﻿USE sofia;
DROP TABLE IF EXISTS sofia.aeu_vpl;
CREATE TABLE aeu_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aeu_vpl WRITE;
INSERT INTO aeu_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","هَاذَا نْسَبْ يَسُوعْ المَسِيحْ وِلْدْ دَاوِدْ وِلْدْ إِبْرَاهِيمْ: ");
INSERT INTO aeu_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","إِبْرَاهِيمْ جَابْ إِسْحَاقْ. وإِسْحَاقْ جَابْ يَعْقُوبْ. ويَعْقُوبْ جَابْ يَهُوذَا وخْوَاتُو. ");
INSERT INTO aeu_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ويَهُوذَا جَابْ فَارِصْ وزَارَحْ مِنْ ثَامَارْ. وفَارِصْ جَابْ حَصْرُونْ. وحَصْرُونْ جَابْ أَرَامْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","وأَرَامْ جَابْ عَمِّينَادَابْ. وعَمِّينَادَابْ جَابْ نَحْشُونْ. ونَحْشُونْ جَابْ سَلْمُونْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","وسَلْمُونْ جَابْ بُوعَزْ مِنْ رَاحَابْ. وبُوعَزْ جَابْ عُوبِيدْ مِنْ رَاعُوثْ. وعُوبِيدْ جَابْ يَسَّى. ");
INSERT INTO aeu_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ويَسَّى جَابْ المَلِكْ دَاوِدْ. ودَاوِدْ جَابْ سُلَيْمَانْ مِالمْرَا الِّي كَانْ مَاخِذْهَا أُورِيَّا. ");
INSERT INTO aeu_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","وسُلَيْمَانْ جَابْ رَحَبْعَامْ. ورَحَبْعَامْ جَابْ أَبِيَّا. وأَبِيَّا جَابْ آسَا. ");
INSERT INTO aeu_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","وآسَا جَابْ يَهُوشَافَاطْ. ويَهُوشَافَاطْ جَابْ يُورَامْ. ويُورَامْ جَابْ عُزِّيَّا. ");
INSERT INTO aeu_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","وعُزِّيَّا جَابْ يُوثَامْ. ويُوثَامْ جَابْ أَحَازْ. وأَحَازْ جَابْ حِزْقِيَّا. ");
INSERT INTO aeu_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","وحِزْقِيَّا جَابْ مَنَسَّى. ومَنَسَّى جَابْ آمُونْ. وآمُونْ جَابْ يُوشِيَّا. ");
INSERT INTO aeu_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ويُوشِيَّا جَابْ يَكُنْيَا وخْوَاتُو، وَقْتِلِّي كَانُوا يِسْبِيوْ فِي اليْهُودْ لْبَابِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","وبَعْدْمَا سْبَاوْهُمْ لْبَابِلْ، يَكُنْيَا جَابْ شَأَلْتِئِيلْ. وشَأَلْتِئِيلْ جَابْ زَرُبَّابِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","وزَرُبَّابِلْ جَابْ أَبِيهُودْ. وأَبِيهُودْ جَابْ أَلِيَاقِيمْ. وأَلِيَاقِيمْ جَابْ عَازُورْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","وعَازُورْ جَابْ صَادُوقْ. وصَادُوقْ جَابْ أَخِيمْ. وأَخِيمْ جَابْ أَلِيُودْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","وأَلِيُودْ جَابْ أَلِيعَازَرْ. وأَلِيعَازَرْ جَابْ مَتَّانْ. ومَتَّانْ جَابْ يَعْقُوبْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ويَعْقُوبْ جَابْ يُوسِفْ رَاجِلْ مَرْيِمْ الِّي وِلْدِتْ يَسُوعْ الِّي يْعَيْطُولُو المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","وهَكَّا نَلْقَاوْ 14 جِيلْ مِنْ إِبْرَاهِيمْ حَتَّى لْدَاوِدْ، و14 جِيلْ مِنْ دَاوِدْ حَتَّى لِينْ تِسْبَاوْ اليْهُودْ لْبَابِلْ، و14 جِيلْ مِلِّي تِسْبَاوْ حَتَّى لِينْ جَاء المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","وهَاوْ كِيفَاشْ تُولِدْ يَسُوعْ المَسِيحْ: كَانِتْ أُمُّو مَرْيِمْ مَخْطُوبَة لْرَاجِلْ إِسْمُو يُوسِفْ. وقْبَلْ مَا يْعَرْسُوا، ظْهُرْ الِّي هِيَّ حِبْلَى بْقُوِّةْ الرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","وعْلَى خَاطِرْ يُوسِفْ كَانْ رَاجِلْ صَالَحْ، قَرِّرْ يِبْعِدْ عْلِيهَا فِي السِّرْ، مِنْ غِيرْ مَا يِفْضَحْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","وهُوَّ مَزَّالْ يْخَمِّمْ فِي الحْكَايَة، ظْهُرْلُو مَلَاكْ مِنْ عَنْدْ الرَّبْ فِي المْنَامْ، وقَالُّو: «يَا يُوسِفْ وِلْدْ دَاوِدْ، مَا تْخَافِشْ إِنِّكْ تْعَرِّسْ بْمَرْيِمْ، عْلَى خَاطِرْ الِّي حِبْلَى بِيهْ هُوَّ مِالرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","وبِشْ تْجِيبْ وْلَيِّدْ، وإِنْتِ تْسَمِّيهْ يَسُوعْ، عْلَى خَاطْرُو بِشْ يْنَجِّي شَعْبُو مِنْ ذْنُوبْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","وهَاذَا الكُلْ صَارْ بَاشْ يِتْحَقَّقْ الِّي قَالُو الرَّبْ عْلَى طْرِيقْ النَّبِيْ: ");
INSERT INTO aeu_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","«الصْبِيَّة تِحْبِلْ، وتْجِيبْ طْفُلْ، يِتْسَمَّى عِمَّانُوئِيلْ!» (الِّي تَفْسِيرُو: اللَّهْ مْعَانَا). ");
INSERT INTO aeu_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ووَقْتِلِّي فَاقْ يُوسِفْ مِالنُّومْ، عْمَلْ كِيمَا قَالُّو المَلَاكْ، ورَوَّحْ بْمَرْتُو لْدَارُو، ");
INSERT INTO aeu_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","آمَا مَا مَسْهَاشْ حَتَّى لِينْ جَابِتْ الطْفُلْ، وسَمَّاهْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ووَقْتِلِّي تُولِدْ يَسُوعْ فِي بَيْتْ لَحْمْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة، فِي عَهْدْ المَلِكْ هِيرُودُسْ، جَاوْ جْمَاعَة حُكَمَاءْ مِالشَّرْقْ لْأُورْشَلِيمْ، ");
INSERT INTO aeu_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","وسِأْلُوا: «وِينُو مَلِكْ اليْهُودْ الِّي تُولِدْ؟ رَانَا شُفْنَا نِجْمْتُو فِي الشَّرْقْ، وجِينَا بَاشْ نُسْجْدُولُو». ");
INSERT INTO aeu_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","وكِي سْمَعْ المَلِكْ هِيرُودُسْ الحْكَايَة هَاذِي، دْخَلْ بَعْضُو هُوَّ وأُورْشَلِيمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","يَاخِي لَمْ كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة الكُلْ وسْإِلْهُمْ: «وِينْ يِتُوْلِدْ المَسِيحْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","جَاوْبُوهْ: «فِي بَيْتْ لَحْمْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة، عْلَى خَاطِرْ هَاذَا الِّي كِتْبُو النَّبِيْ: ");
INSERT INTO aeu_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","وإِنْتِ يَا بَيْتْ لَحْمْ الِّي فِي أَرْضْ يَهُوذَا، مَاكِشْ مَحْقُورَة بِينْ حُكَّامْ يَهُوذَا، عْلَى خَاطِرْ مِنِّكْ يِطْلَعْ حَاكِمْ، يَرْعَى شَعْبِي بَنِي إِسْرَائِيلْ». ");
INSERT INTO aeu_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","وَلَّى هِيرُودُسْ عَيِّطْ لِلْحُكَمَاءْ فِي السِّرْ، وثَبِّتْ مِنْهُمْ وَقْتَاشْ بِالضَّبْطْ ظُهْرِتْ النِّجْمَة، ");
INSERT INTO aeu_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ومْبَعِّدْ بْعَثْهُمْ لْبَيْتْ لَحْمْ وقَالِلْهُمْ: «إِمْشِيوْ لَوْجُوا بِالڨْدَا عَالطْفُلْ. وكِي تَلْقَاوَهْ، إِيجَاوْ خَبْرُونِي بَاشْ نِمْشِي حَتَّى آنَا نُسْجُدْلُو». ");
INSERT INTO aeu_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","بَعْدْمَا سَمْعُوا كْلَامْ المَلِكْ مْشَاوْ. وهُومَا فِي الطْرِيقْ، إِذَا بِيهَا النِّجْمَة الِّي شَافُوهَا قْبَلْ فِي الشَّرْقْ قَاعْدَة تِمْشِي قُدَّامْهُمْ حَتَّى لِينْ وِقْفِتْ فُوقْ البْلَاصَة الِّي مَوْجُودْ فِيهَا الطْفُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ووَقْتِلِّي شَافُوا النِّجْمَة فَرْحُوا فَرْحَة كْبِيرَة. ");
INSERT INTO aeu_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ودَخْلُوا لِلدَّارْ ولْقَاوْ الطْفُلْ مْعَ أُمُّو مَرْيِمْ. وهَبْطُوا عْلَى رْكَايِبْهُمْ وسِجْدُولُو، وحَلُّوا صْنَادِقْهُمْ وهْدَاوْلُو ذْهَبْ وبْخُورْ ولُوبَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ونَبَّهُّمْ اللَّهْ فِي المْنَامْ بَاشْ مَا يِرْجْعُوشْ لْهِيرُودُسْ، وَلَّاوْ جَابُوا طْرِيقْ آخِرْ ورَوْحُوا لِبْلَادْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","وبَعْدْمَا رَوْحُوا الحُكَمَاءْ، ظْهُرْ مَلَاكْ مِنْ عَنْدْ الرَّبْ لْيُوسِفْ فِي المْنَامْ وقَالُّو: «قُومْ! هِزْ الطْفُلْ وأُمُّو وأُهْرُبْ لْمَصْرْ، وإِبْقَى غَادِي حَتَّى لِينْ نْقُلِّكْ وَقْتَاشْ تِرْجَعْ، عْلَى خَاطِرْ هِيرُودُسْ نَاوِي يْلَوِّجْ عْلِيهْ ويُقْتْلُو». ");
INSERT INTO aeu_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","وفِي نَفْسْ اللِّيلَة قَامْ يُوسِفْ وهَزْ الطْفُلْ وأُمُّو ومْشَى لْمَصْرْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","وبْقَى فِيهَا حَتَّى لِينْ مَاتْ هِيرُودُسْ، وهَكَّا صَارْ الِّي قَالُو الرَّبْ عْلَى طْرِيقْ النَّبِيْ: «عَيَّطْتْ لْإِبْنِي مِنْ مَصْرْ». ");
INSERT INTO aeu_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","وكِي فْهِمْ هِيرُودُسْ الِّي الحُكَمَاءْ تْمَسْخْرُوا عْلِيهْ، تْغَشِّشْ عَالإِخِّرْ وعْطَى أَمْرْ بَاشْ يُقْتْلُوا الصْغَارْ الكُلْ الِّي فِي بَيْتْ لَحْمْ والبْلَايِصْ الدَّايْرَة بِيهَا الِّي عْمَارْهُمْ عَامِينْ وأَقَلْ، بْحَسْبْ الوَقْتْ الِّي قَالُولُو عْلِيهْ الحُكَمَاءْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","وهَكَّا صَارْ الِّي قَالُو النَّبِيْ إِرْمِيَا: ");
INSERT INTO aeu_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","«فِي مْدِينِةْ الرَّامَة سَمْعُوا صْيَاحْ، وبَرْشَة بْكَى ونْوَاحْ، رَاحِيلْ تِبْكِي عْلَى وْلَادْهَا، ومَا تْحِبِّشْ تْبَطِّلْ الحُزْنْ عْلَى خَاطِرْهُمْ مَاتُوا». ");
INSERT INTO aeu_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","وبَعْدْمَا مَاتْ هِيرُودُسْ، ظْهُرْ مَلَاكْ مِنْ عَنْدْ الرَّبْ لْيُوسِفْ فِي المْنَامْ وهُوَّ فِي مَصْرْ، ");
INSERT INTO aeu_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","وقَالُّو: «قُومْ! هِزْ الطْفُلْ وأُمُّو وإِرْجَعْ لْأَرْضْ إِسْرَائِيلْ، عْلَى خَاطِرْ الِّي حَبُّوا يُقْتْلُوهْ مَاتُوا». ");
INSERT INTO aeu_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","يَاخِي قَامْ وهَزْ الطْفُلْ وأُمُّو ورْجَعْ لْأَرْضْ إِسْرَائِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","آمَا كِي سْمَعْ الِّي أَرْخِيلَاوُسْ وَلَّى مَلِكْ عْلَى مَنْطَقْةْ اليَهُودِيَّة فِي بْلَاصِةْ بُوهْ هِيرُودُسْ، خَافْ بِشْ يِمْشِيلْهَا. يَاخِي نَبْهُو اللَّهْ فِي المْنَامْ، وَلَّى مْشَى لْمَنْطَقْةْ الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","وسِكْنُوا فِي مْدِينَة إِسْمْهَا النَّاصْرَة، بَاشْ يْصِيرْ الِّي تْقَالْ فِي كْتُبْ الأَنْبِيَاءْ بِشْ يْعَيْطُولُو نَاصْرِي. ");
INSERT INTO aeu_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","وفِي الزْمَانْ هَاذَاكَا، بْدَا يُوحَنَّا الِّي يْعَمِّدْ يْبَشِّرْ فِي خْلَاء مَنْطَقْةْ اليَهُودِيَّة ");
INSERT INTO aeu_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ويْقُولْ: «تُوبُوا، رَاهِي مَمْلَكْةْ السْمَاوَاتْ قُرْبِتْ!». ");
INSERT INTO aeu_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ويُوحَنَّا هَاذَا هُوَّ الِّي حْكَى عْلِيهْ النَّبِيْ إِشَعْيَاءْ كِي قَالْ: «صُوتْ يْعَيِّطْ فِي الخْلَاء: حَضّْرُوا طْرِيقْ الرَّبْ، إِسْتْوِيوْ الثْنِيَّة قُدَّامُو!». ");
INSERT INTO aeu_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","وكَانْ يُوحَنَّا لَابِسْ لِبْسَة مِنْ وْبَرْ الجْمَالْ، ومِتْحَزِّمْ بِحْزَامْ جِلْدْ، ويَاكِلْ فِي الجْرَادْ والعْسَلْ الجَّالِي. ");
INSERT INTO aeu_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","وكَانُوا النَّاسْ يِمْشِيوْلُو مِنْ أُورْشَلِيمْ ومَنْطَقْةْ اليَهُودِيَّة الكُلْ والبْلَايِصْ الِّي بَحْذَا وَادْ الأُرْدُنْ، ");
INSERT INTO aeu_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","بَاشْ يَعْتَرْفُوا بِذْنُوبْهُمْ، وهُوَّ يْعَمِّدْهُمْ فِي وَادْ الأُرْدُنْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ووَقْتِلِّي شَافْ بَرْشَة فِرِّيسِيِّينْ وصَدُّوقِيِّينْ جَايِّينُو بَاشْ يْعَمِّدْهُمْ، قَالِلْهُمْ: «يَا وْلَادْ الأَفَاعِي! شْكُونْ الِّي عَلَّمْكُمْ تُهْرْبُوا مِنْ غَضَبْ اللَّهْ الِّي بِشْ يْجِي؟ ");
INSERT INTO aeu_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","أَعْمْلُوا أَعْمَالْ تْوَرِّي الِّي إِنْتُومَا تُبْتُوا بِالحَقْ، ");
INSERT INTO aeu_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ومَا تْقُولُوشْ فِي قْلُوبْكُمْ: \"أَحْنَا وْلَادْ إِبْرَاهِيمْ\"، عْلَى خَاطِرْ آنَا نْقُلْكُمْ إِنُّو اللَّهْ قَادِرْ يَعْمِلْ مِالحْجَرْ هَاذَا وْلَادْ لْإِبْرَاهِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","هَاوْ الفَاسْ مِنْ تَوَّا حَاضِرْ بَاشْ يْقُصْ الشْجَرْ مِنْ عْرُوقُو، والشَّجْرَة الِّي مَا تْجِيبِشْ غَلَّة بَاهْيَة تِتْقَصْ وتِتْرْمَى فِي النَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","آنَا نْعَمِّدْكُمْ بِالمَاء كِي اتُّوبُوا، آمَا الِّي بِشْ يْجِي بَعْدِي رَاهُو أَقْوَى مِنِّي، وآنَا مَا نِسْتَاهِلْشْ حَتَّى نْهِزْلُو صَنْدَالُو. هُوَّ بِشْ يْعَمِّدْكُمْ بِالرُّوحْ القُدُسْ والنَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ويْهِزْ المَذْرَى فِي يِدُّو ويِفْرِزْ صَابْتُو، يْلِمْ القَمْحْ فِي المَخْزِنْ، آمَا التْبِنْ يَحْرْقُو بْنَارْ مَا تِطْفَاشْ». ");
INSERT INTO aeu_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","فِي الوَقْتْ هَاذَاكَا جَاء يَسُوعْ مِنْ مَنْطَقْةْ الجَلِيلْ لْوَادْ الأُرْدُنْ، ومْشَى لْيُوحَنَّا بَاشْ يِتْعَمِّدْ عْلَى يْدِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","آمَا يُوحَنَّا مَا خَلَّاهِشْ وقَالُّو: «آنَا هُوَّ الِّي مِسْتْحَقْ نْجِيكْ تْعَمِّدْنِي، كِيفَاشْ إِنْتِ الِّي تْجِينِي؟» ");
INSERT INTO aeu_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","يَاخِي جَاوْبُو يَسُوعْ: «خَلِّي هَاذَا يْصِيرْ تَوَّا، عْلَى خَاطِرْ هَكَّا نْتَمْمُوا كُلْ مَاهُو صَالَحْ». يَاخِي وَافْقُو يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","وبِالوَقْتْ بَعْدْمَا تْعَمِّدْ يَسُوعْ وخْرَجْ مِالمَاء، تْحَلِّتْلُو السْمَاء، وشَافْ رُوحْ اللَّهْ هَابِطْ كِالحْمَامَة وحَطْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","وإِذَا بِيهْ صُوتْ مِالسْمَاء يْقُولْ: «هَاذَا هُوَّ إِبْنِي الِّي نْحِبُّو ولِّي آنَا فَرْحَانْ بِيهْ». ");
INSERT INTO aeu_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","وهَزْ الرُّوحْ القُدُسْ يَسُوعْ لِلْخْلَاء بَاشْ إِبْلِيسْ يْجَرْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","وبَعْدْمَا صَامْ 40 يُومْ و40 لِيلَة، جَاعْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","قْرُبْلُو إِبْلِيسْ الِّي يْجَرِّبْ وقَالُّو: «كَانِكْ إِنْتِ إِبْنْ اللَّهْ، قُولْ لِلْحْجَرْ هَاذَا يْوَلِّي خُبْزْ». ");
INSERT INTO aeu_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","يَاخِي جَاوْبُو يَسُوعْ: «مَكْتُوبْ فِي الكْتُبْ المُقَدْسَة: \"الإِنْسَانْ مَا يْعِيشِشْ كَانْ بِالخُبْزْ، آمَا يْعِيشْ بْكُلْ كِلْمَة تُخْرُجْ مِنْ فُمْ اللَّهْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","وهَزُّو إِبْلِيسْ لِلْمْدِينَة المُقَدْسَة، ووَقْفُو عْلَى حَرْفْ أَعْلَى بْلَاصَة فِي الهَيْكِلْ، ");
INSERT INTO aeu_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","وقَالُّو: «كَانِكْ إِنْتِ إِبْنْ اللَّهْ إِرْمِي رُوحِكْ مِنْ فُوقْ، عْلَى خَاطِرْ مَكْتُوبْ: \"يْوَصِّي عْلِيكْ مْلَايِكْتُو\"، \"وهُومَا يْهِزُّوكْ عْلَى يْدِيهُمْ بَاشْ سَاقِيكْ مَا تِتْضْرَبْشْ فِي حَجْرَة\"». ");
INSERT INTO aeu_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","جَاوْبُو يَسُوعْ: «مَكْتُوبْ زَادَا: \"مَا تْجَرَّبْشْ الرَّبْ إِلَاهِكْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ومْبَعِّدْ هَزُّو إِبْلِيسْ فُوقْ جْبَلْ عَالِي بَرْشَة، ووَرَّاهْ مَمَالِكْ الدِّنْيَا الكُلْ والحَاجَاتْ العْظِيمَة الِّي فِيهَا، ");
INSERT INTO aeu_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","وقَالُّو: «نَعْطِيكْ هَاذَا الكُلْ، إِذَا كَانْ تَهْبِطْ عْلَى رْكَايْبِكْ وتِسْجِدْلِي». ");
INSERT INTO aeu_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","يَاخِي جَاوْبُو يَسُوعْ: «إِبْعِدْ عْلِيَّا يَا شِيطَانْ! عْلَى خَاطِرْ مَكْتُوبْ فِي الكْتُبْ المُقَدْسَة: \"إِسْجِدْ لِلرَّبْ إِلَاهِكْ، واعْبْدُو هُوَّ وَحْدُو\"». ");
INSERT INTO aeu_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","وَلَّى إِبْلِيسْ بْعِدْ عْلِيهْ، وجَاتْ المْلَايْكَة وبْدَاتْ تِخْدِمْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","وكِي سْمَعْ يَسُوعْ الِّي يُوحَنَّا تْشَدْ فِي الحَبْسْ، رْجَعْ لْمَنْطَقْةْ الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","وخْرَجْ مِنْ مْدِينِةْ النَّاصْرَة ومْشَى سْكِنْ فِي كَفْرْنَاحُومْ الِّي عْلَى شَطْ البُحَيْرَة المَوْجُودَة فِي أَرْضْ زَبُولُونْ ونَفْتَالِي، ");
INSERT INTO aeu_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","بَاشْ يِتْحَقَّقْ الِّي قَالُو النَّبِيْ إِشَعْيَاءْ: ");
INSERT INTO aeu_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","«أَرْضْ نَفْتَالِي وأَرْضْ زَبُولُونْ، عْلَى ثْنِيِّةْ البُحَيْرَة فِي غَرْبْ وَادْ الأُرْدُنْ، أَرْضْ الجَلِيلْ العَايْشِينْ فِيهَا الِّي مَاهُمْشْ يْهُودْ! ");
INSERT INTO aeu_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","الشَّعْبْ العَايِشْ فِي الظْلَامْ شَافْ نُورْ عْظِيمْ، والنُّورْ ضْوَى عَلِّي عَايْشِينْ فِي أَرْضْ المُوتْ وظِلُّو». ");
INSERT INTO aeu_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ومِنْ وَقْتْهَا بْدَا يَسُوعْ يْبَشِّرْ ويْقُولْ: «تُوبُوا، رَاهِي مَمْلَكْةْ السْمَاوَاتْ قُرْبِتْ». ");
INSERT INTO aeu_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","وَقْتِلِّي كَانْ يَسُوعْ يِمْشِي عْلَى شَطْ بُحَيْرِةْ الجَلِيلْ، شَافْ زُوزْ صَيَّادَة خْوَاتْ يَرْمِيوْ فِي شَبْكَة فِي البُحَيْرَة، وهُومَا سِمْعَانْ الِّي يْعَيْطُولُو بُطْرُسْ وخُوهْ أَنْدَرَاوُسْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","قَالِلْهُمْ: «تَبْعُونِي وآنَا نْرُدْكُمْ صَيَّادِةْ نَاسْ». ");
INSERT INTO aeu_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","وبِالوَقْتْ خَلَّاوْ شْبَاكْهُمْ وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","وهُوَّ مْكَمِّلْ فِي ثْنِيْتُو، شَافْ زُوزْ أَخْوَة أُخْرِينْ، الِّي هُومَا يَعْقُوبْ وِلْدْ زَبَدِي وخُوهْ يُوحَنَّا، وكَانُوا فِي الفْلُوكَة مْعَ بُوهُمْ يْصَلْحُوا فِي شْبَاكْهُمْ، يَاخِي عَيْطِلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","وبِالوَقْتْ خَلَّاوْ الفْلُوكَة وبُوهُمْ وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","وكَانْ يَسُوعْ يْدُورْ فِي مَنْطَقْةْ الجَلِيلْ الكُلْ يْعَلِّمْ فِي وِسْطْ مْعَابِدْ اليْهُودْ، ويْخَبِّرْ بِبْشَارِةْ مَمْلَكْةْ السْمَاوَاتْ، ويِشْفِي النَّاسْ مِنْ كُلْ مَرْضْ ودَاء. ");
INSERT INTO aeu_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","وسَمْعُوا بِيهْ فِي سُورْيَا الكُلْ. وجَابُولُو المُرْضَى بْكُلْ أَنْوَاعْهُمْ، والمَسْكُونِينْ بِالشْوَاطِنْ والمَصْرُوعِينْ والمَشْلُولِينْ، يَاخِي شْفَاهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","وتَبْعُوهْ بَرْشَة نَاسْ مِالجَلِيلْ ومِنْ مَنْطَقْةْ المُدُنْ العَشْرْ وأُورْشَلِيمْ ومَنْطَقْةْ اليَهُودِيَّة ومِنْ شَرْقْ الأُرْدُنْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","وكِي شَافْ يَسُوعْ النَّاسْ طْلَعْ لِلجْبَلْ، ودُوبْ مَا قْعَدْ، قُرْبُولُو تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","وبْدَا يْعَلِّمْ فِيهُمْ، وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«صَحَّة لِيهُمْ الِّي يِعْتَرْفُوا بْضُعْفْهُمْ الرُّوحِي! عْلَى خَاطِرْ مَمْلَكْةْ السْمَاوَاتْ لِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","صَحَّة لِيهُمْ الحْزَانَى، خَاطِرْهُمْ بِشْ يِتْعَزَّاوْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","صَحَّة لِيهُمْ المُسَالْمِينْ! خَاطِرْهُمْ بِشْ يُورْثُوا الأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","صَحَّة لِيهُمْ الجْوَاعَى والعُطْشَانِينْ لِلصَّلَاحْ! رَاهُمْ بِشْ يِشْبْعُوا. ");
INSERT INTO aeu_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","صَحَّة لِيهُمْ الِّي يَرْحْمُوا! خَاطِرْهُمْ بِشْ يِتْرَحْمُوا. ");
INSERT INTO aeu_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","صَحَّة لِيهُمْ الِّي قْلُوبْهُمْ صَافْيَة! عْلَى خَاطِرْهُمْ بِشْ يْشُوفُوا اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","صَحَّة لِيهُمْ الِّي يَعْمْلُوا السَّلَامْ! عْلَى خَاطِرْهُمْ بِشْ يِتْسَمَّاوْ وْلَادْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","صَحَّة لِيهُمْ الِّي يِضْطَهْدُوهُمْ بِسْبَبْ الصَّلَاحْ! عْلَى خَاطِرْ مَمْلَكْةْ السْمَاوَاتْ لِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","«صَحَّة لِيكُمْ كَانْ عْلَى خَاطْرِي عَايْرُوكُمْ واضْطَهْدُوكُمْ وقَالُوا عْلِيكُمْ كْلَامْ خَايِبْ بِالكِذْبْ! ");
INSERT INTO aeu_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","إِفْرْحُوا وازْهَاوْ، عْلَى خَاطِرْ أَجْرْكُمْ عْظِيمْ فِي السْمَاء. رَاهُمْ هَكَّا اضْطَهْدُوا الأَنْبِيَاءْ قْبَلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«إِنْتُومَا مِلْحْ الأَرْضْ. وإِذَا كَانْ المِلْحْ ضَيَّعْ مْلُوحِيتُو، بَاشْ بِشْ يِرْجَعْلُو طَعْمُو؟ رَاهُو مَا عَادْ يُصْلُحْ لْحَتَّى شَيْ، كَانْ بَاشْ يِتْرْمَى لْبَرَّا والنَّاسْ يْعَفْسُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","إِنْتُومَا النُّورْ الِّي فِي الدِّنْيَا هَاذِي. مَا فَمَّاشْ مْدِينَة مِبْنِيَّة فُوقْ جْبَلْ ومَا تِتْشَافِشْ، ");
INSERT INTO aeu_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","ومَا فَمَّاشْ وَاحِدْ يْشَعِّلْ فْنَارْ ويْغُمُّو بْطَاسَة، آمَا يْحُطُّو فِي بْلَاصَة عَالْيَة بَاشْ يِضْوِي عَالمَوْجُودِينْ فِي الدَّارْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","وإِنْتُومَا زَادَا خَلِّيوْ نُورْكُمْ يِضْوِي قُدَّامْ النَّاسْ، بَاشْ يْشُوفُوا أَعْمَالْكُمْ الصَّالْحَة، ويْمَجْدُوا بُوكُمْ الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«مَا تْحُطُّوشْ فِي بَالْكُمْ الِّي آنَا جِيتْ بَاشْ نْرُدْ الشَّرِيعَة وكْتُبْ الأَنْبِيَاءْ بَاطْلِينْ، آنَا مَا جِيتِشْ بَاشْ نْرُدْهُمْ بَاطْلِينْ آمَا بَاشْ نْكَمَّلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","نْقُلْكُمْ الحَقْ: مَادَامْ السْمَاء والأَرْضْ مَوْجُودِينْ، مَا يِتْنَحَّى حَتَّى حَرْفْ ولَا حَتَّى نُقْطَة وَحْدَة مِالشَّرِيعَة حَتَّى لِينْ يِكْمِلْ كُلْ شَيْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","الِّي يْخَالِفْ أَصْغِرْ وَحْدَة مِالوْصَايَا هَاذُمْ ويْعَلِّمْ النَّاسْ بَاشْ يَعْمْلُوا كِيفُو، يْكُونْ عَنْدُو أَقَلْ مْقَامْ فِي مَمْلَكْةْ السْمَاوَاتْ. آمَا الِّي يْطِيعْهُمْ ويْعَلِّمْهُمْ، يْكُونْ عَنْدُو مْقَامْ عَالِي فِي مَمْلَكْةْ السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","وآنَا نْقُولِلْكُمْ، إِذَا كَانْ صَلَاحْكُمْ مَا يْفُوتِشْ صَلَاحْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ، رَاهُو عْمُرْكُمْ مَا بِشْ تُدْخْلُوا لْمَمْلَكْةْ السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«سْمَعْتُوا إِنُّو تْقَالْ لِجْدُودْكُمْ: \"مَا تَعْمِلْشْ جْرِيمِةْ قَتْلْ، ولِّي يُقْتُلْ يِلْزْمُو يِتْحَاكِمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","آمَا آنَا نْقُولِلْكُمْ: الِّي يِتْغَشِّشْ عْلَى خُوهْ يِلْزْمُو يِتْحَاكِمْ، ولِّي يْقُولْ لْخُوهْ \"يَا تَافَهْ\"، يِتْعَدَّى عَالمَجْلِسْ الأَعْلَى، ولِّي يْقُلُّو \"يَا بْهِيمْ\"، يِسْتَاهِلْ نَارْ جْهَنِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","مَالَا كِي تَبْدَى جَايِبْ قُرْبَانِكْ لِلْمَذْبَحْ وتْذَكَّرْتْ وَقْتْهَا الِّي خُوكْ عَنْدُو حَاجَة ضِدِّكْ، ");
INSERT INTO aeu_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","خَلِّي قُرْبَانِكْ قُدَّامْ المَذْبَحْ، وإِمْشِي اتْصَالَحْ مْعَ خُوكْ قْبَلْ، ومْبَعِّدْ إِيجَا أَعْطِي قُرْبَانِكْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","حَاوِلْ فِيسَعْ تْرَاضِي وَاحِدْ عَنْدُو مُشْكْلَة مْعَاكْ مَادَامْكُمْ فِي طْرِيقْكُمْ لِلْمَحْكْمَة، بَاشْ مَا يْهِزِّكْشْ لِلْقَاضِي والقَاضِي يْسَلْمِكْ لِلْحَاكِمْ، وتِتِّرْمَى فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","نْقُلِّكْ الحَقْ: مَاكِشْ بِشْ تُخْرُجْ مِنْ غَادِي حَتَّى لِينْ تْخَلِّصْ آخِرْ فْرَنْكْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«سْمَعْتُوا إِنُّو تْقَالْ: \"مَا تَزْنَاشْ\". ");
INSERT INTO aeu_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","آمَا آنَا نْقُولِلْكُمْ: الِّي يُخْزُرْ لِمْرَا بْشَهْوَة، رَاهُو زْنَى بِيهَا فِي قَلْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","إِذَا كَانْ عِينِكْ اليْمِينْ تْخَلِّيكْ تُغْلُطْ، قَلَّعْهَا وإِرْمِيهَا، تَخْسِرْ قَطْعَة مِنْ بَدْنِكْ خِيرْ مِلِّي بَدْنِكْ الكُلْ يِتْرْمَى فِي جْهَنِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","وإِذَا كَانْ يِدِّكْ اليْمِينْ تْخَلِّيكْ تُغْلُطْ، قُصْهَا وإِرْمِيهَا، تَخْسِرْ قَطْعَة مِنْ بَدْنِكْ خِيرْ مِلِّي بَدْنِكْ الكُلْ يِتْرْمَى فِي جْهَنِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«وتْقَالْ زَادَا: \"الِّي يْطَلَّقْ مَرْتُو، لَازِمْ يَعْطِيهَا وَرْقِةْ الطْلَاقْ\". ");
INSERT INTO aeu_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","آمَا آنَا نْقُولِلْكُمْ: الِّي يْطَلَّقْ مَرْتُو بْأَيْ سْبَبْ بِخْلَافْ الزْنَى، رَاهُو يْخَلِّيهَا عُرْضَة لِلزْنَى، ولِّي يْعَرِّسْ بِمْرَا مْطَلْقَة هُوَّ قَاعِدْ يَزْنَى. ");
INSERT INTO aeu_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«وسْمَعْتُوا زَادَا إِنُّو تْقَالْ لِجْدُودْكُمْ: \"مَا تِحْلِفْشْ وتِخْلِفْ، آمَا كَانْ وعِدْتْ الرَّبْ بْحَاجَة أُصْدُقْ فِيهَا\". ");
INSERT INTO aeu_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","آمَا آنَا نْقُولِلْكُمْ: مَا تِحْلْفُوشْ بِالكُلْ، لَا بِالسْمَاء عْلَى خَاطِرْهَا عَرْشْ اللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ولَا بِالأَرْضْ خَاطِرْهَا مَسْنِدْ سَاقِيهْ، ولَا بْأُورْشَلِيمْ خَاطِرْهَا مْدِينِةْ المَلِكْ العْظِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ومَا تِحْلِفْشْ بْرَاسِكْ، عْلَى خَاطِرْ مَا تْنَجَّمْشْ تْرُدْ حَتَّى شَعْرَة فِيهْ بِيضَة وَلَّا كَحْلَة. ");
INSERT INTO aeu_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","قُولُوا إِيْ إِذَا كَانْ تُقْصْدُوا إِيْ، ولَا كَانْ تُقْصْدُوا لَا، وكُلْ حَاجَة زَايْدَة عْلَى هَاذَا رَاهِي مِالشِّرِّيرْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«سْمَعْتُوا إِنُّو تْقَالْ: \"العِينْ بِالعِينْ والسِّنَّة بِالسِّنَّة\". ");
INSERT INTO aeu_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","آمَا آنَا نْقُولِلْكُمْ: مَا تْرُدُّوشْ عَالشَّرْ بِالشَّرْ. آمَا كَانْ وَاحِدْ ضَرْبِكْ عْلَى خَدِّكْ اليْمِينْ دَوَّرْلُو خَدِّكْ الآخِرْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ولِّي يْحِبْ يِشْكِي بِيكْ بَاشْ يَاخُذْلِكْ جِبْتِكْ، كَمِّلْ خَلِّيلُو بَرْنُوسِكْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ولِّي يْخَلِّيكْ تِمْشِي مْعَاهْ كِيلُومَاتِرْ بِالسِّيفْ عْلِيكْ، إِمْشِي مْعَاهْ زُوزْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","الِّي يُطْلُبْ مِنْ عَنْدِكْ حَاجَة أَعْطِيهَالُو، ولِّي يْحِبْ يِتْسَلَّفْ مِنْ عَنْدِكْ مَا تْرُدُّوشْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«سْمَعْتُوا إِنُّو تْقَالْ: \"حِبْ قْرِيبِكْ وإِكْرَهْ عْدُوكْ\". ");
INSERT INTO aeu_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","آمَا آنَا نْقُولِلْكُمْ: حِبُّوا أَعْدَائْكُمْ وبَارْكُوا الِّي يِلْعْنُوكُمْ وأَعْمْلُوا الخِيرْ لِلِّي يِكْرْهُوكُمْ وصَلِّيوْ لِلِّي يِضْطَهْدُوكُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","وهَكَّا تْكُونُوا وْلَادْ بُوكُمْ الِّي فِي السْمَاء. عْلَى خَاطْرُو يْضَوِّي بْشَمْسُو عَالبَاهِينْ والخَايْبِينْ، ويَعْطِي المْطَرْ لِلصَّالْحِينْ والطَّالْحِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","شْنُوَّة أَجْرْكُمْ وَقْتِلِّي مَا تْحِبُّوا كَانْ الِّي يْحِبُّوكُمْ؟ يَاخِي مُشْ المَكَّاسَة يَعْمْلُوا نَفْسْ الشَّيْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ووَقْتِلِّي مَا تْسَلْمُوا كَانْ عْلَى خْوَاتْكُمْ، شْنِيَّة الحَاجَة الزَّايْدَة الِّي عْمَلْتُوهَا؟ يَاخِي مُشْ هَكَّا زَادَا يَعْمْلُوا الِّي مَاهُمْشْ يْهُودْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","مَالَا كُونُوا كَامْلِينْ، كِيمَا بُوكُمْ الِّي فِي السْمَاء كَامِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«رُدُّوا بَالْكُمْ تَعْمْلُوا الخِيرْ الِّي اللَّهْ يُطْلْبُو مِنْكُمْ بْنِيِّةْ إِنُّو النَّاسْ تْشُوفْكُمْ، مَا كَانِشْ مُشْ بِشْ يْكُونْ لِيكُمْ أَجْرْ عَنْدْ بُوكُمْ الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","وَقْتِلِّي تَعْطِي صَدْقَة، مَا تِبْدَاشْ ادُّورْ وتَحْكِي عْلِيهَا كِيمَا يَعْمْلُوا المُنَافْقِينْ فِي المْعَابِدْ والشْوَارَعْ بَاشْ النَّاسْ يِمْدْحُوهُمْ. نْقُلْكُمْ الحَقْ: رَاهُمْ هَكَّا خْذَاوْ أَجْرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","آمَا إِنْتِ، كِي تَعْطِي صَدْقَة مَا تْخَلِّيشْ يِدِّكْ اليْسَارْ تَعْرِفْ آشْ عَمْلِتْ يِدِّكْ اليْمِينْ، ");
INSERT INTO aeu_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","بَاشْ الصَّدْقَة مْتَاعِكْ تْكُونْ فِي السِّرْ، وبُوكْ الِّي يْرَى الِّي يْصِيرْ فِي السِّرْ يْجَازِيكْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","«ووَقْتِلِّي تْصَلِّيوْ، مَا تْكُونُوشْ كِي المُنَافْقِينْ، الِّي يْحِبُّوا يْصَلِّيوْ وَاقْفِينْ فِي المْعَابِدْ وفِي مَفْرَقْ الشْوَارَعْ الكْبِيرَة بَاشْ النَّاسْ تْشُوفْهُمْ. نْقُلْكُمْ الحَقْ: رَاهُمْ هَكَّا خْذَاوْ أَجْرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","آمَا إِنْتِ، وَقْتِلِّي تْصَلِّي، أُدْخُلْ لْبِيتِكْ وسَكِّرْ بَابِكْ وصَلِّي لْبُوكْ الِّي مَا يْرَاهْ حَدْ. وبُوكْ الِّي يْرَى آشْ يْصِيرْ فِي السِّرْ يْجَازِيكْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","«وكِي تْصَلِّيوْ مَا تُقْعْدُوشْ تْعَاوْدُوا فِي الكْلَامْ بِالفَارَغْ كِيمَا الِّي مَاهُمْشْ يْهُودْ، الِّي مَاشِي فِي بَالْهُمْ إِنُّو اللَّهْ يِسْمَعْهُمْ وَقْتِلِّي يْكَثْرُوا مِالكْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","مَا تْكُونُوشْ كِيفْهُمْ، عْلَى خَاطِرْ بُوكُمْ يَعْرِفْ شْنُوَّة تِحْتَاجُوا قْبَلْ حَتَّى مَا تُطْلْبُوا مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","«وهَاوْ كِيفَاشْ يِلْزِمْكُمْ تْصَلِّيوْ: يَا بُونَا الِّي فِي السْمَاء، خَلِّي إِسْمِكْ يِتْقَدِّسْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","خَلِّي مَمْلَكْتِكْ تْجِي، خَلِّي قَصْدِكْ يْصِيرْ عَالأَرْضْ كِيمَا صَايِرْ فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","أَعْطِينَا اليُومْ الخُبْزْ الِّي يْكَفِّينَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","إِغْفْرِلْنَا ذْنُوبْنَا، كِيمَا أَحْنَا نِغْفْرُوا لِلِّي يُغْلْطُوا فِينَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","مَا ادَّخَّلْنَاشْ فِي تَجْرْبَة، آمَا نَجِّينَا مِالشِّرِيرْ. عْلَى خَاطِرْ لِيكْ المُلْكْ والقُوَّة والمَجْدْ، لِلْأَبَدْ. آمِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","«وكَانْ غْفَرْتُوا لِلنَّاسْ أَغْلَاطْهُمْ، يِغْفْرِلْكُمْ بُوكُمْ الِّي فِي السْمَاء أَغْلَاطْكُمْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","آمَا كَانْ مَا تِغْفْرُوشْ لِلنَّاسْ أَغْلَاطْهُمْ، مَا يِغْفْرِلْكُمْشْ بُوكُمْ زَادَا أَغْلَاطْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","«ووَقْتِلِّي تْصُومُوا، مَا تْخَلِّيوِشْ وْجُوهْكُمْ تْبَانْ حْزِينَة كِي المُنَافْقِينْ، الِّي يْكَشْبْرُوا وْجُوهْهُمْ بَاشْ يْوَرِّيوْ لِلنَّاسْ الِّي هُومَا صَايْمِينْ. نْقُلْكُمْ الحَقْ: الِّي يَعْمْلُوا هَكَّا خْذَاوْ أَجْرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","آمَا إِنْتِ، وَقْتِلِّي تْصِيمْ حُطْ عِطْرْ وأَغْسِلْ وِجْهِكْ، ");
INSERT INTO aeu_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","بَاشْ مَا تْظَهَّرْشْ لِلنَّاسْ الِّي إِنْتِ صْايِمْ، آمَا بُوكْ الِّي مَا يْرَاهْ حَدْ يْرَاكْ، وبُوكْ الِّي يْرَى آشْ يْصِيرْ فِي السِّرْ يْجَازِيكْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«مَا تِكْنْزُوشْ لِرْوَاحْكُمْ كْنُوزْ فِي الأَرْضْ وِينْ يْنَجِّمْ يْفَسَّدْهَا السُّوسْ والصْدِيدْ، ووِينْ يْنَجْمُوا يَحْفْرُوا عْلِيهَا السُّرَّاقْ ويِسْرْقُوهَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","آمَا إِكْنْزُوا لِرْوَاحْكُمْ كْنُوزْ فِي السْمَاء، وِينْ لَا يْنَجِّمْ يْفَسَّدْهَا لَا السُّوسْ ولَا الصْدِيدْ، ولَا يْنَجْمُوا يَحْفْرُوا عْلِيهَا السُّرَّاقْ ويِسْرْقُوهَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","عْلَى خَاطِرْ وِينْ يْكُونْ كَنْزِكْ يْكُونْ قَلْبِكْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«العِينْ هِيَّ فْنَارْ البْدَنْ. كَانْ عِينِكْ لَابَاسْ، بَدْنِكْ الكُلْ بِشْ يْكُونْ مْنَوِّرْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","آمَا إِذَا كَانْ عِينِكْ شِرِّيرَة، بَدْنِكْ الكُلْ بِشْ يْكُونْ مْظَلِّمْ. إِذَا كَانْ النُّورْ الِّي فِيكْ ظْلَامْ، مَالَا قَدَّاشْ قْوِيْ الظْلَامْ الِّي فِيكْ! ");
INSERT INTO aeu_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«حَتَّى وَاحِدْ مَا يْنَجِّمْ يِخْدِمْ زُوزْ أَسْيَادْ، يَا إِمَّا بِشْ يِكْرَهْ وَاحِدْ ويْحِبْ الآخِرْ، وَلَّا بِشْ يْتَبَّعْ وَاحِدْ ويَحْقِرْ الآخِرْ. مَا تْنَجْمُوشْ تِخْدْمُوا اللَّهْ والفْلُوسْ مْعَ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","«هَاذَاكَا عْلَاشْ نْقُولِلْكُمْ: مَا تْعِيشُوشْ وإِنْتُومَا تْخَمُّوا كَانْ فِي شْنُوَّة بِشْ تَاكْلُوا وشْنُوَّة بِشْ تُشْرْبُوا، ولَا فِي شْنُوَّة بِشْ تِلْبْسُوا. يَاخِي هِيَّ الحَيَاةْ لِلْمَاكْلَة أَكَهَوْ، والبْدَنْ لِلِّبْسَة أَكَهَوْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","شُوفُوا العْصَافِرْ كِيفَاشْ لَا تَزْرَعْ ولَا تَحْصِدْ ولَا تْحُطْ فِي مْخَازِنْ، وبُوكُمْ الِّي فِي السْمَاء يُرْزُقْهَا. يَاخِي مُشْ إِنْتُومَا أَهَمْ مِنْهَا إِبَّرْشَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","وشْكُونْ فِيكُمْ الِّي كِي يْخَمِّمْ بْزَايِدْ يْنَجِّمْ يْزِيدْ فِي عُمْرُو حَتَّى سَاعَة وَحْدَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","وعْلَاشْ تْخَمُّوا بْزَايِدْ فِي اللِّبْسَة؟ ثَبْتُوا فِي نَوَّارْ بُوڨَرْعُونْ كِيفَاشْ يِكْبِرْ، وهُوَّ لَا يِتْعِبْ ولَا يَغْزِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","آمَا آنَا نْقُولِلْكُمْ: حَتَّى المَلِكْ سُلَيْمَانْ فِي عِزُّو مَا لْبِسْشْ كِيفْ وَحْدَة مِنْهُمْ! ");
INSERT INTO aeu_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","إِذَا كَانْ الحْشِيشْ الِّي يِنْبِتْ اليُومْ وغُدْوَة يِتْرْمَى فِي النَّارْ اللَّهْ يْلَبْسُو كِيمَا هَكَّا، مُشْ إِنْتُومَا أَوْلَى إِنُّو يْلَبَّسْكُمْ يَلِّي إِيمَانْكُمْ ضْعِيفْ! ");
INSERT INTO aeu_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","هَاذَاكَا عْلَاشْ مَا تُقْعْدُوشْ تْخَمُّوا وتْقُولُوا: \"شْنُوَّة بِشْ نَاكْلُوا؟\" وَلَّا \"شْنُوَّة بِشْ نُشْرْبُوا؟\" وَلَّا \"شْنُوَّة بِشْ نِلْبْسُوا؟\". ");
INSERT INTO aeu_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","الحَاجَاتْ هَاذِي الكُلْ يِجْرِيوْ وْرَاهَا الِّي مَاهُمْشْ يْهُودْ، آمَا بُوكُمْ الِّي فِي السْمَاء يَعْرِفْ الِّي إِنْتُومَا تَحْتَاجُولْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","مَالَا أَسْعَاوْ فِي الأُوِّلْ لْمَمْلَكْةْ اللَّهْ وصَلَاحُو، والحَاجَاتْ هَاذِي الكُلْ تَوْ تِتْزَادِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","مَا تُقْعْدُوشْ تْخَمُّوا فِي غُدْوَة، خَلِّيوْ غُدْوَة كِيفْ يْجِي يْخَمِّمْ عْلَى رُوحُو. كُلْ نْهَارْ يِكْفِيهْ الشَّرْ الِّي فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«مَا تُحْكْمُوشْ عَالنَّاسْ بَاشْ مَا يِتْحْكَمْشْ عْلِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","كِيمَا تُحْكْمُوا يِتْحْكَمْ عْلِيكُمْ، وبِالكِيلْ الِّي تْكَيْلُوا بِيهْ يِتْكَيْلِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","عْلَاشْ القَشَّة الِّي فِي عِينْ خُوكْ تْشُوفْهَا، واللُّوحَة الِّي فِي عِينِكْ مَا تْشُوفْهَاشْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","وَلَّا كِيفَاشْ تْقُولْ لْخُوكْ: \"خَلِّينِي انَّحِّيلِكْ القَشَّة مِنْ عِينِكْ\" وَقْتِلِّي عِينِكْ إِنْتِ فِيهَا لُوحَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","يَا مُنَافِقْ! نَحِّي اللُّوحَة مِنْ عِينِكْ قْبَلْ، وَقْتْهَا تْوَلِّي تْشُوفْ بِالڨْدَا وتْنَجِّمْ تْنَحِّي القَشَّة مِنْ عِينْ خُوكْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","«مَا تَعْطِيوِشْ الحَاجَاتْ المُقَدْسَة لِلْكْلَابْ، ومَا تَرْمِيوِشْ الجُوهِرْ مْتَاعْكُمْ قُدَّامْ الحْلَالِفْ، بَاشْ مَا يْعَفْسُوهَاشْ بْسَاقِيهُمْ ويْدُورُوا عْلِيكُمْ ويِنْهْشُوكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«أُطْلْبُوا تَاخْذُوا، أَسْعَاوْ تَلْقَاوْ، دُقُّوا البَابْ يِتْحَلِّلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","عْلَى خَاطِرْ الِّي يُطْلُبْ يَاخِذْ، ولِّي يَسْعَى يَلْقَى، ولِّي يْدُقْ البَابْ يِتْحَلُّو. ");
INSERT INTO aeu_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","شْكُونْ فِيكُمْ وَقْتِلِّي يُطْلْبُو وِلْدُو فِي الخُبْزْ يَعْطِيهْ حَجْرَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","وَلَّا يُطْلْبُو فِي حُوتَة يَعْطِيهْ حْنَشْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","إِذَا كَانْ وإِنْتُومَا أَشْرَارْ تَعْرْفُوا تَعْطِيوْ حَاجَاتْ بَاهْيَة لَوْلَادْكُمْ، مُشْ بِالأَوْلَى بُوكُمْ الِّي فِي السْمَاء يَعْطِي حَاجَاتْ بَاهْيَة لِلِّي يُطْلْبُوهْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","«كِيمَا تْحِبُّوا النَّاسْ يْعَامْلُوكُمْ، عَامْلُوهُمْ إِنْتُومَا زَادَا. وهَاذَا يْلَخَّصْ التَّعْلِيمْ الِّي فِي الشَّرِيعَة وكْتُبْ الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«أُدْخْلُوا مِالبَابْ الضِّيِّقْ. عْلَى خَاطِرْ بَابْ الهْلَاكْ وَاسَعْ وطْرِيقُو سَاهِلْ، وبَرْشَة الِّي يُدْخْلُوا مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","آمَا قَدَّاشُو ضِيِّقْ البَابْ وصْعِيبْ الطْرِيقْ الِّي يْهِزْ لِلْحَيَاةْ، وشْوَيَّة الِّي يَلْقَاوَهْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«رُدُّوا بَالْكُمْ مِالأَنْبِيَاءْ الكَذَّابِينْ، يْجِيوْكُمْ عَامْلِينْ رْوَاحْهُمْ عْلَالِشْ وهُومَا مِنْ دَاخِلْ ذْيُوبَة مِتْوَحْشَة. ");
INSERT INTO aeu_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","مِنْ ثْمَارْهُمْ تَعْرْفُوهُمْ. يَاخِي الشُّوكْ يْجِيبْ العْنِبْ، وَلَّا العِلِّيقْ يْجِيبْ الكَرْمُوسْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","كِيفْ كِيفْ كُلْ شَجْرَة بَاهْيَة تْجِيبْ ثْمَرْ بَاهِي، وكُلْ شَجْرَة خَايْبَة تْجِيبْ ثْمَرْ خَايِبْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","مَا تْنَجَّمْشْ شَجْرَة بَاهْيَة تْجِيبْ ثْمَرْ خَايِبْ، ولَا شَجْرَة خَايْبَة تْجِيبْ ثْمَرْ بَاهِي. ");
INSERT INTO aeu_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","وكُلْ شَجْرَة مَا تْجِيبِشْ ثْمَرْ بَاهِي تِتْقَصْ وتِتْرْمَى فِي النَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","هَاذَاكَا عْلَاشْ مِنْ ثْمَارْهُمْ تَعْرْفُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«مُشْ كُلْ حَدْ يْقُلِّي: \"يَا رَبْ، يَا رَبْ\" يُدْخُلْ مَمْلَكْةْ السْمَاوَاتْ، مَا يُدْخُلْ كَانْ الِّي يَعْمِلْ مَشِيئِةْ بَابَا الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","نْهَارْ الحْسَابْ بَرْشَة نَاسْ بِشْ يْقُولُولِي: \"يَا رَبْ، يَا رَبْ، مُشْ بْإِسْمِكْ تْنَبَّأْنَا؟ وبِإِسْمِكْ خَرَّجْنَا الشْوَاطِنْ؟ وبِإِسْمِكْ عْمَلْنَا بَرْشَة مُعْجْزَاتْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","وآنَا بِشْ نْقُولِلْهُمْ: \"آنَا عُمْرِي مَا عْرَفْتْكُمْ. إِبْعْدُوا عْلِيَّا يَلِّي تَعْمْلُوا فِي الشَّرْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","«الِّي يِسْمَعْ الِّي قُلْتُو هَاذَا الكُلْ ويْطَبْقُو، يْكُونْ كِيمَا رَاجِلْ حَكِيمْ بْنَى دَارُو عَالحْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","وصَبِّتْ المْطَرْ وجَاتْ الفَيْضَانَاتْ وهَبِّتْ الرِّيحْ بْقُوَّة عَالدَّارْ هَاذِيكَا، آمَا الدَّارْ مَا طَاحِتْشْ، عْلَى خَاطِرْ سَاسْهَا مِبْنِي عَالحْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","ولِّي يِسْمَعْ كْلَامِي هَاذَا ومَا يْطَبْقُوشْ، يْكُونْ كِيمَا رَاجِلْ بْلَا عْقَلْ بْنَى دَارُو عَالرْمَلْ. ");
INSERT INTO aeu_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","وصَبِّتْ المْطَرْ وجَاتْ الفَيْضَانَاتْ وهَبِّتْ الرِّيحْ عَالدَّارْ هَاذِيكَا، يَاخِي طَاحِتْ وتْهَدِّتْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","وكِي كَمِّلْ يَسُوعْ الكْلَامْ هَاذَا، بْقَاوْ النَّاسْ بَاهْتِينْ مِنْ تَعْلِيمُو، ");
INSERT INTO aeu_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","عْلَى خَاطْرُو كَانْ يْعَلِّمْ فِيهُمْ بْسُلْطَة، مُشْ كِيمَا عُلَمَاءْ الشَّرِيعَة مْتَاعْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ووَقْتِلِّي هْبَطْ يَسُوعْ مِالجْبَلْ، تَبْعُوهْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","وجَاهْ وَاحِدْ أَبْرِصْ، وسْجِدْلُو وقَالْ: «يَا سِيدِي، كَانْ تْحِبْ، تْنَجِّمْ اطَّهِّرْنِي مِالبْرَصْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","يَاخِي مَدْ يَسُوعْ يِدُّو ومَسُّو وقَالُّو: «أَيْ نْحِبْ، أُطْهُرْ!» وبِالوَقْتْ تْنَحَّى البْرَصْ وطْهُرْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","وقَالُّو يَسُوعْ: «رُدْ بَالِكْ تْقُولْ لْحَدْ. آمَا إِمْشِي لِلْكَاهِنْ خَلِّيهْ يْشُوفِكْ. ومْبَعِّدْ أَعْطِي القُرْبَانْ الِّي وَصَّى بِيهْ مُوسَى، شْهَادَة لِيهُمْ إِنُّو البْرَصْ تْنَحَّى». ");
INSERT INTO aeu_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","وكِي دْخَلْ يَسُوعْ لْكَفْرْنَاحُومْ،جَاهْ ضَابِطْ رُومَانِي ولَحْ عْلِيهْ ");
INSERT INTO aeu_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","وقَالُّو: «يَا سِيدِي، عَنْدِي خْدِيمْ فِي الدَّارْ شَادِدْ الفَرْشْ وقَاعِدْ يِتْعَذَّبْ بَرْشَة ومَا يْنَجَّمْشْ يِتْحَرِّكْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","قَالُّو يَسُوعْ: «تَوْ نِمْشِي نِشْفِيهْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","يَاخِي جَاوْبُو الضَّابِطْ: «يَا سِيدِي، آنَا مَا نِسْتَاهِلْشْ إِنِّكْ تُدْخُلْ تَحْتْ سْقَفْ دَارِي، قُولْ كِلْمَة بَرْكْ تَوْ خْدِيمِي يَبْرَا. ");
INSERT INTO aeu_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","عْلَى خَاطِرْ آنَا زَادَا عَنْدِي شْكُونْ يُحْكُمْ فِيَّا وعَنْدِي عَسْكِرْ نُحْكُمْ فِيهُمْ، نْقُولْ لْوَاحِدْ \"إِمْشِي!\" يِمْشِي، ولْغِيرُو \"إِيجَا!\" يْجِي، ونْقُولْ لِخْدِيمِي \"أَعْمِلْ هَاذَا!\" يَعْمِلْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","وتْعَجِّبْ يَسُوعْ مِنْ كْلَامْ الضَّابِطْ، وقَالْ لِلِّي يْتَبْعُوا فِيهْ: «نْقُلْكُمْ الحَقْ، فِي بَنِي إِسْرَائِيلْ الكُلْ مَا لْقِيتْ حَدْ عَنْدُو إِيمَانْ عْظِيمْ كِيفْ إِيمَانُو. ");
INSERT INTO aeu_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ونْزِيدْ نْقُولِلْكُمْ إِنُّو بَرْشَة نَاسْ بِشْ يْجِيوْ مِالشَّرْقْ ومِالغَرْبْ ويُقْعْدُوا يِتْعَشَّاوْ عْلَى نَفْسْ الطَّاوْلَة مْعَ إِبْرَاهِيمْ وإِسْحَاقْ ويَعْقُوبْ فِي مَمْلَكْةْ السْمَاوَاتْ، ");
INSERT INTO aeu_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","آمَا وْلَادْ المَمْلْكَة بِشْ يِتِرْمَاوْ لْبَرَّة فِي الظْلَامْ، وِينْ بِشْ يْكُونْ البْكَاء والنْدَمْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","وبَعْدْهَا قَالْ يَسُوعْ لِلضَّابِطْ الرُّومَانِي: «إِمْشِي لْدَارِكْ، وخَلِّي الِّي أَمَّنْتْ بِيهْ يْصِيرْ». وفِي لَحْظِتْهَا بْرَا الخْدِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ودْخَلْ يَسُوعْ لْدَارْ بُطْرُسْ، يَلْقَى حْمَاةْ بُطْرُسْ شَادَّة الفَرْشْ وعَنْدْهَا السْخَانَة، ");
INSERT INTO aeu_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ومَسْهَا مِنْ يِدْهَا، يَاخِي تْنَحَّاتْ عْلِيهَا السْخَانَة، وقَامِتْ تِلْهَاتْ بِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","وفِي العْشِيَّة إِمَّخِّرْ، جَابُولُو بَرْشَة نَاسْ سَاكْنِتْهُمْ الشْوَاطِنْ. وكَانْ يْخَرِّجْ فِي الأَرْوَاحْ الشِّرِّيرَة بْكِلْمَة وَحْدَة، وشْفَى المُرْضَى الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","وهَكَّا صَارْ الكْلَامْ الِّي قَالُو النَّبِيْ إِشَعْيَاءْ: «نَحَّى وْجَايَعْنَا، وهَزْ أَمْرَاضْنَا». ");
INSERT INTO aeu_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","وكِي شَافْ يَسُوعْ بَرْشَة نَاسْ دَايْرِينْ بِيهْ، عْطَى أَمْرْ لِتْلَامِذْتُو بَاشْ يْشُقُّوا لِلجِّيهَة الأُخْرَى مِالبُحَيْرَة. ");
INSERT INTO aeu_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","وجَاهْ وَاحِدْ مِنْ عُلَمَاءْ الشَّرِيعَة وقَالُّو: «يَا مُعَلِّمْ، فِينْ مَا تِمْشِي بِشْ نْتَبْعِكْ». ");
INSERT INTO aeu_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","جَاوْبُو يَسُوعْ: «الثْعَالِبْ عَنْدْهَا مْغَاغِرْ، والطْيُورْ عَنْدْهَا عْشَاشْ، آمَا إِبْنْ الإِنْسَانْ مَا عَنْدُو وِينْ يْكِنْ رَاسُو». ");
INSERT INTO aeu_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","وقَالُّو وَاحِدْ آخِرْ مِنْ تْلَامِذْتُو: «يَا سِيدِي، خَلِّينِي قْبَلْ كُلْ شَيْ نِمْشِي نِدْفِنْ بَابَا». ");
INSERT INTO aeu_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","جَاوْبُو يَسُوعْ : «تَبَّعْنِي وخَلِّي المُوتَى يِدْفْنُوا المُوتَى مْتَاعْهُمْ!» ");
INSERT INTO aeu_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","وطْلَعْ يَسُوعْ فِي الفْلُوكَة وتَبْعُوهْ تْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","وهَبِّتْ رِيحْ قْوِيَّة حَتَّى لِينْ المُوجْ غَطَّى الفْلُوكَة. ويَسُوعْ كَانْ رَاقِدْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ومْشَاوْلُو تْلَامِذْتُو وقَيْمُوهْ وقَالُولُو: «مَنَّعْنَا يَا سِيدْنَا، رَانَا قَاعْدِينْ نُغْرْقُوا!». ");
INSERT INTO aeu_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","قَالِلْهُمْ يَسُوعْ: «شْبِيكُمْ خَايْفِينْ يَلِّي إِيمَانْكُمْ ضْعِيفْ؟» وقَامْ سَكِّتْ الرِّيحْ والبُحَيْرَة، يَاخِي الدِّنْيَا هْدَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","والنَّاسْ تْعَجْبُوا وقَالُوا: «شْكُونُو هَاذَا الِّي حَتَّى مِالرِّيحْ والبُحَيْرَة يْطِيعُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","وكِي وْصُلْ يَسُوعْ لِلجِّيهَة الأُخْرَى مْتَاعْ البُحَيْرَة ولِّي هِيَّ مَنْطَقْةْ الجَدْرِيِّينْ، عُرْضُوهْ زُوزْ رْجَالْ سَاكْنِتْهُمْ أَرْوَاحْ شِرِّيرَة خَارْجِينْ مِنْ بِينْ القْبُورَاتْ، وكَانُوا هَايْجِينْ بَرْشَة، لْدَرْجِةْ إِنُّو حَتَّى حَدْ مَا عَادْ يْنَجِّمْ يِتْعَدَّى مِنْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","وبْدَاوْ يْصِيحُوا: «آشْ بِينَّا وبِينِكْ، يَا إِبْنْ اللَّهْ؟ يَاخِي جِيتْ لَهْنَا بَاشْ تْعَذَّبْنَا قْبَلْ الوَقْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","وكَانُوا فَمَّة بَرْشَة حْلَالِفْ سَارْحِينْ بْعِيدْ عْلِيهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","وتْشَحْتُوهْ الأَرْوَاحْ الشِّرِّيرَة وقَالُولُو: «كَانِكْ بِشْ اطَّرَدْنَا، أَبْعَثْنَا لِلْحْلَالِفْ!». ");
INSERT INTO aeu_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","قَالِلْهُمْ: «إِمْشِيوْ». يَاخِي خَرْجُوا ودَخْلُوا فِي الحْلَالِفْ، وجْرَاوْ الحْلَالِفْ الكُلْ وتِرْمَاوْ مِنْ حَافِّةْ الجْبَلْ فِي البُحَيْرَة وغُرْقُوا. ");
INSERT INTO aeu_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ولِّي كَانُوا سَارْحِينْ بِالحْلَالِفْ هَرْبُوا لِلْمْدِينَة وحْكَاوْ عْلَى كُلْ شَيْ، وعَلِّي صَارْ لِلزُّوزْ رْجَالْ الِّي كَانِتْ سَاكْنِتْهُمْ الشْوَاطِنْ. ");
INSERT INTO aeu_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","وإِذَا بِيهَا المْدِينَة الكُلْ خَرْجِتْ بَاشْ تْقَابِلْ يَسُوعْ. وكِي شَافُوهْ طَلْبُوا مِنُّو يُخْرِجْ مِنْ مْدِينِتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ورْكِبْ يَسُوعْ فِي الفْلُوكَة وشَقْ البُحَيْرَة ورْجَعْ لِمْدِينْتُو. ");
INSERT INTO aeu_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","وجَابُولُو النَّاسْ وَاحِدْ مَشْلُولْ رَاقِدْ عْلَى فَرْشْ، وكِي شَافْ يَسُوعْ إِيمَانْهُمْ قَالْ لِلْمَشْلُولْ: «كُونْ مِطْمَانْ يَا وِلْدِي، رَاهِي ذْنُوبِكْ تْغِفْرِتْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","وفَمَّة جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَة قَالُوا فِي قْلُوبْهُمْ: «الرَّاجِلْ هَاذَا كْفَرْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","وعْرَفْ يَسُوعْ فَاشْ قَاعْدِينْ يْفَكْرُوا، وقَالِلْهُمْ: «عْلَاشْ تَقْرَاوْ فِي الشَّرْ فِي قْلُوبْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","آنَاهُو الأَسْهِلْ؟ إِنُّو يِتْقَالْ: \"ذْنُوبِكْ تْغِفْرِتْ\"، وَلَّا يِتْقَالْ: \"قُومْ وإِمْشِي\"؟ ");
INSERT INTO aeu_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","آمَا هَانِي بِشْ نْوَرِّيكُمْ الِّي إِبْنْ الإِنْسَانْ عَنْدُو السُّلْطَة فِي الأَرْضْ بَاشْ يِغْفِرْ الذْنُوبْ». يَاخِي قَالْ لِلْمَشْلُولْ: «قُومْ! هِزْ فَرْشِكْ ورَوَّحْ لْدَارِكْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","يَاخِي قَامْ ورَوَّحْ لْدَارُو. ");
INSERT INTO aeu_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ووَقْتِلِّي النَّاسْ شَافُوا الِّي صَارْ خَافُوا ومَجْدُوا اللَّهْ الِّي عْطَى سُلْطَة كِيفْ هَاذِي لِلْبَشَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ومْشَى يَسُوعْ مِنْ غَادِي، وفِي الطْرِيقْ شَافْ رَاجِلْ إِسْمُو مَتَّى قَاعِدْ فِي البْلَاصَة الِّي يْلِمُّوا فِيهَا الضَّرَايِبْ. وقَالُّو: «تَبَّعْنِي». يَاخِي قَامْ وتَبْعُو. ");
INSERT INTO aeu_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","وَقْتِلِّي كَانْ يَسُوعْ قَاعِدْ ويَاكِلْ فِي دَارْ مَتَّى، جَاوْ بَرْشَة مَكَّاسَة ومُذْنْبِينْ وقَعْدُوا مْعَ يَسُوعْ وتْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","وكِي شَافُوا الفِرِّيسِيِّينْ هَاذَا قَالُوا لِتْلَامِذْتُو: «عْلَاشْ المُعَلِّمْ مْتَاعْكُمْ يَاكِلْ مْعَ المَكَّاسَة والمُذْنْبِينْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","وكِي سْمَعْ يَسُوعْ كْلَامْهُمْ، قَالْ: «المُرْضَى هُومَا الِّي يَحْتَاجُوا لِطْبِيبْ مُشْ الصْحَاحْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","بَرَّاوْ اتْعَلْمُوا آشْ مَعْنَاهَا الآيَة هَاذِي: \"نْحِبْ رَحْمَة مُشْ ذْبِيحَة\". وآنَا مَا جِيتِشْ نِدْعِي فِي الصَّالْحِينْ لِلتُّوبَة آمَا جِيتْ لِلْمُذْنْبِينْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","وبَعْدْهَا جَاوْ تْلَامِذْةْ يُوحَنَّا لْيَسُوعْ وقَالُوا: «عْلَاشْ أَحْنَا والفِرِّيسِيِّينْ نْصُومُوا بَرْشَة، وتْلَامِذْتِكْ مَا يْصُومُوشْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","قَالِلْهُمْ يَسُوعْ: «يَاخِي يْنَجْمُوا إِمَّالِي العِرْسْ يَحْزْنُوا والعْرُوسْ مَزَّالْ بِينَاتْهُمْ؟ آمَا تَوْ يْجِي نْهَارْ ويِتْنَحَّى العْرُوسْ مِنْ بَحْذَاهُمْ، ووَقْتْهَا تَوْ يْصُومُوا. ");
INSERT INTO aeu_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","مَا فَمَّة حَتَّى حَدْ يْرَقَّعْ لِبْسَة قْدِيمَة بْطَرْفْ قْمَاشْ جْدِيدْ، عْلَى خَاطِرْ القْمَاشْ الجْدِيدْ بِشْ يُشْرُبْ ويِجْبِدْ مْعَاهْ القْمَاشْ القْدِيمْ، وتْوَلِّي التَّقْطِيعَة أَتْعَسْ مِنْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ومَا فَمَّة حَتَّى حَدْ يْحُطْ شْرَابْ جْدِيدْ فِي ڨِرْبَة قْدِيمَة، مَا كَانِشْ الڨِرْبَة تِتْفْلَقْ والشْرَابْ يِتْبَزَّعْ والڨِرْبَة تْوَلِّي مَا عَادِشْ تُصْلُحْ. آمَا يْحُطُّوا الشْرَابْ الجْدِيدْ فِي ڨِرْبَة جْدِيدَة وهَكَّا يِسْتَحْفْظُوا عْلِيهُمْ الإِثْنِينْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","وفِي الوَقْتْ الِّي كَانْ يَسُوعْ يْكَلِّمْ فِيهُمْ، جَاء رَئِيسْ مَعْبِدْ اليْهُودْ وسْجِدْ قُدَّامُو وقَالْ: «بِنْتِي مَزَّالِتْ كِي مَاتِتْ. آمَا إِيجَا حُطْ عْلِيهَا يِدِّكْ تَوْ تَحْيَا». ");
INSERT INTO aeu_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","يَاخِي قَامْ يَسُوعْ هُوَّ وتْلَامِذْتُو وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","وكَانِتْ فَمَّة مْرَا مْرِيضَة بْنَزِيفْ دَمْ مِنْ أَثْنَاشِنْ سْنَة، جَاتْ مِنْ وْرَاهْ ومَسِّتْ طَرْفْ حْوَايْجُو مِاللُّوطَة، ");
INSERT INTO aeu_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","عْلَى خَاطِرْهَا قَالِتْ فِي قَلْبْهَا: «كَانْ نُوصِلْ نْمِسْلُو حْوَايْجُو بَرْكْ تَوْ نَبْرَا». ");
INSERT INTO aeu_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","وتْلَفِّتْ يَسُوعْ وشَافْهَا، يَاخِي قَالْ: «كُونْ مِطْمَانَة يَا بِنْتِي، إِيمَانِكْ شْفَاكْ». وبِالوَقْتْ المْرَا بْرَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","وكِي وْصُلْ يَسُوعْ لْدَارْ رَئِيسْ مَعْبِدْ اليْهُودْ، وشَافْ النَّدَّابَا والنَّاسْ دَاخْلِينْ بْعَضْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","قَالْ: «إِمْشِيوْ عْلَى رْوَاحْكُمْ! البْنَيَّة مَا مَاتِتْشْ، آمَا رَاهِي رَاقْدَة». يَاخِي ضَحْكُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","وبَعْدْمَا خَرْجُوا العْبَادْ، دْخَلْ وشَدْ البْنَيَّة مِنْ يِدْهَا يَاخِي قَامِتْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","والخْبَرْ هَاذَا تِنْشَرْ فِي المَنْطْقَة هَاذِيكَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","وكِي مْشَى يَسُوعْ مِنْ غَادِي، تَبْعُوهْ زُوزْ رْجَالْ عِمْيَانْ وهُومَا يْصِيحُوا ويْعَيْطُوا: «يَا وِلْدْ دَاوِدْ أَرْحَمْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ووَقْتِلِّي دْخَلْ لِلدَّارْ، جَاوَهْ العِمْيَانْ الزُّوزْ، يَاخِي سْإِلْهُمْ يَسُوعْ: «تَمْنُوا الِّي آنَا قَادِرْ نَعْمِلْ هَاذَا؟». قَالُولُو: «أَيْ نْعَمْ يَا سِيدْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","وَلَّى يَسُوعْ مَسْهُمْ مِنْ عِينِيهُمْ وقَالْ: «عْلَى قَدْ إِيمَانْكُمْ تَاخْذُوا». ");
INSERT INTO aeu_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","يَاخِي عِينِيهُمْ تْحَلِّتْ. ونَبَّهْ عْلِيهُمْ يَسُوعْ وقَالِلْهُمْ: «رُدُّوا بَالْكُمْ لَا وَاحِدْ يَعْرِفْ!». ");
INSERT INTO aeu_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","آمَا هُومَا خَرْجُوا وبْدَاوْ يَحْكِيوْ عْلِيهْ فِي المَنْطْقَة هَاذِيكَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ودُوبْ مَا خَرْجُوا الزُّوزْ رْجَالْ، جَاوْ جْمَاعَة وجَابُولُو وَاحِدْ بَكُّوشْ، سَاكْنُو شِيطَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","وكِي خَرِّجْ يَسُوعْ الشِّيطَانْ، البَكُّوشْ وَلَّى يِتْكَلِّمْ. والنَّاسْ بْقَاوْ بَاهْتِينْ، وقَالُوا: «عْمُرْنَا مَا شُفْنَا حَاجَة كِيفْ هَاذِي فِي إِسْرَائِيلْ!». ");
INSERT INTO aeu_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","آمَا الفِرِّيسِيِّينْ قَالُوا: «يْخَرِّجْ فِي الشْوَاطِنْ بْقُوِّةْ رَئِيسْ الشْوَاطِنْ». ");
INSERT INTO aeu_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","وكَانْ يَسُوعْ يْدُورْ مِنْ مْدِينَة لِمْدِينَة ومِنْ قَرْيَة لْقَرْيَة، يْعَلِّمْ فِي مْعَابِدْ اليْهُودْ ويْنَادِي بِبْشَارِةْ مَمْلَكْةْ اللَّهْ، ويِشْفِي فِي النَّاسْ مِنْ كُلْ مَرْضْ وعِلَّة. ");
INSERT INTO aeu_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","وكِي شَافْ النَّاسْ حَنْ عْلِيهُمْ، عْلَى خَاطِرْهُمْ كَانُوا مِتْعَذْبِينْ ومْشَرْدِينْ كِيفْ الغْنَمْ الِّي مَا عَنْدْهَا شْكُونْ يِسْرَحْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","وقَالْ لِتْلَامِذْتُو: «الصَّابَة بَرْشَة، آمَا الخَدَّامَة شْوَيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","مَالَا أُطْلْبُوا مِنْ مُولَى الصَّابَة يَبْعَثْ خَدَّامَة لْصَابْتُو». ");
INSERT INTO aeu_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ومْبَعِّدْ عَيِّطْ لِلْأَثْنَاشِنْ تِلْمِيذْ، وعْطَاهُمْ سُلْطَة بَاشْ يْخَرْجُوا الأَرْوَاحْ الشِّرِّيرَة، ويِشْفِيوْ النَّاسْ مِنْ كُلْ مَرْضْ وعِلَّة. ");
INSERT INTO aeu_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","وهَاذِي أَسَامِي الأَثْنَاشِنْ رَسُولْ: الأُولَانِي إِسْمُو سِمْعَانْ الِّي يْعَيْطُولُو بُطْرُسْ، وخُوهْ أَنْدَرَاوُسْ، ويَعْقُوبْ وِلْدْ زَبَدِي وخُوهْ يُوحَنَّا، ");
INSERT INTO aeu_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","وفِيلِۑُّسْ وبَرْثُلْمَاوُسْ، وتُومَا ومَتَّى المَكَّاسْ، ويَعْقُوبْ وِلْدْ حَلْفَى وتَدَّاوُسْ، ");
INSERT INTO aeu_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","وسِمْعَانْ القَانَوِي، ويَهُوذَا الإِسْخَرْيُوطِي الِّي خَانْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","بْعَثْ يَسُوعْ الأَثْنَاشْ هَاذُومَا ووَصَّاهُمْ: «مَا تِمْشِيوِشْ لِلِّي مَاهُمْشْ يْهُودْ ومَا تُدْخْلُوشْ لْحَتَّى مْدِينَة فِي مَنْطَقْةْ السَّامْرَة. ");
INSERT INTO aeu_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","آمَا بِالأَوْلَى إِمْشِيوْ لِغْنَمْ بَنِي إِسْرَائِيلْ الضَّايْعَة. ");
INSERT INTO aeu_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","وإِنْتُومَا مَاشِينْ بَشْرُوا وقُولُوا: \"رَاهِي مَمْلَكْةْ السْمَاوَاتْ قُرْبِتْ\". ");
INSERT INTO aeu_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","إِشْفِيوْ المُرْضَى، قَيْمُوا المُوتَى، خَلِّيوْ الِّي عَنْدْهُمْ البْرَصْ يُطْهْرُوا، خَرّْجُوا الشْوَاطِنْ. إِنْتُومَا خْذِيتُوا بْلَاشْ، أَعْطِيوْ بْلَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","«مَا تْهِزُّوشْ مْعَاكُمْ فْلُوسْ سِوَى كَانِتْ مِنْ ذْهَبْ وَلَّا فُضَّة وَلَّا نْحَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ولَا تْهِزُّوا مْعَاكُمْ زَادْ لِلطْرِيقْ ولَا لِبْسَة ولَا صَنْدَالْ زَايْدِينْ ولَا عْصَا، عْلَى خَاطِرْ الِّي يِخْدِمْ مِنْ حَقُّو يَعْطِيوَهْ يَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","وأَيْ مْدِينَة وَلَّا دَشْرَة تُدْخْلُوهَا، لَوْجُوا فِيهَا عْلَى شْكُونْ يِسْتَاهِلْ تُدْخْلُوا لْدَارُو، وأُسْكْنُوا عَنْدُو حَتَّى لِينْ تِمْشِيوْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","وكِي تُدْخْلُوا لْدَارْ سَلْمُوا عَالنَّاسْ الِّي فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","وإِذَا كَانْ إِمَّالِي الدَّارْ يِسْتَاهْلُوا، سَلَامْكُمْ يْبَارِكْهُمْ، وإِذَا كَانْهُمْ مَا يِسْتَاهْلُوشْ سَلَامْكُمْ يِرْجْعِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","وأَيْ وَاحِدْ مَا يِقْبِلْكُمْشْ ومَا يِسْمْعِلْكُمْشْ، أُخْرْجُوا مِالدَّارْ وَلَّا المْدِينَة هَاذِيكَا، وأُنْفْضُوا التْرَابْ مِنْ سَاقِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","نْقُلْكُمْ الحَقْ: فِي نْهَارْ الحْسَابْ، مْدِينِةْ سَدُومْ وعَمُورَة بِشْ يْكُونْ حْسَابْهُمْ أَخَفْ مِالمْدِينَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«هَانِي بِشْ نِبْعَثْكُمْ كِيمَا الغْنَمْ فِي وِسْطْ الذْيُوبَة، مَالَا كُونُوا فَايْقِينْ كِي الأَفَاعِي، ومُسَالْمِينْ كِي الحْمَامْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ورُدُّوا بَالْكُمْ مِالنَّاسْ، عْلَى خَاطِرْهُمْ بِشْ يْهِزُّوكُمْ لِلْمْحَاكِمْ، ويِجْلْدُوكُمْ فِي مْعَابِدْ اليْهُودْ، ");
INSERT INTO aeu_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ويْكَرْكْرُوكُمْ لِلْحُكَّامْ والمُلُوكْ عْلَى خَاطْرِي، وهَاذَا بِشْ يْكُونْ شْهَادَة قُدَّامْ اليْهُودْ والمُشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ووَقْتِلِّي يْشِدُّوكُمْ مَا تْخَمُّوشْ فِي كِيفَاشْ بِشْ تَحْكِيوْ وَلَّا شْنُوَّة بِشْ تْقُولُوا، عْلَى خَاطِرْ فِي الوَقْتْ هَاذَاكَا بِشْ يِتْعْطَالْكُمْ الكْلَامْ الِّي تْقُولُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","عْلَى خَاطِرْ مُشْ إِنْتُومَا الِّي تِتْكَلْمُوا، آمَا رُوحْ بُوكُمْ هُوَّ الِّي يِتْكَلِّمْ فِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","والخُو يْهِزْ خُوهْ لِلْمُوتْ، والبُو يْهِزْ وِلْدُو، والوْلَادْ يْدُورُوا عْلَى وَالْدِيهُمْ ويُقْتْلُوهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","والنَّاسْ الكُلْ بِشْ تِكْرَهْكُمْ عْلَى خَاطِرْ إِسْمِي. آمَا الِّي يِثْبِتْ لِلِّخِّرْ يِنْجَى. ");
INSERT INTO aeu_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","وإِذَا اضْطَهْدُوكُمْ فِي مْدِينَة أُهْرْبُوا لِمْدِينَة أُخْرَى، نْقُلْكُمْ الحَقْ: قْبَلْ مَا تْكَمْلُوا خِدْمِتْكُمْ فِي مْدُنْ بَنِي إِسْرَائِيلْ الكُلْ يْجِي إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","«التِّلْمِيذْ مُشْ أَعْظَمْ مِالمُعَلِّمْ مْتَاعُو والخْدِيمْ مُشْ أَعْظَمْ مِنْ سِيدُو. ");
INSERT INTO aeu_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","يِكْفِي التِّلْمِيذْ يْكُونْ كِيفْ المُعَلِّمْ مْتَاعُو والخْدِيمْ يْكُونْ كِيمَا سِيدُو. إِذَا كَانْ كْبِيرْ العِيْلَة سَمَّاوَهْ بَعْلَزَبُولْ، مَالَا بْقِيِّةْ العَايْلَة آشْ بِشْ يْقُولُوا عْلِيهُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","«مَا تْخَافُوشْ مِنْهُمْ. عْلَى خَاطِرْ المَسْتُورْ بِشْ يِتْكْشِفْ، والمْخُبِّي بِشْ يِتْعْرَفْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ولِّي نْقُولْهُولْكُمْ فِي الظْلَامْ، قُولُوهْ فِي النُّورْ. ولِّي تْقَالِلْكُمْ فِي وِذْنِيكُمْ نَادِيوْ بِيهْ مِنْ فُوقْ السْطُوحَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","مَا تْخَافُوشْ مِلِّي يْنَجْمُوا يُقْتْلُوا البْدَنْ آمَا مَا يْنَجْمُوشْ يُقْتْلُوا الرُّوحْ، بِالعَكْسْ خَافُوا مِلِّي يَقْدِرْ يِهْلِكْ البْدَنْ والرُّوحْ فِي جْهَنِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","«يَاخِي مُشْ زُوزْ عْصَافِرْ يِتْبَاعُوا بِفْرَنْكْ؟ ورَغْمْ هَاذَاكَا مَا يْطِيحْ حَتَّى وَاحِدْ مِنْهُمْ عَالأَرْضْ ويْمُوتْ مِنْ غِيرْ عِلْمْ بُوكُمْ الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","آمَا إِنْتُومَا حَتَّى شْعَرْ رْيُوسْكُمْ مَحْسُوبْ بْكُلُّو. ");
INSERT INTO aeu_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","مَالَا مَا تْخَافُوشْ، رَاكُمْ إِنْتُومَا خِيرْ مِنْ بَرْشَة عْصَافِرْ! ");
INSERT INTO aeu_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«الِّي يِسْتَعْرِفْ بِيَّا قُدَّامْ النَّاسْ نِسْتَعْرِفْ بِيهْ قُدَّامْ بَابَا الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ولِّي يُنْكُرْنِي قُدَّامْ النَّاسْ، نُنْكُرُو قُدَّامْ بَابَا الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«مَا يِمْشِيشْ فِي بَالْكُمْ الِّي آنَا جِيتْ بَاشْ نْجِيبْ سَلَامْ لِلْأَرْضْ. مَا جِيتِشْ بَاشْ نْجِيبْ سَلَامْ آمَا بَاشْ نْجِيبْ سِيفْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","جِيتْ بَاشْ يْوَلِّي الوْلِدْ ضِدْ بُوهْ، والبْنَيَّة ضِدْ أُمْهَا، والكِنَّة ضِدْ حْمَاتْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","وهَكَّا يْوَلِّيوْ أَعْدَاءْ الإِنْسَانْ امَّالِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","ولِّي يْحِبْ بُوهْ وَلَّا أُمُّو أَكْثِرْ مِنِّي مَا يِسْتَاهِلْنِيشْ. ولِّي يْحِبْ وِلْدُو وَلَّا بِنْتُو أَكْثِرْ مِنِّي مَا يِسْتَاهِلْنِيشْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ولِّي مَا يْهِزِّشْ صَلِيبُو ويْتَبَّعْنِي، مَا يِسْتَاهِلْنِيشْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","الِّي يْحِبْ يْمَنَّعْ حْيَاتُو يَخْسَرْهَا، ولِّي يَخْسَرْ حْيَاتُو عْلَى خَاطْرِي يِرْبَحْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«الِّي يِقْبِلْكُمْ يِقْبِلْنِي، ولِّي يِقْبِلْنِي يِقْبِلْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","الِّي يِقْبِلْ نَبِيْ عْلَى خَاطْرُو نَبِيْ يَاخِذْ أَجْرْ كِيفْ أَجْرْ النَّبِيْ. ولِّي يِقْبِلْ رَاجِلْ صَالَحْ عْلَى خَاطْرُو رَاجِلْ صَالَحْ يَاخِذْ أَجْرْ كِيفْ أَجْرْ الرَّاجِلْ الصَّالَحْ. ");
INSERT INTO aeu_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ولِّي يَعْطِي لْوَاحِدْ مِالصْغَارْ هَاذُومَا حَتَّى كَاسْ مَاء بَارِدْ عْلَى خَاطْرُو تِلْمِيذِي، نْقُلْكُمْ الحَقْ، أَجْرُو عُمْرُو مَا يْضِيعْ». ");
INSERT INTO aeu_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","وبَعْدْمَا كَمِّلْ يَسُوعْ وَصَّى تْلَامِذْتُو الأَثْنَاشْ، مْشَى مِالبْلَاصَة هَاذِيكَا بَاشْ يْعَلِّمْ ويْبَشِّرْ فِي المْدُنْ الأُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","وسْمَعْ يُوحَنَّا وهُوَّ فِي الحَبْسْ بِلِّي يَعْمِلْ فِيهْ المَسِيحْ، يَاخِي بْعَثْلُو جْمَاعَة مِنْ تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","بَاشْ يِسْأْلُوهْ: «إِنْتِ هُوَّ الِّي نِسْتَنَّاوْ فِيهْ بَاشْ يْجِي، وَلَّا نِسْتَنَّاوْ وَاحِدْ آخِرْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","جَاوِبْهُمْ يَسُوعْ: «إِمْشِيوْ خَبْرُوا يُوحَنَّا بِلِّي تْشُوفُوا فِيهْ وتِسْمْعُوا فِيهْ، ");
INSERT INTO aeu_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","العِمْيَانْ يْشُوفُوا، والعَايْبِينْ يِمْشِيوْ، ولِّي عَنْدْهُمْ البْرَصْ يَطْهْرُوا، والطْرُشْ يِسْمْعُوا، والمُوتَى يْقُومُوا، والمْسَاكِنْ تُوصِلْهُمْ البْشَارَة. ");
INSERT INTO aeu_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","وصَحَّة لِيهْ الِّي مَا يْشُكِّشْ فِيَّا!». ");
INSERT INTO aeu_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","وَقْتِلِّي مْشَاوْ تْلَامِذْةْ يُوحَنَّا، بْدَا يَسُوعْ يَحْكِي لِلنَّاسْ عْلَى يُوحَنَّا وقَالْ: «وَقْتِلِّي خْرَجْتُوا لِلْخْلَاء، شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ قَصْبَة يْحَرِّكْ فِيهَا الرِّيحْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ رَاجِلْ لَابِسْ لِبْسَة مِذْخْمَة؟ الِّي يِلْبْسُوا اللِّبْسَة المِذْخْمَة هُومَا فِي قْصُورْ المُلُوكْ! ");
INSERT INTO aeu_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","قُولُولِي مَالَا شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ نَبِيْ؟ إِيْ نْعَمْ، وآنَا نْقُولِلْكُمْ إِنُّو أَعْظِمْ مِنْ نَبِيْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","هَاذَا هُوَّ الِّي تِكْتِبّْ عْلِيهْ فِي الكْتُبْ المُقَدْسَة: \"هَانِي بِشْ نِبْعَثْ قُدَّامِكْ رَسُولِي، بَاشْ يْحَضِّرْلِكْ الطْرِيقْ\". ");
INSERT INTO aeu_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","«نْقُلْكُمْ الحَقْ: فِي البَشَرْ الكُلْ، عُمْرُو مَا تُوجِدْ وَاحِدْ أَعْظَمْ مِنْ يُوحَنَّا الِّي يْعَمِّدْ. آمَا رَاهُو أَصْغِرْ وَاحِدْ فِي مَمْلِكْةْ السْمَاوَاتْ أَعْظَمْ مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","مِلِّي بْدَا يُوحَنَّا الِّي يْعَمِّدْ خِدْمْتُو لْتَوَّا والنَّاسْ يَسْعَاوْ بَاشْ يُدْخْلُوا مَمْلَكْةْ السْمَاوَاتْ، ولِّي قَاعْدِينْ يَسْعَاوْ يُدْخْلُوهَا بِالشْقَى. ");
INSERT INTO aeu_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","والأَنْبِيَاءْ الكُلْ والتَّوْرَاةْ تْنَبْؤُوا عْلِيهَا حَتَّى لِينْ جَاء يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","وكَانْ تْحِبُّوا تْصَدْقُوا كْلَامْهُمْ، أَعْرْفُوا الِّي يُوَحَنَّا هُوَّ إِيلِيَّا الِّي تِسْتَنَّاوْ فِيهْ يْجِي. ");
INSERT INTO aeu_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ! ");
INSERT INTO aeu_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","«بِشْكُونْ نْشَبَّهْ الجِيلْ هَاذَا؟ هُومَا كِيفْ أَوْلَادْ قَاعْدِينْ فِي السُّوقْ يْعَيْطُوا لِصْحَابْهُمْ ويْقُولُوا: ");
INSERT INTO aeu_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","\"ضْرَبْنَالْكُمْ الزُّكْرَة مَا شْطَحْتُوا، نْدِبْنَالْكُمْ مَا نَوَّحْتُوا\". ");
INSERT INTO aeu_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","«جَاء يُوحَنَّا لَا يَاكِلْ لَا يُشْرُبْ قُلْتُوا: \"سَاكْنُو شِيطَانْ\". ");
INSERT INTO aeu_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","جَاء إِبْنْ الإِنْسَانْ يَاكِلْ ويُشْرُبْ قُلْتُوا عْلِيهْ وَكَّالْ وسُوكَارْجِي وصَاحِبْ المَكَّاسَة والمُذْنْبِينْ. آمَا الحِكْمَة الحَقِيقِيَّة يِشْهْدُولْهَا أَفْعَالْهَا». ");
INSERT INTO aeu_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","وبْدَا يَسُوعْ يْلُومْ فِي المْدُنْ الِّي عْمَلْ فِيهَا أَكْثِرْ مُعْجْزَاتْ ونَاسْهَا مَا تَابُوشْ، ");
INSERT INTO aeu_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","وقَالْ: «يَا وِيلِكْ يَا كُورَزِينْ! يَا وِيلِكْ يَا بَيْتْ صَيْدَا! لَوْ كَانْ المُعْجْزَاتْ الِّي تْعَمْلِتْ فِي وِسْطْكُمْ تْعَمْلِتْ فِي صُورْ وصَيْدَا، رَاهُو نَاسْهُمْ تَابُوا ولِبْسُوا خْيِشْ وحَطُّوا الرْمَادْ عْلَى رْيُوسْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","آمَا آنَا نْقُلْكُمْ: فِي نْهَارْ الحْسَابْ، صُورْ وصَيْدَا بِشْ يْكُونْ حْسَابْهُمْ أَخَفْ مِنْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","وإِنْتِ يَا كَفْرْنَاحُومْ! تْحِبْ تِطْلَعْ لِلسْمَاء؟ لَا، رَاكْ بِشْ تَهْبِطْ لِلْهَاوِيَة. لَوْ كَانْ المُعْجْزَاتْ الِّي تْعَمْلِتْ فِيكْ تْعَمْلِتْ فِي مْدِينِةْ سَدُومْ، رَاهِي قَعْدِتْ مَوْجُودَة لِلْيُومْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","آمَا نْقُلْكُمْ: نْهَارْ الحْسَابْ حَالِةْ سَدُومْ بِشْ تْكُونْ أَهْوِنْ مِنْ حَالْتِكْ». ");
INSERT INTO aeu_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","تْكَلِّمْ يَسُوعْ فِي الوَقْتْ هَاذَاكَا وقَالْ: «نِحْمْدِكْ يَا بَابَا، يَا رَبْ السْمَاء والأَرْضْ، عْلَى خَاطْرِكْ خَبِّيتْ الأُمُورْ هَاذِي عَالحُكَمَاءْ والعُلَمَاءْ وكْشِفْتْهَا لِلصْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","إِيْ نْعَمْ، يَا بَابَا، هَكَّا إِنْتِ حَبِّيتْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","«بَابَا عْطَانِي فِي يِدِّي كُلْ شَيْ. وحَتَّى وَاحِدْ مَا يَعْرِفْ الإِبْنْ كَانْ الآبْ، وحَتَّى وَاحِدْ مَا يَعْرِفْ الآبْ كَانْ الإِبْنْ وأَيْ وَاحِدْ حَبْ الإِبْنْ يْعَرْفُو بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","إِنْتُومَا يَا تَاعْبِينْ وحْمَالْكُمْ ثْقِيلَة، إِيجَاوْنِي وآنَا نْرَتَّحْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","حُطُّوا عْلِيكُمْ نِيرِي واتْعَلْمُوا مِنِّي خَاطِرْنِي سِيِّسْ وقَلْبِي مِتْوَاضَعْ، وتَوَّا تَلْقَاوْ الرَّاحَة لِرْوَاحْكُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","عْلَى خَاطِرْ نِيرِي سَاهِلْ وحِمْلِي خْفِيفْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","فِي الأَيَّامَاتْ هَاذِيكَا تْعَدَّى يَسُوعْ وِسْطْ هْنَاشِرْ فِي نْهَارْ سِبْتْ. وتْلَامِذْتُو جَاعُوا، يَاخِي بْدَاوْ يْنَحِّيوْ فِي سْبُولْ القَمْحْ ويَاكْلُوا. ");
INSERT INTO aeu_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ووَقْتِلِّي الفِرِّيسِيِّينْ شَافُوهُمْ قَالُولُو: «شُوفْ! تْلَامِذْتِكْ يَعْمْلُوا فِي حَاجَة مُشْ حْلَالْ تِتْعْمَلْ نْهَارْ السِّبْتْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","جَاوِبْهُمْ يَسُوعْ: «مَا قْرِيتُوشْ شْنُوَّة عْمَلْ دَاوِدْ هُوَّ ولِّي مْعَاهْ وَقْتِلِّي جَاعُوا؟ ");
INSERT INTO aeu_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","كِيفَاشْ دْخَلْ لْخِيمِةْ الإِجْتِمَاعْ، وكْلَا الخُبْزْ الِّي يِتْقَدِّمْ قُرْبَانْ لِلَّهْ، الِّي مَا عَنْدُوشْ الحَقْ يَاكِلْ مِنُّو هُوَّ ولِّي مْعَاهْ، وحْلَالْ كَانْ لِلْكَهَنَة يَاكْلُوا مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","وَلَّا مَا قْرِيتُوشْ فِي الشَّرِيعَة كِيفَاشْ الكَهَنَة يْكَسْرُوا وْصِيِّةْ السِّبْتْ عْلَى خَاطِرْ يِخِدْمُوا فِي الهَيْكِلْ نْهَارْ السِّبْتْ، ومَا يِتْحِسْبُوشْ مُذْنْبِينْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","آمَا نْقُلْكُمْ: هُونِي فَمَّة وَاحِدْ أَعْظِمْ مِالهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","وكَانْ جِيتُوا فْهِمْتُوا مَعْنَى الآيَة هَاذِي: \"نْحِبْ رَحْمَة مُشْ ذْبِيحَة\" رَاكُمْ مَا حْكُمْتُوشْ عْلَى نَاسْ مَا عَمْلُوشْ حَاجَة غَالْطَة. ");
INSERT INTO aeu_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ هُوَّ رَبْ السِّبْتْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ومْشَى يَسُوعْ مِنْ غَادِي ودْخَلْ لْمَعْبِدْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ولْقَى رَاجِلْ يِدُّو مَشْلُولَة. وحَبُّوا الفِرِّيسِيِّينْ يَلْقَاوْ حَاجَة يِتْهْمُوهْ بِيهَا، وَلَّاوْ سِأْلُوهْ: «يَاخِي حْلَالْ الوَاحِدْ يِشْفِي المُرْضَى نْهَارْ السِّبْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","يَاخِي جَاوِبْهُمْ: «شْكُونْ مِنْكُمْ عَنْدُو عَلُّوشْ وَاحِدْ، ويْطِيحْلُو فِي بِيرْ نْهَارْ السِّبْتْ، ومَا يْشِدُّوشْ ويْخَرْجُو مِالبِيرْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","والإِنْسَانْ قَدَّاشْ عَنْدُو قِيمَة أَكْثِرْ مِالعَلُّوشْ! هَاذَاكَا عْلَاشْ فِعْلْ الخِيرْ بِالسِّبْتْ حْلَالْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ومْبَعِّدْ قَالْ يَسُوعْ لِلرَّاجِلْ: «مِدْ يِدِّكْ!» يَاخِي مَدْهَا، ورَجْعِتْ صْحِيحَة كِي الأُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","وخَرْجُوا الفِرِّيسِيِّينْ وتْفَاهْمُوا بَاشْ يُقْتْلُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","وكِي عْرَفْ يَسُوعْ الِّي هُومَا يْحِبُّوا يُقْتْلُوهْ، خْرَجْ مِنْ غَادِي. وتَبْعُوهْ بَرْشَة نَاسْ وشْفَى المُرْضَى الِّي فِيهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ونَبَّهْ عْلِيهُمْ بَاشْ مَا يَحْكِيوْ عْلِيهْ لْحَدْ، ");
INSERT INTO aeu_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","بَاشْ يِتْحَقَّقْ الِّي قَالُو النَّبِيْ إِشَعْيَاءْ: ");
INSERT INTO aeu_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","«هَاذَا هُوَّ عَبْدِي الِّي اخْتَرْتُو، حْبِيبِي الِّي يْفَرَّحْنِي. بِشْ نْفِيضْ بْرُوحِي فِيهْ، بَاشْ يُعْلِنْ العَدْلْ لِلشُّعُوبْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","لَا يَعْمِلْ عَرْكْ ولَا يْصِيحْ، ولَا حَدْ يِسْمَعْ صُوتُو فِي الشْوَارَعْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","قَصْبَة مْرَضِرْضَة مَا يْكَسَّرْهَاشْ، وفْتِيلَة ادَّخِّنْ مَا يِطْفِيهَاشْ، حَتَّى لِينْ يُنْصُرْ العَدْلْ، ");
INSERT INTO aeu_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","والشُّعُوبْ الكُلْ يْحُطُّوا رْجَاهُمْ فِي إِسْمُو». ");
INSERT INTO aeu_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","وجَابُولُو رَاجِلْ أَعْمَى وبَكُّوشْ سَاكْنُو شِيطَانْ. وشْفَاهْ يَسُوعْ ووَلَّى يِتْكَلِّمْ ويْشُوفْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","والنَّاسْ الكُلْ بِهْتُوا وقَالُوا: «زَعْمَة هَاذَا هُوَّ وِلْدْ دَاوِدْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","وكِي سَمْعُوا الفِرِّيسِيِّينْ النَّاسْ آشْ يَحْكِيوْ قَالُوا: «رَاهُو قَاعِدْ يْخَرِّجْ فِي الشْوَاطِنْ بْرَئِيسْ الشْوَاطِنْ بَعْلَزَبُولْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","وعْرَفْ يَسُوعْ أَفْكَارْهُمْ، وقَالِلْهُمْ: «كُلْ مَمْلْكَة تِتْقْسِمْ ضِدْ رُوحْهَا تِخْرِبْ، وكُلْ مْدِينَة وَلَّا عَايْلَة تِتْقْسِمْ ضِدْ رُوحْهَا مَا ادُّومِشْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","إِذَا كَانْ إِبْلِيسْ يْخَرِّجْ إِبْلِيسْ، بِشْ يِتْقْسِمْ ضِدْ رُوحُو. مَالَا كِيفَاشْ مَمْلَكْتُو تْنَجِّمْ ادُّومْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","وكَانْ آنَا نْخَرِّجْ فِي الشْوَاطِنْ ابَّعْلَزَبُولْ، مَالَا أَوْلَادْكُمْ بِشْكُونْ يْخَرْجُوا فِيهُمْ؟ هَاذَاكَا عْلَاشْ هُومَا الِّي بِشْ يُحْكْمُوا عْلِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","آمَا كَانْ آنَا نْخَرِّجْ فِي الشْوَاطِنْ بْرُوحْ اللَّهْ، أَعْرْفُوا إِنُّو مَمْلَكْةْ اللَّهْ جَاتْ حَتَّى لْعَنْدْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","كِيفَاشْ يْنَجِّمْ وَاحِدْ يُدْخُلْ لْدَارْ رَاجِلْ قْوِيْ ويِسْرَقْلُو دَبْشُو، كَانْ مَا يْكَتْفُوشْ قْبَلْ، ومْبَعِّدْ يِسْرْقُو؟ ");
INSERT INTO aeu_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","الِّي مُشْ مْعَايَا رَاهُو ضِدِّي، ولِّي مَا يَجْمَعْشْ مْعَايَا رَاهُو يْفَرِّتْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","هَاذَاكَا عْلَاشْ نْقُلْكُمْ: كُلْ ذَنْبْ وكُلْ كُفْرْ يِتْغْفِرْ لِلنَّاسْ، آمَا الكُفْرْ بِالرُّوحْ القُدُسْ مَا يِتْغْفِرْشْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","الِّي يْقُولْ كِلْمَة ضِدْ إِبْنْ الإِنْسَانْ يِتْغْفِرْلُو، آمَا الِّي يْقُولْ كِلْمَة ضِدْ الرُّوحْ القُدُسْ، مُشْ بِشْ يِتْغْفِرْلُو، لَا فِي الزْمَانْ هَاذَا ولَا فِي الزْمَانْ الجَايْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«يَا إِمَّا تْخَلِّيوْ الشَّجْرَة تْكُونْ بَاهْيَة تَوَّا تْجِيبْ غَلَّة بَاهْيَة، وَلَّا تْخَلِّيوْ الشَّجْرَة تْكُونْ خَايْبَة تَوَّا تْجِيبْ غَلَّة خَايْبَة. عْلَى خَاطِرْ الشَّجْرَة تِتْعْرَفْ مِنْ غَلَّتْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","يَا وْلَادْ الأَفَاعِي، كِيفَاشْ تْنَجْمُوا تْقُولُوا كْلَامْ يُصْلُحْ وإِنْتُومَا أَشْرَارْ؟ خَاطِرْ اللْسَانْ يَنْطَقْ بِلِّي فِي القَلْبْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","الإِنْسَانْ الصَّالَحْ يْخَرِّجْ الحَاجَاتْ الصَّالْحَة مِالكِنْزْ الصَّالَحْ الِّي فِي قَلْبُو، والإِنْسَانْ الشِّرِيرْ يْخَرِّجْ الشَّرْ مِنْ كِنْزْ الشَّرْ الِّي فِي قَلْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ونْقُلْكُمْ: كُلْ كِلْمَة بَاطْلَة يْقُولُوهَا النَّاسْ بِشْ يِتْحَاسْبُوا عْلِيهَا فِي نْهَارْ الحْسَابْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","عْلَى خَاطِرْ بِكْلَامِكْ تِتْحْسِبْ صَالَحْ وبِكْلَامِكْ تِتْحْسِبْ مُذْنِبْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","وقَالُولُو جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ: «يَا مُعَلِّمْ، نْحِبُّوا نْشُوفُوا مِنِّكْ مُعْجْزَة». ");
INSERT INTO aeu_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","يَاخِي جَاوِبْهُمْ: «جِيلْ شِرِّيرْ وخَايِنْ يْحِبْ عْلَى مُعْجْزَة، ومَا يِتْعْطَالُو كَانْ مُعْجِزْةْ النَّبِيْ يُونَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","وكِيفْ مَا قْعَدْ يُونَانْ ثْلَاثَة أَيَّامْ وثْلَاثَة لْيَالِي فِي كِرْشْ الحُوتَة، هَكَّاكَا إِبْنْ الإِنْسَانْ زَادَا بِشْ يُقْعُدْ ثْلَاثَة أَيَّامْ وثْلَاثَة لْيَالِي فِي قَلْبْ الأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","أَهْلْ مْدِينِةْ نِينَوَى بِشْ يَاقْفُوا نْهَارْ الحْسَابْ مْعَ الجِيلْ هَاذَا ويُحْكْمُوا عْلِيهْ، عْلَى خَاطِرْهُمْ تَابُوا وَقْتِلِّي نَبَّهُّمْ يُونَانْ، وهَاوْ فَمَّة شْكُونْ هْنَا أَعْظِمْ مِنْ يُونَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ومَلِكَةْ الجَنُوبْ بِشْ تَاقِفْ نْهَارْ الحْسَابْ مْعَ الجِيلْ هَاذَا وتُحْكُمْ عْلِيهْ، عْلَى خَاطِرْهَا جَاتْ مِنْ آخِرْ الدِّنْيَا بَاشْ تِسْمَعْ حِكْمِةْ سُلَيْمَانْ، وهَاوْ فَمَّة شْكُونْ هْنَا أَعْظِمْ مِنْ سُلَيْمَانْ!» ");
INSERT INTO aeu_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«وَقْتِلِّي الرُّوحْ الشِّرِّيرْ يُخْرُجْ مِنْ إِنْسَانْ، يَبْدَى يْدُورْ فِي البْلَايِصْ الخَالِيَة يْلَوِّجْ عَالرَّاحَة، ومَا يَلْقَاهَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","وَقْتْهَا يْقُولْ: \"نِرْجَعْ لْدَارِي الِّي خْرَجْتْ مِنْهَا\" ويِرْجَعْ يَلْقَاهَا فَارْغَة ومَكْنُوسَة ومْنَظْمَة. ");
INSERT INTO aeu_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ويِمْشِي يْجِيبْ مْعَاهْ سَبْعَة أَرْوَاحْ أُخْرِينْ أَشَرْ مِنُّو ويُدْخْلُوا ويُسْكْنُوا فِي الإِنْسَانْ هَاذَاكَا، وحَالْتُو تْوَلِّي أَخْيِبْ مِلِّي كَانْ عْلِيهَا قْبَلْ. وهَكَّا بِشْ يْصِيرْ مْعَ الجِيلْ الشِّرِّيرْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ووَقْتِلِّي كَانْ يَسُوعْ يْكَلِّمْ فِي النَّاسْ، جَاوْ أُمُّو وخْوَاتُو وقَعْدُوا وَاقْفِينْ لْبَرَّا، وحَبُّوا يَحْكِيوْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","يَاخِي وَاحِدْ مِالحَاضْرِينْ قَالُّو: «أُمُّكْ وخْوَاتِكْ وَاقْفِينْ لْبَرَّا، يْحِبُّوا يَحْكِيوْ مْعَاكْ». ");
INSERT INTO aeu_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","آمَا يَسُوعْ جَاوْبُو: «شْكُونْهَا أُمِّي، وشْكُونْهُمْ خْوَاتِي؟». ");
INSERT INTO aeu_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","وشَاوِرْ بْيِدُّو لِتْلَامِذْتُو وقَالْ: «هَاذُومْ هُومَا أُمِّي وخْوَاتِي. ");
INSERT INTO aeu_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","عْلَى خَاطِرْ الِّي يَعْمِلْ الِّي يْحِبْ عْلِيهْ بَابَا الِّي فِي السْمَاء هُوَّ خُويَا وأُخْتِي وأُمِّي». ");
INSERT INTO aeu_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","وفِي النْهَارْ هَاذَاكَا، خْرَجْ يَسُوعْ مِالدَّارْ وقْعَدْ عْلَى شَطْ البُحَيْرَة. ");
INSERT INTO aeu_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","وتْلَمُّوا بِيهْ بَرْشَة نَاسْ، حَتَّى لِينْ تْلَزْ يِطْلَعْ فِي فْلُوكَة ويُقْعُدْ فِيهَا، والنَّاسْ الكُلْ بْقَاوْ وَاقْفِينْ عَالشَّطْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","وكَلَّمْهُمْ فِي بَرْشَة أُمُورْ بِالأَمْثَالْ، وقَالْ: «خْرَجْ الفَلَّاحْ بَاشْ يَزْرَعْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","وهُوَّ قَاعِدْ يَزْرَعْ، جَاتْ شْوَيَّة مِالزَرِّيعَة عَالطْرِيقْ، يَاخِي جَاتْ العْصَافِرْ وكْلَاتْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","وشْوَيَّة أُخْرَى جَاتْ فِي أَرْضْ مْحَجْرَة مَا فِيهَاشْ بَرْشَة تْرَابْ، يَاخِي نِبْتِتْ فِيسَعْ عْلَى خَاطِرْ التْرَابْ مَا كَانِشْ غَارَقْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","وكِي طَلْعِتْ الشَّمْسْ تْحَرْقِتْ ويِبْسِتْ خَاطِرْهَا بْلَاشْ عْرُوقْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","وجَاتْ زَرِّيعَة أُخْرَى وِسْطْ الشُّوكْ، وكِي كْبِرْ الشُّوكْ خْنَقْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","وفَمَّة زَرِّيعَة جَاتْ فِي تُرْبَة بَاهْيَة يَاخِي ثُمْرِتْ، مِنْهَا الِّي جَابِتْ 100 ومِنْهَا الِّي جَابِتْ 60 ومِنْهَا الِّي جَابِتْ 30. ");
INSERT INTO aeu_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ!». ");
INSERT INTO aeu_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","يَاخِي قُرْبُولُو تْلَامِذْتُو وسِأْلُوهْ: «عْلَاشْ تْكَلِّمْ فِيهُمْ بِالأَمْثَالْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","جَاوِبْهُمْ: «إِنْتُومَا تِعْطَالْكُمْ بَاشْ تَعْرْفُوا أَسْرَارْ مَمْلَكْةْ السْمَاوَاتْ، آمَا هُومَا مَا تِعْطَالْهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","الِّي عَنْدُو، بِشْ يِتْعْطَالُو أَكْثِرْ ويْوَلِّي عَنْدُو بْزَايِدْ. آمَا الِّي مَا عَنْدُوشْ، حَتَّى الشْوَيَّة الِّي عَنْدُو يِتْفَكُّولُو. ");
INSERT INTO aeu_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","هَاذَاكَا عْلَاشْ آنَا نْكَلِّمْ فِيهُمْ بِالأَمْثَالْ عْلَى خَاطِرْهُمْ يُخْزْرُوا ومَا يْشُوفُوشْ ويِسْمْعُوا ومَا يِفْهْمُوشْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","وهُومَا الِّي تْحَقْقِتْ فِيهُمْ نُبُوِّةْ إِشَعْيَاءْ الِّي تْقُولْ: \"مَهْمَا سْمَعْتُوا، مَاكُمْشْ بِشْ تِفِهْمُوا، ومَهْمَا خْزَرْتُوا، مَاكُمْشْ بِشْ تْشُوفُوا. ");
INSERT INTO aeu_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","عْلَى خَاطِرْ الشَّعْبْ هَاذَا قَلْبُو كْسَاحْ، وسَمَعْهُمْ ثْقُلْ، وغَمْضُوا عِينِيهُمْ، بَاشْ مَا يْشُوفُوشْ بْعِينِيهُمْ، ومَا يِسْمْعُوشْ بْوِذْنِيهُمْ، ومَا يِفْهْمُوشْ بِقْلُوبْهُمْ، ومَا يْتُوبُوشْ بَاشْ نِشْفِيهُمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","«آمَا إِنْتُومَا صَحَّة لِيكُمْ عْلَى خَاطِرْ عِينِيكُمْ تُخْزِرْ ووِذْنِيكُمْ تِسْمَعْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","نْقُلْكُمْ الحَقْ: بَرْشَة أَنْبِيَاءْ وصَالْحِينْ تْمَنَّاوْ يْشُوفُوا الِّي إِنْتُومَا تْشُوفُوا فِيهْ ومَا شَافُوهِشْ، ويِسْمْعُوا الِّي إِنْتُومَا تِسْمْعُوا فِيهْ ومَا سَمْعُوهِشْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«مَالَا إِسْمْعُوا إِنْتُومَا شْنُوَّة المَقْصُودْ بْمَثَلْ الفَلَّاحْ: ");
INSERT INTO aeu_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","الزَّرِّيعَة الِّي جَاتْ عَالطْرِيقْ، هِيَّ كُلْ مِنْ يِسْمَعْ كِلْمِةْ مَمْلَكْةْ اللَّهْ ومَا يِفْهِمْهَاشْ، يْجِي إِبْلِيسْ ويَخْطِفْ الِّي تِزْرَعْ فِي قَلْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","«ولِّي تِزْرَعّْ فِي الأَرْضْ المْحَجْرَة، هُوَّ الِّي يِسْمَعْ الكِلْمَة وبِالوَقْتْ يِقْبِلْهَا وهُوَّ فَرْحَانْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","وعْلَى خَاطِرْ مَا عَنْدْهَاشْ عْرُوقْ مَا تْدُومِشْ. ودُوبْ مَا يْجِي وَقْتْ صْعِيبْ وَلَّا إِضْطِهَادْ عْلَى خَاطِرْ كِلْمَة اللَّهْ، يْسَلِّمْ فِيهَا بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","«ولِّي تِزْرَعّْ وِسْطْ الشُّوكْ، هُوَّ الِّي يِسْمَعْ كِلْمِةْ اللَّهْ، آمَا هْمُومْ الزْمَانْ هَاذَا ومْحَبِّةْ الفْلُوسْ يُخْنْقُوهَا ومَا تُثْمُرْشْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","«آمَا الِّي تِزْرَعّْ فِي الأَرْضْ البَاهْيَة، هُوَّ الِّي يِسْمَعْ كِلْمِةْ اللَّهْ ويِفْهِمْهَا وتُثْمُرْ فِيهْ، وفَمَّة الِّي تْجِيبْ 100 وفَمَّة الِّي تْجِيبْ 60 وفَمَّة الِّي تْجِيبْ 30». ");
INSERT INTO aeu_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","وعْطَاهُمْ يَسُوعْ مَثَلْ آخِرْ وقَالْ: «مَمْلِكْةْ السْمَاوَاتْ هِيَّ كِيفْ رَاجِلْ زْرَعْ زَرِّيعَة بَاهْيَة فِي السَّانْيَة مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ووَقْتِلِّي كَانُوا النَّاسْ رَاقْدِينْ، جَاء عْدُوهْ وزْرَعْ زِيوَانْ فِي وِسْطْ القَمْحْ ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ووَقْتِلِّي القَمْحْ نْبِتْ وعْمَلْ السْبُولْ، نْبِتْ مْعَاهْ الزِّيوَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","وجَاوْ خَدَّامِةْ مُولَى الأَرْضْ وقَالُولُو: \"يَا سِيدْنَا، يَاخِي مُشْ زْرَعْتْ زَرِّيعَة بَاهْيَة فِي أَرْضِكْ؟ مَالَا مْنِينْ جَاهَا الزِّيوَانْ؟\" ");
INSERT INTO aeu_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","وهُوَّ جَاوِبْهُمْ: \"عْدُوْ هُوَّ الِّي عْمَلْ هَاذَا\". يَاخِي سِأْلُوهْ: \"تْحِبْ نِمْشِيوْ نْقَلْعُوهْ الزِّيوَانْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","وجَاوِبْهُمْ: \"لَا، بَاشْ مَا تْقَلْعُوشْ القَمْحْ وإِنْتُومَا تْقَلْعُوا فِي الزِّيوَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","خَلِّيوْهُمْ الزُّوزْ يِكْبْرُوا مْعَ بْعَضْهُمْ لِينْ يْجِي وَقْتْ الحْصَادْ، ووَقْتْهَا نْقُولْ لِلْحَصَّادَة: لِمُّوا الزِّيوَانْ قْبَلْ فِي رْزِمْ وأَحْرْقُوهْ، آمَا القَمْحْ لِمُّوهْ وحُطُّوهْ فِي المَخْزِنْ مْتَاعِي\"». ");
INSERT INTO aeu_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","وعْطَاهُمْ مَثَلْ آخِرْ، وقَالْ: «مَمْلَكْةْ السْمَاوَاتْ هِيَّ كِيفْ حَبِّةْ الخَرْدِلْ الِّي هَزْهَا رَاجِلْ وزْرَعْهَا فِي السَّانْيَة مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","رَغْمِلِّي هِيَّ أَصْغِرْ وَحْدَة فِي الزَّرِّيعَة الكُلْ، آمَا كِي تَبْدَى تِكْبِرْ تْوَلِّي أَكْبِرْ نَبْتَة فِي نَبْتَاتْ الجْنِينَة الكُلْ، ومْبَعِّدْ تْوَلِّي شَجْرَة، وحَتَّى العْصَافِرْ تْجِي وتْعَشِّشْ فِي فْرُوعْهَا». ");
INSERT INTO aeu_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","وقَالِلْهُمْ مَثَلْ آخِرْ: «مَمْلَكْةْ السْمَاوَاتْ هِيَّ كِيفْ خْمِيرَة هَزِّتْهَا مْرَا وحَطِّتْهَا فِي ثْلَاثَة كْيَالْ فَرِينَة حَتَّى لِينْ خْمِرْ العْجِينْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","هَاذَا الكُلْ قَالُو يَسُوعْ لِلنَّاسْ بِالأَمْثَالْ. وكَانْ مَا يَحْكِي مْعَاهُمْ كَانْ بِالأَمْثَالْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","بَاشْ يِتْحَقَّقْ الِّي قَالُو اللَّهْ عْلَى طْرِيقْ النَّبِيْ: «بِالأَمْثَالْ بِشْ نِتْكَلِّمْ، ونِكْشِفْ الِّي كَانْ مْخُبِّي مِلِّي تْخَلْقِتْ الدِّنْيَا». ");
INSERT INTO aeu_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ومْبَعِّدْ بْعَثْ يَسُوعْ النَّاسْ يْرَوْحُوا، ورْجَعْ هُوَّ لِلدَّارْ، وجَاوْ تْلَامِذْتُو وقَالُولُو: «فَسْرِلْنَا المَثَلْ مْتَاعْ الزِّيوَانْ». ");
INSERT INTO aeu_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","يَاخِي جَاوِبْهُمْ: «الِّي زْرَعْ الزَّرِّيعَة البَاهْيَة هُوَّ إِبْنْ الإِنْسَانْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","والأَرْضْ المَزْرُوعَة هِيَّ الدِّنْيَا هَاذِي، والزَّرِّيعَة البَاهْيَة هُومَا وْلَادْ مَمْلَكْةْ اللَّهْ، والزِّيوَانْ هُومَا وْلَادْ إِبْلِيسْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","والعْدُو الِّي زْرَعْ الزِّيوَانْ هُوَّ إِبْلِيسْ، والحْصَادْ هُوَّ آخِرْ الزْمَانْ، والحَصَّادَة هُومَا المْلَايْكَة. ");
INSERT INTO aeu_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","وكِيمَا يِتْقَلَّعْ الزِّيوَانْ ويِتْحْرَقْ بِالنَّارْ، هَكَّاكَا بِشْ يْصِيرْ فِي آخِرْ الزْمَانْ: ");
INSERT INTO aeu_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","يَبْعَثْ إِبْنْ الإِنْسَانْ مْلَايِكْتُو، بَاشْ يْخَرْجُوا مِنْ مَمْلَكْتُو كُلْ الِّي عْمَلُوا الشَّرْ وكُلْ الِّي كَانُوا سْبَبْ فِيهْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ويَرْمِيوْهُمْ فِي النَّارْ، وِينْ بِشْ يْكُونْ البْكَاء والنْدَمْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","آمَا الصَّالْحِينْ، بِشْ يِضْوِيوْ كِي الشَّمْسْ فِي مَمْلَكْةْ بُوهُمْ. الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ! ");
INSERT INTO aeu_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«مَمْلَكْةْ السْمَاوَاتْ هِيَّ كِيمَا كِنْزْ مَدْفُونْ فِي سَانْيِة، لْقَاهْ رَاجِلْ وخَبَّاهْ، ومِالفَرْحَة مْشَى بَاعْ كُلْ مَا يِمْلِكْ وشْرَى السَّانْيَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«وزَادَا مَمْلَكْةْ السْمَاوَاتْ هِيَّ كِيفْ تَاجِرْ يْلَوِّجْ عَالجُوهِرْ الغَالِي. ");
INSERT INTO aeu_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","وكِي لْقَى قَطْعَة جُوهِرْ غَالْيَة بَرْشَة، مْشَى وبَاعْ كُلْ مَا يِمْلِكْ وشْرَاهَا. ");
INSERT INTO aeu_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«وزَادَا مَمْلَكْةْ السْمَاوَاتْ هِيَّ كِيفْ شَبْكَة رْمَاوْهَا فِي البْحَرْ ولَمِّتْ حُوتْ مِنْ كُلْ نَوْعْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","وكِي تِمْلَاتْ خَرْجُوهَا الصَّيَّادَة لِلشَّطْ وقَعْدُوا، والحُوتْ البَاهِي حَطُّوهْ فِي قْفَافْ والخَايِبْ رْمَاوَهْ. ");
INSERT INTO aeu_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","وهَكَّاكَا بِشْ يْصِيرْ فِي آخِرْ الزْمَانْ: يْجِيوْ المْلَايْكَة ويْخَرْجُوا النَّاسْ الأَشْرَارْ مِنْ بِينْ النَّاسْ الصَّالْحِينْ، ");
INSERT INTO aeu_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ويَرْمِيوْهُمْ فِي النَّارْ، وِينْ بِشْ يْكُونْ البْكَاء والنْدَمْ». ");
INSERT INTO aeu_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","وسْإِلْ يَسُوعْ تْلَامِذْتُو: « فْهِمْتُوا الأُمُورْ هَاذِي الكُلْ؟». جَاوْبُوهْ: «إِيْ نْعَمْ». ");
INSERT INTO aeu_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","يَاخِي قَالِلْهُمْ: «هَاذَاكَا عْلَاشْ أَيْ عَالِمْ فِي الشَّرِيعَة كِيفْ يْوَلِّي تِلْمِيذْ فِي مَمْلَكْةْ السْمَاوَاتْ، هُوَّ كِيفْ مُولَى الدَّارْ الِّي يْخَرِّجْ مِالمَخْزِنْ مْتَاعُو كْنُوزْ جْدِيدَة وكْنُوزْ قْدِيمَة». ");
INSERT INTO aeu_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","وبَعْدْمَا كَمِّلْ يَسُوعْ الأَمْثَالْ هَاذِي، مْشَى مِالبْلَاصَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ورْجَعْ لِبْلَادُو، وبْدَا يْعَلِّمْ فِيهُمْ فِي مَعْبِدْ اليْهُودْ، يَاخِي بِهْتُوا وقَالُوا: «مْنِينْ لِيهْ الحِكْمَة والمُعْجْزَاتْ هَاذِي؟ ");
INSERT INTO aeu_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","يَاخِي مُشْ هَاذَا وِلْدْ النَّجَّارْ؟ مُشْ أُمُّو إِسْمْهَا مَرْيِمْ وخْوَاتُو هُومَا يَعْقُوبْ ويُوسِفْ وسِمْعَانْ ويَهُوذَا؟ ");
INSERT INTO aeu_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ومُشْ خْوَاتُو البْنَاتْ عَايْشِنْ بِينَاتْنَا؟ مْنِينْ لِيهْ هَاذَا الكُلْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","هَاذَاكَا عْلَاشْ مَا حَبُّوشْ يِقْبْلُوهْ. يَاخِي يَسُوعْ قَالِلْهُمْ: «النَّبِيْ مَا عَنْدُوشْ كَرَامَة فِي بْلَادُو وبِينْ أَهْلُو ونَاسُو». ");
INSERT INTO aeu_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ومَا عْمَلْشْ بَرْشَة مُعْجْزَاتْ غَادِي بِسْبَبْ قِلِّةْ إِيمَانْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","فِي الوَقْتْ هَاذَاكَا سْمَعْ هِيرُودُسْ الوَالِي أَخْبَارْ يَسُوعْ، ");
INSERT INTO aeu_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","وقَالْ لْخُدَّامُو: «هَاذَا يُوحَنَّا الِّي يْعَمِّدْ قَامْ مِالمُوتْ، هَاذَاكَا عْلَاشْ قَاعِدْ يَعْمِلْ فِي المُعْجْزَاتْ». ");
INSERT INTO aeu_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","عْلَى خَاطِرْ هِيرُودُسْ قْبَلْ شَدْ يُوحَنَّا وكَتْفُو وحَطُّو فِي الحَبْسْ بِسْبَبْ هِيرُودِيَّا مَرْتْ فِيلِۑُّسْ خُوهْ، ");
INSERT INTO aeu_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","عْلَى خَاطِرْ يُوحَنَّا كَانْ يْقُلُّو: «مَا عَنْدِكْشْ الحَقْ تْعَرِّسْ بِيهَا». ");
INSERT INTO aeu_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","وحَبْ يُقْتْلُو، آمَا خَافْ مِالشَّعْبْ، عْلَى خَاطِرْ يُوحَنَّا كَانْ بِالنِّسْبَة لِيهُمْ نَبِيْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","وفِي عِيدْ مِيلَادْ هِيرُودُسْ، شَطْحِتْ بِنْتْ هِيرُودِيَّا فِي الحَفْلَة قُدَّامْ الضْيُوفْ، يَاخِي عِجْبِتْ هِيرُودُسْ، ");
INSERT INTO aeu_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","وحْلِفْ بِشْ يَعْطِيهَا أَيْ حَاجَة تُطْلُبْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","وبَعْدْمَا شَاوْرِتْ أُمْهَا قَالِتْ لْهِيرُودُسْ: «أَعْطِينِي رَاسْ يُوحَنَّا الِّي يْعَمِّدْ عْلَى طْبَقْ!». ");
INSERT INTO aeu_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","حْزِنْ المَلِكْ، آمَا عْلَى خَاطِرْ اليْمِينْ الِّي حَلْفُو قُدَّامْ ضْيُوفُو، عْطَى أَمْرْ بَاشْ يَعْطِيوْهَا الِّي حَبِّتْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","وبْعَثْ سَيَّافْ لِلْحَبْسْ، قَصْ رَاسْ يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","وجَابُو فِي طْبَقْ وعْطَاهْ لِلْبْنَيَّة، وهِيَّ هَزِّتُو لْأُمْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","وجَاوْ تْلَامِذْةْ يُوحَنَّا وهَزُّوا بَدْنُو ودِفْنُوهْ، ومْشَاوْ خَبْرُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","وكِي سْمَعْ يَسُوعْ بِالحْكَايَة، رْكِبْ فِي فْلُوكَة ومْشَى وَحْدُو لِبْلَاصَة خَالْيَة. وكِي النَّاسْ سَمْعُوا بِيهْ، تَبْعُوهْ عْلَى سَاقِيهُمْ مِنْ كُلْ مْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","وكِي هْبَطْ مِالفْلُوكَة، شَافْ بَرْشَة نَاسْ، يَاخِي حَنْ عْلِيهُمْ وشْفَى كُلْ وَاحِدْ مْرِيضْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","وفِي العْشِيَّة، جَاوَهْ تْلَامِذْتُو وقَالُولُو: «النْهَارْ وْفَى، والبْلَاصَة هَاذِي خَالْيَة، أَبْعِثْ النَّاسْ يِمْشِيوْ لِلدْشُرْ ويِشْرِيوْ حَاجَة يَاكْلُوهَا». ");
INSERT INTO aeu_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","آمَا يَسُوعْ قَالِلْهُمْ: «مُشْ لَازِمْ يِمْشِيوْ. إِنْتُومَا أَعْطِيوْهُمْ يَاكْلُوا». ");
INSERT INTO aeu_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","يَاخِي قَالُولُو: «مَا عَنْدْنَا هْنَا كَانْ خَمْسَة خُبْزَاتْ وحُوتِّينْ». ");
INSERT INTO aeu_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","قَالْ يَسُوعْ: «جِيبُوهُمْلِي». ");
INSERT INTO aeu_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","وعْطَى أَمْرْ لِلنَّاسْ بَاشْ يُقْعْدُوا عَالحْشِيشْ، وخْذَا الخَمْسَة خُبْزَاتْ والحُوتِّينْ، وهَزْ عِينِيهْ لِلسْمَاء، وشْكَرْ اللَّهْ وقْسِمْ الخُبْزَاتْ وعْطَاهُمْ لِلتْلَامْذَة، والتْلَامْذَة فَرْقُوهُمْ عَالنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","والنَّاسْ كْلَاوْ لِينْ شَبْعُوا. والتْلَامْذَة هَزُّوا أَثْنَاشِنْ قُفَّة مْعَبْيَة مِلِّي فْضُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","والنَّاسْ الِّي كْلَاوْ كَانُوا قْرَابِةْ 5 000 رَاجِلْ، بِخْلَافْ النْسَاء والصْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","وبَعْدْهَا بِالضَّبْطْ، طَلَّعْ تْلَامِذْتُو فِي الفْلُوكَة بَاشْ يِسْبْقُوهْ لِلشَّطْ الآخِرْ، حَتَّى لِينْ هُوَّ يَبْعَثْ النَّاسْ يْرَوْحُوا. ");
INSERT INTO aeu_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","وبَعْدْمَا بْعَثْ النَّاسْ يْرَوْحُوا، طْلَعْ وَحْدُو لِلجْبَلْ بَاشْ يْصَلِّي. وجَاء اللِّيلْ وهُوَّ لْغَادِي وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","والفْلُوكَة بِعْدِتْ عَالشَّطْ، وبْدَا المُوجْ يَضْرِبْ فِيهَا عْلَى خَاطِرْ الرِّيحْ كَانِتْ عَاكْسِتْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","وقْبَلْ الفَجْرْ جَاهُمْ يَسُوعْ يِمْشِي فُوقْ المَاء. ");
INSERT INTO aeu_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","وكِي شَافُوهْ تْلَامِذْتُو يِمْشِي فُوقْ المَاء تْرِعْبُوا وقَالُوا: «هَاذَا شَبَحْ!» وبْدَاوْ يْصِيحُوا مِالخُوفْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","وبِالوَقْتْ قَالِلْهُمْ يَسُوعْ: «اتْشَجْعُوا! رَانِي آنَا هُوَّ، مَا تْخَافُوشْ». ");
INSERT INTO aeu_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","يَاخِي بُطْرُسْ قَالُّو: «يَا سِيدِي، كَانِكْ إِنْتِ هُوَّ، أُأْمُرْنِي بَاشْ نْجِيكْ نِمْشِي فُوقْ المَاء». ");
INSERT INTO aeu_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","قَالُّو يَسُوعْ: «إِيجَا». يَاخِي خْرَجْ بُطْرُسْ مِالفْلُوكَة ومْشَى لْيَسُوعْ فُوقْ المَاء. ");
INSERT INTO aeu_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","وكِي شَافْ الرِّيحْ قْوِيَّة خَافْ، وبْدَا يُغْرُقْ، وقَامْ يْعَيِّطْ: «يَا سِيدِي، مَنَّعْنِي!» ");
INSERT INTO aeu_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","وبِالوَقْتْ مَدْ يَسُوعْ يِدُّو وشَدُّو وقَالُّو: «يَا قْلِيلْ الإِيمَانْ، عْلَاشْ شَكِّيتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","وكِي طَلْعُوا فِي الفْلُوكَة هْدَاتْ الرِّيحْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ولِّي فِي الفْلُوكَة سِجْدُولُو وقَالُوا: «بِالحَقْ إِنْتِ إِبْنْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","وشَقُّوا البُحَيْرَة لِينْ وُصْلُوا لْشَطْ جَنِّيسَارْتْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","وأَهْلْ المَنْطْقَة هَاذِيكَا عَرْفُوهْ، ونَشْرُوا الخْبَرْ فِي البْلَايِصْ الِّي دَايْرَة بِيهُمْ، يَاخِي جَابُولُو المُرْضَى الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","وطَلْبُوا مِنُّو يْخَلِّيهُمْ يْمِسُّوا حَتَّى طْرَاطِشْ حْوَايْجُو. ولِّي مَسُّوهْ الكُلْ تِشْفَاوْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","وجَاوْ جْمَاعَة مِالفِرِّيسِيِّينْ وعُلَمَاءْ الشَّرِيعَة لْيَسُوعْ مِنْ أُورْشَلِيمْ، وسِأْلُوهْ: ");
INSERT INTO aeu_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«عْلَاشْ تْلَامِذْتِكْ مَا يِحْتَرْمُوشْ العَادَاتْ الِّي فَرْضُوهَا الشْيُوخْ؟ ومَا يَغْسْلُوشْ يْدِيهُمْ قْبَلْ المَاكْلَة؟». ");
INSERT INTO aeu_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","جَاوِبْهُمْ: «وعْلَاشْ إِنْتُومَا مَا اطِّيعُوشْ وْصِيِّةْ اللَّهْ وشَادِّينْ صْحِيحْ فِي عَادَاتْكُمْ وتَقَالِيدْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","اللَّهْ قَالْ: \"إِكْرِمْ بُوكْ وأُمِّكْ، ولِّي يْسِبْ بُوهْ وَلَّا أُمُّو يِلْزْمُو يِتِقْتَلْ\". ");
INSERT INTO aeu_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","آمَا إِنْتُومَا تْقُولُوا: \"إِذَا وَاحِدْ قَالْ لْبُوهْ وَلَّا أُمُّو: الِّي كُنْتْ بِشْ نْعَاوْنِكْ بِيهْ رَانِي عْطِيتُو لِلَّهْ، ");
INSERT INTO aeu_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","يْوَلِّي مَعْفِي، ومُشْ لَازِمْ يْعَاوِنْ بُوهْ وَلَّا أُمُّو\". وهَكَّا خَالِفْتُوا وْصِيِّةْ اللَّهْ عْلَى خَاطِرْ تَقَالِيدْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","يَا مُنَافْقِينْ، صْدُقْ إِشَعْيَاءْ وَقْتِلِّي تْنَبَّأْ عْلِيكُمْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","\"الشَّعْبْ هَاذَا يِكْرِمْنِي بْفُمُّو، آمَا قَلْبُو بْعِيدْ عْلِيَّا. ");
INSERT INTO aeu_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","عْبَادِتْهُمْ لِيَّا بَاطْلَة، وقَاعْدِينْ يْعَلْمُوا فِي وْصَايَا حَطُّوهَا النَّاسْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ومْبَعِّدْ عَيِّطْ يَسُوعْ لِلنَّاسْ وقَالِلْهُمْ: «إِسْمْعُوا وإِفْهْمُوا: ");
INSERT INTO aeu_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","مُشْ الِّي يُدْخُلْ لِلْفُمْ يْنَجِّسْ الإِنْسَانْ، آمَا الِّي يُخْرُجْ مِالفُمْ هُوَّ الِّي يْنَجِّسْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","يَاخِي جَاوُوهْ تْلَامِذْتُو وقَالُوا: «فِي بَالِكْ الِّي كْلَامِكْ هَاذَا غَشِّشْ الفِرِّيسِيِّينْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","جَاوِبْهُمْ: «كُلْ زَرْعْ مَا زَرْعُوشْ بَابَا الِّي فِي السْمَاء يِتْقَلَّعْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","إِبْعْدُوا عْلِيهُمْ! هُومَا عِمْيَانْ يْقُودُوا فِي عِمْيَانْ. وإِذَا كَانْ أَعْمَى يْقُودْ أَعْمَى، الإِثْنِينْ يْطِيحُوا فِي حُفْرَة». ");
INSERT INTO aeu_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","يَاخِي قَالُّو بُطْرُسْ: «فَسْرِلْنَا المَثَلْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","جَاوِبْ يَسُوعْ: « إِنْتُومَا زَادَا لْتَوَّا مَا تِفْهْمُوشْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","يَاخِي مَا تَعْرْفُوشْ الِّي أَيْ مَاكْلَة تُدْخُلْ مِالفُمْ تَهْبِطْ لِلْكِرْشْ، ومْبَعِّدْ تُخْرُجْ مِالبْدَنْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","آمَا الِّي يُخْرُجْ مِالفُمْ، هُوَّ جَايْ مِالقَلْبْ، وهَاذَا الِّي يْنَجِّسْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","عْلَى خَاطِرْ مِالقَلْبْ تْجِي الأَفْكَارْ الشِّرِّيرَة: القَتْلْ والزْنَى والفْسَادْ والسِّرْقَة وشْهَادِةْ الزُّورْ والتَّقْطِيعْ والتَّرْيِيشْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","وهَاذِي هِيَّ الحَاجَاتْ الِّي تْنَجِّسْ الإِنْسَانْ. آمَا المَاكْلَة بِيدِينْ مُشْ مَغْسُولَة مَا تْنَجِّسْشْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","وخْرَجْ يَسُوعْ مِنْ غَادِي ومْشَى لْشِيرِةْ صُورْ وصَيْدَا. ");
INSERT INTO aeu_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","وجَاتُو مْرَا كَنْعَانِيَّة مِالمَنْطْقَة هَاذِيكَا وبْدَاتْ تْعَيِّطْ: «يَا سِيدِي، يَا وِلْدْ دَاوِدْ، أَرْحَمْنِي! بِنْتِي سَاكِنْهَا شِيطَانْ ومْعَذَّبْهَا بَرْشَة». ");
INSERT INTO aeu_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","آمَا هُوَّ مَا جَاوِبْهَا بْحَتَّى كِلْمَة. وجَاوْ تْلَامِذْتُو ولَحُّوا عْلِيهْ وقَالُوا: «بَعَّدْهَا عْلِينَا، رَاهِي قَاعْدَة تْعَيِّطْ وْرَانَا». ");
INSERT INTO aeu_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","جَاوِبْهُمْ: «آنَا مَا بْعَثْنِي اللَّهْ كَانْ لِغْنَمْ بَنِي إِسْرَائِيلْ الضَّايْعَة». ");
INSERT INTO aeu_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","آمَا المْرَا، جَاتْ وسِجْدِتْ قُدَّامُو وقَالِتْ: «يَا سِيدِي، عَاوِنِّي!». ");
INSERT INTO aeu_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","يَاخِي جَاوِبْهَا: «مَا يْجِيشْ نَاخْذُوا خُبْزْ الصْغَارْ ونَرْمِيوَهْ لِلْكْلَابْ». ");
INSERT INTO aeu_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","قَالِتْلُو: «صْحِيحْ يَا سِيدِي! آمَا حَتَّى الكْلَابْ تَاكِلْ مِالفِتْفَاتْ الِّي يْطِيحْ مِنْ طَاوِلْةْ أَسْيَادْهَا». ");
INSERT INTO aeu_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","جَاوِبْهَا يَسُوعْ: «يَا مْرَا، إِيمَانِكْ عْظِيمْ! خَلِّي الِّي طْلَبْتُو يْكُونْ لِيكْ». وفِي لَحْظِتْهَا بِنْتْهَا تِشْفَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ومْبَعِّدْ مْشَى يَسُوعْ مِنْ غَادِي وجَاء لْشَطْ بُحَيْرِةْ الجَلِيلْ، وطْلَعْ لِلجْبَلْ وقْعَدْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","يَاخِي جَاوَهْ بَرْشَة نَاسْ وجَابُوا مْعَاهُمْ نَاسْ عَايْبِينْ ومَشْلُولِينْ وعِمْيَانْ وبْكَاكِشْ وبَرْشَة أُخْرِينْ، وحَطُّوهُمْ قُدَّامْ سَاقِيهْ وهُوَّ شْفَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","وتْعَجْبُوا النَّاسْ كِي شَافُوا البْكَاكِشْ يِتْكَلْمُوا، والمَشْلُولِينْ تِشْفَاوْ، والعَايْبِينْ يِمْشِيوْ، والعِمْيَانْ يْشُوفُوا. ومَجْدُوا إِلَاهْ إِسْرَائِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","وعَيِّطْ يَسُوعْ لِتْلَامِذْتُو وقَالِلْهُمْ: «النَّاسْ هَاذُومَا غَايْضِينِّي، عْلَى خَاطِرْهُمْ بْقَاوْ مْعَايَا ثْلَاثَة أَيَّامْ ومَا عَنْدْهُمْشْ مَا يَاكْلُوا. ومَا نْحِبِّشْ نَبْعَثْهُمْ يْرَوْحُوا وهُومَا جْوَاعَى بَاشْ مَا يَعْيَاوِشْ فِي الثْنِيَّة». ");
INSERT INTO aeu_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","يَاخِي قَالُولُو التْلَامْذَة: «فِي الخْلَاء هَاذَا، مْنِينْ بِشْ نْجِيبُوا خُبْزْ يْكَفِّي النَّاسْ هَاذُومَا الكُلْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","قَالِلْهُمْ يَسُوعْ: «قَدَّاشْ عَنْدْكُمْ مِنْ خُبْزَة؟». قَالُوا: «سَبْعَة خُبْزَاتْ وكْعِيبَاتْ حُوتْ صْغَارْ». ");
INSERT INTO aeu_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","يَاخِي طْلَبْ يَسُوعْ مِالنَّاسْ بَاشْ يُقْعْدُوا عَالأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","وخْذَا السَّبْعَة خُبْزَاتْ وكْعِيبَاتْ الحُوتْ، وشْكَرْ وقْسِمْهُمْ وعْطَاهُمْ لِلتْلَامْذَة، والتْلَامْذَة عْطَاوْ لِلنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","وكْلَاوْ الكُلْ حَتَّى لِينْ شَبْعُوا، وهَزُّوا التْلَامْذَة سَبْعَة قْفَافْ كْبَارْ مِلْيَانِينْ بِالخُبْزْ الِّي فْضُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ولِّي كْلَاوْ كَانْ عْدَدْهُمْ 4 000 رَاجِلْ، بِخْلَافْ النْسَاء والصْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","وبَعْدْمَا يَسُوعْ مَشَّى النَّاسْ، طْلَعْ فِي الفْلُوكَة ومْشَى لْمَنْطَقْةْ مَجْدَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","وجَاوَهْ الفِرِّيسِيِّينْ والصَّدُّوقِيِّينْ بَاشْ يْجَرْبُوهْ، وطَلْبُوا مِنُّو بَاشْ يْوَرِّيهُمْ مُعْجْزَة مِالسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","يَاخِي جَاوِبْهُمْ يَسُوعْ: «كِي تَبْدَى السْمَاء حَمْرَاء وَقْتْ المُغْرُبْ، تْقُولُوا: \"غُدْوَة الطَّقْسْ بِشْ يْجِي بَاهِي\". ");
INSERT INTO aeu_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","وكَانْ صَبْحِتْ السْمَاء حَمْرَاء ومْغَيْمَة، تْقُولُوا: \"اليُومْ المْطَرْ بِشْ تْصُبْ!\". إِنْتُومَا تَعْرْفُوا كِيفَاشْ تْفَسْرُوا مَنْظِرْ السْمَاء، آمَا عَلَامَاتْ الزْمَانْ مَا تَعْرْفُوشْ تْفَسْرُوهَا! ");
INSERT INTO aeu_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","جِيلْ شِرِّيرْ وفَاسَقْ يُطْلُبْ فِي مُعْجْزَة، آمَا مَاهِيشْ بِشْ تِتْعْطَالُو كَانْ مُعْجْزِةْ يُونَانْ». وخَلَّاهُمْ ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","وكِي وُصْلُوا التْلَامْذَة لِلشَّطْ المْقَابِلْ، ظُهْرُوا نْسَاوْ بَاشْ يْهِزُّوا مْعَاهُمْ خُبْزْ. ");
INSERT INTO aeu_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","قَالِلْهُمْ يَسُوعْ: «فِيقُوا، ورُدُّوا بَالْكُمْ مِنْ خْمِيرِةْ الفِرِّيسِيِّينْ والصَّدُّوقِيِّينْ». ");
INSERT INTO aeu_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","يَاخِي بْدَاوْ يِتْنَاقْشُوا بِينْ بْعَضْهُمْ ويْقُولُوا: «هَاذَا عْلَى خَاطِرْ مَا عَنْدْنَاشْ خُبْزْ». ");
INSERT INTO aeu_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","وعْرَفْ يَسُوعْ فَاشْ يَحْكِيوْ يَاخِي قَالِلْهُمْ: «يَلِّي إِيمَانْكُمْ ضْعِيفْ، عْلَاشْ تِتْنَاقْشُوا وتْقُولُوا: مَا عَنْدْنَاشْ خُبْزْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","يَاخِي لْتَوَّا لَا فْهِمْتُوا؟ نْسِيتُوا الخَمْسَة خُبْزَاتْ الِّي شَبْعُوا الـ5 000 وقَدَّاشْ مِنْ قُفَّة هَزِّيتُوا مِلِّي فْضُلْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","وَلَّا السَّبْعَة خُبْزَاتْ الِّي شَبّْعِتْ الـ4 000 وقَدَّاشْ مِنْ قُفَّة مْعَبْيَة هَزِّيتُوا؟ ");
INSERT INTO aeu_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","كِيفَاشْ مَا فْهِمْتُوشْ الِّي آنَا مَانِيشْ نَحْكِي عَالخُبْزْ كِي قُلْتِلْكُمْ: رُدُّوا بَالْكُمْ مِنْ خْمِيرِةْ الفِرِّيسِيِّينْ والصَّدُّوقِيِّينْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","وَقْتْهَا فِهْمُوا التْلَامْذَة الِّي هُوَّ قَالِلْهُمْ رُدُّوا بَالْكُمْ مِنْ تَعْلِيمْ الفِرِّيسِيِّينْ والصَّدُّوقِيِّينْ مُشْ مِنْ خْمِيرِةْ الخُبْزْ. ");
INSERT INTO aeu_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","وَقْتِلِّي وْصُلْ يَسُوعْ لْمَنْطَقْةْ قَيْصَرِيِّةْ فِيلِۑُّسْ، سْإِلْ تْلَامِذْتُو: «حَسْبْ رَايْ النَّاسْ شْكُونِي آنَا إِبْنْ الإِنْسَانْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","جَاوْبُوهْ: «فِيهُمْ شْكُونْ يْقُولْ الِّي إِنْتِ يُوحَنَّا الِّي يْعَمِّدْ، وأُخْرِينْ يْقُولُوا الِّي إِنْتِ إِيلِيَّا، وغِيرْهُمْ يْقُولْ الِّي إِنْتِ إِرْمِيَا وَلَّا وَاحِدْ مِالأَنْبِيَاءْ». ");
INSERT INTO aeu_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","سْإِلْهُمْ: «وحَسْبْ رَايْكُمْ إِنْتُومَا آنَا شْكُونْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","جَاوِبْ سِمْعَانْ بُطْرُسْ: «إِنْتِ المَسِيحْ إِبْنْ اللَّهْ الحَيْ». ");
INSERT INTO aeu_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","قَالُّو يَسُوعْ: «صَحَّة لِيكْ، يَا سِمْعَانْ وِلْدْ يُونَا. الِّي كْشِفْلِكْ الحْقِيقَة هَاذِي مُشْ بَشَرْ، آمَا بَابَا الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","وآنَا نْقُلِّكْ: إِنْتِ بُطْرُسْ، وعَالحَجْرَة هَاذِي نِبْنِي كْنِيسْتِي، وبِيبَانْ الهَاوْيَة مُشْ بِشْ تَقْوَى عْلِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","بِشْ نَعْطِيكْ مْفَاتَحْ مَمْلَكْةْ السْمَاوَاتْ، وكُلْ الِّي تُرْبْطُو فِي الأَرْضْ يْكُونْ مَرْبُوطْ فِي السْمَاء، ولِّي تْحِلُّو فِي الأَرْضْ يْكُونْ مَحْلُولْ فِي السْمَاء». ");
INSERT INTO aeu_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","وبَعْدْهَا نَبَّهْ عْلَى تْلَامِذْتُو بَاشْ مَا يْقُولُوا لْحَدْ الِّي هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ومِنْ وَقْتْهَا بْدَا يَسُوعْ يْفَهَّمْ فِي تْلَامِذْتُو الِّي هُوَّ يِلْزْمُو يِمْشِي لْأُورْشَلِيمْ، ويِتْعَذَّبْ عْلَى يْدِينْ الشْيُوخْ وكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة، ويِتْقْتَلْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ. ");
INSERT INTO aeu_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","وجِبْدُو بُطْرُسْ عْلَى جْنَبْ وبْدَا يْلُومْ عْلِيهْ وقَالُّو: «حَاشَاكْ يَا سِيدِي! هَاذَا مُشْ بِشْ يْصِيرْلِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","آمَا يَسُوعْ تْلَفِّتْ لْبُطْرُسْ وقَالُّو: «إِبْعِدْ عْلِيَّا يَا إِبْلِيسْ! إِنْتِ تْعَطِّلْ فِيَّا، عْلَى خَاطْرِكْ تْفَكِّرْ كِيفْ النَّاسْ مُشْ كِيفْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","وبَعْدْهَا قَالْ يَسُوعْ لِتْلَامِذْتُو: «الِّي يْحِبْ يْتَبَّعْنِي، يِلْزْمُو يُنْكُرْ رُوحُو ويْشَارِكْنِي فِي العْذَابْ والمُوتْ، ");
INSERT INTO aeu_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","عْلَى خَاطِرْ الِّي يْحِبْ يْمَنَّعْ حْيَاتُو يَخْسَرْهَا، ولِّي يَخْسَرْ حْيَاتُو عْلَى خَاطْرِي يَلْقَاهَا. ");
INSERT INTO aeu_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","شْنِيَّة الفَايْدَة كَانْ الإِنْسَانْ يِرْبَحْ العَالِمْ الكُلْ ويَخْسَرْ رُوحُو؟ وشْنِيَّة يْنَجِّمْ يَعْطِي الإِنْسَانْ بَاشْ يِفْدِي رُوحُو؟ ");
INSERT INTO aeu_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ بِشْ يْجِي مْعَ مْلَايِكْتُو فِي مَجْدْ بُوهْ، ووَقْتْهَا يْجَازِي كُلْ وَاحِدْ عْلَى حَسْبْ أَعْمَالُو. ");
INSERT INTO aeu_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","نْقُلْكُمْ الحَقْ: فَمَّة شْكُونْ مِالوَاقْفِينْ هْنَا مَاهُمْشْ بِشْ يْذُوقُوا المُوتْ، إِلَّا بَعْدْمَا يْشُوفُوا إِبْنْ الإِنْسَانْ جَايْ فِي مَمْلَكْتُو». ");
INSERT INTO aeu_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","وبَعْدْ سِتَّة أَيَّامْ هَزْ يَسُوعْ بُطْرُسْ ويَعْقُوبْ ويُوحَنَّا خُوهْ، وطْلَعْ بِيهُمْ لِجْبَلْ عَالِي وَحَّدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","وتْبَدْلِتْ هَيْأْتُو قُدَّامْهُمْ، ووِجْهُو وَلَّى يِضْوِي كِي الشَّمْسْ، وحْوَايْجُو وَلَّاوْ بْيُضْ كِي النُّورْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","وهُومَا هَكَّاكَا، ظُهْرُولْهُمْ مُوسَى وإِيلِيَّا يِتْكَلْمُوا مْعَ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","يَاخِي بُطْرُسْ قَالْ لْيَسُوعْ: «يَا سِيدِي، مَحْلَاهَا القَعْدَة هُونِي! كَانْ تْحِبْ، تَوْ نُنْصْبُوا ثْلَاثَة خْيِمْ: وَحْدَة لِيكْ ووَحْدَة لْمُوسَى ووَحْدَة لْإِيلِيَّا». ");
INSERT INTO aeu_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","وهُوَّ مَزَّالْ يِتْكَلِّمْ، غَطَّاتْهُمْ غِيمَة ضَاوْيَة، وخْرَجْ صُوتْ مِالغِيمَة يْقُولْ: «هَاذَا هُوَّ إِبْنِي الِّي نْحِبُّو ولِّي فَرْحْتِي بِيهْ عْظِيمَة، إِسْمْعُوا كْلَامُو!». ");
INSERT INTO aeu_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","وكِي سَمْعُوا التْلَامْذَة الصُّوتْ، طَاحُوا عْلَى وْجُوهْهُمْ وخَافُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","يَاخِي يَسُوعْ قْرُبِّلْهُمْ ومَسْهُمْ وقَالْ: «قُومُوا، مَا تْخَافُوشْ». ");
INSERT INTO aeu_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","وكِي هَزُّوا عِينِيهُمْ، مَا شَافُوا كَانْ يَسُوعْ وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","وهُومَا هَابْطِينْ مِالجْبَلْ، وَصَّاهُمْ يَسُوعْ: «مَا تْقُولُوا لْحَدْ عَلِّي شُفْتُوهْ إِلَّا بَعْدْمَا يْقُومْ إِبْنْ الإِنْسَانْ مِالمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","يَاخِي التْلَامْذَة سِأْلُوهْ: «عْلَاشْ عُلَمَاءْ الشَّرِيعَة يْقُولُوا الِّي إِيلِيَّا لَازِمْ يْجِي قْبَلْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","جَاوِبْهُمْ: «صْحِيحْ، إِيلِيَّا يْجِي ويْصَلَّحْ كُلْ شَيْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","آمَا آنَا نْقُلْكُمْ: إِيلِيَّا جَاء، ومَا عَرْفُوهُوشْ، آمَا عَمْلُوا فِيهْ كِيمَا حَبُّوا. وكِيفْ كِيفْ إِبْنْ الإِنْسَانْ زَادَا بِشْ يِتْعَذَّبْ عْلَى يْدِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","وَقْتْهَا فِهْمُوا التْلَامْذَة الِّي هُوَّ كَانْ يَحْكِيلْهُمْ عْلَى يُوحَنَّا الِّي يْعَمِّدْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","وكِي رَجْعُوا بَحْذَا النَّاسْ، جَاء رَاجِلْ لْيَسُوعْ وهْبَطْ عْلَى رْكَايْبُو قُدَّامُو. ");
INSERT INTO aeu_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","وقَالْ: «يَا سِيدِي، أَرْحَمْ وِلْدِي عْلَى خَاطْرُو عَنْدُو الصَّرْعْ، ومِتْعَذَّبْ بَرْشَة ودِيمَا يْطِيحْ فِي النَّارْ وفِي المَاء. ");
INSERT INTO aeu_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ورَانِي جِبْتُو لِتْلَامِذْتِكْ، آمَا مَا نَجْمُوشْ يِشْفِيوَهْ». ");
INSERT INTO aeu_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","جَاوِبْ يَسُوعْ: «إِنْتُومَا جِيلْ مُشْ مُؤْمِنْ وضَايَعْ! قَدَّاشْ بِشْ نُقْعْدِلْكُمْ؟ وقَدَّاشْ بِشْ نُصْبِرْ عْلِيكُمْ؟ جِيبُوهُولِي لَهْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ونْزَرْ يَسُوعْ عَالشِّيطَانْ، يَاخِي خَرَجْ مِالوْلَيِّدْ، والوْلَيِّدْ تِشْفَى بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","وجِبْدُوا التْلَامْذَة يَسُوعْ عْلَى جْنَبْ وسِأْلُوهْ: «عْلَاشْ أَحْنَا مَا نَجَّمْنَاشْ نْخَرْجُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","جَاوِبْهُمْ: «عْلَى خَاطِرْ إِيمَانْكُمْ ضْعِيفْ! نْقُلْكُمْ الحَقْ، كَانْ جَاء عَنْدْكُمْ إِيمَانْ قَدْ كَعْبِةْ الخَرْدِلْ، رَاكُمْ تْقُولُوا لِلجْبَلْ هَاذَا: \"نَقِّلْ مِنْ هْنَا لْغَادِي!\" وهُوَّ يْنَقِّلْ، ومَا يْكُونْ حَتَّى شَيْ مُسْتَحِيلْ قُدَّامْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","آمَا النَّوْعْ هَاذَا مِالشْوَاطِنْ، مَا يُخْرُجْ كَانْ بِالصْلَاةْ والصُّومْ». ");
INSERT INTO aeu_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","وكِي كَانُوا التْلَامْذَة مَلْمُومِينْ فِي الجَلِيلْ قَالِلْهُمْ يَسُوعْ: «إِبْنْ الإِنْسَانْ بِشْ يْسَلْمُوهْ بِينْ يْدِينْ النَّاسْ، ");
INSERT INTO aeu_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","وبِشْ يُقْتْلُوهْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ». يَاخِي حِزْنُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","وكِي وُصْلُوا يَسُوعْ وتْلَامِذْتُو لْكَفْرْنَاحُومْ، جَاوْ الِّي يْلِمُّوا فِي ضْرِيبِةْ الهَيْكِلْ لْبُطْرُسْ وقَالُولُو: «يَاخِي المُعَلِّمْ مْتَاعْكُمْ يِدْفَعْ الضَّرَايِبْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","جَاوِبْ: «إِيْ نْعَمْ». ووَقْتِلِّي دْخَلْ بُطْرُسْ لِلدَّارْ، سِبْقُو يَسُوعْ بِالكْلَامْ وقَالُّو: «شْنُوَّة رَايِكْ، يَا سِمْعَانْ؟ مُلُوكْ الأَرْضْ مِنْ عَنْدْ شْكُونْ يَاخْذُوا الضَّرَايِبْ والجِزْيَة؟ مِنْ عَنْدْ أَوْلَادْهُمْ وَلَّا مِالبْرَايْنِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","جَاوْبُو بُطْرُسْ: «مِنْ عَنْدْ البْرَايْنِيَّة». قَالُّو يَسُوعْ: «مَالَا، الأَوْلَادْ مَا يِدْفْعُوا شَيْ. ");
INSERT INTO aeu_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","آمَا بَاشْ مَا نَعْمْلُولْهُمْشْ مُشْكْلَة، إِمْشِي لِلْبُحَيْرَة، وأَرْمِي الصُّنَّارَة، والحُوتَة الأُولَى الِّي تْشِدْهَا، حِلِّلْهَا فُمْهَا تَوْ تَلْقَى بْيَاسَة قِيمِتْهَا تِكْفِي بَاشْ تِدْفَعْ الضَّرِيبَة. خُوذْهَا وادْفَعْ الضَّرِيبَة عْلِيَّا وعْلِيكْ». ");
INSERT INTO aeu_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","فِي الوَقْتْ هَاذَاكَا، جَاوْ التْلَامْذَة لْيَسُوعْ وسِأْلُوهْ: «شْكُونْ أَعْظِمْ وَاحِدْ فِي مَمْلَكْةْ السْمَاوَاتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","يَاخِي عَيِّطْ يَسُوعْ لِطْفُلْ صْغِيرْ ووَقْفُو فِي وِسْطْهُمْ ");
INSERT INTO aeu_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","وقَالْ: «نْقُلْكُمْ الحَقْ: كَانْ مَا تِتْبَدْلُوشْ وتْوَلِّيوْ كِي الأَوْلَادْ الصْغَارْ، مُشْ بِشْ تُدْخْلُوا لْمَمْلَكْةْ السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","الِّي يِتْوَاضَعْ ويْكُونْ كِيفْ هَا الطْفُلْ الصْغِيرْ، هُوَّ أَعْظَمْ وَاحِدْ فِي مَمْلَكْةْ السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ولِّي يِقْبِلْ طْفُلْ صْغِيرْ كِيمَا هَاذَا عْلَى خَاطِرْ إِسْمِي يِقْبِلْنِي آنَا. ");
INSERT INTO aeu_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","«ولِّي يْكُونْ سْبَبْ فِي إِنُّو وَاحِدْ مِالصْغَارْ الِّي يَمْنُوا بِيَّا يُغْلُطْ، خِيرْلُو كَانْ يِتْعَلَّقْ فِي رَقْبْتُو حَجْرِةْ الرْحَى ويِتِرْمَى فِي قَلْبْ البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","يَا وِيلُو العَالِمْ مِالحَاجَاتْ الِّي تْخَلِّي النَّاسْ تُغْلُطْ! الغْلَطْ لَازِمْ بِشْ يْصِيرْ، آمَا يَا وِيلُو الِّي يْكُونْ هُوَّ السْبَبْ فِيهْ! ");
INSERT INTO aeu_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","«وإِذَا يِدِّكْ وَلَّا سَاقِكْ تْخَلِّيكْ تُغْلُطْ، قُصْهَا وأَرْمِيهَا بْعِيدْ، خِيرْلِكْ تُدْخُلْ لِلْحَيَاةْ الأَبَدِيَّة نَاقِصْ سَاقْ وَلَّا يِدْ، مِنْ إِنُّو يْدِيكْ وَلَّا سَاقِيكْ يْكُونُوا كَامْلِينْ وتِطَّيِّشْ فِي النَّارْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","وإِذَا كَانْ عِينِكْ تْخَلِّيكْ تُغْلُطْ، قَلَّعْهَا وأَرْمِيهَا بْعِيدْ، خِيرْلِكْ تُدْخُلْ لِلْحَيَاةْ الأَبَدِيَّة بْعِينْ وَحْدَة، مِنْ إِنُّو يْكُونُوا عَنْدِكْ زُوزْ عِينِينْ وتِتْرْمَى فِي نَارْ جْهَنِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«رُدُّوا بَالْكُمْ تَحْقْرُوا وَاحِدْ مِالصْغَارْ هَاذُومَا. نْقُولِلْكُمْ: مْلَايْكِتْهُمْ فِي السْمَاء دِيمَا يْشُوفُوا فِي وِجْهْ بَابَا الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ جَاء بَاشْ يْنَجِّي الِّي مَاشِينْ لِلْهْلَاكْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","«شْنُوَّة رَايْكُمْ؟ إِذَا كَانْ رَاجِلْ عَنْدُو 100 عَلُّوشْ ووَاحِدْ مِنْهُمْ ضَاعْ، مُشْ يْخَلِّي الـ99 فِي الجْبَالْ ويِمْشِي يْلَوِّجْ عَالعَلُّوشْ الضَّايَعْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","نْقُلْكُمْ الحَقْ: إِذَا كَانْ يَلْقَاهْ، رَاهُو بِشْ يِفْرَحْ بِيهْ أَكْثِرْ مِالـ99 الِّي مَا ضَاعُوشْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","هَكَّاكَا زَادَا بُوكُمْ الِّي فِي السْمَاء مَا يْحِبِّشْ وَاحِدْ مِالصْغَارْ هَاذُومَا يِمْشِي لِلْهْلَاكْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«إِذَا كَانْ خُوكْ غْلُطْ فِي حَقِّكْ، إِمْشِيلُو وأَحْكِي مْعَاهْ بِينِكْ وبِينُو، وكَانْ سْمَعْ مِنِّكْ، تْكُونْ رْبِحْتْ خُوكْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","وكَانْ مَا سْمَعْشْ مِنِّكْ، هِزْ مْعَاكْ وَاحِدْ وَلَّا زُوزْ أُخْرِينْ، بَاشْ مَا يْكُونْ فَمَّة حَتَّى حُكْمْ فِي القَضِيَّة إِلَّا مَا يْكُونْ فَمَّة زُوزْ وَلَّا ثْلَاثَة شْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","وكَانْ مَا حَبِّشْ يِسْمَعْ مِنْهُمْ، قُولْ لِلْكْنِيسَة، وإِذَا مَا حَبِّشْ يِسْمَعْ مِالكْنِيسَة زَادَا، عَامْلُو كِيمَا تْعَامِلْ الِّي مَاهُوشْ يْهُودِي وَلَّا كِيمَا المَكَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","نْقُلْكُمْ الحَقْ: كُلْ الِّي تُرْبْطُوهْ فِي الأَرْضْ يْكُونْ مَرْبُوطْ فِي السْمَاء، ولِّي تْحِلُّوهْ فِي الأَرْضْ يْكُونْ مَحْلُولْ فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","«ونْقُلْكُمْ زَادَا: إِذَا كَانْ زُوزْ مِنْكُمْ يِتْفَاهْمُوا فِي الأَرْضْ عْلَى أَيْ حَاجَة يُطْلْبُوهَا، رَاهُو بَابَا الِّي فِي السْمَاء يَعْطِيهَالْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","عْلَى خَاطِرْ وِينْ يِتْلَمُّوا زُوزْ وَلَّا ثْلَاثَة بْإِسْمِي، آنَا نْكُونْ فِي وِسْطْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","وَقْتْهَا قْرُبْ بُطْرُسْ لْيَسُوعْ وسِأْلُو: «يَا سِيدِي، قَدَّاشْ مِنْ مَرَّة نْسَامَحْ خُويَا وَقْتِلِّي يُغْلُطْ فِي حَقِّي؟ سَبْعَة مَرَّاتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","جَاوْبُو يَسُوعْ: «مُشْ سَبْعَة مَرَّاتْ، آمَا سَبْعِينْ مَرَّة سَبْعَة مَرَّاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","«هَاذَاكَا عْلَاشْ نْشَبَّهْ مَمْلَكْةْ السْمَاوَاتْ بْمَلِكْ حَبْ يْحَاسِبْ عَبِيدُو. ");
INSERT INTO aeu_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","وكِي بْدَا يْحَاسِبْ فِيهُمْ، جَابُولُو وَاحِدْ يْسَالُو بَرْشَة فْلُوسْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","وكِي طْلَعْ العَبْدْ مَا عَنْدُوشْ مْنِينْ يْخَلِّصْ، سِيدُو أْمَرْ بَاشْ يِتْبَاعْ هُوَّ ومَرْتُو وأَوْلَادُو وكُلْ مَا يِمْلِكْ، بَاشْ يْخَلِّصْ الدِّينْ الِّي عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","وَلَّى رْمَى رُوحُو قُدَّامُو وسْجِدْلُو وقَالْ: \"يَا سِيدِي، أُصْبُرْ عْلِيَّا وتَوْ نْخَلْصِكْ فِي دْيُونِي الكُلْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","يَاخِي سْخِفْ عْلِيهْ سِيدُو، وسَامْحُو فِي دْيُونُو الكُلْ وسَيْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","«والعَبْدْ هَاذَا وهُوَّ خَارِجْ، لْقَى وَاحِدْ مِالعَبِيدْ صُوحَابُو كَانْ يْسَالُو شْوَيَّة فْلُوسْ، شَدْ خَنْقُو مِنْ رَقْبْتُو وقَالُّو: \"خَلِّصْنِي فِلِّي نْسَالْهُمْلِكْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","يَاخِي العَبْدْ الآخِرْ رْمَى رُوحُو قُدَّامُو وتْشَحْتُو وقَالْ: \"أُصْبُرْ عْلِيَّا، تَوْ نْخَلْصِكْ فِيهُمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","آمَا هُوَّ مَا حَبِّشْ ورْمَاهْ فِي الحَبْسْ حَتَّى لِينْ يْخَلِّصْ الدِّينْ الِّي عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","وكِي صُوحَابْهُمْ العَبِيدْ شَافُوا الِّي صَارْ، حِزْنُوا بَرْشَة ومْشَاوْ حْكَاوْ لْسِيدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","عَيَّطْلُو سِيدُو وقَالُّو: \"إِنْتِ عَبْدْ شِرِّيرْ! دْيُونِكْ الكُلْ سَامَحْتِكْ فِيهُمْ، عْلَى خَاطْرِكْ اتْشَحَّتْنِي. ");
INSERT INTO aeu_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","مُشْ كَانْ لَازْمِكْ تَرْحَمْ العَبْدْ صَاحْبِكْ كِيمَا آنَا رْحَمْتِكْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","وتْغَشِّشْ سِيدُو بَرْشَة، ورْمَاهْ لِلْجَلَّادِينْ بَاشْ يْعَذْبُوهْ حَتَّى لِينْ يْخَلِّصْ دْيُونُو الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","وبَعْدْ قَالِلْهُمْ يَسُوعْ: «هَكَّا زَادَا يَعْمْلِلْكُمْ بَابَا الِّي فِي السْمَاء كَانْ مَا يْسَامَحْشْ كُلْ وَاحِدْ فِيكُمْ خُوهْ مِنْ قَلْبُو». ");
INSERT INTO aeu_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","وبَعْدْمَا كَمِّلْ يَسُوعْ كْلَامُو، خَلَّى مَنْطَقْةْ الجَلِيلْ ومْشَى لْمَنْطَقْةْ اليَهُودِيَّة الِّي وْرَاء نَهْرْ الأُرْدُنْ. ");
INSERT INTO aeu_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","وتَبْعُوهْ بَرْشَة نَاسْ، وشْفَاهُمْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","وجَاوَهْ جْمَاعَة فِرِّيسِيِّينْ بَاشْ يْجَرْبُوهْ وسِأْلُوهْ: «يَاخِي حْلَالْ الرَّاجِلْ يْطَلَّقْ مَرْتُو لْأَيْ سْبَبْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","جَاوِبْهُمْ: «يَاخِي مَا قْرِيتُوشْ الِّي الخَالَقْ مِلِّي بْدَاتْ الدِّنْيَا، خْلَقْ الإِنْسَانْ ذْكَرْ وأَنْثَى، ");
INSERT INTO aeu_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","وقَالْ: \"هَاذَاكَا عْلَاشْ الرَّاجِلْ يْخَلِّي بُوهْ وأُمُّو ويِتْرْبَطْ بْمَرْتُو ويْوَلِّيوْ الإِثْنِينْ بْدَنْ وَاحِدْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","مَالَا هُومَا مَا عَادِشْ إِثْنِينْ، آمَا بْدَنْ وَاحِدْ. ولِّي جَمْعُو اللَّهْ مَا يْفَرْقُوشْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","يَاخِي سِأْلُوهْ: «مَالَا عْلَاشْ مُوسَى وَصَّى بَاشْ الرَّاجِلْ يَعْطِي وَرْقِةْ طْلَاقْ لْمَرْتُو كِي يْطَلَّقْهَا؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","جَاوِبْهُمْ يَسُوعْ: «مُوسَى خَلَّاكُمْ اطَّلْقُوا نْسَاكُمْ بِسْبَبْ كْسُوحِيِّةْ قْلُوبْكُمْ. آمَا الأُمُورْ مَا كَانِتْشْ هَكَّا مِالأُوِّلْ. ");
INSERT INTO aeu_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","وآنَا نْقُلْكُمْ:الِّي يْطَلَّقْ مَرْتُو لْأَيْ سْبَبْ غِيرْ الزْنَى ويْعَرِّسْ بِمْرَا أُخْرَى يَزْنَى، ولِّي يْعَرِّسْ بِمْرَا مْطَلْقَة يَزْنَى». ");
INSERT INTO aeu_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","قَالُولُو تْلَامِذْتُو: «إِذَا كَانْ هَاذَا حَالْ الرَّاجِلْ مْعَ المْرَا، مَالَا كَانْ مَا يْعَرِّسْشْ خِيرْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","آمَا هُوَّ قَالِلْهُمْ: «مُشْ النَّاسْ الكُلْ يِقْبْلُوا الكْلَامْ هَاذَا، آمَا كَانْ الِّي تِعْطَالْهُمْ بَاشْ يِقْبْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","عْلَى خَاطِرْ فَمَّة نَاسْ تْوِلْدُوا مِنْ كْرُوشْ أُمَّاتْهُمْ مَا يْنَجْمُوشْ يْعَرْسُوا، وفَمَّة شْكُونْ الِّي خْصَاوْهُمْ النَّاسْ، وفَمَّة الِّي إِخْتَارُوا مَا يْعَرْسُوشْ عْلَى خَاطِرْ مَمْلَكْةْ السْمَاوَاتْ. ولِّي يْنَجِّمْ يِقْبِلْ هَاذَا خَلِّيهْ يِقْبْلُو». ");
INSERT INTO aeu_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","وفَمَّة نَاسْ جَابُولُو وْلَادْ صْغَارْ بَاشْ يْحُطْ عْلِيهُمْ يْدِيهْ ويْصَلِّي عْلَى خَاطِرْهُمْ. يَاخِي التْلَامْذَة لَامُوا عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","آمَا يَسُوعْ قَالْ: «خَلِّيوْ الصْغَارْ يْجِيوْنِي ومَا تَمْنْعُوهُمْشْ، عْلَى خَاطِرْ مَمْلَكْةْ السْمَاوَاتْ يُدْخْلُولْهَا النَّاسْ الِّي كِيفْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","وحَطْ عْلِيهُمْ يْدِيهْ وبَارِكْهُمْ، ومْشَى مِالبْلَاصَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","وجَاهْ وَاحِدْ وقَالُّو: «يَا مُعَلِّمْ، شْنِيَّة الأَعْمَالْ الصَّالْحَة الِّي لَازِمْنِي نَعْمِلْهُمْ بَاشْ نَاخِذْ الحَيَاةْ الأَبَدِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","يَاخِي جَاوْبُو: «عْلَاشْ تِسْإِلْ فِيَّا عَالصَّلَاحْ؟ فَمَّة وَاحِدْ بَرْكْ صَالَحْ، آمَا إِذَا كَانْ تْحِبْ تُدْخُلْ لِلْحَيَاةْ الأَبَدِيَّة أَعْمِلْ بِالوْصَايَا». ");
INSERT INTO aeu_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","قَالُّو: «أَنَاهُمْ الوْصَايَا؟». قَالُّو يَسُوعْ: «مَا تَعْمِلْشْ جْرِيمِةْ قَتْلْ، مَا تَزْنَاشْ، مَا تِسْرِقْشْ، مَا تِشْهِدْشْ بِالكِذْبْ، ");
INSERT INTO aeu_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","إِكْرِمْ بُوكْ وأُمِّكْ، وحِبْ قْرِيبِكْ كِيفْ مَا تْحِبْ رُوحِكْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","قَالُّو: «الوْصَايَا هَاذُمْ الكُلْ نْطَبَّقْ فِيهُمْ مِلِّي آنَا صْغِيرْ، شْنُوَّة الِّي مَزَّالْ نَاقِصْنِي؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","جَاوْبُو يَسُوعْ: «إِذَا تْحِبْ تْكُونْ كَامِلْ، بِيعْ الِّي عَنْدِكْ الكُلْ وفَرْقُو عَالفْقَارَى، وهَكَّا يْوَلِّي عَنْدِكْ كِنْزْ فِي السْمَاء، ومْبَعِّدْ إِيجَا تَبَّعْنِي!» ");
INSERT INTO aeu_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","كِي سْمَعْ الكْلَامْ هَاذَا، مْشَى وهُوَّ حْزِينْ، عْلَى خَاطْرُو كَانْ غْنِيْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","يَاخِي يَسُوعْ قَالْ لِتْلَامِذْتُو: «نْقُلْكُمْ الحَقْ: صْعِيبْ عَالغْنِيْ إِنُّو يُدْخُلْ لْمَمْلَكْةْ السْمَاوَاتْ! ");
INSERT INTO aeu_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ونْزِيدْ نْقُلْكُمْ: دْخُولْ الجْمَلْ مِنْ نُقْبِةْ الإِبْرَة أَسْهِلْ مِنْ دْخُولْ الغْنِيْ لْمَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","تْعَجْبُوا التْلَامْذَة بَرْشَة مِالكْلَامْ هَاذَا وقَالُوا: «مَالَا شْكُونْ يْنَجِّمْ يِنْجَى؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","خْزَرِّلْهُمْ يَسُوعْ وقَالْ: «هَاذَا مُسْتَحِيلْ عَنْدْ النَّاسْ، آمَا عَنْدْ اللَّهْ كُلْ شَيْ مُمْكِنْ». ");
INSERT INTO aeu_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","يَاخِي بُطْرُسْ قَالُّو: «هَانَا أَحْنَا خَلِّينَا كُلْ شَيْ وتَبَّعْنَاكْ، شْنُوَّة بِشْ نَاخْذُوا؟». ");
INSERT INTO aeu_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","جَاوِبْ يَسُوعْ: «نْقُلْكُمْ الحَقْ: فِي زْمَانْ تَجْدِيدْ كُلْ شَيْ، وَقْتِلِّي إِبْنْ الإِنْسَانْ يُقْعُدْ عْلَى عَرْشْ مَجْدُو، إِنْتُومَا زَادَا الِّي تَبَّعْتُونِي بِشْ تُقْعْدُوا عْلَى أَثْنَاشِنْ عَرْشْ وتُحْكْمُوا عْلَى قَبَائِلْ بَنِي إِسْرَائِيلْ الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","وأَيْ وَاحِدْ خَلَّى دْيَارْ وَلَّا إِخْوَة وَلَّا خْوَاتْ، وَلَّا بُو، وَلَّا أُمْ، وَلَّا وْلَادْ، وَلَّا أَرَاضِي عْلَى خَاطِرْ إِسْمِي، بِشْ يَاخِذْ قَدْهُمْ 100 مَرَّة ويُورِثْ الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","وبَرْشَة نَاسْ كَانُوا الأُولَانِينْ بِشْ يْوَلِّيوْ الإِخْرَانِينْ، ونَاسْ كَانُوا الإِخْرَانِينْ بِشْ يْوَلِّيوْ الأُولَانِينْ». ");
INSERT INTO aeu_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«رَاهِي مَمْلَكْةْ السْمَاوَاتْ تْشَبَّهْ لْرَاجِلْ عَنْدُو أَرْضْ، خْرَجْ مِالفَجْرْ بَاشْ يْجِيبْ خَدَّامَة لْسَانْيِةْ العْنِبْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","وتْفَاهِمْ مْعَ الخَدَّامَة بَاشْ يَعْطِيهُمْ بْيَاسَة فُضَّة فِي النْهَارْ، وبْعَثْهُمْ لْسَانِيتُو. ");
INSERT INTO aeu_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","وخْرَجْ قْرِيبْ التِّسْعَة مْتَاعْ الصْبَاحْ، يَاخِي شَافْ خَدَّامَة أُخْرِينْ وَاقْفِينْ فِي السُّوقْ مِنْ غِيرْ خِدْمَة ");
INSERT INTO aeu_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","وقَالِلْهُمْ: \"إِمْشِيوْ إِنْتُومَا زَادَا لْسَانْيِةْ العْنِبْ، وتَوْ نَعْطِيكُمْ حَقْكُمْ\". يَاخِي مْشَاوْ. ");
INSERT INTO aeu_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","وخْرَجْ مَرَّة أُخْرَى قْرِيبْ نُصْ النْهَارْ، ومَرَّة أُخْرَى مْعَ مَاضِي ثْلَاثَة مْتَاعْ العْشِيَّة، وعْمَلْ نَفْسْ الحْكَايَة. ");
INSERT INTO aeu_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","وخْرَجْ قْرِيبْ الخَمْسَة مْتَاعْ العْشِيَّة، ولْقَى خَدَّامَة أُخْرِينْ وَاقْفِينْ، وقَالِلْهُمْ: \"شْبِيكُمْ وَاقْفِينْ هُونِي نْهَارْ كَامِلْ بْلَا خِدْمَة؟\". ");
INSERT INTO aeu_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","قَالُولُو: \"مَا عَيْطِلْنَا حَدْ بَاشْ نِخْدْمُوا\". يَاخِي قَالِلْهُمْ: \"إِمْشِيوْ إِنْتُومَا زَادَا لْسَانْيِةْ العْنِبْ\". ");
INSERT INTO aeu_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","وفِي آخِرْ النْهَارْ، قَالْ مُولَى السَّانْيَة لِلِّي لَاهِي بِالخَدَّامَة: \"عَيِّطْ لِلْخَدَّامَة وخَلَّصْهُمْ، وأَبْدَى بِلِّي جَاوْ الإِخْرَانِينْ حَتَّى لِينْ تُوصِلْ لِلِّي جَاوْ الأُولَانِينْ\". ");
INSERT INTO aeu_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","«وجَاوْ الِّي بْدَاوْ يِخْدْمُوا مْعَ الخَمْسَة مْتَاعْ العْشِيَّة، وخْذَا كُلْ وَاحِدْ فِيهُمْ بْيَاسَة فُضَّة. ");
INSERT INTO aeu_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ووَقْتِلِّي جَاوْ الِّي بْدَاوْ الأُولَانِينْ، مْشَى فِي بَالْهُمْ بِشْ يَاخْذُوا أَكْثِرْ مِالأُخْرِينْ، آمَا كُلْ وَاحِدْ فِيهُمْ خْذَا بْيَاسَة فُضَّة. ");
INSERT INTO aeu_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","وهُومَا قَاعْدِينْ يُخْلْصُوا، بْدَاوْ يِتْشَكَّاوْ عْلَى مُولَى السَّانْيَة، ");
INSERT INTO aeu_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ويْقُولُوا: \"هَاذُومَا الِّي جَاوْ الإِخْرَانِينْ خِدْمُوا سَاعَة وَحْدَة، وإِنْتِ خَلَّصْتْهُمْ كِيفْنَا أَحْنَا الِّي خْدِمْنَا نْهَارْ كَامِلْ فِي السْخَانَة!\". ");
INSERT INTO aeu_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","آمَا مُولَى السَّانْيَة جَاوِبْ وَاحِدْ مِنْهُمْ: \"يَا صَاحْبِي، آنَا رَانِي مَا ظْلَمْتِكْشْ. يَاخِي مُشْ تْفَاهِمْتْ مْعَاكْ عْلَى بْيَاسَة فُضَّة؟ ");
INSERT INTO aeu_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","خُوذْ حَقِّكْ وإِمْشِي. هَاذَا الِّي جَاء فِي الإِخِّرْ نْحِبْ نَعْطِيهْ كِيفِكْ، ");
INSERT INTO aeu_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","يَاخِي مَا عَنْدِيشْ الحَقْ نِتْصَرِّفْ فِي فْلُوسِي كِيفْ مَا نْحِبْ؟ وَلَّا إِنْتِ حْسُودِي عْلَى خَاطِرْنِي آنَا كْرِيمْ؟\"». ");
INSERT INTO aeu_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","وقَالْ يَسُوعْ: «وهَكَّا الإِخْرَانِينْ يْوَلِّيوْ الأُولَانِينْ، والأُولَانِينْ يْوَلِّيوْ الإِخْرَانِينْ». ");
INSERT INTO aeu_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ويَسُوعْ طَالَعْ لْأُورْشَلِيمْ، جْبِدْ الأَثْنَاشِنْ تِلْمِيذْ عْلَى جْنَبْ فِي الطْرِيقْ، وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«أَحْنَا طَالْعِينْ لْأُورْشَلِيمْ، وغَادِي، بِشْ يْسَلْمُوا إِبْنْ الإِنْسَانْ لِكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة، وبِشْ يُحْكْمُوا عْلِيهْ بِالمُوتْ، ");
INSERT INTO aeu_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ويْسَلْمُوهْ فِي يْدِينْ نَاسْ مَاهُمْشْ يْهُودْ، بَاشْ يْهِينُوهْ ويِجْلْدُوهْ ويُصْلْبُوهْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ». ");
INSERT INTO aeu_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","وجَاتُو أُمْ وْلَادْ زَبَدِي ومْعَاهَا وْلَادْهَا الزُّوزْ، وسِجْدِتْلُو وطَلْبِتْ مِنُّو حَاجَة. ");
INSERT INTO aeu_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","يَاخِي قَالِلْهَا: «شْنِيَّة تْحِبْ؟». قَالِتْلُو: «أُأْمُرْ إِنُّو وْلَادِي هَاذُومَا الزُّوزْ يُقْعْدُوا وَاحِدْ عْلَى يْمِينِكْ والآخِرْ عْلَى يْسَارِكْ فِي مَمْلَكْتِكْ». ");
INSERT INTO aeu_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","جَاوِبْهُمْ يَسُوعْ: «إِنْتُومَا مُشْ عَارْفِينْ فَاشْ قَاعْدِينْ تُطْلْبُوا. تْنَجْمُوا تُشْرْبُوا الكَاسْ الِّي بِشْ نُشْرُبُو آنَا؟». قَالُولُو: «انَّجْمُوا!». ");
INSERT INTO aeu_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","قَالِلْهُمْ: «إِنْتُومَا بِشْ تُشْرْبُوا الكَاسْ مْتَاعِي، آمَا القَعْدَة عْلَى يْمِينِي وعْلَى يْسَارِي مَا انَّجِّمْ نَعْطِيهَا كَانْ لِلِّي حَضَّرْهَالْهُمْ بَابَا». ");
INSERT INTO aeu_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ووَقْتِلِّي سَمْعُوا التْلَامْذَة العَشْرَة الأُخْرِينْ هَاذَا، تْغَشْشُوا عَالأَخْوَة الزُّوزْ. ");
INSERT INTO aeu_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","يَاخِي عَيْطِلْهُمْ يَسُوعْ وقَالِلْهُمْ: «إِنْتُومَا تَعْرْفُوا الِّي حُكَّامْ الشُّعُوبْ يْسَيْطْرُوا عْلِيهُمْ، ولِّي عَنْدْهُمْ السُّلْطَة يِتْسَلْطُوا عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","وهَاذَا مَا يِلْزْمُوشْ يْكُونْ بِينَاتْكُمْ، آمَا الِّي يْحِبْ يْكُونْ فِيكُمْ عْظِيمْ، لَازِمْ يْكُونْ لِيكُمْ خْدِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ولِّي يْحِبْ يْوَلِّي الأُوِّلْ فِيكُمْ، خَلِّيهْ يْكُونْ عَبْدْ لِيكُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","كِيفْ مَا إِبْنْ الإِنْسَانْ جَاء مُشْ بَاشْ يِخْدْمُوهْ النَّاسْ، آمَا بَاشْ يِخْدِمْهُمْ ويِفْدِي بِحْيَاتُو بَرْشَة مِنْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","وكِي جَاوْ خَارْجِينْ مِنْ أَرِيحَا، تَبْعُوهْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","وكَانْ فَمَّة زُوزْ عِمْيَانْ قَاعْدِينْ بِجْنَبْ الطْرِيقْ، وسَمْعُوا الِّي يَسُوعْ مِتْعَدِّي مِنْ غَادِي. يَاخِي بْدَاوْ يْعَيْطُوا: «يَا سِيدْنَا، يَا وِلْدْ دَاوِدْ أَرْحَمْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","يَاخِي النَّاسْ صَاحُوا عْلِيهُمْ بَاشْ يُسْكْتُوا. آمَا هُومَا عَيْطُوا أَكْثِرْ: «يَا سِيدْنَا، يَا وِلْدْ دَاوِدْ أَرْحَمْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","يَاخِي وْقِفْ يَسُوعْ وعَيْطِلْهُمْ وقَالِلْهُمْ: «آشْ تْحِبُّونِي نَعْمْلِلْكُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","قَالُولُو: «يَا سِيدْنَا، نْحِبُّوكْ تْحِلِّلْنَا عِينِينَا!». ");
INSERT INTO aeu_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","يَاخِي حَنْ عْلِيهُمْ يَسُوعْ ومَسِّلْهُمْ عِينِيهُمْ، وبِالوَقْتْ وَلَّاوْ يْشُوفُوا وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ووَقْتِلِّي قْرُبْ يَسُوعْ وتْلَامِذْتُو مِنْ أُورْشَلِيمْ، ووُصْلُوا لْدَشْرِةْ بِيتْ فَاجِي الِّي بَحْذَا جْبَلْ الزِّيتُونْ، بْعَثْ يَسُوعْ زُوزْ مِنْ تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","وقَالِلْهُمْ: «إِمْشِيوْ لِلدَّشْرَة الِّي مْقَابْلِتْكُمْ، تَوْ تَلْقَاوْ بْهِيمَة مَرْبُوطَة ومْعَاهَا جَحْشْ، حِلُّولْهُمْ الرْبَاطْ وجِيبُوهُمْلِي. ");
INSERT INTO aeu_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","وكَانْ حَدْ كَلَّمْكُمْ، قُولُولُو: \"سِيدْنَا حَاشْتُو بِيهُمْ، وتَوْ فِيسَعْ يْرَجَّعْهُمْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","وهَاذَا صَارْ بَاشْ يْتِمْ الِّي قَالُّو اللَّهْ عْلَى لْسَانْ النَّبِيْ: ");
INSERT INTO aeu_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","«قُولُوا لْبِنْتْ صِهْيَوْنْ: هَاوْ المَلِكْ مْتَاعِكْ جَايِكْ، جَايِكْ مِتْوَاضَعْ ورَاكِبْ عْلَى بْهِيمَة، رَاكِبْ عْلَى جَحْشْ وِلْدْ بْهِيمَة». ");
INSERT INTO aeu_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","يَاخِي مْشَاوْ التْلَامْذَة الزُّوزْ، وعَمْلُوا كِيمَا أْمَرْهُمْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","وجَابُوا البْهِيمَة والجَّحْشْ وحَطُّوا عْلِيهُمْ حْوَايِجْهُمْ، ورْكِبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","وبَرْشَة نَاسْ فِرْشُوا حْوَايِجْهُمْ عَالطْرِيقْ، ونَاسْ أُخْرِينْ فِرْشُوا أَعْرَافْ قَصُّوهَا مِالشْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","وكَانُوا النَّاسْ الِّي يِمْشِيوْ قُدَّامُو ووْرَاهْ يْعَيْطُوا: «أُوصَنَّا لْوِلْدْ دَاوِدْ! مُبَارَكْ الِّي جَايْ بْإِسْمْ الرَّبْ! أُوصَنَّا فِي السْمَاء!». ");
INSERT INTO aeu_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","وكِي دْخَلْ يَسُوعْ لْأُورْشَلِيمْ خَاضِتْ المْدِينَة الكُلْ وبْدَاوْ النَّاسْ يِسْأْلُوا: «شْكُونُو هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ولِّي دَايْرِينْ بِيهْ جَاوْبُوا: «هَاذَا النَّبِيْ يَسُوعْ الِّي مِالنَّاصْرَة فِي مَنْطَقْةْ الجَلِيلْ». ");
INSERT INTO aeu_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ودْخَلْ يَسُوعْ لِلْهَيْكِلْ وطَرِّدْ كُلْ الِّي كَانُوا يْبِيعُوا ويِشْرِيوْ غَادِي، وقْلِبْ طْوَاوِلْ النَّاسْ الِّي يْصَرْفُوا فِي الفْلُوسْ وكْرَاسِي الِّي يْبِيعُوا فِي الحْمَامْ، ");
INSERT INTO aeu_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","وقَالِلْهُمْ: «مَكْتُوبْ بِلِّي: \"دَارِي بِشْ تِتْسَمَّى دَارْ صْلَاةْ، آمَا إِنْتُومَا رَدِّيتُوهَا مْغَارِةْ سُرَّاقْ!\"». ");
INSERT INTO aeu_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","وهُوَّ فِي الهَيْكِلْ، جَاوَهْ العِمْيَانْ والعَايْبِينْ يَاخِي شْفَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","آمَا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة تْغَشْشُوا وَقْتِلِّي شَافُوا المُعْجْزَاتْ الِّي عْمَلْهَا والأَوْلَادْ الصْغَارْ يْعَيْطُوا فِي الهَيْكِلْ: «أُوصَنَّا لْوِلْدْ دَاوِدْ!». ");
INSERT INTO aeu_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","وقَالُولُو: «يَاخِي تِسْمَعْ فَاشْ قَاعْدِينْ يْقُولُوا؟». قَالِلْهُمْ يَسُوعْ: «إِيْ نْعَمْ، يَاخِي عْمُرْكُمْ مَا قْرِيتُوا الآيَة هَاذِي: \"مِنْ أَفَّامْ الصْغَارْ ولِّي مَزَّالُوا يَرْضْعُوا، خَرَّجْتْ حَمْدْ لِلَّهْ\"؟». ");
INSERT INTO aeu_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","وخَلَّاهُمْ وخْرَجْ مِالمْدِينَة لْدَشْرِةْ بِيتْ عَنْيَا، وبَاتْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","وفِي الصْبَاحْ وهُوَّ رَاجَعْ لِلْمْدِينَة، جَاعْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","وشَافْ كَرْمَة عْلَى حَافِّةْ الطْرِيقْ، مْشَالْهَا، آمَا مَا لْقَى فِيهَا كَانْ الأَوْرَاقْ. يَاخِي قَالِلْهَا: «مَا عَادِشْ بِشْ تْجِي مِنِّكْ غَلَّة لِلْأَبَدْ!». وبِالوَقْتْ يِبْسِتْ الكَرْمَة. ");
INSERT INTO aeu_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","وكِي شَافُوا التْلَامْذَة الِّي صَارْ، تْعَجْبُوا وقَالُوا: «كِيِفَاشْ يِبْسِتْ الكَرْمَة بِالوَقْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","جَاوِبْهُمْ يَسُوعْ: «نْقُلْكُمْ الحَقْ: إِذَا كَانْ عَنْدْكُمْ إِيمَانْ ومَا تْشُكُّوشْ، مُشْ بِشْ تَعْمْلُوا الِّي عْمَلْتُو آنَا لِلْكَرْمَة أَكَهَوْ، آمَا حَتَّى كَانْ تْقُولُوا لِلجْبَلْ هَاذَا: \"اتْقَلَّعْ واتْرْمَى فِي البْحَرْ\"، بِشْ يْصِيرْ بِالحَقْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","كُلْ الِّي تُطْلْبُوهْ فِي الصْلَاةْ بْإِيمَانْ، تَاخْذُوهْ». ");
INSERT INTO aeu_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ومْشَى يَسُوعْ لِلْهَيْكِلْ. وهُوَّ يْعَلِّمْ، جَاوَهْ كْبَارْ الكَهَنَة وشْيُوخْ الشَّعْبْ وسِأْلُوهْ: «بَانَا سُلْطَة تَعْمِلْ فِي الحَاجَاتْ هَاذِي؟ وشْكُونْ عْطَاهَالِكْ السُّلْطَة؟». ");
INSERT INTO aeu_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","جَاوِبْهُمْ يَسُوعْ: «وآنَا زَادَا بِشْ نِسْإِلْكُمْ سُؤَالْ وَاحِدْ، وكَانْ تْجَاوْبُونِي، نْقُلْكُمْ بَانَا سُلْطَة نَعْمِلْ فِي الحَاجَاتْ هَاذِي: ");
INSERT INTO aeu_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","شْكُونْ عْطَى السُّلْطَة لْيُوحَنَّا بَاشْ يْعَمِّدْ؟ اللَّهْ وَلَّا النَّاسْ؟». يَاخِي تْشَاوْرُوا مَا بِينَاتْهُمْ وقَالُوا: «إِذَا قُلْنَا: \"مِنْ عَنْدْ اللَّهْ\" تَوْ يْقُولْ: \"مَالَا عْلَاشْ مَا أَمَّنْتُوشْ بِلِّي جَاء بِيهْ؟\" ");
INSERT INTO aeu_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","وإِذَا قُلْنَا \"مِنْ عَنْدْ النَّاسْ\"، نْخَافُوا لَا الشَّعْبْ يْهِيجْ عْلِينَا، عْلَى خَاطِرْهُمْ مُقْتَنْعِينْ الِّي يُوحَنَّا نَبِيْ». ");
INSERT INTO aeu_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","يَاخِي جَاوْبُوهْ: «مَا نَعْرْفُوشْ». قَالِلْهُمْ يَسُوعْ: «حَتَّى آنَا مَا نْقُلْكُمْشْ بَانَا سُلْطَة نَعْمِلْ فِي الحَاجَاتْ هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","«شْنِيَّة رَايْكُمْ؟ كَانْ فَمَّة رَاجِلْ عَنْدُو زُوزْ وْلَادْ. مْشَى لِلْأُوِّلْ وقَالُّو: \"يَا وِلْدِي، إِمْشِي اليُومْ وإِخْدِمْ فِي سَانْيِةْ العْنِبْ\". ");
INSERT INTO aeu_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","يَاخِي جَاوْبُو وِلْدُو: \"مَا نْحِبِّشْ نِمْشِي\". آمَا مْبَعِّدْ نْدِمْ ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","وجَاء لْوِلْدُو الثَّانِي وقَالُّو نَفْسْ الشَّيْ، يَاخِي جَاوْبُو: \"هَانِي مَاشِي يَا بَابَا!\" آمَا مَا مْشَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","شْكُونْ مِنْهُمْ عْمَلْ الِّي حَبْ عْلِيهْ البُو؟». قَالُولُو: «الأُوِّلْ». قَالِلْهُمْ يَسُوعْ: «نْقُولِلْكُمْ الحَقْ: المَكَّاسَة والعَاهْرَاتْ بِشْ يُدْخْلُوا قْبَلْكُمْ لْمَمْلَكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","عْلَى خَاطِرْ يُوحَنَّا جَاء بَاشْ يْوَرِّيكُمْ طْرِيقْ الصَّلَاحْ وإِنْتُومَا مَا صَدَّقْتُوهُشْ، آمَا المَكَّاسَة والعَاهْرَاتْ صَدْقُوهْ. وإِنْتُومَا حَتَّى بَعْدْمَا شُفْتُوا هَاذَا، مَا نْدِمْتُوشْ ومَا صَدَّقْتُوهُشْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«إِسْمْعُوا مَثَلْ آخِرْ: فَمَّة رَاجِلْ زْرَعْ سَانْيَة عْنِبْ، ودَوِّرْ بِيهَا سُورْ، وعْمَلْ فِيهَا مَعْصْرَة وبْنَى بُرْجْ، وكْرَاهَا لْفَلَّاحَة وسَافِرْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","وكِي قْرُبْ وَقْتْ الصَّابَة، بْعَثْ خَدَّامْتُو لِلْفَلَّاحَة بَاشْ يَبْعْثُولُو بَايُو مِنْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","يَاخِي الفَلَّاحَة شَدُّوا خَدَّامْتُو الِّي بْعَثْهُمْ، وضَرْبُوا وَاحِدْ، وقَتْلُوا الآخِرْ، ورَجْمُوا الثَّالِثْ بِالحْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","وبَعْدْهَا، بْعَثْ مُولَى السَّانْيَة خَدَّامَة أُخْرِينْ أَكْثِرْ مِالمَرَّة الأُولَى، يَاخِي عَمْلُوا فِيهُمْ نَفْسْ الشَّيْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","وفِي الإِخِّرْ بْعَثِّلْهُمْ وِلْدُو وقَالْ: \"تَوْ يْقَدْرُوا وِلْدِي\". ");
INSERT INTO aeu_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","وكِي الفَلَّاحَة شَافُوا الوْلِدْ قَالُوا لِبْعَضْهُمْ: \"أَهَوَّا الوْرِيثْ، هَيَّا نُقْتْلُوهْ ونَاخْذُوا أَحْنَا الوَرْثَة مْتَاعُو!\". ");
INSERT INTO aeu_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","وشَدُّوهْ وكَرْكْرُوهْ لْبَرَّا مِالسَّانْيَة وقَتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","مَالَا كِي يِرْجَعْ مُولَى السَّانْيَة، شْنِيَّة بِشْ يَعْمِلْ فِيهُمْ الفَلَّاحَة هَاذُومَا؟». ");
INSERT INTO aeu_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","جَاوْبُوهْ: «يُقْتُلْهُمْ قَتْلَانْ الأَشْرَارْ هَاذُومَا، ويِكْرِي سَانْيِةْ العْنِبْ لْفَلَّاحَة أُخْرِينْ يَعْطِيوَهْ بَايُو مِالصَّابَة فِي وَقْتْهَا». ");
INSERT INTO aeu_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","قَالِلْهُمْ يَسُوعْ: «يَاخِي عْمُرْكُمْ مَا قْرِيتُوا فِي الكْتُبْ المُقَدْسَة: \"الحَجْرَة الِّي رَفْضُوهَا البَنَّايَا، وَلَّاتْ حَجْرِةْ السَّاسْ. هَاذَا آشْ عْمَلْ الرَّبْ، وهَاذِي حَاجَة عْجِيبَة بِالنِّسْبَة لِينَا!\" ");
INSERT INTO aeu_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","«هَاذَاكَا عْلَاشْ نْقُلْكُمْ: مَمْلَكْةْ اللَّهْ بِشْ تِتْفَكِّلْكُمْ وتِتْعْطَى لْشَعْبْ يَعْمِلْ الِّي يُطْلْبُو مِنْهُمْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","الِّي يْطِيحْ عَالحَجْرَة هَاذِي يِتْكَسِّرْ، ولِّي اطِّيحْ عْلِيهْ الحَجْرَة هَاذِي يِدَّڨْدِڨْ». ");
INSERT INTO aeu_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ووَقْتِلِّي سَمْعُوا كْبَارْ الكَهَنَة والفِرِّيسِيِّينْ الزُّوزْ أَمْثَالْ هَاذُومَا، فِهْمُوا الِّي هُوَّ كَانْ يُقْصِدْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","وحَبُّوا يْشِدُّوهْ، آمَا خَافُوا مِالشَّعْبْ، عْلَى خَاطِرْهُمْ كَانُوا يِعْتَبْرُوهْ نَبِيْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","وكَلَّمْهُمْ يَسُوعْ مَرَّة أُخْرَى بِالأَمْثَالْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«مَمْلَكْةْ السْمَاوَاتْ تْشَبَّهْ لْمَلِكْ عْمَلْ عْشَاء فِي عِرْسْ وِلْدُو. ");
INSERT INTO aeu_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","وبْعَثْ عَبِيدُو بَاشْ يْعَيْطُوا لِلْمِسْتِدْعِينْ لِلْعِرْسْ، يَاخِي مَا حَبُّوشْ يْجِيوْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","يَاخِي بْعَثْ المَلِكْ عَبِيدْ أُخْرِينْ وقَالِلْهُمْ: \"قُولُوا لِلْمِسْتِدْعِينْ: عْشَايَا حْضَرْ. ذْبَحْتْ ثِيرَانِي وعْجُولِي السْمَانْ وكُلْ شَيْ حَاضِرْ. إِيجَاوْ لِلْعِرْسْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","آمَا هُومَا مَا اهْتَمُّوشْ، ومْشَاوْ وَاحِدْ لْسَانِيتُو، والآخِرْ لْحَانُوتُو، ");
INSERT INTO aeu_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","والبْقِيَّة شَدُّوا عَبِيدْ المَلِكْ وسَبُّوهُمْ وقَتْلُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","يَاخِي المَلِكْ تْغَشِّشْ وبْعَثْ العَسْكِرْ مْتَاعُو وقْتَلْ المْجَرْمَة هَاذُوكُمْ وحْرَقِّلْهُمْ مْدِينِتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ومْبَعِّدْ قَالْ لْعَبِيدُو: \"العْشَاء حَاضِرْ، آمَا المِسْتَدْعِينْ مَا يِسْتَاهْلُوشْ، ");
INSERT INTO aeu_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","إِمْشِيوْ لِلشْوَارَعْ ولِّي تَلْقَاوَهْ إِسْتَدْعَاوَهْ لِعْشَاء العِرْسْ\". ");
INSERT INTO aeu_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","وخَرْجُوا العَبِيدْ لِلشْوَارَعْ، ولَمُّوا النَّاسْ عْلَى بْعَضْهُمْ أَشْرَارْ وصَالْحِينْ، حَتَّى لِينْ تِمْلَاتْ صَالِةْ العِرْسْ بِالضْيَافْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","آمَا كِي دْخَلْ المَلِكْ بَاشْ يْشُوفْ الضْيَافْ، شَافْ رَاجِلْ مُشْ لَابِسْ لِبْسِةْ العِرْسْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","يَاخِي قَالُّو: \"يَا صَاحْبِي، كِيفَاشْ دْخَلْتْ هْنَا وإِنْتِ مَاكِشْ لَابِسْ لِبْسِةْ العِرْسْ؟\". آمَا الرَّاجِلْ مَا لْقَى مَا يْجَاوِبْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","وَقْتْهَا قَالْ المَلِكْ لِلْعَبِيدْ: \"كَتْفُوهْ مِنْ يْدِيهْ وسَاقِيهْ وطَيْشُوهْ لْبَرَّة فِي الظْلَامْ، غَادِي يْكُونْ البْكَاء والنْدَمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","عْلَى خَاطِرْ المِسْتَدْعِينْ بَرْشَة والمُخْتَارِينْ شْوَيَّة». ");
INSERT INTO aeu_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","وَقْتْهَا مْشَاوْ الفِرِّيسِيِّينْ وتْفَاهْمُوا كِيفَاشْ يْحَصْلُوا يَسُوعْ بْكِلْمَة. ");
INSERT INTO aeu_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","يَاخِي بَعْثُولُو تْلَامْذِتْهُمْ ومْعَاهُمْ جْمَاعَة تَابْعِينْ هِيرُودُسْ وقَالُولُو: «يَا مُعَلِّمْ، أَحْنَا نَعْرْفُوا الِّي إِنْتِ صَادِقْ، وتْعَلِّمْ طْرِيقْ اللَّهْ بِالحَقْ، ومَا تْخَافْ مِنْ حَدْ. عْلَى خَاطْرِكْ مَا تِتْعَامِلْشْ بِالوْجُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","قُولِلْنَا: شْنِيَّة رَايِكْ؟ يَاخِي حْلَالْ نَدْفْعُوا الضَّرَايِبْ لِلْقَيْصِرْ وَلَّا لَا؟». ");
INSERT INTO aeu_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","وعْرَفْ يَسُوعْ الِّي هُومَا يِتْخُوبْثُوا، وقَالِلْهُمْ: «يَا مُنَافْقِينْ! عْلَاشْ تْحِبُّوا تْحَصْلُونِي؟ ");
INSERT INTO aeu_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","وَرِّيوْنِي الفْلُوسْ الِّي تْخَلْصُوا بِيهَا فِي الضَّرِيبَة!». يَاخِي مَدُّولُو بْيَاسَة فُضَّة. ");
INSERT INTO aeu_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","قَالِلْهُمْ يَسُوعْ: «مْتَاعْ شْكُونْ التَّصْوِيرَة هَاذِي، وإِسْمْ شْكُونْ هَاذَا؟» ");
INSERT INTO aeu_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","قَالُوا: «مْتَاعْ القَيْصِرْ!»، قَالِلْهُمْ: «مَالَا أَعْطِيوْ الِّي يْخُصْ القَيْصِرْ لِلْقَيْصِرْ، ولِّي يْخُصْ اللَّهْ لِلَّهْ». ");
INSERT INTO aeu_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","وتْعَجْبُوا مِلِّي سَمْعُوهْ، وخَلَّاوَهْ ومْشَاوْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","وفِي نَفْسْ النْهَارْ، جَاوْ لْيَسُوعْ جْمَاعَة مِالصَّدُّوقِيِّينْ الِّي مَا يَمْنُوشْ بِلِّي فَمَّة قْيَامَة بَعْدْ المُوتْ، وسِأْلُوهْ: ");
INSERT INTO aeu_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","«يَا مُعَلِّمْ، مُوسَى قَالْ: \"إِذَا رَاجِلْ مَاتْ ومَا خَلَّاشْ صْغَارْ، لَازِمْ خُوهْ يْعَرِّسْ بْمَرْتُو ويْجِيبْ صْغَارْ ويْقَيِّدْهُمْ بْإِسْمْ خُوهْ الِّي مَاتْ\". ");
INSERT INTO aeu_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","وكَانْ عَنَّا سَبْعَة أَخْوَة، وعَرِّسْ الأُولَانِي ومَاتْ مِنْ غِيرْ مَا يْجِيبْ صْغَارْ، يَاخِي مَرْتُو خْذَاهَا خُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","وصَارْ نَفْسْ الشَّيْ مْعَ الثَّانِي والثَّالِثْ حَتَّى لِلْخُو السَّابَعْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","وبَعْدْهُمْ الكُلْ، مَاتِتْ المْرَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","مَالَا فِي نْهَارْ القْيَامَة، بِشْ تْكُونْ مَرْتْ شْكُونْ فِيهُمْ؟ هَايْ عَرْسِتْ بِيهُمْ السَّبْعَة!». ");
INSERT INTO aeu_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","جَاوِبْهُمْ يَسُوعْ: «إِنْتُومَا غَالْطِينْ، عْلَى خَاطِرْكُمْ مَا تِفْهْمُوشْ لَا الكْتُبْ المُقَدْسَة ولَا قُوِّةْ اللَّهْ! ");
INSERT INTO aeu_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","عْلَى خَاطِرْ بَعْدْ القْيَامَة مِالمُوتْ، النَّاسْ لَا يْعَرْسُوا ولَا يْعَرْسُولْهُمْ، آمَا بِشْ يْكُونُوا كِي المْلَايْكَة الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","آمَا فِي مَا يْخُصْ قْيَامِةْ المُوتَى، يَاخِي مَا قْرِيتُوشْ شْنِيَّة قَالِلْكُمْ اللَّهْ: ");
INSERT INTO aeu_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","\"آنَا إِلَاهْ إِبْرَاهِيمْ، وإِلَاهْ إِسْحَاقْ، وإِلَاهْ يَعْقُوبْ\"؟ مَالَا اللَّهْ مُشْ إِلَاهْ مُوتَى، آمَا إِلَاهْ حَيِّينْ». ");
INSERT INTO aeu_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","وكِي سَمْعُوا النَّاسْ الكْلَامْ هَاذَا، تْعَجْبُوا مِنْ تَعْلِيمُو. ");
INSERT INTO aeu_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","آمَا كِي سَمْعُوا الفِرِّيسِيِّينْ الِّي هُوَّ سَكِّتْ الصَّدُّوقِيِّينْ، لَمُّوا بْعَضْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ووَاحِدْ مِنْهُمْ، وهُوَّ مِنْ عُلَمَاءْ الشَّرِيعَة، سِأْلُو بَاشْ يْجَرْبُو: ");
INSERT INTO aeu_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«يَا مُعَلِّمْ، آنَاهِي أَعْظِمْ وْصِيَّة فِي الشَّرِيعَة؟». ");
INSERT INTO aeu_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","جَاوْبُو يَسُوعْ: «تْحِبْ الرَّبْ إِلَاهِكْ بْكُلْ قَلْبِكْ، وبْكُلْ رُوحِكْ وبْكُلْ عَقْلِكْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","هَاذِي هِيَّ أَهَمْ وأَعْظِمْ وْصِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","والوْصِيَّة الثَّانْيَة كِيفْهَا: حِبْ قْرِيبِكْ كِيفْ مَا تْحِبْ رُوحِكْ. ");
INSERT INTO aeu_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","الِّي تْعَلْمُو الشَّرِيعَة الكُلْ وكْتُبْ الأَنْبِيَاءْ قَايِمْ عَالزُّوزْ وْصَايَا هَاذُومَا». ");
INSERT INTO aeu_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ووَقْتِلِّي كَانُوا الفِرِّيسِيِّينْ مَلْمُومِينْ مْعَ بْعَضْهُمْ، سْإِلْهُمْ يَسُوعْ: ");
INSERT INTO aeu_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«شْنِيَّة رَايْكُمْ؟ المَسِيحْ هُوَّ وِلْدْ شْكُونْ؟». قَالُولُو: «وِلْدْ دَاوِدْ!». ");
INSERT INTO aeu_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","قَالِلْهُمْ: «مَالَا كِيفَاشْ دَاوِدْ بْوَحْيْ مِالرُّوحْ القُدُسْ يْعَيَّطْلُو \"رَبِّي\" كِي قَالْ: ");
INSERT INTO aeu_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","\"قَالْ اللَّهْ لْرَبِّي: أُقْعُدْ عْلَى يْمِينِي حَتَّى لِينْ نْحُطْ أَعْدَائِكْ تَحْتْ سَاقِيكْ\". ");
INSERT INTO aeu_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","«إِذَا كَانْ دَاوِدْ يَعْيِّطْ لِلْمَسِيحْ رَبْ، مَالَا كِيفَاشْ يْكُونْ المَسِيحْ وِلْدُو؟». ");
INSERT INTO aeu_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","وحَدْ مَا نَجِّمْ يْجَاوْبُو بْكِلْمَة. ومِنْ نْهَارِتْهَا مَا تْجَرَّأْ حَدْ بَاشْ يِسْأْلُو حَتَّى سُؤَالْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ووَقْتْهَا قَالْ يَسُوعْ لِلنَّاسْ ولِتْلَامِذْتُو: ");
INSERT INTO aeu_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ عْطَاوْ لِرْوَاحْهُمْ الحَقْ إِنْهُمْ يْعَلْمُوكُمْ تَوْرَاةْ مُوسَى. ");
INSERT INTO aeu_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","أَحْفْظُوا كُلْ الِّي يْقُولُولْكُمْ عْلِيهْ وأَعْمْلُوا بِيهْ. آمَا مَا تَعْمْلُوشْ كِيفْهُمْ، عْلَى خَاطِرْهُمْ يْقُولُوا حَاجَة ويَعْمْلُوا حَاجَة أُخْرَى ");
INSERT INTO aeu_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ويْحُطُّوا فِي حْمِلْ رْزِينْ عْلَى كْتَافْ النَّاسْ، ومَا يْحَرْكُوشْ حَتَّى صْبُعْ بَاشْ يْعَاونُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ولِّي يَعْمْلُوهْ الكُلْ، يَعْمْلُوهْ بَاشْ النَّاسْ تْشُوفْهُمْ، يْعَرْضُوا فِي العْصَابَة الِّي فِيهَا الآيَاتْ ويْطَوْلُوا فِي أَطْرَافْ حْوَايِجْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ويْحِبُّوا يُقْعْدُوا فِي الصَّفْ الأُوِّلْ فِي المْحَافِلْ والكْرَاسِي الأُولَى فِي المْعَابِدْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ويْحِبُّوا النَّاسْ يْسَلْمُوا عْلِيهُمْ فِي الأَسْوَاقْ، ويْعَيْطُولْهُمْ: \"يَا مُعَلِّمْ! يَا مُعَلِّمْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","«آمَا إِنْتُومَا مَا تْخَلِّيوْ حَتَّى حَدْ يْعَيْطِلْكُمْ \"يَا مُعَلِّمْ\"، عْلَى خَاطِرْكُمْ الكُلْ خْوَاتْ وعَنْدْكُمْ مُعَلِّمْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ومَا تْعَيْطُوا لْحَتَّى حَدْ فِي الأَرْضْ \"يَا بَابَا\"، عْلَى خَاطِرْ عَنْدْكُمْ بُو وَاحِدْ الِّي هُوَّ فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ومَا تْخَلِّيوْ حَتَّى حَدْ يْقُولِلْكُمْ: \"يَا سِيدِي\"، عْلَى خَاطِرْ عَنْدْكُمْ سِيدْ وَاحِدْ الِّي هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","وأَعْظِمْ وَاحِدْ فِيكُمْ لَازْمُو يْكُونْ خْدِيمْ لِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","الِّي يْعَلِّي رُوحُو يَهْبِطْ، ولِّي يْطَيَّحْ مِنْ رُوحُو يَعْلَى. ");
INSERT INTO aeu_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تْسَكْرُوا فِي مَمْلَكْةْ السْمَاوَاتْ فِي وْجُوهْ النَّاسْ، يَاخِي لَا دْخَلْتُوا إِنْتُومَا ولَا خَلِّيتُوا شْكُونْ يُدْخُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تِسْرْقُوا فِي فْلُوسْ الهَجَّالَاتْ، واطَّوْلُوا فِي الصْلَاةْ بَاشْ النَّاسْ تْرَاكُمْ، هَاذَاكَا عْلَاشْ بِشْ تِتْحَاسْبُوا أَكْثِرْ مِالنَّاسْ الأُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تْشُقُّوا البَرْ والبْحَرْ بَاشْ ادَّخْلُوا وَاحِدْ لْدِينْكُمْ، وكِي يُدْخُلْ، تْرُدُّوهْ يِسْتَاهِلْ جْهَنِّمْ قَدْ مَا تِسْتَاهْلُوا إِنْتُومَا بْمَرْتِينْ! ");
INSERT INTO aeu_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","«يَا وِيلْكُمْ يَا قَادَة يَا عِمْيَانْ! تْقُولُوا: \"الِّي يِحْلِفْ بِالهَيْكِلْ مُشْ مَلْزُومْ بِيْمِينُو، آمَا الِّي يِحْلِفْ بِذْهَبْ الهَيْكِلْ، هَاذَاكَا مَلْزُومْ بِيهْ\". ");
INSERT INTO aeu_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","يَا عِمْيَانْ يَلِّي مَا تِفْهْمُوشْ! آنَاهُو الِّي عَنْدُو قِيمَة أَكْثِرْ؟ الذْهَبْ وَلَّا الهَيْكِلْ الِّي خَلَّى الذْهَبْ مْقَدِّسْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","وتْقُولُوا: \"الِّي يِحْلِفْ بِالمَذْبَحْ مُشْ مَلْزُومْ بِيْمِينُو، آمَا الِّي يِحْلِفْ بِالقُرْبَانْ الِّي فُوقْ المَذْبَحْ رَاهُو مَلْزُومْ بِيهْ\". ");
INSERT INTO aeu_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","يَا عِمْيَانْ، آنَاهُو الِّي عَنْدُو قِيمَة أَكْثِرْ؟ القُرْبَانْ وَلَّا المَذْبَحْ الِّي يْخَلِّي القُرْبَانْ مْقَدِّسْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","رَاهُو الِّي يِحْلِفْ بِالمَذْبَحْ، يِحْلِفْ بِيهْ وبْكُلْ الِّي عْلِيهْ، ");
INSERT INTO aeu_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ولِّي يِحْلِفْ بِالهَيْكِلْ، يِحْلِفْ بِيهْ وبِلِّي سَاكِنْ فِيهْ، ");
INSERT INTO aeu_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","ولِّي يِحْلِفْ بِالسْمَاء، يِحْلِفْ بْعَرْشْ اللَّهْ وبِلِّي قَاعِدْ عَالعَرْشْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تَعْطِيوْ العْشُرْ مْتَاعْ النَّعْنَاعْ والشِّبْتْ والكَمُّونْ، ومْهَمْلِينْ أَهَمْ مَا جَاء فِي الشَّرِيعَة: العَدْلْ والرَّحْمَة والأَمَانَة. كَانْ لَازِمْ تَعْمْلُوا هَاذُمْ مِنْ غِيرْ مَا تْهَمْلُوا الأُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","يَا قَادَة يَا عِمْيَانْ! تْصَفِّيوْ فِي المَاء مِالنَّمُّوسَة، آمَا تَبْلْعُوا الجْمَلْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تْنَظْفُوا فِي الكَاسْ والصْحَنْ مِالبَرَّة، وهُومَا مِنْ دَاخِلْ مَلْيَانِينْ بِلِّي نْهِبْتُوهْ وطْمَعْتُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","يَا فِرِّيسِي يَا أَعْمَى! نَظِّفْ الكَاسْ مِنْ دَاخِلْ فِي الأُوِّلْ، بَاشْ يْوَلِّي نْظِيفْ مِنْ بَرَّة زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ كِي القْبُورَاتْ المَدْهُونَة بِالأَبْيِضْ، تُظْهُرْ مِزْيَانَة مِنْ بَرَّة، آمَا مِنْ دَاخِلْ مِلْيَانَة بَعْظَامْ المُوتَى وبِالنْجَاسَة. ");
INSERT INTO aeu_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","هَكَّاكَا إِنْتُومَا زَادَا، مِنْ بَرَّة تُظْهْرُوا لِلنَّاسْ صَالْحِينْ، آمَا مِنْ دَاخِلْ إِنْتُومَا مِلْيَانِينْ بِالنِّفَاقْ والشَّرْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","«يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة ويَا الفِرِّيسِيِّينْ المُنَافْقِينْ! عْلَى خَاطِرْكُمْ تِبْنِيوْ فِي قْبُورَاتْ الأَنْبِيَاءْ وتْزَيْنُوا فِي البْلَايِصْ المَدْفُونِينْ فِيهُمْ الصَّالْحِينْ، ");
INSERT INTO aeu_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","وتْقُولُوا: \"كَانْ جِينَا مَوْجُودِينْ فِي وَقْتْ جْدُودْنَا، رَانَا مَا شَارِكْنَاهُمْشْ فِي قَتْلَانْ الأَنْبِيَاءْ\". ");
INSERT INTO aeu_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","وهَكَّا قَاعْدِينْ تِشْهْدُوا عْلَى رْوَاحْكُمْ الِّي إِنْتُومَا وْلَادْ الِّي قَتْلُوا الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","مَالَا كَمْلُوا إِنْتُومَا الِّي بْدَاوَهْ جْدُودْكُمْ بَاشْ الكَاسْ يْفِيضْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","«يَا حْنُوشَة يَا وْلَادْ الأَفَاعِي! كِيفَاشْ بِشْ تِفْلْتُوا مِنْ عِقَابْ جْهَنِّمْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","هَاذَاكَا عْلَاشْ آنَا بِشْ نَبْعْثِلْكُمْ أَنْبِيَاءْ وحُكَمَاءْ وعُلَمَاء الشَّرِيعَة، مِنْهُمْ الِّي بِشْ تُقْتْلُوهُمْ وتُصْلْبُوهُمْ، ومِنْهُمْ الِّي بِشْ تِجْلْدُوهُمْ فِي مَعَابِدْكُمْ، وتْشِدُّوا جُرِّتْهُمْ مِنْ مْدِينَة لِمْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","وهَاذَا الِّي بِشْ يْخَلِّيكُمْ تِتْحَاسْبُوا عْلَى دَمْ الصَّالْحِينْ الِّي جْرَى عَالأَرْضْ، مِنْ دَمْ هَابِيلْ الصَّالَحْ لْدَمْ زَكَرِيَّا وِلْدْ بَرَخِيَّا الِّي قْتَلْتُوهْ مَا بِينْ الهَيْكِلْ والمَذْبَحْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","نْقُلْكُمْ الحَقْ: الجِيلْ هَاذَا هُوَّ الِّي بِشْ يِتْعَاقِبْ عْلَى هَاذَا الكُلْ!». ");
INSERT INTO aeu_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«يَا أُورْشَلِيمْ، يَا أُورْشَلِيمْ، يَلِّي تُقْتُلْ فِي الأَنْبِيَاءْ وتُرْجُمْ فِلِّي يِتْبَعْثُولْهَا، قَدَّاشْ مِنْ مَرَّة حَبِّيتْ نْلِمْ أَوْلَادِكْ، كِيفْ مَا تْلِمْ الدْجَاجَة فْلَالِسْهَا تَحْتْ جْنَاحَاتْهَا، آمَا إِنْتُومَا مَا حَبِّيتُوشْ. ");
INSERT INTO aeu_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","هَايْ دَارْكُمْ بِشْ تَبْقَالْكُمْ خِرْبَة! ");
INSERT INTO aeu_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ونْقُولِلْكُمْ: مِنْ تَوَّا مَا عَادِشْ بِشْ تْرَاوْنِي حَتَّى لِينْ يْجِي الوَقْتْ الِّي تْقُولُوا فِيهْ \"مُبَارَكْ الِّي جَايْ بْإِسْمْ الرَّبْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","وخْرَجْ يَسُوعْ مِالهَيْكِلْ. وهُوَّ يِمْشِي جَاوَهْ تْلَامِذْتُو وبْدَاوْ يْوَرِّيوْ فِيهْ فِي الهَيْكِلْ كِيفَاشْ مِبْنِي. ");
INSERT INTO aeu_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","قَالِلْهُمْ: «شُفْتُوا هَاذَا الكُلْ؟ نْقُلْكُمْ الحَقْ: لَاحَجْرَة مِنُّو بِشْ تِبْقَى فُوقْ أُخْتْهَا، الكُلُّو بِشْ يِتْهَدْ». ");
INSERT INTO aeu_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","وهُوَّ قَاعِدْ فِي جْبَلْ الزِّيتُونْ، جِبْدُوهْ تْلَامِذْتُو عْلَى جْنَبْ وقَالُولُو: «قُولِلْنَا: وَقْتَاشْ بِشْ يْصِيرْ هَاذَا؟ وشْنِيَّة الأَمَارَة الِّي نَعْرْفُوا بِيهَا وَقْتْ رْجُوعِكْ ونْهَايِةْ الزْمَانْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","جَاوِبْهُمْ يَسُوعْ: «رُدُّوا بَالْكُمْ لَا حَدْ يْغَلِّطْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","بِشْ يْجِيوْ بَرْشَة بْإِسْمِي ويْقُولُوا: آنَا هُوَّ المَسِيحْ! ويْغَلْطُوا بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","وبِشْ تِسْمْعُوا بِحْرُوبَاتْ وأَخْبَارْ حْرُوبَاتْ، رُدُّوا بَالْكُمْ تْخَافُوا. عْلَى خَاطِرْ هَاذَا لَازْمُو يْصِيرْ، آمَا مُشْ هَاذِي هِيَّ النِّهَايَة. ");
INSERT INTO aeu_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","بِشْ تِتْقْلِبْ أُمَّة عْلَى أُمَّة، ومَمْلْكَة عْلَى مَمْلْكَة، وتْصِيرْ مَجَاعَاتْ وزْلَازِلْ فِي بَرْشَة بْلَايِصْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","آمَا هَاذِي مَاهِي إِلَّا بْدَايِةْ الوْجَايَعْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","فِي الوَقْتْ هَاذَاكَا بِشْ يْعَذْبُوكُمْ ويُقْتْلُوكُمْ. وتْكُونُوا مَكْرُوهِينْ عَنْدْ الشُّعُوبْ الكُلْ عْلَى خَاطِرْ إِسْمِي. ");
INSERT INTO aeu_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ووَقْتْهَا بَرْشَة بِشْ يِرْتَدُّوا عَالإِيمَانْ، ويْخُونُوا بْعَضْهُمْ ويِكْرْهُوا بْعَضْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ويُظْهْرُوا بَرْشَة أَنْبِيَاءْ كَذَّابِينْ ويْغَلْطُوا بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ومِنْ كُثْرِةْ الشَّرْ، تِبْرِدْ المْحَبَّة فِي قْلُوبْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","آمَا الِّي يِثْبِتْ لِلِّخِّرْ، هُوَّ الِّي يِنْجَى. ");
INSERT INTO aeu_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","وبْشَارِةْ مَمْلَكْةْ اللَّهْ هَاذِي بِشْ يِسْمَعْ بِيهَا العَالِمْ أَجْمَعْ، وتُوصِلْ الشْهَادَة لِلشْعُوبْ الكُلْ، ومْبَعِّدْ تْجِي النِّهَايَة. ");
INSERT INTO aeu_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«وَقْتِلِّي تْشُوفُوا \"النْجَاسَة الِّي تْخَرِّبْ\" الِّي حْكَى عْلِيهَا النَّبِيْ دَانْيَالْ مَوْجُودَة فِي البْلَاصَة المُقَدْسَة، — خَلِّي القَارِي يِفْهِمْ — ");
INSERT INTO aeu_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","وَقْتْهَا يِلْزِمْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة يُهْرْبُوا لِلجْبَالْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ولِّي فُوقْ السْطَحْ، مَا يَهْبَطْشْ لْدَارُو بَاشْ يْهِزْ دَبْشُو. ");
INSERT INTO aeu_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ولِّي فِي السَّانْيَة، مَا يِرْجَعْشْ بَاشْ يْهِزْ حْوَايْجُو. ");
INSERT INTO aeu_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","يَا وِيلْهُمْ النْسَاء الحْبَالَى ولِّي يْرَضْعُوا فِي الأَيَّامَاتْ هَاذُوكُمْ! ");
INSERT INTO aeu_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","صَلِّيوْ بَاشْ مَا يْكُونِشْ هْرُوبْكُمْ فِي الشْتَاء ولَا فِي نْهَارْ سِبْتْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","عْلَى خَاطِرْ فِي الأَيَّامَاتْ هَاذُوكُمْ بِشْ يْصِيرْ ضِيقْ كْبِيرْ، مَا صَارِشْ كِيفُو مِلِّي تْخَلْقِتْ الدِّنْيَا لْتَوَّا، ومُشْ بِشْ يْزِيدْ يْصِيرْ بِالكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","وكَانْ مَا جَاشْ اللَّهْ قَصَّرْ الأَيَّامَاتْ هَاذُوكُمْ، رَاوْ حَتَّى حَدْ مَا يْنَجِّمْ يِنْجَى. آمَا هُوَّ قَصَّرْهُمْ عْلَى خَاطِرْ النَّاسْ الِّي إِخْتَارْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","«إِذَا قَالِلْكُمْ وَاحِدْ وَقْتْهَا: \"هَاوْ المَسِيحْ هُونِي!\" وَلَّا \"أَهَوْكَا غَادِي\"، مَا تْصَدْقُوهُوشْ! ");
INSERT INTO aeu_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","عْلَى خَاطِرْ بِشْ يُظْهْرُوا أَكْثِرْ مِنْ مَسِيحْ دَجَّالْ وبَرْشَة أَنْبِيَاءْ كَذَّابِينْ، ويَعْمْلُوا مُعْجْزَاتْ وعْجَايِبْ بَاشْ يْحَاوْلُوا يْغَلْطُوا بِيهُمْ حَتَّى النَّاسْ الِّي إِخْتَارْهُمْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","هَانِي قُلْتِلْكُمْ كُلْ شَيْ قْبَلْ مَا يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","مَالَا كَانْ قَالُولْكُمْ: \"أَهَوَّا المَسِيحْ فِي الخْلَاء!\" مَا تِمْشِيوِشْ لْغَادِي، وَلَّا: \"أَهَوَّا فِي الدْيَارْ لْدَاخِلْ\" مَا تْصَدْقُوشْ! ");
INSERT INTO aeu_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","رَاهُو، كِيمَا يَضْرِبْ البْرَقْ فِي الشَّرْقْ ويِضْوِي فِي الغَرْبْ، هَكَّا يْكُونْ رْجُوعْ إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","عْلَى خَاطِرْ وِينْ فَمَّة الجِيفَة، غَادِي تِتْلَمْ النْسُورَا. ");
INSERT INTO aeu_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«وبِالوَقْتْ، بَعْدْ ضِيقْ الأَيَّامَاتْ هَاذِيكَا، بِشْ تِظْلَامْ الشَّمْسْ، ويِتْحْجِبْ ضَوْء الڨَمْرَة، ونْجُومْ السْمَاء اطِّيحْ، وتِتْزَعْزَعْ كُلْ قُوَّة فِي السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","وَقْتْهَا تُظْهُرْ عَلَامِةْ إِبْنْ الإِنْسَانْ فِي السْمَاء، وقْبَايِلْ الأَرْضْ الكُلْ بِشْ تْنَوَّحْ، ويْشُوفُوا إِبْنْ الإِنْسَانْ جَايْ عَالسْحَابْ بْقُوَّة عْظِيمَة ومَجْدْ، ");
INSERT INTO aeu_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ويَبْعَثْ مْلَايِكْتُو يْبَوْقُوا بْصُوتْ عْظِيمْ، ويْلِمُّوا النَّاسْ الِّي إِخْتَارْهُمْ مِالشَّرْقْ والغَرْبْ والشَّمَالْ والجَنُوبْ، مِنْ كُلْ بْلَاصَة تَحْتْ السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«خُوذُوا العِبْرَة مِالكَرْمَة: دُوبْ مَا أَعْرَافْهَا تِخْضَارْ واطَّلَّعْ الأَوْرَاقْ، تَعْرْفُوا الِّي الصِّيفْ قْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","وإِنْتُومَا زَادَا، كِي تْشُوفُوا الحَاجَاتْ هَاذِي قَاعْدَة تْصِيرْ، أَعْرْفُوا الِّي الوَقْتْ قْرُبْ وعَالأَبْوَابْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","نْقُلْكُمْ الحَقْ: الحَاجَاتْ هَاذِي الكُلْ بِشْ تْصِيرْ قْبَلْ مَا يْمُوتْ الجِيلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","السْمَاء والأَرْضْ يِفْنَاوْ، آمَا كْلَامِي عُمْرُو مَا يِفْنَى. ");
INSERT INTO aeu_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«آمَا النْهَارْ هَاذَاكَا والسَّاعَة هَاذِيكَا مَا يَعْرَفْهُمْ حَتَّى حَدْ، لَا المْلَايْكَة الِّي فِي السْمَاء، ولَا الإِبْنْ، مَا يَعْرِفْهُمْ كَانْ الآبْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","وكِيفْ مَا صَارْ فِي زْمَانْ نُوحْ، هَكَّاكَا بَاشْ يْصِيرْ كِي يْجِي إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","كَانُوا النَّاسْ فِي الأَيَّامَاتْ الِّي قْبَلْ الطُّوفَانْ، يَاكْلُوا ويُشُرْبُوا ويْعَرْسُوا ويْعَرْسُولْهُمْ، حَتَّى لِينْ جَاء النْهَارْ الِّي دْخَلْ فِيهْ نُوحْ لِلسْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","وعْلَى غَفْلَة، جَاء الطُّوفَانْ وهَزْهُمْ الكُلْ. هَكَّاكَا بِشْ يْصِيرْ كِي يْجِي إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","فِي الوَقْتْ هَاذَاكَا، يْكُونُوا زُوزْ رْجَالْ فِي السَّانْيَة، يِتْهَزْ وَاحِدْ ويِبْقَى الآخِرْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ويْكُونُوا زُوزْ نْسَاء يِرْحِيوْ مْعَ بْعَضْهُمْ بِالرْحَى، تِتْهَزْ وَحْدَة وتِبْقَى الأُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","مَالَا خَلِّيكُمْ فَايْقِينْ، رَاكُمْ مَا تَعْرْفُوشْ أَنَاهُو النْهَارْ الِّي يِرْجَعْ فِيهْ سِيدْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","وأَعْرْفُوا هَاذَا: كَانْ جَاء مُولَى الدَّارْ يَعْرِفْ وَقْتَاشْ يَهْبِطْ عْلِيهْ السَّارَقْ، رَاهُو سْهَرْ ومَا خَلَّاشْ دَارُو تِتْسْرَقْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","كُونُوا إِنْتُومَا زَادَا مُسْتْعَدِّينْ، عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ بِشْ يِرْجَعْ فِي سَاعَة مَا تِتْوَقْعُوهَاشْ». ");
INSERT INTO aeu_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«شْكُونُو الخْدِيمْ الثِّيقَة والحَكِيمْ الِّي يْكَلْفُو سِيدُو بَاشْ يَعْطِي خُدَّامُو الأُخْرِينْ مَاكْلِتْهُمْ فِي وَقْتْهَا؟ ");
INSERT INTO aeu_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","صَحَّة لِيهْ الخْدِيمْ هَاذَاكَا، الِّي كِي يِرْجَعْ سِيدُو يَلْقَاهْ يِخْدِمْ فِي خِدْمْتُو. ");
INSERT INTO aeu_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","نْقُلْكُمْ الحَقْ: هَاذَا يْحُطُّو سِيدُو مَسْؤُولْ عْلَى أَمْلَاكُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","آمَا إِذَا كَانْ الخْدِيمْ هَاذَا شِرِّيرْ وقَالْ بِينُو وبِينْ رُوحُو: \"سِيدِي بِشْ يِرْجَعْ إِمَّخِّرْ\" ");
INSERT INTO aeu_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","وبْدَا يَضْرِبْ فِي الخُدَّامْ الِّي مْعَاهْ، ويَاكِلْ ويُشْرُبْ مْعَ السُّوكَّارْجِيَّة، ");
INSERT INTO aeu_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","يِرْجَعْ سِيدُو عْلَى غَفْلَة، فِي نْهَارْ مَا يْجِيشْ عْلَى بَالُو وفِي سَاعَة مَا يَعْرِفْهَاشْ، ");
INSERT INTO aeu_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ويْعَاقْبُو عِقَابْ كْبِيرْ ويْوَلِّي مْصِيرُو مْعَ المُنَافْقِينْ. غَادِي وِينْ يْكُونْ البْكَاء والنْدَمْ». ");
INSERT INTO aeu_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«فِي الوَقْتْ هَاذَاكَا، تْشَبَّهْ مَمْلَكْةْ السْمَاوَاتْ لْعَشْرَة ضْيُوفْ صْبَايَا هَزُّوا فْنَارَاتْهُمْ ومْشَاوْ بَاشْ يْعَرْضُوا لِلْعْرُوسْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","خَمْسَة مِنْهُمْ عَنْدْهُمْ حِكْمَة، والخَمْسَة الأُخْرِينْ مَا عَنْدْهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","الِّي مَا عَنْدْهُمْشْ حِكْمَة هَزُّوا فْنَارَاتْهُمْ، ومَا هَزُّوشْ مْعَاهُمْ زِيتْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","آمَا الِّي عَنْدْهُمْ حِكْمَة، هَزُّوا بْزَايِدْ زِيتْ مْعَ فْنَارَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","وبْطَى العْرُوسْ، يَاخِي الكُلْهُمْ نِعْسُوا ورَقْدُوا. ");
INSERT INTO aeu_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","ومْعَ نُصْ اللِّيلْ، فَمَّة صُوتْ صَاحْ: \"هَاوْ العْرُوسْ جَاء، أُخْرْجُوا بَاشْ تْقَابْلُوهْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","يَاخِي قَامُوا الصْبَايَا العَشْرَة الكُلْ وحَضّْرُوا فْنَارَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ولِّي مَا عَنْدْهُمْشْ حِكْمَة قَالُوا لِلْأُخْرِينْ: \"أَعْطِيوْنَا شْوَيَّة مِنْ زِيتْكُمْ، عْلَى خَاطِرْ فْنَارَاتْنَا قَاعْدَة تِطْفَى\". ");
INSERT INTO aeu_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","آمَا الِّي عَنْدْهُمْ حِكْمَة جَاوْبُوا: \"مُمْكِنْ مَا يِكْفِيشْ لِينَا ولِيكُمْ، إِمْشِيوْ لِلِّي يْبِيعُوا فِي الزِّيتْ وإِشْرِيوْ الِّي تَحْتَاجُوهْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","وهُومَا مَاشْيِينْ بَاشْ يِشْرِيوْ، وْصُلْ العْرُوسْ. ودَخْلُوا مْعَاهْ الصْبَايَا المِسْتَدْعِينْ لِلْعِرْسْ، وتْسَكِّرْ البَابْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","وبَعْدْ مُدَّة، خَلْطُوا الصْبَايَا الأُخْرِينْ وقَالُوا لِلْعْرُوسْ: \"يَا سِيدْنَا، يَا سِيدْنَا، حِلِّلْنَا البَابْ!\". ");
INSERT INTO aeu_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","جَاوِبْهُمْ العْرُوسْ: \"نْقُلْكُمْ الحَقْ: آنَا مَا نَعْرِفْكُمْشْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","مَالَا خَلِّيكُمْ فَايْقِينْ، عْلَى خَاطِرْكُمْ مَا تَعْرْفُوشْ لَا النْهَارْ ولَا السَّاعَة. ");
INSERT INTO aeu_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«وتْشَبَّهْ مَمْلَكْةْ السْمَاوَاتْ لْرَاجِلْ حَبْ يْسَافِرْ، يَاخِي اسْتَدْعَى خُدَّامُو وعْطَاهُمْ فْلُوسُو. ");
INSERT INTO aeu_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","عْطَى لِلْأُوِّلْ خَمْسَة صْرُرْ فْلُوسْ، والثَّانِي زُوزْ صْرُرْ، والثَّالِثْ صُرَّة وَحْدَة، كُلْ وَاحِدْ عْلَى قَدْرْ طَاقْتُو، وبَعْدْهَا سَافِرْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","الِّي خْذَا الخَمْسَة صْرُرْ مْشَى بِالوَقْتْ وتَاجِرْ بِيهُمْ، ورْبِحْ خَمْسَة صْرُرْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ولِّي خْذَا الزُّوزْ صْرُرْ عْمَلْ كِيفُو، ورْبِحْ زُوزْ صْرُرْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","آمَا الِّي خْذَا صُرَّة وَحْدَة، مْشَى حْفَرْ حُفْرَة فِي الأَرْضْ، وخَبَّى فِيهَا فْلُوسْ سِيدُو. ");
INSERT INTO aeu_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","«وبَعْدْ مُدَّة طْوِيلَة، رْجَعْ سِيدْ الخُدَّامْ هَاذُوكُمْ وحَاسِبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","وجَاء الِّي خْذَا الخَمْسَة صْرُرْ، وجَابْ خَمْسَة صْرُرْ زَايْدِينْ وقَالْ: \"يَا سِيدِي، إِنْتِ عْطِيتْنِي خَمْسَة صْرُرْ، وهَانِي رْبِحْتْ فُوقْهُمْ خَمْسَة صْرُرْ أُخْرِينْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","يَاخِي قَالُّو سِيدُو: \"صَحِّيتْ، إِنْتِ خْدِيمْ صَالَحْ وثِيقَة. عْلَى خَاطْرِكْ كُنْتْ أَمِينْ فِي الشْوَيَّة، هَانِي بِشْ نَمْنِكْ عَالبَرْشَة: أُدْخُلْ وتَمَتَّعْ بْنَعِيمْ سِيدِكْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","ولِّي خْذَا الزُّوزْ صْرُرْ جَاء هُوَّ زَادَا، وقَالْ: \"يَا سِيدِي، إِنْتِ عْطِيتْنِي زُوزْ صْرُرْ، وهَانِي رْبِحْتْ فُوقْهُمْ زُوزْ صْرُرْ أُخْرِينْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","يَاخِي قَالُّو سِيدُو: \"صَحِّيتْ، إِنْتِ خْدِيمْ صَالَحْ وثِيقَة. عْلَى خَاطْرِكْ كُنْتْ أَمِينْ فِي الشْوَيَّة، هَانِي بِشْ نَمْنِكْ عَالبَرْشَة: أُدْخُلْ وتَمَتَّعْ بْنَعِيمْ سِيدِكْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","وجَاء زَادَا الِّي خْذَا صُرَّة وَحْدَة، وقَالْ: \"يَا سِيدِي، نَعْرِفْ الِّي إِنْتِ رَاجِلْ قَاسِي، تَحْصِدْ مِنْ وِينْ مَا زْرَعْتِشْ، وتْلِمْ مِنْ وِينْ مَا غْرَسْتِشْ، ");
INSERT INTO aeu_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","يَاخِي خُفْتْ، ومْشِيتْ خَبِّيتْ الصُّرَّة مْتَاعِكْ فِي الأَرْضْ، وهَايْ فْلُوسِكْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","جَاوْبُو سِيدُو: \"يَا خْدِيمْ يَا شِرِّيرْ يَا بُخْلِي! كِي إِنْتِ تَعْرِفْ الِّي آنَا نَحْصِدْ مِنْ وِينْ مَا زْرَعْتِشْ، ونْلِمْ مِنْ وِينْ مَا غْرِسْتِشْ، ");
INSERT INTO aeu_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","مُشْ أَحْسَنْلِكْ كَانْ حَطِّيتْلِي فْلُوسِي فِي البَانْكَة، بَاشْ كِي نِرْجَعْ، نَاخِذْهُمْ ومْعَاهُمْ رِبْحْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","وقَالْ لْخُدَّامُو: \"خُوذُوا الصُّرَّة مِنْ عَنْدُو، وأَعْطِيوْهَا لِلِّي عَنْدُو العَشْرَة صْرُرْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","عْلَى خَاطِرْ الِّي عَنْدُو بِشْ يِتَعْطَالُو أَكْثِرْ ويْفِيضْ، ولِّي مَا عَنْدُوشْ، حَتَّى الِّي عَنْدُو بِشْ يِتْفَكْلُو. ");
INSERT INTO aeu_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","والخْدِيمْ هَاذَا الِّي مَا مِنُّوشْ فَايْدَة، إِرْمِيوَهْ لْبَرَّة فِي الظْلَامْ. غَادِي وِينْ البْكَاء والنْدَمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«وَقْتِلِّي يِرْجَعْ إِبْنْ الإِنْسَانْ فِي مَجْدُو، ومْعَاهْ المْلَايْكَة الكُلْ، يُقْعُدْ عْلَى عَرْشُو العْظِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ويِتْلَمُّوا قُدَّامُو الشُّعُوبْ الكُلْ، ويِفْرِزْهُمْ مِنْ بْعَضْهُمْ، كِيمَا يِفْرِزْ السَّارَحْ العْلَالِشْ مِالمْعِيزْ. ");
INSERT INTO aeu_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ويْحُطْ العْلَالِشْ عْلَى يْمِينُو والمْعِيزْ عْلَى يْسَارُو. ");
INSERT INTO aeu_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ومْبَعِّدْ يْقُولْ المَلِكْ لِلِّي عْلَى يْمِينُو: \"إِيجَاوْ، يَلِّي بَارِكْكُمْ بَابَا، أُورْثُوا المَمْلْكَة الِّي تْحَضْرِتِّلْكُمْ مِلِّي تْخَلْقِتْ الدِّنْيَا، ");
INSERT INTO aeu_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","عْلَى خَاطِرْنِي جُعْتْ وإِنْتُومَا وَكَّلْتُونِي، وعْطُشْتْ وإِنْتُومَا شَرَّبْتُونِي، وكُنْتْ غْرِيبْ وإِنْتُومَا سَكَّنْتُونِي، ");
INSERT INTO aeu_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","كُنْتْ عِرْيَانْ وإِنْتُومَا لَبَّسْتُونِي، وكُنْتْ مْرِيضْ وإِنْتُومَا زُرْتُونِي، وكُنْتْ مَرْبُوطْ فِي حَبْسْ وإِنْتُومَا جِيتُونِي\". ");
INSERT INTO aeu_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","وَقْتْهَا الصَّالْحِينْ يْجَاوْبُوهْ: \"يَا سِيدِي، وَقْتَاشْ شُفْنَاكْ جِيعَانْ ووَكَّلْنَاكْ؟ وَلَّا عُطْشَانْ وشَرَّبْنَاكْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ووَقْتَاشْ شُفْنَاكْ غْرِيبْ وسَكِّنَّاكْ؟ وَلَّا عِرْيَانْ ولَبِّسْنَاكْ؟ ");
INSERT INTO aeu_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ووَقْتَاشْ شُفْنَاكْ مْرِيضْ وَلَّا مَرْبُوطْ وزُرْنَاكْ؟\" ");
INSERT INTO aeu_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","والمَلِكْ يْجَاوِبْهُمْ: \"نْقُلْكُمْ الحَقْ: مَادَامْ عْمَلْتُوا هَاذَا مْعَ وَاحِدْ مِنْ خْوَاتِي الصْغَارْ، مَعْنَاهَا عْمَلْتُوهْ مْعَايَا آنَا!\". ");
INSERT INTO aeu_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","ومْبَعِّدْ يْقُولْ لِلِّي عْلَى يْسَارُو: \"إِبْعْدُوا عْلِيَّا يَا مَلْعُونِينْ وإِمْشِيوْ لِلنَّارْ الِّي مَا تِطْفَاشْ، الِّي تْحَضْرِتْ لْإِبْلِيسْ ومْلَايِكْتُو، ");
INSERT INTO aeu_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","عْلَى خَاطِرْنِي جُعْتْ ومَا وَكَّلْتُونِيشْ، وعْطُشِتْ ومَا شَرَّبْتُونِيشْ، ");
INSERT INTO aeu_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","وكُنْتْ غْرِيبْ ومَا سَكَّنْتُونِيشْ، وعِرْيَانْ ومَا لَبَّسْتُونِيشْ، ومْرِيضْ ومَرْبُوطْ ومَا زُرْتُونِيشْ\". ");
INSERT INTO aeu_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","وَقْتْهَا هُومَا زَادَا بِشْ يْجَاوْبُوا: \"يَا سِيدِي، وَقْتَاشْ شُفْنَاكْ جِيعَانْ وَلَّا عُطْشَانْ وَلَّا غْرِيبْ وَلَّا عِرْيَانْ وَلَّا مْرِيضْ وَلَّا مَرْبُوطْ ومَا عَاوِنَّاكِشْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","والمَلِكْ يْجَاوِبْهُمْ: \"نْقُلْكُمْ الحَقْ: مَادَامْكُمْ مَا عْمَلْتُوشْ هَاذَا مْعَ وَاحِدْ مِنْ خْوَاتِي الصْغَارْ، يَعْنِي مَا عْمَلْتُوهُوشْ مْعَايَا آنَا\". ");
INSERT INTO aeu_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","وهَاذُوكُمْ يِمْشِيوْ لِلْعْذَابْ الِّي مَا يُوفَاشْ، والصَّالْحِينْ يِمْشِيوْ لِلْحَيَاةْ الأَبَدِيَّة». ");
INSERT INTO aeu_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ووَقْتِلِّي كَمِّلْ يَسُوعْ كْلَامُو هَاذَا الكُلْ، قَالْ لِتْلَامِذْتُو: ");
INSERT INTO aeu_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«إِنْتُومَا تَعْرْفُوا الِّي عِيدْ الفِصْحْ اليْهُودِي يْجِي بَعْدْ نْهَارِينْ، وإِبْنْ الإِنْسَانْ يْسَلْمُوهْ بَاشْ يِتْصْلَبْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","فِي الوَقْتْ هَاذَاكَا تْلَمُّوا كْبَارْ الكَهَنَة وشْيُوخْ الشَّعْبْ فِي دَارْ الكَاهِنْ الكْبِيرْ الِّي إِسْمُو قَيَافَا، ");
INSERT INTO aeu_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","وتْشَاوْرُوا مْعَ بْعَضْهُمْ بَاشْ يَعْمْلُوا حِيلَة يْشِدُّوا بِيهَا يَسُوعْ ويُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","آمَا قَالُوا: «مَا نَعْمْلُوشْ هَاذَا فِي العِيدْ، بَاشْ مَا يْهِيجِشْ الشَّعْبْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ووَقْتِلِّي كَانْ يَسُوعْ فِي بِيتْ عَنْيَا فِي دَارْ سِمْعَانْ الأَبْرِصْ، ");
INSERT INTO aeu_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","جَاتُو مْرَا وفِي يْدِيهَا دَبُّوزَة عِطْرْ غَالْيَة بَرْشَة، وصَبِّتْهَا فُوقْ رَاسُو وهُوَّ يِتْعَشَّى. ");
INSERT INTO aeu_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","وكِي شَافُوا التْلَامْذَة الِّي عَمْلِتُّو، مَا عْجِبْهُمْشْ وقَالُوا: «عْلَاشْ التَّبْذِيرْ هَاذَا؟ ");
INSERT INTO aeu_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","العِطْرْ هَاذَا كَانْ يْنَجِّمْ يِتْبَاعْ إِبَّرْشَة فْلُوسْ، والفْلُوسْ تِتْعْطَى لِلْفْقَارَى». ");
INSERT INTO aeu_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","عْرَفْ يَسُوعْ الحْكَايَة وقَالِلْهُمْ: «أَخْطَاوْهَا! عْلَاشْ تْقَلْقُوا فِيهَا؟ رَاهِي عَمْلِتْلِي حَاجَة بَاهْيَة. ");
INSERT INTO aeu_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","الفْقَارَى دِيمَا مَوْجُودِينْ، آمَا آنَا مَانِيشْ بِشْ نَبْقَى عَنْدْكُمْ دِيمَا. ");
INSERT INTO aeu_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","هِيَّ كِي صَبِّتْ العِطْرْ عْلَى بَدْنِي، قَاعْدَة تْحَضِّرْ فِيَّا لِدْفِينْتِي. ");
INSERT INTO aeu_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","نْقُلْكُمْ الحَقْ: وِينْ مَا تِتْنْشَرْ البْشَارَة فِي العَالِمْ الكُلْ، النَّاسْ بِشْ يَحْكِيوْ عَلِّي عَمْلِتُّو المْرَا هَاذِي، ويُقْعْدُوا دِيمَا يِتْفَكْرُوهَا!». ");
INSERT INTO aeu_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","فِي الوَقْتْ هَاذَاكَا وَاحِدْ مِالأَثْنَاشِنْ تِلْمِيذْ، ولِّي إِسْمُو يَهُوذَا الإِسْخَرْيُوطِي، مْشَى لِكْبَارْ الكَهَنَة، ");
INSERT INTO aeu_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","وقَالِلْهُمْ: «قَدَّاشْ تَعْطِيوْنِي بَاشْ نْسَلَّمْكُمْ يَسُوعْ؟». يَاخِي دَفْعُولُو ثْلَاثِينْ بْيَاسَة فُضَّة. ");
INSERT INTO aeu_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ومِنْ وَقْتْهَا، بْدَا يَهُوذَا يْلَوِّجْ عْلَى فُرْصَة بَاشْ يْسَلْمُو. ");
INSERT INTO aeu_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","فِي أَوِّلْ أَيَّامَاتْ عِيدْ الفْطِيرْ الِّي بْلَاشْ خْمِيرَة، جَاوْ التْلَامْذَة لْيَسُوعْ وقَالُولُو: «وِينْ تْحِبْنَا نْحَضْرُولِكْ عْشَاء الفِصْحْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","جَاوِبْهُمْ: «إِمْشِيوْ لِفْلَانْ فِي المْدِينَة وقُولُولُو: \"قَالِّكْ المُعَلِّمْ: سَاعْتِي قُرْبِتْ، وبِشْ نَاكِلْ عْشَاء الفِصْحْ مْعَ تْلَامِذْتِي فِي دَارِكْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","وعَمْلُوا التْلَامْذَة كِيمَا قَالِلْهُمْ يَسُوعْ وحَضْرُوا عْشَاء الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","وفِي العْشِيَّة، قْعَدْ يَسُوعْ بَاشْ يَاكِلْ مْعَ تْلَامِذْتُو الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","وهُومَا يَاكْلُوا، قَالْ يَسُوعْ: «نْقُلْكُمْ الحَقْ: وَاحِدْ مِنْكُمْ بِشْ يْخُونِّي». ");
INSERT INTO aeu_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","وحِزْنُوا التْلَامْذَة، وبْدَاوْ يِسْأْلُوا فِيهْ بِالوَاحِدْ: «يَاخِي آنَا هُوَّ، يَا سِيدِي؟». ");
INSERT INTO aeu_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","جَاوِبْهُمْ: «الِّي كْلَا مْعَايَا مِنْ نَفْسْ الصْحَنْ هُوَّ الِّي بِشْ يْخُونِّي. ");
INSERT INTO aeu_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","إِبْنْ الإِنْسَانْ لَازْمُو يْمُوتْ كِيمَا مَكْتُوبْ عْلِيهْ فِي الكْتُبْ المُقَدْسَة، آمَا يَا وِيلُو الرَّاجِلْ الِّي بِشْ يْسَلْمُو. خِيرْلُو كَانْ مَا تُولِدْشْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","يَاخِي سِأْلُو يَهُوذَا الِّي خَانُو: «يَاخِي آنَا هُوَّ، يَا مُعَلِّمْ؟» جَاوْبُو يَسُوعْ: «إِنْتِ بِيدِكْ قُلْتْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","وهُومَا يَاكْلُوا، خْذَا يَسُوعْ خُبْزْ وشْكَرْ اللَّهْ وقْسِمْ وعْطَى لِتْلَامِذْتُو وقَالْ: «خُوذُوا كُولُوا، هَاذَا هُوَّ بَدْنِي». ");
INSERT INTO aeu_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ومْبَعِّدْ خْذَا كَاسْ وشْكَرْ اللَّهْ وعْطَاهُمْ وقَالْ: «أُشْرْبُوا مِنُّو الكُلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","عْلَى خَاطِرْ هَاذَا هُوَّ دَمِّي الِّي يَعْمِلْ بِيهْ اللَّهْ عَهْدْ جْدِيدْ، ولِّي بِشْ يْسِيلْ عْلَى خَاطِرْ بَرْشَة نَاسْ، بَاشْ الذْنُوبْ تِتْغْفِرْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ونْقُولِلْكُمْ: مِنْ تَوَّا مَا عَادِشْ بِشْ نُشْرُبْ مِنْ عَصِيرْ العْنِبْ هَاذَا، حَتَّى لِينْ يْجِي النْهَارْ الِّي نُشْرْبُو فِيهْ مْعَاكُمْ جْدِيدْ فِي مَمْلَكْةْ بَابَا». ");
INSERT INTO aeu_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ومْبَعِّدْ سَبْحُوا اللَّهْ بِالتَّرْنِيمْ، ومْشَاوْ لِجْبَلْ الزِّيتُونْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","وَقْتْهَا قَالِلْهُمْ يَسُوعْ: «الكُلْكُمْ بِشْ تْخَلِّيوْنِي اللِّيلَة هَاذِي. عْلَى خَاطِرْ مَكْتُوبْ: \"نَضْرِبْ السَّارَحْ، تِتْفَرَّقْ الغْنَمْ\". ");
INSERT INTO aeu_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","«آمَا بَعْدْمَا نْقُومْ مِالمُوتْ بِشْ نِسْبِقْكُمْ لِلْجَلِيلْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","جَاوْبُو بُطْرُسْ وقَالُّو: «حَتَّى كَانْ مْشَاوْ عْلِيكْ الكُلْ، آنَا عُمْرِي مَا نْخَلِّيكْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","جَاوْبُو يَسُوعْ: «نْقُلِّكْ الحَقْ: فِي اللِّيلَة هَاذِي، قْبَلْ مَا يْصِيحْ السَّرْدُوكْ، بِشْ تُنْكُرْنِي ثْلَاثَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","قَالُّو بُطْرُسْ: «مَانِيشْ بِشْ نُنْكْرِكْ بِالكُلْ، حَتَّى كَانْ لْزِمْ نْمُوتْ مْعَاكْ!» والتْلَامْذَة الكُلْ قَالُوا نَفْسْ الكْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ومْبَعِّدْ مْشَى يَسُوعْ وتْلَامِذْتُو لِبْلَاصَة إِسْمْهَا جَثْسَيْمَانِي، وقَالِلْهُمْ: «أُقْعْدُوا هُونِي، مَادَامْ آنَا صَلِّيتْ غَادِي». ");
INSERT INTO aeu_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","وهَزْ مْعَاهْ بُطْرُسْ ووْلَادْ زَبَدِي الإِثْنِينْ، وبْدَا يْحِسْ فِي الضِّيقْ والحُزْنْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","وقَالِلْهُمْ: «رُوحِي حْزِينَة بَرْشَة، لْدَرْجِةْ المُوتْ. أُقْعْدُوا هُونِي وأَسْهْرُوا مْعَايَا». ");
INSERT INTO aeu_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","وبْعِدْ عْلِيهُمْ شْوَيَّة وهْبَطْ عْلَى وِجْهُو، وصَلَّى وقَالْ: «يَا بَابَا، إِذَا كَانْ مُمْكِنْ، بَعِّدْ عْلِيَّا الكَاسْ هَاذِي. آمَا خَلِّي يْصِيرْ الِّي تْحِبْ عْلِيهْ إِنْتِ، مُشْ الِّي نْحِبْ عْلِيهْ آنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ورْجَعْ لِتْلَامِذْتُو ولْقَاهُمْ رَاقْدِينْ. يَاخِي قَالْ لْبُطْرُسْ: «هَكَّا، مَا نَجَّمْتُوشْ تَسْهْرُوا مْعَايَا سَاعَة وَحْدَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","أَسْهْرُوا وصَلِّيوْ بَاشْ مَا تُدْخْلُوشْ فِي مِحْنَة. رَاهِي الرُّوحْ نَاشْطَة، آمَا البْدَنْ ضْعِيفْ». ");
INSERT INTO aeu_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ومْشَى يْصَلِّي مَرَّة أُخْرَى، وقَالْ: «يَا بَابَا، إِذَا كَانْ مُشْ مُمْكِنْ تْبَعِّدْ عْلِيَّا الكَاسْ هَاذِي، ولَازِمْ نُشْرُبْهَا، مَالَا خَلِّي يْصِيرْ كِيمَا تْحِبْ إِنْتِ». ");
INSERT INTO aeu_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ورْجَعْ مَرَّة أُخْرَى ولْقَاهُمْ رَاقْدِينْ، عْلَى خَاطِرْ النُّومْ غْلِبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","يَاخِي خَلَّاهُمْ ورْجَعْ يْصَلِّي مَرَّة ثَالْثَة نَفْسْ الصْلَاةْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","وبَعْدْهَا رْجَعْ لِتْلَامِذْتُو وقَالِلْهُمْ: «مَزِّلْتُوا رَاقْدِينْ ومِرْتَاحِينْ! السَّاعَة الِّي فِيهَا يْسَلْمُوا إِبْنْ الإِنْسَانْ لِيْدِينْ المُذْنْبِينْ جَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","قُومُوا، وهَيَّا نِمْشِيوْ! هَاوْ الِّي بِشْ يْخُونِّي جَاء». ");
INSERT INTO aeu_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","وهُوَّ مَزَّالْ يِتْكَلِّمْ، وْصُلْ يَهُوذَا الِّي هُوَّ وَاحِدْ مِالأَثْنَاشْ، ومْعَاهْ بَرْشَة نَاسْ هَازِّينْ سْيُوفَا وعْصِيْ، بَعْثُوهُمْ كْبَارْ الكَهَنَة وشْيُوخْ الشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ولِّي بِشْ يْخُونُو عْطَاهُمْ أَمَارَة وقَالْ: «الِّي بِشْ نْبُوسُو هَاذَاكَا هُوَّ، شِدُّوهْ!». ");
INSERT INTO aeu_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ومْشَى طُولْ لْيَسُوعْ وقَالُّو: «السَّلَامْ، يَا مُعَلِّمْ!» وبَاسُو. ");
INSERT INTO aeu_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","يَاخِي قَالُّو يَسُوعْ: «يَا صَاحْبِي، عْلَاشْ جِيتْ؟». وَقْتْهَا قُرْبُوا لْيَسُوعْ وشَدُّوهْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","وإِذَا بْوَاحِدْ مِلِّي كَانُوا مْعَ يَسُوعْ مَدْ يِدُّو وجْبِدْ سِيفُو وضْرَبْ بِيهْ خْدِيمْ الكَاهِنْ الكْبِيرْ وقَصْلُو وِذْنُو. ");
INSERT INTO aeu_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","قَالُّو يَسُوعْ: «رَجَّعْ سِيفِكْ لِبْلَاصْتُو! عْلَى خَاطِرْ الِّي يِسْتَعْمْلُوا السِّيفْ، يْمُوتُوا بِالسِّيفْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","يَاخِي مَاشِي فِي بَالِكْ الِّي آنَا مَا انَّجَّمْشْ نُطْلُبْ مِنْ بَابَا وهُوَّ يَبْعَثْلِي بِالوَقْتْ أَكْثِرْ مِنْ أَثْنَاشِنْ جَيْشْ مِالمْلَايْكَة؟ ");
INSERT INTO aeu_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","آمَا هَاذَا يِلْزْمُو يْصِيرْ بَاشْ يْتِمْ الِّي جَاء فِي الكْتُبْ المُقَدْسَة». ");
INSERT INTO aeu_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","وقَالْ يَسُوعْ لِلِّي تْلَمُّوا عْلِيهْ: «يَاخِي آنَا سَارَقْ خَارْجِينْلِي بِالسْيُوفَا والعْصِي بَاشْ تْشِدُّونِي؟ كُنْتْ كُلْ يُومْ نُقْعُدْ نْعَلِّمْ بِينَاتْكُمْ فِي الهَيْكِلْ، ومَا شَدِّيتُونِيشْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","آمَا هَاذَا الكُلْ صَارْ بَاشْ يْتِمْ الِّي تْقَالْ فِي كْتُبْ الأَنْبِيَاءْ». وَقْتْهَا تْلَامِذْتُو الكُلْ خَلَّاوَهْ وهَرْبُوا. ");
INSERT INTO aeu_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ولِّي شَدُّوا يَسُوعْ هَزُّوهْ لْقَيَافَا الكَاهِنْ الكْبِيرْ، وكَانُوا مَلْمُومِينْ عَنْدُو عُلَمَاء الشَّرِيعَة والشْيُوخْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","وبُطْرُسْ كَانْ يْتَبَّعْ فِيهْ مِنْ بْعِيدْ حَتَّى لِينْ وْصِلْ لْدَارْ الكَاهِنْ الكْبِيرْ. ودْخَلْ وقْعَدْ مْعَ الحَرَسْ وبْقَى يِسْتَنَّى كِيفَاشْ بِشْ تُوفَى الحْكَايَة. ");
INSERT INTO aeu_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","وكَانُوا كْبَارْ الكَهَنَة ولِّي فِي المَجْلِسْ الأَعْلَى الكُلْ يْلَوْجُوا عْلَى شْكُونْ يِشْهِدْ بِالزُّورْ عْلَى يَسُوعْ بَاشْ يْنَجْمُوا يُقْتْلُوهْ، ");
INSERT INTO aeu_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","آمَا مَا لْقَاوِشْ، رَغْمِلِّي جَاوْ بَرْشَة شْهُودْ زُورْ. وفِي الإِخِّرْ قَدْمُوا زُوزْ ");
INSERT INTO aeu_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","وقَالُوا: «الرَّاجِلْ هَاذَا قَالْ: \"آنَا انَّجِّمْ نْهِدْ هَيْكِلْ اللَّهْ ونْعَاوِدْ نِبْنِيهْ فِي ثْلَاثَة أَيَّامْ\"». ");
INSERT INTO aeu_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ووْقِفْ الكَاهِنْ الكْبِيرْ وقَالْ: «يَاخِي مَا عَنْدِكْ مَا تْجَاوِبْ عَلِّي شِهْدُوا بِيهْ الزُّوزْ هَاذُومَا عْلِيكْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","آمَا يَسُوعْ بْقَى سَاكِتْ. والكَاهِنْ الكْبِيرْ قَالُّو: «حَلَّفْتِكْ بِاللَّهْ الحَيْ قُولِلْنَا: يَاخِي إِنْتِ المَسِيحْ إِبْنْ اللَّهْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","قَالُّو يَسُوعْ: «إِنْتِ بِيدِكْ قُلْتْ. وآنَا نْقُلْكُمْ: مِاليُومْ بِشْ تْشُوفُوا إِبْنْ الإِنْسَانْ قَاعِدْ عْلَى يْمِينْ اللَّهْ القَادِرْ عْلَى كُلْ شَيْ، وجَايْ عْلَى سْحَابْ السْمَاء!». ");
INSERT INTO aeu_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","يَاخِي قَطَّعْ الكَاهِنْ الكْبِيرْ حْوَايْجُو وقَالْ: «هَاوْ كْفَرْ! مَزَّالْ حَاشِتْنَا بِشْهُودْ؟ هَاكُمْ سْمَعْتُوا كُفْرُو، ");
INSERT INTO aeu_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","شْنِيَّة رَايْكُمْ؟». جَاوْبُوا: «يِسْتَاهِلْ المُوتْ!». ");
INSERT INTO aeu_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","وبَعْدْهَا، بِزْقُوا عْلَى وِجْهُو، وضَرْبُوهْ بِالبُونْيَة، وجْمَاعَة مِنْهُمْ عْطَاوَهْ كْفُوفْ ");
INSERT INTO aeu_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","وقَالُوا: «تْنَبْإِلْنَا، يَا سِي المَسِيحْ! شْكُونْ الِّي ضَرْبِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","فِي الوَقْتْ هَاذَاكَا كَانْ بُطْرُسْ قَاعِدْ لْبَرَّا فِي الوِسْطِيَّة مْتَاعْ الدَّارْ. يَاخِي قُرْبِتْلُو خْدِيمَة وقَالِتْ: «إِنْتِ زَادَا كُنْتْ مْعَ يَسُوعْ الجَلِيلِي!». ");
INSERT INTO aeu_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","آمَا هُوَّ نْكَرْ قُدَّامْهُمْ الكُلْ، وقَالْ: «مُشْ فَاهِمْ فَاشْ قَاعْدَة تْقُولْ!». ");
INSERT INTO aeu_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ومْبَعِّدْ خْرَجْ لْمَدْخِلْ الدَّارْ، يَاخِي شَافِتُّو خْدِيمَة أُخْرَى وقَالِتْ لِلِّي كَانُوا غَادِي: «الرَّاجِلْ هَاذَا كَانْ مْعَ يَسُوعْ النَّاصْرِي!». ");
INSERT INTO aeu_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","آمَا بُطْرُسْ نْكَرْ مَرَّة أُخْرَى وحْلِفْ وقَالْ: «الرَّاجِلْ هَاذَا آنَا مَا نَعْرْفُوشْ!». ");
INSERT INTO aeu_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ومْبَعِّدْ شْوَيَّة جَاوْ الِّي كَانُوا وَاقْفِينْ غَادِي لْبُطْرُسْ وقَالُولُو: «بِالحَقْ إِنْتِ زَادَا وَاحِدْ مِنْهُمْ، عْلَى خَاطِرْ لَهْجْتِكْ كِيفْهُمْ!». ");
INSERT INTO aeu_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","وبْدَا بُطْرُسْ يَلْعِنْ ويِحْلِفْ: «الرَّاجِلْ هَاذَا آنَا مَا نَعْرْفُوشْ». وبِالوَقْتْ صَاحْ السَّرْدُوكْ. ");
INSERT INTO aeu_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","يَاخِي تْذَكِّرْ بُطْرُسْ كِلْمِةْ يَسُوعْ كِي قَالُّو: «قْبَلْ مَا يْصِيحْ السَّرْدُوكْ، بِشْ تُنْكُرْنِي ثْلَاثَة مَرَّاتْ» وخْرَجْ لْبَرَّا وبْدَا يِبْكِي بِالشَّهْقَة. ");
INSERT INTO aeu_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","وفِي الصْبَاحْ، تْلَمُّوا كْبَارْ الكَهَنَة وشْيُوخْ الشَّعْبْ الكُلْ، وتْشَاوْرُوا عْلَى كِيفَاشْ بِشْ يُقْتْلُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ومْبَعِّدْ كَتْفُوهْ وهَزُّوهْ وسَلْمُوهْ لْبِيلَاطُسْ الوَالِي. ");
INSERT INTO aeu_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","وَقْتِلِّي يَهُوذَا الِّي خَانُو شَافْ الِّي يَسُوعْ تِحْكَمْ عْلِيهْ، نْدِمْ ورَجَّعْ الثْلَاثِينْ بْيَاسَة فُضَّة لِكْبَارْ الكَهَنَة والشْيُوخْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","وقَالِلْهُمْ: «آنَا غْلُطْتْ كِي سَلَّمْتُكُمْ رَاجِلْ بَرِيءْ». يَاخِي جَاوْبُوهْ: «هَاذِي مُشْ مُشْكْلِتْنَا أَحْنَا، بَرَّا دَبِّرْ رَاسِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ولَّى رْمَى بْيَاسَاتْ الفُضَّة فِي الهَيْكِلْ وخْرَجْ، وبَعْدْهَا مْشَى شْنَقْ رُوحُو. ");
INSERT INTO aeu_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","وخْذَاوْ كْبَارْ الكَهَنَة الفُضَّة وقَالُوا: «هَاذُمْ حَقْ دَمْ إِنْسَانْ، حْرَامْ نْحُطُّوهُمْ فِي خَزْنِةْ الهَيْكِلْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","وبَعْدْمَا تْشَاوْرُوا، شْرَاوْ بِيهُمْ سَانِيةْ الفُخَّارْجِي بَاشْ يَعْمْلُوهَا جَبَّانَة يِدْفْنُوا فِيهَا البْرَايْنِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","هَاذَاكَا عْلَاشْ لِلْيُومْ يْسَمِّيوْهَا سَانْيِةْ الدَّمْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","وهَكَّا تَمْ الِّي قَالُّو النَّبِيْ إِرْمِيَا: «وخْذَاوْ ثْلَاثِينْ بْيَاسَة فُضَّة، السُّومْ الِّي سَامُوهْ بِيهْ بَنِي إِسْرَائِيلْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","وشْرَاوْ بِيهُمْ سَانِيةْ الفُخَّارْجِي، كِيفْ مَا أْمَرْنِي الرَّبْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ووْقِفْ يَسُوعْ قُدَّامْ الوَالِي. والوَالِي سِأْلُو: «يَاخِي إِنْتِ مَلِكْ اليْهُودْ؟» جَاوْبُو يَسُوعْ: « إِنْتِ بِيدِكْ قُلْتْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","وكِي كَانُوا كَبَارْ الكَهَنَة والشْيُوخْ يِتْهْمُوا فِيهْ، بْقَى سَاكِتْ ومَا جَاوِبْهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","قَالُّو بِيلَاطُسْ: «يَاخِي مَاكِشْ قَاعِدْ تِسْمَعْ فِلِّي تِهْمُوكْ بِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","آمَا يَسُوعْ مَا جَاوْبُو بْحَتَّى كِلْمَة، حَتَّى لِينْ بْقَى الوَالِي بَاهِتْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","وكَانْ الوَالِي مِسْتَانِسْ فِي كُلْ عِيدْ يْسَيِّبْ وَاحِدْ مِالمْرَابِيطْ الِّي يَخْتَارُوهْ الشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","وكَانْ عَنْدْهُمْ فِي الوَقْتْ هَاذَاكَا مَرْبُوطْ مَشْهُورْ إِسْمُو بَارَابَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ووَقْتِلِّي تْلَمُّوا النَّاسْ قَالِلْهُمْ بِيلَاطُسْ: «شْكُونْ تْحِبُّونِي نْسَيْبِلْكُمْ: بَارَابَاسْ وَلَّا يَسُوعْ الِّي يْقُولُولُو المَسِيحْ؟» ");
INSERT INTO aeu_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","عْلَى خَاطْرُو كَانْ يَعْرِفْ الِّي هُومَا سَلْمُولُو يَسُوعْ بِسْبَبْ غِيرِتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ووَقْتِلِّي بِيلَاطُسْ كَانْ قَاعِدْ فِي المَحْكْمَة، بَعْثِتْلُو مَرْتُو وقَالِتْلُو: «رُدْ بَالِكْ تَعْمِلْ حَاجَة لِلرَّاجِلْ الصَّالَحْ هَاذَا، رَانِي اللِّيلَة تْقَلَّقْتْ بَرْشَة عْلَى خَاطْرُو فِي حِلْمَة». ");
INSERT INTO aeu_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","آمَا كْبَارْ الكَهَنَة والشْيُوخْ حَرْشُوا النَّاسْ بَاشْ يُطْلْبُوا مِنُّو يْسَيْبِلْهُمْ بَارَابَاسْ ويُقْتُلْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","وكِي سْإِلْهُمْ الوَالِي: «شْكُونْ تْحِبُّونِي نْسَيْبِلْكُمْ؟» جَاوْبُوهْ: «بَارَابَاسْ!». ");
INSERT INTO aeu_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","قَالِلْهُمْ بِيلَاطُسْ: «مَالَا شْنِيَّة تْحِبُّونِي نَعْمِلْ لْيَسُوعْ الِّي يْقُولُولُو المَسِيحْ؟». قَالُوا الكُلْ: «أُصْلْبُو!» ");
INSERT INTO aeu_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","قَالِلْهُمْ: «شْنُوَّة الشَّرْ الِّي عَمْلُو؟». آمَا هُومَا وَلَّاوْ يْصِيحُوا أَكْثِرْ: «أُصْلْبُو!». ");
INSERT INTO aeu_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","وكِي شَافْ بِيلَاطُسْ إِنُّو مُشْ بِشْ يُوصِلْ مْعَاهُمْ لْشَيْ، والشَّعْبْ بْدَا يْهِيجْ أَكْثِرْ، خْذَا مَاء وغْسَلْ يْدِيهْ قُدَّامْ النَّاسْ وقَالْ: «آنَا بَرِيءْ مِنْ دَمْ الرَّاجِلْ هَاذَا! تْصَرْفُوا مْعَاهْ إِنْتُومَا». ");
INSERT INTO aeu_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","والشَّعْبْ الكُلْ جَاوْبُوا: «دَمُّو فِي رَقْبِتْنَا، أَحْنَا وأَوْلَادْنَا!». ");
INSERT INTO aeu_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","يَاخِي سَيْبِلْهُمْ بَارَابَاسْ، وعْطَى أَمْرْ بَاشْ يِجْلْدُوا يَسُوعْ، ومْبَعِّدْ سَلْمُو بَاشْ يِتْصْلَبْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","وجَاوْ عَسْكِرْ الوَالِي وهَزُّوا يَسُوعْ لْدَارْ الوِلَايَة، وتْلَمِّتْ بِيهْ فِرْقِتْهُمْ الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ونَحَّاوْلُو حْوَايْجُو ولَبْسُوهْ لِبْسَة حَمْرَة، ");
INSERT INTO aeu_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","وضَفْرُولُو تَاجْ مِالشُّوكْ وحَطُّوهْ فُوقْ رَاسُو، وحَطُّولُو قَصْبَة فِي يِدُّو اليْمِينْ، وهَبْطُوا عْلَى رْكَايِبْهُمْ قُدَّامُو وبْدَاوْ يِتْمَسْخْرُوا عْلِيهْ ويْقُولُوا: «سَلَامْ يَا مَلِكْ اليْهُودْ!». ");
INSERT INTO aeu_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","وبِزْقُوا عْلِيهْ، وخْذَاوْلُو القَصْبَة وضَرْبُوهْ بِيهَا عْلَى رَاسُو. ");
INSERT INTO aeu_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","وبَعْدْمَا تْمَسْخْرُوا عْلِيهْ، نَحَّاوْلُو اللِّبْسَة الحَمْرَة، وعَاوْدُوا لَبْسُوهْ حْوَايْجُو وهَزُّوهْ بَاشْ يِتْصْلَبْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","وهُومَا خَارْجِينْ بِيهْ مِالمْدِينَة عْرُضْهُمْ رَاجِلْ مِنْ مَنْطَقْةْ قِيرِينَا إِسْمُو سِمْعَانْ، يَاخِي لَزْمُوا عْلِيهْ بَاشْ يْهِزْ الصَّلِيبْ مْتَاعْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","وكِي وُصْلُوا لِبْلَاصَة تِتْسَمَّى الجُلْجْثَة، الِّي مَعْنَاهَا بْلَاصِةْ الجُمْجُمَة، ");
INSERT INTO aeu_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","عْطَاوَهْ شْرَابْ مْخَلِّطْ بْحَاجَة مُرَّة بَاشْ يُشْرُبْ، وكِي ذَاقُو مَا حَبِّشْ يُشْرْبُو. ");
INSERT INTO aeu_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ومْبَعِّدْ صَلْبُوهْ. وعَمْلُوا قُرْعَة عْلَى حْوَايْجُو وقِسْمُوهَا بِينَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","وقَعْدُوا غَادِي يْعِسُّوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","وحَطُّوا بْلَاكَة فُوقْ رَاسُو وكِتْبُوا عْلِيهَا التُّهْمَة مْتَاعُو: «هَاذَا يَسُوعْ، مَلِكْ اليْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","وصَلْبُوا مْعَاهْ زُوزْ سُرَّاقْ، وَاحِدْ عْلَى يْمِينُو ووَاحِدْ عْلَى يْسَارُو. ");
INSERT INTO aeu_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","وكَانُوا الِّي يِتْعَدَّاوْ مِنْ غَادِي يْسِبُّوا فِيهْ، ويْدَوْحُوا فِي رْيُوسْهُمْ ");
INSERT INTO aeu_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ويْقُولُوا: «إِنْتِ يَلِّي بِشْ تْهِدْ الهَيْكِلْ وتِبْنِيهْ فِي ثْلَاثَة أَيَّامْ، كَانِكْ إِنْتِ إِبْنْ اللَّهْ نَجِّي رُوحِكْ وأَهْبِطْ مِنْ فُوقْ الصَّلِيبْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","وكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة والشْيُوخْ كَانُوا يِتْمَسْخْرُوا عْلِيهْ زَادَا، ويْقُولُوا: ");
INSERT INTO aeu_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«نَجَّى غِيرُو، آمَا مَا نَجَّمْشْ يْنَجِّي رُوحُو! هَاذَا هُوَّ مَلِكْ إِسْرَائِيلْ؟ خَلِّيهْ يَهْبِطْ تَوَّا مِنْ فُوقْ الصَّلِيبْ، وتَوْ نَمْنُوا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","مَاهُو حَطْ ثِيقْتُو فِي اللَّهْ وقَالْ: \"آنَا إِبْنْ اللَّهْ\"، خَلِّي اللَّهْ يْنَجِّيهْ تَوَّا كَانُو رَاضِي عْلِيهْ». ");
INSERT INTO aeu_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","والسُّرَّاقْ الزُّوزْ الِّي تْصَلْبُوا مْعَاهْ كَانُوا يْعَايْرُوا فِيهْ بْنَفْسْ الكْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","وظْلَامِتْ الدِّنْيَا الكُلْ مِنْ نُصْ نْهَارْ حَتَّى لْمَاضِي ثْلَاثَة مْتَاعْ العْشِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ومْعَ مَاضِي ثْلَاثَة، عَيِّطْ يَسُوعْ بْصُوتْ عَالِي: «إِيلِي! إِيلِي! لِمَا شَبَقْتَنِي؟» ومَعْنِتْهَا «يَا إِلَاهِي! يَا إِلَاهِي! عْلَاشْ خَلِّيتْنِي؟». ");
INSERT INTO aeu_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","وكِي سَمْعُوهْ جْمَاعَة مِلِّي وَاقْفِينْ غَادِي قَالُوا: «هَاوْ يْعَيِّطْ لِلنَّبِيْ إِيلِيَّا!». ");
INSERT INTO aeu_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","وبِالوَقْتْ جْرَالُو وَاحِدْ مِنْهُمْ، وخْذَا شِيفُونَة، ونَفَّخْهَا فِي الخَلْ، وحَطْهَا عْلَى قَصْبَة ومَدْهَالُو بَاشْ يُشْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","آمَا الأُخْرِينْ قَالُوا: « إِسْتَنَّى، خَلِّينَا نْشُوفُوا إِذَا كَانْ إِيلِيَّا بِشْ يْجِي ويْنَجِّيهْ!». ");
INSERT INTO aeu_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","وعَيِّطْ يَسُوعْ مَرَّة أُخْرَى بِالقْوِيْ، وطَلَّعْ الرُّوحْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","وتْشَرِّڨْ حْجَابْ الهَيْكِلْ عْلَى ثْنِينْ مِالفُوقْ اللُّوطَا. والأَرْضْ تْزَلْزْلِتْ والحْجَرْ تْشَقَّقْ ");
INSERT INTO aeu_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","وتْحَلِّتْ القْبُورَاتْ وبَرْشَة قِدِّيسِينْ كَانُوا مُوتَى قَامُوا، ");
INSERT INTO aeu_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","وخَرْجُوا مِالقْبُورَاتْ. وبَعْدْ قْيَامِةْ يَسُوعْ دَخْلُوا لِلْمْدِينَة المُقَدْسَة وظُهْرُوا لْبَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ووَقْتِلِّي الضَّابِطْ الرُّومَانِي ولِّي كَانُوا يْعِسُّوا مْعَاهْ عْلَى يَسُوعْ شَافُوا الزِلْزَالْ ولِّي صَارْ الكُلْ، تْرِعْبُوا وقَالُوا: «بِالحَقْ هَاذَا كَانْ إِبْنْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","وكَانْ فَمَّة بَرْشَة نْسَاء يِتْفَرْجُوا مِنْ بْعِيدْ. وهُومَا الِّي تَبْعُوا يَسُوعْ مِالجَلِيلْ، بَاشْ يِخْدْمُوهْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","ومِنْهُمْ مَرْيِمْ المَجْدَلِيَّة، ومَرْيِمْ أُمْ يَعْقُوبْ ويُوسِي، وأُمْ وْلَادْ زَبَدِي. ");
INSERT INTO aeu_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","وفِي العْشِيَّة جَاء رَاجِلْ غْنِي إِسْمُو يُوسِفْ مِنْ مْدِينِةْ الرَّامَة، وهُوَّ زَادَا كَانْ مِنْ تْلَامِذْةْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ومْشَى لْبِيلَاطُسْ وطْلَبْ مِنُّو جُثِّةْ يَسُوعْ. يَاخِي بِيلَاطُسْ أْمَرْ بَاشْ يَعْطِيوْهَالُو. ");
INSERT INTO aeu_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","وهَزْ يُوسِفْ الجُثَّة ولَفْهَا فِي كْفَنْ نْظِيفْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ودِفْنُو فِي قْبَرْ جْدِيدْ حَافْرُو فِي الحْجَرْ لْرُوحُو هُوَّ، وحَطْ حَجْرَة كْبِيرَة عْلَى بَابْ القْبَرْ، ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","وكَانِتْ مَرْيِمْ المَجْدَلِيَّة، ومَرْيِمْ الأُخْرَى، قَاعْدِينْ مْقَابِلْ القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ومِنْ غُدْوَة، مَعْنَاهَا بَعْدْ نْهَارْ التَّحْضِيرْ لِلسِّبْتْ، مْشَاوْ كْبَارْ الكَهَنَة والفِرِّيسِيِّينْ لْبِيلَاطُسْ، ");
INSERT INTO aeu_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","وقَالُولُو: «يَا سِيدْنَا، تْذَكَّرْنَا الِّي هَاكِ الدَّجَّالْ وَقْتِلِّي كَانْ حَيْ قَالْ: \"بِشْ نْقُومْ بَعْدْ ثْلَاثَة أَيَّامْ\". ");
INSERT INTO aeu_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","مَالَا أَعْطِي أَمْرْ بَاشْ يْعِسُّوا عَالقْبَرْ لِلنْهَارْ الثَّالِثْ، بَاشْ مَا يْجِيوِشْ تْلَامِذْتُو يِسْرْقُوا جُثْتُو، ويْقُولُوا لِلنَّاسْ: \"رَاهُو قَامْ مِالمُوتْ\"، وتْكُونْ الكِذْبَة الثَّانْيَة أَخْطِرْ مِالأُولَى!». ");
INSERT INTO aeu_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","قَالِلْهُمْ بِيلَاطُسْ: «هَاوْ عَنْدْكُمْ الحَرَسْ، إِمْشِيوْ وعِسُّوا عْلِيهْ كِيمَا تْحِبُّوا». ");
INSERT INTO aeu_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ومْشَاوْ سَكْرُوا القْبَرْ وشَمْعُوهْ، وحَطُّوا عْلِيهْ الحَرَسْ يْعِسُّوا. ");
INSERT INTO aeu_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","وبَعْدْمَا تْعَدَّى السِّبْتْ وطْلَعْ فَجْرْ نْهَارْ الأَحَدْ، مْشَاتْ مَرْيِمْ المَجْدَلِيَّة ومَرْيِمْ الأُخْرَى بَاشْ يْشُوفُوا القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","وإِذَا بِيهْ زِلْزَالْ كْبِيرْ يْصِيرْ، عْلَى خَاطِرْ مَلَاكْ مِنْ عَنْدْ الرَّبْ هْبَطْ مِالسْمَاء وبَعِّدْ الحَجْرَة الِّي فِي بَابْ القْبَرْ وقْعَدْ فُوقْهَا. ");
INSERT INTO aeu_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","وكَانْ مَنْظْرُو كِي البْرَقْ ولِبْسْتُو بِيضَة كِي الثِّلْجْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","وكِي شَافُوهْ الحَرَسْ تْرِعْبُوا ووَلَّاوْ تْقُولِشْ عْلِيهُمْ مُوتَى. ");
INSERT INTO aeu_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","آمَا المَلَاكْ قَالْ لِلزُّوزْ نْسَاء: «مَا تْخَافُوشْ. آنَا نَعْرِفْ الِّي إِنْتُومَا تْلَوْجُوا عْلَى يَسُوعْ الِّي تِصْلَبْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","هُوَّ مَاهُوشْ هْنَا، عْلَى خَاطْرُو قَامْ كِيمَا قَالْ. إِيجَاوْ شُوفُوا البْلَاصَة الِّي كَانْ مَحْطُوطْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","وإِمْشِيوْ فِيسَعْ وقُولُوا لِتْلَامِذْتُو الِّي هُوَّ قَامْ مِنْ بِينْ المُوتَى، وهَاوْ بِشْ يِسْبَقْكُمْ لِلْجَلِيلْ، وغَادِي بِشْ تْشُوفُوهْ. هَانِي خَبَّرْتْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","يَاخِي مْشَاوْ الزُّوزْ نْسَاء فِيسَعْ مِالقْبَرْ، وهُومَا خَايْفِينْ آمَا فِي نَفْسْ الوَقْتْ فَرْحَانِينْ، ومْشَاوْ يِجْرِيوْ بَاشْ يْبَشْرُوا التْلَامْذَة. ");
INSERT INTO aeu_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","وهُومَا فِي الثْنِيَّة، عْرُضْهُمْ يَسُوعْ وقَالِلْهُمْ: «السَّلَامْ». يَاخِي قُرْبُولُو وشَدُّوا فِي سَاقِيهْ وسِجْدُولُو. ");
INSERT INTO aeu_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","قَالِلْهُمْ يَسُوعْ: «مَا تْخَافُوشْ! إِمْشِيوْ لِخْوَاتِي وقُولُولْهُمْ يِمْشِيوْ لِلْجَلِيلْ، وغَادِي يْشُوفُونِي». ");
INSERT INTO aeu_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","وهُومَا فِي الثْنِيَّة، رَجْعُوا جْمَاعَة مِالحَرَسْ لِلْمْدِينَة، وخَبْرُوا كْبَارْ الكَهَنَة بِلِّي صَارْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","يَاخِي تْلَمُّوا كْبَارْ الكَهَنَة والشْيُوخْ وتْشَاوْرُوا، وبَعْدْهَا رْشَاوْ الحَرَسْ إِبَّرْشَة فْلُوسْ، ");
INSERT INTO aeu_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","وقَالُولْهُمْ: «قُولُوا لِلنَّاسْ الِّي تْلَامِذْتُو جَاوْ فِي اللِّيلْ وسِرْقُوهْ وَقْتِلِّي أَحْنَا رَاقْدِينْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","وكِي يِسْمَعْ الوَالِي بِالخْبَرْ، أَحْنَا نْدَافْعُوا عْلِيكُمْ قُدَّامُو ومَا يْصِيرِلْكُمْ شَيْ». ");
INSERT INTO aeu_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","يَاخِي الحَرَسْ خْذَاوْ الفْلُوسْ وعَمْلُوا كِيمَا قَالُولْهُمْ. والإِشَاعَة هَاذِي قَعْدِتْ اتْدُورْ بِينْ اليْهُودْ حَتَّى لِلْيُومْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","وبَعْدْهَا، هَزُّوا الحْدَاشِنْ تِلْمِيذْ رْوَاحْهُمْ ومْشَاوْ لِلْجَلِيلْ، لِلجْبَلْ الِّي قَالِلْهُمْ عْلِيهْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ودُوبْ مَا رَاوَهْ سِجْدُولُو، آمَا فِيهُمْ شْكُونْ الِّي شَكْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","يَاخِي قْرُبِّلْهُمْ يَسُوعْ وقَالْ: «تَعْطَاتْلِي كُلْ سُلْطَة فِي السْمَاء والأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","مَالَا إِمْشِيوْ لِلشْعُوبْ الكُلْ وخَلِّيوْ النَّاسْ يْوَلِّيوْ تْلَامْذَة لِيَّا، وعَمْدُوهُمْ بْإِسْمْ الآبْ والإِبْنْ والرُّوحْ القُدُسْ، ");
INSERT INTO aeu_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","وعَلْمُوهُمْ يْطِيعُوا الِّي وَصِّيتْكُمْ بِيهْ الكُلْ، وهَانِي دِيمَا مْعَاكُمْ، لْآخِرْ الزْمَانْ».");
INSERT INTO aeu_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","هَاذِي هِيَّ بِدَايِةْ البْشَارَة الِّي تْخُصْ يَسُوعْ المَسِيحْ إِبْنْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","كِيمَا قَالْ اللَّهْ فِي كْتَابْ النَّبِيْ إِشَعْيَاءْ: «هَانِي بِشْ نِبْعَثْ قُدَّامِكْ رَسُولِي بَاشْ يْحَضَّرْلِكْ الطْرِيقْ ");
INSERT INTO aeu_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","صُوتْ يْعَيِّطْ فِي الخْلَاء: \"حَضّْرُوا طْرِيقْ الرَّبْ، إِسْتْوِيوْ الثْنِيَّة قُدَّامُو\"». ");
INSERT INTO aeu_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","كَانْ يُوحَنَّا فِي الخْلَاء يْنَادِي لِلنَّاسْ بَاشْ يْتُوبُوا ويِتْعَمْدُوا بَاشْ تِتْغْفِرْ ذْنُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ومْشَاوْلُو النَّاسْ الكُلْ الِّي مِنْ مَنْطَقْةْ اليَهُودِيَّة وأُورْشَلِيمْ، وتْعَمْدُوا عْلَى يْدِيهْ فِي وَادْ الأُرْدُنْ بَعْدْمَا اعْتَرْفُوا بِذْنُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","وكَانْ يُوحَنَّا لَابِسْ وْبَرْ الجْمَالْ ومِتْحَزِّمْ بْجِلْدْ ويَاكِلْ فِي الجْرَادْ والعْسَلْ الجَّالِي. ");
INSERT INTO aeu_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","وكَانْ يْبَشِّرْ ويْقُولْ: «بَعْدِي آنَا بِشْ يْجِي الِّي هُوَّ أَعْظَمْ مِنِّي، ولِّي مَا نِسْتَاهِلْشْ حَتَّى بَاشْ نْطَبِّسْ ونْحِلُّو رْبَايِطْ صَنْدَالُو. ");
INSERT INTO aeu_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","آنَا عَمَّدْتْكُمْ فِي المَاء، آمَا هُوَّ بِشْ يْعَمِّدْكُمْ فِي الرُّوحْ القُدُسْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","فِي الوَقْتْ هَاذَاكَا جَاء يَسُوعْ مِالنَّاصْرَة الِّي فِي مَنْطَقْةْ الجَلِيلْ، وتْعَمِّدْ فِي وَادْ الأُرْدُنْ عْلَى يْدِينْ يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ودُوبْ مَا خْرَجْ مِالمَاء، شَافْ السْمَاء تْشَقِّتْ والرُّوحْ القُدُسْ هْبَطْ عْلِيهْ كِالحْمَامَة. ");
INSERT INTO aeu_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","وجَاء صُوتْ مِالسْمَاء يْقُولْ: «إِنْتِ إِبْنِي الِّي نْحِبُّو، آنَا فَرْحَانْ بِيكْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","وبِالوَقْتْ الرُّوحْ القُدُسْ هَزْ يَسُوعْ لِلْخْلَاء ");
INSERT INTO aeu_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","وعَدَّى 40 يُومْ والشِّيطَانْ يْجَرِّبْ فِيهْ، وكَانْ فِي وِسْطْ الحَيَوَانَاتْ المِتْوَحْشَة والمْلَايْكَة تِخْدِمْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","وبَعْدْمَا تْحَطْ يُوحَنَّا فِي الحَبْسْ، مْشَى يَسُوعْ لْمَنْطَقْةْ الجَلِيلْ يُنْشُرْ فِي بْشَارِةْ اللَّهْ ");
INSERT INTO aeu_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ويْقُولْ: «جَاء الوَقْتْ وقُرْبِتْ مَمْلَكْةْ اللَّهْ. تُوبُوا وأَمْنُوا بِالبْشَارَة!». ");
INSERT INTO aeu_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","وهُوَّ مَاشِي عْلَى شَطْ بُحَيْرِةْ الجَلِيلْ، شَافْ زُوزْ صَيَّادَة، سِمْعَانْ وخُوهْ أَنْدَرَاوُسْ، يَرْمِيوْ فِي الشْبَاكْ فِي البُحَيْرَة. ");
INSERT INTO aeu_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","قَالِلْهُمْ يَسُوعْ: «تَبْعُونِي وآنَا بِشْ نْرُدْكُمْ صَيَّادِةْ نَاسْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","وبِالوَقْتْ خَلَّاوْ الشْبَاكْ مْتَاعْهُمْ وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","وبَعْدْمَا زَادْ مْشَى شْوَيَّة شَافْ يَعْقُوبْ وِلْدْ زَبَدِي وخُوهْ يُوحَنَّا فِي الفْلُوكَة يْصَلْحُوا فِي الشْبَاكْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","بِالوَقْتْ عَيْطِلْهُمْ. يَاخِي خَلَّاوْ بُوهُمْ زَبَدِي مْعَ الخَدَّامَة فِي الفْلُوكَة وتَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ومْبَعِّدْ مْشَاوْ لْكَفْرْنَاحُومْ، ونْهَارْ السِّبْتْ دْخَلْ يَسُوعْ لْمَعْبِدْ اليْهُودْ وبْدَا يْعَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","وقَعْدُوا الحَاضْرِينْ مِتْعَجْبِينْ مِنْ تَعْلِيمُو، عْلَى خَاطْرُو كَانْ يْعَلِّمْ كِيمَا وَاحِدْ عَنْدُو سُلْطَة، مُشْ كِيمَا عُلَمَاءْ الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","وفِي الوَقْتْ هَاذَاكَا، كَانْ فَمَّة فِي المَعْبِدْ رَاجِلْ سَاكْنُو رُوحْ شِرِّيرْ بْدَا يْصِيحْ ");
INSERT INTO aeu_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","وقَالْ: «آشْ تْحِبْ مِنَّا يَا يَسُوعْ النَّاصْرِي؟ جِيتْ بَاشْ تَقْضِي عْلِينَا؟ آنَا نَعْرِفْ إِنْتِ شْكُونْ، إِنْتِ القُدُّوسْ الِّي بَعْثُو اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","يَاخِي يَسُوعْ نْزَرْ عْلِيهْ وقَالُّو: «أُسْكُتْ! وأُخْرُجْ مِنُّو». ");
INSERT INTO aeu_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","صْرَعْ الرُّوحْ الشِّرِيرْ الرَّاجِلْ وصَاحْ بْصُوتْ عَالِي وخْرَجْ مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","النَّاسْ الكُلْ قَعْدُوا مِتْعَجْبِينْ وبْدَاوْ يِسْأْلُوا فِي بْعَضْهُمْ: «شْنُوَّة هَاذَا؟ تَعْلِيمْ جْدِيدْ، وعَنْدُو سُلْطَة! حَتَّى مِالأَرْوَاحْ الشِّرِّيرَة يُأْمُرْهُمْ وهُومَا يْطِيعُوهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","وفِيسَعْ تِشْهَرْ يَسُوعْ فِي مَنْطَقْةْ الجَلِيلْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ودُوبْ مَا خَرْجُوا مِالمَعْبِدْ، مْشَاوْ لْدَارْ سِمْعَانْ وأَنْدَرَاوُسْ، ومْعَاهُمْ يَعْقُوبْ ويُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","كَانِتْ حْمَاةْ سِمْعَانْ رَاقْدَة فِي الفَرْشْ عَنْدْهَا السْخَانَة. يَاخِي كَلْمُوا يَسُوعْ عْلِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","قْرُبِّلْهَا وشَدْهَا مِنْ يِدْهَا وقَيَّمْهَا وبِالوَقْتْ تْنَحَّاتْ عْلِيهَا السْخَانَة ووَلَّاتْ تِخْدِمْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","وفِي العْشِيَّة، وَقْتِلِّي غُرْبِتْ الشَّمْسْ، جَابُولُو النَّاسْ المُرْضَى الكُلْ ولِّي سَاكْنِتْهُمْ الشْوَاطِنْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","والنَّاسْ الكُلْ الِّي فِي أُورْشَلِيمْ تْلَمُّوا قُدَّامْ البَابْ، ");
INSERT INTO aeu_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","وشْفَى بَرْشَة نَاسْ يْعَانِيوْ مِنْ بَرْشَة أَمْرَاضْ، وخَرِّجْ بَرْشَة شْوَاطِنْ، ومَا خَلَّاشْ الشْوَاطِنْ يِتْكَلْمُوا عْلَى خَاطِرْهُمْ عَرْفُوهْ شْكُونُو. ");
INSERT INTO aeu_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ومِنْ غُدْوَة قْبَلْ الفَجْرْ قَامْ يَسُوعْ ومْشَى لْبُقْعَة خَالْيَة وبْدَا يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ومْشَى سِمْعَانْ ولِّي مْعَاهْ يْلَوْجُوا عْلِيهْ ");
INSERT INTO aeu_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ووَقْتِلِّي لْقَاوْهْ قَالُولُو: «رَاهُمْ النَّاسْ الكُلْ يْلَوْجُوا عْلِيكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","قَالِلْهُمْ: «هَيَّا نِمْشِيوْ لِلدْشُرْ الأُخْرَى القْرِيبَة بَاشْ نْبَشِّرْ فِيهَا زَادَا، عْلَى خَاطِرْ هَاذَاكَا عَلَاشْ جِيتْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ومْشَى لِمْعَابِدْ اليْهُودْ الِّي فِي مَنْطَقْةْ الجَلِيلْ الكُلْ، يْبَشِّرْ ويْخَرِّجْ فِي الشْوَاطِنْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","وجَاهْ وَاحِدْ أَبْرِصْ يِتْشَحِّتْ فِيهْ، وهْبَطْ عْلَى رْكَايْبُو قُدَّامُو وقَالْ: «كَانْ تْحِبْ، تْنَجِّمْ اطَّهِّرْنِي مِالبْرَصْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","حَنْ عْلِيهْ يَسُوعْ، ومَدْ يِدُّو ومَسُّو وقَالْ: «أَيْ نْحِبْ، أُطْهُرْ!». ");
INSERT INTO aeu_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ودُوبْ مَا تْكَلِّمْ يَسُوعْ تْنَحَّى عْلِيهْ البْرَصْ وطْهُرْ. ");
INSERT INTO aeu_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","وبِالوَقْتْ، نَبَّهْ عْلِيهْ يَسُوعْ قْبَلْ مَا يْخَلِّيهْ يِمْشِي، ");
INSERT INTO aeu_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","وقَالُّو: «رُدْ بَالِكْ! مَا تْقُولْ لْحَتَّى حَدْ. آمَا إِمْشِي وَرِّي رُوحِكْ لِلْكَاهِنْ، وعْلَى خَاطْرِكْ طْهُرْتْ، قَدِّمْ القُرْبَانْ الِّي أْمَرْ بِيهْ مُوسَى بَاشْ يْكُونْ شْهَادَة لِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","آمَا هُوَّ مْشَى وبْدَا يُنْشِرْ فِي الخْبَرْ قُدَّامْ النَّاسْ، حَتَّى وَلَّى يَسُوعْ مَا عَادِشْ يْنَجِّمْ يُدْخُلْ لْحَتَّى بْلَادْ جْهَارْ، ووَلَّى قَاعِدْ فِي الخْلَاء، والنَّاسْ يْجِيوَهْ مِنْ كُلْ بْلَاصَة. ");
INSERT INTO aeu_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","وبَعْدْ أَيَّامَاتْ، رْجَعْ يَسُوعْ لْمَنْطَقْةْ كَفْرْنَاحُومْ وتِنْشَرّْ الخْبَرْ الِّي هُوَّ فِي الدَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","تْلَمُّوا بَرْشَة نَاسْ لِينْ مَا عَادِشْ فَمَّة بْلَاصَة لْحَتَّى حَدْ حَتَّى قُدَّامْ البَابْ. وبْدَا يَحْكِي مْعَاهُمْ بْكِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","وجَابُولُو وَاحِدْ مَشْلُولْ هَازِّينُو أَرْبْعَة رْجَالْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","آمَا مَا نَجْمُوشْ يُقْرْبُولُو مِنْ كُثْرِةْ النَّاسْ. يَاخِي عَمْلُوا نُقْبَة فِي السْطَحْ فُوقْ البْلَاصَة الِّي كَانْ فِيهَا يَسُوعْ، وهَبّْطُوا مِنْهَا المَشْلُولْ، رَاقِدْ عْلَى فَرْشُو. ");
INSERT INTO aeu_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","وَقْتِلِّي شَافْ يَسُوعْ إِيمَانْهُمْ، قَالْ لِلْمَشْلُولْ: «يَا وِلْدِي، ذْنُوبِكْ تْغَفْرِتْ». ");
INSERT INTO aeu_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","وكَانْ بِينْ القَاعْدِينْ جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَة بْدَاوْ يْخَمُّوا بِينْهُمْ وبِينْ رْوَاحْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«شْبِيهْ الرَّاجِلْ هَاذَا يِتْكَلِّمْ هَكَّا؟ قَاعِدْ يَكْفِرْ! شْكُونْ بِخْلَافْ اللَّهْ وَحْدُو يْنَجِّمْ يِغْفِرْ الذْنُوبْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","وبِالوَقْتْ عْرَفْ يَسُوعْ فَاشْ يْخَمُّوا، يَاخِي سْإِلْهُمْ: «عْلَاشْ تْخَمُّوا هَكَّا؟ ");
INSERT INTO aeu_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","آنَاهُو أَسْهِلْ؟ بَاشْ يِتْقَالْ لِلْمَشْلُولْ: \"ذْنُوبِكْ تْغَفْرِتْ\" وَلَّا يِتْقَالُّو: \"قُومْ! هِزْ فَرْشِكْ وامْشِي\"؟ ");
INSERT INTO aeu_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","آمَا هَانِي بِشْ نْوَرِّيكُمْ الِّي إِبْنْ الإِنْسَانْ عَنْدُو السُّلْطَة فِي الأَرْضْ بَاشْ يِغْفِرْ الذْنُوبْ». يَاخِي قَالْ لِلْمَشْلُولْ: ");
INSERT INTO aeu_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«نْقُلِّكْ: قُومْ! هِزْ فَرْشِكْ ورَوَّحْ لْدَارِكْ». ");
INSERT INTO aeu_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","قَامْ الرَّاجِلْ بِالوَقْتْ، هَزْ فَرْشُو ومْشَى قُدَّامْ النَّاسْ الكُلْ. قَعْدُوا الكُلْهُمْ بَاهْتِينْ وحِمْدُوا اللَّهْ وقَالُوا: «عْمُرْنَا مَا شُفْنَا حَاجَة كِيمَا هَاذِي!». ");
INSERT INTO aeu_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","وخْرَجْ يَسُوعْ مَرَّة أُخْرَى لْشَطْ البُحَيْرَة، وخَلْطُوا عْلِيهْ النَّاسْ الكُلْ، وبْدَا يْعَلَّمْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","وهُوَّ يِمْشِي، شَافْ لَاوِي وِلْدْ حَلْفَى قَاعِدْ فِينْ يْلِمُّوا الضَّرَايِبْ وقَالُّو: «تَبَّعْنِي!». يَاخِي قَامْ وتَبْعُو. ");
INSERT INTO aeu_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ووَقْتِلِّي كَانْ يَسُوعْ قَاعِدْ يَاكِلْ فِي دَارْ لَاوِي، قَعْدُوا مْعَاهْ ومْعَ تْلَامِذْتُو بَرْشَة مَكَّاسَة الِّي يْلِمُّوا فِي الضَّرَايِبْ وبَرْشَة مُذْنْبِينْ، مِلِّي كَانُوا يْتَبْعُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ووَقْتِلِّي عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ شَافُوا الِّي يَسُوعْ يَاكِلْ مْعَ المَكَّاسَة والمُذْنْبِينْ، قَالُوا لِتْلَامِذْتُو: «عْلَاشْ يَاكِلْ مْعَ المَكَّاسَة والمُذْنْبِينْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","سْمَعْهُمْ يَسُوعْ وجَاوِبْهُمْ: «المُرْضَى هُومَا الِّي يَحْتَاجُوا لِلطْبِيبْ مُشْ الصْحَاحْ. آنَا جِيتْ لِلْمُذْنْبِينْ، مُشْ لِلصَّالْحِينْ». ");
INSERT INTO aeu_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","وكَانُوا تْلَامِذْةْ يُوحَنَّا والفِرِّيسِيِّينْ صَايْمِينْ. يَاخِي جَاوْ جْمَاعَة لْيَسُوعْ وسِأْلُوهْ: «عْلَاشْ تْلَامِذْةْ يُوحَنَّا وتْلَامِذْةْ الفِرِّيسِيِّينْ يْصُومُوا، وتْلَامِذْتِكْ مَا يْصُومُوشْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","جَاوِبْهُمْ: «يَاخِي يْنَجْمُوا المِسْتَدْعِينْ لِلْعِرْسْ يْصُومُوا والعْرُوسْ مَزَّالْ مْعَاهُمْ؟ مَادَامُو العْرُوسْ مْعَاهُمْ، مَا يْنَجْمُوشْ يْصُومُوا. ");
INSERT INTO aeu_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","آمَا بِشْ يْجِي الوَقْتْ الِّي يِتْنَحَّى فِيهْ العْرُوسْ مِنْ بَحْذَاهُمْ. وَقْتْهَا يْصُومُوا. ");
INSERT INTO aeu_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","حَتَّى حَدْ مَا يْرَقَّعْ لِبْسَة قْدِيمَة بْطَرْفْ قْمَاشْ جْدِيدْ. مَا كَانِشْ تِتْكَمِّشْ القَطْعَة الجْدِيدَة ويِتْجَبِّدْ القْمَاشْ القْدِيمْ، وتْوَلِّي التَّقْطِيعَة أَتْعَسْ مِنْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ومَا فَمَّة حَتَّى وَاحِدْ يْحُطْ شْرَابْ جْدِيدْ فِي ڨِرْبَة قْدِيمَة، بَاشْ الشْرَابْ الجْدِيدْ مَا يِفْلِقْشْ الڨِرْبَة ويِخْسِرْ الشْرَابْ والڨِرْبَة. آمَا الشْرَابْ الجْدِيدْ يِتْحَطْ فِي ڨِرْبَة جْدِيدَة». ");
INSERT INTO aeu_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","وفِي نْهَارْ السِّبْتْ، تْعَدَّى يَسُوعْ وِسْطْ هْنَاشِرْ، وتْلَامِذْتُو بْدَاوْ يْنَحِّيوْ فِي سْبُولْ القَمْحْ وهُومَا مَاشِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","يَاخِي الفِرِّيسِيِّينْ قَالُولُو: «شُوفْ! عْلَاشْ تْلَامِذْتِكْ يَعْمْلُوا حَاجَاتْ مَا يِلْزِمْشْ تِتَعْمَلْ نْهَارْ السِّبْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","جَاوِبْهُمْ: «يَاخِي مَا قْرِيتُوشْ عَلِّي عَمْلُو دَاوِدْ هُوَّ ولِّي مْعَاهْ وَقْتِلِّي إِحْتَاجُوا وجَاعُوا، ");
INSERT INTO aeu_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","كِيفَاشْ دْخَلْ لْخِيمِةْ الإِجْتِمَاعْ وَقْتِلِّي أَبِيأَثَارْ كَانْ كْبِيرْ الكَهَنَة، وكِيفَاشْ كْلَا مِنْ خُبْزْ القُرْبَانْ الِّي مَسْمُوحْ كَانْ لِلْكَهَنَة بَاشْ يَاكْلُوا مِنُّو، وزَادْ عْطَى لِلِّي مْعَاهْ، وكْلَاوْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","وزَادْ قَالِلْهُمْ: « رَاهُو السِّبْتْ مَجْعُولْ لِلْإِنْسَانْ، مُشْ الإِنْسَانْ مَجْعُولْ لِلسِّبْتْ. ");
INSERT INTO aeu_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","هَاذَاكَا عْلَاشْ إِبْنْ الإِنْسَانْ هُوَّ رَبْ السِّبْتْ زَادَا». ");
INSERT INTO aeu_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ودْخَلْ يَسُوعْ لِلْمَعْبِدْ مَرَّة أُخْرَى وكَانْ فَمَّة رَاجِلْ يِدُّو يَابْسَة. ");
INSERT INTO aeu_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","وبْدَاوْ جْمَاعَة يْرَاقْبُوا فِيهْ يْحِبُّوا يْشُوفُوا إِذَا كَانْ بِشْ يِشْفِي الرَّاجِلْ هَاذَاكَا فِي نْهَارْ السِّبْتْ وَلَّا لَا، وهَكَّاكَا يْنَجْمُوا يِتْهْمُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","قَالْ لِلرَّاجِلْ الِّي يِدُّو يَابْسَة: «قُومْ وآقِفْ فِي الوِسْطْ!». ");
INSERT INTO aeu_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","وبَعْدْ سْإِلْ الحَاضْرِينْ: «زَعْمَة حْلَالْ فِي نْهَارْ السِّبْتْ، نَعْمْلُوا الخِيرْ وَلَّا الشَّرْ؟ إِنَّجِّيوْ رُوحْ وَلَّا نُقْتْلُوهَا؟». آمَا هُومَا قَعْدُوا سَاكْتِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","خْزَرِّلْهُمْ يَسُوعْ بْغُشْ وحْزِنْ عْلَى قَسْوِةْ قْلُوبْهُمْ وقَالْ لِلرَّاجِلْ: «مِدْ يِدِّكْ!». مَدْهَا، وإِذَا بِيهَا رَجْعِتْ صْحِيحَة. ");
INSERT INTO aeu_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","وبِالوَقْتْ خَرْجُوا الفِرِّيسِيِّينْ وتْفَاهْمُوا مْعَ أَتْبَاعْ المَلِكْ هِيرُودُسْ، بَاشْ يُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ومْشَى يَسُوعْ وتْلَامِذْتُو لِلْبُحَيْرَة، وتَبْعُوهْ بَرْشَة نَاسْ مِنْ مَنْطَقْةْ الجَلِيلْ واليَهُودِيَّة، ");
INSERT INTO aeu_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ومِنْ أُورْشَلِيمْ وأَدُومِيَّة ومِنْ وْرَاء وَادْ الأُرْدُنْ، وبَرْشَة نَاسْ مِنْ شِيرِة صُورْ وصَيْدَا، عْلَى خَاطِرْهُمْ سَمْعُوا بِلِّي عَمْلُو. ");
INSERT INTO aeu_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","يَاخِي طْلَبْ مِنْ تْلَامِذْتُو يْحَضْرُولُو فْلُوكَة بَاشْ النَّاسْ مَا يْدِزُّوهِشْ، ");
INSERT INTO aeu_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","عْلَى خَاطِرْ مِلِّي شْفَى بَرْشَة نَاسْ، وَلَّى كُلْ مْرِيضْ يِتْزَاحِمْ مْعَ الآخِرْ بَاشْ يُوصِلْ يْمِسُّو. ");
INSERT INTO aeu_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","وكَانِتْ كُلْ مَا تْشُوفُو الأَرْوَاحْ الشِّرِّيرَة اطِّيحْ قُدَّامُو وتْصِيحْ: «إِنْتِ إِبْنْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","وكَانْ يْنَبَّهْ عَلِيهُمْ بْقُوَّة بَاشْ مَا يُنْشْرُوشْ خَبْرُو. ");
INSERT INTO aeu_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ومْبَعِّدْ طْلَعْ يَسُوعْ لِلجْبَلْ، ونَادَى الِّي يْحِبْ عْلِيهُمْ، يَاخِي جَاوِهْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","وإِخْتَارْ مِنْهُمْ أَثْنَاشِنْ وَاحِدْ وسَمَّاهُمْ رُسُلْ بَاشْ يْكُونُوا مْعَاهْ ويَبْعَثْهُمْ يْبَشْرُوا، ");
INSERT INTO aeu_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","وتْكُونْ عَنْدْهُمْ سُلْطَة بَاشْ يْخَرْجُوا الشْوَاطِنْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","والأَثْنَاشْ الِّي اخْتَارْهُمْ هُومَا: سِمْعَانْ الِّي سَمَّاهْ بُطْرُسْ، ");
INSERT INTO aeu_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ويَعْقُوبْ ويُوحَنَّا وْلَادْ زَبَدِي، الِّي سَمَّاهُمْ بُوَانَرْجِسْ ومَعْنَاهَا وْلَادْ الرْعَدْ، ");
INSERT INTO aeu_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","وأَنْدَرَاوُسْ، وفِيلِۑُّسْ، وبَرْثُلْمَاوُسْ، ومَتَّى، وتُومَا، ويَعْقُوبْ وِلْدْ حَلْفَى، وتَدَّاوُسْ، وسِمْعَانْ القَانَوِي، ");
INSERT INTO aeu_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ويَهُوذَا الإِسْخَرْيُوطِي الِّي خَانُو. ");
INSERT INTO aeu_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ومْشَى يَسُوعْ وتْلَامِذْتُو لِلدَّارْ، ومِنْ كُثْرِةْ النَّاسْ الِّي تْلَمُّوا مَرَّة أُخْرَى، مَا خَلْطُوشْ حَتَّى بَاشْ يَاكْلُوا. ");
INSERT INTO aeu_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ووَقْتِلِّي سَمْعُوا أَقَارْبُو جَاوْ بَاشْ يْهِزُّوهْ عْلَى خَاطِرْ قَالُوا: «خْرَجْ مِنْ عَقْلُو». ");
INSERT INTO aeu_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","وعُلَمَاءْ الشَّرِيعَة الِّي جَاوْ مِنْ أُورْشَلِيمْ قَالُوا: «رَاهُو سَاكْنُو بَعْلَزَبُولْ رَئِيسْ الشْوَاطِنْ، وبِيهْ هُوَّ يْخَرِّجْ فِي الشْوَاطِنْ!». ");
INSERT INTO aeu_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","عَيْطِلْهُمْ يَسُوعْ وكَلَّمْهُمْ بْأَمْثَالْ وقَالْ: «كِيفَاشْ إِبْلِيسْ يْنَجِّمْ يْخَرِّجْ رُوحْ شِرِّيرْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","إِذَا كَانْ مَمْلْكَة تْقِسْمِتْ عْلَى بْعَضْهَا، مُشْ مُمْكِنْ تْدُومْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","وإِذَا كَانْ دَارْ تْقِسْمِتْ عْلَى بْعَضْهَا، مُشْ مُمْكِنْ تِثْبِتْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","وإِذَا كَانْ إِبْلِيسْ جَاء ضِدْ رُوحُو وتِقْسِمْ، مَا يْنَجَّمْشْ يْدُومْ، ويِفْنَى. ");
INSERT INTO aeu_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","حَتَّى حَدْ مَا يْنَجِّمْ يُدْخُلْ لْدَارْ رَاجِلْ قْوِي ويِسْرَقْ الحَاجَاتْ الِّي فِيهَا إِلَّا إِذَا كَانْ يْكَتِّفْ الرَّاجِلْ قْبَلْ ومْبَعِّدْ يِسْرَقْلُو دَارُو. ");
INSERT INTO aeu_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","نْقُلْكُمْ الحَقْ: ذْنُوبْ النَّاسْ الكُلْهَا تِتْغْفِرْ، وحَتَّى مِنْ كُفْرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","آمَا الِّي يَكْفِرْ بِالرُّوحْ القُدُسْ، مَا يِتْغْفِرْلُوشْ، ويِبْقَى بْذَنْبُو لِلْأَبَدْ». ");
INSERT INTO aeu_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","الكْلَامْ هَاذَا جَاوِبْ بِيهْ الِّي كَانُوا يْقُولُوا: «سَاكْنُو رُوحْ شِرِّيرْ». ");
INSERT INTO aeu_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","وجَاوْ خْوَاتْ يَسُوعْ وأُمُّو ووِقْفُوا لْبَرَّا مِالدَّارْ وبَعْثُولُو شْكُونْ يْعَيِّطْلُو. ");
INSERT INTO aeu_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","وكَانُوا بَرْشَة نَاسْ قَاعْدِينْ دَايْرِينْ بِيهْ، قَالُولُو: «رَاهِي أُمِّكْ وخْوَاتِكْ يِسْتَنَّاوْ فِيكْ لْبَرَّا». ");
INSERT INTO aeu_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","جَاوِبْهُمْ وقَالْ: «شْكُونْهُمْ أُمِّي وخْوَاتِي؟». ");
INSERT INTO aeu_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","وتْلَفِّتْ لِلِّي قَاعْدِينْ دَايْرِينْ بِيهْ وقَالْ: «هَاذُمْ هُومَا أُمِّي وخْوَاتِي. ");
INSERT INTO aeu_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","وكُلْ وَاحِدْ يَعْمِلْ الِّي يْحِبْ عْلِيهْ اللَّهْ هُوَّ خُويَا وأُخْتِي وأُمِّي». ");
INSERT INTO aeu_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","وبْدَا يَسُوعْ يْعَلِّمْ فِي شَطْ البُحَيْرَة مَرَّة أُخْرَى. وتْلَمُّوا بِيهْ بَرْشَة نَاسْ، يَاخِي وَلَّى طْلَعْ وقْعَدْ فِي وِسْطْ فْلُوكَة فِي المَاء، والنَّاسْ الكُلْ قَعْدُوا عَالشَّطْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","وعَلَّمْهُمْ بَرْشَة حَاجَاتْ بِالأَمْثَالْ وقَالِلْهُمْ فِي تَعْلِيمُو: ");
INSERT INTO aeu_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«إِسْمْعُوا! خْرَجْ الفَلَّاحْ بَاشْ يَزْرَعْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","وَقْتِلِّي هُوَّ يَزْرَعْ، فَمَّة زِرِّيعَة جَاتْ عَالطْرِيقْ، يَاخِي جَاتْ العْصَافِرْ وكْلَاتْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","وفَمَّة زِرِّيعَة أُخْرَى طَاحِتْ فِي أَرْضْ مْحَجْرَة مَا فِيهَاشْ بَرْشَة تْرَابْ، يَاخِي نِبْتِتْ فِيسَعْ عْلَى خَاطِرْ تْرَابْهَا مُشْ غَارَقْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","آمَا وَقْتِلِّي طَلْعِتْ الشَّمْسْ، تْحَرْقِتْ ويِبْسِتْ عْلَى خَاطِرْ مَا عَنْدْهَاشْ عْرُوقْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","وفَمَّة زِرِّيعَة طَاحِتْ فِي وِسْطْ الشُّوكْ، ووَقْتِلِّي نْبِتْ الشُّوكْ خْنَقْهَا ومَا خَلَّاهَاشْ تُثْمُرْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","وفَمَّة زِرِّيعَة أُخْرَى طَاحِتْ فِي الأَرْضْ البَاهْيَة. نِبْتِتْ وكِبْرِتْ وثُمْرِتْ. فَمَّة مِنْهَا الِّي جَابِتْ 30 مَرَّة قَدْ الِّي تِزْرَعّْ، ومِنْهَا الِّي جَابِتْ 60، ومِنْهَا الِّي جَابِتْ 100». ");
INSERT INTO aeu_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ومْبَعِّدْ قَالْ: «الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ!». ");
INSERT INTO aeu_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ووَقْتِلِّي وَلَّى وَحْدُو، سِأْلُوهْ النَّاسْ الدَّايْرِينْ بِيهْ والرُّسُلْ الأَثْنَاشْ عْلَى مَعْنَى المَثَلْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","قَالِلْهُمْ: «إِنْتُومَا تِعْطَالْكُمْ سِرْ مَمْلَكْةْ اللَّهْ. آمَا النَّاسْ الأُخْرِينْ كُلْ شَيْ يِتْقَالِلْهُمْ بِالأَمْثَالْ: ");
INSERT INTO aeu_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","\"بَاشْ قَدْ مَا يُخْزْرُوا مَا يْشُوفُوشْ، وقَدْ مَا يِسْمْعُوا مَا يِفْهْمُوشْ، بَاشْ مَا يْتُوبُوشْ وتِتْغْفِرْ ذْنُوبْهُمْ\"». ");
INSERT INTO aeu_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","وقَالِلْهُمْ يَسُوعْ: «يَاخِي مَا فْهِمْتُوشْ المَثَلْ هَاذَا؟ مَالَا كِيفَاشْ بِشْ تِفْهْمُوا الأَمْثَالْ الأُخْرِينْ الكُلْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","الفَلَّاحْ يَزْرَعْ كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","والزِرِّيعَة الِّي جَاتْ عَالطْرِيقْ، هُومَا النَّاسْ الِّي دُوبْ مَا يِسْمْعُوا الكِلْمَة، يْجِي الشِّيطَانْ ويَخْطِفْ الكِلْمَة الِّي تْزَرْعِتْ فِي قْلُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ولِّي جَاتْ فِي الأَرْضْ المْحَجْرَة، هُومَا النَّاسْ الِّي دُوبْ مَا يِسْمْعُوا الكِلْمَة يِقْبْلُوهَا بْفَرْحَة، ");
INSERT INTO aeu_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","آمَا مَا عَنْدْهُمْشْ عْرُوقْ ومَا يْدُومُوشْ. ودُوبْ مَا يْجِي وَقْتْ صْعِيبْ وَلَّا إِضْطِهَادْ عْلَى خَاطِرْ كِلْمَة اللَّهْ يْسَلْمُوا فِيهَا فِيسَعْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","والزِرِّيعَة الِّي جَاتْ فِي وِسْطْ الشُّوكْ، هُومَا النَّاسْ الِّي سَمْعُوا الكِلْمَة، ");
INSERT INTO aeu_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","آمَا هْمُومْ الدِّنْيَا ومْحَبِّةْ الفْلُوسْ وشَهْوَاتْ الحَاجَاتْ الأُخْرَى، تُدْخِلْ وتُخْنُقْ الكِلْمَة وتْوَلِّي مَا عَنْدْهَاشْ ثْمَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","آمَا الِّي يِتْزَرْعُوا فِي الأَرْضْ البَاهْيَة، هُومَا الِّي يِسْمْعُوا الكِلْمَة ويِقْبْلُوهَا ويُثْمْرُوا، مِنْهُمْ الِّي يْجِيبْ 30 مَرَّة قَدْ الِّي تِزْرَعّْ ومِنْهُمْ الِّي يْجِيبْ 60 ومِنْهُمْ الِّي يْجِيبْ 100». ");
INSERT INTO aeu_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","وقَالِلْهُمْ يَسُوعْ: « يْجِيبِشْ وَاحِدْ فْنَارْ ويْغُمُّو بْطَاسَة وَلَّا يْحُطُّو تَحْتْ سْرِيرْ؟ يَاخِي مُشْ يِتْحَطْ فِي بْلَاصَة عَالْيَة؟ ");
INSERT INTO aeu_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","كُلْ حَاجَة مْخُبْيَة بِشْ تُظْهُرْ وكُلْ سِرْ بِشْ يِتْكْشِفْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ». ");
INSERT INTO aeu_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","وقَالِلْهُمْ: « رَكْزُوا فِلِّي تِسْمْعُوا فِيهْ! رَاهُو بِالكِيلْ الِّي تْكَيْلُوا بِيهْ، يِتْكَيْلِلْكُمْ ويِتْزَادْ عْلِيهْ، ");
INSERT INTO aeu_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","الِّي عَنْدُو يِتْزَادْلُو أَكْثِرْ، ولِّي مَا عَنْدُوشْ حَتَّى الِّي عَنْدُو يِتْفَكْلُو». ");
INSERT INTO aeu_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","وقَالْ يَسُوعْ: «مَمْلَكْةْ اللَّهْ تْشَبَّهْ لْفَلَّاحْ يَرْمِي الزِّرِّيعَة فِي الأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ومْبَعِّدْ يُرْقُدْ فِي اللِّيلْ ويْقُومْ فِي النْهَارْ والزِّرِّيعَة تِطْلَعْ وتِكْبِرْ، وهُوَّ مَا يَعْرِفْشْ كِيفَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","الأَرْضْ وَحَّدْهَا تَعْطِي الثَّمْرَة، تْنَبِّتْ، وبَعْدْ تْسَبِّلْ، والسْبُولَة تِتْمْلَى بِالقَمْحْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","آمَا دُوبْ مَا الصَّابَة تَحْضِرْ، يَحْصِدْهَا الفَلَّاحْ بِالمِنْجِلْ عْلَى خَاطِرْ جَاء وَقْتْ الحْصَادْ». ");
INSERT INTO aeu_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","وقَالْ يَسُوعْ: «بَاشْ نْشَبْهُوا مَمْلَكْةْ اللَّهْ وبْأَيْ مَثَلْ نْمَثْلُوهَا؟ ");
INSERT INTO aeu_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","تْشَبَّهْ لْزِرِّيعَة الخَرْدِلْ الِّي هِيَّ أَصْغِرْ زَرِّيعَة تِتْزْرَعْ فِي الأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","آمَا وَقْتِلِّي تِنْبِتْ، تْوَلِّي أَكْبِرْ مِالنَّبْتَاتْ الكُلْ واطَّلَّعْ أَغْصَانْ كْبِيرَة، حَتَّى عْصَافِرْ السْمَاء تْعَشِشْ فِي ظُلْهَا». ");
INSERT INTO aeu_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","كَانْ يَسُوعْ يْعَلَّمْ فِيهُمْ كِلْمِةْ اللَّهْ بْبَرْشَة أَمْثَالْ كِيفْ مَا هَاذِي، عْلَى قَدْ مَا يْنَجْمُوا يِفْهْمُوا. ");
INSERT INTO aeu_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ومَا كَانْ يَحْكِيلْهُمْ حَتَّى شَيْ مِنْ غِيرْ مَثَلْ، آمَا كَانْ يْفَسِّرْ لِتْلَامِذْتُو كُلْ شَيْ وَقْتِلِّي يُقْعُدْ مْعَاهُمْ وَحَّدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ونْهَارِتْهَا فِي العْشِيَّة، قَالْ يَسُوعْ لِتْلَامِذْتُو: «هَيَّا نْشُقُّوا البُحَيْرَة لِلجِّيهَة الأُخْرَى». ");
INSERT INTO aeu_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","يَاخِي خَلَّاوْ النَّاسْ وهَزُّوهْ مْعَاهُمْ فِي الفْلُوكَة الِّي كَانْ فِيهَا، وكَانُوا مْعَاهْ فْلَايِكْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","وهَبِّتْ رِيحْ قْوِيَّة ووَلَّى المُوجْ يَضْرِبْ فِي الفْلُوكَة حَتَّى لِينْ قْرِيبْ تِتْعَبَّى بِالمَاء. ");
INSERT INTO aeu_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","وكَانْ يَسُوعْ رَاقِدْ فِي آخِرْ الفْلُوكَة وحَاطِطْ رَاسُو عْلَى مْخَدَّة. قَيْمُوهْ وقَالُولُو: «يَا مُعَلِّمْ! يَاخِي مَا يْهِمِّكْشْ فِينَا كَانْ نُغْرْقُوا؟». ");
INSERT INTO aeu_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","وَلَّى قَامْ وأْمَرْ الرِّيحْ وقَالْ لِلْبُحَيْرَة: «أُسْكُتْ! رِيضْ!» يَاخِي وِقْفِتْ الرِّيحْ والدِّنْيَا هْدَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","وقَالِلْهُمْ: «شْبِيكُمْ خُفْتُوا؟ كِيفَاشْ مَا عَنْدْكُمْشْ إِيمَانْ حَتَّى لْتَوَّا؟». ");
INSERT INTO aeu_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","تْرِعْبُوا وقَالُوا لِبْعَضْهُمْ: «شْكُونُو هَاذَا؟ حَتَّى مِالرِّيحْ والبُحَيْرَة يْطِيعُوهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ووُصْلُوا لِلجِّيهَة الأُخْرَى مْتَاعْ البُحَيْرَة فِي مَنْطَقْةْ الجَرَّاسِيِّينْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ودُوبْ مَا هْبَطْ يَسُوعْ مِالفْلُوكَة، عُرْضُو رَاجِلْ خَارِجْ مِالجَّبَّانَة سَاكْنُو رُوحْ شِرِّيرْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","كَانْ يُسْكُنْ وِينْ يِدْفْنُوا المُوتَى، وحَتَّى حَدْ مَاعَادْ يْنَجِّمْ يُرْبْطُو حَتَّى بِالسْلَاسِلْ، ");
INSERT INTO aeu_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","عْلَى خَاطِرْ بَرْشَة مَرَّاتْ رَبْطُوهْ بِالحْدِيدْ وبِالسْلَاسِلْ وكَانْ يْقَلَّعْهُمْ ويَقْطَّعْهُمْ، ومَا نَجِّمْ حَدْ يْسَيْطِرْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","وكَانْ لِيلْ ونْهَارْ وهُوَّ فِي الجَّبَّانَة وفِي الجْبُولَاتْ، يْصِيحْ ويَجْرَحْ فِي رُوحُو بِالحْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","وكِي شَافْ يَسُوعْ مِنْ بْعِيدْ جْرَالُو وسْجِدْلُو. ");
INSERT INTO aeu_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","وصَاحْ عْلَى طُولْ صُوتُو: «آشْ بِينِي وبِينِكْ يَا يَسُوعْ إِبْنْ اللَّهْ العَالِي؟ حَلَّفْتِكْ بِاللَّهْ مَا تْعَذَّبْنِيشْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","وتْكَلِّمْ هَكَّا عْلَى خَاطِرْ يَسُوعْ قَالُّو: «يَا رُوحْ شِرِّيرْ، أُخْرُجْ مِالرَّاجِلْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","وسِأْلُو يَسُوعْ: «آشْ إِسْمِكْ؟». جَاوْبُو: «إِسْمِي جَيْشْ، عْلَى خَاطِرْنَا بَرْشَة!». ");
INSERT INTO aeu_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","وقْعَدْ يِتْشَحَّتْ فِيهْ بَاشْ مَا يْطَرَّدْهُمْشْ بْعِيدْ عَالمَنْطْقَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","وكَانُوا فَمَّة بَرْشَة حْلَالِفْ سَارْحِينْ بِيهُمْ بَحْذَا الجْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","يَاخِي طَلْبُوا مِنُّو الأَرْوَاحْ وقَالُوا: «أَبْعَثْنَا لِلْحْلَالِفْ نُدْخْلُوا فِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","وَلَّى يَسُوعْ خَلَّاهُمْ، يَاخِي خَرْجُوا ودَخْلُوا فِي الحْلَالِفْ، الِّي كَانُوا قْرَابِةْ 2 000 حَلُّوفْ. وبِالوَقْتْ تِرْمَاوْ الكُلْ مِنْ حَافِةْ الجْبَلْ فِي البُحَيْرَة وغُرْقُوا. ");
INSERT INTO aeu_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","وهَرْبُوا سُرَّاحْ الحْلَالِفْ ونَشْرُوا الخْبَرْ فِي المْدِينَة وفِي الدْشُرْ الدَايْرَة بِيهَا وخَرْجُوا النَّاسْ بَاشْ يْشُوفُوا آشْ صَارْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","وجَاوْ لْيَسُوعْ يَاخِي شَافُوا الرَّاجِلْ الِّي كَانِتْ سَاكْنِتُّو الأَرْوَاحْ الشِّرِّيرَة رْجَعْلُو عَقْلُو ولَابِسْ دَبْشُو وقَاعِدْ، يَاخِي خَافُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","والنَّاسْ الِّي كَانُوا شَاهْدِينْ، حْكَاوْلْهُمْ آشْ صَارْ لِلرَّاجِلْ الِّي سَاكْنِتُّو الأَرْوَاحْ الشِّرِّيرَة ولِلْحْلَالِفْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","يَاخِي شَدُّو صْحِيحْ فِي يَسُوعْ بَاشْ يُخْرُجْ مِنْ مَنْطْقِتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","وكِي جَاء طَالَعْ فِي الفْلُوكَة طْلَبْ مِنُّو الرَّاجِلْ الِّي كَانِتْ سَاكْنِتُّو الأَرْوَاحْ الشِّرِّيرَة بَاشْ يِمْشِي مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","آمَا هُوَّ مَا خَلَّاهِشْ وقَالُّو: «إِمْشِي لْدَارِكْ ولُمَّالِيكْ واحْكِيلْهُمْ آشْ عْمَلْ مْعَاكْ الرَّبْ وكِيفَاشْ رَحْمِكْ». ");
INSERT INTO aeu_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","يَاخِي مْشَى لْمَنْطَقْةْ العَشْرَة مُدُنْ، وبْدَا يَحْكِي عَلِّي عَمْلُو مْعَاهْ يَسُوعْ. والنَّاسْ الكُلْ قَعْدُوا بَاهْتِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ووَقْتِلِّي رْجَعْ يَسُوعْ بِالفْلُوكَة لِلجِّيهَة الأُخْرَى مْتَاعْ البُحَيْرَة، جَاوْ بَرْشَة نَاسْ لِلشَّطْ وتْلَمُّوا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","جَاء وَاحِدْ مِنْ رُؤَسَاءْ مَعْبِدْ اليْهُودْ إِسْمُو يَايْرُسْ، ودُوبْ مَا شَافُو تِرْمَى قُدَّامْ سَاقِيهْ ");
INSERT INTO aeu_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","وقْعَدْ يِتْشَحَّتْ فِيهْ وقَالُّو: «بِنْتِي الصْغِيرَة بِشْ تْمُوتْ. إِمْشِي مْعَايَا وحُطْ يِدِّكْ عْلِيهَا، بَاشْ تِتْشْفَى وتَحْيَى». ");
INSERT INTO aeu_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ولَّى مْشَى مْعَاهْ. وتَبْعُوهْ بَرْشَة نَاسْ وكَانُوا يِدَّازُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","وكَانِتْ فَمَّة مْرَا عَنْدْهَا أَثْنَاشِنْ سْنَة وهِيَّ مْرِيضَة بْنَزِيفْ دَمْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","وعَانَاتْ بَرْشَة وهِيَّ ادَّاوِي عَنْدْ الطُبَّة، وصَرْفِتْ الِّي وْرَاهَا ولِّي قُدَّامْهَا آمَا مَا اسْتْفَادِتْ بْشَيْ، بِالعَكْسْ حَالِتْهَا وَلَّاتْ أَتْعِسْ مِنْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ووَقْتِلِّي سَمْعِتْ بْيَسُوعْ، جَاتْ مِنْ وْرَاهْ فِي وِسْطْ النَّاسْ ومَسِّتْلُو حْوَايْجُو. ");
INSERT INTO aeu_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","عْلَى خَاطِرْهَا قَالِتْ بِينْهَا وبِينْ رُوحْهَا: «يِكْفِينِي نْمِسْ حْوَايْجُو بَاشْ نَبْرَا». ");
INSERT INTO aeu_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","وبِالوَقْتْ وْقِفْ النَّزِيفْ وحَسِّتْ رُوحْهَا بْرَاتْ مِنْ مْرَضْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","وفِي نَفْسْ اللَّحْظَة يَسُوعْ حَسْ بْقُوَّة خَرْجِتْ مِنُّو، تْلَفِّتْ لِلنَّاسْ وسْإِلْهُمْ: «شْكُونْ مَسْلِي حْوَايْجِي؟». ");
INSERT INTO aeu_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","قَالُولُو تْلَامِذْتُو: «يَاخِي تْشُوفْ فِي النَّاسْ كِيفَاشْ يِدَّازُّوا عْلِيكْ مِنْ كُلْ شِيرَة وتِسْإِلْ: \"شْكُونْ الِّي مَسْنِي؟\"». ");
INSERT INTO aeu_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","آمَا هُوَّ تْلَفِّتْ بَاشْ يْشُوفْ شْكُونْ مَسُّو. ");
INSERT INTO aeu_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","يَاخِي جَاتُو المْرَا وهِيَّ تُرْعُشْ مِالخُوفْ عْلَى خَاطِرْهَا عَرْفِتْ آشْ صَارِلْهَا، وتِرْمَاتْ قُدَّامُو وقَالِتْلُو عَالحْقِيقَة الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","قَالِلْهَا: «يَا بِنْتِي، إِيمَانِكْ شْفَاكْ، إِمْشِي فِي الأَمَانْ وابْرَى مِنْ مَرْضِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","وهُوَّ يِتْكَلِّمْ، جَاوْ جْمَاعَة مِنْ دَارْ رَئِيسْ مَعْبِدْ اليْهُودْ وقَالُولُو: « بِنْتِكْ مَاتِتْ. عْلَاشْ تُقْعُدْ إِتَّعِّبْ فِي المُعَلِّمْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","آمَا يَسُوعْ كِي سْمَعْهُمْ، قَالْ لْرَئِيسْ المَعْبِدْ: «مَا تْخَافِشْ، أَمِّنْ بَرْكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ومَا خَلَّا حَتَّى وَاحِدْ يِمْشِي مْعَاهْ، كَانْ بُطْرُسْ ويَعْقُوبْ ويُوحَنَّا خُو يَعْقُوبْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","وكِي وْصُلْ لْدَارْ رَئِيسْ المَعْبِدْ، وشَافْ النَّاسْ قَاعْدِينْ يِبْكِيوْ ويْنَوْحُوا، ");
INSERT INTO aeu_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","دْخَلْ وقَالِلْهُمْ: «عْلَاشْ تِبْكِيوْ وتْنَوْحُوا؟ البْنَيَّة مَا مَاتِتْشْ، هِيَّ رَاقْدَة أَكَهَوْ». ");
INSERT INTO aeu_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","يَاخِي ضَحْكُوا عْلِيهْ. وَلَّى خَرِّجْهُمْ يَسُوعْ الكُلْ وهَزْ مْعَاهْ بُو البْنَيَّة وأُمْهَا والتْلَامْذَة الِّي جَاوْ مْعَاهْ ودْخَلْ لِلْبِيتْ المَوْجُودَة فِيهَا البْنَيَّة. ");
INSERT INTO aeu_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","وشَدْهَا مِنْ يِدْهَا وقَالِلْهَا: «طَلِيثَة قُومْ!» ولِّي مَعْنَاهَا: «يَا بْنَيَّة، نْقُلِّكْ قُومْ!». ");
INSERT INTO aeu_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","وبِالوَقْتْ قَامِتْ البْنَيَّة ووَلَّاتْ تِمْشِي. وكَانْ عْمُرْهَا أَثْنَاشِنْ سْنَة. وقَعْدُوا النَّاسْ بَاهْتِينْ عَالإِخِّرْ. ");
INSERT INTO aeu_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ووَصَّاهُمْ يَسُوعْ وأَكِّدْ عْلِيهُمْ بَاشْ مَا يْقُولُوا لْحَتَّى حَدْ عَلِّي صَارْ، وطْلَبْ مِنْهُمْ بَاشْ يَعْطِيوْهَا تَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ومْشَى يَسُوعْ مِالمَنْطْقَة هَاذِيكَا ورْجَعْ لِبْلَادُو وتَبْعُوهْ تْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ونْهَارْ السِّبْتْ، كَانْ يَسُوعْ يْعَلِّمْ فِي المَعْبَدْ. بَرْشَة نَاسْ تْعَجْبُوا وَقْتِلِّي سَمْعُوهْ وقَالُوا: «مْنِينْ لِيهْ هَاذَا؟ ومْنِينْ جَاتُو الحِكْمَة هَاذِي ومْنِينْ جَاتُو القُوَّة بَاشْ يَعْمِلْ المُعْجْزَاتْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","يَاخِي مُشْ هَاذَا النَّجَّارْ وِلْدْ مَرْيِمْ، وخُو يَعْقُوبْ ويُوسِي ويَهُوذَا وسِمْعَانْ؟ ومُشْ خْوَاتُو البْنَاتْ عَايْشِينْ بِينَاتْنَا؟». هَاذَاكَا عْلَاشْ مَا حَبُّوشْ يِقْبْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","آمَا هُوَّ قَالِلْهُمْ: « النَّبِيْ مَا عَنْدُوشْ كَرَامَة فِي بْلَادُو وبِينْ أَهْلُو ونَاسُو». ");
INSERT INTO aeu_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ومَا نَجِّمْ يَعْمِلْ غَادِي حَتَّى مُعْجْزَة، كَانْ شْوَيَّة مُرْضَى حَطْ عْلِيهُمْ يْدِيهْ وشْفَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","وبْقَى مِتْعَجِّبْ مِنْ قِلِّةْ إِيْمَانْهُمْ. وبْدَا يْدُورْ فِي الدْشُرْ القْرِيبَة ويْعَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ومْبَعِّدْ عَيِّطْ لِلتْلَامْذَة الأَثْنَاشْ، وبْعَثْهُمْ كُلْ زُوزْ مْعَ بْعَضْهُمْ، وعْطَاهُمْ سُلْطَة عَالأَرْوَاحْ الشِّرِّيرَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ووَصَّاهُمْ بَاشْ مَا يْهِزُّوا شَيْ مْعَاهُمْ فِي الطْرِيقْ كَانْ عْصَا، لَا خُبْزْ ولَا صُرَّة ولَا فْلُوسْ فِي جْيُوبْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","آمَا يِلْبْسُوا صَنْدَالْ وكَانْ تَبْدِيلَة وَحْدَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","وقَالِلْهُمْ: «كِي تُدْخْلُوا لْدَارْ أَبْقَاوْ فِيهَا حَتَّى لِينْ تُخْرْجُوا مِالمْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","وأَيْ بْلَاصَة إِمَّالِيهَا مَا يِسْتَقْبْلُوكُمْشْ ومَا يِسْمْعُوشْ كْلَامْكُمْ، أُخْرْجُوا مِنْهَا وأُنْفْضُوا التْرَابْ مِنْ سَاقِيكُمْ أَمَارَة إِنُّو اللَّهْ مُشْ فَرْحَانْ بِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","يَاخِي مْشَاوْ يْبَشْرُوا ويُطْلْبُوا مِالنَّاسْ إِنْهُمْ يْتُوبُوا. ");
INSERT INTO aeu_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","وخَرّْجُوا بَرْشَة شْوَاطِنْ، ودِهْنُوا بَرْشَة مُرْضَى بِالزِّيتْ، وشْفَاوْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","وسْمَعْ المَلِكْ هِيرُودُسْ بْيَسُوعْ، عْلَى خَاطِرْ إِسْمُو وَلَّى مَشْهُورْ. كَانُوا نَاسْ يْقُولُوا: «هَاذَا يُوحَنَّا الِّي يْعَمِّدْ قَامْ مِالمُوتْ، هَاذَاكَا عْلَاشْ قَاعِدْ يَعْمِلْ فِي المُعْجْزَاتْ». ");
INSERT INTO aeu_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ونَاسْ أُخْرِينْ يْقُولُوا: «هَاذَا إِيلِيَّا» وأُخْرِينْ يْقُولُوا: «هَاذَا نَبِيْ كِيفْ الأَنْبِيَاءْ الأُخْرِينْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","آمَا هِيرُودُسْ وَقْتِلِّي سْمَعْ قَالْ: «هَاذَا يُوحَنَّا الِّي آنَا قَصِّيتْلُو رَاسُو، قَامْ مِالمُوتْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","عْلَى خَاطِرْ هِيرُودُسْ بِيدُو بْعَثْ شْكُونْ شَدْ يُوحَنَّا ورَبْطُو فِي الحَبْسْ، بِسْبَبْ هِيرُودِيَّا، مَرْتْ خُوهْ فِيلِۑُّسْ، الِّي عَرِّسْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","وكَانْ يُوحَنَّا يْقُلُّو: «حْرَامْ عْلِيكْ تْعَرِّسْ بْمَرْتْ خُوكْ». ");
INSERT INTO aeu_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","هَاذَاكَا عْلَاشْ كَانِتْ هِيرُودِيَّا نَاقْمَة عْلَى يُوحَنَّا وتْحِبْ تُقْتْلُو، آمَا مَا نَجْمِتْشْ، ");
INSERT INTO aeu_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","عْلَى خَاطِرْ هِيرُودُسْ كَانْ يْخَافْ مِنُّو ويَحْمِي فِيهْ، وعَارِفْ الِّي هُوَّ رَاجِلْ تَقِيْ وصَالَحْ. وكَانْ يْحِبْ يِسْمْعُو، رَغْمِلِّي كَانْ كْلَامُو يْحَيْرُو بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","وجَاتْهَا الفُرْصَة فِي عِيدْ مِيلَادْ هِيرُودُسْ، وَقْتِلِّي عْمَلْ عْشَاء، اسْتَدْعَى فِيهْ المَسْؤُولِينْ الكْبَارْ وضُبَّاطْ الجَيْشْ وأَعْيَانْ مَنْطَقْةْ الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","وهُومَا يِتْعَشَّاوْ، دَخْلِتْ بِنْتْ هِيرُودِيَّا وشَطْحِتْ، وعِجْبِتْ هِيرُودُسْ والنَّاسْ القَاعْدِينْ مْعَاهْ. وَلَّى المَلِكْ قَالْ لِلْبْنَيَّة: «أُطْلْبْ الِّي تْحِبْ عْلِيهْ، وآنَا نَعْطِيهُولِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","وزَادْ حْلِفِّلْهَا وقَالْ: «الِّي تُطْلْبُو نَعْطِيهُولِكْ، حَتَّى لَوْ كَانْ نُصْ مَمْلِكْتِي!». ");
INSERT INTO aeu_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","يَاخِي خَرْجِتْ وسِأْلِتْ أُمْهَا: «زَعْمَة آشْ نُطْلُبْ؟». جَاوْبِتْهَا: «رَاسْ يُوحَنَّا الِّي يْعَمِّدْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","رَجْعِتْ بِالوَقْتْ لِلْمَلِكْ وقَالِتْلُو: «نْحِبِّكْ تَعْطِينِي تَوَّا رَاسْ يُوحَنَّا الِّي يْعَمِّدْ فِي طْبَقْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","حْزِنْ المَلِكْ بَرْشَة. آمَا عْلَى خَاطِرْ اليْمِينْ الِّي حِلْفُو وعْلَى خَاطِرْ الضْيُوفْ، مَا حَبِّشْ يِتْرَاجَعْ فِي وَعْدُو لِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","وبِالوَقْتْ بْعَثْ المَلِكْ سَيَّافْ وأَمْرُو بَاشْ يْجِيبْلُو رَاسْ يُوحَنَّا. يَاخِي مْشَالُو وقَصْلُو رَاسُو فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","وجَابُو فِي طْبَقْ وعْطَاهْ لِلْبْنَيَّة، وهِيَّ هَزِّتُو لْأُمْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ووَقْتِلِّي سَمْعُوا تْلَامِذْةْ يُوحَنَّا بِلِّي صَارْ، جَاوْ وهَزُّوا الجُثَّة ودِفْنُوهَا فِي قْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","وجَاوْ الرُّسُلْ لْيَسُوعْ وحْكَاوْلُو عَالحَاجَاتْ الكُلْ الِّي عَمْلُوهَا ولِّي عَلّْمُوهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ومِنْ كُثْرِةْ النَّاسْ الِّي كَانُوا مَاشِينْ جَايِينْ عْلِيهُمْ، مَا لْقَاوِشْ حَتَّى الوَقْتْ بَاشْ يَاكْلُوا. وَلَّى يَسُوعْ قَالِلْهُمْ : «إِيجَاوْ مْعَايَا إِنْتُومَا وَحَّدْكُمْ لِبْلَاصَة خَالْيَة وارْتَاحُوا شْوَيَّة». ");
INSERT INTO aeu_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","يَاخِي مْشَاوْ بِالفْلُوكَة وَحَّدْهُمْ لِبْلَاصَة خَالْيَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","آمَا بَرْشَة نَاسْ شَافُوهُمْ وعَرْفُوهُمْ وِينْ مَاشِينْ، يَاخِي خَرْجُوا مِنْ كُلْ دَشْرَة، يِجْرِيوْ عْلَى سَاقِيهُمْ، وسِبْقُوهُمْ لِلْبْلَاصَة الِّي مَاشِينْ لِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","كِي هْبَطْ يَسُوعْ مِالفْلُوكَة، شَافْ بَرْشَة نَاسْ مَلْمُومِينْ، يَاخِي حَنْ عْلِيهُمْ، عْلَى خَاطِرْهُمْ كَانُوا كِي الغْنَمْ الِّي مَا عَنْدْهَاشْ سَارِحْ. وبْدَا يْعَلِّمْ فِيهُمْ فِي بَرْشَة حَاجَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","وكِي تْعَدَّى النْهَارْ، جَاوْ التْلَامْذَة لْيَسُوعْ وقَالُولُو: «البْلَاصَة خَالْيَة، والنْهَارْ قْرِيبْ يُوفَى. ");
INSERT INTO aeu_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","أَبْعِثْ النَّاسْ خَلِّيهُمْ يِمْشِيوْ لِلْفِيرْمَاتْ والبْلَايِصْ القْرِيبَة ويِشْرِيوْ حَاجَة يَاكْلُوهَا». ");
INSERT INTO aeu_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","يَاخِي جَاوِبْهُمْ: «أَعْطِيوْهُمْ إِنْتُومَا حَاجَة يَاكْلُوهَا». قَالُولُو: «تْحِبْنَا نِشْرِيوْ خُبْزْ بِفْلُوسْ ثْمَنْيَة شْهُورْ خِدْمَة بَاشْ نَعْطِيوْهُمْ يَاكْلُوا؟». ");
INSERT INTO aeu_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","قَالِلْهُمْ: «إِمْشِيوْ وشُوفُوا قَدَّاشْ عَنْدْكُمْ مِنْ خُبْزَة؟». ووَقْتِلِّي شَافُوا قَالُولُو: «خَمْسَة خُبْزَاتْ وحُوتِّينْ». ");
INSERT INTO aeu_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","أْمَرْهُمْ يَسُوعْ بَاشْ يْقَعْدُوا النَّاسْ كُلْ جْمَاعَة مْعَ بْعَضْهُمْ فُوقْ الحْشِيشْ الأَخْضِرْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","قَعْدُوا كُلْ جْمَاعَة مْعَ بْعَضْهُمْ فِي حْلِقْ. حْلِقْ فِيهُمْ 100 وْحْلِقْ 50. ");
INSERT INTO aeu_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","وخْذَا يَسُوعْ الخَمْسَة خُبْزَاتْ والحُوتِّينْ، وهَزْ عِينِيهْ لِلسْمَاء وشْكَرْ اللَّهْ، وقْسَمْ الخُبْزَاتْ، وعْطَى لِتْلَامِذْتُو بَاشْ يْفَرْقُوهُمْ عَالنَّاسْ. والحُوتِّينْ قَسَّمْهُمْ عَالقَاعْدِينْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","والكُلْ كْلَاوْ وشَبْعُوا. ");
INSERT INTO aeu_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","وفُضْلِتْ أَثْنَاشِنْ قُفَّة مْعِبْيَة بِالخُبْزْ والحُوتْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ولِّي كْلَاوْ مِالخُبْزْ كَانُوا 5 000 رَاجِلْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ومْبَعْدْهَا قَدْ قَدْ، حْكُمْ يَسُوعْ عْلَى تْلَامِذْتُو بَاشْ يِطْلْعُوا فِي الفْلُوكَة ويِسْبْقُوهْ لِلجِّيهَة المْقَابْلَة، لْدَشْرِةْ بِيتْ صَيْدَا، مَا بِينْ هُوَّ يَبْعَثْ النَّاسْ يْرَوْحُوا. ");
INSERT INTO aeu_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","وبَعْدْمَا وَدَّعْهُمْ، طْلَعْ لِلجْبَلْ بَاشْ يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","وكِي جَاء اللِّيلْ، كَانِتْ الفْلُوكَة فِي وِسْطْ البُحَيْرَة وكَانْ يَسُوعْ وَحْدُو عَالبَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","وشَافْ تْلَامِذْتُو يِتْعَذْبُوا وهُومَا يْجَدْفُوا عْلَى خَاطِرْ الرِّيحْ كَانِتْ عَاكْسِتْهُمْ. قْبَلْ الفَجْرْ جَاهُمْ مَاشِي فُوقْ المَاء وزَعْمَة لَا فَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","وَقْتِلِّي شَافُوهْ يِمْشِي فُوقْ المَاء مْشَى فِي بَالْهُمْ شَبَحْ يَاخِي بْدَاوْ يْصِيحُوا. ");
INSERT INTO aeu_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","عْلَى خَاطِرْ الكُلْهُمْ شَافُوهْ وتْرِعْبُوا. آمَا هُوَّ كَلَّمْهُمْ بِالوَقْتْ وقَالِلْهُمْ: «إِتْشَجْعُوا. رَانِي آنَا هُوَّ، مَا تْخَافُوشْ!». ");
INSERT INTO aeu_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","وكِي طْلَعْ مْعَاهُمْ فِي الفْلُوكَة، رْكَحْ الرِّيحْ . يَاخِي بِهْتُوا بَرْشَة وقَعْدُوا مِتْعَجْبِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","عْلَى خَاطِرْ مَا فِهْمُوا شَيْ مِنْ مُعْجِزْةْ الخُبْزْ، مِنْ كُثْرْ مَا كَانِتْ قْلُوبْهُمْ كَاسْحَة. ");
INSERT INTO aeu_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","وكِي شَقُّوا البُحَيْرَة وُصْلُوا لْمَنْطَقْةْ جَنِّيسَارْتْ ورَبْطُوا الفْلُوكَة غَادِي. ");
INSERT INTO aeu_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ودُوبْ مَا هَبْطُوا مِنْهَا النَّاسْ عَرْفُوا الِّي هُوَّ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","بْدَاوْ يِجْرِيوْ فِي المَنْطْقَة الكُلْ ويْهِزُّولُو المُرْضَى فُوقْ فْرُوشَاتْهُمْ لْكُلْ بْلَاصَة يِسْمْعُوا بِيهْ مْشَالْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","وكُلْ بْلَاصَة يِمْشِيلْهَا، سِوَى لِلدْشُرْ وَلَّا الفِيرْمَاتْ وَلَّا الأَرْيَافْ، يْحُطُّوا المُرْضَى فِي وِسْطْ السَّاحَة ويُطْلْبُوا مِنُّو بَاشْ يْخَلِّيهُمْ يْمِسُّوا حَتَّى طْرَاطِشْ حْوَايْجُو. ولِّي مَسُّوهْ الكُلْ تِشْفَاوْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","تْلَمُّوا بِيهْ الفِرِّيسِيِّينْ ومْعَاهُمْ جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَة الجَّايِينْ مِنْ أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","وشَافُوا جْمَاعَة مِنْ تْلَامِذْتُو يَاكْلُوا بِيدِيهُمْ مَنْجُوسِينْ، مِنْ غِيرْ مَا يَغْسْلُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","وكَانُوا الفِرِّيسِيِّينْ واليْهُودْ بْصِيفَة عَامَّة مَا يَاكْلُوا إِلَّا مَا يَغْسْلُوا يْدِيهُمْ عْلَى خَاطِرْهُمْ يْحَافْظُوا عَالعَادَاتْ الِّي فَرْضُوهَا شْيُوخْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","وكَانُوا كِي يِرْجْعُوا مِالسُّوقْ مَا يَاكْلُوا إِلَّا بَعْدْمَا يَطْهْرُوا. وفَمَّة بَرْشَة عَادَاتْ أُخْرَى خْذَاوْهَا مِنْ جْدُودْهُمْ وحَافْظُوا عْلِيهَا، كِيمَا غَسْلَانْ الكِيسَانْ والصْحَافِي والمَاعُونْ النْحَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","يَاخِي سِأْلُوهْ الفِرِّيسِيِّينْ وعُلَمَاءْ الشَّرِيعَة: «عْلَاشْ تْلَامِذْتِكْ مَا يِتْصَرْفُوشْ بْحَسْبْ عَادَاتْ شْيُوخْنَا، يَاكْلُوا وإِيدِيهُمْ مُشْ طَاهْرَة؟». ");
INSERT INTO aeu_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","جَاوِبْهُمْ يَسُوعْ: «يَا مُنَافْقِينْ! عَنْدُو الحَقْ إِشَعْيَاءْ وَقْتِلِّي تْنَبَّأْ عْلِيكُمْ وقَالْ فِي الكْتُبْ المُقَدْسَة: \"الشَّعْبْ هَاذَا يِكْرِمْنِي بْفُمُّو، آمَا قَلْبُو بْعِيدْ عْلِيَّا. ");
INSERT INTO aeu_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","عْبَادِتْهُمْ لِيَّا بَاطْلَة، وقَاعْدِينْ يْعَلْمُوا فِي وْصَايَا حَطُّوهَا النَّاسْ\". ");
INSERT INTO aeu_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","«سَيَّبْتُوا وْصِيِّةْ اللَّهْ وشَدِّيتُوا فِي عَادَاتْ وتَقَالِيدْ عَمْلُوهُمْ النَّاسْ!». ");
INSERT INTO aeu_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","وقَالِلْهُمْ: «مَزْعَمْكُمْ كِي تْخَلِّيوْ وْصِيِّةْ اللَّهْ عْلَى جْنَبْ وتْكَبْشُوا فِي عَادَاتْكُمْ وتَقَالِيدْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","مُوسَى قَالْ: \"إِكْرِمْ بُوكْ وأُمِّكْ، ولِّي يْسِبْ بُوهْ وَلَّا أُمُّو يِلْزْمُو يِتْقْتَلْ\". ");
INSERT INTO aeu_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","آمَا إِنْتُومَا تْقُولُوا: \"إِذَا وَاحِدْ قَالْ لْبُوهْ وَلَّا لْأُمُّو الِّي كُنْتْ نْعَاوِنْ فِيكْ بِيهْ رَانِي عْطِيتُو لِلَّهْ، ");
INSERT INTO aeu_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","يْوَلِّي مَعْفِي، ومُشْ لَازِمْ يْعَاوِنْ بُوهْ وَلَّا أُمُّو\". ");
INSERT INTO aeu_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","هَكَّا تْرُدُّوا كْلَامْ اللَّهْ بَاطِلْ بْتَقَالِيدْكُمْ الِّي تِتْوَارْثُوا فِيهَا، وبْحَاجَاتْ أُخْرَى كِيفْهَا قَاعْدِينْ تَعْمْلُوا فِيهَا». ");
INSERT INTO aeu_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","وعَيِّطْ يَسُوعْ لِلنَّاسْ مَرَّة أُخْرَى وقَالِلْهُمْ: «إِسْمْعُونِي الكُلْ وإِفْهْمُوا. ");
INSERT INTO aeu_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","مَا فَمَّة حَتَّى حَاجَة تُدْخِلْ لِبْدَنْ الإِنْسَانْ تْنَجِّمْ تْنَجْسُو، آمَا الِّي يُخْرِجْ مِالإِنْسَانْ، هُوَّ الِّي يْنَجْسُو. ");
INSERT INTO aeu_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ». ");
INSERT INTO aeu_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ووَقْتِلِّي خَلَّى النَّاسْ ودْخَلْ لِلدَّارْ، سِأْلُوهْ تْلَامِذْتُو عْلَى مَعْنَى المَثَلْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","قَالِلْهُمْ: «حَتَّى إِنْتُومَا زَادَا مَا تِفْهْمُوشْ؟ يَاخِي مَا تَعْرْفُوشْ الِّي حَتَّى شَيْ مِلِّي يُدْخِلْ لِبْدَنْ الإِنْسَانْ يْنَجِّمْ يْنَجْسُو، ");
INSERT INTO aeu_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","عْلَى خَاطِرْ مَا يُدْخُلْشْ لْقَلْبُو آمَا لْكِرْشُو ومْبَعِّدْ يُخْرُجْ مِنْ بْدَنُو؟». وهَكَّا عْلِنْ الِّي المَاكْلَة الكُلْ طَاهْرَة. ");
INSERT INTO aeu_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ومْبَعِّدْ قَالْ: «الحَاجَاتْ الِّي تُخْرُجْ مِالإِنْسَانْ هِيَّ الِّي تْنَجِّسْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","عْلَى خَاطِرْ مِنْ دَاخِلْ، مِنْ قْلُوبْ النَّاسْ تُخْرُجْ الأَفْكَارْ الخَايْبَة: الفْسَادْ والسِّرْقَة والقَتْلْ ");
INSERT INTO aeu_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","والزْنَى والطْمَعْ والخْبَاثَة والغَشَّة والحُسْدْ والإِنْحِرَافْ وتَشْوِيهْ السُّمْعَة والتَّكَبُّرْ والجَهْلْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","الحَاجَاتْ الخَايْبَة هَاذِي الكُلْ تُخْرُجْ مِنْ دَاخِلْ الإِنْسَانْ وهِيَّ الِّي تْنَجْسُو». ");
INSERT INTO aeu_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ومْبَعِّدْ خْرَجْ يَسُوعْ مِنْ غَادِي ومْشَى لْجِيهِةْ صُورْ. ودْخَلْ لْدَارْ ومَا حَبْ حَتَّى حَدْ يَعْرِفْ هُوَّ وِينْ، آمَا مَا نَجَّمْشْ يُقْعِدْ مِتْخُبِّي، ");
INSERT INTO aeu_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","وفَمَّة مْرَا بِنْتْهَا سَاكِنْهَا رُوحْ شِرِّيرْ، دُوبْ مَا سَمْعِتْ بِيهْ جَاتُو وتِرْمَاتْ قُدَّامْ سَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","واتْشَحْتِتُّو بَاشْ يْخَرِّجْ الرُّوحْ الشِّرِّيرْ مِنْ بِنْتْهَا، وكَانِتْ المْرَا هَاذِي أَصْلْهَا سُورِيَّة فِينِيقِيَّة مَعْنَاهَا مُشْ يْهُودِيَّة، ");
INSERT INTO aeu_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","هَاذَاكَا عْلَاشْ قَالِلْهَا: «خَلِّي الأَوْلَادْ يَشْبْعُوا فِي الأُوِّلْ! مَا يْجِيشْ نَاخْذُوا خُبْزْ الأَوْلَادْ ونَرْمِيوَهْ لِلْكْلَابْ». ");
INSERT INTO aeu_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","آمَا هِيَّ جَاوْبِتُّو وقَالِتْلُو: «يَا سِيدِي! حَتَّى الكْلَابْ تَاكِلْ تَحْتْ الطَّاوْلَة مِالفِتْفَاتْ الِّي يْطَيْحُوهْ الأَوْلَادْ». ");
INSERT INTO aeu_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","قَالِلْهَا: «عْلَى خَاطْرِكْ قُلْتْ الكِلْمَة هَاذِي إِمْشِي، رَاهُو الرُّوحْ الشِرِّيرْ خْرَجْ مِنْ بِنْتِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ووَقْتِلِّي رَجْعِتْ لْدَارْهَا، لْقَاتْ بِنْتْهَا فُوقْ الفَرْشْ، ولْقَاتْ الرُّوحْ الشِّرِّيرْ خْرَجْ مِنْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","وخْرَجْ يَسُوعْ مِنْ جِيهِةْ صُورْ وتْعَدَّى عْلَى صَيْدَا وعْلَى حُدُودْ بْلَاصَة اسْمْهَا العَشْرَة مُدُنْ ومْشَى لْبُحَيْرِةْ الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","وجَابُولُو وَاحِدْ أَطْرِشْ ومْلَكْوِنْ وتْشَحْتُوهْ بَاشْ يْحُطْ عْلِيهْ يْدِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","يَاخِي هَزُّو وَحْدُو بْعِيدْ عَالنَّاسْ وحَطْ صْوَابْعُو فِي وِذْنِينْ الرَّاجِلْ وبَعْدْ بْزِقْ ومَسْلُو لْسَانُو. ");
INSERT INTO aeu_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","وهَزْ عِينِيهْ لِلسْمَاء وتْنَهِّدْ وقَالُّو: «إِفَّاتَا!» مَعْنَاهَا «إِتْحَلْ» ");
INSERT INTO aeu_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","وبِالوَقْتْ تْحَلِّتْ وِذْنِيهْ ولْسَانُو تِطْلَقْ وبْدَا يْقُولْ فِي كْلَامْ وَاضَحْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ووَصَّاهُمْ يَسُوعْ بَاشْ مَا يَحْكِيوْ لْحَتَّى حَدْ. وكَانْ كُلْ مَا يْوَصِّيهُمْ أَكْثِرْ كُلْ مَا يُنْشْرُوا الخْبَرْ أَكْثِرْ. ");
INSERT INTO aeu_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","وكَانُوا بَاهْتِينْ فِيهْ وقَالُوا: «الحَاجَاتْ الِّي يَعْمِلْ فِيهَا الكُلْ عْظِيمَة، يْخَلِّي حَتَّى الطْرُشْ يِسْمْعُوا والبْكَاكِشْ يِتْكَلْمُوا». ");
INSERT INTO aeu_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","وفِي الوَقْتْ هَاذَاكَا، زَادُوا تْلَمُّوا بَرْشَة نَاسْ، ومَا كَانِشْ عَنْدْهُمْ مَا يَاكْلُوا. يَاخِي عَيِّطْ يَسُوعْ لِتْلَامِذْتُو وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«غَايْضِينِّي النَّاسْ عْلَى خَاطِرْ تَوَّا ثْلَاثَة أَيَّامْ وهُومَا مْعَايَا ومَاعَنْدْهُمْ مَا يَاكْلُوا. ");
INSERT INTO aeu_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","وإِذَا كَانْ نَبْعَثْهُمْ يْرَوْحُوا وهُومَا جْوَاعَى بِشْ يْدُوخُوا فِي الثْنِيَّة عْلَى خَاطِرْ فِيهُمْ الِّي جَاوْ مِنْ بْلَايِصْ بْعِيدَة». ");
INSERT INTO aeu_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","جَاوْبُوهْ تْلَامِذْتُو: «شْكُونْ يْنَجِّمْ يْشَبَّعْ النَّاسْ هَاذُومَا الكُلْ بِالخُبْزْ فِي بْلَاصَة خَالْيَة كِيمَا هَاذِي؟». ");
INSERT INTO aeu_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","يَاخِي سْإِلْهُمْ: «قَدَّاشْ عَنْدْكُمْ مِنْ خُبْزَة؟» جَاوْبُوهْ: «سَبْعَة». ");
INSERT INTO aeu_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","يَاخِي طْلَبْ مِالنَّاسْ بَاشْ يُقْعْدُوا فِي القَاعَة، وخْذَا السَّبْعَة خُبْزَاتْ وشْكَرْ اللَّهْ وقَسَّمْهُمْ وعْطَى لِتْلَامِذْتُو بَاشْ يْفَرْقُوا عَالنَّاسْ، وَلَّاوْ عَمْلُوا كِيمَا قَلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","وكَانْ عَنْدْهُمْ كَعْبَاتْ حُوتْ صْغَارْ بَارِكْهُمْ وطْلَبْ مِالتْلَامْذَة بَاشْ يْفَرْقُوهُمْ عَالنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","وكْلَاوْ النَّاسْ لِينْ شَبْعُوا. ومْبَعِّدْ هَزُّوا التْلَامْذَة سَبْعَة قْفَافْ مْعِبِّينْ بِالخُبْزْ الِّي فْضُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","والنَّاسْ الِّي كْلَاوْ كَانُوا قْرَابِةْ 4 000. ومْبَعِّدْ بْعَثْهُمْ يَسُوعْ رَوْحُوا، ");
INSERT INTO aeu_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","وبِالوَقْتْ طْلَعْ فِي الفْلُوكَة مْعَ تْلَامِذْتُو وجَاء لْجِيهِةْ دَلْمَانُوثَة. ");
INSERT INTO aeu_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","وجَاوْ الفِرِّيسِيِّينْ وبْدَاوْ يْنَاقْشُوا فِيهْ. وطَلْبُوا مِنُّو مُعْجْزَة مِالسْمَاء، بَاشْ يْجَرْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","تْنَهِّدْ مِنْ قَلْبُو وقَالِلْهُمْ: «عْلَاشْ الجِيلْ هَاذَا يُطْلُبْ فِي مُعْجْزَة؟ نْقُولِلْكُمْ الحَقْ الجِيلْ هَاذَا مُشْ بِشْ يَاخِذْ حَتَّى مُعْجْزَة!». ");
INSERT INTO aeu_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","وخَلَّاهُمْ ورْكِبْ فِي الفْلُوكَة ومْشَى لْشَطْ البُحَيْرَة المْقَابِلْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ونْسَاوْ التْلَامْذَة بَاشْ يْهِزُّوا مْعَاهُمْ خُبْزْ، ومَا كَانْ عَنْدْهُمْ فِي الفْلُوكَة كَانْ خُبْزَة وَحْدَة. ");
INSERT INTO aeu_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ووَصَّاهُمْ يَسُوعْ وقَالِلْهُمْ: «رُدُّوا بَالْكُمْ مِنْ خْمِيرِةْ الفِرِّيسِيِّينْ وخْمِيرِةْ هِيرُودُسْ». ");
INSERT INTO aeu_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","يَاخِي بْدَاوْ يِتْنَاقْشُوا بِينْ بْعَضْهُمْ ويْقُولُوا: «هَاذَا عْلَى خَاطِرْ مَا عَنْدْنَاشْ خُبْزْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","عْرَفْ يَسُوعْ وقَالِلْهُمْ: «شْبِيكُمْ تِتْنَاقْشُوا عَالخُبْزْ! يَاخِي مَزِّلْتُوا لْتَوَّا مَا تَعْرْفُوشْ ومَا تِفْهْمُوشْ؟ يَاخِي لْتَوَّا مَزَّالِتْ قْلُوبْكُمْ كَاسْحَة؟ ");
INSERT INTO aeu_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","عَنْدْكُمْ عِينِينْ ومَا تْشُوفُوشْ؟ وعَنْدْكُمْ وِذْنِينْ ومَا تِسْمْعُوشْ؟ يَاخِي مَا تِتْذَكْرُوشْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","وَقْتِلِّي قَسَّمْتْ الخَمْسَة خُبْزَاتْ عْلَى 5 000 رَاجِلْ، قَدَّاشْ هَزِّيتُوا مِنْ قُفَّة مْعِبْيَة بِالخُبْزْ؟» قَالُولُو: «أَثْنَاشْ!». ");
INSERT INTO aeu_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","«ووَقْتِلِّي قَسَّمْتْ السَّبْعَة خُبْزَاتْ عْلَى 4 000، قَدَّاشْ هَزِّيتُوا مِنْ قُفَّة مْعِبْيَة بِالخُبْزْ؟». قَالُوا: «سَبْعَة». ");
INSERT INTO aeu_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","قَالِلْهُمْ: «ولْتَوَّا مَزِّلْتُوا مَا فْهِمْتُوشْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ووُصْلُوا لْدَشْرِةْ بِيتْ صَيْدَا. وفَمَّة جْمَاعَة جَابُولُو وَاحِدْ أَعْمَى وطَلْبُوا مِنُّو بَاشْ يْحُطْ عْلِيهْ يِدُّو. ");
INSERT INTO aeu_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","شَدْ الأَعْمَى مِنْ يِدُّو وخَرْجُو مِالدَّشْرَة. وبَعْدْ حَطْلُو بْزَاقْ عْلَى عِينِيهْ، وحَطْ عْلِيهْ يْدِيهْ وسِأْلُو: «تْشُوفْ فِي حَاجَة؟». ");
INSERT INTO aeu_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","خْزَرْ وقَالْ: «نْشُوفْ فِي نَاسْ تْقُولْشْ عْلِيهُمْ شْجَرْ مَاشِينْ». ");
INSERT INTO aeu_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","حَطْ عْلِيهْ يِدُّو مَرَّة أُخْرَى، ووَقْتِلِّي حَلْ عِينِيهْ شَافْ كُلْ شَيْ وَاضِحْ ورْجَعْ لَابَاسْ . ");
INSERT INTO aeu_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","يَاخِي بَعْثُو يْرَوَّحْ لْدَارُو وقَالُّو: «مَا تُدْخُلْشْ لِلدَّشْرَة». ");
INSERT INTO aeu_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ومْشَى يَسُوعْ وتْلَامِذْتُو لِدْشُرْ قَيْصَرِيِّةْ فِيلِۑُّسْ، وفِي الطْرِيقْ سْإِلْهُمْ: « آنَا شْكُونْ حَسْبْ رَايْ العْبَادْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","جَاوْبُوهْ: «جْمَاعَة يْقُولُوا عْلِيكْ يُوحَنَّا الِّي يْعَمِّدْ، وجْمَاعَة يْقُولُوا الِّي إِنْتِ إِيلِيَّا، وفَمَّة شْكُونْ يْقُولْ الِّي إِنْتِ وَاحِدْ مِالأَنْبِيَاءْ». ");
INSERT INTO aeu_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","وسْإِلْهُمْ: «وحَسْبْ رَايْكُمْ إِنْتُومَا آنَا شْكُونْ؟». جَاوْبُو بُطْرُسْ: «إِنْتِ المَسِيحْ!». ");
INSERT INTO aeu_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","يَاخِي نَبَّهْ عْلِيهُمْ بَاشْ مَا يْقُولُوشْ عْلَى شْكُونُو هُوَّ لْحَتَّى حَدْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","وبْدَا يَسُوعْ يْعَلِّمْ فِيهُمْ الِّي إِبْنْ الإِنْسَانْ يِلْزْمُو يِتْعَذَّبْ بَرْشَة، ويُرْفْضُوهْ الشْيُوخْ وكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة، ويِتْقْتَلْ، وبَعْدْ ثْلَاثَة أَيَّامْ يْقُومْ . ");
INSERT INTO aeu_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","وكَانْ يَحْكِي عَالمَوْضُوعْ هَاذَا بْصَرَاحَة. جِبْدُو بُطْرُسْ عْلَى جْنَبْ وبْدَا يْلُومْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","آمَا هُوَّ تْلَفِّتْ لِتْلَامِذْتُو ونْزَرْ عْلَى بُطْرُسْ وقَالُّو: «إِبْعِدْ عْلِيَّا يَا إِبْلِيسْ، إِنْتِ تْفَكِّرْ كِيفْ النَّاسْ مُشْ كِيفْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","وعَيِّطْ لِلنَّاسْ ولِتْلَامِذْتُو وقَالِلْهُمْ: «إِذَا كَانْ وَاحِدْ يْحِبْ يْتَبَّعْنِي، لَازِمْ يُنْكُرْ رُوحُو، ويْشَارِكْنِي فِي العْذَابْ والمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","الِّي يْحِبْ يْمَنَّعْ حْيَاتُو يَخْسَرْهَا، ولِّي يَخْسَرْ حْيَاتُو عْلَى خَاطْرِي وعْلَى خَاطِرْ البْشَارَة يْنَجِّيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","شْنِيَّة الفَايْدَة كَانْ الإِنْسَانْ يِرْبَحْ العَالِمْ الكُلْ ويِخْسِرْ رُوحُو؟ ");
INSERT INTO aeu_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","وبِشْنُوَّة يْنَجِّمْ الإِنْسَانْ يِفْدِي رُوحُو؟ ");
INSERT INTO aeu_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","الِّي يِسْتْعَارْ بِيَّا وبِكْلَامِي فِي هَا الجِيلْ الفَاسِدْ والشِّرِيرْ، يِسْتْعَارْ بِيهْ إِبْنْ الإِنْسَانْ وَقْتِلِّي يِرْجَعْ فِي مَجْدْ بُوهْ مْعَ المْلَايْكَة القِدِّيسِينْ». ");
INSERT INTO aeu_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","وقَالِلْهُمْ يَسُوعْ: «نْقُلْكُمْ الحَقْ: فَمَّة شْكُونْ مِالوَاقْفِينْ هُونِي مَاهُمْشْ بِشْ يْذُوقُوا المُوتْ، إِلَّا بَعْدْمَا يْشُوفُوا مَمْلَكْةْ اللَّهْ تُظْهِرْ بْقُوَّة». ");
INSERT INTO aeu_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","وبَعْدْ سِتَّة أَيَّامْ، هَزْ يَسُوعْ بُطْرُسْ ويَعْقُوبْ ويُوحَنَّا، وطْلَعْ بِيهُمْ لِجْبَلْ عَالِي وَحَّدْهُمْ، وغَادِي تْبَدْلِتْ هَيْأْتُو قُدَّامْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ووَلَّاوْ حْوَايْجُو بْيُضْ يِلْمْعُوا كِيفْ الثِّلْجْ مَا يْنَجِّمْشْ حَتَّى صَبَّاغْ فِي الدِّنْيَا يِصْبَغْ لِبْسَة بِالأَبْيِضْ كِيفْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","وظُهْرُولْهُمْ إِيلِيَّا ومُوسَى، وكَانُوا يَحْكِيوْ مْعَ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","وقَالْ بُطْرُسْ لْيَسُوعْ: «يَا مُعَلِّمْ، مَحْلَاهَا القَعْدَة هُونِي، خَلِّينَا نُنْصْبُوا ثْلَاثَة خْيِمْ، وَحْدَة لِيكْ ووَحْدَة لْمُوسَى ووَحْدَة لْإِيلِيَّا!». ");
INSERT INTO aeu_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","وكَانْ مُشْ عَارِفْ شْنُوَّة قَاعِدْ يْقُولْ مِنْ كُثْرِةْ مَا كَانُوا خَايْفِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","وجَاتْ غِيمَة وغَطَّاتْهُمْ، وخْرَجْ صُوتْ مِالغِيمَة يْقُولْ: «هَاذَا هُوَّ إِبْنِي الِّي نْحِبُّو. إِسْمْعُوا كْلَامُو!». ");
INSERT INTO aeu_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","بِالوَقْتْ تْلَفْتُوا التْلَامْذَة، مَا لْقَاوْ حَتَّى حَدْ مْعَاهُمْ كَانْ يَسُوعْ وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ووَقْتِلِّي هُومَا هَابْطِينْ مِالجْبَلْ، وَصَّاهُمْ يَسُوعْ بَاشْ مَا يْقُولُوا لْحَتَّى حَدْ عَلِّي شَافُوهْ، إِلَّا بَعْدْمَا يْقُومْ إِبْنْ الإِنْسَانْ مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","عَمْلُوا بِلِّي وَصَّاهُمْ عْلِيهْ، آمَا قَعْدُوا يِسْأْلُوا فِي بْعَضْهُمْ: «آشْ مَعْنَاهَا يْقُومْ مِالمُوتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","يَاخِي سِأْلُوهْ: «عْلَاشْ يْقُولُوا عُلَمَاءْ الشَّرِيعَة الِّي لَازِمْ إِيلِيَّا يْجِي قْبَلْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","جَاوِبْهُمْ: «صْحِيحْ إِيلِيَّا يْجِي قْبَلْ ويْصَلَّحْ كُلْ شَيْ. آمَا زَادَا مَكْتُوبْ الِّي إِبْنْ الإِنْسَانْ لَازْمُو يِتْعَذَّبْ بَرْشَة ويِتْهَانْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","وآنَا نْقُلْكُمْ: رَاهُو إِيلِيَّا جَاء وعَمْلُوا فِيهْ الِّي حَبُّوا، كِيفْ مَا قَالِتْ عْلِيهْ الكْتُبْ المُقَدْسَة». ");
INSERT INTO aeu_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ووَقْتِلِّي وُصْلُوا لْبْقِيِّةْ التْلَامْذَة، شَافُوا بَرْشَة نَاسْ دَايْرِينْ بِيهُمْ وعُلَمَاءْ الشَّرِيعَة يْنَاقْشُوا فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ودُوبْ مَا النَّاسْ شَافُوا يَسُوعْ، تْعَجْبُوا وجْرَاوْلُو بَاشْ يْسَلْمُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","يَاخِي سْإِلْهُمْ: «فِي شْنُوَّة تْنَاقْشُوا فِيهُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","جَاوْبُو وَاحِدْ مِنْهُمْ: «يَا مُعَلِّمْ جِبْتْلِكْ وِلْدِي، سَاكْنُو رُوحْ شِرِّيرْ رَدُّو بَكُّوشْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","كُلْ مَا الرُّوحْ يْشِدُّو يِتْصْرَعْ، يْخَرِّجْ الكْشَاكِشْ مِنْ فُمُّو ويْعَظْ عْلَى سِنِّيهْ ويِيبِسْ. طْلَبْتْ مِنْ تْلَامِذْتِكْ يْخَرْجُوهْ مِنُّو، يَاخِي مَا نَجْمُوشْ». ");
INSERT INTO aeu_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","قَالِلْهُمْ: «إِنْتُومَا جِيلْ مُشْ مُؤْمِنْ! قَدَّاشْ بِشْ نُقْعْدِلْكُمْ؟ لْوَقْتَاشْ بِشْ نُصْبِرْ عْلِيكُمْ؟ جِيبُوهُولِي!». ");
INSERT INTO aeu_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","جَابُوهُولُو. ودُوبْ مَا الرُّوحْ شَافْ يَسُوعْ، صْرَعْ الطْفُلْ وخَلَّاهْ يِتْصَكِّكْ فِي القَاعَة، وكْشَاكْشُو خَارْجَة مِنْ فُمُّو. ");
INSERT INTO aeu_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","يَاخِي يَسُوعْ سْإِلْ بُوهْ: «مِنْ وَقْتَاشْ وهُوَّ هَكَّا؟» جَاوْبُو: «مِلِّي هُوَّ صْغِيرْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","وبَرْشَة مَرَّاتْ الرُّوحْ يِرْمِيهْ فِي النَّارْ وفِي المَاء يْحِبْ يُقْتْلُو. آمَا كَانْ إِنْتِ تْنَجِّمْ تَعْمِلْ حَاجَة، حِنْ عْلِينَا وعَاوِنَّا!». ");
INSERT INTO aeu_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","قَالُّو يَسُوعْ: « عْلَاشْ تْقُولْ \"كَانْ تْنَجِّمْ\"؟ رَاهُو كُلْ شَيْ مُمْكِنْ عَنْدْ الِّي يَمِّنْ!». ");
INSERT INTO aeu_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","وبِالوَقْتْ صَاحْ بُو الطْفُلْ: «آنَا نَمِّنْ! عَاوِنِّي إِنْتِ وقَوِّي إِيمَانِي الضْعِيفْ!». ");
INSERT INTO aeu_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ووَقْتِلِّي شَافْ يَسُوعْ النَّاسْ يِتْجَارَاوْ بَاشْ يِتْلَمُّوا بِيهْ، نْزَرْ عَالرُّوحْ الشِرِّيرْ وقَالُّو: «يَا رُوحْ، يَلِّي رَدِّيتْ الطْفُلْ هَاذَا بَكُّوشْ وأَطْرِشْ، نُأْمْرِكْ بَاشْ تُخْرُجْ مِنُّو ومَا عَادِشْ تِرْجَعْلُو بِالكُلْ!». ");
INSERT INTO aeu_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","صَاحْ الرُّوحْ وخَلَّى الطْفُلْ يِتْصَكِّكْ بِالقْوِيْ، وخْرَجْ مِنُّو. ووَلَّى الطْفُلْ كَايِنُّو مِيِّتْ، بِالعْمَلْ بَرْشَة نَاسْ قَالُوا الِّي هُوَّ مَاتْ بِالحَقْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","آمَا وَقْتِلِّي شَدُّو يَسُوعْ مِنْ يِدُّو وقَيْمُو، قَامْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","وبَعْدْمَا دْخَلْ يَسُوعْ لِلدَّارْ، سِأْلُوهْ تْلَامِذْتُو وهُومَا وَحَّدْهُمْ: «عْلَاشْ أَحْنَا مَا نَجَّمْنَاشْ نْخَرْجُوا الرُّوحْ الشِرِّيرْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","جَاوِبْهُمْ: «النَّوْعْ هَاذَا مَا يُخْرِجْ كَانْ بِالصَّلَاةْ والصْيَامْ». ");
INSERT INTO aeu_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","خَرْجُوا مِنْ غَادِي وتْعَدَّاوْ عْلَى مَنْطَقْةْ الجَلِيلْ. ومَا حَبِّشْ يَسُوعْ يِسْمَعْ بِيهْ حَتَّى وَاحِدْ، ");
INSERT INTO aeu_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","عْلَى خَاطِرْ كَانْ يْعَلِّمْ فِي تْلَامِذْتُو ويْقُولِلْهُمْ: «إِبْنْ الإِنْسَانْ بِشْ يْسَلْمُوهْ فِي يْدِينْ النَّاسْ، وبِشْ يُقْتْلُوهْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ». ");
INSERT INTO aeu_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","آمَا هُومَا مَا فِهْمُوشْ كْلَامُو وخَافُوا بَاشْ يِسْأْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ومْبَعِّدْ جَاء يَسُوعْ لْكَفْرْنَاحُومْ. ووَقْتِلِّي هُوَّ فِي الدَّارْ سْإِلْ تْلَامِذْتُو: «فَاشْ كُنْتُوا تَحْكِيوْ فِي الطْرِيقْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","يَاخِي سِكْتُوا، عْلَى خَاطِرْهُمْ كَانُوا يِتْنَاقْشُوا فِي شْكُونْ فِيهُمْ أَعْظِمْ مِالآخِرْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","قْعَدْ وعَيِّطْ لِلْأَثْنَاشِنْ تِلْمِيذْ وقَالِلْهُمْ: «إِذَا وَاحِدْ يْحِبْ يْكُونْ أُوِّلْ النَّاسْ، لَازْمُو يْوَلِّي آخِرْهُمْ ويِخْدِمْهُمْ الكُلْ!». ");
INSERT INTO aeu_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","وجَابْ طْفُلْ صْغِيرْ ووَقْفُو فِي وِسْطْهُمْ، وعَنْقُو، وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«الِّي يِقْبِلْ وْلَيِّدْ مِالأَوْلَادْ الصْغَارْ هَاذُمْ عْلَى خَاطْرِي، يِقْبِلْنِي آنَا. ومُشْ يِقْبِلْنِي آنَا أَكَهَوْ، آمَا يِقْبِلْ زَادَا الِّي بْعَثْنِي». ");
INSERT INTO aeu_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","قَالُّو يُوحَنَّا: «يَا مُعَلِّمْ، شُفْنَا وَاحِدْ يْخَرِّجْ فِي الشْوَاطِنْ بْإِسْمِكْ، يَاخِي مْنَعْنَاهْ، عْلَى خَاطْرُو مُشْ تَابَعْنَا». ");
INSERT INTO aeu_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","آمَا يَسُوعْ قَالْ: «مَا تَمْنْعُوهِشْ! عْلَى خَاطِرْ مَا فَمَّة حَتَّى وَاحِدْ يَعْمِلْ مُعْجْزَة بْإِسْمِي، وبَعْدْهَا فِيسَعْ يِتْكَلِّمْ عْلِيَّا بِالخَايِبْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","الِّي مُشْ ضِدْنَا هُوَّ مْعَانَا. ");
INSERT INTO aeu_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ونْقُلْكُمْ الحَقْ الِّي يَعْطِيكُمْ كَاسْ مَاء، عْلَى خَاطِرْكُمْ تَابْعِينْ لِلْمَسِيحْ، أَجْرُو مَا يْضِيعِشْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","«الِّي يْكُونْ سْبَبْ فِي إِنُّو وَاحِدْ مِالصْغَارْ المُؤْمْنِينْ بِيَّا يُغْلُطْ، خِيرْلُو كَانْ يْعَلَّقْ حْجَرْ الرْحَى فِي رَقْبْتُو ويَرْمِي رُوحُو فِي البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","وكَانْ يِدِّكْ تْخَلِّيكْ تُغْلِطْ قُصْهَا. خِيرْلِكْ تُدْخِلْ لِلْحْيَاةْ الأَبَدِيَّة ويِدِّكْ مَقْصُوصَة، مِلِّي تُدْخِلْ بِيدِيكْ الإِثْنِينْ لِجْهَنِّمْ، لْنَارْ مَا تِطْفَاشْ، ");
INSERT INTO aeu_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","وِينْ دُودْهُمْ مَا يْمُوتِشْ والنَّارْ مَا تَطْفَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","وكَانْ سَاقِكْ تْخَلِّيكْ تُغْلِطْ قُصْهَا، خِيرْلِكْ تُدْخِلْ لِلْحْيَاةْ الأَبَدِيَّة وسَاقِكْ مَقْصُوصَة مِلِّي تُدْخِلْ بْسَاقِيكْ الزُّوزْ لِجْهَنِّمْ، ");
INSERT INTO aeu_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","وِينْ دُودْهُمْ مَا يْمُوتِشْ والنَّارْ مَا تِطْفَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","وكَانْ عِينِكْ تْخَلِّيكْ تُغْلِطْ قَلَّعْهَا، خِيرْلِكْ تُدْخِلْ لِلْحْيَاةْ الأَبَدِيَّة بْعِينْ وَحْدَة، مِنْ أَنِّكْ تُدْخِلْ بْعِينِيكْ الزُّوزْ لِجْهَنِّمْ، ");
INSERT INTO aeu_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","وِينْ دُودْهُمْ مَا يْمُوتِشْ والنَّارْ مَا تِطْفَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","كُلْ وَاحِدْ بِشْ يِتْمَلَّحْ بِالنَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","«المِلْحْ بَاهِي. آمَا إِذَا كَانْ المِلْحْ مَا عَادِشْ فِيهْ مَطْعِمْ، كِيفَاشْ نْرَجْعُولُو مَطْعْمُو؟ خَلِّيكُمْ كِي المِلْحْ، وعِيشُوا فِي سَلَامْ مْعَ بْعَضْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ومْشَى يَسُوعْ مِنْ غَادِي وجَاء لْمَنْطَقْةْ اليَهُودِيَّة، لِلجِّيهَة الأُخْرَى مِنْ وَادْ الأُرْدُنْ، وتْلَمُّوا بِيهْ النَّاسْ مَرَّة أُخْرَى، وبْدَا يْعَلِّمْ فِيهُمْ كِالْعَادَة. ");
INSERT INTO aeu_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","وجَاوِهْ جْمَاعَة فِرِّيسِيِّينْ وسَأْلُوهْ بَاشْ يْجَرْبُوهْ: «يَاخِي حْلَالْ الرَّاجِلْ يْطَلَّقْ مَرْتُو؟». ");
INSERT INTO aeu_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","جَاوِبْهُمْ: «آشْ وَصَّاكُمْ مُوسَى؟». ");
INSERT INTO aeu_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","قَالُوا: «مُوسَى سْمَحْ لِلرَّاجِلْ بَاشْ يِكْتِبْ وَرْقِةْ طْلَاقْ لْمَرْتُو، ويْطَلَّقْهَا». ");
INSERT INTO aeu_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","قَالِلْهُمْ يَسُوعْ: « مُوسَى كْتِبِّلْكُمْ الوْصِيَّة هَاذِي مِنْ كْسُوحِيِّةْ قْلُوبْكُمْ . ");
INSERT INTO aeu_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","آمَا مِلِّي تْخَلْقِتْ الدِّنْيَا، اللَّهْ خْلَقْ الإِنْسَانْ ذْكَرْ وأَنْثَى. ");
INSERT INTO aeu_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","وهَاذَاكَا عْلَاشْ الرَّاجِلْ يْخَلِّي بُوهْ وأُمُّو ويِتْرْبَطْ بْمَرْتُو، ");
INSERT INTO aeu_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ويْوَلِّيوْ الإِثْنِينْ بْدَنْ وَاحِدْ. مَا عَادِشْ زُوزْ آمَا بْدَنْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","عْلَى خَاطِرْ الِّي يَجْمْعُو اللَّهْ مَا يْفَرْقُوشْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","وَقْتِلِّي رَجْعُوا لِلدَّارْ، عَاوْدُوا تْلَامِذْتُو جِبْدُولُو نَفْسْ المَوْضُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","قَالِلْهُمْ: «الِّي يْطَلَّقْ مَرْتُو ويْعَرِّسْ بِمْرَا أُخْرَى، يَزْنَى عْلِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","وإِذَا كَانْ المْرَا طَلْقِتْ رَاجِلْهَا وعَرّْسِتْ بْرَاجِلْ آخِرْ، تَزْنَى!». ");
INSERT INTO aeu_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","وجَاوْ نَاسْ وجَابُولُو صْغَارْ بَاشْ يْحُطْ عْلِيهُمْ يِدُّو ويْبَارِكْهُمْ. يَاخِي التْلَامْذَة لَامُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ووَقْتِلِّي شَافْهُمْ يَسُوعْ تْغَشِّشْ وقَالِلْهُمْ: «خَلِّيوْ الصْغَارْ يْجِيوْنِي، ومَا تَمْنْعُوهُمْشْ، عْلَى خَاطِرْ مَمْلَكْةْ اللَّهْ يُدْخْلُولْهَا النَّاسْ الِّي كِيفْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","نْقُولِلْكُمْ الحَقْ:الِّي مَا يِقْبِلْشْ مَمْلَكْةْ اللَّهْ كِيمَا الطْفُلْ الصْغِيرْ، عُمْرُو مَا يُدْخْلِلْهَا!». ");
INSERT INTO aeu_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","وعَنَّقْهُمْ وحَطْ عْلِيهُمْ يْدِيهْ وبَارِكْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","وكِي خْرَجْ يَسُوعْ، جَاهْ رَاجِلْ يِجْرِي وسْجِدْلُو وسِأْلُو: «يَا مُعَلِّمْ يَا صَالَحْ آشْ نَعْمِلْ بَاشْ نُورِثْ الحَيَاةْ الأَبَدِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","آمَا يَسُوعْ قَالُّو: «عْلَاشْ تْعَيَّطْلِي يَا صَالَحْ؟ مَا فَمَّة حَتَّى وَاحِدْ صَالَحْ كَانْ اللَّهْ وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","إِنْتِ تَعْرِفْ الوْصَايَا: \"مَا تَعْمِلْشْ جْرِيمِةْ قَتْلْ، مَا تَزْنَاشْ، مَا تِسْرَقْشْ، مَا تِشْهِدْشْ بِالكِذْبْ، مَا تْغُشِّشْ، إِكْرِمْ بُوكْ وأُمُّكْ!\"». ");
INSERT INTO aeu_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","قَالُّو: «يَا مُعَلِّمْ، الوْصَايَا هَاذُمْ نَعْمِلْ فِيهُمْ مِنْ صُغْرِي». ");
INSERT INTO aeu_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","يَاخِي يَسُوعْ خْزَرْلُو بِمْحَبَة وقَالُّو: «مَزَّالِتْ نَاقْصِتِّكْ حَاجَة وَحْدَة، بِيعْ الِّي عَنْدِكْ الكُلْ وفَرْقُو عَالفْقَارَى، وهَكَّا يْوَلِّي عَنْدِكْ كِنْزْ فِي السْمَاء ومْبَعِّدْ إِيجَا تَبَّعْنِي». ");
INSERT INTO aeu_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","آمَا هُوَّ كِي سْمَعْ الكْلَامْ هَاذَا مْشَى حْزِينْ ومَهْمُومْ عْلَى خَاطْرُو كَانْ صَاحِبْ ثَرْوَة كْبِيرَة. ");
INSERT INTO aeu_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","تْلَفِّتْ يَسُوعْ وقَالْ لِتْلَامِذْتُو: «مَصْعِبْ دْخُولْ الغْنِيِّينْ لْمَمْلَكْةْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","تْعَجْبُوا التْلَامْذَة مِنْ كْلَامُو. وعَاوِدْ يَسُوعْ قَالِلْهُمْ مَرَّة أُخْرَى: «يَا وْلَادِي، مَصْعِبْ دْخُولْ النَّاسْ الِّي تِتْوَكِّلْ عْلَى فْلُوسْهَا لْمَمْلَكْةْ اللَّهْ! ");
INSERT INTO aeu_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","دْخُولْ الجْمَلْ مِنْ نُقْبِةْ الإِبْرَة أَسْهِلْ مِنْ دْخُولْ الغْنِيْ لْمَمْلَكْةْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","التْلَامْذَة تْصَدْمُوا، وقَالُوا لِبْعَضْهُمْ: «مَالَا شْكُونْ يْنَجِّمْ يِنْجَى؟» . ");
INSERT INTO aeu_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","خْزَرِّلْهُمْ يَسُوعْ وقَالِلْهُمْ: «هَاذَا مُسْتَحِيلْ عَنْدْ النَّاسْ آمَا مُشْ مُسْتَحِيلْ عَنْدْ اللَّهْ، عْلَى خَاطِرْ عَنْدْ اللَّهْ كُلْ شَيْ مُمْكِنْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","قَلُّو بُطْرُسْ: «إِنْتِ تَعْرِفْ الِّي أَحْنَا خَلِّينَا كُلْ شَيْ وتَبَّعْنَاكْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","جَاوْبُو يَسُوعْ: «نْقُلْكُمْ الحَقْ: كُلْ مِنْ خَلَّا دَارْ وَلَّا إِخْوَة وَلَّا خْوَاتْ وَلَّا أُمْ وَلَّا بُو وَلَّا وْلَادْ وَلَّا أَرْضْ عْلَى خَاطْرِي وعْلَى خَاطِرْ البْشَارَة، ");
INSERT INTO aeu_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","بِشْ يَاخُذْ قَدْهُمْ 100 مَرَّة دْيَارْ وإِخْوَة وخْوَاتْ وأُمَّاتْ ووْلَادْ وأَرَاضِي فِي الزْمَانْ هَاذَا مْعَ الإِضْطِهَادْ زَادَا، ويَاخِذْ الحَيَاةْ الأَبَدِيَّة فِي الزْمَانْ الجَّايْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","وفَمَّة بَرْشَة نَاسْ كَانُوا الأُوْلَانِينْ بِشْ يْوَلِّيوْ الإِخْرَانِينْ، ونَاسْ كَانُوا الإِخْرَانِينْ بِشْ يْوَلِّيوْ الأُوْلَانِينْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","وكَانُوا فِي الطْرِيقْ طَالْعِينْ لْأُورْشَلِيمْ، ويَسُوعْ يِمْشِي قُدَّامْهُمْ. وكَانُوا التْلَامْذَة مِتْحَيْرِينْ والنَّاسْ الِّي يْتَبْعُوا فِيهْ خَايْفِينْ. جْبِدْ التْلَامْذَة الأَثْنَاشْ عْلَى جْنَبْ، وبْدَا يَحْكِيلْهُمْ عَلِّي بِشْ يْصِيرْلُو وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","«هَانَا طَالْعِينْ لْأُورْشَلِيمْ، وِينْ بِشْ يْسَلْمُوا إِبْنْ الإِنْسَانْ لِكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة. وهُومَا بِشْ يُحْكْمُوا عْلِيهْ بِالمُوتْ ويْسَلْمُوهْ لِيدِينْ حُكَّامْ مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","وبِشْ يْهِينُوهْ ويِبْزْقُوا عْلِيهْ، ويِجْلْدُوهْ، ويُقْتْلُوهْ. وفِي النْهَارْ الثَّالِثْ يْقُومْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","مْبَعِّدْ، جَاوِهْ يَعْقُوبْ ويُوحَنَّا وْلَادْ زَبَدِي وقَالُولُو: «يَا مُعَلِّمْ، نْحِبُّوكْ تَعْمِلْ الِّي نُطْلْبُوهْ مِنِّكْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","سْأَلْهُمْ: «شْنُوَّة تْحِبُّونِي نَعَمْلِلْكُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","قَالُولُو: «وَقْتِلِّي تْكُونْ فِي مَجْدِكْ، خَلِّينَا نُقْعْدُوا وَاحِدْ عْلَى يْمِينِكْ، ووَاحِدْ عْلَى يْسَارِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","قَالِلْهُمْ يَسُوعْ: «إِنْتُومَا مُشْ عَارْفِينْ آشْ قَاعْدِينْ تُطْلْبُوا: تْنَجْمُوا تُشْرْبُوا الكَاسْ الِّي بِشْ نُشْرُبُو آنَا، وَلَّا تْقَاسِيوْ العْذَابْ الِّي بِشْ نِتْعَذْبُو آنَا؟». ");
INSERT INTO aeu_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","قَالُولُو: «انَّجْمُوا». جَاوِبْهُمْ يَسُوعْ: «الكَاسْ الِّي بِشْ نُشْرْبُو آنَا بِشْ تُشْرْبُوهْ، والعْذَابْ الِّي بِشْ نِتْعَذْبُو آنَا بِشْ تِتْعَذْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","آمَا القَعْدَة عْلَى يْمِينِي وعْلَى يْسَارِي مَا انَّجِّمْ نَعْطِيهَا كَانْ لِلِّي حَضَّرْهَالْهُمْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ووَقْتِلِّي سَمْعُوا العَشْرَة تْلَامْذَة الأُخْرِينْ الكْلَامْ هَاذَا، تْغَشْشُوا عْلَى يَعْقُوبْ ويُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","آمَا يَسُوعْ عَيْطِلْهُمْ وقَالِلْهُمْ: «تَعْرْفُوا الِّي حُكَّامْ الشُّعُوبْ يْسَيْطْرُوا عْلِيهُمْ، ولِّي عَنْدْهُمْ السُّلْطَة يِتْسَلْطُوا عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","وهَاذَا مَا يِلْزْمُوشْ يْكُونْ بِينَاتْكُمْ، آمَا الِّي يْحِبْ يْكُونْ فِيكُمْ عْظِيمْ، لَازِمْ يْكُونْ لِيكُمْ خْدِيمْ، ");
INSERT INTO aeu_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ولِّي يْحِبْ يْوَلِّي الأُوِّلْ فِيكُمْ، لَازْمُو يْكُونْ عَبْدْ لِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ مَا جَاشْ بَاشْ النَّاسْ يِخْدْمُوهْ، آمَا بَاشْ يِخْدِمْهُمْ ويِفْدِي بِحْيَاتُو بَرْشَة مِنْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ومْبَعِّدْ وُصْلُوا لْأَرِيحَا. ووَقْتِلِّي كَانْ خَارِجْ مِالمْدِينَة ومْعَاهْ تْلَامِذْتُو وبَرْشَة نَاسْ أُخْرِينْ، كَانْ بَارْتِيمَاوُسْ الأَعْمَى وِلْدْ تِيمَاوُسْ قَاعِدْ عْلَى جْنَبْ الطْرِيقْ يُطْلُبْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","وَقْتِلِّي سْمَعْ الِّي المِتْعِدِّي هُوَّ يَسُوعْ النَّاصِرِي، بْدَا يْعَيِّطْ : «يَا يَسُوعْ وِلْدْ دَاوِدْ، أَرْحَمْنِي!». ");
INSERT INTO aeu_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","وصَاحُوا عْلِيهْ بَرْشَة نَاسْ بَاشْ يُسْكُتْ، آمَا هُوَّ وَلَّى يْعَيِّطْ أَكْثِرْ: «يَا وِلْدْ دَاوِدْ، ارْحَمْنِي!». ");
INSERT INTO aeu_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","يَاخِي وْقِفْ يَسُوعْ وقَالْ: «عَيْطُولُو!». وعَيْطُوا لِلْأَعْمَى وقَالُولُو: «اتْشَجَّعْ، وقُومْ! أَهَوْكَا يْعَيِّطْلِكْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","وَلَّى رْمَى بَرْنُوسُو وقَامْ ومْشَى لْيَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","وسِأْلُو يَسُوعْ: «شْنُوَّة تْحِبْنِي نَعْمِلِّكْ؟». قَالُّو الأَعْمَى: «يَا مُعَلِّمْ، نْحِبْ نْشُوفْ!». ");
INSERT INTO aeu_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","يَاخِي قَالُّو يَسُوعْ: «إِمْشِي! إِيمَانِكْ شْفَاكْ». وبِالوَقْتْ رْجَعْلُو نَظْرُو ووَلَّى يْتَبَّعْ فِي يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","وَقْتِلِّي قُرْبُوا مِنْ أُورْشَلِيمْ، ووُصْلُوا لْدَشْرِةْ بِيتْ فَاجِي ودَشْرِةْ بِيتْ عَنْيَا، بَحْذَا جْبَلْ الزِّيتُونْ، بْعَثْ يَسُوعْ زُوزْ مِنْ تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","وقَالِلْهُمْ: «إِمْشِيوْ لِلدَّشْرَة لِمْقَابْلِتْكُمْ، ودُوبْ مَا تُدْخْلُولْهَا بِشْ تَلْقَاوْ جَحْشْ مَرْبُوطْ عُمْرُو مَا رْكِبْ عْلِيهْ حَتَّى حَدْ. حِلُّولُو الرْبَاطْ وجِيبُوهُولِي لَهْنَا. ");
INSERT INTO aeu_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","وإِذَا وَاحِدْ سْإِلْكُمْ: \"عْلَاشْ تَعْمْلُوا هَكَّا؟\" قُولُوا: \"سِيدْنَا حَاشْتُو بِيهْ وتَوْ فِيسَعْ يْرَجْعُو\"». ");
INSERT INTO aeu_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ومْشَاوْ، ولْقَاوْ الجَّحْشْ مَرْبُوطْ فِي بَابْ، يَاخِي حَلُّولُو الرْبَاطْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","وفَمَّة جْمَاعَة كَانُوا وَاقْفِينْ غَادِي قَالُولْهُمْ: «آشْ تَعْمْلُوا؟ عْلَاشْ تْسَيْبُوا فِي الجَّحْشْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","وجَاوْبُوا كِيفْ مَا وَصَّاهُمْ يَسُوعْ، يَاخِي خَلَّاوْهُمْ يِمْشِيوْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","وجَابُوا الجَّحْشْ لْيَسُوعْ، وحَطُّوا عْلِيهْ حْوَايِجْهُمْ. يَاخِي رْكِبْ فُوقُو. ");
INSERT INTO aeu_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","وبَرْشَة نَاسْ فِرْشُوا حْوَايِجْهُمْ عَالطْرِيقْ، ونَاسْ أُخْرِينْ فِرْشُوا أَعْرَافْ قَصُّوهَا مِالأَشْجَارْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","وكَانُوا الِّي مَاشِينْ قُدَّامُو ولِّي وْرَاهْ يْعَيْطُوا: «أُوصَنَّا! مُبَارَكْ الِّي جَايْ بْإِسْمْ الرَّبْ! ");
INSERT INTO aeu_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","مُبَارْكَة مَمْلَكْةْ بُونَا دَاوِدْ الِّي جَايَة! المَجْدْ لِلَّهْ فِي السْمَاء!». ");
INSERT INTO aeu_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ودْخَلْ يَسُوعْ لْأُورْشَلِيمْ، ومْشَى لِلْهَيْكِلْ، وقْعَدْ يْرَاقِبْ فِلِّي قَاعِدْ صَايِرْ فِيهْ الكُلْ. وكَانْ الوَقْتْ إِمَّخِّرْ، يَاخِي مْشَى لْبِيتْ عَنْيَا هُوَّ والتْلَامْذَة الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ومِنْ غُدْوَة، كِي خَرْجُوا مِنْ بِيتْ عَنْيَا، حَسْ بِالجُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","وشَافْ مِنْ بْعِيدْ كَرْمَة فِيهَا بَرْشَة أَوْرَاقْ، يَاخِي مْشَالْهَا فَمَّاشْ مَا يَلْقَى فِيهَا كَرْمُوسْ. وَقْتِلِّي وْصِلِّلْهَا مَا لْقَى فِيهَا كَانْ الأَوْرَاقْ، عْلَى خَاطِرْ وَقْتْ الكَرْمُوسْ مَزَّالْ مَا جَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","يَاخِي قَالِلْهَا: «مِنْ تَوَّا مَا عَادْ يَاكِلْ مِنْ غَلْتِكْ حَتَّى وَاحِدْ لِلْأَبَدْ!». وكَانُوا تْلَامِذْتُو يِسْمْعُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ووُصْلُوا لْأُورْشَلِيمْ، وكِي دْخَلْ يَسُوعْ لِلْهَيْكِلْ بْدَا يْطَرِّدْ فِلِّي كَانُوا يْبِيعُوا ويِشْرِيوْ غَادِي، وقْلِبْ طْوَاوِلْ النَّاسْ الِّي يْصَرْفُوا فِي الفْلُوسْ وكْرَاسِي الِّي يْبِيعُوا فِي الحْمَامْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ومَا خَلَّا حَتَّى وَاحِدْ هَازِزْ سِلْعَة يُدْخُلْ لِلْهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","وبْدَا يْعَلِّمْ فِيهُمْ ويْقُولْ: «يَاخِي مُشْ مَكْتُوبْ: \"دَارِي بِشْ تِتْسَمَّى دَارْ صْلَاةْ لِلشُّعُوبْ الكُلْ\"؟ آمَا إِنْتُومَا رَدِّيتُوهَا مْغَارِةْ سُرَّاقْ!». ");
INSERT INTO aeu_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","وسَمْعُوا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة الكْلَامْ هَاذَا، ومِنْ خُوفْهُمْ مِنُّو، بْدَاوْ يْلَوْجُوا كِيفَاشْ يُقْتْلُوهْ، عْلَى خَاطِرْ النَّاسْ الكُلْ كَانُوا مَبْهُورِينْ بْتَعْلِيمُو. ");
INSERT INTO aeu_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","وَقْتِلِّي جَاء اللِّيلْ، خَرَجْ يَسُوعْ وتْلَامِذْتُو مِالمْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","وهُومَا رَاجْعِينْ فِي الصْبَاحْ، شَافُوا الكَرْمَة يَابْسَة بْكُلْهَا حَتَّى لِلْعْرُوقْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","وتْذَكِّرْ بُطْرُسْ الِّي صَارْ وقَالُّو: «يَا مُعَلِّمْ، شُوفْ! الكَرْمَة الِّي لْعَنْتْهَا يِبْسِتْ!». ");
INSERT INTO aeu_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","يَاخِي قَالِلْهُمْ: «خَلِّي عَنْدْكُمْ إِيمَانْ بِاللَّهْ! ");
INSERT INTO aeu_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","نْقُلْكُمْ الحَقْ، الِّي يْقُولْ لِلجْبَلْ هَاذَا: \"إِتْقَلَّعْ واتْرْمَى فِي البْحَرْ!\" ومَا يْشُكِّشْ فِي قَلْبُو آمَا يَمِّنْ إِنُّو الِّي يْقُولُو بِشْ يْصِيرْ، رَاهُو يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","هَاذَاكَا عْلَاشْ نْقُولِلْكُمْ: الِّي تُطْلْبُوهْ فِي صْلَاتْكُمْ، أَمْنُوا الِّي إِنْتُومَا خْذِيتُوهْ، تَوْ تَاخْذُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ووَقْتِلِّي تَاقْفُوا بَاشْ تْصَلِّيوْ، إِغْفْرُوا لِلِّي غْلُطْ فِي حَقْكُمْ، بَاشْ بُوكُمْ الِّي فِي السْمَاء يِغْفْرِلْكُمْ أَغْلَاطْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","آمَا كَانْ مَا تِغْفْرُوشْ لِلْأُخْرِينْ، بُوكُمْ الِّي فِي السْمَاء زَادَا مَا يِغْفْرِلْكُمْشْ أَغْلَاطْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ورَجْعُوا لْأُورْشَلِيمْ مَرَّة أُخْرَى. ووَقْتِلِّي يَسُوعْ كَانْ يِمْشِي فِي الهَيْكِلْ، جَاوَهْ كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة والشْيُوخْ، ");
INSERT INTO aeu_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","وسِأْلُوهْ: «بْآنَا سُلْطَة تَعْمِلْ فِي الحَاجَاتْ هَاذِي؟ وشْكُونْ عْطَاكْ السُّلْطَة بَاشْ تَعْمِلْهَا؟». ");
INSERT INTO aeu_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","جَاوِبْهُمْ يَسُوعْ : «وآنَا زَادَا نِسْإِلْكُمْ سُؤَالْ وَاحِدْ، وإِذَا تْجَاوْبُونِي، نْقُلْكُمْ بْآنَا سُلْطَة نَعْمِلْ فِي الحَاجَاتْ هَاذِي: ");
INSERT INTO aeu_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","شْكُونْ عْطَى السُّلْطَة لْيُوحَنَّا بَاشْ يْعَمِّدْ؟ اللَّهْ وَلَّا النَّاسْ؟ جَاوْبُونِي!». ");
INSERT INTO aeu_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","تْشَاوْرُوا مَا بِينَاتْهُمْ وقَالُوا: «إِذَا قُلْنَا: \"مِنْ عَنْدْ اللَّهْ\" يْقُولْ: \"مَالَا عْلَاشْ مَا أَمَّنْتُوشْ بِلِّي جَاء بِيهْ؟\". ");
INSERT INTO aeu_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","زَعْمَة نْقُولُوا: \"مِنْ عَنْدْ النَّاسْ\"؟». آمَا كَانُوا خَايْفِينْ مِالشَّعْبْ، عْلَى خَاطْرُو كَانْ يَعْتَبِرْ يُوحَنَّا نَبِيْ بِالحَقْ. ");
INSERT INTO aeu_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","يَاخِي جَاوْبُوهْ: «مَا نَعْرْفُوشْ». قَالِلْهُمْ يَسُوعْ: «حَتَّى آنَا مَا نْقُلْكُمْشْ بْآنَا سُلْطَة نَعْمِلْ فِي الحَاجَاتْ هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","وبْدَا يَسُوعْ يْكَلِّمْ فِيهُمْ بِالأَمْثَالْ، وقَالْ: «فَمَّة وَاحِدْ زْرَعْ سَانْيَة عْنِبْ ودَوِّرْ بِيهَا سُورْ، وبْنَى فِيهَا مَعْصْرَة، وبُرْجْ، وكْرَاهَا لْفَلَّاحَة وسَافِرْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","وكِي طَابْ العْنِبْ، بْعَثْ وَاحِدْ مِنْ خَدَّامْتُو لِلْفَلَّاحَة بَاشْ يَاخِذْ بَايُو مِالصَّابَة. ");
INSERT INTO aeu_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","يَاخِي شَدُّوهْ وضَرْبُوهْ ورَجْعُوهْ يْدِيهْ فَارْغَة. ");
INSERT INTO aeu_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","عَاوِدْ بْعَثِّلْهُمْ وَاحِدْ آخِرْ. يَاخِي ضَرْبُوهْ عْلَى رَاسُو وهَانُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","وَلَّى بْعَثْ وَاحِدْ آخِرْ، يَاخِي قَتْلُوهْ. وزَادْ بْعَثْ بَرْشَة غِيرْهُمْ، يَاخِي جِلْدُوا جْمَاعَة وقَتْلُوا جْمَاعَة أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ومَا قْعَدْ لِلرَّاجِلْ كَانْ وِلْدُو الِّي يْحِبُّو بَرْشَة، وَلَّى فِي الإِخِّرْ بْعَثْهُولْهُمْ وقَالْ: \"تَوْ يْقَدْرُوا وِلْدِي!\". ");
INSERT INTO aeu_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","آمَا الفَلَّاحَة قَالُوا لِبْعَضْهُمْ: \"أَهَوَّا الوْرِيثْ، هَيَّا نُقْتْلُوهْ ونَاخْذُوا أَحْنَا الوَرْثَة!\". ");
INSERT INTO aeu_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","يَاخِي شَدُّوهْ وقَتْلُوهْ ورْمَاوَهْ لْبَرَّة مِالسَّانْيَة. ");
INSERT INTO aeu_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","آشْ بِشْ يَعْمِلْ مُولَى السَّانْيَة؟ يْجِي ويُقْتِلْ الفَلَّاحَة ويَعْطِي السَّانْيَة لْنَاسْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","يَاخِي مَا قْرِيتُوشْ الآيَة المَكْتُوبَة: \"الحَجْرَة الِّي رَفْضُوهَا البَنَّايَا، وَلَّاتْ حَجْرِةْ السَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","هَاذَا آشْ عْمَلْ الرَّبْ، وهَاذِي حَاجَة عْجِيبَة بِالنِّسْبَة لِينَا!\"». ");
INSERT INTO aeu_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","وحَبُّوا يْشِدُّوهْ، خَاطِرْهُمْ فِهْمُوا الِّي هُوَّ كَانْ يُقْصِدْ فِيهُمْ هُومَا بِالمَثَلْ هَاذَا. آمَا خَافُوا مِالنَّاسْ، يَاخِي خَلَّاوَهْ ومْشَاوْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","وبَعْثُولُو جْمَاعَة مِالفِرِّيسِيِّينْ وجْمَاعَة تَابْعِينْ هِيرُودُسْ، بَاشْ يْحَصْلُوهْ بْكِلْمَة يْقُولْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","وَقْتِّلِي جَاوُوهْ قَالُولُو: «يَا مُعَلِّمْ، أَحْنَا نَعْرْفُوا الِّي إِنْتِ صَرِيحْ، ومَا تْخَافْ مِنْ حَدْ. عْلَى خَاطْرِكْ مَا تَعْمَلْشْ حْسَابْ لِمْقَامَاتْ النَّاسْ، وتْعَلِّمْ طْرِيقْ اللَّهْ بِالحَقْ. يَاخِي حْلَالْ نَدْفْعُوا الضَّرَايِبْ لِلْقَيْصِرْ وَلَّا لَا؟ نَدْفْعُوا وَلَّا مَا نَدْفْعُوشْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","يَاخِي هُوَّ فَاقْ بْنِفَاقْهُمْ وقَالِلْهُمْ: «عْلَاشْ تْجَرْبُوا فِيَّا؟ جِيبُولِي دِينَارْ خَلِّينِي نْشُوفُو!». ");
INSERT INTO aeu_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","جَابُولُو دِينَارْ، يَاخِي سْإِلْهُمْ: «مْتَاعْ شْكُونْ التَّصْوِيرَة هَاذِي، وإِسْمْ شْكُونْ هَاذَا؟» قَالُولُو: «مْتَاعْ القَيْصِرْ». ");
INSERT INTO aeu_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","قَالِلْهُمْ يَسُوعْ: «أَعْطِيوْ الِّي يْخُصْ القَيْصِرْ لِلْقَيْصِرْ، ولِّي يْخُصْ اللَّهْ لِلَّهْ!». وقَعْدُوا الكُلْهُمْ بَاهْتِينْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","وجَاوِهْ جْمَاعَة مِالصَّدُّوقِيِّينْ الِّي يْقُولُوا مَا فَمَّاشْ قْيَامَة بَعْدْ المُوتْ، وسِأْلُوهْ: ");
INSERT INTO aeu_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«يَا مُعَلِّمْ، مُوسَى كْتِبِّلْنَا: إِذَا كَانْ وَاحِدْ خُوهْ مَاتْ وخَلَّى مَرْتُو مِنْ بَعْدُو مِنْ غِيرْ مَا يْجِيبْ صْغَارْ، يِلْزِمْ خُوهْ يْعَرِّسْ بِيهَا ويْجِيبْ صْغَارْ ويْقَيِّدْهُمْ بْإِسْمْ خُوهْ الِّي مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","«وكَانْ فَمَّة سَبْعَة أَخْوَة، عَرِّسْ الأُوِّلْ بِمْرَا ومَاتْ مِنْ غِيرْ مَا يْجِيبْ صْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","وعَرِّسْ بِيهَا الثَّانِي ومَاتْ هُوَّ زَادَا مِنْ غِيرْ مَا يْجِيبْ صْغَارْ وكِيفْ كِيفْ الثَّالِثْ . ");
INSERT INTO aeu_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","وهَكَّا عَرْسُوا بِيهَا السَّبْعَة ومَاتُوا مِنْ غِيرْ مَا جَابُوا صْغَارْ. وبَعْدْهُمْ الكُلْ، مَاتِتْ المْرَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","مَالَا فِي يُومْ القْيَامَة، وَقْتِلِّي يْقُومُوا مِالمُوتْ، بِشْ تْكُونْ مَرْتْ شْكُونْ فِيهُمْ؟ هَايْ عَرْسِتْ بِيهُمْ السَّبْعَة؟». ");
INSERT INTO aeu_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","جَاوِبْهُمْ يَسُوعْ: «إِنْتُومَا غَالْطِينْ، عْلَى خَاطِرْكُمْ مَا تِفِهْمُوشْ لَا الكْتُبْ المُقَدْسَة ولَا قُوِّةْ اللَّهْ! ");
INSERT INTO aeu_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","بَعْدْ القْيَامَة النَّاسْ لَا يْعَرْسُوا ولَا يْعَرْسُولْهُمْ، آمَا يْكُونُوا كِيفْ المْلَايْكَة الِّي فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","آمَا كَانْكُمْ عْلَى قْيَامِةْ المُوتَى، يَاخِي مَا قْرِيتُوشْ فِي التَّوْرَاةْ حْكَايِةْ شَجْرِةْ العُلِّيقَة، كِيفَاشْ اللَّهْ كَلَّمْ مُوسَى وقَالُّو: \"آنَا إِلَاهْ إِبْرَاهِيمْ وإِلَاهْ إِسْحَاقْ وإِلَاهْ يَعْقُوبْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","مَالَا هُوَّ مُشْ إِلَاهْ المُوتَى، آمَا إِلَاهْ الحَيِّينْ. إِنْتُومَا رَاكُمْ غَالْطِينْ بَرْشَة!». ");
INSERT INTO aeu_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","وسْمَعْهُمْ وَاحِدْ مِنْ عُلَمَاءْ الشَّرِيعَة يِتْنَاقْشُوا، وعِجْبُو كِيفَاشْ يَسُوعْ جَاوِبْهُمْ. يَاخِي سِأْلُو: «آنَاهِي أَهَمْ وْصِيَّة فِي الوْصَايَا الكُلْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","جَاوْبُو يَسُوعْ: «أَهَمْ وْصِيَّة هِيَّ: \"إِسْمْعُوا يَا بَنِي إِسْرَائِيلْ، الرَّبْ إِلَاهْنَا هُوَّ رَبْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","حِبْ الرَّبْ إِلَاهِكْ بْكُلْ قَلْبِكْ وبْكُلْ رُوحِكْ وبْكُلْ عَقْلِكْ وبْكُلْ قُوْتِكْ\". ");
INSERT INTO aeu_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","والثَّانْيَة هِيَّ: \"حِبْ قْرِيبِكْ كِيفْ مَا تْحِبْ رُوحِكْ\". مَا فَمَّاشْ وْصِيَّة أُخْرَى أَعْظِمْ مِنْ هَاذُومَا الإِثْنِينْ». ");
INSERT INTO aeu_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","وقَالُّو العَالِمْ فِي الشَّرِيعَة: «صْحِيحْ يَا مُعَلِّمْ! قُلْتْ الحَقْ. خَاطِرْ اللَّهْ وَاحِدْ ومَا فَمَّاشْ غِيرُو. ");
INSERT INTO aeu_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","وإِنُّو الوَاحِدْ يْحِبُّو بْكُلْ قَلْبُو وبْكُلْ عَقْلُو وبْكُلْ قُوْتُو، ويْحِبْ قْرِيبُو كِيفْ مَا يْحِبْ رُوحُو، هَاذُومَا أَحْسِنْ مِنْ كُلْ الذْبَايَحْ والقَرَابِينْ الِّي تِتْحْرَقْ». ");
INSERT INTO aeu_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","وكِي شَافْ يَسُوعْ الِّي هُوَّ جَاوِبْ بْحِكْمَة قَالُّو: «مَاكِشْ بْعِيدْ عْلَى مَمْلَكْةْ اللَّهْ!». وحَتَّى حَدْ مَا تْجَرَّأْ يْزِيدْ يِسْأْلُو. ");
INSERT INTO aeu_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","وَقْتِلِّي كَانْ يَسُوعْ يْعَلِّمْ فِي الهَيْكِلْ، قَالْ: «عْلَاشْ عُلَمَاءْ الشَّرِيعَة يْقُولُوا الِّي المَسِيحْ هُوَّ وِلْدْ دَاوِدْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ودَاوِدْ بِيدُو قَالْ بِالرُّوحْ القُدُسْ: \"قَالْ اللَّهْ لْرَبِّي: أُقْعُدْ عْلَى يْمِينِي، حَتَّى لِينْ نْحُطْ أَعْدَائِكْ تَحْتْ سَاقِيكْ\". ");
INSERT INTO aeu_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","«إِذَا كَانْ دَاوِدْ نَفْسُو يَعْيِّطْ لِلْمَسِيحْ رَبْ، مَالَا كِيفَاشْ يْكُونْ وِلْدُو؟». وكَانُوا بَرْشَة نَاسْ يِسْمْعُوا فِيهْ وفَرْحَانِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","وكِي كَانْ يْعَلِّمْ قَالِلْهُمْ: «رُدُّوا بَالْكُمْ مِنْ عُلَمَاءْ الشَّرِيعَة، الِّي يْحِبُّوا يْدُورُوا بِاللِّبْسَة الطْوِيلَة، ويْحِبُّوا النَّاسْ تْسَلِّمْ عْلِيهُمْ فِي الأَسْوَاقْ، ");
INSERT INTO aeu_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ويْحِبُّوا يُقْعْدُوا فِي الصَّفْ الأُوِّلْ فِي المَعَابِدْ وفِي المْحَافِلْ، ");
INSERT INTO aeu_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","وهُومَا يِسِرْقُوا فِي فْلُوسْ الهَجَّالَاتْ، ويْطَوْلُوا فِي الصْلَاةْ بَاشْ النَّاسْ تْرَاهُمْ. هَاذُوكُمْ بِشْ يِتْحَاسْبُوا أَكْثِرْ مِالنَّاسْ الأُخْرِينْ!». ");
INSERT INTO aeu_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","وقْعَدْ يَسُوعْ مْقَابِلْ صَنْدُوقْ التَّبَرُّعَاتْ الِّي فِي الهَيْكِلْ، وبْدَا يْشُوفْ فِي النَّاسْ كِيفَاشْ يْحُطُّوا فِي الفْلُوسْ. وبَرْشَة غْنِيِّينْ حَطُّوا بَرْشَة فْلُوسْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ومْبَعِّدْ جَاتْ مْرَا هَجَّالَة وفْقِيرَة وحَطِّتْ زُوزْ فْرَنْكْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","يَاخِي عَيِّطْ لِتْلَامِذْتُو وقَالِلْهُمْ: «نْقُلْكُمْ الحَقْ: المْرَا الهَجَّالَة الفْقِيرَة هَاذِي، حَطِّتْ فِي الصَّنْدُوقْ أَكْثِرْ مِلِّي حَطُّوهْ النَّاسْ الأُخْرِينْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","الكُلْهُمْ عْطَاوْ مِلِّي فَاضِلْ عْلِيهُمْ، آمَا هِيَّ رَغْمِلِّي مِحْتَاجَة، حَطِّتْ الِّي عَنْدْهَا الكُلْ. حَطِّتْ الفْلُوسْ الِّي تْعِيشْ بِيهُمْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","وهُوَّ خَارِجْ مِالهَيْكِلْ، قَالُّو وَاحِدْ مِنْ تْلَامِذْتُو: «يَا مُعَلِّمْ، شُوفْ مَلَّا حْجَرْ ومَلَّا بَنِيْ!». ");
INSERT INTO aeu_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","جَاوْبُو يَسُوعْ: «شُفْتْ البَنِيْ العْظِيمْ هَاذَا؟ لَا حَجْرَة مِنُّو بِشْ تِبْقَى فُوقْ أُخْتْهَا، الكُلُّو بِشْ يْطِيحْ». ");
INSERT INTO aeu_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ووَقْتِلِّي يَسُوعْ كَانْ قَاعِدْ فِي جْبَلْ الزِّيتُونْ مْقَابِلْ الهَيْكِلْ، سِأْلُوهْ بُطْرُسْ ويَعْقُوبْ ويُوحَنَّا وأَنْدَرَاوُسْ وَقْتِلِّي وَحَّدْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«قُولِلْنَا: وَقْتَاشْ بِشْ يْصِيرْ هَاذَا؟ وكِي يُقْرُبْ الوَقْتْ، شْنِيَّة الأَمَارَة الِّي نَجْمُوا نَعْرْفُوهْ بِيهَا؟». ");
INSERT INTO aeu_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","جَاوِبْهُمْ يَسُوعْ: «رُدُّوا بَالْكُمْ لَا وَاحِدْ يْغَلَّطْكُمْ! ");
INSERT INTO aeu_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","بِشْ يْجِيوْ بَرْشَة بْإِسْمِي ويْقُولُوا: \"آنَا هُوَّ المَسِيحْ!\" ويْغَلْطُوا بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","آمَا، وَقْتِلِّي تِسْمْعُوا بِالحْرُوبَاتْ وأَخْبَارْ الحْرُوبَاتْ مَا تْخَافُوشْ، خَاطِرْ هَاذَا لَازْمُو يْصِيرْ، آمَا هَاذِي مُشْ النِّهَايَة. ");
INSERT INTO aeu_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","بِشْ تِتْقْلِبْ أُمَّة عْلَى أُمَّة، ومَمْلْكَة عْلَى مَمْلْكَة، وبِشْ تْصِيرْ زْلَازِلْ فِي بَرْشَة بْلَايِصْ، وبَرْشَة مَجَاعَاتْ، آمَا هَاذِي مَاهِي إِلَّا بِدَايِةْ المْوَاجَعْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","«مَالَا رُدُّوا بَالْكُمْ، عْلَى خَاطِرْ بِشْ يْسَلْمُوكُمْ لِلْمْحَاكِمْ وبِشْ تِتْضَرْبُوا فِي المْعَابِدْ، وتَاقْفُوا قُدَّامْ حُكَّامْ ومُلُوكْ عْلَى خَاطْرِي، بَاشْ تِشْهْدُولِي. ");
INSERT INTO aeu_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","آمَا قْبَلْ كُلْ شَيْ لَازِمْ تُوصِلْ البْشَارَة لِلشْعُوبْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ووَقْتِلِّي يْشِدُّوكُمْ بَاشْ يْسَلْمُوكُمْ لِلْمْحَاكِمْ، مَا تُقُعْدُوشْ تْخَمُّوا آشْ بِشْ تْقُولُوا، آمَا قُولُوا الكْلَامْ الِّي يْجِيكُمْ وَقْتْهَا، عْلَى خَاطِرْ مَاكُمْشْ إِنْتُومَا الِّي تِتْكَلْمُوا آمَا الرُّوحْ القُدُسْ هُوَّ الِّي يِتْكَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","والخُو بِشْ يْسَلِّمْ خُوهْ لِلْمُوتْ، والبُو يْسَلِّمْ وِلْدُو، والوْلَادْ يْدُورُوا عْلَى وَالْدِيهُمْ ويْكُونُوا سْبَبْ فِي قَتْلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","وبِشْ يِكْرْهُوكُمْ النَّاسْ الكُلْ عْلَى خَاطِرْ إِسْمِي. آمَا الِّي يِثْبِتْ لِلِّخِّرْ، يِنْجَى». ");
INSERT INTO aeu_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«ووَقْتِلِّي تْشُوفُوا \"النْجَاسَة الِّي تْخَرِّبْ\" مَوْجُودَة فِي البْلَاصَة الِّي مَا يِلْزِمْشْ تْكُونْ فِيهَا — خَلِّي القَارِي يِفْهِمْ — وَقْتْهَا الِّي فِي مَنْطَقْةْ اليَهُودِيَّة يُهْرْبُوا لِلجْبَالْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ولِّي فُوقْ السْطَحْ مَا يَهْبِطْشْ لْدَارُو ومَا يُدْخُلْشْ يْهِزْ مِنْهَا حَاجَة. ");
INSERT INTO aeu_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ولِّي كَانْ فِي السَّانْيَة، مَا يِرْجَعْشْ يْهِزْ حْوَايْجُو. ");
INSERT INTO aeu_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ويَا وِيلْ النْسَاء الحْبَالَى ولِّي يْرَضْعُوا فِي الأَيَّامَاتْ هَاذُوكُمْ! ");
INSERT INTO aeu_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","صَلِّيوْ بَاشْ مَا يْصِيرِشْ هَاذَا فِي الشْتَاء. ");
INSERT INTO aeu_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","وبِشْ يْصِيرْ فِي الأَيَّامَاتْ هَاذُوكُمْ ضِيقْ كْبِيرْ، مَا صَارِشْ كِيفُو مِلِّي خْلَقْ اللَّهْ الدِّنْيَا لْتَوَّا، ومُشْ بِشْ يِتْعَاوِدْ بِالكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ولَوْ كَانْ مُشْ الرَّبْ قَصِّرْ الأَيَّامَاتْ هَاذُوكُمْ، رَاوْ مَا نَجِّمْ حَتَّى حَدْ يِنْجَى. آمَا هُوَّ قَصَّرْهُمْ عْلَى خَاطِرْ النَّاسْ الِّي اخْتَارْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","«إِذَا قَالِلْكُمْ وَاحِدْ وَقْتْهَا: \"هَاوْ المَسِيحْ هُونِي!\" وَلَّا \"أَهَوْكَا غَادِي\"، مَا تْصَدْقُوهِشْ! ");
INSERT INTO aeu_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","خَاطِرْ بِشْ يُظْهْرُوا أَكْثِرْ مِنْ مَسِيحْ دَجَّالْ وبَرْشَة أَنْبِيَاءْ كَذَّابِينْ، وبِشْ يَعْمْلُوا مُعْجْزَاتْ وعْجَايِبْ يْحَاوْلُوا يْغَلْطُوا بِيهُمْ حَتَّى النَّاسْ الِّي اخْتَارْهُمْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","رُدُّوا بَالْكُمْ. هَانِي قُلْتِلْكُمْ كُلْ شَيْ قْبَلْ مَا يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","«آمَا فِي الأَيَّامَاتْ هَاذُوكُمْ، بَعْدْ الضِّيقْ، بِشْ تِظْلَامْ الشَّمْسْ ويِتْحْجِبْ ضَوْء الڨَمْرَة، ");
INSERT INTO aeu_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ونْجُومْ السْمَاء بِشْ اطِّيحْ، وتِتْزَعْزَعْ كُلْ قُوَّة فِي السْمَاوَاتْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","وَقْتْهَا النَّاسْ بِشْ يْشُوفُوا إِبْنْ الإِنْسَانْ جَايْ فِي السْحَابْ بْقُوَّة عْظِيمَة ومَجْدْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","وفِي الوَقْتْ هَاذَاكَا يَبْعَثْ مْلَايِكْتُو بَاشْ يْلِمُّوا النَّاسْ الِّي إِخْتَارْهُمْ مِالشَّرْقْ والغَرْبْ والشَّمَالْ والجَنُوبْ، مِنْ طَرْفْ لْحَرْفْ الدِّنْيَا». ");
INSERT INTO aeu_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","«خُوذُوا العِبْرَة مِالكَرْمَة: دُوبْ مَا أَعْرَافْهَا تِخْضَارْ واطَّلَّعْ الأَوْرَاقْ، تَعْرْفُوا الِّي الصِّيفْ قْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","وإِنْتُومَا زَادَا نَفْسْ الشَّيْ، كِي تْشُوفُوا الحَاجَاتْ هَاذِي قَاعْدَة تْصِيرْ، أَعْرْفُوا الِّي الوَقْتْ قْرُبْ وعَالأَبْوَابْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","نْقُلْكُمْ الحَقْ: الحَاجَاتْ هَاذِي الكُلْ بِشْ تْصِيرْ قْبَلْ مَا يْمُوتْ الجِيلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","السْمَاء والأَرْضْ يِفْنَاوْ، آمَا كْلَامِي عُمْرُو مَا يِفْنَى. ");
INSERT INTO aeu_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","«آمَا النْهَارْ هَاذَاكَا والسَّاعَة هَاذِيكَا مَا يَعْرَفْهُمْ حَتَّى حَدْ، لَا المْلَايْكَة الِّي فِي السْمَاء، ولَا الإِبْنْ، مَا يَعْرِفْهُمْ كَانْ الآبْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","رُدُّوا بَالْكُمْ وفِيقُوا عْلَى خَاطِرْكُمْ مَا تَعْرْفُوشْ وَقْتَاشْ يْجِي الوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","وبِشْ يْكُونْ هَاذَا كِيمَا إِنْسَانْ خَلَّى دَارُو وسَافِرْ لِبْعِيدْ، وعْطَى المَسْؤُولِيَّة لْخَدَّامْتُو بَاشْ يِتْصَرِّفْ كُلْ وَاحِدْ فِي خِدْمْتُو، ووَصَّى العَسَّاسْ بَاشْ يْكُونْ فَايِقْ ويْرُدْ بَالُو. ");
INSERT INTO aeu_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","مَالَا أَسْهْرُوا، خَاطِرْكُمْ مَا تَعْرْفُوشْ وَقْتَاشْ مُولَى الدَّارْ يِرْجَعْ، فِي العْشِيَّة امَّخَّرْ وَلَّا فِي نُصْ اللِّيلْ، وَلَّا الفَجْرْ، وَلَّا فِي الصْبَاحْ، ");
INSERT INTO aeu_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","بَاشْ مَا يْجِيشْ عْلَى غَفْلَة ويَلْقَاكُمْ رَاقْدِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ولِّي نْقُولْهُولْكُمْ، نْقُولُو لِلنَّاسْ الكُلْ: أَسْهْرُوا!» ");
INSERT INTO aeu_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","قْبَلْ عِيدْ الفِصْحْ اليْهُودِي وعِيدْ الفْطِيرْ بِنْهَارِينْ، كَانُوا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة يِتْحَيْلُوا كِيفَاشْ يْشِدُّوا يَسُوعْ ويُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","آمَا كَانُوا يْقُولُوا: «الأَحْسَنْ مَا نَعْمْلُوشْ هَاذَا فِي العِيدْ، بَاشْ مَا يْهِيجِشْ الشَّعْبْ!». ");
INSERT INTO aeu_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","وَقْتِلِّي كَانْ يَسُوعْ فِي بِيتْ عَنْيَا، مِتَّكِي فِي دَارْ سِمْعَانْ الأَبْرِصْ، جَاتْ مْرَا هَازَّة دَبُّوزَة عِطْرْ النَّارْدِينْ الصَّافِي والغَالِي، وكَسْرِتْهَا وصَبِّتْلُو العِطْرْ عْلَى رَاسُو. ");
INSERT INTO aeu_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","وفَمَّة نَاسْ مِالحَاضْرِينْ تْغَشْشُوا وقَالُوا: «عْلَاشْ هَكَّا تَبْذِيرْ العِطْرْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","كَانْ يْنَجِّمْ يِتْبَاعْ بْأَكْثِرْ مِنْ شَهْرِيِّةْ عَامْ كَامِلْ، والفْلُوسْ يَاخْذُوهَا الفْقَارَى». وبْدَاوْ يْلُومُوا فِي المْرَا. ");
INSERT INTO aeu_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","آمَا يَسُوعْ قَالْ: «أَخْطَاوْهَا! عْلَاشْ تْقَلْقُوا فِيهَا؟ رَاهِي عَمْلِتْلِي حَاجَة بَاهْيَة. ");
INSERT INTO aeu_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","الفْقَارَى دِيمَا مْعَاكُمْ، وتْنَجْمُوا تَعْمْلُوا مْعَاهُمْ الخِيرْ وَقْتِلِّي تْحِبُّوا. آمَا آنَا مَانِيشْ بِشْ نْكُونْ مْعَاكُمْ دِيمَا. ");
INSERT INTO aeu_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","هِيَّ عَمْلِتْ الِّي تَقْدِرْ عْلِيهْ. وغَسّْلِتْ بَدْنِي بِالمْسَبَّقْ وحَضْرِتُّو لِلدْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","نْقُلْكُمْ الحَقْ: وِينْ مَا تِتْنْشَرْ البْشَارَة فِي العَالِمْ الكُلْ، بِشْ يَحْكِيوْ النَّاسْ عَلِّي عَمْلِتُّو المْرَا هَاذِي، ويُقْعْدُوا دِيمَا يِتْفَكْرُوهَا!». ");
INSERT INTO aeu_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ومْشَى يَهُوذَا الإِسْخَرْيُوطِي، الِّي هُوَّ وَاحِدْ مِالأَثْنَاشْ، لِكْبَارْ الكَهَنَة بَاشْ يْسَلْمِلْهُمْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ووَقْتِلِّي سَمْعُوا، فَرْحُوا ووِعْدُوهْ بَاشْ يَعْطِيوِهْ فْلُوسْ، وقْعَدْ يِسْتَنَّى فِي فُرْصَة بَاهْيَة بَاشْ يْسَلْمُو. ");
INSERT INTO aeu_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","وفِي النْهَارْ الأُوِّلْ فِي عِيدْ الفْطِيرْ الِّي كَانُوا يِذْبْحُوا فِيهْ عَلُّوشْ الفِصْحْ سِأْلُوا التْلَامْذَة يَسُوعْ: «وِينْ تْحِبْنَا نِمْشِيوْ ونْحَضْرُولِكْ عْشَاء الفِصْحْ بَاشْ تَاكْلُو؟». ");
INSERT INTO aeu_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","وبْعَثْ زُوزْ مِنْ تْلَامِذْتُو وقَالِلْهُمْ: «إِمْشِيوْ لِلْمْدِينَة وتَوْ تَلْقَاوْ رَاجِلْ هَازْ قُلَّة مَاء تَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","والدَّارْ الِّي يُدْخْلِلْهَا قُولُوا لْمُولَاهَا: \"المُعَلِّمْ يْقُولْ: وِينِي البِيتْ الِّي بِشْ نَاكِلْ فِيهَا عْشَاء الفِصْحْ مْعَ تْلَامِذْتِي؟\". ");
INSERT INTO aeu_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","وهُوَّ بَاشْ يْوَرِّيكُمْ بِيتْ كْبِيرَة فِي الطَّاقْ الفُوقَانِي، مَفْرُوشَة وحَاضْرَة، حَضّْرُولْنَا العْشَاء غَادِي!». ");
INSERT INTO aeu_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","مْشَاوْ التْلَامْذَة ودَخْلُوا لِلْمْدِينَة، ولْقَاوْ كُلْ شَيْ كِيفْ مَا قَالِلْهُمْ عْلِيهْ. وغَادِي حَضّْرُوا عْشَاء الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","وفِي العْشِيَّة جَاء يَسُوعْ هُوَّ والتْلَامْذَة الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","وَقْتِلِّي كَانُوا قَاعْدِينْ يَاكْلُوا، قَالْ يَسُوعْ: «نْقُلْكُمْ الحَقْ: وَاحِدْ مِنْكُمْ بِشْ يْخُونِّي وهُوَّ تَوَّا قَاعِدْ يَاكِلْ مْعَايَا». ");
INSERT INTO aeu_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","حِزْنُوا التْلَامْذَة، وبْدَاوْ يِسْأْلُوا فِيهْ بِالوَاحِدْ: «يَاخِي آنَا الِّي بِشْ نْخُونِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","وقَالِلْهُمْ: «هُوَّ وَاحِدْ مِالأَثْنَاشْ وهُوَّ الِّي قَاعِدْ يَاكِلْ مْعَايَا تَوَّا مِنْ نَفْسْ الصْحَنْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","إِبْنْ الإِنْسَانْ لَازْمُو يْمُوتْ كِيمَا مَكْتُوبْ عْلِيهْ فِي الكْتُبْ المُقَدْسَة، آمَا يَا وِيلُو الرَّاجِلْ الِّي بِشْ يْسَلْمُو. خِيرْلُو لَوْ كَانْ مَا تُولِدْشْ!». ");
INSERT INTO aeu_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ووَقْتِلِّي كَانُوا يَاكْلُوا خْذَا يَسُوعْ خُبْزَة وشْكَرْ اللَّهْ، وقْسِمْ وعْطَى لِتْلَامِذْتُو وقَالْ: «خُوذُوا، هَاذَا هُوَّ بَدْنِي». ");
INSERT INTO aeu_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ومْبَعِّدْ خْذَا كَاسْ وشْكَرْ اللَّهْ، وعْطَاهُمْ شَرْبُوا مِنُّو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","وقَالِلْهُمْ: «هَاذَا هُوَّ دَمِّي الِّي يَعْمِلْ بِيهْ اللَّهْ عَهْدْ جْدِيدْ، ولِّي بِشْ يْسِيلْ عْلَى خَاطِرْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","نْقُلْكُمْ الحَقْ: مَا عَادِشْ بِشْ نُشْرُبْ مِنْ عَصِيرْ العْنِبْ، حَتَّى لِلنْهَارْ الِّي نُشْرُبْ فِيهْ عَصِيرْ جْدِيدْ فِي مَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ومْبَعِّدْ سَبْحُوا اللَّهْ بِالتَّرْنِيمْ، ومْشَاوْ لِجْبَلْ الزِّيتُونْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","قَالِلْهُمْ يَسُوعْ: «الكُلْكُمْ بِشْ تْخَلِّيوْنِي، خَاطِرْ مَكْتُوبْ: \"نَضْرِبْ السَّارِحْ، تِتْفَرِّقْ الغْنَمْ\". ");
INSERT INTO aeu_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","«آمَا بَعْدْمَا نْقُومْ مِالمُوتْ، بِشْ نِسْبَقْكُمْ لِلْجَلِيلْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","يَاخِي قَالُّو بُطْرُسْ: «حَتَّى لَوْ كَانْ مْشَاوْ عْلِيكْ الكُلْ، آنَا عُمْرِي مَا نْخَلِّيكْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","قَالُّو يَسُوعْ: «نْقُلِّكْ الحَقْ: اليُومْ، فِي اللِّيلَة هَاذِي، قْبَلْ مَا يْصِيحْ السَّرْدُوكْ مَرْتِينْ تُنْكُرْنِي ثْلَاثَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","آمَا بُطْرُسْ شَدْ صْحِيحْ وقَالْ: «مَانِيشْ بِشْ نُنْكْرِكْ بِالكُلْ، حَتَّى كَانْ لْزِمْ نْمُوتْ مْعَاكْ!». والتْلَامْذَة الكُلْ قَالُوا نَفْسْ الكْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ومْشَاوْ لِبْلَاصَة إِسْمْهَا جَثْسَيْمَانِي، وقَالْ يَسُوعْ لِتْلَامِذْتُو: «أُقْعْدُوا هُونِي مَادَامْ آنَا صَلِّيتْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","وهَزْ مْعَاهْ بُطْرُسْ ويَعْقُوبْ ويُوحَنَّا، وبْدَا يْحِسْ بِالرَّهْبَة والحُزْنْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","وقَالِلْهُمْ: «رُوحِي حْزِينَة بَرْشَة، لْدَرْجِةْ المُوتْ. أُقْعْدُوا هُونِي وأَسْهْرُوا». ");
INSERT INTO aeu_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","وبْعِدْ عْلِيهُمْ شْوَيَّة، وهْبَطْ عَالأَرْضْ وبْدَا يْصَلِّي بَاشْ مَا يِتْعَدَّاشْ بِالسَّاعَة هَاذِيكَا، إِذَا كَانْ مُمْكِنْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","وقَالْ: «بَابَا! يَا بَابَا! إِنْتِ قَادِرْ عْلَى كُلْ شَيْ، بَعِّدْ عْلِيَّا هَا الكَاسْ. آمَا خَلِّي يْصِيرْ الِّي تْحِبْ عْلِيهْ إِنْتِ، مُشْ الِّي نْحِبْ عْلِيهْ آنَا!». ");
INSERT INTO aeu_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","وكِي رْجَعْ لْقَاهُمْ رَاقْدِينْ، وقَالْ لْبُطْرُسْ: «يَا سِمْعَانْ! رَاقِدْ؟ مَا نَجَّمْتِشْ تَسْهِرْ حَتَّى سَاعَة وَحْدَة؟ ");
INSERT INTO aeu_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","أَسْهْرُوا وصَلِّيوْ بَاشْ مَا تُدْخْلُوشْ فِي تَجْرْبَة. رَاهِي الرُّوحْ نَاشْطَة، آمَا البْدَنْ ضْعِيفْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ومْشَى صَلَّى مَرَّة أُخْرَى، وقَالْ نَفْسْ الكْلَامْ . ");
INSERT INTO aeu_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ورْجَعْ مَرَّة أُخْرَى ولْقَاهُمْ رَاقْدِينْ عْلَى خَاطِرْ النُّومْ غْلِبْهُمْ، يَاخِي مَا عَرْفُوشْ آشْ يْجَاوْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","وجَاء المَرَّة الثَّالْثَة وقَالِلْهُمْ: «مَزِّلْتُوا رَاقْدِينْ ومِرْتَاحِينْ؟ يِزِّي! جَاتْ السَّاعَة. تَوَّا إِبْنْ الإِنْسَانْ بِشْ يْسَلْمُوهْ لِيْدِينْ المُذْنْبِينْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","قُومُوا، هَيَّا نِمْشِيوْ! هَاوْ الِّي بِشْ يْخُونِّي جَاء!». ");
INSERT INTO aeu_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","وبِالوَقْتْ، وهُوَّ مَزَّالْ يِتْكَلِّمْ، وْصُلْ يَهُوذَا الِّي هُوَّ وَاحِدْ مِالأَثْنَاشْ، ومْعَاهْ بَرْشَة نَاسْ هَازِّينْ سْيُوفَا وعْصِيْ، بَعْثُوهُمْ كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة والشْيُوخْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ولِّي بِشْ يْسَلْمُو عْطَاهُمْ أَمَارَة وقَالْ: «الِّي بِشْ نْبُوسُو هَاذَاكَا هُوَّ. شِدُّوهْ وهِزُّوهْ وعِسُّوا عْلِيهْ بِالڨْدَا». ");
INSERT INTO aeu_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ودُوبْ مَا وْصُلْ يَهُوذَا، مْشَالُو وقَالُّو: «يَا مُعَلِّمْ!» وبَاسُو. ");
INSERT INTO aeu_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","يَاخِي شَدُّوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","آمَا وَاحِدْ مِالوَاقْفِينْ غَادِي، جْبِدْ سِيفُو وضْرَبْ خْدِيمْ كْبِيرْ الكَهَنَة قَصْلُو وِذْنُو. ");
INSERT INTO aeu_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","قَالِلْهُمْ يَسُوعْ: «يَاخِي آنَا سَارِقْ خَارْجِينْلِي بِالسْيُوفَا والعْصِي بَاشْ تْشِدُّونِي؟ ");
INSERT INTO aeu_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","كُنْتْ كُلْ يُومْ نْعَلِّمْ بِينَاتْكُمْ فِي الهَيْكِلْ، ومَا شَدِّيتُونِيشْ. آمَا تَوَّا لَازِمْ يِتْحَقَّقْ الكْلَامْ الِّي تِكْتِبْ فِي الكْتُبْ المُقَدْسَة». ");
INSERT INTO aeu_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","وَقْتْهَا خَلَّاوَهْ الكُلْ وهَرْبُوا. ");
INSERT INTO aeu_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","وتَبْعُو طْفُلْ مَا لَابِسْ كَانْ فُوطَة. شَدُّوهْ هُوَّ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","يَاخِي خَلَّا الفُوطَة وهْرَبْ عِرْيَانْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","وهَزُّوا يَسُوعْ لِكْبِيرْ الكَهَنَة. وتْلَمُّوا بِيهْ كْبَارْ الكَهَنَة الكُلْهُمْ والشْيُوخْ وعُلَمَاءْ الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","تَبْعُو بُطْرُسْ حَتَّى لِينْ دْخَلْ لدَارْ كْبِيرْ الكَهَنَة، ودْخَلْ وقْعَدْ مْعَ الحُرَّاسْ يِدَّفَّى عَالنَّارْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","وكَانُوا كْبَارْ الكَهَنَة ولِّي فِي المَجْلِسْ الأَعْلَى الكُلْ يْلَوْجُوا عْلَى شْكُونْ يِشْهِدْ ضِدْ يَسُوعْ بَاشْ يْنَجْمُوا يُقْتْلُوهْ، يَاخِي مَا لْقَاوِشْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","عْلَى خَاطِرْ بَرْشَة نَاسْ شِهْدُوا ضِدُّو بِالبَاطِلْ، آمَا شْهَادِتْهُمْ كَانِتْ عَكْسْ بْعَضْهَا. ");
INSERT INTO aeu_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","فِي الإِخِّرْ، قَامُوا جْمَاعَة وشِهْدُوا ضِدُّو بِالكِذْبْ وقَالُوا: ");
INSERT INTO aeu_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«سْمَعْنَاهْ يْقُولْ: \"بِشْ نْهِدْ الهَيْكِلْ هَاذَا الِّي بْنَاوِهْ النَّاسْ، وبَعْدْ ثْلَاثَة أَيَّامْ بِشْ نِبْنِي هَيْكِلْ آخِرْ مَا صَنْعُوشْ الإِنْسَانْ\"». ");
INSERT INTO aeu_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","آمَا حَتَّى هَاذَا زَادَا تْخَالْفُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ووْقِفْ كْبِيرْ الكَهَنَة فِي وِسْطْ المَجْلِسْ وسْإِلْ يَسُوعْ: «يَاخِي مَا عَنْدِكْ مَا تْجَاوِبْ عَالنَّاسْ الِّي شِهْدُوا ضِدِّكْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","آمَا هُوَّ بْقَى سَاكِتْ ومَا جَاوِبْ بْحَتَّى شَيْ. وعَاوِدْ كْبِيرْ الكَهَنَة سِأْلُو: «يَاخِي إِنْتِ المَسِيحْ، إِبْنْ اللَّهْ المُبَارَكْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","قَالْ يَسُوعْ: «آنَا هُوَّ. وبِشْ تْشُوفُوا إِبْنْ الإِنْسَانْ قَاعِدْ عْلَى يْمِينْ اللَّهْ وجَايْ عْلَى سْحَابْ السْمَاء!». ");
INSERT INTO aeu_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","يَاخِي كْبِيرْ الكَهَنَة قَطَّعْ حْوَايْجُو وقَالْ: «آشْ مَزِّلْنَا نَحْتَاجُوا لِشْهُودْ؟ ");
INSERT INTO aeu_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","هَاكُمْ سْمَعْتُوهْ يَكْفِرْ: شْنُوَّة رَايْكُمْ؟». يَاخِي الكُلْهُمْ حُكْمُوا الِّي هُوَّ يِسْتَاهِلْ المُوتْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","وبْدَاوْ جْمَاعَة مِنْهُمْ يِبْزْقُوا عْلِيهْ، ويغَطِّيوْلُو وِجْهُو ويَضْرْبُوهْ ويْقُولُولُو: «تْنَبَّأْ!». وبْدَاوْ حُرَّاسْ الهَيْكِلْ يَضْرْبُوا فِيهْ بِالكَفْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ووَقْتِلِّي بُطْرُسْ كَانْ اللُّوطَا فِي وِسْطْ الدَّارْ، جَاتْ خْدِيمَة تَابْعَة كْبِيرْ الكَهَنَة، ");
INSERT INTO aeu_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","وكِي شَافِتْ بُطْرُسْ يِدَّفَّى ثَبْتِتْ فِيهْ وقَالِتْ: «إِنْتِ زَادَا كُنْتْ مْعَ يَسُوعْ النَّاصْرِي!». ");
INSERT INTO aeu_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","آمَا هُوَّ نْكَرْ وقَالْ: «مُشْ عَارِفْ ومُشْ فَاهِمْ آشْ قَاعْدَة تْقُولْ!». وخْرَجْ وقْعَدْ بَحْذَا البَابْ، ووَقْتْهَا صَاحْ السَّرْدُوكْ. ");
INSERT INTO aeu_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","آمَا وَقْتِلِّي شَافِتُّو الخْدِيمَة مَرَّة أُخْرَى، بْدَاتْ تْقُولْ لِلنَّاسْ الوَاقْفِينْ غَادِي: «هَاذَا وَاحِدْ مِنْهُمْ!». ");
INSERT INTO aeu_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","يَاخِي زَادْ نْكَرْ مَرَّة أُخْرَى. وبَعْدْ شْوَيَّة، قَالُوا الوَاقْفِينْ غَادِي لْبُطْرُسْ: «بِالحَقْ إِنْتِ وَاحِدْ مِنْهُمْ عْلَى خَاطْرِكْ مِنْ مَنْطَقْةْ الجَلِيلْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","آمَا هُوَّ بْدَا يَلْعِنْ ويَحْلِفْ: «رَانِي مَا نَعْرْفُوشْ الرَّاجِلْ هَاذَا الِّي تَحْكِيوْ عْلِيهْ». ");
INSERT INTO aeu_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","وبِالوَقْتْ صَاحْ السَّرْدُوكْ ثَانِي مَرَّة وتْذَكِّرْ بُطْرُسْ آشْ قَلُّو يَسُوعْ: «قْبَلْ مَا يْصِيحْ السَّرْدُوكْ مَرْتِينْ تْكُونْ إِنْتِ نْكَرْتْنِي ثْلَاثَة مَرَّاتْ». يَاخِي اطَّرْشَقْ بِالبْكَاء. ");
INSERT INTO aeu_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","وفِي الصْبَاحْ بِكْرِي تْشَاوْرُوا كْبَارْ الكَهَنَة مْعَ الشْيُوخْ وعُلَمَاءْ الشَّرِيعَة والمَجْلِسْ الأَعْلَى. ومْبَعِّدْ كَتْفُوا يَسُوعْ، وهَزُّوهْ، وسَلْمُوهْ لْبِيلَاطُسْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","وسِأْلُو بِيلَاطُسْ: «يَاخِي إِنْتِ مَلِكْ اليْهُودْ؟». جَاوْبُو يَسُوعْ: «إِنْتِ بِيدِكْ قُلْتْ». ");
INSERT INTO aeu_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","وبْدَاوْ كْبَارْ الكَهَنَة يِتْهْمُوا فِيهْ بْبَرْشَة تُهَمْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","يَاخِي سِأْلُو بِيلَاطُسْ مَرَّة أُخْرَى: «مَاكِشْ بِشْ تْقُولْ حَتَّى شَيْ؟ شُوفْ قَدَّاشْ مِنْ تُهْمَة قَالُوهَا ضِدِّكْ». ");
INSERT INTO aeu_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","آمَا يَسُوعْ مَا جَاوِبْ بْحَتَّى شَيْ بِالعْمَلْ بِيلَاطُسْ إِسْتَغْرِبْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","وكَانْ بِيلَاطُسْ مِسْتَانِسْ فِي كُلْ عِيدْ يْسَيْبِلْهُمْ وَاحِدْ مِالمْرَابِيطْ الِّي يَخْتَارُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","وكَانْ وَاحِدْ إِسْمُو بَارَابَاسْ مَرْبُوطْ هُوَّ وأَصْحَابُو الِّي شَارْكُوا مْعَاهْ فِي ثَوْرَة، وقَتْلُوا نَاسْ وَقْتِلِّي كَانِتْ فَمَّة خُوضَة فِي البْلَادْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","تْلَمُّوا النَّاسْ وطَلْبُوا مِنْ بِيلَاطُسْ بَاشْ يْسَيْبِلْهُمْ وَاحِدْ كِيمَا عَادْتُو. ");
INSERT INTO aeu_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","يَاخِي جَاوِبْهُمْ بِيلَاطُسْ: «تْحِبُّوا نْسَيْبِلْكُمْ مَلِكْ اليْهُودْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","خَاطْرُو كَانْ يَعْرِفْ الِّي كْبَارْ الكَهَنَة سَلْمُوا يَسُوعْ بِسْبَبْ الغِيرَة. ");
INSERT INTO aeu_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","آمَا كْبَارْ الكَهَنَة هَيْجُوا الشَّعْبْ بَاشْ يْصِيحُوا ويُطْلْبُوا مِنُّو يْسَيْبِلْهُمْ بَارَابَاسْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","قَالِلْهُمْ بِيلَاطُسْ مَرَّة أُخْرَى: «مَالَا آشْ تْحِبُّونِي نَعْمِلْ لِلِّي تْسَمِّيوْ فِيهْ مَلِكْ اليْهُودْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","بْدَاوْ يْصِيحُوا ويْعَاوْدُوا: «أُصْلْبُو!». ");
INSERT INTO aeu_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","وسْإِلْهُمْ بِيلَاطُسْ: «شْنُوَّة الشَّرْ الِّي عَمْلُو؟» آمَا هُومَا وَلَّاوْ يْصِيحُوا أَكْثِرْ: «أُصْلْبُو!». ");
INSERT INTO aeu_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","وحَبْ بِيلَاطُسْ يْرَضِّي الشَّعْبْ، يَاخِي سَيْبِلْهُمْ بَارَابَاسْ. وبَعْدْمَا أْمَرْ بْجَلْدْ يَسُوعْ، سَلْمُو بَاشْ يِتْصْلَبْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","وهَزُّوهْ الجُنُودْ لْوِسْطْ دَارْ الوِلَايَة، ولَمُّوا فِرْقِةْ العَسْكِرْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ولَبْسُوهْ لِبْسَة لُونْهَا بَنَفْسَجِي، وضَفْرُولُو تَاجْ مِالشُّوكْ وحَطُّوهْ فُوقْ رَاسُو. ");
INSERT INTO aeu_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","وبْدَاوْ يْحَيِّيوْ فِيهْ ويْقُولُوا: «سَلَامْ يَا مَلِكْ اليْهُودْ!» ");
INSERT INTO aeu_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ويَضْرْبُوا فِيهْ عْلَى رَاسُو بْقَصْبَة، ويِبْزْقُوا عْلِيهْ، ويَهْبْطُوا عْلَى رْكَايِبْهُمْ ويُسْجْدُولُو. ");
INSERT INTO aeu_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","وبَعْدْمَا تْمَسْخْرُوا عْلِيهْ، نَحَّاوْلُو اللِّبْسَة البَنَفْسَجِيَّة ولَبْسُوهْ حْوَايْجُو، وهَزُّوهْ لْبَرَّة بَاشْ يُصْلْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","وكَانْ سِمْعَانْ القِيرِينِي، بُو إِسْكَنْدِرْ ورُوفُسْ، رَاجَعْ مِالسَّانْيَة، يَاخِي لَزْمُوا عْلِيهْ يْهِزْ صَلِيبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ومْشَاوْ بِيهْ لِبْلَاصَة تِتْسَمَّى الجُلْجْثَة، ولِّي مَعْنَاهَا بُقْعِةْ الجُمْجْمَة. ");
INSERT INTO aeu_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","وعْطَاوَهْ شْرَابْ مْخَلِّطْ بِالمُرْ، يَاخِي مَا حَبِّشْ يُشْرْبُو. ");
INSERT INTO aeu_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","وبَعْدْمَا صَلْبُوهْ، قَسْمُوا حْوَايْجُو بِينَاتْهُمْ بِالقُرْعَة. ");
INSERT INTO aeu_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","وَقْتِلِّي صَلْبُوهْ كَانِتْ وَقْتْهَا التِّسْعَة مْتَاعْ الصْبَاحْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","وكِتْبُوا التُّهْمَة مْتَاعُو عْلَى بْلَاكَة ولِّي هِيَّ: «مَلِكْ اليْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","وصَلْبُوا زَادَا زُوزْ سُرَّاقْ، وَاحِدْ عْلَى يْمِينُو ووَاحِدْ عْلَى يْسَارُو. ");
INSERT INTO aeu_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","وهَكَّا تَمْ الكْلَامْ المَكْتُوبْ فِي الكْتُبْ المُقَدْسَة: «وحِسْبُوهْ مْعَ المُجْرْمِينْ». ");
INSERT INTO aeu_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","وكَانُوا المَاشِينْ يْسِبُّوا والجَّايِينْ يْسِبُّوا، وهُومَا يْدَوْحُوا فِي رْيُوسْهُمْ ويْقُولُوا: «هَهْ! يَلِّي بِشْ اطَّيَّحْ الهَيْكِلْ وتِبْنِيهْ فِي ثْلَاثَة أَيَّامْ، ");
INSERT INTO aeu_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","نَجِّي رُوحِكْ وأَهْبِطْ مِنْ فُوقْ الصَّلِيبْ!». ");
INSERT INTO aeu_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","وكَانُوا زَادَا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة يِتْمَسْخْرُوا عْلِيهْ ويْقُولُوا لِبْعَضْهُمْ: «نَجَّى غِيرُو، آمَا مَا انَّجَّمْشْ يْنَجِّي رُوحُو! ");
INSERT INTO aeu_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","تْرَاهْ خَلِّي المَسِيحْ مَلِكْ إِسْرَائِيلْ يَهْبِطْ مِنْ فُوقْ الصَّلِيبْ، تَوَّا نَمْنُوا بِيهْ». وبْدَاوْ السُّرَاقْ الزُّوزْ زَادَا يْسِبُّوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","وظْلَامِتْ الدِّنْيَا الكُلْ مِنْ نُصْفْ النْهَارْ، حَتَّى لِلمَاضِي ثْلَاثَة مْتَاعْ العْشِيَّة. ");
INSERT INTO aeu_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","وفِي مَاضِي ثْلَاثَة صَاحْ يَسُوعْ بْصُوتْ عَالِي: «أَلُّوِي! أَلُّوِي! لِمَا شَبَقْتَنِي؟» ومَعْنِتْهَا «يَا إِلَاهِي! يَا إِلَاهِي! عْلَاشْ خَلِّيتْنِي؟». ");
INSERT INTO aeu_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","وَقْتِلِي سَمْعُوهْ جْمَاعَة مِالوَاقْفِينْ غَادِي قَالُوا: « هَاوْ يْعَيِّطْ لِلنَّبِيْ إِيلِيَّا!». ");
INSERT INTO aeu_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","وبِالوَقْتْ جْرَى وَاحِدْ مِنْهُمْ، خْذَا شِيفُونَة، نَفَّخْهَا فِي الخَلْ، حَطْهَا عْلَى قَصْبَة ومَدْهَالُو بَاشْ يُشْرُبْ، وقَالْ: « إِسْتَنَّاوْ، خَلِّينَا نْشُوفُوا إِذَا كَانْ إِيلِيَّا بِشْ يْجِي ويْهَبْطُو!». ");
INSERT INTO aeu_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","وصَاحْ يَسُوعْ صِيحَة قْوِيَّة وسَلِّمْ الرُّوحْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","وتْشَرِّڨْ حْجَابْ الهَيْكِلْ عْلَى ثْنِينْ، مِالفُوقْ اللُّوطَا. ");
INSERT INTO aeu_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","وَقْتِلِّي الضَّابِطْ الِّي وَاقِفْ مْقَابْلُو شَافُو كِيفَاشْ صَاحْ وسَلِّمْ الرُّوحْ، قَالْ: «بِالحَقْ الإِنْسَانْ هَاذَا كَانْ إِبْنْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","وكَانُوا فَمَّة نْسَاء يِتْفَرْجُوا مِنْ بْعِيدْ فِلِّي قَاعِدْ يْصِيرْ ومِنْهُمْ مَرْيِمْ المَجْدَلِيَّة ومَرْيِمْ أُمْ يَعْقُوبْ الصْغِيرْ ويُوسِي، وسَالُومَة. ");
INSERT INTO aeu_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","هُومَا الِّي تَبْعُوا يَسُوعْ، وكَانُوا يِخْدْمُوا فِيهْ وَقْتِلِّي كَانْ فِي الجَلِيلْ، وبَرْشَة أُخْرِينْ غِيرْهُمْ طَلْعُوا مْعَاهْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","وكِي قْرُبْ اللِّيلْ، وكَانْ نْهَارْهَا نْهَارْ التَّحْضِيرْ، الِّي قْبَلْ السِّبْتْ، ");
INSERT INTO aeu_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","جَاء يُوسِفْ الِّي مِنْ مَنْطَقْةْ الرَّامَة، وهُوَّ كَانْ عُضُوْ مُحْتْرَمْ فِي المَجْلِسْ الأَعْلَى، وكَانْ زَادَا يِسْتَنَّى فِي مَمْلَكْةْ اللَّهْ، تْشَجَّعْ ودْخَلْ لْبِيلَاطُسْ وطْلَبْ مِنُّو جُثِّةْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","إِسْتَغْرِبْ بِيلَاطُسْ كِيفَاشْ يَسُوعْ مَاتْ فِيسَعْ. عَيِّطْ لِلضَّابِطْ وسِأْلُو: «يَاخِي عَنْدُو بَرْشَة مِلِّي مَاتْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","وكِي الضَابِطْ أَكَّدْلُو الخْبَرْ، عْطَى الجُثَّة لْيُوسِفْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","شْرَى يُوسِفْ كْفَنْ ولَفْ بِيهْ الجُثَّة، ودِفْنُو فِي قْبَرْ مَحْفُورْ فِي الحْجَرْ وحَطْ حَجْرَة عْلَى بَابْ القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ومَرْيِمْ المَجْدَلِيَّة ومَرْيِمْ أُمْ يُوسِي شَافُوا البُقْعَة الِّي دِفْنُو فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","وبَعْدْمَا تْعَدَّى السِّبْتْ، شْرَاتْ مَرْيِمْ المَجْدَلِيَّة ومَرْيِمْ أُمْ يَعْقُوبْ وسَالُومَة عْطُورَاتْ بَاشْ يِدْهْنُوا بِيهَا جُثِّةْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ونْهَارْ الأَحَدْ، مْشَاوْ لِلْقْبَرْ فِي الصْبَاحْ بِكْرِي، قْبَلْ طْلُوعْ الشَّمْسْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","وكَانُوا يْقُولُوا لِبْعَضْهُمْ: «شْكُونْ بِشْ يْبَعْدِلْنَا الحَجْرَة مِنْ بَابْ القْبَرْ؟». ");
INSERT INTO aeu_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ووَقْتِلِّي خَزْرُوا، لْقَاوْ الِّي الحَجْرَة تْنَحَّاتْ مِالبَابْ رَغْمِلِّي كَانِتْ كْبِيرَة بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","وكِي دَخْلُوا فِي وِسْطْ القْبَرْ شَافُوا فِي الجِّيهَة اليْمِينْ وَاحِدْ قَاعِدْ ولَابِسْ بِالأَبْيِضْ، يَاخِي خَافُوا. ");
INSERT INTO aeu_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","قَالِلْهُمْ: «مَا تْخَافُوشْ. إِنْتُومَا تْلَوْجُوا عْلَى يَسُوعْ النَّاصْرِي الِّي تِصْلَبْ. رَاهُو قَامْ، هُوَّ مُشْ هُونِي. هَايْ البُقْعَة الِّي حَطُّوهْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","بَرَّاوْ قُولُوا لِتْلَامِذْتُو ولْبُطْرُسْ رَاهُو بِشْ يِسْبِقْكُمْ لِلْجَلِيلْ، وغَادِي بِشْ تْشُوفُوهْ كِيمَا قَالِلْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","يَاخِي خَلَّاوْ القْبَرْ وهَرْبُوا وهُومَا مَرْعُوبِينْ، ومَا قَالُوا حَتَّى شَيْ لْحَتَّى وَاحِدْ مِنْ كُثْرِةْ الخُوفْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","وبَعْدْمَا قَامْ يَسُوعْ مِالمُوتْ نْهَارْ الأَحَدْ الصْبَاحْ، أَوِّلْ مَا ظْهُرْ، ظْهُرْ لْمَرْيِمْ المَجْدَلِيَّة الِّي خَرِّجْ مِنْهَا سَبْعَة أَرْوَاحْ شِرِّيرَة. ");
INSERT INTO aeu_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","يَاخِي مْشَاتْ وبَشْرِتْ أَتْبَاعُو، الِّي كَانُوا يْنَوْحُوا ويِبْكِيوْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","وكِي سَمْعُوا الِّي هُوَّ حَيْ ولِّي هِيَّ شَافِتُّو، مَا صَدْقُوشْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","وبَعْدْهَا ظْهُرْ فِي هَيْئَة أُخْرَى لْزُوزْ مِنْ تْلَامِذْتُو وهُومَا مَاشِينْ لِلرِّيفْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","يَاخِي مْشَاوْ وبَشْرُوا البَقِيَّة، آمَا حَتَّى هُومَا مَا صَدْقُوهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ومْبَعِّدْ ظْهُرْ لِلحْدَاشِنْ تِلْمِيذْ، وَقْتِلِّي كَانُوا يَاكْلُوا، ولَامْهُمْ عْلَى قِلِّةْ إِيمَانْهُمْ وكْسُوحِيِّةْ قْلُوبْهُمْ، كِي مَا صَدْقُوشْ النَّاسْ الِّي شَافُوهْ بَعْدْمَا قَامْ مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","وقَالِلْهُمْ: «إِمْشِيوْ لِلْعَالِمْ أَجْمَعْ، ووَصّْلُوا البْشَارَة لِلنَّاسْ الكُلْ: ");
INSERT INTO aeu_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","الِّي يَمِّنْ ويِتْعَمِّدْ يِنْجَى، ولِّي مَا يَمِّنْشْ يِتَّحْكَمْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ولِّي يَمْنُوا بِشْ تْكُونْ عَنْدْهُمْ المُعْجْزَاتْ هَاذِي: يْخَرْجُوا الشْوَاطِنْ بْإِسْمِي ويِتْكَلْمُوا بْلُوغَاتْ جْدِيدَة، ");
INSERT INTO aeu_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ويْشِدُّوا حَتَّى اللْفَعْ بِيدِيهُمْ. وإِذَا شَرْبُوا حَاجَة سَامَّة مَا تْضُرْهُمْشْ، ويْحُطُّوا يْدِيهُمْ عَالمُرْضَى يَبْرَاوْ». ");
INSERT INTO aeu_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","وبَعْدْمَا الرَّبْ تْكَلِّمْ مْعَاهُمْ، تِرْفَعّْ لِلسْمَاء، وقْعَدْ عْلَى يْمِينْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","وخَرْجُوا التْلَامْذَة يْبَشْرُوا فِي كُلْ بْلَاصَة، وكَانْ الرَّبْ يْعَاوِنْ فِيهُمْ ويْأَكِّدْ فِي كْلَامْهُمْ بِالمُعْجْزَاتْ.");
INSERT INTO aeu_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","بَرْشَة نَاسْ بْدَاوْ يِكْتْبُوا عَالأُمُورْ الِّي صَارِتْ عَنْدْنَا، ");
INSERT INTO aeu_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","كِيمَا وَصْلُوهَالْنَا الِّي كَانُوا شْهُودْ مِالأُوِّلْ وشَافُوهَا بْعِينِيهُمْ، ومْبَعِّدْ وَلَّاوْ خُدَّامْ لْكِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","آنَا زَادَا، بَعْدْمَا ثَبَّتْ مْلِيحْ فِي كُلْ شَيْ مِالأُوِّلْ كِيفْ مَا يِلْزِمْ، شُفْتْ إِنُّو نِكْتِبْهَالِكْ بِالتَّرْتِيبْ يَا صَاحِبْ العِزَّة ثَاوْفِيلُسْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","بَاشْ تِتْأَكِّدْ إِنُّو التَّعْلِيمْ الِّي وْصِلِّكْ صْحِيحْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","فِي زْمَانْ هِيرُودُسْ مَلِكْ اليَهُودِيَّة، كَانْ فَمَّة كَاهِنْ إِسْمُو زَكَرِيَّا، تَابَعْ لْفِرْقِةْ أَبِيَّا مْتَاعْ الكَهَنَة، وكَانِتْ مَرْتُو مِنْ ذُرِّيِّةْ هَارُونْ وإِسْمْهَا أَلِيصَابَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","وكَانُوا الإِثْنِينْ صَالْحِينْ فِي عِينِينْ اللَّهْ، ويْعِيشُوا حَسْبْ الوْصَايَا مْتَاعُو وفَرَايْضُو، ومَا عْلِيهُمْشْ لُومْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","آمَا مَا كَانِشْ عَنْدْهُمْ وْلَادْ، عْلَى خَاطِرْ أَلِيصَابَاتْ مَا كَانِتْشْ تْجِيبْ الصْغَارْ، وكَانُوا الإِثْنِينْ كْبَارْ فِي العْمُرْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","وفِي مَرَّة مِالمَرَّاتْ وَقْتِلِّي كَانْ زَكَرِيَّا يِخْدِمْ فِي الهَيْكِلْ قُدَّامْ اللَّهْ وَقْتْ دَوْرْ فِرْقْتُو فِي الخِدْمَة، ");
INSERT INTO aeu_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","عَمْلُوا قُرْعَة كِيمَا جْرَاتْ عَادِةْ الكَهَنَة، يَاخِي جَاتْ عْلِيهْ هُوَّ بَاشْ يُدْخُلْ لْهَيْكِلْ الرَّبْ ويَحْرَقْ البْخُورْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","والشَّعْبْ الكُلْ كَانْ لْبَرَّة يْصَلِّي وَقْتْ حَرْقَانْ البْخُورْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","يَاخِي ظْهُرْلُو مَلَاكْ مِنْ عَنْدْ الرَّبْ وَاقِفْ عْلَى يْمِينْ المَذْبَحْ مْتَاعْ البْخُورْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","وكِي شَافُو زَكَرِيَّا دْخَلْ بَعْضُو ومِكْنُو الخُوفْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","يَاخِي قَالُّو المَلَاكْ: «مَا تْخَافِشْ يَا زَكَرِيَّا عْلَى خَاطِرْ اللَّهْ سْمَعْ صْلَاتِكْ ومَرْتِكْ أَلِيصَابَاتْ بِشْ تْجِيبْلِكْ وْلَيِّدْ، وإِنْتِ بِشْ تْسَمِّيهْ يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","وبِشْ تِفْرَحْ وتِتْهَنَّى بِيهْ، وبَرْشَة نَاسْ بِشْ يِفْرْحُوا كِي يِتُّولِدْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","عْلَى خَاطْرُو بِشْ يْكُونْ عْظِيمْ عَنْدْ الرَّبْ، ومُشْ بِشْ يُشْرُبْ لَا شْرَابْ ولَا حَاجَاتْ تْسَكِّرْ، وبِشْ يِتْمْلَى بِالرُّوحْ القُدُسْ مِلِّي هُوَّ فِي كِرْشْ أُمُّو. ");
INSERT INTO aeu_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","وبِشْ يْرَجَّعْ بَرْشَة مِنْ بَنِي إِسْرَائِيلْ لِلرَّبْ إِلَاهُّمْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ويْجِي قْبَلْ الرَّبْ بْرُوحْ إِيلِيَّا وقُوْتُو، بَاشْ يْصَالَحْ الوَالْدِينْ مْعَ وْلَادْهُمْ، ويْرَجَّعْ العَاصِينْ لْحِكْمَة الصَّالْحِينْ، وهَكَّا يْحَضِّرْ شَعْبْ مُسْتْعَدْ لِلرَّبْ». ");
INSERT INTO aeu_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","يَاخِي قَالْ زَكَرِيَّا لِلْمَلَاكْ: «كِيفَاشْ يْصِيرْ هَاذَا، وآنَا رَاجِلْ شَايِبْ ومَرْتِي كْبِيرَة فِي العْمُرْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","جَاوْبُو المَلَاكْ: «آنَا جِبْرِيلْ الوَاقِفْ قُدَّامْ اللَّهْ، وآنَا تِبْعَثْتْ بَاشْ نْكَلْمِكْ ونْبَشْرِكْ بِالخْبَرْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","وهَاكْ تَوَّا بِشْ تِبْقَى سَاكِتْ ومَاكِشْ بِشْ تْنَجِّمْ تِتْكَلِّمْ حَتَّى لِينْ يْجِي النْهَارْ الِّي يْتِمْ فِيهْ هَاذَا، عْلَى خَاطْرِكْ مَا صَدَّقْتِشْ كْلَامِي الِّي بِشْ يْصِيرْ فِي وَقْتُو». ");
INSERT INTO aeu_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","الشَّعْبْ كَانْ يِسْتَنَّى فِي زَكَرِيَّا ومِسْتَغْرِبْ كِيفَاشْ بْطَى لْدَاخِلْ فِي الهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","وكِي خْرَجْ مَا نَجَّمْشْ يْكَلَّمْهُمْ، يَاخِي فِهْمُوا الِّي هُوَّ شَافْ رُؤْيَا فِي الهَيْكِلْ، وبْدَا يَحْكِي مْعَاهُمْ بِالإِشَارَاتْ وبْقَى سَاكِتْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ووَقْتِلِّي كِمْلِتْ أَيَّامَاتْ خِدْمْتُو رْجَعْ لْدَارُو. ");
INSERT INTO aeu_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","وبَعْدْ مُدَّة حِبْلِتْ مَرْتُو أَلِيصَابَاتْ، وخَبَّاتْ رُوحْهَا خَمْسَة شْهُورْ وكَانِتْ تْقُولْ: ");
INSERT INTO aeu_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«هَاذَا آشْ عْمَلْ مْعَايَا الرَّبْ نْهَارِةْ الِّي نْعِمْ عْلِيَّا ونَحَّالِي عَارِي بِينْ النَّاسْ!». ");
INSERT INTO aeu_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","وكِي كَانِتْ أَلِيصَابَاتْ فِي شْهَرْهَا السَّادِسْ، بْعَثْ اللَّهْ المَلَاكْ جِبْرِيلْ لِمْدِينَة فِي مَنْطَقْةْ الجَلِيلْ إِسْمْهَا النَّاصْرَة، ");
INSERT INTO aeu_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","لِصْبِيَّة إِسْمْهَا مَرْيِمْ مَخْطُوبَة لْرَاجِلْ مِنْ نَسْلْ دَاوِدْ إِسْمُو يُوسِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","يَاخِي دْخَلِّلْهَا المَلَاكْ وقَالِلْهَا: «السَّلَامْ يَلِّي نْعِمْ عْلِيكْ اللَّهْ! الرَّبْ مْعَاكْ، مُبَارْكَة إِنْتِ مِنْ بِينْ النْسَاء». ");
INSERT INTO aeu_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","يَاخِي دَخْلِتْ بْعَضْهَا مِنْ كْلَامْ المَلَاكْ وقَالِتْ بِينْهَا وبِينْ رُوحْهَا: «زَعْمَة شْنُوَّة مَعْنَى السَّلَامْ هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","يَاخِي قَالِلْهَا المَلَاكْ: «مَا تْخَافِشْ يَا مَرْيِمْ رَاهُو اللَّهْ نْعِمْ عْلِيكْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","وهَاكْ بِشْ تِحْبِلْ وتْجِيبْ وْلَيِّدْ وتْسَمِّيهْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","وبِشْ يْكُونْ عْظِيمْ، ويِتْسَمَّى إِبْنْ العَالِي، ويَعْطِيهْ الرَّبْ الإِلَاهْ عَرْشْ بُوهْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ويِمْلِكْ عْلَى ذُرِّيِّةْ يَعْقُوبْ لِلْأَبَدْ، ومَا يْكُونِشْ فَمَّة نْهَايَة لْمُلْكُو». ");
INSERT INTO aeu_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","يَاخِي قَالِتْ مَرْيِمْ لِلْمَلَاكْ: «كِيفَاشْ يْصِيرْ هَاذَا وآنَا مَزِّلْتْ صْبِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","جَاوِبْهَا المَلَاكْ: «الرُّوحْ القُدُسْ يَهْبِطْ عْلِيكْ وقُدْرِةْ العَالِي تْغَطِّيكْ، هَاذَاكَا عْلَاشْ القُدُّوسْ الِّي بِشْ تُولْدُو يِتْسَمَّى إِبْنْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","وهَايْ قْرِيبْتِكْ أَلِيصَابَاتْ حِبْلَى بِوْلَيِّدْ وهِيَّ كْبِيرَة فِي العْمُرْ، ولِّي كَانُوا يْقُولُوا عْلِيهَا مَا تَضْنَاشْ هَايْ تَوَّا فِي شْهَرْهَا السَّادِسْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","عْلَى خَاطِرْ حَتَّى شَيْ مَاهُو مُسْتَحِيلْ عَنْدْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","يَاخِي قَالِتْ مَرْيِمْ: «آنَا خْدِيمِةْ الرَّبْ، خَلِّي يْصِيرْلِي كِيمَا قُلْتْ». ومْشَى المَلَاكْ مِنْ عَنْدْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","وفِي الأَيَّامَاتْ هَاذُوكُمْ، حَضّْرِتْ مَرْيِمْ رُوحْهَا ومْشَاتْ فِيسَعْ لِلجْبَالْ لِمْدِينَة فِي يَهُوذَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ودَخْلِتْ لْدَارْ زَكَرِيَّا وسَلْمِتْ عْلَى أَلِيصَابَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","وكِي سَمْعِتْ أَلِيصَابَاتْ سْلَامْ مَرْيِمْ تْحَرِّكْ الصْغِيرْ فِي كِرْشْهَا، وتِمْلَاتْ بِالرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","وعَيْطِتْ بْصُوتْ عَالِي وقَالِتْ: «مُبَارْكَة إِنْتِ مِنْ بِينْ النْسَاء، ومُبَارِكْ الصْغِيرْ الِّي فِي كِرْشِكْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","شْكُونِي آنَا حَتَّى تْجِينِي أُمْ سِيدِي؟ ");
INSERT INTO aeu_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","أَوِّلْ مَا وْصِلْ سْلَامِكْ لْوِذْنَيَّا، الصْغِيرْ الِّي فِي كِرْشِي تْحَرِّكْ مِالفَرْحَة. ");
INSERT INTO aeu_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","وصَحَّة لِيهَا الِّي أَمْنِتْ إِنُّو الكْلَامْ الِّي تْقَالِلْهَا مِنْ عَنْدْ الرَّبْ بِشْ يْصِيرْ». ");
INSERT INTO aeu_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","وقَالِتْ مَرْيِمْ: «نَفْسِي تْعَظِّمْ الرَّبْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ورُوحِي تِفْرَحْ بِاللَّهْ الِّي يْنَجِّينِي. ");
INSERT INTO aeu_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","عْلَى خَاطْرُو نْعِمْ عْلِيَّا آنَا خْدِيمْتُو البْسِيطَة! ومِنْ تَوَّا الأَجْيَالْ الكُلْ بِشْ يْقُولُوا صَحَّة لِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","عْلَى خَاطِرْ اللَّهْ القَادِرْ عْلَى كُلْ شَيْ عْمَلْ مْعَايَا حَاجَاتْ عْظِيمَة. إِسْمُو قُدُّوسْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ورَحْمْتُو لِلِّي يَتَّقِيوُهْ، تِبْقَى مِنْ جِيلْ لْجِيلْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","بْقُدْرْتُو عْمَلْ حَاجَاتْ عْظِيمَة. وشَرِّدْ الِّي قْلُوبْهُمْ مِتْكَبْرَة. ");
INSERT INTO aeu_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","هَبِّطْ الحُكَّامْ مِنْ عَرْشْهُمْ، ورْفَعْ المِتْوَاضْعِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","شَبَّعْ الجْوَاعَى بِالخِيرَاتْ، ورَجَّعْ الغُنْيَا بِيْدِيهُمْ فَارْغِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","عَاوِنْ إِسْرَائِيلْ عَبْدُو، عْلَى خَاطِرْ وِعْدُو بِشْ يَرَحْمُو، ");
INSERT INTO aeu_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","كِيمَا وْعِدْ جْدُودْنَا، إِبْرَاهِيمْ وذُرِّيتُو لِلْأَبَدْ». ");
INSERT INTO aeu_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","وبْقَاتْ مَرْيِمْ بَحْذَا أَلِيصَابَاتْ قْرِيبْ الثْلَاثَة شْهُرْ، ومْبَعِّدْ رَجْعِتْ لْدَارْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","وَقْتِلِّي جَاء وَقْتْ أَلِيصَابَاتْ بَاشْ تُولِدْ، جَابِتْ وْلَيِّدْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","وسَمْعُوا جِيرَانْهَا ولِّي يُقْرْبُولْهَا إِنُّو اللَّهْ فَاضْ عْلِيهَا بْرَحْمْتُو، وفَرْحُوا مْعَاهَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","وفِي النْهَارْ الثَّامِنْ جَاوْ بَاشْ يْطَهْرُوا الطْفُلْ، وحَبُّوا يْسَمِّيوَهْ زَكَرِيَّا عْلَى إِسْمْ بُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","آمَا أُمُّو قَالِتْ: «لَا، بِشْ يِتْسَمَّى يُوحَنَّا». ");
INSERT INTO aeu_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","يَاخِي قَالُولْهَا: «حَتَّى وَاحِدْ مِنْ امَّالِيكْ مَا تْسَمَّى بِالإِسْمْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","وسِأْلُوا بُوهْ بِالإِشَارَاتْ بَاشْ يَعْرْفُوا آشْ يْحِبْ يْسَمِّيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","وبُوهْ طْلَبْ لُوحَة وكْتِبْ عْلِيهَا: «إِسْمُو يُوحَنَّا». يَاخِي بِهْتُوا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","وبِالوَقْتْ تْحَلْ فُمْ زَكَرِيَّا وتْسَرَّحْ لْسَانُو، وبْدَا يِتْكَلِّمْ ويْسَبَّحْ فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","والجِيرَانْ الكُلْ مْكِنْهُمْ الخُوفْ، وبْقَاوْ النَّاسْ يَحْكِيوْ بِالأُمُورْ هَاذِي فِي جْبَالْ مَنْطَقْةْ يَهُوذَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ولِّي سَمْعُوهُمْ الكُلْ، قَعْدُوا يْقُولُوا فِي قْلُوبْهُمْ: «زَعْمَة شْنُوَّة بِشْ يْوَلِّي هَا الوْلَيِّدْ؟». عْلَى خَاطِرْ قُدْرِةْ الرَّبْ كَانِتْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","وتِمْلَى زَكَرِيَّا بُوهْ بِالرُّوحْ القُدُسْ، وتْنَبَّأْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«مُبَارَكْ الرَّبْ إِلَاهْ إِسْرَائِيلْ، عْلَى خَاطْرُو جَاء بَاشْ يْعَاوِنْ شَعْبُو ويِفْدِيهْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","وبْعَثِّلْنَا مُنَجِّي قْدِيرْ، مِنْ عَرْشْ عَبْدُو دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","كِيمَا وْعِدْ مِنْ قْدِيمْ الزْمَانْ عْلَى لْسَانْ أَنْبِيَاؤُو القِدِّيسِينْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","بَاشْ يْنَجِّينَا مِنْ أَعْدَائْنَا، ومِنْ يْدِينْ الِّي يِكْرْهُونَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","وهَكَّا، يْظَهِّرْ رَحْمْتُو لِجْدُودْنَا، ويِتْذَكِّرْ عَهْدُو المُقَدِّسْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","عْلَى خَاطْرُو حْلِفْ يْمِينْ، لْبُونَا إِبْرَاهِيمْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","إِنُّو يْنَجِّينَا مِنْ أَعْدَائْنَا، بَاشْ نِعْبْدُوهْ بْلَا خُوفْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","وأَحْنَا فِي القَدَاسَة والصَّلَاحْ قُدَّامُو طُولْ حْيَاتْنَا. ");
INSERT INTO aeu_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","وإِنْتِ يَا وِلْدِي، بِشْ تِتْسَمَّى نَبِيْ العَالِي، عْلَى خَاطْرِكْ جِيتْ قْبَلْ الرَّبْ بِشْ تْحَضَّرْلُو الطْرِيقْ، ");
INSERT INTO aeu_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","وتْعَلِّمْ شَعْبُو إِنُّو النْجَاةْ تْكُونْ بْمَغْفِرْةْ ذْنُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","عْلَى خَاطِرْ إِلَاهْنَا رَحْمْتُو عْظِيمَة، خَلَّى كَوْكِبْ الفَجْرْ يْزُورْنَا مِالسْمَاء ويِضْوِي عْلِينَا، ");
INSERT INTO aeu_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ويْضَوِّي عَالعَايْشِينْ فِي الظْلَامْ وفِي ظِلْ المُوتْ، ويِهْدِي خَطْوَاتْنَا فِي طْرِيقْ السَّلَامْ». ");
INSERT INTO aeu_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","وكَانْ الطْفُلْ يِكْبِرْ ويِتْقَوَّى بِالرُّوحْ، وكَانْ يْعِيشْ فِي الخْلَاء لِلنْهَارْ الِّي ظْهُرْ فِيهْ لْبَنِي إِسْرَائِيلْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","وفِي الزْمَانْ هَاذَاكَا، عْطَى القَيْصِرْ أُغُسْطُسْ أَمْرْ بَاشْ يِحْسْبُوا عْدَدْ سُكَّانْ الإِمْبْرَاطُورِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","وكَانْ هَاذَا أَوِّلْ حِسْبَانْ لِلسُّكَّانْ، وصَارْ فِي زْمَانْ كِيرِينْيُوسْ وَالِي مَنْطَقْةْ سُورِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","يَاخِي مْشَى كُلْ وَاحِدْ لِمْدِينْتُو بَاشْ يِتْقَيِّدْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ومْشَى يُوسِفْ زَادَا مِنْ مْدِينِةْ النَّاصْرَة الِّي فِي مَنْطَقْةْ الجَلِيلْ، لِمْدِينِةْ دَاوِدْ الِّي تِتْسَمَّى بَيْتْ لَحْمْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة، عْلَى خَاطْرُو كَانْ مِنْ ذُرِّيِّةْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","مْشَى بَاشْ يِتْقَيِّدْ غَادِي، هُوَّ وخَطِيبْتُو مَرْيِمْ، الِّي كَانِتْ حِبْلَى. ");
INSERT INTO aeu_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","وهُومَا فِي بَيْتْ لَحْمْ، جَاء وَقْتْ وْلَادِتْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","يَاخِي وِلْدِتْ وِلْدْهَا البِكْرْ، وقَمْطِتُّو ورَقْدِتُّو فِي مَعْلِفْ مْتَاعْ حَيَوَانَاتْ، عْلَى خَاطِرْ مَا كَانِشْ فَمَّة بْلَاصَة لِيهُمْ فِي الوْكَالَة. ");
INSERT INTO aeu_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","وفِي المَنْطْقَة هَاذِيكَا، كَانْ فَمَّة سُرَّاحْ يْبَاتُوا فِي السْوَانِي، ويِتْبَادْلُوا فِي العَسَّة عْلَى غْنَمْهُمْ فِي اللِّيلْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","وإِذَا بِيهْ مَلَاكْ مِنْ عَنْدْ الرَّبْ ظْهُرِّلْهُمْ، ومَجْدْ الرَّبْ ضْوَى عْلِيهُمْ مِنْ كُلْ جِيهَة، يَاخِي خَافُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","آمَا المَلَاكْ قَالِلْهُمْ: «مَا تْخَافُوشْ! جِيتْ نْبَشِّرْ فِيكُمْ بِخْبَرْ عْظِيمْ يْفَرَّحْ الشَّعْبْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","اليُومْ فِي مْدِينِةْ دَاوِدْ تُوْلِدِّلْكُمْ مُنَجِّي هُوَّ المَسِيحْ الرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","وهَاذِي أَمَارَة لِيكُمْ: تَلْقَاوْ طْفُلْ مَلْفُوفْ بِقْمَاطَة ورَاقِدْ فِي مَعْلِفْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","وهُومَا هَكَّاكَا، ظْهُرْ مْعَ المَلَاكْ عْدَدْ كْبِيرْ مِنْ مْلَايِكْةْ جَيْشْ السْمَاءْ، يْسَبْحُوا فِي اللَّهْ ويْقُولُوا: ");
INSERT INTO aeu_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«المَجْدْ لِلَّهْ فِي السْمَاء، وعَالأَرْضْ السَّلَامْ لِلنَّاسْ الِّي يْحِبْهُمْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ووَقْتِلِّي رَجْعُوا المْلَايْكَة لِلسْمَاء، قَالُوا السُرَّاحْ لِبْعَضْهُمْ: «هَيَّا نِمْشِيوْ لْبِيتْ لَحْمْ ونْشُوفُوا الِّي صَارْ، ولِّي خَبَّرْنَا بِيهْ الرَّبْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ومْشَاوْ فِيسَعْ، ولْقَاوْ مَرْيِمْ ويُوسِفْ والطْفُلْ رَاقِدْ فِي المَعْلِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ووَقْتِلِّي شَافُوهْ، حْكَاوْ عَالكْلَامْ الِّي تْقَالِلْهُمْ فِي مَا يْخُصْ الطْفُلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ولِّي سَمْعُوا الكُلْ تْعَجْبُوا مِلِّي قَالُوهْ السُرَّاحْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","آمَا مَرْيِمْ خَلَّاتْ الكْلَامْ هَاذَا الكُلْ فِي قَلْبْهَا وقَعْدِتْ تْخَمِّمْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ورَجْعُوا السُرَّاحْ وهُومَا يْمَجْدُوا ويْسَبْحُوا فِي اللَّهْ عَلِّي سَمْعُوهْ وشَافُوهْ الكُلْ، عْلَى خَاطِرْ كُلْ شَيْ كَانْ كِيمَا قَالِلْهُمْ المَلَاكْ بِالضَّبْطْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","وبَعْدْ ثْمَنْيَة أَيَّامْ، جَاء الوَقْتْ الِّي يْطَهْرُوا فِيهْ الطْفُلْ، وسَمَّاوَهْ يَسُوعْ كِيمَا سَمَّاهْ المَلَاكْ قْبَلْ مَا تِحْبِلْ بِيهْ مَرْيِمْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ووَقْتِلِّي تْعَدَّاوْ أَيَّامْ تَطْهِيرْهُمْ، حَسْبْ شَرِيعِةْ مُوسَى، طَلْعُوا بِيهْ لْأُورْشَلِيمْ بَاشْ يْقَدْمُوهْ لِلرَّبْ، ");
INSERT INTO aeu_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","كِيمَا مَكْتُوبْ فِي شَرِيعِةْ الرَّبْ: «كُلْ بِكْرْ ذْكَرْ يِتْخَصِّصْ لِلرَّبْ»، ");
INSERT INTO aeu_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","وزَادَا بَاشْ يْقَدْمُوا ذْبِيحَة كِيمَا وَصَّاتْ شَرِيعَةْ الرَّبْ: «زُوزْ طْيُورْ يْمَامْ وَلَّا زُوزْ فْرُوخْ حْمَامْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","وكَانْ فَمَّة رَاجِلْ فِي أُورْشَلِيمْ إِسْمُو سِمْعَانْ، والرَّاجِلْ هَاذَا كَانْ صَالَحْ ويْخَافْ اللَّهْ. وكَانْ يِسْتَنَّى وَقْتَاشْ يْجِي الِّي بِشْ يْنَجِّي شَعْبْ إِسْرَائِيلْ، والرُّوحْ القُدُسْ كَانْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","والرُّوحْ القُدُسْ وْحَالُو قْبَلْ، إِنُّو مَا يْمُوتْ إِلَّا مَا يْرَى مَسِيحْ الرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","وجَاء لِلْهَيْكِلْ بْوَحْيْ مِالرُّوحْ. ووَقْتِلِّي يُوسِفْ ومَرْيِمْ دَخْلُوا ومْعَاهُمْ وِلْدْهُمْ يَسُوعْ بَاشْ يَعْمْلُولُو الِّي فَرْضِتُّو الشَّرِيعَة، ");
INSERT INTO aeu_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","هَزُّو سِمْعَانْ بِينْ يْدِيهْ، ومَجِّدْ اللَّهْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«يَا رَبْ، تَوَّا تْحَقَّقْ وَعْدِكْ لِيَّا، خَلِّي عَبْدِكْ يِمْشِي بْسَلَامْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","عْلَى خَاطِرْ عِينَيَّا شَافُوا نْجَاتِكْ ");
INSERT INTO aeu_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","الِّي حَضَّرْتْهَا بَاشْ يْشُوفُوهَا الشُّعُوبْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","هِيَّ نُورْ تِهْدِي بِيهْ الشُّعُوبْ الأُخْرِينْ، ومَجْدْ لْبَنِي إِسْرَائِيلْ شَعْبِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","وتْعَجْبُوا بُوهْ وأُمُّو مِالكْلَامْ الِّي تْقَالْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","وبَارِكْهُمْ سِمْعَانْ وقَالْ لْمَرْيِمْ أُمُّو: «الطْفُلْ هَاذَا اخْتَارُو اللَّهْ بَاشْ يْكُونْ سْبَبْ إِنُّو بَرْشَة نَاسْ فِي بَنِي إِسْرَائِيلْ يْطِيحُوا، وبَرْشَة نَاسْ يْقُومُوا. ويْكُونْ أَمَارَة مِنْ عَنْدْ اللَّهْ يْقَاوْمُوهَا. ");
INSERT INTO aeu_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","وتِتْكْشِفْ نِيَّاتْ بَرْشَة قْلُوبْ. آمَا إِنْتِ، الحُزْنْ بِشْ يُدْخُلْ فِي قَلْبِكْ كِيمَا السِّيفْ». ");
INSERT INTO aeu_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","وكَانِتْ فَمَّة نَبِيَّة، إِسْمْهَا حَنَّة بِنْتْ فَنُوئِيلْ، مِنْ عَرْشْ أَشِيرْ. كَانِتْ كْبِيرَة فِي العْمُرْ، وعَاشِتْ مْعَ رَاجِلْهَا سَبْعَة سْنِينْ بَعْدْ العِرْسْ، ");
INSERT INTO aeu_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ومْبَعِّدْ عَاشِتْ هَجَّالَة. وفِي الوَقْتْ هَاذَاكَا كَانْ عْمُرْهَا 84 سْنَة. وكَانِتْ دِيمَا فِي الهَيْكِلْ، تِعْبِدْ فِي اللَّهْ نْهَارْ ولِيلْ بِالصُّومْ والصْلَاةْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","وجَاتْ فِي نَفْسْ الوَقْتْ وبْدَاتْ تْسَبَّحْ فِي اللَّهْ، وتِتْكَلِّمْ عْلَى يَسُوعْ مْعَ كُلْ النَّاسْ الِّي كَانُوا يِسْتَنَّاوْ فِي اللَّهْ بَاشْ يِفْدِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","وبَعْدْمَا كَمْلُوا يُوسِفْ ومَرْيِمْ فْرَايِضْ شَرِيعِةْ الرَّبْ الكُلْ، رَجْعُوا لِلْجَلِيلْ، لِمْدِينِتْهُمْ النَّاصْرَة. ");
INSERT INTO aeu_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","وكَانْ الوْلَيِّدْ يَسُوعْ يِكْبِرْ ويِتْقَوَّى. وكَانْ مِلْيَانْ بِالحِكْمَة ونِعْمَةْ اللَّهْ كَانِتْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","وكَانُوا وَالْدِيهْ يِمْشِيوْ كُلْ عَامْ لْأُورْشَلِيمْ فِي عِيدْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","وكِي كَانْ عْمُرْ يَسُوعْ أَثْنَاشِنْ سْنَة، طَلْعُوا لْأُورْشَلِيمْ كِي العَادَة فِي العِيدْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","وبَعْدْمَا وْفَاوْ أَيَّامَاتْ العِيدْ، رَوْحُوا وَالْدِيهْ وبْقَى يَسُوعْ فِي أُورْشَلِيمْ مِنْ غِيرْ مَا يَعْرْفُوا. ");
INSERT INTO aeu_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ومْشَى فِي بَالْهُمْ الِّي هُوَّ مْعَ بْقِيِّةْ النَّاسْ الِّي مْسَافْرِينْ مْعَاهُمْ، وبَعْدْمَا مْشَاوْ مْسَافِةْ نْهَارْ كَامِلْ، بْدَاوْ يْلَوْجُوا عْلِيهْ بِينْ الأَقَارِبْ والمْعَارِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","وكِي مَا لْقَاوْهُوشْ رَجْعُوا لْأُورْشَلِيمْ يْلَوْجُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","وبَعْدْ ثْلَاثَة أَيَّامْ لْقَاوَهْ فِي الهَيْكِلْ قَاعِدْ وِسْطْ المُعَلْمِينْ يِسْمَعْ ويِسْإِلْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ولِّي سَمْعُوهْ الكُلْ بْقَاوْ بَاهْتِينْ فِي فَهْمُو وفِي الأَجْوْبَة مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","وتْعَجْبُوا وَالْدِيهْ وَقْتِلِّي شَافُوهْ، وقَالِتْلُو أُمُّو: «يَا وْلِيدِي، عْلَاشْ عْمَلْتْ فِينَا هَكَّا؟ رَانِي آنَا وبُوكْ تْعَذَّبْنَا بَرْشَة وأَحْنَا نْلَوْجُوا عْلِيكْ!». ");
INSERT INTO aeu_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","يَاخِي جَاوِبْهُمْ: «عْلَاشْ تْلَوْجُوا عْلِيَّا؟ مَا تَعْرْفُوشْ الِّي يِلْزِمْنِي نْكُونْ فِي دَارْ بَابَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","آمَا هُومَا مَا فِهْمُوشْ الكْلَامْ الِّي قَالْهُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ورَجْعْ مْعَاهُمْ لِلنَّاصْرَة وكَانْ يِسْمَعْ كْلَامْهُمْ. وأُمُّو خَلَّاتْ هَاذَا الكُلْ فِي قَلْبْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","وكَانْ يَسُوعْ يِكْبِرْ فِي بَدْنُو وفِي الحِكْمَة وفِي النِّعْمَة عَنْدْ اللَّهْ وعَنْدْ النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","وَقْتِلِّي القَيْصِرْ طِيبَارْيُوسْ عْمَلْ 15 سْنَة فِي الحُكْمْ، وكَانْ بِيلَاطُسْ البُنْطِي وَالِي عْلَى مَنْطَقْةْ اليَهُودِيَّة، وهِيرُودُسْ وَالِي عْلَى مَنْطَقْةْ الجَلِيلْ، وخُوهْ فِيلِيبُّسْ وَالِي عْلَى مَنْطَقْةْ إِيطُورِيَّة وتْرَاخُونِيتْسْ، ولِيسَانْيُوسْ وَالِي عْلَى مَنْطَقْةْ الأَبِلِيَّة، ");
INSERT INTO aeu_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","وفِي الوَقْتْ الِّي كَانُوا فِيهْ حَنَّانْ وقِيَافَا كْبَارْ الكَهَنَة، كَلِّمْ اللَّهْ يُوحَنَّا وِلْدْ زَكَرِيَّا وهُوَّ فِي الخْلَاء. ");
INSERT INTO aeu_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","يَاخِي مْشَى لِلْبْقَايَعْ الكُلْ الدَّايْرَة بْوَادْ الأُرْدُنْ، يْنَادِي لِلنَّاسْ بَاشْ يْتُوبُوا ويِتْعَمْدُوا بَاشْ تِتْغْفِرْ ذْنُوبْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","كِيمَا مَكْتُوبْ فِي كْتَابْ النَّبِيْ إِشَعْيَاءْ: «صُوتْ يْعَيِّطْ فِي الخْلَاء: حَضّْرُوا طْرِيقْ الرَّبْ، إِسْتْوِيوْ الثْنِيَّة قُدَّامُو! ");
INSERT INTO aeu_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","كُلْ وَادْ يِتِرْدِمْ، وكُلْ جْبَلْ وهَضْبَة يُوطَاوْ، والثْنَايَا المْعَوْجَة تِتْسْتْوَى، والوَاعْرَة تِسْهَالْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","والنَّاسْ الكُلْ بِشْ يْشُوفُوا نْجَاةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","وكَانْ يُوحَنَّا يْقُولْ لِلنَّاسْ الِّي جَاوْ بَاشْ يِتْعَمْدُوا عْلَى يْدِيهْ: «يَا وْلَادْ الأَفَاعِي! شْكُونْ الِّي وَرَّاكُمْ كِيفَاشْ تُهْرْبُوا مِنْ غَضَبْ اللَّهْ الِّي بِشْ يْجِي؟ ");
INSERT INTO aeu_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","أَعْمْلُوا أَعْمَالْ تْوَرِّي الِّي إِنْتُومَا تُبْتُوا بِالحَقْ، ومَا تْقُولُوشْ فِي قْلُوبْكُمْ: \"أَحْنَا وْلَادْ إِبْرَاهِيمْ\". عْلَى خَاطِرْ آنَا نْقُلْكُمْ إِنُّو اللَّهْ قَادِرْ يَعْمِلْ مِالحْجَرْ هَاذَا وْلَادْ لْإِبْرَاهِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","والفَاسْ تَوَّا مَحْطُوطْ عْلَى عْرُوقْ الشْجَرْ، وكُلْ شَجْرَة مَا تْجِيبِشْ غَلَّة بَاهْيَة تِتْقَصْ وتِتْرْمَى فِي النَّارْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","يَاخِي سِأْلُوهْ النَّاسْ: «مَالَا شْنُوَّة لَازِمْنَا نَعْمْلُوا؟» ");
INSERT INTO aeu_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","وهُوَّ جَاوِبْهُمْ: «الِّي عَنْدُو لِبْسْتِينْ يَعْطِي لِلِّي مَا عَنْدُوشْ، ولِّي عَنْدُو مَاكْلَة يَعْمِلْ نَفْسْ الشَّيْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","وجَاوِهْ زَادَا جْمَاعَة مَكَّاسَة بَاشْ يِتْعَمْدُوا وسِأْلُوهْ: «يَا مُعَلِّمْ، وأَحْنَا آشْ نَعْمْلُوا؟». ");
INSERT INTO aeu_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","يَاخِي قَالِلْهُمْ: «مَا تَاخْذُوشْ أَكْثِرْ مِلِّي لَازِمْ تَاخْذُوهْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","وسِأْلُوهْ جْمَاعَة مِالعَسْكِرْ: «وأَحْنَا، آشْ نَعْمْلُوا؟». جَاوِبْهُمْ: «مَا تَاخْذُوا فْلُوسْ حَتَّى حَدْ بِالقُوَّة، ومَا تِتْبَلَّاوْ عْلَى حَتَّى حَدْ، واسْتَكْفَاوْ بِشْهَارِيكُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","والنَّاسْ كَانُوا يِسْتَنَّاوْ فِي المَسِيحْ، والكُلْ كَانُوا يِسْأْلُوا فِي رْوَاحْهُمْ عْلَى يُوحَنَّا: «زَعْمَة هُوَّ المَسِيحْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","يَاخِي جَاوِبْ يُوحَنَّا وقَالْ لِلنَّاسْ الكُلْ: «آنَا نْعَمِّدْكُمْ بِالمَاء، آمَا بِشْ يْجِي الِّي هُوَّ أَعْظَمْ مِنِّي، وآنَا مَا نِسْتَاهِلْشْ نْكُونْ الخْدِيمْ الِّي يْحِلُّو رْبَايِطْ صَنْدَالُو، هُوَّ بِشْ يْعَمِّدْكُمْ بِالرُّوحْ القُدُسْ والنَّارْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ويْهِزْ المَذْرَى فِي يِدُّو ويِفْرِزْ صَابْتُو، يْلِمْ القَمْحْ فِي المَخْزِنْ مْتَاعُو، آمَا التْبِنْ يَحْرْقُو بْنَارْ مَا تِطْفَاشْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","وكَانْ يُوحَنَّا يَنْصَحْ فِي النَّاسْ إِبَّرْشَة حَاجَاتْ أُخْرِينْ ويْبَشِّرْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","آمَا لَامْ الوَالِي هِيرُودُسْ عْلَى خَاطْرُو عَرِّسْ بْهِيرُودِيَّا مَرْتْ خُوهْ، وعَالحَاجَاتْ الخَايْبَة الِّي عْمَلْهَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","وفُوقْ الشَّرْ الِّي عْمَلُو الكُلْ، زَادْ هِيرُودُسْ حَطْ يُوحَنَّا فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","وبَعْدْمَا تْعَمْدُوا النَّاسْ الكُلْ، تْعَمِّدْ يَسُوعْ زَادَا. ووَقْتِلِّي كَانْ يَسُوعْ يْصَلِّي، تْحَلِّتْ السْمَاء، ");
INSERT INTO aeu_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","وهْبَطْ عْلِيهْ الرُّوحْ القُدُسْ فِي شَكْلْ حْمَامَة، وجَاء صُوتْ مِالسْمَاء يْقُولْ: «إِنْتِ إِبْنِي الِّي نْحِبُّو، وآنَا فَرْحَانْ بِيكْ». ");
INSERT INTO aeu_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","وكِي بْدَا يَسُوعْ خِدْمْتُو كَانْ عُمْرُو قْرِيبْ 30 سْنَة، وكَانْ مَعْرُوفْ الِّي هُوَّ: وِلْدْ يُوسِفْ، وِلْدْ هَالِي، ");
INSERT INTO aeu_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","وِلْدْ مَتْثَاتْ، وِلْدْ لَاوِي، وِلْدْ مَلْكِي، وِلْدْ يَنَّا، وِلْدْ يُوسِفْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","وِلْدْ مَتَّاثِيَا، وِلْدْ عَامُوصْ، وِلْدْ نَاحُومْ، وِلْدْ حَسْلِي، وِلْدْ نَجَّايْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","وِلْدْ مَآثْ، وِلْدْ مَتَّاثِيَا، وِلْدْ شِمْعِي، وِلْدْ يُوسِفْ، وِلْدْ يَهُوذَا، ");
INSERT INTO aeu_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","وِلْدْ يُوحَنَّا، وِلْدْ رِيسَا، وِلْدْ زَرُبَّابِلْ، وِلْدْ شَأَلْتِئِيلْ، وِلْدْ نِيرِي، ");
INSERT INTO aeu_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","وِلْدْ مَلْكِي، وِلْدْ أَدِّي، وِلْدْ قُصَمْ، وِلْدْ أَلْمُودَامْ، وِلْدْ عِيرْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","وِلْدْ يُوسِي، وِلْدْ أَلِيعَازَرْ، وِلْدْ يُورِيمْ، وِلْدْ مَتْثَاتْ، وِلْدْ لَاوِي، ");
INSERT INTO aeu_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","وِلْدْ شَمْعُونْ، وِلْدْ يَهُوذَا، وِلْدْ يُوسِفْ، وِلْدْ يُونَانْ، وِلْدْ أَلِيَاقِيمْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","وِلْدْ مَلَيَا، وِلْدْ مَيْنَانْ، وِلْدْ مَتَّاثَا، وِلْدْ نَاثَانْ، وِلْدْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","وِلْدْ يَسَّى، وِلْدْ عُوبِيدْ، وِلْدْ بُوعَزْ، وِلْدْ سَلْمُونْ، وِلْدْ نَحْشُونْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","وِلْدْ عَمِّينَادَابْ، وِلْدْ أَرَامْ، وِلْدْ حَصْرُونْ، وِلْدْ فَارِصْ، وِلْدْ يَهُوذَا، ");
INSERT INTO aeu_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","وِلْدْ يَعْقُوبْ، وِلْدْ إِسْحَاقْ، وِلْدْ إِبْرَاهِيمْ، وِلْدْ تَارَحْ، وِلْدْ نَاحُورْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","وِلْدْ سَرُوجْ، وِلْدْ رَعُو، وِلْدْ فَالَجْ، وِلْدْ عَابِرْ، وِلْدْ شَالَحْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","وِلْدْ قِينَانْ، وِلْدْ أَرْفَكْشَادْ، وِلْدْ سَامْ، وِلْدْ نُوحْ، وِلْدْ لَامَكْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","وِلْدْ مَتُوشَالَحْ، وِلْدْ أَخْنُوخْ، وِلْدْ يَارِدْ، وِلْدْ مَهْلَلْئِيلْ، وِلْدْ قِينَانْ، ");
INSERT INTO aeu_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","وِلْدْ أَنُوشْ، وِلْدْ شِيثْ، وِلْدْ آدَمْ، مِنْ عَنْدْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ورْجَعْ يَسُوعْ مِنْ وَادْ الأُرْدُنْ وهُوَّ مِلْيَانْ بِالرُّوحْ القُدُسْ، يَاخِي هَزُّو الرُّوحْ لِلْخْلَاء ");
INSERT INTO aeu_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","لْمُدِّةْ 40 يُومْ، وإِبْلِيسْ كَانْ يْجَرِّبْ فِيهْ. وطُولْ المُدَّة هَاذِيكَا يَسُوعْ مَا كْلَا حَتَّى شَيْ، وكِي كِمْلُوا 40 يُومْ جَاعْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","يَاخِي قَالُّو إِبْلِيسْ: «كَانِكْ إِنْتِ إِبْنْ اللَّهْ، قُولْ لِلْحَجْرَة هَاذِي تْوَلِّي خُبْزْ». ");
INSERT INTO aeu_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","جَاوْبُو يَسُوعْ: «مَكْتُوبْ: \"الإِنْسَانْ مَا يْعِيشِشْ كَانْ بِالخُبْزْ، آمَا يْعِيشْ بْكُلْ كِلْمَة تُخْرُجْ مِنْ فُمْ اللَّهْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ومْبَعِّدْ طَلّْعُو إِبْلِيسْ فُوقْ جْبَلْ عَالِي، ووَرَّاهْ مَمَالِكْ الدِّنْيَا الكُلْ فِي لَحْظَة مِالزْمَانْ، ");
INSERT INTO aeu_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","وقَالُّو: «نَعْطِيكْ السُّلْطَة عَالمَمَالِكْ هَاذِي الكُلْ، وكُلْ مَا فِيهَا مِنْ مَجْدْ، عْلَى خَاطِرْ هِيَّ تِعْطَاتْلِي، وآنَا نَعْطِيهَا لِلِّي نْحِبْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","مَالَا، كَانْ إِنْتِ تُسْجُدْلِي، تْوَلِّي الكُلْهَا مْتَاعِكْ!». ");
INSERT INTO aeu_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","وجَاوْبُو يَسُوعْ: «مَكْتُوبْ: \"إِسْجِدْ لِلرَّبْ إِلَاهِكْ، واعْبْدُو هُوَّ وَحْدُو\"». ");
INSERT INTO aeu_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","وهَزُّو إِبْلِيسْ لْأُورْشَلِيمْ، ووَقْفُو عْلَى حَرْفْ أَعْلَى بْلَاصَة فِي الهَيْكِلْ، وقَالُّو: «كَانِكْ إِنْتِ إِبْنْ اللَّهْ أَرْمِي رُوحِكْ مِنْ هُونِي. ");
INSERT INTO aeu_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","عْلَى خَاطِرْ مَكْتُوبْ: \"اللَّهْ يْوَصِّي مْلَايِكْتُو بَاشْ يَحْفْظُوكْ\"، ");
INSERT INTO aeu_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","\"وهُومَا يْهِزُّوكْ عْلَى يْدِيهُمْ، بَاشْ سَاقِيكْ مَا تِتْضْرَبْشْ فِي حَجْرَة\"». ");
INSERT INTO aeu_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","وجَاوْبُو يَسُوعْ: «آمَا مَكْتُوبْ: \"مَا تْجَرَّبْشْ الرَّبْ إِلَاهِكْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","وبَعْدْمَا كَمِّلْ إِبْلِيسْ جَرْبُو بِالتَّجَارِبْ الكُلْ، خَلَّاهْ ومْشَى حَتَّى لِينْ تْجِي فُرْصَة أُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ورْجَعْ يَسُوعْ مِلْيَانْ بْقُوِّةْ الرُّوحْ لْمَنْطَقْةْ الجَلِيلْ، وتِشْهَرْ فِي البْلَايِصْ الِّي دَايْرَة بِيهَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","وكَانْ يْعَلِّمْ فِي مْعَابِدْ اليْهُودْ، وكَانُوا الكُلْ يْمَجْدُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","وجَاء لِمْدِينِةْ النَّاصْرَة الِّي تْرَبَّى فِيهَا، ونْهَارْ السِّبْتْ دْخَلْ كِي العَادَة لْمَعْبِدْ اليْهُودْ، ووْقِفْ بَاشْ يَقْرَى. ");
INSERT INTO aeu_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","يَاخِي عْطَاوِهْ كْتَابْ النَّبِيْ إِشَعْيَاءْ، وحَلُّو ولْقَى الآيَة الِّي مَكْتُوبْ فِيهَا: ");
INSERT INTO aeu_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","«رُوحْ الرَّبْ عْلِيَّا، عْلَى خَاطْرُو إِخْتَارْنِي بَاشْ نْبَشِّرْ المْسَاكِنْ، وبْعَثْنِي بَاشْ انَّادِي لِلْمَرْبُوطِينْ بِالحُرِّيَة، والعِمْيَانْ يْوَلِّيوْ يْشُوفُوا، ونْحَرِّرْ المَظْلُومِينْ، ");
INSERT INTO aeu_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ونْخَبِّرْ عَالوَقْتْ الِّي فِيهْ يْظَهِّرْ الرَّبْ نِعْمْتُو لِلنَّاسْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","وسَكِّرْ يَسُوعْ الكْتَابْ وعْطَاهْ لْخَادِمْ المَعْبِدْ وقْعَدْ. والنَّاسْ الِّي فِي المَعْبِدْ الكُلْ بْقَاوْ يُخْزْرُولُو. ");
INSERT INTO aeu_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","وبْدَا يْقُولِلْهُمْ: «اليُومْ تَحَقَّقْ الكْلَامْ الِّي سْمَعْتُوهْ». ");
INSERT INTO aeu_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","والحَاضْرِينْ الكُلْ كَانُوا يِمْدْحُوا فِيهْ وهُومَا مِتْعَجْبِينْ مِنْ كْلَامْ النِّعْمَة الِّي خَارِجْ مِنْ فُمُّو، وكَانُوا يْقُولُوا: « يَاخِي مُشْ هَاذَا وِلْدْ يُوسِفْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","يَاخِي قَالِلْهُمْ يَسُوعْ: «أَكِيدْ رَاكُمْ بِشْ تْقُولُولِي المَثَلْ هَاذَا: \"يَا طْبِيبْ إِشْفِي رُوحِكْ! ولِّي سْمَعْنَا بِيكْ عْمَلْتُو فِي كَفْرْنَاحُومْ، أَعْمْلُو هْنَا زَادَا فِي مْدِينْتِكْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","وزَادْ قَالْ: «نْقُلْكُمْ الحَقْ: مَا فَمَّة حَتَّى نَبِيْ مَقْبُولْ فِي بْلَادُو. ");
INSERT INTO aeu_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","وبِالحَقْ نْقُلْكُمْ: كَانُوا فَمَّة بَرْشَة نْسَاء هَجَّالَة فِي إِسْرَائِيلْ فِي وَقْتْ النَّبِيْ إِيلِيَّا، وَقْتِلِّي المْطَرْ قَعْدِتْ ثْلَاثَة سْنِينْ وسِتَّة شْهُرْ مَا صَبِّتْشْ حَتَّى لِينْ وَلَّاتْ فَمَّة مَجَاعَة كْبِيرَة فِي البْلَادْ الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","وإِيلِيَّا مَا تِبْعَثْشْ لْحَتَّى وَحْدَة فِيهُمْ، آمَا تِبْعَثّْ لْهَجَّالَة فِي مَدِينِةْ صِرْفَة فِي مَنْطَقْةْ صَيْدَا. ");
INSERT INTO aeu_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","وكَانْ فَمَّة بَرْشَة مُرْضَى بِالبْرَصْ فِي إِسْرَائِيلْ فِي وَقْتْ النَّبِيْ أَلِيشَعْ، ومَا طْهُرْ حَتَّى وَاحِدْ مِنْهُمْ كَانْ نُعْمَانْ السُّورِي». ");
INSERT INTO aeu_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","والحَاضْرِينْ فِي المَعْبِدْ الكُلْ تْغَشْشُوا بَرْشَة كِي سَمْعُوا الكْلَامْ هَاذَا، ");
INSERT INTO aeu_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","يَاخِي قَامُوا وخَرْجُوهْ لْبَرَّة مِالمْدِينَة، وهَزُّوهْ لْحَافِّةْ الجْبَلْ الِّي تِبْنَاتْ عْلِيهْ مْدِينِتْهُمْ بَاشْ يِرْمِيوَهْ مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","آمَا يَسُوعْ تْعَدَّى فِي وِسْطْهُمْ ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","وهْبَطْ لْكَفْرْنَاحُومْ الِّي هِيَّ مْدِينَة فِي مَنْطَقْةْ الجَلِيلْ، وكَانْ يْعَلِّمْ فِي النَّاسْ كُلْ نْهَارْ سِبْتْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","وقَعْدُوا بَاهْتِينْ مِنْ تَعْلِيمُو، عْلَى خَاطِرْ كْلَامُو كَانْ فِيهْ سُلْطَة. ");
INSERT INTO aeu_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","وفِي المَعْبِدْ كَانْ فَمَّة رَاجِلْ سَاكْنُو رُوحْ شِرِّيرْ، بْدَا يْصِيحْ بْصُوتْ عَالِي: ");
INSERT INTO aeu_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«آهْ، آشْ تْحِبْ مِنَّا يَا يَسُوعْ النَّاصْرِي؟ جِيتْ بَاشْ تَقْضِي عْلِينَا؟ آنَا نَعْرِفْ إِنْتِ شْكُونْ: إِنْتِ القُدُّوسْ الِّي بَعْثُو اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","يَاخِي يَسُوعْ نْزَرْ عْلِيهْ وقَالُّو: «أُسْكُتْ وأُخْرِجْ مِنُّو». يَاخِي الشِّيطَانْ صْرَعْ الرَّاجِلْ فِي وِسْطْ النَّاسْ وخْرَجْ مِنُّو مِنْ غِيرْ مَا ضَرُّو. ");
INSERT INTO aeu_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","وإِسْتَغْرْبُوا النَّاسْ الكُلْ وقَالُوا لِبْعَضْهُمْ: «شْنُوَّة الكْلَامْ هَاذَا؟ رَاهُو يُؤْمُرْ فِي الأَرْوَاحْ الشِّرِّيرَة بْسُلْطَة وبْقُوَّة وهُومَا يُخْرْجُوا!». ");
INSERT INTO aeu_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","وتِشْهَرْ يَسُوعْ فِي البْلَايِصْ مْتَاعْ المَنْطْقَة هَاذِيكَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ومْبَعِّدْ، خْرَجْ مِالمَعْبِدْ ودْخَلْ لْدَارْ سِمْعَانْ. وحْمَاةْ سِمْعَانْ كَانْ عَنْدْهَا بَرْشَة سْخَانَة، يَاخِي طَلْبُوا مِنُّو بَاشْ يِشْفِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","قْرُبِّلْهَا يَسُوعْ وعْطَى أَمْرْ لِلسْخَانَة، والسْخَانَة تْنَحَّاتِلْهَا، وبِالوَقْتْ قَامِتْ وبْدَاتْ تِخْدِمْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ووَقْتِلِّي غُرْبِتْ الشَّمْسْ، كُلْ وَاحِدْ عَنْدُو مْرِيضْ مَهْمَا كَانْ نُوعْ مَرْضُو جَابُو لْيَسُوعْ، وهُوَّ حَطْ يْدِيهْ عْلَى كُلْ وَاحِدْ مِنْهُمْ وشْفَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","وخَرْجُوا الشْوَاطِنْ مِنْ بَرْشَة مِنْهُمْ وهُومَا يْصِيحُوا: «إِنْتِ إِبْنْ اللَّهْ!». آمَا يَسُوعْ نْزَرْ عْلِيهُمْ ومَا خَلَّاهُمْشْ يِتْكَلْمُوا، عْلَى خَاطِرْهُمْ عَرْفُوا الِّي هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","وكِي طْلَعْ النْهَارْ، خْرَجْ يَسُوعْ ومْشَى لِبْلَاصَة خْلَاء، ولَوْجُوا عْلِيهْ النَّاسْ حَتَّى لِينْ لْقَاوَهْ وشَدُّوا فِيهْ صْحِيحْ بَاشْ مَا يِمْشِيشْ مِنْ بَحْذَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","آمَا هُوَّ قَالِلْهُمْ: «لَازِمْنِي نِمْشِي لِلْمُدُنْ الأُخْرِينْ زَادَا ونْبَشَّرْهُمْ بْمَمْلَكْةْ اللَّهْ، عْلَى خَاطِرْ اللَّهْ بْعَثْنِي بَاشْ نَعْمِلْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ومْشَى يْبَشِّرْ فِي المْعَابِدْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","وفِي نْهَارْ مِالنْهَارَاتْ، كَانْ يَسُوعْ وَاقِفْ عْلَى شَطْ بُحَيْرِةْ جَنِّيسَارْتْ، والنَّاسْ كَانُوا مَلْمُومِينْ بِيهْ بَاشْ يِسْمْعُوا كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","وشَافْ زُوزْ فْلَايِكْ عَالشَّطْ، هَبْطُوا مِنْهُمْ الصَّيَّادَة بَاشْ يَغْسْلُوا شْبَاكْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","يَاخِي رْكِبْ فِي وَحْدَة مِنْهُمْ الِّي هِيَّ مْتَاعْ سِمْعَانْ، وقَالُّو يِبْعِدْ عَالشَّطْ شْوَيَّة، ومْبَعِّدْ قْعَدْ وبْدَا يْعَلِّمْ فِي النَّاسْ مِالفْلُوكَة. ");
INSERT INTO aeu_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","وكِي كَمِّلْ كْلَامُو قَالْ لْسِمْعَانْ: «أُدْخُلْ لِلْغْرِيقْ، وإِرْمِيوْ شْبَاكُّمْ واصْطَادُوا». ");
INSERT INTO aeu_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","يَاخِي جَاوْبُو سِمْعَانْ: «يَا سِيدْنَا رَانَا تْعِبْنَا اللِّيلْ بْكُلُّو ومَا اصْطَدْنَا شَيْ، آمَا عْلَى كِلْمْتِكْ هَانِي بِشْ نَرْمِي الشْبَاكْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","وكِي عَمْلُوا بِكْلَامُو، اصْطَادُوا بَرْشَة حُوتْ لِينْ شْبَاكْهُمْ بْدَاتْ تِتْقَطَّعْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","وَلَّاوْ شَاوْرُوا بِيْدِيهُمْ لِصْحَابْهُمْ الِّي فِي الفْلُوكَة الأُخْرَى بَاشْ يْجِيوْ يْعَاوْنُوهُمْ، وجَاوْ وعَبَّاوْ الزُّوزْ فْلَايِكْ لِينْ قْرِيبْ يُغْرْقُوا. ");
INSERT INTO aeu_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","وكِي شَافْ سِمْعَانْ بُطْرُسْ الِّي صَارْ، تِرْمَى قُدَّامْ رْكَايِبْ يَسُوعْ وقَالْ: «يَا رَبْ، إِبْعِدْ عْلِيَّا، رَانِي إِنْسَانْ مُذْنِبْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","وكَانْ هُوَّ ولِّي مْعَاهْ مِتْعَجْبِينْ مِنْ كُثْرِةْ الحُوتْ الِّي اصْطَادُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","وكَانْ نَفْسْ الشَّيْ بِالنِّسْبَة لْيَعْقُوبْ ويُوحَنَّا وْلَادْ زَبَدِي الِّي هُومَا شُرْكَا مْعَ سِمْعَانْ. وقَالْ يَسُوعْ لْسِمْعَانْ: «مَا تْخَافِشْ، مِنْ تَوَّا بِشْ تْوَلِّي صَيَّادْ نَاسْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","وكِي رَجْعُوا بِالزُّوزْ فْلَايِكْ لِلشَّطْ، خَلَّاوْ كُلْ شَيْ وتَبْعُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ووَقْتِلِّي كَانْ يَسُوعْ فِي مْدِينَة مِالمُدُنْ، جَاهْ رَاجِلْ بَدْنُو الكُلْ مِلْيَانْ بِالبْرَصْ، وأَوِّلْ مَا شَافْ يَسُوعْ سْجِدْلُو وتْشَحْتُو وقَالْ: «يَا سِيدِي، كَانْ إِنْتِ تْحِبْ، تْنَجِّمْ اطَّهِّرْنِي مِالبْرَصْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","يَاخِي مَدْ يَسُوعْ يِدُّو ومَسُّو وقَالُّو: «أَيْ نْحِبْ، أُطْهُرْ!». وبِالوَقْتْ تْنَحَّى عْلِيهْ البْرَصْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ووَصَّاهْ يَسُوعْ بَاشْ مَا يْقُولْ لْحَدْ وقَالُّو: «إِمْشِي لِلْكَاهِنْ خَلِّيهْ يْشُوفِكْ، وأَعْطِي عْلَى تَطْهِيرِكْ الِّي وَصَّى بِيهْ مُوسَى، خَلِّيهْ يْكُونْ أَمَارَة لِيهُمْ إِنِّكْ تِشْفِيتْ مِالمْرَضْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","آمَا أَخْبَارْ يَسُوعْ زَادِتْ تْنَشْرِتْ أَكْثِرْ، وجَاوَهْ بَرْشَة نَاسْ بَاشْ يِسْمْعُوهْ ويِتْشْفَاوْ مِنْ أَمْرَاضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","آمَا هُوَّ بَرْشَة مَرَّاتْ كَانْ يِمْشِي لِلْخْلَاء بَاشْ يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","وفِي نْهَارْ مِالنْهَارَاتْ، كَانْ يَسُوعْ يْعَلِّمْ، وكَانُوا بِينْ الحَاضْرِينْ جْمَاعَة مِالفِرِّيسِيِّينْ ومِلِّي يْعَلْمُوا فِي الشَّرِيعَة، جَاوْ مِنْ كُلْ دَشْرَة فِي مَنْطَقْةْ الجَلِيلْ واليَهُودِيَّة ومِنْ أُورْشَلِيمْ، وكَانِتْ قُدْرِةْ اللَّهْ تِشْفِي المُرْضَى عْلَى يْدِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","وإِذَا بِيهْ جَاوْ جْمَاعَة هَازِّينْ رَاجِلْ مَشْلُولْ عْلَى فَرْشْ، وحَاوْلُوا يُدْخْلُوا بِيهْ ويْحُطُّوهْ قُدَّامُو. ");
INSERT INTO aeu_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","وكِي مَا نَجْمُوشْ يُدْخْلُوا مِنْ كُثْرِةْ النَّاسْ، طَلْعُوا لِلسْطَحْ ونَقْبُوهْ وهَبْطُوا المَشْلُولْ بِالفَرْشْ مْتَاعُو وحَطُّوهْ فِي الوِسْطْ قُدَّامْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","وكِي شَافْ يَسُوعْ إِيمَانْهُمْ قَالْ لِلْمَشْلُولْ: «يَا رَاجِلْ، ذْنُوبِكْ تْغِفْرِتْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","يَاخِي بْدَاوْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ يْقُولُوا فِي قْلُوبْهُمْ: «شْكُونُو هَاذَا الِّي قَاعِدْ يْقُولْ فِي كْلَامْ كُفْرْ؟ شْكُونْ بِخْلَافْ اللَّهْ وَحْدُو يْنَجِّمْ يِغْفِرْ الذْنُوبْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","وعْرَفْ يَسُوعْ فَاشْ يْخَمُّوا يَاخِي قَالِلْهُمْ: «عْلَاشْ تْخَمُّوا هَكَّا فِي قْلُوبْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","آنَاهُو الأَسْهِلْ؟ إِنُّو يِتْقَالْ: \"ذْنُوبِكْ تْغِفْرِتْ\"، وَلَّا يِتْقَالْ: \"قُومْ وإِمْشِي\"؟ ");
INSERT INTO aeu_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","آمَا هَانِي بِشْ نْوَرِّيكُمْ الِّي إِبْنْ الإِنْسَانْ عَنْدُو السُّلْطَة فِي الأَرْضْ بَاشْ يِغْفِرْ الذْنُوبْ». يَاخِي قَالْ لِلْمَشْلُولْ: «نْقُلِّكْ: قُومْ! هِزْ فَرْشِكْ ورَوَّحْ لْدَارِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","وبِالوَقْتْ قَامْ قُدَّامْهُمْ وهَزْ فَرْشُو الِّي كَانْ رَاقِدْ عْلِيهْ، ورَوَّحْ لْدَارُو وهُوَّ يْمَجِّدْ فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","والنَّاسْ الكُلْ قَعْدُوا بَاهْتِينْ، ومَجْدُوا اللَّهْ وقَالُوا وهُومَا مَاكِنْهُمْ الخُوفْ: «اليُومْ رِينَا عْجَايِبْ!». ");
INSERT INTO aeu_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","وبَعْدْ هَاذَا خْرَجْ يَسُوعْ، وشَافْ مَكَّاسْ إِسْمُو لَاوِي قَاعِدْ فِينْ يْلِمُّوا فِي المَكْسْ، يَاخِي قَالُّو: «تَبَّعْنِي!». ");
INSERT INTO aeu_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","يَاخِي قَامْ وخَلَّى كُلْ شَيْ وتَبْعُو. ");
INSERT INTO aeu_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","وعْمَلُّو لَاوِي ضْيَافَة كْبِيرَة فِي دَارُو، وكَانُوا فَمَّة بَرْشَة مَكَّاسَة ونَاسْ أُخْرِينْ قَاعْدِينْ يَاكْلُوا مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","وبْدَاوْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ يِتْشَكَّاوْ عْلَى تْلَامْذِةْ يَسُوعْ وقَالُولْهُمْ: «عْلَاشْ تَاكْلُوا وتُشْرْبُوا مْعَ المَكَّاسَة والمُذْنْبِينْ؟» ");
INSERT INTO aeu_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","يَاخِي جَاوِبْهُمْ يَسُوعْ: «المُرْضَى هُومَا الِّي يَحْتَاجُوا لِلطْبِيبْ مُشْ الصْحَاحْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","آنَا مَا جِيتِشْ لِلصَّالْحِينْ، آمَا جِيتْ نِدْعِي فِي الْمُذْنْبِينْ بَاشْ يْتُوبُوا». ");
INSERT INTO aeu_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","يَاخِي قَالُولُو: «تْلَامْذِةْ يُوحَنَّا يْصُومُوا ويْصَلِّيوْ بَرْشَة، وتْلَامْذِةْ الفِرِّيسِيِّينْ يَعْمْلُوا نَفْسْ الشَّيْ، آمَا تْلَامِذْتِكْ يَاكْلُوا ويُشْرْبُوا». ");
INSERT INTO aeu_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","قَالِلْهُمْ يَسُوعْ: «يَاخِي تْنَجْمُوا تْلِزُّوا المِسْتَدْعِينْ لِلْعِرْسْ بَاشْ يْصُومُوا والعْرُوسْ مْعَاهُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","آمَا بِشْ يْجِي الوَقْتْ الِّي يِتْنَحَّى فِيهْ العْرُوسْ مِنْ بَحْذَاهُمْ، ووَقْتْهَا يْصُومُوا». ");
INSERT INTO aeu_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","وقَالِلْهُمْ المَثَلْ هَاذَا: «حَتَّى حَدْ مَا يْرَقَّعْ لِبْسَة قْدِيمَة بْطَرْفْ قْمَاشْ جْدِيدْ، عْلَى خَاطِرْ القْمَاشْ الجْدِيدْ بِشْ يِتْقَطَّعْ والرُّقْعَة بِيدْهَا مُشْ بِشْ تْوَاتِي القْمَاشْ القْدِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ومَا فَمَّة حَتَّى وَاحِدْ يْحُطْ شْرَابْ جْدِيدْ فِي ڨِرْبَة قْدِيمَة، بَاشْ الشْرَابْ الجْدِيدْ مَا يِفْلَقْشْ الڨِرْبَة ويَخْسِرْ الشْرَابْ والڨِرْبَة. ");
INSERT INTO aeu_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","آمَا الشْرَابْ الجْدِيدْ يِتْحَطْ فِي ڨِرْبَة جْدِيدَة. ");
INSERT INTO aeu_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ومَا فَمَّة حَدْ يُشْرُبْ الشْرَابْ المْعَتَّقْ ويْلَوِّجْ عَالجْدِيدْ، عْلَى خَاطِرُو يْقُولْ: \"المْعَتَّقْ أَحْسِنْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","وفِي نْهَارْ سِبْتْ، تْعَدَّى يَسُوعْ وِسْطْ هْنَاشِرْ، وبْدَاوْ تْلَامِذْتُو يْنَحِّيوْ فِي السْبُولْ ويُفْرْكُوهُمْ بِينْ يْدِيهُمْ ويَاكْلُوا. ");
INSERT INTO aeu_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","يَاخِي جْمَاعَة مِالفِرِّيسِيِّينْ قَالُولْهُمْ: «عْلَاشْ تَعْمْلُوا حَاجَاتْ مَا يِلْزِمْشْ تِتْعْمَلْ نْهَارْ السِّبْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","جَاوِبْهُمْ يَسُوعْ: «يَاخِي مَا قْرِيتُوشْ شْنِيَّة عْمَلْ دَاوِدْ هُوَّ ولِّي مْعَاهْ وَقْتِلِّي جَاعُوا، ");
INSERT INTO aeu_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","كِيفَاشْ دْخَلْ لْخِيمِةْ الإِجْتِمَاعْ، وخْذَا مِالخُبْزْ الِّي يِتْقَدِّمْ قُرْبَانْ لِلَّهْ وكْلَا مِنُّو، رَغْمِلِّي مَا كَانْ مَسْمُوحْ كَانْ لِلْكَهَنَة بَاشْ يَاكْلُوا مِنُّو، وزَادْ عْطَى مِنُّو لِلِّي مْعَاهْ؟» ");
INSERT INTO aeu_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ومْبَعِّدْ قَالِلْهُمْ: «إِبْنْ الإِنْسَانْ هُوَّ رَبْ السِّبْتْ». ");
INSERT INTO aeu_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","وفِي سِبْتْ آخِرْ دْخَلْ يَسُوعْ لْمَعْبِدْ اليْهُودْ وبْدَا يْعَلِّمْ، وكَانْ فَمَّة رَاجِلْ غَادِي يِدُّو اليْمِينْ مَشْلُولَة. ");
INSERT INTO aeu_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","وكَانُوا عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ يْرَاقْبُوا فِي يَسُوعْ بَاشْ يْشُوفُوهْ كَانْ يِشْفِي نْهَارْ السِّبْتْ. وهَكَّاكَا يْنَجْمُوا يِتْهْمُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","وعْرَفْ يَسُوعْ فَاشْ يْخَمُّوا، يَاخِي قَالْ لِلرَّاجِلْ الِّي يِدُّو مَشْلُولَة: «قُومْ وآقِفْ فِي الوِسْطْ» والرَّاجِلْ قَامْ ووْقِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","وقَالِلْهُمْ يَسُوعْ: «نِسْإِلْكُمْ سُؤَالْ: زَعْمَة حْلَالْ فِي نْهَارْ السِّبْتْ، نَعْمْلُوا الخِيرْ وَلَّا الشَّرْ؟ نْمَنْعُوا إِنْسَانْ وَلَّا نْخَلِّيوِهْ يْمُوتْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","وبَعْدْمَا خْزَرِّلْهُمْ الكُلْ، قَالْ لِلرَّاجِلْ: «مِدْ يِدِّكْ». وكِي مَدْهَا رَجْعِتْ يِدُّو صْحِيحَة. ");
INSERT INTO aeu_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","يَاخِي تْغَشْشُوا بَرْشَة، وبْدَاوْ يِتْشَاوْرُوا شْنِيَّة يَعْمْلُوا فِي يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","وفِي الأَيَّامَاتْ هَاذِيكَا، طْلَعْ لِلجْبَلْ بَاشْ يْصَلِّي، وعَدَّا اللِّيلْ الكُلْ وهُوَّ يْصَلِّي لِلَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","وكِي طْلَعْ الصْبَاحْ، عَيِّطْ لِتْلَامِذْتُو واخْتَارْ مِنْهُمْ أَثْنَاشِنْ وَاحِدْ وسَمَّاهُمْ رُسُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","وهُومَا: سِمْعَانْ الِّي سَمَّاهْ زَادَا بُطْرُسْ، وأَنْدَرَاوُسْ خُوهْ، ويَعْقُوبْ، ويُوحَنَّا، وفِيلِۑُّسْ، وبَرْثُلْمَاوُسْ، ");
INSERT INTO aeu_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ومَتَّى، وتُومَا، ويَعْقُوبْ وِلْدْ حَلْفَى، وسِمْعَانْ الِّي مْسَمِّينُو الغَيُورْ، ");
INSERT INTO aeu_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ويَهُوذَا وِلْدْ يَعْقُوبْ، ويَهُوذَا الإِسْخَرْيُوطِي الِّي بِشْ يْخُونُو. ");
INSERT INTO aeu_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ومْبَعِّدْ هْبَطْ مْعَاهُمْ مِالجْبَلْ، ووْقِفْ فِي بَطْحَة. وكَانْ فَمَّة بَرْشَة مِنْ تْلَامِذْتُو حَاضْرِينْ ومْعَاهُمْ بَرْشَة نَاسْ مِاليَهُودِيَّة وأُورْشَلِيمْ وسَاحِلْ صُورْ وصَيْدَا. ");
INSERT INTO aeu_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","جَاوْ بَاشْ يِسْمْعُوهْ ويِتْشْفَاوْ مِنْ أَمْرَاضْهُمْ، وحَتَّى الِّي كَانِتْ تْعَذَّبْ فِيهُمْ الأَرْوَاحْ الشِّرِّيرَة تِشْفَاوْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","والنَّاسْ الكُلْ كَانُوا يْحَاوْلُوا بَاشْ يْمِسُّوهْ، عْلَى خَاطِرْ كَانِتْ فَمَّة قُوَّة تُخْرُجْ مِنُّو وتِشْفِيهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","وهَزْ يَسُوعْ عِينِيهْ وخْزَرْ لِتْلَامِذْتُو وقَالْ: «صَحَّة لِيكُمْ يَا مْسَاكِنْ، عْلَى خَاطِرْ مَمْلَكْةْ اللَّهْ هِيَّ لِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","صَحَّة لِيكُمْ يَلِّي تَوَّا جِيعَانِينْ، عْلَى خَاطِرْكُمْ بِشْ تِشْبْعُوا. صَحَّة لِيكُمْ يَلِّي تَوَّا تِبْكِيوْ، عْلَى خَاطِرْكُمْ بِشْ تَضْحْكُوا. ");
INSERT INTO aeu_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","صَحَّة لِيكُمْ وَقْتِلِّي يِكْرْهُوكُمْ النَّاسْ ويْطَرْدُوكُمْ ويْعَايْرُوكُمْ، ويْقُولُوا عْلِيكُمْ كْلَامْ خَايِبْ عْلَى خَاطِرْكُمْ اتَّبْعُوا فِي إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","إِفْرْحُوا فِي النْهَارْ هَاذَاكَا وازْهَاوْ، عْلَى خَاطِرْ أَجْرْكُمْ عْظِيمْ فِي السْمَاء. رَاهُو هَكَّا عَمْلُوا جْدُودْهُمْ مْعَ الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","آمَا يَا وِيلْكُمْ يَا غُنْيَا، عْلَى خَاطِرْكُمْ خْذِيتُوا بَايْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","يَا وِيلْكُمْ يَلِّي تَوَّا شَبْعَانِينْ، عْلَى خَاطِرْ بِشْ تْجُوعُوا. يَا وِيلْكُمْ يَلِّي تَوَّا تَضْحْكُوا، عْلَى خَاطِرْ بِشْ تَحْزْنُوا وتْنَوْحُوا. ");
INSERT INTO aeu_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","يَا وِيلْكُمْ إِذَا النَّاسْ الكُلْ مَدْحُوكُمْ. رَاهُو جْدُودْهُمْ عَمْلُوا نَفْسْ الشَّيْ مْعَ الأَنْبِيَاءْ الكَذَّابِينْ». ");
INSERT INTO aeu_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«آمَا إِنْتُومَا يَلِّي تِسْمْعُوا فِيَّا، نْقُلْكُمْ: حِبُّوا أَعْدَاءْكُمْ، أَعْمْلُوا الخِيرْ مْعَ الِّي يِكْرْهُوكُمْ، ");
INSERT INTO aeu_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","بَارْكُوا الِّي يَلْعْنُوكُمْ، وإِدْعِيوْ بِالخِيرْ لِلِّي يَعْمْلُوا مْعَاكُمْ الخَايِبْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ولِّي يَضْرْبِكْ عْلَى خَدِّكْ، زِيدْ دَوَّرْلُو خَدِّكْ الآخِرْ. ولِّي يْنَحِّيلِكْ بَرْنُوسِكْ مَا تْشِدِّشْ عْلِيهْ جِبْتِكْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ولِّي يُقْصْدِكْ فِي حَاجَة أَعْطِيهَالُو، ولِّي يَاخِذْلِكْ حَاجْتِكْ مَا اطَّالْبُوشْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","كِيمَا تْحِبُّوا النَّاسْ يْعَامْلُوكُمْ، عَامْلُوهُمْ إِنْتُومَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","إِذَا تْحِبُّوا الِّي يْحِبُّوكُمْ، شْنِيَّة الحَاجَة الزَّايْدَة الِّي عْمَلْتُوهَا؟ حَتَّى المُذْنْبِينْ يْحِبُّوا الِّي يْحِبُّوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","وإِذَا عْمَلْتُوا الخِيرْ مْعَ الِّي يَعْمْلُوا مْعَاكُمْ فِي الخِيرْ، شْنِيَّة الحَاجَة الزَّايْدَة الِّي عْمَلْتُوهَا؟ حَتَّى المُذْنْبِينْ يَعْمْلُوا هَكَّا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","وإِذَا تْسَلْفُوا الِّي تَعْرْفُوهُمْ بِشْ يْرَجْعُولْكُمْ، شْنِيَّة الحَاجَة الزَّايْدَة الِّي عْمَلْتُوهَا؟ حَتَّى المُذْنْبِينْ يْسَلْفُوا المُذْنْبِينْ وهُومَا مِسْتَنِّينْ يْرَجْعُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","آمَا حِبُّوا أَعْدَاءْكُمْ وأَعْمْلُوا مْعَاهُمْ البَاهِي، وسَلْفُوا مِنْ غِيرْ مَا تِسْتَنَّاوْ إِنُّو الحَاجَة تِرْجْعِلْكُمْ، وهَكَّا يْكُونْ أَجْرْكُمْ عْظِيمْ وتْكُونُوا وْلَادْ العَالِي، الِّي يِنْعِمْ حَتَّى عْلَى نَاكِرْ الجْمِيلْ والشِّرِّيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","مَالَا أَرْحْمُوا كِيمَا بُوكُمْ يَرْحِمْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«مَا تِتْهْمُوشْ النَّاسْ بَاشْ مَا يِتْهْمُوكُمْشْ، مَا تُحْكْمُوشْ عَالنَّاسْ بَاشْ مَا يِتْحْكَمْشْ عْلِيكُمْ، إِغْفْرُوا يِتْغْفِرِّلْكُمْ، ");
INSERT INTO aeu_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","أَعْطِيوْ يِتْعْطَالْكُمْ، كِيلْ وَافِي ومَرْصُوصْ وفَايِضْ يِتْصَبِّلْكُمْ فِي حْجِرْكُمْ، عْلَى خَاطِرْ بِالكِيلْ الِّي تْكَيْلُوا بِيهْ يِتْكَيْلِلْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","وعْطَاهُمْ يَسُوعْ مَثَلْ: «يْنَجَّمْشِي أَعْمَى يْقُودْ أَعْمَى؟ مُشْ بِشْ يْطِيحُوا الزُّوزْ فِي حُفْرَة؟ ");
INSERT INTO aeu_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","مَا فَمَّاشْ تِلْمِيذْ أَعْظِمْ مِالمُعَلِّمْ مْتَاعُو، آمَا التِّلْمِيذْ الِّي يْكَمِّلْ تَعْلِيمُو يْوَلِّي كِيمَا المُعَلِّمْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","«وعْلَاشْ تْشُوفْ القَشَّة الِّي فِي عِينْ خُوكْ، واللُّوحَة الِّي فِي عِينِكْ مَا تْشُوفْهَاشْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","وَلَّا كِيفَاشْ تْنَجِّمْ تْقُولْ لْخُوكْ: \"يَا خُويَا، خَلِّينِي انَّحِّيلِكْ القَشَّة مِنْ عِينِكْ\" وإِنْتِ مَاكِشْ قَاعِدْ تْشُوفْ فِي اللُّوحَة الِّي فِي عِينِكْ؟ يَا مُنَافِقْ! نَحِّي اللُّوحَة مِنْ عِينِكْ قْبَلْ، وَقْتْهَا تْوَلِّي تْشُوفْ بِالڨْدَا وتْنَجِّمْ تْنَحِّي القَشَّة مِنْ عِينْ خُوكْ». ");
INSERT INTO aeu_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«الشَّجْرَة البَاهْيَة مَا تَعْطِيشْ غَلَّة خَايْبَة، والشَّجْرَة الخَايْبَة مَا تَعْطِيشْ غَلَّة بَاهْيَة. ");
INSERT INTO aeu_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","كُلْ شَجْرَة تِتْعْرَفْ مِنْ غَلِّتْهَا: مَا يِجْنِيوِشْ الكَرْمُوسْ مِالشُّوكْ، ومَا يْنَحِّيوِشْ العْنِبْ مِنْ شَجْرِةْ العُلِّيڨْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","الإِنْسَانْ الصَّالَحْ يْخَرِّجْ الحَاجَاتْ الصَّالْحَة مِالكِنْزْ الصَّالَحْ الِّي فِي قَلْبُو، والإِنْسَانْ الخَايِبْ يْخَرِّجْ الحَاجَاتْ الخَايْبَة مِالكِنْزْ الخَايِبْ الِّي فِي قَلْبُو. عْلَى خَاطِرْ اللْسَانْ يَنْطَقْ بِلِّي يْفِيضْ مِالقَلْبْ». ");
INSERT INTO aeu_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«كِيفَاشْ تْعَيْطُولِي \"يَا رَبْ، يَا رَبْ\" وإِنْتُومَا مَا تَعْمْلُوشْ بِلِّي نْقُولْ فِيهْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","هَاوْ بِشْ نْوَرِّيكُمْ لِشْكُونْ يْشَبَّهْ الِّي يْجِينِي ويِسْمَعْ كْلَامِي ويَعْمِلْ بِيهْ: ");
INSERT INTO aeu_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","يْشَبَّهْ لْإِنْسَانْ بْنَى دَارْ، حْفَرِّلْهَا وغَرَّقْ وحَطْ السَّاسْ عَالحْجَرْ. وكِي فَاضْ الوَادْ وهَدْ عْلِيهَا المَاء بْقُوَّة، مَا نَجَّمْشْ يْزَعْزَعْهَا عْلَى خَاطِرْ سَاسْهَا كَانْ مِبْنِي عَالحْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","وآمَا الِّي سْمَعْ كْلَامِي ومَا عْمَلْشْ بِيهْ، يْشَبَّهْ لْإِنْسَانْ بْنَى دَارُو عَالتْرَابْ مِنْ غِيرْ سَاسْ. وكِي فَاضْ عْلِيهَا الوَادْ وهَدْ عْلِيهَا المَاء بْقُوَّة طَاحِتْ بِالوَقْتْ، وتْهَدِّتْ الكُلْ!» ");
INSERT INTO aeu_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","وبَعْدْمَا كَمِّلْ يَسُوعْ كْلَامُو لِلشَّعْبْ، دْخَلْ لِمْدِينِةْ كَفْرْنَاحُومْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","وكَانْ فَمَّة ضَابِطْ رُومَانِي عَنْدُو خْدِيمْ عْزِيزْ عْلِيهْ مْرِيضْ وقْرِيبْ يْمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","وكِي سْمَعْ عْلَى يَسُوعْ، بْعَثْلُو جْمَاعَة مِنْ شْيُوخْ اليْهُودْ بَاشْ يُطْلْبُوا مِنُّو يْجِي ويِشْفِيلُو خْدِيمُو. ");
INSERT INTO aeu_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","وكِي وِصْلُوا لْيَسُوعْ، شَدُّوا فِيهْ صْحِيحْ وقَالُولُو: «رَاهُو يِسْتَاهِلْ إِنِّكْ تَعْاوْنُو فِلِّي طَلْبُو مِنِّكْ، ");
INSERT INTO aeu_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","عْلَى خَاطْرُو يْحِبْ شَعْبْنَا وهُوَّ الِّي بْنَالْنَا المَعْبِدْ». ");
INSERT INTO aeu_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","يَاخِي يَسُوعْ مْشَى مْعَاهُمْ. وكِي قْرُبْ مِالدَّارْ، بْعَثْلُو الضَّابِطْ الرُّومَانِي مْعَ جْمَاعَة صْحَابُو يْقُلُّو: «يَا سِيدِي، مَا اتَّعَّبْشْ رُوحِكْ، آنَا مَا نِسْتَاهِلْشْ إِنِّكْ تُدْخُلْ تَحْتْ سْقَفْ دَارِي. ");
INSERT INTO aeu_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","هَاذَاكَا عْلَاشْ مَا تْجَرَّأْتِشْ إِنِّي نْجِيكْ آنَا بِيدِي، آمَا قُولْ كِلْمَة بَرْكَة تَوْ يَبْرَى خْدِيمِي. ");
INSERT INTO aeu_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","عْلَى خَاطِرْ آنَا زَادَا عَنْدِي شْكُونْ يُحْكُمْ فِيَّا وعَنْدِي عْسَاكِرْ نُحْكُمْ فِيهُمْ. نْقُولْ لْوَاحِدْ \"إِمْشِي!\" يِمْشِي، ولْغِيرُو \"إِيجَا!\" يْجِي، ونْقُولْ لِخْدِيمِي \"أَعْمِلْ هَكَّا!\" يَعْمِلْ». ");
INSERT INTO aeu_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","وكِي سْمَعْ يَسُوعْ الكْلَامْ هَاذَا، تْعَجِّبْ وقَالْ لِلِّي يْتَبْعُوا فِيهْ: «نْحِبْ نْقُولِلْكُمْ إِنُّو فِي بَنِي إِسْرَائِيلْ الكُلْ مَا لْقِيتْ حَدْ عَنْدُو إِيمَانْ عْظِيمْ كِيمَا هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","وكِي رَجْعُوا أَصْحَابْ الضَّابِطْ الرُّومَانِي لِلدَّارْ، لْقَاوْ الِّي الخْدِيمْ بْرَا. ");
INSERT INTO aeu_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ومِنْ غُدْوَة، مْشَى يَسُوعْ لِمْدِينَة إِسْمْهَا نَايِينْ ومْعَاهْ تْلَامِذْتُو وبَرْشَة نَاسْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","وكِي قْرُبْ مِنْ بَابْ المْدِينَة، شَافْ وَاحِدْ مِيِّتْ خَارْجِينْ بِيهْ، وكَانْ هُوَّ الوْلَيِّدْ الوَحِيدْ لِمْرَا هَجَّالَة، وكَانْ مْعَاهَا بَرْشَة مِنْ أَهْلْ المْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","وكِي شَافْهَا يَسُوعْ، سْخِفْ عْلِيهَا وقَالِلْهَا: «مَا تِبْكِيشْ!». ");
INSERT INTO aeu_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","وقْرُبْ مِالنَّعْشْ ومَسُّو، يَاخِي وِقْفُوا الِّي كَانُوا هَازِّينُو، وقَالْ: «يَا وْلِدْ، نْقُلِّكْ: قُومْ!». ");
INSERT INTO aeu_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","تْقَعَّدْ المِيِّتْ وبْدَا يِتْكَلِّمْ، يَاخِي رَجْعُو يَسُوعْ لْأُمُّو. ");
INSERT INTO aeu_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","والنَّاسْ الكُلْ خَافُوا، ومَجْدُوا اللَّهْ وقَالُوا: «ظْهُرْ بِينَاتْنَا نَبِيْ عْظِيمْ، اللَّهْ جَاء بَاشْ يْعَاوِنْ شَعْبُو». ");
INSERT INTO aeu_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","وتِنْشَرْ الخْبَرْ هَاذَا فِي اليَهُودِيَّة الكُلْ وفِي البْلَايِصْ الدَّايْرَة بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","وسْمَعْ يُوحَنَّا الأَخْبَارْ هَاذِي الكُلْ مِنْ تْلَامِذْتُو، يَاخِي عَيِّطْ لْزُوزْ مِنْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","وبْعَثْهُمْ لِلرَّبْ يَسُوعْ بَاشْ يِسْأْلُوهْ: «إِنْتِ هُوَّ الِّي نِسْتَنَّاوْ فِيهْ بَاشْ يْجِي، وَلَّا نِسْتَنَّاوْ وَاحِدْ آخِرْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ومْشَاوْ الزُّوزْ رْجَالْ لْيَسُوعْ، وقَالُولُو: «بْعَثْنَا لِيكْ يُوحَنَّا الِّي يْعَمِّدْ بَاشْ نِسْأْلُوكْ: \"إِنْتِ هُوَّ الِّي نِسْتَنَّاوْ فِيهْ بَاشْ يْجِي، وَلَّا نِسْتَنَّاوْ وَاحِدْ آخَرْ؟\"». ");
INSERT INTO aeu_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","وفِي الوَقْتْ هَاذَاكَا بِالضَّبْطْ، شْفَى يَسُوعْ بَرْشَة مُرْضَى ومُعَاقِينْ وخَرِّجْ أَرْوَاحْ شِرِّيرَة، وبَرْشَة عِمْيَانْ رَدْهُمْ يْشُوفُوا. ");
INSERT INTO aeu_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","يَاخِي يَسُوعْ جَاوِبْ الِّي بْعَثْهُمْ يُوحَنَّا: «إِمْشِيوْ خَبْرُوا يُوحَنَّا بِلِّي شُفْتُوهْ وسْمَعْتُوهْ: العِمْيَانْ يْشُوفُوا، والعَايْبِينْ يِمْشِيوْ، ولِّي عَنْدْهُمْ البْرَصْ يُطْهْرُوا، والطْرُشْ يِسْمْعُوا، والمُوتَى يْقُومُوا، والمْسَاكِنْ تُوصِلْهُمْ البْشَارَة، ");
INSERT INTO aeu_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","وصَحَّة لِيهْ الِّي مَا يْشُكِّشْ فِيَّا!». ");
INSERT INTO aeu_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ووَقْتِلِّي مْشَاوْ تْلَامِذْةْ يُوحَنَّا، بْدَا يَسُوعْ يَحْكِي لِلنَّاسْ عْلَى يُوحَنَّا وقَالْ: «وَقْتِلِّي خْرَجْتُوا لِلْخْلَاء شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ قَصْبَة يْحَرِّكْ فِيهَا الرِّيحْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ رَاجِلْ لَابِسْ لِبْسَة مِذْخْمَة؟ الِّي يِلْبْسُوا اللِّبْسَة الغَالْيَة ولِّي لَابَاسْ عْلِيهُمْ هُومَا فِي قْصُورْ المُلُوكْ! ");
INSERT INTO aeu_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","قُولُولِي مَالَا شْنُوَّة خْرَجْتُوا بَاشْ تْشُوفُوا؟ نَبِيْ؟ إِيْ نْعَمْ، وآنَا نْقُولِلْكُمْ إِنُّو أَعْظِمْ مِنْ نَبِيْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","هَاذَا هُوَّ الِّي تِكْتِبّْ عْلِيهْ فِي الكْتُبْ المُقَدْسَة: \"هَانِي بِشْ نِبْعَثْ قُدَّامِكْ رَسُولِي، بَاشْ يْحَضِّرْلِكْ الطْرِيقْ\". ");
INSERT INTO aeu_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","«وآنَا نْقُلْكُمْ: فِي البَشَرْ الكُلْ، عُمْرُو مَا تُوجِدْ وَاحِدْ أَعْظَمْ مِنْ يُوحَنَّا الِّي يْعَمِّدْ، آمَا رَاهُو أَصْغِرْ وَاحِدْ فِي مَمْلِكْةْ اللَّهْ أَعْظِمْ مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","والنَّاسْ الكُلْ الِّي سَمْعُوا يُوحَنَّا، حَتَّى المَكَّاسَة، إِعْتَرْفُوا بِلِّي اللَّهْ صَالَحْ، وقِبْلُوا بَاشْ يِتْعَمْدُوا بْمَعْمُودِيِّةْ يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","آمَا الفِرِّيسِيِّينْ وعُلَمَاءْ الشَّرِيعَة رَفْضُوا مَشِيئِةْ اللَّهْ لِيهُمْ، ومَا قِبْلُوشْ يُوحَنَّا يْعَمِّدْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","وزَادْ قَالْ: «مَالَا بَاشْ نْشَبَّهْ وْلَادْ الجِيلْ هَاذَا؟ ولِشْكُونْ يْشَبْهُوا؟ ");
INSERT INTO aeu_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","هُومَا كِيفْ وْلَادْ قَاعْدِينْ فِي السُّوقْ يْعَيْطُوا لِبْعَضْهُمْ ويْقُولُوا: \"ضْرَبْنَالْكُمْ الزُّكْرَة مَا شْطَحْتُوا، نْدِبْنَالْكُمْ مَا نَوَّحْتُوا\". ");
INSERT INTO aeu_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","«عْلَى خَاطِرْ يُوحَنَّا جَاء لَا يَاكِلْ خُبْزْ ولَا يُشْرُبْ الشْرَابْ، قُلْتُوا: \"سَاكْنُو شِيطَانْ\". ");
INSERT INTO aeu_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","وجَاء إِبْنْ الإِنْسَانْ يَاكِلْ ويُشْرُبْ، قُلْتُوا عْلِيهْ: \"هَاذَا رَاجِلْ وَكَّالْ وسُوكَارْجِي وصَاحِبْ المَكَّاسَة والمُذْنْبِينْ\". ");
INSERT INTO aeu_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","آمَا الحِكْمَة الحَقِيقِيَّة تُظْهُرْ فِي تَصَرُّفَاتْ الِّي يْطَبْقُوا فِيهَا». ");
INSERT INTO aeu_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","وإِسْتَدْعَاهْ وَاحِدْ فِرِّيسِّي بَاشْ يُفْطُرْ بَحْذَاهْ. يَاخِي دْخَلْ لْدَارْ الفِرِّيسِي، واتَّكَّى بَاشْ يَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","وفِي المْدِينَة هَاذِيكَا، كَانْ فَمَّة مْرَا فَاسْدَة. كِي عَرْفِتْ الِّي يَسُوعْ مِسْتِدْعِي فِي دَارْ الفَرِّيسِي، جَاتْ وجَابِتْ مْعَاهَا دَبُّوزَة غَالِيَة مِلْيَانَة بِالعِطْرْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","وجَاتْ وْرَاهْ عَنْدْ سَاقِيهْ وهِيَّ تِبْكِي وبْدَاتْ تْبِلُّو فِي سَاقِيهْ بِدْمُوعْهَا وتَمْسَحْ فِيهُمْ بِشْعَرْهَا، وتْبُوسْ وتِدْهِنْ فِيهُمْ بِالعِطِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","وكِي شَافْ الفِرِّيسِي الِّي اسْتَدْعَاهْ شْنِيَّة صَارْ، قَالْ بِينُو وبِينْ رُوحُو: «كَانْ جَاء الرَّاجِلْ هَاذَا نَبِيْ رَاهُو عْرَفْ شْكُونِي هَا المْرَا الِّي تْمِسْ فِيهْ وعْرَفْ سِيرِتْهَا! عْلَى خَاطِرْهَا فَاسْدَة». ");
INSERT INTO aeu_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","يَاخِي قَالُّو يَسُوعْ: «يَا سِمْعَانْ عَنْدِي مَا نْقُلِّكْ». وجَاوْبُو سِمْعَانْ: «قُولْ يَا مُعَلِّمْ». ");
INSERT INTO aeu_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","قَالُّو يَسُوعْ: «كَانْ فَمَّة رَاجِلْ مْسَلِّفْ فْلُوسْ لْزُوزْ مِالنَّاسْ، وَاحِدْ سَلْفُو 500 بْيَاسَة فِضَّة والآخِرْ 50. ");
INSERT INTO aeu_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","والزُّوزْ مَا نَجْمُوشْ يْرَجْعُوا الدِّينْ الِّي عْلِيهُمْ، وَلَّى سَامَحْهُمْ الإِثْنِينْ. زَعْمَة شْكُونْ مِنْهُمْ بَاشْ يْحِبُّو أَكْثِرْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","جَاوْبُو سِمْعَانْ: «نِتْصَوِّرْ الِّي يْسَالُو أَكْثِرْ». يَاخِي قَالُّو يَسُوعْ: «كْلَامِكْ صْحِيحْ». ");
INSERT INTO aeu_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ومْبَعِّدْ تْلَفِّتْ يَسُوعْ لِلْمْرَا وقَالْ لْسِمْعَانْ: «رِيتْهَا المْرَا هَاذِي؟ آنَا دْخَلْتْ لْدَارِكْ وإِنْتِ مَا عْطِيتْنِيشْ مَاء بَاشْ نَغْسِلْ سَاقَيَّا، آمَا هِيَّ غَسْلِتْهُمْلِي بِدْمُوعْهَا ومَسْحِتْهُمْلِي بِشْعَرْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","بُوسَة وَحْدَة مَا بُسْتْنِيشْ، آمَا هِيَّ مِلِّي دْخَلْتْ وهِيَّ تْبُوسْلِي فِي سَاقَيَّا. ");
INSERT INTO aeu_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","إِنْتِ مَا دْهِنْتْلِيشْ رَاسِي بِالزِّيتْ، آمَا هِيَّ دِهْنِتْلِي سَاقَيَّا بِالعِطْرْ. ");
INSERT INTO aeu_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","هَاذَاكَا عْلَاشْ نْقُلِّكْ: ذْنُوبْهَا الِّي قَدْ شْعَرْ الرَّاسْ تْغَفْرِتْ، يَاخِي ظَهْرِتْ بَرْشَة مْحَبَّة، آمَا الِّي يِتْغْفِرْلُو شْوَيَّة يْحِبْ شْوَيَّة». ");
INSERT INTO aeu_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","مْبَعِّدْ قَالِلْهَا: «ذْنُوبِكْ مَغْفُورَة». ");
INSERT INTO aeu_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","يَاخِي بْدَاوْ الحَاضْرِينْ يِسْأْلُوا فِي رْوَاحْهُمْ: «شْكُونُو هَاذَا حَتَّى يِغْفِرْ الذْنُوبْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","وقَالْ يَسُوعْ لِلْمْرَا: «إِيمَانِكْ نَجَّاكْ، إِمْشِي فِي سَلَامْ». ");
INSERT INTO aeu_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","وبَعْدْهَا، بْدَا يَسُوعْ يْدُورْ مِنْ مْدِينَة لِمْدِينَة ومِنْ قَرْيَة لْقَرْيَة، يْنَادِي ويْبَشِّرْ بْمَمْلَكْةْ اللَّهْ. وكَانُوا مْعَاهْ تْلَامِذْتُو الأَثْنَاشْ، ");
INSERT INTO aeu_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","وشْوَيَّة نْسَاء شْفَاهُمْ مِالأَرْوَاحْ الشِّرِّيرَة والأَمْرَاضْ، وهُومَا: مَرْيِمْ الِّي يْعَيْطُولْهَا المَجْدَلِيَّة الِّي خَرِّجْ مِنْهَا سَبْعَة شْوَاطِنْ، ");
INSERT INTO aeu_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ويُوَنَّا مَرْتْ خُوزِي الِّي كَانْ لَاهِي بْدَارْ هِيرُودُسْ، وسُوسَنَّة، وبَرْشَة غِيرْهُمْ مِلِّي كَانُوا يْعَاوْنُوا فِي يَسُوعْ وتْلَامِذْتُو مِنْ فْلُوسْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","وتْلَمُّوا بِيهْ بَرْشَة نَاسْ جَايِّينْ مِنْ كُلْ مْدِينَة، يَاخِي قَالِلْهُمْ يَسُوعْ مَثَلْ: ");
INSERT INTO aeu_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«خْرَجْ الفَلَّاحْ بَاشْ يَزْرَعْ الزَّرِّيعَة. وهُوَّ قَاعِدْ يَزْرَعْ، جَاتْ شْوَيَّة مِالزَرِّيعَة عَالطْرِيقْ، يَاخِي تْعَفْسِتْ بِالسَّاقِينْ وكْلَاتْهَا العْصَافِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","وشْوَيَّة أُخْرَى جَاتْ بِينْ الحْجَرْ، ودُوبْ مَا نِبْتِتْ يِبْسِتْ، عْلَى خَاطِرْ مَا كَانِشْ فَمَّة مَاء. ");
INSERT INTO aeu_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","وشْوَيَّة زَرِّيعَة طَاحِتْ فِي وُسْطْ الشُّوكْ، ونْبِتْ مْعَاهَا الشُّوكْ وخْنَقْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","وفَمَّة زَرِّيعَة أُخْرَى جَاتْ فِي أَرْضْ بَاهْيَة، وكِي نِبْتِتْ ثُمْرِتْ وجَابِتْ 100 مَرَّة قَدْ الِّي تِزْرَعْ». وكِي كَمِّلْ المَثَلْ قَالْ بْصُوتْ عَالِي: «الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ!». ");
INSERT INTO aeu_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","وسِأْلُوهْ تْلَامِذْتُو: «شْنِيَّة مَعْنَاهْ المَثَلْ هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","يَاخِي جَاوِبْهُمْ: «إِنْتُومَا تِعْطَالْكُمْ بَاشْ تَعْرْفُوا أَسْرَارْ مَمْلَكْةْ اللَّهْ، آمَا غِيرْكُمْ نْكَلَّمْهُمْ بِالأَمْثَالْ، بَاشْ حَتَّى كِي يُخْزْرُوا مَا يْشُوفُوشْ وكِي يِسْمْعُوا مَا يِفْهْمُوشْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«وهَاذَا المَقْصُودْ بِالمَثَلْ: الزَّرِّيعَة هِيَّ كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","فَمَّة نَاسْ هُومَا كِيمَا الزَّرِّيعَة الِّي جَاتْ عَالطْرِيقْ، يِسْمْعُوا كِلْمِةْ اللَّهْ ومْبَعِّدْ يْجِي إِبْلِيسْ يْنَحِّيهَا مِنْ قْلُوبْهُمْ بَاشْ مَا يَمْنُوشْ ويِنْجَاوْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ونَاسْ أُخْرِينْ كِيمَا الِّي طَاحِتْ بِينْ الحْجَرْ، كِي يِسْمْعُوا الكِلْمَة يِقْبْلُوهَا بْفَرْحَة، آمَا هُومَا مَا عَنْدْهُمْشْ عْرُوقْ، يَمْنُوا مُدَّة قْصِيرَة، ودُوبْ مَا يْجِي وَقْتْ صْعِيبْ يْسَلْمُوا فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ولِّي طَاحُوا وِسْطْ الشُّوكْ، هُومَا الِّي يِسْمْعُوا الكِلْمَة، آمَا وهُومَا مَاشِينْ تُخْنُقْهُمْ الهْمُومْ ومْحَبِّةْ الفْلُوسْ وشْهَاوِي الدِّنْيَا، وثَمْرِتْهُمْ مَا تُنْضُجِشْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","آمَا الِّي طَاحُوا فِي الأَرْضْ البَاهْيَة، هُومَا الِّي قْلُوبْهُمْ صَادْقَة وصَالْحَة، وكِي يِسْمْعُوا كِلْمِةْ اللَّهْ يْشِدُّوا فِيهَا صْحِيحْ ويِجْتَهْدُوا حَتَّى لِينْ يُثْمْرُوا. ");
INSERT INTO aeu_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","«ومَا فَمَّاشْ وَاحِدْ يْشَعِّلْ فْنَارْ ويْغُمُّو بْطَاسَة وَلَّا يْحُطُّو تَحْتْ فَرْشْ، آمَا يْحُطُّو فِي بْلَاصَة عَالْيَة بَاشْ الِّي يُدْخُلُوا يْشُوفُوا الضَّوْء. ");
INSERT INTO aeu_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","عْلَى خَاطِرْ كُلْ حَاجَة مْخُبْيَة بِشْ تُظْهُرْ، وكُلْ سِرْ بِشْ يِتْعْرَفْ ويِتْكْشِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","مَالَا رُدُّوا بَالْكُمْ وأَعْرْفُوا كِيفَاشْ تِسْمْعُوا. رَاهُو الِّي عَنْدُو يِتْزَادْلُو أَكْثِرْ، ولِّي مَا عَنْدُوشْ حَتَّى الِّي يِسْتْخَايْلُو عَنْدُو بِشْ يِتْفَكْلُو». ");
INSERT INTO aeu_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","وجَاوْ أُمْ يَسُوعْ وخْوَاتُو، آمَا مَا نَجْمُوشْ يُوصْلُولُو مِنْ كُثْرِةْ مَا فَمَّة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","يَاخِي قَالُولُو: «أُمُّكْ وخْوَاتِكْ وَاقْفِينْ لْبَرَّا، يْحِبُّوا يْشُوفُوكْ». ");
INSERT INTO aeu_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","جَاوِبْهُمْ: «أُمِّي وخْوَاتِي هُومَا الِّي يِسْمْعُوا كِلْمِةْ اللَّهْ ويْطَبْقُوهَا». ");
INSERT INTO aeu_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","وفِي نْهَارْ مِالنْهَارَاتْ رْكِبْ يَسُوعْ فِي فْلُوكَة مْعَ تْلَامِذْتُو وقَالِلْهُمْ: «هَيَّا نْشُقُّوا لِلجِّيهَة الأُخْرَى مْتَاعْ البُحَيْرَة». ومْشَاوْ بِالفْلُوكَة. ");
INSERT INTO aeu_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","وهُومَا فِي البُحَيْرَة، يَسُوعْ رْقَدْ. وإِذَا بِيهْ هَبِّتْ رِيحْ قْوِيَّة، وبْدَاتْ الفْلُوكَة تِتْعَبَّى بِالمَاء ووَلَّاوْ فِي خْطَرْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","يَاخِي جَاوَهْ تْلَامِذْتُو وفَيْقُوهْ وقَالُولُو: «يَا سِيدْنَا، يَا سِيدْنَا، رَانَا بِشْ نُغْرْقُوا!». وَلَّا قَامْ وأْمَرْ الرِّيحْ والمُوجْ الهَايِجْ، يَاخِي رَكْحُوا والدِّنْيَا هْدَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","مْبَعِّدْ قَالِلْهُمْ: «وِينُو إِيمَانْكُمْ؟». وخَافُوا وتْعَجْبُوا وبْدَاوْ يِسْأْلُوا فِي بْعَضْهُمْ: «شْكُونُو هَاذَا؟ حَتَّى الرِّيحْ والمُوجْ كِي يُأْمُرْهُمْ يْطِيعُوهْ!». ");
INSERT INTO aeu_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ووِصْلُوا لْمَنْطَقْةْ الجَرَّاسِيِّينْ الِّي مْقَابْلَة الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","وكِي هْبَطْ يَسُوعْ لِلْبَرْ، عُرْضُو رَاجِلْ مِالمْدِينَة مَسْكُونْ بْأَرْوَاحْ شِرِّيرَة مِنْ مُدَّة طْوِيلَة، عِرْيَانْ بْكُلُّو ومَا يُسْكُنْشْ فِي دَارْ آمَا بِينْ القْبُورَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ودُوبْ مَا شَافْ يَسُوعْ صَاحْ وتِرْمَى عَنْدْ سَاقِيهْ، وعَيِّطْ عْلَى طُولْ صُوتُو: «آشْ بِينِي وبِينِكْ يَا يَسُوعْ إِبْنْ اللَّهْ العَالِي؟ نِتْرَجَّاكْ، مَا تْعَذَّبْنِيشْ». ");
INSERT INTO aeu_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","قَالْ هَاذَا عْلَى خَاطِرْ يَسُوعْ أْمَرْ الرُّوحْ الشِّرِّيرْ بَاشْ يُخْرُجْ مِالرَّاجِلْ، عْلَى خَاطِرْ بَرْشَة مَرَّاتْ كَانْ يِمْكْنُو، وكُلْ مَا يْشِدُّوهْ بِالسْلَاسِلْ وَلَّا يُرْبْطُولُو سَاقِيهْ بِالحْدِيدْ بَاشْ يْرَيْضُوهْ، كَانْ يْقَطَّعْهُمْ والشِّيطَانْ يْهِزُّو لِلْخْلَاء. ");
INSERT INTO aeu_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","سِأْلُو يَسُوعْ: «آشْ إِسْمِكْ؟». قَالْ: «جَيْشْ!» عْلَى خَاطِرْ جَيْشْ كْبِيرْ مِالأَرْوَاحْ الشِّرِّيرَة كَانُوا دَاخْلِينْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","وتْشَحْتُوهْ بَاشْ مَا يَبْعَثْهُمْشْ لِلْهَاوْيَة. ");
INSERT INTO aeu_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","وكَانْ فَمَّة بَرْشَة حْلَالِفْ سَارْحِينْ فِي الجْبَلْ، يَاخِي طَلْبُوا مِنُّو بَاشْ يْخَلِّيهُمْ يُدْخْلُوا فِيهُمْ، ويَسُوعْ خَلَّاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","وخَرْجُوا الأَرْوَاحْ الشِّرِّيرَة مِالرَّاجِلْ ودَخْلُوا فِي الحْلَالِفْ. وجْرَاوْ الحْلَالِفْ الكُلْ وتِرْمَاوْ مِنْ حَافِّةْ الجْبَلْ فِي البُحَيْرَة وغُرْقُوا. ");
INSERT INTO aeu_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","كِي شَافُوا سُرَّاحْ الحْلَالِفْ آشْ صَارْ، هَرْبُوا ونَشْرُوا الخْبَرْ فِي المْدِينَة والدْشُرْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","وخَرْجُوا النَّاسْ بَاشْ يْشُوفُوا الِّي صَارْ، وجَاوْ لْيَسُوعْ ولْقَاوْ الرَّاجِلْ الِّي خَرْجِتْ مِنُّو الأَرْوَاحْ الشِّرِّيرَة قَاعِدْ عَنْدْ سَاقِينْ يَسُوعْ، لَابِسْ دَبْشُو وبْعَقْلُو، يَاخِي خَافُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","والنَّاسْ الِّي كَانُوا شَاهْدِينْ حْكَاوِلْهُمْ كِيفَاشْ تِشْفَى الرَّاجِلْ المَسْكُونْ بْأَرْوَاحْ شِرِّيرَة. ");
INSERT INTO aeu_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","يَاخِي سُكَّانْ مَنْطَقْةْ الجَرَّاسِيِّينْ الكُلْ طَلْبُوا مِنْ يَسُوعْ بَاشْ يِبْعِدْ عْلِيهُمْ، عْلَى خَاطِرْهُمْ خَافُوا بَرْشَة. وَلَّا طْلَعْ فِي الفْلُوكَة ورْجَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","والرَّاجِلْ الِّي خَرْجِتْ مِنُّو الأَرْوَاحْ الشِّرِّيرَة قْعَدْ يْحَاوِلْ فِيهْ بَاشْ يْهِزُّو مْعَاهْ، آمَا يَسُوعْ مَا خَلَّاهِشْ وقَالُّو: ");
INSERT INTO aeu_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«إِرْجَعْ لْدَارِكْ وأَحْكِي عَلِّي عَمْلُو مْعَاكْ اللَّهْ الكُلْ». يَاخِي دَارْ المْدِينَة الكُلْ يَحْكِي عَلِّي عْمَلْهُولُو يَسُوعْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","وكِي رْجَعْ يَسُوعْ، رَحْبُوا بِيهْ النَّاسْ الكُلْ عْلَى خَاطِرْهُمْ كَانُوا يِسْتَنَّاوْ فِي رْجُوعُو. ");
INSERT INTO aeu_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","وجَاهْ رَاجِلْ إِسْمُو يَايْرُسْ، وهُوَّ وَاحِدْ مِنْ رُؤَسَاءْ مَعْبِدْ اليْهُودْ، وتِرْمَى عَنْدْ سَاقِيهْ وتْشَحْتُو بَاشْ يِمْشِي مْعَاهْ لْدَارُو، ");
INSERT INTO aeu_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","عْلَى خَاطِرْ كَانْ عَنْدُو بْنَيَّة وَحْدَة، عْمُرْهَا أَثْنَاشِنْ سْنَة، قْرِيبْ تْمُوتْ. ويَسُوعْ مَاشِي، كَانُوا بَرْشَة نَاسْ يِدَّازُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","وكَانِتْ فَمَّة مْرَا عَنْدْهَا نَزِيفْ دَمْ مِنْ أَثْنَاشِنْ سْنَة. ورَغْمِلِّي صَرْفِتْ الِّي وْرَاهَا ولِّي قُدَّامْهَا عَالطُّبَّة، مَا نَجِّمْ حَدْ يِشْفِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","وجَاتْ مِنْ وْرَاء يَسُوعْ ومَسِّتْ طَرْفْ مِنْ حْوَايْجُو، وبِالوَقْتْ النَّزِيفْ وْقِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","يَاخِي يَسُوعْ قَالْ: «شْكُونْ مَسْنِي؟». وكِي النَّاسْ الكُلْ نَكْرُوا، بُطْرُسْ قَالْ: «يَا سِيدْنَا النَّاسْ يِدَّازُّوا عْلِيكْ مِنْ كُلْ شِيرَة وإِنْتِ تِسْإِلْ شْكُونْ مَسْنِي؟». ");
INSERT INTO aeu_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","آمَا يَسُوعْ قَالْ: «فَمَّة شْكُونْ مَسْنِي، عْلَى خَاطِرْ حَسِّيتْ بْقُوَّة خَرْجِتْ مِنِّي». ");
INSERT INTO aeu_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ووَقْتِلِّي عَرْفِتْ المْرَا إِنُّو فَاقْ بِيهَا، جَاتُو وهِيَّ تُرْعُشْ مِالخُوفْ، وتِرْمَاتْ عَنْدْ سَاقِيهْ وحْكَاتْ قُدَّامْ النَّاسْ الكُلْ عْلَاشْ مَسِّتُّو، وكِيفَاشْ بْرَاتْ بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","قَالِلْهَا: «يَا بِنْتِي، إِيمَانِكْ شْفَاكْ، إِمْشِي فِي سَلَامْ!». ");
INSERT INTO aeu_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","وهُوَّ يِتْكَلِّمْ، جَاء وَاحِدْ مِنْ دَارْ يَايْرُسْ رَئِيسْ مَعْبِدْ اليْهُودْ وقَالُّو: «بِنْتِكْ مَاتِتْ، مِنْ غِيرْ مَا تُقْعُدْ اتَّعِّبْ فِي المُعَلِّمْ». ");
INSERT INTO aeu_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","وكِي سْمَعْ يَسُوعْ الكْلَامْ هَاذَا، قَالُّو: «مَا تْخَافِشْ، أَمَّنْ بَرْكْ وهِيَّ تِتْشْفَى». ");
INSERT INTO aeu_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","وكِي وْصِلْ يَسُوعْ لِلدَّارْ، مَا خَلَّى حَتَّى وَاحِدْ يُدْخُلْ مْعَاهْ كَانْ بُطْرُسْ ويُوحَنَّا ويَعْقُوبْ وبُو الطُّفْلَة وأُمْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","والنَّاسْ الكُلْ كَانُوا يِبْكِيوْ ويِنْدْبُوا عْلِيهَا، يَاخِي قَالِلْهُمْ يَسُوعْ: «مَا تِبْكِيوِشْ، البْنَيَّة مَا مَاتِتْشْ، آمَا رَاهِي رَاقْدَة». ");
INSERT INTO aeu_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","والنَّاسْ ضَحْكُوا عْلِيهْ، عْلَى خَاطِرْهُمْ كَانُوا يَعْرْفُوا الِّي هِيَّ مَاتِتْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","آمَا هُوَّ خَرِّجْ النَّاسْ الكُلْ لْبَرَّا، وشَدْ الطُّفْلَة مِنْ يِدْهَا وقَالْ بْصُوتْ عَالِي: «يَا بْنَيَّة، قُومْ!». ");
INSERT INTO aeu_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","يَاخِي رَجْعِتِّلْهَا رُوحْهَا ووِقْفِتْ بِالوَقْتْ. وعْطَاهُمْ أَمْرْ بَاشْ يَعْطِيوْهَا تَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","وقَعْدُوا وَالْدِيهَا بَاهْتِينْ، آمَا يَسُوعْ وَصَّاهُمْ بَاشْ مَا يَحْكِيوْ لْحَدْ عَلِّي صَارْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ومْبَعِّدْ عَيِّطْ يَسُوعْ لِتْلَامِذْتُو الأَثْنَاشْ، وعْطَاهُمْ قُوَّة وسُلْطَة بَاشْ يْخَرْجُوا الشْوَاطِنْ الكُلْ ويِشْفِيوْ الأَمْرَاضْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","وبْعَثْهُمْ بَاشْ يْبَشْرُوا بْمَمْلَكْةْ اللَّهْ ويِشْفِيوْ المُرْضَى. ");
INSERT INTO aeu_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","وقَالِلْهُمْ: «وإِنْتُومَا مَاشِينْ مَا تْهِزُّوا مْعَاكُمْ شَيْ: لَا عْصَا، لَا صُرَّة، لَا خُبْزْ، لَا فْلُوسْ ولَا حَتَّى لِبْسَة زَايْدَة. ");
INSERT INTO aeu_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","والدَّارْ الِّي تُدْخْلُولْهَا أُسْكْنُوا فِيهَا حَتَّى لِينْ تِمْشِيوْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","وأَيْ مْدِينَة أَهْلْهَا مَا يِقْبْلُوكُمْشْ، أُخْرْجُوا مِنْهَا وأُنْفْضُوا التْرَابْ مِنْ سَاقِيكُمْ أَمَارَة إِنُّو اللَّهْ مُشْ فَرْحَانْ بِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ووَقْتِلِّي خَرْجُوا، بْدَاوْ يْدُورُوا مِنْ دَشْرَة لْدَشْرَة يْبَشْرُوا ويِشْفِيوْ فِي المُرْضَى فِي كُلْ بْلَاصَة. ");
INSERT INTO aeu_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","وسْمَعْ هِيرُودُسْ الوَالِي بِلِّي كَانْ صَايِرْ الكُلْ، وبْقَى مِتْحَيِّرْ، عْلَى خَاطِرْ فَمَّة شْكُونْ كَانُوا يْقُولُوا: «يُوحَنَّا الِّي يْعَمِّدْ قَامْ مِالمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","وجْمَاعَة يْقُولُوا: «إِيلِيَّا ظْهُرْ»، وأُخْرِينْ يْقُولُوا: «وَاحِدْ مِالأَنْبِيَاءْ القْدُمْ قَامْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","آمَا هِيرُودُسْ قَالْ: « يُوحَنَّا آنَا قَصِّيتْلُو رَاسُو، مَالَا شْكُونُو هَاذَا الِّي نِسْمَعْ عْلِيهْ فِي هَا الأَخْبَارْ؟». وكَانْ يْحَاوِلْ بَاشْ يْقَابْلُو. ");
INSERT INTO aeu_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","وبَعْدْمَا رَجْعُوا الرُّسُلْ، حْكَاوْ لْيَسُوعْ عَلِّي عَمْلُوهْ الكُلْ. يَاخِي هَزْهُمْ مْعَاهْ ومْشَاوْ بَاشْ يُقْعْدُوا وَحَّدْهُمْ بَحْذَا مْدِينَة إِسْمْهَا بَيْتْ صَيْدَا. ");
INSERT INTO aeu_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","آمَا النَّاسْ فَاقُوا بِيهْ وتَبْعُوهْ. يَاخِي اسْتَقْبِلْهُمْ وكَلَّمْهُمْ عْلَى مَمْلَكْةْ اللَّهْ، وشْفَى الِّي كَانُوا مُحْتَاجِينْ يِتْشْفَاوْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","وكِي قْرِيبْ يُوفَى النْهَارْ، جَاوَهْ تْلَامِذْتُو الأَثْنَاشْ وقَالُولُو: «أَبْعِثْ النَّاسْ خَلِّيهُمْ يِمْشِيوْ لِلدْشُرْ والفِيرْمَاتْ القْرِيبَة، بَاشْ يْبَاتُوا غَادِي ويَلْقَاوْ مَا يَاكْلُوا، عْلَى خَاطِرْ هُونِي البْلَاصَة خْلَاء». ");
INSERT INTO aeu_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","آمَا يَسُوعْ قَالِلْهُمْ: «أَعْطِيوْهُمْ إِنْتُومَا مَا يَاكْلُوا». جَاوْبُوهْ: «مَا عَنْدْنَا كَانْ خَمْسَة خُبْزَاتْ وحُوتِّينْ، إِلَّا إِذَا كَانْ نِمْشِيوْ نِشْرِيوْ مَاكْلَة لِلنَّاسْ هَاذُومَا الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","عْلَى خَاطِرْ كَانْ عْدَدْهُمْ تَقْرِيبْ 5 000 رَاجِلْ. يَاخِي قَالْ لِتْلَامِذْتُو: «قَعْدُوهُمْ كُلْ 50 مْعَ بْعَضْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","وعَمْلُوا كِيمَا قَالِلْهُمْ وقَعْدُوا النَّاسْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","وخْذَا يَسُوعْ الخَمْسَة خُبْزَاتْ والحُوتِّينْ وهَزْ عِينِيهْ لِلسْمَاء وشْكَرْ اللَّهْ وقَسَّمْهُمْ وعْطَاهُمْ لِتْلَامِذْتُو بَاشْ يْفَرْقُوهُمْ عَالنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","وكْلَاوْ النَّاسْ الكُلْ وشَبْعُوا. وعَبَّاوْ أَثْنَاشِنْ قُفَّة مِالمَاكْلَة الِّي فُضْلِتْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","فِي نْهَارْ مِالنْهَارَاتْ كَانْ يَسُوعْ قَاعِدْ يْصَلِّي وَحْدُو والتْلَامْذَة كَانُوا بَحْذَاهْ، يَاخِي سْإِلْهُمْ: «آنَا شْكُونْ حَسْبْ رَايْ النَّاسْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","جَاوْبُوهْ: «جْمَاعَة يْقُولُوا عْلِيكْ يُوحَنَّا الِّي يْعَمِّدْ، وجْمَاعَة يْقُولُوا الِّي إِنْتِ إِيلِيَّا، وفَمَّة شْكُونْ يْقُولْ الِّي إِنْتِ وَاحِدْ مِالأَنْبِيَاءْ القْدُمْ قَامْ مِالمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","يَاخِي سْإِلْهُمْ: «وحَسْبْ رَايْكُمْ إِنْتُومَا، آنَا شْكُونْ؟». جَاوْبُو بُطْرُسْ: «إِنْتِ مَسِيحْ اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","آمَا هُوَّ نَبَّهْ عْلِيهُمْ بَاشْ مَا يْقُولُوا هَاذَا لْحَدْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","وقَالْ: «إِبْنْ الإِنْسَانْ لَازْمُو يِتْعَذَّبْ بَرْشَة، ويُرْفْضُوهْ الشْيُوخْ وكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة، ويِتْقْتَلْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","وقَالْ لِلنَّاسْ الكُلْ: «إِذَا كَانْ وَاحِدْ يْحِبْ يْتَبَّعْنِي، لَازْمُو يُنْكُرْ رُوحُو، ويْكُونْ مِسْتْعَدْ بَاشْ يْشَارِكْنِي فِي العْذَابْ والمُوتْ كُلْ يُومْ، ويْتَبَّعْنِي. ");
INSERT INTO aeu_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","الِّي يْحِبْ يْنَجِّي رُوحُو يَخْسَرْهَا. آمَا الِّي يَخْسَرْ رُوحُو عْلَى خَاطْرِي يْنَجِّيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","شْنِيَّة الفَايْدَة كَانْ الإِنْسَانْ يِرْبَحْ العَالِمْ بْكُلُّو ويَخْسَرْ حْيَاتُو وَلَّا يْضَيَّعْهَا؟ ");
INSERT INTO aeu_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","الِّي يِسْتْعَارْ بِيَّا وبِكْلَامِي، يِسْتْعَارْ بِيهْ إِبْنْ الإِنْسَانْ وَقْتِلِّي يِرْجَعْ فِي مَجْدُو ومَجْدْ الآبْ والمْلَايْكَة القِدِّيسِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","آمَا نْقُلْكُمْ الحَقْ: فَمَّة شْكُونْ مِالوَاقْفِينْ هُونِي مَاهُمْشْ بِشْ يْذُوقُوا المُوتْ إِلَّا بَعْدْمَا يْشُوفُوا مَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","وبَعْدْمَا قَالْ الكْلَامْ هَاذَا بِثْمَنْيَة أَيَّامْ، هَزْ يَسُوعْ بُطْرُسْ ويُوحَنَّا ويَعْقُوبْ وطْلَعْ لِلجْبَلْ بَاشْ يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","وهُوَّ يْصَلِّي، وِجْهُو تْبَدِّلْ، وحَوَايْجُو وَلَّاوْ بْيُضْ يِلْمْعُوا. ");
INSERT INTO aeu_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","وإِذَا بِيهُمْ زُوزْ رْجَالْ يَحْكِيوْ مْعَاهْ، وهُومَا: مُوسَى وإِيلِيَّا، ");
INSERT INTO aeu_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","الِّي ظُهْرُوا فِي مَجْدْ، وكَانُوا يِتْكَلْمُوا عْلَى مُوتُو الِّي لَازِمْ يْتِمْ فِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","بُطْرُسْ ولِّي مْعَاهْ غْلِبْهُمْ النُّومْ، آمَا كِي فَاقُوا، شَافُوا مَجْدْ يَسُوعْ والزُّوزْ الرْجَالْ الوَاقْفِينْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","وكِي جَاوْ الرْجَالْ يْفَارْقُوا فِيهْ، قَالْ بُطْرُسْ لْيَسُوعْ: « يَا سِيدِي مَحْلَاهَا القَعْدَة هُونِي، خَلِّينَا نُنْصْبُوا ثْلَاثَة خْيِمْ: وَحْدَة لِيكْ، ووَحْدَة لْمُوسَى، ووَحْدَة لْإِيلِيَّا». وكَانْ مُشْ عَارِفْ فَاشْ قَاعِدْ يْقُولْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","وهُوَّ مَزَّالْ يِتْكَلِّمْ جَاتْ غِيمَة وغَطَّاتْهُمْ، يَاخِي التْلَامْذَة خَافُوا كِي دَخْلُوا وِسْطْ الغِيمَة. ");
INSERT INTO aeu_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","وخْرَجْ صُوتْ مِالغَيْمَة يْقُولْ: «هَاذَا هُوَّ إِبْنِي الِّي اخْتَرْتُو، إِسْمْعُوا كْلَامُو». ");
INSERT INTO aeu_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","وبَعْدْمَا سَمْعُوا الصُّوتْ، شَافُوا يَسُوعْ وَحْدُو. يَاخِي كِتْمُوا الخْبَرْ ومَا حْكَاوْ لْحَتَّى حَدْ فِي الأَيَّامَاتْ هَاذِيكَا عَلِّي شَافُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ومِنْ غُدْوَة، كِي هَبْطُوا مِالجْبَلْ، لْقَاوْ بَرْشَة نَاسْ يِسْتَنَّاوْ فِي يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","وبْدَا وَاحِدْ مِنْهُمْ يْعَيِّطْ ويْقُولْ: «يَا مُعَلِّمْ، نِتْرَجَّاكْ تْجِي تْشُوفْلِي وِلْدِي، رَانِي مَا عَنْدِي كَانْ هُوَّ، ");
INSERT INTO aeu_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","رَاهُو يِمْكْنُو رُوحْ شِرِّيرْ، وفِي لَحْظَة يْوَلِّي يْصِيحْ، ويْطِيحْ يِتْصَكِّكْ وكْشَاكْشُو تُخْرُجْ، ومَا يْسَيْبُو كَانْ بِالسِّيفْ وهُوَّ مْرَضْرِضْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","وطْلَبْتْ مِنْ تْلَامِذْتِكْ بَاشْ يْخَرْجُوهْ مِنُّو، يَاخِي مَا نَجْمُوشْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","جَاوِبْ يَسُوعْ: «إِنْتُومَا جِيلْ مُشْ مُؤْمِنْ وضَايَعْ! قَدَّاشْ بِشْ نُقْعْدِلْكُمْ ونُصْبُرْ عْلِيكُمْ؟» وقَالْ لِلرَّاجِلْ: «جِيبْ وِلْدِكْ هُونِي!». ");
INSERT INTO aeu_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","والوْلَيِّدْ جَايْ فِي الثْنِيَّة، صَرْعُو الشِّيطَانْ وطَاحْ يِتْصَكِّكْ فِي القَاعَة. يَاخِي نْزَرْ يَسُوعْ عَالرُّوحْ الشِّرِّيرْ، وشْفَى الوْلَيِّدْ ورَجْعُو لْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","والنَّاسْ الكُلْ تْعَجْبُوا مِنْ قُدْرِةْ اللَّهْ العْظِيمَة. وهُومَا مِتْعَجْبِينْ مِلِّي عَمْلُو يَسُوعْ، قَالْ هُوَّ لِتْلَامِذْتُو: ");
INSERT INTO aeu_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«إِسْمْعُوا مْلِيحْ الِّي بِشْ نْقُولْهُولْكُمْ: إِبْنْ الإِنْسَانْ بِشْ يْسَلْمُوهْ فِي يْدِينْ النَّاسْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","آمَا هُومَا مَا فَهْمُوشْ كْلَامُو، عْلَى خَاطِرْ مَعْنَاهْ كَانْ مْخُبِّي عْلِيهُمْ، بَاشْ مَا يِفْهْمُوهِشْ. وخَافُوا بَاشْ يِسْأْلُوهْ شْنُوَّة يُقْصُدْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","وتْخَالْفُوا تْلَامِذْتُو فِي بْعَضْهُمْ عْلَى شْكُونْ أَعْظِمْ وَاحِدْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","آمَا يَسُوعْ عْرَفْ الِّي فِي قْلُوبْهُمْ، يَاخِي شَدْ طْفُلْ صْغِيرْ مِنْ يِدُّو ووَقْفُو بْجَنْبُو ");
INSERT INTO aeu_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","وقَالِلْهُمْ: «الِّي يِقْبِلْ الوْلَيِّدْ هَاذَا عْلَى خَاطِرْ إِسْمِي، يِقْبِلْنِي آنَا، ولِّي يِقْبِلْنِي، يِقْبِلْ الِّي بْعَثْنِي. عْلَى خَاطِرْ أَصْغِرْ وَاحِدْ فِيكُمْ الكُلْ هُوَّ أَعْظِمْ وَاحِدْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","تْكَلَّمْ يُوحَنَّا قَالْ: «يَا سِيدِي، شُفْنَا وَاحِدْ يْخَرِّجْ فِي الشْوَاطِنْ بْإِسْمِكْ، يَاخِي مْنَعْنَاهْ، عْلَى خَاطْرُو مُشْ يْتَبَّعْ فِيكْ مْعَانَا». ");
INSERT INTO aeu_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","يَاخِي قَالُّو يَسُوعْ: «مَا تِمْنْعُوهُوشْ، عْلَى خَاطِرْ الِّي مُشْ ضِدْكُمْ، هُوَّ مْعَاكُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","وكِي قْرُبْ الوَقْتْ الِّي بِشْ يِتْرْفَعْ فِيهْ يَسُوعْ لِلسْمَاء، قَرِّرْ بَاشْ يِمْشِي لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","وبْعَثْ جْمَاعَة بَاشْ يِسْبْقُوهْ، ودَخْلُوا لْقَرْيَة فِي مَنْطَقْةْ السَّامْرَة بَاشْ يْحَضْرُولُو مَا يِلْزِمْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","آمَا إِمَّالِيهَا مَا قِبْلُوهِشْ عْلَى خَاطْرُو كَانْ مَاشِي لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","وكِي تْلَامِذْتُو يُوحَنَّا ويَعْقُوبْ شَافُوا الِّي صَارْ قَالُوا: «يَا سِيدْنَا، تْحِبْشِي نُأْمْرُوا بَاشْ تَهْبِطْ عْلِيهُمْ نَارْ مِالسْمَاء وتَحْرَقْهُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","وتْلَفْتِلْهُمْ يَسُوعْ ولَامْ عْلِيهُمْ وقَالْ: «إِنْتُومَا مَا تَعْرْفُوشْ مِنْ آنَا رُوحْ جِيتُوا، ");
INSERT INTO aeu_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ مَا جَاشْ بَاشْ يِهْلِكْ النَّاسْ، آمَا جَاء بَاشْ يْنَجِّيهُمْ». ومْشَاوْ لْدَشْرَة أُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","وهُومَا مَاشِينْ فِي الطْرِيقْ جَاء وَاحِدْ لْيَسُوعْ وقَالُّو: «بِشْ نْتَبْعِكْ فِينْ مَا تِمْشِي». ");
INSERT INTO aeu_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","جَاوْبُو يَسُوعْ: «الثْعَالِبْ عَنْدْهَا مْغَاغِرْ، والطْيُورْ عَنْدْهَا عْشَاشْ، آمَا إِبْنْ الإِنْسَانْ مَا عَنْدُو وِينْ يْكِنْ رَاسُو». ");
INSERT INTO aeu_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","وقَالْ يَسُوعْ لْوَاحِدْ آخِرْ: «تَبَّعْنِي!». آمَا هُوَّ قَالُّو: «يَا سِيدِي، قْبَلْ كُلْ شَيْ خَلِّينِي نِمْشِي نِدْفِنْ بَابَا». ");
INSERT INTO aeu_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","يَاخِي قَالُّو يَسُوعْ: «خَلِّي المُوتَى يِدْفْنُوا المُوتَى مْتَاعْهُمْ، آمَا إِنْتِ إِمْشِي وبَشِّرْ بْمَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","وقَالُّو وَاحِدْ آخِرْ: «يَا سِيدْنَا، آنَا نْتَبْعِكْ، آمَا خَلِّينِي نِمْشِي نْسَلِّمْ عْلَى عَايِلْتِي قْبَلْ». ");
INSERT INTO aeu_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","جَاوْبُو يَسُوعْ: «الِّي يْحُطْ يِدُّو عَالمِحْرَاثْ ويِتْلَفَّتْ لْتَالِي، مَا يُصْلُحْشْ لْمَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","وبَعْدْ هَاذَا زَادْ إِخْتَارْ الرَّبْ يَسُوعْ 72 أُخْرِينْ، وبْعَثْهُمْ كُلْ زُوزْ مْعَ بْعَضْهُمْ، بَاشْ يِسْبْقُوهْ لْكُلْ مْدِينَة وكُلْ بْلَاصَة كَانْ نَاوِي يِمْشِيلْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","وقَالِلْهُمْ: «هَانِي بِشْ نِبْعَثْكُمْ كِيفْ الحَصَّادَة. الصَّابَة بَرْشَة، آمَا الخَدَّامَة شْوَيَّة. مَالَا أُطْلْبُوا مِنْ مُولَى الصَّابَة يَبْعَثْ خَدَّامَة لْصَابْتُو. ");
INSERT INTO aeu_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","إِمْشِيوْ، هَانِي بِشْ نِبْعَثْكُمْ كِيفْ الغْنَمْ فِي وِسْطْ الذْيُوبَة. ");
INSERT INTO aeu_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","لَا تْهِزُّوا مْعَاكُمْ فْلُوسْ، ولَا صُرَّة، ولَا صَنْدَالْ، ومَا تْسَلْمُوا عْلَى حَتَّى حَدْ فِي الطْرِيقْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","والدَّارْ الِّي تُدْخْلُوهَا قُولُوا فِي الأُوِّلْ: \"سَلَامْ لِلدَّارْ هَاذِي\". ");
INSERT INTO aeu_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","إِذَا كَانْ فِيهَا شْكُونْ يْحِبْ السَّلَامْ سْلَامْكُمْ يِمْلَاهْ، مَا كَانِشْ سْلَامْكُمْ يِرْجْعِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","وأُقْعْدُوا فِي الدَّارْ هَاذِيكَا، وكُولُوا وأُشْرْبُوا مِلِّي عَنْدْهُمْ، عْلَى خَاطِرْ الِّي يِخْدِمْ مِنْ حَقُّو يُخْلِصْ. ومَا تُقْعْدُوشْ إِدُّورُوا مِنْ دَارْ لْدَارْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","«وأَيْ مْدِينَة تُدْخْلُوهَا وإِمَّالِيهَا يِقْبْلُوكُمْ، كُولُوا مِالمَاكْلَة الِّي يَعْطِيوْهَالْكُمْ، ");
INSERT INTO aeu_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","وإِشْفِيوْ المُرْضَى الِّي فِيهَا وقُولُولْهُمْ: \"مَمْلَكْةْ اللَّهْ قُرْبِتِّلْكُمْ\". ");
INSERT INTO aeu_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","وأَيْ مْدِينَة تُدْخْلُوهَا ومَا يِقْبْلُوكُمْشْ إِمَّالِيهَا، أُخْرْجُوا لِشْوَارَعْهَا وقُولُوا: ");
INSERT INTO aeu_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","\"حَتَّى تْرَابْ مْدِينِتْكُمْ الِّي لْصِقْ فِي سَاقِينَا نُنْفْضُوهْ عْلِيكُمْ، آمَا أَعْرْفُوا الِّي مَمْلَكْةْ اللَّهْ قْرِيبَة\". ");
INSERT INTO aeu_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","نْقُولِلْكُمْ: رَاهُو فِي نْهَارْ الحْسَابْ، مْدِينِةْ سَدُومْ بِشْ يْكُونْ حْسَابْهَا أَخَفْ مِالمْدِينَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«يَا وِيلِكْ يَا كُورَزِينْ! يَا وِيلِكْ يَا بَيْتْ صَيْدَا! لَوْ كَانْ المُعْجْزَاتْ الِّي تْعَمْلُوا فِي وِسْطْكُمْ تْعَمْلُوا فِي صُورْ وصَيْدَا، رَاهُو نَاسْهُمْ تَابُوا مِنْ مُدَّة طْوِيلَة ولِبْسُوا خْيِشْ وحَطُّوا الرْمَادْ عْلَى رْيُوسْهُمْ بَاشْ يْوَرِّيوْ الِّي هُومَا تَابُوا. ");
INSERT INTO aeu_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","آمَا فِي نْهَارْ الحْسَابْ، صُورْ وصَيْدَا بِشْ يْكُونْ حْسَابْهُمْ أَخَفْ مِنْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","وإِنْتِ يَا كَفْرْنَاحُومْ! تْحِبْ تِطْلَعْ لِلسْمَاء؟ لَا، رَاكْ بِشْ تَهْبِطْ لِلْهَاوِيَة. ");
INSERT INTO aeu_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","«الِّي يِسْمَعْكُمْ، يِسْمَعْنِي، ولِّي يُرْفُضْكُمْ، يُرْفُضْنِي، ولِّي يُرْفُضْنِي يُرْفُضْ الِّي بْعَثْنِي». ");
INSERT INTO aeu_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","والـ72 الِّي بْعَثْهُمْ رَجْعُوا فَرْحَانِينْ وقَالُوا: «يَا سِيدْنَا حَتَّى الشْوَاطِنْ تِخْضْعِلْنَا بْإِسْمِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","يَاخِي قَالِلْهُمْ: «شُفْتْ الشِّيطَانْ طَايَحْ مِالسْمَاء كِيمَا البْرَقْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","وهَانِي عْطِيتْكُمْ سُلْطَة بَاشْ تْعَفْسُوا عَالأَفَاعِي والعْقَارِبْ وكُلْ قُوَّة عَنْدْ العْدُو، وحَتَّى شَيْ مَا يْضُرْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ومْعَ هَاذَا، مَا تِفْرْحُوشْ الِّي الأَرْوَاحْ الشِّرِّيرَة تِخْضْعِلْكُمْ، آمَا إِفْرْحُوا الِّي أَسَامِيكُمْ تْكِتْبِتْ فِي السْمَاء». ");
INSERT INTO aeu_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","وفِي لَحْظِتْهَا تِمّْلَى يَسُوعْ بِالفَرْحَة مِالرُّوحْ القُدُسْ وقَالْ: «نِحْمْدِكْ يَا بَابَا، رَبْ السْمَاء والأَرْضْ، عْلَى خَاطْرِكْ خَبِّيتْ الأُمُورْ هَاذِي عَالحُكَمَاءْ والعُلَمَاءْ وكْشِفْتْهَا لِلصْغَارْ. إِيْ نْعَمْ يَا بَابَا عْلَى خَاطِرْ هَاذِي مَشِيئْتِكْ الصَّالْحَة. ");
INSERT INTO aeu_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","«بَابَا عْطَانِي كُلْ شَيْ، وحَتَّى حَدْ مَا يَعْرِفْ شْكُونْ هُوَّ الإِبْنْ كَانْ الآبْ، وحَتَّى حَدْ مَا يَعْرِفْ شْكُونْ هُوَّ الآبْ كَانْ الإِبْنْ والنَّاسْ الِّي يِخْتَارْ الاِبْنْ بَاشْ يِكْشِفْهُولْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","وتْلَفَّتْ لِتْلَامِذْتُو وقَالِلْهُمْ: «صَحَّة لِلْعِينِينْ الِّي تْشُوفْ فِلِّي تْشُوفُوا فِيهْ إِنْتُومَا. ");
INSERT INTO aeu_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","نْقُلْكُمْ الِّي بَرْشَة أَنْبِيَاءْ ومُلُوكْ تْمَنَّاوْ يْشُوفُوا الِّي إِنْتُومَا تْشُوفُوا فِيهْ ومَا شَافُوهِشْ، ويِسْمْعُوا الِّي إِنْتُومَا تِسْمْعُوا فِيهْ ومَا سَمْعُوهِشْ». ");
INSERT INTO aeu_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","وحَبْ وَاحِدْ مِنْ عُلَمَاءْ الشَّرِيعَة يْجَرْبُو، يَاخِي قَالُّو: «يَا مُعَلِّمْ، آشْ نَعْمِلْ بَاشْ نُورِثْ الحَيَاةْ الأَبَدِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","قَالُّو يَسُوعْ: «آشْ تْقُولْ الشَّرِيعَة؟ وإِنْتِ كِيفَاشْ تْفَسْرُو؟». ");
INSERT INTO aeu_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","جَاوْبُو الرَّاجِلْ: «حِبْ الرَّبْ إِلَاهِكْ بْكُلْ قَلْبِكْ وبْكُلْ رُوحِكْ وبْكُلْ قُوْتِكْ وبْكُلْ عَقْلِكْ، وحِبْ قْرِيبِكْ كِيفْ مَا تْحِبْ رُوحِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","قَالُّو يَسُوعْ: «جَاوِبْتْ بِالصْحِيحْ، أَعْمِلْ هَاذَا تَحْيَا». ");
INSERT INTO aeu_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","آمَا هُوَّ كِي حَبْ يَعْطِي لْرُوحُو الحَقْ، سْإِلْ يَسُوعْ: «شْكُونْ هُوَّ قْرِيبِي؟». ");
INSERT INTO aeu_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","جَاوْبُو يَسُوعْ: «فَمَّة رَاجِلْ كَانْ هَابِطْ مِنْ أُورْشَلِيمْ لْأَرِيحَا، يَاخِي طَاحْ فِي يْدِينْ جْمَاعَة سُرَّاقْ، نَحَّاوْلُو حْوَايْجُو وضَرْبُوهْ، ومْشَاوْ وخَلَّاوَهْ بِينْ حْيَاة ومُوتْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","وبِالصُّدْفَة تْعَدَّى كَاهِنْ مِنْ نَفْسْ الطْرِيقْ، وكِي شَافُو قَصْ لِلشِّيرَة الأُخْرَى ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","وتْعَدَّى زَادَا مِنْ نَفْسْ البْلَاصَة وَاحِدْ مِاللَّاوِيِّينْ الِّي يِخْدْمُوا فِي الهَيْكِلْ، خْزَرْلُو وقَصْ لِلشِّيرَة الأُخْرَى ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","آمَا فَمَّة وَاحِدْ سَامْرِي كَانْ مْسَافِرْ ومِتْعَدِّي مِنْ غَادِي، وكِي شَافُو حَنْ عْلِيهْ ");
INSERT INTO aeu_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","وقْرُبْ مِنُّو وصَبْ زِيتْ وشْرَابْ عَالبْلَايِصْ المَجْرُوحَة وضَمِّدْهُمْلُو، ورَكْبُو عَالزَّايْلَة مْتَاعُو وهَزُّو لِوْتِيلْ وتِلْهَى بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ومِنْ غُدْوَة وهُوَّ خَارِجْ، عْطَى لْمُولَى الوْتِيلْ زُوزْ بْيَاسَاتْ فُضَّة ووَصَّاهْ: \"تِلْهَى بِيهْ، وحَتَّى كَانْ صْرَفْتْ عْلِيهْ أَكْثِرْ مِلِّي عْطِيتِكْ، تَوْ كِي نِرْجَعْ نْمِدْهُمْلِكْ\". ");
INSERT INTO aeu_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","«حَسْبْ رَايِكْ شْكُونْ مِالثْلَاثَة هَاذُومَا يِتْسَمَّى قْرِيبْ الرَّاجِلْ الِّي طَاحْ فِي يْدِينْ السُرَّاقْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","جَاوْبُو: «الِّي عَامْلُو بْرَحْمَة». يَاخِي قَالُّو يَسُوعْ: «مَالَا إِمْشِي وأَعْمِلْ كِيفُو». ");
INSERT INTO aeu_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","وهُومَا يِمْشِيوْ فِي الثْنِيَّة، دْخَلْ يَسُوعْ لْدَشْرَة. يَاخِي ضَيْفِتُّو مْرَا إِسْمْهَا مَرْثَا فِي دَارْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","وكَانِتْ عَنْدْهَا أُخْتْهَا إِسْمْهَا مَرْيِمْ قَعْدِتْ عَنْدْ سَاقِينْ يَسُوعْ تِسْمَعْ فِيهْ فَاشْ قَاعِدْ يْقُولْ. ");
INSERT INTO aeu_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","آمَا مَرْثَا كَانِتْ غَارْقَة فِي تَحْضِيرْ الضْيَافَة. جَاتْ لْيَسُوعْ وقَالِتْلُو: «يَا سِيدِي، يَاخِي مَا قَلْقِكْشْ كِي أُخْتِي خَلَّاتْنِي نَقْضِي وَحْدِي؟ قُلْهَا تْعَاوِنِّي!». ");
INSERT INTO aeu_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","جَاوِبْهَا يَسُوعْ: «مَرْثَا! مَرْثَا! إِنْتِ مْشَغْشْبَة رُوحِكْ ولَاهْيَة فِي بَرْشَة حَاجَاتْ، ");
INSERT INTO aeu_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","آمَا مَا فَمَّة كَانْ حَاجَة وَحْدَة لَازْمَة، ومَرْيِمْ إِخْتَارِتْ أَحْسِنْ بَايْ الِّي حَتَّى حَدْ مَا يْنَجِّمْ يْفُكْهُولْهَا». ");
INSERT INTO aeu_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","نْهَارْ، كَانْ يَسُوعْ يْصَلِّي فِي بْلَاصَة مِالبْلَايِصْ، وكِي كَمِّلْ، قَالُّو وَاحِدْ مِنْ تْلَامِذْتُو: «يَا سِيدِي، عَلِّمْنَا كِيفَاشْ نْصَلِّيوْ، كِيمَا عَلِّمْ يُوحَنَّا تْلَامِذْتُو». ");
INSERT INTO aeu_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","قَالِلْهُمْ يَسُوعْ: «وَقْتِلِّي تْصَلِّيوْ قُولُوا: يَا بُونَا الِّي فِي السْمَاء، خَلِّي إِسْمِكْ يِتْقَدِّسْ، خَلِّي مَمْلَكْتِكْ تْجِي، خَلِّي قَصْدِكْ يْصِيرْ عَالأَرْضْ كِيمَا صَايِرْ فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","أَعْطِينَا كُلْ يُومْ الخُبْزْ الِّي يْكَفِّينَا. ");
INSERT INTO aeu_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","إِغْفْرِلْنَا ذْنُوبْنَا، عْلَى خَاطِرْ أَحْنَا نِغْفْرُوا لِلِّي يُغْلْطُوا فِي حَقْنَا. ومَا ادَّخَّلْنَاشْ فِي تَجْرْبَة، آمَا نَجِّينَا مِالشِّرِيرْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ومْبَعِّدْ زَادْ قَالِلْهُمْ: «شْكُونْ فِيكُمْ عَنْدُو صَاحْبُو، ويِمْشِيلُو فِي نُصْ اللِّيلْ ويْقُلُّو: \"يَا صَاحْبِي سَلَّفْنِي ثْلَاثَة خُبْزَاتْ، ");
INSERT INTO aeu_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","عْلَى خَاطِرْ عَنْدِي صَاحْبِي جَاء مِالسْفَرْ، وآنَا مَا لْقِيتْ مَا نَعْطِيهْ\". ");
INSERT INTO aeu_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","آمَا صَاحْبُو يْجَاوْبُو مِنْ دَاخِلْ: \"مَا تْقَلَّقْنِيشْ! البَابْ مْسَكِّرْ، ووْلَادِي رَاقْدِينْ بْجَنْبِي. مَا انَّجَّمْشْ نْقُومْ ونَعْطِيكْ\". ");
INSERT INTO aeu_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","نْقُولِلْكُمْ: إِذَا كَانْ مَا يْقُومِشْ ويَعْطِيهْ عْلَى خَاطْرُو صَاحْبُو، رَاهُو بِشْ يْقُومْ ويَعْطِيهْ الِّي حَاشْتُو بِيهْ الكُلْ، عْلَى خَاطْرُو شَدْ صْحِيحْ ومَا حْشِمْشْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","«هَاذَاكَا عْلَاشْ آنَا نْقُلْكُمْ: أُطْلْبُوا تَاخْذُوا، أَسْعَاوْ تَلْقَاوْ، دُقُّوا البَابْ يِتْحَلِّلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","عْلَى خَاطِرْ الِّي يُطْلُبْ يَاخِذْ، ولِّي يَسْعَى يَلْقَى، ولِّي يْدُقْ البَابْ يِتْحَلُّو. ");
INSERT INTO aeu_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","شْكُونْ البُو الِّي فِيكُمْ كِي يْجِيهْ وِلْدُو ويُطْلُبْ مِنْ عَنْدُو خُبْزَة، يَعْطِيهْ حَجْرَة؟ وَلَّا يُطْلُبْ مِنْ عَنْدُو حُوتَة، يَعْطِيهْ فِي عُوضْهَا حْنَشْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","وَلَّا يُطْلُبْ مِنْ عَنْدُو عَضْمَة، يَعْطِيهْ عَقْرِبْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","إِذَا كَانْ إِنْتُومَا الأَشْرَارْ تَعْرْفُوا تَعْطِيوْ حَاجَاتْ بَاهْيَة لَوْلَادْكُمْ، مُشْ بِالأَوْلَى بُوكُمْ الِّي فِي السْمَاء يَعْطِي الرُّوحْ القُدُسْ لِلِّي يُطْلْبُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","وفِي مَرَّة، كَانْ يَسُوعْ يْخَرِّجْ فِي شِيطَانْ مِنْ رَاجِلْ، والشِّيطَانْ هَاذَاكَا كَانْ مْخَلِّيهْ بَكُّوشْ، وكِي خْرَجْ، الرَّاجِلْ رْجَعْ يِتْكَلِّمْ، والنَّاسْ تْعَجْبُوا. ");
INSERT INTO aeu_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","آمَا فَمَّة شْكُونْ مِنْهُمْ قَالْ: «هَاذَا يْخَرِّجْ فِي الشْوَاطِنْ ابَّعْلَزَبُولْ رَئِيسْ الشْوَاطِنْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ونَاسْ أُخْرِينْ طَلْبُوا مِنُّو مُعْجْزَة مِالسْمَاء، بَاشْ يْجَرْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","وعْرَفْ يَسُوعْ أَفْكَارْهُمْ، وقَالِلْهُمْ: «كُلْ مَمْلْكَة تِتْقْسِمْ ضِدْ رُوحْهَا تِخْرِبْ، وكُلْ عَايْلَة تِتْقْسِمْ ضِدْ رُوحْهَا تِدَّمِّرْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","إِذَا كَانْ إِبْلِيسْ زَادَا يِتْقْسِمْ عْلَى رُوحُو، مَالَا كِيفَاشْ مَمْلَكْتُو تِبْقَى ثَابْتَة؟ عْلَى خَاطِرْكُمْ تْقُولُوا الِّي آنَا نْخَرِّجْ فِي الشْوَاطِنْ ابَّعْلَزَبُولْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","إِذَا كَانْ آنَا نْخَرِّجْ فِي الشْوَاطِنْ ابَّعْلَزَبُولْ، مَالَا الِّي يْتَبْعُوا فِيكُمْ بِشْكُونْ يْخَرْجُوا فِيهُمْ؟ هَاذَاكَا عْلَاشْ هُومَا الِّي بِشْ يُحْكْمُوا عْلِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","آمَا كَانْ آنَا نْخَرِّجْ فِي الشْوَاطِنْ بْقُوِّةْ اللَّهْ، مَالَا أَعْرْفُوا إِنُّو مَمْلَكْةْ اللَّهْ جَاتْ حَتَّى لْعَنْدْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","«وَقْتِلِّي الرَّاجِلْ القْوِيْ والمْسَلَّحْ يْعِسْ عْلَى دَارُو، الحَاجَاتْ الِّي فِيهَا بِشْ تْكُونْ فِي الحِفِظْ والأَمَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","آمَا كَانْ يِهْجِمْ عْلِيهْ وَاحِدْ أَقْوَى مِنُّو ويِغْلْبُو، يْفُكْلُو سْلَاحُو الِّي مْعَمِّلْ عْلِيهْ، يِسْلْبُو ويْفَرَّقْ المَسْلُوبْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","الِّي مُشْ مْعَايَا رَاهُو ضِدِّي، ولِّي مَا يَجْمَعْشْ مْعَايَا رَاهُو يْفَرِّتْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","«وَقْتِلِّي الرُّوحْ الشِّرِيرْ يُخْرُجْ مِنْ إِنْسَانْ، يِبْدَا يْدُورْ فِي الخْلَاء يْلَوِّجْ عَالرَّاحَة، وكِي مَا يَلْقَاهَاشْ يْقُولْ: \"نِرْجَعْ لْدَارِي الِّي خْرَجْتْ مِنْهَا\". ");
INSERT INTO aeu_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","وكِي يِرْجَعْ يَلْقَاهَا مَكْنُوسَة ومْنَظْمَة. ");
INSERT INTO aeu_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","يْوَلِّي يِمْشِي ويْجِيبْ مْعَاهْ سَبْعَة أَرْوَاحْ أُخْرِينْ أَشَرْ مِنُّو، ويُدْخْلُوا ويُسْكْنُوا غَادِيكَا، وتْوَلِّي حَالِةْ الإِنْسَانْ هَاذَاكَا أَخْيِبْ مِلِّي كَانْ عْلِيهَا قْبَلْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","وهُوَّ يِتْكَلِّمْ، عَلَّاتْ مْرَا صُوتْهَا فِي وِسْطْ النَّاسْ وقَالِتْ: «صَحَّة لِلْأُمْ الِّي جَابِتِّكْ ورَضْعِتِّكْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","آمَا هُوَّ قَالْ: «صَحَّة لِلِّي يِسْمْعُوا كِلْمِةْ اللَّهْ ويْطَبْقُوهَا». ");
INSERT INTO aeu_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","كِي بْدَاتْ الدِّنْيَا تِتْعَبَّى بِالنَّاسْ قَالْ: «الجِيلْ هَاذَا جِيلْ فَاسِدْ، يْحِبْ عْلَى مُعْجْزَة، ومَا بِشْ تِتْعْطَالُو كَانْ مُعْجِزْةْ النَّبِيْ يُونَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","وكِيمَا كَانْ يُونَانْ عَلَامَة لْأَهْلْ مْدِينِةْ نِينَوَى، إِبْنْ الإِنْسَانْ زَادَا بِشْ يْكُونْ عَلَامَة لِلْجِيلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ومَلِكِةْ الجَنُوبْ بِشْ تَاقِفْ نْهَارْ الحْسَابْ مْعَ الجِيلْ هَاذَا وتُحْكُمْ عْلِيهْ، عْلَى خَاطِرْهَا جَاتْ مِنْ آخِرْ الدِّنْيَا بَاشْ تِسْمَعْ حِكْمِةْ سُلَيْمَانْ، وهَاوْ فَمَّة شْكُونْ هْنَا أَعْظِمْ مِنْ سُلَيْمَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","وأَهْلْ مْدِينِةْ نِينَوَى بِشْ يَاقْفُوا نْهَارْ الحْسَابْ مْعَ الجِيلْ هَاذَا ويُحْكْمُوا عْلِيهْ، عْلَى خَاطِرْهُمْ تَابُوا وَقْتِلِّي نَبَّهُّمْ يُونَانْ، وهَاوْ فَمَّة شْكُونْ هْنَا أَعْظِمْ مِنْ يُونَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«مَا فَمَّاشْ وَاحِدْ يْشَعِّلْ فْنَارْ ويْخَبِّيهْ وَلَّا يْغُمُّو بْطَاسَة، آمَا يْحُطُّو فِي بْلَاصَة عَالْيَة بَاشْ الِّي يْجِي دَاخِلْ يْشُوفْ الضَّوْء. ");
INSERT INTO aeu_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","العِينْ هِيَّ فْنَارْ البْدَنْ. كَانْ عِينِكْ لَابَاسْ عْلِيهَا، بَدْنِكْ الكُلْ بِشْ يْكُونْ مْنَوِّرْ. آمَا إِذَا كَانْ عِينِكْ شِرِّيرَة، بَدْنِكْ الكُلْ بِشْ يْكُونْ مْظَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","مَالَا رُدْ بَالِكْ لَا يْكُونْ النُّورْ الِّي فِيكْ ظْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","إِذَا كَانْ بَدْنِكْ الكُلْ مْنَوِّرْ ومَا فِيهْ حَتَّى بْلَاصَة ظْلَامْ، رَاهُو بِشْ يْكُونْ مْنَوِّرْ بْكُلُّو كَايِنُو فْنَارْ ضْوَى عْلِيكْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ووَقْتِلِّي يَسُوعْ كَانْ يِتْكَلِّمْ، اسْتَدْعَاهْ وَاحِدْ مِالفِرِّيسِيِّينْ بَاشْ يُفْطُرْ عَنْدُو. يَاخِي دْخَلْ لْدَارُو واتَّكَّى بَاشْ يَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","وتْعَجِّبْ الفِرِّيسِي كِي شَافْ الِّي يَسُوعْ مَا غْسَلْشْ يْدِيهْ قْبَلْ الفْطُورْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","يَاخِي الرَّبْ يَسُوعْ قَالُّو: «إِنْتُومَا الفِرِّيسِيِّينْ تَغْسْلُوا الكَاسْ والصْحَنْ مِنْ بَرَّة، آمَا مِنْ دَاخِلْ إِنْتُومَا مِلْيَانِينْ بِالطْمَعْ والخُبْثْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","يَلِّي مَا تِفْهْمُوشْ، يَاخِي الِّي صْنَعْ البَرَّانِي، مُشْ هُوَّ بِيدُو الِّي صْنَعْ الدَّخْلَانِي زَادَا؟ ");
INSERT INTO aeu_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","آمَا أَعْطِيوْ صَدْقَة مِلِّي عَنْدْكُمْ، وهَكَّا يْوَلِّي كُلْ شَيْ طَاهِرْ لِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","آمَا يَا وِيلْكُمْ يَا فِرِّيسِيِّينْ، عْلَى خَاطِرْكُمْ تَعْطِيوْ فِي العْشُرْ مْتَاعْ النَّعْنَاعْ والفِيجِلْ وبْقِيِّتْ الحْشَايِشْ، آمَا مْهَمْلِينْ الحَقْ ومْحَبِّةْ اللَّهْ. كَانْ لَازِمْ تَعْمْلُوا هَاذَا مِنْ غِيرْ مَا تْهَمْلُوا الآخِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","يَا وِيلْكُمْ يَا فِرِّيسِيِّينْ! عْلَى خَاطِرْكُمْ تْحِبُّوا تُقْعْدُوا فِي البْلَاصَة الأُولَى فِي المْعَابِدْ، وتْحِبُّوا النَّاسْ تْجِي تْسَلِّمْ عْلِيكُمْ فِي الشْوَارَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","يَا وِيلْكُمْ، عْلَى خَاطِرْكُمْ تْشَبْهُوا لِلْقْبُورَاتْ الِّي مَا تِتْشَافِشْ ومَا عْلِيهَا حَتَّى أَمَارَة، الِّي يِمْشِيوْ فُوقْهَا النَّاسْ مِنْ غِيرْ مَا يَعْرْفُوا الِّي هِيَّ تَحْتْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","وتْكَلِّمْ وَاحِدْ مِنْ عُلَمَاءْ الشَّرِيعَة وقَالُّو: «يَا مُعَلِّمْ، كِي تْقُولْ هَكَّا رَاكْ قَاعِدْ تْسِبْ فِينَا أَحْنَا زَادَا!». ");
INSERT INTO aeu_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","يَاخِي قَالْ: «يَا وِيلْكُمْ إِنْتُومَا زَادَا يَا عُلَمَاءْ الشَّرِيعَة، عْلَى خَاطِرْكُمْ تْحُطُّوا فِي الأَحْمَالْ الثْقِيلَة عْلَى كْتَافْ النَّاسْ، وإِنْتُومَا مَا تْحِبُّوشْ تْمِسُّوهَا حَتَّى بِصْبُعْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","يَا وِيلْكُمْ، تِبْنِيوْ فِي قْبُورَاتْ الأَنْبِيَاءْ وجْدُودْكُمْ هُومَا الِّي قَتْلُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","إِنْتُومَا مَالَا شَاهْدِينْ ومْوَافْقِينْ عَلِّي عَمْلُوهْ جْدُودْكُمْ. هُومَا قَتْلُوا الأَنْبِيَاءْ وإِنْتُومَا تِبْنِيوْ قْبُورَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","هَاذَاكَا عْلَاشْ حِكْمِةْ اللَّهْ قَالِتْ: بِشْ نَبَعْثِلْهُمْ أَنْبِيَاءْ ورُسُلْ، مِنْهُمْ الِّي يُقْتْلُوهُمْ، ومِنْهُمْ الِّي يِضْطَهْدُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","هَاذَاكَا عْلَاشْ نْحَاسِبْ الجِيلْ هَاذَا عْلَى دَمْ الأَنْبِيَاءْ الكُلْ الِّي سَالْ مِلِّي تْخَلْقِتْ الدِّنْيَا، ");
INSERT INTO aeu_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","مِنْ دَمْ هَابِيلْ لْدَمْ زَكَرِيَّا الِّي تِقْتَلْ بِينْ المَذْبَحْ والقُدْسْ الِّي فِي الهَيْكِلْ! إِيْ نْعَمْ، نْأَكْدِلْكُمْ الِّي الدَّمْ هَاذَا الكُلْ بِشْ يِتْحَاسِبْ عْلِيهْ الجِيلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","يَا وِيلْكُمْ يَا عُلَمَاءْ الشَّرِيعَة! إِسْتَوْلِيتُوا عْلَى مِفْتَاحْ المَعْرْفَة، آمَا لَا دْخَلْتُوا إِنْتُومَا ولَا خَلِّيتُوا شْكُونْ يُدْخُلْ». ");
INSERT INTO aeu_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ووَقْتِلِّي خْرَجْ يَسُوعْ مِنْ غَادِي، بْدَاوْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ يِنْقْمُوا عْلِيهْ، ويِسْتَنْطْقُوا فِيهْ فِي بَرْشَة أُمُورْ، ");
INSERT INTO aeu_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ويْعِسُّوا فَمَّاشْ مَا يِزْلِقْ بْكِلْمَة يْشِدُّوهَا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","وفِي الوَقْتْ هَاذَاكَا، تْلَمُّوا عَشَرَاتْ الآلَافْ مِالعْبَادْ حَتَّى وَلَّاوْ يْعَفْسُوا فِي بْعَضْهُمْ، يَاخِي قَالْ يَسُوعْ لِتْلَامِذْتُو فِي الأُوِّلْ: «رُدُّوا بَالْكُمْ مِنْ خْمِيرِةْ الفِرِّيسِيِّينْ الِّي هِيَّ النِّفَاقْ، ");
INSERT INTO aeu_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","عْلَى خَاطِرْ كُلْ مَسْتُورْ بِشْ يِتْكْشِفْ، وكُلْ سِرْ بِشْ يِتَعْرَفْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","هَاذَاكَا عْلَاشْ كُلْ الِّي قُلْتُوهْ فِي الظْلَامْ بِشْ يِتْسْمَعْ فِي النُّورْ. ولِّي وَشْوَشْتُوهْ وْرَاء البِيبَانْ المْسَكْرَة، بِشْ يِتْبَرَّحْ بِيهْ مِنْ فُوقْ السْطُوحَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«ونْقُولِلْكُمْ يَا حْبَابِي: مَا تْخَافُوشْ مِلِّي يُقْتْلُوا البْدَنْ، ولِّي مَا يْنَجْمُوا يَعْمْلُوا شَيْ أَكْثِرْ مِنْ هَكَّا. ");
INSERT INTO aeu_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","آمَا نْوَرِّيكُمْ مِنْ شْكُونْ تْخَافُوا: خَافُوا مِلِّي بَعْدْمَا يُقْتِلْ البْدَنْ عَنْدُو القُدْرَة يَرْمِي فِي جْهَنِّمْ. إِيْ نْعَمْ، نْقُولِلْكُمْ، هَاذَا هُوَّ الِّي تْخَافُوا مِنُّو. ");
INSERT INTO aeu_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","«يَاخِي مُشْ خَمْسَة عْصَافِرْ يِتْبَاعُوا بْزُوزْ فْرَنْكْ؟ ومْعَ هَاذَا اللَّهْ مَا يِنْسَى حَتَّى وَاحِدْ مِنْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","آمَا إِنْتُومَا حَتَّى شْعَرْ رْيُوسْكُمْ مَحْسُوبْ بْكُلُّو، مَالَا مَا تْخَافُوشْ، رَاكُمْ إِنْتُومَا خِيرْ مِنْ بَرْشَة عْصَافِرْ! ");
INSERT INTO aeu_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«ونْقُولِلْكُمْ: الِّي يِسْتَعْرِفْ بِيَّا قُدَّامْ النَّاسْ، يِسْتَعْرِفْ بِيهْ إِبْنْ الإِنْسَانْ قُدَّامْ مْلَايِكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ولِّي يُنْكُرْنِي قُدَّامْ النَّاسْ، نُنْكْرُوا قُدَّامْ مْلَايِكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ولِّي يْقُولْ كِلْمَة ضِدْ إِبْنْ الإِنْسَانْ يِتْغْفِرْلُو، آمَا الِّي يَكْفِرْ بِالرُّوحْ القُدُسْ، مُشْ بِشْ يِتْغْفِرْلُو. ");
INSERT INTO aeu_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","«وكِي يْهِزُّوكُمْ بَاشْ تِتْحَاكْمُوا فِي المْعَابِدْ وقُدَّامْ الحُكَّامْ والنَّاسْ الِّي فِي السُّلْطَة، مَا تْخَمُّوشْ كِيفَاشْ ادَّافْعُوا عْلَى رْوَاحْكُمْ ولَا آشْ بِشْ تْقُولُوا، ");
INSERT INTO aeu_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","عْلَى خَاطِرْ فِي اللَّحْظَة هَاذِيكَا، الرُّوحْ القُدُسْ يْعَلِّمْكُمْ آشْ لَازِمْكُمْ تْقُولُوا». ");
INSERT INTO aeu_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","وقَالُّو وَاحِدْ مِالحَاضْرِينْ: «يَا مُعَلِّمْ، قُولْ لْخُويَا يَعْطِينِي بَايِي مِالوَرْثَة». ");
INSERT INTO aeu_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","آمَا هُوَّ قَالُّو: «يَا رَاجِلْ، شْكُونْ حَطْنِي عْلِيكُمْ قَاضِي وَلَّا قَسَّامْ وِرْثْ؟» ");
INSERT INTO aeu_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","وقَالْ لِلنَّاسْ: «رُدُّوا بَالْكُمْ وابْعْدُوا عْلَى كُلْ أَنْوَاعْ الطْمَعْ، عْلَى خَاطِرْ حْيَاةْ الإِنْسَانْ مُشْ فِي كُثْرِةْ أَمْلَاكُو». ");
INSERT INTO aeu_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","وقَالِلْهُمْ المَثَلْ هَاذَا: «فَمَّة رَاجِلْ غْنِيْ، أَرْضُو جَابِتْلُو صَابَة كْبِيرَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","يَاخِي خَمَّمْ وقَالْ: \"آشْ بِشْ نَعْمِلْ تَوَّا وآنَا مَا عَنْدِيشْ بْلَاصَة نْخَزِّنْ فِيهَا صَابْتِي؟\". ");
INSERT INTO aeu_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ومْبَعِّدْ قَالْ: \"هَاوْ آشْ بِشْ نَعْمِلْ: نْهِدْ المْخَازِنْ الِّي عَنْدِي ونِبْنِي مَا أَكْبِرْ مِنْهَا، ونْخَزِّنْ فِيهُمْ قَمْحِي وخِيرَاتِي الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ونْقُولْ لْرُوحِي: عَنْدِكْ خِيرَاتْ بْزَايِدْ مْخَزْنَة، تِكْفِيكْ سْنِينْ وسْنِينْ، إِرْتَاحْ وكُولْ وأُشْرُبْ وتْنَعِّمْ\". ");
INSERT INTO aeu_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","آمَا اللَّهْ قَالُّو: \"يَلِّي مَا تِفْهِمْشْ، اللِّيلَة هَاذِي تِطْلَعْ رُوحِكْ، وهَاذَا الِّي حَضَّرْتُو لِشْكُونْ بِشْ تْخَلِّيهْ؟\". ");
INSERT INTO aeu_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","وهَاذَا حَالْ الِّي يِكْنِزْ لْرُوحُو، ومَا يْكُونِشْ غْنِيْ لِلَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ومْبَعِّدْ قَالْ يَسُوعْ لِتْلَامِذْتُو: «هَاذَاكَا عْلَاشْ نْقُولِلْكُمْ: مَا تْعِيشُوشْ وإِنْتُومَا تْخَمُّوا فِي شْنُوَّة بِشْ تَاكْلُوا، ولَا فِي شْنُوَّة بِشْ تِلْبْسُوا. ");
INSERT INTO aeu_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","عْلَى خَاطِرْ الحَيَاةْ أَهَمْ مِالمَاكْلَة، والبْدَنْ أَهَمْ مِاللِّبْسَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ثَبْتُوا فِي الغِرْبَانْ: هِيَّ لَا تَزْرَعْ، لَا تَحْصِدْ، ولَا عَنْدْهَا مَخْزِنْ ولَا دِبُّو، واللَّهْ يُرْزُقْهَا. فَمَا بَالِكْ إِنْتُومَا الِّي أَحْسِنْ مِالعْصَافِرْ إِبَّرْشَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","وشْكُونْ فِيكُمْ إِذَا بْقَى يْخَمَّمْ يْنَجِّمْ يْزِيدْ فِي عُمْرُو حَتَّى سَاعَة وَحْدَة؟ ");
INSERT INTO aeu_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","إِذَا كَانْ مَا قْدَرْتُوشْ عَالأُمُورْ البْسِيطَة، مَالَا عْلَاشْ تَبْقَاوْ تْخَمُّوا عَالأُمُورْ الأُخْرَى؟ ");
INSERT INTO aeu_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","«ثَبْتُوا فِي النَّوَّارْ كِيفَاشْ يِكْبِرْ! وهُوَّ لَا يِتْعِبْ ولَا يِغْزِلْ. آمَا آنَا نْقُلْكُمْ: حَتَّى المَلِكْ سُلَيْمَانْ فِي عِزُّو مَا لْبِسْشْ كِيفْ وَحْدَة مِنْهُمْ! ");
INSERT INTO aeu_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","إِذَا كَانْ الحْشِيشْ الِّي يِنْبِتْ اليُومْ وغُدْوَة يِتْرْمَى فِي النَّارْ، اللَّهْ يْلَبْسُو كِيمَا هَكَّا، مُشْ إِنْتُومَا أَوْلَى إِنُّو يْلَبَّسْكُمْ يَلِّي إِيمَانْكُمْ ضْعِيفْ! ");
INSERT INTO aeu_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","مَالَا مَا تُقْعْدُوشْ تْخَمُّوا آشْ بِشْ تَاكْلُوا وآشْ بِشْ تُشْرْبُوا، ومَا تُقْعْدُوشْ مِتْقَلْقِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","الحَاجَاتْ هَاذِي الكُلْ يِجْرِيوْ وْرَاهَا شُعُوبْ العَالِمْ، آمَا بُوكُمْ الِّي فِي السْمَاء يَعْرِفْ الِّي إِنْتُومَا تَحْتَاجُولْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","آمَا أَسْعَاوْ لْمَمْلَكْةْ اللَّهْ، والحَاجَاتْ هَاذِي الكُلْ تَوْ تِتْزَادِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","مَا تْخَافُوشْ، يَلِّي كِيمَا القَطِيعْ الصْغِيرْ! رَاهُو بُوكُمْ الِّي فِي السْمَاء فَرْحَانْ إِنُّو يَعْطِيكُمْ المَمْلْكَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","«بِيعُوا الِّي تِمْلْكُوهْ واتْصَدْقُوا بِيهْ. وزَوْدُوا رْوَاحْكُمْ بْمَالْ مَا يُوفَاشْ، يْكُونْ كِنْزْ فِي السْمَاء مَا يِفْنَاشْ، وِينْ لَا يُقْرْبُو سَارَقْ ولَا يَاكْلُو السُّوسْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","عْلَى خَاطِرْ وِينْ يْكُونْ كِنْزِكْ يْكُونْ قَلْبِكْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«كُونُوا مُسْتْعَدِّينْ، مْشَمْرِينْ عْلَى ذْرَاعَاتْكُمْ وفْنَارَاتْكُمْ شَاعْلَة، ");
INSERT INTO aeu_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","وكُونُوا كِيفْ النَّاسْ الِّي يِسْتَنَّاوْ فِي سِيدْهُمْ وَقْتَاشْ يِرْجَعْ مِالعِرْسْ، بَاشْ دُوبْ مَا يُوصِلْ ويْدُقْ البَابْ يْحِلُّولُو بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","صَحَّة لِيهُمْ الخُدَّامْ الِّي وَقْتِلِّي يِرْجَعْ سِيدْهُمْ يَلْقَاهُمْ سَاهْرِينْ. نْقُلْكُمْ الحَقْ: رَاهُو يْشَمِّرْ عْلَى ذْرَاعُو ويْقَعَّدْهُمْ بَاشْ يَاكْلُوا ويَبْدَى يِخْدِمْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","صَحَّة لِيهُمْ كَانْ رْجَعْ سِيدْهُمْ مْعَ نُصْ اللِّيلْ وَلَّا بَعْدُو ولْقَاهُمْ سَاهْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","آمَا أَعْرْفُوا هَاذَا: كَانْ جَاء مُولَى الدَّارْ يَعْرِفْ وَقْتَاشْ يَهْبِطْ عْلِيهْ السَّارَقْ، رَاهُو مَا خَلَّاشْ دَارُو تِتْسْرَقْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","كُونُوا إِنْتُومَا زَادَا مُسْتْعَدِّينْ عْلَى خَاطِرْ إِبْنْ الإِنْسَانْ بِشْ يِرْجَعْ فِي سَاعَة مَا تِتْوَقْعُوهَاشْ». ");
INSERT INTO aeu_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","يَاخِي سِأْلُو بُطْرُسْ: «يَا سِيدِي، المَثَلْ هَاذَا تْقُولْ فِيهْ لِينَا أَحْنَا وَلَّا لِلنَّاسْ الكُلْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","وجَاوْبُو الرَّبْ يَسُوعْ: «شْكُونُو المَسْؤُولْ الثِّيقَة والحَكِيمْ الِّي يْكَلْفُو سِيدُو بَاشْ يَعْطِي لْخُدَّامُو الأُخْرِينْ بَايْهُمْ مِالمَاكْلَة فِي وَقْتْهَا؟ ");
INSERT INTO aeu_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","صَحَّة لِيهْ الخْدِيمْ هَاذَا، الِّي كِي يِرْجَعْ سِيدُو يَلْقَاهْ يِخْدِمْ فِي خِدْمْتُو. ");
INSERT INTO aeu_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","نْقُلْكُمْ الحَقْ: هَاذَا يْحُطُّو سِيدُو مَسْؤُولْ عْلَى أَمْلَاكُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","آمَا إِذَا كَانْ الخْدِيمْ هَاذَا قَالْ بِينُو وبِينْ رُوحُو: \"سِيدِي بِشْ يِرْجَعْ امَّخَّرْ\" وبْدَا يَضْرِبْ فِي الخُدَّامْ، نْسَاء ورْجَالْ، ويَاكِلْ ويُشْرُبْ ويِسْكِرْ، ");
INSERT INTO aeu_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","يِرْجَعْ سِيدُو عْلَى غَفْلَة، فِي نْهَارْ مَا يْجِيشْ عْلَى بَالُو وفِي سَاعَة مَا يَعْرِفْهَاشْ، ويْعَاقْبُو عِقَابْ كْبِيرْ ويِتْصَرِّفْ مْعَاهْ كِيمَا يِتْصَرِّفْ مْعَ الخُدَّامْ الخَايْنِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","والخْدِيمْ الِّي يَعْرِفْ آشْ يْحِبْ سِيدُو، ومَا يْحَضَّرْشْ رُوحُو ومَا يَعْمِلْشْ الِّي يْحِبْ عْلِيهْ سِيدُو، رَاهُو بِشْ يِتْضْرَبْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","آمَا الِّي مَا يَعْرِفْشْ آشْ يْحِبْ سِيدُو ويَعْمِلْ الِّي يِسْتَاهِلْ عْلِيهْ الضَّرْبْ، هَاذَاكَا يِتْضْرَبْ ضَرْبْ أَخَفْ. كُلْ الِّي تَعْطَالُو بَرْشَة يُطْلْبُوا مِنُّو بَرْشَة، ولِّي يِسْتَأْمْنُوهْ عْلَى بَرْشَة يْطَالْبُوهْ بْمَا أَكْثِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«جِيتْ بَاشْ نَرْمِي نَارْ عَالأَرْضْ، وقَدَّاشْ نِتْمَنَّي إِنْهَا تُكُونْ شِعْلِتْ! ");
INSERT INTO aeu_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","آمَا عَنْدِي وْجَايَعْ لَازِمْنِي نُغْطُسْ فِيهَا كِيمَا الِّي يُغْطُسْ فِي مَعْمُودِيِّةْ المَاء، ومَانِي بِشْ نَرْتَاحْ كَانْ مَا تْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","يَاخِي مَاشِي فِي بَالْكُمْ الِّي آنَا جِيتْ بَاشْ نْجِيبْ سَلَامْ لِلْأَرْضْ؟ لَا، آمَا جِيتْ بَاشْ نْفَرَّقْ بِينْ النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ومِنْ تَوَّا الدَّارْ الِّي فِيهَا خَمْسَة، بِشْ يِتْقَسْمُوا: ثْلَاثَة ضِدْ ثْنِينْ، وثْنِينْ ضِدْ ثْلَاثَة. ");
INSERT INTO aeu_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","البُو يْجِي ضِدْ وِلْدُو، والوْلَيِّدْ ضِدْ بُوهْ. الأُمْ ادُّورْ عْلَى بِنْتْهَا، والبْنَيَّة عْلَى أُمْهَا. الحْمَاة عْلَى كَنِّتْهَا، والكَنَّة عْلَى حْمَاتْهَا». ");
INSERT INTO aeu_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","وزَادْ قَالْ لِلنَّاسْ: «كِي تْشُوفُوا غِيمَة طَالْعَة مِالغَرْبْ، بِالوَقْتْ تْقُولُوا: \"المْطَرْ بَاشْ تْصُبْ\" وهَاذَاكَا الِّي يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","وإِذَا هَبِّتْ رِيحْ مِالجَنُوبْ، تْقُولُوا: \"الدِّنْيَا بِشْ تُسْخُنْ\" وهَاذَاكَا الِّي يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","يَا مُنَافْقِينْ! تَعْرْفُوا حَالِةْ الطَّقْسْ كِي تُخْزْرُوا لِلسْمَاء ولِلْأَرْضْ، وحَالِةْ الزْمَانْ هَاذَا مَا تَعْرْفُوهَاشْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«عْلَاشْ مَا تَعْرْفُوشْ تْمَيْزُوا الحَقْ وَحَّدْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","كِي تَبْدَى مَاشِي لِلْمَحْكْمَة مْعَ الِّي شَاكِي بِيكْ، أَعْمِلْ جِهْدِكْ بَاشْ تِتْصَالَحْ مْعَاهْ وإِنْتِ فِي الثْنِيَّة، بَاشْ مَا يْهِزِّكْشْ لِلقَاضِي، والقَاضِي يْسَلْمِكْ لِلْحَاكِمْ والحَاكِمْ يَرْمِيكْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","آنَا نْقُلِّكْ: مَاكِشْ بِشْ تُخْرُجْ مِنْ غَادِي حَتَّى لِينْ تْخَلِّصْ آخِرْ مِلِّيمْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","وفِي الوَقْتْ هَاذَاكَا، جَاوْ جْمَاعَة لْيَسُوعْ وحْكَاوْلُو عَالجَلِيلِيِّينْ الِّي قْتَلْهُمْ بِيلَاطُسْ، وخَلِّطْ دَمْهُمْ بْدَمْ الذْبَايَحْ مْتَاعْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","جَاوِبْهُمْ يَسُوعْ: «يَاخِي مَاشِي فِي بَالْكُمْ الِّي الجَلِيلِيِّينْ هَاذُوكُمْ صَارِلْهُمْ الِّي صَارْ عْلَى خَاطِرْهُمْ أَشَرْ مِنْ بْقِيِّةْ الجَلِيلِيِّينْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","آنَا نْقُلْكُمْ: لَا! وإِذَا مَا اتُّوبُوشْ، الكُلْكُمْ بِشْ تِمْشِيوْ لِلْهْلَاكْ كِيفْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","وَلَّا مَاشِي فِي بَالْكُمْ الِّي الثْمُنْطَاشِنْ وَاحِدْ الِّي طَاحْ عْلِيهُمْ البُرْجْ فِي سِلْوَامْ وقْتَلْهُمْ، كَانُوا أَشَرْ مِلِّي يُسْكْنُوا فِي أُورْشَلِيمْ الكُلْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","نْقُلْكُمْ: لَا! وإِذَا مَا اتُّوبُوشْ، الكُلْكُمْ بِشْ تِمْشِيوْ لِلْهْلَاكْ كِيفْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","وعْطَى المَثَلْ هَاذَا: «كَانْ فَمَّة وَاحِدْ عَنْدُو كَرْمَة مَغْرُوسَة فِي سَانْيِةْ العْنِبْ مْتَاعُو، مْشَالْهَا فِي بَالُو بِشْ يَلْقَى فِيهَا غَلَّة، يَاخِي مَا لْقَى فِيهَا شَيْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","قَالْ لِلْجَنَّانْ: \"تَوَّا ثْلَاثَة سْنِينْ وآنَا كُلْ مَا نْجِي لِلْكَرْمَة هَاذِي نْحِبْ عَالغَلَّة مَا نَلْقَى فِيهَا شَيْ. قُصْهَا! عْلَاشْ مَاخْذَة بْلَاصَة بِالفَارَغْ؟\". ");
INSERT INTO aeu_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","آمَا الجَنَّانْ جَاوْبُو: \"يَا سِيدِي خَلِّيهَا تْزِيدْ العَامْ هَاذَا، وتَوْ نِقْلْبِلْهَا التْرَابْ الدَّايِرْ بِيهَا ونْحُطِّلْهَا الغْبَارْ، ");
INSERT INTO aeu_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","بَالِكْشِي تْجِيبْ غَلَّة العَامْ الجَّايْ، وكَانْ مَا جَابِتْشْ قُصْهَا\"». ");
INSERT INTO aeu_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","وفِي سِبْتْ مِالأَسْبَاتْ، كَانْ يَسُوعْ يْعَلِّمْ فِي وَاحِدْ مِنْ مْعَابِدْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","وكَانِتْ فَمَّة مْرَا سَاكِنْهَا رُوحْ شِرِّيرْ، مْخُلِّيهَا ثْمُنْطَاشِنْ سْنَة مْرِيضَة وظْهَرْهَا مْقَوِّسْ، مَا تْنَجَّمْشْ تَاقِفْ مِسْتْوِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","وكِي شَافْهَا يَسُوعْ عَيْطِلْهَا وقَالِلْهَا: «يَا مْرَا إِنْتِ تْحَرَّرْتْ مِنْ مَرْضِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","وحَطْ يْدِيهْ عْلِيهَا، وبِالوَقْتْ وِقْفِتْ مِسْتْوِيَّة وبْدَاتْ تْمَجِّدْ فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","آمَا المَسْؤُولْ عَالمَعْبِدْ تْغَشِّشْ عْلَى خَاطِرْ يَسُوعْ شْفَى المْرَا فِي نْهَارْ السِّبْتْ، يَاخِي قَالْ لِلْحَاضْرِينْ: «عَنْدْكُمْ سِتَّة أَيَّامْ تِخْدْمُوا فِيهُمْ، إِيجَاوْ فِيهُمْ وتِشْفَاوْ كِيمَا تْحِبُّو، آمَا نْهَارْ السِّبْتْ لَا». ");
INSERT INTO aeu_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","يَاخِي جَاوْبُو الرَّبْ يَسُوعْ وقَالْ: «يَا مُنَافْقِينْ: يَاخِي مَا يْحِلِّشْ كُلْ وَاحِدْ فِيكُمْ رْبَاطْ ثُورُو وَلَّا بْهِيمُو فِي نْهَارْ السِّبْتْ ويْخَرْجُو مِالكُورِي ويْهِزْ يْشَرْبُو؟ ");
INSERT INTO aeu_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","والمْرَا هَاذِي الِّي هِيَّ بِنْتْ إِبْرَاهِيمْ، تَوَّا ثْمَنْطَاشِنْ سْنَة والشِّيطَانْ رَابِطْهَا، يَاخِي مَا تِسْتَاهِلْشْ يِتْحَلْ رْبَاطْهَا فِي نْهَارْ السِّبْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","وكِي قَالِلْهُمْ الكْلَامْ هَاذَا، الِّي عَارْضُوهْ الكُلْ حِشْمُوا عْلَى رْوَاحْهُمْ، والحَاضْرِينْ الكُلْ فَرْحُوا بِالأَعْمَالْ العْظِيمَة الِّي كَانْ يَعْمِلْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","وقَالْ يَسُوعْ: «لِشْنُوَّة تْشَبَّهْ مَمْلَكْةْ اللَّهْ؟ وبِشْنُوَّة انَّجِّمْ نْشَبَّهَّا؟ ");
INSERT INTO aeu_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","هِيَّ تْشَبَّهْ لْكَعْبِة خَرْدِلْ، هَزْهَا رَاجِلْ وزْرَعْهَا فِي جْنِينْتُو، يَاخِي نِبْتِتْ ووَلَّاتْ شَجْرَة كْبِيرَة، وجَاتْ طْيُورْ السْمَاء وعَشْشِتْ فِيهَا». ");
INSERT INTO aeu_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","وزَادْ قَالْ: «بَاشْ نْشَبَّهْ مَمْلَكْةْ اللَّهْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","هِيَّ تْشَبَّهْ لِخْمِيرَة هَزِّتْهَا مْرَا وحَطِّتْهَا فِي ثْلَاثَة كِيلَاتْ فَرِينَة حَتَّى لِينْ خِمْرِتْ العْجِينَة الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","وكَانْ يَسُوعْ يْعَلِّمْ فِي النَّاسْ فِي كُلْ مْدِينَة وقَرْيَة يِتْعَدَّى عْلِيهَا وهُوَّ فِي طْرِيقُو لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","وسِأْلُو وَاحِدْ: «يَا سِيدْنَا، يَاخِي مَا فَمَّة كَانْ شْوَيَّة مِالنَّاسْ بِشْ يِنْجَاوْ؟». آمَا هُوَّ قَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«أَعْمْلُوا مَجْهُودْكُمْ بَاشْ تُدْخْلُوا مِالبَابْ الضِّيِّقْ، عْلَى خَاطِرْ هَانِي نْقُولِلْكُمْ: بَرْشَة بِشْ يْحَاوْلُوا يُدْخْلُوا ومُشْ بِشْ يْنَجْمُوا. ");
INSERT INTO aeu_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","بَعْدْمَا يْكُونْ مُولَى الدَّارْ قَامْ وسَكِّرْ البَابْ، تَبْدَاوْ إِنْتُومَا وَاقْفِينْ لْبَرَّا، وادُّقُّوا عَالبَابْ وتْقُولُوا: \"يَا سِيدْنَا حِلِّلْنَا!\" يْجَاوِبْكُمْ: \"آنَا مَا نَعْرِفْشْ إِنْتُومَا مْنِينْ\". ");
INSERT INTO aeu_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","وَقْتْهَا تْقُولُوا: \"كْلِينَا وشْرَبْنَا مْعَاكْ، وإِنْتِ عَلَّمْتْ فِي شْوَارَعْنَا\". ");
INSERT INTO aeu_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","آمَا هُوَّ بِشْ يْقُولِلْكُمْ: \"آنَا مَا نَعْرِفْشْ إِنْتُومَا مْنِينْ! إِبْعْدُوا عْلِيَّا يَا أَشْرَارْ\". ");
INSERT INTO aeu_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","«غَادِي بِشْ يْكُونْ البْكَاء والنْدَمْ، كِي تْشُوفُوا إِبْرَاهِيمْ وإِسْحَاقْ ويَعْقُوبْ والأَنْبِيَاءْ الكُلْ فِي مَمْلَكْةْ اللَّهْ، وإِنْتُومَا مْطَيْشِينْ لْبَرَّا. ");
INSERT INTO aeu_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","وبِشْ يْجِيوْ نَاسْ مِالشَّرْقْ ومِالغَرْبْ ومِالشَّمَالْ ومِالجَنُوبْ ويُقْعْدُوا ويَاكْلُوا فِي مَمْلَكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","والإِخْرَانِينْ يْوَلِّيوْ هُومَا الأُولَانِينْ، والأُولَانِينْ يْوَلِّيوْ هُومَا الإِخْرَانِينْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","وفِي الوَقْتْ هَاذَاكَا، جَاوَهْ جْمَاعَة مِالفِرِّيسِيِّينْ وقَالُولُو: «إِمْشِي مِنْ هْنَا وأُهْرُبْ، عْلَى خَاطِرْ هِيرُودُسْ يْحِبْ يُقْتْلِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","يَاخِي قَالِلْهُمْ: «إِمْشِيوْ قُولُوا لْهَاكْ الثَّعْلِبْ: \"هَانِي نْخَرِّجْ فِي الشْوَاطِنْ ونِشْفِي فِي المُرْضَى اليُومْ وغُدْوَة، وفِي النْهَارْ الثَّالِثْ نْكَمِّلْ كُلْ شَيْ\". ");
INSERT INTO aeu_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","آمَا لَازِمْنِي نْكَمِّلْ نِمْشِي فِي طْرِيقِي اليُومْ وغُدْوَة وبَعْدْ غُدْوَة، عْلَى خَاطِرْ مَا فَمَّاشْ نَبِيْ يْمُوتْ لْبَرَّا مِنْ أُورْشَلِيمْ! ");
INSERT INTO aeu_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","«يَا أُورْشَلِيمْ، يَا أُورْشَلِيمْ، يَلِّي تُقْتُلْ الأَنْبِيَاءْ وتُرْجُمْ الِّي يِتْبَعْثُولِكْ، قَدَّاشْ مِنْ مَرَّة حَبِّيتْ نْلِمْ أَوْلَادِكْ، كِيفْ مَا تْلِمْ الدْجَاجَة فْلَالِسْهَا تَحْتْ جْنَاحَاتْهَا. آمَا إِنْتُومَا مَا حَبِّيتُوشْ. ");
INSERT INTO aeu_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","هَايْ دَارْكُمْ بِشْ تَبْقَالْكُمْ خِرْبَة! ونْقُلْكُمْ الحَقْ: مَا عَادِشْ بِشْ تْرَاوْنِي حَتَّى لِينْ يْجِي الوَقْتْ الِّي تْقُولُوا فِيهْ \"مُبَارَكْ الِّي جَايْ بْإِسْمْ الرَّبْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","وفِي نْهَارْ السِّبْتْ، دْخَلْ لْدَارْ وَاحِدْ مِنْ كْبَارْ الفِرِّيسِيِّينْ بَاشْ يَاكِلْ عَنْدُو، والحَاضْرِينْ كَانُوا يِتْرَصْدُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","وكَانْ قُدَّامُو وَاحِدْ مْرِيضْ بِالبُومِينَة. ");
INSERT INTO aeu_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","يَاخِي يَسُوعْ سْإِلْ عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ: «زَعْمَة حْلَالْ يْصِيرْ الشْفَى نْهَارْ السِّبْتْ وَلَّا لَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","آمَا هُومَا قَعْدُوا سَاكْتِينْ، يَاخِي يَسُوعْ هَزْ الرَّاجِلْ وشْفَاهْ وبَعْثُو يْرَوَّحْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ومْبَعِّدْ عَاوِدْ سْإِلْهُمْ: «شْكُونْ مِنْكُمْ كِي يْطِيحْ وِلْدُو وَلَّا ثُورُو فِي بِيرْ نْهَارْ السِّبْتْ، مَا يْخَرْجُوشْ بِالوَقْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ومَا نَجْمُوشْ يْجَاوْبُوهْ عَالسُّؤَالْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","وكِي لَاحِظْ الِّي المِسْتَدْعِينْ قَاعْدِينْ يَخْتَارُوا لِرْوَاحْهُمْ فِي البْلَايِصْ الأُولَى، عْطَاهُمْ المَثَلْ هَاذَا: ");
INSERT INTO aeu_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«وَقْتِلِّي يِسْتَدْعَاكْ وَاحِدْ لِلْعْشَاء فِي عِرْسْ، مَا تُقْعُدْشْ فِي البْلَاصَة الأُولَى، عْلَى خَاطِرْ مُمْكِنْ يْكُونْ مِسْتَدْعِي شْكُونْ أَهَمْ مِنِّكْ، ");
INSERT INTO aeu_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ويْجِي الِّي اسْتَدْعَاكُمْ ويْقُلِّكْ: \"خَلِّي البْلَاصَة لِلرَّاجِلْ هَاذَا\". وَقْتْهَا تْقُومْ وإِنْتِ حَاشِمْ، وتُقْعُدْ فِي البْلَاصَة الإِخْرَانِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","آمَا وَقْتِلِّي يِسْتَدْعَاوِكْ، إِمْشِي وأُقْعُدْ فِي إِخِّرْ بْلَاصَة، بَاشْ وَقْتِلِّي يْجِي الِّي اسْتَدْعَاكْ ويْقُلِّكْ: \"يَا صَاحْبِي إِيجَا وأُقْعُدْ لْقُدَّامْ\"، يْزِيدْ قَدْرِكْ قُدَّامْ الضْيُوفْ المَوْجُودِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","عْلَى خَاطِرْ، الِّي يْعَلِّي رُوحُو يَهْبِطْ، ولِّي يْطَيَّحْ مِنْ رُوحُو يَعْلَى». ");
INSERT INTO aeu_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","وزَادْ قَالْ لِلِّي اسْتَدْعَاهْ: «وَقْتِلِّي تَعْمِلْ فْطُورْ وَلَّا عْشَاء مَا تِسْتَدْعَاشْ لَا صْحَابِكْ ولَا خْوَاتِكْ ولَا الِّي يُقْرْبُولِكْ ولَا جِيرَانِكْ الغُنْيَا، بَاشْ مَا يِسْتَدْعَاوْكِشْ هُومَا زَادَا، وهَكَّا تِتْسَمَّى خْذِيتْ أَجْرِكْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","آمَا وَقْتِلِّي تَعْمِلْ عْشَاء، اسْتَدْعَى الفْقَارَى والمُعَاقِينْ والعَايْبِينْ والعِمْيَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ووَقْتْهَا صَحَّة لِيكْ، عْلَى خَاطِرْ هَاذُمْ مَا عَنْدْهُمْشْ بَاشْ يْرَجْعُولِكْ الأَجْرْ، وهَكَّا تَاخِذْ أَجْرِكْ وَقْتْ قْيَامِةْ الصَّالْحِينْ». ");
INSERT INTO aeu_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","وَقْتِلِّي سْمَعْ وَاحِدْ مِالمِسْتَدْعِينْ الكْلَامْ هَاذَا قَالْ: «صَحَّة لِلِّي بِشْ يَاكِلْ فِي مَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","جَاوْبُو يَسُوعْ: «فَمَّة رَاجِلْ عْمَلْ عْشَاء كْبِيرْ، واسْتَدْعَالُو بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","وفِي وَقْتْ العْشَاء بْعَثْ خْدِيمُو بَاشْ يْقُولْ لِلْمِسْتَدْعِينْ: \"إِيجَاوْ رَاوْ كُلْ شَيْ حَاضِرْ\". ");
INSERT INTO aeu_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","يَاخِي بْدَاوْ الكُلْ يِتْسَبْبُوا. وقَالْ الأُوِّلْ: \"آنَا شْرِيتْ سَانْيَة ولَازِمْنِي نِمْشِي نْشُوفْهَا، سَامَحْنِي مَا انَّجَّمْشْ نْجِي\". ");
INSERT INTO aeu_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ووَاحِدْ قَالْ: \"آنَا شْرِيتْ خَمْسَة زْوَازْ بْڨَرْ، ومَاشِي تَوَّا بَاشْ نْجَرَّبْهُمْ. سَامَحْنِي مَا انَّجَّمْشْ نْجِي\". ");
INSERT INTO aeu_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ووَاحِدْ آخِرْ قَالْ: \"مِزِّلْتْ كِي عَرِّسْتْ، مَا انَّجَّمْشْ نْجِي\". ");
INSERT INTO aeu_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","«ورْجَعْ الخْدِيمْ لْسِيدُو وحْكَالُو عَلِّي صَارْ. وَقْتْهَا تْغَشِّشْ مُولَى الدَّارْ وقَالْ لِخْدِيمُو: \"أُخْرُجْ فِيسَعْ لِشْوَارَعْ المْدِينَة وزْنَاقِيهَا وجِيبْ الفْقَارَى والمُعَاقِينْ والعَايْبِينْ والعِمْيَانْ لَهْنَا\". ");
INSERT INTO aeu_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","رْجَعْ الخْدِيمْ وقَالْ: \"يَا سِيدِي عْمَلْتْ الِّي قُتْلِي عْلِيهْ ومَزَّالِتْ فَمَّة بْلَايِصْ فَارْغَة\". ");
INSERT INTO aeu_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","يَاخِي قَالُّو سِيدُو: \"أُخْرُجْ لِلْكَيَّاسَاتْ والثْنَايَا، وشِدْ صْحِيحْ فِي النَّاسْ بَاشْ يُدْخْلُوا، حَتَّى لِينْ تِتْعَبَّى دَارِي. ");
INSERT INTO aeu_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","رَانِي نْأَكْدِلْكُمْ، وَلَا وَاحِدْ مِنْ هَاكْ الِّي اسْتَدْعِيتْهُمْ بِشْ يْذُوقْ مِنْ عْشَايَا\"». ");
INSERT INTO aeu_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","وكَانْ فَمَّة بَرْشَة نَاسْ مَاشِينْ مْعَ يَسُوعْ، يَاخِي تْلَفْتِلْهُمْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«كَانْ يْجِينِي وَاحِدْ، ومَا يْحِبْنِيشْ أَكْثِرْ مِنْ بُوهْ وأُمُّو ومَرْتُو ووْلَادُو وأَخْوْتُو وخْوَاتُو وحَتَّى أَكْثِرْ مِنْ رُوحُو، مَا يْنَجَّمْشْ يْكُونْ تِلْمِيذِي. ");
INSERT INTO aeu_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ولِّي مُشْ مُسْتْعَدْ يْقَاسِي العْذَابْ والمُوتْ مْعَايَا ويْتَبَّعْنِي، مَا يْنَجَّمْشْ يْكُونْ تِلْمِيذِي. ");
INSERT INTO aeu_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","«شْكُونْ فِيكُمْ كِي يْحِبْ يِبْنِي بُرْجْ، مَا يُقْعُدْشْ فِي الأُوِّلْ ويِحْسِبْ قَدَّاشْ يِتْكَلَّفْلُو، ويْشُوفْ إِذَا الفْلُوسْ الِّي عَنْدُو تِكْفِيهْ بَاشْ يْكَمِّلْ وَلَّا لَا؟ ");
INSERT INTO aeu_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","بَاشْ مَا يْحُطِّشْ السَّاسْ ومْبَعِّدْ مَا يْنَجَّمْشْ يْكَمِّلْ، والنَّاسْ يِضْحْكُوا عْلِيهْ ");
INSERT INTO aeu_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ويْقُولُوا: \"الرَّاجِلْ هَاذَا بْدَا يِبْنِي ومَا نَجَّمْشْ يْكَمِّلْ!\". ");
INSERT INTO aeu_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","«وشْكُونْ المَلِكْ الِّي مَاشِي يْحَارِبْ فِي مَلِكْ آخِرْ، ومَا يُقْعُدْشْ قْبَلْ ويِحْسِبْهَا، بَاشْ يَعْرِفْ إِذَا كَانْ يْنَجِّمْ يْحَارِبْ بْـ10 000 عَسْكْرِي الِّي جَايُو بْـ20 000؟ ");
INSERT INTO aeu_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","مَا كَانِشْ، يَبْعَثْ مَرْسُولْ مَادَامْ العْدُو مَزَّالْ بْعِيدْ، ويِسْإِلْ كِيفَاشْ يْنَجِّمْ يْرَجَّعْ السَّلَامْ بِينَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","وإِنْتُومَا زَادَا، أَيْ وَاحِدْ فِيكُمْ مَا يْسَلَّمْشْ فِلِّي يِمْلْكُو الكُلْ، مَا يْنَجَّمْشْ يْكُونْ تِلْمِيذِي. ");
INSERT INTO aeu_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«المِلْحْ بَاهِي، آمَا إِذَا كَانْ ضَيَّعْ مْلُوحِيتُو، كِيفَاشْ نْرَجْعُولُو طَعْمُو؟ ");
INSERT INTO aeu_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","لَا عَادْ يُصْلُحْ لَا لِلتْرَابْ ولَا لِلْغْبَارْ، ويِتْلَوَّحْ لْبَرَّا. الِّي عَنْدُو وِذْنِينْ تِسْمَعْ، خَلِّيهْ يِسْمَعْ!». ");
INSERT INTO aeu_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","كَانُوا المَكَّاسَة الكُلْ والمُذْنْبِينْ يِتْلَمُّوا بْيَسُوعْ بَاشْ يِسْمْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","يَاخِي بْدَاوْ الفِرِّيسِيِّينْ وعُلَمَاءْ الشَّرِيعَة يِتْشَكَّاوْ ويْقُولُوا: «الرَّاجِلْ هَاذَا يِفْرَحْ بِالمُذْنْبِينْ ويَاكِلْ مْعَاهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","وَلَّى يَسُوعْ عْطَاهُمْ المَثَلْ هَاذَا وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«شْكُونْ مِنْكُمْ عَنْدُو 100 عَلُّوشْ وضَيَّعْ وَاحِدْ مِنْهُمْ، مَا يْخَلِّيشْ 99 فِي الخْلَاء ويِمْشِي يْلَوِّجْ عَالعَلُّوشْ الضَّايَعْ حَتَّى لِينْ يَلْقَاهْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","وكِي يَلْقَاهْ، يْهِزُّو عْلَى كْتَافُو وهُوَّ فَرْحَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","وكِي يِرْجَعْ لْدَارُو يِسْتَدْعَى صْحَابُو وجِيرَانُو ويْقُولِلْهُمْ: \"إِفْرْحُوا مْعَايَا عْلَى خَاطِرْنِي لْقِيتْ عَلُّوشِي الضَّايَعْ!\". ");
INSERT INTO aeu_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","نْقُولِلْكُمْ: هَكَّا تْكُونْ الفَرْحَة فِي السْمَاء بْمُذْنِبْ وَاحِدْ يْتُوبْ، أَكْثِرْ مِنْ 99 صَالَحْ مَا يَحْتَاجُوشْ بَاشْ يْتُوبُوا. ");
INSERT INTO aeu_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«وكَانْ جَاتْ فَمَّة مْرَا عَنْدْهَا عَشْرَة بْيَاسَاتْ فُضَّة، وضَيْعِتْ مِنْهُمْ بْيَاسَة، مُشْ تْشَعِّلْ فْنَارَة وتُكْنُسْ الدَّارْ، وتْلَوِّجْ عْلِيهَا مْلِيحْ حَتَّى لِينْ تَلْقَاهَا؟ ");
INSERT INTO aeu_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","وكِي تَلْقَاهَا، تِسْتَدْعَى صَاحْبَاتْهَا وجِيرَانْهَا وتْقُولِلْهُمْ: \"إِفْرْحُوا مْعَايَا عْلَى خَاطِرْنِي لْقِيتْ بْيَاسْتِي الضَّايْعَة\". ");
INSERT INTO aeu_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","نْقُولِلْكُمْ: هَكَّا تْكُونْ الفَرْحَة بِينْ مْلَايِكْةْ اللَّهْ بْمُذْنِبْ وَاحِدْ يْتُوبْ». ");
INSERT INTO aeu_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","وقَالْ يَسُوعْ: «كَانْ فَمَّة رَاجِلْ عَنْدُو زُوزْ وْلَادْ، ");
INSERT INTO aeu_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","والصْغِيرْ فِيهُمْ قَالُّو: \"يَا بَابَا أَعْطِينِي بَايِي مِالوَرْثَة!\". يَاخِي بُوهُمْ قْسَمِّلْهُمْ كُلْ مَا يِمْلِكْ بِينَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","وبَعْدْ أَيَّامَاتْ، وِلْدُو الصْغِيرْ لَمْ الِّي يِمْلْكُو الكُلْ، ومْشَى لِبْلَادْ بْعِيدَة. وغَادِي بَذِّرْ فْلُوسُو الكُلْ فِي الطِّيشْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","وكِي صْرَفْ الِّي عَنْدُو الكُلْ، جَاتْ مَجَاعَة كْبِيرَة فِي البْلَادْ هَاذِيكَا، وبْدَا يِحْتَاجْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","رَصَّاتْلُو مْشَى يِخْدِمْ عَنْدْ وَاحِدْ مِنْ إِمَّالِي البْلَادْ هَاذِيكَا، يَاخِي بَعْثُو لِلسْوَانِي مْتَاعُو بَاشْ يَسْرَحْلُو بِالحْلَالِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","وكَانْ يِتْمَنَّى يْعَبِّي كِرْشُو بِالخَرُّوبْ الِّي كَانُوا يَاكْلُوا فِيهْ الحْلَالِفْ، آمَا حَدْ مَا عْطَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","«يَاخِي رْجَعْلُو شَاهِدْ لِعْقَلْ وقَالْ: \"قَدَّاشْ مِنْ خَدَّامْ عَنْدْ بَابَا عَنْدُو المَاكْلَة بِالفَاضِلْ، وآنَا هُونِي مِيِّتْ بِالشَّرْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","تَوَّا نْقُومْ ونِرْجَعْ لْبَابَا ونْقُلُّو: يَا بَابَا، آنَا غْلُطْتْ فِي حَقْ اللَّهْ وفِي حَقِّكْ، ");
INSERT INTO aeu_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ومَا نِسْتَاهِلْشْ نِتْسَمَّى وِلْدِكْ، إِحْسِبْنِي كِيمَا وَاحِدْ مِالخَدَّامَة مْتَاعِكْ\". ");
INSERT INTO aeu_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","«وقَامْ ورْجَعْ لْبُوهْ. وهُوَّ جَايْ مِنْ بْعِيدْ شَافُو بُوهْ، يَاخِي حَنْ عْلِيهْ وجْرَالُو وعَنْقُو وبَاسُو. ");
INSERT INTO aeu_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","وقَالْ الوْلِدْ لْبُوهْ: \"يَا بَابَا، آنَا غْلُطْتْ فِي حَقْ اللَّهْ وفِي حَقِّكْ ومَا نِسْتَاهِلْشْ نِتْسَمَّى وِلْدِكْ\". ");
INSERT INTO aeu_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","آمَا البُو قَالْ لْخَدَّامْتُو: \"فِيسَعْ جِيبُولُو أَحْسِنْ لِبْسَة ولَبْسُوهَالُو، وحُطُّولُو خَاتِمْ فِي صُبْعُو وصَبَّاطْ فِي سَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","وجِيبُوا العْجِلْ السْمِينْ واذْبْحُوهْ وخَلِّينَا نَاكْلُوا ونِفْرْحُوا. ");
INSERT INTO aeu_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","رَاهُو وِلْدِي هَاذَا كَانْ مِيِّتْ وحْيَى وكَانْ ضَايَعْ ولْقِيتُو\". وهَكَّا بْدَاوْ الحَفْلَة. ");
INSERT INTO aeu_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","«ووِلْدُو الكْبِيرْ كَانْ فِي السَّانْيَة، وكِي جَاء وقْرُبْ مِالدَّارْ، سْمَعْ صُوتْ الغْنَاء والشْطِيحْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","يَاخِي عَيِّطْ لْوَاحِدْ مِالخَدَّامَة، وسِأْلُو عَلِّي قَاعِدْ يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","جَاوْبُو الخَدَّامْ: \"خُوكْ رْجَعْ، وبُوكْ ذْبَحْلُو العْجِلْ السْمِينْ عْلَى خَاطْرُو رْجَعْلُو لَابَاسْ\". ");
INSERT INTO aeu_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","يَاخِي تْغَشِّشْ ومَا حَبِّشْ يُدْخُلْ. وَلَّى بُوهْ خْرَجْلُو وبْقَى يِتْشَحِّتْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","آمَا هُوَّ قَالُّو: \"آنَا نِخْدِمْ فِيكْ السْنِينْ هَاذِي الكُلْ، وعُمْرِي مَا طَيَّحْتْلِكْ كِلْمْتِكْ، وإِنْتِ وَلَا مَرَّة عْطِيتْنِي حَتَّى جَرْدْ بِرْشْنِي بَاشْ نِفْرَحْ بِيهْ مْعَ صْحَابِي. ");
INSERT INTO aeu_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","آمَا كِي رْجَعْ وِلْدِكْ هَاذَا، الِّي كْلَالِكْ رِزْقِكْ مْعَ النْسَاء الفَاسْدِينْ، ذْبَحْتْلُو العْجِلْ السْمِينْ\". ");
INSERT INTO aeu_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","«قَالُّو بُوهْ: \"يَا وْلِيدِي إِنْتِ دِيمَا مْعَايَا، ولِّي نِمْلْكُو الكُلْ هُوَّ لِيكْ. ");
INSERT INTO aeu_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","آمَا كَانْ لَازِمْنَا نِفْرْحُوا ونَعْمْلُوا حَفْلَة، عْلَى خَاطِرْ خُوكْ هَاذَا كَانْ مِيِّتْ وحْيَى، وكَانْ ضَايَعْ ولْقِينَاهْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","وزَادْ قَالْ لِتْلَامِذْتُو: «كَانْ فَمَّة رَاجِلْ غْنِيْ عَنْدُو وَاحِدْ مَسْؤُولْ عْلَى رِزْقُو، سْمَعْ بِيهْ قَاعِدْ يْبَذَّرْلُو فِي فْلُوسُو. ");
INSERT INTO aeu_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","يَاخِي عَيِّطْلُو وقَالُّو: \"شْنُوَّة الِّي قَاعِدْ نِسْمَعْ فِيهْ عْلِيكْ؟ أَعْطِي حْسَابْ عَلِّي صْرَفْتُو، عْلَى خَاطِرْ مِاليُومْ مَا عَادِشْ بِشْ تْكُونْ مَسْؤُولْ عْلَى رِزْقِي\". ");
INSERT INTO aeu_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","يَاخِي قَالْ بِينُو وبِينْ رُوحُو: \"سِيدِي بِشْ يْطَرِّدْنِي مِنْ خِدْمْتِي، آشْ بِشْ نَعْمِلْ؟ آنَا مَا عَنْدِيشْ جِهْدْ لِلْفْلَاحَة ونِحْشِمْ بَاشْ نْمِدْ يِدِّي لِلطُّلْبَة. ");
INSERT INTO aeu_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","عْرَفْتْ آشْ بِشْ نَعْمِلْ، بَاشْ حَتَّى كَانْ نَحَّالِي خِدْمْتِي، النَّاسْ يِقْبْلُونِي فِي دْيَارْهُمْ\". ");
INSERT INTO aeu_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","«واسْتَدْعَى الِّي كَانْ سِيدُو يْسَالْهُمْ وَاحِدْ وَاحِدْ. وسْإِلْ الأُوِّلْ: \"قَدَّاشْ سِيدِي يْسَالِكْ؟\". ");
INSERT INTO aeu_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","قَالُّو: \"100 بِرْمِيلْ زِيتْ زِيتُونَة\". يَاخِي قَالُّو: \"شِدْ كِمْبْيَالْتِكْ وأُقْعُدْ فِيسَعْ وإِكْتِبْ 50\". ");
INSERT INTO aeu_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","وقَالْ لْوَاحِدْ آخِرْ: \"وإِنْتِ فِي قَدَّاشْ مُسَالْ؟\". جَاوْبُو: \"100 شْكَارَة قَمْحْ\". يَاخِي قَالُّو: \"شِدْ كِمْبْيَالْتِكْ وإِكْتِبْ 80\". ");
INSERT INTO aeu_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","«والرَّاجِلْ مْدَحْ المَسْؤُولْ الِّي مَاهُوشْ أَمِينْ عْلَى خَاطْرُو تْصَرِّفْ بِذْكَاء. رَاهُو وْلَادْ العَالِمْ هَاذَا عَنْدْهُمْ حِكْمَة أَكْثِرْ مِنْ وْلَادْ النُّورْ فِي مُعَامْلَاتْهُمْ مْعَ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","وآنَا نْقُولِلْكُمْ: أَعْمْلُوا اصْحَابْ بِمَالْ الدِّنْيَا هَاذِي، بَاشْ نْهَارِةْ الِّي يُوفَى عْلِيكُمْ، يِقْبْلُوكُمْ فِي الدْيَّارْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","الأَمِينْ فِي الأُمُورْ البْسِيطَة، أَمِينْ زَادَا فِي الأُمُورْ الكْبِيرَة. ولِّي مُشْ أَمِينْ فِي الأُمُورْ البْسِيطَة، مُشْ أَمِينْ زَادَا فِي الأُمُورْ الكْبِيرَة. ");
INSERT INTO aeu_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","إِذَا مَا تْكُونُوشْ أُمَنَاءْ عَالْمَالْ البَاطِلْ، شْكُونْ بِشْ يْأَمِّنْكُمْ عْلَى مَالْ الحَقْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","وإِذَا مَا تْكُونُوشْ أُمَنَاءْ عْلَى حَاجِةْ غِيرْكُمْ، شْكُونْ بِشْ يَعْطِيكُمْ حَاجِتْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","حَتَّى خْدِيمْ مَا يْنَجِّمْ يِخْدِمْ زُوزْ أَسْيَادْ، عْلَى خَاطِرْ يَا إِمَّا بِشْ يِكْرَهْ وَاحِدْ ويْحِبْ الآخِرْ، وَلَّا بِشْ يْتَبَّعْ وَاحِدْ ويَحْقِرْ الآخِرْ. مَا تْنَجْمُوشْ تِخْدْمُوا اللَّهْ والفْلُوسْ مْعَ بْعَضْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","والفِرِّيسِيِّينْ كَانُوا يِسْمْعُوا فِي هَاذَا الكُلْ ويِتْمَسْخْرُوا عْلِيهْ، عْلَى خَاطِرْهُمْ كَانُوا يْحِبُّوا الفْلُوسْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","يَاخِي قَالِلْهُمْ يَسُوعْ: «تْحِبُّوا تُظْهْرُوا الِّي إِنْتُومَا صَالْحِينْ قُدَّامْ النَّاسْ، آمَا اللَّهْ يَعْرِفْ قْلُوبْكُمْ. رَاهُو الِّي يَعْتَبْرُوهْ النَّاسْ عْظِيمْ، هُوَّ مَكْرُوهْ عَنْدْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","«الشَّرِيعَة وكْتُبْ الأَنْبِيَاءْ بْقَاوْ لِينْ جَاء يُوحَنَّا. وبَعْدْهَا بْدَاتْ البْشَارَة بْمَمْلَكْةْ اللَّهْ، وكُلْ وَاحِدْ يَشْقَى بَاشْ يُدْخْلِلْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","آمَا رَاهُو أَسْهِلْ إِنُّو السْمَاء والأَرْضْ يِتْنَحَّاوْ مِنْ إِنُّو حَرْفْ وَاحِدْ مِالشَّرِيعَة يْطِيحْ». ");
INSERT INTO aeu_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","«الِّي يْطَلَّقْ مَرْتُو، ويْعَرِّسْ بِمْرَا أُخْرَى يَزْنَى، ولِّي يْعَرِّسْ بِمْرَا مْطَلْقَة يَزْنَى. ");
INSERT INTO aeu_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","«كَانْ فَمَّة رَاجِلْ غْنِيْ، يِلْبِسْ الغَالِي والمِذْخِمْ، وكُلْ يُومْ عَايِشْ فِي نَعِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","وكَانْ فَمَّة رَاجِلْ مِسْكِينْ إِسْمُو لِعَازِرْ، مَحْطُوطْ قُدَّامْ بَابْ دَارُو، وبَدْنُو لْكُلُّو دِمَّالْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","وكَانْ يِتْشَهَّى إِنُّو يِشْبَعْ مِالفِتْفَاتْ الطَّايَحْ مِنْ طَاوِلْةْ الغْنِيْ، وزِيدْ عْلَى هَاذَا حَتَّى الكْلَابْ كَانِتْ تْجِي وتَلْحِسْ الدِّمَّالْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","«ومَاتْ المِسْكِينْ وهَزِّتُّو المْلَايْكَة بَحْذَا إِبْرَاهِيمْ، والغْنِيْ زَادَا مَاتْ وتِدْفِنْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","وهُوَّ قَاعِدْ يِتْعَذَّبْ فِي الهَاوْيَة، هَزْ الغْنِيْ عِينِيهْ، يَاخِي شَافْ إِبْرَاهِيمْ مِنْ بْعِيدْ ولِعَازِرْ بَحْذَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","يَاخِي عَيِّطْ: \"يَا بَابَا إِبْرَاهِيمْ! أَرْحَمْنِي، وأَبْعَثْلِي لِعَازِرْ خَلِّيهْ يْغَطِّسْ طَرْتُوشِةْ صُبْعُو فِي المَاء ويْبَرِّدْلِي لْسَانِي، رَانِي مِتْعَذَّبْ فِي هَا النَّارْ\". ");
INSERT INTO aeu_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","آمَا إِبْرَاهِيمْ جَاوْبُو: \"يَا وِلْدِي اتْذَكِّرْ الِّي إِنْتِ خْذِيتْ بَايِكْ فِي الدِّنْيَا مِالخِيرَاتْ ولِعَازِرْ خْذَا بَايُو مِالبْلَاوَاتْ، آمَا تَوَّا هُوَّ قَاعِدْ يِتْعَزَّى هْنَا، وإِنْتِ تِتْعَذَّبْ. ");
INSERT INTO aeu_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","وفُوقْ هَاذَا الكُلْ، بِينَاتْنَا هَفْهُوفْ كْبِيرْ، مَا يْنَجِّمْ حَدْ يِتْعَدَّاهْ، لَا مِنْ عَنْدْنَا لْعَنْدْكُمْ ولَا مِنْ عَنْدْكُمْ لْعَنْدْنَا\". ");
INSERT INTO aeu_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","يَاخِي قَالُّو الغْنِيْ: \"مَالَا نِتْرَجَّاكْ يَا بَابَا إِبْرَاهِيمْ بَاشْ تَبْعَثُو لْدَارْ بَابَا، ");
INSERT INTO aeu_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","بَاشْ يْنَبَّهْ خْوَاتِي الخَمْسَة، ومَا تْرَصِّيلْهُمْشْ هُومَا زَادَا فِي بْلَاصَة العْذَابْ هَاذِي\". ");
INSERT INTO aeu_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","آمَا إِبْرَاهِيمْ قَالُّو: \"عَنْدْهُمْ كْتُبْ مُوسَى والأَنْبِيَاءْ! خَلِّي يَعْمْلُوا بِلِّي فِيهُمْ\". ");
INSERT INTO aeu_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","جَاوْبُو: \"لَا يَا بَابَا إِبْرَاهِيمْ، آمَا إِذَا كَانْ وَاحِدْ مِنْ بِينْ المُوتَى مْشَالْهُمْ تَوْ يْتُوبُوا\". ");
INSERT INTO aeu_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","قَالُّو إِبْرَاهِيمْ: \"إِذَا كَانْ مَا سَمْعُوشْ كْلَامْ مُوسَى والأَنْبِيَاءْ، مُشْ بِشْ يِقْتَنْعُوا حَتَّى لَوْ كَانْ قَامْ وَاحِدْ مِنْ بِينْ المُوتَى!\"». ");
INSERT INTO aeu_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","وقَالْ يَسُوعْ لِتْلَامِذْتُو: «أَكِيدْ بِشْ يْصِيرُوا حَاجَاتْ تْخَلِّي النَّاسْ يَعْمْلُوا الذْنُوبْ، آمَا يَا وِيلُو الِّي يْكُونْ هُوَّ السْبَبْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","يْكُونْ خِيرْلُو كَانْ تِتْرْبَطْ فِي رَقْبْتُو حَجْرِةْ رْحَى ويِتْرْمَى فِي البْحَرْ، مِنْ إِنُّو يْكُونْ سْبَبْ فِي إِنُّو وَاحِدْ مِالصْغَارْ هَاذُومَا يَعْمِلْ ذَنْبْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","«مَالَا رُدُّوا بَالْكُمْ. كَانْ خُوكْ عْمَلْ ذَنْبْ وَاجْهُو، وكَانْ تَابْ سَامْحُو. ");
INSERT INTO aeu_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","وكَانْ غْلُطْ فِي حَقِّكْ سَبْعَة مَرَّاتْ فِي النْهَارْ ورْجَعْلِكْ فِي كُلْ مَرَّة وقَالْ \"آنَا تُبْتْ\" سَامْحُو». ");
INSERT INTO aeu_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","وقَالُوا الرُّسُلْ لِلرَّبْ يَسُوعْ: «زِيدْ إِيمَانَّا». ");
INSERT INTO aeu_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","آمَا الرَّبْ يَسُوعْ جَاوِبْهُمْ: «كَانْ جَاء عَنْدْكُمْ إِيمَانْ قَدْ كَعْبِةْ الخَرْدِلْ، رَاكُمْ تْقُولُوا لْشَجْرِةْ التُّوتْ هَاذِي: \"اتْقَلَّعْ واتْغْرِسْ فِي البْحَرْ\" وهِيَّ اطِّيعْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","«شْكُونْ فِيكُمْ عَنْدُو خْدِيمْ يَحْرِثْ وَلَّا يِسْرَحْ بِالغْنَمْ، يْقُلُّو وَقْتِلِّي يِرْجَعْ مِالسَّانْيَة: \"إِيجَا تَوَّا وأُقْعُدْ كُولْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","مُشْ يْقُلُّو: \"حَضَّرْلِي العْشَاء، وشَمِّرْ عْلَى ذْرَاعِكْ وتِلْهَى بِيَّا حَتَّى لِينْ آنَا نَاكِلْ ونُشْرُبْ، ومْبَعِّدْ إِنْتِ كُولْ وأُشْرُبْ عْلَى رُوحِكْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","يَاخِي سِيدُو مَلْزُومْ يُشْكُرُو عْلَى خَاطْرُو عْمَلْ الِّي أَمْرُو بِيهْ؟ مَا نْظُنِّشْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","هَكَّاكَا إِنْتُومَا زَادَا، كِي تَعْمْلُوا الِّي تِأْمَرْتُوا بِيهْ لَازِمْ تْقُولُوا: \"أَحْنَا مَانَا إِلَّا خَدَّامَة، ومَعْمَلْنَا كَانْ الوَاجِبْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","وفِي نْهَارْ، وهُوَّ فِي طْرِيقُو لْأُورْشَلِيمْ، تْعَدَّى يَسُوعْ عَالسَّامْرَة والجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","وهُوَّ دَاخِلْ لْدَشْرَة، جَاوَهْ عَشْرَة رْجَالْ عَنْدْهُمْ البْرَصْ، ووِقْفُوا بْعِيدْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","وبْدَاوْ يْعَيْطُوا: «يَا يَسُوعْ، يَا سِيدْنَا، أَرْحَمْنَا». ");
INSERT INTO aeu_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","وكِي شَافْهُمْ يَسُوعْ قَالِلْهُمْ: «إِمْشِيوْ وَرِّيوْ رْوَاحْكُمْ لِلْكَهَنَة». وهُومَا مَاشِينْ طُهْرُوا مِالبْرَصْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","وكِي وَاحِدْ مِنْهُمْ شَافْ الِّي هُوَّ طْهُرْ، رْجَعْ وهُوَّ يْمَجِّدْ فِي اللَّهْ بْأَعْلَى صُوتُو. ");
INSERT INTO aeu_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","وهْبَطْ عْلَى وِجْهُو قُدَّامْ سَاقِينْ يَسُوعْ وشَكْرُو، والرَّاجِلْ هَاذَا كَانْ سَامْرِي. ");
INSERT INTO aeu_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","يَاخِي يَسُوعْ قَالْ: «مُشْ العَشْرَة رْجَالْ طُهْرُوا؟ مَالَا وِينْهُمْ التِّسْعَة الأُخْرِينْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","مِنْ بِينْهُمْ الكُلْ، مَا فَمَّة حَتَّى حَدْ رْجَعْ بَاشْ يْمَجِّدْ اللَّهْ غِيرْ هَا البَرَّانِي؟». ");
INSERT INTO aeu_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ومْبَعِّدْ قَالُّو: «قُومْ وإِمْشِي عْلَى رُوحِكْ، إِيمَانِكْ شْفَاكْ». ");
INSERT INTO aeu_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ووَقْتِلِّي الفِرِّيسِيِّينْ سِأْلُوهْ: «وَقْتَاشْ تْجِي مَمْلَكْةْ اللَّهْ؟» جَاوِبْهُمْ: «رَاهِي مَمْلَكْةْ اللَّهْ مَا تْجِيشْ بْطَرِيقَة تِتْشَافْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","ومَا يْقُولُوشْ: \"هَايْ هْنَا، وَلَّا: هَايْ غَادِي!\" عْلَى خَاطِرْ مَمْلَكْةْ اللَّهْ هِيَّ فِي وِسْطْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","وقَالْ لِتْلَامِذْتُو: «بِشْ يْجِي وَقْتْ تِتْمَنَّاوْ تْكُونُوا فِيهْ مْعَ إِبْنْ الإِنْسَانْ ولَوْ نْهَارْ وَاحِدْ، ومُشْ بِشْ تْنَجْمُوا. ");
INSERT INTO aeu_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","وبِشْ يْقُولُولْكُمْ: \"هَا هَوَّا هْنَا\" وَلَّا \"أَهَوْكَا غَادِي\". مَا تِمْشِيوِشْ، ومَا اتَّبْعُوهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","عْلَى خَاطِرْ كِيمَا البْرَقْ كِي يُبْرُقْ يْضَوِّي السْمَاء الكُلْ، هَكَّاكَا يْكُونْ إِبْنْ الإِنْسَانْ نْهَارِةْ الِّي يِرْجَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","آمَا فِي الأُوِّلْ لَازْمُو يِتْعَذَّبْ بَرْشَة والجِّيلْ هَاذَا يُرْفْضُو. ");
INSERT INTO aeu_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","«وكِيمَا صَارْ فِي أَيَّامْ نُوحْ، هَكَّاكَا بِشْ يْصِيرْ فِي أَيَّامْ إِبْنْ الإِنْسَانْ: ");
INSERT INTO aeu_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","كَانُوا النَّاسْ يَاكْلُوا ويُشْرْبُوا ويْعَرْسُوا ويْعَرْسُولْهُمْ، لِينْ جَاء النْهَارْ الِّي دْخَلْ فِيهْ نُوحْ لِلسْفِينَة، وجَاء الطُّوفَانْ وهْلِكْهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","وبِشْ يْكُونْ كِيمَا صَارْ زَادَا فِي زْمَانْ لُوطْ: كَانُوا يَاكْلُوا ويُشْرْبُوا، ويِشْرِيوْ ويْبِيعُوا، ويَزْرْعُوا ويِبْنِيوْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","آمَا نْهَارِةْ الِّي خْرَجْ لُوطْ مِنْ مْدِينِةْ سَدُومْ، مَطْرِتْ السْمَاء نَارْ وكِبْرِيتْ وهِلْكِتْهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","«هَكَّا بِشْ يْصِيرْ فِي النْهَارْ الِّي بِشْ يُظْهُرْ فِيهْ إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","فِي النْهَارْ هَاذَاكَا، الِّي يَبْدَى فُوقْ السْطَحْ ودَبْشُو فِي الدَّارْ، مَا يَهْبَطْشْ يْهِزُّو. ولِّي فِي السَّانْيَة مَا يِرْجَعْشْ لِلدَّارْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","اتْذَكْرُوا مَرْتْ لُوطْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","الِّي يْحِبْ يَحْفِظْ حْيَاتُو يَخْسَرْهَا، آمَا الِّي يَخْسَرْ حْيَاتُو هُوَّ الِّي يَحْفَظْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","نْقُولِلْكُمْ: فِي اللِّيلَة هَاذِيكَا يْكُونُوا زُوزْ رَاقْدِينْ فِي فَرْشْ وَاحِدْ، يِتْهَزْ وَاحِدْ ويِبْقَى الآخِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ويْكُونُوا زُوزْ نْسَاء يِرْحِيوْ مْعَ بْعَضْهُمْ، تِتْهَزْ وَحْدَة وتِبْقَى الأُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ويْكُونُوا زُوزْ رْجَالْ فِي السَّانْيَة، يِتْهَزْ وَاحِدْ ويِبْقَى الآخِرْ». ");
INSERT INTO aeu_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","يَاخِي سِأْلُوهْ تْلَامِذْتُو: «وِينْ بِشْ يْصِيرْ هَاذَا يَا سِيدْنَا؟» جَاوِبْهُمْ: «وِينْ فَمَّة الجِيفَة، غَادِي تِتْلَمْ النْسُورَة». ");
INSERT INTO aeu_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","وعْطَاهُمْ مَثَلْ يْبَيْنِلْهُمْ بِيهْ كِيفَاشْ يِلْزِمْهُمْ دِيمَا يْصَلِّيوْ ومَا يْمِلُّوشْ، ");
INSERT INTO aeu_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","وقَالْ: «كَانِتْ فَمَّة مْدِينَة فِيهَا قَاضِي مَا يْخَافِشْ اللَّهْ ومَا يْهِمُّو فِي حَدْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","وكَانِتْ فَمَّة مْرَا هَجَّالَة فِي نَفْسْ المْدِينَة، دِيمَا تْجِيهْ وتْقُلُّو: \"خُوذْلِي حَقِّي مِنْ عْدُويَا\". ");
INSERT INTO aeu_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","وبْقَى مُدَّة مَا يْحِبِّشْ يِقْبِلْ شْكَايِتْهَا. آمَا مْبَعِّدْ قَالْ بِينُو وبِينْ رُوحُو: \"صْحِيحْ آنَا مَا نْخَافِشْ اللَّهْ ومَا يْهِمْنِي فِي حَدْ، ");
INSERT INTO aeu_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","آمَا عْلَى خَاطِرْ الهَجَّالَة هَاذِي تْقَلَّقْ فِيَّا، بِشْ نَاخْذِلْهَا حَقْهَا، مَاكَانِشْ بِشْ تُقْعُدْ كُلْ مَرَّة تْكَسَّرْلِي فِي رَاسِي!\"». ");
INSERT INTO aeu_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","وقَالْ الرَّبْ يَسُوعْ: «إِسْمْعُوا القَاضِي الظَّالِمْ آشْ قَالْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","مَالَا زَعْمَة اللَّهْ مَا يَاخِذْشْ حَقْ الِّي إِخْتَارْهُمْ، الِّي يِتْضَرْعُولُو لِيلْ ونْهَارْ؟ زَعْمَة يِبْطَى عْلِيهُمْ ومَا يْجَاوِبْهُمْشْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","نْقُولِلْكُمْ: رَاهُو فِيسَعْ يَاخْذِلْهُمْ حَقْهُمْ. آمَا وَقْتِلِّي يِرْجَعْ إِبْنْ الإِنْسَانْ، زَعْمَة يَلْقَى إِيمَانْ عَالأَرْضْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","وعْطَى زَادَا مَثَلْ لِلنَّاسْ الِّي يِعْتَبْرُوا رْوَاحْهُمْ صَالْحِينْ، ويَحْقْرُوا غِيرْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«فَمَّة زُوزْ رْجَالْ طَلْعُوا لِلْهَيْكِلْ بَاشْ يْصَلِّيوْ، وَاحِدْ فِرِّيسِي والآخِرْ مَكَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","وْقِفْ الفِرِّيسِي يْصَلِّي فِي قَلْبُو وقَالْ: \"نُشْكْرِكْ يَا اللَّهْ، عْلَى خَاطِرْنِي مَانِيشْ كِيمَا بْقِيِّةْ النَّاسْ الأُخْرِينْ الطَّمَّاعِينْ والظَّالْمِينْ والزَّانِينْ، ولَا كِيمَا المَكَّاسْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","نْصُومْ مَرْتِينْ فِي الجِّمْعَة، ونَعْطِي العْشُرْ مِلِّي نِكْسْبُو الكُلْ\". ");
INSERT INTO aeu_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","آمَا المَكَّاسْ، وْقِفْ مِنْ بْعِيدْ ومَا حَبِّشْ حَتَّى يْهِزْ عِينِيهْ لِلسْمَاء، آمَا كَانْ يَضْرِبْ عْلَى صِدْرُو ويْقُولْ: \"يَا اللَّهْ أَرْحَمْنِي، آنَا المُذْنِبْ\". ");
INSERT INTO aeu_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","نْقُولِلْكُمْ: الِّي رْجَعْ لْدَارُو واللَّهْ مُعْتَبْرُو صَالَحْ هُوَّ المَكَّاسْ مُشْ الفِرِّيسِي. عْلَى خَاطِرْ الِّي يْعَلِّي رُوحُو يَهْبِطْ، ولِّي يْطَيَّحْ مِنْ رُوحُو يَعْلَى». ");
INSERT INTO aeu_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","وجَاوْ نَاسْ وجَابُولُو صْغَارْ بَاشْ يْحُطْ عْلِيهُمْ يِدُّو ويْبَارِكْهُمْ، وكِي شَافُوهُمْ التْلَامْذَة لَامُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","آمَا يَسُوعْ عَيِّطْ لِلصْغَارْ وقَالْ: «خَلِّيوْ الصْغَارْ يْجِيوْنِي ومَا تَمْنْعُوهُمْشْ، عْلَى خَاطِرْ مَمْلَكْةْ اللَّهْ هِيَّ لِلنَّاسْ الِّي كِيفْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","نْقُولِلْكُمْ الحَقْ: الِّي مَا يِقْبِلْشْ مَمْلَكْةْ اللَّهْ كِيمَا الطْفُلْ الصْغِيرْ عُمْرُو مَا يُدْخْلِلْهَا». ");
INSERT INTO aeu_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","وسِأْلُو وَاحِدْ مِالأَعْيَانْ: «إِنْتِ مُعَلِّمْ صَالَحْ، قُلِّي آشْ نَعْمِلْ بَاشْ نُورِثْ الحَيَاةْ الأَبَدِيَّة؟». ");
INSERT INTO aeu_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","آمَا يَسُوعْ قَالُّو: «عْلَاشْ تْعَيِّطْلِي صَالَحْ؟ مَا فَمَّة حَتَّى وَاحِدْ صَالَحْ كَانْ اللَّهْ وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","إِنْتِ تَعْرِفْ الوْصَايَا: مَا تَزْنَاشْ، مَا تَعْمِلْشْ جْرِيمِةْ قَتْلْ، مَا تِسْرَقْشْ، مَا تِشْهِدْشْ بِالكِذْبْ، إِكْرِمْ بُوكْ وأُمِّكْ». ");
INSERT INTO aeu_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","قَالُّو الرَّاجِلْ: «الوْصَايَا هَاذُمْ الكُلْ نْطَبَّقْ فِيهُمْ مِنْ صُغْرِي». ");
INSERT INTO aeu_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","وكِي سْمَعْ يَسُوعْ الكْلَامْ هَاذَا قَالُّو: «مَزَّالِتْ نَاقْصِتِّكْ حَاجَة وَحْدَة: بِيعْ الِّي عَنْدِكْ الكُلْ وفَرْقُو عَالفْقَارَى، وهَكَّا يْوَلِّي عَنْدِكْ كِنْزْ فِي السْمَاء، ومْبَعِّدْ إِيجَا تَبَّعْنِي». ");
INSERT INTO aeu_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","آمَا الرَّاجِلْ كِي سْمَعْ الكْلَامْ هَاذَا، حْزِنْ عَالإِخِّرْ، عْلَى خَاطْرُو كَانْ غْنِيْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","وكِي شَافُو يَسُوعْ كِيفَاشْ حْزِنْ، قَالْ: «مَصْعِبْ دْخُولْ الغْنِيِّينْ لْمَمْلَكْةْ اللَّهْ! ");
INSERT INTO aeu_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","رَاهُو دْخُولْ الجْمَلْ مِنْ نُقْبِةْ الإِبْرَة أَسْهِلْ مِنْ دْخُولْ الغْنِيْ لْمَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ولِّي كَانُوا يِسْمْعُوا فِيهْ قَالُوا: «مَالَا شْكُونْ يْنَجِّمْ يِنْجَى؟». ");
INSERT INTO aeu_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","قَالِلْهُمْ يَسُوعْ: «المُسْتَحِيلْ عَنْدْ النَّاسْ، اللَّهْ يَقْدِرْ عْلِيهْ». ");
INSERT INTO aeu_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","وقَالُّو بُطْرُسْ: «هَانَا أَحْنَا خَلِّينَا الِّي عَنْدْنَا الكُلْ وتَبَّعْنَاكْ!». ");
INSERT INTO aeu_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","يَاخِي قَالِلْهُمْ: «نْقُلْكُمْ الحَقْ: كُلْ مِنْ خَلَّى دَارْ، وَلَّا مْرَا، وَلَّا خْوَاتْ، وَلَّا وَالْدِينْ، وَلَّا وْلَادْ، عْلَى خَاطِرْ مَمْلَكْةْ اللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","بِشْ يَاخِذْ فِي الزْمَانْ هَاذَا أَضْعَافْ الِّي خَلَّاهْ، ويَاخِذْ فِي الزْمَانْ الجَايْ الحَيَاةْ الأَبَدِيَّة». ");
INSERT INTO aeu_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","وبَعْدْهَا جْبِدْ الأَثْنَاشِنْ تِلْمِيذْ عْلَى جْنَبْ وقَالِلْهُمْ: «هَاوْ بِشْ نِطْلْعُوا لْأُورْشَلِيمْ، ولِّي كِتْبُوهْ الأَنْبِيَاءْ عْلَى إِبْنْ الإِنْسَانْ الكُلْ بِشْ يْتِمْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","رَاهُو بِشْ يْسَلْمُوهْ لِلِّي مَاهُمْشْ يْهُودْ، وبِشْ يِتْمَسْخْرُوا عْلِيهْ ويْسِبُّوهْ ويِبْزْقُوا عْلِيهْ، ");
INSERT INTO aeu_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","وبَعْدْمَا يِجْلْدُوهْ يُقْتْلُوهْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ». ");
INSERT INTO aeu_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","آمَا التْلَامْذَة مَا فِهْمُوا حَتَّى شَيْ، والكْلَامْ كَانْ غَامِضْ عْلِيهُمْ، ومَا عَرْفُوشْ شْنِيَّة يُقْصِدْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","وكِي قْرُبْ يَسُوعْ مِنْ مْدِينِةْ أَرِيحَا، كَانْ فَمَّة وَاحِدْ أَعْمَى قَاعِدْ عْلَى جْنَبْ الطْرِيقْ يُطْلُبْ. ");
INSERT INTO aeu_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","وكِي سْمَعْ حِسْ بَرْشَة نَاسْ مِتْعَدِّينْ، سْإِلْ: «آشْ فَمَّة؟». ");
INSERT INTO aeu_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","قَالُولُو: «يَسُوعْ النَّاصْرِي مِتْعَدِّي مِنْ هْنَا». ");
INSERT INTO aeu_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","يَاخِي بْدَا يْعَيِّطْ: «يَا يَسُوعْ وِلْدْ دَاوِدْ، أَرْحَمْنِي!». ");
INSERT INTO aeu_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","والنَّاسْ الِّي قَاعْدِينْ يِمْشِيوْ مِالقُدَّامْ صَاحُوا عْلِيهْ بَاشْ يُسْكُتْ، آمَا هُوَّ وَلَّى يْعَيِّطْ أَكْثِرْ: «يَا وِلْدْ دَاوِدْ، أَرْحَمْنِي!». ");
INSERT INTO aeu_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","يَاخِي وْقِفْ يَسُوعْ وقَالِلْهُمْ يْجِيبُوهُولُو، وكِي قْرُبْ مِنُّو سِأْلُو: ");
INSERT INTO aeu_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«شْنُوَّة تْحِبْنِي نَعْمَلِّكْ؟». قَالْ: «يَا سِيدِي، نْحِبْ نْوَلِّي نْشُوفْ!». ");
INSERT INTO aeu_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","قَالُّو يَسُوعْ: «تْنَجِّمْ تْشُوفْ، إِيمَانِكْ شْفَاكْ». ");
INSERT INTO aeu_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","وبِالوَقْتْ وَلَّى يْشُوفْ، وتَبْعُو وهُوَّ يْسَبَّحْ فِي اللَّهْ. والنَّاسْ الكُلْ كِي شَافُوا الِّي صَارْ، مَجْدُوا اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ودْخَلْ يَسُوعْ لِمْدِينِةْ أَرِيحَا وتْعَدَّى فِي وِسْطْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","وكَانْ فَمَّة غَادِي رَاجِلْ غْنِيْ إِسْمُو زَكَّا، وكَانْ رَئِيسْ المَكَّاسَة. ");
INSERT INTO aeu_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","وحَاوِلْ يْشُوفْ شْكُونْ هُوَّ يَسُوعْ، آمَا مَا نَجَّمْشْ عْلَى خَاطِرْ كَانُوا فَمَّة بَرْشَة نَاسْ قُدَّامُو، وزِيدْ هُوَّ قْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","يَاخِي سْبِقْ يِجْرِي وطْلَعْ فُوقْ شَجْرَة بَاشْ يْشُوفُو، عْلَى خَاطِرْ يَسُوعْ كَانْ بِشْ يِتْعَدَّى مِنْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","وكِي وْصِلْ يَسُوعْ لِلْبْلَاصَة هَاذِيكَا، هَزْ عِينِيهْ وشَافُو، يَاخِي قَالُّو: «يَا زَكَّا، أَهْبِطْ فِيسَعْ، رَاهُو لَازِمْنِي نَبْقَى فِي دَارِكْ اليُومْ». ");
INSERT INTO aeu_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","وَلَّى زَكَّا هْبَطْ فِيسَعْ، وضَيْفُو وكَانْ فَرْحَانْ بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","وكِي شَافُوا النَّاسْ الِّي صَارْ، بْدَاوْ يِتْشَكَّاوْ، ويْقُولُوا: «دْخَلْ لْدَارْ وَاحِدْ مُذْنِبْ بَاشْ يْبَاتْ عَنْدُو!». ");
INSERT INTO aeu_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","آمَا زَكَّا وْقِفْ وقَالْ لِلرَّبْ يَسُوعْ: «يَا سِيدِي، هَانِي بِشْ نَعْطِي نُصْ ثَرْوْتِي لِلْفْقَارَى. وإِذَا كَانْ خْذِيتْ عْلَى وَاحِدْ حَاجَة زَايْدَة، نْرَجَّعْلُو قَدْهَا أَرْبْعَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","يَاخِي قَالُّو يَسُوعْ: «اليُومْ نْجَاوْ أَهْلْ الدَّارْ هَاذِي، عْلَى خَاطِرْ الرَّاجِلْ هَاذَا هُوَّ زَادَا وِلْدْ إِبْرَاهِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","رَاهُو إِبْنْ الإِنْسَانْ جَاء بَاشْ يْلَوِّجْ عَلِّي مَاشِينْ لِلْهْلَاكْ ويْنَجِّيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","وهُومَا قَاعْدِينْ يِسْمْعُوا فِي الكْلَامْ هَاذَا، زَادْ يَسُوعْ عْطَاهُمْ مَثَلْ، عْلَى خَاطْرُو قْرُبْ مِنْ أُورْشَلِيمْ والنَّاسْ كَانْ مَاشِي فِي بَالْهُمْ الِّي مَمْلَكْةْ اللَّهْ بِشْ تُظْهُرْ فِي لَحْظِتْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","وقَالْ: «فَمَّة وَاحِدْ مِالأَعْيَانْ سَافِرْ لِبْلَادْ بْعِيدَة، بَاشْ يِتْعَيِّنْ مَلِكْ ومْبَعِّدْ يِرْجَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","عَيِّطْ لْعَشْرَة مِنْ خُدَّامُو، وعْطَى لْكُلْ وَاحِدْ فِيهُمْ بْيَاسَة ذْهَبْ، وقَالِلْهُمْ: تَاجْرُوا بِيهُمْ حَتَّى لِينْ نِرْجَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","«آمَا وْلَادْ بْلَادُو كَانُوا يِكْرْهُوهْ، وبَعْثُوا وْرَاهْ جْمَاعَة يْقُولُوا: \"مَا نْحِبُّوشْ هَاذَا يْكُونْ مَلِكْ عْلِينَا\". ");
INSERT INTO aeu_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ورْجَعْ بَعْدْمَا تْعَيِّنْ مَلِكْ، وعْطَى أَمْرْ بَاشْ يْعَيْطُوا لِلْخُدَّامْ الِّي عْطَاهُمْ البْيَاسَاتْ الذْهَبْ، بَاشْ يْشُوفْ قَدَّاشْ رْبِحْ كُلْ وَاحِدْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","جَاء الأُوِّلْ وقَالْ: \"يَا سِيدِي، بْيَاسْتِكْ الذْهَبْ جَابِتْ عَشْرَة كِيفْهَا\". ");
INSERT INTO aeu_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","يَاخِي قَالُّو: \"صَحِّيتْ، إِنْتِ خْدِيمْ صَالَحْ. عْلَى خَاطْرِكْ كُنْتْ أَمِينْ فِي القْلِيلْ، بِشْ نْحُطِّكْ حَاكِمْ عْلَى عَشْرَة مُدُنْ\". ");
INSERT INTO aeu_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","وجَاء الثَّانِي وقَالْ: \"يَا سِيدِي، بْيَاسْتِكْ الذْهَبْ جَابِتْ خَمْسَة كِيفْهَا\". ");
INSERT INTO aeu_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","قَالُّو: \"إِنْتِ بِشْ نْحُطِّكْ حَاكِمْ عْلَى خَمْسَة مُدُنْ\". ");
INSERT INTO aeu_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","وجَاء وَاحِدْ آخِرْ وقَالْ: \"يَا سِيدِي، هَايْ بْيَاسْتِكْ الذْهَبْ، لَفِّيتْهَا فِي مَنْدِيلَة وخَبِّيتْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","رَانِي كُنْتْ خَايِفْ مِنِّكْ، عْلَى خَاطْرِكْ إِنْسَانْ صْعِيبْ، تَاخِذْ الِّي مُشْ لِيكْ، وتَحْصِدْ الِّي مَا زَرْعِتُّوشْ يْدِيكْ\". ");
INSERT INTO aeu_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","قَالُّو: \"مِنْ كْلَامِكْ بِشْ نُحْكُمْ عْلِيكْ، يَا خْدِيمْ يَا شِرِّيرْ. إِنْتِ تَعْرِفْ الِّي آنَا إِنْسَانْ صْعِيبْ، نَاخِذْ الِّي مُشْ لِيَّا، ونَحْصِدْ الِّي مَا زَرْعِتُّوشْ يْدَيَّا، ");
INSERT INTO aeu_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","مَالَا عْلَاشْ مَا حَطِّيتْلِيشْ فْلُوسِي فِي البَانْكَة بَاشْ عَالأَقَلْ كِي نِرْجَعْ، نَاخُذْهُمْ ومْعُاهُمْ رِبْحْ؟\". ");
INSERT INTO aeu_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","مْبَعِّدْ قَالْ لِلْحَاضْرِينْ غَادِي: \"خُوذُوا مِنْ عَنْدُو البْيَاسَة الذْهَبْ وأَعْطِيوْهَا لِلِّي عَنْدُو عَشْرَة بْيَاسَاتْ\". ");
INSERT INTO aeu_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","قَالُولُو: \"يَا سِيدْنَا رَاهُو عَنْدُو عَشْرَة بْيَاسَاتْ ذْهَبْ!\". ");
INSERT INTO aeu_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","جَاوِبْهُمْ: \"الِّي عَنْدُو بِشْ يِتْزَادْلُو، ولِّي مَا عَنْدُوشْ، حَتَّى الِّي عَنْدُو بِشْ يِتْفَكْلُو. ");
INSERT INTO aeu_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","آمَا الأَعْدَاءْ مْتَاعِي، الِّي مَا حَبُّونِيشْ نِمْلِكْ عْلِيهُمْ، جِيبُوهُمْلِي لَهْنَا وأَذْبْحُوهُمْ قُدَّامِي\"». ");
INSERT INTO aeu_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","وبَعْدْمَا كَمِّلْ يَسُوعْ كْلَامُو، مْشَى هُوَّ الأُوِّلْ وشَدْ ثْنِيِّةْ أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","وكِي قْرُبْ مِنْ دَشْرِةْ بَيْتْ فَاجِي ودَشْرِةْ بَيْتْ عَنْيَا الِّي بَحْذَا الجْبَلْ المْسَمِّينُوا جْبَلْ الزِّيتُونْ، بْعَثْ زُوزْ مِنْ تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","وقَالِلْهُمْ: «إِمْشِيوْ لِلدَّشْرَة الِّي مْقَابْلِتْكُمْ، ودُوبْ مَا تُدْخْلُوهَا بِشْ تَلْقَاوْ جَحْشْ مَرْبُوطْ عُمْرُو مَا رْكِبْ عْلِيهْ حَتَّى حَدْ، حِلُّولُو الرْبَاطْ وجِيبُوهُولِي لَهْنَا. ");
INSERT INTO aeu_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","وإِذَا كَانْ وَاحِدْ سْإِلْكُمْ: \"عْلَاشْ تْحِلُّولُو فِي الرْبَاطْ؟\" قُولُولُو: \"سِيدْنَا حَاشْتُو بِيهْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ومْشَاوْ الزُّوزْ تْلَامْذَة الِّي بْعَثْهُمْ، ولْقَاوْ كُلْ شَيْ كِيفْ مَا قَالِلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","وهُومَا قَاعْدِينْ يْحِلُّوا فِي الرْبَاطْ، سِأْلُوهُمْ إِمَّالِي الجَّحْشْ: «عْلَاشْ تْحِلُّوا فِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","قَالُوا: «سِيدْنَا حَاشْتُو بِيهْ». ");
INSERT INTO aeu_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","وجَابُولُو الجَّحْشْ، وحَطُّوا عْلِيهْ حْوَايِجْهُمْ، ورَكّْبُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","وهُوَّ مِتْعَدِّي، بْدَاوْ النَّاسْ يِفْرْشُوا فِي حْوَايِجْهُمْ عَالطْرِيقْ بَاشْ يِكْرْمُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","وكِي قْرُبْ مِنْ أُورْشَلِيمْ، فِي الهَبْطَة مْتَاعْ جْبَلْ الزِّيتُونْ، بْدَاوْ تْلَامِذْتُو الكُلْ يْسَبْحُوا فِي اللَّهْ بْصُوتْ عَالِي وهُومَا فَرْحَانِينْ، عَالمُعْجْزَاتْ الِّي شَافُوهَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","ويْقُولُوا: «مُبَارَكْ المَلِكْ الِّي جَايْ بْإِسْمْ الرَّبْ! سَلَامْ فِي السْمَاء، ومَجْدْ فِي الأَعَالِي!». ");
INSERT INTO aeu_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","آمَا جْمَاعَة مِالفِرِّيسِيِّينْ الِّي كَانُوا مَوْجُودِينْ غَادِي قَالُولُو: «يَا مُعَلِّمْ، سَكِّتْ تْلَامِذْتِكْ!». ");
INSERT INTO aeu_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","جَاوِبْهُمْ يَسُوعْ: «نْقُولِلْكُمْ: إِذَا هُومَا يُسْكْتُوا، الحْجَرْ يَنْطَقْ!». ");
INSERT INTO aeu_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","وكِي قْرُبْ لْأُورْشَلِيمْ وشَافْهَا، بْكَى عْلِيهَا. ");
INSERT INTO aeu_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","وقَالْ: «يَا لِيتِكْ اليُومْ عْرَفْتْ شْنُوَّة الِّي فِيهْ سَلَامِكْ! آمَا هَاذَا تَوَّا مَحْجُوبْ عْلَى عِينِيكْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","بِشْ تْجِي عْلِيكْ أَيَّامَاتْ يْسَيْجُوا عْلِيكْ أَعْدَائِكْ، ويَحْصْرُوكْ ويْضَيْقُوا عْلِيكْ مِنْ كُلْ شِيرَة ");
INSERT INTO aeu_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ويْهِدُّوكْ عَالسَّاكْنِينْ فِيكْ، ومَا يْخَلِّيوِشْ فِيكْ حَجْرَة فُوقْ الأُخْرَى، عْلَى خَاطْرِكْ مَا عْرَفْتِشْ الوَقْتْ الِّي جَاء فِيهْ اللَّهْ بَاشْ يْنَجِّيكْ». ");
INSERT INTO aeu_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ومْبَعِّدْ دْخَلْ لِلْهَيْكِلْ، وبْدَا يْطَرِّدْ فِي النَّاسْ الِّي كَانُوا يْبِيعُوا ويِشْرِيوْ. ");
INSERT INTO aeu_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","وقَالِلْهُمْ: «مَكْتُوبْ: \"دَارِي مَجْعُولَة بَاشْ تْكُونْ دَارْ لِلصْلَاةْ، آمَا إِنْتُومَا رَدِّيتُوهَا مْغَارَة مْتَاعْ سُرَّاقْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","وكَانْ يْعَلِّمْ فِي الهَيْكِلْ كُلْ يُومْ. وكْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة وأَعْيَانْ الشَّعْبْ، كَانُوا يْحَاوْلُوا بَاشْ يُقْتْلُوهْ، ");
INSERT INTO aeu_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","آمَا مَا عَرْفُوشْ كِيفَاشْ. عْلَى خَاطِرْ الشَّعْبْ الكُلْ كَانُوا مِتْعَلْقِينْ بِيهْ ويْحِبُّوا يِسْمْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","وفِي نْهَارْ مِالنْهَارَاتْ، كَانْ يَسُوعْ يْعَلِّمْ ويْبَشِّرْ فِي الشَّعْبْ فِي الهَيْكِلْ، يَاخِي جَاوِهْ كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة والشْيُوخْ، ");
INSERT INTO aeu_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","وقَالُولُو: «قُولِلْنَا، بَانَا سُلْطَة تَعْمِلْ فِي الحَاجَاتْ هَاذِي؟ وشْكُونْ عْطَاهَالِكْ السُّلْطَة؟». ");
INSERT INTO aeu_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","جَاوِبْهُمْ: «وآنَا زَادَا بِشْ نِسْإِلْكُمْ سُؤَالْ وَاحِدْ، وجَاوْبُونِي عْلِيهْ: ");
INSERT INTO aeu_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","شْكُونْ عْطَى السُّلْطَة لْيُوحَنَّا بَاشْ يْعَمِّدْ؟ اللَّهْ وَلَّا النَّاسْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","يَاخِي تْشَاوْرُوا مَا بِينَاتْهُمْ وقَالُوا: «إِذَا قُلْنَا: \"مِنْ عَنْدْ اللَّهْ\" تَوْ يْقُولْ: \"مَالَا عْلَاشْ مَا أَمَّنْتُوشْ بِلِّي جَاء بِيهْ يُوحَنَّا؟\". ");
INSERT INTO aeu_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","وإِذَا قُلْنَا \"مِنْ عَنْدْ النَّاسْ\"، الشَّعْبْ الكُلْ بِشْ يُرْجُمْنَا، عْلَى خَاطِرْهُمْ مُقْتَنْعِينْ الِّي يُوحَنَّا نَبِيْ». ");
INSERT INTO aeu_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","وَلَّاوْ جَاوْبُوهْ: «مَا نَعْرْفُوشْ مْنِينْ جَاتْ». ");
INSERT INTO aeu_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","يَاخِي قَالِلْهُمْ يَسُوعْ: «حَتَّى آنَا مَا نْقُلْكُمْشْ بَانَا سُلْطَة نَعْمِلْ فِي الحَاجَاتْ هَاذِي!». ");
INSERT INTO aeu_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","وقَالْ المَثَلْ هَاذَا لِلشَّعْبْ: «فَمَّة وَاحِدْ زْرَعْ سَانْيَة عْنِبْ، وكْرَاهَا لْفَلَّاحَة وسَافِرْ مُدَّة طْوِيلَة. ");
INSERT INTO aeu_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","وكِي طَابْ العْنِبْ، بْعَثْ وَاحِدْ مِنْ خُدَّامُو لِلْفَلَّاحَة بَاشْ يَاخِذْلُو بَايُو مِالصَّابَة. يَاخِي ضَرْبُوهْ ورَجْعُوهْ بِيدِيهْ فَارْغَة. ");
INSERT INTO aeu_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","وَلَّى بْعَثِّلْهُمْ خْدِيمْ آخِرْ، يَاخِي ضَرْبُوهْ هُوَّ زَادَا وهَانُوهْ ورَجْعُوهْ بِيدِيهْ فَارْغَة. ");
INSERT INTO aeu_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","زَادْ عَاوِدْ بْعَثِّلْهُمْ خْدِيمْ ثَالِثْ، يَاخِي جَرْحُوهْ ورْمَاوَهْ لْبَرَّا مِالسَّانْيَة. ");
INSERT INTO aeu_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","يَاخِي مُولَى السَّانْيَة قَالْ: \"آشْ نَعْمِلْ؟ نَبْعْثِلْهُمْ وِلْدِي الِّي نْحِبُّو، بَالِكْشِي كِي يْشُوفُوهْ يْقَدْرُوهْ!\". ");
INSERT INTO aeu_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","آمَا دُوبْ مَا شَافُوهْ الفَلَّاحَة، قَالُوا لِبْعَضْهُمْ: \"هَاذَا هُوَّ الِّي بِشْ يُورِثْ، هَيَّا نُقْتْلُوهْ ونَاخْذُوا أَحْنَا الوَرْثَة!\". ");
INSERT INTO aeu_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ورْمَاوَهْ لْبَرَّة مِالسَّانْيَة وقَتْلُوهْ. وَقْتْهَا آشْ بِشْ يَعْمِلْ مْعَاهُمْ مُولَى السَّانْيَة؟ ");
INSERT INTO aeu_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","بِشْ يْجِي ويُقْتُلْ الفَلَّاحَة ويَعْطِي السَّانْيَة لْغِيرْهُمْ». وكِي سَمْعُوا النَّاسْ الكْلَامْ هَاذَا، قَالُوا: «لَا، أَبَدًا». ");
INSERT INTO aeu_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","خْزَرِّلْهُمْ يَسُوعْ وقَالْ: «مَالَا آشْ تُقْصُدْ الكْتُبْ المُقَدْسَة كِي قَالِتْ: \"الحَجْرَة الِّي رَفْضُوهَا البَنَّايَا، وَلَّاتْ حَجْرِةْ السَّاسْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","«الِّي يْطِيحْ عَالحَجْرَة هَاذِي يِتْكَسِّرْ، ولِّي اطِّيحْ عْلِيهْ الحَجْرَة هَاذِي يِدَّڨْدِڨْ». ");
INSERT INTO aeu_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","وحَبُّوا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة يْشِدُّوهْ وَقْتْهَا، آمَا خَافُوا مِالشَّعْبْ، عْلَى خَاطِرْهُمْ عَرْفُوا الِّي هُوَّ يُقْصُدْ فِيهُمْ بِالمَثَلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ووَلَّاوْ يْعِسُّوا عْلِيهْ، وبَعْثُوا وْرَاهْ نَاسْ عَامْلِينْ رْوَاحْهُمْ صَالْحِينْ بَاشْ يِتْجَسْسُوا عْلِيهْ، فَمَّاشِي مَا يْحَصْلُوهْ بْكِلْمَة يْقُولْهَا، ويْسَلْمُوهْ لِلْحَاكِمْ الرُّومَانِي والسُّلْطَة مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","يَاخِي سِأْلُوهْ: «يَا مُعَلِّمْ، أَحْنَا نَعْرْفُوا الِّي إِنْتِ صَادِقْ فِي كْلَامِكْ وفِي تَعْلِيمِكْ، ومَا تِتْعَامِلْشْ بِالوْجُوهْ، وتْعَلِّمْ طْرِيقْ اللَّهْ بِالحَقْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","يَاخِي حْلَالْ نَدْفْعُوا الضَّرَايِبْ لِلْقَيْصِرْ وَلَّا لَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","وعْرَفْ يَسُوعْ الِّي هُومَا يِتْخُوبْثُوا، وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«وَرِّيوْنِي بْيَاسَة فُضَّة! مْتَاعْ شْكُونْ التَّصْوِيرَة هَاذِي، وإِسْمْ شْكُونْ هَاذَا؟». جَاوْبُوهْ: «مْتَاعْ القَيْصِرْ!» ");
INSERT INTO aeu_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","قَالِلْهُمْ: «مَالَا أَعْطِيوْ الِّي يْخُصْ القَيْصِرْ لِلْقَيْصِرْ، ولِّي يْخُصْ اللَّهْ لِلَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ومَا نَجْمُوشْ يْحَصْلُوهْ بْحَتَّى كِلْمَة قُدَّامْ الشَّعْبْ، وتْعَجْبُوا مِالإِجَابَة مْتَاعُو وسِكْتُوا. ");
INSERT INTO aeu_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","وجَاوَهْ جْمَاعَة مِالصَّدُّوقِيِّينْ الِّي يْقُولُوا مَا فَمَّاشْ قْيَامَة بَعْدْ المُوتْ، وسِأْلُوهْ: ");
INSERT INTO aeu_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«يَا مُعَلِّمْ! مُوسَى كْتِبِّلْنَا: إِذَا وَاحِدْ مْعَرِّسْ مَاتْ، وخَلَّى مَرْتُو مِنْ بَعْدُو مِنْ غِيرْ مَا يْجِيبْ صْغَارْ، يِلْزِمْ خُوهْ يْعَرِّسْ بِيهَا ويْجِيبْ صْغَارْ ويْقَيِّدْهُمْ بْإِسْمْ خُوهْ الِّي مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","وكَانْ فَمَّة سَبْعَة خْوَاتْ، والأُوْلَانِي فِيهُمْ عَرِّسْ بِمْرَا ومَاتْ مِنْ غِيرْ مَا جَابْ صْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","يَاخِي عَرِّسْ بِيهَا الثَّانِي. ");
INSERT INTO aeu_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ومْبَعِّدْ عَرِّسْ بِيهَا الثَّالِثْ، وهَكَّا عَرْسُوا بِيهَا السَّبْعَة وَاحِدْ بَعْدْ وَاحِدْ، والكُلْهُمْ مَاتُوا مِنْ غِيرْ مَا جَابُوا صْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","وبَعْدْهُمْ مَاتِتْ المْرَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","مَالَا فِي نْهَارْ القْيَامَة، بِشْ تْكُونْ مَرْتْ شْكُونْ فِيهُمْ؟ هَايْ عَرْسِتْ بِيهُمْ السَّبْعَة!». ");
INSERT INTO aeu_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","جَاوِبْهُمْ يَسُوعْ: «النَّاسْ فِي الزْمَانْ هَاذَا يْعَرْسُوا ويْعَرْسُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","آمَا الِّي وَلَّاوْ يِسْتَاهْلُوا بَاشْ يْكُونْ عَنْدْهُمْ بَايْ فِي الزْمَانْ الجَايْ والقْيَامَة مِالمُوتْ، هَاذُوكُمْ لَا يْعَرْسُوا ولَا يْعَرْسُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ومَا يْنَجْمُوشْ يْمُوتُوا بَعْدْهَا، عْلَى خَاطِرْهُمْ يْكُونُوا كِيمَا المْلَايْكَة. وهُومَا أَوْلَادْ اللَّهْ عْلَى خَاطِرْهُمْ قَامُوا مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ومُوسَى بِيدُو فِي حْكَايِةْ الْعُلِّيقَة وَرَّى الِّي المُوتَى يْقُومُوا، وَقْتِلِّي قَالْ عَالرَّبْ إِنُّو هُوَّ إِلَاهْ إِبْرَاهِيمْ وإِلَاهْ إِسْحَاقْ وإِلَاهْ يَعْقُوبْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","واللَّهْ مُشْ إِلَاهْ المُوتَى، آمَا إِلَاهْ الحَيِّينْ، وهُومَا الكُلْ حَيِّينْ عَنْدُو». ");
INSERT INTO aeu_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","يَاخِي جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَة قَالُو: «يَا مُعَلِّمْ، يَعْطِيكْ الصَحَّة فِلِّي قُلْتُو». ");
INSERT INTO aeu_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","وبَعْدْهَا مَا تْجَرَّأْ حَتَّى حَدْ بَاشْ يِسْأْلُو عْلَى حَتَّى حَاجَة. ");
INSERT INTO aeu_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","وقَالِلْهُمْ: «كِيفَاشْ يْقُولُوا الِّي المَسِيحْ هُوَّ وِلْدْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","وَقْتِلِّي دَاوِدْ بِيدُو يْقُولْ فِي كْتَابْ المَزَامِيرْ: \"قَالْ اللَّهْ لْرَبِّي: أُقْعُدْ عْلَى يْمِينِي ");
INSERT INTO aeu_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","حَتَّى لِينْ نْحُطْ أَعْدَائِكْ تَحْتْ سَاقِيكْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","«إِذَا كَانْ دَاوِدْ يَعْيِّطْ لِلْمَسِيحْ رَبْ، مَالَا كِيفَاشْ يْكُونْ المَسِيحْ وِلْدُو؟». ");
INSERT INTO aeu_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ووَقْتِلِّي الشَّعْبْ الكُلْ كَانْ يِسْمَعْ فِيهْ، قَالْ يَسُوعْ لِتْلَامِذْتُو: ");
INSERT INTO aeu_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«رُدُّوا بَالْكُمْ مِنْ عُلَمَاءْ الشَّرِيعَة، الِّي يْحِبُّوا يْدُورُوا بِاللِّبْسَة الطْوِيلَة، ويْحِبُّوا النَّاسْ تْسَلِّمْ عْلِيهُمْ فِي الأَسْوَاقْ، ويُقْعْدُوا فِي الصَّفْ الأُوِّلْ فِي المْعَابِدْ وفِي أَحْسِنْ البْلَايِصْ فِي المْحَافِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","وهُومَا يِنْهْبُوا فِي فْلُوسْ الهَجَّالَاتْ، ويْطَوْلُوا فِي الصْلَاةْ بَاشْ النَّاسْ تْرَاهُمْ. هَاذُوكُمْ حْسَابْهُمْ بِشْ يْكُونْ أَكْثِرْ مِنْ غِيرْهُمْ!». ");
INSERT INTO aeu_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","خْزَرْ يَسُوعْ، وشَافْ الغْنِيِّينْ يْحُطُّوا فِي الفْلُوسْ فِي صَنْدُوقْ التَّبَرُّعَاتْ الِّي فِي الهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","وشَافْ زَادَا مْرَا هَجَّالَة وفْقِيرَة، حَطِّتْ زُوزْ فْرَنْكْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","يَاخِي قَالْ: «نْقُلْكُمْ الحَقْ، هَا المْرَا الهَجَّالَة الفْقِيرَة حَطِّتْ أَكْثِرْ مِنْهُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","عْلَى خَاطِرْهُمْ الكُلْ عْطَاوْ مِالفَاضِلْ عْلِيهُمْ، آمَا هِيَّ رَغْمِلِّي مِحْتَاجَة، حَطِّتْ الفْلُوسْ الِّي تْعِيشْ بِيهُمْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","وكَانْ فَمَّة جْمَاعَة يَحْكِيوْ عَالهَيْكِلْ، وكِيفَاشْ مْزَيِّنْ بِالحْجَرْ المِزْيَانْ، والتُّحَفْ الِّي عْطَاوْهَا النَّاسْ هْدِيَّة لِلَّهْ. يَاخِي يَسُوعْ قَالْ: ");
INSERT INTO aeu_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«بِشْ يْجِي وَقْتْ، كُلْ الِّي تْشُوفُوا فِيهْ بِشْ يِتْهَدْ، ولَا حَجْرَة مِنُّو بِشْ تِبْقَى فُوقْ أُخْتْهَا». ");
INSERT INTO aeu_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","سِأْلُوهْ: «يَا مُعَلِّمْ! وَقْتَاشْ بِشْ يْصِيرْ هَاذَا؟ وشْنِيَّة الأَمَارَة الِّي تْوَرِّي إِنُّو هَاذَا قْرِيبْ يْصِيرْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","جَاوِبْهُمْ: «رُدُّوا بَالْكُمْ لَا يْغُرُّوا بِيكُمْ! عْلَى خَاطِرْ بِشْ يْجِيوْ بَرْشَة بْإِسْمِي ويْقُولُوا: \"آنَا هُوَّ المَسِيحْ، والوَقْتْ قْرُبْ!\". مَا اتَّبْعُوهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","وكِي تِسْمْعُوا بِالحْرُوبَاتْ والثَّوْرَاتْ مَا تْخَافُوشْ، عْلَى خَاطِرْ هَاذَا لَازْمُو يْصِيرْ قْبَلْ، آمَا النْهَايَة مَا تْجِيشْ بَعْدْهَا بِالضَّبْطْ». ");
INSERT INTO aeu_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","مْبَعِّدْ قَالِلْهُمْ: «بِشْ تِتْقْلِبْ أُمَّة عْلَى أُمَّة، ومَمْلْكَة عْلَى مَمْلْكَة، ");
INSERT INTO aeu_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","وبِشْ تْصِيرْ زْلَازِلْ قْوِيَّة فِي بَرْشَة بْلَايِصْ، وبَرْشَة مَجَاعَاتْ وأَوْبْئَة، وتْصِيرْ حَاجَاتْ تْخَوِّفْ، وتُظْهُرْ أَمَايِرْ عْظِيمَة فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","«آمَا قْبَلْ هَاذَا الكُلْ، يْشِدُّوكُمْ ويِضْطَهْدُوكُمْ، ويْهِزُّوكُمْ لِلْمْعَابِدْ والحْبُوسَاتْ، ويْوَقْفُوكُمْ قُدَّامْ المُلُوكْ والحُكَّامْ عْلَى خَاطِرْ إِسْمِي. ");
INSERT INTO aeu_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","وهَاذِي بِشْ تْكُونِلْكُمْ فُرْصَة بَاشْ تِشْهْدُولِي. ");
INSERT INTO aeu_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ومَا تُقْعْدُوشْ تْخَمُّوا بِالمْسَبَقْ كِيفَاشْ بِشْ ادَّافْعُوا عْلَى رْوَاحْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","عْلَى خَاطِرْنِي آنَا بِشْ نَعْطِيكُمْ كْلَامْ وحِكْمَة، مَا يْنَجِّمْ حَتَّى حَدْ مِلِّي ضِدْكُمْ يْقَاوِمْهَا وَلَّا يْعَارِضْهَا. ");
INSERT INTO aeu_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","وحَتَّى وَالْدِيكُمْ وخْوَاتْكُمْ وأَقَارِبْكُمْ وأَصْحَابْكُمْ بِشْ يْسَلْمُوكُمْ لِلْحَاكِمْ، ويُقْتْلُوا نَاسْ مِنْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","وبِشْ يِكْرْهُوكُمْ النَّاسْ الكُلْ عْلَى خَاطِرْ إِسْمِي. ");
INSERT INTO aeu_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","آمَا حَتَّى شَعْرَة مِنْ رْيُوسْكُمْ مَا اطِّيحْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","شِدُّوا صْحِيحْ، تِنْجَاوْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","«ووَقْتِلِّي تْشُوفُوا أُورْشَلِيمْ مْحَاصْرَة بِالجْيُوشْ، أَعْرْفُوهَا الِّي هِيَّ بِشْ تِتْخْرِبْ عْلَى قْرِيبْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","وَقْتْهَا يِلْزِمْ الِّي فِي مَنْطَقْةْ اليَهُودِيَّة يُهْرْبُوا لِلجْبَالْ، ولِّي فِي أُورْشَلِيمْ يَرْحْلُوا مِنْهَا ولِّي فِي الأَرْيَافْ مَا يُدْخْلُولْهَاشْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","عْلَى خَاطِرْ الوَقْتْ هَاذَاكَا وَقْتْ إِنْتِقَامْ، يْتِمْ فِيهْ كُلْ الِّي تِكْتِبْ فِي الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","يَا وِيلْهُمْ النْسَاء الحْبَالَى ولِّي يْرَضْعُوا فِي الأَيَّامَاتْ هَاذُوكُمْ! عْلَى خَاطِرْ ضِيقَة عْظِيمَة بِشْ تْصِيرْ عَالأَرْضْ، وغَضَبْ اللَّهْ يَهْبِطْ عَالشَّعْبْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ويْمُوتُوا مَقْتُولِينْ بِالسْيُوفَا ويِتْسْبَاوْ عَنْدْ شْعُوبْ العَالِمْ الكُلْ، وتُقْعُدْ أُورْشَلِيمْ يْعَفْسُوا فِيهَا الشُّعُوبْ الأُخْرِينْ حَتَّى لِينْ يِكْمِلْ وَقْتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","«وبِشْ تْصِيرْ أَمَايِرْ فِي الشَّمْسْ والڨَمْرَة والنْجُومْ، وفِي الأَرْضْ، الشُّعُوبْ يْكُونُوا فِي ضِيقْ وحِيرَة، عْلَى خَاطِرْ البْحَرْ يْكُونْ هَايِجْ ومُوجُو عَالِي. ");
INSERT INTO aeu_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","والنَّاسْ بِشْ يْمُوتُوا مِالرُّعْبْ، ومِنْ خُوفْهُمْ مِلِّي بِشْ يْصِيرْ لِلْعَالِمْ، عْلَى خَاطِرْ السْمَاء بِشْ تِتْزَعْزَعْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","وَقْتْهَا يْشُوفُوا إِبْنْ الإِنْسَانْ جَايْ فِي السْحَابْ بْقُوَّة ومَجْدْ عْظِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","وإِذَا بْدَاتْ الأُمُورْ هَاذِي تْصِيرْ، آقْفُوا وهِزُّوا رْيُوسْكُمْ، عْلَى خَاطِرْ بِشْ تِنْجَاوْ عْلَى قْرِيبْ». ");
INSERT INTO aeu_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","وعْطَاهُمْ المَثَلْ هَاذَا: «أُخْزْرُوا لِلْكَرْمَة وبْقِيِّةْ الشْجَرْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","كِي تْشُوفُوهُمْ بْدَاوْ يْطَلّْعُوا فِي الأَوْرَاقْ، تَعْرْفُوا وَحَّدْكُمْ الِّي الصِّيفْ قْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","وإِنْتُومَا زَادَا، كِي تْشُوفُوا الحَاجَاتْ هَاذِي قَاعْدَة تْصِيرْ، أَعْرْفُوا الِّي مَمْلَكْةْ اللَّهْ قُرْبِتْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","نْقُلْكُمْ الحَقْ، الحَاجَاتْ هَاذِي الكُلْ بِشْ تْصِيرْ قْبَلْ مَا يْمُوتْ الجِيلْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","السْمَاء والأَرْضْ يِفْنَاوْ، آمَا كْلَامِي عُمْرُو مَا يِفْنَى. ");
INSERT INTO aeu_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«رُدُّوا بَالْكُمْ تُقْعْدُوا لَاهِينْ بِالسِّكْرَة والشِّيخَاتْ وَلَّا بِهْمُومْ الدِّنْيَا، لَا يْجِيكُمْ النْهَارْ هَاذَاكَا عْلَى غَفْلَة، ");
INSERT INTO aeu_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","عْلَى خَاطْرُو بِشْ يِتْسَكِّرْ كِي المِنْدَافْ عْلَى سُكَّانْ الأَرْضْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","مَالَا خَلِّيكُمْ فَايْقِينْ وصَلِّيوْ فِي كُلْ وَقْتْ، بَاشْ تْنَجْمُوا تِمْنْعُوا مِنْ كُلْ الِّي بِشْ يْصِيرْ، وتَاقْفُوا قُدَّامْ إِبْنْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","وكَانْ يَسُوعْ يْعَلِّمْ فِي الهَيْكِلْ فِي النْهَارْ، وفِي اللِّيلْ يِمْشِي يْبَاتْ فِي الجْبَلْ الِّي يِتْسَمَّى جْبَلْ الزِّيتُونْ. ");
INSERT INTO aeu_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","وكَانْ الشَّعْبْ الكُلْ يْجِيهْ عَالصْبَاحْ بِكْرِي لِلْهَيْكِلْ بَاشْ يِسْمْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","وقْرُبْ عِيدْ الفْطِيرْ المَعْرُوفْ بْعِيدْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","وكَانُوا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة يْلَوْجُوا عْلَى طَرِيقَة يُقْتْلُوا بِيهَا يَسُوعْ، عْلَى خَاطِرْ كَانُوا خَايْفِينْ مِالشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ودْخَلْ الشِّيطَانْ فِي يَهُوذَا الِّي يْسَمِّيوَهْ الإِسْخَرْيُوطِي، وهُوَّ وَاحِدْ مِالتْلَامْذَة الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","وَلَّى مْشَى لِكْبَارْ الكَهَنَة وقَادِةْ حَرَسْ الهَيْكِلْ وتْفَاهِمْ مْعَاهُمْ كِيفَاشْ بِشْ يْسَلَّمْهُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","يَاخِي فِرْحُوا ووِعْدُوهْ بِشْ يَعْطِيوَهْ فْلُوسْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","وهُوَّ رْضَى، وقْعَدْ يِسْتَنَّى فِي فُرْصَة بَاشْ يْسَلَّمْهُولْهُمْ بِالسِّرْقَة عَالشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","وجَاء نْهَارْ عِيدْ الفْطِيرْ الِّي كَانْ لَازِمْ يِتْذْبَحْ فِيهْ عَلُّوشْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","يَاخِي بْعَثْ يَسُوعْ بُطْرُسْ ويُوحَنَّا وقَالِلْهُمْ: «إِمْشِيوْ حَضْرُولْنَا عْشَاء الفِصْحْ، بَاشْ نَاكْلُوهْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","سِأْلُوهْ: «وِينْ تْحِبْنَا نْحَضْرُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","قَالِلْهُمْ: «دُوبْ مَا تُدْخْلُوا لِلْمْدِينَة، يُعْرِضْكُمْ وَاحِدْ هَازِزْ قُلَّة مَاء. تَبْعُوهْ لِلدَّارْ الِّي بِشْ يُدْخْلِلْهَا، ");
INSERT INTO aeu_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","وقُولُوا لْمُولَى الدَّارْ هَاذِيكَا: \"قَالِّكْ المُعَلِّمْ: وِينِي البِيتْ الِّي بِشْ نَاكِلْ فِيهَا عْشَاء الفِصْحْ مْعَ تْلَامِذْتِي؟\". ");
INSERT INTO aeu_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","وهُوَّ تَوْ يْوَرِّيكُمْ بَيْتْ كْبِيرَة فِي الطَّاقْ الفُوقَانِي، وَاسْعَة ومَفْرُوشَة، حَضْرُوا العْشَاء غَادِي». ");
INSERT INTO aeu_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","مْشَاوْ، ولْقَاوْ كُلْ شَيْ كِيمَا قَالِلْهُمْ، وحَضْرُوا عْشَاء الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","وكِي جَاء الوَقْتْ قْعَدْ هُوَّ والرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","وقَالِلْهُمْ: «قَدَّاشْ شْتْهِيتْ نَاكِلْ عْشَاء الفِصْحْ مْعَاكُمْ قْبَلْ مَا نِتْعَذَّبْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ونْقُولِلْكُمْ: مَا عَادِشْ بِشْ نَاكِلْ مِنُّو مَرَّة أُخْرَى، حَتَّى يِتْحَقَّقْ المَقْصُودْ بِيهْ فِي مَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","وخْذَا كَاسْ وشْكَرْ وقَالْ: «خُوذُوا الكَاسْ هَاذَا وإِقْسْمُوا العَصِيرْ بِينَاتْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","نْقُولِلْكُمْ: مَا عَادِشْ بِشْ نُشْرُبْ مَرَّة أُخْرَى مِنْ عَصِيرْ العْنِبْ حَتَّى لِينْ تْجِي مَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","وخْذَا الخُبْزْ وشْكَرْ وقْسِمْ، وعْطَاهُمْ وقَالْ: «هَاذَا بَدْنِي الِّي يِتْعْطَى عْلَى خَاطِرْكُمْ. أَعْمْلُوا هَاذَا بَاشْ تِتْذَكْرُونِي». ");
INSERT INTO aeu_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","وكِيفْ كِيفْ خْذَا الكَاسْ بَعْدْ العْشَاء وقَالْ: «هَاذَا الكَاسْ هُوَّ العَهْدْ الجْدِيدْ الِّي يَعْمْلُو اللَّهْ بْدَمِّي الِّي بِشْ يْسِيلْ عْلَى خَاطِرْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","آمَا رَاهُو الِّي بِشْ يْخُونِّي قَاعِدْ مْعَايَا عَالطَّاوْلَة. ");
INSERT INTO aeu_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","وإِبْنْ الإِنْسَانْ بِشْ يْمُوتْ كِيمَا اللَّهْ قَرَّرْ، آمَا يَا وِيلُو الِّي بِشْ يْخُونُو!» ");
INSERT INTO aeu_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","وبْدَاوْ التْلَامْذَة يِسْأْلُوا فِي بْعَضْهُمْ: «شْكُونْ فِينَا الِّي بِشْ يَعْمِلْ هَا الْعَمْلَة؟». ");
INSERT INTO aeu_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","وبَعْدْ بْوَقْتْ، صَارْ بِينَاتْهُمْ نِقَاشْ عْلَى شْكُونْ فِيهُمْ أَعْظِمْ مِالآخِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","يَاخِي قَالِلْهُمْ يَسُوعْ: «المُلُوكْ يِتْحَكْمُوا فِي شُعُوبْهُمْ، وأَصْحَابْ السُّلْطَة يْقُولُوا عْلِيهُمْ مُحْسْنِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","آمَا إِنْتُومَا مَا تْكُونُوشْ كِيفْهُمْ، بِالعَكْسْ، أَعْظَمْ وَاحِدْ فِيكُمْ يِلْزْمُو يْكُونْ كِيمَا أَصْغِرْ وَاحِدْ، والقَايِدْ يْكُونْ كِيمَا الخْدِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","شْكُونُو الأَعْظَمْ: الِّي قَاعِدْ يَاكِلْ عَالطَّاوْلَة وَلَّا الِّي يِخْدِمْ فِيهْ؟ يَاخِي مُشْ الِّي قَاعِدْ عَالطَّاوْلَة؟ آمَا آنَا بِينَاتْكُمْ كِيمَا الِّي يِخْدِمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","«إِنْتُومَا هُومَا الِّي وْقِفْتُوا مْعَايَا فِي وَقْتْ مِحْنْتِي، ");
INSERT INTO aeu_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","هَاذَاكَا عْلَاشْ بِشْ نَعْطِيكُمْ السُّلْطَة بَاشْ تِمْلْكُوا كِيمَا عْطَانِي بَابَا السُّلْطَة بَاشْ نِمْلِكْ، ");
INSERT INTO aeu_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","بَاشْ تَاكْلُوا وتُشْرْبُوا عْلَى طَاوِلْتِي فِي مَمْلَكْتِي، وتُقْعْدُوا عْلَى كْرَاسِي المُلْكْ وتُحْكْمُوا عْلَى عْرُوشَاتْ بَنِي إِسْرَائِيلْ الأَثْنَاشْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","وقَالْ الرَّبْ يَسُوعْ: «سِمْعَانْ! سِمْعَانْ! هَاوْ الشِّيطَانْ طْلَبْ إِنُّو يْغَرْبِلْكُمْ كِيمَا يِتْغَرْبِلْ القَمْحْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","آمَا آنَا صَلِّيتْ عْلَى خَاطْرِكْ، بَاشْ إِيمَانِكْ مَا يِفْنَاشْ. وإِنْتِ وَقْتِلِّي تِرْجَعْلِي قَوِّي خْوَاتِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","يَاخِي قَالُّو سِمْعَانْ: «يَا سِيدِي، آنَا مُسْتْعَدْ نِمْشِي مْعَاكْ لِلْحَبْسْ ولِلْمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","قَالُّو يَسُوعْ: «آنَا نْقُلِّكْ يَا بُطْرُسْ، اليُومْ، قْبَلْ مَا يْصِيحْ السَّرْدُوكْ تْكُونْ إِنْتْ نْكَرْتْ إِنِّكْ تَعْرَفْنِي ثْلَاثَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ومْبَعِّدْ قَالِلْهُمْ: «كِي بْعَثْتْكُمْ مِنْ غِيرْ فْلُوسْ ولَا صُرَّة ولَا صَنْدَالْ، اسْتْحَقِّيتُوشِي حَاجَة؟». قَالُوا: «لَا». ");
INSERT INTO aeu_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","يَاخِي قَالِلْهُمْ: «آمَا تَوَّا، الِّي عَنْدُو فْلُوسْ يْهِزْهُمْ، ولِّي عَنْدُو صُرَّة كِيفْ كِيفْ. ولِّي مَا عَنْدُوشْ سِيفْ، يْبِيعْ حْوَايْجُو ويِشْرِي سِيفْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ونْقُولِلْكُمْ: الِّي تِكْتِبْ، \"وحِسْبُوهْ مْعَ المُجْرْمِينْ\" لَازْمُو يِتْحَقَّقْ فِيَّا آنَا، عْلَى خَاطِرْ الِّي يْخُصْنِي لَازْمُو يْتِمْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","قَالُوا التْلَامْذَة: «يَا سِيدْنَا، هَاوْ عَنْدْنَا زُوزْ سْيُوفَا». قَالِلْهُمْ يَسُوعْ: «يِزِّيوْ!». ");
INSERT INTO aeu_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ومْبَعِّدْ خْرَجْ ومْشَى كِي عَادْتُو لِجْبَلْ الزِّيتُونْ، وتْلَامِذْتُو تَبْعُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","وَقْتِلِّي وْصِلْ لِلْبْلَاصَة قَالِلْهُمْ: «صَلِّيوْ بَاشْ مَا تُدْخْلُوشْ فِي تَجْرْبَة». ");
INSERT INTO aeu_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","وبْعِدْ عْلِيهُمْ شْوَيَّة، ورْكَعْ وبْدَا يْصَلِّي: ");
INSERT INTO aeu_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","وقَالْ: «يَا بَابَا، كَانْ تْحِبْ، بَعِّدْ عْلِيَّا هَا الكَاسْ. آمَا خَلِّي يْصِيرْ الِّي تْحِبْ عْلِيهْ إِنْتِ، مُشْ الِّي نْحِبْ عْلِيهْ آنَا». ");
INSERT INTO aeu_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","وظْهُرْلُو مَلَاكْ مِالسْمَاء يْقَوِّي فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","وكَانْ حَاسِسْ بْضِيقْ كْبِيرْ، يَاخِي بْدَى يْصَلِّي بِحْرَارَة، والعْرَقْ مْتَاعُو وَلَّى كِي قَطْرَاتْ الدَّمْ هَابْطَة عَالقَاعَة. ");
INSERT INTO aeu_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","مْبَعِّدْ قَامْ مِالصْلَاةْ ورْجَعْ لِتْلَامِذْتُو، يَلْقَاهُمْ رَاقْدِينْ مِنْ كُثْرِتْ مَا كَانُوا حْزَانَى. ");
INSERT INTO aeu_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","وقَالِلْهُمْ: «شْبِيكُمْ رَاقْدِينْ؟ قُومُوا صَلِّيوْ بَاشْ مَا تُدْخْلُوشْ فِي مِحْنَة». ");
INSERT INTO aeu_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","وهُوَّ مَزَّالْ يِتْكَلِّمْ، جَاوْ جْمَاعَة كَانْ جَايِبْهُمْ يَهُوذَا، الِّي هُوَّ وَاحِدْ مِالأَثْنَاشْ. وقْرُبْ مِنْ يَسُوعْ بَاشْ يْبُوسُو. ");
INSERT INTO aeu_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","قَالُّو يَسُوعْ: «يَا يَهُوذَا، إِبُّوسَة تْخُونْ إِبْنْ الإِنْسَانْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","وكِي فِهْمُوا تْلَامِذْتُو الِّي بِشْ يْصِيرْ قَالُوا: «يَا سِيدْنَا، نَضْرْبُوا بِالسْيُوفَا؟». ");
INSERT INTO aeu_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ووَاحِدْ مِنْهُمْ ضْرَبْ خْدِيمْ الكَاهِنْ الكْبِيرْ وقَصْلُو وِذْنُو اليْمِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","آمَا يَسُوعْ قَالْ: «يِزِّي، حَدْكُمْ هُونِي!» ومَسْ وْذِنْ الرَّاجِلْ وشْفَاهْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","وقَالْ يَسُوعْ لِكْبَارْ الكَهَنَة وقَادِةْ حَرَسْ الهَيْكِلْ والشْيُوخْ الِّي جَاوُوهْ: «يَاخِي آنَا سَارَقْ بَاشْ تْجِيوْنِي بِالسْيُوفَا والعْصِي؟ ");
INSERT INTO aeu_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","كُنْتْ كُلْ يُومْ مْعَاكُمْ فِي الهَيْكِلْ، وحَدْ مَا مَدْ يِدُّو عْلِيَّا. آمَا تَوَّا هَاذَا وَقْتْكُمْ، تَوَّا قُوَّاتْ الشَّرْ تْسَيْطِرْ فِي الظْلَامْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","يَاخِي شَدُّوهْ وكَرْكْرُوهْ وهَزُّوهْ لْدَارْ كْبِيرْ الكَهَنَة. وبُطْرُسْ كَانْ يْتَبَّعْ فِيهْ مِنْ بْعِيدْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","وشَعْلُوا نَارْ فِي الوِسْطِيَّة مْتَاعْ الدَّارْ وقَعْدُوا دَايْرِينْ بِيهَا، وقْعَدْ بُطْرُسْ مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","وفَمَّة خْدِيمَة شَافِتُّو قَاعِدْ بَحْذَا النَّارْ، ثَبْتِتْ فِيهْ وقَالِتْ: «الرَّاجِلْ هَاذَا زَادَا كَانْ مْعَاهْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","آمَا هُوَّ نْكَرْ وقَالْ: «يَا مْرَا، آنَا مَا نَعْرْفُوشْ!». ");
INSERT INTO aeu_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","وبَعْدْ شْوَيَّة شَافُو وَاحِدْ آخِرْ وقَالْ: «إِنْتِ زَادَا وَاحِدْ مِنْهُمْ». آمَا بُطْرُسْ قَالْ: «لَا يَا رَاجِلْ، مَانِيشْ آنَا!». ");
INSERT INTO aeu_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","وبَعْدْمَا تْعَدَّاتْ حْكَايِةْ سَاعَة، فَمَّة وَاحِدْ آخِرْ شَدْ صْحِيحْ وقَالْ: «بِالحَقْ هَاذَا كَانْ مْعَاهْ زَادَا، عْلَى خَاطْرُو مِالجَلِيلْ!». ");
INSERT INTO aeu_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","وبُطْرُسْ قَالْ: «يَا رَاجِلْ، فَاشْ قَاعِدْ تَحْكِي!». وهُوَّ مَزَّالْ يِتْكَلِّمْ، السَّرْدُوكْ صَاحْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","وتْلَفِّتْ الرَّبْ وخْزَرْ لْبُطْرُسْ، يَاخِي تْذَكِّرْ بُطْرُسْ كْلَامْ الرَّبْ كِي قَالُّو: «قْبَلْ مَا يْصِيحْ السَّرْدُوكْ، إِنْتِ بِشْ تُنْكُرْنِي ثْلَاثَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","وخْرَجْ بُطْرُسْ لْبَرَّا وبْدَا يِبْكِي بِالشَّهْقَة. ");
INSERT INTO aeu_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","والرْجَالْ الِّي كَانُوا يْعِسُّوا عْلَى يَسُوعْ، بْدَاوْ يِتْمَسْخْرُوا عْلِيهْ ويَضْرْبُوا فِيهْ، ");
INSERT INTO aeu_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ويْغَطِّيوْلُو فِي وِجْهُو ويِسْأْلُوا فِيهْ: «تْرَاهْ، تْنَبَّأْ شْكُونْ ضَرْبِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","وقَعْدُوا يْسِبُّوا فِيهْ إِبَّرْشَة كْلَامْ خَايِبْ. ");
INSERT INTO aeu_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","وكِي طْلَعْ النْهَارْ، تْلَمُّوا شْيُوخْ الشَّعْبْ، الِّي هُومَا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة، وجَابُوا يَسُوعْ قُدَّامْ مَجْلِسْهُمْ الأَعْلَى. ");
INSERT INTO aeu_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","وقَالُولُو: «إِذَا كَانِكْ إِنْتِ المَسِيحْ قُولِلْنَا!». جَاوِبْهُمْ: «كَانْ نْقُلْكُمْ مَاكُمْشْ بِشْ تْصَدْقُونِي، ");
INSERT INTO aeu_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","وكَانْ نِسْإِلْكُمْ مَاكُمْشْ بِشْ تْجَاوْبُونِي. ");
INSERT INTO aeu_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","آمَا مِنْ تَوَّا إِبْنْ الإِنْسَانْ بِشْ يُقْعُدْ عْلَى يْمِينْ اللَّهْ القَادِرْ عْلَى كُلْ شَيْ». ");
INSERT INTO aeu_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","يَاخِي الكُلْهُمْ قَالُوا: «مَالَا إِنْتِ إِبْنْ اللَّهْ؟». قَالِلْهُمْ: «إِنْتُومَا بِيدْكُمْ تْقُولُوا الِّي آنَا هُوَّ!». ");
INSERT INTO aeu_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","يَاخِي قَالُوا: «عْلَاشْ مَزِّلْنَا نِسْتْحَقُّوا لِشْهُودْ؟ هَانَا سْمَعْنَاهَا مِنْ فُمُّو هُوَّ». ");
INSERT INTO aeu_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","وقَامُوا الكُلْ، وهَزُّوهْ لْبِيلَاطُسْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","وبْدَاوْ يِتْهْمُوا فِيهْ ويْقُولُوا: «شَدِّينَا الرَّاجِلْ هَاذَا يَعْمِلْ فِي فِتْنَة فِي وِسْطْ الشَّعْبْ، ويَمْنَعْ فِي النَّاسْ مِنْ دَفْعَانْ الضَّرَايِبْ لِلْقَيْصِرْ، ويْقُولْ الِّي هُوَّ المَسِيحْ المَلِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","يَاخِي بِيلَاطُسْ سِأْلُو: «إِنْتِ مَلِكْ اليْهُودْ؟». جَاوْبُو يَسُوعْ: «إِنْتِ بِيدِكْ قُلْتْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","وَلَّى بِيلَاطُسْ قَالْ لِكْبَارْ الكَهَنَة والنَّاسْ المَلْمُومِينْ: «مَا لْقِيتْ حَتَّى سْبَبْ يْخَلِّينِي نُحْكُمْ عَالرَّاجِلْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","آمَا هُومَا شَدُّوا صْحِيحْ وقَالُوا: «رَاهُو يْهَيِّجْ فِي الشَّعْبْ فِي مَنْطَقْةْ اليَهُودِيَّة الكُلْ بِلِّي قَاعِدْ يْعَلِّمْ فِيهْ، بْدَاهَا مِالجَلِيلْ حَتَّى لِينْ وْصِلْ لَهْنَا». ");
INSERT INTO aeu_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","وكِي سْمَعْ بِيلَاطُسْ كِلْمِةْ الجَلِيلْ، سْإِلْ: «يَاخِي الرَّاجِلْ هَاذَا مِالجَلِيلْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","وكِي عْرَفْ الِّي يَسُوعْ تَابَعْ لْوِلَايِةْ هِيرُودُسْ، بْعَثْهُولُو، وهِيرُودُسْ بِيدُو كَانْ فِي أُورْشَلِيمْ فِي الوَقْتْ هَاذَاكَا. ");
INSERT INTO aeu_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","وكِي هِيرُودُسْ شَافْ يَسُوعْ فْرَحْ بَرْشَة، عْلَى خَاطْرُو كَانْ يَاسِرْ يِسْمَعْ عْلِيهْ، وعَنْدُو مُدَّة طْوِيلَة مَذَابِيهْ يْشُوفُو، وكَانْ يِتْمَنَّى يْرَاهْ يَعْمِلْ فِي مُعْجْزَة قُدَّامُو. ");
INSERT INTO aeu_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","وسِأْلُو بَرْشَة أَسْئْلَة، آمَا هُوَّ مَا جَاوْبُوشْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ووِقْفُوا كْبَارْ الكَهَنَة وعُلَمَاءْ الشَّرِيعَة وهَبْطُوا عْلِيهْ بِالتُّهَمْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","يَاخِي حَتَّى هِيرُودُسْ والعَسْكَرْ مْتَاعُو حَقْرُوهْ، وتْمَسْخْرُوا عْلِيهْ، ولَبّْسُو جِبَّة مِذْخْمَة، ورَجّْعُو لْبِيلَاطُسْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","وفِي النْهَارْ هَاذَاكَا هِيرُودُسْ وبِيلَاطُسْ تْصَالْحُوا، بَعْدْمَا كَانُوا قْبَلْ مِتْعَارْكِينْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","وعَيِّطْ بِيلَاطُسْ لِكْبَارْ الكَهَنَة والقَادَة والشَّعْبْ ");
INSERT INTO aeu_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","وقَالِلْهُمْ: «جِبْتُولِي الرَّاجِلْ هَاذَا وقُلْتُولِي الِّي هُوَّ يَعْمِلْ فِي فِتْنَة وِسْطْ الشَّعْبْ، وآنَا بَعْدْمَا ثَبَّتْ فِي كُلْ شَيْ قُدَّامْكُمْ، مَا لْقِيتُو عَامِلْ شَيْ مِلِّي تْهِمْتُوهْ بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ولَا هِيرُودُسْ زَادَا شَدْ عْلِيهْ حَاجَة، عْلَى خَاطْرُو رَجَّعْهُولْنَا. مَالَا هُوَّ مَا عْمَلْ شَيْ يِسْتَاهِلْ عْلِيهْ المُوتْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","وهَانِي بِشْ نِجِلْدُو ونْسَيْبُو». ");
INSERT INTO aeu_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","وفِي كُلْ عِيدْ، كَانْ لَازِمْ عْلَى بِيلَاطُسْ يْسَيْبِلْهُمْ وَاحِدْ مِالمْرَابِيطْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","آمَا الحَاضْرِينْ الكُلْ صَاحُوا فَرْدْ وَقْتْ: «أُقْتُلْ هَاذَا! وسَيْبِلْنَا بَارَابَاسْ!». ");
INSERT INTO aeu_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","وبَارَابَاسْ هَاذَا، كَانْ فِي الحَبْسْ بِسْبَبْ فِتْنَة صَارِتْ فِي المْدِينَة وبِسْبَبْ جْرِيمِةْ قْتَلْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","وبِيلَاطُسْ كَانْ يْحِبْ يْسَيِّبْ يَسُوعْ، يَاخِي حْكَى مْعَاهُمْ مَرَّة أُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","آمَا هُومَا زَادُوا صَاحُوا: «أُصْلْبُو! أُصْلْبُو!». ");
INSERT INTO aeu_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","وعَاوِدْ قَالِلْهُمْ مَرَّة ثَالْثَة: «شْنُوَّة الشَّرْ الِّي عَمْلُو؟ مَا لْقِيتْ حَتَّى سْبَبْ يِسْتَاهِلْ عْلِيهْ المُوتْ. بِشْ نِجْلْدُو ونْسَيْبُو». ");
INSERT INTO aeu_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","آمَا هُومَا شَدُّوا صْحِيحْ وبْدَاوْ يْصِيحُوا بْأَعْلَى صُوتْهُمْ بَاشْ يُصْلْبُو. وصْيَاحُهُمْ هُوَّ الِّي غْلِبْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","وحْكُمْ بِيلَاطُسْ بِلِّي حَبُّوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","وسَيْبِلْهُمْ الرَّاجِلْ الِّي اخْتَارُوهْ ولِّي كَانْ فِي الحَبْسْ بِسْبَبْ جْرِيمِةْ القَتْلْ والفِتْنَة. وحْكُمْ عْلَى يَسُوعْ كِيفْ مَا حَبُّوا هُومَا. ");
INSERT INTO aeu_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","وهُومَا هَازِّينُو بَاشْ يُصْلْبُوهْ، شَدُّوا رَاجِلْ مِنْ مَنْطَقْةْ قِيرِينَا إِسْمُو سِمْعَانْ كَانْ رَاجَعْ مِالرِّيفْ، وحَطُّوا عْلِيهْ الصَّلِيبْ بَاشْ يْهِزُّو ويِمْشِي وْرَاء يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","وتَبْعُوهْ بَرْشَة نَاسْ مِالشَّعْبْ، مِنْهُمْ بَرْشَة نْسَاء كَانُوا يِنْدْبُوا ويْنَوْحُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","وتْلَفْتِلْهُمْ يَسُوعْ وقَالْ: «يَا بْنَاتْ أُورْشَلِيمْ مَا تِبْكِيوِشْ عْلِيَّا، آمَا إِبْكِيوْ عْلَى رْوَاحْكُمْ وعْلَى وْلَادْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","عْلَى خَاطِرْ بِشْ يْجِي وَقْتْ يْقُولُوا فِيهْ النَّاسْ: \"صَحَّة لِلنْسَاء الِّي مَا يَضْنَاوِشْ، ولِّي لَا حِبْلُوا ولَا رَضْعُوا!\". ");
INSERT INTO aeu_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ووَقْتْهَا يْقُولُوا لِلجْبَالْ: \"طِيحْ عْلِينَا\"، ولِلْهْضُبْ: \"غَطِّينَا!\". ");
INSERT INTO aeu_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","وإِذَا كَانْ العُودْ الأَخْضِرْ عَمْلُوا فِيهْ هَكَّا، مَالَا اليَابِسْ آشْ بِشْ يِجْرَالُو؟». ");
INSERT INTO aeu_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","وزَادُوا هَزُّوا زُوزْ مُجْرْمِينْ بَاشْ يُقْتْلُوهُمْ مْعَ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","وكِي وِصْلُوا لِلْبُقْعَة الِّي تِتْسَمَّى الجُمْجْمَة، صَلْبُوهْ غَادِي مْعَ الزُّوزْ المْجَرْمَة، وَاحِدْ عْلَى يْمِينُو والآخِرْ عْلَى يْسَارُو. ");
INSERT INTO aeu_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","وقَالْ يَسُوعْ: «يَا بَابَا، إِغْفْرِلْهُمْ، عْلَى خَاطِرْهُمْ مُشْ عَارْفِينْ فَاشْ قَاعْدِينْ يَعْمْلُوا». وقَسْمُوا العْسَاكِرْ حْوَايْجُو بِينَاتْهُمْ بِالقُرْعَة. ");
INSERT INTO aeu_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","والنَّاسْ كَانُوا وَاقْفِينْ يِتْفَرْجُوا، والقَادَة مْتَاعْهُمْ يِتْمَسْخْرُوا ويْقُولُوا: «مَنَّعْ غِيرُو، تْرَاهْ خَلِّيهْ يْمَنَّعْ رُوحُو إِذَا كَانْ هُوَّ المَسِيحْ الِّي اخْتَارُو اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","وكَانُوا العْسَاكِرْ زَادَا يِتْمَسْخْرُوا عْلِيهْ، ويُقْرْبُولُو ويْمِدُّولُو الخَلْ ");
INSERT INTO aeu_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ويْقُولُولُو: «إِذَا كُنْتْ إِنْتِ مَلِكْ اليْهُودْ، نَجِّي رُوحِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","وكَانِتْ مْعَلْقَة فُوقْ رَاسُو بْلَاكَة مَكْتُوبْ عْلِيهَا: «هَاذَا هُوَّ مَلِكْ اليْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","وكَانْ وَاحِدْ مِالمُجْرْمِينْ المَصْلُوبِينْ مْعَاهْ يْسِبْ فِيهْ ويْقُولْ: «مُشْ إِنْتِ المَسِيحْ؟ مَالَا مَنَّعْ رُوحِكْ ومَنَّعْنَا!». ");
INSERT INTO aeu_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","آمَا المُجْرِمْ الآخِرْ لَامْ عْلِيهْ وقَالُّو: «يَاخِي مَا تْخَافِشْ اللَّهْ؟ رَاوْ مَحْكُومْ عْلِيكْ بِالمُوتْ كِيفُو. ");
INSERT INTO aeu_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","أَحْنَا تِحْكَمْ عْلِينَا بِالعَدْلْ ونِسْتَاهْلُوا العِقَابْ عَلِّي عْمَلْنَاهْ بِيدِينَا، آمَا الرَّاجِلْ هَاذَا مَا عْمَلْ حَتَّى حَاجَة غَالْطَة». ");
INSERT INTO aeu_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ومْبَعِّدْ قَالْ: «يَا يَسُوعْ، إِتْذَكِّرْنِي كِي تْجِي فِي مَمْلَكْتِكْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","قَالُّو يَسُوعْ: «نْقُلِّكْ الحَقْ: اليُومْ تْكُونْ مْعَايَا فِي الفِرْدَوْسْ!». ");
INSERT INTO aeu_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","وقْرِيبْ نُصْ النْهَارْ، ظْلَامِتْ الدِّنْيَا الكُلْ حَتَّى لْمَاضِي ثْلَاثَة مْتَاعْ العْشِيَّة. ");
INSERT INTO aeu_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","وغَابِتْ الشَّمْسْ، وتْشَقْ حْجَابْ الهَيْكِلْ مِالوُسْطْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","وصَاحْ يَسُوعْ بْصُوتْ عَالِي: «يَا بَابَا، نْسَلِّمْ رُوحِي بِينْ يْدِيكْ». وكِي كَمِّلْ كْلَامُو، مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","وكِي الضَّابِطْ الرُّومَانِي شَافْ الِّي صَارْ، مَجِّدْ اللَّهْ وقَالْ: «بِالحَقْ الإِنْسَانْ هَاذَا كَانْ رَاجِلْ صَالَحْ». ");
INSERT INTO aeu_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","والنَّاسْ الِّي تْلَمُّوا غَادِي بَاشْ يِتْفَرْجُوا فِي الصَّلْبْ، وَقْتِلِّي شَافُوا الِّي صَارْ، رَوْحُوا لِدْيَارْهُمْ وهُومَا يَضْرْبُوا عْلَى صْدُورَاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","آمَا صُوحَابْ يَسُوعْ الكُلْ والنْسَاء الِّي تَبْعُوهْ مِالجَلِيلْ، كَانُوا وَاقْفِينْ مِنْ بْعِيدْ يِتْفَرْجُوا فِلِّي قَاعِدْ صَايِرْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","وفِي المَجْلِسْ الأَعْلَى مْتَاعْ اليْهُودْ، كَانْ فَمَّة رَاجِلْ تَقِيْ وصَالِحْ إِسْمُو يُوسِفْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ومَا كَانِشْ مْوَافِقْ لَا عَالقَرَارْ الِّي خْذَاوِهْ فِي المَجْلِسْ ولَا عَلِّي عَمْلُوهْ. ويُوسِفْ هَاذَا أَصْلُو مِالرَّامَة الِّي هِيَّ مْدِينَة مِنْ مُدُنْ اليْهُودْ، وكَانْ يِسْتَنَّى فِي مَمْلَكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","يَاخِي مْشَى لْبِيلَاطُسْ وطْلَبْ مِنُّو جُثِّةْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","وهَبّْطُو مِنْ فُوقْ الصَّلِيبْ وكَفْنُو، وحَطُّو فِي قْبَرْ مَحْفُورْ فِي الحْجَرْ مَا تِدْفِنْ فِيهْ حَتَّى حَدْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ونْهَارِتْهَا كَانْ نْهَارْ التَّحْضِيرْ لِلسِّبْتْ الِّي كَانْ قْرِيبْ يَبْدَى. ");
INSERT INTO aeu_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","والنْسَاء الِّي جَاوْ مْعَ يَسُوعْ مِالجَلِيلْ تَبْعُوا يُوسِفْ، وشَافُوا القْبَرْ وكِيفَاشْ الجُثَّة تْحَطِّتْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ومْبَعِّدْ رَوْحُوا وحَضّْرُوا عِطْرْ وقْوَارِصْ. ونْهَارْ السِّبْتْ ارْتَاحُوا كِيفْ مَا وَصَّاتْ الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ونْهَارْ الأَحَدْ فِي الفَجْرْ، جَاوْ النْسَاء لِلْقْبَرْ هَازِّينْ العِطْرْ الِّي حَضّْرُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","يَاخِي لْقَاوْ الحَجْرَة تْنَحَّاتْ مِنْ مَدْخِلْ القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","وكِي دَخْلُوا مَا لْقَاوِشْ جُثِّةْ الرَّبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","وهُومَا حَايْرِينْ فِلِّي صَارْ، إِذَا بْزُوزْ رْجَالْ حْوَايِجْهُمْ تِلْمَعْ، وِقْفُوا بِجْنَبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","يَاخِي مْكِنْهُمْ الخُوفْ وطَبْسُوا رْيُوسْهُمْ، وَقْتْهَا قَالُولْهُمْ الزُّوزْ الرْجَالْ: «عْلَاشْ تْلَوْجُوا عَالحَيْ بِينْ المُوتَى؟ ");
INSERT INTO aeu_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","هُوَّ مُشْ هْنَا، آمَا رَاهُو قَامْ! تْذَكْرُوا الِّي قَالْهُولْكُمْ وَقْتِلِّي كَانْ فِي الجَلِيلْ: ");
INSERT INTO aeu_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","\"إِبْنْ الإِنْسَانْ لَازِمْ يْسَلْمُوهْ لِيْدِينْ نَاسْ مُذْنْبِينْ، ويِتْصْلَبْ، وفِي النْهَارْ الثَّالِثْ يْقُومْ\"». ");
INSERT INTO aeu_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","يَاخِي تْذَكْرُوا كْلَامُو. ");
INSERT INTO aeu_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","وَلَّاوْ رَجْعُوا مِالقْبَرْ وحْكَاوْ الِّي صَارْ الكُلْ لِلتْلَامْذَة الحْدَاشْ ولِلْأُخْرِينْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ولِّي حْكَاوْ لِلرُّسُلْ هُومَا: مَرْيِمْ المَجْدَلِيَّة، ويُوَنَّا، ومَرْيِمْ أُمْ يَعْقُوبْ، والنْسَاء الأُخْرِينْ الِّي مْشَاوْ مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","والرُّسُلْ مَا صَدْقُوهُمْشْ، وظْهُرِّلْهُمْ الِّي هُومَا يْخَلْوْضُوا. ");
INSERT INTO aeu_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","آمَا بُطْرُسْ قَامْ وجْرَى لِلْقْبَرْ، وكِي طَلْ لْقَى قْمَايِطْ الكْفَنْ مَلْفُوفِينْ وَحَّدْهُمْ. يَاخِي رْجَعْ وهُوَّ مِسْتَغْرِبْ مِالحْكَايَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","وفِي نَفْسْ النْهَارْ، فَمَّة زُوزْ مِالتْلَامْذَة كَانُوا فِي الثْنِيَّة مَاشِينْ لْدَشْرَة تِبْعِدْ حْدَاشِنْ كِيلُومَاتِرْ عْلَى أُورْشَلِيمْ، إِسْمْهَا عِمْوَاسْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","وكَانُوا يَحْكِيوْ عَلِّي صَارْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","وهُومَا يَحْكِيوْ ويِتْنَاقْشُوا، وإِذَا بِيهْ يَسُوعْ بِيدُو جَاء وبْدَا يِمْشِي مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","آمَا تْقُولِشْ عْلِيهَا فَمَّة حَاجَة غَمْضِتِّلْهُمْ عِينِيهُمْ يَاخِي مَا عَرْفُوهُوشْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","يَاخِي سْإِلْهُمْ: «فَاشْ تَحْكِيوْ وإِنْتُومَا مَاشِينْ؟». وِقْفُوا وكَانْ الحُزْنْ ظَاهِرْ عْلَى وْجُوهْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","وجَاوْبُو وَاحِدْ مِنْهُمْ إِسْمُو كْلِيُوبَاسْ: «يَاخِي إِنْتِ البَرَّانِي الوَحِيدْ فِي أُورْشَلِيمْ الِّي مَا يَعْرِفْشْ آشْ صَارْ فِي هَا الأَيَّامَاتْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","قَالِلْهُمْ: «آشْ صَارْ؟». قَالُولُو: «الِّي صَارْ فِي يَسُوعْ النَّاصْرِي، الِّي كَانْ نَبِيْ عَنْدُو قُدْرَة فِي القَوْلْ وفِي الفِعْلْ قُدَّامْ اللَّهْ وقُدَّامْ الشَّعْبْ الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","وكِيفَاشْ كْبَارْ الكَهَنَة وقَادِتْنَا سَلْمُوهْ بَاشْ يِتْحْكَمْ عْلِيهْ بِالمُوتْ وصَلْبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","وأَحْنَا كَانْ عَنْدْنَا أَمَلْ الِّي هُوَّ بِشْ يِفْدِي بَنِي إِسْرَائِيلْ. وزِيدْ عْلَى هَاذَا الكُلْ، اليُومْ هُوَّ النْهَارْ الثَّالِثْ مِلِّي صَارِتْ الحْكَايَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","آمَا فَمَّة نْسَاء مِنْ جْمَاعِتْنَا حَيْرُونَا. مْشَاوْ لِلْقْبَرْ فِي الفَجْرْ، ");
INSERT INTO aeu_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ومَا لْقَاوِشْ الجُثَّة، يَاخِي رَجْعُوا وقَالُولْنَا الِّي هُومَا شَافُوا زُوزْ مْلَايْكَة فِي رُؤْيَا قَالُولْهُمْ الِّي هُوَّ حَيْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ومْشَاوْ جْمَاعَة مِنَّا لِلْقْبَرْ، ولْقَاوْ الحْكَايَة صْحِيحَة كِيمَا قَالُوا النْسَاء، آمَا هُوَّ مَا شَافُوهُوشْ». ");
INSERT INTO aeu_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","يَاخِي قَالِلْهُمْ يَسُوعْ: «قَدَّاشْكُمْ مَا تِفْهْمُوشْ وقَدَّاشْكُمْ رْزَانْ فِي الإِيمَانْ بِلِّي قَالُوهْ الأَنْبِيَاءْ! ");
INSERT INTO aeu_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","يَاخِي المَسِيحْ مُشْ كَانْ لَازْمُو يْعَانِي الوْجَايَعْ هَاذِي، ومْبَعِّدْ يُدْخُلْ لْمَجْدُو؟». ");
INSERT INTO aeu_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","وبْدَالْهُمْ مِنْ تَوْرَاةْ مُوسَى حَتَّى لِكْتُبْ الأَنْبِيَاءْ الكُلْ، يْفَسْرِلْهُمْ فِلِّي تِكْتِبْ عْلِيهْ فِي الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","وكِي قُرْبُوا لِلدَّشْرَة الِّي كَانُوا مَاشِينِيلْهَا، حْسِبْ يَسُوعْ رُوحُو مَاشِي لِبْلَاصَة مَا أَبْعِدْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","آمَا هُومَا شَدُّوا فِيهْ صْحِيحْ وقَالُوا: «أَبْقَى مْعَانَا عْلَى خَاطِرْ النْهَارْ قْرِيبْ يُوفَى والدِّنْيَا بْدَاتْ تِظْلَامْ». وَلَّى دْخَلْ وبْقَى مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","وكِي قْعَدْ مْعَاهُمْ بَاشْ يَاكْلُوا، خْذَا الخُبْزْ وشْكَرْ وقْسِمْ وعْطَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","وَقْتْهَا تْحَلِّتْ عِينِيهُمْ وعَرْفُوهْ، وفِي لَحْظِتْهَا مَا عَادِشْ شَافُوهْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","وقَالُوا لِبْعَضْهُمْ: «هَاذَاكَا عْلَاشْ كُنَّا نْحِسُّوا كِيمَا النَّارْ تَاكِلْ فِي قْلُوبْنَا بِالفَرْحَة وَقْتِلِّي كَانْ يْكَلِّمْ فِينَا فِي الطْرِيقْ ويْفَسْرِلْنَا فِي الكْتُبْ المُقَدْسَة!». ");
INSERT INTO aeu_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","وقَامُوا بِالوَقْتْ ورَجْعُوا لْأُورْشَلِيمْ، ولْقَاوْ الرُّسُلْ الحْدَاشْ ولِّي مْعَاهُمْ مَلْمُومِينْ، ");
INSERT INTO aeu_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","وكَانُوا يْقُولُوا الزُّوزْ رْجَالْ: «بِالحَقْ الرَّبْ يَسُوعْ قَامْ مِالمُوتْ، وظْهُرْ لْسِمْعَانْ!». ");
INSERT INTO aeu_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","يَاخِي حْكَاوُلْهُمْ التْلَامْذَة الزُّوزْ عَلِّي صَارْ فِي الطْرِيقْ، وكِيفَاشْ عَرْفُوا الِّي هُوَّ الرَّبْ يَسُوعْ وَقْتِلِّي قْسَمِّلْهُمْ الخُبْزْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","وهُومَا يَحْكِيوْ، وْقِفْ يَسُوعْ بِيدُو فِي وِسْطْهُمْ وقَالِلْهُمْ: «السَّلَامْ لِيكُمْ!». ");
INSERT INTO aeu_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","آمَا هُومَا خَافُوا وتْرِعْبُوا عْلَى خَاطِرْ مْشَى فِي بَالْهُمْ الِّي هُومَا قَاعْدِينْ يْشُوفُوا فِي شَبَحْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","يَاخِي قَالِلْهُمْ: «شْبِيكُمْ دَاخْلِينْ بْعَضْكُمْ؟ وعْلَاشْ الشَّكْ هَاذَا فِي قْلُوبْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","شُوفُوا يْدَيَّا وسَاقَيَّا، آنَا هُوَّ. مِسُّونِي وتْأَكْدُوا. رَاهُو الشَّبَحْ لَا عَنْدُو لْحَمْ ولَا عْظَمْ كِيمَا آنَا عَنْدِي». ");
INSERT INTO aeu_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","وكِي قَالِلْهُمْ هَاذَا، وَرَّاهُمْ يْدِيهْ وسَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","وهُومَا بَاهْتِينْ ومُشْ مْصَدْقِينْ رْوَاحْهُمْ مِنْ كُثْرِةْ الفَرْحَة، قَالِلْهُمْ: «عَنْدْكُمْشِي مَا يِتَّاكِلْ؟». ");
INSERT INTO aeu_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","يَاخِي عْطَاوَهْ شْوَيَّة حُوتْ مِشْوِي، ");
INSERT INTO aeu_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","خْذَاهْ وكْلَاهْ قُدَّامْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ومْبَعِّدْ قَالِلْهُمْ: «هَاذَا هُوَّ الكْلَامْ الِّي قُلْتْهُولْكُمْ كِي كُنْتْ مْعَاكُمْ: إِنُّو لَازِمْ يْتِمْ كُلْ الِّي تِكْتِبْ عْلِيَّا فِي تَوْرَاةْ مُوسَى وكْتُبْ الأَنْبِيَاءْ والمَزَامِيرْ». ");
INSERT INTO aeu_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","مْبَعِّدْ نَوْرِلْهُمْ عْقُولْهُمْ بَاشْ يِفْهْمُوا الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","وقَالِلْهُمْ: «الكْتُبْ المُقَدْسَة تْقُولْ الِّي المَسِيحْ لَازْمُو يْعَانِي الوْجَايَعْ ويْقُومْ مِالمُوتْ فِي النْهَارْ الثَّالِثْ، ");
INSERT INTO aeu_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","وبْشَارِةْ التُّوبَة وغُفْرَانْ الذْنُوبْ بْإِسْمُو لَازِمْ تُوصِلْ لِلشُّعُوبْ الكُلْ، وبِشْ تَبْدَى مِنْ أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","وإِنْتُومَا شْهُودْ عْلَى هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","وهَانِي بِشْ نِبْعْثِلْكُمْ الِّي وْعِدْ بِيهْ بَابَا. مَالَا أُقْعْدُوا فِي مْدِينِةْ أُورْشَلِيمْ حَتَّى لِينْ تَاخْذُوا قُوَّة مِالسْمَاء». ");
INSERT INTO aeu_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","مْبَعِّدْ خَرَّجْهُمْ مِالمْدِينَة وهَزْهُمْ قْرِيبْ لْبِيتْ عَنْيَا، وغَادِي هَزْ يْدِيهْ وبَارِكْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","وهُوَّ يْبَارِكْ فِيهُمْ، فَارِقْهُمْ وتِرْفَعّْ لِلسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","يَاخِي سِجْدُولُو، ورَجْعُوا لْأُورْشَلِيمْ وهُومَا طَايْرِينْ بِالفَرْحَة. ");
INSERT INTO aeu_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","وكَانُوا دِيمَا فِي الهَيْكِلْ، يْسَبْحُوا ويْبَارْكُوا فِي اللَّهْ.");
INSERT INTO aeu_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","فِي الأُوِّلْ بِالكُلْ كَانْ الكِلْمَة، والكِلْمَة كَانْ عَنْدْ اللَّهْ، والكِلْمَة كَانْ هُوَّ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","هُوَّ كَانْ فِي الأُوِّلْ عَنْدْ اللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","واللَّهْ خْلَقْ كُلْ شَيْ بِيهْ، ومِنْ غِيرُو مَا تِخْلَقّْ حَتَّى شَيْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","فِيهْ كَانِتْ الحَيَاةْ، والحَيَاةْ هَاذِي كَانِتْ النُّورْ لِلنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","والنُّورْ يِضْوِي فِي الظْلَامْ، والظْلَامْ مَا غِلْبُوشْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","بْعَثْ اللَّهْ رَاجِلْ إِسْمُو يُوحَنَّا، ");
INSERT INTO aeu_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ويُوحَنَّا جَاء شَاهِدْ بَاشْ يِشْهِدْ لِلنُّورْ، بَاشْ عْلَى طْرِيقُو هُوَّ يَمْنُوا النَّاسْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","مَا كَانِشْ هُوَّ النُّورْ، آمَا جَاء بَاشْ يِشْهِدْ لِلنُّورْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","والكِلْمَة هُوَّ النُّورْ الحَقِيقِي الِّي جَاء لِلْعَالِمْ، بَاشْ يْنَوَّرْ كُلْ إِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","هُوَّ كَانْ فِي العَالِمْ، وبِيهْ تِخْلَقّْ العَالِمْ، آمَا العَالِمْ مَا عَرْفُوشْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","جَاء لْشَعْبُو، آمَا شَعْبُو مَا قِبْلُوشْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","آمَا النَّاسْ الِّي قِبْلُوهْ الكُلْ، مَعْنِتْهَا الِّي أَمْنُوا بْإِسْمُو، عْطَاهُمْ الحَقْ بَاشْ يْوَلِّيوْ وْلَادْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","هُومَا الِّي تْوِلْدُوا، لَا مِنْ بَشَرْ ولَا مِنْ شَهْوِةْ بْدَنْ ولَا مِنْ قَرَارْ إِنْسَانْ، آمَا تْوِلْدُوا مِنْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","والكِلْمَة وَلَّى بَشَرْ، وعَاشْ بِينَاتْنَا مِلْيَانْ بِالنِّعْمَة والحَقْ. وشُفْنَا مَجْدُو، المَجْدْ الِّي خْذَاهْ مِنْ عَنْدْ الآبْ، بِإِعْتِبَارُو إِبْنُو الوَحِيدْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","وشْهِدْلُو يُوحَنَّا وقَالْ: «هَاذَا هُوَّ الِّي قُلْتْ عْلِيهْ: الِّي جَايْ بَعْدِي هُوَّ أَعْظَمْ مِنِّي عْلَى خَاطْرُو كَانْ قَبْلِي». ");
INSERT INTO aeu_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","وأَحْنَا الكُلْنَا خْذِينَا مِنْ نِعْمْتُو الفَايْضَة، نِعْمَة فُوقْ نِعْمَة، ");
INSERT INTO aeu_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","عْلَى خَاطِرْ اللَّهْ عْطَانَا الشَّرِيعَة عْلَى طْرِيقْ مُوسَى، آمَا الحَقْ والنِّعْمَة جَاوْ عْلَى طْرِيقْ يَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","حَتَّى حَدْ مَا شَافْ اللَّهْ. آمَا الإِبْنْ الوَحِيدْ الِّي هُوَّ عَنْدْ الآبْ، عَرَّفْنَا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","وهَاذِي هِيَّ الشْهَادَة الِّي شْهِدْ بِيهَا يُوحَنَّا، وَقْتِلِّي اليْهُودْ الِّي فِي أُورْشَلِيمْ بَعْثُولُوا كَهَنَة ولَاوِيِّينْ بَاشْ يِسْأْلُوهْ: «شْكُونِكْ إِنْتِ؟». ");
INSERT INTO aeu_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","مَا نْكَرْشْ وقَالِلْهُمْ جْهَارْ: «مَانِيشْ آنَا المَسِيحْ». ");
INSERT INTO aeu_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","وَلَّاوْ سِأْلُوهْ: «مَالَا شْكُونِكْ؟ إِنْتِ إِيلِيَّا؟». قَالِلْهُمْ: «لَا». «إِنْتِ النَّبِيْ؟». جَاوِبْهُمْ زَادَا: «لَا». ");
INSERT INTO aeu_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","قَالُولُو: «مَالَا شْكُونِكْ إِنْتِ؟ آشْ نْقُولُوا لِلنَّاسْ الِّي بَعْثُونَا؟ شُنُوَّة تْقُولْ عْلَى رُوحِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","قَالْ: «كِيمَا قَالْ النَّبِيْ إِشَعْيَاءْ: \"آنَا صُوتْ يْعَيِّطْ فِي الخْلَاء: حَضّْرُوا طْرِيقْ الرَّبْ\"». ");
INSERT INTO aeu_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","وبِينْ المَبْعُوثِينْ كَانْ فَمَّة فِرِّيسِيِّينْ، ");
INSERT INTO aeu_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","سِأْلُوهْ: «عْلَاشْ تْعَمِّدْ إِذَا كَانْ مَاكِشْ المَسِيحْ ولَا إِيلِيَّا ولَا النَّبِيْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","جَاوِبْهُمْ يُوحَنَّا: «آنَا نْعَمِّدْ فِي المَاء، آمَا بِينَاتْكُمْ وَاحِدْ مَا تَعْرْفُوهِشْ، ");
INSERT INTO aeu_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","هُوَّ يْجِي بَعْدِي، ويْكُونْ أَعْظَمْ مِنِّي، وآنَا مَا نِسْتَاهِلْشْ نْكُونْ الخْدِيمْ الِّي يْحِلُّو رْبَايِطْ صَنْدَالُو». ");
INSERT INTO aeu_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","هَاذَا الكُلْ صَارْ فِي دَشْرِةْ بِيتْ عَنْيَا، فِي شَرْقْ نَهْرْ الأُرْدُنْ، وِينْ كَانْ يُوحَنَّا يْعَمِّدْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","مِنْ غُدْوَة شَافْ يُوحَنَّا يَسُوعْ جَايُو، يَاخِي قَالْ: «هَاذَا هُوَّ خَرُوفْ اللَّهْ الِّي يْنَحِّي ذْنُوبْ العَالِمْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","هَاذَا هُوَّ الِّي قُلْتْ عْلِيهْ: فَمَّة شْكُونْ يْجِي بَعْدِي، وهُوَّ أَعْظَمْ مِنِّي، عْلَى خَاطْرُو كَانْ قَبْلِي. ");
INSERT INTO aeu_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","وآنَا بِيدِي مَا كُنْتِشْ نَعْرْفُو. آمَا جِيتْ نْعَمِّدْ فِي المَاء بَاشْ بَنِي إِسْرَائِيلْ يَعْرْفُوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","وشْهِدْ يُوحَنَّا، وقَالْ: «آنَا شُفْتْ الرُّوحْ هَابِطْ مِالسْمَاء كِالحْمَامَة وحَطْ فُوقُو. ");
INSERT INTO aeu_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","وآنَا مَا كُنْتِشْ نَعْرْفُو، آمَا الِّي بْعَثْنِي بَاشْ نْعَمِّدْ فِي المَاء قَالِّي: \"الِّي تْشُوفْ الرُّوحْ يَهْبِطْ ويْحُطْ فُوقُو، هَاذَاكَا هُوَّ الِّي بَاشْ يْعَمِّدْ فِي الرُّوحْ القُدُسْ\". ");
INSERT INTO aeu_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","وآنَا شُفْتْ هَاذَا بْعِينِي، هَاذَاكَا عْلَاشْ نِشْهِدْ الِّي هُوَّ إِبْنْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","مِنْ غُدْوَة كَانْ يُوحَنَّا وَاقِفْ مْعَ زُوزْ مِنْ تْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","شَافْ يَسُوعْ مِتْعَدِّي يَاخِي قَالْ: «هَاذَا هُوَّ خَرُوفْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","وكِي سَمْعُوا التْلَامْذَة الزُّوزْ الكْلَامْ هَاذَا، مْشَاوْ وتَبْعُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ووَقْتِلِّي تْلَفِّتْ يَسُوعْ وشَافْهُمْ يْتَبْعُوا فِيهْ، سْإِلْهُمْ: «آشْ تْحِبُّوا؟». قَالُولُو: «يَا رَابِّي، (الِّي مَعْنَاهْ يَا مُعَلِّمْ)، وِينْ تُسْكُنْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","قَالِلْهُمْ: «إِيجَاوْ شُوفُوا». يَاخِي مْشَاوْ وشَافُوهْ وِينْ يُسْكُنْ، وعَدَّاوْ مْعَاهْ بْقِيِّة النْهَارْ، ووَقْتْهَا كَانِتْ الأَرْبْعَة مْتَاعْ العْشِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","أَنْدَرَاوُسْ خُو سِمْعَانْ بُطْرُسْ، كَانْ وَاحِدْ مِالزُّوزْ الِّي سَمْعُوا آشْ قَالْ يُوحَنَّا، وتَبْعُوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","لْقَى أَنْدَرَاوُسْ خُوهْ سِمْعَانْ، وقَالُّو: «لْقِينَا المَسِيَّا»، الِّي مَعْنَاهْ المَسِيحْ، ");
INSERT INTO aeu_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","وهَزُّو مْعَاهْ لْيَسُوعْ. غْزَرْلُوا يَسُوعْ وقَالُّو: «إِنْتِ سِمْعَانْ وِلْدْ يُونَا. بِشْ يْوَلِّي إِسْمِكْ صَفَا، الِّي مَعْنَاهْ \"بُطْرُسْ\"». ");
INSERT INTO aeu_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","مِنْ غُدْوَة قَرِّرْ يَسُوعْ يِمْشِي لْمَنْطَقْةْ الجَلِيلْ، يَاخِي لْقَى فِيلِۑُّسْ وقَالُّو: «تَبَّعْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","وفِيلِۑُّسْ كَانْ مِنْ بِيتْ صَيْدَا، مْدِينِةْ أَنْدَرَاوُسْ وبُطْرُسْ. ");
INSERT INTO aeu_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","لْقَى فِيلِۑُّسْ نَثَنَائِيلْ، وقَالُّو: «لْقِينَا الِّي كْتِبْ عْلِيهْ مُوسَى فِي التَّوْرَاةْ، وكِتْبُوا عْلِيهْ الأَنْبِيَاءْ، يَسُوعْ وِلْدْ يُوسِفْ الِّي مِنْ مْدِينِةْ النَّاصْرَة». ");
INSERT INTO aeu_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","قَالُّو نَثَنَائِيلْ: «يَاخِي تُخْرُجْ مِالنَّاصْرَة حَاجَة تُصْلُحْ؟» جَاوْبُو فِيلِۑُّسْ: «إِيجَا وشُوفْ!». ");
INSERT INTO aeu_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","شَافْ يَسُوعْ نَثَنَائِيلْ جَايُّو، يَاخِي قَالْ عْلِيهْ: «هَاذَا إِسْرَائِيلِي بِالحَقْ، ومَا فِيهِشْ شَكْ!» ");
INSERT INTO aeu_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","قَالُّو نَثَنَائِيلْ: «كِيفَاشْ عْرَفْتْنِي؟» جَاوْبُو يَسُوعْ: «قْبَلْ مَا يْعَيِّطْلِكْ فِيلِۑُّسْ رِيتِكْ قَاعِدْ تَحْتْ الكَرْمَة». ");
INSERT INTO aeu_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","جَاوْبُو نَثَنَائِيلْ: «يَا مُعَلِّمْ إِنْتِ هُوَّ إِبْنْ اللَّهْ. إِنْتِ هُوَّ مَلِكْ إِسْرَائِيلْ!» ");
INSERT INTO aeu_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","جَاوْبُو يَسُوعْ: «يَاخِي أَمَّنْتْ عْلَى خَاطِرْ قُتْلِكْ الِّي آنَا شُفْتِكْ قَاعِدْ تَحْتْ الكَرْمَة؟ رَاكْ بَاشْ تْشُوفْ حَاجَاتْ أَعْظِمْ مِنْ هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","وزَادْ قَالُّو: «الحَقْ الحَقْ نْقُولِلْكُمْ: بِشْ تْشُوفُوا السْمَاء مَحْلُولَة، ومْلَايِكْةْ اللَّهْ طَالْعِينْ هَابْطِينْ عْلَى إِبْنْ الإِنْسَانْ». ");
INSERT INTO aeu_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","وفِي النْهَارْ الثَّالِثْ كَانْ فَمَّة عِرْسْ فِي مْدِينِةْ قَانَا الِّي فِي مَنْطَقْةْ الجَلِيلْ، وكَانِتْ أُمْ يَسُوعْ حَاضْرَة فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ويَسُوعْ وتْلَامِذْتُو كَانُوا زَادَا مِسْتَدْعِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","وَقْتِلِّي وْفَى الشْرَابْ، قَالِتْلُو أُمُّو: «رَاهُو مَا عَادِشْ عَنْدْهُمْ شْرَابْ». ");
INSERT INTO aeu_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","قَالِلْهَا يَسُوعْ: «عْلَاشْ تْحِبْنِي نِدَّخِّلْ يَا مْرَا؟ رَاهُو وَقْتِي مَزَّالْ مَا جَاشْ!». ");
INSERT INTO aeu_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","قَالِتْ أُمُّو لِلْخُدَّامْ: «الِّي يْقُلْكُمْ عْلِيهْ أَعْمْلُوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","وكَانِتْ فَمَّة سِتَّة قْلَالْ حْجَرْ مِلِّي يِسْتَعْمْلُوهُمْ اليْهُودْ بِشْ يِطَّهْرُوا بْمَاهُمْ، حَسْبْ عَادَاتْهُمْ. كُلْ وَحْدَة مِنْهُمْ تَرْفَعْ مَا بِينْ 80 و120 إِيتْرَا. ");
INSERT INTO aeu_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","قَالْ يَسُوعْ لِلْخُدَّامْ: «عَبِّيوْ القْلَالْ بِالمَاء» يَاخِي عَبَّاوْهُمْ لِلْفُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","وقَالِلْهُمْ: «تَوَّا أُغْرْفُوا مِنْهَا وأَعْطِيوْ لِلْمَسْؤُولْ عَالسَّهْرِيَّة». وهَاذَاكَا آشْ عَمْلُوا. ");
INSERT INTO aeu_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ووَقْتِلِّي ذَاقْ المَسْؤُولْ عَالسَّهْرِيَّة المَاء الِّي وَلَّى شْرَابْ، مَا كَانِشْ يَعْرِفْ عْلِيهْ مْنِينْ جَاء. آمَا الخُدَّامْ الِّي جَابُوهُولُو كَانُوا يَعْرْفُوا. يَاخِي عَيِّطْ لِلْعْرُوسْ ");
INSERT INTO aeu_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","وقَالُّو: «النَّاسْ الكُلْ يَعْطِيوْ الشْرَابْ البَاهِي فِي الأُوِّلْ، وبَعْدْمَا يِسْكْرُوا الضْيُوفْ، يَعْطِيوْهُمْ الشْرَابْ العَادِي. آمَا إِنْتِ خَلِّيتْ الشْرَابْ البَاهِي لِلِّخِّرْ!». ");
INSERT INTO aeu_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","وهَاذِي أَوِّلْ مُعْجْزَة يَعْمَلْهَا يَسُوعْ، وكَانِتْ فِي مْدِينِةْ قَانَا فِي الجَلِيلْ. وهَكَّا ظَهِّرْ مَجْدُو، يَاخِي أَمْنُوا بِيهْ تْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","وبَعْدْهَا، هْبَطْ لْكَفْرْنَاحُومْ هُوَّ وأُمُّو وخْوَاتُو وتْلَامِذْتُو، وقَعْدُوا فِيهَا أَيَّامَاتْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","وكِي قْرُبْ عِيدْ الفِصْحْ اليْهُودِي، طْلَعْ يَسُوعْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ولْقَى فِي الهَيْكِلْ بَيَّاعِةْ البْڨَرْ والغْنَمْ والحْمَامْ، ولِّي يْصَرْفُوا فِي الفْلُوسْ حَاطِّينْ طْوَاوِلْهُمْ وقَاعْدِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","يَاخِي عْمَلْ سُوطْ مِنْ حْبَالْ، وطَرِّدْهُمْ الكُلْ مِالهَيْكِلْ، هُومَا وغْنَمْهُمْ وبْڨَرْهُمْ. وقْلِبْ طْوَاوِلْ النَّاسْ الِّي يْصَرْفُوا فِي الفْلُوسْ وفَرْتِلْهُمْ فْلُوسْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","وقَالْ لْبَيَّاعِةْ الحْمَامْ: «هِزُّوا حْمَامْكُمْ مِنْ هُونِي! مَا تْرُدُّوشْ دَارْ بَابَا سُوقْ لِلْبِيعْ والشْرَى». ");
INSERT INTO aeu_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","يَاخِي تْذَكْرُوا تْلَامِذْتُو المَكْتُوبْ فِي الكْتُبْ المُقَدْسَة: «الغِيرَة عْلَى دَارِكْ كْلَاتْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","قَالُولُو اليْهُودْ: «أَعْمْلِلْنَا مُعْجْزَة تْوَرِّينَا الِّي عَنْدِكْ الحَقْ بَاشْ تَعْمِلْ الِّي عْمَلْتُو». ");
INSERT INTO aeu_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","جَاوِبْهُمْ يَسُوعْ: «هِدُّوا الهَيْكِلْ هَاذَا، وآنَا نْعَاوِدْ نِبْنِيهْ فِي ثْلَاثَة أَيَّامْ». ");
INSERT INTO aeu_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","قَالُولُو اليْهُودْ: «الهَيْكِلْ هَاذَا قْعَدْ 46 سْنَة بَاشْ يِتِبْنَى، وإِنْتِ بَاشْ تِبْنِيهْ فِي ثْلَاثَة أَيَّامْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","آمَا الهَيْكِلْ الِّي كَانْ يُقْصُدْ فِيهْ هُوَّ بَدْنُو. ");
INSERT INTO aeu_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","هَاذَاكَا عْلَاشْ، وَقْتِلِّي قَامْ مِالمُوتْ، تْذَكْرُوا تْلَامِذْتُو آشْ قَالْ، وأَمْنُوا بِالكْتُبْ المُقَدْسَة وبِالكْلَامْ الِّي قَالُّو يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","وَقْتِلِّي كَانْ فِي أُورْشَلِيمْ فِي عِيدْ الفِصْحْ، أَمْنُوا بِيهْ بَرْشَة نَاسْ كِي شَافُوا المُعْجْزَاتْ الِّي عْمَلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","آمَا هُوَّ مَا سْتَأْمِنْهُمْشْ عْلَى رُوحُو، عْلَى خَاطْرُو كَانْ يَعْرِفْ النَّاسْ الكُلْ بِالڨْدَا، ");
INSERT INTO aeu_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ومَا يِحْتَاجِشْ لِشْكُونْ يَحْكِيلُو عْلِيهُمْ. عْلَى خَاطْرُو يَعْرِفْ شْنُوَّة فِي قَلْبْ كُلْ إِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","كَانْ فَمَّة رَاجِلْ فِرِّيسِي إِسْمُو نِيقُودِيمُوسْ، وَاحِدْ مِنْ قَادِةْ اليْهُودْ، ");
INSERT INTO aeu_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","جَاء لْيَسُوعْ فِي اللِّيلْ وقَالُّو: «يَا مُعَلِّمْ، نَعْرْفُوا الِّي إِنْتِ مُعَلِّمْ جِيتْ مِنْ عَنْدْ اللَّهْ. عْلَى خَاطِرْ حَتَّى حَدْ مَا يْنَجِّمْ يَعْمِلْ المُعْجْزَاتْ الِّي تَعْمِلْ فِيهُمْ، إِلَّا إِذَا كَانْ اللَّهْ مْعَاهْ». ");
INSERT INTO aeu_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","يَاخِي جَاوْبُو يَسُوعْ: «الحَقْ الحَقْ نْقُلِّكْ: حَتَّى حَدْ مَا يْنَجِّمْ يْشُوفْ مَمْلَكْةْ اللَّهْ إِلَّا إِذَا كَانْ يْعَاوِدْ يِتْوْلِدْ مِنْ جْدِيدْ». ");
INSERT INTO aeu_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","سِأْلُو نِيقُودِيمُوسْ: «كِيفَاشْ الوَاحِدْ يْنَجِّمْ يِتْوْلِدْ بَعْدْمَا شَابْ؟ يَاخِي يْنَجِّمْ يُدْخُلْ لْكِرْشْ أُمُّو مَرَّة أُخْرَى ويِتْوْلِدْ مِنْ جْدِيدْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","جَاوْبُو يَسُوعْ: «الحَقْ الحَقْ نْقُلِّكْ: إِذَا كَانْ وَاحِدْ مَا يِتْوْلِدْشْ مِالمَاء ومِالرُّوحْ، مَا يْنَجِّمْشْ يُدْخُلْ لْمَمْلِكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","المَوْلُودْ مِنْ لْحَمْ ودَمْ هُوَّ لْحَمْ ودَمْ، والمَوْلُودْ مِنْ رُوحْ اللَّهْ هُوَّ تَابَعْ لْرُوحْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","مَا تِسْتَغْرَبْشْ الِّي قُتْلِكْ: يِلْزْمِكُمْ تِتْوِلْدُوا مِنْ جْدِيدْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","الرِّيحْ تْهِبْ كِيفْ مَا تْحِبْ، وتِسْمَعْ صُوتْهَا، آمَا مَا تَعْرِفْهَاشْ مْنِينْ جَاتْ ولَا لْوِينْ مَاشْيَة: ونَفْسْ الشَّيْ بِالنِّسْبَةْ لْكُلْ وَاحِدْ يِتْوْلِدْ مِالرُّوحْ». ");
INSERT INTO aeu_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","قَالُّو نِيقُودِيمُوسْ: «كِيفَاشْ يْنَجِّمْ يْصِيرْ هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","جَاوْبُو يَسُوعْ: «إِنْتِ تْعَلِّمْ فِي بَنِي إِسْرَائِيلْ ومَا تَعْرَفْشْ هَاذَا! ");
INSERT INTO aeu_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","الحَقْ الحَقْ نْقُلِّكْ: أَحْنَا نَحْكِيوْ عَلِّي نَعْرْفُوهْ، ونِشْهْدُوا عَلِّي شُفْنَاهْ، آمَا إِنْتُومَا مَا تِقْبْلُوشْ شْهَادِتْنَا. ");
INSERT INTO aeu_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","حْكِيتِلْكُمْ عْلَى أُمُورْ الدِّنْيَا هَاذِي ومَا صَدَّقْتُونِيشْ. مَالَا كِيفَاشْ بِشْ تْصَدْقُوا كِي نَحْكِيلْكُمْ عْلَى أُمُورْ السْمَاء؟ ");
INSERT INTO aeu_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","حَتَّى حَدْ مَا طْلَعْ لِلسْمَاء إِلَّا إِبْنْ الإِنْسَانْ الِّي هْبَطْ مِالسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","«وكِيمَا عَلَّقْ مُوسَى اللَّفْعَى فِي الصَّحْرَاء، هَكَّا إِبْنْ الإِنْسَانْ لَازِمْ يِتْعَلَّقْ زَادَا، ");
INSERT INTO aeu_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","بَاشْ كُلْ وَاحِدْ يَمِّنْ بِيهْ يَاخِذْ الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","اللَّهْ حَبْ النَّاسْ الكُلْ، لْدَرْجِةْ إِنُّو ضَحَّى بْإِبْنُو الوَحِيدْ، بَاشْ كُلْ مِنْ يَمِّنْ بِيهْ، مَا يِمْشِيشْ لِلْهْلَاكْ، آمَا يَاخُو الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","عْلَى خَاطِرْ اللَّهْ مَا بْعَثْشْ إِبْنُو لِلنَّاسْ بَاشْ يُحْكُمْ عْلِيهُمْ، آمَا بَاشْ يْنَجِّيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","الِّي يَمِّنْ بِيهْ مَا يِتْحَاسِبْشْ، ولِّي مَا يَمِّنْشْ رَاهُو تَحْكَمْ عْلِيهْ بِالمْسَبَّقْ، عْلَى خَاطْرُو مَا أَمَّنْشْ بْإِبْنْ اللَّهْ الوَحِيدْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","«وهَاذَا هُوَّ الحُكْمْ: النُّورْ جَاء لِلْعَالِمْ، آمَا النَّاسْ حَبُّوا الظْلَامْ أَكْثِرْ مِالنُّورْ، عْلَى خَاطِرْهُمْ يَعْمْلُوا فِي الشَّرْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","كُلْ وَاحِدْ يَعْمِلْ الشَّرْ يَكْرَهْ النُّورْ ومَا يُقْرُبْلُوشْ بَاشْ أَعْمَالُو مَا تِتْكْشِفْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","آمَا الِّي يْتَبَّعْ الحَقْ، يُقْرُبْ لِلنُّورْ، بَاشْ يُظْهُرْ الِّي أَعْمَالُو تْعَمْلِتْ بْقُوِّةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ومْبَعِّدْ مْشَى يَسُوعْ وتْلَامِذْتُو لْمَنْطَقْةْ اليَهُودِيَّة، وقْعَدْ مْعَاهُمْ غَادِي، وبْدَا يْعَمِّدْ فِي النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","وكَانْ يُوحَنَّا زَادَا يْعَمِّدْ فِي مَنْطَقْةْ عِينْ نُونْ، بَحْذَا مْدِينِةْ سَالِيمْ، عْلَى خَاطِرْ كَانْ فِيهَا بَرْشَة مَاء. وكَانُوا النَّاسْ يْجِيوْ بَاشْ يْعَمِّدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","وهَاذَا الكُلْ صَارْ قْبَلْ مَا يِتِرْمَى يُوحَنَّا فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","وصَارْ نِقَاشْ بِينْ تْلَامِذْةْ يُوحَنَّا ووَاحِدْ مِاليْهُودْ فِي مَوْضُوعْ التَّطْهِيرْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","يَاخِي جَاوْ لْيُوحَنَّا وقَالُولُو: «يَا مُعَلِّمْ، الرَّاجِلْ الِّي كَانْ مْعَاكْ فِي الشِّيرَة الأُخْرَى مْتَاعْ نَهْرْ الأُرْدُنْ ولِّي إِنْتِ شْهِدْتْلُو، رَاهُو تَوْ قَاعِدْ يْعَمِّدْ والنَّاسْ الكُلْ يِمْشِيوْلُو». ");
INSERT INTO aeu_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","جَاوِبْهُمْ يُوحَنَّا: «حَتَّى حَدْ مَا يْنَجِّمْ يَاخُذْ حَاجَة إِلَّا إِذَا كَانْ عْطَاهَالُو اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","وإِنْتُومَا بِيدْكُمْ تِشْهْدُوا الِّي آنَا قُلْتْ: \"مَانِيشْ آنَا المَسِيحْ، آمَا اللَّهْ بْعَثْنِي قَبْلُو بَاشْ نْحَضَّرْلُو الطْرِيقْ\". ");
INSERT INTO aeu_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","العْرُوسَة رَاهِي لِلْعْرُوسْ وَحْدُو، آمَا صَاحِبْ العْرُوسْ، يَاقِفْ بَحْذَاهْ ويِتْصَنِّتْ ويِفْرَحْ كِي يِسْمَعْ صُوتُو. وآنَا زَادَا نِفْرَحْ كِيفُو، وتَوَّا فَرْحْتِي كِمْلِتْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","عْلَى خَاطِرْ لَازْمُو هُوَّ يْزِيدْ، وآنَا نُنْقُصْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","«الِّي يْجِي مِالفُوقْ، هُوَّ فُوقْ الكُلْ. ولِّي هُوَّ مِالأَرْضْ، هُوَّ تَابَعْ لِلْأَرْضْ ويِتْكَلِّمْ بِكْلَامْ الأَرْضْ. الِّي يْجِي مِالسْمَاء، هُوَّ فُوقْ الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ويِشْهِدْ عَلِّي شَافُو وعَلِّي سَمْعُو وحَتَّى حَدْ مَا يِقْبِلْ شْهَادْتُو، ");
INSERT INTO aeu_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ولِّي قْبِلْ شْهَادْتُو، يِشْهِدْ الِّي اللَّهْ صَادِقْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","الِّي بَعْثُو اللَّهْ يِتْكَلِّمْ بِكْلَامْ اللَّهْ، عْلَى خَاطِرْ اللَّهْ يَعْطِي الرُّوحْ بْلَاشْ حْسَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","الآبْ يْحِبْ الإِبْنْ وحَطْ كُلْ شَيْ بِينْ يْدِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","الِّي يَمِّنْ بِالإِبْنْ، عَنْدُو الحَيَاةْ الأَبَدِيَّة. ولِّي مَا يَأَمَّنْشْ بِالإِبْنْ، مَا يْشُوفِشْ الحَيَاةْ، آمَا يُقْعِدْ تَحْتْ غَضَبْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","وَعْرَفْ يَسُوعْ الِّي الفِرِّيسِيِّينْ سَمْعُوا الِّي عْدَدْ تْلَامِذَتُو قَاعِدْ يْزِيدْ أَكْثِرْ مِنْ يُوحَنَّا ولِّي هُوَّ يْعَمِّدْ فِيهُمْ، ");
INSERT INTO aeu_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","رَغْمِلِّي مُشْ يَسُوعْ بِيدُو الِّي كَانْ يْعَمِّدْ آمَا تْلَامِذْتُو، ");
INSERT INTO aeu_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","وَلَّى خْرَجْ مِنْ مَنْطَقْةْ اليَهُودِيَّة ورْجَعْ لْمَنْطَقْةْ الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","وكَانْ لَازْمُو يِتْعَدَّى عْلَى مَنْطَقْةْ السَّامْرَة. ");
INSERT INTO aeu_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","وْصُلْ لِمْدِينَة فِي السَّامْرَة إِسْمْهَا سُوخَارْ، قْرِيبَة مِنْ قَطْعِةْ الأَرْضْ الِّي عْطَاهَا يَعْقُوبْ لْوِلْدُو يُوسِفْ، ");
INSERT INTO aeu_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","وِينْ فَمَّة بِيرْ يَعْقُوبْ. تْعِبْ يَسُوعْ مِالمَشِي يَاخِي قْعَدْ بَحْذَا البِيرْ. وكَانْ وَقْتْهَا ظُهْرْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","جَاتْ مْرَا سَامِرِيَّة بَاشْ تْعَبِّي المَاء، قَالِلْهَا يَسُوعْ: «أَعْطِينِي نُشْرُبْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","وكَانُوا تْلَامِذْتُو فِي المْدِينَة يِشْرِيوْ فِي المَاكْلَة. ");
INSERT INTO aeu_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","قَالِتْلُو المْرَا السَّامْرِيَّة: «إِنْتِ يْهُودِي وآنَا سَامْرِيَّة، كِيفَاشْ تُطْلُبْ مِنِّي بَاشْ نَعْطِيكْ تُشْرُبْ؟» قَالِتْلُو الكْلَامْ هَاذَا عْلَى خَاطِرْ اليْهُودْ مَا كَانُوشْ يِتْعَامْلُوا مْعَ السَّامِرِيِّينْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","جَاوِبْهَا يَسُوعْ: «كَانْ جِيتْ تَعْرِفْ آشْ يَعْطِي اللَّهْ، وشْكُونْ الِّي قَلِّكْ \"أَعْطِينِي نُشْرُبْ\"، رَاكْ إِنْتِ تُطْلِبْ مِنُّو، وهُوَّ يَعْطِيكْ المَاء الحَيْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","قَالِتْلُو المْرَا: «يَا سِيدِي، مْنِينْ جَاكْ المَاء الحَيْ، وإِنْتِ مَا عَنْدِكْشْ سْطَلْ، والبِيرْ غَارِقْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","يَاخِي إِنْتِ أَعْظَمْ مِنْ بُونَا يَعْقُوبْ الِّي عْطَانَا البِيرْ هَاذَا، وشْرَبْ مِنُّو هُوَّ وأَوْلَادُو والغْنَمْ مْتَاعُو؟» ");
INSERT INTO aeu_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","جَاوِبْهَا يَسُوعْ: «كُلْ وَاحِدْ يُشْرُبْ مِالمَاء هَاذَا يْزِيدْ يُعْطِشْ مَرَّة أُخْرَى، ");
INSERT INTO aeu_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","آمَا الِّي يُشْرُبْ مِالمَاء الِّي نَعْطِيهُولُو آنَا، عُمْرُو مَا عَادْ يُعْطِشْ. المَاء الِّي نَعْطِيهُولُو، يْوَلِّي فِيهْ مِنْ دَاخِلْ عِينْ تْفِيضْ وتَعْطِي الحَيَاةْ الأَبَدِيَّة». ");
INSERT INTO aeu_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","قَالِتْلُو المْرَا: «يَا سِيدِي، أَعْطِينِي مِالمَاء هَاذَا، بَاشْ مَا عَادِشْ نُعْطِشْ، ومَا عَادِشْ نِرْجَعْ نْعَبِّي المَاء مِنْ هْنَا». ");
INSERT INTO aeu_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","قَالِلْهَا: «إِمْشِي عَيِّطْ لْرَاجْلِكْ وإِرْجَعْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","جَاوْبِتُّو المْرَا: «مَا عَنْدِيشْ رَاجِلْ». قَالِلْهَا يَسُوعْ: «قُلْتْ الحَقْ وَقْتِلِّي قُلْتْ \"مَا عَنْدِيشْ رَاجِلْ\"، ");
INSERT INTO aeu_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","عْلَى خَاطِرْ عَرِّسْتْ بْخَمْسَة رْجَالْ، والرَّاجِلْ الِّي عَايْشَة مْعَاهْ تَوَّا مُشْ رَاجْلِكْ. كْلَامِكْ صْحِيحْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","قَالِتْلُوا المْرَا: «يَا سِيدِي، يُظْهُرْلِي فِيكْ نَبِيْ! ");
INSERT INTO aeu_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","جْدُودْنَا عِبْدُوا اللَّهْ فِي الجْبَلْ هَاذَا، وإِنْتُومَا اليْهُودْ تْقُولُوا الِّي لَازِمْ النَّاسْ يِعْبْدُوهْ فِي أُورْشَلِيمْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","جَاوِبْهَا يَسُوعْ: «صَدَّقْنِي يَا مْرَا، بِشْ يْجِي وَقْتْ تِعْبْدُوا فِيهْ الآبْ، لَا فِي الجْبَلْ هَاذَا ولَا فِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","إِنْتُومَا السَّامِرِيِّينْ تِعْبْدُوا فِلِّي مَا تَعْرْفُوهِشْ، وأَحْنَا اليْهُودْ نِعْبْدُوا فِلِّي نَعْرْفُوهْ. عْلَى خَاطِرْ النْجَاةْ تْجِي مِنْ عَنْدْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","آمَا بِشْ يْجِي وَقْتْ ورَاهُو تَوَّا جَاء، الِّي فِيهْ النَّاسْ الِّي يِعْبْدُوا بِحْقِيقَة بِشْ يِعْبْدُوا الآبْ بِالرُّوحْ والحَقْ. والآبْ يْلَوِّجْ عْلَى نَاسْ كِيمَا هَاذُومَا. ");
INSERT INTO aeu_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","اللَّهْ رُوحْ. هَاذَاكَا عْلَاشْ الِّي يِعْبْدُوهْ، لَازِمْهُمْ يِعْبْدُوهْ بِالرُّوحْ وبِالحَقْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","قَالِتْلُو المْرَا: «آنَا نَعْرِفْ الِّي المَسِيَّا، الِّي يْقُولُولُو المَسِيحْ، بِشْ يْجِي. ووَقْتِلِّي يْجِي بِشْ يْقُولِلْنَا عْلَى كُلْ شَيْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","قَالِلْهَا يَسُوعْ: «آنَا هُوَّ، آنَا الِّي قَاعِدْ نْكَلِّمْ فِيكْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","وفِي الوَقْتْ هَاذَاكَا، رَجْعُوا تْلَامِذْتُو وتْعَجْبُوا كِي لْقَاوَهْ يَحْكِي مْعَ مْرَا. آمَا حَتَّى حَدْ مِنْهُمْ مَا قَالُّو: «آشْ تْحِبْ مِنْهَا؟» وَلَّا «عْلَاشْ تْكَلِّمْ فِيهَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","يَاخِي المْرَا خَلَّاتْ قُلِّتْهَا، ورَجْعِتْ لِلْمْدِينَة، وقَالِتْ لِلنَّاسْ: ");
INSERT INTO aeu_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«إِيجَاوْ شُوفُوا رَاجِلْ قَلِّي عَلِّي عْمَلْتُو الكُلْ. زَعْمَة يْكُونِشْ هُوَّ المَسِيحْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","وَلَّاوْ خَرْجُوا مِالمْدِينَة ومْشَاوْلُو. ");
INSERT INTO aeu_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","وفِي الوَقْتْ هَاذَاكَا، قَالُولُو تْلَامِذْتُو: «يَا مُعَلِّمْ، كُولْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","آمَا هُوَّ قَالِلْهُمْ: «آنَا عَنْدِي مَاكْلَة نَاكِلْهَا، إِنْتُومَا مَا تَعْرْفُوهَاشْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","بْدَاوْ التْلَامْذَة يِسْأْلُوا فِي بْعَضْهُمْ: «يَاخِي فَمَّة شْكُونْ جَابْلُو مَاكْلَة؟» ");
INSERT INTO aeu_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","وقَالِلْهُمْ يَسُوعْ: «مَاكِلْتِي هِيَّ إِنِّي نَعْمِلْ آشْ يْحِبْ الِّي بْعَثْنِي، ونْكَمِّلْ خِدْمْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","يَاخِي مُشْ تْقُولُوا: \"الحْصَادْ يْجِي بَعْدْ أَرْبْعَة شْهُرْ؟\" آمَا آنَا نْقُلْكُمْ، حِلُّوا عِينِيكُمْ وشُوفُوا الزَّرْعْ كِيفَاشْ بْيَاضْ وحْضَرْ لِلْحْصَادْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","وبْدَا الِّي يَحْصِدْ يَاخُذْ فِي أُجْرْتُو، ويْلِمْ صَابَة لِلْحَيَاةْ الأَبَدِيَّة، وهَكَّا الِّي يَزْرَعْ ولِّي يَحْصِدْ يِفْرْحُوا مْعَ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ويُصْدُقْ المَثَلْ الِّي يْقُولْ: \"وَاحِدْ يَزْرَعْ والآخِرْ يَحْصِدْ\". ");
INSERT INTO aeu_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","وآنَا بْعَثْتْكُمْ تَحْصْدُوا زَرْعْ مَا تْعِبْتُوشْ عْلِيهْ. غِيرْكُمْ تْعِبْ وإِنْتُومَا تِسْتَنْفْعُوا مِنْ تْعَبْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","وأَمْنُوا بِيهْ بَرْشَة سَامِرِيِّينْ مِالمْدِينَة هَاذِيكَا، عْلَى خَاطِرْ المْرَا شِهْدِتْلُو وقَالِتْ: «قَالِّي عَلِّي عْمَلْتُو الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ووَقْتِلِّي جَاوَهْ السَّامِرِيِّينْ، لَحُّوا عْلِيهْ بَاشْ يُقْعُدْ بَحْذَاهُمْ. يَاخِي قْعَدْ عَنْدْهُمْ نْهَارِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","وزَادُوا كُثْرُوا الِّي أَمْنُوا بِيهْ وَقْتِلِّي سَمْعُوهْ يِتْكَلِّمْ، ");
INSERT INTO aeu_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","وقَالُوا لِلْمْرَا: «أَحْنَا تَوَّا نَمْنُوا بِيهْ، مُشْ عْلَى خَاطِرْ كْلَامِكْ، آمَا عْلَى خَاطِرْ أَحْنَا بِيدْنَا سْمَعْنَاهْ، وعْرَفْنَا إِنُّو بِالحَقْ هُوَّ الِّي يْنَجِّي العَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","وبَعْدْ نْهَارِينْ، مْشَى يَسُوعْ لْمَنْطَقْةْ الجَلِيلْ، ");
INSERT INTO aeu_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","رَغْمِلِّي هُوَّ بِيدُو قَالْ: «حَتَّى نَبِيْ مَا عَنْدُو قْدَرْ فِي بْلَادُو». ");
INSERT INTO aeu_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","وَقْتِلِّي وْصُلْ لِلْجَلِيلْ، رَحْبُوا بِيهْ إِمَّالِيهَا، عْلَى خَاطِرْهُمْ شَافُوا الِّي عْمَلُو الكُلْ، وَقْتِلِّي كَانُوا فِي أُورْشَلِيمْ فِي عِيدْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ومْشَى مَرَّة أُخْرَى لْقَانَا فِي الجَلِيلْ، وِينْ بَدَّلْ المَاء لِشْرَابْ. وكَانْ فَمَّة فِي كَفْرْنَاحُومْ، رَاجِلْ تَابَعْ المَلِكْ، وِلْدُو مْرِيضْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","وَقْتِلِّي سْمَعْ الِّي يَسُوعْ جَاء مِاليَهُودِيَّة لِلْجَلِيلْ، مْشَالُو وطْلَبْ مِنُّو بَاشْ يِمْشِي مْعَاهْ ويِشْفِيلُو وِلْدُو، الِّي كَانْ قْرِيبْ يْمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","قَالُّو يَسُوعْ: «إِنْتُومَا مَا تَمْنُوا كَانْ مَا تْشُوفُوا عْجَايِبْ ومُعْجْزَاتْ!». ");
INSERT INTO aeu_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","قَالُّو الرَّاجِلْ: «يَا سِيدِي، إِيجَا مْعَايَا قْبَلْ مَا وِلْدِي يْمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","قَالُّو يَسُوعْ: «إِمْشِي! رَاهُو وِلْدِكْ حَيْ». صَدِّقْ الرَّاجِلْ الكِلْمَة الِّي قَالْهَالُو يَسُوعْ ومْشَى. ");
INSERT INTO aeu_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","وهُوَّ رَاجِعْ، عُرْضُوهْ الخُدَّامْ مْتَاعُو وبَشْرُوهْ بِلِّي وِلْدُو حَيْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","سْإِلْهُمْ: «وَقْتَاشْ بْرَا؟» قَالُولُو: «تْنَحَّاتْ عْلِيهْ السْخَانَة البَارِحْ مْعَ مَاضِي سَاعَة». ");
INSERT INTO aeu_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","وفْهِمْ البُو الِّي هَاذَاكَا نَفْسْ الوَقْتْ الِّي قَالُّو فِيهْ يَسُوعْ: «وِلْدِكْ حَيْ»، يَاخِي أَمَّنْ هُوَّ وعَايِلْتُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","وهَاذِي المُعْجْزَة الثَّانْيَة الِّي عْمَلْهَا يَسُوعْ، وَقْتِلِّي مْشَى مِاليَهُودِيَّة لِلْجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ومْبَعْدْهَا، جَاء عِيدْ مِنْ أَعْيَادْ اليْهُودْ، يَاخِي طْلَعْ يَسُوعْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","وفِي المْدِينَة هَاذِيكَا كَانِتْ فَمَّة جَابْيَة، بَحْذَا بَابْ الغْنَمْ، دَايِرْ بِيهَا خَمْسَة أَقْوَاسْ، ويْسَمِّيوْهَا بِالعِبْرِيَّة «بِيتْ حَسْدَا». ");
INSERT INTO aeu_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","وكَانُوا جْمَاعَة عِمْيَانْ وعِيَّابْ ومُعَاقِينْ، مَمْدُودِينْ تَحْتْ الأَقْوَاسْ، يِسْتَنَّاوْ حَتَّى المَاء يِتْحَرِّكْ، ");
INSERT INTO aeu_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","عْلَى خَاطِرْ كَانْ فَمَّة مَلَاكْ يْجِي سَاعَة سَاعَة ويْحَرِّكْ المَاءْ، ولِّي يَهْبِطْ فِيهْ الأُوِّلْ، يِتْشْفَى مَهْمَا كَانْ مَرْضُو. ");
INSERT INTO aeu_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","وكَانْ فَمَّة رَاجِلْ لِيهْ 38 سْنَة مْرِيضْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","وَقْتِلِّي شَافُو يَسُوعْ مَمْدُودْ، عْرَفْ الِّي عَنْدُو مُدَّة طْوِيلَة عَالحَالَة هَاذِيكَا، يَاخِي قَالُّو: «تْحِبِّشْ تَبْرَى؟». ");
INSERT INTO aeu_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","جَاوْبُو المْرِيضْ: « يَا سِيدِي، مَا عَنْدِيشْ شْكُونْ يَرْمِينِي فِي الجَابْيَة وَقْتِلِّي يِتْحَرِّكْ المَاء. وكُلْ مَا نْحَاوِلْ نَهْبِطْ، غِيرِي يِسْبِقْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","قَالُّو يَسُوعْ: «قُومْ هِزْ فَرْشِكْ وإِمْشِي». ");
INSERT INTO aeu_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","وبِالوَقْتْ، تِشْفَى الرَّاجِلْ، وهَزْ فَرْشُو ومْشَى. وكَانْ نْهَارِتْهَا نْهَارْ السِّبْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","قَالُوا اليْهُودْ لِلرَّاجِلْ الِّي تِشْفَى: «اليُومْ سِبْتْ. مَا عَنْدِكْشْ الحَقْ تْهِزْ فَرْشِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","جَاوِبْهُمْ: «الِّي شْفَانِي هُوَّ الِّي قَلِّي: هِزْ فَرْشِكْ وإِمْشِي». ");
INSERT INTO aeu_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","يَاخِي سِأْلُوهْ: «شْكُونُو الِّي قَلِّكْ هِزْ فَرْشِكْ وإِمْشِي؟». ");
INSERT INTO aeu_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","والرَّاجِلْ الِّي تِشْفَى مَا كَانِشْ يَعْرِفْ شْكُونْ الِّي شْفَاهْ، عْلَى خَاطِرْ يَسُوعْ بْعِدْ، وضَاعْ عْلِيهْ فِي وِسْطْ النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","مْبَعِّدْ، لْقَاهْ يَسُوعْ فِي الهَيْكِلْ وقَالُّو: «هَاكْ بْرِيتْ، مَالَا مَا تِرْجَعْشْ لِلذْنُوبْ، بَاشْ مَا يْصِيرْلِكْشْ مَا أَتْعِسْ». ");
INSERT INTO aeu_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","مْشَى الرَّاجِلْ وقَالْ لِلْيْهُودْ الِّي يَسُوعْ هُوَّ الِّي شْفَاهْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","يَاخِي بْدَاوْ اليْهُودْ يِضْطَهْدُوا فِي يَسُوعْ عْلَى خَاطْرُو عْمَلْ هَاذَا نْهَارْ السِّبْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","قَالِلْهُمْ يَسُوعْ: «مَزَّالْ بَابَا يِخْدِمْ حَتَّى لْتَوَّا، وآنَا زَادَا قَاعِدْ نِخْدِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","هَاذَاكَا عْلَاشْ اليْهُودْ شَدُّوا صْحِيحْ يْحِبُّوا يُقْتْلُوهْ، مُشْ عْلَى خَاطْرُو خَالِفْ وْصِيِّةْ السِّبْتْ بَرْكْ، آمَا زَادَا عْلَى خَاطْرُو قَالْ الِّي اللَّهْ بُوهْ، وهَكَّا سَاوَى رُوحُو بِاللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","قَالِلْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: الإِبْنْ مَا يْنَجِّمْ يَعْمِلْ حَتَّى شَيْ مِنْ رَاسُو، آمَا يَعْمِلْ الِّي يْشُوفْ الآبْ يَعْمِلْ فِيهْ. الِّي يَعْمْلُو الآبْ الكُلْ يَعْمْلُو الإِبْنْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","عْلَى خَاطِرْ الآبْ يْحِبْ الإِبْنْ، ويْوَرِّيهْ الِّي يَعْمْلُو الكُلْ، وبِشْ يْوَرِّيهْ حَاجَاتْ أَعْظَمْ مِنْ هَاذِي، وإِنْتُومَا بِشْ تِتْعَجْبُوا. ");
INSERT INTO aeu_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","وكِيمَا الآبْ يْقَوِّمْ المُوتَى ويِحْيِيهُمْ، الإِبْنْ زَادَا يِحْيِي الِّي يْحِبْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","الآبْ مَا يُحْكُمْ عْلَى حَتَّى حَدْ، آمَا عْطَى الحُكْمْ الكُلُّو لِلْإِبْنْ، ");
INSERT INTO aeu_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","بَاشْ النَّاسْ الكُلْ يِكْرْمُوا الإِبْنْ، كِيفْ مَا يِكْرْمُوا الآبْ. ولِّي مَا يِكْرِمْشْ الإِبْنْ، مَا يِكْرِمْشْ الآبْ الِّي بَعْثُو. ");
INSERT INTO aeu_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","«الحَقْ الحَقْ نْقُلْكُمْ: الِّي يِسْمَعْ كْلَامِي ويْأَمِّنْ بِلِّي بْعَثْنِي عَنْدُو الحَيَاةْ الأَبَدِيَّة، ومَا يِتْعَاقِبْشْ فِي يُومْ الحْسَابْ، عْلَى خَاطِرْ تْعَدَّى مِالمُوتْ لِلْحَيَاةْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","الحَقْ الحَقْ نْقُلْكُمْ: بَاشْ يْجِي وَقْتْ، ورَاهُو تَوَّا جَاء، الِّي فِيهْ المُوتَى يِسْمْعُوا صُوتْ إِبْنْ اللَّهْ، ولِّي يِسْمْعُوهْ يَحْيَاوْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","وكِيمَا الآبْ هُوَّ مَصْدَرْ الحَيَاةْ، عْطَى لِلْإِبْنْ بَاشْ يْكُونْ هُوَّ زَادَا مَصْدَرْ الحَيَاةْ، ");
INSERT INTO aeu_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","وعْطَاهْ السُّلْطَة بَاشْ يُحْكُمْ عْلَى خَاطْرُو إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","مَا تِسْتَغْرْبُوشْ مِنْ هَاذَا، عْلَى خَاطِرْ بِشْ يْجِي وَقْتْ، يِسْمْعُوا فِيهْ صُوتُو الِّي فِي القْبُورَاتْ الكُلْ ");
INSERT INTO aeu_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ويُخْرْجُوا مِنْهَا: العَامْلِينْ الخِيرْ يْقُومُوا لِلْحَيَاةْ، والعَامْلِينْ الشَّرْ يْقُومُوا بَاشْ يِتْحَاسْبُوا. ");
INSERT INTO aeu_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","مَا انَّجِّمْ نَعْمِلْ حَتَّى شَيْ مِنْ رَاسِي. آنَا نْحَاسِبْ كِيمَا يْقُلِّي الآبْ. وحُكْمِي عَادِلْ عْلَى خَاطِرْنِي مَانِيشْ نَسْعَى بَاشْ نْحَقِّقْ مَشِيئْتِي، آمَا مَشِيئِةْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«كَانْ نِشْهِدْ لْرُوحِي، رَاهِي شْهَادْتِي بَاطْلَة. ");
INSERT INTO aeu_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","آمَا فَمَّة شْكُونْ آخِرْ يِشْهِدْلِي، وآنَا نَعْرِفْ الِّي شْهَادْتُو صْحِيحَة. ");
INSERT INTO aeu_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","إِنْتُومَا بْعَثْتُوا نَاسْ لْيُوحَنَّا، وهُوَّ شْهِدْ لِلْحَقْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","آنَا مَا نِحْتَاجِشْ لِشْهَادِةْ بَشَرْ، آمَا نْقُلْكُمْ فِي الكْلَامْ هَاذَا بَاشْ تِنْجَاوْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","يُوحَنَّا كَانْ فْنَارْ يِشْعِلْ ويِضْوِي وإِنْتُومَا حَبِّيتُوا تِفْرْحُوا بِالنُّورْ مْتَاعُو شْوَيَّة وَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","آمَا آنَا عَنْدِي شْهَادَة أَعْظَمْ مِنْ شْهَادِةْ يُوحَنَّا: الأَعْمَالْ الِّي كَلَّفْنِي بِيهَا الآبْ، ولِّي قَاعِدْ نَعْمِلْ فِيهَا، هِيَّ تِشْهِدْ الِّي الآبْ بْعَثْنِي، ");
INSERT INTO aeu_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","والآبْ الِّي بْعَثْنِي هُوَّ بِيدُو يِشْهِدْلِي. وإِنْتُومَا عْمُرْكُمْ لَا سْمَعْتُوا صُوتُو، ولَا شُفْتُوا وِجْهُو، ");
INSERT INTO aeu_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","وكْلَامُو مَا يِثْبِتْشْ فِيكُمْ، عْلَى خَاطِرْكُمْ مَا تْأَمْنُوشْ بِلِّي بَعْثُو. ");
INSERT INTO aeu_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","تْثَبْتُوا فِي الكْتُبْ المُقَدْسَة، مَاشِي فِي بَالْكُمْ بِشْ تَلْقَاوْ فِيهَا الحَيَاةْ الأَبَدِيَّة، والكْتُبْ هَاذِي بِيدْهَا تِشْهِدْلِي، ");
INSERT INTO aeu_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","آمَا إِنْتُومَا، مَا تْحِبُّوشْ تْجِيوْنِي بَاشْ تَاخْذُوا الحَيَاةْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","«آنَا مَا نِحْتَاجِشْ لْمَجْدْ مِنْ عَنْدْ النَّاسْ، ");
INSERT INTO aeu_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","آمَا آنَا نَعْرِفْكُمْ، ونَعْرِفْ الِّي مْحَبِّةْ اللَّهْ مَاهِيشْ فِي قْلُوبْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","آنَا جِيتْ بْإِسْمْ بَابَا، ومَا قْبِلْتُونِيشْ. وكَانْ وَاحِدْ آخَرْ يْجِيكُمْ بْإِسْمْ رُوحُو، تِقْبْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","وكِيفَاشْ تْنَجْمُوا تَمْنُوا وإِنْتُومَا تِسْتَنَّاوْ بَاشْ تَاخْذُوا المَجْدْ مِنْ عَنْدْ بْعَضْكُمْ، ومَا تُطْلْبُوشْ المَجْدْ الِّي يَعْطِيهْ اللَّهْ وَحْدُو؟ ");
INSERT INTO aeu_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","مَا يِمْشِيشْ فِي بَالْكُمْ الِّي آنَا نِشْكِي بِيكُمْ لِلْآبْ. الِّي يِشْكِي بِيكُمْ هُوَّ مُوسَى الِّي حَاطِّينْ فِيهْ رْجَاكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","وكَانْ جِيتُوا صَدَّقْتُوا مُوسَى رَاكُمْ صَدَّقْتُونِي، عْلَى خَاطْرُو هُوَّ كْتِبْ عْلِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","وإِذَا كَانْ مَا تْصَدْقُوشْ الِّي كِتْبُو عْلِيَّا، مَالَا كِيفَاشْ بِشْ تْصَدْقُوا كْلَامِي؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","وبَعْدْهَا شَقْ يَسُوعْ بُحَيْرِةْ الجَلِيلْ، الِّي يْسَمِّيوْهَا بُحَيْرِةْ طَبَرِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","وتَبْعُوهْ بَرْشَة نَاسْ، عْلَى خَاطِرْهُمْ شَافُوا مُعْجْزَاتُو كِي شْفَى المُرْضَى. ");
INSERT INTO aeu_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","يَاخِي طْلَعْ يَسُوعْ لِلجْبَلْ مْعَ تْلَامِذْتُو وقَعْدُوا. ");
INSERT INTO aeu_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ووَقْتْهَا قْرُبْ عِيدْ الفِصْحْ مْتَاعْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","هَزْ يَسُوعْ عِينِيهْ وشَافْ بَرْشَة نَاسْ جَايِينُوا، يَاخِي قَالْ لْفِيلِۑُّسْ: «مْنِينْ نِشْرِيوْلْهُمْ خُبْزْ بَاشْ يَاكْلُوا؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","قَالْ الكْلَامْ هَاذَا بَاشْ يْجَرَّبْ فِيلِۑُّسْ، آمَا هُوَّ كَانْ يَعْرِفْ رُوحُو آشْ بِشْ يَعْمِلْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","جَاوْبُو فِيلِۑُّسْ: «حَتَّى كَانْ نِشْرِيوْ خُبْزْ بِفْلُوسْ ثْمَنْيَة شْهُورْ خِدْمَة، هَاذَا مَا يِكْفِيشْ بَاشْ كُلْ وَاحِدْ مِنْهُمْ يَاخِذْ ڨِدْمَة صْغِيرَة!» ");
INSERT INTO aeu_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","قَالُّو أَنْدَرَاوُسْ، خُو سِمْعَانْ بُطْرُسْ، الِّي هُوَّ وَاحِدْ مِنْ تْلَامِذْتُو: ");
INSERT INTO aeu_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«هَاوْ فَمَّة وْلَيِّدْ عَنْدُو خَمْسَة خُبْزَاتْ شْعِيرْ وحُوتِّينْ: آمَا آشْ يْنَجْمُوا يَعْمْلُوا لِلنَّاسْ هَاذُومَا الكُلْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","وكَانْ فَمَّة بَرْشَة حْشِيشْ فِي البُقْعَة هَاذِيكَا، يَاخِي قَالْ يَسُوعْ: «قَعّْدُوا النَّاسْ!»، وَلَّاوْ قَعْدُوا، وكَانُوا وقْتْهَا 5 000 رَاجِلْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","خْذَا يَسُوعْ الخُبْزَاتْ وشْكَرْ اللَّهْ، وعْطَى لِلْمَوجُودِينْ الكُلْ قَدْ مَا حَبُّوا. وعْمَلْ نَفْسْ الشَّيْ بِالحُوتِّينْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ووَقْتِلِّي شَبْعُوا، قَالْ لِتْلَامِذْتُو: «لِمُّوا الِّي فْضُلْ الكُلْ بَاشْ مَا يْضِيعْ مِنُّو حَتَّى شَيْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","وَلَّاوْ لَمُّوهْ، وعَبَّاوْ أَثْنَاشِنْ قُفَّة بِالخُبْزْ الِّي فْضُلْ بَعْدْمَا كْلَاوْ النَّاسْ مِالخَمْسَة خُبْزَاتْ شْعِيرْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ووَقْتِلِّي شَافُوا النَّاسْ المُعْجْزَة الِّي عْمَلْهَا يَسُوعْ قَالُوا: «بِالحَقْ، هَاذَا هُوَّ النَّبِيْ الِّي جَايْ لِلْعَالِمْ!» ");
INSERT INTO aeu_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","وعْرَفْ يَسُوعْ الِّي هُومَا يْحِبُّوا يَخْطْفُوهْ ويْنَصْبُوهْ مَلِكْ، يَاخِي بْعِدْ عْلِيهُمْ ورْجَعْ وَحْدُو لِلجْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ومْعَ المُغْرُبْ، هَبْطُوا تْلَامِذْتُو لِلْبُحَيْرَة، ");
INSERT INTO aeu_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ورِكْبُوا فِي فْلُوكَة، قَاصْدِينْ مْدِينِةْ كَفْرْنَاحُومْ فِي الشِّيرَة الأُخْرَى مْتَاعْ البُحَيْرَة. وظْلَامِتْ الدِّنْيَا ويَسُوعْ مَزَّالْ مَا خْلَطْشْ عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","وهَبِّتْ رِيحْ قْوِيَّة، هَيْجِتْ البُحَيْرَة. ");
INSERT INTO aeu_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","وبَعْدْمَا بِعْدُوا فِي البُحَيْرَة خَمْسَة وَلَّا سِتَّة كِيلُومِيتْرَاتْ، شَافُوا يَسُوعْ يُقْرُبْ لِلْفْلُوكَة وهُوَّ مَاشِي فُوقْ المَاء، يَاخِي خَافُوا. ");
INSERT INTO aeu_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","آمَا هُوَّ قَالِلْهُمْ: «آنَا هُوَّ، مَا تْخَافُوشْ!». ");
INSERT INTO aeu_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","وحَبُّوا يْطَلْعُوهْ مْعَاهُمْ فِي الفْلُوكَة، آمَا بِالوَقْتْ وِصْلِتْ الفْلُوكَة لِلْبْلَاصَة الِّي كَانُوا مَاشِينْ لِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ومِنْ غُدْوَة، النَّاسْ الِّي قَعْدُوا فِي الشِّيرَة الأُخْرَى مْتَاعْ البُحَيْرَة، تْذَكْرُوا الِّي هُومَا شَافُوا فْلُوكَة وَحْدَة، ولِّي يَسُوعْ مَا طْلَعْشْ فِيهَا مْعَ تْلَامِذْتُو، ولِّي تْلَامِذْتُو مْشَاوْ وَحَّدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","وجَاوْ فْلَايِكْ أُخْرِينْ مِنْ طَبَرِيَّة، لِلشَّطْ الِّي قْرِيبْ مِالبْلَاصَة الِّي كْلَاوْ فِيهَا الخُبْزْ، بَعْدْمَا الرَّبْ يَسُوعْ شْكَرْ اللَّهْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","وَقْتِلِّي شَافُوا النَّاسْ الِّي لَا يَسُوعْ ولَا تْلَامِذْتُو مَوْجُودِينْ غَادِي، وَلَّاوْ رِكْبُوا فِي الفْلَايِكْ ومْشَاوْ لْكَفْرْنَاحُومْ يْلَوْجُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","وكِي لْقَاوِهْ فِي الشِّيرَة الأُخْرَى مْتَاعْ البُحَيْرَة قَالُولُو: «يَا مُعَلِّمْ، وَقْتَاشْ وْصِلْتْ لَهْنَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","جَاوِبْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: إِنْتُومَا تْلَوْجُوا عْلِيَّا، مُشْ عْلَى خَاطِرْكُمْ شُفْتُوا مُعْجْزَاتْ، آمَا عْلَى خَاطِرْكُمْ كْلِيتُوا مِالخُبْزْ وشْبَعْتُوا. ");
INSERT INTO aeu_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","إِسْعَاوْ وْرَاء المَاكْلَة الِّي تْدُومْ لِلْحَيَاةْ الأَبَدِيَّة، مُشْ وْرَاء المَاكْلَة الِّي تِفْنَى. المَاكْلَة هَاذِي يَعْطِيهَالْكُمْ إِبْنْ الإِنْسَانْ الِّي خِتْمُو اللَّهْ الآبْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","قَالُولُو: «شْنُوَّة الِّي يْحِبْنَا اللَّهْ نَعْمْلُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","جَاوِبْهُمْ يَسُوعْ: «الِّي يُطْلْبُو مِنْكُمْ اللَّهْ هُوَّ إِنْكُمْ تَمْنُوا بِلِّي بَعْثُو». ");
INSERT INTO aeu_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","قَالُولُو: «شْنِيَّة المُعْجْزَة الِّي تَعْمِلْهَا بَاشْ نْشُوفُوهَا ونَمْنُوا بِيكْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","جْدُودْنَا كْلَاوْ المَنْ فِي الصَّحْرَاء، كِيمَا تْقُولْ الكْتُبْ المُقَدْسَة: \"عْطَاهُمْ خُبْزْ مِالسْمَاء بَاشْ يَاكْلُوا\"». ");
INSERT INTO aeu_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","يَاخِي قَالِلْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: مُشْ مُوسَى الِّي عْطَاكُمْ الخُبْزْ مِالسْمَاء، آمَا بَابَا هُوَّ الِّي يَعْطِيكُمْ الخُبْزْ الحَقِيقِي مِالسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","عْلَى خَاطِرْ خُبْزْ اللَّهْ هُوَّ الِّي يَهْبِطْ مِالسْمَاء ويَعْطِي الحَيَاةْ لِلنَّاسْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","قَالُولُو: «يَا سِيدْنَا، دِيمَا أَعْطِينَا مِالخُبْزْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","قَالِلْهُمْ يَسُوعْ: «آنَا هُوَّ خُبْزْ الحَيَاةْ. الِّي يْجِينِي عُمْرُو مَا يْجُوعْ، ولِّي يَمِّنْ بِيَّا عُمْرُو مَا يُعْطِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","آمَا آنَا قُلْتِلْكُمْ: إِنْتُومَا شُفْتُونِي، آمَا مَا تْأَمْنُوشْ بِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","الِّي يَعْطِيهُمْلِي الآبْ الكُلْهُمْ يْجِيوْنِي، ولِّي يْجِينِي عُمْرِي مَا نْطَرْدُو. ");
INSERT INTO aeu_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","رَانِي مَا هْبَطِّشْ مِالسْمَاء بَاشْ نَعْمِلْ الِّي نْحِبْ عْلِيهْ آنَا، آمَا بَاشْ نَعْمِلْ الِّي يْحِبْ عْلِيهْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ولِّي بْعَثْنِي، يْحِبْنِي مَا نْضَيَّعْ حَتَّى وَاحِدْ مِلِّي عْطَاهُمْلِي، آمَا نْقَيِّمْهُمْ مِالمُوتْ فِي نْهَارْ الحْسَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","وهَاذَا آشْ يْحِبْ بَابَا: كُلْ وَاحِدْ يْشُوفْ الإِبْنْ ويْأَمِّنْ بِيهْ يَاخُو الحَيَاةْ الأَبَدِيَّة. وآنَا نْقَيْمُو مِالمُوتْ فِي نْهَارْ الحْسَابْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","وتْشَكَّاوْ اليْهُودْ عْلَى يَسُوعْ عْلَى خَاطْرُو قَالْ: «آنَا هُوَّ الخُبْزْ الِّي هْبَطْ مِالسْمَاء». ");
INSERT INTO aeu_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","وقَالُوا: «يَاخِي مُشْ هَاذَا يَسُوعْ وِلْدْ يُوسِفْ؟ أَحْنَا نَعْرْفُوا بُوهْ وأُمُّو، مَالَا كِيفَاشْ يْقُولْ الِّي هُوَّ هْبَطْ مِالسْمَاء؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","جَاوِبْهُمْ يَسُوعْ: «مَا تِتْشَكَّاوِشْ بِينْ بْعَضْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","حَتَّى حَدْ مَا يْنَجِّمْ يْجِينِي إِلَّا إِذَا كَانْ الآبْ الِّي بْعَثْنِي يِجْبْدُو، وآنَا نْقَوْمُو مِالمُوتْ فِي نْهَارْ الحْسَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","مَكْتُوبْ فِي كْتُبْ الأَنْبِيَاءْ: \"النَّاسْ الكُلْ بِشْ يِتْعَلْمُوا مِنْ اللَّهْ\". وكُلْ الِّي يِسْمَعْ الآبْ ويِتْعَلِّمْ مِنُّو، يْجِينِي. ");
INSERT INTO aeu_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","حَتَّى حَدْ مَا شَافْ الآبْ كَانْ الِّي جَاء مِنْ عَنْدْ اللَّهْ: هَاذَاكَا الوَحِيدْ الِّي شَافْ الآبْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","الحَقْ الحَقْ نْقُلْكُمْ: الِّي يَمِّنْ بِيَّا، عَنْدُو الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","آنَا هُوَّ خُبْزْ الحَيَاةْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","جْدُودْكُمْ كْلَاوْ المَنْ فِي الصَّحْرَاء، ورَغْمْ هَاذَاكَا مَاتُوا، ");
INSERT INTO aeu_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","آمَا الِّي يَاكِلْ الخُبْزْ الِّي هْبَطْ مِالسْمَاء، مَا يْمُوتِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","آنَا هُوَّ الخُبْزْ الحَيْ الِّي هْبَطْ مِالسْمَاء. الِّي يَاكِلْ مِالخُبْزْ هَاذَا يَحْيَا لِلْأَبَدْ. والخُبْزْ هَاذَا هُوَّ بْدَنِي، الِّي نَعْطِيهْ بَاشْ النَّاسْ يَحْيَاوْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","وتْعَارْكُوا اليْهُودْ بِينْ بْعَضْهُمْ وقَالُوا: «كِيفَاشْ يْنَجِّمْ الرَّاجِلْ هَاذَا يَعْطِينَا بْدْنُو بَاشْ نَاكْلُوهْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","يَاخِي جَاوِبْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: إِذَا مَا تَاكْلُوشْ بْدَنْ إِبْنْ الإِنْسَانْ ومَا تُشْرْبُوشْ دَمُّو، مُشْ بَاشْ تْكُونْ فِيكُمْ الحَيَاةْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","الِّي يَاكِلْ بَدْنِي ويُشْرُبْ دَمِّي عَنْدُو الحَيَاةْ الأَبَدِيَّة، وآنَا نْقَوْمُو مِالمُوتْ فِي نْهَارْ الحْسَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","عْلَى خَاطِرْ بَدْنِي هُوَّ المَاكْلَة الحَقِيقِيَّة، ودَمِّي هُوَّ الشْرَابْ الحَقِيقِي. ");
INSERT INTO aeu_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","الِّي يَاكِلْ مِنْ بَدْنِي ويُشْرُبْ مِنْ دَمِّي، يِثْبِتْ فِيَّا، وآنَا نِثْبِتْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","وكِيمَا الآبْ الِّي هُوَّ حَيْ بْعَثْنِي وآنَا نَحْيَا بِيهْ، الِّي يَاكِلْنِي زَادَا يَحْيَا بِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","هَاذَا هُوَّ الخُبْزْ الِّي هْبَطْ مِالسْمَاء، ورَاهُو مُشْ كِيفْ المَنْ الِّي كْلَاوَهْ جْدُودْكُمْ ومَاتُوا. الِّي يَاكِلْ مِالخُبْزْ هَاذَا يَحْيَا لِلْأَبَدْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","قَالْ يَسُوعْ الكْلَامْ هَاذَا وَقْتِلِّي كَانْ يْعَلِّمْ فِي مَعْبِدْ اليْهُودْ فِي كَفْرْنَاحُومْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","وَقْتِلِّي سَمْعُوهْ، بَرْشَة مِنْ تْلَامِذْتُو قَالُوا: «مَا اصْعْبُو الكْلَامْ هَاذَا، شْكُونْ يْنَجِّمْ يِقْبْلُو؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","وعْرَفْ يَسُوعْ فِي قَلْبُو الِّي تْلَامِذْتُو يِتْشَكَّاوْ، وَلَّى سْإِلْهُمْ: «يَاخِي صْدَمْكُمْ الكْلَامْ هَاذَا؟ ");
INSERT INTO aeu_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","مَالَا آشْ بِشْ تَعْمْلُوا كَانْ تْشُوفُوا إِبْنْ الإِنْسَانْ طَالِعْ لْفِينْ كَانْ قْبَلْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","الرُّوحْ هُوَّ الِّي يَعْطِي الحَيَاةْ، آمَا الإِنْسَانْ وَحْدُو مَا يِنْفَعْ لْحَتَّى شَيْ. والكْلَامْ الِّي قُلْتْهُولْكُمْ رَاهُو رُوحْ وحَيَاةْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","آمَا فِيكُمْ الِّي مَا يْأَمْنُوشْ». قَالْ يَسُوعْ هَاذَا عْلَى خَاطْرُو كَانْ يَعْرِفْ مِالأُوِّلْ شْكُونْهُمْ الِّي مَا يْأَمْنُوشْ بِيهْ، وشْكُونُو الِّي بِشْ يْخُونُو. ");
INSERT INTO aeu_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","وقَالْ: «هَاذَاكَا عْلَاشْ قُلْتِلْكُمْ: مَا يْنَجِّمْ حَتَّى حَدْ يْجِينِي إِلَّا إِذَا كَانْ الآبْ خَلَّاهْ يْجِينِي». ");
INSERT INTO aeu_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","مِنْ وَقْتْهَا، بَرْشَة مِنْ تْلَامِذْتُو خَلَّاوَهْ وبَطْلُوا مَا عَادِشْ يْتَبْعُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","يَاخِي دَارْ لِلتْلَامْذَة الأَثْنَاشْ وقَالِلْهُمْ: «إِنْتُومَا زَادَا تْحِبُّوا تِمْشِيوْ كِيفْهُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","جَاوْبُو سِمْعَانْ بُطْرُسْ: «يَا رَبْ، لِشْكُونْ بِشْ نِمْشِيوْ؟ إِنْتِ الِّي عَنْدِكْ كْلَامْ الحَيَاةْ الأَبَدِيَّة، ");
INSERT INTO aeu_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","وأَحْنَا أَمَّنَّا وعْرَفْنَا الِّي إِنْتِ القُدُّوسْ الِّي بَعْثُو اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","جَاوِبْهُمْ يَسُوعْ: «مُشْ آنَا الِّي خْتَرْتْكُمْ إِنْتُومَا الأَثْنَاشْ؟ ومْعَ هَاذَا وَاحِدْ مِنْكُمْ شِيطَانْ!» ");
INSERT INTO aeu_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","وِقْصَدْ بِكْلَامُو هَاذَا، يَهُوذَا وِلْدْ سِمْعَانْ الإِسْخَرْيُوطِي، الِّي بِشْ يْخُونُو، رَغْمِلِّي هُوَّ وَاحِدْ مِنْ الأَثْنَاشْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ومْبَعِّدْ هَاذَاكَا بْدَا يَسُوعْ يْدُورْ فِي الجَلِيلْ، ومَا حَبِّشْ يِمْشِي لْمَنْطَقْةْ اليَهُودِيَّة عْلَى خَاطِرْ اليْهُودْ كَانُوا يْحِبُّوا يُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ووَقْتِلِّي قْرُبْ عِيدْ الخْيَامْ اليْهُودِي، ");
INSERT INTO aeu_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","قَالُولُو خْوَاتُو: «أُخْرُجْ مِالمَنْطْقَة هَاذِي وإِمْشِي لِلْيَهُودِيَّة، بَاشْ تْلَامِذْتِكْ زَادَا يْشُوفُوا أَعْمَالِكْ، ");
INSERT INTO aeu_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","رَاهُو الِّي يْحِبْ يِتْشْهَرْ مَا يِلْزْمُوشْ يِخْدِمْ فِي السِّرْ. مَادَامِكْ تَعْمِلْ فِي الأَعْمَالَ هَاذِي، ظَهِّرْ رُوحِكْ لِلنَّاسْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","قَالُوا الكْلَامْ هَاذَا عْلَى خَاطِرْ حَتَّى خْوَاتُو بِيدْهُمْ مَا كَانُوشْ يَمْنُوا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","يَاخِي قَالِلْهُمْ يَسُوعْ: «وَقْتِي مَزَّالْ مَا جَاشْ، آمَا إِنْتُومَا الوَقْتْ دِيمَا مُنَاسِبْ لِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","العَالِمْ مَا يْنَجِّمْشْ يَكْرَهْكُمْ إِنْتُومَا، آمَا يَكْرَهْنِي آنَا عْلَى خَاطِرْنِي نِشْهِدْ عْلِيهْ الِّي أَعْمَالُو شِرِّيرَة. ");
INSERT INTO aeu_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","إِمْشِيوْ إِنْتُومَا لِلْعِيدْ، آمَا آنَا مَانِيشْ مَاشِي تَوَّا لِلْعِيدْ هَاذَا عْلَى خَاطِرْ وَقْتِي مَزَّالْ مَا جَاشْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","قَالِلْهُمْ الكْلَامْ هَاذَا وقْعَدْ فِي الجَلِيلْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","آمَا بَعْدْمَا مْشَاوْ خْوَاتُو لِلْعِيدْ، مْشَى هُوَّ زَادَا، آمَا فِي السِّرْ مِنْ غِيرْ مَا يْظَهِّرْ رُوحُو. ");
INSERT INTO aeu_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","وكَانُوا اليْهُودْ يْلَوْجُوا عْلِيهْ فِي العِيدْ ويِسْأْلُوا: «وِينُو هَاكَا الرَّاجِلْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","وكَانُوا النَّاسْ يِوَشْوْشُوا بِينَاتْ بْعَضْهُمْ عْلِيهْ، فَمَّة شْكُونْ قَالْ: «رَاهُو رَاجِلْ صَالَحْ». وفَمَّة شْكُونْ قَالْ: «لَا، رَاهُو يْغَلِّطْ فِي النَّاسْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","آمَا حَتَّى حَدْ مَا حْكَى عْلِيهْ جْهَارْ، عْلَى خَاطِرْ كَانُوا خَايْفِينْ مِنْ قَادِةْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","وفِي وِسْطْ أَيَّامَاتْ العِيدْ، طْلَعْ يَسُوعْ لِلْهَيْكِلْ وبْدَا يْعَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","يَاخِي إِتْعَجْبُوا قَادِةْ اليْهُودْ وقَالُوا: «كِيفَاشْ هَاذَا يَعْرِفْ الكْتُبْ المُقَدْسَة بِالڨْدَا، وهُوَّ مَا تَعَلَّمْهُمْشْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","جَاوِبْهُمْ يَسُوعْ: «الِّي نْعَلِّمْ فِيهْ مُشْ مِنْ عَنْدِي آمَا مِنْ عَنْدْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","كَانْ وَاحِدْ يْحِبْ يَعْمِلْ مَشِيئِةْ اللَّهْ، تَوْ يَعْرِفْ كَانْ تَعْلِيمِي هَاذَا مِنْ عَنْدْ اللَّهْ وَلَّا مِنْ عَنْدِي آنَا. ");
INSERT INTO aeu_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","الِّي يْقُولْ كْلَامْ مِنْ عَنْدُو رَاهُو يُطْلُبْ المَجْدْ لْرُوحُو، آمَا الِّي يُطْلُبْ المَجْدْ لِلِّي بَعْثُو، رَاهُو صَادِقْ ومَا فِيهْ حَتَّى غَشَّة. ");
INSERT INTO aeu_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","يَاخِي مُشْ مُوسَى عْطَاكُمْ الشَّرِيعَة؟ آمَا حَتَّى وَاحِدْ مِنْكُمْ مَاهُو يْطَبَّقْ فِيهَا! مَالَا عْلَاشْ تْحِبُّوا تُقْتْلُونِي؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","جَاوْبُوهْ النَّاسْ: «إِنْتِ سَاكْنِكْ شِيطَانْ، شْكُونُو الِّي يْحِبْ يُقْتْلِكْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","جَاوِبْهُمْ يَسُوعْ: «آنَا مَا عْمَلْتْ كَانْ حَاجَة وَحْدَة نْهَارْ السِّبْتْ، وإِنْتُومَا الكُلْكُمْ إِسْتَغْرَبْتُوا. ");
INSERT INTO aeu_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","والطْهُورْ مُشْ مُوسَى الِّي جَابُو، كَانْ عَنْدْ الجْدُودْ مِنْ قْبَلْ. آمَا مُوسَى وَصَّاكُمْ بِيهْ، هَاذَاكَا عْلَاشْ إِنْتُومَا اطَّهْرُوا العْبَادْ حَتَّى لَوْ كَانْ نْهَارْ السِّبْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","إِذَا كَانْ إِنْتُومَا اطَّهْرُوا النَّاسْ نْهَارْ السِّبْتْ بَاشْ مَا تْخَالْفُوشْ شَرِيعِةْ مُوسَى، مَالَا عْلَاشْ تِتْغَشْشُوا عْلِيَّا عْلَى خَاطِرْنِي شْفِيتْ إِنْسَانْ بْكُلُّو نْهَارْ السِّبْتْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","مَا تُحْكْمُوشْ عَالظَّاهِرْ، آمَا أُحْكْمُوا بِالعَدْلْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","وَقْتْهَا فَمَّة جْمَاعَة مِنْ أُورْشَلِيمْ قَالُوا: «يَاخِي مُشْ هَاذَا الِّي يْحِبُّوا يُقْتْلُوهْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","هَاوْ يِتْكَلِّمْ جْهَارْ ومَا قَالُولُو حَتَّى شَيْ. يَاخِي القَادَة إِقْتَنْعُوا الِّي هُوَّ المَسِيحْ بِالحَقْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","وَقْتِلِّي يْجِي المَسِيحْ، حَدْ مَا بِشْ يَعْرِفْ عْلِيهْ مْنِينْ جَاء، آمَا هَاذَا أَحْنَا نَعْرْفُوهْ مْنِينْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","يَاخِي قَالْ يَسُوعْ عْلَى طُولْ صُوتُو وهُوَّ يْعَلِّمْ فِي الهَيْكِلْ: «إِنْتُومَا تَعْرْفُونِي، وتَعْرْفُوا آنَا مْنِينْ. آنَا مَا جِيتِشْ مِنْ رُوحِي، ولِّي بْعَثْنِي رَاهُو صَادِقْ، وإِنْتُومَا مَا تَعْرْفُوهِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","آمَا آنَا رَانِي نَعْرْفُو، عْلَى خَاطِرْنِي مِنُّو، وهُوَّ الِّي بْعَثْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","وَقْتْهَا حَبُّوا يْشِدُّوهْ، آمَا حَتَّى حَدْ مَا نَجِّمْ يْحُطْ يِدُّو عْلِيهْ، عْلَى خَاطِرْ سَاعْتُو مَزَّالِتْ مَا جَاتِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","آمَا بَرْشَة نَاسْ مِلِّي كَانُوا حَاضْرِينْ أَمْنُوا بِيهْ وقَالُوا: «زَعْمَة وَقْتِلِّي يْجِي المَسِيحْ بَاشْ يَعْمِلْ مُعْجْزَاتْ أَكْثِرْ مِلِّي عْمَلْهُمْ الرَّاجِلْ هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","وسَمْعُوا الفِرِّيسِيِّينْ آشْ كَانُوا النَّاسْ يْوَشْوْشُو عْلِيهْ بِينْ بْعَضْهُمْ. وَلَّاوْ هُومَا وكْبَارْ الكَهَنَة بَعْثُوا حُرَّاسْ بَاشْ يْشِدُّوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","وقَالْ يَسُوعْ: «بِشْ نْزِيدْ نُقْعُدْ مْعَاكُمْ مُدَّة قْصِيرَة، ومْبَعِّدْ نِرْجَعْ لِلِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","بَاشْ تْلَوْجُوا عْلِيَّا ومَا تَلْقَاوْنِيشْ، والبْلَاصَة الِّي بِشْ نْكُوْنْ فِيهَا، مَا تْنَجْمُوشْ تِمْشِيوْلْهَا». ");
INSERT INTO aeu_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","قَالُوا اليْهُودْ بِينْ بْعَضْهُمْ: «يَاخِي وِينْ نَاوِي يِمْشِي حَتَّى مَا نَلْقَاوْهِشْ؟ زَعْمَة بَاشْ يِمْشِي لِلْمُدُنْ اليُونَانِيَّة المِتْفَرْقِينْ فِيهَا اليْهُودْ، ويْعَلِّمْ اليُونَانِيِّينْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","آشْ يُقْصُدْ كِي قَالْ: \"بِشْ تْلَوْجُوا عْلِيَّا ومَا تَلْقَاوْنِيشْ، والبْلَاصَة الِّي بَاشْ نْكُوْنْ فِيهَا، مَا تْنَجْمُوشْ تِمْشِيوْلْهَا\"؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","وفِي آخِرْ نْهَارْ فِي العِيدْ، ولِّي هُوَّ أَهَمْ نْهَارْ، وْقِفْ يَسُوعْ وقَالْ بْصُوتْ عَالِي: «كَانْ وَاحِدْ عْطُشْ، خَلِّيهْ يْجِينِي ويُشْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ولِّي يَمِّنْ بِيَّا، كِيمَا قَالِتْ الكْتُبْ المُقَدْسَة: \"تِجْرِي مِنُّو وِدْيَانْ مَاء حَيْ\"». ");
INSERT INTO aeu_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","وقَالْ هَاذَا عَالرُّوحْ الِّي المُؤْمْنِينْ بِيهْ بِشْ يِقْبْلُوهْ، ووَقْتْهَا الرُّوحْ القُدُسْ مَزَّالْ مَا تِعْطَاشْ، عْلَى خَاطِرْ يَسُوعْ مَزَّالْ مَا تْمَجِّدْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","وفَمَّة بَرْشَة مِلِّي كَانُوا حَاضْرِينْ سَمْعُوا الكْلَامْ هَاذَا قَالُوا: «بِالحَقْ هَاذَا هُوَّ النَّبِيْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","وفَمَّة نَاسْ أُخْرِينْ قَالُوا: «هَاذَا هُوَّ المَسِيحْ!» وأُخْرِينْ زَادَا قَالُوا: «يَاخِي المَسِيحْ بِشْ يْجِي مِالجَلِيلْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","يَاخِي مُشْ قَالِتْ الكْتُبْ المُقَدْسَة الِّي المَسِيحْ بِشْ يْجِي مِنْ ذُرِّيِّةْ دَاوِدْ، ومِنْ بِيتْ لَحْمْ، المْدِينَة الِّي جَاء مِنْهَا دَاوِدْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","يَاخِي تْخَالْفُوا النَّاسْ بِينْ بْعَضْهُمْ عْلَى خَاطْرُو. ");
INSERT INTO aeu_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","وفَمَّة جْمَاعَة مِنْهُمْ حَبُّوا يْشِدُّوهْ، آمَا حَتَّى وَاحِدْ مَا حَطْ يِدُّو عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ووَقْتِلِّي رَجْعُوا حُرَّاسْ الهَيْكِلْ، سِأْلُوهُمْ كْبَارْ الكَهَنَة والفِرِّيسِيِّينْ: «عْلَاشْ مَا جِبْتُوهِشْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","جَاوْبُوهُمْ الحُرَّاسْ: «عْمُرْنَا مَا سْمَعْنَا وَاحِدْ يِتْكَلِّمْ كِيمَا الرَّاجِلْ هَاذَا!». ");
INSERT INTO aeu_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","قَالُولْهُمْ الفِرِّيسِيِّينْ: «يَاخِي إِنْتُومَا زَادَا غَلَّطْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","شُفْتُوشْ وَاحِدْ مِنْ كْبَارْ الكَهَنَة وَلَّا الفِرِّيسِيِّينْ أَمَّنْ بِيهْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","آمَا عَامِّةْ الشَّعْبْ الِّي مَا يَعْرْفُوشْ الشَّرِيعَة، هَاذُوكُمْ مَلْعُونِينْ!» ");
INSERT INTO aeu_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","آمَا نِيقُودِيمُوسْ الِّي هُوَّ وَاحِدْ مِالفِرِّيسِيِّينْ، وهُوَّ الِّي مْشَى لْيَسُوعْ فِي اللِّيلْ، قَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«يَاخِي شَرِيعِتْنَا تُحْكُمْ عْلَى وَاحِدْ قْبَلْ مَا تِسْمْعُوا وتَعْرِفْ آشْ عْمَلْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","جَاوْبُوهْ: «تِطْلَعْشْ إِنْتِ زَادَا مِالجَلِيلْ؟ ثَبِّتْ فِي الكْتُبْ المُقَدْسَة، تَوْ تَلْقَى الِّي حَتَّى نَبِيْ مَا يْجِيْ مِالجَلِيلْ». ");
INSERT INTO aeu_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ومْبَعِّدْ كُلْ وَاحِدْ رَوِّحْ لْدَارُو. ");
INSERT INTO aeu_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","آمَا يَسُوعْ طْلَعْ لِجْبَلْ الزِّيتُونْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","وفِي الفَجْرْ رْجَعْ لِلْهَيْكِلْ، وجَاوُوهْ النَّاسْ الكُلْ، يَاخِي قْعَدْ وبْدَا يْعَلِّمْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","وجَابُولُو عُلَمَاءْ الشَّرِيعَة والفِرِّيسِيِّينْ مْرَا شَدُّوهَا تَزْنَى، ووَقْفُوهَا فِي الوِسْطْ، ");
INSERT INTO aeu_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","وقَالُولُو: «يَا مُعَلِّمْ، المْرَا هَاذِي شَدُّوهَا تَزْنَى، ");
INSERT INTO aeu_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ومُوسَى وَصَّانَا فِي الشَّرِيعَة إِنُّو الِّي كِيفْهَا لَازِمْ يِتْرِجْمُوا. وإِنْتِ، آشْ تْقُولْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","قَالُولُو الكْلَامْ هَاذَا بَاشْ يْحَصْلُوهْ ويَلْقَاوْلُو تُهْمَة. آمَا يَسُوعْ طَبِّسْ، وبْدَا يِكْتِبْ بْصُبْعُو فِي التْرَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","وكِي شَدُّوا صْحِيحْ فِي سُؤَالْهُمْ، وْقِفْ يَسُوعْ وقَالِلْهُمْ: «الِّي فِيكُمْ عُمْرُو مَا عْمَلْ ذَنْبْ، خَلِّيهْ يْكُونْ أَوِّلْ وَاحِدْ يَرْمِي عْلِيهَا حَجْرَة». ");
INSERT INTO aeu_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","وطَبِّسْ مَرَّة أُخْرَى ورْجَعْ يِكْتِبْ فِي التْرَابْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ووَقْتِلِّي سَمْعُوا الكْلَامْ هَاذَا، بْدَاوْ يِجْبْدُوا فِي رْوَاحْهُمْ بِالوَاحِدْ بِالوَاحِدْ، كْبَارْهُمْ قْبَلْ صْغَارْهُمْ. وقْعَدْ يَسُوعْ وَحْدُو والمْرَا وَاقْفَة فِي بْلَاصِتْهَا. ");
INSERT INTO aeu_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","وْقِفْ يَسُوعْ وقَالِلْهَا: «وِينْهُمْ يَا مْرَا؟ يَاخِي حَتَّى وَاحِدْ مِنْهُمْ مَا حْكُمْ عْلِيكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","قَالِتْ: «حَتَّى حَدْ، يَا سِيدِي». قَالِلْهَا يَسُوعْ: «وآنَا زَادَا مَا نُحْكُمْشْ عْلِيكْ. إِمْشِي عْلَى رُوحِكْ ومَا تِرْجَعْشْ لِلذْنُوبْ!». ");
INSERT INTO aeu_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","وزَادْ يَسُوعْ كَلِّمْ النَّاسْ وقَالِلْهُمْ: «آنَا نُورْ العَالِمْ. الِّي يْتَبَّعْنِي مَا يِمْشِيشْ فِي الظْلَامْ، آمَا يْكُونْ عَنْدُو نُورْ الحَيَاةْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","يَاخِي قَالُولُو الفِرِّيسِيِّينْ: «إِنْتِ تِشْهِدْ لْرُوحِكْ، هَاذَاكَا عْلَاشْ شْهَادْتِكْ بَاطْلَة». ");
INSERT INTO aeu_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","جَاوِبْهُمْ يَسُوعْ: «حَتَّى كَانْ نِشْهِدْ لْرُوحِي شْهَادْتِي صْحِيحَة، عْلَى خَاطِرْ نَعْرِفْ رُوحِي مْنِينْ جِيتْ ولْوِينْ مَاشِي. آمَا إِنْتُومَا، مَا تَعْرْفُونِيشْ مْنِينْ جِيتْ ولَا لْوِينْ مَاشِي. ");
INSERT INTO aeu_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","إِنْتُومَا تُحْكْمُوا كِيفْ مَا يُحْكْمُوا البَشَرْ، آمَا آنَا مَا نُحْكُمْ عْلَى حَتَّى حَدْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","وحَتَّى كَانْ حْكُمْتْ، حُكْمِي صْحِيحْ، عْلَى خَاطِرْنِي مَانِيشْ نُحْكُمْ وَحْدِي، نُحْكُمْ آنَا والآبْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","مَكْتُوبْ فِي شَرِيعِتْكُمْ الِّي شْهَادِةْ زُوزْ مِنْ نَاسْ تْصُحْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","آنَا نِشْهِدْ لْرُوحِي، والآبْ الِّي بْعَثْنِي هُوَّ زَادَا يِشْهِدْلِي». ");
INSERT INTO aeu_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","يَاخِي قَالُولُو: «وِينُو بُوكْ؟». جَاوِبْهُمْ يَسُوعْ: «إِنْتُومَا لَا تَعْرْفُونِي ولَا تَعْرْفُوا بَابَا. كَانْ جِيتُوا عْرَفْتُونِي، رَاكُمْ عْرَفْتُوا بَابَا». ");
INSERT INTO aeu_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","قَالْ يَسُوعْ الكْلَامْ هَاذَا بَحْذَا صَنْدُوقْ التَّبَرُّعَاتْ، وَقْتِلِّي كَانْ يْعَلِّمْ فِي الهَيْكِلْ. وحَتَّى حَدْ مَا شَدُّو، عْلَى خَاطِرْ وَقْتُو مَزَّالْ مَا جَاشْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","وزَادْ قَالِلْهُمْ: «آنَا مَاشِي وبِشْ تْلَوْجُوا عْلِيَّا، آمَا بِشْ تْمُوتُوا فِي ذْنُوبْكُمْ. البْلَاصَة الِّي آنَا مَاشِيلْهَا مَا تْنَجْمُوشْ تْجِيوْهَا». ");
INSERT INTO aeu_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","قَالُوا اليْهُودْ: «زَعْمَة بِشْ يُقْتُلْ رُوحُو، هَاذَاكَا عْلَاشْ قَالْ: \"إِنْتُومَا مَا تْنَجْمُوشْ تْجِيوْ لِلْبْلَاصَة الِّي آنَا مَاشِيلْهَا\"؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","قَالِلْهُمْ: «إِنْتُومَا مِاللُّوطَة آمَا آنَا مِالفُوقْ. إِنْتُومَا مِالعَالِمْ هَاذَا آمَا آنَا مَانِيشْ مِالعَالِمْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","هَاذَاكَا عْلَاشْ قُلْتِلْكُمْ بِشْ تْمُوتُوا فِي ذْنُوبْكُمْ. إِذَا كَانْ مَا تَمْنُوشْ الِّي آنَا هُوَّ، رَاكُمْ بِشْ تْمُوتُوا فِي ذْنُوبْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","قَالُولُو: «شْكُونِكْ إِنْتِ؟». جَاوِبْهُمْ يَسُوعْ: «آنَا هُوَّ الِّي قُلْتِلْكُمْ عْلِيهْ مِالأُوِّلْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","عَنْدِي بَرْشَة حَاجَاتْ نْقُولْهَا عْلِيكُمْ، وبَرْشَة حَاجَاتْ نُحْكُمْ بِيهَا عْلِيكُمْ. آمَا الِّي بْعَثْنِي رَاهُو صَادِقْ، ولِّي سْمَعْتُو مِنُّو نْقُولُو لِلْعَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ومَا فِهْمُوشْ الِّي هُوَّ كَانْ يَحْكِيلْهُمْ عَالآبْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","قَالِلْهُمْ يَسُوعْ: «وَقْتِلِّي تْعَلْقُوا إِبْنْ الإِنْسَانْ، تَوْ تَعْرْفُوا الِّي آنَا هُوَّ، ولِّي آنَا مَا نَعْمِلْ حَتَّى شَيْ مِنْ رَاسِي، آمَا نْقُولْ الِّي عَلِّمْهُولِي الآبْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","والآبْ الِّي بْعَثْنِي هُوَّ مْعَايَا ومَا يْخَلِّينِيشْ وَحْدِي، عْلَى خَاطِرْنِي دِيمَا نَعْمِلْ الِّي يْرَضِّيهْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","وهُوَّ قَاعِدْ يْقُولْ فِي الكْلَامْ هَاذَا، أَمْنُوا بِيهْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","وقَالْ يَسُوعْ لِلْيْهُودْ الِّي أَمْنُوا بِيهْ: «إِذَا كَانْ تِثْبْتُوا فِي كْلَامِي، تْوَلِّيوْ بِالحَقْ تْلَامِذْتِي، ");
INSERT INTO aeu_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","وتَعْرْفُوا الحَقْ والحَقْ يْحَرِّرْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","جَاوْبُوهْ: «أَحْنَا ذُرِّيِّةْ إِبْرَاهِيمْ وعْمُرْنَا مَا كُنَّا عَبِيدْ لْحَتَّى حَدْ! كِيفَاشْ تْقُلْنَا: \"بِشْ تْوَلِّيوْ أَحْرَارْ\"؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","جَاوِبْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: الِّي يَعْمِلْ الذْنُوبْ هُوَّ عَبْدْ لِلذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","والعَبْدْ مَا يُقْعُدْشْ فِي دَارْ سِيدُو لِلْأَبَدْ، آمَا الإِبْنْ يِبْقَى لِلْأَبَدْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","إِذَا حَرَّرْكُمْ الإِبْنْ رَاكُمْ تْوَلِّيوْ بِالحَقْ أَحْرَارْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","آنَا نَعْرِفْ الِّي إِنْتُومَا ذُرِّيِّةْ إِبْرَاهِيمْ، آمَا تْحِبُّوا تُقْتْلُونِي، عْلَى خَاطِرْ كْلَامِي مَا عَنْدْوشْ بْلَاصَة فِي قْلُوبْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","آنَا نَحْكِي عَلِّي شُفْتُو عَنْدْ بَابَا، وإِنْتُومَا تَعْمْلُوا فِلِّي سْمَعْتُوهْ مِنْ بُوكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","قَالُولُو: «بُونَا هُوَّ إِبْرَاهِيمْ». جَاوِبْهُمْ يَسُوعْ: «كَانْ جِيتُوا وْلَادْ إِبْرَاهِيمْ، رَاكُمْ تَعْمْلُوا أَعْمَالْ إِبْرَاهِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","آمَا هَاكُمْ تْحِبُّوا تُقْتْلُونِي، آنَا الِّي كَلِّمْتْكُمْ بِالحَقْ الِّي سْمَعْتُو مِنْ عَنْدْ اللَّهْ. إِبْرَاهِيمْ مَا عْمَلْشْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","إِنْتُومَا تَعْمْلُوا فِي أَعْمَالْ بُوكُمْ». قَالُولُو: «أَحْنَا مَانَاشْ أَوْلَادْ حْرَامْ. عَنْدْنَا بُو وَاحِدْ، هُوَّ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","يَاخِي قَالِلْهُمْ يَسُوعْ: «كَانْ جَاء اللَّهْ بُوكُمْ رَاكُمْ تْحِبُّونِي، عْلَى خَاطِرْنِي خْرَجْتْ وجِيتْ مِنْ عَنْدْ اللَّهْ. مَا جِيتِشْ وَحْدِي، آمَا هُوَّ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","وعْلَاشْ مَا تِفْهْمُوشْ آشْ قَاعِدْ نْقُولْ؟ عْلَى خَاطِرْكُمْ مَا اطِّيقُوشْ تِسْمْعُوا كْلَامِي. ");
INSERT INTO aeu_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","إِنْتُومَا وْلَادْ إِبْلِيسْ، وتْحِبُّوا تَعْمْلُوا شْهَاوِي بُوكُمْ. هُوَّ كَانْ قَتَّالْ أَرْوَاحْ مِنْ أُوْلُو. مَا ثْبِتْشْ فِي الحَقْ، عْلَى خَاطِرْ مَافِيهِشْ حَقْ. وهُوَّ يِكْذِبْ والكِذِبْ فِي طْبِيعْتُو، عْلَى خَاطْرُو كَذَّابْ وبُو الكِذْبْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","آمَا آنَا، عْلَى خَاطِرْ نْقُولْ فِي الحَقْ، إِنْتُومَا مَا تْصَدْقُونِيشْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","شْكُونْ فِيكُمْ يْشِدْ عْلِيَّا ذَنْبْ؟ ومَادَامْنِي نْقُولْ فِي الحَقْ، عْلَاشْ مَا تْصَدْقُونِيشْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","الِّي هُوَّ تَابَعْ اللَّهْ يِسْمَعْ كْلَامْ اللَّهْ، وإِنْتُومَا مَا تِسْمْعُوشْ، عْلَى خَاطِرْكُمْ مَاكُمْشْ تَابْعِينْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","جَاوْبُوهْ اليْهُودْ: «مُشْ عَنْدْنَا الحَقْ كِي نْقُولُوا الِّي إِنْتِ سَامْرِي وسَاكْنِكْ شِيطَانْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","جَاوِبْهُمْ يَسُوعْ: «مُشْ سَاكِنِّي شِيطَانْ، آمَا آنَا نِكْرِمْ فِي بَابَا، وإِنْتُومَا مَاكُمْشْ تِكْرْمُوا فِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","آنَا مَا نُطْلُبْشْ المَجْدْ لْرُوحِي، آمَا فَمَّة شْكُونْ يُطْلُبْهُولِي، وهُوَّ الِّي يُحْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","الحَقْ الحَقْ نْقُلْكُمْ: الِّي يْطِيعْ كْلَامِي، عُمْرُو مَا يْشُوفْ المُوتْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","قَالُولُو اليْهُودْ: «تَوَّا بِالحَقْ عْرَفْنَا الِّي سَاكْنِكْ شِيطَانْ. إِبْرَاهِيمْ مَاتْ والأَنْبِيَاءْ مَاتُوا، وإِنْتِ تْقُولْ: \"الِّي يْطِيعْ كْلَامِي عُمْرُو مَا يْشُوفْ المُوتْ\"! ");
INSERT INTO aeu_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","يَاخِي إِنْتِ أَعْظَمْ مِنْ بُونَا إِبْرَاهِيمْ الِّي مَاتْ؟ وحَتَّى الأَنْبِيَاءْ مَاتُوا، يَاخِي شْكُونْ حَاسِبْ رُوحِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","جَاوِبْ يَسُوعْ: «كَانْ جِيتْ نْمَجِّدْ فِي رُوحِي، رَاهُو مَجْدِي بَاطِلْ. آمَا بَابَا هُوَّ الِّي يْمَجِّدْنِي، وإِنْتُومَا تْقُولُوا عْلِيهْ الِّي هُوَّ إِلَاهْكُمْ . ");
INSERT INTO aeu_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","إِنْتُومَا مَا تَعْرْفُوهِشْ، آمَا آنَا نَعْرْفُو. كَانْ نْقُولْ الِّي آنَا مَا نَعْرْفُوشْ، نْكُونْ كَذَّابْ كِيفْكُمْ. آمَا آنَا نَعْرْفُو ونْطِيعْ كْلَامُو. ");
INSERT INTO aeu_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","بُوكُمْ إِبْرَاهِيمْ كَانْ مِتْشَوَّقْ يْشُوفْ نْهَارِي، وشَافُو وفْرَحْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","قَالُولُو اليْهُودْ: «كِيفَاشْ شُفْتْ إِبْرَاهِيمْ، وإِنْتِ عُمْرِكْ أَقَلْ مِالخَمْسِينْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","جَاوِبْهُمْ يَسُوعْ: «الحَقْ الحَقْ نْقُلْكُمْ: قْبَلْ مَا يِتْوْجِدْ إِبْرَاهِيمْ، آنَا مَوْجُودْ». ");
INSERT INTO aeu_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","يَاخِي هَزُّوا الحْجَرْ بَاشْ يُرْجْمُوهْ، آمَا يَسُوعْ تْخَبَّى وخْرَجْ مِالهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ووَقْتِلِّي كَانْ يَسُوعْ مِتْعَدِّي، شَافْ رَاجِلْ أَعْمَى مِلِّي تُولِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","سِأْلُوهْ تْلَامِذْتُو: «يَا مُعَلِّمْ، شْكُونُو المُذْنِبْ: هُوَّ وَلَّا وَالْدِيهْ، حَتَّى تُولِدْ أَعْمَى؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","جَاوِبْهُمْ يَسُوعْ: «لَا هُوَّ ولَا وَالْدِيهْ أَذْنْبُوا، آمَا تُولِدْ أَعْمَى بَاشْ النَّاسْ يْشُوفُوا فِيهْ آشْ يْنَجِّمْ يَعْمِلْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","يِلْزِمْنِي نَعْمِلْ أَعْمَالْ الِّي بْعَثْنِي، مَادَامْ الدِّنْيَا نْهَارْ، رَاهُو بَاشْ يْجِي اللِّيلْ وحَتَّى حَدْ مَا عَادْ يْنَجِّمْ يَعْمِلْ حَاجَة. ");
INSERT INTO aeu_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","مَادَامْنِي فِي العَالِمْ، آنَا نُورْ العَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","قَالْ الكْلَامْ هَاذَا وبْزَقْ فِي التْرَابْ، وعْمَلْ مِنُّو طِينْ وحَطُّو عْلَى عِينِينْ الأَعْمَى ");
INSERT INTO aeu_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","وقَالُّو: «إِمْشِي وأَغْسِلْ رُوحِكْ فِي جَابِيَةْ سِلْوَامْ» الِّي مَعْنَاهَا مَبْعُوثْ. يَاخِي مْشَى، وغْسَلْ، ورْجَعْ مِنْ غَادِي وهُوَّ يْشُوفْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","الجِيرَانْ والنَّاسْ الِّي شَافُوهْ قْبَلْ يُطْلُبْ قَالُوا: «يَاخِي مُشْ هَاذَا الِّي كَانْ دِيمَا يُقْعُدْ ويُطْلُبْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","فَمَّة الِّي قَالُوا: «أَيْ هَاذَاكَا هُوَّ». وفَمَّة الِّي قَالُوا: «لَا، يِشَبَّهْلُو». آمَا هُوَّ كَانْ يْقُولْ: «آنَا هُوَّ!». ");
INSERT INTO aeu_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","يَاخِي سِأْلُوهْ: «كِيفَاشْ عِينِيكْ تْحَلِّتْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","جَاوِبْ: «الرَّاجِلْ الِّي إِسْمُو يَسُوعْ عْمَلْ طِينْ وحَطُّو عْلَى عِينَيَّا وقَالِّي: \"إِمْشِي أَغْسِلْ فِي جَابِيَةْ سِلْوَامْ\". مْشِيتْ وغْسَلْتْ، ووَلِّيتْ نْشُوفْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","قَالُولُو: «وهُوَّ وِينُو؟» قَالْ: «مَا نَعْرِفْشْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","يَاخِي هَزُّوا الرَّاجِلْ الِّي كَانْ أَعْمَى لِلْفِرِّيسِيِّينْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","والنْهَارْ الِّي عْمَلْ فِيهْ يَسُوعْ الطِّينْ وحَلْ عِينِينْ الأَعْمَى كَانْ نْهَارْ سِبْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","زَادُوا الفِرِّيسِيِّينْ سِأْلُوهْ كِيفَاشْ وَلَّى يْشُوفْ، جَاوِبْهُمْ: «حَطْلِي طِينْ عْلَى عِينَيَّا وغْسَلْتْ وَلِّيتْ نْشُوفْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","فَمَّة فِرِّيسِيِّينْ قَالُوا: «مَا يْنَجِّمْشْ يْكُونْ الرَّاجِلْ هَاذَا جَايْ مِنْ عَنْدْ اللَّهْ عْلَى خَاطْرُو مَا احْتَرِمْشْ السِّبْتْ». وفَمَّة نَاسْ أُخْرِينْ قَالُوا: «كِيفَاشْ يْنَجِّمْ وَاحِدْ مُذْنِبْ يَعْمِلْ المُعْجْزَاتْ هَاذِي؟» وتْخَالْفُوا بِينْ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","وزَادُوا سِأْلُو الأَعْمَى: «وإِنْتِ شْنُوَّة تْقُولْ عْلِيهْ بَعْدْمَا حَلِّكْ عِينِيكْ؟». جَاوِبْهُمْ: «هُوَّ نَبِيْ!». ");
INSERT INTO aeu_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","وقَادِة اليْهُودْ مَا صَدْقُوشْ الِّي هُوَّ كَانْ أَعْمَى ووَلَّى يْشُوفْ، وَلَّاوْ إِسْتَدْعَاوْ أُمُّو وبُوهْ ");
INSERT INTO aeu_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","وسِأْلُوهُمْ: «يَاخِي مُشْ هَاذَا وِلْدْكُمْ الِّي تْقُولُو إِنُّو تُولِدْ أَعْمَى؟ مَالَا كِيفَاشْ وَلَّى يْشُوفْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","أُمُّو وبُوهْ قَالُوا: «أَحْنَا نَعْرْفُوا الِّي هَاذَا وِلْدْنَا، ولِّي هُوَّ تُولِدْ أَعْمَى ");
INSERT INTO aeu_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","آمَا كِيفَاشْ تَوَّا وَلَّى يْشُوفْ وشْكُونْ حَلُّو عِينِيهْ، مَا نَعْرْفُوشْ. هُوَّ بَالِغْ، إِسْأْلُوهْ، تَوْ يْجَاوِبْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ووَالْدِيهْ قَالُوا هَاذَا عْلَى خَاطِرْهُمْ خَايْفِينْ مِنْ قَادِةْ اليْهُودْ، الِّي تْفَاهْمُوا بَاشْ يْطَرْدُوا مِالمَعْبِدْ أَيْ وَاحِدْ يْقُولْ الِّي يَسُوعْ هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","هَاذَاكَا عْلَاشْ وَالْدِيهْ قَالُوا: «هُوَّ بَالِغْ، إِسْأْلُوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ومْبَعِّدْ سْتَدْعَاوْا الفِرِّيسِيِّينْ الرَّاجِلْ الِّي كَانْ أَعْمَى مَرَّة أُخْرَى وقَالُولُو: «قُولْ الحَقْ قُدَّامْ اللَّهْ! أَحْنَا نَعْرْفُوا الِّي الرَّاجِلْ هَاذَا مُذْنِبْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","جَاوِبْ: «مَا نَعْرِفْشْ هُوَّ مُذْنِبْ وَلَّا لَا، آمَا نَعْرِفْ حَاجَة وَحْدَة: كُنْتْ أَعْمَى وتَوَّا وَلِّيتْ نْشُوفْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","وَلَّاوْ سِأْلُوهْ مَرَّة أُخْرَى: «آشْ عْمَلِّكْ؟ كِيفَاشْ حَلِّكْ عِينِيكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","جَاوِبْهُمْ: «قُلْتِلْكُمْ ومَا سْمَعْتُونِيشْ، عْلَاشْ تْحِبُّوا تِسْمْعُوا مَرَّة أُخْرَى؟ يَاخِي إِنْتُومَا زَادَا تْحِبُّوا تْوَلِّيوْ تْلَامِذْتُو؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","يَاخِي سَبُّوهْ وقَالُولُو: «إِنْتِ تِلْمِيذُو! آمَا أَحْنَا رَانَا تْلَامِذْةْ مُوسَى. ");
INSERT INTO aeu_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","أَحْنَا نَعْرْفُوا الِّي اللَّهْ كَلَّمْ مُوسَى، آمَا هَاذَا مَا نَعْرْفُوشْ عْلِيهْ حَتَّى مْنِينْ جَاء». ");
INSERT INTO aeu_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","جَاوِبْهُمْ الرَّاجِلْ: «غْرِيبَة! كِيفَاشْ مَا تَعْرْفُوهِشْ مْنِينْ جَاء وهُوَّ حَلِّي عِينَيَّا؟ ");
INSERT INTO aeu_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","أَحْنَا نَعْرْفُوا الِّي اللَّهْ مَا يَسْتَجِيبِشْ لِلْمُذْنْبِينْ، آمَا يَسْتَجِيبْ لِلنَّاسْ الِّي يْخَافُوهْ ويَعْمْلُوا مَشِيئْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","وعْمُرْنَا مَا سْمَعْنَا بْوَاحِدْ حَلْ عِينِينْ إِنْسَانْ مَوْلُودْ أَعْمَى. ");
INSERT INTO aeu_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","لَوْ كَانْ مَا جَاشْ الرَّاجِلْ هَاذَا مِنْ عَنْدْ اللَّهْ، مَا كَانْ يْنَجِّمْ يَعْمِلْ حَتَّى شَيْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","قَالُولُو: «إِنْتِ بْكُلِّكْ تُولِدْتْ فِي الذْنُوبْ وتْحِبْ تْعَلَّمْنَا؟» وطَرْدُوهْ مِالمَعْبِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","وسْمَعْ يَسُوعْ الِّي هُومَا طَرْدُوهْ، يَاخِي وَقْتِلِّي قَابْلُو سِأْلُو: «إِنْتِ تَمِّنْ بِإِبْنْ الإِنْسَانْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","جَاوْبُو: «شْكُونُو هُوَّ يَا سِيدِي بَاشْ نَمِّنْ بِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","قَالُّو يَسُوعْ: «إِنْتِ شُفْتُو، وهُوَّ قَاعِدْ يَحْكِي مْعَاكْ تَوَّا!». ");
INSERT INTO aeu_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","قَالْ: «آنَا نَمِّنْ، يَا سِيدِي!» وسْجِدْلُو. ");
INSERT INTO aeu_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","وقَالْ يَسُوعْ: «جِيتْ لِلْعَالِمْ هَاذَا بَاشْ نُحْكُمْ، بَاشْ الِّي مَا يْشُوفُوشْ يْوَلِّيوْ يْشُوفُوا، ولِّي يْشُوفُوا يْوَلِّيوْ مَا يْشُوفُوشْ». ");
INSERT INTO aeu_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","سَمْعُوهْ جْمَاعَة مِالفِرِّيسِيِّينْ الِّي كَانُوا حَاضْرِينْ، قَالُولُو: «يَاخِي أَحْنَا زَادَا عِمْيَانْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","جَاوِبْهُمْ يَسُوعْ: «كَانْ جِيتُوا عِمْيَانْ بِالحَقْ، رَاهُو مَا عْلِيكُمِشْ ذَنْبْ. آمَا إِنْتُومَا تْقُولُوا إِنْكُمْ تْشُوفُوا، هَاذَاكَا عْلَاشْ إِنْتُومَا مَسْؤُولِينْ عْلَى ذَنْبْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","«الحَقْ الحَقْ نْقُلْكُمْ: الِّي مَا يُدْخُلْشْ لْكُورِي الغْنَمْ مِالبَابْ، آمَا يِطْلَعْلُو مِنْ شِيرَة أُخْرَى، رَاهُو سَارِقْ وخَطَّافْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","آمَا الِّي يُدْخُلْ مِالبَابْ رَاهُو رَاعِي الغْنَمْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","والعَسَّاسْ يْحِلُّو، والغْنَمْ تِسْمَعْ صُوتُو، ويْعَيِّطْ لِلْغْنَمْ مْتَاعُو كُلْ وَاحِدْ بْإِسْمُو ويْخَرِّجْهُمْ لْبَرَّا مِالكُورِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ووَقْتِلِّي يْخَرِّجْهُمْ الكُلْ، يِمْشِي قُدَّامْهُمْ وهُومَا يْتَبْعُوهْ عْلَى خَاطِرْهُمْ يَعْرْفُوا صُوتُو. ");
INSERT INTO aeu_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","آمَا البَرَّانِي يُهْرْبُوا مِنُّو مَا يْتَبْعُوهِشْ، عْلَى خَاطِرْهُمْ مَا يَعْرْفُوشْ صُوتْ البْرَايْنِيَّة». ");
INSERT INTO aeu_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","قَالِلْهُمْ يَسُوعْ المَثَلْ هَاذَا، آمَا هُومَا مَا فَهْمُوشْ شْنُوَّة يُقْصُدْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","يَاخِي زَادْ قَالِلْهُمْ : «الحَقْ الحَقْ نْقُولِلْكُمْ: آنَا هُوَّ بَابْ الغْنَمْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","الِّي جَاوْ قَبْلِي الكُلْهُمْ سُرَّاقْ وخَطَّافِينْ، آمَا الغْنَمْ مَا سَمْعُولْهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","آنَا هُوَّ البَابْ. الِّي يُدْخُلْ مِنِّي يِنْجَى، ويُدْخُلْ ويُخْرُجْ ويَلْقَى آشْ يَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","السَّارِقْ مَا يْجِي كَانْ بَاشْ يِسْرِقْ ويِذْبِحْ وْيِهْلِكْ. آمَا آنَا جِيتْ بَاشْ نَعْطِيهُمْ حَيَاةْ، حَيَاةْ عَنْدْهَا مَعْنَى. ");
INSERT INTO aeu_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","«آنَا هُوَّ الرَّاعِي الصَّالَحْ، والرَّاعِي الصَّالَحْ يْضَحِّي بْرُوحُو عْلَى خَاطِرْ الغْنَمْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","والخَدَّامْ مُشْ كِيفْ الرَّاعِي، عْلَى خَاطِرْ الغْنَمْ مُشْ مْتَاعُو، وَقْتِلِّي يْشُوفْ الذِّيبْ جَايْ، يْخَلِّي الغْنَمْ ويُهْرُبْ، والذِّيبْ يَخْطِفْهَا ويْفَرَّقْهَا. ");
INSERT INTO aeu_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","والخَدَّامْ يُهْرُبْ عْلَى خَاطْرُو خَدَّامْ، ومَا يْهِمُّوشْ فِي الغْنَمْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","آمَا آنَا الرَّاعِي الصَّالَحْ، ونَعْرِفْ الغْنَمْ مْتَاعِي والغْنَمْ مْتَاعِي تَعْرَفْنِي، ");
INSERT INTO aeu_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","كِيفْ مَا الآبْ يَعْرِفْنِي وآنَا نَعْرِفْ الآبْ. وآنَا نْضَحِّي بْرُوحِي عْلَى خَاطِرْ الغْنَمْ مْتَاعِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","وعَنْدِي غْنَمْ أُخْرِينْ مَاهُمْشْ مِالكُورِي هَاذَا، لَازِمْنِي نْجِيبْهُمْ، وهُومَا بِشْ يِسْمْعُوا صُوتِي، ويْوَلِّي فَمَّة رَعِيَّة وَحْدَة وْرَاعِي وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","هَاذَاكَا عْلَاشْ الآبْ يْحِبْنِي، عْلَى خَاطِرْنِي نَعْطِي حْيَاتِي بَاشْ نْعَاوِدْ نَاخِذْهَا. ");
INSERT INTO aeu_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","حَتَّى حَدْ مَا يَاخِذْلِي حْيَاتِي بِالقُوَّة، آمَا آنَا الِّي نْضَحِّي بِيهَا بِرْضَايَا. عَنْدِي السُّلْطَة بِشْ نَعْطِيهَا، وعَنْدِي السُّلْطَة بِشْ نْرَجَّعْهَا. هَاذِي الوْصِيَّة الِّي خْذِيتْهَا مِنْ عَنْدْ بَابَا». ");
INSERT INTO aeu_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","وتْخَالْفُوا اليْهُودْ مَرَّة أُخْرَى عْلَى خَاطِرْ الكْلَامْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","بَرْشَة مِنْهُمْ قَالُوا: «رَاهُو سَاكْنُو شِيطَانْ ويْخَرِّفْ، عْلَاشْ تِسْمْعُوا فِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ونَاسْ أُخْرِينْ قَالُوا: «الكْلَامْ هَاذَا مُشْ مْتَاعْ وَاحِدْ سَاكْنُو شِيطَانْ. يَاخِي الشِّيطَانْ يْنَجِّمْ يْحِلْ عِينِينْ العِمْيَانْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","وجَاء عِيدْ تَجْدِيدْ الهَيْكَلْ فِي أُورْشَلِيمْ، وكَانْ الوَقْتْ فِي الشْتَاء. ");
INSERT INTO aeu_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","وكَانْ يَسُوعْ يْدُورْ فِي الهَيْكِلْ فِي البْلَاصَة الِّي مْسَمِّينْهَا أَقْوَاسْ سُلَيْمَانْ، ");
INSERT INTO aeu_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","دَارُوا بِيهْ اليْهُودْ وقَالُولُو: «لْوَقْتَاشْ بَاشْ تْخَلِّينَا حَايْرِينْ فِيكْ؟ قُلْنَا بْصَرَاحَة: يَاخِي إِنْتِ هُوَّ المَسِيحْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","جَاوِبْهُمْ يَسُوعْ: «قُلْتِلْكُمْ، آمَا إِنْتُومَا مَا تْصَدْقُوشْ. الأَعْمَالْ الِّي نَعْمِلْ فِيهَا بْإِسْمْ بَابَا هِيَّ تِشْهِدْلِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","آمَا إِنْتُومَا مَا تْصَدْقُونِيشْ عْلَى خَاطِرْكُمْ مَاكُمْشْ مِالغْنَمْ مْتَاعِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","الغْنَمْ مْتَاعِي يِسْمْعُوا صُوتِي، وآنَا نَعْرِفْهُمْ وهُومَا يْتَبْعُونِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","وآنَا نَعْطِيهُمْ الحَيَاةْ الأَبَدِيَّة، وعْمُرْهُمْ مَا يِمْشِيوْ لِلْهْلَاكْ، وحَتَّى حَدْ مَا يْنَجِّمْ يْفُكْهُمْ مِنْ يِدِّي. ");
INSERT INTO aeu_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","بَابَا الِّي عْطَاهُمْلِي هُوَّ أَعْظِمْ مِالكُلْ، وحَتَّى حَدْ مَا يْنَجِّمْ يْفُكْهُمْ مِنْ يِدْ الآبْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","آنَا والآبْ وَاحِدْ». ");
INSERT INTO aeu_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","وهَزُّوا اليْهُودْ الحْجَرْ مَرَّة أُخْرَى بَاشْ يُرْجْمُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","قَالِلْهُمْ يَسُوعْ: «آنَا وَرِّيتْكُمْ بَرْشَة أَعْمَالْ صَالْحَةْ مِنْ عَنْدْ الآبْ، عْلَى آنَا وَحْدَة مِنْهُمْ بَاشْ تُرْجْمُونِي؟». ");
INSERT INTO aeu_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","جَاوْبُوهْ اليْهُودْ: «مَانَاشْ بَاشْ نُرْجْمُوكْ عْلَى حَاجَة صَالْحَة عْمَلْتْهَا، آمَا عْلَى كُفْرِكْ. عْلَى خَاطْرِكْ رَدِّيتْ رُوحِكْ اللَّهْ، وإِنْتِ مَاكْ إِلَّا بَشَرْ». ");
INSERT INTO aeu_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","جَاوِبْهُمْ يَسُوعْ: «يَاخِي مُشْ فِي شَرِيعِتْكُمْ اللَّهْ قَالْ: \"إِنْتُومَا آلْهَة\"؟ ");
INSERT INTO aeu_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","إِذَا كَانْ شَرِيعِتْكُمْ تْسَمِّي النَّاسْ الِّي جَاتْهُمْ كِلْمِةْ اللَّهْ آلْهَة، والكْتُبْ المُقَدْسَة دِيمَا صَادْقَة، ");
INSERT INTO aeu_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","كِيفَاشْ تْقُولُو لِلِّي قَدْسُو الآبْ وبَعْثُو لِلْعَالِمْ \"إِنْتِ تَكْفِرْ\"، عْلَى خَاطِرْنِي قُلْتْ: \"آنَا إِبْنْ اللَّهْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","إِذَا كَانْ مَانِيشْ نَعْمِلْ فِي أَعْمَالْ بَابَا، مَا تْصَدْقُونِيشْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","آمَا إِذَا كُنْتْ نَعْمِلْ فِيهَا، عْلَى الأَقَلْ صَدْقُواهَا هِيَّ، كِي مَاكُمْشْ مْصَدْقِينِّي آنَا. ووَقْتْهَا تَعْرْفُوا وتِتْأَكْدُوا الِّي الآبْ فِيَّا وآنَا فِيهْ». ");
INSERT INTO aeu_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","وحَاوْلُوا مَرَّة أُخْرَى بَاشْ يْشِدُّوهْ، آمَا هُوَّ فْلِتْ مِنْ بِينْ يْدِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ورْجَعْ لِلشِّيرَة الأُخْرَى مْتَاعْ نَهْرْ الأُرْدُنْ وِينْ كَانْ يُوحَنَّا يْعَمِّدْ فِي النَّاسْ قْبَلْ، وقْعَدْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","وجَاوَهْ بَرْشَة نَاسْ وقَالُوا: «يُوحَنَّا مَا عْمَلْ حَتَّى مُعْجْزَة، آمَا الِّي قَالُّو عَالرَّاجِلْ هَاذَا الكُلُّو صْحِيحْ». ");
INSERT INTO aeu_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","وغَادِي أَمْنُوا بِيهْ بَرْشَة نَاسْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","وكَانْ فَمَّة رَاجِلْ مْرِيضْ إِسْمُو لِعَازَرْ، مِنْ دَشْرِةْ بِيتْ عَنْيَا الِّي تُسْكُنْ فِيهَا مَرْيِمْ وأُخْتْهَا مَرْثَى. ");
INSERT INTO aeu_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ومَرْيِمْ هَاذِي هِيَّ الِّي دِهْنِتْ سَاقِينْ الرَّبْ بِالعِطْرْ ومَسْحِتْهُمْ بِشْعَرْهَا، وهِيَّ أُخْتْ لِعَازَرْ المْرِيضْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","بَعْثُوا الإِخْوَاتْ لْيَسُوعْ شْكُونْ يْقُّلُو: «يَا سِيدِي، رَاهُو الِّي تْحِبُّو مْرِيضْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ووَقْتِلِّي سْمَعْ يَسُوعْ قَالْ: «المْرَضْ هَاذَا مُشْ بِشْ يْوَصِّلْ لِلْمُوتْ، آمَا بِشْ يِتْمَجِّدْ بِيهْ اللَّهْ، وهَكَّا يِتْمَجِّدْ بِيهْ إِبْنْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","وكَانْ يَسُوعْ يْحِبْ مَرْثَا وأُخْتْهَا ولِعَازَرْ، ");
INSERT INTO aeu_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ورَغْمْ هَاذَا، وَقْتِلِّي سْمَعْ بْلِعَازَرْ مْرِيضْ، زَادْ قْعَدْ نْهَارِينْ فِي البْلَاصَة الِّي هُوَّ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ومْبَعِّدْ قَالْ لِتْلَامْذَتُو: «هَيَّا نِرْجْعُوا لْمَنْطَقْةْ اليَهُودِيَّة». ");
INSERT INTO aeu_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","يَاخِي قَالُولُو التْلَامْذَة: «يَا مُعَلِّمْ، قْبِيلَة شْوَيَّة اليْهُودْ كَانُوا يْحِبُّوا يُرْجْمُوكْ، وإِنْتِ تْحِبْ تِرْجَعْ الغَادِي؟». ");
INSERT INTO aeu_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","جَاوِبْ يَسُوعْ: «يَاخِي النْهَارْ مُشْ فِيهْ أَثْنَاشِنْ سَاعَة؟ الِّي يِمْشِي فِي النْهَارْ مَا يِدَّعْثِرْشْ، عْلَى خَاطِرْ فِي النْهَارْ الدِّنْيَا ضَاوْيَة، ويْنَجِّمْ يْشُوفْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","آمَا الِّي يِمْشِي فِي اللِّيلْ يِدَّعْثِرْ، عْلَى خَاطْرُو مَافِيهِشْ نُورْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","وبَعْدْ زَادْ قَالِلْهُمْ: «صَاحِبْنَا لِعَازَرْ رْقَدْ، آمَا آنَا بِشْ نِمْشِي نْقَيْمُو». ");
INSERT INTO aeu_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","قَالُولُو التْلَامْذَة: «يَا سِيدْنَا، كَانُو رَاقِدْ، تَوْ يْقُومْ لَابَاسْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","وكَانْ يَسُوعْ يَحْكِي عْلَى مُوتْ لِعَازَرْ، آمَا هُومَا مْشَى فِي بَالْهُمْ يَحْكِي عَالنُّومْ العَادِي. ");
INSERT INTO aeu_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","وَلَّى قَالِلْهُمْ يَسُوعْ بْوْضُوحْ: «لِعَازَرْ مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","وعْلَى خَاطِرْكُمْ آنَا فَرْحَانْ الِّي مَاكُنْتِشْ غَادِي، بَاشْ إِنْتُومَا تَمْنُوا. أَيَّا بَرَّى نِمْشِيوْلُو». ");
INSERT INTO aeu_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","يَاخِي تُومَا الِّي يْسَمِّيوَهْ التُّومِي قَالْ لِلتْلَامْذَة الأُخْرِينْ: «هَيَّا أَحْنَا زَادَا نِمْشِيوْ ونْمُوتُوا مْعَاهْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ووَقْتِلِّي وْصُلْ يَسُوعْ، لْقَى الِّي لِعَازَرْ عَنْدُو أَرْبْعَة أَيَّامْ فِي القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","وكَانِتْ بِيتْ عَنْيَا مَا تِبْعِدْ عْلَى أُورْشَلِيمْ كَانْ حْكَايِةْ ثْلَاثَة كِيلُومَاتِرْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","وبَرْشَة يْهُودْ جَاوْ لْمَرْثَا ومَرْيِمْ بَاشْ يْعَزِّيوْهُمْ فِي خُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","وَقْتِلِّي سَمْعِتْ مَرْثَا الِّي يَسُوعْ جَايْ، خَرْجِتْ بَاشْ تْعَرِّضْلُو، آمَا مَرْيِمْ بْقَاتْ فِي الدَّارْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","قَالِتْ مَرْثَا لْيَسُوعْ: «يَا سِيدِي، كَانْ جِيتْ إِنْتِ هْنَا، رَاهُو خُويَا مَا مَاتِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","آمَا حَتَّى تَوَّا نَعْرِفْ الِّي أَيْ حَاجَة تُطْلُبْهَا مِنْ عَنْدْ اللَّهْ، يَعْطِيهَالِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","قَالِلْهَا يَسُوعْ: «خُوكْ بِشْ يْقُومْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","قَالِتْلُو مَرْثَا: «آنَا نَعْرِفْ الِّي هُوَّ بِشْ يْقُومْ فِي يُومْ القْيَامَة، فِي نْهَارْ الحْسَابْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","يَاخِي قَالِلْهَا يَسُوعْ: «آنَا هُوَّ القْيَامَة والحَيَاةْ. الِّي يَمِّنْ بِيَّا بِشْ يَحْيَا حَتَّى لَوْ كَانْ مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ولِّي هُوَّ حَيْ ويَمِّنْ بِيَّا عُمْرُو مَا يْمُوتْ. إِنْتِ تَمِّنْ بْهَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","قَالِتْلُو: «إِيْ نْعَمْ يَا سِيدِي، آنَا نَمِّنْ الِّي إِنْتِ هُوَّ المَسِيحْ إِبْنْ اللَّهْ الِّي جَايْ لِلْعَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","وبَعْدْمَا قَالِتْ الكْلَامْ هَاذَا، رَجْعِتْ مَرْثَا لِلدَّارْ وعَيْطِتْ لِأُخْتْهَا مَرْيِمْ وقَالْتِلْهَا فِي وْذِنْهَا: «المُعَلِّمْ هْنَا، ويْعَيِّطْلِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ودُوبْ مَا سَمْعِتْ مَرْيِمْ، قَامِتْ فِيسَعْ ومْشَاتْلُو، ");
INSERT INTO aeu_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","عْلَى خَاطِرْ يَسُوعْ مَزَّالْ مَا وْصِلْشْ لِلْقَرْيَة، آمَا قْعَدْ فِي البْلَاصَة الِّي عُرْضُتُّو فِيهَا مَرْثَا. ");
INSERT INTO aeu_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","اليْهُودْ الِّي كَانُوا فِي الدَّارْ يْعَزِّيُوا فِي مَرْيِمْ، شَافُوا الِّي هِيَّ قَامِتْ فِيسَعْ وخَرْجِتْ، يَاخِي تَبْعُوهَا، عْلَى خَاطِرْ مْشَى فِي بَالْهُمْ الِّي هِيَّ مَاشْيَة لِلْقْبَرْ بَاشْ تِبْكِي غَادِي. ");
INSERT INTO aeu_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","وكِي وِصْلِتْ مَرْيِمْ لِلْبْلَاصَة الِّي فِيهَا يَسُوعْ، تِرْمَاتْ عَنْدْ سَاقِيهْ دُوبْ مَا شَافِتُّو وقَالِتْلُو: «يَا سِيدِي، كَانْ جِيتْ هْنَا، رَاهُو خُويَا مَا مَاتِشْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ووَقْتِلِّي شَافْهَا يَسُوعْ تِبْكِي، واليْهُودْ الِّي جَاوْ مْعَاهَا يِبْكِيُوا، تْنَهِّدْ بِالقْوِيْ وظْهُرْ عْلِيهْ الحُزْنْ، ");
INSERT INTO aeu_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","وقَالْ: «وِينْ دْفِنْتُوهْ؟» قَالُولُو: «يَا سِيدْنَا، إِيجَا وشُوفْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ووَقْتْهَا بْكَى يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","يَاخِي اليْهُودْ قَالُوا: «شُوفُوا قَدَّاشْ كَانْ يْحِبُّو!». ");
INSERT INTO aeu_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","آمَا فَمَّة مِنْهُمْ الِّي قَالُوا: «هَاذَا الِّي حَلْ عِينِينْ الأَعْمَى، مَا كَانِشْ يْنَجِّمْشْ يْمَنَّعْ لِعَازَرْ مِالمُوتْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","وتْنَهِّدْ يَسُوعْ مِالحُزْنْ مَرَّة أُخْرَى. وبَعْدْ وْصُلْ لِلْقْبَرْ الِّي كَانْ عِبَارَة عْلَى مْغَارَة مْسَكْرَة بْحَجْرَة. ");
INSERT INTO aeu_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","قَالِلْهُمْ يَسُوعْ: «نَحِّيوْ الحَجْرَة!». قَالِتْلُو مَرْثَا أُخْتْ المَيِّتْ: «يَا سِيدِي، رَاهُو نْتِنْ عْلَى خَاطِرْ عَنْدُو أَرْبْعَة أَيَّامْ فِي القْبَرْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","جَاوِبْهَا يَسُوعْ: «مُشْ قُتْلِكْ إِذَا كَانْ تَمِّنْ تْشُوفْ مَجْدْ اللَّهْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","نَحَّاوْ الحَجْرَة، وهَزْ يَسُوعْ عِينِيهْ لِلسْمَاء وقَالْ: «يَا بَابَا، نُشْكْرِكْ عْلَى خَاطْرِكْ سْمَعْتْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","نَعْرِفْ الِّي إِنْتِ دِيمَا تِسْمَعْ صْلَاتِي، آمَا رَانِي قُلْتْ الكْلَامْ هَاذَا عْلَى خَاطِرْ النَّاسْ الِّي دَايْرِينْ بِيَّا، بَاشْ يَمْنُوا الِّي إِنْتِ بْعَثْتْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","وبَعْدْمَا قَالْ هَاذَا، عَيِّطْ بْصُوتْ عَالِي: «لِعَازَرْ، أُخْرُجْ!». ");
INSERT INTO aeu_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","وخْرَجْ المَيِّتْ ويْدِيهْ وسَاقِيهْ مْقَمْطِينْ، ووِجْهُو مَلْفُوفْ بْمَنْدِيلَة، يَاخِي قَالِلْهُمْ يَسُوعْ: «نَحِّيوْلُو قْمَايِطْ الكْفَنْ وخَلِّيوَهْ يِمْشِي!». ");
INSERT INTO aeu_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","وبَرْشَة مِاليْهُودْ الِّي جَاوْ بَاشْ يْعَزِّيْوْ مَرْيِمْ، وشَافُوا شَعْمَلْ يَسُوعْ، أَمْنُوا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","آمَا فَمَّة شْكُونْ مِنْهُمْ مْشَاوْ لِلْفِرِّيسِيِّينْ وحْكَاوْلْهُمْ عَلِّي عَمْلُو يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","وعَمْلُوا كْبَارْ الكَهَنَة والفِرِّيسِيِّينْ إِجْتِمَاعْ المَجْلِسْ الأَعْلَى، وقَالُوا: «شْنَعْمْلُوا؟ الرَّاجِلْ هَاذَا قَاعِدْ يَعْمِلْ فِي بَرْشَة مُعْجْزَاتْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","إِذَا كَانْ نْخَلِّيوْهْ هَكَّا، النَّاسْ الكُلْ بِشْ يَمْنُوا بِيهْ، ويْجِيوْ الرُّومَانْ ويِخْرْبُولْنَا الهَيْكِلْ وأُمِّتْنَا». ");
INSERT INTO aeu_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","وقَالْ وَاحِدْ مِنْهُمْ ولِّي هُوَّ قَيَافَا الِّي كَانْ الكَاهِنْ الكْبِيرْ فِي العَامْ هَاذَاكَا: «إِنْتُومَا مَا تَعْرْفُوا حَتَّى شَيْ! ");
INSERT INTO aeu_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ومَاكُمْشْ فَاهْمِينْ الِّي كِي يْمُوتْ وَاحِدْ بَرْكْ فِي عُوضْ الشَّعْبْ، خِيرْ مِلِّي تِدَّمِّرْ الأُمَّة الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ومَا قَالِشْ الكْلَامْ هَاذَاكَا مِنْ رَاسُو، آمَا قَالُّو عْلَى خَاطْرُو كَانْ الكَاهِنْ الكْبِيرْ فِي العَامْ هَاذَاكَا، وتْنَبَّأْ الِّي يَسُوعْ بِشْ يْمُوتْ فِي عُوضْ الأُمَّة، ");
INSERT INTO aeu_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ومُشْ فِي عُوضْ الأُمَّة هَاذِيكَا أَكَهَوْ، آمَا بَاشْ يْلِمْ وْلَادْ اللَّهْ المْفَرْقِينْ ويْرُدْهُمْ شَعْبْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ومِنْ نْهَارِتْهَا قَرْرُوا قَادِةْ اليْهُودْ بَاشْ يُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","يَاخِي يَسُوعْ بَطِّلْ مَا عَادِشْ يِمْشِي فِي وِسْطْ اليْهُودْ جْهَارْ، ومْشَى لِبْلَاصَة قْرِيبَة مِالصَّحْرَاء، لِمْدِينَة إِسْمْهَا أَفْرَايِمْ، وقْعَدْ غَادِي هُوَّ وتْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","وقْرُبْ عِيدْ الفِصْحْ اليْهُودِي، وطَلْعُوا بَرْشَة نَاسْ مِالأَرْيَافْ لِمْدِينِةْ أُورْشَلِيمْ بَاشْ يَعْمْلُوا فْرَايِضْ التَّطْهِيرْ قْبَلْ مَا يْجِي العِيدْ. ");
INSERT INTO aeu_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","وكَانُوا يْلَوْجُوا عْلَى يَسُوعْ، ويِسِأْلُوا فِي بْعَضْهُمْ وهُومَا فِي الهَيْكِلْ: «شْنُوَّة رَايْكُمْ؟ زَعْمَة يْجِي لِلْعِيدْ وَلَّا لَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","وكْبَارْ الكَهَنَة والفِرِّيسِيِّينْ سْبَقْ وعْطَاوْا أَمْرْ بَاشْ الِّي يَعْرِفْ يَسُوعْ وِينْ، يِعْلِمْ عْلِيهْ، بَاشْ يْشِدُّوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","قْبَلْ العِيدْ الفِصْحْ بْسِتَّة أَيَّامْ، جَاء يَسُوعْ لْبِيتْ عَنْيَا، وِينْ يُسْكُنْ لِعَازَرْ الِّي قَيْمُو مِالمُوتْ، ");
INSERT INTO aeu_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","يِاخِي حَضّْرُولُو العْشَاء. وكَانِتْ مَرْثَا لَاهْيَة بِيهُمْ فِي العْشَاء، وكَانْ لِعَازَرْ وَاحِدْ مِلِّي قَاعْدِينْ يِتْعَشَّاوْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","وخْذَاتْ مَرْيِمْ نُصْفْ إِيتْرَا مِنْ عِطْرْ النَّارْدِينْ الصَّافِي والغَالِي، ودَهْنِتْ بِيهْ سَاقِينْ يَسُوعْ، ومَسْحِتْهُمْ بِشْعَرْهَا. يَاخِي فَاحِتْ الرِّيحَة فِي الدَّارْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","آمَا وَاحِدْ مِنْ تْلَامِذْتُو الِّي هُوَّ يَهُوذَا الإِسْخَرْيُوطِي الِّي بِشْ يْخُونُو مْبَعِّدْ قَالْ: ");
INSERT INTO aeu_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«عْلَاشْ هَكَّا! كَانْ يْنَجِّمْ يِتْبَاعْ العِطْرْ هَاذَا بْشَهْرِيِّةْ عَامْ كَامِلْ، ويِتِعْطَى لِلْفْقَارَى!». ");
INSERT INTO aeu_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","قَالْ الكْلَامْ هَاذَا مُشْ عْلَى خَاطْرُو يْحِنْ عَالفْقَارَى، آمَا عْلَى خَاطْرُو كَانْ سَارِقْ، وصَنْدُوقْ الفْلُوسْ عَنْدُو، وكَانْ يِسْرِقْ مِلِّي يِتْحَطْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","قَالْ يَسُوعْ: «أَخْطَاهَا! رَاهِي اسْتَحْفْظِتْ عَالعِطْرْ هَاذَا لِلنْهَارْ الِّي بِشْ يِدْفْنُونِي فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","الفْقَارَى دِيمَا مْعَاكُمْ، آمَا آنَا مَانِيشْ بِشْ نَبْقَى دِيمَا مْعَاكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","وسَمْعُوا بَرْشَة يْهُودْ الِّي هُوَّ مَوْجُودْ فِي بِيتْ عَنْيَا، وَلَّاوْ جَاوْ مُشْ عْلَى خَاطْرُو هُوَّ أَكَهَوْ، آمَا زَادَا بِشْ يْشُوفُوا لِعَازَرَ الِّي قَيْمُو مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","يَاخِي كْبَارْ الكَهَنَة قَرْرُوا بَاشْ يُقْتْلُوا لِعَازَرَ زَادَا، ");
INSERT INTO aeu_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","عْلَى خَاطِرْ فِي جُرْتُو هُوَّ بَرْشَة يْهُودْ بْدَاوْ يِبْعْدُوا عْلِيهُمْ ويَمْنُوا بْيَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ومِنْ غُدْوَة، النَّاسْ الِّي جَاوْ لْعِيدْ الفِصْحْ ولِّي كَانْ عْدَدْهُمْ كْبِيرْ، سَمْعُوا إِنُّو يَسُوعْ فِي طْرِيقُو لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","يَاخِي هَزُّوا سْعَفْ النْخَلْ وخَرْجُوا بَاشْ يِسْتَقْبْلُوهْ، وكَانُوا يْعَيْطُوا: «أُوصَنَّا! مُبَارَكْ الِّي جَايْ بْإِسْمْ الرَّبْ! ومُبَارَكْ مَلِكْ إِسْرَائِيلْ!» ");
INSERT INTO aeu_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ولْقَى يَسُوعْ جَحْشْ، ورْكِبْ عْلِيهْ كِيفْ مَاهُو مَكْتُوبْ: ");
INSERT INTO aeu_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","«مَا تْخَافِشْ يَا بِنْتْ صِهْيَوْنْ، المَلِكْ مْتَاعِكْ جَايِكْ رَاكِبْ عْلَى جَحْشْ وِلْدْ بْهِيمَة». ");
INSERT INTO aeu_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","فِي وَقْتْهَا، التْلَامْذَة مَا فِهْمُوشْ آشْ قَاعِدْ يْصِيرْ. آمَا بَعْدْمَا تْمَجِّدْ يَسُوعْ، تْذَكْرُوا الِّي الآيَة هَاذِي تْكِتْبِتْ عْلِيهْ، ولِّي النَّاسْ عَمْلُوا هَاذَا عْلَى خَاطْرُو. ");
INSERT INTO aeu_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","والنَّاسْ الِّي كَانُوا مْعَاهْ وَقْتِلِّي قَيِّمْ لِعَازَرَ مِالمُوتْ وخَرْجُو مِالقْبَرْ شِهْدُوا بِلِّي صَارْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","وبَرْشَة نَاسْ خَرْجُوا بَاشْ يِسْتَقْبْلُوهْ، عْلَى خَاطِرْهُمْ سَمْعُوا الِّي هُوَّ عْمَلْ المُعْجْزَة هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","يَاخِي قَالُوا الفِرِّسِيِّينْ لِبْعَضْهُمْ: «شُفْتُوا! هَانَا مَا وْصِلْنَا لْشَيْ. أَهَوْكَا النَّاسْ الكُلْ وَلَّاوْ يْتَبْعُوا فِيهْ!». ");
INSERT INTO aeu_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","وكَانْ مِنْ بِينْ الِّي جَاوْ لْأُورْشَلِيمْ بَاشْ يِعْبْدُوا اللَّهْ فِي العِيدْ نَاسْ مُشْ يْهُودْ، ");
INSERT INTO aeu_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","مْشَاوْ لْفِيلِۑُّسْ، الِّي كَانْ مِنْ بِيتْ صَيْدَا فِي مَنْطَقْةْ الجَلِيلْ وقَالُولُو: «يَا سِيدْنَا نْحِبُّوا نْشُوفُوا يَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","مْشَى فِيلِۑُّسْ وقَالْ لْأَنْدَرَاوُسْ، ومْشَاوْ مْعَ بْعَضْهُمْ وقَالُوا لْيَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","جَاوِبْهُمْ يَسُوعْ: «جَاء الوَقْتْ الِّي بِشْ يِتْمَجِّدْ فِيهْ إِبْنْ الإِنْسَانْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","الحَقْ الحَقْ نْقُولِلْكُمْ: إِذَا كَانْ القَمْحَةْ مَا اطِّيحِشْ فِي الأَرْضْ وتْمُوتْ، رَاهِي تِبْقَى وَحَّدْهَا. آمَا إِذَا كَانْ مَاتِتْ، رَاهِي تْجِيبْ بَرْشَة قَمْحَاتْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","الِّي يْحِبْ حْيَاتُو يِخْسِرْهَا، ولِّي يُنْكُرْهَا فِي الدِّنْيَا هَاذِي رَاهُو يَحْفِظْهَا لِلْحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","الِّي يْحِبْ يِخْدِمْنِي يْتَبَّعْنِي، ووِينْ نْكُونْ آنَا يْكُونْ هُوَّ زَادَا. ولِّي يِخْدِمْنِي يِكْرْمُو الآبْ». ");
INSERT INTO aeu_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","«آنَا تَوَّا مْشَوِّشْ. آشْ بِشْ نْقُولْ؟ \"يَا بَابَا، نَجِّينِي مِالسَّاعَة هَاذِي\"؟ لَا! تِي آنَا جِيتْ بِالذِّمَة عْلَى خَاطِرْ السَّاعَة هَاذِي. ");
INSERT INTO aeu_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","يَا بَابَا مَجِّدْ إِسْمِكْ!». يَاخِي صُوتْ مِالسْمَاء قَالْ: «مَجِّدْتُو، وبِشْ نْزِيدْ نْمَجْدُو!». ");
INSERT INTO aeu_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","النَّاسْ الِّي كَانُوا غَادِي وسَمْعُوا الصُّوتْ قَالُوا: «هَاذَا صُوتْ رْعَدْ!» وجْمَاعَة أُخْرِينْ قَالُوا: «كَلْمُو مَلَاكْ!». ");
INSERT INTO aeu_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","جَاوِبْ يَسُوعْ وقَالْ: «الصُّوتْ هَاذَا مَا جَاشْ لِيَّا آنَا، آمَا لِيكُمْ إِنْتُومَا. ");
INSERT INTO aeu_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","تَوَّا جَاء وَقْتْ الحُكْمْ عَالعَالِمْ. تَوَّا بِشْ يِطَّرِّدْ الِّي يُحْكُمْ فِي العَالِمْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","وَقْتِلِّي يِرْفْعُونِي مِالأَرْضْ ونِتْعَلِّقْ، بِشْ نْقَرِّبْ النَّاسْ الكُلْ لِيَّا». ");
INSERT INTO aeu_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","قَالْ الكْلَامْ هَاذَا، وكَانْ يُقْصُدْ بِيهْ الطَّرِيقَة الِّي بِشْ يْمُوتْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","جَاوْبُوهْ النَّاسْ: «نَعْرْفُوا مِالشَرِيعَة الِّي المَسِيحْ يِبْقَى حَيْ لِلْأَبَدْ. مَالَا كِيفَاشْ إِنْتِ تْقُولْ: \"يِلْزِمْ إِبْنْ الإِنْسَانْ يِتْعَلَّقْ؟\" يَاخِي شْكُونُو إِبْنْ الإِنْسَانْ هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","قَالِلْهُمْ يَسُوعْ: «النُّورْ بِشْ يْزِيدْ يِبْقَى مْعَاكُمْ مُدَّة قْصِيرَة، مَالَا إِمْشِيوْ مَادَامْ عَنْدْكُمْ النُّورْ، بَاشْ مَا يَهْبِطْشْ عْلِيكُمْ الظْلَامْ. خَاطِرْ الِّي يِمْشِي فِي الظْلَامْ مَا يَعْرِفْشْ عْلَى رُوحُو وِينْ مَاشِي. ");
INSERT INTO aeu_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","مَادَامْ النُّورْ مْعَاكُمْ، أَمْنُوا بِالنُّورْ، بَاشْ تْوَلِّيوْ وْلَادْ النُّورْ». وبَعْدْمَا قَالِلْهُمْ يَسُوعْ الكْلَامْ هَاذَا، مْشَى وتْخَبَّى عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ورَغْمِلِّي عْمَلْ بَرْشَة مُعْجْزَاتْ قُدَّامْ عِينِيهُمْ، مَا أَمْنُوشْ بِيهْ، ");
INSERT INTO aeu_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","وهَكَّا تْحَقَّقْ الِّي قَالُّو النَّبِيْ إِشَعْيَاءْ: «يَا رَبْ، شْكُونْ الِّي أَمَّنْ بِكْلَامْنَا؟ ولِشْكُونْ ظُهْرِتْ قُوِّةْ الرَّبْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ومَا نَجْمُوشْ يَمْنُوا، عْلَى خَاطِرْ إِشَعْيَاءْ قَالْ زَادَا: ");
INSERT INTO aeu_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","«عْمَالْهُمْ عِينِيهُمْ، وقَسَّالْهُمْ قْلُوبْهُمْ، بَاشْ مَا يْشُوفُوشْ بْعِينِيهُمْ، ومَا يِفْهْمُوشْ بِقْلُوبْهُمْ، ومَا يْتُوبُوشْ بَاشْ نِشْفِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","قَالْ إِشَعْيَاءْ الكْلَامْ هَاذَا وَقْتِلِّي شَافْ مَجْدْ يَسُوعْ وحْكَى عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","بِالرَّغْمْ مِنْ هَاذَا الكُلْ، بَرْشَة مِنْ قَادِةْ اليْهُودْ أَمْنُوا بْيَسُوعْ. آمَا مَا اعْتَرْفُوشْ بِيهْ جْهَارْ، عْلَى خَاطِرْهُمْ خَايْفِينْ لَا الفِرِّيسِيِّينْ يْطَرْدُوهُمْ مِالمَعْبِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","وحَبُّوا يْرَضِّيوْ النَّاسْ أَكْثِرْ مِلِّي يْرَضِّيوْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","يَاخِي قَالْ يَسُوعْ بْصُوتْ عَالِي: «الِّي يَمِّنْ بِيَّا، مَا يَمِّنْشْ بِيَّا آنَا بَرْكْ، آمَا يَمِّنْ بِلِّي بْعَثْنِي زَادَا. ");
INSERT INTO aeu_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ولِّي يْرَانِي يْرَى الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","آنَا جِيتْ نُورْ لِلْعَالِمْ، بَاشْ الِّي يَمِّنْ بِيَّا مَا يَبْقَاشْ فِي الظْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ولِّي يِسْمَعْ كْلَامِي ومَا يْطَبْقُوشْ، مَا نُحْكُمْشْ عْلِيهْ، عْلَى خَاطِرْ جِيتْ بِشْ نْجِّي العَالِمْ، مُشْ بَاشْ نُحْكُمْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","الِّي مَا يِقْبِلْنِيشْ ومَا يِقْبِلْشْ كْلَامِي، عَنْدُو شْكُونْ يُحْكُمْ عْلِيهْ: الكْلَامْ الِّي قُلْتُو هُوَّ الِّي يُحْكُمْ عْلِيهْ نْهَارْ الحْسَابْ، ");
INSERT INTO aeu_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","عْلَى خَاطِرْ آنَا مَا قُلْتْ حَتَّى شَيْ مِنْ عَنْدِي، آمَا الآبْ الِّي بْعَثْنِي وَصَّانِي آشْ بَاشْ نْقُولْ ونِتْكَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","وآنَا نَعْرِفْ الِّي وْصِيْتُو تَعْطِي الحَيَاةْ الأَبَدِيَّة. والكْلَامْ الِّي نْقُولْ فِيهْ آنَا، هُوَّ كِيمَا قَالْهُولِي الآبْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","قْبَلْ عِيدْ الفِصْحْ، يَسُوعْ الِّي كَانْ يَعْرِفْ إِنُّو سَاعْتُو جَاتْ بَاشْ يِمْشِي مِالدِّنْيَا هَاذِي لِلْآبْ، حَبْ الِّي تَابْعِينُو فِي الدِّنْيَا هَاذِي، حَبْهُمْ لْأَقْصَى دَرْجَة. ");
INSERT INTO aeu_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ووَقْتِلِّي كَانْ يِتْعَشَّى مْعَ تْلَامِذْتُو، إِبْلِيسْ كَانْ حَاطِطْ فِي قَلْبْ يَهُوذَا وِلْدْ سِمْعَانْ الإِسْخَرْيُوطِي إِنُّو يْخُونُو. ");
INSERT INTO aeu_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ويَسُوعْ كَانْ يَعْرِفْ الِّي الآبْ عْطَاهْ سُلْطَة عْلَى كُلْ شَيْ، وإِنُّو جَاء مِنْ عَنْدْ اللَّهْ وبِشْ يِرْجَعْ لِلَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","وَلَّا قَامْ عَالعْشَاء، ونَحَّى بَرْنُوسُو، وخْذَا مَنْشْفَة واتْحَزِّمْ بِيهَا، ");
INSERT INTO aeu_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","وصَبْ مَاء فِي بَانُو، وبْدَا يَغْسِلْ فِي سَاقِينْ التْلَامْذَة ويْنَشِّفْ فِيهُمْ بِالمَنْشْفَة المِتْحَزِّمْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","وَقْتِلِّي وْصُلْ لْسِمْعَانْ بُطْرُسْ، قَالُّو سِمْعَانْ: «يَاسِيدِي، إِنْتِ تَغْسَلِّي سَاقَيَّا؟». ");
INSERT INTO aeu_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","جَاوْبُو يَسُوعْ: «إِنْتِ تَوَّا مَاكِشْ فَاهِمْ آشْ قَاعِدْ نَعْمِلْ، آمَا تَوْ تِفْهِمْ مْبَعِّدْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","قَالُّو بُطْرُسْ: «مُسْتَحِيلْ تَغْسِلِّي سَاقَيَّا». جَاوْبُو يَسُوعْ: «إِذَا مَا نَغْسِلِّكْشْ سَاقِيكْ مُشْ بِشْ تْكُونْ فَمَّة حَاجَة تُرْبْطِكْ بِيَّا». ");
INSERT INTO aeu_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","يَاخِي قَالُّو سِمْعَانْ بُطْرُسْ: «مَالَا يَا سِيدِي، مُشْ كَانْ سَاقَيَّا بَرْكْ، آمَا يْدَيَّا ورَاسِي زَادَا». ");
INSERT INTO aeu_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","قَالُّو يَسُوعْ: «الِّي يَغْسِلْ بَدْنُو يْوَلِّي الكُلُّو طَاهِرْ، ومَا يِسْتْحَقْ كَانْ لِغْسِيلْ سَاقِيهْ. إِنْتُومَا طَاهْرِينْ، آمَا مُشْ الكُلْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ويَسُوعْ كَانْ يَعْرِفْ شْكُونْ الِّي بِشْ يْخُونُو. هَاذَاكَا عْلَاشْ قَالْ: «مَاكُمْشْ الكُلْكُمْ طَاهْرِينْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","وبَعْدْمَا غْسَلِّلْهُمْ سَاقِيهُمْ، لْبِسْ بَرْنُوسُو ورْجَعْ لِبْلَاصْتُو، وقَالِلْهُمْ: «يَاخِي فَاهْمِينْ الِّي عْمَلْتْهُولْكُمْ؟ ");
INSERT INTO aeu_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","إِنْتُومَا تْنَادِيوْلِي يَا مُعَلِّمْ ويَا سِيدِي، وعَنْدْكُمْ الحَقْ عْلَى خَاطِرْنِي آنَا مُعَلِّمْ وسَيِّدْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","إِذَا كَانْ آنَا المُعَلِّمْ والسَيِّدْ غْسَلْتِلْكُمْ سَاقِيكُمْ، مَالَا إِنْتُومَا زَادَا يِلْزِمْكُمْ تَغْسْلُوا سَاقِينْ بْعَضْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","وهَانِي كُنْتِلْكُمْ مِثَالْ بَاشْ اتَّبْعُوهْ، وتَعْمْلُوا إِنْتُومَا زَادَا كِيمَا عْمَلْتِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","الحَقْ الحَقْ نْقُولِلْكُمْ: العَبْدْ مُشْ أَعْظِمْ مِنْ سِيدُو، ولَا المَرْسُولْ أَعْظِمْ مِلِّي بَعْثُو. ");
INSERT INTO aeu_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","مَادَامْكُمْ عْرَفْتُوا هَاذَا، صَحَّة لِيكُمْ كَانْ اطَّبْقُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","«آنَا مَانِيشْ نَحْكِي عْلِيكُمْ الكُلْ، آنَا نَعْرِفْ الِّي اخْتَرْتْهُمْ. آمَا لَازِمْ يْتِمْ الِّي قَالِتُّو الكْتُبْ المُقَدْسَة: \"الِّي كْلَا خُبْزِي، دَارْ عْلِيَّا\". ");
INSERT INTO aeu_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","«نْقُولِلْكُمْ هَاذَا تَوَّا قْبَلْ مَا يْصِيرْ، بَاشْ وَقْتِلِّي يْصِيرْ تَمْنُوا الِّي آنَا هُوَّ. ");
INSERT INTO aeu_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","الحَقْ الحَقْ نْقُولِلْكُمْ: الِّي يِقْبِلْ الِّي نَبْعْثُو يِقْبِلْنِي، ولِّي يِقْبِلْنِي، يِقْبِلْ الِّي بْعَثْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","وبَعْدْمَا قَالْ يَسُوعْ الكْلَامْ هَاذَا، تْقَلِّقْ وقَالْ: «الحَقْ الحَقْ نْقُولِلْكُمْ: وَاحِدْ مِنْكُمْ بِشْ يْخُونِّي». ");
INSERT INTO aeu_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","يَاخِي خَزْرُوا التْلَامْذَة لِبْعَضْهُمْ وهُومَا حَايْرِينْ مُشْ عَارْفِينْ فِي شْكُونْ كَانْ يُقْصُدْ بِكْلَامُو. ");
INSERT INTO aeu_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ووَاحِدْ مِالتْلَامْذَة، الِّي يَسُوعْ يْحِبُّو، كَانْ مِتَّكِّي بْجَنْبُو. ");
INSERT INTO aeu_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","هْمِزْلُو سِمْعَانْ بُطْرُسْ بَاشْ يِسْأْلُو فِي شْكُونْ كَانْ يُقْصُدْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ومَالْ التِّلْمِيذْ عْلَى صْدِرْ يَسُوعْ وسِأْلُو: «شْكُونُو هُوَّ، يَا سِيدِي؟» ");
INSERT INTO aeu_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","جَاوِبْ يَسُوعْ: «هُوَّ الِّي نْغَطِّسْلُو اللُّقْمَة ونَعْطِيهَالُو!» وغَطِّسْ يَسُوعْ ڨِدْمِةْ الخُبْزْ وعْطَاهَا لْيَهُوذَا وِلْدْ سِمْعَانْ الإِسْخَرْيُوطِي. ");
INSERT INTO aeu_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","وبَعْدْمَا كْلَاهَا دْخَلْ فِيهْ الشِّيطَانْ. يَاخِي قَالُّو يَسُوعْ: «الِّي نَاوِي تَعْمْلُو، أَعْمْلُو فِيسَعْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ومَا فْهِمْ حَتَّى وَاحِدْ مِلِّي يِتْعَشَّاوْ مْعَاهْ عْلَاشْ قَالُّو الكْلَامْ هَاذَاكَا. ");
INSERT INTO aeu_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","وعْلَى خَاطِرْ يَهُوذَا كَانْ مَسْؤُولْ عْلَى صَنْدُوقْ الفْلُوسْ، مْشَى فِي بَالْهُمْ الِّي يَسُوعْ وَصَّاهْ بَاشْ يِشْرِي الِّي يِسْتْحَقُّوهْ لِلْعِيدْ، وَلَّا بَاشْ يَعْطِي حَاجَة لِلْفْقَارَى. ");
INSERT INTO aeu_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","وكْلَا يَهُوذَا الڨِدْمَة وخْرَجْ بِالوَقْتْ. وكَانِتْ الدِّنْيَا لِيلْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ووَقْتِلِّي خْرَجْ يَهُوذَا قَالْ يَسُوعْ: «تَوَّا تْمَجِّدْ إِبْنْ الإِنْسَانْ، وتْمَجِّدْ اللَّهْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ومَادَامْ اللَّهْ تْمَجِّدْ فِيهْ، رَاهُو اللَّهْ بِيدُو بِشْ يْمَجِّدْ إِبْنْ الإِنْسَانْ زَادَا، وبِشْ يْمَجْدُو عْلَى قْرِيبْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","يَا وْلَادِي، آنَا بِشْ نْزِيدْ نَبْقَى مْعَاكُمْ مُدَّة قْصِيرَة. بِشْ تْلَوْجُوا عْلِيَّا، آمَا الِّي قُلْتُو لِلْيْهُودْ نْقُولْهُولْكُمْ إِنْتُومَا تَوَّا: \"رَاكُمْ مَا تْنَجْمُوشْ تْجِيوْ لِلْبْلَاصَة الِّي آنَا مَاشِيلْهَا\". ");
INSERT INTO aeu_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","نْوَصِّيكُمْ وْصِيَّة جْدِيدَة: حِبُّوا بْعَضْكُمْ. كِيفْ مَا آنَا حَبِّيتْكُمْ إِنْتُومَا زَادَا حِبُّوا بْعَضْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","إِذَا كَانْ عَنْدْكُمْ مْحَبَّة لِبْعَضْكُمْ، النَّاسْ الكُلْ بِشْ يَعْرْفُوا الِّي إِنْتُومَا تْلَامِذْتِي». ");
INSERT INTO aeu_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","قَالُّو سِمْعَانْ بُطْرُسْ: «يَا سِيدِي، إِنْتِ وِينْ مَاشِي؟». جَاوْبُو يَسُوعْ: « تَوَّا مَا تْنَجِّمْشْ اتَّبَّعْنِي لِلْبْلَاصَة الِّي مَاشِيلْهَا، آمَا يْجِيكْ نْهَارْ واتَّبَّعْنِي». ");
INSERT INTO aeu_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","يَاخِي قَالُّو بُطْرُسْ: «يَا سِيدِي، عْلَاشْ مَا انَّجَّمْشْ نْتَبْعِكْ تَوَّا؟ آنَا مُسْتْعَدْ نْمُوتْ عْلَى خَاطْرِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","جَاوْبُو يَسُوعْ: « إِنْتِ مُسْتْعَدْ بَاشْ تْمُوتْ عْلَى خَاطْرِي؟ الحَقْ الحَقْ نْقُلِّكْ: مَا يْصِيحْ السَّرْدُوكْ كَانْ مَا تْكُونْ نْكَرْتْنِي ثْلَاثَة مَرَّاتْ». ");
INSERT INTO aeu_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","«مَا تْخَلِّيوْشْ قْلُوبْكُمْ تِتْحَيِّرْ. إِنْتُومَا تَمْنُوا بِاللَّهْ، مَالَا أَمْنُوا بِيَّا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","عَنْدْ بَابَا فَمَّة بَرْشَة دْيَارْ. كَانْ جَاء مُشْ بِالحَقْ، رَانِي قُلْتِلْكُمْ. وآنَا مَاشِي بَاشْ نْحَضْرِلْكُمْ بْلَاصَة. ");
INSERT INTO aeu_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","وكِي نِمْشِي نْحَضْرِلْكُمْ بْلَاصَة، نِرْجَعْ ونْهِزْكُمْ، بَاشْ تْكُونُوا وِينْ مَا نْكُونْ آنَا. ");
INSERT INTO aeu_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","وإِنْتُومَا تَعْرْفُوا الطْرِيقْ الِّي يْوَصِّلْ لِلْبْلَاصَة الِّي آنَا مَاشِيلْهَا». ");
INSERT INTO aeu_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","قَالُّو تُومَا: «يَا سِيدِي، أَحْنَا مَا نَعْرْفُوكْشْ لْوِينْ مَاشِي، كِيفَاشْ تْحِبْنَا نَعْرْفُوا الطْرِيقْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","قَالُّو يَسُوعْ: «آنَا هُوَّ الطْرِيقْ والحَقْ والحَيَاةْ، حَتَّى حَدْ مَا يْجِي لِلْآبْ إِلَّا عْلَى طْرِيقِي. ");
INSERT INTO aeu_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","كَانْ عْرَفْتُونِي رَاكُمْ عْرَفْتُوا بَابَا زَادَا. ومِنْ تَوَّا إِنْتُومَا تَعْرْفُوهْ وزَادَا شُفْتُوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","قَالُّو فِيلِۑُّسْ: «يَا سِيدِي، وَرِّينَا الآبْ وهَاذَا يِكْفِينَا». ");
INSERT INTO aeu_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","قَالُّو يَسُوعْ: «آنَا مْعَاكُمْ الوَقْتْ هَاذَا الكُلْ، ومَا عْرَفْتْنِيشْ يَا فِيلِۑُّسْ؟ الِّي شَافْنِي رَاهُو شَافْ الآبْ، مَالَا كِيفَاشْ تْقُولْ \"وَرِّينَا الآبْ\"؟ ");
INSERT INTO aeu_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","يَاخِي مَا تَمِّنْشْ الِّي آنَا فِي الآبْ والآبْ فِيَّا؟ الكْلَامْ الِّي نْقُلْكُمْ فِيهْ مُشْ مِنْ عَنْدِي، والأَعْمَالْ الِّي نَعْمِلْهَا رَاهُو يَعْمِلْ فِيهَا الآبْ الِّي فِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","صَدْقُونِي كِي نْقُلْكُمْ: آنَا فِي الآبْ والآبْ فِيَّا. وَلَّا عَالأَقَلْ صَدْقُونِي عْلَى خَاطِرْ الأَعْمَالْ الِّي عْمَلْتْهَا. ");
INSERT INTO aeu_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","الحَقْ الحَقْ نْقُلْكُمْ: الِّي يَمِّنْ بِيَّا هُوَّ زَادَا يَعْمِلْ الأَعْمَالْ الِّي نَعْمِلْ فِيهَا، ويَعْمِلْ حَتَّى أَعْظِمْ مِنْهَا، عْلَى خَاطِرْنِي مَاشِي لْبَابَا. ");
INSERT INTO aeu_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","كُلْ مَا تُطْلْبُوهْ بْإِسْمِي نَعْمْلُو، بَاشْ يِتْمَجِّدْ الآبْ عْلَى طْرِيقْ الإِبْنْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","وكَانْ تُطْلْبُوا مِنِّي حَاجَة بْإِسْمِي، نَعْطِيهَالْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«كَانْ تْحِبُّونِي، تَوَّا اطَّبْقُوا الِّي وَصِّيتْكُمْ بِيهْ ");
INSERT INTO aeu_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","وآنَا بِشْ نُطْلُبْ مِالآبْ يَعْطِيكُمْ وَاحِدْ آخَرْ يْعَاوِنْكُمْ، ويِبْقَى مْعَاكُمْ لِلْأَبَدْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","هُوَّ رُوحْ الحَقْ الِّي نَاسْ العَالِمْ هَاذَا مَا يْنَجْمُوشْ يِقْبْلُوهْ. عْلَى خَاطِرْ مَا يْشُوفُوهِشْ ومَا يَعْرْفُوهِشْ. آمَا إِنْتُومَا تَعْرْفُوهْ عْلَى خَاطْرُو مْعَاكُمْ وبِشْ يْكُونْ فِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","مَانِيشْ بِشْ نْخَلِّيكُمْ يْتَامَى آمَا تَوَّا نَرْجْعِلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","بَعْدْ شْوَيَّة، النَّاسْ الِّي فِي العَالِمْ هَاذَا مَا عَادِشْ بِشْ يْشُوفُونِي، آمَا إِنْتُومَا تْشُوفُونِي. وعْلَى خَاطِرْنِي آنَا حَيْ، إِنْتُومَا زَادَا بِشْ تَحْيَاوْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","وفِي النْهَارْ هَاذَاكَا بِشْ تَعْرْفُوا الِّي آنَا فِي بَابَا، ولِّي إِنْتُومَا فِيَّا وآنَا فِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","الِّي يِقْبِلْ الوْصَايَا مْتَاعِي ويَعْمِلْ بِيهَا، هَاذَاكَا هُوَّ الِّي يْحِبْنِي. ولِّي يْحِبْنِي يْحِبُّو بَابَا، وآنَا زَادَا نْحِبُّو ونْظَهَّرْلُو رُوحِي». ");
INSERT INTO aeu_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","يَاخِي قَالُّو يَهُوذَا آخِرْ، مُشْ يَهُوذَا الإِسْخَرْيُوطِي: «يَا سِيدِي، كِيفَاشْ تْظَهْرِلْنَا رُوحِكْ ومَا تْظَهَّرْهَاشْ لِلْعَالِمْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","جَاوْبُو يَسُوعْ: «الِّي يْحِبْنِي يْطِيعْ كْلَامِي، وبَابَا زَادَا يْحِبُّو، ونْجِيُوهْ ونُسْكْنُوا مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ولِّي مَا يْحِبْنِيشْ مَا يِسْمَعْشْ كْلَامِي. والكْلَامْ الِّي سْمَعْتُوهْ مُشْ مِنْ عَنْدِي، آمَا مِنْ عَنْدْ الآبْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","«قُلْتِلْكُمْ هَاذَا الكُلْ وآنَا مَزِّلْتْ مْعَاكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","آمَا المُعِينْ، الِّي هُوَّ الرُّوحْ القُدُسْ الِّي بِشْ يَبْعْثُو الآبْ بْإِسْمِي، هُوَّ الِّي بِشْ يْعَلِّمْكُمْ كُلْ شَيْ، ويْذَكَّرْكُمْ بِلِّي قُلْتْهُولْكُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","«نْخَلِّيلْكُمْ سَلَامْ، نَعْطِيكُمْ سَلَامِي. السَّلَامْ الِّي نَعْطِيهُولْكُمْ آنَا، مُشْ كِيفْ الِّي يَعْطِيهْ العَالِمْ. مَالَا مَا تْخَلِّيوْشْ قْلُوبْكُمْ تِتْحَيِّرْ وتْخَافْ. ");
INSERT INTO aeu_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","إِنْتُومَا سْمَعْتُونِي كِي قُلْتِلْكُمْ: آنَا مَاشِي وبِشْ نَرْجْعِلْكُمْ. كَانْكُمْ تْحِبُّونِي تَوَّا تِفْرْحُوا الِّي آنَا مَاشِي لِلْآبْ، عْلَى خَاطِرْ الآبْ أَعْظِمْ مِنِّي. ");
INSERT INTO aeu_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","قُلْتِلْكُمْ الحَاجَاتْ هَاذِي قْبَلْ مَا تْصِيرْ، بَاشْ وَقْتِلِّي تْصِيرْ تَمْنُوا. ");
INSERT INTO aeu_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","مَا عَادِشْ بِشْ نِتْكَلَّمْ مْعَاكُمْ بَرْشَة، عْلَى خَاطِرْ الِّي يُحْكُمْ فِي العَالِمْ هَاذَا، بِشْ يْجِي. ومَا عَنْدُو حَتَّى سُلْطَة عْلِيَّا، ");
INSERT INTO aeu_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","آمَا لَازِمْ النَّاسْ الِّي فِي العَالِمْ هَاذَا يَعْرْفُوا الِّي آنَا نْحِبْ الآبْ ونَعْمِلْ الِّي وَصَّانِي عْلِيهْ. قُومُوا نِمْشِيوْ مِنْ هْنَا!» ");
INSERT INTO aeu_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«آنَا هُوَّ العِنْبَة الحَقِيقِيَّة وبَابَا هُوَّ الِّي لَاهِي بِالعْنِبْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","كُلْ عُرْفْ فِيَّا مَا يْجِيبِشْ غَلَّة يْقُصُّو، ولِّي يْجِيبْ غَلَّة يُزْبْرُو بَاشْ يْجِيبْ غَلَّة أَكْثِرْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","إِنْتُومَا تَوَّا طَاهْرِينْ عْلَى خَاطِرْ الكْلَامْ الِّي قُلْتْهُولْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","إِثْبْتُوا فِيَّا كِيمَا نِثْبِتْ فِيكُمْ. وكِيمَا العُودْ مَا يْنَجِّمْ يْجِيبْ غَلَّة كَانْ مَا يِثْبِتْ فِي العِنْبَة، إِنْتُومَا زَادَا مَا تْنَجْمُوا تْجِيبُوا غَلَّة كَانْ مَا تِثْبْتُوا فِيَّا. ");
INSERT INTO aeu_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","«آنَا العِنْبَة وإِنْتُومَا الأَعْرَافْ، الِّي يِثْبِتْ فِيَّا وآنَا نِثْبِتْ فِيهْ، يْجِيبْ بَرْشَة غَلَّة. عْلَى خَاطِرْ، بْلَاشْ بِيَّا مَا تْنَجْمُوا تَعْمْلُوا حَتَّى شَيْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","الِّي مَا يِثْبِتْشْ فِيَّا، يِتْرْمَى لْبَرَّا كِالعُرْفْ اليَابِسْ. والأَعْرَافْ اليَابْسَة تِتْلَمْ وتِتْرْمَى فِي النَّارْ بَاشْ تِتْحْرَقْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","كَانْ تِثْبْتُوا فِيَّا ويِثْبِتْ كْلَامِي فِيكُمْ، تُطْلْبُوا الِّي تْحِبُّوا عْلِيهْ تَاخْذُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","وَقْتِلِّي تْجِيبُوا بَرْشَة غَلَّة، هَاذَا يْمَجِّدْ بَابَا، وهَكَّا تْوَرِّيوْا الِّي إِنْتُومَا تْلَامِذْتِي بِالحَقْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","«كِيفْ مَا حَبْنِي الآبْ آنَا زَادَا حَبِّيتْكُمْ، مَالَا إِثْبْتُوا فِي مْحَبْتِي. ");
INSERT INTO aeu_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","كَانْ اطِّيعُوا الوْصَايَا مْتَاعِي، تِثْبْتُوا فِي مْحَبْتِي، كِيفْ مَا آنَا عْمَلِتْ بِالوْصَايَا مْتَاعْ بَابَا، ونِثْبِتْ فِي مْحَبْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","قُلْتِلْكُمْ هَاذَا بَاشْ تْدُومْ فَرْحْتِي فِيكُمْ، وتْكُونْ فَرْحِتْكُمْ كَامْلَة. ");
INSERT INTO aeu_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","هَاذِي هِيَّ وْصِيْتِي: حِبُّوا بْعَضْكُمْ كِيفْ مَا آنَا حَبِّيتْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","مَا فَمَّاشْ مْحَبَّة أَكْبِرْ مِنْ إِنُّو الوَاحِدْ يْضَحِّي بِحْيَاتُو عْلَى خَاطِرْ حْبَابُو. ");
INSERT INTO aeu_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","إِنْتُومَا حْبَابِي كَانْ تَعْمْلُوا الِّي نْوَصِّيكُمْ بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","مَا عَادِشْ نْسَمِّيكُمْ عَبِيدْ، عْلَى خَاطِرْ العَبْدْ مَا يَعْرِفْشْ آشْ يَعْمِلْ سِيدُو. آمَا سَمِّيتْكُمْ حْبَابِي، عْلَى خَاطِرْنِي حْكِيتِلْكُمْ عَلِّي سْمَعْتُو مِنْ عَنْدْ بَابَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","مُشْ إِنْتُومَا الِّي خْتَرْتُونِي، آنَا الِّي خْتَرْتْكُمْ وكَلَّفْتْكُمْ بَاشْ تِمْشِيوْ وتُثْمْرُوا وثْمَرْكُمْ يْدُومْ. وَقْتْهَا يَعْطِيكُمْ الآبْ كُلْ مَا تُطْلْبُوهْ بْإِسْمِي. ");
INSERT INTO aeu_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","وهَاذِي هِيَّ وْصِيْتِي: حِبُّوا بْعَضْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«وكَانْ كْرَهْكُمْ العَالِمْ، أَعْرْفُوا الِّي هُوَّ كْرَهْنِي قْبَلْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","كَانْ جِيتُوا مِالعَالِمْ، رَاهُو العَالِمْ يْحِبْكُمْ كِيمَا يْحِبْ الِّي تَابْعِينُو، آمَا عْلَى خَاطِرْ آنَا خْتَرْتْكُمْ مِالعَالِمْ، إِنْتُومَا مَا عَادِشْ تَابْعِينُو، هَاذَاكَا عْلَاشْ هُوَّ يَكْرَهْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","تْذَكْرُوا الكْلَامْ الِّي قُلْتْهُولْكُمْ: \"العَبْدْ مُشْ أَعْظِمْ مِنْ سِيدُو\". كَانْ إِضْطَهْدُونِي رَاهُمْ بِشْ يِضْطَهْدُوكُمْ، وكَانْ سَمْعُوا كْلَامِي، رَاهُمْ بِشْ يِسْمْعُوا كْلَامْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","هُومَا بِشْ يَعْمْلُوا فِيكُمْ هَاذَا الكُلْ عْلَى خَاطِرْ إِسْمِي، خَاطِرْهُمْ مَا يَعْرْفُوشْ الِّي بْعَثْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","كَانْ مَا جِيتِشْ وكَلِّمْتْهُمْ، رَاهُو مَا عْلِيهُمْ حَتَّى ذَنْبْ. آمَا تَوَّا مَا عَنْدْهُمْ حَتَّى عُذْرْ عْلَى ذْنُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","الِّي يَكْرَهْنِي يَكْرَهْ بَابَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","كَانْ مَا جِيتِشْ عْمَلْتْ قُدَّامْهُمْ مُعْجْزَاتْ الِّي حَتَّى حَدْ مَا عْمَلْهَا، رَاهُو مَا عْلِيهُمْ حَتَّى ذَنْبْ. آمَا هُومَا شَافُوا، ومْعَ هَاذَا كَرْهُونِي وكَرْهُوا بَابَا. ");
INSERT INTO aeu_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","آمَا هَاذَا صَارْ بَاشْ يْتِمْ المَكْتُوبْ فِي الشَّرِيعَة مْتَاعْهُمْ: \"كَرْهُونِي مِنْ غِيرْ سْبَبْ\". ");
INSERT INTO aeu_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","«ووَقْتِلِّي يْجِي المُعِينْ الِّي بَاشْ نَبْعَثْهُولْكُمْ مِنْ عَنْدْ الآبْ، يَعْنِي رُوحْ الحَقْ الِّي يْجِي مِنْ عَنْدْ الآبْ، هُوَّ يِشْهِدْلِي. ");
INSERT INTO aeu_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","وإِنْتُومَا زَادَا بِشْ تِشْهْدُولِي، عْلَى خَاطِرْكُمْ مْعَايَا مِالأُوِّلْ». ");
INSERT INTO aeu_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«قُلْتِلْكُمْ الكْلَامْ هَاذَا بَاشْ مَا تِتْصَدْمُوشْ وبَاشْ إِيمَانْكُمْ مَا يُضْعُفْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","بِشْ يْطَرْدُوكُمْ مِنْ مْعَابِدْ اليْهُودْ. وبِشْ يْزِيدْ يْجِي وَقْتْ، يِمْشِي فِي بَالْ الِّي يُقْتُلْكُمْ الِّي هُوَّ قَاعِدْ يْرَضِّي فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","وهُومَا يَعْمْلُوا فِي هَاذَا عْلَى خَاطِرْهُمْ لَا عَرْفُوا بَابَا ولَا عَرْفُونِي. ");
INSERT INTO aeu_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","آمَا هَانِي قُلْتِلْكُمْ عْلَى هَاذَا، بَاشْ كِي يْصِيرْ، تِتْذَكْرُوا كَلَامِي. مَا قُلْتْهُولْكُمْشْ مِالأُوِّلْ عْلَى خَاطِرْنِي كُنْتْ مْعَاكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","آمَا تَوَّا، آنَا رَاجَعْ لِلِّي بْعَثْنِي، وحَتَّى حَدْ مِنْكُمْ مَا سْأَلْنِي: \"وِينْ مَاشِي؟\". ");
INSERT INTO aeu_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","آمَا وَقْتِلِّي قُلْتِلْكُمْ الكْلَامْ هَاذَا، قْلُوبْكُمْ تِمْلَاتْ بِالحُزْنْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","نْقُولِلْكُمْ الحَقْ، كَانْ نِمْشِي خِيرِلْكُمْ. عْلَى خَاطِرْ كَانْ مَا نِمْشِيشْ، مَا يْجِيكُمْشْ المُعِينْ. آمَا كَانْ نِمْشِي نَبْعَثْهُولْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ووَقْتِلِّي يْجِي، يْبَيِّنْ لْنَاسْ العَالِمْ الِّي هُومَا غَالْطِينْ فِي مَا يْخُصْ الذْنُوبْ والصَّلَاحْ والحْسَابْ: ");
INSERT INTO aeu_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","فِي مَا يْخُصْ الذْنُوبْ، رَاهُو عْلَى خَاطِرْهُمْ مَا يَمْنُوشْ بِيَّا، ");
INSERT INTO aeu_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","وفِي مَا يْخُصْ الصَّلَاحْ، رَاهُو عْلَى خَاطِرْنِي رَاجَعْ لِلْآبْ ومَا عَادِشْ بِشْ تْشُوفُونِي، ");
INSERT INTO aeu_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","وفِي مَا يْخُصْ الحْسَابْ، رَاهُو عْلَى خَاطِرْ الِّي يُحْكُمْ فِي العَالِمْ هَاذَا مَحْكُومْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","«مَزَّالْ عَنْدِي بَرْشَة كْلَامْ نْحِبْ نْقُولْهُولْكُمْ، آمَا رَاكُمْ تَوَّا مَا تْنَجْمُوشْ تِتْحَمْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ووَقْتِلِّي يْجِي رُوحْ الحَقْ، بِشْ يْدِلْكُمْ لِلْحَقْ الكُلْ، عْلَى خَاطْرُو مُشْ بِشْ يْقُولْ حَتَّى شَيْ مِنْ عَنْدُو، آمَا بِشْ يِتْكَلِّمْ بِلِّي يِسْمْعُو وبِشْ يَحْكِيلْكُمْ عَالحَاجَاتْ الِّي بِشْ تْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","وبِشْ يْمَجِّدْنِي عْلَى خَاطِرْ الكْلَامْ الِّي بِشْ يْقُولْهُولْكُمْ جَايْ مِنْ عَنْدِي. ");
INSERT INTO aeu_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","الِّي عَنْدْ الآبْ الكُلْ هُوَّ لِيَّا. هَاذَاكَا عْلَاشْ قُلْتِلْكُمْ: الكْلَامْ الِّي بِشْ يْقُولْهُولْكُمْ جَايْ مِنْ عَنْدِي. ");
INSERT INTO aeu_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«بَعْدْ شْوَيَّة، مَاكُمْشْ بِشْ تْشُوفُونِي، ومْبَعْدْهَا بِشْوَيَّة، تِرْجْعُوا تْشُوفُونِي». ");
INSERT INTO aeu_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","وفَمَّة جْمَاعَة مِالتْلَامْذَة سِأْلُوا بْعَضْهُمْ: «شْنُوَّة يُقْصُدْ كِي قَالْ: \"بَعْدْ شْوَيَّة مَاكُمْشْ بِشْ تْشُوفُونِي، ومْبَعْدْهَا بِشْوَيَّة بِشْ تْشُوفُونِي\"، وزَادَا كِي قَالْ \"آنَا رَاجَعْ لِلْآبْ\"؟». ");
INSERT INTO aeu_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","وقَالُوا: «آشْ مَعْنَاهَا \"بَعْدْ شْوَيَّة\"؟ مَانَاشْ فَاهْمِينْ آشْ قَاعِدْ يْقُولْ». ");
INSERT INTO aeu_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","وعْرَفْ يَسُوعْ الِّي هُومَا يْحِبُّوا يِسْأْلُوهْ، يَاخِي قَالِلْهُمْ: «تِسْأْلُوا فِي بْعَضْكُمْ شْنُوَّة نُقْصُدْ كِي قُلْتْ: \"بَعْدْ شْوَيَّة مَاكُمْشْ بِشْ تْشُوفُونِي، ومْبَعْدْهَا بِشْوَيَّة بِشْ تْشُوفُونِي؟\" ");
INSERT INTO aeu_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","الحَقْ الحَقْ نْقُولِلْكُمْ، إِنْتُومَا بِشْ تِبْكِيوْ وتْنَوْحُوا، والعَالِمْ بِشْ يِفْرَحْ. إِنْتُومَا بِشْ تَحْزْنُوا، آمَا رَاهُو حُزْنْكُمْ بِشْ يْوَلِّي فَرْحَة. ");
INSERT INTO aeu_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","المْرَا تَحْزِنْ وَقْتِلِّي يْجِي وَقْتْهَا بِشْ تُوْلِدْ. آمَا بَعْدْمَا تُولِدْ تِنْسَى وجَايَعْهَا الكُلْ، عْلَى خَاطِرْهَا فَرْحَانَة الِّي جَابِتْ إِنْسَانْ لِلدِّنْيَا. ");
INSERT INTO aeu_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","إِنْتُومَا زَادَا بِشْ تَحْزْنُوا تَوَّا، آمَا رَانِي بِشْ نِرْجَعْ ونْشُوفْكُمْ، وقْلُوبْكُمْ بِشْ تِفْرَحْ وحَتَّى حَدْ مَا بِشْ يْنَحِّيلْكُمْ فَرْحِتْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","وفِي النْهَارْ هَاذَاكَا، مَا عَادْشْ بِشْ تِسْأْلُونِي عْلَى حَتَّى شَيْ. الحَقْ الحَقْ نْقُلْكُمْ: الِّي تُطْلْبُوهْ مِنْ الآبْ بْإِسْمِي، يَعْطِيهُولْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","حَتَّى لْتَوَّا مَا طْلَبْتُوا حَتَّى شَيْ بْإِسْمِي. أُطْلْبُوا تَاخْذُوا، بَاشْ تِكْمِلْ فَرْحِتْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«كَلَّمْتْكُمْ عَالأُمُورْ هَاذِي بِالأَمْثَالْ. آمَا بِشْ يْجِي الوَقْتْ الِّي نَحْكِيلْكُمْ فِيهْ عَالآبْ بِكْلَامْ وَاضَحْ مِنْ غِيرْ أَمْثَالْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","وفِي النْهَارْ هَاذَاكَا، إِنْتُومَا بِشْ تُطْلْبُوا مِالآبْ بْإِسْمِي، وْمَانِيشْ قَاعِدْ نْقُلْكُمْ الِّي آنَا بِشْ نُطْلْبُو فِي عُوضْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","رَاهُو الآبْ بِيدُو يْحِبْكُمْ عْلَى خَاطِرْكُمْ حَبِّيتُونِي وأَمَّنْتُوا الِّي آنَا جِيتْ مِنْ عَنْدْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","إِيْ نْعَمْ، آنَا خْرَجْتْ مِنْ عَنْدْ الآبْ وجِيتْ لِلدِّنْيَا هَاذِي، وتَوَّا بِشْ نْخَلِّي الدِّنْيَا ونِرْجَعْ لِلْآبْ». ");
INSERT INTO aeu_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","قَالُولُو تْلَامِذْتُو: «إِنْتِ تَوَّا تِتْكَلَّمْ بِكْلَامْ وَاضِحْ، مُشْ بِالأَمْثَالْ. ");
INSERT INTO aeu_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","وأَحْنَا تَوَّا نَعْرْفُوا الِّي إِنْتِ تِعْلِمْ بْكُلْ شَيْ، ومَا تِحْتَاجْ لْحَتَّى حَدْ بِشْ يِسْأْلِكْ. هَاذَاكَا عْلَاشْ أَحْنَا نَمْنُوا الِّي إِنْتِ جِيتْ مِنْ عَنْدْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","جَاوِبْهُمْ يَسُوعْ: «تَوَّا أَمَّنْتُوا؟ ");
INSERT INTO aeu_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","آمَا بِشْ يْجِي وَقْتْ، وهَاوْ تَوَّا جَاء، الِّي فِيهْ بِشْ تِتْفَرْقُوا، وكُلْ وَاحِدْ يِمْشِي عْلَى رُوحُو وتْخَلِّيُونِي وَحْدِي. آمَا رَانِي مَانِيشْ وَحْدِي، عْلَى خَاطِرْ الآبْ مْعَايَا. ");
INSERT INTO aeu_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","قُلْتِلْكُمْ الكْلَامْ هَاذَا بَاشْ يْوَلِّي عَنْدْكُمْ السَّلَامْ فِيَّا. فِي العَالِمْ بِشْ تْعَانِيوْ مِالمْحَايِنْ، آمَا تْشَجْعُوا، رَانِي آنَا غْلِبْتْ العَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","بَعْدْمَا قَالْ الكْلَامْ هَاذَا، هَزْ يَسُوعْ عِينِيهْ لِلسْمَاء وقَالْ: «يَا بَابَا الوَقْتْ جَاء: مَجِّدْ إِبْنِكْ بَاشْ إِبْنِكْ يْمَجْدِكْ ");
INSERT INTO aeu_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","عْلَى خَاطِرْ عْطِيتُو سُلْطَة عَالبَشَرْ الكُلْ، بَاشْ يَعْطِي الحَيَاةْ الأَبَدِيَّة لِلنَّاسْ الِّي عْطِيتْهُمْلُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","والحَيَاةْ الأَبَدِيَّة هِيَّ إِنْهُمْ يَعْرْفُوكْ إِنْتِ وَحْدِكْ الإِلَاهْ الحَقِيقِي، ويَعْرْفُوا يَسُوعْ المَسِيحْ الِّي بْعَثْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","آنَا مَجَّدْتِكْ فِي الأَرْضْ، كِي كَمَّلْتْ الخِدْمَة الِّي كَلَّفْتْنِي بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","وتَوَّا يَا بَابَا، مَجِّدْنِي بِالمَجْدْ الِّي كَانْ عَنْدِي وَقْتِلِّي كُنْتْ مْعَاكْ قْبَلْ مَا تْخَلْقِتْ الدِّنْيَا. ");
INSERT INTO aeu_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«ولِّي عْطِيتْهُمْلِي مِالعَالِمْ خَلِّيتْهُمْ يَعْرْفُوكْ. هُومَا كَانُوا مْتَاعِكْ، وإِنْتِ عْطِيتْهُمْلِي وطَاعُوا كْلَامِكْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","وتَوَّا يَعْرْفُوا إِنُّو الِّي عْطِيتْهُولِي الكُلْ هُوَّ مِنْ عَنْدِكْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","آنَا وصَّلْتِلْهُمْ الكْلَامْ الِّي عْطِيتْهُولِي، وهُومَا قِبْلُوهْ وعَرْفُوا بِالحَقْ الِّي آنَا جِيتْ مِنْ عَنْدِكْ، وصَدْقُوا إِنِّكْ إِنْتِ الِّي بْعَثْتْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","آنَا نِدْعِيلْهُمْ فِي صْلَاتِي. مَا نِدْعِيشْ لِلْعَالِمْ، آمَا نِدْعِي لِلِّي عْطِيتْهُمْلِي عْلَى خَاطِرْهُمْ مْتَاعِكْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","كُلْ مَا هُوَّ لِيَّا رَاهُو لِيكْ، ولِّي لِيكْ هُو لِيَّا، وآنَا نِتْمَجِّدْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","مَانِيشْ بِشْ نُقْعُدْ فِي العَالِمْ هَاذَا، آنَا رَاجِعْلِكْ، آمَا هُومَا قَاعْدِينْ فِي العَالِمْ. يَا بَابَا القُدُّوسْ، أَحْفِظْهُمْ بْقُوِّةْ إِسْمِكْ الِّي عْطِيتْهُولِي، بَاشْ يْكُونُوا وَاحِدْ كِيفْ مَا آنَا وإِنْتِ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","وَقْتِلِّي كُنْتْ مْعَاهُمْ حَافِظْتْ عْلِيهُمْ بْقُوِّةْ إِسْمِكَ الِّي عْطِيتْهُولِي. حْمِيتْهُمْ ومَا ضَاعْ مِنْهُمْ حَتَّى وَاحِدْ، إِلَّا الِّي مْصِيرُو الهْلَاكْ، بَاشْ يْتِمْ الِّي تْقَالْ فِي الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","«وآنَا تَوَّا رَاجَعْلِكْ. آمَا نْقُولْ الكْلَامْ هَاذَا وآنَا مَزِّلْتْ فِي العَالِمْ بَاشْ فَرْحْتِي الكَامْلَة تْوَلِّي فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","آنَا وَصَّلْتِلْهُمْ كْلَامِكْ والعَالِمْ كْرَهْهُمْ عْلَى خَاطِرْهُمْ مَاهُمْشْ مِالعَالِمْ، كِيمَا آنَا مَانِيشْ مِالعَالِمْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","مَا نُطْلُبْشْ بَاشْ تْخَرِّجْهُمْ مِالعَالَمْ، آمَا نُطْلُبْ مِنِّكْ بَاشْ تَحْفِظْهُمْ مِالشِّيطَانْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","هُومَا مُشْ مِالعَالِمْ، كِيمَا آنَا مَانِيشْ مِالعَالِمْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","قَدِّسْهُمْ فِي الحَقْ، كْلَامِكْ هُوَّ الحَقْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","كِيمَا بْعَثْتْنِي لِلْعَالِمْ، آنَا زَادَا بْعَثْتْهُمْ لِلْعَالِمْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","وعْلَى خَاطِرْهُمْ آنَا نْقَدِّسْ رُوحِي، بَاشْ هُومَا زَادَا يِتْقَدْسُوا فِي الحَقْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«ومَا نُطْلُبْشْ عْلَى خَاطِرْهُمْ هُومَا بَرْكْ، آمَا زَادَا عْلَى خَاطِرْ الِّي بِشْ يَمْنُوا بِيَّا بِسْبَبْ كْلَامْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","بَاشْ يْكُونُوا وَاحِدْ يَا بَابَا، كِيفْ مَا إِنْتِ فِيَّا وآنَا فِيكْ. خَلِّيهُمْ هُومَا زَادَا يْكُونُوا وَاحِدْ فِينَا، بَاشْ يْصَدَّقْ العَالِمْ الِّي إِنْتِ بْعَثْتْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","وآنَا عْطِيتْهُمْ المَجْدْ الِّي عْطِيتْهُولِي، بَاشْ يْكُونُوا وَاحِدْ كِيمَا آنَا وإِنْتِ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","آنَا فِيهُمْ وإِنْتِ فِيَّا بَاشْ وِحْدِتْهُمْ تْكُونْ كَامْلَة، ويَعْرِفْ العَالِمْ الِّي إِنْتِ بْعَثْتْنِي ولِّي إِنْتِ تْحِبْهُمْ كِيمَا حَبِّيتْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","«يَا بَابَا، نْحِبْ الِّي عْطِيتْهُمْلِي يْكُونُوا مْعَايَا وِينْ مَا آنَا مَوْجُودْ، بَاشْ يْشُوفُوا المَجْدْ الِّي عْطِيتْهُولِي، عْلَى خَاطْرِكْ حَبِّيتْنِي مِنْ قْبَلْ مَا تْخَلْقِتْ الدِّنْيَا. ");
INSERT INTO aeu_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","يَا بَابَا الصَّالَحْ، العَالِمْ مَا عَرْفِكْشْ، آمَا آنَا عْرَفْتِكْ، وهَاذُومَا عَرْفُوا الِّي إِنْتِ بْعَثْتْنِي. ");
INSERT INTO aeu_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","وخَلِّيتْهُمْ يَعْرْفُوكْ، وبِشْ نْخَلِّيهُمْ يَعْرْفُوكْ أَكْثِرْ، بَاشْ مْحَبْتِكْ لِيَّا تْكُونْ فِيهُمْ، ونْكُونْ آنَا زَادَا فِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","وبَعْدْمَا كَمِّلْ يَسُوعْ صْلَاتُو، مْشَى هُوَّ وتْلَامِذْتُو وشَقُّوا وَادْ قَدْرُونْ. وغَادِي، كَانِتْ فَمَّة سَانْيَة، دَخْلُولْهَا هُوَّ وتْلَامِذْتُو. ");
INSERT INTO aeu_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ويَهُوذَا الِّي بِشْ يْخُونُو كَانْ يَعْرِفْ البْلَاصَة هَاذِيكَا، عْلَى خَاطِرْ يَسُوعْ تْقَابِلْ مْعَ تْلَامِذْتُو غَادِي، بَرْشَة مَرَّاتْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","جَاء يَهُوذَا وجَابْ مْعَاهْ عَسْكِرْ وحُرَّاسْ المَعْبِدْ الِّي بَعْثُوهُمْ كْبَارْ الكَهَنَة والفِرِّيسِيِّينْ، ودَخْلُوا لِلسَّانْيَة هَازِّينْ فْنَارَاتْ ومْشَاعِلْ وسْلَاحْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","وكَانْ يَسُوعْ يَعْرِفْ الِّي بِشْ يْصِيرْلُو الكُلْ، يَاخِي مْشَالْهُمْ وقَالِلْهُمْ: «عْلَى شْكُونْ تْلَوْجُوا؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","جَاوْبُوهْ: «يَسُوعْ النَّاصْرِي». قَالِلْهُمْ: «آنَا هُوَّ!» وكَانْ يَهُوذَا الِّي خَانُو وَاقِفْ مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","ووَقْتِلِّي قَالِلْهُمْ يَسُوعْ: «آنَا هُوَّ» وَخْرُوا لْتَالِي وطَاحُوا عَالقَاعَة. ");
INSERT INTO aeu_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","يَاخِي عَاوِدْ يَسُوعْ سْأَلْهُمْ: «عْلَى شْكُونْ تْلَوْجُوا؟». قَالُوا: «يَسُوعْ النَّاصْرِي». ");
INSERT INTO aeu_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","جَاوِبْهُمْ يَسُوعْ: «قُلْتِلْكُمْ آنَا هُوَّ. إِذَا كَانْكُمْ تْلَوْجُوا عْلِيَّا آنَا، خَلِّيوْ هَاذُومَا يِمْشِيوْ عْلَى رْوَاحُهُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","وهَكَّا تْحَقَّقْ الِّي قَالُّو يَسُوعْ: «مَا ضَيَّعْتْ حَتَّى وَاحِدْ مِلِّي عْطِيتْهُمْلِي». ");
INSERT INTO aeu_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","وكَانْ سِمْعَانْ بُطْرُسْ عَنْدُو سِيفْ، جِبْدُو وضْرَبْ خْدِيمْ الكَاهِنْ الكْبِيرْ وقَصْلُو وذْنُو اليْمِينْ. والخْدِيمْ كَانْ إِسْمُو مَلْخُسْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","قَالْ يَسُوعْ لْبُطْرُسْ: «رَجَّعْ سِيفِكْ لِبْلَاصْتُو! يَاخِي مُشْ لَازِمْنِي نُشْرُبْ كَاسْ الوْجَايَعْ الِّي عْطَاهَولِي الآبْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","بِالوَقْتْ، العَسْكِرْ وقَايِدْهُمْ وحُرَّاسْ الهَيْكِلْ، شَدُّوا يَسُوعْ وكَتْفُوهْ، ");
INSERT INTO aeu_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","وهَزُّوهْ فِي الأُوِّلْ لْحَنَّانْ حْمُو قَيَافَا. وقَيَافَا كَانْ هُوَّ الكَاهِنَ الكْبِيرْ فِي العَامْ هَاذَاكَا. ");
INSERT INTO aeu_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","وقَيَافَا هُوَّ الِّي نْصَحْ اليْهُودْ وقَالْهُمْ «أَحْسْنِلْكُمْ كَانْ يْمُوتْ رَاجِلْ وَاحِدْ فِي بْلَاصِةْ الشَّعْبْ الكُلْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","سِمْعَانْ بُطْرُسْ وتِلْمِيذْ آخَرْ تَبْعُوا يَسُوعْ. دْخَلْ التِّلْمِيذْ الآخِرْ لْوِسْطْ الدَّارْ كْبِيرْ الكَهَنَة مْعَ يَسُوعْ عْلَى خَاطِرْ كْبِيرْ الكَهَنَة كَانْ يَعْرْفُو، ");
INSERT INTO aeu_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","آمَا بُطْرُسْ قْعَدْ وَاقِفْ لْبَرَّا بَحْذَا البَابْ. خْرَجْ التِّلْمِيذْ الآخِرْ، الِّي يَعْرْفُو كْبِيرْ الكَهَنَة، وكَلِّمْ الِّي تْعِسْ فِي البَابْ، ودَخِّلْ بُطْرُسْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","يَاخِي الخْدِيمَة الِّي تْعِسْ فِي البَابْ سِأْلِتْ بُطْرُسْ: «مُشْ إِنْتِ وَاحِدْ مِنْ تْلَامِذْةْ الرَّاجِلْ هَاذَا؟». جَاوِبْهَا بُطْرُسْ: «لَا، مَانِيشْ مِنْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","كَانِتْ الدِّنْيَا بَارْدَة بَرْشَة، وكَانُوا الخُدَّامْ وحُرَّاسْ الهَيْكِلْ مْشَعْلِينْ نَارْ ووَاقْفِينْ يِدَّفَّاوْ. وكَانْ بُطْرُسْ وَاقِفْ يِدَّفَّى مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","سْأَلْ كْبِيرْ الكَهَنَة يَسُوعْ عْلَى تْلَامِذْتُو وعْلَى تَعْلِيمُو. ");
INSERT INTO aeu_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","جَاوْبُو يَسُوعْ: «كَلَّمْتْ النَّاسْ الكُلْ جْهَارْ. كُنْتْ دِيمَا نْعَلِّمْ فِي المْعَابِدْ وفِي الهَيْكِلْ وِينْ يِتْلَمُّوا اليْهُودْ الكُلْ، ومَا قُلْتْ حَتَّى شَيْ فِي السِّرْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","مَالَا عْلَاشْ تِسْإِلْ فِيَّا آنَا؟ إِسْإِلْ النَّاسْ الِّي سَمْعُونِي عَلِّي قُلْتْهُولْهُمْ. هُومَا يَعْرْفُونِي آشْ قُلْتْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","وَقْتِلِّي قَالْ يَسُوعْ الكْلَامْ هَاذَا، وَاحِدْ مِالحُرَّاسْ الِّي بْجَنْبُو ضَرْبُو بْكَفْ وقَالُّو: «هَكَّا تْجَاوِبْ كْبِيرْ الكَهَنَة؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","جَاوْبُو يَسُوعْ: «كَانْ قُلْتْ كْلَامْ غَالِطْ، قُلِّي. وكَانْ قُلْتْ الحَقْ، عْلَاشْ تَضْرِبْ فِيَّا؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ومْبَعِّدْ حَنَّانْ بْعَثْ يَسُوعْ مْكَتِّفْ، لْقِيَافَا كْبِيرْ الكَهَنَة. ");
INSERT INTO aeu_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","فِي الوَقْتْ هَاذَاكَا، كَانْ سِمْعَانْ بُطْرُسْ وَاقِفْ يِدَّفَّى. يَاخِي سِأْلُوهْ: «مُشْ إِنْتِ وَاحِدْ مِنْ تْلَامِذْتُو؟». نْكَرْ بُطْرُسْ وقَالْ: «مَانِيشْ مِنْهُمْ!». ");
INSERT INTO aeu_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","يَاخِي قَالُّو وَاحِدْ مِنْ خُدَّامْ كْبِيرْ الكَهَنَة، وهُوَّ نْسِيبْ الخْدِيمْ الِّي بُطْرُسْ قَصْلُو وِذْنُو: «مُشْ شُفْتِكْ مْعَاهْ فِي السَّانْيَة؟» ");
INSERT INTO aeu_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","زَادْ بُطْرُسْ نْكَرْ مَرَّة أُخْرَى. وبِالوَقْتْ، فَمَّة سَرْدُوكْ صَاحْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ومْبَعِّدْ هَزُّوا يَسُوعْ مِنْ دَارْ قَيَافَا لْدَارْ الوِلَايَة. ووَقْتْهَا كَانْ صْبَاحْ. مَا حَبُّوشْ اليْهُودْ يُدْخْلُوا لْدَارْ الوِلَايَة بَاشْ مَا يِتْنَجْسُوشْ، وبَاشْ يْنَجْمُوا يَاكْلُوا مِنْ مَاكْلَة عِيدْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","وَلَّى خَرَجِّلْهُمْ بِيلَاطُسْ وسْإِلْهُمْ: «بَاشْ تَاهْمِينُو الرَّاجِلْ هَاذَا؟» ");
INSERT INTO aeu_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","جَاوْبُوهْ: «كَانْ مَا جَاشْ مُجْرِمْ، رَانَا مَا جِبْنَاهُولِكْشْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","قَالِلْهُمْ بِيلَاطُسْ: «هِزُّوهْ إِنْتُومَا وأُحْكْمُوا عْلِيهْ بِلِّي مَوْجُودْ فِي شَرِيعِتْكُمْ». جَاوْبُوهْ اليْهُودْ: «مَا عَنْدْنَاشْ الحَقْ نُقْتْلُوا حَتَّى حَدْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","هَاذَا صَارْ بَاشْ يِتْحَقَّقْ الِّي قَالُّو يَسُوعْ عَالطَّرِيقَة الِّي بَاشْ يْمُوتْ بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","يَاخِي بِيلَاطُسْ رْجَعْ دْخَلْ لْدَارْ الوِلَايَة وعَيِّطْ لْيَسُوعْ وسِأْلُو: «يَاخِي إِنْتِ مَلِكْ اليْهُودْ؟» ");
INSERT INTO aeu_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","جَاوْبُو يَسُوعْ: «الكْلَامْ هَاذَا مِنْ عَنْدِكْ وَلَّا النَّاسْ قَالُوهُولِكْ عْلِيَّا؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","جَاوِبْ بِيلَاطُسْ: «يَاخِي آنَا يْهُودِي؟ شَعْبِكْ وكْبَارْ الكَهَنَة هُومَا الِّي جَابُوكْ لِيَّا. شْنُوَّة عْمَلْتْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","جَاوِبْ يَسُوعْ: «مَمْلْكَتِي مَاهِيشْ مِالعَالِمْ هَاذَا. وكَانْ جَاتْ مَمْلِكْتِي مِالعَالِمْ هَاذَا، رَاهُمْ خُدَّامِي حَارْبُوا بَاشْ اليْهُودْ مَا يْشِدُّونِيشْ. آمَا مَمْلِكْتِي مُشْ مِالعَالِمْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","قَالُّو بِيلَاطُسْ: «مَالَا، إِنْتِ مَلِكْ؟». جَاوْبُو يَسُوعْ: «إِنْتِ بِيدِكْ قُلْتْ الِّي آنَا مَلِكْ. آنَا تُولِدْتْ وجِيتْ لِلْعَالِمْ بَاشْ نِشْهِدْ لِلْحَقْ. وكُلْ وَاحِدْ تَابَعْ لِلْحَقْ يِسْمَعْ الكْلَامْ الِّي نْقُولْ فِيهْ». ");
INSERT INTO aeu_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","يَاخِي قَالُّو بِيلَاطُسْ: «شْنُوَّة هُوَّ الحَقْ؟». بَعْدْمَا قَالْ هَاذَا، خْرَجْ مَرَّة أُخْرَى لِلْيْهُودْ وقَالِلْهُمْ: «مَا لْقِيتْ حَتَّى سْبَبْ يْخَلِّينِي نُحْكُمْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","آمَا فِي العَادَة نْسَيْبِلْكُمْ وَاحِدْ مِالمْرَابِيطْ فِي عِيدْ الفِصْحْ. تْحِبُّوشْ نْسَيْبِلْكُمْ مَلِكْ اليْهُودْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","يَاخِي صَاحُوا: «هَاذَاكَا لَا. سَيْبِلْنَا بَارَابَاسْ». وبَارَابَاسْ هَاذَا كَانْ مُجْرِمْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","يَاخِي بِيلَاطُسْ عْطَى أَمْرْ بَاشْ يْهِزُّوا يَسُوعْ ويَضْرْبُوهْ بِالسُّوطْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","وضَفْرُوا الجُنُودْ تَاجْ مِالشُّوكْ وحَطُّوهُولُو فُوقْ رَاسُو، ولَبْسُوهْ لِبْسَة فِي لُونْ البَنَفْسَجْ، ");
INSERT INTO aeu_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ودَارُوا بِيهْ وبْدَاوْ يَضْرْبُوا فِيهْ بِالكَفْ ويْقُولُوا: «سَلَامْ يَا مَلِكْ اليْهُودْ!». ");
INSERT INTO aeu_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","وخْرَجْ بِيلَاطُسْ مَرَّة أُخْرَى لِلنَّاسْ وقَالِلْهُمْ: «هَانِي بِشْ نْخَرِّجْهُولْكُمْ، بَاشْ تَعْرْفُوا الِّي آنَا مَا لْقِيتْ حَتَّى سْبَبْ يْخَلِّينِي نُحْكُمْ عْلِيهْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","خْرَجْ يَسُوعْ وهُوَّ لَابِسْ تَاجْ الشُّوكْ واللِّبْسَة البَنَفْسَجِيَّة. يَاخِي قَالِلْهُمْ بِيلَاطُسْ: «أَهَوَّا الرَّاجِلْ!». ");
INSERT INTO aeu_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","وَقْتِلِّي شَافُوهْ كْبَارْ الكَهَنَة والحُرَّاسْ، صَاحُوا: «أُصْلْبُو! أُصْلْبُو!». قَالِلْهُمْ بِيلَاطُسْ: «هِزُّوهْ إِنْتُومَا وأُصْلْبُوهْ، آنَا مَا لْقِيتْ حَتَّى سْبَبْ يْخَلِّينِي نُحْكُمْ عْلِيهْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","جَاوْبُوهْ اليْهُودْ: «أَحْنَا عَنْدْنَا شَرِيعَة، والشَّرِيعَة تْقُولْ الِّي لَازْمُو يْمُوتْ، عْلَى خَاطِرْ قَالْ عْلَى رُوحُو الِّي هُوَّ إِبْنْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","وَقْتِلِّي سْمَعْ بِيلَاطُسْ كْلَامْهُمْ، زَادْ خَافْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","وعَاوِدْ دْخَلْ لْدَارْ الوِلَايَة وقَالْ لْيَسُوعْ: «إِنْتِ مْنِينْ؟». آمَا يَسُوعْ مَا جَاوْبُوشْ بِالكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","قَالُّو بِيلَاطُسْ: «مَا تْحِبِّشْ تْكَلِّمْنِي؟ يَاخِي مَا تَعْرَفْشْ الِّي عَنْدِي السُّلْطَة بَاشْ نْسَيْبِكْ، وعَنْدِي السُّلْطَة بَاشْ نُصْلْبِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","جَاوْبُو يَسُوعْ: «مَا عَنْدِكْ عْلِيَّا حَتَّى سُلْطَة كَانْ مُشْ اللَّهْ عْطَاهَالِكْ. هَاذَاكَا عْلَاشْ، الِّي سَلَّمْنِي لِيكْ ذَنْبُو أَعْظِمْ مِنْ ذَنْبِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ومِنْ وَقْتْهَا، حَاوِلْ بِيلَاطُسْ يْسَيْبُو، آمَا اليْهُودْ صَاحُوا: «كَانْ تْسَيْبُو، مَعْنَاهَا إِنْتِ مَا تْحِبِّشْ القَيْصِرْ، عْلَى خَاطِرْ الِّي يْقُولْ عْلَى رُوحُو مَلِكْ، هُوَّ عْدُو لِلْقَيْصَرْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","وَقْتِلِّي سْمَعْ بِيلَاطُسْ الكْلَامْ هَاذَا، خَرِّجْ يَسُوعْ وقْعَدْ عْلَى كُرْسِي الحُكْمْ فِي بْلَاصَة إِسْمْهَا البْلَاطْ، وبِالعِبْرِيَّة إِسْمْهَا «جَبَّاثَا». ");
INSERT INTO aeu_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","وهَاذَا صَارْ مْعَ الظُّهْرْ، فِي النْهَارْ الِّي يْحَضْرُوا فِيهْ لِلْفِصْحْ. قَالْ بِيلَاطُسْ لِلْيْهُودْ: «هَا هُوَّ المَلِكْ مْتَاعْكُمْ!». ");
INSERT INTO aeu_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","يَاخِي صَاحُوا: «أُقْتْلُو! أُقْتْلُو! أُصْلْبُو!». قَالِلْهُمْ بِيلَاطُسْ: «تْحِبُّونِي نُصْلُبْ المَلِكْ مْتَاعْكُمْ؟». جَاوْبُوهْ كْبَارْ الكَهَنَة: «مَا عَنْدْنَاشْ مَلِكْ آخِرْ بْخَلَافْ القَيْصِرْ!». ");
INSERT INTO aeu_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","وَلَّا بِيلَاطُسْ سَلَّمْهُولْهُمْ بَاشْ يُصْلْبُوهْ. يَاخِي هَزُّوا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","وخْرَجْ يَسُوعْ وهُوَّ هَازِزْ صْلِيبُو، مَاشِي لْبُقْعَة تِتْسَمَّى الجُمْجْمَة، ولِّي يْقُولُولْهَا بِالعِبْرِيَّة «الجُلْجْثَة». ");
INSERT INTO aeu_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","وغَادِي صَلْبُوهْ وصَلْبُوا مْعَاهْ زُوزْ رْجَالْ، وَاحِدْ عْلَى يْمِينُو ووَاحِدْ عْلَى يْسَارُو ويَسُوعْ فِي الوُسْطْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","وعَلِّقْ بِيلَاطُسْ بْلَاكَة عَالصَّلِيبْ مَكْتُوبْ عْلِيهَا: «يَسُوعْ النَّاصْرِي، مَلِكْ اليْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","بَرْشَة يْهُودْ قْرَاوْ البْلَاكَة، عْلَى خَاطِرْ البْلَاصَة الِّي تِصْلَبْ فِيهَا يَسُوعْ كَانِتْ قْرِيبَة مِالمْدِينَة. والكْتِيبَة كَانِتْ بِالعِبْرِيَّة واللَّاتِينِيَّة واليُونَانِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","يَاخِي قَالُوا كْبَارْ الكَهَنَة لْبِيلَاطُسْ: «مَا تِكْتِبْشْ \"مَلِكْ اليْهُودْ\" آمَا إِكْتِبْ \"الرَّاجِلْ هَاذَا قَالْ: آنَا مَلِكْ اليْهُودْ!\"». ");
INSERT INTO aeu_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","جَاوِبْهُمْ بِيلَاطُسْ: «الِّي كْتِبْتُو، كْتِبْتُو». ");
INSERT INTO aeu_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","وبَعْدْمَا العَسْكَرْ صَلْبُوا يَسُوعْ، قَسْمُوا حْوَايْجُو عْلَى أَرْبْعَة، وكُلْ عَسْكْرِي خْذَا بَايْ. وخْذَاوْ جُبْتُو زَادَا، وكَانِتْ لْكُلْهَا قَطْعَة وَحْدَة مَنْسُوجَة، مَا فِيهَاشْ خْيَاطَة. ");
INSERT INTO aeu_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","قَالُوا العَسْكَرْ لِبْعَضْهُمْ: «مُشْ لَازِمْ نْقَطْعُوهَا. خَلِّينَا نَعْمْلُوا عْلِيهَا قُرْعَة، ونْشُوفُوا شْكُونْ يِرْبِحْهَا». هَاذَاكَا صَارْ بَاشْ يِتْحَقَّقْ الِّي تْقَالْ فِي الكْتُبْ المُقَدْسَة: «قَسْمُوا حْوَايْجِي مَا بِينَاتْهُمْ، وعَمْلُوا قُرْعَة عْلَى جُبْتِي». وهَاذَا هُوَّ الِّي عَمْلُوهْ العَسْكِرْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","وكَانِتْ مَرْيِمْ أُمْ يَسُوعْ وَاقْفَة بَحْذَا صَلِيبُو، ومْعَاهَا أُخْتْهَا، ومَرْيِمْ مَرْتْ كِلُوبَا، ومَرْيِمْ المَجْدَلِيَّة. ");
INSERT INTO aeu_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","وَقْتِلِّي يَسُوعْ شَافْ أُمُّو والتِّلْمِيذْ الِّي يْحِبُّو وَاقِفْ بَحْذَاهَا، قَالْ لْأُمُّو: «يَا مْرَا، هَاذَا وِلْدِكْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","وقَالْ لِلتِّلْمِيذْ: «هَاذِي أُمِّكْ!». ومِنْ وَقْتْهَا، هَزْهَا التِّلْمِيذْ لْدَارُو. ");
INSERT INTO aeu_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","وبَعْدْ هَاذَا، شَافْ يَسُوعْ الِّي كُلْ شَيْ كْمِلْ. يَاخِي قَالْ: «آنَا عُطْشَانْ»، بَاشْ يِتْحَقَّقْ الِّي تْقَالْ فِي الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","وكَانْ فَمَّة سْطَلْ مَلْيَانْ بِالخَلْ، غَطْسُوا فِيهْ شِيفُونَة وحَطُّوهَا عْلَى عُودْ رِيحَانْ وطَلْعُوهَا لْفُمُّو. ");
INSERT INTO aeu_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ووَقْتِلِّي ذَاقْ يَسُوعْ الخَلْ قَالْ: «كُلْ شَيْ كْمِلْ!» وهَبَّطْ رَاسُو وطَلَّعْ الرُّوحْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","والنْهَارْ هَاذَاكَا كَانْ يُومْ التَّحْضِيرْ لِلسِّبْتْ. وَلَّاوْ اليْهُودْ طَلْبُوا مِنْ بِيلَاطُسْ بَاشْ يَعْطِي أَمْرْ لِلْعَسْكِرْ يْكَسْرُوا سَاقِينْ المَصْلُوبِينْ ويْهَبْطُوهُمْ. وهَكَّا مَا يْبَاتُوشْ عَالصَّلِيبْ لِنْهَارْ السِّبْتْ، بِالأَخَصْ الِّي السِّبْتْ هَاذَاكَا كَانْ نْهَارْ عْظِيمْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","وَلَّاوْ العَسْكِرْ جَاوْ وكَسْرُوا سَاقِينْ الرَّاجِلْ الأَوِّلْ وبَعْدْ سَاقِينْ الرَّاجِلْ الثَّانِي الِّي تْصَلْبُوا مْعَ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ووَقْتِلِّي وُصْلُوا لْيَسُوعْ، لْقَاوْهْ مَاتْ. يَاخِي مَا كَسْرُولُوشْ سَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","آمَا وَاحِدْ مِالعَسْكِرْ ضَرْبُو بْرُمْحْ فِي جَنْبُو، وبِالوَقْتْ خْرَجْ مِنُّو دَمْ ومَاء. ");
INSERT INTO aeu_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ولِّي شَافْ هَاذَا، يِشْهِدْ بِيهْ وشْهَادْتُو صْحِيحَة. ويَعْرِفْ الِّي هُوَّ يْقُولْ فِي الحَقْ، بَاشْ إِنْتُومَا زَادَا تَمْنُوا. ");
INSERT INTO aeu_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","هَاذَا صَارْ بَاشْ يِتْحَقَّقْ الِّي قَالِتُّو الكْتُبْ المُقَدْسَة: «مَا يِتْكَسَّرْلُو حَتَّى عْظَمْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ومَكْتُوبْ فِي بْلَاصْة أُخْرَى فِي الكْتُبْ المُقَدْسَة: «بِشْ يُخْزْرُوا لِلشَّخْصْ الِّي دَغْرُوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","وبَعْدْ هَاذَا جَاء يُوسِفْ الِّي أَصْلُو مِنْ مْدِينِةْ الرَّامَة. وهُوَّ كَانْ تِلْمِيذْ يَسُوعْ فِي السِّرْ، عْلَى خَاطْرُو كَانْ خَايِفْ مِاليْهُودْ. وطْلَبْ مِنْ بِيلَاطُسْ بَاشْ يْخَلِّيهْ يْهِزْ جُثِّةْ يَسُوعْ، وبِيلَاطُسْ وَافَقْ. يَاخِي جَاء وهَزْهَا. ");
INSERT INTO aeu_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","وجَاء زَادَا نِيقُودِيمُوسْ، الِّي قْبَلْ بْمُدَّة مْشَى لْيَسُوعْ فِي اللِّيلْ. وجَابْ مْعَاهْ قْرَابِةْ 34 كِيلُو مُرْ وعُودْ مْخَلْطِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","وهَزُّوا جُثِّةْ يَسُوعْ، وفَوْحُوهَا بِالعِطْرْ ولَفُّوهَا فِي قْمَايِطْ، كِيفْ مَا كَانِتْ عْوَايِدْ اليْهُودْ فِي الدْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","وكَانِتْ فَمَّة سَانْيَة فِي البْلَاصَة الِّي تِصْلَبْ فِيهَا يَسُوعْ، والسَّانْيَة هَاذِيكَا فِيهَا قْبَرْ جْدِيدْ مَا تْحَطْ فِيهْ حَتَّى حَدْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","وَلَّاوْ حَطُّوا يَسُوعْ فِي القْبَرْ هَاذَاكَا عْلَى خَاطْرُو كَانْ قْرِيبْ، وعْلَى خَاطِرْ كَانْ النْهَارْ هَاذَاكَا عَنْدْ اليْهُودْ، نْهَارْ التَّحْضِيرْ لِلسِّبْتْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","نْهَارْ الأَحَدْ الصْبَاحْ بِكْرِي، جَاتْ مَرْيِمْ المَجْدَلِيَّة لِلْقْبَرْ والدِّنْيَا مَزَّالِتْ ظَلْمَة، يَاخِي شَافِتْ الحَجْرَة الِّي مْسَكْرِينْ بِيهَا القْبَرْ مْنِحْيَة. ");
INSERT INTO aeu_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","مْشَاتْ تِجْرِي لْسِمْعَانْ بُطْرُسْ والتِّلْمِيذْ الآخِرْ الِّي يْحِبُّو يَسُوعْ وقَالْتِلْهُمْ: «هَزُّوا سِيدْنَا مِالقْبَرْ، ومَا نَعْرْفُوشْ وِينْ حَطُّوهْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","يَاخِي مْشَى بُطْرُسْ والتِّلْمِيذْ الآخِرْ لِلْقْبَرْ، ");
INSERT INTO aeu_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","وكَانُوا الإِثْنِينْ يِجْرِيوْ مْعَ بْعَضْهُمْ، آمَا التِّلْمِيذْ الآخِرْ سْبِقْ بُطْرُسْ ووْصِلْ قَبْلُو لِلْقْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","طَبِّسْ، شَافْ القْمَايِطْ فِي القَاعَة، آمَا مَا دْخَلْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","خْلَطْ عْلِيهْ سِمْعَانْ بُطْرُسْ، ودْخَلْ لِلْقْبَرْ وشَافْ القْمَايِطْ طَايْحِينْ فِي القَاعَة، ");
INSERT INTO aeu_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","والمَنْدِيلَة الِّي كَانِتْ مَحْطُوطَة عْلَى رَاسْ يَسُوعْ، لْقَاهَا مَلْفُوفَة وَحَّدْهَا، فِي بْلَاصَة بْعِيدَة عْلَى القْمَايِطْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","وَقْتْهَا دْخَلْ التِّلْمِيذْ الآخِرْ الِّي سْبَقْ بُطْرُسَ لِلْقْبَرْ، يَاخِي شَافْ وأَمَّنْ، ");
INSERT INTO aeu_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","عْلَى خَاطِرْ، حَتَّى لِلْوَقْتْ هَاذَاكَا، مَا كَانُوشْ التْلَامْذَة فَاهْمِينْ الِّي يَسُوعْ لَازِمْ يْقُومْ مِالمُوتْ كِيمَا قَالِتْ الكْتُبْ المُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ومْبَعِّدْ، رَوْحُوا التْلَامْذَة لِدْيَارْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","آمَا مَرْيِمْ المَجْدَلِيَّة، وِقْفِتْ بَحْذَا القْبَرْ تِبْكِي. وهِيَّ تِبْكِي، طَبْسِتْ بَاشْ تْطُلْ عَالقْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","يَاخِي شَافِتْ زُوزْ مْلَايْكَة لَابْسِينْ بِالأَبْيِضْ وقَاعْدِينْ فِي البْلَاصَة الِّي كَانِتْ مَحْطُوطَة فِيهَا جُثَّةْ يَسُوعْ، وَاحِدْ عَنْدْ رَاسُو ووَاحِدْ عَنْدْ سَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","قَالُولْهَا: «يَا مْرَا، عْلَاشْ تِبْكِي؟». جَاوْبِتْ: «هَزُّوا سِيدِي ومَا نَعْرَفْشْ وِينْ حَطُّوهْ!». ");
INSERT INTO aeu_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","قَالِتْ هَاذَا وتْلَفْتِتْ، يَاخِي شَافِتْ يَسُوعْ وَاقِفْ، آمَا مَا عَرْفِتُّوشْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","قَالِلْهَا يَسُوعْ: «يَا مْرَا، عْلَاشْ تِبْكِي؟ عْلَى شْكُونْ تْلَوِّجْ؟». مْشَى فِي بَالْهَا الِّي هُوَّ الجَنَّانْ يَاخِي قَالِتْلُو: «يَا سِيدِي، كَانِكْ إِنْتِ هَزِّيتُو، قُلِّي وِينْ حَطِّيتُو بَاشْ نِمْشِي نْهِزُّو». ");
INSERT INTO aeu_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","قَالِلْهَا يَسُوعْ: «يَا مَرْيِمْ». تْلَفْتِتْلُو وقَالِتْلُو بِالعِبْرِيَّة: «رَبُّونِي!» (الِّي مَعْنَاهَا يَا مُعَلِّمْ). ");
INSERT INTO aeu_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","قَالِلْهَا: «مَا تْشِدْنِيشْ، عْلَى خَاطِرْنِي مَزِّلْتْ مَا طْلَعْتِشْ لِلْآبْ، آمَا إِمْشِي لِخْوَاتِي وقُولِلْهُمْ رَانِي بَاشْ نِطْلَعْ لْبَابَا وبُوكُمْ، إِلَاهِي وإِلَاهْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","رَجْعِتْ مَرْيِمْ المَجْدَلِيَّة وقَالِتْ لِلتْلَامْذَة الِّي هِيَّ شَافِتْ الرَّبْ يَسُوعْ، وحْكَاتِلْهُمْ عَلِّي قَالْهُولْهَا الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","وفِي عْشِيَّةْ النْهَارْ هَاذَاكَا، الِّي هُوَّ نْهَارْ الأَحَدْ، كَانُوا التْلَامْذَة مَلْمُومِينْ فِي دَارْ وقَافْلِينْ البِيبَانْ عْلَى خَاطِرْهُمْ كَانُوا خَايْفِينْ مِاليْهُودْ. وإِذَا بِيهْ، جَاء يَسُوعْ، ووْقِفْ فِي وُسْطْهُمْ وقَالِلْهُمْ: «السَّلَامْ لِيكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","وبَعْدْمَا قَالْ هَاذَا، وَرَّاهُمْ يْدِيهْ وجَنْبُو، يَاخِي فَرْحُوا التْلَامْذَة عْلَى خَاطِرْ شَافُوا الرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","قَالِلْهُمْ يَسُوعْ مَرَّة أُخْرَى: «السَّلَامْ لِيكُمْ! كِيمَا بْعَثْنِي الآبْ، آنَا زَادَا نِبْعَثْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","قَالْ هَاذَا ونْفَخْ عْلِيهُمْ وقَالِلْهُمْ: «إِقْبْلُوا الرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","الِّي تِغْفْرُولْهُمْ إِنْتُومَا ذْنُوبْهُمْ، تِتْغْفَرِّلْهُمْ، ولِّي مَا تِغْفْرُولْهُمْشْ ذْنُوبْهُمْ مَا يِتْغْفَرِّلْهُمْشْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","وتُومَا، الِّي هُوَّ وَاحِدْ مِالتْلَامْذَة الأَثْنَاشْ ولِّي كَانُوا يْعَيْطُولُو التُّومِي، مَا كَانِشْ مْعَاهُمْ وَقْتِلِّي جَاء يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","قَالُولُو التْلَامْذَة الأُخْرِينْ: «أَحْنَا شُفْنَا الرَّبْ!» قَالِلْهُمْ: «آنَا مَا نْصَدَّقْ كَانْ مَا نْشُوفْ أَمَارِةْ المْسَامِرْ فِي يْدِيهْ، ونْحُطْ صُبْعِي فِي بْلَاصِةْ المْسَامِرْ ونْحُطْ يِدِّي فِي جَنْبُو». ");
INSERT INTO aeu_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","وبَعْدْ ثْمَنْيَة أَيَّامْ، كَانُوا التْلَامْذَة فِي الدَّارْ مَرَّة أُخْرَى، ومْعَاهُمْ تُومَا. جَاء يَسُوعْ رَغْمِلِّي كَانِتْ البِيبَانْ مَقْفُولَة، ووْقِفْ فِي وُسْطْهُمْ وقَالْ: «السَّلَامْ لِيكُمْ». ");
INSERT INTO aeu_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ومْبَعِّدْ قَالْ لْتُومَا: «حُطْ صُبْعِكْ هُونِي وشُوفْ يْدَيَّا، وهَاتْ يِدِّكْ وحُطْهَا فِي جَنْبِي. مَا عَادِشْ تْشِكْ، آمَا أَمَّنْ!» ");
INSERT INTO aeu_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","جَاوْبُو تُومَا: « رَبِّي وإِلَاهِي!» ");
INSERT INTO aeu_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","قَالُّو يَسُوعْ: «أَمَّنْتْ عْلَى خَاطْرِكْ رِيتْنِي! صَحَّة لِيهُمْ الِّي يَمْنُوا مِنْ غِيرْ مَا يْشُوفُوا». ");
INSERT INTO aeu_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","وعْمَلْ يَسُوعْ قُدَّامْ تْلَامِذْتُو بَرْشَة مُعْجْزَاتْ أُخْرَى مَا تْكِتْبِتْشْ فِي الكْتَابْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","آمَا هَاذِي تْكِتْبِتْ، بَاشْ تَمْنُوا الِّي يَسُوعْ هُوَّ المَسِيحْ إِبْنْ اللَّهْ، وبَاشْ تْكُونْ عَنْدْكُمْ حَيَاةْ بِالإِيمَانْ بْإِسْمُو. ");
INSERT INTO aeu_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","وزَادْ يَسُوعْ ظْهُرْ مَرَّة أُخْرَى لِتْلَامِذْتُو عْلَى شَطْ بُحَيْرَةْ طَبَرِيَّة. وهَاوْ كِيفَاشْ ظْهُرِّلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","كَانْ سِمْعَانْ بُطْرُسْ، وتُومَا الِّي يْعَيْطُولُو التُّومِي، ونَثَنَائِيلْ الِّي مِنْ مَنْطَقْةْ قَانَا الجَلِيلْ، ووْلَادْ زَبَدِي، وزُوزْ تْلَامْذَة أُخْرِينْ مِنْ تْلَامِذْةْ يَسُوعْ مَلْمُومِينْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","قَالِلْهُمْ سِمْعَانْ بُطْرُسْ: «آنَا مَاشِي نِصْطَادْ». قَالُولُو: «أَحْنَا زَادَا نِمْشِيوْ مْعَاكْ». خَرْجُوا وطَلْعُوا فِي الفْلُوكَة، آمَا اللِّيلَة هَاذِيكَا مَا صْطَادُوا شَيْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","وَقْتِلِّي طْلَعْ النْهَارْ كَانْ يَسُوعْ وَاقِفْ عَالشَّطْ، آمَا التْلَامْذَة مَا عَرْفُوهِشْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","يَاخِي قَالِلْهُمْ: «يَا شَبَابْ، مَا صْطَدْتُوا شَيْ؟» جَاوْبُوهْ: «لَا». ");
INSERT INTO aeu_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","قَالِلْهُمْ: «إِرْمِيوْ الشَّبْكَة عْلَى يْمِينْ الفْلُوكَة وتَوَّا تَلْقَاوْ الحُوتْ». رْمَاوْ الشَّبْكَة ومِنْ كُثْرِةْ مَا كَانِتْ مْعِبْيَة بِالحُوتْ، مَا نَجْمُوشْ يْخَرْجُوهَا. ");
INSERT INTO aeu_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","قَالْ التِّلْمِيذْ الِّي يْحِبُّو يَسُوعْ لْبُطْرُسْ: «رَاهُو الرَّبْ يَسُوعْ!». كِي سْمَعْ سِمْعَانْ بُطْرُسْ كِلْمِةْ: «رَاهُو الرَّبْ يَسُوعْ»، لْبِسْ بَرْنُوسُو عْلَى خَاطْرُو كَانْ مْنَحِّيهْ، وتِرْمَى فِي المَاء. ");
INSERT INTO aeu_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","والتْلَامْذَة الأُخْرِينْ وُصْلُوا لِلشَّطْ بِالفْلُوكَة، وهِيَّ تْكَرْكِرْ فِي الشَّبْكَة المْعِبْيَة بِالحُوتْ، عْلَى خَاطِرْهُمْ كَانُوا بْعَادْ عَالشَّطْ قْرَابِةْ المْيَاةْ مِيتْرُو أَكَهَوْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","ووَقْتِلِّي خَرْجُوا لِلشَّطْ، شَافُوا حُوتْ يْطِيبْ عَالجْمَرْ، وخُبْزْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","قَالِلْهُمْ يَسُوعْ: «جِيبُوا مِالحُوتْ الِّي شَدِّيتُوهْ تَوَّا». ");
INSERT INTO aeu_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","طْلَعْ سِمْعَانْ بُطْرُسْ فِي الفْلُوكَة، وكَرْكِرْ الشَّبْكَة المِلْيَانَة لِلشَّطْ. وكَانِتْ فِيهَا 153 حُوتَة كْبِيرَة. ورَغْمِلِّي كَانِتْ مْعِبْيَة، مَا تْقَطْعِتْشْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","قَالِلْهُمْ يَسُوعْ: «إِيجَاوْ كُولُوا!» وحَتَّى وَاحِدْ مِالتْلَامْذَة مَا تْجَرَّأْ يِسْأْلُو «إِنْتِ شْكُونْ؟»، عْلَى خَاطِرْ عَرْفُوا الِّي هُوَّ الرَّبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","يَاخِي قْرُبِّلْهُمْ يَسُوعْ، وعْطَاهُمْ الخُبْزْ، وزَادْ مَدِّلْهُمْ الحُوتْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","هَاذِي كَانِتْ المَرَّة الثَّالْثَة الِّي ظْهُرْ فِيهَا يَسُوعْ لِتْلَامِذْتُو بَعْدْمَا قَامْ مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","وبَعْدْمَا كْلَاوْ، قَالْ يَسُوعْ لْسِمْعَانْ بُطْرُسْ: «يَا سِمْعَانْ وِلْدْ يُونَا، يَاخِي تْحِبْنِي أَكْثِرْ مِلِّي يْحِبُّونِي هَاذُومَا الكُلْ؟». جَاوْبُو: «إِيْ نْعَمْ، يَا رَبْ. إِنْتِ تَعْرِفْ الِّي آنَا نْحِبِّكْ». قَالُّو: «أَرْعَى الغْنَمْ مْتَاعِي». ");
INSERT INTO aeu_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","وقَالُّو يَسُوعْ مَرَّة أُخْرَى: «يَا سِمْعَانْ وِلْدْ يُونَا، يَاخِي تْحِبْنِي؟». جَاوْبُو: «إِيْ نْعَمْ، يَا رَبْ، إِنْتِ تَعْرِفْ الِّي آنَا نْحِبِّكْ». قَالُّو: «تِلْهَا بِالغْنَمْ مْتَاعِي». ");
INSERT INTO aeu_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","وسِأْلُو مَرَّة ثَالْثَة: «يَا سِمْعَانْ يَا وِلْدْ يُونَا، يَاخِي تْحِبْنِي؟». حْزِنْ بُطْرُسْ عْلَى خَاطِرْ يَسُوعْ سِأْلُو مَرَّة ثَالْثَة: «يَاخِي تْحِبْنِي؟». قَالُّو: «يَا رَبْ، إِنْتِ تَعْرِفْ كُلْ شَيْ، وتَعْرِفْ الِّي آنَا نْحِبِّكْ». قَالُّو يَسُوعْ: «أَرْعَى الغْنَمْ مْتَاعِي. ");
INSERT INTO aeu_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","الحَقْ الحَقْ نْقُلِّكْ: وَقْتِلِّي كُنْتْ صْغِيرْ، كُنْتْ تِلْبِسْ حْوَايْجِكْ وَحْدِكْ وتِمْشِي وِينْ تْحِبْ. آمَا وَقْتِلِّي تْوَلِّي شَايِبْ، تْمِدْ يْدِيكْ ووَاحِدْ آخَرْ يْلَبْسِكْ ويْهِزِّكْ وِينْ مَا تْحِبِّشْ تِمْشِي». ");
INSERT INTO aeu_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","لَمَّحْ يَسُوعْ بِالكْلَامْ هَاذَا لِلطَّرِيقَة الِّي بِشْ يْمُوتْ بِيهَا بُطْرُسْ ولِّي بِشْ يِتْمَجِّدْ بِيهَا اللَّهْ. ومِنْ بَعْدْهَا قَالُّو: «تَبَّعْنِي!». ");
INSERT INTO aeu_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","تْلَفِّتْ بُطْرُسْ، وشَافْ التِّلْمِيذْ الِّي يْحِبُّو يَسُوعْ يْتَبَّعْ فِيهُمْ، وهُوَّ الِّي إِتَّكَّى عْلَى صْدِرْ يَسُوعْ وَقْتْ العْشَاء وقَالُّو: «يَا سِيدِي، شْكُونُو الِّي بَاشْ يْخُونِكْ؟». ");
INSERT INTO aeu_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","وَقْتِلِّي شَافُو بُطْرُسْ قَالْ لْيَسُوعْ: «وهَاذَا يَا رَبْ، آشْ بَاشْ يْصِيرْلُو؟». ");
INSERT INTO aeu_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","قَالُّو يَسُوعْ: «إِذَا كَانْ نْحِبُّو يُقْعُدْ حَيْ حَتَّى لِينْ نِرْجَعْ، هَاذَا مَا يْخُصِّكْشْ. إِنْتِ، تَبَّعْنِي!». ");
INSERT INTO aeu_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","يَاخِي طَلْعِتْ إِشَاعَة بِينْ المُؤْمْنِينْ الِّي التِّلْمِيذْ هَاذَاكَا مُشْ بِشْ يْمُوتْ. آمَا يَسُوعْ مَا قَالِشْ لْبُطْرُسْ الِّي هُوَّ مُشْ بِشْ يْمُوتْ. قَالُّو: «إِذَا كَانْ نْحِبُّو يُقْعُدْ حَيْ حَتَّى لِينْ نِرْجَعْ، هَاذَا مَا يْخُصِّكْشْ». ");
INSERT INTO aeu_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","والتِّلْمِيذْ هَاذَا هُوَّ الِّي يِشْهِدْ بِالأُمُورْ هَاذِي، وهُوَّ الِّي كْتِبْهَا. وأَحْنَا نَعْرْفُوا الِّي شْهَادْتُو صْحِيحَة. ");
INSERT INTO aeu_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","وفَمَّة بَرْشَة حَاجَاتْ أُخْرِينْ عْمَلْهُمْ يَسُوعْ. كَانْ تِتْكْتِبْ بِالوَحْدَة بِالوَحْدَة، مَا نْظُنِّشْ الِّي العَالِمْ كَامِلْ بِشْ يَرْفَعْ الكْتُبْ الِّي بِشْ تِتْكْتِبْ عْلِيهَا.");
INSERT INTO aeu_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","حْكِيتْلِكْ فِي كْتَابِي الأُوِّلْ، يَا ثَاوْفِيلُسْ، عْلَى كُلْ الحَاجَاتْ الِّي عْمَلْهَا يَسُوعْ وعَلِّمْهَا، مِالأُوِّلْ ");
INSERT INTO aeu_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","حَتَّى لِلنْهَارْ الِّي تِرْفَعْ فِيهْ لِلسْمَاء، بَعْدْمَا عْطَى الوْصَايَا مْتَاعُو بِالرُّوحْ القُدُسْ لِلرُّسُلْ الِّي سْبَقْ واخْتَارْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","وهُومَا الِّي ظْهُرِّلْهُمْ بَرْشَة مَرَّاتْ بَعْدْ مَا مَاتْ ولْمُدِّةْ أَرْبْعِينْ يُومْ، ووَرَّاهُمْ إِبَّرْشَة أَمَارَاتْ الِّي هُوَّ حَيْ، وحْكَالْهُمْ عْلَى مَمْلَكْةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ومَرَّة، وَقْتِلِّي كَانْ يَاكِلْ مْعَاهُمْ، قَالِلْهُمْ: «مَا تِمْشِيوِشْ مِنْ أُورْشَلِيمْ، آمَا إِسْتَنَّاوْ حَتَّى يْتِمْ وَعْدْ الآبْ الِّي سْمَعْتُوهْ مِنْ عَنْدِي. ");
INSERT INTO aeu_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","يُوحَنَّا عَمِّدْ النَّاسْ بِالمَاء آمَا إِنْتُومَا بِشْ تِتْعَمْدُوا بَعْدْ أَيَّامَاتْ بِالرُّوحْ القُدُسْ». ");
INSERT INTO aeu_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","يَاخِي سِأْلُوهْ الِّي كَانُوا مْعَاهْ وَقْتْهَا: «يَا رَبْ، زَعْمَة فِي الوَقْتْ هَاذَا بِشْ تْرَجَّعْ المَمْلْكَة لْإِسْرَائِيلْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","جَاوِبْهُمْ يَسُوعْ: «مُشْ مَسْؤُولِيِّتْكُمْ بَاشْ تَعْرْفُوا الوَقْتْ والزْمَانْ الِّي حَطْهُمْ الآبْ بْسُلْطْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","آمَا وَقْتِلِّي يَهْبِطْ عْلِيكُمْ الرُّوحْ القُدُسْ، بِشْ تَاخْذُوا قُوَّة، وتْكُونُولِي شْهُودْ فِي أُورْشَلِيمْ واليَهُودِيَّة الكُلْ وفِي السَّامْرَة وحَتَّى لْآخِرْ الأَرْضْ». ");
INSERT INTO aeu_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","وكِي قَالْ الكْلَامْ هَاذَا، تِرْفَعْ لِلسْمَاء وهُومَا يُخْزْرُولُو، ومْبَعِّدْ، جَاء سْحَابْ وحِجْبُو مِنْ قُدَّامْ عِينِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ووَقْتِلِّي كَانُوا يُخْزْرُوا لِلسْمَاء وهُوَّ طَالْعِلْهَا، جَاوْ زُوزْ رْجَالْ لَابْسِينْ بِالأَبْيِضْ وِقْفُوا بَحْذَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","وقَالُولْهُمْ: «يَا رْجَالْ الجَلِيلْ، شْبِيكُمْ وَاقْفِينْ تُخْزْرُوا لِلسْمَاء؟ يَسُوعْ هَاذَا الِّي تِرْفَعْ لِلسْمَاء، بِشْ يِرْجَعْ مِنْهَا بْنَفْسْ الطَّرِيقَة الِّي شُفْتُوهْ طَالْعِلْهَا». ");
INSERT INTO aeu_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ومْبَعِّدْ، رَجْعُوا الرُّسُلْ لْأُورْشَلِيمْ مِالجْبَلْ المَعْرُوفْ بِجْبَلْ الزِّيتُونْ، الِّي هُوَّ قْرِيبْ مِنْ أُورْشَلِيمْ مْسَافِةْ كِيلُومَاتِرْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","وَقْتِلِّي وُصْلُوا، طَلْعُوا لِلْعْلِي الِّي كَانُوا سَاكْنِينْ فِيهْ. وكَانُوا غَادِي بُطْرُسْ ويُوحَنَّا، ويَعْقُوبْ، وأَنْدَرَاوُسْ، وفِيلِۑُّسْ، وتُومَا، وبَرْثُلْمَاوُسْ، ومَتَّى، ويَعْقُوبْ وِلْدْ حَلْفَى، وسِمْعَانْ الِّي يْغِيرْ عْلَى بْلَادُو، ويَهُوذَا وِلْدْ يَعْقُوبْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","وكَانُوا الكُلْهُمْ يْدَاوْمُوا عَالصَّلَاةْ بْقَلْبْ وَاحِدْ، ومْعَاهُمْ النْسَاء، ومَرْيِمْ أُمْ يَسُوعْ، وأَخْوْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","وفِي الأَيَّامَاتْ هَاذُوكُمْ، وْقِفْ بُطْرُسْ قُدَّامْ أَخْوْتُو المُؤْمْنِينْ، الِّي كَانْ عْدَدْهُمْ قْرِيبْ لْـ120، وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«يَا خْوَاتِي، كَانْ لَازِمْ تِتْحَقَّقْ النُّبُوَّة الِّي قَالْهَا الرُّوحْ القُدُسْ عْلَى لْسَانْ النَّبِيْ دَاوِدْ، فِي مَا يْخُصْ يَهُوذَا الِّي دَلْ النَّاسْ عْلَى يَسُوعْ بَاشْ يْشِدُّوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","هُوَّ كَانْ وَاحِدْ مِنَّا، وشَارِكْنَا فِي الخِدْمَة. ");
INSERT INTO aeu_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","«وبَعْدْمَا شْرَى أَرْضْ بِالفْلُوسْ الِّي خْذَاهَا عَالشَّرْ الِّي عَمْلُو، طَاحْ فِيهَا عْلَى وِجْهُو، وتْشَقِّتْ كِرْشُو، وخَرْجِتْ مْصَارْنُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","وسُكَّانْ أُورْشَلِيمْ الكُلْ عَرْفُوا الحْكَايَة، يَاخِي سَمَّاوْ السَّانْيَة بْلُوغِتْهُمْ \"حَقْلْ دَمَخْ\"، ومَعْنَاهَا سَانِيةْ الدَّمْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","«ومَكْتُوبْ فِي كْتَابْ المَزَامِيرْ: \"خَلِّي دَارُو تْوَلِّي خِرْبَة، ومَا يُسْكُنْهَا حَدْ\". «وزَادَا: \"خَلِّي خِدْمْتُو يَاخِذْهَا غِيرُو\". ");
INSERT INTO aeu_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","«مَالَا يِلْزِمْنَا نِخْتَارُوا وَاحِدْ مِالرْجَالْ الِّي رَافْقُونَا طُولْ المُدَّة الِّي عَدَّاهَا مْعَانَا الرَّبْ يَسُوعْ، ");
INSERT INTO aeu_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","مِاليُومْ الِّي تْعَمِّدْ فِيهْ عْلَى يْدِينْ يُوحَنَّا لِلْيُومْ الِّي تِرْفَعْ فِيهْ لِلسْمَاء، بَاشْ يْكُونْ شَاهِدْ مْعَانَا عْلَى قْيَامِةْ يَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","يَاخِي الإِخْوَة الحَاضْرِينْ إِقْتَرْحُوا زُوزْ رْجَالْ: يُوسِفْ المَعْرُوفْ بْإِسْمْ بَارْسَابَا ويْعَيْطُولُوا زَادَا يُوسْتُسْ، ومَتِّيَاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","مْبَعِّدْ صَلَّاوْ وقَالُوا: «يَا رَبْ، إِنْتِ تَعْرِفْ قْلُوبْ النَّاسْ الكُلْ، وَرِّينَا أَنَاهُو الِّي اخْتَرْتُو مِالزُّوزْ رْجَالْ هَاذُومَا ");
INSERT INTO aeu_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","بَاشْ يْشَارِكْنَا فِي الخِدْمَة ويْكُونْ رَسُولْ فِي عُوضْ يَهُوذَا الِّي مْشَى لِلبْلَاصَة الِّي يِسْتَاهِلْهَا». ");
INSERT INTO aeu_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","وبَعْدْهَا عَمْلُوا قُرْعَة، طَاحِتْ عْلَى مَتِّيَاسْ، يَاخِي تْزَادْ لِلرُّسُلْ الحْدَاشْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","وَقْتِلِّي جَاء العِيدْ الِّي يْسَمْيوَهْ يُومْ الخَمْسِينْ، كَانُوا المُؤْمْنِينْ الكُلْ مُجْتَمْعِينْ مْعَ بْعَضْهُمْ فِي بُقْعَة وَحْدَة. ");
INSERT INTO aeu_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","وإِذَا بْحِسْ جَاء مِالسْمَاء كَايِنُّو صُوتْ رِيحْ قْوِيْ، ومْلَى البِيتْ الِّي كَانُوا قَاعْدِينْ فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","وظُهْرِتِّلْهُمْ لْسَانَاتْ كَايِنْهَا مِنْ نَارْ، تْفَرْقِتْ وحَطِّتْ عْلَى كُلْ وَاحِدْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","وتِمْلَاوْ الكُلْ بِالرُّوحْ القُدُسْ، وبْدَاوْ يِتْكَلْمُوا بْلُوغَاتْ أُخْرَى، كِيمَا عْطَاهُمْ الرُّوحْ بَاشْ يَنْطْقُوا. ");
INSERT INTO aeu_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","وفِي الوَقْتْ هَاذَاكَا، كَانُوا فِي أُورْشَلِيمْ جْمَاعَة مِاليْهُودْ الِّي يْخَافُوا اللَّهْ، ولِّي جَاوْ مِنْ كُلْ أُمَّة فِي الأَرْضْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","وَقْتِلِّي سَمْعُوا الحِسْ هَاذَاكَا، تْلَمُّوا النَّاسْ عْلِيهُمْ وكَانُوا مِتْعَجْبِينْ، عْلَى خَاطِرْ كُلْ وَاحِدْ كَانْ يِسْمَعْ فِيهُمْ يِتْكَلْمُوا بْلُوغْتُو هُوَّ. ");
INSERT INTO aeu_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","وبِهْتُوا وإِحْتَارُوا ووَلَّاوْ يِسْأْلُوا فِي بْعَضْهُمْ: «مُشْ الِّي قَاعْدِينْ يِتْكَلْمُوا الكُلْهُمْ مِالجَلِيلْ؟ ");
INSERT INTO aeu_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","مَالَا كِيفَاشْ كُلْ وَاحِدْ مِنَّا قَاعِدْ يِسْمَعْ فِي لُوغِةْ البْلَادْ الِّي تُولِدْ فِيهَا؟ ");
INSERT INTO aeu_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","مِنَّا بَرْثِيِّينْ ومَادِيِّينْ وعِيلَامِيِّينْ ومِنَّا مِنْ سُكَّانْ مَنْطَقْةْ مَا بِينْ النَّهْرِينْ واليَهُودِيَّة وكَبَّدُوكِيَّة، وبُنْطُسْ وآسِيَّا ");
INSERT INTO aeu_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","وفَرِيجِيَّة وبَمْفِيلِيَّة ومَصْرْ ومِنْ بْقَايَعْ مِنْ لِيبْيَا مِنْ مَنْطَقْةْ قِيرِينَا ومْعَانَا بَرْشَة زُوَّارْ مِنْ رُومَا، ");
INSERT INTO aeu_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","يْهُودْ أَصْلِيِّينْ ولِّي وَلَّاوْ يْهُودْ وكَرِيتِيِّينْ وعْرَبْ. وهَانَا الكُلْنَا نِسْمْعُوا فِيهُمْ يْكَلْمُوا فِينَا بْلُوغَاتْنَا عْلَى أَعْمَالْ اللَّهْ العْظِيمَة». ");
INSERT INTO aeu_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","وبْدَاوْ الكُلْهُمْ يِسْأْلُوا فِي بْعَضْهُمْ وهُومَا مِسْتَغْرْبِينْ وحَايْرِينْ: «شْنِيَّة الحْكَايَة؟». ");
INSERT INTO aeu_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","آمَا نَاسْ أُخْرِينْ تْمَسْخْرُوا عْلِيهُمْ وقَالُوا: «النَّاسْ هَاذُومَا سْكَارَا». ");
INSERT INTO aeu_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","يَاخِي وْقِفْ بُطْرُسْ مْعَ الرُّسُلْ الحْدَاشْ، وقَالْ لِلْحَاضْرِينْ بْصُوتْ عَالِي: «يَا أَهْلْ اليَهُودِيَّة، ويَلِّي سَاكْنِينْ فِي أُورْشَلِيمْ الكُلْ، إِسْمْعُوا مْلِيحْ الكْلَامْ الِّي بِشْ نْقُولْهُولْكُمْ وأَعْرْفُوا حْقِيقِةْ الِّي قَاعِدْ يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","هَاذُومَا مَاهُمْشْ سْكَارَا كِيمَا تْظُنُّوا، مَزَّالِتْ التِّسْعَة مْتَاعْ الصْبَاحْ! ");
INSERT INTO aeu_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","آمَا هَاذَا هُوَّ الِّي قَالْ عْلِيهْ النَّبِيْ يُوئِيلْ: ");
INSERT INTO aeu_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","\"يْقُولْ اللَّهْ: فِي آخِرْ الزْمَانْ بِشْ نْفِيضْ مِنْ رُوحِي عَالنَّاسْ الكُلْ، ويِتْنَبْؤُوا وْلَادْكُمْ وبْنَاتْكُمْ، ويْشُوفُوا شَبَابْكُمْ رُؤَى، ويِحْلْمُوا كْبَارْكُمْ أَحْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","فِي الأَيَّامَاتْ هَاذُوكُمْ، نْفِيضْ مِنْ رُوحِي عْلَى كُلْ خْدِيمَة وخْدِيمْ عَنْدِي، ويِتْنَبْؤُوا. ");
INSERT INTO aeu_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","وبِشْ نَعْمِلْ عْجَايِبْ لْفُوقْ فِي السْمَاء، وعَلَامَاتْ لُوطَا عَالأَرْضْ دَمْ ونَارْ وبَرْشَة دُخَّانْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","وقْبَلْ مَا يْجِي يُومْ الرَّبْ، هَاكْ النْهَارْ العْظِيمْ المَجِيدْ، الشَّمْسْ تْوَلِّي ظْلَامْ، والڨَمْرَة تْوَلِّي كِي الدَّمْ ");
INSERT INTO aeu_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","وَقْتْهَا كُلْ مِنْ يُطْلُبْ إِسْمْ الرَّبْ يِنْجَى\". ");
INSERT INTO aeu_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","«يَا رْجَالْ إِسْرَائِيلْ، إِسْمْعُوا الكْلَامْ هَاذَا: يَسُوعْ النَّاصْرِي، رَاجِلْ عْطَاهْ اللَّهْ مُعْجْزَاتْ وعْجَايِبْ وعَلَامَاتْ، عْمَلْهَا عْلَى يِدُّو قُدَّامْكُمْ، كِيمَا تَعْرْفُوا. ");
INSERT INTO aeu_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ومْعَ هَاذَا، سْمَحِّلْكُمْ اللَّهْ، حَسْبْ خُطْتُو المَرْسُومَة وعِلْمُو السَّابَقْ، بَاشْ تْشِدُّوهْ وتُصْلْبُوهْ وتُقْتْلُوهْ عْلَى يْدِينْ الأَشْرَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","آمَا اللَّهْ قَيْمُو حَيْ، وكَسِّرْ سْلَاسِلْ المُوتْ، عْلَى خَاطِرْ مَا كَانِتْشْ المُوتْ تْنَجِّمْ تْشِدُّو. ");
INSERT INTO aeu_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","وقَالْ عْلِيهْ دَاوِدْ: \"كُنْتْ نْشُوفْ فِي الرَّبْ دِيمَا قُدَّامِي، هُوَّ دِيمَا مْعَايَا، بَاشْ مَنْخَافِشْ، ");
INSERT INTO aeu_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","هَاذَاكَا عْلَاشْ فْرَحْ قَلْبِي ولْسَانِي سَبَّحْ، وحَتَّى بَدْنِي عَنْدُو رْجَى بَعْدْ المُوتْ، ");
INSERT INTO aeu_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","عْلَى خَاطِرْ مَاكِشْ بِشْ تْخَلِّينِي فِي الهَاوْيَة ومَاكِشْ بِشْ تْخَلِّي قُدُّوسِكْ يِفْسِدْ فِي القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","هْدِيتْنِي لِطْرِيقْ الحَيَاةْ، وتِمْلَانِي بِالفَرْحَة وَقْتِلِّي نْكُونْ مْعَاكْ\". ");
INSERT INTO aeu_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","«يَا خْوَاتِي، خَلِّينِي نْقُولِلْكُمْ بْصَرَاحَة، بُونَا دَاوِدْ مَاتْ وتِدْفِنْ، وقَبْرُو مَوْجُودْ عَنْدْنَا حَتَّى لِلْيُومْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","وهُوَّ كَانْ نَبِيْ ويَعْرِفْ الِّي اللَّهْ حْلِفْلُو بِاليْمِينْ الِّي وَاحِدْ مِنْ ذُرِّيتُو بِشْ يُقْعُدْ عْلَى عَرْشُو. ");
INSERT INTO aeu_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","وشَافْ قْيَامِةْ المَسِيحْ قْبَلْ مَا تْصِيرْ، وتْكَلَّمْ عْلِيهَا كِي قَالْ الِّي اللَّهْ مُشْ بِشْ يْخَلِّيهْ فِي الهَاوْيَة، ومُشْ بِشْ يْخَلِّي بَدْنُو يِفْسِدْ فِي القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","يَسُوعْ هَاذَا قَوْمُو اللَّهْ مِالمُوتْ، وأَحْنَا الكُلْ شْهُودْ عْلَى هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","وكِي رَفْعُو اللَّهْ بْقُدْرْتُو، خْذَا الرُّوحْ القُدُسْ الِّي وْعِدْ بِيهْ الآبْ، وفَاضْ بِيهْ عْلِينَا. ولِّي قَاعْدِينْ تْشُوفُوا فِيهْ وتِسْمْعُوا فِيهْ تَوَّا، هُوَّ النْتِيجَة. ");
INSERT INTO aeu_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ودَاوِدْ مَا طْلَعْشْ لِلسْمَاء، آمَا هُوَّ بِيدُو يْقُولْ: \"قَالْ اللَّهْ لْرَبِّي: أُقْعُدْ عْلَى يْمِينِي، ");
INSERT INTO aeu_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","حَتَّى لِينْ نْحُطْ أَعْدَائِكْ تَحْتْ سَاقِيكْ\". ");
INSERT INTO aeu_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","«هَاذَاكَا عْلَاشْ، لَازِمْ بَنِي إِسْرَائِيلْ الكُلْ يَعْرْفُوا ويِتْأَكْدُوا الِّي اللَّهْ جْعَلْ يَسُوعْ هَاذَا، الِّي إِنْتُومَا صْلَبْتُوهْ، رَبْ ومَسِيحْ!» ");
INSERT INTO aeu_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","وَقْتِلِّي سَمْعُوا الحَاضْرِينْ الكْلَامْ هَاذَا، ضَمِيرْهُمْ أَنَّبْهُمْ، وسِأْلُوا بُطْرُسْ وبْقِيِّةْ الرُّسُلْ: «يَا خْوَاتِي، آشْ نَعْمْلُوا؟». ");
INSERT INTO aeu_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","جَاوِبْهُمْ بُطْرُسْ: «تُوبُوا وخَلِّي كُلْ وَاحِدْ فِيكُمْ يِتْعَمِّدْ بْإِسْمْ يَسُوعْ المَسِيحْ، بَاشْ تِتْغْفَرْ ذْنُوبْكُمْ وهَكَّا تَاخْذُوا هِيبِةْ الرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","عْلَى خَاطِرْ الوَعْدْ هَاذَا لِيكُمْ ولِوْلَادْكُمْ ولِلنَّاسْ البْعَادْ الكُلْ، لْكُلْ وَاحِدْ يَسْتَدْعِيهْ الرَّبْ إِلَاهْنَا». ");
INSERT INTO aeu_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","وكَانْ بُطْرُسْ يِشْهْدِلْهُمْ ويْشَجَّعْ فِيهُمْ إِبَّرْشَة كْلَامْ آخِرْ ويْقُولِلْهُمْ: «مَنّْعُوا رْوَاحْكُمْ مِالجِيلْ الفَاسِدْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ولِّي قِبْلُوا كْلَامُو تْعَمْدُوا. وتْزَادُوا لْمَجْمُوعِةْ المُؤْمْنِينْ فِي النْهَارْ هَاذَاكَا قْرَابِة الـ3 000 وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","وكَانُوا دِيمَا يِسْمْعُوا التَّعْلِيمْ الِّي يْعَلْمُوهْ الرُّسُلْ، ودِيمَا يِتْلَمُّوا مْعَ بْعَضْهُمْ ويِتْشَارْكُوا فِي كُلْ شَيْ، ويَقْسْمُوا الخُبْزْ ويِصَلِّيوْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","وصَارِتْ بَرْشَة مُعْجْزَاتْ وعْجَايِبْ عْلَى يْدِينْ الرُّسُلْ، خَلَّاتْ النَّاسْ الكُلْ بَاهْتِينْ ودَاهْشِينْ . ");
INSERT INTO aeu_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","وكَانُوا المُؤْمْنِينْ الكُلْ مْعَ بْعَضْهُمْ، يِتْشَارْكُوا فِي كُلْ شَيْ: ");
INSERT INTO aeu_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","يْبِيعُوا أَمْلَاكْهُمْ ولِّي يِكْسْبُوهْ، ويَقْسْمُوا الفْلُوسْ بِينَاتْهُمْ عْلَى قَدْ مَا يِحْتَاجْ كُلْ وَاحِدْ مِنْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","وكَانُوا مْوَاظْبِينْ عَالحْضُورْ فِي الهَيْكِلْ كُلْ يُومْ بْقَلْبْ وَاحِدْ، ويَقْسْمُوا الخُبْزْ فِي الدْيَارْ، ويَاكْلُوا مْعَ بْعَضْهُمْ بْفَرْحَة وبْنِيَّة صَافْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","وكَانُوا يْسَبْحُوا اللَّهْ، ولَاقِينْ القْبُولْ عَنْدْ النَّاسْ الكُلْ. وكَانْ الرَّبْ كُلْ يُومْ يْزِيدْ لِلْمَجْمُوعَة النَّاسْ الِّي يِنْجَاوْ بْإِيمَانْهُمْ بِالمَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","نْهَارْ مِالنْهَارَاتْ، مْشَى بُطْرُسْ ويُوحَنَّا لِلْهَيْكِلْ فِي وَقْتْ صْلَاةْ الثْلَاثَة مْتَاعْ العْشِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","وكَانْ بَحْذَا بَابْ الهَيْكِلْ الِّي يِتْسَمَّى بَابْ جْمِيلْ، رَاجِلْ مَشْلُولْ مِلِّي تُولِدْ، يْجِيبُوهْ النَّاسْ كُلْ يُومْ ويْحُطُّوهْ غَادِي ويُقْعُدْ يُطْلُبْ فِي الصَّدْقَة مِنْ عَنْدْ النَّاسْ الدَّاخْلِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ووَقْتِلِّي شَافْ بُطْرُسْ ويُوحَنَّا دَاخْلِينْ لِلْهَيْكِلْ، طْلَبْ مِنْهُمْ صَدْقَة. ");
INSERT INTO aeu_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","يَاخِي خَزْرُولُوا بُطْرُسْ ويُوحَنَّا بِالڨْدَا وقَالُّو بُطْرُسْ: «أُخْزْرِلْنَا!». ");
INSERT INTO aeu_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","خْزَرِّلْهُمْ، مَاشِي فِي بَالُو بِشْ يَاخِذْ مِنْهُمْ حَاجَة. ");
INSERT INTO aeu_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","يَاخِي قَالُّو بُطْرُسْ: «لَا عَنْدِي فُضَّة ولَا ذْهَبْ، آمَا الِّي عَنْدِي نَعْطِيهُولِكْ: بْإِسْمْ يَسُوعْ المَسِيحْ النَّاصْرِي قُومْ وامْشِي!». ");
INSERT INTO aeu_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","وشَدُّو مِنْ يِدُّو اليْمِينْ وقَوْمُو. وبِالوَقْتْ رَجْعِتْ القُوَّة فِي سَاقِيهْ وقْدَامُو. ");
INSERT INTO aeu_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ونَڨِّزْ ووْقِفْ وبْدَا يِمْشِي. ودْخَلْ مْعَاهُمْ لِلْهَيْكِلْ وهُوَّ يِمْشِي ويْنَڨِّزْ وطَايِرْ مِالفَرْحَة ويِحْمِدْ فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","والحَاضْرِينْ الكُلْ شَافُوهْ يِمْشِي ويِحْمِدْ فِي اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","وعَرْفُوهْ الِّي هُوَّ الرَّاجِلْ المَشْلُولْ الِّي مِسْتَانِسْ يُقْعُدْ يُطْلُبْ قُدَّامْ بَابْ جْمِيلْ مْتَاعْ الهَيْكِلْ، يَاخِي بِهْتُوا وتْعَجْبُوا مِلِّي صَارْلُو. ");
INSERT INTO aeu_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","وفِي الوَقْتْ الِّي كَانْ فِيهْ الرَّاجِلْ المَشْلُولْ شَادِدْ جْنَبْ بُطْرُسْ ويُوحَنَّا فِي أَقْوَاسْ الهَيْكِلْ المَعْرُوفَة بْأَقْوَاسْ سُلَيْمَانْ، تْلَمُّوا عْلِيهُمْ بَرْشَة نَاسْ وكَانُوا بَاهْتِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","وَقْتِلِّي شَافْ بُطْرُسْ هَاذَا، قَالِلْهُمْ: «يَا بَنِي إِسْرَائِيلْ، عْلَاشْ بَاهْتِينْ مِلِّي صَارْ؟ وعْلَاشْ تُخْزْرُولْنَا تْقُولِشْ عْلِينَا أَحْنَا بْقُدْرِتْنَا وَلَّا بِالتَّقْوَى مْتَاعْنَا رَدِّينَا الرَّاجِلْ هَاذَا يِمْشِي؟ ");
INSERT INTO aeu_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","رَاهُو إِلَاهْ إِبْرَاهِيمْ وإِسْحَاقْ ويَعْقُوبْ، إِلَاهْ جْدُودْنَا، هُوَّ الِّي مَجِّدْ خَادْمُو يَسُوعْ، الِّي إِنْتُومَا سَلَّمْتُوهْ لِلْمُوتْ ونْكَرْتُوهْ قُدَّامْ بِيلَاطُسْ رَغْمِلِّي كَانْ يْحِبْ يْسَيْبُو. ");
INSERT INTO aeu_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","إِنْتُومَا نْكَرْتُوا القُدُّوسْ الصَّالَحْ، وطْلَبْتُوا مِنْ بِلَاطُسْ بَاشْ يْسَامَحْ وَاحِدْ قَاتِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","قْتَلْتُوا مَنْبَعْ الحَيَاةْ، آمَا اللَّهْ قَوْمُو مِالمُوتْ، وأَحْنَا شْهُودْ عْلَى هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","والرَّاجِلْ هَاذَا الِّي تْشُوفُوا فِيهْ ولِّي تَعْرْفُوهْ رَجْعِتْلُو صَحْتُو عْلَى خَاطِرْ إِيمَانَّا بْإِسْمْ يَسُوعْ. الإِيمَانْ بْيَسُوعْ هُوَّ الِّي عْطَاهْ الصَّحَّة الكَامْلَة قُدَّامْكُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","«آنَا نَعْرِفْ يَا خْوَاتِي، الِّي جَهْلْكُمْ هُوَّ الِّي خَلَّاكُمْ إِنْتُومَا وشْيُوخْكُمْ تِتْصَرْفُوا هَكَّا مْعَ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","آمَا هَكَّا، تَمِّمْ اللَّهْ الِّي وْحَى بِيهْ مِنْ قْبَلْ لِلأَنْبِيَاءْ الكُلْ، الِّي المَسِيحْ بِشْ يِتْعَذَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","مَالَا تُوبُوا وإِرْجْعُوا لِلَّهْ بَاشْ يِغْفْرِلْكُمْ ذْنُوبْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","وتْجِيكُمْ أَيَّامَاتْ الفْرَجْ مِنْ عَنْدُو، ويَبْعْثِلْكُمْ مَرَّة أُخْرَى يَسُوعْ المَسِيحْ الِّي اخْتَارْهُولْكُمْ مِنْ قْبَلْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","آمَا تَوَّا، لَازْمُو يُقْعُدْ فِي السْمَاء حَتَّى يْجِي الوَقْتْ الِّي يِتْصَلَّحْ فِيهْ كُلْ شَيْ، كِيمَا وْحَى اللَّهْ لِلأَنْبِيَاءْ الصَّالْحِينْ، مِنْ قْدِيمْ الزْمَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ومُوسَى قَالْ: \"الرَّبْ إِلَاهْكُمْ بِشْ يِبْعْثِلْكُمْ نَبِيْ كِيفِي مِنْ بِينْ خْوَاتْكُمْ. إِسْمْعُوا كْلَامُو فِلِّي يْقُلْكُمْ عْلِيهْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","آمَا الِّي مَا يِسْمَعْشْ كْلَامُو رَاهُو بِشْ يِتِمْحَى مِالشَّعْبْ\". ");
INSERT INTO aeu_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","وزَادَا الأَنْبِيَاءْ الكُلْ، مِنْ صَمُوئِيلْ حَتَّى لِلِّي جَاوْ بَعْدُو، تْنَبْؤُوا عَالأَيَّامْ هَاذِي. ");
INSERT INTO aeu_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","وإِنْتُومَا وْلَادْ الأَنْبِيَاءْ هَاذُومَا ووْلَادْ العَهْدْ الِّي عَمْلُو اللَّهْ مْعَ جْدُودْنَا، وَقْتِلِّي قَالْ لْإِبْرَاهِيمْ: \"بِشْ نْبَارِكْ شْعُوبْ الأَرْضْ الكُلْ عْلَى طْرِيقْ ذِرِّيتِكْ\". ");
INSERT INTO aeu_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","واللَّهْ قَيِّمْ خَادْمُو وبْعَثْهُولْكُمْ لِيكُمْ إِنْتُومَا الأُولَانِينْ، بَاشْ يْبَارِكُّمْ ويْخَلِّي كُلْ وَاحِدْ فِيكُمْ يِرْجَعْ عَالشَّرْ الِّي يَعْمِلْ فِيهْ». ");
INSERT INTO aeu_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","وَقْتِلِّي كَانْ بُطْرُسْ ويُوحَنَّا يْكَلْمُوا فِي الحَاضْرِينْ، جَاوْهُمْ الكَهَنَة وقَايِدْ حَرَسْ الهَيْكِلْ وجْمَاعَة مِالصَّدُّوقِيِّينْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","وكَانُوا مِتْغَشْشِينْ مِنْ بُطْرُسْ ويُوحَنَّا عْلَى خَاطِرْ كَانُوا يْعَلْمُوا فِي النَّاسْ ويْقُولُوا الِّي المُوتَى بِشْ يْقُومُوا مِالمُوتْ مَادَامْ يَسُوعْ قَامْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","يَاخِي شَدُّوهُمْ، وعْلَى خَاطِرْ الدِّنْيَا ظْلَامِتْ، حَطُّوهُمْ فِي الحَبْسْ حَتَّى لْغُدْوَة. ");
INSERT INTO aeu_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","آمَا، بَرْشَة مِلِّي سَمْعُوا الكْلَامْ الِّي قَالُوهْ بُطْرُسْ ويُوحَنَّا أَمْنُوا. ووَلَّى عْدَدْ الرْجَالْ الِّي أَمْنُوا قْرَابِةْ الـ5 000. ");
INSERT INTO aeu_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ومِنْ غُدْوَة، تْلَمُّوا قَادِةْ اليْهُودْ والشْيُوخْ وعُلَمَاءْ الشَّرِيعَة فِي أُورْشَلِيمْ، ");
INSERT INTO aeu_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ومْعَاهُمْ حَنَّانْ الكَاهِنْ الكْبِيرْ، وقِيَافَا، ويُوحَنَّا، والإِسْكَنْدَرْ، وامَّالِي كْبَارْ الكَهَنَة الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","وجَابُوا بُطْرُسْ ويُوحَنَّا فِي الوِسْطْ وسِأْلُوهُمْ: «بَانَا قُوَّة، وبِاسْمْ شْكُونْ عْمَلْتُوا هَاذَا؟». ");
INSERT INTO aeu_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","يَاخِي تِمْلَى بُطْرُسْ بِالرُّوحْ القُدُسْ وجَاوِبْهُمْ: «يَا قَادِةْ الشَّعْبْ وإِنْتُومَا يَا شْيُوخُو، ");
INSERT INTO aeu_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","إِذَا كَانْكُمْ تِسْتَجْوْبُوا فِينَا اليُومْ عْلَى خَاطِرْ عْمَلْنَا الخِيرْ مْعَ وَاحِدْ مْرِيضْ، وتْحِبُّوا تَعْرْفُوا كِيفَاشْ بْرَا، ");
INSERT INTO aeu_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","مَالَا أَعْرْفُوا، وخَلِّي شَعْبْ إِسْرَائِيلْ الكُلُّو يَعْرِفْ، الِّي المَشْلُولْ هَاذَا وَاقِفْ قُدَّامْكُمْ لَابَاسْ عْلِيهْ بْقُوِّةْ إِسْمْ يَسُوعْ المَسِيحْ النَّاصْرِي، الِّي صْلَبْتُوهْ ولِّي اللَّهْ قَوْمُو مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","يَسُوعْ هَاذَا: هُوَّ الحَجْرَة الِّي رْفَضْتُوهَا إِنْتُومَا البَنَّايَا، ولِّي وَلَّاتْ حَجْرِةْ السَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","«مَا فَمَّة نْجَاةْ كَانْ عْلَى طْرِيقُو هُوَّ، عْلَى خَاطِرْ مَا فَمَّة حَتَّى إِسْمْ آخِرْ عْطَاهْ اللَّهْ لِلنَّاسْ انَّجْمُوا نِنْجَاوْ بِيهْ». ");
INSERT INTO aeu_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","وَقْتِلِّي شَافُوا الحَاضْرِينْ فِي المَجْلِسْ شَجَاعِةْ بُطْرُسْ ويُوحَنَّا، وعَرْفُوا الِّي هُومَا نَاسْ عَادِيِّينْ ومُشْ مِتْعَلْمِينْ، تْعَجْبُوا. وَقْتْهَا عَرْفُوا الِّي هُومَا كَانُوا مْعَ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","آمَا كِي شَافُوا المَشْلُولْ الِّي بْرَا وَاقِفْ مْعَاهُمْ، مَا لْقَاوْ مَا يْقُولُوا. ");
INSERT INTO aeu_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","وَلَّاوْ أَمْرُوهُمْ بَاشْ يُخْرْجُوا مِالمَجْلِسْ، وقَعْدُوا يِتْشَاوْرُوا مْعَ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","وقَالُوا: «آشْ نَعْمْلُوا مْعَ الزُّوزْ رْجَالْ هَاذُومَا؟ سُكَّانْ أُورْشَلِيمْ الكُلْ يَعْرْفُوا الِّي مُعْجْزَة كْبِيرَة صَارِتْ عْلَى يْدِيهُمْ، ومَا انَّجْمُوشْ نُنْكْرُوهَا. ");
INSERT INTO aeu_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","آمَا بَاشْ الخْبَرْ مَا يْزِيدِشْ يِتِنْشَرْ، لَازِمْ نْهَدْدُوهُمْ بَاشْ مَا عَادِشْ يَحْكِيوْ لْحَتَّى حَدْ آخِرْ عَالإِسْمْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","يَاخِي عَيْطُولْهُمْ وأَمْرُوهُمْ بَاشْ مَا عَادِشْ يَنْطْقُوا ولَا يْعَلْمُوا النَّاسْ بْإِسْمْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","آمَا بُطْرُسْ ويُوحَنَّا قَالُولْهُمْ: «أُحْكْمُوا إِنْتُومَا! شْنُوَّة الصْحِيحْ عَنْدْ اللَّهْ؟ نْطِيعُوكُمْ إِنْتُومَا وَلَّا نْطِيعُوا اللَّهْ؟ ");
INSERT INTO aeu_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","وأَحْنَا، مَا انَّجْمُوشْ نُسْكْتُوا ومَا نَحْكِيوِشْ عَلِّي رِينَاهْ وسْمَعْنَاهْ». ");
INSERT INTO aeu_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","يَاخِي هَدْدُوهُمْ مَرَّة أُخْرَى، ومَا لْقَاوِشْ كِيفَاشْ يْعَاقْبُوهُمْ. وَلَّاوْ سَيْبُوهُمْ عْلَى خَاطِرْ خَافُوا مِالشَّعْبْ، الِّي كَانْ الكُلُّو يْمَجِّدْ فِي اللَّهْ عَلِّي صَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","والرَّاجِلْ الِّي تِشْفَى بِالمُعْجْزَة كَانْ عُمْرُو فُوقْ الـ40 سْنَة. ");
INSERT INTO aeu_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","بَعْدْمَا تْسَيْبُوا، رَجْعُوا بُطْرُسْ ويُوحَنَّا لِصْحَابْهُمْ، وحْكَاوِلْهُمْ عْلَى كُلْ الِّي قَالُوهُولْهُمْ كْبَارْ الكَهَنَة والشْيُوخْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","وكِي سَمْعُوا هَاذَا، بْدَاوْ يْصَلِّيوْ بْقَلْبْ وَاحِدْ قَالُوا: «يَا رَبْ، يَا خَالِقْ السْمَاء والأَرْضْ والبْحَرْ وكُلْ مَا فِيهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","إِنْتِ الِّي قُلْتْ بِالرُّوحْ القُدُسْ عْلَى لْسَانْ بُونَا وعَبْدِكْ دَاوِدْ: \"عْلَاشْ الأُمَمْ هَاجُوا؟ وتْآمْرُوا الشُّعُوبْ مِنْ غِيرْ فَايْدَة؟ ");
INSERT INTO aeu_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","تْلَمُّوا مُلُوكْ الأَرْضْ ورُؤَسَاءْهَا، وتْحَالْفُوا ضِدْ الرَّبْ ومَسِيحُو!\". ");
INSERT INTO aeu_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","«وبِالفِعْلْ، الكْلَامْ هَاذَا تْحَقَّقْ، كِي تْحَالِفْ هِيرُودُسْ، وبِيلَاطُسْ البُنْطِي، واليْهُودْ والشُّعُوبْ الأُخْرِينْ، ضِدْ عَبْدِكْ القُدُّوسْ يَسُوعْ، الِّي إِنْتِ اخْتَرْتُو بَاشْ يْكُونْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","وعَمْلُوا كُلْ الِّي إِنْتِ سْبَقْتْ وقَرَّرْتُو بْقُدْرْتِكْ وحِكْمْتِكْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","وتَوَّا يَا رَبْ، شُوفْ كِيفَاشْ يْهَدْدُوا فِينَا، واعْطِينَا أَحْنَا عَبِيدِكْ القُوَّة بَاشْ نِتْكَلْمُوا بِكْلَامِكْ مِنْ غِيرْ خُوفْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ومِدْ يِدِّكْ واشْفِي، وخَلِّي مُعْجْزَاتْ وعْجَايِبْ تْصِيرْ بْإِسْمْ عَبْدِكْ القُدُّوسْ يَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","وكِي كَمْلُوا الصْلَاةْ، تْزَلْزْلِتْ البْلَاصَة الِّي كَانُوا مَلْمُومِينْ فِيهَا، وتِمْلَاوْ الكُلْهُمْ بِالرُّوحْ القُدُسْ وبْدَاوْ يِتْكَلْمُوا بِكْلَامْ اللَّهْ مِنْ غِيرْ خُوفْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","والمُؤْمْنِينْ كَانُوا قَلْبْ وَاحِدْ ونَفْسْ وَحْدَة، ولِّي عَنْدُو حَاجَة مَا كَانِشْ يْقُولْ «هَاذِي مْتَاعِي وَحْدِي»، آمَا كَانُوا يِتْشَارْكُوا فِي كُلْ شَيْ عَنْدْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","وكَانُوا الرُّسُلْ يِشْهْدُوا عْلَى قْيَامِةْ الرَّبْ يَسُوعْ بْقُوَّة كْبِيرَة، ونِعْمِةْ اللَّهْ العْظِيمَة كَانِتْ عْلِيهُمْ الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ومَا كَانْ حَدْ فِيهُمْ مُحْتَاجْ، عْلَى خَاطِرْ الِّي كَانُوا عَنْدْهُمْ دْيَارْ وَلَّا أَرَاضِي كَانُوا يْبِيعُوهُمْ ويْجِيبُوا فْلُوسْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ويْحُطُّوهُمْ عَنْدْ الرُّسُلْ، وهُومَا يْفَرْقُوا بْحَسْبْ حَاجِةْ كُلْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","وهَكَّا عْمَلْ يُوسِفْ، الِّي الرُّسُلْ سَمَّاوَهْ بَرْنَابَا (مَعْنَاهَا وِلْدْ التَّشْجِيعْ) وهُوَّ مِنْ عْشِيرِةْ لَاوِي، ومَوْلُودْ فِي قُبْرُصْ. ");
INSERT INTO aeu_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","بَاعْ الأَرْضْ مْتَاعُو، وجَابْ فْلُوسْهَا وحَطْهُمْ عَنْدْ الرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","وكَانْ فَمَّة رَاجِلْ إِسْمُو حَنَانْيَا، تْفَاهِمْ مْعَ مَرْتُو سَفِيرَة، وبَاعْ أَرْضْ كَانْ يِمْلِكْهَا، ");
INSERT INTO aeu_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ونَحَّى مِنْ فْلُوسْ البِيعَة وخَلَّاهُمْ لْرُوحُو، وكَانِتْ مَرْتُو فِي بَالْهَا. ومْبَعِّدْ جَابْ البَاقِي وحَطُّو قُدَّامْ الرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","يَاخِي قَالُّو بُطْرُسْ: «يَا حَنَانْيَا! عْلَاشْ خَلِّيتْ الشِّيطَانْ يَمْلَالِكْ قَلْبِكْ، وخَلَّاكْ تِكْذِبْ عَالرُّوحْ القُدُسْ، وتْخَبِّي لْرُوحِكْ فْلُوسْ مِنْ سُومْ الأَرْضْ؟ ");
INSERT INTO aeu_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","يَاخِي مَا كَانِتْشْ بِشْ تِبْقَالِكْ لَوْ كَانْ مَا بِعْتْهَاشْ؟ وكِي بَعْتْهَا كُنْتْ تْنَجِّمْ تِتْصَرِّفْ فِي فْلُوسْهَا كِيمَا يُظْهُرْلِكْ. عْلَاشْ نْوِيتْ بَاشْ تْغُشْ؟ إِنْتِ مَا كْذِبْتِشْ عَالنَّاسْ آمَا كْذِبْتْ عْلَى اللَّهْ!». ");
INSERT INTO aeu_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","دُوبْ مَا سْمَعْ حَنَانْيَا الكْلَامْ هَاذَا، طَاحْ ومَاتْ عَالبْلَاصَة، والنَّاسْ الِّي سَمْعُوا بِيهْ خَافُوا بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","وجَاوْ شَبَابْ وكَفْنُوهْ، وهَزُّوا دِفْنُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","وبَعْدْ قْرَابِةْ ثْلَاثَة سْوَايَعْ، دَخْلِتْ مَرْتْ حَنَانْيَا، وهِيَّ مَا تَعْرَفْشْ الِّي صَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","سْإِلْهَا بُطْرُسْ: «قُلِّي، يَاخِي بِالسُّومْ هَاذَا بَعْتُوا الأَرْضْ؟». جَاوْبِتُو: «إِيْ نْعَمْ، بِالسُّومْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","قَالِلْهَا بُطْرُسْ: «عْلَاشْ تْفَاهِمْتْ مْعَ رَاجْلِكْ بَاشْ تْجَرْبُوا رُوحْ الرَّبْ؟ آهُومَا الشَّبَابْ الِّي دِفْنُوا رَاجْلِكْ وَاقْفِينْ فِي البَابْ، وبِشْ يْهِزُّوكْ إِنْتِ زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","وبِالوَقْتْ طَاحِتْ عَنْدْ سَاقِينْ بُطْرُسْ ومَاتِتْ. كِي دَخْلُوا الشَّبَابْ لْقَاوْهَا مِيتَة، هَزُّوهَا ودِفْنُوهَا بَحْذَا رَاجِلْهَا. ");
INSERT INTO aeu_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","وخَافُوا المُؤْمْنِينْ الكُلْ، وزَادَا النَّاسْ الِّي سَمْعُوا الخْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","وصَارِتْ عْلَى يْدِينْ الرُّسُلْ بَرْشَة مُعْجْزَاتْ وعْجَايِبْ فِي وِسْطْ الشَّعْبْ. وكَانُوا الكُلْهُمْ يِتْلَمُّوا بْقَلْبْ وَاحِدْ فِي الهَيْكِلْ وِينْ أَقْوَاسْ سُلَيْمَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","وحَتَّى حَدْ مِلِّي مَا كَانُوشْ تَابْعِينْهُمْ مَا تْشَجَّعْ بَاشْ يْوَلِّي مْعَاهُمْ. آمَا الشَّعْبْ كَانْ يْقَدِّرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","وكَانْ عْدَدْ الِّي يَمْنُوا بِالرَّبْ مِالرْجَالْ والنْسَاء يِمْشِي ويْزِيدْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","وكَانُوا النَّاسْ يْهِزُّوا المُرْضَى ويْحُطُّوهُمْ عْلَى فْرُوشَاتْ وحْصُرْ فِي الشَّارَعْ وَقْتِلِّي يِتْعَدَّى بُطْرُسْ، فَمَّاشْ مَا يْجِي ظِلُّو عْلَى جْمَاعَة مِنْهُمْ، ويِبْرَاوْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","وبَرْشَة نَاسْ مِالدْشُرْ القْرِيبَة لْأُورْشَلِيمْ كَانُوا يْجِيبُوا المُرْضَى ولِّي مْعَذْبِتْهُمْ الأَرْوَاحْ الشِّرِّيرَة، وكَانُوا الكُلْهُمْ يِبْرَاوْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","يَاخِي الكَاهِنْ الكْبِيرْ وجْمَاعْتُو التَّابْعِينْ لْمَذْهِبْ الصَّدُّوقِيِّينْ كْلَاتْهُمْ الغِيرَة مِالرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","وَلَّاوْ شَدُّوهُمْ وحَطُّوهُمْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","آمَا مَلَاكْ مِنْ عَنْدْ الرَّبْ حَلْ بِيبَانْ الحَبْسْ فِي اللِّيلْ، وسَيَّبْهُمْ وقَالِلْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«إِمْشِيوْ آقْفُوا فِي الهَيْكِلْ، وأَحْكِيوْ لِلنَّاسْ عْلَى بْشَارِةْ الحَيَاةْ الجْدِيدَة كَامْلَة». ");
INSERT INTO aeu_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","سَمْعُوا كْلَامُو، ومْشَاوْ لِلْهَيْكِلْ مْعَ الفَجْرْ وبْدَاوْ يْعَلْمُوا. وجَاء الكَاهِنْ الكْبِيرْ وجْمَاعْتُو، وعْمَلْ إِجْتِمَاعْ مْعَ المَجْلِسْ الأَعْلَى، حَضْرُوا فِيهْ شْيُوخْ إِسْرَائِيلْ الكُلْ، وأَمْرُوا بَاشْ يْجِيبُوا الرُّسُلْ مِالحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","آمَا كِي وِصْلُوا الِّي بَعْثُوهُمْ لِلحَبْسْ مَا لْقَاوْهُمْشْ، وَلَّاوْ رَجْعُوا لِلمَجْلِسْ وقَالُوا: ");
INSERT INTO aeu_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","«لْقِينَا بِيبَانْ الحَبْسْ مْسَكْرَة بِالڨْدَا، والعَسَّاسَة وَاقْفِينْ قُدَّامْهُمْ. آمَا وَقْتِلِّي حَلِّينَاهُمْ مَا لْقِينَا حَتَّى حَدْ لْدَاخِلْ». ");
INSERT INTO aeu_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","وَقْتِلِّي سْمَعْ قَايِدْ حَرَسْ الهَيْكِلْ، وكْبَارْ الكَهَنَة الكْلَامْ هَاذَا، بِهْتُوا وبْدَاوْ يِسْأْلُوا فِي بْعَضْهُمْ: «زَعْمَة شْنُوَّة الِّي صَارْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","وجَاء رَاجِلْ وقَالِلْهُمْ: «الرْجَالْ الِّي حَطِّيطُوهُمْ فِي الحَبْسْ وَاقْفِينْ فِي الهَيْكِلْ يْعَلْمُوا فِي النَّاسْ!». ");
INSERT INTO aeu_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","وَلَّى مْشَى قَايِدْ حَرَسْ الهَيْكِلْ هُوَّ والحَرَسْ، وجَابُوا الرُّسُلْ بِالسْيَاسَة، عْلَى خَاطِرْ خَافُوا لَا الشَّعْبْ يُرْجُمْهُمْ كَانْ جَابُوهُمْ بِالقُوَّة. ");
INSERT INTO aeu_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","وَقْتِلِّي دَخّْلُوهُمْ قُدَّامْ المَجْلِسْ، قَالِلْهُمْ الكَاهِنْ الكْبِيرْ: ");
INSERT INTO aeu_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","«نَبَّهْنَا عْلِيكُمْ بَاشْ مَا تْعَلْمُوشْ بِالإِسْمْ هَاذَا، آمَا إِنْتُومَا مْلِيتُوا أُورْشَلِيمْ بْتَعْلِيمْكُمْ، وتْحِبُّوا تْحَمْلُونَا أَحْنَا مَسْؤُولِيِّةْ قَتْلَانْ الرَّاجِلْ هَاذَا!». ");
INSERT INTO aeu_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","يَاخِي بُطْرُسْ والرُّسُلْ جَاوْبُوا: «لَازِمْنَا نْطِيعُوا اللَّهْ مُشْ النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","إِلَاهْ جْدُودْنَا قَيِّمْ يَسُوعْ الِّي إِنْتُومَا عَلَّقْتُوهْ عْلَى لُوحَة وقْتَلْتُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","واللَّهْ كِرْمُو وحَطُّو عْلَى يْمِينُو، بَاشْ يْكُونْ هُوَّ المَلِكْ والمُنَجِّي، بَاشْ يَعْطِي لْبَنِي إِسْرَائِيلْ التَّوْبَة وغُفْرَانْ الذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","وأَحْنَا شْهُودْ عْلَى هَاذَا، والرُّوحْ القُدُسْ الِّي عْطَاهْ اللَّهْ لِلنَّاسْ الِّي يْطِيعُوهْ، يِشْهِدْ زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","وكِي سَمْعُوا الِّي فِي المَجْلِسْ الكْلَامْ هَاذَا تْغَشْشُوا بَرْشَة وحَبُّوا يُقْتْلُوا الرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","آمَا وْقِفْ وَاحِدْ مِنْهُمْ إِسْمُو غَمَالَائِيلْ، وهُوَّ فِرِّيسِي مِلِّي يْعَلْمُوا فِي الشَّرِيعَة، والنَّاسْ الكُلْ تِحْتَرْمُو، وأْمَرْ بَاشْ يْخَرْجُوا الرُّسُلْ شْوَيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ومْبَعِّدْ قَالْ لِلمَجْلِسْ: «يَا بَنِي إِسْرَائِيلْ، رُدُّوا بَالْكُمْ تَعْمْلُوا الِّي نَاوِينْ تَعْمْلُوهْ فِي الرْجَالْ هَاذُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","رَاهُو قْبَلْ بْمُدَّة، جَاء وَاحِدْ إِسْمُو ثُودَاسْ وعْمَلْ رُوحُو زَعْمَة إِنْسَانْ عْظِيمْ، وتَبْعُوهْ 400 رَاجِلْ. آمَا نْهَارِةْ الِّي تِقْتَلْ، الِّي تَبْعُوهْ الكُلْ تْفَرْقُوا، ووْفَاتْ حْكَايْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","وبَعْدُو، فِي وَقْتْ حِسْبَانْ الشَّعْبْ، جَاء يَهُوذَا الجَلِيلِي ومْشَاوْ فِي جُرْتُو بَرْشَة نَاسْ. آمَا هُوَّ زَادَا تِقْتَلْ، وتْفَرْقُوا الِّي تَبْعُوهْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","وآنَا نَنْصَحْكُمْ بَاشْ تِبْعْدُوا عْلَى الرْجَالْ هَاذُومَا ومَا تِهْتَمُّوشْ بِيهُمْ. وإِذَا كَانِتْ أَفْكَارْهُمْ وأَعْمَالْهُمْ مِنْ عَنْدْ النَّاسْ، رَاهِي بِشْ تِفْشِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","آمَا إِذَا كَانِتْ بِالحَقْ مِنْ عَنْدْ اللَّهْ، رَاكُمْ مَا تْنَجْمُوشْ تْوَقْفُوهُمْ، والَّا تْوَلِّيوْ إِنْتُومَا أَعْدَاءْ لِلَّهْ زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","يَاخِي عْمَلْ المَجْلِسْ بِنْصِيحْتُو واسْتَدْعَاوْ الرُّسُلْ وجِلْدُوهُمْ وأَمْرُوهُمْ بَاشْ مَا عَادِشْ يْعَلْمُوا بْإِسْمْ يَسُوعْ، وبَعْدْ سَيْبُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","وخَرْجُوا الرُّسُلْ مِالمَجْلِسْ فَرْحَانِينْ عْلَى خَاطِرْ اللَّهْ اعْتَبَرْهُمْ أَهْلْ بَاشْ يِتْهَانُوا فِي جُرِّةْ إِسْمْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","وكَانُوا كُلْ يُومْ فِي الهَيْكِلْ وفِي الدْيَارْ، يْعَلْمُوا ويْبَشْرُوا الِّي يَسُوعْ هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","وفِي الأَيَّامَاتْ هَاذُوكُمْ، كِي زَادُوا كُثْرُوا التْلَامْذَة، تْشَكَّاوْ المُؤْمْنِينْ اليُونَانِيِّينْ مِالمُؤْمْنِينْ العِبْرَانِيِّينْ، عْلَى خَاطِرْ هَجَّالَاتْهُمْ مَا كَانُوشْ يَاخْذُوا فِي بَايْهُمْ مِالإِعَانَاتْ الِّي تِتْفَرَّقْ كُلْ يُومْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","يَاخِي الرُّسُلْ الأَثْنَاشْ اسْتَدْعَاوْ التْلَامْذَةْ وقَالُولْهُمْ: «مَا يْجِيشْ نْسَلْمُوا فِي تَعْلِيمْ كِلْمِةْ اللَّهْ ونِتِلْهَاوْ نْفَرْقُوا فِي المَاكْلَة. ");
INSERT INTO aeu_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","مَالَا، إِخْتَارُوا مِنْكُمْ سَبْعَة رْجَالْ، سُمْعِتْهُمْ بَاهْيَة ومِلْيَانِينْ بِالرُّوحْ القُدُسْ والحِكْمَة، خَلِّي نْكَلْفُوهُمْ بِالخِدْمَة هَاذِي. ");
INSERT INTO aeu_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","وأَحْنَا نْرَكْزُوا عَالصْلَاةْ وخِدْمِةْ الكِلْمَة». ");
INSERT INTO aeu_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","الإِقْتِرَاحْ هَاذَا عْجِبْ التْلَامْذَة الكُلْ، واخْتَارُوا اسْتِفَانُوسْ، رَاجِلْ مِلْيَانْ بِالإِيمَانْ وبِالرُّوحْ القُدُسْ، وفِيلِۑُّسْ، وبُرُوخُورُسْ ونِيكَانُورْ، وتِيمُونْ، وبَرْمِينَاسْ ونِيقُولَاوُسْ الأَنْطَاكِي الِّي وَلَّى يْهُودِي قْبَلْ مَا يْوَلِّي مَسِيحِي. ");
INSERT INTO aeu_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","وجَابُوهُمْ ووَقْفُوهُمْ قُدَّامْ الرُّسُلْ. يَاخِي صَلَّاوْ وحَطُّوا عْلِيهُمْ يْدِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","وكَانِتْ كِلْمِةْ اللَّهْ تِنْتَشِرْ فِيسَعْ، وعْدَدْ التْلَامْذَةْ فِي أُورْشَلِيمْ يْزِيدْ، وبَرْشَة كَهَنَة طَاعُوا وأَمْنُوا بْيَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","وكَانْ اسْتِفَانُوسْ مِلْيَانْ بِالنِّعْمَة والقُوَّة، وكَانْ يَعْمِلْ فِي عْجَايِبْ ومُعْجْزَاتْ كْبِيرَة وِسْطْ الشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","يَاخِي جَاوْ ضِدُّو جْمَاعَة مِالمَعْبِدْ الِّي مْسَمِّينُو مَعْبِدْ العَبِيدْ الِّي تْحَرْرُوا، ومْعَاهُمْ يْهُودْ مِنْ قِيرِينَا والإِسْكَنْدَرِيَّة ومِنْ مَنْطَقْةْ كِيلِيكِيَّا وآسِيَّا، وبْدَاوْ يْنَاقْشُوا فِي اسْتِفَانُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","آمَا مَا نَجْمُوشْ يِغْلْبُوا الحِكْمَة الِّي عْطَاهَالُو الرُّوحْ القُدُسْ فِي الكْلَامْ. ");
INSERT INTO aeu_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","وَلَّاوْ رْشَاوْ جْمَاعَة بَاشْ يْقُولُوا: «سْمَعْنَا اسْتِفَانُوسْ يْقُولْ كْلَامْ كُفْرْ عْلَى مُوسَى وعْلَى اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","وهَكَّا هَيْجُوا الشَّعْبْ والشْيُوخْ وعُلَمَاءْ الشَّرِيعَة عْلَى اسْتِفَانُوسْ، وشَدُّوهْ وجَابُوهْ قُدَّامْ المَجْلِسْ الأَعْلَى، ");
INSERT INTO aeu_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","وجَابُوا شْهُودْ زُورْ يْقُولُوا: «الرَّاجِلْ هَاذَا دِيمَا يِتْكَلَّمْ ضِدْ الهَيْكِلْ وضِدْ الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","وسْمَعْنَاهْ يْقُولْ الِّي يَسُوعْ النَّاصْرِي بَاشْ يِهِدْ الهَيْكِلْ ويْبَدِّلْ العَادَاتْ الِّي خْذِينَاهَا مِنْ عَنْدْ مُوسَى». ");
INSERT INTO aeu_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","وَقْتِلِّي النَّاسْ الِّي فِي المَجْلِسْ خَزْرُوا لِاسْتِفَانُوسْ، شَافُوا وِجْهُو كَايِنُّو وِجْهْ مْلَايْكَة. ");
INSERT INTO aeu_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","يَاخِي سِأْلُو الكَاهِنْ الكْبِيرْ: «صْحِيحْ الِّي مِتَّهْمِينِكْ بِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","جَاوْبُو: «يَا خْوَاتِي ويَا شْيُوخْنَا، إِسْمْعُونِي! إِلَاهْ المَجْدْ ظْهُرْ لْبُونَا إِبْرَاهِيمْ وهُوَّ فِي بْلَادْ مَا بِينْ النَّهْرِينْ، قْبَلْ مَا يُسْكُنْ فِي مْدِينِةْ حَارَانْ، ");
INSERT INTO aeu_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","وقَالُّو: \"خَلِّي أَرْضِكْ وأَهْلِكْ وامْشِي لِلْأَرْضْ الِّي بِشْ نْوَرِّيهَالِكْ\". ");
INSERT INTO aeu_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ورْحَلْ مِنْ بْلَادْ الكِلْدَانِيِّينْ وسْكِنْ فِي حَارَانْ لِينْ مَاتْ بُوهْ، وبَعْدْ جَابُو اللَّهْ لِلبْلَادْ هَاذِي الِّي تُسْكْنُوا فِيهَا تَوَّا. ");
INSERT INTO aeu_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ومَا وَرّْثُو شَيْ مِنْهَا ولَا حَتَّى شْبِرْ. آمَا وِعْدُو بِشْ يَعْطِيهَالُو لِيهْ ولْذُرِّيتُو مِنْ بَعْدُو، رَغْمِلِّي وَقْتْهَا مَا كَانِشْ عَنْدُو وْلَادْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","«واللَّهْ قَالُّو: \"ذُرِّيتِكْ بِشْ يِتْغَرْبُوا فِي بْلَادْ مَاهِيشْ بْلَادْهُمْ، وامَّالِيهَا بِشْ يِسْتَعِبْدُوهُمْ ويْذِلُّوهُمْ مُدِّةْ 400 سْنَة. ");
INSERT INTO aeu_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","آمَا آنَا بِشْ نْعَاقِبْ الشَّعْبْ الِّي يِسْتَعْبِدْهُمْ. وبَعْدْهَا، يُخْرْجُوا مِالبْلَادْ هَاذِيكَا ويْجِيوْ يِعْبْدُونِي فِي البْلَاصَة هَاذِي\". ");
INSERT INTO aeu_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","وطْلَبْ اللَّهْ مِنْ إِبْرَاهِيمْ بَاشْ يْطَهِّرْ الذْكُورَة الِّي فِي عَايِلْتُو عَلَامَة لِلعَهْدْ الِّي عَمْلُو مْعَاهْ. وهَكَّا وَقْتِلِّي تُولِدْ إِسْحَاقْ، طَهْرُو فِي النْهَارْ الثَّامِنْ، وإِسْحَاقْ طَهِّرْ وِلْدُو يَعْقُوبْ، ويَعْقُوبْ طَهِّرْ ولَادُو الأَثْنَاشْ، الِّي هُومَا جْدُودْنَا الأُولَانِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","«وجْدُودْنَا الأُولَانِينْ حِسْدُوا يُوسِفْ وبَاعُوهْ، ووَلَّى عَبْدْ فِي مَصْرْ. آمَا اللَّهْ كَانْ مْعَاهْ، ");
INSERT INTO aeu_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ومَنّْعُو مِالمَشَاكِلْ الِّي صَارِتْلُو الكُلْ، وعْطَاهْ نِعْمَة وحِكْمَة قُدَّامْ فَرْعُونْ مَلِكْ مَصْرْ. يَاخِي رَدُّو فَرْعُونْ مَسْؤُولْ عْلَى مَصْرْ وعْلَى قَصْرُو. ");
INSERT INTO aeu_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","«وصَارِتْ بَعْدْهَا مَجَاعَة فِي مَصْرْ الكُلْ وفِي أَرْضْ كَنْعَانْ، وعَانَاوْ جْدُودْنَا مِنْ ضِيقْ كْبِيرْ ومَا لْقَاوْ مَا يَاكْلُوا. ");
INSERT INTO aeu_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","وكِي سْمَعْ يَعْقُوبْ الِّي فَمَّة قَمْحْ فِي مَصْرْ، بْعَثِّلْهَا جْدُودْنَا المَرَّة الأُولَى. ");
INSERT INTO aeu_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","وفِي المَرَّة الثَّانْيَة، يُوسِفْ عَرِّفْهُمْ بْرُوحُو، وهَكَّا فَرْعُونْ وَلَّى يَعْرِفْ أَصْلْ يُوسِفْ مْنِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","وبْعَثْ يُوسِفْ جَابْ بُوهْ يَعْقُوبْ، وجَابْ أَهْلُو وامَّالِيهْ الكُلْ لْمَصْرْ، وكَانُوا 75 وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","وهْبَطْ يَعْقُوبْ وجْدُودْنَا لْمَصْرْ، وقَعْدُوا فِيهَا حَتَّى لِينْ مَاتُوا. ");
INSERT INTO aeu_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ونَقّْلُوهُمْ لْمَنْطَقْةْ شَكِيمْ، ودِفْنُوهُمْ غَادِي، فِي القْبَرْ الِّي شْرَاهْ إِبْرَاهِيمْ مِنْ أَوْلَادْ حَمُورْ بِشْوَيَّة فُضَّة. ");
INSERT INTO aeu_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","«وكِي قْرُبْ الوَقْتْ الِّي بِشْ يْتَمِّمْ فِيهْ اللَّهْ وَعْدُو لِإِبْرَاهِيمْ، كَانْ شَعْبْنَا فِي مَصْرْ يُكْثُرْ ويْزِيدْ فِي العْدَدْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","مْبَعِّدْ جَاء مَلِكْ جْدِيدْ عْلَى مَصْرْ، مَا كَانِشْ يَعْرِفْ حْكَايِةْ يُوسِفْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","يَاخِي دَارْ عْلَى شَعْبْنَا وذَلْ جْدُودْنَا، ولَزْهُمْ بَاشْ يْسَلْمُوا فِي وْلَادْهُمْ ويْخَلِّيوْهُمْ يْمُوتُوا. ");
INSERT INTO aeu_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","وفِي الوَقْتْ هَاذَاكَا تُولِدْ مُوسَى، وكَانْ مِزْيَانْ بَرْشَة، وتْرَبَّى مْعَ أُمُّو وبُوهْ لْمُدِّةْ ثْلَاثَة شْهُورْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","آمَا وَقْتِلِّي تْلَزُّوا بَاشْ يْسَلْمُوا فِيهْ، بِنْتْ فَرْعُونْ مَنْعِتُّو ورَبَّاتُو كِي وِلْدْهَا. ");
INSERT INTO aeu_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","وتْعَلِّمْ مُوسَى كُلْ حِكْمِةْ المَصْرِيِّينْ، حَتَّى وَلَّى عْظِيمْ فِي القَوْلْ والفِعْلْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","«وَقْتِلِّي وَلَّى عُمْرُو أَرْبْعِينْ سْنَة، جَاء عْلَى بَالُو بَاشْ يْزُورْ خْوَاتُو الِّي هُومَا بَنِي إِسْرَائِيلْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","وشَافْ مَصْرِي قَاعِدْ يُضْرِبْ فِي وَاحِدْ مِنْهُمْ، حَبْ يْحَامِي عْلِيهْ ويَاخُولُو حَقُّو، يَاخِي قْتَلْ المَصْرِي. ");
INSERT INTO aeu_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ومْشَى فِي بَالُو خْوَاتُو بِشْ يِفِهْمُوا الِّي اللَّهْ يْحِبْ يْنَجِّيهُمْ عْلَى طْرِيقُو، آمَا هُومَا مَا فِهْمُوشْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ومِنْ غُدْوَة، لْقَى زُوزْ مِنْ خْوَاتُو يِتْعَارْكُوا، وحَبْ يْصَلَّحْ بِينَاتْهُمْ، يَاخِي قَالِلْهُمْ: \"رَاكُمْ خْوَاتْ، عْلَاشْ تَعْمْلُوا هَكَّا فِي بْعَضْكُمْ؟\" ");
INSERT INTO aeu_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","وإِذَا بِالرَّاجِلْ الظَّالِمْ دَزْ مُوسَى وقَالُّو: \"شْكُونْ حَطِّكْ حَاكِمْ وقَاضِي عْلِينَا؟ ");
INSERT INTO aeu_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","تْحِبْ تُقْتُلْنِي كِيمَا قْتَلْتْ المَصْرِي البَارَحْ؟\". ");
INSERT INTO aeu_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","كِي سْمَعْ مُوسَى الكْلَامْ هَاذَا، هْرَبْ وتْغَرِّبْ فِي أَرْضْ مِدْيَانْ، وجَابْ فِيهَا زُوزْ وْلَادْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","«وبَعْدْ 40 سْنَة، فِي صَحْرِةْ جْبَلْ سِينَاءْ، ظْهُرْلُو مَلَاكْ فِي وِسْطْ نَارْ شَاعْلَة فِي شَجْرِةْ عِلِّيقْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","تْعَجِّبْ مُوسَى مِالمَنْظِرْ هَاذَا، وبْدَا يُقْرُبْ بَاشْ يْثَبِّتْ، وسْمَعْ صُوتْ الرَّبْ يْقُلُّو: ");
INSERT INTO aeu_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","\"آنَا إِلَاهْ جْدُودِكْ، إِلَاهْ إِبْرَاهِيمْ وإِسْحَاقْ ويَعْقُوبْ\". يَاخِي مُوسَى تِرْعِبْ ومَا نَجَّمْشْ حَتَّى يُغْزِرْ، ");
INSERT INTO aeu_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","قَالُّو الرَّبْ: \"نَحِّي صَنْدَالِكْ، رَاهِي البْلَاصَة الِّي إِنْتِ وَاقِفْ فِيهَا أَرْضْ مُقَدْسَة. ");
INSERT INTO aeu_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","آنَا رِيتْ ذُلْ شَعْبِي فِي مَصْرْ، وسْمَعْتْ تَنْهِيدْهُمْ، وهْبَطْتْ بَاشْ نْمَنَّعْهُمْ. وتَوَّا، إِيجَا نِبَعْثِكْ لْمَصْرْ\". ");
INSERT INTO aeu_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","«مُوسَى هَاذَا الِّي شَعْبُو رَفْضُو وقَالُّو: \"شْكُونْ حَطِّكْ حَاكِمْ وقَاضِي عْلِينَا؟\" هُوَّ الِّي اللَّهْ بَعْثُو عْلَى طْرِيقْ المَلَاكْ الِّي ظْهُرْلُو فِي العُلِّيقَة بَاشْ يْقُودْهُمْ ويْحَرِّرْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","وهُوَّ الِّي خَرِّجْهُمْ مِنْ مَصْرْ بَعْدْمَا عْمَلْ عْجَايِبْ ومُعْجْزَاتْ فِيهَا وفِي البْحَرْ الأَحْمَرْ وفِي الصَّحْرَاء لْمُدِّةْ 40 سْنَة. ");
INSERT INTO aeu_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","وهَاذَا هُوَّ مُوسَى الِّي قَالْ لْبَنِي إِسْرَائِيلْ: \"اللَّهْ بِشْ يِبْعْثِلْكُمْ نَبِيْ كِيفِي مِنْ بِينْ خْوَاتْكُمْ\". ");
INSERT INTO aeu_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","وهُوَّ الِّي كَانْ مْعَ الشَّعْبْ فِي الصَّحْرَاء، وكَانْ وَاسْطَة بِينْ المَلَاكْ الِّي كَلْمُو فِي جْبَلْ سِينَاءْ وجْدُودْنَا. وهُوَّ الِّي خْذَا الكْلَامْ الِّي يَعْطِي الحَيَاةْ بَاشْ يْوَصَّلْهُولْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","«آمَا جْدُودْنَا مَا حَبُّوشْ يْطِيعُوهْ ورَفْضُوهْ، وحَنِّتْ قْلُوبْهُمْ لِلرْجُوعْ لْمَصْرْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","وقَالُوا لْهَارُونْ: \"أَعْمْلِلْنَا آلْهَة تْوَرِّينَا الطْرِيقْ، عْلَى خَاطِرْ مَا نَعْرْفُوشْ آشْ صَارْ لْمُوسَى الِّي خَرَّجْنَا مِنْ أَرْضْ مَصْرْ\". ");
INSERT INTO aeu_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","وفِي الوَقْتْ هَاذَاكَا، صَنْعُوا صَنْبَة كِيمَا العْجِلْ، وذَبْحُولْهَا ضْحِيَّة، وفَرْحُوا بِلِّي عَمْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","يَاخِي اللَّهْ بْعِدْ عْلِيهُمْ وخَلَّاهُمْ يِعْبْدُوا فِي نْجُومْ السْمَاء، كِيمَا جَاء فِي كْتَابْ الأَنْبِيَاءْ: \"يَا بَنِي إِسْرَائِيلْ! يَاخِي جِبْتُولِي ذْبِيحَة وَلَّا قُرْبَانْ فِي الـ40 سْنَة الِّي عَدِّيتُوهُمْ فِي الصَّحْرَاء؟ ");
INSERT INTO aeu_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","لَا، آمَا هَزِّيتُوا خِيمِةْ الإِلَاهْ مُولُوكْ ونِجْمِةْ الإِلَاهْ رَمْفَانْ، الِّي هُومَا صْنَبْ صْنَعْتُوهَا بَاشْ تِعْبْدُوهَا. هَاذَاكَا عْلَاشْ بِشْ نِنْفِيكُمْ لْأَبْعِدْ مِنْ بْلَادْ بَابِلْ\". ");
INSERT INTO aeu_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","«وَقْتِلِّي كَانُوا جْدُودْنَا فِي الصَّحْرَاء، هَزُّوا مْعَاهُمْ خِيمِةْ العَهْدْ الِّي اللَّهْ أْمَرْ مُوسَى بَاشْ يَصْنَعْهَا كِيمَا وَرَّاهَالُو بِالضَّبْطْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ومْبَعِّدْ، خْذَاوْهَا جْدُودْنَا وهَزُّوهَا لِلْبْلَادْ الِّي إِحْتَلُّوهَا مْعَ يَشُوعْ بَعْدْمَا طَرِّدْ اللَّهْ مِنْ قُدَّامْهُمْ الشُّعُوبْ الِّي كَانُوا سَاكْنِينْ فِيهَا. وقَعْدِتْ الخِيمَة غَادِي حَتَّى لْوَقْتْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","الِّي كَانْ اللَّهْ رَاضِي عْلِيهْ. طْلَبْ دَاوِدْ مِنْ اللَّهْ بَاشْ يْخَلِّيهْ يِبْنِي هَيْكِلْ لْإِلَاهْ يَعْقُوبْ، ");
INSERT INTO aeu_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","آمَا سُلَيْمَانْ هُوَّ الِّي بْنَى الهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","فِي الحْقِيقَة، اللَّهْ العَالِي مَا يُسْكُنْشْ فِي بَنْيْ صَنْعِتُّو يْدِينْ البَشَرْ، كِيفْ مَا قَالْ النْبِي: ");
INSERT INTO aeu_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","\"الرَّبْ يْقُولْ: السْمَاء عَرْشِي، والأَرْضْ وِينْ نْحُطْ سَاقَيَّا. آنَا هُو البِيتْ الِّي بِشْ تِبْنِيوْهُولِي؟ وآنَا هِيَّ البُقْعَة الِّي بِشْ نِرْتَاحْ فِيهَا؟ ");
INSERT INTO aeu_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","مُشْ آنَا الِّي صْنَعْتْ الحَاجَاتْ هَاذِي الكُلْ بِيْدَيَّا؟\". ");
INSERT INTO aeu_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","«يَلِّي رُوسْكُمْ صْحِيحَة، وقْلُوبْكُمْ كَاسْحَة ووِذْنِيكُمْ مْسَكْرَة، إِنْتُومَا دِيمَا تْقَاوْمُوا فِي الرُّوحْ القُدُسْ كِيمَا عَمْلُوا جْدُودْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","فَمَّاشْ نَبِيْ مَا اضْطَهْدُوهِشْ جْدُودْكُمْ؟ وحَتَّى الِّي تْنَبْؤُوا عَالصَّالِحْ الِّي بِشْ يْجِي قَتْلُوهُمْ، ولِّي إِنْتُومَا سَلِّمْتُوهْ وقْتَلْتُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","إِنْتُومَا يَلِّي خْذِيتُوا الشَّرِيعَة عْلَى طْرِيقْ المْلَايْكَة آمَا مَا طَبَّقْتُوهَاشْ!». ");
INSERT INTO aeu_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","وَقْتِلِّي الحَاضْرِينْ سَمْعُوا كْلَامْ اسْتِفَانُوسْ، تِمْلَاتْ قْلُوبْهُمْ بِالحِقْدْ وتْغَشْشُوا بَرْشَة عْلِيهْ وتْحَلْفُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","آمَا هُوَّ هَزْ عِينِيهْ لِلسْمَاء وهُوَّ مَلْيَانْ بِالرُّوحْ القُدُسْ، وشَافْ مَجْدْ اللَّهْ ويَسُوعْ وَاقِفْ عْلَى يْمِينْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","وقَالْ: «آنَا نْشُوفْ فِي السْمَاء مَحْلُولَة، وإِبْنْ الإِنْسَانْ وَاقِفْ عْلَى يْمِينْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","يَاخِي صَاحُوا بْصُوتْ عَالِي، وسَدُّوا وذْنِيهُمْ، وهِجْمُوا عْلِيهْ الكُلْ فَرْدْ مَرَّة. ");
INSERT INTO aeu_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","وخَرْجُوهْ لْبَرَّا مِالمْدِينَة وبْدَاوْ يُرْجْمُوا فِيهْ بِالحْجَرْ. ونَحَّاوْ الشْهُودْ جْبَايِبْهُمْ وخَلَّاوْهُمْ عَنْدْ سَاقِينْ وَاحِدْ اسْمُو شَاوُلْ بَاشْ يْعِسْ عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","وهُومَا يُرْجْمُوا فِيهْ، كَانْ اسْتِفَانُوسْ يِدْعِي: «يَا الرَّبْ يَسُوعْ، إِقْبِلْ رُوحِي!». ");
INSERT INTO aeu_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ومْبَعِّدْ، هْبَطْ عْلَى رْكَايْبُو وصَاحْ بْصُوتْ عَالِي: «يَا رَبْ مَا تْحَاسِبْهُمْشْ عَالذَّنْبْ هَاذَا!». وبَعْدْمَا قَالْ الكْلَامْ هَاذَا، مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","وكَانْ شَاوُلْ مْوَافِقْ عْلَى قَتْلَانْ اسْتِفَانُوسْ. وفِي النْهَارْ هَاذَاكَا، بْدَا إِضْطِهَادْ كْبِيرْ عَالكْنِيسَة الِّي فِي أُورْشَلِيمْ، وتْفَرْقُوا المُؤْمْنِينْ الكُلْ فِي اليَهُودِيَّة والسَّامْرَة. ومَا قَعْدُوا فِي أُورْشَلِيمْ كَانْ الرُّسُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","وفَمَّة نَاسْ يْخَافُوا رَبِّي هَزُّوا اسْتِفَانُوسْ ودِفْنُوهْ وبْكَاوْ عْلِيهْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","وكَانْ شَاوُلْ يْحَاوِلْ بَاشْ يَقْضِي عَالكْنِيسَة. كَانْ يْدُورْ مِنْ دَارْ لْدَارْ، يْكَرْكِرْ فِي الرْجَالْ والنْسَاء ويِرْمِي فِيهُمْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","آمَا المُؤْمْنِينْ الِّي تْفَرْقُوا كَانُوا يِمْشِيوْ مِنْ بُقْعَة لْبُقْعَة يْوَصْلُوا فِي البْشَارَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ومْشَى فِيلِۑُّسْ لِمْدِينَة فِي السَّامْرَة، وبْدَا يْبَشِّرْ بِالمَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","والنَّاسْ الكُلْ، كِي سَمْعُوا بِالمُعْجْزَاتْ الِّي عْمَلْهَا وكِي شَافُوهَا، رَكْزُوا أَكْثِرْ عَلِّي كَانْ يْقُولْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","عْلَى خَاطِرْ الأَرْوَاحْ الشِّرِّيرَة كَانُوا يْصِيحُوا بْصُوتْ عَالِي ويُخْرْجُوا مِالنَّاسْ الِّي سَاكْنِينْهُمْ، وزَادَا، بَرْشَة مَشْلُولِينْ وعَايْبِينْ بْرَاوْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","وتِمْلَاتْ المْدِينَة بِالفَرْحَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","وفِي الوَقْتْ هَاذَاكَا، كَانْ فَمَّة سَحَّارْ فِي المْدِينَة إِسْمُو سِيمُونْ، وكَانُوا السَّامِرِيِّينْ مَبْهُورِينْ بِيهْ، وكَانْ يْقُولْ عْلَى رُوحُو الِّي هُوَّ رَاجِلْ عْظِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","وكَانُوا الكُلْ بِصْغِيرْهُمْ بِكْبِيرْهُمْ يِسْمْعُوا فِي كْلَامُو ويْقُولُوا: «الرَّاجِلْ هَاذَا هُوَّ قُوِّةْ اللَّهْ الِّي تِتْسَمَّى العْظِيمَة». ");
INSERT INTO aeu_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","وكَانُوا يِسْمْعُوا كْلَامُو، عْلَى خَاطِرْ فْتِنْهُمْ بْسِحْرُو مُدَّة طْوِيلَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","آمَا وَقْتِلِّي بَشِّرْهُمْ فِيلِۑُّسْ بْمَمْلِكْةْ اللَّهْ وبْقُوِّةْ إِسْمْ يَسُوعْ المَسِيحْ، أَمْنُوا وتْعَمْدُوا رْجَالْ ونْسَاء. ");
INSERT INTO aeu_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","وسِيمُونْ بِيدُو أَمَّنْ وتْعَمِّدْ، وكَانْ شَادْ جْنَبْ فِيلِۑُّسْ وبَاهِتْ فِي العْجَايِبْ والمُعْجْزَاتْ الكْبِيرَة الِّي كَانْ يَعْمِلْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","وكِي سَمْعُوا الرُّسُلْ فِي أُورْشَلِيمْ الِّي السَّامِرِيِّينْ قِبْلُوا كِلْمِةْ اللَّهْ، بَعْثُولْهُمْ بُطْرُسْ ويُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","وَقْتِلِّي وُصْلُوا، طَلْبُوا مِنْ اللَّهْ بَاشْ يَعْطِي الرُّوحْ القُدُسْ لِلسَّامِرِيِّينْ، ");
INSERT INTO aeu_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","عْلَى خَاطِرْ حَتَّى لْوَقْتْهَا مَزَّالْ حَتَّى وَاحِدْ فِيهُمْ مَا خْذَاهْ، بِخْلَافْ إِنْهُمْ تْعَمْدُوا بْإِسْمْ الرَّبْ يَسُوعْ أَكَهَوْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","وَلَّاوْ بُطْرُسْ ويُوحَنَّا حَطُّوا يْدِيهُمْ عْلِيهُمْ، وقِبْلُوا الرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","وكِي شَافْ سِيمُونْ الِّي اللَّهْ عْطَى الرُّوحْ القُدُسْ لِلْمُؤْمْنِينْ وَقْتِلِّي حَطُّوا الرُّسُلْ يْدِيهُمْ عْلِيهُمْ، مَدْ لْبُطْرُسْ ويُوحَنَّا فْلُوسْ، ");
INSERT INTO aeu_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","وقَالِلْهُمْ: «أَعْطِيوْنِي آنَا زَادَا السُّلْطَة هَاذِي بَاشْ أَيْ وَاحِدْ نْحُطْ يْدَيَّا عْلِيهْ يَاخِذْ الرُّوحْ القُدُسْ». ");
INSERT INTO aeu_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","قَالُّو بُطْرُسْ: «اللَّهْ يِهْلْكِكْ إِنْتِ وفْلُوسِكْ، عْلَى خَاطِرْ مْشَى فِي بَالِكْ تْنَجِّمْ تِشْرِي الهِيبَة الِّي عْطَاهَا اللَّهْ بِالفْلُوسْ! ");
INSERT INTO aeu_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","لَا عَنْدِكْ لَا قَسْمْ ولَا بَايْ فِي الخِدْمَة هَاذِي، عْلَى خَاطِرْ قَلْبِكْ مُشْ صَادِقْ مْعَ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","تُوبْ عْلَى شَرِّكْ وأُطْلُبْ الرَّبْ، بَالِكْشِي يِغْفِرْلِكْ الِّي نْوِيتُو فِي قَلْبِكْ، ");
INSERT INTO aeu_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","عْلَى خَاطِرْ نْشُوفْ فِيكْ مِلْيَانْ بِمْرَارِةْ الحُسْدْ ومَرْبُوطْ بِالذْنُوبْ». ");
INSERT INTO aeu_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","يَاخِي جَاوِبْ سِيمُونْ: «أُطْلْبُوا إِنْتُومَا الرَّبْ بَاشْ مَا يْصِيرْلِي شَيْ مِلِّي قُلْتُوهْ». ");
INSERT INTO aeu_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","وبَعْدْمَا عْطَاوْ بُطْرُسْ ويُوحَنَّا شْهَادِتْهُمْ وتْكَلْمُوا بْكِلْمِةْ الرَّبْ، رَجْعُوا لْأُورْشَلِيمْ وهُومَا يْبَشْرُوا فِي بَرْشَة دْشُرْ فِي السَّامْرَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","وكَلِّمْ مَلَاكْ مِنْ عَنْدْ الرَّبْ فِيلِۑُّسْ وقَالُّو: «قُومْ وشِدْ ثْنِيِّةْ الجَنُوبْ، عَالطْرِيقْ الصَّحْرَاوِي الِّي بِينْ أُورْشَلِيمْ وغَزَّة». ");
INSERT INTO aeu_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","وَلَّى قَامْ ومْشَى. فِي الطْرِيقْ، قَابِلْ رَاجِلْ مَخْصِي مِالحَبَشَة، جَاء لْأُورْشَلِيمْ بَاشْ يِعْبِدْ اللَّهْ. وهُوَّ وزِيرْ المَالِيَّة عَنْدْ كِنْدَاكَة، مَلِكَةْ الحَبَشَة. ");
INSERT INTO aeu_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","وكَانْ مْرَوَّحْ لِبْلَادُو، قَاعِدْ فِي كَرُّوسْتُو، يَقْرَى فِي كْتَابْ النَّبِيْ إِشَعْيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","يَاخِي قَالْ الرُّوحْ لْفِيلِۑُّسْ: «قَدِّمْ وامْشِي بِجْنَبْ الكَرُّوسَة هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","مْشَالْهَا فِيلِۑُّسْ يِجْرِي، وسْمَعْ الرَّاجِلْ يَقْرَى فِي كْتَابْ النَّبِيْ إِشَعْيَاءْ، وسِأْلُو: « يَاخِي قَاعِدْ تِفْهِمْ فِلِّي تَقْرَى فِيهْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","جَاوْبُو: «كِيفَاشْ بِشْ نِفْهِمْ إِذَا مَا فَمَّة حَدْ يْفَسَّرْلِي؟» وطْلَبْ مِنْ فِيلِۑُّسْ بَاشْ يِرْكِبْ بَحْذَاهْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","وكَانْ الوْزِيرْ وْصُلْ لْوِينْ الكْتَابْ يْقُولْ: «كَانْ كِيمَا النَّعْجَة الِّي يْهِزُّوهَا تِتِذْبَحْ، وكِيمَا العَلُّوشْ السَّاكِتْ بِينْ يْدِينْ الِّي يْجِزْ فِيهْ، مَا حَلِّشْ فُمُّو. ");
INSERT INTO aeu_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ذَلُّوهْ وظَلْمُوهْ. شْكُونْ بِشْ يَحْكِي عْلَى ذُرِّيتُو؟ عْلَى خَاطِرْ حْيَاتُو تْسِلْبِتْ!». ");
INSERT INTO aeu_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","وسْإِلْ الوْزِيرْ فِيلِۑُّسْ: «عْلَى شْكُونْ يَحْكِي النَّبِيْ هْنَا؟ يَحْكِي عْلَى رُوحُو وَلَّا عْلَى حَدْ آخِرْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","يَاخِي تْكَلِّمْ فِيلِۑُّسْ وبْدَا يْبَشِّرْ فِيهْ بْيَسُوعْ مِنْ الآيَاتْ هَاذُوكُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","وهُومَا فِي الطْرِيقْ، وُصْلُوا لْبُقْعَة فِيهَا مَاء، يَاخِي قَالْ الوْزِيرْ: «شُوفْ! هَاوْ فَمَّة مَاء، شْنُوَّة الِّي يِمْنَعْنِي بَاشْ نِتْعَمِّدْ؟» ");
INSERT INTO aeu_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","جَاوْبُو فِيلِۑُّسْ: «كَانْ تَمِّنْ مِنْ كُلْ قَلْبِكْ، تْنَجِّمْ تِتْعَمِّدْ». يَاخِي قَالُّو: «آنَا نَمِّنْ الِّي يَسُوعْ المَسِيحْ هُوَّ إِبْنْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","وأْمَرْ بَاشْ يْوَقْفُوا الكَرُّوسَة، وهَبْطُوا مْعَ بْعَضْهُمْ لِلمَاءْ، وعَمْدُو فِيلِۑُّسْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","وكِي خَرْجُوا مِالمَاء، خْطَفْ رُوحْ الرَّبْ فِيلِۑُّسْ، والوْزِيرْ مَا عَادِشْ شَافُو، يَاخِي كَمِّلْ طْرِيقُو وهُوَّ فَرْحَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","آمَا فِيلِۑُّسْ لْقَى رُوحُو فِي مْدِينِةْ أَشْدُودْ. وبْدَا يِمْشِي ويْبَشِّرْ فِي كُلْ مْدِينَة يِتْعَدَّى عْلِيهَا، لِينْ وْصُلْ لْقَيْصَرِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","وكَانْ شَاوُلْ مَزَّالْ يِتْحَلِّفْ فِي تْلَامِذْةْ الرَّبْ يَسُوعْ ويْهَدِّدْ فِيهُمْ بِالقَتْلْ، ومْشَى لِلكَاهِنْ الكْبِيرْ، ");
INSERT INTO aeu_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","وطْلَبْ مِنُّو رَسَايِلْ لْمْعَابِدْ اليْهُودْ الِّي فِي دِمَشْقْ، بَاشْ يْنَجِّمْ يْشِدْ الرْجَالْ والنْسَاء الِّي يْتَبْعُوا فِي المَذْهَبْ الِّي يِتْسَمَّى الطْرِيقْ، ويْهِزْهُمْ مْكَتْفِينْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","وهُوَّ مَاشِي فِي الطْرِيقْ، وَقْتِلِّي قْرِيبْ يُوصِلْ لْدِمَشْقْ، إِذَا بْنُورْ مِالسْمَاء يِضْوِي عْلِيهْ مِنْ كُلْ شِيرَة. ");
INSERT INTO aeu_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","يَاخِي طَاحْ فِي القَاعَة، وسْمَعْ صُوتْ يْقُلُّو: «شَاوُلْ! شَاوُلْ! عْلَاشْ تِضْطَهِدْ فِيَّا؟». ");
INSERT INTO aeu_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","سِأْلُو شَاوُلْ: «شْكُونِكْ إِنْتِ يَا رَبْ؟». جَاوْبُو: «آنَا يَسُوعْ الِّي إِنْتِ تِضْطَهِدْ فِيهْ. صْعِيبْ عْلِيكْ تْقَاوِمْنِي». ");
INSERT INTO aeu_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","قَالُّو شَاوُلْ وهُوَّ خَايِفْ وْمَرْعُوبْ: «يَا رَبْ آشْ تْحِبْنِي نَعْمِلْ؟». قَالُّو الرَّبْ: «قُومْ وأُدْخُلْ لِلْمْدِينَة وتَوَّا يْقُولُولِكْ شْنُوَّة يِلْزْمِكْ تَعْمِلْ». ");
INSERT INTO aeu_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","آمَا الرْجَالْ الِّي كَانُوا مْسَافْرِينْ مْعَ شَاوُلْ، وِقْفُوا بَاهْتِينْ ومَا نَجْمُوا يَنْطْقُوا بْحَتَّى كِلْمَة، يِسْمْعُوا فِي الصُّوتْ، آمَا مَا يْشُوفُوا فِي حَتَّى حَدْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","وقَامْ شَاوُلْ مِالقَاعَةْ، وبِالرَّغْمْ الِّي كَانِتْ عِينِيهْ مَحْلُولَة، مَا كَانْ يْرَى فِي شَيْ. وَلَّاوْ شَدُّوهْ مِنْ يِدُّو ودَخْلُوهْ لْدِمَشْقْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","وقْعَدْ ثْلَاثَة أَيَّامْ مَا يْشُوفِشْ، لَا كْلَا ولَا شْرَبْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","وكَانْ فِي دِمَشْقْ تِلْمِيذْ إِسْمُو حَنَانِيَّا، عَيَّطْلُو الرَّبْ فِي رُؤْيَا: «حَنَانِيَّا!». قَالُّو: «نْعَمْ يَا رَبْ». ");
INSERT INTO aeu_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","قَالُّو الرَّبْ: «قُومْ وامْشِي فِي الشَّارِعْ المَعْرُوفْ بِالطْرِيقْ المِسْتْوِي، واسْإِلْ فِي دَارْ يَهُوذَا عْلَى رَاجِلْ مِنْ طَرْسُوسْ إِسْمُو شَاوُلْ. هُوَّ تَوَّا قَاعِدْ يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ورَاهُو شَافْ فِي رُؤْيَا رَاجِلْ إِسْمُو حَنَانِيَّا جَاهْ وحَطْ عْلِيهْ يْدِيهْ بَاشْ يِرْجَعْ يْشُوفْ». ");
INSERT INTO aeu_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","جَاوْبُو حَنَانِيَّا: «آمَا آنَا يَا رَبْ سْمَعْتْ مِنْ بَرْشَة نَاسْ عَالشَّرْ الِّي عَمْلُو الرَّاجِلْ هَاذَا فِي القِدِّيسِينْ التَّابْعِينِكْ الِّي فِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","وهَاوْ جَاء لْهُونِي وعَنْدُو سُلْطَة مِنْ عَنْدْ كْبَارْ الكَهَنَة بَاشْ يْشِدْ النَّاسْ الِّي يَمْنُوا بِيكْ». ");
INSERT INTO aeu_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","آمَا الرَّبْ قَالُّو: «إِمْشِي! عْلَى خَاطِرْ آنَا اخْتَرْتْ الرَّاجِلْ هَاذَا بَاشْ يَحْكِي عْلِيَّا لِلشُّعُوبْ الِّي مُشْ يْهُودْ ولِلْمُلُوكْ ولْبَنِي إِسْرَائِيلْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","وبِشْ نْوَرِّيهْ قَدَّاشْ لَازْمُو يِتْعَذَّبْ عْلَى خَاطِرْ إِسْمِي». ");
INSERT INTO aeu_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","مْشَى حَنَانِيَّا ودْخَلْ لِلدَّارْ وحَطْ يْدِيهْ عْلَى شَاوُلْ وقَالْ: «يَا خُويَا شَاوُلْ، بْعَثْنِي لِيكْ الرَّبْ يَسُوعْ الِّي ظْهُرْلِكْ فِي الثْنِيَّة الِّي جِيتْ مِنْهَا بَاشْ يِرَجَّعْلِكْ نَظْرِكْ وتِتِمْلَى بِالرُّوحْ القُدُسْ». ");
INSERT INTO aeu_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","وبِالوَقْتْ طَاحُوا مِنْ عِينِيهْ حَاجَاتْ كِيمَا القْشُورْ، ورْجَعْ يْشُوفْ، يَاخِي قَامْ وتْعَمِّدْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","وبَعْدْ كْلَا، يَاخِي رَجْعِتْلُو قُوْتُو. وعَدَّى أَيَّامَاتْ مْعَ التْلَامْذَة فِي دِمَشْقْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","وبِالوَقْتْ بْدَا يْبَشِّرْ فِي مْعَابِدْ اليْهُودْ بِلِّي يَسُوعْ هُوَّ إِبْنْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ولِّي سَمْعُوهْ الكُلْ بِهْتُوا وقَالُوا: «مُشْ هَاذَا الِّي كَانْ يْحَاوِلْ يَقْضِي عَلِّي يَمْنُوا بْيَسُوعْ فِي أُورْشَلِيمْ؟ يَاخِي مُشْ جَاء لَهْنَا بَاشْ يْشِدْ المُؤْمْنِينْ يْهِزْهُمْ مْكَتْفِينْ لِكْبَارْ الكَهَنَة؟». ");
INSERT INTO aeu_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","آمَا شَاوُلْ كَانِتْ قُوْتُو فِي التَبْشِيرْ قَاعْدَة تْزِيدْ، وكَانْ يْحَيِّرْ اليْهُودْ السَّاكْنِينْ فِي دِمَشْقْ بِالأَدِلَّة الِّي تْوضَّحْ الِّي يَسُوعْ هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","وبَعْدْ مُدَّة، تْفَاهْمُوا اليْهُودْ مْعَ بْعَضْهُمْ بَاشْ يُقْتْلُوا شَاوُلْ، ");
INSERT INTO aeu_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","آمَا هُوَّ سْمَعْ بِيهُمْ. وكَانُوا يْعِسُّوا عْلَى بِيبَانْ المْدِينَة لِيلْ ونْهَارْ، بَاشْ يُقْتْلُوهْ وَقْتِلِّي يُخْرُجْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","يَاخِي هَزُّوهْ التْلَامْذَة فِي اللِّيلْ، وحَطُّوهْ فِي قُفَّة وهَبْطُوهْ بِالحْبَالْ مِنْ فُوقْ سُورْ المْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","وَقْتِلِّي وْصُلْ شَاوُلْ لْأُرْشَلِيمْ، حَبْ يْوَلِّي مْعَ التْلَامْذَة، آمَا الكُلْ خَافُوا مِنُّو، ومَا صَدْقُوشْ الِّي هُوَّ وَلَّى وَاحِدْ مِنْ تْلَامِذْةْ الرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","يَاخِي بَرْنَابَا هَزُّو مْعَاهْ لِلرُّسُلْ، وَحْكَالْهُمْ كِيفَاشْ الرَّبْ ظْهُرْلُو فِي الطْرِيقْ وكَلْمُو، وكِيفَاشْ بَشِّرْ بِاسِمْ يَسُوعْ بْشَجَاعَة فِي دِمَشْقْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","وقْعَدْ شَاوُلْ يِمْشِي ويْجِي مْعَاهُمْ فِي أُورْشَلِيمْ، وكَانْ يْبَشِّرْ بْإِسْمْ الرَّبْ مِنْ غِيرْ خُوفْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","وكَانْ يِتْنَاقِشْ مْعَ اليْهُودْ الِّي يِتْكَلْمُوا بِاليُونَانِيَّة ويْحَاجِجْ فِيهُمْ. وكَانُوا يْحَاوْلُوا يُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","وكِي سَمْعُوا الإِخْوَة بْهَاذَا، هَزُّوهْ لِمْدِينِةْ قَيْصَرِيَّة، ومِنْ غَادِي بَعْثُوهْ لْطَرْسُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","وكَانِتْ الكْنِيسَة فِي مَنَاطِقْ اليَهُودِيَّة والجَلِيلْ والسَّامْرَة عَايْشَة فِي سَلَامْ، وقَاعْدَة تِكْبِرْ فِي الإِيمَانْ وفِي طَاعَةْ الرَّبْ، وتْزِيدْ فِي العْدَدْ بْتَشْجِيعْ الرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","وَقْتِلِّي بُطْرُسْ كَانْ يِمْشِي مِنْ بُقْعَة لْبُقْعَة، زَارْ القِدِّيسِينْ السَّاكْنِينْ فِي مْدِينِةْ لُدَّة. ");
INSERT INTO aeu_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ولْقَى غَادِي رَاجِلْ مَشْلُولْ إِسْمُو إِينِيَاسْ، عَنْدُو ثْمَنْيَة سْنِينْ مَا قَامِشْ مِالفَرْشْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","قَالُّو بُطْرُسْ: «يَا إِينْيَاسْ، يَسُوعْ المَسِيحْ يِشْفِيكْ، قُومْ وڨِدْ فَرْشِكْ بِيدِكْ». وبِالوَقْتْ قَامْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","وشَافُوهْ الِّي يُسْكْنُوا فِي لُدَّة وفِي أَرْضْ شَارُونْ الكُلْ، وأَمْنُوا بِالرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","وكَانِتْ فِي مْدِينِةْ يَافَا تِلْمِيذَة اسْمْهَا طَابِيثَا، الِّي مَعْنَاهْ غْزَالَة، دِيمَا تَعْمِلْ فِي الخِيرْ وتْعَاوِنْ فِي الفْقَارَى. ");
INSERT INTO aeu_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","وفِي الوَقْتْ هَاذَاكَا مُرْضِتْ ومَاتِتْ. يَاخِي غَسّْلُوهَا وحَطُّوهَا فِي بَيْتْ فِي العْلِيْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","سَمْعُوا التْلَامْذَة فِي يَافَا الِّي بُطْرُسْ مَوْجُودْ فِي لُدَّة، بِمَا إِنْهَا قْرِيبَة مِنْ يَافَا، يَاخِي بَعْثُولُو زُوزْ رْجَالْ يْلِحُّوا عْلِيهْ ويْقُولُولُو: «إِيجَانَا فِيسَعْ ومَا تَبْطَاشْ عْلِينَا». ");
INSERT INTO aeu_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","يَاخِي قَامْ بُطْرُسْ مْشَى مْعَاهُمْ. وكِي وْصُلْ، طَلْعُوهْ لِلْعْلِيْ. ودَارُوا بِيهْ النْسَاء الهَجَّالَاتْ، يِبْكِيوْ ويْوَرِّيوْ فِيهْ فِي اللِّبْسَة والحْوَايِجْ الِّي خَيْطِتْهُمْ غْزَالَة كِي كَانِتْ حَيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","خَرِّجْ بُطْرُسْ النَّاسْ الكُلْ مِالبِيتْ، وهْبَطْ عْلَى رْكَايْبُو وصَلَّى. وبَعْدْ تْلَفِّتْ لِلجُثَّة وقَالْ: «يَا طَابِيثَا، قُومْ!»، يَاخِي حَلِّتْ عِينِيهَا، وَقْتِلِّي شَافِتْ بُطْرُسْ، قَعْدِتْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","مَدْ بُطْرُسْ يِدُّو وقَوَّمْهَا، ومْبَعِّدْ عَيِّطْ لِلْقِدِّيسِينْ والهَجَّالَاتْ ووَرَّهَالْهُمْ حَيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","وتِنْشَرْ الخْبَرْ فِي يَافَا الكُلْ. وبَرْشَة نَاسْ أَمْنُوا بِالرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","وقْعَدْ بُطْرُسْ أَيَّامَاتْ فِي يَافَا عَنْدْ وَاحِدْ دَبَّاغْ إِسْمُو سِمْعَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","وكَانْ فَمَّة فِي قَيْصَرِيَّة ضَابِطْ رُومَانِي إِسْمُو كُرْنِيلْيُوسْ، تَابَعْ لْفِرْقِةْ الجَيْشْ الِّي تِتْسَمَّى الإِيطَالِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","كَانْ تَقِيْ ويْخَافْ رَبِّي هُوَّ وعَايِلْتُو الكُلْ، ويِتْصَدِّقْ بَرْشَة عْلَى عَالفْقَارَى ودِيمَا يْصَلِّي لِلَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","فِي نْهَارْ مِالنْهَارَاتْ، مْعَ مَاضِي ثْلَاثَة مْتَاعْ العْشِيَّة، شَافْ كُرْنِيلْيُوسْ فِي رُؤْيَا وَاضْحَة، مَلَاكْ مِنْ عَنْدْ اللَّهْ دْخَلُّو وقَالُّو: «يَا كُرْنِيلْيُوسْ!». ");
INSERT INTO aeu_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","خْزَرْ لِلْمَلَاكْ وهُوَّ خَايِفْ وسِأْلُو: «آشْ فَمَّة يَا سِيدِي؟». قَالُّو المَلَاكْ: «صْلَاتِكْ وصَدْقَاتِكْ وُصْلُوا لِلَّهْ، ورَاهُو مُشْ نَاسِيكْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","أَبْعِثْ تَوَّا رْجَالْ لْيَافَا، واسْتَدْعِي سِمْعَانْ الِّي يْعَيْطُولُو بُطْرُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","هُوَّ يُسْكُنْ عَنْدْ سِمْعَانْ الدَّبَّاغْ الِّي دَارُو قْرِيبَة لِلبْحَرْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","وبَعْدْمَا مْشَى المَلَاكْ الِّي كَانْ يْكَلِّمْ فِيهْ، عَيِّطْ كُرْنِيلْيُوسْ لِثْنِينْ مِنْ خُدَّامُو، وجُنْدِي يْخَافْ رَبِّي مِالحُرَّاسْ التَّابْعِينُو. ");
INSERT INTO aeu_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","وحْكَالْهُمْ الِّي صَارْ الكُلْ، وبْعَثْهُمْ لْيَافَا. ");
INSERT INTO aeu_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ومِنْ غُدْوَة، وَقْتِلِّي بْدَاوْ الرْجَالْ الثْلَاثَة يُقْرْبُوا لْيَافَا، طْلَعْ بُطْرُسْ لِلسْطَحْ مْعَ نُصْفْ النْهَارْ بَاشْ يْصَلِّي. ");
INSERT INTO aeu_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","جَاعْ بَرْشَة، واشْتْهَى يَاكِلْ. وهُومَا يْحَضْرُولُو فِي الفْطُورْ، شَافْ رُؤْيَا، ");
INSERT INTO aeu_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","وشَافْ السْمَاء مَحْلُولَة، وحَاجَة كِيمَا مَلْحْفَة كْبِيرَة مَرْبُوطَة مِنْ أَطْرَافْهَا الأَرْبْعَة هَابْطَة تِدَّلْدِلْ لِلقَاعَة. ");
INSERT INTO aeu_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","وكَانْ فِيهَا أَنْوَاعْ الحَيَوَانَاتْ الكُلْ: الِّي تِمْشِي، ولِّي تَزْحِفْ، ولِّي اطِّيرْ فِي السْمَاء. ");
INSERT INTO aeu_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","وجَاهْ صُوتْ يْقُلُّو: «يَا بُطْرُسْ، قُومْ اذْبَحْ وكُولْ!». ");
INSERT INTO aeu_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","آمَا بُطْرُسْ جَاوْبُو: «لَا يَا رَبْ! آنَا عُمْرِي مَا كْلِيتْ شَيْ مَنْزُوسْ وَلَّا مْحَرَّمْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","يَاخِي الصُّوتْ قَالُّو مَرَّة أُخْرَى: «الِّي طَهْرُو اللَّهْ، مَا تِحْسْبُوشْ إِنْتِ مَنْزُوسْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","وتْعَاوِدْ هَاذَا ثْلَاثَة مَرَّاتْ، وبَعْدْهَا تْهَزِّتْ المَلْحْفَة لِلسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","قْعَدْ بُطْرُسْ حَايِرْ ويِسْإِلْ فِي رُوحُو عْلَى مَعْنَى الرُّؤْيَا الِّي شَافْهَا. هُوَّ هَكَّاكَا، والرْجَالْ الِّي بْعَثْهُمْ كُرْنِيلْيُوسْ وُصْلُوا قُدَّامْ البَابْ، بَعْدْمَا سِأْلُوا عْلَى دَارْ سِمْعَانْ الدَّبَّاغْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","وسِأْلُوا: «سِمْعَانْ الِّي يِتْسَمَّى بُطْرُسْ مَوْجُودْ هْنَا؟». ");
INSERT INTO aeu_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","وفِي الوَقْتْ هَاذَاكَا، كَانْ بُطْرُسْ مَزَّالْ يْفَكِّرْ فِي مَعْنَى الرُّؤْيَا، يَاخِي قَالُّو الرُّوحْ: «فَمَّة ثْلَاثَة رْجَالْ قُدَّامْ البَابْ يْلَوْجُوا عْلِيكْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","أَهْبِطْ وامْشِي مْعَاهُمْ ومَا تِتْرَدِّدَشْ، عْلَى خَاطِرْ آنَا الِّي بْعَثْتْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","هْبَطِّلْهُمْ بُطْرُسْ وقَالْ: «آنَا هُوَّ الِّي تْلَوْجُوا عْلِيهْ، عْلَاشْ جِيتُوا؟». ");
INSERT INTO aeu_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","جَاوْبُوهْ: «بْعَثْنَا الضَّابِطْ كُرْنِيلْيُوسْ، وهُوَّ رَاجِلْ صَالَحْ ويْخَافْ اللَّهْ، واليْهُودْ الكُلْ يِشْهْدُولُو بِهَاذَا، أَوْحَالُو اللَّهْ عْلَى طْرِيقْ مَلَاكْ طَاهِرْ بَاشْ يِسْتَدْعَاكْ لْدَارُو ويِسْمَعْ الكْلَامْ الِّي عَنْدِكْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","دَخَّلْهُمْ بُطْرُسْ وضَيَّفْهُمْ لِيلِتْهَا بَحْذَاهْ، ومِنْ غُدْوَة مْشَى مْعَاهُمْ، ومْشَاوْ مْعَاهْ إِخْوَة مِنْ يَافَا. ");
INSERT INTO aeu_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ووُصْلُوا لْقَيْصَرِيَّة مِنْ غُدْوَة. وكَانْ كُرْنِيلْيُوسْ يِسْتَنَّى فِيهُمْ، واسْتَدْعَى امَّالِيهْ وأَصْحَابُو القْرَابْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","وَقْتِلِّي دْخَلْ بُطْرُسْ، إِسْتَقْبْلُو كُرْنِيلْيُوسْ وسْجِدْلُو. ");
INSERT INTO aeu_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","يَاخِي قَوْمُو بُطْرُسْ وقَالُّو: «قُومْ، مَانِي إِلَّا إِنْسَانْ كِيفِي كِيفِكْ». ");
INSERT INTO aeu_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ودْخَلْ بُطْرُسْ وهُوَّ يَحْكِي مْعَاهْ، ولْقَى بَرْشَة نَاسْ مَلْمُومِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","يَاخِي قَالِلْهُمْ: «إِنْتُومَا تَعْرْفُوا الِّي مْحَرَّمْ عَاليْهُودِي يِتْعَامِلْ مْعَ الِّي مُشْ يْهُودِي وَلَّا حَتَّى يْزُورُو فِي دَارُو. آمَا اللَّهْ وَرَّانِي الِّي مَا يِلْزِمْنِيشْ نْقُولْ عْلَى حَتَّى حَدْ إِنُّو مَنْزُوسْ وَلَّا مُشْ طَاهِرْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","هَاذَاكَا عْلَاشْ وَقْتِلِّي اسْتَدْعِيتُونِي جِيتْ طُولْ، عْلَاشْ اسْتَدْعِيتُونِي؟». ");
INSERT INTO aeu_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","جَاوِبْ كُرْنِيلْيُوسْ: « تَوَّا أَرْبْعَة أَيَّامْ لْتَالِي، كُنْتْ نْصَلِّي فِي دَارِي مْعَ مَاضِي ثْلَاثَة، وإِذَا بِيهْ ظْهُرْ قُدَّامِي رَاجِلْ لِبْسْتُو تِلْمَعْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","وقَالِّي: \"يَا كُرْنِيلْيُوسْ! اللَّهْ سْمَعْ صْلَاتِكْ وتْذَكِّرْ صَدْقَاتِكْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","أَبْعِثْ رْجَالْ لْيَافَا، واسْتَدْعِي سِمْعَانْ الِّي يْعَيْطُولُو بُطْرُسْ، رَاهُو سَاكِنْ فِي دَارْ سِمْعَانْ الدَّبَّاغْ القْرِيبَة مِالبْحَرْ\". ");
INSERT INTO aeu_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","يَاخِي بْعَثْتْلِكْ بِالوَقْتْ، وإِنْتِ مَا قَصَّرْتِشْ كِي جِيتْ. وأَحْنَا تَوَّا حَاضْرِينْ الكُلْ قُدَّامْ اللَّهْ بَاشْ نِسْمْعُوا كُلْ الِّي أَمْرِكْ بِيهْ الرَّبْ بَاشْ تْقُولُو». ");
INSERT INTO aeu_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","بْدَا بُطْرُسْ يِتْكَلِّمْ وقَالْ: « آنَا بِالحَقْ تْأَكَّدِتْ الِّي اللَّهْ مَا يْمَيِّزْ حَدْ عْلَى حَدْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","وهُوَّ يِقْبِلْ كُلْ وَاحِدْ يِتَّقِيهْ ويَعْمِلْ الصَّلَاحْ، مَهْمَا كَانِتْ جِنْسِيتُو. ");
INSERT INTO aeu_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","وبْعَثْ كِلْمْتُو لْبَنِي إِسْرَائِيلْ، وبَشَّرْهُمْ بِالسَّلَامْ الِّي يْجِي عْلَى طْرِيقْ يَسُوعْ المَسِيحْ، الِّي هُوَّ رَبْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","وإِنْتُومَا لَازِمْ سْمَعْتُوا بِالحَاجَاتْ الِّي صَارِتْ فِي مَنْطَقْةْ اليَهُودِيَّة، ولِّي بْدَاتْ فِي الجَلِيلْ بَعْدْ المَعْمُودِيَّة الِّي نَادَى بِيهْ يُوحَنَّا، ");
INSERT INTO aeu_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","وكِيفَاشْ اللَّهْ مْلَى يَسُوعْ النَّاصْرِي بِالرُّوحْ القُدُسْ وبِالقُوَّة، وكِيفَاشْ كَانْ يِمْشِي مِنْ بُقْعَة لْبُقْعَة يَعْمِلْ فِي الخِيرْ ويِشْفِي الِّي تْسَلِّطْ عْلِيهُمْ إِبْلِيسْ الكُلْ، عْلَى خَاطِرْ اللَّهْ كَانْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","وأَحْنَا شْهُودْ عْلَى كُلْ الِّي عَمْلُو فِي بْلَادْ اليْهُودْ وفِي أُورْشَلِيمْ. وبِالحَقْ صَلْبُوهْ وقَتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","آمَا اللَّهْ قَوْمُو مِالمُوتْ فِي النْهَارْ الثَّالِثْ، وخَلَّاهْ يُظْهُرْ، ");
INSERT INTO aeu_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","مُشْ لِلنَّاسْ الكُلْ، آمَا لِلشْهُودْ الِّي إِخْتَارْهُمْ اللَّهْ مِنْ قْبَلْ، مَعْنَاهَا لِينَا أَحْنَا الِّي كْلِينَا وشْرَبْنَا مْعَاهْ بَعْدْمَا قَامْ مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ووَصَّانَا نْوَصْلُوا البْشَارَة لِلنَّاسْ، ونِشْهْدُوا الِّي اللَّهْ حَطُّو هُوَّ بَاشْ يْحَاسِبْ الحَيِّينْ والمُوتَى. ");
INSERT INTO aeu_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","والأَنْبِيَاءْ الكُلْ يِشْهْدُولُو الِّي كُلْ وَاحِدْ يَأَمِّنْ بِيهْ تِتْغْفِرْ ذْنُوبُو بْإِسْمُو». ");
INSERT INTO aeu_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","وَقْتِلِّي كَانْ بُطْرُسْ يْقُولْ فِي الكْلَامْ هَاذَا، هْبَطْ الرُّوحْ القُدُسْ عَلِّي كَانُوا يِسْمْعُوا فِيهْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","يَاخِي تْعَجْبُوا المُؤْمْنِينْ اليْهُودْ الِّي جَاوْا مْعَ بُطْرُسْ، عْلَى خَاطِرْ اللَّهْ عْطَى هِيبِةْ الرُّوحْ القُدُسْ لِلنَّاسْ الِّي مَاهُمْشْ يْهُودْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","وسَمْعُوهُمْ يِتْكَلْمُوا بْلُوغَاتْ أُخْرَى ويْسَبْحُوا فِي اللَّهْ. يَاخِي بُطْرُسْ قَالْ: ");
INSERT INTO aeu_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«النَّاسْ هَاذُومَا خْذَاوْ الرُّوحْ القُدُسْ كِيفْنَا، مَالَا يْنَجِّمْشْ وَاحِدْ يَمْنَعْ إِنْهُمْ يِتْعَمْدُوا بِالمَاء؟». ");
INSERT INTO aeu_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","وأْمَرْ بَاشْ يِتْعَمْدُوا بْإِسْمْ يَسُوعْ المَسِيحْ، ومْبَعِّدْ طَلْبُوا مِنُّو بَاشْ يْزِيدْ يُقْعُدْ مْعَاهُمْ أَيَّامَاتْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","وسَمْعُوا الرُّسُلْ والإِخْوَة الِّي فِي اليَهُودِيَّة، الِّي الشُّعُوبْ الأُخْرِينْ زَادَا قِبْلُوا كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","وَقْتِلِّي رْجَعْ بُطْرُسْ لْأُورْشَلِيمْ، المُؤْمْنِينْ اليْهُودْ المْطَهْرِينْ لَامُوا عْلِيهْ وقَالُولُو: ");
INSERT INTO aeu_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","«كِيفَاشْ دْخَلْتْ لْدَارْ نَاسْ مُشْ مْطَهْرِينْ وكْلِيتْ مْعَاهُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","يَاخِي بْدَى بُطْرُسْ يْفَسْرِلْهُمْ فِلِّي صَارْ بِالتَّفْصِيلْ، وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«كُنْتْ نْصَلِّي فِي يَافَا، يَاخِي شُفْتْ فِي رُؤْيَا حَاجَة كِالمَلْحْفَة الكْبِيرَة مَرْبُوطَة مِالأَرْبْعَة شِيرَاتْ هَابْطَة مِالسْمَاء حَتَّى لِينْ وِصْلِتْلِي. ");
INSERT INTO aeu_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","وَقْتِلِّي ثَبَّتّْ مْلِيحْ، لْقِيتْ فِيهَا أَنْوَاعْ الحَيَوَانَاتْ الِّي تِمْشِي ولِّي تَزْحِفْ ولِّي اطِّيرْ والحَيَوَانَاتْ المِتْوَحْشَةْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","وسْمَعْتْ صُوتْ يْقُلِّي: \"يَا بُطْرُسْ، قُومْ اذْبَحْ وكُولْ!\". ");
INSERT INTO aeu_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","آمَا آنَا جَاوِبْتْ: \"لَا يَا رَبْ! رَانِي عُمْرِي مَا حَطِّيتْ فِي فُمِّي حَاجَة مَنْزُوسَة ولَا مْحَرْمَة\". ");
INSERT INTO aeu_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","يَاخِي الصُّوتْ جَاوِبْنِي مَرَّة أُخْرَى مِالسْمَاء: \"الِّي طَهْرُو اللَّهْ مَا تِحْسْبُوشْ إِنْتِ مَنْزُوسْ\". ");
INSERT INTO aeu_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","وتْعَاوِدْ هَاذَا ثْلَاثَة مَرَّاتْ، وبَعْدْ تْهَزَ كُلْ شَيْ لِلسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","وفِي لَحْظِتْهَا، وُصْلُوا لِلدَّارْ الِّي كُنْتْ فِيهَا، ثْلَاثَة رْجَالْ مَبْعُوثِينْ لِيَّا مِنْ مْدِينِةْ قَيْصَرِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","وأْمَرْنِي الرُّوحْ بَاشْ نِمْشِي مْعَاهُمْ مِنْ غِيرْ مَا نِتْرَدِّدْ. يَاخِي مْشِيتْ ومْعَايَا السِّتَّة أَخْوَة هَاذُومَا. ودْخَلْنَا لْدَارْ الرَّاجِلْ، ");
INSERT INTO aeu_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","حْكَالْنَا كِيفَاشْ شَافْ المَلَاكْ وَاقِفْ فِي دَارُو ويْقُلُّو: \"أَبْعِثْ رْجَالْ لْيَافَا يْجِيبُوا سِمْعَانْ الِّي يْعَيْطُولُو بُطْرُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","وهُوَّ بِشْ يْكَلْمِكْ بِكْلَامْ تِنْجَى بِيهْ إِنْتِ وعَايِلْتِكْ الكُلْ\". ");
INSERT INTO aeu_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","وَقْتِلِّي بْدِيتْ نِتْكَلِّمْ هْبَطْ عْلِيهُمْ الرُّوحْ القُدُسْ كِيمَا هْبَطْ عْلِينَا أَحْنَا فِي الأُوِّلْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","وتْذَكَّرْتْ الِّي قَالْهُولْنَا الرَّبْ: \"يُوحَنَّا عَمِّدْ بِالمَاءْ، آمَا إِنْتُومَا بِشْ تِتْعَمْدُوا بِالرُّوحْ القُدُسْ\". ");
INSERT INTO aeu_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","إِذَا كَانْ اللَّهْ عْطَاهُمْ نَفْسْ الهِيبَة الِّي عْطَاهَالْنَا كِي أَمَّنَّا بِالرَّبْ يَسُوعْ المَسِيحْ، شْكُونْ آنَا بَاشْ نَمْنْعُو؟». ");
INSERT INTO aeu_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","وَقْتِلِّي الحَاضْرِينْ سَمْعُوا الكْلَامْ هَاذَا، سِكْتُوا وحَمْدُوا اللَّهْ وقَالُوا: «مَالَا اللَّهْ نْعِمْ زَادَا عَلِّي مَاهُمْشْ يْهُودْ بَاشْ يْتُوبُوا ويِنْجَاوْ». ");
INSERT INTO aeu_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","آمَا المُؤْمْنِينْ الِّي تْفَرْقُوا بِسْبَبْ الإِضْطِهَادْ الِّي صَارِلْهُمْ بَعْدْمَا مَاتْ اسْتِفَانُوسْ، وِصْلُوْا حَتَّى لْفِينِيقْيَة وقُبْرُصْ وأَنْطَاكْيَة ومَا بَشْرُوا بِكِلْمَةْ اللَّهْ كَانْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","آمَا كَانْ فَمَّة شْكُونْ مِنْهُمْ أَصْلْهُمْ مِنْ قُبْرُصْ وقِيرِينَا، كِي وُصْلُوا لْأَنْطَاكْيَة، بْدَاوْ يَحْكِيوْ مْعَ اليُونَانِيِّينْ ويْبَشْرُوا فِيهُمْ بِالرَّبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","وكَانْ الرَّبْ مْعَاهُمْ، يَاخِي أَمْنُوا بَرْشَة نَاسْ، ورَجْعُوا لِلرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ووْصِلْ الخْبَرْ لِلكْنِيسَة المَوْجُودَة فِي أُورْشَلِيمْ، يَاخِي بَعْثُوا بَرْنَابَا لْأَنْطَاكْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","وَقْتِلِّي وْصُلْ وشَافْ كِيفَاشْ اللَّهْ نْعِمْ عْلِيهُمْ، فْرَحْ بَرْشَة، ووَصَّاهُمْ بَاشْ يْشِدُّوا صْحِيحْ فِي الرَّبْ، مِنْ كُلْ قْلُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","وكَانْ بَرْنَابَا رَاجِلْ صَالَحْ، مِلْيَانْ بِالرُّوحْ القُدُسْ والإِيمَانْ، وبَرْشَة نَاسْ أَمْنُوا بِالرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ومْبَعِّدْ، مْشَى بَرْنَابَا لْطَرْسُوسْ يْلَوِّجْ عْلَى شَاوُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","وَقْتِلِّي لْقَاهْ، رَجّْعُو مْعَاهْ لْأَنْطَاكْيَة، وقَعْدُوا عَامْ كَامِلْ وهُومَا يِتْلَمُّوا مْعَ الكْنِيسَة، ويْعَلْمُوا فِي بَرْشَة نَاسْ. وفِي أَنْطَاكْيَة، كَانِتْ أَوِّلْ مَرَّة يِتْسَمَّاوْ فِيهَا تْلَامِذْةْ الرَّبْ «المَسِيحِيِّينْ». ");
INSERT INTO aeu_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","وفِي الوَقْتْ هَاذَاكَا، جَاوْ أَنْبِيَاءْ مِنْ أُورْشَلِيمْ لْأَنْطَاكْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","وْقِفْ وَاحِدْ مِنْهُمْ إِسْمُو أَغَابُوسْ، وتْنَبَّأْ بِالرُّوحْ الِّي بِشْ تْصِيرْ مَجَاعَة كْبِيرَة فِي العَالِمْ الكُلْ. والمَجَاعَة هَاذِي صَارِتْ بِالحَقْ فِي زْمَانْ القَيْصِرْ كْلُودْيُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","يَاخِي قَرْرُوا التْلَامْذَة بِشْ يِتْبَرَّعْ كُلْ وَاحِدْ مِنْهُمْ بِلِّي يَقْدِرْ عْلِيهْ ويِبْعْثُوا التَّبَرُّعَاتْ لِلْإِخْوَة السَّاكْنِينْ فِي مَنْطَقْةْ اليَهُودِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","وهَاذَا الِّي عَمْلُوهْ بِالضَّبْطْ، بَعْثُوا تَبَرُّعَاتْهُمْ لِشْيُوخْ الكْنِيسَة مْعَ بَرْنَابَا وشَاوُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","فِي الوَقْتْ هَاذَاكَا بْدَا المَلِكْ هِيرُودُسْ يِضْطَهِدْ فِي جْمَاعَة مِالمُؤْمْنِينْ الِّي فِي الكْنِيسَة. ");
INSERT INTO aeu_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","وقْتَلْ يَعْقُوبْ خُو يُوحَنَّا بْسِيفْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","وَقْتِلِّي شَافْ الِّي هَاذَا يْرَضِّي اليْهُودْ، قَرِّرْ بَاشْ يْشِدْ بُطْرُسْ زَادَا. وكَانْ هَاذَا فِي أَيَّامَاتْ عِيدْ الفْطِيرْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","وَقْتِلِّي شَدُّو، حَطُّو فِي الحَبْسْ، وحَطْ أَرْبْعَة فِرَقْ عَسْكِرْ يْعِسُّوا عْلِيهْ، كُلْ فِرْقَةْ فِيهَا أَرْبْعَة، وكَانْ نَاوِي يُحْكُمْ عْلِيهْ قُدَّامْ الشَّعْبْ بَعْدْ عِيدْ الفِصْحْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","هَاذَاكَا عْلَاشْ خَلَّاهْ فِي الحَبْسْ، آمَا الكْنِيسَة كَانِتْ تْصَلِّي لِلَّهْ بْقُوَّة عْلَى خَاطْرُو. ");
INSERT INTO aeu_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","وقْبَلْ مَا يُحْكُمْ عْلِيهْ هِيرُودُسْ بْلِيلَة، كَانْ بُطْرُسْ رَاقِدْ بِينْ زُوزْ عَسْكِرْ ومَرْبُوطْ بْزُوزْ سْلَاسِلْ، وكَانُوا الحُرَّاسْ قُدَّامْ البَابْ يْعِسُّوا عَالحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","وإِذَا بِيهْ ظْهُرْ مَلَاكْ مِنْ عَنْدْ الرَّبْ، والبِيتْ الِّي كَانْ مَرْبُوطْ فِيهَا الكُلْهَا ضْوَاتْ. وهْمِزْ المَلَاكْ بُطْرُسْ فِي جَنْبُو وفَيْقُو وقَالُّو: «قُومْ فِيسَعْ!». يَاخِي طَاحُوا السْلَاسِلْ الزُّوزْ مِنْ يْدِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","وقَالُّو المَلَاكْ: «إِلْبِسْ حْزَامِكْ وصَنْدَالِكْ». وعْمَلْ بُطْرُسْ كِيمَا قَالُّو، مْبَعِّدْ زَادْ قَالُّو: «إِلْبِسْ بَرْنُوسِكْ وتَبَّعْنِي!». ");
INSERT INTO aeu_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","وخْرَجْ بُطْرُسْ يْتَبَّعْ فِي المَلَاكْ، ومَا كَانِشْ يَعْرِفْ إِنُّو الِّي عَمْلُو المَلَاكْ حْقِيقَة، مَاشِي فِي بَالُو قَاعِدْ يْشُوفْ فِي رُؤْيَا. ");
INSERT INTO aeu_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","وَقْتِلِّي تْعَدَّاوْ عْلَى فِرْقِةْ العَسْكَرْ الأُولَى والثَّانِيَة ووُصْلُوا لْبَابْ الحَبْسْ الحْدِيدْ الِّي يْهِزْ لِلْمْدِينَة، تْحَلِّلْهُمْ البَابْ وَحْدُو، وخَرْجُوا. وبَعْدْمَا مْشَاوْ فِي أَوِّلْ النَهْجْ، خَلَّاهْ المَلَاكْ ومْشَى بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","وَقْتْهَا فْطُنْ بُطْرُسْ وقَالْ: «تَوْ تْأَكِّدْتْ الِّي الرَّبْ بْعَثْ مَلَاكُو ومَنَّعْنِي مِنْ يِدْ هِيرُودُسْ ومِلِّي كَانُوا اليْهُودْ يِتْوَقْعُوهْ بِشْ يَعْمْلُوا فِيَّا». ");
INSERT INTO aeu_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","وَقْتِلِّي فْهِمْ هَاذَا، مْشَى لْدَارْ مَرْيِمْ أُمْ يُوحَنَّا الِّي يْسَمِّيوَهْ مُرْقُسْ، وِينْ كَانُوا بَرْشَة مُؤْمْنِينْ مَلْمُومِينْ يْصَلِّيوْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","دَقْ عَالبَابْ البَرَّانِي، يَاخِي جَاتْ خْدِيمَة اسْمْهَا رُودَة بَاشْ تْشُوفْ شْكُونْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","وكِي سَمْعِتْ صُوتْ بُطْرُسْ عَرْفِتُّو. يَاخِي مِنْ فَرْحِتْهَا نْسَاتْ بَاشْ تْحِلْ البَابْ ودَخْلِتْ تِجْرِي وقَالْتِلْهُمْ: «رَاهُو بُطْرُسْ وَاقِفْ قُدَّامْ البَابْ!». ");
INSERT INTO aeu_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","قَالُولْهَا: «إِنْتِ تْهَتْرِي!». آمَا هِيَّ شَدِّتْ صْحِيحْ فِي كْلَامْهَا، يَاخِي قَالُوا: «مَالَا هَاذَا مَلَاكُو!». ");
INSERT INTO aeu_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","وقْعَدْ بُطْرُسْ يْدُقْ فِي البَابْ حَتَّى لِينْ حَلُّولُو، وكِيفْ شَافُوهْ بِهْتُوا. ");
INSERT INTO aeu_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","وهَزْ يِدُّو بَاشْ يُسْكْتُوا، وحْكَالْهُمْ كِيفَاشْ الرَّبْ خَرّْجُو مِالحَبْسْ. وقَالِلْهُمْ: «قُولُوا لْيَعْقُوبْ ولِلإِخْوَة المُؤْمْنِينْ عَلِّي صَارْ». ومْبَعِّدْ خْرَجْ ومْشَى لِبْلَاصَة أُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","وَقْتِلِّي طْلَعْ النْهَارْ، الحُرَّاسْ دَخْلُوا بْعَضْهُمْ، وبْدَاوْ يِسْأْلُوا: «زَعْمَة آشْ صَارْ لْبُطْرُسْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","وكِي طْلَبْ هِيرُودُسْ بَاشْ يْجِيبُوهْ ومَا لْقَاوُوهِشْ، إِسْتَجْوِبْ الحُرَّاسْ، وحْكُمْ عْلِيهُمْ بِالإِعْدَامْ. مْبَعِّدْ مْشَى هِيرُودُسْ مِنْ مَنْطَقْةْ اليَهُودِيَّة لْقَيْصَرِيَّة وقْعَدْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","وكَانْ هِيرُودُسْ نَاقِمْ عْلَى سُكَّانْ صُورْ وصَيْدَا. يَاخِي تْفَاهْمُوا مْعَ بْعَضْهُمْ وبَعْثُوا جْمَاعَة لِبْلَاسْتُسْ حَاجِبْ المَلِكْ وتْشَحْتُوهْ بَاشْ يِتْوَسْطِلْهُمْ، فَمَّاشْ مَا تِتْصَلَّحْ الأُمُورْ مْعَ هِيرُودُسْ، عْلَى خَاطِرْهُمْ كَانُوا يِسْتَرْزْقُوا مِنْ مَمْلِكْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","وفِي النْهَارْ الِّي بِشْ يْقَابِلْهُمْ فِيهْ، لْبِسْ هِيرُودُسْ لِبْسَة خَاصَّة بِالمُلُوكْ، وقْعَدْ عَالعَرْشْ وبْدَا يُخْطُبْ عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","يَاخِي صَاحْ الشَّعْبْ: «هَاذَا صُوتْ إِلَاهْ، مُشْ صُوتْ إِنْسَانْ!». ");
INSERT INTO aeu_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","وبِالوَقْتْ ضَرْبُو مَلَاكْ مِنْ عَنْدْ الرَّبْ عْلَى خَاطْرُو مَا عْطَاشْ المَجْدْ لِلَّهْ، يَاخِي كْلَاهْ الدُّودْ ومَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","آمَا كَانِتْ كِلْمِةْ اللَّهْ مَاشْيَة وتِتِّنْشَرْ، وعْدَدْ المُؤْمْنِينْ مَاشِي ويُكْثُرْ. ");
INSERT INTO aeu_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ورَجْعُوا بَرْنَابَا وشَاوُلْ مِنْ أُورْشَلِيمْ بَعْدْمَا كَمْلُوا مُهِمِّتْهُمْ، وجَابُوا مْعَاهُمْ يُوحَنَّا الِّي يْسَمِّيوَهْ مُرْقُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","وكَانْ فَمَّة فِي كْنِيسِةْ أَنْطَاكْيَة جْمَاعَة مِالأَنْبِيَاءْ والمُعَلْمِينْ، ومِنْهُمْ بَرْنَابَا، وسِمْعَانْ الِّي يْعَيْطُولُو لَسْوِدْ، ولُوكْيُوسْ مِنْ قِيرِينَا، ومَنَايَنْ الِّي تْرَبَّى مْعَ الوَالِي هِيرُودُسْ وَقْتِلِّي كَانْ صْغِيرْ، وشَاوُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","وَقْتِلِّي كَانُوا يِعْبْدُوا فِي الرَّبْ وصَايْمِينْ، قَالِلْهُمْ الرُّوحْ القُدُسْ: «إِفْرْزُولِي بَرْنَابَا وشَاوُلْ لِلْخِدْمَة الِّي دْعِيتْهُمْ لِيهَا». ");
INSERT INTO aeu_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","بَعْدْمَا صَامُوا وصَلَّاوْ، حَطُّوا عْلِيهُمْ يْدِيهُمْ وخَلَّاوْهُمْ يِمْشِيوْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","وكِي بْعَثْهُمْ الرُّوحْ القُدُسْ، مْشَاوْ بَرْنَابَا وشَاوُلْ لْبُرْطْ سَلُوكِيَة، ومِنْ غَادِي سَافْرُوا لْجَزِيرِةْ قُبْرُصْ عْلَى طْرِيقْ البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","وَقْتِلِّي وُصْلُوا لِمْدِينِةْ سَلَامِيسْ، بْدَاوْ يْبَشْرُوا بْكِلْمِةْ اللَّهْ فِي مْعَابِدْ اليْهُودْ وكَانْ يُوحَنَّا يْعَاوِنْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","وسَافْرُوا فِي جَزِيرِةْ قُبْرُصْ الكُلْ حَتَّى لِينْ وُصْلُوا لِمْدِينِةْ بَافُوسْ. وغَادِي لْقَاوْ سَحَّارْ يْهُودِي، نَبِيْ كَذَّابْ، إِسْمُو بَارْيَشُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","وكَانْ مِالمُقَرْبِينْ لْسَرْجِيُوسْ بُولُسْ وَالِي قُبْرُصْ. وكَانْ الوَالِي هَاذَا إِنْسَانْ ذْكِي. اسْتَدْعَى بَرْنَابَا وشَاوُلْ بَاشْ يِسْمَعْ مِنْهُمْ كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","يَاخِي عَلِيمْ السَّحَّارْ (وهَاذَا مَعْنَى إِسْمُو)، جَاء ضِدْهُمْ وحَاوِلْ مَا يْخَلِّيشْ الوَالِي يَمِّنْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","آمَا شَاوُلْ الِّي إِسْمُو بُولِسْ زَادَا تِمْلَى بِالرُّوحْ القُدُسْ، وخْزَرْ لِلسَّحَّارْ ");
INSERT INTO aeu_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","وقَالُّو: «يَا وِلْدْ إِبْلِيسْ، يَا عْدُوْ الحَقْ، يَا غَشَّاشْ ويَا خْبِيثْ، مَاكِشْ بِشْ تْبَطِّلْ مِنْ تَعْوِيجْ الحْقِيقَة الِّي تْخُصْ الرَّبْ؟ ");
INSERT INTO aeu_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","تَوَّا الرَّبْ بِشْ يْمِدْ عْلِيكْ يِدُّو وتْوَلِّي أَعْمَى، ومَا عَادِشْ تْشُوفْ الضَّوْ لْمُدَّة مِالزْمَانْ». وبِالوَقْتْ هَبْطِتْ عْلَى عِينِيهْ ضْبَابَة كَحْلَة، وبْدَا يْدُورْ ويْلَوِّجْ عْلَى شْكُونْ يْشِدُّو مِنْ يِدُّو ويْقُودُو. ");
INSERT INTO aeu_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","وكِي شَافْ الوَالِي آشْ صَارْ تِبْهَرْ بْتَعْلِيمْ الرَّبْ وأَمِّنْ . ");
INSERT INTO aeu_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","وسَافِرْ بُولِسْ والزُّوزْ الِّي مْعَاهْ عْلَى طْرِيقْ البْحَرْ مِنْ بَافُوسْ لِمْدِينِةْ بَرْجَة الِّي فِي مَنْطَقْةْ بَمْفِيلِيَّة، وغَادِي خَلَّاهُمْ يُوحَنَّا ورْجَعْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","آمَا هُومَا سَافْرُوا مِنْ بَرْجَة لِمْدِينِةْ أَنْطَاكْيَة الِّي فِي مَنْطَقْةْ بِيسِيدِيَّة، وفِي نْهَارْ السِّبْتْ دَخْلُوا لْمَعْبِدْ اليْهُودْ وقَعْدُوا. ");
INSERT INTO aeu_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","وبَعْدْمَا تِقْرَى مِالتَّوْرَاةْ وكْتُبْ الأَنْبِيَاءْ، بَعْثُولْهُمْ رُؤَسَاءْ المَعْبِدْ وقَالُوا: «يَا خْوَاتْنَا، إِذَا كَانْ عَنْدْكُمْ كْلَامْ تْشَجْعُوا بِيهْ المَوْجُودِينْ، اتْفَضْلُوا». ");
INSERT INTO aeu_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","وْقِفْ بُولِسْ وهَزْ يِدُّو سَكِّتْهُمْ وقَالْ: «يَا بَنِي إِسْرَائِيلْ، ويَلِّي تْخَافُوا اللَّهْ إِسْمْعُوا: ");
INSERT INTO aeu_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","إِلَاهْ شَعْبْ إِسْرَائِيلْ إِخْتَارْ جْدُودْنَا، وزَادْ فِي عْدَدْ شَعْبْنَا وَقْتِلِّي كَانُوا مِتْغَرْبِينْ فِي مَصْرْ، ومْبَعِّدْ خَرِّجْهُمْ مِنْهَا بْقُدْرْتُو العْظِيمَة. ");
INSERT INTO aeu_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","وتْحَمِّلْهُمْ لْمُدِّةْ أَرْبْعِينْ سْنَة فِي الصَّحْرَاء. ");
INSERT INTO aeu_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","وفْنَى سَبْعَة شْعُوبْ فِي أَرْضْ كَنْعَانْ، وعْطَى أَرْضْهُمْ وَرْثَة لْشَعْبُو. ");
INSERT INTO aeu_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","وبَعْدْ مُدِّةْ 450 سْنَة، عْطَاهُمْ قُضَاةْ حَتَّى لْوَقْتْ النَّبِيْ صَمُوئِيلْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ومْبَعِّدْ، الشَّعْبْ طْلَبْ مَلِكْ. يَاخِي اللَّهْ حَطْ شَاوُلْ وِلْدْ قَيْسْ مِنْ عَرْشْ بِنْيَامِينْ مَلِكْ عْلِيهُمْ لْمُدِّةْ 40 سْنَة. ");
INSERT INTO aeu_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ومْبَعِّدْ نَحَّاهْ وحَطْ دَاوِدْ مَلِكْ عْلِيهُمْ، وشْهِدْلُو وقَالْ: \"لْقِيتْ دَاوِدْ وِلْدْ يَسَّى رَاجِلْ يَرْضَى عْلِيهْ قَلْبِي، وبِشْ يَعْمِلْ الِّي نْحِبْ عْلِيهْ\". ");
INSERT INTO aeu_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ومِنْ ذُرِّيِّةْ دَاوِدْ، بْعَثْ اللَّهْ مُنَجِّي لْشَعْبْ إِسْرَائِيلْ كِيفْ مَا وعِدْهُمْ. والمُنَجِّي هَاذَا هُوَّ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","«وقْبَلْ مَا يْجِي يَسُوعْ، دْعَى يُوحَنَّا شَعْبْ إِسْرَائِيلْ الكُلْ بَاشْ يْتُوبُوا ويِتْعَمْدُوا. ");
INSERT INTO aeu_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","وَقْتِلِّي قْرِيبْ يْكَمِّلْ مُهِمْتُو قَالْ: \"شْكُونْ تِسْخَايْلُونِي؟ مَانِيشْ آنَا المُنَجِّي! آمَا هَاوْ بِشْ يْجِي بَعْدِي، وآنَا مَا نِسْتَاهِلْشْ حَتَّى بَاشْ نْحِلُّو رْبَايِطْ صَنْدَالُو\". ");
INSERT INTO aeu_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","«يَا خْوَاتِي، إِنْتُومَا يَا وْلَادْ إِبْرَاهِيمْ وإِنْتُومَا يَلِّي تْخَافُوا اللَّهْ مِالحَاضْرِينْ، رَاهِي رِسَالِةْ النْجَاةْ تْبَعْثِتْ لِينَا أَحْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","آمَا أَهْلْ أُورْشَلِيمْ ورُؤَسَاءْهُمْ مَا عَرْفُوشْ يَسُوعْ يَاخِي حُكْمُوا عْلِيهْ بِالمُوتْ. وهَكَّا تَمُّوا كْلَامْ الأَنْبِيَاءْ الِّي يَقْرَاوَهْ كُلْ نْهَارْ سِبْتْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ورَغْمِلِّي مَا لْقَاوْ حَتَّى سْبَبْ يِسْتَاهِلْ عْلِيهْ المُوتْ، طَلْبُوا مِنْ بِيلَاطُسْ بَاشْ يُقْتْلُو. ");
INSERT INTO aeu_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","وبَعْدْمَا عَمْلُوا فِيهْ كُلْ الِّي كِتْبُوهْ عْلِيهْ الأَنْبِيَاءْ، هَبْطُوهْ مِنْ فُوقْ الصَّلِيبْ وحَطُّوهْ فِي القْبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","آمَا اللَّهْ قَوْمُو مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ظْهُرْ مُدَّة لِلِّي مْشَاوْ مْعَاهْ مِالجَلِيلْ لْأُورْشَلِيمْ. وهُومَا تَوَّا يِشْهْدُولُو قُدَّامْ الشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","«وأَحْنَا تَوَّا نْبَشْرُوكُمْ إِنُّو الوَعْدْ الِّي عْطَاهْ اللَّهْ لِجْدُودْنَا، ");
INSERT INTO aeu_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","حَقْقُو لِوْلَادْهُمْ الِّي هُومَا أَحْنَا، وَقْتِلِّي قَوِّمْ يَسُوعْ مِالمُوتْ، كِيمَا مَكْتُوبْ فِي المَزْمُورْ الثَّانِي: \"إِنْتِ إِبْنِي، وآنَا اليُومْ جِبْتِكْ\". ");
INSERT INTO aeu_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","«واللَّهْ قَوْمُو مِالمُوتْ ومَا عَادِشْ بِشْ يِرْجَعْ يْمُوتْ بِالكُلْ، وهَاذَا آشْ قَالْ اللَّهْ فِي الكْتُبْ المُقَدْسَة: \"بِشْ نَعْطِيكُمْ البَرَكَاتْ المُقَدْسَة والصَّادْقَة، الِّي وْعِدْتْ بِيهَا دَاوِدْ\". ");
INSERT INTO aeu_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","«ويْقُولْ دَاوِدْ فِي مَزْمُورْ آخِرْ: \"مَاكِشْ بِشْ تْخَلِّي قُدُّوسِكْ يِفْسِدْ فِي القْبَرْ\". ");
INSERT INTO aeu_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","«آمَا دَاوِدْ مَاتْ بَعْدْمَا خْدِمْ شَعْبُو بْحَسْبْ قَصْدْ اللَّهْ، وتِدْفِنْ مْعَ جْدُودُو وبَدْنُو تْعَفِّنْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","آمَا الِّي قَوْمُو اللَّهْ مِالمُوتْ، بَدْنُو مَا فْسِدْشْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","مَالَا يْكُونْ فِي عِلْمْكُمْ يَا خْوَاتِي، الِّي أَحْنَا نْبَشْرُوا فِيكُمْ إِنُّو غُفْرَانْ الذْنُوبْ يْكُونْ عْلَى طْرِيقْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","وكُلْ وَاحِدْ يَأَمِّنْ بِيهْ، يِتْحَرَّرْ مِنْ ذْنُوبُو الكُلْ. وهَاذَا شَرِيعِةْ مُوسَى مَا تْنَجَّمْشْ تَعْمْلُو. ");
INSERT INTO aeu_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","مَالَا رُدُّوا بَالْكُمْ لَا يَجْرَالْكُمْ الِّي تْقَالْ فِي كْتُبْ الأَنْبِيَاءْ: ");
INSERT INTO aeu_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","\"أُخْزْرُوا يَلِّي تِتْمَسْخْرُوا، اتْعَجْبُوا وافْنَاوْ! عْلَى خَاطِرْ فِي زْمَانْكُمْ بِشْ نَعْمِلْ شَيْ عْمُرْكُمْ لَا بِشْ تْصَدْقُوهْ حَتَّى لَوْ حَدْ حْكَالْكُمْ عْلِيهْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ووَقْتِلِّي كَانُوا بُولِسْ وبَرْنَابَا خَارْجِينْ مِنْ مَعْبِدْ اليْهُودْ، لَحُّوا عْلِيهُمْ النَّاسْ بَاشْ يِرْجْعُوا السِّبْتْ الِّي بَعْدُو ويْكَلْمُوهُمْ فِي نَفْسْ المَوْضُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","وبَعْدْمَا وْفَى الإِجْتِمَاعْ، تَبْعُوهُمْ بَرْشَة مِاليْهُودْ ومِالمِتْهَوْدِينْ الِّي يْخَافُوا رَبِّي، يَاخِي بْدَاوْ بُولِسْ وبَرْنَابَا يْكَلْمُوا فِيهُمْ ويْشَجْعُوا فِيهُمْ بَاشْ يِثْبْتُوا فِي نِعْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","والسِّبْتْ الِّي مْبَعْدُو تْلَمُّوا تَقْرِيبْ إِمَّالِي البْلَادْ الكُلْ بَاشْ يِسْمْعُوا كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","وكِي اليْهُودْ شَافُوا عْدَدْ النَّاسْ المَلْمُومِينْ، تِمْلَاتْ قْلُوبْهُمْ بِالغِيرَة وبْدَاوْ يْعَارْضُوا فِي بُولِسْ ويْسِبُّوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","يَاخِي كَلْمُوهُمْ بُولِسْ وبَرْنَابَا بْكُلْ ثِيقَة وقَالُوا: «كَانْ لَازِمْ نْوَصْلُوا كِلْمِةْ اللَّهْ لِيكُمْ إِنْتُومَا الأُولَانِينْ، آمَا كِي رْفَضْتُوهَا، وحْكُمْتُوا عْلَى رْوَاحْكُمْ بِلِّي إِنْتُومَا مَا تِسْتَاهْلُوشْ الحَيَاةْ الأَبَدِيَّة، هَانَا تَوَّا مَاشْيِنْ بَاشْ نْوَصْلُوهَا لِلِّي مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","والرَّبْ أَمَرْنَا وقَالْ: \"خَلِّيتِكْ نُورْ لِلشُّعُوبْ الأُخْرَى، بَاشْ تْوَصِّلْ النْجَاةْ لِخِّرْ الأَرْضْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","وكِي سَمْعُوا الِّي مَاهُمْشْ يْهُودْ الكْلَامْ هَاذَا، فَرْحُوا بَرْشَة، ومَجْدُوا كِلْمِةْ الرَّبْ. وأَمْنُوا كُلْ الِّي إِخْتَارْهُمْ اللَّهْ لِلحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","وانْتَشْرِتْ كِلْمِةْ الرَّبْ فِي المَنْطْقَة الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","آمَا اليْهُودْ حَرْشُوا النْسَاء المِتْدَيْنِينْ الِّي مْقَامْهُمْ عَالِي وأَعْيَانْ لِمْدِينَة. يَاخِي اتْسَبْبُّوا فِي اضْطِهَادْ ضِدْ بُولِسْ وبَرْنَابَا، حَتَّى طَرْدُوهُمْ مِنْ مَنْطْقِتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","يَاخِي نَفْضُوا التْرَابْ مِنْ سَاقِيهُمْ، أَمَارَة ضِدْهُمْ، ومْشَاوْ لْمَنْطَقْةْ إِيقُونْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","وكَانُوا التْلَامْذَة مِلْيَانِينْ بِالفَرْحَة وبِالرُّوحْ القُدُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","وفِي إِيقُونْيَة، دَخْلُوا بُولِسْ وبَرْنَابَا لْمَعْبِدْ اليْهُودْ كِالعَادَة، وقَالُوا كْلَامْ خَلَّى بَرْشَة يْهُودْ ولِّي مَاهُمْشْ يْهُودْ يَمْنُوا. ");
INSERT INTO aeu_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","آمَا اليْهُودْ الِّي مَا أَمْنُوشْ، حَرْشُوا النَّاسْ الِّي مَاهُمْشْ يْهُودْ عَالإِخْوَة، وعَمْرُولْهُمْ مْخَاخْهُمْ عْلِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","آمَا بُولِسْ وبَرْنَابَا قَعْدُوا غَادِي مُدَّة طْوِيلَة يْبَشْرُوا بِالرَّبْ بْكُلْ ثِيقَة. وكَانْ الرَّبْ يْأَكِّدْ فِي كْلَامْهُمْ عْلَى نِعْمْتُو بْمُعْجْزَاتْ وعْجَايِبْ عْمَلْهَا عْلَى يْدِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","يَاخِي اتْقِسْمُوا أَهْلْ المْدِينَة: جْمَاعَة مْعَ اليْهُودْ، وجْمَاعَة مْعَ الرُّسُلْ الزُّوزْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","وكِي قَرْرُوا اليْهُودْ وشْيُوخْهُمْ والنَّاسْ الِّي مَاهُمْشْ يْهُودْ بَاشْ يْهِينُوا الرُّسُلْ ويُرْجْمُوهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","عَرْفُوا الرُّسُلْ الحْكَايَة، يَاخِي هَرْبُوا لْمُدُنْ لِسْتْرَة ودَرْبَة الِّي فِي مَنْطَقْةْ لِيقُونِيَة ولِلْبْلَايِصْ الدَّايْرَة بِيهُمْ ");
INSERT INTO aeu_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","وكَمْلُوا يْبَشْرُوا غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","وفِي لِسْتْرَة، كَانْ فَمَّة رَاجِلْ قَاعِدْ، مَشْلُولْ مِلِّي تُولِدْ، وعُمْرُو مَا مْشَى بِالكُلْ . ");
INSERT INTO aeu_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","وكَانْ يِسْمَعْ فِي كْلَامْ بُولِسْ، يَاخِي ثَبِّتْ فِيهْ بُولِسْ وشَافْ الِّي كَانْ عَنْدُو إِيمَانْ الِّي هُوَّ بِشْ يَبْرَى. ");
INSERT INTO aeu_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","قَالُّو بْصُوتْ عَالِي: «قُومْ آقِفْ عْلَى سَاقِيكْ!». يَاخِي نَڨِّزْ الرَّاجِلْ وبْدَا يِمْشِي. ");
INSERT INTO aeu_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","وكِي شَافُوا الحَاضْرِينْ الِّي عَمْلُو بُولِسْ، صَاحُوا بِاللُّوغَة اللِّيقُونِيَّة: «هَاوْ الآلْهَة ظُهْرُوا فِي شَكْلْ عْبَادْ وجَاوْ بَحْذَانَا!». ");
INSERT INTO aeu_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","وسَمَّاوْ بَرْنَابَا «زَفْسَ»، وبُولِسْ «هَرْمَسَ» عْلَى خَاطْرُو هُوَّ الِّي كَانْ يِتْكَلِّمْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","وكَانْ فِي مَدْخِلْ المْدِينَة مَعْبِدْ الإِلَاهْ زَفْسَ، جَاء الكَاهِنْ مْتَاعُو ووْرَاهْ نَاسْ أُخْرِينْ فِي يْدِيهُمْ تِيجَانْ مِالنَوَّارْ وجَايْبِينْ ثِيرَانْ بَاشْ يْقَدْمُوهُمْ ذْبِيحَة لْبُولِسْ وبَرْنَابَا. ");
INSERT INTO aeu_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","وَقْتِلِّي سَمْعُوا الرُّسُلْ بِالحْكَايَة، قَطْعُوا حْوَايِجْهُمْ، ومْشَاوْ لِلنَّاسْ يِجْرِيوْ ويْعَيْطُوا: ");
INSERT INTO aeu_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«يَا نَاسْ، عْلَاشْ تَعْمْلُوا هَكَّا؟ رَانَا بَشَرْ ضْعَافْ كِيفْنَا كِيفْكُمْ، جِينَا نْبَشْرُوا فِيكُمْ بَاشْ تْبَطْلُوا الحَاجَاتْ الفَارْغَة هَاذِي، وتِرْجْعُوا لِلَّهْ الحَيْ الِّي خْلَقْ الأَرْضْ والسْمَاء والبْحَرْ وكُلْ الِّي فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","فِي الأَجْيَالْ السَّابْقَة الكُلْ اللَّهْ خَلَّى الشُّعُوبْ يِمْشِيوْ فِي الطْرِيقْ الِّي اخْتَارُوهْ، ");
INSERT INTO aeu_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","آمَا فِي نَفْسْ الوَقْتْ كَانْ دِيمَا يَعْطِيهُمْ دَلِيلْ الِّي هُوَّ مَوْجُودْ بِالخِيرْ الِّي يَعْمْلُو، وهُوَّ مَزَّالْ يَعْطِيكُمْ المْطَرْ مِالسْمَاء، والصَّابَة فِي وَقْتْهَا، ويْشَبَّعْكُمْ بِالمَاكْلَة ويْفَرَّحْ قْلُوبْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","وحَتَّى كِي قَالُولْهُمْ الكْلَامْ هَاذَا، مَا نَجْمُوا يَقْنْعُوهُمْ بَاشْ مَا يْقَدْمُولْهُمْشْ ذْبَايِحْ كَانْ بِالسِّيفْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","وجَاوْ جْمَاعَة يْهُودْ مِنْ أَنْطَاكْيَة وإِيقُونْيَة ودَوْرُوا النَّاسْ عْلَى بُولِسْ، يَاخِي رُجْمُوهْ وكَرْكْرُوهْ لْبَرَّة مِالمْدِينَة، مَاشِي فِي بَالْهُمْ الِّي هُوَّ مَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","آمَا كِي دَارُوا بِيهْ التْلَامْذَة، قَامْ ودْخَلْ لِلْمْدِينَة. ومِنْ غُدْوَة سَافِرْ مْعَ بَرْنَابَا لْدَرْبَة. ");
INSERT INTO aeu_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","وبَشْرُوا أَهْلْ دَرْبَة وبَرْشَة مِنْهُمْ وَلَّاوْ تْلَامْذَة لِلْمَسِيحْ، ومْبَعِّدْ رَجْعُوا لِلسْتْرَة، ومِنْ لِسْتْرَة تْعَدَّاوْ لْإِيقُونِيَّة، وفِي الإِخِّرْ لْأَنْطَاكْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","وكَانُوا يْقَوِّيوْ فِي عَزِيمِةْ التْلَامْذَة ويْشَجْعُوا فِيهُمْ بَاشْ يِثْبْتُوا فِي الإِيمَانْ ويْقُولُولْهُمْ: «لَازِمْ نْعَانِيوْ ونِتْعَذْبُوا بَاشْ نُدْخْلُوا لْمَمْلَكْةْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","وعَيْنُوا شْيُوخْ فِي كُلْ كَنِيسَة، وبَعْدْمَا صَلَّاوْ وصَامُوا، خَلَّاوْهُمْ فِي وْدِيعِةْ الرَّبْ الِّي أَمْنُوا بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ومْبَعِّدْ تْعَدَّاوْ عْلَى بِيسِيدِيَّة ووُصْلُوا لْمَنْطَقْةْ بَمْفِيلِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","وبَشْرُوا بْكِلْمِةْ اللَّهْ فِي بَرْجَة، ومْبَعِّدْ هَبْطُوا لِمْدِينِةْ أَتَّالِيَة. ");
INSERT INTO aeu_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ومِنْهَا رَجْعُوا عْلَى طْرِيقْ البْحَرْ لْأَنْطَاكْيَة، وهِيَّ المْدِينَة الِّي بَعْثُوهُمْ مِنْهَا الإِخْوَةْ فِي وْدِيعِةْ رَبِّي، لِلخِدْمَةْ الِّي كَمْلُوهَا. ");
INSERT INTO aeu_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","وَقْتِلِّي وُصْلُوا لْأَنْطَاكْيَة، اسْتَدْعَاوْ الكْنِيسَة، وحْكَاوْلْهُمْ عَلِّي عَمْلُو اللَّهْ مْعَاهُمْ، وكِيفَاشْ حَلْ بَابْ الإِيمَانْ لِلِّي مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","وقَعْدُوا مْعَ التْلَامْذَة مُدَّة طْوِيلَة. ");
INSERT INTO aeu_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","وجَاوْ جْمَاعَة مِاليَهُودِيَّة لْأَنْطَاكْيَة، وبْدَاوْا يْعَلْمُوا فِي الإِخْوَة ويْقُولُولْهُمْ: «كَانْ مَا تِطَّهْرُوشْ كِيفْ مَا تْقُولْ شَرِيعِةْ مُوسَى، مَاكُمْشْ بِشْ تِنْجَاوْ». ");
INSERT INTO aeu_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","يَاخِي تْخَالْفُوا بُولِسْ وبَرْنَابَا مْعَاهُمْ وصَارِتْ بِينَاتْهُمْ نِقَاشَاتْ كْبِيرَة. وَلَّاوْ الكُلْ قَرْرُوا بِشْ يَبْعْثُوا بُولِسْ وبَرْنَابَا ومْعَاهُمْ مُؤْمْنِينْ أُخْرِينْ بَاشْ يْقَابْلُوا الرُّسُلْ وشْيُوخْ الكْنِيسَة الِّي فِي أُورْشَلِيمْ ويِتْشَاوْرُوا فِي المَوْضُوعْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","وبَعْدْمَا عْطَاتْهُمْ الكْنِيسَة الِّي يِحْتَاجُوهْ لِلسْفَرْ، مْشَاوْ وتْعَدَّاوْ عْلَى فِينِيقْيَة والسَّامْرَة، وحْكَاوْ لِلْمُؤْمْنِينْ غَادِي كِيفَاشْ الِّي مَاهُمْشْ يْهُودْ زَادَا أَمْنُوا بِالمَسِيحْ. والإِخْوَة الكُلْ فَرْحُوا فَرْحَة كْبِيرَة بِالخْبَرْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","وَقْتِلِّي وُصْلُوا لْأُورْشَلِيمْ، فَرْحُوا بِيهُمْ الرُّسُلْ والشْيُوخْ والكَنِيسَة الكُلْ، يَاخِي حْكَاوْلْهُمْ عَلِّي عَمْلُو اللَّهْ عْلَى يْدِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","آمَا فَمَّة شْكُونْ مِالمُؤْمْنِينْ الِّي كَانُوا قْبَلْ فِرِّيسِيِّينْ وِقْفُوا وقَالُوا: «المُؤْمْنِينْ الِّي مَاهُمْشْ يْهُودْ يِلْزِمْهُمْ يْطَهْرُوا، ولَازِمْ تُؤْمْرُوهُمْ بَاشْ يْطَبْقُوا شَرِيعِةْ مُوسَى». ");
INSERT INTO aeu_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","وتْلَمُّوا الرُّسُلْ والشْيُوخْ بَاشْ يْنَاقْشُوا المَوْضُوعْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","وبَعْدْ نِقَاشَاتْ طْوِيلَة، وْقِفْ بُطْرُسْ وقَالْ: «يَا خْوَاتِي، إِنْتُومَا تَعْرْفُوا الِّي اللَّهْ اخْتَارْنِي مِالأُوِّلْ بَاشْ النَّاسْ الِّي مَاهُمْشْ يْهُودْ يِسْمْعُوا البْشَارَة مِنِّي ويَمْنُوا. ");
INSERT INTO aeu_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","واللَّهْ الِّي يَعْرِفْ القْلُوبْ، ظَهِّرْ الِّي هُوَّ قْبِلْهُمْ وَقْتِلِّي عْطَاهُمْ الرُّوحْ القُدُسْ كِيفْنَا أَحْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ومَا فَرِّقْشْ بِينَّا وبِينْهُمْ فِي حَتَّى شَيْ، عْلَى خَاطْرُو طَهِّرْ قْلُوبْهُمْ بِالإِيمَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","مَالَا عْلَاشْ تْعَارْضُوا فِي اللَّهْ وتْحُطُّوا عَالتْلَامْذَةْ فِي حِمْلْ لَا نَجَّمْنَا نْهِزُّوهْ لَا جْدُودْنَا ولَا أَحْنَا؟ ");
INSERT INTO aeu_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","بِالعَكْسْ أَحْنَا نَمْنُوا الِّي نِعْمِةْ الرَّبْ يَسُوعْ هِيَّ الِّي تْنَجِّينَا كِيمَا يِنْجَاوْ هُومَا زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","يَاخِي سِكْتُوا النَّاسْ الكُلْ، وبْدَاوْ يِسْمْعُوا فِي بَرْنَابَا وبُولِسْ يَحْكِيوْلْهُمْ عَالمُعْجْزَاتْ والعْجَايِبْ الِّي عْمَلْهَا اللَّهْ عْلَى يْدِيهُمْ بِينْ النَّاسْ الِّي مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","وبَعْدْمَا كَمْلُوا كْلَامْهُمْ، قَالْ يَعْقُوبْ: «يَا خْوَاتِي، إِسْمْعُونِي: ");
INSERT INTO aeu_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","سِمْعَانْ حْكَالْكُمْ كِيفَاشْ اللَّهْ حْرَصْ مِالأُوِّلْ بَاشْ يِخْتَارْ مِنْ بِينْ الشُّعُوبْ شَعْبْ يْكُونْ خَاصْ لِيهْ . ");
INSERT INTO aeu_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","وهَاذَا يْوَافِقْ كْلَامْ الأَنْبِيَاءْ كِيفْ مَا هُوَّ مَكْتُوبْ فِي الكْتُبْ المُقَدْسَةْ: ");
INSERT INTO aeu_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","\"بَعْدْ هَاذَا بِشْ نِرْجَعْ، ونِبْنِي خِيمِةْ دَاوِدْ الطَّايْحَة، نِبْنِي الِّي بْقَى مِنْهَا ونْوَقِّفْهَا مِنْ جْدِيدْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","بَاشْ هَكَّا، بْقِيِّةْ النَّاسْ يْنَجْمُوا يُطْلْبُوا الرَّبْ، وزَادَا الشُّعُوبْ الِّي مَاهُمْشْ يْهُودْ الِّي دْعِيتْهُمْ بَاشْ يِتْسَمَّاوْ بِاسْمِي، يْقُولْ الرَّبْ الِّي يَعْمِلْ الأُمُورْ هَاذِي، ");
INSERT INTO aeu_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ولِّي يَعْرَفْهَا مِنْ أَوِّلْ الدِّنْيَا\". ");
INSERT INTO aeu_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","«هَاذَاكَا عْلَاشْ نْرَى إِنُّو مَا لَازِمْنَاشْ نْثَقْلُوا عَالنَّاسْ الِّي رَجْعُوا لِلَّهْ مِلِّي مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","آمَا نِكْتْبُولْهُمْ ونْوَصِّيوْهُمْ بَاشْ مَا عَادِشْ يَاكْلُوا مِالذْبَايَحْ المَنْجُوسَة المَذْبُوحَة لِلأَصْنَامْ، وبَاشْ مَا عَادِشْ يَزْنَاوْ، ومَا عَادِشْ يَاكْلُوا لْحَمْ الحَيَوَانَاتْ المَخْنُوقَة، ولَا الدَّمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","عْلَى خَاطِرْ مِنْ قْدِيمْ الزْمَانْ مُوسَى كَانْ عَنْدُو نَاسْ تِشْهِدْلُو فِي كُلْ مْدِينَة، وشَرِيعْتُو تِتْقْرَى فِي المْعَابِدْ كُلْ نْهَارْ سِبْتْ». ");
INSERT INTO aeu_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","يَاخِي قَرْرُوا الرُّسُلْ والشْيُوخْ والنَّاسْ الكُلْ الِّي فِي الكْنِيسَة بَاشْ يِخْتَارُوا زُوزْ رْجَالْ مِالإِخْوَة ويَبْعْثُوهُمْ مْعَ بُولِسْ وبَرْنَابَا لْأَنْطَاكْيَة. وَلَّاوْ إِخْتَارُوا يَهُوذَا الِّي يْعَيْطُولُو بَارْسَابَا وسِيلَا، الِّي كَانُوا يِعْتَبْرُوهُمْ مِالقَادَة. ");
INSERT INTO aeu_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","وعْطَاوْهُمْ رِسَالَة مَكْتُوبْ فِيهَا: «مِنْ خْوَاتْكُمْ الرُّسُلْ والشْيُوخْ. «سَلَامْ لِلإِخْوَة المُؤْمْنِينْ الِّي مَاهُمْشْ يْهُودْ فِي أَنْطَاكْيَة وسُورْيَة وكِيلِيكِيَّة: ");
INSERT INTO aeu_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","«سْمَعْنَا الِّي فَمَّة نَاسْ جَاوْكُمْ مِنْ عَنْدْنَا مِنْ غِيرْ مَا فَوِّضْنَاهُمْ، وقَالُولْكُمْ كْلَامْ قَلَّقْكُمْ وخَلَّاكُمْ حَايْرِينْ، ");
INSERT INTO aeu_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","هَاذَاكَا عْلَاشْ تْفَاهِمْنَا بَاشْ نِخْتَارُوا زُوزْ رْجَالْ ونَبْعْثُوهُمْلْكُمْ مْعَ خْوَاتْنَا الِّي يْعِزُّوا عْلِينَا بَرْنَابَا وبُولِسْ، ");
INSERT INTO aeu_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","الِّي خَاطْرُوا بِحْيَاتْهُمْ بَاشْ يْبَشْرُوا بْإِسْمْ رَبْنَا يَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","وبْعَثْنَالْكُمْ يَهُوذَا وسِيلَا، بَاشْ تِسْمْعُوا مِنْهُمْ نَفْسْ الكْلَامْ الِّي كْتِبْنَاهُولْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","عْلَى خَاطِرْ بِالنِّسْبَة لِلرُّوحْ القُدُسْ وبِالنِّسْبَة لِينَا أَحْنَا زَادَا، مُشْ لَازِمْ نْثَقْلُوا عْلِيكُمْ بْأَكْثِرْ مِالحَاجَاتْ الِّي لَا بُدَّا مِنْهَا ولِّي هِيَّ: ");
INSERT INTO aeu_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","تْبَطْلُوا مَاكِلْةْ الذْبَايِحْ المَذْبُوحَة لِلصْنَبْ، والدَّمْ ولْحَمْ الحَيَوَانَاتْ المَخْنُوقَة والزْنَى. بَاهِي كَانْ تِبْعْدُوا عَالحَاجَاتْ هَاذِي. «وتَوَّا نْخَلِيوْكُمْ فِي وْدِيعِةْ رَبِّي». ");
INSERT INTO aeu_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ومْشَاوْ الِّي إِخْتَارُوهُمْ لْأَنْطَاكْيَة، وغَادِي لَمُّوا المُؤْمْنِينْ الكُلْ، وعْطَاوْهُمْ الرِّسَالَة. ");
INSERT INTO aeu_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","وكِي قْرَاوْهَا فَرْحُوا بَرْشَة عْلَى خَاطِرْ تْشَجْعُوا بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ويَهُوذَا وسِيلَا كَانُوا زَادَا أَنْبِيَاءْ، وقَالُوا بَرْشَة حَاجَاتْ شَجْعِتْ الإِخْوَة وقَوَّاتْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","وبَعْدْمَا قَعْدُوا مُدَّة غَادِي، سَلْمُوا عْلِيهُمْ الإِخْوَة وخَلَّاوْهُمْ يِرْجْعُوا لِلِّي بَعْثُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","آمَا سِيلَا حَبْ يِبْقَى غَادِي، ولَّى يَهُوذَا رْجَعْ وَحْدُو. ");
INSERT INTO aeu_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","وقَعْدُوا بُولِسْ وبَرْنَابَا مُدَّة فِي أَنْطَاكْيَة، يْعَلْمُوا ويْبَشْرُوا بْكِلْمِةْ الرَّبْ وكَانُوا مْعَاهُمْ بَرْشَة نَاسْ أُخْرِينْ يْعَاوْنُوا فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","وبَعْدْ أَيَّامَاتْ، قَالْ بُولِسْ لْبَرْنَابَا: «هَيَّا نِرْجْعُوا ونْزُورُوا الإِخْوَة فِي كُلْ مْدِينَة بَشِّرْنَا فِيهَا بْكِلْمِةْ الرَّبْ، ونِطْمَانُوا عْلِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","وحَبْ بَرْنَابَا يْهِزُّوا مْعَاهُمْ يُوحَنَّا الِّي يْعَيْطُولُو مُرْقُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","آمَا بُولِسْ مَا حَبِّشْ، عْلَى خَاطْرُو فِي بَمْفِيلِيَّة خَلَّاهُمْ، ومَا كَمَّلْشْ مْعَاهُمْ الخِدْمَة. ");
INSERT INTO aeu_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","وتْعَارْكُوا حَتَّى لِينْ تْفَارْقُوا عَالحْكَايَة هَاذِي، وَهَزْ بَرْنَابَا مُرْقُسْ مْعَاهْ وسَافْرُوا لْقُبْرُصْ عْلَى طْرِيقْ البْحَرْ . ");
INSERT INTO aeu_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","آمَا بُولِسْ اخْتَارْ سِيلَا. بَعْدْمَا الإِخْوَة سَلْمُوهْ فِي وْدِيعِةْ رَبِّي، ");
INSERT INTO aeu_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","سَافْرُوا فِي سُورْيَة وكِيلِيكِيَّة، يْشَجْعُوا فِي الكْنَايِسْ فِي كُلْ بْلَاصَة. ");
INSERT INTO aeu_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ووْصِلْ بُولِسْ لْدَرْبَة ولِسْتْرَة، وكَانْ فِيهَا تِلْمِيذْ إِسْمُو تِيمُوثَاوُسْ، أُمُّو كَانِتْ يْهُودِيَّة وأَمْنِتْ بِالمَسِيحْ وبُوهْ كَانْ يُونَانِي. ");
INSERT INTO aeu_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","وكَانِتْ عَنْدُو سُمْعَةْ بَاهْيَة عَنْدْ الإِخْوَة فِي إِيقُونْيَة ولِسْتْرَة. ");
INSERT INTO aeu_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","وحَبْ بُولِسْ يِهِزُّو مْعَاهْ. وَلَّى طَهَّرْلُو، عْلَى خَاطِرْ اليْهُودْ الِّي سَاكْنِينْ غَادِي، يَعْرْفُوا الِّي بُوهْ يُونَانِي. ");
INSERT INTO aeu_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ومْشَاوْ بُولِسْ وصْحَابُو مِنْ بْلَادْ لِبْلَادْ يْوَصْلُوا فِي القَرَارَاتْ الِّي خْذَاوْهُمْ الرُّسُلْ والشْيُوخْ فِي أُورْشَلِيمْ لِلْمُؤْمْنِينْ بَاشْ يْطَبْقُوهَا. ");
INSERT INTO aeu_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","وكَانِتْ الكْنَايِسْ تِتْقَوَّى فِي الإِيمَانْ، وعْدَدْ المُؤْمْنِينْ يْزِيدْ نْهَارْ بَعْدْ نْهَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","بَعْدْمَا مْنَعْهُمْ الرُّوحْ القُدُسْ بَاشْ يْبَشْرُوا فِي آسِيَّا، تْعَدَّاوْ لْمَنَاطِقْ فَرِيجِيَّة وغَلَاطْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","وكِي وُصْلُوا لِحْدُودْ مْدِينِةْ مِيسِيَّا، حَاوْلُوا بَاشْ يُدْخْلُوا لْمَنْطَقْةْ بِثِينِيَّة، آمَا رُوحْ يَسُوعْ مَا خَلَّاهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","وَلَّاوْ تْعَدَّاوْ عْلَى مِيسِيَّة ومْشَاوْ لِمْدِينِةْ تَرُوَاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","وفِي اللِّيلَة هَاذِيكَا شَافْ بُولِسْ فِي رُؤْيَا، رَاجِلْ مِنْ مَقْدُونِيَّة يِتْشَحِّتْ فِيهْ ويْقُولْ: «تْعَدَّى لْمَقْدُونِيَّة وعَاوِنَّا!». ");
INSERT INTO aeu_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","وَقْتْهَا تْأَكِّدْنَا الِّي اللَّهْ يْحِبْنَا نْبَشْرُوا بِالبْشَارَة فِي مَقْدُونِيَّة. يَاخِي مْشِينَالْهَا بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","وسَافِرْنَا مِنْ بُرْطْ تَرُوَاسْ لْجَزِيرِةْ سَامُوثْرَاكِي. ومِنْ غُدْوَة كَمِّلْنَا سْفَرْنَا لِمْدِينِةْ نِيَاۑُولِيسْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ومِنْ غَادِي مْشِينَا لْفِيلِۑِّي، وهِيَّ أَكْبِرْ مْدِينَة إِسْتَعْمْرُوهَا الرُّومَانْ فِي وِلَايِةْ مَقْدُونِيَّة. وقْعَدْنَا فِيهَا أَيَّامَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ونْهَارْ السِّبْتْ خْرَجْنَا مِنْ بَابْ المْدِينَة ومْشِينَا لِبْلَاصَة قْرِيبْ الوَادْ، كَانُوا اليْهُودْ مِسْتَانْسِينْ يْصَلِّيوْ فِيهَا. يَاخِي قْعَدْنَا نِتْكَلْمُوا مْعَ النْسَاء المَلْمُومِينْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","وكَانِتْ بِينَاتْهُمْ مْرَا تَقِيَّة اسْمْهَا لِيدِيَّة مِنْ مْدِينِةْ ثِيَاتِيرَا، اتَّاجِرْ فِي القْمَاشَاتْ الغَالْيَة. وَقْتِلِّي كَانِتْ تِسْمَعْ فِي بُولِسْ، اللَّهْ حَلْ قَلْبْهَا بَاشْ تِقْبِلْ كْلَامُو، ");
INSERT INTO aeu_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","وكِي تَعَمْدِتْ هِيَّ وعَايْلِتْهَا، شَدِّتْ فِينَا صْحِيحْ وقَالْتِلْنَا: «إِذَا كَانْ تِعْتَبْرُونِي مُؤْمْنَة بِالرَّبْ، إِيجَاوْ لْدَارِي وأُقْعْدُوا عَنْدِي». ولَزْمِتْ عْلِينَا. ");
INSERT INTO aeu_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","وفِي نْهَارْ مِنْ النْهَارَاتْ كُنَّا مَاشِينْ نْصَلِّيوْ، عُرْضِتْنَا خْدِيمَة سَاكِنْهَا رُوحْ يْخَلِّيهَا تْنَجِّمْ ادَّڨِّزْ. وكَانِتْ بِالدْڨَازَة هَاذِي تْجِيبْ لَسْيَادْهَا بَرْشَة فْلُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","يَاخِي بْدَاتْ اتَّبَّعْ فِينَا وفِي بُولِسْ وتْصِيحْ: «النَّاسْ هَاذُمْ يِخْدْمُوا فِي اللَّهْ العَالِي، ويْخَبْرُوا فِيكُمْ عْلَى طْرِيقْ النْجَاةْ!». ");
INSERT INTO aeu_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","وقَعْدِتْ بَرْشَة أَيَّامَاتْ وهِيَّ تَعْمِلْ فِي نَفْسْ الحَاجَة حَتَّى لِينْ بُولِسْ تْقَلَّقْ، يَاخِي تْلَفِّتْ وقَالْ لِلرُّوحْ: «نُأْمْرِكْ بْإِسْمْ يَسُوعْ المَسِيحْ بَاشْ تُخْرُجْ مِنْهَا». وبِالوَقْتْ خْرَجْ مِنْهَا. ");
INSERT INTO aeu_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","وَقْتِلِّي أَسْيَادْهَا شَافُوا الِّي بَابْ رِزْقْهُمْ تْسَكِّرْ، شَدُّوا بُولِسْ وسِيلَا، وكَرْكْرُوهُمْ لْسَاحِةْ المْدِينَة بَاشْ يْحَاكْمُوهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","وَقْفُوهُمْ قُدَّامْ الحُكَّامْ وقَالُوا: «الرْجَالْ هَاذُومَا الزُّوزْ يَعْمْلُوا فِي بَلْبْلَةْ فِي البْلَادْ، وهُومَا يْهُودْ ");
INSERT INTO aeu_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","يْحِبُّوا يْدَخْلُولْنَا عَادَاتْ أَحْنَا الرُّومَانِيِّينْ مَمْنُوعْ عْلِينَا نِقْبْلُوهَا وَلَّا نَعْمْلُوهَا». ");
INSERT INTO aeu_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","يَاخِي هَاجُوا عْلِيهُمْ النَّاسْ، والحُكَّامْ عْطَاوْ أَمْرْ بَاشْ يْقَطْعُولْهُمْ حْوَايِجْهُمْ، ويَضْرْبُوهُمْ بِالعْصِيْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","وبَعْدْمَا ضَرْبُوهُمْ بَرْشَة، رْمَاوْهُمْ فِي الحَبْسْ، ووَصَّاوْ السَّجَّانْ بَاشْ يْعِسْ عْلِيهُمْ بِالڨْدَا. ");
INSERT INTO aeu_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","وبَاشْ يَعْمِلْ الِّي وَصَّاوَهْ عْلِيهْ، حَطْهُمْ فِي الحَبْسْ الدَّخْلَانِي، ورَبْطِّلْهُمْ سَاقِيهُمْ فِي قَالِبْ لُوحْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ومْعَ نُصْفْ اللِّيلْ، كَانُوا بُولِسْ وسِيلَا يْصَلِّيوْ ويْسَبْحُوا فِي اللَّهْ بِالتَّرَانِيمْ، والمَرْبُوطِينْ الأُخْرِينْ يِسْمْعُوا فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","وإِذَا بِيهْ زِلْزَالْ قْوِيْ زَعْزَعْ سِيسَانْ الحَبْسْ، وبِالوَقْتْ تْحَلِّتْ البِيبَانْ وتْخَلْعِتْ سْلَاسِلْ المْرَابِيطْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","وقَامْ السَّجَّانْ مِالنُّومْ، وشَافْ بِيبَانْ الحَبْسْ مَحْلُولَة، يَاخِي جْبِدْ سِيفُو بَاشْ يُقْتُلْ رُوحُو عْلَى خَاطِرْ مْشَى فِي بَالُو الِّي المْرَابِيطْ هَرْبُوا. ");
INSERT INTO aeu_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","آمَا بُولِسْ عَيِّطْ عْلَى طُولْ صُوتُو: «رُدْ بَالِكْ تْضُرْ رُوحِكْ! أَحْنَا الكُلْ هْنَا». ");
INSERT INTO aeu_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","وطْلَبْ السَّجَّانْ يْجِيبُولُو ضَوْ، ودْخَلْ يِجْرِي لْدَاخِلْ وهُوَّ يُرْعِشْ بِالخُوفْ، وتِرْمَى عَنْدْ سَاقِينْ بُولِسْ وسِيلَا. ");
INSERT INTO aeu_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","مْبَعِّدْ خَرِّجْهُمْ لْبَرَّة وسْإِلْهُمْ: «يَا سْيَادِي، آشْ لَازِمْنِي نَعْمِلْ بَاشْ نِنْجَى؟». ");
INSERT INTO aeu_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","جَاوْبُوهْ: «أَمِّنْ بِالرَّبْ يَسُوعْ، تَوْ تِنْجَى إِنْتِ وعَايِلْتِكْ». ");
INSERT INTO aeu_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","وبَشْرُوهْ هُوَّ وعَايِلْتُو الكُلْ بْكِلْمِةْ الرَّبْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","وفِي نَفْسْ اللَّحْظَة فِي اللِّيلَة هَاذِيكَا بِيدْهَا هَزْهُمْ ونَظْفِلْهُمْ جْرُوحْهُمْ وبِالوَقْتْ تْعَمِّدْ هُوَّ وعَايِلْتُو الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","وبَعْدْ هَزْهُمْ لْدَارُو، وحَطِّلْهُمْ المَاكْلَة، وفْرَحْ مْعَ عَايِلْتُو الكُلْ، عْلَى خَاطْرُو أَمَّنْ بِاللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ووَقْتِلِّي طْلَعْ النْهَارْ، بَعْثُوا الحُكَّامْ مَجْمُوعَة مِالحَرَسْ بَاشْ يْقُولُوا لِلْسَّجَّانْ: «سَيِّبْ الزُّوزْ رْجَالْ». ");
INSERT INTO aeu_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","وعَاوِدْ السَّجَّانْ كْلَامْهُمْ لْبُولِسْ وقَالُّو: «الحُكَّامْ أَمْرُونِي بَاشْ نْسَيِّبْكُمْ، أُخْرْجُوا تَوَّا وإِمْشِيوْ فِي آمَانْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","آمَا بُولِسْ قَالِلْهُمْ: «كِيفَاشْ! ضَرْبُونَا قُدَّامْ النَّاسْ مِنْ غِيرْ مَا يْحَاكْمُونَا ورْمَاوْنَا فِي الحَبْسْ رَغْمِلِّي عَنْدْنَا الجِنْسِيَّة الرُّومَانِيَّة، وتَوَّا يْحِبُّوا يْسَيْبُونَا بِالسِّرْقَة. لَا! لَازِمْ يْجِيوْ هُومَا بِيدْهُمْ ويْسَيْبُونَا!». ");
INSERT INTO aeu_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","وَصّْلُوا الحَرَسْ كْلَامْهُمْ لِلحُكَّامْ. وَقْتِلِّي سَمْعُوا الِّي هُومَا رُومَانْ خَافُوا، ");
INSERT INTO aeu_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","يَاخِي جَاوْ وطَلْبُوا مِنْهُمْ السْمَاحْ وسَيْبُوهُمْ، وطَلْبُوا مِنْهُمْ يُخْرْجُوا مِالمْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","وكِي خْرَجْ بُولِسْ وسِيلَا مِالحَبْسْ، مْشَاوْ لْدَارْ لِيدِيَّة، وغَادِي قَابْلُوا الإِخْوَة وشَجْعُوهُمْ. ومْبَعِّدْ مْشَاوْ عْلَى رْوَاحْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","وبَعْدْمَا تْعَدَّاوْ عْلَى مُدُنْ أَمْفِيۑُولِيسْ وأَۑُولُونِيَّة، وُصْلُوا لِمْدِينِةْ تْسَالُونِيكِي. وكَانْ فِيهَا مَعْبِدْ لِلْيْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","وكِيمَا عَادْتُو، دْخَلْ بُولِسْ لِلمَعْبِدْ وقْعَدْ يْنَاقِشْ فِيهُمْ مِالكْتُبْ المُقَدْسَةْ لْمُدِّةْ ثْلَاثَة أَسْبَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","وفَسْرِلْهُمْ ووَرَّاهُمْ الِّي المَسِيحْ كَانْ لَازْمُو يْمُوتْ ويْقُومْ مِنْ بِينْ المُوتَى، وقَالِلْهُمْ: «يَسُوعْ الِّي آنَا تَوَّا قَاعِدْ نْبَشِّرْ فِيكُمْ بِيهْ هُوَّ المَسِيحْ». ");
INSERT INTO aeu_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","يَاخِي اقْتَنْعُوا جْمَاعَة مِنْهُمْ ووَلَّاوْ مْعَ بُولِسْ وسِيلَا، ومْعَاهُمْ بَرْشَة يُونَانِيِّينْ مِلِّي يِعْبْدُوا فِي رَبِّي، وبَرْشَة نْسَاء مِنْ أَعْيَانْ البْلَادْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","يَاخِي اليْهُودْ كْلَاتْهُمْ الغِيرَة، وَلَّاوْ لَمُّوا نَاسْ أَشْرَارْ مِنْ وْلَادْ الشَّارِعْ وكَوْنُوا عِصَابَة وعَمْلُوا خُوضَة فِي البْلَادْ، ومْبَعِّدْ هِجْمُوا عْلَى دَارْ يَاسُونْ، يْلَوْجُوا عْلَى بُولِسْ وسِيلَا بَاشْ يْخَرْجُوهُمْ لِلشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","وكِي مَا لْقَاوْهُمْشْ جَابُوا يَاسُونْ وجْمَاعَة مِالإِخْوَة وهَزُّوهُمْ لْحُكَّامْ المْدِينَة، وهُومَا يْصِيحُوا: «النَّاسْ هَاذُمْ هُومَا الِّي قِلْبُوا الدِّنْيَا الكُلْ، وهَاهُمْ جَاوْ لِمْدِينِتْنَا أَحْنَا زَادَا. ");
INSERT INTO aeu_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ويَاسُونْ مْضَيِّفْهُمْ فِي دَارُو. والكُلْهُمْ قَاعْدِينْ يْخَالْفُوا فِي أَوَامِرْ القَيْصِرْ، ويْقُولُوا الِّي فَمَّة مَلِكْ آخِرْ إِسْمُو يَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","يَاخِي تْقَلْقُوا النَّاسْ والحُكَّامْ كِي سَمْعُوا الكْلَامْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ومَا سَيْبُوا يَاسُونْ وبْقِيِّة الإِخْوَة كَانْ مَا خْذَاوْ كَفَالَة. ");
INSERT INTO aeu_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","وبِالوَقْتْ، دُوبْ مَا طَاحْ اللِّيلْ، بَعْثُوا الإِخْوَة بُولِسْ وسِيلَا لِمْدِينِةْ بِيرِيَّة. وَقْتِلِّي وُصْلُوا، مْشَاوْ لْمَعْبِدْ اليْهُودْ الِّي فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ويْهُودْ بِيرِيَّة كَانُوا مِتْجَاوْبِينْ أَكْثِرْ مِنْ يْهُودْ تْسَالُونِيكِي، وقِبْلُوا كِلْمِةْ الرَّبْ بْحَمَاسْ، وكَانُوا يَقْرَاوْ فِي الكْتُبْ المُقَدْسَة كُلْ يُومْ بَاشْ يِتْأَكْدُوا إِنُّو التَّعْلِيمْ الِّي كَانُوا يِسْمْعُوا فِيهْ صْحِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","هَاذَاكَا عْلَاشْ أَمْنُوا بَرْشَة يْهُودْ، وبَرْشَة يُونَانِيِّينْ، مِنْهُمْ نْسَاء مِنْ أَعْيَانْ البْلَادْ ومِنْهُمْ رْجَالْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","وكِي عَرْفُوا اليْهُودْ الِّي فِي تْسَالُونِيكِي الِّي بُولِسْ يْبَشِّرْ بْكِلْمِةْ اللَّهْ فِي بِيرِيَّة، خَلْطُوا وْرَاهْ، وبْدَاوْ يْهَيْجُوا عْلِيهْ فِي النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","يَاخِي بِالوَقْتْ بَعْثُوا الإِخْوَة بُولِسْ لِلبْحَرْ بَاشْ يْسَافِرْ، وبْقَاوْ سِيلَا وتِيمُوثَاوُسْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","والمُؤْمْنِينْ الِّي مْشَاوْ مْعَ بُولِسْ وَصْلُوهْ لْأَثِينَا، ورَجْعُوا بَعْدْمَا وَصَّاهُمْ بُولِسْ بَاشْ يَبْعْثُولُو سِيلَا وتِيمُوثَاوُسْ فِي أَقْرِبْ وَقْتْ مُمْكِنْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","وَقْتِلِّي بُولِسْ كَانْ يِسْتَنَّى فِيهُمْ فِي أَثِينَا، شَافْ الِّي المْدِينَة مِلْيَانَة بِالأَصْنَامْ. يَاخِي تْقَلَّقْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","وبْدَا يْنَاقِشْ فِي النَّاسْ الِّي يِعْبْدُوا رَبِّي فِي المَعْبِدْ مِاليْهُودْ وغِيرْهُمْ، ويْنَاقِشْ زَادَا فِي النَّاسْ الِّي يُعْرْضُوهْ كُلْ يُومْ فِي السُّوقْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","وصَارْ نِقَاشْ مْعَ الفَلَاسْفَة الأَبِيقُورِيِّينْ والرِّوَاقِيِّينْ، يَاخِي جْمَاعَة مِنْهُمْ قَالُوا: «آشْ يْحِبْ يْقُولْ هَلِّي يَحْكِي بَرْشَة؟». أُخْرِينْ قَالُوا: «ظَاهِرْ إِنُّو يَحْكِي عْلَى آلْهَة غْرِيبَة»، عْلَى خَاطِرْ بُولِسْ كَانْ يْبَشِّرْ بْيَسُوعْ والقْيَامَة مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","يَاخِي هَزُّوهْ لْمَجْلِسْ المْدِينَة الِّي يِتْسَمَّى الأَرْيُوبَاغُوسْ وقَالُولُو: «نْحِبُّوا نَعْرْفُوا التَّعْلِيمْ الجْدِيدْ الِّي تَحْكِي عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","أَحْنَا قَاعْدِينْ نِسْمْعُوا فِي كْلَامْ غْرِيبْ، ونْحِبُّوا نَعْرْفُوا آشْ مَعْنَاهْ». ");
INSERT INTO aeu_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","وكَانُوا أَهْلْ أَثِينَا والبْرَايْنِيَّة السَّاكْنِينْ فِيهَا يْعَدِّيوْ مُعْظِمْ وَقْتْهُمْ يِتْنَاقْشُوا فِي الأَفْكَارْ الجْدِيدَة. ");
INSERT INTO aeu_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ووْقِفْ بُولِسْ فِي وُسْطْ المَجْلِسْ وقَالْ: «يَا أَهْلْ أَثِينَا، ظَاهِرْينْ الِّي إِنْتُومَا مِدَّيْنِينْ بَرْشَة، وفِي كُلْ شَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","عْلَى خَاطِرْ وَقْتِلِّي كُنْتْ نْدُورْ فِي مْدِينِتْكُمْ ونُخْزُرْ لِلْمْعَابِدْ مْتَاعْكُمْ، لْقِيتْ مَذْبَحْ مَكْتُوبْ عْلِيهْ: \"لِلإِلَاهْ المَجْهُولْ\". وآنَا رَانِي قَاعِدْ نْبَشِّرْ فِيكُمْ بِالإِلَاهْ المَجْهُولْ هَاذَا الِّي تِعْبْدُوا فِيهْ مِنْ غِيرْ مَا تَعْرْفُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","اللَّهْ الِّي خْلَقْ العَالِمْ وكُلْ مَا فِيهْ، رَبْ السْمَاء والأَرْضْ، الِّي مَا يُسْكُنْشْ فِي مَعَابِدْ بْنَاوْهَا البَشَرْ، ");
INSERT INTO aeu_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","مَا يِسْتْحَقِّشْ لِلنَّاسْ بَاشْ تِخْدْمُو، عْلَى خَاطْرُو هُوَّ الِّي يَعْطِيهُمْ الكُلْ الحَيَاةْ والنْفَسْ ويَعْطِيهُمْ كُلْ شَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","خْلَقْ الشُّعُوبْ الكُلْ مِنْ إِنْسَانْ وَاحِدْ، بَاشْ يُسْكْنُوا فِي الأَرْضْ الكُلْ، وحَدِدِّلْهُمْ مِنْ قَبْلْ مُدِّةْ وُجُودْهُمْ والبْلَايِصْ الِّي بِشْ يْعِيشُوا فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","عْلَى خَاطْرُو يْحِبْهُمْ يْلَوْجُوا عْلِيهْ، فَمَّاشْ مَا يِتَهْدَاوْ ويَلْقَاوَهْ، رَغْمِلِّي هُوَّ مُشْ بْعِيدْ عْلَى كُلْ وَاحِدْ فِينَا. ");
INSERT INTO aeu_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","رَانَا نَحْيَاوْ ونِتْحَرْكُوا ونِتْوِجْدُوا بِيهْ هُوَّ. وكِيمَا قَالْ وَاحِدْ مِنْ شُعَرَاءْكُمْ: \"أَحْنَا زَادَا ذُرِّيتُو\". ");
INSERT INTO aeu_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","«ومَادَامْنَا ذُرِّيِّةْ اللَّهْ، مَالَا مَا يِلْزِمْنَاشْ نْفَكْرُوا الِّي الإِلَاهْ هُوَّ صَنْبَة مِالذْهَبْ وَلَّا مِالفِضَّة وَلَّا مِالحْجَرْ يَصْنَعْهَا الإِنْسَانْ كِيفْ مَا يْحِبْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","وإِذَا كَانْ اللَّهْ عَدَّى أَيَّامَاتْ الجَهْلْ الِّي فَاتِتْ، رَاهُو اليُومْ يُأْمُرْ النَّاسْ الكُلْ فِي كُلْ بْلَاصَة بَاشْ يْتُوبُوا. ");
INSERT INTO aeu_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","عْلَى خَاطْرُو حَدِّدْ نْهَارْ بَاشْ يْحَاسِبْ فِيهْ العَالِمْ بِالعَدْلْ عْلَى يِدْ رَاجِلْ إِخْتَارُو، وبَيِّنْ لِلنَّاسْ الِّي هُوَّ إِخْتَارُو كِي قَوْمُو مِالمُوتْ». ");
INSERT INTO aeu_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","كِي سَمْعُوهْ يَحْكِي عَالقْيَامِة مِالمُوتْ، فَمَّة شْكُونْ مِنْهُمْ بْدَاوْ يِتْمَسْخْرُوا. آمَا فَمَّة نَاسْ أُخْرِينْ قَالُولُو: «مَذَابِينَا كَانْ تْزِيدْ تَحْكِيلْنَا عَالمَوْضُوعْ هَاذَا مَرَّة أُخْرَى». ");
INSERT INTO aeu_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","وَلَّى خْرَجْ بُولِسْ مِنْ بَحْذَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","آمَا فَمَّة جْمَاعَة مِنْهُمْ وَلَّاوْ مْعَاهْ وأَمْنُوا، مِنْهُمْ دْيُونِيسْيُوسْ الِّي كَانْ عُضُوْ فِي مَجْلِسْ المْدِينَة، ومْرَا إِسْمْهَا دَامَارِيسْ، وبَرْشَة نَاسْ أُخْرِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","وبَعْدْ هَاذَا، سَافِرْ بُولِسْ مِنْ أَثِينَا لِمْدِينِةْ كُورِنْثُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","وقَابِلْ يْهُودِي إِسْمُو أَكِيلَا، مَوْلُودْ فِي مَنْطَقْةْ بُنْطُسْ، مَزَّالْ كِي جَاء مِنْ إِيطَالْيَا مْعَ مَرْتُو بْرِيسْكِلَّا، عْلَى خَاطِرْ القَيْصِرْ كْلُودْيُوسْ طَرِّدْ اليْهُودْ الكُلْ مِنْ رُومَا. يَاخِي مْشَى بُولِسْ يْشُوفْ فِيهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","وعْلَى خَاطِرْهُمْ كَانُوا يَصْنْعُوا فِي الخْيِمْ كِيفُو، قْعَدْ عَنْدْهُمْ وخْدِمْ مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","وكَانْ كُلْ نْهَارْ سِبْتْ يِتْنَاقِشْ مْعَ النَّاسْ الِّي يْجِيوْ لِلمَعْبِدْ، ويْحَاوِلْ يَقْنَعْ اليْهُودْ ولِّي مُشْ يْهُودْ . ");
INSERT INTO aeu_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ووَقْتِلِّي وُصْلُوا سِيلَا وتِيمُوثَاوُسْ مِنْ مَقْدُونِيَّة، خَصِّصْ بُولِسْ وَقْتُو الكُلْ لِلتَّبْشِيرْ، وكَانْ يِشْهِدْ لِلْيْهُودْ الِّي يَسُوعْ هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","آمَا هُومَا عَارْضُوهْ وبْدَاوْا يْسِبُّوا فِيهْ، يَاخِي نْفَضْ حْوَايْجُو وقَالِلْهُمْ: «ذَنْبْكُمْ فِي رَقْبِتْكُمْ، آنَا بَرِيءْ مِنْكُمْ. ومِنْ تَوَّا بِشْ نِمْشِي لِلِّي مَاهُمْشْ يْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ومْشَى مِنْ غَادِي لْدَارْ رَاجِلْ مُشْ يْهُودِي يِعْبِدْ فِي اللَّهْ، إِسْمُو تِيطُسْ يُوسْتُسْ. دَارُو كَانِتْ لَاصْقَة المَعْبِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","وأَمِّنْ كْرِيسْبُسْ رَئِيسْ المَعْبِدْ بِالرَّبْ هُوَّ وعَايِلْتُو الكُلْ، وبَرْشَة مِنْ أَهْلْ كُورِنْثُوسْ الِّي سَمْعُوا تَبْشِيرْ بُولِسْ أَمْنُوا وتْعَمْدُوا. ");
INSERT INTO aeu_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","وفِي لِيلَة مِاليَالِي، قَالْ الرَّبْ لْبُولِسْ فِي رُؤْيَا: «مَا تْخَافِشْ! تْكَلِّمْ ومَا تُسْكُتْشْ، ");
INSERT INTO aeu_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","آنَا مْعَاكْ وحَتَّى حَدْ مَا يْنَجِّمْ يْضُرِّكْ، عْلَى خَاطِرْ عَنْدِي بَرْشَة نَاسْ فِي المْدِينَة هَاذِي هُومَا شَعْبِي». ");
INSERT INTO aeu_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","وقْعَدْ بُولِسْ فِي كُورِنْثُوسْ عَامْ وسِتَّة شْهُرْ يْعَلِّمْ فِي النَّاسْ كِلْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","وَقْتِلِّي كَانْ غَالْيُونْ حَاكِمْ عْلَى مَنْطَقْةْ أَخَائِيَة، لَمُّوا اليْهُودْ بْعَضْهُمْ وهِجْمُوا عْلَى بُولِسْ وهَزُّوهْ لِلمَحْكْمَة ");
INSERT INTO aeu_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","وقَالُوا: «الرَّاجِلْ هَاذَا يَقْنَعْ فِي النَّاسْ بَاشْ يِعْبْدُوا اللَّهْ بْطَرِيقَة تْخَالِفْ شَرِيعِتْنَا». ");
INSERT INTO aeu_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","وَقْتِلِّي جَاء بُولِسْ بَاشْ يِتْكَلِّمْ، قَالْ غَالْيُونْ لِلْيْهُودْ: «يَا يْهُودْ، كَانْ جَاتْ القَضِيَّة هَاذِي فِيهَا جْرِيمَة وَلَّا ذَنْبْ، رَانِي بِالحَقْ سْمَعْتْ شْكَايِتْكُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","آمَا مَادَامْهَا قَضِيِّةْ كِلْمَاتْ وأَسَامِي وحَاجَاتْ تْخُصْ شَرِيعِتْكُمْ، مَا عْلِيكُمْ كَانْ تْحِلُّوهَا مَا بِينَاتْكُمْ. آنَا مَا نْحِبِّشْ نُحْكُمْ فِي القَضَايَا هَاذُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","وطَرِّدْهُمْ مِالمَحْكْمَة. ");
INSERT INTO aeu_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","يَاخِي هَزُّوا سُوسْتَانِيسْ رَئِيسْ المَعْبِدْ، وضَرْبُوهْ قُدَّامْ المَحْكْمَة، وغَالْيُونْ مَا عَبَّرْهُمْشْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","وقْعَدْ بُولِسْ فِي كُورِنْثُوسْ مُدَّة طْوِيلَة. ومِنْ بَعْدْهَا وَدَّعْ الإِخْوَة وسَافِرْ لْسُورْيَة عْلَى طْرِيقْ البْحَرْ ومْعَاهْ بْرِيسْكِيلَا وأَكِيلَا، بَعْدْمَا حَجِّمْ شَعْرُو فِي مْدِينِةْ كَنْخَرِيَّة عْلَى خَاطْرُو كَانْ وَاعِدْ وَعْدَة لْرَبِّي. ");
INSERT INTO aeu_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","وَقْتِلِّي وُصْلُوا لْأَفَسُسْ خَلَّاهُمْ بُولِسْ غَادِي، ودْخَلْ لِلمَعْبِدْ يْنَاقِشْ فِي اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","يَاخِي طَلْبُوا مِنُّو بَاشْ يُقْعُدْ مْعَاهُمْ مُدَّة أَطْوِلْ، آمَا هُوَّ مَا قْبِلْشْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ووَقْتِلِّي وَدَّعْهُمْ قَالِلْهُمْ: « تَوَّا نَرْجْعِلْكُمْ كَانْ حَبْ رَبِّي». ومْبَعِّدْ سَافِرْ مِنْ مْدِينِةْ أَفَسُسْ عْلَى طْرِيقْ البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","وْصُلْ لْبُرْطْ قَيْصَرِيَّة وطْلَعْ سَلِّمْ عَالكْنِيسَة فِي أُورْشَلِيمْ، مْبَعِّدْ مْشَى لْأَنْطَاكْيَة. ");
INSERT INTO aeu_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","وبَعْدْمَا عَدَّى فِيهَا مُدَّة، سَافِرْ لْمَنَاطِقْ غَلَاطْيَة وفَرِيجِيَّة، ودَارْهُمْ بْلَاصَة بْلَاصَة وهُوَّ يْقَوِّي ويْشَجَّعْ فِي التْلَامْذَة الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","وجَاء لْأَفَسُسْ رَاجِلْ يْهُودِي إِسْمُو أَبُلُّوسْ، أَصْلُو مِنْ مْدِينِةْ الإِسْكَنْدَرِيَّة، يَعْرِفْ يِتْكَلَّمْ، ويَعْرِفْ الكْتُبْ المُقَدْسَةْ بِالڨْدَا. ");
INSERT INTO aeu_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","وكَانْ مِتْمَكِّنْ مِنْ تَعْلِيمْ المَذْهَبْ الِّي يْسَمِّيوِهْ طْرِيقْ الرَّبْ، وكَانْ يِتْكَلِّمْ بْحَمَاسْ كْبِيرْ، وِيْعَلِّمْ فِي تَعْلِيمْ صْحِيحْ عْلَى يَسُوعْ، آمَا مَا كَانْ يَعْرِفْ كَانْ مَعْمُودِيَّةْ يُوحَنَّا. ");
INSERT INTO aeu_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","وبْدَا يِتْكَلِّمْ بْشَجَاعَة وثِيقَةْ فِي المَعْبِدْ. آمَا كِي سَمْعُوهْ أَكِيلَا وبْرِيسْكِلَّا، هَزُّوهْ لْدَارْهُمْ، وزَادُوا فَسْرُولُو ووَضْحُولُو تَعْلِيمْ اللَّهْ أَكْثِرْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","وقَرِّرْ أَبُلُّوسْ يْسَافِرْ لْأَخَائِيَة، يَاخِي شَجْعُوهْ الإِخْوَة وكِتْبُوا لِلتْلَامْذَة الِّي غَادِي بَاشْ يِسْتَقْبْلُوهْ بِالڨْدَا. ووَقْتِلِّي وْصُلْ، عَاوِنْ بَرْشَة الِّي وَلَّاوْ مُؤْمْنِينْ عْلَى خَاطِرْ نِعْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","عْلَى خَاطْرُو كَانْ يْسَكِّتْ اليْهُودْ بْقُوِّةْ الحُجَجْ مْتَاعُو قُدَّامْ النَّاسْ الكُلْ ويْبَيْنِلْهُمْ مِالكْتُبْ المُقَدْسَةْ الِّي يَسُوعْ هُوَّ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","وَقْتِلِّي أَبُلُّوسْ كَانْ فِي كُورِنْثُوسْ، سَافِرْ بُولِسْ عْلَى طْرِيقْ البَرْ فِي المَنَاطِقْ العَالْيَة حَتَّى وْصُلْ لْأَفَسُسْ. وغَادِي لْقَى شْوَيَّة تْلَامْذَة. ");
INSERT INTO aeu_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","سْإِلْهُمْ: «يَاخِي خْذِيتُوا الرُّوحْ القُدُسْ وَقْتِلِّي أَمَّنْتُوا؟». جَاوْبُوهْ: «لَا! ولَا حَتَّى سْمَعْنَا إِنُّو الرُّوحْ القُدُسْ مَوْجُودْ». ");
INSERT INTO aeu_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","يَاخِي سْإِلْهُمْ: «مَالَا بَانَا مَعْمُودِيَّة تْعَمَّدْتُوا؟». جَاوْبُوا: «بْمَعْمُودِيِّةْ يُوحَنَّا». ");
INSERT INTO aeu_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","قَالْ بُولِسْ: «مَعْمُودِيِّةْ يُوحَنَّا كَانِتْ لِلتُّوبَة، وهُوَّ كَانْ يِدْعِي الشَّعْبْ بَاشْ يَمْنُوا بِلِّي يْجِي بَعْدُو، يَعْنِي بْيَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","وكِي سَمْعُوا الكْلَامْ هَاذَا، تْعَمْدُوا بْإِسْمْ الرَّبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ووَقْتِلِّي حَطْ بُولِسْ عْلِيهُمْ يْدِيهْ، هْبَطْ عْلِيهُمْ الرُّوحْ القُدُسْ، وبْدَاوْ يِتْكَلْمُوا بْلُوغَاتْ أُخْرَى ويِتْنَبْؤُوا. ");
INSERT INTO aeu_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","وكَانُوا قْرَابِةْ أَثْنَاشِنْ رَاجِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","وقْعَدْ بُولِسْ يِمْشِي لْمَعْبِدْ اليْهُودْ لْمُدِّةْ ثْلَاثَة شْهُرْ، وكَانْ يِتْكَلِّمْ جْهَارْ عْلَى مَمْلِكْةْ اللَّهْ، ويْنَاقِشْ فِي الحَاضْرِينْ ويْحَاوِلْ يَقْنَعْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","آمَا فَمَّة الِّي عَانْدُوا ومَا حَبُّوشْ يَمْنُوا، وبْدَاوْ يْسِبُّوا فِي المَذْهَبْ الِّي يِتْسَمَّى طْرِيقْ الرَّبْ قُدَّامْ النَّاسْ الكُلْ. يَاخِي خَلَّاهُمْ بُولِسْ وهَزْ التْلَامْذَة وَحَّدْهُمْ، وبْدَا يِتْنَاقِشْ مْعَاهُمْ ويْعَلِّمْ فِيهُمْ كُلْ يُومْ، فِي مَدْرَسْةْ وَاحِدْ إِسْمُو تِيرَانُّوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ودَاوِمْ عْلَى هَاذَا لْمُدِّةْ عَامِينْ، حَتَّى وِصْلِتْ كِلْمِةْ الرَّبْ لِلْيْهُودْ ولِلِّي مُشْ يْهُودْ الكُلْ الِّي يُسْكْنُوا فِي آسِيَّا. ");
INSERT INTO aeu_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","وكَانْ اللَّهْ يَعْمِلْ فِي مُعْجْزَاتْ كْبِيرَة عْلَى يْدِينْ بُولِسْ، ");
INSERT INTO aeu_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","حَتَّى وَلَّاوْ النَّاسْ يْهِزُّوا المْنَادِلْ والفْوُطْ الِّي مَسُّوا بْدَنْ بُولِسْ، ويْحُطُّوهُمْ عَالمُرْضَى، والمُرْضَى يَبْرَاوْ وتُخْرُجْ مِنْهُمْ الأَرْوَاحْ الشِّرِّيرَة. ");
INSERT INTO aeu_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","وكَانْ فَمَّة يْهُودْ رَحَّالَة خِدْمِتْهُمْ تَخْرِيجْ الأَرْوَاحْ الشِّرِّيرَة، حَاوْلُوا يِسْتَعْمْلُوا إِسْمْ الرَّبْ يَسُوعْ بَاشْ يِطَرْدُوهَا. كَانُوا يْقُولُوا لِلأَرْوَاحْ: «بْإِسْمْ يَسُوعْ الِّي يْبَشِّرْ بِيهْ بُولِسْ نُأْمْرِكْ بَاشْ تُخْرُجْ». ");
INSERT INTO aeu_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","وكَانْ مْعَ الجْمَاعَة هَاذُمْ سَبْعَة مِنْ وْلَادْ وَاحِدْ مِنْ كْبَارْ الكَهَنَةْ إِسْمُو سَكَاوَا. ");
INSERT INTO aeu_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","يَاخِي جَاوِبْهُمْ الرُّوحْ الشِّرِّيرْ: «يَسُوعْ نَعْرْفُو وبُولِسْ زَادَا نَعْرْفُو، آمَا إِنْتُومَا شْكُونْكُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","وهْجِمْ عْلِيهُمْ الرَّاجِلْ الِّي فِيهْ الرُّوحْ الشِّرِّيرْ وتْمَكِّنْ مِنْهُمْ وغْلِبْهُمْ، يَاخِي هَرْبُوا مِالدَّارْ عِرْيَانِينْ ومَجْرُوحِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","اليْهُودْ ولِّي مُشْ يْهُودْ السَّاكْنِينْ فِي أَفَسُسْ الكُلْ سَمْعُوا بِلِّي صَارْ، وخَافُوا بَرْشَة، وهَكَّا تْمَجِّدْ إِسْمْ الرَّبْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","وجَاوْ بَرْشَة مِلِّي أَمْنُوا، واعْتَرْفُوا بِالأَعْمَالْ الشِّرِّيرَة الِّي عَمْلُوهَا. ");
INSERT INTO aeu_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","وبَرْشَة مِلِّي كَانُوا يِسِحْرُوا لَمُّوا كْتُبِّتْهُمْ وهَزُّوا حَرْقُوهَا قُدَّامْ النَّاسْ الكُلْ. وكِي حِسْبُوا سُومْهَا لْقَاوْهَا تَسْوَى 50 000 قَطْعَة مِالفِضَّة. ");
INSERT INTO aeu_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","وهَكَّا كَانِتْ كِلْمِةْ الرَّبْ تِتِنْشَرْ وتَأْثِيرْهَا يَقْوَى. ");
INSERT INTO aeu_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","وبَعْدْ الحَاجَاتْ الِّي صَارِتْ هَاذِي الكُلْ، قَرِّرْ بُولِسْ بَاشْ يْسَافِرْ لْأُورْشَلِيمْ ويِتْعَدَّى عْلَى مَقْدُونِيَّة وأَخَائِيَة، وقَالْ: «بَعْدْمَا نِمْشِي غَادِي، لَازِمْنِي نْزُورْ رُومَا زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","وبْعَثْ لْمَقْدُونِيَّة زُوزْ مِلِّي يْعَاوْنُوا فِيهْ، وهُومَا تِيمُوثَاوُسْ وأَرَسْطُوسْ، آمَا هُوَّ زَادْ قْعَدْ مُدَّة فِي آسِيَّا. ");
INSERT INTO aeu_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","وفِي المُدَّة هَاذِيكَا وُقْعِتْ مُشْكْلَة كْبِيرَة فِي أَفَسُسْ بِسْبَبْ الطْرِيقْ هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","عْلَى خَاطِرْ فَمَّة صَايْغِي إِسْمُو دِيمِتْرِيُوسْ كَانْ يَصْنَعْ فِي مْعَابِدْ صْغِيرَة مِالفِضَّة كِيمَا مَعْبِدْ الإِلَاهَة أَرْطَامِيسْ، وكَانُوا الصُّنَّاعْ يِرْبْحُوا فِي بَرْشَة فْلُوسْ مِالخِدْمَة هَاذِي. ");
INSERT INTO aeu_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","يَاخِي لَمْ صُنَّاعُو وأَصْحَابْ صَنْعْتُو وقَالِلْهُمْ: «يَا رْجَالْ، إِنْتُومَا تَعْرْفُوا الِّي الخِيرْ الِّي عَايْشِينْ فِيهْ، وَاقِفْ عْلَى صَنْعِتْنَا هَاذِي. ");
INSERT INTO aeu_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","وإِنْتُومَا شُفْتُوا وسْمَعْتُوا الِّي بُولِسْ هَاذَا أَثِّرْ عْلَى بَرْشَة نَاسْ، مُشْ فِي أَفَسُسْ بَرْكْ، آمَا تَقْرِيبْ فِي آسِيَّا الكُلْ، وقْنَعْهُمْ الِّي الآلْهَة الِّي تِتْصْنَعْ بِاليِدْ مَاهِيشْ آلْهَة. ");
INSERT INTO aeu_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","وهَاذَا مُشْ بِشْ يْنَقِّصْ مِنْ قِيمِةْ صَنْعِتْنَا أَكَهَوْ، آمَا بِشْ يْطَيِّحْ قِيمِةْ مَعْبِدْ الإِلَاهَة العْظِيمَة أَرْطَامِيسْ، ويْنَقْصِلْهَا مِنْ هِيبِتْهَا، وهِيَّ الِّي يِعْبْدُوهَا النَّاسْ فِي آسِيَّا الكُلْ وفِي بْقِيِّةْ العَالِمْ». ");
INSERT INTO aeu_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","وكِي سَمْعُوا الصُّنَّاعْ الكْلَامْ هَاذَا، تْغَشْشُوا بَرْشَة وبْدَاوْ يْصِيحُوا: «عْظِيمَة أَرْطَامِيسْ، آلِهِةْ أَفَسُسْ!». ");
INSERT INTO aeu_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","وصَارِتْ خُوضَة كْبِيرَة فِي المْدِينَة الكُلْ، وهِجْمُوا بَرْشَة نَاسْ عْلَى غَايُوسْ وأَرِسْتَرْخُسْ الِّي مِنْ مَقْدُونِيَّة ولِّي كَانُوا مْسَافْرِينْ مْعَ بُولِسْ، وهَزُّوهُمْ بِالقُوَّة لْمَسْرَحْ المْدِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","وحَبْ بُولِسْ يْوَاجِهْ النَّاسْ، آمَا التْلَامْذَة مَا خَلَّاوْهِشْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","وحَتَّى صْحَابُو مِالمَسْؤُولِينْ الِّي فِي آسِيَّا بَعْثُولُو، وتْشَحْتُوهْ بَاشْ مَا يْخَاطِرْشْ بْرُوحُو ويِمْشِي لِلمَسْرَحْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","وكَانُوا النَّاسْ دَاخْلِينْ بْعَضْهُمْ، فَمَّة الِّي يْصِيحُوا عْلَى حَاجَة وأُخْرِينْ يْصِيحُوا عْلَى حَاجَة أُخْرَى، وأَغْلَبِيِّتْهُمْ مَا كَانُوشْ يَعْرْفُوا عْلَاشْ هُومَا غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","وكَانْ بِينَاتْهُمْ رَاجِلْ يْهُودِي إِسْمُو إِسْكَنْدَرْ، دَزُّوهْ اليْهُودْ القُدَّامْ وطَلْبُوا مِنُّو بَاشْ يِتْكَلِّمْ، يَاخِي هَزْ يِدُّو بَاشْ النَّاسْ يُسْكْتُوا ويِسْمْعُوا الدِّفَاعْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","آمَا كِي عَرْفُوا الِّي هُوَّ يْهُودِي، بْدَاوْ يْصِيحُوا الكُلْ بْصُوتْ وَاحِدْ ولْمُدِّةْ سَاعْتِينْ: «عْظِيمَة أَرْطَامِيسْ، آلِهِةْ أَفَسُسْ!». ");
INSERT INTO aeu_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","وفِي الإِخِّرْ، نَجِّمْ كَاتِبْ حَاكِمْ المْدِينَة يْرَيِّضْهُمْ وقَالِلْهُمْ: «يَا أَهْلْ أَفَسُسْ! شْكُونْ مَا يَعْرِفْشْ الِّي أَفَسُسْ هِيَّ المْدِينَة الِّي تُحْرُسْ فِي مَعْبِدْ أَرْطَامِيسْ العْظِيمَة، وفِي تِمْثَالْهَا الِّي هْبَطْ مِالسْمَاء؟ ");
INSERT INTO aeu_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","هَاذِي حَاجَة مَعْرُوفَة ومَا فِيهَاشْ كْلَامْ، مَالَا رِيضُوا ومَا تِتْسَرْعُوشْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","إِنْتُومَا جِبْتُوا الزُّوزْ رْجَالْ هَاذُمْ لَهْنَا، رَغْمِلِّي لَا سِرْقُوا المَعْبِدْ ولَا سَبُّوا إِلَاهِتْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","وإِذَا كَانْ دِيمِتْرِيُوسْ ولِّي يِخْدْمُوا مْعَاهْ يْحِبُّوا يِشْكِيوْ بْحَدْ، رَاهُو عَنَّا مْحَاكِمْ وقُضَاةْ يْنَجْمُوا يِشْكِيوْلْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","وإِذَا كَانْ عَنْدْكُمْ شْكَايَة أُخْرَى، لَازِمْنَا نُحْكْمُوا فِيهَا فِي جَلْسَة قَانُونِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","آمَا هَكَّا، مُمْكِنْ يِتْهْمُونَا بِالفِتْنَة بِسْبَبْ الِّي صَارْ اليُومْ. ومَا عَنْدْنَا حَتَّى عُذْرْ نْفَسْرُوا بِيهْ الخُوضَةْ هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","وبَعْدْمَا قَالْ الكْلَامْ هَاذَا، بْعَثْهُمْ يْرَوْحُوا. ");
INSERT INTO aeu_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","بَعْدْمَا وْفَاتْ الخُوضَة، عَيِّطْ بُولِسْ لِلتْلَامْذَة وشَجِّعْهُمْ، ومْبَعِّدْ وَدَّعْهُمْ وسَافِرْ لْمَقْدُونْيَا. ");
INSERT INTO aeu_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","وقْعَدْ يْدُورْ فِيهَا ويْشَجَّعْ بَرْشَة فِي المُؤْمْنِينْ فِي كُلْ بْلَاصَة. ومْبَعِّدْ وْصُلْ لِليُونَانْ، ");
INSERT INTO aeu_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","وقْعَدْ فِيهَا ثْلَاثَة شْهُرْ. وَقْتِلِّي كَانْ يْحَضِّرْ فِي رُوحُو بَاشْ يْسَافِرْ لْسُورْيَة عْلَى طْرِيقْ البْحَرْ، كَانُوا اليْهُودْ يْخَطِطُوا بَاشْ يُقْتْلُوهْ، يَاخِي قَرِّرْ بَاشْ يِرْجَعْ عْلَى طْرِيقْ مَقْدُونِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","وسَافِرْ مْعَاهْ سُوبَاتْرُسْ وِلْدْ بِرُّسْ مِنْ بِيرِيَّة، وأَرِسْتَرْخُسْ وسَكُونْدُسْ مِنْ تْسَالُونِيكِي، وغَايُوسْ وتِيمُوثَاوُسْ مِنْ مْدِينِةْ دَرْبَة، وتِيخِيكُسْ وتُرُوفِيمُسْ مِنْ آسِيَّا. ");
INSERT INTO aeu_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","هَاذُومَا سِبْقُونَا وقَعْدُوا يِسْتَنَّاوْ فِينَا فِي تَرُوَاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","آمَا أَحْنَا سَافِرْنَا عْلَى طْرِيقْ البْحَرْ مِنْ فِيلِپِّي بَعْدْ عِيدْ الفْطِيرْ، وبَعْدْ خَمْسَة أَيَّامْ خْلَطْنَا عْلِيهُمْ لْتَرُوَاسْ، وقْعَدْنَا غَادِي سَبْعَة أَيَّامْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ونْهَارْ الأَحَدْ، كُنَّا مَلْمُومِينْ بَاشْ نِقْسْمُوا الخُبْزْ ونَاكْلُوا. بْدَا بُولِسْ يُوعِظْ فِي الحَاضْرِينْ، وطَوِّلْ فِي الكْلَامْ حَتَّى لْنُصْفْ اللِّيلْ عْلَى خَاطْرُو كَانْ نَاوِي يْسَافِرْ مِنْ غُدْوَة. ");
INSERT INTO aeu_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","والبِيتْ الِّي تْلَمِّينَا فِيهَا فِي الطَّاقْ الفُوقَانِي كَانْ فِيهَا بَرْشَة فْنَارَاتْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","وكَانْ فَمَّة وْلِدْ إِسْمُو أَفْتِيخُوسْ قَاعِدْ عْلَى حَرْفْ الشِّبَّاكْ. كِي بُولِسْ طَوِّلْ فِي الكْلَامْ، غِلْبُو النُّومْ يَاخِي طَاحْ مِالطَّاقْ الثَّالِثْ، وهَزُّوهْ مِيِّتْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","يَاخِي هْبَطْ بُولِسْ وطَبِّسْ عْلِيهْ وعَنْقُو وقَالْ: «مَا تْخَافُوشْ! رَاهُو حَيْ». ");
INSERT INTO aeu_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","وبَعْدْهَا طْلَعْ لِلطَّاقْ الفُوقَانِي، وقْسِمْ الخُبْزْ وكْلَا، وبْقَى يِتْكَلِّمْ حَتَّى لِلفَجْرْ، ومْبَعِّدْ مْشَى. ");
INSERT INTO aeu_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ورَوْحُوا بِالوْلِدْ حَيْ، وهَاذَا شَجَّعْهُمْ بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","آمَا أَحْنَا سْبِقْنَا بُولِسْ ورْكِبْنَا فِي سْفِينَةْ لْأَسُّوسْ، واسْتَنِّينَاهْ بَاشْ يْجِي يِرْكِبْ مْعَانَا مِنْ غَادِي، عْلَى خَاطْرُو حَبْ يِمْشِي لْأَسُّوسْ عْلَى سَاقِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","وَقْتِلِّي خْلَطْ عْلِينَا، طَلَّعْنَاهْ مْعَانَا فِي السْفِينَة ومْشِينَا لِمْدِينِةْ مِيتِيلِينِي. ");
INSERT INTO aeu_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ومِنْ غُدْوَة كَمِّلْنَا السْفَرْ ووْصُلْنَا قُدَّامْ جَزِيرِةْ خِيُوسْ. وفِي النْهَارْ الثَّالِثْ تْعَدِّينَا بِجْنَبْ جَزِيرِةْ سَامُوسْ. ووْصُلْنَا لْمْدِينِةْ مِيلِيتُسْ فِي النْهَارْ الرَّابَعْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","وكَانْ بُولِسْ مْقَرِّرْ إِنُّو مَا يَاقِفْشْ فِي أَفَسُسْ بَاشْ مَا يْضَيَّعْشْ الوَقْتْ فِي آسِيَّا، فَمَّاشْ مَا يَخْلِطْ عْلَى عِيدْ يُومْ الخَمْسِينْ فِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ومِنْ مِيلِيتُسْ، بْعَثْ بُولِسْ يِسْتَدْعَى فِي شْيُوخْ كْنِيسِةْ أَفَسُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","وكِي وُصْلُوا قَالِلْهُمْ: «إِنْتُومَا تَعْرْفُوا كِيفَاشْ كُنْتْ نِتْصَرِّفْ مْعَاكُمْ طُولْ الوَقْتْ الِّي عَدِّيتُو بِينَاتْكُمْ، مِالنْهَارْ الأُوِّلْ الِّي عْفَسْتْ فِيهْ آسِيَّا. ");
INSERT INTO aeu_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","وكُنْتْ نِخْدِمْ فِي الرَّبْ بْكُلْ تَوَاضُعْ وبَرْشَة دْمُوعْ، ونْقَاسِي فِي المْحَايِنْ فِي جُرِّتْ مُؤَامْرَاتْ اليْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ومَا قَصِّرْتِشْ فِي حَتَّى حَاجَة تْفِيدْكُمْ. بِالعَكْسْ، كُنْتْ نْشَجَّعْ فِيكُمْ ونْعَلِّمْ فِيكُمْ قُدَّامْ النَّاسْ ومِنْ دَارْ لْدَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","وكُنْتْ نْشَجَّعْ فِي اليْهُودْ ولِّي مُشْ يْهُودْ بَاشْ يْتُوبُوا ويِرْجْعُوا لِلَّهْ، ويَمْنُوا بْرَبْنَا يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","وآنَا تَوَّا بِشْ نْطِيعْ الرُّوحْ القُدُسْ ونِمْشِي لْأُورْشَلِيمْ، ومَا نَعْرِفْشْ شْنُوَّة الِّي يِسْتَنَّى فِيَّا غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","آمَا فِي كُلْ مْدِينَة نِمْشِيلْهَا، الرُّوحْ القُدُسْ يْقُلِّي إِنُّو الحَبْسْ والمَشَاكِلْ يِسْتَنَّاوْ فِيَّا غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","آنَا حْيَاتِي مَا تْهِمْنِيشْ، الِّي يْهِمْنِّي هُوَّ إِنِّي نْقُومْ بْمُهِمْتِي ونْكَمِّلْ الخِدْمَة الِّي كَلَّفْنِي بِيهَا الرَّبْ يَسُوعْ، وهِيَّ إِنِّي نْخَبِّرْ بِبْشَارِة نِعْمِةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","وآنَا نَعْرِفْ إِنْكُمْ إِنْتُومَا الِّي كُنْتْ فِي وِسْطْكُمْ نْبَشِّرْ بْمَمْلِكْةْ اللَّهْ مَا عَادِشْ بِشْ تْشُوفُوا وِجْهِي مَرَّة أُخْرَى. ");
INSERT INTO aeu_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","هَاذَاكَا عْلَاشْ نْقُلْكُمْ اليُومْ بِلِّي آنَا بَرِيءْ مِنْ دَمْكُمْ، كَانْ وَاحِدْ مِنْكُمْ مَا يِنْجَاشْ، ");
INSERT INTO aeu_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","عْلَى خَاطِرْنِي مَا خَبِّيتْ عْلِيكُمْ شَيْ مِنْ خُطِّةْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","مَالَا رُدُّوا بَالْكُمْ عْلَى رْوَاحْكُمْ وعْلَى شَعْبْ اللَّهْ الكُلْ الِّي حَطْكُمْ الرُّوحْ القُدُسْ مَسْؤُولِينْ عْلِيهْ، بَاشْ تِتْلْهَاوْ بِكْنِيسِةْ اللَّهْ الِّي شْرَاهَا بْدَمُّو. ");
INSERT INTO aeu_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","«وآنَا نَعْرِفْ الِّي بَعْدْمَا نِمْشِي بِشْ يُدْخْلُوا بِينَاتْكُمْ نَاسْ كِالذْيُوبَة المِتْوَحْشَة ومُشْ بِشْ يِرْفْقُوا بْشَعْبْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ويُخْرْجُوا مِنْكُمْ نَاسْ يْبَدْلُوا الحَقْ فِي تَعْلِيمْهُمْ بَاشْ يْجُرُّوا التْلَامْذَة وْرَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","مَالَا رُدُّوا بَالْكُمْ، وتْذَكْرُوا كِيفَاشْ قْعَدْتْ ثْلَاثَة سْنِينْ وآنَا انَّبَّهْ فِي كُلْ وَاحِدْ فِيكُمْ نْهَارْ ولِيلْ وآنَا نِبْكِي بِالدْمُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","«وتَوَّا نْخَلِّيكُمْ فِي وْدِيعِةْ رَبِّي، وكِلْمِةْ نِعْمْتُو القَادْرَة بَاشْ تِبْنِيكُمْ وتُضِمْنِلْكُمْ مِيرَاثْ مْعَ قِدِّيسِينْ اللَّهْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","آنَا عُمْرِي مَا اشْتْهِيتْ لَا فُضَّة ولَا ذْهَبْ ولَا لِبْسَة حَدْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","وإِنْتُومَا تَعْرْفُوا الِّي آنَا خْدِمْتْ بِيدَيَّا هَاذُمْ بَاشْ نُصْرُفْ عْلَى رُوحِي وعَالنَّاسْ الِّي مْعَايَا. ");
INSERT INTO aeu_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ووَرِّيتْكُمْ كِيفَاشْ يِلْزِمْنَا نِخْدْمُوا ونِتْعْبُوا بَاشْ نْعَاوْنُوا المِحْتَاجِينْ. اتْفَكْرُوا كْلَامْ الرَّبْ يَسُوعْ وَقْتِلِّي قَالْ: \"الِّي يَعْطِي يِتْبَارِكْ أَكْثِرْ مِلِّي يَاخُذْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","وبَعْدْمَا قَالْ الكْلَامْ هَاذَا، رْكَعْ مْعَاهُمْ الكُلْ وصَلَّى. ");
INSERT INTO aeu_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","واطَّرْشْقُوا الكُلْ بِالبْكَاء، وتِرْمَاوْ عْلَى بُولِسْ يْعَنْقُوا ويْبُوسُوا فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","وأَكْثِرْ حَاجَة حَزْنِتْهُمْ كِي قَالِلْهُمْ الِّي مَا عَادِشْ بِشْ يْشُوفُوهْ مَرَّة أُخْرَى. ومْبَعِّدْ شَيْعُوهْ لِلسْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","وبَعْدْمَا تْفَارِقْنَا، سَافِرْنَا طُولْ لْجَزِيرِةْ لْكُوسْ عْلَى طْرِيقْ البْحَرْ، ومِنْ غُدْوَة وْصِلْنَا لْجَزِيرِةْ رُودُسْ ومِنْ غَادِي كَمَّلْنَا لْبُرْطْ بَاتَرَا، ");
INSERT INTO aeu_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","وِينْ لْقِينَا سْفِينَة مَاشْيَة لْفِينِيقْيَة، رْكِبْنَا فِيهَا وشَقِّينَا البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","وكِي رِينَا جَزِيرِةْ قُبْرُصْ، خَلِّينَاهَا عْلَى يْسَارْنَا وكَمِّلْنَا السْفَرْ لْسُورْيَة. وهْبَطْنَا فِي بُرْطْ صُورْ، عْلَى خَاطِرْ السْفِينَة كَانْ لَازِمْ تْهَبِّطْ السِّلْعَة الِّي فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ولْقِينَا غَادِي تْلَامْذَة، ضَيْفُونَا عَنْدْهُمْ سَبْعَة أَيَّامْ. وعْلَى خَاطِرْ الرُّوحْ وحَالْهُمْ، كَانُوا يِنْصْحُوا فِي بُولِسْ بَاشْ مَا يِمْشِيشْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","كِي وْفَاتْ الزْيَارَة، خْرَجْنَا بَاشْ نْكَمْلُوا سْفَرْنَا. يَاخِي شَيْعُونَا هُومَا ونْسَاهُمْ ووْلَادْهُمْ حَتَّى لِينْ خْرَجْنَا البَرَّة مِالمْدِينَة، وعَالشَّطْ هْبَطْنَا عْلَى رْكَايِبْنَا وصَلِّينَا. ");
INSERT INTO aeu_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","وبَعْدْ سَلَّمْنَا عْلَى بْعَضْنَا ورْكِبْنَا فِي السْفِينَة، وهُومَا رَجْعُوا لِدْيَارْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","وكَمِّلْنَا سَفْرِتْنَا مِنْ صُورْ لِمْدِينِةْ بْتُولِمَايِسْ، وسَلِّمْنَا عَالإِخْوَة الِّي غَادِي وعَدِّينَا مْعَاهُمْ نْهَارْ وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ومِنْ غُدْوَة وْصِلْنَا لْقَيْصَرِيَّة، ومْشِينَا لْدَارْ فِيلِۑُّسْ المُبَشِّرْ، وهُوَّ وَاحِدْ مِالسَّبْعَة الِّي إِخْتَارُوهُمْ فِي أُورْشَلِيمْ، وقْعَدْنَا عَنْدُو. ");
INSERT INTO aeu_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","وكَانْ عَنْدُو أَرْبْعَة بْنَاتْ صْبَايَا يِتْنَبْؤُوا. ");
INSERT INTO aeu_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","وبَعْدْمَا تْعَدَّاتْ أَيَّامَاتْ وأَحْنَا عَنْدُو، جَاء نَبِيْ إِسْمُو أَغَابُوسْ مِنْ مَنْطَقْةْ اليَهُودِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","جَانَا، وخْذَا حْزَامْ بُولِسْ ورْبَطْ رُوحُو بِيهْ مِنْ يْدِيهْ وسَاقِيهْ وقَالْ: «الرُّوحْ القُدُسْ يْقُولْ: \"مُولَى الحْزَامْ هَاذَا بِشْ يُرْبْطُوهْ اليْهُودْ كِيمَا هَكَّا فِي أُورْشَلِيمْ، ويْسَلْمُوهْ لِلِّي مَاهُمْشْ يْهُودْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","وكِي سْمَعْنَا الكْلَامْ هَاذَا، وَلِّينَا أَحْنَا والنَّاسْ الِّي كَانُوا غَادِي الكُلْ نِتْشَحْتُوا فِي بُولِسْ بَاشْ مَا يِمْشِيشْ لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","آمَا بُولِسْ قَالِلْنَا: «عْلَاشْ تِبْكِيوْ وتْوَجْعُولِي فِي قَلْبِي؟ آنَا مُسْتْعَدْ مُشْ بَاشْ يُرْبْطُونِي بَرْكَا فِي أُورْشَلِيمْ، آنَا مُسْتْعَدْ حَتَّى بَاشْ نْمُوتْ عْلَى خَاطِرْ إِسْمْ الرَّبْ يَسُوعْ». ");
INSERT INTO aeu_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","وكِي مَا نَجِّمْنَاشْ نَقْنْعُوهْ، سْكِتْنَا وقُلْنَا: «خَلِّي الِّي يْحِبُّو الرَّبْ، هُوَّ الِّي يْصِيرْ». ");
INSERT INTO aeu_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","وبَعْدْ أَيَّامَاتْ، حَضَّرْنَا رْوَاحْنَا ومْشِينَا لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","ومْشَاوْ مْعَانَا تْلَامْذَة مِنْ قَيْصَرِيَّة، وهَزُّونَا لْدَارْ تِلْمِيذْ قْدِيمْ مِنْ قُبْرُصْ إِسْمُو مَنَاسُونْ، بَاشْ نُقْعْدُوا عَنْدُو. ");
INSERT INTO aeu_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ووَقْتِلِّي وْصِلْنَا لْأُورْشَلِيمْ، فَرْحُوا بِينَا الإِخْوَة بَرْشَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ومِنْ غُدْوَة مْشَى مْعَانَا بُولِسْ لْدَارْ يَعْقُوبْ، وكَانُوا شْيُوخْ الكْنِيسَة الكُلْ مَلْمُومِينْ عَنْدُو. ");
INSERT INTO aeu_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","سَلِّمْ عْلِيهُمْ بُولِسْ وبْدَا يَحْكِيلْهُمْ بِالتَّفْصِيلْ كِيفَاشْ اللَّهْ اسْتَخْدْمُو بِينْ النَّاسْ الِّي مَاهُمْشْ يْهُودْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","كِي سَمْعُوا الأَخْبَارْ هَاذِي، مَجْدُوا اللَّهْ وقَالُوا لْبُولِسْ: «هَاكْ تْشُوفْ يَا خُونَا بُولِسْ الِّي فَمَّة آلَافْ مِاليْهُودْ أَمْنُوا بِالرَّبْ، وهُومَا شَادِّينْ فِي الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","وسَمْعُوا الِّي إِنْتِ تْعَلِّمْ فِي اليْهُودْ الِّي يُسْكْنُوا فِي الغُرْبَة بَاشْ مَا عَادِشْ يْتَبْعُوا شَرِيعِةْ مُوسَى، وتْوَصِّي فِيهُمْ بَاشْ مَا يْطَهْرُوشْ وْلَادْهُمْ ومَا يْتَبْعُوشْ العَادَاتْ المَوْرُوثَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","مَالَا آشْ نَعْمْلُوا تَوَّا؟ أَكِيدْ بِشْ يِسْمْعُوا الِّي إِنْتِ جِيتْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","مَالَا أَعْمِلْ الِّي بِشْ نْقُولُولِكْ عْلِيهْ: عَنْدْنَا أَرْبْعَة رْجَالْ وَاعْدِينْ وِعْدَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","هِزْهُمْ لِلْهَيْكِلْ وطَبَّقْ إِنْتِ ويَّاهُمْ شَرِيعِةْ التَّطْهِيرْ، وأَعْطِيهُمْ فْلُوسْ بَاشْ يْحَجْمُوا شْعُورَاتْهُمْ، وهَكَّا النَّاسْ الكُلْ يْوَلِّيوْ يَعْرْفُوا إِنُّو الِّي سَمْعُوهْ عْلِيكْ مُشْ صْحِيحْ ولِّي إِنْتِ قَاعِدْ تْطَبَّقْ فِي الشَّرِيعَة كِيفْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","آمَا الِّي أَمْنُوا وهُومَا مُشْ يْهُودْ، آهَاوْكَا بْعَثْنَالْهُمْ ووَصِّينَاهُمْ بَاشْ مَا يَاكْلُوشْ مِالذْبَايَحْ المَذْبُوحَة لِلأَصْنَامْ، الدَّمْ، لْحَمْ الحَيَوَانَاتْ المَخْنُوقَة، ويِبْعْدُوا عَالزْنَى». ");
INSERT INTO aeu_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ومِنْ غُدْوَة هَزْ بُولِسْ الأَرْبْعَة رْجَالْ وعَمْلُوا الحَاجَاتْ اللَّازْمَة لِلتَّطْهِيرْ، ودْخَلْ لِلْهَيْكِلْ بَاشْ يْقَيِّدْ وَقْتَاشْ يُوفَى التَّطْهِيرْ، ويْقَدَّمْ كُلْ وَاحِدْ فِيهُمْ القُرْبَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","وكِي قْرِيبْ تُوفَى السَّبْعَة أَيَّامْ، جْمَاعَة مِنْ يْهُودْ آسِيَّا شَافُوا بُولِسْ فِي الهَيْكِلْ. يَاخِي هَيْجُوا عْلِيهْ النَّاسْ وشَدُّوهْ ");
INSERT INTO aeu_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","وهُومَا يْصِيحُوا: «إِجْرِيوْلْنَا يَا بَنِي إِسْرَائِيلْ، هَاذَا هُوَّ الرَّاجِلْ الِّي يْعَلِّمْ فِي النَّاسْ فِي كُلْ بُقْعَة فِي تَعْلِيمْ ضِدْ شَعْبْنَا وشَرِيعِتْنَا وضِدْ البْلَاصَة هَاذِي زَادَا، حَتَّى إِنُّو دَخِّلْ الِّي مَاهُمْشْ يْهُودْ لِلْهَيْكِلْ ونَجِّسْ البْلَاصَة المُقَدْسَة هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","قَالُوا هَاذَا عْلَى خَاطِرْهُمْ شَافُوا تُرُوفِيمُسْ الِّي مِنْ أَفَسُسْ مْعَ بُولِسْ فِي المْدِينَة، يَاخِي مْشَى فِي بَالْهُمْ الِّي هُوَّ دَخْلُو مْعَاهْ لِلْهَيْكِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","وَقْتْهَا هَاجِتْ المْدِينَة الكُلْ، وبْدَاوْ النَّاسْ يِجْرِيوْ مِنْ كُلْ بْلَاصَةْ، وهِجْمُوا عْلَى بُولِسْ وكَرْكْرُوهْ لْبَرَّة مِالهَيْكِلْ، وتْسَكْرِتْ بِيبَانْ الهَيْكِلْ بِالوَقْتْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","وهُومَا شَادِّينُو بَاشْ يُقْتْلُوهْ، وْصُلْ الخْبَرْ لْقَايِدْ العَسْكِرْ الرُّومَانِي بِلِّي أُورْشَلِيمْ الكُلْهَا خَايْضَة. ");
INSERT INTO aeu_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","بِالوَقْتْ هَزْ مْعَاهْ عَسْكِرْ وضُبَّاطْ ومْشَالْهُمْ يِجْرِي. كِي شَافُوهُمْ اليْهُودْ جَايِينْ، وَقْفُوا الضَّرْبْ وسَيْبُوا بُولِسْ . ");
INSERT INTO aeu_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","وقْرُبْ القَايِدْ وشَدْ بُولِسْ، وأْمَرْ بَاشْ يُرْبْطُوهْ بْزُوزْ سْلَاسِلْ، وبْدَا يِسْإِلْ: «شْكُونُو هَاذَا، وشَعْمَلْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","يَاخِي بْدَاوْ جْمَاعَة مِنْهُمْ يْعَيْطُوا ويْقُولُوا فِي شَيْ، وجْمَاعَة يْقُولُوا فِي شَيْ آخِرْ. وكِي مَا نَجِّمْشْ يَعْرِفْ شْنُوَّة الِّي صَارْ بِالضَّبْطْ بِسْبَبْ الخُوضَةْ، أْمَرْ بَاشْ يْهِزُّوا بُولِسْ لِلثَّكْنَةْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","وَقْتِلِّي وُصْلُوا بِيهْ لِلدْرُوجْ، تْلَزُّوا العَسْكِرْ بَاشْ يْهِزُّوهْ مْحَمِّلْ ويْمَنْعُوهْ مِنْ عُنْفْ النَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","عْلَى خَاطِرْهُمْ كَانُوا يْتَبْعُوا فِيهْ وهُومَا يْعَيْطُوا: «أُقْتْلُوهْ!». ");
INSERT INTO aeu_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","وكِي قْرِيبْ يُدْخُلْ بُولِسْ لِلثَّكْنَةْ قَالْ لِلقَايِدْ بِاللُّوغَة اليُونَانِيَّة: «انَّجِّمْ نْقُلِّكْ حَاجَة؟». قَالْ القَايِدْ: «تِتْكَلِّمْ بِاليُونَانِيَّة؟ ");
INSERT INTO aeu_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","مُشْ إِنْتِ المَصْرِي الِّي عْمَلْ ثَوْرَة فِي المْدِينَة المُدَّة الِّي فَاتِتْ، وخَرِّجْ مْعَاهْ 4 000 قَتَّالِةْ أَرْوَاحْ لِلصَّحْرَاء، وحَطْ رُوحُو قَايِدْ عْلِيهُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","يَاخِي بُولِسْ جَاوْبُو: «آنَا يْهُودِي مِنْ طَرْسُوسْ المْدِينَة المَشْهُورَة الِّي فِي كِيلِيكِيَّة. مِنْ فَضْلِكْ، خَلِّينِي نْكَلِّمْ الشَّعْبْ». ");
INSERT INTO aeu_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","يَاخِي القَايِدْ خَلَّاهْ. ووْقِفْ بُولِسْ فُوقْ الدْرُوجْ وشَاوِرْ بِيِدُّو لِلشَّعْبْ. وَقْتِلِّي سِكْتُوا، بْدَا يْكَلِّمْ فِيهُمْ بِاللُّوغَة العِبْرِيَّة وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«يَا خْوَاتِي ويَا شْيُوخْنَا، إِسْمْعُونِي نْدَافِعْ عْلَى رُوحِي». ");
INSERT INTO aeu_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","وكِي سَمْعُوهْ يْكَلِّمْ فِيهُمْ بِاللُّوغَة العِبْرِيَّة، سِكْتُوا جِمْلَا. يَاخِي قَالْ: ");
INSERT INTO aeu_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«آنَا يْهُودِي تُولِدْتْ فِي طَرْسُوسْ الِّي فِي كِيلِيكِيَّة، آمَا تْرَبِّيتْ هُونِي فِي أُورْشَلِيمْ وكُنْتْ تِلْمِيذْ عَنْدْ غَمَالَائِيلْ وتْعَلِّمْتْ شَرِيعِةْ جْدُودْنَا عْلَى قَاعْدَة صْحِيحَة. وكُنْتْ مِتْحَمِّسْ لْخِدْمِةْ اللَّهْ، كِيفْ مَا إِنْتُومَا اليُومْ. ");
INSERT INTO aeu_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","واضْطَهِدْتْ النَّاسْ الِّي يْتَبْعُوا فِي الطْرِيقْ هَاذَا لْحَدْ المُوتْ، وكُنْتْ نْشِدْ فِيهُمْ رْجَالْ ونْسَاء، ونَرْمِي فِيهُمْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","والكَاهِنْ الكْبِيرْ والشْيُوخْ الكُلْ شَاهْدِينْ عْلَى كْلَامِي. آنَا هَزِّيتْ مِنْ عَنْدْهُمْ جْوَابَاتْ لِخْوَاتْهُمْ فِي دِمَشْقْ بَاشْ يْعَاوْنُونِي نْشِدْ النَّاسْ الِّي غَادِي، ونْرَجَّعْهُمْ مْسَلْسْلِينْ لْأُورْشَلِيمْ بَاشْ يِتْعَاقْبُوا. ");
INSERT INTO aeu_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«وفِي الظُّهْرْ، وَقْتِلِّي قْرِيبْ نُوصِلْ لْدِمَشْقْ، ضْوَى عْلِيَّا نُورْ عْظِيمْ مِالسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","يَاخِي طُحْتْ عَالقَاعَةْ، وسْمَعْتْ صُوتْ يْقُلِّي: \"شَاوُلْ! شَاوُلْ! عْلَاشْ تِضْطَهِدْ فِيَّا؟\". ");
INSERT INTO aeu_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","جَاوِبْتْ: \"شْكُونْ إِنْتِ يَا رَبْ؟\". قَالْ: \"آنَا يَسُوعْ النَّاصْرِي الِّي إِنْتِ تِضْطَهِدْ فِيهْ\". ");
INSERT INTO aeu_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","ولِّي كَانُوا مْعَايَا شَافُوا النُّورْ، آمَا مَا سَمْعُوشْ صُوتْ الِّي يْكَلِّمْ فِيَّا. ");
INSERT INTO aeu_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","يَاخِي قُلْتْ: \"آشْ نَعْمِلْ يَا رَبْ؟\". جَاوِبْنِي الرَّبْ: \"قُومْ وإِمْشِي لْدِمَشْقْ، وغَادِي يْقُولُولِكْ آشْ يِلْزْمِكْ تَعْمِلْ\". ");
INSERT INTO aeu_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","«ووَصْلُونِي الِّي مْعَايَا لْدِمَشْقْ وهُومَا شَادِّينِي مِنْ يْدَيَّا، عْلَى خَاطِرْنِي مَا عَادِشْ نْشُوفْ مِنْ قُوِّةْ النُّورْ الِّي عْمَانِي. ");
INSERT INTO aeu_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","وكَانْ فِيهَا رَاجِلْ يْخَافْ رَبِّي إِسْمُو حَنَانِيَّا عَايِشْ حَسْبْ الشَّرِيعَة، ومَشْهُودْلُو مِاليْهُودْ الِّي فِي دِمَشْقْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","جَانِي ووْقِفْ بْجَنْبِي وقَالْ: \"يَا خُويَا شَاوُلْ، شُوفْ!\". يَاخِي رْجَعْتْ نْشُوفْ بِالوَقْتْ، ورِيتُو. ");
INSERT INTO aeu_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","وقَالْ: \"إِلَاهْ جْدُودْنَا اخْتَارِكْ بَاشْ تَعْرْفُو آشْ يْحِبْ، وبَاشْ تْشُوفْ الصَّالَحْ وتِسْمَعْ كْلَامْ مِنْ فُمُّو. ");
INSERT INTO aeu_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","وإِنْتِ بِشْ تْكُونْ شَاهِدْ لِيهْ قُدَّامْ النَّاسْ الكُلْ بِلِّي رِيتُو وسْمَعْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","وتَوَّا فَاشْ تِسْتَنَّى؟ قُومْ تْعَمِّدْ وتِغْسَلْ مِنْ ذْنُوبِكْ وادْعِي بْإِسْمْ الرَّبْ\". ");
INSERT INTO aeu_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","«وبَعْدْ رْجَعْتْ لْأُورْشَلِيمْ. وآنَا نْصَلِّي فِي الهَيْكِلْ، شُفْتْ رُؤْيَا، ");
INSERT INTO aeu_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","وشُفْتْ الرَّبْ يْقُلِّي: \"إِزْرِبْ! وأُخْرُجْ تَوَّا مِنْ أُورْشَلِيمْ، عْلَى خَاطِرْ نَاسْهَا مَاهُمْشْ بِشْ يِقْبْلُوا شْهَادْتِكْ لِيَّا\". ");
INSERT INTO aeu_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","يَاخِي قُلْتْ: \"يَا رَبْ، رَاهُمْ يَعْرْفُوا الِّي آنَا كُنْتْ نُدْخُلْ لِلمْعَابِدْ الكُلْ بَاشْ نْشِدْ الِّي يَمْنُوا بِيكْ ونْحُطْهُمْ فِي الحَبْسْ ونَضْرَبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","وكُنْتْ حَاضِرْ وَقْتِلِّي سَيْلُو دَمْ شَهِيدِكْ اسْتِفَانُوسْ، وكُنْتْ مْوَافِقْ عْلَى قَتْلَانُو، ونْعِسْ عْلَى حْوَايِجْ الِّي قَتْلُوهْ\". ");
INSERT INTO aeu_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","يَاخِي قَالِّي: \"إِمْشِي، بِشْ نِبْعْثِكْ بْعِيدْ لِلنَّاسْ الِّي مَاهُمْشْ يْهُودْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","وقَعْدُوا النَّاسْ يِسْمْعُوا فِيهْ حَتَّى لِينْ قَالْ الكِلْمَة هَاذِي، يَاخِي صَاحُوا بْأَعْلَى صُوتْهُمْ: «إِمْحِيوْ الرَّاجِلْ هَاذَا مِالأَرْضْ. هَاذَا مَا يِسْتَاهِلْشْ يْعِيشْ». ");
INSERT INTO aeu_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","وبْدَاوْ يْصِيحُوا ويَرْمِيوْ فِي حْوَايِجْهُمْ، ويْذَرِّيوْ فِي التْرَابْ فِي الهْوَاء. ");
INSERT INTO aeu_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","يَاخِي أْمَرْ القَايِدْ بَاشْ يْدَخْلُوا بُولِسْ لِلثَّكْنَة، ويِسْتَجْوْبُوهْ بِالضَّرْبْ، بَاشْ يَعْرِفْ شْنُوَّة الِّي خَلَّى النَّاسْ يْهِيجُوا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","ووَقْتِلِّي كَتْفُوهْ بَاشْ يِجِلْدُوهْ، قَالْ لِلضَّابِطْ الِّي كَانْ وَاقِفْ بْجَنْبُو: «يَاخِي القَانُونْ يِسْمْحِلْكُمْ بَاشْ تِجِلْدُوا مُوَاطِنْ رُومَانِي قْبَلْ مَا تْحَاكْمُوهْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","وكِي سْمَعْ الضَّابِطْ الكْلَامْ هَاذَا، مْشَى لِلقَايِدْ وخَبْرُو وقَالْ: «فِي بَالِكْ آشْ كُنْتْ بِشْ تَعْمِلْ؟ الرَّاجِلْ هَاذَا رُومَانِي!». ");
INSERT INTO aeu_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","يَاخِي مْشَى القَايِدْ لْبُولِسْ وسِأْلُو: «قُلِّي، بِالحَقْ إِنْتِ مُوَاطِنْ رُومَانِي؟». جَاوْبُو: «إِيْ نْعَمْ». ");
INSERT INTO aeu_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","قَالْ القَايِدْ: «آنَا دْفَعْتْ بَرْشَة فْلُوسْ بَاشْ نَاخُو الجِنْسِيَّة الرُّومَانِيَّة». قَالْ بُولِسْ: «آمَا آنَا تُولِدْتْ بِيهَا». ");
INSERT INTO aeu_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","وبِالوَقْتْ وَخْرُوا الِّي كَانُوا بِشْ يِسْتَجْوْبُوهْ. والقَايِدْ خَافْ بَرْشَة كِي عْرَفْ الِّي هُوَّ كَتِّفْ مُوَاطِنْ رُومَانِي. ");
INSERT INTO aeu_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","ومِنْ غُدْوَة حَبْ القَايِدْ يَعْرِفْ حْقِيقِةْ التُّهْمَة الِّي تَاهْمِينُوا بِيهَا اليْهُودْ، يَاخِي نَحَّالُو السْلَاسِلْ واسْتَدْعَى كْبَارْ الكَهَنَةْ والمَجْلِسْ الأَعْلَى. وبَعْدْ جَابْ بُولِسْ ووَقْفُو قُدَّامْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","خْزَرْ بُولِسْ لِلمَجْلِسْ وقَالْ: «يَا خْوَاتِي، آنَا عِشْتْ حْيَاتِي قُدَّامْ اللَّهْ بْضَمِيرْ مِرْتَاحْ حَتَّى لِلْيُومْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","آمَا حَنَانِيَّا الكَاهِنْ الكْبِيرْ، عْطَى أَمْرْ لِلوَاقْفِينْ بِجْنَبْ بُولِسْ بَاشْ يُضْرْبُوهْ عْلَى فُمُّو. ");
INSERT INTO aeu_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","يَاخِي بُولِسْ قَالُّو: «اللَّهْ بِشْ يُضْرْبِكْ يَا مُنَافِقْ! قَاعِدْ تُحْكُمْ عْلِيَّا حَسْبْ الشَّرِيعَة، ومْبَعِّدْ تْخَالِفْهَا وتُأْمُرْ بَاشْ يَضْرْبُونِي؟». ");
INSERT INTO aeu_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","والنَّاسْ الوَاقْفِينْ بْجَنْبُو قَالُولُو: «يَاخِي تْسِبْ فِي كْبِيرْ كَهَنَةْ اللَّهْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","جَاوِبْ بُولِسْ وقَالْ: «يَا خْوَاتِي، مَا كُنْتِشْ نَعْرِفْ الِّي هُوَّ الكَاهِنْ الكْبِيرْ، عْلَى خَاطِرْ مَكْتُوبْ فِي الكْتُبْ المُقَدْسَةْ: \"مَا تْسِبِّشْ رَئِيسْ شَعْبِكْ\"». ");
INSERT INTO aeu_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","وكِي عْرَفْ بُولِسْ الِّي المَجْلِسْ فِيهْ جْمَاعَة صَدُّوقِيِّينْ وجْمَاعَة فِرِّيسِيِّينْ، صَاحْ وقَالْ: «يَا خْوَاتِي، آنَا فِرِّيسِي وِلْدْ فِرِّيسِي، وقَاعِدْ نِتْحَاكِمْ تَوَّا عْلَى خَاطِرْ عَنْدِي رْجَى فِي قْيَامَة المُوتَى». ");
INSERT INTO aeu_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","ودُوبْ مَا قَالْ الكْلَامْ هَاذَا، تْعَارْكُوا الفِرِّيسِيِّينْ والصَّدُّوقِيِّينْ، وتِقْسِمْ المَجْلِسْ، ");
INSERT INTO aeu_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","عْلَى خَاطِرْ الصَّدُّوقِيِّينْ مَا يْأَمْنُوشْ بِقْيَامَة المُوتَى ولَا بِالمْلَايْكَة ولَا بِالأَرْوَاحْ، آمَا الفِرِّيسِيِّينْ يَمْنُوا بْهَاذُمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","وعْلَا صْيَاحْهُمْ، ووِقْفُوا جْمَاعَة مِنْ عُلَمَاءْ الشَّرِيعَةْ التَّابْعِينْ لِلْفِرِّيسِيِّينْ وبْدَاوْا يَحْتَجُّوا بْقُوَّة وقَالُوا: «الرَّاجِلْ هَاذَا مَا لْقِينَالُو حَتَّى عِيبْ، بَالِكْشِي كَلْمُو رُوحْ وَلَّا مَلَاكْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","والمُشْكُلْ زَادْ كْبِرْ، لْدَرْجِةْ إِنُّو القَايِدْ خَافْ لَا يْقَطْعُوا بُولِسْ طْرُوفْ. يَاخِي أْمَرْ العَسْكِرْ بَاشْ يَهْبْطُوهْ ويْهِزُّوهْ مِنْ بِينَاتْهُمْ ويْرَجْعُوهْ لِلثَّكْنَة. ");
INSERT INTO aeu_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","واللِّيلَة الِّي بَعْدْهَا، ظْهُرْ الرَّبْ لْبُولِسْ وقَالُّو: «اتْشَجَّعْ! كِيمَا شْهِدْتْلِي فِي أُورْشَلِيمْ، بِشْ تِشْهِدْلِي فِي رُومَا زَادَا». ");
INSERT INTO aeu_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","وَقْتِلِّي طْلَعْ النْهَارْ تْفَاهْمُوا اليْهُودْ عْلَى بُولِسْ، وحِلْفُوا بِشْ لَا يَاكْلُوا ولَا يُشْرْبُوا حَتَّى لِينْ يُقْتْلُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","وكَانُوا أَكْثِرْ مِنْ 40 وَاحِدْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","مْشَاوْ لْكْبَارْ الكَهَنَة والشْيُوخْ وقَالُوا: «تُحْرِمْ عْلِينَا المَاكْلَة والشْرَابْ حَتَّى لِينْ نُقْتْلُوا بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","إِنْتُومَا بْصِيفِتْكُمْ أَعْضَاءْ مَجْلِسْ الأَعْلَى، أُطْلْبُوا مِالقَايِدْ بَاشْ يْجِيبْ بُولِسْ، بْحُجِّةْ إِنْكُمْ تْزِيدُوا تْحَقْقُوا مْعَاهْ، وأَحْنَا نْكُونُوا مُسْتْعَدِّينْ بَاشْ نُقْتْلُوهْ قْبَلْ مَا يُوصْلِلْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","آمَا وِلْدْ أُخْتْ بُولِسْ سْمَعْ بِالخُطَّة، يَاخِي مْشَالُو لِلثَّكْنَةْ وحْكَالُو كُلْ شَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","ولَّى بُولِسْ اسْتَدْعَى وَاحِدْ مِالضُبَّاطْ وقَالُّو: « هِزْ الطْفُلْ هَاذَا لِلقَايِدْ، عْلَى خَاطِرْ عَنْدُو حَاجَة بِشْ يْقُولْهَالُو». ");
INSERT INTO aeu_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","وهَزُّو الضَّابِطْ لِلقَايِدْ وقَالْ: «رَاهُو المَرْبُوطْ بُولِسْ عَيِّطْلِي، وِطْلَبْ مِنِّي بَاشْ نْجِيبْلِكْ الطْفُلْ هَاذَا عْلَى خَاطِرْ عَنْدُو مَا يْقُلِّكْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","يَاخِي جِبْدُو القَايِدْ عْلَى جْنَبْ مِنْ يِدُّو وسِأْلُو: «شْنُوَّة تْحِبْ تْقُلِّي؟». ");
INSERT INTO aeu_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","قَالُّو: «اليْهُودْ تْفَاهْمُوا بَاشْ يُطْلْبُوا مِنِّكْ تْجِيبْ بُولِسْ غُدْوَة لِلمَجْلِسْ، بْحُجِّة إِنْهُمْ بَاشْ يْزِيدُوا يْحَقِّقُوا فِي حْكَايْتُو أَكْثِرْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","مَا تْصَدَّقْهُمْشْ، رَاهُو فَمَّة أَكْثِرْ مِنْ 40 رَاجِلْ مْحَضْرِينْلُوا كَمِينْ وحَرْمُوا عْلَى رْوَاحْهُمْ المَاكْلَة والشْرَابْ حَتَّى يُقْتْلُوهْ، وهُومَا تَوَّا حَاضْرِينْ، وقَاعْدِينْ يِسْتَنَّاوْ فِيكْ بَاشْ تْوَافِقْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","يَاخِي قَالُّو القَايِدْ: «مَا تْقُولْ لْحَدْ الِّي إِنْتِ عْلِمْتْنِي» وخَلَّاهْ يِمْشِي. ");
INSERT INTO aeu_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","وعَيِّطْ القَايِدْ لْزُوزْ مِنْ ضُبَّاطُو وقَالِلْهُمْ: «حَضّْرُوا 200 عَسْكْرِي و70 فَارِسْ و200 جُنْدِي هَازِّينْ الأَرْمَاحْ بَاشْ يِمْشِيوْ اليُومْ التِّسْعَة مْتَاعْ اللِّيلْ لْقَيْصَرِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","وحَضّْرُوا زَادَا حْصُنَّة بَاشْ تْهِزْ بُولِسْ وتْوَصْلُو سَالِمْ لِلوَالِي فِيلِكْسْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","وكْتِبْ رِسَالَة لِلوَالِي يْقُولْ فِيهَا: ");
INSERT INTO aeu_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«مِنْ كْلُودْيُوسْ لِيسْيَاسْ لْفَخَامِةْ الوَالِي فِيلِكْسْ، تَحِيَّاتِي: ");
INSERT INTO aeu_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","«الرَّاجِلْ هَاذَا شَدُّوهْ اليْهُودْ وزَعْمَةْ لَا قَتْلُوهْ. وكِي عْرَفْتْ الِّي هُوَّ مُوَاطِنْ رُومَانِي، مْشِيتْلُو فِيسَعْ مْعَ العَسْكِرْ ومَنَّعْتُو. ");
INSERT INTO aeu_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","وحَبِّيتْ نَعْرِفْ بَاشْ تَاهْمِينُو، يَاخِي هَزِّيتُو لْمَجْلِسْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","ولْقِيتْ الِّي تَاهْمِينُو بْمَسَائِلْ تْخُصْ الشَّرِيعَة مْتَاعْهُمْ، وحَتَّى شَيْ مِلِّي تَاهْمِينُو بِيهْ مَا يِسْتْحَقْ المُوتْ ولَا حَتَّى الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","وبَعْدْ عْرَفْتْ الِّي هُومَا تْآمْرُوا عْلِيهْ بَاشْ يُقْتْلُوهْ، ولِّيتْ بْعَثْتْهُولِكْ بِالوَقْتْ، وعْطِيتْ أَمْرْ لِلشَّاكْيِينْ بِيهْ بَاشْ يْجِيوْكْ إِنْتِ ويِشْكِيوْلِكْ». ");
INSERT INTO aeu_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ونَفْذُوا العَسْكِرْ أَوَامِرْ قَايِدْهُمْ وهَزُّوا بُولِسْ فِي اللِّيلْ ووُصْلُوا بِيهْ لِمْدِينِةْ أَنْتِيبَاتْرِيسْ، ");
INSERT INTO aeu_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","ومِنْ غُدْوَة رَجْعُوا لِلثَّكْنَةْ، وخَلَّاوْ الفُرْسَانْ يِمْشِيوْ مْعَ بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","وكِي وُصْلُوا الفُرْسَانْ لْقَيْصَرِيَّة، عْطَاوْ الرِّسَالَة لِلْوَالِي وسَلْمُولُو بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","قْرَى الوَالِي الرِّسَالَة، وسْإِلْ بُولِسْ عْلَى أَصْلُو مْنِينْ . وكِي عْرَفْ الِّي هُوَّ مِنْ كِيلِيكِيَّة، ");
INSERT INTO aeu_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","قَالُّو: «تَوْ نْشُوفْلِكْ القَضِيَّة مْتَاعِكْ كِي يَحْضْرُوا الشَّاكْيِينْ بِيكْ». وعْطَى أَمْرْ بَاشْ يِبْقَى بُولِسْ تَحْتْ الحِرَاسَةْ فِي دَارْ الوِلَايَة التَّابْعَة لْهِيرُودُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","وبَعْدْ خَمْسَة أَيَّامْ، جَاء حَنَانِيَّا الكَاهِنْ الكْبِيرْ وجْمَاعَة مِالشْيُوخْ ومُحَامِي إِسْمُو تَرْتُلُّسْ لْقَيْصَرِيَّة، وشْكَاوْا بْبُولِسْ لِلْوَالِي. ");
INSERT INTO aeu_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","وجَابُوا بُولِسْ وبْدَا تَرْتُلُّسْ يِتْهِمْ فِيهْ قُدَّامْ فِيلِكْسْ وقَالْ: «الفَضْلْ يِرْجَعْ لِيكْ إِنْتِ فِي السَّلَامْ الِّي مِتْمَتْعِينْ بِيهْ أَحْنَا، والإِصْلَاحَاتْ الِّي تْعَمْلِتْ لْشَعْبْنَا هَاذَا نَتِيجِةْ حِكْمْتِكْ، ");
INSERT INTO aeu_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","وأَحْنَا يَا حَضْرِةْ الوَالِي فِيلِكْسْ فَرْحَانِينْ بْهَاذَا، وشَاكْرِينِكْ فِي كُلْ وَقْتْ وفِي كُلْ بْلَاصَة. ");
INSERT INTO aeu_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","وبَاشْ مَا نْطَوِّلْشْ عْلِيكْ أَكْثِرْ، مَذَابِيكْ تِتْكَرِّمْ عْلِينَا، وتْوَسَّعْ بَالِكْ وتِسْمَعْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","أَحْنَا فِقْنَا الِّي الرَّاجِلْ هَاذَا يِتْسَبِّبْ فِي المَشَاكِلْ، ويَعْمِلْ فِي فِتْنَة بِينْ اليْهُودْ فِي العَالِمْ الكُلْ، وهُوَّ زَعِيمْ مَذْهَبْ النَّاصِرِيينْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","وحَاوِلْ يْنَجِّسْ الهَيْكِلْ مْتَاعْنَا. وَلِّينَا شَدِّينَاهْ وحَبِّينَا نُحْكْمُوا عْلِيهْ حَسْبْ شَرِيعِتْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","آمَا القَايِدْ لِيسْيَاسْ جَاء وفَكُّو مِنْ يْدِينَا بِالقُوَّة، ");
INSERT INTO aeu_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","وعْطَى أَمْرْ لِلِّي تَاهْمِينُو بَاشْ يْجِيوْ يِشْكِيوْ لِيكْ إِنْتِ، وكِي تِسْتَجْوْبُو تَوَّا تِتْأَكِّدْ إِنُّو كُلْ المُتَّهْمِينُو بِيهْ صْحِيحْ». ");
INSERT INTO aeu_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","واليْهُودْ الكُلْ وَافْقُوهْ وقَالُوا الِّي هَاذَا صْحِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","وطْلَبْ الوَالِي مِنْ بُولِسْ بَاشْ يِتْكَلِّمْ، يَاخِي قَالْ: «آنَا نَعْرِفْ الِّي عَنْدِكْ سْنِينْ تُحْكُمْ فِي قَضَايَا شَعْبْنَا، هَاذَاكَا عْلَاشْ بِشْ نْدَافِعْ عْلَى رُوحِي قُدَّامِكْ وآنَا مُطْمَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","وتْنَجِّمْ تِتْأَكِّدْ الِّي مَا عَنْدِيشْ حَتَّى أَثْنَاشِنْ يُومْ مِلِّي وْصِلْتْ لْأُورْشَلِيمْ بَاشْ نِعْبِدْ رَبِّي. ");
INSERT INTO aeu_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","وحَتَّى وَاحِدْ مَا لْقَانِي انَّاقِشْ فِي حَدْ فِي الهَيْكِلْ، ولَا فِي المَعَابِدْ ولَا فِي حَتَّى بْلَاصَة فِي المْدِينَة، ولَا نْهَيِّجْ فِي الشَّعْبْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","وهُومَا مَا يْنَجْمُوشْ يَعْطِيوِكْ الدَّلِيلْ عَلِّي مُتَّهْمِينِي بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","آمَا نِعْتَرِفْلِكْ الِّي آنَا نِعْبِدْ فِي إِلَاهْ جْدُودْنَا حَسْبْ المَذْهَبْ الِّي يِتْسَمَّى الطْرِيقْ ولِّي يْقُولُوا عْلِيهْ إِنُّو بِدْعَة، ونَمِّنْ بْكُلْ الِّي مَكْتُوبْ فِي الشَّرِيعَة وكْتُبْ الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","وعَنْدِي رْجَى فِي اللَّهْ كِيفْهُمْ، إِنُّو بِشْ تْكُونْ فَمَّة قْيَامَةْ مِالمُوتْ لِلصَّالْحِينْ والأَشْرَارْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","هَاذَاكَا عْلَاشْ نْجَاهِدْ بَاشْ يْكُونْ ضَمِيرِي طَاهِرْ قُدَّامْ اللَّهْ والنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","«وبَعْدْمَا غِبْتْ سْنِينْ عْلَى أُورْشَلِيمْ، رْجَعْتِلْهَا بَاشْ نْجِيبْ شْوَيَّة تَبَرُّعَاتْ لْشَعْبِي ونْقَدِّمْ قْرَابِينْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","شَافُونِي جْمَاعَة يْهُودْ مِنْ آسِيَّا فِي الهَيْكِلْ. وَقْتْهَا مَزِّلْتْ كِي كَمَّلْتْ شَرِيعِة التَّطْهِيرْ، ولَا كُنْتْ مْدَوِّرْ بِيَّا نَاسْ ولَا نَعْمِلْ فِي فَوْضَى. ");
INSERT INTO aeu_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","وكَانْ لَازِمْ يْجِيوِكْ هُومَا بِيدْهُمْ ويِشْكِيوْلِكْ كَانْ جَاء عَنْدْهُمْ حَاجَة ضِدِّي. ");
INSERT INTO aeu_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","وَلَّا خَلِّي النَّاسْ المَوْجُودِينْ هُونِي يْقُولُولِكْ شْنُوَّة الذَّنْبْ الِّي شَدُّوهْ عْلِيَّا، وَقْتِلِّي تْحَاكِمْتْ قُدَّامْ المَجْلِسْ الأَعْلَى. ");
INSERT INTO aeu_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","إِلَّا إِذَا كَانْ عْلَى خَاطِرْ الجُمْلَةْ الوَحِيدَةْ الِّي نْطَقْتْ بِيهَا وآنَا وَاقِفْ قُدَّامْهُمْ: \"آنَا قَاعِدْ نِتْحَاكِمْ تَوَّا عْلَى خَاطِرْنِي نَمِّنْ بِقْيَامِةْ المُوتَى\"». ");
INSERT INTO aeu_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","وفِيلِكْسْ الِّي كَانْ يَعْرِفْ بَرْشَة حَاجَاتْ عَلِّي يْسَمِّيوُهْ الطْرِيقْ، أَجِّلْ الجَلْسَةْ وقَالْ: «وَقْتِلِّي يْجِي القَايِدْ لِيسْيَاسْ، تَوْ نُحْكُمْ فِي القَضِيَّة مْتَاعْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","وأْمَرْ الضَّابِطْ بَاشْ يْحُطُّوا بُولِسْ تَحْتْ العَسَّة، آمَا تْكُونْ عَنْدُو شْوَيِّةْ حُرِّيَّة ويْخَلِّيوْ صْحَابُو يْزُورُوهْ ويِتِلْهَاوْ بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","وبَعْدْ أَيَّامَاتْ جَاء فِيلِكْسْ ومْعَاهْ مَرْتُو دْرُوسِيلَا، وكَانِتْ يْهُودِيَّة، يَاخِي اسْتَدْعَى بُولِسْ وسَمْعُو يَحْكِي عَالإِيمَانْ بِالمَسِيحْ يَسُوعْ. ");
INSERT INTO aeu_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","وَقْتِلِّي بْدَا بُولِسْ يَحْكِي عَالصَّلَاحْ والرْزَانَةْ ويُومْ الحْسَابْ، خَافْ فِيلِكْسْ وقَالُّو: «إِمْشِي تَوَّا، وكِي يِبْدَا عَنْدِي وَقْتْ تَوْ نْعَيِّطْلِكْ». ");
INSERT INTO aeu_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","وكَانْ عَنْدُو أَمَلْ إِنُّو بُولِسْ يَعْطِيهْ فْلُوسْ فَمَّاشْ مَا يْسَيْبُو. هَاذَاكَا عْلَاشْ كَانْ يْمَشِّي فِيهْ ويْجِيبْ بَاشْ يَحْكِي مْعَاهْ . ");
INSERT INTO aeu_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","وبَعْدْ عَامِينْ عَالحَالَة هَاذِي، خْذَى بُورْكِيُوسْ فَسْتُوسْ بُقْعِةْ فِيلِكْسْ. وعْلَى خَاطِرْ فِيلِكْسْ حَبْ يْرَضِّي اليْهُودْ، خَلَّى بُولِسْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","ثْلَاثَة أَيَّامْ بَعْدْمَا وَلَّى فَسْتُوسْ وَالِي، مْشَى مِنْ قَيْصَرِيَّة لْأُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","وجَاوْهْ كْبَارْ الكَهَنَةْ وأَعْيَانْ اليْهُودْ وشْكَاوْ بْبُولِسْ، ");
INSERT INTO aeu_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","وطَلْبُوا مِنُّوا بَاشْ يَعْمِلْ عْلِيهُمْ مْزِيَّةْ ويْرَجَّعْ بُولِسْ لْأُورْشَلِيمْ، عْلَى خَاطِرْهُمْ كَانُوا عَامْلِينْلُو خُطَّة بَاشْ يُقْتْلُوهْ فِي الثْنِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","جَاوِبْهُمْ فَسْتُوسْ بِلِّي بُولِسْ بِشْ يِبْقَى تَحْتْ الحِرَاسَةْ فِي قَيْصَرِيَّة، ولِّي هُوَّ بِيدُو بِشْ يِرْجْعِلْهَا عْلَى قْرِيبْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","وقَالْ: «خَلِّي قَادِتْكُمْ يِمْشِيوْ مْعَايَا. وإِذَا كَانْ الرَّاجِلْ هَاذَا مُذْنِبْ مَا عْلِيهُمْ كَانْ يِشْكِيوْ بِيهْ قُدَّامِي». ");
INSERT INTO aeu_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","وعَدَّى فَسْتُوسْ مْعَاهُمْ يْجِي ثْمَنْيَة وَلَّا عَشْرَة أَيَّامْ، ورْجَعْ لْقَيْصَرِيَّة. ومِنْ غُدْوَة قْعَدْ عْلَى كُرْسِيهْ فِي المَحْكْمَة، وعْطَى أَمْرْ بَاشْ يْجِيبُوا بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","ووَقْتِلِّي جَاء، دَارُوا بِيهْ اليْهُودْ الِّي جَاوْ مِنْ أُورْشَلِيمْ، وتِهْمُوهْ بْبَرْشَة تُهَمْ خْطِيرَة مَا نَجْمُوشْ يِثْبْتُوهَا عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","ودَافِعْ بُولِسْ عْلَى رُوحُو وقَالْ: «آنَا مَا عْمَلْتْ حَتَّى ذَنْبْ فِي حَقْ شَرِيعِةْ اليْهُودْ، ولَا فِي حَقْ الهَيْكِلْ ولَا القَيْصِرْ». ");
INSERT INTO aeu_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","لَكِنْ فَسْتُوسْ حَبْ يْرَضِّي اليْهُودْ، يَاخِي سْإِلْ بُولِسْ: «تْحِبْشِي تِمْشِي لْأُورْشَلِيمْ، وتِتْحَاكِمْ قُدَّامِي عَالتُّهَمْ هَاذُمْ؟». ");
INSERT INTO aeu_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","جَاوِبْ بُولِسْ: «آنَا وَاقِفْ فِي مَحْكْمِةْ القَيْصِرْ، ويِلْزِمْ نِتْحَاكِمْ فِيهَا. آنَا مَا غْلُطِّشْ فِي حَقْ اليْهُودْ وإِنْتِ تَعْرِفْ هَاذَا مْلِيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","كَانْ جِيتْ عْمَلْتْ جْرِيمَةْ تِسْتْحَقْ الإِعْدَامْ، مَا كُنْتِشْ بِشْ نِتْهَرِّبْ مِالمُوتْ. آمَا مَادَامْ التُّهَمْ مْتَاعْ النَّاسْ هَاذُومْ مَاهِيشْ صْحِيحَة، مَالَا حَتَّى حَدْ مَا عَنْدُو الحَقْ يْسَلِّمْنِي لِيهُمْ بَاشْ يْحَاكْمُونِي. آنَا بِشْ نِسْتِينِفْ دَعْوْتِي لِلْقَيْصِرْ». ");
INSERT INTO aeu_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","وتْشَاوِرْ فَسْتُوسْ مْعَ المُسْتَشَارِينْ مْتَاعُو وقَالُّو: «طْلَبْتْ بَاشْ تِسْتِينِفْ لِلْقَيْصِرْ، مَالَا بِشْ تِمْشِي لِلْقَيْصِرْ». ");
INSERT INTO aeu_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","وبَعْدْ أَيَّامَاتْ، جَاء المَلِكْ أَغْرِيبَاسْ وأُخْتُو بَرْنِيكِي لْقَيْصَرِيَّة بَاشْ يْسَلْمُوا عْلَى فَسْتُوسْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","بَعْدْمَا قَعْدُوا مُدَّة، حْكَى فَسْتُوسْ لِلمَلِكْ عْلَى قَضِيَّة بُولِسْ وقَالْ: «فَمَّة رَاجِلْ خَلَّاهْ فِيلِكْسْ فِي الحَبْسْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","وآنَا فِي أُورْشَلِيمْ، شْكَاوْ بِيهْ كْبَارْ الكَهَنَةْ وشْيُوخْ اليْهُودْ، وطَلْبُوا مِنِّي بَاشْ نُحْكُمْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","وقُلْتِلْهُمْ الِّي مُشْ مِنْ عَادِةْ الرُّومَانْ يُحْكْمُوا عْلَى وَاحِدْ، قْبَلْ مَا يِتْوَاجَهْ مْعَ الِّي شَاكِينْ بِيهْ، بَاشْ تْكُونْ عَنْدُو فُرْصَة يْدَافِعْ عْلَى رُوحُو. ");
INSERT INTO aeu_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","ووَقْتِلِّي جَاوْ مْعَايَا لْهُونِي، مَا ضَيَّعْتِشْ الوَقْتْ ومِنْ غُدْوَة عْمَلْتْ جَلْسَة فِي المَحْكْمَة، وعْطِيتْ الأَمْرْ بَاشْ يْجِيبُوهْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","وَقْتِلِّي قَابْلُوهْ الِّي شَاكِينْ بِيهْ، مَا قَالُوا حَتَّى تُهْمَة مِالتُّهَمْ الِّي كُنْتْ مِتْوَقَّعْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","آمَا نَاقْشُوهْ فِي حَاجَاتْ تْخُصْ دِينْهُمْ، وتْخُصْ رَاجِلْ إِسْمُو يَسُوعْ، مَاتْ وبُولِسْ يْقُولْ الِّي هُوَّ حَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","يَاخِي حِرْتْ كِيفَاشْ نُحْكُمْ فِي القَضِيَّة هَاذِي، وسْإِلْتْ بُولِسْ إِذَا كَانْ يْحِبْ يِمْشِي لْأُورْشَلِيمْ بَاشْ يِتْحَاكِمْ غَادِي. ");
INSERT INTO aeu_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","آمَا بُولِسْ طْلَبْ بَاشْ يِسْتِينِفْ قَضِيَّتُو قُدَّامْ القَيْصِرْ، وَلِّيتْ أْمَرْتْ بَاشْ يِبْقَى تَحْتْ الحِرَاسَةْ حَتَّى لِينْ نَبْعَثْهُولُو». ");
INSERT INTO aeu_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","يَاخِي قَالْ أَغْرِيبَاسْ لْفَسْتُوسْ: «مَذَابِيَّا نِسْمْعُوا الرَّاجِلْ هَاذَا». جَاوْبُو: «غُدْوَة تِسْمْعُو». ");
INSERT INTO aeu_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","ومِنْ غُدْوَة، جَاء المَلِكْ أَغْرِيبَاسْ وبَرْنِيكِي فِي مَوْكِبْ عْظِيمْ، ودَخْلُوا لِلمَحْكْمَةْ دَايْرِينْ بِيهُمْ قَادِةْ العَسْكِرْ وأَعْيَانْ المْدِينَة. وفَسْتُوسْ عْطَى الأَمْرْ بَاشْ يْجِيبُوا بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","وقَالْ فَسْتُوسْ: «يَا أَغْرِيبَاسْ المَلِكْ، ويَلِّي حَاضْرِينْ مْعَانَا الكُلْ، قُدَّامْكُمْ الرَّاجِلْ الِّي شْكَاوْ بِيهْ اليْهُودْ الكُلْ فِي أُورْشَلِيمْ وهْنَا، وكَانُوا يْصِيحُوا: \"مَا يِلْزْمُوشْ يِبْقَى حَيْ\". ");
INSERT INTO aeu_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","آمَا آنَا شُفْتْ الِّي هُوَّ مَا عْمَلْ حَتَّى شَيْ يِسْتْحَقْ عْلِيهْ المُوتْ. آمَا هُوَّ اسْتِينِفْ دَعْوْتُو لْجَلَالِةْ القَيْصِرْ، وآنَا قَرَّرْتْ نَبْعِثْهُولُو. ");
INSERT INTO aeu_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","آمَا مَا عَنْدِيشْ حَاجَة وَاضْحَة نِكْتِبْهَا لِلْقَيْصِرْ. هَاذَاكَا عْلَاشْ جِبْتُو قُدَّامْكُمْ وبِالأَخَصْ قُدَّامِكْ إِنْتِ يَا المَلِكْ أَغْرِيبَاسْ، بَاشْ نَلْقَى شْنُوَّة نِكْتِبْ بَعْدْمَا يِتْحَقِّقْ مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","عْلَى خَاطِرْ مُشْ مَعْقُولْ نِبْعَثْ مَرْبُوطْ، مِنْ غِيرْ مَا نِكْتِبْ بَاشْ تَاهْمِينُو بِالضَّبْطْ». ");
INSERT INTO aeu_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","وقَالْ أَغْرِيبَاسْ لْبُولِسْ: «مَسْمُوحْلِكْ بَاشْ ادَّافِعْ عْلَى رُوحِكْ». يَاخِي مَدْ بُولِسْ يِدُّو وِبْدَا يْدَافِعْ وقَالْ: ");
INSERT INTO aeu_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«يَا حَضْرِةْ المَلِكْ أَغْرِيبَاسْ! آنَا فَرْحَانْ الِّي بِشْ نْدَافِعْ عْلَى رُوحِي قُدَّامِكْ ضِدْ التُّهَمْ الِّي تِهْمُونِي بِيهَا اليْهُودْ، ");
INSERT INTO aeu_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","خَاصَّةً إِنِّكْ تَعْرِفْ بِالڨْدَا عَادَاتْهُمْ والحَاجَاتْ الِّي يِتْخَالْفُوا فِيهَا. وآنَا نِتْمَنَّى إِنِّكْ تْوَسَّعْ بَالِكْ وتِسْمَعْنِي لِلِّخِّرْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","«اليْهُودْ الكُلْ يَعْرْفُوا سِيرْتِي مِلِّي آنَا صْغِيرْ، ويَعْرْفُوا الِّي آنَا تْرَبِّيتْ بِينْ شَعْبِي فِي أُورْشَلِيمْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","وهُومَا يَعْرْفُونِي مِنْ وَقْتْ طْوِيلْ، وكَانْ حَبُّوا، يْنَجْمُوا يِشْهْدُوا الِّي آنَا كُنْتْ فِرِّيسِي تَابَعْ لْأَكْثِرْ مَذْهَبْ مِتْشَدِّدْ فِي دِينْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","وآنَا اليُومْ قَاعِدْ نِتْحَاكِمْ عْلَى خَاطِرْ عَنْدِي رْجَى فِي الوَعْدْ الِّي اللَّهْ وْعِدْ بِيهْ جْدُودْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","وعْرُوشَاتْ شَعْبْنَا الأَثْنَاشْ عَنْدْهُمْ رْجَى إِنُّو الوَعْدْ هَاذَا بِشْ يِتْحَقِّقْ، هَاذَاكَا عْلَاشْ مَزَّالُوا يْدَاوْمُوا عَالعِبَادَة لِيلْ مْعَ نْهَارْ. واليْهُودْ، يَا سِيدْنَا المَلِكْ، قَاعْدِينْ يِتْهْمُوا فِيَّا وبِسْبَبْ الرْجَى هَاذَا. ");
INSERT INTO aeu_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","مَالَا عْلَاشْ مَا تْصَدْقُوشْ الِّي اللَّهْ يْقَوِّمْ المُوتَى؟ ");
INSERT INTO aeu_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","«آنَا بِيدِي كُنْتْ مُقْتَنَعْ الِّي يِلْزِمْنِي نَعْمِلْ كُلْ جِهْدِي بَاشْ نْقَاوِمْ إِسْمْ يَسُوعْ النَّاصْرِي. ");
INSERT INTO aeu_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","وهَاذَا آشْ عْمَلْتْ فِي أُورْشَلِيمْ. حَطِّيتْ بَرْشَة قِدِّيسِينْ فِي الحَبْسْ بْتَفْوِيضْ مِنْ كْبَارْ الكَهَنَةْ، وكُنْتْ دِيمَا نْوَافِقْ وَقْتِلِّي يِتْحْكَمْ عْلِيهُمْ بِالإِعْدَامْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","وعَذَّبْتْهُمْ بَرْشَة فِي المْعَابِدْ الكُلْ فَمَّاشْ مَا يَكْفْرُوا، وكُنْتْ نَاقِمْ عْلِيهُمْ لْدَرْجِة إِنِّي وَلِّيتْ شَادِدْ جُرِّتْهُمْ حَتَّى لْبَرَّا مِالبْلَادْ». ");
INSERT INTO aeu_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«وفِي سَفْرَة مِالسَّفْرَاتْ هَاذُوكُمْ، كُنْتْ فِي طْرِيقِي لْدِمَشْقْ بَعْدْمَا خْذِيتْ سُلْطَةْ وتَفْوِيضْ مِنْ عَنْدْ كْبَارْ الكَهَنَة. ");
INSERT INTO aeu_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","مْعَ نُصْ النْهَارْ وآنَا فِي الطْرِيقْ، شُفْتْ يَا سِيدْنَا المَلِكْ، نُورْ سَاطَعْ مِالسْمَاء أَقْوَى مِنْ نُورْ الشَّمْسْ، دَايِرْ بِيَّا وبِلِّي مْعَايَا. ");
INSERT INTO aeu_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","يَاخِي طُحْنَا الكُلْ فِي القَاعَة، وسْمَعْتْ صُوتْ يْقُلِّي بِاللُّوغَة العِبْرِيَّة: \"شَاوُلْ! شَاوُلْ! عْلَاشْ تِضْطَهِدْ فِيَّا؟ كِي تْقَاوِمْنِي رَاكْ تَاذِي فِي رُوحِكْ!\". ");
INSERT INTO aeu_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","يَاخِي سْإِلْتْ: \"شْكُونْ إِنْتِ يَا رَبْ؟\". جَاوِبْنِي الرَّبْ: \"آنَا يَسُوعْ الِّي إِنْتِ تِضْطَهِدْ فِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","قُومْ آقِفْ عْلَى سَاقِيكْ، آنَا ظْهُرْتْلِكْ بَاشْ نْرُدِّكْ خَادِمْ لِيَّا وشَاهِدْ عَالرُّؤْيَا الِّي رِيتْنِي فِيهَا تَوَّا، ولْغِيرْهَا مِلِّي بِشْ نْوَرِّيهُمْلِكْ مْبَعِّدْ، ");
INSERT INTO aeu_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","وبِشْ نْمَنْعِكْ مِنْ شَعْبِكْ ومِالشُّعُوبْ الأُخْرَى الِّي بِشْ نِبْعْثِكْ لِيهُمْ، ");
INSERT INTO aeu_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","بَاشْ تْحِلِّلْهُمْ عِينِيهُمْ وتْخَرِّجْهُمْ مِالظْلَامْ لِلنُّورْ، ومِنْ سُلْطِةْ الشِّيطَانْ لْسُلْطِةْ اللَّهْ بَاشْ تِتْغْفِرْ ذْنُوبْهُمْ، ويُورْثُوا مْعَ القِدِّيسِينْ المُؤْمْنِينْ بِيَّا\". ");
INSERT INTO aeu_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«ومِنْ وَقْتْهَا، يَا حَضْرِةْ المَلِكْ أَغْرِيبَاسْ، مَا جِيتِشْ ضِدْ الرُّؤْيَا الِّي مِالسْمَاء. ");
INSERT INTO aeu_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","وبَشِّرْتْ فِي الأُوِّلْ فِي دِمَشْقْ، ومْبَعِّدْ فِي أُورْشَلِيمْ واليَهُودِيَّة ولِّي مَاهُمْشْ يْهُودْ، وشَجَّعْتْهُمْ بَاشْ يْتُوبُوا ويِرْجْعُوا لِلَّهْ ويْخَلِّيوْ تُوبِتْهُمْ تُظْهِرْ فِي أَفْعَالْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","هَاذَاكَا عْلَاشْ شَدُّونِي اليْهُودْ فِي الهَيْكِلْ وحَبُّوا يُقْتْلُونِي. ");
INSERT INTO aeu_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","آمَا اللَّهْ حْفَظْنِي حَتَّى لِلْيُومْ، وعَاوِنِّي بَاشْ نَاقِفْ نِشْهِدْلُو قُدَّامْ الصْغِيرْ والكْبِيرْ، ومَا نْقُولْ كَانْ الِّي تْنَبَّأْ بِيهْ مُوسَى والأَنْبِيَاءْ، ");
INSERT INTO aeu_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","وهُوَّ إِنُّو المَسِيحْ بِشْ يِتْعَذَّبْ، ويْكُونْ أَوِّلْ وَاحِدْ يْقُومْ مِالمُوتْ، ويْبَشِّرْ بِالنُّورْ شَعْبْنَا والشْعُوبْ الأُخْرَى». ");
INSERT INTO aeu_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","ودُوبْ مَا قَالْ بُولِسْ الكْلَامْ هَاذَا، قَصْ عْلِيهْ فَسْتُوسْ وقَالْ بْصُوتْ عَالِي: «إِنْتِ هْبِلْتْ يَا بُولِسْ! كَثْرِةْ العِلْمْ الِّي عَنْدِكْ هَبْلِتِّكْ!». ");
INSERT INTO aeu_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","جَاوْبُو بُولِسْ: «آنَا مَانِيشْ مَهْبُولْ يَا حَضْرِةْ الحَاكِمْ فَسْتُوسْ. آنَا نْقُولْ فِي كْلَامْ صْحِيحْ ومَعْقُولْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","والمَلِكْ الِّي آنَا نْكَلِّمْ فِيهْ تَوَّا بْصَرَاحَة، يَعْرِفْ الأُمُورْ هَاذِي، وآنَا مِتْأَكِّدْ الِّي مَا يَخْفَى عْلِيهْ شَيْ مِنْهَا، عْلَى خَاطِرْهَا مَا صَارِتْشْ فِي التْرَاكِنْ المْخُبْيَةْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","يَا حَضْرِةْ المَلِكْ أَغْرِيبَاسْ، يَاخِي إِنْتِ تَمِّنْ بِالأَنْبِيَاءْ؟ آنَا نَعْرِفْ الِّي إِنْتِ تَمِّنْ بِيهُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","جَاوِبْ أَغْرِيبَاسْ بُولِسْ: «يَاخِي فِي الوَقْتْ القْصِيرْ هَاذَا تْحِبْ تَقْنَعْنِي بَاشْ نْوَلِّي مَسِيحِي!». ");
INSERT INTO aeu_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","قَالْ بُولِسْ: «وَقْتْ طْوِيلْ وَلَّا قْصِيرْ، آنَا رَانِي نُطْلُبْ فِي رَبِّي بَاشْ إِنْتِ ولِّي يِسْمْعُوا فِيَّا الكُلْ تْوَلِّيوْ كِيفِي، آمَا مِنْ غِيرْ السْلَاسِلْ هَاذِي». ");
INSERT INTO aeu_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","يَاخِي قَامْ المَلِكْ والحَاكِمْ وبَرْنِيكِي ولِّي كَانُوا قَاعْدِينْ مْعَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","وقَالُوا لِبْعَضْهُمْ وهُومَا خَارْجِينْ: «الرَّاجِلْ هَاذَا مَا عْمَلْ حَتَّى شَيْ يِسْتْحَقْ عْلِيهْ المُوتْ وَلَّا الحَبْسْ». ");
INSERT INTO aeu_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","وقَالْ أَغْرِيبَاسْ لْفَسْتُوسْ: «لَوْ كَانْ مَا اسْتِينِفْشْ لِلْقَيْصِرْ، الرَّاجِلْ هَاذَا كَانْ يْنَجِّمْ يِمْشِي عْلَى رُوحُو». ");
INSERT INTO aeu_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","وكِي تْقَرَّرْ إِنُّو نْسَافْرُوا لْإِيطَالْيَا عْلَى طْرِيقْ البْحَرْ، سَلْمُوا بُولِسْ ومْعَاهْ مْرَابِيطْ أُخْرِينْ لْضَابِطْ إِسْمُو يُولْيُوسْ تَابَعْ لْفِرْقِةْ أُوغُسْطُسْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","ورْكِبْنَا فِي سْفِينَة جَايَة مِنْ بُرْطْ أَدْرَامِيتْ ومَاشْيَة لِلمَوَانِي الِّي عْلَى شْطُوطْ آسِيَّا، وكَانْ مْعَانَا أَرِسْتَرْخُسْ مِنْ تْسَالُونِيكِي الِّي فِي مَنْطَقْةْ مَقْدُونِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","ومِنْ غُدْوَة وْصِلْنَا لْصَيْدَا. وكَانْ يُولْيُوسْ يْعَامِلْ فِي بُولِسْ بِالبَاهِي، وخَلَّاهْ يْزُورْ صْحَابُو بَاشْ يَاخُذْ مِنْ عَنْدْهُمْ الِّي يِحْتَاجُو. ");
INSERT INTO aeu_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","وبَحَّرْنَا مِنْ غَادِي، وجِبْنَا عْلَى شْطُوطْ قُبْرُصْ، خَاطِرْ الرِّيحْ كَانِتْ عَكْسْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","وتْعَدِّينَا فِي البْحَرْ بِجْنَبْ كِيلِيكِيَّة وبَمْفِيلِيَّة، ووْصُلْنَا لْبُرْطْ مِيرَا فِي مَنْطَقْةْ لِيكِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","ولْقَى الضَّابِطْ غَادِي سْفِينَة جَايَة مِالإِسْكَنْدَرِيَّة ومَاشْيَة لْإِيطَالْيَا، يَاخِي طْلَعْنَا فِيهَا. ");
INSERT INTO aeu_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","وقَعْدِتْ السْفِينَة مُدَّة وهِيَّ تِمْشِي بِينَا بِالشْوَيَّة بِالشْوَيَّة. تْعِبْنَا بَرْشَةْ بَاشْ وْصِلْنَا لِمْدِينِةْ كِنِيدُسْ، وكِيفْ الرِّيحْ مَا خَلَّاتْنَاشْ نُدْخْلُوا لِلبُرْطْ، وَلِّينَا سَافِرْنَا قْرِيبْ مِنْ شْطُوطْ جَزِيرِةْ كْرِيتْ وتْعَدِّينَا مِنْ بَحْذَا رَاسْ سَلْمُونِي. ");
INSERT INTO aeu_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","وبِصْعُوبَة كْبِيرَة وْصِلْنَا لْبُقْعَة تِتْسَمَّى المَوانِي الجْمِيلَة، قْرِيبَة مِنْ مْدِينِةْ لَسَائِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","وضَاعْ عْلِينَا بَرْشَة وَقْتْ، وحَتَّى مِنْ وَقْتْ الصْيَامْ تْعَدَّى ووَلَّى السْفَرْ فِي البْحَرْ مُخْطِرْ، يَاخِي بُولِسْ نَبَّهُّمْ ");
INSERT INTO aeu_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","وقَالْ: «يَا رْجَالْ، آنَا نْرَى الِّي السْفَرْ تَوَّا مُخْطِرْ، وفِيهْ خْسَارَة كْبِيرَة، مُشْ عَالسْفِينَة ولِّي فِيهَا بَرْكْ، آمَا زَادَا عْلَى حْيَاتْنَا». ");
INSERT INTO aeu_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","آمَا الضَّابِطْ إِقْتَنَعْ بِكْلَامْ رَايِّسْ السْفِينَة وبِكْلَامْ مُولَاهَا أَكْثِرْ مِنْ كْلَامْ بُولِسْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","وبِمَا إِنُّو البُرْطْ مَا يُصْلُحْشْ بَاشْ نْشَتِّيوْ فِيهْ، الأَكْثَرِيَّةْ قَرْرُوا يْكَمْلُوا يْسَافْرُوا فَمَّاشْ مَا يُوصْلُوا لْبُرْطْ فِينِكْسْ ويْعَدِّيوْ الشْتَاء غَادِي، والبُرْطْ هَاذَا كَانْ فِي جَزِيرِةْ كْرِيتْ مْقَابِلْ الجَنُوبْ الغَرْبِي والشَّمَالْ الْغَرْبِي. ");
INSERT INTO aeu_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","وكِي هَبِّتْ رِيحْ خْفِيفَة مِالجَنُوبْ، مْشَى فِي بَالْهُمْ إِنُّو الِّي حَبُّوا عْلِيهْ صَارْ، يَاخِي طَلّْعُوا مَرْسَاةْ السْفِينَة وبَحْرُوا بِجْنَبْ جَزِيرَةْ كْرِيتْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","آمَا بَعْدْهَا بِشْوَيَّة هَبِّتْ مِالجَزِيرَة رِيحْ قْوِيَّة يْسَمِّيوْهَا الشَّمَالِيَّة الشَّرْقِيَّة. ");
INSERT INTO aeu_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","وضَرْبِتْ السْفِينَة حَتَّى لِينْ مَا عَادِشْ تْنَجِّمْ تْقَاوِمْهَا. يَاخِي سَلِّمْنْا وخَلِّينَا الرِّيحْ تْهِزْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","وتْعَدِّينَا قْرِيبْ مِنْ جَزِيرَة صْغِيرَة إِسْمْهَا كُودَا. وبِالسِّيفْ مَا نَجِّمْنَا نْطَلْعُوا فْلُوكِةْ النَّجْدَةْ فُوقْ السْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","وبَعْدْ فِيسَعْ خْذَاوْ الإِحْتِيَاطَاتْ اللَّازْمَة ورَبْطُوا السْفِينَة مِالوِسْطْ بِالحْبَالْ. وعْلَى خَاطِرْهُمْ خَافُوا لَا يُصْدْمُوا فِي رْمَلْ شَطْ سِيرْتِسْ، هَبّْطُوا القْلَاعَاتْ وخَلَّاوْ السْفِينَة هَازِزْهَا الرِّيحْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","وفِي النْهَارْ الثَّانِي قْوَاتْ عْلِينَا الرِّيحْ، وبْدَاوْ يْنَقْصُوا مِالسِّلْعَة الِّي هَازِّتْهَا السْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","وفِي النْهَارْ الثَّالِثْ، هُومَا بِيدِيهُمْ رْمَاوْ مَاعُونْ السْفِينَة فِي البْحَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","تْعَدَّاتْ أَيَّامَاتْ، مَا رِينَا فِيهَا لَا شَمْسْ ولَا نْجُومْ، والعَاصْفَةْ مَاشْيَة وتَقْوَى، ومَا عَادْ عَنْدْنَا حَتَّى أَمَلْ بَاشْ نَمْنْعُوا. ");
INSERT INTO aeu_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","وكَانُوا المْسَافْرِينْ مْبَطْلِينْ المَاكْلَة مِنْ مُدِّة طْوِيلَة، وْقِفْ بُولِسْ فِي وُسْطْهُمْ وقَالْ: «يَا رْجَالْ، كَارْكُمْ سْمَعْتُوا كْلَامِي ومَا سَافِرْتُوشْ مِنْ كْرِيتْ، وَلَّا رَاكُمْ مْنَعْتُوا مِالخْطَرْ والخْسَايِرْ هَاذُمْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","آمَا تَوَّا نُطْلُبْ مِنْكُمْ بَاشْ تِتْشَجْعُوا. رَاهُو حَتَى وَاحِدْ فِيكُمْ مَا بِشْ يِخْسِرْ حْيَاتُو. آمَا بِشْ نِخْسْرُوا السْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","عْلَى خَاطِرْ فِي اللِّيلَة الِّي فَاتِتْ ظْهُرْلِي مَلَاكْ مِنْ عَنْدْ إِلَاهِي الِّي آنَا نِعْبِدْ فِيهْ، ");
INSERT INTO aeu_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","وقَالِّي: \"مَا تْخَافِشْ يَا بُولِسْ. رَاكْ لَازْمِكْ تَاقِفْ قُدَّامْ القَيْصِرْ. وعْلَى خَاطْرِكْ، اللَّهْ بَاشْ يْمَنَّعْ المْسَافْرِينْ الِّي مْعَاكْ الكُلْ\". ");
INSERT INTO aeu_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","مَالَا تْهَنَّاوْ يَا رْجَالْ، عْلَى خَاطِرْ عَنْدِي إِيمَانْ بِاللَّهْ ولِّي قَالْهُولِي بِشْ يْصِيرْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","عْلَى خَاطِرْ أَكِيدْ السْفِينَة تِصْطَعْ فِي جَزِيرَة مِالجُزُرْ». ");
INSERT INTO aeu_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","وفِي لِيلِةْ أَرْبَعْطَاشْ، كُنَّا ضَايْعِينْ والرِّيحْ تْهِزْ فِينَا وتْجِيبْ فِي بْحَرْ أَدْرِيَا. ومْعَ نُصْ اللِّيلْ، البَحَّارَة مْشَى فِي بَالْهُمْ الِّي هُومَا قُرْبُوا مِالبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","قَاسُوا غُرْقْ المَاء لْقَاوْهْ 37 مِيتْرُو، وبَعْدْ شْوَيَّة قَاسُوا مَرَّة أُخْرَى لْقَاوْهْ 28 مِيتْرُو. ");
INSERT INTO aeu_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","وخَافُوا لَا السْفِينَة تُصْدُمْ فِي الحْجَرْ، وَلَّاوْ رْمَاوْ أَرْبْعَة مْخَاطِفْ مِنْ تَالِي، وقَعْدُوا يِسْتَنَّاوْ فِي طْلُوعْ النْهَارْ بِالدْقِيقَة والدْرَجْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","وحَاوْلُوا البَحَّارَة بَاشْ يُهْرْبُوا مِالسْفِينَة، يَاخِي هَبّْطُوا فْلُوكِةْ النَّجْدَةْ زَعْمَة زَعْمَة بَاشْ يَرْمِيوْ المْخَاطِفْ مِالقُدَّامْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","يَاخِي قَالْ بُولِسْ لِلضَّابِطْ ولِلْعَسْكَرْ: «إِذَا كَانْ هَاذُمْ مَا يَبْقَاوِشْ فِي السْفِينَة، رَاكُمْ مَاكُمْشْ بِشْ تَمْنْعُوا». ");
INSERT INTO aeu_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","يَاخِي قَصُّوا العَسْكِرْ حْبَالْ الفْلُوكَة وخَلَّاوْهَا اطِّيحْ فِي المَاء. ");
INSERT INTO aeu_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","وكِي قْرِيبْ يِطْلَعْ النْهَارْ، طْلَبْ بُولِسْ مِالنَّاسْ الكُلْ بَاشْ يَاكْلُوا وقَالْ: «تْعَدَّاوْ أَرْبَعْطَاشِنْ يُومْ وإِنْتُومَا تِسْتَنَّاوْ مِنْ غِيرْ مَا كْلِيتُوا شَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","وآنَا نُطْلُبْ مِنْكُمْ بَاشْ تَاكْلُوا، عْلَى خَاطِرْ هَاذَا يْعَاوِنْكُمْ بَاشْ تِمْنْعُوا، ومُشْ بِشْ تِتْمَسْ حَتَّى شَعْرَة مِنْ رَاسْ حَتَّى وَاحِدْ مِنْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","مْبَعِّدْ خْذَا الخُبْزْ وشْكَرْ اللَّهْ قُدَّامْ النَّاسْ الكُلْ، وقَسْمُو وبْدَا يَاكِلْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","يَاخِي الكُلْهُمْ طْمَانُوا وكْلَاوْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","وكُنَّا 276 وَاحِدْ فِي السْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","وبَعْدْمَا شَبْعُوا، رْمَاوْ القَمْحْ فِي البْحَرْ بَاشْ يْخَفْفُوا عَالسْفِينَة. ");
INSERT INTO aeu_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","وكِي طْلَعْ النْهَارْ، مَا عَرْفُوشْ البَحَّارَة الْأَرْضْ الِّي وِصْلُولْهَا، آمَا شَافُوا خَلِيجْ فِيهْ شَطْ رْمَلْ، يَاخِي قَرْرُوا بِشْ يِرْسِيوْ السْفِينَة فِيهْ كَانْ يْنَجْمُوا. ");
INSERT INTO aeu_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","وقَصُّوا المْخَاطِفْ وخَلَّاوْهُمْ يُغْرْقُوا. وحَلُّوا الحْبَالْ الِّي تُرْبِطْ الدَّفَّة، وطَلّْعُوا القْلَاعْ القُدَّامِي وقَبّْلُوهْ لِلرِّيحْ وقَصْدُوا الشَّطْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","آمَا السْفِينَةْ صُدْمِتْ فِي بْلَاصَة فِي البْحَرْ رْمَلْهَا عَالِي. وْحِلْ نُصْهَا القُدَّامِي فِي الرْمَلْ ومَا عَادِشْ يِتْحَرِّكْ، ونُصْهَا التِّيلَانِي قْعَدْ يِتْكَسِّرْ مِنْ قُوِّةْ المُوجْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","والعَسْكِرْ حَبُّوا يُقْتْلُوا المْرَابِيطْ بَاشْ حَتَّى وَاحِدْ مِنْهُمْ مَا يْعُومْ لِلشَّطْ ويُهْرُبْ. ");
INSERT INTO aeu_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","آمَا الضَّابِطْ كَانْ يْحِبْ يْمَنَّعْ بُولِسْ، وَلَّى مَا خَلَّاهُمْشْ يَعْمْلُوا الِّي فِي بَالْهُمْ. وعْطَى أَمْرْ لِلِّي يَعْرْفُوا يْعُومُوا بَاشْ يْنَڨْزُوا هُومَا الأُولَانِينْ ويْعُومُوا لِلشَطْ قْبَلْ الأُخْرِينْ، ");
INSERT INTO aeu_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","والبْقِيَّة يْحَاوْلُوا بَاشْ يَخْلْطُوا عْلِيهُمْ عَاللُّوحْ وَلَّا عْلَى قْطَايِعْ السْفِينَة. وهَكَّا وُصْلُوا الكُلْ سَالْمِينْ لِلبَرْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","وبَعْدْمَا مْنَعْنَا، عْرَفْنَا الِّي الجَزِيرَةْ الِّي وْصِلْنَالْهَا هِيَّ جَزِيرِةْ مَالْطَة. ");
INSERT INTO aeu_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","وامَّالِيهَا كَانُوا بَاهِينْ مْعَانَا بَرْشَة. فَرْحُوا بِينَا وشَعْلُولْنَا النَّارْ عْلَى خَاطِرْ الطَّقْسْ كَانْ بَارِدْ والمْطَرْ تْصُبْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","ولَمْ بُولِسْ حِزْمَةْ حْطَبْ ورْمَاهَا فِي النَّارْ، يَاخِي بِالسْخَانَة خَرْجِتْلُو لَفْعَى وتْلَفِّتْ عْلَى يِدُّو. ");
INSERT INTO aeu_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","وكِي شَافُوا الِّي يُسْكْنُوا فِي مَالْطَة اللَّفْعَى شَادَّة فِي يِدُّو، قَالُوا لِبْعَضْهُمْ: «الرَّاجِلْ هَاذَا مَا يْكُونْ كَانْ قَاتِلْ رُوحْ، حَتَّى بَعْدْمَا مْنَعْ مِالبْحَرْ، العَدَالَةْ مَا خَلَّاتُوشْ يْعِيشْ». ");
INSERT INTO aeu_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","آمَا بُولِسْ رْمَى اللَّفْعَى فِي النَّارْ مِنْ غِيرْ مَا عَمْلِتْلُو حَتَّى شَيْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","وقَعْدُوا يِسْتَنَّاوْ فِيهْ بَاشْ يِتْنْفَخْ وَلَّا يْطِيحْ يْمُوتْ. آمَا كِي سْتَنَّاوْ وَقْتْ طْوِيلْ ومَا جْرَالُو شَيْ، بَدْلُوا رَايْهُمْ وقَالُوا: «هَاذَا إِلَاهْ». ");
INSERT INTO aeu_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","وقْرِيبْ مِنْ البُقْعَة هَاذِيكَا كَانْ فَمَّة سْوَانِي تَابْعَة لْحَاكِمْ الجَزِيرَة بُوبْلْيُوسْ، الِّي فْرَحْ بِينَا فِي دَارُو وضَيَّفْنَا ثْلَاثَة أَيَّامْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","وكَانْ بُوبْلْيُوسْ رَاقِدْ فِي الفَرْشْ مْرِيضْ بِالسْخَانَة وعَنْدُو جَرْيَانْ جُوفْ قْوِيْ، يَاخِي مْشَالُو بُولِسْ وصَلَّى، وحَطْ عْلِيهْ يْدِيهْ وشْفَاهْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","وكِي صَارْ هَاذَا، جَاوَهْ المُرْضَى الِّي فِي الجَزِيرَة الكُلْ وتِشْفَاوْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","وفَرْحُوا بِينَا بِالڨْدَا، وكِي جِينَا مْسَافْرِينْ، عْطَاوْنَا كُلْ الِّي نِسْتْحَقُّولُو فِي سْفَرْنَا. ");
INSERT INTO aeu_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","وبَعْدْ ثْلَاثَة شْهُرْ، رْكِبْنَا فِي سْفِينَة مِالإِسْكَنْدَرِيَّة، عَدَّاتْ شْتَاءْ كَامِلْ فِي مَالْطَة، وكَانِتْ عْلِيهَا عَلَامِةْ الآلْهَة التْوَامَة. ");
INSERT INTO aeu_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","وكِي وْصِلْنَا لْسِرَاكُوسَا قْعَدْنَا فِيهَا ثْلَاثَة أَيَّامْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","مْبَعِّدْ قَعْدِتْ السْفِينَة تِمْشِي قْرِيبْ مِالشَّطْ حَتَّى لِينْ وْصِلْنَا لِمْدِينِةْ رِيغِيُونْ. مِنْ غُدْوَة هَبِّتْ رِيحْ جَنُوبِيَّة دَزِّتْ السْفِينَة، وفِي نْهَارِينْ وْصِلْنَا لِمْدِينِةْ بُوطْيُولِي. ");
INSERT INTO aeu_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","وغَادِي قَابِلْنَا جْمَاعَة مِالإِخْوَة، طَلْبُوا مِنَّا بَاشْ نُقْعْدُوا عَنْدْهُمْ سَبْعَة أَيَّامْ. وهَكَّا وْصِلْنَا لْرُومَا. ");
INSERT INTO aeu_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","كِي سَمْعُوا بِينَا الإِخْوَة جِينَا، سَافْرُوا حَتَّى لْسُوقْ أَبِيُّوسْ ولِبْلَاصِةْ الثْلَاثَة وِكَالَاتْ بَاشْ يِسْتَقْبْلُونَا. ووَقْتِلِّي شَافْهُمْ بُولِسْ شْكَرْ اللَّهْ وتْشَجَّعْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","كِي وْصِلْنَا لْرُومَا، الضَّابِطْ خَلَّى بُولِسْ يُسْكُنْ فِي دَارْ وَحْدُو ومْعَاهْ العَسْكْرِي الِّي يْعِسْ عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","وبَعْدْ ثْلَاثَة أَيَّامْ اسْتَدْعَى بُولِسْ قَادِةْ اليْهُودْ وقَالِلْهُمْ: «يَا خْوَاتِي، آنَا مَا عْمَلْتْ حَتَّى شَيْ ضِدْ الشَّعْبْ ولَا ضِدْ عَادَاتْ جْدُودْنَا، ورَغْمْ هَاذَاكَا شَدُّونِي فِي أُورْشَلِيمْ وسَلْمُونِي لِلرُّومَانْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","وبَعْدْمَا الرُّومَانْ إِسْتَجْوْبُونِي، حَبُّوا يْسَيْبُونِي عْلَى خَاطِرْنِي مَا عْمَلْتْ شَيْ نِسْتْحَقْ عْلِيهْ المُوتْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","آمَا اليْهُودْ مَا وَافْقُوشْ، وتْلَزِّيتْ بَاشْ نَرْفَعْ قَضِيْتِي لِلْقَيْصِرْ. آمَا هَاذَا مَا يِعْنِيشْ الِّي آنَا قَاعِدْ نِشْكِي بْشَعْبِي. ");
INSERT INTO aeu_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","هَاذَاكَا عْلَاشْ حَبِّيتْ نْشُوفْكُمْ ونَحْكِي مْعَاكُمْ، وآنَا رَانِي مَرْبُوطْ بِالسِّلْسْلَة هَاذِي عْلَى خَاطِرْ رْجَى بَنِي إِسْرَائِيلْ». ");
INSERT INTO aeu_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","يَاخِي قَالُولُو: «مَا جَاتْنَا فِيكْ حَتَّى رِسَالَةْ مِاليَهُودِيَّة، وحَتَّى وَاحِدْ مِالإِخْوَةْ الِّي جَاوْنَا مِنْ غَادِي مَا قَالْ عْلِيكْ حَاجَة خَايْبَةْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","آمَا أَحْنَا نْحِبُّوا نِسْمْعُوا رَايِكْ إِنْتِ، عْلَى خَاطِرْ نَعْرْفُوا الِّي النَّاسْ فِي كُلْ بْلَاصَةْ يْعَارْضُوا فِي المَذْهِبْ هَاذَا». ");
INSERT INTO aeu_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","وتْفَاهْمُوا عْلَى نْهَارْ آخِرْ بَاشْ يِتْقَابْلُوا فِيهْ. وجَاوْ لْدَارُو مْعَ بَرْشَة نَاسْ، وقْعَدْ بُولِسْ مِالصْبَاحْ لِلعْشِيَّة وهُوَّ يْفَسْرِ ويِشْهِدْ عْلَى مَمْلِكْةْ اللَّهْ، ويِقْنَعْ فِيهُمْ بَحْقِيقِةْ يَسُوعْ مِنْ شَرِيعَةْ مُوسَى وكْتُبْ الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","فَمَّة الِّي مِنْهُمْ إِقْتَنَعْ بِكْلَامُو، وفَمَّة الِّي مَا حَبِّشْ يَمِّنْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","ومَا تْفَاهْمُوشْ بِينَاتْ بْعَضْهُمْ وقْبَلْ مَا يِمْشَيوْ قَالِلْهُمْ بُولِسْ: «صْدُقْ الرُّوحْ القُدُسْ وَقْتِلِّي قَالْ لِجْدُودْكُمْ عْلَى لْسَانْ النَّبِيْ إِشَعْيَاءْ: ");
INSERT INTO aeu_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","\"إِمْشِي لِلشَّعْبْ هَاذَا وقُلُّو: مَهْمَا سْمَعْتُوا، مَاكُمْشْ بِشْ تِفِهْمُوا، ومَهْمَا خْزَرْتُوا، مَاكُمْشْ بِشْ تْشُوفُوا. ");
INSERT INTO aeu_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","عْلَى خَاطِرْ الشَّعْبْ هَاذَا قَلْبُو كْسَاحْ، وسَمْعْهُمْ ثْقُلْ، وغَمْضُوا عِينِيهُمْ، بَاشْ مَا يْشُوفُوشْ بْعِينِيهُمْ، ومَا يِسْمْعُوشْ بْوِذْنِيهُمْ، ومَا يِفْهْمُوشْ بِقْلُوبْهُمْ ومَا يْتُوبُوشْ بَاشْ نِشْفِيهُمْ\". ");
INSERT INTO aeu_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","«ويْكُونْ فِي عِلْمْكُمْ الِّي اللَّهْ وَصِّلْ بْشَارِةْ النْجَاةْ لِلِّي مَاهُمْشْ يْهُودْ، وهُومَا بِشْ يِسْمْعُوهَا». ");
INSERT INTO aeu_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","ووَقْتِلِّي سَمْعُوا اليْهُودْ الكْلَامْ هَاذَا، خَرْجُوا وهُومَا يِتْنَاقْشُوا بْقُوَّة. ");
INSERT INTO aeu_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","وسْكِنْ بُولِسْ عَامِينْ كَامْلِينْ فِي الدَّارْ الِّي كْرَاهَا، وكَانْ يِفْرَحْ بِلِّي يْجِيوْ يْزُورُوهْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","وكَانْ يْبَشِّرْ بْمَمْلِكْةْ اللَّهْ، ويْعَلِّمْ عَالرَّبْ يَسُوعْ المَسِيحْ بِالجْهَارْ مِنْ غِيرْ مَا يْعَطْلُو حَدْ.");
INSERT INTO aeu_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","مِنْ بُولِسْ عَبْدْ يَسُوعْ المَسِيحْ، الِّي دْعَاهْ اللَّهْ بَاشْ يْكُونْ رَسُولْ، واخْتَارُو بَاشْ يْخَبِّرْ بِالبْشَارَة مْتَاعُو، ");
INSERT INTO aeu_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","الِّي سْبَقْ ووْعِدْ بِيهَا عْلَى طْرِيقْ أَنْبِيَاؤُو فِي الكْتُبْ المُقَدْسَة، ");
INSERT INTO aeu_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ولِّي تْخُصْ إِبْنُو الِّي مِنْ شِيرْتُو كَإِنْسَانْ، جَاء مِنْ ذُرِّيِّةْ دَاوِدْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","آمَا مِنْ شِيرِةْ رُوحْ القَدَاسَة، بَيِّنْ اللَّهْ بْقُوَّة الِّي هُوَّ إِبْنُو، وَقْتِلِّي قَيْمُو مِنْ بِينْ الأَمْوَاتْ. هُوَّ رَبْنَا يَسُوعْ المَسِيحْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","الِّي بِيهْ، ولْمَجْدْ إِسْمُو، خْذِيتْ نِعْمَة بَاشْ نْكُونْ رَسُولْ ونِدْعِي النَّاسْ مِالشُّعُوبْ الكُلْ لْطَاعِةْ اللَّهْ بِالإِيمَانْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","وإِنْتُومَا زَادَا مِنْهُمْ مَادَامْ اللَّهْ دْعَاكُمْ بَاشْ تْوَلِّيوْ تَابْعِينْ لْيَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","نِكْتِبْ لِلْمُؤْمْنِينْ الكُلْ المَوْجُودِينْ فِي رُومَا، الِّي هُومَا شَعْبْ اللَّهْ الِّي يْحِبُّو، والمَدْعُوِّينْ بَاشْ يْكُونُوا قِدِّيسِينْ، النِّعْمَة والسَّلَامْ لِيكُمْ مِنْ عَنْدْ اللَّهْ بُونَا ومِنْ عَنْدْ الرَّبْ يَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","قْبَلْ كُلْ شَيْ، نُشْكُرْ إِلَاهِي بْإِسْمْ يَسُوعْ المَسِيحْ عْلَى خَاطِرْكُمْ الكُلْ، وعْلَى خَاطِرْ إِيمَانْكُمْ الِّي سْمَعْ بِيهْ العَالِمْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","واللَّهْ الِّي نِخْدِمْ فِيهْ مِنْ كُلْ قَلْبِي ونْبَشِّرْ بِبْشَارِةْ إِبْنُو، يِشْهِدْ الِّي دِيمَا نُذْكُرْكُمْ قُدَّامُو، ");
INSERT INTO aeu_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","ودِيمَا نُطْلُبْ مِنُّو فِي صْلَاتِي إِنُّو بْقُدْرْتُو يْسَهَّلِّي فِي فُرْصَة بَاشْ نْجِي نْطُلْ عْلِيكُمْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","عْلَى خَاطِرْنِي مِتْوَحَّشْكُمْ، ونْحِبْ نَعْطِيكُمْ بَرْكَة رُوحِيَّة تْقَوِّيكُمْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","بَاشْ نْشَجْعُوا بْعَضْنَا بِالإِيمَانْ الِّي نِتْشَارْكُوا فِيهْ، الِّي هُوَّ إِيمَانْكُمْ وإِيمَانِي. ");
INSERT INTO aeu_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ونْحِبْكُمْ تَعْرْفُوا، يَا خْوَاتِي، الِّي آنَا حَاوِلْتْ بَرْشَة مَرَّاتْ بَاشْ نْجِيكُمْ، بَاشْ يْكُونْ عَنْدِي ثْمَرْ فِي وِسْطْكُمْ كِيمَا فِي وِسْطْ الشُّعُوبْ الأُخْرِينْ الكُلْ، آمَا حَتَّى لْتَوَّا بَرْشَة حَاجَاتْ مَانْعِتْنِي. ");
INSERT INTO aeu_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","عَنْدِي وَاجِبْ بَاشْ نْبَشِّرْ الشُّعُوبْ الكُلْ: المِتْمَدْنِينْ ولِّي مُشْ مِتْمَدْنِينْ، المِتْعَلْمِينْ ولِّي مُشْ قَارِينْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","هَاذَاكَا عْلَاشْ مِتْشَوَّقْ بَرْشَة بَاشْ نْبَشِّرْكُمْ إِنْتُومَا زَادَا الِّي فِي رُومَا. ");
INSERT INTO aeu_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","آنَا مَا نِحْشِمْشْ بِبْشَارِةْ المَسِيحْ، عْلَى خَاطِرْهَا قُوِّةْ اللَّهْ الِّي تْنَجِّي كُلْ وَاحِدْ يَمِّنْ بِيهَا، اليْهُودْ فِي الأُوِّلْ ومْبَعِّدْ الِّي مَاهُمْشْ يْهُودْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","عْلَى خَاطِرْ فِيهَا يْوَرِّينَا اللَّهْ كِيفَاشْ يْرُدْ الإِنْسَانْ صَالَحْ قُدَّامُو: وهَاذَا عْلَى أَسَاسْ الإِيمَانْ وبِالإِيمَانْ وَحْدُو، كِيمَا هُوَّ مَكْتُوبْ: «الصَّالَحْ يَحْيَا بِالإِيمَانْ». ");
INSERT INTO aeu_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","اللَّهْ وَرَّى مِالسْمَاء قَدَّاشْ هُوَّ غَاضِبْ عْلَى فْسَادْ وشَرْ النَّاسْ، الِّي بِفْسَادْهُمْ مَا يْخَلِّيوِشْ الحْقِيقَة تُظْهُرْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","عْلَى خَاطِرْ الِّي يْنَجْمُوا يَعْرْفُوهْ عْلَى اللَّهْ وَاضْحِلْهُمْ. اللَّهْ بِيدُو وَضَّحْهُولْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","ومِلِّي تْخَلْقِتْ الدِّنْيَا صِفَاتْ اللَّهْ الِّي مَا تِتْشَافِشْ، قُدْرْتُو الأَبَدِيَّة وطَبِيعْتُو الإِلَهِيَّة، ظَاهْرِينْ فِي مَخْلُوقَاتُو. هَاذَاكَا عْلَاشْ النَّاسْ مَا عَنْدْهُمْ حَتَّى عُذْرْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","رَغْمِلِّي عَرْفُوا اللَّهْ، مَا مَجْدُوهِشْ ومَا شُكْرُوهِشْ بِٱعْتِبَارُو اللَّهْ. بِالعَكْسْ، زَادْ فْسِدْ تَفْكِيرْهُمْ وظْلَامِتْ قْلُوبْهُمْ مِنْ قِلِّةْ الفَهْمْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","حَاسْبِينْ رْوَاحْهُمْ حُكَمَاءْ، يَاخِي وَلَّاوْ فِي الحْقِيقَة جُهَّالْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","وفِي عُوضْ مَا يِعْبْدُوا إِلَاهْ المَجْدْ الِّي مَا يِفْنَاشْ، عِبْدُوا أَصْنَامْ تْشَبَّهْ لِلْإِنْسَانْ الفَانِي ولِلطْيُورْ ولِلْحَيَوَانَاتْ الِّي تِمْشِي ولِّي تَزْحِفْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","هَاذَاكَا عْلَاشْ سَلَّمْهُمْ اللَّهْ لْشَهْوِةْ قْلُوبْهُمْ، لِلْفْسَادْ الِّي نَجْسُوا بِيهْ بْدَنَّاتْهُمْ مَا بِينْ بْعَضْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","بَدْلُوا حَقْ اللَّهْ بِالكِذْبْ، وعِبْدُوا المَخْلُوقْ وخِدْمُوهْ فِي بْلَاصِةْ الخَالِقْ الِّي هُوَّ مُبَارَكْ لِلْأَبَدْ. آمِينْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","هَاذَاكَا عْلَاشْ سَلَّمْهُمْ اللَّهْ لِلشْهَاوِي الِّي تَعْمِلْ العَارْ. وَلَّاوْ نْسَاهُمْ يُرْقْدُوا مْعَ بْعَضْهُمْ بْعَكْسْ الطَّبِيعَة. ");
INSERT INTO aeu_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","والرْجَالْ زَادَا بَطْلُوا العَلَاقَاتْ العَادِيَّة مْعَ النْسَاء وهَاجِتْ شَهْوِتْهُمْ لِبْعَضْهُمْ. وعَمْلُوا الِّي مَا يِتْعْمَلْشْ كِي رَقْدُوا رْجَالْ مْعَ رْجَالْ، وهَكَّا خْذَاوْ العِقَابْ الِّي يِسْتْحَقُّوهْ عْلَى فْسَادْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","ومَادَامْهُمْ مَا حَبُّوشْ يَعْرْفُوا اللَّهْ، سَلَّمْهُمْ لْتَفْكِيرْهُمْ الفَاسِدْ بَاشْ يَعْمْلُوا الِّي مَا يِتْعْمَلْشْ. ");
INSERT INTO aeu_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","وَلَّاوْ مِلْيَانِينْ بْكُلْ أَنْوَاعْ الفْسَادْ والشَّرْ والطْمَعْ والنْجَاسَة، ومِلْيَانِينْ بِالحُسْدْ والقَتْلْ والعَرْكْ والغَشَّة والخْبَاثَة. ولَاهِينْ بِالقِيلْ والقَالْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","يْقَطْعُوا ويْرَيْشُوا فِي بْعَضْهُمْ، يِكْرْهُوا اللَّهْ، يْعَايْرُوا النَّاسْ، مِتْكَبْرِينْ، مِتْفَاخْرِينْ، مُتْفَنِّينْ فِي الشَّرْ، عَاصِينْ وَالْدِيهُمْ، ");
INSERT INTO aeu_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","لَا عَنْدْهُمْ فَهْمْ ولَا أَمَانَة ولَا حَنَانْ ولَا رَحْمَة. ");
INSERT INTO aeu_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","هُومَا يَعْرْفُوا الِّي اللَّهْ حْكُمْ بِالمُوتْ عَلِّي يَعْمْلُوا الحَاجَاتْ هَاذُومَا. ورَغْمْ هَاذَا، مُشْ يَعْمْلُوهَا بَرْكْ، آمَا يْزِيدُوا يِفْرْحُوا بِالنَّاسْ الِّي يَعْمْلُوهَا. ");
INSERT INTO aeu_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","هَاذَاكَا عْلَاشْ مَا عَنْدِكْ حَتَّى عُذْرْ يَا إِنْسَانْ، يَلِّي تُحْكُمْ عَالنَّاسْ الأُخْرِينْ وإِنْتِ تَعْمِلْ فِي نَفْسْ العْمَايِلْ. عْلَى خَاطِرْ، كِي تُحْكُمْ عْلِيهُمْ، إِنْتِ تُحْكُمْ عْلَى رُوحِكْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","وأَحْنَا نَعْرْفُوا الِّي اللَّهْ يُحْكُمْ بِالعَدْلْ عَالنَّاسْ الِّي يَعْمْلُوا الحَاجَاتْ هَاذِيكَا. ");
INSERT INTO aeu_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","وإِنْتِ يَلِّي قَاعِدْ تُحْكُمْ عَالنَّاسْ الِّي يَعْمْلُوا الحَاجَاتْ هَاذِيكَا، وإِنْتِ بِيدِكْ تَعْمِلْ فِيهَا، يَاخِي مَاشِي فِي بَالِكْ بِشْ تَمْنَعْ مِنْ حُكْمْ اللَّهْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","وَلَّا مَاكِشْ عَاطِي قِيمَة لْطِيبْتُو ووِسْعْ بَالُو وصَبْرُو؟ يَاخِي مَا تَعْرَفْشْ الِّي القَصْدْ مِنْ طِيبْتُو هُوَّ إِنِّكْ إِتُّوبْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","آمَا بِعْنَادِكْ وكْسُوحِيِّةْ قَلْبِكْ، قَاعِدْ تْلِمْ فِي غَضَبْ اللَّهْ عْلِيكْ لِنْهَارْ الحْسَابْ، النْهَارْ الِّي بِشْ يْظَهَّرْ فِيهْ اللَّهْ حُكْمُو العَادِلْ، ");
INSERT INTO aeu_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","عْلَى خَاطْرُو بِشْ يْحَاسِبْ كُلْ وَاحِدْ حَسْبْ أَعْمَالُو. ");
INSERT INTO aeu_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","ولِّي يِجْتَهْدُوا فِي فِعْلْ الخِيرْ، ويِسْعَاوْ لِلْمَجْدْ والكَرَامَة والخُلُودْ، بِشْ يَعْطِيهُمْ الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","آمَا الِّي يْلَوْجُوا عْلَى مَصْلْحِتْهُمْ الشَّخْصِيَّة، ومَا يِقْبْلُوشْ الحَقْ ويْتَبْعُوا الظُّلْمْ، بِشْ يَسْخِطْهُمْ ويْهَبَّطْ عْلِيهُمْ الغَضَبْ مْتَاعُو. ");
INSERT INTO aeu_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","وبِشْ يْكُونْ عْذَابْ وشِدَّة لْكُلْ إِنْسَانْ يَعْمِلْ الشَّرْ، لِليْهُودِي فِي الأُوِّلْ ومْبَعِّدْ لِلِّي مُشْ يْهُودِي، ");
INSERT INTO aeu_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","ويَعْطِي مَجْدْ وكَرَامَة وسَلَامْ لْكُلْ وَاحِدْ يَعْمِلْ الخِيرْ، لِلْيْهُودِي فِي الأُوِّلْ ومْبَعِّدْ لِلِّي مُشْ يْهُودِي. ");
INSERT INTO aeu_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","رَاهُو اللَّهْ مَا يْمَيِّزْ حَدْ عْلَى حَدْ. ");
INSERT INTO aeu_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","الِّي عَمْلُوا الذْنُوبْ وهُومَا مَا عَنْدْهُمْشْ شَرِيعِةْ مُوسَى، بِشْ يْمُوتُوا زَادَا مِنْ غِيرْ حُكْمْ الشَّرِيعَة. ولِّي عَمْلُوا الذْنُوبْ وهُومَا عَنْدْهُمْ شَرِيعِةْ مُوسَى، بِشْ يْتَحْكَمْ عْلِيهُمْ بِالشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","عْلَى خَاطِرْ مُشْ الِّي يِسْمْعُوا الشَّرِيعَة هُومَا الِّي يْرُدْهُمْ اللَّهْ صَالْحِينْ، آمَا الِّي يْطَبْقُوهَا. ");
INSERT INTO aeu_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","النَّاسْ الِّي مَاهُمْشْ يْهُودْ، ولِّي مَا عَنْدْهُمْشْ شَرِيعِةْ مُوسَى، وَقْتِلِّي يَعْمْلُوا بِطْبِيعِتْهُمْ الحَاجَاتْ الِّي تْقُولْ عْلِيهُمْ الشَّرِيعَة، يْكُونُوا شَرِيعَة لِرْوَاحْهُمْ، حَتَّى كَانْ مَا عَنْدْهُمْشْ شَرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","هَاذَا يْبَيِّنْ الِّي قَانُونْ الشَّرِيعَة مَكْتُوبْ فِي قْلُوبْهُمْ، وضَمِيرْهُمْ زَادَا يِشْهِدْ عْلَى هَاذَا، وحَتَّى أَفْكَارْهُمْ مِنْ دَاخِلْ مَرَّة تِتْهِمْهُمْ ومَرَّة إِدَّافَعْ عْلِيهُمْ . ");
INSERT INTO aeu_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","وكِيمَا بَشِّرْتْكُمْ، بِشْ يُظْهُرْ هَاذَا الكُلْ نْهَارِةْ الِّي يْحَاسِبْ اللَّهْ العْبَادْ عْلَى سْرَايِرْ قْلُوبْهُمْ، بْيَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","وإِنْتِ، الِّي تْسَمِّي فِي رُوحِكْ يْهُودِي، ومْعَمِّلْ عَالشَّرِيعَة وتِتْفُوخِرْ بِاللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","وتَعْرِفْ آشْ يْحِبْ اللَّهْ، وتَعْرِفْ تْفَرَّقْ بِينْ البَاهِي والخَايِبْ كِيمَا تْعَلَّمْتْ مِالشَّرِيعَة، ");
INSERT INTO aeu_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","ووَاثِقْ الِّي إِنْتِ قَايِدْ لِلْعِمْيَانْ، ونُورْ لِلِّي عَايْشِينْ فِي الظْلَامْ ");
INSERT INTO aeu_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ولِّي إِنْتِ مُرْشِدْ لِلجُهَّالْ، ومُعَلِّمْ لِلصْغَارْ، ولِّي إِنْتِ عْلَى خَاطِرْ عَنْدِكْ الشَّرِيعَة، وْصِلْتْ لْقِمِّةْ الحَقْ والمَعْرْفَة… ");
INSERT INTO aeu_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","إِنْتِ، يَلِّي تْعَلَّمْ فِي الأُخْرِينْ، مُشْ كَانْ تْعَلَّمْ رُوحِكْ خِيرْ؟ يَاخِي تْقُولْ مَا تِسْرْقُوشْ وإِنْتِ تِسْرِقْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","وتْقُولْ مَا تَزْنَاوْشْ وإِنْتِ تَزْنَى؟ وتْقُولْ تِكْرَهْ الصْنَبْ آمَا تِسْرِقْ الهَيْكِلْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","تِتْفُوخِرْ بِالشَّرِيعَة، وتْهِينْ اللَّهْ كِي تْخَالِفْهَا! ");
INSERT INTO aeu_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","رَاهُو مَكْتُوبْ: «الِّي مَاهُمْشْ يْهُودْ، كَفْرُوا بْإِسْمْ اللَّهْ بِسْبَبْكُمْ إِنْتُومَا اليْهُودْ». ");
INSERT INTO aeu_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","الطْهُورْ عَنْدُو قِيمَة إِذَا كَانْ اطِّيعْ الشَّرِيعَة، آمَا إِذَا كَانْ تْخَالِفْ الشَّرِيعَة، كِيفِكْ كِيفْ الِّي مُشْ مْطَهِّرْ. ");
INSERT INTO aeu_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","وإِذَا وَاحِدْ مُشْ مْطَهِّرْ يْطَبَّقْ فْرَايِضْ الشَّرِيعَة، يَاخِي مُشْ بِشْ يِحْسْبُو اللَّهْ كَايِنُّو مْطَهِّرْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","ولِّي يَعْمِلْ بِالشَّرِيعَة وهُوَّ مُشْ مْطَهِّرْ، بِشْ يُحْكُمْ عْلِيكْ إِنْتِ الِّي تْخَالِفْ الشَّرِيعَة وإِنْتِ عَنْدِكْ الكْتُبْ المُقَدْسَة والطْهُورْ. ");
INSERT INTO aeu_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","رَاهُو اليْهُودِي الحَقِيقِي، مُشْ الِّي هُوَّ يْهُودِي فِي الظَّاهِرْ، والطْهُورْ الحَقِيقِي مُشْ حَاجَة مِنْ بَرَّة فِي اللْحَمْ، ");
INSERT INTO aeu_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","آمَا اليْهُودِي الحَقِيقِي هُوَّ اليْهُودِي مِنْ دَاخِلْ، والطْهُورْ الحَقِيقِي هُوَّ طْهُورْ القَلْبْ بِالرُّوحْ مُشْ بِالشَّرِيعَة. هَاذَاكَا هُوَّ الإِنْسَانْ الِّي يَاخِذْ المَدْحْ مِنْ اللَّهْ مُشْ مِالنَّاسْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","مَالَا شْنُوَّة فَضْلْ اليْهُودِي؟ وشْنِيَّة فَايِدْةْ الطْهُورْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","مِالجِيهَاتْ الكُلْ فَمَّة فَايْدَة. وأَهَمْ وَحْدَة هِيَّ الِّي اللَّهْ إِسْتَأْمِنْ اليْهُودْ عْلَى كْلَامُو. ");
INSERT INTO aeu_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","وإِذَا كَانْ جْمَاعَة مِنْهُمْ خَانُوا الأَمَانَة، يَاخِي قِلِّةْ أَمَانِتْهُمْ تْبَطِّلْ أَمَانِةْ اللَّهْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","بِالطْبِيعَة لَا! اللَّهْ صَادِقْ والنَّاسْ الكُلْ تِكْذِبْ. وكِيمَا مَكْتُوبْ: «يَا اللَّهْ هَكَّا تِثْبِتْ الِّي إِنْتِ صَادَقْ فِي كْلَامِكْ، وغَالِبْ وَقْتِلِّي تُحْكُمْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","آمَا إِذَا كَانْ شَرْنَا يْظَهِّرْ صَلَاحْ اللَّهْ، يَاخِي مَعْقُولْ نْقُولُوا اللَّهْ ظَالِمْ كِي يْعَاقِبْنَا؟ وهْنَا نِتْكَلِّمْ بْمَنْطَقْ البَشَرْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","حَاشَاهْ! مَالَا كَانْ هَكَّا، كِيفَاشْ بِشْ يْنَجِّمْ يْحَاسِبْ العَالِمْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","ومُمْكِنْ تْقُولْ: «إِذَا كَانْ كِذْبِي يْزِيدْ يْظَهِّرْ صِدْقْ اللَّهْ ويْمَجْدُو أَكْثِرْ، مَالَا عْلَاشْ يِتْحْكَمْ عْلِيَّا كِيمَا وَاحِدْ مُذْنِبْ؟». ");
INSERT INTO aeu_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","يَاخِي مُشْ فَمَّة نَاسْ يِتْبَلَّاوْ عْلِينَا، ويِتْهْمُوا فِينَا بِالبَاطِلْ الِّي أَحْنَا نْقُولُوا: «عْلَاشْ مَا نَعْمْلُوشْ الشَّرْ بَاشْ يْجِي مِنُّو الخِيرْ؟». وهَاذُمْ اللَّهْ بِشْ يْحَاسِبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","شْنُوَّة، مَالَا؟ يَاخِي أَحْنَا اليْهُودْ خِيرْ مِالنَّاسْ الأُخْرِينْ؟ مُسْتَحِيلْ! وآنَا سْبَقْ وْقُلْتِلْكُمْ الِّي اليْهُودْ ولِّي مُشْ يْهُودْ الكُلْهُمْ تَحْتْ سُلْطِةْ الخَطِيئَة. ");
INSERT INTO aeu_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","وكِيمَا مَكْتُوبْ: «مَا فَمَّة حَتَّى حَدْ صَالَحْ، ولَا حَتَّى وَاحِدْ، ");
INSERT INTO aeu_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","حَتَّى وَاحِدْ مَا يِفْهِمْ، وحَتَّى وَاحِدْ مَا يْلَوِّجْ عْلَى اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","الكُلْهُمْ ضَاعُوا، الكُلْهُمْ فِسْدُوا. حَتَّى حَدْ مَا يَعْمِلْ فِي الصَّلَاحْ، وَلَا وَاحِدْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","«ڨْرَاجِمْهُمْ كِيفْ القْبُورَاتْ المَحْلُولَة، لْسَانَاتْهُمْ خْبِيثَة». «وسِمْ الأَفَاعِي فِي شْفَايِفْهُمْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","«مَاعَنْدْهُمْ فِي آفَّامْهُمْ كَانْ دْعَاء الشَّرْ والكْلَامْ الِّي يُوجَعْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","«يِتْجَارَاوْ بَاشْ يُقْتْلُوا العْبَادْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","وِينْ يِمْشِيوْ يِخْلِيوْهَا ومَا يْجِي مِنْ وْرَاهُمْ كَانْ الهَّمْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","طْرِيقْ السَّلَامْ مَا يَعْرْفُوهِشْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","«ومَا يْخَافُوشْ اللَّهْ». ");
INSERT INTO aeu_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","وأَحْنَا نَعْرْفُوا بِلِّي المَكْتُوبْ فِي الشَّرِيعَة، يْخُصْ النَّاسْ الِّي هُومَا تَحْتْ حُكْمْ الشَّرِيعَة، بَاشْ حَتَّى وَاحِدْ مَا يْنَجِّمْ يِتْكَلِّمْ، ويْكُونْ العَالِمْ الكُلْ تَحْتْ حُكْمْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","عْلَى خَاطِرْ حَتَّى حَدْ مَا يْوَلِّي صَالَحْ قُدَّامْ اللَّهْ بْطَاعْتُو لِلشَّرِيعَة: الشَّرِيعَة تْوِجْدِتْ بَاشْ تِكْشِفْ الذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","آمَا تَوَّا ظْهُرْ كِيفَاشْ اللَّهْ يْرُدْ الإِنْسَانْ صَالَحْ مِنْ غِيرْ الشَّرِيعَة، كِيمَا شِهْدِتْ التَّوْرَاة وكْتُبْ الأَنْبِيَاءْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","اللَّهْ يَعْتْبَرْ الإِنْسَانْ صَالَحْ بْإِيمَانُو بْيَسُوعْ المَسِيحْ. وهَاذَا يِطَّبَّقْ عْلَى النَّاسْ الكُلْ الِّي يَمْنُوا بِيهْ ومَا فَمَّة حَتَّى فَرْقْ بِينَاتْهُمْ، ");
INSERT INTO aeu_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","خَاطِرْ النَّاسْ الكُلْ عَمْلُوا الذْنُوبْ وتْحِرْمُوا مِنْ مَجْدْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","آمَا اللَّهْ اعْتَبَرْهُمْ صَالْحِينْ بِالنِّعْمَة، وهَاذِي هْدِيَّة مِنْ عَنْدُو عْلَى خَاطِرْ يَسُوعْ المَسِيحْ فْدَاهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","اللَّهْ عْطَاهُولْنَا ضْحِيَّة بَاشْ يْكَفِّرْ عْلَى ذْنُوبْنَا بْدَمُو، إِذَا كَانْ أَمَّنَّا بِيهْ. وهَاذَا يْبَيِّنْ إِنُّو اللَّهْ صَالَحْ عْلَى خَاطْرُو صْبَرْ عْلَى ذْنُوبْ النَّاسْ الِّي تْعَمْلِتْ قْبَلْ ومَا عَاقِبْهُمْشْ عْلِيهَا، ");
INSERT INTO aeu_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","ويْبَيِّنْ زَادَا فِي الوَقْتْ الحَاضِرْ إِنُّو اللَّهْ صَالَحْ عْلَى خَاطِرْ كُلْ وَاحِدْ يَمِّنْ بْيَسُوعْ يَعْتَبْرُو صَالَحْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","مَالَا بَاشْ يْنَجِّمْ يِتْفُوخِرْ الإِنْسَانْ؟ بْحَتَّى شَيْ! يَاخِي يْنَجِّمْ يِتْفُوخِرْ بْأَعْمَالْ الشَّرِيعَة؟ أَكِيدْ لَا، عْلَى خَاطْرُو وَلَّى صَالَحْ بِالإِيمَانْ، مُشْ بِالأَعْمَالْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","والنْتِيجَة الِّي وْصِلْنَالْهَا هِيَّ إِنُّو الإِنْسَانْ يْوَلِّي صَالَحْ بِالإِيمَانْ، مُشْ كِي يْطَبَّقْ فَرَايِضْ الشَّرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","يَاخِي اللَّهْ إِلَاهْ اليْهُودْ أَكَهَوْ؟ مُشْ هُوَّ إِلَاهْ الشُّعُوبْ الأُخْرِينْ زَادَا؟ إِيْ نْعَمْ، هُوَّ إِلَاهْ الشُّعُوبْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","مَادَامُو اللَّهْ وَاحِدْ، بِشْ يَعْتَبِرْ اليْهُودْ صَالْحِينْ عْلَى أَسَاسْ إِيمَانْهُمْ، ولِّي مَاهُمْشْ يْهُودْ صَالْحِينْ بْإِيمَانْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","زَعْمَة أَحْنَا قَاعْدِينْ انَّقْصُوا مِنْ قِيمِةْ الشَّرِيعَة كِي نْأَكْدُوا عَالإِيمَانْ؟ بِالعَكْسْ، أَحْنَا نْوَرِّيُو عْلَاشْ الشَّرِيعَة تْوِجْدِتْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","وآشْ نْقُولُوا عْلَى بُونَا إِبْرَاهِيمْ؟ آشْ صَارْ مْعَاهْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","لَوْ كَانْ اللَّهْ إِعْتَبَرْ إِبْرَاهِيمْ صَالَحْ عْلَى أَسَاسْ أَعْمَالُو، رَاهُو كَانْ عَنْدُو الحَقْ يِتْفُوخِرْ، آمَا مُشْ قُدَّامْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","آشْ تْقُولْ الكْتُبْ المُقَدْسَة؟ «أَمَّنْ إِبْرَاهِيمْ بِاللَّهْ، يَاخِي إِيمَانُو تِحْسِبْلُو صَلَاحْ». ");
INSERT INTO aeu_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","الِّي يِخْدِمْ خِدْمَة يُخْلُصْ عْلِيهَا، وهَاذَاكَا حَقُّو مُشْ هْدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","آمَا الِّي مَا يِتْوَكِّلْشْ عْلَى أَعْمَالُو ويَمِّنْ بِاللَّهْ الِّي يِغْفِرْ لِلْمُذْنِبْ، إِيمَانُو هَاذَا يِحْسِبْهُولُو اللَّهْ صَلَاحْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","وكِيمَا قَالْ دَاوِدْ وهُوَّ يَحْكِي عْلَى فَرْحِةْ النَّاسْ الِّي إِعْتَبْرُهُمْ اللَّهْ صَالْحِينْ بْإِيمَانْهُمْ مُشْ بَأَعْمَالْهُمْ: ");
INSERT INTO aeu_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","«صَحَّة لِلِّي تْنَحَّاتْ خَطِيئِتْهُمْ وتْغَفْرِتْ ذْنُوبْهُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","صَحَّة لِلِّي مَا يِحْسِبْلُو اللَّهْ حَتَّى ذَنْبْ!». ");
INSERT INTO aeu_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","يَاخِي البَرْكَة هَاذِي لِلْيْهُودْ أَكَهَوْ وَلَّا لِلِّي مُشْ يْهُودْ زَادَا؟ وأَحْنَا سْبَقْ وقُلْنَا: رَاهُو اللَّهْ إِعْتَبَرْ إِبْرَاهِيمْ صَالَحْ بِسْبَبْ إِيمَانُو. ");
INSERT INTO aeu_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","وَقْتَاشْ صَارْ هَاذَا؟ قْبَلْ الطْهُورْ وَلَّا بَعْدُو؟ هَاذَا صَارْ قْبَلْ مَا يْطَهِّرْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","إِبْرَاهِيمْ خْذَا الطْهُورْ عَلَامَةْ وبُرْهَانْ الِّي اللَّهْ إِعْتَبْرُو صَالَحْ بِالإِيمَانْ قْبَلْ مَا يْطَهِّرْ، بَاشْ يْوَلِّي هُوَّ بُو النَّاسْ الِّي يَمْنُوا وهُومَا مُشْ مْطَهْرِينْ، وهَكَّا يَعْتَبِرْهُمْ اللَّهْ صَالْحِينْ، ");
INSERT INTO aeu_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","وزَادَا بُو المْطَهْرِينْ الِّي مَا يْعَمْلُوشْ كَانْ عَالطْهُورْ، آمَا يِمْشِيوْ فِي طْرِيقْ الإِيمَانْ الِّي كَانْ مَاشِي فِيهْ بُونَا إِبْرَاهِيمْ قْبَلْ مَا يْطَهِّرْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","وَقْتِلِّي وْعِدْ اللَّهْ إِبْرَاهِيمْ وذِرِّيتُو إِنْهُمْ بِشْ يُورْثُوا العَالِمْ، مَا كَانِشْ هَاذَاكَا عْلَى أَسَاسْ الشَّرِيعَة، آمَا عْلَى أَسَاسْ الصَّلَاحْ الِّي يْجِي بِالإِيمَانْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","إِذَا كَانْ الِّي يْطَبْقُو فِي الشَّرِيعَة هُومَا الِّي يُورْثُوا، مَالَا الإِيمَانْ مَا عَنْدُوشْ فَايْدَة والوَعْدْ بَاطِلْ: ");
INSERT INTO aeu_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","عْلَى خَاطِرْ الشَّرِيعَة تْخَلِّي اللَّهْ يِتْغَشِّشْ ويْعَاقِبْ الِّي يْخَالْفُوهَا، وكَانْ مَا جَاتِشْ فَمَّة شَرِيعَة مَا يْنَجَّمْشْ الوَاحِدْ يْخَالِفْهَا. ");
INSERT INTO aeu_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","هَاذَاكَا عْلَاشْ الوَعْدْ يْجِي بِالإِيمَانْ عْلَى أَسَاسْ النِّعْمَة، بَاشْ يْكُونْ مَضْمُونْ لْذُرِّيِّةْ إِبْرَاهِيمْ الكُلْ، مُشْ لِلِّي عَنْدْهُمْ الشَّرِيعَة أَكَهَوْ، آمَا زَادَا لِلِّي عَنْدْهُمْ إِيمَانْ كِيمَا إِبْرَاهِيمْ. عْلَى خَاطْرُو بُونَا الكُلْ، ");
INSERT INTO aeu_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","كِيمَا مَكْتُوبْ : «رَدِّيتِكْ بُو لْبَرْشَة شْعُوبْ». هُوَّ بُونَا قُدَّامْ اللَّهْ الِّي أَمَّنْ بِيهْ، ولِّي يْقَيِّمْ المُوتَى، ويْرُدْ الِّي مُشْ مَوْجُودْ مَوْجُودْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","وحَتَّى وَقْتِلِّي مَا كَانِشْ فَمَّة رْجَى، إِبْرَاهِيمْ أَمَّنْ وكَانْ عَنْدُو رْجَى، وهَكَّا وَلَّى بُو لْبَرْشَة شْعُوبْ كِيفْ مَا قَالُّو اللَّهْ: «بِشْ تْكُونْ عَنْدِكْ بَرْشَة ذُرِّيَّة». ");
INSERT INTO aeu_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","ومَا ضْعُفْشْ إِيمَانُو رَغْمِلِّي عُمْرُو كَانْ قْرِيبْ 100 سْنَة، وكَانْ يَعْرِفْ الِّي لَا هُوَّ ولَا مَرْتُو سَارَّة يْنَجْمُوا يْجِيبُوا الصْغَارْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","مَا ضْعُفْشْ إِيمَانُو ومَا شَكِّشْ فِي وَعْدْ اللَّهْ، آمَا بِالعَكْسْ، تْقَوَّى بِالإِيمَانْ وعْطَى المَجْدْ لَلَّهْ، ");
INSERT INTO aeu_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","عْلَى خَاطِرْ كَانْ مِتْأَكِّدْ الِّي اللَّهْ قَادِرْ بَاشْ يْتَمِّمْ وَعْدُو. ");
INSERT INTO aeu_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","عْلَى خَاطِرْ الإِيمَانْ هَاذَاكَا، إِبْرَاهِيمْ تِحْسِبّْ صَالَحْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","وَقْتِلِّي تْقُولْ الكْتُبْ المُقَدْسَة: «إِعْتَبْرُو صَالَحْ» مَا تْقُولِشْ هَاذَا عْلِيهْ هُوَّ وَحْدُو، ");
INSERT INTO aeu_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","آمَا عْلِينَا أَحْنَا زَادَا. اللَّهْ يَعْتْبَرْنَا صَالْحِينْ، أَحْنَا الِّي نَمْنُوا بِاللَّهْ الِّي قَيِّمْ رَبْنَا يَسُوعْ مِالمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","عْلَى خَاطِرْ اللَّهْ سَلْمُو لِلْمُوتْ بِسْبَبْ ذْنُوبْنَا وقَيْمُو مِالمُوتْ بَاشْ يْرُدْنَا صَالْحِينْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","مَالَا، مَادَامْ اللَّهْ رَدْنَا صَالْحِينْ بِالإِيمَانْ، وَلَّى عَنْدْنَا سَلَامْ مْعَاهْ بْرَبْنَا يَسُوعْ المَسِيحْ، ");
INSERT INTO aeu_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","وبِيهْ نَجَّمْنَا نُدْخْلُوا بِالإِيمَانْ لِلنِّعْمَة الِّي أَحْنَا فِيهَا تَوَّا، ونِفْرْحُوا الِّي عَنْدْنَا رْجَى، الِّي أَحْنَا بِشْ نْشَارْكُوا فِي مَجْدْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","وأَكْثِرْ مِنْ هَكَّا، نِفْرْحُوا زَادَا فِي أَوْقَاتْ الضِّيقْ، عْلَى خَاطِرْ نَعْرْفُوا الِّي الضِّيقْ يْعَلَّمْنَا الصَّبْرْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","والصَّبْرْ يْخَلِّينَا نِتْقَوَّاوْ وَقْتْ المِحْنَة، والقُوَّة هَاذِي تَخْلَقْ فِينَا الرْجَى، ");
INSERT INTO aeu_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","والرْجَى مَا يْخِيبِشْ عْلَى خَاطِرْ اللَّهْ فَاضْ بِمْحَبْتُو فِي قْلُوبْنَا بِالرُّوحْ القُدُسْ الِّي عْطَاهُولْنَا. ");
INSERT INTO aeu_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","وفِي الوَاقَعْ، وَقْتِلِّي كُنَّا مَا عَنْدْنَاشْ القُدْرَة بَاشْ إِنَّجِّيوْ رْوَاحْنَا، مَاتْ المَسِيحْ عْلَى خَاطِرْ المُذْنْبِينْ فِي الوَقْتْ الِّي إِخْتَارُو اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","صْعِيبْ الوَاحِدْ يْمُوتْ عْلَى خَاطِرْ إِنْسَانْ صَالَحْ. مُمْكِنْ الوَاحِدْ يِتْشَجَّعْ ويِفْدِي إِنْسَانْ بَاهِي بَرْشَة، ");
INSERT INTO aeu_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","آمَا اللَّهْ وَرَّانَا مْحَبْتُو، عْلَى خَاطِرْ وأَحْنَا مَزِّلْنَا مُذْنْبِينْ مَاتْ المَسِيحْ عْلَى خَاطِرْنَا. ");
INSERT INTO aeu_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","ومَادَامْنَا تَوَّا وَلِّينَا صَالْحِينْ بْدَمُّو، مَالَا أَكِيدْ بِشْ نِنْجَاوْ بِيهْ مِنْ غَضَبْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","وإِذَا كَانْ اللَّهْ، وَقْتِلِّي كُنَّا أَعْدَاؤُو، صَالَحْنَا مْعَاهْ بْمُوتْ إِبْنُو، مَالَا أَكِيدْ، وأَحْنَا تَوَّا مِتْصَالْحِينْ مْعَاهْ، بِشْ نِنْجَاوْ بِحْيَاتُو. ");
INSERT INTO aeu_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ومُشْ هَاذَا بَرْكْ، آمَا زَادَا نِفْرْحُوا بِاللَّهْ، عْلَى طْرِيقْ رَبْنَا يَسُوعْ المَسِيحْ الِّي صَالَحْنَا مْعَاهْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","هَاذَاكَا عْلَاشْ، كِيمَا دَخْلِتْ الخَطِيئَة لِلدِّنْيَا بْإِنْسَانْ وَاحِدْ، والخَطِيئَة هَاذِي دَخْلِتْ مْعَاهَا المُوتْ، زَادَا وَلَّاوْ النَّاسْ الكُلْ يْمُوتُوا عْلَى خَاطِرْ الكُلْهُمْ عَمْلُوا الذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","والخَطِيئَة كَانِتْ مَوْجُودَة فِي العَالِمْ حَتَّى قْبَلْ الشَّرِيعَة، آمَا مَا كَانِتْشْ تِتِّحْسِبْ ضِدْ النَّاسْ، عْلَى خَاطِرْ وَقْتْهَا مَا كَانِتْشْ فَمَّة شَرِيعَة. ");
INSERT INTO aeu_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","ومْعَ هَاذَا، مِنْ وَقْتْ آدَمْ حَتَّى لْمُوسَى، سَيْطِرْ المُوتْ عَالنَّاسْ الكُلْ، حَتَّى الِّي مَا عَمْلُوشْ خَطِيئَة كِيمَا الِّي عْمَلْهَا آدَمْ. وآدَمْ كَانْ يُرْمُزْ لْشَخْصْ بِشْ يْجِي بَعْدُو. ");
INSERT INTO aeu_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","آمَا هْدِيِّةْ اللَّهْ لِينَا مُشْ كِيمَا خَطِيئِةْ آدَمْ. إِذَا كَانِتْ البَشَرِيَّة تْمُوتْ نْتِيجِةْ خَطِيئِةْ إِنْسَانْ وَاحِدْ، مَالَا نِعْمِةْ اللَّهْ أَعْظِمْ! عْلَى خَاطْرُو فَاضْ بِيهَا عَالبَشَرِيَّة الكُلْ، وعْطَاهَا هْدِيَّة عْلَى طْرِيقْ إِنْسَانْ وَاحِدْ، الِّي هُوَّ يَسُوعْ المَسِيحْ! ");
INSERT INTO aeu_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","ونْتِيجِةْ خَطِيئِةْ إِنْسَانْ وَاحِدْ مُشْ كِيمَا نْتِيجِةْ هْدِيِّةْ اللَّهْ. نْتِيجِةْ خَطِيئِةْ إِنْسَانْ وَاحِدْ خَلَّاتْ اللَّهْ يُحْكُمْ عَالنَّاسْ الكُلْ، آمَا هْدِيِّةْ اللَّهْ وَصْلِتْهُمْ لِلصَّلَاحْ حَتَّى بَعْدْمَا عَمْلُوا بَرْشَة ذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","إِذَا كَانْ بْخَطِيئِةْ إِنْسَانْ وَاحِدْ سَيْطِرْ المُوتْ عَالنَّاسْ الكُلْ بِسْبَبْ الإِنْسَانْ الوَاحِدْ هَاذَاكَا، مَالَا تَوَّا، الِّي رَدْهُمْ اللَّهْ صَالْحِينْ بْنِعْمْتُو العْظِيمَة، بِشْ يْعِيشُوا ويِمْلْكُوا عْلَى طْرِيقْ إِنْسَانْ وَاحِدْ، الِّي هُوَّ يَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","مَالَا، كِيمَا خَطِيئِةْ إِنْسَانْ وَاحِدْ جَابِتْ المُوتْ لِلنَّاسْ الكُلْ، صَلَاحْ إِنْسَانْ وَاحِدْ جَابْ الصَّلَاحْ الِّي يَعْطِي الحَيَاةْ، لِلنَّاسْ الكُلْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","وكِيمَا بْخَطِيئِةْ إِنْسَانْ وَاحِدْ النَّاسْ الكُلْ وَلَّاوْ مُذْنْبِينْ، زَادَا، بْطَاعِة إِنْسَانْ وَاحِدْ بَرْشَة نَاسْ بِشْ يْوَلِّيوْ صَالْحِينْ. ");
INSERT INTO aeu_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","الشَّرِيعَة جَاتْ بَاشْ تُكْثُرْ المَعْصِيَة، آمَا وِينْ تُكْثُرْ المَعْصْيَة تْزِيدْ تُكْثُرْ النِّعْمَة، ");
INSERT INTO aeu_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","بَاشْ، كِيمَا سَيْطْرِتْ الخَطِيئَة عَالنَّاسْ الكُلْ بِالمُوتْ، زَادَا تِمْلِكْ النِّعْمَة عَالنَّاسْ الكُلْ بِالصَّلَاحْ، وتَعْطِي الحَيَاةْ الأَبَدِيَّة بْيَسُوعْ المَسِيحْ رَبْنَا. ");
INSERT INTO aeu_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","مَالَا آشْ نْقُولُوا؟ نُقْعْدُوا عَايْشِينْ فِي الذْنُوبْ بَاشْ النِّعْمَة تُكْثُرْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","حَاشَا! أَحْنَا الِّي مُتْنَا بِالنِّسْبَة لِلذْنُوبْ،كِيفَاشْ نُقْعْدُوا نْعِيشُوا فِيهَا؟ ");
INSERT INTO aeu_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","يَاخِي مَا تَعْرْفُوشْ الِّي أَحْنَا الكُلْ، وَقْتِلِّي تْعَمِّدْنَا ووَلِّينَا وَاحِدْ مْعَ المَسِيحْ يَسُوعْ، تْعَمِّدْنَا بَاشْ نِتْشَارْكُوا مْعَاهْ فِي مُوتُو؟ ");
INSERT INTO aeu_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","وكِي تْعَمِّدْنَا، هَاذَا مَعْنَاهْ الِّي أَحْنَا مُتْنَا مْعَاهْ وتِدْفِنَّا مْعَاهْ، بَاشْ، كِيمَا قَامْ المَسِيحْ مِالمُوتْ بْقُدْرِةْ الآبْ، أَحْنَا زَادَا نْعِيشُوا حْيَاةْ جْدِيدَة. ");
INSERT INTO aeu_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","ومَادَامْ وَلِّينَا وَاحِدْ مْعَاهْ فِي مُوتْ كِيمَا مُوتُو، أَكِيدْ بِشْ نْوَلِّيوْ وَاحِدْ مْعَاهْ فِي قْيَامَة كِيمَا قْيَامْتُو. ");
INSERT INTO aeu_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","وأَحْنَا نَعْرْفُوا الِّي الإِنْسَانْ القْدِيمْ الِّي فِينَا تِصْلَبْ مْعَ المَسِيحْ، بَاشْ الذْنُوبْ مَا عَادِشْ يْكُونْ عَنْدْهَا سُلْطَة عْلِينَا، ومَا نَبْقَاوِشْ عَبِيدْ لِيهَا. ");
INSERT INTO aeu_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","عْلَى خَاطِرْ الِّي يْمُوتْ يِتْحَرِّرْ مِالذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","ومَادَامْنَا مُتْنَا مْعَ المَسِيحْ، أَحْنَا نَمْنُوا الِّي بِشْ نَحْيَاوْ مْعَاهْ زَادَا. ");
INSERT INTO aeu_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","ونَعْرْفُوا الِّي المَسِيحْ، بَعْدْمَا قَيْمُو اللَّهْ مِالمُوتْ، مُشْ بِشْ يْمُوتْ مَرَّة أُخْرَى، والمُوتْ مَعَادِشْ عَنْدْهَا سُلْطَة عْلِيهْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","عْلَى خَاطْرُو وَقْتِلِّي مَاتْ، مَاتْ عْلَى خَاطِرْ الذْنُوبْ مَرَّة وَحْدَة، آمَا تَوَّا، الحْيَاةْ الِّي يَحْيَاهَا، يَحْيَاهَا لِلَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","كِيفْ كِيفْ إِنْتُومَا زَادَا، إِحْسْبُوا رْوَاحْكُمْ مُوتَى بِالنِّسْبَة لِلذْنُوبْ، وحَيِّينْ لِلَّهْ بْيَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","مَالَا مَا تْخَلِّيوِشْ الذْنُوبْ تْسَيْطِرْ عْلَى بْدَنْكُمْ الفَانِي وتْوَلِّيوْ اتَّبْعُوا شْهَاوِيهْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","مَا تْسَلْمُوشْ أَعْضَاءْ بْدَنْكُمْ لِلذْنُوبْ، بَاشْ مَا تْوَلِّيشْ سْلَاحْ لِلشَّرْ، آمَا سَلْمُوا رْوَاحْكُمْ لِلَّهْ بْصِيفِتْكُمْ قُمْتُوا حَيِّينْ مِالمُوتْ، وسَلْمُولُو أَعْضَاءْ بْدَنْكُمْ، سْلَاحْ لْكُلْ مَاهُو صَالَحْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","وهَكَّا، مَا عَادِشْ يْكُونْ لِلذْنُوبْ سُلْطَة عْلِيكُمْ، مَادَامْ مَاكُمْشْ تَحْتْ حُكْمْ الشَّرِيعَة، آمَا تَحْتْ حُكْمْ النِّعْمَة. ");
INSERT INTO aeu_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","مَالَا كِيفَاشْ؟ نَعْمْلُوا الذْنُوبْ مَادَامْنَا تَحْتْ حُكْمْ النِّعْمَة مُشْ تَحْتْ حُكْمْ الشَّرِيعَة؟ حَاشَا! ");
INSERT INTO aeu_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","يَاخِي مَا تَعْرْفُوشْ الِّي، كِي تْحُطُّوا رْوَاحْكُمْ فِي خِدْمِةْ وَاحِدْ واطِّيعُوهْ، تْوَلِّيوْ عَبِيدْ عَنْدُو؟ يَا إِمَّا تْكُونُوا عَبِيدْ لِلذْنُوبْ الِّي يْهِزُّوا لِلْمُوتْ، وَلَّا تْكُونُوا عَبِيدْ لِلطَّاعَة الِّي تْهِزْ لِلصَّلَاحْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","قْبَلْ كُنْتُوا عَبِيدْ لِلذْنُوبْ، آمَا الحَمْدْ لِلَّهْ، عْلَى خَاطِرْكُمْ طُعْتُوا مِنْ كُلْ قْلُوبْكُمْ التَّعْلِيمْ الِّي خْذِيتُوهْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","وتَوَّا تْحَرَّرْتُوا مِالذْنُوبْ ووَلِّيتُوا عَبِيدْ لِلصَّلَاحْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","وآنَا نْعَبْرِلْكُمْ بْلُوغَة سَاهْلَة خَاطِرْنِي نَعْرِفْ الِّي صْعِيبْ عْلِيكُمْ تِفْهْمُوا. مَالَا، كِيمَا خَلِّيتُوا أَعْضَاءْ بْدَنْكُمْ يْكُونُوا عَبِيدْ لِلنْجَاسَة والشَّرْ الِّي خَلَّى شَّرْكُمْ يْزِيدْ ، تَوَّا خَلِّيوْ أَعْضَاءْ بْدَنْكُمْ يْكُونُوا عَبِيدْ لِلصَّلَاحْ، الِّي يْخَلِّي قَدَاسِتْكُمْ تْزِيدْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","عْلَى خَاطِرْ، كِي كُنْتُوا عَبِيدْ لِذْنُوبْ، كُنْتُوا أَحْرَارْ، مُشْ مُطَالْبِينْ بَاشْ تَعْمْلُوا الصَّلَاحْ. ");
INSERT INTO aeu_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","يَاخِي، آشْ رْبَحْتُوا مِالحَاجَاتْ الِّي تَوَّا تِحْشْمُوا بِيهَا، ولِّي عَاقْبِتْهَا المُوتْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","آمَا تَوَّا، بَعْدْمَا تْحَرَّرْتُوا مِالذْنُوبْ ووَلِّيتُوا عَبِيدْ لِلَّهْ، الِّي رْبَحْتُوهْ هِيَّ القَدَاسَة، الِّي نْتِيجِتْهَا الحَيَاةْ الأَبَدِيَّة. ");
INSERT INTO aeu_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","عْلَى خَاطِرْ عَاقِبْةْ الذْنُوبْ هِيَّ المُوتْ، آمَا الهْدِيَّة الِّي يَعْطِيهَا اللَّهْ، هِيَّ الحَيَاةْ الأَبَدِيَّة بْيَسُوعْ المَسِيحْ رَبْنَا. ");
INSERT INTO aeu_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","مَا يَخْفَاشْ عْلِيكُمْ يَا خْوَاتِي، الِّي قَانُونْ الشَّرِيعَة مَا يِطَبِّقْ عَالإِنْسَانْ كَانْ وهُوَّ حَيْ، وآنَا قَاعِدْ نْكَلِّمْ فِي نَاسْ يَعْرْفُوا الشَّرِيعَة، ");
INSERT INTO aeu_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","ونَعْطِيكُمْ مِثَالْ: المْرَا المْعَرْسَة تُرْبِطْهَا الشَّرِيعَة بْرَاجِلْهَا مَادَامُو حَيْ. آمَا كَانْ رَاجِلْهَا مَاتْ، تْوَلِّي، حَسْبْ الشَّرِيعَة، مَا عَادِشْ مَرْبُوطَة بِيهْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","هَاذَاكَا عْلَاشْ كَانْ وَلَّاتْ مَرْتْ رَاجِلْ آخَرْ ورَاجِلْهَا حَيْ، تِتْسَمَّى زَانْيَة. آمَا كَانْ رَاجِلْهَا يْمُوتْ، تْوَلِّي حُرَّة مِالقَانُونْ هَاذَا، ومَا تِتْسَمَّاشْ زَانْيَة كَانْ تْعَرِّسْ بْرَاجِلْ آخِرْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","وهَكَّا إِنْتُومَا زَادَا يَا خْوَاتِي، بْمُوتْ المَسِيحْ، وَلِّيتُوا مُوتَى بِالنِّسْبَة لِلشَّرِيعَة، بَاشْ تْنَجْمُوا تْكُونُوا تَابْعِينْ لْوَاحِدْ آخِرْ، مَعْنَاهَا تَابْعِينْ لِلْمَسِيحْ الِّي قَامْ مِالمُوتْ، بَاشْ تَعْمْلُوا أَعْمَالْ صَالْحَة لِلَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","وَقْتِلِّي كُنَّا عَايْشِينْ بِطْبِيعِتْنَا البَشَرِيَّة الفَاسْدَة، كَانِتْ شْهَاوِينَا الفَاسْدَة الِّي ظَهْرِتْهُمْ الشَّرِيعَة، هِيَّ الِّي تِتْحَكِّمْ فِي البْدَنْ الكُلْ، بَاشْ تْخَلِّينَا نَعْمْلُوا أَعْمَالْ تْهِزْ لِلْمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","آمَا تَوَّا تْحَرِّرْنَا مِالشَّرِيعَة، عْلَى خَاطِرْ مُتْنَا بِالنِّسْبَة لِلِّي كَانْ رَابِطْنَا، بَاشْ نِعْبْدُوا اللَّهْ بْطَرِيقَة جْدِيدَة، بِالرُّوحْ، مُشْ بْطَرِيقِةْ الفَرَايِضْ المَكْتُوبَة. ");
INSERT INTO aeu_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","مَالَا آشْ نْقُولُوا؟ يَاخِي الشَّرِيعَة بِيدْهَا مُذْنْبَة؟ حَاشَاهَا! بِالعَكْسْ مَا عْرَفْتْ شْنُوَّة هُوَّ الشَّرْ كَانْ بِالشَّرِيعَة. عْلَى خَاطِرْ مَا كُنْتِشْ بِشْ نَعْرِفْ شْنِيَّة هِيَّ الشَّهْوَة كَانْ الشَّرِيعَة مَا قَالِتْشْ: «مَا تِشْتْهِيشْ». ");
INSERT INTO aeu_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","آمَا الخَطِيئَة اسْتْغَلِّتْ الوْصِيَّة بَاشْ تْحَرِّكْ فِيَّا الشْهَاوِي الكُلْ. عْلَى خَاطِرْ، كَانْ مُشْ مِالشَّرِيعَة، رَاهِي الخَطِيئَة مَا عَنْدْهَاشْ سُلْطَة. ");
INSERT INTO aeu_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","قْبَلْ مَا نَعْرِفْ الشَّرِيعَة، كُنْتْ حَيْ، آمَا وَقْتِلِّي جَاتْ الشَّرِيعَة، الذْنُوبْ حْيَاتْ ");
INSERT INTO aeu_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","وآنَا مُتْ، والوْصِيَّة الِّي المَفْرُوضْ تَعْطِي الحَيَاةْ، هِيَّ بِيدْهَا هَزِّتْنِي لِلْمُوتْ، ");
INSERT INTO aeu_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","عْلَى خَاطِرْ الذْنُوبْ لْقَاتْ فُرْصِتْهَا فِي الوْصِيَّة، وخَدْعِتْنِي وقَتْلِتْنِي بِيهَا. ");
INSERT INTO aeu_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","مَالَا، الشَّرِيعَة مُقَدْسَة، والوْصِيَّة مُقَدْسَة وعَادْلَة وصَالْحَة. ");
INSERT INTO aeu_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","يَاخِي، الصَّلَاحْ يْهِزْنِي لِلْمُوتْ؟ حَاشَاهْ! آمَا الذْنُوبْ هِيَّ الِّي اسْتَعْمْلِتْ الشَّرِيعَة الصَّالْحَة وتْسَبْبِّتْلِي فِي المُوتْ، مُشْ الشَّرِيعَة بِيدْهَا. وهَاذَا بَاشْ تُظْهِرْ الذْنُوبْ عْلَى حْقِيقِتْهَا. عْلَى خَاطِرْ، بِالوْصِيَّة، يُظْهُرْ شَرْ الذْنُوبْ لْأَقْصَى دَرْجْتُو. ");
INSERT INTO aeu_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","أَحْنَا نَعْرْفُوا الِّي الشَّرِيعَة مِنْ رُوحْ اللَّهْ، آمَا آنَا بَشَرْ وعَبْدْ لِلذْنُوبْ: ");
INSERT INTO aeu_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","آنَا مُشْ فَاهِمْ رُوحِي فَاشْ نَعْمِلْ، عْلَى خَاطِرْ الِّي نْحِبْ نَعْمْلُو مَا نَعْمْلُوشْ، ولِّي مَا نْحِبِّشْ نَعْمْلُو هَاذَاكَا هُوَّ الِّي نَعْمْلُو. ");
INSERT INTO aeu_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","ومَادَامْنِي نَعْمِلْ فِلِّي مَا نْحِبِّشْ نَعْمْلُو، مَعْنَاهَا نْوَافِقْ الِّي الشَّرِيعَة صَالْحَة. ");
INSERT INTO aeu_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","فِي الحْقِيقَة مَانِيشْ آنَا الِّي قَاعِدْ نَعْمِلْ فِي هَاذَا، آمَا الذْنُوبْ المَوْجُودَة فِيَّا هِيَّ الِّي تَعْمِلْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","آنَا نَعْرِفْ الِّي مَا فِيَّا حَتَّى شَيْ صَالَحْ، نُقْصُدْ فِي طْبِيعْتِي البَشَرِيَّة الفَاسْدَة. عْلَى خَاطِرْنِي نْحِبْ نَعْمِلْ الخِيرْ، آمَا مَا انَّجَّمْشْ نَعْمْلُو. ");
INSERT INTO aeu_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","الخِيرْ الِّي نْحِبْ نَعْمْلُو مَا نَعْمْلُوشْ، آمَا الشَّرْ الِّي مَا نْحِبِّشْ نَعْمْلُو، هَاذَاكَا الِّي نَعْمْلُو. ");
INSERT INTO aeu_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","وإِذَا كَانْ نَعْمِلْ فِلِّي مَا نْحِبِّشْ نَعْمْلُو، مَالَا مَانِيشْ آنَا الِّي نَعْمِلْ فِيهْ، آمَا الذْنُوبْ المَوْجُودَة فِيَّا هِيَّ الِّي تَعْمِلْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","وَلَّالِي كَايِنُّو قَانُونْ: كِي نْحِبْ نَعْمِلْ الخِيرْ، نَلْقَى رُوحِي نَعْمِلْ فِي الشَّرْ. ");
INSERT INTO aeu_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","ورَانِي مِنْ دَاخِلْ فَرْحَانْ بْشَرِيعِةْ اللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","آمَا فَمَّة قُوَّة أُخْرَى فِيَّا تْحَارِبْ فِي القَانُونْ الِّي يِقْبْلُو عَقْلِي، وتْخَلِّينِي مَرْبُوطْ فِي قُوِّةْ الذْنُوبْ السَّاكْنَة فِيَّا. ");
INSERT INTO aeu_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","آنَا إِنْسَانْ تَعِيسْ! شْكُونْ بِشْ يْمَنَّعْنِي مِنْ هَا البْدَنْ الِّي مَاشِي لِلْمُوتْ؟ ");
INSERT INTO aeu_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","نُشْكُرْ اللَّهْ الِّي يْمَنَّعْنِي بْرَبْنَا يَسُوعْ المَسِيحْ. مَالَا، آنَا بْعَقْلِي خَاضَعْ لْشَرِيعِةْ اللَّهْ، آمَا بْطْبِيعِةْ البَشَرْ الفَاسْدَة آنَا خَاضَعْ لْشَرِيعِةْ الذْنُوبْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","مَالَا تَوَّا، مَا عَادِشْ فَمَّة حُكْمْ عَلِّي تَابْعِينْ يَسُوعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","عْلَى خَاطِرْ شَرِيعِةْ الرُّوحْ الِّي يَعْطِي الحَيَاةْ بْيَسُوعْ المَسِيحْ، حَرِرِّتْنِي مِنْ شَرِيعِةْ الذْنُوبْ والمُوتْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","ولِّي مَا نَجْمِتْشْ تَعْمْلُو الشَّرِيعَة بِسْبَبْ ضُعْفْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة، عَمْلُو اللَّهْ وَقْتِلِّي بْعَثْ إِبْنُو الِّي وَلَّى بَشَرْ كِيفْنَا أَحْنَا المُذْنْبِينْ، بَاشْ يْحَرِّرْنَا مِالخَطِيئَة ويُحْكُمْ عَالخَطِيئَة المَوْجُودَة فِي الطْبِيعَة البَشَرِيَّة الفَاسْدَة. ");
INSERT INTO aeu_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","عْمَلْ هَاذَا بَاشْ الصَّلَاحْ الِّي تُطْلْبُو الشَّرِيعَة يِتْحَقَّقْ فِينَا أَحْنَا الِّي نْعِيشُوا حَسْبْ الرُّوحْ، مُشْ حَسْبْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة. ");
INSERT INTO aeu_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","رَاهُمْ الِّي يْعِيشُوا حَسْبْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة، يْفَكْرُوا فِي أُمُورْ بَشَرِيَّة. ولِّي يْعِيشُوا حَسْبْ الرُّوحْ، يْفَكْرُوا فِي أُمُورْ رُوحِيَّة. ");
INSERT INTO aeu_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","التَّفْكِيرْ فِي أُمُورْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة آخْرُو مُوتْ، آمَا التَّفْكِيرْ فِي أُمُورْ الرُّوحْ آخْرُو حَيَاةْ وسَلَامْ، ");
INSERT INTO aeu_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","ولِّي يْحِبْ يْرَضِّي الطْبِيعَة البَشَرِيَّة الفَاسْدَة هُوَّ عْدُو اللَّهْ، عْلَى خَاطِرْ مَا يْطِيعِشْ شَرِيعِةْ اللَّهْ. وفِي الحْقِيقَة مَا يْنَجِّمْشْ يْطِيعْهَا. ");
INSERT INTO aeu_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","ولِّي هُومَا تَحْتْ سُلْطِةْ الطْبِيعَة البَشَرِيَّة مَا يْنَجْمُوشْ يْرَضِّيوْ اللَّهْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","آمَا إِذَا كَانْ رُوحْ اللَّهْ يُسْكُنْ فِيكُمْ، إِنْتُومَا مَاكُمْشْ تَحْتْ سُلْطِةْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة، آمَا تَحْتْ سُلْطِةْ الرُّوحْ. ولِّي مَا عَنْدُوشْ رُوحْ المَسِيحْ، رَاهُو مُشْ تَابَعْ المَسِيحْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","آمَا، إِذَا كَانْ المَسِيحْ فِيكُمْ، رَغْمِلِّي بْدَنَّاتْكُمْ يْجِيهَا نْهَارْ وتْمُوتْ بِسْبَبْ الذْنُوبْ، الرُّوحْ يَعْطِيكُمْ حْيَاةْ عْلَى خَاطِرْ اللَّهْ رَدْكُمْ صَالْحِينْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","وإِذَا كَانْ رُوحْ اللَّهْ الِّي قَيِّمْ يَسُوعْ مِالمُوتْ يُسْكُنْ فِيكُمْ، رَاهُو الِّي قَيِّمْ المَسِيحْ مِالمُوتْ بِشْ يَعْطِي حَيَاةْ لِبْدَنَّاتْكُمْ الفَانْيَة بْرُوحُو الِّي يُسْكُنْ فِيكُمْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","مَالَا يَا خْوَاتِي، رَانَا عَنْدْنَا وَاجِبْ، آمَا وَاجِبْنَا مُشْ بَاشْ نْطِيعُوا الطْبِيعَة البَشَرِيَّة الفَاسْدَة ونْعِيشُوا حَسْبْهَا هِيَّ. ");
INSERT INTO aeu_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","عْلَى خَاطِرْ كَانْ تْعِيشُوا حَسْبْ الطْبِيعَة البَشَرِيَّة الفَاسْدَة بِشْ تْمُوتُوا، آمَا إِذَا كَانْ بِالرُّوحْ تُقْتْلُوا أَعْمَالْهَا رَاكُمْ بَاشْ تَحْيَاوْ. ");
INSERT INTO aeu_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","الِّي يْقُودْهُمْ رُوحْ اللَّهْ، هُومَا وْلَادْ اللَّهْ، ");
INSERT INTO aeu_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","رَاكُمْ مَا خْذِيتُوشْ رُوحْ يْرَجَّعْكُمْ عَبِيدْ مَرَّة أُخْرَى ويْرَجَّعْكُمْ لِلْخُوفْ، آمَا خْذِيتُوا رُوحْ يْرُدْكُمْ وْلَادْ اللَّهْ، رُوحْ يْخَلِّينَا نْقُولُوا لِلَّهْ: «بَابَا! يَا بُونَا!» ");
INSERT INTO aeu_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","والرُّوحْ هُوَّ بِيدُو يِشْهِدْ مْعَ رْوَاحْنَا الِّي أَحْنَا وْلَادْ اللَّهْ. ");
INSERT INTO aeu_