﻿USE sofia;
DROP TABLE IF EXISTS sofia.aer_vpl;
CREATE TABLE aer_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aer_vpl WRITE;
INSERT INTO aer_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1"," Lyetenyenge akwele, arne anetyakenhenge-urrke, Ngkartele apmere ahelhe nhenhe uthene alkere uthene arrpmerneke. ");
INSERT INTO aer_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Urreke Ngkartele arne iwenhe-iwenhe apeke renhe arrpmernetyenhenge, apmere ahelhe nhenhe re arltwe anthurre anekenge, arneke arrangkwe anthurre aneke. Arrekwele anthurre re ingwemerte anthurre aneke. Ingwemertele apmere ahelhe nhenhe-arlke, kwatye-arlke arteke. Rlke akngerre anthurrele wernetyame angkulye akantyere ingwemerte anthurre areye utepe-utepe-irretyame kwatye artepele. ");
INSERT INTO aer_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Ngkarte anteme angkeke, “Alkngenthe pwarrtyaye!” Kenhe arratye alkngenthe iparrpe pwarrtyerlenge. ");
INSERT INTO aer_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","5","Re areke alkngenthe pwarrtyentye Rarle aknganeke-arle mwerre aneke. Kele imerte Re alkngenthe pwarrtyentye arritnye akemele “Arlte,” arlte-ngentyele ingwemerte akalkelhe-ilemele, kele imerte Re ingwemerte arritnye akemele “Ingwe.” Kele angwerre-angwerre-irreke, ingwemerte-irremele ingwemerte rarle aneke, ingweleme anteme irreke. Alakenhe arlte anyente arrwekele nhenhe re aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Kele imerte Ngkarte kwatyeke angkeke, “Kwatyaye akalke-irraye, atherrame mpwaremele itepele-ante atherre akenhe mpwelekenge mpepele kwatyeke arrangkwe anetyenhenge, kwatye awenge arrpenhe kwenele kwatye awenge arrpenhe akertnele.” ");
INSERT INTO aer_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kele yanhe-ngentyele alakenhe rarle ratherre irreke. Re arrkngerte arrerneke ikwere-atherre, ratherre urlerteke-urlerte anetyeke. Kwatye arrpenhe arrkngerte ikwerenge akertnenyele inteke, kenhe kwatye arrpenhe arrkngerte ikwerenge kwenele. ");
INSERT INTO aer_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Ngkartele arrkngerte mpwepeke renhe “alkere” arritnye akeke. Kele angwerre-angwerre-irreke, ingwemerte-irremele ingwemerte rarle aneke, ingweleme anteme irreke. Kele imerte ingweleme-irreke arlte-irremele, arlte atherrame tnetye-alpeke. ");
INSERT INTO aer_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Kele Ngkarte angkeke, “Kwatye ingkirreke kwenele-arle inteme ahelhe yanhenge akalke-irremele intaye ahelhe ararrtye irretyenhenge!” Kenhe alakenhe-arle irrerlenge Ngkarte-arle angkeke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Ngkartele anteme apmere ararrtye yanhe renhe arraterlenge “ahelhe” atniweke, kenhe kwatye Rarle apurtelhe-ileke yanhe renhe Re “kwatye alaye” atniweke. Ngkartele areke iwenhe-arle Re aknganeke-arle mwerre aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Yanhe iperre-ngentyele Ngkarte angkeke, “Ahelhe-ngentyele arne-arlke, merne-akerte-arlke, arne arrpenheke-arrpenhe areye-ngentyele annge ikwerenhe-arrpe-arle urlerteke-urlerte, name atherrke-arlke arrpenhe-arrpenhe lyapewarraye!” Alakenhe-arle irrerlenge Ngkarte-arle angkeke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Ahelhe-ngentyele name atherrke-arlke, arne atningke areye, arrpenheme annge-akerte areye-arlke, arne atningke merne annge itnekenhe-arrpe-arle urlerteke-urlerte. Ngkartele areke iwenhe-arle Re aknganeke-arle mwerre aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Kele angwerre-angwerre-irreke, ingweleme irremele arlte-irrintyemele arlte arrpenhe ikwerele. Arlte urrpetye anteme-arle. ");
INSERT INTO aer_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Ngkarte Re imerte angkemele, “Alkngenthe atningke akertnenge arrataye, alkerele pwarrtyetyeke, itne-arle arlte ingwenge akalkelhe-iletyenhenge! Alkere akertnele akwete anaye ingkirrekele itelaretyeke ilengare itne unernte-werretyeke.” Alakenhe-arle irrerlenge Ngkarte angkeke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Ngkartele alkngenthe akngerre atherrame arrpmerneke. Re arrpmerneke alkngenthe arrpenhenge akngerre-ulkere arltenge pwarrtyetyeke, arlennge-arle. Kele imerte re alkngenthe akweke-ulkere arrpmerneke ingwele anteme pwarrtyetyeke. Re kwerralye ingkirreke-arlke arrpmerneke. ");
INSERT INTO aer_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Re alkngenthe atningke alkereke arrerneke, arlennge, atnyentye, kwerralye areye, ahelhe-werne-atheke itne pwarrtyerlte-anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Re arlennge arrerneke arlteke akngerrepate anetyeke, atnyentye uthene kwerralye uthene arrerneke ingweke akngerrepate anetyeke. Alakenhe-arle Re alkngenthe atherrame alkereke arrerneke, arlte uthene ingwe uthene ikwere-atherrenge-arrpe akalke-akalke anerle-anerretyeke. Ngkartele areke iwenhe-arle Re aknganeke-arle mwerre aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Kele angwerre-angwerre-irreke, ingweleme irremele arlte-irrintyemele arlte arrpenhe ikwerele. Arlte urrpetye arrpenhe nhenhele arlte awethe arrpenhe anteme aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Kele imerte Ngkarte angkemele, “Ayenge ahentye-aneme kwatye alayeke akngerre-irraye irrpennge arrpe-anenhe-akerte-arlke iwenhe-iwenhe arrpenhe kwatye alaye-arenye areye-akerte-arlke. Ayenge ahentye-aneme thipeke iwenhe-iwenhe apeke arrantherre kele alkereke-irretyeke. Ayenge thipe arrekantherre ahentye-aneme atningke-irraye.” ");
INSERT INTO aer_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kele imerte Ngkartele irrpennge areye-arlke, kwatye-arenye akngerre-apenhe areye-arlke arrpmerneke, arrpenhe ingkirreke kwatyele anenhe-anenhe re arrpmerneke. Re thipe arrpe-anenhe anthurre arrpmerneke alkereke-irretyeke. Ngkartele areke iwenhe-arle Re aknganeke-arle mwerre aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Ngkarte itneke mwerre angkemele, “Ayenge arrekantherre ahentye-aneme atningke anthurre akngerre-irraye, akweke areye atningke atnyenewarraye! Arrantherre kwatye alaye-arenye atningke-irraye kwatye mpwanke-irretyeke. Arrantherre thipe areye-arle atningke anthurre akngerre-irraye, alkere mpwanke-irraye.” ");
INSERT INTO aer_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Kele angwerre-angwerre-irreke, ingweleme irremele arlte-irrintyemele arlte arrpenhe ikwerele. Arlte arrpenhe nhenhele number 5 anteme-arle. ");
INSERT INTO aer_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Kele imerte Ngkarte angkeke, “Ayenge ahentye-aneme apmere arrpe-anenheke ahelheke itethe areye atningke-irretyeke. Kere arlkwentye akngerre areye-arlke, kere arlkwentye akngerre-kwenye areye-arlke, kere ingke-akerte areye-arlke, arrentye areye-arlke arne akweke nhenge ahelhele unthentye akngerre areye, arrpenhe nterte areye-arlke, arrpenhe ahe akngerre areye-arlke. Ingkirreke anthurre ayenge ahentye-aneme atningke-irretyeke.” Alakenhe-arle irrekenge Ngkarte-arle angkeke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Kele Ngkartele ingkirreke anthurre aknganeke. Rarle kere iwenhe-iwenhe apeke ingke-akerte areye-arlke, arrentye arrpenheke-arrpenhe areye-arlke arne akweke nhenge ahelhele unthentye akngerre areye, arrpenhe nterte areye-arlke, arrpenhe ahe akngerre areye-arlke, re arrpmerneke. Ngkartele areke iwenhe-arle Re aknganeke-arle mwerre aneke. ");
INSERT INTO aer_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","27","Kele ikwerenge-ntyele Ngkarte angkemele, “Anwerne tyerrtye mpwarewarreye anwerne-arteke. Itne anteme-arle ingkirrekeke akngerrepate anetyenhenge itnenhe arntarnte-aremele: kwatye-arenye ingkirrekeke-arlke, thipe alkere-arenye ingkirrekeke-arlke, arrentye arrpenheke-arrpenhe areyeke-arlke arne akweke nhenge ahelhele unthentye akngerre areye-arlke, arrpenhe nterte areyeke-arlke, arrpenhe ahe akngerre areyeke-arlke, akngerre-arlke akweke areyeke-arlke ingkirreke anthurreke.” Kele Ngkartele tyerrtye areye aknganeke Re-arteke anthurre anetyeke, Re urreye uthene marle uthene aknganemele. ");
INSERT INTO aer_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Kele imerte Ngkarte itneke mwerre angkemele, “Ayenge ahentye-aneme arrantherre ampe areye atnyenetyeke, ayenge ahentye-aneme ampe atningke anthurre atnyenetyeke itne-arle apmere arrpe-anenhe-werne anteke-irretyeke ahelhe nhenhe arrpe-anenhele. Ayenge ahentye-aneme arrantherre apmere ahelhe nhenheke akngerrepate anetyenhenge renhe arntarnte-aretyeke. Arrantherre ingkirrekeke akngerrepate anerrirretyenhe, kwatye-arenye ingkirrekeke-arlke, thipe ingkirrekeke-arlke, arrpenhe ahelhe-arenye ingkirrekeke-arlke, arne iwenhe-iwenhe ingkirrekeke apeke.” ");
INSERT INTO aer_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Kele imerte Re angkemele, “Araye, The arrenhantherrenhe merne antheme arlkwetyeke, iwenhe-iwenhe renhe apeke, merne ntange-akerte areye, arne alhengkweltye merne-akerte, ingkirreke alakenhe renhe arlkwenhe-arlkwenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Kele The name atherrke ahelhe yanhe ikwere arrernemele kere alhengkweltye ahelhe-arenye ingkirrekeke, thipe alkere-arenye ingkirrekeke, arrpenhe iwenhe-iwenhe apeke ingkirrekeke atherrke arlkwenhe-arlkwenhe itneke.” Alakenhe-arle irrerlenge Ngkarte-arle angkeke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Ngkartele areke iwenhe-arle Re mpwareke-arle mwerre anthurre aneke. Kele angwerre-angwerre-irreke, ingweleme irremele arlte-irrintyemele arlte arrpenhe ikwerele. Arlte nhenhele number 6 uyerreke. ");
INSERT INTO aer_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Alakenhe renhe-arle Ngkarte ingkirreke mpwarentye uyerreme. Re alkere, ahelhe, arrpenhe ingkirreke anthurre-arle mpwarentye uyerreme. ");
INSERT INTO aer_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Arlte six-pele-iperre, kele Re ingkirreke mpwarentye uyerreke-arlenge. Arlte arrpenhele, arlte number 7, Re imerte arrernelheke ltyerremele. ");
INSERT INTO aer_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Kele imerte Ngkartele arlte nhenhe renhe arrpenhe ulkere-arle mpwaremele, ikwerenhe-arrpe-arle. Re renhe arlte apurrke mpwareke tyerrtye areyele-arle Ngkarte itelarerrirretyeke. Alakenhe Re aknganeke Rarle ingkirrenyeke mpwarentye uyerreke-arlenge arlte 7-nge ltyerremele aneke. ");
INSERT INTO aer_vpl VALUES ("GN2_4a","002_2_4a","GEN","2","4a","4a","Ayeye arrpenhe nhenhele ileme nthakenhe-arle Re alkere uthene ahelhe uthene aknganeke, arne arrpenhe ingkirreke anthurre re aknganeke. ");
INSERT INTO aer_vpl VALUES ("GN2_4b","002_2_4b","GEN","2","4b","5","Ngkartele ahelhe uthene alkere uthene arrpmerneke. Ayeye nhenhe arne ingkirreke-akerte Rarle arrpmerneke. Kenhe apmere ahelhe akenhe arltwe ware-arle aneke, arne areye-arlke arne atherrke areye-arlke lyapetyakenhe ahelhenge Ngkartele-arle kwatye yernetyakenhe akwetenge ahelhele urntetyeke. Kenhe Re akenhe tyerrtye areye aknganetyakenhe akwete ahelhe renhe atyerte-iletyeke kartene mpwaretyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Kwatye pintye ahelhe-ngentyele arrateke ahelhe terte mpwaremele. ");
INSERT INTO aer_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Kele imerte Ngkartele ahelhe ineke ahelhe yanhenge tyerrtye aknganeke. Ngkartele imerte alhe renhe pewe-ilemele renhe itethe-ilemele, kenhe tyerrtye re akenhe arratye-arle itethe-irrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Yanhe ikwerenge-ntyele Ngkartele kartene arrpmerneke ikngerre-ampinyeke apmere Eden arritnye ikwere atniweke. Kele imerte Re tyerrtye nhenge kartene ikwere arrernemele. ");
INSERT INTO aer_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Kele imerte Ngkartele arne mwerre arrpenheke-arrpenhe areye ahelhe-ngentyele arratelhe-ilemele arrerneke, arne merne mwerre-akerte areye-arle arlkwenhe-arlkwenhe-arle, arne arrpenheme akenhe mwerre aretyeke ware-arle. Kartene mpepe ikwerele Re arne impene atherre ngkernemele lyapelhe-ileke, arne anyentele itethele-antheme-arle, kenhe arne arrpenhe re akenhe tyerrtye areye akaltyele-antheme itne-arle itelarerrirretyenhenge arne iwenhe apeke mwerre areye, arne iwenhe apeke akurne areye. ");
INSERT INTO aer_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","14","Lhere apmere Eden-ele awenge alheme kartene yanhe anhemele arne ingkirrenyeke lyapelhe-ilemele. Kele imerte lhere akalke-irremele lhere four-peleke. Lhere arrekwele Pishon arritnye, awenge alheke apmere Havilah-ele. Apmere yanhele gold uthene apwerte mwerre akngerre arrpenhe areye uthene, ankere ikwemeye-arteke anthurre ntyentye aneke. Lhere arrpenhe Gihon arritnye, awenge alheke apmere Cush-ele. Lhere arrpenhe Tigris arritnye, awenge alheke apmere Assyria ikngerre ampinyele. Lhere arrpenhe Euphrates arritnye aneke. ");
INSERT INTO aer_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Kele imerte Ngkartele tyerrtye nhenge inemele apmere Eden ikwere arrerneke, kartene ikwere urrkaperle-anetyeke ahelhe atyerte-ilemele arne-arlke lyapelhe-iletyeke, renhe arntarnte-arerle-anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Kenhe Ngkartele akenhe renhe alkngarre-ileke, “Arne atningke kartenele aneme, mwerre unte merne annge areye arne yanhe areye-ngentyele arlkwetyeke, kele unte arlkwe. ");
INSERT INTO aer_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Kenhe arne anyente tnerlenge unte ikwerenge merne annge arlkwetyeke-kwenye-arle. Kenhe arne yanhele tyerrtye areye akaltyele-antheme itne-arle itelarerrirretyenhenge arne iwenhe apeke mwerre areye, arne iwenhe apeke akurne areye. Arne renhe impaye! Merne annge arne ikwerenge arlkwetyale! Unte apeke yanhe-ngentyele merne annge arlkwetyenhe, arlte yanhe ikwerele kele unte iparrpe anthurre ilweme-arle.” ");
INSERT INTO aer_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Kele imerte Ngkarte awethe angkeke, “Artwe nhenhe anyente-arenye aneme, alakenhe mwerre anetyakenhe-arle. The kele ikwere atyewe mwerre aknganetyenhe, irlkwatherre ikwerenhe. Tyerrtye nhenhe ikwere arratye mwerre anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Urreke Re marle aknganetyenhenge, Ngkartele ahelhe-ngentyele kere areye arrpenhe ingkirreke aknganeke, thipe alkere-arenye ingkirreke-arlke Re aknganeke. Re imerte itnenhene artwe ikwere-werne akngetyeke imernemele re aretyeke, arritnye iwenhe renhe apeke itnenhene atniwetyenhenge. Kele arritnye iwenhe apeke artwe re itnenhene antheke, nhenhe kele arritnye itneke akwete-ante aneke. ");
INSERT INTO aer_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Artwe re imerte kere arrpenheke-arrpenhe ingkirreke-arlke thipe alkere-arenye itnenhene-arlke arritnye antheke. Kenhe irlkwatherre artwe-kenhe anetyakenhe akwete. ");
INSERT INTO aer_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Yanhe ikwerenge-ntyele Ngkartele artwe renhe ankwe-ileke, artwe re ankwe akngerre anteme interlenge. Re ankwe akngerre interlenge Ngkartele utyipme anyente ulte ikwerenhenge ineke, altywere renhe tyelkele martemele anteme. ");
INSERT INTO aer_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Utyipme yanhenge, rarle artwe ikwerenge inemele, Ngkartele marle anteme aknganeke. Kele imerte Re arelhe artwe ikwere-werne akngeke renhe anthemele. ");
INSERT INTO aer_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Kenhe artwele arelhe aremele, re angkeke, “Araye! Nhenhe-athewe irlkwatherre atyinhe anthurre re. Ngkartele utyipme atyinhe inemele, tyelke atyinhe uthene marle irlkwatherre atyenge aknganetyeke. Renhe kele arritnye “arelhe” aketyeke, rarle artwe-ngentyele-arle aknganekenge.” ");
INSERT INTO aer_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Alakenhe ikwerenge artwele anyikwe uthene mikwe uthene imperle-alhemele arelhe anewe-aketyeke. Anewarte ratherre anyente-irremele, ratherre tyerrtye anyente-arteke. ");
INSERT INTO aer_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Kenhe arlte yanhe ikwerele artwe uthene arelhe uthene tyerrtye akethe yenpe-ante anthurre anerle-anerreke, apure-irrerle-anerretyange. ");
INSERT INTO aer_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Kenhe apmwe re akenhe arrpenhe ingkirrekenge ilyernpenye ulkere Ngkartele-arle mpwarekenge. Arlte anyentele apmwele arelhe renhe ularele apayuthnetye-alheke, “Nthakenhe-ame unte itirreme? Yanhe-ame arratye akwele Ngkartele-arle ileke, ‘Mpwele merne annge arne ingkirreke-ngentyele kartene nhenhenge arlkwetyale anetyeke?’” ");
INSERT INTO aer_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Kenhe arelhe re akenhe apmwe ikwere angkirtneke, “Arrangkwe, yanhe arratye anetyakenhe! Ngkartele ilerneke ileke mwerre akwele merne annge ingkirreke kartene nhenhenge-ntyele arlkwerle-anerretyeke. ");
INSERT INTO aer_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Kenhe arne anyente ware kartene mpwepele aneme, ikwerenge-ntyele kwenhe Ngkartele ilernenhe alkngarre-ileke, ‘Mpwele arne yanhenge arlkwetyale anetyeke, mpwele arne renhe anpetyale anetyeke. Mpwele apeke merne annge arne mpwepele yanhe-ngentyele arlkweme kele ilwerle-anerretyenhenge!’” ");
INSERT INTO aer_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Kenhe apmwe re akenhe angkeke, “Arratye anetyakenhe! Mpwele apeke merne annge yanhe arlkwerle-anerremele kenhe mpwele ilwerle-anerretyeke arrangkwe-arle! ");
INSERT INTO aer_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Ngkartele mpwele alakenhe mpwaretyeke-kwenye ileke Rarle itelaremele mpwele-arle merne annge ikwere iperre-ngentyele arlkwemenge, akaltye anthurre irretyenhele. Kele imerte mpwele Ngkarte-arteke anteme anerle-anerremele, mpwele-arle itelaretyenhenge arne iwenhe apeke mwerre areye, arne iwenhe apeke akurne areye. Kele mpwele apeke yanhe itelareme, mpwele Ngkarte-arrpe-arteke anerle-anerretyenhenge.” Alakenhe-arle apmwe ularele angkeke. ");
INSERT INTO aer_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Apmwe re angkeke-arle iperre arelhe re arne renhe arerle-anemele itirreke, “Arne nhenhe apeke mwerre anthurre merne annge nhenhe apeke mwerre arlkwetyeke anteye.” Re awethe itirremele, “Ayekaye, the apeke merne nhenhe arlkwemele, ayenge kele Ngkarte re-arteke antime irremere.” Kele imerte re alhemele merne annge renhe arne nhenge kartene mpwepenge inemele arlkwemele. Re imerte akweke apeke akngemele artwe anewikwe renhe anthetyeke. Kenhe artwe anewikwele akenhe merne renhe anteye arlkwerleke-arle. ");
INSERT INTO aer_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Kele ratherre-arle arlkwerle-anerreke-arle iperre kele iparrpe anthurre akaltye anteme anerle-anerreke. Kele ratherre imerte arerrerle-aneke akaltye aneke ratherre-arle tyerrtye akethe yenpe-ante anthurre anteme anerle-anerremele. Iparrpe anthurre apure anteme irrerle-anerremele. Kele imerte utyerrke arlpelhe anteme ratherre inemele, arlpelhe anyenteke-ilemele alpele mpwarerle-anerreke ikwere-atherrenhe-arrpe tyerrtye akethe artelhetyeke. ");
INSERT INTO aer_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Kele angwerre-angwerrele ratherre Ngkarte awerle-anerreke kartenele irrerntenge untherlenge. Kenhe ratherre Ngkarte-ketye alengke-iwelherle-anerreke, arne artnele. ");
INSERT INTO aer_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Kenhe Ngkarte re akenhe artwe ikwere antangkeke, “Nthenhe-ame unte?” ");
INSERT INTO aer_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Artwe re tyerneke, “The ngenhe kartenele untherlenge aweke, ayenge atere-irreke anteme, ayenge-arle tyerrtye akethe yenpe-ante aneke. Alakenhe ikwerenge ayenge ngkwengetye alengke-iwelheke anteme.” ");
INSERT INTO aer_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Kenhe Ngkartele renhe apayuthneke, “Angwenhele-ame ngkwenge ileke unte-arle tyerrtye akethe yenpe-ante aneme? Unte-ame merne annge arne yanhe-ngentyele ineke renhe arlkweke? Unte-ame itelareme Tharle ngenhe ileke arne yanhe impetyeke, merne annge arne yanhe-ngentyele arlkwetyale?” ");
INSERT INTO aer_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Kenhe artwe angkirtnerlenge, “Ngkarte-aye, arelhe nhenge unte-arle ayenge irlkwatherre atyenge antheke, re-thewe ayenge merne annge arne yanhe-ngentyele antheke arlkwetyeke, kele the arlkweke.” ");
INSERT INTO aer_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Kenhe Ngkartele anteme arelhe apayuthneke, “Iwenhe-ame unte mpwareke?” Arelhe angkirtnerlenge, “Apmwe rarle atyenge urrtyirremele ilekenge. Alakenhe ikwerenge the merne annge arlkweke anteme.” ");
INSERT INTO aer_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kele imerte Ngkartele apmwe ileke, “Unte marle yanheke akurne mpwarekenge, The ngenhe-ante artimperre-iweme, kenhe kere arrpenhe areye artimperre-iwetyakenhe. Kele arlte nhenhe-ngentyele-arle unte kele atnertele artnerre-akemele, ulpmernte arlkwerle-apetyeke. Kele alakenhe rarle ngkwenge anetyenhe akwetethenhe-akwetethe. ");
INSERT INTO aer_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Kele arelhe yanhe uthene ampe ikwerenhe areye-arlke, itnekenge ingkirreke-arlke akwetethe-arle ngkwenge ahele uthnerrerlte-anetyenhe ilengareke-atwetye apeke. Kele lyete-ngentyele tyerrtye ingkirreke-arle apmwe areye-arlke akwetethe ahele uthnerrerle-anetyenhe. Tyerrtye areye akaperte ngenhe ulthetyenhe, kenhe unte akenhe renhe alkngerurrke-arle uthnetyenhe.” Alakenhe-arle Ngkartele apmwe renhe artimperre-iweke. ");
INSERT INTO aer_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Kele imerte arelhe renhe re ileke, “Kenhe arlte nhenhenge-ntyele The ngenhe rlkerte akngerre anthetyenhe unte ampe akweke atnyenetyenhenge. Unte anewe ngkwinheke alhirretyenhe, kenhe arrangkwe-arle, kenhe re akenhe ngkwenge akngerrepate anetyenhe.” Alakenhe-arle Ngkartele arelheke nhenge angkeke. ");
INSERT INTO aer_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","18","Kele imerte artwe renhe anteme Ngkartele ilemele, “The ngenhe ileke merne arne yanhe-ngentyele arlkwetyale anetyeke, arne nhenge kartene mpwepele tnerlenge. Kenhe unte akenhe Atyenge akangkwe-irretyakenhe anewangkweke-tetye akangkwe-irremele, merne annge yanhe arlkwemele. Alakenhe ikwerenge The ahelhe ingkirreke renhe artimperre-iweme, renhe akurne-ilemele ngkwenge-ketye. Ahelhe arrpe-anenhele arne akurne areye lyapeme, arne lyeke-akerte areye-arlke lyapemele. Kele lyete-ngentyele unte ilwetyeke-atwetye unte arnterre anthurre urrkapetyenhe merne lyapelhe-ilemele arlkwetyeke. Unte merne kartene nhengenge awethe arlkwetyeke anetyakenhe, merne arrpenhe pwetye-arenye ware-ante-arle unte arlkwetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Lyete-ngentyele unte arnterre anthurre urrkapemele antyeye akngerrele anteme merne ngkwinhe lyapelhe-iletyeke ware. Kenhe unte apeke arnterre urrkapetyakenhe kele imerte unte angayakwe re anteme, atnerte ulthetyakenhe anteme anerle-anetyenhe. Unte warrke akwete mpwarerle-anemele ilwetyeke-atwetye, unte kele-arle ilweke iperre ahelhe anteme irretyenhe. The ngenhe ahelhe-ngentyele mpwareke unte ahelhe irrirtnetyenhe.” Kenhe alakenhe rarle Ngkarte artwe yanhe ikwere angkeke. ");
INSERT INTO aer_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Yanhe ikwerenge-ntyele artwele arelhe anewikwe renhe “Eve” arritnye antheke, Eve ileme “itethe” re, tyerrtye ingkirreke anthurre ikwerenge-ntyele aneme lyete. ");
INSERT INTO aer_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Kenhe Ngkartele Adam ikwere uthene, anewikwe utheneke mantere kere yenpe-ngentyele mpwareke, ratherre artelhetyeke. ");
INSERT INTO aer_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nhenhe ikwerenge-ntyele Ngkarte angkeke, “Araye, ratherre merne arne yanhe-ngentyele arlkwerle-anerreke-arle iperre anwerne-arteke anteme-irreke, kele ratherre re itelareme iwenhe apeke mwerre-akerte, iwenhe apeke akurne-akerte. Alakenhe ikweretye anwerne renhe-atherrenhe kartene nhenhe-ketye arratelhe-ilemele yernetyeke. Ratherre apeke merne arne yanhenge-arlke arlkweme, arne nhenge itethe anthemenge-arle, ratherre itethe akwete-ante anemere ilwetyakenhe-arle. Alakenhe irreketyenge, anwerne renhe-atherrenhe apmere nhenhenge arratelhe-ilemele aywepeme.” ");
INSERT INTO aer_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kele imerte Ngkartele renhe-atherrenhe apmere Eden kartene ikwerenge arratelhe-ilemele aywepeke, ratherre apmere arrpenhele ahelhe atyerte-ilemele merne-arlke lyapelhe-iletyeke, artwe-arle ahelhe ikwerenge mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Renhe-atherrenhe aywepekarle-iperre, Ngkartele apmere Eden kartene ikwerenge ikngerre-ampinyeke arlpelhe-akerte alkere-arenye ikwerenhe areye ngkerneke, itne arne arrirlpe ure-akerte atnyenerlenge, kartene renhe akayake-iletyeke, tyerrtye areye apetyewarreketyenge arne yanhe-ngentyele inerrirreketye arne nhenge itethe-arle antheme. ");
INSERT INTO aer_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Yanhe ikwerenge-ntyele, Eve Adam-nge inteke re anteme ampe-akerte irremele. Urreke re ampe urreye akweke atnyeneke, Cain arritnye atniwemele. Kenhe Eve angkeke, “Atyinhe ampe akweke urreye inteke Ngkarte Akngerre-arle atyengenge anekenge.” ");
INSERT INTO aer_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Kele imerte, re awethe ampe-akerte-irremele. Kele ampe urreye arrpenhe atnyeneke Abel arritnye anteme re atniwemele, re atyikwe Cain-kenhe. Abel amangkemele akngerre-irremele, yepe-yepe arntarnte-aretyarte. Kenhe Cain amangkemele akngerre-irremele, re kartene mpwareke merne atherrke lyapelhe-iletyarte arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Kele arlte arrpenhele anteme Cain-ele merne kartene ikwerenhe-ngentyele akngetyeke Ngkarte renhe anthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Kenhe Abel re akenhe kere akngetyeke Ngkarte renhe anthetyeke, re yepe-yepe akweke mwerre akngerre akngetyemele, rarle atweke-arle itemele. Re tyelke itemele, antere mwerre-arlke Ngkarte anthetyeke. Kenhe Ngkarte Abel-kenheke ante-arle akangkeke. ");
INSERT INTO aer_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Kenhe Ngkarte Cain-eke akangketyakenhe, merne ikwerenhe ikwele-aremele. Kele imerte Cain ahele anthurre irreke, inngerre arrpenhe anthurre irremele, alhwarrpe anthurre irremele. ");
INSERT INTO aer_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Kenhe Ngkartele Cain apayuthneke, “Unte-ame iwenhenge ahele-irreke? Iwenhenge-ame unte ahele-irremele inngerre arrpenhe anthurre irrerle-alheke? ");
INSERT INTO aer_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Unte apeke arratye mpwarerlenge, Ayenge ngkwenge akangketyenhe. Kenhe unte apeke arratye mwerre mpwaretyakenhe, kele imerte arelhaye akurne-irreketyenge! Unte ilelhetyeke arne akurne areye mpwaretyale, arne akurne nhenge areye unte mpwaretyeke ahentye-anemele. Kenhe unte apeke akurne akwete mpwarerle-anemele kele akurne ngkwenge irretyenhenge.” Alakenhe rarle Ngkarte Cain-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Kenhe Cain atyeye ikwerenhe Abel-eke angkeke, “Mpe, ilerne apmere arne artne-werne alherretyekaye!” Kele imerte ratherre arnperle-alherremele. Apmere akethele anerle-anerremele, Cain re atyeyikwe-werne ularre-irreke, renhe irrerlknge atwemele. ");
INSERT INTO aer_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Kele urreke, Ngkarte apetyemele Cain apayuthneke, “Nthenhe-ame atyeye ngkwinhe Abel?” Re apele angkirtnerlenge, “Yekwe! The atyeye atyinhe arntarnte-aretyakenhe. Yanhe-arle warrke atyinhe anetyakenhe. Tharle itelaretyakenhe re nthenhele-arle.” ");
INSERT INTO aer_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Kenhe Ngkarte Cain-eke angkeke, “Iwenhenge-ame unte atyeye ngkwinheke akurne anthurre mpwareke? The alhwe atyeyangkwe-kenhe ahelheke-arleke areme. Alhwe ikwerenhe ahentye-arteke ahelhenge arlkerlenge Atyenge-werne. Alhwe yanhele Atyenge ilemele unte-arle atyeyangkwe irrerlknge atwekenge. ");
INSERT INTO aer_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Kele lyete-ngentyele, The ngenhe artimperre-iweme. Unte atyeyangkwe irrerlknge atwerlenge, alhwe ikwerenhe ahelhele inteme. Alakenhe ikwerenge unte ahelhe atyete-ilemele tnyemele arne ngkernetyeke, itne uyarne lyapeme Tharle ahelhe akurnelhe-ileme ngkwenge-ketye. ");
INSERT INTO aer_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Unte merne-akerte areye ngkwenge-arrpe lyapelhe-iletyeke arrangkwe anteme. Unte merne annge areye ahelheke ngkernetyenhe, kenhe itne akenhe merne-akerte irretyakenhe, arrangkwe. Unte atyengetye alhetyenhe, apmere arrpe-anenhe-werne anange-irreme, apmere ngkwinhe-kwenye anteme, ahelhe nhenhele-arle talkwe ware unthepe-arle-unthetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Kenhe Cain imerte Ngkarteke angkeke, “Nhenhe apele lterrke anthurre mpwaretyeke! Unte apeke piweme ayenge uyarne aneme. Atyenge-ame nthakenhe-irretyenhe? ");
INSERT INTO aer_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Lyete unte ayenge ngkwengetye, apmere atyinhenge-arlke yerneme, Ngkwengele-arlenge anetyeke arrangkwe. The ahelhe uyarne atyete-ileme arne ngkernetyeke. Ayenge apmere-kwenye, ahelhele talkwe ware anteme untherle-anetyenhe ipenye-arteke. Kenhe angwenhele apeke ayenge aremele, re ayenge kele irrerlknge-ante ware atwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Kenhe Ngkartele renhe ileke, “Arrangkweyaye! Artwe angwenhele apeke ngenhe irrerlknge atwemele, The ngkwenge artwe renhe-arlke, ikwere-artweye arrpenhe six-pele areye-arlke irrerlknge atwetyenhe.” Kenhe Ngkartele akenhe Cain-eke-arleke imperre uthneke, artwe arrpenhele renhe aremele irrerlknge atweketye. ");
INSERT INTO aer_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ikwerenge-ntyele Cain re akenhe Ngkarte-ngentyele imperle-alhemele apmere Eden-enge ikngerre-werne-atheke alheke apmere Nod ikwerele aneke. ");
INSERT INTO aer_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Cain anewikwenge inteke-arle iperre ratherre ampe urreye akweke atnyenemele Enoch arritnye. Cain-ele warle atningke arteke apmere akngerrele, apmere yanhe renhe “Enoch” atniweke, alerikwe arritnye-arteke. ");
INSERT INTO aer_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Kenhe Enoch amangkemele akngerre-irremele, anewe akemele, ratherre ampe urreye atnyeneke Irad arritnye antheke. Kenhe Irad amangkemele akngerre-irremele, anewe akemele, ratherre ampe urreye atnyeneke Mehujael arritnye antheke. Kenhe Mehujael amangkemele akngerre-irremele, anewe akemele, ratherre ampe urreye atnyeneke Methushael arritnye antheke. Kenhe Methushael amangkemele akngerre-irremele, anewe akemele, ratherre ampe urreye atnyeneke Lamech arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Kenhe Lamech amangkemele akngerre-irremele, anewe atherre akemele. Anewe arrekwelenye Adah arritnye aneke. Anewe arrpenhe ikwerenhe Zillah arritnye aneke. ");
INSERT INTO aer_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Anewe arrekwelenye Lamech-kenhele ampe urreye akweke atnyeneke Jabal arritnye antheke. Re amangkemele akngerre-irremele, rarle tyerrtye arrekwelenye ilthe akngerrele aneke-arle, pweleke atningke-arlke atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Kenhe Adah re akenhe ampe urreye arrpenhe atnyeneke, atyeye Jabal-eke. Jubal arritnye ikwerenhe aneke. Re amangkemele akngerre-irremele, rarle tyerrtye arrekwelenyele lyre-le flute ngkelhe-ngkelhe-iletyarte. Kenhe anewe Lamech-kenhe arrpenhe Zillah-ele ampe urreye atnyeneke Tubal-Cain arritnye antheke. Tubal-Cain amangkemele akngerre-irremele, re tool areye iron-ngentyele-arlke bronze-ngentyele-arlke mpwaretyarte. Kenhe Zillah-ele akenhe ampe marle atnyeneke, ");
INSERT INTO aer_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Naamah arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Arlte anyente Lamech-ele anewe ikwerenhe atherreke angkeke, “Adah uthene Zillah uthene ayenge mwantye awerle-anerraye, anewe atherre atyinhe ayenge lyete nhenhe awerle-anerraye! Artwe apmerrkele ayenge atweke ayenge akurne mpwaremele, tharle renhe irrerlknge atweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Kele artwele apeke ayenge irrerlknge atwemere tharle artwe apmerrke nhenge atwekenge, kenhe Ngkartele akenhe atyenge artwe renhe atwetyenhe, ikwere-artweye arrpenhe 76-pele areye-arlke atwetyenhele. Mpwele itelareme, Ngkarte-arle angkekenge, artwe angwenhele-arle apeke Cain irrerlknge atwemele, re Cain-eke artwe renhe-arlke, ikwere-artweye arrpenhe 6-pele areye-arlke, irrerlknge atwetyenhe. Ayenge akwele Cain-enge akngerre awethe-ulkere.” ");
INSERT INTO aer_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Adam uthene Eve uthenele ampe arrpenhe awethe atnyeneke. Ratherre ampe urreye anyente atnyeneke Seth arritnye antheke. Kenhe Eve akenhe angkeke, “Ngkartele ayenge ampe urreye arrpenhe antheke, tharle ampe arrpenhe atyenge Abel aparlpe-ilekenge, artwe nhenge Cain-ele irrerlknge atwekarlenge.” ");
INSERT INTO aer_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Kenhe Seth akenhe amangkemele akngerre-irremele, anewe akemele, ratherre ampe urreye atnyeneke Enosh arritnye antheke. Nhenhe ikwerele-ureke tyerrtye areye Ngkarteke angketyeke-irreke. ");
INSERT INTO aer_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Ayeye nhenhe Adam-akerte, arritnye areye ampe ikwerenhe-akerte, ikwere-artweye arrpenhe ingkirreke-arlke-akerte. Lyetenyenge Ngkartele-arle nhenge tyerrtye areye mpwareke Re-arteke anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Re urreye uthene marle uthene aknganeke, Re imerte ikwere-atherre arne mwerre areye mpwaremele, renhe-atherrenhe “tyerrtye areye” arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Kenhe Adam re arrule akngerrele anekenge, year 130-pelenge re alere akweke atnyeneke Seth arritnye antheke. Seth amangkeke akngerre-irremele, anyikwe Adam-arteke re aneke. ");
INSERT INTO aer_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Adam re year 800-pele awethe aneke. Kenhe Seth inteke-arle-iperre, Adam-ele ampe akweke arrpenhe atningke renhe anteme atnyeneke, marle uthene urreye uthene areye. ");
INSERT INTO aer_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Re ampwe-irremele itethe akwete anerle-aneke, year 930-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Kenhe Seth re akenhe itethe akwete anthurre anerle-aneke, year 105-pelenge re alere akweke atnyeneke Enosh arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Kenhe Seth re akenhe itethe akwete anthurre anerle-aneke year 807-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kenhe re ampwe-irremele itethe akwete anerle-aneke, year 912-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Kenhe Enosh re akenhe itethe akwete anthurre anerle-aneke, year 90-pelenge re alere akweke atnyeneke Kenan arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Kenhe Enosh re akenhe itethe akwete anthurre anerle-aneke year 815-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kenhe Enosh ampwe-irremele itethe akwete anerle-aneke, year 905-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Kenhe Kenan re akenhe itethe akwete anthurre anerle-aneke, year 70-pelenge re alere akweke atnyeneke Mahalalel arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Kenhe Kenan re akenhe itethe akwete anthurre anerle-aneke year 840-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kenhe Kenan ampwe-irremele itethe akwete anerle-aneke, year 910-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Kenhe Mahalalel re akenhe itethe akwete anthurre anerle-aneke, year 65-pelenge re alere akweke atnyeneke Jared arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Kenhe Mahalalel re akenhe itethe akwete anthurre anerle-aneke year 830-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kenhe Mahalalel ampwe-irremele itethe akwete anerle-aneke, year 895-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Kenhe Jared re akenhe itethe akwete anthurre anerle-aneke, year 162-pelenge re alere akweke atnyeneke Enoch arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Kenhe Jared re akenhe itethe akwete anthurre anerle-aneke year 800-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kenhe Jared ampwe-irremele itethe akwete anerle-aneke, year 962-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Kenhe Enoch re akenhe itethe akwete anthurre anerle-aneke, year 65-pelenge re alere akweke atnyeneke Methuselah arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","24","Kele Enoch itethe akwete anerle-aneke, year 300-pele awetheke-atwetye, Methuselah inteke-arle iperrenge. Enoch atyewe mwerre Ngkarteke akwetethe ikwerenge anerle-aneke. Enoch itethe akwete aneke year 365-peleke-atwetye, kele arlte anyentele Ngkartele apele renhe iparrpe alkere akertne-werne-atheke akngeke. Re ilwetyakenhe, kenhe tyerrtye areyele akenhe renhe uyarne arerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Kenhe Methuselah re akenhe itethe akwete anthurre anerle-aneke, year 187-pelenge re alere akweke atnyeneke Lamech arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Kenhe Methuselah re akenhe itethe akwete anthurre anerle-aneke year 782-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Kenhe Methuselah ampwe-irremele itethe akwete anerle-aneke, year 969-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Kenhe Lamech re akenhe itethe akwete anthurre anerle-aneke, year 182-pelenge re alere akweke atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Lamech alere ikwerenhe Noah arritnye atniweke. Re angkemele, “Ngkartele ahelhe nhenhe akurnelhe-ilekenge anwerne-arle arnterre anthurre urrkapewarreme merne arlkwerrirretyeke anwernenhe apurrkele-antherlenge. Kenhe Noah re akenhe anwernenhe mwantye-mwantye-iletyenhe anwerne-arle arnterre urrkapewarremenge.” ");
INSERT INTO aer_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Kenhe Lamech re akenhe itethe akwete anthurre anerle-aneke year 595-pele awethe, re akwete ampe akweke atningke anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Kenhe Lamech ampwe-irremele itethe akwete anerle-aneke, year 777-peleke-atwetye re ilweke anteme. ");
INSERT INTO aer_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Kenhe artwe Noah rarle year 500-pele anekenge-ntyele, re alere urrpetye atnyeneke Shem, Ham, Japheth arritnye itnekenhe antheke. ");
INSERT INTO aer_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Kenhe tyerrtye areye atningke-ame-atningke-irreke apmere arrpe-anenhe-werne anteke-irremele. Ampe itnekenhe areyele-arlke ampe arrpenhe atningke atnyenewarreke, itne-arlke atningke-ame-atningke-irreke. Kenhe arrpenhemele marle mwerre akngerre atnyenewarreke. ");
INSERT INTO aer_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Kenhe artwe arrpenheme ingkirrekele akeme “Alkere akertnenye-arenye areye.” Alkere-arenye areyele marle mwerre akngerre yanhe areye arerrirremele itneke alhirreke, itne imerte marle areye akngakemele nhenge areyeke itne-arle ahentye-anemele itnenhe anewe akemele. ");
INSERT INTO aer_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Kenhe Ngkarte re akenhe aremele ingkirreke-arle irremenge Re angkeke, “Kwerrene renhe Tharle itnenhe antheke itneke-arleke akwete-ante anetyakenhe, iwenhenge-arle itne mpwarewarrerlenge. Kenhe itne akenhe tyerrtye ware. Kenhe lyete nhenhenge-ntyele tyerrtye areye year 120-peleke-atwetye ware itethe anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Nhenhe ikwerele-ureke tyerrtye akngerre-apenhe, artwe areyele “Akertnenye-arenye areye” akeke, marle mwerre akngerre areyenge intemele, itne ampe areye atnyenemele Nephilim arritnye aneke. Ampe nhenhe areye amangkemele akngerre-irreke, lterrke atwentye akngerre areye aneke. Ayeye ahinpenyenge artwe nhenhe areye lterrke atwentye akngerre areye anerrirretyarte. ");
INSERT INTO aer_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Nhenge Ngkartele itnenhene aremele arratye alhwarrpe anthurre irreke itne-arle akwetethe itirrewarrerlenge akurne mpwarewarretyeke anteme itne mwerre mpwaretyeke itirrewarretyakenhe anthurre. Ngkartele aretyeke tyerrtye areye-arle akurne anthurre anerrirremenge. ");
INSERT INTO aer_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Ngkarte alhwarrpe-irreke itirremele, “Iwenheke-ame the tyerrtye nhenhe areye mpwareke apmere ahelhe nhenheke arrernemele anetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Re imerte angkemele, “Ayenge arratye alhwarrpe anthurre anteme-arle Tharle itnenhene ingkirreke aknganeke-iperrenge. The tyerrtye ingkirreke atwetyenhe tharle mpwareke. The kere ingkirreke atwetyenhe apmere ahelhe nhenhele-arle anerrirremeke, kere ingkirreke, arrentye akweke areye, thipe ingkirreke alkere-arle unthentye akngerre areye-arlke. The nhenhe mpwaretyenhe tyerrtye yanhe areyele-arle ayenge alhwarrpele-antherlenge anthurre. Itne akurne akwete mpwarerlte-anemele.” ");
INSERT INTO aer_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Kenhe artwe anyente akenhe Ngkartele mwantyele areke rarle mwerre-arle aneke. Artwe nhenhe re akenhe Noah arritnye aneke. Re arne akurne mpwaretyakenhe. Ngkarte ikwere akangkentye aneke. Kenhe Noah re akenhe atyewe mwerre Ngkarteke aneke. ");
INSERT INTO aer_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","13","Ayeye nhenhe Noah-akerte. Noah alere urrpetye atnyeneke, Shem, Ham, Japheth uthene. Tyerrtye ingkirreke apmere arrpe-anenhele akurne akwete mpwarerlte-anemele. Itne atwerreke, akurne itneke-arrpe mpwarewarretyarte, mwantye ulkere-irrerirretyakenhe. Kenhe Ngkartele itnenhe kwene aremele areke arne akurne anthurre itne-arle mpwarewarremenge. Itne akwetethe akurne anthurre mpwarerlte-anetyame. Ngkarte Noah-eke angkeke, “Araye, tyerrtye ingkirrekele arne akurne akwete mpwarerlte-aneme. Tharle tyerrtye ingkirrenyeke anthurre apmere ahelhe nhenhele uyerrelhe-iletyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ngkarte Noah-eke angkeke, “Ayenge ngkwenge ahentye-aneme arne boat akngerre-apenhe anthurre mpwaretyeke. Renhe mpwaretyeke arne lterrke mwerre-ngentyele, gopher arritnye akeke. Iperte akweke areye kwene ampinyeke, akethe-ampinyeke martemele anteye, arne ankerele-arteke artemele martemele kwatye irrpeketye. Arne boat akngerre-apenhe kwene ikwerele unte apmere akweke areye mpwaretyeke atningke kwenele anerre-arlke-irretyenhe tnerre-arlke-irretyenhe. ");
INSERT INTO aer_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Renhe arteme akngerre anetyeke anteke anthurre, nhenhe-arteke: 150 metres arlpentye, 25 metres anteke, 13 metres akertne-atheke. ");
INSERT INTO aer_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Boat akertneke anteme unte warle artepe akngerre anthurre artaye kwatye irrpeketye. Kele boat ake mpepe mpwaraye 45 centimeters akertnele aneme warle artepe arrpenhenge anetyeke. Kele boat kweneke unte apmere akweke areye artetyeke akertne-antepe kwene-antepe anetyeke arrpenhe kweneke, arrpenhe mpepeke, arrpenhe akertneke. Kele altywere anteke akngerre anyente artetyeke, ingkirrekele irrpintyewarretyeke.” ");
INSERT INTO aer_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ngkarte awethe angkeke, “Kenhe Tharle kwatye urewe akngerre anthurre ahelhe nhenhe-werne yernetyenhenge. Kwatye urewe nhenhele anteke-irretyenhe apmere ahelhe arrpe-anenhe anthurre artemele. Itethe areye ingkirreke anthurre uyerrelhe-iletyeke, ahelheke anentye akngerre areye, alkereke anentye akngerre areye-arlke, ingkirrenyeke akethe ante arrernetyenhe. Kwatye urewele itnenhene ingkirrenyeke atwetyenhe kele itne ingkirrenyeke ilwerrirretyenhe anteme. ");
INSERT INTO aer_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Kele antime, Noah itirretyalaye! The apele ngenhe arntarnte-aretyeke alhilemele. Atere-irretyale. Unte-arlke, anewe ngkwinhe-arlke, alere ngkwinhe areye-arlke, anewe itnekenhe areye-arlke, arrantherre ingkirrenyeke boat ikwere antyetyeke itethe akwete anetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Ngkartele Noah ileke, “Unte anteye kere ingkirreke arrpe-anenhe akngetyeke, urreye anyente marle anyente ikngale boat kwene ikwere akwernetyeke, itne-ante itethe anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Kele thipe arrpenheke-arrpenhe itnekenge atherre ngkwenge-arlenge akngetyetyenhe, kere arrpenheke-arrpenhe itnekenge atherre antime, alhengkweltye artnerrentye arrpenheke-arrpenhe itnekenge atherre anteme, marle uthene urreye uthene alakenhe. Itne ingkirreke ngkwenge-werne apetyewarremele unte itnenhene itethe atnyenetyeke. ");
INSERT INTO aer_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Unte merne arrpenheke-arrpenhe itnekenhe arrekantherrenhe-arrpe-arlke ingkirrekeke apurtelhe-iletyeke boat ikwerele atnyenemele, kwatye urewele-arle ahelhe arrpe-anenhe arterlenge, arrantherre ingkirrekele boat kwenele merne arlkwetyeke atnyenetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Kenhe Noah re akenhe ingkirreke anthurre mpwareke, Ngkartele-arle renhe ileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Kenhe arne nhenge boat akngerre-apenhe mpwareke-arle-iperre Ngkartele Noah renhe ileke, “Kele boat ikwere antyemele alhaye, unte ngkwenge-artweye areye-akerte. Ngenhe anyente-ante-arle The areke arratye anerle-anerlenge, kenhe arrpenhe ingkirrekele akurne anthurre-arle mpwarerlte-aneme. ");
INSERT INTO aer_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Kenhe kere arrpenhe ingkirreke-ngentyele inetyeke alhaye, kere arlkwenhe-arlkwenhe areye-ngentyele. Marle seven-pele uthene urreye seven-pele uthene inetyeke alhaye boat ikwere itnenhene akwernemele, seven-eke-seven. Kele imerte kere arrpenhe areye-ngentyele inetyeke alhaye, kere arlkwenhe-arlkwenhe-kwenye areye-ngentyele. Marle anyente-ante ware, urreye anyente-ante ware yanhe areye-ngentyele inetyeke alhaye kele boat ikwere itnenhene akwernemele, atherreke-atherre. ");
INSERT INTO aer_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Kele rante-rante mpwaraye thipe areyeke. Kenhe thipe areye-arlke arrpenheke-arrpenhe areye-ngentyele inetyeke alhaye urreye seven-pele marle seven-pele anteme boat kwene ikwere akwernemele. Alakenhe rarle The arrpenheme itethe atnyenetyeke. Kwatye urewe akngerre iperrele nhenhe areyele, kere nhenhe areye-arlke, thipe nhenhe areye-arlke atningke-ame-atningke-irretyenhenge apmere ahelhe nhenhele. ");
INSERT INTO aer_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kele arlte seven-pele uyerrenherlenge, The kwatye akngerre yernetyenhe. Arlte 40-peleke ingwe 40-peleke akwete anthurre re kwatye urnterle-anetyeke. Alakenhe rarle The ingkirrenyeke anthurre akethe-iletyenhe Tharle mpwareke areye apmere ahelhe nhenheke, kwatye urewele.” ");
INSERT INTO aer_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Kele imerte Noah re akenhe ingkirreke aweke-arle-iperre re mpwaremele Ngkartele-arle renhe ileke. ");
INSERT INTO aer_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","16","Nhenhe ikwerele-ureke kwatye urewe akngerre-arle apmere ahelhe nhenhe-werne apetyetyenhenge, artwe Noah re ampwe anthurre irreke, re year 600-pele aneke. Kele Noah re-arlke, anewe ikwerenhe-arlke, alere urrpetye-arlke itnekenhe anewe areye-arlke, ingkirrenyeke boat kwene ikwere-werne irrperrirreke kwatye urewe akngerre-ketyenge. Kere arrpe-anenhe areye-arlke, arrentye areye-arlke, thipe arrpe-anenhe areye-arlke marle uthene urreye uthene atherreke-atherre, itne ingkirreke Noah ikwerenge apurte-irrerirreke boat ikwere intyeke, Ngkartele-arle ilekenge. Kele ingkirreke boat kweneke irrpenheke-arle iperre Ngkartele boat arriwe martemele. Kele arlte seven-pele uyerrenhekenge, kenhe kwatye akngerre urntetyeke tharte-irreke. Kenhe kwatye urewe akngerrele re akenhe apmere ahelhe nhenhe arterlenge, Ngkartele-arle renhe ileke-arteke. Kenhe Noah year 600-nge aneke boat-eke irrpemele kwatye urewe akngerre-ketyenge. Kenhe atnyentye anyente uyerrenheke arrpenhe akngerre-irrerlenge, arlte 17-pelenge iperre kwatye akngerre anthurre ahelhe nhenheke-arleke urnteke. Kwatye akngerre ahelhe-ngentyele-arlke arrateke apmere arrpe-anenhele anteke-irremele kele apmere ahelhe nhenhe renhe arteke. Kele kwatye re akwete urntepe-urntemele, arlte 40-pele, ingwe 40-peleke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","20","Kenhe kwatye akwete urnterle-anemele akertne-ame-akertne-irremele arlte 40-peleke-atwetye, ingkirreke anthurre arteke, apmere ahelhe nhenhe-arlke, apwerte antherrtye areye-arlke artemele. Kwatye akertne-ame-akertne-irrerlenge boat akenhe akertne-irreke kwatye artepe inteme. Kwatye urewele apwerte akngerre ingkirreke arteke, kwatye re apele apwerte akertnenye akertnele aneme, metre 7-pele apwerte akertnenyenge. ");
INSERT INTO aer_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","23","Arratye apelaye itethe ingkirreke anthurre aheye angkenhe-angkenhe areye apmere ahelhe nhenhele anerrirreme-arle, kere ingkirreke-arlke, arrentye ingkirreke-arlke, thipe ingkirreke-arlke, iwenhe-iwenhe ingkirreke anthurre alhekwarle-irrerirreke. Tyerrtye ingkirreke anthurre-arlke apmere ahelhe nhenhele anerrirreke ilwerrirremele, Ngkartele-arle ilekenge-arteke. Re ingkirreke anthurre kwatye urewe akngerrele atweke. Kenhe Noah-ante arrpenhe areye-arlke ikwerenge aneke, itne-ante ware itethe akwete aneke, Ngkartele-arle itnenhe kwatye urewe-ketye itetheke mpwareke. ");
INSERT INTO aer_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Kenhe kwatye urewe akngerre nhenge ahelhe nhenhele arrule ulkere-arle interle-aneke ingkirreke artemele arlte 150-peleke-atwetye, nhenge atnyentye 5-peleke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Ngkarte Noah ikwere alkngwirretyakenhe, ikwere-artweye areyeke-arlke kere arrpenhe ingkirrekeke-arlke ikwerele-arlenge boat akngerrele anerlte-anerlenge, itneke akwete itirremele. Kele Re rlke akngerre anthurre anteme yerneke, apmere arrpe-anenhele wernetyeke. Kenhe kwatye re akenhe akweke-arle-irrirtnerlenge. ");
INSERT INTO aer_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Ngkartele marteke kwatye ahelhe-ngentyele-arle aterle-anetyame, Re kwatye akertne-ngentyele ingkirrenyeke marteke awethe urntetyeke arrangkwe anteme-arle. ");
INSERT INTO aer_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Kenhe kwatye urewe akngerre-arle ahelhe arrpe-anenhele intetyame, re imerte mwantye akweke-ame-akweke-irreke. Arlte 150-pele iperre kwatye urewe re kele akweke anteme-irreke. ");
INSERT INTO aer_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Atnyentye seven-pele uyerrenheke, arlte 17-enge, boat akngerre re kele apwerte akngerre akertnenyeke arrernelheke, apwerte antherrtye nhenge Ararat arritnyeke-arleke. ");
INSERT INTO aer_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Kwatye re akwete akweke-ame-akweke-irrirtneke atnyentye arrpenhe urrpetyeke-atwetye. Kele imerte, apwerte akertnenye areyele arratintyemele. ");
INSERT INTO aer_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","7","Arlte arrpenhe 40-pelenge akarelheke-arle-iperre, Noah-ele boat akngerre kwene-ngentyele window renhe altywere-ilemele, thipe angepe renhe anteme yerneke ahelhe ararrtye-irrerlenge aretyeke. Kenhe angepe re alheke alkereke-irrerle-anemele kwatye-arle uyerretyenheke akarelhemele. ");
INSERT INTO aer_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Kenhe Noah re akenhe thipe arrpenhe nturrerte-arteke renhe yerneke, aretyeke ithwenge apeke kwatye ingkirreke kele uyerrekeke apeke, arrangkwe apeke. ");
INSERT INTO aer_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Kenhe nturrerte re apele uyarne untheke arrernelhetyeke, kwatye-arle ahelhe arrpe-anenhele interlenge akwete. Thipe nturrerte-arteke imerte Noah ikwere-werne apetyalpeke. Noah-ele iltye akertne-ilemele nturrerte arrernelhetyeke, awethe boat akngerre kwene-werne irrpirtneke. ");
INSERT INTO aer_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Re arlte 7-pele arrpenheke akarelheke-arle-iperre, re awethe thipe nturrerte-arteke yanhe renhe yerneke, ahelhe ararrtye-irrerlenge aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Kenhe nturrerte alkereke-irremele alheke angwerre-angwerrele ikwere-werne apetyalpemele, olive irlpelhe atherrke akngetye-alpeke rarle inerne. Kenhe Noah-ele irlpelhe atherrke yanhe areke-arle-iperre re itelaremele kwatye uyerrerlenge-arle, ahelhe ararrtye arraterlenge. ");
INSERT INTO aer_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Re arlte 7-pele awetheke akarelhekenge-ntyele re thipe nturrerte-arteke renhe awethe yerneke. Nturrerte-arteke re apele apetyalpetyakenhe anteme-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Kenhe Noah re year 601-pele anekenge-ntyele atnyentye akwerrke irrerlenge kwatye urewe ingkirreke-arle kele ahelhe nhenhele intemele uyerrekenge. Kele imerte re arne boat artepe renhe irlwemele re imerte akertnenge akwete aremele ahelhe lyete-ante re ararrtye-irrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Kele atnyentye arrekwelenye uyerrenhekenge, Noah akarelheme atnyentye arrpenhe uyerrenhetyeke, kenhe ahelhe nhenhe ingkirreke akenhe ararrtye anteme. ");
INSERT INTO aer_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","16","Kenhe Ngkarte Noah ikwere-werne-atheke angkeke, “Kele boat akngerre-ngentyele atnarnpaye, unte anewe ngkwinhe-arlke, alere ngkwinhe areye-arlke, anewe itnekenhe areye-arlke. ");
INSERT INTO aer_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Kere-arlke, arrpenhe itethe ingkirreke-arlke boat-enge arratelhe-ilaye, thipe areye-arlke, arrentye akweke areye-arlke. Kele itne boat akngerrenge-ntyele atnarnpewarreke-arle iperre itne ingkirreke awethe atningke-ame-atningke-irretyeke, akweke areye atnyenetyeke apmere ahelhe arrpe-anenhele anerrirretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kele Noah-ele renhe aweke-arle-iperre re boat akngerrenge atnarnpeke, anewe ikwerenhe-akerte, alere ikwerenhe areye-akerte itnekenhe anewe areye-akerte anteye. ");
INSERT INTO aer_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Itethe arrpenhe ingkirreke boat akngerrenge atnarnpeke, kere ahe akngerre areye-arlke, arrpenheme atnure areye-arlke, thipe ingkirreke-arlke, arrentye akweke nhenge areye-arlke, marle uthene urreye uthene, itne aharlele atnarnpemele. ");
INSERT INTO aer_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Noah-ele boat akngerrenge-ntyele atnarnpekenge re apwerte ilperre-ilperre akngerre ineke, renhe akertneke-arleke kere ampetyeke Ngkarteke, altar arritnye. Re kere arrpe-anenhenge anyente ineke, thipe arrpe-anenhenge anyente ineke, nhenhe areyenge Ngkarteke mwerre-arle anthetyeke. Noah-ele itnenhe atweke apwerte ilperre-ilperreke-arleke arrernemele, urele itemele, itnenhe itemele Ngkarteke anthetyeke. Alakenhe renhe Noah Ngkarteke akangkeme. ");
INSERT INTO aer_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Kenhe Ngkartele ntyernemele kere unpe mwerre renhe iterlenge, Re akangkeke. Re itirreke, “The apmere ahelhe akurne-ileke kwatye urewe akngerre yernemele tyerrtye ingkirreke-arle akenge anerlte-anemenge. Kenhe The akenhe awethe apmere ahelhe nhenhe akurne-iletyakenhe anteme anetyenhe, The ingkirreke aheye angkenhe-angkenhe areye-arle awethe atwetyakenhe anteme anetyenhe. Kenhe tyerrtye areyele-arle arrule akwekenge-ntyele ilwetyeke-atwetye akurne-ante renhe mpwarerlte-anemele. Kenhe The akenhe apmere ahelhe nhenhe akethe ante arrernetyakenhe anteme anetyenhe tyerrtye areye akurne-iletyeke. ");
INSERT INTO aer_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Apmere ahelhe nhenhe akwete anerlenge, arne ingkirreke akwetethe rante-rante anerlte-anetyenhe. Arlte uthene ingwe uthene akwetethe aneme, urinpe uthene alhwerrpe uthene akwetethe aneme, ahurratye uthene atherrkenye uthene akwetethe aneme. Kenhe tyerrtye areyele akwetethe arne annge areye ngkerneme, merne mpenge areye inemele.” Alakenhe renhe Ngkartele Noah-eke alhileke. ");
INSERT INTO aer_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Kenhe Ngkarte Noah-eke alere ikwerenhe areyeke-arlke mwerre aneke, itneke angkemele, “Ayenge arrekantherre ampe atningke atnyenetyeke ahentye-anemele, ikwere iperrenge ayenge ahentye-anemele ampe itnekenhe areyeke atningke-ame-atningke-irretyeke, arrantherre awethe akngerre-ilerretyeke apmere ahelhe arrpe-anenhele anteke-irrerirremele anerrirretyenhenge, arrekantherre-artweye-akerte. ");
INSERT INTO aer_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","The arrenhantherrenhe kere arrpe-anenheke akngerrepate arrerneme, thipe arrpe-anenheke, arrentye arrpe-anenheke, thipe alkereke irrenhe-irrenhe areye, kere kwatye-arenye ingkirrekeke-arlke. Itne arrekantherretye atere-irrerirretyenhe. ");
INSERT INTO aer_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Arrwekele The arrenhantherrenhe merne-ante ware arlkwerrirretyeke antheke, kenhe lyete-ngentyele the arrenhantherrenhe merne-arlke kere-arlke antheme arlkwerrirretyeke. Kenhe lyete-ngentyele akenhe arrantherre kere arrpe-anenhe atwerrirremele arlkwerrirretyeke. ");
INSERT INTO aer_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Awerrirraye! Arrantherre kere atwerrirremele, urreke renhe arlkwerrirretyenhenge, arrantherre itnekenhe alhwe altyiwemele ahelheke. Kere alhwe-akerte akwete arlkwerrirretyale, alhwele-arle itnenhe itethe akwete atnyenerlenge. ");
INSERT INTO aer_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Kenhe tyerrtye anyentele apeke arrpenhe irrerlknge atweme, kenhe The akenhe renhe atwerlenge. Alakenhe rarle, kere ahe akngerrele apeke tyerrtye uthnemele irrerlknge atweme, kenhe The akenhe kere renhe-arle atwerlenge. ");
INSERT INTO aer_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kenhe tyerrtye angwenhele apeke arrpenhe renhe ahe akngerrele irrerlknge atweme, kenhe tyerrtye arrpenhele renhe-arle irrerlknge atwerlenge. Kenhe The apele tyerrtye areye Ayenge-arrpe-arteke mpwareke. Alakenhe ikwerenge arrantherre atwerrirretyeke tyerrtye renhe-arle arrpenhe renhe atwerlenge. ");
INSERT INTO aer_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Ayenge ahentye-aneme arrantherre ampe atningke awethe atnyenetyeke tyerrtye atningke apmere ahelhe arrpe-anenhele anteke-irrerirretyeke anerrirretyenhenge.” Alakenhe renhe-arle Ngkarte Noah-eke angkeke arrpenhe itneke-arlke. ");
INSERT INTO aer_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Kele imerte Ngkarte Noah-eke alere ikwerenhe urrpetyeke-arlke awethe angkeke, ");
INSERT INTO aer_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Lyete the arrenhantherrenhe arratye alhilemele angkeme ngkwenge arrekantherre-artweye areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","The arrenhantherrenhe alhileme, kere arrpe-anenheke-arlke, thipe arrpe-anenheke-arlke, arrentye arrpe-anenheke-arlke, kere kwatye-arenye areyeke-arlke, itethe ingkirrekeke-arle boat akngerrenge-ntyele arrekantherrenge arraterlenge. ");
INSERT INTO aer_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ayenge uternelheme, The awethe kwatye urewe akngerre yanhe-arteke yernetyakenhe ahelhe nhenhe artetyeke. Kele arrangkwe awethe anetyeke. The awethe kwatye urewe akngerre alakenhe-arteke yernetyakenhe itethe ingkirreke ahelhe nhenhele akethe ante arrernetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Ngkartele itneke ileke, “Lyete The arne alkere akertneke arrernetyenhe arrenhantherrenhe irlpangkelhe-iletyeke The alhilentye akngerre Atyinhe atnyenetyeke, arrekantherre-artweye areyeke-arlke, itethe ingkirreke atningkeke-arlke. ");
INSERT INTO aer_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","The angkulyeke mpwelarre renhe akertne anthurreke arrernetyenhe, yanhe renhe arerrirremele arrenhantherrenhe irlpangkelhe-iletyeke alhilentye akngerre Atyinheke. ");
INSERT INTO aer_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","The alkere angkulyele artemele kenhe mpwelarre mpepenge arraterlenge, ");
INSERT INTO aer_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","The imerte itelaremele Ayenge-arle arrekantherrenhe uternelhemele, itethe ingkirrekeke-arlke kenhe kwatye urewe akngerrele apmere ahelhe nhenhe awethe artetyeke arrangkwe anteme, awethe arrenhantherrenhe akethe ante arrernetyeke, arrangkwe anteme. ");
INSERT INTO aer_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Kele nhenge mpwelarre re akenhe angkulyenge arraterlenge The renhe aretyenhe irlpangkemele alhilentye akngerre yanheke. Alhilentye akngerre yanhe re akwete-ante anerle-anetyenhe, uyerretyeke arrangkwe anteme-arle.” ");
INSERT INTO aer_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ngkarte Noah-eke angkeke, “Impene anthurre nhenhe re. Mpwelarre arraterlenge re aheye angkenhe-angkenhe ingkirreke irlpangkelhe-iletyenhe, Ayenge-arle alhilentye akngerreke uternelhemele.” ");
INSERT INTO aer_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Artwe Noah ikwere-artweye areye-arlke boat akngerrenge-ntyele atnarnpewarreke. Alere ikwerenhe Shem, Ham, Japheth uthene arritnye. ");
INSERT INTO aer_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Alere urrpetye nhenhe areye-ngentyele tyerrtye areye anteme atningke-ame-atninge-irreke apmere arrpe-anenhe-werne-atheke anteke-irremele anerrirretyeke. Tyerrtye ingkirreke alere urrpetyeke-artweye. ");
INSERT INTO aer_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Kenhe Noah re akenhe nthakenhakenhe itelareme merne apeke lyapelhe-iletyeke. Kele imerte merne kripethe areye anteme ngkernemele kartene akngerre ikwere. ");
INSERT INTO aer_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Merne kripethe mpenge-irrerlenge, renhe areye akeke ngkwarle mpwaremele. Ngkwarle antyweke-arle iperre akaperte arerte-irreke re mantere irlwelhe-ilemele tyerrtye akethe inteke apmere ikwerenhele. ");
INSERT INTO aer_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Kenhe alere ikwerenhe Ham, Canaan-eke anyikwe, apmereke irrpemele anyikwe renhe areke tyerrtye akethe yanhele interlenge, re apmere-ngentyele arratemele kake ikwere-atherreke iletyeke alheke. ");
INSERT INTO aer_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Kenhe Shem uthene Japheth uthene ratherre antyame inerle-anerreke renhe pwerlepe akertnele atnyenerle-anerremele. Kele ratherre apmereke irrpemele ampetyele akngerle-anerremele akngeye ikwere-atherrenhe antyameke athenemele. Ratherre renhe arerle-anerretyakenhe tyerrtye akethe interlenge. ");
INSERT INTO aer_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Kenhe arlte arrpenhele Noah re akeme-irreke re akaltye-irremele alere ingkernenye Ham-ele tyerrtye akethe renhe arekenge, renhe apurele-anthemele. ");
INSERT INTO aer_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Kenhe Noah re akenhe ikwere ahele-irreke alakenhe angkemele, “The Ngkarte apayuthnetyeke Canaan renhe, alere Ham-kenhe-arle, akurne mpwaretyenhenge! Kenhe lyete-ngentyele re kikwe areyeke akwetethe arnterre urrkapetyeke. ");
INSERT INTO aer_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Kenhe the akenhe Ngkarte apayuthnetyenhe Shem arntarnte-aretyeke. The Ngkarte apayuthnetyenhe Canaan uternetyeke Shem-eke arnterre urrkapetyeke, mane-kwenyeke. ");
INSERT INTO aer_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","The Ngkarte apayuthnetyenhe apmere atningke Japheth anthetyeke. Kenhe Japheth uthene Shem uthenele apmere akngerre yanhe ratherre-arrpe akalkelhe-ilerretyeke. Kenhe Canaan re akenhe Japheth ikwere arnterre urrkapetyeke, Japheth-ele renhe akwete uternetyenhe anteme-arle.” ");
INSERT INTO aer_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Kenhe kwatye akngerre yanhe uyerrekenge Noah re itethe akwete anerle-aneke year atningkeke-atwetye, year 350-pelenge awethe. ");
INSERT INTO aer_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kenhe re ampwe anthurre irremele re ilweke, year 950-peleke-atwetye re aneke-arle. ");
INSERT INTO aer_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ayeye nhenhe alere Noah-kenhe urrpetye-akerte, Shem, Ham, Japheth uthene arritnye. Artwe urrpetye nhenhele anewe-akeke ampe atningke atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Kenhe Japheth re akenhe alere nhenhe areye atnyeneke: Gomer, Magog, Madai, Javan, Tubal, Meshech, Tiras uthene. Kenhe nhenhe areye-ngentyele tyerrtye arrpenhe areye atningke-ame-atningke-irreke. ");
INSERT INTO aer_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Kenhe alere Japheth-kenhe Gomer arritnye aneke, re alere urrpetye atnyeneke Ashkenaz, Riphath, Togarmah arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Kenhe alere Japheth-kenhe arrpenhe Javan arritnye aneke, alere nhenhe areye atnyeneke Elishah, Tarshish, Kittim, Rodanim uthene arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kenhe nhenhe areye-ngentyele arrpenhe areye atningke-ame-atningke-irreke, tyerrtye nhenhe areye Japheth-eke-artweye areye. Kenhe arrpenheme itne kwatye alaye akngerre itepele anerrirretyarte, kenhe arrpenheme apmere akweke areye kwatye mpepele anerrirretyarte. Itne anyenhengenhenge areye anteye ingkirreke anerrirretyarte, angkentye itnekenhe-arrpe angkemele anerrirretyarte. ");
INSERT INTO aer_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Kenhe Ham re akenhe alere nhenhe areye atnyeneke: Cush, Egypt, Put, Canaan uthene arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Alere akngerrepate Ham-kenhele nhenhe areye atnyeneke: Seba, Havilah, Sabtah, Raamah, Sabteca uthene. Kenhe Raamah re akenhe alere atherre-akerte, Sheba uthene Dedan uthene arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kenhe Cush re akenhe alere atnyeneke Nimrod arritnye. Artwe nhenhe re akenhe ilyenpenye kere atwetyeke, rarle arrwekele anthurre. ");
INSERT INTO aer_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Ngkartele renhe lterrke mpwareke rarle atwentye akngerre anetyeke, alakenhe ikwerenge tyerrtye ingkirreke akwete angkeme, “Re ilernpenye anthurre artwe Nimrod aneke-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Artwe Nimrod nhenge apmere nhenhe areyeke akngerrepate aneke: Babylon, Erech, Accad, Calneh uthene. Apmere nhenhe areye apmere akngerre Shinar-ele aneke. ");
INSERT INTO aer_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Kele imerte Nimrod re apmere yanhe ikwerenge-ntyele impemele re alheke, apmere arrpenhe Assyria-werne alheke. Yanhe ikwerele re apmere arrpenhe areye arteke Nineveh, Rehoboth-Ir, Calah uthene. ");
INSERT INTO aer_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Re anteme apmere arrpenhe akngerre mpwareke Resen arritnye. Apmere nhenhe re Nineveh uthene Calah uthene mpwepele aneke. Tyerrtye atningke anthurre apetyewarremele apmere yanhele anerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Kenhe alere Ham-kenhe arrpenhe Egypt arritnye aneke. Re amangkemele akngerre-irreke alere seven-pele atnyeneke: Ludim, Anamim, Lehabim, Naphtuhim, ");
INSERT INTO aer_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Pathrusim, Casluhim, Caphtorim uthene. Urreke tyerrtye apmere Philistia-arenye areye artwe nhenge Caphtorim-eke-artweye areye. ");
INSERT INTO aer_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Alere ingkernenye Ham-kenhe, Canaan arritnye aneke, amangkemele akngerre-irreke alere atherrame atnyeneke. Alere arrekwelenye Sidon arritnye aneke, arrpenhe akenhe Heth arritnye aneke. ");
INSERT INTO aer_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","19","Anyenhenge atningke Canaan-engentyele arrateke, artweye-nhenge areye arritnye alakenhe: Heth, Jebus, Amor, Girgash, Hiv, Ark, Sin, Arvad, Zemar, Hamath uthene. Artweye-nhenge nhenhe areye Canaan ikwerenge-ntyele atningke-ame-atningke-irremele, itne imerte apmere arrpenhe areye-werne anteke-irrerirremele. Arrpenheme ayerrere-werne atheke alherlte-iwemele apmere Sidon-eke-atwetye. Kenhe arrpenheme antekerre-werne atheke alherlte-iwemele apmere Gaza-eke-atwetye. Kenhe arrpenheme ikngerre-werne atheke alherlte-iwemele Sodom, Gomorrah, Admah, Zeboiim utheneke-atwetye, apmere yanhe Lasha itwele. ");
INSERT INTO aer_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nhenhe areye Ham-kenheke-artweye areye aneke, itne apmere yanhe areyele anyenhengenhenge anerrirretyarte. Kenhe itne akenhe arrpenhenge areye akalkeke-akalke anerrirretyarte angkentye itnekenhe-arrpe angkerrirremele. ");
INSERT INTO aer_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Kenhe Shem re akenhe kake Japheth-kenhe aneke, re-arlke akngeye aneke alere Eber-kenhe areyeke. ");
INSERT INTO aer_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Artwe Shem nhenge re alere nhenhe areye atnyeneke: Elam, Asshur, Arpachshad, Lud, Aram uthene. Kele imerte nhenhe itneke-ngentyele arrpenhe areye anteme atningke-ame-atningke-irrerirreke. Kele imerte itnekenhe anyenhengenhenge yanhe ikwerele anerrirretyarte. ");
INSERT INTO aer_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Artwe Aram nhenge re alere nhenhe areye atnyeneke: Uz, Hul, Gether, Mash uthene arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Kenhe Shem-akenhe alere arrpenhe Arpachshad arritnye, re akenhe alere arritnye Shelah atnyeneke, kenhe Shelah re akenhe alere atnyeneke Eber arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Kele imerte Eber re alere atherre-akerte, Peleg uthene Joktan uthene arritnye antheke. Kenhe Peleg arritnye ileme “akalke-irreme.” Nhenhe ikwerele-ureke, Peleg itethe anerlenge, tyerrtye apmere ahelhe nhenhele anerrirreke akalke-irremele apmere arrpe-anenhe-werne anteke-irreke. ");
INSERT INTO aer_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","29","Kenhe artwe Joktan re akenhe alere atningke atnyeneke, itnekenhe arritnye aneke: Almodad, Sheleph, Hazarmaveth, Jerah, Hadoram, Uzal, Diklah, Obal, Abimael, Sheba, Ophir, Havilah, Jobab uthene, yanhe areye kele. Nhenhe areye ingkirreke alere areye Joktan-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Kenhe apmerele Shem ikwerenhe areye anerrirretyarte, alturle ampinye-ngentyele apmere Mesha arritnye-werne atheke, ikngerre-werne atheke apwerte antherrtyeke-atwetye, apmere Sephar arritnye ikwereke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Shem-eke-artweye areye apmere arrpenhe yanhe areyele anyenhengenhenge anerrirretyarte, apmere itnekenhe-arrpele anyente ikwerele. Kenhe itne akenhe arrpenhenge areye akalkeke-akalke anerrirretyarte angkentye itnekenhe-arrpe angkerrirremele. ");
INSERT INTO aer_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Arritnye nhenhe areye anyenhengenhenge ingkirreke artwe Noah-engentyele, alerikwe areye-ngentyele. Kenhe kwatye akngerre uyerreke-arlenge-ntyele, Noah-eke-artweye, alerikweke artweye-arlke atningke-ame-atningke-irremele ingkernenye areye, itne apmere arrpe-anenhe-werne anteke-irrerirremele, ahelhe arrpe-anenhe-werne itne akalke-irrerirreke. Itnekenhe-arrpe anyenhengenhenge anerrirretyarte. ");
INSERT INTO aer_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Nhenhe ikwerele-ureke, arrekwelenye areye itne angkentye anyente ware angkerrirretyarte, itne ingkirreke angkentye rante-rante angkerretyarte. ");
INSERT INTO aer_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Ikngerre ampinyele itne anerrirretyarte iperre, itne apmere yanhe impemele aname-irreke ahelhe akethe akngerre-werne apmere Shinar-ele, yanhe ikwerele anerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Itne apmere yanhe ikwerele anerlte-anemele angkerreke, “Anwerne ahelhe urrkngele arne brick areye mpwarewarretyeke, ure akngerrele itemele itne lterrke-irretyenhenge. Kele imerte anwerne apmere arlpentye akngerre renhe mpwarewarremele.” Kele itne ahelhe urrknge-ngentyele brick areye mpwarewarreke, apwerte-kwenye-arle, itnenhe urele lterrke-ilemele. Itne imerte tar mpwaremele, itnenhe anyentelhe-iletyeke, kwentye-kwentye itnenhe artemele. ");
INSERT INTO aer_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Itne anteme angkerreke, “Yewe, anwerne warle atningke arteye, anwerne apurte anteme anetyeke atningke anthurre-arle anwerne irremenge, anteke-irretyakenhe anerlte-anetyeke. Kele anwerne anteme warle arlpentye akngerre anthurre mpwepenge arteye alkere akertneke-atwetye. Kenhe arrpenhe areye akweke iperre areye apetyetyenhe apmere nhenhe arerrirremele itne itelarerrirretyenhe anwernenhe tnakewarretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","7","Kenhe Ngkarte re akenhe akertne-ngentyele atnarnpetyekerleke apmere akngerre areye-arlke warle arlpentye akngerre nhenge itne-arle artetyame renhe aretyeke. Re ikwere-arrpe angkeke, “Tyerrtye nhenhe areyele arne iwenhe apeke renhe mpwaretyeke, itne ingkirreke-arle angkentye anyente-ante angkemenge, itne ingkirreke-arle awerreme-arle. Itne apeke alakenhe renhe akwete mpwaremele, kele imerte itne iwenhe apeke ikwere ahentye-anemele itne mpwaretyeke, arrpenheke arrangkwele itnenhe arrkngerte-iletyeke. Mpe, anwerne itneke-werne-atheke atnarnpetyekerleye angkentye itnekenhe akalkelhe-iletyenhe itnenhe apatelhe-ilemele, itne anteme uye awerretyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Alakenhe renhe-arle Ngkartele tyerrtye yanhe areye irrarnpelhe-ileke. Kele itne warle areye-arlke warle arlpentye akngerre-arlke artentye impelheke, itne-arle uye awerretyarte. Kenhe apmere yanhe re akenhe Babel arritnye-arle aneke tyerrtye areyele-arle uyarne awerretyartenge. Kele itne apmere arrpe-anenhele anteme aneme irrarnpeke-irrarnpe anthurre re anteme. ");
INSERT INTO aer_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","11","Ayeye nhenhe Shem-eke-artweye areye-akerte. Shem itethe aneke year 100-peleke-atwetye, re anteme alere atnyeneke Arpachshad arritnye, rarle inteke year atherrame iperre kwatye urewe akngerre uyerrekenge-ntyele. Arpachshad akweke interlenge-arle iperre artwe Shem re akenhe year 500-pele awethe aneke, urreye areye marle areye-arlke arrpenhe atnyenemele. ");
INSERT INTO aer_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","13","Kenhe Arpachshad re akenhe year 35-pele aneke-arle iperre, alere Shelah arritnye atnyeneke anteme. Shelah inteke-arle iperre, Arpachshad year atningke anthurre awethe anekenge, 403-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","15","Kenhe Shelah re akenhe year 30-pele aneke-arle iperre, alere Eber arritnye atnyeneke anteme. Eber inteke-arle iperre, Shelah year atningke anthurre awethe anekenge, 403-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","17","Kenhe Eber re akenhe year 34-pele aneke-arle iperre, alere Peleg arritnye atnyeneke anteme. Peleg inteke-arle iperre, Eber year atningke anthurre awethe anekenge, 430-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","19","Kenhe Peleg re akenhe year 30-pele aneke-arle iperre, alere Reu arritnye atnyeneke anteme. Reu inteke-arle iperre, Peleg year atningke anthurre awethe anekenge, 209-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","21","Kenhe Reu re akenhe year 32-pele aneke-arle iperre, alere Serug arritnye atnyeneke anteme. Kele imerte Arpachshad year atningke anthurre awethe anekenge, 207-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","23","Kenhe Serug re akenhe year 30-pele aneke-arle iperre, alere Nahor arritnye atnyeneke anteme. Nahor inteke-arle iperre, Serug year atningke awethe anekenge, 200-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","25","Kenhe Nahor re akenhe year 29-pele aneke-arle iperre, alere Terah arritnye atnyeneke anteme. Terah inteke-arle iperre, Nahor year atningke awethe anekenge, 119-pele ingkirreke, urreye areye marle areye-arlke arrpenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Kenhe Terah re akenhe year 70-pele aneke-arle iperre, re alere urrpetye atnyeneke. Itnekenhe arritnye aneke, Abram, Nahor, Haran uthene aneke. ");
INSERT INTO aer_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","32","Ayeye nhenhe artwe Terah-eke-artweye areye-akerte. Terah-ele alere urrpetye atnyeneke, Abram, Nahor, Haran uthene arritnye. Kenhe Haran re akenhe alere Lot arritnye atnyeneke. Haran re ilweke anyikwe Terah itethe akwete anemenge. Haran apmere Ur-ele ilweke, apmere akngerrele Chaldea-arenye areyeke, apmere yanhe nhenge nthenhele-arle re inteke-arle. Haran re akenhe itethe akwete anemele re marle akweke atherre-akerte, Milcah uthene Iscah uthene. Kenhe Milcah re akenhe Nahor anewe akeke, Nahor kake Haran-kenhe aneke. Kenhe Abram-ele akenhe anewe akeke arelhe Sarai arritnye. Kenhe Sarai re akenhe ampe uyarne atnyenetyarte. Re uyarne atnerte-atnerte-irreme. Arlte anyentele Terah apmere Ur-ngentyele aname-irreke. Re alerikwe Abram, anewikwe Abram-kenhe Sarai, arrenge-arrenge ikwerenhe Lot arritnye apmere yanhe-ngentyele akngeke. Itne apmere arrpenhe Canaan-werne alhetyeke-irreme. Kenhe urreke-arle apmere yanheke irretyenhenge itne apmere arrpenhe ikwere irretye-alheke Haran arritnyeke. Kele yanhe ikwerele itne akwete anteme anerrirretyarte. Kenhe Terah re akenhe ampwe-irremele year 205-pele aneke-arle iperre re ilweke apmere yanhe Haran ikwerele. ");
INSERT INTO aer_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Ngkartele Abram renhe ileke, “Apmere ngkwinhe imperle-alhaye, apmere akngeye ngkwinhe-kenhe inpe imperle-alhemele, ngkwenge-artweye areye-arlke imperle-alhaye, The apmere arrpenhe ngkwenge imernetyenhenge anetye-alhetyeke. ");
INSERT INTO aer_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Yewe, The ngenhe ampe atningke anthurre anthetyenhe, ngkwenge-artweye atningke-ame-atningke-irretyenhenge. Arritnye ngkwinhe akngerre anteme irretyenhe, kenhe tyerrtye areyele apmere arrpe-anenhe-arenyele ngenhe tnakewarretyenhenge. The ngenhe arntarnte-aretyenhe ngkwenge akangkentye anemele. Kenhe unte akenhe arrpenhe areye arntarnte-aretyenhe itneke akangkentye anemele. ");
INSERT INTO aer_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Kenhe tyerrtye areye apeke ngkwenge akangkemele aneme, ngenhe arntarnte-aremele, kele Ayenge itneke akangketyenhe itnenhe mwerre arntarnte-aretyenhenge. Kenhe itne apeke akurne ngkwenge mpwarewarretyenhe, kenhe Tharle itneke akurne mpwaretyenhenge. Kenhe ngkwengenge ayenge tyerrtye areyeke apmere arrpe-anenhele akangketyenhe, itnenhe arntarnte-aremele.” ");
INSERT INTO aer_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","5","Kele Abram akenhe YAHWEH-eke akangkwe-irreke. Apmere Haran ikwerenge-ntyele Abram imperle-alheke anewikwe Sarai-akerte-arlke alere atyeyikwe-kenhe Lot-arlke, urrkapentye akngerre ikwerenhe areye-akerte-arlke. Re ingkirreke ikwerenhe areye akngetyeke, kamule areye-arlke, nanikute areye-arlke, pweleke areye-arlke, tangkeye areye-arlke arne iwenhe-iwenhe areye-arlke, ingkirreke itne-arle apurtelhe-ilemele apmere Haran ikwerele-arle atnyenewarreke. Re itnenhe apmere arrpenhe Canaan arritnye-werne akngeke. Nhenge Abram year 175-pele aneke re apmere Haran imperle-alheke. ");
INSERT INTO aer_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Kenhe itne alherlte-iwepiwemele apmere Canaan ikwere arratye irrperrirreke, kenhe tyerrtye atningke akenhe kele-arle anerlte-anetyame, Canaan-arenye areye. Kele itne alethe alherlte-iwemele akwete apmere Shechem-eke-irreke. Apmere nhenhe itwele-arle arne ameke-ameke akwele tneke, arne nhenge Moreh-kenhe. Abram apmere yanhe ikwerele ngkernelheke. ");
INSERT INTO aer_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Kele imerte YAHWEH-ele arratemele Abram ikwere angkeke, “Apmere nhenhe apelaye Tharle ngenhe anthetyeke ngkwenge-artweyeke anetyenhenge.” Kenhe Abram re akenhe akangkeke anthurre, re imerte apwerte areye inemele aharle-iwemele akertneke-arleke kere itetyeke YAHWEH renhe tnaketyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Yanhe ikwerenge-ntyele Abram ikwere-artweye areyenge impemele antekerre-werne atheke alheke apmere apwerte-apwerte-werne ikngerre ampinyele apmere Bethel-enge. Yanhe ikwere irremele itne apmere mpwepele mpwareke Bethel-enge ikngerre ampinyele, kenhe apmere arrpenhe Ai re akenhe alturle-ampinyele. Re awethe anteye-arle apwerte arrpenheme inemele aharle-iwemele YAHWEH renhe tnaketyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Kele imerte Abram ikwerenhe areye-arlke apmere yanhe impemele antekerre-werne atheke apmere ahurratye Negev-werne alethe alhemele. ");
INSERT INTO aer_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Kenhe apmere Canaan ikwerele ararrtye anthurre aneke, kwatye-arlke urntetyakenhe, tyerrtye areye merneke arrangkwe anteme anerrirreke. Kele Abram apmere yanhe imperle-alhemele antekerre-werne alheke apmere Egypt-werne-atheke yanhe ikwerele anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","12","Kenhe urreke apmere ikwere irrpetyenhenge re apmere arrpenhe akweke ikwere ngkernelheke Egypt itereke. Yanhe ikwerele re anewikwe Sarai ikwere angkeke, “Unte apele arelhe mwerre akngerre, kele Egypt-arenye areyele ngenhe aremele apeke itne itirretyenhe, ‘Ayekaye, arelhe nhenhe re mwerre akngerre,’ itne apeke ngkwenge alhirretyenhe. Kele imerte itne ayenge atwetyenhe, ngenhe kwenye. ");
INSERT INTO aer_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Alakenhe irreketyenge, itneke ilaye, ‘Nhenhe apele kake atyinhe-arle.’ Unte apeke alakenhe angkerlenge, kele itne ayenge atwetye-kwenye-arle, ayenge mwerre anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Kele itne apmere Egypt-eke irrperreke, kenhe Egypt-arenye areye itne akenhe Sarai arratye arerrirremele angkerrirreke, “Ayekaye, arelhe nhenhe re arratye mwerre akngerre.” ");
INSERT INTO aer_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Kenhe urrkapentye akngerre Pharaoh-kenhe areyele Sarai arerrirremele, itne akngerrepate itnekenhe iletyete-alheke arelhe mwerre akngerre nhenge-akerte. Kenhe re itneke ileke apmere ikwerenhe-werne renhe akngetyetyeke. Itne renhe inetyete-alheke apmere Pharaoh-kenhe-werne akngetyewarremele. ");
INSERT INTO aer_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Pharaoh Abram-eke akangkentye aneke Sarai-iperre, kele imerte re renhe yepe-yepe areye, nanikute areye, pweleke areye, kamule areye, tangkeye areye-arlke antheke, urrkapentye akngerre arrpenheme-arlke. ");
INSERT INTO aer_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Kenhe YAHWEH re akenhe Pharaoh-eke akangkentye anetyakenhe rarle Sarai Abram-engentyele rakerlenge. Kele imerte YAHWEH-ele Pharaoh rlkerte-ileke, arrpenhe areye-arlke ikwerenge-arle anerlte-anetyame, Re ingkirreke rlkerte-ileke anteye. ");
INSERT INTO aer_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","19","Kele Pharaoh Abram-eke antangkelheke. Re apetyerlenge arteke, Pharaoh ikwere angkeke, “Iwenheke-ame unte atyenge ularele urrtyirreke? Nthakenhe-arle-ame unte atyenge iletyakenhe arelhe nhenhe-arle anewe ngkwinhe aneme? Unte arelhe nhenhe ayenge apale antheke atyeye ngkwinhe akwele, kenhe re akenhe ngkwenge anewe-arle. Nhenheyaye, renhe iparrpe akngirtnemele alhaye.” ");
INSERT INTO aer_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Ikwere iperrele, Pharaoh-ele urrkapentye ikwerenhe areye uterneke Abram uthene anewikwe uthene aywepetyeke. Kele imerte Abram uthene ikwere-artweye areye uthene impelheke, arne ingkirreke itnekenhe akngerlte-iwemele. ");
INSERT INTO aer_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","2","Apmere Egypt-ngentyele, Abram itneke-akerte alpeke ayerrere-ikngerre apmere ahurratye Negev-werne. Re atnyeneke mane-arlke atningke, pweleke areye-arlke, kamule areye-arlke, merne akngerre-arlke, arne arrpenhe atningke-arlke. Kele Lot-eke-artweye areye inpe, ikwerenge apurte Negev-werne alherlte-iweke. ");
INSERT INTO aer_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","4","Yanhe-ngentyele, itne ayerrere anteme alheke, apmere arrpe-anenhele inteke. Itne alpeke apmere arrkatye ikwere-werne apmere Bethel uthene Ai uthene mpwepele Abram-arle aneke arrekwele, rarle apwerte areye kwentye-kwentye-ileke YAHWEH-eke, ameke-ameke ikwere. Yanhe anthurreke Abram-ele YAHWEH utyernemele tnakeke. ");
INSERT INTO aer_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Alere atyeyikwe-ke Abram-kenhe Lot arritnye, re-inpe arne atningke atnyenetyarte, pweleke areye-arlke, yepe-yepe areye-arlke, urrkapentye akngerre atningke areye-arlke. Ratherre arne atningke anthurre atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Apmere ikwerele, arrekwele anetyarte tyerrtye Canaan-arenye areye, arrpenhe areye-arlke, Perizzite areye, yanhe ikwerele itne-arlke apmere-ampinye ikwerele. Atherrke akweke ware anetyarte pweleke areyeke, arrpenhe areyele-arlke arlkwetyeke, kwatye akweke ware-arlke aneke. Alakenhe ikwerenge anteme, urrkapentye akngerre Abram-kenhe areye ante urrkapentye akngerre Lot-kenhe areye ahele angkerreke atherrkeke-arlke kwatyeke-arlke arrangkwenge. Itne uyarne apurte anetyarte apmere anyente ikwerele, atherrke-arlke kwatye-arlke akweke warenge. Alakenhe ikwerenge itne ahele angkerretyeke-irreke. ");
INSERT INTO aer_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Yanhenge anteme, Abram Lot-eke angkeke, “Anwerneke-artweye kwenhe anyente aneme, urrkapentye akngerre anwerne-kenhe ilterrerlenge ipmentyele aretyale. ");
INSERT INTO aer_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Apmere ahelhe kwenhe akngerre aneme anwerne ingkirrekeke. Apmere nhakwe araye ikngerre, antekerre, alturle, ayerrere uthene. Apmere ngkwenge akngakaye. Unte apeke alturle-werne alheme, ayenge ikngerre-werne-arle alhetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","13","Kele, Lot-ele apmere renhe areke. Re ahelhe akethe areke lhere anteke kwatye akngerre-akerte interlenge. Re areke arne akngerre atningke lhere iterele, lhere renhe-arle akenhe ileme Jordan, re antekerre-werne inteme apmere Zoar-werne-atheke. Apmere re mwerre akngerre nhenge Eden-arteke aneme nhenge YAHWEH-elarle mpwareke Adam uthene Eve utheneke, nhenge apmere arrpenhe Egypt-arlke-arteke. Kele Abram uthene Lot uthene akalke-irrerle-anerreke. Lot-ele apmere ahelhe akethe nhenge akngakeke lhere akngerre-akerte interlenge, antekerre-ikngerre-werne atheke aname-irreke apmere yanhele anetyeke, apmere nhenge Sodom itwele. Nhenhe renhe-arteke aneke, urreke Ngkartele apmere Sodom uthene Gomorrah uthene akethe ante arrernetyenhenge tyerrtye apmere yanhe atherre-arenye areye-arle akurne anthurre anerrirretyartenge. Kenhe Abram akenhe apmere Canaan-ele anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","15","Ikwerenge-ntyele, Lot-arle kele alhekenge, YAHWEH Abram-eke angkeke, “Irntwarre anthurre araye apmere ayerrere-atheke, antekerre-atheke, ikngerre-atheke, alturle-atheke. The ngenhe antheme apmere ahelhe nhenhe ngkwenge akwerrke areye uthene ngkwenge-artweye areye-arlke. Kele apmere rarle ngkwenge-arle, ngkwenge-artweye areyeke-arlke akwete-ante anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ngkwenge akwerrke areye atningke-irretyenhe yerre areye-arteke. Angwenhele ampe ngkwinhe areye alknge ikwerenhele anyente-ame-anyente aretyeke arrangkwe-arle, itne-arle atningke anthurre anerrirrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Unthetyeke alhaye apmere arrpe-anenhele, irntwarre antekerre-atheke, alturle-atheke, ayerrere-atheke, ikngerre-atheke. The apele ngenhe, ngkwenge-artweye areye-arlke apmere nhenhe ingkirreke anthetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kele, Abram alhetyeke-irreke alturle antekerre-atheke. Apmere arrpenhe atningkele re anetyarte. Re apetyeke apmere arrpenhe-werne apmere Hebron, yanhele anetyarte. Apmere Hebron ikwerele aneke arne ameke-ameke akngerre atningke. Arne nhenhe areye artwe Mamre-kenhe. Yanhe ikwere Abram-ele apwerte areye kwentye-kwentye-ileke YAHWEH-eke renhe utyernemele tnaketyeke. ");
INSERT INTO aer_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nhenhe ikwerele-ureke artwe anyente re akenhe apmere Babylon-eke Akngerrepate-arle aneke, Amraphel arritnye aneke. Arioch Akngerrepate aneke apmere Ellasar-ekarle. Kedorlaomer apmere Elam-ekarle Akngerrepate aneke, Tidal apmere Goiim-ekarle Akngerrepate aneke. ");
INSERT INTO aer_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Akngerrepate four-pele itne thultye areye itnekenhe-arlke apetyewarreke atwerrirretyeke Akngerrepate arrpenhe five-pele areyenge ante thultye itnekenhe areyenge. Arritnye itnekenhe aneke, Bera, Birsha, Shinab uthene Shemeber uthene-arlke. Kenhe Bera akenhe apmere Sodom-ekarle Akngerrepate aneke, kenhe Birsha akenhe apmere Gomorrah-ekarle Akngerrepate aneme, Shinab apmere Admah-ekarle Akngerrepate aneke, kele Shemeber akenhe apmere Zeboiim-ekarle Akngerrepate aneke. Artwe arrpenhe Bela-karle Akngerrepate aneke. Arritnye arrpenhe aneke apmere ikwere Zoar-arle. ");
INSERT INTO aer_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nhenge Akngerrepate four-pele thultye itnekenhe-akerte apetyewarremele Akngerrepate five-pele itnekenge atwerretyeke, Akngerrepate five-pele itne thultye itnekenhe areye-akerte apurte-irreke lhere Siddim-enge. (Lyete anwerne apmere nhenhe ileme, “Kwatye Alaye Apirnte.” Arrangkwe-arle kwatye kwene ikwerele aneme.) ");
INSERT INTO aer_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Urreke alakenhe irretyenhenge, Akngerrepate Kedorlaomer kwenhe akngerrepate aneke Akngerrepate five-pele arrpenhe itneke year 12-peleke-atwetye. Year arrpenhele anteme itne ikwere urrkapetyakenhe anteme aneke. Itne renhe atwetyeke angkerreke. ");
INSERT INTO aer_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Alakenhenge year arrpenhele anteme, Akngerrepate Kedorlaomer-ele ileke Akngerrepate Amraphel, Arioch, Tidal uthene artwe thultye itnekenhe apurtelhe-iletyeke Akngerrepate arrpenhe itnekenge atwerretyeke. Akngerrepate four-pele itne akenhe alheke thultye itnekenhe-akerte apmere Ashteroth-karnaim arritnye-werne tyerrtye Rephaite areyenge atwerretyeke. Thultye areye Akngerrepate Kedorlaomer-kenhele tyerrtye Rephaite areye atweke. Kele itne alheke apmere Ham-werne tyerrtye Zuzite areye-arle aneke-werne itnenhene atwetyeke. Yanhe-ngentyele, itne apmere Shaveh Kiriathaim-werne alheke tyerrtye Emite areye atwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Kele anteme, thultye Kedorlaomer-kenhe areye alheke apwerte antherrtye apmere Edom-werne apmere El Paran arritnye-werne. Apmere arerrke akngerre itwele. Thultye akngerrepate Kedorlaomer-kenhe areyele tyerrtye Horite areye atwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Yanhe-ngentyele, thultye Kedorlaomer-kenhe areye alheke apwerte antherrtye-ngentyele apmere En Mishpat-werne. Arritnye arrpenhe aneme nhenheke Kadesh-arle. Thultye akngerrepate Kedorlaomer-kenhe areyele tyerrtye Amalekite areye uthene Amorite areye uthene atwetyeke. Tyerrtye Amorite areye anetyarte apmere Hazazon-Tamar-ele. ");
INSERT INTO aer_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Akngerrepate five-pele itne Sodom-arenye, Gomorrah-arenye, Admah-arenye, Zeboiim-arenye uthene Bela-arenye-arlke itne awerrirreke Akngerrepate Kedorlaomer-arle apetyeme Akngerrepate urrpetye arrpenhe areye-arlke-akerte itnenhe atwetyeke. Arratye anteme, itne alheke lhere Siddim arritnye-werne atwerretyeke. ");
INSERT INTO aer_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Apmere yanhenge, itne akngerre atwerreke Akngerrepate areye Kedorlaomer-enge, Tidal-enge, Amraphel-enge, Arioch-enge uthene thultye areye itnekenhenge. Thultye apurte four-pele itne atwerreke thultye apurte five-pele itnekenge. ");
INSERT INTO aer_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Lhere akngerre Siddim itwele aneke ahelhe urrknge akngerre aneke. Angwenhe apeke-arle akertnele untheke, kele re iperte urrknge ikwere atnyemele ilwemele-arle. Atwerrentyele-ureke, Akngerrepate Sodom-arenye uthene Gomorrah-arenye uthene thultye ikwere-atherrenhe areye-arlke atere unterlte-iweke. Itne ahelhe urrknge ikwere atnyeke, ingkirreke-ante itne ilweke, yanheke-ante. Akngerrepate urrpetye arrpenhe itne thultye itnekenhe-arlke atere unteke apwerte antherrtye akertne-werne ilweme-ketyenge. ");
INSERT INTO aer_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Kele yanhenge Akngerrepate Kedorlaomer thultye ikwerenhe areye-akerte alheke Sodom-werne Gomorrah-werne-arlke itne anyelkngele ineke arne ingkirreke tyerrtye yanhe-arenye areye-ngenytele. Itne merne-arlke ingkirreke anyelkngele ineke. ");
INSERT INTO aer_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Yanhenge arrekwele aneke, Lot-arle anetyarte apmere Sodom-ele. Re akenhe alere kikweke Abram-kenhe aneke. Kele thultye Kedorlaomer-kenhe areyele Lot akngerlte-iweke jail-werne. Itne arne ingkirreke Lot-kenhe areye-arlke anyelkngele ineke. Kele imerte itne apmere itnekenhe-werne alpemele. ");
INSERT INTO aer_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Kenhe artwe anyente akenhe Sodom-engentyele alwirreke. Re alheke Abram-eke iletyeke re akenhe Hebrew-arle aneke Kedorlaomer-elarle Lot akngeke arne ikwerenhe areye-arlke. Ikwerenge anteme, Abram apmere Hebron-ele aneme, arne akngerre anyente itwele aneke, arne nhenge Mamre-kenhe Amorite-arle aneke. Mamre re akenhe kake akngerrepate aneke Eshkol uthene Aner atherreke-arle. Arrwekele akenhe, itne Abram-eke angkeke tyerrtye areye apeke renhe atwetyeke apetyerlenge, itne renhe arntarnte-arerle-anemele anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","15","Nhenge Abram-ele aweke-arle iperre Akngerrepate areyele alerikweke ayernerlenge rakeke, re artwe atwerrentye akngerre ikwerenhe areye apurtelhe-ileke Mamre uthene kake ikwerenhe atherre uthene itnekenhe thultye areye-arlke itne atwirtnetyeke itnenhene. Kele, itne irraweye alheke ayerrere-werne, apmere Dan arritnye-werne. Dan itwele aneke, Kedorlaomer thultye ikwerenhe areye-akerte angathele inteke. Abram uthene thultye 318 ikwerenhe areye, itne aperteke ingwe mpwepele, ingke akantyele alhemele atweke itepe arrpe-anenhe-ngentyele. Itne kwene-akerle untemele arnterre arlkemele anthurre. Kele thultye Abram-kenhe areyele thultye Kedorlaomer-kenhe areye irnterre anthurre atweke. Thultye Abram-kenhe areyele itnenhe urrpetye atweke. Arrpenhe areyele itnenhe aterele-anthemele alwerneke apmere Damascus-enge anpere-irrenhemele ayerrere-werne-atheke. Yanhe-ngentyele itne itnenhe alwerneke apmere arrpenhe Hobah-werne. ");
INSERT INTO aer_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Yanhe-ngentyele atwerreke-arle ipenhe Abram-ele Lot inirtneke ampe ikwerenhe areye-arlke arelhe-arlke arne areye-arlke pweleke areye-arlke ingkirreke. Re antekerre akngirtneke apmere akngerre Sodom ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Apmere Sodom ikwerele, Akngerrepate arrpenhele aweke ayeye Abram-akerte, re renhe aretyeke apetyeke. Mpwepenge ratherre anyente-irreke apwerte atwatye Shaveh arritnye aneke. Tyerrtye areye apmere yanhe ileme, “Apwerte Atwatye Akngerrepate-kenhe.” ");
INSERT INTO aer_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Akngerrepate arrpenhe apetyeke Salem-engentyele Melchizedek arritnye aneke. Re akenhe Akngerrepate anetyarte tyerrtye Salem-arenye areyeke. Re akenhe kwertengerle aneke urrkapentye akngerre Ngkarte-kenhe. Re Abram-eke arratetye-alheke, re renhe mpwepeke renhe aremele. Re Abram merne uthene ngkwarle akweke uthene antheke, imerte ikwere akangkemele. ");
INSERT INTO aer_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Re anteme angkeke Abram-eke, “Ayenge Ngkarteke angkeme ngkwenge, Ikwere re kwenhe akngerre anthurre aneme akertnele. Ngkarte re akwele aknganeke alkere-arlke ahelhe nhenhe-arlke. Unte kwenhe akangkentye anthurre anerle-anetyenhe Ikwerenge-ntyele ware. ");
INSERT INTO aer_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Kele unte-arle renhe mwerre akeme nhenge Rarle ngenhe ameke-arerlenge itethe atnyenemele atwerrekerlenge ureke.” Alakenhe-arle re Abram-eke angkeke. Kele ikwerenge anteme, arne Abram-elarle ineke King four-pele nhenge areye-ngentyele, re yakwethe ten-peleke-arlenge arrerneke, ten-pele ikwerenge-ntyele re Melchizedek anyente antheke ikwere akangkemele. ");
INSERT INTO aer_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Yanhe-ngentyele, Akngerrepate Sodom-arenye anteme Abram-eke angkeke, “Tyerrtye atyinhe areye ayenge anthintye-alpaye, Kedorlaomer-arle akngeke areye atwerreke-arlele ureke nhengenge. Arne itnekenhe mane-arlke, kele ngkwenge anteme atnyenaye.” ");
INSERT INTO aer_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abram ikwere alakenhe angkirtneke, “Arrangkwe, tharle arne yanhe areye inetyeke arrangkwe-arle. Nhenhe anthurrenge, YAHWEH-ele ayenge angkerlenge aweme, YAHWEH-elarle arne ingkirreke arrerneke nhenheke arrule, the ngkwenge arratye ileme YAHWEH-eke arratye alhilemele: ");
INSERT INTO aer_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","The kwenhe arne ngkwinhe areye inetyeke arrangkwe-arle, string anyenteke apeke ingke-kenhe anyenteke apeke, arrangkwe-ante. Tharle arne yanhe areye arrangkwe-arle akngetyeke unte apeke ayeye ilerle-apeketyenge arrpenhe areyeke unte-arle ayenge arne areye antheke. Ayenge-arle alakenheke ahentye-anetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Thultye atyinhe areyele kele-arle merne arlkweke. Nhenhe areyeke merne akweke anthaye. Kele imerte merne-arlke arne arrpenhe-arlke anthemele arrpenhe nhenhe areye Mamre uthene Eschol uthene Aner-kenhe-arlke, nhenge itne anteme arne yanhe areye-akerte apmere itnekenhe-werne alpetyenhenge.” Kele, arne itneke-akerte merne-arlke-akerte itne akalke-irremele alperlte-iweke. ");
INSERT INTO aer_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Yanhe iperre, akngerre-arle atwerreke iperre, Abram-ele altyerre areke, altyerre ikwerenge re areke YAHWEH apetyerlenge imerte ikwere angkemele, “Abram, atere-irretyale! Ayenge kwenhe ngkwenge alkwerte-arteke, alkwertele-arle ilpelhentye akngerre, tharle ngenhe arntarnte-aremele itnenhe arrkngente-iweme, The imerte ngenhe arne mwerre anthurre anthemele.” ");
INSERT INTO aer_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Kenhe Abram-ele renhe apayuthneke, “Yewe, YAHWEH, kele mwerre-arle unte apeke ayenge arne mwerre nhenhe anthemele, kele lyete ayenge aneme ampe urreyeke arrangkwe. Angwenheke anteme the arne atyinhe areye anthetyenhe ayenge ilwemele, tyerrtye arrpenhe-ame the anthetyenhe? Ayenge apeke alereke-arlke arrangkwe ilwemele, urrkapentye akngerre atyinhele-arle arne areye ineme atyenge-ngentyele. Nhenhe Eleazar arritnye aneme, apmere Damascus-arenye. ");
INSERT INTO aer_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Unte kwenhe ayenge alere anthetyakenhe. Ayenge ilweme alereke arrangkwe akwete, nhenge Eleazar, urrkapentye akngerre atyinhe arrpenhe areyeke akngerrepate-arle anemeke, rarle arne atyinhe areye ingkirreke ineme.” ");
INSERT INTO aer_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","YAHWEH anteme Abram-eke angkeke, “Arrangkwe, alakenhe-arle arratye kwenye-arle. Eleazar yanhele-arle arne ngkwinhe areye inetyeke arrangkwe-arle. Unte-arle alere ngkwinhe anyente-arle atnyenetyenhe. Rarle kwenhe arne ngkwinhe ingkirrenyeke inetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Yanhe-ngentyele, YAHWEH-ele anteme Abram kwene-ngentyele akethe-werne tyerreke ilthe-ngentyele. Re Abram-eke angkeke, “Akertne nhakwe araye kwerralye akertne nhakwe areye, nthakentye-ame unte areme? Alakenhe akwele ngkwenge akwerrke areye anetyenhe, kwerralye areye-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Kele, Abram YAHWEH-eke akangkwe-irreke re angkekenge. Rarle arratye itelareke iwenhe YAHWEH-ele ikwere alhileke-arle altyerrenge rarle akwerrke atningke anthurre atnyenetyenhenge. Yanhenge anteme, YAHWEH-ele Abram arratye akeke rarle ikwere akangkwe-irrekenge, Re ikwere anteme angkeke, “Unte apele atyenge arratye aneme.” ");
INSERT INTO aer_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Ikwere iperre, YAHWEH ikwere angkeke, “Ayenge-arle YAHWEH. The akwele ngenhe yerrele akngeme apmere Ur-enge apmere akngerre Babylon-engentyele. Tharle ngenhe apmere nhenhe-werne akngetyeke. The ngenhe apmere nhenhe antheme unte apmere nhenhele akwete-ante anerle-anetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abram-ele renhe apayuthneke, “Kele YAHWEH, the kwenhe arratye itelaretyakenhe iwenhe unte-arle angkeme atyenge apmere nhenhe-akerte. Nthakenhe-ame the itelareme apmere atyinhe nhenhe?” ");
INSERT INTO aer_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","YAHWEH Abram-eke angkirtnerlenge, “Kele mwerre, Tharle ngkwenge imerneme angkentye arratye atyinhe. Pweleke marle anyente inemele akngetyaye, nanikute anyente-arlke, yepe-yepe urreye anyente uthene, year urrpetye aneke areye. Itnenhe nhenhe-werne akngetyaye. Thipe atherre-arlke akngetyaye, urelyarre anyente, uthene apelkere anyente uthene.” ");
INSERT INTO aer_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Kele, Abram-ele inetye-alheke imerte akngetyemele YAHWEH-werne. Yanhe-ngentyele, re pweleke ahentye akeke, nanikute uthene yepe-yepe-arlke. Pwelekeke-amparre re akiltye-ileke mpepenge tyarrpemileme, nanikute uthene yepe-yepe uthene-arlke re akiltye-ileke mpwepenge. Thipe atherre, re mpankwe akwete-arle impeke, mpwepenge aketyakenhe-arle. Yanhe-ngentyele, re akalke-ileke itnenhe akerte arratye atherrame arrerneke. ");
INSERT INTO aer_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Abram-ele anemele aretyame kere itnenhene irretyele ineme-ketyenge. Itne kwene-irremele ineme-ketyenge. Alakenhe-irreme-ketyenge, re kere itnenhe aretyame, kele re aywepeke irretye itnenhe. ");
INSERT INTO aer_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Kele uterne-arle irrpekenge, re apurrke-irremele ankwe anteme inteke. Rarle ankwenge ingwele anthurre anteme-irreke. Yanhe-ngentyele re atere anthurre irreke iwenhenge apeke. ");
INSERT INTO aer_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","YAHWEH anteme ikwere angkeke, “Ampe ngkwinhe areye, ampe arrpenhe areye-arlke, ampe arrpe-anenhe, itne-arle ipenye-arle anetyenhe apmere arrpenhe ikwerele. Tyerrtye apmere yanhe-arenye areye-arle ampe ngkwinhe areyeke akngerrepate-arle anetyenhe. Itne-arle itneke ahele-irreme urrkapetyeke uternetyenhenge. Itne kwenhe itnenhe atwerlte-anetyenhe year 400-peleke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Yanhe-ngentyele, urreke-arle The atwirtnemele ahele akngerre areye, itne-arle ampe ngkwinhe areye arnterre urrkapetyeke mpwarewarrerlenge akngerre anthurre ware ante apele. Kele the ampe ngkwinhe areye apmere yanhe-ngentyele tyerremele akngeme. Nhenge itne apmere yanhe imperlenge, itne arne ingkirreke akngerneme arrpenhe nhakwenge areye-kenhe, arne itnekenhe areye, mane itnekenhe-arlke. ");
INSERT INTO aer_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Kele unte Abram, unte pele itethe anetyenhe artwe ampwe-ante irretyeke-atwetye, arrpenhele ngenhe akurne-iletyakenhe. Urreke, arlenge-arlentyele unte akangkentyele ilwetyenhe, ngkwenge-artweyele ngenhe iperteke arteme. ");
INSERT INTO aer_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Lyete apmere nhenhenge Canaan-ele, Amorite areyele akurne akwete-arle irrerlte-anetyenhe. Urrekeke-atwetye The itnenhe impeme, yernetyakenhele. Urreke ampe ngkwinhe areye apmere nhenhe Canaan-werne apetyalperlte-iwetyenge, itne Amorite areye aywepetyenhe, tyerrtye akurne areye.” ");
INSERT INTO aer_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Uterne-arle-irrpekenge anteme, ingwemerte anthurrenge Abram akarre-irreke, re imerte aremele arne atherre amperlenge, anyente ure alepe-arteke-arle aneke arrpenhe akenhe tyampite-arteke kwatye urinpe anthurre-arle irremenge. Arne ratherre mpwepe-werne-irreke kere akerte arratyenge mpwepele. ");
INSERT INTO aer_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Kere ikwere-akertele YAHWEH Abram-eke alhileke angkemele, “Apmere nhenhe Egypt-nge ayerrere atheke-arle aneme lhere akngerre ikngerre atheke lhere akngerre Euphrates-werne atheke, The ampe ngkwinhe areye anthetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","21","Tyerrtye arrpe-anenhe apmere nhenhele-arle aneme, nhenge Kenite areye, Kenizzite areye, Kadmonite areye, Hittite areye, Perizzite areye, Rephaimite areye, Amorite areye-arlke, Canaanite areye-arlke, Girgashite areye uthene Jebusite areye-arlke, apmere itnekenhe the itnekenge inemele tyerrtye ngkwinhe areye antheme.” ");
INSERT INTO aer_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","3","Abram aneke year ten-pele anthurreke-atwetye apmere Canaan ikwerele. Anewe ikwerenhe Sarai arritnye aneke, re ampeke arrangkwe akwete aneke, arrangkwe anteye. Arelhe arrpenhe aneke apmere Egypt-arenye Hagar arritnye re Sarai-ke urrkapeme. Urreke Sarai alheke Abram-werne ikwere angkemele, “YAHWEH-ele kwenhe ayenge ayakeke ampe atnyeneketye, ayenge kwenhe ampeke arrangkwe akwete aneme. Hagar-werne alhaye, mpwele interretyeke apurte. Re apeke ngkwenge ampe atnyenetyeke, kele ampe renhe ayenge anthaye the amangkelhe-iletyeke atyenge-arrpe.” Kele Abram re alheke arelhe arrpenhe Hagar ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Kele, Abram uthene Hagar uthene ratherre apurte inteke. Yanhe-ngentyele, Hagar re atnerte-atnerte anteme irreke ikwerenge. Re arelheke anteme rarle atnerte-atnerte anteme irreke, re itelarelheke rarle akwele Sarai-nge awethe mwerre ulkere anthurre akwele aneke re akangkeke anthurre. Kele re Sarai arelhe ampwe renhe arrkentye anthurre ileke. Sarai re ahele anthurre awelheke Hagar-arle renhe arrkentye ilekenge. ");
INSERT INTO aer_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Kele, Sarai re alheke Abram-werne, re anteme ikwere ahele angkeke, “Re ayenge areme arelhe ampwe, re ayenge arrkentye ilemele atherrele ileme ayenge-arle ampeke arrangkwe anemenge. Ngkwenge-ngentyele akwele re ayenge arrkentye ileme. The ngenhe renhe antheke. Atyenge ratherre anemele anteme ayenge arrkentye ilemele ayenge akwetethe kele re itelarelheme rarle atnerte-atnerte aneme. Ayenge apeke-arle akurne-irreke apale alhemele YAHWEH-ketye, unte apeke-arle apale alheke ikwere-ketye. Ayenge akutne! Akarelhetyeke YAHWEH-eke angwenhe-arle ikwere mwerre anemeke.” ");
INSERT INTO aer_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abram anteme Sarai-ke angkirtneke, “Re kwenhe ngkwenge urrkapentye akngerre. Nthakenhe apeke renhe ilaye!” Kele, Sarai re anteme ahele alheke Hagar-werne, re renhe tnyante atweke. Yanhe-ngentyele, atweke-arle ipenhe, Hagar alwirremele unteke Abram utheneke-artweye areye-ketyenge. ");
INSERT INTO aer_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Sarai-le-arle renhe tnyante atweke ipenhe, Hagar iwerre ahurratyele alhemele apmere Shur-werne-atheke. Iwerre itwele re kwatye ngentye aretye-alheke. Ikwerele anteme re anetyame apurrke anthurre. YAHWEH-ele alkere-arenye ikwere-werne yerneke. ");
INSERT INTO aer_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Alkere-arenyele areke Hagar renhe imerte ikwere alakenhe angkemele, “Hagar, unte urrkapentye akngerre marle Sarai-kenhe. Nthenhenge-ame unte apetyeke, nthenhe-werne-ame unte alheme?” Hagar utnenge alkere-arenye ikwere angkirtnerlenge, “Ayenge-arle alwirremele alheme akngerrepate atyinhe-ketye rarle atyenge ahele-irremenge.” ");
INSERT INTO aer_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Alkere-arenye re awethe Hagar ikwere angkeke, “Akngerrepate ngkwinhe-werne alpaye urrkapemele mpwaraye iwenhe apeke-arle ngenhe ileme, kele mpware ante akiwarre-irretyale. ");
INSERT INTO aer_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","The ngenhe ampe atningke anthurre antheme, angwenhele-ame itnenhe alkngele anyente-ame-anyente areme? ");
INSERT INTO aer_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ayenge awaye, unte kwenhe kele atnerte-atnerte anteme, urreke unte ampe urreye akweke atnyenetyenhe. Unte renhe Ishmael arritnye anthetyeke nhenge YAHWEH-ele itelareke akngerrepate ngkwinhe ngkwenge ahentye anetyakenhe, re ngenhe artnerlenge aweke. ");
INSERT INTO aer_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Ampe ngkwinhe lterrke anetyenhe, atwentye akngerre tangkeye-arteke anetyenhe. Re amangkemele, re alhetyeke ahentye re alheme nthenhe apeke. Re unthemele, angwenhele renhe uternetyeke arrangkwele. Rarle tyerrtye areye atweme akwete anetyenhe, arrpenhe areyele renhe atwirtnetyenhe anteye. Re ikwere-artweye areye-ketye arlenge ulkere anepanetyenhe.” Alakenhe-arle Hagar-eke angkeke utnenge alkere-arenye re. ");
INSERT INTO aer_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Yanhe-ngentyele, Hagar re ikwere-arrpe angkeke, “The-ame arratye Ngkarte areke?” Yanhe-ngentyele, Hagar-ele YAHWEH arritnye antheke “El-Roi,” alakenhe ileme “YAHWEH-ele ayenge areme.” ");
INSERT INTO aer_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Nhenhe ikwerenge anteme, tyerrtye areyele iletyarte kwatye ngentye renhe Beer-lahai-roi, alakenhe ileme “kwatye ngentye Ngkarte-kenhe, Rarle thewe ayenge areme.” Ngentye re aneke apmere ratherre mpwepele apmere ratherre Kadesh uthene Bered uthene arritnye anerle-anerreke. ");
INSERT INTO aer_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Kele Hagar YAHWEH-eke akangkwe-irremele alpeke akngerrepate ikwerenhe-werne. Yanhenge, ikwerenge anteme Hagar-ele ampe akweke atnyeneke urreye akweke Ngkartele-arle ileke-arteke. Re Abram antheke, Abram-ele ampe akweke renhe arritnye anthetyenhenge re anteme renhe arritnye antheke urreye akweke renhe Ishmael. ");
INSERT INTO aer_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Abram kwenhe artwe ampwe aneke year 86-pele aneke nhenge Ishmael-arle intekenge. ");
INSERT INTO aer_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Ikwere iperre Abram year 99-pele anteme aneke, YAHWEH ikwere awethe arrateke imerte awethe ikwere angkemele, “Ayenge-arle LTERRKE ANTHURRE-ARLE, tyerrtye areyele-arle El-Shaddai ilepileme! Angkentye Atyinhenge ularre mwerrentye aneme, Ayenge akwetethe apentemele apale alhetyale. ");
INSERT INTO aer_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ayenge uternelheme ngkwenge-artweye atningke anthurre-arle anthetyeke. The mpwaretyenhe iwenhe apeke renhe alhilemele.” ");
INSERT INTO aer_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Nhenge Abram-ele aweke Ngkarte angkerlenge, re amperele-arlenge tneke ikwere, urlele imerte ahelhe anpemele. Ngkarte imerte ikwere alakenhe angkemele, ");
INSERT INTO aer_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Lyete ayenge ngkwenge uternelheme. Unte kwenhe akngeye anetyenhe tyerrtye atningke areyeke apmere arrpe-anenhele. The mpwaretyenhe iwenhe apeke renhe alhilemele. ");
INSERT INTO aer_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Arlte lyetenge anteme, arritnye ngkwinhe-arle Abram anetyakenhe-arle. The arritnye arrpenhe antheme anteme Abraham, Tharle ngenhe akngeye atningke-kenhe anteme-arle mpwareme apmere arrpe-anenhele. ");
INSERT INTO aer_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Tyerrtye apmere arrpe-anenhele ngenhe akngeye iletyenhe, King arrpe-anenhe-arlke angwenhe anetyenhe ngkwenge-ngentyele. ");
INSERT INTO aer_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Akwete-ante Ayenge angkeme arratye alhilentye atnyenemele, ngkwenge-arlke tyerrtye ngkwinhe areyeke-arlke. Lyete Ayenge ngkwenge Ngkarte aneme, yanhenge ayenge ngkwenge akwerrke areyeke Ngkarte anetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","The anteme ngkwenge-artweye areye-arlke apmere nhenhe Canaan anthetyenhe, nthenhele-arle unte-arle lyete ipenye aneme. Apmere nhenhe-arle ngkwenge akwete-ante-arle ngkwenge akwerrke areyeke-arlke, Ayenge Ngkarte itneke akwete-arle anerle-aneme.” ");
INSERT INTO aer_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","10","Ngkarte awethe Abraham-eke angkeke, “Abraham, unte kwenhe Ayenge akwete-ante apentetyeke Atyenge akwetethe akangkwe-irrerle-anemele The ngenhe ilerlenge unte-arlke ngkwenge akwerrke areyele-arlke Ayenge akwetethe apentetyeke. Arrantherre arrekantherrenhe artwe areye artwe-iletyeke kwenhe, ingkirreke anthurre. ");
INSERT INTO aer_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Kele The areme arrantherre apeke-arle artwe arrekantherrenhe artwe-irrekenge, kele The apeke arrenhantherrenhe areme mpwarerlenge Tharle arrenhantherrenhe ileke. Kele The itelareme arrantherre-arle nhenge areye akngaketyenhe Ayenge apentetyeke. ");
INSERT INTO aer_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","13","Nhenhe apele angkentye Atyinhe-arle. Lyete nhenge ampe urreye akweke intemele, kele unte renhe artwe-iletyeke week anyentenge iperrele. Urrkapentye akngerre arrekantherrenhe areye apmere arrekantherrenhenge-arle inteke areye-arlke, iparrpe itnenhe artwe-iletyeke, urrkapentye akngerre arrpenhe areye-arlke apmere arrpenheke-arle arrantherre ineke areye-arlke, itnenhe-arlke iparrpe artwe-ilemele. Nhenge The aremele arrekantherre-artweye uthene urrkapentye akngerre areye uthene artwe-irreke-arle, kele The itelareme arrantherre-arle nhenge areye akngakemele Ayenge apentetyeke. ");
INSERT INTO aer_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Angwenhele apeke arrenhantherrenhe ayakemele itnenhe artwe-ileketye, itne-arle angkentye Atyinhe-arle ultakeme. Alakenhe ikwerenge anteme, itnenhe aywepaye arrekantherrenhe areye-ketye.” ");
INSERT INTO aer_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Kele Ngkarte awethe angkeke Abraham-eke, “Kele ngkwenge anewe, The renhe arritnye akngarte-iweme. Renhe unte Sarai awethe iletyale. Lyete-ngentyele unte renhe arritnye arrpenhe anthetyeke renhe Sarah akemele. ");
INSERT INTO aer_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","The renhe arntarnte-areme ikwere akangkemele aneme, The renhe urreye akweke-arle antheme. Tyerrtye arrpenhe areyele renhe meye akeme, atningke apmere arrpe-anenhe-kenhele, King atningke anetyenhe apmere arrpenhe atningke-arenye ikwere akwerrke areye-kenhe.” ");
INSERT INTO aer_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Nhenge re aweke Ngkarte alakenhe angkerlenge, Abraham amperele-arlenge tneke, re imerte arrkene atherremele ikwere-arrpe. Imerte ikwere-arrpe angkemele, “Ayenge kwenhe year 100 pele aneme. Kele atyenge anewe re akenhe year 90-arle. Nthakenhe-ame ilerne, artwe ampwe uthene arelhe ampwe uthenele ampe atnyenetyeke?” ");
INSERT INTO aer_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Kele, Abraham-ele Ngkarte apayuthneke, “Atyenge alere Ishmael, renheke-amparre akngakaye, unte renhe ampe anthetyenhenge apmere-arlke.” ");
INSERT INTO aer_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Ngkarte Abraham-eke angkirtnerlenge, “Arrangkwe, The Ishmael akngaketyeke arrangkwe-arle arne ngkwinhe areye anthetyeke. Arratye-arle anewe ngkwinhe arrekwelenye-arle Sarah, re kwenhe ampe urreye akweke atnyenetyenhe anteye. Unte renhe Isaac arritnye anthetyeke. The alere yanhe akngakeme ampe atningke atnyenetyeke, renhe-ante ware the angkentye Atyinhe anthemele ileme akwete-ante. Ayenge-arle ikwere alkngwirretyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","“Kele ngkwenge alere Ishmael-arle, The ngenhe aweke-arle angkerlenge. Yewe, The renhe lterrke ilemele arntarnte-aremele, re ampe atningke atnyenetyenhe atyengenge ularre. Tharle renhe urreye 12-pele anthurre-arle anthetyenhe. Itne-arle tyerrtye atningkeke-arlke itneke akwerrke areyeke-arlke akngerrepate anetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Urreke year anyentenge iperre, Sarah-ele ampe urreye akweke renhe atnyenemele, ikwere-ante ware ayenge yewe angkeme. Kele-arle ayenge ngkwenge angkeke.” ");
INSERT INTO aer_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Kele-arle Ngkarte angkeke iperre, Re Abraham imperle-alheke. ");
INSERT INTO aer_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Ngkarte-arle akertne alpekenge anteme, Abraham-ele ikwere-artweyeke uthene urrkapentye akngerre ikwerenhe areye Ishmael urreye akweke nhenge-arlke. Yanhe anthurrenge, Ishmael-eke-amparre re artwe-ileke, arrpenhe ingkirreke anthurre anteme re artwe-ileke. ");
INSERT INTO aer_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","27","Arlte anyentele itne ingkirreke artwe-irreke. Abraham aneke year 99-pele anteme, ikwere alere Ishmael year 13-pele aneke. ");
INSERT INTO aer_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Uterne akngerrele angwerrele Abraham anetyame ilthe arriwe altywerele arne ameke-ameke areye Mamre-kenhele itwele, YAHWEH-arle ikwere awethe arratekenge, ");
INSERT INTO aer_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","kenhe re akenhe renhe alhengke-aretyakenhe-arle YAHWEH-arle anekenge, re areke artwe urrpetye ware tnerlenge. Angathele re aremele-arteke ikwere-werne-atheke arnekarnare unteke, inngerre kwene-irremele ahelhe-werne-atheke. ");
INSERT INTO aer_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Imerte angkemele anyenteke, “Akngerrepataye, apmere atyinhe-werne apetyaye the ngenhe arntarnte-aretyeke akangkemele anemele. ");
INSERT INTO aer_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","The arrpenhe ileme ngkwenge kwatye akngetyetyeke unte ingke alhewelhetyeke, kele unte arne ntartengele ankwe intetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","The ngkwenge merne ineye ngenhe lterrke-iletyeke unte alhetyenhenge anteme. Ayenge ngkwenge akangkentye anthurre aneme ngenhe arntarnte-aretyeke unte-arle apmere atyinhe-werne apetyerlenge.” Kele artwe urrpetye itne akangkemele anetyeke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abraham iparrpe alheke ilthe ikwerenhe-werne imerte Sarah-eke angkemele “Iparrpaye! Merne ulpe inaye yakwethe akngerrele-arlenge merne athetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Alakenhe-arle angkeke ipenhe, Abraham unteke pweleke ikwerenhe areye-werne imerte pweleke mwerre anthurre akweke anyente inemele, re imerte anthemele urrkapentye akngerre ikwerenhe areye. Urrkapentye akngerrele iparrpe atweke kele itetyeke anteme. ");
INSERT INTO aer_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Kele kere mpengenge anteme, re yoghurt ineke, werlatye-arlke, kere-arlke, imerte kere-arlke renhe anthemele ipenye itnenhene. Nhenge itne-arle arlkwetyamenge, re arne atnartenge itneke itwele tneke. ");
INSERT INTO aer_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Nhenge itne arlkweke-arle iperrele itne angkeke “Nthenhe-arle-ame ngkwenge anewe?” Abraham angkirtneke, “Re kwenhe yanhe ilthe kwenele.” ");
INSERT INTO aer_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Ipenye anyente urrpetye itnekenge akenhe YAHWEH-arle aneke, re anteme angkeke, “Ayenge apetye-alperlenge alakentyele year-enge, Sarah-ele kele ampe urreye akweke anteme atnyenerlenge.” Kenhe Sarah akenhe Abraham ingkernele-arle aneke, awerle-anemele ilthe arriwe-ngentyele. ");
INSERT INTO aer_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham uthene Sarah atherre kele ampwe ratherre anteme, Sarah kele ampwe anthurre anteme ampe atnyenetyeke. ");
INSERT INTO aer_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Re akenhe atherremele ikwere-arrpe angkerlenge, “Abraham ilerne kwenhe ampwe atherre anteme ilerne kwenhe ampe atnyenetyeke kwenye-arle. Ayenge atyepe-atyepe anetyakenhe aneme.” ");
INSERT INTO aer_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","YAHWEH-ele anteme Abraham apayuthneke, “Iwenheke-arle-ame Sarah atherreke? Iwenheke-arle-ame re apateme ampwele ampe atnyeneketye? ");
INSERT INTO aer_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Ayenge-arle YAHWEH-arle! The arne ingkirreke anthurre mpwarentye akngerre. Nhenge ayenge apetye-alpemele alakentyele year arrpenhe nhakwele, the ilekenge, Sarah-ele kele alakentyele ampe urreye-akerte anteme anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Kele Sarah atere-irremele urrtyirreke, “Ayenge-arle atherretyakenhe-arle.” Kele YAHWEH angkerlenge, “Yanhe-arle arratye anetyakenhe-arle. Unte-arle atherreke-arle!” ");
INSERT INTO aer_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Yanhe-ngentyele, ipenye urrpetye itne alherlte-iweke apmere akertne-werne apmere akngerre Sodom-werne kwene-akerle aretyeke, Abraham itnekenge alheke. ");
INSERT INTO aer_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Nhenge itne-arle alhetyamenge YAHWEH ikwere-arrpe angkeke, “The Abraham-eke ileye nthakenhe-arle The mpwaretyenhe, ");
INSERT INTO aer_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","ikwere akwerrke areye kwenhe akngerre anthurre anetyenhe itnekenge anteme The arne mwerre akngerre mpwaretyenhe tyerrtye arrpe-anenheke apmere nhenhele. ");
INSERT INTO aer_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","The kwenhe renhe akngakeke rarle ikwere akwerrke areye akaltyele-anthetyeke Atyenge akangkwe-irretyeke, Atyenge arratye mpwaretyeke mwerre-arlke anetyeke. Kele The Abraham ikwere atningke antheme, Tharle ikwere arratye ileke-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Kele YAHWEH Abraham-eke angkeke, “Abraham, tharle aweke tyerrtye areye apmere Sodom-arenye uthene Gomorrah-arenye areye-arlke akurne-irrerirremele arne akurne arrpe-anenhe mpwarerlte-aneme. ");
INSERT INTO aer_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Kele The-arrpe anteme aretyeke alheme tyerrtye itnenhe itne akurne apeke-arle itne arratye apeke anemeke. Arrangkwenge apeke itne, Ayenge kele akaltye anetyeke ahentye-aneme.” ");
INSERT INTO aer_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Artwe nhenge atherre alherreke apmere Sodom-werne-atheke. Kenhe YAHWEH akenhe Abraham-enge-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abraham YAHWEH-werne apetyemele ikwere angkemele, “YAHWEH, nhenge unte tyerrtye akurne nhenhe areye atwemele, unte-ame tyerrtye mwerre areye-arlke atwetyenhe? ");
INSERT INTO aer_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Unte-ame apmere yanhe ataketyenhe tyerrtye 50-pele apeke mwerre anerlenge? ");
INSERT INTO aer_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Unte-arle itnenhe atwetyeke arrangkwe-arle Unte tyerrtye arrpenhe akurne itnenhe-ante atwemele. Unte-arle tyerrtye areyeke itirreme nthakenhe itnenhe mpwaretyeke apmere nhenhenge, Unte akenhe kele arratye-iletyeke-arle.” ");
INSERT INTO aer_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","YAHWEH angkirtneke alakenhe, “The apeke tyerrtye mwerre 50-pele areme Sodom-eke, kele The apmere renhe ataketyeke arrangkwe-arle itneke-akertenge.” ");
INSERT INTO aer_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abraham angkirtneke, “Nhenhe ayenge ngkwenge akwenpe anteme angkeme, the ngenhe awethe apayuthneye. Kele ayenge atyene anetyakenhe urlpmernte uthene arlpmenye uthene-arteke kwenhe ngkwengenge ularre. ");
INSERT INTO aer_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Kele apeke tyerrtye mwerre 45-pele ware apeke anerlenge-artaye. Unte-ame tyerrtye ingkirreke apmere ikwere atakemere?” YAHWEH akenhe angkerlenge, “Arrangkwe, Tharle apmere yanhe ataketyeke arrangkwe-arle, The apeke tyerrtye mwerre 45-pele ware aremele.” ");
INSERT INTO aer_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Urrpetye-ngare anteme Abraham angkeke YAHWEH-eke, “Kele tyerrtye mwerre areye apeke 40-pele ware anerlenge-artaye?” YAHWEH alakenhe-arle angkirtnerlenge, “The apmere yanhe ataketyeke arrangkwe-arle, The apeke tyerrtye mwerre 40-pele ware arerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abraham angkeke, “Atyenge ahele-irretyale. YAHWEH, the apeke-arle ngenhe apayuthnemele 30-pele apeke tyerrtye mwerre areye aneke apmere ikwerele.” YAHWEH angkirtneke, “Arrangkwe, Tharle apmere renhe ataketyeke arrangkwe-arle, The apeke tyerrtye mwerre 30-pele ware arerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Kele imerte Abraham angkemele, “Atyenge ahele irretyale, YAHWEH, the apeke ngenhe awethe apayuthnemele unte apeke tyerrtye mwerre 20-pele apeke aretye-alhemele?” YAHWEH angkirtneke, “Arrangkwe, Tharle apmere renhe ataketyeke arrangkwe-arle, The apeke tyerrtye mwerre 20-pele ware arerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abraham awethe angkeke, “Atyenge ahele-irretyale, kele the ngenhe anyente-ngare ware apayuthneye. Unte apeke-arle tyerrtye mwerre 10-pele ware aretye-alheke-artaye apmere ikwere.” YAHWEH angkirtneke, “Arrangkwe, Tharle apmere renhe ataketyeke arrangkwe-arle, The apeke tyerrtye mwerre 10-pele ware arerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Nhenge YAHWEH-arle Abraham-eke angkeke iperre, Re alheke. Abraham anteme apmere ikwerenhe-werne alpeme. ");
INSERT INTO aer_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ingwe ikwerele artwe nhenge atherre apmere Sodom-werne apetye-alherreke. Yanhe ikwerele Lot aneke, apmere Sodom arriwe ikwerele anemele re renhe-atherrenhe areke imerte akeme-irremele, akaperte kwene-irremele rarle itelarekenge ratherre-arle impene anthurre aneme. ");
INSERT INTO aer_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Re angkeke, “Akngerrepate atyinhe atherre, ayenge urrkapentye akngerre mpwele-kenhe. Ayenge akangkemele mpwele apmere atyinhe-werne apetyerlenge. Mpwele ingke alhewelhetyeke, anemele ingwele, ingwenthe akenhe, mpwele akeme-irremele imerte alhemele.” Kele ratherre ikwere angkerle-anerrerlenge, “Arrangkwe, ilerne apmere akethele inteme, apmere tyerrtye areye-arle apurte irrepirreme ikwerele.” ");
INSERT INTO aer_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Kenhe Lot re akenhe akwete angkeke ratherre apmere-werne alpetyeke-atwetye. Kele ratherre Lot-kenhe apmereke irreke-arle re merne mpwareke, merne arlware-ilentye akngerre-kwenye-akerte, kere-arlke iteke, itne apurtele anteme arlkweke. ");
INSERT INTO aer_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Urreke-arle Lot uthene ayeye ilenhe-ilenhe ratherre-arlke ankwe-irretyenhenge, artwe arrpe-anenhe Sodom-arenye, ingkernenye ampwe-arlke, apetyeke apmere ikwerenhe akethele tnerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Imerte arlkerrirremele, “Ipenye ngkwinhe atherre-artaye? Akethe-werne yernaye, anwerne itnenhe anyetyenhenge!” ");
INSERT INTO aer_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Lot re akethe-werne alhemele arriwe marteke. ");
INSERT INTO aer_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Re anteme itneke angkeke, “Atyewe areye-aye, akurne alakenhe mpwaretyalaye! ");
INSERT INTO aer_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Arelhe awenke atherre atyinhe aneme artwenge-arle intetyakenhe arrekwelenge. The renhe-atherrenhe akethe-werne akngetyetyenhe, arrantherre imerte nthakenhe apeke re irremele ikwere-atherre. Kele artwe yanhe atherre impetyeke atherre-arle apmere atyinhe-werne-arle apetyerlenge the renhe-atherrenhe arntarnte-arle-areme.” ");
INSERT INTO aer_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tyerrtye areye itne akenhe angkirtnerlenge, “Anwerneke arrkngerte tnetyale! Unte apele itepe-iperre. Unte anteme akwele anwerne iletyeke nthakenhe irretyeke! Anwerne ngkwenge akurne awethe arntwarre anthurre mpwaretyeke itneke-arle anwerne mpwaretyenhe.” Tyerrtye areye Lot-eke akwete ahele-irreke. Kele arratye ante, itne Lot ankerte-iwemele arriwe-werne atheke unterlte-iweke ultaketyeke akwele. ");
INSERT INTO aer_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Kele artwe atherre apmere kwenele-arle anerle-anerreke-arle Lot renhe tyarre-inerle-anerreke, imerte apmere kweneke arrernemele, arriwe imerte martemele. ");
INSERT INTO aer_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ratherre imerte artwe arrpe-anenhe renhe pwenge ilerle-anerremele, itne apele arriweke uyarne unthemele irreke. ");
INSERT INTO aer_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","13","Artwe atherre imerte Lot-eke angkemele, “YAHWEH-elarle arne akurne areye aweke-arle tyerrtye Sodom-arenye areye-akerte, re anteme ilernenhe yerneke apmere renhe akethe ante arrernetyeke. Ngkwenge-artweye areye, ngkwenge akwerrke areye-arlke apmere nhenhenge-ntyele akngaye. Ingkirreke anthurre ngkwinhe areye apmere nhenhele-arle aneme, awenke-arlke, apmerrke-arlke, arelhe ngkwinhe, alere areyele-arle anewe aketyenhe areye-arlke.” ");
INSERT INTO aer_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Lot imerte alhemele artwe arelhe awenke ikwerenhe atherreke-arle anewe aketyenhe-werne imerte angkemele, “Iparrpaye nhenhenge arratetyekaye! YAHWEH-ele kwenhe apmere nhenhe ataketyenhe.” Kenhe itne akenhe itirrerlenge arrkene-arle akwele re angkeke, imerte tnyante atherremele. ");
INSERT INTO aer_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Arlte arrpenhele artwe atherre Lot athekelhe-ileke iparrpe irretyeke. Ratherre angkeke, “Iparrpaye ngkwenge anewe uthene marle awenke ngkwinhe atherre-arlke-akerte imerte arratemele alhemele nhenhenge-ntyele! Arrangkwenge apeke, YAHWEH-ele arrenhantherrenhe ingkirreke anteye atweme apmere nhenhe re atakerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Arrekwele, Lot ware tnetyame yanhe ikwerele. Kele YAHWEH-ele renhe itetheke mpwaretyeke ahentye-aneke. Kele artwe atherrele Lot akngeke, anewe ikwerenhe-arlke, ikwerenhe awenke atherre-arlke iltyele inemele apmere ikwerenge-ntyele. ");
INSERT INTO aer_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Kele itne arntwarre anteme irreke kele apmere yanhe akethele anteme, artwe atherre angkeke, “Iparrpaye, untaye alkngarelhetyale. Apwerte atwatye-arlke ngkernelhetyale. Apwerte-werne atheke untaye, unte-arle mwerre anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","19","Lot angkirtneke alakenhe, “Unte kwenhe anwerneke mwerre anthurre aneke. Unte kwenhe anwerne itethe-ileke, kele anwernenhe apwerte-apwerte-werne yernetyalaye. Apmere yanhe arntwarre anthurre-eyaye, kele YAHWEH-ele anwerne-arle urreke arrernelhetyenhenge akwete apmere renhe ataketyeke, kele anwerne ilwemele. ");
INSERT INTO aer_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Apmere arrpenhe akweke-arle angathe yanhe unte apeke anwernenhe yanhe-werne yerneme kele anwerne kele mwerre-arle aneme.” ");
INSERT INTO aer_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Kele re angkirtneke, “Kele, apmere yanhe ikwere-werne alhaye, tharle apmere renhe ataketyeke arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Iparrpaye, untaye! Kele the awethe mpwaretyeke arrangkwe-arle arrantherre nhakweke irretyeke-atwetye.” Apmere yanhe arritnye aneke Zoar anteme Lot-arle ileke apmere akwekenge akwele. ");
INSERT INTO aer_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Uterne kele arrateke anteme Lot-arle apmere akweke Zoar ikwere-irrekenge anteme. ");
INSERT INTO aer_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Kele YAHWEH-ele yerneke arne sulphur amperlenge kwatye-arteke alkerenge Sodom uthene Gomorrah uthene-werne. ");
INSERT INTO aer_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Re apmere renhe-atherrenhe atakeke tyerrtye areye apmere ikwerele aneke areye-arlke, apmere ahelhe itnekenhe-arlke, arne-arlke, atherrke-arlke lyapekeke-arle. ");
INSERT INTO aer_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Kenhe anewikwe Lot-kenhe renhe-arle apenteke alkngarelheke apmere ikwere-werne kele re ilweke yanhe ikwere, Ngkartele renhe apirnte-werne akngarte-iweke ingkwepeye arlpentye-arteke tnerlenge. ");
INSERT INTO aer_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Ingweleme anyente ikwerele anteme Abraham akeme-irreke apmere-werne alhemele nthenhele-arle re tneke-arle YAHWEH-eke angkemele. ");
INSERT INTO aer_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Re akertnenge kwene-werne areke Sodom uthene Gomorrah uthene-werne atheke imerte aremele ure rerrke akngerre-arteke, apmere arrpe-anenhenge akwerte arraterlenge. ");
INSERT INTO aer_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Nhenge Ngkartele atakerlenge apmere yanhe atherre apwerte atwatyele-arle nhenge Lot-arle anetyarte, Re itelareke rarle Abraham-eke angkeke Lot arntarnte-aremele ure akurne akngerre ikwere-ketye. ");
INSERT INTO aer_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Ikwerenge anteme, Lot uthene marle awenke ikwerenhe atherre apwerte akertne-werne alheke rarle atere-irrekenge apmere Zoar ikwerele anetyeke. Itne apurte anerrirretyarte inteye kwenele. ");
INSERT INTO aer_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Arlte anyentele anteme marle akngerre atyeye ikwerenheke alakenhe angkeke, “Ilerneke-artweye kwenhe ampwe anthurre anteme, artweke-arlke kwenye ilerneke arrangkwe anewe akemele ampe atnyenetyeke. ");
INSERT INTO aer_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Ilerneke-artweye ngkwarlele arerte-iletyeke-aye! Kele ikwerenge intetyenhenge atnerte-atnerte-irretyenhe ampe atnyenetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Ingwe ikwerele ratherre ikwere-atherre-artweye ngkwarlele arerte-ileke, marle akngerrepate ikwere iwelheke antyameke. Kenhe re akenhe itelaretyakenhenge rarle ikwerenge iwelhekenge aneke akeme-irremele. ");
INSERT INTO aer_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Arlte arrpenhele marle akngerre re angkeke atyeyikwe ikwerenheke angkeke, “Ayenge-arle atyenge-artweyenge-arle ingwele inteke. Renhe awethe ngkwarlele arerte-ileye lyete ingwele, unte anteme ikwerenge iwelhetyeke intetyenhenge, ilerne apurtele ampe atnyenetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Ingwe ikwerele ratherre ikwere-atherre-artweye ngkwarlele awethe arerte-ileke, kele imerte marle ingkernenye anteme ikwerenge inteke. Awethe re itelaretyakenhe aneke re kwenhe irrkaye-irrkaye-irremele ngkwarle iperrenge. ");
INSERT INTO aer_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Alakenhenge-arle marle awenke Lot-kenhe atherrele ampe urreye atherre atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Marle akngerrepate ampe urreye ikwere Moab arritnye antheke, kele re akenhe Moab-arenye areyeke-artweye-arle. ");
INSERT INTO aer_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Marle ingkernenyele akenhe ikwere ampe urreye Ben-Ammi-arle arritnye antheke, re akenhe Ammonite areyeke-artweye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abraham apmere yanhe imperle-alhemele alheke antekerre-werne re apmere arrangkethe Negev-werne, rarle anetye-alpeke-werne Kadesh uthene Shur uthene mpwepele. Yanhenge re alheke anteme apmere Gerar-werne. ");
INSERT INTO aer_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Nhenge rarle yanhele anemele re tyerrtye areyeke ileke anewikwe-arle Sarah-arle, re akwele yaye ikwerenhe. Kenhe Akngerrepate Abimelech Gerar-arenyele Sarah ineke apmere akngerre ikwerenhe-werne akngemele. ");
INSERT INTO aer_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Kenhe Ngkarte akenhe Abimelech-eke altyerrenge-arle apetyerlenge imerte ikwere angkemele, “Awaye! Unte kwenhe ilwetyenhe arelhe unte-arle ineke yanhe kwenhe kele anewe-akerte.” ");
INSERT INTO aer_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","5","Kenhe Abimelech akenhe ikwerenge intetyakenhe-arle Ngkarteke angkeke, “Ayenge atwetyale! Ayenge-arle Sarah-enge intetyakenhe-arle. Abraham-elarle ileke rarle akwele yaye ikwerenhe, kenhe re-arlke angkeke Abraham akwele kake ikwerenhe. Ayenge-arle akurne irretyeke kwenye-arle aneke, ayenge-arle itirreke apele mwerreke-athene.” ");
INSERT INTO aer_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Ngkarte Abimelech-eke angkeke altyerre arrpenhenge: “Kele The itelareme unte mwerre akwele mpwaremeke-athene. Alakenhenge akwele The ngenhe ayakeke Sarah-enge inteme-ketyenge akurne-arlke irreme-ketye. ");
INSERT INTO aer_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Kele arelhe yanhe ikwere anewe-werne iparrpe yernirtnaye rarle kwenhe Atyenge angkemenge, re kwenhe Atyenge angketyenhe ngkwenge arrkngente angketyenhe-arlke. Kele, unte apeke renhe ikwere anewe anthirtnetyakenhe, kele unte ngkwenge-artweye areye-arlke ilwerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Ingweleme anteme Abimelech re akeme-irreke-arle urrkapentye ikwerenhe areyeke antangkemele, re anteme itnenhe ileke nthakenhe-arle-irreke altyerre ikwerenhenge kele itne atere-arle-irrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abimelech imerte Abraham-eke anteme antangkelhemele apetyetyeke: “Araye unte-arle anwerneke mpwareke! Ayenge-arle ngkwenge akurne irretyakenhe-arle. Ngkarte anteme ahentye-aneme atyenge akurne mpwaretyeke tyerrtye atyinhe areye-arlke ngkwenge-ngentyele ware. ");
INSERT INTO aer_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Nthakenhe-ame unte itirreke ngkwenge anewe-akerte urrtyirremele?” ");
INSERT INTO aer_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abraham angkirtnerlenge: “Ayenge urrtyirreke ayenge-arle itirrekenge tyerrtye areye Ngkarteke akangkwe-irretyakenhe apmere nhenhele, ayenge itirreke arrpenhele ayenge-arle atwerrirretyenheke anewe atyinhe inetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Kele, arratye-arle akenhe. Re kwenhe arratye yaye atyinhe. Akngeye ilerne-kenhe anyente aneme, meye ilerne-kenhe akenhe arrpenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Ngkartele ayenge ileke apmere akngeye atyinhe-kenhe impemele alhetyeke unthemele, the renhe ileke, ‘Unte apeke atyenge arratye ahentye-aneme unte tyerrtye arrpenhe areyeke iletyeke ayenge atyeye ngkwinhe-arle.’” ");
INSERT INTO aer_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abimelech-ele anteme Abraham yepe-yepe areye antheke, pweleke-arlke, urreye uthene marle uthene urrkapentye akngerre areye-arlke. Re Sarah yernirtneke ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abimelech-ele Abraham ileke re apmere arerle-anetyeke apmere nthenhele-arle re anetyeke ahentye-aneme. ");
INSERT INTO aer_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Re anteme Sarah-eke alakenhe angkeke, “The atyeye ngkwinhe antheke ngkweltye silver 1000-pele anthurre tyerrtye areyeke imernemele unte-arle akurne-irretyakenhe-arle.” ");
INSERT INTO aer_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Kele Ngkartele ayakeke anewe Abimelech-kenhe-arlke urrkapentye akngerre ikwerenhe areye-arlke ampe atnyeneme-ketye Abimelech-elarle Sarah inekenge, anewe Abraham-kenhe. Kele Abraham-ele Ngkarte apayuthneke Abimelech mwerre-iletyeke itne anteme ampe anteme atnyenewarretyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","YAHWEH-arle mwerre-arle aneke Sarah-eke rarle angkentye ikwerenhe atnyeneke-arle. Rarle mpwareke Rarle angkeke-arteke akwete-arle. ");
INSERT INTO aer_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Kele Abraham ampwe anthurre anteye nhenge aneke, Sarah-ele ampe urreye atnyeneke YAHWEH-elarle ileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abraham-ele alere ikwerenhe Isaac arritnye antheke, nhenge arritnye re ileme “rarle atherreme-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Week anyentenge urreye akweke nhenge inteke-arle-iperre, Abraham-ele akweke renhe artwe-ileke angkentye itnekenhenge ularre, YAHWEH-elarle ileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Abraham akenhe year 100 apele-arle aneke Isaac-arle intekenge, ");
INSERT INTO aer_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Sarah imerte angkemele, “Ngkartele ayenge atherretyeke mpwareke. Kele tyerrtye areyele alakenhe-akerte awemele itne atyenge atherretyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Kele imerte re angkemele, “Angwenhele apeke-ame itelaremere tharle Abraham-eke ampe atnyenetyenhe. Kele the akenhe ampe antheke-arle artwe ampwe apeke ikwere.” ");
INSERT INTO aer_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Kele Isaac akngerre anteme irreke mikwekenge werlatye impelhemele anteme, arlte ikwerele anteme Abraham-ele merne akngerre iteke itne apurtele anteme arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","10","Nhenge tyerrtye areyele-arle akangkemele merne arlkwetyamenge apurtele, Sarah-ele areke ampe Hagar-kenhe Ishmael, Isaac-enge arrkene-irrerlenge. Re imerte Abraham-eke angkeke, “Unte kwenhe arelhe urrkapentye akngerre Egypt-arenye ampe urreye yanhe-kenhe uthene aywepetyeke! Ayenge ikwere ahentye-anetyakenhe arne ngkwinhe areye inetyeke, ayenge Isaac-eke ahentye-aneme arne ngkwinhe areye inetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Abraham-ele nhenhe awemele re akngerre itirreke Ishmael-eke. ");
INSERT INTO aer_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Kenhe Ngkarte akenhe Abraham-eke angkerlenge, “Abraham, itirretyale urrkapentye akngerre arelhe ngkwinheke urreye akweke yanheke-arlke. Kele mpwaraye iwenhe apeke renhe Sarah-ele ngenhe ileke, Isaac-enge-arle tyerrtye atningke irretyenhenge tharle ngenhe alhileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Kele, urrkapentye akngerre yanheke ampe urreye-arle ngkwenge alere-arlke-arle, kele the ikwere akwerrke areye akngerre atningke anthurre ileme.” ");
INSERT INTO aer_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Ingwe-athnele arrpenhele Abraham-ele Hagar antheke yakwethe kwatye-akerte, merne-arlke, re ikwere-arleke pwerlepeke utyernemele. Re anteme renhe urreye ikwerenhe-akerte yerneke. Ratherre apmere ahurratyele untherle-anerretyeke apmere Beersheba itwele. ");
INSERT INTO aer_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yanhe-ngentyele ratherre kwatyeke arrangkwe irreke, Hagar-ele anteme ikwere ampe ulyeke arrerneke. Re itirreke akweke rarle akwele ilwetyenheke arne artnartenge ikwere merne-arlke kwatye-arlke arrangkwenge akwele. ");
INSERT INTO aer_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Kele re aneke arntwarre anthurrele, rarle ahentye-anetyakenhe akweke renhe ilwerlenge aretyeke. Re imerte tnyante artnemele irrare anthurre anekenge. ");
INSERT INTO aer_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Nhenge Ngkartele urreye akweke renhe artnerlenge aweke, alkere-arenye Ngkarte-kenhe Hagar-eke arlkeke alkere akertne-ngentyele imerte angkemele, “Hagar, iwenheke-ame unte arnterre itirreme? Atere-irretyalaye. The kwenhe aweke ampe urreye ngkwinhe artnerlenge. ");
INSERT INTO aer_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Renhe akemelhe-ilaye iltye arntwirrkemele, The kwenhe renhe akngerreke-artweye iletyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Kele Ngkartele anteme ikwere kwatye iperte imerneke itwele-arle aneme. Re anteme alheke kwatye iperte ikwere-werne yakwetheke kwatye akngerre theleke, imerte ampe urreye ikwerenhe anthemele antywetyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Ngkarte kwenhe mwerre anthurre Ishmael-eke aneke renhe mwerrantye-arlke arntarnte-aremele re amangkerlenge anteme. Rarle amangkemele artwe akweke re ilyernpenye anthurre anteme kere atwetyeke. Re anetyarte apmere ahurratye Paran arritnyele, mikwele-arle anteme arelhe awenke ikwere ineke Egypt-nge re anewe aketyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Abraham-arle apmere antekerrele akwete aneke apmere Canaan-ele, Abimelech uthene akngerrepate thultye ikwerenhe areye-kenhe Phicol apetyeke Abraham-werne imerte angkemele, “Ngkarte-arle ngkwengenge akwetethe aneme ngenhe arntarnte-aremele unte-arle mwantyele-arlke mwerrantye-arlke mpwarerle-anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Kele ayenge ngkwenge ahentye-aneme atyenge uternelhetyeke unte-arle atyenge akwetethe mwerre anetyeke atyenge-artweye areyeke-arlke, ayenge-arle ngkwenge mwerre anetyarte-arteke apmere nhenhele ipenye-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Kele yanhenge, Abraham ikwere uternelheke re itneke mwerre anerle-anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abraham ahele angketyame Abimelech-eke, urrkapentye akngerre Abimelech-kenhe areye ahele-irrerlenge itnenhe ayakeke kwatye ngentye-werne apetyeme-ketye, Abraham-elarle tnyekenge. Re Abimelech-eke angkeke, “Urrkapentye akngerre ngkwinhe areyele anwerne kwatye ngentye anyente apetyewarreme-ketye ayakeke.” ");
INSERT INTO aer_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Kenhe Abimelech akenhe alakenhe angkirtnerlenge, “The kwenhe nhenhe lyete-ante aweme, iwenhenge-ame unte arrekwele angketyakenhe? Tharle itelaretyakenhe angwenhele-arle alakenhe mpwareke.” ");
INSERT INTO aer_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Abraham-ele Abimelech antheke yepe-yepe uthene pweleke-arlke, kele ratherre ipeltye-ilerreme ahele-irreke-arle iperre, apurte anteme-irreke. ");
INSERT INTO aer_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abraham-ele yepe-yepe marle arrpenhe areye akngakeke yepe-yepe ikwerenhe areye-ngentyele, ");
INSERT INTO aer_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Kenhe Abimelech-ele apayuthneke, “Iwenhenge-ame unte yepe-yepe yanhe areye akalkelhe-ileke?” ");
INSERT INTO aer_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abraham-ele renhe ileke, “Ayenge ngkwenge ahentye-aneme yepe-yepe seven-pele nhenhe areye akngetyeke imernetyeke, unte-arle yewe angkekenge tharle kwatye ngentye nhenhe tnyeke.” ");
INSERT INTO aer_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Ratherre anteme apmere renhe Beersheba arritnye antheke anteme, ratherre-arle apurte irremele yewe angkerrekenge ipeltye-ilerreke. ");
INSERT INTO aer_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Kele ratherre-arle ipeltye-ilerreke-arle iperre, Abimelech uthene Phicol nhenge akngerrepate rarle thultye areyeke uthene alperreke apmere Philistia-arenye areye-werne. ");
INSERT INTO aer_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abraham-ele arne irrkepe-arteke ngkerneke apmere Beersheba-le imerte Ngkarte utyernemele tnakeke Ngkarte nhenge akwete-arle anerle-aneme, re renhe arritnye ileme YAHWEH. ");
INSERT INTO aer_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Kele Abraham apmere ikwerele anetyarte arrule anthurreke-atwetye apmere Philistia-arenye areye-kenhele. ");
INSERT INTO aer_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Year arrpe-anenhe ipenhe, kele Isaac apmerrke anteme irrerlenge, Ngkarte ahentye-anemele aretyeke Abraham apeke-arle ikwere akangkwe-irrentye anemeke, ikwere angkeke, “Abraham-aye!” Abraham angkirtneke, “Wertaye?” ");
INSERT INTO aer_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","YAHWEH angkeke, “Isaac inetyeke alhaye, alere ngkwinhe anyente-awerne, unte-arle ikwere-ante ahentye anthurre aneme! Renhe akngaye apmere Moriah arritnye-werne, the ngkwenge apwerte antherrtye akngerre imernetyenhe. Unte yanhe ikwere irremele, Ayenge ngkwenge ahentye-aneme alere ngkwinhe atwetyeke imerte urele itemele apwerte aharleke-arleke. Atyenge nhenhe mpwaraye.” ");
INSERT INTO aer_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Kele Abraham ingwe-athnele akeme-irreke ure atwetyeke. Re saddle arrerneke tangkeye-ke-arleke imerte arnpenhemele Isaac-akerte urrkapentye akngerre ikwerenhe atherre-arlke-akerte apmere Ngkartele-arle renhe ileke ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Arlte urrpetye-iperre Abraham-ele areke arlenge anthurre apmere renhe. ");
INSERT INTO aer_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Re urrkapentye akngerre ikwerenhe atherre ileke, “Nhenhele anerle-anerraye tangkeye-akerte, atyenge alere ilerne-arle alherremenge Ngkarteke utyernemele tnaketyeke. Urreke ilerne apetye-alperretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Kele Abraham-ele ure utyerneke Isaac untyeke-arleke, re akenhe ure aperrke uthene nayepe uthene-arle atnyeneke. Kele ratherre alherremele, ");
INSERT INTO aer_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","8","Isaac anteme angkeke, “Akngeye-aye, ilerne atnyeneme ure aperrke uthene ure arletye uthene atnyeneme ure itetyeke, kenhe nthenhe-arle akenhe yepe-yepe atwetyeke urele itemele apwerte aharleke-arleke itetyeke?” Abraham angkirtneke, “Ngkartele-arle arntarnte-aremele yepe-yepe akwerrke ilernenhe antheme.” Kele ratherre apurte alherreke anteme. ");
INSERT INTO aer_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Kele apmere ikwere ratherre arrernelheke Ngkartele-arle ileke ikwerele, Abraham-ele apwerte areye apurtelhe-ileme, ure akertneke-arleke arrernemele. Yanhe-ngentyele, re ikwere alere arntwirrkemele, ayernemele renhe atheneke ure akertneke-arleke. ");
INSERT INTO aer_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Re anteme nayepe ineke, imerte akertne-ilemele ikwere alere atanthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Kele alkere-arenye YAHWEH-kenhe arlkeke alkere akertne-ngentyele, “Abraham! Abraham!” Re angkirtneke, “Kweye!” ");
INSERT INTO aer_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Kele utnenge alkere-arenye ikwere angkeke, “Urreye yanhe atwetyalaye, renhe atwetyale anetyeke! Kele lyete the arratye itelareme unte Ngkarteke akangkwe-irreme, unte kwenhe ngkwenge alere anyente renhe impene atwetyeke aneke.” ");
INSERT INTO aer_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Kele utnenge alkere-arenye rarle angkeke-arteke, Abraham-ele atnyenemele imerte yepe-yepe urreye aremele rulye-rulye ikwerenhenge-arle mwernelheke arne alarteke-arleke. Re alheke imerte yepe-yepe renhe inemele imerte atwemele ikwere alere impemele. ");
INSERT INTO aer_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Abraham-ele anteme apmere renhe arritnye antheke, “YAHWEH-ele ilernenhe antheme iwenhe apeke ikwere ilerne ahentye-aneme.” Lyete-arlke anteme tyerrtye areye angkeme, “Apwerte YAHWEH-kenhe anwerne antheme.” ");
INSERT INTO aer_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Kele alkere-arenye YAHWEH-kenhe arlkeke awethe anteme alkere akertne-ngentyele: ");
INSERT INTO aer_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","“YAHWEH-ele ngkwenge nhenhe alhilentye impene mwerre ngenhe mpwaretyeke unte-arle ngkwenge alere anyente-awerne akwenpele anthetyeke anekenge: ");
INSERT INTO aer_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","‘Tharle ngenhe arne mwerre atningke antherle-anetyenhe. Ayenge ngkwenge mwerre anthurre anerle-anetyenhe artweyenhenge areye atningke anthurre anthemele, kele yanhenge anteme unte akngerreke-artweye aneme kwerralye alkere anemenge-arlke irntwarre, yerre areye-arteke anemenge irntwarre anthurre. Itne atwerretyenhe tyerrtye apmere arrpenhe-arenye areyenge, itne apmere itnekenhe-arlke inemele arrpenhe areye anepanetyarte. ");
INSERT INTO aer_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Kenhe tyerrtye ingkirreke apmere ahelhe nhenhe-arenyele ayenge apayuthnetyenhe itneke arne mwerre areye mpwaretyeke, the ngkwinheke-artweye areye mwerre mpwareke-arteke. The nhenhe itneke mpwaretyeke, unte-arle atyenge akangkwe-irrerlenge.’” ");
INSERT INTO aer_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Yanhe-ngentyele, Abraham alpeke urrkapentye akngerre nhenge atherre-werne itne-arle apurte apetyeke, itne apurte anteme alperlte-iweke apmere Abraham-kenhe-werne Beersheba-le. ");
INSERT INTO aer_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","23","Kake Abraham-kenhe Nahor-ele anewe-akeke Milcah, urreke ikwerenge-ntyele tyerrtye anyentele Abraham-eke ileke Milcah-elarle ampe urreye areye atnyeneke. Ratherre urreye eight-pele anthurre atnyeneke. Uz-arle arrekwelenye: Buz anteme, kele Kemuel anteme Aram-eke-artweye-arle irreke: kele ikwere-atherre alere five-pele arrpenhe areye aneke: Chesed, Hazo, Pildash, Jidlaph, Bethuel-arlke rarle Rebekah-kenhe akngeye irreke. ");
INSERT INTO aer_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Kenhe Nahor-ele anewe arrpenhe re akenhe alere four-pele atnyeneke: Tebah, Gaham, Tahash uthene Maacah uthene. ");
INSERT INTO aer_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Nhenge Sarah-arle year 127-pele irrekenge, re ilweke apmere Kiriath-Arba arritnyenge apmere Canaan-ele. Apmere re arritnye arrpenhe Hebron. Abraham irrpenheke ilthe kwene-werne imerte Sarah anewe ikwerenheke tnyante artnemele ilwekenge-arle. Re atyalangke ikwerenhe itwele aneke irrare anthurre. ");
INSERT INTO aer_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Kele Abraham artneke-arle iperre, re alheke atyalangke rarle intetyame-ngentyele akngerrepate areye tyerrtye Hittite areye-werne apmere anyente ikwerenge-ante. Itne apmere arriwele anerrirretyame nthenhele-arle itne-arle akwetethe angkerremele anepaneme ikwerele. Abraham alhemele itneke angkeke, ");
INSERT INTO aer_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Apmere nhenhe kwenhe arrekantherrenhe kenhe ayenge akenhe ipenye-arle. The arrenhantherrenhe apayuthnetyeke apmere akweke ware ayenge maneke anthetyeke the anewe atyinhe iperteke artetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Hittite areye itne Abraham-eke angkirtnerlenge alakenhe, ");
INSERT INTO aer_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Artwe ampwaye, unte kwenhe akngerrepate anthurre anwerneke aneme. Anwerne-arrpele apmere atnyeneme anwerneke-artweye areye-kenhe. Unte apeke anwernenhe apayuthneme, arrangkwele ngenhe ayakeme anewe ngkwinhe ahelhe irrare anwerne-kenhele artemenge. Mwerrantye ngenhe antheme unte ngkwenge anewe artetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Itnenhe aweke-arle iperre Abraham amperele-arlenge tneke imerte Hittite areyeke tyernemele, ");
INSERT INTO aer_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","“Arrantherre apeke atyenge ahentye anthurre anemele the apeke atyenge anewe artetyeke apmere arrekantherrenge, kele Ephron-eke angkaye atyenge-ngentyele. Rarle alere Zohar-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Kenhe Ephron re akenhe apmereke-artweye inteye akwekeke Machpelah arritnye. Re apeke atyenge mwerre apeke angkemele inteye renhe atnyenetyeke, kele the renhe mane-arle antheme. Arrantherre mwantyele arelhewarraye the renhe mane antherlenge kele arrantherre itelaretyeke inteye yanhe kele atyinhe anteme. Kele the anewe atyinhe ikwereke artetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Artwe nhenge Ephron, re anetyame Hittite akngerrepate areye-akerte gate arriwele. Re Abraham angkerlenge aweke, re angkeke, ");
INSERT INTO aer_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Artwe ampwaye, ayenge awaye kele tyerrtye ingkirrekele awetyeke ayenge ngkwenge angkerlenge. The ngenhe ahelhe-arlke inteye akweke-arlke anthetyenhe. The ngenhe anthetyenhe unte ngkwenge anewe ngkwinhe iperteke artetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abraham re awethe amperele-arlenge tneke Hittite akngerrepate itnekenge arrekwelele. ");
INSERT INTO aer_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","Re Ephron-eke angkeke, “Arrangkwe, ayenge awaye. Tharle apmere yanhe inetyeke arrangkwe-arle mane anthetyakenhe-arle. Me, mane nhenhe inaye unte-arle apmereke-artweye! The anewe atyinhe iperteke artetyeke ahentye-aneme.” ");
INSERT INTO aer_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Kele Ephron Abraham-eke angkeke, ");
INSERT INTO aer_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Artwe ampwaye, ayenge ngkwenge ahele angkerretyeke ahentye anetyakenhe! Unte apeke ayenge apwerte mane 400-pele anthetyeke, kele the ngenhe apmere anthetyenhenge unte anewe ngkwinhe artetyeke yanheke.” ");
INSERT INTO aer_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Kele, Abraham yewe angkeke Ephron-eke, re renhe apwerte mane antyapere antheke. Hittite akngerrepate areye itne renhe areke alakenhe mpwarerlenge. Re itnenhe ularele anthetyakenhe, arrangkwe anthurre. ");
INSERT INTO aer_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","18","Arratye kwenhe, Hittite akngerrepate areye-arle gate arriwele anetyame, itne Abraham aretyame Ephron mane antherlenge. Abraham-ele Ephron mane antheke iperre, Ephron-ele apmere akweke renhe sell-eme-ileke ikwere apmere Machpelah renhe. Machpelah aneke ikngerrele apmere arrpenhe Mamre arritnyenge. Kele, Abraham-arle apmereke-artweye aneke inteyeke-arlke arne areyeke-arlke yanhe-arle tnekeke. ");
INSERT INTO aer_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Yanhe-ngentyele, Abraham-ele apmere renhe imperle-alheke anewe ikwerenhe iperteke artetyeke apmere Machpelah ikwerele apmere arrpenhe Mamre itweke. Apmere yanhe Mamre, apmere akngerre Canaan-ele aneke. Ikwerenge anteme tyerrtye areyele apmere renhe Hebron anteme arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Tyerrtye ingkirreke kele akaltye anteme aneke inteye apmere ikwerele Abraham-kenhe anteme aneme. ");
INSERT INTO aer_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham kele artwe ampwe anthurre anteme aneke. Kenhe YAHWEH-ele renhe arne atningke anthurre antheke renhe akwetethe arntarnte-arlke-aretyarte. ");
INSERT INTO aer_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Arlte anyentele, Abraham antangkelheke urrkapentye akngerre atyeperre ikwerenheke imerte angkemele, “YAHWEH-nge arrekwele atyenge uternelhaye. ");
INSERT INTO aer_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Rarle nhenge alkere uthene apmere ahelhe nhenhe utheneke akngerrepate, atyenge uternelhaye unte-arle anewe akngaketyakenhe atyenge alereke Isaac tyerrtye nhenhe Canaan-arenye areye-ngentyele. ");
INSERT INTO aer_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Kele anteme, apmere-werne alpaye nthenhele-arle ayenge inteke-arle, anewe ikwere aretyeke atyenge-artweye areyenge.” ");
INSERT INTO aer_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Kenhe urrkapentye akngerre re akenhe apayuthnerlenge, “Kele arelhe awenke the akngakeme, re apeke apale angkerlenge-artaye apmere ikwerenhe impetyakenhe atyengenge apetyetyeke? Nthakenhe-ame anteme ayenge irretyenhe? Kele the Isaac yerneye re-arrpe aneweke aretyeke?” ");
INSERT INTO aer_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham angkirtnerlenge, “Arrangkwe! Renhe akngirtnetyale nhakwe-werne, nthakenhe apeke irremele. ");
INSERT INTO aer_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","YAHWEH kwenhe arne arrpe-anenheke akngerrepate aneme alkere akertnele ayenge kwenhe re tyerrelheke apmere ayenge-arle inteke-ngentyele nhenhe-werne akngetyemele atyenge ilemele rarle atyenge-artweyeke apmere nhenhe antheme akwete-ante. Alakenhe renhe-arle the Isaac yernirtnetye-kwenye apmere yanhe-werne ayenge-arle apetyeke. Unte alpemele aneweke aretyeke atyenge alereke, YAHWEH-ele utnenge alkere-arenye yerneme arrekwele ngkwenge imernetyeke unte atyenge alere anewe inetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Unte apmere ikwere irremele unte arelhe renhe aretye-alhetyenhe. Kele arelhe re apeke ayene-irrerlenge, kele unte angkentye nhenhe atnyenetyeke arrangkwe anteme-arle. Kele alere atyinhe akwete akngirtnetyale nhakwe-werne.” ");
INSERT INTO aer_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kele urrkapentye akngerre Abraham-eke uternelheke rarle arratye mpwaretyenhe rarle ilekenge. ");
INSERT INTO aer_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Ikwerenge-ntyele anteme, urrkapentye akngerre re kamule ten-pele inemele ikwerenge akngetyeke alethe alhemele. Re arne mwerre akngerre atningke inemele apurtelhe-ilemele akngeke, arne nhenge areye Abraham-kenhe, arne gold uthene silver uthenenge-arle mpwareke, mantere mwerre akngerre areye-arlke, arne nhenhe itnenhe re kwentye-kwentye-ilemele kamule areyeke-arleke utyerneke. Kele re arnpenheke urrkapentye akngerre Abraham-kenhe arrpenhe areye-akerte-arlke itne apurte alethe alherlte-iweke apmere ayerrere Syria-werne, kake Abraham-kenhe Nahor-arle aneke-werne. ");
INSERT INTO aer_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Kele re apmere ikwere itweke anteme irreke nthenhele-arle Nahor aneke ikwere-werne re ngkernelhemele kamule areye ltyerretyeke arrerneke kwatye ngentye apmere akweke itepele. Kele angwerrele anthurre anteme, arelhe awenke urrpetye apetyeke apmere angathenge-ntyele kwatye itne akwetethe inepineme ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Nhenge urrkapentye akngerre Abraham-kenhele areke arelhe awenke itne apetyerlenge kwatye-werne-atheke re Ngkarteke angkeke apayuthnemele alakenhe: “YAHWEH, unte kwenhe Ngkarte akngerrepate atyinhe Abraham-kenhe, Ngkarte nhenge rarle utyernemele tnakerlenge. The ngenhe apayuthneme unte ikwere mwerre anetyeke angkentye ngkwinhe atnyenemele ayenge ipmentye Isaac aneweke aretyeke lyete. ");
INSERT INTO aer_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Arelhe awenke itne lyete ware apetyetyenhe kwatye ngentye nhenhe-werne itne kwatye inetyeke. ");
INSERT INTO aer_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Itne nhenheke-irremele the marle anyente apayuthnetyenhe atyenge kwatye inetyeke. Kele re apeke kwatye inemele atyenge anthemele the antywetyeke re atyenge akangkentye-arlke ilelheme anteme kele kamule areye-arlke kwatye anthemele, kele the itelareme renhe-arle unte ineke Isaac-eke anewe anetyeke. Kele alakenhe-arle the itelaretyenhe unte-arle akngerrepate atyinheke alhilentye ngkwinhe atnyeneke.” ");
INSERT INTO aer_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","16","Nhenge rarle YAHWEH-eke akwete angketyamenge, marle mwerre akngerre arlwekere-arenye apetyeke kwatye ikwere-werne kwatye-kenhe untyele akngemele, Rebekah arritnye aneke. Marle nhenhe artwenge arrekwele intetyakenhe. Re ampe Bethuel-kenhe, alere kake Abraham-kenhe Nahor-kenhe anewikwe Milcah uthene-kenhe. Nhenge Rebekah apetyemele urrkapentye akngerre Abraham-enge anpere alheke, imerte kwatye ngentye-werne alhemele. Re kwene irremele tyampite ikwerenheke kwatye theleke anteme. Kele re kwatye thelemele tyampite ikwere, akertne-ilemele untyeke arrernemele untyeme-irremele alheke. Kele re alpemele. ");
INSERT INTO aer_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Urrkapentye akngerre Abraham-kenhe unteke marle ikwere-werne imerte angkemele, “Kwatye akweke ayenge anthaye.” ");
INSERT INTO aer_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Kele re tyerneke, “Ayenge-arle akangkemele-arle ngenhe kwatye anthetyeke.” Re tyampite iparrpele untyenge-ntyele atnarnpelhe-ilemele renhe iltyele arntwirrkeke rarle antywetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","20","Kele rarle antywerlenge ipenhe, arelhe re angkeke, “Urreke, the kwatye inetyeke alheme kamule ngkwinhe areyele kwatye antywemele alyure anetyeke.” Kele re iparrpe alheke kwatye inetyeke thelemele tyampite-ngentyele urtne akwekeke-arleke kamule areye antywenheke. Re akwete-akwete kwatye inemele akngernetyeke kamule areyele awethe antywetyeke. ");
INSERT INTO aer_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Rarle kwatye inetyamenge urrkapentye akngerre Abraham-kenhe angketyakenhe aneke, kele re areke ingkirreke Rebekah-ele mpwarerlenge, rarle ahentye-anekenge itelaretyeke marle nhenhe apeke-arle YAHWEH-ele akngakeke. ");
INSERT INTO aer_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Kele kamule areyele kwatye antyweke-arle ipenhe, urrkapentye re alheke yakwethe ineke kamule-ngentyele, gold iltye-kenhe mwerre akngerre, gold amulte-kenhe akngerre atherre-arlke. Re akngemele Rebekah antheke. Re iltye-kenhe antheke alhe ikwerenheke gold amulte-kenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","Re imerte renhe apayuthneke, “Atyenge ilaye angwenhe-ame akngeye ngkwinhe. Re-ame apmere atnyeneme anwerne lyete ingwele intetyeke?” ");
INSERT INTO aer_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Re angkirtnerlenge, “Akngeye atyinhe-arle Bethuel-arle, Nahor uthene Milcah utheneke alere. ");
INSERT INTO aer_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Anwerne-arle apmere atnyeneme-arle unte-arlke urrkapentye ngkwinhe areye-arlke intetyeke, anwerne atherrke-arlke atningke atnyeneme kamule areyeke-arlke.” ");
INSERT INTO aer_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Kele urrkapentye akngerre re akaperte kwene-irremele YAHWEH-eke angkeke, ");
INSERT INTO aer_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","“YAHWEH, Ngkarte akngerrepate atyinhe Abraham-kenhe-aye, ayenge akangkeme anthurre unte-arle ayenge ikwere-artweye areye-werne akngetyekenge alhilentye ngkwinhe arratye atnyenemele.” ");
INSERT INTO aer_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Urrkapentye akngerre Abraham-kenhe uthene Rebekah uthene-arle angkerreke iperre, Rebekah apmere-werne unteke ikwere-artweye areyeke iletyeke ingkirreke nthakenhe-arle irrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Re apmereke irreke re ikwere-artweye areyeke ileke ingkirreke nthakenhe-arle irreke. Nhenge rarle kake ikwerenhe Laban-ele awetyame re imerte awemele nthakenhe-arle urrkapentye akngerre Abraham-kenhe-arle angkeke, re imerte aremele iltye-kenhe alhe-larlenge, amulte-kenheke irrperlenge. Yanhenge rarle angkeke ipenhe, Laban re unteke apmerenge arratemele urrkapentye akngerre Abraham-kenhe renhe arneke-arnare-irretyeke, re alhemele urrkapentye akngerre renhe aretye-alheke kwatye iterele kamule ikwerenhe areye-akerte urrkapentye akngerre arrpenhe areye-arlke. ");
INSERT INTO aer_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laban re anyente-irretyeke alheke ikwere angkeke, “Tharle itelareme-arle YAHWEH-elarle ngenhe mwantyele akngetyeke nhenhe-werne. Atyengenge apmere-werne apetyaye. Ahelhe akethele akwete anetyale. The arrekantherre apmere atnyenemele warle anwerne-kenhele, kamule arrekantherrenhe areyeke-arlke ltyerretyeke merne atherrke-arlke arlkwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kele urrkapentye akngerre Abraham-kenhe kwatye ngentye imperle-alheke Laban-akerte apmere-werne alhemele. Ratherre arratetye-alheke apmere Laban-kenheke, urrkapentye akngerre Laban-kenhele kamule-ngentyele arne areye atnarnpelhe-ileke imerte itnenhe merne atherrke anthemele arlkwetyeke. Kamule itne arlkwerlenge kele urrkapentye itne kwatye apmere kwene-werne akngeke, urrkapentye akngerre Abraham-kenhe areye ingke alhewelhetyeke. ");
INSERT INTO aer_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ingke-arle itne alhewelheke iperre, urrkapentye akngerre Laban-kenhele merne itneke akngetyeke arlkwetyeke. Kele urrkapentye akngerre Abraham-kenhe angkerlenge Laban-eke, “Urreke the arlkwetyenhenge, the arrekantherre iletyeke iwenhenge ayenge apetyeke.” Laban akenhe angkirtnerlenge “Kele ilaye, iwenhenge unte apetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Kele urrkapentye akngerre Abraham-kenhele renhe alakenhe ileke: “Ayenge-arle urrkapentye akngerre Abraham-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","YAHWEH kwenhe mwerre anthurre aneke akngerrepate atyinheke imerte re akngerre anthurre irrerlenge. Re renhe yepe-yepe atningke antheke, nanikute areye-arlke, pweleke, kamule areye-arlke, tangkeye areye-arlke, silver akngerre uthene gold akngerre uthene, urrkapentye akngerre atningke-arlke. Re kwenhe mwerre anthurre arne rarle mpwareme areyeke YAHWEH-elarle renhe arntarnte-arerlenge-arle akwetethe. ");
INSERT INTO aer_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Kenhe Sarah akenhe, akngerrepate atyinheke anewe, re kwenhe ampe atnyenetyakenhe ampwe anthurre irremele-ante. Kele re arelhe ampwe-irremele urreye akweke atnyeneke, akngerrepate atyinhele akenhe ikwere alere arne atningke antheke. ");
INSERT INTO aer_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Ayenge akngerrepate atyenge alhilelhemele the akwele iwenhe apeke mpwaretyeke re ayenge ilerlenge. Re anteme atyenge ileke, ‘Ayenge ahentye-aneme unte alhetyeke anewe inetyeke atyenge alereke Isaac-eke. Apmere nhenhele anetyale anewe akngaketyeke arelhe apmere nhenhe-arenye areyenge, apmere Canaan-arle aneme nthenhele-arle anwerne lyete anepaneme kwenhe. ");
INSERT INTO aer_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Kele alpaye, apmere nhenge-werne atyinheke-artweye areye-arle anerlte-aneme, anewe inetyeke alere atyinheke atyenge-artweye areyenge.’ ");
INSERT INTO aer_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Kele the akngerrepate atyinhe apayuthneke, ‘The arelhe awenke renhe aremele ngkwenge alereke, nthakenhe-ame ayenge irretyenhe re apeke mwernte-irrerlenge, atyengenge apetyalpetyakenhe?’ ");
INSERT INTO aer_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Akngerrepate atyinhe akenhe angkerlenge, ‘The kwenhe akwetethe YAHWEH awenhe-awenhe ikwere akangkwe-irremele, the itelareme re utnenge alkere-arenye yernetyenhe unte-arle unthemele aretyeke atyenge-artweye areye itweke. ");
INSERT INTO aer_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Kele unte renhe areke-arle ipenhe itne ikwere ayakemele unte renhe akngetye-alperlenge, kele unte alhilentye atyinhenge impentye anetyeke.’ ");
INSERT INTO aer_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Rarle atyenge alakenhe ileke ipenhe the apmere impemele alheke anwerne-arle anetyarte imerte kwatye ngentye nhenge-werne apetyemele. Ayenge-arle nhenge arrekwele apetyetyenhe, ayenge nterte-arle irreke tneke YAHWEH-eke apayuthnemele, ‘YAHWEH, akngerrepate atyinhe Ngkarte Abraham-kenhe-aye, the ngenhe apayuthneme atyenge imernetyenhe nthakenhe the anewe aretyenhe ikwerenhe alerikweke, ");
INSERT INTO aer_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","nhenge ayenge kwatyele anekenge.’ The YAHWEH apayuthneke atyenge imernemele tharle itelaretyeke. Ayenge ikwere angkemele, ‘Kele arelhe awenke apetyemele apmere itwenge-ntyele kwatye inetyeke ngentyenge-ntyele, the renhe apayuthnetyenhe kwatye inetyeke imerte ayenge akweke anthemele antywetyeke. ");
INSERT INTO aer_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","Re apeke ayenge kwatye anthemele imerte re angkemele kamule atyinhe areye kwatye anthetyeke-arlke, kele the itelareme marle wenke nhenhe re athewe unte-arle ineke-arle alere akngerrepate atyinhe-kenhele anewe aketyenhenge.’ ");
INSERT INTO aer_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Urreke-arle ayenge YAHWEH-eke angkeke ipenhe, Rebekah apetyerlenge kwatye-kenhe untyele akngernerle-apemele. Re ngentye-werne apetyemele kwatye ineke yakwethe ikwerele theleke. Yanhenge re yakwetheke-arle theleke ipenhe re untyeke-arleke utyerneke the renhe kwatye antywetyeke apayuthneke. ");
INSERT INTO aer_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Re iparrpele yakwethe untyenge atnarnpelhe-ileke atyenge angkemele, ‘Nhenhe kwatye antywetyeke. Unte-arle antyweke iperre the kamule ngkwinhe areyeke kwatye inetyenhenge.’ Kele the kwatye renhe antyweke, yanhe-ngentyele re kamule areye anteme kwatye antheke. ");
INSERT INTO aer_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Kele kamule areyele kwatye antyweke iperre the renhe apayuthneke angwenhe-ame ikwerenhe akngeye, kele re angkirtnerlenge, ‘Akngeye atyinhe-arle Bethuel-arle Nahor uthene Milcah utheneke alere.’ Nhenhe awemele-arteke ayenge alheke ikwere iltye-kenhe gold-akerte ineke alhe-ke imerte arrernemele, re imerte amulte-kenhe areye-arlke iltye akantyeke-arleke arrernemele. ");
INSERT INTO aer_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Kele ayenge akaperte kwene-irremele ahelheke amperele-arlenge tnemele YAHWEH utyernemele tnakeke, Ngkarte akngerrepate atyinhe Abraham-kenhe. Ayenge akangkeke arnterre ayenge-arle YAHWEH-ele akngetyeke akngerrepate atyenge-artweye areye-werne, the itnenhe ampe marle itne-kenheke apayuthnetyenhenge ikwere-artweye areye marle re anewe anetyeke alere akngerrepate atyinhe-kenheke. ");
INSERT INTO aer_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Ayenge anteme iletyeke ahentye-aneme unte apeke arratye-arratye apeke mpwaretyeke akngerrepate atyinheke. Unte-ame ikwere mwerre anemele renhe Rebekah antheme ithwenge apeke, the apeke marle awenke arrpenheke unthemele aretyeke?” ");
INSERT INTO aer_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Kenhe Laban uthene Bethuel uthene angkirtneke, “Kele anwerne itelareme YAHWEH-elarle nhenhe mpwareke, kele anwerne mpwaretyeke YAHWEH-arle ileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Anwerne nhenheke akangkeme anthurre. Kele anteme apmere nhenhe impemele akngerrepate ngkwinhe Abraham-werne alpaye Rebekah-arlke akngemele re alere akngerrepate ngkwinhe-kenhe anewe aketyenhenge, YAHWEH-elarle ileke-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Urrkapentye akngerre Abraham-kenhe akangkemele akaperte kwene-irreke YAHWEH-eke angkemele. ");
INSERT INTO aer_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kele itne-arle angkerreke ipenhe urrkapentye akngerre Abraham-kenhe alheke arne mwerre akngerre arrpenhe areye inetyeke imerte Rebekah anthemele, mantere nhenge, arne arrpenhe areye silver uthene gold uthenenge-arle mpwareke. Re arne mwerre akngerre arrpenhe areye antheke kake ikwerenhe meye ikwerenhe-arlke. ");
INSERT INTO aer_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Urrkapentye akngerre Abraham-kenhe uthene artwe areye ikwerele-arlenge uthenele merne uthene kere uthene arlkweke kwatye antywemele-arlke, imerte anemele inteke yanhe ikwerele. Ingwe-athnele anteme itne akeme-irremele, urrkapentye akngerre Abraham-kenhe Rebekah-eke-artweye areyeke angkeke, “Ayenge apeke alpetyeke Rebekah-akerte akngerrepate atyinhe-werne lyete-anteye?” ");
INSERT INTO aer_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Kele Laban uthene mikwe uthene ikwere angkirtnerlenge, “Rebekah anwerneke impemele arlte ten-pele awethe anetyekaye, kele re ngkwengenge alpetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Re akenhe angkerlenge, “Ayenge awethe ayaketyalaye awethe anetyeke. YAHWEH-ele ayenge kele-arle arratye-ilekenge anewe inetyeke alere akngerrepate atyinhe-kenheke. Kele anteme anwerne impeme lyete alpetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Ratherre angkerle-anerrerlenge, “Mpe, Rebekah-eke-amparre apayuthnetyeke nthakenhe-arle re irretyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Alhemele itne renhe apayuthneke, “Unte-ame ahentye-aneme apmere nhenhe impemele alhetyeke artwe nhenhenge lyete?” Re angkirtnerlenge, “Yewe, ayenge ikwerenge alhetyeke lyete.” ");
INSERT INTO aer_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kele itne yewe angkerreke Rebekah arelhe ampwe-arlke iparrpe alhetyeke urrkapentye akngerre Abraham-kenhe-akerte artwe areyenge-arlke. Arelhe ampwe nhenhe akenhe atyewe-arle aneke ikwere-artweye areyeke re akenhe Rebekah akwetethe-arle arntarnte-aretyarte ampe akwekenge-ntyele re amangkelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Ingkirreke itne YAHWEH-eke angkeke Rebekah ikwere, “Anwerne Ngkarte apayuthneme ngenhe ampe atningke anthetyeke atyemeye-arlke Re akwetethe anteme arntarnte-aretyenhe, tyerrtye apmere arrpenhe-arenye areyele itnenhe uyarne atweme itne apetyerlenge atwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Kele ikwerenheke-artweye areye-arle YAHWEH-eke angkeke ipenhe, Rebekah arelhe awenke arrpenhe areye-arlke arratyeke irreke apmere impemele alhetyeke. Itne akethe-werne alhemele kamule-ke antyerlte-alheke urrkapentye akngerre areye-arlke kele alheke urrkapentye akngerre Abraham-kenhe arrpenhe areyenge. ");
INSERT INTO aer_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Yanhenge akenhe Isaac apmere Beer-lahai-roi-ngentyele apetyalpemele, apmere Negev-ele anetyame. ");
INSERT INTO aer_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","65","Ingwe anyentele re akethele unthetyame itirremele, re areke tyerrtye areye arlengenge apetyerlenge kamule-nge ikwere-werne atheke. Re arnpenheke itneke-werne-atheke. Nhenge Rebekah-ele renhe apetyerlenge areke; Re iparrpe ngkernemele kamule ikwerenhe-ngentyele atnarnpemele, imerte urrkapentye akngerre Abraham-kenhe apayuthnemele, “Angwenhe-ame artwe yanhe ularre apetyeme?” Urrkapentye akngerre re akenhe angkerlenge “Re kwenhe akngerrepate atyinhe Isaac.” Kele Rebekah-ele mantere ineke re inngerre artelhetyeke, nhenge arelhe apmere yanhe-arenye areyele mpwaretyarte alhilentye itnekenhele areketyenge. ");
INSERT INTO aer_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Kele Isaac itnekenge apurte-irremele, urrkapentye akngerre Abraham-kenhele ileke ikwere nthakenhe-arle irreke-akerte. ");
INSERT INTO aer_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Ikwerenge anteme Isaac-ele Rebekah akngeke ilthe ikwerenhe, ikwere anewe anteme aneke re ikwere arnterre anthurre ahentye-aneke. Nhenge Isaac-arle irrare anthurre anetyarte meye ikwerenhe-arle aparlpe-ilekenge kele Rebekah anewe ikwerenhenge anteme, re akangkentye anteme awethe aneme. ");
INSERT INTO aer_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Nhenge Sarah ilweke-arle iperre kele Abraham-ele arelhe arrpenhe Keturah arritnye anewe akeke, ");
INSERT INTO aer_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","ratherre ampe urreye six-pele atnyeneke: Zimran, Jokshan, Medan, Midian, Ishbak uthene Shuah uthene. ");
INSERT INTO aer_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Ikwerenge, alere anyente Abraham-kenhe Jokshan arritnye aneke re anewe akerte-irreke imerte urreye atherre atnyenemele Sheba uthene Dedan uthene. Kele Dedan amangkeke anteme, re anewe inemele ampe urreye urrpetye atnyeneke anteme: Asshurim, Letushim, Leummim-arlke. ");
INSERT INTO aer_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Alere arrpenhe Abraham-kenhe, Midian re anewe inemele, urreye five-pele atnyeneke: Ephah, Epher, Hanoch, Abida uthene Eldaah uthene. Ampe nhenhe areye Keturah-kenhe aneke. ");
INSERT INTO aer_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","6","Nhenge Abraham-arle itethe akwete anekenge, re arne mwerre areye antheke Hagar uthene Keturah utheneke alere. Re imerte itnenhe yernemele apmere ikngerrele anetyeke rarle ahentye anetyakenhe itne Isaac uthene apurte anetyeke. Ikwere ipenhe anteme, Abraham-arle ilwekenge anteme, re arne ikwerenhe ingkirreke impeke, arne ingkirreke re atnyeneke Isaac-eke. ");
INSERT INTO aer_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","8","Abraham aneke artwe ampwe anthurre irretyeke re uyerremele year 175-pele anekenge. ");
INSERT INTO aer_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Ikwere alerikwe atherre, Isaac uthene Ishmael uthenele renhe iperteke arteke apmere Hebron-enge ikngerreke Machpelah inteye ikwere. Apmere nhenhe Mamre-nge ikngerre aneke apmere Abraham-arle manele ineke Ephron, alere Zohar-kenhenge, artwe Hittite re aneke. Ikwere alere atherrele renhe iperteke arteke ikwere anewe Sarah itweke. ");
INSERT INTO aer_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Nhenge Abraham-arle ilwekenge, Isaac apmere Beer-lahai-roi ikwerele anetyarte. Ngkartele akwetethe arne mwerre mpwaretyarte Isaac-eke, re akngeye Abraham-eke mpwaretyarte-arteke. ");
INSERT INTO aer_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Ayeye nhenhe Ishmael-eke-artweye-akerte. Ishmael re akenhe alere akngerrepate Abraham-kenhe-arle. Meye ikwerenhe Egypt-arenye aneke, Hagar arritnye. Hagar re akenhe urrkapentye akngerre Sarah-kenhe anewikwe Abraham-kenhe-arle anemeke. ");
INSERT INTO aer_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","15","Nhenhe-arle akenhe alere 12-pele itnekenhe arritnye: Arrekwelenye akenhe Nebaioth arritnye aneke. Ikwerenge anteme Kedar, kele Abdeel anteme, kele Mibsam anteme, Mishma, Dumah, Massa, Hadad, Tema, Jetur, Naphish, uthene Kedemah uthene. ");
INSERT INTO aer_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Kele alerikwe itne amangkeke, itne akalke-irremele alheke apmere arrpe-anenhele anetyeke. Apmere arrpenhe areyele itne itne-kenheke-artweye areyeke akngerrepate aneke. Apmere 12-pele itnekenge arritnye rante-rante areye aneke alere 12-pele itnekenhe-arteke. ");
INSERT INTO aer_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Kenhe Ishmael akenhe arruleke-atwetye aneke re uyerreke artwe ampwe anthurre irrekenge, year 137-pele aneke. ");
INSERT INTO aer_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Alere 12-pele Ishmael-kenheke-artweyele, itne itne-arrpeke-artweye atnyeneke, itne anerrirretyarte mpwepele apmere atherrele, apmere ikwere-atherrenhe Havilah uthene Shur uthene arritnye. Apmere yanhe-arle anetyarte angathe aneke ikngerrele apmere Egypt-nge apmere Assyria-werne atheke. Ishmael-kenheke-artweye areye arlengele anerrirretyarte ikwere atyeyikwe-kenheke-artweye areye-ketye itne-arle atwerrentye akngerrenge. ");
INSERT INTO aer_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Ayeye nhenhe Isaac-akerte, alere Abraham-kenhe-arle. Itelareme Abraham-arle alere Isaac arritnye atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Nhenge Isaac-arle year 40-pele anekenge, re arelhe anewe akeke Rebekah arritnye, ampe Bethuel-kenhe. Re yaye aneke Laban-eke, ratherre apmere Paddan-Aram-arenye. ");
INSERT INTO aer_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Kenhe Rebekah re akenhe ampe uyarne-arle atnyeneke alakenhe ikwerenge anteme Isaac-ele YAHWEH apayuthneke ratherre ampe atnyenetyeke. YAHWEH-ele aweke Isaac re angkerlenge. Yanhenge anteme, Rebekah atnerte-atnerte-irreke, rante-atherre-akerte. ");
INSERT INTO aer_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Rebekah-ele ampe akweke atherre awelheke atnerte kwenele akngelherlenge, re akenhe itirreke ratherre-arle atwerreke. Re-arrpe itirreke, “Iwenhenge-arle-ame ayenge alakenhe awelheme?” Alakenhenge anteme, Rebekah akngerre itirremele angkeke YAHWEH-eke nthakenhe-arle irremeke. ");
INSERT INTO aer_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Kele YAHWEH-ele Rebekah tyerneke, “Ngkwenge ampe urreye atherre intemele imerte apurte amangkemele, arrekwelenye urrkapetyenhe ingkernenyeke. Ampe urreye ratherre ampe atningke atnyenetyenhe, itne-kenheke akwerrke areye akalke-akalke anetyenhe apurte anetyange. Ratherre atyewe anetyakenhe. Akwerrke ingkernenye-kenhe areye lterrke anetyenhe, itne akenhe kake ikwerenhe areyenge lterrke ulkere. Alakenhe akwele unte awelheme urreye akweke ratherre angkelhe-ilerrerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Ikwerenge-ntyele, kele angathe anteme irreke Rebekah-ele ampe akweke atherre atnyenetyeke. Akweke ratherre arratye aneke atherre atnerte kwenele. ");
INSERT INTO aer_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Nhenge akweke arrekwelenye intekenge; yenpe ikwerenhe athetheke aneke, re alte athetheke tyerrtye ikwerenheke-arleke atnyeneke alte antyame akngerre-arteke. Akngeye uthene meye uthenele Esau arritnye antheke. Arritnye nhenhe re angkeme “alte arlpentye akemele-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kele Esau-arle intekenge, kele kake akweke ikwerenhe anteme inteke. Ampe ingkernenye-arle intekenge, arrekwelenye ingkernenyele ingke atnware arntwirrkeke. Alakenhenge anteme anyikwe uthene meyikwe uthenele Jacob arritnye antheke. Arritnye nhenhe re angkeme “Ingke Atnware-arle Arntwirrkeme akemele-arteke.” Nhenge Rebekah-arle ampe akweke nhenhe atherre atnyenekenge, Isaac akenhe year 60-pele-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Nhenge ratherre amangkerle-anerremele, Esau akenhe irlkngenye anthurre-arle, re ahentye anetyarte ulyenye alhetyeke. Kenhe atyeyikwe Jacob akenhe apmerele anerle-anetyarte ware ilthe ikwere-artweye-kenhe itwele. ");
INSERT INTO aer_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Kenhe Isaac-ele akwetethe kere Esau-elarle akngetye-alpetyarte arlkwetyarte. Isaac arnterre Esau-ke ahentye-anetyarte ikwere-arle kere itemele akngetye-alpetyartenge. Kenhe Rebekah akenhe Jacob-ekarle arnterre ahentye-aneke Esau-ke kwenye. ");
INSERT INTO aer_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Arlte anyente ikwerele, Jacob-ele kere kwatye athetheke iteke tyampite akngerrele. Kenhe Esau re akenhe ulyenge ipenhe apetyalpeke, kereke angayakwe anthurre. ");
INSERT INTO aer_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Re Jacob-eke angkeke, “Aye, ayenge angayakwe anthurre-eyaye! Iparrpe ayenge anthaye the kere kwatye athetheke yanhe arlkwetyeke!” Alakenhe akwele arritnye arrpenhe Esau-kenhe ineke “Edom,” alakenhe ileme “Athetheke.” ");
INSERT INTO aer_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Jacob kake ikwerenheke angkeke, “Unte kake atyinhe. Ilerneke-artweye ilwerlenge, unte arne arrpe-anenhe inetyenhe, unte anteme arntarnte-aretyenhenge. The akenhe anetyeke arrangkwe-arle, arrangkwe anthurre. Unte-ame ahentye-aneme ayenge anthetyeke arne ingkirreke akngeye-kenhe? Unte apeke ayenge ingkirreke anthemele, kele the ngenhe kere kwatye athetheke akweke-arle anthirtneme arlkwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esau-ele atyeyikwe tyerneke, “Aye, ayenge angayakwe ilweme lyete, tharle arne akngeye-kenhe areye anetyeke arrangkwe-arle, ayenge kele ilwekenge. Nthakenhe anteme the renhe iletyenhe!” ");
INSERT INTO aer_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Kele Jacob akenhe kake ikwerenheke angkirtnerlenge, “Atyenge uternelhaye, unte atyenge arne ingkirreke akngeye-kenhe anthemele, kele the ngenhe kere kwatye antheme-arle arlkwetyeke.” Kele, Esau uternelheke arne ingkirreke akngeye ikwere-atherrenhe-kenhe anthetyeke arne-arlke, mane-arlke. ");
INSERT INTO aer_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Yanhe-ngentyele, Jacob merne uthene kere kwatye uthene antheke kake ikwerenhe arlkwetyeke. Kele Esau-ele arlkweke ipenhe, re akeme-irremele alheke. Alakenhe Esau-ele atyeye ikwerenhe arne areye mane-arlke antheke, akngeye ikwere-atherrenhe areye. Esau apale itirreke arne areye akngeye ikwerenhe-kenheke, rarle itnenhene ipmentye-iweke. Re arne impene yanhe areyeke mwantye itirretyakenhe, re itnenhene arntwirrketyeke, arerte-irretyakenhe, rarle kake akngerrepate akwele. Kenhe arrangkwe-arle akenhe, re arne impene yanhe areyeke itirretyakenhe, itne akurne-arteke akwele. ");
INSERT INTO aer_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Ikwere iperre anteme apmere yanhele, itne merne-arlke kere-arlke atnyenetyakenhe aneke kwatyeke arrangkwenge, tyerrtye atningke angayakwe aneke. Nhenhe aneke nhenge Abraham-arle itethe anekenge-arteke. Isaac-ele apmere ikwerenhe impemele alheke apmere Egypt-werne atheke. Ikwere-werne atheke alhemele re ngkernelheke apmere Gerar arritnyeke imerte Abimelech-eke angkemele. Re tyerrtye apmere Philistia ikwere-arenye areyeke akngerrepate aneke. ");
INSERT INTO aer_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Isaac apmere ikwere irretye-alheke, YAHWEH-ele renhe ileke, “Apmere Egypt-werne alhetyalaye. The ngkwenge imerneme nthenhele-arle unte anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Lyeteke ware apmere nhenhele anaye, kele Ayenge ngkwengenge aneme ngenhe arntarnte-aremele. The ngenhe antheme apmere ahelhe nhenhele unte anetyeke ampe ngkwinhe areyeke-arlke arrenge-arrenge ngkwinhe areyeke-arlke. Nhenhe apele The ngkwenge-artweye Abraham-eke-arle angkentye arratye ilekenge-arle. ");
INSERT INTO aer_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Yewe, The ngenhe akwerrke atningke anthurre anthetyenhe, The itnenhe atningke-ileme. Itne apele kwerralye areye alkerele-arle aneme-arteke anetyenhe, atningke anthurre-arle tyerrtye areyele arritnye iletyeke. Ayenge itneke mwerre anetyenhe. Kele tyerrtye apmere arrpe-anenhele akangketyenhe ngkwenge-artweye areyekenge, itne-kenheke akwerrke areye. ");
INSERT INTO aer_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","The alakenhe ngkwenge mpwareme akngeye ngkwinhe Abraham-arle atyenge akwetethe awelhetyartenge. Re Atyenge akangkwe-irretyarte imerte Atyenge mpwaremele iwenhe The renhe ilerlenge. Re Atyenge akangkwe-irretyarte mpwaretyartele Tharle renhe akaltyele-antheke-arlke. Re arratye angkentye atyinhe apentetyarte.” Alakenhe-arle YAHWEH Isaac-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Kele Isaac-ele mpwareke nthakenhe-arle YAHWEH-ele ikwere ilekenge imerte anemele Gerar ikwerele, rarle apmere Egypt-werne alhetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Rebekah, anewe Isaac-kenhe-arle, re arelhe mwerre akngerre anthurre aneke. Nhenge Isaac-arle apmere Gerar ikwerele anetyame artwe apmere yanhe-arenye areyele Isaac apayuthneke anewikwe-akerte alakenhe, “Angwenhe-ame arelhe yanhe?” Isaac-ele itnenhe ularele ileke alakenhe, “Yanhe-arle yaye akweke atyinhe-arle.” Re akenhe itneke-ketye atere-arle-irreke. Re urrtyirremele ileke, re kwenhe arratye iletyakenhe re ikwerenhe anewe aneke. Rarle urrtyirremele ileke rarle itirremenge itne renhe atweme-ketye imerte anewe ikwerenhe akngemele rarle mwerre akngerre anthurrenge. ");
INSERT INTO aer_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaac apmere Gerar ikwerele akwete anthurre aneke. Ikwerenge anteme, Abimelech, tyerrtye Philistia-arenye areyeke akngerrepate-arle aneke, renhe aretyame apmere arriwe ikwerenhe-ngentyele. Re Isaac areke Rebekah arrwantyerlenge akwakemele. ");
INSERT INTO aer_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abimelech-ele anteme artwe ikwerenhe areye yerneke Isaac inetyeke. Isaac re apetyeke arteke, Abimelech ikwere angkerlenge, “Aye, arelhe nhenhe-ame arratye ngkwenge anewe! Iwenheke anteme unte anwernenhe ularele ileke? Unte-arle anwerneke ileke yanhe yaye akweke ngkwinhe akwele.” Isaac-ele renhe tyerneke, “Ayenge-arle atere-arle-irreke ayenge itirreke arrpenhele apeke ayenge atweketyenge imerte arelhe ikwere-arrpe akngetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Kele, Abimelech angkeke Isaac-eke, “Unte kwenhe alakenhe irretyale anetyeke. Iwenhenge-arle-ame unte urrtyirreke anwerneke? Artwe nhenhe areyele apeke-arle arelhe awenke nhenhe inetyeke aneke imerte ikwerenge intemele apeke. Angwenhele apeke-arle arelhe yanhe ineke, kele akurne anthurre-arle aneme, Ngkartele anwerne ingkirreke atwetyeke-arle!” ");
INSERT INTO aer_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kele Abimelech-ele tyerrtye ingkirreke ikwerenhe areye alkngarre-ileke, “Angwenhele artwe yanhe-arlke apeke anewikwe-arlke apeke anpeme, the thultye atyinhe areye iletyenhe renhe irrerlknge atwetyeke!” ");
INSERT INTO aer_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Ikwerenge anteme, Isaac-ele annge areye ngkerneke merne lyapetyeke. Urreke uternenge anteme re merne mpenge areye ineke arne areyenge rarle lyapelhe-ilekenge-ntyele. Arne itne merne annge akngerre anthurre lyapeke, re inemele annge mpenge awethe anthurre-ulkere re ngkernekenge. Alakenhe renhe YAHWEH-ele arntarnte-areke renhe lterrke-ilemele. ");
INSERT INTO aer_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Isaac akenhe arne atningke anthurre atnyeneke, re imerte arne awethe-ame-awethe inemele. ");
INSERT INTO aer_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Re urrkapentye akngerre atningke atnyeneke, arelhe areye uthene artwe areye uthene, itne ikwere arrule anthurreke-atwetye warrke-irrekenge. Kenhe tyerrtye apmere Philistia-arenye areye akenhe ingkerte-arle irrerlenge rarle yepe-yepe uthene pweleke uthene atningke atnyenekenge. ");
INSERT INTO aer_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Itne kwatye ngentye areye marteke, ahelhele artemele. Kwatye ngentye nhenhe areye akenhe urrkapentye akngerre Abraham-kenhele tnyeke, arrekwele akngeye Isaac-kenhe Abraham re itethe akwete anerlenge. ");
INSERT INTO aer_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Kele Abimelech apetyemele Isaac-eke angkeke, “Apmere atyinhe-ngentyele alhaye, apmere arrpenhe-werne! Unte tyerrtye ngkwinhe areye-akerte, arrantherre anwerneke lterrke anthurrenge!” ");
INSERT INTO aer_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Kele Isaac, ikwere-artweye areye-akerte alheke ikngerre-werne atheke lherele anemele apmere Gerar-enge arntwarre. ");
INSERT INTO aer_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Arrule anthurre lhere yanhe ikwerele, akngeye Isaac-kenhe Abraham-ele kwatye ngentye areye tnyeke. Kele rarle ilweke iperrenge, tyerrtye Philistia-arenye areyele itnenhe marteke ahelhele artemele kwatye ngentye itnenhe. Kele Isaac-arlke ikwere-artweye areye-akerte tyerrtye arrpenhe ikwere-akerte areye-arlke, itne akenhe lhere ikwere-werne alhemele ngentye arrpenhe tnyerlenge-arle, re imerte ngentye itnenhe arritnye anthemele arritnye akngeye ikwerenhele-arle antheke-arteke anteye. Alakenhenge anteme ngentye itne Isaac-kenhe anteme aneke. ");
INSERT INTO aer_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Arlte anyentele, urrkapentye akngerre Isaac-kenhe areyele ngentye arrpenhe tnyerrirreke lhere ikwere. Yanhe ikwere anthurreke itne kwatye atelenge areke ahelhe-ngentyele atelenge. ");
INSERT INTO aer_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Artwe Gerar-arenye areyele akenhe pweleke areye-arle arntarnte-aretyame apmere ikwerele. Itne urrkapentye akngerre Isaac-kenhe areyeke, pweleke areye-arle arntarnte-aremeke, ahele angkerreke, itneke angkeke, “Kwatye yanhe kwenhe anwerne-kenhe!” Isaac-ele kwatye ngentye renhe arritnye atheke “Esek,” angkentye Hebrew-enge alakenhe-arle ileme, “Ilterrentye akngerre,” itnarle ilterrekenge kwatye ngentye ikwere ahele angkerrekenge. Yanhenge anteme, Isaac ikwerenhe areye-akerte alheke apmere arrpenhe-werne kwatye ngentye renhe impemele. ");
INSERT INTO aer_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Kele arlengenge ulkere, Isaac-kenhe areye kwatye ngentye arrpenhe-arle tnyerlenge, kele tyerrtye arrpenhe areyele itnenhe kwatye ngentyeke arlkareke. Kele Isaac-ele akenhe kwatye ngentye renhe “Sitnah-arle” arritnye antheke, alakenhe ileme “Atwerrentye Akngerre” itne-arle atwerrekenge kwatye ngentye ikwere. ");
INSERT INTO aer_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Ikwere ipenhe, Isaac tyerrtye ikwerenhe areye-akerte alheke apmere arrpenhe-werne, kwatye ngentye arrpenhe-arle tnyerlenge. Arrpenhe rante-rante areye itnarle kwatye ngentye nhenhe itnekenge akngetyakenhe-arle. Alakenhenge anteme Isaac-ele kwatye ngentye renhe arritnye antheke “Rehoboth” alakenhe ileme “Apmere Anteke Anwerne Anetyeke.” Re angkeke tyerrtye ikwerenhe areyeke, “YAHWEH-elarle anwernenhe apmere nhenhe antheke! Anwerne nhenhele akangkentye anerlte-anemele atningke-irretyeke!” ");
INSERT INTO aer_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Ikwere ipenhe anteme, Isaac tyerrtye ikwerenhe areye-akerte aname-irreke Rehoboth-enge-ntyele imerte ikngerre atheke alhemele apmere Beersheba-le anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Nhenge itne apmere yanhe ikwere arrernelhemele, ingwe anyente ikwerele YAHWEH-ele arraterlenge Isaac-eke altyerrenge imerte ikwere angkemele, “Ayenge kwenhe, Ngkarte akngeye ngkwinhe Abraham-eke-arle angkeke. Re kwenhe atyenge akwetethe akangkwe-irretyarte. Atere irretyale. Ayenge ngkwengenge-arlke-arle aneme. The ngenhe arntarnte-aretyenhe ngenhe lterrke ilemele. Ayenge akngeye ngkwinheke angkeke tharle renhe ampe atningke anthetyenhe arrengeke-arlke! Alakenhenge anteme the ngenhe ampe atningke antheme arrenge-arlke, ayenge-arle angkeke arteke.” ");
INSERT INTO aer_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Kele Isaac-ele apwerte areye lyernte-arrernemele kere re itetyeke YAHWEH-eke. Re imerte YAHWEH-eke akangkemele alyelhemele, re imerte tyerrtye areyeke ilemele YAHWEH-arle mwerre-arle. Yanhe-ngentyele, Re tyerrtye ikwerenhe areye-akerte yanhe ikwerele ilthele inteke, kele urrkapentye akngerre ikwerenhe areyele kwatye ngentye arrpenhe tnyetyeke-arle alherlte-iwerlenge. ");
INSERT INTO aer_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ikwere ipenhe Abimelech apetyeke apmere Gerar-engentyele Isaac-eke angketyeke. Artwe arrpenhe atherre ikwerenge apetyeke: Ahuzzath akaltyele-anthenhe-anthenhe ikwerenhe uthene Phicol renhe arntarnte-arentye akngerre uthene, re akenhe thultye Abimelech-kenhe areyeke akngerrepate-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Isaac-ele itnenhe apayuthneke, “Iwenhenge-ame arrantherre nhenhe-werne apetyeke? Unte-arle atyenge mwerre anetyakenhe-arle aneke arrekwele. Unte kwenhe atyenge ahele-irremele aywepeke.” ");
INSERT INTO aer_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Itne Isaac-eke angkeke, “Anwerne kwenhe ngenhe arrule arepareme, kele anwerne itelareme YAHWEH-elarle ngenhe arntarnte-areme. Anwerne imerte angkerremele, ‘Alhetyekaye Isaac aretyeke, anwerne angkerretyeke alheye apmere uthene kwatye nhenhe uthene-akerte, anwerne ipeltye-irremele anteme anetyenhenge, ilterretyale atwerretyale-arlke anetyeke, kele nterte mwerre anteme anetyeke.’ Alakenhenge kwenhe anwerne-arle ngenhe aretyeke apetyeke. ");
INSERT INTO aer_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Anwerne kwenhe ngkwengenge atwerretyakenhe. Anwerne kwenhe akwetethe mwerre aneke ngkwenge, anwerne imerte ngenhe atwerretyakenhele ware yernemele. Anwerneke alhilelhe unte-arle anwernenge atwerretye-kwenye. Kele lyete akenhe YAHWEH ngkwenge mwerre anthurre-arle aneme ngenhe arntarnte-aremele, lterrke-ilemele.” ");
INSERT INTO aer_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Kele, Isaac-ele merne mwerre mpwaremele iteke itneke ingkirrekele arlkwemele antywemele anteme. ");
INSERT INTO aer_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Arlte arrpenhele anteme, itne uternelherreke arne akngele iwenhe apeke ikwere awethe atwerretyale anetyeke. Ngkartele itnenhe alakenhe mpwarerlenge areke. Kele Isaac itneke artwaremele angkeke kele itne alperlenge anteme. Kele itne atyewe nhenge mwerre anteme aneke. ");
INSERT INTO aer_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Arlte ikwerele, urrkapentye akngerre Isaac-kenhe areye apetyalpemele ikwere angkeke, “Anwerne kwatye ngentye tnyeke, imerte kwatye aremele!” ");
INSERT INTO aer_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Kele, Isaac-ele kwatye ngentye renhe arritnye anthemele “Shibah.” Lyete ulkere itne apmere renhe arritnye ileme “Beersheba,” alakenhe ileme “Apmere anwerne-arle uternelherreke.” ");
INSERT INTO aer_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Kele year 40-pele anteme aneke alere Isaac-kenhe Esau-eke, re arelhe atherre ineke anewe ikwere-arrpe. Arrekwele iperre kenhe arritnye aneke Judith. Re ampe Beeri-kenhe aneke, Re akenhe aneke tyerrtye “Hittite” areyeke. Arelhe arrpenhe akenhe arritnye aneke Basemath-arle. Re akenhe ampe Elon-kenhe. Re akenhe Hittite-ante-arlke. ");
INSERT INTO aer_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Arelhe nhenhe atherrele, Esau-ele ineke-arle, ratherre Isaac uthene Rebekah uthene akangkentye mpwaretyakenhele renhe-atherrenhe urewampe anthurre ileke. ");
INSERT INTO aer_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac artwe ampwe anthurre anteme irreke. Alknge atherre akenge anteme irreke, re aretyakenhe anteme aneke irrkaye-irrkaye ware. Yanhe-ngentyele, re ileke tyerrtye anyente alhetyeke alere akngerrepate ikwerenhe Esau inetyeke. Kele Esau re apetyeke, Isaac ikwere angkeke, “Atyenge alere.” Esau angkirtneke, “Wertaye?” ");
INSERT INTO aer_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Kele Isaac ikwere angkeke, “Kele ayenge artwe ampwe anthurre anteme, ayenge apeke-arle ilwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Alhaye irrtyarte ngkwinhe inetyeke imerte ulyenye alhemele. Kere atwetyeke alhaye the arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Unte apetyalpemele kere itetyeke ayenge-arle ahentye-aneme ulkere imerte itemele ayenge anthemele the arlkwetyeke. Kele tharle kere arlkweke iperrenge, the ngkwenge anteme antheme arne atyinhe areye ngkwinhe anteme anetyeke. Ayenge ngkwenge alyelhetyenhe arne mwerre areye-akerte ngkwenge-arle mpwaretyenhe alakenhe urreke irretyenhe ngkwenge. The alakenhe mpwaretyeke ayenge ilweketyenge.” ");
INSERT INTO aer_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Kele, Esau alheke, ulyenye unthetyeke. Nhenge Isaac-arle alakenhe angketyamenge Esau-eke, ratherre itirreke ratherre akwele atherre-arrpe-arle akwele aneke ratherre-arle angkerretyamenge. Kenhe Rebekah-ele akenhe itwenge awetyame nterte-ntertele, ratherre apale aneke rarle itwele tnetyamenge akethele, arrangkwe. ");
INSERT INTO aer_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebekah alheke ampe arrpenhe Jacob-eke iletyeke, “Aye, the awerne akngeye ngkwinhe angkerlenge kake ngkwinhe Esau-eke. ");
INSERT INTO aer_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","Re Esau ileke ikwere ulyenye alhetyeke, nhenge re apetyalpemele kere mwerre itetyeke. Re Esau-eke angkeke, ‘YAHWEH-ele ayenge ayeye mwerre antheke, nhenge urreke ayenge ilwetyenhenge ayenge ngkwenge alyelhetyenhe unte ngkwenge akwete-ante atnyenetyenhenge.’ Alakenhe-arle re Esau-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Kele ayenge anteme awe, atyenge akangkwe-irraye ayenge ngkwenge angkerlenge. ");
INSERT INTO aer_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Apmere nhenge-werne alhaye urrkapentye akngerre areyele-arle yepe-yepe areye arntarnte-areme-werne nanikute atherre inaye, atyenge akngetye-alpemele the itetyenhe Isaac-ele arlkwenhe-arlkwenhe-arteke. ");
INSERT INTO aer_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Imerte akngemele akngeye ngkwinhele kere nhenhe arlkwetyeke. Kele, urreke re ilwetyenhenge re alyeme ngenhe kake ngkwinhe kwenye mwerrele. Unte akwete-ante atnyenetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Kenhe Jacob angkeke meye ikwerenheke, “Urrekaye, Urrekaye! Kake atyinhe Esau-arle alte akngerre anthurre-arle. Ayenge-arle yenpe urlkere-arle alte kwenye-arle! ");
INSERT INTO aer_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Akngeye atyinhele apeke ayenge anpemele, kele re itele-arle-areme ayenge Esau kwenye-arle! Kele re ayenge angkentye mwerre arne areye anthetyeke arrangkwe-arle, arrangkwe anthurre. Re ayenge alyemele apale-arle atyenge angkeme tharle renhe ularele ilekenge!” ");
INSERT INTO aer_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Meye ampe ikwerenheke angkeke, “Akngeye ngkwinhele apeke ngenhe alyerlenge, kele re ayenge anyente-ante alyetyeke unte-arle apale irrekenge. Kele ayenge-ante awaye, nanikute atherre inetyeke alhaye.” ");
INSERT INTO aer_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Kele, Jacob alheke nanikute akweke atherre inetyeke. Re renhe-atherrenhe akngetye-alpeke meye ikwerenhe-werne. Rebekah-ele ngkweltye-ngkweltye-ileke kere renhe, imerte mwerrantye anthurre itemele Isaac-ele arlkwentye akngerre-arteke akwete. ");
INSERT INTO aer_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Kele, Rebekah alheke mantere Esau-kenhe inetyeke mwerre akngerre areye apmere kwenele-arle anetyarte areye. Kele mantere renhe antheke irrpetyeke. ");
INSERT INTO aer_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Kele re iltye Jacob-kenhe imartiweke nanikute altele ite urlkere-arlke imartiweke re anpetyenhenge alte akngerre anthurre renhe kake ikwerenhe-arteke. ");
INSERT INTO aer_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Re imerte Jacob merne uthene kere uthene-akerte yernemele rarle itemele Jacob-ele akngeye ikwerenheke akngetyeke. ");
INSERT INTO aer_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Jacob-ele kere uthene merne uthene akngeke akngeye ikwerenheke imerte angkemele, “Akngeye-aye.” Isaac-eke ikwere angkirtnerlenge, “Angwenhe-ame unte, Esau apeke Jacob apeke, angwenhe-aye?” ");
INSERT INTO aer_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Jacob-ele renhe tyerneke, “Ayenge-arle Esau-arle akngerrepate ngkwinhe. Ayenge ulyenye alheke, the ngkwenge kere akngetyeke, unte-arle ayenge ileke-arteke. Akeme-irraye kere nhenhe arlkwetyeke, the ulyenyenge akngetye-alpeke. Unte atyenge alyelheme arne mwerre areye-akerte tharle inetyeke, atyenge-arle urreke irretyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Kenhe Isaac-ele renhe apayuthneke, “Nthakenhe-ame unte kere ineke, nthakenhe-arle iparrpe ware?” Jacob ikwere angkirtneke, “YAHWEH-ele atyenge imerneke nthenheke kere atwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Kele Isaac Jacob-eke angkeke, “Alere, itwe-irraye, the ngenhe anpetyenhenge. The ngenhe anpemele, kele the itelareme unte arratye-arle alere Esau atyinhe.” ");
INSERT INTO aer_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Kele Jacob angathe-irreke akngeye ikwerenhe itwele. Isaac-ele renhe anpemele angkeke, “Unte angkeme Jacob-arteke, kele the ngenhe anpemele kele unte amulte Esau-arteke alte akngerre-arle.” ");
INSERT INTO aer_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Kele, Isaac-ele renhe alhengke-aretyakenhe aneke rarle amulte alte akngerre anekenge kake ikwerenhe Esau-arteke. Nhenge Isaac-ele renhe anpeke re itirreke Esau-eke-athene. Kele Isaac ikwere angkeke, “Nhenge apeke-arle Esau-arle amulte alte akngerrenge, kele lyete, urreke ayenge ilwetyenhenge, the ikwere iletyenhenge arne mwerre areye-arle ikwere anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Urreke re ikwere arne mwerre areye-akerte alyelhetyenhenge, re anyente-ngare awethe apayuthneke, “Unte arratye alere atyinhe Esau-arle?” Jacob angkirtnerlenge, “Yewe, ayenge Esau-arle.” ");
INSERT INTO aer_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Kele Isaac ikwere angkeke, “Kele mwerre, atyenge alere! Kere awethe atyenge akngetyaye the arlkwetyeke, the ngenhe angkentye mwerre atyinhe anthetyenhenge.” Kele Jacob-ele kere awethe akngetyemele Isaac-eke, kele re arlkwemele, ngkwarle antyweke-anteye. ");
INSERT INTO aer_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Kele akngeye ikwerenhe Isaac angkeke ikwere, “Angathe-irraye, the ngenhe arrwantyetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Kele, Jacob apetyemele renhe arrwantyeke. Isaac-ele renhe ntyerneke mantere Esau-kenhe, kele re ikwere mwerrantye angkeke Jacob-eke. Re alakenhe alyelheke, “Aye! Alere atyinhe mwerre anthurre ntyeme apmere nthenhele-arle YAHWEH-arle apetyeke-ngentyele-arteke atherrke-arle mwerrantye anemenge-arteke! ");
INSERT INTO aer_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","“The Ngkarte apayuthneme ngkwenge-akerte kwatye akngerre yernetyeke re arne areye lyapelhe-iletyenhenge. Kele unte annge atningke anteme inetyenhenge arne re lyaperlenge, kele annge areye lyaperlenge, kele unte ngkwarle antywemele merne arlkwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","“The Ngkarte ngkwenge-akerte apayuthneme Re ngenhe tyerrtye apmere arrpe-anenheke akngerrepate arrernetyeke. Itne apetyemele ngkwenge artepe arrernelhemele itne ngenhe akngerrepate anteme ileme. The Ngkarte apayuthneme unte kake akweke ngkwinhe areyeke akngerrepate anetyeke. Alere meye ngkwinhe-kenhe areye ngkwenge artepe arrernelhetyenhe. Angwenhele ngenhe akurne-ilemele ilyentye akngerre, Ngkartele renhe atwetyenhenge. Angwenhe apeke ngkwenge mwerre aneme, Ngkarte itneke-arle mwerre anetyenhe.” Alakenhe-arle Isaac alyelhetyame, re anteme Jacob angkentye ingkirreke mwerre antheke. Re apale itirreke Jacob-arle Esau akwele anekeke. Kele Jacob-ele akngeye ikwerenhe iparrpele imperle-alheke. ");
INSERT INTO aer_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Kele Jacob-arle alhekenge, kake ikwerenhe Esau apetyalpeke ulyenye-ngentyele. ");
INSERT INTO aer_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Re kere akemele akngetyeke itemele akngeye ikwerenheke. Esau ikwere angkeke, “Akngeye-aye, akeme-irraye kere nhenhe arlkwetyeke tharle ngkwenge atwetyeke alheke, kele unte angkentye mwerre atyenge anthetyenhenge akwete-ante atnyenetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Kele renhe akngeye ikwerenhe Isaac-ele apayuthneke, “Kele angwenhe-ame unte?” Esau angkirtnerlenge, “Ayengeyaye, Esau!” ");
INSERT INTO aer_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Nhenge Isaac-ele nhenhe aweke arteke, re arrewetyeke anteme irreke. Re Esau apayuthneke, “Aye, angwenhe anteme yanhe ulyenye atyenge alheke? Angwenhele ayenge kere antheke urreke unte apetyetyenhenge? The kwenhe kele kere arlkweke, the anteme artwe renhe angkentye mwerre antheke. The angkentye renhe inirtnetyeke arrangkwe anteme-arle ngenhe anthetyeke, arrangkwe! Arne mwerre nhenge areye-arlke, angkentye ikwerenge anetyenhe artwe arrpenhe ikwere anteme.” ");
INSERT INTO aer_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Nhenhe Esau-ele aweke, re arnterre anthurre artneke, re ahele anthurre awelheke imerte akngeye ikwerenheke angkemele, “Akngeye-aye! Ayenge-arle-artaye? Ayenge-arlke alyaye mwerre areye atyenge irretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Kele Isaac akenhe ikwere alakenhe-arle angkerlenge, “Ngkwenge atyeyele atyenge ularele iletyeke apetyeke. Re akwele kele angkentye mwerre renhe ineke ngkwenge-ketye.” ");
INSERT INTO aer_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esau anteme angkeke akngeye ikwerenheke, “Arritnye Jacob-kenhe-arle, “Akwetethe-arle ularele ilentye akngerre-arle.” Arratye apelaye. Re kwenhe ayenge atherre-ngare ularele ileke. Arrule re ayenge uterneke arne areye ngkwinhe anthetyeke ikwere unte ilwerlenge. Kele lyete akenhe re angkentye mwerre ngkwinhe akngeke atyenge-ketye!” Kele Esau-ele ikwere-artweye apayuthneke, “Atyenge ilaye, arne mwerre apeke atyenge-werne irretyenhenge?” ");
INSERT INTO aer_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Isaac ikwere angkirtneke, “Tharle renhe kele-arle akngerrepate-arlke mpwareke ngkwenge-arlke-arle re akngerrepate. Kake akweke ikwerenhe areye-arle ikwere-arle urrkapetyenhe, the kwenhe ikwere arne atningke-arle arratye ileke, merne-arlke ngkwarle-arlke akngerre. Atyenge alere-aye, tharle ngkwenge arne apeke awethe anthetyeke arrangkwe-arle. The arne awetheke arrangkwe atnyeneme ngenhe anthetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Kele Esau akenhe renhe akwete anthurre akayake-ileke, “Unte apeke-arle arne mwerre anyente arrpenhe-arle atnyeneme ayenge anthetyeke. Akngeye-aye, mwerre anyente ware ayenge anthaye! Atyenge ilaye atyenge-arle arne mwerre areye anetyenhenge?” Yanhenge, Esau arnterre artneke. ");
INSERT INTO aer_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Kele Isaac-ele ileke Esau-eke nthakenhe-arle ikwere irretyenhe. Isaac alakenhe alyelheke, “Unte kwenhe apmere irntwarre anthurrele anepanetyenhe apmere mwerre-ketye kwatye-arlke-arle akweke anthurre aneme ikwerele. ");
INSERT INTO aer_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Unte kwenhe tyerrtye arrpenhe areyenge-arle akwetethe atwerrerle-anetyenhe irrewe ngkwinhe areyele arrpenhe itnenhe atwerlte-anetyenhe, unte kwenhe ngkwinhe atyeyeke urrkaperle-anetyenhe, ayernentye akngerre-arteke. Kele unte ikwere-ketye untetyeke irreme, re ngenhe ipmentyele-arle areme, rarle ngenhe ayaketyeke kwenhe, arrangkwe-arle.” ");
INSERT INTO aer_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Yanhe-ngentyele, Esau Jacob-eke ahentye anetyakenhe anteme aneke re angkentye impene akngeye ikwerenhe-kenhe ularele ilemele inekenge. Esau re-arrpe-arle nterte-nterte itirreke, “Akngeye atyinhe ingwenthe warele ilwetyenhe ayenge alhwarrpe awelheme ikwere. Kele the Jacob-arle atwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Kenhe tyerrtye arrpenhele akenhe Rebekah-eke ileke Esau-arle aperteke Jacob renhe atwetyeke. Rebekah-ele anteme yerneke tyerrtye anyentele Jacob inetyeke alhetyeke. Kele re apetyalpeke, Rebekah ikwere angkeke, “Ayenge awaye, kake ngkwinhe Esau ahele anthurre awelheme. Re kwenhe nterte-nterte itirreme nthakenhe ngenhe iletyeke atwemele. ");
INSERT INTO aer_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","45","Esau-ele ngenhe lyete apeke atwemele, kele tyerrtye arrpenhele-arle renhe atwetyenhe, the apeke mpwele aparlpe-iletyeke. Alakenhe irreme-ketye kake atyinhe aneme apmere Haran-ele Laban arritnye, apmere nhenhe impemele iparrpe alhaye re ngenhe arntarnte-aretyenhenge! Ikwerele urreke anaye kake ngkwinhe ahele kwenyenge akwete, re ngkwengenge atwerretye-kwenye anetyenhenge. Urreke anteye kake ngkwinhe ngkwenge ahentye-anetyeke arrangkwe. Re alkngwirreme anteme unte-arle ikwere arne areye inekenge. Kele the urrkapentye akngerre anyente anteme ngkwenge yerneme unte apetyalpetyeke ikwere-werne.” ");
INSERT INTO aer_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Kele Rebekah anewe ikwerenhe Isaac-eke angkeke, “Ayenge ahentye-anetyakenhe arelhe Hittite apmere nhenhe-arenye areyeke. Ampe ilerne-kenhe Esau-ele kele arelhe Hittite akurne atherre anewe akeke. Kele Jacob-ele apeke arrpenhe anewe akemele, kele ayenge ilwetyeke ahentye-aneme ayenge-arle itneke ahentye anetyakenhe anthurrenge.” ");
INSERT INTO aer_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Kele Isaac-ele yerneke Jacob inetyeke alhetyeke ikwere-werne apetyetyeke. Jacob apetyemele ilthe kwene-werne irrpenheke, Isaac ikwere angkeke renhe lterrke-iletyeke: “Arelhe apmere nhenhe Canaan-arenye areye anewe aketyale. ");
INSERT INTO aer_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Nhenhe-tetye mpwaraye. Kele iparrpe alhaye apmere Paddan-Aram-werne, apmere nthenhele-arle atyangkwe Bethuel-arle aneme-werne. Ayenge ahentye-aneme unte-arle marle meyeke-artweye areye-ngentyele anewe aketyeke. Pmarle Laban-ele marle wenke areye atnyeneme. Yanhe areye-ngentyele ngkwenge anewe inaye.” ");
INSERT INTO aer_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Kele Isaac alereke alakenhe angkeke, “Ngkartele, ngangkere arne arrpe-anenhele atnyenemele, ngkwenge arratye-arratye mpwaretyeke arne areye mwerre ngkwenge anetyeke. Re ngkwenge mwerre aneye, unte-arle ampe atningke atnyenetyenhenge Ikwerenge ularre ware. Lyete the ngenhe ngkwenge alakenhe apayuthneme. Kele urreke ngkwinheke-artweye areye atningke-ame-atningke-irretyenhe apmere arrpe-anenhe-werne anteke-irremele anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","The ngenhe ngkwenge apayuthnetyenhe ampe ngkwinhe areye arntarnte-aretyeke ngenhe-arlke ampe ngkwinhe areye-arlke lterrke-iletyeke arrenge-arrenge ngkwinhe arntarnte-areke-arteke. Ngkartele arrenge-arrenge ngkwinhe Abraham ahelhe nhenhe alhilemele anthetyeke, ikwerenheke-artweye areye-arlke. Kenhe lyete unte apmere nhenhele anepaneme ipenye-arteke. Urreke-arle Ngkartele ngenhe ingkirreke anthurre anthetyenhe rarle arrenge-arrenge ngkwinhe alhileke. Ahelhe nhenhe ngkwenge anetyenhe, ngkwenge-artweye areyeke-arlke, rarle alhileke-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Kele Isaac-ele Jacob yerneke. Kenhe Jacob imperle-alhemele alheke apmere Paddan-Aram-werne apmarleye ikwerenhe Laban-arle anetyarte-werne. Laban-arle kake akngerrepate Rebekah-kenhe aneke. Akngeye itnekenhe Bethuel-arle aneke, re akenhe apmere Aramea-elarle anetyarte. Rebekah akenhe meye aneke Jacob uthene Esau utheneke. ");
INSERT INTO aer_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esau-ele aweke-arle iperre, Isaac-elarle Jacob-eke mwerre alyelheke, renhe yernemele Paddan-Aram-werne anewe akwele inetyeke. Esau-ele awethe aweke Isaac-ele-arle Jacob ilekenge arelhe Canaan-arenye inetyale. ");
INSERT INTO aer_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Esau-ele aweke anteye Jacob-arle ikwere-artweye atherre akangkwe-irrekenge imerte alhemele apmere Paddan-Aram ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Alakenhenge-arle Esau-ele itelareke akngeye ikwerenhe-arle ahentye-anetyakenhe aneke arelhe atherre Canaan-arenyeke re kele anewe akeke arrekwele-arle. ");
INSERT INTO aer_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kele Esau arelhe arrpenhe anewe aketyeke anteme-arle itelareke. Nhenhenge anteme re alheke kake akngeye ikwerenhe-kenhe Ishmael-werne anteme imerte marle wenke ikwerenhe Mahalath anteme anewe akemele. Re akenhe yaye aneke Neboiath-ekarle, arrenge-arrenge Abraham-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Ayeye nhenhe Jacob-akerte rarle apmere ikwerenhe impeke apmere Paddan-Aram-werne alhemele. Nhenge Jacob-ele apmere ikwerenhe Beersheba imperle-alhemele, Haran-werne atheke. ");
INSERT INTO aer_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Ingwe arrpenhele anteme, mpwepele alhepalhemele, uterne-arle irrpekenge anteme, re inteke anteme. Re apwerte aremele ineke rtunke imerte arrernemele kele re ankwe-irreke. ");
INSERT INTO aer_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Re imerte altyerre anteme aremele, re areke iwerre akertne-werne atheke alherlenge apmere Ngkarte-kenhe-werne. Jacob-ele utnenge alkere-arenye areye areke alkere-ngentyele atnarnpemele iwerreke arnpemele apetyewarremele, kele awethe itne akertne-werne-atheke alperlte-iwemele. ");
INSERT INTO aer_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Re imerte akertne-atheke aremele Ngkarte akertne anthurrele tnerle-anerlenge iwerre ikwerenge! YAHWEH imerte Jacob-eke angkemele, “Ayenge-arle YAHWEH-arle Ngkarte anyente re arrenge-arrenge ngkwinhe Abraham-elarle apentetyarte, utyernemele tnakeke. Ayenge-arle anyente rarle akngeye ngkwinhe Isaac-elarle apentetyarte, utyernemele tnakeke rarle. Ahelhe nhenhe unte interlenge, The ngenhe antheme ampe ngkwinhe areye-arlke, itne-kenheke akwerrke areye-arlke. ");
INSERT INTO aer_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tyerrtye itne atningke anthurre irretyenhe yerre areye-arteke. Itne irrarnpe-irretyenhe alturle-atheke ikngerre-atheke ayerrere-atheke imerte antekerre-atheke anteme. Unte ngkwinhe areye-arlke Atyenge akangkwe-irremele areye-arle, ngkwengenge ularre ngkwenge akwerrke areyenge, The itnekenge arne mwerre areye mpwaretyenhe tyerrtye arrpe-anenheke apmere ahelhe nhenhele. ");
INSERT INTO aer_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ayenge nhenhele ngkwenge aneme, The ngenhe arntarnte-areme nthenhe-werne apeke-arle unte alhemenge. The ngenhe apmere ahelhe nhenhe-werne urreke akngetye-alpeme. The ngenhe impetyeke arrangkwe-arle. The ngenhe alhileke ipenhe, unte-arle inetyenhe-arle Atyengenge ularre.” ");
INSERT INTO aer_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","17","Kele Jacob iparrpe akeme-irreke anteme altyerrele re areke iperre. Re atere-irreke apatemele re-arrpe angkeke alakenhe, “Arratye anthurre apelaye, YAHWEH-arle nhenhele aneme, tharle alakenhe arrekwele itelaretyakenhe! Apmere ameke-ameke nhenhele-arle ayenge aterele-arle-antheme! Nhenhe kwenhe apmere Ngkarte-kenhe, iwerre nhenge apmere Ngkarte-kenhe akertne-werne-arle alpeme.” Re imerte ankwe anteme iwelhirtnemele. ");
INSERT INTO aer_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Ingwe athnele anteme, Jacob akeme-irreke. Re apwerte nhenge ineke rarle rtunke inteke, re imerte ahelheke ngkernemele, re imerte antere anteme thelemele Ngkarteke angkemele. ");
INSERT INTO aer_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Jacob-ele apmere renhe arritnye antheke “Bethel,” alakenhe ileme “Apmere Ngkarte-kenhe.” Arrekwele, tyerrtye areyele iletyarte “Luz.” ");
INSERT INTO aer_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nhenge Jacob-arle tnetyamenge re Ngkarteke angkentye akngerre nhenhe alhileke, “The Ngkarte apentetyeke ahentye-aneme, ayenge ahentye-aneme re ayenge arntarnte-aretyeke akurne-ketyenge-arlke ayenge alethe alhemenge. Ayenge ahentye-aneme re ayenge merne-arlke kere-arlke anthetyeke, mantere-arlke. ");
INSERT INTO aer_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","Kele, ayenge atnerte atyenpe irretye kwenye anetyeke akngerre itirretyale anteye. Urreke anteme ayenge akngeye atyinhe kenhe apmere-werne apetyalpetyenhe anetyeke anteme. YAHWEH-arle atyinhe anetyenhe akwetethe anthurre anteme. ");
INSERT INTO aer_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Apwerte nhenhe-arle apmere anetyenhe nthenhele-arle tyerrtye areye apetyewarretyenhenge anetyenhe Ngkarte renhe utyernemele tnakewarretyeke anetyenhe. Ngkarteke the imerneme ayenge-arle akangkentye anthurre-arle aneme. Iwenhe apeke-arle the ineme, the arne yanhe areye apurtelhe-ilemele yakwethe ten-peleke kwernemele, kele yakwethe anyente anteme the Ngkarte anthetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Apmere Bethel-engentyele Jacob akwete alheme apmere Haran-werne atheke. Yanhe-ngentyele, re apmere ikwere irrpenheke tyerrtye atningke-arle anetyame-werne, itnarle itnenhene aketyarte ikngerre-arenye areye. ");
INSERT INTO aer_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Re apmere yanheke irreme, re kwatye ngentye aretye-alheke. Apwerte akngerre-arle kwatye ngentye renhe akertne arteke. Kenhe yepe-yepe areye akenhe urlerteke-urlerte interrirretyame apurte-apurte. Arlte arrpe-anenhele itne kwatye ngentye-werne antywetyeke alhetyarte. ");
INSERT INTO aer_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Arlte arrpe-anenhele, yepe-yepe arntarnte-arentye akngerre areyele itnenhe arntarnte-aretyarte apurtelhe-ilemele, yepe-yepe itnenhene itne kwatye anthetyeke akngetyarte. Yepe-yepe arntarnte-arentye akngerre areye anyente-irrerirremele itne apwerte akngerre renhe-arle itne anamelhe-iletyarte yepe-yepe itnekenhe kwatye anthetyenhenge antywetyeke. Kwatye-arle itne antyweke ipenhe, arntarnte-arentye akngerre areyele apwerte nhenge artirtnetyarte kwatye ngentye renhe. ");
INSERT INTO aer_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Jacob-ele yepe-yepe arntarnte-arentye akngerre areye apayuthneke “Nthenhe-arenye-ame arrantherre?” Itne angkirtnerlenge alakenhe, “Anwerne-arle apmere Haran-arenye-arle.” ");
INSERT INTO aer_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Yanhe-ngentyele Jacob-ele itnenhe apayuthneke, “Arrantherre-ame artwe Laban arritnyeke akaltye, arrenge-arrenge ikwerenhe, Nahor-arle?” Itne angkirtneke, “Ye, anwerne-arle ikwere akaltye-arle.” ");
INSERT INTO aer_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yanhe-ngentyele, Jacob-ele itnenhe apayuthneke, “Re-ame mwerre aneme?” Itne ikwere angkirtneke, “Ye, rarle mwerre-arle. Araye! Nhenhe-werne apetyerlenge ampe awenke ikwerenhe Rachel. Re yepe-yepe akngeye ikwerenhe-kenhe areye akngernerle-apeme.” ");
INSERT INTO aer_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Yanhe-ngentyele, Jacob itneke angkeke, “Urrekaye! Uterne akertne akwetenge. Ingwe-arlke irretyakenhe akwete yepe-yepe areye ankweke athenetyale. Kwatye-arlke itnenhe anthaye ikwere ipenhe imerte itnenhe akngirtnemele atherrke anteme arlkwetyeke angwerre-angwerre irretyeke.” ");
INSERT INTO aer_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Kenhe itne akenhe alakenhe-arle angkerlenge, “Anwerne-arle kwenhe yepe-yepe areye kwatye antywetyeke anthetyakenhe akwete, anwerne kwenhe akarelhemele yepe-yepe arntarnte-arentye akngerre arrpenhe areyeke itne-arle yepe-yepe arrpenhe areye-arle akngetyemeke. Yanhe-ngentyele anwerne ingkirreke apwerte nhenhe anamelhe-iletyenhenge yepe-yepe areyele kwatye antywetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Jacob-arle yepe-yepe arntarnte-arentye akngerre areyeke angketyamenge, Rachel apetyeke yepe-yepe anyikwe-kenhe areye uthene nanikute areye uthene-akerte. Re akenhe yepe-yepe arntarnte-arentye akngerre anteye-arle. ");
INSERT INTO aer_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Jacob-ele renhe areke arteke, re kwatye ngentye ikwere-werne alheke, imerte apwerte akngerre renhe anamelhe-ilemele imerte yepe-yepe areye uthene nanikute areye uthene kwatye anthemele, Rachel akenhe altyeleye ikwere-arle aneke, ampe pmarle-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yanhe ipenhe re alhemele Rachel arrwantyeke, re imerte arrangkemele rarle akangkentye anthurre-arle awelhekenge ikwerenhe areyenge apmereke irretye-alheke. ");
INSERT INTO aer_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Yanhe iperre anteme re Rachel-eke ileke, “Ayenge kwenhe altyelangkwe ngkwinhe. Rebekah meye atyinhe re yaye Laban-kenhe.” Yanhe-ngentyele, Rachel apmere-werne untemele akngeye ikwerenheke iletyeke. ");
INSERT INTO aer_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Nhenge Laban-ele ayeye Jacob-akerte aweke alere atyeye-kenhe-arle, re ikwere arnekarnare irreke. Laban-ele Jacob akwaketye-akemele Jacob renhe arrwantyeke arrelyennge atherre-ante. Re anteme renhe apmere ikwerenhe-werne akngirtneke. Yanhenge Jacob angkeke Laban-eke ilelhemele-arlke. ");
INSERT INTO aer_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laban ikwere angkeke, “Unte kwenhe ampatye atyinhe, unte kwenhe alhwe anyente-ngentyele tyerrtye anyente-ngentyele.” Arratye anteme, Jacob aneke Laban-enge atnyentye anyenteke ikwere urrkapemele. ");
INSERT INTO aer_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Yanhe-ngentyele, Laban angkeke Jacob-eke, “Unte kwenhe ampatye atyinhe. Kenhe unte apeke atyenge urrkaperlenge, kele the ngenhe pay-eme-ileme iwenhe apeke ikwere unte-arle ahentye-aneme renhe. Iwenhe-ame the ngkwenge antheye unte atyenge urrkaperlenge?” ");
INSERT INTO aer_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Kenhe Laban-ele akenhe ampe marle atherre atnyeneke. Marle akngerrepate ikwerenhe Leah arritnye aneke, kele ikwere atyeye akenhe Rachel-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","18","Leah-arle mwerre akngerre anetyakenhe, alknge alernnge-alernnge irrerle-anetyakenhe-arle. Kenhe Rachel akenhe mwerre arrpenhe-ulkere-arle aneke, Jacob akenhe ikwere-arle ahentye anthurre aneke. Yanhe-ngentyele, re Laban apayuthneke, “Kele mwerre-ame unte atyenge marle ingkernenye ngkwinhe Rachel antheme? Ayenge apeke ngkwenge year seven-peleke-atwetye urrkapetyeke, yanhe ikwerenge unte renhe ayenge anthetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laban ikwere kele yewe angkeke imerte renhe ilemele, “Kele mwerre-arle alakenhe. Kenhe unte apeke Rachel impemele, renhe inetyakenhe-arle, kele re artwe arrpenhe-arle ineme ayenge-arle ahentye-anetyakenhe. Ayenge ahentye-aneme unte renhe anewe aketyeke unte atyengenge anerle-anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Yanhe-ngentyele, Jacob urrkapeke Laban-eke year seven-pele anthurreke-atwetye Rachel anewe aketyenhenge. Re akenhe itirreke year seven-pele itne-arle akweke ware athene rarle marle ikwere arnterre anthurre-arle ahentye-anekenge. ");
INSERT INTO aer_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Ikwere ipenhe, year seven pele-arle anteme urrkapeke ipenhe, Jacob Laban-werne alhemele angkeke, “Kele mwerre-arle alakenhe. Ayenge-arle year seven-peleke-arle urrkaperle-aneke unte-arle atyenge uternelhekenge. Rachel ayenge anthaye the renhe anewe aketyenhenge.” Laban ikwere yewe angkeke. ");
INSERT INTO aer_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Yanhe-ngentyele, Laban-ele ikwerenhe areye apurtelhe-ileke, itne anteme merne uthene kere uthene apurtele arlkwerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","24","Ingwe ikwerele itne-arle merne arlkweke ipenhe, Laban-ele Rachel akngetyetyakenhe aneke Jacob-eke. Ikwerenge akenhe re-tetye Leah-arle akngetyeke, marle akngerrepate ikwerenhe-arle ilthe Jacob-kenhe-werne. Ingwemertenge Jacob apale itirreke Rachel-eke akwele, re anteme ikwerenge inteke. ");
INSERT INTO aer_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Ingweleme anteme Jacob apateke anthurre. Rarle itirreke re akwele Rachel-enge-arle intekeke-athene, kele Leah-enge-arle akenhe re inteke. Yanhe-ngentyele anteme re Laban-eke anteme angketyeke alheke, “Aye, nthakenhe-ame unte atyenge irreke? Iwenhenge-ame unte atyenge urrtyirremele ileke alakenhe? Ayenge-arle ngkwenge arnterre anthurre-arle urrkapeke the Rachel akwele anewe aketyenhenge, Leah kwenye.” ");
INSERT INTO aer_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laban ikwere angkirtneke, “Unte kwenhe itelaretyakenhe nthakenhe-arle anwerne apmere nhenhenge mpwareme. Apmere anwerne-kenhenge-arle yaye akngerrepate anewe akeme marle ingkernenye arrekwele, alakenhe-arle angkentye anwerne-kenhe. ");
INSERT INTO aer_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Leah-enge anaye week anyenteke arrawe-irrentye akngerrele-ureke unte renhe anewe anteme aketyenhenge, yanhe-ngentyele kele the ngenhe Rachel anteme anthetyenhe anewe aketyeke. Kenhe unte apeke Rachel anewe akemele, ayenge ahentye-aneme unte atyenge year seven-pele awetheke urrkapetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yanhe-ngentyele, Jacob yewe angkeke Laban-eke imerte Leah-enge anemele week anyenteke. Yanhe-ngentyele, Laban-ele Rachel anteme renhe antheke anewe aketyeke. ");
INSERT INTO aer_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","30","Jacob anteme alheke intetyeke anewe ikwerenhe Rachel-enge. Rarle Leah-eke akweke ware-arle ahentye-aneke. Re akenhe Rachel-eke-arle arnterre ahentye-aneke. Yanhe-ngentyele anteme Re Laban-eke year seven-pele awetheke urrkapeke. Kenhe Laban-ele Leah arelhe urrkapentye akngerre antheke, Zilpah arritnye. Ikwere iperre, Laban-ele arelhe anyente Rachel antheke Bilhah arritnye urrkapentye akngerre ikwerenhe. ");
INSERT INTO aer_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Ikwere ipenhe Jacob-ele Rachel anewe akeke ipenhe, YAHWEH Ngkartele areke rarle Rachel-eke arnterre ahentye-aneke, Leah-eke kwenye. Yanhe-ngentyele re ahentye-aneke Leah ampe anthetyeke. Re mwantye-mwantye itirreke Leah-akerte rarle ampe renhe anthetyeke. Kele ikwere atyeye akenhe ampe atnyenetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Leah atnerte-atnerte-irreke imerte ampe urreye akweke atnyenemele. Yanhe-ngentyele anteme re angkeke, “YAHWEH mwantye-mwantye itirreke atyenge ayenge-arle irrare anekenge atyenge anteme re ampe urreye antheke. Kele atyenge anewe anteme atyenge itirretyenhe.” Alakenhenge anteme, Leah-ele alere ikwerenhe Reuben arritnye antheke. Arritnye Reuben ileme “Ampe urreye atyinhe araye!” ");
INSERT INTO aer_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Yanhe-ngentyele, Leah awethe atnerte-atnerte-irreke, re imerte ampe urreye arrpenhe anteme atnyenemele. Yanhe-ngentyele, re angkeke, “YAHWEH-ele ayenge aweke atyenge anewe atyinhe-arle ahentye-anetyakenhe akwetenge alakenhenge anteme ayenge YAHWEH-ele ampe urreye antheke.” Alakenhenge anteme Leah-ele ampe urreye ikwerenhe Simeon arritnye antheke. Arritnye Simeon ileme “Re ayenge aweke.” ");
INSERT INTO aer_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Yanhe-ngentyele, Leah awethe atnerte-atnerte-irreke, re imerte ampe urreye arrpenhe atnyenemele. Ikwere ipenhe re-arrpe angkeke, “The kwenhe anewe atyinhe ampe urreye urrpetye antheke kele ayenge apeke re angathe arntwirrkeme anteme apeke.” Alakenhenge anteme re ampe urreye ikwerenhe Levi arritnye antheke. Arritnye Levi ileme “Re Ayenge Angathe Arntwirrkeme.” ");
INSERT INTO aer_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ikwere ipenhe Leah-ele ampe urreye arrpenhe atnyeneke, re angkemele, “Lyete-ulkere ayenge Ngkarteke akangkemele tnaketyeke.” Akweke re akenhe Judah arritnye-arle, arritnye yanhele-arle ilemenge “Re Ikwere Akangkemele Tnakeme.” Alakenhe ikwerenge re ampe urreye ingkernenye ikwerenhe Judah arritnye antheke. Kele re ampe atyernetyakenhe anteme irreke. ");
INSERT INTO aer_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Ikwerele-ureke nhenge Leah-elarle ampe areye atnyeneke iperre, Rachel-ele akenhe ampe atnyenetyakenhe-arle ikwere anewe Jacob-eke. Alakenhe ikwerenge anteme re ingkerte-irreke yaye ikwerenheke re imerte Jacob-eke angketyeke alhemele, “Unte apeke atyenge ampe anthetyakenhe, kele ayenge itethe akwete anetyeke ahentye-anetyakenhe-arle!” ");
INSERT INTO aer_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Jacob ikwere ahele-irreke imerte ikwere angkemele “Aye, ayenge-ame Ngkarte? Arrangkwe-arle! Ngkartele-ante kwenhe ampe anthentye akngerre! Re akwele ngenhe ayakeme ampe atnyenetyakenhe, ayenge kwenye!” ");
INSERT INTO aer_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Rachel anteme ikwere alakenhe angkeke, “Nhenheyaye, urrkapentye akngerre atyinhe Bilhah akngaye imerte ikwerenge intemele. Re ampe ikwerenhe atnyenemele, re ayenge anthetyenhenge. Yanhenge anteme re atyinhe anteme aneme the renhe amangkelhe-iletyeke.” ");
INSERT INTO aer_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Yanhe-ngentyele, Rachel-ele Bilhah renhe antheke Jacob anewe akemele ikwerenge intetyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Bilhah re atnerte-atnerte anteme irreke re anteme ampe urreye akweke atnyenemele Jacob ikwere. ");
INSERT INTO aer_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Yanhe-ngentyele, Rachel angkeke, “Ngkartele arratye imerneke ayenge-arle arratye aneke. Re kwenhe atyenge akangkwe-irreke ayenge-arle angkekenge, nhenge rarle Leah-eke akangkwe-irreke-arteke, re anteme ayenge ampe urreye antheke.” Alakenhenge anteme Rachel-ele urreye akweke renhe Dan arritnye antheke. Arritnye Dan ileme “Re Ayenge Aremele Ayenge Arratye Akeke.” ");
INSERT INTO aer_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Yanhe iperre, Bilhah re awethe atnerte-atnerte-irreke re imerte ampe urreye akweke atnyenemele Jacob-eke. ");
INSERT INTO aer_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Rachel angkeke, “Ayenge akwetethe-arle yaye atyinhenge ahele akerreme ampe areye anewe atyinheke atnyenetyeke. The anteme impeme.” Alakenhe anteme Rachel-ele ampe urreye akweke renhe Naphtali arritnye antheke. Naphtali ileme “Re Ayenge Ayaketyeke Aneke.” ");
INSERT INTO aer_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Kele ampe urreye four-pele-arle atnyeneke iperre Leah-ele ampe awethe atnyenetyakenhe aneke. Alakenhe ikwerenge anteme re arelhe urrkapentye akngerre ikwerenhe Zilpah antheke Jacob rarle anewe ikwerenhe anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Ikwere ipenhe, Zilpah-ele ampe urreye akweke atnyeneke re Leah anthetyenhenge Jacob-eke anthetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Leah angkeke, “Alakenhe ware kwenhe arne mwerre areye atyenge irreke!” Alakenhenge anteme re ampe renhe Gad arritnye antheke. Arritnye Gad ileme “Atyenge-arle Mwerre-irreke.” ");
INSERT INTO aer_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Ikwere iperre, Zilpah-ele ampe urreye akweke arrpenhe atnyeneke Leah-eke re Jacob anthetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Leah angkeke, “Ayenge-arle lyete akangkentye anthurre aneme. Arelhe atningkele anteme ayenge akangkentye aketyenhe.” Alakenhe anteme, re ampe urreye akweke renhe Asher arritnye antheke. Asher ileme “Ayenge akangketyeke mpwareke.” ");
INSERT INTO aer_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Ikwere-arlke ipenhe anteme, tyerrtye apmere yanhe-arenye areyele merne inetyame, Reuben alheke itne-arle urrkapetyame ikwere-werne imerte arne akweke aremele itnarle ileme “mandrake areye” arlpelhe-akerte. Tyerrtye areye itirretyarte nhenge arelhele apeke mandrake renhe arlkwemele, arlpelhe areyele itnenhe alpe-eme-ilemele atnerte-atnerte-arle-irretyeke. Reuben-ele arne arlpelhe renhe ineke imerte meye ikwerenhe Leah-eke akngirtnemele. Rachel-ele areke re alakenhe mpwarerlenge imerte alakenhe Leah-eke angkemele, “Atyenge alhwarrpe-irraye, arne arlpelhe akweke ayenge anthaye urreye ngkwinhe-arle inekenge.” ");
INSERT INTO aer_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Leah angkirtneke, “Impaye! Unte kwenhe kele anewe atyinhe akngeke atyenge-ketyenge. Unte apeke urreye atyinhe kenhe arlpelhe mandrake areye akngetyeke-arlke ahentye-aneme, arlpelhe nhenge areyele ngenhe alpe-eme-ileme atnerte-atnerte-irretyeke!” Rachel ikwere angkeke, “Unte apeke ayenge arne arlpelhe urreye ngkwinhe-kenhe anthemele, kele unte lyete Jacob-enge inteme-arle lyete ingwele the ngkwenge arratye ileme.” Yanhe-ngentyele, Leah kele yewe angkeke Rachel-eke. ");
INSERT INTO aer_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Ingwe ikwerele, Jacob-arle urrkapentye iperre apmere-werne apetyalpeke, Leah alheke ikwere arnekarnare irremele. Re anteme Jacob-eke angkeke, “The Rachel arne arlpelhe antheke atnerte-atnerte irretyeke, Reuben atyenge urreyele-arle ineke areye. Ilerne kwenhe apurte inteme lyete ingwele.” Kele, ingwe ikwerele, Jacob Leah-enge inteke. ");
INSERT INTO aer_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Alakenhe urreke anetyenhenge, Leah-ele Ngkarte-arlke arrekwele apayuthnetyarte re atnerte-atnerte-irretyenhenge. Ngkartele renhe aweke angkerlenge, arratye re atnerte-atnerte-irreke awethe, re urreye arrpenhe atnyeneke. Kele re ampe urreye five-peleke-artweye aneke. ");
INSERT INTO aer_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Yanhe-ngentyele, Leah angkeke. “Ayenge kwenhe Ngkarteke angkeke atyenge ampe anthetyeke. The antheke arelhe urrkapentye akngerre atyinhe Zilpah re renhe anewe akemele atnyenetyeke. Alakenhenge anteme ayenge Ngkartele ampe urreye arrpenhe antheke.” Alakenhenge anteme Leah-ele ampe urreye ikwerenhe Issachar arritnye antheke. Issachar arritnye ileme “Re Ayenge Antheke.” ");
INSERT INTO aer_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Ikwere-arle ipenhe, Leah awethe atnerte-atnerte-irreke, re imerte urreye akweke arrpenhe atnyenemele. Re anteme ampe urreye six-pele anteme atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Ikwere-ipenhe anteme re angkeke alakenhe, “Ngkartele kwenhe atyenge arne impene anthurre antheke arratye mwerre anthurre. Tharle anewe atyinhe ampe urreye six-pele-arle antheke. Yanhenge anteme re atyenge arne impene anthetyenhe!” Alakenhenge anteme Leah-ele ampe urreye ikwerenhe Zebulun arritnye antheke. Zebulun arritnye ileme “Arne Impene Atyenge.” ");
INSERT INTO aer_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ikwere-iperre, Leah-ele ampe marle akweke anteme atnyeneke renhe Dinah arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Ikwerele-ureke anteme, Rachel-ele Ngkarte apayuthneke renhe atnerte-atnerte mpwaretyeke Ngkarte akenhe Rachel-eke alkngwirretyakenhe-arle. Rarle itele-arle-areke tyerrtye areye-arle ikwere mwerrantye angketyakenhe re anteme renhe mwerre-ileke re ampe anteme atnyenetyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Rachel atnerte-atnerte-irreke imerte ampe urreye akweke atnyenemele. Akweke renhe anteme re Joseph arritnye antheke, re anteme angkeke, “Tyerrtye areye kwenhe atyenge akurnentye angkerreke nhenge the ampe atnyenetyakenhenge. Ayenge kwenhe ayenge-arrpe apure-irreke. Kele lyete akenhe ayenge Ngkartele akangkentye anthurre-arle mpwareke, apure-irretyale. ");
INSERT INTO aer_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Kele ayenge akenhe ahentye-aneme ayenge YAHWEH-ele ampe arrpenhe anthetyeke.” Alakenhenge anteme Rachel-ele ampe urreye ikwerenhe Joseph arritnye antheke. Joseph ileme “Ayenge ahentye-aneme arrpenhe atnyenetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Kele Joseph-arle inteke ipenhe, Jacob ahentye-aneke apmere ikwerenhe-werne alpetyeke, re anteme Laban-werne alheke apayuthnetyeke re renhe impemele alpetyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Re anteme ikwere angkeke, “Atyenge anthaye anewe atyinhe areye ampe areye-arlke atyinhe ayenge apmere atyinhe-werne alpetyenhenge. The arne atyinhe areye atnyenetyeke ahentye-aneme ayenge-arle ngkwenge arnterre anthurre urrkapekenge. Unte itelareme kele arratye-arle.” ");
INSERT INTO aer_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Kenhe Laban akenhe angkerlenge, “Unte apeke atyenge akangkentye, kele nhenhele anaye, alhetyale. The ngkarte akweke atyinhe areye apayuthneke itne atyenge ilerlenge ngkwenge-akerte. Unte nhenhele anerle-anerlenge, YAHWEH-elarle ngenhe lterrke ileke arntarnte-aremele. Alakenhenge kwenhe re ayenge-arlke arntarnte-areke. ");
INSERT INTO aer_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kele atyenge ilaye. Iwenhe-ame the ngkwenge antheye unte-arle nhenhele atyengenge anetyenhenge?” ");
INSERT INTO aer_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","30","Jacob angkirtneke, “Unte ayenge itelareme ayenge-arle ngkwenge arnterre urrkapeke. Arrule urreke ayenge nhenhe-werne apetyetyenhenge, unte kwenhe yepe-yepe urrpetye ware atnyeneke. Kele ayenge anteme apetyeke yepe-yepe areye uthene nanikute areye uthene arntarnte-aretyamele, kele itne atningke anteme-arle-irrerlenge unte anteme atningke anteme atnyeneme. Nthenhele apeke-arle ayenge ngkwenge urrkapeke, YAHWEH-ele ngenhe lterrke-ilemele ngenhe arntarnte-areke. Kele ayenge-arle-artaye? Ilengare-arle-ame unte atyenge mwerre angkeme ayenge yernirtnemele atyinhe areye the-arrpele arntarnte-aretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Ikwerenge-ntyele, Laban-ele renhe awethe apayuthneke, “Iwenhe-ame the ngkwenge anthetyenhe?” Jacob-ele renhe tyerneke, “Ayenge arne iwenhe apeke renhe anthetyale. Ayenge ahentye-aneme unte atyenge arne anyente ware mpwaretyeke. Unte apeke atyenge yewe angkeme kele ayenge apetyalpemele yepe-yepe areye uthene nanikute areye uthene arntarnte-aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","The yepe-yepe itnenhe akngakemele urrperle areye inetyenhenge; yepe-yepe ntenye-ntenye urrperle-akerte areye-arlke the akngaketyenhenge. The nanikute ntenye-ntenye-akerte areye-arlke. Alakenhe ware-arle the ngenhe apayuthneme the itnenhe atyenge-arrpe atnyenetyeke. The itnenhe kele arntwarre anthurre-werne arntarnte-aretyeke akngirtnetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Ikwerenge, nhenge unte anteme apetyemele ayenge arerle-alpetyeke, unte ayenge itelareme the ngkwengenge anyelkngele inetyakenhe. Unte-arrpe akngakemele aretyeke. Unte apeke areme nanikute urrperle areye-arlke ntenye-ntenye-akerte areye-arlke kele unte itelareme tharle ngkwengenge anyelkngele inetyakenhe-arle. Kele unte apeke yepe-yepe mperlkere areye aremele kele unte itelaretyeke tharle ngkwenge-ntyele anyelkngele-arle ineke.” ");
INSERT INTO aer_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laban-ele Jacob awemele alakenhe ikwere angkeke, “Mwerre! Kele mpe, alhetyekaye nanikute areye uthene yepe-yepe areye uthene akngaketyeke.” ");
INSERT INTO aer_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Kenhe, arlte anyente ikwerele, Laban akenhe yepe-yepe ikwerenhe areye-werne alhemele nanikute areye-arlke-werne imerte akngakemele mperlkere-akerte areye marle uthene urreye uthene, alakenhenge ntenye-ntenye arlpentye-akerte areye apeke. Re yepe-yepe urrperle areye-arlke akngakeke. Re anteme yepe-yepe areye itnenhe akngeke alere ikwerenhele arntarnte-aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Yanhe-ngentyele Laban ikwerenhe areye-akerte aname-irremele alheke yepe-yepe areye-arlke, nanikute ikwerenhe areye-arlke-akerte arlte urrpetyele alhemele irntwarre Jacob-ketyenge. Yanhe-ngentyele, Jacob-ele yepe-yepe Laban-kenhe areye uthene nanikute areye uthene arntarnte-areke yanhe ikwerele. ");
INSERT INTO aer_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Jacob-ele walye akeke arne poplar-nge, arne almond-nge uthene, arne plane-ngentyele-arlke. Kele imerte walye areye yenpe parlke-iwemele. Walye areye arlkenye mperlkere-akerte nthenhele-arle rarle yenpe parlke-iweke. ");
INSERT INTO aer_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Re anteme arne tyipe areye iperteke-arleke arrernemele kwatye ngentye itwele nthenhele-arle yepe-yepe areyele-arle kwatye antywetyarte. Re alakenhe mpwareke rarle itelaremele alakentye-ntyele-arle itneke anewe akerrentye akngerrenge. ");
INSERT INTO aer_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","Nanikute urrperle marle areye urreye urrperle areye-arlke apurte-irretyarte arrekwele arne arlkenye-akerte itnekenge. Alakenhenge anteme nanikute itne atnerte-atnerte-irreke, akweke areye akenhe ntenye-ntenye-akerte-arle apeke, arlkenye-akerte-arlke apeke inteke. ");
INSERT INTO aer_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Kenhe yepe-yepe akweke areye akenhe, Jacob-ele akngerre areye-ngentyele-arle akngakeke. Re itnenhene utepelhe-ileke itne nanikute urrperle Laban-kenhe areye aretyenhenge uthene ntenye-ntenye areye-arlke. Alakenhe ikwerenge yepe-yepe Jacob-kenhe areyele akweke ntenye-ntenye areye atnyenetyenhenge. Alakenhe-arle Jacob-ele yepe-yepe ikwerenhe areye akngaketyarte Laban-kenhe areye-ketyenge. ");
INSERT INTO aer_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","42","Nhenge atyepe-atyepe lterrke ulkere areye-arle apurte-irretyarte anewe akerretyeke, Jacob-ele akenhe arne arlkenye mperlkere-akerte areye arrernetyarte itneke arrwekeleke itne aretyenhenge. Kele akweke ulkere itne atnerte-atnerte-irrerlenge, kele akweke itnekenhe akenhe ntenye-ntenye-akerte, lterrke anthurre anteye interlenge. Itne akenhe Jacob-kenhe-arle aneke. Kele alyepe-alyepe areye apurte-irremele anewe-akerretyeke re itnenhe arne arlkenye mperlkere-akerte areye arrekweleke arrernetyakenhe-arle. Nhenge alyepe-alyepe areye atnerte-atnerte irremele, akweke itnekenhe ntenye-ntenye-kwenye akenhe alyepe-alyepe anthurre-arle inteke. Nhenhe areye Laban-kenhe areye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Alakenhenge-arle nanikute Jacob-kenhe areye-arlke yepe-yepe areye-arlke atningke irreke. Re nanikute-arlke yepe-yepe-arlke atningke atnyeneke, arelhe-arlke artwe-arlke urrkapentye akngerre atningke re atnyeneke. Kamule-arlke tangkeye-arlke atningke. ");
INSERT INTO aer_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ikwere iperre Jacob-ele aweke ikwere-arle Laban-eke alere areye tyele angkerreke ikweretye, “Urreke Jacob apetyetyenhenge akngeye anwerne-kenhele arne arunthe atnyeneke, kenhe re akenhe anteme arne ingkirreke akngeye anwerne-kenhe-nge rakeke. Re arne akngeye anwerne-kenhele mpwareke re arne itnenhe ikwere inetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Kenhe Laban akenhe atyewe mwerre Jacob-kenhe-arle anetyarte, kele Jacob-ele Laban aretyarte, re alakenhe itirretyarte, “Laban apeke-arle atyenge awethe ahentye-anetyakenhe apeke-arle.” ");
INSERT INTO aer_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","YAHWEH anteme Jacob-eke angkeke, “Alpaye apmere ngkwinhe-werne ngkwenge-artweye areye-werne. Kele ayenge ngkwengenge anetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kele imerte, Jacob Rachel uthene Leah utheneke antangkelheke ratherre apetye-alherretyeke rarle yepe-yepe areye uthene nanikute areye uthene arntarnte-aretyame-werne. ");
INSERT INTO aer_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Ratherre apetye-alherreke arteke re angkeke, “Akngeye mpwele-kenhe atyenge mwerre ulkere anetyarte, kele lyete akenhe re atyenge ahentye-anetyakenhe anteme-arle. Kele mwerre. Ayenge-arle atere anetyakenhe-arle aneme, Ngkarte, anyente re akngeye atyinhe Isaac-ele-arle apentetyarte, rarle akwetethe-arle atyengenge anerle-aneme. ");
INSERT INTO aer_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Kele mpwele itelareme ayenge-arle arnterre urrkapeke akngeye mpwele-kenheke. ");
INSERT INTO aer_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Re kwenhe ayenge maneke alhileke anthetyeke tharle yepe-yepe ikwerenhe areye arntarnte-aretyartenge. Kele re akenhe ayenge ularele ileke 10-ngare anthurre, mane anthetyakenhe akwete. Re ayenge akurne-ileke. Ngkartele renhe ayakeke ayenge atweketye, ayenge arntarnte-aremele. ");
INSERT INTO aer_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Arrekwele akenhe, Laban atyenge angkeke, ‘Unte yepe-yepe areye uthene nanikute areye uthene ntenye-ntenye areye interlenge atnyenetyeke unte-arle atyenge itnenhe arntarnte-aretyartenge.’ Kele yanhe-ngentyele yepe-yepe areye uthene nanikute areye uthene akenhe ntenye-ntenye-ante areye-arle inteke. Kele imerte re akurrknge akngarte-iwelhemele atyenge angkemele, ‘Kele unte yepe-yepe areye uthene nanikute areye uthene ntenye-ntenye-kwenye-ante areye interlenge atnyenetyeke unte-arle atyenge itnenhe arntarnte-aretyartenge.’ Kele yanhe-ngentyele yepe-yepe areye uthene nanikute areye uthene akenhe ntenye-ntenye-kwenye-ante areye-arle interlenge. ");
INSERT INTO aer_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Alakenhe-arle Ngkartele yepe-yepe areye uthene nanikute areye uthene akngeye mpwele-kenhe-ketye ineke, imerte ayenge anteme anthemele.” ");
INSERT INTO aer_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Jacob anteme anewe ikwerenhe atherreke angkeke, “Ikwerenge nhenge yepe-yepe areye uthene nanikute areye uthene-arle anewe akerretyame. The altyerre areke. The altyerre ikwerenge areke nanikute urreye areye apurte-irrerlenge nanikute marle areyeke. Nanikute ntenye-ntenye-kwenye areye itne akenhe nanikute marle areyenge apurte-irretyakenhe-arle aneke. Kenhe nanikute arlkenye-akerte itne ante-arle arrpenhe itnekenge apurte-irremele anewe akerretyeke. ");
INSERT INTO aer_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Kele alkere-arenye Ngkarte-kenhe anyente atyenge altyerrenge angkeke, ‘Jacob-aye!’ Ayenge utnenge alkere-arenye ikwere angkirtneke, ‘Wertaye?’ ");
INSERT INTO aer_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Kele utnenge alkere-arenye atyenge angkerlenge, ‘Nanikute urreye areye araye. Arlkenye-akerte yanhe areye-arlke ntenye-ntenye areye-arlke ware apurte-irremele anewe akerretyeke marle areyenge. Tharle ngenhe arntarnte-aretyame, tharle itelareme Laban-elarle ngkwenge arne akurne mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ayenge-arle Ngkarte anyente-arle ngkwenge apmere Bethel-eke imernelheke. Apmere nhenge unte-arle apwerte nhenge ngkerneke, unte imerte antere anteme akertneke thelemele. Yanhe ikwere-arle unte atyenge alhileke unte-arle ayenge apentetyenhe. Ayenge ahentye-aneme unte apmere nhenhenge arratetyeke, apmere unte-arle akweke inteke-werne alpaye.’ Alakenhe-arle utnenge alkere-arenye re atyenge altyerrenge angkeke.” ");
INSERT INTO aer_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kenhe Rachel uthene Leah uthene akenhe Jacob-eke ahele-irremele angkerlenge, “Akngeye ilerne-kenhe apeke ilwerlenge, kele ilerne arne ampenye ikwerenhe areye inetyakenhe, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Rarle ilerneke mwerre anetyakenhe-arle aneke, arrangkwe-arle. Rarle ilerneke ahentye anetyakenhe-arle aneke nhenge ilerne-arle apmere arrpenhe-arenye-arteke. Rarle ilernenhe ngenhe antheke apwerte maneke ware-arle. Rarle mane ingkirreke akurne-arle-ileke nhenge ilernenhe ware anthemele. ");
INSERT INTO aer_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Alakenhenge-arle Ngkartele yepe-yepe areye uthene nanikute atningke-arlke ikwerenge-ntyele ineke, akngeye ilernekenhe-ngentyele, kele ilerne-kenhe anteme-arle akenhe ampe ilerne-kenhe areye-kenhe-arlke. Ngkarte apeke-arle ahentye-aneme unte iwenhe apeke renhe mpwaretyeke, ikwere akangkwe-irraye ilerne ngenhe apentetyenhenge!” ");
INSERT INTO aer_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Kele Jacob alethe alhetyeke irreke ampe areye-arlke anewe areye-arlke ikwerenhe kamule-ke utyernemele. ");
INSERT INTO aer_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","Itne apmere renhe impemele alpeke Canaan-werne. Isaac akenhe apmere Canaan ikwerele akwete-arle aneke. Re yepe-yepe areye-arlke nanikute areye-arlke akngeke thakemenele-arteke. Re akngeke arne ingkirrenyeke ikwerenhe rarle Paddan-Aram-enge atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Kele aletheke anteme irretyeke aneke Jacob ikwerenhe areye-akerte Canaan-werne, Rachel alheke apmere akngeye ikwerenhe-kenhe-werne ngkarte-apartetye akweke areye apwerte-ngentyele-arle mpwareke anyelkngele inetyeke akngeye ikwerenhe-ngentyele. Laban akenhe apmerele anetyakenhe-arle aneke. Re kele alheke yepe-yepe areye althetyeke. ");
INSERT INTO aer_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Jacob akenhe Laban-eke ilelhetyakenhe-arle alheme. Rarle renhe ularele ileke re ikwere-ketye urntetyenhenge Laban-ele renhe ayakeketye. ");
INSERT INTO aer_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Alakenhe-arle re arne ingkirreke ikwerenhe akngeke. Itne anteme apmere Laban-kenhe imperlte-alheke, Euphrates lhere akngerre renhe anperele arenherlte-iwemele, itne imerte alhemele apmere apwerte akngerre-werne Gilead arritnye apmere re. ");
INSERT INTO aer_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Arlte atherre iperre, tyerrtye arrpenhele Laban-eke ileke Jacob-arle alwirreke ikwere-artweye-akerte. ");
INSERT INTO aer_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Kele Laban-ele artwe ikwerenhe areye apurtelhe-ilemele interteke-irreke Jacob-kenhe areyeke. Kele week anyentele anteme re itnenhe apmere apwerte-apwertele apmere Gilead-eke areke. ");
INSERT INTO aer_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Ingwe anyente ikwerele anteme, Ngkarte Laban-eke angkeke altyerrenge, re renhe alkngarre-ileke, “Ayenge awaye! Jacob atwetyale anetyeke!” ");
INSERT INTO aer_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Jacob ikwerenhe areye-akerte apwerte-apwertele inteke apmere Gilead-enge. Laban artwe ikwerenhe areye-akerte inteke apmere ikwerele itwele-ante. ");
INSERT INTO aer_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laban anteme Jacob-werne apetyemele angkeke, “Iwenhenge-ame unte ayenge ularele ileke? Iwenhenge-ame unte marle atyinhe atherre akngetyeke ayernentye akngerre atherre-arteke akwele? ");
INSERT INTO aer_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Iwenhenge-ame unte nterte-nterte atyenge-ketye alwirreke? Unte apeke-arle ayenge ilekenge, kele the ngkwenge merne-arlke kere-arlke-arle akngerre itemele anwerne ingkirrekele arlkwetyeke. Anwerne-arle akangkentye-arle aneme, anwerne-arle terurrele ltare atwemele, guitar-arlke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Kele, unte itnenhe akngeke, atyenge-ketyenge alwirrelhe-ilemele. The akenhe atyemeye atyinhe areye marle atyinhe atherre-arlke arrwantyetyakenhe ware aneke, arrangkwe-arle. The apele itnenhe atwaretyakenhe-arle aneke. Unte ayenge irrarele-antheke unte-arle apale mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ayenge apeke-arle ahentye-aneke, kele the ngenhe atweme-arle. Kenhe Ngkartele akenhe ayenge ingwele ileke ngenhe atwetyale anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Kele the itelareme unte irrare irrentye akngerre akngeye ngkwinheke apmere ngkwinheke-arlke. Kele iwenhenge-arle akenhe unte ngkarte-apartetye akweke atyinhe areye anyelkngele ineke?” ");
INSERT INTO aer_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Jacob angkirtneke, “Ayenge-arle ilelhetyakenhe apetyeke ayenge-arle ngkwenge-ketye atere-irrekenge. Ayenge itirreke unte-arle akwele ampe ngkwinhe atherre atyengenge rakeme-ketyenge. ");
INSERT INTO aer_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Kele ngkarte-apartetye akweke ngkwinhe areye unte-arle tnakemenge, ayenge kele akutne-arle. Kele unte antyame-arlke anwerne-kenhe aretyeke-arle. Ilerneke-artweyeke areye nhenhe aneme, itne ilernenhe aweme-arle. Anwerne apurtele areme kele unte apeke ngkarte-apartetye akweke nhenge areye ngkwinhe areme, antyame angwenhe-kenhele, kele the artwe atyinhe areye ileme renhe atwetyeke anyelkngele-arle inekenge.” Alakenhe-arle Jacob-ele Laban ileke, re akenhe akutne-arle aneke anewe ikwerenhe Rachel-elarle arne impene akweke nhenge areye anyelkngele inekenge. ");
INSERT INTO aer_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Kele Laban apale untheke arne nhenge itneke. Ilthe Jacob-kenhe-urrke re areke, kele imerte ilthe Leah-kenhe kwene anteme aremele. Kele re imerte ilthe urrkapentye akngerre atherre Bilhah uthene Zilpah uthene-kenhe-werne alhemele, kele re arrangkwe areke. Re imerte ilthe Rachel-kenhe-werne anteme alhemele arne nhenge itneke unthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Kenhe Rachel-ele akenhe arne impene nhenge areye arrekwele anyelkngele ineke. Urreke Laban ilthe Rachel-kenheke irrpetyenhenge, Rachel-ele apenhe arne nhenge areye alengke-iweke yakwethe kamule-kenheke-arle. Rarle irrpenhekenge re akenhe akertnele-arle intetyame. Laban irrpenhemele ilthe Rachel-kenhe-werne re untheke apmere arrpe-anenhele untheke, kele re arne impene akweke nhenge itneke uye apale untheke, arrangkwe. ");
INSERT INTO aer_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Rachel imerte angkemele, “Akngeye-aye, ayenge rlkerte awelheme, ayenge uye-arle tneme.” Kele Laban-ele renhe ipmentyele impeke, re imerte akethe-werne arratemele, imerte apmere arrpe-anenhe aremele, re uye untheke arne impene akweke itneke. ");
INSERT INTO aer_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob ahele anthurre irreke Laban-eke. Re ikwere-werne atheke nentye-nentye alheke imerte angkemele, “Aye, atyenge angkaye! Ayenge kwenhe ngkwenge apale angketyakenhe akurne mpwaretyakenhe iwenhenge-ame unte ayenge alwerneme? Atyenge ware ilaye! ");
INSERT INTO aer_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Unte kwenhe antyame anwerne-kenhe-arlke ilkareke, unte arne ngkwinhe areye aretyakenhe, arrangkwe-arle. Unte apeke arne ngkwinhe areye arratye arerlenge, kele atyenge unte imernetyeke-arle! Nhenhe arrekweleke arrernetyeke atyinhe areye ingkirrekele aretyeke. Kele itne aretyenhenge angwenhele arratye ilemeke apeke! ");
INSERT INTO aer_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ayenge awaye! Ayenge kwenhe ngkwenge year 20-peleke-atwetye urrkapeke. Yanhenge anteme yepe-yepe areye uthene nanikute areye uthene inteke ilweke-arle anetyakenhe, itne atningke-irreke-arle. The akenhe yepe-yepe urreye anyente-ante apeke arlkwetyakenhe, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Nhenge akngwelye artnwerele-arle yepe-yepe areye uthene nanikute areye uthene arlkwekenge, tharle ngenhe ularele iletyakenhe-arle, tharle ngenhe yepe-yepe atyinhe-arle antheke. Nhenge arrpenhe areyele-arle ngkwinhe areye arltele apeke ingwele apeke anyelkngele inerrirretyarte, unte akenhe ayenge-arle uternetyarte the atyinhe anyente ngenhe anthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Ayenge-arle uterne akngerrele ureke urrkapetyarte, irrernte akngerrele-arlke ayenge-arle ingkwe ilweke, tyerrtye atyinhe tharre anthurrenge, ayenge-arle ankwe-arlke mwerre intetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ayenge-arle ngkwenge arlte arrpe-anenhele-arle urrkapeke year 20 peleke-atwetye. Ayenge-arle ngkwenge urrkapeke year 14 peleke-atwetye ampe marle ngkwinhe atherreke ware. Yanhenge anteme ayenge ngkwenge year 6 peleke-atwetye urrkapeke yepe-yepe areye uthene nanikute areye ngkwinhe areyeke. Unte-arle ayenge 10-ngare anthurre-arle ularele ileke. Unte-arle atyenge alhileke mane anthetyeke yepe-yepe ngkwinhe areye-arle arntarnte-arekenge. Kele unte apale-arle angkerlenge unte-arle ayenge akweke ware-arle mane anthetyarte. ");
INSERT INTO aer_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Kele Ngkarte atyinhe arrenge-arrenge atyinhe Abraham uthenele-arle apentetyarte, rarle atyinhe lyete akwete-arle aneme. The apeke-arle renhe atnyenetyakenhe, kele unte ayenge iltye ante-arle yernemere. Kele Ngkartele ayenge arnterre urrkaperlenge-arle areke, re anteme ngenhe areke atyenge ahele untherlenge. Alakenhenge anteme ngenhe Ngkartele ayakeke ingwele ayenge atwetyale!” ");
INSERT INTO aer_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Kele Laban angkeke ampatye ikwerenheke, “Arelhe nhenhe atherre kwenhe ampe atyinhe atherre, ampe itnekenhe akenhe atyinhe-arle. Yepe-yepe yanhe areye-arlke nanikute areye-arlke kwenhe atyinhe. Kele the ngenhe ayaketyeke arrangkwe-arle ampe atyinhe arrenge-arrenge atyinhe areye-arlke raketyeke. Kele itnenhe akngaye. ");
INSERT INTO aer_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Ngkartenge ularre alhiletyeke ilerne awethe atwerretyale anetyeke. Apwerte nhenhe areye ilerne apurtelhe-iletyeke itne ilernenhe irlpangkelhe-iletyeke awethe atwerreketye.” Jacob kele mwerre-arle angkeke. ");
INSERT INTO aer_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Arratye, re apwerte akngerre ngkerneke renhe-atherrenhe irlpangkelhe-iletyeke ratherre angkerrekeke. ");
INSERT INTO aer_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Re artwe ikwerenhe areye ileke apwerte akweke areye itepe arrpe-anenheke arrernetyeke. Itne merne-arlke arlkweke yanhe ikwerele. ");
INSERT INTO aer_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laban-ele apmere renhe arritnye antheke angkentye ikwerenhele “Jegar Sahadutha,” alakenhe ileme “Apwerte lyernte-ipeke anwernenhe irlpangkelhe-iletyeke.” Kele Jacob-ele ileke angkentye ikwerenhele “Galeed” alakenhe ante-arle ileme “Apwerte lyernte-ipeke anwernenhe irlpangkelhe-iletyeke.” ");
INSERT INTO aer_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Kele Laban angkeke ampatye-ampatye ikwerenhe Jacob-eke, “Urreke anwerne apmere nhenhe aremele, ilerne itelareme ilerne-arle alhilerreke, ilerne-arle awethe atwerretyakenhe anetyeke.” Alakenhe ikwerenge anteme re apmere nhenhe “Galeed” ileke. ");
INSERT INTO aer_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Kele Laban alakenhe angkeke, “Ilerne apeke akalke-irreme, ayenge ahentye-aneme YAHWEH ilerneke arelhetyeke, ilerne apeke awethe atwerreketye!” Alakenhenge anteme apmere yanhe arritnye arrpenhe-akerte aneke “Mizpah.” Alakenhe ileme Hebrew-enge “Re Ilerneke Arelheme.” ");
INSERT INTO aer_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laban ikwere awethe angkeke, “Itelaretyeke nhenhe, alkngwirretyale. Ngkartele anwernenhe lyete arntarnte-areme. Unte apeke marle atyinhe atherre atwerlenge, unte apeke arelhe arrpenhe apeke inerlenge, ayenge apeke-arle akutne aneme. Kele Ngkartele ante-arle ngenhe areme akurne-irrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Apwerte nhenhe araye the lyernte-arrerneke, kele ilerne akwetethe itelaretyeke atwerretyale anetyeke. Ayenge-arle apwerte nhenhe-arenyenge anpere alhetyeke arrangkwe-arle ngkwengenge atwerretyeke, arrangkwe. Unte akenhe apwerte yanhe areyenge atyengenge atwerretyeke anpere alhetyale anetyeke-arle. ");
INSERT INTO aer_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ngkarte Abraham uthene Nahor uthenele-arle apenteke, kele re areme-arle nthakenhe-arle ilerne irreme. Unte apeke ayenge atwemele, Ngkartele areme ilerne iwenhe apeke renhe mpwarerlenge. Re itelaretyenhe ilerne apeke arratye mpwarerle-anerrerlenge.” Kele Jacob Laban-eke angkeke, “Ngkartenge arrekwele-arle, anyente re akngeye atyinhe Isaac-ele-arle apentetyarte, the arratye ngenhe alhileme ayenge apwerte nhenhe areyenge anpere alhetyakenhe apmere ngkwinhe-werne ngenhe atwetyeke arrangkwe.” ");
INSERT INTO aer_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Kele Jacob-ele yepe-yepe anyente atwemele iteke Ngkarte-werne atheke. Re anteme ileke artwe ikwerenge-arle aneke areye ikwerenge arlkwetyeke. Kele itne-arle arlkweke iperre, itne apwerte-apwerte yanhele inteke. ");
INSERT INTO aer_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Kele ingweleme anteme, Laban-ele arrenge-arrenge ikwerenhe areye arrwantyemele. Ampe ikwerenhe atherre-arlke imerte itneke angkemele, “Ngkartele arntarnte-aremele arrekantherre mwerre mpwaretyenhe.” Kele re alpeke anteme apmere ikwerenhe-werne. ");
INSERT INTO aer_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob-arle alethe alpetyame ikwerenhe areye-akerte arne-arlke atningke-akerte, utnenge alkere-arenye areye ikwere arrateke. ");
INSERT INTO aer_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Jacob-ele itnenhe areke, re-arrpe angkeke, “Apmere nhenhe-arle Ngkarte-kenhe-arle!” Re anteme apmere renhe arritnye antheke “Mahanaim.” Arritnye Mahanaim ileme “Apmere atherre.” ");
INSERT INTO aer_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Nhenge Mahanaim-enge, Jacob-ele ayeye-akerte areye yerneke kake ikwerenhe Esau-werne. Ikwerele ureke, Esau akenhe apmere Seir-ele aneke, apmere akngerre Edom arritnye. ");
INSERT INTO aer_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Urreke re itnenhe yernetyenhenge, re angkentye nhenhe antheke, “Angkentye nhenhe ngkwenge atyeye Jacob-engentyele. Unte-arle atyenge akngerrepate aneme ayenge ngkwenge akangkwe-irreme nthakenhe-arle unte atyenge angkemeke. The ngkwenge iletyeke ahentye-aneme nthakenhe-arle ayenge irreke. Ayenge-arle apmere Laban-kenhele anetyarte, kenhe lyete-ulkere ayenge-arle kele apetyalpetyeke aneke. ");
INSERT INTO aer_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","The pweleke areye-arlke, tangkeye areye-arlke, yepe-yepe areye-arlke, nanikute areye-arlke atyinhe atnyeneme-arle. The arelhe-arlke artwe-arlke atningke atnyeneme atyenge urrkapentye akngerre areye. The angkentye nhenhe ngkwenge yerneme unte atyenge mwerre anetyenhenge.” Kele artwe Jacob-kenhe areye alheke Esau-eke iletyeke nhenge rarle ikwere-werne-atheke apetyetyamenge. ");
INSERT INTO aer_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Kele-arle Esau areke iperre artwe Jacob-kenhe areye apetyalpeke imerte ikwere angkemele, “Anwerne kake ngkwinhe Esau mpwepeke areke, re kwenhe artwe 400 pele ikwere-akerte atnyeneme.” ");
INSERT INTO aer_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Jacob-ele nhenge aweke, re atere anthurre irreke. Re itirreke Esau-ele akwele renhe atwetyeke-arle apetyemenge. Alakenhe irreme-ketye re ikwerenhe areye akngakeke, ingkirreke akalkelhe-ilemele, yepe-yepe-arlke kamule areye-arlke pweleke areye uthene nanikute areye uthene-arlke-arle re akngakeke. ");
INSERT INTO aer_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Jacob re-arrpe itirreke, “Esau-ele apeke arrpenhe nhakwe areye atwemele, kenhe arrpenhe areye akenhe atere-arle unterlte-iwerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Re anteme Ngkarteke angkeke, “Unte kwenhe Ngkarte atyinhe Isaac uthenele arrenge-arrenge atyinhe Abraham uthene apententye akngerre. Ayenge awaye, ayenge akunye apenhe! YAHWEH, unte ayenge ileke apmere nhenhe-werne apetyalpetyeke apmere atyinhe-werne tyerrtye atyinhe areye-werne-arlke. Unte atyenge angkeke unte-arle atyenge mwerre anthurre anetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Iwenhenge-ame unte atyenge mwerre anthurre akwete aneme, ayenge akngerre kwenye-arle? Iwenhenge-ame unte ayenge akwete arntarnte-areme. Arrule anthurre ayenge-arle anpere alheke lhere Jordan-enge apmere Mesopotamia-werne, ayenge arne atneme anyente-akerte ware alheke. Kele lyete akenhe the arne atningke anthurre anteme-arle atnyeneme, aharle atherre ante akalkelhe-iletyeke anteme. ");
INSERT INTO aer_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Kake akngerre atyinhe Esau-arle apetyemenge ayenge atere-irreme re anwernenhe ingkirre atweme-ketye, arelhe-arlke ampe-arlke. Alakenhe ikwerenge anteme-arle the ngenhe apayuthneme ayenge arntarnte-aretyeke ikweretye. ");
INSERT INTO aer_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","The ngenhe alakenhe apayuthneme unte-arle angkekenge atyenge mwerre anetyeke. Unte anteme angkeke ayenge atyemeye-arlke ampe-arlke atningke anthetyeke yerre areye-arteke. Atningke anthurre!” ");
INSERT INTO aer_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Kele-arle Jacob Ngkarteke angkeke iperre re ingwe anyenteke aneke kele arlte ingweleme anteme re kere ikwerenhe areye akngakeke kake ikwerenhe anthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","Re nanikute marle 200-pele apurtelhe-ileke imerte nanikute urreye 20-pele anteme apurtelhe-ilemele, kele imerte yepe-yepe marle 200-pele imerte yepe-yepe urreye 20-pele anteme apurtelhe-ilemele arrpenheke arrernemele. ");
INSERT INTO aer_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","Kele re kamule marle 30-pele apurtelhe-ilemele akweke itnekenhe-arlke. Kele re pweleke 40-pele apurtelhe-ilemele pweleke urreye 10-pele-arlke imerte tangkeye marle 20-pele apurtelhe-ilemele tangkeye urreye 10-pele-arlke. ");
INSERT INTO aer_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Re anteme artwe urrkapentye akngerre 10-pele ineke itne arne itnenhe arntarnte-aretyenhenge apurtelhe-ilemele, re anteme itneke angkeke “Arrantherre lherele tyanemele alhaye arne nhenhe areye akngemele apurte akwete kake atyinhe anthetyeke. Itnenhe apurtelhe-ilemele akngetyeke aharle anyenteke-anyente, irntwarreke-irntwarre.” ");
INSERT INTO aer_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Kele imerte Jacob angkemele urrkapentye akngerre anyenteke, artwe nhengeke arrekwelenye areye arntarnte-aremenge, “Kake atyinhe apeke apetyemele ngkwenge angkemele, re ngenhe apayuthneme angwenheke-arle unte urrkapeme. Rarle ngenhe apayuthneme nthenhe-arle unte alhemeke, re ngenhe apayuthneme angwenhe-kenhe nhenhe areye yepe-yepe, nanikute-arlke, tangkeye uthene kamule utheneke-arlke. ");
INSERT INTO aer_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Re apeke ngenhe alakenhe apayuthnerlenge, kele alakenhe ikwere angkirtnaye, ‘Nhenhe areye-arle ngkwenge atyeye Jacob-kenhe-arle, rarle ngkwinhe urrkapentye akngerre anteme-arle. Rarle ngenhe arne nhenhe areye antheme unte ngkwenge atnyenetyeke. Unte anteme-arle akngerrepate ikwerenhe. Jacob-arle ingkerne-arle apetyemenge.’ Alakenhe unte Esau-eke angketyeke.” ");
INSERT INTO aer_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Kele Jacob angkeke urrkapentye akngerre arrpenhe areyeke, “Unte alakenhe angketyeke re apeke arrekantherre-werne apetyerlenge. ");
INSERT INTO aer_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Alakenhe ikwere angkaye, ‘Jacob urrkapentye akngerre ngkwinhe anwernenge ingkerne apetyeme.’” Jacob re-arrpe itirreke, “The apeke arne nhenhe areye yernemele kake atyinheke, kele the renhe aremele, kele re apeke-arle atyengenge ipeltye-irremele, atyenge ahele-irretyakenhe aneme.” ");
INSERT INTO aer_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Jacob-ele artwe urrkapentye akngerre ikwerenhe areye arrekwele yerneke yepe-yepe-arlke kere arrpenhe areye-akerte-arlke, re akenhe ingkerne akwete-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Ingwe ikwerele ingwemertenge anteme, Jacob ankwenge-ntyele akeme-irreke, re anewe ikwerenhe atherre akemelhe-ileke, arelhe urrkapentye akngerre atherre uthene alere ikwere areye 11-pele ikwerenhe-arlke. Re itnenhe arrekwele yerneke, itne lhere Jabbok-ekenge irntwarre-werne alheke, arne ingkirreke Jacob-kenhe itnekenge akngemele. ");
INSERT INTO aer_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Kele Jacob akenhe anyente-arle ingkerne aneke. Nhenge rarle anyente anekenge artwe anyente apetyemele renhe arntwirrkeke Jacob renhe, ratherre anteme ahelheke ntewirretyeke uye akwete. Ratherre arntwirrkerreke akwete ntewirremele ingwartentyele, nterte-arlke irretyakenhe. Artwe rarle Jacob ahelheke ntewetyeke ahentye-aneke. ");
INSERT INTO aer_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Re Jacob ingwartentyele angkerte-iweme. Kele ingwe athnele anteme re Jacob alkngarlpe atweke ulyepere akertne-arlke wangketyeke ante artwe rarle uye Jacob ahelheke iwekenge, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Re anteme Jacob-eke angkeke, “Aye, ayenge impaye, uterne arrateme antemeyaye!” Jacob ikwere angkirtneke, “Kele, ayenge alhilaye unte ayenge arntarnte-aretyenheke ayenge lterrke-arlke atnyenemele akwetethe!” ");
INSERT INTO aer_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Artwe rarle renhe apayuthneke, “Iwenhe-ame arritnye ngkwinhe?” Jacob ikwere angkirtneke, “Ayenge-arle Jacob-arle.” ");
INSERT INTO aer_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Kele artwe re angkerlenge, “The arritnye ngkwinhe akngarte-iweme Jacob-engentyele, arritnye yanhe ileme “ularele mpwarentye akngerre” Israel arritnye-werne, unte-arle Ngkartenge atwerrekenge artwenge-arlke, unte kwenhe apurrke-irretyakenhe akwete anthurre alheke uyerretyeke ante. Israel arritnye ileme “Ratherre Ngkarte uthene-arle angkerte-iwerreke.” ” ");
INSERT INTO aer_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Kele Jacob anteme ikwere angkeke, “The ngenhe apayuthneme, iwenhe-ame arritnye ngkwinhe?” Artwe re angkirtneke, “Tharle arritnye atyinhe iletyeke arrangkwe-arle.” Kele artwele anteme Jacob alhileke rarle renhe arntarnte-aretyenhe renhe lterrke-arlke-ilemele akwete-anteke. Kele artwe re Jacob impemele alheke. ");
INSERT INTO aer_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Kele Jacob anteme angkeke, “The kwenhe inngerre Ngkarte-kenhe areke, ayenge anteme itethe akwete-arle!” Re anteme apmere renhe Peniel arritnye antheke. Arritnye nhenhe ileme “inngerre Ngkarte-kenhe” rarle Ngkarte yanheke arekenge. ");
INSERT INTO aer_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","32","Nhenge uterne-arle akertne-irrekenge Jacob-ele apmere renhe impemele alheke alkngarlpe ikwerenhe rlkerte anthurre aneke renhe-arle atwekenge, re tyertnemele alhetyame. Alakenhenge anteme tyerrtye Israel-arenye areyele kere alkngarlpe yepe-yepe-kenhe arlkwentye akngerre kwenye, nanikute-arlke pweleke-arlke, yanhe-arle artwe nhengele Jacob alkngarlpe atwekenge. ");
INSERT INTO aer_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Kele ikwere iperre Jacob-ele areke Esau uthene artwe 400-pele ikwerenhe areye-arlke arlengenge apetyerlenge. Re iparrpele ikwerenhe areye akalkelhe-ileke aharle urrpetye-werne. ");
INSERT INTO aer_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Re marle urrkapentye akngerre atherre ampe areye-akerte arrekweleke arrerneke. Re Leah ampe ikwerenhe areye-akerte mpwepeke arrerneke. Kele imerte Rachel ampe ikwerenhe Joseph-akerte ingkerneke arrernemele. ");
INSERT INTO aer_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Jacob imerte arrekwele alhemele Esau-werne atheke, ikwere anewe ampe areyele-arlke akenhe renhe apurtele ingkernenge apentewarrerlenge. Re kake ikwerenhe Esau-werne angathe anteme irreke, Jacob ikwere amperele-arlenge tnemele akaperte kwene-irreke seven-ngare anthurre. ");
INSERT INTO aer_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Kele Esau akenhe arnekarnare unteke Jacob-eke. Ratherre anyente-irreme Esau-ele renhe akwaketye-akeme akangkemele, lyete nhenhe-ante-arle arerrerne iperre, re Jacob arrwantyeke arrelyennge atherre-ante. Ratherre artnelhe-ilerreke akangkemele akngerre anthurre. ");
INSERT INTO aer_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esau-ele areke arelhe areye apetyerlenge ampe areye akenhe ingkerne, re anteme Jacob apayuthneke, “Nhenhe areye-ame ngkwinhe areye?” Jacob ikwere angkirtneke, “Yewe kake, itne-arle atyinhe-arle, Ngkarte-arle atyenge mwerre aneke, re anteme ayenge nhenhe areye antheke.” ");
INSERT INTO aer_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Kele arelhe urrkapentye akngerre atherre anteme apetyeke ampe itnekenhe-akerte, imerte inngerre kwene-akerle tnemele ikwere. ");
INSERT INTO aer_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Kele Leah anteme ampe ikwerenhe areye-arlke Esau-eke akaperte kwene-irreke. Kele Joseph uthene Rachel uthene menhenge anteme akaperte kwene-irreke Esau-eke. ");
INSERT INTO aer_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Re imerte Jacob-eke angkerlenge, “Apmwerrke the areke artwe ngkwinhe areyele nanikute uthene yepe-yepe-arlke pweleke-arlke kamule-arlke tangkeye-arlke akngetyerlenge. Iwenhenge-arle-ame unte atyenge-werne itnenhe akngetyeme?” Jacob ikwere angkirtneke, “Tharle ngenhe anthetyeke ahentye aneme tyawerrelye-arteke unte anteme atyenge akangketyeke.” ");
INSERT INTO aer_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Kele Esau ayenelhemele ilelhemele, “Alakenhe mpwaretyalaye atyinhe kele-arle atningke anthurre. Kele atnyenaye ngkwenge-arrpe!” ");
INSERT INTO aer_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Jacob akenhe ikwere akwete-arle angkerlenge, “Aye, unte apeke atyenge ahele anetye-kwenye kele ngkwenge-arrpe akngaye! Kele alakenhe imerneme unte-arle atyenge itirremele. Kele imernemele alakenhe unte atyenge mwerre-arle aneme, Ngkarte-arle atyenge alakenhe mwerre aneke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Ngkarte-arle atyenge mwerre anthurre-arle aneke atyenge re arne atningke-arlke-arle antheke. Tharle nhenhe areye ingkirreke arlkwetyeke arrangkwe-arle. Kele nhenhe areye akngaye ngkwenge-arrpe atnyenetyeke the ngkwenge akurne mpwarekenge.” Re akwete alakenhe Esau-eke angkeke. Kele Esau akangkwe-irreke Jacob-eke, imerte ikwere angkemele, “Kele. The itnenhe akngeme. ");
INSERT INTO aer_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Kele mpe. Ilerne apurte alperretyeke apmere atyinhe-werne. Ayenge arrwekelirreme.” ");
INSERT INTO aer_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Kenhe Jacob mwernte-irremele renhe ileke, “Kake urreke-aye! Unte itelareme atyinhe areye-arle ingkirreke apurrke-ante-arle unthentye ipenhe. Yepe-yepe areye-arlke, kamule areye-arlke arrpenhe areye-arlke apurrke unthentye ipenhe, akweke areyele akenhe werlatye akwete-arle antywerlte-apeme. The apeke akwete itnenhe arlte arrpenheke-atwetye unthelhe-ilemele kele itne ilwerrirretyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","The ngenhe apayuthneme arrekwele alhetyeke, kake akngerre atyinhe. The ngenhe ingkernenge apenterle-apetyenhenge. Kele ayenge mwantye-arle alheme nhenhe areye-akerte. The itnenhe uternetyakenhe iparrpe alhetyeke, mpwaretyakenhe-arle. Kake akngerre-aye, the ngenhe apmere Seir-eke urreke aretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Kele Esau anteme ikwere angkirtneke, “Kele. Mwerre-ame the artwe urrpetye atyinhe imperle-alheye arrenhantherrenhe arntarnte-aretyeke tyerrtye arrpenhe areye-ketye?” Jacob angkirtneke, “Arrangkwe, kele mwerre, kele alakenhe mpwaretyale. Kele ingkirreke itnenhe akngaye. The ngenhe akangkentye mpwaretyeke ahentye aneme.” ");
INSERT INTO aer_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Kele Esau akangkwe-irreke arlte ikwerele anteme, re artwe ikwerenhe areye-akerte alpeke apmere Seir-werne. ");
INSERT INTO aer_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Kele Jacob akenhe arnparrtye-irreke antekerre-atheke apmere Succoth-werne. Re ikwere irremele apmere ikwere arteke, ulye akweke areye anteme re arteke yepe-yepe, nanikute, pweleke, tangkeye-arlke ikwerenhe areyeke. Alakenhenge anteme re apmere renhe Succoth arritnye ileke. Arritnye Succoth ileme “Ulye akweke areye.” ");
INSERT INTO aer_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Ikwere iperre Jacob-ele apmere Succoth renhe imperle-alheke apmere Canaan-werne anteme. Re apmere mpwareke Shechem-enge ikngerreke. Alakenhenge-arle YAHWEH-ele renhe mwerre akngetye-alpeke apmere Paddan-Aram-engentyele apmere ahelhe ikwerenhe-werne. ");
INSERT INTO aer_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Ikwere ipenhe anteme re apmere renhe apwerte manele ineke. Re ngkweltye 100-pele antheke alere Hamor-kenhe areye apmereke-artweye anthetyeke apmere nhenge inetyeke. ");
INSERT INTO aer_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Kele Jacob apmere ikwerele aneke anteme, re apwerte areye lyernte-arrerneke Ngkarte tnaketyeke. Re anteme apmere renhe akeke El-Elohe-Israel. Arritnye El-Elohe-Israel ileme “Ngkarte-arle Israel-arenye areyeke Akngerrepate aneme.” ");
INSERT INTO aer_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Dinah ampe Leah-kenhe aneke, akngeye ikwerenhe Jacob-arle. Arlte anyentele re aretyeke alheke arelhe areye apmere Canaan-arenye, itne arlenge kwenye ware anetyame. ");
INSERT INTO aer_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Re alhepalherlenge, artwe anyentele renhe aretyame. Shechem arritnye ikwerenhe aneke, alere Hamor-kenhe re akenhe Hivi areye-arle aneke ikwerenhe areyeke akngerrepate. Shechem-ele renhe aremele ikwere alhirreme, re imerte amultenge tyarre-inemele renhe akurne-ileke. Re renhe anterneme, marle-arle ahentye anetyakenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Ikwere imerte mwerrentye anteme angkemele rarle ikwere ahentye-aneke anewe ikwerenhe anetyeke. Re ikwere ahentye anthurre aneke, re ikwere mwerrentye angketyame re ikwere ahentye-anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Yanhe-ngentyele Shechem alpeke imerte akngeye ikwerenheke ilemele, “Unte alhemele apayuthneye Jacob the apeke ampe ikwerenhe Dinah anewe aketyeke.” Kele Hamor yewe angkeke. ");
INSERT INTO aer_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Ikwerenge akenhe tyerrtye arrpenhele Jacob-eke ileke Shechem-elarle Dinah akurne-ilekenge. Kele Jacob akenhe nterte akwete-arle aneke ikwere alere areye-arle alethe alhekenge yepe-yepe areye arntarnte-aretyeke. Rarle nterte-nterte akarelhetyame itne-arle apetyalpetyenheke. ");
INSERT INTO aer_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Yanhenge, Hamor ikwere alere Shechem uthene apetyalperreke apmere Jacob-kenhe-werne. Hamor apetyeke layaketyeke Jacob alere ikwerenhele apeke Dinah anewe aketyeke. ");
INSERT INTO aer_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ikwerenge, tyerrtye arrpenhele ileke alere Jacob-kenhe areye nthakenhe-arle-irrekenge. Awemele arteke, itne apmere-werne alpeke. Itne apatewarreke ahele anthurre awelhemele Shechem-elarle Dinah uternerlenge ikwerenge intetyeke. Itne itirreke itneke-artweyeke areye-arle akwele apurele-anthekenge Israel-enge. Shechem kwenhe alakenhe irretyale renhe anpetyale akurne anthurre mpwarelhemele. ");
INSERT INTO aer_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Jacob uthene ikwere alere areye apurte-irreke, Hamor ilelheke iwenhenge-arle re angketyeke apetyeke: “Atyenge alere Shechem ahentye-aneme marle ngkwinhe anewe aketyeke, ratherre anewe akerreye. ");
INSERT INTO aer_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ngkwinhe areye uthene atyinhe areye uthenele kwenhe marle atningke anthurre atnyeneme. Anwerne kwenhe itnenhe anwerneke alere areye anewe aketyeke antherretyeke. Anwerneke-artweye atningke-irremele anwerne ingkirreke apurte anerlte-anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Arrantherre akenhe apmere nhenhele akwete-ante anerlte-anetyeke. Nhenhe kwenhe apmere akngerre anthurre. Unte alhetyeke ahentye-aneme apmere ikwere-werne unte kele apmere inetyeke apmere mwerre apeke.” Alakenhe-arle Hamor-ele Jacob ankeye-ankeyele apayuthneke. ");
INSERT INTO aer_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Kele ikwere-artweye Hamor-arle angkeke ipenhe kele Shechem anteme angkeke Jacob-eke uthene alere ikwerenhe areye utheneke, “Yewe, atyenge mwerre anaye the anewe aketyenhenge marle wenke ngkwinhe. Ikwerenge anteme, the ngenhe iwenhe apeke unte-arle apayuthneme renhe-arle anthetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Arrantherre apeke ayenge maneke apayuthnemele, the arrenhantherrenhe antheme-arle arrantherre ayenge renhe anewe aketyeke antherlenge. Atyenge mwerre anaye the renhe anewe aketyenhenge!” ");
INSERT INTO aer_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Kele alere Jacob-kenhe areye akenhe ahele anthurre-arle anerrirreke Shechem-elarle yaye itnekenhe Dinah akurne-ilekenge. Kele itne ularele iletyeke ahentye-aneke Shechem uthene akngeye ikwerenhe uthene itne-arle akngerreke-arle nthakenhe renhe-atherrenhe atwetyeke. Itne ikwere-atherre urrtyirreke Hamor-eke alakenhe angkemele, ");
INSERT INTO aer_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","“Anwerne yaye anwerne-kenhe Shechem anewe aketyeke anthetyeke arrangkwele-arle mpwelenhe kwenhe artwe-iletyakenhenge angkentye anwerne-kenhe-nge ularre. Anwerne apeke ipmentyele impemele unte Dinah anewe aketyeke, kele apure anthurrenge-arle alakenhe! ");
INSERT INTO aer_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Urreke unte yaye akweke anwerne-kenhe anewe aketyenhenge, tyerrtye arrpenhele-arle arrenhantherrenhe ingkirreke artwe-iletyeke. Arrantherre akenhe anwerne-arteke artwe-irretyeke, angkentye anwerne-kenhe kwenhe alakenhe. ");
INSERT INTO aer_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Arrantherre apeke ingkirreke artwe-irremele, kele anwerne apmere nhenhele anerlte-anetyeke arrekantherrenge. Anwerne marle awenke areye anewe aketyeke antherretyenhenge anwerne apurte anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Kele arrantherre apeke ampe urreye akwete anetyeke artwe-irretye-kwenye kele anwerne alheme-arle apmere nhenhenge-ntyele, anwerne-arle yaye anwerne-kenhe apmere arrpenhe-werne akngeme.” ");
INSERT INTO aer_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Kele Hamor uthene Shechem alere ikwerenhe uthenele mwerre angkeke Jacob-arle angkekenge Shechem-ele akwele Dinah anewe aketyeke. ");
INSERT INTO aer_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Shechem re iparrpe mpwareke iwenhe alere Jacob-kenhe areyele apayuthneke-arteke rarle marle wenke Jacob-kenheke arnterre ahentye-anekenge. Rarle itelareke artwe apmere yanhe-arenye itne-arle akangkwe-irrentye-akngerre akngeye ikwerenhe Hamor-eke rarle itneke akngerrepate-arle aneke re anteme ahentye-aneke ikwere alere akangkentye mpwaretyeke. Shechem akenhe Hamor-kenhe impene anthurre-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Kele Hamor apmere itnekenhe arriwe-werne alheke ikwere alere-akerte artwe areye-arle anetyame-werne apurte-irremele angkerrentye akngerre apmere ikwere-werne. Itne angkerreke nthakenhe-arle itneke Jacob angkekeke. ");
INSERT INTO aer_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","Itne alakenhe ileke, “Jacob alere ikwerenhe areye-arlke anwerneke mwerre anthurreyaye. Anwerne itneke angkeke nhenhe-werne apetyemele akwete-ante anetyeke. Nhenhe-arle apmere anteke-arle itneke-arlke. Anwerne itnekenhe marle awenke areye-arlke anewe aketyenhenge, marle anwerne-kenhele akenhe itnekenhe-arle anewe akerlenge ante. Kele anwerne apurte anerlte-anemele arne-arlke antherrerlte-anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Kele anwerne itnekenge apurte-irretyenhenge anyente ware mpwaretyeke. Anwerne-kenhe artwe areye artwe-irretyeke itne-arteke. ");
INSERT INTO aer_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Nthakenhe-ame itirreme? Anwerne apeke artwe-irremele pweleke areye-arlke yepe-yepe areye-arlke kele anwernenhe-arle antheme. Yewe, anwerne artwe-irretyekaye anwerne apurte anerlte-anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kele, itne yewe angkerreke Hamor uthene Shechem uthenenge. Itne apurte-irremele artwe-ilerretyeke. ");
INSERT INTO aer_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Arlte atherre ipenhe, itne rlkerte anthurre awelheke. Itne ware intetyame-ante arelhetyakenhe tyerrtye arrpenhe areye-ketye. Yanhe-ngentyele, alere Jacob-kenhe atherre, Simeon uthene Levi uthene, kake Dinah-kenhe atherre, apetye-alherremele itnenhe nayepe arrirlpele atantherle-anerreke. Itnenhe ingkirreke irrerlknge atwemele. ");
INSERT INTO aer_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Ratherre apetye-alherremele Hamor uthene Shechem uthene irrerlknge ante atweke. Yanhe-ngentyele itne Dinah akngirtneke apmere Shechem-kenhe-ketye. ");
INSERT INTO aer_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Lyete akenhe alere Jacob-kenhe areye alherlte-iwemele irrpenheke apmere akngerre Hamor-kenhe-werne. Itne arerrirreke tyerrtye atyalangke areye apmere arrpe-anenhe ikwerele, itne alherlte-iwemele arne ingkirreke rakewarreke. Itne alakenhe mpwareke Shechem-arle itneke apale irrekenge yaye itne-kenheke. ");
INSERT INTO aer_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Itne rakewarreke pweleke areye, yepe-yepe areye-arlke nanikute areye-arlke, tangkeye areye-arlke arne atningke anthurre tyerrtye itnekenhe. ");
INSERT INTO aer_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Itne arne mwerre akngerre areye renhe anyelkngele ineke apmere itnekenhe-ngentyele, itne arelhe areye-arlke ampe areye-arlke ingkirreke rakeke akngirtnemele apmere itnekenhe-werne. ");
INSERT INTO aer_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Nhenge kake areye apetyete-alpeke anyelknge ipenhe-akerte apmere Jacob-kenhe-werne, Jacob itneke ahele-irreke. Re Simeon uthene Levi utheneke angkeke, “Alakenhe-arle akurne anthurre-arle! Tyerrtye apmere nhenhe-arenye areye, Canaan-arenye areye uthene Perizzite-arenye areye uthenele anwerneke ilkelhetyakenhe anteme anetyenhe, itne apeke awerlenge ratherre-arle Hamor uthene Shechem uthene irrerlknge atwekenge artwe arrpenhe areye-arlke. Itne angketyenhe anwerne-arle akwele arnterte anthurre ntyentye akwele. Itne kwenhe atningke anthurre, kele anwerne-kenhe akwele artwe urrpetye ware-arle atwentye akngerre. Itne awemele nthakenhe-arle-irreke itne apurte-irremele anwernenhe atwetyeke, itne anwernenhe ingkirreke-arle atwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Simeon uthene Levi uthenele akngeye itnekenhe ilirtneke, “Aye! Iwenhenge-arle-ame unte ilernenhe alkngetherre ileme? Shechem-elarle yaye anwerne-kenhe-arle apurele-antheke. Rarle renhe uterneke ikwerenge intetyeke, arelhe akurne maneke ante interle-apentye akngerre nhenge ulkere-arteke!” ");
INSERT INTO aer_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Ikwere ipenhe Ngkartele Jacob ileke, “Apmere nhenhe imperle-alhaye, apmere Bethel-werne aname-irraye ngkwinhe areye-akerte, apmere tharle ngkwenge imerneke nhenge-werne, unte-arle urnteke nhenge Esau-ketyenge. Unte apmere ikwere irremele, apwerte akngerre areye lyernte-arrernaye unte atyenge tnaketyeke tharle ngkwenge mpwareke-ngentyele.” ");
INSERT INTO aer_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Kele Jacob anteme ileke ikwerenheke-artweye areye uthene urrkapentye akngerre ikwerenhe areyeke-arlke, “Arrantherre apeke arne akurne areye-arlke ngkarte apwerte akweke areye-arlke atnyenemele apmere arrpenhe-ngentyele, ipmentyele impaye itneke artepe arrernelhetyale, kele Ngkarte anyente-ante apenterlte-anaye. Mantere mwerreke irrperraye aletheke-arle irremenge arrantherre-arle Ngkartenge anyente-irretyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kele anwerne aname-irretyenhenge apmere apwerte-apwerte Bethel-werne. Yanhenge the apwerte areye apurte-iletyenhenge, lyernte-arrernetyeke Ngkarteke rarle ayenge arntarnte-arekenge kake atyinhe Esau-elarle ayenge alwernekenge ureke. Rarle ayenge akwetethe arntarnte-aretyartenge apeke-arle ayenge nthenhele apeke-arle ayenge anekenge-arlke.” ");
INSERT INTO aer_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Kele tyerrtye areyele mpwareke nthakenhe-arle itnenhe Jacob-ele ileke. Itne apurte-irremele arne akurne itnekenhe areye Jacob antheke, ingkirrenyeke anthurre. Itne irlpe-kenhe itnekenhe-arlke ilywemele antheke. Jacob-ele arne itnenhe akngeke alhemele apmere akngerre Shechem-werne. Re iperte akngerre tnyeke arne oak angkweye itereke apmere Shechem itwele imerte arne akurne itnenhe iperteke artemele. ");
INSERT INTO aer_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yanhe-ngentyele Jacob ikwerenhe areye-akerte-arlke Shechem-engentyele imperlte-alheke apmere Bethel-werne. Itne alherlte-iwepiwemele, Ngkartele itnenhene arntarnte-arerle-apeke. Tyerrtye apmere Canaan-arenye areyele itnenhe atwetyakenhe aneke Ngkartele-arle itnenhe aterele-anthekenge Jacob uthene areye ikwerenhe-arenyenge-arlke. ");
INSERT INTO aer_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Kele arlte urrpetye ipenhe, Jacob uthene ikwere-artweye areye uthene apmere Luz-eke arrernelheke, kenhe Luz akenhe arritnye arrpenhe Bethel-eke. Apmere re akenhe Canaan-elarle. ");
INSERT INTO aer_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yanhe ikwere-arle Ngkarte imernelheke Jacob-eke arrekwele, re alwirreke kake ikwerenhe Esau-ketye. Jacob-ele apwerte areye lyernte-arrerneke Ngkarteke tnakemele, re imerte arritnye anthemele “El Bethel.” El Bethel alakenhe ileme “Apmere nhenhe ameke-ameke, apmere Ngkarte-kenhe.” ");
INSERT INTO aer_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Jacob-kenheke-artweye anyente aneke arelhe ampwe anthurre Deborah arritnye aneke. Rarle meye Jacob-kenhe Rebekah amangkelhe-ileke. Nhenge Rebekah-arle ilwekenge anteme, Deborah re anteme anetyarte Jacob-kenhe areyenge. Itne-arle Bethel itwele anetyartenge arelhe ampwe re ilweke, itne renhe iperteke arteke arne oak artnartengeke apwerte antherrtye Bethel-enge kweneke. Itne apmere renhe ileke “Allon Bacuth.” Allon Bacuth ileme “Anwerne artneke arne oak itwele.” ");
INSERT INTO aer_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Jacob ikwerenhe areye-akerte apmere Paddan-Aram-enge apetyalpeke iperre, Ngkarte awethe Jacob-eke imernelheke, Re ayeye mwerre anthurre ikwere ileke, Re ikwere ileke rarle renhe lterrke-ileme arntarnte-aretyenhe akwetethe. Re awethe ileke nthakenhe-arle re arrekwele angkeke-arteke akwete, rarle apmere Canaan-werne atheke alpemenge. ");
INSERT INTO aer_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Re ikwere ileke, “Lyete Jacob arritnye ngkwinhe, kenhe lyete-ngentyele ngenhe tyerrtye areyele arritnye alakenhe awethe iletyakenhe-arle. The arritnye ngkwinhe akngarte-iweme Jacob-enge, Israel-werne.” ");
INSERT INTO aer_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Yanhe-ngentyele, Ngkartele renhe ileke, “Ayenge El-Shaddai, Lterrke Anthurre Nhenge! Atningke anthurre irraye atyengenge! Ampe ngkwinhe areyele ampe atningke anthurre atnyenetyenhe apmere arrpe-anenhele. Itne amangkemele itne akngerrepate arrpe-anenhe anetyenhe apmere arrpe-anenhele. ");
INSERT INTO aer_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Apmere nhenhe tharle antheke arrenge-arrenge ngkwinhe Abraham uthene akngeye ngkwinhe Isaac utheneke, the ngenhe anteme antheme, kele urreke unte ilwerlenge, the ampe ngkwinhe areye-arle antheme.” ");
INSERT INTO aer_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Ngkartele angkentye nhenhe arratye-arratye ileke Jacob-eke. Kele rarle angkeke ipenhe, re alpeke akertne-atheke Jacob imperle-alhemele. ");
INSERT INTO aer_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yanhe-ngentyele, Jacob-ele apwerte ulkere ineke imerte ngkernemele tnemele nthenhele-arle Ngkarte ikwerenge angkekenge. Nhenge re apwerte renhe ahelheke ngkernemele, re ngkwarle uthene antere uthene apwerte akertneke theleke Ngkarteke akangkemele. ");
INSERT INTO aer_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yanhe-ngentyele re apmere renhe “Bethel” arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Ikwere-arlke ipenhe Jacob-ele ikwerenhe areye-akertele Bethel imperlte-alheke, itne imerte apmere Ephrath arritnye-werne alhemele. Jacob-eke anewe Rachel atnerte-atnerte-arle aneke, re atnerte akngelhemele untherle-anemele akwete. Re rlkerte anthurre awelheke re itirremele rarle ampe akweke ikwerenhe-arle aparlpe-iletyenheke-athene. ");
INSERT INTO aer_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Rachel re rlkerte anthurre awelheke kenhe ampe akweke re akenhe intetyakenhe akwete-arle. Arelhe anyente Rachel-enge aneke re akenhe ampe akweke areye athenentye akngerre-arle. Ampe akweke re interlenge athenentye akngerre re Rachel-eke angkeke, “Atere-irretyale, unte kwenhe ampe urreye arrpenhe atnyeneme.” ");
INSERT INTO aer_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Rachel re akenhe rlkerte akngerre akwete-arle awelheke, ilwetyeke-urletye. Urreke re ilwetyenhenge re ampe urreye ikwerenhe Ben-Oni arritnye antheke. Arritnye Ben-Oni akenhe alakenhe-arle ileme “Ayenge ampe atyinhele artnetyeke mpwareke.” Kele yanhe ipenhe akenhe Jacob-ele renhe arritnye arrpenhe-arle antherlenge “Benjamin.” Arritnye Benjamin ileme “Atyinhe impene anthurre.” ");
INSERT INTO aer_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Yanhe-ngentyele Rachel ilweke anteme. Jacob-ele atyalangke ikwerenhe akngeke, re renhe iwerre itereke iperteke arteke, iwerre nhenge Ephrath-werne atheke. Ephrath nhenge arritnye arrpenhe Bethlehem-eke. ");
INSERT INTO aer_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Iperte ikwerenhe akertneke, Jacob-ele apwerte ulkere akngerre ngkerneke tyerrtye areyele itelaretyenhenge nthenhele-arle Rachel intemeke. Apwerte re akenhe aneme lyete-arlke. ");
INSERT INTO aer_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Yanhe-ngentyele, Jacob (Israel arritnye anteme lyete aneme) ikwerenhe areye-akerte anetyarte apmere arrpenhe Migdal-Eder-nge anteme. ");
INSERT INTO aer_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Itne-arle anetyartenge, alere arrekwelenye Israel-kenhe Reuben, re alhemele inteke Bilhah-enge. Bilhah akenhe urrkapentye akngerre Rachel-kenhe-arle aneke. Re akenhe anewe arteke-arle aneke Israel-eke. Israel-ele aweke nthakenhe-arle Reuben irreke. ");
INSERT INTO aer_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","26","Israel-ele alere 12-pele atnyeneke. Nhenhe-arle arritnye itnekenhe, itne ikwere inteke apmere Paddan-Aram-enge. Anewe ikwerenhe Leah-ele 6-pele atnyeneke: Reuben-eke-amparre akenhe arrekwelenye, Simeon anteme, Levi anteme, Judah, Issachar uthene Zebulun uthene anteme. Anewe arrpenhe Jacob-kenhe Rachel-ele ampe urreye atherre-arle atnyeneke, Joseph uthene Benjamin uthene. Urrkapentye akngerre Rachel-kenhe Bilhah-ele ampe urreye atherre-arle atnyeneke Dan uthene Naphtali uthene. Urrkapentye akngerre Leah-kenhe Zilpah-ele ampe urreye atherre anteye atnyeneke Gad uthene Asher uthene. ");
INSERT INTO aer_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Ikwere iperre, Jacob alpeke Mamre-werne akngeye ikwerenhe Isaac-werne itethe akwete-arle anetyame-werne. Mamre apmere arrpenhe Kiriath-Arba itwele-arle, arritnye arrpenhe Hebron aneke-arle. Yanhe ikwerele-arle Abraham uthene Isaac uthene anetyarte ipenye-arteke arrwekele. ");
INSERT INTO aer_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaac aneke year 180-pele urreke re ilwetyenhenge. Arratye, re kwenhe artwe ampwe anthurre-arle aneke. Ikwere alere Esau uthene Jacob uthenele renhe iperteke arteke. ");
INSERT INTO aer_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Artwe nhenhe Esau, arritnye ikwerenhe arrpenhe Edom aneke. Ayeye nhenhe aneme ikwere-akerte alere ikwerenhe areye-arlke-akerte itne-arle inteke, re Canaan-ele anerlenge. ");
INSERT INTO aer_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esau-ele arelhe apmere ikwerenhe-arenye anewe aketyakenhe-arle. Kele, re arelhe apmere arrpenhe-arenye-arle anewe akeke kele Canaan-arenye-ante angkentye arrpenhe angkentye akngerre. Anewe ikwerenhe arrekwelenye Adah arritnye aneke. Re akenhe ampe Elon-kenhe-arle aneke. Elon akenhe angkentye arrpenhe angkeme, Het areye-kenhe-arle. Esau-eke anewe arrpenhe Oholibamah aneke Re ampe Anah-kenhe-arle aneke, ikwere ipmenhe akenhe Zibeon-arle aneke Zibeon akenhe Hivite-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Anewe arrpenhe Esau-kenhe aneke Basemath arritnye. Re akenhe ampe marle Ishmael-kenhe-arle aneke artwe Nebaioth-eke atyeyikwe. ");
INSERT INTO aer_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Anewe Esau-kenhe Adah-ele ampe urreye atnyeneke Eliphaz arritnye. Yanhe-ngentyele, anewe arrpenhe Esau-kenhe Basemath-ele ampe urreye atnyeneke, arritnye ikwerenhe Reuel. ");
INSERT INTO aer_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Anewe ikwerenhe arrpenhe Oholibamah-ele ampe urreye urrpetye atnyeneke, arritnye itnekenhe aneke Jeush, Jalam uthene Korah uthene. Alakentyele-arle alere Esau-kenhe aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Nhenge itne-arle Canaan-ele anetyartenge, Esau-ele pweleke-arlke yepe-yepe-arlke atningke atnyeneke, alakenhe ante-arle kake ikwerenhe Jacob-ele atnyeneke. Itne kere atningke atnyeneke atherrke-arlke akenhe akweke anteme irreke apmere itne-arle anetyarte ikwerele. Kele, Esau aname-irreke kake ikwerenhe-ketye apmere arrpenhe merne-arlke atningke-arle aneme ikwere-werne kere ikwerenhe areye-akerte. Esau-ele anewe ikwerenhe areye akngeke, ampe marle areye, alere ikwerenhe urrkapentye akngerre nhenge areye-arlke, pweleke-arlke, yepe-yepe-arlke arne ikwerenhe arrpenhe areye-arlke. Re itnenhe akngeke arlenge anthurre Canaan-ketye apmere apwerte akngerre Seir arritnye-werne. Ikwerele itne akwete-ante anthurre anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Ayeye nhenhe Esau-akerte. Esau-arle apmere Seir-werne alpeke-akerte, ikwere akwerrke areye akngerre-ame-akngerre anteme irreke itne anetyarte, itne Edom arritnye akelhewarreke. Nhenhe akwerrke Esau-ke areye: ");
INSERT INTO aer_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","13","Alakenhe-arle arrekwele intelhe-ileke, Esau-ele alere atnyeneke anewe ikwerenhe Adah-eke. Eliphaz arritnye ikwerenhe aneke. Anewe alere arrekwelenye-kenhele ampe five-pele atnyeneke: Teman, Omar, Zepho, Gatam, Kenaz uthene. Kenhe anewe arrpenhe Timna-ke, Eliphaz-ele alere arrpenhe atnyeneke, Amalek arritnye aneke. Yanhe iperre, anewe arrpenhe Basemath-ele ampe urreye anyente atnyeneke, Reuel arritnye aneke. Kenhe Reuel anewe akerremele, alere four-pele atnyeneke: Nahath, Zerah, Shammah, Mizzah uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Alakenhe intelhe-ilentye aneke. Mpwepe ipenhe anewe Esau-kenhe marle Oholibamah-kenhe aneke ipmenhe Zibeon-kenhe. Oholibamah-ele alere urrpetye atnyeneke Esau-eke itnekenhe arritnye aneke Jeush, Jalam uthene Korah uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","16","Tyerrtye Edom-arenye areyele akngerrepate itnekenhe Esau-arle aneke. Akngerrepate nhenhe itne aneke Eliphaz-kenhe areye-arle, Esau uthene Adah utheneke alere areye: Teman, Omar, Zepho, Kenaz, Korah, Gatam uthene Amalek uthene, itne Edom-arenye areyeke akngerrepate areye aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Tyerrtye arrpenhe areye aneke Reuel-kenhe areye-ngentyele Esau uthene Basemath uthene-kenhe: Arritnye itnekenhe aneke: Nahath, Zerah, Shammah, Mizzah-arlke. ");
INSERT INTO aer_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","19","Tyerrtye arrpenhe areye aneke anewe Esau-kenhe Oholibamah-ngentyele. Itne aneke Jeush, Jalam uthene Korah uthene. Nhenhe itne Anah-eke ipmenhe areye-arle. ");
INSERT INTO aer_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Urreke-arle Esau ikwerenhe areye-akerte aname-irretyenhenge, tyerrtye apmereke-artweye areye itnekenhe Seir-eke akwerrke areye-arle aneke. Artwe nhenhe Seir, Hor-arenye areye-kenhe-arle. Re-arlke tyerrtye atningkenge itne anetyarte apmere Edom-ele. Alere Seir-kenhe areye arritnye aneke Lotan, Shobal, Zibeon, Anah, Dishon, Ezer uthene Dishan uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Lotan alere atherre-akerte, Hori uthene Homam uthene. Yaye akweke Lotan-kenhe aneke, Timna arritnye anemele. ");
INSERT INTO aer_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Alere Shobal-kenhe areye, itne aneke Alvan, Manahath, Ebal, Shepho uthene Onam uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zibeon alere atherre-akerte. Aiah uthene Anah uthene. Anah yanhe rarle akenhe kwatye pintye nhenge apmere ahurratyele areke kwatye urinpe ahelhe-ngentyele arraterlenge arrule akngeye ikwerenhe-kenhe tangkeye areye arntarnte-arerle-anemele. ");
INSERT INTO aer_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Anah ampe atherre-akerte, Dishon uthene arelhe Oholibamah uthene. Oholibamah anewe Esau-eke ante aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Alere Dishon-kenhe areye aneke, arritnye itnekenhe Hemdan, Eshban, Ithran uthene Keran uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Alere Ezer-kenhe areye, arritnye itnekenhe aneke, Bilhan, Zaavan uthene Akan uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Dishan alere atherre-akerte, arritnye ikwere-atherrenhe Uz uthene Aran uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Tyerrtye nhenhe areye Horite areyeke akngerrepate anerrirreke apmere Seir-ele aneke: Lotan, Shobal, Zibeon, Anah, ");
INSERT INTO aer_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Dishon, Ezer uthene Dishan uthene. ");
INSERT INTO aer_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Apmere Edom ikwerele, urreke Israel areyele Akngerrepate atnyenetyenhenge, tyerrtye arrpe-anenhe-arle akngerrepate aneke arrpenhe-ngentyele arrpenhe-werne. Nhenhe-arle akenhe arritnye itnekenhe: ");
INSERT INTO aer_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Arrekwele apmere ikwere akngerrepate aneke Bela, Beor-eke alere. Re apmere arrpenhe Dinhabah-engentyele-arle. ");
INSERT INTO aer_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Nhenge Bela-arle ilwekenge anteme, kenhe Jobab anteme-arle akngerrepate anerlenge, re anteme apmereke akngerrepate aneke. Re akenhe Zerah-ke alere-arle aneke apmere Bozrah-arenye. ");
INSERT INTO aer_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Kenhe Jobab ilwekenge anteme, kele Husham anteme akngerrepate aneke. Re anteme-arle akngerrepate irreke Re akenhe apmere tyerrtye Teman-kenhe areye-ngentyele-arle. ");
INSERT INTO aer_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Kenhe Husham-arle ilwekenge kele Hadad anteme-arle akngerrepate aneke Re anteme apmere ikwere akngerrepate aneke akngeye ikwerenhe Bedad-arle aneke, re akenhe thultye angkweye-arle aneke arrule-ngentyele, re akenhe apmere Midian-arenye thultye areye-arlke-arle atweke apmere Moab ikwere Haddad re akenhe Avith-kenhe-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Kenhe Hadad-arle ilwekenge, kele Samlah anteme-arle akngerrepate aneke. Re anteme-arle apmere ikwerenheke akngerrepate anerlenge. Re akenhe Masrekah-arenye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Kenhe Samlah-arle ilwekenge, Shaul anteme-arle akngerrepate aneke. Re anteme-arle apmereke akngerrepate aneke. Re akenhe Rehoboth-arenye-arle aneke, apmere kwatye lhere akngerre itwele. ");
INSERT INTO aer_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Kenhe Shaul-arle ilwekenge, Baal-Hanan anteme-arle akngerrepate aneke, Re anteme-arle apmere ikwerenheke akngerrepate aneke. Re akenhe Pau-arenye-arle aneke. Akngeye ikwerenhe akenhe Achbor-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Kele Baal-Hanan-arle ilwekenge, Hadar anteme-arle akngerrepate aneke, Re anteme-arle apmere ikwerenheke akngerrepate aneke, Anewe ikwerenhe akenhe Mehetabel-arle aneke, re akenhe ampe Matred-kenhe-arle aneke. Kenhe arritnye meye Matred-kenhe aneke Me-Zehab-arle. ");
INSERT INTO aer_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","43","Nhenhe-arle akenhe arritnye aneme akngerrepate areye Esau-ngentyele apmere Edom ikwerele-arle aneke. Timna, Alua, Jetheth, Oholibamah, Elah, Pinon, Kenaz, Teman, Mibzar, Magdiel uthene Iram uthene. Kele alere nhenhe areye amangkewarremele, itne apmere arrpe-anenhele anetyeke alherlte-iweke. Apmere arrpe-anenhele itne akngerrepate areye anerrirreke itne-kenheke-artweye areyeke apmere itnekenhe arritnye aneke alereke akngerrepate itne-arteke. ");
INSERT INTO aer_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Akngeye Joseph-kenhe Jacob anetyarte apmere Canaan-ele, apmere akngeye Jacob-kenhe Isaac-arle unthetyarte apmere arrpe-anenhele. ");
INSERT INTO aer_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Ayeye nhenhe Jacob-kenhe areye-akerte. Alere Jacob-kenhe, Joseph re 17 years old aneke. Kake ikwerenhe areye akenhe meye urrpetye-ngentyele-arle, Leah, Bilhah, Zilpah. Bilhah uthene Zilpah uthene anewe Jacob-kenhe atherreke-urrke urrkapetyarte Leah uthene Rachel utheneke. Jacob-arle akenhe akngeye aneke urreye itneke. Joseph kake ikwerenhe areyele-arlke yepe-yepe areye-arlke nanikute areye-arlke arntarnte-aretyarte. Ikwere ipenhe Joseph ayeye-akerte apetyalpeke akngeye ikwerenheke iletyeke kake ikwerenhe areyele-arle akurne mpwarekenge iletyeke. ");
INSERT INTO aer_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Jacob anteme (Israel-arlke renhe ileme) Joseph-eke arnterre anthurre ahentye-aneke alere arrpenhe areyenge awethe-ulkere rarle artwe ampwe aneke Joseph-arle intekenge. Re ahentye-aneke Joseph akngerre anthurre ikwerenge anteme re ikwere mantere mwerre alkarle amulte arlpentye-akerte mpwareke. ");
INSERT INTO aer_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Kake Joseph-kenhe areyele itelarerrirreke Jacob-arle ikwere arnterre ahentye-aneke. Ikwerenge anteme itne ikwere ahentye-anetyakenhe anetyarte. Itne ikwere mwerrantye angketyakenhe anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","7","Awethe ante alakenhe-irrekenge kake ikwerenhe areye ahele anthurre mpwareke. Ingwe anyentele Joseph-ele altyerre areke. Yanhe iperre re kake ikwerenhe areyeke ileke: “Nhenhe awerrirraye: Ingwele the altyerre areke. Anwerne apurte urrkapemele merne inerrirretyame. Anwerne name annge-akerte aketyame imerte ayernerlte-anemele anyenteke-anyente ahelheke imerte athenemele anwerne name annge-akerte areye urreke inetyenhenge. Ikwerenge anteme name tharle ayerneke akenhe tnerle-alheke tyerrtye-arteke re-arrpe akwete. Kele arrantherre-arle ayerneke areye akenhe tnemele imerte kwene-irreme atyenge, atyinhe-arle atyeperre anthurre-arle anekenge. Yanhe-arle the altyerre atyinhenge areke.” Kele kake ikwerenhe areyele renhe awemele ahele anthurre irrerirreke awethe ulkere anteme. ");
INSERT INTO aer_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Kele kake ikwerenhe areye ikwere angkerrirreke, “Unte-ame itirreme unte akwele anwerneke akngerrepate anetyeke?” Kake ikwerenhe areye ikwere ahentye-anetyakenhe rarle altyerre nhenhe ilekenge. ");
INSERT INTO aer_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ikwerenge Joseph-ele altyerre arrpenhe anteme areke. Ingweleme anteme re akeme-irremele angkeke kake ikwerenhe areyeke, “Ingwele the altyerre arrpenhe areke. The uterne areke, atnyentye, kwerralye 11-pele anthurre, itne atyenge kwene-irrerreke ayenge-arle atyeperre anthurre anekenge.” ");
INSERT INTO aer_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Kele Joseph alheke akngeye ikwerenhe Jacob-eke iletyeke altyerre ikwere-akerte. Nhenge akngeye ikwerenhele altyerre ikwere-akerte awemele, re Joseph-eke ahele-irreke, Jacob imerte ikwere angkemele, “Unte kwenhe altyerre arerne anwerneke iletyale kwenhe anetyakenhe, iwenhenge-arle-ame unte anwerneke altyerre nhenhe ileke? Meye ngkwinhe, kake ngkwenge areye ayenge-arlke arrpenhe areye-arlke, anwerne-arle ngkwenge artepe arrernelhetyeke arrangkwe-arle!” ");
INSERT INTO aer_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Kake Joseph-kenhe areye ingkerte anthurre irreke. Kenhe akngeye ikwerenhe Jacob akenhe akwete-arle itirreke nthakenhe-arle Joseph-ele altyerre areke. ");
INSERT INTO aer_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","14","Ikwere ipenhe Jacob ikwere-artweye areye-akerte apmere Hebron-ele anetyarte. Kake Joseph-kenhe areyele yepe-yepe areye akngeye ikwerenhe-kenhe akngeke Shechem-werne itnenhe arntarnte-aretyeke. Ikwerenge anteme, Jacob Joseph-eke antangkelheke imerte ikwere angkemele “Kake ngkwinhe areyele yepe-yepe areye arntarnte-areme apmere Shechem-ele. The ngenhe apmere yanhe-werne yerneme. Itneke-werne alhaye, aretyeke yepe-yepe itnarle arntarnte-areme areye apeke-arle mwerreke. Imerte apetyalpemele atyenge iletyeke nthakenhe-arle kake ngkwinhe areye irreme, itne mwerre apeke?” Joseph angkirtnerlenge akngeye ikwerenheke, “Yewe, kele ayenge Shechem-werne alhetyenhenge.” Kele Joseph-ele apmere yanhe imperle-alheke ayerrere-atheke imerte alhemele apmere Shechem-werne. Kele arlte arrpenhe ikwerele re Shechem-eke arrernelheke. ");
INSERT INTO aer_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Re apateke nthenheke re itnenhe aretyenheke, apmere arrpe-anenhele unthemele, re kake ikwerenhe-kenhe yepe-yepe areyeke untheke. Artwe anyentele renhe apayuthneke apatemele tnerle-anerlenge, “Iwenheke-ame unte areme?” ");
INSERT INTO aer_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Joseph artwe ikwere angkirtneke, “Ayenge kake atyinhe areyeke apale untheme yepe-yepe-arle arntarnte-areme areyeke, unte apeke akaltye aneme nthenhele apeke-arle itne anemeke?” ");
INSERT INTO aer_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Artwe re anteme Joseph-eke angkeke, “Ye, nhenhele akwele itne aneke, kele itne alheke-arle. Itne angkeke apmere Dothan itwe-werne akwele alhetyeke.” Ikwere iperre Joseph apmere ikwerenge imperle-alheke Dothan ikwere-werne alhemele. Re ikwere arrernelhemele, kake ikwerenhe areye yepe-yepe areye-arlke areke irntwarrenge akwete. ");
INSERT INTO aer_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Kenhe kake Joseph-kenhe areyele renhe irntwarrenge akwete-arle anareke. Iparrpe-iparrpe itne angkerreke nthakenhe renhe irrerlknge atwetyeke. Ahele itne angkerreke, ");
INSERT INTO aer_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","“Aye, araye, Joseph altyerre arentye akngerre nhenge apetyeme! ");
INSERT INTO aer_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kele renhe atwerrirretyekaye, atyalangke renhe anwerne iperteke iwetyenhenge. Akngeye anwerne-kenhele apeke apayuthnemele ikwere, anwerne akenhe akngwelye artnwerele arlkweke-arle ilerlenge. Ye, kele renhe atwerrirreye! Re kwenhe anwerneke akngerrepate anetyakenhe. Ayeye-arle re anwerneke ileke altyerre ikwerenhe-akerte, kele arrangkwe-arle anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Kenhe kake itnekenhe Reuben-ele itnenhe aweke arretyerlte-anerlenge Joseph atwetyeke, re itnenhe ileke urreke akarelhetyeke. Re itneke angkeke, “Urrekaye, anwerne atwetyale anetyeke! ");
INSERT INTO aer_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Renhe impaye, atwetyale! Nhenhe iperteke ware iwetyeke imerte impemele.” Alakenhe-arle Reuben angkeke kake ikwerenhe areyeke. Reuben-arle itirreke renhe urreke tyerretyeke iperte ikwerenge-ntyele imerte yernirtnemele akngeye itnekenhe-werne. ");
INSERT INTO aer_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","24","Itne akwete angkerrerlte-anerlenge Joseph angathe-ame-angathe-irreke, kele kake ikwerenhele renhe arntwirrkeke. Itne mantere mwerre akngerre renhe ilywerrirreke re irrpekenge akngeye itnekenhe-arle ikwere mpwaremele antheke. Itne renhe akngemele alhwenge iperte akngerreke iwerrirreke. ");
INSERT INTO aer_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Yanhenge iperre itne anerrirreke, merne anteme itne arlkwerrirretyame, itne areke tyerrtye arrpenhe areye apetyewarrerlenge apmere arlenge-arenye areye. Itne areke tyerrtye arne antherrentye akngerre areye apmere Midian-arenyenge, iwerre anyente ikwerele itne alheke iwerre apmere Gilead-engentyele apmere arrpenhe Egypt-werne atheke. Kamule areye yakwethe arrpe-anenhe-akerte aneke arne arunthe-akerte, itne arne itnenhe akngeke sell-eme-iletyeke Egypt-werne. Yakwethe itnekenhele aneke arrkipere-arteke-arlke, arne arrpenhe ikwemeye ntyentye akngerre areye-arlke. ");
INSERT INTO aer_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Kele Judah angkeke, kake ikwerenhe areye re ileke, “Anwerne apeke atyeye akweke atwerlenge akngeye anwerne-kenhe ularele ileme, kele arne mwerreke arrangkwe anwerneke irretyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kele anwerne apeke renhe tyerrtye arne antherrentye akngerre areye maneke anthemele, anwerne nhenhe itethe impetyeke-arle, renhe atwetyale. Akngeye ikwerenhe kwenhe anwerne-kenhe akngeye-arlke. Anwerne kele renhe nhenhe areye anthetyeke maneke ware renhe atwetyale.” Kake Judah-kenhe areye mwerre angkerreke. ");
INSERT INTO aer_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Ikwerenge tyerrtye Midian-arenye itne apmere itne-kenheke itwe-irreke. Kake ikwerenhe areyele Joseph renhe iperte-ngentyele tyarre-ineke imerte renhe sell-eme-ilemele silver 20-pele anthurreke. Yanhe-ngentyele tyerrtye arne antherrentye akngerre areye itne aletheke irreke Joseph renhe-arlke itne akngeke Egypt-werne. ");
INSERT INTO aer_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Yanhe-ngentyele, Reuben alheke Joseph iperte-ngentyele tyarre-inetyeke, re areke iperte renhe imerte arrangkwe-arle aremele. Re anteme mantere ikwerenhe alterremele ahele-anthurre-irremele itneke. ");
INSERT INTO aer_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Re anteme kake ikwerenhe areye-werne alpemele, itnenhe ileke, “Ayekaye! Nthakenhe-ame atyeye akweke anwerne-kenhe irreke nthenhe-ame re alheke? Ayenge akutne-arle nthenhe-werne-arle re alheke. Nthakenhe-ame ayenge irreye?” ");
INSERT INTO aer_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Itne renhe tyernetyakenhe. Itne alhemele nanikute atwetyeke alheke itne-arle angkerreke-arteke. Itne renhe akngetye-alpeke, imerte mantere Joseph-kenhe nanikute alhweke-arleke akwerneke. ");
INSERT INTO aer_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Itne imerte alpemele akngeye itne-kenheke iletyeke, itne mantere renhe ikwere imerneke. Itne imerte ikwere alakenhe angkemele, “Anwerne mantere nhenhe kutyeke arne artneke. Nhenhe akwele unte mpwareke ngkwenge alereke?” ");
INSERT INTO aer_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Jacob-ele mantere alhengke-aremele, re angkeke, “Ayekaye! Mantere nhenhe-arle alere atyinhe-kenhe-arle. Kele apeke-arle akngwelye artnwerele renhe uthnemele arlkweke. Kele ilweke-arle rarle re. Itne-arle renhe alterremele uthnerrirreke.” ");
INSERT INTO aer_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Jacob-ele anteme mantere ikwerenhe-arrpe anteme alterreke, akayale arrangkeke. Re anteme mantere urrperleke irrpeke, ahelheke arrernelhemele, alpmenyele anteme artelhemele alhwarrpe anthurre intetyame. Re ikwerele anemele akwete anthurre artnetyame. ");
INSERT INTO aer_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Alere-arlke arelhe-arlke ampe ikwerenhe areye untetyeke ikwere-werne ikwerenge itne anerrirreke. Itne ingkirreke anthurre artnerrirreke. Itne renhe arrkernemele anthurre ntertelhe-iletyeke alkngwirretyeke mpwaremele-arlke re alere ikwerenhe-arle ilwekenge. Jacob alhwarrpe akwete aneke, anteme itneke angkeke, “Ayenge imperrirraye atyenge alereke artnetyekaye. Ayenge-arle akwete-arle akaye artnerle-anetyenhe ayenge ilwetyeke-atwetye ikwere ayenge interteke irretyeke irrerlknge areye-arle aneme-werne. Yanhe ikwere-arle ayenge nterte-irremele anetyenhe.” Arratye, yanhenge anteme Jacob alhwarrpe anetyarte arrule-ngentyele alere ikwerenhe Joseph-eke. ");
INSERT INTO aer_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nhenge Midian-arenye areyele Joseph akngeke Egypt-werne, itne Egypt-arteke irremele itne renhe sell-eme-ileke maneke artwe Potiphar arritnyeke. Kele Potiphar re akenhe artwe alartetye Pharaoh-ke-arle urrkapetyarte, Egypt-arenye areyeke akngerrepate atyeperre ikwere. Potiphar akenhe akngerrepate aneke thultye areyeke jail-le. ");
INSERT INTO aer_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yanhenge Judah kake ikwerenhe areye imperle-alheke apmere arrpenhe-werne Canaan-enge. Re anetyarte artwe Hirah arritnyenge. Hirah akenhe apmere akweke-arenye-arle aneke, Adullam arritnye anekenge. ");
INSERT INTO aer_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Nhenge Judah-ele apmere ikwerele anetyarte, re areke marle Canaan-arenye anyente re ahentye-aneke anewe aketyeke. Akngeye ikwerenhe Shua arritnye aneke. Kele artwe re marle renhe anewe akeke, ratherre apurte anteme inteke. ");
INSERT INTO aer_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Ikwerenge anteme arelhe re atnerte-atnerte-irreke, re anteme ampe urreye akweke atnyeneke, Judah-ele anteme urreye akweke renhe Er arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Kele awethe anteme re ampe urreye akweke arrpenhe atnyenemele Onan arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Imerte urreye akweke arrpenhe anteme atnyenemele imerte Shelah arritnye anthemele. Judah akenhe apmere Kezib arritnyele-arle aneke ikwerele ureke. ");
INSERT INTO aer_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Alere arrekwelenye Judah-kenhe Er amangkeke anteme, Judah-ele arelhe anteme ikwere ineke re anewe aketyeke. Tamar arritnye ikwerenhe aneke. ");
INSERT INTO aer_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Kenhe Er akenhe artwe akurne-arle aneke. YAHWEH-ele renhe areke akurne mpwarerlenge, re anteme renhe ilwetyeke mpwareke. ");
INSERT INTO aer_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Kele Er-arle ilwekenge anteme, akngeye ikwerenhe anteme angkeke atyeye ikwerenhe Onan-eke, “Kake ngkwinhe Er-ele alere atnyenetyakenhe-arle aneke. Unte kwenhe Tamar-enge intetyeke re ngkwenge ampe atnyenetyenhenge. Kele ampe yanhe re Er-kenhe-arle anetyenhe. Angkentye anwerne-kenhe-ngentyele-arle alakenhe.” ");
INSERT INTO aer_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Kele Onan akenhe alakenheke ahentye anetyakenhe-arle aneke, alere yanhe-arle ikwerenhe anetyakenhenge. Re-arrpe itirreke, “Ayenge apeke Tamar-enge intemele, re apeke ampe atnyenemele, ampe rarle atyinhe anetyakenhe-arle aneme.” Kele re alhemele Tamar-enge aneke, kele re ikwerenge intetyakenhe-arle aneke. Alakenhenge-arle re atnerte-atnerte-irretyakenhe aneke re ampe atnyenetyakenhe aneke anewe ilwekarle ikwere-arlke. ");
INSERT INTO aer_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","YAHWEH ahele-irreke rarle Onan arekenge Tamar-enge intetyakenhenge. Re anteme Onan ilwetyeke mpwareke. ");
INSERT INTO aer_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Judah anteme atere-irremele re-arrpe anteme angkeke, “YAHWEH apeke alere ingkernenye atyinhe anteme ilwetyeke mpwaretyenhe rarle Er uthene Onan uthene ilwetyeke mpwareke-arteke.” Re anteme alhemele Tamar-eke angkeke, “Alpaye ngkwenge-artweye atherre-werne imerte anemele itnekenge akwete anthurre. Artwe arrpenhe anewe aketyale. Atyenge alere Shelah kwenhe ampe urreye akweke ware-arle kele the ngenhe apayuthneme ikwere unte akarelhetyeke. Re amangkemele, unte renhe anewe aketyeke.” Kele Tamar re alpeke apmere ikwere-artweye atherre-kenhe-werne anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","14","Arrulenge arrpenhele anewe Judah-kenhe, ampe Shua-kenhe, ilweke. Judah-arle akaye-akerte aneke ipenhe re atyewe ikwerenhe Hirah uthene alherreke artwe urrkapentye akngerre ikwerenhe areye aretyeke. Itne alte yepe-yepe areye-kenhe akerrirretyame. Tyerrtye arrpenhele Tamar-eke ileke ampatye-ampatye ikwerenhe-arle Timnah-werne alheme yepe-yepe areye alte aketyeke. Re ayeye awemele arteke, re ahele-irreke Judah-eke re angkentye ikwerenhe atnyenetyakenhenge. Kenhe Shelah akenhe artwe anteme-arle irrekenge. Kele Judah-ele akenhe renhe anewe anthetyakenhenge. Kele re itirreke nthakenhe irretyeke. Re anteme mantere ikwerenhe ilywelheke rarle warlekwerte anekenge re imerte mantere alkarle anthurreke anteme irrpemele. Re anteme mantere akweke arrernemele inngerre ikwerenhe artelhemele renhe alhengke-arerrirretyakenhe anetyenhenge. Re anteme apmere Enaim arritnye-werne alheke, Timnah-werne atheke-arle anteme. Re ikwere irremele arteke arrernelheke iwerre itereke Timnah atheke ikwere. Judah-eke re akarelhetyame rarle anpere alhetyenheke. ");
INSERT INTO aer_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yanhe-ngentyele Judah anpere alheke Tamar-arle anetyamenge ikwerele. Re renhe areke imerte renhe alhengke-aretyakenhe-arle anemele rarle inngerre ikwerenhe artelhekenge imarteye re-arrpe anteme itirreke, “Angwenhe-arle-ame arelhe yanhe? The apeke renhe mane anthemele, re imerte atyengenge interle-apeke.” ");
INSERT INTO aer_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Re akenhe itelaretyakenhe arelhe ampatye-ampatye ikwerenhe, Judah ikwere-werne alhemele ikwere angkeke, “Ayenge ahentye-aneme ngkwengenge intetyeke.” Kele re ikwere angkirtnerlenge, “Ayenge apeke ngkwengenge interlenge, iwenhe apeke renhe unte-arle ayenge antheme?” ");
INSERT INTO aer_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Judah ikwere angkirtnerlenge, “Unte apeke atyengenge interlenge, the ngkwenge nanikute akweke-arle yerneme.” Kele Tamar anteme angkeke ikwere, “Kele mwerre. Kele iwenhe anteme unte ayenge anthetyenhe unte-arle angkentye ngkwinhe arratye apeke atnyenemele imerte nanikute renhe ayenge anthemele?” ");
INSERT INTO aer_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Judah ikwere angkirtneke, “Iwenhe-ame ngenhe anthetyeke unte ahentye-aneme?” Re ikwere angkirtneke alakenhe, “Arne nhenge iltye-kenhe string-akerte ngkwinhe ayenge anthaye unte impatye ilentye akngerre ngkwinhe, atneme ngkwinhe-arlke.” Kele Judah-ele renhe iltye-kenhe impene antheke, atneme ikwerenhe-arlke. Kele ratherre apurte inteke anteme. Tamar atnerte-atnerte anteme irreke. ");
INSERT INTO aer_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Kele Judah-arle alhekenge anteme, Tamar apmere-werne anteme alpeke. Re mantere inngerre ikwerenhenge ilywelheke, re imerte mantere rarle arrekwele irrpeke ikwere anteme irrpemele. ");
INSERT INTO aer_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Judah alpeke apmere arratye nhenge-werne arntarnte-arentye akngerre areyele-arle yepe-yepe areye atnyenetyame ikwere-werne. Re nanikute akwerrke ineke atyewe ikwerenhe Hirah imerte renhe anthemele ileke, “Nhenhe akngaye imerte arelhe arriwele-arle aneme nhenge anthemele Enaim-eke. Iltye-kenhe uthene atneme uthene atyinhe inetyeke alhaye ikwerenge-ntyele imerte atyenge akngetye-alpemele” Kele Hirah re alheke Enaim-werne ikwere arerle-apemele, re akenhe renhe aretyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Re artwe areye tnerlte-anetyamenge-arle areye apayuthneke, “Nthenhe-ame arelhe nhenge nhenhele-arle anetyarte, unte itelareme maneke-arle artwenge intentye akngerre nhenge?” Itne ikwere angkirtneke, “Arelhe akurne re-arteke-arle nhenhe arrangkwe-arle.” ");
INSERT INTO aer_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Kele Hirah-ele nanikute akwerrke renhe akngirtneke Judah-werne, imerte angkemele, “The kwenhe arelhe ikwere arrangkwe areke. Artwe nhakwe areyele atyenge ileke arelhe akurne alakenheke-arle arrangkwe-arle nhenhe.” ");
INSERT INTO aer_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Judah akenhe ikwere angkerlenge, “Kele unte unthetyeke alheke ikwere nanikute nhenhe anthetyenhenge tharle ngenhe ileke-arteke. Awethe ikwere alpetyale. Unte apeke alpemele, arrpenhe areyele ilernenhe arrkentye-arle-ileme.” ");
INSERT INTO aer_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Atnyentye arrpe-anenhe ipenhe artwe urrpetye apetyemele Judah-eke angkeke, “Aye! Ampatye-ampatye ngkwinhe nhenge Tamar akurne-irreke re kwenhe atnerte-atnerte anteme. Re apeke-arle artwenge intetyarte maneke-ante atheke.” Kele Judah ahele anthurre irremele angkeke itneke, “Alherlte-iwaye renhe inetyeke imerte atyenge-werne akngetyemele imerte anwerne renhe arnele atwetyenhenge iperte-werne atheke!” ");
INSERT INTO aer_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Kele itne alherlte-iwemele renhe inetyeke. Itne apmere ikwerenheke irretye-alherlenge, re itnenhe ayakemele ileke, “Urrekaye, the angkentye yernetyeke ahentye-aneme ampatye-ampatye atyinhe Judah-werne. Arne iltye-kenhe nhenhe-arlke atneme nhenhe-arlke akngaye ikwere imernetyeke. Renhe imerte apayuthnemele arne angwenhe-kenhe nhenhe areye. Ayenge-arle arne nhenhe areyeke artweyenge-arle inteke. Alakenhenge-arle ayenge atnerte-atnerte.” ");
INSERT INTO aer_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Artwe itne atneme uthene arne iltye-kenhe uthene Judah-eke imerneke, re arne ikwerenhe areye arratye alhengke-areke. Re artwe itneke angkeke, “Ayenge-arle akurne anthurre-arle Tamar akenhe arelhe mwerre. The kwenhe alere atyinhe Shelah renhe anthetyakenhe, arrule-arle the renhe alhilekeke.” Re anteme Tamar apmere ikwerenhe-werne akngirtneke re ikwerenge awethe intetyakenhe aneke, arrangkwe. ");
INSERT INTO aer_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Atnyentye six-pele-iperre, Tamar-ele kele akweke atnyenetyeke anteme irreke. Arelhe arrpenhe ikwerenge aneke. Re itelareke Tamar-ele-arle ampe akweke atherre atnertele atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kele akweke ratherre intemenge, iltye akweke anyente-urrke arrateke. Arelhe re ampe akweke nhenhe mantere athethekele ayerneke iltye ikwerenhe. Re Tamar-eke angkeke, “Ampe akweke nhenhe apele arrekwele inteke-arle.” ");
INSERT INTO aer_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Kele ampe akweke re akenhe iltye atnerte Tamar-kenheke irrpirtnerlenge. Kele ampe akweke arrpenhe rarle arrekwele arraterlenge. Arelhe re imerte ikwere angkemele, “Aye! Unte-arle arrekwele arrateke kake ngkwinhenge arrekwele-arle.” Itne renhe Perez arritnye antheke alakenhe ileme, “Unte-arle arrekwele arrateke.” ");
INSERT INTO aer_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Kele ampe akweke arrpenhe anteme arrateke, mantere athethekele-arle iltye ayerneke re. Itne renhe Zerah arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Arrule anthurre nhenge Joseph-arle kake ikwerenhe areyele maneke antherreke tyerrtye arne antherrentye akngerre areyeke, itne renhe apmere Egypt-werne akngerlte-iweke. Itne artwe akngerre Potiphar arritnyeke renhe antheke. Potiphar re akenhe thultye-arteke-arle urrkapetyarte Pharaoh Egypt-arenyeke. Re akngerrepate atyeperre aneke urrkapentye akngerre areyeke-arlke urrkapentye akngerre Pharaoh-kenhe areyeke-arlke. Urrkapentye akngerre itnekenhe thultye-arteke areyele Pharaoh ilpemele. ");
INSERT INTO aer_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Joseph re urrkapetyarte Potiphar ikwerenhe apmerele, artwe re Egypt-arenye ikwere. Yanhe ikwerele ureke akenhe YAHWEH-elarle renhe arntarnte-aretyarte. Joseph re kele mwerre anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Potiphar-ele areke Joseph-arle mwerre urrkapetyarte. Potiphar-ele itelareke YAHWEH-elarle Joseph arntarnte-aretyarte Joseph-arle mwerrantye urrkapetyartenge. ");
INSERT INTO aer_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Potiphar re akenhe akangkentye anthurre-arle aneke Joseph-eke renhe ileke, “Joseph, unte kwenhe urrkapentye akngerre mwerre anthurre. Kele unte-ante anteme ayenge arntarnte-aretyeke the ngenhe apmere atyinheke akngerrepate arrerneme, atyenge-artweye areyeke uthene urrkapentye akngerre atyinhe areyeke-arlke. Lyete-ngentyele unte arne ingkirreke atyinhe areye urrkapentye akngerre arrpenhe atyinhe areyeke-arlke akngerrepate anemele arntarnte-aretyeke.” ");
INSERT INTO aer_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yanhe-ngentyele, Joseph-ele Potiphar-eke-artweye areye-arlke arne ingkirreke ikwerenhe areye-arlke arntarnte-aretyarte. YAHWEH Joseph-enge anerle-anetyarte, alakenhe ikwerenge Potiphar-eke-artweyele arne atningke inerrirrekenge. Apmere ikwerenhele, YAHWEH-ele arne areye merne-arlke atningke-akerte lyapelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Alakenhe ikwerenge-arle Potiphar-ele Joseph ingkirreke anthurreke akngerrepate mpwareke. Potiphar kele akngerre itirretyakenhe-arlke anetyale. Re itirretyarte-ante merne iwenhe-arteke ware arlkwetyeke. Joseph akngerre lterrke, mwerre akngerre anthurre aneke. ");
INSERT INTO aer_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Kenhe anewe Potiphar-kenhele renhe ntertele aretyarte ikwere itirremele-arlke. Arlte anyentele re renhe ileke, “Joseph apetyaye, atyengenge intetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Kenhe Joseph akenhe ayene-ilelheke, renhe awemele angkerlenge, “Arrangkwe, ayenge-arle ngkwenge intetyeke kwenye-arle! Ngkwenge anewe kwenhe akngerrepate atyinhe. Re ayenge arne ingkirreke anthurre ikwerenhe-arle antherlenge arntarnte-aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ayenge urrkapentye ingkirreke ikwerenhe areyeke akngerrepate. The kwenhe akngerrepate arrpenhe atnyenetyakenhe. Ngkwenge anewele kwenhe ayenge arne ingkirreke anthurre ikwerenhe antheke. Re kwenhe atyenge-ketye alengke-iwelhetyakenhe. Unte kwenhe ikwere anewe. Ngenhe-ante kwenhe re ayenge anthetyakenhe. Ayenge apeke ngkwengenge intemele, kele akurne anthurre-arle alakenhe, ayenge Ngkarte-ketye-arle akurne irreme.” ");
INSERT INTO aer_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","11","Arlte arrpe-anenhele Joseph apmere Potiphar-kenhe-werne alhetyarte urrkapetyeke. Kenhe arlte arrpe-anenhele akenhe anewe Potiphar-kenhele Joseph apayuthnetyarte ikwerenge intetyeke. Re akenhe apale-iknge angkerlenge ikwerenge ayene-ilelhemele. Re ikwere akangkwe-irretyakenhe anetyarte ikwere itwele-arle anetyakenhe. Arlte anyentele re alheke apmere Potiphar-kenhe-werne urrkapetyeke. Re anyente anthurre urrkapetyame. Artwe arrpenheke-arlke arrangkwe. ");
INSERT INTO aer_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Yanhe-ngentyele, anewe Potiphar-kenhe apetyemele renhe tyartenge tyarre-ineke. Re renhe awethe apayuthneke, “Unte-ame atyenge inteme?” Joseph ikwere-ketye intwarre-irreke, tyarte ikwerenhe akenhe alterrelherlenge-arle. Joseph apmere ikwere-ketye alwirremele unteke. Kenhe arelhe re akenhe tyarte Joseph-kenhe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","15","Nhenge Joseph-ele tyarte renhe impemele apmerenge arratemele unteke, arelhe re ahele-irremele arnterre anthurre arlkeke urrkapentye akngerre akethele tnetyamenge areyeke. Itne kwene-werne apetyemele, re itneke angkeke, “Tyarte nhenhe araye! Artwe Hebrew nhenge-kenhe anewe atyinhele-arle akngetyeke nhenge. Re apeke-arle renhe nhenhe-werne akngetyeke anwernenhe apurele-anthetyenhenge. Artwe rarle apetyeke nhenhe-werne urrkapetyeke, re ayenge ileke ikwerenge intetyeke. Ayenge arlkemele the renhe alwerneke. Re atere-irremele tyarte ikwerenhe imperle-alheke. Nhenhe akwele araye!” ");
INSERT INTO aer_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Arelhe re tyarte renhe akwete atnyeneke, re akarelhetyame anewe ikwerenhe apetyalpetyeke. ");
INSERT INTO aer_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Anewe ikwerenhe apmere-werne apetyalperlenge, re ikwere ileke nthakenhe-akenhe anthurre-arle re ileke urrkapentye akngerre areye nhenge areyeke. Re anewe ikwerenheke ileke, “Artwe Hebrew urrkapentye akngerre nhenge Joseph, unte-arle akngetyeke nhenge, re apmere kwene-werne apetyeke, ayenge apurele-anthetyeke aneke. ");
INSERT INTO aer_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Re angathe-irrerlenge ayenge anpetyeke, ayenge arnterre arlkeke, imerte renhe alwernemele. Re apmere-ngentyele atere unteke, tyarte ikwerenhe iwerle-alhemele. Nhenhe akwele!” ");
INSERT INTO aer_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Nhenge pwathe Joseph-kenhe Potiphar-ele nhenhe awekenge, re ahele anthurre irreke ayeye warele ileke awemele. ");
INSERT INTO aer_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Re thultye ikwerenhe areye ileke Joseph-eke alhetyeke renhe re jail-ke akwernetyenhenge. Yanhe ikwere-arle itne tyerrtye areye akwernetyarte itne apeke Pharaoh-eke akurne-irrerlenge. Thultye areyele Joseph ineke imerte renhe jail-ke akwernemele. Re ikwerele akwete anthurre anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Kenhe YAHWEH akenhe Joseph-enge akwete-arle aneke, re jail-le anerlenge, ikwere mwerre anthurre-arlke anemele. Jail kwene ikwerele thultye akngerrepate anetyarte re thultye arrpenhe areyeke-arlke akngerrepate re anetyarte tyerrtye apeke alwirreketye akwele. Kenhe thultye re akenhe Joseph-eke ahentye-arle aneke YAHWEH-arle ikwerenge anekenge. ");
INSERT INTO aer_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Thultye akngerrepatele Joseph akngakeke ayernentye akngerre arrpenhe areye arntarnte-aretyeke. Thultye re Joseph ileke, Joseph-ele itnenhe arntarnte-areke jail kwenenge. ");
INSERT INTO aer_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Arratye apelaye, YAHWEH-arle Joseph-enge aneke-arle. Nhenge re ayernentye akngerre areye arntarnte-aretyamenge, alakenhenge anteme thultye re itirretyakenhe anetyarte. Nhenge Joseph-arle jail-le anetyartenge, ikwere akurne-irretyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","Ikwere ipenhe, Pharaoh urrkapentye akngerre ikwerenhe atherreke ahele-irreke ratherre-arle akurne mpwarekenge. Urrkapentye akngerre anyentele ikwere ngkwarle-arle akngetyetyarte. Arrpenhe re akenhe ikwere merne mpwarentye akngerre-arle. Alakenhe-arle urrkapentye ikwere-atherrenhe aneke. ");
INSERT INTO aer_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","Kele-arle Pharaoh urrkapentye akngerre ikwerenhe atherreke ahele-irrekenge, re renhe-atherrenhe jail-ke akwerneke Joseph-eke-arleke. Re thultye ileke renhe-atherrenhe kwene ikwerele atnyenetyeke ilengareke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Thultye akngerrepatele Joseph ileke, “Artwe nhenhe atherre arntarnte-araye.” Kele, Joseph-ele renhe-atherrenhe arntarnte-areke arruleke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Ingwe anyentele, itne ingkirreke ankwe-arle intekenge, artwe ratherre altyerre atherre areke, artwe nhengele Pharaoh Egypt-arenye areyeke-arle ngkwarle inetyarte, kenhe arrpenhele-arle merne-arle itetyarteke. Ratherre altyerre arrpenhe atherre areke. ");
INSERT INTO aer_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Ingweleme anteme Joseph alheke ikwere-atherre-werne. Rarle areke-arle inngerre arrpenhe anthurre-arle ratherre atnyenekenge. Re akutne aneke iwenhenge-arle ratherre inngerre alhwarrpe alakenhe anekenge. ");
INSERT INTO aer_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Kele, Joseph-ele renhe-atherrenhe apayuthneke, “Iwenhenge-ame mpwele inngerre arrpenhe anthurre lyete aneme?” ");
INSERT INTO aer_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Artwe ratherre ileke, “Ingwele ilerne kwenhe altyerre akurne areke, arne iwenhe apeke renhe areke. Ilerne akutne iwenhe ilerne-arle arekeke angwenhele-ame ilerneke iletyenhe?” Joseph-ele ikwere-atherre ileke, “Ngkartele-ante kwenhe mpweleke ileme nthakenhe-arle altyerre re ileme. Kele atyenge ilaye nthakenhe-arle mpwele altyerre areke.” ");
INSERT INTO aer_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Kele, artwele Pharaoh ngkwarle-arle akngetyetyarte re ileke, “Altyerre atyinhenge the areke arne kripethe lyaperlenge ahelhe-ngentyele. ");
INSERT INTO aer_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","Walye urrpetye lyapeke arne kripethe ikwerenge-ntyele. Arne re lyapemele arteke kele antethe mwerre-arle arraterlenge. Tharle aretyame lyaperlenge, merne annge itne mpenge anteme irreke. ");
INSERT INTO aer_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","The annge kripethe itnenhe inemele arterte-ileke ngkwarle mpwaremele tyampite-ke thelemele. The tyampite renhe Pharaoh-werne akngemele antywetyeke anteme. Alakenhe-arle the altyerre atyinhenge areke. Iwenhe-ame alakenhe ileme?” ");
INSERT INTO aer_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Joseph-ele ikwere ileke, “Tharle ngkwenge ileme iwenhe-arle unte areke. Kripethe walye urrpetye itnenhe ileme arlte urrpetye. ");
INSERT INTO aer_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Arlte ingwenthe-ngentyele, Pharaoh ngkwenge apetyeme ngenhe jail-ngentyele tyerretyeke unte ikwere urrkapetyenhenge. Urreke unte metye-metyeke irrpetyenhenge unte renhe ngkwarle anthetyarte. Alakenhe-arle unte renhe ngkwarle awethe antherle-anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Kele ngenhe ipmentye ayweperlenge, atyenge alkngwirretyale. Atyenge mwerre anaye, Pharaoh-eke ilaye nthakenhe-arle atyenge irreke re ayenge jail-ngentyele tyerrelhe-iletyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ikwere ilaye arrule anthurre, ayenge kwenhe Egypt-werne akngetyeke apmere atyinhe Hebrew areye-arle anemenge-ntyele. Ikwerenge, kele the kwenhe Pharaoh-eke apale mpwaretyakenhe, ayenge tyerrtye areyele jail-ke akwernekenge.” Alakenhe-arle Joseph-ele artwe ikwere ileke. ");
INSERT INTO aer_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Artwe arrpenhele Pharaoh-eke-arle merne itetyarte, re aweke Joseph-ele ilerlenge artwe arrpenhe nhenge akenhe altyerre re anteme itirreke Joseph-elarle mwerrantye altyerre renhe ilekenge athene. Kele re Joseph-eke angkeke, “The kwenhe altyerre areke ingwele. Altyerre atyinhenge the urtne urrpetye areke akaperte atyinheke-arleke. ");
INSERT INTO aer_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Urtne itnekenge merne akngerre anthurre aneke mpenge areye tharle iteke Pharaoh-eke akwele. Kenhe thipe areyele-arle akenhe merne itnenhe arlkwerlenge urtne akertnenye-ngentyele. Nthakenhe-arle-ame alakenhe ileme?” ");
INSERT INTO aer_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Joseph-ele ikwere ileke, “The ngkwenge ileme nthakenhe-arle altyerre re ileme. Urtne urrpetye itne ileme arlte urrpetye-arle. ");
INSERT INTO aer_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Arlte ingwenthe iperre, Pharaoh ngkwenge antangketyenhe. Re anteme artwe ikwerenhe areye ileme ngenhe akaperte ultaketyeke imerte arneke irlpare arrernemele tyerrtye ngkwinhe! Thipe areyele anteme tyelke areye arlkwetyeke apetyeme tyerrtye ngkwinhe-ngentyele!” Alakenhe-arle ikwere Joseph-ele ileke. ");
INSERT INTO aer_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","22","Ayeye nhenhe Joseph-elarle ileke-arle arratye-arle. Kele arlte urrpetye iperre Pharaoh-ele ileke urrkapentye akngerre ikwerenhe areye thultye areye-arlke merne akngerre arlkwetyeke apetyewarretyeke Pharaoh ikwerenhe ampe akweke-arle re inteke arlte-arle anekenge. Itne-arle merne arlkwetyamenge, Pharaoh-ele thultye areye ileke artwe renhe-atherrenhe inetyeke, ngkwarle-arle ikwere anthetyarte nhenge uthene merne-arle itetyarte nhenge uthene. Artwe ratherre apetyeke, re arrekwele ipenhe ileke “Yewe, unte apele apetyalpetyeke atyenge ngkwarle akngetyerle-anetyeke.” Kele, artwe re ikwere ngkwarle akngetyetyarte. Pharaoh-ele imerte artwe arrpenhe nhenge ilemele, “The ileme thultye atyinhele ngenhe atwetyeke.” Re anteme thultye ikwerenhe areye uterneke renhe akaperte ultaketyeke imerte tyerrtye ikwerenhe arneke-arleke irlpare arrernemele. Arratye Joseph-elarle ileke-arteke anthurre aneke. ");
INSERT INTO aer_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Artwe arrekwele iperre re, ngkwarle-arle akngetyarte re, rarle alkngwirreke-arle Joseph-eke jail kwenele-arle re anemeke. Artwe yanhe re akenhe Joseph itelaretyakenhe Pharaoh-eke iletyakenhele. Joseph re anteme jail-ele akwete kwenele aneke. ");
INSERT INTO aer_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Joseph jail-ele aneke awethe year atherreke-atwetye. Rarle jail-ele akwete aneke Pharaoh Egypt-arenyele altyerre areke. Alakenhe-arle re altyerre areke: re areke rarle tnerle-anetyame kwatye lhere akngerre Nile arritnyele. ");
INSERT INTO aer_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Re pweleke antere akngerre seven-pele kwatye kweneke areke. Itne akenhe mwerre anthurre aneke antere akngerre areye. Pweleke itne akwele kwatyenge arratemele atherrke akwele arlkwerlte-apetyame lhere iterele akwele. ");
INSERT INTO aer_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Re altyerre akwete arerle-anemele areke pweleke ngkwerne-ngkwerne arrpenhe seven-pele awethe kwatye kweneke. Pweleke nhenhe itne akenhe ngkwerne-ngkwerne anthurre aneke akurne anthurre itne. Itne kwatye-ngentyele arratewarremele tnerrirreke pweleke antere akngerre itneke itwele lhere iterele. ");
INSERT INTO aer_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Yanhe-ngentyele pweleke ngkwerne-ngkwerne itne pweleke antere akngerre itnenhe arlkwerrirreke. Kele Pharaoh re akenhe ankwenge-ntyele akeme-irremele aneke anteme. ");
INSERT INTO aer_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Pharaoh re awethe ankwe-irrirtneke imerte altyerre arrpenhe-arle aremele. Altyerre ikwerenge re areke arne altyeye-arteke lyaperlenge. Altyeye arrpenhenge re areke merne alangkwe-arteke seven-pele lyaperlenge, itne akngerre anthurre aneke mwerre akngerre-arle. ");
INSERT INTO aer_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Altyeye arrpenhe akenhe lyapeke arrpenhe ikwere itwele, altyeye nhenge alangkwe mwerre akngerre-apenhe anthurre areye-akerte-arle. Alangkwe seven-pele anthurre aneke altyeye anyente ikwerele. Rlke urinpe akngerrele werneke ikngerre-ngentyele, imerte arne altyeye itnenhe ampemele. ");
INSERT INTO aer_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Altyeye seven-pele antyerrke itne altyeye mwerre arrpenhe areye arlkweke. Kele Pharaoh re ankwenge-ntyele akeme-irreke anteme. Re anteme re-arrpe angkeke, “Ayekaye! The altyeye-arteke areye areke akwele, kenhe the akenhe altyerre ware-arle areke!” ");
INSERT INTO aer_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ingweleme anteme, Pharaoh akngerre anteme itirreke nthakenhe-arle altyerre re ileme. Re ayeye yerneke artwe altyerre ilenhe-ilenhe areyeke, ngangkere areyeke-arlke renhe aretyeke apetyetyenhenge. Itne apetyewarreke, re itneke ileke nthakenhe anthurre-arle re altyerre areke. Re anteme itnenhe apayuthneke, “Iwenhenge-ame the altyerre nhenhe atherre areke? Iwenhe ikwerenge?” Itne akenhe itelaretyakenhe-arle aneke nthakenhe Pharaoh-eke iletyeke. ");
INSERT INTO aer_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Yanhe-ngentyele anteme, urrkapentye akngerre anyente anteme apetyeke Pharaoh ikwere-werne, anyente nhenge ikwere-arle ngkwarle akngetyetyarte nhenge, Joseph-enge-arle jail kwenele aneke, re Pharaoh ileke, “Ayenge akurne. The ngkwenge arrekwele iletyakenhe irreke, ayenge kwenhe alkngwirreke-arle. ");
INSERT INTO aer_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Unte-ame itelareme unte atyenge uthene urrkapentye akngerre arrpenhe uthene nhenge ilerneke ahele-irreke, ngkwenge merne itentye akngerre nhenge? Unte ahele-irremele ilernenhe jail-ke akwerneke. Kwene-arle jail-ele anekenge, thultye akngerrepatele ilernenhe arntarnte-aretyarte yanheke. ");
INSERT INTO aer_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Ingwe anyentele, ilerne altyerre arerle-anerreke. Altyerre atyinhenge the merne annge areye lyaperlenge areke. Arrpenhe re akenhe merne areye-arle urtnele aneme-arle altyerre areke. Ilerne akutne aneke nthakenhe-arle altyerre itne ilekeke. ");
INSERT INTO aer_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Yanhe ikwerele ureke, artwe Hebrew anyente uthene-arle akenhe anwerne jail-ele aneke. Rarle akenhe Potiphar-eke urrkapetyarte, thultye akngerrepate. Ilerne anteme altyerre ilerne-kenhe-akerte ileke ikwere, re imerte ilerneke arratye-arratye-ilemele. ");
INSERT INTO aer_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Re ilerneke ileke akenhe kele arratye anthurre rarle aneke. Unte ayenge tyerrelhe-ileke jail-ngentyele ayenge urrkapetyenhenge, the ngkwenge akwetethe ngkwarle akngetyerle-anetyenhenge. Artwe arrpenhe nhenge ngkwenge merne itentye akngerre nhenge, unte-arle renhe atweke-arle. Alakenhe renhe-arle artwe Hebrew re ilerneke arrekwele ileke. Unte apeke renhe apayuthnemele re imerte apeke ngkwenge altyerre ngkwinhe iletyeke.” ");
INSERT INTO aer_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Iparrpe anthurrele Pharaoh-ele ileke artwe urrkapentye akngerre ikwerenhe areyeke alhetyeke Joseph jail-ngentyele tyerretyeke. Itne alhemele iparrpe renhe tyerreke. Urreke re Pharaoh aretyenhenge, Joseph althelhemele, alhewelhemele, mantere mwerreke-arlke irrpeke. Re imerte alhemele apmere Pharaoh-kenhe-werne, akngerre anthurre-arle akenhe apmere, re imerte ikwerenge arrekwele tnemele. ");
INSERT INTO aer_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Pharaoh ikwere angkeke, “Ingwele the altyerre atherre areke, arrpenheke arrangkwele atyenge iletyeke nthakenhe-arle altyerre ratherre ileme. The ngenhe apetyetyeke ileke tyerrtye areyele-arle atyenge ileke ngenhe altyerreke apayuthnetyeke, unte anteme ileme iwenhe apeke-arle altyerre re aneke nthakenhe apeke. Arratye-ame alakenhe?” ");
INSERT INTO aer_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Joseph ikwere angkirtneke, “Ayenge kwenye! Tharle ngkwenge altyerre ngkwinhe-akerte iletyeke arrangkwe-arle, kenhe Ngkartele-ante-arle ileme unte akangketyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Kele Pharaoh Joseph-eke angkeke, “Alakenhe-arle the altyerre atyinhenge areke: Altyerre atyinhenge, the areke ayenge kwatye iterele tnerle-anerlenge, lhere akngerre Nile-le. ");
INSERT INTO aer_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","The imerte aremele pweleke seven-pele anthurre kwatye kwenele tnerlte-anerlenge. Itne antere akngerre, mwerre anthurre aneke. Pweleke itne kwatyenge arratewarremele atherrke arlkwerlte-apeke. ");
INSERT INTO aer_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","The imerte aremele pweleke seven-pele awethe kwatye kwenele tnerlte-anerlenge. Itne akenhe ngkwerne-ngkwerne anthurre areye-arle aneke akurne areye. The kwenhe pweleke alakenhe arrekwelenge apmere Egypt-nge aretyakenhe. ");
INSERT INTO aer_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Kele imerte pweleke ngkwerne-ngkwerne itne kwatyenge arratewarremele pweleke antere akngerre itnenhe arlkwerrirremele. ");
INSERT INTO aer_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Ayenge itirrekeke-athene pweleke ngkwerne-ngkwerne itne-arle akwele antere akngerre irretyenheke pweleke antere akngerre itnenhe arlkwemele, kenhe arrangkwe-arle. Itne akenhe ngkwerne-ngkwerne akwete-arle aneke itne-arle kwatye kwenele arrekwele aneke-arteke. Yanhe-ngentyele ayenge akarre anteme irreke. ");
INSERT INTO aer_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Yanhe-ngentyele ayenge ankwe-irrirtneke, the imerte altyerre arrpenhe anteme-arle aremele. Altyerre ikwerenge the areke altyeye areye-arteke lyaperlenge. Arne altyeye ikwerele aneke alangkwe seven-pele anthurre, itne akenhe aneke alangkwe akngerre-apenhe mwerre anthurre areye arne altyeye mwerrele. ");
INSERT INTO aer_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Altyeye arrpenhe lyapeke alangkwe-arteke, arne ikwerenge arlenge kwenye. Re akenhe alangkwe seven-pele ante-arle atnyeneke. Rlke urinpele ikngerre-ngentyele wernemele itnenhe ampeke. Itne antyerrke irreke, akurne ingkirreke. ");
INSERT INTO aer_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Yanhe-ngentyele, alangkwe akurne itne alangkwe mwerre itnenhe seven-pele arlkwerrirreke. Ayenge imerte akarre anteme irremele. Ingweleme anteme the ngangkere areyeke ileke. Itne altyerre atyinhe atyenge iletyakenhe aneke itne-arle altyerre nhenhe atherreke apatewarrerlenge-arle.” ");
INSERT INTO aer_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Joseph-ele Pharaoh ileke, “Pweleke areye-arlke altyeye areye-arlke-arle unte altyerre ngkwinhenge areke, itne kwenhe angkentye Ngkarte-ngentyele. Re kwenhe ngkwenge iletyenhe nthakenhe-arle re apmere nhenhe iletyenhe. ");
INSERT INTO aer_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","31","Yewe, arratye apelaye! Pweleke seven pele uthene altyeye akngerre-apenhe uthene unte altyerre areke, ileme Ngkartele-arle ngenhe merne arunthe akngerre anthetyenhe year seven-peleke-atwetye. Ikwerele ureke, tyerrtye areyele merne arunthe Egypt-nge arlkwetyenhe. Kele pweleke ngkwerne-ngkwerne seven-pele arrpenhe nhenge areye altyeye antyerrke seven-pele-arlke unte altyerrenge areke-arlke rlke urinpele-arle itnenhe werneke ampemele, ileme Ngkartele ngkwenge imernerle-aneme re awethe merne lyapelhe-iletyeke arrangkwe-arle year seven-pele awetheke-atwetye. Tyerrtye ingkirreke alkngwirrewarretyenhe year mwerre arrpenhe areyeke, itne anteme angayakwe anetyenhe. Itne anteme angketyenhe, ‘Anwerne kwenhe merneke arrangkwe anetyenhe apmere akurne nhenhele! Anwerne ingkirreke angayakwe ilwetyenhe-aye!’ Yewe, akurne anthurre akwele anetyenhe merne-arlke year seven-peleke arrangkwe anemele. ");
INSERT INTO aer_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Ngkartele ngkwenge altyerre atherre imerneke nthakenhe-arle re iletyenheke. Iwenhe-arle unte altyerre ngkwinhenge areke kwenhe arratye anetyenhe. Ngkarte-arle akaltye-arle aneke merne areye-akerte. Urreke anteme Ngkartele merne anthetyenhe year seven-peleke-atwetye. Yanhe-ngentyele merne awethe lyapetyeke arrangkwe anteme anetyenhe, arrangkwe anetyenhe year seven-pele awetheke-atwetye.” ");
INSERT INTO aer_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Yanhe-ngentyele Joseph-ele Pharaoh ileke, “Ayenge awaye! Artwe anyente inaye akngerrepate-arle anetyenhe, artwe akaperte arratye, tyerrtye nhenhe areyeke-arle akngerrepate anetyenheke. Rarle itelaretyenheke nthenheke merne arunthe arrernetyeke uterne seven peleke itne lyaperlte-anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Artwe arrpenhe areye-arlke inaye itne akngerrepate areye anetyenhenge apmere arrpe-anenheke. Itnenhe ilaye tyerrtye areye-ngentyele merne inetyeke year seven peleke-atwetye lyaperlenge-arteke. Ingkirrenyeke inetyale, akweke ware. Itne apeke annge yakwethe five-pele apeke atnyenerlenge, anyente ware inaye itneke-ngentyele. Alakenhe itneke-ngentyele annge areye inaye. ");
INSERT INTO aer_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Merne ingkirreke akngerrepate areyele-arle tyerrtye areye-ngentyele ineme year seven-pele ikwerele, itnenhe ilaye apmere warle akngerre areyeke arrernetyeke. Itnenhe ilaye arntarnte-aretyeke year seven-pele ikwerele tyerrtye areye angayakwele apeke anyelknge ineketyenge, merne-arle lyapetyakenhenge. ");
INSERT INTO aer_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Ikwerele ureke merne Egypt-nge lyapetyakenhenge, akngerrepate areyele itnenhe akweke-ame-akweke ware anthetyeke itne angayakwe-irreketyenge. Alakenhenge-arle apmere akurne-irreketyenge merneke arrangkwenge.” Alakenhe-arle Joseph-ele Pharaoh ileke. ");
INSERT INTO aer_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Nhenge Joseph-ele ileke altyerre uthene merne uthene-akerte, Pharaoh Egypt-arenye tyerrtye ikwere urrkapentye akngerre areyele-arlke renhe awerrirremele, itne ingkirreke mwerre angkerreke Joseph-arle itirrentye mwerre atnyenemenge. ");
INSERT INTO aer_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Yanhe-ngentyele, Pharaoh-ele urrkapentye akngerre ikwerenhe areye ileke, “Artwe arrpenhe apeke Joseph-arteke mwerre anetyakenhe, arrangkwe-arle Ngkartele-arle renhe utnenge lterrke-arle anthekenge!” ");
INSERT INTO aer_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Pharaoh imerte Joseph-eke angkemele, “Ngkartele kwenhe ngkwenge ileke mwerre-arlke akurne-arlke-arle anetyenheke anwerneke. Alakenhenge kwenhe unte akaltye anthurre aneme tyerrtye arrpenhe areye-arteke kwenye. Utnenge Ngkarte-kenhe ngkwengenge anepaneme. ");
INSERT INTO aer_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","41","Lyete the ngenhe tyerrtye ingkirrekeke apmere Egypt-ele akngerrepate mpwareme. Ayenge-ante-arle ngkwenge akngerrepate anetyenhe. Tyerrtye atyinhe areye-arle atyenge akangkwe-irrentye akngerre-arle, itne-arle ngkwenge akangkwe-irretyenhe unte itnenhe ilerlenge.” Alakenhe-arle Pharaoh-ele Joseph ileke. ");
INSERT INTO aer_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Kele Pharaoh-ele iltye-kenhe ikwerenhe ilyweke iltye ikwerenhe-ngentyele, iltye-kenhele mpwaretyarte tyerrtye ingkirrekeke imernetyeke re apele akngerrepate aneme. Iltye-kenhe ikwerele akenhe aneke arlkenye Pharaoh-kenhe. Kele re irlweke-arle ipenhe, re Joseph iltyeke-arleke arrerneke, re anteme Joseph mantere mwerre areye antheke irrpetyeke, re imerte ite-kenhe gold antheke re arrernelhetyeke. ");
INSERT INTO aer_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","45","Pharaoh-ele Joseph ileke, “Ayenge-arle Pharaoh! Kele lyete-ngentyele tyerrtye nhenhe areye ngkwenge akangkwe-irretyeke unte itnenhe ilerlenge. Unte apmere arrpe-anenhe-werne alhetyeke nhenhe Egypt-nge unte iletyeke itne merne lyapelhe-iletyeke itneke nthakenhe apeke itne iletyeke. Urreke itne arne apeke lyapelhe-iletyenhenge, arne iwenhe apeke arrpenhe renhe areye mpwaretyenhenge, itne ngenhe apayuthnetyekeke-amparre. Itne apeke ngenhe apayuthnetyakenhe itne arneke arrangkwe mpwaretyakenhe merne lyapelhe-iletyeke arrangkwe-arle. The ngenhe arritnye arrpenhe antheme. Lyete-ngentyele ngkwinhe arritnye Zaphenath-Paneah anteme, alakenhe ileme “Ngkarte angkemele aneme.” The anteme ngenhe arelhe Asenath arritnye antheme, ngkwenge anewe anetyeke. Re kwenhe ampe Potiphera-kenhe, re arrawe-irrentye akngerrepate itnekenhe-arle aneke apmere On-ele.” Yanhe-ngentyele, Pharaoh-ele Joseph ileke nanthele tyarre-inentye akngerre ikwerenheke antyerle-alhetyeke, thultye akngerrepate-kenheke-arleke. Re ileke tyerrtye areye nanthele tyarre-inentye akngerre Joseph-kenhe arrekwelele alhetyeke ingkernele-arle apetyetyamenge. Nhenge artwe areye-arle alhetyemenge, itne tyerrtye areyeke arlkeke, “Arrantherre ingkirreke artepe arrernelhaye akngerrepate-arle apetyemenge!” Yanhe-ngentyele, tyerrtye areyele kele Joseph itelarerrirreke, rarle akngerrepate aneke. ");
INSERT INTO aer_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Nhenge Pharaoh-elarle Joseph akngerrepate mpwareke tyerrtye Egypt-arenye areyeke, Joseph akenhe artwe apmerrke year 30-pele ware-arle aneke. Yanhe-ngentyele, re apmere Pharaoh-kenhenge imperle-alheke apmere arrpe-anenhe-werne Egypt-ele aneme-werne rarle apmere ingkirreke aretyeke re akngerrepate aneke. ");
INSERT INTO aer_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Joseph apmere arrpe-anenhele unthetyarte, re unthemele akwete aneke year seven-peleke-atwetye. Ikwerele ureke, merne akngerre anthurre lyapeke apmere arrpe-anenhele tyerrtye areyele merne annge akemele anyentelhe-ilemele Joseph antheke. ");
INSERT INTO aer_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Joseph urrkapentye akngerre ikwerenhe areye-akerte alheke apmere arrpe-anenhe-werne, itne merne arrpenheme inemele tyerrtye areye-ngentyele akngirtneke apmere warle akngerreke arrernetyeke apmere itne-kenheke. ");
INSERT INTO aer_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Itne merne akweke ware inetyakenhe, itne akngerre anthurre ineke. Apmere yanhenge merne akngerre, akngerre anthurre atnyeneke. Arrpenhele uyarne intelhe-ileme merne nthakentye itne arrerneke apmere akngerre ikwere akngerre anthurre-arle anekenge. ");
INSERT INTO aer_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Ikwerele ureke, urreke-arle ahurratye-irretyenhenge, anewe Joseph-kenhe Asenath-ele ampe urreye akweke atherre atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Joseph-ele alere arrekwelenye Manasseh arritnye antheke, imerte ikwere angkemele, “Itne ayenge akngeyenge, atyenge-artweyenge rakemele, apmere nhenhe-werne ayenge akngetyeke. Tyerrtye apmere Egypt-arenye areyele ayenge urrkapetyeke uterneke. Kele mwerre. Ngkarte-arle atyenge mwerre-arle aneke, kele ayenge akangkemele, Ngkartele-arle ayenge arne akurne areyeke alkngwe-ilerlenge. Alakenhenge anteme the ngenhe Manasseh arritnye antheme.” Hebrew angkentyenge Manasseh angkeme-arteke “Alkngwe-ileme.” ");
INSERT INTO aer_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Joseph-ele atyeye akweke Ephraim arritnye antheke imerte renhe ilemele, “Ayenge apateke nhenhe Egypt-nge. Kele mwerre-arle alakenhe. Ngkartele ayenge akweke atherre antheke. Alakenhenge-arle the ngenhe Ephraim arritnye antheme.” Hebrew angkentyenge angkeme “Ephraim,” angkeme-arteke “Ngkartele ayenge alere atherre antheke.” ");
INSERT INTO aer_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","54","Year seven pele ikwere iperre merne mwerre anthurre lyapemele Egypt-nge, yanhe-ngentyele Ngkartele merne awethe lyapelhe-iletyakenhe aneke, alakenhe-arle Joseph-ele arrekwele ileke. Merne awethe lyapetyakenhe aneke Egypt-ele apmere arrpenhele-arlke, arrangkwe. Kenhe itne akenhe merne akngerre-arle awakeke arrernemele arlkwetyeke Egypt-nge Joseph-elarle urrkapentye akngerre ikwerenhe areyele-arlke annge areye anyentelhe-ilerlenge imerte warle akngerreke arrernemele ahurratyeke anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Nhenge tyerrtye areye-arle angayakwe-irrerirreke itne apetyewarretyarte Pharaoh apayuthnetyeke, “Anwernenhe merne annge anthaye anwerne athetyeke merne mpwaremele!” Re itneke angkirtnetyarte, “Alherlte-iwaye, Joseph merne anngeke apayuthnetyeke, ikwere imerte akangkwe-irremele.” ");
INSERT INTO aer_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","57","Yewe, tyerrtye atningke anthurre angayakwe aneke apmere Egypt-ele. Urreke itnenhe merne anthetyenhenge, Joseph-ele warle akngerre itnenhe altywere-ileke urrkapentye akngerre ikwerenhe areyele itne-arle merne akngerre arrerneke. Tyerrtye areye apetyewarretyarte Joseph uthene urrkapentye akngerre ikwerenhe areye uthene-werne. Itne itnenhe mane anthetyarte merne inetyeke. Tyerrtye areye-arle angayakwe anthurre aneke, Egypt-arenye areye-ante kwenye. Tyerrtye atningke apetyewarretyarte apmere arrpe-anenhe-ngentyele Egypt-werne merneke arrangkwe-arle anekenge apmere arrpe-anenhele, ahurratye akngerre-arle anekenge. ");
INSERT INTO aer_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Nhenge artwe ampwe Jacob-ele aweke itne-arle merne atnyeneke apmere Egypt-ele, re alere ikwerenhe areyeke angkeke, “Iwenhenge-ame arrantherre arnterre arerrerlte-aneme arne-arlke mpwaretyakenhele? ");
INSERT INTO aer_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Tharle aweke itne-arle akwele merne akngerre atnyeneme Egypt-ele, akeme-irraye alhetyeke Egypt-werne merne inetyeke anwerne itethe anetyenhenge. Arrantherre apeke nhenhele aneme alhetyakenhe, kele anwerne ingkirreke angayakwe ilweme-arle.” ");
INSERT INTO aer_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Arratye apele, kake ten-pele Joseph-kenhe itne kele aletheke irreke apmere akngeye itnekenhenge akenhe imperlte-alhemele Egypt-werne merne inerrirretyeke. ");
INSERT INTO aer_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Kenhe Jacob-ele ileke atyeyikwe Joseph-kenhe Benjamin alethe alhetyeke kwenye akurne apeke irreme-ketyenge. Jacob re-arrpe angkeke, “The apeke Benjamin yernemere Egypt-werne, itne renhe atweketyenge. Kele the renhe nhenhele atnyeneme-arle.” ");
INSERT INTO aer_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Tyerrtye atningke angayakwe anerrirreke Canaan-arenye areye-arlke apmere arrpe-anenhe ikwerele itne anteme ingkirreke Egypt-werne alherlte-iweke merne inetyeke. Kele, Jacob-eke alere itne akngeye itnekenhe imperlte-alheke Egypt-werne alhemele tyerrtye arrpenhe atningkenge merne inetyeke alherlte-iweke areyenge. Itne tangkeye areye akngetyeke merne itnekenhe akngernerlte-apetyenhenge. Artwe ampwe Jacob re apmere ikwerenhele anetyame. ");
INSERT INTO aer_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","9","Tyerrtye itne Egypt-eke-arteke irreke, Joseph akenhe tyerrtye yanhe-arenye areyeke akngerrepate-arle aneke. Re itneke annge areye maneke anthetyame. Nhenge kake Joseph-kenhe areye anteme apetyewarreke renhe aretyeke itne kake akweke itnekenhe alhengke-aretyakenhe aneke. Itne ikwere akaperte kwene-irreke. Joseph-ele itnenhe itelareke, kenhe re akenhe itneke ilelhetyakenhe-arle aneke angwenhe-arle re aneke. Re itelareke arrule-arle re altyerre areke-akerte kake ikwerenhe areye aremele, meye uthene akngeye uthene-arlke-arle ikwere artepe arrernelheke. Re ahele-ahele itneke angkeke, “Nthenhenge-ame arrantherre apetyeke?” Itne ikwere angkirtneke, “Anwerne-arle apmere Canaan-enge-arle apetyeke merne inetyeke.” Joseph-ele itneke ileke, “Arrangkwe, yanhe-arle arratye anetyakenhe-arle, arrantherre ularele-arle apetyeke anwernenhe aretyeke anwerne apeke-arle iltyelaye irremeke lterrke apeke-arle anwerne anemeke arrantherre apeke anwernenhe alyepe-alyepe aremele kele arrantherre anwernenhe atwetyeke apetyemele!” ");
INSERT INTO aer_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Itne Joseph-eke angkirtnerlenge, “Yanhe arratye anetyakenhe-arle! Unte-arle anwerneke akngerrepate aneme anwerne-arle anyelkngele inetyeke apetyetyakenhe-arle, anwerne-arle merneke ware-arle apetyeke anwerneke-artweye areyeke. ");
INSERT INTO aer_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Anwerne akngeye anyente-akerte. Anwerne-arle ngkwenge urrtyirretyakenhe-arle! Anwerne kwenhe nterte-ntertele arerlte-apetyeke apetyetyakenhe.” ");
INSERT INTO aer_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Joseph-ele itnenhene ntertelhe-ileke, “Arrangkwe, yanhe arratye anetyakenhe-arle! Arrantherre-arle apetyeke anwernenhe aretyeke anwerne lterrkeke apeke alyepe-alyepeke apeke!” ");
INSERT INTO aer_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Itne ikwere angkirtneke, “Anwerne kwenhe ngkwenge arratye ileme! Anwerne kwenhe Canaan-arenye areye, anwerne akngeye anyente-akerte. Atyeye anwerne-kenhe anwernekenge apetyetyakenhe. Rarle akngeye anwerne-kenhenge-arle anerle-aneme rarle ingkernenye nhakwe-arle. Anwerne atyeye akweke arrpenhe-arlke-arle atnyeneke, rarle uyerreke-arrpe-arle arrule anthurre.” ");
INSERT INTO aer_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Joseph itneke akangkwe-irretyakenhe akwete aneke, re itnenhe ileke, “Awethe angketyale! Kele the itelareme arrantherre-arle apetyeke anwernenhe ulyanye-ulyanyele aretyeke anwerne apeke-arle lterrke anemeke alyepe-alyepeke apeke! ");
INSERT INTO aer_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","16","Kele mwerre-arle. Ayenge-arle arrekantherre angketyeke ahentye-aneme the apeke arrenhantherrenhe aretyeke mwerre apeke arrantherre akurne apeke. The aretyeke ahentye-aneme arrekantherre atyeyangkweke-arle arrantherre arratye apeke angkemeke. Kele the arrenhantherrenhe jail-ke akwerneme. Kele the anyente-arle yernirtneme apmere-werne re atyeye akweke renhe nhenhe-werne akngetye-alpetyenhenge. Re apeke renhe akngetye-alpemele, kele the arrenhantherrenhe apmere-werne yernirtnemele. Kele re renhe akngetyetyakenhe apmerele anemele, kele the arrenhantherrenhe arratye ileme the arrenhantherrenhe jail-ke akwete-ante impetyenhe!” ");
INSERT INTO aer_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Arratye anteme, Joseph-ele kake ikwerenhe areye jail-ke akwerneke. Re itnenhe martelhentye atnyeneke arlte atherrameke. ");
INSERT INTO aer_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Ingweleme arrpenhele Joseph-ele itnenhe ileke, “Arrantherre apeke atyenge akangkwe-irremele, the arrenhantherrenhe atwetyeke arrangkwe-arle ayenge kwenhe Ngkartenge mwerrentye anerle-aneme. ");
INSERT INTO aer_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Arrantherre apeke-arle atyenge arratye-arle ileme, kele the anyente ware-arle jail nhenhele atnyeneme. Arrpenhe areye the yernirtneme merne-akerte arrekantherre-artweye areye anthetye-alpetyeke. ");
INSERT INTO aer_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Yanhe-ngentyele, atyeye akweke arrekantherrenhe atyenge-werne akngetyaye. Arrantherre apeke renhe atyenge-werne akngetyemele, kele the itelareme arrantherre-arle atyenge arratye ileme. The arrenhantherrenhe atwetyeke arrangkwe-arle.” Kake ten-pele itne mwerrentye yewe angkeke Joseph-eke. ");
INSERT INTO aer_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Itne itelaretyakenhe aneke akngerrepate rarle Joseph aneke Joseph-arle itneke Egypt-arenye angkentyele angkekenge. Itne angkentye itnekenhenge angkerreke, “Ngkartele kwenhe anwernenhe rlkerte-ileme anwerne-arle atyeye akweke anwerne-kenhe Joseph atwekenge. Anwerne-arle renhe iperteke akwernekenge, re uye anwerneke angkeke renhe iperte-ngentyele tyerretyeke, renhe rlkerte-iletyakenhele, anwerne kwenhe akangkwe-irretyakenhe aneke. Alakenhenge-arle artwe nhenhele anwernenhe ileme Benjamin inetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Reuben itneke angkeke, “The arrenhantherrenhe ileke Joseph impetyeke atwetyaleke! Arrantherre atyenge akangkwe-irretyakenhe-arle aneke! Arrangkwe, arrantherre renhe iperte akngerre ikwere renhe akwerneke. Alakenhenge-arle Ngkarte anwerneke ahele-irreme!” ");
INSERT INTO aer_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Kake ten-pele itne itirreke Joseph-arle akwele Hebrew angkentyeke akutne anekeke-athene, re itneke Hebrew angkentye angketyakenhenge. Rarle itneke Egypt-arenye angkentye angkekenge, artwe arrpenhele-arle ikwere iletyame. Kele re awerlenge-arle itne angkentye Hebrew angkerrerlenge. ");
INSERT INTO aer_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Rarle itnenhe aweke-iperre, re itnenhe imperle-alhemele itneke artnemele anteme. Rarle artneke-iperre itneke apetye-alpemele angkeke, “Kele, apmere arrekantherrenhe-werne alperlte-iwaye. The anyente-arle jail-le atnyeneme.” Joseph-ele Simeon akngakeke imerte urrkapentye akngerre ikwerenhe areye ileme renhe iltye atherre ayernetyeke kake ikwerenhe areyele arerlenge. ");
INSERT INTO aer_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yanhe-ngentyele, Joseph-ele itnenhe imperle-alheke. Re urrkapentye akngerre ikwerenhe areye iletye-alheke, “Yakwethe itnekenhe inaye, merne akngerre anthurre arrernaye yakwethe itne-kenheke. Mane merneke-arle antheke nhenge, yakwethe itne-kenheke arrernirtnaye. Urreke itne alhetyenhenge itnenhe merne-arlke, annge mpenge-arlke, iwenhe apeke-arlke anthaye.” Kele, urrkapentye akngerre areyele mpwareke Joseph-elarle itnenhe ileke-arteke. ");
INSERT INTO aer_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Yanhe-ngentyele, kake areyele yakwethe itnekenhe inemele tangkeye areyeke utyerneke. Itne anteme Egypt-ngentyele Canaan-werne aletheke-irrerreke. Itne akutne aneke mane-arle yakwethe kweneke-arle arrerneke-arle anekenge. ");
INSERT INTO aer_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Arlte anyentele itne alethe-irreke, imerte intemele ingwe anyenteke. Kake anyentele yakwethe altywere-ileke tangkeye akwele merne anthetyenhenge. Re yakwethe renhe altywere-ilemele, areke apatemele mane areye merne akertneke. ");
INSERT INTO aer_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Re kake ikwerenhe areyeke angkeke, “Ayakeye! Mane merneke-arle antheke rarle nhenhe! Ayakwethe atyinhe kwenenge! Tyerrtye arrpenhele apeke-arle arrernirtneke.” Kake Joseph-kenhe areye atere anthurre irrerreke, itne apatemele arlkerreke, “Ayekeye! Nthakenhe-ame Ngkartele anwernenhe iletyenhe? Anwerne ingkirreke kele ilwetyenhe!” ");
INSERT INTO aer_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Kake nine-pele itne aletheke-irrereke arlte urrpetyeke-atwetye Canaan-werne-atheke merne annge itneke-akerte. Itne akngeye itnekenhe apmereke irremele ikwere ileke nthakenhe anthurre-arle irreke itneke Egypt-nge. ");
INSERT INTO aer_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Itne ikwere ileke, “Anwerne-arle Egypt-werne alhekenge, apmere ikwere-arenye akngerrepatele apele anwerneke ahele anthurre angkeke. Re anwernenhe ilperneke anwerne-arle nterte-nterte akwele untherlte-apekeke itnenhe aremele lterrkeke apeke alyepe-alyepeke apeke akwele. ");
INSERT INTO aer_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Anwerne renhe ileke, ‘Arrangkweyaye, anwerne-arle ngkwenge urrtyirretyakenhe-arle! Anwerne-arle ntertele ingkirreke aretyeke apetyetyakenhe-arle.’ ");
INSERT INTO aer_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Anwerne akngerrepate yanheke angkerrirreke, ‘Anwerne kwenhe akngeye anyente-akerte. Ikwerenhe kwenhe alere eleven-pele anthurre aneme. Ten-pele ware anwerne nhenhe-werne apetyeke, anyente akenhe apmerele-arle ikwerenge. Atyeye arrpenhe anwerne-kenhe arrule-arle ilweke.’ Alakenhe-arle anwerne ikwere ileke. ");
INSERT INTO aer_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Akngerrepatele anwernenhe ileke, ‘Arrantherre apeke atyenge mpwaremele the arrenhantherrenhe ilerlenge kele the itelareme arrantherre-arle atyenge arratye-arle ileme. Kele arrekantherre-artweye-werne alperlte-iwaye merne akngerre nthakentye-arle arrantherre-arle ahentye aneme-akerte. Anyente-arle imerte imperlte-alhemele nhenhe jail-ke. ");
INSERT INTO aer_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Yanhe-ngentyele, atyeye akweke arrekantherrenhe imerte akngetyemele Egypt-werne, atyenge imernetyeke. Kele the itelaretyenhenge arrantherre apeke atyenge arratye ilerneke. Kele the itelaretyenhenge arrantherre-arle Egypt-werne apetyetyakenhe ingkirreke ulyanye-ulyanyele aretyeke. Arrantherre apeke atyeye akweke arrekantherrenhe akngetyemele, kele the arrenhantherrenhe jail-ngentyele nhenge anthirtnemele yernirtnemele. Kele arrantherre Egypt-ele unthemele arne iwenhe apeke renhe inetyenhenge. Arrenhantherrenhe-arle ayaketyeke-arlke atwetyeke-arlke arrangkwe-arle.’ Alakenhe-arle akngerrepatele anwernenhe ileke.” ");
INSERT INTO aer_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Yanhe-ngentyele, itne ayakwethe merne annge-akerte ineke, imerte ahelheke altyiwemele. Ahelheke itne altyiwemele, anyenteke-anyente itne mane nhenge areke. Itne atere anthurre irreke mane rarle anekenge merneke-arle antheke. Akngeye itnekenhele areke mane renhe re-arlke atere-irreke anteye. ");
INSERT INTO aer_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Re itnenhe ileke, “Ayekaye! Arrantherre-arle akwetethe ampe atyinhe areye atyenge-ngentyele rakeme! Arrekwele the alere atyinhe Joseph-urrke aparlpe-ileke, kele Simeon anteme jail kwenele aneme. Kele arrantherre ayenge apayuthneme Benjamin anteme yernetyeke Egypt-werne. Atyenge-ante akurne anteme irreme!” ");
INSERT INTO aer_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Yanhe-ngentyele, Reuben akngeye ikwerenheke angkeke, “Benjamin ayenge anthaye the renhe imernetyeke Egypt-arenye akngerrepateke. The renhe mwantyele arntarnte-aretyenhenge. The renhe mwantyele mwerre akwete akngetye-alpetyenhenge. The apeke renhe akngetye-alpetyakenhenge, renhe Egypt-eke imperle-alhemele, kele unte ampe atyinhe atherre-arle atwetyeke!” ");
INSERT INTO aer_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Kele Jacob-ele renhe ilerlenge, “Arrangkwe! Tharle Benjamin arrekantherrenge yernetyeke kwenye-arle! The kele-arle kake ikwerenhe aparlpe-ilekenge. Benjamin-arle urreye akweke ingkernenye anyente-arle anewe atyinhe Rachel-kenhe. The apeke renhe ngkwengenge yerneme Egypt-werne, akurne apeke ikwere irreketyenge. Re apeke ilwerlenge, ayenge irrare anthurre irretyenhe ilwemele, ayenge-arle ampwe anthurre anemenge.” ");
INSERT INTO aer_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Arrule anthurreke-atwetye merne lyapetyakenhe aneke apmere Canaan-elarle ahurratye akngerre anekenge tyerrtye areye akenhe angayakwe anthurre anteme-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Jacob uthene ikwere-artweye areyele itne merne-arlke kere-arlke Egypt-nge-arle akngetyeke ingkirreke anthurrele arlkwerrirreke. Itne-arle awethe anteme angayakwe anekenge Jacob alere ikwerenhe areyeke angkeke, “Egypt-werne alperlte-iwaye, merne awethe inetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","5","Alere Jacob-kenhe Judah ikwere angkeke, “Egypt-arenye akngerrepate nhenge kwenhe ahele anthurre angkeke, re anwerneke alakenhe angkeke, ‘Atyeye akweke arrekantherrenhe akngetye-alpaye, renhe nhenhe-werne akngetyaye. Arrantherre renhe akngetye-alpetyakenhenge, urrkapentye akngerre atyinhe areyele ayenge arrantherre awethe aretyeke kwenye anteme ileme-ketyenge.’ Alakenhe-arle Egypt-arenye akngerrepatele anwernenhe ileke. Unte apeke Benjamin ileme anwernenge alhetyeke Egypt-werne, kele anwerne alhemele-arle merne inetyeke. Kele unte apeke Benjamin anwernenge yernetyakenhenge, anwerne Egypt-werne alhetyeke arrangkwe-arle.” ");
INSERT INTO aer_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Re angkeke Judah-eke, “Ayekaye! Iwenhenge-ame arrantherre akurne-arteke nhenhe mpwaremele Egypt-arenye akngerrepate nhengeke ileke atyeye akweke-arle arrekantherrenhe atnyeneke? Arrantherre kwenhe ayenge apurrkele-antheme!” ");
INSERT INTO aer_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Alere Jacob-kenhe areye angkirtneke ikwere, “Akngerrepate Egypt-arenye re kwenhe anwernenhe aremele akwete angkeke arne arunthe-akerte apayuthnemele. Re anwerneke angkeke, ‘Akngeye arrekantherrenhe-ame itethe akwete? Atyeye akweke-ame arrekantherrenhe aneme?’ Anwerne ikwere ileke ngkwenge-akerte atyeye akweke anwerne-kenhe-arlke-akerte, anwerne itelaretyakenhe anwernenhe-arle iletyenheke Benjamin Egypt-werne akngetyetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Kele Judah angkeke akngeye ikwerenheke, “Benjamin atyengenge yernaye, kake areye alherlte-iwetyenhenge Egypt-werne lyete angwerrele. Unte apeke anwernenhe lyete Egypt-werne yernemele, anwerne angayele ilwetyeke arrangkwe-arle. Unte-arlke ampe anwerne-kenhe areye-arle merne akngerre-akerte-arle anemele. ");
INSERT INTO aer_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Unte apeke Benjamin yernemele atyengenge Egypt-werne, the ngenhe ileme the renhe mwantyele-arle arntarnte-aretyenhe. Tharle ngenhe ipmentyele aretyeke arrangkwe-arle re apeke rlkerte inerlenge. Ayenge apeke ikwere arrangkwe apetyalperlenge, unte apeke atyenge ahele-irretyeke apeke ayenge ilpernemele ilwetyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Iparrpaye irrkwanthe-irretyale! Unte apeke-arle anwernenge Benjamin arrekwele Egypt-werne yernekenge, kele anwerne apeke-arle Egypt-werne alhemele atningke-ngare apetyalpemele atningke-ngare merne-arlke atningke-akerte.” ");
INSERT INTO aer_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Jacob anteme itneke angkeke, “Yewe, the arrenhantherrenhe ayaketyeke anteme awethe. Kele Benjamin apeke arrekantherrenge alhemele Pharaoh Egypt-arenye ikwere arne mwerre impene akngerlte-iwaye imerte renhe anthemele. Arne mwerre areye akngaye apmere nhenhenge-ntyele re arlkwetyeke: Ngkwarle untyeyampe-arteke, annge areye anwerne-arle pistachio akeme, almond areye-arlke arne kereke arrernentye akngerre nhenge ulkere-arlke. Antere tyerrtyeke arrernentye akngerre nhenge ulkere-arlke arne ikwemeye arrpenhe areye mwerre ntyentye-arlke. ");
INSERT INTO aer_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Nhenge arrantherre-arle Egypt-werne arrekwele alheke merne inetyeke, arrantherre artwe renhe ayakwethe mane-akerte anyente antheke. Arrantherre nhenhe-werne apetyalpeke, arrantherre akngetye-alpemele ayakwethe merne-akerte mane-akerte-arlke atnyeneke akwete-arle. Tyerrtye arrpenhele apeke-arle apalele arrerneke. Arrantherre apeke merne akngerre awethe inetyeke alpemele, mane ayakwethe atherrenge akngaye merne inetyeke. ");
INSERT INTO aer_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Arrantherre Benjamin akngaye arrekantherrenge. Egypt-werne iparrpe alperlte-iwaye merne inetyeke akngerrepate ikwerenge. ");
INSERT INTO aer_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Ngkarte-arle LTERRKE ANTHURRE! The Renhe apayuthneme arrekantherre-akertele Pharaoh Egypt-arenye ikwere re mwerre anetyeke arrekantherre. The Ngkarte apayuthneme Benjamin uthene Simeon uthene-arlke arrenhantherrenhe ingkirreke atyenge-werne akngetye-alpetyeke. The apeke renhe-atherrenhe aretyakenhenge, kele mwerre-arle. Kele the Ngkarte arratye akwete itelaretyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Yanhe-ngentyele itne Canaan-engentyele alperlte-iweke Egypt-werne. Itne arne mwerre impene areye-arlke, itnekenhe-arrpe yakwethe mane-akerte atherrame, Benjamin-arlke akngeke. Iparrpe ware itne Egypt-eke irreke. Itne arrernelhemele arteke Joseph-enge arrekwele tneke, apmere ikwerenge. ");
INSERT INTO aer_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Nhenge Joseph-ele itnenhene aremele re alhengke-areke atyeye akweke ikwerenhe Benjamin. Joseph angkeke urrkapentye akngerre ikwerenheke, apmere arntarnte-arentye akngerreke, “Artwe yanhe areye apmere atyinhe-werne akngetyaye. Kere pweleke atwetyeke alhaye imerte itemele. The artwe nhenhe areyenge kere arlkwetyeke ahentye-aneme lyete.” ");
INSERT INTO aer_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Kele, urrkapentye akngerre re alheke kere pweleke renhe atwemele imerte itemele. Re anteme alheke kake Joseph-kenhe areye inetyeke apmere Joseph-kenhe-werne ikwerenge kere arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Kenhe atyeyenhenge areye apmere Joseph-kenhe-werne alhemele, itne ikwere-ketye atere-irrereke. Itne angkerreke, “Ayekeye! Iwenhenge-ame re anwernenhe apmere ikwerenhe-werne akngetyeke? Mane nhenge-arle yakwetheke apalele apeke arrernekenge nhenge anwerne apmere-werne alperlenge. Kele re apeke anwernenhe atwetyeke, re apeke-arle anwernenhe uternetyenhe ikwere urrkapetyeke ayernentye akngerre areye-arteke. Re apeke-arle tangkeye anwerne-kenhe areye apeke raketyenhe.” Alakenhe-arle itne itirrewarreke. ");
INSERT INTO aer_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Yanhe-ngentyele, itne alheke artwe urrkapentye akngerre ikwere itwe-werne arriwele-arle tnetyame ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Itne ikwere angkeke, “Akngerrepataye, anwerne kwenhe arrekwele-arle nhenhe Egypt-werne apetyeke merne inetyeke. ");
INSERT INTO aer_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Anwerne apmere-werne alpemele merne-akerte, anwerne mpwepele inteke. Kele anwerne yakwethe altywere-ilemele areke, anyenteke-anyente anwerne mane areye areke itnenhene akngetye-alpeke ngenhe anthetyeke. ");
INSERT INTO aer_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Anwerne yakwethe arrpenhe mane-akerte akngetyeke anwerne-arle merne awethe inetyenhenge. Kele anwerne itelaretyakenhe-arle angwenhele apeke-arle mane renhe arrernirtnekeke arrekwele-arle anwerne apetyekenge.” ");
INSERT INTO aer_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Urrkapentye akngerre re angkirtneke, “Kele mwerre. Atere-irretyalaye. Ngkarte nhenge arrantherre akangkwe-irrentye akngerrele, Re apeke-arle arrernirtneke yakwethe itneke-arleke arrekwele. Kele-arle the mane nhenge atnyeneme arrantherre ayenge arrekwele anthekenge.” Yanhe-ngentyele, urrkapentye akngerre re anteme Simeon kake itnekenhe tyerretyeke alheke jail-ngentyele imerte itneke-werne akngetye-alpemele. ");
INSERT INTO aer_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Kele nhenge urrkapentye akngerre re itnenhe apmere Joseph-kenhe-werne akngetyeke, re itnenhe kwatye antheke ingke alhewelhetyeke, re imerte tangkeye itnekenhe-arlke merne atherrke anthemele. ");
INSERT INTO aer_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Nhenge tangkeye itnekenhele-arle merne atherrke arlkwetyamenge, itne arne mwerre impene areye ineke itne-arle akngetyemele Joseph anthetyeke. Urrkapentye akngerre re anteme itnenhe ileke itne Joseph-enge merne arlkwetyeke arlte mpwepele. ");
INSERT INTO aer_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Nhenge Joseph apmere-werne apetye-alperlenge, itne renhe arne itnenhe antheke akaperte kwene-irreremele. ");
INSERT INTO aer_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Joseph-ele itnenhe apayuthneke, “Arrantherre-ame mwerre awelheme, artwe ampwe akngeye arrekantherrenhe re-ame mwerre akwete, nhenge arrantherre-arle nhenge atyenge arrekwele ilekenge ipenhe? Re-ame mwerre? Re-ame itethe akwete?” ");
INSERT INTO aer_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Itne ikwere angkirtneke, “Yewe, akngeye anwerne-kenhe-arle mwerre anthurre itethe akwete-arle. Rarle urrkapentye akngerre ngkwinhe-arle.” Itne ingkirreke akaperte kwene-irrereke Joseph ikwere. ");
INSERT INTO aer_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","30","Kele Joseph akeme-irremele areke atyeye akweke ikwerenhe Benjamin. Ratherre akenhe meye anyente-akerte-arle aneke. Nhenge Joseph-ele renhe aremele re ingkwe anthurre artneke. Re kake ikwerenhe areye apayuthneke, “Nhenhe-ame atyeye akweke re arrantherre-arle atyenge ileke-akerte re?” Joseph Benjamin-eke angkeke, “Apmerrke-aye, ayenge Ngkarteke angkeme re ngkwenge mwerre anetyenhenge.” Joseph-ele itnenhe iparrpe anthurre imperle-alheke itne renhe artnerlenge areketyenge. Re alpeke apmere arrpenhe ikwerenhe-werne imerte tnyante artnemele atyeye akweke ikwerenheke rarle ikwere arnterre ahentye-anekenge. ");
INSERT INTO aer_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Kele Joseph kwatyele inngerre alhewelheke nhenhe kake ikwerenhe areyele areketyenge rarle artnetyamenge. Re apetyalpeke kake ikwerenhe areye-werne imerte urrkapentye akngerre ikwerenheke angkemele, “Kere akngetyaye tyerrtye nhenhe areyele arlkwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","33","Urrkapentye akngerre Joseph-kenhele kere akngetye-alpeke apmere-werne. Joseph re anyente-arrpe anetyame table-le, re anteme ileke kake ikwerenhe areye ikwerenge arrekwele-arle anetyeke table arrpenhele. Re itnenhene arrerneke ikwerenge arrekweleke. Re kake akngerre ikwerenhe arrerneke ikwere akwangenyeke arrekweleke, re imerte kake akweke ikwerenhe anteme arrernemele ikwere akwe-arratyeke anetyeke. Re Benjamin arrerneke ingkerneke akwe-arratyeke. Itne apayuthnerreke, “Nthakenhe-arle-ame re itelareme angwenhe-arle kake akngerre aneme?” Itne Joseph alhengke-aretyakenhe akwete aneke. Tyerrtye atningke arrpenhe areye table arrpenhele anerrirretyame Egypt-arenye areye. Egypt-arenye areye akenhe Hebrew areyeke ilkelhetyakenhe-arle aneke, itnekenge arlkwetyakenhe-arlke. Itne itneke ahentye-anetyakenhe aneke Hebrew areyele-arle merne arlkwetyarte Egypt-arenye areyele arlkwetyakenhe-arle. Alakenhenge-arle itne kake Joseph-kenhe areyenge merne arlkwemele anetyakenhe. ");
INSERT INTO aer_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Urrkapentye akngerre areyele table Joseph-kenhe-ngentyele merne inemele, itne artwe Hebrew itnenhene wanteke. Itne artwe itnenhene anyenteke-anyente merne antheke. Kele Benjamin kake akweke-arle itne merne antheke akenhe artwe atningkele arlkwetyeke. Itne itnenhene ngkwarle-arlke antheke. Yanhe-ngentyele, kake Joseph-kenhe areyele merne ingkirre arlkwemele ngkwarle ingkirre antyweke, itne arnterre akangketyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Joseph-ele ileke apmereke urrkapentye akngerre ikwerenhe, “Yakwethe areye inaye itne-arle akngetyeke areye. Itneke merne akngerre anthurre arrernaye. Mane ngenhe-arle merne inetyeke antheke-arlke, yakwetheke arrernirtnaye merne annge areye-akerteke-arleke. ");
INSERT INTO aer_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Nhenhe-arle tyampite impene atyinhe, arrantherre itelareme tyampite silver nhenge. Renhe yakwethe atyeye akweke-kenheke arrernaye. Mane-arlke arrernirtnaye.” Kele, urrkapentye akngerrele tyampite impene uthene mane uthene yakwethe atyeye akweke-kenheke arrerneke. ");
INSERT INTO aer_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Kele arlte arrpenhele anteme, uterne arratekenge anteme, kake Joseph-kenhe areyele antyame-arlke anteme tangkeye-ke utyerneke. Urrkapentye akngerre apetyemele itnenhe ileke apmere-werne alpetyeke. ");
INSERT INTO aer_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Itne alpemele anteme alheke apmere ikwerenge-ntyele. Kele itne arlenge-irretyakenhenge akwete Joseph urrkapentye akngerre ikwerenheke angkeke, “Artwe nhakwe areyeke interteke irraye, alakenhe itnenhe apayuthnaye, ‘Akngerrepate atyinhe-arle arrekantherre mwerre-arle aneke. Nthakenhe-ame arrantherre ikwere irreke? ");
INSERT INTO aer_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Tyampite silver ikwerenhe apeke-arle arrantherre anyelkngele ineke re antywenhe-antywenhe. Tyampite yanhe kwenhe impene anthurre. Alakenhe-arle re altyerre ilenhe-ilenhe tyampite yanhe-ngentyele ware altyerre ilenhe-ilenhe tyerrtye areyeke. Arrantherre kwenhe akurne anthurre aneme!’ Unte itneke alakenhe iletyeke!” ");
INSERT INTO aer_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Urrkapentye akngerre re itnenhene apentemele iwerrele itnenhene ayakeke. Re itneke angkeke Joseph-ele ileke-arteke akwete, “Akngerrepate atyinhe kwenhe arrekantherre mwerre anthurre aneke, nthakenhe-ame arrantherre ikwere irreke? Tyampite silver nhenge ikwerenhe kwenhe arrantherre anyelkngele ineke. Tyampite yanhe kwenhe impene anthurre. Tyampite yanhe-ngentyele ware kwenhe re tyerrtye areyeke altyerre ilenhe-ilenhe. Arrantherre ingkerre akurne anthurre aneme!” ");
INSERT INTO aer_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Itne angkirtnewarreke ikwere, “Yanhe-arle arratye anetyakenhe-arle! Iwenhenge-arle-ame unte anwernenhe alakenhe ilperneme? Anwerne kwenhe urrkapentye akngerre areye ware tyampite renhe-arle anwerne anyelkngele inetyakenhe-arle! ");
INSERT INTO aer_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Anwerne-arle mane yakwethele-arle aremele itnenhe akngetye-alpeke, anwerne Canaan-eke irremele arteke-arle areke. Anwerne-arle ngenhe anthirtneke-arle. Iwenhenge-arle-ame unte itirreme anwerne-arle gold apeke silver apeke akngerrepate ngkwinhe-kenhe anyelkngele inetyenhe? ");
INSERT INTO aer_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Araye yakwethe kwenele anwerne-kenhe areye. Unte apeke arratye inemele, angwenhele apeke-arle atnyenemenge, unte renhe irrerlknge atwetyeke. Anwernenhe imerte unte ilemele anwerne ngkwenge ayernentye akngerre areye-arteke urrkapetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Urrkapentye akngerre re itnenhe ileke, “Kele mwerre, arrantherre-arle angkemenge-arteke the mpwareme, the apeke tyampite renhe arratye aremele yakwethe angwenhe-kenheke, the renhe atwetyeke arrangkwe-arle. Kele the renhe akngirtneme-arle re urrkaperle-anetyeke. Ayenge-arle arrekantherre ahele-irretyakenhenge-arle kele apmere-werne alperlte-iwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Kele, itne iparrpe-iparrpele tangkeye areyenge arne areye atnarnpelhe-ileke, imerte ahelheke anteme arrernemele. Itne imerte yakwethe itnekenhe altywere-ilemele urrkapentye akngerrele kwene aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Urrkapentye akngerre re kake akngerrepatenge-urrke ilkaremele areke. Re tyampite renhe aretyakenhe aneke. Re arne ingkirreke itnekenhe-arlke ilkaremele untheke, arrangkwe akwete. Yanhenge anteme re alheke akweke ingkernenye-werne yakwethe Benjamin-kenhe-arlke aretyeke. Yakwethe Benjamin-kenheke arratye re tyampite silver renhe areke. ");
INSERT INTO aer_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Itne tyampite renhe aremele, mantere itnekenhe alterreke atnerte itnekenhe-arle akngarte-anthurre-iwekenge. Itne imerte alhwarrpe-alhwarrpele ware anteme yakwethe itnekenhe ayerneke. Itne-arle imerte itnekenhe areye tangkeye areyeke utyernirtneke, apmere Joseph-kenhe-werne alperlte-iwemele. ");
INSERT INTO aer_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Joseph apmerele akwete aneke Judah areye-arle apetyalpekenge. Judah uthene kake ikwerenhe areye apmere Joseph-kenhe kwene-werne irrpenhemele, itne kwene-irreke ikwere, inngerre ahelhe-werne-atheke. ");
INSERT INTO aer_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Joseph-ele itnenhe apayuthneke, “Iwenhenge-ame arrantherre tyampite atyinhe anyelkngele ineke? Arrantherre-ame itelaretyakenhe ayenge-arle ngangkere aneme? Arrantherre atyengenge arne iwenhe apeke renhe alengke-iwetyeke arrangkwe-arle. Ngangkere atyinhe-akertele-arle the altyerrenge aremele-arle. Kele the aketheke-arle areme angwenhele apeke atyenge-ketye alengke apeke iwerlenge.” ");
INSERT INTO aer_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Judah imerte ikwere angkemele, “Akngerrepate, anwerne kwenhe ngkwenge uyarne angketyeke-irreme. Kele anwerne-arle iwenhe apeke mpwaretyeke arrangkwe-arle Ngkartele kwenhe anwernenhe alethe impeme. Ngkartele ngkwenge ileke anwerne-arle akurne areye aneme. Arratye kwenhe. Kele anwerne ngkwenge urrkapentye akngerre areye anetyeke ayernentye akngerre areye-arteke, Benjamin-ante kwenye.” ");
INSERT INTO aer_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Kele Joseph akenhe itneke angkerlenge, “Arrangkwe, the arrenhantherrenhe ayernentye akngerre-arteke iletyeke kwenye-arle. The Benjamin anyente ware-arle ileme atyenge urrkapetyeke rarle tyampite atyinhe anyelkngele inekenge. The arrenhantherrenhe ileme alpetyeke akngeye arrekantherrenhe-werne ikwere mwerre anerrirremele anteme.” ");
INSERT INTO aer_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Judah alheke Joseph angathe-werne ilemele imerte ikwere angkemele, “Urrekaye! Ayenge ngkwenge arratyentye angketyeke ahentye-aneme. Atyenge ahele-irretyale anaye. Tharle ngenhe itelareme lterrke Pharaoh Egypt-arenye-arteke, kenhe ayenge akenhe arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Nhenge anwerne arrekwele nhenhe-werne apetyeke ngenhe aretyeke, unte anwernenhe apayuthneke, ‘Akngeye arrekantherrenhe-ame itethe akwete? Arrekantherrenhe atyeye akweke aneme?’ Alakenhe-arle unte anwernenhe apayuthneke. ");
INSERT INTO aer_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Anwerne ngkwenge ileke akngeye anwerne-kenhe-arle itethe akwete aneme, atyeye akweke-arlke-arle apmerele aneme ikwerenge. Atyeye akweke anwerne-kenhe-arle inteke akngeye anwerne-kenhe ampwenge anteme. Atyeye akweke anwerne-kenhe meye, anwerne renhe aparlpe-ileke akweke atnyenerlenge. Alere arrpenhe ikwerenhe, anwerne aparlpe-ileke. Akngeye anwerne-kenhele atyeye akweke anwerne-kenhe-nge ahentye anthurre-arle. Alakenhe-arle ngkwenge arrekwele anwerne ileke. ");
INSERT INTO aer_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Unte anteme anwernenhe ileke, ‘Atyeye akweke arrekantherrenhe Benjamin akngetyaye the renhe aretyenhenge.’ ");
INSERT INTO aer_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Anwerne ngenhe ileke, ‘Arrangkwe, anwerne renhe nhenhe-werne akngetyetyeke arrangkwe-arle unte aretyeke. Anwerne apeke renhe akngeye ikwerenhe-ngentyele akngetyemele, artwe ampwe re ilweme-arle.’ ");
INSERT INTO aer_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Kele unte anwerneke angkerlenge, ‘Iparrpe atyeye akweke arrekantherrenhe nhenhe-werne akngetyaye! Arrantherre ikwere arrangkwe apetyalpemele tharle arrenhantherrenhe Egypt-werne apetyetyeke kwenye ayakeme-arle merne-ketyenge-arlke.’ Alakenhe-arle unte anwernenhe ileke. ");
INSERT INTO aer_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Kele, anwerne alperlte-iwemele ileke akngeye anwerne-kenheke, ngkwinhe urrkapentye akngerre, unte-arle Benjamin aretyeke ahentye-aneke. Alakenhenge anteme renhe irrarele-antheke rarle Benjamin-eke itirreke akurne-irreme-ketye. ");
INSERT INTO aer_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Ikwerenge-ntyele, anwerne-arle merne ingkirreke arlkwekenge, anwerne awethe angayakwe-irreke. Akngeye anwerne-kenhele anwernenhe ileke, ‘Egypt-werne alperlte-iwaye merne awethe inetyeke anwerneke.’ ");
INSERT INTO aer_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","“Anwerne renhe ileke, ‘Arrangkwe, anwerne Egypt-werne alpetyeke arrangkwe-arle atyeye akweke anwerne-kenhe kwenye. Anwerne apeke renhe nhenheke imperlte-alhemele ngkwengenge, akngerrepate Egypt-arenyele anwerne renhe aretyeke arrangkwe-arle ileme.’ Alakenhe-arle anwerne akngeye anwerne-kenheke ileke. ");
INSERT INTO aer_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Re anwerneke angkeke, ‘Arrantherre itelareme Rachel anewe atyinhe, rarle ampe urreye atherre-arle atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Anyente arrpenhele ayenge imperle-alheke aparlpe-irretyeke. Akngwelye areyele apeke-arle alterremele uthneke. Tharle renhe inngerre awethe-arlke aretyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Lyete anteme arrantherre ayenge apayuthneme ampe Rachel-kenhe anyente awerne renhe yernetyeke ayenge-arle ikwere arnterre-arle ahentye-aneme. The apeke renhe yernemele arrekantherrenge, re apeke ilweketyenge-arle. The renhe-arlke aparlpe-ilemele, ayenge akwetethe-arle artnerle-aneme ayenge ilwetyeke-atwetye.’ Alakenhe-arle artwe ampwe akngeye anwerne-kenhe anwerneke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Nthakenhe-ame unte itirreme? Anwerne apeke Benjamin nhenheke impemele, apmere-werne alpemele ikwere kwenye, nthakenhe-ame akngeye anwerne-kenhe irretyenhe? Re kwenhe Benjamin-eke arnterre itirrentye akngerre. Alakenhenge anteme ayenge ikwere kwenye alpetyakenhe. ");
INSERT INTO aer_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","Anwerne apeke alpemele apmere-werne atyeye-kwenye anwerne-kenheke, akngeye anwerne-kenhe-arle arratye irrare-irremele ilweme. ");
INSERT INTO aer_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","“The akngeye anwerne-kenheke ileke tharle Benjamin mwantyele arntarnte-aretyenhe. Alakenhe-arle ayenge ikwere angkeke, ‘The apeke Benjamin akngetye-alpetyakenhenge, kele unte ayenge-arle ilpernetyeke akwete ayenge ilwetyeke-atwetye.’ Alakenhe-arle ayenge ikwere angkeke. ");
INSERT INTO aer_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Alakenhenge-arle ayenge ahentye-aneme unte Benjamin impetyeke ayenge-arle imerte ngkwenge urrkapemele ayernentye akngerre-arteke. Benjamin yernirtnaye alpetyeke kake ikwerenhe areyenge akngeye ikwerenhe-werne. ");
INSERT INTO aer_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Ayenge-arle Benjamin kwenye apmere-werne alpetyeke arrangkwe-arle. Ayenge apeke-arle ikwere kwenye alpetyeke aneke, kele the akngeye atyinhe irrare anthurre-arle mpwareme. Tharle alakenhe mpwaretyeke ahentye-anetyakenhe-arle.” Alakenhe-arle Judah angkeke Joseph-eke. ");
INSERT INTO aer_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Nhenge Joseph-ele aweke Judah angkerlenge, re uyarne itirreke, re ingkwe anthurre artneke. Re ahentye-anetyakenhe aneke urrkapentye akngerre ikwerenhe areyele renhe artnelhe-ilerlenge aretyeke re anteme itneke Egypt-arenye angkentyele angkeke, “Apmerenge arratewarraye, ayenge impemele artwe Hebrew nhenhe areyenge anyente.” Kele urrkapentye akngerre itne Joseph renhe imperlte-alheke, re anyente kake ikwerenhe areyenge aneke. ");
INSERT INTO aer_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Re anteme tnyante anthurre artneke Egypt-arenye areyele akethele-arle tneke renhe awerrirreke artnerlenge itne imerte tyerrtye arrpenhe areyeke iletyeke alhemele apmere Pharaoh-kenhele aneke areyeke. ");
INSERT INTO aer_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Joseph-ele anteme kake ikwerenhe areye Hebrew angkentyele ileke, “Ayenge kwenhe Joseph! Akngeye atyinhe-ame itethe akwete?” Kake ikwerenhe areye ikwere angketyakenhe aneke itne kwenhe apatewarremele ikwere-ketye atere-irreke. ");
INSERT INTO aer_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Kenhe Joseph akenhe itneke angkerlenge, “Atyenge-werne angathe-irraye. Arratye, ayenge-arle atyeye ngkwinhe Joseph-arle. Arrule anthurre kwenhe arrantherre ayenge tyerrtye arrpenhe areye maneke antheke. Itne ayenge uterneke urrkapetyeke ayernentye akngerre arrpenhe areye-arteke. ");
INSERT INTO aer_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Kele mwerre. Itirrewarretyalaye! Tharle arrenhantherrenhe atwetyeke arrangkwe-arle. Arrekantherre-arrpe ahele-irretyale ayenge-arle nhenhe-werne yernekenge. Alakenhe rarle aneke Ngkartele-arle ayenge nhenhe-werne yernetyeke aneke arrekantherre arrekwele-irretyeke tyerrtye areye arntarnte-aretyeke angayakwe aneme-ketye. ");
INSERT INTO aer_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Tyerrtye areye kwenhe angayakwe aneke uterne atherreke ware ahurratye akngerre-arle anekenge apmere Egypt-nge apmere arrekantherrenhenge-arlke. Kele the arrenhantherrenhe ileme merne kwenye year five-pele awethenge lyapetyeke arrangkwe-arle. Yanhe ikwerele ureke, tyerrtyele merne annge ngkernetyeke ahelheke arrangkwe-arle, tyerrtyele merne inetyeke arrangkwe-arle anetyenhe, arrangkwe anthurre. ");
INSERT INTO aer_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Alakenhe ikwerenge-arle Ngkartele ayenge yerneke arrekantherrenge arrekwele. Ayenge apeke-arle yanhele anekenge nhenhe-werne apetyetyakenhe, arrantherre ampe-arlke arrekantherrenhe kele angayakwe-arle anemele ilweme-arle. Kenhe tyerrtye ingkirrekele apatewarretyenhe nthakenhe-arle akwele Ngkartele-arle arrenhantherrenhe itetheke mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","The arrekantherre iletyeke ahentye-aneme nthakenhe-arle Ngkartele atyenge mpwareke. Arrantherre-arle ayenge nhenhe-werne apetyetyeke uternetyakenhe-arle, arrangkwe. Ngkartele kwenhe re-arrpe ayenge Egypt-arenye areyeke akngerrepate arrerneke. Ayenge-arle urrkapentye akngerre mwerre Pharaoh-kenhe. Tharle arne ingkirrenyeke ikwerenhe areye arntarnte-areme apmere ikwerenhenge. Ayenge-arle akngerrepate aneme apmere arrpe-anenhe nhenhe Egypt-nge. ");
INSERT INTO aer_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","“Kele kake atyinhe areye, iparrpe alherlte-iwaye apmere nhenhenge-ntyele, imerte akngeye atyinhe akenhe apmere-werne alpemele ikwere ilaye, ‘Alakenhe-arle alere ngkwinhe Joseph angkeke anwerneke: Re ilelheke Ngkartele-arle renhe akngakeke tyerrtye Egypt-arenye areyeke akngerrepate anetyeke. Re angkeke unte akwele Egypt-werne alhetyeke iparrpe anthurre akwele renhe aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Unte apeke Egypt-werne apetyemele, kele re angkeke unte ikwere itwele anetyeke apmere Goshen arritnyele. Re angkeke unte ampe-arlke, ngkwenge ipmenhe areye-arlke, ingkirreke akngetyeke. Re angkeke unte yepe-yepe areye, nanikute areye, pweleke areye-arlke akngetyetyeke, ngkwenge urrkapentye akngerre areye-arlke apurte anetyeke ikwere itwele. ");
INSERT INTO aer_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Re ileke merneke-arlke-arle arrangkwe-arle anetyenhe year five-pele arrpenheke-atwetye apmere arrpe-anenhele. Ikwerenge-ntyele re ngenhe arntarnte-aretyenhe angayakwe unte ilweme-ketye.’ Alakenhe-arle unte akngeye atyinhe iletyeke.” ");
INSERT INTO aer_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Joseph angkeke kake ikwerenhe areyeke, “Ayenge araye! Arrantherre itelareme Joseph-arle ayenge arrekantherre angkerle-aneme ayenge-arle Hebrew angkentyele angkemenge-arle. Atyeye akweke atyinhe Benjamin-elarle ayenge areme-arle alknge ikwerenhe-arrpele. ");
INSERT INTO aer_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Kele alhe anteme akngeye atyinheke iletyeke atyenge-arle tyerrtye Egypt-arenye areye-arle atyenge akangkentye anthurre aneme ayenge-arle akngerrepate impene anemenge. Ikwere ilaye ingkirreke arrantherre-arle areke alknge arrekantherrenhe anthurrele. Iparrpe alhaye akngeye atyinhe inetyeke, nhenhe-werne imerte iparrpe akngetye-alpemele.” ");
INSERT INTO aer_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Kele Joseph-ele kake akweke ikwerenhe Benjamin akwaketye-akemele, re imerte ikwere artnemele. Benjamin-arlke ikwere artneke. ");
INSERT INTO aer_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Joseph-ele kake ikwerenhe areye ingkirreke arrwantyeke. Re itneke artneke akwaketye-akemele. Yanhe-ngentyele kake ikwerenhe areye ikwere angkerreke anteme. ");
INSERT INTO aer_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tyerrtye anyentele ileke Pharaoh uthene urrkapentye akngerre ikwerenhe areye utheneke, “Artwe Hebrew nhenge areye Canaan-enge-arle apetyewarreke areye, kake Joseph-kenhe areye kwenhe!” Ayeye renhe awemele, itne arnterre anthurre akangkeke. ");
INSERT INTO aer_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Pharaoh apetyemele Joseph-eke angkeke, “Kake ngkwinhe areye ilaye merne arrernetyeke yakwethe itne-kenheke imerte tangkeye-ke arrernemele itne Canaan-werne alpetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Itnenhe ilaye akngeye itnekenhe akngetye-alpetyeke ikwerenhe areye-arlke apmere atyinhe-werne. Nhenge itne Egypt-eke irretye-alpemele, the itnenhe apmere mwerre anthurre antheme itne anerlte-anetyeke itne merne-arlke mwerre arlkwerlte-anetyenhenge nhenhe-arle anwerne atnyeneme kere areye-arlke anwerne merne mwerre anthetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Urreke alhetyenhenge, wagon areye itnenhe anthaye itne akngetyeke. Nhenge itne Egypt-werne apetyalperlenge, anewe-arlke ampe-arlke wagon itnekenhenge anerlte-apetyenhenge apurrke-irreme-ketye. Akngeye itnekenhe-arlke wagon-eke antyemele apetyetyeke. ");
INSERT INTO aer_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Nhenge itne nhenhe-werne apetyalpemele, itnenhe ilaye merne-arlke, mantere-arlke arne ingkirrenyeke imperlte-alhetyeke. Itnenhene ilaye arne itne-kenheke itirretyale nhenhe Egypt-nge-arle anwerne arne atningke atnyenemenge. Anwerne-arle itnenhe arne mwerre areye nhenhe-ngentyele-arle anthetyenhe.” Alakenhe-arle Pharaoh Joseph-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Kele, Joseph-ele wagon pweleke-kenhe areye itnenhe antheke Pharaoh-elarle ileke-arteke. Re imerte merne-arlke atningke itnenhe anthemele aletheke. ");
INSERT INTO aer_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Re itnenhe mantere mwerre areye antheke itne aletheke irrpetyeke. Re atyeyikwe Benjamin mantere five-pele anthurre antheke, re imerte renhe silver 300-pele anthurre anthemele. ");
INSERT INTO aer_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Joseph-ele itnenhe tangkeye urreye 10-pele antheke arne impene anthurre areye Egypt-ngentyele akngetyerlenge. Re tangkeye marle 10-pele-arlke anthemele merne akngerre akngetyerlenge arne mwerre akngerre arrpenhe areye-arlke akngeye itne-kenheke. ");
INSERT INTO aer_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Joseph angkeke kake ikwerenhe areyeke, “Arrantherre apmere-werne alperlte-iwemele, ahele akerretyale anetyeke!” Kele itne renhe imperlte-alheke anteme. ");
INSERT INTO aer_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Itne Egypt impemele alheke apmere akngeye itnekenhe Canaan-werne alpemele. ");
INSERT INTO aer_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Itne Canaan-eke-irremele, ikwere ileke, “Ngkwenge alere Joseph kwenhe ilwetyakenhe. Re kwenhe itethe akwete! Re kwenhe akngerrepate impene aneme Egypt-arenye areyeke.” Akngeye itnekenhe Jacob atnulkeke anthurre itnenhe awemele rarle itirreke ikwere-arle itne ularele ware-arle ilekeke-athene. ");
INSERT INTO aer_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Itne ileke nthakenhe-arle Joseph angkeke-arlke-akerte. Jacob-ele anteme areke pweleke wagon areye ikwere-arle Joseph-ele yerneke Egypt-ngentyele. Re anteme mwerre awelheke, atnerte ikwerenhe mwerre anthurre anteme-irreke. ");
INSERT INTO aer_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Re alere ikwerenhe areye ileke, “Arratye apeke kwenhe! Kele the arratye anteme itelareme alere atyinhe itethe aneme. Ayenge urreke ilwetyenhenge, ayenge Egypt-werne alhetyenhe renhe aretyeke.” ");
INSERT INTO aer_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Jacob-ele ikwere-artweye areye arne-arlke ikwerenhe areye apurtelhe-ilemele, apmere ikwerenhe imperle-alheke Egypt-werne-atheke. Re mpwepele inteke Beersheba-le. Re pweleke atweke imerte Ngkarte anthemele renhe tnakemele utyernetyeke akngeye ikwerenhe Isaac-elarle itemele anthetyarte-arteke Ngkarte anyente renhe. ");
INSERT INTO aer_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Ingwe ikwerele, Jacob-arle ankwe intekenge, Ngkarte ikwere angkeke. Re ikwere angkeke altyerrenge, “Jacob-aye!” Jacob ikwere angkirtnerlenge, “Wertaye?” ");
INSERT INTO aer_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Ngkarte ikwere angkeke, “Ngkarte anyente-arle ayenge akngeye ngkwinhe-arle utyernemele tnaketyarte re. Kele mwerre-arle unte Egypt-werne alhetyeke, Egypt-arenye areye-ketye atere-irretyale the ngkwenge mpwareme tharle ngenhe alhilekele-arteke. Unte arrenge-arrenge-arlke atningke atnyenetyenhe itne anteme atningke-irretyenhe apmere nhenhele anemele. ");
INSERT INTO aer_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ayenge ngkwengenge alheme Egypt-werne. Unte ilwemele, alere ngkwinhe Joseph-arle ngkwengenge tnetyenhe, rarle iltyele ngenhe alknge martetyenhe. Ikwerenge-ntyele, the ngkwinhe areye Canaan-werne akngirtnetyenhe.” Alakenhe-arle Ngkarte angkeke Jacob-eke altyerrenge. ");
INSERT INTO aer_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Arlte arrpenhele anteme, Jacob uthene tyerrtye ikwere-artweye areye-arlke impemele aname-irreke apmere Beersheba-ngentyele Egypt-werne atheke. Alere ikwerenhe areyele ampe-arlke anewe itnekenhe-arlke utyerneke wagon areyeke itneke-arle yerneke areye Canaan-werne atheke. Itne wagon-ele anerlte-apeke Egypt-werne-atheke alethe alhemele. ");
INSERT INTO aer_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","7","Itne ingkirreke akngeke, yepe-yepe areye, nanikute areye, pweleke areye-arlke arne arunthe-arlke, arne atningke itne-arle apurtelhe-ilekenge Canaan-enge. Jacob alheke Egypt-werne alere ikwerenhe areye-akerte, ampe areye-arlke, arelhe areye-arlke. Re itnenhe Egypt-werne ingkirrenyeke akngeke. ");
INSERT INTO aer_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Nhenhe arritnye-arle tyerrtye areye-kenhe Jacob-enge-arle apmere Egypt-werne alhemeke. Reuben, rarle arrekwelenye Jacob-kenhe-arle. ");
INSERT INTO aer_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Alere arrpenhe Reuben-kenhe areye arritnye aneke, Hanoch, Pallu, Hezron uthene Carmi uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Alere arrpenhe Jacob-kenhe Simeon arritnye aneke. Alere Simeon-kenhe areye Jemuel, Jamin, Ohad, Jakin, Zohar uthene Shaul arritnye aneke. Meye Shaul-kenhe Canaan-arenye-arle. ");
INSERT INTO aer_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Alere arrpenhe Jacob-kenhe Levi-arle aneke. Alere Levi-kenhe areye aneke Gershon, Kohath uthene Merari uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Kenhe alere arrpenhe Jacob-kenhe Judah-arle aneke. Alere Judah-kenhe areye akenhe aneke Er, Onan, Shelah, Perez uthene Zerah uthene. Er uthene Onan uthene apele apmere Canaan-enge ante-arle ilweke-arle. Alere Perez-kenhe Hezron uthene Hamul uthene-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Alere arrpenhe Jacob-kenhe areye akenhe aneke Issachar. Alere Issachar-kenhe aneke Tola, Puah, Jashub uthene Shimron uthene-arlke. ");
INSERT INTO aer_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Kenhe alere arrpenhe Jacob-kenhe Zebulun-arle aneke. Alere Zebulun-kenhe aneke Sered, Elon uthene Jahleel uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Leah-arle akenhe meye aneke Reuben-eke, Simeon-eke, Levi-ke, Judah-eke, Issachar uthene Zebulun uthene Jacob-arle akenhe akngeye itnekenhe aneke. Akweke itnekenhe inteke nhenge Jacob uthene Leah uthene apmere Paddan-Aram-ele anerle-anerretyarte. Ampe marle Jacob-kenhe yanhele-arle akweke inteke ante-arle. Ye, Jacob uthene Leah uthenele atnyeneke 33-pele anthurre tyerrtye areye yanhele-arle inteke areye. ");
INSERT INTO aer_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Alere arrpenhe Jacob-kenhe Gad-arle aneke. Alere Gad-kenhe areye aneke Zephon, Haggi, Shuni, Ezbon, Eri, Arodi uthene Areli uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Alere arrpenhe Jacob-kenhe Asher-arle aneke. Alere Asher-kenhe areye akenhe Imnah, Ishvah, Ishvi uthene Beriah uthene-arle aneke. Yaye itnekenhe arritnye Serah-arle aneke. Alere atherre Beriah-kenhe Heber uthene Malkiel uthene-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Zilpah-arle akenhe meye aneke Gad uthene Asher utheneke. Re akenhe urrkapentye akngerre Leah-kenhe-arle aneke Laban-elarle Leah arrekwele antheke. Leah renhe antheke Jacob uthene ratherre intetyeke. Ye, Jacob uthenele areye 16-pele anthurre atnyeneke. ");
INSERT INTO aer_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Anewe arrpenhe Jacob-kenhe Rachel-arle aneke. Alere ikwerenhe atherre akenhe Joseph uthene Benjamin uthene-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Nhenge Joseph-arle Egypt-ele anetyartenge, re marle Asenath arritnye anewe-akeke. Ikwere akngeye akenhe Potiphera arritnye-arle aneke. Re akenhe arrawe-irrentye akngerrepate itnekenhe-arle aneke apmere On-ele. Alere Joseph-kenhe atherre aneke Manasseh uthene Ephraim uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Arritnye alere Benjamin-kenhe aneke Bela, Beker, Ashbel, Gera, Naaman, Ehi, Rosh, Muppim, Huppim uthene Ard uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jacob uthene Rachel uthene-ngentyele, tyerrtye 14-pele anthurre-arle inteke-arle. ");
INSERT INTO aer_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Alere arrpenhe Jacob-kenhe Dan-arle aneke. Alere Dan-kenhe Hushim-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Alere arrpenhe Jacob-kenhe Naphtali-arle aneke. Naphtali ikwerenhe alere aneke Jahziel, Guni, Jezer uthene Shillem uthene. ");
INSERT INTO aer_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Bilhah meye aneke Dan uthene Naphtali utheneke. Re akenhe urrkapentye akngerre Rachel-kenhe-arle Laban-elarle arrekwele antheke. Rachel-ele renhe antheke Jacob ratherre intetyeke. Jacob uthene Bilhah uthenenge ampe 7-pele inteke. ");
INSERT INTO aer_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","27","Ingkirrenyeke 70-pele apurte-irremele itne alherlte-iweke Jacob-enge Egypt-werne. Tyerrtye 70-pele nhenhe itneke-ngentyele anherre-anherre ikwerenhe areye-arlke alherlte-iweke. Re tyerrtye ingkirrenyeke pipe nhenhele-arle arritnye aneme areyenge alheke. Alere Joseph-kenhe atherre apele Manasseh uthene Ephraim uthene Egypt-elarle akweke inteke atherre-arle. ");
INSERT INTO aer_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Kele Jacob ikwere-artweye areye-akerte Egypt-nge arlenge kwenye anteme aneke, re alere ikwerenhe Judah ileke alhetyeke arrekwele Joseph-eke unthetyeke. Judah-ele Joseph iletyeke alheke ikwerenheke-artweye areye-arle apetyewarremenge. Kele imerte, Jacob ikwere-artweye areye-akerte apmere Goshen ikwere-werne alheke. ");
INSERT INTO aer_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Nhenge Joseph-ele aweke arteke akngeye ikwerenhe-arle apetyeme, re urrkapentye akngerre areye ileke wagon akweke ikwerenhe inetyeke akngeye ikwerenheke arneke-arnare-irretyenhenge. Re ikwere itweke-irreke arteke, renhe akwaketye-akemele. Re renhe mwantye-mwantye-ilemele akwete anthurre ikwere artnemele. ");
INSERT INTO aer_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Jacob alere ikwerenheke angkeke, “Kele the ngenhe inngerre areme. Kele the itelareme unte itethe anteme aneme. Alakenhenge akwele ayenge lyete ilwerlenge apeke, ayenge akangkentye-arle ilweme.” ");
INSERT INTO aer_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Kele Joseph-ele kake ikwerenhe areye akngeye ikwerenhe-kenhe areye-arlke ileke, “Kele the Pharaoh-eke iletyeke alheme arrantherre-arle kele apetyewarrekenge. The ikwere alakenhe ileme, ‘Kake atyinhe areye akngeye atyinhe-arlke Canaan-engentyele nhenhe-werne apetyewarreke atyengenge anetyeke. ");
INSERT INTO aer_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Itne thakemene, yepe-yepe areye, nanikute areye, pweleke areye-arlke arntarnte-arentye akngerre. Itne arne ingkirreke akngetyewarreke.’ Alakenhe-arle the Pharaoh-eke iletyenhe. ");
INSERT INTO aer_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Re nhenhe awemele arteke re urrkapentye akngerre ikwerenhe areye yerneme arrenhantherrenhe inetyeke renhe aretyeke arrantherre alhetyeke. Arrantherre apeke renhe aretyeke alhemele, re arrenhantherrenhe alakenhe-arle apayuthnetyenhenge, ‘Warrke iwenhe-arteke-ame arrantherre mpwarentye akngerre?’ ");
INSERT INTO aer_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","Re arrenhantherrenhe alakenhe apayuthnemele, arrantherre akenhe ikwere alakenhe-arle ilerlenge, ‘Anwerne-arle thakemene areye-arle. Anwerne-arle yepe-yepe areye, nanikute areye-arlke, pweleke areye-arlke-arle arntarnte-arentye akngerre arrekwelenye anwerne-kenhe areye-arteke. Kele anwerne ngkwenge urrkapetyeke.’ Alakenhe renhe iletyeke. Pharaoh-eke arrantherre alakenhe angkemele, re arrenhantherrenhe ileme arrantherre Gosher-ele anerrirretyeke tyerrtye areye-ketye arntwarrele Egypt-arenye areye-ketyenge-arlke. Egypt-arenye areye-arle ilkelhetyakenhe-arle thakemene areyeke.” ");
INSERT INTO aer_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Joseph apmere Goshen imperle-alhemele alheke Pharaoh renhe iletyeke, “Akngeye atyinhe kake atyinhe areye-arlke nhenhe Canaan-engentyele apetyewarreke. Itne yepe-yepe areye-arlke pweleke areye-arlke itnekenhe akngetyewarreke. Goshen-ele akwele itne.” ");
INSERT INTO aer_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Kele Joseph alpeke imerte kake five-pele ikwerenhe akngakemele Pharaoh renhe aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Nhenge itne apmere Pharaoh-kenheke irrpenhemele, re itnenhe apayuthneke, “Iwenhe-arteke warrke-ame arrantherre mpwarentye akngerre?” Itne ikwere angkirtnewarreke, “Anwerne-arle thakemene areye-arle. Anwerne-arle yepe-yepe-arlke, nanikute areye-arlke, pweleke areye-arlke arntarnte-arentye akngerre-arle arrekwelenye anwerne-kenhe areye-arteke. Anwerne ngkwenge lyete-ante urrkapewarreme. ");
INSERT INTO aer_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Anwerne-arle ipenye areye ware anetyeke-arle apetyewarreke. Atherrkeke-arlke arrangkwe-arle apmere anwerne-kenhe Canaan yepe-yepe areyele apeke pweleke areyele apeke arlkwetyeke. Anwerne-arlke arrpenhe areye-arlke-arle ingkirreke angayakwe-arle anerrirreke. Anwernenhe aywepetyale! Anwerne apmere Goshen-ele anerlte-anetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Pharaoh anteme Joseph-eke angkeke, “Yewe, akngeye ngkwinhe kake ngkwinhe areye-arlke ngkwengenge anetyeke apetyeke. ");
INSERT INTO aer_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Apmere itneke akngakaye nhenhe Egypt-nge apmere mwerre itnenhe anthaye akngeye ngkwinhe kake-arlke ngkwinhe areye. Kele itne Goshen-ele anetyeke. Itne apeke thakemene mwerre areye, itne pweleke areye-arlke yepe-yepe areye-arlke atyinhe arntarnte-aretyeke anteme.” ");
INSERT INTO aer_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","9","Joseph anyikwe Jacob inetyeke alheke, re anteme renhe akngirtneke Pharaoh aretyeke. Re apmere ikwereke-irremele Jacob-ele Ngkarte apayuthneke re Pharaoh ikwere mwerre anetyeke renhe arntarnte-aremele. Pharaoh-ele anteme Jacob apayuthneke, “Artwe ampwaye, year nthakentyeke-atwetye-ame unte itethe aneke?” Jacob ikwere angkirtneke, “Year 130-peleke-atwetye kwenhe ayenge aneke apmere arrpe-anenhele ipenye unthemele. Akngeye atyinhe, arrule anthurre itethe arlenge ulkere-arle aneke, ayenge-arteke kwenye, ayenge-arle mwerre anetyakenhe-arle aneke, ayenge-apenhe.” ");
INSERT INTO aer_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Jacob-ele awethe Ngkarte apayuthneke Pharaoh-eke mwerre arntarnte-aretyeke. Re anteme imperle-alhemele alheke. ");
INSERT INTO aer_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Kele-arle akngeye Joseph-kenhe uthene kake areye-arlke Pharaoh-eke angkeke iperre, Joseph-ele mpwareke Pharaoh-elarle renhe ileke-arteke akwete; re akngeye ikwerenhe kake-arlke ikwere-artweye areye apmere mwerre anthurre antheke. Apmere re akenhe apmere arrpenhe akngerre Rameses-enge arlenge kwenye-arle. ");
INSERT INTO aer_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Re anteme ikwere-artweye areye merne akwetethe anthurre anteme anthetyarte. Itne anteme angayakwe irretyakenhe anetyarte. ");
INSERT INTO aer_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kwatyele-arlke anhetyakenhe akwete aneke Egypt uthene Canaan uthenele ahurratye anthurre akwete aneke. Tyerrtye areye kele angayakwe anthurre anteme aneke merneke-arlke arrangkwenge anteme. ");
INSERT INTO aer_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Alakenhe anteme itne apetyewarretyarte Joseph-engentyele merne inerrirretyeke, arrantherre itelareme merne annge nhenge areye-arle re warle akngerreke arrekwele arrerneke-arle. Itne mane itnekenhe ingkirreke anthurre renhe antheke, re imerte itnenhe merne-arle anthemele, kele mane-arle itne ingkirre anthekenge, Joseph-ele mane itnenhe apmere Pharaoh-kenhe-werne akngemele, yanhe ikwerele atnyenetyarte. ");
INSERT INTO aer_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Nhenge tyerrtye Egypt-arenye areye uthene tyerrtye Canaan-arenye areye-arlke mane ingkirreke itnekenhe uyerrelhe-ilekenge merne inemele. Itne Joseph-werne apetyewarreke, imerte ikwere angkerrirremele, “Ayekaye! Anwernenhe merne arlkwetyeke anthaye! Anwerne kwenhe mane ingkirreke uyerrelhe-ileke! Unte apeke anwernenhe merne anthetyakenhenge, anwerne ilweme-arle unte arerlenge!” ");
INSERT INTO aer_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Joseph itneke angkirtneke, “Arrantherre maneke arrangkwe, kele mwerre. Ayenge nanthe arrekantherrenhe anthaye, pweleke areye, yepe-yepe areye, tangkeye areye-arlke. Yanhe areyeke the arrenhantherrenhe merne arlkwetyeke-arle anthetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Kele alakenhe anteme itne mpwarewarreke. Tyerrtye areye Canaan-arenye uthene Egypt-arenye areyele uthene nanthe areye-arlke akngetyeke, pweleke areye, yepe-yepe areye, nanikute areye, tangkeye areye-arlke itne imerte Joseph anthemele. Yanhe-ngentyele re itnenhe merne anteme antheke kere itneke. Year anyenteke-atwetye re itnenhe merne antherle-aneke. ");
INSERT INTO aer_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Kele year arrpenhele anteme, tyerrtye itne Joseph-werne apetyete-alpeke, itne imerte ikwere angkemele, “Unte itelareme anwerne kwenhe maneke arrangkwe akwete. Kele nanthe-arlke, pweleke-arlke, yepe-yepe-arlke, tangkeye-arlke, nanikute-arlke kele ngkwinhe anteme. Iwenhe anteme-ame anwerne ngenhe anthetyenhe? Anwerne-ame apmere anwerne-kenhe anteme ngenhe anthetyenhe anwernenhe-arlke apeke unte ngkwenge inetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Unte-ame areme? Anwernenhe ilwetyeke impetyalaye! Unte areme apmere-arlke ahurratye anthurre. Arne-arlke lyapetyakenhe. Arne arrpe-anenhe ilwetyenhe anwerne-arlke apeke ilwetyenhe! Unte apeke anwernenhe merne arlkwetyeke anthemele, kele anwerne-arrpe ngkwenge anthelheme-arle, apmere-arlke anwerne-kenhe. Pharaoh-kenhe anteme-arle anwerne anemele, anwerne anteme ikwere ayernentye akngerre areye-arteke anteme urrkapeme. Anwernenhe merne annge anthaye ahelheke anwerne-arle ngkernetyenhenge. Anwerne apeke itnenhe ahelheke ngkernemele, itne apeke atherrke lyapetyenhenge. Kenhe anwerne apeke annge areye ngkernetyakenhe, kele apmere ingkinyeke anthurre-arle intetyenhenge.” Alakenhe-arle tyerrtye itne Joseph-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Joseph-ele apmere ingkirreke tyerrtye itneke-ngentyele ineke, imerte Pharaoh anthemele ahelhe-arle ahurratye anthurre anekenge tyerrtye itne arne arrpenheke arrangkwe anthetyeke anekenge merne inetyeke, itne anteme apmere itnekenhe antheke. Alakenhenge anteme itne Joseph apmere akweke-ame-akweke antheke. Yanhe-ngentyele apmere arrpe-anenhe Egypt-ele Pharaoh-kenhe anteme aneke. ");
INSERT INTO aer_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tyerrtye areye-arlke-arle Pharaoh-kenhe anteme aneke itne-arle merneke anthelheke Pharaoh-eke. Joseph-ele itnenhe uterneke urrkapetyeke ayernentye akngerre areye-arteke merneke-ante atheke. Tyerrtye arrpe-anenhe-arle Pharaoh-eke ayernentye akngerre-arteke urrkapetyarte. ");
INSERT INTO aer_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Artwe areye ngkarte-apartetye Egypt-kenhe areyeke urrkapetyarte mane akwete-arle atnyeneke, urrkapentye iperre-arle itnenhe Pharaoh-elarle antheke. Itne merne ineke mane urrkapentye iperre itnekenhele. Alakenhe ikwerenge-arle Joseph-ele apmere itnekenhe inetyakenhe itne ayernentye akngerre anetyakenhe aneke tyerrtye arrpenhe areye-arteke. ");
INSERT INTO aer_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Joseph imerte tyerrtye areyeke angkeke, “Ayenge awerrirraye. Arrantherre-arlke apmere arrekantherrenhe-arlke kele Pharaoh-kenhe anteme-arle aneke. The arrenhantherrenhe iltye antheke ikwere urrkapewarretyeke. The arrenhantherrenhe annge antheme ahelheke ngkernetyeke. Anyenteke-anyente, arrantherre merne annge apmere-werne akngaye. Ahelheke imerte ngkernemele lyapetyeke. ");
INSERT INTO aer_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Arratye apeke lyaperlenge merne annge areye mpenge-irremele, akemele lyernte-arrernaye lyernte five-pele imerte arrernemele, Pharaoh imerte anyente anthemele, four-pele arrpenhe imerte arrekantherre-arle atnyenemele arrekantherre-artweye-arlke ampe areyele-arlke arlkwetyeke. Merne annge arrpenhe areye imerte ahelheke-arle ngkernirtnemele lyapetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tyerrtye itne Joseph-eke angkeke, “Kele anteme, unte-arle angkeme-arteke anwerne mpwareme. Unte apeke anwernenhe urrkapetyeke ileme, anwerne-arle Pharaoh-eke urrkapetyenhe ayernentye akngerre areye-arteke merneke ware unte-arle anwerneke mwerre anekenge anwernenhe itethe atnyenemele.” ");
INSERT INTO aer_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Joseph-ele pipe-ke intelhe-ileke angkentye tyerrtye ingkirreke akangkwe-irremele anetyeke. Alakenhe-arle ayeye re aneme: “Nhenge tyerrtye areyele apeke merne annge ngkernemele ahelheke lyapetyeke, re imerte mpenge-irremele, itne imerte lyernte-arrernemele, Pharaoh-eke anyente, four-pele arrpenhe akenhe itneke-arrpe.” Alakenhe-arle Joseph-ele intelhe-ileke Egypt-arenye areyele aretyeke. Alakenhe akwete-arle lyete-arlke mpwarerlte-aneme. Kenhe artwe areye ngkarte-apartetye Egypt-kenhe areyeke urrkapetyarte-arle, angkentye nhenhe apentetyakenhe-arle Pharaoh-elarle apmere itnekenhe inetyakenhenge. ");
INSERT INTO aer_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Kele-arle Joseph-ele ikwere-artweye areye anamelhe-ilekenge, tyerrtye Israel-arenye nhenge areye, apmere Goshen-ele itne aneke year 17-peleke-atwetye. Itnekenhe arne-arlke atningke-irremele aneke ampe areye-arlke atningke-irremele anthurre anteme. ");
INSERT INTO aer_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Artwe ampwe Jacob, re Goshen-ele aneke year 17-peleke-atwetye. Rarle ilwekenge anteme, re year 147-peleke-atwetye aneke-arle. ");
INSERT INTO aer_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Urreke re ilwetyenhenge, re Joseph-eke antangkelheke renhe aretyeke apetyetyeke. Joseph apetyeke-arle iperre Jacob ikwere angkeke, “Alere, ayenge kwenhe ilwetyenhe anteme. Unte apeke atyenge ahentye-aneme, atyenge arratye ilelhaye. Atyenge arratye ilelhaye ayenge ilwerlenge, unte ayenge nhenhe Egypt-eke iperteke artetyale. ");
INSERT INTO aer_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","31","Tyerrtye atyalangke atyinhe inemele Egypt-ngentyele imerte ayenge akngirtnemele akngeye atyinhe areye-arle ipertele artelheme-werne itneke itwe ayenge artetyeke. Alakenhe ayenge ilaye!” Joseph ikwere alakenhe angkirtnerlenge, “Yewe, the ngenhe akngirtnemele ngenhe apmere ngkwinheke artetyeke.” Yanhe-ngentyele, Jacob anteme iwelheke apurrke anteme antyameke, imerte Ngkarteke akangkentyele angkemele. ");
INSERT INTO aer_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Ikwere ipenhe, Joseph-ele aweke Jacob-arle rlkerte anthurre irrekenge, ingkwe ilwemele. Re alere ikwerenhe atherre akngeke, Manasseh uthene Ephraim uthene, apmere Goshen-werne Jacob aretyeke. ");
INSERT INTO aer_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Nhenge Joseph apmereke irretye-alhemele alere ikwerenhe atherre-akerte, tyerrtye arrpenhele iletyeke alheke Jacob-eke, “Alere ngkwinhe nhenhe-werne apetyeke ngenhe aretyeke.” Jacob tyerrtye alyepe-alyepe anthurre intetyame, re intetyame tnetye-arlke-akenhe. Nhenge Joseph apmere ikwereke-irreke arteke alere ikwere-atherre-akerte, Jacob mwantye anthurre akeme-irremele aneke. ");
INSERT INTO aer_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","4","Jacob angkeke Joseph-eke, “Arrule anthurre Ngkarte lterrke anthurre rarle, atyenge imernelheke apmere Luz-enge apmere akngerre Canaan-enge. Re ayenge ileke rarle ayenge arntarnte-arerle-anetyenhe lterrke-ilemele akwetethe, re imerte ampe atningke ayenge anthemele itne imerte atningke anteme irremele. Re atyenge angkeke, ‘Atyengenge ularre ware kwenhe unte ampe atningke atnyenetyenhe. The ngenhe apmere nhenhe antheme ampe ngkwinhe areyeke ampe itnekenhe areyeke anthetyeke. Itnekenhe anteme aneme akwetethe.’ Alakenhe-arle atyenge Ngkarte angkeke. ");
INSERT INTO aer_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Joseph, ngkwenge alere atherre Manasseh uthene Ephraim uthene-arle apmere nhenhe Egypt-elarle akweke inteke. Ayenge-arle ingkerne ante-arle apmere nhenhe-werne apetyeke. Lyete ayenge ikwere-atherre altye-irreme, ratherre anteme atyinhe aneme Reuben uthene Simeon uthene-arteke. ");
INSERT INTO aer_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Kele urreke, unte alere awethe atnyenemele, kele itne ngkwinhe-arle anetyenhe. Tharle itnenhe apmere anthetyeke arrangkwe-arle. Itne apmere Ephraim uthene Manasseh uthene-arle antheme ikwerele anetyeke-arle. ");
INSERT INTO aer_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Arrule anthurre, ayenge-arle apmere Paddan-engentyele apetyalpemele, the anewe atyinhe aparlpe-ileke apmere nhenge Canaan-ele ilerne alhele-iwemele. Ayenge alhwarrpe anthurre irreke renhe iperteke artemele iwerre itereke Ephrath-werne-atheke, ayenge ikwere ahentye anthurre aneke, alakenhenge anteme ayenge angkeme Ephraim uthene Manasseh utheneke.” Alakenhe-arle Jacob Joseph-eke angkeke. Apmere yanhe Ephrath, lyete tyerrtye areyele Bethlehem ileme. ");
INSERT INTO aer_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Kele Jacob-ele areke urreye ratherre Joseph-enge tnerle-anerrerlenge. Jacob-ele renhe apayuthneke, “Angwenhe-ame urreye nhenhe atherre?” Re angkeke alakenhe rarle pwenge anteme-irrekenge aretye-arlke-akenhe. ");
INSERT INTO aer_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Joseph-ele anyikwe tyerneke, “Nhenhe-arle alere atyinhe atherre-arle Ngkartele-arle ayenge nhenhe Egypt-nge antheke-arle.” Jacob angkeke Joseph-eke, “Ngkwenge alere atherre atyenge-werne akngetyaye ayenge ikwere-atherre alyelhentye impenele alyetyenhenge ilpentyeke ratherre akwete-ante atnyenerle-anerretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Jacob-arle artwe ampwe anthurre-arle aneke, re anteme aretyakenhe aneke rarle pwenge-arle anekenge. Kele Joseph-ele urreye renhe-atherrenhe itwekelhe-ileke Jacob-werne. Jacob-ele renhe-atherrenhe akwaketye-akeke. ");
INSERT INTO aer_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Re imerte Joseph-eke angkemele, “Ayenge-arle itirreke unte-arle akwele ilwekeke-athene. Ayenge-arle itirreke tharle akwele ngenhe awethe aretyenheke-athene, kele arrangkwe-arle. Ngkarte-arle atyenge mwerre-arle aneke. Rarle ayenge akngetyeke alere ngkwinhe atherre aretyeke-arle.” ");
INSERT INTO aer_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","13","Joseph-ele ikwere alere atherre Jacob-enge arrwekele ngkerneke, re iltye akaperte ikwere-atherrenheke arrernemele alyelhentye impenele alyetyeke. Joseph akaperte kwene-irreke urreye ikwere-atherre ingkernele. Inngerre ikwerenhele ahelhe anpeke. Re akarelheke Jacob-eke ikwere-atherre alyelhetyeke. Manasseh akenhe kake akngerre Ephraim-kenhe-arle aneke. ");
INSERT INTO aer_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Ikwerenge anteme, Jacob-ele kwenhe iltye akwe-arratye ikwerenhe Manasseh akaperteke arrernetyakenhe, kele arrangkwe-arle. Jacob-ele akenhe kele-arle Ephraim akaperteke arrerneke. Re iltye akwangenye ikwerenhe-arle Manasseh-eke arrerneke. ");
INSERT INTO aer_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Jacob Joseph-eke-urrke alyelheke, alakenhe-arle re alyeke, “Arrenge-arrenge atyinhe Abraham uthene akngeye atyinhe uthenele Ngkarte anwerne-kenhe-arle apenterle-anerreke. Ngkartele-arle ayenge akwetethe arntarnte-arentye akngerre, arntarnte-arentye akngerrele-arle yepe-yepe ikwerenhe areye arntarnte-arentye akngerre-arteke, alakenhe akwele. ");
INSERT INTO aer_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Nhenge atyenge-arle akurne-irrerlenge, alkere-arenye Ngkarte-kenhe areyele ayenge arntarnte-aretyarte. Lyete the Ngkarte apayuthneme nhenhe atherre arntarnte-aretyeke lterrke-ilemele. Nhenhe atherre atyenge-artweye-arteke. Nhenge ratherre amangkemele, ratherre ampe areye atyenge atnyenetyenhe, arrenge-arrenge atyenge Abraham-eke akngeye atyenge Isaac-eke-arlke. The Ngkarte apayuthneme nhenhe atherre ampe atningke anthetyeke. Apmere arrpe-anenhele anerlte-anetyeke. Itne anwerneke alkngwirretyeke kwenye anetyenhenge.” Alakenhe-arle Jacob-ele alyeke urreye akweke ikwere-atherre. ");
INSERT INTO aer_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Urreke Jacob-ele urreye ikwere-atherre alyelhetyenhenge, Joseph-ele areke akngeye ikwerenhe iltye arrernerlenge akwe-arratye ikwerenhe Ephraim ingkernenyeke arrernerlenge. Alakenhe re irrekenge Joseph akangkentye anetyakenhe aneke. Re akngeye ikwerenhe-kenhe iltye akwe-arratye inemele Ephraim-engentyele imerte akaperte Manasseh-kenheke arrernetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Re Jacob-eke angkeke, “Akngeye, unte kwenhe apalele akwe-arratye ngkwinhe arrerneke Ephraim akaperteke. Unte kwenhe Manasseh akaperteke arrernetyakenhe aneke. Re kake akngerrepate. Iltye akwe-arratye Ephraim akaperteke arrernaye.” ");
INSERT INTO aer_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Kenhe anyikwe ayene-ilelheke ikwere angkemele, “Arrangkwe, the iltye akwe-arratye apale arrernetyakenhe Ephraim akaperteke. Nhenge Manasseh anteme amangkemele, rarle akngerrepate anetyenhe, rarle ampe atningke atnyenetyenhe arrenge-arrenge-arlke atningke. Kele atyeyikwe akenhe akngerrepate impene-arle anetyenhe Manasseh-enge arntwarre ulkere, tyerrtye Ephraim-kenhe-arle atningke-arle anetyenhe, itnekenhe apmere arrpe-anenhele-arle anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Jacob awethe alyelheke Manasseh uthene Ephraim utheneke, “Urreke, tyerrtye Israel-arenye areye ampe itne-kenheke alyelhetyenhe, alakenhe-arle itne angketyenhe, ‘Anwerne Ngkarte apayuthnetyenhe arrenhantherrenhe mwerre-iletyeke rarle Ephraim uthene Manasseh uthene mwerre-ileke-arteke.’” Alakenhe-arle Jacob alyelheke, Ephraim akngakemele rarle Manasseh-enge irntwarre-arle anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Jacob angkeke Joseph-eke, “Ayenge araye. Ayenge ilwetyenhe anteme. Ngkarte-arle ngkwengenge anetyenhe. Rarle ngenhe apmere akngeye ngkwinhe-kenhe-werne akngirtnetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","The ngenhe apmere antheke, tharle kake ngkwinhe areye arrekwele anthetyakenhe aneke. The ngenhe apmere Shechem arritnye-arle antheke. The apmere yanhe ineke tyerrtye Amorite areye-ngentyele-arle. The itnekenge ineke akngerre anthurre-arle atwerreke iperre.” ");
INSERT INTO aer_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Kele-arle Jacob re Ephraim uthene Manasseh utheneke alyelheke iperre, re alere arrpenhe ikwerenhe areyeke antangkelheke renhe aretyeke apetyetyeke. Nhenge itne ikwereke irrerlenge, re itneke angkeke, “Atyenge-werne angathe-irrerraye anyente-ame-anyente ayenge arrekantherre alyelhetyenhenge. The ileme nthakenhe-arle arrantherre irretyenhe urreke.” Re imerte alyemele anteme. ");
INSERT INTO aer_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Atyenge alere areye, atyenge-werne angathe-irrerraye arrantherre ayenge awetyenhenge. Jacob-arle ayenge, akngeye arrekantherrenhe arritnye atyinhe akenhe Israel-arle.” ");
INSERT INTO aer_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Reuben-eke-urrke Jacob-ele alyeke, “Reuben, unte alere akngerrepate atyinhe-arle, arrule anthurre ayenge-arle atyepe-atyepe-arlke anekenge. The meye ngkwinhe anewe akeke, unte-arle ampe atyinhe arrekwelenye atyinhe aneke ayenge-arle artwe anteme-irrekenge. Alakenhenge anteme the itelareke ayenge-arle lterrke aneke. Unte-arle alere arrpenhe atyinhe nhenhe areyeke akngerrepate, unte arrpenhe atyeye areyenge lterrke ulkere. ");
INSERT INTO aer_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Kele unte akenhe ahe-akngerre anthurre-arle. Angwenhele-arle-ame ngenhe ayaketyenhe unte akurne mpwarerlenge? Arrule anthurre-arle unte arelhe anewe atyinhenge inteke, urrkapentye akngerre nhengenge-arle, unte-arle ayenge apurele-anthurre-arle-antheke. Alakenhenge anteme unte kake ngkwinhe areyeke akngerrepate anetyakenhe aneme.” ");
INSERT INTO aer_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Kele Jacob-ele Simeon uthene Levi uthene anteme alyeke, “Simeon uthene Levi uthene, mpwele-arle atyeyenhenge-arle aneme. Mpwele kwenhe arraweye anthurre akwetethe-arle arrpenhe areye ahele-ahele akeme. Arrule anthurre, mpwele tyerrtye areye atweke nayepe akngerre mpwele-kenhele akemele. ");
INSERT INTO aer_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Mpwele tyele-arle angketyarte tyerrtye nhakwe atwetyeke. Tharle mpwelenhe akayake-iletyakenhe-arle alakenhe-irrerlenge. Arrule mpwele tyerrtye areye atweke mpwele-arle itneke ahentye-anetyakenhe anekenge. Mpwele nayepele alwerrknge pweleke-kenhe-arlke aketyarte itnenhe unthetyakenhe mpwaremele, mpwele-arle arrkerneke ware-arle alakenhe mpwarerle-anerreke, akurne anthurre-arle alakenhe. ");
INSERT INTO aer_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Mpwele-arle apure-arlke anetyakenhe-arle tyerrtye arrpenhe areye-ketye, mpwele-arle ahele anthurre-arle lterrke anthurre-arlke-arle arrpenhe areyeke alakenhenge anteme the mpwelenhe Ngkarteke iletyenhe mpwelenhe artimperre-iwetyeke. Tharle mpwelenhe apmere ampe mpwele-kenheke-arlke anthetyeke arrangkwe-arle. Itne-arle apmere atnyenetyeke arrangkwe-arle. Itne-arle apmere kake itnekenhe-kenhele ware-arle anetyenhe the itnenhe antherlenge.” ");
INSERT INTO aer_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","Jacob-ele Judah anteme alyeke, “Judah, kake ngkwinhe areye kwenhe ngkwenge akangkentye anthurre anetyenhe. Itne anteme ngkwenge artepe arrernelhetyenhe. Tyerrtye areye ngkwenge ahentye-anetyakenhe, unte apeke itneke ahele-irremele, unte itnenhe irrerlknge-arle atweme. ");
INSERT INTO aer_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Unte kwenhe lion ahe akngerre-arteke, lion arrpenheke ahele unthemele imerte atwemele arlkwemele nhenge ulkere-arteke. Re itnenhe atwemele, imerte arlkwemele, apmere-werne anteme-arle apetyalpemele. Imerte re ahelheke iwelhemele ankwe-intemele. Renhe-arle angwenhele akemelhe-iletyeke arrangkwe-arle itne-arle atere-arle-irreme lion ikwere-ketye! Judah, alakenhe-arle unte lterrke anthurre. ");
INSERT INTO aer_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","The ngenhe apmere nhenhe antheme. Unte akngerrepate irretyeke unte lterrke akwete anemele ngkwengenge raketyeke arrangkwe-arle. Ikwerenge anteme ngkwenge alere areye arrenge-arrenge ngkwinhe areye-arle akngerrepate anetyenhe King areye-arteke. Yanhe-ngentyele, tyerrtye anyente Shiloh arritnye anteme apetyetyenhe. Tyerrtye apmere arrpe-anenhe-ngentyele apetyetyenhe renhe awetyeke, itne anteme ikwere akangkwe-irreretyenhe, apwerte mane-arlke arne mwerre akngerre arrpenhe areye-arlke ikwere-werne akngetyewarremele. ");
INSERT INTO aer_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Judah, unte apmere renhe arntarnte-aretyeke, unte tangkeye ngkwinhe areye ayernetyeke itne arne kripethe itwele anetyeke arlpelhe areye arlkwetyeke arne kripethe atningke anthurre-arle lyapemenge. ");
INSERT INTO aer_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Alknge ngkwinhe athetheke anthurre irretyenhe ngkwarle iperre, artitye ngkwinhe mperlkere anetyenhe unte-arle werlatye antywemenge.” ");
INSERT INTO aer_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Kele Jacob-ele Zebulun anteme alyeke, “Zebulun, apmere ngkwinhe ayerrere-werne atheke Sidon-eke-atwetye, kwatye alaye akngerre itwele. Apmere mwerre anetyenhe boat areye-arle tnerlte-anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Kele Jacob-ele Issachar anteme alyeke, “Issachar, unte tangkeye lterrke-arteke-arle anetyenhe arne arunthe akngernentye akngerre-arteke. Kele apurrke anteme arne ulthentye areye-akerte iwelhemele yakwethe areye artepele akwete akngernemele. ");
INSERT INTO aer_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Alakenhe-arle unte anetyenhe, unte-arle apmere mwerreke-arle apale untherle-apetyenhe unte apurrke-irremele. Unte-arrpe angketyenhe, ‘Yewe, apmere nhenhe-arle mwerre anthurre-arle!’ Arratye-arle yanhe! Apmere yanhele-arle unte arnterre anthurre-arle urrkapetyenhe ayernentye akngerre-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Kele Jacob-ele Dan anteme alyeke, “Dan, kele-arlke ngkwinhe areye akweke anteye aneme, unte apele ngkwinheke-artweye areyeke akngerrepate anetyenhe, arrpenhe areye-arteke akngerrepate anyenhenge itne-kenheke apmere Israel-ele. ");
INSERT INTO aer_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Unte-arle apmwe ahe-akngerre iwerre iterele-arle interle-aneme-arteke-arle anetyenhe. Tyerrtye apeke nanthenge apetyemele iwerre ikwerele, kele apmwe re apeke akweke anemenge, kele nanthe renhe ngkwerne-arle uthnemele. Nanthe re rlkerte awelhemele anteme unteme, tyerrtye renhe ahelhe-werne atheke-arle iweme.” ");
INSERT INTO aer_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Jacob anteme YAHWEH-eke angkeke, “YAHWEH, the ngenhe apayuthneme unte anwernenhe arntarnte-aretyeke tyerrtye arrpenhele-arle anwernenhe atweme-ketyenge.” ");
INSERT INTO aer_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Kele Jacob-ele Gad anteme alyeke, “Gad, tyerrtye areyele ngenhe akwetethe atwetyeke-irretyenhe. Itne ngkwenge-ngentyele arrkernemele anyelkngele inetyeke, kele arrangkwe. Kenhe unte itnenhene alwernetyenhe atwetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Kele Jacob-ele Asher anteme alyeke, “Asher, apmere ngkwinhele merne mwerre atningke lyapetyenhe merne mwerre akngerrepatele arlkwenhe-arlkwenhe-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Kele Jacob-ele Naphtali anteme alyeke, “Naphtali, unte-arle nanthe marle-arteke ipmentye aywepeke-arle iperre, akwerrke mwerre akngerre areye atnyenetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Kele Jacob-ele anteme Joseph alyeke, “Joseph, unte apele tangkeye ahe akngerre-arteke anetyenhe kwatye pintye itwele, nhenge tangkeye ahe akngerre-arteke apwerte iterele aneme. ");
INSERT INTO aer_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Artwe areye ngkwenge-werne apetyeke atwetyeke. Itne irraweye anthurre apetyewarreke ngenhe althenhemele irrtyartele, kwetere-akertele-arlke. ");
INSERT INTO aer_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Kenhe unte akenhe atere arrewetyakenhe-arle aneke, arrangkwe-arle. Unte nterte-nterte-arle tneke, unte imerte irrtyarte ngkwinhele itnenhe thilemele. Ngkarte atyinhe-arle lterrke anthurre-arle, Rarle ngenhe ngangkere antheke. Ngkarte atyinhe-arle Israel apwerte antherrtye-arteke-arle. Rarle ngenhe lterrke-ileme-arle. Re yepe-yepe arntarnte-arentye akngerre-arteke-arle yepe-yepe ikwerenheke ahentye-aneme-arteke. Re atyenge ahentye-aneme, re ngkwenge-arlke ahentye-anemele. ");
INSERT INTO aer_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Ngkarte atyinhe-arle ngkwengenge anetyenhe. Rarle lterrke anthurre-arle! Re ngenhe aremele arntarnte-arerle-anetyenhe ngenhe lterrke-ilemele. Re ngkwenge kwatye yerneme alkere-ngentyele, kwatye pelhe-pelhe-arlke re ngenhe antheme ngkwenge anewele ampe atningke atnyenetyenhe, pweleke areyele-arlke, yepe-yepe areyele-arlke, ngkwinhele nanikute areyele-arlke, ingkirrekele akwerrke atningke atnyenetyenhe. ");
INSERT INTO aer_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Ayeye nhenhe-arle the alyeme, ngkwinhe-arle aneme. Ayeye atyinhe-arle apwerte akngerrenge lterrke-ulkere, arrule-arle anetyame-arteke. Arne atningke unte-arle inetyenhe itne apwerte areye artetyenhenge. Arrule anthurre Ngkartele ngenhe akalkelhe-ileke kake ngkwinhe areye-ngentyele imerte ngenhe itneke akngerrepate arrernemele. Ayeye nhenhele-arle ngenhe lterrke-arle-iletyenhe, ngenhe lterrke atnyenemele.” ");
INSERT INTO aer_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Kele Jacob-ele Benjamin alyeke, “Benjamin, unte-arle akngwelye artnwere angayakwe-arteke-arle. Kereke ingweleme untherle-apemele. Itnenhe atwemele alterremele imerte arlkwemele. Ingwele re kere awethe atweme, imerte akngwelye akweke ikwerenhe areyeke akngetye-alpemele.” ");
INSERT INTO aer_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Jacob-ele alyelhentye akngerre 12-pele alyeke alere 12-pele ikwerenheke, apurteke 12-pele Israel-arenye. Re itelareke iwenhe-arteke-arle itne anerrirrekenge akurne apeke, mwerre apeke, atwerrentye akngerre apeke. Alakenhenge-arle re itelareke ayeye alyetyeke itneke-arrpe. ");
INSERT INTO aer_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","32","Jacob ikwere alere areyeke angkeke, “Ayenge-arle ilwetyeke anteme-arle areme. Ayenge ilwemele, ayenge nhenhe Egypt-eke iperteke artetyale. Ayenge akngirtnaye inteye Ephron Hittite areyenge nhenge-kenhe-werne. Inteye re Machpelah-ele Mamre-nge ikngerre Canaan-ele. Inteye yanhe renhe-arle Abraham-ele manele ineke Ephron-enge. Yanheke-arle itne atyenge-artweye areye iperteke arteke. Inteye yanhe ikwere itne arrenge-arrenge atyinhe Abraham arteke anewe ikwerenhe Sarah uthene. Akngeye atyinhe Isaac anewe ikwerenhe Rebekah, meye atyinhe, anewe atyinhe Leah-arlke-arle ingkirreke yanheke iperteke arteke. Ayenge-arlke ikwere iperteke artetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Nhenge Jacob-arle alere ikwerenhe areyeke alakenhe angkekenge, re antyameke iwelheke. Re iwelhemele, re aheye angketyakenhe aneke, re imerte ilwemele anteme. ");
INSERT INTO aer_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Nhenge Jacob-arle ilwekenge anteme, Joseph ikwere akertneke iwelhemele re arrwantyeke. Re akngeye ikwerenheke artnetyame anteme. ");
INSERT INTO aer_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","3","Apmere Egypt ikwerele, ngangkerele anterele apernetyarte tyerrtye atyalangke areye arlte 40-peleke-atwetye urreke artetyenhenge. Imerte manterele ayernemele tyerrtye arnterte-irreme-ketyenge. Kele, Joseph ngangkere itneke angkeke, “Atyalangke akngeye atyinhe-kenhe akngaye, imerte iperteke artemele.” Kele, artwe itne atyalangke Jacob-kenhe akngeke. Arlte 40 peleke-atwetye imerte anterele apernerlte-anemele, manterele ayernemele, arnterte ntyeme-ketye. Itne renhe iperteke arteke. Tyerrtye Egypt-arenye areye artnerrirreke akngeye Joseph-kenheke irrare aneke arlte 70 peleke-atwetye. ");
INSERT INTO aer_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Yanhe-ngentyele, Joseph alhemele angkeke urrkapentye akngerre Pharaoh-kenhe areyeke, “Arrantherre apeke atyenge ahentye-aneme, Pharaoh iletyeke alhaye, ");
INSERT INTO aer_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Akngeye atyinhe-arle itethe anekenge, the renhe alhileke tharle renhe Canaan-werne akngirtnetyeke. The renhe ileke tharle renhe inteye ikwere-arrpe artekenge ikwere-werne. Ayenge alheye, the akngeye atyinhe arterle-alpetyenhenge. Yanhe-ngentyele apetye-anteme-alpetyenhenge.’” ");
INSERT INTO aer_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Pharaoh-ele ayeye yernintye-alpeke Joseph-eke ilemele, “Mwerre-arle alakenhe. Mpwaraye unte-arle alhileke-arteke. Kele alhaye akngeye ngkwinhe apmere ikwerenheke artetyeke.” ");
INSERT INTO aer_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","9","Tyerrtye atningke alherlte-iweke Joseph-enge akngeye ikwerenhe artetyeke. Urrkapentye akngerre Pharaoh-kenhe areye-arlke alherlte-iweke, akngerrepate arrpenhe Egypt-arenye areye-arlke Joseph-enge alherlte-iweke. Arrpenhe areye nanthe itnekenhenge-arlke alherlte-iweke, arrpenhe areye wagon-akerte itnekenhenge-arlke alherlte-iweke. Joseph-kenheke-artweye areye, kake ikwerenhe areye-arlke, tyerrtye akngeye ikwerenhenge-arle areke areye-arlke, alherlte-iweke Canaan-werne. Itne ampe itnekenhe iwerlte-alheke, yepe-yepe areye-arlke, nanikute areye-arlke, pweleke areye-arlke Goshen-eke. ");
INSERT INTO aer_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Itne Canaan-eke-irremele, itne apmere Atad arritnye-werne alheke, lhere Jordan-enge ikngerrele. Apmere nhenge itne merne annge areye arneke-arleke arrernemele imernte anthelke uthene renhe uthene akngakemele. Joseph aneke arlte 7-peleke-atwetye tyerrtye itnekenge. Ikwerele ureke, tyerrtye areye arnterre anthurre artnerrirreke Jacob-eke, Joseph akenhe irrare-irrare anthurre-arle artneke, re anteme urnteke anteme alyelhemele. ");
INSERT INTO aer_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tyerrtye atningke areye Canaan-arenyele arerrirreke Egypt-arenye areye apmere irrareke apmere Atad-eke, itne imerte angkerremele, “Egypt-arenye yanhe areye kwenhe irrare anthurre awelheme, itne-arle arrpenhe nhenge aparlpe-ilekenge.” Alakenhenge anteme apmere re arritnye “Abel-Mizraim” Canaan-arenyeke angkentyenge ileme, “Egypt-arenye areye anerrirreme alhwarrpe-irremele.” ");
INSERT INTO aer_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Ikwere-iperrele, alere Jacob-kenhe areyele renhe iperteke arterrirreke, alakenhe-arle re arrwekele itneke ilekenge. Renhe inteyeke atheneke, apmere Machpelah-ele arritnye aneke. Ahelhe nhenhe Abraham-elarle ineke artwe Ephron-enge, rarle Hittite anekeke. Abraham ahelhe yanhe ineke rarle ikwere-artweye areye artetyeke. ");
INSERT INTO aer_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Itne ahelhe irrare-werne-irreke-arle iperrenge, Joseph arrpenhe areye-arlke ingkirreke apmere Egypt-werne alperlte-iweke. ");
INSERT INTO aer_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Kake Joseph-kenhe areye angkerreke, “Anwerne kwenhe akngeyeke arrangkwe anteme. Joseph apeke-arle anwerneke ahele akwete-arle. Re apeke-arle anwernenhe atwetyenhe anwerne-arle ikwere akurne mpwarekenge arrule, nhenge renhe-arle anwerne yerneke ayernentye akngerre-arteke Egypt-werne. Nthakenhe-ame anwerne irretyenhe?” ");
INSERT INTO aer_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Itne ayeye yerneke Joseph-werne, ikwere alakenhe angkeke, “Urreke akngeye anwerne-kenhe ilwetyenhenge, re anwerneke angkeke, ");
INSERT INTO aer_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Arrantherre-arle akurne anthurre areye-arle! Arrantherre-arle Joseph-eke ahentye-anetyakenhe-arle aneke, arrantherre imerte renhe atwemele. Joseph ilaye arrenhantherrenhe ipmentyele impetyeke ilpernetyakenhe anetyeke.’ Alakenhe-arle akngeye anwerne-kenhe angkeke. Anwerne ngkwenge arnterre angkeme anwernenhe unte impetyeke akurne anwerne-kenheke alkngwirretyeke, anwernenhe ilpernetyakenhe aneme. Anwerne-arle Ngkarte anyente renhe-arle apententye akngerre akngeye anwerne-kenhele-arle apentewarretyartenge.” Joseph-ele itnenhe awemele re artneke. ");
INSERT INTO aer_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Kake Joseph-kenhe areye apetyewarreke ikwere kwene-irreremele. Itne ikwere angkeke, “Anwerne kwenhe ngkwinhe anteme. Anwerne-arle ngkwenge urrkapetyenhe-arle ayernentye akngerre areye-arteke.” ");
INSERT INTO aer_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Joseph itneke angkeke, “Arrangkwe, atyengenge atere-irrerirretyalaye! Ayenge apele Ngkarte anetyakenhe-arle! Tharle arrenhantherrenhe atwetyeke arrangkwe-arle! ");
INSERT INTO aer_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Arrule anthurre, arrantherre ayenge atwetyeke ahentye-aneke, kele Ngkartele akngarte-iweke imerte mwerre mpwaremele. Rarle ayenge atnyeneke tyerrtye areyeke mwerre anetyeke itnenhe arntarnte-aremele, itne-arle angayele ilwetyeke-arle aneke, kele arrangkwe-arle. Unte ayenge atwetyeke ahentye-aneke, kenhe Ngkartele akenhe ayenge mwerre-ileke, re ayenge akngakemele tyerrtye atningkeke mwerre anetyeke-arle itnenhe itethe atnyenetyeke. ");
INSERT INTO aer_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Alakenhenge anteme the arrenhantherrenhe ileme, atyengenge atere-irrerirretyale!” Kele Joseph angkentye mwerre itneke angkeke, “The arrenhantherrenhe arntarnte-areme ampe arrekantherrenhe areye-arlke.” Nhenge kake Joseph-kenhe areyele awerrirremele re alakenhe angkerlenge itne mwerre awelheke, itirrewarretyakenhe-arlke. ");
INSERT INTO aer_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","26","Joseph akngeye ikwere-artweye areye-arlke apmere Egypt-ele anetyarte arrule anthurreke-atwetye, re anteme ampwe anthurre irreke. Ikwere alere Ephraim-ele ampe areye atnyeneke arrenge-arrenge ikwerenhe areye-arlke. Alere Joseph-kenhe Manasseh-ele alere-akerte, Makir arritnye aneke. Makir-ele ampe atningke atnyeneke. Kenhe Joseph ampe ikwerenhe areye altye-ileke. Urreke re ilwetyenhenge, Joseph kake ikwerenhe areyeke angkeke, “Ayenge kwenhe ilwetyeke-urletye anteme. Ngkartele-arle arrenhantherrenhe akwetethe-arle arntarnte-arerle-anetyenhe. Urreke anteme Ngkarte apetyemele arrekantherre-artweye areye-akerte arratelhe-iletyenhe Egypt-ngentyele, arrenhantherrenhe apmere Canaan-werne arrwekelhe-ileme rarle alhileke Abraham-eke, Isaac-eke Jacob-eke-arlke. Atyenge alhilelherrirraye arrantherre-arle atyalangke atyinhe arrekantherrenge akngirtnetyeke Canaan-werne ayenge ilwerlenge.” Yanhe-ngentyele, Joseph ilweke, re year 110-pele aneke. Apmere Egypt-ele, ngangkere areyele tyerrtye atyalangke anterele aperneke, itne renhe manterele imarteye-iwemele renhe arne kweneke arrerneke. Alakenhe-arle ayeye Joseph-akerte uyerreme. ");
INSERT INTO aer_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","5","Artwe ampwe nhenge Jacob, arritnye arrpenhe ikwerenhe aneke Israel. Nhenge re Canaan-engentyele impemele apmere Egypt-werne alhetyeke re alerikwe areye akngeke itne-kenheke-artweye areye-arlke, itnenhe ingkirreke 70 anteme. Nhenhe alerikwe arritnye areye-kenhe aneme: Reuben, Simeon, Levi, Judah, Issachar, Zebulun, Benjamin, Dan, Naphtali, Gad, Asher uthene. Kenhe alerikwe arrpenhe akenhe Joseph, re Egypt-nge kele-arle aneke, re apmere yanhe ikwerele ahinpe-ngentyele anetyarte. ");
INSERT INTO aer_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Joseph apmere Egypt-nge uyerreke. Alerikwe areye-arlke itne-kenheke-artweye areye-arlke, Jacob-enge-arle apmere Egypt-werne apetyewarrekeke, itne ingkirreke anthurre uyerreke anteye. Itnekenhe kartweyekartweye apmere Egypt-nge arlenge-ulkere anetyarte uterne 400-eke-atwetye. ");
INSERT INTO aer_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Tyerrtye Israel-arenye areye atningke-ame-atningke anthurre irreke. Itne lterrke anthurre irreke, ikwere-ipenhe atningke arrpenhe apmere arrpe-anenhele Egypt-nge anerrirreke. ");
INSERT INTO aer_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Arrule ikwerenge-ntyele artwe arrpenhe anteme Pharaoh aneke Egypt-arenye areyeke. Re ayeye Joseph-akerteke akutne aneke arrule anthurre-arle anetyarteke. ");
INSERT INTO aer_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Arlte anyentele re akngerrepate government-kenhe areyeke angkeke, “Ayekaye, Israel-arenye areye arerrirraye! Itne kwenhe atningke anthurre, lterrke anthurre irrerlenge! Itne kwenhe anwernekenge lterrke anthurre ulkere! Itne apeke anwernenhe irrerlknge atweme-ketye! ");
INSERT INTO aer_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Tyerrtye apmere arrpenhe-arenye areye apeke nhenhe-werne apetyeme anwernenhe atwerrerlenge-artaye? Nthakenhe-ame anwerne irretyenhe? Tyerrtye Israel-arenye areye apeke itnekenge apurte-irreketyenge, itne anteme apeke anwernekenge atwerreme anwernenhe irrerlknge atweme anteye! Itne apmere arrpenhe-werne anteme alwirreme! Nthakenhe-ame anwerne itnenhe atningke-irreketyenge ayakeye?” ");
INSERT INTO aer_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Arratye-arle, Pharaoh uthene akngerrepate government-kenhe uthene areyele Israel-arenye areye warrke-irretyeke uternetyarte ayernentye akngerre areye-arteke. Itne artwe areye akngakeke Israel-arenye areye arnterre anthurre warrke-irretyeke uternetyeke itne apurrke-irretyenhenge atwerretyeke itirretyakenhe anetyenhenge. Itne itnenhe uterneke tantyipe akngerre atherre Pharaoh-eke artetyeke apmere Pithom uthene apmere Rameses uthene. Kele imernte Egypt-arenye areyele arne ingkirreke antelhe-iletyarte tantyipe nhenhe atherreke arrernemele. ");
INSERT INTO aer_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Yewe, itne Israel-arenye areye akwetethe anthurre warrke-irretyeke uternetyarte. Itne itnenhe atwetyarte rlkerte-iletyarte, itne itnenhene ayene-iletyarte ampe akweke awethe atnyeneme-ketye, arrangkwe-arle akenhe. Israel-arenye areyele akwetethe anthurre ampe atningke atnyenewarretyarte. Itne atningke-ame-atningke-irreke irrarnpe-irreremele Egypt ikwerenge. Alakenhe ikwerenge anteme Egypt-arenye areye itne-ketyenge atere-irrereke. ");
INSERT INTO aer_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Itne Israel-arenye areye atwemele itnenhe akwete anthurre warrke-irretyeke uternetyame Israel-arenye areyeke akurne anthurre anteme irrerlenge. ");
INSERT INTO aer_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Itne itnenhe apmere brick areyele artetyeke uternetyame. Israel-arenye areyele ahelhe urrknge uthene atherrke uthene anyente-iletyeke brick areye mpwaretyeke anteye apmere artetyeke. Itne kwenhe uternetyarte ahelhe atyete-ilemele tnyetyeke arne ngkernetyenhenge, annge ntange areye lyapetyeke. Egypt-arenye areye itneke alhwarrpe awelhetyakenhe aneke nhenge itne arnterre anthurre warrke-irretyartenge. ");
INSERT INTO aer_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Yanhele aneke arelhe Hebrew atherre apmere yanhe ikwerele arelhe arrpenhe areye-arle mwerre-ilemeke nhenge itne ampe akweke mwerre mpwaretyenhenge. Arritnye ikwere-atherrenhe aneke Shiphrah uthene Puah uthene. Urreke arelhe Israel-arenye areyele ampe akweke atnyenetyenhenge arelhe nhenhe atherre arelhe atnerte-atnerte areyenge anerle-anerretyarte. Arlte anyentele Pharaoh angkeke arelhe nhenhe atherreke, ");
INSERT INTO aer_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Mpwele apeke arelhe Hebrew areyenge aneme, nhenge itne ampe akweke itnekenhe atnyenemenge, kele itne apeke marle atnyeneme renhe impe, irrerlknge atwetyale. Itne akenhe ampe urreye akweke apeke atnyeneme, urreye yanhe areye irrerlknge atwe!” ");
INSERT INTO aer_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Kenhe arelhe yanhe atherrele akenhe Pharaoh awetyakenhele aneke ratherre-arle Ngkarte apentemele, Renhe-ante ware mwantyele awetyartele. Kele ratherre anteme urreye akweke areye irrerlknge atwetyakenhe aneke nhenge itne akweke interlenge. ");
INSERT INTO aer_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Kele imerte Pharaoh-ele anteme warrkene ikwerenhe anyente yerneke arelhe yanhe atherreke antangketyeke. Nhenge ratherre apmere Pharaoh-kenhe-werne apetyemele, rarle ikwere-atherre apayuthnekenge, “Iwenhenge-ame mpwele ayenge awetyakenhe aneke? The kwenhe mpwelenhe ileke ampe urreye akweke irrerlknge atwetyeke. Kenhe mpwele akenhe itnenhe itethe-arle atnyenerlenge.” ");
INSERT INTO aer_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Arelhe yanhe atherramele renhe ileke, “Arelhe Israel-arenye areye kwenhe rlterrke anthurre-arle, arelhe Egypt-arenye areye-arteke anetyakenhe. Itne ampe areye iparrpele atnyeneme. Urreke itne ampe akweke atnyenetyenhenge, itne ilernenhe apetyetyeke ileke itnekenge anetyeke. Kenhe itne akenhe ampe iparrpele atnyeneme ilerne yanhe ikwerele anetyakenhele!” ");
INSERT INTO aer_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","21","Yewe, arelhe yanhe atherrele Ngkarte arratye awerle-anerretyarte. Alakenhe ikwerenge anteme Ngkartele arelhe yanhe atherre ampe atningke antheke. Kenhe akwete, arelhe Hebrew areyele akwetethe anthurre ampe atningke awethe atnyeneke. ");
INSERT INTO aer_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Ikwerenge-ntyele anteme, Pharaoh tyerrtye ikwerenhe areyeke angkeke, “Ayenge awerrirraye! Nhenge arelhe Hebrew areyele ampe urreye akweke atnyenemele, itnenhe inaye lhere akngerre Nile-ke-arleke iwerrirraye kwatye urewele itnenhe akngetyeke alhekwarle-iletyeke. Marle akweke areye impaye, irrerlknge atwetyale!” ");
INSERT INTO aer_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Nhenhe ikwerele ureke, artwe Hebrew anyente Levi-kenhe areye-ngentyele aneke. Re marle anewe akeke anyenhenge ikwerenhe-ngentyele. ");
INSERT INTO aer_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","Ikwerenge-ntyele re anteme akngerre-apenhe-irreke, ampe urreye akweke atnyenemele anteme. Re kwenhe mwerre akngerre anthurre aneke, mikwele renhe apmere kweneke alengke-iwetyarte Egypt-arenye areye-ketye itne apeke renhe irrerlknge atweme-ketyenge. ");
INSERT INTO aer_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Atnyentye urrpetye iperrele anteme, mikwe apaleke-arle-irreke ampe akngerre-werne apmere kweneke alengke-iwetyeke. Mikwele anteme arne akweke pmware-arteke ineke ikwere-arleke ankere arrernemele nhenge kwatye akertnele anteye intepintetyenhenge, kwatyeke irrpeme-ketye. Re urreye akweke renhe pmware kweneke-arleke akwerneke, re anteme renhe kwatye urewe ikwere-werne akngeke kwatye pintyarre angketyarre nhenge-werne. Re renhe kwatyeke-arleke arrerneke kwatye pintyarre angketyarre mpwepe-mpwepeke tyerrtye areyele renhe areme-ketye. ");
INSERT INTO aer_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Yaye akngerre urreye akweke-kenhele antengeke-irretyame. Re mikwe arerle-anetyame nhenge re pmware kwatyeke-arleke arrernerlenge. Re-arrpe anteme itirreke, “Nthakenhe-arle-irretyenhe apeke atyenge atyeyeke?” ");
INSERT INTO aer_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Ikwere ipenhe, marle wenke Pharaoh-kenhe anteme kwatye urewe-werne alhewelhetyeke apetyetyame. Re lhere iterele alhepalhemele arelhe warrkene ikwerenhe areye-akerte kwatye pintyarre angketyarre itwele. Nhenge re alhepalhemele pmware yanhe areke kwatye akertnele intepinterlenge, re warrkene anyente ikwerenhe renhe inetyeke ileke ikwere. ");
INSERT INTO aer_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Re renhe inemele marle wenke Pharaoh-kenhe-werne akngetyeke. Nhenge re renhe altywere-ilemele, re ampe urreye akweke kweneke areke. Re artnetyamenge, re ikwere atnerte alhwarrpe awelheke. Re arelhe warrkene ikwerenhe ileke, “Araye! Ampe akweke nhenhe kwenhe tyerrtye Hebrew areye-ngentyele!” ");
INSERT INTO aer_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Yaye akngerre ampe urreye akweke ikwerenhe anteme apetyemele apayuthneke, “Wertaye? Unte-ame ayenge alhetyeke arelhe Hebrew-eke antangketyeke re nhenge ampe akweke yanhe ngkwenge arntarnte-aretyeke?” ");
INSERT INTO aer_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Marle awenke Pharaoh-kenhe anteme angkeke, “Yewe, mwerre anthurre! Renhe inetyeke alhaye!” Marle re alhemele meye ampe akweke-kenhe ineke renhe kwatye urewe-werne akngetyeke. ");
INSERT INTO aer_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Marle awenke Pharaoh-kenhe anteme ikwere angkeke, “Ampe akweke nhenhe akngaye, renhe werlatye anthaye atyenge. The ngenhe ikwere apwerte ngkweltye anthetyenhenge.” Re ampe akweke renhe apmere-werne akngirtneke arratye, renhe werlatye antheke. Re renhe amangkelhe-ileke uterne atherreke apeke, urrpetyeke apeke. ");
INSERT INTO aer_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Ikwere ipenhele nhenge urreye akweke re merne uthene kere utheneke akaltye-irreke arlkwetyeke anteme, mikwe re renhe marle wenke Pharaoh-kenhe-werne akngirtneke, ikwere anthirtnemele. Re ikwere altye-irreke ampe urreye ikwerenhe-arrpe-arteke anetyeke, renhe Moses arritnye antheke. Arritnye yanhe ileme, “The renhe kwatye-ngentyele arratelhe-ileke.” ");
INSERT INTO aer_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Uterne arrpe-anenhe-ngentyele Moses amangkeke, re artwe anteme aneke, Re akngerrepate atyeperre anteme irreke apmere Egypt-nge. Arlte anyentele re apmere-werne alheke Hebrew apmere-altye areyele warrke-irretyamenge. Re Egypt-arenye areye areke itnenhe warrke-irretyeke uternerlte-anerlenge. Artwe Egypt-arenye anyentele warrkene Hebrew anyente atwetyame. ");
INSERT INTO aer_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Moses-ele arekeke-amparre nhenge tyerrtye arrpenhe apeke yanhe ikwerele anekenge. Arrangkwe, re tyerrtye arrpenhe aretyakenhe aneke. Kele imerte re Egypt-arenye renhe irrerlknge atweke. Re iparrpe iperte atnyemele renhe arteke. Re imerte apmere-werne alpemele. ");
INSERT INTO aer_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Arlte arrpenhele anteme Moses apmere re-ante ikwere-werne alpeke anteme. Re artwe Hebrew atherre areke ahele angkerretyamenge. Nhenge anyentele anteme arrpenhe atweke, Moses anteme renhe ileke artwe yanhe arrpenhe renhe-arle atwekeke, “Aye! Iwenhenge-ame unte artwe nhenhe atwerne? Mpwele kwenhe Hebrew atherrame anerle-anerreme!” ");
INSERT INTO aer_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Artwele anteme tyerneke, “Angwenhele-ame ngenhe akngakeke unte akwele akngerrepate-arteke aneme ilernenhe atwerreme-ketye ayaketyeke? Unte-ame ayenge irrerlknge atwetyenhe unte artwe nhenge Egypt-arenye irrerlknge atweke-arteke?” Nhenge Moses-ele yanhe awemele, re atere anthurre irreke ikwere-arrpe angkemele, “Ayekeye! Tyerrtye atningke apeke kwenhe akaltye aneme nhengeke the artwe nhenge irrerlknge atweke.” Re Egypt-ngentyele uyerremele unteke arlenge anthurre-werne alhemele. ");
INSERT INTO aer_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Nhenge Pharaoh-ele awemele Moses-elarle artwe Egypt-arenye irrerlknge atwekenge, re atwerrentye akngerre ikwerenhe areye ileke Moses-eke unthetyeke alhetyeke renhe irrerlknge atwetyeke. Kenhe arrangkwe-arle. Itne ikwere uyarne untheke. Re Egypt-ngentyele kele alwirremele unteke. Re apmere Midian-werne atheke unthemele alhetyame. Ikwere irretye-alhemele re kwatye ngentye itwele anetye-alheke. ");
INSERT INTO aer_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Apmere yanhe ikwere Midian-ele artwe Jethro arritnye aneke. Reuel arritnye arrpenhe ikwerenhe aneke. Re kwertengerle tyatye-arenye aneke, re ampe marle seven atnyeneke. Itne yepe-yepe areye arntarnte-aretyarte, itne yepe-yepe itnekenhe areye kwatye ngentye-werne antywetyeke akngetyarte. Arlte anyentele, nhenge itne kwatye inetyeke apetyeke itne kwatye uyarne anthurre theleme urtne akngerreke-arteke yepe-yepe areyeke. ");
INSERT INTO aer_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Kenhe yepe-yepe arntarnte-arentye akngerre arrpenhe areye apetyemele marle itnenhe aywepemele kwatye-ketye ilpetye-alheke. Nhenge Moses-ele itnenhe aremele re yepe-yepe arntarnte-arentye akngerre arrpenhe areye aywepeke, kwatye inemele anteme yepe-yepe marle-kenhe areyeke. ");
INSERT INTO aer_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Marle yanhe areye apmere-werne anteme alperlte-iweke Jethro akngeye itnekenhe-werne. Kenhe re akenhe itnenhe apayuthneke, “Iwenhe-aperte? Iwenhenge-arle-ame arrantherre iparrpe apetyerre-alperne? Uterne kwene-irretyakenhe akwete. Ayenge itirreme arrantherre yepe-yepe kwatye anthetyemeke-athene kwatye ngentyele.” ");
INSERT INTO aer_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Marle itne renhe tyernirtneke, “Yepe-yepe arntarnte-arentye akngerre arrpenhe areyele anwerne-ketye iwerre ilperne kwatye ngentye ikwerenge. Egypt-arenye anyentele anteme itnenhe ayweperne. Re anteme yepe-yepe anwerne-kenhe kwatye antheke.” ");
INSERT INTO aer_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Re itnenhe apayuthneke, “Artwe re anteme nthenhe? Iwenhenge-arle-ame arrantherre renhe ingkerneke imperlte-alherne? Renhe inetyeke alhaye re anteme anwernekenge arlkwetyenhenge.” Ikwere-ipenhele itne Moses inetyeke alheke. ");
INSERT INTO aer_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Nhenge Moses apmere Jethro-kenheke irreke, itne renhe ikngwerlenge, Moses anteme itnekenge anerle-anekenge. Urreke Jethro-le Moses marle ikwerenhe Zipporah antheke anewarte anetyeke. ");
INSERT INTO aer_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Ikwere-ipenhele anteme, Zipporah-ele urreye akweke atnyeneke. Moses renhe Gershom arritnye antheke. Moses re-arrpe angkeke, “Ayenge kwenhe apmere nhenhele ipenye aneme. Alakenhe ikwerenge anteme the alere atyinhe Gershom arritnye antheke.” Gershom arritnye ileme “Tyerrtye apmere arrpenhe-arenye.” ");
INSERT INTO aer_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Uterne urrpetye-iperre anteme Pharaoh re ilweke. Egypt-arenye areyele akenhe Hebrew areye warrke-irretyeke akwete anthurre uternetyame itnenhe rlkerte-anthurre-iletyame atwemele-arlke. Kenhe Hebrew areye akenhe artnemele anthurre Ngkarteke inketyamele itnenhe itetheke mpwaretyeke Egypt-arenye areye-ketye. ");
INSERT INTO aer_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Nhenge Ngkartele itnenhe artnerlenge aweke, Re arrekwelenye itnekenhe areyeke itirreke, Abraham, Isaac, Jacob utheneke. Arrule anthurre Re itnenhe alhileke-arle nhenge Re itnenhe arntarnte-aretyenhe itne-kenheke artweye areye-arlke. ");
INSERT INTO aer_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Yewe, Ngkartele areke tyerrtye areye Israel-arenye ayernentye akngerre areye-arteke warrke-irrerlenge Egypt-nge, Re itneke alhwarrpe anthurre awelherlenge. ");
INSERT INTO aer_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Moses-ele yepe-yepe areye arntarnte-aretyarte arnteweye ikwerenheke. Itelareme, Jethro-arle kwertengerle tyatye-arenye apmere Midian ikwerele. Arlte anyentele, Moses-ele yepe-yepe uthene nanikute areye uthene ahelhe arrangkethele arrekwele-irretyame nhenge itne anteme apwerte ameke-ameke akngerreke itwe ulkere-anteme-irreke apwerte Sinai arritnye. ");
INSERT INTO aer_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Yanhe ikwerenge alkere-arenye YAHWEH-kenhe arrateke, arne akwekeke tnemele Moses-eke imernelhemele. Arne akweke yanhe arlpelhe akngerre-akerte ure alkngenthe-ante aneke. Moses apateke anthurre nhenge re renhe aremele ure alkngenthe-ante anerlenge, re akenhe ampetyakenhe aneke uyerremele, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Moses re-arrpe angkeke, “Ayenge apatemele anthurre! Arne nhenhe re kwenhe akwete ampeme, atherrke-atherrke akenhe akwete anemele. The itwenge-ulkerenge aretyeke alheme nthakenhe-arle irrerlenge!” ");
INSERT INTO aer_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Nhenge arne mpwepele ampetyamele, mpwepe anthurre ikwerenge-ntyele Ngkartele Moses apetyerlenge areke. Re ikwere arlkeke, “Moses, Moses!” Moses ikwere angkirtnerlenge, “Nhenheyaye ayenge.” ");
INSERT INTO aer_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Kele Ngkarte anteme ikwere angkeke, “Itwe-werne awethe apetyetyalaye, yanhe ikwerele ane! Ingke-kenhe irlwaye unte-arle tneme yanhe anthurre kwenhe apmere ameke-ameke aneme. ");
INSERT INTO aer_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Ayenge kwenhe arrekwelenye ngkwinhe areyeke Ngkarte aneme, Ngkarte aneke Abraham-eke, Isaac-eke, Jacob utheneke, arrekwelenye ngkwinhe areye arrule anthurre-arle anerrirretyarteke.” Nhenge Moses-ele nhenhe renhe awemele re inngerre manterele artelheke rarle atere anthurre awelheke Ngkarte areme-ketye. ");
INSERT INTO aer_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","YAHWEH anteme Moses-eke angkeke, “The kwenhe Egypt-arenye areye areme nhenge itne tyerrtye Atyinhe areye atwerlenge itnenhe arnterre anthurre warrke-irretyeke uterneme. The itnenhe aweme atyenge artnerlenge The itnenhe nhenge itetheke mpwaretyeke. The kwenhe itelareme itne-arle uyarne anthurre itirremenge. ");
INSERT INTO aer_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Alakenhe ikwerenge anteme Ayenge alkere akertne-ngentyele apetyeke. Ayenge apetyeke itnenhe ingkirreke anthurre itetheke mpwaretyeke itnenhe Egypt-arenye areye-ketyenge akngetyeke. The itnenhe Egypt-ngentyele arratelhe-iletyeke, itnekenge arrekwele-irremele apmere mwerre anthurre-werne akngetyeke merne arunthe anthurre-akerte-werne. The itnenhe apmere arrpenhe areye-arle anerlte-aneme-werne akngetyenhe: Canaanite areye, Hittite areye, Amorite areye, Perizzite areye, Hivite areye, Jebusite areye-arlke. ");
INSERT INTO aer_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Awerrirraye, The kwenhe Atyinhe areye artnerlenge aweke. The itelareme Egypt-arenye areyele itnenhe warrke-irretyeke uterneme ayernentye akngerre areye-arteke. ");
INSERT INTO aer_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Alakenhe ikwerenge anteme The ngenhe Pharaoh-werne yerneme unte nhenge tyerrtye Atyinhe areye apmere Egypt-ngentyele arratelhe-iletyenhenge apmere arrpenhe-werne akngemele. Iparrpe alhaye! Itnenhe inetyeke alhaye unte-arle itnekenge Egypt-ngentyele arrekwele-irretyenhenge!” ");
INSERT INTO aer_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Kenhe Moses Ngkarteke angkerlenge, “Ayenge akngerre anetyakenhe! Pharaoh-ele ayenge awetyakenhele anetyenhe! Nthakenhe-arle-ame the tyerrtye Israel-arenye areye Egypt-ngentyele arratelhe-iletyenhe? The alakenhe uyarne anthurre mpwareme!” ");
INSERT INTO aer_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Kenhe Ngkarte akenhe ikwere angkerlenge, “Ayenge ngkwengenge Egypt-werne alhetyenhe. Nhenge unte Atyinhe areye yanhe-ngentyele arratelhe-ilerlenge itnenhe apwerte akngerre nhenhe-werne akngetyaye nhenge itne Ayenge utyernemele tnaketyenhenge. Alakenhe ikwerenge tyerrtye areyele itelaretyenhenge Tharle ngenhe yerneke.” ");
INSERT INTO aer_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Kele Moses Ngkarteke angkirtneke, “Kweye? Ayenge apeke itneke-werne alheme alakenhe angkemele, ‘Ngkarte, akngeye anwerne-kenhe areyele-arle arrule anthurre apentetyarteke, Re ayenge nhenhe-werne yerneke,’ itne apeke ayenge arratye itelaretyakenhe. Itne ayenge alakenhe apayuthnemele, ‘Iwenhe-ame arritnye Ikwerenhe, iwenhe-arteke-ame Re?’ Alakenhe renhe itne atyenge angketyenhenge. Nthakenhe-ame ayenge itneke angketyenhe? Atyenge ilaye, iwenhe-ame arritnye Ngkwinhe?” ");
INSERT INTO aer_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Ngkarte anteme ikwere angkeke, “AYENGE AKWETE-ANTE ANEME. Arritnye atyinhe aneme YAHWEH. Tyerrtye yanhe ilaye YAHWEH-ele ngenhe yerneke. ");
INSERT INTO aer_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","16","Itnenhe ilaye ayenge Ngkarte anyente re aneme arrekwelenye arrekantherrenhe areyele-arle apentetyarteke, Abraham, Isaac, Jacob uthenele. Itnenhe ilaye The ngenhe yerneme itnenhe Egypt-ngentyele arratelhe-iletyeke. YAHWEH arritnye Atyinhe akwete-ante anetyenhe. Lyete-ngentyele itne Ayenge YAHWEH aketyeke. Artwe ampwe akngerrepate Israel-arenye areye inetyeke alhaye. Itnenhe ilaye Ayenge-arle ngkwenge imernelheke, iwenhe Ayenge ngkwenge angkerne. Itneke ilaye The areke-arle Egypt-arenye areyele itnenhe arnterre warrke-irretyeke uternerlenge itnenhe atwemele-arlke. ");
INSERT INTO aer_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Ayenge-arrpe anteme angkeke, The Atyinhe areye Egypt-ngentyele arratelhe-ilemele akngetyetyenhe itne-arle itnenhe atwemenge itnenhe akurne anthurre ilemenge. Ayenge itnekenge arrekwele-irretyenhe apmere mwerre anthurre-werne akngetyenhele merne akngerre-arle aneme-werne. Lyete tyerrtye arrpenhe areye yanhe ikwerele apmereke-artweye aneme, Canaanite areye, Hittite areye, Amorite areye, Perizzite areye, Hivite areye Jebusite areye uthene. The apmere ahelhe itnekenhe raketyenhe tyerrtye Atyinhe areye anthetyenhenge!” ");
INSERT INTO aer_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","Ngkarte anteme Moses-eke angkeke, “Unte apeke ayeye nhenhe tyerrtye Atyinhe areyeke ileme, itne anteme ngenhe aweme. Ikwere-ipenhele unte uthene artwe ampwe akngerrepate Israel-arenye uthene, Pharaoh-werne alherlte-iwaye, ikwere alakenhe angkaye, ‘Anwerne Hebrew areyele Ngkarte apenteme, YAHWEH arritnye Ikwerenhe aneme. Re anwerneke imernelheke. Anwerne apmere arrangkethe-werne alhetyeke arlte urrpetyeke, yanhe ikwerenge anteme anwerne YAHWEH-eke kere iteme. Anwerne Renhe yanhe ikwerele tnaketyenhe. Mwerre-ame anwerne yanhe ikwere-werne alhetyeke?’ Alakenhe unte artwe ampwe akngerrepate yanhe areye-arlke Pharaoh-eke angketyeke. ");
INSERT INTO aer_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Kenhe Pharaoh-ele ngenhe awetyakenhe anetyenhe. Re arrenhantherrenhe mwerntelhe-iletyenhe arrantherre ahelhe arrangkethe ikwere-werne alheme-ketye. Alakenhe irreketyenge anteme, The renhe uterneme ngenhe awetyeke. ");
INSERT INTO aer_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Utnenge Akngerre Atyinhele The renhe uternetyenhe arrenhantherrenhe ipmentye impetyeke. The Egypt-arenye yanhe areye rlkerte-iletyenhe atwemele anteye itne Atyenge-ketye atere anthurre irretyenhenge. Ikwere-ipenhele Pharaoh-ele anteme arrenhantherrenhe Egypt-ngentyele yernetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Yewe, Egypt-arenye areye arrekantherre-ketyenge, Israel-arenye areye-ketyenge atere anthurre awelhetyenhe. Alakenhe ikwerenge anteme nhenge arrantherre Egypt impemele alhemele, arrantherre iltye-ante impemele alhetyakenhe anetyenhe. Itne arrenhantherrenhe arne atningke anthurre anthetyenhe itne-arle arrekantherrenge atere awelhemenge. ");
INSERT INTO aer_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Urreke arrantherre Egypt impemele alhetyenhenge, arelhe Israel-arenye areyele arelhe Egypt-arenye areye apayuthnetyenhe itneke-arle itwele anekeke apeke itneke-arle warrke-irretyarte apmere itnekenhenge. Itne itnenhe apayuthnetyenhe mantereke, ite-kenheke, iltye-kenheke, itne-arle silver uthene gold uthene-ngentyele mpwarekeke. Arelhe Egypt-arenye areyele arne yanhe areye ingkirreke arelhe Israel-arenye areye anthetyenhe, kele imerte arelhe Israel-arenye areye akenhe arne yanhe areye ampe itnekenhe areye anthetyenhenge. Alakenhe ikwerenge tyerrtye Israel-arenye areyele arne ingkirreke Egypt-arenye areye-ngentyele inetyenhe.” Alakenhe renhe Ngkarte Moses-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Kenhe Moses akenhe awethe YAHWEH-eke angkeke, “Israel-arenye areyele ayenge awetyakenhe apeke. Itne apeke atyenge angkeketyenge, ‘Arrangkwe, YAHWEH ngkwenge imernelhetyakenhe!’ Nhenge alakenhe itne apeke atyenge angkeme-ketye, nthakenhe-arle-ame ayenge itneke angketyenhe?” ");
INSERT INTO aer_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","YAHWEH-ele anteme renhe apayuthneke, “Iwenhe-ame iltyele?” Moses ikwere angkirtneke, “Nhenhe atneme atyinhe.” ");
INSERT INTO aer_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","YAHWEH anteme ikwere angkeke, “Ahelheke iwaye!” Kele, Moses atneme renhe ahelheke iweke. Arne re iparrpe anthurre apmwe-werne akngarte-iwelheke, Moses antyarlpe-iwelheke atere-irrekenge. ");
INSERT INTO aer_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","YAHWEH-ele renhe atyenpelhe-ileke ikwere angkemele, “Atere-irretyalaye, tile-nge arntwirrkaye.” Moses-ele anteme tile-nge arntwirrkeke. Iltye ikwerenhele apmwe renhe anpeke-arteke ampwe atneme-werne anteme akngarte-iwelhirtneke. ");
INSERT INTO aer_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","YAHWEH anteme ikwere angkeke, “Nhenge unte Israel-arenye areye-werne alhemele, atneme ngkwinhe ahelheke iwetyeke The ngkwenge imerneke-arteke. Nhenge re apeke apmwe-werne akngarte-iwelhemele, tile-nge arntwirrkaye, re atneme-werne akngarte-iwelhirtneme anteme. Nhenge itne apeke ngenhe aremele alakenhe mpwarerlenge, itne anteme angkentye ngkwinhe arratye itelaretyenhenge. Unte itneke ileme Ayenge-arle, YAHWEH-arle ngkwenge imernelhekeke. Unte itneke iletyeke Ayenge-arle arrwekelenye areye itne-kenheke Ngkarte aneme, Abraham-eke, Isaac-eke, Jacob utheneke-arle arrule anthurre apentetyarteke.” ");
INSERT INTO aer_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","YAHWEH anteme Moses-eke angkeke, “Iltye ngkwinhe mantereke-arleke akwernaye.” Kele, Moses-ele iltye ikwerenhe mantereke-arleke akwerneke. Nhenge iltye arratelhe-ilelhemele, iltye ikwerenhe irrkentye akngerre irreke. ");
INSERT INTO aer_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","YAHWEH anteme ikwere angkeke, “Iltye ngkwinhe mantereke-arleke awethe akwernaye.” Moses-ele iltye ikwerenhe mantereke-arleke awethe akwerneke. Nhenge re tyarre-inemele awethe re mwerre-irrekenge anteme irrkentye kwenye aneke. ");
INSERT INTO aer_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","YAHWEH anteme ikwere angkeke, “Unte apeke Israel-arenye areyeke atneme yanhe renhe imerneme apmwe-werne-arle akngarte-iwelhemeke, itne apeke ngkwenge akangkwe-irretyakenhe anetyenhe, Tharle ngenhe yernekeke. Unte apeke itneke iltye ngkwinhe imerneme irrkentye akngerre-arle irrekeke, nhenge re mwerre-irrerlenge awethe, itne apeke ngkwenge akangkwe-irretyakenhe akwete aneme. ");
INSERT INTO aer_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Itne apeke ngenhe awetyakenhe akwete, lhere akngerre Nile-ngentyele kwatye inaye, itnekenge alkngetherre ahelheke thelaye, re alhwe-werne atheke anteme akngarte-iwelheme.” ");
INSERT INTO aer_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Kenhe Moses akenhe YAHWEH-ketye mwernte akwete aneme, re-anteme Ikwere angkeke, “Ayenge arne nhenhe areyeke akutne aneme, ayenge kwenhe tyerrtye atningke anthurreke angketyakenhe anetyarte. Unte atyenge imernelheke, ayenge kwenhe apekape angkentye akwete. Ayenge kwenhe arlenye apekape irrentye akngerre-arlke nhenge angkemele. Ayenge kwenhe apale-arle-irreme nthakenhe renhe the itneke iletyeke.” ");
INSERT INTO aer_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","YAHWEH anteme awethe ikwere angkeke, “Ayenge kwenhe YAHWEH aneme. The kwenhe arrakerte ngkwinhe mpwareke. Ayenge apeke ahentye-aneme, the ngenhe anpetyeke nhenge unte imerte angketye-kwenye awetye-arlke-kwenye anetyenhenge. Ayenge apeke ahentye-aneme the ngenhe alknge pwenge-iletyenhe. Unte apeke alknge pwenge aneme, the ngenhe alknge awethe altywere-iletyeke unte awethe aretyeke anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Atyenge ahele akwete angketyalaye! Arlenye apertape akwele ilelhetyalaye! Israel-arenye areye-werne alhaye! Ayenge ngkwengenge alhetyenhenge. The ngenhe iletyenhe iwenhe apeke ikwere unte itneke angketyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Kenhe Moses re akenhe Renhe awetyakenhe akwete mwernte akngerre akwete anemele, re YAHWEH-eke angkeke, “Ayenge akunye apenhe! Ayenge yernetyalaye! Tyerrtye arrpenhe yernaye!” ");
INSERT INTO aer_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","YAHWEH Moses-eke ahele-anteme-irreke, ikwere angkemele “Kele kwenhe! Kake akngerre ngkwinhe-arle-artaye? The renhe nhenhe-werne yerneme. Re Levi-kenheke-artweye aneme, re kwenhe ilernpenye angketyeke. Nhenge re ngenhe aremele, re ngkwenge akangkentye anthurre anetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","16","Ayenge mpwelekenge anetyenhe, The mpweleke iletyenhe iwenhe apeke ikwere angketyeke. The ngenheke-amparre arratye-ileme nthakenhe-akenhe unte angketyenhenge, unte anteme angkentye Atyinhe Aaron-eke iletyenhenge. Re ngenhe awetyenhenge imerte tyerrtye areyeke ngkwenge angketyenhenge. Unte ikwere Ngkarte-arteke angketyenhe. ");
INSERT INTO aer_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Atneme ngkwinhe apmere Egypt-werne akngaye. Iwenhe re apeke ayenge ngkwenge angkeme atneme ngkwinhe-akertele itneke imernaye unte arne areye ilyernpenye mpwaretyeke itne ngenhe aretyenhenge itelaretyenhenge unte Utnenge Atyinhe atnyeneme.” ");
INSERT INTO aer_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Ikwere-ipenhele, Moses arnteweyikwe Jethro-werne alpeke. Re ikwere angkeke, “Arnteweye-aye, mwerre-ame ayenge apmere Egypt-werne alpeme? Ayenge kwenhe tyerrtye atyinhe areye-werne alpetyeke ahentye-aneme itne apeke-arle itethe akwete anemeke aretyeke.” Jethro ikwere angkirtneke, “Yewe, mwerre anthurre. Iparrpe alhaye. Ngkartele ngenhe arntarnte-areme.” ");
INSERT INTO aer_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Moses apmere Midian-ele urreke ulkere aneke re arne areye akwete-ante mpwaretyeke alhetyenhe. YAHWEH anteme ikwere angkeke, “Egypt-werne iparrpe alpaye. Artwe nhenge areye-arle ngenhe-arle irrerlknge atwetyeke angketyameke itne ingkirreke ilweke-arle.” ");
INSERT INTO aer_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Moses-ele anewe ikwerenhe alere ikwerenhe atherre inerle-alheke, itnenhe tangkeye-ke arrerneke. Re Egypt-werne atheke ingkele alheke, itne ingkerne apetyetyame tangkeye-nge. Moses atneme ikwerenhe-akerte alhetyame Ngkartele-arle renhe akngetyeke ilekenge. ");
INSERT INTO aer_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","YAHWEH anteme Moses-eke angkeke, “Nhenge unte apmere Egypt-eke irretye-alhemele, ayenge awaye angkerlenge. Ayenge awaye nhenge tyerrtye areyele ngenhe aretyenhenge unte-arle Utnenge Atyinhe atnyeneme. The Utnenge Atyinhe ngkwengeke-arleke kele akwerneke. Pharaoh-ele ngenhe aretyenhe nhenge unte arne areye Utnenge Atyinhele ilernpenye anthurre mpwarerlenge. The akenhe renhe ikerlte-iletyenhenge, re ngenhe awetyakenhe anetyenhenge. Re tyerrtye ngkwinhe areye Egypt-ngentyele irlwemele aywepetyakenhe anetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Kenhe nhenge re apeke arrenhantherrenhe mwernte-ilemele, alakenhe ikwere angkaye, ‘Alakenhe kwenhe YAHWEH ngkwenge angkeme, “Unte kwenhe alere akngerrepate ngkwinheke ahentye anthurre aneme. Alakenhe re-anteye ayenge kwenhe tyerrtye Israel-arenye areyeke ahentye anthurre aneme. ");
INSERT INTO aer_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","Itnenhe Egypt-ngentyele ipmentye aywepaye itne Ayenge apentetyenhenge ayenge tnaketyenhenge anteye. The ngenhe alkngarre-ileme, unte apeke itnenhe Egypt-ele akwete atnyenetyenhe, The akenhe alere arrwekele-ipenhe ngkwinhe irrerlknge atwetyenhe.” ’ Alakenhe renhe anteme unte Pharaoh-eke iletyeke.” ");
INSERT INTO aer_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Ikwere-ipenhele anteme Moses Egypt-werne alheke anewe ikwerenhe uthene alere atherrame uthene-akerte. Itne mpwepeke interrirreke. Alere ingkernenye Moses-kenhe artwe-irretyakenhe akwete, alakenhe ikwerenge anteme YAHWEH-ele Moses irrerlknge atwetyeke aneke. ");
INSERT INTO aer_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","26","Alakenhe irreketyenge, Moses ikwere anewe Zipporah-ele iwenhe apeke renhe mpwarerlenge, alakenhe ikwerenge anteme Ngkartele Moses irrerlknge atwetyakenhe aneke Zipporah-ele-arle iwenhe apeke renhe nhenge mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Nhenge Moses itwe-ulkere akwete anekenge, YAHWEH Aaron-eke angkeke, “Apmere ahelhe arrangkethe-werne alhaye unte Moses aretyenhenge.” Kele Aaron anteme alheke Moses aretyeke mpwekeke akwete-arle apmere ahelhe arrangkethe-werne alhemeke. Re Moses areke apwerte ameke-ameke ikwerele Sinai arritnyele. Aaron anteme apetyeke Moses-eke arnekarnare renhe kwaketye-akeke. ");
INSERT INTO aer_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Moses-ele anteme Aaron-eke ileke YAHWEH angketyamenge-akerte urreke re Egypt-werne apetyalpetyenhenge. Re Aaron-eke imerneke atneme Ngkartele-arle renhe akngetyeke ilekenge. Moses anteme Aaron-eke angkeke, “Ngkartele ayenge ileke arne areye Utnenge Ikwerenhele ilernpenye mpwaretyeke tyerrtye areyeke alkngetherre anthurre. The apeke atneme nhenhe ahelheke iweme, re apmwe-werne anteme akngarte-iwelhetyenhenge. The apeke iltye mantereke-arleke akwerneme, re irrkentye akngerre irreme. Alakenhe renhe Ngkartele atyenge mpwaretyeke ileke.” ");
INSERT INTO aer_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Ikwerenge anteme, nhenge Moses uthene Aaron uthene apmere Egypt-eke irremele, ratherre akngerrepate Israel-arenye areye apurtelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron-ele anteme itneke ingkirreke anthurre iletyame YAHWEH-arle Moses-eke angkekeke. Nhenge Moses-ele atneme ahelheke iweke, re apmwe-werne akngarte-iwelherlenge. Nhenge re renhe kutyeke re atneme-werne anteme akngarte-iwelhirtnekenge. Nhenge re iltye mantereke-arleke akwerneke, re irrkentye akngerre irremenge nhenge renhe tyarre-inemele awethe re mwerre-irrekenge anteme irrkentye kwenye aneke. ");
INSERT INTO aer_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Nhenge Israel-arenye areyele aremele renhe alakenhe renhe mpwarerlenge, itne arratye itelareke YAHWEH-ele Moses yerneke arne nhenhe areye ilernpenye mpwaretyeke. Itne anteme angkerreke, “Ngkarte kwenhe anwerneke itirreme. Re anwernenhe ipmentye impetyakenhele. Re Egypt-arenye areye areke nhenge itne anwernenhe atwerlenge.” Itne ingkirreke anthurre anteme ahelhe-werne kwene-irreme, itne anteme Renhe tnakeke. ");
INSERT INTO aer_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Moses uthene Aaron uthenele tyerrtye Israel-arenye areyeke imerneke-arle-iperre, nhenge Ngkarte-arle ilernpenye anthurre aneme, ratherre Pharaoh-werne aretyeke alherreke. Ratherre ikwere angkeke, “YAHWEH, Ngkarte Israel-arenye areyeke-arle anemeke, Re kwenhe ngenhe nhenhe ileme, ‘Tyerrtye atyinhe areye ipmentye aywepaye itne imperlte-alhetyeke. Itnenhe yernaye apmere arrangkethe mpwepeke-werne alhetyeke nhenge itne arrawe-irrentye akngerrele arlkwetyenhenge Ayenge tnaketyenhenge.’” ");
INSERT INTO aer_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Kenhe Pharaoh re akenhe ayene-ilelheke, re itneke angkeke, “Angwenhe-ame YAHWEH? Iwenheke-ame the Renhe awetyenhe? Ayenge Ikwere akutne-arle! The arrenhantherrenhe Israel-arenye areye apmere arrangkethe-werne yernetyakenhele aneme, arrangkwe-arle!” ");
INSERT INTO aer_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Aaron uthene Moses uthene Ikwere angkeke, “Ngkarte, anwerne Hebrew areyele-arle apentemeke, Re anwernenhe ileke apmere arrangkethe-werne alhetyeke. Yanhe ikwerele anteme anwerne YAHWEH Ngkarte anwerne-kenheke kere tyawerrelye antheme. Unte apeke anwernenhe ayakeme, Re apeke anwernenhe rlkerte-iletyenhe anwerne ilweme anteme apeke, anwerne ingkirreke anthurre apeke ilweme atwerrentye akngerre iperre.” ");
INSERT INTO aer_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","5","Kenhe Pharaoh akenhe akwete anthurre ayene-ilelheke, re Moses uthene Aaron utheneke angkeke, “Ipmentye! Iwenhenge-arle-ame mpwele tyerrtye akwerrke ngkwenge areye ileme warrke itnekenhe impemele alhetyeke apmere arrangkethe-werne alhetyeke? Itne kwenhe atningke! Alperlte-iwaye itnenhe ilaye warrke-irrirtnetyeke! The itnenhe yernetyakenhe alhetyeke! Iwenhenge-ame unte itnenhe warrke-irreme-ketye ayaketyeke ahentye aneme?” ");
INSERT INTO aer_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Ikwerenge-ntyele, arlte ikwerele-anteye, Pharaoh warrkene ikwerenhe areyeke angkeke, warrkene ikwerenhe areyeke-anteye tyerrtye Israel-arenye areye-arle uternemeke warrke-irretyeke ayernentye akngerre areye-arteke, re itneke angkeke, ");
INSERT INTO aer_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","8","“Arrantherre kwenhe tyerrtye Israel-arenye areye name antyerrke anthetyarte ahelhe urrkngenge anyentelhe-iletyeke apmere artetyeke. Itne kwenhe brick atningke anthurre arlte arrpe-anenhele mpwaretyarte. Lyete-ulkere anteme itne aname-atheke. Alakenhe ikwerenge anteme itne ayenge arnterre apayuthneme, itne warrke itnekenhe imperlte-alhetyeke anteme apmere arrangkethe-werne alhetyeke kere tyawerrelye Ngkarte anthetyenhenge. Tharle itnenhe arratye itelaretyakenhe! Lyete-ngentyele itnenhe name antyerrke awethe anthetyale anetyeke. Itnenhe ilaye name antyerrke itnekenhe-arrpe inetyeke brick areye mpwaretyeke. Itnenhe uternaye brick atningke anthurre mpwaretyeke arrekwele-arteke nhenge arrantherre itnenhe name antyerrke yanhe anthetyarte. Itne apeke urrpetye ware mpwareme-ketye, itnenhe alkngetherre ilaye, itne aname-atheke-ketye. ");
INSERT INTO aer_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Yewe, itnenhe akwete warrke-irretyeke uternaye. Itnenhe awempeme-ilaye, itnenhe apurrkele-anthemele! Itne apeke alakenhe arnterre akwete warrke-irreme, kele itne Moses awetyakenhele aneme itneke urrtyirremele ilerlenge!” Alakenhe renhe Pharaoh warrkene ikwerenhe areyeke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Arratye anthurre anteme warrkene yanhe areye tyerrtye Israel-arenye areye-werne alheke, itneke angkemele, “Pharaoh kwenhe angkerne re akwele arrenhantherrenhe name antyerrke awethe anthetyakenhe anetyenhe brick areye mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Re angkeke arrantherre name antyerrke arrekantherre-arrpe untherlte-anetyeke. Re angkeke aname-atheke anetyale anaye. Re angkeke arrantherre brick atningke anthurre mpwaretyeke arrekwele-arteke nhenge anwerne arrenhantherrenhe name antyerrke akngerre anthetyarte.” ");
INSERT INTO aer_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Ikwerenge-ntyele tyerrtye Israel-arenye areye Egypt-nge untherlte-iweke arratye, name antyerrke inetyeke brick mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Tyerrtye Egypt-arenye areyele itnenhe uternetyame arnterre anthurre warrke-irretyeke, itneke angkemele, “Iparrpe warrke-irrerlte-anaye! Pharaoh angkeke brick atningke anthurre mpwarewarretyeke arrekwele-arteke nhenge anwerne name antyerrke anthetyartenge.” ");
INSERT INTO aer_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Urreke nhenhe anetyenhenge, Egypt-arenye areyele tyerrtye Israel-arenye arrpenheme akngakeke warrkene arrpenhe areyeke akngerrepate anetyeke. Itne itnenhe ileke, “Apmere-altye arrekantherrenhe apeke aname-atheke irrerlenge, itne apeke akweke ware warrke-irremele, anwerne arrenhantherrenhe irrerlknge atwetyenhenge!” Ikwere-ipenhele, tyerrtye Israel-arenye areyele brick atningke mpwaretyakenhe aneke, arrangkwe-arle. Itne name antyerrkeke apale untherlte-iweke akweke ware-ante. Kele imerte Egypt-arenye areyele akngerrepate Israel-arenye areye atweke itnenhe apayuthnemele, “Aye! Iwenhenge-ame apmere-altye arrekantherrenhe aname-atheke irrerlenge? Itne kwenhe brick urrpetye ware mpwareme, arunthe anetyakenhe arrekwele-arteke!” ");
INSERT INTO aer_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Kenhe akngerrepate Israel-arenye areye Pharaoh apayuthnetyeke alheke, “Anwerne akunye-apenhe areye! Iwenhenge-arle-ame unte anwerneke ahele aneme? Anwerne kwenhe warrkene ngkwinhe areye ware! Iwenhenge-arle-ame warrkene ngkwinhe areyele anwernenhe atweme? ");
INSERT INTO aer_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Artwe ngkwinhe areyele kwenhe anwernenhe name antyerrke anthetyakenhe. Itne kwenhe anwernenhe akwete anthurre uterneme brick atningke mpwaretyeke arrekwele-arteke! Anwerne kwenhe urrpetye ware mpwareme, itne akenhe anwerneke ahele-irrerlenge, anwernenhe atwemele anteye. Anwerneke ahele-irretyale anaye! Anwernenhe aname-atheke aketyale anaye! Warrkene ngkwinhe areyeke ahele-irraye itne-arle anwernenhe name antyerrke anthetyakenhenge!” ");
INSERT INTO aer_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Pharaoh itneke angkeke, “Arrantherre kwenhe aname-atheke ware! Arrantherre itirreme arrantherre-arle warrke-irretyakenhe akwele aneme. Alakenhe ikwerenge anteme arrantherre ayenge apayuthneme apmere arrangkethe ikwere-werne alhetyeke kere itetyeke YAHWEH tyawerrelye anthetyeke. ");
INSERT INTO aer_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Warrke-irretyeke alperlte-iwaye! Anwerne arrenhantherrenhe name antyerrke awethe anthetyakenhe aneme. Kenhe arrantherre kwenhe akwete anthurre brick atningke mpwaretyeke arrekwele-arteke, nhenge anwerne arrenhantherrenhe name antyerrke anthekenge-arteke. Arrangkwe apeke the arrenhantherrenhe ingkirreke anthurre irrerlknge atwetyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Nhenge akngerrepate Israel-arenye areyele nhenhe awemele, itne angkerreke, “Ayekaye! Nthakenhe-ame anwerne-irreye? Anwerne apeke brick urrpetye-urrpetye ware mpwareme, artwe Pharaoh-kenhe areyele anteme anwernenhe irrerlknge atwerlenge ingkirreke anthurre!” ");
INSERT INTO aer_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Ikwere-ipenhele, itne apmere Pharaoh-kenhe renhe impemele alheke, itne apmere Moses uthene Aaron uthene-kenhe-werne alpeke, itneke-arle akarelhetyameke. ");
INSERT INTO aer_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Itne Moses uthene Aaron utheneke angkeke, “Ngkartele kwenhe mpwelenhe irrerlknge atwetyeke! Pharaoh artwe ikwerenhe areye-arlke kwenhe anwerneke ahele anthurre aneme mpwele-ngentyele ware. Mpwele Pharaoh ileke anwernenhe apmere arrangkethe-werne ipmentye aywepetyeke. Alakenhe ikwerenge anteme itne anwernenhe ingkirreke irrerlknge atwetyeke ahentye aneme.” ");
INSERT INTO aer_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Kenhe Moses akenhe anyente-arenye alheke YAHWEH-eke angketyeke, Renhe apayuthnemele, “YAHWEH, iwenhenge-ame unte anwernenhe arlkarentye-ileme nhenhe Egypt-nge? Anwerne kwenhe tyerrtye Ngkwinhe areye. Unte-ame ayenge nhenhe-werne yerneke Unte anwernenhe arlkarentye-iletyeke anteme? ");
INSERT INTO aer_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Ayenge kwenhe Pharaoh-werne angketyeke alheke Unte-arle ayenge ileke-arteke. Alakenhe ikwerenge anteme re tyerrtye Ngkwinhe areyeke ahele-irreke, re itnenhe akwete anthurre atweme itnenhe arlkarentye-ilemele anteye. Iwenhenge-arle-ame Unte itnenhe arntarnte-aretyakenhe?” ");
INSERT INTO aer_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","YAHWEH anteme Moses-eke angkeke, “Unte kwenhe ayenge aretyenhe nhenge The Pharaoh ayaketyenhenge Israel-arenye areye akurne-ileme-ketye itnenhe atwerle-aneme-ketye. The ngangkerele renhe atwetyenhe nhenge re tyerrtye Atyinhe areye Egypt-ngentyele apmere arrangkethe ikwere-werne ipmentye yernetyenhenge. Re tyerrtye areye yernetyenhe atyenge-ngentyele ware.” ");
INSERT INTO aer_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Ngkarte anteme Moses-eke angkeke, “Ayenge kwenhe YAHWEH aneme. ");
INSERT INTO aer_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Arrule anthurre Ayenge Abraham, Isaac uthene Jacob utheneke imernelheke. Ayenge itneke ilelheke arritnye Atyinhe NGKARTE LTERRKE ANTHURRE ANEME-ARLE. Itne YAHWEH arritnyeke akutne aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","The itnenhe alhileke The itnenhe apmere Canaan itnenhe anthetyeke aneme. Arrule anthurre itne apmere yanhe ikwerele anetyarte, itnekenhe anetyakenhe aneke. Apmere yanhe tyerrtye arrpenhe areye-kenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Lyete The awerne tyerrtye Israel-arenye areye ampwangkewarrerlenge. The kwenhe itelareme Egypt-arenye areyele itnenhe atwemenge itnenhe warrke-irretyeke ayernentye akngerre areye-arteke uternemele. Ayenge tyerrtye Atyinhe areyeke alkngwirretyakenhe The apmere Canaan yanhe renhe anthetyeke alhileke-iperre. ");
INSERT INTO aer_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Tyerrtye Israel-arenye areye Atyenge-akerte iletyeke alhaye. Itneke alakenhe ilaye, ‘Ayenge kwenhe YAHWEH. The kwenhe Egypt-arenye areye ayaketyeke itnenhe atweme-ketye arnterre warrke-irretyeke uterneme-ketye anteye. Arrantherre itneke awethe warrke-irretyakenhe anetyenhenge. The arrenhantherrenhe ngangkerele Egypt-arenye areye-ngentyele akngetyenhenge. The itnenhe akurne-iletyenhe akurnentye anthurre. ");
INSERT INTO aer_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Arrantherre tyerrtye Atyinhe areye anteme aneme, ayenge Ngkarte arrekantherrenhe anetyenhe. Arrantherre itelaretyenhenge Ayenge-arle Ngkarte YAHWEH aneme. The arrenhantherrenhe Egypt-arenye areye-ngentyele akngetyenhe, itne arrenhantherrenhe warrke-irretyeke awethe uternetyakenhe anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","The arrenhantherrenhe yerrele-akngetyenhe apmere ahelhe ikwere-werne The arrule anthurre Abraham, Isaac, Jacob utheneke alhileke-iperrele. The arrenhantherrenhe apmere yanhe renhe anthetyenhe. Apmere re arrekantherrenhe anetyenhe. Ayenge kwenhe YAHWEH.’ Alakenhe renhe unte tyerrtye Israel-arenye areyeke angketyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Kele Moses-ele anteme tyerrtye Israel-arenye areyeke iwenhe renhe iletye-alheke Ngkartele renhe angketyeke ileke. Kenhe itne akenhe renhe arratye itelaretyakenhe akwete aneke, arrangkwe-arle. Egypt-arenye areyele itnenhe akwete anthurre warrke-irretyeke uternetyame, Israel-arenye areye itneke-arrpe alhwarrpe anthurre awelheke. Alakenhe ikwerenge anteme itne Moses arratye itelaretyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","11","YAHWEH anteme Moses-eke angkeke, “Pharaoh iletyeke alhaye tyerrtye Israel-arenye areye Egypt-ngentyele ipmentye yernetyeke itnenhe mwernte-iletyale.” ");
INSERT INTO aer_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Moses anteme YAHWEH-eke angkeke, “Araye! Tyerrtye Israel-arenye areyele kwenhe ayenge awetyakenhe! Pharaoh-ele ayenge awetyakenhe itanye! Ayenge kwenhe akutne, ayenge kwenhe tyerrtye atningkeke arrekwele angketyakenhe aneke, iwenhe re-anteme ayenge ikwere angketyenhe?” ");
INSERT INTO aer_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","YAHWEH-ele Moses uthene Aaron uthene ileke, Israel-arenye areyeke-arlke Pharaoh-ekarlke awethe iletyeke alheme. Itnenhe ilaye Tharle mpwelenhe ileke tyerrtye Israel-arenye areye apmere Egypt-ngentyele arratelhe-iletyeke. ");
INSERT INTO aer_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Tyerrtye Israel-arenye areye anyenhenge areye apurte anetyarte. Nhenhe anteme arritnye itnekenhe aneme nhenge yanhe areye anyenhenge itnekenhe-arrpe areyeke akngerrepate-arle anekeke. Alere akngerrepate Israel-kenhe Reuben arritnye aneke. Reuben alere 4-pele atnyeneke Hanock, Pallu, Hezron, Carmi. Artwe nhenhe areye anyenhenge four-pele areyeke akngerrepate aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Alere Simeon-kenhe areye arritnye aneke: Jemuel, Jamin, Ohad, Jakin, Zohar, Shaul. Shaul-eke mikwe Canaan-arenye aneke. Artwe six-pele nhenhe areye anyenhenge six-pele areyeke akngerrepate areye aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Levi itethe aneke uterne 137-eke-atwetye. Alerikwe areye arritnye aneke: Gershon, Kohath, Merari. Itne anyenhenge three-pele apurte anetyarte. ");
INSERT INTO aer_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershon alere atherre atnyeneke, Libni, Shimei arritnye. Ratherre anyenhenge atherre apurte anetyarte. ");
INSERT INTO aer_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Kohath itethe aneke uterne 133-eke-atwetye. Alere ikwerenhe areye-kenhe arritnye aneke, Amram, Izhar, Hebron, Uzziel. ");
INSERT INTO aer_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Alere Merari-kenhe atherre arritnye aneke Mahli uthene Mushi uthene. Anyenhenge nhenhe areye Levi-kenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Artwe Amram-ele atyeyikwe akngeye ikwerenhe-kenhe Jochebed arritnye anewe akeke. Jochebed-ele Aaron uthene Moses uthene-akerte. Amram itethe aneke uterne 137-eke-atwetye. ");
INSERT INTO aer_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Artwe Izhar arritnye aneke, alerikwe Korah, Nepheg, Zichri arritnye. ");
INSERT INTO aer_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Artwe Uzziel arritnye, alerikwe Mishael, Elzaphan, Sithri. ");
INSERT INTO aer_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Artwe Aaron-ele akenhe Elisheba anewe-akeke, alere Amminadab-kenhe yaye akngerre Nahshon-eke re aneke, Elisheba-le ampe akweke Nadab, Abihu, Eleazar, Ithamar atnyeneke. ");
INSERT INTO aer_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Artwe Korah, alere ikwerenhe areye-kenhe arritnye aneke Assir, Elkanah, Abiasaph. Alerikwe nhenhe areye akenhe anyenhenge three-peleke akngerrepate aneke Korah-kenhe. ");
INSERT INTO aer_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleazar, alere Aaron-kenhele arelhe anewe-akeke, akngeye ikwerenhe aneke Putiel. Re ampe akweke Phinehas atnyeneke. Ye, nhenhe kwenhe arritnye anyenhenge areyeke akngerrepate Levi-kenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Kenhenge yanhe atherre Aaron uthene Moses uthene, yanhe ikwere-atherre thewe YAHWEH-arle angkekeke, “Tyerrtye Atyinhe Israel-arenye areye Egypt-ngentyele arratelhe-ilerle-anerraye. Anyenhenge-arrpe ingkirreke apmere yanhe ikwerenge-ntyele akngetyaye.” ");
INSERT INTO aer_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Ratherre anteme Pharaoh-eke angketyeke alherreke, ratherre renhe ileke tyerrtye Israel-arenye areye apmere Egypt-ngentyele yernetyeke mwernte-iletyale itnenhe. ");
INSERT INTO aer_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Nhenge Moses apmere Egypt-ele akwete anekenge, YAHWEH ikwere angkeke, ");
INSERT INTO aer_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","“Ayenge kwenhe YAHWEH. Pharaoh-eke iletyeke alhaye nthakenhe re ayenge ngkwenge angkerne.” ");
INSERT INTO aer_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Moses ikwere angkeke, “Arrangkwe, Ayenge kwenhe apale-apale ware angkentye akngerre. Nthakenhe-ame ayenge ikwere angketyenhe? Re ayenge awetyakenhele anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Ikwere-ipenhe, YAHWEH Moses-eke angkeke, “The kwenhe ngenhe akngakeke Ngkarte-arteke anetyeke Pharaoh Egypt-arenyeke. The kake akngerrepate ngkwinhe akngakeke ayeye akngernentye akngerre anetyeke ngkwenge angketyeke anteye. ");
INSERT INTO aer_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","The ngenhe ileme iwenhe apeke renhe unte angketyeke. Aaron-eke ayeye Atyinhe ilaye, re anteme Pharaoh-eke angketyenhenge. Re Pharaoh-eke alakenhe anteme angketyenhe, ‘Mwernte-iletyalaye nhenge tyerrtye Israel-arenye areye Egypt impemele alherlenge. Itnenhe ipmentye yernaye.’ ");
INSERT INTO aer_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","The akenhe Pharaoh yanhe renhe ikerlte-iletyenhe nhenge re mpwelenhe awetyakenhe anetyenhenge. Ikwere-iperrele anteme arlte arrpe-anenhele The ikwere imernetyeke The arne ingkirreke ilernpenye anthurre mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Kenhe Re akenhe ikerlte anthurre akwete anetyenhe. Re mpwelenhe awetyakenhe akwete anetyenhe. Ikwere iperrele anteme The tyerrtye Egypt-arenye areye akurne-iletyenhe. Yanhe ikwerenge-ntyele, The anyenhenge arrpe-anenhe ingkirreke, Atyinhe ingkirreke apmere Egypt-ngentyele arratelhe-iletyenhe. ");
INSERT INTO aer_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Nhenge The Egypt-arenye areye akurne-ilemele, nhenge The Israel-arenye areye apmere Egypt-ngentyele yerrele akngemele, ikwere-iperrele anteme Egypt-arenye areyele itelaretyenhe Ayenge YAHWEH akngerre anthurre-arle aneme.” Alakenhe rarle YAHWEH Moses-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Kele Moses uthene Aaron uthenele Pharaoh-eke ileke arratye ayeye renhe-anteye YAHWEH-elarle ikwere-atherre arrwekele ilekeke. ");
INSERT INTO aer_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Nhenge Moses uthene Aaron uthene Pharaoh-eke angketyeke alherreke, ratherre artwe ampwe atherre aneke, Moses year 80-arle aneke, kenhe Aaron akenhe year 83-arle aneke. ");
INSERT INTO aer_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","9","Ikwere iperrele anteme, YAHWEH Moses uthene Aaron utheneke angkeke, “Nhenge mpwele Pharaoh-werne alhemele, re mpwelenhe apayuthnetyenhe arne iwenhe apeke renhe ilyernpenye mpwaretyeke. Moses-aye, re apeke ngenhe apayuthnerlenge, Aaron ilaye atneme ikwerenhe ahelheke iwetyeke Pharaoh-nge alkngetherre anthurre. Atneme anteme apmwe-werne akngarte-iwelhetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Kele, Moses uthene Aaron uthenele anteme Pharaoh aretyeke alheke. Nhenge re renhe-atherrenhe apayuthnemele arne iwenhe apeke renhe ikwere ilyernpenye imernetyeke, Aaron-ele atneme ikwerenhe ahelheke iweke Pharaoh-nge alkngetherre anthurre, warrkene ikwerenhe areyenge-arlke. Arne atneme re-anteme apmwe-werne akngarte-iwelheke. ");
INSERT INTO aer_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Pharaoh-ele anteme yerneke akaperte altywere areye, ngangkere ikwerenhe areye-arlke ineke. Itne arrpe-anenhele interte-akeme anteye. ");
INSERT INTO aer_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Itne ingkirreke anthurrele atneme itnekenhe ahelheke iwerrirreke. Arne atneme ingkirreke anthurre apmwe-werne akngarte-iwelheke. Kenhe apmwe Aaron-kenhele apmwe arrpenhe areye arlkwerlenge. ");
INSERT INTO aer_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Pharaoh re ikerlte akwete aneke. Re Moses uthene Aaron uthene awetyakenhe akwete aneke. Alakenhe renhe YAHWEH-ele ikwere-atherre ileke-arle Pharaoh-akerte. ");
INSERT INTO aer_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Ikwere iperrele anteme, YAHWEH Moses-eke angkeke, “Pharaoh kwenhe ikerlte akwete aneme. Re kwenhe akwete anthurre mwernte-ileme tyerrtye areye Egypt-ngentyele alheme-ketye. ");
INSERT INTO aer_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ingwenthe ingweleme kwatye lhere akngerre Nile-werne alherraye. Ankarre iterele anteme tne. Atneme ngkwinhe akngaye apmwe-werne-arle akngarte-iwentye akngerre nhenge. Pharaoh-eke akarelhaye nhenge kwatye-werne alhewelhetyeke apetyerlenge. ");
INSERT INTO aer_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Nhenge re apetyerlenge, ikwere alakenhe angkaye, ‘YAHWEH kwenhe tyerrtye Hebrew areyeke Ngkarte aneme. Re kwenhe ayenge ngkwenge-werne angketyeke yerneke. Alakenhe kwenhe re ngkwenge angkeme, “Mwernte-iletyalaye tyerrtye Atyinhe areye-ketye apmere arrangkethe ikwere-werne alherlenge. Itne yanhe ikwerele Ayenge utyernemele tnaketyenhenge.” Alakenhe renhe-arle YAHWEH-ele ngkwenge ileme. Unte kwenhe arrwekele renhe awetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Alakenhe kwenhe YAHWEH anteme ngkwenge angkeme, “Unte Moses apayuthnerlenge angwenhe Ayenge aneme. Mwerre, The ngkwenge imernetyenhe Ayenge ilernpenye anthurre aneme, arne iwenhe apeke renhe ngangkerele ilernpenye mpwaretyeke, unte anteme itelaretyenhenge angwenhe Ayenge aneme-arle. Yanhe arratye anthurre. Moses-ele kwatye lhere Nile arne atneme ikwerenhele atwetyenhe. Nhenge re renhe atwemele kwatye re alhwe-werne anteme akngarte-iwelhetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Ikwere-iperrele kwatye lhere Nile kwenele-arle anemeke ingkirreke anthurre ilwetyenhe, kwatye anteme arntirte ntyeme. Arrantherre Egypt-arenye areyele kwatye yanhenge antywetyakenhele anetyenhe.” ’” ");
INSERT INTO aer_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","YAHWEH Moses-eke angkeke, “Aaron ilaye arne atneme ikwerenhe inetyeke alhetyeke imerte kwatye alaye uthene kwatye arnerre uthene areye Egypt-werne thiletyeke. Re apeke arne atneme ikwerenhele itneke-werne atheke thileme kwatye ingkirreke alhwe-werne akngarte-iwelhetyenhenge anteme, kwatye lhere akngerrele lhere akwekele-arlke, kwatye ilerrtye-ilerrtyele-arlke, ingkirreke anthurre alhwe-werne akngarte-iwelhetyenhe, kwatye-kenhe areyele-arlke, yakwethe kwatye akngernentye akngerre areyele-arlke.” ");
INSERT INTO aer_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Arratye, nhenge Pharaoh warrkene ikwerenhe areye-arlke lhere Nile-werne apetyemele, Moses uthene Aaron uthenele mpwarerle-anerreke iwenhe renhe Ngkartele-arle ikwere-atherre ilekeke. Nhenge Aaron-ele arne atneme ikwerenhele kwatye atwerlenge kwatye ingkirreke anthurre alhwe-werne akngarte-iwelheke. Pharaoh uthene warrkene ikwerenhe areye uthenele renhe areke mpwarerlenge. ");
INSERT INTO aer_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Kele imerte ingkirreke anthurre kwatye kwenele-arle anekeke ilwerrirreke, itne ingkirreke anthurre irntirte-arle-irremele, akurne ntyemele. Kwatye lhere re-anteme irntirte anthurre ntyeke. Itne kwatye renhe antywetyakenhe aneke kwatye ingkirreke anthurre-arle Egypt-ele alhwe-werne akngarte-iwelhekenge. ");
INSERT INTO aer_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Ikwere iperrele, Egypt-arenye ngangkere areyele kwatye inemele renhe alhwe-werne akngarte-iweke anteye Moses-elarle mpwarekenge-arteke. Ikwere-iperrele anteme, Pharaoh awethe anteye ikerlte-irreke. Re Moses uthene Aaron uthene awetyakenhe aneke. Re akwete anthurre Israel-arenye areye-ketye mwernte-iletyame itne Egypt-ngentyele alheme-ketye. Alakenhe renhe YAHWEH-ele Moses uthene Aaron utheneke Pharaoh-akerte ileke. ");
INSERT INTO aer_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Pharaoh re anteme Moses uthene Aaron uthene-ketye impemele alheke apmere ikwerenhe-werne alpeke, Re renhe-atherrenhe awetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Egypt-arenye areyele kwatye lhere Nile-ngentyele uyarne antyweme. Itne lhere itweke kwatye iperte atnyeke, kenhe arrangkwe-arle. Itne akwete anthurre kwatyeke apale unthetyame. ");
INSERT INTO aer_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Nhenge YAHWEH-ele kwatye lhere Nile-le alhwe-werne akngarte-iweke, alhwe re yanhe ikwerele arlte seven-ele aneke. ");
INSERT INTO aer_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Ikwere-iperrele, YAHWEH Moses-eke angkeke, “Angkentye nhenhe Pharaoh-eke angketyeke alpaye, ‘Alakenhe nhenhe kwenhe YAHWEH ngkwenge angkeme, “Tyerrtye Atyinhe areyele apmere arrangkethele Ayenge utyernemele tnaketyeke. Itneke-ketye mwernte-iletyalaye! ");
INSERT INTO aer_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Unte apeke itneke-ketye ayene-ilelhemenge, The antyetyerre atningke anthurre apmere arrpe-anenhe-werne Egypt-werne yernetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lhere akngerre Nile-le antyetyerre mpwanke anetyenhe. Itne kwatye lhere-ngentyele arratetyenhe, apmere ingkirreke kweneke irrpemele arrantherre aneme-arle. Itne alhetyenhe arrantherre inteme-arle-werne, itne ntyamenge arrekantherrenhe unarnpetyenhe. Ye, antyetyerre areye apmere arrpe-anenhe-werne alhetyenhe, apmere tyerrtye arrekantherrenhe areye-kenheke irrpemele, apmere akngerrepate areye-kenheke-arlke irrpemele. Itne arne areyeke-arleke unarnpetyenhe arrantherre-arle merne itetyeke atnyenemeke. ");
INSERT INTO aer_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Ye, antyetyerre areye ngkwenge-arleke unarnpetyenhe, akngerrepate arrekantherrenhe-arlke, tyerrtye areye-arlke!” ’ Unte alakenhe renhe Pharaoh-eke iletyeke.” ");
INSERT INTO aer_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Ikwere-iperrele anteme YAHWEH Moses-eke angkeke, “Aaron ilaye arne atneme ikwerenhe inetyeke kwatye lhereke-arlke, arnerre areyeke-arlke thiletyeke. Re nhenge mpwarerlenge, antyetyerre ingkirreke anthurre kwatye iperte-ngentyele apmere Egypt-nge arratetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Kenhe Aaron-ele thileke anthurre kwatye lhere ingkirrekeke, kwatye iperte ingkirrekeke Egypt-nge. Kele imerte antyetyerre atningke anthurre kwatye-ngentyele arratemele apmere arrpe-anenhele Egypt-nge unarnpemele. ");
INSERT INTO aer_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Nhenhe ikwerele ureke, Egypt-arenye ngangkere areye apetyeke, itne-inpe antyetyerre areye kwatye-ngentyele arratelhe-ileke. Antyetyerre atningke anthurre apmere Egypt ikwerele unarnpetyame. ");
INSERT INTO aer_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Ikwere-iperrele anteme, Pharaoh-ele angkentye Moses uthene Aaron utheneke yerneke renhe aretyeke apetyetyeke. Nhenge ratherre irretye-alherremele, re ikwere-atherre angkerlenge, “YAHWEH-eke ilaye antyetyerre nhenhe areye atyenge-ngentyele akngetyeke tyerrtye atyinhe areye-ngentyele-arlke. Re apeke itnenhe akngetyeme, ikwere-iperrele anteme the arrenhantherrenhe ipmentye aywepetyenhenge apmere arrangkethe ikwere-werne arrantherre Renhe yanhe ikwerele utyernemele tnakewarretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Moses-ele Pharaoh apayuthneke, “Atyenge lyete ilaye! Ilengare-ame ayenge YAHWEH-eke ngkwenge angketyenhe warrkene ngkwinhe areyeke-arlke, tyerrtye ngkwinhe areyeke-arlke? Ayenge apeke ikwere angkerlenge, antyetyerre areye anteme apmere arrekantherrenhe-ngentyele arnparrtye-irretyenhe. Itne lhere Nile-werne alpetyenhe, itne-arle arrekwele aneke-werne.” ");
INSERT INTO aer_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","11","Pharaoh Moses-eke angkeke, “Ingwenthe YAHWEH atyenge apayuthnaye.” Moses ikwere angkeke, “Yewe, ayenge apeke YAHWEH-eke ingwenthe angkerlenge, antyetyerre areye arrekantherre-ngentyele arnparrtye-irretyenhe, warrkene ngkwinhe areye-ngentyele, tyerrtye ngkwinhe areye-ngentyele. Itne apmere-ngentyele-arlke arnparrtye-irretyenhe, lhere Nile-le-ante ware anemele. Ikwere-iperrele, unte itelaretyenhe YAHWEH kwenhe Ngkarte atyinhe aneme, tyerrtye atyinhe areyeke-arlke.” ");
INSERT INTO aer_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Ikwere-iperrele anteme Moses uthene Aaron uthenele Pharaoh impemele alheke. Arlte arrpenhele Moses YAHWEH-eke inkeke, “Antyetyerre nhenhe areye Egypt-arenye areye-ngentyele akngaye, nhenge areye Unte-arle itneke-werne-atheke yerneke!” ");
INSERT INTO aer_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","YAHWEH-ele awetyame Moses angkerle-anerlenge, renhe anteme re tyerneke. Antyetyerre areye kwenhe apmere areye kwenenge ilwerne, ahelhe akethe arrpe-anenhele. ");
INSERT INTO aer_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Egypt-arenye areyele untherlte-apeme antyetyerre ilweke-arle areye kutyerlte-apeke. Antyetyerre areye irntirte-irreme, akurne anthurre ntyemele. ");
INSERT INTO aer_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Nhenge Pharaoh-ele antyetyerre ilweke-arle areye aremele, re awethe-anteye ikerlte-irreke. Re Moses uthene Aaron uthene awetyakenhe aneke nhenge ratherre ikwere-werne angketyeke apetye-alherrekenge. Alakenhe renhe YAHWEH Pharaoh-akerte arrwekele angkeke-arle, ikwere-akerte ikerlte awethe-irretyenhe awetye-arlke-akenhe. ");
INSERT INTO aer_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ikwere-iperrele, YAHWEH Moses-eke angkeke, “Aaron ilaye ahelhe arne atneme ikwerenhele atwetyeke. Nhenge re ahelhe atwerlenge ahelhe-ngentyele akenhe iwenye atningke anthurre arraterlenge apmere apanpe ikwerele Egypt-ele.” ");
INSERT INTO aer_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Aaron-ele arne atneme ikwerenhe inemele arratye, re imerte atneme ikwerenhele ahelhe atweke nhenge renhe Moses-ele ilerlenge. Nhenge re renhe atwerlenge arteke, ahelhe-ngentyele iwenye atningke anthurre Egypt-ele arrateke. Iwenye areye anthurre tyerrtye areyeke-arlenge alkereke-irreke pwelekeke-arlenge-arlke. ");
INSERT INTO aer_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Kenhe Egypt-arenye ngangkere areyele akenhe ahelhe arne atneme itnekenhele atweke. Itne renhe anteye mpwaretyeke arrkerneke, arrangkwe akenhe, itne uyarne mpwareme! Kenhe iwenye-ante anthurre tyerrtye areyeke pweleke-ante areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Ngangkere areye anteme Pharaoh-eke angkeke, “Arrangkwe, anwerne kwenhe akutne aneme nthakenhe ahelhe ngangkere anwerne-akenhele iwenye-werne akngarte-iwetyeke. Aaron-ele ngangkere ngkarte anyente-kenhele ware ahelhe iwenye-werne akngarte-iwetyeke.” Kenhe Pharaoh re akenhe ikerlte akwete aneke, awetye-arlke-akenhe re. Alakenhe re YAHWEH Pharaoh-akerte arrwekele angkeke-arle, ikwere-akerte ikerlte awethe-irretyenhe awetye-arlke-akenhe. ");
INSERT INTO aer_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","YAHWEH Moses-eke angkeke, “Nhenge unte akeme-irremele ingwenthe, kwatye lhere-werne alhaye. Pharaoh-eke akarelhe nhenge re yanhe ikwere-werne apetyerlenge. Nhenge re apetyerlenge, alakenhe ikwere angkaye, ‘Alakenhe kwenhe YAHWEH ngkwenge angkeme, “Tyerrtye Atyinhe areyele kwenhe Ayenge utyernemele tnakewarretyeke apmere ahurratyenge. Itne-ketye mwernte-iletyalaye! ");
INSERT INTO aer_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Unte apeke itne-ketye mwernte-ileme, The amenge atningke anthurre ngkwenge yernetyenhe. Itne apmere kwene ngkwinhe-werne alkereke-irretyenhe. Itne ngkwenge-arlenge alkereke-irretyenhe, warrkene ngkwinhe areyeke-arlenge tyerrtye ngkwinhe areyeke-arlenge-arlke. Itne arrenhantherrenhe uthnetyenhe akurnentye anthurre. Amenge areye atningke-irretyenhe apmere kwene areyenge, Egypt-ante ahelhenge-arlke. ");
INSERT INTO aer_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“‘ “The akenhe amenge areye Goshen-werne yernetyakenhele anetyenhe, arrangkwe-arle. Tyerrtye Atyinhe areye yanhele anemenge, Israel-arenye areye. Amenge areyele itnenhe apurrkele-anthetyakenhe Goshen-enge. Nhenge unte amenge areye aremele, unte kele itelaretyenhe Ayenge apele, YAHWEH-arle apmere nhenhele anemeke. ");
INSERT INTO aer_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ye, ingwenthe The amenge areye ngkwenge-werne tyerrtye ngkwinhe areye-werne-arlke ilyernpenye yernetyenhe. Nhenge itne arrekantherre-ketye apetyeme, The tyerrtye Atyinhe areye arntarnte-aretyenhe.” ’ Alakenhe renhe anteme Pharaoh-eke angkaye.” Moses-ele Pharaoh iletye-alheke anthurre YAHWEH-ele amenge areye ikwere uthene tyerrtye Ikwerenhe areye utheneke yernetyeke aneme. ");
INSERT INTO aer_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","YAHWEH-ele amenge atningke anthurre itneke yerneke arratye. Itne apmere Pharaoh-kenhe warrkene ikwerenhe-kenheke-arlke kwene-werne alkereke-irrenheke. Amenge atningke anthurre Egypt ikwerele aneke, itne tyerrtye areye, ahelhe-arlke akurne-anthurre-ilemele. ");
INSERT INTO aer_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Pharaoh anteme Moses uthene Aaron utheneke antangkelheke. Nhenge ratherre apetyekenge re ikwere-atherre angkeke, “Yewe, mpwele-arle tyerrtye mpwele-kenhe areye uthene kwenhe kere itemele Ngkarte anthetyeke apmere ahelhe nhenhe ikwerele.” ");
INSERT INTO aer_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Moses ikwere angkirtneke, “Nthakenhe-ame alakenhe? Anwerne apeke pweleke atweme, itnenhe apeke itemele YAHWEH-eke anthemele, Egypt-arenye areyele anteme anwernenhe areme, itne anwerneke ahele anthurre irretyenhe, anwerne-arle pweleke yanhe areye atwerlenge. Itne anwerneke angkeme, ‘Aye! Iwenhenge-arle-ame arrantherre pweleke atweme? Itne kwenhe anwerneke ameke-ameke. Anwerne kwenhe itnenhe tnakeme!’ Ikwere-iperrele itne apwerte areye inemele wetyenhe anwernenhe irrerlkngeke-ante! ");
INSERT INTO aer_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Alakenhe ikwerenge anteme anwerne nhenhe ikwerele kere YAHWEH-eke itetyakenhe. Alakenhe mpwaretyeke anwerne ingkele apmere ahurratye-werne alhetyeke arlte urrpetyeke. Yanhe ikwerenge anteme anwerne kere Ikwere itetyenhe. Alakenhe renhe YAHWEH-ele anwernenhe mpwaretyeke ileke.” ");
INSERT INTO aer_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Kenhe Pharaoh akenhe Moses-eke angkirtneke, “Yewe, unte-arle tyerrtye ngkwinhe areye uthene apmere nhenhe impaye apmere ahurratye-werne alhemele. Arlenge anthurre-werne alhetyalaye. Itwe-ulkere ware-werne alhaye nhenge arrantherre kere renhe YAHWEH-eke itetyenhenge. Urreke arrantherre alhetyenhenge, unte Renhe apayuthneye amenge areye anwerne-ngentyele Re yernirtnetyenhenge?” ");
INSERT INTO aer_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Moses ikwere angkeke, “Yewe, The ngenhe impeme anteme. Ayenge YAHWEH-eke angketyenhenge. Ingwenthe-arle amenge areyele ngenhe impetyenhe warrkene areye-arlke, tyerrtye ngkwinhe areye-arlke. Ayenge awaye! Anwerneke awethe urrtyirremele iletyalaye! Anwerne-ketye mwernte-iletyale, anwerne kwenhe apmere ahurratye-werne alhetyeke kere YAHWEH-eke itetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Ikwere-iperrele anteme Moses-ele Pharaoh impemele alheke, YAHWEH-eke anteme re angkeke. ");
INSERT INTO aer_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","YAHWEH-ele aweke Moses angkerlenge. Arlte arrpenhele anteme Re angeme areye Pharaoh-ngentyele aywepeke, warrkene areyenge-arlke tyerrtye Pharaoh-kenhe areye-ngentyele-arlke. Amenge anyente-arle apeke yanhe ikwere akwete anetyakenhe aneke, itne ingkirreke anthurre alheke. ");
INSERT INTO aer_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Kenhe Pharaoh akenhe awethe-anteye ikerlte-irreke. Re ahentye akngarte-iwelhemele itnenhe mwernte-ileke alheme-ketyenge-tetye. ");
INSERT INTO aer_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","YAHWEH Moses-eke angkeke, “Pharaoh-eke angketyeke alhaye, ikwere angke, ‘Alakenhe nhenhe kwenhe YAHWEH, Ngkarte-arle Hebrew areye-kenhe anemeke, ngkwenge angkeme, “Tyerrtye Atyinhe areye kwenhe apmere ahurratye-werne alhetyeke ahentye-aneme Ayenge utyernetyeke tnakewarremele. Itne-ketye mwernte-iletyalaye!” ’” ");
INSERT INTO aer_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ikwere-iperrele anteme Moses Pharaoh-eke alhemele angkeke, “Unte apeke Israel-arenye areye mwernte-ileme akwete, itnenhe ipmentye aywepetyakenhele, ");
INSERT INTO aer_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","YAHWEH-ele pweleke arrekantherrenhe areyeke akurne-anthurre-iletyenhe, nanthe areyeke, tangkeye areyeke, kamule areyeke, nanikute areyeke, yepe-yepe ingkirreke anthurreke-arlke apmere Egypt nhenhe ikwerele. Itne ingkirreke rlkerte-irremele ilwetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Kenhe atnunthe Israel-arenye areye-kenhe YAHWEH-ele itnenhe mwantyele arntarnte-aretyenhe. Anyente akweke rlkerte-irretyakenhe anthurre anetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Yewe, YAHWEH atyenge angkeke ingwenthele Re atnunthe areye irrerlknge atwetyenhe, itne ilwetyenhenge anteme.” ");
INSERT INTO aer_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Arlte arrpenhele YAHWEH-ele atnunthe ingkirreke Egypt-arenye areye-kenhe irrerlknge atweke arratye, Moses-ele ikwere arrwekele ileke-arle-arteke. Atnunthe areye ingkirreke anthurre ilweke. Kenhe atnunthe Israel-arenye areye-kenhe ilwetyakenhe aneke. Anyente akwekeke arrangkwe. ");
INSERT INTO aer_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Nhenge Pharaoh-ele aremele pweleke areye ilwetyamenge, re artwe ikwerenhe areye yerneke Goshen-werne alhetyeke tyerrtye Israel-arenye areye-arle anekeke-werne. Itne yanhe ikwere-werne alhemele areke pweleke Israel-arenye areye-kenhe itethe akwete. Itne Pharaoh-eke iletye-alpeke. Re akenhe ikerlte akwete aneke. Arratye anteme re nhenge alhileke-arle tyerrtye Israel-arenye areye apmere arrangkethe ikwere-werne ipmentye aywepetyeke, re ahentye akngarte-iwelhemele itnenhe mwernte-ileke alheme-ketyenge-tetye. ");
INSERT INTO aer_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Ikwere iperrele, YAHWEH Moses uthene Aaron utheneke angkeke, “Mpwele arlpmenye ure-ngentyele inerraye. Moses, unte arlpmenye renhe alkere-werne atheke iwaye nhenge Pharaoh-ele ngenhe aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Arlpmenye re ulpmernte-arteke-werne akngarte-iwelhetyenhenge, rlkele anteme re apmere arrpe-anenhe Egypt-werne atheke wernetyenhe. Ahelhe urlpmerntele Egypt-arenye areyeke-arleke atnunthe areyeke-arleke arrernelhetyenhe, itne anteme artwekere-ante anetyenhenge. Artwekere itne akngerre-anthurre-irretyenhe, tyerrtye ingkirreke itnekenhe artwekere-ante anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Ikwere-iperrele anteme, Moses uthene Aaron uthene alherreke arlpmenye ure-ngentyele inetyeke. Ratherre alherreke Pharaoh-nge arrekwele tnerle-anerreke. Ikwere-iperrele Moses-ele arlpmenye alkere-werne atheke iweke. Egypt-arenye ingkirreke atnunthe itnekenhe areye-inpe artwekere akngerre irreme. Itne ingkirreke anthurre aterlkemele. ");
INSERT INTO aer_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Egypt-arenye ingkirreke artwekere akngerre irreke ngangkere areye-arlke. Ngangkere areye Moses-enge arrwekele tnetyakenhe aneke itne-arle artwekere-akerte rlkerte aneke anteye, tyerrtye arrpenhe ingkirreke-arteke apmere Egypt-ele. ");
INSERT INTO aer_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Kenhe Pharaoh akenhe ikerlte-irrerlenge awethe anteye YAHWEH-nge ware. Re Moses uthene Aaron uthene awetyakenhele aneke. Alakenhe renhe YAHWEH ikwere-atherre arrwekele angkeke, Pharaoh re awethe anteye ikerlte-irretyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","YAHWEH Moses-eke angkeke, “Ingwenthe ingweleme akeme-irraye Pharaoh aretyeke alhaye. Alakenhe kwenhe ikwere angke, ‘Nhenhe kwenhe YAHWEH, Ngkarte-arle Hebrew areyeke anemeke, ngkwenge angkeme, “Tyerrtye Atyinhe areyele Ayenge tnaketyeke ahentye-aneme apmere arrangkethe ikwerenge. Itnenhe ipmentye aywepaye, itne-ketye mwernte-iletyale. ");
INSERT INTO aer_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Unte apeke itne-ketye akwete anthurre mwernte-ileme, The ngenhe akurne-anthurre-iletyenhe. The ngenhe akurne-iletyenhe warrkene ngkwinhe areye-arlke tyerrtye Egypt-arenye areye-arlke. Unte anteme itelaretyenhenge arrpenhe Ayenge-arteke anetyakenhe aneme. ");
INSERT INTO aer_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ayenge apeke arrwekele ahentye aneke, The arrenhantherrenhe arrengkwelthele kele irrerlknge atwemere, The arrenhantherrenhe akethe-ante arrernemere. ");
INSERT INTO aer_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Kenhe arrangkwe-arle! The ngenhe itethe akwete atnyeneme unte aretyenhenge Ayenge kwenhe lterrke anthurre aneme. The arrenhantherrenhe itethe atnyeneke tyerrtye apmere arrpe-anenhele ayeye Atyenge-akerte iletyenhenge nhenge itne arritnye Atyinhe awemele. ");
INSERT INTO aer_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Kenhe unte akenhe tnakelheme. Unte kwenhe tyerrtye Atyinhe areyeke ahele-irrerle-aneme. Unte kwenhe itne-ketye akwetethe anthurre mwernte-ilerle-anemele, nhenge itne apmere Egypt-ele anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Ayenge awaye! Ingwenthe the kwatye apweteke yernetyenhe arne areye ingkirreke ataketyeke. Tyerrtye Egypt-arenye areyele arne alakenhe arrwekelenge aretyakenhe aneke, arrangkwe-arle! ");
INSERT INTO aer_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Yewe, warrkene ngkwinhe areye apmere arrpe-anenhe-werne yernaye. Itnenhe pweleke areye apurtelhe-iletyeke ilaye atnunthe arrpenhe areye-arlke ahelhe akethele-arle anemeke. Itne itnenhe warle kweneke apeke arrernetyeke. Ingwenthe apweteke alkere-ngentyele atnyetyenhe. Itne tyerrtye areye-arlke pweleke areye-arlke atwetyenhe ahelhe akethele-arle tnemeke. Angwenhe apeke ahelhe akethele tnerlenge ilwetyenhe-anteye.” ’ Moses-aye, alakenhe renhe unte Pharaoh-eke ilaye.” ");
INSERT INTO aer_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Ikwere-iperrele anteme Moses-ele Pharaoh-eke iletye-alheke nthakenhe-arle YAHWEH angkeke-arle. Warrkene Pharaoh-kenhe areyele aweke Moses angkerlenge. Tyerrtye arrpenhe areye-inpele Moses mwantye anthurre awetyame, itne YAHWEH-ketye atere-irrerirreke. Itne warrkene areye iparrpe anthurre apmere kwene-werne akngeke pweleke areye-arlke. ");
INSERT INTO aer_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Kenhe warrkene Pharaoh-kenhe arrpenhe areye akenhe, akwenpele aweke Moses angkerlenge itnenhe ilemele iwenhe apeke renhe YAHWEH-ele renhe arrekwele ilerlenge-arle. Itne warrkene arrpenhe areye-arlke pweleke areye-arlke warle kwene-werne akngetyakenhele aneke, arrangkwe-arle. Itne itnenhe ahelhe aketheke impeke. ");
INSERT INTO aer_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Ikwere-iperrele anteme YAHWEH Moses-eke angkeke, “Iltye ngkwinhe alkere-werne atheke akertne-ilaye. The anteme apweteke kwene-akerle Egypt-werne-atheke iwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","24","Kenhe Moses-ele akenhe atneme ikwerenhe ineke arratye, renhe alkere-werne atheke thileke. YAHWEH-ele anteme apweteke ahelhe-werne yerneke. Kwatye akngerre anteme angkeme, alharrkentye anteme apweteke akngerre-anteme Egypt-eke atnyetyame. Ye, arratye anthurre nhenhe-arle. Kwatye apweteke atningke anthurre ahelheke atnyeke. Urreke nhenhe anetyenhenge, nhenhe-arteke Egypt-arenye areyele aretyakenhe aneke apmere yanhe ikwerele kwatye alakenhe urnterlenge-arteke. ");
INSERT INTO aer_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Kwatye apwetekele arne ingkirreke anthurre atakeke akethele-arle anemeke. Re tyerrtye areye, pweleke areye-arlke ingkirreke akethe-ante arrerneke akethele-arle tnekeke. Kwatye apwetekele merne wheat akurne-ileke yanhele-arle lyapemeke, arne ingkirreke atakeke yanhele-arle lyapemeke. ");
INSERT INTO aer_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Kenhe apmere yanhe Goshen-ele, nhenge tyerrtye Israel-arenye areyele aneke kwatye apweteke atnyetyakenhe aneke, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Pharaoh anteme Moses uthene Aaron utheneke antangkeke. Ratherre nhenge apetye-alherrerlenge, re ikwere-atherre angkeke, “Ayenge urrernaye ware kwenhe! Ayenge YAHWEH-ketye aneme. YAHWEH kwenhe anyente-arle arratye aneme, ayenge-arteke anetyakenhe. The tyerrtye atyinhe areyele-inpe arrenhantherrenhe Egypt-ngentyele ipmentye aywepetyeke arrantherre-ketye mwernte-iletyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Ayekeye! Atyenge YAHWEH-eke angkaye. Renhe apayuthnaye apweteke uthene kwatye alharrkentye uthene uyerrelhe-iletyeke. Re kwenhe anwernenhe akurne-ileme. Tyerrtye ngkwinhe areye apeke ahentye-aneme Egypt impetyeke, the itne-ketye awethe mwernte-iletyakenhe anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Kenhe Moses akenhe Pharaoh-eke angkeke, “Ayenge kwenhe apmere nhenhenge arratetyenhe. Ayenge nhenge alhemele, ayenge iltye akertne-irretyenhe YAHWEH ngkwenge apayuthnetyenhe. Re-anteme kwatye apweteke nhenhe uyerrelhe-iletyenhe. Re apweteke arrekantherre yernetyakenhe anetyenhenge arrantherre kwatye angkerlenge awetyakenhe. Ikwerenge anteme, unte itelaretyenhenge ahelhe nhenhe-arle YAHWEH-kenhe aneme. ");
INSERT INTO aer_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ayenge apele, the itelareme unte-arlke warrkene ngkwinhe areye-arlke YAHWEH-ketye atere anetyakenhe aneme akwete.” ");
INSERT INTO aer_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Nhenhe ikwerele ureke, arne atherrke-arteke arrpenhe areye flax ileme Egypt-nge itne antethe-akerte tneke. Annge ntange arrpenhe areye barley ileme mpenge aneke tyerrtye areyele aketyeke aneke. Nhenge kwatye apweteke ahelheke alkere-ngentyele atnyemele, itne flax uthene merne barley uthene akurne-ileke. ");
INSERT INTO aer_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Annge ntange arrpenhe areye wheat uthene spelt uthene ileme itne akwete lyapetyame, mpenge anetyakenhe akwete. Kwatye apweteke itneke-arleke-anteye atnyeke, itnenhe akenhe akurne-iletyakenhe. Itne akwete lyapetyame tyerrtye areyele uthnetyeke. ");
INSERT INTO aer_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Nhenge Moses-ele Pharaoh-nge impemele alheke, re apmere ikwerenge-ntyele arrateke. Re iltye atherre alkere-werne-atheke akertne-irreke, YAHWEH-eke angketyeke. Kwatye uyerreke kwatye apweteke-akertele aneke alharrkentye uyerreke anteye. ");
INSERT INTO aer_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Pharaoh-ele areke alakenhe re irrelenge. Arrangkwe akwete, Re arratye mpwaretyakenhe akwete aneke. Re awethe ikerlte-irreke, warrkene ikwerenhe areye ikerlte anteme irrerlenge. ");
INSERT INTO aer_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Ye, Pharaoh-arle ikerlte-irreke, re Israel-arenye areye-ketye mwernte-ileke Egypt impemele alheketye. Alakenhe re YAHWEH arrwekele angkeke-arle, Pharaoh re akwete anthurre ikerlte anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","YAHWEH anteme Moses-eke angkeke, “Pharaoh-eke angketyeke alhaye. The kwenhe renhe warrkene ikwerenhe areye-inpe ikerlte-iletyeke. The itnenhe ikerlte-ileke The itneke imernetyeke the arne areye ilyernpenye anthurre mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","The itnenhe ikerlte-ileke unte ampe ngkwinhe areye, atyemeye uthene arrenge uthene areye atyenge-akerte iletyenhenge ayenge Egypt-arenye areyeke anhelhetyarte itneke imerneke nthakenhe-arle the arne areye ilyernpenye anthurre mpwarekeke. Arrantherre anteme itelaretyenhe Ayenge apele YAHWEH aneme.” ");
INSERT INTO aer_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Kele Moses uthene Aaron uthene anteme Pharaoh renhe aretyeke alheke. Ratherre apmere akngerre kwene-werne irrpenheke, ikwere angkemele, “Alakenhe kwenhe YAHWEH Ngkarte anwerne-kenhe ngkwenge angkeme, ‘Unte-ame Atyenge untyemurle anetyenhe arlengeke-atwetye nhenge Ayenge ngkwenge angkerle-anemele? Ayenge kwenhe tyerrtye Atyinhe areye apmere arrangkethe-werne alhetyeke ahentye-aneme itne ayenge yanhe ikwerele utyernemele tnakewarretyenhenge. Itne-ketye mwernte-iletyale! ");
INSERT INTO aer_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Unte apeke atyenge-ketye ayene-ilelheme unte apeke tyerrtye Atyinhe areye-ketye mwernte-ilemele, The inteltye atningke anthurre apmere arrekantherrenhe-werne yernetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Inteltye areye anetyenhe apmere apanpele Egypt-nge anetyenhe. Itne ahelhe-ante artetyenhe. Tyerrtye areyele ahelhe aretyakenhe anetyenhe. Nhenge kwatye apweteke alkere-ngentyele atnyeke, wheat lyapetyakenhe aneke. Lyete annge ntange akweke ware anteme lyapirtneme. Yewe, nhenge inteltye areye apetyelenge, itne wheat ingkirreke akurne-iletyenhe lyapeme-ketye. Itne arlpelhe ingkirreke arne-ngentyele arlkwetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Inteltye atningke apmere ngkwinhe kweneke irrpenheme warrkene ngkwinhe areye-kenheke-arlke. Inteltye areye apmere Egypt-arenye areye-kenheke-arlke irrpenhetyenhe. Arrekwelenye arrekantherrenhe akngerrepate areye, apmere nhenhele-arle arrule anekeke, kele ilweke-arle areye anekeke, itne kwenhe inteltye alakenhe arrwekelenge aretyakenhe, arrangkwe-arle. Arrpenhe akwele Egypt-arenyele inteltye atningke anthurre nhenhe-arteke arrwekelenge aretyakenhe aneke, arrangkwe-arle.’” Alakenhe Moses-ele Pharaoh renhe ileke, re anteme alheke. ");
INSERT INTO aer_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Warrkene Pharaoh-kenhe areye ikwere angkeke, “Artwe nhenhe Moses kwenhe anwerneke anhelheme. Re kwenhe arne ingkirreke nhenhele akurne-anthurre-ileme! Iwenhenge-arle-ame unte renhe akwete ayene-ilelheme? Artwe Israel-arenye areye apmere nhenhe-ngentyele yernaye itne nhenge alhetyenhenge YAHWEH Ngkarte itnekenhe utyernemele tnaketyeke apmere arrangkethe ikwerele.” ");
INSERT INTO aer_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Kenhe warrkene areyele Moses uthene Aaron uthene inetyeke alhemele arratye, renhe-atherrenhe Pharaoh-werne akngetye-alpemele. Re ikwere-atherre angkeke, “Yewe, mpwele apeke YAHWEH Ngkarte mpwele-kenhe arratye tnaketyeke ahentye-aneme, kele alherraye! The arrenhantherrenhe-ketye mwernte-iletyakenhe anetyenhe. Nthakentye-ame arrantherre apmere arrangkethe ikwere-werne alhetyenhe?” ");
INSERT INTO aer_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Moses ikwere angkirtnerlenge, “Anwerne ingkirreke anthurre alhetyenhe, artwe apmerrke areye, artwe ampwe areye, arelhe uthene artwe uthene, yepe-yepe areye, pweleke areye-arlke. Nhenge anwerne yanhe ikwere-irretye-alhemele anwerne arrawe-irrentye akngerre atnyenetyenhe, anwerne YAHWEH utyernemele tnakewarretyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Pharaoh Moses-eke angkeke, “Arrangkwe! Unte kwenhe alakenhe angkeme ahele-ahele aketyeke, apmere nhenhe-ngentyele anwerne-ketyenge aterarlpe untetyeke. Ayenge apale awetyale-aye, ayenge-arle arrekantherre mwerre anetyakenhele anetyenhe, arrangkwe anthurre-arle! YAHWEH-ele apeke arrenhantherrenhe arntarnte-aretyenhe. Apekaye, ayenge akutne anthurre! Unte apeke arelhe uthene ampe areye uthene ngkwengenge akngetyeke ahentye-aneme? Arrangkwe-arle! The itne-ketye mwernte-ileme. ");
INSERT INTO aer_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Arrangkwe! Unte, artwe areye ware-inpe apmere arrangkethe ikwere-werne alhetyeke YAHWEH renhe tnaketyeke. Alakenhe ikwere ware unte ayenge apayuthnetyame.” Artwe Pharaoh-kenhe areyele Moses uthene Aaron uthene apmere Pharaoh-kenhe-ngentyele tyerrelhe-iletyeke. ");
INSERT INTO aer_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","YAHWEH anteme Moses-eke angkeke, “Iltye akertne-irraye Egypt-werne-atheke thilaye. Inteltye atningke anteme apetyeme, itne apmere apanpele Egypt-nge. Nhenge itelareme kwatye apweteke alkere-ngentyele atnyeke, re akurne-ileke name atherrke ingkirreke arne ingkirreke-arlke. Name atherrke areye lyete-atheke lyapirtneme. Inteltye yanhe areye apetyemele name atherrke ingkirreke arlpelhe ingkirreke arne-ngentyele arlkwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Moses-ele atneme ikwerenhe ineke arratye re thileke ingkirreke renhe apmere Egypt-ele. YAHWEH-ele anteme rlke akngerre anthurre ikngerre-ngentyele yerneke. Rlke akngerrele arltele-akake, ingwele-akake werneke. Arlte arrpenhele anteme uterne arratintyeke, rlkele inteltye atningke anthurre akngetyeke. ");
INSERT INTO aer_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Inteltye areye alkereke-irrereke arrtyarnpemele apmere arrpe-anenhe Egypt-nge. Arrwekelenge alakenhe aretyakenhe aneke inteltye atningke anthurre nhenhe-arteke. Lyete-arlke renhe itne alakenhe aretyakenhe, arrangkwe-arle! ");
INSERT INTO aer_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Inteltye areye ahelhe arrpe-anenhe ikwerele arrtyarnpetyame, itne ahelhe urrperle anthurre ilemele. Nhenge kwatye apwetekele alkere-ngentyele atnyemele, ikwere-iperrele arne areye lyapirtneke. Inteltye areyele akenhe arlkweke name atherrke ingkerrenyeke, arlpelhe arne-ngentyele-arlke, merne arnele aneke anteye. Itne ingkirreke anthurre arlkweke. Egypt-ele aneke name atherrke-arlke, arne-arlke anetyakenhe anthurre, arrangkwe! ");
INSERT INTO aer_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Pharaoh anteme Moses uthene Aaron utheneke antangkeke. Nhenge ratherre renhe aretyeke alheke, re ikwere-atherre angkerlenge “Ayenge kwenhe YAHWEH-eke, Ngkarte mpwele-kenheke, apale angkerne. The kwenhe mpwelenhe awetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Ayenge ilpernetyakenhe anaye, ayenge arriletyale anaye. Mpwele YAHWEH Ngkarte mpwele-kenhe apayuthnaye inteltye nhenhe areye anwerne-ngentyele akngetyeke, anwerne ingkirreke anthurre ilweme-ketye!” ");
INSERT INTO aer_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Kele Moses-ele Pharaoh renhe imperle-alheke arratye. Re-anteme YAHWEH-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Rlkele inteltye areye-arle akngetyekeke, re ikngerre-ngentyele apetyeke. Nhenge YAHWEH-ele aweke Moses angkerle-anerlenge re rlke renhe akngarte-iweme alturle-ngentyele anteme rlkele wernerlenge. Rlkele inteltye areye werneke itnenhe kwatye alayeke iweke. Kele anteme inteltyeke arrangkwe anthurre aneke Egypt-nge. ");
INSERT INTO aer_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Ikwere-iperrele anteme YAHWEH-ele akwete anthurre Pharaoh ayakeke tyerrtye Israel-arenye areye Egypt-ngentyele yerneme-ketye, Re ikerlte akwete anekenge. ");
INSERT INTO aer_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","YAHWEH anteme Moses-eke angkeke, “Iltye ngkwinhe alkere-werne atheke akertne-irraye, Egypt ingwemerte-irretyenhenge. Tyerrtye areye alknge pwenge-arteke unthetyenhenge. Itne anpelpe-anpetyenhenge nhenge nthenhe-werne atheke-arle alhetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Moses iltye ikwerenhe alkere-werne atheke akertne-irreke arratye, Egypt ingkirreke anthurre ingwemerte-irrerlenge. Ingwemerte aneke arlte urrpetyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Tyerrtye areye arerretyakenhe aneke nhenge ingwemerte anthurre-arle anekenge. Arlte urrpetyeke-atwetye Egypt-arenye areye akethele unthetyakenhe aneke, arrangkwe. Itne aretye-arlke-akenhe anthurre aneke. Kenhe Israel-arenye areyele akenhe arlte akwete atnyeneke. ");
INSERT INTO aer_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Pharaoh anteme Moses-eke antangkelheke. Re nhenge apetyerlenge, Pharaoh ikwere angkeke, “Yewe, nhenge arrantherre apeke akwete ahentye aneme YAHWEH utyernemele tnaketyeke kele alherlte-iwaye! The arrekantherre-ketye mwernte-iletyakenhe. Arelhe uthene ampe areye uthene akngaye. Kenhe yepe-yepe areye, nanikute areye-arlke, pweleke areye-arlke nhenhe ingkerneke imperlte-alhaye.” ");
INSERT INTO aer_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Kenhe Moses akenhe Pharaoh-eke ahele-irreke, “Arrangkwe, anwerne yepe-yepe, nanikute anwerne-kenhe areye ingkerneke impetyakenhe! Anwerne itnenhe akngemele nhenge anwerne itnenhe itetyenhenge YAHWEH anthetyeke. ");
INSERT INTO aer_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Anwerne pweleke ingkirreke akngetyenhe anteye. Anwerne anyente anthurre impetyakenhe anetyenhele, arrangkwe-arle. Anwerne itnenhe itetyeke YAHWEH anthetyeke anwerne Renhe utyernemele tnaketyeke. Anwerne akutne aneme nthenhe-ante-nthenhe anwerne Ikwere itetyeke. Nhenge anwerne apmere yanhe ikwere irremele, YAHWEH-ele anwernenhe iletyenhe nthenhe-ante-nthenhe Ikwere itetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Kenhe YAHWEH-ele Pharaoh ayakeke Israel-arenye areye yerneme-ketye, re ikerlte akwete anekenge. ");
INSERT INTO aer_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Pharaoh anteme Moses-eke angkeke, “Apmere nhenhe-ngentyele alhaye apetyalpetyale anaye. Unte apeke atyenge-werne apetyalpeme unte ilwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Moses ikwere angkirtnerlenge, “Mwerre, unte ayenge alhetyeke ileme. Ayenge kele alheme. Ayenge apetyalpetyakenhe aneme ngenhe awethe aretyakenhe.” ");
INSERT INTO aer_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","YAHWEH Moses-eke angkeke, “The Pharaoh uthene Egypt-arenye areye uthene anyente-ngare awethe akurne-iletyenhe. Ikwere-iperrele anteme re arrenhantherrenhe Egypt-ngentyele yernetyenhe. Nhenge Pharaoh-ele apeke arrenhantherrenhe apmere arrangkethe ikwere-werne yernerlenge, re arrenhantherrenhe ingkirreke anthurre alhetyeke uternetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Tyerrtye Israel-arenye areyeke angketyeke alhaye, artwe uthene arelhe uthene areyeke. Itnenhe ilaye Egypt-arenye areye silver uthene gold utheneke apayuthnetyeke.” Alakenhe renhe YAHWEH Moses-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Arrwekele ulkere, Egypt-arenye areye Israel-arenye areyeke ahentye anthurre anetyakenhe anetyarte itneke anhelhemele. Kenhe YAHWEH-ele akenhe Egypt-arenye areye uterneke itnenhe tnaketyeke. Artwe Pharaoh-kenhe areye uthene Egypt-arenye areye uthenele itelareke Moses artwe akngerrepate anekenge. ");
INSERT INTO aer_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Ikwere-iperrele Moses Pharaoh-eke ahele angkeke alhemele, “Alakenhe kwenhe YAHWEH ngkwenge angkeme, ‘Lyete ingwele Ayenge Egypt-nge untherle-apeme. ");
INSERT INTO aer_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Nhenge ayenge untherle-apemele, nhenhe ikwerele ureke, ampe urreye akweke arrekwelenye areye ilwetyenhenge. Alere arrekwelenye Pharaoh-kenhe ilwetyenhe anteye. Ampe urreye akweke arrekwelenye arelhe warrkene areye-kenhe ilwetyenhe anteye. Arrekwelenye areye-arlke pweleke areye-kenhe, itne ilwetyenhe anteye. ");
INSERT INTO aer_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Arlte ikwerenge anteme Egypt-arenye areye akayale irrerlte-aneme alhwarrpe anthurre anerrirretyenhe. Itne arrwekele-arle alakenhe akayale irrerlte-anetyakenhe aneke. Itne alakenhe awethe akayale irrerlte-anetyakenhe anetyenhe, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Nhenhe ikwerele ureke, Israel-arenye areye mwerre anthurre anetyenhe, akayale irrerlte-anetyakenhe aneme. Kenhe arrantherre awetyakenhe akngwelye anyente anthurre arrangkerlenge apmere Israel-arenye areye-kenhe. Ikwere-iperrele Pharaoh-ele itelaretyenhe Tharle, YAHWEH-ele, Israel-arenye areye arntarnte-areme, Egypt-arenye areye-arteke anetyakenhele.’ Alakenhe renhe YAHWEH ngkwenge angkeme. ");
INSERT INTO aer_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Ikwere-iperrele anteme warrkene ngkwinhe areye apetyetyenhe atyengenge arrwekele artepe-arrernelhemele. Itne atyenge angketyenhe, ‘Moses nhenhe-ngentyele alhaye, tyerrtye ngkwinhe areye-arlke akngaye, ingkirrekele ngenhe-arle awemeke ngenhe-arle apentemeke.’ Alakenhe renhe itne atyenge angketyenhe. Nhenge itne apeke atyenge alakenhe angkemele, the itnenhe impemele alhetyenhe.” Kele imerte Moses impemele alheke ahele anthurre awelhemele! ");
INSERT INTO aer_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Ikwere-iperrele anteme, YAHWEH Moses-eke angkeke, “Pharaoh-ele ngenhe awetyakenhele anetyenhe. Alakenhe ikwerenge anteme The Egypt-arenye areyeke imernetyenhe The arne ingkirreke ilyernpenye anthurre mpwaretyeke itne anteme itelaretyenhenge Ayenge-ante ware apele Ngkarte aneme.” ");
INSERT INTO aer_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Arratye apelaye, Moses uthene Aaron uthenele Pharaoh-eke akwete imernetyarte YAHWEH kwenhe lterrke anthurre aneme nhenge Re Egypt-arenye areye akurne anthurre iletyarte. YAHWEH-ele akwetethe anthurre Pharaoh ayaketyarte Israel-arenye areye Egypt-ngentyele yerneme-ketye. Re ikerlte akwete aneke itnenhe yernetyakenhe akwete aneke. ");
INSERT INTO aer_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","2","YAHWEH Moses uthene Aaron utheneke angkeke, “Lyete nhenhe-ngentyele, nhenge atnyentye arrekwele arraterlenge arrantherre atnyentye nhenhe “Abib” arritnye anthetyenhe, re kwenhe atnyentye arrekwelenye uterne arrpenheke anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Mpwele Israel-arenye areyeke angketyeke alherraye, itneke alakenhe ilaye, ‘Anwerneke akarelhaye arlte ten-eke-atwetye. Ikwere-iperrele anteme, artwe arrantherre ingkirreke alherlte-iwaye yepe-yepe akwerrke artweyangkweke inetyeke arrpenhe areye-arle apmere arrekantherrenhe-arrpele anentye akngerre artweyangkwe areyenge. ");
INSERT INTO aer_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Nhenge urrpetye apeke ware artweke-artweye-arrpe aneke, itne apeke kere ingkirreke arlkwetyakenhe aneme-ketye. Akurne kwenhe alakenhe. Alakenhe-irreketye, artwe yanhe apeke anyenhenge arrpenhe areyenge apurte-irretyeke itweke-itweke-arle anemeke itne akenhe kere ingkirreke yanhe arlkwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Iwenhe-arteke yepe-yepe-ame artwe arrantherre akngaketyenhe? Yepe-yepe re uterne anyente anetyeke, urreye aneme anteye, mwerre-anteye rlkerte kwenye. Arrantherre apeke yepe-yepe uyarne areme, nanikute akwerrke-tetye inaye. ");
INSERT INTO aer_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Nhenge arrantherre-arrpe yepe-yepe inerlenge, itnenhe itethe akwete atnyenaye arlte 4 arrpenheke-atwetye. Ikwere-iperrele anteme, nhenge arlennge irrperlenge, arrantherre Israel-arenye areye yepe-yepe uthene nanikute uthene alywekele irrerlknge atwetyeke artweyangkwe areyeke. ");
INSERT INTO aer_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ikwere-iperrele anteme arrantherre alhwele arriwe akertne apernetyeke arriwe itereke-arleke anteye apmere areyele arrantherre-arle kere itemele yepe-yepe arlkwemele. ");
INSERT INTO aer_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Ingwe ikwerele-anteye, arrantherre yepe-yepe urele itetyeke. Arrantherre kere renhe arlkwetyeke arlpelhe irrkerteyenge merne arlware-irrentye kwenye. ");
INSERT INTO aer_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Arrantherre kere arletye arlkwetyale anetyeke, kere renhe kwatyele itetyale anetyeke, arrangkwe-arle. Kere renhe urele itaye akaperte-arlke, ingke atherre-arlke, atnerte-arlke. ");
INSERT INTO aer_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Ingkerreke anthurre arlkwaye. Kere ampenye apeke yanhe akwete anerlenge impaye, arlkwetyale anaye. Nhenge arlennge arraterlenge, kere ampenye ureke arrernaye arlpmenye-irretyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","12","‘Alakenhe re kwenhe kere renhe arlkwetyeke: Urreke arrantherre arlkwetyenhenge, arrantherre mantere arrekantherrenhe irrpetyeke-amparre ingke-kenhe-arlke. Atneme arrekantherrenhe inaye arrantherre-arle alhetyeke atyepe-atyepe-irreme-arteke. Kere uthene merne uthene renhe iparrpe arlkwaye. Nhenge arrantherre alakenhe-arteke mpwareme arlte renhe “Passover” arritnye anthetyeke. Passover ileme “Alkere-arenyele anwernenhe irrerlknge atwetyakenhe aneke, re anpere-irremele.” Ingwe ikwerele-anteye, Ayenge Egypt-nge-arlenge alkereke-irretyenhe. The urreye arrekwelenye irrerlknge atwetyenhe pweleke areye-kenhe-arlke Egypt-nge artweyenhengeke-arleke-arrpe. Ayenge apele YAHWEH. The ngkarte urrtyirrentye itnekenhe artimperre-iwetyenhe yanhe areye Egypt-arenye areyele-arle apwerte-ngentyele arne-ngentyele mpwarekeke itne-arle apentemeke. ");
INSERT INTO aer_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Alhwe yanhe arriwele-arle anemeke impatye-arteke, nhenge The alhwe arriweke aremele Ayenge itnekenge akertnele alkereke-irrenheme, itnekenge anpere-irremele, The arrenhantherrenhe atwetyakenhe aneme. The akenhe Egypt-arenye areye-ante ware atwetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","Lyete-ngentyele, nhenge arrantherre arlte nhenheke itirremele arrantherre renhe akwete-ante itelaremele. Uterne arrpe-anenhele nhenge atnyentye akwerrke arraterlenge, anwerne-arle Abib ilemeke, arrantherre artweyangkwe areyele-arlke Passover arlkwetyeke Ayenge tnakewarretyeke. Yewe, ampe ngkwinhe areye, ampeke-artweyekartweyele Ayenge akwete-ante utyernemele tnaketyenhe!’” ");
INSERT INTO aer_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Kele imerte YAHWEH-ele Moses angkentye antheke, nthakenhe-arle-irreme-akerte tyerrtye Israel-arenye areyele arrawe-irrentye yanhe akwetethe itelarerlte-anetyeke, uterne arrpe-anenhele akwete-ante. Re angkeke, “Arrawe-irrentye re anetyenhe arlte seven-eke-atwetye. Nhenhe ikwerele ureke arrantherre merne arlware-irrentye kwenye arlkwetyenhe. Arrantherre merne arlware-irrentye-akerte arlkwetyakenhele anetyenhe. Nhenge arrawe-irrentye re-anteme anerlenge, arlte arrekwele arlware-irrentye akngerre nhenge inaye, apmere ikwerele-arle anemeke, renhe iwaye arlkwetyakenhele. Arrpenhele apeke merne arlware-irrentye-akerte renhe arlkwerlenge arlte arrawe-irrentye ikwerele ureke, artwe yanhe renhe akwete-ante aywepetyeke. Tyerrtye re kwenhe Atyinhe anetyakenhe aneme, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Arrawe-irrentye ikwerele ureke, arlte arrekwelenge arlte ingkernenge anteye, tyerrtye areye apurte-irreretyeke Ayenge utyernemele tnaketyeke. Arlte atherre ikwerele ureke, arrantherre warrke-irretyale anetyeke, arrangkwe-arle. Kere ngkwinhe-arrpe itaye, yanhe mwerre-arle. Warrke-irretyale anaye. ");
INSERT INTO aer_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","Arrawe-irrentye nhenhe “Merne Arlware-irrentye-kwenye” akeme. Arrantherre merne arlware-irrentye-kwenye nhenhe renhe arlkwetyeke arrawe-irrentye ikwerele arrantherre nhenge itelaretyenhe The arrenhantherrenhe Egypt-ngentyele akngeke anyenhenge twelve-arle. Lyete-ngentyele ampe arrekantherrenhe areye ampe itnekenhe areyele-arlke arlte nhenhe-akerte itelaretyenhe akwete-ante alkngwirretyakenhele. Nhenhe atywerrenge Atyinhe arrekantherre. Nhenhe renhe akwete-ante apenterlte-anaye. ");
INSERT INTO aer_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Yewe, uterne-arrpe-uterne-arrpe, nhenge atnyentye akwerrke-ipenhe arraterlenge, arlte 14-eke-atwetye akarelhaye. Ikwere-iperrele anteme, akarelhaye uterne irrpetyeke. Ikwere-iperre anteme merne arlware-irrentye kwenye ware arlkwaye. Merne arlware-irrentye kwenye ware arlkwaye arlte seven-eke-atwetye arrawe-irrentye ikwerele. ");
INSERT INTO aer_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","20","Arlte seven ikwerele ureke, arne nhengele merne-arle arlware-ilemeke apmere-ngentyele iwaye. Arrpenhele apeke merne arlkweme arne arlware-ilentye akngerre-akerte nhenge arrawe-irrentyele, tyerrtye yanhe renhe arrekantherre-ngentyele akwete-ante yernaye. Atywerrenge nhenhe tyerrtye Israel-arenye areyeke tyerrtye arrpenhe areyeke-arlke apmere Jew-arenye areye-kenhele-arle anemeke. Arrantherre atywerrenge nhenhe apentewarraye nthenhele apeke arrantherre anepaneme.” ");
INSERT INTO aer_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Ikwere-iperrele anteme, Moses-ele angkentye yerneke artwe akngerrepate Israel-arenye areyeke renhe aretyeke apetyetyeke. Nhenge itne apetyekenge, re itneke angkeke, “Arrantherre-arrpe yepe-yepe akwerrke inaye arrekantherrenhe-arrpeke-artweyenhenge-ke. Itnenhe irrerlknge atwaye nhenge arrantherre kere impene nhenhe arlkwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Nhenge arrantherre yepe-yepe nhenhe renhe irrerlknge atwerlenge, alhwe renhe yepe-yepe-kenhe apantheke-arleke thelaye. Ikwere-iperrele anteme arlpelhe alhwe kweneke-arleke arrernaye. Arlpelhe yanhe areyele arriwe akertnele apernaye itere atherrele anteye. Kele, arrantherre, artweyangkwe areye-inpe kwenele anaye aherrkintyeke. Arratetyale anaye! ");
INSERT INTO aer_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Lyete ingwele YAHWEH untherle-apetyenhe alkere-arenye Ikwerenhe-akerte, Rarle Athewe Ingkerreke Atwentye Akngerre. Apurtele ratherre Egypt-arenye areye irrerlknge atwetyenhe. Nhenge YAHWEH-ele apeke alhwe arriwenge aremele, Re alkereke-irremele anpere irretyenhe arrenhantherrenhe irrerlknge atwetyakenhele. Re ayaketyenhe Alkere-arenye-arle Ingkerreke Atwentye Akngerre, re Israel-arenye areye irrerlknge atwetyakenhe anetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Arrantherre ingkirreke anthurrele atywerrenge nhenhe renhe akwete-ante apenterlte-anaye. Atywerrenge nhenhe arrekantherre aneme ampe arrekantherrenhe areyeke, kartweyekartweyeke. ");
INSERT INTO aer_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Atywerrenge nhenhe renhe apenterlte-anaye nhenge arrantherre apmere arrpenheke irrpetye-alherlenge, apmere yanhe YAHWEH-elarle arrekantherre alhilekeke. ");
INSERT INTO aer_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ampe arrekantherrenhe anyentele alakenhe apayuthnetyenhe, ‘Iwenhenge-arle-ame anwerne kere tyawerrelye nhenhe arlkweme? Iwenhenge-arle-ame anwerne yepe-yepe uthene nanikute uthene nhenhe areye irrerlknge atweme-arteke?’ ");
INSERT INTO aer_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","Nhenge alakenhe apeke itne arrenhantherrenhe apayuthnerlenge, itneke alakenhe angkirtnaye, ‘Kere nhenhe anwerne-arle arlkweme apele YAHWEH tnaketyeke anwernenhe-arle Egypt-ngentyele arratelhe-ilekeke. Ye, anwerne Israel-arenye areye Egypt-ele anerrirretyarte. Nhenge YAHWEH Egypt-ele anpere-irrenhemele, Re Egypt-arenye ingkirreke anthurre irrerlknge atweke. Re apmere anwerne-kenhele alkerele alheke. Re itneke anpere-irremele anwernenhe impeke irrerlknge atwetyale. Re anwernenhe atnyeneke ilweme-ketyenge.’” Nhenge tyerrtye Israel-arenye areyele nhenhe renhe awemele itne ahelhenge amperele-arlenge tneke YAHWEH utyernemele tnakewarreke. ");
INSERT INTO aer_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Kele itne anteme apmere-werne alperlte-iweke. Itne yepe-yepe irrerlknge atweke, arriwe areye alhwele apernemele. YAHWEH-ele itnenhe alakenhe renhe mpwaretyeke ileke. ");
INSERT INTO aer_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Ingwe mpwepele, YAHWEH-ele alere arrekwelenye Egypt-arenye areye-kenhe irrerlknge atweke. Re alere arrekwelenye Pharaoh-kenhe irrerlknge atweke, alere ayernentye akngerre Egypt-arenye areye-kenhe anteye. Re arrwekelenye pweleke-kenhe areye uthene yepe-yepe-kenhe areye uthene irrerlknge-anteye atweke. ");
INSERT INTO aer_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Ingwe ikwerele-anteye, Pharaoh-arle warrkene Ikwerenhe areye-arlke akeme-irrereke. Artweyeke-artweyekele itne alere arrekwelenye aparlpe-ilerrirreke. Alakenhe ikwerenge anteme itne ingkirreke itneke akayale-irremele. ");
INSERT INTO aer_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Nhenge YAHWEH-ele ampe urreye ingkirreke, pweleke areye-arlke irrerlknge atwemele, ingwe ikwerele-anteye Pharaoh Moses uthene Aaron utheneke antangkeke. Itne ikwere-werne apetyeke arteke, re ikwere-atherre angkeke, “Arrantherre Israel-arenye areye-aye alherlte-iwaye, anwernenhe impeyewe! Arrantherre apmere arrangkethe ikwere-werne alhetyeke YAHWEH renhe utyernemele tnaketyeke. ");
INSERT INTO aer_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Yepe-yepe ingkirreke akngaye, nanikute, tangkeye, pweleke areye-arlke. Itnekenge-arlke apmere arrangkethe ikwere-werne alherlte-iwaye. YAHWEH apayuthnaye ayenge-inpe arntarnte-aretyeke.” Alakenhe renhe Pharaoh Moses uthene Aaron utheneke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Egypt-arenye areye anteme Israel-arenye areyeke angkeke, “Arrantherre apeke Egypt-nge anetyeke aneke alhetyakenhele, anwerne ingkirreke ilwetyenhenge! Alakenhe-irreme-ketye, iparrpe-ante alherlte-iwaye!” ");
INSERT INTO aer_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kenhe Israel-arenye areyele kele-arle merne ulpmenthe kwatyenge anyentelhe-ileke, itne arne arlware-ilentye akngerre ikwere-arleke arrernetyakenhele aneke, arrangkwe-arle. Itne merne ulpmenthe kwatye apantheke-arleke anyentelhe-ileke. Nhenge Egypt-arenye areyele ileke Israel-arenye areyele apmere renhe impemele alhetyeke, anyenteke-anyentele Israel-arenye areyele merne urrknge inemele renhe ayernemele urtneke-arleke akwernemele, itne pwerlepeke-arlenge akngernetyeke. ");
INSERT INTO aer_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Ikwere-iperrele anteme itne Egypt-arenye areye apayuthneke, yanhe areye-arle itneke-arlenge itwele anetyarteke, silver-eke, gold-eke, mantereke-arlke. Kenhe Moses-ele akenhe Israel-arenye areye arrewekele-anteye alakenhe renhe mpwareke. ");
INSERT INTO aer_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Nhenge Israel-arenye areyele Egypt-arenye areye arne yanhe areyeke apayuthneke, Egypt-arenye areye itneke ahele irretyakenhe aneke, itnenhe-ketye ayene-iletyakenhe, arrangkwe-arle. Kenhe YAHWEH akenhe arrewekele anteye-arle Egypt-arenye areyeke angkeke mwantye-mwantye-iletyeke Israel-arenye areyeke. Alakenhe ikwerenge anteme itne arne ingkirreke itnenhe antheke. Alakenhe ikwerenge Israel-arenye areyele arne areye Egypt-arenye areye-ngentyele akngeke, urreke itne alhetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israel-arenye areye anteme apmere Rameses-ngentyele Succoth-werne atheke alheke. Artwe 600,000, arelhe areye uthene ampe areye uthene ingkele alherlte-iweke. ");
INSERT INTO aer_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Tyerrtye arrpenhe areyele-arlke apmere arrpenhe-arenye areyele-arle Egypt imperlte-alheke. Itne ingkirreke anthurre alethe alheke. Itne itnekenhe-arrpe yepe-yepe areye nanikute areye, pweleke areye-arlke akngeke. ");
INSERT INTO aer_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Nhenge itne mpwepele inteke itne merne urrknge yanhe renhe iteke. Nhenge itne alhetyeke-urletye aneke nhenge Egypt imperlte-alhetyeke, itne atheke anthurre irreke alethe alhetyeke. Itne merne arlware-ilentye-akerte itetyakenhe aneke, arrangkwe-arle. Alakenhe ikwerenge anteme itne merne arlware-ilentye kwenye ware arlkweke. ");
INSERT INTO aer_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Urreke itne Egypt impemele alhetyenhenge, Israel-arenye areye yanhe ikwerele uterne 430-ele aneke-arle. ");
INSERT INTO aer_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Kele arlte anyentele anteme, YAHWEH-kenhe areyele Egypt imperlte-alheke anyenhenge 12-arle apurte-irrentyele. ");
INSERT INTO aer_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Arlte ikwerele-anteye, YAHWEH-ele Israel-arenye areye mwantyele arntarnte-aretyame nhenge Re itnenhe Egypt-ngentyele arratelhe-ilemele. Alakenhe ikwerenge anteme lyete anteye Israel-arenye areyele arlte nhenhe renhe itelarerlte-anetyeke ikwere alkngwirretyakenhe anetyeke. Itne itelaretyeke YAHWEH-elarle mwantyele arntarnte-aretyarte arrekwelenye itnekenhe areye. ");
INSERT INTO aer_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Ikwere-iperrele anteme YAHWEH Moses uthene Aaron utheneke angkeke, “The kwenhe arrenhantherrenhe atywerrenge Passover arrawe-irrentye-akerte anthetyeke ahentye aneme nhenge arrantherre renhe arratye apentetyenhenge. Arrawe-irrentye ikwerele Israel-arenye areyele yepe-yepe uthene nanikute uthene ware arlkwetyeke YAHWEH-eke antheke-arle iperre. Tyerrtye apmere arrpenhe-arenye areyele renhe arlkwetyeke arrangkwe. ");
INSERT INTO aer_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Nhenge tyerrtye Israel-arenyele apeke tyerrtye apmere arrpenhe-arenye apwerte ngkweltyele ineme ikwere warrke-irretyeke, urreke arrawe-irrentye anetyenhenge re apeke warrkene yanhe artwe-ileme, kele warrkene yanhele kere arlkwemele arrawe-irrentye ikwerele. ");
INSERT INTO aer_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nhenge arrpenhele apeke warrkene yanhe renhe artwe-iletyakenhe, kele re kere arlkwetyeke arrangkwe arrawe-irrentye ikwerele. Kenhe tyerrtye angwenhe apeke re apmere arrpenhe-arenye arrekantherrenge aneme, re kere arlkwetyeke arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Nhenge arrantherre Israel-arenye areyele apeke kere arlkweme arrawe-irrentye ikwerele, apmere kwenele akwete anaye. Apmerenge akethe-werne alhetyale anaye nhenge kere arlkwetyeke, kere ngkwerne ultaketyale. ");
INSERT INTO aer_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Arrawe-irrentye nhenhe ikwerele ureke, arrantherre Israel-arenye areyele kere renhe apurtele arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Tyerrtye apmere ahelhe arrpenhe-ngentyele apeke apetyeme arrpenhele apeke renhe artwe-iletyakenhe, re apeke kere arlkwetyeke ahentye-aneme arrawe-irrentye ikwerele, re akwete arlkwetyeke arrangkwe-arle. Urreke arrantherre arrawe-irrentye renhe atnyenetyenhenge renhe artwe-ilaye, urreye ikwerenhe areye-arlke nhenge itne anteme arrekantherrenge kere arlkwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Atywerrenge nhenhe Israel-arenye areyeke aneme tyerrtye arrpenhe areye-arlkeke arrekantherrenge-arle anemeke.” Nhenhe kwenhe YAHWEH Moses uthene Aaron utheneke angkeke Passover arrawe-irrentye-akerte. Ikwere-iperre anteme Moses uthene Aaron uthenele Israel-arenye arrpenhe areyeke iletyeke alhemele. ");
INSERT INTO aer_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Nhenge Israel-arenye areyele atywerrenge nhenhe renhe awemele YAHWEH-elarle Moses uthene Aaron uthene anthekeke, itne aweke arratye renhe apenterlte-anemele. ");
INSERT INTO aer_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Arlte yanhe ikwerele-anteye, YAHWEH-ele tyerrtye areye Egypt-ngentyele arratelhe-ileke anyenhenge 12-arle apurte-irrentyele. ");
INSERT INTO aer_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","2","YAHWEH Moses-eke angkeke, “Nhenge arelhe Israel-arenye areyele ampe urreye akweke arrekwelenye atnyenerlenge, renhe Ayenge anthaye Atyenge warrke-irretyeke. Nhenge pweleke apeke, yepe-yepe apeke, nanikute apeke, tangkeye apekele urreye akwerrke arrwekelenye atnyeneme, kele itnenhe Ayenge anthetyeke tyawerrelye-arteke. Arrwekelenye ingkirreke nhenhe areye Atyinhe aneme.” ");
INSERT INTO aer_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Moses anteme tyerrtye areyeke angkeke, “Lyete anwerne Egypt-ngentyele arratewarreke. Lyete-ngentyele, arlte nhenhe ikwere-akerte akwetethenhe itirrewarraye ikwere alkngwirretyale anaye. Arrantherre ayernentye akngerre areye-arteke Egypt-nge warrke-irretyarte, kenhe YAHWEH-elarle akenhe arrenhantherrenhe apmere yanhe-ngentyele ilyernpenye anthurrele arratelhe-ileke. Lyete-ngentyele, arlte nhenhe ikwerele, merne arlware-ilentye kwenye ware arlkwaye, merne arlware-ilentye-akerte arlkwetyale. ");
INSERT INTO aer_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Uterne-arrpe-uterne-arrpele nhenge arrantherre apeke aremele atnyentye akwerrke arraterlenge, itelaraye arlte-akerte nhenge YAHWEH-ele anwernenhe Egypt-ngentyele arratelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Arrule anthurre-arle, YAHWEH-ele apmere arrpenhe arrekwelenye anwerne-kenhe anthetyeke alhileke. Re itneke alakenhe angkeke, ‘Urreke, The arrenhantherrenhe ahelhe anthetyenhenge lyete-arle Canaan-arenye-kenhe anemeke, Hittite, Amorite, Hivite, Jebusite areye-kenhe-arlke.’ Arratye apelaye, YAHWEH-ele anwernenhe yerrele-akngetyenhe merne atningke-arle anemeke-werne. Nhenge anwerne yanhe ikwere-werne alhemele, anwerne uterne-arrpe-uterne-arrpe apurte-irretyenhe arlte nhenhe itelaretyenhenge. Anwerne arlte nhenhele apurte-irretyeke nhenge atnyentye akwerrke arraterlenge. ");
INSERT INTO aer_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Nhenge anwerne apurte-irrerlenge, anwerne kwenhe merne arlware-ilentye kwenye ware arlkwetyeke arlte seven-eke-atwetye. Anwerne impetyenhe merne arlware-ilentye-akerte renhe arlkwetyakenhele. Kele arlte seven ikwerele anteme anwerne akenhe merne akngerre arlkwetyeke YAHWEH utyernemele tnaketyeke. ");
INSERT INTO aer_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Nhenhe arratye-arle. Nhenge anwerne apeke apmere ahelhe yanhe ikwere-werne alhemele, arlte seven-eke anwerne merne arlware-ilentye-akerte arlkwetyeke arrangkwe, anwerne kele impetyeke. ");
INSERT INTO aer_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","“Nhenge anwerne apurte-irrerlenge arrawe-irrentye akngerre atnyenetyeke merne akngerre arlkwetyeke, alere anwerne-kenhele apeke anwernenhe apayuthnetyenhe alakenhe, ‘Akngeye-aye, iwenhenge-ame anwerne arrawe-irreme merne akngerre arlkwetyeke?’ Anwerne itneke alakenhe angkirtnetyeke, ‘Alere-aye, YAHWEH-ele kwenhe anwernenhe Egypt-ngentyele arratelhe-ileke. Re anwernenhe mwantyele arntarnte-areke. Alakenhe ikwerenge anteme anwerne arrawe-irreme merne akngerre arlkwetyenhe, anwerne anteme Renhe itelaretyeke.’ ");
INSERT INTO aer_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Ye, nhenge anwerne apurte-irremele merne akngerre arlkwetyeke, anwerne YAHWEH-akerte itirretyenhenge itelaremele Re anwernenhe arntarnte-arekenge. Anwerne tyerrtye areye-arteke anetyenhe ayeye YAHWEH-kenhe-arle tyelarre anwerne-kenheke-arleke intelhe-ilekeke iltye-kenheke-arleke-arlke. Arrawe-irrentye ikwerele ureke anwerne atywerrenge YAHWEH-kenhe ampe anwerne-kenhe areye akaltyele-anthetyeke. Anwerne itelaretyeke Re anwernenhe Egypt-ngentyele ilyernpenye anthurrele arratelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Ayenge awerrirraye! Uterne-arrpe-uterne-arrpele nhenge atnyentye akwerrke arraterlenge, arrawe-irrentye yanhe ikwere akwetethenhe apurte-irreraye. ");
INSERT INTO aer_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“YAHWEH-ele anwernenhe apmere ahelhe yanhe-werne akngetyetyenhe lyete-arle Canaanite areye-kenhe anemeke. Apmere ahelhe nhenhe aneme Rarle arrekwelenye anwerne-kenhe areyeke alhileke. ");
INSERT INTO aer_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","Urreke nhenge anwerne apmere yanhe ikwerele anerlenge, anwerne atywerrenge nhenhe apentetyenhe: Nhenge arelhe Israel-arenyele ampe urreye akweke atnyenerlenge, renhe YAHWEH-eke anthaye Ikwere warrke-irretyeke. Kenhe pweleke, yepe-yepe, nanikute apeke, tangkeye apekele urreye akweke arrekwelenye atnyenemele, itnenhe YAHWEH-eke anthaye tyawerrelye-arteke. Urreye arrwekelenye areye aneme YAHWEH-eke. ");
INSERT INTO aer_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Kenhe tangkeyele apeke urreye arrwekelenye atnyenerlenge, unte apeke renhe ngkwenge-arrpe atnyeneme. Kele mwerre. Kenhe arrantherre apeke tangkeye renhe atnyeneme, yepe-yepe anyenteke-amparre irrerlknge atwaye renhe urele itemele renhe YAHWEH anthemele anteme. Ikwere-iperrele anteme arrantherre akenhe tangkeye renhe arrekantherre-arrpe atnyenetyeke. Arrantherre akenhe apeke yepe-yepe anyente irrerlknge atwetyakenhe, kele tangkeye irrerlknge atwaye, untye ultakemele. Nhenge urreye akweke arrekwelenye interlenge arrekantherrenhe arrpenheke-artweyeke, urreye akweke ingkirreke yanhe areye aneme YAHWEH-eke. Itnenhe yepe-yepe areye-arteke irrerlknge atwetyale anaye, arrangkwe-arle. Yepe-yepe-tetye urele itaye YAHWEH-eke anthetyenhenge. Nhenge urreye akweke yanhe areye YAHWEH-eke-ante ware warrke-irretyeke. ");
INSERT INTO aer_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Nhenge anwerne yepe-yepe alakenhe irrerlknge atwemele renhe urele itemele, alere anwerne-kenhele alakenhe apeke apayuthneme, ‘Akngeye-aye, iwenhenge-arle-ame unte pweleke arrwekelenye atweme, yepe-yepe uthene nanikute uthene apeke? Iwenhenge-arle-ame unte itnenhe irrerlknge atwemele urele iteme?’ Alakenhe re anwerne itneke angkirtnetyeke, ‘Aleraye, YAHWEH-ele anwernenhe Egypt-ngentyele ilyernpenye anthurrele arratelhe-ileke anwernenhe mwantyele arntarnte-aremele. Anwerne Egypt-arenye areyeke arnterre warrke-irretyarte ayernentye akngerre areye-arteke. ");
INSERT INTO aer_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Pharaoh ikerlte anthurre-arle aneke, re YAHWEH irlpe artepele ante awelpe-awenherlenge. Re anwernenhe ayaketyarte alheme-ketyenge. Alakenhe ikwerenge anteme YAHWEH-ele alere arrekwelenye Egypt-arenyeke-artweyikwe irrerlknge atweke. Re urreye arrwekelenye yepe-yepe-kenhe, pweleke-kenhe, nanikute-kenhe tangkeye-kenhe-arlke irrerlknge atweke. Alakenhe ikwerenge anteme the urreye arrwekelenye pweleke-kenhe areye, yepe-yepe, nanikute-kenhe areye-arlke irrerlknge atweme, itne aneme YAHWEH-eke. Alakenhe ikwerenge anteme the itnenhe urele itemele tyawerrelye-arteke YAHWEH-eke anthemele. Nhenge alere arrekwelenye atyinhe akweke inteke, the renhe irrerlknge atwetyakenhele aneke, arrangkwe-arle. Alakenhe-irreketyenge, the yepe-yepe irrerlknge atweke. The anteme renhe urele itemele YAHWEH antheke.’ Alakenhe renhe kwenhe anwerne alere anwerne-kenhe areyeke angketyeke nhenge itne anwernenhe apayuthnerlenge. ");
INSERT INTO aer_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Yewe, nhenge anwerne apurte-irrerlenge nhenge arrawe-irrentye ikwerele, nhenhe ikwerele ureke anwerne YAHWEH-eke itirretyeke anwernenhe-arle arntarnte-arekeke. Anwerne anetyenhe tyerrtye areye-arteke ayeye YAHWEH-kenhe-arle tyelarre anwerne-kenheke-arleke iltye-kenheke-arleke intelhe-ilekeke. Anwerne ikwere alkngwirretyakenhe anetyenhe. Arrawe-irrentye ikwerele ureke anwerne atywerrenge YAHWEH-kenhe ampe anwerne-kenhe areye akaltyele-anthetyenhe. Anwerne itirretyenhenge Re nhenge anwernenhe Egypt-ngentyele ilyernpenye anthurrele arratelhe-ilemele akngetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Nhenge Pharaoh-ele Israel-arenye areye Egypt-ngentyele yerneke alhetyeke, Ngkartele itnenhe yerrele-akngetyakenhele aneke iwerre Philistia-werne atheke-arle alhemeke, arrangkwe-arle. Iwerre yanhe Egypt-ngentyele Philistia-werne-atheke urteke-itanye ware aneme. Ngkarte alakenhe itirretyame, “The apeke Israel-arenye areye iwerrele akngeme Philistia-werne-atheke-arle alhemeke, itne apeke Philistia-arenye areye-ketyenge atere-irreme, itnekenge atwerreme-ketyenge apeke. Itne apeke Egypt-werne alpeme-ketye.” Alakenhe re Ngkarte itirretyame. ");
INSERT INTO aer_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Re-anteme itnenhe iwerre arrpenhele akngeke, Re itnenhe ahelhe arrangkethele akngeke, kwatye alaye akngerre-werne-atheke Name Arlpentye arritnye. Kenhe Israel-arenye areye irraweye apetyeme irrtyarte-akerte. ");
INSERT INTO aer_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Kenhe Moses-ele akenhe irrerlknge ngkwerne Joseph-kenhe areye ikwerenge akngernerle-apetyeme. Arrule anthurre, urreke Joseph ilwetyenhenge, re kake ikwerenhe areyeke alakenhe angkeke, “Ngkartele arrenhantherrenhe mwantyele arntarnte-aretyenhe. Re arrenhantherrenhe artweyangkwe areye-arlke apmere ahelhe nhenhe Egypt-ngentyele yerrele-akngetyenhe. Atyenge ilaye nhenge ayenge ilwerlenge arrantherre irrerlknge ngkwerne areye apmere Canaan-werne akngirtnetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Nhenge Israel-arenye areyele Succoth imperlte-alhemele, itne Etham-werne alhemele apmere ahurratye itwele inteke. ");
INSERT INTO aer_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","22","YAHWEH-ele itneke imerneke nthenhe-werne atheke alhetyeke. Re itnekenge arrwekele alhetyame itne Renhe aretyeke. Arltele akenhe, Re arrwekele alhetyame angkulye arlpentye akngerre-arteke. Ingwele akenhe, Re alhetyame ure alkngenthe arlpentye akngerre-arteke-arle. Re itnekenge arrekwele-irretyarte alakenhe renhe arlte arrpe-anenhele, ingwe arrpe-anenhele. Re itnenhe impetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","2","Kele, YAHWEH anteme Moses-eke angkeke, “Israel-arenye ingkirreke anthurre ilaye apmere Pi Hahiroth-werne alpetyeke. Itnenhe ilaye apmere Migdol uthene kwatye alaye Name Arlpentye uthene mpwepele intetyeke. Nhenhe kwenhe apmere arrpenhe itwe-ulkerele aneke Baal Zephon arritnye. ");
INSERT INTO aer_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Pharaoh alakenhe itirreme-ketye, ‘Yewe! Israel-arenye yanhe areye apale-apale-irreme nthenhe-werne alhetyeke. Itne atyenge-ketyenge alwirretyakenhele. The itnenhe urreke-arle artenhele aretyenhe apmere ahelhe arrangkethe ikwerenge.’ Alakenhe renhe Pharaoh itirretyenhe. ");
INSERT INTO aer_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","The Pharaoh ikerlte-iletyenhe, nhenge re arrenhantherrenhe intertele alwernetyenhenge thultye ikwerenhe areye-akerte. The akenhe itnenhe ingkirreke anthurre akethe-ante arrernetyenhenge, arrantherre Ayenge utyernemele tnaketyeke. Ikwere-iperrele anteme Egypt-arenye areyele itelaretyenhenge Ayenge-arle YAHWEH apele aneme, Ngkarte arne ingkirrekeke tyerrtye ingkirreke anthurreke.” Alakenhe renhe YAHWEH Moses-eke angkeke. Israel-arenye areyele aweke nthakenhe-arle YAHWEH itneke angkeke-arle. Itne apmere Baal Zephon itwele alhemele inteke. ");
INSERT INTO aer_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Arrpenhe alhemele Pharaoh-eke ileke, nhenge Israel-arenye ingkirreke anthurre alwirreke-arle. Nhenge re nhenhe awemele, re thultye ikwerenhe areyeke-arlke angkerreke, “Ayekaye! Iwenhenge-arle-ame anwerne alkngele-ante areke Israel-arenye areye alwirrirrerlenge? Anwerne itnenhe ayaketyeke! Angwenhe-ame anwerneke warrke-irretyenhe lyete?” ");
INSERT INTO aer_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Kele Pharaoh-ele anteme nanthele tyarre-akngentye akngerre ikwerenhe-arle inerle-alheke, re irraweye apetyeme irrtyarte-akerte. Re thultye ikwerenhe areyeke antangkeke. ");
INSERT INTO aer_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Re thultye 600 ikwerenhe areyeke antangkeke itne itnekenhe-arrpe nanthe tyarre-akngentye akngerre areye inetyeke. Itne Pharaoh-nge alheke, akngerrepate thultye areye-kenhe-akerte-arlke. ");
INSERT INTO aer_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Kenhe YAHWEH-ele Pharaoh ikerlte-ileke arratye. Re Israel-arenye areye alwerneke YAHWEH-elarle itnenhe arntarnte-aretyameke. ");
INSERT INTO aer_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Kenhe Pharaoh-ele thultye ikwerenhe areyele-arlke Israel-arenye areye akwetethe alwerneke. Itne itneke-werne itweke-irrenheke itne Kwatye Alaye Name Arlpentye itwele anetyamenge. Apmere nhenhe re itwele aneke Pi Hahiroth, apmere Baal-Zephon-nge. ");
INSERT INTO aer_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Nhenge Israel-arenye areyele aremele Egypt-arenye areye itwe-irrintyerlenge, itne atere anthurre irrereke, itne YAHWEH-eke arlkeke Re itnenhe akayake-iletyenhenge ilweme-ketyenge. ");
INSERT INTO aer_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Itne Moses ilteke, “Ayekaye! Iwenhenge-arle-ame unte anwernenhe Egypt-ngentyele arratelhe-ileke? Anwerne ingkirreke anthurre ilwetyenhenge. Anwerne Egypt-ele akwete anetyeke aneke-tetye, anwerne yanhe ikwerenge ilwetyeke aneke! ");
INSERT INTO aer_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nhenge anwerne Egypt-ele anetyarte, anwerne ngkwenge angkeke, ‘Anwernenhe impaye! Anwerne ngkwengenge Egypt impetyeke ahentye-anetyakenhe. Anwerne nhenhele akwete aneme nhenhe anthurrele warrke-irreme.’ Alakenhe renhe anwerne ngenhe ileke. Unte akenhe anwernenhe uterneke anthurre, anwerne ingkirreke anthurre anteme apmere arrangkethe nhenhe anthurrele ilwetyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Moses itneke angkeke, “Kele Mwerre! Alhwarrpe-irretyale! Nhenhele YAHWEH-eke akarelhaye, Re arrenhantherrenhe itetheke mpwaretyenhenge. Lyete arrantherre Egypt-arenye areye areme itwe-irrintyerlenge. Lyete-ngentyele akenhe arrantherre itnenhe awethe aretyakenhe. ");
INSERT INTO aer_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Atyenpe anerrirraye, atyenge ahele-irretyale! YAHWEH-ele Egypt-arenye yanhe areye irrerlknge atwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Ikwere-iperrele anteme, YAHWEH Moses-eke angkeke, “Iwenhe ikwerenge-ame unte atyenge arlkeme? Israel-arenye areye ilaye Kwatye Alaye Name Arlpentye Akngerre-werne-atheke alhetyeke. ");
INSERT INTO aer_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Arne atneme ngkwinhe akertne-ilaye, renhe kwatye-werne-atheke thilemele. Kwatye anteme anteke altywere-irremele akalke-akalke-irreme, ikwere-iperre anteme arrantherre Israel-arenye areye akenhe mpwepele anpere-irrenhemele ahelhe arlenyele. ");
INSERT INTO aer_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Tharle thewe Egypt-arenye areye ikerlte-ileke anetyeke. Alakenhe ikwerenge anteme itne arrenhantherrenhe kwatyenge alwernetyenhe. Kenhe alakenhe irreketyenge The itnenhe kwatye kwenenge alhekwarle-iletyenhe. The itnenhe ingkirreke kwatyele ataketyenhe, Pharaoh, thultye ikwerenhe areye, nanthe itnekenhe areye-arlke. Israel-arenye areyele anteme Ayenge utyernemele tnaketyeke. ");
INSERT INTO aer_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Egypt-arenye areyele anteme itelaretyenhenge Ayenge-arle YAHWEH aneme, Ngkarte arne ingkirrekeke, tyerrtye ingkirrekeke.” ");
INSERT INTO aer_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Alkere-arenye Ngkarte-kenhe Israel-arenye areyenge arrwekele alhetyarte, Re itneke imernetyarte nthenhe-werne alhetyeke. Kenhe angkulye akngerre yanhe itnekenge arrwekele alhetyarte. Kenhe alkere-arenye uthene angkulye uthene lyete itnekenge ingkernenge anteme alhetyame, itnenhe arntarnte-aretyame, itnenhe Egypt-arenye areye-ketye ameke-aremele. ");
INSERT INTO aer_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","Ye, angkulye yanhe re mpwepe-atherrele aneke Israel-arenye Egypt-arenye areyenge. Ingwe ikwerele ureke Israel-arenye areyele arltele-arteke aretyarte. Angkulyele tyerrtye Egypt-arenye areye arteke nhenge itne uyarne areme ingwele-arteke. Alakenhe ikwerenge anteme ingwele-arteke aneme, itne tyerrtye Israel-arenye areyeke itwe-irretyakenhe-irreke. ");
INSERT INTO aer_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Moses anteme arne atneme ikwerenhe ineke, kwatye-werne thilemele. YAHWEH-ele rlke ikngerre-ngentyele yerneke, rlke akngerrele ingwele-akake werneke, kele kwatye renhe anteme antarre-iweke, mpwepe anteme altywere-irreke, ahelhe anteme arerrke-irreke. ");
INSERT INTO aer_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israel-arenye areye ahelhe arerrke mpwepele alheke kwatye iterele-ante atherre tnerlenge apwerte atwatye-arteke. ");
INSERT INTO aer_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Ikwere-iperre anteme Pharaoh uthene thultye ikwerenhe areye uthenele ahelhe arerrtyele ingkernenge apenteke kwatye mpwepeke. ");
INSERT INTO aer_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Ingwele-arle aneke uterne akertne-irretyakenhe akwete. YAHWEH-ele Egypt-arenye areye angkulye uthene ure alkngenthe uthene-ngentyele aretyame. Ingweleme anthurre Re itnenhe apatelhe-ileke, itne yanhe ikwerele arrakerte arralkeme tnerrirreke. Itne apatewarremele anthurre aneke. ");
INSERT INTO aer_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Karnte-karnte areye tyarre-akngentye akngerre itnekenhe rterteke irrpwelpirrpwetyame, itne uyarne anthurre tyarre-ineke ahelhe rterte ikwerenge. Egypt-arenye areye anteme arlkelhe-arlkelhe-ilerreke, “Ayekeye! Anwerne Israel-arenye areye-ketye alperlte-iwetyeke! Ngkarte itnekenhe YAHWEH-ele thewe anwernenhe irrerlknge atwetyenhaye!” ");
INSERT INTO aer_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Nhenge Israel-arenye areye kwatyenge irntwarreke irreke, YAHWEH Moses-eke angkeke, “Arne atneme ngkwinhe awethe akertne-ilaye, kwatye-werne-atheke thile anteme. Nhenge unte alakenhe renhe mpwarerlenge, kwatyele anteme Egypt-arenye areye arteme itnenhe ingkirreke anthurre alhekwarle-ileme tyarre-akngentye akngerre itnekenhe-arlke.” ");
INSERT INTO aer_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Moses anteme arne atneme ikwerenhele kwatye thileke. Uterne anteme akertne-irretyame. Nhenge re kwatye thilemele, kwatye apurte-irrirtneke awethe-anteye. Kenhe Egypt-arenye areye akenhe uyarne anthurre tyenelheme ingkerne-atheke. YAHWEH-ele itnenhe ingkirreke anthurre kwatyele alhekwarle-iweke. ");
INSERT INTO aer_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Kwatye apurte-irrirtneke arratye, re thultye Egypt-arenye areye ingkirreke alhekwarle-iweke, tyarre-akngentye akngerre itnekenhe areye-arlke. Arrangkwe anthurre itethe akwete aneme, itne ingkirreke ilwerrirreke. ");
INSERT INTO aer_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Kenhe tyerrtye Israel-arenye areye-ante akenhe itethe akwete aneke. Itne kwatye akngerre ikwerenge itere arrpenhele tnerrirreke. ");
INSERT INTO aer_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Alakenhe ikwerenge YAHWEH-ele Israel-arenye areye Egypt-arenye areye-ketye itetheke mpwareke. Israel-arenye areyele areke tyerrtye irrerlknge kwatye iterele areye interrirrerlenge. ");
INSERT INTO aer_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Itne itelarerlte-aneke YAHWEH-ele itnenhe ilyernpenye anthurrele itethe atnyeneke. Itne nterte anthurre ikwerele tnerrirretyame, itne angkerreke, “Arratye anthurre kwenhe, YAHWEH kwenhe mwerre anthurre! Anwerne mwerre-arle Renhe-ante arratye itelareme, Re anwernenhe arntarnte-areme. Anwerne mwerre-arle Moses-inpe arratye itelareme, YAHWEH-elarle renhe akngakeke anwerneke akngerrepate anetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Moses Israel-arenye areyenge Kwatye Alaye Name Arlpentye-ngentyele arrekweleke-irreke. Re itnenhe apmere ahelhe arrangkethe Shur arritnye-werne yerrele-akngeke. Itne ingkele alherlte-iweke arlte urrpetyeke, itne akenhe kwatyeke uyarne anthurre untheke, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Itne anteme apmere Marah arritnyeke irrpeke. Kenhe kwatye yanhe ikwerele aneke, itne renhe antywetyakenhe aneke irrkerteye anthurre-arle anekenge. Alakenhe ikwerenge anteme itne renhe Marah arritnye antheke. Angkentye itnekenhele Marah ileme “Irrkerteye.” ");
INSERT INTO aer_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Tyerrtye areye Moses-eke ahele-irreke itne-arle kwatye irrkerteye renhe uyarne antywemenge, itne renhe apayuthnemele, “Aye! Iwenhe-ame anwerne antyweme? Kwatye nhenhe irrkerteye anthurre!” ");
INSERT INTO aer_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Kenhe Moses athathe-iwelhemele aneke. Kele re-anteme YAHWEH-eke angkeke, “Atyenge ilaye nthakenhe-ame ayenge irretyeke!” Kele YAHWEH-ele anteme ikwere arne imerneke. Moses-ele arne yanhe ineke kwatyeke-arleke iwemele. Kwatye mwerre-anteme-irreke antywetyeke. Apmere yanhe ikwerele YAHWEH-ele tyerrtye Israel-arenye areye arrkerneke aretyeke itne apeke Renhe arratye itelaremere, arratye apentetyenhe anteye, ithwenge apeke. Ikwere iperre, Re anteme itnenhe atywerrenge arrpenhe antheke itne mwerre anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Re itneke angkeke, “Ayenge apele YAHWEH, Ngkarte arrantherre-arle apenterlte-anemeke. Ayenge apeke arrekantherre iwenhe apeke ikwere angkeme, Ayenge awerrirraye Atyenge ahele-irretyale. The arrenhantherrenhe ileme angkentye Atyinhe mwerrentye apentewarraye. Arrantherre apeke alakenhe anemele, The arrenhantherrenhe rlkerte-iletyakenhe anetyenhe The nhenge Egypt-arenye areyeke arrwekele mpwareke-arteke. Yewe, Ayenge apele YAHWEH. Tharle thewe arrenhantherrenhe mwerre-ilentye akngerre.” ");
INSERT INTO aer_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Ikwere iperrele anteme, Israel-arenye areye apmere arrpenhe-werne Elim arritnye-werne alherlte-iweke. Apmere Elim-ele kwatye ngentye twelve-pele aneke arne palm seventy-pele areye-arlke. Tyerrtye areye kwatye itwele inteke. ");
INSERT INTO aer_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Apmere Elim-engentyele, Israel-arenye areye apmere ahelhe arrangkethe Sin arritnye-werne alheke. Apmere yanhe nhenge mpwepe-atherrele aneke Elim uthene Sinai uthenele. Nhenge itne Egypt impemele alheke, itne ingkele alheke week urrpetye-urrpetyele ingkele alheke itne anteme apmere arrangkethe yanhe ikwere-irreke. ");
INSERT INTO aer_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Tyerrtye areye anteme ahele-irreke apmere yanhele-arle merneke arrangkwe anekenge, itne Moses-eke ahele angkemele, ");
INSERT INTO aer_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","“Araye! Iwenhenge-arle-ame unte anwernenhe apmere akurne anthurre nhenhe-werne akngetyeke? Anwerne angayakwe ilwetyenhe! Apmere Egypt-ele anwerne merne uthene kere uthene arunthe arlkwetyeke anetyarte. YAHWEH-ele apeke yanhe ikwerele anwernenhe irrerlknge atweke kele mwerre-anteye-arle anemere. Lyete akenhe anwerne ingkirreke nhenheke ilwetyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","YAHWEH anteme Moses-eke angkeke, “The merne urrpetyeke-urrpetye arrekantherre alkere akertne-ngentyele yernetyenhenge. Arrantherre merne akngerre arlkwetyenhe. The akwetethenhe kwene-akerle yernerle-anetyenhe arrekantherre arlte arrpe-anenhele arrantherre-arle arlkwetyenhenge. Arlte arrpe-anenhele The arrenhantherrenhe arrkernerle-anetyenhe arrantherre apeke-arle Ayenge awerlte-anemeke. ");
INSERT INTO aer_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Arlte arrpe-anenhele arrantherre merne akweke ware arrekantherre-arrpe kutyemele arlte ikwere-ante ware. Arlte Friday-ele akenhe arrantherre merne atningke anthurre kutyetyeke renhe itemele arlkwetyeke Friday-ele uthene Saturday-ele uthene Arlte Impenele-arle anerlenge.” ");
INSERT INTO aer_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Kele Moses uthene Aaron uthene anteme tyerrtye areyeke angkeke, “Ilerne arrenhantherrenhe Egypt-ngentyele akngetyetyakenhe aneke, arrangkwe. Arlte ingwele nhenhe anthurrele arrantherre itelaretyeke YAHWEH-ele arrenhantherrenhe Egypt-ngentyele akngetyeke. ");
INSERT INTO aer_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","8","Ingwenthe YAHWEH-ele arrekantherre imernetyenhe Rarle ilyernpenye anthurre anemele, Re arrekantherre-werne apetyetyenhe. Nhenge arrantherre ilerneke ahele-irrerne, kele arrantherre kwenhe YAHWEH-eke ahele-irreke anthurre. Re arrenhantherrenhe aweke-arle. Rarle thewe ilernenhe ilekeke arrenhantherre nhenhe-werne akngetyetyeke. Ilerne renhe warele awetyame. Ilerne warrkene Ikwerenhe ware aneke.” Moses anteme itneke angkeke, “Ayenge awerrirraye! Arlte arrpe-anenhele nhenge uterne irrperlenge, YAHWEH-ele arrenhantherrenhe anthetyenhe kere arlkwetyeke, ingweleme arrpe-anenhele Re arrenhantherrenhe anthetyenhe merne arlkwetyeke. Arrantherre nhenhe arlkwetyeke, angayakwe anetyakenhe anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Ikwere-iperrele anteme, Moses Aaron-eke angkeke, “Tyerrtye Israel-arenye nhenhe areyeke angkaye, ‘Arrantherre ingkirreke, YAHWEH-ele arrenhantherrenhe aweke ilernenhe alkngetherre ilerlenge. Alakenhe ikwerenge anteme arrantherre apmere ahelhe ameke-ameke Ikwerenhele nhenhele apurte-irretyeke.’” ");
INSERT INTO aer_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaron-ele anteme tyerrtye areye apurtelhe-ileke, itneke angkemele. Nhenge re itneke angkemele, tyerrtye areyele apmere ahelhe arrangkethe arlenge-ulkereke aretyamenge. Kele angkulye akngerre anthurre anteme apetyeke arlenge ulkerenge re imparrkeye anthurre aneke. YAHWEH angkulye ikwerenge aneke. ");
INSERT INTO aer_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","12","Kele YAHWEH anteme Moses-eke angkeke, “The kwenhe Israel-arenye areye awerne nhenge itne mpwelenhe alkngetherre ilerlenge. Alakenhe itneke angkaye, ‘Arlte arrpe-anenhele nhenge uterne irrperlenge, arrantherre kere akngerre anthurre arlkwetyenhe. Ingweleme arrpe-anenhele arrantherre merne akngerre anthurre arlkwetyenhe. Arrantherre anteme angayakwe anetyakenhe anetyenhe. Ikwere-iperrele arrantherre itelaretyenhe Ayenge apele YAHWEH Ngkarte arrekantherrenhe anemenge.’” ");
INSERT INTO aer_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Arlte ikwerele-anteye, nhenge uterne irrpekenge thipe irlpwerre atningke anthurre alkereke-irrenheke Israel-arenye areye-arle anetyamenge-werne. Itne alkere-ngentyele itnyemele ahelhe artemele. Ingweleme anteme uterne nhenge arraterlenge, althwente ingweleme arrernelheke ingkirrekeke-arleke. ");
INSERT INTO aer_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","15","Uterne anteme akertne-irreke, ahelhe-anteme rlterrke-irreke althwente re-anteme arlenye-irreke. Israel-arenye areyele areke arne iwenhe apeke renhe ahelhele interlenge. Itne alakenhe renhe-arteke aretyakenhele aneke arrule anthurre-ngentyele. Mperlkere anthurre aperaltye-arteke aneke. Itne apayuthnerreke, “Iwenhe-ame nhenhe?” Moses itneke angkirtneke, “Nhenhe kwenhe merne re YAHWEH-elarle anwerneke yerneke anwerne arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Alakenhe re YAHWEH atyenge angkeke, ‘Itne akenhe urtne inetyeke untherlte-apemele merne nhenhe renhe kutyerlte-apemele, itne kenhe renhe ineme arrernemele urtne itne-kenheke-arle arlte arrpe-anenhele.’” ");
INSERT INTO aer_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Kele imerte Israel-arenye areye arrpe-anenhele urtne ineke, itne untherlte-apemele merne kutyerlte-apeke. Arrpenhemele arunthe anthurre inerrirreke, arrpenhemele akweke ware ineke. ");
INSERT INTO aer_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Nhenge itne imernelherreke nhenge nthakentye-arle itne inerrirreke, arrpenheme atningke ineke-arle. Arrpenhemele akweke ware ineke, kele mwerre. Itne merne atningke akwete atnyeneke arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Ikwere-iperrele anteme, Moses itneke angkeke, “Arrantherre ankeye akngerre irretyale-aye! Lyete arlkwaye ingkirreke anthurre arrantherre atnyeneme. Renhe ingwentheke atnyenetyale anetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Kenhe tyerrtye arrpenheme akenhe ankeye akngerre irrerlenge, itne Moses awetyakenhe aneke. Itne merne renhe ingkirreke arlkwetyakenhe aneke, itne arrpenheme ingweleme arrpenheke atnyeneke. Kenhe merne yanhe re akenhe irntirte-arle-irreme, akurne ntyeme mpwere-akerte. Moses itneke ahele anthurre awelheke. ");
INSERT INTO aer_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ingweleme arrpe-anenhele tyerrtye areyele akutyewarretyarte merne areye ahelhe-ngentyele. Itne inetyarte arlte anyenteke ware. Nhenge uterne akwetethe arratetyarte urinpe anthurre irretyarte. Uternele merne renhe urrknge-iletyeke, merne anteme uyelpuyerreme impeltye-impeltye-irreme ahelheke-arleke. ");
INSERT INTO aer_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","23","Arlte Friday-ele, tyerrtye areyele urtne atherre inetyarte, itne merne renhe ikwere-atherreke-arleke arrernetyarte. Akngerrepate arrpenhe areye anteme apetyemele Moses-eke angkeke, “Tyerrtye areyele kwenhe urtne atherre ineke itne merne ahelhe-ngentyele itneke-arleke arrernemele.” Moses itneke angkeke, “Kele mwerre. Alakenhe kwenhe YAHWEH angkeme: ‘Saturday Ingwenthe Arlte Impene Atyinhe aneme. Arrantherre anetyeke ware ltyerremele warrke-irretyeke arrangkwe. Lyete-tetye merne arrpenheme urele itaye, merne ampenye kwatyenge tyampite-nge itaye. Merne arrpenheme atnyenaye ingwenthe arlkwetyeke.’” ");
INSERT INTO aer_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Kele, tyerrtye areyele merne arrpenheme ingwelemeke atnyeneke Moses-ele itnenhe mpwaretyeke ileke-arteke. Kenhe merne re akenhe irntirte-arle irretyakenhe, mpwere-kwenyele aneme. ");
INSERT INTO aer_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Kenhe Moses anteme tyerrtye areyeke angkeke, “Lyete Saturday aneme, Arlte Impene YAHWEH-kenhe. Anerlte-anaye ltyerremele ware warrke-irretyeke arrangkwe anthurre. Arrantherre apeke merneke unthetyeke alheme, arrantherre uyarne anthurre areme. Merne ware arlkwaye arrantherre-arle apmwerrke kutyewarreke. ");
INSERT INTO aer_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Nhenhe atywerrenge YAHWEH-kenhe anwerneke aneme. Anwerne alhetyenhenge merneke untherlte-apetyeke Sunday-ngentyele Friday-eke-atwetye, arlte six-peleke. Kenhe Saturday-ele anwerne merne ahelheke-arleke unthetye-alpetyakenhe, arrangkwe-arle. Arlte yanhe kwenhe impene anthurre YAHWEH-eke.” ");
INSERT INTO aer_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Yanhe arratye anthurre-arle. Kenhe arlte Saturday ikwerele-anteye, tyerrtye arrpenheme alheke merneke unthetyeke. Kenhe arrangkwe-arle, itne apmere ikwere apale-untheke. ");
INSERT INTO aer_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kenhe YAHWEH anteme Moses-eke angkeke, “Araye! Nthakenhe-ame arrantherre irreme? Iwenhenge-arle-ame arrantherre ayenge awetyakenhe nthakenhe-arle Ayenge arrekantherre angkeke? ");
INSERT INTO aer_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ayenge awerrirraye! The kwenhe arrenhantherrenhe ileke Saturday-ele warrke-irretyale anaye. The arrenhantherrenhe ileke Friday arrpe-anenhele The arrenhantherrenhe merne akngerre anthurre anthetyenhe nhenge arrantherre kutyetyenhenge itemele arlkwetyeke, arlte atherreke, kenhe Saturday arrpe-anenhele arrantherre anetyeke apmerele altyerremele untherlte-apetyale anetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Kele ikwere-iperrele anteme tyerrtye areye arlte Saturday arrpe-anenhele anetyarte ltyerremele, warrke-irretyakenhe anetyarte. ");
INSERT INTO aer_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Tyerrtye Israel-arenye areyele merne renhe aketyarte “manna,” nhenhe ileme, “iwenhe-ame nhenhe?” Manna aperaltye-arteke aneke ngkwarle ikwemeye urltampe-arteke. ");
INSERT INTO aer_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Moses anteme tyerrtye areyeke angkeke, “YAHWEH-ele ayenge ileke the manna arrpenheme tyampite-ke akwernetyeke ampe anwerne-kenhele aretyenhenge iwenhe-arteke-arle re anekeke. Nhenge itne merne renhe aremele, itne itelaretyenhenge YAHWEH-ele anwernenhe Egypt-ngentyele arratelhe-ileke anwernenhe merne yanhe renhe apmere arrangkethe ikwerenge anthetyarte.” ");
INSERT INTO aer_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Moses anteme Aaron-eke angkeke, “Tyampite akngerre inemele merne yanhe ikwere akwernaye, anwerne ampe anwerne-kenhe areyeke imernetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aaron-ele-anteme tyampite akngerre ineke merne renhe inemele tyampite kweneke akwerneke. Urreke re tyampite yanhe box impene kweneke arrerneke. Nhenge Israel-arenye areyele Tyampite Akngerre Ameke-ameke renhe atnyenemele itne YAHWEH-eke itirrewarretyarte nhenge Re itnenhe arntarnte-arekenge Rarle Abraham-eke arrule anthurre alhileke-arle-arteke. ");
INSERT INTO aer_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","36","Israel-arenye areyele merne yanhe renhe arlkweke uterne 40-eke-atwetye. Nhenhe ikwerele ureke itne apmere arrangkethe ikwerele untherlte-apetyarte. Itne apmere Canaan-eke irrpeke-arle iperre, YAHWEH-ele merne yanhe renhe itnenhe anthemele impeke. Canaan-enge nhenge Israel-arenye areye anetyarte ilengareke-atwetye re apeke. Tyampite yanhe thewe itne manna renhe ikwere arrernetyarte omer arritnye. ");
INSERT INTO aer_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Israel-arenye areye apmere arrangkethe ikwerele Sin arritnyele anetyarte. Nhenge YAHWEH-ele itnenhe ileke apmere arrpenhe-werne alhetyeke, itne anteme alherlte-iweke. Ikwere-iperre anteme itne apmere Rephidim-ele inteke. Kenhe yanhe ikwerele akenhe kwatyeke arrangkwe-arle aneke tyerrtye areyele antywetyeke. ");
INSERT INTO aer_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Lyarrke-lyarrke anthurre irremele itne Moses-eke ahele-irreke, ikwere angkemele, “Anwernenhe kwatye anthaye.” Moses itneke angkirtnerlenge, “Iwenhenge-ame arrantherre atyenge ahele-irreme? Arrantherre apeke YAHWEH arratye itelaretyakenhe Renhe arrkernemele ware? Arrantherre-ame itirreme nhenge Re apekele anwernenhe impeke arntarnte-aretyakenhele? Arrantherre apeke alakenhe itirreme, Re arrekantherre ahele-irretyenhenge!” ");
INSERT INTO aer_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Tyerrtye areye kwatyeke angkethakwe anthurre irreke. Itne Moses-eke ahele-irreke angkemele, “Iwenhenge-arle-ame unte anwernenhe Egypt-ngentyele arratelhe-ileke? Iwenhenge-ame unte anwernenhe nhenhe-werne akngetyeke, ampe anwerne-kenhe, yepe-yepe, pweleke, nanikute anwerne-kenhe areye-arlke anwernenhe irrerlknge atwetyeke apeke? Nthenhenge-ame anwerne antywetyenhe?” ");
INSERT INTO aer_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Moses-ele anteme YAHWEH apayuthneke, “Nthakenhe-ame ayenge tyerrtye nhenge areyeke irreye? Itne ayenge awetyakenhe, itne ayenge irrerlknge apwertele weme!” ");
INSERT INTO aer_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","YAHWEH anteme Moses-eke angkeke, “Artwe akngerrepate areye apurtelhe-ilaye. Tyerrtye areyenge arrwekele untherle-apaye akngerrepate areye-akerte. Atneme ngkwinhe akngaye, nhenge unte-arle Egypt-ngentyele akngetyekeke nhenge unte Lhere Akngerre Nile atweke. Iparrpe alhaye! ");
INSERT INTO aer_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Apwerte akngerre nhenge Sinai-werne alhaye. Yanhe ikwerele unte apwerte arlwe aretyenhenge. Ayenge arrekantherrenge arrwekele tnetyenhe apwerte arlwe yanhe ikwerele. Apwerte yanhe renhe atneme ngkwinhele atwaye. Kwatye anteme arrateme, tyerrtye areyele anteme kwatye renhe antyweme.” Moses YAHWEH-eke awelheke, re alhemele apwerte yanhe renhe atweke artwe akngerrepate areyele renhe arerlenge. Kwatye apwerte-ngentyele thelelheke. ");
INSERT INTO aer_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Moses apmere yanhe renhe atniweke “Massah,” arritnye yanhe ileme, “Itne Ngkarte arrkerneke.” Israel-arenye yanhe areye kwatyeke arrangkwe aneke iperre, itne Ngkarte arrkernetyame, Moses arlkaremele, “YAHWEH-ame nhenhe akwete anwernekenge? Re-ame anwernenhe akwete arntarnte-areme?” Alakenhe ikwerenge anteme Moses-ele apmere renhe arritnye arrpenhe antheke “Meribah,” arritnye nhenhe ileme “Itne arlkarentye-ileke.” ");
INSERT INTO aer_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Nhenge Israel-arenye areye apmere Rephidim-ele anerlenge, Amalekite areye apmere yanhele irraweye aneke, itnenhe atwetyeke-urletye. ");
INSERT INTO aer_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Moses Joshua-ke angkeke, “Artwe arrpenheme akngakaye arrantherre nhenge atwerretyeke alhetyenhenge Amalekite areyenge. Ingwenthe ayenge alheme apwerte akertne nhakwele tnetyeke. The atneme atyinhe akngetyenhe Ngkartele-arle ayenge atnyenetyeke anthekeke. The arne renhe akertne-antepe atnyenetyenhe, the arrekantherre-werne thiletyenhe arrantherre anteme itnenhe atwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Joshua anteme Moses-eke awelheke, re artwe areye akngakeke atwerretyeke Amalekite areyenge. Urreke itne atwerretyeke alhetyenhenge, Moses Aaron-enge apwerte akertneke antyeke, artwe arrpenhe Hur arritnye-akerte anteye. ");
INSERT INTO aer_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","12","Re arne atneme iltye ikwerenhele akertne-ileke, renhe akapertenge akertne atnyenemele. Nhenge re arne renhe alakenhe renhe arntwirrkemele, Israel-arenye areyele Amalekite areye irrerlknge atwetyame. Moses artwe ampwe aneke iltye ikwerenhe apurrke-irremele. Re atneme renhe uyarne anthurre akertne atnyeneme. Nhenge iltye ikwerenhe kwene-irremele, Amalekite areyele akenhe Israel-arenye areye irrerlknge atwerlenge. Alakenhe re irreme-ketye, Aaron uthene Hur uthenele apwerte akngerre anthurre ineke Moses arrernelhetyenhenge. Ikwere-iperrele anteme, Aaron uthene Hur uthenele amulte Moses-kenhe arntwirrkerle-anerretyeme re arne atneme renhe akwete arntwirrketyenhenge nhenge artwe areye atwerretyamenge. Aaron itere itwele tneke, kenhe Hur akenhe itere arrpenhele tneke. Alakenhe ikwerenge artwe ratherre amulte atherre Moses-kenhe arntwirrkerle-anerretyame uterne-ante irrpetyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Alakenhenge re-anteme Joshua uthene thultye ikwerenhe areye uthenele Amalekite areye irrerlknge atweke. ");
INSERT INTO aer_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","YAHWEH anteme Moses-eke angkeke, “Ayeye nhenhe renhe pipe-ke intelhe-ilaye nhenge tyerrtye areye ikwere itirretyenhenge urreke, ikwere alkngwirretyakenhele. Ayeye nhenhe renhe Joshua-ke akwetethenhe ilaye. Renhe ilaye The Amalekite areye akethe-ante arrernetyenhe, anyente-ante itethe anetyakenhe anetyenhe ahelhe nhenhele!” ");
INSERT INTO aer_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Ikwere iperrele anteme, Moses-ele apwerte arrpenheme ineme aharle-iwemele YAHWEH tnaketyeke. Apmere yanhe renhe arritnye antheke “YAHWEH NISSI!” Arritnye nhenhe ileme, “YAHWEH-ele ayenge artengele-areme-arle.” ");
INSERT INTO aer_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Moses anteme angkeke, “The kwenhe atneme atyinhe akertne atheke arntwirrketyame YAHWEH-arle aneme-werne. YAHWEH-ele kwenhe Amalekite areye akwetethe anthurre irrerlknge atwerle-anetyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","2","Nhenge Israel-arenye areyele Egypt impemele alheke, itne akwete anthurre alethe alhetyame atnyentye atherreke. Arlte arrpenhele anteme itne irretye-alheke apmere arrangkethe ikwere Sinai arritnyeke. Mpwepele anteme itne inteke apmere arrpenhe Rephidim arritnyele. Urreke-ulkere anteme itne Sinai-ke irretye-alheke. Itne apwerte akngerre Sinai atnartengele inteke. ");
INSERT INTO aer_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Moses apwerte akertneke Ngkarte-werne antyeke. YAHWEH anteme Moses-eke apwerte akertne-ngentyele arlkeke ikwere angkemele, “Alakenhe nhenhe unte Jacob-kenhe areyeke angketyeke, tyerrtye Israel-arenye areye-arle anemeke. ");
INSERT INTO aer_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Arrantherre Ayenge itelaretyeke, The nhenge tyerrtye Egypt-arenye areye arrileke. Arrantherre Ayenge itelareme The arrenhantherrenhe Egypt-ngentyele arratelhe-ileke. The arrenhantherrenhe ahelhe nhenhe-werne mwantyele akngetyeke. The arrenhantherrenhe mwantyele arntarnte-areke nhenge arrantherre alethe alhetyemenge, irretyele-arteke akweke ikwerenhe areye arntarnte-areme urreke itne alkereke-irretyenhenge. Alakenhe renhe The arrenhantherrenhe arntarnte-areke. ");
INSERT INTO aer_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Atyenge aywerrke-irremele Atyenge-ketye mwernte-irretyale anaye, angkentye Atyinhe akwetethe apenterlte-anaye. Tyerrtye atningke anthurre apmere ahelhe nhenhe-arenye Atyinhe aneme, kenhe nhenge arrantherre apeke Ayenge aweme, The arrenhantherrenhe akngaketyenhe tyerrtye arrpenhe ingkirreke-ngentyele ahelhe nhenhe ikwerenge. ");
INSERT INTO aer_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","Ayenge arrekantherre Ayenge-ante ware awetyeke ahentye aneme, Ayenge-ante ware apentetyeke. Arrantherre ingkirreke Atyenge warrke-irretyenhe kwertengerle tyatye-arenye areye-arteke, The arrenhantherrenhe Atyenge-arrpe akalkelhe-iletyenhe.’ Alakenhe re-anteme unte Israel-arenye areyeke angketyeke.” ");
INSERT INTO aer_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Moses anteme apwerte-ngentyele kwene-akerle alpeke, artwe ampwe akngerrepate ingkirreke apurtelhe-ilemele. Re itneke angkentye ingkirreke anthurre ileke YAHWEH-ele ikwere apwerte ikwerenge ileke. ");
INSERT INTO aer_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Itne anteme Moses-eke angkeke, “Kele mwerre-arle. Iwenhe apeke YAHWEH anwerneke angkerlenge, anwerne Ikwere aywerrke-irretyenhenge. Anwerne anetyenhe Ikwere-ante ware warrke-irretyenhe.” Moses anteme apwerte akertne-werne alpeke, YAHWEH-eke angkemele, “Tyerrtye nhakwe areye angkeke itne-arle akwele anetyenhe Ngkwenge-ante ware warrke-irretyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","YAHWEH anteme Moses-eke angkeke, “Ayenge ngkwenge-werne angkulye urrperle akngerre-arteke apetyetyenhe, ngkwenge angketyeke. Tyerrtye areyele Ayenge awetyenhe nhenge Ayenge Ngkwenge angkerlenge. Nhenge Ayenge ngkwenge angkerlenge, kele tyerrtye areyele anteme Ngenhe akwetethe arratye itelaretyenhenge.” Moses anteme kwene-akerle atnarnpetyeke tyerrtye nhenge areye-werne-atheke. Re itneke ileke nthakenhe-akenhe YAHWEH ikwere angkekenge. ");
INSERT INTO aer_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Kele Moses anteme apwerte akngerre ikwere akertne-werne antyirtneke, YAHWEH anteme ikwere angkeke, “Tyerrtye nhakwe areye iletyeke alhaye itne nhenge mpwarelhetyeke lyete-arlke ingwenthe-arlke Ayenge aretyenhenge. Itnenhe ilaye mantere itnekenhe alhewetyeke. ");
INSERT INTO aer_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","Arlte ingwenthe arrpenhe-ngentyele, Ayenge YAHWEH kwenhe nhenhe-werne akertne-ngentyele apetyetyenhe apmere nhenhe apwerte akngerre Sinai-werne. Itnenhe ilaye Atyenge arelhetyeke. Tyerrtye atningke anthurrele Ayenge aretyenhe apetyerlenge. ");
INSERT INTO aer_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Arrkngerte apwerte akngerre ikwerenge-arlenge arrernaye tyerrtye areye ilaye ikwere-werne angathe-irretyale anetyeke. Angwenhele apeke apwerte akngerre nhenhe anpeme renhe irrerlknge atwaye. ");
INSERT INTO aer_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Tyerrtye yanhe anpetyalaye. Renhe apwertele irrerlknge atwaye, irrtyarte akwekele apeke. Arratye apelaye, tyerrtyele apeke, atnunthele apeke apwerte akngerre renhe anperlenge, itne ilwemele. Unte apeke nhenge awerlenge aywerre trumpet-kenhe arlkerlenge, kele tyerrtye areye anteme arrkngerte yanhe-werne alhetyeke apwerte atnartengele.” Alakenhe renhe YAHWEH Moses-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","15","Moses anteme kwene-akerle tyerrtye areye-werne atnarnpeke. Re itneke angkeke, “Arlte ingwenthe arrpenhe-ngentyele, Ngkarte akertne-ngentyele apwerte akngerre nhenhe-werne apetyetyenhe. Arrantherre mpwarelhaye nhenge arrantherre Ikwerenge arrwekele tnetyenhenge. Artwe areye, anewikwe arrekantherrenge intetyale anetyeke lyete apeke ingwenthe apeke, itnenhe impaye, itnenhe anpetyale.” Arratye anthurre, ikwere iperrenge anteme tyerrtye nhakwe areyele mantere itnekenhe areye alheweke. Itne arlte atherrele mpwarelheke. ");
INSERT INTO aer_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Arlte arrpenhele, ingwe-athnele kwatye alharrkentye aneke, kwatye akngerre angkeke. Tyerrtye areyele angkulye urrperle akngerre areke apwerte akngerre renhe arterlenge, tyerrtye angwenhele apeke re trumpet arnterre anthurre arrkene-ilerlenge. Tyerrtye arrpenheme atere-irreremele aneke. ");
INSERT INTO aer_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Moses-ele tyerrtye ingkirreke apmere itnekenhe-ngentyele yerrele akngeke nhenge itne Ngkarteke apurte-irretyenhenge. Itne arrkngerte ikwere akethele tnerrirretyame, irrpenhetyakenhele. ");
INSERT INTO aer_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","YAHWEH anteme kwenhe akertne-ngentyele apwerte akngerre-werne atheke apetyeke ure akngerrele. Ure kwertele apwerte renhe artetyame. Ure kwerte akngerre anthurre alkere-werne atheke urnteme, apwerte akngerre re akngelheke anthurre! ");
INSERT INTO aer_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Trumpet re tyerrtye angwenhele apeke-arle arrkene-ilemeke, akngerre-ame-akngerre-irreke. Moses Ngkarteke angketyame, Ngkarte anteme ikwere angkirtnerlenge. Angkentye ikwerenhe aneke kwatye angkeme-arteke aneke urreke kwatyele atwetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Ye, YAHWEH alkere akertne-ngentyele apwerte akertne-werne atheke apetyeke, akertne-ngentyele Re Moses-eke arlkeke, Moses anteme antyeke. ");
INSERT INTO aer_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","YAHWEH anteme Moses-eke angkeke, “Kwene-werne alpaye itnenhe alkngarre-ilemele itne-arle apeke iparrpe intyeme-ketyenge Ayenge aretyeke. Alakenhe renhe apeke itne mpwarerlenge itne ingkirreke anthurre ilwetyenhenge! ");
INSERT INTO aer_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Kwertengerle tyatye-arenye areye-arlke alkngarre-ilaye. Itnekeke-amparre mpwarelhetyeke atyenge itwe-werne apetyetyeke. Nhenge itne apeke mpwarelhetyakenhe ware apetyeme, The itnenhe atwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Moses anteme YAHWEH-eke angkeke, “Arratye anthurre yanhe. Tyerrtye areyele apwerte akngerre nhenhe Sinai-ke antyetyeke arrangkwe. Unte anwerneke kele angkerne, ‘Apwerte akngerre nhenheke-arlenge arrkngerte arrernetyeke re apmere ameke-ameke Ngkwenge-ante ware anetyenhenge.’” ");
INSERT INTO aer_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","YAHWEH anteme Moses-eke angkeke, “Apwerte akngerrenge-ntyele atnarnpaye, Aaron nhenhe-werne akngetye-alpaye. Kwertengerle tyatye-arenye areye ayene-ilaye tyerrtye arrpenhe yanhe areye nhenhe-werne antyeme-ketye. Itne apeke nhenhe-werne iparrpe unterrirremele arrkngerte ankerte-iweme-ketye. Itne apeke Atyenge-werne angathe-irrerlenge Ayenge aretyeke, The itnenhe iparrpe arterteke atwetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Arratye, Moses kwene-akerle tyerrtye areye-werne atnarnpeke, itneke ileke iwenhe-ante-iwenhe-ante YAHWEH ikwere angkekenge. ");
INSERT INTO aer_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Ngkarte anteme tyerrtye areyeke alakenhe angkeke: ");
INSERT INTO aer_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ayenge kwenhe YAHWEH aneme, Ngkarte arrantherre-arle apentemeke. The kwenhe arrenhantherrenhe Egypt-ngentyele arratelhe-ileke Egypt-arenye areyele-arle arrenhantherrenhe warrke-irretyeke uternetyartenge ayernentye akngerre areye-arteke. ");
INSERT INTO aer_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Arrantherre kwenhe Atyenge-ante ware kwene-irretyeke, Ayenge-ante ware utyernemele tnaketyeke. Arne arrpenhe apeke, tyerrtye arrpenhe apeke “ngkarte” aketyale. Ayenge-ante ware Ngkarte akaye. ");
INSERT INTO aer_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","“Arrantherre arne ingkirreke alkerenge, ahelhenge, kwatye alaye akngerrenge areme. Kele mwerre-arle. Arne nhenhe areye-arteke akenhe mpwaretyalaye, arne-ngentyele, apwerte-ngentyele-arlke apeke, arrangkwe-arle! ");
INSERT INTO aer_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Arrantherre apeke arne areye arne-ngentyele apeke apwerte-ngentyele apeke mpwarerlenge, kele arrantherre apeke itneke kwene-irremele itnenhe tnakemele. Itnenhe impaye! Ayenge Ngkarte ingkerte aneme. Arrantherre apeke Ayenge impeme arne yanhe areye apentemele itnenhe utyernemele tnaketyeke, kele Ayenge arrekantherre ahele anthurre irretyenhenge. Arrantherre apeke akurnentye anerlenge, The akenhe arrenhantherrenhe arriletyenhe ampe arrekantherrenhe-arlke, atyinhengenhenge arrekantherrenhe-arlke, ampe itnekenhe-arlke. ");
INSERT INTO aer_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Kenhe tyerrtye arrpenhe areye akenhe Atyenge ahentye aneme, tyerrtye areyele-arle atywerrenge Atyinhe atnyenemeke, Ayenge itneke akwete-ante ahentye anetyenhenge. The itnenhe impetyakenhe anetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","“Arritnye Atyinhe impene anthurre aneme. Alakenhe ikwerenge anteme, arritnye Atyinhe akurne-iletyale. Arrantherre apeke arritnye atyinhe akurne-ilerlenge, The arrenhantherrenhe atwetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","“Arlte Apurrke Atyinhe impene aneme. Ayenge itelaraye arlte nhenhe ikwerenge, Atyenge alkngwirretyalaye. ");
INSERT INTO aer_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Week arrpe-anenhele, arrantherre apeke arlte six-eke warrke-irreme, kele mwerre-arle. ");
INSERT INTO aer_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Kenhe Arlte Apurrke Atyinhe ameke-ameke aneme. Arlte nhenhe ikwerenge tyerrtye areye warrke-irretyale anetyeke, itne ltyerretyeke ware Ayenge utyernemele tnaketyeke! Angkentye nhenhe tyerrtye ingkirreke anthurreke aneme: Arrekantherre, ampe arrekantherrenhe areyeke-arlke, warrkene arrekantherrenhe areyeke-arlke, tyerrtye areyeke apmere arrpenhe-ngentyele arrekantherre-arlenge-arle anemeke. Tyerrtye angwenhe apeke re warrke-irretyale anetyeke Arlte Apurrke Atyinhele. ");
INSERT INTO aer_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Arrule anthurre, The, YAHWEH-elarle, arne ingkirreke aknganeke arlte six-pelele. The alkere-arlke, ahelhe-arlke, kwatye alaye-arlke aknganeke, arne ingkirreke-arle itnekenge anemeke. Ikwere iperre anteme, arlte arrpenhele Ayenge ltyerremele aneke warrke-irretyakenhe. Alakenhe ikwerenge anteme The arlte yanhe mwerre ileme, The renhe mpwareke arlte impene anetyeke tyerrtye areyeke. The arlte nhenhe renhe tyerrtye areyeke akngakeke itne ltyerretyeke Ayenge utyernemele tnaketyeke. ");
INSERT INTO aer_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","“Arrekantherre artweyeke aywerrke-irraye. Arrantherre apeke itneke aywerrke-irreme, arrantherre apmere yanhele arrule anthurre anetyenhe Tharle arrenhantherrenhe anthemeke. Ayenge YAHWEH Ngkarte aneme arrantherre-arle apentemeke. ");
INSERT INTO aer_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","“Tyerrtye arrpenhe areye irrerlknge atwetyale! ");
INSERT INTO aer_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","“Arrantherre apeke nhenge kele anewarte aneme arelhe arrpenhenge intetyale anaye! ");
INSERT INTO aer_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","“Tyerrtye arrpenhe-ngentyele anyelkngele inetyalaye! ");
INSERT INTO aer_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","“Urrtyirremele iletyale tyerrtye angwenhe-akerte apeke court-enge! ");
INSERT INTO aer_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","“Artwe areye-aye, artwe arrpenhe apeke apmere arrekantherrenhe itwele anerlenge, itirretyale anaye arrantherre akwele apmere ikwerenhe raketyenhe. Itirretyale anaye arne ikwerenhe areye inetyeke, anewe ikwerenhe apeke, warrkene ikwerenhe apeke, pweleke apeke tangkeye ikwerenhe apeke. Itirretyale anaye arne nhenhe areye atnyenetyeke akwele! Itne artwe arrpenhe-kenhe aneme. “Angkentye nhenhe areye akwete-ante aneme, arrantherre itnenhe akwetethenhe-akwetethe apenterlte-anetyeke!” ");
INSERT INTO aer_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Israel-arenye areye akwete anthurre tnerrirretyame apwerte akngerre ikwerenge. Itne aweke kwatye akngerre anthurre angkerlenge, itne aweke iwenhe-akweye-arteke trumpet-arteke tyerrtyele arnterre anthurre arrakertele pewe-iletyame. Itne areke ure kwerte urrperle apwerte-ngentyele urnterlenge. Nhenge itne nhenhe areye aremele, itne aterele arrewemele apwerte akngerrenge-ntyele irntwarre-irremele, arlengele tnerrirretyame. ");
INSERT INTO aer_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Itne anteme Moses-eke angkeke, “Unte apeke anwerneke angkeme, anwerne ngenhe awetyenhenge. Kenhe Ngkarte akenhe apeke anwerneke angkerlenge, anwerne ingkirreke anthurre ilwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Kenhe Moses akenhe itneke angkeke, “Atere-irretyalaye! Ngkarte nhenhe-werne apetyeke arrenhantherrenhe arrkernetyeke, arrantherre apeke Renhe apenterlenge, arrangkwe apeke. Re arrekantherre ahentye aneme Ikwere akwetethenhe itirrerlte-anetyeke, iwerre akurne-werne alheme-ketye.” ");
INSERT INTO aer_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Nhenge tyerrtye areyele nhenhe renhe awemele itne apwerte ikwerenge-ntyele akwete anthurre arlengele tnerrirreke. Moses-ante ware angkulye urrperle akngerre ikwere-werne-atheke itwe-irreke, Ngkarte-arle aneme-werne. ");
INSERT INTO aer_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","YAHWEH Moses-eke apwerte akertne-ngentyele angkeke, “Aaron, Nadab, Abihu, akngerrepate seventy Israel-arenye yanhe areye inetyeke alhaye. Arrantherre anteme apwerte nhenheke antyemele Atyenge-werne, Atyenge angathe-irretyale. Atyengenge arlengele tnaye, kwene-irremele anteme Ayenge utyernemele tnakaye. ");
INSERT INTO aer_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Moses-aye, unte-ante kwenhe Atyenge-werne itweke-irretyeke. Arrpenhe yanhe areye ilaye apwerte-werne antyintyeme-ketye. Tyerrtye arrpenhe areyele ngkwengenge apwerteke antyetyeke arrangkwe!” ");
INSERT INTO aer_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Moses anteme tyerrtye areye-werne alhemele itneke ileke ingkirreke YAHWEH ikwere angkekenge. Itne ikwere angkeke, “Mwerre anthurre kwenhe alakenhe. Iwenhe apeke re YAHWEH ngkwenge angkeke, anwerne awetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Moses-ele anteme arne ingkirreke pwekeke intelhe-ileke YAHWEH-elarle ikwere ileke. Ingweleme anthurre arlte arrpenhele re apwerte areye apurtelhe-ileke apwerte akngerre ikwere itweke kwentye-kwentye-ilemele. Ikwere iperrele anteme re apwerte athirnte arlpentye 12-pele ineke, itnenhe akerte arratye ngkernemele. Apwerte 12-pele nhenhele imerneke anyenhenge 12-pele Israel-arenye areye. ");
INSERT INTO aer_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Moses-ele anteme artwe apmerrke arrpenheme pweleke arrpenheme irrerlknge atwetyeke yerneke. Pweleke nhenhe itnenhene itne apwerte aharleke-arleke iteke YAHWEH tnaketyenhenge. Arrpenheme itne irrtnye-iweke apwerte ikwere-arlenge YAHWEH-eke itemele. Kele tyerrtye areyele anteme kere ingkirreke arlkweke. Itne itirretyame nhenge itne mwerre anerrirretyartenge. ");
INSERT INTO aer_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Nhenge itne pweleke areye irrerlknge atwemele, Moses-ele alhwe arrpenheme inemele renhe urtne urrpetyeke-arlke theleke, alhwe arrpenheme re apwerte aharleke-arleke thelemele. ");
INSERT INTO aer_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Moses-ele anteme pweke ineke re atywerrenge YAHWEH-kenhe arrwekele intelhe-ileke-arle tyerrtye areyeke aharlperre ilemele. Re aharlperre angkeme nhenge tyerrtye areyele renhe awetyenhenge. Tyerrtye areye anteme ikwere angkeke, “Arne ingkirreke YAHWEH pweke nhenhe ikwerele angkerlenge, anwerne ikwere aywerrke-irreme renhe awetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Moses-ele anteme urtne alhwe-akerte areye ineke, re tyerrtye areyeke-arleke alhwele anhemele. Re itneke angkeke, “YAHWEH-ele anwernenhe alhileke Re anwernenhe akwetethe arntarnte-aretyenhenge. Arrantherre angkeke arrantherre-arle akwetethe awerlte-anetyenhe iwenhe apeke renhe re arrekantherre angkerlenge pweke nhenhe ikwerenge. Alakenhe ikwerenge anteme the arrekantherre-arleke alhwele anheke. Arrantherre apeke ayeye nhenheke alkngwirremele renhe apentetyakenhele, arrantherre anteme pweleke nhenhe areye-arteke ilwetyenhe. Alhwe arrekantherrenhe ahelheke-arleke altyiwelheme.” ");
INSERT INTO aer_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Moses, Aaron, Nadab, Abihu-arlke, akngerrepate 70-arlke apwerte akertne-werne antyenheke. ");
INSERT INTO aer_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Yanhe ikwerele itne Ngkarte areke Israel-arenye areyele-arle apentewarremeke. Ingke kwenele-ulkere itne areke iwenhe-akweye iwerre-arteke, iwerre yanhe re alkere-alkere aneke. ");
INSERT INTO aer_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Yanhe arratye anthurre aneme! Akngerrepate areyele Ngkarte areke. Kenhe Re akenhe itnenhe irrerlknge atwetyakenhe aneke. Ikwere iperrele anteme itne merne arlkweke kwatye antywemele. Kele imerte itne apwertenge atnarnpewarremele. ");
INSERT INTO aer_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","YAHWEH anteme Moses-eke angkeke, “Akertne atheke Atyenge-werne antyintyaye. Atyenge akarelhaye The ngenhe apwerte athirnte atherrame anthetyenhenge. Apwerte athirnte nhenhe atherreke-arleke The atywerrenge uthene ayeye Atyinhe uthene intelhe-ileke tyerrtye areye ikwere-atherre akaltye-irretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","14","Ikwere iperrele, Moses akngerrepate areyeke angkeke, “Arrantherre ingkerne nhenhele anerrirraye. Aaron uthene Hur uthene arrekantherrenge nhenhele anetyenhenge. Tyerrtye areye apeke ahele-irrerrerlenge arne iwenheke apeke re, itne akenhe ikwere-atherre angketyenhe. Joshua-ante ware kwenhe arrawe-irrentyeke atyenge aywerrke-irremele atyengenge apetyeme.” Kele Moses-ele Joshua ineke, ratherre apwerte ameke-ameke Sinai-werne alherreke. Yanhe ikwere irretye-alherremele, Moses-ele Joshua ingkerne imperle-alheke, re-arrpe apwerte akertne-werne atheke antyeke. ");
INSERT INTO aer_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Nhenge Moses-ele akertneke antyeke angkulye areyele apwerte renhe arterlenge. ");
INSERT INTO aer_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Arratye, YAHWEH angkulyenge aneke akngerrele arrtyernemele. Angkulyele apwerte akngerre renhe arteke arlte urrpetyeke-urrpetyeke-atwetye. Arlte seven-nge YAHWEH Moses-eke angkulye-ngentyele angkeke. ");
INSERT INTO aer_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Israel-arenye areyele alkngenthe Ngkarte-kenhe aretyame akngerrele arrtyernerlenge. Alkngenthe re arrtyernetyame ure akngerre-arteke apwerte akertne anthurrenge. ");
INSERT INTO aer_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Angkulyele Moses-inpe arteke. Re akertne yanhe ikwerele aneke arlte 40-eke uthene ingwe 40 utheneke-atwetye. ");
INSERT INTO aer_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","YAHWEH Moses-eke angkeke, ");
INSERT INTO aer_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Israel-arenye areyeke ilaye, ‘Atywerrenge Arlte Apurrke-akerte apenterlte-anaye. Arlte lyete-ngentyele, Saturday arrpe-anenhele, arrantherre Atyenge itirretyenhenge itelaremele The arrenhantherrenhe arntarnte-arerle-anemenge. Arlte yanhe renhe akngakemele atnyenaye. Arrantherre anteme itelaretyenhenge Ayenge YAHWEH aneme tyerrtye ingkirreke-arle arratye-ilemeke.’ ");
INSERT INTO aer_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“Saturday kwenhe arlte arrpenhe areye-arteke anetyakenhe, arrangkwe-arle. Saturday Atyenge aneme. Kenhe angwenhe apeke Saturday-ele warrke-irreme, tyerrtye yanhe renhe irrerlknge atwaye! Re arrekantherrenge anetyakenhe anetyeke. ");
INSERT INTO aer_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Sunday-ngentyele Friday-eke-atwetye ware warrke-irraye. Yanhe mwerre-arle. Kenhe Saturday arrpe-anenhele ltyerrerlte-anaye, warrke-irretyale. Saturday kwenhe Atyinhe aneme, nhenge arrantherre Atyenge itirretyeke, Ayenge utyernemele tnakewarretyeke. Angwenhe apeke Saturday-ele warrke-irreme, renhe irrerlknge atwaye! ");
INSERT INTO aer_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Lyete-ngentyele, arrantherre, arrekantherre-artweye areye angkentye Atyinheke Saturday-akerte itirretyeke. Ikwere alkngwirretyale anaye The itelaretyenhenge arrantherre Ayenge tnakewarrerlenge. ");
INSERT INTO aer_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Arrantherre apeke akwete anthurre itirrerlte-anemele ayeye Atyinheke Saturday-akerteke, kele The arrenhantherrenhe akwetethe arntarnte-aretyenhe. Arrantherre itelareme, nhenge The ahelhe uthene alkere uthene arne arrpenhe ingkirreke mpwaremele, The ingkirreke arlte urrpetyeke-urrpetyele mpwareke. Arlte arrpenhele anteme Ayenge ltyerremele, warrke-irretyakenhele aneke. Alakenhe ikwerenge anteme arrantherre warrke-irretyakenhe anetyeke arlte Saturday areyele.” ");
INSERT INTO aer_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Kele nhenge YAHWEH Moses-eke apwerte Sinai-nge angkentye uyerreke. Re renhe apwerte athirnte atherre atywerrenge Ikwerenhe-akerte antheke. Ngkartele atywerrenge yanhe areye iltye Ikwerenhele intelhe-ileke. ");
INSERT INTO aer_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Moses apwerte akertne Sinai-le akwete anetyame apetye-alpetyakenhele. Kele tyerrtye areye anteme Aaron-werne alheke ikwere angkemele, “Araye, Moses-ame nthakenhe-arle irrerle-aneme? Iwenhenge-ame re apetyalpetyakenhe? Rarle thewe anwernenhe Egypt-ngentyele arratelhe-ileke. Re apeke ilweke. Aaron-aye arne apeke anwerneke mpwaraye arne-ngentyele, apwerte-ngentyele apeke, gold-engentyele apeke, re anwernenhe iletyenhenge nthenhe-werne-atheke alhetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Kenhe Aaron akenhe itneke angkeke, “Yewe, gold irlpe-kenhe ayenge anthaye anewe arrekantherrenhe irlpele atnyeneme, alere uthene marle uthene-kenhe areye-arlke.” ");
INSERT INTO aer_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Kele tyerrtye areyele gold irlpe-kenhe akngetyeke Aaron anthemele. ");
INSERT INTO aer_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Aaron-ele gold ingkirreke tyampiteke-arleke akwerneke. Re imerte tyampite ureke-arleke arrerneke urinpe-iletyeke urreke re gold renhe theletyenhenge. Kele re arneke-arleke thelemele iwenhe-akweye-arteke pweleke-arteke re inngelheme. Kele re-anteme gold renhe irrakere-ilemele pweleke anteme gold ikwerenge-ntyele mpwareke. Tyerrtye areye anteme angkeke, “Araye! Nhenhe araye! Nhenhele-arle anwernenhe Egypt-ngentyele arratelhe-ilekeke!” ");
INSERT INTO aer_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaron-ele anteme apwerte areye aharle-ileke gold pweleke ikwerenge arrekwele rarle mpwareke, re tyerrtye areyeke angkeke, “Ingwenthe anwerne nhenhenge apurte-irremele arrawe-irrentye akngerreke, anwerne YAHWEH-eke alyelhetyeke urntetyeke!” ");
INSERT INTO aer_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Arlte arrpenhele anteme tyerrtye areye ingweleme anthurre akeme-irreke, pweleke arrpenheme inemele. Pweleke arrpenheme itne apwerte ikwereke-arlenge iteke urrperle-ante-irretyeke YAHWEH utyernemele tnaketyeke. Pweleke arrpenheme itne irrtnye-iwemele iteke itnenhe arlkwetyenhenge. Tyerrtye areyele kere renhe arlkweke ngkwarle-arlke antywemele. Ikwere iperrele anteme itne mpwenye untherreke, ngkwarle iperrele. ");
INSERT INTO aer_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Nhenhe ikwerele ureke, YAHWEH Moses-eke angkeke, “Apwerte nhenhe-ngentyele tyerrtye areye-werne atnarnpaye unte-arle Egypt-ngentyele arratelhe-ilekeke. Itne kwenhe akurne-anthurre-ilelheke. ");
INSERT INTO aer_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Itne kwenhe kele iwerrenge untyeme-irreke Tharle itneke imernekeke itne atywerrenge Atyinhe apentetyakenhe The itnenhe ileke-arteke. Itne renhe akweke ware apenteke. Kele lyete itne Atyenge-ngentyele untyeme-irreme anteme. Itne itneke-arrpe pweleke gold-engentyele mpwareke, ikwere kwene-irremele renhe utyernetyeke. Itne kere arrpenheme iteke pweleke utyernetyeke. Itne imerte angkemele, ‘Pweleke gold nhenhe araye! Nhenhele athewe anwernenhe Egypt-ngentyele arratelhe-ileke.’” ");
INSERT INTO aer_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ikwere-iperrele anteme, YAHWEH Moses-eke angkeke, “The kwenhe tyerrtye mwernte akngerre nhenhe areye itelareme, nthakenhe-arle itne Atyenge-ketye iparrpe untyeme-irreme. ");
INSERT INTO aer_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Ayenge ahele anthurre awelheme, The itnenhe atwetyenhenge anthurre. Ayenge ayaketyale! The anewikwe ampe ngkwinhe areye akethe-ante arrernetyakenhe, arrangkwe-arle. Ngkwenge-artweye-ngentyele tyerrtye atningke intetyenhe itne atningke-ame-atningke-irretyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Moses YAHWEH-eke inkeke, “Ayekaye, YAHWEH! Tyerrtye ingkirrekeke ahele-irretyalaye. Tyerrtye nhenhe areye kwenhe Unte Egypt-ngentyele arratelhe-ileke, Unte akethe-ante arrerneke yanhe areye-arle itnenhe atwetyeke ahentye aneke! ");
INSERT INTO aer_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Unte apeke itnenhe irrerlknge atweme, Egypt-arenye areye alakenhe angkeketyenge, ‘YAHWEH-ele Israel-arenye areye Egypt-ngentyele arratelhe-ileke apmere arrangkethe ikwere-werne. Kenhe Re akenhe itnenhe urrtyekele-iwetyame ware. Re itnenhe arratelhe-ileke itnenhe irrerlknge atwetyenhenge apwerte nhenhenge.’ Alakenhe renhe itne angketyenhe. Alakenhe ikwerenge anteme Unte itneke ahele-irretyale anetyeke, itnenhe akethe-ante arrernetyalaye! ");
INSERT INTO aer_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Abraham, Isaac, Jacob-eke itirraye. Arrule anthurre Unte itneke angkeke, ‘Arrantherre ampe atningke anthurre atnyenetyenhe atyinhengenhenge atningke anthurre. Itne anetyenhe atningke anthurre kwerralye areye-arteke nhenge alkerele aneme-arteke. The itnenhe apmere ahelhe nhenhe anthetyenhe, re itnekenhe akwete-ante anetyenhenge.’ Alakenhe renhe akwele Unte itnenhe alhileke.” ");
INSERT INTO aer_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Nhenge YAHWEH-ele Moses alakenhe renhe angkerlenge aweke, Re itirrentye ikwerenhe akngarte-iwelheke, itirrentye arrpenhe anteme aneke. Re tyerrtye ingkirreke akethe-ante arrernetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Ikwere iperrele anteme, Moses utepe-irremele apwerte-ngentyele kwene-akerle atnarnpetye-alpeke, re apwerte athirnte atherre akngeke nhenge YAHWEH-elarle atywerrenge Ikwerenhe ikwere-arleke intelhe-ilekeke arrwekeleke-arleke artepeke-arleke. ");
INSERT INTO aer_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Moses-ele apwerte renhe-atherrenhe mpwaretyakenhe, arrangkwe-arle. Ngkartele renhe-atherrenhe mpwareke, atywerrenge apwerte ikwere atherreke-arleke intelhe-ilemele. ");
INSERT INTO aer_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Nhenge Moses apwerte akertne-ngentyele atnarnpintyeke, kele re anteme Joshua mpwepeke aremele. Joshua-le tyerrtye ingkirreke anthurre arlkerlenge aweke re anteme Moses-eke angkeke, “Aye! Israel-arenye areye apeke atwerreme itne-arrpe!” ");
INSERT INTO aer_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Moses ikwere angkeke, “Arrangkwe, itne alyelhetyakenhele nhenge itne impeke atwerrentye iperre, the itnenhe awetyakenhe artnerlenge, the itnenhe aweme alyelherlenge.” ");
INSERT INTO aer_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Nhenge Moses itwe anteme irrenheke, re pweleke gold yanhe areke. Re tyerrtye areye urnterlenge areke. Re ahele-anthurre-irreke. Re anteme apwerte atherrame renhe ahelheke iweke, renhe-atherre ultakeke apwerte akngerre ikwere itweke. ");
INSERT INTO aer_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Ikwere iperrele anteme re pweleke renhe inemele nhenge itne-arle gold-engentyele mpwarekeke. Re renhe ure kweneke-arleke arrerneke nhenge arne re urrknge-irretyenhenge kwatye-arteke. Nhenge gold irrernte-irrerlenge, Re renhe kutyemele urlpmernteke ngkweltye-ngkweltye-ilemele. Re renhe kwatye kweneke iweke. Re anteme Israel-arenye areye uterneke kwatye renhe antywetyeke. ");
INSERT INTO aer_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Moses anteme Aaron-eke angkeke, “Iwenhenge-arle-ame unte tyerrtye nhenhe areye YAHWEH-ngentyele untyeme-ileke pweleke nhenhele? Alakenhe kwenhe akurne anthurre! Nthakenhe-ame tyerrtye nhenhe areye ngkwenge irreke? Itne ngenhe uternetyakenhe. Nthakenhe-arle-ame unte itnenhe iletyakenhe renhe impetyeke?” ");
INSERT INTO aer_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaron Moses-eke angkirtneke, “Unte kwenhe akngerrepate atyinhe aneme. Atyenge ahele-irretyale anaye! Unte kwenhe itelareme tyerrtye nhenhe areye arne akurne ingkirrekeke akwetethe itirrerlenge. ");
INSERT INTO aer_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Itne atyenge angkeke, ‘Moses-ele anwernenhe Egypt-ngentyele arratelhe-ileke anwerne anteme akutne aneme nthenhe-arle re anemeke. Arne iwenhe apeke renhe anwerneke mpwaraye arne-ngentyele apeke, apwerte-ngentyele apeke, gold-engentyele apeke nhenge re anwerneke imernetyenhenge nthenhe-werne alhetyeke.’ ");
INSERT INTO aer_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Kele ayenge anteme tyerrtye areyeke angkeke, ‘Yewe, irlpe-kenhe gold areye arrekantherrenhe irlwaye, ite-kenhe areye-arlke iltye-kenhe areye-arlke, itnenhe atyenge-werne akngetyaye.’ Kele itne ayenge gold ingkirreke anthurre antheke. The anteme renhe ureke iweke, pweleke gold anteme arratintyeke.” ");
INSERT INTO aer_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Moses-ele aretyame tyerrtye areye urnterlenge, arlkerlenge tyerrtye arerte areye-arteke. Aaron-ele itnenhe ayaketyakenhe renhe mpwarerlenge. Moses ikwere-arrpe angkeke, “Ayekeye! Tyerrtye arrpenhe areye anwerneke-arle ahentye-anetyakenhe anemeke, itne anwernenhe aretyenhenge, anwernenhe atherrelhe-iletyenhe!” ");
INSERT INTO aer_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Moses anteme apetyemele arriwe itwele tneke apmere ikwerenge arrwekele. Re tyerrtye areyeke arlkeke, “Aye! Angwenhele apeke YAHWEH apentetyeke, atyinhe itwele tnerrirraye.” Kele atyinhenge Levi-kenhe areye anteme apetyeke Moses itwele tnerrirremele. ");
INSERT INTO aer_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ikwere iperrele anteme, Moses itneke angkeke, “YAHWEH kwenhe Ngkarte aneme nhenge anwerne Israel-arenye areyele tnakeme apentemele anteye. Alakenhe re kwenhe Re arrekantherre Levi-kenhe areye-ngentyele angkeme, ‘Artwe arrantherre nayepe arlpentye arrekantherrenhe inerrirraye. Itneke-akerte arrantherre apmerele unthemele, kake uthene yaye uthene, atyeyangkwe areye irrerlknge atwaye, atyewangkwe areye-arlke arrantherre-arle akaltye anemeke.’” ");
INSERT INTO aer_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Tyerrtye Levi-kenhe yanhe areyele itne Moses aweke. Itne nayepe areye inemele tyerrtye areye irrerlknge atweke, itne artwe 3,000 irrerlknge atwemele. ");
INSERT INTO aer_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Moses anteme Levi-kenhe areyeke angkeke, “Lyete arrantherre YAHWEH-eke anthelheke nhenge arrantherre kwertengerle tyatye-arenye-arteke Ikwere warrke-irretyeke. Arrantherre kake uthene yaye uthene, alere arrekantherrenhe areye-arlke irrerlknge atweke. Alakenhe ikwerenge anteme YAHWEH arrekantherre akangkeme. Arrantherre kwenhe kwertengerle tyatye-arenye Ikwerenhe areye anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Arlte arrpenhele anteme, Moses tyerrtye areyeke angkeke, “Arrantherre kwenhe akurne anthurre aneme. Lyete ayenge arrekantherre YAHWEH-eke angketyenhe. Nhenge ayenge Ikwere angkemele, Re apeke arrekantherrenge ipeltye-irretyenhenge. Re apeke arrekantherrenge arratye ipeltye-irreme, arrantherre Ikwere atyewe-irretyenhenge awethe.” ");
INSERT INTO aer_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Moses anteme alpemele YAHWEH-eke angkeke, “Tyerrtye nhenhe areye kwenhe akurne anthurre. Itne arne pweleke gold-engentyele itneke-arrpe mpwareke itne ikwere kwene-irremele renhe tnaketyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Itnenhe ilpernetyakenhe anaye, akunye yanhe areye, itnekenge ipeltye-irremele arriletyale anaye. Unte apeke itnenhe irrerlknge atwetyeke anetyenhe akwete. Itnenhe irrerlknge atwetyalaye, ayenge-tetye irrerlknge atwaye nhenge ayenge itneke ilwetyenhenge! Arritnye atyinhe pweke akngerre yanhe-ngentyele urrparaye nhenge Unte-arle arritnye atyinhe intelhe-ilekeke tyerrtye arrpenhe Ngkwinhe areyenge.” ");
INSERT INTO aer_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","YAHWEH anteme Moses-eke angkeke, “Angwenhele apeke akurne mpwareme Atyenge-ketye untyeme-irrerlenge, The arritnye ikwerenhe pweke-ngentyele urrparetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Tyerrtye areye-werne alpaye, itnekenge arrekwele-irreme apmere nhenge-werne The ngkwenge arrwekele ileke. Alkere-arenye Atyinhele ngkwenge imernetyenhenge nthenhe-werne-atheke alhetyeke. The tyerrtye yanhe areye atwetyenhe akurne-arle-irrekeke.” ");
INSERT INTO aer_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","YAHWEH-ele tyerrtye yanhe areye rlkerte-anthurre-ileke Aaron-arle uternekeke pweleke gold mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Moses-ele ilthe artetyarte, itne-arle “Ilthe Ameke-ameke” akekeke, nhenge arlenge-ulkereke Israel-arenye areye anetyamenge. Re renhe akeke “Ilthe Ameke-ameke.” Nhenge tyerrtye areyele YAHWEH iwenhe apeke renhe apayuthnetyeke, itne apmere itnekenhe impemele arlenge anthurre unthetyarte Ilthe Ameke-ameke ikwere-werne alhetyeke. ");
INSERT INTO aer_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Nhenge Moses Ilthe Ameke-ameke-werne alhetyarte, tyerrtye areye tnerrirretyarte, itne ilthe arriwe itnekenhe-arrpenge tnetyarte. Itne renhe aretyarte re Ilthe Ameke-ameke kwene-werne irrpenherlenge. ");
INSERT INTO aer_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Nhenge Moses Ilthe Ameke-ameke-werne irrpenhetyarte angkulye arlpentye akngerre anthurre apetyetyartenge, re Ilthe Ameke-ameke arriwenge arrwekele tnetyartele. Nhenge angkulye yanhe ikwerele anerlenge, YAHWEH Moses-eke angketyarte. ");
INSERT INTO aer_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Tyerrtye areyele angkulye renhe aretyarte, re Ilthe Ameke-ameke ikwere itwe anthurrele tnetyartenge. Itne ilthe itnekenhe-arrpele tnerrirremele YAHWEH tnakewarretyarte. ");
INSERT INTO aer_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","YAHWEH Moses-eke angketyarte Ilthe Ameke-ameke kwenenge. Ratherre arerretyarte nhenge angkerremele, tyerrtye areyele mpwareme-arteke nhenge itne angkerremele. Ikwere iperrele anteme Moses apmere-werne alpetyarte. Kenhe Joshua akenhe Ilthe Ameke-ameke kwenenge anetyarte renhe impetyakenhele. Joshua Moses-kenhe kwertengerle-arteke anetyarte. ");
INSERT INTO aer_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Ikwere iperrele Moses YAHWEH-eke angkeke, “The ngenhe arne iwenhe-akweyeke apayuthnetyeke ahentye aneme. Unte ayenge ileke tyerrtye nhenhe areye Egypt-ngentyele arratelhe-iletyeke itnekenge apmere arrpenhe-werne arrwekele-irretyeke. Angwenhe-ame Unte atyenge-werne yernetyenhe atyengenge warrke-irretyeke? Unte atyenge alakenhe renhe iletyakenhe aneke. Unte atyenge arrwekele nhenge ileke Unte-arle ayenge itelareme, atyenge akangkemele anemele. ");
INSERT INTO aer_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Mwerre anthurre alakenhe! Unte apeke atyenge akangkentye anthurre aneme, atyenge ilaye nthakenhe-ame unte irretyenhe. Ikwere iperre anteme the Ngenhe awethe itelaretyenhe, nthakenhe-arle Unte itirremele. Kele imerte the Ngenhe akwetethe anthurre akangkemele mpwaretyenhe atyenge. Tyerrtye nhenhe areyeke alkngwirretyale anaye. Unte kwenhe itnenhe akngakeke.” ");
INSERT INTO aer_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","YAHWEH anteme Moses-eke angkeke, “Ayenge ngkwengenge alhetyenhe. Ikwere iperre anteme unte mwerre nterte anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Moses anteme Ikwere angkeke, “Unte apeke nhenhele aneme anwernekenge alhetyakenhele, anwernenhe apmere arrpenhe-werne yernetyale anaye. ");
INSERT INTO aer_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Unte apeke nhenhele aneme, anwernekenge alhetyakenhele, nhenge anwerne apeke apmere nhenhe imperlte-alhemele Ngkwenge-kwenyele, arrpenhe areyele anwernenhe itelaretyakenhe anetyenhe, Unte-arle atyenge akangkemele aneme, tyerrtye nhenhe areyeke-inpe. Anwerne kwenhe tyerrtye Ngkwinhe areye aneme. Anwerne apeke alheme Ngkwenge-kwenyele, anwerne tyerrtye arrpenhe areye-arteke anteme aneme, anwerne iltye-ante aneme itne-arteke. Anwerne tyerrtye arrpenhe areye-arteke anetyakenhe Unte-arle anwernekenge anemenge.” ");
INSERT INTO aer_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","YAHWEH anteme Moses-eke angkeke, “Yewe, Ayenge arrekantherrenge alhetyenhe, The kwenhe ngenhe itelareme anthurre, Ayenge ngkwenge akangkentye anthurre aneme.” ");
INSERT INTO aer_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Moses anteme YAHWEH-eke angkeke. “The kwenhe Ngenhe aretyeke pwarrtyerlenge ngangkere Ngkwinhe-akerte.” ");
INSERT INTO aer_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","YAHWEH ikwere angkeke, “Yewe, Ayenge anpere alhetyenhe ngkwenge imernetyenhenge Ayenge mwerre-arle anemele, The ngkwenge arratye-iletyenhenge arritnye ameke-ameke Atyinhe. Arritnye atyinhe aneme YAHWEH. The tyerrtye areye akngakeke itneke mwerre anetyenhenge itnenhe mwantye-mwantye-iletyenhenge. Ayenge ngkwenge imernelhetyeke ahentye aneme. ");
INSERT INTO aer_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","The ngenhe ayaketyenhe inngerre Atyinhe areme-ketye. Angwenhele apeke inngerre Atyinhe aremele kele ilwemele.” ");
INSERT INTO aer_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kele YAHWEH anteme ikwere angkeke, “Apwerte arlwe akngerre itwe-ulkere tyarrpe-akerte aneme. Apwerte arlwe yanhe ikwere itwele tnetyeke alhaye. ");
INSERT INTO aer_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ayenge pwarrtyetyenhe nhenge apwerte yanhe ikwerenge anpere alhemele. The ngenhe apwerte arlwe tyarrpeke arrernetyekeke-amparre. Nhenge Ayenge anpere alhemele, The ngenhe iltyele artetyenhe. ");
INSERT INTO aer_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","The iltye anamelhe-iletyenhe anteme, unte artepe aretyenhenge. Unte inngerre Atyinhe aretyakenhe anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","YAHWEH Moses-eke angkeke, “Apwerte athirnte arrpenhe atherre arrpaye nhenge The ngenhe arrwekele ileke-arteke, apwerte athirnte arrpenhe yanhe atherre-arteke nhenge unte kwene-akerle iweke-arle ultakemele. The atywerrenge Atyinhe apwerte nhenhe ikwere atherreke-arleke arrernetyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ingwenthe ingweleme apwerte athirnte arrpenhe atherre akngetyaye, Atyenge-werne apetyaye apwerte akngerre Sinai-werne, Ayenge ngkwenge angketyenhenge. ");
INSERT INTO aer_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Tyerrtye arrpenhe ngkwengenge akngetyetyale, arrangkwe-arle. Tyerrtye areye ayakaye apwerte nhenhe ikwere itwe-werne apetyeme-ketye, yepe-yepe-arlke, pweleke-arlke ayakaye, name atherrke arlkweme-ketye apwerte akngerre atnartengele lyaperlenge-arle.” ");
INSERT INTO aer_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Kenhe Moses-ele apwerte athirnte atherrame ineke arratye, renhe-atherrenhe arrpemele alyere-alyere-iletyeke. Arlte arrpenhele re apwerte akngerre Sinai akertne-werne antyeke apwerte yanhe atherre-akerte. Alakenhe renhe YAHWEH-ele renhe arrekwele ileke mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","YAHWEH anteme apwerte akngerre Sinai-werne apetyeke angkulye kwenenge. Re apetyemele Moses itwele tnetye-alheke angkemele, “Ayenge-arle YAHWEH.” ");
INSERT INTO aer_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Re Moses-enge arrwekele anpere alheke ikwere angkemele, “Ayenge kwenhe YAHWEH Ngkarte. The kwenhe tyerrtye areye akwetethe mwantye-mwantye-ilerle-aneme, itneke mwerre anemele. Nhenge itne akurne anerlenge Atyenge-ketye, Ayenge itneke iparrpe ahele-irretyakenhele, arrangkwe-arle. Ayenge itneke ahentye akwete aneme. Nhenge The arne iwenheke apeke alhilemele, The renhe anthemele renhe inirtnetyakenhe awethe. Ayenge kwenhe itneke akwetethe arratye angkeme. ");
INSERT INTO aer_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Arratye anthurre yanhe. Ayenge kwenhe tyerrtye atningke anthurreke mwerre aneme. Nhenge itne akurnentye anerlenge Atyenge-ketye, ikwere iperrele anteme itne Atyenge-werne utepe-irrirtneme, The itnenhe yernetyakenhele, arrangkwe-arle. The akurne itnekenge urrpareme arriletyakenhele. Kenhe itne apeke arne akurne akwete mpwarerlte-anerlenge, Atyenge-werne utepe-irrirtnetyakenhele, The itnenhe arratye anthurre anteme arriletyenhe. The itnenhe ware arriletyakenhe anetyenhe apeke, The ampe itnekenhe-arlke, ampe itnekenhe areye-arlke akenhe akwete arriletyenhe, alakenhe renhe The akwetethe mpwarerle-anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Kele Moses iparrpe anthurre ahelhe-werne kwene-irreke YAHWEH tnakemele. ");
INSERT INTO aer_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Moses Ikwere angkeke, “YAHWEH, the kwenhe tyerrtye nhenhe areye itelareme, anwerne kwenhe akaperte apwerte-arteke aneme, mwernte akwete aneme. The itelareme anwerne akurne aneme akurnentye anerlte-anemele. Unte apeke atyenge akangkentye akwete aneme, anwernenge irlkwatherre apetyaye nthenhe-werne re apeke anwerne alherlte-iwerlenge. Anwernenhe atnyenaye anwerne tyerrtye aharle Ngkwinhe anetyeke.” ");
INSERT INTO aer_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Nhenge Moses apwerte akngerre Sinai-ngentyele apetyalpemele, Re apwerte athirnte atherre iltyele atnyenetyamele. Inngerre ikwerenhe pwarrtyeme rarle YAHWEH-eke angketyamenge apwerte akngerre ikwerenge. Kenhe re akenhe akutne aneke alakenhe ikwere. ");
INSERT INTO aer_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Nhenge Aaron uthene Israel-arenye areye uthenele areke inngerre Moses-kenhe pwarrtyerlenge itne ikwere-werne itweke-irretyakenhe aneke itne-arle ikwere-ketye atere-irrekenge. ");
INSERT INTO aer_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Moses anteme itneke arlkeke, “Atyenge-ketye atere-irretyalaye, itwe-werne apetyaye!” Aaron uthene akngerrepate arrpenhe areye uthene ikwere-werne apetyewarreke, Moses anteme itneke angkeke. ");
INSERT INTO aer_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Kele imerte tyerrtye areye anteme Moses-werne itwe apetyewarreke, re itneke atywerrenge ileke YAHWEH-elarle ikwere ilekeke apwerte akngerre Sinai akertnenge. ");
INSERT INTO aer_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Nhenge Moses tyerrtye areyeke angkeke-iperre, re inngerre ikwerenhe manterele artelhemele. ");
INSERT INTO aer_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Nhenge Moses Ilthe Ameke-ameke kweneke irrpemele YAHWEH-eke angketyeke, re mantere akweke renhe inngerre ikwerenhe-ngentyele irlwetyarte. Nhenge re Ilthe ikwerenge arratemele alhetyarte, Re tyerrtye areyeke arne ingkirreke anthurre iletyarte YAHWEH angketyartenge. ");
INSERT INTO aer_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Tyerrtye areyele inngerre ikwerenhe pwarrtyerlenge aretyarte. Alakenhe ikwerenge anteme Re inngerre ikwerenhe manterele artelhetyarte, nhenge rarle YAHWEH-eke angkeke iperre. ");
INSERT INTO aer_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Nhenge Moses-ele Ilthe Ameke-ameke artemele, re arne ingkirreke kwene ikwere arrerneke YAHWEH-elarle ikwere arrwekele ilekeke. Kele imerte angkulye YAHWEH-nge apetyeke alkere-ngentyele re Ilthe renhe arterlenge. Ngangkere Ikwerenhe Ilthe Ameke-ameke kwene ikwerele aneme. ");
INSERT INTO aer_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Alakenhe ikwerenge anteme Moses kwene-werne irrpetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","37","Nhenge angkulyele Ilthe renhe artemele, Israel-arenye areye apmerele akwete anetyartenge-arle. Nhenge angkulye akertne-werne-atheke antyemele, Israel-arenye areye apmere arrpenhe-werne aname-irretyarte. ");
INSERT INTO aer_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Yanhe arratye anthurre. Arltele ureke, angkulyele Ilthe Ameke-ameke renhe artetyarte. Ingwele akenhe re pwarrtyetyarte anthurre ure-arteke. Nhenge Israel-arenye areye anange-irretyarte, itne angkulye itnekenge arrekwele aretyarte, itne renhe apentetyarte anteme. ");
INSERT INTO aer_vpl VALUES ("RT1_1","009_1_1","RUT","1","1","2","Arrule anthurre, urreke king areye apmere Israel-ele akngerrepate anetyenhenge, artwe arrpenhe areye tyerrtye Israel-arenyeke pwathe anetyarte. Nhenhe ikwerele ureke, apmere Israel-ele, merneke arrangkwe anthurre aneke uterne urrpetyeke-atwetye ahurratye akngerre-arle anekenge. Kenhe artwe anyente akenhe anetyarte Elimelech arritnye Bethlehem-arenye, apmere ahelhe akngerre Judah ikwerele. Artwe nhenhe Elimelech apmere Bethlehem imperle-alheke apmere arrpenhe Moab-werne alhemele. Re anewikwe Naomi akngeke alere atherre-inpe Mahlon uthene Kilion uthene. Tyerrtye nhenhe areye apmere Ephrathah-arenye aneke apmere Bethlehem itwele. Itne Moab-werne aname-irremele apmere ikwerele anepanetyarte. ");
INSERT INTO aer_vpl VALUES ("RT1_3","009_1_3","RUT","1","3","3","Ikwerenge-ntyele, Elimelech anewe Naomi-kenhe ilweke. Kele, Naomi re aneweke arrangkwe aneke, ikwere alere atherre anyikweke arrangkwe anerle-anerreke. ");
INSERT INTO aer_vpl VALUES ("RT1_4","009_1_4","RUT","1","4","4","Alere nhenhe atherrele arelhe apmere Moab-arenye atherre anewe akeke. Kilion-ele Orpah anewe akeke, kenhe Mahlon-ele akenhe Ruth anewe akeke. Naomi re apmere Moab ikwerele aneke alere atherre-akerte uterne 10-eke-atwetye. ");
INSERT INTO aer_vpl VALUES ("RT1_5","009_1_5","RUT","1","5","5","Yanhe ikwerenge-ntyele, Mahlon uthene Kilion uthene ilweke anteye. Kenhe Naomi re akenhe anewe-kwenye, alere atherre-kwenye aneke. ");
INSERT INTO aer_vpl VALUES ("RT1_6","009_1_6","RUT","1","6","6","Nhenge Naomi-arle apmere Moab-ele anetyarte, re aweke YAHWEH-elarle ikwere-artweye areye arntarnte-aretyame apmere Judah-ele. Rarle itnenhe merne antheme anteye. Re ayeye yanhe aweke arteke, Naomi re alpetyeke aneme apmere Moab imperle-alhetyeke apmere ikwerenhe-werne. Anherrenhenge ikwerenhe atherre ikwerenge alhetyeke aneme anteye. ");
INSERT INTO aer_vpl VALUES ("RT1_7","009_1_7","RUT","1","7","7","Kele, itne apmere renhe itne-arle anetyarte imperlte-alheke ingkele apmere Judah-werne arnpenhemele. ");
INSERT INTO aer_vpl VALUES ("RT1_8","009_1_8","RUT","1","8","8","Nhenge alpemele anteme, Naomi anherrenhenge ikwerenhe atherreke angkeke, “Apmere altyerre-werne alperraye, mpwele kwenhe atyenge mwerre anthurre aneke atyenge alere atherreke-arlke nhenge tharle renhe-atherrenhe aparlpe-ilekenge. Nhenge mpwele alherremele, YAHWEH mpweleke mwerre anthurre anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("RT1_9","009_1_9","RUT","1","9","9","YAHWEH-ele mpwelenhe apmere arrpenhe antheme anewe arrpenhe mpweleke antheme anteye.” Kele Naomi-le anherrenhenge ikwerenhe atherre arrwantyeke, kele ratherre akenhe arnterre anthurre arrangkeke, ratherre-arle renhe imperle-alherretyeke ahentye-kwenye. ");
INSERT INTO aer_vpl VALUES ("RT1_10","009_1_10","RUT","1","10","10","Anherrenhenge ikwerenhe atherre alakenhe ikwere angkeke, “Arrangkwe, ilerne ngkwengenge alheme ngkwengenge anetyeke ngkwenge-artweye areyenge-arlke.” ");
INSERT INTO aer_vpl VALUES ("RT1_11","009_1_11","RUT","1","11","11","Kenhe Naomi re akenhe ikwere-atherre angkeke, “Anherrenhenge atyinhe atherre, mpwele apmere mpwele-kenhe-werne alperraye. Iwenhenge-arle-ame mpwele atyenge apetyetyeke? The kwenhe artwe arrpenhe atherre uyarne awethe atnyeneme renhe-atherrenhe amangkelhe-ilemele mpwelenhe anthetyeke anewe aketyeke, arrangkwe anthurre-arle! ");
INSERT INTO aer_vpl VALUES ("RT1_12","009_1_12","RUT","1","12","12","Apmere altyerre-werne alperraye. Ayenge kwenhe awethe anewe aketyakenhe-arle ayenge ampwe anthurre anemele. The apeke artwe arrpenhe lyete ingwele anewe aketyeke, kele the apeke ampe urreye arrpenhe atherre atnyenemele, nthakenhe anteme-arle? Anwerne kwenhe alakenhe awethe anetyakenhe aneme, arrekwele anetyarte-arteke. ");
INSERT INTO aer_vpl VALUES ("RT1_13","009_1_13","RUT","1","13","13","Mpwele-ame urreye ikwere-atherre akarelhemele ratherre artwe akngerre irretyeke-atwetye? Mpwele-ame akarelhemere, arrpenhe areye anewe aketyakenhe anemele, renhe-atherrenhe anewe aketyeke-atwetye? Anherrenhenge atherre atyinhe nhenhele anerle-anerraye, atyengenge apetyalpetyale anewe aketyeke akarelhetyeke, iwenhe-arle atyenge irrekenge akurne-arle aneme. Kenhe nthakenhe-arle mpweleke irrekenge akurne awethe arntwarre ulkere. Atyengenge apetyalpetyale anaye, Ngkartele-arle kwenhe atyenge arlkarentye-ilekenge!” ");
INSERT INTO aer_vpl VALUES ("RT1_14","009_1_14","RUT","1","14","14","Arelhe areye awethe artnerreke. Orpah-ele anteme Naomi arrwantyeke apmere ikwere-werne alethe-irremele alpetyeke. Ruth akenhe mwernte-irreke Naomi ikwerenge renhe arnterre arntwirrkemele, impetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("RT1_15","009_1_15","RUT","1","15","15","Naomi ikwere angkeke, “Araye, arntengangkwe apmere ikwerenhe-werne alpeme, apmere altyerre ikwerenhe-werne. Ikwerenge alpaye.” ");
INSERT INTO aer_vpl VALUES ("RT1_16","009_1_16","RUT","1","16","16","Kenhe Ruth akenhe ikwere alakenhe angkirtnerlenge, “Atyenge iletyale ngenhe imperle-alhetyeke! Ayenge iletyale, ‘Ayenge apentetyale anaye!’ Unte apeke alhemele, ayenge ngkwengenge alheme. Unte apmere arrpenhele aneme, ayenge ngkwengenge aneme anteye. Ngkwenge-artweye areye atyenge-artweye areye anteye. Ngkarte ngkwinhe Ngkarte atyinhe anteye-arle. ");
INSERT INTO aer_vpl VALUES ("RT1_17","009_1_17","RUT","1","17","17","Kele nthenhenge unte ilweme-arle, ayenge yanhe ikwerele ngkwengenge ilweme anteye. Itne ayenge-inpe yanheke artentye-iwetyenhe. The ngenhe alhileme YAHWEH-nge alkngetherre ayenge ngkwengenge akwetethe alhetyeke. Ayenge ilweke-arle iperre, kele the anteme ngenhe imperle-alhetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("RT1_18","009_1_18","RUT","1","18","18","Naomi-le itelareke Ruth-arle ikwerenge alhetyeke. Naomi-le renhe awethe uterneke imperle-alhetyeke, re nterte-irremele aneke. ");
INSERT INTO aer_vpl VALUES ("RT1_19","009_1_19","RUT","1","19","19","Yanhe-ngentyele, Naomi uthene Ruth uthene alethe alhemele ratherre apmere Bethlehem-eke irrpenhe-irreke. Nhenge ratherre apmere Bethlehem-eke irrpemele, tyerrtye yanhe-arenye areye ikwere-atherre akangkemele aneke. Arelhe apmere yanhe-arenye areye angkerreke, “Naomi akunye re-ame nhenhe? Iwenhenge-ame Naomi irrare anthurre apetyeke?” ");
INSERT INTO aer_vpl VALUES ("RT1_20","009_1_20","RUT","1","20","20","Naomi-le itneke ileke, “Ayenge Naomi aketyale, rarle akenhe ilemeke “akangkentye.” Ayenge Mara akaye rarle akenhe ilemeke “irrare” Ngkartele-arle, akngerre anthurre-arle anemeke kwenhe, ayenge irrare-ilerlenge. ");
INSERT INTO aer_vpl VALUES ("RT1_21","009_1_21","RUT","1","21","21","Nhenge the apmere nhenhe imperle-alheke-iperre arrule anthurre-arle, the kwenhe arne atningke atnyeneke. Kenhe lyete, YAHWEH-ele ayenge nhenhe-werne iltye-ante akngetye-alpeke. Kele iwenhenge-arle ayenge Naomi ileme? YAHWEH-ele ayenge arlkarentye-ileke. Ngkartele kwenhe, akngerre anthurre-arle anemeke, ayenge akurne anthurre ileke.” ");
INSERT INTO aer_vpl VALUES ("RT1_22","009_1_22","RUT","1","22","22","Kele, Naomi uthene Ruth anherre ikwerenhe uthene, arelhe-arle apmere Moab-arenye anekeke, Moab-engentyele apetye-alperreke. Ratherre apmere Bethlehem-werne apetye-alherreke nhenge tyerrtye areyele annge ntange areye akemele uthnerlte-aneke barley arritnye. ");
INSERT INTO aer_vpl VALUES ("RT2_1","009_2_1","RUT","2","1","1","Artwe anyente apmere yanhe Bethlehem-ele anetyame anewe Naomi-kenheke-artweye-arle anemeke, anewe yanhe-arle ilwekeke. Artwe yanhe apmere Bethlehem-ele arne atningke anthurre atnyeneke, re kwenhe atyeperre anemele, Boaz arritnye anemele. ");
INSERT INTO aer_vpl VALUES ("RT2_2","009_2_2","RUT","2","2","2","Arlte anyentele Ruth, arelhe Moab-arenye re, Naomi-ke angkeke, “Ayenge yernaye tyerrtye areye-werne merne barley annge-arle akemele uthnerlte-apeme-werne. Arrpenhe apeke atyenge alhwarrpe-irretyenhenge the annge areye ingkernenge kutyerle-apetyenhenge.” Naomi ikwere angkeke, “Alhaye, anherreye atyinhe.” ");
INSERT INTO aer_vpl VALUES ("RT2_3","009_2_3","RUT","2","3","3","Kele, Ruth re alheke apmere tyerrtye areyele-arle merne annge akemele uthnerlte-anemeke-werne. Re warrkene yanhe areye apenteke annge ntange-arle akerlte-apekeke. Re ingkernenge apetyeke ampenye areye kutyerle-apemele. Kenhe Boaz re akenhe apmere yanheke-artweye aneke. ");
INSERT INTO aer_vpl VALUES ("RT2_4","009_2_4","RUT","2","4","4","Nhenge Boaz Bethlehem-engentyele apetyemele, re warrkene ikwerenhe areyeke angkeke, “YAHWEH arrekantherrenge aneme!” Kele warrkene ikwerenhe areye ikwere angkirtnerlenge, “YAHWEH-ele ngenhe arntarnte-areme!” ");
INSERT INTO aer_vpl VALUES ("RT2_5","009_2_5","RUT","2","5","5","Yanhe-ngentyele, Boaz-ele warrkene apayuthneke, warrkene arrpenhe areyeke-arle akngerrepate anemeke, “Angwenhe-kenhe-ame arelhe yanhe?” ");
INSERT INTO aer_vpl VALUES ("RT2_6","009_2_6","RUT","2","6","6","Warrkenele renhe tyerneke, “Arelhe yanhe Moab-arenye-arle, re Naomi-nge apetyeke apmere Moab-engentyele. ");
INSERT INTO aer_vpl VALUES ("RT2_7","009_2_7","RUT","2","7","7","Rarle ayenge apayuthnekenge, ‘Aye! Ayenge warrkene areyenge intertele alheye, annge ntange areye ahelhe-ngentyele kutyerle-apemele nhenge itnarle imperlte-apemenge.’ Ingweleme-ngentyele arltele-akake re anwerneke intertele warrke-irreke, re kwenhe nhenhele akweke ware ltyerremele aneke.” ");
INSERT INTO aer_vpl VALUES ("RT2_8","009_2_8","RUT","2","8","8","Yanhe-ngentyele, Boaz Ruth-eke angkeke, “Arelhe-aye, ayenge awaye. Tyerrtye arrpenhe areye-kenhe apmere-werne alhetyale, annge ntange itnekenhe-arle lyapeme-werne. Apmere nhenhe-ngentyele-ante annge ntange ngkwenge-arrpe inemele. Arelhe warrkene atyinhe areye apentaye. ");
INSERT INTO aer_vpl VALUES ("RT2_9","009_2_9","RUT","2","9","9","Mwantyele araye nthenhe-werne-arle warrkene artwe areye alheme annge ntange akemele kutyetyeke. Yanhe-ngentyele itnenhene ingkernenge apenterle-apaye. Tharle artwe areye ileke ngenhe ipmentyele impetyeke. Unte apeke angkethakwe irremele, kele akwenpele kwatye antywemele anaye, kwatye tyampite-nge inemele nhenge warrkene areyele ikwere-arleke thelerlenge.” ");
INSERT INTO aer_vpl VALUES ("RT2_10","009_2_10","RUT","2","10","10","Ruth anteme akaperte kwene-irremele ahelheke-arleke amperele-arlenge tnemele, re Boaz-eke angkeke, “Ayenge kwenhe ipenye, apmere arrpenhe-arenye. Iwenhenge-arle-ame unte ayenge areke iperrele atyenge anteme arnterre akangkemele aneke? Iwenhenge-ame unte atyenge mwerre anthurre aneme?” ");
INSERT INTO aer_vpl VALUES ("RT2_11","009_2_11","RUT","2","11","11","Boaz ikwere angkirtnerlenge, “The kwenhe itelareme unte-arle anherrangkwe Naomi-ke mwerre anthurre anekenge. Unte kwenhe ikwere mwerre anthurre aneke nhenge re anewe ikwerenhe aparlpe-ilekenge. Unte kwenhe ngkwenge-artweye atherre mangkwe uthene anyangkwe uthene apmere ingkerneke iwerle-alheke. Unte kwenhe apmere nhenhe-werne apetyeke, unte kwenhe tyerrtye apmere nhenhe-arenye areyeke akutne. ");
INSERT INTO aer_vpl VALUES ("RT2_12","009_2_12","RUT","2","12","12","YAHWEH ngkwenge akangkemele anthurre anetyenhe ngenhe tnakemele. Re kwenhe ngenhe mwantyele arntarnte-aremele anetyenhe, YAHWEH kwenhe Ngkarte aneme Israel-arenye areyele-arle tnakemeke. Unte kwenhe Ikwere-werne thipe akweke-arteke apetyeke mikwe ikwerenhe irlpelhe kwenele-arle anekeke, Re ngenhe arntarnte-aretyeke anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("RT2_13","009_2_13","RUT","2","13","13","Ruth imerte ikwere alakenhe angkemele, “Unte kwenhe mwerre anthurre. Unte kwenhe atyenge mwerrantye angkeke. Ayenge kwenhe irrare-arle arrekwele aneke. Ayenge kwenhe warrkene ngkwinhe kwenye, kenhe unte akenhe ayenge akangkentye-anthurre-ilerne, ayenge akwele warrkene ngkwinhe-arteke aneme. Ayenge kwenhe mwerre anetyakenhe warrkene ngkwinhe anetyeke.” ");
INSERT INTO aer_vpl VALUES ("RT2_14","009_2_14","RUT","2","14","14","Nhenge itne merne arlkwemenge, Boaz Ruth-eke angkeke, “Nhenhe-werne apetyaye! Merne anwerne-kenhe arlkwaye. Me! Merne nhenhe kere kwatye nhenheke-arleke akwernemele.” Kele, Ruth re artwe areyenge arrernelheke. Boaz-ele Ruth annge ntange itemeke-arle ure-ngentyele antheke. Ruth-ele arlkweke anhelke-irretyeke-atwetye, ntange akenhe akngerre akwete-arle. ");
INSERT INTO aer_vpl VALUES ("RT2_15","009_2_15","RUT","2","15","15","Nhenge Ruth akeme-irremele warrke-irretyeke alpeke, Boaz warrkene ikwerenhe areyeke angkerlenge, “Renhe impaye re ntange annge aharle arrpenhe areyenge inetyeke. Renhe alharlkwetyale. ");
INSERT INTO aer_vpl VALUES ("RT2_16","009_2_16","RUT","2","16","16","Ntange annge areye ahelheke ampenye-ilaye re-arrpe anteme renhe kutyetyenhenge, renhe ayaketyale mpwareme-ketye.” ");
INSERT INTO aer_vpl VALUES ("RT2_17","009_2_17","RUT","2","17","17","Kele, Ruth-ele ntange annge itnenhe angwerreke-atwetye kutyeke. Re imerte ntange arne arlparreke-arleke arrerneke imernte anthelke uthene renhe uthene akngakemele. Re yakwethe akngerre-apenheke-arleke akwerneke. ");
INSERT INTO aer_vpl VALUES ("RT2_18","009_2_18","RUT","2","18","18","Kele imernte, Ruth-ele yakwethe ikwerenhe ineke apmere-werne akngirtneke. Kele anherrikwele renhe areke annge ntange arunthe-akerte. Ruth renhe merne ampenye yanhe antheke. ");
INSERT INTO aer_vpl VALUES ("RT2_19","009_2_19","RUT","2","19","19","Naomi-le renhe apayuthneke, “Nthenhe-ngentyele-ame unte ntange annge nhenhe areye kutyeke lyete? Nthenhele-ame unte warrke-irreke lyete? Ayenge Ngkarteke angketyeke re tyerrtye yanheke mwerre anthurre anetyeke ngenhe-arle arntarnte-arekeke!” Ruth-ele ikwere artwe ikwere-akerte ileke merne arunthe-akerte-arle atnyenemeke. Re ikwere angkeke, “Artwe yanhe, ayenge-arle lyete warrke-irretyameke, Boaz arritnye.” ");
INSERT INTO aer_vpl VALUES ("RT2_20","009_2_20","RUT","2","20","20","Naomi-le anherre-anherre ikwerenhe ileke, “Kele Boaz akangkentye aneye YAHWEH-nge ularre! YAHWEH-ele kwenhe ilernenhe mwantye-mwantye-ileme ilweke-arle yanhe areyeke-arlke!” Kele imernte, Naomi-le Ruth ileke, “Boaz kwenhe anwerneke-artweye aneme. Re kwenhe anwernenhe arntarnte-areme.” ");
INSERT INTO aer_vpl VALUES ("RT2_21","009_2_21","RUT","2","21","21","Yanhe-ngentyele, Ruth ikwere angkeke, “Boaz-ele ayenge ileke ayenge ikwere akwete warrke-irretyeke, re ayenge ileke arelhe warrkene areyenge itwele anetyeke itne annge ntange ingkirreke uthnerlte-apemele inetyeke-atwetye.” ");
INSERT INTO aer_vpl VALUES ("RT2_22","009_2_22","RUT","2","22","22","Naomi anteme anherre-anherre ikwerenhe Ruth-eke angkeke, “Kele mwerre kwenhe unte-arle tyerrtye nhenhe areyenge warrke-irretyeke. Unte apeke apmere arrpenhele warrke-irreme, artwe arrpenhele apeke ngenhe akurne-ileme-ketye. Unte Boaz-enge mwerre anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("RT2_23","009_2_23","RUT","2","23","23","Kele, Ruth arelhe warrkene Boaz-kenhe areyenge iterele warrke-irretyarte. Re annge ntange areye uthnetyarte itne uyerretyeke-atwetye. Ruth anherre-anherre ikwerenhe Naomi-nge akwete anetyarte. ");
INSERT INTO aer_vpl VALUES ("RT3_1","009_3_1","RUT","3","1","1","Arlte anyentele, Naomi Ruth-eke angkeke, “Anherreye atyinhe, ayenge ngkwenge artwe anewe arrpenheke unthetyeke, unte ikwerenge alhetyeke apmere ikwerenhenge anetyeke. ");
INSERT INTO aer_vpl VALUES ("RT3_2","009_3_2","RUT","3","2","2","Kele awe anteme! Boaz kwenhe anwerne-kenheke-artweye anteye aneme. Unte kwenhe arelhe warrkene ikwerenhe areyenge warrke-irreme anteye. Lyete ingwele re yanhe ikwerele warrke-irretyenhe itne annge ntange areye arnpernetyenhenge. ");
INSERT INTO aer_vpl VALUES ("RT3_3","009_3_3","RUT","3","3","3","Alhewelhetyeke alhaye. Arne unpe akngerre nhengele apernelhaye mwerre akngerre ntyeme-arle. Mantere mwerre akngerreke irrpaye, apmere akethe ikwere-werne anteme alhaye nthenhele-arle itne annge ntange areye arnpernerlenge. Alengke-iwelhaye urrekeke-atwetye re merne arlkweke-iperre ngkwarle-arlke antywemele-iperre. ");
INSERT INTO aer_vpl VALUES ("RT3_4","009_3_4","RUT","3","4","4","Yanhe-ngentyele, re apetyemele iwelhemele. Mwantyele araye nthenhele-arle re intemeke. Nhakwe-werne alhaye, antyame ikwerenhe ingke-ngentyele akertne-ilaye imerte ikwere-arleke ankweke iwelhemele. Yanhe-ngentyele ankwe-irremele intaye. Nhenge re ngenhe aremele, re ngenhe ileme nthakenhe-irretyeke.” ");
INSERT INTO aer_vpl VALUES ("RT3_5","009_3_5","RUT","3","5","5","Ruth ikwere angkirtneke, “Nthakenhe apeke unte atyenge angkeme, ayenge akangkwe-irremele renhe mpwareme anteme.” ");
INSERT INTO aer_vpl VALUES ("RT3_6","009_3_6","RUT","3","6","6","Kele, Ruth apmere akethe ikwere-werne alheke itne annge ntange areye arnpernerlenge. Kele re mpwareke anthurre nthakenhe-arle anherrikwele renhe ileke. ");
INSERT INTO aer_vpl VALUES ("RT3_7","009_3_7","RUT","3","7","7","Kele nhenge merne-arlke arlkweke-arle iperre ngkwarle-arlke antywemele, Boaz re akangkemele anthurre awelheke. Re apetyeke annge ntange areye itweke iwelhemele. Ruth anteme ikwere-werne mwantye anthurre alheke. Re antyame ingke ikwerenhe-ngentyele mwantye anthurrele akertne-ileke, imerte iwelhemele. ");
INSERT INTO aer_vpl VALUES ("RT3_8","009_3_8","RUT","3","8","8","Ingwe mpwepele anteme, Boaz iparrpe akeme-irreke akertneke alkngarelhemele areke. Re apatemele anthurre aneke arelhe-arle ingke ikwerenhe itwele interlenge. ");
INSERT INTO aer_vpl VALUES ("RT3_9","009_3_9","RUT","3","9","9","Boaz-ele renhe apayuthneke, “Angwenhe-ame unte?” Re angkeke, “Ayenge-arle Ruth, ngkwinhe warrkene. Unte kwenhe atyenge-artweyeke aneme. Unte kwenhe ayenge arntarnte-aretyeke. Ayenge antyame ngkwinhele artaye. Unte apeke ayenge artemele, kele the anteme itelareme unte ayenge anewe aketyenhe.” ");
INSERT INTO aer_vpl VALUES ("RT3_10","009_3_10","RUT","3","10","10","Kele Boaz ikwere alakenhe angkeke, “YAHWEH-ele ngenhe mwerre atnyeneme. Unte kwenhe mwerre anthurre aneme unte Naomi-ke anekeke-amparre-arteke. Unte kwenhe artwe apmerrkeke anewe aketyeke uyarne untheme, nhenge apwerte mane arunthe-akerte apeke nhenge apwerte mane kwenye apeke, arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("RT3_11","009_3_11","RUT","3","11","11","Kele atere-irretyalaye. The ngkwenge iwenhe apeke renhe mpwareme unte-arle ayenge apayuthnerlenge. Tyerrtye apmere nhenhe-arenye areye-arle ngkwenge akaltye-arle aneme unte-arle mwerre anthurre aneme. ");
INSERT INTO aer_vpl VALUES ("RT3_12","009_3_12","RUT","3","12","12","Arratye anthurre-arle. Ayenge akwele ngkwenge-artweyeke arratye aneme the ngenhe arntarnte-aretyenhe. Kenhe artwe arrpenhe akenhe aneme ngkwenge akwerrke anteye. Rarle kwenhe ngkwenge-artweye anthurre-arle. Nhenge re apeke ngenhe arntarnte-aretyekeke-amparre. ");
INSERT INTO aer_vpl VALUES ("RT3_13","009_3_13","RUT","3","13","13","Nhenhele lyete ingwele anaye. The renhe apayuthnetyeke alheme re apeke ngenhe arntarnte-aretyeke ahentye aneme. Re apeke ngenhe inemele arntarnte-aretyeke, kele mwerre-arle. Kenhe arrangkwenge, tharle anteme ngenhe arntarnte-aretyenhe. Yanhe ikwerenge-ntyele the ngkwenge ahelhe Elimelech-kenhe apwerte manele inirtneme. YAHWEH kwenhe arratye itethe anthurre aneme, Re ingkirreke awemele ayenge angkerlenge. The ngenhe arratye anthurre ileme, tharle ngkwenge ahelhe renhe inirtnetyenhe. Kele nhenhele intaye ingwelemeke ante.” ");
INSERT INTO aer_vpl VALUES ("RT3_14","009_3_14","RUT","3","14","14","Kele Ruth yanhe ikwerele ingke ikwerenhe itweke inteke ingwelemeke-ante. Re akarre-irreke, ingwele-atnhele ware alherle-iwerlenge arrpenhe areyele apeke renhe areketye. Kenhe Boaz akenhe ikwere angkeke, “Apmere-werne nterte alpaye, arrpenhe areyele areketye unte-arle nhenhe-werne apetyeke, apmere nhenhe-werne itne-arle annge ntange arnpernemeke.” ");
INSERT INTO aer_vpl VALUES ("RT3_15","009_3_15","RUT","3","15","15","Kele imerte Boaz Ruth-eke angkeke, “Urreke unte alpetyenhenge, antyame ngkwinhe akngetyaye ahelheke antekelhe-ilaye.” Kele Ruth re antyame ahelheke-arleke arrerneke renhe antekelhe-ilemele, kele imerte Boaz-ele annge areye thelemele renhe akngerre anthurre antheke. Boaz-ele anteme antyame annge ntange-akerte ikwere artepeke arrerneke, kele re apmere ikwerenhe-werne alperlenge. ");
INSERT INTO aer_vpl VALUES ("RT3_16","009_3_16","RUT","3","16","16","Ruth anherreye ikwerenhe-werne alpeke. Re apmerele aneke-iperre Naomi-le renhe apayuthnerlenge, “Iwenhe renhe-ame unte mpwareke, anherre atyinhe? Nthakenhe-arle-irreke?” Kele imerte Ruth-ele ikwere ileke nthakenhe-arle irrekenge. ");
INSERT INTO aer_vpl VALUES ("RT3_17","009_3_17","RUT","3","17","17","Re ileke, “Boaz-ele ayenge annge ntange arunthe antheke. Re atyenge angkeke, ‘Unte anherre-anherre ngkwinhe-werne iltye-ante merne kwenye alpetyeke arrangkwe.’” ");
INSERT INTO aer_vpl VALUES ("RT3_18","009_3_18","RUT","3","18","18","Naomi ikwere angkirtnerlenge, “Ruth, anherreye atyinhe, Boaz-eke akarelhaye nthakenhe-arle re angketyenheke ngkwenge. Ngenhe-arle re impetyakenhe anetyenhe. Rarle artwe ampwe areyeke ngkwenge-akerte ingweleme apeke angketyeke alheme, lyete angwerrele apeke.” ");
INSERT INTO aer_vpl VALUES ("RT4_1","009_4_1","RUT","4","1","1","Boaz apmere akngerre arriwe-werne alheke, re yanhe ikwerele akarelheke artwe artweyikweke-arle apetyemeke, nhenge rarle arrekwele-arle angkekeke nhenge Elimelech-kenheke-artweyikwe-arle. Artwe rarle thewe nhenge reke-amparrele-arle Naomi uthene Ruth uthene arntarnte-aretyeke anemeke. Boaz ikwere arlkeke, “Atyewe atyinhe, nhenhe-werne apetyaye! Ngkwenge-arle thewe ayenge untherle-apeme. Nhenheke arrernelhaye!” Kele artwe apetyemele arrernelhemele aneke anteme. ");
INSERT INTO aer_vpl VALUES ("RT4_2","009_4_2","RUT","4","2","2","Kele Boaz alheke artwe ampwe 10-pele inerle-alpetyeke apmereke-artweye arrpenhe areye-arlke. Re itneke angkeke, “Apetyewarraye nhenhele arrernelhetyeke!” Kele itne anerrirreke. ");
INSERT INTO aer_vpl VALUES ("RT4_3","009_4_3","RUT","4","3","3","Boaz anteme ikwere artweyeke alakenhe angkeke, “Naomi kwenhe apmere Moab-engentyele apetyalpeke. Re kwenhe ahentye aneme ahelhe nhenhe apwerte maneke anthetyeke Elimelech ilerne-kenheke-artweye-arle anekeke. ");
INSERT INTO aer_vpl VALUES ("RT4_4","009_4_4","RUT","4","4","4","Ayenge kwenhe ngkwenge itirremele angketyeke. Unte apeke mwerre aneme ahelhe nhenhe inetyeke, kele apwerte manele akwenpele inaye! Ahelhe renhe inaye tyerrtye nhenhe areyenge alkngetherre anthurre itne anteme renhe arrakwernetyenhenge, artwe ampwe nhenhe areyenge alkngetherre anthurre anwerne-kenhe akngerrepate areye-arle anemeke. Unte apeke mwerre kwenye, atyenge ilaye. The kwenhe apmere nhenhe inetyeke ahentye aneme. Unte apeke imperlenge, inetyakenhele, kele tharle inetyenhenge anteme.” Kele ikwere-artweye ikwere angkeke, “Kele, the kwenhe apmere nhenhe ineme.” ");
INSERT INTO aer_vpl VALUES ("RT4_5","009_4_5","RUT","4","5","5","Yanhe-ngentyele anteme Boaz ikwere angkeke, “Unte apeke ahelhe yanhe Naomi-ngentyele ineme, kele unte Ruth-arle anewe aketyekeke-amparre, re apele anherre-anherre ikwerenhe Naomi-nge-arle anemeke, nhenge re anewikwe aparlpe-ileke. Arelhe re kwenhe apmere Moab-arenye. Nhenge mpwele apeke ampe atnyenemele, kele itne artwe-kenhe-arle aparlpe-ilekeke. Kele ahelhe yanhe-inpe akenhe artwe ikwerenheke artweye areyeke.” ");
INSERT INTO aer_vpl VALUES ("RT4_6","009_4_6","RUT","4","6","6","Kele ikwere-artweye ikwere angkirtnerlenge, “Iwenhe unte angkeme arratye-arle, kele the akenhe ahelhe yanhe inetyeke arrangkwe-arle. Nhenge the apeke inemele, kele the ahelhe yanhe alere atyinhe uyarne antheme. Arrangkwe, the ahelhe yanhe inetyeke arrangkwe-arle. Kele ngkwenge-arrpe inaye!” ");
INSERT INTO aer_vpl VALUES ("RT4_7","009_4_7","RUT","4","7","7","Arrule anthurre apmere Israel-enge, nhenge itnarle ahelhe apwerte manele inetyarte, tyerrtye ingke-kenhe anyente irlwelhetyarte imerte tyerrtye arrpenhe anthemele. Alakenhe ikwerenge itne anthetyarte tyerrtye atningkeke alkngetherre anthurre itne anteme itelareme angwenhe-kenhe ahelhe anteme yanhe. ");
INSERT INTO aer_vpl VALUES ("RT4_8","009_4_8","RUT","4","8","8","Akwerrke ikwere Boaz-eke angkeke, “Unte kwenhe ahelhe nhenhe inaye.” Re angkirtnerlenge, “Kele, tharle ineme.” Kele ingke-kenhe ikwerenhe irlwelheke imerte Boaz anthemele. ");
INSERT INTO aer_vpl VALUES ("RT4_9","009_4_9","RUT","4","9","9","Kele imerte Boaz artwe ampwe itneke angkeke, arrpenhe areyeke-arle tnerlte-anemeke, “Arrantherre ayenge arrakwerneme tharle ahelhe nhenhe Naomi-ngentyele apwerte manele ineme. The kwenhe ingkirreke anthurre Elimelech-kenhe ineme, Kilion uthene Mahlon uthene-kenhe-arlke. ");
INSERT INTO aer_vpl VALUES ("RT4_10","009_4_10","RUT","4","10","10","Ruth kwenhe apmere Moab-arenye arrekwele aneke. Kele mwerre-arle. Kele the Ruth anteme ineme the arne areye arntarnte-aretyeke anewe arrekwelenge ikwerenhe-arle anekeke. Ilerne apeke ampe areye atnyenemele, itne akenhe akngeye-kenhe-arle ilwekeke. Kele the Ruth anewe anteme akeme. Re yanhe-arle thewe Moab-arenye Mahlon-enge-arle anekeke. Kele the renhe anewe akeme nhenge arne areye anewe Ruth-kenhe anetyenhenge ikwere akwerrke areyeke. Tyerrtye apmere nhenhe-arenye areyele renhe itelaretyenhenge, itne ikwere alkngwirretyakenhe anetyenhe. Alakenhe akwele re arritnye ikwerenhe aparlpe-iletyakenhe anetyenhe, itne apmere itnekenhele akwete-ante-arle anerlte-aneme. The nhenhe mpwareke arrekantherrenge alkngetherre anthurre. Kele arrantherre ayenge arrakwerneme.” ");
INSERT INTO aer_vpl VALUES ("RT4_11","009_4_11","RUT","4","11","11","Kele, tyerrtye areye, artwe ampwe areye-arlke arriwele-arle anemeke, itne Boaz-eke angkeke, “Kele, anwerne ngenhe arrakwerneke. Arelhe nhenhe apmere ngkwinhe-werne apetyetyenhe.” Nhenge itne Ruth-akerte angkemele itne Boaz-eke angkeke, “YAHWEH-ele ngenhe arntarnte-areme anewe ngkwinhe mwerre anetyeke Rachel uthene Leah uthene-arteke, ratherre apmere arrule-arle anekeke, ampe atningke atnyenemele anteye. Ratherre kwenhe ampe atningke-akerte aneke. Arratye, ikwere-atherre-ngentyele tyerrtye Israel-arenye atningke-ame-atningke anteme irreke. Unte lterrke anetyenhe apmere Ephrathah-ke. Unte ahawethe anthurre anetyenhe apmere Bethlehem-enge.” Kele imerte itne Boaz-eke awethe angkeke, ");
INSERT INTO aer_vpl VALUES ("RT4_12","009_4_12","RUT","4","12","12","“Tamar-ele Judah-eke alere atnyeneke Perez arritnye. Alakenhe-anteye YAHWEH-ele mpwelenhe ampe areye anthetyenhe, Ruth mpwelenhe. Kele ngkwenge-artweye areye mwerre anthurre anetyenhenge Perez-arteke, itne impene akngerre-irretyenhe Perez areye-arteke. Ngkwenge akwerrke areye atningke-irretyenhe, Perez-kenhe areye-arteke atningke-irrerlenge.” ");
INSERT INTO aer_vpl VALUES ("RT4_13","009_4_13","RUT","4","13","13","Kele, Boaz-ele Ruth anewe akeke. YAHWEH mwerre anthurre Ruth-eke aneke, re anteme atnerte-atnerte anteme irrekenge. Urreke anteme re ampe urreye akweke atnyeneke. ");
INSERT INTO aer_vpl VALUES ("RT4_14","009_4_14","RUT","4","14","14","Arelhe areyele Naomi ileke, “Ingkerrekele YAHWEH tnakewarreye! YAHWEH-eke akangkemele angkeye Rarle ngenhe ipmenhe anthekenge. Re kwenhe ahawethe anthurre anetyenhe apmere Israel-enge. ");
INSERT INTO aer_vpl VALUES ("RT4_15","009_4_15","RUT","4","15","15","Re ngenhe lterrke-iletyenhe, ngenhe mwantyele arntarnte-aremele nhenge unte arelhe ampwe-irrerlenge. Kele nhenhele imerneme, anherre-anherre ngkwinhe kwenhe ngkwenge arnterre-arle ahentye aneme, re ngkwenge mwerre anthurre aneme, tyerrtye arrpenhe areye-arteke kwenye. Re kwenhe ngkwenge-arle impene anthurre aneme, ampe urreye seven-enge impene ulkere. Re kwenhe ngkwenge ipmenhe atnyeneke.” ");
INSERT INTO aer_vpl VALUES ("RT4_16","009_4_16","RUT","4","16","16","Naomi-le urreye akweke ampe ikwerenhe-kenhe ineke, renhe anyanemele anartwele atnyenemele, re renhe arntarnte-areke re amangkerlenge. ");
INSERT INTO aer_vpl VALUES ("RT4_17","009_4_17","RUT","4","17","17","Arelhe Bethlehem-arenye areyele, nhenge akweke rarle intekenge arritnye antheme, alakenhe anteme angkeke, “Naomi-le ampe urreye atnyeneme.” Tyerrtye areyele renhe Obed arritnye antheke. Urreke-arle, Obed Jesse-ke-artweye irreke, kele Jesse anteme David-eke-artweye irreke aneke. ");
INSERT INTO aer_vpl VALUES ("RT4_18","009_4_18","RUT","4","18","18","Nhenhe areye Perez-eke-artweye aneme. Perez akenhe Hezron-eke artweye aneke. ");
INSERT INTO aer_vpl VALUES ("RT4_19","009_4_19","RUT","4","19","19","Hezron akenhe Ram-eke artweye aneke. Ram akenhe Amminadab-eke artweye aneke. ");
INSERT INTO aer_vpl VALUES ("RT4_20","009_4_20","RUT","4","20","20","Amminadab akenhe Nahshon-eke artweye aneke. Nahshon akenhe Salmon-eke artweye aneke. ");
INSERT INTO aer_vpl VALUES ("RT4_21","009_4_21","RUT","4","21","21","Salmon akenhe Boaz-eke artweye-arle aneke. Boaz akenhe Obed-eke artweye aneke. ");
INSERT INTO aer_vpl VALUES ("RT4_22","009_4_22","RUT","4","22","22","Obed akenhe Jesse-ke artweye-arle aneke, Jesse akenhe David-eke artweye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Israel-arenye areyeke Angkentye nhenhe Jesus Christ-akerte. Jesus Christ arrateke David Akngerrepateke-artweye-ngentyele arrule-arle anetyarteke. David Akngerrepate re akenhe Abraham-eke-artweye-ngentyele-arle arrateke arrule-arle ikwerenge arrekwele anetyarteke, kele David-engentyele atningke arrpenhe areye-arlke anteme inteke arrpenhe anteme arrpenhe anteme. Kele ikwerenge-ntyele arrulenge arrpenhele anteme Jesus anteme inteke. Abraham-engentyele nhenhe arritnye areye aneke arrpenhe-ngentyele arrpenhe anteme Jesus-arle inteke-werne-atheke, nhenhe-arle arritnye arrpenhe itne Jesus-enge arrekwele aneke: ");
INSERT INTO aer_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Alere Abraham-kenhe Isaac arritnye, alere Isaac-kenhe arritnye Jacob-arle, alere Jacob-kenhe areye aneke Judah uthene atyeye ikwerenhe areye-arlke. ");
INSERT INTO aer_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Alere Judah-kenhe atherre Perez uthene Zerah uthene-arle arritnye. Mikwe ikwere-atherrenheke Tamar arritnye. Alere Perez-kenhe anteme Hezron aneke akenhe alere ikwerenhe akenhe Ram-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Alere Ram-kenhe arritnye akenhe Amminadab-arle aneke, alere Amminadab-kenhe Nahshon-arle aneke, alere Nahshon-kenhe Salmon-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon-ele arelhe Rahab arritnye anewe akeke alere anteme ikwere-atherrenhe Boaz arritnye aneke, Boaz-ele marle Ruth arritnye anewe akeke alere ikwere-atherrenhe anteme Obed arritnye aneke. Alere Obed-kenhe Jesse arritnye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Alere Jesse-kenhe David-arle aneke, arrantherre itelareme Ngkartele-arle renhe akngakeke King anetyeke tyerrtye Israel-arenye areyeke. Alere David-kenhe Solomon arritnye-arle aneke. Meye Solomon-kenhe anewe aneke artwe Uriah arritnyeke-arle arrekwele. ");
INSERT INTO aer_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Alere Solomon-kenhe Rehoboam arritnye-arle aneke, kenhe alere ikwerenhe akenhe Abijah arritnye-arle aneke. Alere Abijah-kenhe Asaph arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Alere Asaph-kenhe Jehoshaphat arritnye-arle aneke kenhe alere ikwerenhe akenhe Joram arritnye-arle aneke, alere Joram-kenhe Uzziah arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Alere Uzziah-kenhe Jotham arritnye-arle, kenhe alere ikwerenhe akenhe Ahaz, alere Ahaz-kenhe Hezekiah arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Alere Hezekiah-kenhe Manasseh arritnye-arle aneke alere ikwerenhe akenhe Amon arritnye-arle aneke, alere Amon-kenhe akenhe Josiah arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Alere Josiah-kenhe atningke aneke Jeconiah uthene kake ikwerenhe areye-arlke. Ikwerenge-ntyele anteme Babylon-arenye areye apetyemele Israel-arenye areye apmere Babylon-werne akngetye-alpeke. ");
INSERT INTO aer_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Alere Jeconiah-kenhe aneke Shealtiel arritnye kenhe alere ikwerenhe arritnye Zerubbabel-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Alere Zerubbabel-kenhe aneke Abiud-arle alere ikwerenhe akenhe Eliakim arritnye-arle, kenhe alere ikwerenhe akenhe Azor arritnye-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Alere Azor-kenhe Zadok arritnye-arle, alere ikwerenhe akenhe Akim arritnye-arle, alere Akim-kenhe Eluid-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eluid-eke alere akenhe Eleazar arritnye-arle aneke, alere ikwerenhe akenhe Matthan arritnye-arle, alere ikwerenhe akenhe Jacob-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Alere Jacob-eke Joseph-arle aneke, arrantherre itelareme anewe Mary-kenhe, kele Mary-ele anteme ampe atnyeneke Jesus arritnye, arritnye arrpenhe Christ, nhenge Ngkartele-arle alhileke. ");
INSERT INTO aer_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Altye nhenhe areye-ngentyele Jesus inteke, arrenge-arrenge Abraham-kenhe 14-pele anthurre aneke anyente-ame-anyente itne arrateke David-eke-atwetye. Kele David-engentyele awethe arrenge-arrenge areye-akerte. Kele ikwerenge awethe 14-pele arrateke arrenge-arrenge itne anyente-ame-anyente anteme itne ilweke. Kele thultye areye anteme apetyeke itnenhe Babylon-werne akngetyeke. Kele ikwerenge awethe 14-pele arrateke arrenge-arrenge itne anyente-ame-anyente anteme itne ilweke, itneke-ngentyele anteme Jesus inteke. ");
INSERT INTO aer_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Angkentye nhenhe nthakenhe-arle Christ inteke-akerte, re akenhe Ngkartele-arle alhileke-arle yernetyeke. Arelhe awenke anyente Mary arritnye, artwe Joseph arritnye-arle, ratherre nhenge inerretyeke. Urreke-arle Joseph-ele Mary anewe aketyenhenge, Utnenge Akngerre ikwere-werne apetyeke renhe atnerte-atnerte mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Nhenge Joseph-ele Mary areke re apale itirreke artwe arrpenhele-arle akwele ingkernenge akurne mpwarekeke, rarle akutne aneke nthakenhe-arle Utnenge Akngerrele mpwarekeke. Joseph artwe mwerre anthurre aneke re atywerrenge Jew-arenye areye-kenheke akangkwe-irretyarte re Mary apurele-anthetye-kwenye ahentye-aneke atningkele awerlenge. Re itirreke, “Iwenhenge-arle-ame the marle atnerte-atnerte anewe aketyeke ahentye aneme? Ayenge ikwere nterte-nterte angkeye, renhe ipmentye impemele.” ");
INSERT INTO aer_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Nhenge Joseph-arle alakenhe itirretyamenge, alkere-arenye Ngkarte-kenhe arrateke Joseph-eke, re altyerre arerle-anerlenge, re anteme ikwere angkeke, “Joseph, David-eke-artweye, apure-irretyalaye Mary anewe aketyeke, ampe akweke nhenhe Utnenge Akngerre-ngentyele-arle, artwe arrpenhe-kenhe anetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Re anteme ampe atnyenetyenhe, re akweke renhe atnyenemele unte renhe Jesus arritnye anthetyeke, rarle tyerrtye ikwerenhe areye itetheke mpwaretyenhenge ilweketye, itne-arle arne akurne mpwarewarrerlenge.” Alakenhe renhe utnenge alkere-arenye Joseph-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Angkentye nhenhe areye alakenhe-irreke Ngkartele-arle arrule anthurre ilekenge artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Isaiah-eke alakenhe kwenhe arratye anetyenhe. Re alakenhe angkeke, ");
INSERT INTO aer_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Awaye, arelhe awenke anyente artwenge-arlke arrekwelenge intetyakenhe atnerte-atnerte-irretyenhe imerte ampe akweke atnyenemele, itne anteme renhe “Immanuel” iletyenhe,” arritnye nhenhe alakenhe ileme, “Ngkarte anwernekenge apurte aneme.” Alakenhe-arle alkere-arenye utnenge Joseph-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Joseph re anteme akeme-irremele ankwenge-ntyele utnenge alkere-arenye renhe-arle aweke-iperre re Mary anewe akeke imerte renhe arntarnte-aremele apmere ikwerenhenge. ");
INSERT INTO aer_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ratherre akenhe apurte intetyakenhe-arle aneke ampe akweke ikwere akarelhemele intetyeke. Yanhe iperre ampe akweke rarle intekenge anteme ratherre akweke renhe Jesus arritnye antheke. ");
INSERT INTO aer_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesus inteke apmere Bethlehem arritnye-enge apmere akngerre Judea-nge, ikwerenge artwe anyente Herod arritnye apmere Judea-ke akngerrepate aneke. Kele Jesus-arle inteke-iperre artwe akaltye anthurre urrpetye ikngerre-ngentyele Jerusalem-werne apetyeke. Itne akngerre itelareke kwerralye areye arerlte-apemele ware. ");
INSERT INTO aer_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Itne Jerusalem-eke-irremele itne tyerrtye apmere-arenye areye apayuthneke, “Nthenhele-ame ampe akweke re inteke, akngerrepate Jew areye-kenhe arrantherre itelareme? Ikngerrele anerlte-aneme anwerne areke kwerralye akngerre arraterlenge lyete-ante. Kwerralye renhe areke-arle iperre anwerne itirreke, ‘Jew areyeke akngerrepate-arle inteke.’ Alakenhenge anteme anwerne apetyeke ikwere akangkentye.” ");
INSERT INTO aer_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Kele nhenge Herod Akngerrepatele awemele artwe akngerre urrpetye-arle untherlte-apekenge ampe akweke inteke-arle ikwere, re akwele akngerrepate anetyenhenge, Herod arnterre anthurre itirremele, ingkerte-irremele itirreke, “Ampe akweke nhenhe apeke amangkemele apmere atyinheke-artweyeke akngerrepate irreme, ayenge-tetye.” Jerusalem-arenye areye atere-irreke, Herod-arle anyingkeke awemele. ");
INSERT INTO aer_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Aweke-arle iperre, Herod-ele kwertengerle akngerrepate tyatye-arenye areye apurtelhe-ileke angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye-arlke, re anteme itnenhe apayuthneke, “Nthenhenge-ame angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyele ileke Christ, Ngkartele-arle alhileke-arle intetyenheke?” ");
INSERT INTO aer_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Itne akenhe ikwere ilerlenge, “Re kwenhe apmere Bethlehem-ele intetyenhe apmere Judea ikwerele. Anwerne itelareme artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Micah-elarle arrule intelhe-ilekenge. Alakenhe-arle re intelhe-ileke: ");
INSERT INTO aer_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Awerrirraye apmere akweke nhenge Bethlehem-arenye areyele, apmere akngerre Judea ampinyele! Apmere arrekantherrenhe impene anthurre, artwe-arle apmere arrekantherre-ngentyele akngerrepate anetyenhenge. Re Israel-arenye atyinhe areye arntarnte-aretyenhe, yepe-yepe arntarnte-arentye akngerrele yepe-yepe ikwerenhe areye arntarnte-areme-arteke.’” Alakenhe-arle itne Herod-eke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Herod-ele alakenhe awemele re angkentye yerneke artwe akaltye anthurre urrpetyeke renhe nterte-ntertele aretyeke apetyetyeke. Kele re anteme akaltye-irreke ilengare anthurre-arle kwerralye arrule arratekeke. ");
INSERT INTO aer_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Re anteme itnenhe ularele ileke itneke alakenhe angkemele, “Bethlehem-werne alherlte-iwaye ampe akweke ikwere mwantyele aretyeke imerte apetyalpemele atyenge iletyeke ayenge anteme alhetyenhenge renhe aretyeke.” Re anteme itnenhe Bethlehem-werne yerneke. ");
INSERT INTO aer_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Kele renhe-arle aweke-iperre itne alheke anteme. Itne imerte aremele kwerralye renhe ikngerrenge-arle arrateke renhe itne imerte akangkemele anthurre aremele arteke. Kwerralye re itnekenge arrekwelele akwete alheke apmere Bethlehem-ele apmere nthenhele-arle ampe akweke rarle intetyame ikwerenge tnetye-alpetyeke. ");
INSERT INTO aer_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Apetyemele arteke itne apmere kwene-werne irrpenheke imerte ampe akweke renhe aremele Mary meye ikwerenhenge. Itne anteme kwene-irremele akweke renhe tnakemele arne mwerre akngerre itne-arle akngetyeke areye imerte altywere-ilemele anthemele apwerte gold, mwerre akngerre ntyentye akngerre arne atherre frankincense uthene myrrh uthene. ");
INSERT INTO aer_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Yanhe-ngentyele itne itirremele Herod-werne alpetyeke, kenhe ingwe ikwerele itne-arle ankwe anekenge Ngkartele itnenhe altyerrenge ileke Herod-werne alpetyale anetyeke. Ingweleme anteme itne apmere itnekenhe-werne alperlte-iweke Herod-ketye iwerre arrpenhele. ");
INSERT INTO aer_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Artwe yanhe urrpetye alpekenge-arle anteme, alkere-arenye Ngkarte-kenhe arrateke Joseph-eke ingwele altyerrenge imerte ikwere angkemele, “Iparrpe akeme-irraye, akweke nhenhe akngetyeke meye ikwerenhe uthene apmere Egypt-werne thultye Herod-kenhe areye-arle akweke nhenhe atwetyeke unthetyenhe-ketye. Ikwerele urrekeke-atwetye anemele the ngenhe iletyeke ilengareke-atwetye unte apetyalpetyeke the ngenhe ilerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kele ingwe ikwerele antime Joseph akeme-irreke imerte menhenge atherre akngemele Egypt-werne. ");
INSERT INTO aer_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Egypt-eke arteke-irremele itne aneke akweke renhe arntarnte-aremele arruleke-atwetye Herod ilwetyeke-atwetye. Alakenhenge anteme iwenhe-arle Ngkarte angkeke arrule artwe angkentye Ikwerenhe awemele ilerle-apentye akngerre Hosea-ke arratye-arle irrerlenge. Hosea alakenhe angkeke, “Ampe atyinhe alhetyeke Egypt-werne anetyeke, yanhe-ngentyele anteme the renhe iletyenhe apmere ikwerenge impemele apetyalpetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Herod uyarne akarelheke artwe akaltye anthurre urrpetyeke apetyalpetyeke re anteme aweke itne-arle renhe ularele ileke itne imerte apmere itnekenhe-werne anteme alperlte-iwemele re ahele anthurre irreke. Kele imerte re thultye ikwerenhe areye ileke ampe urreye akweke areye atwetyeke Bethlehem-ele apmere itwele-arle aneme areyeke-arlke. Re ileke ampe akngerre ulkere areye-arlke atwetyeke, nhenge uterne atherreke-arle aneke areye-arlke. Re alakenhe irreke re itelarekenge artwe urrpetye itne-arle ileke kwerralye arrekwelenye renhe aremele, re anteme itirreke, “Re kwenhe ampe akweke ware apeke, lyete-ante apeke-arle unthentye irreme.” Thultye ikwerenhe areyele akenhe arratye-arle ampe urreye areye atweke. ");
INSERT INTO aer_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","18","Alakenhenge anteme iwenhe-arle Ngkarte angkeke arrule artwe angkentye Ikwerenhe awemele ilerle-apentye akngerre Jeremiah-nge anpere-irrenheme arratye-arle irrerlenge. Alakenhe anteme re intelhe-ileke, “Apmere Ramah arritnyenge itne aweme arelhe arnterre anthurre artnerlenge, Re akenhe arelhe Rachel-arle aneke irrare-irrare, ampe ingkirreke-ante-arle ikwerenhe uyerrekenge. Itne anteme uyarne anthurre renhe ntertele ileke ampe areye-arle ilwekenge ikwerenhe.” Angkentye nhenhe akenhe arratye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Ikwerenge-ntyele Herod-arle ilwekenge anteme alkere-arenye Ngkarte-kenhe awethe arrateke Joseph-eke nhenge re altyerre aremele Egypt-nge. ");
INSERT INTO aer_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Alkere-arenye utnenge re ikwere angkeke, “Akeme-irraye, menhenge atherre inerle-alhemele alpaye apmere ngkwinhe Israel-werne. Kele mwerre anteme artwe ampe akweke renhe-arle atwetyeke aneke-arle kele ilwekenge.” ");
INSERT INTO aer_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Kele arratye Joseph-ele renhe-atherrenhe inerle-alhemele alpeke apmere Israel-werne. ");
INSERT INTO aer_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Kele re arrernelhemele aweke Archelaus, alerikwe Herod-kenhe akngerrepate anerlenge apmere Judea ikwerele. Akngeye ikwerenhe ilweke-arle iperrenge re anteme-arle apmere Judea-ke akngerrepate aneke. Nhenge Joseph-ele awemele re atere-irreke re ahentye-anetyakenhe-irreke apmere ikwere-werne alpetyeke. Kele awethe, altyerre arrpenhe anteme re areke utnenge alkere-arenye nhengele renhe ileke re Judea-werne alpetyale anetyeke re ayerrere alhetyeke apmere kwatye alaye itwele Galilee-werne rarle mwerre anetyenheke. ");
INSERT INTO aer_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Re anteme alheke apmere akngerre Nazareth arritnye-werne ikwerele anteme re aneke. Re Nazareth-werne alhemele alpeke alakenhenge anteme arratye aneke Jesus Anwerneke-artweye-arle angkeke arrule artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyeke, itne anteme alakenhe renhe intelhe-ileke, “Artwe Ngkartele-arle alhileke rarle Nazareth-arenye-arle anetyenhe, tyerrtye areye anteme ikwere angkerrirretyenhe artwe nhenhe-arle Nazareth-arenye-arle.” Nhenge Joseph-ele anteme Jesus Nazareth-werne akngeke, angkentye nhenhe akenhe arratye-arle aneke. ");
INSERT INTO aer_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ikwerenge-ntyele uterne arrpe-anenhe-arle anpere irrenhekenge, artwe John arritnye, nhenge tyerrtye areye kwatyeke akwernentye akngerre, angkentye iletyame Ngkarte-akerte tyerrtye atningkeke apmere ahurratye Judea ikwere. ");
INSERT INTO aer_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Re anteme alakenhe angkeke, “Akurnenge utepe-irraye Ngkarte-werne-atheke, kele arlte angathe anteme-arle irremenge Ngkarte-arle tyerrtye areyeke akngerrepate anetyenhenge itnenhe arntarnte-aremele.” ");
INSERT INTO aer_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","John akwele artwe re, arrantherre itelareme angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Isaiah arritnyele-arle ileke ikwere-akerte alakenhe ilemele, “Tyerrtye anyente kwenhe apmere ahurratye-arenye arlkerle-apeme tyerrtye areyeke ikwere-werne apetyerlenge-arle, alakenhe: ‘Ngkarte Anwerneke-artweyeke arratye-irreraye arrekwele nhenge re apetyemele angkerlenge, arrantherre mwantyele awerrirretyeke. Arrantherre itelareme artwele iwerre arratye-ilerlenge akngerrepate ingkerne apetyetyenhenge. Alakenhe akwele arrantherre arratye-irremele akarelhemele anetyeke, Nhenge Ngkarte Anwerneke-artweye apetyemele angketyeke, arrantherre renhe mwantyele awetyeke ikwere akangkwe-irremele.’” ");
INSERT INTO aer_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Nhenge mantere ikwerenhe akenhe alte kamule-kenhe-ngentyele-arle mpwareke, re ulte ikwerenge ayernelheke irrtnye kere-kenhele-arle. Re inteltye uthene ngkwarle urltampe uthene arlkwetyarte. ");
INSERT INTO aer_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tyerrtye atningke apetyewarretyarte renhe angkerlenge awetyeke. Itne apmere Judea-ngentyele apetyewarreke, apmere Jerusalem-engentyele anteye apetyewarretyarte, apmere itweke-itweke arrpenhe areye-ngentyele-arlke, lhere akngerre Jordan-engentyele-arlke, lhere nhenhe kwatye urewe-arle. ");
INSERT INTO aer_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Re angkerlenge itne renhe awemele apure-irrerirreke, itne anteme ingkirreke ikwere akethe ilelheke arne akurne areye itne mpwaretyarte-arle. Re anteme aweke-arle-iperre itne ilelherlenge, re itnenhe kwatyeke akwerneke Jordan lhereke imerte itnenhe baptise-eme-ilemele. ");
INSERT INTO aer_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Artwe Pharisee uthene Sadducee uthene areyele renhe apayuthneke itnenhe-arlke kwatyeke akwernetyeke. John-ele itnenhe aremele alakenhe angkeke, “Iwenhenge-ame arrantherre kwatyeke irrpetyeke apetyeke? Arratye-ame arrantherre akurne imperlte-alhemele akngarte-iwelheke? Arrangkwe, arrantherre-arle urrtyirrentye akngerre areye-arle! Arrantherre apeke-arle apale-arle itirreme Ngkartele-arle arrenhantherrenhe ipeltye-ilemeke tharle arrenhantherrenhe kwatyeke akwernerlenge. Kele arrangkwe-arle! Ngkarte ahele anthurre aneme arrantherre-arle akurne mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Arrantherre ingkirrekele awerrirraye. Arrantherre akurne areye arratye impetyeke akngarte-iwelhemele mwerre mpwaretyeke mwerre anemele. Kele yanhe-ngentyele, Ngkartele aremele arrantherre-arle mwerre mpwaremenge, kele re arrekantherre akangkemele-arle aneme. ");
INSERT INTO aer_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Kenhe arrantherre alakenhe apeke-arle itirreme, ‘Ngkartele anwernenhe akurne areye-arteke aretyakenhe, anwerne-arle arrenge-arrenge Abraham-kenhe areye anerlenge. Alakenhe ikwerenge anteme re anwernenhe atwetyakenhe.’ Kenhe arrangkwe-arle, arrantherre-arle apale-arle itirreme. Kele apwerte nhenhe areye araye. Ngkarte apeke-arle ahentye-aneke re arrenge-arrenge Abraham-kenhe areye apwerte nhenhe areye-ngentyele mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Awerrirraye! Arrantherre akurne anerrirreme, arne merne-kwenye-arteke, angwenhele apeke-arle arne merne-kwenye aremele, ikwere akarelhetyakenhe, arrangkwe-arle, renhe akemele ureke iwetyenhenge. Ngkarte Re artwe-arteke arne areye irntwernetyeke aneme, Re akarelhemele tyerrtye atwetyeke itnenhene ureke iwetyeke akurne akwetethe-arle anerrirrerlenge.” Alakenhe renhe-arle John-ele itneke ileke. ");
INSERT INTO aer_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Kele John tyerrtye itneke alakenhe angkeke, “The arrenhantherrenhe kwatye-werne irrpelhe-ilemele baptise-eme-iletyeke. Kenhe urreke, tyerrtye arrpenhe anyente apetyeme atyengenge awethe arntwarre anthurre. Ayenge akenhe urrkapentye akngerre ikwerenhe-arteke ware-arle. Tharle ingke-kenhe ikwerenhe uyarne-arle ilyweme, ayenge-arle akweke-ulkere. Urreke re arrenhantherrenhe urele uthene Utnenge uthenele-arle baptise-eme-iletyenhe. Re Utnenge Akngerre ikwerenhe arrpenhemeke-arleke akwernetyenhe, arrantherre anteme akngarte-iwelhetyenhenge. Arrpenheme areye Re ure akngerreke-arleke akwernetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Re apetyetyenhe tyerrtye areye akngaketyeke, arelhele-arle ntange areye alkereke iweme-arteke kenhe akenge areye rlkele akngerlenge kenhe mwerre areye ante-arle anerlenge. Alakenhenge re mwerre areye akngakemele itnenhe arntarnte-aretyeke, kele akurne areye akenhe re itnenhe akngakeme imerte itnenhe yernemele aywepemele. Re mwerre areye atnyenetyenhe tyerrtye akurne areye-ngentyele. Re mwerre atnyeneme akayake-ilemele akurne-ketye, akurne areye akenhe re ureke-arle iweme, ure nhenge akwetethe anthurre-arle ampepampemeke.” ");
INSERT INTO aer_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Yanhe-ngentyele anteme Jesus apmere Galilee-ngentyele apetyeke lhere Jordan-werne imerte John apayuthnemele renhe kwatyeke akwernemele baptise-eme-iletyeke. ");
INSERT INTO aer_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Kenhe John lterrke akwete aneke, ikwere angkemele, “Arrangkwe, unte ayenge-tetye kwatyeke akwernemele baptise-eme-ilaye. Iwenhenge-arle-ame the ngenhe kwatyeke akwerneye?” ");
INSERT INTO aer_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesus imerte ikwere angkirtnemele, “Arrangkwe, kele mwerre, unte ayenge kwatyeke akwernaye, Ngkarte-arle ahentye-aneme unte ayenge kwatyeke akwernemele baptise-eme-iletyeke.” Jesus-arle alakenhe angkekenge, John itirreke mwerrantye imerte renhe kwatyeke akwernemele baptise-eme-ilemele. ");
INSERT INTO aer_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus-arle kwatye-ngentyele akeme-irrekenge alkere altywere-irreke re areke Utnenge Ngkarte-kenhe anteme atnarnperlenge thipe urelyarre-arteke imerte ikwere-arleke arrernelhemele. ");
INSERT INTO aer_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Alkere-ngentyele anteme Ngkarte alakenhe angkeke, “Nhenhe-arle ampe impene atyinhe-arle, ayenge-arle ikwere ahentye anthurre-arle ayenge-arle ikwere akangkentye anthurre-arle aneme.” ");
INSERT INTO aer_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Utnenge Akngerre-arle Jesus-eke-arleke arrernelheke-iperre re Jesus apmere ahurratye-werne akngeke, apmere ikwere-werne nhenge tyerrtye-arlke anetyakenhe-werne, arrentye Satan-ele renhe uternetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Re akenhe merne-arlke arlkwetyakenhe arrule aneke arlte 40-eke-atwetye re angayakwe aneke. ");
INSERT INTO aer_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Arrentye Satan anteme apetyeke ikwere alakenhe angkeke, “Unte-ame angayakwe? Unte apeke-arle Alere Ngkarte-kenhe, apwerte nhenhe areye akngarte-iwaye merne irretyeke.” ");
INSERT INTO aer_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Kenhe Jesus akenhe ikwere alakenhe-arle angkirtnerlenge, “Arrangkwe, alakenhe-arle pweke-nge arrule intelhe-ileke, ‘Tyerrtye areye itethe akwete anetyakenhe merne-ante ware arlkwemele, itne itethe akwete aneme angkentye Ngkarte-kenhe awemele.’” ");
INSERT INTO aer_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Arrentye Satan-ele anteme Jesus apmere akngerre Jerusalem-werne akngeke imerte renhe ilemele tyatye akngerre Jew areye-kenhe akertnele tnetyeke. ");
INSERT INTO aer_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Re imerte renhe ileme uternemele-arteke, “Alere Ngkarte-kenhe akwele unte, tyatye akngerre nhenhe akertne-ngentyele ahelheke antewelhaye. Intelhe-ilentye Ngkarte-kenhele alakenhe-arle ileme, ‘Ngkartele alkere-arenye Ikwerenhe areye yernetyenhenge ngenhe arntarnte-aretyeke unte apeke atnyerlenge itne ngenhe akertne-atheke arntwirrketyenhenge apwertele ingke ngenhe atweme-ketye.’” ");
INSERT INTO aer_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Kenhe Jesus akenhe ikwere alakenhe-arle angkerlenge, “Arrangkwe, ayenge-arle antewelhetyeke arrangkwe-arle, alakenhe-arle akenhe pweke-nge arrule aneke, ‘Unte Ngkarte ware apayuthnetyale arrkenelhetyeke, renhe uternetyale ngenhe akayake-iletyeke.’ Alakenhe ikwerenge-ntyele-arle ayenge apmere akertne nhenhenge-ntyele ahelheke antewelhetyakenhe.” ");
INSERT INTO aer_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Awethe Arrentyele renhe apwerte akngerre anthurre-werne akngeke, yanhe-ngentyele anteme re ikwere imerneke ahelhe ingkirreke anthurre, apmere arrpe-anenhe mwerre areye-akerte tyerrtye areye-arlke. Re anteme Jesus-eke angkeke, ");
INSERT INTO aer_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Awaye! Unte apeke atyenge kwene-irreme akangkwe-irremele the ngenhe apmere nhenhe areye ingkirreke-arle antheme.” ");
INSERT INTO aer_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Kenhe Jesus akenhe ikwere alakenhe-arle angkirtnerlenge, “Atyenge-ketyenge alhaye! Ayenge-arle ngkwenge akangkwe-irretyeke arrangkwe-arle, alakenhe-arle Moses-ele arrule intelhe-ilekenge tyerrtye Israel-arenye areyeke, ‘Arrantherre Ngkarteke-ante ware kwene-irremele Renhe utyernemele anthurre tnaketyeke. Ikwere-ante ware awemele akangkwe-irretyeke.’” ");
INSERT INTO aer_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Arrentye re anteme renhe imperle-alheke, alkere-arenye utnenge areye anteme renhe apetyemele arntarnte-aretyeke. ");
INSERT INTO aer_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus-arle apmere ahurratye ikwerenge-ntyele arratemele apetyeke aweke Herod-elarle John jail-ke akwerneke, awemele arteke re apmere Galilee-werne-atheke alheke. ");
INSERT INTO aer_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Apmere Nazareth-eke arteke irremele re ikwerele anetyakenhe anpere akwete alheke apmere Capernaum-werne, yanhe ikwerele aneke. Apmere yanhe kwatye alaye Galilee itwele. Kenhe apmere yanhe re akenhe Galilee arrantherre itelareme arrenge-arrenge Zebulun uthene Naphtali uthene areye-kenhe apmere-arle. ");
INSERT INTO aer_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesus anerle-aneke apmere Galilee-le. Nhenhe alakenhe-irreke Ngkarte-arle arrekwele angkekenge angkentye Ikwerenhe ilerle-apentye akngerre Isaiah-eke, nthakenhe-arle arratye-irretyenhe. Re angkentye renhe intelhe-ileke arrule anthurre alakenhe, ");
INSERT INTO aer_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Arrenge-arrenge areye Zebulun uthene Naphtali uthene-kenhe nhenhe awerrirraye! Iwerre akngerre inteme kwatye alaye Galilee-werne, arrantherre ingkirre anetyeke lhere Jordan altulenge. Jew anetyakenhe areye-arlke ayenge awerrirraye, kele arrantherre-arlke Jew areyenge apmere Galilee-nge anepaneme. ");
INSERT INTO aer_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Arrantherre kwenhe ingwemertele anerlte-aneme arrantherre-arle Ngkarteke akutne anerlte-anekenge, ikwere akangkwe-irretyakenhe, arrantherre anteme ilweketye atere-irrerlte-aneme. Kele urreke alkngenthe akngerre arratetyenhe ingweleme pwarrtyemele uterne-arteke arratetyenhe re tyerrtye areyeke arratemele apmere tyerrtye ilweke-arle areye-kenhele-arle anerlte-anemeke, alkngenthe re anteme akwete pwarrtyerle-anetyenhe ingwemertele-arle aneme areye itne Ngkarte aretyenhe uterne-arteke pwarrtyerlenge.” Alakenhe-arle Isaiah-ele arrule intelhe-ileke, arratye-arle akenhe irrerlenge Jesus-arle apetyemele apmere Galilee-le aneke. ");
INSERT INTO aer_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Yanhenge anteme Jesus untherle-apemele angkentye ilerle-apemele. Alakenhe anteme re ileke, “Akurne-arle mpwareke-iperre utepe-irraye akurne mpwaretyale, angathe irrerlenge Ngkarte-arle tyerrtye areyeke akngerrepate anteme anetyenhe itnenhe lterrke akwete atnyenetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus nhenge kwatye alaye Galilee iterele alhepalhemele areke arrwempenhenge atherre Simon uthene Andrew uthene. Ratherre-arle kere kwatye-arenye areye arntirrkwetyame net-nge, arne nhenge inwerle akngerre-artekenge. ");
INSERT INTO aer_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Re anteme ikwere-atherre angkeke, “Apetye-alherraye, ayenge apenterle-anerraye, the mpwelenhe akaltyele-anthetyenhenge mpwele tyerrtye areyeke angketyeke itne atyenge itweke-irremele anetyenhenge, itne atyinhe apententye akngerre irretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Angkentye anyente-ngare aweke-arle iperre, ratherre arne arntirrkwentye akngerre areye iparrpe imperle-alheke, renhe ratherre apentenheke. ");
INSERT INTO aer_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Arlenge-werne irreke-arle Jesus-ele areke ampe-ikwe Zebedee-kenhe atherre James uthene John uthene anerle-anerrerlenge anyikwele-arlenge. Ratherre-arle anetyame boat kwenele net-ele ayernemele uyarne, arne nhenge areye inwerle-artekele ultakerle-alheke. Jesus-ele renhe-atherrenhe apurte aremele ikwere-atherre antangkeke renhe apentetyeke. ");
INSERT INTO aer_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ratherre akngeye ikwere-atherrenhe Zebedee boat ikwere-atherrenhe impemele renhe apenterle-anerreke. ");
INSERT INTO aer_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus untherle-apemele apmere arrpe-anenhe-ngentyele tantyipe arrpe-anenhele imerte alhemele tyatye Jew areye-kenhe-werne angkentye Ngkarte-kenhe iletyeke tyerrtye areyeke. Re anteme itneke Angkentye Mwerre ileke nhenge Ngkartele-arle tyerrtye areye akngerrepate itnekenhele-arteke arntarnte-aretyeke. Apmere arrpe-anenhele re rlkerte areye apanemele ngangkerele angkwerre-iwemele rlkerte atningke arrpenhe arrpe-anenhe angkwerre-iweke. ");
INSERT INTO aer_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Apmere arrpe-anenhe-ngentyele itne awerrirreke Ngkartele-arle rlkerte areye angkwerre-iwerle-apemele-akerte apmere Syria-ngentyele-arlke. Awemele arteke itne rlkerte atningke akngetyeke angkwerre-iwetyeke, arrwengkelthe atningke-akerte areye. Arrpenhe areyele arrentye-arle atnyeneke, arrpenhe areye akenhe arrewerlenge imerte atnyemele ahelhe-werne-atheke, arrpenhe areye akenhe lterrke-irreke ngkwerne uye imerte alhemele. Jesus-ele anteme ingkirreke itnenhe angkwerre-iweke. ");
INSERT INTO aer_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tyerrtye areyele anteme renhe akwetethe anthurre anteme apentetyarte. Ikwere-akerte awemele, itne apmere arrpe-anenhe-ngentyele apetyewarreke, apmere nhenge areye Galilee itwele, tantyipe 10-pele-ngentyele, arntwarrenge-arlke apmere Judea-nge, Jerusalem-enge, ikngerrenge lhere Jordan-enge-arlke. ");
INSERT INTO aer_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Jesus-ele aremele tyerrtye atningke anthurre ikwere irrperremele angathe-irrerlenge, re alheke apwerteke antyenheke arrernelhetye-alhemele, apententye akngerre ikwerenhe areyele imerte renhe apenteke. ");
INSERT INTO aer_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Re anteme itneke angkeke, alakenhe akaltyele-anthemele, ");
INSERT INTO aer_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Kele mwerre-arle tyerrtye arrpenhe areye itne Ngkartenge arrekwelele tnerlenge itelarelhemele itne iwenhe-arteke apure-irremele. Kenhe tyerrtye nhenhe areye Ngkartele atyewe Ikwerenhe-arle aketyenhe, itnenhe arntarnte-aremele, alakenhenge anteme itne akangkentye anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Mwerre-arle tyerrtye arrpenhe areye atnerte akurne awelheme. Kenhe Ngkartele-arle itnenhe amantye-aketyenhe ntertelhe-ilemele, alakenhenge anteme itne akangkentye anthurre anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Mwerre-arle alakenhe tyerrtye arrpenhe areye-arle ahe-akngerre kwenye. Tyerrtye nhenhe areyeke Ngkartele arne mwerre areye-arle anthetyenhe, alakenhe ikwerenge anteme itne akangkentye anthurre anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Mwerre-arle alakenhe tyerrtye areye ahentye anthurre aneme Ngkarteke akwetethe akangkwe-irremele. Itne akangkentye anerlte-aneme Ngkartele-arle itnenhe atnyenerlenge, itne alakenhe anerrirretyeke. ");
INSERT INTO aer_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Mwerre-arle alakenhe nhenge tyerrtye arrpenheme arrpenhe areyeke alhwarrpe-irreme mwantye-mwantye-ilemele, alakenhenge anteme itne mwerre anetyenhe akangkemele. Itne akangkentye anerlte-aneme Ngkartele-arle itnenhe mwantye-mwantye-ilekenge. ");
INSERT INTO aer_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Mwerre-arle alakenhe tyerrtye arrpenhe areye utnenge itnekenhele akangkwe-irrerlenge Ngkarte akangketyeke mpwaremele. Itne ingkirrekele-arle Ngkarte aretyenhe, alakenhenge anteme itne akangkentye anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Mwerre-arle alakenhe tyerrtye areyele arrpenhe itnenhe arrkngente-iwemele atwerreketyenge, itne ipeltye-ilerretyeke. Ngkartele tyerrtye nhenhe areye Ikwere-artweye aketyenhe, itne ampe Ikwerenhe areye anteme anetyenhenge, alakenhenge anteme itne akangketyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Mwerre-arle alakenhe tyerrtye arrpenheme areye Ngkartenge arratye anerlte-anerlenge kenhe arrpenhe areye itneke tyele angkemenge. Kenhe Ngkartele akenhe Akngerrepate itnekenhe-arle, itnenhe Ikwerenhe areye aketyenhe, itnenhe arntarnte-aremele, alakenhenge anteme itne akangketyenhe. ");
INSERT INTO aer_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","12","Mwerre-arle alakenhe tyerrtye arrpenhe areye arrekantherre apale angkemele arrenhantherrenhe atwerrirrerlenge. Arrekantherre itne-arlke tyele angkerremele arrantherre-arle ayenge apenterlte-anemenge. Tyerrtye areyele arrekantherre arne akurne mpwaretyenhe itne-arle arrule angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyeke akurne mpwareke-arteke. Kenhe Ngkartele akenhe arne mwerre anthurre-arle arrekantherre alkere akertnele atnyenerle-aneme. Alakenhenge anteme arrantherre akangkentye anetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Arrantherre-arle apirnte-arteke-arle tyerrtye areyeke. Nhenge tyerrtyele apirnte arrerneme kere ikwemeye ilemele. Kele alakenhe-arle, nhenge arrantherre Ngkarteke akangkwe-irremele. Itne arrenhantherrenhe aremele alakenhe anerlenge, kele itne ahentye-arle-aneme atyewe Ngkarte-kenhe anetyeke. Kele nhenge apirnte akurne-irremele arrpenhele imerte kereke-arleke arrernemele kere renhe akurne-arle-ileme. Kele re akurne arrkernemele kele impemele anteme. Kele re apirnte renhe ahelheke iwemele tyerrtye areyele anteme ingkele ultherreme. Alakenhe anteye-arle arrantherre mwernte-irremele akngakelheme Ngkarte-ketyenge, arrenhantherrenhe tyerrtye areyele arerlenge, kele itne Ngkartenge apurte-irretyeke ahentye anetyakenhe-arle aneme. Alakenhenge anteme arrantherre atyenge uyarne mwerre urrkapeme. ");
INSERT INTO aer_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Arrantherre alkngenthe-arteke-arle anerlte-aneme tyerrtye areyeke. Itelaraye, nhenge alkngenthe ingwele pwarrtyerlenge iwerre akethe imernemele, tyerrtye areyele iwerre renhe arratye aremele, itne arratye anteme alheme. Kele alakenhe-arle arrantherre iwerre imerneme tyerrtye ahelhe nhenhe-arenye areyeke Ngkarte-werne apetyetyeke. Nhenge tantyipe apwerte akertneke-arle arteke akethe renhe tyerrtye areyele aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Kele alakenhe-arle, nhenge tyerrtyele apmere kweneke-arle lamp alkngenthe-ilemele, urtne akwekele artetyakenhe-arle anemele, kenhe re akenhe akertneke arrernemele-tetye ingkirrekele alkngenthe aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Alakenhenge anteme alengke-iwelhewarretyale. Kele itne anteme arrenhantherrenhe areme arne mwerre mpwarerlenge kele itne Akngeye arrekantherrenhe akertnele-arle anemeke akangkwe-irreme anteye.” ");
INSERT INTO aer_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Arrantherre apeke-arle atyenge apale itirrewarreme alakenhe, ‘Tyerrtye nhenhe apeke-arle apetyeke angkentye Moses-kenhe impetyeke, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyele ileke-arlke.’ Kele arrangkwe-arle, ayenge-arle angkentye yanhe areye iwetyeke apetyetyakenhe-arle, kele ayenge apetyeke angkentye arrulenye arratye irretyeke. ");
INSERT INTO aer_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tharle arrenhantherrenhe arratye-arle ileme, alkere uthene ahelhe nhenhe uthene nterte tnerlenge angkentye ingkirreke itne-arle arrekantherre akwete-arle anetyenhe arrantherre akangkwe-irremele mpwaretyeke, angkentye akngerre uthene angkentye akweke ware uthene. Angkentye itne-arle uyerretyeke arrangkwe-arle, angkentye itne-arle arratye irrekenge ante-arle uyerretyenhe arlte ingkerne nhakwenge. ");
INSERT INTO aer_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Alakenhenge anteme arrantherre angkentye itneke akangkwe-irretyeke. Kele angwenhe apeke angkentye nhenheke akangkwe-irretyakenhe anyente apeke-arle re itirreke angkentye renhe ingkirreke arrpenhenge akweke ulkere, arrpenhe areye akaltyele-anthemele angkentye nhenhe impetyeke, kele Ngkartele areme tyerrtye nhenhe ikwere akangkentye anetyakenhe, re anteme angkeme tyerrtye nhakweke rarle arrpenhekenge anetyakenhe-arle arrpenhe ingkirrekenge akweke ulkere Ngkarte tyerrtye areyeke akngerrepate anteme anerlenge. Kenhe tyerrtye apeke akangkwe-irremele angkentye nhenhe areyeke mpwaremele itne-arle angkemeke tyerrtye arrpenhe areye-arlke akaltyele-anthemele itne arne-ante mpwaretyeke. Nhenge Ngkartele tyerrtye yanhe aremele ikwere akangkeme-arle, re impene anetyenhenge Ngkarte tyerrtye ingkirrekeke akngerrepate anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nhenhe awerrirraye! Arrantherre nhenhe itelarerrirreme, artwe areyele nhenge angkentye Moses-kenhe akaltyele-anthenhe-anthenhe-arlke, Pharisee areye-arlke, itne angkentye Moses-kenheke akangkwe-irremele, aywerrkele mpwaremele, itne Ngkarteke arratye anetyeke. Kenhe Ngkartele arrenhantherrenhe ikwerenhe areye mpwaretyakenhe arrantherre-arle itne-arteke akangkwe-irremenge ware. Nhenge arrantherre utnengele uthene urtakwertele uthene Ngkarteke ahentye-anemele, angkentye ikwerenhe aywerrke akangkwe-irremele, yanhenge anteme Ngkartele arrenhantherrenhe ikwerenhe mpwareme arrenhantherrenhe arntarnte-aretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jesus-ele akwete akaltyele-antherle-anemele itnenhe ileke, “Itelareme nthakenhe-arle Ngkarte angkeke tyerrtye areyeke arrule anthurre, nhenge rarle angkeke arrule arrenge-arrenge arrekantherrenheke alakenhe: ‘Tyerrtye arrpenhe areye atwetyale anetyeke, arrantherre apeke tyerrtye atwemele itne-arle arrenhantherrenhe court-werne-arle akngetyenhenge.’ ");
INSERT INTO aer_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","“Kenhe ayenge arrekantherre angkeme, Unte apeke arrpenheke ahele ware irreme, Ngkartele ngenhe court akngerre-werne akngetyenhe. Kele unte apeke arrpenheke angkeme alakenhe, ‘Unte apele arerte!’ Unte court-werne alhemele. Kele unte apeke arrpenhe renhe ilteme, ikwere alakenhe angkemele, ‘Unte Ngkarteke akutne!’ Kele Ngkartele ngenhe ure akwetethe alkngentheke-arle iweme. ");
INSERT INTO aer_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","Alakenhe irreme-ketyenge anteme arrantherre mwerre anetyeke tyerrtye arrekantherre-artweye areyenge. Iwenhe apeke-arle unte akngetyeke tyatye arriwele tnemele Ngkarteke anthetyeke kele unte itelaremele, ‘Kweye, alakenhe akwele tharle akurne mpwarekenge atyenge-artweyeke, ahele re aneme atyenge.’ Alakenhe itirremele akwele unte arrekwele alhetyeke anyente-irremele ikwerenge ipeltye-irretyeke imerte apetyalpemele tyatye akngerre-werne, arne nhenge Ngkarte anthemele. ");
INSERT INTO aer_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Unte apeke tyerrtye arrpenheke akurne mpwaremele re ahele-irremele ngenhe court-werne-arle akngeme. Kenhe nhenge re ngenhe court-werne akngerlenge unte ikwere mwerrantye angketyeke unte alhepalhemele unte anyente-irremele ikwere ipeltye-irretyenhenge urreke unte court-werne alhetyenhenge. Re anteme apeke imerte ipmentyele impemele court-werne akngetyakenhe. Kenhe unte apeke angketyakenhe anemele unte apeke anyente-irretyakenhe ikwere akangkwe-irretyakenhe anemele, kele re ngenhe akngeme judge anteme aretyeke-arle, kele re ngenhe itelaretyenhenge akurne-arle re anteme ngenhe ileme apwerte ngkweltye anthetyeke, re anteme ngkwenge irrkwentye inemele ngenhe jail-ke akwerneme. ");
INSERT INTO aer_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Unte anteme aneme ikwerele akwete anthurre unte apwerte ngkweltye ingkirre anthetyeke-atwetye. Arratye-arle ayenge angkeme.” ");
INSERT INTO aer_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Jesus re akwete angkeme, “Arrantherre nhenhe-arlke awerrirraye, arrantherre itelareme Ngkartele-arle arrenhantherrenhe arrule ileke alakenhe, ‘Unte anewe arrpenhe-kenhenge intetyale, anewe ngkwinhenge-ante intetyeke.’ ");
INSERT INTO aer_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","“Kenhe ayenge arrekantherre alakenhe anteme angkeme, artwele apeke marle arrpenhe aremele imerte alakenhe ware itirremele, ‘Ayenge arelhe mwerre akngerre yanhenge intetyeke.’ Arrantherre apeke apale itirreme-ketye re marle ikwerenge intemele Ngkartele renhe akurne-arle ileme. Kele re renhe aremele ware ikwerenge intetyeke ahentye-anemele kele Ngkartele renhe akurne-arle ileme. ");
INSERT INTO aer_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Kele unte apeke-arle alknge arratye ngkwinhele areke-arle iperre, unte imerte akurne mpwaremele. Kele, unte alknge renhe tyerremele iwetyeke unte akwete akurne mpwareketyenge. Kele mwerre-arle unte alknge anyente-akerte anetyeke Ngkartele tyerrtye ngkwinhe ureke iweketyenge unte-arle akurne mpwarekenge. ");
INSERT INTO aer_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","“Alakenhe ante apeke unte iltye akwe-arratye ngkwinhele akurne mpwaremele. Kele, unte iltye ngkwinhe akemele iwetyeke unte-arle akurne akwete mpwareme-ketyenge. Kele mwerre-arle iltyeke arrangkwe anetyeke Ngkartele ngenhe ureke iweketyenge unte-arle akurne mpwarekenge.” ");
INSERT INTO aer_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Jesus alakenhe-arlke angkeke, “Itelareme nthakenhe-arle Ngkarte arrule anthurre angkeke, nhenge arrule anthurre re angkeke arrwekelenye arrekantherrenhe areyeke alakenhe, ‘Artwe apeke anewe ikwerenhenge akalke-irreme renhe yernemele, re pipe-ke intelhe-iletyeke renhe imerte anthemele re itelaretyenhenge rarle ikwere ahentye-anetyakenhe aneme.’ ");
INSERT INTO aer_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kenhe the akenhe arrenhantherrenhe alakenhe-arle ileme, ‘Artwele apeke anewe ikwerenhe pipe apeke anthemele renhe yernetyenhenge. Kenhe arelhe nhenge artwe arrpenhenge intetyakenhe. Urreke artwe arrpenhele anteme apeke renhe anewe aketyenhenge. Kele artwe arrekwelele arelhe renhe akurne-ileme, rarle artwe arrpenhenge intemenge. Artwe arrpenhele arelhe renhe ingkerne anewe akemele re-arlke-arle akurne mpwareme.’” ");
INSERT INTO aer_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Jesus-ele itnenhe akwete akaltyele-anthemele, itnenhe ileke, “Arrantherre nhenhe-arlke awerrirraye, Ngkarte-arle angkeke arrwekelenye arrekantherrenheke arrule anthurre, ‘Arrantherre apeke Ngkarte Akngerre alhilemele iwenhe apeke renhe mpwaretyeke, kele arratye mpwaraye.’ ");
INSERT INTO aer_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","37","“Arrantherre apeke alhiletyeke ahentye-anemele arne iwenhe apeke renhe mpwaretyeke, kele ware alhilaye, arritnye arrpenhe-kenhe ilemele alhiletyale. Tyerrtye arrpenheke apeke unte alhiletyeke arne iwenhe apeke renhe mpwaretyeke arritnye arrpenhe-urrke ilemele, arritnye alkere akertne-ngentyele apeke ahelhe nhenhenge apeke Jerusalem-enge apeke, tyerrtye re unte arritnye alakenhe atniwelenge aweme kele re ngenhe arratye aweme-arle. Kenhe the akenhe arrekantherre alakenhe-arle ileme, ‘Unte apeke alhiletyeke arratye ahentye-aneme arritnye arrpenhe-kenhe iletyalaye. Nhenge unte alhilemele arritnye arrpenhe-kenhe ilemele ngenhe-arle arrentyele-arle uterneme arritnye arrpenhe-kenhe ilemele alhiletyeke. Kele-arlke re akertnenye arritnye ilemele alhiletyalaye Ngkarte-arle apmere yanheke akngerrepate anemenge. Alakenhe anteye arritnye ahelhe nhenhe-arenyenge-arlke alhiletyale ahelhe nhenhe Ikwerenhe antime-nge. Jerusalem arritnyenge-arlke alhiletyale, apmere yanhe-arle Ngkarte-kenhe-arlke Rarle apmere ikwere akngerrepate. Unte apeke-arle ahentye-aneme alhiletyeke arritnye arrpe-anenhe iletyale ware alhilaye.’” ");
INSERT INTO aer_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Kele Jesus angkeke, “Nhenhe-arlke awerrirraye! Arrule anthurre Moses-ele alakenhe intelhe-ileke, ‘Ngenhe apeke tyerrtyele alknge atwerlenge, renhe alknge ware atwirtnaye, ngenhe apeke artitye atwerlenge ultakemele renhe artitye ware atwirtnetyeke ultakemele.’ ");
INSERT INTO aer_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kenhe the akenhe arrekantherre alakenhe-arle ileme, ‘Ngkwenge apeke akurne mpwarerlenge unte akenhe ikwere akurne mpwarirtnetyale anetyeke. Ngenhe apeke arrelyennge anyente atwerlenge ikwere arrpenhe anthelhaye. ");
INSERT INTO aer_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Tyerrtye arrpenhele apeke ngenhe court-werne akngerlenge, unte-arle arne iwenhe apeke ikwere renhe arrekwele apayuthnekenge, anthirtnetyenhenge. Artwe court-eke akngerrepatele apeke ngenhe ilemele tyarte ilywetyeke tyerrtye renhe anthetyeke, kele tyarte ante ware renhe anthirtnetyale renhe mantere arrpenhe ngkwinhe-arlke anthaye unte-arle apwerte mane atningkele ineke. ");
INSERT INTO aer_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Thultye-le apeke ngenhe uternemele unte yakwethe ikwerenhe akngernetyeke ikwerenge alherle-apemele. Kele unte akwete akngernerle-apetyeke, kele re anteme ngkwenge angkemele renhe anteme anthirtnetyeke kele unte ikwere alakenhe-arle angketyeke, “Kele mwerre-arle, the intwarre ulkere akngetyenhenge ngkwenge.” Ikwerenge imerte awethe intwarre alhemele yakwethe ikwerenhe akngernemele. ");
INSERT INTO aer_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tyerrtye arrpenhele apeke ngenhe iwenhe apeke renhe apayuthnerlenge, kele renhe ipmentyele awetyale, renhe anthaye iwenheke-arle re ahentye-anemenge. Re apeke-arle arne arrpenhe iwenhe apeke ikwere inkeme, renhe anthaye.’” ");
INSERT INTO aer_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Jesus-ele akwete akaltyele-anthemele itnenhe ileke, “Nhenge angwenhe apeke rarle alakenhe arrule angkeke, ‘Unte atyewe ngkwinhe areyeke ahentye-anetyeke, ngkwenge-arle ahentye-anetyakenhe areyeke ahentye-anetyale.’ ");
INSERT INTO aer_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kenhe the akenhe arrenhantherrenhe angkentye arrpenhe-arle akaltyele-antheme, ‘Arrantherre akangkelhe-iletyeke arrekantherre-arle ahentye-anetyakenhe areye arrenhantherrenhe-arle atweme areye-arlke, Ngkarteke imerte angkemele arrekantherre-arle ahentye-anetyakenhe areyeke re itnenhene mwantyele arntarnte-aretyenhenge.’ ");
INSERT INTO aer_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Arrantherre alakenhe mpwaremele Ngkartele akertne-arenyele aremele itirreme, ‘Arratye apelaye! Tyerrtye nhenhe areye arratye atyinhe, itne-arle ayenge angwaremenge.’ Arrantherre itelareme, Ngkartele uterne-arle akertne-ileme tyerrtye mwerre areyeke-arleke pwarrtyetyeke tyerrtye akurne areyeke-arleke-arlke. Kwatye mwerre-arlke-arle re yerneme tyerrtye mwerre areyeke akurne mpwarentye akngerre areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Arrantherre apeke tyerrtye arrpenheke mwerre mpwaremele rarle arrekantherre mwerre mpwarekenge-ante ware. Kenhe Ngkartele nhenhe aremele re-ame arrekantherre akangkeme? Arrangkwe, arrantherre awethe arnterre ulkere mpwaraye. Kenhe artwe akurne areyele government-eke-arle mane inerlte-aneme areye alakenhe antime-arle mwerre mpwareme, tyerrtye arrpenhele ikwere mwerre mpwarerlenge-ante. Kenhe arrantherre akenhe mwerre anetyeke atherre anteyeke, atyewe arrekantherrenhe areyeke uthene akurne mpwarentye akngerre itneke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ngkartele arrenhantherrenhe areme arrantherre atyewe arrekantherrenhe-werne itneke akangkentyele angkemele apetyerlenge, Re arrekantherre akangketyakenhe anetyenhe, arrantherre-arle awethe arnterre ulkere mpwaretyeke. Kenhe tyerrtye Ngkarteke akutne areye mwerre angkeme atyewe itne-kenheke. Arrantherre kwenhe mwerre angketyeke atherre antimeke atyewe arrekantherrenheke, atyewe anetyakenhe areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yewe, arrantherre kwenhe mwerrantye anthurre anetyeke, arrantherre itelareme Ngkarte-arle mwerrantye aneme-arteke, alakenhe-athewe.” ");
INSERT INTO aer_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Jesus-ele akwete atyewe ikwerenhe areye akaltyele-anthemele itnenhe ileke, “Nhenge arrantherre Ngkarte utyernemele tnaketyeke arrantherre akwetethe-arle arne arrpenheke-arrpenhe mpwareme, apwerte ngkweltyeke arrangkwe areye anthemele, imerte merne arlkwetyakenhe anemele ikwere angketyeke. Kenhe tyerrtye arrpenhe areyele akenhe alakenhe mpwarentye akngerre arrpenhe areyele arerlenge itnenhe akwele tnaketyenhenge. Itne-arteke anetyalaye. Arrantherre apeke alakenhe irremele, kele Ngkarte alkere akertnenye-arenye arrekantherre akangkentye kwenye-arle anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Arrantherre apeke-arle arneke arrangkwe areyeke anthetyeke ahentye-anemele, itnenhene anthetyakenhe arrpenhe areyele arrenhantherrenhe arerlenge. Alakenhe renhe urrtyalthe areyele mpwareme. Itne alethe alhemele iwerrele akunye-apenhe areye aremele, anthemele tyerrtye areyele arerlenge itnenhe tnakewarretyeke. Alakenhe awethe, itne antheme tyatye Jew-kenhe areyeke arrpenhe areyele arerlenge nhenge, itne itnenhe aremele, itne itnenhene tnakemele. Alakenhe the arrekantherre arratye ileme, nhenge Ngkartele aremele itne alakenhe mpwarerlenge, rarle itnenhe tnaketyakenhe, arrpenhe areyele-arle itnenhe kele arerlenge tnakewarreke. ");
INSERT INTO aer_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nhenge arrantherre apeke-arle ahentye-anemele tyerrtye akunye-apenhe areye anthetyeke, alengke-iwelhe anteme itnenhe anthaye arrpenhe areyele aretyakenhenge. ");
INSERT INTO aer_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Yewe, arrantherre anthemele alengke-iwemele anthetyeke arrpenhe areyele itelaretyakenhenge. Akngeye-ante arrekantherre-akerte akaltye anemele arrantherre-arle alengke-iwemele antherlte-anemenge arrenhantherrenhe-arle re arekenge anteme re arrekantherre arne mwerre antheme.” ");
INSERT INTO aer_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Jesus angkeke, “Arrekantherre-arrpe arelhewarraye, Ngkarteke angketyale nhenge ularele arrpenhe areyele-arteke. Itne nhenge Ngkarteke angkeme akangkemele tnemele tyatye kwenele, akethele-arlke, tyerrtye arrpenhe areyele akwele aretyenhenge. Kele ingkirrekele itelaraye: Ngkartele itnenhe tnaketyeke arrangkwe-arle, arrpenhe areyele-arle itnenhe kele tnakewarrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Nhenge unte Ngkarteke angkemele apmere ngkwinhe arriwe martemele anyente-ante ikwere angketyeke. Kele Ngkarte-ante-arle akaltye aneme unte-arrpe-arle angkeke, re anteme, ngenhe areke-arle-iperrenge, ngenhe arne mwerre anthurre anthetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Unte apeke Ngkarteke angkemele, angkentye akwete-akwete angketyale. Alakenhe renhe tyerrtye areye Ngkarteke akutne angkeme. Itne apale itirremele itne-arle akwete-akwete angkentye angkepangkeme, re itnenhe awerlenge. ");
INSERT INTO aer_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Itnenhe angwaretyale arrantherre Ngkarteke angkemele, kele Ngkarte anwerne-kenhe-arle akaltye-arle iwenheke-arle arrantherre ahentye-anemeke urreke-arle arrantherre apayuthnetyenhenge-ante. ");
INSERT INTO aer_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kele nhenge arrantherre Ngkarteke angkemele, alakenhe angketyeke, ‘Ngkarte Akngeyaye, alkerele-arle aneme. Impene anthurre kwenhe arritnye ngkwinhe aneye. Altyerre Ngkwinhe apetyaye. ");
INSERT INTO aer_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Alakenhe anetyenhe ahelhe nhenhele apmere Ngkwinhe-arteke. ");
INSERT INTO aer_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Arlte nhenhenge merne anwernenhe anthaye. ");
INSERT INTO aer_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Anwerne akurne mpwareke-arle iperre, anwernenhe ilpernetyakenhe anaye. Alakenhe-arteke, nhenge arrpenhe areyele anwernenhe akurne mpwaremele, anwerne itnenhe ilpernetyakenhe anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Anwernenhe akurne-werne-atheke akngetyalaye. Anwernenhe akngarte-iwaye akurne-ketye.’” ");
INSERT INTO aer_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesus alakenhe-arlke itneke angkeke, “Angwenhele apeke arrekantherre akurne mpwareme, arrantherre anteme itnenhe ilpernetyakenhe anetyeke. Kele Akngeye alkere akertne-arenyele arrenhantherrenhe ilpernetyakenhe aneme nhenge arrantherre akurne mpwarerlenge. ");
INSERT INTO aer_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kenhe arrantherre apeke tyerrtye arrpenhe areye ilpernemele aneme itnekenge ipeltye-irretyakenhe anemele itne arrekantherre akurne mpwarerlenge, kele Akngeye arrekantherrenhe alkere akertne-arenyele arrenhantherrenhe ilperneme ipeltye-irretyakenhe anemele nhenge arrantherre akurne mpwarerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Jesus angkeke, “Arrantherre apeke-arle merne arlkwetyakenhe Ngkarteke angkerlte-anetyenhenge. Kenhe arrantherre apeke alakenhe mpwaremele artwe arrpenhe areye angwareketyenge urrtyirremele-arle mwerre akwele anerlte-aneme. Tyerrtye yanhe arrpenhe areyele aretyenhenge ahentye-anemele merneke arrangkwe anemele, itnenhe akwele tnaketyenhenge. Nhenge itne-arle arlpmenye inngerreke arrernelhemele untherlte-apemele alhwarrpe akwele arrpenhe areyele itnenhe aremele alakenhe akwele itirretyenhenge, ‘Yewe, arratye apelaye, tyerrtye mwerre nhenhe areye-arle arlkwetyakenhe-arle Ngkarteke angkerrirretyenhenge.’ Kenhe the akenhe arrenhantherrenhe arratye-arle ileme, Ngkartele itnenhe aremele rarle itnenhe tnaketyakenhele, tyerrtye areyele-arle itnenhe tnakemele arekenge. ");
INSERT INTO aer_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Unte apeke-arle merne arlkwetyakenhe Ngkarteke angketyenhenge, alte ngkwinhe comb-eme-ilelhemele inngerre ngkwinhe kwatyele alhewelhaye. ");
INSERT INTO aer_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Kele arrpenhe areyele ngenhe aremele itne itelaretyakenhe unte-arle merne arlkwetyakenhe. Kele Akngeyele-ante-arle ngenhe areke nthakenhe-arle-irreke. Areke-arle iperrenge Re ngenhe arne mwerre areye anthirtnetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Jesus angkeke, “Arne arrpe-anenhe-arlke, apwerte ngkweltye-arlke inetyale alengke-iwetyeke arrantherre apmere ahelhe nhenhele anepanemele, itne-arle akurne-irretyenhenge. Apmere ahelhe nhenhele interrke areyele-arle arne ingkirreke arlkweme. Anyelkngalthe areyele-arlke anteme apmere arrekantherrenheke irrperlenge anyelkngele inetyenhe arne yanhe areye. ");
INSERT INTO aer_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kele ahelhe nhenhele anerlte-anemele arrantherre Ngkarteke akwete urrkapewarretyeke re anteme arrekantherre arne mwerre akngerre areye renhe-arle akngakemele arrerneme arrekantherre alkerenge. Alkerele akenhe arne itne mwerre akwete-arle aneme, apmere yanhenge-arle arne angkweye-irretyeke arrangkwe-arle interrkeke-arlke arrangkwe-arle, anyelkngalthe areyeke arrangkwe. ");
INSERT INTO aer_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Unte apeke-arle ahentye-aneme arne alkere-arenye utnengeke unte-arle arne ahelhe-arenye areyeke ahentye-anemele unte-arle arne itneke akwete-arle itirrekele anteme. Unte apeke arnterre ahentye-aneme arne alkere-arenye utnenge itneke unte alkngwirretyeke arne ahelhe-arenye areyeke alkere-arenye utnengeke anteme itirremele imerte Ngkarteke-ante akangkwe-irremele.” ");
INSERT INTO aer_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Jesus angkeke, “Alknge ngkwinhe-arle alkngenthe-arteke tyerrtye ngkwinheke. Alknge mwerre apeke unte mwerre aretyeke, unthemele mwerre. Kenhe alknge ngkwinhe akurne apeke, ingwemertele aneme-arteke, aretyeke arrangkwe-arle, unte itelaretyakenhe-arle irreme. Alakenhe-arle, unte apeke akwetethe mwantye-mwantyele arrpenhe areye antherle-anemele kele utnenge alkngenthe-akerte anetyenhenge. Kenhe unte apeke arne areye atnure-irremele atnyenemele, kele utnenge apele ingwemerte-arle anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Jesus angkeke, “Tyerrtye-arle akngerrepate atherreke urrkapetyeke arrangkwe-arle. Re apeke-arle arrpenheke impenele awelhemele, arrpenhe irlpe artepele aweme. Re arrpenhe yanheke apeke-arle ahentye-arle-aneme arrpenheke akenhe re ahentye anetyakenhe apeke-arle. Alakenhe-arteke, unte apeke apwerte ngkweltyeke ahentye-anemele kele unte Ngkarteke ahentye-anetyakenhe-arle, Unte Ngkarte uthene mane uthene anyentelhe-iletyeke arrangkwe-arle imerte itirremele anteme. Unte Ngkarte anyenteke-ante akangkwe-irretyeke-tetye, mane ngkweltyeke itirretyale.” ");
INSERT INTO aer_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Jesus anteme angkeke, “Arlte arrpenheme arrantherre apeke arnterre itirremele alakenhe, ‘Nthenhenge-ame anwerne merne inetyenhe anwerne anhelke anetyenhenge, kwatye antywetyeke anteye? Nthenheke-ame mantere ineme anwerne untyetye anetyeke?’ Kenhe the akenhe arrekantherre ileme, Ngkartele kwenhe anwernenhe mpwareke mwerre anetyeke. Re anwerneke alkngwirretyakenhe anwernenhe ipmentye-iwetyakenhe, anwernenhe arntarnte-arerle-anetyenhe. Kenhe nhenhe ikwerenge-ntyele anwerne merneke-arlke mantereke-arlke itirrewarretyale. ");
INSERT INTO aer_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","“Thipe areye aremele itirrewarraye, itne ntange areye-arlke ahelheke ngkernewarretyakenhe merne lyapelhe-iletyeke, arrangkwe-arle. Nhenge ntange mpenge-irrerlenge, itne-arle kutyewarretyakenhe-arle apurtelhe-ilemele apmere itnekenhe-werne akngirtnewarretyeke arlte arrpenhele arlkwerrirretyeke, arrangkwe-arle. Kenhe itne Ngkarte merneke apayuthnetyeke arrangkwe-arle, re itnenhene arntarnte-arerle-anerlenge. Kenhe Ngkarte arrekantherre ahentye anthurre aneme thipe areyenge arntwarre ulkere. Yanhe ikwerenge-ntyele merneke akwenpe anerrirraye itirrewarretyale. ");
INSERT INTO aer_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Iwenheke-ame arrantherre merneke itirrewarreme? Arrantherre merneke itirrewarremele, arrenhantherrenhe itethe-iletyakenhe, arrangkwe-arle.” ");
INSERT INTO aer_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Jesus alakenhe akwete angkeke, “Kele iwenhenge-arle akenhe arrantherre mantereke itirrewarreme? Antethe itnenhene araye, itneke itirreke nthakenhe-arle itne lyaperlenge, mwerre anthurre-arle itne aneme, kele itne-arle urrkapetyakenhe-arle mantere itnekenhe mpwaretyeke irrpetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Kenhe arrantherre itelarerrirreme artwe akngerrepate Solomon arritnye aneke, arrule anthurre akngerrepate anetyarte, rarle mantere mwerre akngerre areyeke-arlke irrpetyarte. Kenhe antethe nhenhe areye ikwerenge mwerre akngerre ulkere. ");
INSERT INTO aer_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Atherrke antethe-akerte-arle itne akenhe akwete anthurre arruleke-atwetye anerrirretyeke arrangkwe-arle, akweke ware, lyeteke-atwetye ware itne anerrirreme. Kele antyerrke-irremele, urele anteme ampeme uyerretyeke-ante. Kele-arle itne akweke ware aneke, Ngkartele akenhe atherrke renhe mwerre akngerre akwete-arle mpwareme. Alakenhe-arle re atherrkeke mpwareme, kele re mantere antheme-arle arrantherre ahentye-anemenge, arlte lyetenyenge. Kenhe arrantherre akenhe itirreme rarle uyarne mpwaremeke-athene. ");
INSERT INTO aer_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Kele yanhenge itirretyale alakenhe ware angkaye, ‘Ayenge akunye-apenhe, kwatye uthene merne utheneke arrangkwenge, ayenge-ame nthakenhe-irretyenhe? Nthenhenge-arle-ame the inetyenhe?’ Alakenhe-arlke itirretyale angkemele, ‘Ayenge akunye-apenhe, mantere atyinhe-arle alterrelhekenge. Nthakenhe-arle-ame ayenge irretyenhe? Nthenhenge-ame the mantere inetyenhe irrpetyeke?’ ");
INSERT INTO aer_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ayenge alakenhe angkeme, alakenhe rarle Ngkarteke akutne areye-arle itirrerlte-anemenge. Kenhe Ngkartele-arle ingkirrenyeke anthurre itelareme iwenheke-arle arrantherre ahentye-anemeke re anteme arrenhantherrenhe anthemele-arle. ");
INSERT INTO aer_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Kele arrantherre akenhe arne atningkeke itirrewarretyale anetyeke, ware, kele anerlte-anaye. Kele ikwere-ante akwete itirrerlte-anemele anaye Rarle arrenhantherrenhe akwetethenhe-arle arntarnte-arerlenge. Ikwere aywerrkele akangkwe-irremele iwenhe apeke renhe-arle re arrekantherre angkeme iparrpele mpwarewarre, re anteme arrenhantherrenhe merne anthemele mantere-arlke, arne atningke arrpenhe areyeke-arlke arrantherre ahentye-anerlenge, arlte lyetenyenge. ");
INSERT INTO aer_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Arne areye ingwentheke inetyeke itirrewarretyale. Kele itneke alakenhe itirrewarretyale, ‘Nthenhe-ngentyele-arle-ame anwerne arne inetyenhe?’ Arrantherre itelareme yanhenge anteme-arle Ngkartele arrekantherre anthetyenhe, arrantherre anteme arnterre itirrewarremele anetyale arlte arrpenheke, arrantherre itirrewarraye lyeteke-arle arrantherre ahentye-anemeke-ante.” ");
INSERT INTO aer_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jesus-ele apententye akngerre ikwerenhe areye akaltyele-anthetyame alakenhe, “Kenhe arrantherre apeke arrpenhe areye ilperneme, Ngkartele anteme arrenhantherrenhe ilperneme. ");
INSERT INTO aer_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Nhenge arrantherre apeke arrpenhe areyeke angkemele itnenhe akurne akeme, Ngkarte alakenhe-arle angkeme arrenhantherrenhe akurne akeme. Kenhe arrantherre akenhe tyerrtye arrpenhe areyeke angkemele itneke akangketyeke mpwaremele itnenhe ilpernetyakenhele kele arrenhantherrenhe Ngkartele-arle alakenhe akangketyeke mpwareme ilpernetyakenhele. ");
INSERT INTO aer_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","5","“Iwenhenge-arle-ame arrantherre akurne-irreme arrpenhe areyeke apale angkemele itnenhe arratye-iletyeke akwele? Arrantherre itirrewarraye arrekantherre-urrke, urreke arrantherre arrpenhe areyeke akenge itirretyenhenge. The arrekantherre arratye ileke arrantherre itelarerrirretyeke arrantherre akurne mpwarerlenge kele Ngkarte-kenhe arrpenheke anteme angkemele arrantherre apeke renhe aremele akurne-irrerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Jesus-ele itnenhe akwete akaltyele-anthetyame, “Angkentye Mwerre Ngkarte-kenhe kwenhe atyeperre anthurre. Kele arlte arrpenheme arrantherre angkentye nhenheke angkemele kele tyerrtye arrpenhe areye akenhe akangkwe-irretyakenhe-arle. Kele itne apeke ipmentye-iweme iwenhe renhe itneke arrantherre-arle ilerlenge, itneke awethe iletyalaye. Nhenge tyerrtye itne akenhe akngwelye ahe akngerre-arteke, pike-pike-arteke-arlke. Arrantherre apeke akwete angkentye Ngkarte-kenhe itneke mwerre ilerlte-apemele itne-arle irlpe martelhentye-arle akangkwe-irretyakenhe, itne anteme arrekantherre ahele angkerremele, akngwelye nhenge ahe akngerrele tyerrtye uthneme, alakenhe athewe. Itne anteme akurne-ileme angkentye arrantherre-arle angkeme, tyerrtyele nhenge pike-pike merne anthemele imerte itne ahelhe urrkngeke akwernemele imerte ulthemele, alakenhe akwele itne angkentye renhe akurne-ilentye akngerre. Arrantherre akenhe Angkentye Mwerre Ngkarte-kenhe akwete itneke ilerle-apetyale anetyeke-arle, kele impetyeke ante, angkentye yanhe-arle atyeperre anthurrenge.” ");
INSERT INTO aer_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Kele Jesus-ele itnenhe akaltyele-antheke alakenhe Ngkarteke angketyeke, “Kele, angwenhele apeke arne iwenhe-iwenheke renhe Ngkarteke akwete anthurre apayuthnerle-aneme re renhe ineme-arle. Kenhe angwenhe apeke arne iwenhe ikwere apale unthemele kele re renhe aretye-alheme-arle. Kenhe angwenhele apeke re arriwe renhe ltare-atwetye-alhemele, Ngkartele renhe altywere-ileme re Ikwere-werne alhetyeke renhe aretye-alhetyeke. Alakenhe ikwerenge anteme arrantherre Ngkarte renhe arne iwenhe-iwenhe apeke ikwere apayuthnerrirretyeke, kele Re arrenhantherrenhe anthetyenhe-arle. Kenhe arrantherre apeke Ikwere akwete-arle untherlte-anemele, Re kele arrekantherre imernelheme. Kenhe arrantherre apeke arriwe renhe akwete-arle ltare-atwerlte-aneme, kenhe Re kele arriwe renhe arrekantherre altywere-ileme-arle arrantherre-arle irrperrirretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kenhe arrantherre nthakenhe-arle irretyenhe nhenge alere arrekantherrenhele apeke merneke apayuthnerlenge? Arrantherre-ame renhe apwerte anthetyenhe? Arrangkwe! ");
INSERT INTO aer_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Nhenge re arrenhantherrenhe irrpenngeke apayuthnerlenge, renhe akenhe apmwe anthetyakenhe. Arrantherre renhe irrpennge-arle anthetyenhe arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Kele arrantherre ampe arrekantherrenhe areye arne mwerre antherlte-aneme itne arrenhantherrenhe apayuthnerlenge, kele arrantherre-arle akurne akwete mpwarerlte-anemenge. Kele Akngeye arrekantherrenhe alkere akertnele-arle anemeke, arrantherre itirrewarremele iwenhe-arteke-arle Re aneke? Rarle nhenge mwerre anthurre aneme, arrekantherrenge mwerre akngerre ulkere. Re akenhe arne mwerre akngerre aywerrkele anthentye akngerre-arle arrantherre apayuthnerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Jesus angkeke, “Arrantherre ahentye-aneme tyerrtye arrpenhe areyele mwerre aywerrkele mpwaretyeke arrekantherre. Kele arrantherre-arlke akenhe akwete mwerre aywerrkele mpwaretyeke tyerrtye arrpenhe areyeke alakenhe-arle Moses uthene artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areye uthenele-arle intelhe-ileke arrule anthurre, anwerne alakenhe mpwaretyeke.” ");
INSERT INTO aer_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Jesus angkeke, “Ingkirrekele awerrirraye! Iwerre atherre kwenhe aneme tyerrtye areyele apentetyeke. Iwerre anyente arriwe anteke-akerte-arle aneme, iwerre arrpenhe akenhe urlpme anthurre-arle, arriwe urlpme-akerte. Kenhe iwerre anteke re akenhe impeltye anthurre-arle mwerre anthurre, iwerre ikwerenge akenhe tyerrtye atningke anthurre-arle irrpenheme arriwe antekenge. Kele iwerre re akenhe apmere akurne-werne-arle tyerrtye areye Ngkarte-ketyenge akngakemele irrare anerlte-anetyenhe. Kele iwerre urlpme re akenhe impeltye anetyakenhe-arle lterrke anthurre apentetyeke, tyerrtye urrpetye ware-arle akenhe arriwe urlpme ikwere irrpenheme iwerre renhe apentemele. Kele iwerre re akenhe alheme apmere mwerre akngerre ikwere-werne Ngkartenge-arle anyente-irreme-werne, akwetethe-arle akangkentye anerlte-aneme-werne. Kele, arrantherre iwerre urlpme ikwere irrpenhemele akwete urlpme renhe apentetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Jesus-ele atyewe ikwerenhe areye alkngarre-ileke alakenhe, “Ameke-arelhewarraye akwetethe yanhe areye-ketye urrtyirremele ilemenge itnarle angkentye Ngkarte-kenhe ilerlte-apeme akwele. Itne akngwelye artnwere-arteke yepe-yepe yenpeke irrpemenge yepe-yepe akwele anteme, itne-arle alengke-iwelheke iperre, apetyewarremele anteme yepe-yepe itnenhe uthnemele arlkwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Kele arrantherre itnenhe alhengke-arle-areme itne-arle mpwaremenge, arrantherre arerrirremele itne akurne atningke mpwarerlenge kele arrantherre itelareme-arle urrtyirrentye akngerre nhenhe areye. Merne ntange areye-akerte itelaraye, merne kripethe areye-arle arne lyeke-lyekenge lyapetyakenhe-arle, nhenge merne utyerrke arne ilpeyenge lyapetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","18","Arrantherre itelareme arne mwerrenge-ante kwenhe merne ntange lyapeme mpenge-irremele ikwemeye-irremele, kenhe arne akurnenge akenhe merne akurne-arle aneme. Nhenge alakenhe-arlke arne mwerrenge merne akurne-arle lyapetyakenhe aneme, alakenhe anteye arne akurnenge merne mwerre lyapetyeke arrangkwe-arle. Awemele anteme akaltye-irraye angkentye nhenhe areyeke, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyele mwerre-ante-arle mpwareme, kenhe angkentye Ngkarte-kenhe akngarte-iwentye akngerre areyele akenhe akurne-ante-arle mpwarerlenge. ");
INSERT INTO aer_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Arrantherre itelareme artwe garden-eke-artweye, re areme arnele merne ntange akurne akwete atnyenerlenge, re ultakemele-arle ureke iweme. ");
INSERT INTO aer_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Alakenhe-arteke, arrantherre arerrirremele angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyele akurne mpwarerlte-aneme kele arrantherre itelarerrirreme itne-arle urrtyirreme-arle angkentye Ngkarte-kenhe ileme.” ");
INSERT INTO aer_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jesus awethe angkeke, “Arrantherre itelareme arrpenhemele ayenge-arle akngerrepate ilemenge. Arrpenhe areye akenhe urrtyirremele ileme ayenge-arle akwele akngerrepate itnekenhe. Kenhe itne akenhe akangkwe-irretyakenhe awetyakenhe-arlke mpwaretyakenhe Ngkartele-arle itnenhe ilekeke. Alakenhenge anteme Ngkartele itnenhe atyewe aketyakenhe itnenhene arntarnte-aretye-arlke-akenhe akngerrepatele-arteke. ");
INSERT INTO aer_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","The arrekantherre ileme arlte ingkernenge tyerrtye areye tnetyenhe Ngkartenge arrekwele-arle atningkele ayenge-arle akngerrepate ileme areye akenhe alakenhe-arle angketyenhe, ‘Akngerrepate! Arritnye ngkwinhe angkeke-arle iperre anwerne angkentye ngkwinhe tyerrtye areyeke ilemele, anwerne-arle arrentye areye aywepeke tyerrtye areye-ngentyele arritnye ngkwinhe ilemele, awethe ante, arritnye ngkwinhe ilemele, anwerne arne ilyernpenye atningke ngangkerele mpwareke.’ ");
INSERT INTO aer_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Kenhe ayenge akenhe itneke alakenhe-arle angkirtnetyenhe-arle, ‘Arrangkwe, the arrenhantherrenhe itelaretyakenhe-arle. Arrantherre akwetethe-arle akurne mpwaretyarte Ngkarteke. Atyenge-ketyenge alhaye!’” ");
INSERT INTO aer_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesus angkeke, “Awerrirraye! Tyerrtye angwenhele ayenge-arle awemeke nthakenhe-arle angkeke-arle iperre, renhe anteme aywerrkele mpwaremele, artwe-artekele-arle ilthe ikwerenhe apwerte athirnteke-arleke arteke. Nhenge artwe nhenhe itelarentyele-arle apwerte athirnte angwareke apmere arteke re apwerteke-arleke mwantyele arteke, rarle lterrke anekenge. ");
INSERT INTO aer_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Ikwerenge-ntyele kwatye akngerre apetyeke imerte anhemele, lherenge-arlke kwatye urewe akngerre anteke-irreke kele apmere re akenhe atnyetyakenhe akwete-arle anerlenge. Rlke akngerrele-arlke werneke apmere renhe ankerte-iwemele, kele atakelhetyakenhe akwete-arle anerlenge, artwe rarle apwerte athirnteke artekenge apmere ikwerenhe, mwerre akwete tneke akngelhetyakenhe-arlke. Alakenhe arrantherre apeke angkentye atyinhe awerrirreke-arle iperre, renhe anteme aywerrkele mpwaremele, kele arrantherre atnyetyakenhe, kele lterrke-arle aneme arrekantherre apeke akurne-irrelenge. ");
INSERT INTO aer_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kele tyerrtye angwenhele apeke aweke-arle iperre nthakenhe-arle ayenge angkeke imerte ipmentye-iwemele-arle rarle artwe arrpenhe apmere artentye akngerre-arteke-arle. Artwe nhenhele akenhe arerte apeke lhere itereke-arle apmere ikwerenhe arteke ahelhe urrkngele-arle. ");
INSERT INTO aer_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Ikwerenge-ntyele kwatye akngerrele anheke, lherele kwatye urewe akngerre anteme irreke anteke-irremele. Kwatye ikwerenge akenhe rlke akngerrele-arlke werneke apmere renhe ankerte-iwemele, iparrpe anthurre apmere re atakelheke imerte atnyemele uyerretyeke-ante.” ");
INSERT INTO aer_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus-arle angkentye nhenhe areyeke angkeke iperre tyerrtye renhe-arle aweke itne arnterre anthurre apatewarreke, rarle nhenge ilernpenye anthurrele angkerlenge. ");
INSERT INTO aer_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Alakenhe-arle nhenge Jesus-elarle tyerrtye areye akaltyele-anthetyarte, re itneke angkentye ileke Ngkartele-arle renhe anthekenge. Kenhe angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyele tyerrtye itnenhe akaltyele-anthetyarte, itne itneke angkentye itnekenhe-arrpe iletyarte, angkentye itnekenge-arrpe ware. ");
INSERT INTO aer_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus apwerte akertne-ngentyele atnarnpemele iperre tyerrtye atningke anthurrele renhe apentewarreke. ");
INSERT INTO aer_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kenhe artwe anyente utyene irrkelhe-irrkelhe ilentye akngerre-akerte apetyeke nhenge Jesus aremele re amperele-arlenge tnemele renhe apayuthneke, “Jesus-aye, ayenge utyene nhenhe angkwerre-iwaye. The itelareme unte-arle ayenge angkwerre-iwemere, unte-arrpe apeke awelhemele.” ");
INSERT INTO aer_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Kele Jesus-ele iltye ikwerenhele renhe anpeke, ikwere angkirtnemele, “The ngenhe angkwerre-iwetyeke ahentye-aneme.” Kenhe iparrpe anthurrele utyene akngerre uyerrerlenge, yenpe alyere-alyere-irremele. ");
INSERT INTO aer_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Kele anteme Jesus ikwere angkeke, “Arrpenhe areyeke ilelhetyale tharle ngenhe angkwerre-iweke. Angkentye Moses-kenhe alakenhe angkeme: Kenhe arrekwele kwertengerle tyatye-arenyeke imernelhetyeke alhaye ngenhe-arle angkwerre-iwekeke. Kele re ngenhe areke-arle-iperre ilemele yenpe ngkwinhe ulkere anteme, kele thipe akweke atherre inaye ampetyeke Ngkarteke yanhe atherre tyawerrelyele anthetyenhenge. Kele mwerrantye mpwareke-ngentyele itne itelarerrirretyenhenge unte-arle mwerre-irrekenge.” ");
INSERT INTO aer_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Nhenge Jesus-arle apmere nhenge Capernaum-werne alherlenge thultye akngerrepate ikwere-werne apetyeke. Artwe nhenhe apmere Rome-arenye thultye Rome-arenye 100-eke alartetye-arle apmere Capernaum-ele. Re anteme Jesus-eke angkeke, alakenhe renhe apayuthnemele, ");
INSERT INTO aer_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Akngerrepate anwerne-kenhe, urrkapentye akngerre atyinhe rlkerte apmerele interle-aneme, akngelhetyakenhe-arlke arekare awelhemele.” ");
INSERT INTO aer_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Awemele Jesus ikwere alakenhe angkeke, “Kele mwerre-arle! Ayenge iparrpe alheme renhe angkwerre-iwemele mwerre iletyeke.” ");
INSERT INTO aer_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Kenhe akngerrepate thultye-kenhe re akenhe angkerlenge, “Arrangkwe akngerrepate, unte kwenhe akngerre aneme, kele ayenge akenhe artwe akurne akweke ware-arle ayenge apure-arle-irreme unte apmere atyinhe-werne apetyetyeke. Unte nhenhenge ware angkeye arrwengkelthe re nhenhenge-ntyele ware mwerre-iletyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","The itelareme unte-arle Ngkarteke mpwarepareme. Kenhe Re ngenhe ileme mpwaretyeke, nge Renhe awemele, kele nge mpwareme-arle. Alakenhe rarle ayenge warrke-irreme Rome-arenye areyeke akngerrepate. Kenhe ayenge akngerrepate aneme thultye arunthe anthurre-akerte. Ayenge anyenteke angkemele yanhe-werne alhetyeke, kenhe re iparrpe anthurre alherlenge. Kenhe ayenge apeke anyenteke angkemele, “Nhenhe-werne apetyaye!” Kele re iparrpe anthurre apetyeme. Kenhe ayenge anyenteke angkemele mpwaretyeke, kenhe re iparrpe anthurrele mpwarerlenge. Kele unte-arteke rarle. Kele unte-arle angkemele arteke kenhe iparrpe anthurre urrkapentye akngerre atyinhe re mwerre-irrerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nhenge Jesus-ele nhenhe awemele re apatemele anthurre. Re imerte tyerrtye areyeke angkemele renhe-arle apentewarremeke, “The arrenhantherrenhe arratye ileme, artwe nhenhe thultye atningkeke akngerrepate-arle anemeke re Jew anetyakenhe-arle, re akenhe arratye itirreme tharle mpwaretyeke, Jew areye-arteke kwenye. Apmere nhenhe Israel-enge the arrpenhe aretyakenhe artwe nhenhe-arteke-arle arratye itirremeke tharle iwenhe apeke renhe mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","The arrekantherre arratye ileme, tyerrtye apmere arrpe-anenhe-ngentyele Jew anetyakenhe areye apetyetyenhe. Itne-arle apetyetyenhe Abraham-eke anyente-irretyeke, Isaac-eke, Jacob-eke-arlke akangkemele merne apurtele arrpenhe areyenge arlkwetyenhe Ngkarte akngerrepate anerlenge itnenhe arntarnte-aretyenhele. ");
INSERT INTO aer_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Kele Jew arrpenhe areye itnekenge apurte anetyeke arrangkwe-arle. Ngkartele-arle itnenhe arrule akngakeke Ikwerenhe areye anetyeke. Itne-arle akenhe Ikwerenhe areye anetyeke ahentye-anetyakenhe-arle anekenge Re akenhe itnenhe uliletyenhe, kenhe itne ingkirreke arrangkemele artitye lterrkemele utyene-ante-irretyeke alkngultyeke-ante artnemele anerle-atherre-anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jesus anteme thultye akngerrepateke angkeke, “Kele, apmere-werne alpaye! The urrkapentye akngerre ngkwinhe mwerre-ileke unte-arle itirreke the mpwaretyeke.” Ikwerenge anteme urrkapentye akngerre re iparrpe anthurre mwerre-irreke. ");
INSERT INTO aer_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesus apmere yanhe ikwerenge-ntyele imperle-alhemele apmere Peter-kenhe-werne alheke nthenhele-arle mwerikwe Simon-kenhe rlkerte anthurre apmere kwenele intekenge, amperlenge anthurre re awelheke. ");
INSERT INTO aer_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesus-ele iltye ikwerenhe apaneke, iparrpe anthurre rlkerte imperle-alhemele arratintyeke, arelhe re akenhe mwerre-arle-irrerlenge. Re akeme-irremele merne-arlke itetyeke. Re anteme Jesus-arlke anthemele arrpenhe areye-arlke. ");
INSERT INTO aer_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kele-arle alernnge irrpeke-arle arrpenhe areyele apmere yanhe ikwere areye-ngentyele arrentye areye-akerte Ngkarte-werne akngetyewarreke re itnenhe mwerre-iletyeke. Rarle angkentyele ware arrentye itneke-ngentyele arratelhe-ilemele aywepeke, itne mwerre-irreke. Jesus-ele rlkerte areye ingkirreke angkwerre-iweke. ");
INSERT INTO aer_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nhenge Jesus-ele tyerrtye areye alakenhe angkwerre-iweke, alhilentye Ngkarte-kenhe arratye-irretyeke, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Isaiah-ele intelhe-ilekenge-arteke arrule anthurre pwekeke-arleke alakenhe, “Re arrengkwelthe anwerne-kenhe areye uyerrelhe-ileke anwernenhe mwerre-ilemele.” ");
INSERT INTO aer_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesus-ele areke tyerrtye atningke anthurre ikwere-werne apetyewarremele tnerrirrerlenge re angkeke apententye akngerre ikwerenhe areyeke, “Mpe, boat-eke antyemele alhetyekeye ahelhe irntwarre-werne kwatye alayele arrengakwe-werne!” ");
INSERT INTO aer_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Nhenge re angkeke alhetyeke, artwe angkentye Moses-kenhe-arle akaltyele-anthetyarte apetyeke Jesus-eke angkemele, “The ngenhe apenterle-apetyeke nthenhe-werne apeke unte alherlenge.” ");
INSERT INTO aer_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Kele Jesus akenhe ikwere angkerlenge, “Kere rapite itne alhwengele anerrirreme, kenhe thipe areye akenhe arne akertnele antywele anerrirreme. Kenhe ayenge akenhe, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apmere-kwenye-arle, arrangkwe. Ayenge-arle akwetethe re intetyeke. Ayenge-arle akwetethe-arle unthetyarte.” ");
INSERT INTO aer_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kele apententye akngerre Jesus-kenhe arrpenhe anteme ikwere angkeke, “Ayenge apele alhampwe-irreke-arle. Ayenge urrekeke impaye ayenge-arle apmere-werne alpetyeke, akngeye atyinhe artetyeke. Kenhe yanhe iperrele the ngenhe apenterle-apetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Kele Jesus akenhe ikwere alakenhe-arle angkirtnerlenge, “Arrangkwe, lyete nhenhe ayenge apentaye, atyenge akangkwe-irretyakenhe areyele renhe iperteke artetyeke re ilwerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Kele Jesus boat-eke antyemele kwatye alayele tyanemele alhetyeke-irreme apententye akngerre areye-akerte. ");
INSERT INTO aer_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Itne alaye talkwe alherlte-iwepiwemele, rlke akngerrele wernerlenge impeltye-ngentyele. Kwatye alyepe boat ikwere-arleke irrpeke, itne akenhe atere-irrerirrerlenge alhekwarle-irrerirre-ketyenge. Kenhe Jesus boat ikwerele ankwe-interle-aperlenge akwenpe anthurre. ");
INSERT INTO aer_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kenhe ikwerenhe areyele akarrelhe-ilemele akemelhe-ilerrirremele angkerrirreke, “Akngerrepataye! Anwernenhe itetheke mpwaraye, alhekwarle-irrerirre-ketyenge!” ");
INSERT INTO aer_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Kele Jesus itneke angkirtneke, “Iwenheke-ame arrantherre atere-irreme? Arrantherre itirretyakenhe tharle arrenhantherrenhe ulyeyele arntarnte-arerle-aneme.” Yanhe ikwerenge-ntyele, re akeme-irremele rlke mwantye-irretyeke kwatye arnmarre-arlke akweke-irretyeke ileke. Iparrpe anthurrele rlke atnengke-irreke kwatye arnmarre akweke-irreke. ");
INSERT INTO aer_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Itne apatemele angkerreke, “Artwe iwenhe-arle-ame nhenhe re? Re rlke uthene kwatye arnmarre uthene akweke-irretyeke ileke, kenhe ratherre atnengke-irrerlenge-arle!” ");
INSERT INTO aer_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Kele Jesus apententye akngerre ikwerenhe areye-arlke kwatye alayenge intwarreke-irremele itne alherlte-iweke apmere Gadara arritnye-werne. Apmere yanhe re, arratye apwerte akngerre areye-arle interrirreme inteye arrpe-anenhe aneme-akerte. Yanhe ikwere areye itne ilweke-arle areye inteye kweneke arrernewarretyarte. Kenhe artwe arerte atherre apmere yanhe ikwerele anerle-anerretyarte, arrentye atningke areye-arle ikwere-atherrele-arlenge aneme-akerte. Tyerrtye apmere ikwere-arenye areye iwerrele inteye itwele alhetyakenhe ahe-akngerre ikwere-atherre-ketyenge. ");
INSERT INTO aer_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ratherre untetyemele Jesus-nge arrekwele tneke, arrentye areye ikwere arlkemele, “Alere Ngkarte-kenhe, ingkirreke anthurreke akngerre anerlenge-arle. Unte-ame anwernenhe nthakenhe-iletyenhe? Unte-ame anwernenhe apmere akurne anthurre-werne yernetyeke lyete ware, urrekeke impetyakenhe?” ");
INSERT INTO aer_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Kenhe pike-pike atningke apwerte itwele tnerrirreke arlkwerrirremele. ");
INSERT INTO aer_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Arrentye areyele Jesus renhe ileke, “Unte apeke nhenhe atherrenge arratelhe-ilemele anwernenhe pike-pike itneke-werne yernaye anwerne tyerrtye itne-kenheke irrpetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Kele Jesus itneke angkirtnerlenge, “Kele mwerre-arle, pike-pike itneke irrperrirraye.” Iparrpele arrentye itne artwe yanhe atherrenge-ntyele arratewarremele pike-pike itne areyeke-arleke irrperrirreke. Kele imerte pike-pike itne apwerte kwene-werne unterlte-iwemele apwerte arnke-werne, ingkirreke akertne-ngentyele atnyerrirremele kwatye kweneke, ingkirreke anthurre anteme itne alhekwarle-irrerirreke. ");
INSERT INTO aer_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Kenhe tyerrtye yanhe itne pike-pike itnenhene arntarnte-arerlte-anemele arerrirreke nthakenhe-arle-irrerne, kele itne anteme-arle apmere-werne-arleke-irreme. Kenhe itne ingkirrenyekeke ilerrirreke nthakenhe Jesus-ele mpwareke-akerte, artwe atherre-arle arrentye areye atnyeneke-akerte-arlke. ");
INSERT INTO aer_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kele ikwerenge-ntyele, tyerrtye apmere yanhe-arenye itne Jesus-eke atwaremele alherlte-iweke. Itne renhe aremele, Gadara-arenye yanhe areye atere-irrerirremele, ikwere angkerrirreke, “Apmere nhenhenge-ntyele alperlte-iwaye!” ");
INSERT INTO aer_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Kele Jesus, apententye akngerre ikwerenhe areye-arlke boat-eke antyemele kwatye alayele tyanemele alpeke apmere nthenhe re anetyarte-werne. ");
INSERT INTO aer_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Apmereke-irrerlenge, artwe four-pelele artwe anathe antyameke arrernemele inerlte-alheke renhe imerte Jesus-werne akngetyemele. Kele Jesus-ele renhe-arle akngetyewarrekenge aremele itirreke, “Artwe nhenhe areye arratye itirreme tharle artwe anathe nhenhe mwerre-iletyenheke.” Re anteme artwe rlkerte ikwere angkeke, “Aye artwe-aye, atere-irretyalaye Ngkartele-arle ngenhe ilpernetyakenhe aneme unte-arle akurne mpwarekenge. Rarle ngkwengenge ipeltye-irreke-arle.” ");
INSERT INTO aer_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Kenhe artwe areyele, angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyele Jesus awemele, alakenhe itirremele, “Aye! Artwe nhenhele-arle Ngkarte angwareme, re-arrpe-arle Ngkarte akwele itirreme.” ");
INSERT INTO aer_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Kele Jesus-ele itelareke nthakenhe-arle itne ikwere-akerte itirreme imerte itneke angkemele, “Arrantherre akurnentye itirretyale anetyeke!” ");
INSERT INTO aer_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Arrantherre-arle ayenge areke-arle artwe nhenheke ayenge angkerlenge, kenhe arrantherre akenhe iwenhe apeke renhe aretyakenhe-arle aneke. Kele arrantherre apeke-arle atyenge apale itirreme ayenge-arle ware angkerlenge, kele arrantherre itirretyakenhe tharle mpwaretyeke. Kele ayenge lyete angkeme artwe inwerre nhenheke renhe mwerre-iletyeke. Kele arrantherre renhe areme, artwe inwerre nhenhe akngelhetyakenhe akeme-irrerlenge, kele anteme arrantherre itelaretyenhenge nthakenhe-arle ayenge arrekwele angkeke, the, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, angwenhe apeke renhe Ngkartenge ipeltye-ilerreme mpwaretyeke, Ngkartele anteme renhe ilpernetyakenhe aneme. Re anteme awethe angkeke artwe inwerre ikwere, “Artwe-aye, akeme-irraye, antyame ngkwinhe inemele apmere-werne alpaye!” ");
INSERT INTO aer_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Kele arratye re iparrpe akeme-irreke apmere-werne alpemele. ");
INSERT INTO aer_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Kele tyerrtye arunthe angathele-arle tneke areyele areke-arle itne atere-irremele Ngkarteke anteme utyernemele tnakemele angkeke alakenhe itirremele, “Aye! Arratye-arle Ngkartele artwe nhenhe ngangkere antheke re, ngangkere akngerre-akertele tyerrtye areye mwerre-iletyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Kele yanhe-ngentyele Jesus-ele apmere renhe impemele alheke artwe Matthew arritnye areke iwerre iterele ilthe akwekele anerle-anerlenge apwerte ngkweltye inemele government-eke. Nhenge artwe yanhele tyerrtye areye aremele iwerre ikwerele alherlenge re apwerte ngkweltye itneke-ngentyele inetyame government-eke. Jesus anteme ikwere angkeke, “Apetyaye, ayenge apentetyeke.” Kele Matthew akeme-irremele alheke apententye akngerre arrpenhe areyenge apurte-irremele. ");
INSERT INTO aer_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Jesus apententye akngerre ikwerenhe areye-akerte alheke apmere Matthew-kenhe-werne merne arlkwetyeke. Kenhe arrpenhe areyele-arlke mane-arle inerlte-anetyarteke arrpenhe areyele-arle akurne mpwaretyarteke itnekenge apurte-irremele merne arlkwerrirretyeke. ");
INSERT INTO aer_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Pharisee areyele itnenhe areke merne arlkwerlenge Jesus-enge, itne ikwerenhe areye alakenhe apayuthneke, “Aye! Iwenhenge-arle-ame akaltyele-anthenhe-anthenhe arrekantherrenhe apurtele arlkweme apwerte ngkweltye inentye akngerre areyenge tyerrtye akurne mpwarentye akngerre areyenge-arlke? Re itnekenge apurte-irretyale anetyeke, re kwenhe artwe mwerre areyenge anetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Kele Jesus-ele itnenhe awemele alakenhe angkerlenge, imerte itneke alakenhe angkemele, “Nhenhe awerrirraye! Tyerrtye mwerre areye ngangkere aretyeke alhetyakenhe-arle! Rlkerte areyele-ante-arle renhe aretyeke alheme. ");
INSERT INTO aer_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Arrantherre apeke apale itirreme ayenge-arle akwele apetyeke mwerre areye akwele ikngwetyeke. Arrangkwe, ayenge-arle apetyeke tyerrtye akurne areye ikngwetyeke. Akwete anteme itelaretyeke angkentye nhenhe arrpenhele arrule-arle Bible-nge intelhe-ileke. Ngkarte-arle alakenhe angkeke, ‘Kere atwetyale ayenge anthetyeke. Alakenhe-ante-arle ayenge ahentye-aneme; arrantherre arrpenhe areyeke alhwarrpe-irremele alpe-eme-iletyeke. The areme alakenhe arrantherre mpwarerlenge kele ayenge arnterre anthurre-arle akangkeme.’” ");
INSERT INTO aer_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Arlte anyentele apententye akngerre John kwatye akwernentye akngerre-kenhe arrpenhe areye apetyemele Jesus apayuthneke, “Anwerne Pharisee areyele-arlke merne arlkwentye akngerre kwenhe anwerne-arle Ngkarteke angketyeke ante-arle ahentye-aneme. Iwenhenge-arle-ame apententye akngerre ngkwinhe areyele akwetethe merne arlkweme, arraretyakenhele-arlke?” ");
INSERT INTO aer_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesus itneke angkirtnerlenge, “Nhenge artwele apeke anewe-akemele, atyewe atningke-arle apurte-irremele akangkentyele merne arlkwerrirretyeke. Re itnekenge akwete anemele, itne arlkwerrirremenge akwete. Kele yanhe-ngentyele arrpenhe areyele artwe renhe atyewe ikwerenhenge arntwirrkemele akngeme. Kele alakenhe ikwerenge itne, irrare-irremenge-arle, merne arlkwetyakenhe-arle. Kenhe itne akenhe ayenge arntirrkwemele akngeme apententye akngerre atyinhe areyele merne arlkwetyakenhe-arle anerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jesus-ele itneke ileke angkentye alengkiwentye mantere-akerte. “Arrantherre itelareme mantere tyerrtye-kenhe ingkweye-irrerlenge altywere-akerte re, artetyeke, re mantere akweke alkarlenge-ntyele aketyakenhe ingkweye ikwere-arleke arrernetyeke, alterrelheketye alhewerlenge. Kele unte apeke renhe alheweme, mantere akweke alkarle rarle arrerneke re akenhe akweke-arle-irrerlenge imerte alterrelhemele-arle, kele mantere altywere-akerte re akenhe altywere akngerre-arle-irrerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Jesus-ele itneke ileke angkentye alengkiwentye arrpenhe ngkwarle-kenhe ayakwethe-akerte. “Awethe anteme angkentye arrpenhe-ulkere nhenhe awerrirraye ngkwarle-kenhe yakwethe-akerte. Artwe arrpenhele mpwareme yakwethe kere yenpe-ngentyele ngkwarle lyetenye akwernetyeke atnyenemele. Kenhe re akenhe yakwethe angkweyeke ngkwarle lyetenye akwernetyeke arrangkwe-arle, re apeke ngkwarle lyetenye thelemele ngkwarle rarle akurne-arle-irrerlenge. Yakwethe angkweyenge, antyerrkenge, alterrelhemele, ngkwarle re altyiwelhemele ahelhe-werne-atheke-arle. Alakenhe-irreme-ketye anteme re ngkwarle lyetenye renhe akwernemele yakwethe atyete-atyete mwerre lyetenyeke-arleke kele yakwethe re mwerre alterrelhetyakenhe-arle aneme kele yakwethe uthene ngkwarle uthene kele mwerre-arle aneme.” Alakenhe-arle Jesus itneke angkeke itne-arle angkentye ikwerenhe Moses-kenheke-arleke anyentelhe-ileme-ketye. ");
INSERT INTO aer_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nhenge Jesus-arle itneke angketyamenge artwe Jew areyeke tyatye-arenye akngerrepate apetyeke. Jesus-eke kwene-irremele ikwere angkeke, “Ampe marle atyinhe apele ilwerne lyete ware. Aretyeke apetyaye, renhe anpemele re itethe-irrirtnetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesus-ele awemele artwe renhe apentenheke, atyewe ikwerenhe areye-arlke apentenheke. ");
INSERT INTO aer_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Itne ingkerre artwe ikwerenhe apmere-werne alherlte-iweke, kele arelhe rlkerte arrpenhe apetyeke-arle mpwepe-mpwepele. Rarle alhwe itnyetyarte akwetethenhe akwetethe arrule-arrule-ngentyele year 12-peleke-atwetye. Re Jesus-werne angathe-irremele re itirreke, “The nterte-ntertele ware mpwaremele mantere ikwerenhe anpeme, kele ayenge mwerre-arle-irreme.” Kele arratye re mantere atnartenge ikwerenhe anpeke. ");
INSERT INTO aer_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesus-ele alkngarelhemele renhe areke re renhe mwantye-mwantye-ilemele angkeke, “Akunye-apenhe! The ngenhe angkwerre-iweke unte-arle ayenge arratye itelarekenge. Apmere-werne alpaye itirretyakenhenge, unte-arle kele mwerre aneme.” ");
INSERT INTO aer_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Kele Jesus apmere artwe irrare-kenhe-werne alheke, re apetyemele areke tyerrtye areye akayale artnelhe-ilerrerlenge, arrpenhe areyele horn pewe-ileke irrarele. ");
INSERT INTO aer_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Re anteme itneke angkeke, “Akeme-irrerirraye, akethe-werne alherlte-iwaye! Ampe nhenhe kwenhe ilwetyakenhe rarle interle-aneme ware.” Nhenhe itne awemele itne atherreke Jesus ikwere, itne-arle itelareke marle renhe kele ilweke-arle. ");
INSERT INTO aer_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Kele akngeye ampe marle-kenhele anteme itnenhe akethe-werne alhetyeke ileke. Kele Jesus irrpenheke ampe rarle intetyame-werne imerte renhe iltyenge inemele, kele ampe re akenhe akeme-irrerlenge mwerre anteme-irremele. ");
INSERT INTO aer_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Tyerrtye areyele awerrirreke ampe akeme-arle-irreke ikwere-akerte imerte angkentye antekelhe-ilemele apmere arrpe-anenhe-werne. ");
INSERT INTO aer_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kele Jesus-ele apmere rarle imperle-alheke. Rarle iwerrele alhetyamenge artwe pwenge atherrele renhe apenteke alakenhe arlkerle-aperremele. “David-eke-artweye-aye! Ilerneke alhwarrpe-irraye.” ");
INSERT INTO aer_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Jesus apmereke-irremele re kwene-werne alpeke, artwe ratherre renhe apentemele kweneke irrperle-anerreke. Kele Jesus-ele renhe-atherrenhe apayuthneke, “Mpwele-ame arratye itirremele tharle mpwelenhe alknge ulyeyele altywere-ilemere?” Ratherre angkirtnerlenge, “Yewe Ngkarte, ilerne arratye itelareme.” ");
INSERT INTO aer_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Kele renhe-atherrenhe alknge anpeke imerte angkemele, “Kele mwerre, alknge mpwele-kenhe-arle altywere-arle-irretyenhe mpwele-arle itirremenge tharle mpwelenhe angkwerre-iwetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Kele arratye, alknge ikwere-atherrenhe altywere-irreke ratherre imerte aremele. Kele Jesus-ele renhe-atherrenhe ileke tyerrtye arrpenhe areyeke iletyale anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Kele ratherre akenhe akangkwe-irretyakenhe-arle aneke, ratherre alheke apmere arrpe-anenhe-werne tyerrtye areyeke ilelhemele Jesus-ele-arle renhe-atherrenhe mpwareke angkwerre-iwemele. ");
INSERT INTO aer_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Kele ratherre-arle alhekenge kele tyerrtye arrpenhe areye anteme Jesus-werne apetyemele akngetyeke artwe angketyakenhe anyente arrentye-arle ikwerele-arlenge anekenge. ");
INSERT INTO aer_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Kele Jesus-ele arrentye renhe ileke arratemele alhetyeke, kele artwe arrakerte altywere-irreke kele re anteme angkeke. Tyerrtye areyele aremele itne apatewarreke imerte angkemele, “Ayekaye! Anwerne-arle alakenhe aretyakenhe-arle apmere nhenhe Israel-eke.” ");
INSERT INTO aer_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Kele artwe Pharisee itne akenhe angkeke, “Arrangkwe, rarle arrentye areye aywepemele tyerrtye areye-ngentyele arrentye akngerrepatele-arle renhe ngangkere anthekenge-arle.” ");
INSERT INTO aer_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesus apmere arrpe-anenhele untherle-apeke apmere akweke areyele apmere akngerre areyele-arlke, re tyatye Jew areye-kenhe-werne-arlke alheke. Re itneke Angkentye Mwerre Ngkarte-kenhe ileke Ngkarte-arle itneke akngerrepate aneme itnenhe arntarnte-aremele. Apmere arrpe-anenhele re rlkerte-arlke inwerre areye-arlke angkwerre-iweke. ");
INSERT INTO aer_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Re tyerrtye areye aremele re itneke alhwarrpe anthurre awelheke, itne akunye-apenhe-arle apatewarrerlenge untherlte-apekenge yepe-yepe areye-arle aparlpe-irreke, arrpenheke arrangkwele itnenhe arntarnte-aretyeke nhenge ulkere-arteke. ");
INSERT INTO aer_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Jesus tyerrtye areyeke alhwarrpe-irremele atyewe ikwerenhe areyeke angkeke, “Tyerrtye arrpenhe arunthe areye apmere arrpe-anenhe yanhe ikwerele-arle anerrirremeke. Kenhe the atyenge urrkapentye akngerre urrpetye ware atnyeneme tyerrtye ingkirreke-arle inemeke Ngkarte Ikwere-werne akngetye-akngetye-alhetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Kenhe Ngkartele ingkirreke yanhe areye Ikwere-arrpe anteme-arle atnyenetyeke. Kenhe arrantherre akenhe Ngkarte Ikwere angkerrirraye Renhe apayuthnerrirraye urrkapentye akngerre awethe arrpenhe areye nhenhe-werne yernetyeke, Re itnenhe ingkirreke Ikwere-werne akngetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","4","Kele Jesus-ele atyewe 12-pele ikwerenhe areye ikngwemele akngakemele, anyente Simon arritnye Peter-arle arritnye arrpenhe ikwerenhe aneke, kake ikwerenhe Andrew, alere Zebedee-kenhe atherre James uthene John uthene, Philip uthene Bartholomew-arlke, Thomas uthene Matthew uthene apwerte mane inentye akngerre-arle government-eke, James alere Althaea-kenhe-arle, Thaddaeus uthene Simon uthene, Rome-arenye areyeke akngerrepate-arle ahentye kwenye anthurre, Judas Iscariot, re akenhe urreke-arle Jesus Jew areye-kenhe akngerrepate areyeke imernetyenhe itne renhe arntwirrketyenhenge. Jesus-ele artwe nhenhe areye ikngweke ikwere-werne apetyetyeke, ngangkere anthemele, itnenhe ileke alhetyeke arrentye areye tyerrtye areye-ngentyele aywepetyenhenge tyerrtye areye-arlke angkwerre-iwemele mwerre-iletyeke. ");
INSERT INTO aer_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Nhenge Jesus-ele apententye akngerre 12-pele yernemele, ngangkere anthemele itnenhe ilemele Israel-arenye areyeke-ante ware alhetyeke imerte itneke alakenhe angkemele, “Apmere Jew anetyakenhe areye-werne alhetyale. Samaria-arenye areye-werne-arlke alhetyale! ");
INSERT INTO aer_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Anwerne-kenhe areye-werne-ante alherlte-iwaye, nhenge tyerrtye Israel-arenye areye itne-arle yepe-yepe areye-arteke aparlpe-aparlpe anerlenge, arntarnte-arentye akngerrenge-ntyele untherrirrekenge. ");
INSERT INTO aer_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Arrantherre itneke-werne alherlte-iwemele Angkentye Mwerre Ngkarte-kenhe iletyeke, alakenhe itneke ilaye, ‘Kele angathe anteme-irreme Ngkartele anwernenhe ikwerenhe mpwaretyeke anwernenhe arntarnte-aremele akngerrepatele.’ ");
INSERT INTO aer_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","The arrenhantherrenhe ngangkere anthekenge, tyerrtye rlkerte areye angkwerre-iwemele mwerre-iletyeke, arrantherre apeke aremele tyerrtye ilweke-arle, renhe akemelhe-ilaye itethe-ilirtnemele, tyerrtye utyene-akerte areye-arlke angkwerre-iwaye mwerre-iletyeke, arrentye areye-arlke tyerrtye areye-ngentyele aywepaye. Kele itne mwerre-irrerlenge, itnenhe maneke apayuthnetyale tharle arrenhantherrenhe yernerlenge areye mwerre-iletyeke, kele arrantherre akenhe akangkentyele itnenhe angkwerre-iwetyeke mane kwenye. ");
INSERT INTO aer_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","10","Imerte iltye-ante alherlte-iwemele yakwethe akngetyale. Mantere arrpenhe apeke, ingke-kenhe arrpenhe-arlke apeke urrekeke akngetyale, atneme-arlke akngetyale, iltye-ante alethe alherlte-iwaye. Tyerrtye areyele arrenhantherrenhe iwenhe apeke renhe antheme arrantherre-arle atyenge urrkapemenge. ");
INSERT INTO aer_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Arrantherre apmere arrpenhe-werne alherlte-iwemele aremele tyerrtye mwerreke arrenhantherrenhe-arle apmereke akwernetyenheke. Apmere ikwerenhele akwete anaye altheke-arlekele-ante iwerle-alhetyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Kenhe urreke arrantherre ilthe arrpenhe-kenheke irrpetyenhenge itneke alakenhe angkerrirraye, ‘Ngkartele arrekantherrele-arlenge aneme-arle akwetethenhe-akwetethe.’ ");
INSERT INTO aer_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Kenhe yanhe-arenye apeke arrekantherre mwerre angkerrirrerlenge, Ngkartele itnekenge anetyenhe akwetethenhe-akwetethe. Kenhe itne apeke arrekantherre ahentye-kwenye anerrirrerlenge, itnenhene imperre-arle-irraye, Ngkartele itnenhe imperlenge anteye. ");
INSERT INTO aer_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Kele itne apeke arrenhantherrenhe apmereke akwernetyakenhe ikngwetyakenhe itne angkentye-arlke arrekantherrenheke akangkwe-irretyakenhenge. Kele arrantherre apmere renhe impemele alhaye, kenhe urreke arrantherre apmere ikwerenge alhetyenhenge ahelhe lernelhetyeke ingke-kenhe arrekantherrenhe-ngentyele. Itne aremele ahelhe lernerlenge kele itne itelaremele-arle Ngkarte-arle itneke ahele-arle-irreme. ");
INSERT INTO aer_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ayenge-arle arrekantherre arratye-arle angkeme, arlte ingkernenge Ngkartele-arle tyerrtye areye akngakemele akalkelhe-iletyenhe apmere arrpe-anenhe-ngentyele. Re aywepemele yernetyenhe Sodom-arenye areye uthene Gomorrah-arenye areye uthene apmere akurne arrengkwelthe-arle akwetethe aneme-werne. Re tyerrtye areye angkentye arrekantherrenhe-arle aweke-arle iperre, akangkwe-irretyakenhe areye-arlke yerneme. Kenhe itne akenhe rlkerte akngerre anthurre renhe inetyenhe Sodom-arenye areye uthene Gomorrah-arenye areyenge awethe arntwarre ulkere.” ");
INSERT INTO aer_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Kele Jesus awethe itneke angkeke, “Ye, the arrenhantherrenhe apmere areye-werne yerneme, arrantherre angkentye atyinhe iletyeke. Kenhe apmere itnekenge akenhe tyerrtye ahe akngerre areye-arle aneme, itne-arle arrekantherre ahele-irretyenhe, arrekantherre akurne-arle-irreme. Kele arrantherre yepe-yepe-arteke-arle akngwelye artnwere ahe-akngerre areyele utepe-akerrirreke. Alakenhenge anteme arrantherre mwantyele awerrirretyeke, ameke-arelhewarremele itneke ahele-irrirtnetyale, nterte ware anemele thipe urrelyarre-arteke. ");
INSERT INTO aer_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yewe ameke-arelhewarraye, itne-arle arrenhantherrenhe arntwirrkemele court-eke arrernetyenhe. Itne arrenhantherrenhe atwetyenhe, tyatye Jew areye-kenhe arrpe-anenhenge, arrantherre-arle angkentye atyinhe ilemenge. ");
INSERT INTO aer_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Alakenhe-arlke itne arrenhantherrenhe akngetyenhe ngkernetyeke akngerrepate areyeke-arleke arrantherre-arle ayenge apentemenge. Kenhe arrantherre anteme Ayeye Mwerre itneke akwenpele iletyenhe, Jew anetyakenhe areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Itne apeke arrenhantherrenhe arntirrkwerlenge arrenhantherrenhe court-werne akngetyeke atere-irretyale anaye, akwenpe. Arrantherre apateketye nthakenhe akngerrepateke angketyeke. Arnterre itirretyale nthakenhe angketyeke, Ngkartele-arle arrenhantherrenhe angkentye anthetyenhenge nthakenhe angketyeke. ");
INSERT INTO aer_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Utnenge ikwerenhele-arle arrekantherre imernetyenhe nthakenhe angketyeke arratye. Arrantherre-arle itirrentye arrekantherrenhenge angketyeke arrangkwe-arle, kele arrantherre-arle angketyenhe rarle arrenhantherrenhe ileme-arteke-arle. ");
INSERT INTO aer_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","22","“Ye, tyerrtye areye arrekantherre ahentye-anetyakenhe anetyenhe arrantherre-arle atyinhe anemenge. Artwe ayenge apentetyakenhele-arle kake ikwerenhe iltye anthetyenhe akurne areyeke rarle ayenge apenterlenge itne anteme renhe atwetyenhenge. Alakenhe anteye akngeyele apeke mpwareme ampe ikwerenhe areyeke ayenge-arle itne apentemenge. Ampele apeke iltye anthemele mikwe uthene anyikwe uthene iltye anthemele artwe ahe akngerre itnenhe atwetyeke itne-arle atyinhe anemenge. Kele arrantherre apeke ayenge akwetethe apenterlte-anemele arrantherre ilwetyeke-atwetye kele arrenhantherrenhe Ngkartele mwantyele-arle arntarnte-areme arrantherre akwete-ante ikwere anerlte-anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Arrantherre apeke apetyemele apmere arrpenheke arratetye-alhemele arrenhantherrenhe tyerrtye areyele atwemele-arle ilterreme arrantherre-arle angkentye atyinhe ilemenge, kele arrantherre apmere arrpenhe-werne untetyeke-arle. Kele the akenhe arrenhantherrenhe arratye-arle ileme, arrantherre Israel-ele akwete untherlte-anemenge angkentye atyenge-akerte ilerlte-apemele, ayenge Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apetyalpetyenhe akngerrepate anteme anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Awerrirraye, tyerrtye ahele akngerre areye atyenge-akerte angkerreme, atyenge-arle itne akurne-irrekenge itne arrekantherre anteme akurne-irretyenhe arrantherre-arle atyewe atyinhe anemenge. Angkentye nhenheke akangkwe-irraye, ‘Arrantherre itelareme artwe akaltye-arle-irrerle-aneme, rarle akaltyele-anthenhe-anthenhe ikwerenhenge akngerre ulkere anetyakenhe-arle, alakenhe anteye urrkapentye akngerre areye akngerre-irretyakenhe akngerrepate ikwerenhenge ulkere.’ ");
INSERT INTO aer_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Alakenhenge arrantherre itirrewarretyeke, tyerrtye areyele apeke akaltyele-anthenhe-anthenhe ilterrirrerlenge kele itne ikwerenge-arle akaltye-irreke areye-arlke-arle ilteke. Itne apeke akngerrepate akurne-ilemele, alakenhe itne akurne-ileme urrkapentye akngerre ikwerenhe areyeke. Itne kwenhe atyenge ahele-irremele alakenhe angkeme, ‘Unte kwenhe arrentye nhenge Beelzebul, arrentye areyeke akngerrepate.’ Itne apeke atyenge apale angkemele kele itne akurne awethe arntwarre-arle arrekantherre, arrantherre-arle atyinhe anemenge.” ");
INSERT INTO aer_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Kele imerte Jesus angkemele, “Tyerrtye yanhe areyenge atere-irretyale tharle arrekantherre ileme-arle itne-arle tyele angkerlte-anemenge, arne yanhe apele Ngkartele iletyenhe-arle urreke tyerrtye ingkirrekele awetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Angkentye nhenge tharle arrekantherre ileke anyelknge-anyelkngele ingwele arrantherre arltele akethe angketyeke tyerrtye areyeke. Angkentye tharle arrekantherre arretyemele ileke, arrantherre arnterre arlketyeke tyerrtye areyele awetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Atere-irretyalaye tyerrtye areyele arrenhantherrenhe atweketye, itne-arle tyerrtye arrekantherrenhe ware-arle atwerlenge, itne akenhe utnenge arrekantherrenhe uyarne atweme. Kele Ngkarte-ketyenge-ante akwete atere-irretyeke, Ngkartele-ante-arle kwenhe tyerrtye uthene utnenge-arlke apmere akurne ureke iweme. ");
INSERT INTO aer_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ngkarte-arle arrekantherre akwetethe-arle mwerrantye itirrerle-aneme alkngwirretyakenhele. Thipe nhenge nyingkeke itirraye. Unte apeke thipe atherre alakenhe inemele mane akwekele ware. Arrantherre apeke itirreme Ngkarte-arle akwele thipeke itirretyakenheke-athene. Arrangkwe, Ngkarte-arle itneke akwetethe-arle itirrerle-aneme nhenge thipe anyente atnyeme imerte ilwemele, kele re itelareme-arle. ");
INSERT INTO aer_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ngkarte arrekantherre thipe areyenge awethe anthurre ulkere ahentye-aneme. Re itelareme nthakentyeke alte akapertele arrekantherrele-arlenge, re yanhe areyeke ingkirreke anthurreke alkngwirretyakenhe. Alakenhe ikwerenge anteme arrantherre arrpenhe itne-ketye atere-irrerirretyale anetyeke itne apeke apetyewarrerlenge arrenhantherrenhe atwerrirretyeke. Kele arrenhantherrenhe Ngkartele arntarnte-aretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Unte apeke akwenpe ilelheme tyerrtye atningkenge unte-arle atyewe atyinhe aneme, kele ayenge alakenhe anteye-arle angkeme alkere akertnenge akngeye atyinhe anerlenge alakenhe, ‘Nhenhe areye-arle atyinhe areye-arle.’ ");
INSERT INTO aer_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Kenhe unte apeke atyenge akutne angkemele tyerrtye atningke arrekwelenge, kele ayenge ngkwenge akutne-arle ilelheme Akngeye atyinheke alkere akertnele anemeke.” ");
INSERT INTO aer_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Jesus itneke akwete angkeke alakenhe, “Arrantherre apeke-arle apale itirrewarreke ayenge-arle ahelhe-werne apetyeke nhenge tyerrtye areye akwele arrpenhe-arrpe anyente-irrerlte-anetyenhenge. Kele arrangkwe, tyerrtye areye-arle ahele-irremele atwerreme-arle atyengenge. ");
INSERT INTO aer_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Akngeye alerikweke ahentye-anetyakenhe rarle ayenge-ante apentemenge. Kenhe meye ampikweke ahentye-anetyakenhe rarle ayenge-ante apentemenge. Kenhe arelhe arrpenhe akenhe anherre-anherre ikwerenheke ahentye-anetyakenhe rarle ayenge-ante apentemenge. ");
INSERT INTO aer_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ye, ngkwenge-artweye areyele ayenge arratye apentetyakenhe ngkwenge ahentye-anetyakenhe-arle unte-arle ayenge apentemenge. ");
INSERT INTO aer_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Unte apeke-arle ngkwenge-artweye areyeke ahentye anthurre aneme apeke, akngeye uthene meye uthene ngkwinhe ampe-arlke ngkwenge, kele mwerre-arle. Kele unte ayenge apentetyeke unte atyenge-arle ahentye-anetyeke itnekenge awethe ulkere. Kele, unte-arle atyenge ahentye-aneme alakenhe-arteke, kele unte apententye akngerre atyinhe arratye anetyenhe-arle.” ");
INSERT INTO aer_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jesus angkeke, “Kenhe ayenge apmere Jerusalem-werne alhemele arne arntarlkweke-arleke ilwetyeke. Kenhe arrantherre apeke akangkemele atyengele-arlenge ilwetye-alhetyeke, kele mwerre-arle. Apetyaye atyewe atyinhe anaye. Kenhe arrantherre apeke akenhe atyengele-arlenge ilwetyeke ahentye-anetyakenhe, nthakenhe-ame arrantherre atyenge atyewe-irretyenhe? ");
INSERT INTO aer_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Kenhe angwenhe apeke itethe anetyeke-arle itirremele ilweketyenge, re ilwetyenhe akwete. Kenhe angwenhe apeke ilwetyenhe rarle ayenge apentemenge, the renhe itethe atnyenetyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Jesus angkeke, “Tyerrtyele apeke arrenhantherrenhe aremele, akangkemele arrenhantherrenhe ikngweme, imerte apmere kweneke arrernemele arrenhantherrenhe arntarnte-aremele, kele ayenge ikwerenge akangkentye anthurre-arle aneme rarle ayenge ikngwemenge-arteke ayenge arntarnte-aretyeke-arteke. Rarle aleme altywerele renhe apmere-werne ikngwemele alakenhe. Rarle ikngweme anteye arrpenhe ayenge-arle yerneke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Angwenhele artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre akangkemele ikngweme rarle angkentye ilemenge, kele, Ngkartele renhe-atherre-ante-arle arne mwerre-arteke antheme-arlke. Kele angwenhele apeke artwe mwerre ikngweme rarle mwerrenge, kele, Ngkartele renhe-atherre-ante-arle arne mwerre-arteke antheme. ");
INSERT INTO aer_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nhenhe itelareye. Angwenhele apeke kwatye irrernte anthemele apententye akngerre kwenhe rarle ayenge apentemenge, kele, akwetethenhe-arle Ngkartele renhe arne mwerre arratye antherle-aneme.” Alakenhe-arle Jesus-ele apententye akngerre 12 pele ikwerenhe areye akaltyele-antheke urreke re itnenhe yernetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Nhenge Jesus-ele 12 pele itnenhene akaltyele-antheke-arle iperre, re apmere ikwerenge-ntyele alheke apmere akweke itweke-itweke arrpenhe areye-werne tyerrtye ingkirrekeke angkentye Ngkarte-akerte ilerle-apemele itne akangkwe-irremele awetyeke. ");
INSERT INTO aer_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Artwe nhenhe John, tyerrtye areye kwatyeke akwernentye akngerre-arle, re aweke jail-ngentyele Christ-ele-arle arne atningke ngangkere akngerrele mpwareke, re apententye akngerre ikwerenhe areye ilekenge Jesus apayuthnetyeke alhetyeke. ");
INSERT INTO aer_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Itne anteme alherlte-iweke, ikwerenge anyente-irremele apayuthneke, “Unte-ame artwe John-elarle iletyame urreke apetyetyenhe-arle? Unte apeke-arle tyerrtye arrpenhe apeke-arle, kele anwerne ikwere akarelheme akwete-arle.” ");
INSERT INTO aer_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Kele re itneke angkirtneke, “John-eke ilerretye-alhaye arne atningke arrantherre-arle areke awemele-arlke. ");
INSERT INTO aer_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Pwenge aneke-arle areye kele aretyeke anteme akenhe, inwerre areye akenhe akeme-irremele untheme anteme-arle, arrengkwelthe-akerte areye kele mwerre anteme-arle, kele irlpe awetyakenhe areyele kele aweme anteme-arle, tyerrtye ilweke-arle areye akenhe itethe anteme-arle. Tyerrtye ingkirreke alhwarrpe aneke kele Angkentye Mwerre Ngkarte-kenhe anteme aweme. ");
INSERT INTO aer_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ye, kele awethe anteye John-eke iletye-alpaye Ngkartele yanhe areyeke-arle akangkeme atyenge-arle arratye akwete akangkwe-irremenge.” Alakenhe-arle Jesus angkeke nhenge re itnenhe John-werne yernirtnemele. ");
INSERT INTO aer_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kele itne alherlenge, Jesus tyerrtye areyeke angkeke John-akerte alakenhe, “Arrantherre itelareme arrule anthurre, urreke Herod-ele-arle renhe jail-eke akwernetyenhenge, arrantherre apmere ahurratye-werne, apmere nhenge arntwarre tyerrtye areye-arle aneme-ketye, artwe John renhe aretyeke. Kele iwenhenge-arle-ame arrantherre renhe aretyeke alheke? Artwe iwenhe-arteke-arle-ame arrantherre aretyeke alheke? Arrantherre apeke apale-arle alakenhe itirreke John-arle angkentye ikwerenhe akwethenhe-akwetethe akngarte-iwerle-anetyame. Arrangkwe, rarle angkentye anyente akwete-arle ilerle-aneme. ");
INSERT INTO aer_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Kele iwenhenge-arle-ame arrantherre renhe aretyeke alheke? Arrantherre apeke-arle artwe mantere mwerre akngerre-akerte apeke-arle aretyeke alheke? Kele arrangkwe-arle, John-arle alakenhe anetyakenhe-arle, artwe mantere mwerreke irrpentye akngerre-arle akngerrepate itnekenhe akenhe apmerele-ante-arle anentye akngerre-arle ahurratyele anetyakenhe, tyerrtye areye-ketyenge arntwarrele. ");
INSERT INTO aer_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Atyenge ilaye! Artwe iwenhe-arteke-ame arrantherre aretyeke alheke? Arrantherre apeke-arle artwe angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre apeke areke? Ye, kele arrantherre arratye-arle areke! John-arle atyeperre rarle angkentye Ngkarte-kenhe ilentye akngerrenge awethe ulkere. Arrpenhe areyenge atyeperre anthurre ulkere. ");
INSERT INTO aer_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Arrpenhele angkentye ikwere-akerte intelhe-ileke pipe-ke-arleke arrule, Ngkarte-arle ikwere alakenhe angkeke-akerte, “The angkentye ilenhe-ilenhe yernetyenhe ngkwengenge arrekwele. Re ngkwengenge arrekwele-arle alhetyenhe, tyerrtye itneke iletyeke ngkwenge akwetante mpwaretyeke unte-arle apetyetyeke.’” ");
INSERT INTO aer_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Jesus awethe itneke angkeke, “Nhenhe itelaraye! Artwe John, tyerrtye areye kwatyeke akwernentye akngerre-arle, re arrpenhe ingkirrekenge atyeperre anthurre ulkere, ikwerenge-arle arrekwele anerrirrekeke. Kenhe lyete-ngentyele akenhe iwerre arrpenhe-arle aneme. Ampe akweke areye Ngkartele-arle atyewe ikwerenhe areye akeme, itne kwenhe John-enge atyeperre anthurre ulkere-arle. ");
INSERT INTO aer_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","John Baptist apetyeke tyerrtye areyeke ilemele Ngkarte-werne utepe-irretyeke, itneke ilemele Ngkarte rarle itneke ahentye-anerlenge arnenge-ikwe mpwaretyeke, itnenhene arntarnte-aretyeke. Lyete tyerrtye arrpenhemele akwete arrkernewarremele arnterre anthurre Ngkarte akngerrepate itnekenhe mpwaretyeke, itne Jesus-nge anyente-irretyeke ahentye anthurre anemele. ");
INSERT INTO aer_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","“Arrule anthurre Moses-ele-arlke, angkentye Ngkarte-kenhe ilentye akngerre arrpenhe areyele-arlke intelhe-ileke Ngkartele-arle akwetethe anteme tyerrtye areyeke akngerrepate anerle-anetyenhenge. Kele nyurrpe arrpe-anenhe re anteme akngerre-irreke, ilweke anteme. Kele arrpenheke-artweyeke-artweye irreme ilwerrirreke anteme. Kele John anteme ingkernenge apetyeke. ");
INSERT INTO aer_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Itne ileke-arle arrekwele akwete urreke-arle angkentye ilentye akngerre arrpenhe artwe Elijah arritnye-arle apetye-alpetyenhe arrekwele akngerrepate alhileke-arle ikwerenge. Alakenhenge anteme arrantherre angkentye ikwere akangkwe-irretyeke, anyente Elijah-arteke-arle apetyetyenhenge, arrantherre itelareme artwe nhenge John. ");
INSERT INTO aer_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ye, kele arrantherre apeke akaltye-irretyeke ahentye-aneme, kele mwantyele awaye nthakenhe-arle ayenge angkerneke.” ");
INSERT INTO aer_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kele Jesus itneke alakenhe awethe angkeke, “Iwenhe-arteke-arle-ame arrantherre? Arrantherre-arle akurrknge akwetethe akngarte-iwelhewarreme ampe areye-arteke. Arrantherre itelareme nthakenhe-arle ampe areye apurte-irremele tnemele arlkerrentye akngerre nhenge alakenhe angkemele, ");
INSERT INTO aer_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Anwerne kwenhe alyelhetyame arrkerneme-arlke irlpentye mwerreke, arrantherre akenhe urntetyeke apetyetyakenhe-arle.’ Kele arrpenhe areye akenhe itne alakenhe-arle angkirtnerlenge, ‘Yewe, kele anwerne akenhe artnemele-arle irrare-irremele-arle alyelhetyame alyelhentye irrare-irrareke. Kenhe arrantherre anwernenhe awemele, anwerneke anyente-irretyakenhe, anwernenge artnetyakenhe-arle.’ ");
INSERT INTO aer_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","19","Alakenhe rarle arrantherre John ilerneke ipmentye-iweme. John apetyeke re ngkwarle antywetyakenhe aneke, awethe-ngare merne-arlke arlkwetyakenhe anetyarte Ngkarteke-ante angketyenhenge. Kele nhenge arrantherre renhe arerrirremele, arrantherre angkeke rarle arrentye-akerte ikwerenge untyeme-irreke. Kele nhenge arrantherre ayenge aremele, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, kele arrantherre apale angkemele alakenhe, ‘Artwe yanhe-arle atnure-arle-irreme merne uthene ngkwarle utheneke, atyewe akemele tyerrtye akurne areyenge anemele, arrantherre itelareme artwe areye mane inenhe-inenhe government areyeke-arle, tyerrtye akurne arrpenhe areye-arlke.’ Arrantherre alakenhe rarle atyenge angkerrirreke. Alakenhe ikwerenge anteme arrantherre ampe areye-arteke. Kele nhenhe-arle awerrirraye, Ngkarte akenhe akaltye anthurre re, iwerre arrpenheke-arrpenhe tyerrtye arrpe-anenheke mpwareke. Urreke tyerrtye areyele itelaretyenhe John-elarle iwerre Ngkarte-kenhe apenteke ikwere, kenhe the akenhe iwerre Ngkarte-kenhe apenteme atyenge.” ");
INSERT INTO aer_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Kele Jesus aletheke-irretyame apmere nhenhe areye-werne Chorazin, Bethsaida, Capernaum-werne-arlke, re rlkerte areye angkwerre-iwerle-apetyame itneke ngangkerele arne mwerre-arlke mpwaremele. Tyerrtye apmere yanhe-arenye areyele akethe areke ngangkerele mpwarerle-aperlenge, itne akenhe ikwere akangkwe-irretyakenhe-arle aneke. Itne apure-irretyakenhe aneke akurne areye-arle mpwarekenge. Itne Ngkarte-werne utepe-irretyakenhe. Kele Jesus itneke alakenhe ahele-ahele angkeke, ");
INSERT INTO aer_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Akurne akngerre-arle anetyenhe Chorazin-arenye areyeke-arlke Bethsaida-arenye areyeke-arlke. Apmere arrekantherrenge tharle tyerrtye rlkerte areye-arle angkwerre-iwekenge ngangkerele-arle itnenhe mwerre-ileke, ngangkerele-arlke atningke arrpenhe mpwareke. Kele arrantherre areke-arle iperre, Ngkarte-werne utepe-irretyakenhe-arle. The apeke alakenhe arrekwele mpwareke-arle apmere Tyre uthene Sidon uthenele tyerrtye apmere yanhe atherre-arenye areye-arle kele iparrpe-arle apure-irremere akurne itnekenhe-ngentyele. Kele imerte mantere ingkweyeke irrpemele imerte arlpmenyele inngerre apernelhemele imernetyeke apure-irremele akurnentye impemele. ");
INSERT INTO aer_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nhenhe awerrirraye! Urreke, arlte ingkernenge, Ngkartele-arle inemele akngaketyenhe tyerrtye apmere arrpe-anenhe-ngentyele, re alkngetherre ilemele tyerrtye areye Tyre-arenye, arrpenhe areye-arlke Sidon-arenye itnenhe apmere akurne-werne yernetyenhe, itne arrengkwelthe inetyenhenge rlkerte-irretyeke. Re arrenhantherrenhe alkngetherre ilemele yernemele arrantherre-arlke arrpenhe yanhe areyenge alhetyeke, kele apmere yanhenge arrantherre rlkerte arrpenhe-arle ineme tyerrtye itnekenge awethe ulkere, arrenhantherrenhe kwarneme anthurre. ");
INSERT INTO aer_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kenhe arrantherre apmere Capernaum-elarle anerrirremeke, arrantherre-ame itirrewarreme Ngkartele-arle arrenhantherrenhe alkere akertne anthurre-werne utyernetyenhe apeke? Arrangkwe! Kenhe Re akenhe arrenhantherrenhe ure atetherre-werne iwetyenhe-tetye. Arrekantherre arrekwelenge kwenhe the atningke-ngare ngangkerele mpwareke-arle, kele arrantherre areke-arle-iperrele akenhe akurne areye impetyakenhe, akngarte-iwelhetyakenhe. The apeke-arle arne areye ngangkerele mpwareke apmere Sodom-ele arrule anthurre, kele itne apeke-arle areke, akurne impemele akngarte-arle-iwelheme. Kele apmere itnekenhe kele akwete-arle tneme, kenhe arrangkwe-arle akenhe. ");
INSERT INTO aer_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Urreke, arlte ingkernenge, Ngkartele-arle tyerrtye areye inemele akngaketyenhe Re anteme itnenhe akayake-iletyakenhe imerte itnenhe yernemele Sodom-arenye itnenhe apmere ahelhe akurne-werne, ure alkngenthe-werne arrwengkelthe akngerre inetyeke itnenhene atwetyeke anthurre. Re arrenhantherrenhe akayake-iletyakenhe itnekenge yernemele, kele apmere yanhenge arrantherre rlkerte arntwarre-arle ineme arrantherre-arle ayenge arekenge atningke-ngare ngangkerele arne arunthe mpwarerlenge, kele arrantherre akenhe atyenge akangkwe-irretyakenhe akwete-arle aneke.” Alakenhe-arle itneke Jesus angkeke. ");
INSERT INTO aer_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Kele Jesus Akngeye ikwerenheke angkeke, “Akngeye-aye, unte kwenhe tyerrtye ingkirrekeke alartetye anthurre, apmere ahelhe nhenhele-arlke alkere akertnele-arlke. Kele the ngenhe utyernemele tnakeme, unte-arle angkentye mwerre nhenhe tyerrtye areyeke imernekenge nhenge ngkwenge akutne areyeke, unte akaltye areyeke imernetyakenhe aneke, unte-arle alengke-arle-iweke itne-ketyenge. ");
INSERT INTO aer_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yewe Akngeye-aye, unte alakenhe mpwareke unte-arle ahentye-anekenge warte.” ");
INSERT INTO aer_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Kele ikwerenge-ntyele, Jesus itneke angkeke, “Akngeye atyinhele ayenge ingkirreke anthurre antheke alartetye anetyeke. Ayenge-arle Alere Ikwerenhe. Re-ante ayenge itelareme anthurre. Kenhe ayenge-arle akenhe, Alerikwe-arle, the-ante Renhe itelareme anthurre. Kenhe yanhe areye the akngakeke-arle, tharle itneke Ngkarte Ikwere-akerte ileke, yanhe areye-arle atyenge-artweye-arle anemeke. Itne Ngkarte awerrirretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Kele Jesus itneke angkeke, “Yewe, angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyele-arle arrenhantherrenhe uterneke arne arrpe-anenhe mpwaretyeke, arrenhantherrenhe apurrkele-antheme. Kele nhenhe anteme awerrirraye, arrantherre apeke-arle apurrke anthurre awelhemele atyenge-werne apetyewarraye the arrenhantherrenhe ltyerretyeke arrernetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Yewe, atyenge-ngentyele akwete akaltye-irraye atyenge akangkwe-irremele ayenge angkerlenge, tharle arrenhantherrenhe mwantye-mwantye-ileme akangkemele. Kele the arrenhantherrenhe ltyerretyeke-arle arrerneme arrantherre akangkentye anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Angkentye atyinhe arrantherre awemele akangkwe-irremele, arrantherre akangkentye anthurre-arle aneme.” Alakenhe-arle Jesus itneke angkeke itne akwenpe anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Kele yanhe-ngentyele Jesus apmere arrpenhe-ngentyele alheke apententye akngerre ikwerenhe areye-akerte arlte apurrkele Saturday-enge. Itne merne ulpe mpwarentye akngerre-arle amangkeke-mpele alheke. Kele apententye akngerre ikwerenhe areye akenhe angayakwe irreke itne merne ulpe mpwarentye akngerre ntange areye akemele arlkwerlte-aperlenge alherle-apemele. ");
INSERT INTO aer_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Kenhe Pharisee arrpenhemele itnenhe merne ulpe mpwarentye akngerre ntange areye inerlenge areke imerte Jesus-eke angkemele, “Aye, nhenhe araye! Arlte apurrkele apententye akngerre ngkwinhe areyele kwenhe merne ulpe mpwarentye akngerre ntange areye akemele arlkweme. Itne urrkapemele kwenhe angkentye anwerne-kenhe ultakeme. Kenhe angkentye anwerne-kenhe alakenhe-arle, arlte apurrkenge urrkapetyale anetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","4","Kele Jesus itneke angkirtnerlenge, “Kele arrantherre-ame aretyakenhe pipe-nge David-arle angayakwe-irremele alheke ilthe ameke-ameke Ngkarte-kenhe-werne imerte merne impene-werne renhe arlkwemele imerte arrpenhe areye ikwerenge-arle aneke areye arlkwetyeke anthemele. Kele arratye-arle angkentye ileme kwertengerle tyatye-arenye areyele-ante merne renhe arlkwetyeke. Kele itne akenhe akangkwe-irretyakenhe-arle aneke imerte merne renhe arlkwemele itnenhe iltetyakenhe-arle aneke itne-arle angayakwe anekenge ware.” ");
INSERT INTO aer_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Jesus akwete angkeke, “Kele awethe, arrantherre-ame aretyakenhe pipe-nge angkentye Moses-kenhenge: Arlte apurrkele kwertengerle tyatye-arenye areye tyatye-ke akwetethe irrpenherlenge ikwerele urrkapetyeke. Nhenge Ngkartele itnenhe urrkaperlenge areme itneke ahele-irretyakenhe-arle, itne-arle urrkapewarrerlenge. Re akwenpele anerle-aneme. ");
INSERT INTO aer_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kele lyete the angkentye arrpenhe arrekantherre ileme. Ngkartele-arle ayenge yerneke angkentye atyeperre anthurre iletyeke, angkentye atyinhe atyeperre anthurre ulkere angkentye temple-nge ileme-akerte. ");
INSERT INTO aer_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Arrantherre itelaretyenhele nthakenhe-arle angkentye nhenhele ileme Ngkarte-arle arrule angkeke: “Kere atwetyale ayenge anthetyeke.” Nhenheke-ante-arle ayenge ahentye-aneme; arrantherre arrpenhe areyeke alhwarrpe-irremele alpe-eme-iletyeke. Nhenge The arerlenge arrantherre alakenhe mpwarerlenge, kele ayenge arnterre anthurre-arle akangketyenhe. “Arrantherre apeke renhe itelarerrirremele, kele arrantherre apententye akngerre atyinhe areyeke ahele-irretyale-arle, itnenhe ilemele itne-arle akwele akurne mpwarekeke. ");
INSERT INTO aer_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yewe, arrantherre itelaretyakenhe-arle ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, alartetye anthurre, the kwenhe iletyenhe nthakenhe-irretyeke arlte apurrkenge.” Alakenhe-arle Jesus angkeke Pharisee areyeke. ");
INSERT INTO aer_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yanhe-ngentyele anteme Jesus arrpenhe areyele-arlenge apmere ikwerenge-ntyele alheke imerte tyatye Jew areye-kenheke irrpemele. Arrernelheke-arle iperre itne kweneke irrpenherlte-iweke. ");
INSERT INTO aer_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Yanheke anteme Jesus-ele areke artwe iltye tharre-arle-irreke tyerrtye areyenge. Kele Pharisee areyele anemele arerlenge Jesus nhenge itne renhe iltetyenhenge re apeke ahele-irrelenge. Nhenge itne artwe iltye tharre renhe aremele alakenhe itirreke, “Re apeke-arle lyete renhe angkwerre-iwemele mwerre mpwaremele arlte apurrkele angkentye Moses-kenhe akurne-ilemele.” Kele itne anteme renhe apayuthneke, “Iwenhe-arteke-arle-ame angkentye Moses-kenhe? Mwerre-ame tyerrtye rlkerte areye mwerre-iletyeke arlte apurrkele, arrangkwe apeke?” ");
INSERT INTO aer_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Kele Jesus itneke angkirtnerlenge, “Nhenge yepe-yepe apeke iperteke atnyerlenge-artaye arlte apurrkele, arrantherre-ame renhe impeme urrekeke tyerretyakenhe imerte anemele? Arrangkwe, tyerremele-arle ingwelemeke impetyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Artwe akunye nhenhe akenhe yepe-yepenge impene anthurre-ulkere! Angkentye Moses-kenhenge-arle akenhe anwerne arrpenheke alhwarrpe-irretyeke alpe-eme-iletyeke arlte apurrkele-arlke.” ");
INSERT INTO aer_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesus anteme angkeke artweke iltye tharre-akerte, “Iltye aternelhaye!” Kele arratye re iltye antekelhe-ileke, iltye arratye mwerre-irreke iltye arrpenhe-arteke. ");
INSERT INTO aer_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Pharisee areyele nhenhe areke-arle iperre itne anteme alhemele angkerretyamele Jesus akwele irrerlknge atwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Kele Jesus-ele aweke itne-arle renhe irrerlknge atwetyeke angkerreke re anteme apmere renhe impemele alheke apmere arrpenhe-werne. Kenhe tyerrtye atningke anthurrele renhe apenteke, re anteme tyerrtye rlkerte areye anpemele angkwerre-iwemele mwerre mpwarerle-apeke. ");
INSERT INTO aer_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Re itnenhe ileke arrpenhe areyeke iletyaleke. ");
INSERT INTO aer_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Kele angkentye nhenhe Jesus-akerte rlkerte areye angkwerre-iweme, Ngkarte arrekwele angkeke-arle angkentye ilerle-apentye akngerre Isaiah arritnyeke. Isaiah-ele arrule anthurre pwekeke intelhe-ileke alakenhe: ");
INSERT INTO aer_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“The renhe akngakeke atyenge urrkapetyeke. Re impene anthurre atyinhe, ayenge-arle ikwere akangkentye anthurre-arle, the utnenge atyinhe ikwere-arleke arrerneme. Re anteme tyerrtye areye iletyenhe, Ngkartele-arle Jew anetyakenhe areye itelaremele arratye atnyenetyenhenge. ‘Ngkarte ahentye-aneme tyerrtye ingkirrekeke ikwerenhe irretyeke arratye anemele.’ Alakenhe-arle re iletyenhe. ");
INSERT INTO aer_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Re anteme nterte anetyenhe, tyerrtye areyeke ahele-irrerle-apetyakenhe, iwerre arrpenhenge itwele tnemele arlkerle-apetyakenhe arrpenhele renhe awetyeke. ");
INSERT INTO aer_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Nhenge re tyerrtye akunye areye ilwetyeke-irrerlenge aremele, re itnenhe impetyeke arrangkwe-arle, kele alhwarrpe-irremele itnenhe itethe-ilemele akemelhe-ilirtneme-arle. Arrantherre itelareme, nhenge artwele ure akweke amperle-anerlenge areme, re mwantyele pewe-ileme akngerre irretyeke-atwetye, alakenhe-arle re tyerrtye areye itethe atnyeneme. Re apurrke-irretyakenhe-arle aneme mpwepenge apeke ingkirreke arratye-ileke-ante-arle iperre, re imerte ltyerremele anteme-arle. ");
INSERT INTO aer_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tyerrtye ingkirreke apmere arrpe-anenhe-arenye areye ikwere akarelhemele arelheke re itnenhe apetyemele itetheke mpwaretyeke.” Alakenhe-arle Ngkarte arrule angkeke, kele arratye anteme alakenhe-irreke. ");
INSERT INTO aer_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Tyerrtye arrpenhe areyele artwe rlkerte Jesus-werne akngetyeke. Artwe re akenhe pwenge-arle aneke angketye-arlke-akenhe arrentye-arle ikwerele-arlenge anerlenge. Kele Jesus-ele artwe renhe angkwerre-iweke, alknge alkngampe-ileke arratye aretyeke artwe angketyeke-irreme anteme. ");
INSERT INTO aer_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Kele tyerrtye areyele areke apatemele anthurre imerte alakenhe angkerremele, “Artwe nhenhe David-eke-artweye apeke Ngkartele-arle alhileke.” ");
INSERT INTO aer_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Kele nhenge Pharisee areyele nthakenhe-irrekenge awemele itne arrpenhe areyeke ileke, “Arrangkwe, arrentye nhenge Beelzebul-ele ngangkere ikwerenhe renhe antheke, arrantherre itelareme re arrentye arrpenhe areyeke akngerrepate nhenge, alakenhenge akwele re arrentye ayweperle-anetyeke tyerrtye areye-ngentyele.” ");
INSERT INTO aer_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesus-ele kele itelareke nthakenhe-arle itne ikwere-akerte itirreke re anteme alakenhe angkeke, “Nhenhe awerrirraye! Tyerrtye apmere anyente-arenye areye apeke atwerrentye akngerre itne akenhe akweteke-ilemele atwerreme, tyerrtye areyeke arrangkwe anetyeke-atwetye. Alakenhe anteye artweye-nhenge areye apeke warle anyente-arenye areye atwerrerlte-aneme imerte akweteke-ilemele atwerreme, tyerrtye areyeke arrangkwe anetyeke-atwetye. ");
INSERT INTO aer_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Alakenhe-ante-arle Arrentyeke, re apeke arrentye ikwere akwerrke areye tyerrtye areye-ngentyele aywepetyeke aneke kele itne ikwere ahentye-anetyakenhe-arle aneme ikwere anetyakenhe. Kele re itnenhe uyarne uterneme, alyepe-alyepe-irremere alartetye itnekenhe anetyakenhe anteme. ");
INSERT INTO aer_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kenhe arrantherre akenhe angkeme arrentye Beelzebul arritnyele-arle akwele ngangkere ayenge antheme arrentye areye ayweperle-anetyeke tyerrtye areye-ngentyele. The apeke-arle arrentye aywepeme ngangkere ikwerenhele, angwenhele-arle akenhe arrenhantherrenhe ngangkere antheke arrentye aywepetyeke? Arrentye Satan-eleye? Arrangkwe, Ngkartele-arle itnenhe ngangkere anthekenge arrentye areye aywepetyeke. Arrantherre apale angkeme Beelzebul-ele akwele ayenge ngangkere ikwerenhe anthemenge arrentye areye aywepetyeke. ");
INSERT INTO aer_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Kenhe Utnenge Ngkarte-kenhe re apele ayenge ngangkere-arle antheme the arrentye areye aywepetyeke. Arrantherre ayenge areke-arle iperrele arrentye ayweperlenge itelaretyenhe Ngkarte-arle apetyeke arrenhantherrenhe apurtelhe-iletyeke arrekantherre Alartetye anetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Kele Jesus-ele angkentye arrpenhe anteme itneke ileke itnenhe akaltyele-anthemele alakenhe, “Artwe-ame apmere lterrke akngerre-kenhe-werne arne areye akwenpele anyelkngele inetyeke? Arrangkwe-arle. Re artwe lterrke-urrke ayernetyekeke-amparre kele imerte re arne itnenhe anteme inetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Jesus awethe angkeke, “Tyerrtye apeke atyengenge apurte urrkapetyakenhe, re arrentye Satan-kenhe-arle, atyenge ahele-irremele. Re apeke tyerrtye areye Ngkarte-werne akngetye-alpetyakenhe, kele re itnenhe aterele-anthemele atyenge-ketyenge aywepemele. ");
INSERT INTO aer_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kele nhenhe-arle itelarerrirraye, arrantherre apeke-arle apure anerlte-aneme akurne atningke mpwarekenge, Ngkartele arrenhantherrenhe ilpernetyakenhe aneme. Arrantherre apeke-arle apure-irreme arrantherre-arle Renhe arrkentye-ilekenge, kele Re arrenhantherrenhe ilpernetyakenhe aneme-arle. Kenhe arrantherre akenhe arrkentye-ilemele Utnenge Akngerreke, Re arrekantherrenge ipeltye-irretyakenhe, arrenhantherrenhe ilwetyeke-arle arrerneme. ");
INSERT INTO aer_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Yewe, angwenhe apeke atyenge-akerte akurnentye angkeme, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, kele Ngkartele tyerrtye renhe ilpernetyakenhe aneme-arle. Kenhe arrantherre akenhe arrkentye-ilemele Utnenge Akngerreke, ikwerenge ipeltye-irretyakenhe arrekantherrenge, re arrenhantherrenhe ilwetyeke-arle arrerneme, renhe ilwetyeke-arle ngkerneme arlte ingkerneke-atwetye.” ");
INSERT INTO aer_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jesus Pharisee itneke akwete angkeke, “The angkentye merne ntange-akerte ileme. Arne mwerre-ngentyele merne mwerre-arle lyapeme, kenhe arne akurne akenhe merne akurne-arle lyapeme. ");
INSERT INTO aer_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Arrantherre untherlte-aneme, arrpenhe areyeke urrtyirremele. Kele arrantherre-arle akurnentye anemenge, kele arrantherre angkentye mwerre uyarne angkeme. Kenhe tyerrtye mwerrantye itirrentye akngerre-arle angkentye mwerre akngetyeke. ");
INSERT INTO aer_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Tyerrtye mwerrantye angkeme rarle itirrentye mwerre-akerte, arne akurnele merne akurne lyapelhe-ileme-arteke, tyerrtye akurnentye angkeme rarle itirrentye akurne-akerte-arle. ");
INSERT INTO aer_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Alakenhenge anteme akwete itirretyeke, urreke arlte ingkernenge Ngkartele akalkelhe-iletyenhe tyerrtye ingkirreke, itneke anyenteke-anyente Re akaltye alakenhe angketyenhe, ‘Iwenhenge-arle-ame unte mwerrantye itirretyakenhe, apale angkemele ahelhe nhenhele anetyarte?’ ");
INSERT INTO aer_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Yewe, arlte ikwerele Re arrenhantherrenhe akngaketyenhe nthakenhe-arle arrantherre angkekenge. Kele mwerrantye apeke-arle arrantherre angkekenge re mwerrantye arrekantherre anetyenhe arratye. Kenhe akurnentye apeke-arle arrantherre angkeke re arrenhantherrenhe akurne akwete aketyenhe re arrenhantherrenhe apmere akurne ikwere-werne yernetyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Kele Pharisee areye uthene angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye Jesus-eke alakenhe angkeke, “Akaltyele-anthenhe-anthenhe-aye! Kele unte apeke-arle ngangkere ngkwinhele mpwaremele-artaye anwerne aretyenhenge kele anwerne anteme itelareme Ngkartele-arle ngenhe yerneke.” ");
INSERT INTO aer_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Kele Jesus akenhe ayenelhe-ileke itneke alakenhe-arle angkemele, “Kele arratye-arle arrantherre akurne areye Ngkarteke akangkwe-irretyakenhe-arle. Arrantherre ayenge akwete apayuthneme ngangkerele mpwaretyeke, ayenge areke-arle iperrenge arrantherre akwele ayenge arratye itelaretyenhenge. Kele arrangkwe, Ngkartele iwenhe apeke renhe ngangkerele mpwaretyakenhe arrantherre-arle aretyenhenge ware akwele. Urreke-arle arrantherre aretyenhe arne nhenge-arle Jonah-eke nthakenhe-irrekenge, arrantherre anteme itelaremele-arle. Jonah re angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre anetyarte. ");
INSERT INTO aer_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Re kere kwatye-arenye akngerre-apenhe atnerte kwenele anetyarte arlte urrpetyeke-atwetye, ingwe urrpetyeke-atwetye-arlke. Alakenhe-arteke-arle Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, ahelhe kwenele anerle-anetyenhe arlte urrpetyeke ingwe urrpetyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Kenhe the akenhe arrekantherre awethe iletyeke ahentye-aneme artwe nhenge Jonah angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre-akerte. Arrule anthurrenge re, apmere Nineveh-arenye areyele awerrirrerlenge Jonah-ele itneke angkentye Ngkarte-kenhe ileke. Re itneke Ngkarte-akerte iletyarte. Kele re itneke ileke-arle iperre, itne arne akurne ingkirreke anthurre itnenhe imperlte-alheke itne-arle mpwarewarretyarte Ngkarte Ikwere-werne itne utepe-irrintyete-alpeke. Kenhe urreke re anteme, arlte ingkernenge, Ngkarte tyerrtye ingkirrekeke itirretyenhe nthakenhe itnenhe mpwaretyeke. Kenhe apmere Nineveh-arenye areye tnerrirremele angkerrirreme arrantherre kwenhe mwerre anerrirretyakenhe anteye-arle. Alakenhenge angkentye atyinhe akenhe angkentye Jonah ikwerenhenge akngerre-ulkere-arle. Itne angkentye ikwerenhe awerrirreke, kenhe arrantherre akenhe angkentye atyinhe awerrirretyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“The arrekantherre angkentye arrpenhe iletyenhe: Arrule anthurre arelhe alartetye Sheba-arenye, apmere arlenge anthurre-ngentyele apetyeke artwe akaltye anthurre Solomon awetyeke. Kenhe lyete nhenhe akenhe angkentye atyinhe angkentye Solomon ikwerenhenge akngerre-ulkere-arle, kenhe arrantherre angkentye atyinhe awerrirretyakenhe. Kele arlte ingkernenge, Ngkarte tyerrtye ingkirreke anthurreke itirretyenhe nthakenhe itneke mpwaretyeke. Kenhe arelhe nhenge re akenhe tnemele angkeme arrantherre kwenhe mwerre anetyakenhe arrantherre-arle angkentye atyinhe awerrirretyakenhenge-arle.” ");
INSERT INTO aer_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Jesus-ele itneke awethe ileke, “Nhenge arrentye tyerrtye ikwerenge-ntyele arratemele, re apmere ingkinyele-arteke anteme anemenge, tyerrtye arrpenhe anetyakenhe anteme, arrangkwe anthurre. Kenhe arrentye-arle apmere kwatye-kwenyele-arlke ahurratye untherle-apemele, apmere mwerreke arerle-apemele anetyeke. Kenhe re apeke apmere mwerreke uyarne aremele anetyeke, ");
INSERT INTO aer_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","re ilelhemele alhepalheme, ‘Ayenge-arle tyerrtye nhenge-werne alpetyeke itirreme ikwerele-arlenge arrekwele ayenge-arle aneke-werne. Kenhe arrpenheke arrangkwe rarle re lyete aneme.’ Arratye rarle, arrentye tyerrtye nhenge-werne alpemele renhe aretye-alpeke apmere alkarle-arteke renhe ingkirreke-arle akngarte-iwerlenge. ");
INSERT INTO aer_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Re anteme alpemele arrentye 7-pele arrpenhele-arlenge, ikwerenge akurne anthurre ulkere-arle. Kele itne tyerrtye yanheke irrpirtnewarremele atneme ikwerele-arlenge apmere mpwaremele. Kenhe yanhe ikwerenge-ntyele, tyerrtye arrentye areye-akerte re akurne awethe-arle re anekenge-ntyele anpere anthurre anteme aneme. Alakenhe-irretyenhe tyerrtye akurne areyeke angkentye atyinhe aweke-arle iperre.” Alakenhe-arle Jesus-ele itnenhe akaltyele-antheke. ");
INSERT INTO aer_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Nhenge Jesus apmere kwenele anetyamele atningkeke angkemele, mikwe-arlke atyeyikwe areye-arlke renhe arerrirretyeke apetyewarreke. Kele itne akethele tnetyetalhemele arrpenhe itneke angketyete-alheke, “Anwerne Jesus-eke angkerrirretyeke.” ");
INSERT INTO aer_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kele anyentele ware Jesus-eke iletyeke alheke, “Jesus-aye, mangkwe-arlke atyeyangkwe areye-arlke akethele yanhe tnetyetalheme. Itne ngkwenge angkerrirretyeke ahentye-anerrirreme.” ");
INSERT INTO aer_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Kenhe Jesus re ikwere angkirtneke, “The ngkwenge meye atyinhe uthene atyeye atyinhe areye uthene-akerte ileme. Unte-ame itelareme angwenhe apeke tyerrtye areye the akeme meye atyinhe uthene atyeye atyinhe uthene?” ");
INSERT INTO aer_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ikwere iperrele Jesus apententye akngerre ikwerenhe areye thilemele angkeke, “Nhenhe-arle meye atyinhe atyeye atyinhe areye-arlke! ");
INSERT INTO aer_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Angwenhe apeke Akngeye alkere akertne-arenyeke akangkwe-irremele, Ikwere aywerrke arne mwerre areye mpwareme, itne atyeye atyinhe uthene meye atyinhe uthene-arle aneme.” ");
INSERT INTO aer_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Arlte yanhe ikwerele, Jesus anteme apmere ikwerenge arratemele alhemele kwatye alaye Galilee iterele aneke. ");
INSERT INTO aer_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tyerrtye atningke anthurre anteme renhe awetyeke apetyewarreke re akaltyele-antherlenge. Re akeme-irremele boat-eke antyemele itneke angketyame. Kenhe tyerrtye areye akenhe kwatye iterele tnerrirrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Re itnenhe angkentye alengkiwentye akngerre atningke alakenhe akaltyele-anthetyame: “Awerrirraye. Artwe arrpenhe nhengele ntange areye iwerle-apeke ahelhe rarle atyerte-ilekeke. ");
INSERT INTO aer_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ntange areye iwemele, ntange arrpenhe areye akenhe iwerreke-arle atnyerlenge. Kenhe thipele anteme apetyemele itnenhe arlkweke. ");
INSERT INTO aer_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Kenhe ntange arrpenhe areye akenhe ahelhe apwerte-apwerteke-arle atnyerlenge. Kenhe atherrke anteme iparrpe anthurre lyapeke iwenhe-akweyenge ahelhe akweke-arle yanhe anekenge. ");
INSERT INTO aer_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Nhenge uterne arratemele arne itnenhe ampeke antyerrke-ilemele itne-arle artekerre ntarneke ware arrernerlenge. ");
INSERT INTO aer_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Kenhe ntange arrpenhe areye akenhe atnyeke lyeke akngerre-arle lyapetyartenge. Lyeke akngerre lyapemele arrpenhe itnenhe ayelpayernemele akurne-ileke. Merne ntange lyapetyakenhe aneke. ");
INSERT INTO aer_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Kenhe ntange arrpenhe areye akenhe ahelhe mwerreke atnyeke. Arne nhenhe areye lyapeke akngerre anthurre. Arrpenhemele merne akweke ware atnyeneke, arrpenhemele akngerre awerne atnyeneke, arrpenhe areyele akenhe akngerre anthurre-arle atnyeneke. Ayeye alakenhe-arle aneke.” ");
INSERT INTO aer_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Jesus itneke angkeke, “Yewe, angkentye nhenhe awerrirraye, arrantherre ingkirreke akwetethe itirreme nhenge itelarerrirretyeke.” ");
INSERT INTO aer_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Kele apententye akngerre Jesus-kenhe areye apetyemele renhe alakenhe apayuthneke, “Iwenhenge-arle-ame unte tyerrtye areyeke angkentye alengke-iwelhentye areye alakenhe ilerle-apeme, arratye-arratye iletyakenhe?” ");
INSERT INTO aer_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Re anteme itneke angkirtneke, “Ngkarte angketyenhe arrekantherre imernemele angkentye-arle artemeke, arrantherre anteme itelarerrirretyeke, kenhe arrpenhe areyele itelarerrirretyakenhe. Angkentye nhenge arrekantherre alartetye anetyenhenge-akerte. Arrpenhemele nhenge akwetethe awemele angkentye nhenhe-ante ware nhenge angkentye akngerre anthurre, re itneke imernetyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Angwenhele apeke Ngkarte-akerteke akweke ware itelaremele, re apeke awethe itelaretyeke, Ngkartele ikwere awethe imernetyenhe-arle. Kenhe angwenhe apeke akenhe Ngkarteke akangkwe-irretyakenhe iwenhe apeke-arle itne Ikwere-akerte aweke-arle, kele Ngkartele itnekenge repe-akemele iwenhe apeke renhe itne atnyenerlenge, itne Ikwere-akerte alkngwirretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Jesus itneke angkeke, “Tharle angkentye ileme tyerrtye areyeke, arratye-arratye-iletyakenhe iwenhe renhe tharle itneke ileme, kele-arle itne areme-itanye nthakenhe-arle the mpwareme, kele itne akenhe itelaretyakenhe-arle nthakenhe-arle the ileme. Kele itne akwetethe awerlte-anemele itne akenhe uyarne itelarerrirreme. ");
INSERT INTO aer_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Arrule anthurre angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Isaiah-ele itneke-akerte alakenhe intelhe-ileke, ‘Arrantherre iwenhe apeke renhe akwete awerlte-aneme ayenge angkerlenge, kenhe arrantherre uyarne itelarerrirreme. Awethe ante, arrantherre akwetethe arerlte-anemele iwenhe apeke renhe the mpwarerlenge, kenhe arrantherre uyarne itelarerrirreme. ");
INSERT INTO aer_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ayenge alakenhe angkerne tyerrtye nhenhe areye-arle akenhe akaperte martelhekenge itne anteme akaltye-arlke-irretyakenhe anteme. Kele-arle itne irlpe-akerte-itanye, itne-arle atyenge ahentye-anetyakenhe akangkwe-irretyeke nthakenhe-arle ayenge angkemeke. Itne apeke-arle alknge apeke-arle martelheke-arteke itne-arle akangkwe-irretye-kwenye-arle iwenhe-arle arratye anemeke. Itne apeke-arle arratye awemele, itne anteme arratye akangkwe-irremere warte, itne-arle alkngele arekenge, irlpele-arlke awemele. Kele itne apeke arratye itelarentyele akangkwe-irremele-arlke angkentye tharle ileke areyeke. Alakenhe-arle mpwarekenge itne untyeme-irremele arne akurne itne-arle mpwaretyarte-ketye itne atyenge-werne apetye-apeke-alpetyenhenge. Kele yanhe-ngentyele the itnenhe mwerre-ileme. Kenhe itne akenhe alakenhe mpwaretyeke ahentye-anetyakenhe-arle.’ Alakenhe-arle Isaiah-ele intelhe-ileke.” ");
INSERT INTO aer_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Jesus alakenhe anteme angkeke apententye akngerre ikwerenhe areyeke, “Arrantherre akenhe ayenge alkngele areme, atyenge irlpele akangkwe-irremele. Alakenhe ikwerenge anteme arrantherre akangkentye anthurre. ");
INSERT INTO aer_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Kenhe the akenhe arrekantherre arratye-arle ileme: Arrule anthurre tyerrtye areye angkentye Ngkarte-kenhe-arle awemele ilerle-apetyarte, arrpenhe areye-arlke Ngkarteke-arle arratyentye anerrirretyarte, itne kwenhe ahentye-anetyarte aretyeke iwenhe-arle arrantherre areme. Kele itne akenhe uyerreke-arle, aretyakenhe akwete. Itne akwele awetyeke-arlke ahentye-aneke arrantherre-arteke, itne akenhe awetyakenhe akwete-arle uyerreke.” ");
INSERT INTO aer_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Kele Jesus itneke angkeke, “Awerrirraye, tharle arrekantherre ileme angkentye merne ntange-akerte. ");
INSERT INTO aer_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Tyerrtye arrpenheme areye ntange iwerreke-arle atnyeke-arteke. Itne angkentye Ngkarte-akerte awerrirreme rarle alartetye anetyenhe-akerte, kele itne akenhe itelaretyakenhe-arle. Kele arrentye-arle apetyemele itnenhene alkngwe-iletyeke. ");
INSERT INTO aer_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Tyerrtye arrpenheme akenhe ntange ahelhe apwerte-apwerteke-arle atnyeke-arteke-arle. Itne angkentye renhe awemele iparrpele arnterre anthurre-arle akangkeme. ");
INSERT INTO aer_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Kenhe itne angkentye renhe awerrirreme. Kenhe ikwerenge-ntyele apeke itneke akurne akngerre-irrerirretyenhe, arrpenhe apeke itneke ahentye-anetyakenhe itne-arle angkentye Ngkarte-kenheke akangkwe-irrerlenge, kenhe itne akenhe Ngkarte ikwere iparrpe alkngwirrewarrerlenge, ikwere-ketye untyeme-irrerirremele. ");
INSERT INTO aer_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Tyerrtye arrpenheme areye ntange-arteke nhenge ahelhe lyeke akngerre-akerteke-arle atnyeke. Angkentye yanhe renhe awemele akangkwe-irremele akweke ware. Kenhe itne imerte itirrewarremele arne iwenhe-iwenhe apeke ahelhe nhenhe-arenyeke. Kele yanhe areyele itne angkentye Ngkarte-kenhe renhe awerrirremele, kenhe itne akenhe angkentye renhe lterrke atnyenewarretyakenhe-arle, arrpenhe itnenhe akaltyele-anthetyakenhe Ngkarte-akerte. ");
INSERT INTO aer_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Kenhe tyerrtye arrpenheme yanhe areye itne ahelhe ulpmerre yanhe areye-arteke, itne yanhe areye apele angkentye Ngkarte-kenhe renhe awerrirremele, arratye rarle itne awemele renhe arratye itelarerrirremele anerrirreke. Kenhe yanhe iperrele itne anteme tyerrtye arrpenhe areye anteme Ngkarte-akerte akaltyele-antherrirreme. Arrpenhemele akweke ware mpwareme. Arrpenhemele akenhe akngerre-ulkere-arle mpwarerlenge. Arrpenhe areyele akenhe akngerre anthurre-arle mpwarerlenge. Tyerrtye atningke anthurre Ngkarteke akangkwe-irretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe itneke ileke, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Artwe anyente, garden arntarnte-arentye akngerre, ntange mwerre areye iweke ahelhe rarle atyerte-ilekeke. ");
INSERT INTO aer_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kele ingwele artwe rarle ankwe intekenge urrkapentye akngerre ikwerenhe areye-arlke, artwe anyente apetyeke, re apmereke-artweyeke ahentye-anetyakenhe, re ahelhe ikwere-werne alheke imerte anyelknge-anyelkngele annge akurne areye irrarnpelhe-ilemele iwemele. Re anteme ikwere-iperre alheke. ");
INSERT INTO aer_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ikwere iperre merne ntange akngerre amangkeke ntange areye-akerte, annge akurne itne-arlke lyapeke itnekenge imerte akngerre anthurre lyapemele. ");
INSERT INTO aer_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nhenge urrkapentye akngerre areyele aremele itne alartetye itne-kenheke alakenhe angkeke, ‘Alartetye-aye! Nthenhe-ngentyele-ame arne akurne nhenhe areye lyapeke? Unte itelareme, unte kwenhe ntange mwerre areye-ante-arle ngkerneke.’ ");
INSERT INTO aer_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Re akenhe angkirtnerlenge, ‘Arrangkwe, tharle annge akurne ngkernetyakenhe-arle, artwe atyenge ahentye-anetyakenhenge apeke anyelknge-anyelkngele apetyemele annge akurne areye iweke.’ “Itne anteme renhe apayuthneke, ‘Anwerne-ame itnenhe tyerremele iweme?’ ");
INSERT INTO aer_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Re angkirtnerlenge, ‘Kele impaye! Arne akurne areye tyerretyale arne mwerre-arlke anteme tyerreme-ketyenge-arlke. ");
INSERT INTO aer_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Apurte lyapetyeke impaye, kele ikwerenge-ntyele, ntange itne mpenge anteme irremele. The anteme ileme ntange inemele akentye akngerre areye uthnemele arrekwele akurne areye apurtelhe-iletyeke inemele urele itetyeke. Ntange mwerre arrpenhe areye imerte arrernemele apmereke merne ntangeke.’ Alakenhe-arle anetyenhe arlte ingkerne nhakwenge.” Alakenhe-arle Jesus-ele itneke ileke. ");
INSERT INTO aer_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe itneke ileke, alakenhe, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe. Artwe garden arntarnte-arentye akngerrele annge mustard anyente inemele ahelheke ngkernemele renhe arteke. ");
INSERT INTO aer_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Annge re akenhe akweke anthurre-arle, arrpenhe ingkirrekenge akweke-ulkere. Kele amangkemele akenhe ulye akngerre anthurre anentye akngerre-arle, arne arrpenhe areyenge akngerre-ulkere. Arne ikwerenge akenhe thipe areye apetyemele untye itnekenhe mpwaremele aneme.” Alakenhe-arle Jesus-ele itneke ileke. ");
INSERT INTO aer_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe itneke ileke, alakenhe, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe. Nhenge arelhe anyentele merne arlware-ilentye akngerre akweke arrerneme ulpmerre akngerreke-arleke anyentelhe-ilemele itetyeke. Kele nhenge re anteme arlware-ilentye akngerre akwekele merne renhe arlware-ileme.” ");
INSERT INTO aer_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yewe, Jesus-ele tyerrtye areyeke angkentye alengke-iwentye alakenhe ilemele, itnenhe akngarte-iweke. Rarle angkentye arrpenhe-arteke iletyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Re alakenhe angkemele, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre anyentele arrule anthurre ileke, arratye-arle aneke. Angkentye alakenhe: “The angkentye alengke-arle-iweke areye-arlke ileme arne atningke-akerte. The itneke angkentye arrpenhe artemele angkeme, Ngkartele-arle angkentye nhenhe areye alengke-iweke nhenge rarle ahelhe uthene alkere uthene mpwarekenge. Alakenhe akwete rarle the ilerle-anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Kele Jesus-ele areye impemele alheke imerte apmere kwene-werne irrpenhemele. Kele apententye akngerre ikwerenhe areye apetyemele ikwere alakenhe angkeke, “Anwerneke angkaye, angkentye arne akurne areye-akerte arratye-ilemele.” ");
INSERT INTO aer_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Kele Jesus angkeke, “Ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, annge mwerre-arle iweke re-arteke-arle. ");
INSERT INTO aer_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Apmere ahelhe anteke akenhe ahelhe-arle atyerte-ileme-arteke-arle. Kele tyerrtye Ngkarte-arle alartetye irremele atnyeneke akenhe annge mwerre areye-arteke-arle. Kele tyerrtye Satan-ele-arle atnyeneme areye akenhe annge akurne areye-arle arrentye-kenhe areye-arteke. ");
INSERT INTO aer_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","40","Artwe-arle apmereke-artweye ikwere ahentye-anetyakenhe aneke nhenge annge akurne-arle ngkerneke, re akenhe arrentye-arteke-arle. Kele annge mpenge areye-arle kutyeke areye akenhe, utnenge alkere-arenye areye-arteke-arle. Arrantherre itelareme, urreke ahelhe uthene alkere uthene uyerrerlenge kele itne tyerrtye arrentye Satan-kenhe areye-arle apurtelhe-ileme, nhenge areye arne akurne-arteke imerte ureke iwemele. ");
INSERT INTO aer_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Urreke, arrantherre itelareme the, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, utnenge alkere-arenye atyinhe areye yernetyenhe, itne anteme tyerrtye arne akurne areye mpwarentye akngerre areye apurtelhe-iletyeke alheme, tyerrtye nhenge areye-arlke arrpenhe areye-arle uterneme akurne mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Itne itnenhe apurtelhe-ilekarle-iperre ure akngerreke iweme amperle-arle-anemeke, itne anteme akwetethe artnerlte-anetyenhe rlkerte akngerre-akerte, uyarne itirremele. ");
INSERT INTO aer_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kenhe Ngkartele kele tyerrtye ikwerenhe areye apmere mwerre akngerrele-arle atnyeneme, itne anteme pwarrtyetyenhe uterne-arteke. Ye, arrantherre apeke akaltye-irretyeke ahentye-aneme, mwantyele anteme awe nthakenhe-arle ayenge arrekantherre angkeme.” ");
INSERT INTO aer_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe itneke ileke, alakenhe, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe. Arne mwerre akngerre arrpenhe areye mane akngerreke ipertele artelherlte-aneme ahelhe kwenele. Artwe arrpenhe akutne-arle anekele apetyemele tnyemele renhe areke, areke-arle iperre anteme re akangkeke imerte ahelhele artirtnemele alpemele arne ingkirreke anthurre ikwerenhe areye maneke antheke. Kele mane atningke-akertele anteme re alpemele ahelhe renhe pay-eme-ileke arne mwerre nhenge areye-akerte arrpenhele-arle arteke.” ");
INSERT INTO aer_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe ileke, alakenhe, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Artwe apwerte impene inenhe-inenhe apmere arrpe-anenhe-werne alherle-aneme apwerte mwerre akngerre anthurreke aremele pay-eme-iletyeke. ");
INSERT INTO aer_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Re anteme apwerte impene anthurre areke arrpenhe areyenge mwerre akngerre-ulkere artwe arrpenheke-arleke. Re alpemele arne ingkirreke anthurre ikwerenhe areye maneke antheke, mane ikwerele anteme re apwerte impene renhe pay-eme-ileke.” ");
INSERT INTO aer_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Jesus-ele anteme angkentye alengke-iwelhentye arrpenhe itneke ileke, alakenhe “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Arrantherre itelareme, artwe areyele net iweme kwatye iperte akngerreke kere kwatye-arenye arrpe-anenhe inetyeke. ");
INSERT INTO aer_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Kele itne tyarre-inemele kwatye alayenge-ntyele kele imerte kwatye iterele anemele akngakerle-anemele mwerre areye imerte tyampite-ke arrernemele imerte akurne areye iwemele. ");
INSERT INTO aer_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Alakenhe-arle anetyenhe urreke nhenge ahelhe uthene alkere uthene uyerrerlenge. Yanhenge anteme utnenge alkere-arenye areye alhetyenhe akurne areye uthene mwerre areye apurte anerlte-anerlenge. Itne imerte tyerrtye akurne mpwarentye akngerre areye anyentelhe-ilemele, ");
INSERT INTO aer_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","itnenhe imerte ure akngerreke iwemele, itne anteme yanhele akwete-ante anerlte-aneme rlkerte-akerte artnerlte-anemele, uyarne itirremele.” ");
INSERT INTO aer_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus-ele anteme apententye akngerre ikwerenhe areye apayuthneke, “Arrantherre apeke angkentye nhenhe areye arratye itelarerrirreme?” Itne anteme angkirtneke, “Yewe, anwerne-arle itele-arle-areme.” ");
INSERT INTO aer_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Re anteme angkeke, “Yewe, arrantherre arratye-arle akaltye-irreke angkentye Ngkarte-kenheke, nhenge Rarle alartetye irremele tyerrtye itnenhe arntarnte-areme-akerte. Arrantherre angkentye atherreke akaltye, angkentye lyetenyeke uthene arrulenyeke uthene, arrantherre itelareme angkentye atherre nhenge tharle arrekantherre ileke, nhenge Ngkartele Moses-eke-arlke-arle ileke. Arrantherre itelareme artwe anyentele arne mwerre areye atnyenentye akngerre arne box kwenele apmere ikwerenhele arne angkweye uthene lyetenye-arlke apurte. Re akenhe ahentye arne angkweye uthene lyetenye utheneke-arlke. Alakenhenge anteme arrantherre atyengenge akaltye-irreke angkentye atherre atnyenetyeke, atherre anteye lyetenye uthene arrulenye uthene.” ");
INSERT INTO aer_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","54","Jesus-elarle angkentye nhenhe areye ileke-iperre re apmere ikwerenge-ntyele alheke apmere ikwerenhe Nazareth-werne. Apmere ikwere irremele re tyatye Jew areye-kenheke irrpenheke imerte itneke angkentye angkemele akaltyele-anthemele. Itne renhe awemele apatewarremele angkerreke, “Aye! Angwenhele-ame renhe akaltyele-antheke angkentye ilernpenyele angketyeke? Nthakenhe-ame re ngangkere akngerre-akertele arne arrpenheke-arrpenhe mpwarerle-apeme? ");
INSERT INTO aer_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Re alere-arle artwe apmere artentye akngerre nhenge-kenhe, meye ikwerenhe akenhe Mary-arle, kele ikwere atyeye areye akenhe James, Joseph, Simon, Judas uthene nhenhele aneme. ");
INSERT INTO aer_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ikwerenhe marle atyeye areye-arlke-arle nhenhele aneme. Kele, nthakenhe anteme re alakenhe ilyenpenye-irreke?” ");
INSERT INTO aer_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Itne-arle itirrewarretyakenhe-arle aneke rarle arne iwenhe apeke renhe ngangkerele mpwaretyeke, itne anteme ikwere awelhetyakenhe aneke. Kele Jesus, nhenhe awemele, angkeke, “Tyerrtye apmere arrpenhe-arenye areyele-arle akwetethe-arle tnakewarreme tyerrtye areye angkentye Ngkarte-kenhe-arle awemele ilerle-apetyameke. Kele apmere ikwerenhe-arenye areyele-arlke akenhe ikwere akangkwe-irretye-kwenye-arle renhe tnakewarretyakenhe re angkerlenge itne renhe awetyakenhe-arle aneme.” ");
INSERT INTO aer_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Kele apmere yanhe ikwerele Jesus-ele ngangkerele mpwaretyakenhe aneke tyerrtye atningkeke, itne-arle itirrewarrekenge rarle uyarne mpwaremeke-athene, kele re urrpetye-arrpe ware-arle angkwerre-iweke. ");
INSERT INTO aer_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Arrule-arle Herod-ele arelhe atyeyikwe-kenhe ineke-arle renhe anewe akeke. Arelhe Herodias arritnye aneke. John-ele arnterre iletyame Herod renhe alakenhe, “Unte apale-apale mpwareme renhe anewe akemele.” Alakenhenge anteme Herod-ele, thultye ikwerenhe areye yerneke arntwirrketyeke John, renhe ayernemele jail-ke akwernetyenhe. Arratye itne arntwirrkeke renhe jail-ke akwernemele. ");
INSERT INTO aer_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Alakenhe ikwerenge anteme re ingkwe John irrerlknge atwetyeke aneke, Herod re kwenhe atere aneke tyerrtye areye-ketye. Itne itirreke John-arle artwe nhenge angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre-arle. ");
INSERT INTO aer_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Kele, urreke-ulkere-nge anteme, tyerrtye atningke apurte-irreke nhenge itne merne arunthe arlkwetyenhenge Herod ikwerenge akangketyeke. Alakenhe re itne mpwarerlenge, marle wenke Herodias-kenhe apetyetyame unterle-apemele nhenge itne renhe arerrirretyenhenge. Herod akangkeke anthurre marle anthepe-irrerlenge aremele. ");
INSERT INTO aer_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kele, Herod marleke angkeke, “Iwenhe ikwere-ame atnerte ngkwinhe ahentye anthurre aneme? Iwenhe ikwere apeke-arle unte itirreme, the ngenhe arne ingkirreke antheme nhenge unte-arle ahentye-anemeke. Ngkartele itelareme ayenge-arle ngkwenge arratye ilelhemeke.” ");
INSERT INTO aer_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Kele imerte re meye ikwerenhe Herodias-werne alhemele renhe apayuthneke, “Meye, Alartetye yanhele kwenhe ayenge ileke nhenge the akwele yanhe renhe apayuthnetyeke arne iwenhe apeke ikwere, yanhe ikwerenge-ntyele anteme re ayenge antheme. Iwenheke-ame the renhe apayuthneye?” Meye ikwerenhe akenhe angkirtnerlenge, “Alakenhe ikwere angkaye, ‘Akaperte John Baptist-kenhe ultakaye imerte akngetye-alpemele atyenge imernetyeke!’” Kele, re untirtneke Herod-werne, ikwere angkeke, “Akaperte John Baptist-kenhe ultakaye atyenge-werne akngetyetyeke!” ");
INSERT INTO aer_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nhenge Herod-ele renhe alakenhe angkerlenge aweke-arle, kele re alhwarrpe anthurre awelherlenge John-eke. Re uyarne anthurre itirreke marle nhenhe ikwere alakenhenge re kwenhe renhe alhileke-arle arne areye renhe anthetyeke, arrekwele arrpenhe areyenge. Kele re yerneke thultye anyente ikwerenhe sword akngerre-akerte. ");
INSERT INTO aer_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","11","Re jail-ke irrpenheke John Kwatyeke Akwernentye Akngerre akaperte ultaketyeke. Re akaperte ware apantheke arrernemele akngetye-alpeke. Nhenge akwete-arle aneke re marle renhe antheke, re anteme akngeke meye ikwerenhe Herodias-werne. ");
INSERT INTO aer_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Nhenge apententye akngerre John-kenhe areyele angkentye nhenhe renhe awerrirremele, itne apetyewarremele renhe ineke renhe iperteke akwernewarreke mwerrentyele artemele. Itne anteme alhemele ileke Jesus-eke John-arle uyerreke-akerte. ");
INSERT INTO aer_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Nhenhe ikwerele ureke Herod Antipas-ele, artwe nhenge Galilee-arenye areyeke-arle alartetye aneme, angkentye Jesus-akerte aweke tyerrtye areyele ilerlte-aperlenge apmere arrpe-anenhenge. ");
INSERT INTO aer_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herod mpwarentye akngerre ikwerenhe areyeke angkeke, “Artwe yanhe-ame John kwatyeke akwernentye akngerre? Itne-ame renhe atweke? Ilweke-arle-iperre-ame re nhenhe itethe-irrintye-alpeke? Alakenhenge-ame re ilyernpenye arne arunthe anteme mpwareme?” ");
INSERT INTO aer_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Nhenge Jesus-ele aweke John-arle ilweke-akerte, re boat-eke antyemele alheke apmere arrpenhe-werne re-arrpe anetyeke. Kenhe tyerrtye areyele awerlenge rarle yanhe ikwere-werne alheke. Apmere arrpe-anenhe-ngentyele itne ingkele apetyeke nthenhele Jesus anemenge. ");
INSERT INTO aer_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Nhenge Jesus apmere yanheke irremele boat-engentyele atnarnpemele, re areke tyerrtye atningke anthurre tnerrirrerlenge, itne ikwere akarelheke. Re itneke alhwarrpe awelheke rlkerte itnekenhe-arle angkwerre-iwekenge. ");
INSERT INTO aer_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Angwerre-angwerre-anteme-irreke, apententye akngerre ikwerenhe areye apetyemele ikwere angkeke, “Apmere nhenhe apmere arrpenhenge arlenge-ulkere, uterne kwenhe irrpeme. Itnenhene yernaye merne itneke-arrpe alhetyeke inetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesus akenhe itneke angkerlenge, “Itne kwenhe nhenhele aneme. Arrantherre itnenhe merne anthaye!” ");
INSERT INTO aer_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Apententye akngerre areye ikwere angkirtnerlenge, “Anwerne kwenhe merne tampe 5 pele ware atnyeneme kere kwatye-arenye atherre-arlke ware.” ");
INSERT INTO aer_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesus itneke angkeke, “Merne uthene kere kwatye uthene akngetyaye, ayenge anthetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tyerrtye areyeke anteme re ileke nhenge itne arrernelhetyeke atherrke-karleke. Kele Jesus anteme merne 5 pele kere kwatye-arenye atherre ineke. Re alkere akertne-werne-atheke areke Ngkarte utyernemele tnakeke. “Akngeyaye, ayenge kwenhe lyete ngkwenge akangkemele angkeme merne nhenheke.” Kele re anteme merne renhe ultakeke, kere kwatye-arenye nhenge ngkweltye-ngkweltye-ilemele, re antheke apententye akngerre ikwerenhe areye. Itne untherlte-apemele merne uthene kere kwatye-arenye akweke ware anthirtnaneke tyerrtye apurte-arle anerrirreke itnenhe. ");
INSERT INTO aer_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Tyerrtye ingkirreke anthurrele arlkweke anhelke-irretyeke. Ikwere iperrele apententye akngerre ikwerenhe areyele kutyerlte-apeke nhenge merne uthene kere kwatye-arenye uthene impekele areye yakwethe akngerre 12-pele areye-akertele. Yakwethe ikwerele ipmentye-ipmentye anthurre inteke. ");
INSERT INTO aer_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Artwe areyele nhenge arlkweke atnerte ulhelkeke-atwetye, areye kwenhe aneke 5,000 anthurre. Arelhe-arlke ampe areyele-arlke merne uthene irrpennge uthene arlkweke. ");
INSERT INTO aer_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Jesus anteme apententye akngerre ikwerenhe areyeke angkeke, “Arrantherre arrwekele alhaye boat-enge kwatye alayenge arrengakwe ampinye-werne. The kwenhe tyerrtye nhenhe areye apmere itnekenhe-werne yernirtneme.” Apententye akngerre ikwerenhe areye anteme boat-eke antyemele alheke kwatye alayenge arrengakwe ampinye-werne-atheke. Jesus-ele tyerrtye areye apmere itnekenhe-werne yernirtneke. ");
INSERT INTO aer_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nhenge itnenhe apmere-werne yerneke-arle iperrele, re apwerte akertneke antyeke re-arrpe angketyeke Ngkarteke. Ingwele anteme-irreke, Jesus anyente-arenye anetyame. ");
INSERT INTO aer_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Yanhe ikwerenge apententye akngerre Jesus-kenhe kwatye alaye mpwepele akwete alhetyame, kenhe itne uyarne anthurre arrengkere-irreke nhenge rlkele inngerre itnekenhe wernekenge, kwatyele itnenhe ulpertelhe-ilemele iweke. ");
INSERT INTO aer_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ingwemertele akwete, Jesus apwerte-ngentyele atnarnpeke, kwatye artepele itneke-werne atheke ingke apetyemele. ");
INSERT INTO aer_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Apententye akngerre areyele renhe areke kwatye artepele apetyerlenge, itne atere anthurre irrereke arlkerrirremele, “Ayekaye! Lthane-aketye alaye!” ");
INSERT INTO aer_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Jesus akenhe itneke angkerlenge, “Atere-irretyale anaye! Ayengeyaye! Atnerre anerrirraye!” ");
INSERT INTO aer_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Peter anteme angkeke, “Akngerrepataye! Unte-ame yanhe? Unte apeke-arle arratye yanhele tnemenge atyenge antangkaye ayenge boat-engentyele atnarnpemele alhetyenhenge ngkwenge-werne kwatye artepele.” ");
INSERT INTO aer_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Re anteme angkeke, “Kele, atnarnpemele atyenge-werne apetyaye!” Re anteme boat-engentyele atnarnpemele alheke kwatye artepele Jesus ikwere-werne-atheke. ");
INSERT INTO aer_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nhenge re alherle-apemele rlkele kwatye akngelhetyeke mpwarerlenge re anteme atere-irreke mpwepe anthurreke-irremele re anteme kwatye kweneke irrpetyeke alhemele re arlkeke, “Akngerrepataye! Ayenge kwatye-ketye inaye!” ");
INSERT INTO aer_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Iparrpe anthurrele Jesus-ele renhe amultenge tyarre-ineke imerte renhe kwatye-ngentyele tyarre-inemele imerte ikwere alakenhe angkemele, “Aye! Iwenhenge-ame unte itirreke tharle ngenhe uyarne mpwaretyame?” ");
INSERT INTO aer_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Kele ratherre boat-eke antyemele rlke atyenpe anteme irrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Apententye akngerre arrpenhe areye boat-elarle aneke areye Jesus-nge arrekwele kwene-irremele renhe tnakewarremele ikwere angkeke, “Arratye-arle unte Alere Ngkarte-kenhe.” ");
INSERT INTO aer_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ikwerenge anteme itne kwatye alayenge arrengakwe ampinyeke-irreke apmere Gennesaret ikwerenge. ");
INSERT INTO aer_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tyerrtye atningke anthurrele renhe alhengke-areke, itne iparrpe angkentye antekelhe-ileke Jesus-arle apmere ikwerele anetye-alheke. Itne tyerrtye rlkerte areye ikwere-werne akngetyeke. ");
INSERT INTO aer_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Rlkerte areye Jesus-eke arlketyame, “Anwerne ahentye aneme mantere akantye-ante ware ngkwinhe anpetyeke nhenge yanhe-arle anpeme-iperrele anwerne iparrpe mwerre-irretyenhenge!” Nhenge Jesus-ele mwerrelhe-ileke ingkirrekele-arle mantere ikwerenhe anpekenge.");
INSERT INTO aer_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ikwerenge Pharisee urrpetye-arlke angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye-arlke Jerusalem-engentyele apetyeke Jesus aretyeke. Itne renhe apayuthneke, ");
INSERT INTO aer_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Nthakenhe-arle-ame apententye akngerre ngkwinhe areyele apentetyakenhe akngerrepate arrulenye anwerne-kenhele-arle anwernenhe akaltyele-antheke? Itne kwenhe iltye alhewelhetyakenhe, akngerrepate arrulenye anwerne-kenhele anwernenhe akaltyele-antheke-arteke, nhenge merne arlkwetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Re itneke angkirtnerlenge, “Iwenheke-ame arrantherre angkentye Ngkarte-kenhe awerrirretyakenhe, angkentye akngerrepate arrulenye anwerne-kenhe ware awerrirremele? ");
INSERT INTO aer_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Nhenge angkentye Ngkarte-kenhe alakenhe angkeke, ‘Arrantherre akngeye uthene meye utheneke akurne angkirtnetyale, renhe-atherrenhe aywerrke-irremele awetyeke. Angwenhe apeke akurne angkerlenge akngeye uthene meye utheneke, arrpenhe areyele renhe irrerlknge-arle atwetyeke.’ ");
INSERT INTO aer_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kenhe arrantherre akenhe alakenhe-arle apale akaltyele-antherlenge, ‘Unte mangkwe uthene anyangkwe utheneke angketyeke, “The mpwelenhe alpe-eme-iletyeke arrangkwe-arle. Arne nhenge tharle mpwelenhe anthetyeke aneke arntarnte-aretyeke, the Ngkarte anteme alhileke renhe anteme anthetyeke.” ’” ");
INSERT INTO aer_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Jesus anteme itneke angkeke, “Alakenhe-arteke arrantherre angkentye Ngkarte-kenhe untyeme-ileme. Angkentye arrekantherrenhe-arrpe akaltyele-anthemele.” ");
INSERT INTO aer_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yewe, arrantherre-arle ularele mwerre aneme akwele. Kenhe angkentye Ngkarte-kenhe-arle ileke, Isaiah-ele, arratye anthurre-arle arrule arrekantherre-akerte alakenhe intelhe-ileke, ");
INSERT INTO aer_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Tyerrtye nhenhe areyele ayenge tnakeme arrakerte itnekenhenge ware. Kenhe itne akenhe angkentye atyinheke akangkwe-irretyakenhe-arle, atyenge ahentye-anerrirretyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Itne urrtyirremele kwene-irremele ayenge tnakeme. Alakenhenge itne akaltyele-anthemele angkentye itnekenhe-arrpe. Itne urrtyirremele ileme angkentye atyinhe alakenhe re.” ");
INSERT INTO aer_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Kele Jesus-ele tyerrtye areyeke antangkeke, itne angathe-irremele apetyeke renhe awetyeke. Re anteme itneke alakenhe angkeke, “Ayenge awemele akaltye-irraye! ");
INSERT INTO aer_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Iwenhe apeke renhe tyerrtyele-arle arrakerte ikwere-arleke akwerneme, renhe akurne-iletyeke arrangkwe Ngkartenge alkngetherre. Tyerrtye akurne-irreme Ngkartenge alkngetherre, rarle angkentye akenge areye angkemenge.” ");
INSERT INTO aer_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Urreke, apententye akngerre areye ikwere alakenhe angkeke, “Unte-ame itelareme Pharisee yanhe areye-arle ahele anthurre irrereke, angkentye-arle unte angkekenge?” ");
INSERT INTO aer_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesus imerte itneke angkemele, “Ngkarte akertne-arenye atyinhe, Re tyerrtye areye angkentye apale-arle akaltyele-antheme iwetyenhe-arle, arne nhenge Ngkarte-ketye, merne ngkernentye akngerrele-arteke-arle arne areye iwetyenhenge rarle ngkernetyakenhe. Re arne nhenge areye tyarre-inetyenhe, artekerre-arlke. ");
INSERT INTO aer_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kele Pharisee itneke akangkwe-irretyale anaye, itne kwenhe pwenge areye-arteke ware pwenge arrpenhe areye-arle arntirrkwemele akngerle-apeme. Nhenge pwenge arrpenhele pwenge arrpenhe arntwirrkerle-apeme ratherre imerte alhemele iperte akngerreke atnyerle-anerremele.” ");
INSERT INTO aer_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Peter imerte Jesus-eke angkemele, “Anwerneke ilaye angkentye nhenhe areye akethelhe-ilemele anwerne anteme itelarerrirretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesus anteme itneke angkeke, “Arrantherre-inpe ayenge itelarerrirretyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Arrantherre itelarerrirretyeke, nhenge tyerrtye areyele arlkwemele, merne re arrakerteke irrperlenge kele imerte merne nhenge anpere-irrenhemele arratetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Kele itirrewarraye iwenhe-arle arrakerte-ngentyele arratemeke, angkentye akurne areye-arle! Tyerrtye akurne areye-akerte itirremele, re anteme akurne angkeme, alakenhenge-arle re Ngkarte tnaketyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Nhenge tyerrtye akurnentye itirremele, alakenhenge anteme re tyerrtye arrpenhe atweme, arelhe arrpenhe anyelkngele intelhe-ilemele, imerte anewe arrpenhe-kenhe mpwenye akngemele. Re imerte arne arrpenhe-kenhe anyelkngele inemele, imerte urrtyirremele-arlke ilemele, arrpenhe areye-akerte akurne angkemele. ");
INSERT INTO aer_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ye, tyerrtye akenge-irremele rarle akenge itirremele-arle akenge mpwareke-arle. Kele Ngkartele aremele tyerrtye iltye alhewelhetyakenhele merne inemele arlkwerlenge rarle itnenhe akenge iletyakenhe-arle.” Alakenhe-arle Jesus apententye akngerre areyeke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yanhe-ngentyele Jesus alheke apmere yanhe iwerle-alhemele akweke ware anetyeke apmere Tyre uthene Sidon uthene itwele. ");
INSERT INTO aer_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Apmere yanhe ikwerele arelhe anyente apmere Canaan-arenye apetyeke Jesus-werne imerte ikwerenge arrekwele tnemele angkemele, “David-eke-artweye-aye, atyenge mwerre anemele atyenge alhwarrpe-irraye! Ampe atyinhe akunye rlkerte anthurre arrentyele-arle renhe rlkerte mpwarekenge.” ");
INSERT INTO aer_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesus-ele akenhe renhe irlpe artepele-arle awerlenge nthakenhe-arle re angkekenge, ikwere angkirtnetyakenhe anemele. Kele arelhe re renhe akwete apentemele ikwere arlkerle-apeke. Kele apententye akngerre Jesus-kenhe areye anteme ikwere angkeke, “Renhe aywepaye! Re kwenhe anwerneke arlkemele apenterle-apeme.” ");
INSERT INTO aer_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Kele Jesus arelheke angkeke, “Arrangkwe, Ngkartele-arle ayenge Israel-arenye areye-werne-ante-arle yerneke, itne-arle yepe-yepe aparnte-arle-irreke-arteke-arle anemenge itnenhe-arle arntarnte-aretyakenhe.” ");
INSERT INTO aer_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Nhenhe awemele arelhe re amperele-arlenge tnemele Jesus-eke angkeke, “Alartetye-aye, atyenge mwerre anemele renhe mwerre-iletyeke apetyaye!” ");
INSERT INTO aer_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Kele Jesus renhe ayene-ilemele, angkentye artemele ikwere angkeke, “Atyenge kwenhe mwerre anetyakenhe merne ampe areyenge rakemele akngwelye areye anthetyeke-arteke.” Alakenhe-arle re angkeke, Ngkartele-arle renhe yerneke Jew areye-ante angkwerre-iwetyeke, Jew anetyakenhe areye-kwenye. ");
INSERT INTO aer_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Arelhe re akenhe ikwere angkirtnerlenge, “Ye, arratye-arle akngerrepate kele unte itelareme nhenge ampe areyele arlkwerlenge, merne ngkweltye-ngkweltye table-ngentyele atnyerlenge, kele akngwelyele arlkwerlenge-arle.” ");
INSERT INTO aer_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Jesus imerte ikwere angkemele, “Arelhaye, unte kwenhe arratye angkeke. Unte-arle arratye itirreme tharle mpwaretyeke, kele ikwerenge anteme the mpwareme iwenhe-arle unte ahentye anemeke.” Kele arratye anthurre anteme ampe ikwerenhe mwerre-irreke. ");
INSERT INTO aer_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ikwerenge Jesus-ele apmere renhe impemele alpeke apmere Galilee-werne ikwerele anteme re kwatye iterele alhetyame re imerte apwerte akertneke antyenhemele anetye-alpeke. ");
INSERT INTO aer_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Kele tyerrtye atningke anteme ikwere-werne apetyewarreke, itne tyerrtye rlkerte atningke renhe akngetyeke, nhenge, inwerre areye, pwenge areye, angketyakenhe areye, awetyakenhe areye-arlke arrengkwelthe arunthe-akerte arrpenhe areye-arlke. Jesus-werne akngetyemele itne ingkeke athenemele, re akenhe itnenhe angkwerre-iwerlenge-arle ingkirre. ");
INSERT INTO aer_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tyerrtye areyele aremele nhenhe itne arnterre apatewarreke, angketyakenhe areye angkerlenge awemele, inwerre areye mwerre-irrerlenge, unthetyakenhe areye untherlenge, pwenge areyele arerlenge anteme. Itne anteme ingkirreke Ngkarte tnakewarreke, Israel-arenye areyele-arle utyernemele tnakewarreme renhe. ");
INSERT INTO aer_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesus antangkeke-arle-iperrele apententye akngerre ikwerenhe areyeke, re itneke angkemele, “Ayekaye, ayenge alhwarrpe awelheme tyerrtye nhenhe areyeke itne-arle atyengenge anekenge arlte urrpetyenge merne itnekenhe uyerreke anteme. Tharle itnenhe uyarne yernekenge alhemele apeke itne angayakwe atnyeketyenge. Nhenge arrpenhe areye itne apmere arlenge-ntyele apetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Apententye akngerre ikwerenhe akenhe angkerlenge, “Anwerne apmere unpenyele anemele, nthenhe-ngentyele anteme anwerne merne inetyenhe atningke nhenhe areye wantetyeke?” ");
INSERT INTO aer_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesus itneke angkirtneke, “Merne tampe nthakentye-arle-ame arrantherre atnyeneme.” Itne akenhe angkirtnerlenge, “Seven pele, kere kwatye-arenye akweke urrpetye-arlke.” ");
INSERT INTO aer_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Re ileke tyerrtye areye ahelheke arrernelhetyeke. ");
INSERT INTO aer_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Merne tampe seven-pele, kere kwatye-arenye akweke urrpetye-arlke itnenhe akngeke-iperrele, Ngkarteke angkemele ultakeke. Re antheke apententye akngerre ikwerenhe areye tyerrtye areye antherle-apetyeke. Itne akngernerlte-apemele anthirtnaneke itnenhe. ");
INSERT INTO aer_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Tyerrtye ingkirrekele arlkwemele atnerte ulhelke anteme. Apententye akngerre ikwerenhe areyele yakwethe seven-pele inemele, merne ipmentye-ipmentye areye kutyeke apurtelhe-ileke itnenhe. ");
INSERT INTO aer_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Artwe 4,000 atningkele arlkwemele atnerte ulhelke anteme, arelhe arrpenhe atningkele-arlke ampe areyele-arlke arlkwerrirreke. ");
INSERT INTO aer_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus-ele tyerrtye areye yerneke apmere-werne alpetyeke. Apententye akngerre ikwerenhe areye boat-eke antyeke. Itne kwatyele alheke arrengakwe-werne apmere Magadan-werne. ");
INSERT INTO aer_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Kele Pharisee areye uthene Sadducee areye uthene Jesus-werne apetyeke renhe uternetyeke arne ulyeyele mpwaretyeke, itneke imernetyeke Ngkartele-arle arratye renhe ngangkere antheke. ");
INSERT INTO aer_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kele Jesus itneke angkeke, “Nhenhe awerrirraye. Arrantherre itelareme nhenge uterne irrperlenge angkulye mwerrantye athetheke-irreme, renhe aremele arrantherre angkerrirremele, ‘Araye, angkulye areye athetheke-irreme. Kele ingweleme alkere akethe anetyenhe, kwatyeke arrangkwe.’ ");
INSERT INTO aer_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Arlte arrpenhe akenhe ingweleme, urreke uterne akertne-irretyenhenge, alakenhe ante-arle angkulye athetheke-irremele imparrkeme, alakenhe irremele arrantherre angkerrirreme, ‘Araye angkulye athetheke-irrekeyaye. Kwatyele apeke lyete anhetyenhe.’ Kele, arrantherre alkere aremele arrantherre akaltyele itelaremele-arle angkeme. Kele arrantherre areme nthakenhe-arle lyete-irreme arrantherre itelaretyakenhe-arle nthakenhe-arle Ngkartele mpwareme.” ");
INSERT INTO aer_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Kele Jesus itneke angkerlenge, “Kele arratye-arle arrantherre akurne areye Ngkarteke akangkwe-irretyakenhe. Arrantherre ayenge akwete apayuthneme the akwele ngangkerele mpwaretyeke arrantherre-arle atyenge-ante-arle akangkwe-irreme ayenge aremele alakenhe mpwarerlenge. Kele arrangkwe, Ngkartele iwenhe apeke renhe ngangkerele mpwaretyakenhe arrantherre aretyenhenge ware akwele. Urreke-arle arrantherre aretyenhe arne nhenge Jonah-ekarle irreke-arteke kele arrantherre itele-arle-areme.” Alakenhe-arle itne angkeke-iperre re alheke anteme. ");
INSERT INTO aer_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Itne apurte antyemele boat-eke kwatye alaye akngerrele alheke. Kenhe apententye akngerre areye akenhe alkngwirreke-arle merne tampe akngetyetyeke. ");
INSERT INTO aer_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesus anteme angkelpe-angkeke, itnenhe alakenhe ilemele, “Mwantye itirremele ameke-arelhewarretyeke arne nhenge merne arlware-ilentye akngerre Pharisee areye uthene Sadducee areye uthene-kenhe-ketyenge.” ");
INSERT INTO aer_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nhenge apententye akngerre areyele awemele alakenhe itne angkerreke, “Nthakenhe-ame re angkeme? Re apeke-arle alakenhe angkeme anwerne-arle merne imperlte-alhekenge.” ");
INSERT INTO aer_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Kenhe Jesus-ele awerlenge nthakenhe-arle itne angkeke imerte itneke angkemele, “Iwenhenge-arle-ame arrantherre angkerreme arrantherre-arle merne akngetyetyakenhe? Arrantherre apeke-arle itirreme tharle arrenhantherrenhe uyarne wantemeke-athene. ");
INSERT INTO aer_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Arrantherre-ame ayenge ipmentyele-arle areme ayenge itele-arlke-aretyakenhele? Arrantherre apeke-arle alkngwirreke-arle tharle artwe 5,000 wanteke merne 5-pele-ngentyele ware, kele itne arlkweke-arle iperre atnerte anhelke-ilelhemele, arrantherre merne ampenye ineke imerte kutyemele yakwethe 12 pele anthurreke arrernemele. ");
INSERT INTO aer_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Arrantherre apeke alkngwirreke tharle tyerrtye arrpenhe atningke anthurre 4,000 ingkirreke wantekeke merne 7-pelele ware, arrantherre anteme urtne 7-peleke merne ampenye areye arrerneke. ");
INSERT INTO aer_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nthakenhe anteme arrantherre itelaretyakenhe akwete nthakenhe-arle ayenge angkemeke? Ayenge-arle arrekantherre merne-akerte angketyakenhe-arle, kele the akenhe arrenhantherrenhe ileme mwantye itirretyeke-arle ameke-arelhemele merne arlware-ilentye akngerre Pharisee areye uthene Sadducee areye uthene-kenhe-ketye.” ");
INSERT INTO aer_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kele apententye akngerre itne itele-anteme-areke nthakenhe-arle re angkeke, itne-arle apale-arle itirreke Jesus-eke rarle angkekenge merne arlware-ilentye akngerre-akerte. Kele arrangkwe-arle, re ileke itnenhe alkngarre-ilemele Pharisee areye uthene Sadducee areye uthene-ketye angkentye urrtyirrentye-arle ilemenge. ");
INSERT INTO aer_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kele Jesus itne-akerte apmere arrpenhe-werne alheke, Caesarea Philippi arritnye-werne, re anteme apententye akngerre itnenhe alakenhe apayuthneke, “Atyenge ilaye! Nthakenhe-ame tyerrtye arrpenhe areye atyenge-akerte angkerreme, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke-akerte?” ");
INSERT INTO aer_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Itne akenhe ikwere angkirtnerlenge, “Arrpenheme areye itirreme unte-arle akwele John nhenge tyerrtye areye-arle kwatyeke akwernetyarteke, itethe-arle-irrintye-alpeke. Arrpenhe areye akenhe itirreme unte-arle Elijah-arle akwele itethe-arle-irrintye-alpeke. Arrpenhe areye akenhe itirreke unte-arle Jeremiah-arle, itethe-arle-irrintye-alpeke. Arrpenhe areye akenhe itirreke unte-arle akwele arrule-arle angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre, itethe-arle-irrintye-alpeke.” ");
INSERT INTO aer_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Kele Jesus itneke angkeke, “Kele angwenhe anteme arrantherre-arle ayenge ileme?” ");
INSERT INTO aer_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Kenhe Simon Peter akenhe angkirtnerlenge, “Unte-arle Christ-arle, nhenge Ngkartele-arle alhileke. Unte Alere Ngkarte-kenhe-arle, Ngkarte lterrke akngerre-arle aneme akenhe.” ");
INSERT INTO aer_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Kele Jesus anteme ikwere angkeke, “Yewe arratye Simon, Jonah-eke alere! Unte arratye-arle angkeme. Kele mwerre-arle, artwe arrpenhele-arle ngenhe akaltyele-anthetyakenhenge. Unte alakenhe angkeke Akngeye akertne-arenyele ngenhe alakenhe akaltyele-anthekenge. ");
INSERT INTO aer_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Awaye! Lyete the ngenhe ileme, Peter arritnye ngkwinhe, arritnye yanhele ileme “apwerte.” Unte apwerte-arteke, apmere artentye akngerrele arrekwele apwerte arrerneme warle artetyenhenge. Unte arrpenhe atningke anthurreke atyenge-akerte iletyenhe, itne ayenge apentetyenhenge. Itne ayenge akwete apentewarretyenhe, iperte-werne atheke apeke. ");
INSERT INTO aer_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Kele Peter, the ngenhe arrernetyenhe, unte-arle tyerrtye itneke arriwe altywere-iletyenhe, nhenge tyerrtye areyeke Ngkarte-arle alartetye anetyeke. Apmere ahelhe nhenhele unte arrpenhe areye arratye ayaketyenhe iwenhe apeke renhe mpwarerlenge, Ngkartele-arle akertnenge kele ayakekenge. Apmere ahelhe nhenhele unte arrpenhe areyeke arratye yewe angketyenhe iwenhe apeke renhe mpwarerlenge, Ngkarte-arle akertnenge kele yewe angkekenge.” ");
INSERT INTO aer_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Kele Jesus alakenhe itneke angkeke, “Tyerrtye arrpenhe areyeke atyenge-akerte iletyale, kele arrantherre itelareme ayenge-arle Christ aneme Ngkartele-arle alhileke!” ");
INSERT INTO aer_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Kele Jesus anteme apententye akngerre ikwerenhe areyeke alakenhe angkeke, “Urreke ulkere ayenge apmere Jerusalem-werne alhetyeke, yanhe ikwerele Jew akngerrepate areyele, kwertengerle akngerrepate tyatye-arenye areyele, angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyele atyenge anyurre-irremele, akurne anthurre irretyenhe atyenge, ayenge rlkerte anthurre atwetyenhe. Apmere yanhenge itne ayenge iltye anthetyenhe arrpenhe areyele ayenge atwetyeke. Itne-arle ayenge irrerlknge atwekenge ingwe atherre-iperrele ayenge itethe-irrirtnetyenhe akeme-irremele.” Alakenhe-arle Jesus-ele apententye akngerre itneke ileke. ");
INSERT INTO aer_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Peter-ele Jesus-eke antangkeke akngakelhe-ilemele, ikwere ahele angkemele, “Itne kwenhe ngenhe irrerlknge atwetyakenhe. Ngkartele ngenhe mwantyele arntarnte-aretyenhe!” ");
INSERT INTO aer_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jesus Peter-werne ularre-irremele ikwere ahele angkeke, “Arrentye-aye ayenge impemele alhaye. Unte akenhe itirreme tyerrtye ahelhe-arenye-arteke-arle. Unte kwenhe Ngkarte-arteke itirretyakenhe.” ");
INSERT INTO aer_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Kenhe Jesus apententye akngerre ikwerenhe itneke angkeke, “Angwenhele apeke-arle ayenge apenterle-anetyeke ahentye-aneme, re ikwere-arrpe alkngwirretyeke, atyenge-ante itirremele ayenge apenterle-anetyeke. Kenhe arrpenhe areyele apeke ngenhe atwerrirretyenhe arne arntarlkweke-arleke, unte-arle ayenge apentemenge, kele mwerre-arle. Atere-irretyalaye ilweme-ketye, ayenge apenterlte-akwete-anaye! ");
INSERT INTO aer_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Kenhe unte apeke-arle akwete itethe anetyeke ahentye-aneme, unte imerte ilelhemele unte-arle atyenge akutne-arle, arrpenhe areyele ngenhe atweketye, kele unte Ngkartenge itethe akwete-ante anetyakenhe-arle. Kenhe arrpenhe areyele apeke ngenhe atweme unte-arle ayenge apentemenge, kele unte Ngkartenge itethe akwete-ante-arle aneme. ");
INSERT INTO aer_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Kele tyerrtye nhenge ahentye-aneme arne ahelhe nhenhe-arenye ingkirreke inetyeke, kele re apententye akngerre-irretyakenhe-arle, nthakenhe anteme irretyenhe re ilwerlenge? Kele, re ilwemele, aparnte-irretyenhe, Ngkartenge akwete-ante anetyeke arrangkwe. Anwerne arne areye Ngkarte uyarne antheme, ikwerenge itethe akwete-ante anetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Urreke, ayenge Alere alkere-arenye ahelhe nhenhele-arle alkngirreke, Ngkarte-ngentyele kwene-werne apetyetyenhe, utnenge alkere-arenye atningke anthurre atyengenge irlkwatherre. Ayenge arratemele pwarrtyetyenhe alkngenthe akngerre-arteke, ingkirrekeke imernemele Ngkarte-arle mwerre akngerre aneme. Ayenge-arle apetyalpeke iperre ayenge ingkirrekeke itirretyenhe nthakenhe itnenhe iletyeke, the arne mwerre anthetyenhe tyerrtye mwerre-arle mpwaretyarte areyeke. The akenhe ilpernentye akngerrele atwetyenhe, tyerrtye arne akurne-arle mpwaretyarte areye. ");
INSERT INTO aer_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mwantyele awerrirraye! Arrpenhe areye lyete nhenhele tnerrirremele ayenge arerrirretyenhe, Alere alkere-arenye ahelhe nhenhele-arle akweke inteke, apetyalpetyenhe Akngerrepate anetyeke. Urreke itne ilwerrirretyenhenge nhenhe aretyenhe.” Alakenhe re, Jesus-ele itneke ileke. ");
INSERT INTO aer_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Arlte six pele iperrele Jesus antangkeke Peter, James, John-ekarlke. Re itnenhe akngeke apwerte akertne anthurre-werne, itne-arrpe anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Itne aretyame, Jesus arrpenhe anthurre irrerlenge, inngerre arrpenhe-irreke alernngele-arteke pwarrtyeke, mantere-arlke ikwerenhe mperlkere alernnge-alernnge anthurre irrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Iparrpele, Elijah uthene Moses uthene arraterle-anerremele Jesus ikwere angkerle-anerreke. ");
INSERT INTO aer_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Peter anteme Jesus-eke angkeke, “Akngerrepataye, Mwerre kwenhe anwerne ngkwenge nhenhele aneme. Unte apeke-arle ahentye-anemenge anwerne ilthe urrpetye artetyeke, ngkwenge anyente, Moses-eke anyente, anyente arrpenhe Elijah-eke-arle? Mwerreye?” ");
INSERT INTO aer_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kenhe Peter angkerlenge, kenhe angkulye alernnge-alernngele itnenhene urrpetye-arlke ingkirreke arterlenge. Angkulye-ngentyele angkerlenge itne aweke, “Nhenhe kwenhe alere atyeperre anyente atyinhe. Renhe akwetethe anthurre awerlte-anaye ingkirrekele.” ");
INSERT INTO aer_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Kenhe yanhe ikwerenge re, apententye akngerre Jesus-kenhe areye atere-irremele atnyerrirreke. ");
INSERT INTO aer_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesus re akenhe itneke-werne alhemele anpetyeke, itneke angkeke, “Akeme-irraye! Atere-irretyale!” ");
INSERT INTO aer_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Nhenge utnyeneke-arle-ipenhele, itne areke Jesus re-arrpe anteme tnerle-anerlenge ikwerele. ");
INSERT INTO aer_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Itne apwerte kwenekerle-alhemele Jesus-ele itneke ileke, “Arrantherre iletyale anetyeke tyerrtye areyeke iwenhe-arle arrantherre nhenheke arerne. Nhenge urreke ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, itethe-arle-irreke irrerlkngele aneke akeme-irretyenhe. Ikwere iperre anteme arrpenhe areye iletyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Apententye akngerre Jesus-kenhe areyele renhe apayuthneke, “Iwenhenge-arle angkentye Moses-kenhe akaltyele-anthenhe-anthenhe angkeme nhenge Elijah arrwekele apetyetyenhe? Nhenge itnekenge, artwe Ngkartele alhileke-arle ipenhe urreke akwele apetyeme intertele?” ");
INSERT INTO aer_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Re itneke angkirtneke, “Yewe, Elijah anteme arrekwele apetyemele arne ingkirreke mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","The arrekantherre arratye ileme: Elijah kele apetyeke, kenhe itne akenhe renhe alengkaretyakenhe-arle anerlenge. Itne ikwere irrpelthe-irreke. Itne renhe atweke alakenhe-arteke itne ayenge atwetyenhe, ayenge-arle Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke atwetyeke-arteke.” ");
INSERT INTO aer_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Kele anteme itne itelarerrirreke rarle John kwatyeke akwernentye akngerre-akerte itneke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Jesus apententye akngerre-akerte apwerte akertne-ngentyele atnarnpeke atningke arrpenhe tnerrirretyamenge-werne. Kenhe artwe anyentele Jesus ikwere-werne apetyemele kwene-irremele ikwere angkeke, ");
INSERT INTO aer_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Alartetye-aye, alere atyinhe-werne apetyaye. Re akwetethe arerte-irremele akurne anthurre aneme, re akwete-akwete ureke-arleke atnyerle-aneme, kwatyeke-arleke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","The apententye akngerre ngkwinhe areye apayuthneke renhe mwerre-iletyeke. Itne akenhe uyarne-arle angkwerre-iwerlenge renhe.” ");
INSERT INTO aer_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nhenge Jesus-ele nhenhe awemele re imerte itneke angkeke, “Arratye, tyerrtye arrantherre-arle Ngkarteke akangkwe-irretyakenhe-arle arrantherre akwetethe-arle apale itirrentye akngerre. Arrantherre-ame ayenge akwete ulpertelhe-ileme arrantherre-arle itelarerrirretyakenhe? Ilengareke-atwetye ayenge arrekantherrenge anerle-anetyeke urreke anthurreke-atwetye apeke? Kele ampe urreye atyenge-werne akngetyaye!” ");
INSERT INTO aer_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Kele imerte Jesus-ele arrentye ampe urreyeke-arleke ileke, “Arrentyaye, the ngenhe uterneme ampe urreye nhenhenge-ntyele arratintyeke awethe apetyalpetyale alhaye!” Iparrpe arrentye ampe urreye-ngentyele arratemele alheke. Urreye iparrpe mwerre-irrerle-alheke. ");
INSERT INTO aer_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ikwere-ipenhe Jesus alpeke apmere rarle aneke-werne. Jesus re-arrpe anerlenge, apententye akngerre areyele renhe apayuthneke, “Iwenhenge-arle-ame anwerne uyarne arrentye yanhe ayweperne?” ");
INSERT INTO aer_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","21","Jesus anteme angkirtneke, “The arrekantherre arratye ileme, arrantherre itirretyakenhe rarle arratye anetyeke arrantherre-arle akweke ware-arle akwenpe aneke. Alakenhenge anteme arrantherre mpwaretyakenhe aneke aywepemele anetyeke. Arrantherre itirreme rarle arratye anetyenhe, arrantherre apwerte akngerre nhenhe alakenhe angkemele, ‘Nhenhe-ngentyele akeme-irraye, nhakwe-werne alhaye!’ Kele arratye-arle re alheme arrantherre-arle ilekenge, arrantherre anteme arne akngerre atningke ngangkerele mpwareke.” ");
INSERT INTO aer_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Kele apententye akngerre areye apmere renhe imperlte-alhemele apmere Galilee-werne alheke imerte ikwerele apurte-irremele. Jesus imerte itneke angkemele, “Artwe anyentele ayenge imernetyenhe itneke, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, imerte ayenge artwe areye iltye anthemele, itne imerte ayenge inemele akngerlte-iwemele ayenge atwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Kele ingwe atherre iperre ayenge itethe-irrirtnemele ilweke-arle iperre akeme-irretyenhe.” Nhenge apententye akngerre areyele renhe alakenhe angkerlenge awemele, itne atnerte akurne anthurre awelheke. ");
INSERT INTO aer_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Jesus ikwerenhe areye-akerte apetyeke apmere Capernaum-werne artwe maneke apurte irrentye akngerre areye tyatye Jew-kenheke apetyemele. Itne Peter apayuthneke alakenhe, “Arrekantherrenhe akaltyele-anthenhe-anthenhele-ame mane tyatye-ke anthentye akngerre?” ");
INSERT INTO aer_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Kele Peter akenhe angkirtnerlenge, “Kele, arratye-arle!” Kele itne apmere-werne anteme alpeke kele Peter apmereke irremele Jesus ikwere angkeke, “Simon, nthakenhe-ame unte itirreme? Tyerrtye areyeke akngerrepate nhenhe areyele-ame angwenhenge tax mane inerreperreme? Alere itnekenhe-ngentyele apeke, tyerrtye apmere itnekenhe-ngentyele areyenge apeke?” ");
INSERT INTO aer_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Kele Peter angkirtnerlenge, “Kele, itne tyerrtye apmere itnekenhe areye-ngentyele-arle ineme.” Kele Jesus angkeke, “Ye, arratye alere akngerrepate areye-kenhe areyele itnenhe mane tax-eke anthetyeke arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Kele mwerre-arle, anwerne itnenhe antheme-arle itne anwerneke ahele-irreme-ketyenge. Kele unte apeke-arle kwatye alaye akngerre-werne alhemele-artaye, imerte hook iwemele kere kwatye-arenye inetyeke kwatye kwene-werne, unte kere kwatye-arenye arrekwele-iperre arratye inemele unte areme kere kwatye-arenye ikwerenhe arrakerte kweneke mane ngkweltye anyente. Peter alhemele arratye mpwaremele. Mane yanhe-arle ilerneke-arle tyatye renhe anthetyeke, kele inemele akngaye mane inerlte-apentye akngerre areye-arle anthetyeke tyatye Jew areye-kenheke.” ");
INSERT INTO aer_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Yanhenge anteme apententye akngerre areye Jesus-werne apetyemele renhe apayuthneke, “Nhenge Ngkartele anwernenhe arntarnte-arerle-anerlenge alartetyele-arteke, angwenhe anteme re itelareme akngerre anthurre-arle aneme, arrpenhe areyenge akngerre anthurre-ulkere?” ");
INSERT INTO aer_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aweke-arle iperre re ampe akweke anyenteke antangkeke re imerte renhe itneke mpwepeke ngkernemele. ");
INSERT INTO aer_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Re imerte itneke alakenhe angkemele, “Ayenge-arle arrekantherre arratye-arle angkeme, arrantherre apeke akngarte-iwelhemele ampe nhenhe-arteke anerlenge, Ngkartele arrenhantherrenhe ikwerenhe ileme arrenhantherrenhe arntarnte-aremele akwete alartetyele warte. ");
INSERT INTO aer_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ampe akweke nhenhe aremele nhenheke itirrewarraye, rarle akangkemele tnakelhetyakenhe-arle. Arrantherre apeke atyeperre anthurre anetyeke ahentye-aneme, kele ampe nhenhe-arteke irremele-ante, Ngkartele arrenhantherrenhe atyeperre-ileme re alartetye irrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Kele angwenhele apeke ampe akweke nhenhe-arteke atyewe akeme, the renhe atyewe akeme-anteye.” ");
INSERT INTO aer_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jesus itneke akwete angkeke, “Kele arrantherre apeke apententye akngerre atyinhe anyente akurne mpwaretyeke ileme, ampe akweke nhenhe-arteke apeke, Ngkartele arrenhantherrenhe akenge-arle-ileme. Arrpenhele apeke apwerte akngerre iteke-arleke ayernerlenge ngenhe kwatye iperteke iwemele, kenhe tyerrtye areye itirrewarremere arne akenge-arle ngkwenge irrekeke. Kenhe Ngkartele akenhe ngkwenge akenge awethe ulkere-arle mpwarerlenge, unte apeke arrpenhe, ampe akweke nhenhe-arteke renhe, akurne mpwaretyeke ilerlenge. ");
INSERT INTO aer_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Yewe, apmere arrpe-anenhele tyerrtye akurne atningke aneme itne anteme akwetethe tyerrtye arrpenhe areye uterneme akurne mpwaretyeke. Ngkartele-arle itnenhe atwetyenhe-arle akngerre anthurre itne tyerrtye itnenhe ularele uternerlenge akurne-irretyeke. ");
INSERT INTO aer_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Kele, unte apeke iltye ngkwinhele apeke ingke ngkwinhele apeke akurne mpwareme. Kele, unte iltye apeke ingke apeke anyente ultakemele iwetyeke unte akwete akurne mpwareme-ketyenge. Kele mwerre-arle unte iltye anyente apeke ingke anyente apeke atnyeneme, kele unte itethe akwete anetyenhenge Ngkartenge. Kele akurne anthurre unte-arle iltye atherrele apeke ingke atherrele apeke akurne mpwarerle-aneme, Ngkartele akenhe ngenhe apmere akurne ikwere-arle iwerlenge, ure akngerreke-arleke. ");
INSERT INTO aer_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Unte apeke alknge ngkwinhele arerlenge akurne mpwarerlenge. Kele unte alknge ngkwinhe tyerremele iwetyeke unte akurne awethe mpwarerle-aneme-ketye. Kele mwerre-arle unte apeke alknge mwerre anyente aneme itethe akwete anetyeke Ngkartenge. Kele unte akurne akwete mpwarerle-aneme alknge atherre-akertele Ngkartele ngenhe iweme-arle apmere akurne ikwere-werne, ure akngerreke-arleke.” Alakenhe-arle Jesus itneke angkeke. ");
INSERT INTO aer_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","11","Kele Jesus tyerrtye itneke angkeke, “Ameke-arelhewarraye! Akurne-iletyale ampe akweke nhenhe areye. Alkere-arenye ingkirreke ampe nhenhe areye-kenhe, alkere akertnele Ngkartenge, akwetethe akweke areye arntarnte-arerlte-aneme. Kenhe ayenge akenhe apmere nhenhe-werne apetyeke aparlpe-arle-irreke areye mwantyele arntarnte-aretyeke. ");
INSERT INTO aer_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“The arrekantherre angkentye iletyenhe artwe anyente-akerte yepe-yepe 100 anthurre-arle atnyeneke. Yepe-yepe anyente akenhe aparlpe-arle-irrerlenge. Anyente-arle aparlpe-ilekenge, nthakenhe anteme re irretyenhe? Arratye, rarle yepe-yepe 99 arrpenhe areye apwerte areyeke impemele, arrpenhe anyente ikwere-arle unthetyeke alhemere. ");
INSERT INTO aer_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Kenhe arntarnte-arentye akngerrele apeke areke yepe-yepe anyente aparlpe-arle-irreke renhe, re ikwere akangketyenhe anthurre-arle. Arratye apelaye. Re anyente ikwere akangkentye anthurre awethe ulkere arrpenhe 99-pele-nge, nhenge aparlpe-arle-irretyakenhe areyenge. ");
INSERT INTO aer_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Akngeye arrekantherrenhe alkere akertnenye yepe-yepe arntarnte-arentye akngerre yanhe-arteke, re arrpenhe aparlpe-iletyeke ahentye anetyakenhe. Re ampe akweke areyeke ahentye anthurre aneme. Re itneke ahentye-aneme arntarnte-aretyeke ikwerenge utepe-irreme-ketye.” ");
INSERT INTO aer_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Atyewe Ngkarte-kenhe arrpenhe apeke ngkwenge apale angkeme, akurne mpwaremele apeke. Kele unte ikwere-werne alhetyeke mpwele apurte-irremele nthenhenge apeke imerte mwantyele ilemele rarle ngkwenge akurne mpwarekenge. Re apeke ngkwenge akangkwe-irremele ahele-irretye-kwenye anetyenhenge, apure-irremele ipeltye-irremele ngkwengenge. ");
INSERT INTO aer_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Re apeke ngkwenge akangkwe-irretyakenhe, atyewe Ngkarte-kenhe anyente apeke, atherrame apeke inemele alhaye apurte imerte angketyeke alhemele. The ngkwenge nhenhe ileme arrule tyerrtye anyentele intelhe-ileke Bible-nge unte alakenhe mpwaretyeke. ‘Tyerrtye anyentele apeke arrpenhe ilperneme rarle akwele renhe akurne mpwarekenge. Kele re akenhe anyente-arrpe angketyeke alhetyale anetyeke, imerte akngemele tyerrtye arrpenhe anyente apeke atherrame apeke areke-arle akurne-arle mpwarerlenge imerte yanhe urrpetye apurte-irremele angkerremele ikwere.’ ");
INSERT INTO aer_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Re apeke-arle ngenhe irlpe artepele aweke, renhe atyewe Ngkarte-kenhe-werne areye akngaye, imerte ikwere angkemele atningkenge alkngetherre. Re apeke mwernte akwete tneme atningkele arerlenge, kele ikwere-ketye untyeme-irremele anetyeke. Re anteme Ngkarteke akutne areye-arteke aneme.” ");
INSERT INTO aer_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Kele Jesus awethe angkeke apententye akngerre ikwerenhe areyeke, “Awerrirraye! The angkentye nhenhe arrekantherre arratye ileme. Apmere ahelhe nhenhele arrantherre arrpenhe areye arratye ayaketyenhe iwenhe apeke renhe mpwarerlenge, Ngkartele-arle akertnenge kele ayakeke. Apmere ahelhe nhenhele arrantherre arrpenhe areyeke arratye yewe angketyenhe iwenhe apeke renhe mwerre mpwarerlenge, Ngkarte-arle akertnenge kele yewe angkekenge. ");
INSERT INTO aer_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Awethe ayenge arrekantherre angkeme alakenhe: tyerrtye atherre apeke apurte-irremele imerte yewe angkerremele iwenhe apeke ikwere, kele imerte Ngkarte anteme ikwere-akerte apayuthnemele. Kele re mpwareme-arle iwenhe-arle ratherre apayuthneke. ");
INSERT INTO aer_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","The arrekantherre ileme tyerrtye atherre apeke urrpetye apeke atyenge akangkwe-irrentye akngerre apurte-irremele Ngkarteke angkeme, kele ayenge itnekenge apurte-irretye-alheme-arle yanhele.” ");
INSERT INTO aer_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Kele Peter Jesus-werne apetyemele renhe apayuthneke, “Alartetye, atyewe Ngkarte-kenhe arrpenhele apeke atyenge akurne akwete mpwarerle-anerlenge, nthakentye-ngare-ame the renhe ipmentyele impetyeke renhe ilpernetyakenhe anemele? The-ame renhe 7-ngare anthurre impeme, re apeke awethe akurne-irrerlenge the-ame renhe atweye?” ");
INSERT INTO aer_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Kele Jesus akenhe ikwere angkerlenge, “Arrangkwe, renhe ipmentyele impetyeke renhe atwetyale. ");
INSERT INTO aer_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","The arrekantherre ileme, Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Artwe akngerrepate aneke re mane anthetyarte ingwentheke ware urrkapentye akngerre ikwerenhe areye, itne imerte anthirtnemele anteme. Arlte anyentele re itirreke, ‘The pipe nhenhe areye, aretyeke angwenhele-arle ayenge mane anthirtnetyenheke.’ ");
INSERT INTO aer_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Re imerte pweke altywere-ilemele aremenge re imerte arritnye anyente-arle aremele, mane akngerre anthurre-arle anthirtnetyeke aneke. Akngerrepatele imerte urrkapentye akngerre anyente ilemele tyerrtye yanhe renhe ikwere-werne akngetyetyeke. Re anteme alhemele renhe ikngweke imerte renhe akngetye-alpemele. ");
INSERT INTO aer_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Kele artwe re uyarne itirreke nthakenhe anthirtnetyeke rarle akweke ware atnyenekenge. Akngerrepate imerte alakenhe-arle angkemele, ‘Artwe nhenhe akngaye anewe-arlke ampe-arlke ikwerenhe areye-arlke arne itnekenhe-arlke ingkirreke imerte tyerrtye arrpenhe anthemele maneke, kele unte mane renhe inemele atyenge anteme-arle akngetye-alpemele.’ ");
INSERT INTO aer_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Kenhe artwe re akenhe amperele-arlenge tnemele angkerlenge, ‘Mwantyele akarelhaye, kele the ngenhe ingkirreke anthurre-arle mwantyele antherle-anetyenhenge!’ ");
INSERT INTO aer_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Akngerrepate ikwere alhwarrpe-irremele renhe yerneke alhetyeke anteme. ");
INSERT INTO aer_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Kele artwe urrkapentye rarle alhekenge anteme re urrkapentye akngerre arrpenhe areke imerte itirremele, ‘The kwenhe artwe nhenhe mane ngkweltye akweke ware antheke arrekwele, re kwenhe ayenge anthirtnetyakenhe akwete.’ Re artwe renhe arntwirrkemele ahentyenge tnerneke imerte ikwere angkemele, ‘Iparrpe ayenge mane atyinhe anthirtnaye tharle ngenhe arrekwele antheke!’ ");
INSERT INTO aer_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Urrkapentye akngerre re akenhe ikwere amperele-arlenge tnemele angkerlenge-arle, ‘Mwantye ulkere atyenge akarelhaye, the ngkwenge urreke anthirtnetyenhenge!’ ");
INSERT INTO aer_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Kele artwe re akenhe ikwere alhwarrpe-arlke-irretyakenhele renhe jail-ke akwerneke re jail-le anemele renhe anthirtnetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Kenhe urrkapentye akngerre arrpenhe areyele renhe aremele alakenhe irrelenge itne ahele-irremele itne alheke akngerrepate itne-kenheke iletyeke iwenhe-arle itne areke ipenhe. ");
INSERT INTO aer_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Kele akngerrepatele itnenhe ileke artwe renhe ikwere inetyeke. Kele itne anteme alhemele renhe inerle-alpeke. Kele akngerrepate anteme ikwere angkeke, ‘Unte kwenhe akurne anthurre, unte kwenhe ayenge mane akngerre anthintye-alpetyeke, unte-arle ayenge apayuthneke iperre the ngenhe mwantyele-arle impeke. ");
INSERT INTO aer_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Unte-arle urrkapentye akngerre nhengeke alhwarrpe-irretyakenhe-arle irreke, ayenge-arle ngkwenge alhwarrpe-irreke-arteke.’ ");
INSERT INTO aer_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kele akngerrepate re ahele anthurre irreke urrkapentye akngerre ikwerenheke imerte alakenhe angkemele, ‘Artwe nhenhe jail-werne akngerlte-iwaye thultye areyele renhe tnyante atwetyeke. Kele re-arrpe apeke jail-ele anemele, mane atyinhe ingkirreke anthirtnemele-ante re arratetyenhenge.’” ");
INSERT INTO aer_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Kele Jesus-arle itneke alakenhe angkeke-iperre re itneke angkeke, “Akngeye atyinhe alkere akertnele-arle aneme kwenhe akngerrepate nhenhe-arteke aneme. The arrekantherre ileme arrantherre apeke arrpenhe areyenge ipeltye-irrerlenge itnenhe atwirtnetyakenhe anemele, Akngeye akertne-arenye akenhe arrekantherrenge ipeltye anteye-arle irreme imerte atwirtnetyakenhe-arle anemele. Kenhe arrantherre apeke ahentye-anetyakenhe aneme ipeltye-irretyeke kele re ipeltye-irretyakenhe anteye-arle aneme arrekantherrenge.” ");
INSERT INTO aer_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Alakenhe angkeke-arle iperre, Jesus apmere Galilee imperle-alheke Judea ampinye-werne. Re kwatye lhere Jordan-enge arntwarre aneke. ");
INSERT INTO aer_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tyerrtye atningke anthurre ikwere-werne apetyewarremele tnerrirreke ikwerenge. Kele re akenhe itnekenhe rlkerte areye angkwerre-arle-iwerlenge. ");
INSERT INTO aer_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Artwe Pharisee urrpetye apetyemele Jesus renhe apayuthneke nhenge itne alknginye-alknginyele ahentye-anemele renhe alhule-iwetyeke. Kele itne renhe apayuthneke, “Anwerneke ilaye! Mwerre-ame artwe anewe ikwerenhenge akalke-irreme arelhe renhe mikwe anyikwe-werne yernirtnemele nthakenhe apeke-arle re irrekenge?” ");
INSERT INTO aer_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Kenhe Jesus itneke alakenhe-arle angkirtnerlenge, “Arrantherre-ame Bible-nge apeke aretyakenhe? Arlte arrwekele-arle Ngkartele-arle urreye uthene marle uthene aknganeke. ");
INSERT INTO aer_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Kele alakenhenge anteme artwele anyikwe uthene mikwe uthene imperle-alhemele arelhe anewe akemele anyente-irretyeke. ");
INSERT INTO aer_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Yewe, ratherre atherre-arle aneke anyente anteme irreke, alakenhenge anteme artwe re arelhe ikwerenhe yernetyale anetyeke ikwerenge akwete, Ngkartele-arle artwe renhe anyentelhe-ilekenge arelhe anewe ikwerenheke-arleke.” ");
INSERT INTO aer_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Itne ikwere angkeke, “Iwenhenge-ame angkentye Moses-kenhe alakenhe angkeke? ‘Nhenge artwe apeke ahentye-aneme anewe ikwerenhenge akalke-irretyeke, re apeke intelhe-iletyeke pipe-ke-arleke renhe re anthetyeke renhe yernetyenhenge.’” ");
INSERT INTO aer_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesus itneke angkirtnerlenge, “Nhenge Ngkartele urreye uthene marle uthene arrwekele aknganeke, ratherre anewe akerretyeke akwetethe anerle-anerretyeke. Kenhe arrantherre-arle angkentye Ngkarte-kenhe impeme, iwenhe apeke renhe akwenpele mpwarewarreme. Alakenhe ikwerenge-ntyele Moses-ele arrenhantherrenhe angkentye antheke artwele anewe ikwerenhe kele impetyeke. ");
INSERT INTO aer_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Artwe apeke anewe ikwerenhenge akalke-irremele yernirtnemele arelhe-arle artwe arrpenhenge intekenge, kele mwerre rarle. Kenhe the akenhe arrekantherre ileme, artwe angwenhe apeke anewe ikwerenhenge akalke-irremele renhe yernirtnemele re anteme arelhe arrpenhe anewe akemele, rarle mpwenye ikngwemele, akurne anthurre rarle.” ");
INSERT INTO aer_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Kele apententye akngerre Jesus-kenhe areye ikwere angkeke, “Alakenhe apeke-arle anewarte-arle aneme-akerte unte ileme, kele anwerne mwerre-arle anewe akerretyakenhe aneme!” ");
INSERT INTO aer_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Kenhe Jesus itneke angkirtnerlenge, “Artwe arrpenheme ware anewe aketyakenhe. Kenhe Ngkartele apeke artwe nhenge areye ileme anewe aketyale, kele alakenhenge-arle itne anyente anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Artwe arrpenheme uyarne anewe akerreme itne-arle arne akurne-akerte intekenge. Kenhe arrpenheme uyarne anewe akerreme artwe arrpenhele-arle itnenhe iwenhe apeke renhe mpwarekenge. Kenhe arrpenheme anewe akerretyakenhe aneme itne Ngkarteke urrkapetyenhenge. Kenhe artwe arrpenheme impentyele aneme anewe akerretyakenhe, kele mwerre-arle.” ");
INSERT INTO aer_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Urreke re, tyerrtye arrpenhemele ampe akweke itnekenhe Jesus-werne akngetyewarreke, re itnenhene iltyele itneke-arleke arrernetyeke, Ngkarteke itneke angketyeke. Kenhe apententye akngerre Jesus-kenhe areye ahele-irremele-arle itneke angkerrirreke. ");
INSERT INTO aer_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Kele Jesus angkeke apententye akngerre ikwerenhe areyeke, “Arrantherre apeke areme ampe akweke areye atyenge-werne apetyerlenge itnenhe ayaketyale! The arrekantherre ileme angwenhe apeke ampe akweke nhenhe areye-arteke anemele Ngkartele itnenhe atyewe Ikwerenhe aketyenhe arntarnte-aremele akngerrepate itnekenhele-arteke.” ");
INSERT INTO aer_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Kele anteme Jesus-ele ampe akweke areye iltyele anpeke Ngkarteke itneke angkemele, re itnenhe mwerre mpwaretyenhenge. Re anteme itnenhe impemele alheke. ");
INSERT INTO aer_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Arlte arrpenhele tyerrtye anyente apetyeke imerte Jesus apayuthnemele, “Akaltyele-anthenhe-anthenhe-aye! Arne iwenhe-ame mwerre the mpwaretyeke Ngkarteke anyente-irremele ikwerenge akwete-ante anetyenhenge?” ");
INSERT INTO aer_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Kenhe Jesus ikwere angkirtnerlenge, “Iwenheke-ame unte ayenge apayuthnerne iwenhe mwerre-akerte? Tyerrtye arrpenhe mwerre anetyakenhe, kenhe Ngkarte-ante mwerre. Unte apeke ahentye-aneme itethe akwete-ante anetyeke, kele antime unte akwetethe angkentye Moses-kenhe akngerre apenterle-anetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Artwele Jesus renhe apayuthneke, “Iwenhe-ame angkentye Moses-kenhe the apentetyeke?” Jesus ikwere angkirtnerlenge, “Tyerrtye arrpenhe renhe irrerlknge atwetyale! Intetyale anewe tyerrtye arrpenhe-kenhenge, impetyeke akwete. Anyelkngele inetyale! Ularele apwerte ngkweltye inetyale anetyeke! Arrpenheke akurne ilpernetyale! ");
INSERT INTO aer_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Meye uthene akngeye uthene awerle-anetyeke ikwere-atherre ahele-irretyale! Arrpenhe areyeke ahentye-anetyeke ngkwenge-arrpe ahentye-aneme-arteke.” ");
INSERT INTO aer_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Kenhe apmerrke re awethe angkeke, “Akngerrepataye, the angkentye akngerre renhe areye apenteke, renhe akwetethe awerle-apemele. The-ame angkentye arrpenhe apenteme re?” ");
INSERT INTO aer_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesus imerte ikwere alakenhe-arle angkemele, “Unte apeke mwerre anthurre anetyeke ahentye-anemele, unte alhetyeke arne ingkirreke ngkwinhe anthetyeke maneke, kele mane anthemele mane atnyenetyakenhe areyeke imerte apetyemele ayenge apentetyeke. Yanhe-ngentyele anteme, unte ineme arne mwerre anthurre alkere akertne-ngentyele.” ");
INSERT INTO aer_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Nhenge artwele nhenhe awemele re irrare-irreke imerte alpemele rarle mane-arlke mantere-arlke atningke atnyenekenge, re akenhe ikwere-arrpe atnyenetyeke-arle ahentye-aneke. ");
INSERT INTO aer_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nhenge Jesus-ele areke artwe renhe alherlenge re angkeke apententye akngerre ikwerenhe areyeke, “The arrekantherre arratye ileme, tyerrtye mane-arlke mantere-arlke atningke-akerte areye arrpernkeme Ngkarte renhe apayuthnetyeke akngerrepate irretyenhenge itnenhe arntarnte-aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ayenge awerrirraye! Arrantherre itelareme alhwenge yerre-kenhe altywere akweke anthurre-akerte, kamule apeke-ame altywere ikwerenge irrpenhemere? Arrangkwe. Alakenhe akwele angwenhe apeke mane atningke-akerte, arrpernkeme Ngkarte renhe apayuthnetyeke akngerrepate irretyenhenge itnenhe arntarnte-aretyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Kele apententye akngerrele awekenge anteme, apatemele itne Jesus apayuthneke, “Kele, tyerrtye iwenhe-arteke-ame Ngkartele itethe akwete-ante atnyenetyenhe?” ");
INSERT INTO aer_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Kele Jesus-ele itnenhe arratye aremele angkeke, “The arrenhantherrenhe ileme, tyerrtye-arle arntarnte-arelhetyeke arrangkwe-arle, kele Ngkartele-ante-arle arntarnte-areme.” ");
INSERT INTO aer_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Kele Peter angkerlenge, “Awaye, unte itelareme anwerne kwenhe arne areye impemele apetyeke ngenhe apentetyenhenge, kele iwenhe anteme anwernenhe Ngkartele anthetyenhe?” ");
INSERT INTO aer_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Kele Jesus angkirtnerlenge, “Urreke-arle uterne uthene alkere uthene uyerretyenhenge, ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, alartetye anetyenhe chair atyeperre anthurrenge, ahelhe uthene alkere uthene arrpenhenge. Kele arrantherre apententye akngerre 12 pele atyinhe, alakenhe-arteke chair atyeperre 12-pele-nge anetyenhe, kele arrantherre Israel-arenye arrwekelenye areyeke itirretyenhe nthakenhe itneke mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Kele angwenhele apeke ayenge apentetyenhenge, re apeke-arle apmere impekenge, kake akngerre uthene yaye akngerre uthene-arlke, mikwe uthene anyikwe uthene-arlke, ampe-arlke, kartene ikwerenhe-arlke. Kele alakenhenge Ngkartele renhe antheme awethe ulkere rarle arrekwele atnyenekenge, kele re Ngkartenge aneme akwete-ante apurte anteme. ");
INSERT INTO aer_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Arrantherre itelareme tyerrtye arrpenhe areye atyeperre anthurre anteme, kele arrpenhe areye akenhe anetyakenhe-arle. Kele atyeperre-arle aneke itne akweke anteme-arle irreme, kele atyeperre anetyakenhe itne anteme-arle atyeperre anthurre irretyenhe.” Alakenhe-arle Jesus angkeke apententye akngerre ikwerenhe areyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Jesus-ele anteme angkentye alengke-iwentye arrpenhe itneke ileke, alakenhe, “Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Artwe anyentele atnyeneke garden mwerre anthurre merne kripethe areye-akerte. Arlte anyentele, ingweleme anthurre re alheke apmere arrpenhe-werne urrkapentye akngerre artwe areyeke unthetyeke, garden ikwerenhenge urrkapetyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Re alhemele areke artwe urrpetye urrkapetyeke tnerlte-anerlenge itneke re antangkemele ileke, ‘Apetyewarraye, garden atyinhenge urrkapetyeke, the anteme mane antheme arrantherre ingweleme-ngentyele ingweke-atwetye urrkaperlenge.’ Alakenhe awemele itne mwerre angkeke. Re anteme itnenhe ileke urrkapetyeke alhetyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Kele uterne-arle akertne anteme irrekenge re awethe alheke artwe urrkapentye akngerre arrpenhe areye aretyeke re arratye areke arrpenhe areye tnerlte-anerlenge urrkapetyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Re anteme itne angkeke, ‘Apetyewarraye garden atyinhenge urrkapetyeke, kele the mane anthetyenhenge ingweke-atwetye urrkaperlenge.’ ");
INSERT INTO aer_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kele itne alhemele urrkerlpe-urrkapeke. Kele arlte mpwepele alartetye re awethe apmere arrpenhe-werne alheke artwe arrpenhe areye aremele re ileke urrkapetyeke alhetyeke. Alakenhe anteye re alheke angwerrele artwe arrpenhe areye anteme ileke urrkapetyeke garden ikwerenhenge. ");
INSERT INTO aer_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","“Kele ulye arlpentyele re alheke awethe imerte aremele artwe areye tnerlte-anerlenge urrkapetyakenhe. Re imerte itneke angkemele, ‘Iwenhenge-ame arrantherre akwete ingweke-atwetye tnerlte-aneme urrkapetyakenhe?’ ");
INSERT INTO aer_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Kele itne angkirtnerlenge, ‘Arrangkwe anwerne kwenhe, tyerrtyele anwernenhe urrkapetyeke ikngwetyakenhe-arle.’ “Re anteme itneke angkeke, ‘Yewe, arrantherre-arlke apetyewarraye garden atyinhele urrkapetyeke.’ Kele itne alheke urrkerlpe-urrkapetyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kele uterne-arle irrpekenge anteme akngerrepate artweke antangkeke, urrkapentye akngerre arrpenhe areye-arle arntarnte-aremeke, ikwere angkemele, ‘Antangkaye artwe urrkapentye akngerre areyeke itnenhe anteme mane anthemele. Ingkerne-arle apetyeke areye-urrke anthaye, imerte mpwepenge-arle apetyeke areye anteme, kele imerte ingweleme anthurre-arle apetyeke areye anteme anthemele.’ ");
INSERT INTO aer_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Kele artwe re antangkeke yanhe areyeke ingkerne-arle apetyekeke, akweke ware-arle urrkapemeke, itnenhene mane anthemele arlte akngerreke. ");
INSERT INTO aer_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Ingweleme-arle apetyeke areye akenhe aremele itirrerlenge, ‘Yewe, re itnenhe antheme arlte akngerrele-arle urrkapekenge kele re anwernenhe awethe-arle anthetyenhe anwerne-arle ingweke-atwetye urrkapekenge.’ Kele re akenhe itnenhe rante-rante ante-arle antherlenge. ");
INSERT INTO aer_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","12","Kele itne mane inemele itne ahele angkerreke imerte alartetyeke angkemele, ‘Unte itelareme artwe yanhe areye kwenhe apetyeke ulye akngerrele imerte akweke ware urrkapemele, kele anwerne akenhe ingweleme-ngentyele ingweke-atwetye-arle urrkapeke uterne akngerrenge, unte akenhe anwernenhe itnekenge awethe akngerre ulkere apeke anthetyakenhe-arle. Iwenhenge-arle-ame unte anwernenhe ingkirreke rante-rante antheke?’ ");
INSERT INTO aer_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Kele alartetye re artwe anyenteke angkeke, ‘Atyewe-aye, the kwenhe ngenhe apalele anthetyakenhe the kwenhe arratye-arle antheke. Nhenge unte-arle ingweleme apetyekenge the ileke tharle ngenhe mane arlte akngerreke anthetyenhe unte-arle arltele-akake urrkaperlenge. Unte itelareme, awemele, yewe angkerreke. ");
INSERT INTO aer_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kele mane ngkwinhe inemele anteme apmere-werne alpe! The apwerte mane mpwanke anthetyeke ahentye-aneme artwe ingkerne-arle apetyekeke nhenhe areye ngenhe-arle antheke-arteke. ");
INSERT INTO aer_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kele mwerre-arle the mwerrantye antheke ayenge-arle ahentye-anemenge, nhenhe-arle mane atyinhe-arle the antheme nthakenhe-arle ayenge ahentye-aneme-arteke. Iwenhenge-arle-ame arrantherre ahele angkerreme? Arrantherre apeke-arle ingkerte-arle-irreme tharle anthemenge mwerrantye.’” ");
INSERT INTO aer_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Kenhe Jesus angkentye-arle itneke ileke iperre itneke alakenhe angkeke, “Arrantherre itelareme tyerrtye arrpenhe areye atyeperre anthurre anteme, kele arrpenhe areye akenhe anetyakenhe-arle. Kele tyerrtye atyeperre-arle aneke itne akweke anteme-arle irreme, kele tyerrtye atyeperre anetyakenhe itne anteme-arle atyeperre anthurre irretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus apententye akngerre ikwerenhe areye-arlke iwerrele alherlte-iwetyame Jerusalem-werne-atheke, re itneke antangkeke akngakelhe-ilemele, angkeke, ");
INSERT INTO aer_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Ayenge awerrirraye! Anwerne apmere Jerusalem-werne-atheke. Yanhe ikwerele, tyerrtye arrpenhe apeke atyenge-ngentyele artepe untyeme-irretyenhe, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, iltye anthetyenhe kwertengerle akngerrepate tyatye-arenye areyeke, angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyeke-arlke. Kenhe itne ayenge imerrentye irrerlkngeke atwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Kele itne anteme ayenge iltye anthetyenhe Jew anetyakenhe areyeke. Kele itne anteme atyenge anhelhetyenhe, imerte arne atyepele-arteke atwemele. Kele itne ayenge arne arntarlkweke-arleke irlpare arrernetyenhe ayenge ilwetyenhenge. Kenhe ingwe atherre iperrele, ayenge itethe-irrirtnetyenhe akeme-irremele.” ");
INSERT INTO aer_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ikwerenge-ntyele anewikwe Zebedee-kenhele alerikwe atherre James uthene John uthene Jesus-werne akngeke kwene-irremele ikwere ankeye inkeke. ");
INSERT INTO aer_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Kenhe Jesus ikwere angkerlenge, “Iwenhe-ame the ngkwenge mpwaretyeke?” Re ikwere angkirtnerlenge, “Urreke, unte tyerrtye ingkirreke anthurreke akngerrepate anerlenge, ampe nhenhe atherre akngerrepate ngkwenge itwele anetyeke, ngkwenge itweke arrernelhetyeke anyente akwe-arratyeke, arrpenhe akwe-alyengeke.” ");
INSERT INTO aer_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Kenhe Jesus ikwere-atherre angkeke, “Akutne-akutne ware kwenhe mpwele ayenge apayuthneke. Mwerre-ame alakenhe itne renhe-atherrenhe rlkerteke atweme, irrerlknge atwetyeke, nhenge itne-arle ayenge irrerlknge atwetyeke-arteke?” Ratherre ikwere angkirtnerlenge, “Yewe, kele mwerre-arle.” ");
INSERT INTO aer_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesus akenhe ikwere-atherre angkerlenge, “Mpwele kwenhe arratye rlkerte akngerre inetyenhe. Mpwele ayenge-arteke ilwetyenhe. The kwenhe uyarne akngakeme angwenhe apeke re atyenge akwe-arratyeke akwe-alyengeke anetyeke. Nhenge Ngkartele-ante kwenhe akngakentye akngerre itnenhe.” ");
INSERT INTO aer_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Nhenge apententye akngerre arrpenhe ten-pelele ikwere-atherre-akerte awemele, itne ahele-irreke atyeyenhengeke. ");
INSERT INTO aer_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kele Jesus-ele itnenhe anyentelhe-ilemele angkeke, “Arrantherre itelareme nthakenhe-arle akngerrepate ahelhe nhenhe-arenye areyele tyerrtye ingkirreke uterneme mpwaretyeke. Itne uterneme itnenhe arne arrpe-anenhe renhe mpwaretyeke itne ahentye-anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Kenhe arrantherre akenhe yanhe areye-arteke anerrirretyale anetyeke-arle! Kenhe angwenhe re apeke arrekantherrenge akngerrepate anetyeke, re arrpenhe itnekenge ingkerneke arrernelhetyeke, urrkapentye akngerre-arteke anetyeke, arrpenhe ingkirrekeke urrkaperle-anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Kenhe angwenhe re apeke arrekantherrenge arrekwele anetyeke, re arrpenhe areyeke mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Alakenhe apeke arrantherre apale itirreme, ayenge-arle, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apetyeke nhenge arrpenhe areye akwele atyenge urrkapetyeke. Arrangkwe-arle! Ayenge-arle apetyeke tyerrtye areyeke urrkapetyeke, ingkirrekeke ilwetyeke Ngkarte-arle atnerte ulthelhetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Apententye akngerre Jesus-kenhe areye anteme apmere Jericho imperlte-alhemele alheke, tyerrtye atningke anthurrele anteme itnenhe apentewarreke. ");
INSERT INTO aer_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Itne arerrirreke artwe alknge pwenge atherre iwerre iterele anerle-anerrerlenge. Ratherre aweke arrpenhe areye angkerrerlenge nhenge Jesus Nazareth-arenye-arle apetyeme. Ratherre arlkemele angkeke, “Jesus-aye. David-eke-artweye, ilerneke apeke alhwarrpe awelhaye ilernenhe mwerre-ilemele mpwaraye.” ");
INSERT INTO aer_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tyerrtye areyele renhe-atherrenhe ntertelhe-ileke, “Nterte-irraye.” Kenhe ratherre akenhe awethe anteye-arle arnterre anthurre arlkerlenge, “Jesus-aye, David-eke-artweye, ilerneke apeke alhwarrpe awelhaye ilernenhe mwerre-ilemele mpwaraye.” ");
INSERT INTO aer_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Kele Jesus ngkernelhemele renhe-atherrenhe apayuthneke, “Iwenheke-ame unte atyenge ahentye-aneme mpweleke mpwaretyeke?” ");
INSERT INTO aer_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ratherre akenhe angkirtnerlenge, “Akngerrepataye! Alknge altywere-ilaye ilerne aretyeke.” ");
INSERT INTO aer_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesus pwenge ikwere-atherre alhwarrpe-irreke, re alknge ikwere-atherrenhe anpeke, alkngampelhe-ileke-iperre, iparrpe anthurre arerle-anerreke ratherre Jesus apenterle-anerreke iwerrele alhetyeke. ");
INSERT INTO aer_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesus, apententye akngerre ikwerenhe areye-akerte apetyemele, itne itwe-irretye-alheke apmere Jerusalem-eke, itne apmere nhenge Apwerte Olive areye-akerte arritnyeke irretye-alheke, yanhe ikwerenge-ntyele itne apmere Bethphage areke. Jesus-ele yerneke apententye akngerre atherre arrwekele alhetyeke, ");
INSERT INTO aer_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","ikwere-atherre angkeke, “Apmere Bethphage nhakwe-werne alherraye, mpwele irrpenhe-irremele aretye-alherremele tangkeye menhenge atherre arneke-arleke ayerneke-arle iwerrele tnerle-anerrerlenge, yanhe atherre irlwemele atyenge-werne akngetyetyeke. ");
INSERT INTO aer_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Kenhe tyerrtye angwenhele apeke mpwelenhe apayuthneme, ‘Iwenheke-ame mpwele tangkeye yanhe atherre akngerle-anerreme?’ Alakenhe ilerle-anerraye, ‘Ngkarte Anwerneke-artweye-arle ikwere-atherre ahentye-anemeke. Re renhe-atherrenhe iparrpe anthirtnetyenhe.’” ");
INSERT INTO aer_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Angkentye nhenhe tangkeye-akerte angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre Zechariah-le-arle intelhe-ileke Pipe-nge arrule anthurre. Angkentye nhenhe arratye anthurre-arle aneme: ");
INSERT INTO aer_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Angkentye antekelhe-ilaye apmere Jerusalem-arenye areyeke, ‘Araye! Alartetye arrekantherrenhe apetyerlenge, re tnakelhetyakenhe. Re apetyeme tangkeye-nge, tangkeye akweke ulkereke antyerle-alhemele.’” ");
INSERT INTO aer_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Kele ratherre apmere-werne-atheke arnpenheke, mpwaretyeke iwenhe Jesus-elarle ileke. ");
INSERT INTO aer_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ratherre tangkeye renhe-atherrenhe Jesus-werne akngetye-alperreke. Mantere ikwere-atherrenhe ilywelhe-ilemele tangkeye akweke ikwere artepeke-arleke arrernerle-anerreke. Jesus tangkeye akweke-ulkereke-arleke antyerle-alheke. ");
INSERT INTO aer_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tyerrtye arrpenhe atningkele-arlke mantere itnekenhe ilywelhe-ilerrirremele antekelhe-ilemele iwerreke, arrpenhe areyele walye areye akemele iwerreke antekelhe-ilemele, Jesus ikwere arrwekele rarle alhetyenheke. Alakenhe re itne ikwere akangkentye renhe imernewarreke. ");
INSERT INTO aer_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Nhenge arrwekele areye alherlte-apetyame, ingkernele areye-arlke alhetyame arlkerlte-apetyeme angkemele, “Yewe, Ngkarte, artwe nhenhe arntarnte-araye unte-arle yerneke. Renhe impaye akngerrepate anemele anwernenhe arntarnte-aretyeke arrenge arrwekelenye David-ele-arteke. Yewe, Ngkarte kwenhe mwerre anthurre!” ");
INSERT INTO aer_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Kele re Jerusalem-eke-arteke irremele tyerrtye areye apatewarreke, itne ikwere-werne untemele arlkemele, apayuthnerreke itne-arrpe, “Angwenhe-ame nhenhe?” ");
INSERT INTO aer_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Nhenge tyerrtye areye Jesus-nge Jerusalem-werne apetyewarreke, itneke angkirtnemele, “Artwe nhenhe Jesus, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre-arle, apmere Nazareth-arenye, apmere akngerre Galilee-nge.” ");
INSERT INTO aer_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Kele Jesus yarte tyatye Jew-kenheke irrpenheke imerte aremele tyerrtye areyele arne arrpe-anenhe areye sell-eme-ilerlenge arrpenhe areyeke. Kele re table areye nthenhele-arle itne mane antherrerlenge re irtwakeke, chair-arlke itnekenhe nthenhele-arle itne thipe mperlkere-arlke-arle sell-eme-ileke. ");
INSERT INTO aer_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Re anteme itneke angkeke, “Iwenhe-arle pipe-le intelhe-ileke akwete-arle tneme, Ngkarte alakenhe angkeke, ‘Tyatye atyinhe, atyinhe akwete anetyeke-aye, tyerrtye areye atyenge angkerlte-anetyeke, ayenge utyernemele tnakewarretyeke.’ Kenhe arrantherre akenhe maneke ntyelhe akngerre-arle tyatye nhenheke irrperreke kele, mane inemele tyerrtye arrpenhe areye-ngentyele. Apmere nhenhe arrantherre akenge mpwaremele apmere anyelkngalthe areye-kenhe-arteke mpwaremele.” ");
INSERT INTO aer_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Kele imerte pwenge areye uthene inwerre areye uthene ikwere-werne apetyewarreke, tyatye Jew-kenhe yanhe ikwere-werne, re itnenhe angkwerre-iwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Tyatye Jew-kenhe nhenge ikwerele ampe areyele renhe utyernemele tnakewarretyame, alakenhe angkerrirremele, “Renhe impaye akngerrepate anetyeke anwernenhe arntarnte-aretyeke arrenge arrwekelenye David-ele-arteke!” Nhenge kwertengerle akngerrepate tyatye-arenye areyele, angkentye akaltyele-anthenhe-anthenhe areyele-arlke ampe itnenhe awemele Jesus renhe utyernerlenge tnakewarrekele, renhe areke rlkerte areye angkwerre-iwerlenge, itne ahele anthurre awelheke. ");
INSERT INTO aer_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Itne ikwere angkeke, “Unte ampe nhenhe areye ntertelhe-iletyeke. Unte apeke itnenhe awetyakenhe ngenhe utyernemele tnakewarrerlenge.” Jesus akenhe itneke angkirtnerlenge, “Yewe, the itnenhe aweme. Arrantherre apeke angkentye Pipe-ke akutne, alakenhe angkerlenge, ‘Ngkarte, unte ampe-arlke, ampe akweke areye-arlke akaltyele-antheke itne Ngenhe arratye utyernemele tnaketyeke!’” ");
INSERT INTO aer_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Kele-arle re angkeke iperre Jesus, apententye akngerre areye-arlke alheke Jerusalem-engentyele apmere Bethany-werne yanhe ikwerele itne inteke. ");
INSERT INTO aer_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ingwe arrpenhele intemele arlte arrpenhele anteme, akeme-irremele alherlte-iweke Bethany-ngentyele apmere Jerusalem-werne-atheke. Itne alherlte-iwemele Jesus angayakwe anteme-irreke. ");
INSERT INTO aer_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Re areke arne utyerrke apurte-apurte iwerrele tnerlenge. Re alheke merne anngeke uyarne areke arlkwetyeke, arlpelhe-ante ikwerele, re arne ikwere angkeke, “Arrpenheke arrangkwe merne arlkwetyeke ngkwengenge urreke, akwete-ante unte merneke arrangkwe tnetyenhe!” Iparrpe anthurre arne re antyerrke-irreke. ");
INSERT INTO aer_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Apententye akngerre Jesus-kenhe areyele aremele nthakenhe-arle-irreke, itne apatewarreke, renhe apayuthnemele, “Nthakenhe-ame utyerrke nhenhe iparrpe antyerrke-irreke?” ");
INSERT INTO aer_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Re itneke angkirtnerlenge, “Ayenge arratye angkeme, arrantherre itirreme rarle arratye anetyenhe, arrantherre arne utyerrke ikwere angketyeke, ayenge-arle angkeke-arteke, kenhe re antyerrke-arle-irrerlenge. Arrantherre apeke apwerte akngerre yanheke angketyeke, ‘Akeme-irraye, unte-arrpe kwatye alayeke iwelhaye!’ Apwerte yanhele arrenhantherrenhe awetyenhe, re akeme-irremele kwatye alaye kwene-werne iwelhetyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Kele arrantherre ingkirreke apeke itirreme Ngkartele-arle renhe arrenhantherrenhe arratye anthetyeke, kele arrantherre apeke renhe apayuthneme nhenge arne iwenhe ikwere apeke, kenhe Re arrenhantherrenhe antherlenge-arle.” ");
INSERT INTO aer_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesus-kenhe areye arratetye-alheke Jerusalem-eke, Jesus tyatye akngerre Jew areye-kenheke irrpenheke tyerrtye areye akaltyele-anthetyame. Kenhe kwertengerle akngerrepate tyatye-arenye areyele-arlke, akaltyele-anthenhe-anthenhe areye-arlke, apmereke-artweye areye-arlke, artwe ampwe arrpenhe areye-arlke ikwere-werne alhemele renhe apayuthneke, “Angwenhele-ame akngerrepate anthurrele-arle ngkwenge ileke mane-akerte artwe akngerrepate nhenge ingkirreke aywepetyeke apmere nhenhenge-ntyele? Anwerneke ilaye!” ");
INSERT INTO aer_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Kenhe Jesus akenhe itneke angkirtnerlenge, “Awerrirraye, the arrenhantherrenhe apayuthneme, arrantherre atyenge iletyenhenge, kele anteme the arrekantherre iletyenhenge angwenhele ayenge alartetye arrerneke. ");
INSERT INTO aer_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Angwenhele apeke John kwatyeke akwernentye akngerre renhe ileke tyerrtye itnenhene kwatyeke akwernetyeke baptise-eme-iletyeke? Ngkartele apeke, artwe arrpenhele apeke? Atyenge ilerrirraye.” Kenhe itne Jesus renhe awerrirremele angkerlenge, itne angkerreke, “Anwerne ikwere angkerrirretyakenhe Ngkartele-arle renhe ileke, tyerrtye itnenhene kwatyeke akwernetyeke, rarle anwernenhe apayuthnetyenhe-ketye, ‘Iwenheke-ame arrantherre ikwere akangkwe-irretyakenhe?’ ");
INSERT INTO aer_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Kenhe anwerne ikwere alakenhe angkerrirretyakenhe, ‘Artwe arrpenhele-arle renhe ileke-arle tyerrtye itnenhene kwatyeke akwernetyeke,’ arrpenhe itne apeke anwerneke ahele-irrerirretyenhe-ketye apwertele atwerrirretyenhe itne-arle itirrewarrerlenge John-arle angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre-arle aneke. Kele nthakenhe-ame anwerne angkerrirreye?” ");
INSERT INTO aer_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Alakenhe ikwerenge anteme itne Jesus-eke angkirtnewarreke, “Anwerne akutne. Angwenhele-ame John ileke tyerrtye itnenhene kwatyeke akwernetyeke?” Kenhe Jesus re akenhe itneke angkirtnerlenge, “Arrantherre ayenge tyernewarretyakenhe, kenhe the akenhe arrenhantherrenhe tyernirtnetyakenhe arrekantherre ilemele angwenhele-arle ayenge alartetye anetyeke arrerneke, arne nhenge areye mpwaremele.” ");
INSERT INTO aer_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Kele Jesus angkeke kwertengerle tyatye-arenye areyeke, alakenhe, “Urrekaye the angkentye artemele arrekantherre iletyenhenge, kele arrantherre awerrirremele atyenge iletyeke nthakenhe arrantherre itirrewarreme. Artwe kenhenge atherre-akerte, alere akngerrepateke angkeke, ‘Akngerrepate atyinhe-aye, unte alhemele urrkapetyeke garden merne annge areye-akerte anwerne-kenhe-werne.’ ");
INSERT INTO aer_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Kenhe alere akngerrepate re angkerlenge, ‘Arrangkwe! Ayenge ahentye kwenye-arle.’ Kele ingkerne ante anteme re itirreke urrkapetyeke alhetyeke, imerte urrkapetyeke alhemele garden ikwere-werne. ");
INSERT INTO aer_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Akngeye re imerte alere ingkernenye ikwerenheke anteme alakenhe angkemele, ‘Garden-werne urrkapetyeke alhaye.’ “Ingkernenye re akenhe angkirtnerlenge, ‘Yewe, ayenge alheme urrkapetyeke.’ Ikwerenge akenhe re alhetyakenhe urrkapetyeke.” ");
INSERT INTO aer_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Kele Jesus-ele angkentye renhe-arle ileke iperrele itnenhe apayuthneke, “Alere angwenhe-ame aywerrkele akangkwe-irremele alhemele mpwareke akngeye ikwerenhele renhe ilekenge?” Itne imerte angkirtnemele, “Alere akngerrepatele.” Re anteme itneke angkeke, “Yewe, the arrekantherre arratye ileme, Ngkarte akngerrepate irretyenhe mane inenhe-inenhe government-eke areye, arelhe artwe arrpenhe arrpe-anenhenge intentye akngerre areyenge maneke, itnenhe arntarnte-aretyenhe. Kenhe arrantherre akenhe ingkerneke-arle iwerle-alhetyenhe, rarle arrekantherre akngerrepate irretyakenhe, arntarnte-aretyakenhele. ");
INSERT INTO aer_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Arrekwele-arle John kwatyeke akwernentye akngerrele arrenhantherrenhe ilekeke Ngkarteke arratye-arratye anetyeke, arrantherre akenhe renhe irlpe artepele awerlenge, ikwere akangkwe-irretyakenhe-arle. Kenhe mane inenhe-inenhe areyele renhe awemele, arelhe maneke artwe arrpenhe arrpe-anenhenge intentye akngerre areyele-arlke awemele, itne renhe awemele ikwere akangkwe-irreke imerte akurne-ketye untyeme-irremele anteme. Kele arrantherre areke itne-arle akangkwe-irremele akngarte-anteme-iwelhelenge kele arrantherre akenhe awelhetyakenhe-arle akngarte-arlke-iwelhetyakenhe-arle.” Alakenhe-arle Jesus angkeke kwertengerle tyatye-arenye akngerrepate areyeke artwe ampwe akngerrepate areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus-ele angkentye alengkiwentye arrpenhe itneke ileke, alakenhe: “Apmere arrule re, apmereke-artweye anyentele arne kripethe areye kele ngkerneke. Re arrkngerte ngkerneke itepe arrpe-anenhele, iperte atnyeke nhenge kripethe itnenhe ingkele arterte-ileme ngkwarle mpwaretyeke. Re apmere arlpentye akngerre arteke nhenge re akertne-ngentyele arerle-anetyenhenge tyerrtye areyele-arle merne anyelkngele ineketye. Urreke re apmere arrpenhe-werne alhetyenhenge, re merne ngkernentye akngerre ikwerenhe artwe arrpenhe itnenhene antherle-alheke ikwere arntarnte-aretyeke. Kele imerte re apmere ikwerenhe-ngentyele impemele apmere arrpenhe ikwere-werne alhemele urrekeke-atwetye anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Kenhe urreke kripethe yanhe areye amangkemele mpenge-irrerlenge, artwe apmere yanheke-artweye re urrkapentye urrpetye ikwerenhe yanhe ikwere-werne yernirtneke. Alartetyele anteme urrkapentye areye yerneke kripethe akngetye-alpetyeke akwele, akalkelhe-ilekenge ikwerenhe akwele. ");
INSERT INTO aer_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Kenhe mpwarentye akngerre yanhe areyele itnenhe arnarewarremele itneke-werne-atheke apetyerlenge itnenhe anteme anyente arntirrkwewarremele renhe atwerrirreke, kenhe arrpenhe renhe irrerlknge atweke, arrpenhe renhe apwerte areyele atweke. ");
INSERT INTO aer_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Kenhe artwe kripethe ngkernentye akngerre yanhe ikwere-artweye re awethe-arle artwe arrpenhe areye anteme yernirtneke. Kenhe mpwarentye akngerrele itnenhene anteme arntirrkwewarremele anthurre atwerrirretyeke anteye. ");
INSERT INTO aer_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Kele imerte, artwe kripethe ngkernentye akngerre yanheke-artweye re-arrpe angkemele, ‘Iwenhe-ame the mpwaretyenhe? Atyinhe anyente-arle, the apeke renhe yernemere-artaye, itne apeke renhe awerrirretyenhenge atwerrirretyakenhele.’ Kele renhe yerneke. ");
INSERT INTO aer_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Kenhe mpwarentye akngerre areyele akenhe renhe arnarewarremele itneke-werne-atheke apetyerlenge, itne-arrpe angkerreke, ‘Yanhe araye, alere apmereke-artweye-kenhe nhenhe-werne apetyerlenge. Anwerne renhe irrerlknge atwerrirreye, kele anwerne imerte ahelhe nhenhe ikwerenge rakewarremele!’ ");
INSERT INTO aer_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kele itne renhe arntirrkwewarremele apmere merne ngkernentye akngerrenge-ntyele aketheke iwerrirremele renhe irrerlknge atwerrirreke.” ");
INSERT INTO aer_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Ikwere iperrele Jesus-ele itnenhene apayuthneke, “Iwenhe-ame artwe apmere yanheke-artweyele mpwaretyenhe urrkapentye akngerre areyeke re apmere ikwerenhe-werne apetyalperlenge?” ");
INSERT INTO aer_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Itne angkirtnerlenge, “Re apetyemele akurne anthurre yanhe areye irrerlknge atwetyenhe. Ikwere iperrele re mpwarentye akngerre arrpenhe itnenhene kripethe ngkernentye akngerre renhe anthetyenhe itne arntarnte-aretyeke, merne kripethe mpenge-irrerlenge itne renhe anthirtnetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Kenhe Jesus re akenhe itnenhene aremele angkeke, “Mwantye itirrewarraye nthakenhe-arle Payepule ikwerele atyenge-akerte angkeme: ‘Kenhe apwerte renhe-arle urrkapentye akngerre itne akethe-werne iwerrirreke, kenhe arrpenhe areyele akenhe apwerte nhenge apmere anthurreke arrerneke, apwerte nhenge arrpenhe ingkirrekenge mwerre akngerre anthurre ulkere aneke! Ngkartele apwerte renhe akngakemele yanhe ikwere arrerneke, anwerne angketyame, “Re tnerle-aneme yanhe ikwerele arratye mwerre akngerre anthurre.” ’ Alakenhe itne Payepule-nge intelhe-ileke.” ");
INSERT INTO aer_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Kele Jesus anteme akngerrepate areyeke angkeke, “Alakenhe angkentye Ngkarte-kenhe angkeme: ‘Ngkarte akngerrepate arrekantherrenhe anetyakenhe, arrenhantherrenhe arntarnte-aretyeke arrangkwe. Re anteme arrpenhe areyeke Alartetye anetyenhenge, nhenge areye ikwere aywerrkele akangkwe-irreme warrke ikwerenhe mpwaretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Tyerrtye apeke-arle apetyetyenhenge. Apwerte yanhele anteme renhe tyelpelhe-ileme atnyetyeke mpwaretyenhenge. Kele ngkwerne ingkirreke ikwerenhe ultake-arle-lheme. Kele apwerte re apeke tyerrtye arrpenheke-arleke-arle atnyeke iperre, imerte tyerrtye renhe ngkweltye-arle-ilemele.’” ");
INSERT INTO aer_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Kenhe nhenge Pharisee akngerrepate areyele kwertengerle akngerrepate tyatye-arenye areyele awerrirremele angkentye-arle Jesus-ele ilekenge kripethe ngkernentye akngerreke-artweye ikwere-akerte, kenhe itne akenhe itelarerrirreke re itneke-akerte-arle angkeke. ");
INSERT INTO aer_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kele imerte itne ikwere itirrewarremele nthakenhe renhe arntirrkwewarretyeke. Kenhe tyerrtye arrpenhe areye akenhe itne itirrewarreke Jesus-arle angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre-arle. Alakenhe ikwerenge-ntyele akngerrepate yanhe areye atere-irrerirreke renhe imperrirremele arrpenhele itnenhene atweketye. ");
INSERT INTO aer_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Awethe Jesus-ele angkentye alengkiwentye arrpenhe ileke alakenhe, ");
INSERT INTO aer_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ngkarte tyerrtye areyeke alartetye irrerlenge itnenhe arntarnte-aremele, alakenhe-arle anetyenhe: Artwe anyente aneke apmere arrpe-anenheke akngerrepate-arle, kenhe alerikwele akenhe anewe aketyeke anteme-arle aneke. Kele alartetyele urrkapentye akngerre ikwerenhe areyeke ileke merne-arlke kere-arlke akngerre itetyeke. Re antangkeke atyewe ikwerenhe areyeke-arlke apetyetyeke apurte-irremele merne arlkwetyeke alere ikwerenhele-arle anewe akekenge. ");
INSERT INTO aer_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Kele alartetyele areke kele-arle merne-arlke kere-arlke itekenge anteme re urrkapentye akngerre ikwerenhe areye yerneke alhetyeke tyerrtye areyeke antangketyeke, rarle kele ileke areyeke. Nhenge itne apetyewarremele, apurte anteme anemele merne arlkwetyenhenge. Kele itne alheke itnenhe ikngwetyeke. Kenhe ingkirrekele awemele akenhe itne apetyetyakenhe-arle anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Kele imerte re urrkapentye akngerre arrpenhe areye anteme-arle yernemele tyerrtye itnenhe ikngwetyeke apurtele merne arlkwetyeke. Itne imerte alhemele itneke angkemele, ‘Apetyewarraye! Alartetye anwerne-kenhele merne-arlke kere-arlke akngerre mpwarekeyaye, pweleke akngerre areye uthene pweleke akweke areye uthene kere tyelke mwerre anthurre-akerte. Re kwenhe ingkirreke iteke arrantherre apetyemele arlkwetyeke. Kele apetyewarraye akangkemele anwerne arlkwetyenhenge.’ ");
INSERT INTO aer_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Kele arrpenhe areyele akenhe itnenhe irlpe artepele awemele, arne itnekenhe akwete mpwarerlte-anerlenge, arrpenheme areye garden itnekenhe-werne alperlte-iweke, arrpenheme areye akenhe urrkapetyeke-ante-arle alperlte-iweke mane awethe mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Kele arrpenhe areyele akenhe urrkapentye akngerre alartetyele-arle yerneke areye arntwirrkemele anthurre-arle atwerrirreke ilwetyeke-ante. ");
INSERT INTO aer_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nhenge alartetyele awemele atwerre-arle-irreke-akerte re ahele anthurre irreke. Re thultye areye ileke alhetyeke. Itne alhemele tyerrtye itnenhe atwerrirreke imerte apmere itnekenhe urele itemele ngkweltye-ilemele. ");
INSERT INTO aer_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Alartetye anteme urrkapentye akngerre ikwerenhe areyeke antangkemele imerte ilemele, ‘Awerrirraye, the merne-arlke kere-arlke akngerre anthurre itekeyaye. Kele tyerrtye areye tharle ikngweke apetyetyeke akenhe itne ayene-ilelherlenge apetyetye-kwenye. ");
INSERT INTO aer_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Apmere arrpenhe-werne alhemele anteme arrantherre apeke aremele tyerrtye iwerrele untherlte-anerlenge itnenhe-arlke ikngwaye apetyetyeke merne akngerre arlkwetyeke.’ ");
INSERT INTO aer_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kele itne alhemele tyerrtye iwerre iterele-arlke-arle aneke areye akngetyeke. Arrpenheme akurne-arlke-arle akwetethe mpwareke, arrpenhe areye akenhe mwerre-arle mpwareke-arle, itne anteme apetyeke apmere alartetye-kenheke irrpemele, atningke anthurre irremele. ");
INSERT INTO aer_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Kele alartetye irrpintyemele aretyeke tyerrtye areye, re areke artwe anyente mantere angkweye-akerte. Nhenge artwele anewe akerlenge kele tyerrtye areye akenhe mantere mwerreke-arle irrperlenge imerte apetyemele anteme. Kele artwe nhenhe re akenhe mantere mwerreke irrpetyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Artwe alartetye imerte ikwere alakenhe angkemele, ‘Atyewe! Iwenhenge-ame unte mantere mwerreke irrpetyakenhe apetyeke?’ Artwe re akenhe angketye-arlke-akenhe yanhe ikwerele aneke. ");
INSERT INTO aer_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Kele artwe alartetye anteme urrkapentye akngerre ikwerenhe areyeke antangkelheke imerte itnenhe ilemele, ‘Apetyewarraye, artwe nhenhe ingkenge uthene iltyenge uthene ayernaye imerte renhe aketheke ingwemerteke iwemele, yanhele re akwete anetyeke akngerre artnemele.’ Kele itne renhe ayernemele aketheke iwerrirreke.” ");
INSERT INTO aer_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus-elarle angkentye nhenhe ileke-iperre re itneke angkeke, “Ngkartele kwenhe tyerrtye atningke anthurreke antangkeme renhe apentetyeke, kele re akenhe urrpetye ware-arle akngakeme, akangkwe-arle-irreme areye, renhe aywerrkele apentetyeke areye-ante.” Alakenhe-arle Jesus angkeke kwertengerle tyatye-arenye akngerrepate areyeke, artwe ampwe areye uthene Pharisee areye utheneke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Artwe Pharisee areye apurte-irremele angkerretyame, Jesus renhe ularele apayuthnetyeke, urrtyirremele, re apale angkemere. Itne itirrewarretyame, re apeke apale angkerlenge itne renhe arntirrkwewarretyeke imerte Rome-arenye akngerrepate iltye anthemele. ");
INSERT INTO aer_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Itne Pharisee areye, apententye akngerre Herod-kenhe areye-arlke Jesus-werne yerneke apayuthnetyeke nhenge re akwele apale angketyenhenge. Itne-arle ikwere-werne apetyewarreke-iperre ikwere alakenhe angkerrirreke, “Akaltyele-anthenhe-anthenhe-aye, anwerne itelareme unte tyerrtye ingkirrekeke akwetethe arratye angkentye akngerre. Unte akngerrepate areyeke-arlke akwenpe anthurre angkenhe-angkenhe. Unte-arle angkentye arratye Ngkarte-akerte itneke ileme. Kele arratye mwerre-arle. ");
INSERT INTO aer_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Nthakenhe-ame unte itirreme? Kele mwerre-arle anwerne apeke tax mane artwe akngerrepate Caesar anthetyeke? Nthakenhe-ame anwerne irreye?” ");
INSERT INTO aer_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Kele Jesus-ele itelareke itne-arle renhe ularele ware apayuthnetyame, re imerte itneke alakenhe-arle angkemele, “Arrantherre kwenhe tyerrtye urrtyirremele ware-arle anerlte-aneme mwerre akwele. Iwenheke-ame arrantherre ayenge urrtyirremele apayuthneme? ");
INSERT INTO aer_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Atyenge-werne mane ngkweltye anyente akngetyaye, arrantherre-arle Caesar renhe anthemenge, the renhe aretyeke.” Itne arratye akngetyemele renhe antheke. ");
INSERT INTO aer_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Mane ngkweltye areke-arle iperre, Jesus-ele itnenhe apayuthneke, “Inngerre-arlke arritnye-arlke angwenhe-kenhe-ame ngkweltye ikwerele aneme?” ");
INSERT INTO aer_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Kenhe itne ikwere angkirtnerlenge, “Artwe nhenge Caeser.” Awethe Jesus itneke angkeke, “Arne areye Caesar-kenhe renhe anthirtnewarraye. Kenhe iwenhe apeke renhe Ngkarte-kenhe, Renhe anthirtnewarremele.” ");
INSERT INTO aer_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Kenhe itne Jesus renhe awerrirreke angkerlenge itne apatewarremele nthakenhe-irretyeke itirrewarreke. Kele itne ikwerenge-ntyele alheke. ");
INSERT INTO aer_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Arlte yanhe ikwerele tyerrtye arrpenheme Sadducee areye Jesus-werne apetyewarreke. Nhenhe areye angkerrirretyarte Ngkartele-arle akwele tyerrtye ilweke-arle-ngentyele itethe-ilirtnetyakenhe-arle. Itne renhe apayuthnerrirreke, ");
INSERT INTO aer_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Akaltyele-anthenhe-anthenhe-aye, arrule artwe Moses-ele pipe-ke intelhe-ileke anewenhenge angwenhe apeke ikwere-atherre-akerte. Kele artwe apeke ampeke arrangkwe akwete ilwerlenge, kenhe atyeyikwe re anteme-arle warlekwerte renhe anewe aketyeke, anewenhenge atherrele ampe atnyenetyeke kikweke. ");
INSERT INTO aer_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kenhe lyete anwerne angkentye kenhenge-nhenge seven pele-akerte ngkwenge ileme. Kenhe artwe atyeyenhenge areye amangkemele akngerre-irrerirremele, meye uthene akngeye uthene anyente-ngentyele. Kenhe kake akngerre akenhe anewe akemele ampeke arrangkwe akwete-arle ilweke. ");
INSERT INTO aer_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Kenhe atyeyikwe re anteme-arle arelhe warlekwerte renhe anewe akeke, kele imerte re anteme-arle ampeke arrangkwe ilwemele. Kele anyenteke-anyentele atyeyikwe yanhe areyele arelhe warlekwerte yanhe renhe anewe akeke, kele imerte itne anyenteke-anyente anteme ilwerrirremele, ampeke arrangkwe akwete. ");
INSERT INTO aer_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kele ikwerenge-ntyele, arelhe yanhe re anteme-arle ilweke. ");
INSERT INTO aer_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kenhe urreke re akenhe, Ngkartele itnenhene itethe-ilintye-alpetyenhe, kenhe anewe angwenhe-kenhe-arle-ame arelhe re anetyenhe? Anwerneke ilaye.” ");
INSERT INTO aer_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesus itneke angkirtnerlenge, “Arrangkwe, arrantherre untyeme itirreme, akutne iwenhele arrule intelhe-ileke-akerte Payepuleke. Arrantherre akutne Ngkarteke nhenge arne iwenhe apeke renhe ngangkerele mpwareme-arleke. ");
INSERT INTO aer_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Kenhe tyerrtye areye akenhe ilwemele itethe-irrirtneke-iperre, anewe akerretyakenhe anetyenhe. Itne utnenge alkere-arenye areye-arteke alkerele anetyenhe, anewe akerrentye akngerre kwenye. ");
INSERT INTO aer_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","“Arrantherre ayenge apayuthnerrirreke Ngkartele-arle tyerrtye areye itethe-ilirtnemeke apeke ilweke-arle-iperre? Arrantherre-ame angkentye nhenge itelarerrirreme nhenge Ngkarte-arle Moses-eke angkeke, Abraham, Isaac, Jacob-arlke-arle apmere arrule ilwekenge, ");
INSERT INTO aer_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ayenge Ngkarte, Abraham, Jacob, Isaac-elarle utyernemele tnakewarreme akwete. Kenhe ilweke-arle areyele ayenge utyernemele tnaketyakenhe-arle. Kenhe itethe areyele ayenge utyernemele tnakewarreme akwete.’ Abraham, Isaac, Jacob arrule anthurre ilweke, urreke Moses intetyenhenge, kenhe Ngkarte angkerlenge itne-arle renhe utyernemele tnakewarreme akwete-arle!” ");
INSERT INTO aer_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Kele renhe-arle awerrirreke iperre, itne apatewarremele nterte anthurre irrerirreke anteme. ");
INSERT INTO aer_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Kenhe Pharisee areyele awerrirreke Jesus-ele Sadducee itnenhe ntertelhe-ilerlenge, itne apurte-irrerirreke Jesus apayuthnerrirretyeke. ");
INSERT INTO aer_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","36","Kele artwe anyente itnekenge aneke, angkentye Moses-kenhe akaltyele-anthenhe-anthenhe, re Jesus ularele ware apayuthneke nthakenhe-arle re angketyenhenge alakenhe, “Ngkartele anwernenhe angkentye atningke akaltyele-antheke, angkentye iwenhe-ame akngerre-ulkere?” ");
INSERT INTO aer_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesus ikwere angkirtneke, “Unte Ngkarteke-ante ware ahentye-anetyeke atyepe-atyepe. Ikwerenge untyeme-irretyeke arrangkwe. Ikwere-ante ware urrkaperle-anetyeke atyepe-atyepe! ");
INSERT INTO aer_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Angkentye nhenhe arrpenhenge arrekwele aneme, angkentye nhenhe arrpenhe areyenge impene-ulkere. ");
INSERT INTO aer_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Angkentye akngerre arrpenhe akenhe alakenhe-arle aneme: Arrpenhe areyeke ahentye-anetyeke, ngkwenge-arrpe-arle unte ahentye-aneme-arteke. ");
INSERT INTO aer_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Arrantherre apele Ngkarteke ahentye-anetyeke atyepe-atyepe, arrpenhe areyeke ahentye-anetyeke, ngkwenge-arrpe-arle unte ahentye-aneme-arteke, arrantherre angkentye arrpenhe ingkirreke aywerrkele apentewarretyenhe-arle, angkentye nhenge areye Moses-elarle, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areyele-arlke-arle anwernenhe akaltyele-antheke.” ");
INSERT INTO aer_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Pharisee areye yanhele akwete anerlenge, Jesus-ele itnenhe apayuthneke, ");
INSERT INTO aer_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Artwe nhenge Ngkartele-arle alhileke, nthakenhe-ame arrantherre itirrewarreme ikwere-akerte? Re-ame angwenhe-kenhe arrwekelenye-ngentyele?” Itne ikwere angkirtnerlenge, “Artwe nhenge Ngkartele-arle alhileke, rarle David-eke-artweye-ngentyele aneme.” ");
INSERT INTO aer_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Kele Jesus-ele itnenhene awethe apayuthnemele, “Arrule anthurre, David itethe akwete anerlenge, Utnenge Akngerrele ikwere ileke artwe nhenge-akerte Ngkartele-arle alhileke-akerte, rarle renhe ileke, “Akngerrepate atyinhe.” Nthakenhe-arle-ame David-ele renhe Alartetye akeke? ");
INSERT INTO aer_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Arrantherre itelareme, David Alartetyele-arle pipe-ke intelhe-ileke ikwere-akerte alakenhe: ‘Ngkarte Alartetye atyinheke angkeke, “Unte atyenge itweke arrernelhaye atyengenge alartetye anetyeke, tharle tyerrtye yanhe areye ngkwenge ahentye-kwenye areye ingke ngkwinhenge kwene-iletyenhenge, kele itne ngkwenge akangkwe-irretyenhenge.” ’ ");
INSERT INTO aer_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Arrantherre apeke itelarerrirreme? David angkeke artwe nhenge Ngkartele-arle alhileke-arle, alartetye ikwerenhe aneme. Nthakenhe-arle-ame artwe re urreke-arle apetyetyenhe David-engentyele uthene anetyenhe? Rarle David-engentyele aneke-iperre, re alartetye ikwerenhe-arlke aneme. Artwe nhenge Ngkartele-arle alhileke David-enge awethe arntwarre-arle.” ");
INSERT INTO aer_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Itne ikwere angkirtnetyakenhe, arrangkwe-arle. Kele itne nterte anthurre irrerirreke anteme. Itne atere-irrerirreke renhe awethe apayuthnetyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Yanhe-ngentyele Jesus angkeke apententye akngerre ikwerenhe areyeke tyerrtye arrpenhe yanhele-arle aneke areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Arrantherre itelareme angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye-arlke, Pharisee areye-arlke-arle Ngkartele akngakeke Jew areye arrenhantherrenhe angkentye Moses-kenhe akaltyele-anthetyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Alakenhenge anteme itne apeke angkerlenge, arrantherre kwenhe itneke akangkwe-irretyeke imerte aywerrkele mpwaremele iwenhe-arle itne angkeme. Kele itnenhe angwaretyale anetyeke iwenhe apeke-arle itne mpwareme. Nhenge itne apeke arratye-arratye-arlke akaltyele-antherlenge yanhe areye-arle itne-arrpe arratye mpwaretyakenhe-arle. ");
INSERT INTO aer_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Itne akwetethe-arle itirreme arne arrpe-anenheke tyerrtye arrpenhe areyele mpwaretyeke itnenhe akwetethe-arlke uternemele arne itnenhe mpwaretyeke. Kele itne tyerrtye yanhe areye aremele, itnenhe alpe-eme-iletyeke arrangkwe-arle. Nhenge alartetyele-arle urrkapentye akngerre ikwerenhe uternemele-arteke arne ulthentye akngernetyeke re-arrpe. Nhenge re-arrpe uyarne akemelhe-ilemele akertne-iletyeke anyentele, alartetyele renhe akwenpele-arle arerle-aneme. Alakenhe anetyale anetyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Alartetye yanhe areyele akenhe arne arrpe-anenhe-arle mpwareme nhenge tyerrtye arrpenhe areyele akwele itnenhe aremele tnaketyenhenge akwele. Itnenhe arerrirraye! Arrantherre-ame areme arne akweke yanhe areye itne-arle akngerneme amultele-arlke urlele-arlke? Itne anteme pipe angkentye Moses-kenhe-akerte ayerneke imerte arne akweke yanheke akwerneke. Itnenhe arerrirraye! Itne mantere arlpentyeke irrpemele untherlte-aperlenge tnakelhemele, itnenhe akwele tyerrtye areyele aretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Kele itne imerte tyatye itne-kenheke apurte-irremele, apurtele apeke merne akngerre arlkwemele, itne chair impene anthurre areye-arle akngakeme, chair nhenge areye tyerrtye akngerre areyeke, tyerrtye areyele aretyenhenge itnenhe akwele tnaketyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nhenge itne alhemele merne uthene kere uthene inetyeke, itne arnterre anthurre-arle akangkemele tyerrtye arrpenhe areye itneke akaperte kwene-irrerlenge itnenhe akaltyele-anthenhe-anthenhe-arlke akerlenge. ");
INSERT INTO aer_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Kele awerrirraye! Tyerrtyele apeke arrenhantherrenhe “Akaltyele-anthenhe-anthenhe” akerlenge renhe ayakaye, arrantherre ingkirreke kake uthene yaye uthene-arle aneme alakenhe anteye-arle Akaltyele-anthenhe-anthenhe anyente aneme arrekantherre. ");
INSERT INTO aer_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Tyerrtye arrpenhe renhe “akngeye” aketyale anetyeke. Arrantherre Akngeye anyente-ante-arle atnyeneme alkere akertnele-arle anerle-aneme. ");
INSERT INTO aer_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Tyerrtyele apeke arrenhantherrenhe “akngerrepate” akerlenge, arrantherre akenhe renhe ayaketyeke-arle re arrenhantherrenhe apalele tnakeme-ketye arrekantherrenhe kwenhe Akngerrepate anyente-ante aneme, anyente nhenge Ngkartele-arle alhileke. ");
INSERT INTO aer_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Kele angwenhe apeke-arle arrekantherrenhenge atyeperre anetyeke ahentye-aneme, kele re-arrpe arrekantherre ingkirrekeke urrkapetyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Kenhe angwenhe apeke re ikwere-arrpe akngerre atniwelheme, arrpenhenge areye akngerre ulkere, urreke Ngkartele renhe ingkerne arrernetyenhenge renhe apurele-anthemele. Kenhe angwenhe apeke re tnakelhetyakenhe, kenhe ikwere-arrpe akurne-akurne itirremele, urreke Ngkartele renhe akngerre atniwetyenhe, arrpenhenge areye arrekwelenge arrernetyenhenge.” ");
INSERT INTO aer_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Kele Jesus angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye uthene Pharisee areye utheneke angkeke, “Akunye areye-aye! Arrekantherre akurne akngerre irretyenhe arrantherre-arle urrtyirrerlte-anemenge arne areye mpwarerlte-anemele. Nhenge tyerrtye areye Ngkarteke anerlte-anetyeke arrkernerlenge, arrantherre-arle arriwe metye-arteke-arle aneme, itnenhe ayakemele apmere Ngkarte-kenheke irrpenheme-ketye. Kele, arrantherre-arlke irrpenhetyeke arrangkwe-arle, kele arrantherre tyerrtye arrpenhe areye ayakeme-arle irrpenheme-ketye.” ");
INSERT INTO aer_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Kele Jesus angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye uthene Pharisee areye utheneke awethe angkeke, “Akunye areye-aye! Arrekantherre akurne akngerre irretyenhe arrantherre-arle urrtyirrerlte-anemenge arne areye mpwarerlte-anemele. Arrantherre apmere warlekwerte areye-kenheke irrpeme arne areye itnekenhe anyelkngele inerlte-anemele. Kele imerte arrantherre mwerre akwele tyatye-ke irrpemele Ngkarteke akwete anthurre angketyeke. Kele mwerre anetyakenhe-arle alakenhe, akurne-arle alakenhe! Ngkartele-arle arrenhantherre arerle-aneme alakenhe mpwarerlenge, kele re arrekantherre arne akenge anthurre mpwareme! ");
INSERT INTO aer_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Akunye areye-aye! Arrantherre angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye uthene Pharisee areye uthene. Arrekantherre akurne akngerre irretyenhe arrantherre-arle urrtyirrerlte-anemenge arne areye mpwarerlte-anemele. Arrantherre apeke apmere arrpe-anenhe-werne untherlte-apemele, apmere kwatye alayenge arntwarre apeke, apmere arlenge anthurre-werne-arlke, arrantherre tyerrtye anyente uternetyeke arrantherre-arteke anetyeke. Tyerrtye re anteme arrantherre-arteke irremele, re arrekantherrenge akurne awethe arntwarre-ulkere aneme, urreke re apmere arrentye Satan-kenhe-werne-arle alhetyenhe, arrantherre-arlke yanhe-werne ante-arle alherlte-iweme, apmere akurne urele akwetethe amperle-aneme-werne. ");
INSERT INTO aer_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Arrantherre angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye uthene Pharisee areye uthene. Akunye areye-aye! Ngkartele arrekantherre akurne anthurre mpwareme. Arrantherre-arle itelaretyakenhe-arle iwenhe arrantherre angkeme, arrantherre akaltyele-antheme akutne areye, alakenhe itneke angkemele, ‘Unte apeke tyerrtye arrpenhe arne iwenhe apeke renhe mpwaretyeke alhileme, tyatye Jew-kenhe arritnyele ilemele, kele mwerre-arle mpwaretyakenhe apeke. Kenhe unte apeke tyerrtye arrpenhe nhakweke uternelheme apwerte gold arritnyele tyatye Jew-kenhe kwenele-arle aneme yanhenge. Kele urrtyirretyale! Arrantherre arratye mpwaretyeke.’ Alakenhe-arle arrantherre itnenhe apale akaltyele-antheme. ");
INSERT INTO aer_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Itirrentye arrekantherrenhe arratye anetyakenhe. Tyatye Jew-kenhe impene anthurre aneme. Gold re akenhe impene anetyakenhe. Kenhe gold impene anteme-arle irreme, rarle tyatye akngerre Jew-kenhele anemenge ware, mwerre Ngkarteke. ");
INSERT INTO aer_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","“Arrantherre itelareme nthakenhe-arle arrantherre kere akngetyemele, kere renhe apwerte athereke-arleke ure itemele ntheke-iwemele Ngkarte anthemele, renhe tnakemele. Arrantherre awethe akaltyele-antheme alakenhe, “Unte apeke tyerrtye arrpenhe arne iwenhe apeke renhe mpwaretyeke alhileme, “apwerte athere kere ntheke-iwentye akngerre” arritnyele ilemele, kele mwerre-arle mpwaretyakenhe apeke. Unte apeke tyerrtye arrpenhe arne iwenhe apeke renhe mpwaretyeke alhileme, “kere apwerte athereke-arleke-arle arrerneke” arritnye ilemele. Kele urrtyirretyale! Arrantherre arratye mpwaretyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Itirrentye arrekantherrenhe arratye anetyakenhe! Kere nhenge apwerte athere ntheke-iwentye akngerre ikwere-arle arrerneke impene aneme. Kenhe apwerte athere ntheke-iwentye akngerre renhe kere yanhenge impene anthurre ulkere-arle, itne-arle apwerte athere ntheke-iwentye nhengele kere areye amperlenge itne Ngkarte utyernemele tnakewarretyeke. ");
INSERT INTO aer_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kere rarle impene-ante-arle irreme apwerte ikwere-arleke-arle arrernekenge ware. Apwerte athere ntheke-iwentye rarle kerenge impene anthurre ulkere-arle. Angwenhele apeke tyerrtye arrpenhe arne iwenhe apeke renhe mpwaretyeke alhileme, “apwerte athere ntheke-iwentye akngerre” kele re angkeme apwerte atherre ntheke-iwentye akngerre ikwere-akerte-arle iwenhe-arle akertnele ampeme ikwere-arlke-arle. ");
INSERT INTO aer_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Angwenhele apeke tyerrtye arrpenhe arne iwenhe apeke renhe mpwaretyeke alhileme, “Tyatye Jew areye-kenhe” arritnye angkemele, kele rarle arritnye Ngkarte-kenhele-arle alhileme, Ngkarte-arle yanhe tyatye kwenele-arle anemenge. ");
INSERT INTO aer_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Arrpenhele apeke arne iwenhe apeke renhe mpwaretyeke alhileme, “alkere akertne” arritnye angkemele, kele re alakenhe angkemele re arritnye Ngkarte-kenhele-ante-arle ileme, alkere-arle Ngkarte chair ikwerenhele anentye akngerre, ingkirreke anthurreke akngerrepate.” Alakenhe-arle Jesus angkeke angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye Pharisee areye utheneke. ");
INSERT INTO aer_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Awethe re angkeke angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyeke Pharisee areyeke-arlke, “Akunye areye-aye! Arrantherre tyerrtye urrtyirremele mwerre akwele anerlte-aneme, arrangkwe. Alakenhe ikwerenge anteme akurne akngerre arrekantherre irretyenhe! Nhenge arrantherre arne akweke areye karteneke ngkerneme itne lyaperlenge, arunthe akweke arlpelhe-akerte areye, arne akweke nhenge mint-arlke, dill-arlke, cumin-arlke. Kele imerte itneke-ngentyele arrantherre merne annge 100 akngeme, imerte akngakemele Ngkarteke 10-pele anthemele. Alakenhe nhenhe rarle angkentye Moses-kenhenge ularre. Kele mwerre-arle alakenhe arrantherre akwete mpwarerlte-anetyeke. Kenhe arrantherre akenhe angkentye impene anthurre areyeke alkngwirreke. Arrantherre tyerrtye areye arratyentye arntarnte-aretye-kwenye-arle, arrantherre itneke urrtyirreme-arle. Arrantherre itneke alhwarrpe-irretye-kwenye-arle alpe-eme-iletyakenhe-arle. Arrantherre-arle Ngkarteke akwete awerrirretyakenhe. ");
INSERT INTO aer_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Yewe, arrantherre-arle akutne-arle, artwe pwengele-arteke-arle arrantherre akngerlte-apeme tyerrtye arrpenhe areye arrantherre itelaremele-arteke, kele arrangkwe-arle. Ayenge alakenhe akwete angkeme arrantherre-arle akwete arne akweke areye alakenhe mpwarerlte-anemenge, kele arrantherre akenhe arne akngerre areye mpwaretyeke arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Akunye areye-aye! Arrantherre angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye Pharisee areye-arlke arrantherre urrtyirremele ilentye akngerre mwerre akwele anerlte-anemele. Arrantherre tnakelhentye akngerre areye! Alakenhenge-arle arrekantherre akurne akngerre irretyenhe! Arrantherre-arle itne-arteke nhenge tyampite uthene plate uthene akethe-ante urlkernemele, kwene akenhe aternnge-arle. Arrantherre arne arrpe-anenhe akethele mpwarerlte-aneme arrpenhe areyele aretyenhenge arrantherre mwerre akwele. Kele arrantherre akenhe atnure, ntyelhe-arle aneme-arle. ");
INSERT INTO aer_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Itirrentye arrekantherrenhe arratye anetyakenhe. Atnure ante ntyelhe anetyale! Kele imerte arrantherre mwerre apeke arne renhe arratye mpwaremele. Arrantherre apeke tyampite uthene plate uthene kwenele arrekwele alhewerlenge, kele itne alkarle anthurre anetyenhenge. Alakenhe arrantherre itirretyeke iwenhe-arle arrekantherrele-arlenge kwenele anemeke, akurne areye-ketye untyeme-irreme, kele yanhe-ngentyele imerte arrantherre mwerre arratye anteme anetyenhele. ");
INSERT INTO aer_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Akunye areye-aye! Angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye Pharisee areye-arlke arrantherre urrtyirremele mwerre akwele anerlte-aneme. Arrantherre tnakelhentye akngerre areye-arle! Alakenhenge anteme arrekantherre akurne akngerre irretyenhe! Arrantherre-arle tyerrtye ilweke-arle areye-kenhe iperte-arteke-arle, arrpenhe areyele mperlkere intelhe-ileke. Arrpenhe areyele iperte yanhe areye arerlenge, itne akethele mwerre aneme, kenhe kwenele akenhe tyerrtye areye-kenhe ngkwerne-ante-arle aneme, ilweke-arle arnterte-irrerlte-anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Alakenhe anthurre-arle arrantherre aneme. Tyerrtye areyele arrenhantherrenhe aremele, itne itirreme arrantherre mwerre akwele, kele arratye anetyakenhe-arle, kwene akenhe arrantherre akurne anthurre-arle. Arrantherre angkeme arrantherre-arle angkentye Ngkarte-kenhe akwele apententye akngerre, kele arrangkwe-arle, arrantherre arratyentye apentetyakenhe-arle.” ");
INSERT INTO aer_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Jesus angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areye uthene Pharisee areye utheneke awethe angkeke, “Akunye areye-aye! Arrantherre mwerre akwele anerlte-aneme. Apmere irrare nthenhele-arle, arrekantherrenhe arrekwelenye areyele angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areye artelheme, arrantherre warle impene arteme itnenhe itelaretyeke itne-arle atweke areye. Arrantherre awethe mwerre akngerre mpwareke apmere nthenhele-arle artwe arrpenhe areye Ngkarteke-arle arratye anetyarte areye artelhemenge. ");
INSERT INTO aer_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Kele arrantherre atyenge alakenhe-arle angkeme, ‘Altyerre iperre anwerne-kenhe areyele-arle angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areye-arle atweke. Kenhe anwerne apeke-arle yanhe ikwerele ureke aneke, anwerne itnenhe atwetyakenhe-arle anemere.’ ");
INSERT INTO aer_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Kele arrantherre akaltye angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areye mwerre-arle. Kenhe arrantherre angkentye atyinhe akwenpele irlpe artepele awemele, imernemele arrantherre-arle arrekantherrenhe altyerre ipenhe areye-arteke anemenge. ");
INSERT INTO aer_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Kele lyete arrantherre altyerre iperre arrekantherrenhe impatye apenterlte-anetyenhe!” ");
INSERT INTO aer_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Arrantherre-arle tyerrtye akurne anthurre aneme apmwe arrengkwelthe akurne-akerte areye-arteke! Ngkarte-ketye alengke-iwelhetyeke arrangkwe-arle. Re arrenhantherrenhe ure akngerreke-arle iweme ampetyeke! ");
INSERT INTO aer_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Awerrirraye! Ngkarte arrekantherre antangkelhetyenhe, yanhe areyeke angkentye Ikwerenhe awemele ilerle-apentye akngerre, ake altywere areye, akaltyele-anthenhe-anthenhe areyeke-arlke. Arrantherre arrpenhe areye atweme, arrpenhe areye akenhe arrantherre arne arntarlkweke-arleke irlpare arrerneme ilwetyeke, arrpenhe areye arrantherre tyatye kweneke-arle ngkerneme itnenhe whip-ele atwemele. Arrantherre itnenhe alwernerlte-anetyenhe antime apmere anyente-ngentyele apmere arrpenhe-werne-atheke. ");
INSERT INTO aer_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Alakenhenge anteme Ngkartele arrenhantherrenhe ilpernemele atwetyenhe, arrantherre-arle artwe arrpenhe mwerre areye apelkele atwekenge. Arrantherre itelareme angwenhele Abel atweke. Alakenhenge anteme altyerre iperre arrekantherrenhe areye, arrpenhe-ngentyele arrpenhe-werne-atheke, itne tyerrtye areye akwetethe atwerlte-anemele anteme, ikwerenge anteme itne Barachiah-eke alerikwe Zechariah atweke. Itne aremele renhe tyatye arrkngerte kwene-werne irrpenherlenge, renhe atwerrirreke. ");
INSERT INTO aer_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Yewe, the arrenhantherrenhe arratye alkngetherre ilemele Ngkartele arrenhantherrenhe-arlke atweme re anteme arrwekelenye areyele-arle artwe nhenhe areye atwekenge.” Alakenhe-arle Jesus angkeke angkentye Moses-kenhe akaltyele-anthenhe-anthenhe areyeke Pharisee areyeke-arlke. ");
INSERT INTO aer_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Kele Jesus alhwarrpe anthurre irremele tyerrtye Jerusalem-arenye areyeke angkeke, “Jerusalem-arenye areye-apenhe, Jerusalem-arenye areye-apenhe! Akunye areye! Kele arrule anthurrenge arrantherre angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre areye apwertele wemele atwerrirretyarte Ngkartele-arle angkentye-akerte areye-arlke yernetyarte apmere nhenhe-werne. Arrulenge-arrule ayenge ahentye-aneke arrenhantherre apurtelhe-ilemele arntarnte-aretyeke, nhenge thipe mikwele akweke ikwerenhe areye apurtelhe-ilemele arlpelhe kweneke arrernemele arntarnte-aremele-arteke, alakenhe athewe. Kele arrantherre akenhe ayenge ikwele-areke anthurre-arle. ");
INSERT INTO aer_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Lyete ware Ngkartele Temple Jew areye-kenhe arrekantherrenhe ipmentye-iwetyenhe, apmere arltwe tnetyenhe, Re awethe yanhele anetyakenhe anteme. ");
INSERT INTO aer_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kenhe ayenge apmere nhenhenge-ntyele alpeme antime, arrantherre ayenge awethe urreke arerrirretyakenhe, urrekeke-ante apeke. Kenhe urreke rarle, ayenge apetye-alpetyenhe, nhenge arrantherre ayenge arerrirremele arlkerrirretyenhele, ‘Anwerne ingkirreke alyelhewarretyekaye Ngkarte anwerne-kenhe-werne-atheke! Artwe nhenhe apele Ngkartele-arle anwerneke-werne yernekeke. Ngkarte-aye, unte-arle renhe akangkentye-ileme.’” Alakenhe-arle Jesus angkeke irrare-irremele tyerrtye apmere Jerusalem-arenye areyeke. ");
INSERT INTO aer_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Nhenge Jesus tyatye Jew areye-kenhe ikwerenge-ntyele arraterlenge, apententye akngerre ikwerenhe areye apetyeke ikwere angketyeke, “Akaltyele-anthenhe-anthenhe-aye, Tyatye mwerre akngerre yanhe araye.” ");
INSERT INTO aer_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Kenhe Jesus re akenhe itneke angkirtnerlenge, “Yewe, apmere akngerre nhenhe areye itne arteke apwerte akngerre areye-ngentyele, itne alakenhe anerrirretyakenhe-arle anetyenhe, arrangkwe anthurre-arle. Urreke rarle, tyerrtye arrpenhe areyele itnenhene ahelhe-werne-atheke atakemele ankerte-iwerrirretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Urreke, Jesus Apwerte Olive-akertele re-arrpe anetyame, apententye akngerre areye apetyemele renhe apayuthnerrirreke, “Anwerneke ilaye, ilengare-ame tyatye nhakwe renhe itne ultaketyenhe? Anwerneke ilaye, nthakenheke-amparre-arle irretyenhe nhenge anwerne akaltye anetyenhenge ilengare-arle unte apetyalpetyeke, ahelhe-arlke alkere-arlke uyerretyeke anerlenge.” ");
INSERT INTO aer_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Kenhe Jesus itneke angkirtnerlenge, “Arrantherre tyerrtye arrpenhe areye-ketye arntarnte-arelhewarraye, itne apeke arrekantherre urrtyirreme-ketye, itne apeke arrenhantherrenhe utepelhe-ilemeketye atyengenge. ");
INSERT INTO aer_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Kenhe atningke arrpenhe areye akenhe apetyewarremele, arrekantherre alakenhe apale angkerrirretyenhe, ‘Ayenge Messiah, nhenge Ngkartele-arle arrekantherre alhileke yernetyeke!’ Atningkele-arle aweke-iperrele itnenhe apentewarretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Atere-irretyale anaye nhenge arrantherre awemele thultye areye atwerrerlenge apmere arrpe-anenhele. Yanhe areyeke-amparre arrekwele irretyenhe, kenhe yanhe ikwerele ahelhe-arlke alkere-arlke uyerretyeke arrangkwe-arle. ");
INSERT INTO aer_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kenhe urreke ahelhe nhenhe uyerretyenhenge, tyerrtye apmere arrpe-anenhe-ngentyele-arle ahele uthnerremele atwerretyenhe, tyerrtye ingkirreke itne ahele uthnerretyenhe. Ikwerenge-ntyele ahelhe anteke nhenhe arrewemele irrerirretyenhe, apmere arrpe-anenhele-arlke kele merneke arrangkwe anerrirretyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Alakenhe arrekwele-arle aneke. Kenhe arne yanhe areyeke-amparre irretyenhe. Urreke ayenge apetyalpetyenhenge arne arrpenhe akurne anthurre areye-arle anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Yanhenge anteme tyerrtye areye arrekantherre anteme ahele-irretyenhe, itne thultye areye itnekenhe iletyenhe arrenhantherrenhe arntwirrkemele irrerlknge atwetyeke. Yewe, tyerrtye areye apmere arrpe-anenhe-ngentyele arrekantherre ahentye-anetyakenhe anetyenhe arrantherre-arle atyewe atyinhe anekenge. ");
INSERT INTO aer_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Yanhenge anteme atyinhe atyewe arrpenhemele ayenge-arle apenteke-iperre untyeme-irremele atyenge akangkwe-irretyakenhe anteme anetyenhe. Kenhe arrpenhemele arrpenhe itnenhe thultye areye iltye anthetyenhe itnenhe atwetyeke. ");
INSERT INTO aer_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Tyerrtye atningke urrtyirretyenhe, ilelhemele itne-arle angkentye Ngkarte-kenhe ilentye akngerre akwele. Tyerrtye atningkele awemele akangkwe-irretyenhe angkentye itnekenhe-ke imerte apale anteme alherlte-iwemele. ");
INSERT INTO aer_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Yewe, tyerrtye areye apmere arrpe-anenhe-ngentyele akurne-irretyenhe akwete akurne mpwarerlte-anemele. Tyerrtye areye Ngkarteke akangkwe-irretyakenhe, itne arrpenhe areye-ketye alhule-iwetyenhe, Ngkarte-arle awerrirremenge. ");
INSERT INTO aer_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Kele arrantherre apeke ayenge akwetethe apenterlte-anemele ilwetyeke-atwetye kele arrenhantherrenhe Ngkartele mwantyele-arle arntarnte-aretyenhe, akayake-ilemele arrantherre anteme akwete-ante Ikwerenge anerlte-anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Apententye akngerre atyinhe areyele angkentye mwerre Ngkarte-akerte ilerlte-apetyenhe, angkentye nhenge Ngkarte-akerte tyerrtye areyeke-arle akngerrepate irremele itnenhe arntarnte-aremele. Kele tyerrtye areyele-arle kele apmere arrpe-anenhenge awekenge iperre ante-arle, ahelhe uthene alkere uthene uyerretyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Kenhe Jesus awethe apententye akngerre ikwerenhe areyeke angkeke, “Urreke, arrantherre arne akurne anthurre arerrirretyenhe Tyatye nhenhe kwene ikwerele. Alakenhe ikwerenge Ngkartele tyatye renhe impetyenhe-arle, renhe arntarnte-aretyakenhe. Kenhe Daniel-ele, angkentye Ngkarte-kenhe awemele ilerle-apentye akngerrele arrule anthurre-arle nhenhe ikwere-akerte intelhe-ileke. Angwenhele apeke angkentye nhenhe read-eme-ileme, mwantye itirraye! ");
INSERT INTO aer_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Kenhe arrantherre apmere Judea ikwerele apeke aneme arne akenge areye alakenhe areye irrerlenge aremele, apwerte-werne iparrpe alherlte-iwetyeke-arle! ");
INSERT INTO aer_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Yanhe ikwerele-ureke tyerrtye anyente apeke ulyentyele apmere itweke aneme, re akenhe apmere-werne alpetyale anetyeke-arle, arne ikwerenhe areye inetyeke, urreke alwirretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Alakenhe apeke arrantherre apmere akethele urrkapemele, alpetyale anaye apmere-werne mantere arrekantherrenhe inetyeke, impemele-ante alhaye. ");
INSERT INTO aer_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Kenhe arelhe atnerte-atnerte areyeke arne iwenhe-iwenhe apeke renhe akurne anthurre-arle anetyenhe. Kenhe arelhe ampe arethape-akerte, itne uyarne alheme! ");
INSERT INTO aer_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ngkarte apayuthnaye nhenge akurne yanhe areye alhwerrpele anetyale, arrantherre-arle uyarne untemenge. Awethe anteye Ngkarte apayuthneme nhenge akurne yanhe areye arlte apurrkele anetyale. ");
INSERT INTO aer_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yewe, akurne akngerre anthurre kwenhe anetyenhe, arrekwele-ngentyele nhenge Ngkartele-arle ahelhe nhenhe mpwareke arne arrpe-anenhe akurne aneke akwetethenhe. Kenhe tyerrtye areyele arrwekele arne akurne nhenhe-arteke irrerlenge aretyakenhe-arle. Alakenhe-arteke anteme awethe anetyakenhe anetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ngkarte kele angkeke akurne nhenge areye alakenhe-irrerlenge, urteke ware anetyenhe kele uyerremele. Re alakenhe mpwareke ingkirreke ilweketyenge. Re itirreke rarle arrekwele akngakeke areyeke. Alakenhe ikwerenge re angkeke akurne nhenge areye anetyenhe iparrpe uyerretyenhenge. ");
INSERT INTO aer_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Kenhe arrpenhe apeke arrekantherre angketyenhe, ‘Apetyewarraye aretyeke, nhenhe anyente aneme Ngkartele-arle alhileke nhenhe-werne yernetyeke.’ Renhe irlpe artepele awetyeke! Angwenhe apeke alakenhe angkeme, ‘Nhakweyaye re!’ Renhe irlpe artepele awetyeke! ");
INSERT INTO aer_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","25","Kenhe arrpenhe areye akenhe urrtyirremele ware-arle angkerlenge alakenhe, ‘Ayenge kwenhe artwe Ngkartele-arle alhileke.’ Kenhe arrpenhe areye akenhe urrtyirremele ware angketyenhe, ‘Ayenge kwenhe aneme angkentye Ngkarte-kenhe awemele ilerle-apentye akngerre.’ Itne arne impene ngangkerele mpwareke tyerrtye itneke urrtyirretyeke, arrekantherre-arlke, nhenge areye Ngkartele-arle kele akngakeke. Kenhe itne arrekantherre uyarne-arle urrtyirreke tharle arrenhantherrenhe nhenhe areye-akerte arrekwele ilekenge.” ");
INSERT INTO aer_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Kenhe arrpenheme areye apeke apetyewarremele arrekantherre angkerrirretyenhe, ‘Nhakwe arerrirraye, artwe nhenge Ngkartele-arle alhileke re apmere ahurratyele anerlenge!’ Kenhe itne apeke akenhe angkerrirretyenhenge, ‘Re apmere kwenele alengke-iwelheme!’ Kenhe itne apeke arrekantherre alakenhe angkerrirrerlenge, itnenhene awerrirretyale! ");
INSERT INTO aer_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ayenge-arle Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke. Nhenge ayenge apmere ahelhe nhenhe-werne apetye-alpemele, ayenge alarrkentye-arteke apetyetyenhe, alarrkemele alkere akertne alkngenthe-iletyenhe ikngerre-ngentyele alturle-werne-atheke. Alarrkentye-arteke, tyerrtye ingkirrekele ayenge arerrirretyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Thipe irretye areye itelaraye! Arrantherre itelareme nhenge kere apmere awangkele ilwerlenge yanhele intemele irretye areye irrperrerlenge. Kele anwerne itelareme iwenheke-arle itne yanhele aneme. Alakenhe-arle arrantherre ayenge akethe aretyenhe apetyalperlenge, iwenheke-arle ayenge nhenhele aneme-arlke.” ");
INSERT INTO aer_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Jesus itneke awethe angkeke, “Akurne yanhe areye-arle irreke iperre, uterne ingwemerte-irretyenhe, atnyentye pwarrtyetyakenhe anetyenhe. Kwerralye areye alkere-ngentyele atnyerrirretyenhe, Ngkartele altyerre-iperre alkere akertne-arenye areye lernetyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, angkulyenge arratemele, apetyetyenhe pwarrtyemele. Nhenge ayenge nhenhe-werne ngangkere akngerre-akerte apetyetyenhe. Kenhe tyerrtye areye apmere arrpe-anenhe-arenyele ayenge aretyenhe, itne ingkirreke arrangkelhe-ilerremele atere anthurre irrerirretyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","The utnenge alkere-arenye atyinhe areye yernetyenhe, trumpet itnekenhe arnterre angkelhe-angkelhe-iletyenhe, utnenge alkere-arenye atyinhe areye alhetyeke, ikngerre-werne, antekerre-werne, alturle-werne, ayerrere-werne. Itne alhetyenhe apurtelhe-iletyeke tyerrtye areye Ngkartele-arle akngakeke areye, imerte akngetye-alpemele ikwere-werne.” ");
INSERT INTO aer_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Jesus anteme angkeke, “Arne utyerrke-akerte itirrewarraye. Arrantherre itelareme alhwerrpenge arlpelhe areye atnyentye akngerre uyerremele imerte. Ikwere-ipenhele, nhenge arlpelhe arrpenhe areye arraterlenge arrantherre itelareme uterne-arle itwe-irreme. ");
INSERT INTO aer_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kele alakenhe rarle anetyenhe, arrantherre yanhe areye arerrirretyenhe alkerele anerlenge, kele arrantherre itelarerrirretyenhe ayenge-arle itwe anteme-irreme apetyalpetyeke. ");
INSERT INTO aer_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","“Itelarerrirraye. Kenhe nhenge tyerrtye arrpenheme lyete itethe akwete anerlte-aneme, urreke itne ilwerrirretyenhenge, itne akurne anthurre ingkirreke arerrirretyenhe. ");
INSERT INTO aer_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ahelhe-arlke alkere-arlke uyerretyenhe, kenhe angkentye atyinhe areye akenhe uyerretyakenhe akwete-arle anetyenhe.” ");
INSERT INTO aer_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Jesus-ele apententye akngerre ikwerenhe areyeke alakenhe ileke, “Ingkirrenyeke akutne aneme ilengare-arle ayenge apetye-alpetyenheke, Utnenge alkere-arenye areye-arlke akutne aneme. Ayenge-arlke, the-arlke itelaretyakenhe. Ngkarte-ante kwenhe akaltye aneme. ");
INSERT INTO aer_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apetyalpetyeke aneme, ingkirreke arreware akwete anetyenhenge. Alakenhe-arteke, ahinpe anthurre Noah-arle itethe anetyartenge. ");
INSERT INTO aer_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Urreke kwatye urewe akngerre anetyenhenge tyerrtye ingkirreke arreware aneke. Itne merne arlkwetyarte, anewe akerretyarte. Kele imerte Noah ikwere-artweye areye-arlke boat-eke antyenhemele, rarle mpwarekeke. ");
INSERT INTO aer_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Kenhe tyerrtye areye akenhe akwete arreware anerlte-aneke. Kele kwatye urewe akngerre anteme apetyemele itnenhe atweke. Alakenhe-arle urreke tyerrtye areye arreware anthurre-arle anetyenhe, ilengare ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apetyalperlenge. ");
INSERT INTO aer_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Kenhe urreke-arle ayenge ahelhe nhenhe-werne apetyalpetyenhenge, yanhe ikwerele artwe atherre apeke akethele urrkaperle-anerrerlenge. Kenhe the akenhe anyente ware-arle akngetyenhe, kenhe arrpenhe akenhe ipmentye-arle irrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Awethe-arlke, arlte yanhe ikwerele arelhe atherrele apeke merne ntange areye atherle-anerreme. Kenhe the akenhe anyente ware-arle akngetyenhe, kenhe arrpenhe akenhe ipmentye-arle irrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Alakenhe rarle re, arrantherre arelherlte-anetyeke akwete atyenge, Alere alkere-arenye ahelhe nhenhele-arle alkngirreke, apetyalpetyeke-atwetye, arrantherre-arle akutne-arle ilengare-arle ayenge apetyalpetyenheke. ");
INSERT INTO aer_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","The arrekantherre angkentye akweke arrpenhe iletyeke ahentye-aneme artwe ikwere-akerte apmere iltheke-artweye. Kenhe re apeke apmere kwenele ankwe akngerre, kenhe arrpenhe apeke anyelkngeke apetyerlenge, kele re imerte ingkirrenyeke anthurre-arle anyelkngele inerle-alhemele. Kenhe apmereke-artweye re apeke-arle akarre aneke-arle, re aretyeke-arle aneke anyelkngalthe re apetyerlenge, re imerte renhe-arle ulilemele-arle arne ikwerenhe areye anyelkngele ineme-ketye. Kenhe arrantherre akenhe arratye nhenhe itelarerrirreme. ");
INSERT INTO aer_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Alakenhe rarle, arrantherre kwenhe arelherlte-anetyeke atyenge ilengare-arle ayenge apetyalpetyenheke. Ayenge, Alere alkere-arenye apmere ahelhe nhenhele-arle akweke inteke, apetye-arle-alpetyenheke arrantherre akutne-arle aneme. Arrantherre alkngwe akwete anerlte-aneme ware.” Jesus-arle ikwere-arrpe-arle angketyame apententye akngerre ikwerenhe areyeke. ");
INSERT INTO aer_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Kenhe Jesus re angkentye nhenhe ileke: “Angwenhe-ame urrkapentye akngerre mwerre Ngkarte-kenhe? Kenhe ilthekeke-artweye re alethe alhetyeke, re kele urrkapentye akngerre anyente ware ikwere ineme urrkapentye akngerre arrpenhe areye arntarnte-aretyeke, itnenhene merne-arlke kere-arlke anthetyeke angayakwe irrerirrerlenge. ");
INSERT INTO aer_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nhenge artwe iltheke-artweye alethe alhekenge-ntyele apetye-alpemele, re apeke urrkapentye akngerre renhe aretye-alpeme arnterre anthurre warrke-irrerlenge, iltheke-artweye re ikwere akangketye-alpeme. ");
INSERT INTO aer_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Kele the arrekantherre arratye-arle ileme. Kenhe re imerte urrkapentye akngerre yanhe renhe-arle arne ingkirrenyeke ikwerenheke akngerrepate arrernemele. ");
INSERT INTO aer_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“Kenhe urrkapentye akngerre akurne, re-arrpe angketyenhenge, ‘The itelaretyakenhe, ilengare apeke-arle akngerrepate atyinhe apetyalpetyenhe, re apeke-arle akwete-ante anthurre-arle alhetyenhe, kele re akutne-arle aneme nthakenhe-arle ayenge irremeke.’ ");
INSERT INTO aer_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Re anteme urrkapentye akngerre arrpenhe areke ahele-irremele itnenhe atwemele. Kele re arrpenhe areyenge apurte-irretyenhe, merne akngerre-arlke arlkwemele, ngkwarle akngerre-arlke antywemele irrkaye-irrkaye-irremele. ");
INSERT INTO aer_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kele urreke, akngerrepate apetyalpetyenhe artwe yanhe re alkngwe anerlenge. ");
INSERT INTO aer_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Re renhe aremele akurne anthurre irrerlenge, re renhe iwetyenhe arnterre anthurre atwemele renhe apmere akurne nhenge-werne yernemele. Re kele alhetyeke arrpenhe areyele-arlenge anetyeke tyerrtye yanhe areyenge mwerre-arle akwele anerlte-anemenge. Re anemele artitye inkerrelhilemele rlkerte awelheke, uyarne itirremele.” ");
INSERT INTO aer_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","2","Jesus-ele itneke angkentye arrpenhe ileke, “Ayenge apetyalpemele ahelhe nhenhe-werne akngerrepate anteme anetyeke, alakenhe-arle irretyenhe. Arlte yanhe ikwerele tyerrtye areye arelhe wenke 10 pele-arteke-arle apmere atyewe itnekenhe-werne alherlenge, akarelhemele anewe akwerrke-iperreke apetyetyeke renhe anewe aketyeke. Itne ingwele alkngenthe-akerte alheke. ");
INSERT INTO aer_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Kenhe arelhe 5 pele akwenpele aneke, alkngenthe itnekenhe alkngenthe-ileke iperre, antere awethe akngetyakenhe urrekeke. ");
INSERT INTO aer_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Kenhe arelhe ilernpenye 5 pele arrpenhele akenhe itelareke-arle, irlpangkemele antere awethe akngetyetyeke urrekeke, alkngenthe ilwernelheketye. ");
INSERT INTO aer_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ingwele anteme, artwe re apetyetyakenhe akwete aneke. Arelhe itne akarelhemele akarelhemele-irreke, ankwe-anteme-interrirreke. ");
INSERT INTO aer_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Kele ingwe mpwepele anteme tyerrtye anyentele arlkelhe-ileke alakenhe, ‘Iparrpe akeme-irraye! Artwe anewe-arle aketyenhe re angathe anteme apetyemenge, kele alhetyekeye ikwere arnekarnare irretyeke!’ ");
INSERT INTO aer_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Kele itne akeme-irrerirreke ankwenge-ntyele alkngenthe itnekenhe-arle akngerre-ilemele alhetyeke. ");
INSERT INTO aer_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Kele arerte-arerte itne uyarne itirreke alkngenthe itnekenhe akweke-arle-irrekenge, ‘Anwerne kwenhe antere akngerre inetyakenhe irreke.’ Uyarne itelaremele itne arelhe 5 pele arrpenhe areye apayuthneke. ‘Antere akweke anwernenhe anthaye! Alkngenthe anwerne-kenhe-arle ilwernelhekenge.’ ");
INSERT INTO aer_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Kele itne angkirtnerlenge, ‘Arrangkwe, anwerne-kenhe-arle akweke ware-arle anwerneke-ante-arle. Shop-werne alherlte-iwaye antere awethe arrekantherre inetyeke!’ ");
INSERT INTO aer_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Kele itne alherlte-iweke inerrirretyeke. Kele itne-arle alhekenge-ureke artwe re apetyeke anteme-arle anewe aketyeke akwerrke-iperre ikwerenhe renhe akngetyeke. Arelhe ilernpenye areye-arlke apurte-iremele ikwere-atherrenge alheke lamp alkngenthe-akerte akngeye ikwerenhe-kenhe apmere-werne arrernelhemele itne kwene irrpenherlte-iweke imerte merne akngerre anthurre arlkwerrirremele, artwe urrkapentye akngerrele anteme arriwe marteke. ");
INSERT INTO aer_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Kele antere awethe-arle ineke iperre arelhe 5-pele arrpenhe itne apetyalpeke apmere ikwere-werne akethele tnemele arlkerrirremele alakenhe, ‘Akngerrepataye! Altywere-ilaye anwerne irrpenhetyenhenge!’ ");
INSERT INTO aer_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Kele re alakenhe-arle angkerlenge, ‘Iwenhe ikweraye? Ayenge-arle arrekantherre akutne-arle.’” ");
INSERT INTO aer_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Kele Jesus-ele angkentye nhenhe ileke-iperre re itneke angkeke, “Kele mwantyele anteme awerrirraye! Arrantherre kwenhe arelhe 5 pele itelarentye nhenge areye-arteke anetyeke. Akwetethe atyenge akarelherlte-anetyeke ayenge-arle ahelhe nhenhe-werne apetyalpetyenheke, arrantherre-arle akutne-arle ilengare-arle ayenge apetyalpetyenheke.” ");
INSERT INTO aer_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Ikwere iperrele Jesus-ele angkentye itneke ileke, “Ayenge apetyalpemele ahelhe nhenheke-werne akngerrepate anteme anetyeke, alakenhe-arle irretyenhe: Artwele urrkapentye akngerre urrpetye atnyeneke. Artwe yanhe rarle arne ikwerenhe areye anyenteke-iletyame apmere arrpenhe-werne alethe-irrerle-alhetyeke. Urreke re alhetyenhenge re itneke antangkeke. Anyenteke-anyente re itneke mane ampenye ikwerenhe antheke, itne arntarnte-aretyeke akngerre-ilemele. ");
INSERT INTO aer_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Artwe arrekwele-iperreke re antheke mane 5000 gold ngkweltye akngerre anthurre nhenge yanhenge re ikwere arntarnte-aretyenhenge. Artwe arrpenheke akenhe re antheke mane 2000 gold ngkweltye ikwere re arntarnte-aretyeke anteye, kele artwe ingkerne-iperreke akenhe re antheke mane 1000 gold ngkweltye areye. Ikwere-iperrele anteme re alheke apmere arrpenhe-werne ilengareke-atwetye ikwere apeke. ");
INSERT INTO aer_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Urrkapentye arrekwele-iperrele nhenge 5,000 gold ngkweltye areye atnyenetyeke, re iparrpe alheke arne arrpenhe mpwaremele, apwerte nhenge atningke-irretyeke. Ikwere-iperre anteme 5,000 awethe mpwareke. Kele re 10,000 atnyeneke anteme. ");
INSERT INTO aer_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Urrkapentye arrpenhele nhenge 2,000 gold ngkweltye areye atnyeneke, re alheke arne arrpenhe mpwaremele, rarle apwerte nhenge atningke-irretyeke. Ikwere-iperre anteme 2,000 awethe mpwareke. Kele re 4,000 atnyeneke anteme. ");
INSERT INTO aer_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Urrkapentye ingkerne-iperrele 1,000 gold ngkweltye areye-arle ineke, re apele alhemele iperte tnyeke ahelheke, re ngkweltye itnenhe iperteke arteke. ");
INSERT INTO aer_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Urrekenge anteme, artwe akngerrepate re nhenge urrkapentye urrpetyeke re apetyalpeke apmere arrpenhe ikwerenge-ntyele, re itnenhe mane ikwere apayuthneke. ");
INSERT INTO aer_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Urrkapentye arrekwele-iperre nhenge 10,000 gold ngkweltye areye-arle atnyeneke re apetyemele ikwere angkeke, ‘Akngerrepataye unte kwenhe ayenge antheke-arle 5,000 gold ngkweltye areye ngkwenge atningke-iletyeke. Nhenhe araye! Nhenhe 5,000 unte-arle ayenge anthekenge, the kwenhe 5000 awethe mpwareke! Re anteme ingkirreke anthirtneke akngerrepate ikwerenhe renhe.’ ");