﻿USE sofia;
DROP TABLE IF EXISTS sofia.adj_vpl;
CREATE TABLE adj_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES adj_vpl WRITE;
INSERT INTO adj_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jesu Krist lagŋɛl Abraham ɛm, lele David ɛm ab e mew. ");
INSERT INTO adj_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham ecʼalaw Isak e lʼew ab ɛm ecʼen ecʼes ↄsŋm: Jakↄb, ");
INSERT INTO adj_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda lele lisijimɛl ab; Perɛs lele Zera ab (Tamar el ɛl lis), Ɛsrↄm, Aram, ");
INSERT INTO adj_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aminadab, Nasↄn, Salmↄ, ");
INSERT INTO adj_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Boas (Rahab el lis), Obɛd (Rut el lis) ");
INSERT INTO adj_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jese, lele jim ɛb ebu David ab. Salomↄ (lis el Uri e yↄw a); ");
INSERT INTO adj_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Roboam, Abia, Asaf, ");
INSERT INTO adj_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Josafat, Joram, Osias, ");
INSERT INTO adj_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Joatam, Akas, Esekias, ");
INSERT INTO adj_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Manase, Amↄ, Josias, ");
INSERT INTO adj_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yekonia lele lisijimɛl ab. Lɛgŋ ab ɛm anake wɛl ot Israɛl ecʼey im madu ↄkr ɛm Babilↄn wus af a. ");
INSERT INTO adj_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ca eke wɛl ot Israɛl ecʼey im Babilↄn a, ow e jam a, ow el Salatiɛl, Sorobabɛl, ");
INSERT INTO adj_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Abiud, Eliakim, Asↄr, ");
INSERT INTO adj_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Sadↄk, Akim, Eliud, ");
INSERT INTO adj_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eleasar, Matan, Jakↄb, ");
INSERT INTO adj_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ɛtŋ Jakↄb ew Josɛf, Mari ɛc; Mari anake ew Jesu eke wɛl bʼɛsŋ Mesi a. ");
INSERT INTO adj_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Sica kʼigŋ Abraham toŋ David a, ow ij alaw sakp lɛw yar; David toŋ ke kʼok lɛgŋ ab ɛm a eke wɛl ot Israɛl ecʼey im Babilↄn wus af a, ow ij alaw sakp lɛw yar; sica aŋa toŋ ke ok Mesi e mew e lɛgŋ a, ow ij ɛmɛny alaw sakp lɛw yar. ");
INSERT INTO adj_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Kin Jesu Krist eci mew owi ecʼelel eke ɛcr. Josɛf ɛsu Jesu lis Mari; gbɛkↄ gbuŋ ke -lʼuwarir any a, Abŋ Lala ecʼabusu ɛm, Mari anŋ nimamn. ");
INSERT INTO adj_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ɛc Josɛf el ɛgŋ eke bʼɛlum Nyam ɛtŋ lʼerurm eke li kʼɛlu ow ↄkm dedeku fɛŋ ecʼany af; ow sosiɛm lʼɛgŋ lʼeb eke ew ew ɛm, li kʼɛlu ow es. ");
INSERT INTO adj_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Sica eke nʼam tutr low na a, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ow mɛmn ɛm ɛŋnʼn ɛtŋ dadʼr ninɛ: «Josɛf, David eci lilaw, ɛrmij kʼókʼŋ eke kʼoc Mari ɛsɛ ŋ e yↄw af, aŋke Abŋ Lala ecʼabusu ɛm anake nʼanŋ nimamn a. ");
INSERT INTO adj_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Li bʼow lʼew iy, ŋ bʼow ɛsŋ iy a Jesu, aŋke in anake li bʼow lʼeb in ecʼagŋ a nimum lʼɛlu es ɛl e sikpl ɛm a.» ");
INSERT INTO adj_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Low na ɛy yecʼɛtŋ ke odad a eke Ɛs Kↄtↄkↄ dad kokoba ↄb ɛs ab ɛm a íy nɛny. ");
INSERT INTO adj_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Kin odad a: Dedyↄwli a eke anm igŋ ab a bʼow anŋ lokab ɛtŋ bʼow ew iy igŋ eke wɛl bʼow ɛsŋ Emanuɛl. (Nin a e nyandrɛ el: “Nyam anŋ ɛy ab.”) ");
INSERT INTO adj_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Eke Josɛf ufŋm es a, li kok ɛsɛ elel eke Ɛs Kↄtↄkↄ ecʼɛrm ɛs a dadʼr ab af, ɛtŋ lʼoc Mari ɛsɛ in e yↄw af. ");
INSERT INTO adj_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Gbɛkↄ nʼanm ow ab toŋ batŋ Mari ew iy igŋ eke Josɛf ɛw nin Jesu. ");
INSERT INTO adj_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Lɛgŋ ab ɛm eke Erↄd el ɛb ebu a anake wɛl ew Jesu Bɛtlehɛm baŋn, Jude wus af a. Sica eke wɛl ew Jesu a, nuŋ ɛm ↄny ɛsɛl ekʼel mílɛ́l ɛm ɛkn ecʼa, anŋ yogŋ a eke ligbn bʼigb a ow toŋ ok Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","-Lʼibrm ninɛ: «Bogŋ iy a eke wɛl ew ke el Jwifɛl ecʼɛb ebu ab a ee? Sʼɛkn in eci lɛ́l a yogŋ a eke ligbn bʼanŋ igb a, ow sosiɛm anake sʼow eke si kʼusrʼr sos a.» ");
INSERT INTO adj_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Eke ɛb ebu Erↄd amani na ok ↄru ɛm a, ɛrmni ɛdŋʼn es, Jerusalɛm nimum ecʼagŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Erↄd as egb waw ɛsɛl ɛgbɛl a fɛŋ lele ol e low yɛgm ɛsɛl ab ab fɛŋ luku ɛtŋ am ibrm ɛl yogŋ eke wɛl kʼew Mesi a. ");
INSERT INTO adj_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","-Li dad ow ninɛ: «Bɛtlehɛm baŋn, Jude wus af, aŋke kin low yecʼeke Nyam dad ke kokoba ↄb ɛs a nↄn: ");
INSERT INTO adj_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ɛtŋ ŋ, Bɛtlehɛm, elm Jude wus af ecʼɛb ewi a fɛŋ eci jam ɛs. Kↄ ŋ ɛm ɛb ebu a bʼow anŋ ɛy ↄkm, ke nyímn ɛm ecʼagŋ Israɛl.» ");
INSERT INTO adj_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ow sosiɛm ew ew ɛm Erↄd ɛsŋ nuŋ ɛm ↄny ɛsɛl a ekʼɛl ɛm, li kʼuw lɛgŋ tasi yecʼaf eke lɛ́l a kʼɛy ↄkm ab any. ");
INSERT INTO adj_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ɛtŋ lʼɛrm wɛl Bɛtlehɛm. Li dad wɛl ninɛ: «Ìmn otarir iy a e lís e low akr sɛnyn sɛnyn toŋ ɛ́ŋan in; eke bʼɛŋan in a òwr dadrʼm yecʼɛtŋ kʼɛm yɛji mʼím mʼusrʼr sos.» ");
INSERT INTO adj_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Eke -lʼirir ɛb ebu a e sodad a, -lʼɛlu lakr -nʼim. Eke -nʼaam a, kin lɛ́l a eke -lʼikŋn anym -lʼɛkan yogŋ a eke ligbn bʼanŋ igb a, ekʼikŋ ɛl anym. Ɛtŋ wanci ab af a eke lɛ́l a im ok yogŋ a eke iy a anŋ a, nʼinym es. ");
INSERT INTO adj_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Eke -lʼɛkan lɛ́l a inym es a, -nʼanŋ sos ɛm iŋn ligbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","-Lʼok akŋ a ɛtŋ -lʼɛkn iy a lele lis Mari ab. -Lʼok ↄwrↄkp wus ɛtŋ -nʼam usr iy a sos. -Li kpakpab ɛl eci sekpr ab es ɛtŋ -lʼap ow sika, ogŋ lele kpey ab. ");
INSERT INTO adj_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ow e jam a, Nyam ɛwar ɛl mɛmn ɛm, eke -li kʼɛwlmn mɛny -nʼiimn Erↄd ogŋ a ij; ɛtŋ -lʼeb ejagb ɛjeci -nʼim ɛl eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Sica eke nuŋ ɛm ↄny ɛsɛl a im a, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ow ɛŋn Josɛf mɛmn ɛm ɛtŋ dadʼr ninɛ: «Ìgb, òc iy a lele lis ab urur es imn Ejipt toŋ bake Ɛs Kↄtↄkↄ dád ↄny e mɛny ɛwl ow ecʼodad, aŋke Erↄd bʼow ↄl iy a eci ibi es.» ");
INSERT INTO adj_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Kpɛkŋ Josɛf igb ncok ɛm, oc iy a lele Mari ab ɛtŋ -nʼim Ejipt. ");
INSERT INTO adj_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","-Nʼanŋ yogŋ toŋ Erↄd uw. Low na ɛy yecʼɛtŋ ke Ɛs Kↄtↄkↄ ecʼodad na eke dad kokoba ↄb ɛs ab ɛm a, íy nɛny: Ejipt wus af ɛtŋ mʼɛsŋ ɛm ecʼiy a. ");
INSERT INTO adj_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Eke Erↄd bʼuw any eke nuŋ ɛm ↄny ɛsɛl a ɛjuʼr a, ɛrm eblʼl afŋn in es. Na sosiɛm nʼↄŋ abusu eke wɛl kʼibi Bɛtlehɛm lele in e saw saw ab ecʼey mɛny nɛnym, toŋ kʼigŋ akpo yony ɛsɛl a fɛŋ. Nuŋ ɛm ↄny ɛsɛl ecʼamani a ekʼↄŋʼn lɛgŋ ab af eke lɛ́l a ɛy ↄkm a, af yogŋ anake li kok low na a. ");
INSERT INTO adj_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Ɛbɛn eke kokoba ↄb ɛs Jeremi ecʼodad na eke dad a iy nɛny ana: ");
INSERT INTO adj_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Rama ɛb ɛm, wɛl iri lebl ekʼikŋ, ↄŋn ikŋ lele luw eci likekr ab. Rashɛl anake am ikŋ in ecʼey a ecʼↄŋn a. Lʼibram ŋↄŋn aŋke in ecʼey a anm ij. ");
INSERT INTO adj_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Eke Erↄd uw a, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam mɛmn ɛm ow ɛŋn Josɛf Ejipt wus af ");
INSERT INTO adj_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ɛtŋ dadʼr ninɛ: «Ìgb, òc iy a lele lis ab ke ɛ́wal mɛny imn Israɛl wus af, aŋke agŋ a eke am ↄl iy ab es eke kʼibi a -lʼuw.» ");
INSERT INTO adj_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ow ↄŋ Josɛf igb oc iy a lele lis ab ɛtŋ -lʼɛwl -nʼim Israɛl wus af. ");
INSERT INTO adj_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gbɛkↄ Josɛf iri eke Arkelaↄs usr ɛs Erↄd usu ɛsɛ Jude eci es ɛw ɛs af; na sosiɛm erŋn owʼr sos eke li kʼim lʼir Jude. Eke wɛl yɛgmʼn ow ecʼów mɛmn ɛm a, nʼim Galile wus af, ");
INSERT INTO adj_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ɛtŋ nʼim lʼir Nasarɛt baŋn. Ow el ɛbɛn yecʼɛtŋ ke kokoba ↄb ɛsɛl ecʼodad na eke dad a íy nɛny: Wɛl bʼow ɛsŋʼn Nasarɛt iy. ");
INSERT INTO adj_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Lɛgŋ ab ɛm a, Jan mij ok nuŋ ɛs ɛy ↄkm Jude eci loj a ɛtŋ am dad Nyam odad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","«Ìtŋnin ɛrm ɛm aŋke Afr ecʼes ɛw a ow titm.» ");
INSERT INTO adj_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Jan el ɛgŋ a eke kokoba ↄb ɛs Esayi dad in e ecʼodad, ow a eke nʼam dad lʼɛsɛ: Ɛgŋ nyam anŋ loj am ɛlu lebl dad ɛsɛ: «Kòkr Ɛs Kↄtↄkↄ ecʼejagb a, kòkr in e sebr a ínym nyim nyim!» ");
INSERT INTO adj_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Jan sus mob eke wɛl kok gbaŋkↄ kedebnam e suw ɛm ɛtŋ lʼɛgŋ ndey lɛl e meb er ɛm; li bʼij tɛtɛ gbaŋgban lele mow mun ab. ");
INSERT INTO adj_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Jerusalɛm ecʼagŋ, Jude wus af ecʼagŋ fɛŋ, lele mij ewl mij Jurdɛn wus ab af ecʼagŋ a am ow Jan ogŋ. ");
INSERT INTO adj_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","-Nʼam ɛgŋ ɛl e sikpl a -lʼeb agŋ fɛŋ ecʼany af, ɛtŋ Jan am ok ɛl mij nuŋ Jurdɛn erŋ. ");
INSERT INTO adj_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Eke Jan am ɛkn eke Farisiɛl nↄnↄ lele Sadusiɛl ab am ow in ogŋ mij ok nuŋ ecʼa, li dad wɛl ninɛ: «Ɔny morŋn amua! Kↄ bwo dad ↄny eke, ekʼokr mij nuŋ ke ↄtur eke kʼŋgbroŋn Nyam ecʼɛrm bebl ekʼam ow ab ɛm ee? ");
INSERT INTO adj_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Sica yɛ̀gmn ↄny ecʼes an ab ɛm eke itŋnin ɛrm ɛm! ");
INSERT INTO adj_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ɛtŋ ɛmɛny kì tutar ↄny ɛm ki dadr kʼɛsrɛ: “Ɛy lagŋ el Abraham.” Kↄ mʼam dad ↄny eke Nyam ↄtu eke ki kok mebn amua él Abraham ecʼalaw! ");
INSERT INTO adj_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Sica ↄs anŋ eke bʼow bubr ekŋ es min ɛm. Likŋ fɛŋ ekʼↄ́sum ey amamn a, wɛl bʼow ubrʼr es oc ↄwlʼl alm. ");
INSERT INTO adj_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ɛm ecʼa, mʼam mʼok ↄny mij nuŋ mij ɛm ɛsɛ ɛrm ɛm itŋn eci mɛny ɛwr af, gbɛkↄ ɛgŋ ekʼanŋʼm jam am ow a bʼow ok ↄny mij nuŋ Abŋ Lala lele al ɛm ab. Nʼↄny abusu nↄnↄ lʼakm im. Mʼitm bↄbↄ yɛji eke mi kʼↄny in e cↄkrukpↄ meb a mʼotʼr es. ");
INSERT INTO adj_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nʼↄnym waw ab ɛtŋ li bʼow nʼↄŋ egb a lɛf, lʼéb ey a, ke lʼígŋ suw a lʼok es. Li bʼow lʼeb egb a lʼok egbel ɛm, ke lʼófŋ suw a al ekʼiram es ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sica Jesu anŋ Galile ow Jurdɛn eke Jan kʼokʼr mij nuŋ; ");
INSERT INTO adj_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","kↄ Jan ɛgŋm, ɛtŋ dadʼr ninɛ: «Ɛm anake kʼokʼm mij nuŋ a, ɛtŋ ow el ŋ eke am ow ɛm ogŋ!» ");
INSERT INTO adj_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Gbɛkↄ Jesu dadʼr ninɛ: «Caca ɛm a, ɛ̀gŋ ke ow él ɛbɛn, aŋke ɛbɛn eke si bʼow si kok ów fɛŋ eke Nyam am ibrm ɛy ab ana.» Ow sosiɛm Jan ɛgŋ eb okʼr mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Eke Jesu ok mij nuŋ ke am ɛy ↄkm erŋ a, kpɛkŋ afr agbr ɛm. Lʼɛkn Nyam ecʼAbŋ ekʼam usʼr es nuŋ af ɛsɛ kel af. ");
INSERT INTO adj_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ɛtŋ lebl nyam anŋ afr am ikŋ dad ɛsɛ: «Ɛgŋ na el ɛm ecʼIy eke mʼerur tasi; mʼoc ɛm eci sos ɛm iŋn fɛŋ mʼɛluʼl ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Sica Nyam ecʼAbŋ oc Jesu im loj eke agn kʼɛjuʼr. ");
INSERT INTO adj_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Eke nʼɛnŋ nɛny sɛgŋ ekŋ yony, ncok lele lɛgŋ owr ab a, ca namn owʼr sos. ");
INSERT INTO adj_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Agn ekʼel ɛju ɛs a, ɛri ow titmʼn ɛtŋ dadʼr ninɛ: «Ekʼel Nyam ecʼIy, ke dàd mebn amua ítŋn el ob ij.» ");
INSERT INTO adj_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Jesu dadʼr ninɛ: «Wɛl nↄn Nyam Lɛl ɛm eke: Ow elm ob ij sↄny cɛ ↄ́ↄm ɛgŋ sel, kↄ Nyam ecʼodad ebl fɛŋ eke bʼanŋʼn nɛnym ɛy ↄkm a.» ");
INSERT INTO adj_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ɛmɛny agn ocʼr im uyumʼn Jerusalɛm ɛb lala ab ɛm e Nyamel gbɛl a e luw af ecʼusu gege a, ");
INSERT INTO adj_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ɛtŋ dadʼr ninɛ: «Eke el Nyam ecʼIy, ke ànŋ aŋa igb us es wus; aŋke wɛl nↄn Nyam Lɛl ɛm eke: Nyam bʼow ↄŋ in ecʼafr ɛrm ɛsɛl a ow ŋ sosiɛm, ɛtŋ -li bʼow -lʼocʼŋ abu ɛm abu ɛm, yecʼɛtŋ ke lebn kaka kí kokmʼŋ ob lakr.» ");
INSERT INTO adj_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Jesu dadʼr ninɛ: «Nyam Lɛl yɛji dad eke: Kʼɛ́bam Ɛs Kↄtↄkↄ ŋ e Nyam.» ");
INSERT INTO adj_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ɛmɛny agn ocʼr im lafɛny gege nyam af, yɛgmʼn wus na ecʼes ɛw es ɛw a fɛŋ lele ɛl eci sakpl ab ab, ");
INSERT INTO adj_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ɛtŋ dadʼr ninɛ: «Mob amua fɛŋ mʼow mʼↄŋ eke ok ↄwrↄkp wus igŋʼm nuŋ.» ");
INSERT INTO adj_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ca Jesu dadʼr ninɛ: «Ŋ Satan, kpabʼm es lís! Aŋke wɛl nↄn Nyam Lɛl ɛm eke: Bʼow igŋ Ɛs Kↄtↄkↄ ŋ e Nyam sↄny nuŋ, ke kók in sↄny coco e juma.» ");
INSERT INTO adj_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Sica agn ɛgbʼr es; ɛtŋ kin afr ɛrm ɛsɛl owʼr saw am kok in e lís e low. ");
INSERT INTO adj_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Eke Jesu iri eke wɛl ɛlu Jan sobel ɛm a, nʼim Galile wus af. ");
INSERT INTO adj_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Lʼirm Nasarɛt ij, ɛtŋ nʼim nʼanŋ Kapɛrnayum, ɛb eke anŋ Galile eci mij lekpl a saw, Zabulↄn lele Nɛftali ab eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ow el ɛbɛn yecʼɛtŋ ke kokoba ↄb ɛs Esayi eci sodad amua eke dad a íy nɛny: ");
INSERT INTO adj_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Zabulↄn eci wus a, Nɛftali eci wus a ekʼanŋ okij saw ecʼejagb ab af, Jurdɛn jam a, Galile ekʼagŋ ekʼelm Jwifɛl a ir af! ");
INSERT INTO adj_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Agŋ a ekʼir ncebn ɛm a ɛkn usuayl ligbɛl! Ɛtŋ agŋ a ekʼanŋ luw eci lↄw ew a, usuayl ɛjn ok ɛl af. ");
INSERT INTO adj_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lɛgŋ na af anake Jesu ↄb nuŋ am dad Nyam odad ɛsɛ: «Ìtŋnin ɛrm ɛm aŋke Afr ecʼes ɛw a ow titm.» ");
INSERT INTO adj_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesu am ɛcr Galile eci mij lekpl a e saw saw ɛtŋ lʼɛkn agŋ lisijimɛl yony ekʼel ↄcn ibi ɛsɛl: Simↄ eke wɛl bʼɛsŋ Piɛr lele lisijim Andre ab. -Nʼam ok muw mij lekpl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesu dad ɛl ninɛ: «Usrʼm jam, mʼow mi kok ↄny eel agŋ eb ɛsɛl.» ");
INSERT INTO adj_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Kpɛkŋ -li digŋ ɛl eci muw a -lʼok es ɛtŋ -lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Eke li bʼim akpoj tɛl a, lʼɛkn agŋ lisijimɛl ɛjeci yony Jak lele Jan ab, Sebede ecʼey. Ɛl ɛs ab -nʼanŋ ɛl eci mijɛtŋ ab ɛm -nʼam kok ɛl eci muw a ɛtŋ Jesu ɛsŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Kpɛkŋ -li digŋ ɛl ɛs lele mijɛtŋ ab ab -lʼɛlu es, ɛtŋ -lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesu am ɛc Galile eci wus ab af; wus ab af yogŋ, nʼam yɛgm agŋ low Nyam nuŋ igŋ susu a ɛtŋ nʼam ↄb gbreŋgbi usu a ecʼAmani Mamn a e kokoba. Nʼam ewlm ↄ́lu a ɛl ecʼↄl ɛrŋ ɛrŋ fɛŋ ɛm lele ɛl eci dudu fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Siri wus af nimum, Jesu e lís ecʼodad eke wɛl am dad a ecʼamani am ok agŋ ↄru ɛm, ɛtŋ wɛl am isʼr agŋ fɛŋ ekʼam ij ↄl ɛrŋ ɛrŋ e gbre ɛsɛ agŋ ekʼↄny abŋ eŋuŋ, krokro ɛsɛl lele sos ɛ́yru ab; ɛtŋ Jesu am ewlm ɛl. ");
INSERT INTO adj_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Agŋ nↄnↄ ekʼanŋ Galile ow, Ɛb Lɛw a eci wus ab af ecʼagŋ, Jerusalɛm ecʼagŋ, Jude wus af ecʼagŋ lele Jurdɛn ogog eci wus ab af ecʼagŋ ab, am us Jesu jam. ");
INSERT INTO adj_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Eke Jesu ɛkn bieku a, lʼuyu lafɛny af ɛtŋ li sig es. In e jam ɛsɛl a ow titmʼn ");
INSERT INTO adj_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ɛtŋ nʼam yɛgm wɛl low li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Agŋ ekʼij abŋ ɛm e gbↄr, ehe él ɛl eci aŋke Afr e gbreŋgbi usu a, ɛl eci! ");
INSERT INTO adj_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Agŋ a ekʼanŋ sↄrŋ ɛm a, ehe él ɛl eci aŋke Nyam bʼow ɛyr ɛl ɛrm es! ");
INSERT INTO adj_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Agŋ ɛrm frↄrↄ ɛsɛl, ehe él ɛl eci, aŋke -li bʼow -lʼij wus eke Nyam ɛwar a ecʼaja. ");
INSERT INTO adj_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Agŋ eke low nɛnyɛmbri nyam ecʼamn am ↄny a, ehe él ɛl eci, aŋke Nyam bʼow iyr ɛl lok. ");
INSERT INTO adj_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Agŋ a eke bʼikŋ agŋ sↄrŋ a, ehe él ɛl eci, aŋke Nyam bʼow ikŋ ɛl sↄrŋ! ");
INSERT INTO adj_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Agŋ ekʼɛrm ɛm ayl a, ehe él ɛl eci, aŋke -li bʼow -lʼɛkn Nyam. ");
INSERT INTO adj_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Agŋ a eke bʼis ɛrm es ɛy a, ehe él ɛl eci, aŋke wɛl bʼow ɛsŋ ɛl Nyam ecʼey. ");
INSERT INTO adj_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Agŋ a eke bʼan es ɛsɛ elel eke Nyam bʼerur ab af, ke ow sosiɛm wɛl bʼijr gbre a, ehe él ɛl eci, aŋke Afr e gbreŋgbi usu a, ɛl eci. ");
INSERT INTO adj_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ànŋn ehe ɛm eke ɛm sosiɛm agŋ bi wɛwr ↄny, bʼijr ↄny gbre, bi dad ów eŋuŋ fɛŋ ok ↄny af yadŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kòkr yaya, ànŋn sos ɛm iŋn ɛm, aŋke afr ob ap ligbɛl nyam am eku ↄny. Kokoba ↄb ɛsɛl ekʼikŋ anym ow a yɛji, ɛbɛn eke wɛl ijr ɛl gbre ana.» ");
INSERT INTO adj_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","«Ɔny anake eel wus na e mok a. Kↄ eke mok irmn in e ded a, ayaf wɛl ↄtu eke ki kokrʼr ke lʼɛwl li ded ee? Lʼakplm ij, gbeŋ cɛ lʼit eke wɛl kʼoc ↄwlʼl ke agŋ uyuʼr af. ");
INSERT INTO adj_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ɔny anake eel wus na ecʼusuayl a. Baŋn ekʼanŋ lafɛny af a ↄnym es lↄl. ");
INSERT INTO adj_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Wɛl ígŋm kɛniɛ ɛwm es ob ew; kↄ wɛl bʼitmʼn es ob gege af, ke lʼáyal agŋ a fɛŋ ekʼanŋ akŋ a. ");
INSERT INTO adj_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ɛbɛn ekʼↄny ecʼusuayl a ki jɛjn agŋ fɛŋ ecʼany af ana, yecʼɛtŋ ke -lʼɛkn ↄny ecʼów amamn a eke bi kokr a, ke -li kↄklm ↄny Ɛs ekʼanŋ afr a.» ");
INSERT INTO adj_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","«Kì tutar eke mʼow e mi kʼↄny Mois ecʼol a lele kokoba ↄb ɛsɛl e low yɛgm ab ab mʼot es. Mʼowm eke mi kʼↄny mʼot ɛl es, kↄ eke mi kʼɛlu liy ɛm. ");
INSERT INTO adj_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Mʼam dad ↄny nawrɛ ɛm eke afr lele wus ab bʼow ɛc, kↄ ol a eke wɛl nↄn a e mↄni kaka, ow e logli kaka kʼow tɛtŋm es toŋ ke fɛŋ íy nɛny. ");
INSERT INTO adj_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ow sosiɛm, ɛgŋ eke bʼow igŋ sol amua ɛm e likekli nyam ɛlu es, ke bʼow yɛgm agŋ kok ɛbɛn a, Afr e gbreŋgbi usu a, li bʼow lʼel likekli; gbɛkↄ ɛgŋ eke bʼow ↄsu ol a, ke bʼow yɛgm agŋ kok ɛbɛn a, Afr e gbreŋgbi usu a, li bʼow lʼel ligbɛl. ");
INSERT INTO adj_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Kↄ mʼam dad ↄny: eke kokmn low yecʼa eke Nyam am ibrm ↄny a akamn ol e low yɛgm ɛsɛl lele Farisiɛl ab a, kʼow ɛymn Afr e gbreŋgbi usu a.» ");
INSERT INTO adj_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","«Irir eke wɛl dad ɛy lagŋɛl: “Kʼíbim ɛgŋ, ɛgŋ fɛŋ ekʼibi ɛgŋ a, wɛl bʼow ocʼr im jɛj ok ecʼany af.” ");
INSERT INTO adj_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Kↄ ɛm, mʼam dad ↄny mʼɛsɛ: ɛgŋ fɛŋ eke bʼow ebl ɛrm ok lisijim af a, wɛl bʼow ocʼr im jɛj ok ecʼany af; ɛgŋ eke bʼow wɛwr lisijim ɛsɛ: “Ŋ nyamb ɛgŋ a,” wɛl bʼow ocʼr im Sanedrɛn ecʼagŋ a ecʼany af; ɛtŋ ɛgŋ eke bʼow dad lisijim ɛsɛ “Nuŋ ɛm akplm ŋ a,” it eke wɛl kʼocʼr im gbre ij usu ecʼal ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Eke am oc ob ap im egb waw usu ↄŋ Nyam, ɛtŋ yogŋ ↄkn ekʼesŋ jim ɛw low ŋ ab a, ");
INSERT INTO adj_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","egb waw usu yogŋ, ɛ̀w ŋ ecʼob ap ab es, ke íkŋ anym im okar ɛm esŋ jim ab ke sica ɛ́wl ow ke áp Nyam ob a. ");
INSERT INTO adj_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Eke ɛgŋ nyam ɛw low ŋ ab, ɛtŋ usr ejagb aamn jɛj ok ɛm a, ògŋ es fafa okar ɛm eke anŋn ejagb af a, yecʼɛtŋ ke li kʼócmʼŋ nʼↄↄm jɛj ok ɛs, jɛj ok ɛs a ocmʼŋ ↄↄm usu ↄsu ɛs ɛlumʼŋ sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Mʼam dadʼŋ nawrɛ ɛm: kʼow ɛym ↄkm yogŋ eke sↄgm ŋ e labm a fɛŋ ekʼↄny a uwarm.» ");
INSERT INTO adj_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","«Irir low yecʼa eke wɛl dad ab ee? Kʼíjm nfaci. ");
INSERT INTO adj_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Kↄ ɛm mʼam dad ↄny: ɛgŋ fɛŋ eke bi lɛr lawl e yↄw ke bʼↄny erur in ecʼɛrm ɛm a, ow ab lʼij nfaci ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Eke batŋ ow el ŋ e lidr e nyamn a anake bʼↄŋ ɛy sikpl owi ɛm a, ↄkr ↄny ocʼr es ↄwlʼl usu kpekpe: ow akpl ŋ eci eke kʼirmn ŋ e sos ikpr nyam cɛ, ow a eke ŋ e sos a fɛŋ kʼanŋ ke wɛl ↄny ↄwlʼŋ gbre ij usu a. ");
INSERT INTO adj_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Eke batŋ ow el ŋ e lidr abu a anake bʼↄŋ ɛy sikpl owi ɛm a, ùbrʼr es oc ↄwlʼl kpekpe: ow akpl ŋ eci eke kʼirmn sos ogog nyam, ow a eke kʼim gbre ij usu ab ɛm ŋ e sos a fɛŋ ab a.» ");
INSERT INTO adj_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","«Wɛl dad yɛji: “Eke am ogŋ ŋ e yↄw eke ↄl mar ɛbi a, ↄ́ŋʼn igŋnin e lɛl.” ");
INSERT INTO adj_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Kↄ ɛm mʼam dad ↄny: ɛgŋ fɛŋ ekʼɛlu in e yↄw e lʼↄl mar lʼɛbi es, ke ow elm egŋ ot owi ɛm a, nʼↄŋ yↄw a bʼow ɛy nfaci ij owi ɛm. Ɛtŋ ɛgŋ ekʼɛbi yↄw eke wɛl ↄwr a, in yɛji lʼij nfaci.» ");
INSERT INTO adj_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","«Irir low yecʼa eke wɛl dad ɛy lagŋɛl ab ee? Kʼítŋnm ŋ e nɛny ij a, kↄ ke kók Ɛs Kↄtↄkↄ ecʼany af, yecʼa eke dad nɛny ij ɛm a. ");
INSERT INTO adj_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Kↄ ɛm, mʼam dad ↄny eke kʼíjmn nɛny kaka: kʼíjmn nɛny afr e nin ɛm aŋke ow el Nyam eci es sig usu; ");
INSERT INTO adj_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","kʼíjmn nɛny wus e nin ɛm aŋke ow el in ecʼakr es ok usu, kʼíjmn nɛny Jerusalɛm e nin ɛm, aŋke ow el Ɛb Ebu gbɛl a ecʼɛb. ");
INSERT INTO adj_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Kʼíjm nɛny okm ŋ e nuŋ ab af aŋke kʼↄtum kokm ŋ e sin nuŋ nyam ibrm oglog ufum. ");
INSERT INTO adj_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dàdr cɛ ɛsrɛ: “Ɛɛ” oglog “Njaŋ.” Yecʼa eke wɛl bi dad igŋ af a, low ŋuŋn ɛs eci.» ");
INSERT INTO adj_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","«Irir low yecʼa eke wɛl dad ab ee? Nyamn lele nyamn ab ɛtŋ nɛn lele nɛn ab. ");
INSERT INTO adj_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Kↄ ɛm mʼam dad ↄny eke kʼátarmn ↄny ecʼifnu ab. Eke batŋ ɛgŋ nyam ɛdŋʼŋ any af lidr ogog e láwl a, ↄkŋʼn nɛmn ogog ecʼa yɛji lʼɛ́dŋʼŋ. ");
INSERT INTO adj_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Eke ɛgŋ oc imʼŋ jɛj ok ecʼany af eke kʼeb ŋ eci mob sus ɛm a, yɛ̀bʼr lʼéb ŋ e mob af ɛw a yɛji. ");
INSERT INTO adj_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Eke ɛgŋ nyam ↄnyʼŋ lɛc ɛm eke kʼan es in ab sↄfu kaka fɛŋ a, àn ow eci sakp yony. ");
INSERT INTO adj_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɛgŋ ekʼam ibrmʼŋ ob a, ↄŋʼn; kʼùŋan ɛgŋ ɛrm suŋ.» ");
INSERT INTO adj_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","«Irir low yecʼa eke wɛl dad ab ee? Bʼow erur ɛgŋ kaka fɛŋ ke ífn ŋ ecʼifnu. ");
INSERT INTO adj_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Kↄ ɛm mʼam dad ↄny: èrurir ↄny ecʼefnu, ke ŋↄ́ŋan Nyam ↄŋn agŋ a eke bʼijr ↄny gbre a; ");
INSERT INTO adj_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ow ɛm a bʼow eel ↄny Ɛs ekʼanŋ afr a ecʼey, aŋke in e ligbn a bʼafŋn ów eŋuŋ kok ɛsɛl lele ów amamn kok ɛsɛl ab, ɛtŋ in ecʼafr e mij a bʼaan ów amamn kok ɛsɛl lele ów eŋuŋ kok ɛsɛl ab. ");
INSERT INTO adj_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Eke batŋ ow el agŋ a cɛ eke bʼerur ↄny a bʼerurir, ke bla kʼↄŋ ekur Nyam ogŋ ecʼob ap ee? Wus labm eb ɛsɛl yɛji ɛbɛn cɛ -li bi kok. ");
INSERT INTO adj_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ekʼow el ↄny lisijimɛl cɛ bʼɛsŋnin, ke low ligbɛl kokr ab ee? Nyam any uwm ɛsɛl yɛji, ɛbɛn cɛ -li bi kok. ");
INSERT INTO adj_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Éel sↄbↄ ɛsɛ elel ekʼↄny Ɛs ekʼanŋ afr a yɛji el sↄbↄ ab af.» ");
INSERT INTO adj_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","«Ɛ̀wr ɛrm, kì kokr Nyam e lís e low fɛŋ agŋ ecʼany af any ij sosiɛm eci. Eke bʼow kokr ɛbɛn, kʼow ɛŋnmn ↄny Ɛs Nyam ekʼanŋ afr ecʼob ap a. ");
INSERT INTO adj_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ow sosiɛm, eke am ↄŋ ↄgbↄru os, kʼɛ̀w fuw ɛm agŋ kʼɛ́knʼŋ; Nyam nuŋ igŋ usu lele ɛbɛrŋ ɛm ab, ɛbɛn eke ów ɛnyɛmbri yony yony ɛsɛl bi kok ana. -Li bi kok ɛbɛn ekʼagŋ kʼusr ɛl sos. Low nawrɛ mʼam dad ↄny ekʼɛl ecʼob ap a -nʼɛŋn ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Kↄ ŋ ecʼa, ekʼam ap ↄgbↄru ob ŋ e lidr abu ab ɛm, ŋ e nɛmn abu a kʼɛ́kn, ");
INSERT INTO adj_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","yecʼɛtŋ ke ob ap a él es lↄl ɛm, ke asŋ Nyam eke bʼɛkn es lↄl ɛm e low a, bʼow apʼŋ ob. ");
INSERT INTO adj_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ɔny e Nyam ŋↄŋn ɛm, kì kokr ɛsɛ ów ɛnyɛmbri yony yony ɛsɛl af; -li bʼerur eke -li kʼinym es Nyam nuŋ igŋ usu a lele ɛbɛrŋ saw saw ab -ni ŋↄŋn Nyam yecʼɛtŋ ke agŋ fɛŋ ɛ́kn ɛl. Low nawrɛ mʼam dad ↄny, ɛl ecʼob ap a, -nʼɛŋn ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Kↄ ŋ, eke am erur e ki ŋↄŋn Nyam, ɛ̀y ŋ ecʼakŋ abl êl ke yogŋ, ŋↄ́ŋn asŋ Nyam es lↄl ɛm, ke Asŋ Nyam eke bʼɛkn es lↄl ɛm e low a, bʼow ↄŋʼŋ ŋ ecʼob ap a. ");
INSERT INTO adj_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Eke bi ŋↄŋan Nyam, odad ebl nyam coco a cɛ kʼánŋ ↄny nɛnym kʼibn ɛsɛ Nyam any uwm ɛsɛl ecʼab af; -li bi tutr eke odad a bʼↄfu ɛl nɛnym a ke Nyam bʼow iri ɛl e ŋↄŋn e lebl a. ");
INSERT INTO adj_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Kʼèbr ɛl e lakr a, aŋke ↄny Ɛs Nyam, gbuŋ ke íbrmn in low a, li bʼikŋ anym lʼuw low yecʼa ekʼam erurir ab any. ");
INSERT INTO adj_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ɔny e Nyam ŋↄŋn ɛm, dàdr ɛsrɛ: Ɛy Ɛs ekʼanŋ afr, ke ŋ e nin lala a ↄ́ny ɛlum; ");
INSERT INTO adj_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ke ŋ ecʼes ɛw a ów; ke wɛl kók ŋ ecʼerur wus aŋa ɛsɛ afr ecʼab af. ");
INSERT INTO adj_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ɔ̀ŋ ɛy yɛfɛnyna ecʼob ij a ekʼit a. ");
INSERT INTO adj_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Àp ɛy low ŋuŋ a eke si kok a, ɛsɛ elel eke si bʼap agŋ a eke kok ɛy low ŋuŋ ab af. ");
INSERT INTO adj_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kì yɛb ɛy si kʼɛy ɛbm owi ɛm, kↄ ↄny oc ɛy es low ŋuŋ ecʼabu ɛm; aŋke akpo akpo fɛŋ, es ɛw, abusu ↄny lele anygbɛl ab él ŋ eci. Amɛn. ");
INSERT INTO adj_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Tasi ɛm a, ekʼocr low ŋuŋ ekʼagŋ kok ↄny a apr, ↄny Ɛs ekʼanŋ afr a yɛji bʼow oc ap ↄny. ");
INSERT INTO adj_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Kↄ eke ocmn low ŋuŋ ekʼɛgŋ kok ↄny a apmn, ↄny Ɛs ekʼanŋ afr a yɛji, kʼow ocm ↄny e low ŋuŋ e kokr a apm ↄny. ");
INSERT INTO adj_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ɛtŋ kin, eke am ɛnŋn nɛny, kʼɛ̀wr sↄrŋ e sos ɛsɛ elel eke ów ɛnyɛmbri yony yony ɛsɛl bi kok ab af; -li bʼɛw any ekʼagŋ fɛŋ kʼuw any eke -nʼam ɛnŋ nɛny. Mʼam dad ↄny nawrɛ ɛm ekʼɛl e labm sↄg a -nʼɛŋn ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Kↄ ŋ ecʼa, ekʼam ɛnŋ nɛny, yↄg any, ɛ̀fŋ sin, ");
INSERT INTO adj_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","yecʼɛtŋ kʼagŋ kʼúwm any ekʼanŋ nɛny ɛnŋ ɛm. Asŋ sↄny coco ekʼɛgŋ ɛknm a cɛ bʼow ɛkn, ɛtŋ in eke li bʼɛkn low yecʼa ekʼam kok es lↄl ɛm a, li bʼow li sↄgʼŋ ow e labm.» ");
INSERT INTO adj_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","«Kʼàsr ↄny ecʼob ↄny luku wus af aŋa eke sisŋ lele adagra ab bi ŋuŋn, ke elu yɛji bʼok akŋ iy mil a. ");
INSERT INTO adj_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Kↄ àsr ↄny ecʼob ↄny luku afr. Yogŋ, ke ow el sisŋ, ke ow el adagra, -li kʼↄtumn -ni ŋuŋnmn; ɛtŋ yogŋ, elu kʼↄtum okm akŋ iym mil. ");
INSERT INTO adj_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Tasi ɛm a, yogŋ eke ŋ ecʼob ↄny a anŋ a, yogŋ cɛ ŋ ecʼɛrm a yɛji bʼow anŋ.» ");
INSERT INTO adj_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","«Anyamn el sos megl e kɛniɛ. Eke anyamn akplʼŋ a, ŋ e sos megl a fɛŋ anŋ usuayl ɛm; ");
INSERT INTO adj_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","kↄ eke anyamn akplmʼŋ a, ke ŋ e sos megl a fɛŋ yɛji anŋ ncebn ɛm ŋ̂. Eke batŋ usuayl ekʼanŋʼŋ ɛm a el ncebn, ke ncebn ligbɛl marɛm ow bʼow el a!» ");
INSERT INTO adj_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","«Aduigŋ kaka kʼↄtum kokm es ɛw ɛsɛl yony e juma; oglog li bʼow lʼifn krɛkrɛ ecʼa, ke lʼérur yony ɛm ecʼa; oglog li bʼow lʼij nɛny nyam nyam e lís, ke li kʼɛ́wm nyam e low any. Ɔtumn eke ki kokr Nyam e juma ke kokr jɛtɛ yɛji e juma. ");
INSERT INTO adj_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ow amua fɛŋ sosiɛm a, mʼam dad ↄny: kʼèbar ob ekʼijr mij ekʼɛgŋn ɛsŋn sel, oglog ↄny ecʼob sos ɛw e low ɛrmij. Kↄ sel ɛŋn akplm akam ob ij ee? Ɛtŋ kↄ sos megl apklm akam ob sos ɛw ee? ");
INSERT INTO adj_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Lɛ̀ɛr ↄr: -lʼewlmn egb, -lʼubmn egb, -lʼasmn egb luku egbel ɛm, gbɛkↄ ↄny Ɛs ekʼanŋ afr a bi gbagbl ɛl! Kↄ ilmn an akamn ↄr amua ee? ");
INSERT INTO adj_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ɔny ɛm a, bwo ecʼɛgŋ ↄtu eke in ecʼɛrmij ebr ɛm kʼobn in ecʼowr anŋ e sɛgŋ a tɛl ee? ");
INSERT INTO adj_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ɛtŋ kↄ bla ɛtŋ ob sos ɛw e low bʼokr ↄny ɛrmij ee? Lɛ̀ɛr ↄgm e suw ↄdↄdↄ ecʼelel eke bʼɛlil: -li kokmn juma, -lʼolmn gbad. ");
INSERT INTO adj_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Gbɛkↄ mʼam dad ↄny eke Salomↄ ekʼↄny ob nↄnↄ a yɛji, ↄnym ob sos ɛw ekʼakpl akm ↄgm suw ↄdↄdↄ amua ɛm e nyam. ");
INSERT INTO adj_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nyam bʼɛw ↄgm e suw ekʼanŋ yɛfɛnyna, ke efi wɛl bʼow oc ↄwl alm a ob sos. Sakp abi ↄny yɛji li kʼow lʼɛwm ↄny ob sos ɛbɛn ee? Ɔmn ufum ↄny es gbɛ! ");
INSERT INTO adj_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Kʼèbar ɛrmij ki dadr kʼɛsrɛ: “Bla obi si bʼow sʼij ee? Bla mij iy si bʼow sʼɛgŋ ee? Bla obi si bʼow sʼɛw sos ee?” ");
INSERT INTO adj_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Tasi ɛm a, Nyam any uwm ɛsɛl anake sakp sakp fɛŋ bʼↄl ów amua fɛŋ es a. Kↄ, ↄny Ɛs ekʼanŋ afr a uw any eke ↄnyn ow ecʼes abur. ");
INSERT INTO adj_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Nyam e gbreŋgbi usu a eci low íkŋ anym okr ↄny ɛrmij, low nɛnyɛmbri nyam eke nʼam ibrm a yɛji, ke ow e likpr a fɛŋ Nyam bʼow igŋ af ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ca kʼèbar efi e low ɛrmij, efi bʼow ism in e low ab. Lɛgŋ lɛgŋ e gbre a bi bɛbmn lɛgŋ ab ab.» ");
INSERT INTO adj_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","«Kì jɛjr agŋ e lís ecʼów kʼokr, yecʼɛtŋ ke ↄny yɛji, Nyam kí jɛjm ↄny e lís ecʼów okm; ");
INSERT INTO adj_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","aŋke Nyam bʼow jɛj ↄny e lís e low ok ɛsɛ elel eke bi jɛjr agŋ ɛjeci e lís e low okr ab af, ɛtŋ akunda yecʼɛm eke bʼocr ɛbmnin ob ↄŋn agŋ ɛjecʼa, ow ɛm cɛ Nyam yɛji bʼow oc ɛbmn ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kↄ bla ɛtŋ am lɛr suwli ekʼanŋ esŋ jim e nyamn ɛm a, ɛtŋ ɛ́wm likŋ ikpr ekʼanŋʼŋ nyamn ɛm a e low ɛrm ee? ");
INSERT INTO adj_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Oglog ayaf likŋ ikpr ↄtu ekʼanŋʼŋ nyamn ɛm ke dad esŋ jim ɛsɛ: “Yɛ̀bʼm mʼↄny suwli na mʼócʼŋ es nyamn ɛm ee?” ");
INSERT INTO adj_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ɛnyɛmbri yony yony ɛs, ìkŋ anym ↄny likŋ ikpr ekʼanŋʼŋ nyamn ɛm a oc es, ke sica bʼow ɛkn es sɛnyn sɛnyn ↄny esŋ jim e suwli ekʼanŋ nyamn ɛm a oc es. ");
INSERT INTO adj_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Kʼòcr Nyam ecʼob kʼↄŋn mↄwr bake -lʼɛwl -li gugŋ ↄny; kʼòcr an gbɛl e miyob kʼokr es sigbroko ecʼany af bake -lʼuyu af.» ");
INSERT INTO adj_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","«Ìbrmn ob eke erurir a, Nyam bʼow ↄŋ ↄny. Ɔ̀ↄl ob eke erurir a es, Nyam bʼow ↄŋ ɛŋnʼn. Ìcmn lisany abu, Nyam bʼow fig ↄny. ");
INSERT INTO adj_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Kↄ ɛgŋ fɛŋ eke bʼibrm ob eke lʼerur a, Nyam bʼↄŋʼn; ɛgŋ fɛŋ eke bʼↄl ob eke lʼerur a es a, Nyam bʼↄŋ nʼɛŋn; ɛtŋ Nyam bi fig ɛgŋ fɛŋ eke bʼicmʼn lisany abu a. ");
INSERT INTO adj_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Kↄ ↄny ɛm aŋa, ɛgŋ nyam anŋ ekʼin ecʼiy bʼibrmʼn futufutu ke lʼóc lebn nʼↄŋ ow ee? ");
INSERT INTO adj_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Oglog ow bʼibrmʼn ↄcn, ke lʼóc lorŋn nʼↄŋ ow ee? ");
INSERT INTO adj_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ɔny nana ekʼeel agŋ eŋuŋ a, bʼuwr ob amamn any ↄŋn ↄny ecʼey; ɛtŋ Nyam ekʼanŋ afr a anake kʼow uwm any ↄↄm agŋ ekʼam ibrmʼn ów amamn ab ee? ");
INSERT INTO adj_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Low fɛŋ ekʼam erurir eke agŋ ki kok ↄŋ ↄny a, ↄny yɛji, kòkr ɛbɛn kpɛŋ ↄŋn agŋ ɛjecʼa. Mois ecʼol a lele kokoba ↄb ɛsɛl e silɛl a e low yɛgm ekʼɛy ↄkm ana.» ");
INSERT INTO adj_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","«Èbar lisany likekli eci! Aŋke lisany gbada lele ejagb gbada ab bʼirmn ɛgŋ, ɛtŋ agŋ nↄnↄ bʼɛcr yogŋ eci. ");
INSERT INTO adj_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Kↄ lisany eke bʼɛwl ɛgŋ sel ɛŋn ɛm a ɛw likekli afŋn es, ɛtŋ ejagb eke bʼɛwl ɛgŋ sel ɛŋn ɛm a ɛw kↄli nↄnↄ. Agŋ tɛl cɛ bʼɛcr yogŋ eci.» ");
INSERT INTO adj_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","«Ɔ̀sur sos kokoba ↄb ɛsɛl ayadŋu e lís, -li bʼitŋn -lʼɛw mɛcɛb e sos -lʼow ↄny ɛm, kↄ ɛl obi ɛm a, botimbo. ");
INSERT INTO adj_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Bʼow uwr ɛl any ɛl e low kok ɛm. Kↄ kati ɛm wɛl bʼↄw kↄkↄbri, ɛtŋ kↄ librebr ɛm, wɛl bʼↄw babm ee? ");
INSERT INTO adj_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Likŋ mamn, ey amamn li bʼↄsu, ɛtŋ likŋ ŋuŋ ey eŋuŋ li bʼↄsu. ");
INSERT INTO adj_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Likŋ mamn kʼↄtum ↄsum ey eŋuŋ, ɛtŋ likŋ ŋuŋ kʼↄtum ↄsum ey amamn. ");
INSERT INTO adj_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Likŋ fɛŋ ekʼↄ́sum ey amamn a, wɛl bʼow ubrʼr es oc ↄwlʼl alm. ");
INSERT INTO adj_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ɛbɛn eke bʼow uwr kokoba ↄb ɛsɛl ayadŋu any ɛl ecʼów kok ɛm ana.» ");
INSERT INTO adj_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","«Ow elm agŋ a fɛŋ eke bʼɛsŋʼm: “Ɛs Kↄtↄkↄ, Ɛs Kↄtↄkↄ” a, kʼow okm Nyam e gbreŋgbi usu a, kↄ agŋ a cɛ eke bʼow kok ɛm Ɛs ekʼanŋ afr e ecʼerur a. ");
INSERT INTO adj_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Jɛj ok e lɛgŋ a, agŋ nↄnↄ bʼow dadʼm ɛsɛ: “Ɛs Kↄtↄkↄ, Ɛs Kↄtↄkↄ, kↄ ow elm ŋ e nin ɛm sʼelm kokoba ↄb ɛsɛl, ŋ e nin ɛm sʼogŋm abŋ eŋuŋ, ŋ e nin ɛm si kokm sakrowa nↄnↄ ee?” ");
INSERT INTO adj_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ɛtŋ mʼow mi dad ɛl any af mʼɛsɛ: “Ìmn yogŋ a, ↄny ów eŋuŋ kok ɛsɛl, lɛgŋ kaka mʼuwm ↄny any!” ");
INSERT INTO adj_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Na sosiɛm ɛgŋ kaka fɛŋ ekʼiri sodad amua eke mi dad, ke kok ɛsɛ elel eke lʼirir ab af a, nʼanŋ ɛsɛ ɛwru nyam eke us in ecʼêl lob af af. ");
INSERT INTO adj_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Mij an ok wus, mij ewl mij fɛŋ iy igŋ êl a, lɛf ɛlul êl a lɛc ɛm, kↄ lʼɛym aŋke wɛl usʼr lob af. ");
INSERT INTO adj_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Kↄ ɛgŋ kaka fɛŋ ekʼiri sodad amua eke mi dad, ke kokm ɛsɛ elel eke lʼirir ab af a, nʼanŋ ɛsɛ nyamb ɛgŋ nyam ekʼus in ecʼêl a mrici af af. ");
INSERT INTO adj_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Mij an ok wus, mij ewl mij fɛŋ iy igŋ êl a, lɛf ɛlul êl a ɛtŋ ow ɛy wus kikn es nimum.» ");
INSERT INTO adj_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Eke Jesu dad ów ↄm e sodad amua bake ow uwr a, agŋ a ekʼam iri in e low yɛgm a, low am iti any in ecʼelel eke nʼam yɛgmn agŋ low a sosiɛm, ");
INSERT INTO adj_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","aŋke nʼanm ɛsɛ ɛl ecʼol e low yɛgm ɛsɛl ab af, kↄ nʼam yɛgm wɛl low abusu ↄny ɛm. ");
INSERT INTO adj_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesu anŋ lafɛny ab af us es, ɛtŋ agŋ nↄnↄ am usʼr jam. ");
INSERT INTO adj_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Kpɛkŋ kokobe ɛs nyam ow titmʼn, ok ↄwrↄkp wus in ecʼany af ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, eke ŋ erur, ↄtu eke kʼayalʼm.» ");
INSERT INTO adj_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesu ɛgŋm abu es itŋn in ɛtŋ dad ninɛ: «Mʼerur, àyl!» Kpɛkŋ kokobe a ocʼr es lís ɛtŋ lʼayl. ");
INSERT INTO adj_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ɛtŋ Jesu dadʼr ninɛ: «Ìri sɛnyn sɛnyn: kì dad low na kʼok ɛgŋ kaka. Gbɛkↄ ìm yɛgm egb waw ɛs a sos, ke wáw egb a ɛsɛ elel eke Mois ecʼol a ibrm ab af ɛsɛ daŋku ij af.» ");
INSERT INTO adj_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wanci ab af eke Jesu am ɛy Kapɛrnayum a, Rom e srↄda eyŋ ekŋ yen eci anym ɛs nyam ow titmʼn ɛtŋ am ŋↄŋnʼn ");
INSERT INTO adj_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","dad ɛsɛ: «Ɛgŋ gbɛl, ɛm e juma kok ɛs a bubm es ɛru es akŋ, nʼam ij gbre nↄnↄ.» ");
INSERT INTO adj_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jesu ibrmʼn ninɛ: «Mʼím mʼewlmʼn ee?» ");
INSERT INTO adj_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Gbɛkↄ anym ɛs a dad ninɛ: «Ɛgŋ gbɛl, mʼitm eke kʼɛy ɛm e gbugŋ a. Kↄ dàd odad ebl nyam cɛ ke kpɛkŋ ɛm e juma kok ɛs a éwl. ");
INSERT INTO adj_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ɛm obi yɛji, mʼanŋ abusu ɛsɛl ekpekp ecʼew, ɛtŋ mʼↄny srↄda eyŋ eke mʼɛw es. Eke mi bi dad nyam mʼɛsɛ: “Ìm!”, kpɛkŋ li bʼim; ɛtŋ eke mi bi dad ɛjeci nyam mʼɛsɛ: “Òw!”, kpɛkŋ li bʼow; ɛtŋ eke mi bi dad ɛm ecʼaduigŋ a mʼɛsɛ: “Kòk low na!”, kpɛkŋ li bi kok.» ");
INSERT INTO adj_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Eke Jesu iri sodad amua a, lʼerur anym ɛs a e low ɛtŋ nʼam dad agŋ a ekʼam usʼr jam a lʼɛsɛ: «Mʼam dad ↄny nawrɛ ɛm, mʼɛŋnm ↄmn ɛs nɛnɛ kaka Israɛl eyŋ ɛm bↄbↄ yɛji. ");
INSERT INTO adj_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kↄ mʼam dad ↄny, agŋ nↄnↄ bʼow anŋ yogŋ eke ligbn bʼanŋ igb lele yogŋ eke ligbn bʼɛru es ab ow Afr eci gbreŋgbi usu a, -lʼok es Abraham, Isak, lele Jakↄb ab ob ij usu a. ");
INSERT INTO adj_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ɛtŋ agŋ a ekʼit eke blel ɛŋn Afr e gbreŋgbi usu a, wɛl bʼow ogŋ ok ɛl gbeŋ ncebn ab ɛm, yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a.» ");
INSERT INTO adj_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ɛtŋ Jesu dad anym ɛs a ninɛ: «Ìm gbugŋ, yecʼa ekʼŋ ecʼↄmn a am erur a, bʼow ɛŋn.» Ɛtŋ anym ɛs a e juma kok ɛs a ewl wanci ab af cɛ. ");
INSERT INTO adj_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ca Jesu im Piɛr ecʼakŋ a, ɛtŋ lʼɛkn Piɛr ɛy lis eke sos am ɛtu es ɛru es. ");
INSERT INTO adj_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jesu itŋn yↄw a ecʼabu a abu ɛtŋ lɛfr ↄl a ocʼr es lís; lʼigb ɛtŋ nʼam kok Jesu e lís e low. ");
INSERT INTO adj_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Eke lɛgŋ ew es a, wɛl ot agŋ nↄnↄ eke abŋ eŋuŋ am ijr gbre a is Jesu. In ecʼodad ebl ɛm cɛ lʼogŋ abŋ eŋuŋ a ɛtŋ lʼewlm ↄ́lu a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Li kok ɛbɛn yecʼɛtŋ ke kokoba ↄb ɛs Esayi ecʼodad na eke dad a íy nɛny: Lʼeb ɛy e sos dudu a ɛtŋ lʼokm ɛy sel es ɛy ecʼↄl ɛm. ");
INSERT INTO adj_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Eke Jesu bʼɛkn bieku a eke did ɛlul il ɛm a, lʼibrm eke in e jam ɛsɛl a kʼubr mij lekpl a e jam in ab. ");
INSERT INTO adj_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ol e low yɛgm ɛs nyam ɛri ow ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, mʼow mʼusʼŋ jam usu fɛŋ eke bʼow im a.» ");
INSERT INTO adj_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesu dadʼr ninɛ: «Ɛkrɛ ↄny ɛl ecʼↄmu wus ɛm eke bʼɛru ɛm, ↄr yɛji ↄny ɛl e mel; kↄ ɛgŋ ecʼIy ↄnym usu nuŋ nyam ekʼↄtu ekʼɛru es eb sel.» ");
INSERT INTO adj_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ɛgŋ ɛjeci, in e jam ɛsɛl ab ɛm e nyam dadʼr ninɛ: «Ɛgŋ gbɛl, ↄŋʼm abusu mʼím mʼoc ɛm ɛs es gbuŋ ke mʼów.» ");
INSERT INTO adj_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesu dadʼr ninɛ: «Ùsʼm jam ke yɛ́b agŋ a ekʼuw abŋ ɛm a, ót ɛl ecʼagŋ a ekʼuw ab es.» ");
INSERT INTO adj_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Sica Jesu ɛy mijɛtŋ nyam ɛm ɛtŋ in e jam ɛsɛl a igŋʼn ab im. ");
INSERT INTO adj_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Kpru ɛm, lidgbegb ligbɛl am ɛlu mij lekpl ab af, toŋ batŋ mra am ↄl eke kʼubur mijɛtŋ ab es; kↄ Jesu gbɛ, nʼam ɛru mɛmn. ");
INSERT INTO adj_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Jam ɛsɛl a ɛri ow titmʼn ɛtŋ am uwrʼr dadʼr ɛsɛ: «Ɛgŋ gbɛl, èb ɛy, kↄ sʼam uw!» ");
INSERT INTO adj_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jesu dad ɛl ninɛ: «Kↄ bla ɛtŋ erŋn am ↄny ↄny ee? Ɔmn ufum ↄny es tasi!» Lʼigb, ɛtŋ lebl tuↄtuↄ ɛm, li dad lidgbegb a lele mra ab ab eke kʼirm es, ɛtŋ usu a fɛŋ irm es tiŋ. ");
INSERT INTO adj_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Agŋ a fɛŋ low iti any ɛtŋ am dad ɛsɛ: «Kↄ bwo el ɛgŋ ikŋ na eke lidgbegb lele mra ab bʼↄny in ecʼɛlum ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Eke Jesu ubr mij lekpl a e jam, Gadareni eyŋ eci wus ab af a, agŋ yony anŋ suwↄmu ecʼaraŋn ok ↄkm ɛtŋ am ow ↄbrʼr. Abŋ eŋuŋ anŋ agŋ amua ɛm, ɛtŋ -li bʼↄr abr nↄnↄ. Ow ↄŋ ɛgŋ ↄ́tum ɛcrm ebr ab af eci. ");
INSERT INTO adj_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kpɛkŋ abŋ eŋuŋ ɛsɛl a am ↄg dad ɛsɛ: «Nyam ecʼIy, kↄ bla lowi anŋ ɛy araŋn ee? Kↄ ɛy e gbre ijr ecʼow gbuŋ ke lɛgŋ a ów ee?» ");
INSERT INTO adj_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Akpoj ɛm a, gbroko nↄnↄ anŋ ekʼam ↄl ɛl ecʼob ij es ɛc. ");
INSERT INTO adj_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Abŋ eŋuŋ a am ŋↄŋn Jesu ɛsɛ: «Ekʼerur eke kʼogŋ ɛy a, ógŋ ɛy sʼok sigbroko amua ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesu dad ɛl ninɛ: «Ìmn.» -Lʼok ↄkm wɛl ɛm -nʼim -lʼir sigbroko ab ɛm. Kpɛkŋ gbroko a fɛŋ anŋ lafɛny ab af uru es ok mij lekpl ab ɛm uw. ");
INSERT INTO adj_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Sigbroko ↄsu ɛsɛl a uru es im baŋn ↄb low a ekʼɛy a ecʼamani; -li dad abŋ eŋuŋ ɛsɛl yony a yɛji ecʼodad. ");
INSERT INTO adj_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ow sosiɛm, baŋn a ecʼagŋ a fɛŋ ok ↄkm im am ɛkn Jesu; eke -lʼɛkan ow a, -ni ŋↄŋn ow ekʼow kʼŋgboŋ ɛl eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jesu ɛy mijɛtŋ nyam ɛm, ɛtŋ ɛwl ubr mij lekpl a im baŋn. ");
INSERT INTO adj_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Agŋ oc sos es wɛw ɛs nyam ekʼanŋ faja ɛm isʼr. Eke Jesu bʼɛkn agŋ a ecʼↄmn a, li dad sos es wɛw ɛs a ninɛ: «Ɛm jim, ɛrmij kʼókʼŋ! Mʼoc ŋ e sikpl a mʼapʼŋ!» ");
INSERT INTO adj_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Ow sosiɛm, ol e low yɛgm ɛsɛl bɛb am dad ɛl obi ɛm ɛsɛ: «Ɛgŋ na am ocr in sosi Nyam! Nʼam ↄbr Nyam any!» ");
INSERT INTO adj_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Eke Jesu uw ɛl e tutr ab any a, li dad ninɛ: «Kↄ bla ɛtŋ am ↄnyn sow tutr eŋuŋ amua ee? ");
INSERT INTO adj_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kↄ bogŋ ecʼanake ɛw fuɛfuɛ eke wɛl ki dad sos es wɛw ɛs ab ee? “Mʼoc ŋ e sikpl a mʼapʼŋ,” oglog wɛl dádʼr ɛsɛ: “Ìgb ke án es ee”? ");
INSERT INTO adj_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Gbɛkↄ mʼerur eke kʼuwr low na any: wus af aŋa, ɛgŋ ecʼIy ↄny abusu eke kʼoc sikpl ap.» Ɛtŋ sica li dad sos es wɛw ɛs a ninɛ: «Ìgb, òc ŋ e eci faja a eb ejagb im gbugŋ!» ");
INSERT INTO adj_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Ɛtŋ sos es wɛw ɛs a igb aam gbugŋ. ");
INSERT INTO adj_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Eke bieku a bʼɛkn low na a, ow am ↄny ɛl erŋn ɛtŋ -nʼam kↄklm Nyam, abusu ikŋ na eke nʼↄŋ agŋ a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Eke Jesu igb yogŋ aam a, in ecʼɛc ɛm a, lʼɛkn ɛgŋ nyam eke wɛl bʼɛsŋ Matie eke sig es wus labm eb usu. Li dad ow ninɛ: «Ùsʼm jam.» Ɛtŋ lʼigb lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Sica eke Jesu am ij ob Matie ecʼakŋ a, wus labm eb ɛsɛl nↄnↄ lele sikpl ɛsɛl ɛjecʼab ow ɛŋn Jesu lele in e jam ɛsɛl ab ab ɛtŋ -lʼokr af -nʼam ij ob. ");
INSERT INTO adj_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farisiɛl ɛkn low na ɛtŋ am dad in e jam ɛsɛl a ɛsɛ: «Kↄ bla ɛtŋ ↄny eci low yɛgm ɛs a am ij ob agŋ amua ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesu iri ɛl lebl ɛtŋ dad ninɛ: «Agŋ a eke anŋ sos tuↄtuↄ ɛm a, ibram sos kok ɛs, kↄ ↄ́lu a anake ibrm sos kok ɛs a. ");
INSERT INTO adj_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ìmn ke wéwar Nyam e sodad amua eke dad a: Mi bʼerur ɛrm mamn owi mʼakm ndey ɛm e segb waw. Tasi ɛm a, mʼowm eke mi kʼɛsŋ agŋ eke bʼubr ɛl sosi nɛnyɛmbri nyam ɛsɛl a, kↄ mʼow eke mi kʼɛsŋ sikpl ɛsɛl.» ");
INSERT INTO adj_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ow e jam a, Jan mij ok nuŋ ɛs eci jam ɛsɛl a ow ɛŋn Jesu ɛtŋ am ibrmʼn ɛsɛ: «Kↄ bla ɛtŋ sakp nↄnↄ ɛy lele Farisiɛl ab si bʼɛnŋ nɛny ɛtŋ ŋ e jam ɛsɛl a ɛ́nŋm ee?» ");
INSERT INTO adj_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ɛtŋ Jesu dad ɛl ninɛ: «Am tutar ekʼagŋ lawlɛl eke wɛl ɛsŋ mɛbi ecʼes gbɛgbl ɛm a ↄtu eke kʼanŋ sos es ↄw ɛm eke yↄw ɛ́c a anŋ ɛl ab ee? Njaŋ! Gbɛkↄ lɛgŋ am ow eke wɛl bʼow ↄny yↄw ɛ́c a oc es ɛl ecʼaraŋn, ke sica -nʼɛnŋ nɛny gↄŋ. ");
INSERT INTO adj_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Ɛgŋ ócm gbad owr lele gbad sig ab ↄbarm gigŋm; aŋke gbad owr a bʼↄny gbad sig a agbr ɛm, ɛtŋ gbad a ecʼɛm agbr a bʼow agb nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ɛtŋ ɛmɛny ɛgŋ ócm mar owr okm marel sig ɛm; eke kok ɛbɛn a, mar owr a bʼow ↄny marel sig a ↄb es; mar a bʼow ok es ɛtŋ marel a bʼow uŋ. Tasi ɛm a, mar owr, marel owr ɛm wɛl bʼokʼr ɛtŋ mar a lele marel ab ab bʼanŋ.» ");
INSERT INTO adj_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Eke Jesu am dad ɛl sodad amua a, Jwifɛl ecʼes ɛw ɛs nyam ow. Lʼok ↄwrↄkp wus Jesu ecʼany af ɛtŋ li dad ninɛ: «Ɛm jↄw uw wanci na af cɛ; gbɛkↄ òw itŋn in abu, li bʼow lʼigb.» ");
INSERT INTO adj_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesu lele in eci jam ɛsɛl ab ab igb usʼr jam. ");
INSERT INTO adj_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Kpɛkŋ kin yↄw nyam eke bʼub abu ke mebl a ɛ́dŋm es toŋ ow ij akpo lɛw yony. Lʼɛcr jam jam eci lʼow li titm Jesu ɛtŋ lʼitŋn ow e mob sus ɛm a ecʼɛnyɛmbri a abu, ");
INSERT INTO adj_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","aŋke nʼam dadr in sosi lʼɛsɛ: «Blel mi kʼitŋn in e mob sus ɛm a abu cɛ, ke mʼewl ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jesu ɛwl mɛny lɛrʼr ɛtŋ dadʼr ninɛ: «Ɛm jↄw, ɛrmij kʼòkʼŋ, ŋ ecʼↄmn a ewlmʼŋ!» Ɛtŋ wanci ab af cɛ yↄw a ewl. ");
INSERT INTO adj_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sica Jesu im es ɛw ɛs a ecʼakŋ a. Eke li bʼok yogŋ a, lʼɛkn kete afl ɛsɛl eke bɛbm sos ɛgŋ es oc eci lele dedeku a ekʼam ↄg ab ab, ");
INSERT INTO adj_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ɛtŋ li dad ninɛ: «Òkr ↄkm aŋa, dedyↄwli a, lʼuwm, kↄ mɛmn nʼam ɛru.» Dedeku a am kokr Jesu miyɛr. ");
INSERT INTO adj_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Eke wɛl ogŋ agŋ a ok gbeŋ a, Jesu ɛy ojli ɛm a, nʼↄny dedyↄwli a abu ɛtŋ ow igb. ");
INSERT INTO adj_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Amani a eb es wus ab af nimum. ");
INSERT INTO adj_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Sica eke Jesu igb yogŋ aam a, ány eflu yony am usʼr jam. -Nʼam ↄgr ow -lʼɛsɛ: «David e lilaw, ìkŋ ɛy sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Eke Jesu im ɛy gbugŋ a, ány eflu a im titmʼn ɛtŋ nʼam ibrm wɛl lʼɛsɛ: «Kↄ ↄnyn ↄmn eke mʼↄtu eke mi kʼewlm ↄny ee?» -Li dad ninɛ: «Ɛɛ, Ɛgŋ gbɛl, ↄtu eke kʼewlm ɛy.» ");
INSERT INTO adj_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ɛtŋ Jesu itŋn ɛl anyamn abu ɛtŋ dad ninɛ: «Nyam ↄ́ŋ ↄny low a ekʼam ekur ↄmn ɛm a!» ");
INSERT INTO adj_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ɛtŋ -nʼam ɛkn es. Jesu dad ɛl lebl tuↄtuↄ ɛm ninɛ: «Kì kokr ɛgŋ kaka kʼúw any.» ");
INSERT INTO adj_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Gbɛkↄ ány eflu a im, ɛtŋ wus a nimum af -nʼam dad Jesu ecʼodad. ");
INSERT INTO adj_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Eke ány eflu a bʼim a, kpɛkŋ wɛl oc ɛbrm nyam ekʼabŋ ŋuŋ anŋ ɛm is Jesu. ");
INSERT INTO adj_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Sica eke Jesu ogŋ abŋ ikŋ na a, ɛbrm a am dad odad. Bieku a low iti any ɛtŋ am dad ɛsɛ: «Israɛl wus af aŋa, sʼɛknm low nɛnɛ lɛgŋ kaka.» ");
INSERT INTO adj_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Gbɛkↄ Farisiɛl a gbɛ am dad ɛsɛ: «Abŋ eŋuŋ ecʼes ɛw ɛs a anake bʼↄŋʼn abusu lʼogŋ abŋ eŋuŋ amua a.» ");
INSERT INTO adj_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesu am ɛc baŋn ɛgbɛl ɛm lele baŋn ekekey ɛm ab. Nʼam yɛgm agŋ low ɛl e Nyam nuŋ igŋ usu a, nʼam ↄb gbreŋgbi usu a ecʼAmani Mamn e kokoba ɛtŋ nʼam ewlm ↄ́lu a ɛl ecʼↄl ɛrŋ ɛrŋ fɛŋ ɛm lele ɛl e dudu fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Agŋ dedeku a eke nʼam ɛkn a e low ↄnyʼn sↄrŋ afŋn in es, aŋke agŋ amua sos kikn es, sos ↄw es ɛsɛ mɛcɛb ekʼↄnym ↄsu ɛs af. ");
INSERT INTO adj_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Ɛtŋ Jesu dad in e jam ɛsɛl a ninɛ: «Egb ub a ufu es nↄnↄ, kↄ juma kok ɛsɛl ɛnym. ");
INSERT INTO adj_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Ìbrmn egb ↄgm ɛs a ke lʼɛ́rm juma kok ɛsɛl nↄnↄ im in ecʼegb ub ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesu ɛsŋ in e jam ɛsɛl lɛw yony a ɛtŋ nʼↄŋ wɛl abusu eke wɛl kʼogŋ abŋ eŋuŋ, ewlm ↄ́lu lele ɛl eci ↄl ɛrŋ ɛrŋ fɛŋ ɛm lele ɛl eci dudu fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Kin ɛrm ɛsɛl lɛw yony a ecʼen: krɛkrɛ ɛm a, Simↄ eke wɛl igŋ nin af Piɛr, lele lisijim Andre ab; Jak lele lisijim Jan ab, agŋ a yony mum Sebede ecʼey; ");
INSERT INTO adj_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filip, Bartelemi, Toma lele Matie ekʼel wus labm eb ɛs; Tade lele Alfe jim Jak ab; ");
INSERT INTO adj_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simↄ ɛb dogŋn ɛs lele Judas Iskariↄt ekʼↄl Jesu ij ab ab. ");
INSERT INTO adj_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Sica Jesu ɛrm agŋ lɛw yony amua ɛtŋ am ijl ɛl nɛny dad ɛsɛ: «Kʼìmn agŋ ekʼelm Jwifɛl a eci wus af, ɛtŋ ɛmɛny kʼɛ̀yr Samari eci baŋn fɛŋ ɛm yɛji. ");
INSERT INTO adj_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Kↄ ìmn Israɛl ecʼagŋ ekʼanŋ ɛsɛ mɛcɛb ekʼirm af ogŋ. ");
INSERT INTO adj_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ejagb us ɛm a, ↄbr Amani a dadr ɛsrɛ: “Afr eci es ɛw a ow titm!” ");
INSERT INTO adj_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Èwlmn ↄ́lu, ìgbmn agŋ luw ɛm, èwlmn kokobe ɛsɛl ayl, ògŋn abŋ eŋuŋ. Ɔfr ɛm ɛŋan, ɛl yɛji ↄŋn ɛl ↄfr ɛm. ");
INSERT INTO adj_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Kʼòcr sika, os, deŋ kaka fɛŋ kʼánŋ ↄny ekpr ɛm. ");
INSERT INTO adj_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Kʼòcr usu im ecʼekpr, kʼòcr kotu yony, cↄkrukpↄ lele kpama ab. Tasi ɛm a, ob kok ɛs it ob ij ↄŋ. ");
INSERT INTO adj_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Eke okr ɛb nyam ɛm, ìbrmn ɛŋan ɛgŋ ekʼerur eke kʼeb ↄny a, ke ánŋn ɛgŋ ikŋ na ogŋ toŋ ke ókr ↄkm yogŋ. ");
INSERT INTO adj_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Eke bʼokr akŋ nyam, ɛ̀sŋnin ɛl ɛsrɛ: “Ɛrm es ɛy ánŋ ↄny ab.” ");
INSERT INTO adj_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Eke akŋ a ecʼagŋ a eb ↄny a, ↄny ecʼɛrm es ɛy a bʼow anŋ ɛl ab; kↄ eke -lʼebm ↄny a, ke ↄny ecʼɛrm es ɛy a ɛ́wl ow ↄny ab. ");
INSERT INTO adj_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ekʼakŋ nyam oglog ɛb nyam ɛm wɛl ɛgŋm ebm ↄny oglog irim ↄny ecʼodad a, òkr ↄkm yogŋ ke cícr ↄny ecʼakr sɛc a okr ɛl es. ");
INSERT INTO adj_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Low nawrɛ mʼam dad ↄny: jɛj ok e lɛgŋ a, Sodↄm lele Gomↄr ab e low ŋuŋ e wɛl ki kok a bʼow ↄdŋ tɛl akm ɛb na ecʼagŋ ecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","«Kin mʼam mʼɛrm ↄny ɛsɛ mɛcɛb af sibotimbo ecʼaraŋn. Ɛ̀war ɛsɛ morŋn af, ke ánŋn frↄrↄ ɛsɛ kel af. ");
INSERT INTO adj_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ɔ̀sur sos kↄ agŋ bʼow ot im ↄny jɛj ok ecʼany af ɛtŋ -li bʼow -lʼↄr ↄny say ɛm Nyam nuŋ igŋ susu. ");
INSERT INTO adj_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ɛm sosiɛm, wɛl bʼow ot im ↄny es ɛw ɛsɛl lele ɛ́b ebu ab ecʼany af, yecʼɛtŋ ke ɛl lele Nyam any uwm ɛsɛl ab ecʼany af íjr daŋku. ");
INSERT INTO adj_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lɛgŋ eke wɛl bʼow ot im ↄny jɛj ok ecʼany af a, odad yecʼa eke ki dadr a, lele elel eke ki dadr ab ab ecʼɛrmij kʼók ↄny; wanci ab af cɛ Nyam bʼow dad ↄny sodad a eke ki dadr a. ");
INSERT INTO adj_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Sodad a kʼow anm ↄny ɛm owm, kↄ ↄny Ɛs Nyam ecʼAbŋ a bʼow dad odad ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Agŋ lisijimɛl bʼow ot ɛl lisijimɛl lokm ow ibi eci; ey ɛsɛl yɛji bʼow kok ɛbɛn ɛl ecʼey e lís, ey yɛji bʼow ↄbr ɛl ɛsɛl any, ↄŋ wɛl ibi ɛl. ");
INSERT INTO adj_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Ɛm sosiɛm agŋ a fɛŋ bʼow ifn ↄny; gbɛkↄ ɛgŋ eke bʼow inym es kikri toŋ ow e nuŋ ɛdŋ ɛm a, bʼow ɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Eke wɛl am ijr ↄny gbre ɛb nyam ɛm a, òkr ↄkm imn ɛb ɛjecʼɛm. Low nawrɛ mʼam dad ↄny: kʼow ɛcmn Israɛl ecʼɛb a fɛŋ ɛm uwrm ɛtŋ ɛgŋ ecʼIy bʼow ow. ");
INSERT INTO adj_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Low wewr ɛs kaka ágbm akam in e low yɛgm ɛs; ɛtŋ juma kok ɛs kaka ágbm akam in ecʼes ɛw. ");
INSERT INTO adj_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Ow it eke low wewr ɛs kʼanŋ ɛsɛ in e low yɛgm ɛs ab af, ke juma kok ɛs yɛji ánŋ ɛsɛ in ecʼes ɛw ɛs ab af. Eke wɛl ɛsŋ akŋ ɛs a Bɛlsebul, ke sakp abi wɛl kʼow wɛwrm akŋ a ecʼagŋ ab ee? ");
INSERT INTO adj_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Ow sosiɛm kʼùrur agŋ amua. Kↄ low fɛŋ eke lↄl es a bʼow ɛy ↄkm; ɛtŋ low fɛŋ ekʼel asre ɛm ecʼa, wɛl bʼow uw any. ");
INSERT INTO adj_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Low yecʼeke mi dad ↄny saw ɛm a, dàdr agŋ fɛŋ ecʼany af; ke ow eke irir asre ut ɛm a, úyur êl luw af ɛlul lebl agŋ iri. ");
INSERT INTO adj_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Kʼùrur agŋ a eke bʼibi sos megl ke ↄ́tum ibim ɛgŋ e liy a; kↄ ùrur Nyam ekʼↄny abusu ekʼibi sos megl lele liy ab gbre ij usu a. ");
INSERT INTO adj_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Kↄ wɛl ↄ́lm yay yony ijm lɛl nyam ee? Ɛbɛn yɛji, yony ab ɛm e nyam ɛ́ym wus ekʼow elm Nyam ecʼerur. ");
INSERT INTO adj_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ɔny ecʼa, ↄny e sin nuŋ bↄbↄ yɛji Nyam awl uw any. ");
INSERT INTO adj_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kʼùrur erŋn: ↄny, iil an nↄnↄ akmn siyay nↄnↄ!» ");
INSERT INTO adj_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","«Eke ɛgŋ nyam bi dad dedeku fɛŋ ecʼany af ekʼin el ɛm eci, ɛm yɛji, ɛm Ɛs ekʼanŋ afr ecʼany af, mʼow mi dad mʼɛsɛ: “Lʼel ɛm eci.” ");
INSERT INTO adj_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Gbɛkↄ ekʼɛgŋ nyam bi dad dedeku fɛŋ ecʼany af ekʼin uwm im any, ɛbɛn ɛm yɛji, ɛm Ɛs ekʼanŋ afr ecʼany af a mʼow mi dad mʼɛsɛ: “Mʼuwmʼn any.” » ");
INSERT INTO adj_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","«Kʼↄ̀nyn ↄmn eke mʼis ɛrm es ɛy wus af aŋa. Mʼowm eke mi kʼis ɛrm es ɛy, kↄ ar owi. ");
INSERT INTO adj_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Tasi ɛm a, mʼow eke mi kʼↄbar ɛgŋ lele ɛs ab nuŋ, yↄwli lele lis ab, yↄw eke wɛl ɛbi ow lele ɛc lis ab. ");
INSERT INTO adj_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ifanin bʼow anŋ akŋ nyam coco ecʼagŋ ecʼaraŋn. ");
INSERT INTO adj_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ɛgŋ yecʼeke bʼerur ɛs oglog lis akmʼm a, itm eke kʼel ɛm e jam us ɛs; ɛgŋ yecʼeke bʼerur jim oglog jↄw akmʼm a, in yɛji itm eke kʼel ɛm e jam us ɛs. ");
INSERT INTO adj_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ɛgŋ ekʼabum in obi ecʼolikŋ usm im jam a, itm eke kʼel ɛm e jam us ɛs. ");
INSERT INTO adj_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ɛtŋ ɛmɛny ɛgŋ eke bʼow ↄsu in e sel a, li bʼow lʼirmn; kↄ ɛgŋ eke bʼow irmn in e sel a ɛm sosiɛm a, li bʼow nʼɛŋn.» ");
INSERT INTO adj_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","«Ɛgŋ ekʼeb ↄny a, ebʼm; ɛtŋ ɛgŋ ekʼebʼm a, eb Nyam ekʼɛrmʼm a. ");
INSERT INTO adj_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɛgŋ ekʼeb kokoba ↄb ɛs, Nyam e kokoba ↄb ɛs ekʼow el a sosiɛm a, bʼow ɛŋn ob ap ekʼel Nyam e kokoba ↄb ɛsɛl ecʼa. Ɛtŋ ɛgŋ ekʼeb low nɛnyɛmbri nyam ɛs, low nɛnyɛmbri nyam ɛs ekʼɛgŋ na el Nyam ecʼany af a sosiɛm a, li bʼow nʼɛŋn ob ap a ekʼel low nɛnyɛmbri nyam ɛsɛl ecʼa. ");
INSERT INTO adj_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Low nawrɛ mʼam dad ↄny: ɛgŋ yecʼeke bʼow aw mij dra kpↄk nyam cɛ ↄŋ ɛm e jam ɛsɛl ey amua ɛm e nyam, ɛm e jam us ɛs eke iy a el a sosiɛm a, ɛgŋ ikŋ na bʼow ɛŋn in ecʼob ap.» ");
INSERT INTO adj_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Eke sica Jesu dad ów ↄm e sodad amua ok in jam ɛsɛl lɛw yony a bake ow uwr a, lʼigb yogŋ, nʼim eke li ki yɛgm agŋ low ke li dád Nyam ecʼodad wus ab af e sɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Jan mij ok nuŋ ɛs ekʼanŋ sobel ɛm a, iri wɛl dad Krist ecʼów eke am kok. Lʼɛrm in e jam ɛsɛl ab ɛm e bɛb Jesu ogŋ ");
INSERT INTO adj_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","eke -li kʼibrm ow -lʼɛsɛ: «Kↄ ŋ, Mesi a eke in kʼow ab ana, oglog ɛgŋ ɛjeci ɛl kʼeku ee?» ");
INSERT INTO adj_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesu dad ɛl ninɛ: «Ìmn dadr Jan low yecʼa ekʼam irir ke am ɛkan a: ");
INSERT INTO adj_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ány eflu am ɛkn es, akr kpɛcɛ ɛsɛl am an es, kokobe ɛsɛl yɛji am ewl, ↄru ablu yɛji am iri ów, agŋ ekʼuw a yɛji am igb ɛtŋ wɛl am ↄb Amani Mamn a e kokoba ok ↄgbↄru. ");
INSERT INTO adj_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Ehe él ɛgŋ a eke kʼow irmnm in ecʼↄmn eke nʼↄny ɛm ɛm a eci.» ");
INSERT INTO adj_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Kpɛkŋ eke Jan eci jam ɛsɛl a im a, Jesu oc Jan e lís e low am ibrm dedeku a ɛsɛ: «Kↄ loj yogŋ bla imn eke kʼɛkan ee? Kↄ ɛgŋ ekʼanŋ ɛsɛ anany eke lɛf am ↄny mumu af ee? Njaŋ! ");
INSERT INTO adj_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ca eke ow elm ɛbɛn a, ke bla im ɛkan ee? Ɛgŋ eke sus mob sɛnyn ee? Njaŋ, agŋ eke bi sus mob sɛnyn sɛnyn a, ɛ́b ebu e gbugŋ -li bʼanŋ. ");
INSERT INTO adj_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ɛtŋ ca bla tasi im ɛkan ee? Kↄ kokoba ↄb ɛs nyam ee? Ɛɛ, mʼam dad ↄny ekʼɛgŋ a ekʼɛkan a agb akm kokoba ↄb ɛs; ");
INSERT INTO adj_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","aŋke Nyam Lɛl ɛm a, Nyam dad Jan e lís e low ninɛ: Kin, mʼam ↄŋ ɛm ecʼɛrm ɛs ikŋʼŋ anym kók ŋ ecʼejagb a. ");
INSERT INTO adj_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Low nawrɛ mʼam dad ↄny: agŋ a eke wɛl ew ab ɛm a, ɛgŋ kaka anm agbm akam Jan mij ok nuŋ ɛs; gbɛkↄ Afr e gbreŋgbi usu a ecʼagŋ a ekʼanŋ a e likekli a agb akm Jan. ");
INSERT INTO adj_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lɛgŋ a ɛtŋ eke Jan am ↄb Amani a toŋ ke kʼit yɛfɛnyna a, Afr e gbreŋgbi usu a e low am ɛy lɛc, ɛtŋ ów gaŋgaŋ ɛsɛl a am ↄl ekʼoc lɛc ɛm. ");
INSERT INTO adj_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Toŋ kʼigŋ Jan e lɛgŋ ɛm a, kokoba ↄb ɛsɛl a fɛŋ lele Mois ecʼol ab ab ↄb gbreŋgbi usu a ecʼamani. ");
INSERT INTO adj_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Ɛtŋ ekʼerurir ekʼubrʼm nawrɛ, ke Jan anake el Eli a eke kʼɛwl ow a. ");
INSERT INTO adj_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ekʼↄnyn ↄru eke kʼirir, kʼírir sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Kↄ bwo ecʼɛgŋ mʼↄtu eke mi kʼoc mi bɛbmn yɛfɛnyna ecʼagŋ ab ab ee? -Lʼot etuey ekʼanŋ an ↄl usu es, ke bɛb am dad ɛjeci lebl gege ɛm ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Sʼafl kete ɛj ub eci sʼok ↄny, ɛtŋ ɛgŋmn eke kʼubr ɛj! Sʼɛgŋ sↄrŋ ɛj sʼok ↄny ɛtŋ ɛgŋmn okmn sabu ɛrmni ikŋmn ↄŋn!” ");
INSERT INTO adj_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Kin, Jan ekʼow a, li bʼɛnŋ nɛny, lʼɛ́gŋm mar, ɛtŋ agŋ bi dad ekʼowʼn ↄny abŋ ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Sica ɛgŋ ecʼIy ekʼow a, li bʼij ob, li bʼɛgŋ mar, ɛtŋ agŋ bi dad ekʼɛgŋ ikŋ na in el ob iju, mar ɛgŋu, wus labm eb ɛsɛl lele sikpl ɛsɛl ab e lawl. Gbɛkↄ Nyam eci sɛwr a bʼulm es in ecʼów a ecʼↄkm ok ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ɛmɛny Jesu am ɛnym sɛb a eke wɛl ɛm li kok in e sakrowa ɛgbɛl nↄnↄ a abr, aŋke ɛb eyŋ a itŋnm ɛrm ɛm. Li dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«Korasin ecʼagŋ, gbre él ↄny eci! Bɛtsayida ecʼagŋ, gbre él ↄny eci! Aŋke sakrowa a eke wɛl kok ↄny ogŋ a, blel ow el Tir lele Sidↄn ab wɛl kok ana, ke blel -lʼɛw sↄrŋ e sos, -li kpakp milakŋ, -lʼok fandi, ɛrm ɛm itŋn eci. ");
INSERT INTO adj_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Na sosiɛm mʼam dad ↄny jɛj ok e lɛgŋ a, Tir lele Sidↄn ab e low ŋuŋ eke Nyam ki kok a bʼow ↄdŋ akm ↄny ecʼa. ");
INSERT INTO adj_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ɛtŋ ŋ Kapɛrnayum, am tutr eke any ij ɛm bʼow agb toŋ bake ím titm afr ee? Njaŋ, bʼow is es toŋ bake igŋ ↄŋnes baŋn; aŋke sakrowa a eke wɛl kok ŋ ogŋ a, blel Sodↄm ana, ke ɛb ikŋ na ánŋ yɛfɛnyna yɛji. ");
INSERT INTO adj_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Na sosiɛm mʼam dadʼŋ, jɛj ok e lɛgŋ a, Sodↄm e low ŋuŋ eke wɛl ki kok a bʼow ↄdŋ tɛl akm ŋ ecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Lɛgŋ ab ɛm a, Jesu dad ninɛ: «Ɛm Ɛs, ŋ ekʼel afr lele wus ab ecʼƐs Kↄtↄkↄ a, mʼam ɛluʼŋ bia, ów a ekʼot lↄl es, ɛsɛwru lele nuŋ ɛm ↄny ɛsɛl ab ecʼany af, ke yɛgm etuey uw any a eci. ");
INSERT INTO adj_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ɛɛ! Ɛm Ɛs erur eke ow kʼel ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Ɛm Ɛs ocr in sosi nimum ɛlulʼm abu ɛm. Ɛgŋ kaka uwm Iy ab any eke ow elm Ɛs sↄny coco cɛ, ɛtŋ ɛgŋ kaka uwm Ɛs any eke ow elm Iy a sↄny coco lele agŋ a eke Iy a erur eke kʼɛlu ↄkm yɛgm ab ab. ");
INSERT INTO adj_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Ɔny fɛŋ ekʼɛrɛkp am leg leg ↄny a òwr ɛm ogŋ, mʼow mʼↄŋ ↄny ɛrm es ɛy. ");
INSERT INTO adj_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɛ̀gŋn ɛm e low ɛbr, ke yɛ́br mi yɛgm ↄny low aŋke mʼel ɛrm frↄrↄ, ɛrm nini ɛs; ow ɛm bʼow ɛŋan ↄny obi ecʼɛrm es ɛy. ");
INSERT INTO adj_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ɛm e low a eke mʼow mʼↄŋ ↄny a ecʼↄsu a, ɛw fuɛfuɛ, ɛtŋ ɛrɛkp eke mʼow mʼↄŋ ↄny a ɛwm leg leg.» ");
INSERT INTO adj_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Eke sɛgŋ bɛb ɛc a, nɛnɛgŋ nyam, Jesu lele in e jam ɛsɛl ab ab am ɛcr segb ↄgm eci. Jam ɛsɛl a namn am ↄny ɛtŋ am bubm egbey a ij. ");
INSERT INTO adj_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Eke Farisiɛl bʼɛkn a, -li dad Jesu ninɛ: «Ìs any ɛkn, ŋ e jam ɛsɛl a am kok low eke ɛy ecʼol a ↄↄm abusu eke wɛl ki kok nɛnɛgŋ e lɛgŋ!» ");
INSERT INTO adj_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesu dad ɛl ninɛ: «Awlmn low a eke ɛb ebu David in obi in obi lele in ecʼagŋ ab ab kok lɛgŋ nyam eke namn am ↄny ɛl ab ee? ");
INSERT INTO adj_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Lʼɛy Nyamel ɛm, ɛtŋ in ecʼagŋ ab ab -lʼij egb waw e futufutu a; ke -nʼↄnym ow ecʼij ecʼabusu kaka. Ɛy ecʼol a ↄŋ abusu eke egb waw ɛsɛl sↄny coco kʼij. ");
INSERT INTO adj_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ɛtŋ ɛmɛny awlmn Mois ecʼol ab ɛm eke nɛnɛgŋ e lɛgŋ, egb waw ɛsɛl ekʼↄny juma Nyamel gbɛl ab ɛm a, ↄ́sum nɛnɛgŋ ecʼol a, ke ow élm ɛl ecʼów ↄbr ab ee? ");
INSERT INTO adj_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Kↄ mʼam dad ↄny ekʼaŋa low nyam anŋ ekʼↄny any akm Nyamel gbɛl a! ");
INSERT INTO adj_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Blel uwr Nyam Lɛl a e sodad amua ekʼam dad ɛsɛ: mi bʼerur ɛrm mamn owi mʼakm ndey ɛm e segb waw e nyandrɛ any tasi ana, ke agŋ amua ekʼɛknm low a, blel ↄbmn ɛl low. ");
INSERT INTO adj_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Tasi ɛm a, ɛgŋ ecʼIy anake el nɛnɛgŋ ecʼes ɛw ɛs a.» ");
INSERT INTO adj_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Eke Jesu ŋgboŋ yogŋ im ɛy ɛl eci Nyam nuŋ igŋ usu a, ");
INSERT INTO adj_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ɛgŋ nyam ekʼabu wɛw es anŋ yogŋ. Agŋ a ekʼanŋ yogŋ a erur eke kʼok Jesu ów af; ow sosiɛm -lʼibrm ow ninɛ: «Kↄ ɛy ecʼol a ↄŋ abusu eke wɛl kʼewlm ɛgŋ nɛnɛgŋ e lɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesu dad ɛl ninɛ: «Ekʼↄny ɛm ecʼɛgŋ nyam ↄny licɛb nyam coco ɛtŋ licɛb a ɛy nↄmu croŋ ɛm nɛnɛgŋ e lɛgŋ a, li kʼow nʼiim nʼↄnym lʼocm ow es ee? ");
INSERT INTO adj_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ɛgŋ il an akm licɛb! Ow sosiɛm ɛy ecʼol a ↄŋ abusu eke wɛl ki kok low mamn ↄŋ ɛgŋ nɛnɛgŋ e lɛgŋ.» ");
INSERT INTO adj_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesu dad ɛgŋ a ninɛ: «Ɛ̀gŋm abu es.» Lʼɛgŋm abu a es ɛtŋ ow ɛwl akpl ɛsɛ yecʼab af. ");
INSERT INTO adj_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ow ↄŋ Farisiɛl a ok ↄkm Nyam nuŋ igŋ usu a, -nʼim -nʼam as luku -lʼↄl elel eke -li kʼↄnyn Jesu bake -lʼibi ow. ");
INSERT INTO adj_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Eke Jesu iri in e luw ecʼamani a, nʼŋgboŋ yogŋ ɛtŋ agŋ nↄnↄ am usʼr jam. Nʼam ewlm ↄ́lu a fɛŋ, ");
INSERT INTO adj_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ɛtŋ nʼam ijl wɛl nɛny lʼɛwar eke wɛl kʼulamʼn es. ");
INSERT INTO adj_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Li kok ɛbɛn yecʼɛtŋ ke kokoba ↄb ɛs Esayi eci sodad amua eke dad a íy nɛny: ");
INSERT INTO adj_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nyam dad ninɛ: «Kin ɛm e libↄwi eke mi sↄsum mʼoc ke mʼↄny in ecʼerur ɛtŋ mʼoc ɛm eci sos ɛm iŋn mʼɛluʼl ɛm. Mʼow mʼɛluʼl ɛm ecʼAbŋ ab ɛm ɛtŋ li bʼow lʼɛwar ɛbr ɛbr a fɛŋ ɛm e low nɛnyɛmbri nyam a. ");
INSERT INTO adj_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Li kʼow lʼatarm ów es ɛgŋ kaka fɛŋ ab ɛtŋ li kʼow lʼɛlum lebl, wɛl kʼow irimʼn lebl ɛbɛrŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Anany ekʼibn es a, li kʼow nʼↄnym lʼubm es. Kɛniɛ ekʼin ecʼal a am irm es a, li kʼow nʼↄnym lʼirmnm es. Li bʼow li kok ɛbɛn toŋ ke low nɛnyɛmbri nyam éb es usu a fɛŋ; ");
INSERT INTO adj_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ɛtŋ wus na e ɛbr ɛbr a fɛŋ bʼow oc ɛl ecʼↄmn a ɛluʼl ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Sica ɛmɛny wɛl oc any eflu nyam eke el ɛbrm yɛji, abŋ eŋuŋ ekʼanŋʼn ɛm a sosiɛm is Jesu. Jesu ewlm ɛgŋ a; ow ↄŋ nʼam dad ów ɛtŋ nʼam ɛkn es yɛji. ");
INSERT INTO adj_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Agŋ a fɛŋ low iti any ɛtŋ am dad ɛsɛ: «Kↄ sↄŋ Jesu na David eci lilaw li kʼel ee?» ");
INSERT INTO adj_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Eke Farisiɛl iri odad na a, -li dad ninɛ: «Ɛgŋ na am ogŋ abŋ eŋuŋ aŋke ɛl ecʼes ɛw ɛs Bɛlsebul anake am ↄŋʼn abusu a.» ");
INSERT INTO adj_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesu uw ɛl e sow tutr ab any ɛtŋ dad ɛl ninɛ: «Es ɛw fɛŋ eke in ecʼagŋ a ubr ɛm a bʼuŋ. Ɛb fɛŋ, oglog akŋ fɛŋ ekʼin ecʼagŋ a ubr ɛm a, bʼuŋ. ");
INSERT INTO adj_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Eke sica Satan am ogŋ abŋ ekʼel Satan eci, ke in sosi nʼam ogŋn ar a; kↄ in ecʼes ɛw a ↄtu eke kʼanŋ ee? ");
INSERT INTO adj_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Am ubr eke mʼam ogŋ abŋ eŋuŋ Bɛlsebul ecʼabusu ɛm; ɛtŋ ↄny agŋiyɛl ecʼa eke bʼogŋ a, kↄ bwo bʼↄŋ ɛl abusu ee? Ɛl obi ɛl obi -nʼam yɛgm eke ↄnymn low ij! ");
INSERT INTO adj_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Tasi ɛm a, Nyam ecʼAbŋ ɛm anake mʼam ogŋ abŋ eŋuŋ a; ow am yɛgm eke Nyam ecʼes ɛw a ow ↄny ecʼaraŋn ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Eke wɛl erur eke kʼim ɛy lɛc ɛs nyam ecʼakŋ iyʼr mil a, ow it ke wɛl íkŋ anym ↄny awŋʼn gbuŋ ke wɛl ↄ́tu ɛy in ecʼakŋ ot in eci mob a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Ɛgŋ ekʼanm ɛm ab a, el ɛm ecʼifnu, ɛtŋ ɛgŋ eke ɛ́luam im abu sʼasm Nyam ecʼey luku a, am ↄmun ɛl es. ");
INSERT INTO adj_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Na sosiɛm a, mʼam dad ↄny: wɛl ↄtu eke kʼoc agŋ e sikpl owi lele wɛwr owi eke dad ab ab a ap ɛl; gbɛkↄ ɛgŋ eke dad odad ŋuŋ ok Abŋ Lala af a, Nyam kʼow ocm apmʼn. ");
INSERT INTO adj_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɛgŋ fɛŋ eke dad odad ŋuŋ ok ɛgŋ ecʼIy af a, Nyam bʼow oc apʼr; kↄ ɛgŋ yecʼeke dad odad ŋuŋ ok Abŋ Lala af a, ke ow él yɛfɛnyna, ke ow él efi, Nyam kʼow ocm apmʼn.» ");
INSERT INTO adj_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","«Kòkr likŋ akpl, in ecʼey a yɛji bʼow akpl; kòkr likŋ él likŋ ŋuŋ, in ecʼey a yɛji kʼow akplm, aŋke wɛl bʼuw likŋ fɛŋ any in ecʼey ↄsu ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ɔny morŋn, ayaf ↄtur eke ki dadr ów amamn, ↄny ekʼeel agŋ eŋuŋ ab ee? Low yecʼa ekʼiy ɛrm ɛm gbↄŋ a anake nɛny bi dad ɛlu ↄkm a. ");
INSERT INTO adj_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ɛgŋ mamn, in ɛm ecʼów amamn eke bʼanŋ a anake li bʼoc lʼɛlu ↄkm a; ɛtŋ ɛgŋ ŋuŋ, in ɛm ecʼów eŋuŋ eke bʼanŋ a anake li bʼoc lʼɛlu ↄkm a. ");
INSERT INTO adj_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Mʼam dad ↄny eke jɛj ok e lɛgŋ a, sodad eke agŋ dad ɛsɛ odad ↄfr ↄfr af a, -li bʼow -lʼawl; ");
INSERT INTO adj_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","aŋke ŋ ecʼodad ebl ɛm wɛl bʼow jɛj ŋ e low ok ɛgŋʼŋ low oglog ↄbʼŋ low.» ");
INSERT INTO adj_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ɛtŋ ol e low yɛgm ɛsɛl bɛb lele Farisiɛl bɛb ab am dad Jesu ɛsɛ: «Low yɛgm agŋ ɛs, sʼam erur eke kʼɛlu mɛny ɛwr nyam ↄkm yɛgm ɛy.» ");
INSERT INTO adj_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jesu dad ɛl ninɛ: «Yɛfɛnyna ecʼagŋ eŋuŋ amua ekʼijm nɛny nyam Nyam ecʼany af a, am ibrm mɛny ɛwr, kↄ wɛl kʼow kokm mɛny ɛwr kaka ↄↄm ɛl ekʼow elm kokoba ↄb ɛs Jonas ecʼa cɛ. ");
INSERT INTO adj_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Tasi ɛm a ɛsɛ elel eke Jonas anŋ ↄcn gbɛl a lokm ij sɛgŋ nyahan ncok lele lɛgŋ owr ab a, ɛbɛn nyam coco ɛgŋ ecʼIy yɛji bʼow anŋ wus ɛm ij sɛgŋ nyahan ncok lele lɛgŋ owr ab. ");
INSERT INTO adj_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jɛj ok e lɛgŋ a, Ninif eyŋ bʼow igb yɛfɛnyna ecʼagŋ ecʼany af, ɛtŋ bʼow ↄb ɛl low, aŋke ɛl, eke -lʼirir Jonas eci Nyam odad a, -lʼitŋn ɛrm ɛm. Ɛtŋ kin ɛgŋ anŋ ekʼagb akm Jonas! ");
INSERT INTO adj_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Jɛj ok e lɛgŋ a, Seba ecʼes ɛw lis a bʼow igb inym es yɛfɛnyna ecʼagŋ a ecʼany af, ɛtŋ bʼow ↄb ɛl low, aŋke nʼanŋ usu kpekpe lʼow yecʼɛtŋ ke lʼíri eke li kʼiri Salomↄ eci sɛwr e sodad a. Ɛtŋ kin, ɛgŋ anŋ ekʼagb akm Salomↄ!» ");
INSERT INTO adj_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","«Ekʼabŋ ŋuŋ nyam anŋ ɛgŋ ɛm ɛy ↄkm a, li bʼanŋ usu wɛwɛ nʼam rereb usu a, nʼám ↄl usu eke li kʼir. Eke sica nʼɛ́ŋnm a, ");
INSERT INTO adj_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ke nʼám dad in ɛm lʼɛsɛ: “Mʼow mʼɛwl mʼim mʼɛy ɛm ecʼakŋ a eke mʼanŋ mʼɛy ↄkm a.” Eke li bʼɛwl mɛny lʼow a, li bʼɛkn eke wɛl apl akŋ ab es ayl, wɛl nyinyimn ow akpl ɛtŋ ɛgŋ irm ɛm. ");
INSERT INTO adj_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Sica li bʼɛwl nʼim lʼɛsŋ lawlɛl abŋ eŋuŋ lↄbŋ ekʼuŋ akmʼn, -li bʼokr af -lʼir yogŋ. Ow e jam a, abŋ amua bʼijr ɛgŋ na gbre akm krɛkrɛ ecʼa. Yɛfɛnyna ecʼagŋ eŋuŋ ecʼa yɛji, ɛbɛn ow bʼow el.» ");
INSERT INTO adj_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Eke Jesu odad anŋ nɛnym am dad agŋ a, kpɛkŋ lis lele lisijimɛl ab ow inym es gbeŋ eke ki dadʼr odad. ");
INSERT INTO adj_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɛgŋ nyam dad Jesu ninɛ: «Kin esŋ lele esŋ jimɛl ab ekʼow inym es gbeŋ. -Nʼam erur eke -li ki dadʼŋ odad.» ");
INSERT INTO adj_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jesu dad ɛgŋ a ninɛ: «Kↄ bwo el ɛm lis ee? Ɛtŋ kↄ bwo ɛl el ɛm lisijimɛl ee?» ");
INSERT INTO adj_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ɛtŋ nʼam ↄkŋ jam ɛsɛl a abu li dad lʼɛsɛ: «Kin ɛm lis lel ɛm lisijimɛl ab ekʼanŋ aŋa, ");
INSERT INTO adj_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","aŋke ɛgŋ kaka fɛŋ eke bi kok Ɛs ekʼanŋ afr ecʼerur a, el ɛm lisijim, ɛm lisijↄw lel ɛm lis ab.» ");
INSERT INTO adj_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Lɛgŋ a cɛ, Jesu anŋ akŋ a ɛy ↄkm ɛtŋ im sig es mij saw eke ki yɛgm agŋ low. ");
INSERT INTO adj_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Agŋ nↄnↄ ar ɛlul il ɛm; na sosiɛm lʼɛy mijɛtŋ nyam ɛm li sig es. Kↄ bieku a gbɛ inym es mij nɛny a. ");
INSERT INTO adj_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Nʼam dad wɛl ów nↄnↄ nyandrɛ ɛm lʼɛsɛ: «Lɛgŋ nyam, ɛgb ewl ɛs nyam im ↄgm am ewl egb. ");
INSERT INTO adj_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Eke nʼam ufŋ egb ey ab es a, bɛb ok ebr af ɛtŋ ↄr ow sus ij. ");
INSERT INTO adj_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Bɛb ok mebn wus af, usu eke sɛc ɛnym. Kpɛkŋ -lʼɛli, sɛc a ekʼɛnym a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Kↄ eke ligbn ow afr a, lʼebal egb a eke ɛli ok ↄkm a ɛtŋ li wɛwr wɛl es aŋke min ↄnym ɛl wus tasi. ");
INSERT INTO adj_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Bɛb ɛjeci ok usu eke mirŋ anŋ. Mirŋ a ɛli ↄny awŋ ɛl es. ");
INSERT INTO adj_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Gbɛkↄ egb ey a e bɛb ok wus mamn af ɛtŋ il ewŋ: bɛb ↄny likŋ lele lɛw ab, bɛb ↄny ekŋ nyahan, ɛtŋ ow e bɛb a, ekŋ yen.» ");
INSERT INTO adj_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ɛtŋ Jesu igŋ af dad ninɛ: «Eke ↄnyn ↄru eke kʼirir, ke írir sɛnyn sɛnyn.» ");
INSERT INTO adj_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jam ɛsɛl a ow titm Jesu ɛtŋ am ibrmʼn ɛsɛ: «Kↄ bla ɛtŋ bi dad ɛl odad nyandrɛ ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Li dad wɛl ninɛ: «Ɔny, ɛŋan Afr eci gbreŋgbi usu a ecʼów a eke lↄl es a ecʼany uw, kↄ ɛl -nʼɛŋnm. ");
INSERT INTO adj_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tasi ɛm a, ɛgŋ ekʼɛŋn any uw a, wɛl bʼow obnʼn ɛtŋ ow bʼow ufur es; kↄ ɛgŋ ekʼɛŋnm a, tɛl a eke ↄtu eke kʼanŋʼn a, wɛl bʼow eb. ");
INSERT INTO adj_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ow sosiɛm mi bʼoc nyandrɛ ɛm mi dad ɛl odad, aŋke -li bi lɛr kↄ -lʼɛknmn, ɛtŋ ow bʼok ɛl ↄru ɛm yɛji kↄ -lʼirimn, ɛtŋ ow ókm ɛl es sos ɛm. ");
INSERT INTO adj_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ɛbɛn eke Nyam ecʼodad eke dad ɛl Esayi eci kokoba ↄb ɛm a, ɛy ↄkm sodad amua ɛm ana: Ow bʼow ok ↄny ↄru ɛm sɛnyn sɛnyn, kↄ kʼow irimn; bʼow lɛɛr sɛnyn sɛnyn, kↄ kʼow ɛknmn. ");
INSERT INTO adj_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Tasi ɛm a, agŋ amua na itŋn ɛw tuↄtuↄ; -li babl ↄru es, -li bubur anyamn yecʼɛtŋ ke ɛl ecʼanyamn kʼɛ́knm, ke ɛl ecʼↄru a kʼírim ów, ɛl eci nuŋ ɛm ↄny a kʼánm es, -lʼɛwlmn -lʼowmn ɛm ogŋ bake mʼéwlm ɛl. ");
INSERT INTO adj_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Ɔny ecʼa, sos ɛm ↄtu eke kʼiŋn ↄny aŋke ↄny ecʼanyamn am ɛkn es ɛtŋ ↄny ecʼↄru am iri ów! ");
INSERT INTO adj_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mʼam dad ↄny nawrɛ ɛm: kokoba ↄb ɛsɛl nↄnↄ lele agŋ ekʼij nɛny nyam Nyam ecʼany af ab a erur eke kʼɛkn low na eke am ɛkan a, kↄ -lʼɛknm, iri low na ekʼam irir a, kↄ -lʼirim.» ");
INSERT INTO adj_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","«Ìrir egb ewl ɛs ecʼodad a e nyandrɛ. ");
INSERT INTO adj_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ebr ab af a eke egb a ok a, el agŋ a eke bʼiri wɛl am dad gbreŋgbi usu a ecʼodad ke ɛ́wm ɛrm af a, agn low ŋuŋ ɛs bʼow oc yecʼa eke wɛl ewl ɛl ecʼɛrm ɛm a. ");
INSERT INTO adj_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Mebn wus a eke egb a ok a, el agŋ a eke bʼiri Nyam ecʼodad ke kpɛkŋ bʼebʼr sos ɛm iŋn ɛm a. ");
INSERT INTO adj_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Gbɛkↄ -li yɛbmn odad a okm min ɛl ɛm, -li bʼɛw ɛrm af tɛl cɛ. Eke sica sos es ↄw owi oglog gbre ij owi bʼow Nyam odad a sosiɛm a, -li bʼɛgbr ↄmn a fafa. ");
INSERT INTO adj_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Wus a eke mirŋ nↄnↄ anŋ af ke egb a ok af a, el agŋ a eke bʼiri Nyam ecʼodad, ke ɛmɛny bʼebr wus na ecʼów a e low ɛrmij a. -Li bʼↄl ob ↄny es. Ɛrmij owi amua bʼɛju ɛl, bʼawŋ odad ab es, ɛtŋ ow ↄ́sum ey kaka. ");
INSERT INTO adj_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Wus mamn a, el agŋ a eke bʼiri Nyam ecʼodad ke bʼɛw ɛrm af a. -Li bʼↄsu ey: bɛb ecʼa likŋ lele lɛw ab oglog ekŋ nyahan ɛtŋ bɛb ecʼa ekŋ yen.» ");
INSERT INTO adj_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesu am dad ɛl nyandrɛ ɛm odad ɛjeci ɛsɛ: «Kin Afr eci gbreŋgbi usu a eci elel eke anŋn: ɛgŋ nyam ewl egb amamn in ecʼↄgm a. ");
INSERT INTO adj_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ncok nyam, eke agŋ a fɛŋ am ɛru mɛmn a, in ecʼifnu nyam ow ewl suw eŋuŋ egb ab ɛm ɛtŋ im. ");
INSERT INTO adj_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Eke egb a ɛli bake il ewŋ a, suw eŋuŋ a yɛji ɛli ok ↄkm. ");
INSERT INTO adj_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ɔgm ɛs a eci juma kok ɛsɛl a ow am dadʼr ɛsɛ: “Ɛgŋ gbɛl, kↄ ow elm egb amamn ewlm ŋ ecʼↄgm a ee? Ɛtŋ kↄ bogŋ suw eŋuŋ amua anŋ ow ee?” ");
INSERT INTO adj_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Li dad wɛl ninɛ: “Ifnu nyam e low eke kok ana.” Juma kok ɛsɛl a ibrmʼn ninɛ: “Erur eke si kʼim sʼiri suw eŋuŋ ab es ee?” ");
INSERT INTO adj_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Li dad ninɛ: “Njaŋ, aŋke ow eci es iri ɛm a, ↄtur eke kʼirir egb amamn ab es. ");
INSERT INTO adj_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Yɛ̀br ɛl -lʼokr af -lʼagb toŋ ke ow ít egb ub e lɛgŋ a, ke sica yogŋ, mʼow mi dad egb ub ɛsɛl a mʼɛsɛ: Ìkŋn anym irir suw eŋuŋ ab es awŋ es eku eku ofŋn, ke sica ókr egb a, ɛm ecʼegbel ab ɛm.” » ");
INSERT INTO adj_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesu am dad ɛl nyandrɛ ɛm odad ɛjeci: «Afr eci gbreŋgbi usu a anŋ ɛsɛ likŋ e liy nyam ekʼigŋ nyam oc ewl in ecʼↄgm af. ");
INSERT INTO adj_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Lʼel egb ey a fɛŋ ɛm eci likekli tasi; kↄ eke lʼɛli a, lʼel egb ewlu ab ɛm e likŋ ligbɛl tasi. Lʼel likŋ toŋ batŋ ↄr bʼow us mel in ecʼál ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesu am dad ɛl nyandrɛ ɛm odad ɛjeci: «Afr eci gbreŋgbi usu a anŋ ɛsɛ lijru eke yↄw nyam oc wuwlm ma toy likŋ lele yen ab toŋ bake ma a nimum inŋ eb es ab af.» ");
INSERT INTO adj_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesu am dad dedeku a ów amua fɛŋ nyandrɛ ɛm; li dádm wɛl low ekʼow elm nyandrɛ ɛm. ");
INSERT INTO adj_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Li bi kok ɛbɛn yecʼɛtŋ ke kokoba ↄb ɛs ecʼodad a íy nɛny: Mʼow mi dad ɛl odad nyandrɛ ɛm, mʼow mʼↄŋ ɛl ów eke lↄl es wus eci nuŋ ↄb ɛm ɛtŋ a ecʼamani. ");
INSERT INTO adj_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Sica Jesu ɛlu bieku ab es ɛtŋ im akŋ. In e jam ɛsɛl a im titmʼn ɛtŋ am ibrmʼn ɛsɛ: «Òtar nyandrɛ ɛm odad a ekʼel suw eŋuŋ ekʼanŋ ↄgm a e low akr ok ɛy.» ");
INSERT INTO adj_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesu dad ninɛ: «Ɛgŋ ecʼIy anake ewl egb amamn a; ");
INSERT INTO adj_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ↄgm a, ke wus na nimum ana; egb amamn a el agŋ a eke bʼɛlum gbreŋgbi usu a eci low; suw eŋuŋ a, el agŋ a eke bʼɛlum agn low ŋuŋ ɛs e low a; ");
INSERT INTO adj_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ifnu a eke am ewl suw eŋuŋ a, ke agn ana; egb ub a, ke jɛj ok e lɛgŋ ana; ɛtŋ egb ub ɛsɛl a ke afr ɛrm ɛsɛl ana. ");
INSERT INTO adj_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ɛsɛ elel eke wɛl am iri suw eŋuŋ es eke wɛl kʼↄwl al ɛm a, ɛbɛn eke ow bʼow el jɛj ok e lɛgŋ ecʼab ana: ");
INSERT INTO adj_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ɛgŋ ecʼIy bʼow ɛrm in ecʼafr ɛrm ɛsɛl a, -li bʼow -nʼↄny agŋ a fɛŋ eke bʼirmn ɛl lawlɛl ecʼↄmn a lele ów eŋuŋ kok ɛsɛl ab ab -lʼot es gbreŋgbi usu a, ");
INSERT INTO adj_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ke -lʼot -lʼↄwl wɛl al gbɛl ab ɛm; yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a. ");
INSERT INTO adj_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Kↄ sica agŋ a eke ij nɛny nyam Nyam ecʼany af a, bʼow jɛjn ɛsɛ ligbn af ɛl Ɛs eci gbreŋgbi usu a. Ekʼↄnyn ↄru eke kʼirir, ke írir sɛnyn sɛnyn.» ");
INSERT INTO adj_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Afr eci gbreŋgbi usu a anŋ ɛsɛ ob ↄny eke lↄl es ↄgm nyam af. Ɛgŋ nyam iwr ob ↄny na es ɛtŋ ɛmɛny oc lↄlʼl es ↄgm a. Sos ɛm iŋnʼn toŋ batŋ nʼim lʼↄl ob fɛŋ eke nʼↄny a lʼij, ɛtŋ lʼɛwl lʼow lʼↄl ↄgm a.» ");
INSERT INTO adj_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","«Afr eci gbreŋgbi usu a anŋ ɛsɛ an ↄlu nyam ekʼam ↄl miyob amamn es af. ");
INSERT INTO adj_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Eke nʼɛŋn an gbɛl e miyob nyam a, nʼim lʼↄl ob fɛŋ eke nʼↄny a lʼij, ɛtŋ lʼↄl miyob a.» ");
INSERT INTO adj_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","«Ɛmɛny Afr eci gbreŋgbi usu a anŋ ɛsɛ muw eke wɛl ok ke ↄny ↄcn ɛrŋ ɛrŋ fɛŋ af. ");
INSERT INTO adj_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Eke ow bʼiy a, mij juma kok ɛsɛl a bʼↄdu owʼr ákpaf ke ok es am jɛj ↄcn ab es: -li bʼok amamn a mulu ɛm, ke -lʼↄwl yecʼeke akplm a. ");
INSERT INTO adj_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Jɛj ok e lɛgŋ a, ɛbɛn ekʼow bʼow el ana: afr ɛrm ɛsɛl bʼow ow kpab agŋ eŋuŋ a es, amamn a e lís, ");
INSERT INTO adj_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ke ↄ́wl ɛl al gbɛl ab ɛm. Yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a.» ");
INSERT INTO adj_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesu ibrm ɛl ninɛ: «Kↄ irir ów a fɛŋ ee?» -Lʼɛgŋ ninɛ: «Ɛɛ.» ");
INSERT INTO adj_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ɛtŋ ca li dad wɛl ninɛ: «Ɛbɛn eke ol eci low yɛgm ɛs fɛŋ ekʼam el Afr e gbreŋgbi usu a ecʼɛgŋ a, anŋ ana. Nʼanŋ ɛsɛ akŋ ɛs nyam eke bʼɛlu in ecʼob ↄny ↄkm low yɛgm owr ɛm lele low yɛgm esig ɛm ab af.» ");
INSERT INTO adj_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Eke Jesu dad nyandrɛ ɛm odad amua bake ow uwr a, lʼigb yogŋ ");
INSERT INTO adj_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","nʼim ɛb ab ɛm eke nʼanŋ lʼagb a. Nʼam yɛgm agŋ low yogŋ eci Nyam nuŋ igŋ usu a toŋ agŋ a fɛŋ ekʼanŋ yogŋ a low iti any afŋn es. -Nʼam dad -lʼɛsɛ: «Bogŋ nuŋ ɛm ↄny na anŋ owʼr ee? Ayaf lʼↄtu eke li ki kok sakrowa amua ee? ");
INSERT INTO adj_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Kↄ ow elm ↄgↄg es ↄdu ɛs a ecʼiy ab ee? Kↄ ow elm Mari elm lis ee? Kↄ Jak, Josɛf, Simↄ lele Jud ab elm lisijimɛl ee? ");
INSERT INTO adj_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Kↄ lisijↄwɛl fɛŋ irm ɛy ab ee? Kↄ abusu ikŋ na bogŋ nʼɛŋn ee?» ");
INSERT INTO adj_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ɛtŋ ów amua fɛŋ ↄ́ↄm abusu eke -li kʼↄny ↄmn Jesu ɛm. Ɛtŋ Jesu dad ɛl ninɛ: «Usu a fɛŋ wɛl bʼↄny kokoba ↄb ɛs ecʼɛlum, ekʼow elm in ecʼɛb ab ɛm lele in ecʼakŋ ab cɛ wɛl ↄ́nym in ecʼɛlum.» ");
INSERT INTO adj_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Yogŋ eci sakrowa a eke Jesu kok a tɛl cɛ, ɛl eci ↄmn a eke -nʼↄnym a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Lɛgŋ ab ɛm a, Galile eci es ɛw ɛs Erↄd Antipas am iri Jesu eci nin ekʼam il e low. ");
INSERT INTO adj_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Li dad in eci juma kok ɛsɛl a ninɛ: «Ɛgŋ a Jan mij ok nuŋ ɛs! Lʼigb luw ɛm, na sosiɛm anake nʼam ↄny abusu li kok sakrowa a.» ");
INSERT INTO adj_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Kin elel eke Jan mij ok nuŋ ɛs a e luw owi a ɛcr: Erↄd Antipas oc lisijim Filip e yↄw Erodiad, ɛtŋ Jan im dad Erↄd ninɛ: «Ow itm eke kʼoc esŋ jim e yↄw.» Ɛtŋ ow sosiɛm Erↄd ↄŋ abusu wɛl ↄny Jan ok ŋgbraka ɛlu sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Erↄd am erur eke kʼibi Jan, kↄ nʼam uru Jwifɛl a, aŋke -li bʼoc Jan ɛsɛ kokoba ↄb ɛs af. ");
INSERT INTO adj_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gbɛkↄ sica Erↄd e mew ecʼes gbɛgbl e lɛgŋ ab ɛm a, Erodiad jↄw ub ɛj etu a eke wɛl ɛsŋ a ecʼany af. In e low iŋn Erↄd sos ɛm ");
INSERT INTO adj_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","toŋ lʼɛgŋ lʼeb eke li kʼↄŋ ow ob fɛŋ eke ow bʼow ibrm a. ");
INSERT INTO adj_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Erodiad ecʼów ↄm ebl ɛm, jↄw dad Erↄd ninɛ: «Òc Jan mij ok nuŋ ɛs eci nuŋ a wayas ɛm isʼm aŋa!» ");
INSERT INTO adj_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ɛb ebu a sos ↄw es; gbɛkↄ eke lʼij nɛny etu a ecʼany af a, lʼɛlu abusu es eke li kʼↄŋ ow. ");
INSERT INTO adj_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Nʼↄŋ ɛgŋ im sobel ɛm ubr Jan mij ok nuŋ ɛs nuŋ. ");
INSERT INTO adj_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Wɛl oc nuŋ a wayas ɛm ow ↄŋ dedyↄwli a ɛtŋ lʼeb nʼↄŋ lis. ");
INSERT INTO adj_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ekʼów a ɛc ɛbɛn a, Jan eci jam ɛsɛl a ow oc in e sos megl a im oc es, ɛtŋ im ɛwl Jesu amani low na ekʼɛy a eci. ");
INSERT INTO adj_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Eke Jesu iri Jan e low na a, lʼigb yogŋ mijɛtŋ ɛm eke li kʼim in sↄny usu saw ɛm, kↄ agŋ a uw any; -lʼok ↄkm sɛb a ekʼanŋ yogŋ ab ɛm, ɛtŋ mij nɛny a -nʼam us Jesu jam lakr ɛm. ");
INSERT INTO adj_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Mijɛtŋ a bʼitr es eke Jesu bʼus es a, lʼɛkn agŋ nↄnↄ; wɛl e low ↄnyʼn sↄrŋ ɛtŋ kpɛkŋ nʼam ewlm ɛl ecʼↄ́lu a. ");
INSERT INTO adj_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Eke lɛgŋ ew es a, in e jam ɛsɛl a ow titmʼn ɛtŋ am dadʼr ɛsɛ: «Lɛgŋ ɛc, ɛtŋ ɛmɛny usu na yɛji ɛw usu saw ɛm. Òk agŋ ab es ím baŋn baŋn ekʼanŋ saw saw aŋa a yecʼɛtŋ ke -lʼↄl ob ij.» ");
INSERT INTO adj_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesu dad ɛl ninɛ: «Ow itm eke -li kʼim; ↄny obi, ↄŋn ɛl ob -lʼij!» ");
INSERT INTO adj_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","-Li dad ow ninɛ: «Futufutu yen lele ↄcn yony ab cɛ anake sʼↄnym ab aŋa a.» ");
INSERT INTO adj_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesu dad ɛl ninɛ: «Òtr isrʼm aŋa.» ");
INSERT INTO adj_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ɛtŋ ɛmɛny li dad agŋ a eke kʼok es suw ab af; sica lʼoc futufutu yen a lele ↄcn yony ab ab, lʼigbl any ogŋ afr ɛtŋ lʼɛlu Nyam bia. Li bubr ɛm nʼↄŋ jam ɛsɛl a ɛtŋ -li cɛc -nʼↄŋ agŋ a. ");
INSERT INTO adj_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɛl fɛŋ -lʼij ob lok iy ɛl ɛtŋ ɛmɛny ow wal es. Jam ɛsɛl a ot ekpr a eke wal es a as luku, ɛtŋ ow iy mulu lɛw yony. ");
INSERT INTO adj_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Agŋ a fɛŋ ekʼij ob a ↄtu eke kʼij agŋ fandi yen; wɛl awlm ↄyↄw lel ey ab. ");
INSERT INTO adj_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Kpɛkŋ eke ow bʼuwr a, Jesu ↄŋ jam ɛsɛl a ok mijɛtŋ ab ɛm eke kʼikŋ anym im mij lekpl a e jam a, ke nʼánŋ in obi lʼafl agŋ ab es. ");
INSERT INTO adj_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Eke lʼafl wɛl es a, lʼuyu lafɛny ab af eke li ki ŋↄŋn Nyam. Eke lɛgŋ ew es a, nʼanŋ yogŋ in sↄny. ");
INSERT INTO adj_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Mijɛtŋ a gbɛ, wus ab a, nʼim kpekpe, mra am ɛlul il aŋke lɛf am ɛlu ↄbrʼr. ");
INSERT INTO adj_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Eke lɛgŋ am ɛny ow a, Jesu am an es mij ab af im ɛŋn in e jam ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Eke -lʼɛkan Jesu am an es mij af a, -li kpikprm es ɛtŋ -li dad ninɛ: «Na ↄŋnabŋ!» Ɛtŋ -nʼam ↄg erŋn ebl ɛm. ");
INSERT INTO adj_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Gbɛkↄ kpɛkŋ Jesu dad ɛl ninɛ: «Ɛrm úsu ↄny lokm! Erŋn kʼↄ́ny ↄny! Kↄ ɛm!» ");
INSERT INTO adj_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Piɛr ↄdu odad eb ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, eke ow el ŋ tasi, ke ↄŋ abusu mʼan es mij ab af mʼow mʼɛŋnʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Jesu ɛgŋ dad ninɛ: «Òw!» Piɛr ɛy ↄkm mijɛtŋ ab ɛm ɛtŋ am an es mij ab af im ɛŋnʼn. ");
INSERT INTO adj_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Gbɛkↄ eke lʼɛkn lɛf a e lɛc ekʼam ɛlu ↄkm a, erŋn owʼr sos ɛtŋ nʼam ɛmn. Lʼɛlu lebl li dad ninɛ: «Ɛgŋ gbɛl, èb ɛluʼm es!» ");
INSERT INTO adj_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kpɛkŋ Jesu ɛgŋm abu es ↄnyʼn, ɛtŋ dadʼr ninɛ: «Ɔmn ɛwʼŋ fuɛfuɛ tasi! Kↄ bla ɛtŋ bɛbar ee?» ");
INSERT INTO adj_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Ɛl yony mum -lʼok mijɛtŋ ab ɛm ɛtŋ lɛf a irm es. ");
INSERT INTO adj_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ow ↄŋ jam ɛsɛl a ekʼanŋ mijɛtŋ ab ɛm a, ok ↄwrↄkp wus Jesu ecʼany af ɛtŋ am dad ɛsɛ: «Ŋ gbɛ Nyam ecʼIy tasi!» ");
INSERT INTO adj_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Eke Jesu lele in e jam ɛsɛl ab ab ubr mij lekpl a e jam a ke -lʼitar es Genesarɛt wus af a, ");
INSERT INTO adj_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","yogŋ ecʼagŋ a uw Jesu any ɛtŋ ɛwl susu a fɛŋ in ecʼow ecʼamani. Ɛtŋ wɛl ot ↄ́lu fɛŋ isʼr. ");
INSERT INTO adj_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","-Nʼam ŋↄŋn ow eke ow ki yɛb wɛl itŋn in e mob sus ɛm a ecʼɛnyɛmbri a cɛ abu, ɛtŋ agŋ a fɛŋ ekʼam itŋn in e mob sus ɛm a abu a, am ewl. ");
INSERT INTO adj_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Sica Farisiɛl lele ol eci low yɛgm ɛsɛl ab anŋ Jerusalɛm ow ɛŋn Jesu ɛtŋ am ibrmʼn ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","«Kↄ bla ɛtŋ ŋ e jam ɛsɛl a ɛ́luam ɛy lagŋɛl ecʼɛb ir owi a ekʼↄŋ ɛy a ee? Tasi ɛm a, low yɛgm a am ibrm eke wɛl ki yↄg sabu gbuŋ ke ij ob, kↄ -li kokmn.» ");
INSERT INTO adj_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesu dad ɛl ninɛ: «Ɛtŋ kↄ ↄny, bla sosiɛm ɛtŋ ↄny ecʼɛb ir ecʼów a sosiɛm ɛ́luamn Nyam ecʼol ab ee? ");
INSERT INTO adj_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Tasi ɛm a, Nyam dad ninɛ: Ɛ̀lum asŋ lele esŋ ab, ɛtŋ ɛmɛny: ɛgŋ eke bi yayr ɛs lele lis ab a, lʼit eke wɛl kʼibiʼr. ");
INSERT INTO adj_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Kↄ ↄny, ↄny e low yɛgm ab ɛm bi dadr ɛsrɛ: ekʼɛgŋ nyam in dad ow ɛs oglog ow lis in ɛsɛ: “Ob a eke mi kʼↄŋʼŋ ŋ ecʼabu ɛlum ecʼa, mʼoc mʼɛw es Nyam ecʼegb wawr eci,” ");
INSERT INTO adj_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ke ɛgŋ ikŋ na, ↄny ecʼa, yecʼeke li kʼↄŋ ɛs a, nʼŋgboŋ ow e low ɛm ŋ̂. Ɛbɛn eke bʼisr Nyam ecʼodad ab es ↄŋn ↄny ecʼagŋ ɛm ecʼów a usu ana! ");
INSERT INTO adj_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ɔny, agŋ ɛnyɛmbri yony yony ɛsɛl! Nawrɛ tasi, Esayi dad ↄny e lís e low na in e kokoba ↄb ab ɛm: ");
INSERT INTO adj_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Nyam dad eke: “Agŋ amua na nɛny ɛm ↄfr ↄfr -nʼam kↄklm im, kↄ ɛl ecʼɛrm a kpab es ɛm e lís. ");
INSERT INTO adj_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Nuŋ ↄfr ↄfr agŋ amua am igŋʼm, aŋke agŋ ɛm ecʼów anake -li bʼoc -li yɛgmn agŋ low a.” » ");
INSERT INTO adj_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Sica Jesu ɛsŋ dedeku a ɛtŋ am dad ɛl ɛsɛ: «Ìgŋn lↄru es irir low na sɛnyn sɛnyn: ");
INSERT INTO adj_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ow elm ob eke bʼɛy ɛgŋ nɛnym a, ↄↄm ɛgŋ uwm anŋ, kↄ low eke bʼanŋ ɛgŋ nɛnym ɛy ↄkm a, low na anake bʼↄŋ ɛgŋ úwm anŋ a.» ");
INSERT INTO adj_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Low na af jam ɛsɛl a ow ɛŋn Jesu ɛtŋ am dadʼr ɛsɛ: «Odad na eke dad Farisiɛl iri a, kↄ uw any ekʼow ɛy ɛl sos ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Li dad ninɛ: «Likŋ fɛŋ ekʼelm ɛm Ɛs ekʼanŋ afr eci likŋ ekʼewl a, li bʼow lʼiri ow es. ");
INSERT INTO adj_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɛ̀gbr ɛl es, -lʼel ány eflu ekʼam nyimn ány eflu! Ekʼany eflu nyam am nyimn any eflu ɛjeci nyam, ɛl yony mum -li bʼow -lʼok nↄmu nyam ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Piɛr ↄdu odad eb ɛtŋ am dadʼr ɛsɛ: «Òtar nyandrɛ ɛm odad na e low akr ok ɛy.» ");
INSERT INTO adj_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesu dad ninɛ: «Kↄ ↄny bↄbↄ yɛji, kʼirimn low na eci nyandrɛ ab ee? ");
INSERT INTO adj_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Kↄ uwmn any eke ob fɛŋ eke bʼɛy ɛgŋ nɛnym a, bʼim ɛy lokm, ke sica nʼanŋ lokm a lʼɛy ↄkm ee? ");
INSERT INTO adj_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Low eke bʼanŋ nɛnym ɛy ↄkm a, ɛrm ɛm ow bʼanŋ ow; ɛtŋ low na anake bʼↄŋ ɛgŋ uwm anŋ a. ");
INSERT INTO adj_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tasi ɛm a, sow tutr eŋuŋ eke bʼↄŋ ɛgŋ ibi ɛgŋ, ɛrum yↄw ɛjecʼab, ij nfaci, iy mil, ij daŋku yadŋ ke dád sodad eŋuŋ ok agŋ af a, ɛrm ɛm -li bʼanŋ -lʼow. ");
INSERT INTO adj_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ów amua anake bʼↄŋ ɛgŋ uwm anŋ a! Ij ob ke kí yↄgm abu a ↄ́ↄm ɛgŋ uwm anŋ.» ");
INSERT INTO adj_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɛtŋ Jesu igb yogŋ im Tir lele Sidↄn ab eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kpɛkŋ kin Kana wus af e yↄw nyam ekʼir wus ikpr ab af a, ow ɛŋnʼn ɛtŋ am ɛlu lebl dad ɛsɛ: «Ɛgŋ gbɛl, David e lilaw, ìkŋʼm sↄrŋ! Kↄ abŋ ŋuŋ am ijr ɛm jↄw gbre, ow kʼakplm kaka!» ");
INSERT INTO adj_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Gbɛkↄ Jesu cicm sar okmʼn es. In e jam ɛsɛl a ow titmʼn ɛtŋ am dadʼr ɛsɛ: «Ògŋʼn kↄ nʼam us ɛy jam lʼↄgr ɛy nↄnↄ.» ");
INSERT INTO adj_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesu dad ninɛ: «Nyam ɛrmʼm Israɛl ecʼagŋ a ekʼanŋ ɛsɛ mɛcɛb ekʼirm af a eci cɛ.» ");
INSERT INTO adj_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Kↄ yↄw a ow ok ↄwrↄkp wus in ecʼany af ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, ìkŋʼm sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesu dad ninɛ: «Ow itm eke wɛl kʼoc etuey ecʼob ij ↄŋ mↄwr.» ");
INSERT INTO adj_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Yↄw a dad ninɛ: «Ɛgŋ gbɛl, tasi, gbɛkↄ mↄwr yɛji, ɛl eci es ɛw ɛsɛl eci ob ij a ecʼekpr a eke bʼanŋ tabl af ok wus a, -li bʼij.» ");
INSERT INTO adj_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ow ↄŋ Jesu dadʼr ninɛ: «Oy! Ɔmn agbʼŋ gbɛ! Bʼow ɛŋn low a ekʼam erur a.» Ɛtŋ wanci ab af cɛ, yↄw a ecʼiy a ewl. ");
INSERT INTO adj_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Sica Jesu igb yogŋ im ɛy Galile eci mij lekpl a ogŋ. Lʼuyu ligigl nyam af li sig es. ");
INSERT INTO adj_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Agŋ nↄnↄ ow ɛŋnʼn. -Lʼism akr kpɛcɛ ɛsɛl, ány eflu, sos ɛ́yru, ɛbrmɛl, lele ↄ́lu ɛjeci nↄnↄ ab. -Lʼok wɛl es Jesu ecʼany af ɛtŋ lʼewlm wɛl. ");
INSERT INTO adj_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Eke -lʼɛkan ɛbrmɛl dad ów, sos ɛ́yru ewl, akr kpɛcɛ ɛsɛl an es lele ány eflu ekʼɛkn es ab ab a, agŋ a low iti any afŋn es ɛtŋ -nʼam kↄklm Israɛl e Nyam a. ");
INSERT INTO adj_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ɛmɛny Jesu ɛsŋ in e jam ɛsɛl a ɛtŋ dad ninɛ: «Agŋ amua e low am ↄnyʼm sↄrŋ, aŋke kin sɛgŋ emum nyahan eke -nʼanŋn ɛm ab ke -nʼↄnym ob kaka eke -li kʼij. Mʼerurm eke mi kʼↄŋ ɛl -nʼim namn; ejagb -lʼↄtu eke -li kʼɛŋn es abur.» ");
INSERT INTO adj_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jam ɛsɛl a dadʼr ninɛ: «Kↄ usu saw ɛm aŋa, bogŋ sʼↄtu eke si kʼɛŋn ob ij sʼↄŋ agŋ amua ij lok iy ee?» ");
INSERT INTO adj_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ɛtŋ Jesu ibrm ɛl ninɛ: «Kↄ futufutu abi ↄnymn ab ee?» Ɛtŋ -li dad ninɛ: «Futufutu lↄbŋ lele ↄcn ekekey abi ka ab.» ");
INSERT INTO adj_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ca li dad agŋ a eke kʼok es wus. ");
INSERT INTO adj_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ɛtŋ lʼot futufutu lↄbŋ a lele ↄcn ab ab, lʼɛlu Nyam bia, li bubr ɛm nʼↄŋ in e jam ɛsɛl a, ɛtŋ -li cɛc agŋ a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Ɛl fɛŋ -lʼij lok iy ɛl. Jam ɛsɛl a ot ekpr a eke wal es a as luku, ɛtŋ ow iy mulu ɛgbɛl lↄbŋ. ");
INSERT INTO adj_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Agŋ a ekʼij ob a ij agŋ fandi yar, wɛl awlm ↄyↄw lele etuey ab. ");
INSERT INTO adj_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Eke sica Jesu ↄŋ bieku a im a, lʼɛy mijɛtŋ ab ɛm ɛtŋ nʼim Magadan eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farisiɛl lele Sadusiɛl ab ow ɛŋn Jesu eke kʼɛbmʼn. -Lʼibrm ow ninɛ: «Ɛ̀lu mɛny ɛwr nyam ↄkm yɛgm ɛy ekʼow el Nyam ɛrmʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Kↄ Jesu dad ɛl ninɛ: «Lɛgŋ es ew ɛm bi dadr ɛsrɛ: “Efi e lɛgŋ a bʼow akpl, aŋke afr ebl es.” ");
INSERT INTO adj_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ɛtŋ ibribr fafa, eke afr bʼibr es a, bi dadr ɛsrɛ: “Yɛfɛnyna nyam bʼow an.” Lɛgŋ eci elel eke bʼanŋn a bʼuwr any, kↄ sɛgŋ amua eci mɛny ɛwr a, ↄ́tumn uwmn any! ");
INSERT INTO adj_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Yɛfɛnyna ecʼagŋ eŋuŋ amua eke íjm nɛny nyam Nyam ecʼany af a am ibrm mɛny ɛwr; kↄ wɛl kʼow kokm mɛny ɛwr kaka ↄↄm ɛl ekʼow elm Jonas ecʼa cɛ.» Ɛtŋ lʼɛlu wɛl es nʼim. ");
INSERT INTO adj_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Eke jam ɛsɛl a im ok mij lekpl a e jam a, -lʼijl es eke -li kʼoc futufutu. ");
INSERT INTO adj_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jesu dad ɛl ninɛ: «Ɛ̀wr ɛrm! Ɔ̀sur sos Farisiɛl lele Sadusiɛl ab eci lijru a e lís.» ");
INSERT INTO adj_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Jam ɛsɛl a am dadarir ɛl ↄfr ɛsɛ: «Eke sʼocm futufutu a sosiɛm anake nʼam dad ów amua a.» ");
INSERT INTO adj_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesu uw odad a eke -nʼam dad ab any ɛtŋ li dad wɛl ninɛ: «Bla sosiɛm ɛtŋ am dadr ↄny ↄfr ɛm ɛsrɛ: “Eke sʼebm futufutu a sosiɛm ee?” Kↄ kʼirimn cɛ ee! ");
INSERT INTO adj_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ow kʼokm ↄny es sos ɛm cɛ ee? Futufutu yen a eke mi bubr ɛm, mʼↄŋ agŋ fandi yen lele ekpr a eke wal es eci mulu abi a eke otr imn a, kↄ kʼↄknmn ow e low ee? ");
INSERT INTO adj_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ɛtŋ kↄ futufutu lↄbŋ a eke mi bubr ɛm mʼↄŋ agŋ fandi yar a, lele ekpr a eke wal es a eci mulu ɛgbɛl abi a eke otr imn a, kʼↄknmn ow e low ee? ");
INSERT INTO adj_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ɔ̀sur sos Farisiɛl lele Sadusiɛl ab e lijru a e lís. Kↄ ayaf ↄtur eke kʼuwmn any ekʼow elm futufutu ecʼodad mi dadm ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ca jam ɛsɛl a iri ekʼow elm lijru a eke wɛl bʼoc kokr futufutu a ecʼodad Jesu dadm ɛl, kↄ Farisiɛl lele Sadusiɛl ab e low yɛgm a e low. ");
INSERT INTO adj_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jesu im ɛy Sesare Filip ecʼɛb ɛm. Nʼam ibrm in e jam ɛsɛl a lʼɛsɛ: «Ayaf agŋ bi dadr ɛgŋ ecʼIy e lís ee?» ");
INSERT INTO adj_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","-Li dad ninɛ: «Agŋ bɛb bi dad ɛsɛ ŋ Jan mij ok nuŋ ɛs, bɛb bi dad ɛsɛ ŋ Eli, ɛtŋ agŋ likpr ecʼa, -li bʼocʼŋ ɛsɛ Jeremi oglog kokoba ↄb ɛs ɛjeci nyam af.» ");
INSERT INTO adj_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ɛtŋ Jesu ibrm ɛl ninɛ: «Kↄ ↄny obi ↄny obi a, ayaf bʼocarʼm ee?» ");
INSERT INTO adj_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simↄ Piɛr dad ninɛ: «Ŋ Mesi a, Nyam a ekʼanŋ owr ecʼIy.» ");
INSERT INTO adj_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ca Jesu dadʼr ninɛ: «Simↄ Jonas jim, ehe él ŋ eci, aŋke nawrɛ ikŋ na, ow elm ɛgŋ ɛlum ↄkm dadmʼŋ, kↄ ɛm Ɛs ekʼanŋ afr a. ");
INSERT INTO adj_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Sica ɛm, mʼam dadʼŋ mʼɛsɛ: ŋ Lob, ɛtŋ lob ikŋ na af, mʼow mʼus ɛm e Nyamel a. Luw ecʼabusu a kʼↄtum ↄnym lɛc in af. ");
INSERT INTO adj_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mʼow mʼↄŋʼŋ Afr e gbreŋgbi usu a eci sisafuɛ a: low fɛŋ eke bʼow igŋ wus af aŋa a, Afr bʼow igŋ; low fɛŋ eke bʼow eb wus af aŋa a, Afr yɛji bʼow eb.» ");
INSERT INTO adj_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesu ijl in e jam ɛsɛl a nɛny dad ninɛ: «Kì dadr ɛgŋ kaka eke mʼel Mesi a.» ");
INSERT INTO adj_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lɛgŋ a cɛ, Jesu ↄb nuŋ am dad ulm in e jam ɛsɛl a es ɛsɛ: «Ow it eke mi kʼim Jerusalɛm ke yogŋ mʼíj gbre nↄnↄ, agŋ ekpekp, egb waw ɛsɛl ɛgbɛl, lel ol e low yɛgm ɛsɛl ab ab ecʼabu ɛm. Wɛl bʼow ibiʼm ɛtŋ sɛgŋ nyahan mʼow mʼigb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ɛbɛn a, Piɛr ocʼr ab im saw ɛm ɛtŋ am ɛnymʼn abr dad ɛsɛ: «Ɛgŋ gbɛl! Nyam ↄ́ny ocʼŋ es ɛm! Low na kʼow ɛŋnmʼŋ lɛgŋ kaka!» ");
INSERT INTO adj_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Gbɛkↄ Jesu ɛwl sos mɛny ɛtŋ am dad Piɛr ɛsɛ: «Satan, kpàbʼm es lís! Ŋ el ɛm ecʼejagb us e lirikp, aŋke ŋ e tutr a elm Nyam e tutr, kↄ agŋ ɛm eci.» ");
INSERT INTO adj_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ɛmɛny Jesu am dad in e jam ɛsɛl a ɛsɛ: «Ekʼɛgŋ nyam am erur eke kʼusʼm jam a, ow it ke li kí tutrm in e lís owi, lʼábu in obi ecʼolikŋ a, ke lʼúsʼm jam. ");
INSERT INTO adj_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Tasi ɛm a, ɛgŋ yecʼeke bʼow erur eke ki dogŋn in e sel a, bʼow irmn. Gbɛkↄ ɛgŋ yecʼeke bʼow irmn in e sel a ɛm sosiɛm a bʼow ɛŋn. ");
INSERT INTO adj_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Eke batŋ ɛgŋ nyam ↄny wus ecʼob fɛŋ ɛtŋ lʼirmn in e sel a, ke bla ow bʼow eel il ab ee? Kↄ bla ob iy ɛgŋ ↄtu eke kʼoc sↄgr in e sel ab ee? ");
INSERT INTO adj_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tasi ɛm a, ɛgŋ ecʼIy bʼow ow Ɛs ecʼanygbɛl ab ɛm lele in ecʼafr ɛrm ɛsɛl ab ab, ɛtŋ ɛgŋ ɛgŋ in eci es an ab ɛm, li bʼow li sↄg ow labm. ");
INSERT INTO adj_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Low nawrɛ mʼam dad ↄny: agŋ amua ekʼanŋ aŋa a e bɛb bʼow ɛkn ɛgŋ ecʼIy ow ɛsɛ ɛb ebu af gbuŋ ke -lʼuw.» ");
INSERT INTO adj_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Eke sɛgŋ nↄhↄn ɛc a, Jesu ɛsŋ Piɛr, Jak lele Jan ekʼel Jak lisijim ab ɛtŋ -li kpab es -nʼim saw ɛm ɛl sↄny lafɛny gege nyam af. ");
INSERT INTO adj_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Jesu itŋn sos ɛl ecʼany af: any am jɛjnʼn ɛsɛ ligbn af ɛtŋ in e mob sus ɛm a ufu pum pum pum anŋ ɛsɛ usuayl af. ");
INSERT INTO adj_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ɛtŋ kin, jam ɛsɛl nyahan a ɛkn Mois lele Eli ab ekʼilm any am dad ów Jesu ab. ");
INSERT INTO adj_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ɛtŋ Piɛr dad Jesu ninɛ: «Ɛgŋ gbɛl, ow akpl eke si kʼanŋ aŋa! Ekʼerur, aŋa mʼↄtu eke mi kʼus nuŋ igŋ usu nyahan: ŋ e nyam, Mois e nyam lele Eli e nyam ab.» ");
INSERT INTO adj_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Odad anŋ Piɛr nɛnym am dad ɛtŋ kpɛkŋ kin jru ekʼam jɛjn ow ubur ɛl es. Lebl nyam anŋ jru ab ɛm am ikŋ dad ɛsɛ: «Ɛgŋ na el ɛm ecʼIy eke mʼerur tasi; mʼoc ɛm eci sos ɛm iŋn fɛŋ mʼɛluʼl ɛm. Ìrir in e low!» ");
INSERT INTO adj_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Eke jam ɛsɛl a iri lebl ikŋ na a, erŋn ↄny ɛl afŋn es ɛtŋ -li bubu any es wus. ");
INSERT INTO adj_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jesu im titm ɛl, itŋn ɛl abu ɛtŋ dad ɛl ninɛ: «Ìgbr, kʼùrur erŋn.» ");
INSERT INTO adj_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","-Li gbigbl any ogŋ ɛtŋ -lʼɛknm ɛgŋ kaka ekʼow elm Jesu sↄny cɛ. ");
INSERT INTO adj_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Eke -nʼanŋn lafɛny ab af -nʼam us es a, Jesu am ijl ɛl nɛny dad ɛsɛ: «Low na ekʼɛkan a, kì dadr kokr ɛgŋ kaka toŋ bake ɛgŋ ecʼIy ígb agŋ ekʼuw ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ɛtŋ jam ɛsɛl a am ibrm Jesu ɛsɛ: «Dàd ɛy, kↄ bla sosiɛm ɛtŋ ol e low yɛgm ɛsɛl a bi dad ekʼEli in kʼow gbuŋ ke Mesi in ow ee?» ");
INSERT INTO adj_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesu dad ɛl ninɛ: «Tasi ɛm a, Eli eke li kʼow ke ni nyímn ów a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Gbɛkↄ mʼam dad ↄny ekʼEli ow lɛgŋ a ɛtŋ, agŋ ɛgŋm ebmʼn ɛtŋ kokʼr low yecʼeke -lʼerurir a. Ɛbɛn eke -li bʼow -li kok ɛgŋ ecʼIy sos keskes ana.» ");
INSERT INTO adj_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Sica jam ɛsɛl a iri eke Jan mij ok nuŋ ɛs ecʼodad anake Jesu am dad ɛl a. ");
INSERT INTO adj_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Eke Jesu lele in e jam ɛsɛl ab ab ow ok yogŋ a eke bieku a anŋ a, ɛgŋ nyam ow titm Jesu, ok ↄwrↄkp wus in ecʼany af ");
INSERT INTO adj_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, ↄny ɛm ecʼiy a eci sↄrŋ ikŋ. Lʼel krokro ɛs ɛtŋ ↄl a bʼijrʼr gbre toŋ sakp nↄnↄ ecʼa li bʼɛy alm, oglog mij ɛm. ");
INSERT INTO adj_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mʼocʼr mʼis ŋ e jam ɛsɛl a kↄ -lʼↄtum -lʼewlam ow.» ");
INSERT INTO adj_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jesu igbl lebl ogŋ dad ninɛ: «Wew! Ɔny eel agŋ eŋuŋ eke ↄmn anm ɛm tasi! Ɛmɛny sɛgŋ abi mʼit eke mi kʼanŋ ↄny ab ee? Ɛtŋ ɛmɛny sakp abi ow it eke mi kʼɛgŋ low na mʼeb ee? Òcr iy a isrʼm aŋa.» ");
INSERT INTO adj_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jesu ↄↄr abŋ ŋuŋ a abr ɛy ↄkm iy ab ɛm ɛtŋ lʼewl wanci ab af cɛ. ");
INSERT INTO adj_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jam ɛsɛl a im titm Jesu saw ɛm ɛtŋ ibrmʼn ninɛ: «Kↄ bla ɛtŋ ɛy sʼↄtum sʼↄnym abusu sʼogŋm abŋ na ee?» ");
INSERT INTO adj_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jesu dad ɛl ninɛ: «Ɔny ecʼↄmn a ufum es. Low nawrɛ mʼam dad ↄny: blel ↄnyn ↄmn ɛw likekli ɛsɛ likŋ e liy af, ↄtur eke ki dadr ligigl na ɛsrɛ: “Ìgb aŋa im yogŋ a”, li bʼow nʼim. Low kaka kʼow ↄtum akam ↄny.  ");
INSERT INTO adj_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Abŋ akpasu na, Nyam ŋↄŋn lele nɛny ɛnŋ ɛm ab cɛ wɛl ↄtu eke kʼogŋʼn.» ");
INSERT INTO adj_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lɛgŋ nyam, jam ɛsɛl a fɛŋ ɛŋanin Galile, ɛtŋ Jesu am dad ɛl ɛsɛ: «Wɛl bʼow ↄny ɛgŋ ecʼIy ɛlu agŋ abu ɛm, ");
INSERT INTO adj_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ke -lʼibi ow; gbɛkↄ sɛgŋ nyahan, li bʼow lʼigb luw ɛm.» Ow sosiɛm jam ɛsɛl a sos ↄw es nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Eke Jesu lele in e jam ɛsɛl ab ab ow ok Kapɛrnayum a, Nyamel gbɛl a eci wus labm eb ɛsɛl a ow ɛŋn Piɛr ɛtŋ am ibrmʼn ɛsɛ: «Kↄ ↄny eci low yɛgm ɛs a, nʼam sↄgm Nyamel gbɛl a eci wus labm ee?» ");
INSERT INTO adj_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piɛr dad ninɛ: «Njaŋ, li bi sↄg.» Wanci ab af a eke Piɛr am ɛy akŋ a, Jesu ikŋ anym eb odad ɛtŋ dadʼr ninɛ: «Simↄ, kↄ ayaf am tutar ee? Wus na eci ɛ́b ebu a, kↄ bwo ki sↄg wus labm ↄŋ ɛl ee? Ɛl ecʼɛb eyŋ a, kↄ etu agŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piɛr dad ninɛ: «Etu agŋ a cɛ.» Af yogŋ Jesu dad Piɛr ninɛ: «Ɛb eyŋ a ↄnym labm sↄg ij. ");
INSERT INTO adj_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Gbɛkↄ sʼerurm eke si kʼebal agŋ amua ɛrm es. Na sosiɛm ìm mij lekpl ab ɛm ↄwl ew; ↄcn krɛkrɛ a eke bʼow ↄny a, fìg in e nɛny a, bʼow ɛŋn os eke bʼow ɛbm ŋ lele ɛm ab eci wus labm a eci sↄg. Òc os a ow sↄg ɛl ɛy ecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Wanci ab af a, jam ɛsɛl a ow ɛŋn Jesu ɛtŋ am ibrmʼn ɛsɛ: «Afr eci gbreŋgbi usu yogŋ, kↄ bwo ecʼɛgŋ el ligbɛl ee?» ");
INSERT INTO adj_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jesu ɛsŋ iyli nyam ow, nʼinymn ow es ɛl ecʼaraŋn ");
INSERT INTO adj_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ɛtŋ li dad ninɛ: «Low nawrɛ mʼam dad ↄny: eke itŋnmn ↄnymn ɛrm ɛsɛ etuey af, kʼow ↄtumn ɛymn Afr eci gbreŋgbi usu a. ");
INSERT INTO adj_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Gbreŋgbi usu a ecʼɛgŋ ligbɛl a, in lʼel ɛgŋ a eke bʼis es ke bʼɛwl anŋ ɛsɛ iy na af a.» ");
INSERT INTO adj_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","«Eke ɛgŋ eb ey amua ɛm e nyam ɛm sosiɛm a, ke ɛm anake lʼebʼm a. ");
INSERT INTO adj_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Gbɛkↄ ɛgŋ eke bʼow ↄny ɛgŋ ekʼↄny ↄmn ɛm ɛm ɛsɛ iy na af ɛlu wus a, low ŋuŋ a eke li kʼɛŋn a agb nↄnↄ. Eke wɛl oc meb ucur lob ligbɛl ucuʼr ɛmn, ɛtŋ ↄny ɛman in okij a, ow akpl akm low ŋuŋ a eke wɛl ki kokʼr a. ");
INSERT INTO adj_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Bogŋ e gbre ana! Wus na af, ów nↄnↄ anŋ low ŋuŋ kok eci! Tasi ów amua bʼow anŋ sɛgŋ fɛŋ eci, gbɛkↄ gbre bʼow el ɛgŋ a eke bʼow kok ów amua a eci! ");
INSERT INTO adj_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Eke batŋ ow el ŋ ecʼabu a oglog ŋ e lakr a anake bʼↄŋ ɛy sikpl owi ɛm a, ke ùbrʼr es oc ↄwlʼl kpekpe; ow akpl ŋ eci eke kʼɛy sel ɛŋn tasi ab ɛm abu nyam coco ab oglog lakr nyam coco ab, ow a eke kʼɛli sabu yony lele akr yony ab, ke wɛl óc ↄwlʼŋ al a ekʼiram es ab ɛm a. ");
INSERT INTO adj_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ɛtŋ ekʼow el ŋ e nyamn a anake bʼↄŋ ɛy sikpl owi ɛm a, ↄkr ↄny oc es ocʼr ↄwlʼl kpekpe; ow akpl ŋ ecʼeke kʼɛy sel ɛŋn tasi ab ɛm nyamn nyam coco ab, ow a eke kʼɛli anyamn yony, ke wɛl óc ↄwlʼŋ gbre ij usu ecʼal ab ɛm a.» ");
INSERT INTO adj_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","«Ɛ̀wr ɛrm ɛm e jam ɛsɛl ey amua ɛm e nyam ecʼifn owi ɛm; tasi ɛm a, mʼam dad ↄny eke ɛl ecʼafr ɛrm ɛsɛl bʼanŋ sɛgŋ fɛŋ ɛm Ɛs ekʼanŋ afr a ecʼany af.  ");
INSERT INTO adj_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Kin low nyam, ↄny e tutr el bogŋ ecʼee? Eke ɛgŋ nyam ↄny mɛcɛb ekŋ yen, ɛtŋ ɛl ɛm eci nyam irm a, kↄ li kʼow lʼigŋm ekŋ yar lɛw libarm a lʼɛlum es lafɛny af yogŋ, nʼiim lʼↄlm yecʼa ekʼirm a lʼocm ee? ");
INSERT INTO adj_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Mʼam dad ↄny, eke nʼɛŋn ow, li bʼow nʼↄny sos ɛm iŋn licɛb na e nuŋ af lʼakm ekŋ yar lɛw libarm a ekʼiram a. ");
INSERT INTO adj_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ɛbɛn ekʼↄny Ɛs ekʼanŋ afr a erurm eke ɛm e jam ɛsɛl ey amua ɛm e nyam kʼirm ana.» ");
INSERT INTO adj_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","«Eke esŋ jim nyam kok low ŋuŋ ŋ e lís, ke ìm ɛŋnʼn ŋ sↄny, ke dádʼr in e low ŋuŋ a eke li kok a. Eke lʼiri ŋ ecʼodad a, ke esŋ jim a lʼel ŋ ecʼŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Kↄ eke lʼɛgŋm lʼirim ŋ ecʼodad a, òc ɛgŋ ɛjeci nyam oglog agŋ yony ab im, yecʼɛtŋ ke, ɛsɛ elel eke Nyam Lɛl a am dadr ab af a: odad fɛŋ eci nyinyimn ɛm, adaŋku yony oglog nyahan ánŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Gbɛkↄ eke lʼɛgŋm lʼirim wɛl ecʼodad a, dàd ok Nyamel; ɛtŋ eke lʼɛgŋm lʼirim Nyamel ecʼodad a, òcʼr ɛsɛ Nyam any uwm ɛs af oglog wus labm eb ɛs af. ");
INSERT INTO adj_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Low nawrɛ mʼam dad ↄny: low fɛŋ eke bʼow igŋn wus af aŋa a, Afr bʼow igŋ; low fɛŋ eke bʼow ebr wus af aŋa a, Afr yɛji bʼow eb. ");
INSERT INTO adj_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ɛmɛny mʼam dad ↄny, eke wus af aŋa, ↄny ɛm ecʼagŋ yony okr af eke kʼibrm low kaka fɛŋ jɛj ok owi ecʼa, ɛm Ɛs ekʼanŋ afr a bʼow ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Tasi ɛm a, yogŋ ekʼagŋ yony nyahan as luku ɛm e nin ɛm a, mʼanŋ ɛl ecʼaraŋn.» ");
INSERT INTO adj_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ɛtŋ Piɛr ow titm Jesu ɛtŋ am ibrmʼn ɛsɛ: «Ɛgŋ gbɛl, ekʼɛm lisijim bi kokʼm low ŋuŋ, ke sakp abi mi kʼoc mʼapʼr ee? Kↄ sakp lↄbŋ ee?» ");
INSERT INTO adj_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jesu dadʼr ninɛ: «Njaŋ, mi dadmʼŋ mʼɛsmɛ toŋ sakp lↄbŋ, kↄ toŋ sakp ekŋ nyahan lele lɛw ab toŋ sakp lↄbŋ. ");
INSERT INTO adj_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Na sosiɛm, kin Afr e gbreŋgbi usu a ecʼelel ekʼanŋn: ɛb ebu nyam erur eke kʼub in ecʼob a ekʼin eci juma kok ɛsɛl a ↄnymʼn ab a. ");
INSERT INTO adj_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Eke lʼↄb nuŋ nʼam kok ow e low a, wɛl oc juma kok ɛs nyam ekʼↄnymʼn os bubutɛ gbɛl ab isʼr. ");
INSERT INTO adj_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɛgŋ a ↄnym ob kaka eke kʼoc sↄgr in e labm a; ow sosiɛm ɛb ebu a ↄŋ abusu eke wɛl kʼↄlʼl ijʼr ɛsɛ aduigŋ af, ke wɛl ↄ́l in e yↄw, in ecʼey lele ob fɛŋ eke nʼↄny ab ab ij yecʼɛtŋ ke lʼↄ́tu li sↄg labm a. ");
INSERT INTO adj_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Juma kok ɛs a ok ↄwrↄkp wus ɛb ebu a ecʼany af ɛtŋ am dadʼr ɛsɛ: “Ɛrm ɛ́yʼŋ es, èku bɛb, mʼow mi sↄgʼŋ fɛŋ!” ");
INSERT INTO adj_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ɛb ebu a sↄrŋ ↄny nↄnↄ: lʼoc labm a lʼap ow ɛtŋ lʼɛlu ow es ow im. ");
INSERT INTO adj_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Juma kok ɛs a ecʼim ɛm a, lʼↄbr lawl juma kok ɛs nyam ekʼↄnymʼn os tɛl ab. Nʼↄny ow ɛmn ɛmn nʼam bↄbrm ow lʼatr ow sel li dad lʼɛsɛ: “Sↄg ɛm ecʼos a ekʼↄnym ab a!” ");
INSERT INTO adj_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Lawl a ok ↄwrↄkp wus in ecʼany af ɛtŋ am ŋↄŋnʼn ɛsɛ: “Ɛrm ɛ́yʼŋ es, èku bɛb, mʼow mi sↄgʼŋ!” ");
INSERT INTO adj_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Gbɛkↄ lʼɛgŋm; nʼↄny lʼɛlu ow sobel ɛm ekʼow kʼanŋ ɛm toŋ ke ow sↄ́gʼr labm a. ");
INSERT INTO adj_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Eke juma kok ɛsɛl ɛjecʼa ɛkn low a ekʼɛy a, sos ↄw ɛl es sɛnyn sɛnyn ɛtŋ -nʼim -lʼawl ów a fɛŋ -lʼok ɛb ebu a. ");
INSERT INTO adj_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Af yogŋ, ɛb ebu a ↄŋ wɛl ɛsŋ juma kok ɛs a ow ɛtŋ li dad ow ninɛ: “Juma kok ɛs ŋuŋ! Mʼoc ŋ e labm a fɛŋ mʼapʼŋ eke ŋↄŋnʼm a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ŋ yɛji, blel ↄ́ny awlʼŋ a eci sↄrŋ ikŋ ɛsɛ elel eke mʼↄny ŋ e sↄrŋ ikŋ ab af.” ");
INSERT INTO adj_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ɛb ebu a ɛrm ebl afŋn es ɛtŋ nʼↄny juma kok ɛs a lʼɛlu sobel ɛm milↄlu kokr eci toŋ ke li sↄ́g labm a fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Ɛtŋ Jesu igŋ af dad ninɛ: «Ɛbɛn eke ɛm Ɛs ekʼanŋ afr a bʼow kok ↄny ana, ekʼↄny ɛm ecʼɛgŋ nyam nyam ocm low ŋuŋ eke lisijim kokʼr a apmʼn ɛrm nyam ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Eke sica Jesu dad ów ↄm odad bake ow uwr a, lʼigb Galile ɛtŋ nʼim Jude wus af e mij jam ekʼel Jurdɛn a. ");
INSERT INTO adj_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Agŋ nↄnↄ am usʼr jam ɛtŋ lʼewlm ɛl ɛm ecʼↄ́lu a. ");
INSERT INTO adj_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farisiɛl bɛb ow titm Jesu eke kʼukʼr meb odad ebl ɛm. -Lʼibrm ow ninɛ: «Kↄ low kaka fɛŋ ɛm, ɛy ecʼol a ↄŋ abusu eke ɛgŋ kʼogŋ in e yↄw ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesu dad ninɛ: «Kↄ awlmn low yecʼa eke Nyam Lɛl dad ab ee? Nuŋ ↄb ɛm a, Nyam kok igŋ lele yↄw ab, ");
INSERT INTO adj_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ɛtŋ li dad ninɛ: Na sosiɛm anake igŋ bʼow ŋgboŋ ɛs lele lis ab ecʼakŋ, ke lʼókr af in e yↄw ab ab -lʼel sos megl nyam a. ");
INSERT INTO adj_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Ca -lʼelm agŋ yony ij, kↄ sos megl nyam. Ke ɛgŋ kʼↄ́nym yecʼeke Nyam ↄny okr af a kpabm es.» ");
INSERT INTO adj_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ɛmɛny Farisiɛl am ibrmʼn ɛsɛ: «Kↄ ɛgŋ am ow ogŋ in e yↄw a, bla sosiɛm ɛtŋ Mois bʼibrm eke wɛl kʼↄŋ ow igŋnin e lɛl ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Li dad ninɛ: «Ɔny ecʼɛrm tuↄtuↄ a sosiɛm anake Mois ↄŋ ↄny abusu eke kʼogŋn ↄny ecʼↄyↄw a. Kↄ nuŋ ↄb ɛm a, ow elm ɛbɛn ow ɛcrm. ");
INSERT INTO adj_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Mʼam dad ↄny: igŋ fɛŋ eke ɛlu in e yↄw es, ke ow elm egŋ ot owi ɛm, ke im ɛbi yↄw ɛjecʼa, lʼij nfaci ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","In e jam ɛsɛl a dadʼr ninɛ: «Ekʼow el ɛbɛn tasi ɛgŋ kʼanŋ in e yↄw ab a, ke ow akplm ekʼɛgŋ kʼɛbi yↄw.» ");
INSERT INTO adj_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesu dad ɛl ninɛ: «Agŋ a fɛŋ kʼↄtum ɛgŋm odad na ebm ekʼow elm agŋ a cɛ eke Nyam bʼↄŋ ow ecʼabusu a. ");
INSERT INTO adj_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ów nↄnↄ anŋ eke bʼɛdŋn agŋ yↄw ecʼɛbi agŋ: bɛb ecʼa, mew ɛm ɛtŋ -lʼijm ow e lɛc; bɛb ecʼa egŋ agbru, agŋ ↄŋ -nʼↄnym ow ecʼabusu; sica bɛb ecʼa, Afr eci gbreŋgbi usu e juma kok sosiɛm -lʼerurmn eke -li kʼɛbi yↄw. Ke ɛgŋ yecʼeke kʼɛgŋ low yɛgm na eb a, lʼɛ́gŋ lʼeb!» ");
INSERT INTO adj_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Sica agŋ ot etuey am is Jesu eke li kʼat wɛl abu nuŋ ni ŋↄŋn Nyam nʼↄŋ wɛl, kↄ jam ɛsɛl a am ɛnym agŋ a abr. ");
INSERT INTO adj_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Gbɛkↄ Jesu dad ninɛ: «Yɛ̀br etuey ow ɛm ogŋ! Ɛgŋ kʼɛ́dŋn ɛl, aŋke tasi ɛm a, Afr e gbreŋgbi usu a el agŋ a ekʼanŋ ɛsɛ ɛl af a eci.» ");
INSERT INTO adj_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Lʼat wɛl abu nuŋ lʼɛdŋ wɛl ↄwrↄ ɛtŋ lʼigb yogŋ nʼim. ");
INSERT INTO adj_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ɛtŋ kin ɛgŋ nyam ow ɛŋn Jesu ɛtŋ am ibrmʼn ɛsɛ: «Low yɛgm agŋ ɛs, kↄ bla low mamn iy mʼↄtu eke mi ki kok ke mʼɛ́ŋn sel ekʼↄnym uwr ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesu dadʼr ninɛ: «Kↄ bla sosiɛm ɛtŋ am ibrm im low yecʼa eke kʼakpl ab af ee? Nyam sↄny coco cɛ akpl. Eke batŋ am erur eke kʼɛy sel ekʼↄnym uwr ɛm a, ɛ̀lum sol a.» ");
INSERT INTO adj_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Lʼibrm ninɛ: «Kↄ bogŋ eci sol ee?» Jesu dad ninɛ: «Kʼíbim ɛgŋ, kʼíjm nfaci, kʼíym mil, kʼíjm daŋku yadŋ ɛm ɛgŋ e nuŋ af; ");
INSERT INTO adj_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ɛ̀lum asŋ lele esŋ ab, ke érur ɛgŋ kaka fɛŋ ɛsɛ ŋ obi af.» ");
INSERT INTO adj_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ŋgbafrɛli a dadʼr ninɛ: «Mi bʼɛlum sol amua fɛŋ. Ɛmɛny bogŋ ecʼanake anŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesu dadʼr ninɛ: «Ekʼam erur eke kʼanŋ ɛsɛ elel eke Nyam am erur ab af a, ke ìm ↄl ŋ ecʼob a eke ↄny a ij, òc ow ecʼos a ↄŋ ↄgbↄru, ke bʼow ɛŋn ob ↄny afr, ca ɛ́wl mɛny ow ke úsʼm jam.» ");
INSERT INTO adj_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ŋgbafrɛli a bʼiri low na a, nʼaam sos es ↄw ɛm aŋke tasi ɛm a, nʼↄny ob nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ɛtŋ sica Jesu dad in e jam ɛsɛl a ninɛ: «Low nawrɛ mʼam dad ↄny: ow ɛw tuↄtuↄ eke gbreŋgbi kʼɛy Afr eci gbreŋgbi usu a. ");
INSERT INTO adj_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ɛtŋ ɛmɛny, kin low nyam eke mʼam dad ↄny: gbaŋkↄ kedebnam eci fɛfn ↄmu ɛm eke kʼɛcr a ɛw fuɛfuɛ akm gbreŋgbi eci Nyam e gbreŋgbi usu a ecʼɛm ɛy a.» ");
INSERT INTO adj_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Eke jam ɛsɛl a iri ów amua a, low iti ɛl any ɛtŋ -nʼam dad -lʼɛsɛ: «Ke sica bwo ecʼɛgŋ ↄtu eke kʼɛŋn sel ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesu lɛr ɛl ɛtŋ dad ɛl ninɛ: «Agŋ ecʼany af a ow ɛw tuↄtuↄ, kↄ ow elm Nyam ecʼany af gbɛ, aŋke Nyam ecʼa, fɛŋ ɛw fuɛfuɛ!» ");
INSERT INTO adj_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ca kin Piɛr eb odad ɛtŋ dadʼr ninɛ: «Ŋ obi yɛji ɛ̀kn! Ɛy, sʼigŋ fɛŋ sʼok es ɛtŋ sʼusʼŋ jam. Kↄ ɛy ecʼa, ayaf ow bʼow ɛcr ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: lɛgŋ a eke ɛgŋ ecʼIy bʼow sig es in ecʼanygbɛl ecʼatufu lɛkpn af, ɛb owr ab ɛm yogŋ a, ↄny lɛw yony a ekʼusrʼm jam a, ↄny yɛji bʼow sigr es atufu mɛkpn af, ke jɛ́jr Israɛl ecʼeb lɛw yony a ecʼów okr. ");
INSERT INTO adj_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ɛtŋ agŋ a fɛŋ ekʼigŋ ɛl ecʼakŋ oglog ɛl lisijimɛl oglog ɛl lisijↄwɛl, ɛl ɛsɛl, ɛl lisɛl, ɛl ecʼey, ɛl e sↄgm ok es, ɛm e nin a sosiɛm a, -li bʼow -nʼɛŋn sakp ekŋ yen ok af ɛtŋ -li bʼow -nʼɛŋn sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Kↄ agŋ nↄnↄ a eke caca ɛm el ánymu a, bʼow el ajamu ɛtŋ agŋ nↄnↄ a eke caca ɛm el ajamu a, bʼow el ánymu.» ");
INSERT INTO adj_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","«Tasi ɛm a, kin elel eke Afr eci gbreŋgbi usu a anŋn: gbreŋgbi nyam ɛy ↄkm ibribr fafa eke kʼeb juma kok ɛsɛl in e viny ↄgm a eci, ɛtŋ nʼɛŋn. ");
INSERT INTO adj_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Nɛny okr ɛl af juma kok ɛsɛl ab ab os nyam, ekʼel lɛgŋ nyam e labm sↄg eci, ɛtŋ lʼot wɛl nʼim in ecʼↄgm a. ");
INSERT INTO adj_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Wanci libarm ɛm a, lʼɛy ↄkm ɛtŋ lʼɛkn bɛb ekʼanŋ ɛbɛrŋ ɛm ke ↄnym low kaka eke ki kok. ");
INSERT INTO adj_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Li dad wɛl ninɛ: “Ɔny yɛji ìmn ɛm ecʼↄgm a kokr juma, mʼow mʼↄŋ ↄny labm sↄg ekʼit a,” ");
INSERT INTO adj_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ɛtŋ -nʼim ↄgm a. Lɛgŋ bʼuyu nuŋ, ɛmɛny ↄgm ɛs a ɛy ↄkm ot agŋ ɛtŋ ɛmɛny ncebles eci wanci nyahan ɛm yɛji, lʼɛy ↄkm li kok ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Sica ncebles eci wanci yen ɛm a, lʼɛy ↄkm ɛtŋ ɛmɛny lʼɛkn agŋ ɛjeci ekʼanŋ ɛbɛrŋ ɛm yogŋ. Lʼibrm wɛl ninɛ: “Kↄ bla ɛtŋ lɛgŋ mum a bʼanŋn ↄfr ↄfr nɛnɛ ee?” ");
INSERT INTO adj_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","-Li dad ninɛ: “Ɛgŋ kaka ebm ɛy juma.” Li dad wɛl ninɛ: “Ekʼow el ɛbɛn, ke ↄny yɛji, ìmn ɛm eci viny ↄgm a kokr juma.” ");
INSERT INTO adj_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Eke lɛgŋ ew es a, ↄgm ɛs a dad in ecʼob awl ɛs a ninɛ: “Ɛ̀sŋ juma kok ɛsɛl a ke sↄ́g ɛgŋ ɛgŋ e labm a. Bʼow ↄb nuŋ ajamu ab ɛm toŋ ke úwar ánymu ab ɛm.” ");
INSERT INTO adj_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Agŋ a ekʼↄb juma nuŋ ncebles eci wanci yen ɛm a ow, ɛtŋ ɛgŋ ɛgŋ ɛŋn in ecʼos nyam a. ");
INSERT INTO adj_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Eke sica ow igŋ agŋ a eke wɛl ikŋ anym eb a ogŋ a, -li tutr eke -li bʼow -nʼɛŋn ow afŋ es; gbɛkↄ ɛl yɛji, wɛl ↄŋ ɛl ɛgŋ ɛgŋ os nyam. ");
INSERT INTO adj_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Os a ecʼeb ɛm a, -nʼam ɛny abr -lʼok ↄgm ɛs ab af ");
INSERT INTO adj_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","-li dad -lʼɛsɛ: “Juma kok ɛsɛl amua eke wɛl anŋ jam eb a, wanci nyam eci juma cɛ -li kok ɛtŋ sↄg ɛl labm ɛsɛ ɛy eke lɛgŋ mum a sʼij gbre ligbn kpaŋ kpaŋ na ɛm ab af!” ");
INSERT INTO adj_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Gbɛkↄ ↄgm ɛs a dad ɛl ɛm ecʼɛgŋ nyam ninɛ: “Lawl, mi kokm ɛnyɛmbri yony owi ŋ e lís. Nɛny okr ɛy af os nyam ekʼel lɛgŋ nyam juma eci, kↄ yadŋ ee? ");
INSERT INTO adj_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Èb ŋ e labm sↄg a ke ím. Mʼerur eke ɛgŋ na eke wɛl anŋ jam eb a, mʼↄ́ŋʼn os a ɛsɛ ŋ ecʼab af. ");
INSERT INTO adj_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Kↄ mʼↄnym abusu eke ɛm ecʼos a, mi ki kokr low yecʼeke mʼerur ab ee? Kↄ ɛm ecʼɛrm mamn a e low a, nyamn ɛyr ow am ↄnyʼŋ ee?” » ");
INSERT INTO adj_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Ɛtŋ sica Jesu igŋ af dad ninɛ: «Agŋ ekʼel ajamu a bʼow el ánymu, ɛtŋ agŋ ekʼel ánymu a, bʼow el ajamu.» ");
INSERT INTO adj_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesu lele in e jam ɛsɛl ab ab am uyu im Jerusalɛm. Es an im ɛm a, lʼot jam ɛsɛl lɛw yony ab ab nʼim saw ɛm, ɛtŋ nʼam dad wɛl lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Ìsr any ɛkan, kin Jerusalɛm anake sʼam uyu sʼim a; yogŋ, ɛgŋ ecʼIy bʼow ɛy egb waw ɛsɛl ɛgbɛl lel ol e low yɛgm ɛsɛl ab ab ecʼabu ɛm. -Li bʼow -lʼↄb ow low luw eci, ");
INSERT INTO adj_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ɛtŋ -li bʼow -lʼoc ow -nʼↄŋ Nyam any uwm ɛsɛl eke ki kokrʼr miyɛr, ↄrʼr say ɛm, ɛwʼr olikŋ af luw eci. Eke ow bʼow kok sɛgŋ nyahan a, li bʼow lʼigb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Sica Sebede ecʼey yony a ecʼɛl lis a ow titm Jesu, lʼok ↄwrↄkp wus ow ecʼany af ɛtŋ nʼam ibrm ow ob. ");
INSERT INTO adj_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesu ibrmʼn ninɛ: «Kↄ bla low iy am erur ee?» Li dad ow ninɛ: «Ɛ̀gŋ eb eke ɛm ecʼey yony amua bʼow ok es susu amamn lɛgŋ eke bʼow eb ŋ ecʼɛb eb e lɛkpn a; nyam ánŋ lidr ogog ke nyam ánŋ nɛmn ogog.» ");
INSERT INTO adj_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesu dad ɛl ninɛ: «Low yecʼa ekʼam ibrmn a, kʼuwmn any. Kↄ ↄtur eke kʼɛgŋn gbre eci mij kpↄk a eke mʼow mʼɛgŋ ab ee?» -Li dad ow ninɛ: «Ɛɛ, sʼↄtu.» ");
INSERT INTO adj_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesu dad ɛl ninɛ: «Tasi ɛm a, bʼow ɛgŋn ɛm e mij kpↄk a. Gbɛkↄ ɛm e lidr abu af ecʼes sig a, lele nɛmn abu af ecʼab ab a, ow elm ɛm mʼↄↄm ɛgŋ; susu amua, ɛm Ɛs kok agŋ a eke li bɛbm sos a eci.» ");
INSERT INTO adj_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Eke jam ɛsɛl agŋ lɛw a iri low na a, -lʼebl ɛrm -lʼok agŋ lisijimɛl yony ab af. ");
INSERT INTO adj_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ow sosiɛm Jesu ɛsŋ ɛl fɛŋ ɛtŋ dad ɛl ninɛ: «Ɛkan ɛb ecʼes ɛw ɛsɛl a, -li bʼɛw ɛb ab es abusu ↄny ɛm, ɛtŋ ɛl ɛm ecʼagŋ any ɛsɛl ekʼanŋ a bʼɛlu ɛl ecʼabusu ↄny a ↄkm dedeku a e nuŋ af. ");
INSERT INTO adj_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Gbɛkↄ ↄny ecʼaraŋn ecʼa, ow kʼɛ́cr ɛbɛn. Eke batŋ ↄny ɛm ecʼɛgŋ kaka fɛŋ am erur e kʼel ↄny ecʼes ɛw ɛs a, ke lʼél ↄny a fɛŋ ecʼob oc ↄŋ ɛs; ");
INSERT INTO adj_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ɛtŋ ɛmɛny ekʼↄny ɛm ecʼɛgŋ kaka fɛŋ am erur eke kʼel ↄny ecʼanymu a, ke lʼél ↄny a fɛŋ ecʼadu. ");
INSERT INTO adj_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ɛbɛn nyam coco ɛgŋ ecʼIy yɛji owm ekʼagŋ ki kok in e lís e low, kↄ lʼow eke li ki kok agŋ e lís e low, ke lʼóc in e sel a lʼɛw awoba li sↄgr agŋ nↄnↄ.» ");
INSERT INTO adj_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Eke -lʼokr ↄkm Jeriko a, agŋ nↄnↄ am us Jesu jam. ");
INSERT INTO adj_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Kpɛkŋ kin, ány eflu yony eke sig es ejagb saw, -lʼiri eke Jesu am ɛc. -Nʼam ɛlu lebl -li dad -lʼɛsɛ: «Ɛgŋ gbɛl, David e lilaw, ìkŋ ɛy sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Dedeku a am ɛnym ɛl abr eke -li ki yewal, gbɛkↄ ca -nʼam ɛlu lebl tuↄtuↄ -li dad -lʼɛsɛ: «Ɛgŋ gbɛl, David e lilaw, ìkŋ ɛy sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jesu inym es ɛtŋ ɛsŋ ɛl am ibrm ɛl ɛsɛ: «Kↄ bla low iy am erurir eke mi ki kok mʼↄŋ ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","-Li dad ow ninɛ: «Ɛgŋ gbɛl, kòk ke ɛy ecʼanyamn a ɛ́kn es.» ");
INSERT INTO adj_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ɛl e low ↄny Jesu sↄrŋ ɛtŋ lʼitŋn wɛl ecʼanyamn a abu; kpɛkŋ agŋ a yony mum am ɛkn es, ɛtŋ -nʼam us Jesu jam. ");
INSERT INTO adj_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sica Jesu lele in e jam ɛsɛl ab ab im titm Jerusalɛm. Eke -li titmn Bɛtfaje baŋn, Olivie lafɛny af a, Jesu ɛrm jam ɛsɛl yony. ");
INSERT INTO adj_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Li dad wɛl ninɛ: «Ìmn baŋn a ekʼanŋ ↄny any af ab ɛm; kpɛkŋ yogŋ bʼow ɛŋan gbaŋkↄ kpɛtɛŋ yↄw nyam eke wɛl ucur es ke in e liy a anŋ in ab. Mↄmun in es otr ɛl isrʼm. ");
INSERT INTO adj_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Eke batŋ ɛgŋ bʼibrm ↄny low, dàdr ɛsrɛ: “Ɛgŋ gbɛl a ↄny ow ecʼes abur.” Ɛtŋ kpɛkŋ wɛl bʼow ɛlu ɛl es ↄŋ ↄny.» ");
INSERT INTO adj_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Low na ɛy yecʼɛtŋ ke kokoba ↄb ɛs eci sodad amua eke dad a íy nɛny: ");
INSERT INTO adj_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Dàdr Siↄn ecʼagŋ a: kin ↄny ecʼɛb ebu a am ow ↄny ogŋ a frↄrↄ ɛm, lʼuyu gbaŋkↄ yↄw lele in e liy ab af. ");
INSERT INTO adj_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Jam ɛsɛl yony a im, ɛtŋ kok yecʼa eke Jesu dad ɛl a. ");
INSERT INTO adj_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","-Lʼot gbaŋkↄ kpɛtɛŋ yↄw a lele liy ab ab -lʼow, -lʼot ɛl e sigbad a -lʼok wɛl af ɛtŋ Jesu sig es af. ");
INSERT INTO adj_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Agŋ nↄnↄ gbɛl ot ɛl e sigbad a faf ejagb, bɛb am bubr ekŋ ál ok ejagb. ");
INSERT INTO adj_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Agŋ a ekʼanŋʼn anym a lele bɛb a ekʼanŋʼn jam ab ab am ↄg dad ɛsɛ: «Hosana! Anygbɛl él David e lilaw eci. Ke Nyam ɛ́dŋ ɛgŋ ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ! Anygbɛl él Nyam ekʼanŋ afr kpekpe a eci!» ");
INSERT INTO adj_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Ɛtŋ eke nʼam ɛy Jerusalɛm a, bieku a fɛŋ am bↄbar. Wɛl am ibrm ɛsɛ: «Kↄ bwo el ɛgŋ na ee?» ");
INSERT INTO adj_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Agŋ a am dad ɛsɛ: «Ɛgŋ na, kokoba ↄb ɛs Jesu, Nasarɛt ekʼanŋ Galile wus af a ecʼɛgŋ.» ");
INSERT INTO adj_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Sica Jesu im ɛy Nyamel gbɛl a e gbugŋ a, ɛtŋ ogŋ agŋ a fɛŋ ekʼam ↄl mob ij a, lele agŋ a ekʼam ↄl mob ab ab gbugŋ yogŋ. Nʼↄny jɛtɛ titŋn ɛsɛl a e sitabl a lele prɛndrɛ ↄl ij ɛsɛl a e mɛkpn ab ab lʼok wus. ");
INSERT INTO adj_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ɛtŋ li dad wɛl ninɛ: «Nyam Lɛl ɛm a Nyam dad ninɛ: Wɛl bʼow ɛsŋ ɛm ecʼêl a, Nyam ŋↄŋn ecʼêl. Kↄ ↄny, am ocr kokr elu ecʼɛŋanin usu.» ");
INSERT INTO adj_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ány eflu lele akr kpɛcɛ ɛsɛl ab ow titm Jesu Nyamel gbɛl a e gbugŋ a ɛtŋ lʼewlm wɛl. ");
INSERT INTO adj_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Egb waw ɛsɛl ɛgbɛl a lele ol e low yɛgm ɛsɛl ab ab ɛkn ów any iti owi eke nʼam kok, -lʼɛkn etuey ekʼam ↄg Nyamel gbɛl ab ɛm dad ɛsɛ: «Anygbɛl él David e lilaw eci!» Ɛrm ebl ɛl, ");
INSERT INTO adj_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ɛtŋ -li dad Jesu ninɛ: «Kↄ am iri odad a eke -nʼam dad ab ee?» Jesu dad ɛl ninɛ: «Ɛɛ, mʼam iri kↄ lɛgŋ kaka awlmn Nyam Lɛl ɛm ecʼodad na ekʼel: Kok elel eke toŋ etuey lele ey mɛny nɛnym ab bↄbↄ yɛji kↄklmʼŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ɛtŋ lʼɛlu wɛl es lʼɛy ↄkm ɛb ab ɛm, nʼim Betani lʼɛru. ");
INSERT INTO adj_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lɛgŋ bʼɛny akr af ecʼibribr fafa a, eke Jesu am ɛwl ow ɛb ab ɛm a, namn owʼr sos. ");
INSERT INTO adj_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Lʼɛkn babm ikŋ nyam ekʼinym es ejagb saw ɛtŋ nʼim lʼɛy ow ecʼew a; gbɛkↄ nʼɛŋnm ob kaka ekʼow elm suw a cɛ. Li dad babm ikŋ a ninɛ: «Lɛgŋ kaka kʼow ↄsum liy ij!» Kpɛkŋ wanci ab af cɛ babm ikŋ a inym es uw es. ");
INSERT INTO adj_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Jam ɛsɛl a bʼɛkn ɛbɛn a, low iti ɛl any afŋn es, ɛtŋ -nʼam ibrm Jesu -lʼɛsɛ: «Kↄ ayaf ɛtŋ babm ikŋ na inym es kpɛkŋ uw es ee?» ");
INSERT INTO adj_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: eke ↄnyn ↄmn ɛtŋ bɛbar anm ↄny ɛm a, ↄtur eke ki kokr low na eke mi kok babm ikŋ na a. Ow elm low na sↄny cɛ, kↄ ↄtur yɛji eke ki dadr ligigl na ɛsrɛ: “Ŋ̀gboŋ aŋa, ke ím ɛy okij ɛm,” ɛtŋ ow bʼow el. ");
INSERT INTO adj_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Eke ↄnyn ↄmn, bʼow ɛŋan low fɛŋ eke bʼow ibrmn Nyam ŋↄŋn ɛm a.» ");
INSERT INTO adj_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jesu ɛwl ow Nyamel gbɛl a e gbugŋ a ɛtŋ am yɛgm agŋ low. Egb waw ɛsɛl ɛgbɛl lele Jwifɛl ecʼagŋ ekpekp ab ab ow ɛŋnʼn ɛtŋ am ibrmʼn ɛsɛ: «Kↄ bogŋ ecʼabusu ɛm bi kok ów amua ee? Ɛtŋ kↄ bwo bʼↄŋʼŋ ow e kok ecʼabusu ee?» ");
INSERT INTO adj_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesu dad ɛl ninɛ: «Ɛm yɛji mʼam ow mʼibrm ↄny low nyam cɛ; eke dadrʼm a, ɛm yɛji mi bʼow mi dad ↄny abusu yecʼɛm eke mi bi kok ów amua a. ");
INSERT INTO adj_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Kↄ bwo ↄŋ Jan abusu ow ok agŋ mij nuŋ ee? Kↄ Nyam oglog agŋ ee?» Ɛtŋ ow ɛw ɛl ów es atar ɛl ↄfr ɛtŋ -nʼam dad -lʼɛsɛ: «Eke si dad eke Nyam ↄŋʼn abusu lʼow, li bʼow lʼibrm ɛy lʼɛsɛ: “Kↄ bla sosiɛm ɛtŋ ubmn in nawrɛ ee?” ");
INSERT INTO adj_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ɛtŋ eke si dad eke agŋ ↄŋʼn abusu lʼow yɛji, ow it eke si kʼↄny dedeku a e muru, aŋke tasi ɛm a, agŋ a fɛŋ bʼoc Jan ɛsɛ kokoba ↄb ɛs af.» ");
INSERT INTO adj_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ɛtŋ sica -li dad Jesu ninɛ: «Sʼuwm any.» Ɛtŋ Jesu yɛji dad ɛl ninɛ: «Eke ow el ɛbɛn a, ɛm yɛji mi kʼow mi dadm ↄny abusu yecʼɛm eke mi bi kok ów amua fɛŋ a.» ");
INSERT INTO adj_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesu usr af dad ninɛ: «Kↄ ayaf am ɛkanin low na ee? Ɛgŋ nyam ↄny ey yony. Lɛgŋ nyam, li dad iy kpekp a ninɛ: “Ɛm jim, yɛfɛnyna ìm ↄgm kok juma.” ");
INSERT INTO adj_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Li dad ninɛ: “Mʼiim”, gbɛkↄ ow bʼinŋn ebr a, lʼitŋn odad ebl ɛtŋ nʼim ↄgm a. ");
INSERT INTO adj_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Odad nyam a cɛ, iy ɛs a dad ok jam ɛs a. Iy a dad ɛs ninɛ: “Mʼow mʼim,” gbɛkↄ nʼiim. ");
INSERT INTO adj_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Agŋ yony na, bogŋ ecʼanake kok ɛs ecʼerur ab ee?» -Li dad ninɛ: «Iy kpekp a.» Ɛtŋ Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: wus labm eb ɛsɛl lele afacyↄw ab bʼow ikŋ ↄny anym Nyam e gbreŋgbi usu a. ");
INSERT INTO adj_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Tasi ɛm a, Jan mij ok nuŋ ɛs ow ↄny ogŋ low nɛnyɛmbri nyam e yɛgm eci, ɛtŋ ubmn in nawrɛ; gbɛkↄ wus labm eb ɛsɛl lele afacyↄw ab ubʼr nawrɛ. Ɛtŋ ɛmɛny ów amua bↄbↄ ekʼɛkan a yɛji, itŋnmn ɛrm ɛm ubmn in nawrɛ.» ");
INSERT INTO adj_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","«Ìrir nyandrɛ ɛm odad ɛjeci na: lɛgŋ nyam, ↄgm ɛs nyam ewl viny in ecʼↄgm a. Nʼawŋ lakp lʼɛlul ɛm, li kok usu eke wɛl kʼifi egb ey ab es, ɛtŋ li kok usu gege eke wɛl kʼanŋ ↄsu ↄgm a. Ɛtŋ lʼoc egb ↄgm a lʼabul ↄgm juma kok ɛsɛl ɛtŋ lʼeb ejagb nʼim usu. ");
INSERT INTO adj_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Eke egb ub e lakpo ow a, lʼɛrm in ecʼabu ɛlum ɛsɛl a im ↄgm juma kok ɛsɛl a ogŋ eke li kʼɛŋn in ecʼegb eke kʼɛbmʼn a. ");
INSERT INTO adj_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ɔgm juma kok ɛsɛl a ↄny in ecʼabu ɛlum ɛsɛl a, ↄr nyam, ibi yecʼa, ɛtŋ nyahan ɛm ecʼa, -lʼibi ow mebn ɛm. ");
INSERT INTO adj_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Sica ↄgm ɛs a ɛrm in ecʼabu ɛlum ɛsɛl a im nↄnↄ ɛm akm krɛkrɛ ɛm ecʼa, kↄ ↄgm juma kok ɛsɛl a kok ɛl low nyam cɛ. ");
INSERT INTO adj_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ow e jam a, lʼɛrm in ecʼiy a ɛtŋ nʼam tutr lʼɛsɛ: “-Li bʼow -nʼↄny ɛm jim ecʼɛlum.” ");
INSERT INTO adj_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Gbɛkↄ eke ↄgm juma kok ɛsɛl a ɛkn iy a, -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: “Kin ɛgŋ a eke godo godo bʼow el aja ij ɛs a! Sʼímn, sʼíbir ir ke egb ↄgm a él ɛy eci!” ");
INSERT INTO adj_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","-Nʼↄny iy a, -lʼoc -nʼim -lʼↄwl ow ↄgm a e lakp jam a ɛtŋ -lʼibi ow.» ");
INSERT INTO adj_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesu ibrm ɛl ninɛ: «Ɛtŋ sica lɛgŋ eke egb ↄgm ɛs a bʼow ow a, bla lowi li bʼow li kok ↄgm juma kok ɛsɛl ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","-Li dad ow ninɛ: «Agŋ ibiu amua ecʼa, sↄrŋ ikŋ kʼow anm ɛm, li bʼow lʼibi wɛl, lʼéb ↄgm a lʼabul ↄgm juma kok ɛsɛl ɛjeci. Eke egb ub e lɛgŋ a bʼow ow a, wɛl bʼow ↄŋʼn in ecʼegb ekʼit a.» ");
INSERT INTO adj_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Ɛtŋ Jesu dad ɛl ninɛ: «Kↄ awlmn lɛgŋ kaka Nyam Lɛl ecʼodad eke dad ab ee? Lebn a eke êl us ɛsɛl a oc ↄwl a, ɛwl el êl lↄy ɛm e lebn tasi. Na low ekʼanŋ Nyam ogŋ ow ke el low sↄbↄ ɛy ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jesu igŋ af dad ninɛ: «Mʼam dad ↄny, na sosiɛm wɛl bʼow eb ↄny Nyam e gbreŋgbi usu a abu ɛm ↄŋ ɛbr nyam ecʼagŋ a eke bʼow kok ow e low a.  ");
INSERT INTO adj_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɛgŋ eke bʼow ɛy lebn na af a, bʼow kikn es, ɛtŋ ɛgŋ fɛŋ eke lebn a bʼow ɛy af a, bʼow piplm ɛm el siflefl.» ");
INSERT INTO adj_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Egb waw ɛsɛl ɛgbɛl lele Farisiɛl ab iri Jesu eci sodad a, ɛtŋ -lʼuw any eke ow am dad ɛl ecʼodad. ");
INSERT INTO adj_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","-Nʼam ↄl akunda yecʼɛm eke -li kʼɛdŋn Jesu, gbɛkↄ -nʼam uru dedeku a, aŋke agŋ amua bʼoc Jesu ɛsɛ kokoba ↄb ɛs af. ");
INSERT INTO adj_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ɛmɛny Jesu oc nyandrɛ ɛm odad am dad ok agŋ a ekʼow low iri ɛm a. Nʼam dad wɛl lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Kin Afr eci gbreŋgbi usu a ecʼelel eke anŋn: es ɛw ɛs nyam kok ob ij, jim e mɛbi ecʼes gbɛgbl a eci. ");
INSERT INTO adj_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Lʼɛrm in eci juma kok ɛsɛl a im eke kʼɛsŋ agŋ a eke lʼɛw abu ob ij na ecʼa, kↄ -lʼɛgŋm -lʼowm. ");
INSERT INTO adj_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ɛmɛny lʼɛrm juma kok ɛsɛl ɛjeci ɛtŋ li dad wɛl ninɛ: “Dàdr agŋ a eke mʼɛw abu a: Sica wɛl iny ob ab ŋ̂, wɛl ibi ɛm eci sed a, mindey sↄbↄ fɛŋ iy nɛny. Òwr mɛbi a ecʼes gbɛgbl a ecʼob ij ab ɛm!” ");
INSERT INTO adj_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Gbɛkↄ agŋ a eke wɛl ɛw abu a tutrm ow e low ɛtŋ im ɛl ecʼów ɛm: nyam ecʼa, in ecʼↄgm owi ɛm, yecʼa, in ecʼan ↄl owi ɛm; ");
INSERT INTO adj_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","bɛb ↄny juma kok ɛsɛl a, ijr gbre ɛtŋ ibi ɛl. ");
INSERT INTO adj_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Es ɛw ɛs a ɛrm ebl: lʼɛrm in ecʼar ɛsɛl a im ibi agŋ ibiu amua ɛtŋ ɛtul ɛl ecʼɛb a. ");
INSERT INTO adj_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Sica li dad juma kok ɛsɛl a ninɛ: “Mɛbi a ecʼes gbɛgbl ecʼob ij a bɛbmn ab, gbɛkↄ agŋ a eke mʼɛw abu a itm. ");
INSERT INTO adj_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Ìmn sɛbɛrŋ ɛm, ke ɛ́wr agŋ ekʼↄtur eke kʼɛŋan a abu ob ij a eci.” ");
INSERT INTO adj_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Juma kok ɛsɛl a im sɛbɛrŋ ab ɛm, as agŋ a fɛŋ eke -nʼam ɛŋn a luku, amamn lele eŋuŋ ab, ɛtŋ es gbɛgbl usu a agŋ iy gbↄŋ. ");
INSERT INTO adj_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Es ɛw ɛs a ɛy akŋ eke kʼɛkn agŋ a eke wɛl im ot ow a, ɛtŋ lʼɛkn ɛgŋ nyam ekʼɛwm es gbɛgbl a ecʼob sos. ");
INSERT INTO adj_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Li dad ow ninɛ: “Lawl, kↄ ayaf ɛyr akŋ aŋa, ɛtŋ ɛwm es gbɛgbl a ecʼob sos ee?” Ɛgŋ a yewal tiŋ. ");
INSERT INTO adj_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Ɛtŋ es ɛw ɛs a dad juma kok ɛsɛl a ninɛ: “Àwŋn in sabu lele akr ab, ke ócr ↄwal il gbeŋ ncebn ab ɛm. Yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a.” » ");
INSERT INTO adj_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesu igŋ af dad ninɛ: «Tasi ɛm a, wɛl ɛw nↄnↄ abu, kↄ tɛl cɛ wɛl sↄsum ot.» ");
INSERT INTO adj_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sica ow ↄŋ Farisiɛl a im ut asre. -Nʼam bɛbm elel eke -li kʼuk Jesu meb ke -nʼↄny ow odad ebl ɛm. ");
INSERT INTO adj_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ow bʼuwr a, -lʼɛrm ɛl e jam ɛsɛl ab ɛm ecʼagŋ bɛb lele Erↄd ecʼogog ecʼagŋ ab im dad Jesu ninɛ: «Low yɛgm agŋ ɛs, sʼuw any eke ŋ bi dad low nɛnyɛmbri nyam: Nyam ecʼelel eke am ibrm eke si kʼiir ɛb a, bi yɛgm ow ecʼejagb a kpɛŋ. Ɔ́nym ɛgŋ kaka e muru; ŋ ecʼa, agŋ a fɛŋ el agŋ nɛnyɛmbri nyam. ");
INSERT INTO adj_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Dàd ɛy yecʼekʼam tutr odad na af a: kↄ ɛy ecʼol ab ɛm abusu ɛru es eke si ki sↄg wus labm sʼↄŋ Sesar ee?» ");
INSERT INTO adj_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Gbɛkↄ Jesu uw ɛl eci sow tutr eŋuŋ ab any, ɛtŋ li dad wɛl ninɛ: «Ɛnyɛmbri yony yony ɛsɛl, kↄ bla sosiɛm ɛtŋ am ukrʼm meb ee? ");
INSERT INTO adj_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Yɛ̀gmnʼm os a eke wɛl bʼoc sↄgr wus labm a.» -Lʼoc os deŋ nyam -lʼow -li yɛgm ow, ");
INSERT INTO adj_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ɛtŋ Jesu ibrm ɛl ninɛ: «Mɛny ɛwr na lele nin na eke wɛl nↄn os na af a, bwo ecʼɛgŋ ecʼow el ee?» ");
INSERT INTO adj_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","-Li dad ninɛ: «Sesar eci.» Ɛtŋ Jesu dad ɛl ninɛ: «Eke ow el ɛbɛn a, ke ↄŋn Sesar yecʼekʼel Sesar ecʼa, ke ↄ́ŋn Nyam yecʼekʼel Nyam ecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Eke -lʼirir odad a, low iti ɛl any afŋn es, ɛtŋ -lʼɛlu ow es -nʼim. ");
INSERT INTO adj_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Lɛgŋ a cɛ, Sadusiɛl bɛb ow ɛŋn Jesu. (Ke Sadusiɛl anake bi dad ɛsɛ luw ɛm anŋ igb in anm a.) -Nʼam ibrm Jesu low na ");
INSERT INTO adj_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","-lʼɛsɛ: «Low yɛgm agŋ ɛs, kin Mois ecʼelel eke dadr: Eke ɛgŋ nyam uw ɛtŋ lʼewm ey a, ow it eke lisijim kʼɛbi iŋnyↄw a ew ey in ab ɛwʼr nin es. ");
INSERT INTO adj_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kin ɛy ɛm ecʼagŋ lisijimɛl lↄbŋ e low ekʼɛŋn: likpekp a ɛbi yↄw, ewm iy kaka toŋ ɛtŋ lʼuw. Eke lʼewm iy a, lʼɛlu lisijim iŋnyↄw ab es. ");
INSERT INTO adj_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Lisijim yony ɛm a yɛji ɛbɛn, nyahan ɛm ecʼa yɛji ɛbɛn; ɛtŋ ɛl lↄbŋ mum ecʼa, ow el ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Eke ɛl fɛŋ -lʼuwr a, yↄw a yɛji uw. ");
INSERT INTO adj_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Sica lɛgŋ eke agŋ ekʼuw a bʼow igb luw ɛm a, agŋ lisijimɛl lↄbŋ a, bwo ecʼɛgŋ anake yↄw a bʼow el in ecʼab ee? Aŋke ɛl fɛŋ -lʼɛbi ow, ow el ɛl e yↄw!» ");
INSERT INTO adj_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesu dad ɛl ninɛ: «Ɔny, ekʼam irmn, aŋke uwmn Nyam Lɛl a eke wɛl nↄn a ab any, ɛtŋ Nyam ecʼabusu a yɛji uwmn any. ");
INSERT INTO adj_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Tasi ɛm a, lɛgŋ ekʼagŋ ekʼuw a bʼow igb a, egŋ lele ↄyↄw ab kʼow ɛbirm okm es ij, kↄ -li bʼow -lʼir ɛb ɛsɛ elel eke afr ɛrm ɛsɛl anŋn afr ab af. ");
INSERT INTO adj_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yecʼa eke kʼel agŋ eke kʼigb luw ɛm a, kↄ awlmn lɛgŋ kaka low yecʼa eke Nyam dad ↄny ab ee? Li dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ɛm mʼel Abraham e Nyam, Isak e Nyam, lele Jakↄb e Nyam ab.» Ɛtŋ Jesu usr af dad ninɛ: «Kↄ agŋ ekʼuw a e Nyam li kʼel ee? Njaŋ, lʼel agŋ ekʼuw ke anŋ owr a e Nyam.» ");
INSERT INTO adj_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Eke dedeku a iri low na a, ow ↄr ɛl. ");
INSERT INTO adj_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Eke Farisiɛl iri eke Jesu abl Sadusiɛl nɛny es odad ebl ɛm a, -lʼut asre. ");
INSERT INTO adj_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ɛtŋ ɛl ɛm ecʼol e low yɛgm ɛs gbɛl nyam erur eke kʼɛbm Jesu. Lʼibrm ow ninɛ: ");
INSERT INTO adj_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","«Low yɛgm agŋ ɛs, kↄ ol a fɛŋ ɛm e ligbɛl el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesu dadʼr ninɛ: «Bʼow erur Asŋ Kↄtↄkↄ ŋ e Nyam ŋ ecʼɛrm fɛŋ ɛm, ŋ ecʼabŋ fɛŋ ɛm, lele ŋ e tutr pupukpaŋ ab. ");
INSERT INTO adj_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Na anakʼel ol ab ɛm e ligbɛl lele ow eci tasi ab a. ");
INSERT INTO adj_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ɛtŋ kin yony ɛm ecʼeke akpl ot krɛkrɛ ecʼab es: bʼow erur ɛgŋ kaka fɛŋ ɛsɛ ŋ obi ŋ obi af. ");
INSERT INTO adj_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Mois ecʼol a fɛŋ lele kokoba ↄb ɛsɛl eci low yɛgm ab ab anŋ ol yony na ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Farisiɛl as luku ɛtŋ Jesu am ibrm ɛl low na: ");
INSERT INTO adj_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","«Tutr eke ↄnyn Mesi a e lís el bogŋ ecʼee? Bwo e lilaw eel ee?» -Li dad ow ninɛ: «Lʼel David e lilaw.» ");
INSERT INTO adj_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Jesu dad ɛl ninɛ: «Ɛtŋ kↄ sica ayaf David ekʼAbŋ Lala nyimn a ↄtu ɛsŋʼn “Ɛs Kↄtↄkↄ” ee? Ke David dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ɛs Kↄtↄkↄ Nyam dad ɛm Ɛs Kↄtↄkↄ ninɛ: Òw sig es ɛm e lidr abu af toŋ bake mʼót ŋ ecʼefnu a mʼok ŋ ecʼakr ew. ");
INSERT INTO adj_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Eke sica David bʼɛsŋʼn “Ɛs Kↄtↄkↄ”, ke ayaf Mesi a ↄtu eke kʼel David e lilaw ee?» ");
INSERT INTO adj_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Ɛl ɛm ecʼɛgŋ kaka ↄtum pigm nɛny dadm odad nyam coco yɛji, ɛtŋ ow e lɛgŋ a ɛtŋ a, ɛgŋ kaka úsm ibramʼn low ij. ");
INSERT INTO adj_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Sica Jesu am dad bieku a lel in e jam ɛsɛl ab ab ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Wɛl abul ol e low yɛgm ɛsɛl a lele Farisiɛl ab ab Mois ecʼol a ecʼakr otar. ");
INSERT INTO adj_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ow sosiɛm ɛ̀lumn ɛl, ke kókr low yecʼa eke -li bi dad ↄny a, gbɛkↄ kʼèbr ɛl ecʼes an a e lakr, aŋke low a eke -li bi yɛgm agŋ a, -li kokmn. ");
INSERT INTO adj_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ow bʼel ɛrɛkp leg leg eke -li bʼawŋ -lʼitm agŋ ↄbi af, kↄ ɛl obi ɛm a, -lʼɛgŋmn -lʼocmn abuli ɛm -lʼɛluamn agŋ abu uyum sɛrɛkp leg leg amua. ");
INSERT INTO adj_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ɛl ecʼów fɛŋ e kok ɛm, -li bʼerur ekʼɛgŋ ki lɛr ɛl. Ow ɛm a, Nyam odad a eke -li bʼoc -lʼucu ɛl e sos a, bʼɛw low agbr ɛm. Ɛtŋ ɛmɛny ɛl eci mob af ɛw a ecʼɛnyɛmbri a eke -li bi gigŋ a yɛji bʼar es afŋn es. ");
INSERT INTO adj_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ekʼow el ob ij ecʼes gbɛgbl ɛm yɛji, -li bʼerur susu amamn, ɛtŋ Nyam nuŋ igŋ susu a, -li bi dogŋn mɛkpn anym es; ");
INSERT INTO adj_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","-li bʼerur eke dedeku ɛm wɛl kʼɛsŋn ɛl ɛlum ɛm, ɛtŋ ɛmɛny -li bʼerur ekʼagŋ kʼɛsŋ ɛl “Low yɛgm agŋ ɛs”. ");
INSERT INTO adj_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Gbɛkↄ ↄny, kʼↄ̀ŋn agŋ kʼɛsŋ ↄny “Low yɛgm agŋ ɛs”, aŋke ɛgŋ nyam coco cɛ bi yɛgm ↄny low ɛtŋ ↄny fɛŋ eel agŋ lisijimɛl ↄfr. ");
INSERT INTO adj_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Wus af aŋa, kʼɛ̀sŋn ɛgŋ kaka ɛy “Ɛs”, aŋke ɛgŋ Ɛs nyam coco ↄnyn, in a ekʼanŋ afr a. ");
INSERT INTO adj_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ɛtŋ ɛmɛny kʼↄ̀ŋn ɛgŋ kʼɛsŋ ↄny “Es Ɛw Ɛs”, aŋke Es Ɛw Ɛs nyam coco ↄnyn, in lʼel Mesi a. ");
INSERT INTO adj_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ow it ekʼↄny ɛm ecʼɛgŋ ligbɛl a kʼél ↄny ecʼob oc ↄŋ ɛs. ");
INSERT INTO adj_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɛgŋ eke bʼow igblʼl in sosi ogŋ a, wɛl bʼow isʼr es, gbɛkↄ ɛgŋ eke bʼow is es a, wɛl bʼow igblʼl ogŋ.» ");
INSERT INTO adj_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","«Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke bʼabal Afr eci gbreŋgbi usu a e lisany a agŋ ecʼany af. Ɔny obi ókmn ɛm ɛtŋ agŋ a eke bʼerur eke kʼok ɛm a, ɛ́gŋmn -lʼokmn ɛm.  ");
INSERT INTO adj_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny, agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke bʼɛcar mij af eci, wus wɛwɛ af eci imn susu fɛŋ eke kʼɛŋan ɛgŋ nyam coco eke kʼus ↄny jam; eke bʼɛŋan in a, bi kokar ir lʼot gbre ij usu ecʼɛgŋ es sakp yony lʼakm ↄny. ");
INSERT INTO adj_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Nyimn ɛsɛl ekʼany efl, gbre él ↄny eci! Ɔny bi dadr ɛsrɛ: “Ekʼɛgŋ nyam ij nɛny Nyamel gbɛl a e nin ɛm, ke nʼanm nɛny ij ab ɛm; kↄ eke lʼij nɛny sika a ekʼanŋ Nyamel gbɛl ab ɛm a e nin ɛm, ke nʼanŋ nɛny ij ab ɛm.” ");
INSERT INTO adj_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ɔny anyamb agŋ! Ány eflu! Kↄ bogŋ ecʼob anake ↄny any ab ee? Sika a, kↄ Nyamel gbɛl a eke bʼↄŋ sika a ↄny any ab ee? ");
INSERT INTO adj_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ɛmɛny bi dadr yɛji ɛsrɛ: “Ekʼɛgŋ ij nɛny egb waw usu e nin ɛm, ke nʼanm nɛny ij ab ɛm; kↄ eke lʼij nɛny ob ap a ekʼanŋ egb waw usu a e nin ɛm a, ke nʼanŋ nɛny ij ab ɛm.” ");
INSERT INTO adj_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ány eflu! Bogŋ ecʼob anake ↄny any ab ee? Ob ap a, kↄ egb waw usu a eke bʼↄŋ ob ap a ↄny any ab ee? ");
INSERT INTO adj_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ɛgŋ ekʼam ij nɛny egb waw usu a e nin ɛm a, am ij nɛny egb waw usu a lel ob fɛŋ ekʼanŋ egb waw usu ab ab e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ɛgŋ ekʼam ij nɛny Nyamel gbɛl a e nin ɛm a, am ij nɛny Nyamel gbɛl a lele Nyam ekʼir ɛm ab ab e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɛgŋ ekʼam ij nɛny afr e nin ɛm a, am ij nɛny Nyam e lɛkpn a lele Nyam eke sig es af ab ab e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke bʼↄŋn Nyam ↄny ecʼob ekʼewal a eci sakp lɛw ɛm toŋ mob sↄsŋn ob ab yɛji, gbɛkↄ bʼigŋn low yɛgm amamn a ekʼel ol a ecʼa ɛlul es, ɛsɛ jɛj ok nyim nyim, sↄrŋ ikŋ lele nɛny nyam ij ab. Ke tasi ɛm a, low na anake wɛl ki kok a, ke ow e likpr a yɛji, wɛl kʼigŋm ɛlum es. ");
INSERT INTO adj_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Nyimn ɛsɛl ekʼany efl! Bʼↄsr mij es eke kʼↄnyn kpikpi ekʼanŋ ɛm a ocr es, kↄ bʼɛman gbaŋkↄ kedebnam! ");
INSERT INTO adj_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke ↄny e mij kpↄk lel ↄny e kpokpo ab ab e jam jam a, bʼɛtŋn es, kↄ ow e lokm a, ów eŋuŋ bʼiy ɛm: sos es ↄnyn anm ↄny ɛm, bʼerurir ob ↄny toŋ él ↄny mil. ");
INSERT INTO adj_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farisiɛl ekʼany efl, tɛ̀tŋn mij kpↄk a e lokm ab es yɛ, ɛtŋ ow e jam jam a yɛji bʼow ayl. ");
INSERT INTO adj_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke ↄny bʼotr suwↄmu eke wɛl ufur es; ow ecʼaf a bʼakpl, kↄ ow e lokm a, agŋ ekʼuw ecʼew lele kpↄtↄm owi ab bʼanŋ. ");
INSERT INTO adj_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ɛbɛn nyam coco ↄny yɛji, sos af a, bi yɛgmn agŋ ekʼijr nɛny nyam Nyam ecʼany af, kↄ ↄny e lokm a, ów ɛnyɛmbri yony yony lele ów eŋuŋ ab iy ɛm gbↄŋ. ");
INSERT INTO adj_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Ol e low yɛgm ɛsɛl lele Farisiɛl ab, ↄny agŋ ɛnyɛmbri yony yony ɛsɛl, gbre él ↄny eci! Aŋke bi kokr kokoba ↄb ɛsɛl eci suwↄmu a akpl, ɛtŋ bʼijr mɛwl nɛny nyam ɛsɛl ecʼab af, ");
INSERT INTO adj_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ɛtŋ bi dadr ɛsrɛ: “Blel ɛy lagŋɛl e lɛgŋ ab ɛm sʼanŋ ana, ke blel nɛny okrm ɛy af sʼibim kokoba ↄb ɛsɛl a.” ");
INSERT INTO adj_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ɛbɛn a, ↄny obi ɛm uwar ↄny sosi any eke eel agŋ a ekʼibi kokoba ↄb ɛsɛl a ecʼalaw. ");
INSERT INTO adj_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Sica ↄny ecʼa, abu ánŋ ↄny ɛm! Ùwarir low yecʼa eke ↄny lagŋɛl ↄb nuŋ a! ");
INSERT INTO adj_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ɔny morŋn kpu ecʼeb amua, ayaf ↄtur eke kʼánmn gbre ij usu ee? ");
INSERT INTO adj_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Na sosiɛm kin, mʼow mʼɛrm kokoba ↄb ɛsɛl, agŋ nuŋ ɛm ↄny ɛsɛl lele low yɛgm ɛsɛl tasi ab ↄny ogŋ. Ɔny bʼow ibir bɛb, ɛwr bɛb ol likŋ af. Ɔny e Nyam nuŋ igŋ usu a, bʼow ↄↄr bɛb say ɛm, ɛtŋ bʼow ogŋn ɛl es ɛb ɛb ɛm. ");
INSERT INTO adj_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ow ɛm a, bʼow ɛŋan low nɛnyɛmbri nyam ɛsɛl eci low ŋuŋ a eke wɛl kok a ecʼabr ɛnym ekʼit a. Ow ↄb nuŋ nɛny nyam ɛs Abɛl eci low ŋuŋ a eke wɛl kok ab ɛm, ɛtŋ ow im toŋ ɛdŋ nuŋ Zakari Baraki jim ecʼab ɛm. Ibir ir egb waw usu a lele usu lala ab ab ecʼaraŋn a. ");
INSERT INTO adj_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Low nawrɛ mʼam dad ↄny: ów eŋuŋ a ecʼabr ɛnym a ekʼit a bʼow ɛy yɛfɛnyna ecʼagŋ a e nuŋ af!» ");
INSERT INTO adj_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","«Jerusalɛm Jerusalɛm, ŋ eke bʼibi kokoba ↄb ɛsɛl ke bʼↄr agŋ eke Nyam bʼɛrm ow ŋ ogŋ a mebn ɛm a! Sakp abi mʼerur eke mi kʼas ŋ ecʼey luku ɛm e lís, ɛsɛ elel eke ŋgↄs ey lis bʼas in ecʼey luku ↄw éw ab af, ɛtŋ ɛ́gŋm! ");
INSERT INTO adj_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ow sosiɛm kin, Nyam bʼow digŋ ↄny ecʼakŋ a ɛlu es foŋ. ");
INSERT INTO adj_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Tasi ɛm mʼam dad ↄny: kʼow ɛknmnʼm toŋ ba ke lɛgŋ a ow; yogŋ anake bʼow dadr ɛsrɛ: “Ke Nyam ɛ́dŋ ɛgŋ ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ a!” » ");
INSERT INTO adj_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesu ɛy ↄkm Nyamel gbɛl ab ɛm ɛtŋ aam. In e jam ɛsɛl a im ɛŋnʼn eke ki yɛgmʼn Nyamel gbɛl a ecʼelel eke wɛl usr a. ");
INSERT INTO adj_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Jesu ↄdu odad eb ɛtŋ am dad ɛl ɛsɛ: «Am ɛkan ów amua fɛŋ ee? Low nawrɛ mʼam dad ↄny: aŋa lebn kaka kʼow usrm lawl lebn af anm, fɛŋ bʼow ɛr ok wus.» ");
INSERT INTO adj_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Eke Jesu sig es Olivie lafɛny af a, jam ɛsɛl a im ɛŋnʼn in sↄny ɛm ɛtŋ am ibrmʼn ɛsɛ: «Dàd ɛy ↄ! Kↄ bogŋ lɛgŋ iy low na bʼow ɛy, ɛtŋ bogŋ eci mɛny ɛwr bʼow yɛgm ŋ e mowrer lele wus na e nuŋ ɛdŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesu dad ɛl ninɛ: «Ɛ̀wr ɛrm! Kì yɛbr ɛgŋ kʼirmn ↄny. ");
INSERT INTO adj_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Tasi ɛm a, agŋ nↄnↄ bʼow ow ɛm e nin ɛm dad ɛsɛ: “Ɛm Mesi a”, ɛtŋ -li bʼow -lʼirmn agŋ bubutɛ. ");
INSERT INTO adj_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Bʼow irir ar ekʼam ɛy aŋa e likekr lele ar owi eke bʼow ɛy akpoj a ecʼamani ab; kì yɛbr erŋn kʼↄny ↄny. Ow it ekʼów amua kʼɛy, kↄ ow kʼelm wus na e nuŋ ɛdŋ. ");
INSERT INTO adj_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tasi ɛm a, ɛbr nyam ecʼagŋ bʼow im ɛŋn ɛbr ɛjeci nyam ogŋ ar; es ɛw nyam bʼow im ɛŋn es ɛw ɛjeci nyam ar ogŋ eci; lek bʼow ɛy ɛtŋ wus bʼow umu susu susu af. ");
INSERT INTO adj_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ów amua fɛŋ bʼow ɛw ɛsɛ iy ↄnyn eci dudu krɛkrɛ ab af. ");
INSERT INTO adj_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Ow sosiɛm agŋ bʼow ot im ↄny gbre ijr eci ɛtŋ -li bʼow -lʼibi ↄny. Ɛm sosiɛm ɛbr ɛbr a fɛŋ bʼow ifn ↄny. ");
INSERT INTO adj_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ɛtŋ ow e lɛgŋ ab ɛm a, agŋ nↄnↄ bʼow irmn ɛl ecʼↄmn; -li bʼow -lʼɛjurir ɛtŋ -li bʼow -lʼifanin ɛl ↄfr yɛji. ");
INSERT INTO adj_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ɛtŋ ɛmɛny kokoba ↄb ɛsɛl ayadŋu nↄnↄ bʼow ok ↄkm ɛtŋ bʼow irmn agŋ nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Low ŋuŋ kok bʼow ɛny eb es toŋ ke agŋ bɛb ecʼerur ekʼↄny a írm. ");
INSERT INTO adj_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Gbɛkↄ ɛgŋ eke bʼow inym es kikri toŋ ow e nuŋ ɛdŋ ɛm a, bʼow ɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Wɛl bʼow ↄb gbreŋgbi usu a ecʼAmani Mamn na wus na nimum af, yecʼɛtŋ ke ɛbr ɛbr a fɛŋ íj daŋku; ke sica ow él ow e nuŋ ɛdŋ gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","«Sica bʼow ɛkan ob yecʼa eke wɛl bʼɛsŋ “Musue ob iyr” eke kokoba ↄb ɛs Daniɛl dad ow ecʼodad a. Wɛl bʼow ɛwʼr usu lala a. (Ke ɛgŋ eke bʼow awl ów amua a, íri sɛnyn sɛnyn!) ");
INSERT INTO adj_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ke kpɛkŋ agŋ a eke bʼow anŋ Jude wus af a, ow akpl ke -lʼuru es -nʼim mafɛny ɛm; ");
INSERT INTO adj_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ɛgŋ eke bʼow anŋ in ecʼêl af e lɛf eb usu a, kʼúsm es ɛym akŋ ocm ob; ");
INSERT INTO adj_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ɛtŋ ɛgŋ eke bʼow anŋ ↄgm a, kʼɛ́wlm iim jam ocm in e mob af ɛw a ij. ");
INSERT INTO adj_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sɛgŋ amua bʼow ɛw tuↄtuↄ molok ab lisɛl lel ɛl ekʼam ↄŋ ey mɛny ab ab eci. ");
INSERT INTO adj_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ŋↄŋan Nyam yecʼɛtŋ ke es uru ikŋ na kʼɛ́ym nyam es us ɛm, oglog nɛnɛgŋ e lɛgŋ! ");
INSERT INTO adj_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Tasi ɛm a, ow e lɛgŋ ab ɛm, gbre ij a bʼow ɛw tuↄtuↄ afŋn es. Ow bʼow akm gbre ij fɛŋ eke wɛl ɛkn wus e nuŋ ↄb ɛm toŋ ke kʼit yɛfɛnyna ecʼa. Lɛgŋ kaka, gbre ij ikŋ na kʼow anm ij. ");
INSERT INTO adj_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ɛtŋ blel Nyam ɛgŋm isrm sɛgŋ amua ɛm, ke ɛgŋ kaka blel ↄtum anm owr. Lʼisr sɛgŋ amua ɛm agŋ a eke li sↄsum lʼot a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Eke batŋ ɛgŋ nyam bi dad ↄny ɛsɛ: “Ɛ̀kan, Mesi a anŋ aŋa!” oglog: “Nʼanŋ yogŋ a!” kʼùbr ɛgŋ a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Tasi ɛm a, mesiɛl ayadŋu lele kokoba ↄb ɛsɛl ayadŋu ab bʼow ok ↄkm. -Li bʼow -li kok mɛny ɛwr ɛgbɛl lele ów any iti owi ab agŋ ecʼirmn eci, ɛtŋ ekʼow it yɛji, -lʼↄtu -lʼirmn agŋ a eke Nyam sↄsum ot a. ");
INSERT INTO adj_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kin, ìrir! Mʼikŋ anym mʼɛwar ↄny. ");
INSERT INTO adj_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Eke batŋ wɛl bi dad ↄny ɛsɛ: “Ɛ̀kan, nʼanŋ loj yogŋ!” kʼìmn. Oglog ekʼɛgŋ bi dad ↄny ɛsɛ: “Ɛ̀kan, nʼam lↄl es aŋa!” kʼùbr ir nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ɛsɛ elel eke afr bʼɛŋn ke bʼayal yogŋ a eke ligbn bʼigb, toŋ ok yogŋ a eke ligbn bʼɛru es a, ɛbɛn eke ɛgŋ ecʼIy bʼow owr ana. ");
INSERT INTO adj_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Yogŋ eke sos megl ugŋn anŋ a, yogŋ anake sikaka bʼas luku a.» ");
INSERT INTO adj_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","«Kpɛkŋ eke sɛgŋ ab ɛm eci gbre ij owi a bʼoc es a, ligbn bʼow irm es ɛtŋ awl yɛji kʼow afŋm ij, mílɛ́l bʼow anŋ afr ok wus ɛtŋ afr ecʼabusu owi fɛŋ bʼow wuwal. ");
INSERT INTO adj_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ɛtŋ sica ɛgŋ ecʼIy e mɛny ɛwr a bʼow ɛy ↄkm afr; ɛtŋ wus na nimum ecʼɛbr ɛbr a fɛŋ bʼow ikŋ ↄŋn kok sↄrŋ, -li bʼow -lʼɛkn ɛgŋ ecʼIy eke bʼow anŋ afr e jru ɛm am ow abusu fɛŋ lel anygbɛl ab. ");
INSERT INTO adj_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Krↄkr gbɛl a bʼow ikŋ, ɛtŋ li bʼow nʼↄŋ in ecʼafr ɛrm ɛsɛl a im wus na eci ↄy yar ab ɛm as agŋ a eke li sↄsum lʼot a luku; ow bʼow ↄb nuŋ ogog nyam toŋ ogog yecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","«Kin low yɛgm ekʼel babm e likŋ a eci eke kʼirir: kpɛkŋ eke in ecʼál a bʼɛw wrↄwrↄ, ke nʼam gigŋ ↄdↄdↄ a, kpɛkŋ bʼuwr any eke mewij ow titm ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ɛbɛn nyam coco, eke bʼɛkan ów amua ow a, ke kpɛkŋ úwr any eke low a titm, ɛtŋ ow bʼow ɛy. ");
INSERT INTO adj_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Low nawrɛ mʼam dad ↄny: yɛfɛnyna ecʼagŋ a fɛŋ kʼow uwm uwrm ɛtŋ ów amua bʼow ɛy. ");
INSERT INTO adj_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Afr lele wus ab bʼow ɛc, gbɛkↄ lɛgŋ kaka ɛm e sodad a kʼow ɛcm.» ");
INSERT INTO adj_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","«Gbɛkↄ ów a e lɛgŋ lele wanci ab ab eke bʼow ɛy a, ɛgŋ kaka uwm any: afr ɛrm ɛsɛl yɛji uwm any, ɛgŋ ecʼIy bↄbↄ yɛji uwm any, ekʼow elm ɛm Ɛs sↄny coco cɛ. ");
INSERT INTO adj_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Low yecʼa ekʼɛy Noe e lɛgŋ ab ɛm a, lɛgŋ ekʼɛgŋ ecʼIy bʼow ow a, ow bʼow el ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Tasi ɛm a, ow e lɛgŋ a, gbuŋ ke mij gbɛl a ekʼan a eci lɛgŋ ów a, agŋ am ij ɛtŋ am ɛgŋ ɛsɛ sɛgŋ fɛŋ ecʼab af. -Nʼam ɛbi ↄyↄw, -nʼam ɛbir ɛl ecʼey ↄyↄw egŋ toŋ batŋ it lɛgŋ a eke Noe ɛy mijɛtŋ gbɛl ab ɛm a; ");
INSERT INTO adj_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","-lʼɛwm ow e low ɛrm toŋ ow it lɛgŋ a eke mij gbɛl a an ot ɛl fɛŋ ab im a. Lɛgŋ ekʼɛgŋ ecʼIy bʼow ow a, ɛbɛn ekʼow bʼow ɛcr ana. ");
INSERT INTO adj_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ow ɛm a, ekʼagŋ yony anŋ ↄgm, wɛl bʼow oc nyam ke wɛl ígŋ nyam ɛlu es. ");
INSERT INTO adj_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ekʼↄyↄw yony am bɛbm sos ob iny eci, wɛl bʼow oc nyam ke wɛl ígŋ nyam ɛlu es. ");
INSERT INTO adj_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ɔ̀sur, aŋke uwmn lɛgŋ a eke ↄny Ɛs Kↄtↄkↄ bʼow ow ab any. ");
INSERT INTO adj_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ìrir low na ow ók ↄny es sos ɛm sɛnyn sɛnyn: blel akŋ ɛs bʼuw ncok e wanci ekʼulu kʼow ab any ana, ke blel nʼánŋ any owr yecʼɛtŋ ke li kí yɛbm ow ɛpirm ɛymʼn akŋ. ");
INSERT INTO adj_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Na sosiɛm, ↄny yɛji, bɛ̀bmn sos, aŋke ɛgŋ ecʼIy bʼow ow wanci af eke kʼow ↄmnmn a.» ");
INSERT INTO adj_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","«Bwo ecʼɛgŋ el juma kok ɛs mamn lele nuŋ ɛm ↄny ɛs ab ee? Kin ɛgŋ nyam eke in ecʼes ɛw ɛs a ↄŋ abusu eke kʼɛkn juma kok ɛsɛl ɛjecʼa e lís e low, nʼↄ́ŋ wɛl ob ij wanci a ekʼow bʼit a. ");
INSERT INTO adj_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Ehe él juma kok ɛs ikŋ na eci, eke in ecʼes ɛw ɛs a e mɛny ɛwl ow ɛm, bʼow ɛŋan am kok juma a! ");
INSERT INTO adj_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Low nawrɛ mʼam dad ↄny: es ɛw ɛs a bʼow afl in ecʼob ↄny a fɛŋ es ɛlul il abu ɛm. ");
INSERT INTO adj_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Gbɛkↄ ekʼow el juma kok ɛs ŋuŋ, li bʼow li dad in ecʼɛrm ɛm lʼɛsɛ: “Ɛm ecʼes ɛw ɛs a kʼow owm caca.” ");
INSERT INTO adj_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ɛtŋ li bʼow lʼↄb nuŋ nʼam ↄr in e juma ɛm e lawlɛl a, nʼám ij ke nʼám ɛgŋ, mar ɛgŋ ɛsɛl ab ab. ");
INSERT INTO adj_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kↄ es ɛw ɛs a bʼow ɛwl ow lɛgŋ nyam eke li kʼow nʼↄmnm, wanci nyam af eke li kʼow lʼuwm any. ");
INSERT INTO adj_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Li bʼow lʼogŋ juma kok ɛs a ke nʼↄ́ŋ ow ɛnyɛmbri yony yony ɛsɛl eci gbre ij a; yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a.» ");
INSERT INTO adj_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","«Afr eci gbreŋgbi usu a anŋ ɛsɛ ededyↄw oto lɛw a e low ab af. -Lʼot ɛl e mun al a ɛtŋ -lʼok ↄkm -nʼaam -lʼↄbr mɛbi ɛs a. ");
INSERT INTO adj_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ɛl ɛm a, yen ɛ́wm low ɛrm ɛtŋ yen a gbɛ bʼɛw low ɛrm. ");
INSERT INTO adj_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ɛl a eke ɛ́wm low ɛrm a, ot ɛl e mun al a, kↄ -lʼocm mun kaka -lʼakŋam abu ab. ");
INSERT INTO adj_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ɛtŋ ɛl a eke bʼɛw low ɛrm a, ot ɛl e mun al a lele mun ekʼanŋ mun kpar ɛm ab im. ");
INSERT INTO adj_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Eke mɛbi ɛs a ecʼow a am ibn, ↄyↄw oto a fɛŋ mɛmn eb sos, ɛtŋ am ɛru mɛmn. ");
INSERT INTO adj_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Eke lɛgŋ usu a, lebl nyam ikŋ dad ninɛ: “Kin mɛbi ɛs a! Òkr ↄkm ↄbar ir!” ");
INSERT INTO adj_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ededyↄw oto lɛw a ufŋm es igb ɛtŋ am bɛbm ɛl e mun al a sos. ");
INSERT INTO adj_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Low ɛrm ɛ́wm lisɛl a am dad likpr a ɛsɛ: “Ɔ̀ŋn ɛy ↄny e mun a tɛl, kↄ ɛy e mun al a am irm es.” ");
INSERT INTO adj_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","-Li dad wɛl ninɛ: “Njaŋ, aŋke ow ɛnym eke ow bʼow ɛbm ɛy bake ow ɛbm ↄny. Ìmn ↄl ij usu a, ke ↄ́ↄl ↄny eci.” ");
INSERT INTO adj_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Low ɛrm ɛ́wm lisɛl a im am ↄl mun, ɛtŋ wanci ab af cɛ mɛbi ɛs a ow. Ededyↄw oto yen a eke bɛbm sos a ok es gbɛgbl usu a in ab ɛtŋ wɛl abl êl a safuɛ ɛm. ");
INSERT INTO adj_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Eke ow ibn tɛl a, ↄyↄw oto ɛjecʼa yɛji ow, ɛtŋ am ɛlu lebl dad ɛsɛ: “Ɛgŋ gbɛl, ɛgŋ gbɛl, fìg ɛy lisany!” ");
INSERT INTO adj_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Kↄ mɛbi ɛs a dad ninɛ: “Low nawrɛ mʼam dad ↄny: mʼuwm ↄny any.” » ");
INSERT INTO adj_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesu igŋ af dad ninɛ: «Ɔ̀sur aŋke uwmn lɛgŋ a lele wanci ab ab any.» ");
INSERT INTO adj_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","«Tasi ɛm a, Afr eci gbreŋgbi usu a anŋ ɛsɛ ɛgŋ nyam ekʼam ow im usu af. Lʼɛsŋ in eci juma kok ɛsɛl a ɛtŋ lʼabul wɛl in ecʼob ↄny a. ");
INSERT INTO adj_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Nʼↄŋ nyam sika ɛm os yen, yecʼa yony, ɛtŋ nyahan ɛm ecʼa nyam. Ɛgŋ ɛgŋ eci lɛc ogŋ eke bʼim ok a, ow ɛm li cɛc wɛl os a, ɛtŋ nʼim. ");
INSERT INTO adj_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Kpɛkŋ juma kok ɛs a ekʼɛŋn yen a oc im ↄↄl an ɛtŋ ɛŋn sika ɛm os ɛjeci yen. ");
INSERT INTO adj_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Yecʼa ekʼɛŋn yony a yɛji kok ɛbɛn, ɛtŋ ɛŋn sika ɛm os ɛjeci yony. ");
INSERT INTO adj_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Gbɛkↄ yecʼa ekʼɛŋn ekŋ nyam a im ur nↄmu lↄl in ɛgŋ gbɛliy ecʼos ab es ɛm. ");
INSERT INTO adj_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Eke ow kok sɛgŋ nↄnↄ a, juma kok ɛsɛl a ecʼes ɛw ɛs a ow, ɛtŋ wɛl ab nʼam ub ob. ");
INSERT INTO adj_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","In a eke ɛŋn sika ɛm os yen a, ɛri ow ɛtŋ ok ɛjeci yen ↄkm ɛtŋ dad ninɛ: “Es ɛw, ↄŋʼm sika ɛm os yen. Mʼɛŋn ekŋ ɛjeci yen: kin ow.” ");
INSERT INTO adj_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","In eci es ɛw ɛs a dadʼr ninɛ: “Ow akpl, ŋ juma kok ɛs mamn nɛny nyam ɛs. Ij nɛny nyam ów ekekey ɛm, mʼow mʼabulʼŋ ów ɛgbɛl. Òw kok sos ɛm iŋn ɛm ab.” ");
INSERT INTO adj_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Juma kok ɛs a eke ɛŋn sika ɛm os yony a yɛji ow dad ninɛ: “Es ɛw, ↄŋʼm sika ɛm os yony. Mʼɛŋn ɛjeci yony: kin ow.” ");
INSERT INTO adj_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","In ecʼes ɛw ɛs a dadʼr ninɛ: “Ow akpl, ŋ juma kok ɛs mamn nɛny nyam ɛs. Ij nɛny nyam ów ekekey ɛm, mʼow mʼabulʼŋ ów ɛgbɛl. Òw kok sos ɛm iŋn ɛm ab.” ");
INSERT INTO adj_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Sica juma kok ɛs a ekʼɛŋn sika ɛm os nyam a ɛri ow ɛtŋ dad ninɛ: “Es ɛw, mʼuw any eke ŋ ɛw tuↄtuↄ: yogŋ eke ewlm a, bʼↄw, yogŋ eke ɛlum egb nↄmu ɛm a yɛji bʼub. ");
INSERT INTO adj_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Erŋn ↄnyʼm ɛtŋ mʼoc ŋ ecʼos a mi lↄl es nↄmu ɛm: kin ow.” ");
INSERT INTO adj_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","In ecʼes ɛw ɛs a dadʼr ninɛ: “Ŋ juma kok ɛs ŋuŋ, ↄrŋu! Uw any eke mi bʼↄw egb yogŋ eke mʼewlm a, ɛtŋ mi bʼub egb yogŋ eke mʼɛlum egb nↄmu ɛm. ");
INSERT INTO adj_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Blel óc ɛm ecʼos a ɛw es ob es ɛw usu, ke ɛm eci mɛny ɛwl ow ɛm a, mʼóc ɛm ecʼob a lele ow eci mij ab ab. ");
INSERT INTO adj_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Èbr ir sika ɛm os nyam a abu ɛm, ke ócr ↄŋn ɛgŋ a ekʼↄny sika ɛm os lɛw a. ");
INSERT INTO adj_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Tasi ɛm a, ɛgŋ fɛŋ ekʼↄnym ob ab a, wɛl bʼow obnʼn ɛtŋ ow bʼow ufuʼr es, kↄ ɛgŋ ekʼↄnym ob kaka a, tɛl a eke nʼↄny a yɛji, wɛl bʼow ↄdu ebʼr abu ɛm. ");
INSERT INTO adj_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Juma kok ɛs keskes na ecʼa, ↄnyn ↄwal il gbeŋ ncebn ab ɛm, yogŋ anake ↄŋn ikŋ lele an ɛm sasagr ab bʼow anŋ a.” » ");
INSERT INTO adj_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","«Lɛgŋ ekʼɛgŋ ecʼIy bʼow ow in ecʼanygbɛl ab ɛm afr ɛrm ɛsɛl fɛŋ ab a, li bʼow li sigr in ecʼɛb ebu el e lɛkpn a. ");
INSERT INTO adj_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Wus na nimum eci ɛbr ɛbr a fɛŋ bʼow as luku in ecʼany af, ɛtŋ li bʼow lʼok agŋ a sakp yony ɛsɛ elel eke mɛbob ↄsu ɛs bʼok mɛcɛb ogog ke bʼok sican ogog ab af. ");
INSERT INTO adj_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Li bʼow lʼok mɛcɛb in e lidr ogog a, ke lʼók sican in e nɛmn ogog a. ");
INSERT INTO adj_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Ɛtŋ ɛb ebu a bʼow dad agŋ a ekʼanŋ in e lidr ogog a ɛsɛ: “Ɔny a eke ɛm Ɛs ɛdŋ ↄwrↄ a, òwr ke íjr gbreŋgbi usu a eke wɛl kok ɛw es wus e nuŋ ↄb ɛm ɛtŋ a ecʼaja. ");
INSERT INTO adj_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Tasi ɛm a, namn ↄnyʼm ɛtŋ ↄŋnʼm ob mʼij; mijamn ↄnyʼm ɛtŋ ↄŋnʼm mij mʼɛgŋ; mʼel utuɛgŋ ɛtŋ ebr ɛlulʼm akŋ; ");
INSERT INTO adj_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","mʼanŋ sos ↄfr ɛtŋ ɛwrʼm ob sos; mʼanŋ ↄl ɛm, ɛtŋ kokrʼm sos; mʼanŋ sobel ɛm, ɛtŋ owr ɛkanʼm.” ");
INSERT INTO adj_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Ɛtŋ agŋ a eke kok Nyam ecʼerur a bʼow ibrmʼn ɛsɛ: “Ɛs Kↄtↄkↄ, kↄ bogŋ e lɛgŋ sʼɛknʼŋ namn ab ɛtŋ sʼↄŋʼŋ ob ij, oglog mijamn ɛm ɛtŋ sʼↄŋʼŋ mij ɛgŋ ee? ");
INSERT INTO adj_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kↄ bogŋ e lɛgŋ sʼɛknʼŋ ɛsɛ utu af, ɛtŋ sʼeb sʼɛluʼŋ akŋ, oglog sos ↄfr ɛtŋ sʼɛwʼŋ ob sos ee? ");
INSERT INTO adj_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kↄ bogŋ e lɛgŋ sʼɛknʼŋ ↄl ɛm oglog sobel ɛm ɛtŋ sʼow sʼɛknʼŋ ee?” ");
INSERT INTO adj_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ɛb ebu a bʼow dad ɛl ɛsɛ: “Low nawrɛ mʼam dad ↄny: sakp sakp fɛŋ a eke kokr ów amua ↄŋn ɛm lisijimɛl ey amua ɛm e likekli nyam a, ke ɛm anake kokr ↄŋn a.” ");
INSERT INTO adj_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Ɛtŋ ɛb ebu a bʼow dad agŋ a ekʼanŋʼn nɛmn ogog a ɛsɛ: “Ɔny agŋ eke wɛl ofn, kpàbrʼm es lís imn kpekpe. Ìmn al a ekʼiram es ab ɛm, al a eke wɛl kok ɛw agn lele in ecʼɛrm ɛsɛl ab ab es a. ");
INSERT INTO adj_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Tasi ɛm a, namn ↄnyʼm ɛtŋ ↄↄmnʼm ob mʼijm; mijamn ↄnyʼm ɛtŋ ↄↄmnʼm mij mʼɛgŋm; ");
INSERT INTO adj_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","mʼel utuɛgŋ, ɛtŋ ebmnʼm; mʼanŋ sos ↄfr, ɛtŋ ɛwmnʼm ob sos; mʼanŋ ↄl ɛm, mʼanŋ sobel ɛm, ɛtŋ kokmn ɛm e lís e low kaka.” ");
INSERT INTO adj_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Ɛtŋ -li bʼow -lʼibrm ow -lʼɛsɛ: “Ɛs Kↄtↄkↄ, kↄ bogŋ e lɛgŋ sʼɛknʼŋ namn, mijamn, oglog utuɛgŋ, oglog sos ↄfr, oglog ↄl ɛm, oglog sobel ɛm, ɛtŋ sʼɛluamʼŋ abu ee?” ");
INSERT INTO adj_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ɛb ebu a bʼow dad ɛl ɛsɛ: “Low nawrɛ mʼam dad ↄny: sakp sakp fɛŋ eke kokmn ów amua ↄↄmn ɛm e jam ɛsɛl ey amua ɛm e nyam a, ke ɛm anake kokmn ↄↄmn a.” ");
INSERT INTO adj_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ɛtŋ -li bʼow -nʼim gbre ij ekʼↄnym uwr ab ɛm, ke agŋ a eke kok Nyam ecʼerur a ím sel ɛŋn ekʼↄnym uwr ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Eke Jesu dad ów ↄm eci sodad amua bake ow uwr a, li dad in e jam ɛsɛl a ninɛ: ");
INSERT INTO adj_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Uwr any eke ow anŋ sɛgŋ yony ke Pak ecʼes gbɛgbl a ów. Wɛl bʼow ↄl ɛgŋ ecʼIy ij yecʼɛtŋ ke wɛl ↄ́bʼr ecigbrↄ olikŋ af.» ");
INSERT INTO adj_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ke ɛbɛn a, egb waw ɛsɛl ɛgbɛl lele Jwifɛl ɛm ecʼagŋ ekpekp ab ab as luku egb waw ɛs ligbɛl Kayif e gbugŋ a; ");
INSERT INTO adj_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ɛl fɛŋ -lʼokr af -lʼɛgŋ -lʼeb eke ew ew ɛm -li kʼↄny Jesu ke -lʼibi ow. ");
INSERT INTO adj_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","-Nʼam dad -lʼɛsɛ: «Ow itm eke si kʼↄnyʼn es gbɛgbl na ɛm; ekʼow el ɛbɛn, bↄbar owi bʼow ɛy bieku ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesu im Betani baŋn, Simↄ a eke lɛgŋ anym ɛm kokobe ok a ecʼakŋ. ");
INSERT INTO adj_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Eke Jesu anŋ ob ij lↄfu lís a, yↄw nyam ow titmʼn. Nʼↄnym an gbɛl e mijey kↄk nyam eke wɛl kok lebn ɛm ab; lebn na, wɛl bʼɛsŋʼn albatr. Lʼɛwl mijey a fɛŋ lʼok Jesu nuŋ. ");
INSERT INTO adj_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Eke jam ɛsɛl a bʼɛkn ɛbɛn a, ow e low ebl ɛl ɛrm ɛtŋ -nʼam dad -lʼɛsɛ: «Kↄ bogŋ ecʼob ŋuŋn el na ee? ");
INSERT INTO adj_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Kↄ ow itm eke mijey ikŋ na, wɛl kʼↄl ij an tuↄtuↄ oc ow ecʼos a ↄŋ ↄgbↄru ee?» ");
INSERT INTO adj_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesu iri low na eke -nʼam dad a, ɛtŋ li dad wɛl ninɛ: «Kↄ bla ɛtŋ am ijar yↄw na gbre ee? Low na eke li kok ɛm e lís a el low mamn. ");
INSERT INTO adj_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Tasi ɛm a, ↄgbↄru ecʼa, -nʼanŋ ↄny ab sɛgŋ a fɛŋ; kↄ ɛm, mi kʼow mʼanm ↄny ab sɛgŋ a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Lʼokʼm mijey na sos yecʼɛtŋ ke ow bɛ́bm im sos uwↄmu ɛm eci. ");
INSERT INTO adj_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Low nawrɛ mʼam dad ↄny: wus na nimum af ecʼusu kaka fɛŋ eke wɛl bʼow ↄb Amani Mamn a eci kokoba a, wɛl bʼow ↄkn yↄw na e low, ke wɛl dád low a eke li kok a yɛji.» ");
INSERT INTO adj_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ nyam eke wɛl bʼɛsŋ Judas Iskariↄt, im ɛŋn egb waw ɛsɛl ɛgbɛl a ");
INSERT INTO adj_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ɛtŋ dad ɛl ninɛ: «Kↄ eke mʼↄny Jesu mʼↄŋ ↄny, ke bla bʼow ↄŋnʼm ee?» Agŋ a awl os likŋ lele lɛw ab ↄŋʼn. ");
INSERT INTO adj_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Wanci ab af cɛ, Judas am ↄl akunda sɛnyn yecʼɛm eke kʼↄny Jesu ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Futufutu ekʼejru ánm ɛm ecʼes gbɛgbl e lɛgŋ krɛkrɛ a, jam ɛsɛl a ow am ibrm Jesu ɛsɛ: «Kↄ bogŋ am erur eke si kʼim si bɛbm Pak eci ob ij a eci sos ee?» ");
INSERT INTO adj_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesu dad ɛl ninɛ: «Ìmn ɛb ab ɛm, ɛy ecʼɛgŋ a ogŋ ke dádr ir ɛsrɛ: “Low yɛgm agŋ ɛs ninɛ in eci wanci a in bɛbmn ab; ŋ ogŋ a anake in eci jam ɛsɛl ab ab, ɛl bʼow ɛl kok Pak a.” » ");
INSERT INTO adj_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jam ɛsɛl a kok yecʼa eke Jesu dad ɛl a, ɛtŋ -li bɛbm Pak ecʼob ij a eci sos. ");
INSERT INTO adj_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Eke lɛgŋ ew es a, Jesu lele in e jam ɛsɛl lɛw yony ab ab sig es ob ij lↄfu lís. ");
INSERT INTO adj_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Eke -nʼam ij ob a, Jesu dad ninɛ: «Low nawrɛ mʼam dad ↄny: ↄny ɛm ecʼɛgŋ nyam bʼow ↄl ijʼm.» ");
INSERT INTO adj_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jam ɛsɛl a sos ↄw es afŋn es, ɛtŋ ɛgŋ ɛgŋ am ibrmʼn ɛsɛ: «Ɛgŋ gbɛl, kↄ ow ↄtu eke kʼel ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesu dad ɛl ninɛ: «Ɛgŋ a eke ɛm ab us abu lↄfu nyam ɛm a, in anake li bʼow lʼↄl lʼijʼm a. ");
INSERT INTO adj_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ɛgŋ ecʼIy bʼow uw ɛsɛ elel eke Nyam Lɛl ɛwar in e lís ab af; gbɛkↄ gbre él ɛgŋ a ekʼam ↄl ijʼr a eci! Ɛgŋ ikŋ na, blel wɛl ewmʼn bↄbↄ yɛji!» ");
INSERT INTO adj_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Judas a ekʼam ↄl ijʼr a am ibrmʼn ɛsɛ: «Low yɛgm agŋ ɛs, kↄ ow ↄtu eke kʼel ɛm ee?» Jesu dadʼr ninɛ: «Ŋ obi dad.» ");
INSERT INTO adj_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Eke -nʼam ij ob a, Jesu oc futufutu, lʼɛlu Nyam bia, lʼubr ɛm nʼↄŋ in e jam ɛsɛl a, ɛtŋ li dad ninɛ: «Èbr ke íjr, na el ɛm e sos megl.» ");
INSERT INTO adj_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ɛmɛny lʼoc mij kpↄk eke mar anŋ ɛm; eke lʼɛlu Nyam bia a, nʼↄŋ in e jam ɛsɛl a, ɛtŋ li dad ninɛ: «Ɛ̀gŋn ↄny fɛŋ, ");
INSERT INTO adj_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","aŋke na el ɛm e mebl, Nyam e sinm a e mebl ekʼam ow ok es agŋ nↄnↄ e sikpl oc ap eci. ");
INSERT INTO adj_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mʼam dad ↄny ekʼigŋ yɛfɛnyna a, mi kʼow mʼɛgŋm mar na sakp ɛjeci toŋ ke ow ít lɛgŋ a eke ↄny ab, ɛm Ɛs e gbreŋgbi usu a, mʼow mʼɛgŋ mar owr a.» ");
INSERT INTO adj_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Sica -lʼɛgŋ es gbɛgbl a ecʼɛj ba ow bʼuwr, ɛtŋ -nʼim Olivie lafɛny af. ");
INSERT INTO adj_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Sica Jesu dad in e jam ɛsɛl a ninɛ: «Ncok na cɛ, low a eke bʼow ɛŋnʼm a bʼow ok ↄny ecʼↄmn a wus. Tasi ɛm a, Nyam Lɛl ab ɛm wɛl nↄn: Mʼow mʼibi mɛcɛb ↄsu ɛs a, ɛtŋ mɛcɛb a fɛŋ bʼow ↄmu es. ");
INSERT INTO adj_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Gbɛkↄ ɛm eci uwↄmu ɛm anŋ igb ɛm a, mʼow mʼikŋ anym mʼim Galile mʼeku ↄny.» ");
INSERT INTO adj_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piɛr dad ninɛ: «Eke agŋ a fɛŋ igŋ ɛluʼŋ es yɛji, ɛm gbɛ lɛgŋ kaka mi kʼow mʼigŋm mʼɛlumʼŋ es.» ");
INSERT INTO adj_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesu dadʼr ninɛ: «Low nawrɛ mʼam dadʼŋ: ncok na cɛ, gbuŋ ke ŋgↄs íkŋ a, bʼow ɛgbrʼm sakp nyahan dad eke uwm im any.» ");
INSERT INTO adj_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piɛr dadʼr ninɛ: «Eke ow it ŋ ab eci luw bↄbↄ yɛji, mi kʼow mi dadm mʼɛsmɛ mʼuwmʼŋ any.» Ɛtŋ jam ɛsɛl ɛjecʼa yɛji dad ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ɛtŋ sica Jesu lele in e jam ɛsɛl ab ab ow ok usu nyam eke wɛl bʼɛsŋ Jɛsemane, ɛtŋ nʼam dad wɛl lʼɛsɛ: «Eke mʼaam yogŋ a mi ŋↄŋn Nyam a, òkr es aŋa.» ");
INSERT INTO adj_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Lʼoc Piɛr lele Sebede ecʼey yony ab ab lʼigŋ sos af nʼim. Sos ↄb nuŋ am ↄwʼr es, ɛtŋ ɛrmij yɛji am okʼr afŋn es. ");
INSERT INTO adj_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Li dad wɛl ninɛ: «Sos es ↄw ekʼel luw eci afŋn ɛm ecʼabŋ ab es; òkr es aŋa ke ↄ́sur ɛm ab.» ");
INSERT INTO adj_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Lʼɛri nʼim kpekpe tɛl, lʼok ↄwrↄkp wus lʼubu any es ɛtŋ nʼam ŋↄŋn Nyam li dad sodad amua: «Ɛm Ɛs, ekʼow it tasi, ke ↄny gbre eci mij kpↄk na kpabʼm es lís. Ke fɛŋ ɛm a, ow kʼél yecʼa eke mʼam erur a, kↄ yecʼa eke ŋ am erur a.» ");
INSERT INTO adj_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jesu ɛwl ow jam ɛsɛl nyahan a ogŋ a, ɛtŋ nʼɛŋan wɛl eke wɛl am ɛru mɛmn. Li dad Piɛr ninɛ: «Kↄ wanci nyam bↄbↄ yɛji, ↄtumn ↄsumn ɛm ab ee? ");
INSERT INTO adj_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ànŋn any owr ↄsur ke ŋↄ́ŋan, yecʼɛtŋ ke kʼɛ́ymn ɛbm ɛkn owi ɛm. Ɔny ecʼabŋ a gbɛ inym es low fɛŋ e kok eci, kↄ ↄny e sos megl a gbɛ ijm lɛc.» ");
INSERT INTO adj_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nʼim akpoj sakp yony ɛm ɛtŋ nʼam ŋↄŋn Nyam li dad sodad amua: «Ɛm Ɛs, eke mij kpↄk na kʼow ocm im es lís eke mi kʼɛgŋm ow e mij a, ke kòk ŋ ecʼerur a!» ");
INSERT INTO adj_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Eke ɛmɛny lʼɛwl mɛny lʼow in e jam ɛsɛl a ogŋ a, nʼɛŋan wɛl mɛmn ɛru ɛm; mɛmn am bↄbm ɛl anyamn. ");
INSERT INTO adj_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ɛmɛny Jesu ɛlu ɛl es im akpoj ɛtŋ am ŋↄŋn Nyam sakp nyahan ɛm. Nʼam ebr sodad nyam coco ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ɛmɛny lʼɛwl lʼow jam ɛsɛl a ogŋ a ɛtŋ nʼam dad wɛl lʼɛsɛ: «Aŋ! Am ɛrur mɛmn a cɛ ebr sel ee? Kin, wanci a eke wɛl bʼow ↄl ɛgŋ ecʼIy ij sikpl ɛsɛl ecʼabu ɛm a ow ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ìgbr sʼímn! Kin, ɛgŋ a eke am ↄl ijʼm a ow titm ŋ̂!» ");
INSERT INTO adj_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesu odad anŋ nɛnym kʼuwrm ɛtŋ kpɛkŋ Judas, jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ nyam a, ilm any. Agŋ nↄnↄ a ekʼow in ab a ↄnym ekŋ ekpr lele mab ler ɛm ab. Egb waw ɛsɛl ɛgbɛl lele Jwifɛl ecʼagŋ ekpekp ab ab anake ɛrm ɛl a. ");
INSERT INTO adj_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas eke bʼow ↄl Jesu ij a, ikŋ anym yɛgm dedeku a in ecʼakunda yecʼɛm eke -li kʼↄnyn ow a. Li dad ninɛ: «Ɛgŋ a eke mʼow mi joj nɛny a, in ana; ↄnyn in.» ");
INSERT INTO adj_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ɛtŋ kpɛkŋ Judas ow titm Jesu ɛtŋ dadʼr ninɛ: «Low yɛgm agŋ ɛs, mʼam ɛsŋnʼŋ!» Ɛtŋ li joj ow nɛny. ");
INSERT INTO adj_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesu dadʼr ninɛ: «Ɛm lawl, low yecʼa ekʼow eke ki kok a, kòk fafa.» Kpɛkŋ agŋ a okʼr af ↄnyʼn. ");
INSERT INTO adj_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Agŋ a ekʼanŋ Jesu ab a e nyam ↄdu in e lab ler ɛm a eb. Lʼiyr egb waw ɛs ligbɛl a ecʼabu ɛlum ɛs a ɛtŋ lʼubr ow lↄru es. ");
INSERT INTO adj_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesu dadʼr ninɛ: «Òc ŋ e lab ler ɛm a ɛw ow eci usu a, aŋke agŋ a eke bʼoc lab ler ɛm a, -li bʼow -lʼuw lab ler ɛm ɛm. ");
INSERT INTO adj_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Kↄ uwm any eke mʼↄtu eke mi kʼibrm ɛm Ɛs abu ɛlum, ke kpɛkŋ lʼísʼm afr ɛrm ɛsɛl áru eb lɛw yony ee? ");
INSERT INTO adj_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ke low na eke kok ab ɛm, ayaf Nyam Lɛl a ↄtu eke kʼiy nɛny ee? Nyam Lɛl a dad eke ów a kʼɛcr ɛbɛn.» ");
INSERT INTO adj_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ɛtŋ Jesu am dad dedeku a ɛsɛ: «Kↄ ɛm eci ↄny a ibrm eke kʼotr ekŋ ekpr lele mab ler ɛm ab owr ɛsɛ low ŋuŋ kok ɛs ɛm el af ee? Sɛgŋ a fɛŋ mi bi sig es Nyamel gbɛl a e gbugŋ mi yɛgm agŋ low ɛtŋ ↄnymnʼm. ");
INSERT INTO adj_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Kↄ ów amua ɛy yecʼɛtŋ ke kokoba ↄb ɛsɛl ecʼodad a ekʼanŋ Nyam Lɛl ɛm a íy nɛny.» Ɛtŋ jam ɛsɛl a fɛŋ igŋ ɛluʼl es uru es im. ");
INSERT INTO adj_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Agŋ a ekʼↄny Jesu a, -lʼoc -nʼim ow egb waw ɛs ligbɛl Kayif ecʼany af, yogŋ a eke ol e low any uw ɛsɛl lele agŋ ekpekp ab ab as luku a. ");
INSERT INTO adj_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Piɛr anŋ akpoj ɛm am us Jesu jam toŋ lʼok egb waw ɛs ligbɛl a e gbugŋ a. Lʼɛy gbugŋ a li sig es usu ↄsu ɛsɛl ab ab yecʼɛtŋ ke lʼɛ́kn elel eke low a bʼow ɛcr a. ");
INSERT INTO adj_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Egb waw ɛsɛl ɛgbɛl a lele Sanedrɛn a ecʼagŋ ɛjecʼa fɛŋ ab am ↄl daŋku ij nyam, eke kʼↄbr Jesu low, ekʼow el yadŋ ɛm yɛji, yecʼɛtŋ ke -lʼibi ow, ");
INSERT INTO adj_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","kↄ -nʼɛŋnmn low kaka. Ke agŋ nↄnↄ ow cicrʼr yadŋ ɛm cɛ. Sica ow ecʼuwr ɛm a, agŋ yony ow ");
INSERT INTO adj_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ɛtŋ am dad ɛsɛ: «Ɛgŋ na dad nɛny ij ɛm ninɛ: “Mʼↄtu eke mi kʼↄny Nyamel gbɛl a mi ŋuŋn, ke sɛgŋ nyahan mʼúsr ɛm.” » ");
INSERT INTO adj_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Egb waw ɛs ligbɛl a igb ɛtŋ dad Jesu ninɛ: «Kↄ wɛl ám dad sodad amua okʼŋ af, ke kʼↄ́bm kpu ee?» ");
INSERT INTO adj_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Kↄ Jesu yewal tiŋ. Ɛtŋ egb waw ɛs ligbɛl a dadʼr ninɛ: «Nyam ekʼanŋ owr e nin ɛm, mʼam ibrmʼŋ, dàd ɛy ofn ɛm tasi ekʼow el ŋ el Mesi, Nyam ecʼIy a.» ");
INSERT INTO adj_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesu dadʼr ninɛ: «Ŋ obi dad. Ɛmɛny mʼam dad ↄny: jam aŋa bʼow ɛkan ɛgŋ ecʼIy eke sig es Nyam Abusu Ɛs eci lidr abu af, ke bʼow anŋ afr eci jru ɛm ám ow.» ");
INSERT INTO adj_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Odad na sosiɛm egb waw ɛs ligbɛl a ↄny in eci simob sus ɛm a gbagbrm ɛm, ɛtŋ dad ninɛ: «Lʼↄbr Nyam any! Ɛy sʼibram adaŋku ij! Ɔny yɛji caca irir eke li dad low ↄbr any owi Nyam e lís a. ");
INSERT INTO adj_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Kↄ ↄny e tutr el bogŋ ecʼee?» -Li dad ninɛ: «Ow ɛyʼr af, lʼit eke wɛl kʼibiʼr gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ɛtŋ sica -nʼam afl ow sar any -lʼↄr ow kukuta ɛm; bɛb gbɛ am dɛdŋʼn any af, ");
INSERT INTO adj_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ɛtŋ am dad ɛsɛ: «Ŋ ekʼel Mesi a, ɛ̀lu es ɛkn ↄkm ke dád ɛy ɛgŋ a ekʼiyrʼŋ ob a!» ");
INSERT INTO adj_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piɛr sig es gbugŋ yogŋ. Ob oc ↄŋ lisɛl ab ɛm e nyam ow titmʼn ɛtŋ dadʼr ninɛ: «Ŋ yɛji, anŋ Jesu Galile iyli na ab!» ");
INSERT INTO adj_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Kↄ lʼɛgbr ow dedeku a fɛŋ ecʼany af ninɛ: «Low yecʼa ekʼam ↄl eke ki dad a, mi kʼuwm any.» ");
INSERT INTO adj_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Lʼigb nʼaamn gbugŋ a e lisany a eci, ɛtŋ ob oc ↄŋ lis ɛjeci nyam ɛknʼn ɛtŋ am dad ok agŋ a ekʼanŋ yogŋ a ɛsɛ: «Ɛgŋ na yɛji, nʼanŋ Nasarɛt iyli Jesu ab.» ");
INSERT INTO adj_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ɛtŋ ɛmɛny Piɛr ɛgbrʼr dad ofn ɛm ninɛ: «Ɛgŋ ikŋ na, mʼuwmʼn any.» ");
INSERT INTO adj_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ow bʼinŋn ebr tɛl a, agŋ a ekʼanŋ yogŋ a ow titm Piɛr ɛtŋ am dadʼr ɛsɛ: «Tasi, ŋ, ɛl ɛm ecʼɛgŋ nyam. Ŋ ecʼodad a am otʼŋ suw es af yɛgm yogŋ ekʼanŋ ow a.» ");
INSERT INTO adj_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Piɛr ↄdu eb dad ninɛ: «Ekʼow el yadŋ mʼam ↄny, ke Nyam kókʼm low ŋuŋ! Mʼam ofn mi dad ekʼɛgŋ na mʼuwmʼn any!» Odad na anŋʼn nɛnym nʼam dad, ɛtŋ kpɛkŋ ŋgↄs ikŋ. ");
INSERT INTO adj_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ow ↄŋ Piɛr ↄkn odad a eke Jesu dadʼr a: «Gbuŋ ke ŋgↄs íkŋ a, bʼow dad sakp nyahan eke uwmʼm any.» Ɛtŋ Piɛr ɛy ↄkm im gbeŋ am ikŋ low dudu eci ↄŋn. ");
INSERT INTO adj_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Eke lɛgŋ ɛny a, ibribr fafa, egb waw ɛsɛl ɛgbɛl a fɛŋ lele Jwifɛl ecʼagŋ ekpekp ab ab okr af ɛgŋ eb eke kʼibi Jesu. ");
INSERT INTO adj_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","-Nʼↄŋ wɛl ↄny awŋʼn, -lʼoc -nʼim -nʼↄŋ ow Pilat, Rom iy ekʼel Jude ecʼes ɛw ɛs. ");
INSERT INTO adj_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Judas a eke ↄl Jesu ij a, iri eke wɛl ↄb Jesu low. Ow e low ɛyʼr sos ɛm, ɛtŋ lʼɛwlm os likŋ lele lɛw ab ab a mɛny nʼim nʼↄŋ egb waw ɛsɛl ɛgbɛl a lele agŋ ekpekp ab ab. ");
INSERT INTO adj_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Li dad wɛl ninɛ: «Mʼɛy lↄbr, mʼↄl ɛgŋ ekʼɛknm low a mʼij luw eci!» Kↄ -li dad ow ninɛ: «Na ŋ e low ana, ɛy e low kaka anm ɛm!» ");
INSERT INTO adj_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ɛtŋ Judas, ↄkm ɛy ɛm a, oc os a im ↄwl Nyamel gbɛl ab ɛm. Ɛtŋ nʼim lʼoc meb lʼɛdŋn ɛmn. ");
INSERT INTO adj_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Egb waw ɛsɛl ɛgbɛl a ot os a ɛtŋ dad ninɛ: «Ɛy ecʼol a ɛdŋn eke wɛl kʼoc os ikŋ na wuwlm Nyamel gbɛl a ecʼos ab ab, aŋke ow el mebl ecʼos.» ");
INSERT INTO adj_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Eke sica nɛny okr ɛl af a, -lʼoc os a -lʼↄl mijel kok ɛs a ecʼↄgm eke -li ki kok etu agŋ ecʼes oc usu. ");
INSERT INTO adj_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Na sosiɛm anake wɛl ɛsŋ ↄgm a “mebl ecʼↄgm” toŋ kʼow it yɛfɛnyna a. ");
INSERT INTO adj_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ow ↄŋ kokoba ↄb ɛs Jeremi eci sodad amua eke dad a iy nɛny: -Lʼot os likŋ lele lɛw ab a, (an eke Israɛl eyŋ ɛw ana,) ");
INSERT INTO adj_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","-lʼↄↄl mijel kok ɛs a ecʼↄgm a, ɛsɛ elel eke Ɛs Kↄtↄkↄ dadrʼm ab af. ");
INSERT INTO adj_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jesu anŋ es ɛw ɛs Pilat ecʼany af ɛtŋ ow am ibrmʼn ɛsɛ: «Kↄ ŋ Jwifɛl ecʼɛb ebu ab ana ee?» Jesu dadʼr ninɛ: «Ŋ obi dad.» ");
INSERT INTO adj_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ɛtŋ ɛmɛny eke egb waw ɛsɛl ɛgbɛl lele agŋ ekpekp ab ab am cicrʼr a, li dadm odad kaka. ");
INSERT INTO adj_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ɛtŋ Pilat dadʼr ninɛ: «Kↄ ów amua eke -nʼam dad -lʼokʼŋ af a, am iri ee?» ");
INSERT INTO adj_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Kↄ Jesu ↄbm kpu low kaka af toŋ es ɛw ɛs a low iti any afŋn es. ");
INSERT INTO adj_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sakp sakp fɛŋ eke Pak ecʼes gbɛgbl e lɛgŋ bʼow a, es ɛw ɛs a bʼɛlu sobel ɛm ɛs nyam es, in a eke dedeku a bʼerur a. ");
INSERT INTO adj_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ke lɛgŋ ab ɛm, ɛb any ↄbr ɛs ligbɛl nyam eke wɛl bʼɛsŋ Barabas anŋ sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Pilat am ibrm dedeku a ekʼas luku a ɛsɛ: «Kↄ bwo ecʼɛgŋ am erurir eke mi kʼɛlu es mʼↄŋ ↄny ee? Barabas kↄ Jesu a eke wɛl bʼɛsŋ Krist ab ee?» ");
INSERT INTO adj_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Tasi ɛm a, lʼuw any sɛnyn sɛnyn eke nyamn ɛyr ɛm wɛl oc Jesu isʼr. ");
INSERT INTO adj_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Eke Pilat sig es jɛj ok usu a, in e yↄw a ↄŋ wɛl isʼr amani na: «Kʼɛ̀y ɛgŋ na eke ɛknm low kaka a e low na ɛm, aŋke tasi ɛm a, ncok na, mɛmn ɛm mʼij gbre nↄnↄ in sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Kpɛkŋ egb waw ɛsɛl ɛgbɛl a lele agŋ ekpekp ab ab am itr dedeku a eke kʼibrm Barabas ecʼes ɛlu lele Jesu ecʼibi ab e low. ");
INSERT INTO adj_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Es ɛw ɛs a ɛmɛny ↄdu odad eb ɛtŋ am ibrm ɛl ɛsɛ: «Agŋ yony a, bogŋ eci am erurir eke mi kʼɛlu es mʼↄŋ ↄny ee?» -Li dad ow ninɛ: «Barabas!» ");
INSERT INTO adj_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilat ibrm ɛl ninɛ: «Ke sica Jesu a eke wɛl bʼɛsŋ Krist a ecʼa, ayaf mi ki kokrʼr ab ee?» Ɛl fɛŋ -lʼokr lebl af -li dad ninɛ: «Ɛ̀wʼr olikŋ af!» ");
INSERT INTO adj_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilat ibrm ɛl ninɛ: «Kↄ bla low ↄbr iy li kok ee?» Kↄ -nʼam ↄg lebl tuↄtuↄ ɛm -lʼɛsɛ: «Ɛ̀wʼr olikŋ af cɛ!» ");
INSERT INTO adj_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Eke sica Pilat ɛkn ekʼow akplm ij, ke ɛmɛny itarir a lele sↄg ab ab am bobn a, lʼoc mij li yↄg sabu dedeku a ecʼany af ɛtŋ li dad ninɛ: «Na ↄny e low ana! Mʼanm ɛgŋ na e luw owi ɛm!» ");
INSERT INTO adj_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Dedeku a fɛŋ ↄdu eb dad ninɛ: «Ke in e luw a e ligbↄw ánŋ ɛy lele ɛy ecʼalaw ab ab e nuŋ af!» ");
INSERT INTO adj_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Pilat ɛlu Barabas es ɛtŋ nʼↄŋ wɛl ↄr Jesu say ɛm gbuŋ ɛtŋ lʼɛlu abusu es eke wɛl kʼoc im ɛw ow olikŋ af. ");
INSERT INTO adj_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Pilat eci srↄda eyŋ a ↄny Jesu ɛlu lakp lokm a ekʼel Pilat e gbugŋ a, ɛtŋ ɛl a fɛŋ -lʼiwr -li did -lʼɛlul ow ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Wɛl ↄny in e mob a otʼr es sos ɛtŋ wɛl susʼr mob af ɛw ebl. ");
INSERT INTO adj_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","-Li kok mirŋ ɛm tufɛ, -lʼoc -lʼus ow ɛtŋ -lʼɛlu ow anany in e lidr abu ab ɛm. -Lʼok ↄwrↄkp wus ow ecʼany af ɛtŋ -nʼam kokr ow miyɛr -li dad -lʼɛsɛ: «Sʼam ɛsŋnʼŋ o, Jwifɛl ecʼɛb ebu!» ");
INSERT INTO adj_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","-Nʼam fafl ow sar any ɛtŋ -lʼoc anany a -nʼam nɛnŋn ow nuŋ. ");
INSERT INTO adj_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Eke -li kokar ow miyɛr sɛnyn sɛnyn bake ow uwr a, -nʼↄny mob af ɛw a -lʼoc ow es, -lʼɛwl -li sus ow ow e mob a ɛtŋ -lʼoc -nʼim ow eke -li kʼɛw ow olikŋ af. ");
INSERT INTO adj_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Eke -nʼanŋn baŋn a -nʼam ok ↄkm a, -lʼↄbr Sirɛn iy nyam eke wɛl bʼɛsŋ Simↄ; srↄda eyŋ a ↄnyʼn lɛc ɛm eke li kʼabu Jesu ecʼolikŋ a. ");
INSERT INTO adj_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","-Nʼim -lʼok usu nyam eke wɛl bʼɛsŋ Gↄlgota ekʼel nyandrɛ ɛm “Nuŋ kpↄk ecʼusu.” ");
INSERT INTO adj_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Yogŋ, -nʼↄŋ Jesu mar eke wɛl wuwlm ob lolo ab eke kʼɛgŋ; eke li tat anm a, lʼerurm eke li kʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","-Lʼɛw ow olikŋ af ɛtŋ -li cɛc ow eci mob sus ɛm a sↄsum oc kok ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ɛtŋ -lʼok es yogŋ -nʼam ↄsu ow. ");
INSERT INTO adj_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","In e nuŋ af a, -ni nↄn lɛl ekʼam yɛgm low a sosiɛm eke wɛl ↄbʼr low a. Ow eke wɛl nↄn a el: “Ɛgŋ na Jesu, Jwifɛl ecʼɛb ebu.” ");
INSERT INTO adj_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","In e saw saw a, wɛl ok elu yony olikŋ af; nyam anŋʼn lidr abu af ɛtŋ nyam anŋʼn nɛmn abu af. ");
INSERT INTO adj_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Agŋ ekʼam ɛc a am ɛgŋn nuŋ ɛm wɛwrʼr, ");
INSERT INTO adj_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ɛtŋ am dadʼr ɛsɛ: «Ŋ ekʼam erur eke kʼufŋ Nyamel gbɛl ab es ke sɛgŋ nyahan kpɛŋ ús ɛjecʼa, eke el Nyam ecʼIy tasi, èbr ŋ sosi, ànŋ olikŋ af yogŋ us es!» ");
INSERT INTO adj_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ɛtŋ egb waw ɛsɛl ɛgbɛl a, ol e low yɛgm ɛsɛl a lele agŋ ekpekp ab ab yɛji am kokrʼr miyɛr dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","«Lʼeb agŋ ɛjeci lʼɛlu es, ɛtŋ lʼↄtum eke li kʼebʼr in sosi! Kↄ Israɛl ecʼɛb ebu tasi ee? Sica nʼánŋ olikŋ af yogŋ lʼus es, ke sʼúbʼr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Lʼoc in ecʼↄmn a lʼɛlu Nyam ɛm li dad ninɛ: “Mʼel Nyam ecʼIy.” Ɛɛ! Eke Nyam ↄny in ecʼerur tasi, ke lʼéb lʼɛlu ow es gↄŋ!» ");
INSERT INTO adj_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ɛtŋ ów eŋuŋ kok ɛsɛl eke wɛl ɛw olikŋ af in ab a yɛji am wɛwrʼr dad ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Sica lɛgŋ uyu nuŋ ɛm a, ncebn ɛy wus a nimum af toŋ ok ncebles eci wanci nyahan ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ekʼow am titm ncebles eci wanci nyahan a, Jesu barm lebl tuↄtuↄ ɛm ninɛ: «Eli, Eli, lema sabaktani?» (ekʼel nyandrɛ ɛm: “Ɛm e Nyam, ɛm e Nyam, kↄ bla ɛtŋ digŋ ɛluʼm es ee?”) ");
INSERT INTO adj_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Agŋ nyam nyam ekʼanŋ yogŋ a iri odad na ɛtŋ dad ninɛ: «Nʼam ɛsŋ Eli!» ");
INSERT INTO adj_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Kpɛkŋ ɛl ɛm ecʼɛgŋ nyam uru es im oc mbra usm ɛl eci mar ab ɛm ɛtŋ oc ucur anany ↄkŋ Jesu eke kʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Gbɛkↄ agŋ ɛjecʼa am dad ɛsɛ: «Èku yɛ, si bʼow sʼɛkn eke Eli bʼow eb ɛluʼl es!» ");
INSERT INTO adj_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ɛmɛny Jesu barm lebl ligbɛl nyam ɛtŋ ok sel es. ");
INSERT INTO adj_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Kpɛkŋ, Nyamel ab ɛm eci gbad gbɛl gbada a eke wɛl ɛw ɛdŋn usu lala ab any a, igŋ afr ɛm a ɛtŋ agbr ɛm araŋn didi toŋ ok esr ɛm a. Wus umu, mób gbagbrm ɛm, ");
INSERT INTO adj_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","53","suwↄmu fifig. Eke Jesu igb luw ɛm a, ↄmn ɛsɛl nↄnↄ a ekʼuw a igb luw ɛm; -nʼanŋ suwↄmu ab ɛm -lʼok ↄkm. -Lʼok Jerusalɛm, ɛb lala ab ɛm; yogŋ agŋ nↄnↄ ɛkn ɛl. ");
INSERT INTO adj_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Eke srↄda eyŋ a eci anym ɛs a lele srↄda eyŋ ab ab ekʼam ↄsu Jesu a ɛkn wus umu a lele ów a ekʼam ɛy ow ab ab a, erŋn ↄny ɛl afŋn es. -Nʼam dad -lʼɛsɛ: «Njɛ, tasi ɛgŋ na Nyam ecʼIy!» ");
INSERT INTO adj_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Ɔyↄw nↄnↄ ekʼus Jesu jam Galile ɛtŋ eke ki kok in e lís e low a anŋ yogŋ am ɛkn low a akpoj ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ɛl ɛm a, Mari, Magdala baŋn yↄwi a, Mari Jak lele Josɛf ab e lis a, lele Sebede ecʼey a ecʼɛl lis ab yɛji anŋ. ");
INSERT INTO adj_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","58","Eke lɛgŋ ew es a, Arimate baŋn eci gbreŋgbi nyam, eke wɛl bʼɛsŋ Josɛf, ke in yɛji el Jesu eci jam us ɛs a im ɛŋn Pilat ɛtŋ ibrm ekʼow kʼoc Jesu eci sos megl a ↄŋʼn; ɛtŋ Pilat ↄŋ abusu. ");
INSERT INTO adj_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Josɛf oc sos megl a wiwrm gbad ufu owr ab ");
INSERT INTO adj_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ɛtŋ lʼoc nʼim lʼoc ow es in obi eci uwↄmu lob owr eke nʼↄŋ wɛl ur ab ɛm. Li wuwl lob nyam lʼabl uwↄmu a ecʼɛm ɛy usu ab es ɛtŋ nʼim. ");
INSERT INTO adj_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Magdala yↄwi a lele Mari yecʼab ab anŋ yogŋ, -lʼok es -lʼↄbr uwↄmu ab any. ");
INSERT INTO adj_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nɛnɛgŋ e sos bɛbm e lɛgŋ ɛc; sica lɛgŋ bɛny a, egb waw ɛsɛl ɛgbɛl a lele Farisiɛl ab ab okr af im Pilat ogŋ a ");
INSERT INTO adj_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, low nyam ow ɛy nuŋ ɛm: yadŋu na, in ecʼowr anŋ ɛm a, li dad eke, ekʼin uw ba owʼn bi kok sɛgŋ nyahan a, in bʼow in igb luw ɛm. ");
INSERT INTO adj_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Ɛ̀gŋ ↄŋ abusu ke wɛl ↄ́su uwↄmu a toŋ ow kok sɛgŋ nyahan, yecʼɛtŋ ke in e jam ɛsɛl a kʼíym sos megl a bake -li dadmn dedeku a eke lʼigb luw ɛm. Sica eci, yadŋ ikŋ na bʼow agb akm krɛkrɛ ecʼa.» ");
INSERT INTO adj_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat dad ɛl ninɛ: «Ɔnyn usu ↄsu ɛsɛl. Ìmn ke ↄ́ŋn ɛl -lʼↄsu uwↄmu a ɛsɛ elel eke am erurir ab af.» ");
INSERT INTO adj_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","-Nʼim -nʼam bɛbm uwↄmu a ecʼelel eke wɛl kʼↄsur a. -Lʼↄkr lob a ekʼanŋ uwↄmu nɛny a wɛl kↄkr saw saw ab es sɛnyn sɛnyn ɛtŋ -lʼok usu ↄsu ɛsɛl. ");
INSERT INTO adj_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Nɛnɛgŋ e lɛgŋ a bʼɛc eci dimas lɛgŋ ɛny ow ɛm a, Mari Magdala yↄwi a lele Mari yecʼab ab ow am ɛkn uwↄmu a. ");
INSERT INTO adj_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kpru ɛm, wus umu lɛc ɛm, ɛtŋ Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam anŋ afr us es, ow wuwl lob a oc es ɛtŋ sig es af. ");
INSERT INTO adj_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Lʼɛw ɛsɛ afr eke bʼɛŋn af, ɛtŋ in eci mob sus ɛm a ufu ɛsɛ nyamok af. ");
INSERT INTO adj_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Usu ↄsu ɛsɛl a erŋn ↄny afŋn es, am ufŋ bↄbar, ɛtŋ ɛw ɛsɛ agŋ ekʼuw cɛ af. ");
INSERT INTO adj_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Afr ɛrm ɛs a dad ↄyↄw a ninɛ: «Erŋn kʼↄ́ny ↄny. Mʼuw any ekʼam ↄↄl Jesu a eke wɛl ɛw olikŋ af a; ");
INSERT INTO adj_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","nʼanm aŋa. Lʼigb agŋ ekʼuw ab ɛm ɛsɛ elel eke lʼikŋ anym li dad ab af. Òwr ɛkan usu a eke lʼɛru es a. ");
INSERT INTO adj_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Sica ìmn fafa dadr in e jam ɛsɛl a ɛsrɛ: “Lʼigb agŋ ekʼuw ab ɛm nʼaam lʼeku ↄny Galile. Yogŋ anake bʼow ɛkan in a.” » ");
INSERT INTO adj_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Erŋn lele sos ɛm iŋn ligbɛl ɛm ab, -lʼogŋ es -nʼŋgboŋ uwↄmu a ecʼusu a, ɛtŋ -lʼuru es -nʼaam -lʼɛwl Jesu e jam ɛsɛl a amani. ");
INSERT INTO adj_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Kpɛkŋ Jesu ↄbr ɛl ɛtŋ am dad ɛl ɛsɛ: «Mʼam ɛsŋn ↄny!» -Nʼim -li titm ow, -nʼↄny ow akr es ɛtŋ -nʼam igŋ ow nuŋ. ");
INSERT INTO adj_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jesu dad ɛl ninɛ: «Erŋn kʼↄ́ny ↄny. Ìmn dadr ɛm lisijimɛl a im Galile: yogŋ anake -li bʼow -lʼɛknʼm a.» ");
INSERT INTO adj_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Eke ↄyↄw a anŋ ejagb af yogŋ aam a, srↄda eyŋ ab ɛm e bɛb ekʼam ↄsu usu a ɛwl ow baŋn a, ɛtŋ awl ów a fɛŋ ekʼɛy a ok egb waw ɛsɛl ɛgbɛl a. ");
INSERT INTO adj_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Egb waw ɛsɛl ɛgbɛl a lele agŋ ekpekp ab ab ↄny luku as. Sica eke nɛny okr ɛl af a, -nʼↄŋ srↄda eyŋ a os nↄnↄ, ");
INSERT INTO adj_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","ɛtŋ -li dad wɛl ninɛ: «Dàdr ɛsrɛ: “Sʼam ɛru mɛmn ncok ɛm, ɛtŋ kpɛkŋ ɛgŋ a, in e jam ɛsɛl a ow iy in e sos megl a.” ");
INSERT INTO adj_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ɛtŋ eke Pilat iri yɛji, si bʼow sʼɛyrʼr ɛrm es; sʼuw elel eke si kʼɛwr nɛny ke kʼɛŋnmn es abur kaka ab any.» ");
INSERT INTO adj_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Usu ↄsu ɛsɛl a eb os a ɛtŋ kok ɛsɛ elel eke wɛl dadr ɛl ab af. Ɛbɛn eke amani a eb es Jwifɛl ɛm toŋ it yɛfɛnyna ana. ");
INSERT INTO adj_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Jam ɛsɛl lɛw nyam a ecʼa, -nʼim Galile eci lafɛny a eke Jesu yɛgm ɛl ab af. ");
INSERT INTO adj_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Yogŋ, eke -lʼɛkan ow a, -lʼok ↄwrↄkp wus -lʼigŋ ow nuŋ, gbɛkↄ ɛl ɛm ecʼagŋ bɛb gbɛ am bɛbar. ");
INSERT INTO adj_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesu ɛri ow ɛtŋ dad ɛl ninɛ: «Afr lele wus ab ecʼabusu a fɛŋ, Nyam ↄŋʼm. ");
INSERT INTO adj_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Sica ìmn wus na eci ɛbr ɛbr a ecʼagŋ a ogŋ, ke kókr ɛl -lʼel ɛm e jam us ɛsɛl; òkr ɛl mij nuŋ Ɛs, Jim, lele Abŋ Lala e nin ɛm ab; ");
INSERT INTO adj_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","yɛ̀gmn ɛl -lʼↄsu ów a fɛŋ eke mi dad ↄny a. Sica ìrir: sɛgŋ a fɛŋ mʼow mʼanŋ ↄny ab toŋ wus na e nuŋ ɛdŋ.»");
INSERT INTO adj_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Aŋa anake Jesu Krist Nyam Jim ecʼAmani Mamn a ↄb nuŋ a, ");
INSERT INTO adj_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ɛsɛ elel eke Nyam eci kokoba ↄb ɛs Esayi nↄn ab af: Ɛm Nyam, mʼow mʼↄŋ ɛm ecʼɛrm ɛs ikŋ anym kok ŋ ecʼejagb a. ");
INSERT INTO adj_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ɛgŋ nyam anŋ loj am ɛlu lebl dad ɛsɛ: «Kòkr Ɛs Kↄtↄkↄ ecʼejagb a, kòkr in e sebr a ínym nyim nyim!» ");
INSERT INTO adj_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kin elel eke Jan mij ok nuŋ ɛs ɛy ↄkm loj, ke am ɛlu lebl dad: «Ìtŋnin ɛrm ɛm, òkr mij nuŋ, ke Nyam bʼow oc ↄny e sikpl a ap ↄny.» ");
INSERT INTO adj_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Jude wus a nimum ecʼagŋ a fɛŋ lele Jerusalɛm ecʼab ab am ow Jan ogŋ. -Nʼam ɛgŋ ɛl e sikpl a -lʼeb agŋ a fɛŋ ecʼany af, ɛtŋ Jan am ok ɛl mij nuŋ Jurdɛn erŋ. ");
INSERT INTO adj_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan sus mob eke wɛl kok gbaŋkↄ kedebnam e suw ɛm, ɛtŋ lʼɛgŋ ndey lɛl ɛm e meb er ɛm. In ecʼob eke li bʼij a el tɛtɛ gbaŋgban lele mow mun ab. ");
INSERT INTO adj_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Nʼam dad agŋ a fɛŋ lʼɛsɛ: «Ɛgŋ a ekʼanŋʼm jam bʼow a, ↄny abusu nↄnↄ akm im, mʼitm yɛji eke mi kʼis es bake mʼↄny in e cↄkrukpↄ meb a mi mↄmu es. ");
INSERT INTO adj_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Ɛm ecʼa, mʼam ok ↄny mij nuŋ mij ɛm, kↄ in li bʼow lʼok ↄny mij nuŋ Abŋ Lala ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Lɛgŋ ab ɛm, Jesu anŋ Nasarɛt Galile wus af ow, ɛtŋ Jan okʼr mij nuŋ Jurdɛn erŋ. ");
INSERT INTO adj_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Eke nʼanŋ mij ab ɛm nʼam ɛy ↄkm a, lʼɛkn afr agbr ɛm ɛtŋ Abŋ usʼr es nuŋ af ɛsɛ kel af. ");
INSERT INTO adj_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ɛtŋ lebl nyam anŋ afr ikŋ am dad ɛsɛ: «Ŋ el ɛm ecʼIy eke mʼerur tasi; mʼoc ɛm eci sos ɛm iŋn fɛŋ mʼɛluʼŋ ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Kpɛkŋ eke ow bʼuwr a, Abŋ Lala oc imʼn loj. ");
INSERT INTO adj_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nʼanŋ yogŋ lʼij sɛgŋ ekŋ yony eke Satan ɛjuʼr. Lʼir yogŋ akp ɛm e mindey ab, ɛtŋ afr ɛrm ɛsɛl ow am kok in e lís e low. ");
INSERT INTO adj_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Lɛgŋ ab ɛm eke wɛl ɛlu Jan mij ok nuŋ ɛs sobel ɛm a, Jesu im Galile wus af ɛtŋ nʼam ↄb Nyam ecʼAmani Mamn a eci kokoba li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","«Lɛgŋ a eke Nyam ɛwar a ow ŋ̂, aŋke Nyam ecʼes ɛw a ow titm. Ìtŋnin ɛrm ɛm ke ébr Amani Mamn a.» ");
INSERT INTO adj_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Eke Jesu am ɛcr Galile eci mij lekpl a e saw saw a, lʼɛkn ↄcn ibi ɛsɛl agŋ yony, Simↄ lele lisijim Andre ab ekʼam ok muw mij lekpl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesu dad ɛl ninɛ: «Ùsrʼm jam, mʼow mi kok ↄny éel agŋ eb ɛsɛl.» ");
INSERT INTO adj_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Kpɛkŋ -li digŋ ɛl e muw a -lʼok es, ɛtŋ -lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Jesu bʼimn anym eci tɛl a, lʼɛkn Sebede jimɛl a, Jak lele lisijim Jan ab. -Nʼanŋ ɛl eci mijɛtŋ ab ɛm -nʼam kok ɛl eci muw a. ");
INSERT INTO adj_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kpɛkŋ Jesu ɛsŋ ɛl; -li digŋ ɛl ɛs Sebede lele ɛl e juma kok ɛsɛl ab ab -lʼɛlu es lɛtŋ ab ɛm, ɛtŋ -lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jesu lel in e jam ɛsɛl ab ab im Kapɛrnayum ecʼɛb ab ɛm. Nɛnɛgŋ e lɛgŋ a, Jesu ɛy Nyam nuŋ igŋ usu a ɛtŋ am yɛgm agŋ low. ");
INSERT INTO adj_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Agŋ a ekʼam iri in e low yɛgm a, low am iti any in ecʼelel eke nʼam yɛgmn agŋ low a sosiɛm, aŋke nʼanm ɛsɛ ɛl ecʼol e low yɛgm ɛsɛl ab af, kↄ nʼam yɛgm wɛl low abusu ↄny ɛm. ");
INSERT INTO adj_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ke Nyam nuŋ igŋ usu yogŋ ɛgŋ nyam ekʼabŋ ŋuŋ anŋ ɛm a, am ↄg dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","«Oy! Nasarɛt e Jesu, bla am erur eke ki kok ɛy ee? Kↄ ekʼow eke ki ŋuŋn ɛy ee? Ɛm, mʼuw ɛgŋ ekʼelʼŋ ab any: Nyam ecʼɛrm ɛs lala.» ");
INSERT INTO adj_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesu dad abŋ ŋuŋ a odad lebl tuↄtuↄ ɛm ninɛ: «Yèwal, ke ɛ́y ↄkm ɛgŋ na ɛm!» ");
INSERT INTO adj_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Abŋ ŋuŋ a mumu ɛgŋ a lɛc ɛm, ɛtŋ am ↄg ɛy ↄkm in ɛm. ");
INSERT INTO adj_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Agŋ a fɛŋ low iti any afŋn es toŋ batŋ -nʼam bibrmnin ɛl ↄfr -lʼɛsɛ: «Kↄ na bla lowi ana ee? Bogŋ ecʼabusu ↄny ɛm e low yɛgm owr ana ee? Ɛgŋ ikŋ na ɛw abŋ eŋuŋ yɛjʼes, ɛtŋ -li bʼɛlum ow!» ");
INSERT INTO adj_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ɛtŋ kpɛkŋ agŋ am dad Jesu e lís e low Galile wus nimum af. ");
INSERT INTO adj_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Eke -nʼanŋn Nyam nuŋ igŋ usu a -lʼokr ↄkm a, Jesu, Jak lele Jan ab im Simↄ lele lisijim Andre ab ogŋ a. ");
INSERT INTO adj_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simↄ ɛy lis eke sos am ɛtu es a, ɛru es. Ɛtŋ kpɛkŋ wɛl dad in ecʼↄl owi ok Jesu. ");
INSERT INTO adj_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jesu im ɛŋn yↄw a, lʼucu abu nʼↄny lʼigbm ow, ɛtŋ kpɛkŋ in ecʼↄl a ocʼr es lís. Ɛtŋ yↄw a am kok ɛl e lís e low. ");
INSERT INTO adj_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ncebles ɛm a, eke ligbn im ɛru es a, agŋ ot ɛl ecʼↄ́lu a fɛŋ is Jesu; abŋ eŋuŋ ɛsɛl yɛji anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɛb ab ɛm ecʼagŋ a fɛŋ as luku Simↄ eci lisany a. ");
INSERT INTO adj_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesu ewlm ↄ́lu a lel ɛl ecʼↄl ɛrŋ ɛrŋ a fɛŋ ab. Nʼam ogŋ abŋ eŋuŋ a, ɛtŋ lʼɛ́lum wɛl abusu es eke wɛl ki dad odad, aŋke -lʼuw ɛgŋ a ekʼel Jesu ab any. ");
INSERT INTO adj_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lɛgŋ ɛny ow ɛm a, eke usu kʼotm es a, Jesu igb ɛy gbeŋ ɛtŋ im usu saw ɛm. Yogŋ, nʼam ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simↄ lele lawlɛl a ekʼanŋ in ab ab ok ↄkm im in ecʼↄl ɛm. ");
INSERT INTO adj_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Eke nʼɛŋan ow a, -li dad ow ninɛ: «Agŋ a fɛŋ am ↄlʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jesu dad ɛl ninɛ: «Sʼŋ́gboŋn aŋa, sʼímn baŋn saw saw a, aŋke yogŋ yɛji ow it eke mi ki dad ɛl Amani Mamn a ecʼodad. Na sosiɛm eci mʼow wus na af.» ");
INSERT INTO adj_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ɛtŋ Jesu am ɛc Galile wus ab af nimum. Nʼam ↄb Amani Mamn a e kokoba Nyam nuŋ igŋ usu a fɛŋ, ɛtŋ nʼam ogŋ abŋ eŋuŋ yɛji. ");
INSERT INTO adj_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Lɛgŋ nyam kokobe ɛs nyam ow am kok sↄrŋ ibrm Jesu abu ɛlum; lʼok ↄwrↄkp wus Jesu ecʼany af, ɛtŋ nʼam dad lʼɛsɛ: «Eke ŋ erur, ↄtu eke kʼayalʼm.» ");
INSERT INTO adj_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","In e low ↄny Jesu sↄrŋ; lʼɛgŋm abu es lʼitŋn ow ɛtŋ li dad ninɛ: «Mʼerur, àyl!» ");
INSERT INTO adj_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kpɛkŋ kokobe a ocʼr es lís, ɛtŋ lʼayl. ");
INSERT INTO adj_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesu ɛlu ↄlu a eke lʼewlm a abusu es eke kʼim, ɛtŋ lʼɛwar ow lebl tuↄtuↄ ɛm ninɛ: ");
INSERT INTO adj_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","«Ìri sɛnyn sɛnyn, kì dad low na kʼok ɛgŋ kaka! Gbɛkↄ ìm yɛgm egb waw ɛs a sos, ke wáw egb ɛsɛ elel eke Mois ecʼol a ibrm ab af, ke ow íj daŋku.» ");
INSERT INTO adj_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɔlu a im, ɛtŋ usu a fɛŋ nʼam dad low a eke ɛŋnʼn a ecʼodad. Na sosiɛm Jesu ↄ́tum ilam sos any ɛb ɛm, kↄ li bʼanŋ usu saw ɛm ke agŋ am anŋ susu a fɛŋ ow in ogŋ. ");
INSERT INTO adj_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Eke sɛgŋ bɛb ɛc a, Jesu ɛwl ow Kapɛrnayum, ɛtŋ dedeku a iri eke lʼɛc akŋ. ");
INSERT INTO adj_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ɛtŋ kpɛkŋ agŋ nↄnↄ ow as luku gbugŋ a eb usu a fɛŋ; usu kaka anm, lisany a bↄbↄ yɛji usu anm. Nʼam dad wɛl Nyam ecʼodad, ");
INSERT INTO adj_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ɛtŋ agŋ yar abu sos es wɛw ɛs nyam am is Jesu. ");
INSERT INTO adj_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Gbɛkↄ eke -li kʼↄtumn -lʼokmn yogŋ a eke Jesu sig es agŋ a sosiɛm a, -li fig usu nyam êl luw af a, ɛtŋ -lʼoc ↄlu a ekʼanŋ in eci faja ɛm a -lʼusm es Jesu ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Eke Jesu bʼɛkn agŋ a ecʼↄmn a, li dad sos es wɛw ɛs a ninɛ: «Ɛm jim, mʼoc ŋ e sikpl a mʼapʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ol eci low any uw ɛsɛl bɛb sig es yogŋ, ɛtŋ am tutr ɛl ecʼɛrm ɛm dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«Kↄ bla ɛtŋ ɛgŋ na am dad odad nɛnɛ ee? Nʼam ↄbr Nyam any! Bwo ecʼɛgŋ ↄtu eke kʼóc sikpl ap ekʼow elm Nyam sↄny coco ee?» ");
INSERT INTO adj_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Eke Jesu uw ɛl e sow tutr ab any a, li dad wɛl ninɛ: «Kↄ bla ɛtŋ am tutar ów amua na ↄny ecʼɛrm ɛm ee? ");
INSERT INTO adj_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kↄ bogŋ ecʼanake ɛw fuɛfuɛ eke wɛl ki dad sos es wɛw ɛs ab ee? “Mʼoc ŋ e sikpl a mʼapʼŋ”, oglog ke wɛl dádʼr ɛsɛ: “Ìgb oc ŋ eci faja a ke án es ee”? ");
INSERT INTO adj_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Gbɛkↄ mʼerur eke kʼuwr low na any: wus na af, ɛgŋ ecʼIy ↄny abusu eke kʼoc sikpl ap.» Ɛtŋ sica li dad sos es wɛw ɛs a ninɛ: ");
INSERT INTO adj_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","«Mʼam dadʼŋ, ìgb oc ŋ eci faja a eb ejagb ím gbugŋ!» ");
INSERT INTO adj_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Kpɛkŋ ɛgŋ a igb agŋ a fɛŋ ecʼany af, lʼoc in eci faja a, ɛtŋ lʼɛy ↄkm nʼam an es nʼim. Ow e low a iti dedeku ab any, ɛtŋ -nʼam kↄklm Nyam -li dad -lʼɛsɛ: «Lɛgŋ kaka sʼɛknm low akpasu na.» ");
INSERT INTO adj_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ɛmɛny Jesu ɛwl im Galile eci mij nɛny a. Agŋ nↄnↄ am ow in ogŋ, ɛtŋ nʼam yɛgm wɛl low. ");
INSERT INTO adj_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","In ecʼɛc ɛm a, lʼɛkn Alfe jim Levi, eke sig es wus labm eb usu. Jesu dadʼr ninɛ: «Ùsʼm jam!» Levi igb ɛtŋ usʼr jam. ");
INSERT INTO adj_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ow e jam a, Jesu im Levi ecʼakŋ a, ɛtŋ am ij ob. Wus labm eb ɛsɛl nↄnↄ lele sikpl ɛsɛl ab am ij ob Jesu lele in eci jam ɛsɛl ab ab, aŋke agŋ amua e nↄnↄ anake am usʼr jam a. ");
INSERT INTO adj_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ɛtŋ ol e low yɛgm ɛsɛl ekʼel Farisiɛl ecʼogog ecʼagŋ a, ɛkn eke Jesu am ij ob agŋ amua fɛŋ ab; ɛtŋ -li dad in eci jam ɛsɛl a ninɛ: «Kↄ bla ɛtŋ nʼam ij ob wus labm eb ɛsɛl amua lele sikpl ɛsɛl amua ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesu iri odad a eke -nʼam dad a, ɛtŋ dad ɛl ninɛ: «Agŋ a ekʼanŋ sos tuↄtuↄ ɛm a, íbram sos kok ɛs, kↄ ↄ́lu anake bʼibrm sos kok ɛs a. Mʼowm eke mi kʼɛsŋ agŋ eke bʼubr ɛl sosi nɛnyɛmbri nyam ɛsɛl a, kↄ mʼow eke mi kʼɛsŋ “sikpl ɛsɛl”.» ");
INSERT INTO adj_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Lɛgŋ nyam, Jan mij ok nuŋ ɛs eci jam ɛsɛl a lele Farisiɛl ab am ɛnŋ nɛny. Agŋ ow am ibrm Jesu ɛsɛ: «Kↄ bla sosiɛm ɛtŋ Jan mij ok nuŋ ɛs eci jam ɛsɛl a lele Farisiɛl ecʼab ab bʼɛnŋ nɛny ɛtŋ ŋ e jam ɛsɛl a ɛ́nŋm nɛny ee?» ");
INSERT INTO adj_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesu dad ɛl ninɛ: «Kↄ am tutar ekʼagŋ lawlɛl eke wɛl ɛsŋ mɛbi eci es gbɛgbl ɛm a ↄtu eke kʼɛ́nŋ nɛny eke yↄw ɛc a anŋ ɛl ab ee? Njaŋ! Sɛgŋ a fɛŋ eke yↄw ɛc a bʼow anŋ ɛl ab a, -li bʼow -lʼij ɛtŋ -li bʼow -lʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Gbɛkↄ lɛgŋ am ow eke wɛl bʼow ↄny yↄw ɛc a oc es ɛl ecʼaraŋn, ke sica -nʼɛnŋ nɛny gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Ɛtŋ Jesu ub ɛl nyandrɛ ninɛ: «Ɛgŋ ócm gbad owr lele gbad sig ab ↄbarm gigŋm. Eke kok ɛbɛn, ke gbad owr a bʼow ↄny gbad sig a agbr ɛm; ɛtŋ gbad a ecʼɛm agbr a bʼow agb nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ɛtŋ ɛmɛny ɛgŋ ócm mar owr okm marel sig ɛm. Eke kok ɛbɛn a, mar owr a bʼow inŋ toŋ ba ke ↄ́ny marel sig a ↄb es. Ɛtŋ wɛl bʼow irmn mar a lele marel ab ab. Tasi ɛm a, mar owr, marel owr ɛm wɛl kʼok.» ");
INSERT INTO adj_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Nɛnɛgŋ e lɛgŋ nyam, Jesu lel in eci jam ɛsɛl ab ab am ɛcr segb ↄgm eci. Ɛl ecʼejagb us ɛm a, jam ɛsɛl a am bubm egbey a. ");
INSERT INTO adj_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farisiɛl ow ɛtŋ am ibrm Jesu ɛsɛ: «Ìs any ɛkn, kↄ bla sosiɛm ɛtŋ ŋ e jam ɛsɛl a am kok low ekʼɛy ecʼol a ↄↄm abusu eke wɛl ki kok nɛnɛgŋ e lɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jesu ↄdu eb dad ɛl ninɛ: «Awlmn low eke ɛb ebu David in obi in obi lele in ecʼagŋ ab ab kok lɛgŋ nyam eke namn am ↄny ɛl ab ee? ");
INSERT INTO adj_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Lʼɛy Nyamel ɛm, ɛtŋ in eci agŋ ab ab -lʼij egb waw eci futufutu a. Low na ɛy egb waw ɛs ligbɛl Abiatar e lɛgŋ ab ɛm. Ɛy ecʼol a ↄŋ abusu eke egb waw ɛsɛl sↄny coco kʼij egb waw e futufutu na.» ");
INSERT INTO adj_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesu igŋ af dad ninɛ: «Nyam kok nɛnɛgŋ ɛgŋ e nimamn sosiɛm kↄ ow elm nɛnɛgŋ sosiɛm Nyam kokm ɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Na sosiɛm anake ɛgŋ ecʼIy el nɛnɛgŋ yɛji ecʼes ɛw ɛs a.» ");
INSERT INTO adj_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ɛmɛny Jesu ɛwl ow Nyam nuŋ igŋ usu a. Yogŋ, lʼɛkn ɛgŋ nyam ekʼabu wɛw es. ");
INSERT INTO adj_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Agŋ a fɛŋ ekʼanŋ Nyam nuŋ igŋ usu a okʼr anyamn af am lɛr gbiy ɛkn, eke li bʼow lʼewlm ɛgŋ na nɛnɛgŋ e lɛgŋ na, aŋke -nʼam ↄl low nyam eke -li kʼebr ow af -lʼok ow ów af. ");
INSERT INTO adj_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesu ɛsŋ ɛgŋ a ekʼabu wɛw es a, ɛtŋ li dad ow ninɛ: «Ìgb ow aŋa inym es agŋ a fɛŋ ecʼany af!» ");
INSERT INTO adj_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ɛtŋ nʼam ibrm agŋ a ekʼanŋ yogŋ a lʼɛsɛ: «Nɛnɛgŋ e lɛgŋ a bla lowi ɛy ecʼol a ↄŋ abusu eke wɛl ki kok ee? Low nimamn kↄ low ŋuŋ ee? Wɛl ↄtu eke ki sↄg ɛgŋ oglog wɛl ɛgbʼr es luw ee?» Kↄ -lʼↄbm kpu. ");
INSERT INTO adj_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɛtŋ Jesu am lɛr ɛl ɛrm bebl ɛm; sos yɛji ↄwʼr es aŋke -nʼↄnym sↄrŋ ikŋ kaka. Li dad ↄlu a ninɛ: «Ɛ̀gŋm abu es!» Lʼɛgŋm abu es ɛtŋ lʼewl. ");
INSERT INTO adj_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kpɛkŋ Farisiɛl a ok ↄkm Nyam nuŋ igŋ usu a, ɛtŋ Erↄd Antipas ecʼogog ecʼagŋ ab ab -nʼim -nʼam as luku, -lʼↄl elel eke -li kʼↄnyn Jesu bake -lʼibi ow. ");
INSERT INTO adj_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesu lel in e jam ɛsɛl ab ab ocr sos es im Galile e mij saw a, ɛtŋ agŋ nↄnↄ am usʼr jam. Agŋ am anŋ Galile, Jude, ");
INSERT INTO adj_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalɛm, Idume, Jurdɛn ogog eci wus ab af, Tir lele Sidↄn eci baŋn saw saw a ow. Bieku na am ow eke kʼɛkn Jesu aŋke -lʼiri ów a fɛŋ ekʼow am kok a. ");
INSERT INTO adj_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Jesu dad in e jam ɛsɛl a ninɛ: «Òcr mijɛtŋ nyam owr ɛwr es aŋa, yecʼɛtŋ ke dedeku a kʼátram im sel.» ");
INSERT INTO adj_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Eke Jesu ewlm agŋ nↄnↄ a sosiɛm, agŋ a fɛŋ ekʼↄny ↄl ɛrŋ ɛrŋ a, am itarir eke kʼɛŋn usu itŋn in abu. ");
INSERT INTO adj_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ekʼagŋ ekʼabŋ eŋuŋ anŋ ɛm a bʼɛkn Jesu a, -li bʼok wus ow ecʼany af -nʼam babarm -lʼɛsɛ: «Ŋ Nyam ecʼIy.» ");
INSERT INTO adj_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Kↄ Jesu am ijl ɛl nɛny kpoŋkpoŋ dad ɛsɛ: «Kʼùlmnʼm es!» ");
INSERT INTO adj_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ca Jesu uyu lafɛny af, lʼɛsŋ agŋ eke lʼerur a ɛtŋ wɛl ow in ogŋ. ");
INSERT INTO adj_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ɛl ɛm a li sↄsum agŋ lɛw yony lʼot ɛtŋ nʼↄŋ wɛl nin ɛrm ɛsɛl. Li sↄsum lʼot wɛl eke wɛl kʼanŋ in ab ke nʼám ɛrm wɛl -nʼim -lʼↄb gbreŋgbi usu a e kokoba. ");
INSERT INTO adj_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nʼↄŋ wɛl abusu eke wɛl kʼogŋ abŋ eŋuŋ yɛji. ");
INSERT INTO adj_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Kin ɛrm ɛsɛl lɛw yony a ecʼen: Simↄ (Jesu igŋʼn nin af Piɛr), ");
INSERT INTO adj_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jak lele lisijim Jan ab, ɛl Sebede ecʼey (Jesu ↄŋ ɛl nin Bwanɛrgɛs ekʼel nyandrɛ ɛm: “agŋ ekʼɛl e low kok bʼot nyamgbrany es”), ");
INSERT INTO adj_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andre, Filip, Bartelemi, Matie, Toma, Jak Alfe jim, Tade, Simↄ low dogŋn ɛs, ");
INSERT INTO adj_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","lele Judas Iskariↄt ekʼↄl Jesu ij ab ab. ");
INSERT INTO adj_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ɛmɛny Jesu ɛwl mɛny ow akŋ a. Agŋ nↄnↄ ɛwl mɛny ow as luku yogŋ toŋ Jesu lel in e jam ɛsɛl ab ab ɛ́ŋnm abusu eke kʼij ob yɛji. ");
INSERT INTO adj_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Jesu ecʼakŋ ecʼagŋ am ow eke kʼocʼr ab im aŋke -nʼam iri eke Jesu in ki kokm ɛgŋ ɛm owi. ");
INSERT INTO adj_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ɛtŋ ol e low yɛgm ɛsɛl ekʼanŋ Jerusalɛm ow a am dad ɛsɛ: «Bɛlsebul, abŋ eŋuŋ ecʼes ɛw a, anŋ Jesu ɛm! Ow anake ow bʼↄŋʼn abusu ke li bʼↄtu lʼogŋ abŋ eŋuŋ a.» ");
INSERT INTO adj_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesu ɛsŋ ɛl ɛtŋ nʼam dad wɛl sodad nyandrɛ ɛm lʼɛsɛ: «Ayaf Satan ↄtu eke kʼogŋn in sosi ar ee? ");
INSERT INTO adj_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Eke batŋ es ɛw nyam ecʼagŋ bʼogŋ ar ɛl ↄfr ɛm, es ɛw a kʼↄtum anm ij. ");
INSERT INTO adj_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ɛbɛn nɛnyɛmbri nyam bosu nyam ecʼagŋ ekʼubr ɛm ɛl ↄfr a, kʼↄtum anm ij. ");
INSERT INTO adj_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Eke batŋ Satan bʼogŋn in sosi ar, oglog Satan nɛny ókrm af in obi ab ij a, ke in eci abusu a kʼↄtum ibnm ij; in eci es ɛw a uwr ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ɛtŋ ɛmɛny, eke wɛl erur eke kʼim ɛy lɛc ɛs nyam ecʼakŋ iyʼr mil a, ow it ke wɛl íkŋ anym ↄny awŋʼn gbuŋ ke wɛl ↄ́tu ɛy in ecʼakŋ a ot in eci mob a fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ɛtŋ Jesu igŋ af dad ninɛ: «Mʼam dad ↄny nawrɛ ɛm tasi, agŋ ↄtu eke kʼɛŋn sikpl fɛŋ lele sodad eŋuŋ fɛŋ eke -li bʼow -li dad -lʼok Nyam af ab ab ecʼoc ap. ");
INSERT INTO adj_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Gbɛkↄ ekʼɛgŋ nyam dad low ŋuŋ ok Abŋ Lala af a, li kʼow nʼɛŋnm ow ecʼoc ap lɛgŋ kaka, aŋke low ŋuŋ a bʼow anŋʼn af sɛgŋ fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Jesu dad odad na ok ol e low yɛgm ɛsɛl ab af, aŋke -li dad ekʼabŋ ŋuŋ in anŋ ow ɛm sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ɛtŋ Jesu lis lele lisijim jam ɛsɛl ab ab ow. -Nʼinym es gbeŋ a ɛtŋ -nʼↄŋ ɛgŋ ɛy akŋ a eke kʼɛsŋʼn. ");
INSERT INTO adj_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Agŋ nↄnↄ ok es iwr ɛlul Jesu ɛm, ɛtŋ wɛl dadʼr eke: «Kin, esŋ lele esŋ jimɛl ab ekʼow inym es gbeŋ a. -Nʼam erur eke -li kʼɛknʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ɛtŋ Jesu dad ninɛ: «Kↄ bwo el ɛm lis ee? Ɛtŋ kↄ bwo ɛl el ɛm lisijimɛl ee?» ");
INSERT INTO adj_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɛtŋ eke lʼɛw nyamn li lɛr agŋ a ekʼok es iwr did ɛlul il ɛm a, li dad ninɛ: «Kin ɛm lis lel ɛm lisijimɛl ab ekʼanŋ aŋa, ");
INSERT INTO adj_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","aŋke ɛgŋ kaka fɛŋ eke bi kok Nyam ecʼerur a, el ɛm lisijim, ɛm lisijↄw, lel ɛm lis ab.» ");
INSERT INTO adj_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Sakp ɛjeci, Jesu ow Galile eci mij nɛny a, ɛtŋ nʼam yɛgm agŋ low. Agŋ nↄnↄ ow ar did ɛlul il ɛm. Na sosiɛm lʼɛy mijɛtŋ nyam ekʼanŋ mij af ab ɛm ɛtŋ li sig es. Bieku a nimum ok es mij nɛny a. ");
INSERT INTO adj_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesu am ot nyandrɛ ɛm ecʼów nↄnↄ yɛgmn ɛl low. In eci low yɛgm ab ɛm, nʼam dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«Ìgŋn lↄru es irir! Lɛgŋ nyam, egb ewl ɛs nyam im ↄgm am ewl egb. ");
INSERT INTO adj_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Eke nʼam ufŋ egb ey ab es a, bɛb ok ebr af ɛtŋ ↄr ow sus ij. ");
INSERT INTO adj_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Bɛb ok mebn wus af, usu eke sɛc ɛnym. Kpɛkŋ -lʼɛli sɛc a ekʼɛnym a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Kↄ eke ligbn ow afr a, lʼebal egb a eke ɛli ok ↄkm a ɛtŋ li wɛwr ow es aŋke min ↄnym ɛl wus tasi. ");
INSERT INTO adj_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Bɛb ɛjeci ok usu eke mirŋ anŋ. Mirŋ a ɛli ↄny awŋ ɛl es. Na sosiɛm -lʼↄsum ey kaka. ");
INSERT INTO adj_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Gbɛkↄ egb ey a e bɛb ok wus mamn af. -Lʼɛli -lʼok ↄkm, -lʼagb ɛtŋ -lʼↄsu ey. Bɛb ↄsu likŋ lele lɛw ab, bɛb ecʼa ekŋ nyahan ɛtŋ ow e bɛb a ↄsu ekŋ yen.» ");
INSERT INTO adj_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ɛtŋ Jesu igŋ af dad ninɛ: «Ekʼↄnyn ↄru eke kʼirir, ke írir sɛnyn sɛnyn!» ");
INSERT INTO adj_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Eke Jesu anm bieku ab ab ij a, in e jam ɛsɛl lɛw yony a lel agŋ a eke bʼanŋ in ab a, am ibrmʼn low sodad nyandrɛ ab af. ");
INSERT INTO adj_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesu dad ɛl ninɛ: «Ɔny ɛŋan Nyam eci gbreŋgbi usu a ecʼów a eke lↄl es a ecʼany uw. Kↄ ɛl ecʼa, nyandrɛ ɛm cɛ mʼam dad ɛl, ");
INSERT INTO adj_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","yecʼɛtŋ ke -li bi lɛr ke -li kʼɛknmn; -li bʼiri ke ow kʼokm ɛl es sos ɛm, aŋke blel ow am ok ɛl es sos ɛm, blel -lʼɛwl mɛny -lʼow Nyam ogŋ, ke blel ow áp ɛl low.» ");
INSERT INTO adj_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ɛtŋ Jesu dad agŋ a ekʼanŋ yogŋ a ninɛ: «Ɔny ↄtumn irimn egb ewl ɛs a ecʼodad a e nyandrɛ? Ayaf bʼow ↄtur irir sodad nyandrɛ ɛm a fɛŋ ee? ");
INSERT INTO adj_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Egb ewl ɛs a ewl Nyam odad. ");
INSERT INTO adj_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ebr ab af a eke egb a ok a, el agŋ eke bʼiri odad a. Kpɛkŋ Satan ow ↄny odad eke wɛl ewl ɛl ecʼɛrm ɛm a oc es. ");
INSERT INTO adj_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Mebn wus a eke egb a ok a, el agŋ eke bʼiri odad a ke kpɛkŋ ebʼr sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Gbɛkↄ, -li yɛbmn odad a okm min ɛl ɛm, -li bʼɛw ɛrm af tɛl cɛ. Eke sica sos es ↄw owi oglog gbre ij owi bʼow Nyam odad a sosiɛm a, -li bʼɛgbr ↄmn a fafa. ");
INSERT INTO adj_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Wus a eke mirŋ nↄnↄ anŋ af ke egb a ok af a, el agŋ eke bʼiri odad a. ");
INSERT INTO adj_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Gbɛkↄ wus aŋa ecʼɛrm mij ebr, ob ↄny e mɛju lele wus ecʼów aw ɛjeci nↄnↄ iy ɛl ɛrm ɛm gbↄŋ, ɛtŋ ↄny odad a awŋ es ɛl ɛm, ke ↄ́tum ↄsum ey kaka. ");
INSERT INTO adj_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Wus mamn a el agŋ eke bʼiri odad a ke ebʼr. Ow ↄsu ey ɛl ɛm. Bɛb ↄsu likŋ lele lɛw ab, likpr ↄsu ekŋ nyahan ɛtŋ bɛb a ↄsu ekŋ yen!» ");
INSERT INTO adj_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jesu ibrm ɛl ninɛ: «Kↄ kɛniɛ eke wɛl bʼigŋ a, ob ew eke wɛl kʼubur es oglog kofa ew eke wɛl kʼoc ɛw sosiɛm wɛl bʼigŋ ee? Njaŋ! Tasi ɛm a, ob gege af wɛl bʼitmn es. ");
INSERT INTO adj_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ɛbɛn low fɛŋ eke lↄl es a bʼow ɛy ↄkm, ɛtŋ yecʼekʼanŋ ncebn ɛm a bʼow ilm any usuayl ɛm. ");
INSERT INTO adj_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ke ɛgŋ ekʼↄny ↄru eke kʼiri a, íri gↄŋ!» ");
INSERT INTO adj_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ɛtŋ ɛmɛny Jesu dad ɛl ninɛ: «Ɛ̀wr low fɛŋ eke bʼow irir a ɛrm sɛnyn sɛnyn! Aŋke akunda yecʼɛm eke bʼow ocr ɛbmnin ob ↄŋn ɛgŋ ɛjecʼa, ow ɛm cɛ Nyam yɛji bʼow ɛbmn ↄŋ ↄny, ɛtŋ li bʼow li kok lʼakm ↄny ecʼa. ");
INSERT INTO adj_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Tasi ɛm a, ɛgŋ ekʼiri odad a ke ucu ↄny es a, Nyam bʼow obnʼn; kↄ ɛgŋ ekʼirim kaka a, tɛl a eke lʼiri a yɛji, wɛl bʼow ↄny ocʼr es ɛrm af.» ");
INSERT INTO adj_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ɛmɛny Jesu dad ninɛ: «Nyam e gbreŋgbi usu a otarir es odad na ab: igŋ nyam ewl egb ey in ecʼↄgm a. ");
INSERT INTO adj_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Sica nʼim ɛtŋ nʼam ir ɛb, lʼɛru es lʼigb, ncok lele lɛgŋ owr ab ɛsɛ sɛgŋ fɛŋ ecʼab af. Gbɛkↄ egb ey a ɛli ok ↄkm ɛtŋ am agb ekʼɛgŋ a in obi uwm ow e low kaka any. ");
INSERT INTO adj_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Kↄ wus in obi li bi kok ɛtŋ egb ey a bʼɛli ok ↄkm, agb toŋ usu sel ɛm. ");
INSERT INTO adj_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ɛtŋ ekʼegb ey a usu a, kpɛkŋ ɛgŋ a ow ɛl ecʼub ɛm, aŋke ow it eke sica wɛl kʼub ɛl gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ɛmɛny Jesu dad ninɛ: «Bla lowi wɛl ↄtu eke kʼoc bɛbmn Nyam e gbreŋgbi usu ab ab ee? Ɛtŋ bogŋ ecʼodad wɛl ↄtu eke kʼoc dadr ow e low ee? ");
INSERT INTO adj_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nyam e gbreŋgbi usu a anŋ ɛsɛ likŋ e liy nyam eke wɛl ewl af. Gbuŋ eke wɛl kʼewlʼl a, lʼel egb ey a fɛŋ ɛm eci likekli tasi. ");
INSERT INTO adj_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Sica eke li bʼɛli lʼɛy ↄkm a, li bʼagb lʼakm wɛl fɛŋ. Li bʼok ál, li faf es toŋ bake ↄ́r ám ow sus mel in ecʼál a eci lↄw ew a.» ");
INSERT INTO adj_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Sodad nyandrɛ amua ɛm anake Jesu bʼoc am dadr ɛl Nyam ecʼodad a, yecʼa cɛ eke -lʼↄtur eke -li kʼoc -lʼɛw es ɛrm ɛm a. ");
INSERT INTO adj_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Sakp sakp fɛŋ Jesu bʼoc sodad nyandrɛ ɛm am dadr ɛl ów. Gbɛkↄ eke li bʼanŋ in e jam ɛsɛl ab ab a, li bʼotar ów a fɛŋ akr lʼok wɛl. ");
INSERT INTO adj_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Lɛgŋ a cɛ eci ncebles a, Jesu dad in e jam ɛsɛl a ninɛ: «Sʼúbar mij jam a.» ");
INSERT INTO adj_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɛtŋ eke -lʼɛlul bieku ab es a, jam ɛsɛl a ok lɛtŋ a eke Jesu anŋ ɛm ab ɛm, ɛtŋ -nʼim. Mɛtŋ ɛjeci yɛji anŋ ɛl saw. ");
INSERT INTO adj_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ɛl ecʼubr ɛm a, kpɛkŋ lidgbegb okr ɛl es ɛtŋ mra am ɛlul ɛl, toŋ mij am bubm ok ɛl lɛtŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jesu gbɛ ɛkpn ob, ɛru es lɛtŋ nɛny a am ɛru mɛmn. Jam ɛsɛl a am uwrʼr dadʼr ɛsɛ: «Low yɛgm agŋ ɛs, kↄ ɛy e luw na eke sʼam ow sʼuw a, ow am kokmʼŋ low kaka ee?» ");
INSERT INTO adj_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesu ufŋm es ɛtŋ dad lidgbegb a lele mij ab ab ninɛ: «Ìrmn es! Àdar!» Ɛtŋ lidgbegb a ecʼɛlu a ubr es ɛtŋ usu a fɛŋ irm es tiŋ. ");
INSERT INTO adj_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Sica Jesu am dad in e jam ɛsɛl a ɛsɛ: «Kↄ bla ɛtŋ erŋn am ↄny ↄny ee? Kↄ ↄny kʼↄnymn ↄmn cɛ ee?» ");
INSERT INTO adj_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Jam ɛsɛl a erŋn ligbɛl am ↄny ɛtŋ am dad ɛl ↄfr ɛm ɛsɛ: «Kↄ bwo el ɛgŋ ikŋ na eke lidgbegb lele mij ab bʼↄny in ecʼɛlum ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesu lel in eci jam ɛsɛl ab ab im ok Galile eci mij jam a, Geraseni eyŋ eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Eke nʼanŋ mijɛtŋ ab ɛm lʼus es a, kpɛkŋ ɛgŋ nyam anŋ ɛgŋ es oc usu a ɛy ↄkm ow am ↄbrʼr. Ɛgŋ a, abŋ ŋuŋ anŋʼn ɛm. ");
INSERT INTO adj_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Suwↄmu ecʼaraŋn anake li bʼanŋ a. Ɛgŋ kaka ↄ́tum ucurmʼn es, ŋgbraka ɛm bↄbↄ yɛji, ");
INSERT INTO adj_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","aŋke sakp nↄnↄ wɛl bʼawŋʼn akr lele sabu ab ŋgbraka ɛm, kↄ li bʼↄny fɛŋ li bubr es. Ɛgŋ kaka ↄnym lɛc eke kʼↄtu ↄnyʼn yɛji. ");
INSERT INTO adj_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Sɛgŋ fɛŋ, ncok lele lɛgŋ owr ab, li bʼanŋ suwↄmu ekʼanŋ mafɛny ɛm a ecʼaraŋn; nʼam babarm ke nʼam ot mebn li kokr in sosi mob. ");
INSERT INTO adj_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Lʼɛkn Jesu akpoj ɛm, lʼuru es lʼow, lʼok ↄwrↄkp wus ow ecʼany af, ɛtŋ nʼam ɛlu lebl tuↄtuↄ li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","«Jesu, Nyam ekʼanŋ afr kpekpe ecʼIy, kↄ bla lowi anŋ ɛy araŋn ee? Nyam e nin ɛm mʼam ŋↄŋnʼŋ, kì kokʼm low ŋuŋ!» ");
INSERT INTO adj_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Abŋ ŋuŋ a ɛw lebl am dad ɛbɛn aŋke Jesu ikŋ anym dadʼr ninɛ: «Abŋ ŋuŋ, ɛ̀y ↄkm ɛgŋ na ɛm!» ");
INSERT INTO adj_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ca Jesu am ibrmʼn ɛsɛ: «Kↄ ayaf wɛl bʼɛsŋnʼŋ ee?» Li dad ninɛ: «Wɛl bʼɛsŋʼm “Bubutɛ”, aŋke sʼɛny nↄnↄ.» ");
INSERT INTO adj_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ɛtŋ nʼam at lebl es ni ŋↄŋn Jesu lʼɛsɛ: «Kʼògŋ abŋ eŋuŋ amua kʼŋgboŋ wus ikpr ab af.» ");
INSERT INTO adj_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Yogŋ, gbroko nↄnↄ anŋ ekʼam ij ob lafɛny a saw. ");
INSERT INTO adj_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Abŋ eŋuŋ a am ŋↄŋn Jesu dad ɛsɛ: «Ògŋ ɛy sʼim sigbroko amua ogŋ a yecʼɛtŋ ke sʼók ɛl ɛm!» ");
INSERT INTO adj_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Jesu ↄŋ ɛl ow ecʼabusu. Abŋ eŋuŋ a ok ↄkm ɛgŋ ab ɛm, ɛtŋ im ok sigbroko ab ɛm. Gbroko a fɛŋ ekʼanŋ yogŋ a ↄtu eke kʼij fandi yony. Ɛl a fɛŋ -nʼanŋ lafɛny ab af -lʼuru es -lʼok mij lekpl ab ɛm, ɛtŋ -nʼɛmn. ");
INSERT INTO adj_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Es uru ɛm, sigbroko ↄsu ɛsɛl a ɛwl im am ↄb amani ɛb ab ɛm lele sikpukpu ɛm ab. Ɛtŋ agŋ am ow ɛkn low yecʼa ekʼɛy a. ");
INSERT INTO adj_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","-Lʼow -nʼɛŋn Jesu, ɛtŋ -lʼɛkn ɛgŋ a eke lɛgŋ sig ɛm abŋ eŋuŋ anŋ ɛm a eke sig es. Sica li sus mob; nuŋ ɛm ayal. Ɛtŋ agŋ a erŋn am ↄny. ");
INSERT INTO adj_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Agŋ a ekʼɛkn ów a fɛŋ ekʼɛŋn ɛgŋ a ekʼↄny abŋ eŋuŋ a, lele low yecʼa ekʼɛŋn sigbroko ab ab a, am awl ow ecʼów ok ɛl. ");
INSERT INTO adj_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ɛtŋ agŋ a fɛŋ ekʼow a okr af am ŋↄŋn Jesu eke li kʼŋgboŋ ɛl eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Eke Jesu am ɛy mijɛtŋ ab ɛm a, ɛgŋ a ekʼↄny abŋ eŋuŋ bake ewl a am dadʼr ɛsɛ: «Ekʼow akplʼŋ sos ɛm, ke mʼam erur eke mi kʼanŋ ŋ ab!» ");
INSERT INTO adj_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Jesu ɛgŋm, gbɛkↄ li dad ow ninɛ: «Ɛ̀wl im ŋ ecʼagŋ a ogŋ a, ke áwl ów a fɛŋ eke Ɛs Kↄtↄkↄ kok ↄŋʼŋ a, lele sↄrŋ ikŋ e nʼↄny ŋ ecʼab ab a ok ɛl.» ");
INSERT INTO adj_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Ɛgŋ a im, ɛtŋ lʼↄb nuŋ Ɛb Lɛw ab ɛm, nʼam dad ów a fɛŋ eke Jesu kok ↄŋʼn a lʼok agŋ. Ɛtŋ agŋ a fɛŋ low iti any. ");
INSERT INTO adj_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Eke Jesu anŋ mij jam a owr mijɛtŋ ɛm ecʼa, agŋ nↄnↄ gbɛl ow iwr did ɛlul il ɛm mij nɛny yogŋ. ");
INSERT INTO adj_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ɛgŋ nyam eke wɛl bʼɛsŋ Jayirus, Nyam nuŋ igŋ usu a ecʼes ɛw ɛs anŋ ow ɛtŋ eke lʼɛkn Jesu a, lʼok ↄwrↄkp wus ow ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nʼam at lebl es ni ŋↄŋn Jesu li dad lʼɛsɛ: «Ɛm jↄwli am uw. Òw ke átʼr abu nuŋ, yecʼɛtŋ ke li kʼúwm kↄ ke nʼánŋ owr.» ");
INSERT INTO adj_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesu ab -nʼim, ɛtŋ agŋ nↄnↄ a ekʼaam ɛwlʼl a am itarir -lʼul il. ");
INSERT INTO adj_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Bieku na ɛm, yↄw nyam eke bʼub abu ke mebl a ɛdŋm es toŋ ij akpo lɛw yony anŋ. ");
INSERT INTO adj_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Lʼij gbre nↄnↄ gbɛl sos kok ɛsɛl nↄnↄ ecʼabu ɛm. Ni ŋuŋn in ecʼos fɛŋ, kↄ lʼewlm, gbɛkↄ catŋ anake ↄl a am ↄtu yɛjʼa. ");
INSERT INTO adj_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ɛtŋ eke lʼiri Jesu e lís e lʼow a, lʼow lʼɛy dedeku ab ɛm, lʼɛc Jesu jam, ɛtŋ lʼitŋn ow eci mob sus ɛm a abu. ");
INSERT INTO adj_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Ke li dad in ecʼɛrm ɛm ninɛ: «Blel mi kʼitŋn in e mob sus ɛm a abu cɛ, ke mʼewl ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kpɛkŋ lʼɛkn eke mebl a ekʼam okʼr a ɛdŋ es, ɛtŋ lʼɛkan in sosi ɛm eke lʼewl in ecʼↄl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Akr af yogŋ cɛ Jesu uw any eke lɛc nyam ɛy ↄkm in ɛm. Lʼɛdŋ mɛny bieku ab ɛm ɛtŋ nʼam ibrm wɛl li dad lʼɛsɛ: «Kↄ bwo ecʼɛgŋ itŋn ɛm eci mob sus ɛm a abu ee?» ");
INSERT INTO adj_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","In e jam ɛsɛl a am dadʼr ɛsɛ: «Ám ɛkn agŋ nↄnↄ na ekʼam itarir -lʼulʼŋ a, ke ám ibrm ɛgŋ ekʼitŋnʼŋ abu ee?» ");
INSERT INTO adj_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ɛtŋ Jesu am ɛw nyamn in e saw saw a, yecʼɛtŋ ke lʼɛ́kn ɛgŋ a eke kok low na a. ");
INSERT INTO adj_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Yↄw a erŋn am ↄny, nʼam ufŋ, aŋke lʼuw low a ekʼɛŋnʼn ab any. Na sosiɛm lʼow lʼok ↄwrↄkp wus Jesu ecʼany af, ɛtŋ lʼɛgŋ low a lʼeb. ");
INSERT INTO adj_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesu dadʼr ninɛ: «Ɛm jↄw, ŋ ecʼↄmn a ewlmʼŋ! Ìm ɛrm es ɛy ɛm, ke éwl ŋ ecʼↄl ab ɛm gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesu odad anŋ nɛnym am dad ɛtŋ agŋ anŋ Jayirus ogŋ a ow. -Nʼam dad ow -lʼɛsɛ: «Ejↄŋ uw! Kʼìjr low yɛgm agŋ ɛs gbre ↄfr ↄfr.» ");
INSERT INTO adj_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jesu usm ɛl e sodad ebl a jam kↄ li dad Jayirus ninɛ: «Kʼùru erŋn, kↄ ↄny ↄmn sↄny coco cɛ.» ");
INSERT INTO adj_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nʼↄↄm ɛgŋ kaka abusu eke kʼim ɛwlʼl ekʼow elm Piɛr, Jak lele Jan ekʼel Jak lisijim ab cɛ. ");
INSERT INTO adj_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","-Nʼim -lʼok Jayirus ecʼakŋ a; yogŋ, sↄ́g ↄnym nuŋ. Jesu ɛkn ekʼagŋ am ikŋ ↄŋn babarm. ");
INSERT INTO adj_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Lʼɛy akŋ a, ɛtŋ nʼam ibrm wɛl lʼɛsɛ: «Kↄ bla sosiɛm ɛtŋ am ikŋn ↄŋn ↄgr ee? Dedyↄwli a, lʼuwm kↄ mɛmn nʼam ɛru.» ");
INSERT INTO adj_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɛtŋ dedeku a am kokr Jesu miyɛr. Ow sosiɛm lʼogŋ agŋ a fɛŋ ok ↄkm. Gbɛkↄ lʼɛsŋ iy ɛs a, iy lis a, lel in eci jam ɛsɛl agŋ nyahan ab ab, ɛtŋ -lʼok akŋ a eke dedyↄwli a anŋ a. ");
INSERT INTO adj_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Nʼↄny ow abu, ɛtŋ li dad ow ninɛ: «Talita, kum!» (Ow e nyandrɛ el: “Dedyↄwli, mʼam dadʼŋ, ìgb!”) ");
INSERT INTO adj_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kpɛkŋ dedyↄwli a igb ɛtŋ nʼam an es. Ke dedyↄwli a, nʼↄny akpo lɛw yony. Agŋ a fɛŋ ekʼanŋ yogŋ a, low iti any. ");
INSERT INTO adj_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Jesu am dad ɛl lebl tuↄtuↄ ɛm ɛsɛ: «Kì dadr kʼokr ɛgŋ kaka.» Ɛtŋ ɛmɛny lʼigŋ af li dad ninɛ: «Ɔ̀ŋan in ob tɛl lʼij.» ");
INSERT INTO adj_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesu ŋgboŋ yogŋ, ɛtŋ nʼim Nasarɛt baŋn a eke lʼagb a. In eci jam ɛsɛl a im ɛwlʼl. ");
INSERT INTO adj_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Nɛnɛgŋ e lɛgŋ a Jesu am yɛgm agŋ low Nyam nuŋ igŋ usu a. Yogŋ, agŋ nↄnↄ anŋ. Eke -nʼam iri Jesu eci low yɛgm a, low am iti ɛl any ɛtŋ -nʼam dad -lʼɛsɛ: «Kↄ bogŋ low na anŋ owʼr ee? Ɛtŋ bogŋ eci nuŋ ɛm ↄny anake nʼɛŋn ab ee? Ayaf li bʼↄtu li kok sakrowa amua yɛjʼee? ");
INSERT INTO adj_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Kↄ ɛgŋ na ow elm ↄgↄg es ↄdu ɛs ab ee? Mari jim ab ee? Jak, Jose, Jud lele Simↄ ab ecʼɛl lisijim ee? Ɛtŋ kↄ lisijↄwɛl gbɛ irm ɛy ab aŋa ee?» Ów amua fɛŋ ↄ́ↄm Nasarɛt eyŋ abusu eke kʼↄny ↄmn Jesu ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ow sosiɛm li dad wɛl ninɛ: «Usu a fɛŋ wɛl bʼↄny kokoba ↄb ɛs ecʼɛlum, ekʼow elm in ecʼɛb a, in ecʼagŋ ɛm, lel in ecʼakŋ ab cɛ eke wɛl ↄ́nym in ecʼɛlum.» ");
INSERT INTO adj_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jesu ↄtum kokm akrowa kaka Nasarɛt yogŋ, ekʼow elm ↄ́lu bɛb eke lʼat abu nuŋ ke ewl a. ");
INSERT INTO adj_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ɛtŋ ɛb eyŋ a ecʼↄmn ↄnym a e low am atʼr sel. Ɛmɛny Jesu am ɛc baŋn baŋn a ekʼanŋ saw saw yogŋ a, ɛtŋ nʼam yɛgm agŋ low. ");
INSERT INTO adj_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Lʼɛsŋ jam ɛsɛl lɛw yony a, ɛtŋ lʼↄb nuŋ nʼam ɛrm wɛl agŋ yony yony. Nʼↄŋ wɛl abusu abŋ eŋuŋ fɛŋ eci nuŋ af. ");
INSERT INTO adj_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɛtŋ nʼam ijl wɛl nɛny li dad lʼɛsɛ: «Ɔny ecʼejagb us ɛm a, kʼòcr ob kaka ekʼow elm kpama cɛ. Kʼòcr futufutu, kʼòcr ekpr, kʼòcr os kʼánŋ ↄny ekpr ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Òkr cↄkrukpↄ gbɛ, ke ɛ́wal mob sus ɛm nyam cɛ. ");
INSERT INTO adj_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Eke batŋ okr akŋ nyam ɛtŋ agŋ a eb ↄny a, ke ánŋn yogŋ toŋ ↄny eci lɛgŋ a eke kʼimn a ow. ");
INSERT INTO adj_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Eke batŋ usu nyam ecʼagŋ ɛgŋm ebm ↄny, oglog ɛgŋm eke kʼiri ↄny e nɛny ɛm ecʼodad, ke ókr ↄkm yogŋ, cícr ↄny ecʼakr sɛc a okr ɛl es, ke ow íj low ŋuŋ a eke -li kokr a eci daŋku.» ");
INSERT INTO adj_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Jam ɛsɛl a im ɛtŋ -nʼam ↄb ɛrm ɛm itŋn eci kokoba. ");
INSERT INTO adj_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","-Nʼam ogŋ abŋ eŋuŋ nↄnↄ, ɛtŋ -nʼam udu ↄ́lu a mun nuŋ -lʼewlm wɛl. ");
INSERT INTO adj_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Eke Jesu e nin a eb es usu a fɛŋ a, ɛb ebu Erↄd Antipas yɛji iri in e lebl. Wɛl am dad ɛsɛ: «Jan mij ok nuŋ ɛs igb luw ɛm; na sosiɛm anake nʼam ↄny abusu li kok sakrowa a.» ");
INSERT INTO adj_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Bɛb am dad ɛsɛ: «Eli.» Oglog am dad ɛsɛ: «Ɛgŋ na anŋ ɛsɛ kokoba ↄb ɛsɛl esig ab af.» ");
INSERT INTO adj_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ekʼów amua na ok Erↄd ↄru ɛm a, li dad ninɛ: «Jan mij ok nuŋ ɛs a eke mʼↄŋ abusu wɛl ubr nuŋ es a, anake igb luw ɛm a!» ");
INSERT INTO adj_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Kin elel eke Jan mij ok nuŋ ɛs e luw owi a ɛcr. Erↄd Antipas oc lisijim Filip e yↄw Erodiad. Jan im dad Erↄd ninɛ: «Ow itm eke kʼoc esŋ jim e yↄw.» Ɛtŋ ow sosiɛm Erↄd ↄŋ abusu wɛl ↄny Jan ok ŋgbraka ɛlu sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Erodiad ↄny Jan e sifn; nʼam erur eke li kʼibi ow kↄ nʼɛ́ŋnm ow ecʼabusu, ");
INSERT INTO adj_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","aŋke Erↄd bʼↄny Jan eci muru. Tasi ɛm a, li bʼoc ow ɛsɛ ɛgŋ lala af, ɛsɛ low nɛny nyam ɛs af, ɛtŋ li bʼɛw ow ɛrm. Eke batŋ lʼiri Jan ecʼodad, ke ow ám ɛwʼr sel at sos ɛm. Gbɛkↄ li bʼerur eke li kʼiri ow ecʼodad. ");
INSERT INTO adj_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Sica lɛgŋ nyam Erodiad ɛŋn abusu eke kʼibi Jan mij ok nuŋ ɛs a. Ow el Erↄd e mew ecʼes gbɛgbl e lɛgŋ. Erↄd ɛsŋ in eci saw saw e nyimn ɛsɛl a fɛŋ, srↄda eyŋ fandi eci anym ɛsɛl a, lele Galile ecʼagŋ ɛgbɛl ab ab ob ij ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Yogŋ anake Erodiad jↄw ow ɛy ob ij usu a, ke am ub ɛj a. Erↄd lel agŋ a eke lʼɛsŋ ob ij ɛm ab ab erur dedyↄwli a e low. Ɛtŋ Erↄd am dad dedyↄwli a ɛsɛ: «Kↄ bla ob iy am ibrm eke mi kʼↄŋ ee?» ");
INSERT INTO adj_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nʼam ij nɛny li dad lʼɛsɛ: «Ìbrm im ob fɛŋ ekʼam erur a, mʼow mʼↄŋ. Ekʼow el ɛm ecʼes ɛw a eci likpr bↄbↄ yɛji, mʼow mʼↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kpɛkŋ yↄwli a uru es im dad ok lis ninɛ: «Ɛm lis, kↄ bla ob iy mi kʼibrm ee?» Lis dadʼr ninɛ: «Ìbrm Jan mij ok nuŋ ɛs e nuŋ a.» ");
INSERT INTO adj_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Kpɛkŋ dedyↄwli a ogŋ es im ɛb ebu a ogŋ a, ɛtŋ li dad ow ninɛ: «Ìsʼm sicaca Jan mij ok nuŋ ɛs a eci nuŋ a wayas ɛm!» ");
INSERT INTO adj_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ɛb ebu a sos ↄw es amani a eke lʼiri a eci, gbɛkↄ li kʼↄtum lʼↄwrm sar ij, nɛny a eke lʼij lele agŋ a eke ok es ab ab sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kpɛkŋ nʼↄŋ usu ↄsu ɛsɛl ab ɛm ecʼɛgŋ nyam abusu eke kʼim ubr Jan nuŋ es. Nʼim sobel ɛm yogŋ, ɛtŋ lʼubr ow nuŋ es. ");
INSERT INTO adj_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Lʼoc lʼow nʼↄŋ dedyↄwli a, ɛtŋ ow oc im ↄŋ lis. ");
INSERT INTO adj_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Eke Jan eci jam ɛsɛl a bʼiri low na a, -lʼow, ɛtŋ -lʼoc ow eci sos megl a -nʼim -lʼoc es. ");
INSERT INTO adj_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","31","Ɛrm ɛsɛl a eke Jesu ɛrm a, ɛwl ow ɛtŋ eke -lʼokr es Jesu ab a, -nʼam ↄb juma a fɛŋ eke -li kokr a lele low a eke -li yɛgmn agŋ ab ab a ecʼamani -lʼok ow. Eke -nʼam dad ow odad a, agŋ nↄnↄ am ow ɛtŋ am ɛwl toŋ -nʼↄnymn abusu kaka fɛŋ eke -li kʼij ob; ɛtŋ Jesu dad in e jam ɛsɛl a ninɛ: «Òwr sʼímn saw ɛm aŋa, bake ébr sel tɛl.» ");
INSERT INTO adj_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ɛl sↄny -lʼok mijɛtŋ ɛm -nʼaam usu saw ɛm ekʼirm es. ");
INSERT INTO adj_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ɛl ecʼim ɛm a, agŋ ɛkn ɛl, ɛtŋ lʼuw any ekʼow el Jesu lele in eci jam ɛsɛl ab ab anake aam a. Kpɛkŋ agŋ amua anŋ baŋn a ogŋ es ikŋ anym im ok usu a eke -nʼaam a. ");
INSERT INTO adj_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Mijɛtŋ a bʼitr es eke Jesu bʼus es a, lʼɛkn agŋ nↄnↄ ekʼok es ɛsɛ mɛcɛb ekʼↄnym ↄsu ɛs af, ɛtŋ ɛl owi ↄnyʼn sↄrŋ. Ow sosiɛm, nʼam yɛgm wɛl ów nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Eke lɛgŋ ɛc a, jam ɛsɛl a ow ɛŋn Jesu ɛtŋ am dadʼr ɛsɛ: «Lɛgŋ ɛc, ɛtŋ usu na yɛji ɛw usu saw ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Òk agŋ ab es ím sikpukpu a lele baŋn baŋn ekʼanŋ saw saw aŋa ab ab ɛm yecʼɛtŋ ke -lʼↄl ob ij.» ");
INSERT INTO adj_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jesu dad ɛl ninɛ: «Ɔny obi, ↄŋn ɛl ob -lʼij!» -Li dad ow ninɛ: «Kↄ futufutu os ekŋ lɛw si kʼim sʼↄl sʼow sʼↄŋ ɛl -lʼij ee?» ");
INSERT INTO adj_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Li dad wɛl ninɛ: «Ìmn ɛkan! Kↄ futufutu abi anŋ ↄny ee?» -Nʼim -lʼibrm ɛtŋ -lʼɛwl mɛny -lʼow -li dad ninɛ: «Futufutu yen lele ↄcn yony ab cɛ anŋ.» ");
INSERT INTO adj_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Li dad jam ɛsɛl a eke kʼↄŋ agŋ a ok es eku ɛm eku ɛm suw owr ab af. ");
INSERT INTO adj_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","-Nʼↄŋ agŋ a ok es sɛrŋ ɛm sɛrŋ ɛm. Bɛb ok es ekŋ yen yen, oglog ok es ekŋ yony lele lɛw lɛw ab. ");
INSERT INTO adj_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Jesu oc futufutu yen a lele ↄcn yony ab ab, lʼigbl any ogŋ afr, ɛtŋ lʼɛlu Nyam bia. Li bubr ɛm nʼↄŋ in e jam ɛsɛl a eke ki cɛc ↄŋ agŋ a. Li cɛc wɛl ↄcn yony a yɛji. ");
INSERT INTO adj_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Agŋ a fɛŋ ij ob a lok iy. ");
INSERT INTO adj_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jam ɛsɛl a ot ekpr a eke wal es a as luku ɛtŋ ow iy mulu lɛw yony. ");
INSERT INTO adj_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Agŋ a fɛŋ ekʼij ob a, egŋ fandi yen anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Kpɛkŋ eke low na ɛy oc es a, Jesu ↄŋ in e jam ɛsɛl a ok mijɛtŋ ab ɛm eke kʼikŋ anym im mij lekpl a e jam a, Bɛtsayida ɛb ogog a, ke nʼánŋ in obi lʼafl bieku ab es. ");
INSERT INTO adj_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Eke lʼɛlu wɛl es a, lʼuyu lafɛny ab af eke li ki ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Eke lɛgŋ am uk a, jam ɛsɛl a anŋ mijɛtŋ ab ɛm, mij araŋn yogŋ, ɛtŋ Jesu anŋ ákpaf a. ");
INSERT INTO adj_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jesu ɛkn eke jam ɛsɛl a am ij gbre mij ↄr ab ɛm, aŋke lɛf am ɛlu ↄbr ɛl. Eke lɛgŋ am ɛny ow a, Jesu am an es mij ab af im ɛŋn ɛl, nʼam ↄl eke li kʼafŋ wɛl es. ");
INSERT INTO adj_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","-Lʼɛkn ow ekʼow am an es mij ab af ow; -li tutr ekʼow el ↄŋnabŋ, ɛtŋ -nʼam babarm. ");
INSERT INTO adj_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ɛl fɛŋ -lʼɛkn ow ɛtŋ -li kpikprm es. Kpɛkŋ Jesu dad ɛl ninɛ: «Ɛrm úsu ↄny lokm! Erŋn kʼↄ́ny ↄny! Kↄ ɛm!» ");
INSERT INTO adj_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Lʼɛy mijɛtŋ ab ɛm li sig wɛl es ɛm, ɛtŋ lɛf a irm es. Jam ɛsɛl a low iti any toŋ afŋn es, ");
INSERT INTO adj_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","aŋke akrowa a ekʼɛy futufutu a eci cɛc ɛm a, -lʼirim ow okm ɛl es sos ɛm, ɛl ecʼɛrm tuↄtuↄ a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Eke Jesu lel in eci jam ɛsɛl ab ab ubr mij lekpl a e jam a, -nʼim -lʼok Genesarɛt ɛb ɛm. -Lʼitr mijɛtŋ ab es, ɛtŋ -lʼus es. ");
INSERT INTO adj_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Ɛl ecʼes us ɛm a, kpɛkŋ agŋ uw Jesu any, ");
INSERT INTO adj_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","-lʼɛwl amani a wus ikpr a nimum af ɛtŋ agŋ ot ɛl ecʼↄ́lu ogo af am ow yogŋ a eke -lʼirir eke Jesu anŋ a. ");
INSERT INTO adj_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Usu a fɛŋ eke Jesu am ɛy a, ke ow el baŋn gbɛl ɛm o, ke ow el baŋn likekli ɛm o, ke ow el kpukpu ɛm o, agŋ am ot ↄ́lu ow ɛjɛm araŋn. -Nʼam ŋↄŋn ow eke ow ki yɛb wɛl itŋn in e mob sus ɛm a ecʼɛnyɛmbri a cɛ abu, ɛtŋ agŋ a fɛŋ ekʼam itŋn mob sus ɛm a abu a, am ewl. ");
INSERT INTO adj_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ca Farisiɛl lel ol e low yɛgm ɛsɛl bɛb ekʼanŋ Jerusalɛm ow ab ab, iwr did ɛlul Jesu ɛm. ");
INSERT INTO adj_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","-Lʼɛbmn nyamn eke Jesu e jam ɛsɛl ab ɛm ecʼagŋ bɛb yↄgm sabu ɛsɛ elel eke ɛl ecʼɛb ir a am ibrm ab af, ɛtŋ -nʼam ij ob. ");
INSERT INTO adj_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ke tasi ɛm a, Farisiɛl lele Jwifɛl bɛb ab ogŋ a, eke yↄgm abu, kʼↄtum ijm ob; aŋke -li bʼucu ɛl agŋiyɛl ecʼɛb ir owi amua -nʼↄny es. ");
INSERT INTO adj_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Na sosiɛm, eke -nʼanŋ an ↄl usu batŋ -lʼow gbugŋ, -lʼijmn ob eke -lʼakprm mij sos. Ɛtŋ ɛmɛny -nʼↄny agŋ ɛm ecʼɛb ir owi nↄnↄ yɛjʼeke -li bʼↄsu ɛsɛ mij kpↄk, ob ijr kpokpo lele sijↄwrɛ ab ecʼelel eke wɛl kʼɛtŋn es ab af. ");
INSERT INTO adj_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ow sosiɛm Farisiɛl a lel ol e low yɛgm ɛsɛl ab ab am ibrm Jesu ɛsɛ: «Kↄ bla ɛtŋ ɛy lagŋɛl ecʼɛb ir owi a ekʼↄŋ ɛy a, ŋ e jam ɛsɛl a ɛ́luam ee? -Li bʼot sabu ekʼaylm -nʼam ijr ob.» ");
INSERT INTO adj_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesu am dad ɛl ɛsɛ: «Ɔny, agŋ ɛnyɛmbri yony yony ɛsɛl! Nawrɛ tasi, Esayi dad ↄny e lís e low in e kokoba ↄb ab ɛm: Nyam dad eke agŋ amua na nɛny ɛm ↄfr ↄfr -nʼam kↄklm im, kↄ ɛl ecʼɛrm a kpab es ɛm e lís. ");
INSERT INTO adj_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Nuŋ ↄfr ↄfr agŋ amua am igŋʼm, aŋke agŋ ɛm ecʼów anake -li bʼoc -nʼam yɛgmn agŋ low a.» ");
INSERT INTO adj_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɛtŋ ɛmɛny Jesu usr af dad ninɛ: «Ɔny bi waal Nyam ecʼol a ecʼów a ɛlul es, ɛtŋ bʼucur agŋ ɛm ecʼa ↄnyn es.» ");
INSERT INTO adj_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ɛtŋ ɛmɛny lʼigŋ af ninɛ: «Ɔny, ↄnyn nyandrɛ nↄnↄ ekʼow ɛm bʼigŋn Nyam e sol a okr es, ke bʼucur ↄny ecʼagŋ ɛm ecʼa ↄnyn es! ");
INSERT INTO adj_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Tasi ɛm a, Mois dad ninɛ: “Ɛ̀lum asŋ lel esŋ ab.” Ɛtŋ lʼusr af ninɛ: “Ɛgŋ eke yayr ɛs lele lis ab a, lʼit eke wɛl kʼibiʼr.” ");
INSERT INTO adj_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ɛtŋ ↄny, ↄny e low yɛgm ab ɛm bi dadr ɛsrɛ, ekʼɛgŋ nyam in dad ow ɛs oglog ow lis in ɛsɛ: “Ob a eke mi kʼↄŋʼŋ ŋ eci abu ɛlum ecʼa, ob a el Kↄrban” (ow e nyandrɛ el, ob eke wɛl oc ɛw es Nyam ecʼegb wawr ↄŋ eci), ");
INSERT INTO adj_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ↄny bʼɛlul abusu es ekʼɛgŋ ikŋ na, kí kokm low kaka ↄↄm ɛs lele lis ab ij. ");
INSERT INTO adj_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ɛbɛn anake ↄny, bʼↄnyn Nyam ecʼów ekʼɛlu abusu es eke wɛl ki kok a otr es, ke bʼucur ↄny ecʼagŋ ɛm ecʼa ekʼirir a ↄnyn es a. Ɛtŋ ↄnyn ów bubutɛ gbɛl e bi kokr ɛsɛ low ikŋ na af.» ");
INSERT INTO adj_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ɛmɛny Jesu ɛsŋ agŋ a ɛtŋ am dad ɛl ɛsɛ: «Ìgŋn lↄru es ↄny fɛŋ kʼírir. ");
INSERT INTO adj_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ow elm ob ekʼɛgŋ bʼij ok lokm a, ↄↄmʼn lʼuwm anŋ, kↄ ów tutr eke bʼanŋ in ecʼɛrm ɛm ɛy ↄkm a anake bʼↄŋʼn lʼuwm anŋ a. ");
INSERT INTO adj_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ke ɛgŋ fɛŋ ekʼↄny ↄru eke kʼiri a, íri gↄŋ!» ");
INSERT INTO adj_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Eke Jesu ɛlu agŋ ab es im ɛy akŋ a, in e jam ɛsɛl a im ɛŋnʼn ɛtŋ am ibrmʼn ɛsɛ: «Òtar nyandrɛ a ekʼub a e low akr òk ɛy!» ");
INSERT INTO adj_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ɛtŋ nʼam dad wɛl lʼɛsɛ: «Kↄ ↄny yɛji kʼↄtumn kʼirimn low na eci nyandrɛ ee? Uwmn any ekʼow elm ob ekʼɛgŋ bʼij ok lokm a, kʼↄtum ↄↄmʼn lʼuwm anŋ, ");
INSERT INTO adj_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","kↄ ów tutr eke bʼanŋ in ecʼɛrm ɛm ɛy ↄkm a anake bʼↄŋʼn ke lʼuwm anŋ ab ee? Aŋke ob e li bʼij lʼok sos ɛm a, lokm ow bʼokʼr kↄ ow elm ɛrm ɛm, ɛtŋ li bʼiny lʼok es.» (Odad ebl na ɛm a, Jesu am yɛgm ekʼob fɛŋ akpl iju.) ");
INSERT INTO adj_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ɛtŋ ɛmɛny Jesu dad ninɛ: «Ów tutr eke bʼanŋ ɛgŋ ɛm ɛy ↄkm a bʼↄŋ ɛtŋ lʼuwm anŋ. ");
INSERT INTO adj_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Tasi ɛm a, ɛgŋ ecʼɛrm ɛm anake sow tutr eŋuŋ a fɛŋ bʼanŋ, ke bʼↄŋʼn lʼij nfaci, lʼiy mil, lʼibi ɛgŋ, ");
INSERT INTO adj_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","lʼɛrum yↄw ɛjecʼab, lʼerur lawl ecʼob; li kok low ŋuŋ, lʼɛju ɛgŋ, li wuwlm ów ab, nʼↄnyn ɛgŋ nyamn ɛyr, li cak cak ɛgŋ, nʼↄny tutre, ke lʼij nyamb a. ");
INSERT INTO adj_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ów amua fɛŋ eke bʼanŋ ɛgŋ ecʼɛrm ɛm ok ↄkm a, anake bʼↄŋ ke lʼuwm anŋ a.» ");
INSERT INTO adj_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jesu ŋgboŋ yogŋ a e nʼanŋ a, ɛtŋ nʼim lʼɛy wus ikpr a eke titm Tir ab af. Eke lʼɛy akŋ nyam a, lʼerurm eke wɛl kʼuw any eke lʼow nʼanŋ yogŋ, gbɛkↄ ow ibnm ɛtŋ amani a eb es eke Jesu in ow aŋa. ");
INSERT INTO adj_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Yↄw nyam ekʼin ecʼiy yↄwli ↄny abŋ ŋuŋ a, iri eke Jesu ow anŋ ɛb ab ɛm. Lʼow nʼɛŋn ow ɛtŋ lʼok ↄwrↄkp wus ow ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Yↄw a elm Jwif, wɛl ewʼr Fenisi ɛb ɛm, Siri wus af. Nʼam ŋↄŋn Jesu eke kʼogŋ abŋ ŋuŋ ekʼanŋ jↄwli ab ɛm a ɛlu ↄkm. ");
INSERT INTO adj_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Kↄ Jesu dadʼr ninɛ: «Yɛ̀b, wɛl ↄ́ŋ etuey ob ij yɛ aŋke ow itm eke wɛl kʼoc ɛl ecʼob ij a ↄŋ mↄwr ey.» ");
INSERT INTO adj_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Yↄw a ↄdu eb ɛtŋ dad ninɛ: «Ɛgŋ gbɛl, nawrɛ tasi dad. Gbɛkↄ mↄwr ey eke bʼanŋ tabl ew a, bʼij etuey ecʼob eke bʼakm ɛl ok wus a.» ");
INSERT INTO adj_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesu dadʼr ninɛ: «Low na eke dad a sosiɛm, ↄtu eke kʼim gbugŋ. Abŋ ŋuŋ a ɛy ↄkm ŋ ecʼiy ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Yↄw a im gbugŋ ɛtŋ ɛŋn in ecʼiy a ekʼɛru es ob ɛrur ob af, ɛtŋ lʼɛkn yɛji eke abŋ ŋuŋ a ɛy ↄkm ow ɛm. ");
INSERT INTO adj_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Sica Jesu ŋgboŋ Tir eci wus ab af, ɛcr Sidↄn eci, ubr Ɛb Lɛw a e wus ab af, im ok Galile e mij a ogŋ a. ");
INSERT INTO adj_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Agŋ oc ɛgŋ nyam ekʼↄru abl ke ↄ́tum dadm odad okm es a is Jesu, ɛtŋ am ŋↄŋnʼn eke li kʼat ow abu nuŋ. ");
INSERT INTO adj_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesu ɛlu bieku ab es, oc ↄlu a im saw ɛm. Lʼot sabu ey lʼok ow ↄru ɛm, ɛtŋ lʼoc in e sar nɛnym a lʼudu ow anm. ");
INSERT INTO adj_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sica Jesu igbl any ogŋ afr, bubm sel ok ɛtŋ dad ɛgŋ a ninɛ: «Efata!» (Ow e nyandrɛ el “Fìg!”) ");
INSERT INTO adj_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kpɛkŋ ɛgŋ a am iri ów, anm kpabʼr es nɛnym ɛtŋ lʼↄb nuŋ nʼam dad odad sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesu ijl agŋ a nɛny dad ninɛ: «Kì dadr low na kʼòkr ɛgŋ kaka!» Sica eke li bʼijl wɛl nɛny eke wɛl kí dadm a, yogŋ anake agŋ a yɛji, bʼim am ↄb low a ecʼamani a. ");
INSERT INTO adj_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Agŋ a fɛŋ anŋ low any iti ligbɛl ɛm toŋ am dad ɛsɛ: «Fɛŋ eke li bi kok a bʼel ów amamn ↄfr. Li bi kok ↄ́ru ablu am iri ów ɛtŋ ɛl a ekʼↄ́tum dadm odad a, yɛji bi dad ów.» ");
INSERT INTO adj_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Lɛgŋ ab ɛm, ɛmɛny agŋ nↄnↄ gbɛl ow iwr did ɛlul Jesu ɛm. Eke -nʼↄnym ob kaka eke -li kʼij a, Jesu ɛsŋ in e jam ɛsɛl a, ɛtŋ dad ɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","«Agŋ amua e low am ↄnyʼm sↄrŋ, aŋke kin sɛgŋ emum nyahan ɛtŋ eke -nʼanŋn ɛm ab ke -nʼↄnym ob kaka eke -li kʼij. ");
INSERT INTO adj_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Eke mʼam ɛlu ɛl es -nʼim namn, -li kʼow -nʼↄnymn lɛc ɛl ecʼejagb us ɛm, aŋke ɛl ɛm ecʼagŋ nyam nyam anŋ susu kpekpe ow.» ");
INSERT INTO adj_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","In e jam ɛsɛl a am dadʼr ɛsɛ: «Ɛtŋ sica bogŋ si kʼɛŋn ob ij sʼↄŋ ɛl usu saw ɛm na ekʼɛgŋ irm ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesu ibrm ɛl ninɛ: «Kↄ futufutu abi ↄnymn ab ee?» Ɛtŋ jam ɛsɛl a dad ninɛ: «Lↄbŋ.» ");
INSERT INTO adj_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Sica Jesu ↄŋ abusu eke dedeku a kʼok es wus. Lʼot futufutu lↄbŋ a, lʼɛlu Nyam bia, li bubr ɛm, ɛtŋ nʼↄŋ in e jam ɛsɛl a eke ki cɛc dedeku a. Ɛtŋ jam ɛsɛl a cɛc ↄŋ ɛl fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","-Nʼↄnym ↄcn abi ka ab. Jesu oc yeci yɛji ɛlu Nyam bia ɛtŋ ↄŋ jam ɛsɛl a eke ki cɛc ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Agŋ a ij ob molok iy ɛl toŋ ob wawal es. Jam ɛsɛl a ɛc ot ob a fɛŋ eke wal es a ɛtŋ ow ij mulu ɛgbɛl lↄbŋ. ");
INSERT INTO adj_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Agŋ a fɛŋ ekʼij ob a, ↄtu eke kʼij agŋ fandi yar. Sica Jesu ↄŋ ɛl abusu eke -li kʼim, ");
INSERT INTO adj_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ɛtŋ kpɛkŋ in lel in e jam ɛsɛl ab ab -lʼok mijɛtŋ ab ɛm -nʼim Dalmanuta eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Farisiɛl ow ɛŋn Jesu ɛtŋ am atar ów es in ab. Eke -lʼerurir eke -li kʼuk ow meb a sosiɛm, -li dad ow ninɛ: «Kòk mɛny ɛwr nyam ↄŋ ɛy yecʼɛtŋ ke sʼúw any tasi ekʼow el Nyam ɛrmʼŋ ow.» ");
INSERT INTO adj_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesu bubm sel ok ɛtŋ dad ninɛ: «Bla sosiɛm ɛtŋ yɛfɛnyna ecʼagŋ amua am ibrm eke kʼɛkn mɛny ɛwr ee? Mʼam dad ↄny nawrɛ ɛm tasi: wɛl kʼow kokm mɛny ɛwr kaka ↄↄm ↄny.» ");
INSERT INTO adj_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ɛtŋ lʼɛlu wɛl es, lʼɛy mijɛtŋ ab ɛm lʼubr mij jam a. ");
INSERT INTO adj_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Eke -nʼim a, jam ɛsɛl a ijl es eke kʼeb futufutu, ekʼow elm futufutu nyam a cɛ eke -nʼↄnymn ab mijɛtŋ ab ɛm a. ");
INSERT INTO adj_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesu am ijl ɛl nɛny dad ɛsɛ: «Ɛ̀wr ɛrm! Ke ↄ́sur sos Farisiɛl lele Erↄd ab e lijru a e lís.» ");
INSERT INTO adj_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Jam ɛsɛl a ekʼiri low na a am dadarir ɛl ↄfr ɛm ɛsɛ: «Eke sʼebm futufutu a sosiɛm anake nʼam dad ɛy ów amua a.» ");
INSERT INTO adj_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Eke Jesu iri ów a eke -nʼam dadarir ɛl ↄfr ɛm a, nʼam dad wɛl lʼɛsɛ: «Kↄ bla sosiɛm ɛtŋ am dadr ɛsrɛ: “Eke sʼebm futufutu a sosiɛm ee?” Kↄ kʼirimn cɛ ee? Kↄ ow kʼokm ↄny es sos ɛm cɛ ee? Kↄ ↄny ecʼɛrm tuↄtuↄ a sosiɛm ee? ");
INSERT INTO adj_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","19","Ɔny ɛlil anyamn ɛtŋ ɛ́knmn es ee? Ɛlil ↄru ɛtŋ írimn ów ee? Kʼↄknmn lɛgŋ a eke mʼubr futufutu yen ɛm mʼↄŋ agŋ fandi yen a ij a, ow a ekʼakm ɛl a, mulu abi anake ɛcr otr ab ee?» -Li dad ninɛ: «Lɛw yony.» ");
INSERT INTO adj_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ɛmɛny lʼibrm wɛl ninɛ: «Lɛgŋ a eke mʼubr futufutu lↄbŋ ab ɛm mʼↄŋ agŋ fandi yar a ij a, ow a ekʼakm ɛl a, mulu abi anake ɛc otr ab ee?» -Li dad ninɛ: «Lↄbŋ.» ");
INSERT INTO adj_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ɛtŋ Jesu usr af dad ɛl ninɛ: «Ɛtŋ ɛmɛny sica kʼirimn ow kʼokm ↄny es sos ɛm cɛ ee?» ");
INSERT INTO adj_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jesu lel in e jam ɛsɛl ab ab im ok Bɛtsayida. Yogŋ agŋ oc any eflu nyam ow ɛtŋ am ŋↄŋnʼn eke li kʼitŋn ow abu. ");
INSERT INTO adj_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Jesu ucu any eflu a abu ↄny ɛtŋ ocʼr ab im baŋn saw a. Yogŋ lʼoc sar lʼubr ow anyamn ɛm, lʼok ow sabu any ɛtŋ lʼibrm ow ninɛ: «Kↄ am ɛkn es ee?» ");
INSERT INTO adj_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Any eflu a fifig anyamn ɛtŋ dad ninɛ: «Mʼam ɛkn agŋ ekʼam an es, gbɛkↄ mʼam ɛkn ɛl ɛsɛ ekŋ af.» ");
INSERT INTO adj_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ɛmɛny Jesu okʼr sabu any ɛtŋ nʼam ɛkn es sɛnyn sɛnyn. Sica lʼewl tasi ɛtŋ nʼam ɛkn ob fɛŋ ɛsɛ elel ekʼow it ab af. ");
INSERT INTO adj_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ɛtŋ Jesu dadʼr ninɛ: «Èb ejagb im gbugŋ; kↄ kʼↄ̀kŋ any kpɛkŋ kpɛkŋ kʼim kʼɛy agŋ ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ow e jam a, Jesu lel in e jam ɛsɛl ab ab us ejagb aam baŋn baŋn a ekʼanŋ Sesare Filip eci wus ab af a. Eke -nʼanŋn ejagb -nʼaam a, Jesu ibrm in e jam ɛsɛl a ninɛ: «Kↄ ayaf agŋ bi dadr ɛm e lís ee?» ");
INSERT INTO adj_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","-Li dad ow ninɛ: «Agŋ bɛb bi dad ɛsɛ ŋ Jan mij ok nuŋ ɛs, bɛb bi dad ɛsɛ ŋ Eli, ɛtŋ agŋ likpr ecʼa, -li bʼocʼŋ ɛsɛ kokoba ↄb ɛsɛl ab ɛm e nyam af.» ");
INSERT INTO adj_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ɛtŋ Jesu ibrm ɛl ninɛ: «Kↄ ↄny obi ↄny obi a, ayaf bʼocarʼm ee?» Piɛr ↄdu eb dad ninɛ: «Ŋ el Mesi a.» ");
INSERT INTO adj_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Jesu ijl ɛl nɛny kpoŋ kpoŋ eke -li ki dadmn in e lís e low -lʼokmn ɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesu am yɛgm in e jam ɛsɛl a low dad ɛl ɛsɛ: «Ow it ekʼɛgŋ ecʼIy kʼij gbre nↄnↄ; ke agŋ ekpekp, egb waw ɛsɛl ɛgbɛl lel ol e low yɛgm ɛsɛl ab ígŋ ɛluʼl es, ↄ́ŋ wɛl ibiʼr ke sɛgŋ nyahan, lʼígb agŋ ekʼuw ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nʼam dad wɛl sodad amua lʼɛrum mar. Na sosiɛm Piɛr ocʼr ab im saw ɛm ɛtŋ am ɛnymʼn abr dadʼr ɛsɛ: «Kì dad odad nɛnɛ.» ");
INSERT INTO adj_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Eke Jesu ɛwl mɛny lɛr in e jam ɛsɛl a, li dad Piɛr lebl tuↄtuↄ ɛm ninɛ: «Satan, kpàbʼm es lís, aŋke ŋ e tutr a elm Nyam e tutr, kↄ na agŋ ɛm e tutr.» ");
INSERT INTO adj_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Eke Jesu ɛsŋ dedeku a lel in e jam ɛsɛl ab ab a, nʼam dad wɛl lʼɛsɛ: «Ekʼɛgŋ nyam am erur eke kʼusʼm jam a, ow it ke li kí tutrm in e lís owi, lʼábu in obi ecʼolikŋ a ke lʼúsʼm jam. ");
INSERT INTO adj_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Tasi ɛm a, ɛgŋ yecʼeke bʼow erur eke ki dogŋn in e sel a, bʼow irmn. Gbɛkↄ ɛgŋ yecʼeke bʼow irmn in e sel a Amani Mamn a lel ɛm sosiɛm ab a, bʼow ɛŋn. ");
INSERT INTO adj_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Eke batŋ ɛgŋ nyam ↄny wus ecʼob fɛŋ ɛtŋ lʼirmn in e sel a, ke bla ow bʼow eel il ab ee? ");
INSERT INTO adj_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ɛtŋ bla ob iy ɛgŋ ↄtu eke kʼoc sↄgr in e sel ab ee? ");
INSERT INTO adj_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Yɛfɛnyna ecʼagŋ amua el sikpl ɛsɛl lel ɛnyɛmbri yony yony ɛsɛl ab Nyam ecʼany af. Ekʼɛgŋ nyam ɛ́s am ↄny ɛm lel ɛm e sodad ebl ab ab sosiɛm agŋ amua ecʼaraŋn, ɛbɛn cɛ ɛgŋ ecʼIy yɛji ɛ́s bʼow ↄny, lɛgŋ eke li bʼow lʼow Ɛs ecʼanygbɛl ɛm, afr ɛrm ɛsɛl lala ab ab a.» ");
INSERT INTO adj_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ɛmɛny Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: agŋ amua ekʼanŋ aŋa a e bɛb bʼow ɛkn Nyam ecʼes ɛw a ow abusu ↄny ɛm gbuŋ ke -lʼuw.» ");
INSERT INTO adj_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Eke sɛgŋ nↄhↄn ɛc a, Jesu ɛsŋ Piɛr, Jak lele Jan ab ɛtŋ -li kpab es -nʼim saw ɛm ɛl sↄny lafɛny gege nyam af. Yogŋ, Jesu itŋn sos ɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","In eci mob sus ɛm a e jɛjn a afŋn es; wus af aŋa, ɛgŋ kaka anm eke kʼↄŋ in eci mob sus ɛm a jɛjn ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Ɛtŋ kpɛkŋ Eli lele Mois ab okm sos ↄkm ɛtŋ am dad ów Jesu ab. ");
INSERT INTO adj_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Eke Piɛr bʼɛkn ɛbɛn a, li dad Jesu ninɛ: «Low yɛgm agŋ ɛs, ow akpl eke si kʼanŋ aŋa! Sʼús nuŋ igŋ usu nyahan: ŋ e nyam, Mois e nyam lel Eli e nyam ab.» ");
INSERT INTO adj_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Tasi ɛm a, Piɛr ɛknm odad eke ki dad aŋke ɛl nyahan mum erŋn am ↄny ɛl. ");
INSERT INTO adj_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kpɛkŋ jru ɛy ɛtŋ ubur ɛl es. Ɛtŋ lebl nyam anŋ jru ab ɛm am ikŋ dad ɛsɛ: «Ɛgŋ na el ɛm ecʼIy eke mʼerur tasi; ìrir in e low.» ");
INSERT INTO adj_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kpɛkŋ jam ɛsɛl a am ↄl saw saw, gbɛkↄ -lʼɛknm ɛgŋ kaka ekʼow elm Jesu sↄny cɛ ekʼanŋ ɛl ab a. ");
INSERT INTO adj_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Eke -nʼanŋn lafɛny ab af -nʼam us es a, Jesu ijl ɛl nɛny dad ninɛ: «Low na ekʼɛkan a, kì dadr kʼokr ɛgŋ kaka, toŋ bake ɛgŋ ecʼIy ígb agŋ ekʼuw ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","-Lʼɛgŋ low a -lʼeb, gbɛkↄ -nʼam ibrmnin ɛl ↄfr -lʼɛsɛ: «Ke ɛgŋ ecʼIy ígb agŋ ekʼuw ab ɛm e nyandrɛ el ayaf ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ɛmɛny jam ɛsɛl a am ibrm Jesu ɛsɛ: «Dàd ɛy, kↄ bla sosiɛm ɛtŋ ol e low yɛgm ɛsɛl a bi dad ekʼEli in kʼow gbuŋ ke Mesi a in ów ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jesu dad ɛl ninɛ: «Ɛɛ, Eli eke li kʼow ke ni nyímn ów a fɛŋ. Gbɛkↄ bla sosiɛm Nyam Lɛl ɛm wɛl nↄn ekʼɛgŋ ecʼIy bʼow ij gbre nↄnↄ ke wɛl kʼúbmʼn ee? ");
INSERT INTO adj_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mʼam dad ↄny ekʼEli ecʼa, lʼow lɛgŋ a ɛtŋ, ɛtŋ agŋ kokʼr low yecʼa eke -lʼerurir a ɛsɛ elel eke wɛl nↄn ab af.» ");
INSERT INTO adj_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Eke -lʼowr -nʼɛŋan jam ɛsɛl likpr a, -lʼɛkn dedeku ekʼɛlul wɛl ɛm, ɛtŋ wɛl am atar ów es ol e low yɛgm ɛsɛl ab ab. ");
INSERT INTO adj_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Eke dedeku a bʼɛkn Jesu a, low iti ɛl any ɛtŋ kpɛkŋ -nʼam uru es -nʼim -lʼɛsŋn ow. ");
INSERT INTO adj_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jesu ibrm jam ɛsɛl a ninɛ: «Kↄ bla owi am atarir es ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Dedeku ab ɛm a, ɛgŋ nyam ↄdu eb dad ninɛ: «Low yɛgm agŋ ɛs, mʼoc ɛm jim ekʼↄny abŋ ŋuŋ ke ↄↄmʼn li dadm odad a mʼisʼŋ. ");
INSERT INTO adj_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Usu kaka fɛŋ ekʼabŋ na bʼɛyʼr af a, ow bʼↄny ɛluʼl ow wus, sar ufu ám iflʼl nɛny, nʼám sasagr an ɛm, ke nʼám ɛcan es. Mi dad ŋ e jam ɛsɛl a eke kʼogŋ abŋ ikŋ na in ɛm, ɛtŋ -lʼↄtum -nʼↄnym ow ecʼabusu.» ");
INSERT INTO adj_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesu dad in e jam ɛsɛl a ninɛ: «Ɔny tasi, eel agŋ eke ↄmn anm ɛm! Ɛmɛny sɛgŋ abi mʼit eke mi kʼanŋ ↄny ab ee? Ɛtŋ ɛmɛny sakp abi ow it eke mi kʼɛgŋ low na mʼeb ee? Òcr iy a isrʼm aŋa!» ");
INSERT INTO adj_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wɛl oc iy a isʼr. Ekʼabŋ ŋuŋ a bʼɛkn Jesu a, lʼufŋ iy a lɛc ɛm, nʼↄny lʼɛlu ow wus. Iy a am wuwl wus yogŋ ɛtŋ sar ufu am iflʼl nɛny. ");
INSERT INTO adj_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesu ibrm iy ɛs a ninɛ: «Kↄ ow ij sɛgŋ abi ekʼabŋ ŋuŋ na anŋʼn af ee?» Iy ɛs a dad ninɛ: «In e likekli ɛm ɛtŋ. ");
INSERT INTO adj_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Sakp oglog abŋ a bʼↄny ɛluʼl alm, oglog mij ɛm eke kʼibiʼr. Ekʼↄtu e ki kok, ìkŋ ɛy sↄrŋ ke ɛ́lum ɛy abu!» ");
INSERT INTO adj_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesu am dadʼr ɛsɛ: «Kↄ bla ɛtŋ am dad ɛsɛ: “Ekʼↄtu e ki kok ee?” Wɛl ↄtu eke ki kok low low fɛŋ ɛgŋ eke bʼↄny ↄmn a eci.» ");
INSERT INTO adj_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Kpɛkŋ iy ɛs a igbl lebl ogŋ ɛtŋ am dad ɛsɛ: «Mʼub nawrɛ! Ɛ̀lum im abu ke ɛm ecʼↄmn ↄnym a óc es ɛm ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Eke Jesu ɛkn agŋ a ekʼam uru ow a, lʼoc lebl tuↄtuↄ ɛm nʼam dad abŋ ŋuŋ a lʼɛsɛ: «Abŋ eke bʼↄŋ ɛgŋ el ɛbrm lel ↄru ablu ab, mʼam dadʼŋ: ɛ̀y ↄkm iy na ɛm, kʼɛ̀wl mɛny kʼow in ɛm ij!» ");
INSERT INTO adj_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Abŋ ŋuŋ a babarm, ufŋ iy a lɛc ɛm ɛtŋ lʼɛy ↄkm. Iy a ɛw ɛsɛ ekʼowʼn uw cɛ af, toŋ agŋ ekʼanŋ yogŋ a am dad ɛsɛ: «Iy a, lʼuw.» ");
INSERT INTO adj_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Gbɛkↄ Jesu ↄny iy a abu ɛtŋ ow ↄŋ lʼigb nʼinym es. ");
INSERT INTO adj_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Eke Jesu im gbugŋ, ke in eci jam ɛsɛl ab ab -nʼanŋn ɛl sↄny a, -nʼam ibrm ow -lʼɛsɛ: «Kↄ bla ɛtŋ ɛy sʼↄtum sʼↄnym abusu sʼogŋm abŋ na ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jesu am dad ɛl ɛsɛ: «Abŋ akpasu na, Nyam ŋↄŋn ɛm cɛ wɛl bʼogŋʼn lʼɛy ↄkm.» ");
INSERT INTO adj_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Sica -nʼŋgboŋ usu a eke -nʼanŋn a, ɛtŋ -lʼubr Galile ogog a. Jesu e tutr ɛm a, kʼɛgŋ kʼúwm yogŋ a eke nʼanŋ ab any. ");
INSERT INTO adj_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Nʼam yɛgm in e jam ɛsɛl a low li dad wɛl lʼɛsɛ: «Wɛl bʼow ↄny ɛgŋ ecʼIy ɛlu agŋ abu ɛm, ke -lʼibi ow. Eke ow bʼow kok sɛgŋ nyahan a, li bʼow lʼigb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Gbɛkↄ low yɛgm ikŋ na, jam ɛsɛl a kʼirim ow eci nyandrɛ a, ɛtŋ -nʼam uru eke -li kʼibrm Jesu low na ecʼakr otar a. ");
INSERT INTO adj_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","-Nʼim -lʼɛy Kapɛrnayum; eke -nʼimn -lʼokr akŋ a, Jesu am ibrm in e jam ɛsɛl a ɛsɛ: «Kↄ ejagb us ɛm a, bla owi anake am atarir es ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ɛl a fɛŋ -li yewal, aŋke ejagb af a, -lʼatar ów es, -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Kↄ bwo el ɛy ecʼanymu ee?» ");
INSERT INTO adj_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Sica Jesu sig es, ɛtŋ lʼɛsŋ jam ɛsɛl lɛw yony a fɛŋ, ɛtŋ nʼam dad wɛl lʼɛsɛ: «Eke ɛgŋ nyam erur eke kʼel ↄny ecʼanymu, ke lʼél ↄny a fɛŋ eci jam ablu, lʼél ↄny fɛŋ eci ob oc ↄŋ ɛs.» ");
INSERT INTO adj_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ɛtŋ Jesu ↄny iyli nyam abu ow araŋn yogŋ ɛl ecʼany af, lʼoc ow ɛtŋ nʼam dad wɛl lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","«Ekʼɛgŋ eb ey amua ɛm e nyam ɛm sosiɛm a, ke ɛm anake lʼebʼm a. Ɛtŋ ɛgŋ a ekʼebʼm a, ow elm ɛm obi lʼebm im, kↄ ɛgŋ a ekʼɛrmʼm a anake lʼeb ɛbɛn a.» ");
INSERT INTO adj_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan dad Jesu ninɛ: «Low yɛgm agŋ ɛs, sʼɛkn ɛgŋ nyam eke oc ŋ e nin a am kokr juma ogŋn abŋ eŋuŋ. Sʼɛdŋn in, eke lʼelm ɛy ecʼɛgŋ a sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jesu dad ninɛ: «Ɛgŋ kʼɛ́dŋn in, aŋke ɛgŋ kaka anm eke bʼow oc ɛm e nin a kokr sakrowa, ke kpɛkŋ ow e jam a, ↄ́tu dad ɛm e nin ŋuŋ ecʼodad. ");
INSERT INTO adj_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Tasi ɛm a, ɛgŋ ekʼifnm ɛy a, el ɛy ecʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Low nawrɛ mʼam dad ↄny: ɛgŋ kaka fɛŋ ekʼↄŋ ↄny mij kpↄk ɛm ɛgŋn, Krist ecʼagŋ ekʼeel a sosiɛm a, ɛgŋ ikŋ na, li bʼow nʼɛŋn in e labm sↄg.» ");
INSERT INTO adj_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ɛmɛny Jesu usr af dad ninɛ: «Ɛgŋ eke bʼow ↄny ɛgŋ ekʼↄny ↄmn ɛm ɛm ɛsɛ iy na af ɛlu wus a, low ŋuŋ a eke li kʼɛŋn a agb nↄnↄ. Eke wɛl oc meb ucur lob ligbɛl ucuʼr ɛmn, ɛtŋ ↄny ɛman in okij a, ow akpl akm low ŋuŋ a eke wɛl ki kokʼr a. ");
INSERT INTO adj_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Eke batŋ ow el ŋ ecʼabu a anake bʼↄŋ ɛy sikpl owi ɛm a, ke ùbrʼr es, aŋke ow akpl ŋ eci eke kʼɛy sel ɛŋn tasi ab ɛm abu nyam coco ab, ow a eke kʼɛli sabu yony ke ím anŋ gbre ij usu, yogŋ a eke al ekʼiram es anŋ a.  ");
INSERT INTO adj_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Yogŋ, sisŋ a eke bʼij sos megl a, -lʼuwmn, ɛtŋ al a ekʼanŋ yogŋ a yɛji iram es kaka. ");
INSERT INTO adj_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ɛtŋ ekʼow el ŋ e lakr a anake bʼↄŋ ɛy sikpl owi ɛm a, ke ùbrʼr es, aŋke ow akpl ŋ eci eke kʼɛy sel ɛŋn tasi ab ɛm lakr nyam coco ab, ow a eke kʼɛli akr yony ke ím gbre ij usu a.  ");
INSERT INTO adj_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Yogŋ, sisŋ a eke bʼij sos megl a, -lʼuwmn, ɛtŋ al a ekʼanŋ yogŋ a yɛji iram es kaka. ");
INSERT INTO adj_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Eke batŋ ow el ŋ e nyamn a anake bʼↄŋ ɛy sikpl owi ɛm a, ↄkr ↄny ocʼr es, ow akpl ŋ eci eke kʼoc nyamn nyam ab ɛy Nyam eci gbreŋgbi usu ab ɛm, ow a eke kʼɛli anyamn yony ke wɛl ↄny ↄwlʼŋ gbre ij usu a. ");
INSERT INTO adj_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Yogŋ, sisŋ a eke bʼij sos megl a, -lʼuwmn, ɛtŋ al a ekʼanŋ yogŋ a yɛji iram es kaka. ");
INSERT INTO adj_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Tasi ɛm a, ɛgŋ ɛgŋ bʼow ɛcr al eci gbre ijr ab ɛm, yecʼɛtŋ ke ɛbm ɛkn na áyal il ɛsɛ egb waw eke wɛl bʼok mok af ab af. ");
INSERT INTO adj_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Mok el ob mamn. Eke batŋ lʼirmn in e ded a, ayaf wɛl ki kokr ke lʼɛ́wl mɛny li ded ee? Ow akpl ekʼↄny ɛm a, mok e ded ikŋ na kʼanŋ, yecʼɛtŋ ke ↄny ↄfr ɛm a, ír ɛrm es ɛy ecʼɛb.» ");
INSERT INTO adj_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesu igb yogŋ im Jude wus af, ɛtŋ lʼubr Jurdɛn jam a. Ɛmɛny agŋ nↄnↄ ow as luku ɛlul il ɛm; ɛsɛ sɛgŋ fɛŋ ecʼa eke li bi kok ab af, nʼam yɛgm agŋ a low. ");
INSERT INTO adj_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Eke Farisiɛl kʼɛbm Jesu a sosiɛm, -lʼow -nʼɛŋn ow ɛtŋ -nʼam ibrm ow -lʼɛsɛ: «Kↄ ɛy ecʼol ab ɛm abusu ɛru es eke igŋ kʼɛlu in e yↄw es ee?» ");
INSERT INTO adj_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jesu ibrm ɛl ninɛ: «Kↄ low yɛgm eke Mois ↄŋ ↄny a el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","-Li dad ninɛ: «Mois ↄŋ abusu eke wɛl ki nↄn igŋnin e lɛl gbuŋ ke igŋ ógŋ in e yↄw.» ");
INSERT INTO adj_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ow sosiɛm Jesu dad ɛl ninɛ: «Mois nↄn ol ikŋ na aŋke ↄny, eel agŋ ɛrm tuↄtuↄ ɛsɛl. ");
INSERT INTO adj_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Gbɛkↄ wus e nuŋ ↄb ɛm a, eke Nyam kok ów a fɛŋ a, li kok wɛl igŋ lele yↄw ab. ");
INSERT INTO adj_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Na sosiɛm anake igŋ bʼow ŋgboŋ ɛs lele lis ab ecʼakŋ, ");
INSERT INTO adj_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ke lʼókr af in e yↄw ab ab -lʼel sos megl nyam a. Ca -lʼelm agŋ yony ij, kↄ sos megl nyam. ");
INSERT INTO adj_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ke ɛgŋ kʼↄ́nym yecʼeke Nyam ↄny okr af a, kpabm es.» ");
INSERT INTO adj_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Sica eke Jesu lele in e jam ɛsɛl ab ab im ok akŋ a, ɛmɛny jam ɛsɛl a am ibrmʼn ów, odad a eke li dad ab af. ");
INSERT INTO adj_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesu dad ɛl ninɛ: «Igŋ fɛŋ eke ɛlu in e yↄw es, ke im ɛbi yↄw ɛjecʼa, lʼij nfaci krɛkrɛ e yↄw a ecʼany af ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ɛtŋ eke yↄw nyam ɛlu in ecʼigŋ es ɛtŋ im oc igŋ ɛjecʼa, in yɛji lʼij nfaci ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Agŋ ot etuey aam Jesu ogŋ eke li kʼat wɛl abu nuŋ, gbɛkↄ jam ɛsɛl a am ɛnym ɛl abr. ");
INSERT INTO adj_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Eke Jesu bʼɛkn ɛbɛn a, ow e low eblʼl ɛrm ɛtŋ li dad in e jam ɛsɛl a ninɛ: «Yɛ̀br etuey ow ɛm ogŋ! Ɛgŋ kʼɛ́dŋn ɛl, aŋke tasi ɛm a Nyam e gbreŋgbi usu a, agŋ a ekʼanŋ ɛsɛ ɛl af a eci. ");
INSERT INTO adj_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Low nawrɛ mʼam dad ↄny, ɛgŋ kaka fɛŋ ekʼɛgŋm Nyam e gbreŋgbi usu a ebm ɛsɛ iyli af a, ɛgŋ ikŋ na, lɛgŋ kaka li kʼow lʼↄtum lʼɛym ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ɛtŋ Jesu am ot ey a, at ɛl abu nuŋ ɛdŋ ɛl ↄwrↄ. ");
INSERT INTO adj_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ejagb cɛ eke Jesu us eke kʼim a, kpɛkŋ ɛgŋ nyam uru es ɛcʼr anym ok ↄwrↄkp wus ɛtŋ am ibrmʼn ɛsɛ: «Low yɛgm agŋ ɛs mamn, kↄ ayaf mi ki kokr ke mʼíj sel ɛŋn ekʼↄnym uwr ecʼaja ee?» ");
INSERT INTO adj_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jesu dadʼr ninɛ: «Kↄ bla ɛtŋ am ɛsŋʼm ɛgŋ mamn ee? Ɛgŋ kaka elm ɛgŋ mamn, ekʼow elm Nyam sↄny coco cɛ. ");
INSERT INTO adj_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kↄ uw sol ab any ee? Kʼíbim ɛgŋ, kʼíjm nfaci, kʼíym mil, kʼíjm daŋku yadŋ ɛm ɛgŋ e nuŋ af, kí kokm lɛyr owi ɛgŋ e lís, ɛ́lum asŋ lele esŋ ab.» ");
INSERT INTO adj_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɛgŋ a dadʼr ninɛ: «Low yɛgm agŋ ɛs, likekli ɛm ɛtŋ mi bʼɛlum sol amua fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jesu lɛrʼr, ↄny in ecʼerur ɛtŋ dadʼr ninɛ: «Ow anŋʼŋ low nyam cɛ. Ìm ↄl ŋ ecʼob ekʼↄny a ij, òc ow ecʼos a ↄŋ ↄgbↄru, ke bʼow ɛŋn ob ↄny afr, ca ɛ́wl mɛny ow usʼm jam.» ");
INSERT INTO adj_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ekʼɛgŋ a iri odad na a, ow e low ɛdŋʼn ɛrmni es, ɛtŋ nʼaam sos es ↄw ɛm, aŋke nʼↄny ob nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Eke Jesu lɛr in e jam ɛsɛl a ekʼanŋʼn saw saw a, li dad wɛl ninɛ: «Nyam e gbreŋgbi usu a ecʼɛm ɛy a ɛw tuↄtuↄ agŋ a ekʼↄny ob nↄnↄ a eci gbɛ!» ");
INSERT INTO adj_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jam ɛsɛl a low iti any low na eke -lʼirir a sosiɛm; ɛtŋ Jesu ɛwl am dad ɛl ɛsɛ: «Ɛm jimɛl, Nyam eci gbreŋgbi usu a ecʼɛm ɛy a ɛw tuↄtuↄ. ");
INSERT INTO adj_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Kin, gbaŋkↄ kedebnam eci fɛfn ↄmu ɛm eke kʼɛcr a, ɛw fuɛfuɛ akm gbreŋgbi eci Nyam e gbreŋgbi usu ecʼɛm ɛy a.» ");
INSERT INTO adj_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Ow ↄŋ jam ɛsɛl a eci low any iti a am afŋn es, ɛtŋ -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Kↄ sica bwo ecʼɛgŋ ↄtu ekʼɛŋn sel ee?» ");
INSERT INTO adj_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jesu ok ɛl anyamn af, ɛtŋ dad ɛl ninɛ: «Agŋ ecʼany af a, ow ɛw tuↄtuↄ, kↄ ow elm Nyam ecʼany af a gbɛ, aŋke Nyam ecʼa, fɛŋ ɛw fuɛfuɛ!» ");
INSERT INTO adj_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Af yogŋ Piɛr dadʼr ninɛ: «Ŋ obi yɛji ɛ̀kn! Ɛy, sʼigŋ fɛŋ sʼok es ɛtŋ sʼusʼŋ jam.» ");
INSERT INTO adj_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesu dadʼr ninɛ: «Low nawrɛ mʼam dad ↄny: eke ɛm lele Amani Mamn ab ab sosiɛm ɛgŋ nyam igŋ in ecʼakŋ, lisijimɛl, lisijↄwɛl, lis, ɛs, in ecʼey, in e sↄgm ɛlu es a, ");
INSERT INTO adj_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","sɛgŋ amua eke sʼanŋ ɛm ab ɛm, li bʼow nʼɛŋn ów amua e sakp ekŋ yen ok af: akŋ, lisijimɛl, lisijↄwɛl, lisɛl, ey lele sↄgm ab. Ɛtŋ li bʼow lʼↄbr gbre ijr yɛji. Ke sica sɛgŋ a eke anŋ anym am ow ab ɛm a, nʼɛ́ŋn sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Gbɛkↄ ánymu ab ɛm eci nↄnↄ bʼow ɛwl el ajamu, ɛtŋ ajamu ab ɛm e nↄnↄ, bʼow ɛwl el ánymu.» ");
INSERT INTO adj_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Jesu us ejagb agŋ a ekʼam usʼr jam ab ab, lʼikŋ wɛl anym -nʼam uyu -nʼim Jerusalɛm. Jam ɛsɛl a ɛrmni ɛdŋ es, ɛtŋ agŋ a ekʼam usʼr jam a erŋn ow sos. Jesu ɛsŋ lɛw yony a saw ɛm eke ki dad ɛl low yecʼa eke bʼow ɛŋnʼn a. ");
INSERT INTO adj_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","34","Li dad ninɛ: «Ìsr any ɛ̀kan, kin Jerusalɛm anake sʼam uyu sʼim a; yogŋ ɛgŋ ecʼIy bʼow ɛy egb waw ɛsɛl ɛgbɛl lel ol e low yɛgm ɛsɛl ab ab ecʼabu ɛm. -Li bʼow -lʼↄb ow low luw eci, ɛtŋ -li bʼow -lʼoc ow -nʼↄŋ Nyam any uwm ɛsɛl kokrʼr miyɛr, aflʼl sar any, ↄrʼr say ɛm, ke -lʼibi ow. Gbɛkↄ eke sɛgŋ nyahan bʼow ɛc a, li bʼow lʼigb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Sica Sebede jimɛl a, Jak lele Jan ab, ow ɛŋn Jesu ɛtŋ am dadʼr ɛsɛ: «Low yɛgm agŋ ɛs, sʼam erur eke low yecʼeke si bʼow sʼibrmʼŋ a, kók ↄŋ ɛy.» ");
INSERT INTO adj_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jesu ibrm ɛl ninɛ: «Kↄ bla lowi am erurir eke mi ki kok mʼↄŋ ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","-Li dad ow ninɛ: «Lɛgŋ eke bʼow anŋ ŋ ecʼanygbɛl ɛm a, ɛ̀gŋ ↄŋ ɛy abusu ke sʼók es ŋ ab: ɛgŋ nyam sígʼŋ es lidr ogog ke nyam sígʼŋ es nɛmn ogog.» ");
INSERT INTO adj_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Gbɛkↄ Jesu dad ɛl ninɛ: «Low yecʼa ekʼam ibrmn a, kʼuwmn any. Kↄ ↄtur eke bʼow ɛgŋn gbre e mij kpↄk a eke mʼow mʼɛgŋ a, oglog wɛl ok ↄny gbre e mij nuŋ a eke wɛl bʼow okʼm ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","-Li dad ow ninɛ: «Ɛɛ, sʼↄtu.» Ɛtŋ Jesu dad ɛl ninɛ: «Bʼow ɛgŋn mij kpↄk a eke mʼow mʼɛgŋ a, ɛtŋ wɛl bʼow ok ↄny mij nuŋ a eke wɛl bʼow okʼm a, ");
INSERT INTO adj_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","gbɛkↄ ɛm e lidr abu af ecʼes sig a lele nɛmn abu af ecʼab ab a, ow elm ɛm mʼↄↄm ɛgŋ. Susu amua el agŋ a eke ɛl sosiɛm Nyam kok ɛw es a eci.» ");
INSERT INTO adj_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Eke jam ɛsɛl agŋ lɛw a iri low na a, -nʼam ebl ɛrm -lʼok Jak lele Jan ab af. ");
INSERT INTO adj_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ow sosiɛm Jesu ɛsŋ ɛl fɛŋ ɛtŋ am dad ɛl ɛsɛ: «Ɛ̀kan ekʼagŋ a e si bʼoc ɛsɛ ɛb ecʼes ɛw ɛsɛl af a, bʼɛw ɛb ab es abusu ↄny ɛm, ke ɛl ɛm ecʼagŋ any ɛsɛl ekʼanŋ a, bʼɛlu ɛl ecʼabusu ↄny a ↄkm dedeku a e nuŋ af a. ");
INSERT INTO adj_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Gbɛkↄ ↄny eci araŋn ecʼa, ow kʼɛ́cr ɛbɛn. Eke batŋ ↄny ɛm ecʼɛgŋ kaka fɛŋ am erur eke kʼel ↄny ecʼes ɛw ɛs a, ke lʼél ↄny a fɛŋ ecʼob oc ↄŋ ɛs; ");
INSERT INTO adj_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ɛtŋ ɛmɛny ekʼↄny ɛm ecʼɛgŋ kaka fɛŋ am erur eke kʼel ↄny ecʼanymu, ke lʼél agŋ a fɛŋ ecʼadu. ");
INSERT INTO adj_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ɛbɛn nyam coco ɛgŋ ecʼIy yɛji owm ekʼagŋ ki kok in e lís e low, kↄ lʼow eke li ki kok agŋ e lís e low, ke lʼóc in e sel a lʼɛw awoba li sↄgr agŋ nↄnↄ.» ");
INSERT INTO adj_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jesu lel in e jam ɛsɛl ab ab ow ok Jeriko ɛb ɛm. Sica eke Jesu, in e jam ɛsɛl a lel agŋ dedeku ab ab am ok ↄkm baŋn a, -lʼuyum any eflu nyam eke wɛl bʼɛsŋ Bartime, Time jim ab, eke sig es ejagb saw ob sasm eci. ");
INSERT INTO adj_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Eke lʼiri ekʼow el Nasarɛt iy Jesu a, nʼam ɛlu lebl li dad lʼɛsɛ: «Jesu, David eci lilaw, ìkŋʼm sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Agŋ nↄnↄ gbɛl erurm ɛtŋ am ɛnymʼn abr eke li ki yewal, gbɛkↄ nʼam at lebl es lʼↄg li dad lʼɛsɛ: «David eci lilaw, ìkŋʼm sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jesu inym es ɛtŋ dad eke wɛl kʼɛsŋʼn any eflu a. -Lʼɛsŋ ow ɛtŋ -li dad ow ninɛ: «Àtr sos es igb! Nʼam ɛsŋʼŋ.» ");
INSERT INTO adj_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Any eflu a wↄg in e mob sus ɛm a ɛlu es, ɛtŋ lʼigb kpɛkŋ nʼim nʼɛŋn ow. ");
INSERT INTO adj_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jesu ibrmʼn ninɛ: «Kↄ bla lowi am erur eke mi ki kok mʼↄŋʼŋ ee?» Any eflu a dadʼr ninɛ: «Low yɛgm agŋ ɛs, mʼam erur eke mi kʼɛwl mʼɛkn es.» ");
INSERT INTO adj_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jesu dadʼr ninɛ: «Ìm! Ŋ ecʼↄmn a ewlmʼŋ.» Kpɛkŋ nʼam ɛkn es, ɛtŋ nʼam us Jesu jam. ");
INSERT INTO adj_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Eke -nʼimn bake -nʼam titm Jerusalɛm, ke -nʼanŋn Bɛtfaje baŋn lele Betani baŋn ab eci nɛny nɛny a, Olivie lafɛny a ogŋ a, Jesu ɛrm in e jam ɛsɛl ab ɛm ecʼagŋ yony ");
INSERT INTO adj_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","ɛtŋ li dad wɛl ninɛ: «Ìmn baŋn a ekʼanŋ ↄny anym ab ɛm, kpɛkŋ eke bʼow okr ɛm a, bʼow ɛŋan gbaŋkↄ kpɛtɛŋ eke wɛl ucur es, ke lɛgŋ kaka ɛgŋ sigm af. Mↄmun in es kʼócr isrʼm aŋa. ");
INSERT INTO adj_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Eke batŋ ɛgŋ bʼibrm ↄny low a sosiɛm eke am mↄmun gbaŋkↄ kpɛtɛŋ na es a, dádr ɛsrɛ: “Ɛgŋ gbɛl ↄny ow ecʼes abur. Gbɛkↄ kpɛkŋ cɛ li bʼow lʼɛwl mɛny lʼɛlu es ow ow ɛŋnʼŋ.” » ");
INSERT INTO adj_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","-Nʼim ɛtŋ -nʼɛŋn gbaŋkↄ kpɛtɛŋ nyam ekʼucur es gbeŋ lisany saw, ejagb nɛny, ɛtŋ -ni mↄmu ow es. ");
INSERT INTO adj_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Agŋ nyam nyam ekʼanŋ yogŋ a am ibrm ɛl ɛsɛ: «Kↄ bla anake am kokr ab ee? Bla sosiɛm am mↄmun gbaŋkↄ kpɛtɛŋ na es ee?» ");
INSERT INTO adj_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Jam ɛsɛl a dad agŋ a yecʼa eke Jesu dad ɛl a, ɛtŋ kpɛkŋ wɛl ɛlu ɛl es -lʼeb ejagb -nʼim. ");
INSERT INTO adj_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","-Lʼoc gbaŋkↄ kpɛtɛŋ a -lʼis Jesu, -lʼot ɛl e sigbad a -lʼok ow af ɛtŋ Jesu sig es af. ");
INSERT INTO adj_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Agŋ nↄnↄ am ot ɛl e sigbad a ok ejagb, ɛtŋ bɛb ecʼa, ow el ekŋ al eke -lʼubr ↄgm ↄgm a. ");
INSERT INTO adj_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Agŋ a ekʼikŋ Jesu anym lel ɛl a ekʼanŋʼn jam ab ab a, am ↄg dad ɛsɛ: «Hosana! Anygbɛl él Nyam eci! Ke Nyam ɛ́dŋ ɛgŋ ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ! ");
INSERT INTO adj_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Ke Nyam ɛ́dŋ gbreŋgbi usu a ecʼes ɛw a ekʼam ow a ↄwrↄ! Ɛy lagŋ David eci gbreŋgbi usu a ecʼes ɛw a! Anygbɛl él Nyam ekʼanŋ afr kpekpe a eci!» ");
INSERT INTO adj_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesu ɛy Jerusalɛm ɛtŋ nʼim toŋ lʼɛy Nyamel gbɛl ab ɛm. Eke lʼɛw mob a fɛŋ nyamn af uwr a, in lel in e jam ɛsɛl ab ab, -lʼeb ejagb -nʼim Betani, aŋke lɛgŋ am uk. ");
INSERT INTO adj_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Eke lɛgŋ ɛny ke Jesu lel in e jam ɛsɛl ab ab ok ↄkm Betani a, Jesu namn ow sos. ");
INSERT INTO adj_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Akpoj ɛm a, lʼɛkn babm ikŋ nyam ekʼebu sɛnyn sɛnyn. Ɛtŋ nʼaam lʼɛkn eke li bʼow nʼɛŋn ey ow ɛm. Kↄ eke nʼim li titm likŋ a, lʼɛkn eke ow el suw ↄfr, aŋke ow elm lakpo ekʼow it ekʼow kʼↄsu ey a. ");
INSERT INTO adj_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ɛtŋ Jesu dad ninɛ: «Ke lɛgŋ kaka ɛgŋ kʼɛ́ŋnm ŋ ɛm e liy ijm.» Jam ɛsɛl a iri odad a eke li dad a. ");
INSERT INTO adj_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Sica -nʼim -lʼok Jerusalɛm. Eke Jesu ɛy Nyamel gbɛl a eci gbugŋ a, nʼam ogŋ án ↄlu a lel agŋ ekʼam ↄl mob ab ab lʼok ↄkm. Ɛtŋ nʼↄny jɛtɛ titŋn ɛsɛl e sitabl a lele prɛndrɛ ↄl ij ɛsɛl e mɛkpn ab ab lʼok wus. ");
INSERT INTO adj_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ɛtŋ lʼɛ́gbm ɛgŋ kaka es eke kʼoc ob ubr Nyamel ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ɛtŋ sica nʼam yɛgm wɛl low li dad lʼɛsɛ: «Nyam Lɛl ɛm Nyam dad ninɛ: Wɛl bʼow ɛsŋ ɛm ecʼêl a Nyam ŋↄŋn ecʼêl, ɛbr ɛbr fɛŋ eci. Kↄ ↄny, am ocr kokr elu eci ɛŋanin usu.» ");
INSERT INTO adj_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Ekʼegb waw ɛsɛl ɛgbɛl lel ol e low yɛgm ɛsɛl ab ab iri low ikŋ na a, -nʼam ↄl akunda yecʼɛm eke -li kʼibi Jesu. Ke tasi ɛm a, -li bʼↄny ow e muru aŋke dedeku a bʼerur in e low yɛgm a. ");
INSERT INTO adj_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Eke lɛgŋ ew es a, Jesu lel in e jam ɛsɛl ab ab ok ↄkm ɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ibribr ɛm a, eke Jesu lel in e jam ɛsɛl ab ab am ɛc ebr ab af a, -lʼɛkn babm ikŋ a e wɛw es toŋ ok min ɛm. ");
INSERT INTO adj_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piɛr ↄkn low a ekʼɛc a, ɛtŋ li dad Jesu ninɛ: «Low yɛgm agŋ ɛs, lɛ̀r! Babm ikŋ a ekʼofn ok af a wɛw es fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesu am dad in e jam ɛsɛl a ɛsɛ: «Low nawrɛ mʼam dad ↄny: ↄnyn ↄmn Nyam ɛm! ");
INSERT INTO adj_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ekʼɛgŋ dad ligigl na eke kʼŋgboŋ aŋa im ɛy okij ɛm, ɛtŋ bɛbar anmʼn ɛrm ɛm, ɛtŋ lʼub nawrɛ eke low a e li dad a bʼow el a, tasi ow bʼow el. ");
INSERT INTO adj_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Na sosiɛm mʼam dad ↄny, ob fɛŋ eke bʼow ibrmn Nyam ŋↄŋn ɛm a, ùbr nawrɛ eke ɛŋan ɛtŋ Nyam bʼow ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Sica, eke am ŋↄŋn Nyam ɛtŋ ↄkan eke ↄnyn low ↄny lawl nyam ab a, òcr apr ir, yecʼɛtŋ ke ↄny Ɛs ekʼanŋ afr a yɛji áp ↄny e sikpl a.  ");
INSERT INTO adj_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Gbɛkↄ eke kʼow apmn ↄny lawlɛl a, ↄny Ɛs ekʼanŋ afr a yɛji kʼow apm ↄny ↄny e sikpl a.» ");
INSERT INTO adj_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ɛmɛny eke Jesu lel in e jam ɛsɛl ab ab ow Jerusalɛm a, nʼanŋ Nyamel gbɛl a eci gbugŋ a nʼam nyinymn es. Egb waw ɛsɛl, ol e low yɛgm ɛsɛl lel agŋ ekpekp ab ab ow ɛŋnʼn, ");
INSERT INTO adj_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ɛtŋ -nʼam ibrm ow -lʼɛsɛ: «Kↄ bogŋ ecʼabusu ɛm bi kok ów amua ee? Ɛtŋ kↄ bwo bʼↄŋʼŋ ow e kok ecʼabusu ee?» ");
INSERT INTO adj_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jesu dad ɛl ninɛ: «Mʼaam mʼibrm ↄny low nyam cɛ. Sica eke dadrʼm a, ɛm yɛji mi bʼow mi dad ↄny abusu yecʼɛm eke mi bi kok ów amua a. ");
INSERT INTO adj_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kↄ bwo ↄŋ Jan abusu ow ok agŋ mij nuŋ ee? Kↄ Nyam oglog agŋ ee? Dàdrʼm mʼiri.» ");
INSERT INTO adj_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ow ɛw ɛl ów es atar ɛl ↄfr ɛm ɛtŋ -nʼam dad -lʼɛsɛ: «Eke si dad eke Nyam ↄŋʼn abusu lʼow, li bʼow lʼibrm ɛy lʼɛsɛ: “Kↄ bla sosiɛm ɛtŋ ubmn in nawrɛ ee?” ");
INSERT INTO adj_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ɛtŋ eke si dad eke agŋ ↄŋʼn abusu lʼow, yeci yɛji es abur.» (-Nʼↄny dedeku a e muru, aŋke ɛl fɛŋ -li bʼoc Jan kokoba ↄb ɛs tasi.) ");
INSERT INTO adj_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ɛtŋ sica -li dad Jesu ninɛ: «Sʼuwm any.» Ɛtŋ Jesu yɛji dad ɛl ninɛ: «Eke ow el ɛbɛn a, ɛm yɛji mi kʼow mi dadm ↄny abusu yecʼɛm eke mi bi kok ów amua fɛŋ a.» ");
INSERT INTO adj_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ow e jam a, ɛmɛny Jesu am dad ɛl odad nyandrɛ ɛm ɛsɛ: «Lɛgŋ nyam ↄgm ɛs nyam ewl viny in ecʼegb ↄgm a. Nʼawŋ lakp lʼɛlul ɛm, li kok usu eke wɛl kʼifi egb ey ab es, ɛtŋ li kok usu gege eke wɛl kʼanŋ ↄsu ↄgm a. Ɛtŋ lʼoc egb ↄgm a lʼabul ↄgm juma kok ɛsɛl, ɛtŋ lʼeb ejagb nʼim usu. ");
INSERT INTO adj_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Ekʼegb ub e lakpo ow a, egb ↄgm ɛs a ɛrm in ecʼabu ɛlum ɛs nyam im eke juma kok ɛsɛl a kʼↄŋʼn in ecʼegb a eke kʼɛbmʼn a. ");
INSERT INTO adj_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Juma kok ɛsɛl a ↄny abu ɛlum ɛs a, -lʼↄr ow ɛtŋ -lʼɛwlm ow mɛny ow im abu ↄfr. ");
INSERT INTO adj_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ɛmɛny egb ↄgm ɛs a ɛrm abu ɛlum ɛs nyam im. In ecʼa, -li kok ow ob nuŋ ɛtŋ -li kok ow sos keskes. ");
INSERT INTO adj_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ɛmɛny egb ↄgm ɛs a ɛrm abu ɛlum ɛs ɛjeci nyam im. In ecʼa, -nʼↄny ow ɛtŋ -lʼibi ow. Lʼɛrm abu ɛlum ɛsɛl ɛjecʼim, kↄ -li kok wɛl low nɛnyɛmbri nyam a cɛ: -lʼↄr bɛb ɛtŋ -lʼibi likpr. ");
INSERT INTO adj_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sica in ecʼiy eke lʼerur tasi a cɛ el ɛgŋ ekʼanŋʼn abu ɛm. Ow anake lʼabal es lʼɛrm ow ekʼow kʼim ɛkn wɛl a, aŋke in e tutr ɛm a, ekʼow el in ecʼiy a, wɛl bʼow ↄny ow ecʼɛlum. ");
INSERT INTO adj_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Gbɛkↄ eke juma kok ɛsɛl a ɛkn iy a, -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: “Kin ɛgŋ a eke godo godo bʼow el aja ij ɛs a. Sʼímn, sʼíbir ir, ke egb ↄgm a él ɛy eci.” ");
INSERT INTO adj_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","-Nʼↄny iy a, -lʼibi ow, ɛtŋ -lʼoc ow e sos megl a -lʼↄwl ↄgm a e jam a.» ");
INSERT INTO adj_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Sica Jesu ibrm ninɛ: «Egb ↄgm ɛs a, bla li bʼow li kok ab ee? Li bʼow lʼow, lʼibi juma kok ɛsɛl a, ke lʼóc egb ↄgm a lʼɛlul agŋ ɛjecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Kↄ ↄny awlmn odad na eke wɛl nↄn Nyam Lɛl ɛm ab ee? Lebn a eke êl us ɛsɛl a oc ↄwl a, ɛwl el êl lↄy ɛm e lebn tasi. ");
INSERT INTO adj_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Na low eke anŋ Nyam ogŋ ow ke el low sↄbↄ ɛy ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sica Jwifɛl ecʼes ɛwɛl a am ↄl akunda yecʼɛm eke kʼɛw Jesu abu af, aŋke -lʼuw any eke ɛl ow dad odad nyandrɛ ɛm na ok ɛl af. Gbɛkↄ dedeku a e muru sosiɛm a, -lʼɛgb ow es ɛtŋ -lʼeb ejagb -nʼim. ");
INSERT INTO adj_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Jwifɛl ecʼes ɛwɛl a ɛrm Farisiɛl ecʼagŋ nyam nyam lele Erↄd ecʼogog ecʼagŋ nyam nyam ab ow eke kʼuk Jesu meb ke -nʼↄny ów ow ecʼodad ebl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","-Lʼow -nʼɛŋn Jesu ɛtŋ -li dad ow ninɛ: «Low yɛgm agŋ ɛs, sʼuw any eke ŋ bi dad low nɛnyɛmbri nyam, ↄ́nym ɛgŋ kaka e muru; ŋ ecʼa, agŋ a fɛŋ el agŋ nɛnyɛmbri nyam, ɛtŋ Nyam ecʼelel eke am ibrm eke si kʼiir ɛb a, bi yɛgm ow ecʼejagb a kpɛŋ. Dàd ɛy ↄ! Kↄ ɛy ecʼol ab ɛm, abusu ɛru es eke si ki sↄg wus labm sʼↄŋ Sesar es ee? Ow it eke si ki sↄg ee?» ");
INSERT INTO adj_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Gbɛkↄ Jesu ekʼuw ɛl e kprakpr ab any a dad ɛl ninɛ: «Bla sosiɛm ɛtŋ am ukrʼm meb ee? Òcr os a isrʼm ke mʼɛ́kn.» ");
INSERT INTO adj_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","-Lʼoc os a -lʼis ow, ɛtŋ Jesu ibrm ɛl ninɛ: «Mɛny ɛwr na lele nin na eke wɛl nↄn os na af a, bwo ecʼɛgŋ ecʼow el ee?» -Li dad ninɛ: «Sesar eci.» ");
INSERT INTO adj_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ɛtŋ Jesu dad ɛl ninɛ: «Eke ow el ɛbɛn a, ↄŋn Sesar yecʼekʼel Sesar ecʼa, ke ↄ́ŋn Nyam yecʼekʼel Nyam ecʼa.» Ɛtŋ Jesu eci low ikŋ na e dad ɛl a ɛw ɛl any iti. ");
INSERT INTO adj_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Lɛgŋ nyam, Sadusiɛl ɛm ecʼagŋ likpr ow ɛŋn Jesu. (Ke Sadusiɛl anake bi dad ɛsɛ luw ɛm anŋ igb in anm a.) -Nʼam ibrm Jesu low na -lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","«Low yɛgm agŋ ɛs, Mois nↄn ol na ↄŋ ɛy dad ninɛ: Eke igŋ nyam ɛbi yↄw ɛtŋ lʼewm iy kaka toŋ lʼuw, ow akpl ke lisijim éb iŋnyↄw a ɛbi, éw ey in ab ɛw lisijim nin es. ");
INSERT INTO adj_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Kin agŋ lisijimɛl lↄbŋ e low ekʼɛŋn: likpekp a ɛbi yↄw, lʼewm iy kaka ow ab ɛtŋ lʼuw. ");
INSERT INTO adj_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Yony ɛm ecʼa eb iŋnyↄw a ɛbi, lʼewm iy kaka ow ab ɛtŋ in yɛji lʼuw. Low nɛnyɛmbri nyam a, ɛŋn nyahan ɛm ecʼa yɛji; ");
INSERT INTO adj_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","agŋ a lↄbŋ mum, ɛgŋ ɛgŋ ɛbi yↄw a kↄ lʼewm iy kaka, ɛtŋ ɛl fɛŋ -lʼuw. Ekʼɛl fɛŋ -lʼuwr a, yↄw a yɛji uw. ");
INSERT INTO adj_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Sica lɛgŋ a ekʼagŋ ekʼuw a bʼow igb luw ɛm a, bwo ecʼɛgŋ e yↄw tasi li bʼow lʼel ab ee? Aŋke ɛl a fɛŋ ɛgŋ ɛgŋ ɛbiʼr ow el in e yↄw.» ");
INSERT INTO adj_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesu dad ɛl ninɛ: «Njɛ, ↄny na irm anake am irmn a! Ɛtŋ uwr low nuŋ af ekʼam irmn ab any ee? Ɔny uwmn Nyam Lɛl a eke wɛl nↄn ab any, ɛtŋ Nyam ecʼabusu a yɛji uwmn any. ");
INSERT INTO adj_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Tasi ɛm a, lɛgŋ ekʼagŋ bʼow anŋ luw ɛm igb a, egŋ lele ↄyↄw ab kʼow ɛbirm okm es ij, kↄ -li bʼow -lʼir ɛb ɛsɛ elel eke afr ɛrm ɛsɛl anŋn afr ab af. ");
INSERT INTO adj_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Sica yecʼekʼel uwↄmu ɛm anŋ igb ecʼa, awlmn Mois e lɛl e nↄn ab ɛm, yogŋ a eke wɛl dad kati ekʼam iri ke ɛ́tum es a ecʼodad ab ee? Wɛl nↄn dad eke Nyam dad Mois ninɛ: Ɛm mʼel Abraham e Nyam, Isak e Nyam, lele Jakↄb e Nyam ab.» ");
INSERT INTO adj_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ɛtŋ Jesu usr af dad ninɛ: «Kↄ agŋ eke uw a e Nyam li kʼel ee? Njaŋ, lʼel agŋ ekʼuw ke anŋ owr a e Nyam. Njɛ, ↄny na irm anake am irmn a!» ");
INSERT INTO adj_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ol e low yɛgm ɛs nyam iri ɛl ecʼów es atar a, ɛtŋ lʼɛkn eke Jesu ecʼodad a e dad Sadusiɛl a el low tasi. Lʼɛri lʼow li titm ow ɛtŋ nʼam ibrm ow lʼɛsɛ: «Ol a fɛŋ ɛm e ligbɛl el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jesu dadʼr ninɛ: «Kin ol a fɛŋ ɛm e ligbɛl: O Israɛl, ìgŋ lↄru es! Ɛs Kↄtↄkↄ ɛy e Nyam el Nyam nyam coco. ");
INSERT INTO adj_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Bʼow erur Asŋ Kↄtↄkↄ ŋ e Nyam ŋ ecʼɛrm fɛŋ ɛm, ŋ ecʼabŋ fɛŋ ɛm, ŋ e tutr fɛŋ ɛm lele ŋ e lɛc pupukpaŋ ab. ");
INSERT INTO adj_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ɛtŋ kin ol a e yony ɛm ekʼot krɛkrɛ ecʼab es: Bʼow erur ɛgŋ kaka fɛŋ ɛsɛ ŋ obi af. Ol a fɛŋ ɛm, kaka anm agbm akam ol yony na.» ");
INSERT INTO adj_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ol e low yɛgm ɛs a dad Jesu ninɛ: «Low yɛgm agŋ ɛs, ow akpl! Low nawrɛ tasi anake dad a: Ɛs Kↄtↄkↄ el Nyam nyam coco, ɛtŋ Nyam kaka anm ekʼow elm in sↄny cɛ. ");
INSERT INTO adj_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Njɛ ekʼɛgŋ erur Nyam in ecʼɛrm fɛŋ ɛm, in e tutr fɛŋ ɛm, lele in e lɛc pupukpaŋ ab, ɛtŋ lʼerur ɛgŋ kaka fɛŋ ɛsɛ in obi af a, na akpl akm mindey eke li kʼim Nyam ecʼany af lʼofŋ, lel egb waw ɛrŋ ɛrŋ eke li ki kok nʼↄŋ ow ab ab.» ");
INSERT INTO adj_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesu ɛkn ekʼol e low yɛgm ɛs a dad low a nuŋ ɛm ↄny ɛm, ɛtŋ li dad ow ninɛ: «Ŋ, titm Nyam e gbreŋgbi usu a.» Ow e jam a, ɛgŋ kaka úsm ibram Jesu low ij. ");
INSERT INTO adj_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Eke Jesu anŋ Nyamel gbɛl ab ɛm am yɛgm agŋ low a, lʼibrm ninɛ: «Ayaf ɛtŋ ol e low yɛgm ɛsɛl ↄtu e ki dad ɛsɛ: Mesi el David e lilaw ee? ");
INSERT INTO adj_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","David, ekʼAbŋ Lala owʼr af a, in obi li dad ninɛ: Ɛs Kↄtↄkↄ Nyam dad ɛm Ɛs Kↄtↄkↄ ninɛ: Òw sig es ɛm e lidr abu af toŋ bake mʼót ŋ ecʼefnu a mʼok ŋ ecʼakr ew. ");
INSERT INTO adj_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Eke sica David bʼɛsŋʼn “Ɛs Kↄtↄkↄ”, ke ayaf Mesi a ↄtu eke kʼel David e lilaw ee?» Agŋ nↄnↄ gbɛl am erur Jesu ecʼodad ekʼam dad a. ");
INSERT INTO adj_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesu in e low yɛgm ab ɛm am dad ɛl ɛsɛ: «Ɛ̀wr sos ɛrm ol e low yɛgm ɛsɛl amua eke bi sus mob akpakp am ok ↄkm ɛc a e lís. -Li bʼerur eke dedeku ɛm wɛl kʼɛsŋn ɛl ɛlum ɛm, ");
INSERT INTO adj_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ɛtŋ Nyam nuŋ igŋ e susu a, -li bi dogŋn mɛkpn anym es; es gbɛgbl ecʼob ij owi ɛm yɛji, -li bʼerur susu amamn. ");
INSERT INTO adj_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","-Li bʼufŋ eŋnyↄw ɛb es, ɛtŋ -li bi kok nyandrɛ -lʼↄfur Nyam ŋↄŋn yecʼɛtŋ ke wɛl ót ɛl agŋ amamn. Na sosiɛm anake ɛl e jɛj ok a bʼow ɛw tuↄtuↄ a.» ");
INSERT INTO adj_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Sica Jesu sig es ↄbr usu a eke wɛl kok Nyamel gbɛl ab ɛm ob ap ecʼab any, ɛtŋ nʼam lɛr elel eke agŋ a am apr ob a. Egbreŋgbi nↄnↄ am ok os nↄnↄ kↄprↄ ebr mob ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Iŋnyↄw gbↄr yↄw nyam ow ɛtŋ ɛlu os ekekey yony ekʼusm any yɛji kↄprↄ ebr ob ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jesu am dad in e jam ɛsɛl a ɛsɛ: «Low nawrɛ mʼam dad ↄny, iŋnyↄw gbↄr yↄw na ap ob akm agŋ likpr a fɛŋ, ");
INSERT INTO adj_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","aŋke ɛl ecʼa -nʼↄŋ ɛl ecʼob e -nʼↄnyn a ecʼow ekʼigŋ af a; kↄ iŋnyↄw a ecʼa, nʼↄŋ in e gbↄr ɛm ecʼa eke nʼↄny a, ow a fɛŋ a eke li kʼiir ɛb af a.» ");
INSERT INTO adj_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Eke Jesu anŋ Nyamel gbɛl ab ɛm ɛy ↄkm a, in e jam ɛsɛl ab ɛm ecʼɛgŋ nyam dadʼr ninɛ: «Low yɛgm agŋ ɛs, ìs any ɛkn mebn ɛgbɛl amua lele mel ɛgbɛl amua ab ↄ!» ");
INSERT INTO adj_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesu dadʼr ninɛ: «Mel ɛgbɛl amua ekʼam ɛkn a, kaka kʼow anm; fɛŋ bʼow ɛr ok wus. Lebn kaka kʼow anm lawl af ij.» ");
INSERT INTO adj_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Sica eke Jesu sig es Olivie lafɛny af ↄbr Nyamel gbɛl ab any a, Piɛr, Jak, Jan lele Andre ab ekʼanŋ in ab ɛl sↄny a, am ibrmʼn low saw ɛm ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","«Dàd ɛy ↄ! Kↄ bogŋ lɛgŋ iy low na bʼow ɛy, ɛtŋ ów amua fɛŋ eke bʼow ɛy a e mɛny ɛwr el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesu am dad ɛl ɛsɛ: «Ɛ̀wr ɛrm! Kì yɛbr ɛgŋ kʼirmn ↄny. ");
INSERT INTO adj_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Tasi ɛm a, agŋ nↄnↄ bʼow ow ɛm e nin ɛm dad ɛsɛ: “Ɛm Mesi a,” ɛtŋ -li bʼow -lʼirmn agŋ bubutɛ. ");
INSERT INTO adj_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Eke batŋ am irir ar ekʼam ɛy aŋa e likekr lel ar owi eke bʼow ɛy akpoj a ecʼamani ab a, erŋn kʼↄ́ny ↄny. Ow it eke ów amua kʼɛy, kↄ ow elm wus e nuŋ ɛdŋ. ");
INSERT INTO adj_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tasi ɛm a, ɛbr nyam ecʼagŋ bʼow im ɛŋn ɛbr ɛjeci nyam ogŋ ar; es ɛw nyam bʼow im ɛŋn es ɛw ɛjeci ar ogŋ eci. Susu nↄnↄ wus bʼow umu ɛtŋ lek yɛji bʼow ɛy. Ów amua fɛŋ bʼow ɛw ɛsɛ iy ↄnyn eci dudu krɛkrɛ ab af. ");
INSERT INTO adj_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Gbɛkↄ ↄny, ↄny obi ↄny obi a, ɛ̀wr ɛrm. Agŋ bʼow ot im ↄny jɛj ok ecʼany af. Wɛl bʼow ↄr ↄny Nyam ŋuŋ igŋ susu. Ɛm e nin a eci daŋku ij sosiɛm, wɛl bʼow ot im ↄny es ɛw ɛsɛl lele ɛ́b ebu ab ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ow it eke krɛkrɛ ɛm a, wɛl kʼↄb Amani Mamn a e kokoba ok ɛbr ɛbr a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ɛtŋ eke wɛl bʼow ot im ↄny jɛj ok ecʼany af a, ɛrmij kʼíkŋ anym kʼok ↄny ow a eke bʼow dadr a eci. Dàdr wanci ab af ecʼa cɛ eke Nyam bʼow ↄŋ ↄny a, aŋke sodad a kʼow anm ↄny ɛm owm, kↄ Abŋ Lala a bʼow dad odad a ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Agŋ lisijimɛl bʼow ot ɛl lisijimɛl lokm ow ibi eci; ey ɛsɛl yɛji bʼow kok ɛbɛn ɛl ecʼey e lís, ey yɛji bʼow ↄbr ɛl ɛsɛl any, ↄŋ wɛl ibi ɛl. ");
INSERT INTO adj_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ɛm sosiɛm, agŋ a fɛŋ bʼow ifn ↄny; gbɛkↄ ɛgŋ eke bʼow inym es kikri toŋ ow e nuŋ ɛdŋ ɛm a, bʼow ɛŋn sel.» ");
INSERT INTO adj_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","«Ke sica bʼow ɛkan “Musue ob iy” anŋ yogŋ ekʼitm eke li kʼanŋ a. (Ke ɛgŋ eke bʼow awl ów amua a, íri sɛnyn sɛnyn.) Ke kpɛkŋ agŋ a eke bʼow anŋ Jude wus af a, ow akpl ke -lʼuru es -nʼim mafɛny ɛm. ");
INSERT INTO adj_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ɛgŋ eke bʼow anŋ in ecʼêl afr e lɛf eb usu a, kʼúsm es ɛym akŋ ocm ob; ");
INSERT INTO adj_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ɛtŋ ɛgŋ eke bʼow anŋ ↄgm a, kʼɛ́wlm iim jam ocm in e mob af ɛw a ij. ");
INSERT INTO adj_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sɛgŋ amua bʼow ɛw tuↄtuↄ molok ab lisɛl lel ɛl ekʼam ↄŋ ey mɛny ab ab eci. ");
INSERT INTO adj_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Nyam ŋↄŋn a át es yecʼɛtŋ ke low na kʼɛ́ym nyam es us ɛm, ");
INSERT INTO adj_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","aŋke sɛgŋ na ɛm a, gbre ij a bʼow ɛw tuↄtuↄ afŋn es. Ow bʼow akm gbre ij fɛŋ ekʼanŋ lɛgŋ a ɛtŋ eke Nyam kok ów a fɛŋ toŋ kʼít yɛfɛnyna ecʼa. Lɛgŋ kaka gbre ij na kʼow anm ij. ");
INSERT INTO adj_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Ɛtŋ blel Ɛs Kↄtↄkↄ isrm sɛgŋ amua ɛm, ke ɛgŋ kaka blel ↄtum anm owr. Lʼisr sɛgŋ amua ɛm agŋ a eke li sↄsum lʼot a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Eke batŋ ɛgŋ nyam bi dad ↄny ɛsɛ: “Ɛ̀kan, Mesi a anŋ aŋa!” oglog: “Nʼanŋ yogŋ a!” kʼùbr ɛgŋ a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Tasi ɛm a, mesiɛl ayadŋu lele kokoba ↄb ɛsɛl ayadŋu ab bʼow ok ↄkm. -Li bʼow -li kok mɛny ɛwr lele ów any iti owi ab agŋ ecʼirmn eci, ke ekʼow it yɛji, -lʼↄtu -lʼirmn agŋ a eke Nyam sↄsum ot a. ");
INSERT INTO adj_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Ɔny ecʼa, ɛ̀wr ɛrm! Mʼikŋ anym mʼɛwar ↄny ów amua fɛŋ eke bʼow ɛy a eci.» ");
INSERT INTO adj_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ɛmɛny Jesu igŋ af ninɛ: «Gbɛkↄ sɛgŋ ab ɛm, eke gbre ij owi na fɛŋ bʼow ɛc ok es a, ligbn bʼow irm es ɛtŋ awl yɛji kʼow afŋm ij. ");
INSERT INTO adj_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Mílɛ́l bʼow ok wus ɛtŋ afr ecʼabusu owi fɛŋ bʼow wuwal. ");
INSERT INTO adj_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Sica yogŋ anake wɛl bʼow ɛkn ɛgŋ ecʼIy eke bʼow anŋ afr e jru ɛm am ow, abusu fɛŋ lele anygbɛl ab a. ");
INSERT INTO adj_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Li bʼow lʼism afr ɛrm ɛsɛl ab, ɛtŋ li bʼow lʼas agŋ a eke li sↄsum lʼot a luku, wus na ecʼↄy yar ab ɛm, toŋ lʼok afr e nuŋ.» ");
INSERT INTO adj_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Sica Jesu dad ninɛ: «Kin low yɛgm ekʼel babm e likŋ a eci eke kʼirir: kpɛkŋ eke in ecʼál a bʼɛw wrↄwrↄ, ke nʼam gigŋ ↄdↄdↄ a, kpɛkŋ bʼuwr any eke mewij ow titm ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ɛbɛn nyam coco eke bʼɛkan ów amua am ow a, ke kpɛkŋ úwr any eke low a titm, ɛtŋ ow bʼow ɛy. ");
INSERT INTO adj_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Low nawrɛ mʼam dad ↄny: yɛfɛnyna ecʼagŋ fɛŋ kʼow uwm uwrm ɛtŋ ów amua bʼow ɛy. ");
INSERT INTO adj_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Afr lele wus ab bʼow ɛc, gbɛkↄ lɛgŋ kaka ɛm e sodad a kʼow ɛcm. ");
INSERT INTO adj_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Gbɛkↄ ów a e lɛgŋ lele wanci ab ab eke bʼow ɛy a, ɛgŋ kaka uwm any, afr ɛrm ɛsɛl yɛji uwm any, ɛgŋ ecʼIy bↄbↄ yɛji uwm any, ekʼow elm ɛm Ɛs sↄny coco. ");
INSERT INTO adj_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɛ̀wr ɛrm! Mɛmn kʼíbi ↄny, aŋke uwmn lɛgŋ ab any. ");
INSERT INTO adj_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ow anŋ ɛsɛ ɛgŋ nyam ekʼaam usu, ke oc in ecʼakŋ a abul in eci juma kok ɛsɛl a ke ↄŋ ɛl ów fɛŋ ecʼabusu af. Nʼↄŋ ɛgŋ nyam nyam eci juma eke ki kok ɛtŋ li dad usu ↄsu ɛs a eke kʼanŋ any owr ke ám ↄsu usu a. ");
INSERT INTO adj_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Ɔ̀sur, aŋke uwmn wanci a ekʼakŋ ɛs a bʼow ɛwl mɛny ow ab any. Ow kʼↄdm ke lʼów ncebles ɛm, ncok eci lɛgŋ uyu nuŋ ɛm, ŋgↄs ikŋ ɛm, oglog ibribr. ");
INSERT INTO adj_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Eke lʼow lʼokr ↄny es kpru, li kʼɛ́ŋn ↄny mɛmn ɛru ɛm. ");
INSERT INTO adj_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Odad na eke mʼam dad ↄny a, agŋ a fɛŋ anake mʼam dad a: Ànŋn any owr!» ");
INSERT INTO adj_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ow anŋ sɛgŋ yony ke Pak lele Futufutu ekʼejru ánm ɛm ecʼes gbɛgbl a e lɛgŋ ɛy. Egb waw ɛsɛl ɛgbɛl lele ol e low yɛgm ɛsɛl ab ab am as luku ↄl elel eke kʼↄnyn Jesu ew ew ɛm ke -lʼibi ow a. ");
INSERT INTO adj_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Gbɛkↄ -nʼam dad ɛl ↄfr ɛm -lʼɛsɛ: «Ow itm eke si kʼↄnyʼn es gbɛgbl na ɛm; ekʼow el ɛbɛn, bↄbar a owi bʼow ɛy bieku ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesu im Betani baŋn, Simↄ a eke lɛgŋ anym ɛm kokobe ok a ecʼakŋ. Eke Jesu anŋ ob ij lↄfu lís a, yↄw nyam ow titmʼn. Nʼↄnym án gbɛl e mijey kↄk nyam eke wɛl kok lebn ɛm ab; lebn na, wɛl bʼɛsŋʼn albatr, ke mijey a el nar tasi ɛm. Nʼↄny lʼↄb es ɛtŋ lʼɛwl lʼok Jesu nuŋ. ");
INSERT INTO adj_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Agŋ a ekʼanŋ yogŋ a eci bɛb erurm ɛtŋ am ɛny abr dad ɛl ↄfr ɛm ɛsɛ: «Kↄ na, ow elm ob ŋuŋn ana ee? ");
INSERT INTO adj_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ow itm eke mijey ikŋ na, wɛl kʼↄl ij os ekŋ yen yen sakp nyahan, oc ow ecʼos a ↄŋ ↄgbↄru ee?» Ɛtŋ -nʼam cak cak yↄw a ɛrm bebl ɛm. ");
INSERT INTO adj_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Gbɛkↄ Jesu dad ninɛ: «Ɛ̀gbr yↄw ab es tiŋ! Kↄ bla ɛtŋ am ijar ir gbre ee? Low na eke li kok ɛm e lís a el low nimamn. ");
INSERT INTO adj_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tasi ɛm a, ↄgbↄru ecʼa, -nʼanŋ ↄny ab sɛgŋ a fɛŋ, lɛgŋ kaka fɛŋ ekʼerurir a, ↄtur eke ki kokr ɛl ów amamn; kↄ ɛm, sɛgŋ a fɛŋ mi kʼow mʼanm ↄny ab. ");
INSERT INTO adj_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Yↄw na kok low yecʼa eke lʼↄtu eke li ki kok a. Lʼikŋ anym lʼokʼm mijey na sos, ɛm ecʼuwↄmu ɛm anŋ a eci. ");
INSERT INTO adj_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Low nawrɛ mʼam dad ↄny, wus na nimum af ecʼusu kaka fɛŋ eke wɛl bʼow ↄb Amani Mamn a eci kokoba a, wɛl bʼow ↄkn yↄw na e low, ke wɛl dád low a eke li kok a yɛji.» ");
INSERT INTO adj_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Sica, jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ nyam eke wɛl bʼɛsŋ Judas Iskariↄt, im ɛŋn egb waw ɛsɛl ɛgbɛl a, ɛtŋ dad ɛl eke kʼↄny Jesu ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Eke -lʼirir odad na a, sos ɛm iŋn ɛl toŋ -lʼɛgŋ -lʼeb eke -li kʼↄŋ ow os. Ow ↄŋ Judas am ↄl akunda sɛnyn yecʼɛm eke li kʼↄny Jesu nʼↄŋ wɛl. ");
INSERT INTO adj_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Futufutu ekʼejru ánm ɛm e lɛgŋ krɛkrɛ eke wɛl bʼibi mɛcɛb Pak ecʼes gbɛgbl ecʼob ij ecʼa, jam ɛsɛl a ibrm Jesu ninɛ: «Kↄ bogŋ am erur eke si kʼim si bɛbm Pak ecʼob ij a e sos ee?» ");
INSERT INTO adj_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ɛtŋ Jesu dad in e jam ɛsɛl ab ɛm ecʼagŋ yony ninɛ: «Ìmn baŋn a, bʼow ↄbar ɛgŋ nyam ekʼuyu mijel. Ùsr ɛgŋ ikŋ na jam, ");
INSERT INTO adj_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ke akŋ yecʼeke li bʼow lʼɛy a, dádr akŋ ɛs a eke low yɛgm agŋ ɛs am ibrm usu a ekʼin eci jam ɛsɛl ab ab ɛl kʼij Pak ecʼob a. ");
INSERT INTO adj_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Li bʼow li yɛgm ↄny êl afr yogŋ, oj gbɛl nyam eke akŋ e mob a fɛŋ iy nɛny ɛm. Yogŋ anake bʼow kokr Pak ecʼob ij a.» ");
INSERT INTO adj_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jam ɛsɛl a im ok baŋn a, ɛŋn fɛŋ a ɛsɛ elel eke Ɛs Kↄtↄkↄ dadr ɛl ab af, ɛtŋ -li bɛbm Pak ecʼob ij a eci sos. ");
INSERT INTO adj_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lɛgŋ es ew ɛm a, Jesu lele jam ɛsɛl lɛw yony ab ab im yogŋ. ");
INSERT INTO adj_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Eke -nʼanŋ ob ij usu ke -nʼam ij ob a, Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: ↄny ɛm ecʼɛgŋ nyam ekʼam ij ob ɛm ab a, bʼow ↄl ijʼm.» ");
INSERT INTO adj_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Jam ɛsɛl a fɛŋ sos ↄw es ɛtŋ ɛgŋ ɛgŋ am ibrmʼn ɛsɛ: «Kↄ ow ↄtu eke kʼel ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Li dad wɛl ninɛ: «Ɔny lɛw yony ab ɛm ecʼɛgŋ nyam, in a ekʼam us abu ɛm ab lↄfu nyam ɛm a. ");
INSERT INTO adj_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ɛɛ, tasi, ɛgŋ ecʼIy bʼow uw ɛsɛ elel eke Nyam Lɛl ɛwar in e lís ab af; gbɛkↄ gbre él ɛgŋ a ekʼam ↄl ijʼr a eci! Ɛgŋ ikŋ na, blel wɛl ewmʼn bↄbↄ yɛji.» ");
INSERT INTO adj_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Eke -nʼam ij ob a, Jesu oc futufutu, lʼɛlu Nyam bia, lʼubr ɛm, nʼↄŋ in e jam ɛsɛl a ɛtŋ li dad ninɛ: «Èbr, na el ɛm e sos megl.» ");
INSERT INTO adj_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ɛmɛny lʼoc mij kpↄk eke mar anŋ ɛm, lʼɛlu Nyam bia, nʼↄŋ in e jam ɛsɛl a; ɛtŋ ɛl fɛŋ -lʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Sica Jesu dad ɛl ninɛ: «Na el ɛm e mebl, Nyam e sinm a e mebl ekʼam ow ok es agŋ nↄnↄ eci. ");
INSERT INTO adj_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Low nawrɛ mʼam dad ↄny: mi kʼow mʼɛgŋm mar na sakp ɛjeci toŋ ke ow él Nyam e gbreŋgbi usu a eci mar owr eke mi kʼɛgŋ.» ");
INSERT INTO adj_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Sica -lʼɛgŋ es gbɛgbl a ecʼɛj ba ow bʼuwr, ɛtŋ -nʼim Olivie lafɛny af. ");
INSERT INTO adj_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jesu am dad in e jam ɛsɛl a ɛsɛ: «Low a eke bʼow ɛŋnʼm a bʼow ok ↄny wus ↄny eci ↄmn ab ɛm. Tasi ɛm a, Nyam Lɛl ab ɛm wɛl nↄn eke mʼow mʼibi mɛcɛb ↄsu ɛs a ɛtŋ mɛcɛb a fɛŋ bʼow ↄmu es. ");
INSERT INTO adj_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Gbɛkↄ ɛm eci uwↄmu ɛm anŋ igb ɛm a, mʼow mʼikŋ anym mʼim Galile mʼeku ↄny.» ");
INSERT INTO adj_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Piɛr dadʼr ninɛ: «Ekʼagŋ a fɛŋ bʼow igŋ ɛlu ŋ es yɛji, ow kʼow elm ɛm gbɛ!» ");
INSERT INTO adj_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jesu dadʼr ninɛ: «Low nawrɛ mʼam dadʼŋ: ncok na cɛ, gbuŋ ke ŋgↄs íkŋ sakp yony a, bʼow ɛgbrʼm sakp nyahan dad eke uwm im any.» ");
INSERT INTO adj_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Kↄ Piɛr am dad lebl tuↄtuↄ ɛm ɛsɛ: «Eke ow it ŋ ab eci luw bↄbↄ yɛji, mi kʼow mʼↄtum mi dadm mʼɛsmɛ mʼuwmʼŋ any.» Ɛtŋ jam ɛsɛl ɛjecʼa yɛji dad ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jesu lele in e jam ɛsɛl ab ab im ok usu nyam eke wɛl bʼɛsŋ Jɛsemane. Jesu dad in e jam ɛsɛl a ninɛ: «Eke mʼaam mi ŋↄŋn Nyam a, òkr es aŋa.» ");
INSERT INTO adj_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɛtŋ lʼɛsŋ Piɛr, Jak lele Jan ab eke kʼim in ab. Sos ↄb nuŋ am ↄwʼr es ɛtŋ ɛrm mij yɛji am okʼr afŋn in es. ");
INSERT INTO adj_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Li dad wɛl ninɛ: «Sos es ↄw ekʼel luw eci afŋn ɛm ecʼabŋ ab es; òkr es aŋa ke ↄ́sur.» ");
INSERT INTO adj_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Lʼɛri nʼim kpekpe tɛl, lʼok ↄwrↄkp wus, lʼubu any es, ɛtŋ nʼam ŋↄŋn Nyam ekʼow it ke gbre ij eci wanci ikŋ na kpábʼr es lís. ");
INSERT INTO adj_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Nʼam dad lʼɛsɛ: «Aba, ɛm Ɛs, ŋ ɛm ów fɛŋ ecʼabusu a anŋ; ↄny gbre e mij kpↄk na kpabʼm es lís. Ke fɛŋ ɛm a, ow kʼél yecʼa eke mʼam erur a, kↄ yecʼa eke ŋ am erur a.» ");
INSERT INTO adj_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɛtŋ lʼow nʼɛŋn jam ɛsɛl nyahan a eke mɛmn ibi. Li dad Piɛr ninɛ: «Simↄ, am ɛru mɛmn! Kↄ wanci nyam bↄbↄ yɛji ↄtum ↄsum ee? ");
INSERT INTO adj_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ànŋn any owr ↄsur ke ŋↄ́ŋan, yecʼɛtŋ ke kʼɛ́ymn ɛbm ɛkn owi ɛm. Ɔny ecʼabŋ a gbɛ inym es low fɛŋ e kok eci, kↄ ↄny e sos megl a gbɛ ijm lɛc ij.» ");
INSERT INTO adj_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ɛmɛny lʼɛwl mɛny nʼim ɛtŋ Nyam ŋↄŋn a el nɛnyɛmbri nyam a cɛ. ");
INSERT INTO adj_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Eke ɛmɛny lʼɛwl mɛny lʼow in e jam ɛsɛl ogŋ a, nʼɛŋan wɛl mɛmn ɛru ɛm. Mɛmn am bↄbm ɛl anyamn; ow ↄŋ -lʼuwmn low yecʼeke -li ki dad Jesu ab any. ");
INSERT INTO adj_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Sakp nyahan ɛm ecʼa eke Jesu ɛwl ow a, nʼam dad in e jam ɛsɛl a lʼɛsɛ: «Am ɛrur mɛmn cɛ ebr sel ee? Sica ow bɛbmn ab ŋ̂! Wanci a eke wɛl bʼow ↄl ɛgŋ ecʼIy ij sikpl ɛsɛl ecʼabu ɛm a, ow ŋ̂. ");
INSERT INTO adj_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ìgbr, sʼímn! Kin, ɛgŋ a eke am ↄl ijʼm a ow titm ŋ̂!» ");
INSERT INTO adj_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesu odad anŋ nɛnym kʼuwrm ɛtŋ kpɛkŋ Judas, jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ nyam ilm any. Agŋ a ekʼow in ab a, ↄnym ekŋ ekpr lele mab ler ɛm ab. Egb waw ɛsɛl ɛgbɛl, ol e low yɛgm ɛsɛl lel agŋ ekpekp ab ab anake ɛrm ɛl a. ");
INSERT INTO adj_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Judas eke bʼow ↄl Jesu ij a, ikŋ anym yɛgm dedeku a akunda yecʼɛm eke -li kʼↄnyn ow a. Li dad ninɛ: «Ɛgŋ a eke mʼow mi joj nɛny a, in ana; ↄnyn in, òcr imn in, ke ↄ́sur ir sɛnyn sɛnyn gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kpɛkŋ eke Judas im titm Jesu a, li dad ninɛ: «Low yɛgm agŋ ɛs!» Ɛtŋ li joj ow nɛny. ");
INSERT INTO adj_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Kpɛkŋ agŋ a okʼr af ↄnyʼn. ");
INSERT INTO adj_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Jam ɛsɛl ab ɛm ecʼɛgŋ nyam ↄdu in e lab ler ɛm a eb, lʼiyr egb waw ɛs ligbɛl a ecʼabu ɛlum ɛs a ɛtŋ lʼubr ow lↄru es. ");
INSERT INTO adj_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jesu ↄdu odad eb ɛtŋ am dad dedeku a ɛsɛ: «Kↄ ɛm eci ↄny a, ibrm eke kʼotr ekŋ ekpr lele mab ler ɛm ab owr, ɛsɛ low ŋuŋ kok ɛs ɛm el af ee? ");
INSERT INTO adj_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Ɔny ab cɛ mʼanŋ sɛgŋ a fɛŋ. Mi bi yɛgm agŋ low Nyamel gbɛl a e gbugŋ ɛtŋ ↄnymnʼm. Gbɛkↄ ow ɛy, yecʼɛtŋ ke Nyam Lɛl ɛm ecʼów a eke wɛl nↄn a íy nɛny.» ");
INSERT INTO adj_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Kpɛkŋ jam ɛsɛl a fɛŋ igŋ Jesu ɛlu es, uru es im. ");
INSERT INTO adj_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ŋgbafrɛ nyam eke gbad ikpr nyam cɛ anŋ sos, am us Jesu jam. Wɛl kʼↄnyʼn, ");
INSERT INTO adj_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","gbɛkↄ lʼigŋ in e gbad a lʼɛlu es, lʼuru es sos ↄfr nʼim. ");
INSERT INTO adj_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Agŋ a oc Jesu im egb waw ɛs ligbɛl a eci gbugŋ a; yogŋ egb waw ɛsɛl ɛgbɛl a fɛŋ, agŋ ekpekp a, lel ol e low yɛgm ɛsɛl ab ab as luku. ");
INSERT INTO adj_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Piɛr anŋ akpoj ɛm am us Jesu jam. Nʼim toŋ lʼɛy egb waw ɛs ligbɛl a eci gbugŋ a. Nʼim nʼɛŋn usu ↄsu ɛsɛl a ɛtŋ li sig es al saw nʼam ↄgbu al. ");
INSERT INTO adj_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Egb waw ɛsɛl ɛgbɛl a lele Sanedrɛn ecʼagŋ ɛjecʼa fɛŋ ab am ↄl daŋku ij nyam eke kʼↄbr Jesu low yecʼɛtŋ ke -lʼibi ow, kↄ -nʼɛŋnmn low kaka. ");
INSERT INTO adj_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tasi ɛm a, agŋ nↄnↄ am ij daŋku yadŋ ɛm Jesu e nuŋ af, kↄ ɛl ↄfr eci daŋku ij ab ɛm yɛji, nɛny ókrm ɛl af. ");
INSERT INTO adj_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Agŋ bɛb igb ɛtŋ am ij daŋku yadŋ ɛm in e nuŋ af dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","«Sʼirir nɛnym li dad ninɛ: “Nyamel gbɛl na ekʼagŋ ecʼabu in us a, in bʼow in ↄny in ɛr in ok; eke owʼn bʼow in ij sɛgŋ nyahan a, in bʼow in us ɛjeci nyam ekʼin elm agŋ ecʼabu ɛm ecʼekʼin us.” » ");
INSERT INTO adj_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Odad na af bↄbↄ yɛji nɛny okrm ɛl af ɛl e daŋku ij ab ɛm. ");
INSERT INTO adj_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Kpɛkŋ egb waw ɛs ligbɛl a igb agŋ a fɛŋ ecʼany af, ɛtŋ am ibrm Jesu ɛsɛ: «Kↄ wɛl ám dad sodad amua okʼŋ af, ke kʼↄ́bm kpu ee?» ");
INSERT INTO adj_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Kↄ Jesu yewal tiŋ; li cicm sar lʼokm ow es. Ɛmɛny egb waw ɛs ligbɛl a am ibrmʼn sakp yony ɛm ɛsɛ: «Kↄ ŋ Mesi, Nyam a eke si bʼigŋ nuŋ a ecʼIy ee?» ");
INSERT INTO adj_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesu ɛgŋ dad ninɛ: «Ɛɛ, mʼel; ɛtŋ ↄny fɛŋ, bʼow ɛkan ɛgŋ ecʼIy eke sig es Nyam abusu Ɛs eci lidr abu af, ke bʼow anŋ afr eci jru ɛm ám ow.» ");
INSERT INTO adj_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Odad na sosiɛm, egb waw ɛs ligbɛl a ↄny in eci simob sus ɛm a gbagbrm ɛm, ɛtŋ dad ninɛ: «Ɛy, sʼibram adaŋku ij! ");
INSERT INTO adj_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ɔny obi yɛji irir eke li dad low ↄbr any owi Nyam e lís. Kↄ ↄny e tutr el bogŋ ecʼee?» Agŋ a fɛŋ ↄb Jesu low ekʼel in ecʼibi eci. ");
INSERT INTO adj_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ɛtŋ ɛm yogŋ ecʼagŋ bɛb am aflʼl sar any. -Nʼawŋ ow any es, -nʼam ↄr ow kukuta ɛm, ɛtŋ -nʼam ibrm ow -lʼɛsɛ: «Tùtr ke úlm ɛgŋ a es!» Ɔbↄwi a ebʼr abu ɛm ɛtŋ am dɛdŋʼn any af. ");
INSERT INTO adj_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ɛtŋ eke Piɛr anŋ wus a gbugŋ yogŋ cɛ a, egb waw ɛs ligbɛl a eci ob oc ↄŋ lisɛl ab e nyam ow, ");
INSERT INTO adj_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ɛtŋ ɛknʼn eke nʼam ↄgbu al. Lʼok any es li lɛr ow sɛnyn sɛnyn ɛtŋ li dad ow ninɛ: «Ŋ yɛji anŋ Nasarɛt e Jesu ab.» ");
INSERT INTO adj_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Kↄ lʼɛgbr li dad ninɛ: «Mi kʼirim sɛnyn sɛnyn; low yecʼa ekʼam ↄl eke ki dad a, mi kʼuwm any.» Nʼimn gbeŋ lisany a eci ɛtŋ ŋgↄs ikŋ. ");
INSERT INTO adj_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ob oc ↄŋ lis a ɛknʼn, ɛtŋ ɛmɛny am dad agŋ a ekʼanŋ yogŋ a ɛsɛ: «Ɛgŋ na, jam ɛsɛl ab ɛm ecʼɛgŋ nyam!» ");
INSERT INTO adj_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Kↄ Piɛr ɛgbr sakp yony ɛm dad ninɛ: «Njaŋ! Kaka!» Ekʼow ibn tɛl a, agŋ a ekʼanŋ yogŋ a, am dad Piɛr ɛsɛ: «Tasi, ŋ jam ɛsɛl ab ɛm ecʼɛgŋ nyam, aŋke ŋ Galile wus af ecʼɛgŋ!» ");
INSERT INTO adj_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Gbɛkↄ Piɛr ↄdu eb dad ninɛ: «Ekʼow el yadŋ mʼam ↄny, ke Nyam kókʼm low ŋuŋ! Mʼam ofn mi dad ekʼɛgŋ na ekʼam dadr in e low a mʼuwmʼn any.» ");
INSERT INTO adj_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Odad na anŋʼn nɛnym nʼam dad ɛtŋ kpɛkŋ, ŋgↄs ikŋ sakp yony ɛm. Ow ↄŋ Piɛr ↄkn low a eke Jesu dadʼr a: «Gbuŋ ke ŋgↄs íkŋ sakp yony a, bʼow dad sakp nyahan eke uwm im any.» Ow sosiɛm, nʼam ikŋ ↄŋn. ");
INSERT INTO adj_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Ibribr fafa ɛm a, egb waw ɛsɛl ɛgbɛl a, agŋ ekpekp a, ol e low yɛgm ɛsɛl a, lel agŋ a fɛŋ ekʼel ɛl e Sanedrɛn ecʼagŋ a, ɛc ok usu nyam eke ki bɛbm low a ucu es. -Nʼↄŋ wɛl ↄny Jesu awŋ ɛtŋ -lʼoc -nʼim -nʼↄŋ ow Pilat. ");
INSERT INTO adj_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat ibrm Jesu ninɛ: «Kↄ ŋ Jwifɛl ecʼɛb ebu ee?» Jesu ↄdu eb ninɛ: «Ŋ obi dad.» ");
INSERT INTO adj_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Egb waw ɛsɛl ɛgbɛl a am dad ów eŋuŋ nↄnↄ ok Jesu af. ");
INSERT INTO adj_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ow ↄŋ ɛmɛny Pilat am ibrm Jesu ɛsɛ: «Kↄ ŋ ↄ́tum dadm low kaka ee? Ɛtŋ kↄ am iri ów amua fɛŋ eke -nʼam dad -lʼokʼŋ af ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Kↄ Jesu dadm low kaka ij, ɛtŋ ow e low iti Pilat any afŋn es. ");
INSERT INTO adj_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Eke sakp sakp fɛŋ Pak ecʼes gbɛgbl e lɛgŋ bʼow a, Pilat bʼɛlu sobel ɛm ɛs nyam eke dedeku a bʼibrm ab es. ");
INSERT INTO adj_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kↄ ɛgŋ nyam eke wɛl bʼɛsŋ Barabas lele lawlɛl ab ab ekʼɛ́gŋm Rom ecʼes ɛw e low ebm a, anŋ sobel ɛm. -Lʼel agŋ ekʼɛl ecʼɛrm bebl ɛm ibi ɛgŋ. ");
INSERT INTO adj_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Dedeku a uyu im ɛŋn Pilat, ɛtŋ am ibrmʼn ɛsɛ: «Kòk low a eke lakpo lakpo fɛŋ bi kok a ↄŋ ɛy.» ");
INSERT INTO adj_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat ɛwl am ibrm ɛl ɛsɛ: «Kↄ am erurir eke mi kʼɛlu Jwifɛl ecʼɛb ebu ab es mʼↄŋ ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tasi ɛm a, lʼuw any eke nyamn ɛyr ɛm egb waw ɛsɛl ɛgbɛl a oc Jesu isʼr. ");
INSERT INTO adj_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Egb waw ɛsɛl ɛgbɛl a am ok dedeku a al ɛm dad ekʼow kʼɛlu Barabas es ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat ɛmɛny am ibrm dedeku a ɛsɛ: «Sica bla lowi mi ki kok ɛgŋ a eke bʼɛsŋn Jwifɛl ecʼɛb ebu ab ee?» ");
INSERT INTO adj_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","-Nʼam ↄg -li dad ow -lʼɛsɛ: «Ɛ̀wʼr olikŋ af!» ");
INSERT INTO adj_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat ibrm ɛl ninɛ: «Kↄ bla low ↄbr iy li kok ee?» Kↄ -nʼam ↄg lebl tuↄtuↄ ɛm -lʼɛsɛ: «Ɛ̀wʼr olikŋ af!» ");
INSERT INTO adj_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat erur eke ki kok dedeku a sos ɛm iŋn; na sosiɛm lʼɛlu Barabas es nʼↄŋ wɛl, ɛtŋ nʼↄŋ wɛl ↄr Jesu say ɛm gbuŋ ɛtŋ lʼɛlu abusu es eke wɛl kʼoc im ɛw ow olikŋ af. ");
INSERT INTO adj_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Srↄda eyŋ a ↄny Jesu ɛlu lakp lokm a ekʼel Pilat e gbugŋ a, ɛtŋ -lʼɛsŋ ɛl lawlɛl likpr a fɛŋ ow. ");
INSERT INTO adj_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","-Li sus ow mob sus ɛm ebl kondoŋ nyam, -li kok mirŋ ɛm tufɛ ɛtŋ -lʼoc -lʼus ow. ");
INSERT INTO adj_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ɛtŋ -nʼam kokr ow miyɛr -lʼibrm ow -lʼɛsɛ: «Sʼam ɛsŋnʼŋ o, Jwifɛl ecʼɛb ebu!» ");
INSERT INTO adj_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","-Lʼoc likŋni -nʼam ↄr ow nuŋ nuŋ, -nʼam fafl ow sar any, ɛtŋ -nʼam kok nyandrɛ -lʼok ↄwrↄkp wus ow ecʼany af. ");
INSERT INTO adj_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Eke -li kokar ow miyɛr bake ow uwr a, -nʼↄny mob sus ɛm ebl kondoŋ a -lʼoc ow es, ɛtŋ -lʼɛwl mɛny -lʼot ow e mob tasi a -li sus ow. Ɛtŋ sica -nʼↄny -lʼɛlu ow gbeŋ -nʼam oc -nʼim -lʼɛw ow olikŋ af. ");
INSERT INTO adj_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Sica eke -nʼanŋn ejagb af -nʼaam a, -lʼↄbr Simↄ, Sirɛn baŋn iy nyam ekʼel Alesandr lele Rufus ab ecʼɛl ɛs ekʼanŋ akp ɛm am ow, ɛtŋ srↄda eyŋ a ↄnyʼn lɛc ɛm eke li kʼabum Jesu olikŋ. ");
INSERT INTO adj_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","-Nʼↄny Jesu -nʼim usu nyam eke wɛl bʼɛsŋ Gↄlgota ekʼel nyandrɛ ɛm “Nuŋ kpↄk ecʼusu”. ");
INSERT INTO adj_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yogŋ srↄda eyŋ a wuwlm mar lele kpey ab ↄŋ Jesu eke kʼɛgŋ, kↄ lʼɛgŋm lʼebm. ");
INSERT INTO adj_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","-Lʼɛw Jesu olikŋ af ɛtŋ -li cɛc ow eci mob sus ɛm a sↄsum oc kok ɛm, -lʼuw ɛgŋ ɛgŋ ecʼekʼɛbm ab any. ");
INSERT INTO adj_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ibribr e wanci libarm af anake -lʼɛwr ow olikŋ af a. ");
INSERT INTO adj_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ɛtŋ ligↄg log nyam eke wɛl nↄn aru in ecʼolikŋ a, am yɛgm low a nuŋ af eke wɛl ↄbʼr low luw ecʼa. Odad a el: “Ɛgŋ na el Jwifɛl ecʼɛb ebu.” ");
INSERT INTO adj_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yogŋ cɛ -lʼok ów eŋuŋ kok ɛsɛl yony yɛji olikŋ af; nyam anŋ Jesu lidr abu af, ɛtŋ nyam anŋʼn nɛmn abu af.  ");
INSERT INTO adj_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Nɛnɛ anake Nyam Lɛl ecʼa e dad a iy nɛny a: Wɛl awlʼl ów eŋuŋ kok ɛsɛl ecʼaraŋn. ");
INSERT INTO adj_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Agŋ ekʼam ɛcr yogŋ ecʼa, am ɛgŋn nuŋ ɛm wɛwrʼr ɛtŋ am dadʼr ɛsɛ: «Ŋ ekʼam erur eke kʼufŋ Nyamel ab es ke sɛgŋ nyahan kpɛŋ ús ɛjecʼa, ");
INSERT INTO adj_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","èbr ŋ sosi, ànŋ olikŋ af yogŋ us es!» ");
INSERT INTO adj_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ɛtŋ egb waw ɛsɛl ɛgbɛl a, lel ol e low yɛgm ɛsɛl ab ab yɛji am kokrʼr miyɛr dadarir ɛl ↄfr ɛm ɛsɛ: «Lʼeb agŋ ɛjeci lʼɛlu es, ɛtŋ lʼↄ́tum eke li kʼebr in sosi! ");
INSERT INTO adj_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Ke Mesi ikŋ na ekʼel Israɛl ecʼɛb ebu a, ánŋ olikŋ af aŋa us es, ke sʼɛ́kn, ke sʼúbʼr nawrɛ tasi.» Ɛtŋ ów eŋuŋ kok ɛsɛl eke wɛl ɛw olikŋ af in ab a yɛji am wɛwrʼr. ");
INSERT INTO adj_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Sica lɛgŋ uyu nuŋ ɛm a, ncebn ɛy wus a nimum af toŋ ok ncebles e wanci nyahan ɛm. ");
INSERT INTO adj_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ncebles e wanci nyahan ɛm a, Jesu barm lebl tuↄtuↄ ɛm ninɛ: «Eloi, Eloi, lama sabaktani?» (ekʼel nyandrɛ ɛm: “Ɛm e Nyam, ɛm e Nyam, kↄ bla ɛtŋ digŋ ɛluʼm es ee?”) ");
INSERT INTO adj_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Agŋ nyam nyam ekʼanŋ yogŋ a iri odad na ɛtŋ dad ninɛ: «Ìrir, nʼam ɛsŋ Eli!» ");
INSERT INTO adj_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ɛtŋ ɛl ɛm ecʼɛgŋ nyam uru es im oc mbra usm ɛl eci mar ab ɛm, oc ujr likŋni nyam ɛm ɛtŋ oc am ↄkŋ Jesu ekʼɛgŋ. Ɛtŋ li dad ninɛ: «Sʼɛ́wr nyamn es sʼɛkan ekʼEli bʼow ↄny usmʼn es olikŋ na af!» ");
INSERT INTO adj_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ɛtŋ eke Jesu barm lebl ligbɛl nyam a, lʼok sel es. ");
INSERT INTO adj_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wanci ab af cɛ Nyamel ab ɛm eci gbad gbɛl gbada a eke wɛl ɛw ɛdŋn usu lala ab any a, igŋ afr ɛm a ɛtŋ agbr ɛm araŋn didi toŋ ok esr ɛm a. ");
INSERT INTO adj_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Rom e srↄda eyŋ a eci anym ɛs a ekʼↄbr Jesu any a, ɛkn luw a ecʼelel eke ɛcr ɛtŋ li dad ninɛ: «Njɛ tasi ɛgŋ na Nyam ecʼIy!» ");
INSERT INTO adj_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ɔyↄw bɛb yɛji anŋ yogŋ ɛtŋ am lɛr low a akpoj ɛm. Ɛl ɛm a, Mari, Magdala baŋn yↄwi a, Salome lele Mari, Jak likekli lele Jose ecʼɛl lis ab anŋ. ");
INSERT INTO adj_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ɔyↄw amua na, Galile ɛtŋ -li bʼus Jesu jam ɛtŋ -li bi kok ow e lís e low fɛŋ. Ɔyↄw nↄnↄ bɛb yɛji eke us Jesu jam ow Jerusalɛm a, anŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Sica eke lɛgŋ ew es a, Josɛf, Arimate baŋn iy a, am ow. Lʼel Jwifɛl e Sanedrɛn ab ɛm ecʼany ɛs nyam ekʼin yɛji am eku ↄmn ɛm, Nyam e gbreŋgbi usu a e mowrer e low. Ow el nɛnɛgŋ e sos bɛbm e lɛgŋ, ekʼel lɛgŋ e wɛl bʼɛŋn gbuŋ ke nɛnɛgŋ bʼɛy wus a. Na sosiɛm lʼoc lokm susu ɛm, nʼim nʼɛŋn Pilat ɛtŋ lʼibrm ekʼow kʼoc Jesu e sos megl a ↄŋʼn. ");
INSERT INTO adj_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat low iti any eke Jesu kʼuw fafa. Na sosiɛm lʼɛsŋ Rom e srↄda eyŋ eci nyimn ɛs ligbɛl a ow ɛtŋ lʼibrm ow eke Jesu uw ow ibn. ");
INSERT INTO adj_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sica eke Pilat iri ɛgŋ ligbɛl a nɛnym a, nʼↄŋ Josɛf abusu eke kʼim oc Jesu e sos megl a. ");
INSERT INTO adj_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Josɛf im ↄl gbad ufu nimamn nyam, lʼow nʼↄny Jesu e sos megl a lʼusm es olikŋ ab af, lʼoc gbad ufu a li wiwrm ow ab ɛtŋ lʼoc nʼim lʼoc ow es uwↄmu lob nyam eke wɛl nʼↄŋ ur ab ɛm. Ɛtŋ li wuwl lebn ligbɛl nyam lʼow lʼabl ow ecʼɛm ɛy usu ab es. ");
INSERT INTO adj_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari, Magdala baŋn yↄwi a, lele Mari, Jose lis ab, am lɛr yogŋ a eke wɛl am ɛw Jesu a. ");
INSERT INTO adj_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Eke nɛnɛgŋ e lɛgŋ a ɛcʼa, Mari, Magdala baŋn yↄwi a, Salome lele Mari, Jak lis ab, ↄl mun sŋↄsŋↄ eke kʼim ok Jesu e sos megl ab af. ");
INSERT INTO adj_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Dimas eci ibribr fafa eke ligbn am ɛy ↄkm a, -lʼigb -nʼaam uwↄmu ab af. ");
INSERT INTO adj_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","-Nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Kↄ bwo ecʼɛgŋ bʼow wuwl lebn na ekʼanŋ uwↄmu a ecʼɛm ɛy usu a oc es ↄŋ ɛy ee?» ");
INSERT INTO adj_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Gbɛkↄ eke -li bʼigbl any ogŋ -li lɛr a, -lʼɛkn eke lob a oc es anŋ saw ɛm. ");
INSERT INTO adj_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","-Nʼim -lʼok uwↄmu ab ɛm, ɛtŋ -lʼɛkn ŋgbafrɛ nyam eke sig es lidr ogog a, sus mob ufu kpaakp, ɛtŋ ↄyↄw a erŋn ligbɛl am ↄny. ");
INSERT INTO adj_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Gbɛkↄ ŋgbafrɛ a dad ɛl ninɛ: «Erŋn kʼↄ́ny ↄny; am ↄↄl Nasarɛt e Jesu a eke wɛl ɛw olikŋ af a; lʼigb agŋ ekʼuw ab ɛm, nʼanm aŋa. Lɛ̀ɛr yogŋ a eke wɛl ɛwʼr a. ");
INSERT INTO adj_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Sica ìmn ke dádr jam ɛsɛl likpr a lele Piɛr ab eke in am ikŋ ↄny anym in im in eku ↄny Galile; yogŋ anake ↄny bʼow ↄny ɛkan in ɛsɛ elel eke in dad ↄny ab af a.» ");
INSERT INTO adj_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ɔyↄw a ok ↄkm uwↄmu ab ɛm ɛtŋ es uru ɛm eb ejagb aam, aŋke sos am ufŋ ɛl, ɛtŋ erŋn am ↄny ɛl. -Li dadm ɛgŋ kaka low a, aŋke erŋn a afŋn ɛl es.  ");
INSERT INTO adj_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Eke sica Jesu igb luw ɛm a, nɛnɛgŋ e lɛgŋ krɛkrɛ a eci ibribr fafa a, lʼikŋ anym li yɛgm Mari, Magdala yↄwi a ekʼow ɛm lʼogŋ abŋ eŋuŋ lↄbŋ a sos. ");
INSERT INTO adj_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Kpɛkŋ Mari im ɛŋn jam ɛsɛl likpr a ekʼanŋ sos es ↄw ɛm ke am ikŋ ↄŋn a, ɛtŋ li dad wɛl low a fɛŋ eke lʼɛkn a. ");
INSERT INTO adj_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Li dad agŋ a ninɛ: «Jesu anŋ owr, mʼɛknʼn!» Kↄ eke -lʼirir odad na a, -lʼubm ow nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ow e jam a, Jesu ɛlu sos ↄkm akunda ɛjecʼɛm, yɛgm jam ɛsɛl yony ekʼus ejagb aam kpukpu ɛm a. ");
INSERT INTO adj_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","-Lʼɛwl mɛny -lʼow, ɛtŋ -lʼotar ow e low akr -lʼok jam ɛsɛl likpr a, kↄ ɛl yɛji wɛl ubm ɛl nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Sica eke jam ɛsɛl lɛw nyam a am ij ob a, Jesu ɛlu sos ↄkm yɛgm ɛl; ɛtŋ nʼam ɛnym wɛl abr ɛl ecʼↄmn eke -nʼↄnym a lele ɛl ecʼɛrm tuↄtuↄ ab ab sosiɛm, aŋke wɛl ɛgŋm ubm agŋ a ekʼɛkn in ecʼowr anŋ a e low a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ɛtŋ li dad wɛl ninɛ: «Ìmn wus na nimum af ke ↄ́br Amani Mamn a e kokoba okr agŋ fɛŋ. ");
INSERT INTO adj_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɛgŋ yecʼeke bʼow ↄny ↄmn ke wɛl bʼow ok mij nuŋ a, li bʼow nʼɛŋn sel; gbɛkↄ ɛgŋ yecʼeke kʼow ↄnym ↄmn a, Nyam bʼow ↄbʼr low luw eci. ");
INSERT INTO adj_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Agŋ a eke bʼow ↄny ↄmn a, kin mɛny ɛwr eke bʼow ok ↄkm: -li bʼow -lʼogŋ abŋ eŋuŋ ɛm e nin ɛm; -li bʼow -lʼɛbr sɛbr ɛjeci; ");
INSERT INTO adj_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","eke -nʼↄny lorŋn abu ɛm, ɛtŋ -lʼɛgŋ ob kaka fɛŋ eke wɛl ok ob ŋuŋ ɛm yɛji, ow kʼow kokm ɛl low kaka; -li bʼow -lʼat ↄ́lu abu nuŋ ɛtŋ wɛl bʼow ewl.» ");
INSERT INTO adj_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Sica eke Ɛs Kↄtↄkↄ Jesu dad ɛl odad bake ow uwr a, nʼim afr ɛtŋ li sig es Nyam e lidr abu af. ");
INSERT INTO adj_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Jam ɛsɛl a im ɛtŋ am ↄb Amani Mamn a e kokoba susu a fɛŋ. Ɛs Kↄtↄkↄ am ɛlum ɛl abu ɛl e juma kok ab ɛm, ɛtŋ mɛny ɛwr fɛŋ eke -nʼam ɛlu ↄkm a, am yɛgm ekʼɛl ecʼodad a el nawrɛ tasi.");
INSERT INTO adj_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","2","Ɛgŋ gbɛl Teofil mamn, agŋ nↄnↄ gbɛl nↄn ów amua eke ɛy ɛy ɛm a ɛsɛ elel eke agŋ a ekʼɛkn low a nuŋ ↄb ɛm ɛtŋ, ke Nyam ↄŋ eke ki dad ɛy in ecʼodad a dad ɛy ab af. ");
INSERT INTO adj_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Na sosiɛm ɛgŋ gbɛl Teofil, ɛm yɛji mʼotar low a ekʼɛy nuŋ ↄb ɛm ɛtŋ a akr, ɛtŋ mʼerur eke mi ki nↄn mʼↄsŋm es mʼↄŋʼŋ ɛsɛ elel eke mʼɛŋan ab af, ");
INSERT INTO adj_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","yecʼɛtŋ ke úw any eke low yɛgm a ekʼɛŋn a el nawrɛ tasi. ");
INSERT INTO adj_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Lɛgŋ a eke Erↄd el Jude wus af ecʼɛb ebu a, Nyam ecʼegb waw ɛs nyam anŋ eke wɛl bʼɛsŋ Zakari, ke el Abia ecʼeb ɛm ecʼegb waw ɛsɛl a ecʼɛgŋ nyam. Wɛl bʼɛsŋ ɛy a Elisabɛt, egb waw ɛsɛl ecʼɛl lagŋ Arↄn ecʼeb ɛm e yↄw. ");
INSERT INTO adj_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ɛl yony mum -lʼij nɛnyɛmbri nyam Nyam ecʼany af, ɛtŋ -li bʼɛlum Ɛs Kↄtↄkↄ e sol a sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Kↄ -lʼewm iy kaka, aŋke Elisabɛt el itr yↄw ɛtŋ ɛl yony mum -lʼel agŋ ekʼusu nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","9","Lɛgŋ nyam, Zakari am kok egb waw ɛs e juma Nyam ecʼany af. Ow el ɛl ecʼeb a e lɛgŋ, ɛtŋ in anake sↄsum oc ɛyʼr af a. Ow sosiɛm nʼim lʼɛy Ɛs Kↄtↄkↄ e Nyamel gbɛl a e Nyam ŋↄŋn usu lala a eke li ki waw egb ogŋ ɛm, ɛsɛ elel eke egb waw ɛsɛl bi kok ab af. ");
INSERT INTO adj_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Dedeku a fɛŋ anŋ gbeŋ am ŋↄŋn Nyam wanci a eke wɛl am ofŋ ogŋ a. ");
INSERT INTO adj_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Eke Zakari ɛy yogŋ a, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ɛlu sos ↄkm yɛgmʼn; nʼinym es egb waw usu a e lidr ogog a eke wɛl bi kok ogŋ ecʼegb waw a. ");
INSERT INTO adj_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Eke Zakari bʼɛknʼn a, lʼikprm es ɛtŋ erŋn am ↄnyʼn. ");
INSERT INTO adj_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Kↄ afr ɛrm ɛs a dadʼr ninɛ: «Zakari, kʼùru erŋn, aŋke Nyam iri ŋ e ŋↄŋn ebl a. Ayŋ Elisabɛt bʼow ew iy igŋ nyam ↄŋʼŋ, ɛtŋ bʼow ɛwʼr nin Jan. ");
INSERT INTO adj_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Ow bʼow el ŋ ecʼehe ligbɛl, ɛtŋ agŋ nↄnↄ gbɛl sos ɛm bʼow iŋn in e mew a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Li bʼow lʼel ɛgŋ ligbɛl Ɛs Kↄtↄkↄ ecʼany af. Li kʼow lʼɛgŋm mar fɛŋ eke bʼↄny ɛgŋ a. Lis e lokm ɛtŋ li bʼow nʼɛŋn Abŋ Lala. ");
INSERT INTO adj_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Li bʼow lʼɛsŋ Israɛl ecʼagŋ nↄnↄ eke digŋ Nyam ecʼejagb mamn a ɛlu es a ow Ɛs Kↄtↄkↄ ɛl e Nyam a ogŋ. ");
INSERT INTO adj_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Li bʼow nʼɛŋn Abŋ Lala ɛsɛ Nyam e kokoba ↄb ɛs Eli ecʼab af. Ɛtŋ Abŋ a bʼow ↄŋʼn lɛc lʼɛy ↄkm Nyam ecʼany af, ke li dád ey lele ɛl ɛsɛl ab okr ɛm. Li bʼow nʼↄŋ low ↄbr any ɛsɛl tutr ów ɛsɛ ɛsɛwru nɛnyɛmbri nyam ɛsɛl af. Nɛnɛ anake li bʼow li bɛbm agŋ sos Ɛs Kↄtↄkↄ ecʼeb ecʼa.» ");
INSERT INTO adj_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Eke afr ɛrm ɛs a dad ɛbɛn a, Zakari yɛji dadʼr ninɛ: «Kↄ ayaf mʼow mʼuw any eke low na el nawrɛ ee? Tasi ɛm a, ɛm lele ɛm ɛy ab sʼusu.» ");
INSERT INTO adj_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ɛtŋ ɛrm ɛs a dadʼr ninɛ: «Ɛm Gabriɛl. Mi bʼanŋ Nyam ecʼany af mi kok in e juma; lʼɛrmʼm eke mi kʼow mʼↄŋʼŋ amani mamn na. ");
INSERT INTO adj_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ɛtŋ ɛm ecʼodad na bʼow iy nɛny eke ow bʼow sig ow e lɛgŋ a, kↄ ubm nawrɛ. Na sosiɛm bʼow el ɛbrm, kʼow dadm odad toŋ bake ow ít lɛgŋ eke low a bʼow ɛy ɛkn ŋ e nyamn ɛm a.» ");
INSERT INTO adj_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Agŋ a fɛŋ ekʼanŋ yogŋ am eku Zakari a, low am iti any aŋke nʼam ibn Nyam ŋↄŋn usu a. ");
INSERT INTO adj_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Kↄ eke lʼɛy ↄkm Nyam ŋↄŋn usu yogŋ a, lʼↄ́tum eke li ki dad wɛl odad, ɛtŋ agŋ a uw any eke lʼɛkn low nyam. Nɛny ablʼl es lʼel ɛbrm, ɛtŋ nʼam dad wɛl odad sabu ɛm sabu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Eke Zakari uwar in e sɛgŋ a eke li kʼanŋ Nyamel gbɛl ab ɛm li kok juma a, lʼɛwl mɛny nʼim gbugŋ. ");
INSERT INTO adj_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Gbugŋ e nʼim a, eke sɛgŋ bɛb bʼɛc a, ɛy Elisabɛt anŋ lok ab, ɛtŋ nʼanŋ akŋ sos ↄsu ɛm toŋ ij awl yen, ɛtŋ nʼam dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«Kin ow eke Ɛs Kↄtↄkↄ kok ↄŋʼm; lʼerur eke li kʼↄŋʼm iy mʼew, ocʼm ɛ́s es agŋ ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Eke Elisabɛt e lok a ij awl nↄhↄn a, Nyam ɛrm in ecʼafr ɛrm ɛs Gabriɛl, Galile eci baŋn nyam eke wɛl bʼɛsŋ Nasarɛt, ");
INSERT INTO adj_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","dedyↄwli nyam ekʼuwm igŋ any ogŋ. -Lʼel ɛb ebu David ecʼeb ɛm eci yↄw eke wɛl bʼɛsŋ Mari. In eci igŋ ekʼɛsuʼr a Josɛf. ");
INSERT INTO adj_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Afr ɛrm ɛs a im ɛŋnʼn ɛtŋ ɛsŋn in dad ninɛ: «Sos ɛm íŋnʼŋ! Nyam ↄŋʼŋ bibm, ɛtŋ nʼanŋ ŋ ab!» ");
INSERT INTO adj_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Odad na ↄŋ Mari ikprm es ɛtŋ am ibrm in sosi ɛsŋn akpasu na e nyandrɛ. ");
INSERT INTO adj_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Na ɛm a, afr ɛrm ɛs a dadʼr ninɛ: «Mari, kʼùru erŋn, aŋke ɛŋn Nyam ecʼↄwrↄ. ");
INSERT INTO adj_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Bʼow anŋ lok ab ew iy igŋ nyam ɛtŋ bʼow ɛwʼr nin Jesu. ");
INSERT INTO adj_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Li bʼow lʼagb ɛtŋ wɛl bʼow ɛsŋʼn Nyam ekʼanŋ afr usu kpekpe ecʼIy. Ɛtŋ Ɛs Kↄtↄkↄ Nyam bʼow oc lagŋ David ecʼes ɛw lɛkpn a ↄŋʼn, ");
INSERT INTO adj_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ɛtŋ li bʼow lʼɛw Israɛl ecʼagŋ ab es sɛgŋ fɛŋ, ɛtŋ in ecʼes ɛw a kʼow ↄnym uwr.» ");
INSERT INTO adj_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Kↄ Mari dadʼr ninɛ: «Ɛm eke mʼel dedyↄwli eke kʼuwm igŋ any a, ayaf low na bʼow eel ee?» ");
INSERT INTO adj_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ɛtŋ afr ɛrm ɛs a dadʼr ninɛ: «Abŋ Lala bʼow owʼŋ af, ɛtŋ Nyam ekʼanŋ afr kpekpe e lↄw a bʼow uburʼŋ es. Na sosiɛm, iy eke bʼow ew a, wɛl bʼow ɛsŋʼn Nyam ecʼIy lala. ");
INSERT INTO adj_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ɛ̀kn! Elisabɛt ekʼel ŋ ecʼakŋ e yↄw a anŋ iy igŋ nyam e lok ab, in e susu ɛm. -Li bʼɛsŋ ow itr yↄw, ɛtŋ kin eke sica nʼanŋ lok ab ow ij awl nↄhↄn, ");
INSERT INTO adj_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","aŋke low kaka ↄtum eke kʼakm Nyam.» ");
INSERT INTO adj_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ɛtŋ Mari dad ninɛ: «Mʼel Ɛs Kↄtↄkↄ ecʼadyↄw, ke ow él ɛsɛ elel eke dad ab af.» Ɛtŋ afr ɛrm ɛs a ɛluʼl es im. ");
INSERT INTO adj_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Sɛgŋ ab ɛm a cɛ eke low na ɛc a, Mari ogŋ es im Jude eci baŋn nyam ekʼanŋ lafɛny af. ");
INSERT INTO adj_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Eke nʼim a, lʼɛy Zakari e gbugŋ a ɛtŋ lʼɛsŋn Elisabɛt. ");
INSERT INTO adj_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Kpɛkŋ eke Elisabɛt bʼiri in ecʼɛsŋn a, iy a eke anŋʼn lokm a mumu, ɛtŋ Elisabɛt ɛŋn Abŋ Lala. ");
INSERT INTO adj_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Kpɛkŋ li barm lebl tuↄtuↄ lʼɛsŋn Mari li dad ninɛ: «Nyam ɛdŋʼŋ ↄwrↄ akm ↄyↄw fɛŋ, ɛtŋ in ecʼↄwrↄ a bʼow anŋ iy a eke bʼow ew ab af! ");
INSERT INTO adj_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kↄ bwo elʼm, ɛtŋ Ɛs Kↄtↄkↄ e lis kʼow ɛm ogŋ ee? ");
INSERT INTO adj_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kↄ kin, kpɛkŋ eke mi bʼiri ŋ ecʼɛsŋn a e lebl a, iy a ekʼanŋʼm lokm a mumu sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ehe él ŋ eci, aŋke ub nawrɛ eke Ɛs Kↄtↄkↄ ecʼodad eke wɛl dadʼŋ a, bʼow iy nɛny!» ");
INSERT INTO adj_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Eke Elisabɛt dad ɛbɛn ba bʼok es a, Mari am kↄklm Nyam dad ɛsɛ: «Ɛm e liy am kↄklm Ɛs Kↄtↄkↄ, ");
INSERT INTO adj_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ɛtŋ ɛm ecʼabŋ sos ɛm am iŋn Nyam, ɛm ecʼEb Ɛs ɛm; ");
INSERT INTO adj_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","aŋke lʼerur eke li kʼis any li lɛrʼm, ɛm, in ecʼadyↄwli. Ɛɛ, sica gbɛ wus na ecʼagŋ fɛŋ bʼow dadʼm eke mʼel ehe lis, ");
INSERT INTO adj_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","aŋke Nyam Abusu Ɛs kokʼm ów amamn ɛgbɛl: in e nin a el lala, ");
INSERT INTO adj_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","In e sↄrŋ ikŋ a bʼow anŋ alaw alaw, agŋ eke bʼɛlumʼn a eci. ");
INSERT INTO adj_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Lʼɛlu in ecʼabusu a e lɛc ↄkm ɛtŋ lʼogŋ es ɛfuu, ɛrm tuↄtuↄ ɛsɛl nʼↄmun es, ");
INSERT INTO adj_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","lʼitr ɛ́b ebu ɛl e mɛkpn af lʼok wus, ɛtŋ nʼↄny ɛrm frↄrↄ ɛsɛl lʼigbl ogŋ. ");
INSERT INTO adj_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Lʼiyr ámnu lok ɛtŋ lʼogŋ egbreŋgbi im abu ↄfr. ");
INSERT INTO adj_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Lʼɛlum in e juma kok ɛs Israɛl abu, lʼↄkn in e sↄrŋ ikŋ a ekʼanŋ godo godo fɛŋ ");
INSERT INTO adj_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ɛsɛ elel eke lʼɛwar ɛy ɛsɛl, Abraham lele in ecʼalaw alaw ab af a.» ");
INSERT INTO adj_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ɛtŋ Mari anŋ Elisabɛt ab ij awl nyahan, ɛtŋ ɛwl mɛny im baŋn. ");
INSERT INTO adj_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Eke sɛgŋ ɛc a, lɛgŋ a eke Elisabɛt kʼew in ecʼiy a ow, ɛtŋ lʼew iy igŋ nyam. ");
INSERT INTO adj_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Elisabɛt ecʼakŋ a lele agŋ a eke -lʼiir -li titmnin ab ab iri eke Ɛs Kↄtↄkↄ ɛlu in ecʼɛrm mamn ↄkm in e lís, ɛtŋ -nʼam kok sos ɛm iŋn ow ab. ");
INSERT INTO adj_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Eke lʼew iy a bake ow ij sɛgŋ niwn a, -lʼoc -lʼow ow eke wɛl kʼubr ow likr es. Ow ɛm a, -lʼerur eke wɛl kʼɛw iy a Zakari ekʼel ɛs e nin a; ");
INSERT INTO adj_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","kↄ lis dad ninɛ: «Njaŋ, wɛl bʼow ɛsŋʼn Jan.» ");
INSERT INTO adj_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Ɛtŋ -li dad ow ninɛ: «Ŋ ecʼakŋ a, ɛgŋ kaka ijm nin na.» ");
INSERT INTO adj_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ɛtŋ -nʼam ibrm iy ɛs a sabu ɛm, eke -li kʼuw elel eke li kʼɛwr ow nin any. ");
INSERT INTO adj_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zakari ibrm ob eke li ki nↄn af; wɛl ↄŋʼn, ɛtŋ ni nↄn: «In e nin a, Jan.» Low na iti ɛl fɛŋ any. ");
INSERT INTO adj_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ɛtŋ kpɛkŋ Zakari nɛny lele anm ab kpab es, ɛtŋ nʼam kↄklm Nyam lebl gege. ");
INSERT INTO adj_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Agŋ a fɛŋ ekʼir ɛlul ɛl ɛm a erŋn am ↄny, ɛtŋ Jude mafɛny e wus ab af ecʼagŋ a fɛŋ yɛji iri ów amua ɛtŋ am dad okarir ɛl ↄfr. ");
INSERT INTO adj_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Agŋ a fɛŋ ekʼiri low na a am tutr ów ɛrm ɛm dad ɛsɛ: «Kↄ iy na, bla li bʼow lʼel ee?» Ow ɛm a, agŋ a fɛŋ uw any eke Ɛs Kↄtↄkↄ ecʼabu a anŋʼn af. ");
INSERT INTO adj_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Eke ów amua ɛc a, Zakari, iy ɛs a, ɛŋn Abŋ Lala ɛtŋ nʼam ↄb kokoba li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Wɛl kↄ́klm Ɛs Kↄtↄkↄ Israɛl e Nyam, aŋke lʼoc in ecʼany li lɛr in ecʼagŋ ɛtŋ li sↄg wɛl. ");
INSERT INTO adj_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Lʼɛlu Eb Ɛs Abusu Ɛs nyam ↄkm nʼↄŋ ɛy, in e juma kok ɛs ɛb ebu David ecʼalaw ɛm. ");
INSERT INTO adj_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Na anake lʼɛwar lɛgŋ kpekpe ɛm ɛtŋ, in e kokoba ↄb ɛsɛl lala ɛm a. ");
INSERT INTO adj_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Lʼɛwar eke li bʼow li sↄg ɛy ɛy ecʼefnu ecʼabu ɛm lele agŋ a fɛŋ ekʼam ifn ɛy a ecʼabusu a e lís ab. ");
INSERT INTO adj_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɛbɛn eke lʼɛlu in ecʼɛrm mamn ↄkm ɛy ɛsɛl e lís, ke lʼↄkn in e sinm lala a yɛji ana. ");
INSERT INTO adj_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Tasi ɛm a, Nyam ɛwar ɛy lagŋ Abraham nɛny ij ɛm, ");
INSERT INTO adj_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","eke kʼeb ɛlu ɛy es, ɛy ecʼefnu ecʼabu ɛm, ke nʼↄ́ŋ ɛy abusu sʼigŋʼn nuŋ, si kók in e juma ɛrm susu ɛm; ");
INSERT INTO adj_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","yecʼɛtŋ ke sʼél agŋ amamn ów tutr ɛm lele nɛny nyam ij ɛm ab in ecʼany af, ɛy ecʼowr anŋ ɛm sɛgŋ fɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ɛtŋ ŋ, ɛm ecʼiy, wɛl bʼow ɛsŋʼŋ Nyam ekʼanŋ afr kpekpe e kokoba ↄb ɛs, eke bʼow an es Ɛs Kↄtↄkↄ ecʼany af kok in ecʼejagb, ");
INSERT INTO adj_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ke yɛ́gm in ecʼagŋ uw sel ɛŋn any, ke lʼóc sikpl lʼap wɛl. ");
INSERT INTO adj_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ɛy e Nyam a el ɛrm mamnu, low mamn Ɛs. Ow sosiɛm li bʼow lʼɛjn afr ecʼusuayl a lʼok ɛy af, ɛsɛ ligbn eke bʼɛy ↄkm am ow af, ");
INSERT INTO adj_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ke lʼáyal agŋ ekʼanŋ ncebn ɛm luw ecʼabusu e gbre ij ɛm, ke ni nyímn ɛy e lakr ecʼes an, ɛrm es ɛy ecʼejagb ab af.» ");
INSERT INTO adj_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Iy a am agb ɛtŋ am ↄny lɛc abŋ ɛm. Ɛtŋ lʼir loj toŋ batŋ ow sig lɛgŋ a eke lʼↄb nuŋ nʼam kok Nyam e juma Israɛl eyŋ ecʼany af a. ");
INSERT INTO adj_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Lɛgŋ ab ɛm a, Sesar Ogust ↄŋ abusu eke wɛl kʼawl ɛb a fɛŋ ekʼanŋ Rom ecʼes ɛw ɛm a ecʼagŋ a. ");
INSERT INTO adj_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Krɛkrɛ ɛm ecʼagŋ awl na ɛy lɛgŋ a eke Kirinus el Siri wus af ecʼes ɛw ɛs a. ");
INSERT INTO adj_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Agŋ a fɛŋ aam wɛl áwl ɛl, ɛgŋ ɛgŋ in e baŋn. ");
INSERT INTO adj_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Josɛf igb Nasarɛt baŋn Galile wus af im Bɛtlehɛm, Jude wus af ekʼel ɛb ebu David e baŋn a. Nʼim yogŋ aŋke in yɛji lʼel David e lilaw. ");
INSERT INTO adj_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Lʼoc Mari ekʼel in e yↄw eke lʼɛsu ke anŋ lokab ab ab nʼim. ");
INSERT INTO adj_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Eke -nʼimn -lʼokr Bɛtlehɛm a, in ecʼiy a e mew e lɛgŋ ow. ");
INSERT INTO adj_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ɛtŋ lʼew in eci yɛfl iy igŋ nyam. Lʼoc gbad ufu li bubur ow sos es, ɛtŋ lʼɛrum ow es mindey ecʼob ijr ↄfu ɛm, aŋke usu anm ɛbam ɛl etu eb usu a. ");
INSERT INTO adj_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Wus ab af yogŋ cɛ, mɛcɛb ↄsu ɛsɛl bʼanŋ loj am ↄsu ɛl mɛcɛb a ncok ɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kpɛkŋ Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ɛy ↄkm, ɛtŋ Ɛs Kↄtↄkↄ ecʼanygbɛl a ɛjn usuayl ok ɛl af, ɛtŋ erŋn am ↄny ɛl. ");
INSERT INTO adj_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Gbɛkↄ afr ɛrm ɛs a dad ɛl ninɛ: «Kʼùrur erŋn! Mʼam is ↄny amani mamn ligbɛl eke bʼow iŋn agŋ a fɛŋ sos ɛm: ");
INSERT INTO adj_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ncok a, David eci baŋn a, wɛl ew ↄny ecʼEb Ɛs ekʼel Krist Ɛs Kↄtↄkↄ a. ");
INSERT INTO adj_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ɛtŋ kin mɛny ɛwr yeci eke bʼow ↄŋ ↄny uwr ir any: bʼimn ba bʼokr baŋn a, bʼow ɛŋan iy owrli nyam eke wɛl bubur sos es gbad ufu ɛm ɛrum es mindey ecʼob ijr ↄfu ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Eke afr ɛrm ɛs a dad odad a bake ow uwr a, kpɛkŋ afr ecʼɛrm ɛsɛl nↄnↄ gbɛl ow ɛŋnʼn ɛtŋ -nʼam kↄklm Nyam -li dad -lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«Anygbɛl él Nyam ekʼanŋ afr usu kpekpe eci, ɛrm es ɛy él wus na ecʼagŋ eke ɛŋn in ecʼɛrm mamn a eci!» ");
INSERT INTO adj_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Eke afr ɛrm ɛsɛl a ɛlu ɛl es aam afr a, mɛcɛb ↄsu ɛsɛl a am dadarir ɛl ↄfr ɛsɛ: «Sʼímn fafa sʼokr Bɛtlehɛm, ke sʼɛ́kan low a ekʼɛy, ke Ɛs Kↄtↄkↄ kok ɛlu ↄkm sʼuw any a!» ");
INSERT INTO adj_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","-Lʼogŋ es -nʼim -lʼok yogŋ, ɛtŋ -nʼɛŋn Mari, Josɛf lele iy owrli a ekʼɛru es mindey ecʼob ijr ↄfu ɛm a. ");
INSERT INTO adj_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Eke -lʼɛkan iy a, -nʼam awl ów a eke afr ɛrm ɛs a dad ɛl ow e lís a. ");
INSERT INTO adj_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ɛtŋ ɛl a fɛŋ ekʼam iri mɛcɛb ↄsu ɛsɛl a ecʼodad a, low am iti any iŋn sos ɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Kↄ Mari eb ów amua fɛŋ ɛw es in ecʼɛrm ɛm, yecʼɛtŋ ke sɛgŋ fɛŋ nʼám tutr. ");
INSERT INTO adj_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Mɛcɛb ↄsu ɛsɛl a ɛwl mɛny aam. -Nʼam dad Nyam ecʼanygbɛl ecʼodad -li kↄklm ow, ów a fɛŋ eke -lʼɛkan ke -lʼirir a sosiɛm; tasi ɛm a, ow anŋ ɛsɛ yecʼa eke afr ɛrm ɛs a dad ɛl ab af. ");
INSERT INTO adj_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Eke ow ij sɛgŋ niwn a, wɛl ubr iy a likr es, ɛtŋ wɛl ɛwʼr nin Jesu, nin a eke afr ɛrm ɛs a ɛwar gbuŋ ke lis anŋ in e lokab a. ");
INSERT INTO adj_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Ɛtŋ lɛgŋ a eke Josɛf lele Mari ab kʼim ke Mari ki kok sos ayal owi, ɛsɛ elel eke Mois ecʼol a dad ab af a ow. -Lʼoc iy a -lʼow Jerusalɛm eke -li kʼoc -nʼim ow Ɛs Kↄtↄkↄ ecʼany af, ");
INSERT INTO adj_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","aŋke Ɛs Kↄtↄkↄ ecʼol ab ɛm, wɛl nↄn eke: Iy igŋ krɛkrɛ fɛŋ eke wɛl ew a, wɛl óc ɛwʼr saw Ɛs Kↄtↄkↄ e juma kok eci. ");
INSERT INTO adj_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ke ca ɛmɛny -li kok egb waw yɛji eke ol a ibrm a: kel yony oglog prɛndrɛ ekekey yony. ");
INSERT INTO adj_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Lɛgŋ ab ɛm a, Jerusalɛm baŋn yogŋ igŋ nyam anŋ eke wɛl bʼɛsŋ Simeↄn. Ɛgŋ na el ɛgŋ mamn; li bʼɛlum Nyam ɛtŋ nʼam eku ɛgŋ eke kʼow sↄg Israɛl a. Ɛtŋ Abŋ Lala anŋ in ab. ");
INSERT INTO adj_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Abŋ Lala ɛwar ir eke li kʼow lʼuwm toŋ bake lʼɛ́kn Mesi a ekʼƐs Kↄtↄkↄ ɛrm a. ");
INSERT INTO adj_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Eke Josɛf lele Mari ab oc ɛl jim Jesu ow Nyamel gbɛl a gbugŋ a eke ki kok in e lís e low ɛsɛ elel eke ol dad ab af a, Abŋ nyimn Simeↄn yɛji ow yogŋ. ");
INSERT INTO adj_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Eke li bʼɛkn iy a, lʼeb ow in ecʼabu ɛm, ɛtŋ lʼɛlu Nyam bia li dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Sica Ɛs Kↄtↄkↄ, ɛ̀lu ŋ e juma kok ɛs es úw ɛrm es ɛy ɛm, ɛsɛ elel eke dad ab af, ");
INSERT INTO adj_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","aŋke mʼɛkn ŋ e sel ɛŋn a, ");
INSERT INTO adj_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","sel ɛŋn a e kok ɛw es ɛbr ɛbr fɛŋ ecʼa: ");
INSERT INTO adj_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ke el usuayl eke bʼow ayal ɛbr ɛbr fɛŋ ekʼuwm Nyam any, ke bʼow el Israɛl ecʼagŋ ecʼanygbɛl a.» ");
INSERT INTO adj_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Jesu ɛs lele lis ab low am iti any Simeↄn ecʼodad ekʼam dad iy a e lís a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simeↄn ŋↄŋn Nyam ↄŋ ɛl ɛtŋ dad lis Mari ninɛ: «Nyam sↄsum iy na oc; li bʼow lʼel lirikp lʼok agŋ nↄnↄ wus Israɛl ɛb ɛm, ke lʼigbm nↄnↄ. Li bʼow lʼel Nyam e mɛny ɛwr nyam eke agŋ kʼow ɛgŋm in e low ebm. ");
INSERT INTO adj_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Ow ɛm anake agŋ nↄnↄ e tutr eŋuŋ ekʼanŋ mɛrm ɛm a bʼow ok ↄkm a; ɛtŋ ŋ yↄw, low bʼow duduʼŋ ɛyʼŋ sos ɛm ɛsɛ labli eke bʼigŋ ɛgŋ af.» ");
INSERT INTO adj_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Nyam e kokoba ↄb lis nyam anŋ eke wɛl bʼɛsŋ An, Fanuɛl jↄw ekʼel Asɛr ecʼeb ɛm e yↄwli. Lʼusu nↄnↄ. Nʼanŋ in ecʼigŋ ab ab akpo lↄbŋ in e mↄwr yↄw ɛm a, ");
INSERT INTO adj_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ɛtŋ ɛc uw, lʼel iŋnyↄw. Sica lʼij akpo ekŋ yar lele yar ab, ɛtŋ sɛgŋ fɛŋ li bʼim Nyamel gbɛl ɛm li kok Nyam e juma ncok lele lɛgŋ owr ab, nɛny ɛnŋ ɛm lele Nyam ŋↄŋn ɛm ab. ");
INSERT INTO adj_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Wanci ab af cɛ in yɛji lʼow nʼam ɛlu Nyam bia iy a, ɛtŋ nʼam dad ow e lís e low lʼok agŋ a fɛŋ ekʼam eku Jerusalɛm ecʼes eb ɛlu owi a. ");
INSERT INTO adj_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Eke Mari lele Josɛf ab uwar ów a fɛŋ eke Ɛs Kↄtↄkↄ ecʼol a ibrm a, iy ab ab -lʼɛwl mɛny -nʼim Nasarɛt baŋn Galile wus. ");
INSERT INTO adj_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Yogŋ, Jesu am agb lele lɛc ab; ɛtŋ Nyam ecʼↄwrↄ lele nuŋ ɛm ↄny ab anŋ in ab. ");
INSERT INTO adj_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Lakpo lakpo fɛŋ, Mari lele Josɛf ab bʼim Jerusalɛm Pak ecʼes gbɛgbl ɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Eke Jesu ij akpo lɛw yony a, ɛsɛ elel eke -li bi kok ab af, -lʼoc ow ab -nʼim es gbɛgbl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Eke es gbɛgbl a uwr ke -lʼɛwal mɛny -nʼaam a, Jesu anŋ Jerusalɛm yogŋ, eke Mari lele Josɛf ab uwm any. ");
INSERT INTO adj_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","-Li tutr eke Jesu us ejagb ɛl lawlɛl ab aam. -Nʼan es ejagb af toŋ ij lɛgŋ nimum nyam, ɛtŋ -nʼam ↄl ow ɛl ecʼagŋ ogŋ lele ɛl lawlɛl ɛm ab, ");
INSERT INTO adj_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","gbɛkↄ -nʼɛŋnm ow. Ca -lʼɛwl mɛny -lʼow Jerusalɛm -nʼam ↄl ow. ");
INSERT INTO adj_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Eke ow ij sɛgŋ nyahan a, -nʼɛŋn ow Nyamel gbɛl a e gbugŋ a. Li sig es ol e low any uw ɛsɛl ecʼaraŋn nʼam iri wɛl ecʼodad a ɛtŋ in yɛji nʼam bibrm wɛl ów. ");
INSERT INTO adj_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Agŋ a fɛŋ ekʼam iri in ecʼodad a low am iti any, in e sodad eke nʼam dad nʼↄŋ wɛl nuŋ ɛm ↄny ɛm a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Eke ɛs lele lis ab bʼɛknʼn a, low iti ɛl any ɛtŋ Mari dad ninɛ: «Ɛm ecʼiy, kↄ bla ɛtŋ kok ɛy low nɛnɛ ee? Kin, ɛm lele asŋ ab sʼam ↄlʼŋ ɛrm mij ab.» ");
INSERT INTO adj_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Kↄ li dad wɛl ninɛ: «Bla sosiɛm ɛtŋ am ↄↄlʼm ee? Uwr any eke ow it eke mi ki kok ɛm Ɛs e juma.» ");
INSERT INTO adj_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Kↄ -li kʼirim yecʼa eke ow am dad ɛl a. ");
INSERT INTO adj_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Ɛtŋ Jesu im Nasarɛt ɛl ab, nʼam ɛlum wɛl. Mari gbɛ, lʼeb ów amua fɛŋ lʼɛw es ɛrm ɛm nʼam tutr ow e low. ");
INSERT INTO adj_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ɛtŋ Jesu am agb sos megl ɛm lele nuŋ ɛm ↄny ɛm ab. Nyam am ↄny in ecʼerur, ɛtŋ agŋ yɛji am ↄny in ecʼerur. ");
INSERT INTO adj_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Ow ij akpo lɛw yen eke Sesar Tibɛr ɛw ɛb a fɛŋ ekʼanŋ Rom eyŋ ecʼabu ɛm a es. Pↄns Pilat ɛw Jude wus es. Erↄd Antipas ɛw Galile wus es, ɛtŋ lisijim Filip ɛw Iture lele Trakonit wus ab es. Lisanias yɛji ɛw Abilɛn wus es, ɛtŋ An lele Kayif ab el egb waw ɛsɛl ɛgbɛl. Yogŋ ɛm anake Nyam dad Zakari jim Jan ekʼanŋ loj a odad a. ");
INSERT INTO adj_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Jan am ɛc ɛlul Jurdɛn e mij ewl mij a e wus ab ɛm, ɛtŋ nʼam ɛlu lebl li dad lʼɛsɛ: «Ìtŋnin ɛrm ɛm, òkr mij nuŋ, ke Nyam bʼow oc ↄny e sikpl a ap ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Ɛsɛ elel eke ow anŋ kokoba ↄb ɛs Esayi e lɛl ɛm ab af: Ɛgŋ nyam anŋ loj am ɛlu lebl dad ɛsɛ: «Kòkr Ɛs Kↄtↄkↄ ecʼejagb a, kòkr in e sebr a ínym nyim nyim! ");
INSERT INTO adj_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Yìyibar ↄmu a fɛŋ ekʼanŋ mafɛny araŋn araŋn a; bↄbmn mafɛny lele egigl ab ab es sís es, nyìnyiman sebr eke kikn a ínym, ke wɛl ↄ́du sejagb a fɛŋ es iy bɛbmn. ");
INSERT INTO adj_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ɛtŋ agŋ fɛŋ bʼow ɛkn Nyam e sel ɛŋn a.» ");
INSERT INTO adj_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Agŋ nↄnↄ a am ow Jan ogŋ eke li kʼok wɛl mij nuŋ, ɛtŋ nʼam dad wɛl lʼɛsɛ: «Ɔny morŋn amua! Kↄ bwo dad ↄny eke, ekʼokr mij nuŋ ↄtur eke kʼŋgbroŋn Nyam ecʼɛrm bebl ekʼam ow ab ɛm ee? ");
INSERT INTO adj_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Sica yɛ̀gmn ↄny ecʼes an ab ɛm eke itŋnin ɛrm ɛm, ke kí dadmn ↄny obi ɛm ɛsmn: “Ɛy lagŋ el Abraham!” Kↄ mʼam dad ↄny eke Nyam ↄtu eke ki kok mebn amua él Abraham ecʼalaw. ");
INSERT INTO adj_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Sica ↄs anŋ eke bʼow bubr ekŋ es min ɛm. Likŋ fɛŋ ekʼↄ́sum ey amamn a, wɛl bʼow ubrʼr es oc ↄwlʼl alm.» ");
INSERT INTO adj_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Kↄ agŋ a am ibrmʼn dad ɛsɛ: «Kↄ sica ɛy, ayaf si ki kokr ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Li dad wɛl ninɛ: «Ɛgŋ ekʼↄny mob sus ɛm yony a, lʼóc nyam nʼↄŋ ɛgŋ ekʼↄnym a. Ke ɛgŋ ekʼↄny ob ij a yɛji ↄ́ŋ ɛgŋ eke ↄnym a.» ");
INSERT INTO adj_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Wus labm eb ɛsɛl ekʼow eke kʼok mij nuŋ a yɛji am ibrmʼn ɛsɛ: «Low yɛgm agŋ ɛs, kↄ sica ayaf si ki kokr ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Li dad wɛl ninɛ: «Os yecʼeke ol ɛw ↄŋ ↄny eke kʼebr a, kʼìgŋn ɛjeci kokr ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Srↄda eyŋ bɛb yɛji ow ibrmʼn ninɛ: «Ɛtŋ kↄ ɛy, ayaf si ki kokr ab ee?» Ɛtŋ li dad wɛl ninɛ: «Kʼèbr ɛgŋ kaka ecʼob lɛc ɛm, oglog kʼↄ̀br ɛgŋ kaka low yadŋ ɛm. Kↄ èkur ↄny e labm sↄg a cɛ.» ");
INSERT INTO adj_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Agŋ a fɛŋ ekʼam eku a am ↄmn ɛtŋ ɛgŋ ɛgŋ am dad in ecʼɛrm ɛm ɛsɛ: «Kↄ Jan na kʼel Mesi ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Kↄ Jan dad ɛl fɛŋ ninɛ: «Ɛm ecʼa, mʼam ok ↄny mij nuŋ mij ɛm. Kↄ ɛgŋ eke ↄny abusu akm im, ke mʼitm bↄbↄ yɛji eke mi kʼↄny in e cↄkrukpↄ meb a mi mↄmu es a am ow. In li bʼow lʼok ↄny mij nuŋ Abŋ Lala lele al ɛm ab. ");
INSERT INTO adj_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Nʼↄnym waw ab ɛtŋ li bʼow nʼↄŋ egb a lɛf, lʼéb ey a, ke lʼígŋ suw a lʼok es. Li bʼow lʼeb egb a lʼok egbel ɛm, ke lʼófŋ suw a al ekʼiram es ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ɛbɛn eke Jan am ↄm agŋ ów nↄnↄ ke am dad ɛl Amani Mamn ecʼodad yɛjʼana. ");
INSERT INTO adj_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gbɛkↄ nʼam ɛnym Erↄd abr aŋke ow eb ow lisijim e yↄw Erodiad ɛbi, ɛtŋ ow kok ów eŋuŋ nↄnↄ gbɛl yɛji. ");
INSERT INTO adj_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ɛtŋ ɛmɛny lʼɛlu Jan sobel ɛm lʼigŋ ów eŋuŋ amua eke li kok ab af. ");
INSERT INTO adj_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Eke Jan ok agŋ a fɛŋ mij nuŋ bake ow uwr a, lʼok Jesu yɛji. Eke Jesu ok mij nuŋ oc es ke am ŋↄŋn Nyam a, afr fig, ");
INSERT INTO adj_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ɛtŋ Abŋ Lala usʼr es nuŋ af ɛsɛ kel af. Ɛtŋ Nyam e lebl anŋ afr ikŋ dad ninɛ: «Ŋ el ɛm ecʼiy eke mʼerur tasi, mʼoc ɛm eci sos ɛm iŋn fɛŋ mʼɛluʼŋ ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesu ↄb nuŋ am yɛgm agŋ low, lʼↄtu eke li kʼↄny akpo likŋ lele lɛw ab. Agŋ bi tutr eke Jesu el Josɛf jim. Ɛtŋ kin Josɛf lagŋɛl ecʼen ecʼes ↄsŋm: ");
INSERT INTO adj_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Eli, Matat, Levi, Mɛlki, Janayi, Josɛf. ");
INSERT INTO adj_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Matatias, Amↄs, Nahum, Ɛsli, Nagayi. ");
INSERT INTO adj_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Maat, Matatias, Semeyin, Josɛk, Joda. ");
INSERT INTO adj_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joana, Resa, Sorobabɛl, Salatiɛl, Neri. ");
INSERT INTO adj_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Mɛlki, Adi, Kosam, Ɛlmadam, Ɛr. ");
INSERT INTO adj_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Joswe, Eliesɛr, Jorim, Matat, Levi. ");
INSERT INTO adj_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Simeↄn, Juda, Josɛf, Jonam, Eliakim. ");
INSERT INTO adj_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Meleya, Mena, Matata, Natan, David. ");
INSERT INTO adj_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Jese, Jobɛd, Boas, Sala, Nasↄn. ");
INSERT INTO adj_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Aminadab, Admin, Arni, Esrↄm, Farɛs, Juda. ");
INSERT INTO adj_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jakↄb, Isak, Abraham, Tera, Nakↄr. ");
INSERT INTO adj_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Seruk, Rago, Falɛk, Ebɛr, Sala. ");
INSERT INTO adj_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Kayinam, Arpasad, Sɛm, Noe, Lemɛk. ");
INSERT INTO adj_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Matusala, Enↄk, Yarɛd, Maleleyɛl, Kayinam. ");
INSERT INTO adj_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Enↄs, Sɛt, Adam eke Nyam in obi kok in ecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Eke Jesu anŋ Jurdɛn ow a, Abŋ Lala iyʼr ɛm, ɛtŋ lʼoc ow nʼim loj. ");
INSERT INTO adj_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yogŋ, agn ɛjuʼr toŋ ow ij sɛgŋ ekŋ yony. Sɛgŋ a nimum fɛŋ ɛm a, nʼɛnŋ nɛny eke lʼijm ob kaka. Eke ow bʼuwr a, namn owʼr sos, ");
INSERT INTO adj_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ɛtŋ agn dadʼr ninɛ: «Eke el Nyam ecʼIy, ke dàd lebn na ítŋn el ob ij.» ");
INSERT INTO adj_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesu dadʼr ninɛ: «Wɛl nↄn Nyam Lɛl ɛm eke: Ow elm ob ij sↄny cɛ ↄ́ↄm ɛgŋ sel.» ");
INSERT INTO adj_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ɛmɛny agn ocʼr ab im lafɛny gege nyam af, ɛtŋ inym es yɛgmʼn wus na nimum ecʼes ɛw es ɛw a fɛŋ, ");
INSERT INTO adj_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","7","ɛtŋ dadʼr ninɛ: «Mʼow mʼↄŋʼŋ abusu lele anygbɛl fɛŋ ekʼanŋ es ɛw na ɛm a, eke ok ↄwrↄkp wus igŋʼm nuŋ, aŋke na fɛŋ, ɛm wɛl ↄŋʼm, ɛtŋ mʼↄtu eke mi kʼↄŋ ɛgŋ eke mʼerur a.» ");
INSERT INTO adj_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Kↄ Jesu dadʼr ninɛ: «Wɛl nↄn Nyam Lɛl ɛm eke: Bʼow igŋ Ɛs Kↄtↄkↄ ŋ e Nyam nuŋ ke kók in sↄny coco cɛ e juma.» ");
INSERT INTO adj_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ɛtŋ ɛmɛny agn ocʼr im uyumʼn Jerusalɛm e Nyamel gbɛl a e luw af ecʼusu gege a, ɛtŋ dadʼr ninɛ: «Eke el Nyam ecʼIy tasi, ke ànŋ aŋa igb us es wus; ");
INSERT INTO adj_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","aŋke wɛl nↄn Nyam Lɛl ɛm eke: Nyam bʼow ↄŋ in ecʼafr ɛrm ɛsɛl ↄsuʼŋ. ");
INSERT INTO adj_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ɛtŋ ɛmɛny: -Li bʼow -lʼocʼŋ abu ɛm abu ɛm yecʼɛtŋ ke lebn kaka kí kokmʼŋ ob lakr.» ");
INSERT INTO adj_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesu ↄdu eb dadʼr ninɛ: «Nyam Lɛl dad eke: Kʼɛ́bam Ɛs Kↄtↄkↄ ŋ e Nyam.» ");
INSERT INTO adj_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Eke lʼɛju Jesu kprakpr amua na ɛm bake ow uwr a, agn ŋgboŋ ɛgbʼr es im am ekuʼr lɛgŋ ɛjeci. ");
INSERT INTO adj_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Jesu ɛwl im Galile; Abŋ Lala ecʼabusu a iyʼr ɛm, ɛtŋ yogŋ agŋ am dad in e lís e low. ");
INSERT INTO adj_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nʼam yɛgm agŋ low Nyam nuŋ igŋ susu, ɛtŋ agŋ a fɛŋ am awʼr. ");
INSERT INTO adj_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesu im Nasarɛt baŋn, yogŋ eke wɛl gbagblʼl a. Nɛnɛgŋ e lɛgŋ a, nʼim lʼɛy Nyam nuŋ igŋ usu a ɛsɛ elel eke li bi kok godʼɛtŋ ab af. Lʼigb eke li kʼawl Nyam odad eke wɛl nↄn a lʼok agŋ, ");
INSERT INTO adj_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ɛtŋ wɛl oc kokoba ↄb ɛs Esayi e lɛl ↄŋʼn. Ni mↄmu lɛl ab es, ɛtŋ nʼɛŋn usu a eke wɛl nↄn eke: ");
INSERT INTO adj_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ɛs Kↄtↄkↄ ecʼAbŋ anŋ ɛm ab, aŋke li sↄsum lʼocʼm eke mi kʼↄb Amani Mamn a mʼok ↄgbↄru. Lʼɛrm im eke mi ki dad sobel ɛm ɛsɛl ecʼes eb ɛlu owi, ke mʼↄ́ŋ ány eflu ɛkn es, ke mʼéb agŋ eke am ij gbre a mʼɛ́lu es, ");
INSERT INTO adj_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ke mi dád agŋ eke lakpo eke Nyam bʼow ɛlu in ecʼɛrm mamn ↄkm agŋ e lís a ow. ");
INSERT INTO adj_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Eke Jesu awl lɛl a bake ow uwr a, lʼar lɛl a es lʼoc nʼↄŋ ob oc ↄŋ ɛs a, ɛtŋ li sig es. Agŋ a fɛŋ a ekʼanŋ Nyam nuŋ igŋ usu a okʼr anyamn af. ");
INSERT INTO adj_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ɛtŋ nʼam dad wɛl lʼɛsɛ: «Yɛfɛnyna, Nyam Lɛl na ecʼodad na eke wɛl awl ok ↄny ke irir a, ow e lɛgŋ a ow ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Agŋ a fɛŋ am aw Jesu, ɛtŋ ow am iti ɛl any sodad amamn amua eke ow am dad a sosiɛm. Ɛtŋ -nʼam dad -lʼɛsɛ: «Kↄ ow elm Josɛf jim ab ana ee?» ");
INSERT INTO adj_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ow ɛm a, Jesu ↄdu eb dad ɛl ninɛ: «Nawrɛ, bʼow dadrʼm nyandrɛ ɛm ecʼodad na ɛsrɛ: “Sɛkp kok ɛs, kòkr ŋ sosi sɛkp!” Ɛtŋ ɛmɛny bʼow dadrʼm ɛsrɛ: “Sʼiri yecʼa fɛŋ eke kok Kapɛrnayum a; aŋa ekʼel ŋ e baŋn a yɛji kòk ɛbɛn nyam coco gↄŋ!” ");
INSERT INTO adj_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Low nawrɛ mʼam dad ↄny: wɛl ébm kokoba ↄb ɛs kaka sɛnyn sɛnyn in ecʼɛb ɛm. ");
INSERT INTO adj_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mʼam dad ↄny nawrɛ tasi eke Eli e lɛgŋ ab ɛm a, eŋnyↄw nↄnↄ gbɛl anŋ Israɛl wus af. Lɛgŋ a, nyam anm toŋ batŋ ow ij akpo nyahan lele likpr ab, ɛtŋ lek ligbɛl ɛy eb ɛb a nimum ɛm. ");
INSERT INTO adj_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Ɛbɛn yɛji Nyam ɛram Eli iim Israɛl wus af ecʼiŋnyↄw kaka ogŋ, kↄ lʼɛrm ow iŋnyↄw a ekʼir Sarɛpta, Sidↄn wus af a ogŋ. ");
INSERT INTO adj_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kokoba ↄb ɛs Elise e lɛgŋ ab ɛm yɛji, kokobe ɛsɛl nↄnↄ gbɛl anŋ Israɛl wus af. Kↄ ɛbɛn yɛji, ɛl ɛm ecʼɛgŋ kaka ewlm in e kokobe ecʼↄl ab ɛm, eke ow elm Nayma, Siri iy a sↄny cɛ.» ");
INSERT INTO adj_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Eke Jesu dad ów amua a, agŋ a fɛŋ ekʼanŋ Nyam nuŋ igŋ usu a ke iri a am ebl ɛrm. ");
INSERT INTO adj_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ɛtŋ -lʼigb -nʼↄny ow lʼoc ow ab -nʼim ɛl eci baŋn a ekʼanŋ ligigl af a eke -li ki pipig ow, ow ɛ́y nↄmu ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Kↄ lʼɛpir wɛl araŋn lʼeb ejagb nʼim. ");
INSERT INTO adj_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ɛmɛny Jesu im Kapɛrnayum baŋn, Galile ɛb ɛm, ɛtŋ yogŋ nʼam yɛgm agŋ low nɛnɛgŋ e lɛgŋ. ");
INSERT INTO adj_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Agŋ a ekʼam iri in e low yɛgm a, low am iti any in ecʼelel eke nʼam yɛgmn agŋ low ab ɛm, aŋke nʼam dad wɛl odad abusu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Nyam nuŋ igŋ usu yogŋ a, igŋ nyam anŋ ekʼabŋ ŋuŋ anŋ ɛm. Nʼam ɛlu lebl tuↄtuↄ li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","«Oy! Nasarɛt e Jesu, kↄ bla am erur eke ki kok ɛy ee? Kↄ ekʼow eke ki ŋuŋn ɛy ee? Ɛm, mʼuw ɛgŋ ekʼelʼŋ ab any: Nyam ecʼɛrm ɛs Lala!» ");
INSERT INTO adj_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesu dad abŋ ŋuŋ a odad lebl tuↄtuↄ ɛm ninɛ: «Yèwal! Ke ɛ́y ↄkm ɛgŋ na ɛm!» Abŋ ŋuŋ a ↄny igŋ a ɛlu wus agŋ fɛŋ ecʼany af, ɛtŋ lʼɛy ↄkm eke li kokm ow low ŋuŋ kaka. ");
INSERT INTO adj_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Agŋ a fɛŋ low iti any afŋn es ɛtŋ -nʼam dadarir -lʼɛsɛ: «Bogŋ ecʼodad el na ee? Igŋ na bi dad odad lɛc ɛm lele abusu ɛm ab, ke kpɛkŋ abŋ eŋuŋ am ok ↄkm!» ");
INSERT INTO adj_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ɛtŋ -nʼam dad Jesu e lís e low wus ab af nimum. ");
INSERT INTO adj_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesu anŋ Nyam nuŋ igŋ usu a ɛy ↄkm ɛtŋ im igŋ nyam e gbugŋ. Igŋ a wɛl bʼɛsŋʼn Simↄ, ɛtŋ ɛy lis lɛfr ↄl am ↄny tuↄtuↄ. Wɛl am dad Jesu eke kʼewlm yↄw a. ");
INSERT INTO adj_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nʼim li titm ow ɛtŋ lʼis es li dad lɛfr ↄl a odad lebl tuↄtuↄ ɛm, nʼↄŋ ow ol, ɛtŋ lɛfr ↄl a ocʼr es lís. Kpɛkŋ lʼigb wus ɛtŋ nʼam kok Jesu lele in e jam ɛsɛl ab ab e lís e low. ");
INSERT INTO adj_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Eke lɛgŋ ew es a, agŋ a fɛŋ eke ↄl akpasu akpasu am ↄny a, wɛl ot ow ɛl Jesu ogŋ. Ɛtŋ lʼat ɛgŋ nyam nyam abu nuŋ, lʼewlm wɛl. ");
INSERT INTO adj_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Abŋ eŋuŋ nↄnↄ gbɛl anŋ agŋ ab ɛm ok ↄkm am ↄg dad ɛsɛ: «Ŋ el Nyam ecʼIy tasi!» Kↄ Jesu dad ɛl odad lebl tuↄtuↄ ɛm ɛdŋn ɛl eke -li ki dadmn odad, aŋke -lʼuw any eke Jesu el Mesi. ");
INSERT INTO adj_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sica eke lɛgŋ am ɛny a, Jesu ɛy ↄkm ɛb ab ɛm im usu saw ɛm. Agŋ nↄnↄ am ↄlʼl. Eke -nʼɛŋan ow a, -lʼerur eke -li kʼucu -nʼↄny ow es, ow ánŋ ɛl ab. ");
INSERT INTO adj_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Kↄ Jesu dad ɛl ninɛ: «Ow akpl ke mʼím sɛb ɛjecʼɛm yɛji mi dad Nyam e gbreŋgbi usu a ecʼamani ecʼodad, aŋke na sosiɛm eci Nyam ɛrm im mʼow.» ");
INSERT INTO adj_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Ɛtŋ nʼam dad Nyam ecʼodad Jude wus af e Nyam nuŋ igŋ susu a. ");
INSERT INTO adj_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Lɛgŋ nyam, Jesu inym es Genesarɛt e mij lekpl a ecʼany af a, ɛtŋ agŋ nↄnↄ ow iwr ɛlul il ɛm ɛtŋ am itarir eke kʼiri Nyam ecʼodad. ");
INSERT INTO adj_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Eke Jesu bʼɛdŋ mɛny a, lʼɛkn muwɛtŋ yony ekʼitr es nanu a. Ɛtŋ ↄcn ibi ɛsɛl anŋ ɛm us es am yↄyↄg ɛl e muw ab es. ");
INSERT INTO adj_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesu ɛy mɛtŋ a e nyam ɛm, ekʼel Simↄ ecʼa, ɛtŋ nʼam ŋↄŋn ow eke ow kʼↄdu lɛtŋ a eb jam tɛl ɛy mij ab ɛm. Jesu sig es lɛtŋ ab ɛm, ɛtŋ ɛmɛny am yɛgm agŋ a low. ");
INSERT INTO adj_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Eke li yɛgm wɛl ów bake ow uwr a, li dad Simↄ ninɛ: «Ɔ̀du lɛtŋ a eb im libn ab ɛm, ke ŋ lele awlŋɛl ab ab ókr ↄny e muw a ↄnyn ↄcn.» ");
INSERT INTO adj_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ɛtŋ Simↄ dadʼr ninɛ: «Ɛm ɛgŋ gbɛliy, sʼↄdu muw ncok a toŋ sʼɛŋnm ob kaka. Kↄ eke dad a, mʼow mʼↄdu muw a mʼɛkn.» ");
INSERT INTO adj_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","-Lʼↄdu muw a, ɛtŋ -nʼↄny ↄcn bubutɛ gbɛl, toŋ batŋ ɛl e muw a am ↄl eke ki gbagbrm ɛm. ");
INSERT INTO adj_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ɛtŋ -nʼam ibrm ɛl lawlɛl a ekʼanŋ lɛtŋ ɛjecʼab ɛm a, eke kʼow ɛlum ɛl abu. -Lʼow ɛtŋ -nʼↄny ↄcn a -lʼok mɛtŋ yony ab ɛm iy gbↄŋ gbↄŋ, batŋ mɛtŋ a am ↄl eke kʼɛmn. ");
INSERT INTO adj_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Eke Simↄ Piɛr bʼɛkn ɛbɛn a, lʼok ↄwrↄkp wus Jesu ecʼany af, ɛtŋ li dad ninɛ: «Ɛgŋ gbɛl, kʼòw ki titmʼm, aŋke mʼel sikpl ɛs!» ");
INSERT INTO adj_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Tasi ɛm a, low na iti Simↄ lele agŋ a ekʼanŋ in ab a any, ↄcn bubutɛ a eke -nʼↄnyn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Ɛtŋ lawlɛl Jak lele Jan ab ekʼel Sebede jimɛl a yɛji, low iti any. Kↄ Jesu dad Simↄ ninɛ: «Kʼùru erŋn; kↄ jam aŋa agŋ anake bʼow eb ↄŋʼm a.» ");
INSERT INTO adj_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɛtŋ kpɛkŋ -lʼot ɛl e mɛtŋ a -lʼow itr es ákpaf, ɛtŋ -lʼigŋ fɛŋ -lʼok es -nʼam us Jesu jam. ");
INSERT INTO adj_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Eke Jesu anŋ Galile wus af eci baŋn nyam a, kokobe ɛs nyam ow ɛŋnʼn. Eke li bʼɛkn Jesu a, lʼɛy wus lʼubu any es ow ecʼany af, ɛtŋ nʼam ŋↄŋn ow li dad lʼɛsɛ: «Ɛgŋ gbɛl, eke erur, ↄtu eke kʼayalʼm.» ");
INSERT INTO adj_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesu ɛgŋm abu es itŋn in ɛtŋ dad ninɛ: «Mʼerur, àyl!» Ɛtŋ kpɛkŋ kokobe a ocʼr es lís. ");
INSERT INTO adj_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Gbɛkↄ Jesu ɛdŋn in dadʼr ninɛ: «Kì dad ɛgŋ kaka ŋ ecʼewl a e low; kↄ ìm yɛgm egb waw ɛs a sos, ke wáw egb a ɛsɛ elel eke Mois ecʼol a ibrm ab af, ke ow íj daŋku.» ");
INSERT INTO adj_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ɛbɛn a yɛji, Jesu e nin a am eb es susu a fɛŋ. Ɛtŋ agŋ nↄnↄ gbɛl bʼow in ogŋ am iri in ecʼodad a, ɛtŋ ↄ́lu a bʼibrm eke li kʼewlm wɛl. ");
INSERT INTO adj_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Kↄ Jesu bʼocr sos es im usu saw ɛm am ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Lɛgŋ nyam, Jesu am yɛgm agŋ low, ɛtŋ Farisiɛl lele ol e low any uw ɛsɛl ab, anŋ Galile baŋn baŋn, Jude baŋn baŋn lele Jerusalɛm ab ow ok es yogŋ. Ɛtŋ Nyam ecʼabusu a anŋ Jesu ab ɛtŋ am ↄŋʼn lʼewlm ↄ́lu. ");
INSERT INTO adj_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Ɛtŋ kin agŋ oc sos es wɛw ɛs nyam ekʼɛru es faja ɛm ow, ɛtŋ am ↄl eke kʼoc ɛluʼl akŋ Jesu ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Gbɛkↄ -lʼɛknmn usu eke -li kʼɛcr nↄnↄ gbɛl a sosiɛm. -Lʼoc -lʼuyum ow êl luw af ɛtŋ -li fig usu nyam, -lʼusm ow es faja ab agŋ a ecʼaraŋn, Jesu ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Eke Jesu bʼɛkn ɛl ecʼↄmn a, li dad ↄlu a ninɛ: «Lisijim, mʼoc ŋ e sikpl a mʼapʼŋ!» ");
INSERT INTO adj_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Eke Jesu dad ɛbɛn a, ol e low yɛgm ɛsɛl a lele Farisiɛl ab ab am bibrmnin ɛl ↄfr ɛsɛ: «Kↄ ɛgŋ na, ayaf nʼam ocr in sosi ɛtŋ nʼam ↄbr Nyam any nɛnɛ na ee? Kↄ bwo ↄtu ekʼap ɛgŋ sikpl ekʼow elm Nyam sↄny cɛ ee?» ");
INSERT INTO adj_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jesu uw ɛl e sow tutr ab any ɛtŋ dad ɛl ninɛ: «Bla ɛtŋ am ↄnyn sow tutr nɛnɛ ↄny eci mɛrm ab ɛm ee? ");
INSERT INTO adj_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kↄ bogŋ ecʼanake ɛw fuɛfuɛ eke wɛl ki dad sos es wɛw ɛs ab ee? “Mʼoc ŋ e sikpl a mʼapʼŋ” oglog ke wɛl dádʼr ɛsɛ: “Ìgb ke án es ee”? ");
INSERT INTO adj_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Gbɛkↄ mʼerur eke kʼuwr low na any: wus af aŋa, ɛgŋ ecʼIy ↄny abusu eke kʼoc sikpl ap.» Ɛtŋ sica li dad sos es wɛw ɛs a ninɛ: «Mʼam dad ŋ, ìgb, òc ŋ eci faja a eb ejagb im gbugŋ.» ");
INSERT INTO adj_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ɛtŋ kpɛkŋ igŋ a igb wus agŋ a fɛŋ ecʼany af oc in eci faja a eke lʼɛrur a aam gbugŋ, ɛtŋ nʼam kↄklm Nyam. ");
INSERT INTO adj_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Eke agŋ a ɛkn low na a, ow iti ɛl any, erŋn am ↄny ɛl, ɛtŋ -nʼam kↄklm Nyam -li dad -lʼɛsɛ: «Yɛfɛnyna sʼɛkn low any iti owi eke sʼɛknm lɛgŋ kaka!» ");
INSERT INTO adj_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Eke low na ɛc a, Jesu ɛy ↄkm aam ɛtŋ ɛkn wus labm eb ɛs nyam eke wɛl bʼɛsŋ Levi. Li sig es wus labm eb usu, ɛtŋ Jesu dadʼr ninɛ: «Ùsʼm jam!» ");
INSERT INTO adj_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Levi igb wus, digŋ wus labm eb e juma a ɛlu es ɛtŋ usʼr jam. ");
INSERT INTO adj_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ow e jam a, Levi kok ob ij ligbɛl nyam in ogŋ a ↄŋ Jesu. Wus labm eb ɛsɛl nↄnↄ gbɛl lele agŋ ɛjecʼab yɛji anŋ ob ij ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Eke -nʼam ij ob a, Farisiɛl lele ɛl ɛm ecʼol e low yɛgm ɛsɛl ab ab am ɛny abr dad Jesu e jam ɛsɛl a ɛsɛ: «Kↄ bla ɛtŋ am ijr ɛtŋ am ɛgŋn lↄfu nyam ɛm wus labm eb ɛsɛl lele sikpl ɛsɛl ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesu ↄdu eb dad ɛl ninɛ: «Agŋ ekʼanŋ sos tuↄtuↄ ɛm a, íbram sos kok ɛs. Kↄ ↄ́lu anake bʼibrm sos kok ɛs a. ");
INSERT INTO adj_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mʼowm eke mi kʼɛsŋ agŋ eke bʼubr ɛl sosi nɛnyɛmbri nyam ɛsɛl a, kↄ mʼow eke mi kʼɛsŋ “sikpl ɛsɛl” yecʼɛtŋ ke -lʼitŋn ɛrm ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Sica agŋ bɛb am dad Jesu ɛsɛ: «Jan mij ok nuŋ ɛs e jam ɛsɛl a bʼɛnŋ nɛny ke ám ŋↄŋn Nyam, ɛtŋ Farisiɛl e jam ɛsɛl a yɛji bi kok ɛbɛn. Kↄ ŋ e jam ɛsɛl a am ij ob ɛtŋ am ɛgŋ!» ");
INSERT INTO adj_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ɛtŋ Jesu ↄdu eb dad ɛl ninɛ: «Kↄ ↄtur eke kʼɛdŋnin agŋ eke wɛl ɛsŋ mɛbi ecʼes gbɛgbl ɛm a ob ij, eke yↄw ɛc a anŋ ɛl ab ee? Njaŋ! ");
INSERT INTO adj_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Gbɛkↄ lɛgŋ am ow, eke wɛl bʼow ↄny yↄw ɛc a oc es ɛl ecʼaraŋn, ke sica -nʼɛnŋ nɛny gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Ɛmɛny Jesu dad ɛl nyandrɛ ɛm odad na ninɛ: «Ɛgŋ ócm gbad owr log ɛlum gbad sig ɛm gigŋm. Eke kok ɛbɛn, ke gbad owr a ŋuŋn a; ow kʼow okrm af gbad sig ab ab. ");
INSERT INTO adj_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ɛtŋ ɛmɛny ɛgŋ ócm mar owr okm marel sig ɛm. Eke kok ɛbɛn a, mar owr a bʼow inŋ toŋ bake ↄ́ny marel sig a ↄb es: mar a bʼow ok es ɛtŋ marel a bʼow uŋ. ");
INSERT INTO adj_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Kↄ mar owr, marel owr ɛm wɛl bʼokʼr. ");
INSERT INTO adj_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ɛgŋ ekʼɛgŋ mar sig ɛcm ab a, kʼow erurm mar owr ecʼɛgŋ aŋke li bʼow li dad eke mar sig a in akpl!» ");
INSERT INTO adj_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Nɛnɛgŋ nyam, Jesu lele in e jam ɛsɛl ab ab am ɛcr segb ↄgm eci. In e jam ɛsɛl a am bubm egb a ecʼey a, ɛtŋ -nʼam gag es -lʼij. ");
INSERT INTO adj_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ow ↄŋ ɛtŋ Farisiɛl bɛb am dad ɛl ɛsɛ: «Kↄ bla sosiɛm am kokr low eke ɛy ecʼol a ↄↄm abusu eke wɛl ki kok nɛnɛgŋ e lɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ɛtŋ Jesu dad ɛl ninɛ: «Awlmn low eke ɛb ebu David in obi in obi lele in ecʼagŋ ab ab kok lɛgŋ nyam eke namn am ↄny ɛl ab ee? ");
INSERT INTO adj_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Lʼɛy Nyamel ab ɛm, ɛtŋ in ecʼagŋ ab ab -lʼij egb waw eci futufutu a; ke -nʼↄnym ow ecʼij ecʼabusu kaka. Ɛy ecʼol a ↄŋ egb waw ɛsɛl sↄny coco abusu eke kʼij.» ");
INSERT INTO adj_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Ɛmɛny Jesu dad ɛl ninɛ: «Ɛgŋ ecʼIy el nɛnɛgŋ ecʼes ɛw ɛs.» ");
INSERT INTO adj_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Nɛnɛgŋ e lɛgŋ ɛjeci nyam, Jesu im ɛy Nyam nuŋ igŋ usu a am yɛgm agŋ low. Yogŋ nʼɛŋn igŋ nyam eke lidr abu wɛw es. ");
INSERT INTO adj_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ɛtŋ ol e low yɛgm ɛsɛl lele Farisiɛl ab am ↄsu Jesu eke -li kʼɛkn ekʼow bʼow ewlm ɛgŋ nɛnɛgŋ e lɛgŋ, aŋke -nʼam ↄl low ij nyam eke -li kʼebr ow af -nʼↄŋ ow dedeku. ");
INSERT INTO adj_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Kↄ Jesu uw ɛl e sow tutr ab any, ɛtŋ li dad igŋ a ekʼabu wɛw es a ninɛ: «Ìgb inym es araŋn aŋa agŋ a fɛŋ ecʼany af!» Ɛtŋ kpɛkŋ igŋ a igb inym es. ");
INSERT INTO adj_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ca Jesu dad ɛl ninɛ: «Dàdrʼm: nɛnɛgŋ e lɛgŋ a, bla lowi ɛy ecʼol a ↄŋ abusu eke wɛl ki kok ee? Low nimamn kↄ low ŋuŋ ee? Wɛl ↄtu eke ki sↄg ɛgŋ oglog wɛl ɛgbʼr es luw ee?» ");
INSERT INTO adj_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Eke Jesu ibrm ɛl ów amua bake ow uwr a, nʼam lɛr wɛl ɛtŋ li dad igŋ a ninɛ: «Ɛ̀gŋm abu es!» Ɛtŋ eke li bʼɛgŋm abu es a, in ecʼabu a ɛwl mɛny akplʼl. ");
INSERT INTO adj_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ol e low yɛgm ɛsɛl a lele Farisiɛl ab ab ɛrm am ebl, ɛtŋ -nʼam dadarir ɛl ↄfr elel eke -li ki kokr Jesu. ");
INSERT INTO adj_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ow e jam a, Jesu uyu lafɛny nyam af eke ki ŋↄŋn Nyam, ɛtŋ ni ŋↄŋn Nyam ncok nyam a nimum. ");
INSERT INTO adj_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Eke lɛgŋ ɛny a, lʼɛsŋ in e jam ɛsɛl a ɛtŋ li sↄsum lɛw yony lʼot, lʼɛw wɛl nin “ɛrm ɛsɛl”. ");
INSERT INTO adj_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ɛl ecʼen el: Simↄ, eke Jesu igŋ nin af Piɛr; lisijim Andre, Jak lele Jan ab, Filip lele Bartelemi ab, ");
INSERT INTO adj_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matie, Toma lele Jak, Alfe jim ab, Simↄ, ɛb dogŋn ɛs, ");
INSERT INTO adj_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas ekʼel Jak jim lele Judas Iskariↄt ekʼↄl Jesu ij ab ab. ");
INSERT INTO adj_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesu anŋ lafɛny ab af us es ɛrm ɛsɛl ab ab, ɛtŋ ow inym es lafɛny a ecʼesr pɛtɛ a. Yogŋ, in e jam ɛsɛl nↄnↄ gbɛl lele bieku bieku ekʼanŋ Jude, Jerusalɛm, Tir lele Sidↄn ekʼel ɛb yony ekʼanŋ okij any ab yɛji, ow. ");
INSERT INTO adj_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","-Lʼow eke -li kʼiri ow ecʼodad ke ow éwlm ɛl ecʼↄl a yɛji. Ɛtŋ agŋ eke abŋ eŋuŋ am ijr gbre a yɛji ewl. ");
INSERT INTO adj_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Agŋ a fɛŋ am ↄl eke kʼitŋn in abu, aŋke ewlm ecʼabusu e lɛc nyam bʼɛy ↄkm in ɛm ewlm agŋ a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesu is any lɛr in e jam ɛsɛl a ɛtŋ dad ɛl ninɛ: «Ɔny ekʼeel ↄgbↄru a, ehe él ↄny eci aŋke Nyam e gbreŋgbi usu a el ↄny eci! ");
INSERT INTO adj_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ɔny eke sica namn am ↄny ↄny a, ehe él ↄny eci aŋke lɛgŋ nyam am ow eke Nyam bʼow iyr ↄny lok! Ɔny eke sica am ikŋn ↄŋn a, ehe él ↄny eci aŋke bʼow ifir miyɛr! ");
INSERT INTO adj_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ehe él ↄny eci, ↄny eke agŋ am ifn ↄny, ebm ↄny ke am wɛwr ↄny, ke am dad ↄny ecʼodad eŋuŋ, eke eel ɛgŋ ecʼIy e jam ɛsɛl a sosiɛm a! ");
INSERT INTO adj_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sos ɛm íŋn ↄny! Ìgbr susr es eke ów nɛnɛ bʼɛŋn ↄny a, aŋke afr, ob ap ligbɛl nyam am eku ↄny. Ɛbɛn eke ɛl lagŋɛl a ijr kokoba ↄb ɛsɛl gbre ana. ");
INSERT INTO adj_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Kↄ ↄny egbreŋgbi a, gbre él ↄny eci, aŋke ɛŋan ↄny ecʼehe a godʼɛtŋ! ");
INSERT INTO adj_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Gbre él ↄny eci, ↄny eke lok iy ↄny a aŋke namn bʼow ↄny ↄny! Gbre él ↄny eci, ↄny eke am ifir miyɛr a aŋke bʼow ikŋn ↄŋn nↄnↄ! ");
INSERT INTO adj_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Gbre él ↄny eci, eke agŋ a fɛŋ bi dad ↄny e lís e low mamn. Ɛl lagŋɛl yɛji, ɛbɛn eke godo godo a -li dadr kokoba ↄb ɛsɛl ayadŋu a ecʼów amamn ana!» ");
INSERT INTO adj_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","«Ɔny ekʼam irir ɛm ecʼodad a, kin yecʼeke mʼam dad ↄny: èrurir ↄny ecʼefnu ke kókr ów amamn ↄŋn agŋ eke bʼifn ↄny a. ");
INSERT INTO adj_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Àfal agŋ a eke bʼofn ↄny ab es, ke ŋↄ́ŋan ↄŋn agŋ a eke bi kok ↄny ów eŋuŋ a. ");
INSERT INTO adj_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Ekʼɛgŋ bʼɛdŋʼŋ any af láwl ogog, ke ɛ̀wl ogog nyam a yɛji ↄŋʼn lʼɛ́dŋʼŋ. Ekʼɛgŋ bʼebʼŋ gbad, ke yɛ̀bʼr lʼéb ŋ e mob af ɛw a yɛji. ");
INSERT INTO adj_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɛgŋ fɛŋ eke bʼibrmʼŋ ob a, ↄŋʼn. Ɛtŋ ekʼɛgŋ oc ŋ ecʼob, ke kʼìbrmʼn kʼeb. ");
INSERT INTO adj_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Low fɛŋ ekʼam erurir eke agŋ ki kok ↄŋ ↄny a, ↄny yɛji kòkr ɛbɛn kpɛŋ ↄŋn agŋ ɛjecʼa. ");
INSERT INTO adj_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Eke bʼerurir agŋ a cɛ eke bʼerur ↄny a, ke bla low mamn iy am ekur eke bʼow ɛŋan ee? Sikpl ɛsɛl bↄbↄ yɛji bʼerur agŋ eke bʼerur ɛl a! ");
INSERT INTO adj_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ɛtŋ eke bi kokr low nimamn ↄŋn agŋ a sↄny cɛ eke bi kok ↄny low nimamn a, ke bla low mamn iy am ekur eke bʼow ɛŋan ee? Sikpl ɛsɛl bↄbↄ yɛji bi kok ɛbɛn! ");
INSERT INTO adj_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Kↄ eke ow el agŋ a sↄny cɛ ekʼam ↄman eke bʼow ↄwr ob ↄŋ ↄny a bʼabmnin ob, ke bla low mamn iy am ekur eke bʼow ɛŋan ee? Sikpl ɛsɛl yɛji bʼabmn ɛl lawlɛl sikpl ɛsɛl ob, yecʼɛtŋ ke ɛl yɛji wɛl ↄ́wr ↄŋ ɛl ɛbɛn kpɛŋ! ");
INSERT INTO adj_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Yecʼeke ki kokr a el: èrurir ↄny ecʼefnu, kòkr ɛl ów amamn. Àbmnin ɛl ob ke kʼↄ́mnmn eke -li kʼↄwr -nʼↄŋ ↄny. Eke bi kokr ɛbɛn a, bʼow ɛŋan ob ap ligbɛl ɛtŋ bʼow eel Nyam ekʼanŋ afr kpekpe ecʼey, aŋke Nyam akpl ɛtŋ li bi kok low mamn nʼↄŋ agŋ eŋuŋ lele agŋ ekʼuwm low mamn any ab. ");
INSERT INTO adj_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ɔny yɛji, èel ɛ́rm mamnu, ɛsɛ elel eke ɛy Ɛs el ɛrm mamnu ab af.» ");
INSERT INTO adj_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","«Kì jɛjr agŋ ecʼów kokr, yecʼɛtŋ ke Nyam kí jɛjm okm ↄny. Kʼↄ̀br agŋ low, yecʼɛtŋ ke Nyam yɛji kʼↄ́bm ↄny low. Òcr low apr agŋ ke Nyam yɛji óc low ap ↄny. ");
INSERT INTO adj_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ɔ̀ŋn agŋ ob, ke Nyam yɛji ↄ́ŋ ↄny ob yiyibr ↄny: ↄny e gbad a eke ↄkŋn eke wɛl kok ↄny ob ɛm a, wɛl bʼow ok ↄny ob ow íy gbↄŋ, tatakŋ es, gigigŋ es. Akunda yecʼɛm eke bʼocr ɛbmnin ob ↄŋn ɛgŋ ɛjecʼa, ow ɛm cɛ Nyam yɛji bʼow oc ɛbmn ↄŋ ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Ɛmɛny Jesu dad ɛl odad nyandrɛ ɛm ninɛ: «Kↄ any eflu ↄtu eke ki nyimn lawl any eflu ee? Eke ow el ɛbɛn a, ke ɛl yony mum -li bʼow -lʼok nↄmu nyam ɛm. ");
INSERT INTO adj_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Low wewr ɛs kaka ágbm akam in e low yɛgm ɛs; kↄ low wewr ɛs fɛŋ ekʼuw low any sɛnyn sɛnyn a bʼow anŋ ɛsɛ in e low yɛgm ɛs ab af. ");
INSERT INTO adj_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kↄ bla ɛtŋ am lɛr suwli ekʼanŋ esŋ jim e nyamn ɛm a, ɛtŋ ɛ́wm likŋ ikpr ekʼanŋʼŋ nyamn ɛm a e low ɛrm ee? ");
INSERT INTO adj_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ɛtŋ ayaf ↄtu eke ki dad esŋ jim ɛsɛ: “Lisijim, yɛ̀bʼm mʼↄ́ny suwli ekʼanŋʼŋ nyamn ɛm a mʼóc es, ke kʼɛ́knm likŋ ikpr ekʼanŋʼŋ nyamn ɛm ab ee?” Ɛnyɛmbri yony yony ɛs, ìkŋ anym ↄny likŋ ikpr ekʼanŋʼŋ nyamn ɛm a oc es, ke sica bʼow ɛkn es sɛnyn sɛnyn ↄ́ny esŋ jim e suwli ekʼanŋ nyamn ɛm a oc es.» ");
INSERT INTO adj_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","«Likŋ mamn ↄ́sum ey eŋuŋ, ɛtŋ likŋ ŋuŋ ↄ́sum ey amamn. ");
INSERT INTO adj_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Tasi ɛm a, wɛl bʼuw likŋ nyam nyam any in ecʼey ↄsu ɛm: wɛl ↄ́wm babm librebr ɛm, ɛtŋ wɛl ↄ́wm kↄkↄbri kati ɛm. ");
INSERT INTO adj_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ɛgŋ mamn, in ɛm ecʼów amamn eke bʼanŋ a anake li bʼoc lʼɛlu ↄkm a; ɛtŋ ɛgŋ nuŋ, in ɛm ecʼów eŋuŋ eke bʼanŋ a anake li bʼoc lʼɛlu ↄkm a. Low yecʼa ekʼiy ɛgŋ ecʼɛrm ɛm gbↄŋ a anake nɛny bi dad ɛlu ↄkm a.» ");
INSERT INTO adj_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","«Kↄ bla ɛtŋ bʼɛsŋnʼm “Ɛgŋ Gbɛl, Ɛgŋ Gbɛl” ɛtŋ am kokmn yecʼa eke mi bi dad ↄny ab ee? ");
INSERT INTO adj_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɛgŋ eke bʼow ɛm ogŋ iri ɛm ecʼodad, ke bʼucu ↄny es kok a, mʼam ow mi yɛgm ↄny ob eke li bʼot es a: ");
INSERT INTO adj_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","nʼanŋ ɛsɛ ɛgŋ nyam ekʼam us êl af, lʼagbr nↄmu im wus ɛm kpekpe ɛtŋ li sigm in ecʼêl ab es lebn af. Eke mij iy am ewl igŋ êl a, êl a ɛym wus aŋke ɛgŋ na usʼr lʼakpl. ");
INSERT INTO adj_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Kↄ ɛgŋ eke am iri ɛm ecʼodad a ke úcum ↄnym es kokm ɛsɛ elel eke nʼam iri ab af a, anŋ ɛsɛ ɛgŋ nyam ekʼam us êl sɛc af ke agbrm nↄmu yɛji af. Eke mij iy am ewl igŋ êl a, kpɛkŋ êl a ɛy wus gbruu bubm es nimum!» ");
INSERT INTO adj_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Eke Jesu dad agŋ a odad bake ow uwr a, nʼim Kapɛrnayum. ");
INSERT INTO adj_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Yogŋ, Rom eci srↄda eyŋ ekŋ yen ecʼanym ɛs nyam ↄny in e juma kok ɛs nyam eke lʼerur nↄnↄ; ɛtŋ juma kok ɛs a ↄl am ↄny toŋ batŋ am ow uw. ");
INSERT INTO adj_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Eke lʼiri wɛl dadʼr Jesu e low a, lʼɛrm Jwifɛl ecʼagŋ ekpekp bɛb im am ɛsŋʼn eke li kʼow lʼewlm in e juma kok ɛs a. ");
INSERT INTO adj_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","-Nʼim -nʼɛŋn ow ɛtŋ -nʼam ŋↄŋn ow atrm ɛm -li dad -lʼɛsɛ: «Ɛgŋ na ekʼɛrm ɛy a it eke kʼɛŋn in ecʼabu ɛlum. ");
INSERT INTO adj_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Lʼerur ɛy ecʼɛb na ɛtŋ in anake nʼↄŋ ke wɛl us ɛy e Nyam nuŋ igŋ usu a.» ");
INSERT INTO adj_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Eke Jwifɛl a dad ów amua ok Jesu a, lʼɛgŋ ɛtŋ kpɛkŋ nʼaam wɛl ab. Ow anŋ tɛl ke -lʼok gbugŋ, ɛtŋ ɛmɛny anym ɛs a ɛrm lawlɛl eke kʼim dadʼr ɛsɛ: «Ɛgŋ gbɛl, ɛs ow ɛs dadʼŋ eke ŋ kʼìjr sos gbre ŋ kʼow yɛji, kↄ in itm eke ŋ kʼɛy in e gbugŋ a; ");
INSERT INTO adj_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","na sosiɛm anake in igbm in obi in owm toŋ bake in ɛŋnʼŋ a. Kↄ ŋ dád odad ebl nyam cɛ, ke kpɛkŋ in e juma kok ɛs a in bʼow in ewl. ");
INSERT INTO adj_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","In obi yɛji in anŋ abusu ɛsɛl ekpekp ecʼew, ɛtŋ in ↄny srↄda eyŋ eke in ɛw es. Eke in bi dad nyam in ɛsɛ: “Ìm!”, kpɛkŋ owʼn bʼim; in bi dad ɛjeci in ɛsɛ: “Òw!”, kpɛkŋ owʼn bʼow; ɛtŋ eke in bi dad in e juma kok ɛs in ɛsɛ: “Kòk low na!”, kpɛkŋ owʼn bi kok low a.» ");
INSERT INTO adj_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Eke Jesu iri sodad amua eke wɛl ow dadʼr a, lʼerur anym ɛs a e low. Sica lʼɛwl mɛny nʼam dad agŋ a ekʼam usʼr jam a lʼɛsɛ: «Mʼam dad ↄny, mʼɛŋnm ↄmn ɛs nɛnɛ kaka Israɛl eyŋ ɛm bↄbↄ yɛji.» ");
INSERT INTO adj_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Agŋ a eke wɛl ɛrm a ɛwl mɛny im anym ɛs a e gbugŋ a, ɛtŋ -lʼɛkn eke juma kok ɛs a ewl. ");
INSERT INTO adj_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eke low na ɛc a, Jesu aam baŋn nyam eke wɛl bʼɛsŋ Nayin; ɛtŋ in e jam ɛsɛl a lele agŋ nↄnↄ gbɛl ab am usʼr jam. ");
INSERT INTO adj_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Eke nʼam titm baŋn ecʼɛm ɛy usu a, wɛl oc ɛgŋ nyam ekʼuw a aam oc es ɛtŋ baŋn a ecʼagŋ nↄnↄ gbɛl yɛji aam ɛl ab. Ow el iŋnyↄw nyam ecʼiy ekpↄbi. ");
INSERT INTO adj_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Eke Ɛs Kↄtↄkↄ ɛkn yↄw a, ow e low ↄnyʼn sↄrŋ ɛtŋ li dad ow ninɛ: «Kʼìkŋ ↄŋn!» ");
INSERT INTO adj_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Kpɛkŋ li tat nʼim lʼitŋn lɛblakp a abu, ɛtŋ agŋ a inym es. Li dad ninɛ: «Ŋgbafrɛli, mʼam dadʼŋ, ìgb!» ");
INSERT INTO adj_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ɛtŋ ɛgŋ a ekʼuw a igb inym es ɛtŋ am dad odad. Ɛtŋ Jesu dad lis ninɛ: «Kin ŋ ecʼiy a.» ");
INSERT INTO adj_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Agŋ a fɛŋ erŋn am ↄny ɛtŋ am kↄklm Nyam dad ɛsɛ: «Kokoba ↄb ɛs ligbɛl nyam ɛy ↄkm ɛy ɛm! Nyam ow am ɛlum in ecʼagŋ abu!» ");
INSERT INTO adj_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ɛtŋ Jude wus ab af lele baŋn a fɛŋ eke ɛlulil ɛm ab ab iri low a eke Jesu kok a. ");
INSERT INTO adj_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Jan e jam ɛsɛl a im dad ów a fɛŋ eke Jesu kok a ok Jan. Lʼɛsŋ ɛl ɛm ecʼagŋ yony, ");
INSERT INTO adj_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ɛtŋ lʼɛrm wɛl Ɛs Kↄtↄkↄ ogŋ eke -li kʼibrm ow eke ow el Mesi a eke ow a, oglog ɛgŋ ɛjeci -li kʼeku. ");
INSERT INTO adj_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Eke jam ɛsɛl yony a im ok yogŋ a, -li dad Jesu ninɛ: «Jan mij ok nuŋ ɛs ɛrm ɛy sʼow eke si kʼibrmʼŋ: “Kↄ ŋ, ŋ el ɛgŋ a eke ɛl uw any eke in bʼow in ow a, oglog ɛgŋ ɛjeci ɛl kʼeku ee?” » ");
INSERT INTO adj_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Wanci ab af a, Jesu am ewlm agŋ nↄnↄ ekʼↄl akpasu akpasu am ↄny, nʼam ogŋ agŋ nↄnↄ ecʼabŋ eŋuŋ; ɛtŋ nʼam ↄŋ ány eflu nↄnↄ ɛkn es. ");
INSERT INTO adj_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Ɛtŋ li dad agŋ a eke Jan ɛrm a ninɛ: «Ìmn ke dádr Jan low a eke ɛkan ke irir a: ány eflu am ɛkn es, akr kpɛcɛ ɛsɛl am an es, kokobe ɛsɛl yɛji am ewl, ↄ́ru ablu yɛji am iri ów, agŋ ekʼuw a yɛji am igb, ɛtŋ wɛl am ↄb Amani Mamn a e kokoba ok ↄgbↄru. ");
INSERT INTO adj_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Ehe él ɛgŋ a eke kʼow irmnm in ecʼↄmn eke nʼↄny ɛm ɛm a eci!» ");
INSERT INTO adj_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Eke Jan ecʼagŋ a ekʼɛrm a ɛwl mɛny im a, Jesu oc Jan e lís e low am ibrm agŋ a ɛsɛ: «Kↄ loj yogŋ bla imn eke kʼɛkan ee? Kↄ ɛgŋ ekʼanŋ ɛsɛ anany eke lɛf am ↄny mumu af ee? Njaŋ! ");
INSERT INTO adj_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ca eke ow elm ɛbɛn a, ke bla imn ɛkan ee? Ɛgŋ eke sus mob sɛnyn ee? Njaŋ! Agŋ eke bi sus mob sɛnyn sɛnyn íj ɛb a, ɛ́b ebu e gbugŋ -li bʼanŋ. ");
INSERT INTO adj_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ɛtŋ ca bla tasi imn ɛkan ee? Kↄ kokoba ↄb ɛs nyam ee? Ɛɛ, mʼam dad ↄny eke ɛgŋ a ekʼɛkan a agb akm kokoba ↄb ɛs. ");
INSERT INTO adj_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nyam Lɛl ɛm a, Nyam dad Jan e lís e low ninɛ: Kin, mʼam ↄŋ ɛm ecʼɛrm ɛs íkŋʼŋ anym kok ŋ ecʼejagb a.» ");
INSERT INTO adj_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ɛmɛny Jesu dad ɛl ninɛ: «Mʼam dad ↄny eke agŋ eke wɛl ew ab ɛm, ɛgŋ kaka anm ekʼagb akm Jan; kↄ Nyam e gbreŋgbi usu a ecʼagŋ ekʼanŋ a e likekli a agb akmʼn.» ");
INSERT INTO adj_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Agŋ nↄnↄ toŋ wus labm eb ɛsɛl bↄbↄ yɛji ekʼiri Jesu ecʼodad a, uw any eke Nyam e low a nawrɛ, aŋke -lʼɛgŋ Jan ok ɛl mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Kↄ Farisiɛl lele ol e low any uw ɛsɛl ab ab ɛgŋm Nyam e low eke ki kok ↄŋ ɛl a ebm, aŋke -lʼɛgŋm eke Jan kʼok ɛl mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ɛmɛny Jesu dad ninɛ: «Bwo ecʼɛgŋ mʼↄtu eke mi kʼoc mi bɛbmn yɛfɛnyna ecʼagŋ ab ab ee? Bogŋ ecʼagŋ -lʼot es ee? ");
INSERT INTO adj_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","-Lʼot etuey ekʼanŋ an ↄl usu es ke am dad lebl gege ɛm ɛsɛ: “Sʼafl kete ɛj ub eci sʼok ↄny, ɛtŋ ɛgŋmn eke kʼubr ɛj! Sʼɛgŋ sↄrŋ ɛj sʼok ↄny, ɛtŋ ɛgŋmn okmn sabu ɛrmni ikŋmn ↄŋn!” ");
INSERT INTO adj_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Kin Jan ekʼow a, li bʼɛnŋ nɛny, lʼɛ́gŋm mar, ɛtŋ ↄny bi dadr ekʼowʼn ↄny abŋ ŋuŋ! ");
INSERT INTO adj_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Sica ɛgŋ ecʼIy ekʼow a, li bʼij ob, li bʼɛgŋ mar, ɛtŋ ↄny cɛ bi dadr eke ɛgŋ ikŋ na, in el ob iju, mar ɛgŋu, wus labm eb ɛsɛl lele sikpl ɛsɛl ab e lawl! ");
INSERT INTO adj_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Agŋ a eke ɛgŋ Nyam e sɛwr a eb a uw any eke sɛwr a el low nɛnyɛmbri nyam.» ");
INSERT INTO adj_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Lɛgŋ nyam, Farisi nyam eke wɛl bʼɛsŋ Simↄ ɛsŋ Jesu eke kʼow ij ob in ab. Jesu ɛgŋ ɛtŋ im ɛy in e gbugŋ a sig es ob ij usu. ");
INSERT INTO adj_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Baŋn yogŋ yↄw nyam eke nin uŋ a anŋ. Eke lʼiri eke Jesu anŋ ob ij usu Farisi a e gbugŋ a, lʼow yogŋ. Nʼↄnym mijey kↄk nyam eke wɛl kok lebn eke wɛl bʼɛsŋ albatr ɛm ab, ke mijey sŋↄsŋↄ iy ɛm gbↄŋ. ");
INSERT INTO adj_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Lʼis es Jesu ecʼakr esr nʼam ikŋ ↄŋn lʼↄpar ow akr es in e mikŋ ab ɛm, lʼoc in e sin nuŋ a nʼam tɛtŋ ow es; nʼam ɛy ow akr af li joj ow akr, ɛtŋ nʼam ok ow mijey a. ");
INSERT INTO adj_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Eke Farisi a bʼɛkn ɛbɛn a, nʼam dad in ɛm lʼɛsɛ: «Blel igŋ na el kokoba ↄb ɛs tasi ana, ke blel lʼúw any eke yↄw na ekʼam titŋn in sabu a el yↄw eke nin uŋ.» ");
INSERT INTO adj_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Kↄ Jesu dad Farisi a ninɛ: «Simↄ, mʼↄny low eke mi ki dadʼŋ.» Ɛtŋ Simↄ ↄdu eb dad ninɛ: «Low yɛgm agŋ ɛs, dàd gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ɛtŋ lʼub ow nyandrɛ nyam li dad ninɛ: «Agŋ yony abmn os ɛgŋ nyam ogŋ: nyam ij os ekŋ yen yen sakp yen e labm, ɛtŋ nyam a ij os ekŋ yony lele lɛw ab e labm. ");
INSERT INTO adj_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɛl yony mum -lʼↄtum -li sↄgm labm a, ɛtŋ igŋ a oc ap ɛl. Kↄ ɛl yony na ɛm a, bwo ecʼɛgŋ anake bʼow erur igŋ a akm lawl ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ɛtŋ Simↄ ninɛ: «Mʼam tutr ke ɛgŋ eke wɛl oc in e labm nↄnↄ a ap a.» Jesu ɛgŋ ninɛ: «Ow tasi anake dad a.» ");
INSERT INTO adj_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ɛtŋ kpɛkŋ lʼɛwl mɛny lʼↄkŋ yↄw ab any ɛtŋ li dad Simↄ ninɛ: «Kↄ am ɛkn yↄw na! Mʼow mʼɛyʼŋ gbugŋ ɛtŋ ↄↄm im mij akr es yↄg eci. Kↄ in, li yↄgʼm akr es in e mikŋ ab ɛm ɛtŋ li tɛtŋ es in e sin nuŋ ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Eke mʼow a, ɛym im af. Kↄ in, anym ɛtŋ nʼam ɛyʼm akr af li jójʼm akr. ");
INSERT INTO adj_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Okm im mun nuŋ, kↄ in lʼokʼm mijey akr. ");
INSERT INTO adj_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Na sosiɛm mʼam dadʼŋ: erur ligbɛl na eke lʼɛlu ↄkm a am yɛgm eke in e sikpl nↄnↄ gbɛl a yɛji wɛl oc apʼr. Kↄ ɛgŋ eke wɛl ap sikpl tɛl a, erur tɛl cɛ li bʼɛlu ↄkm.» ");
INSERT INTO adj_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ɛtŋ li dad yↄw a ninɛ: «Mʼoc ŋ e sikpl a mʼapʼŋ.» ");
INSERT INTO adj_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Agŋ a ekʼanŋ yogŋ am ij ob ɛl ab a am dad ɛl ↄfr ɛm ɛsɛ: «Kↄ bwo el ɛgŋ na ɛtŋ li kʼap ɛgŋ sikpl ee?» ");
INSERT INTO adj_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Kↄ Jesu dad yↄw a ninɛ: «Ŋ ecʼↄmn a eb ɛluʼŋ es; ìm ɛrm es ɛy ɛm gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","2","Eke na bʼɛc a, Jesu am ɛc baŋn ɛgbɛl ɛm lel ekekey ɛm ab dad Nyam e gbreŋgbi usu a ecʼAmani Mamn ecʼodad. In e jam ɛsɛl lɛw yony a lel ↄyↄw bɛb eke lʼogŋ abŋ eŋuŋ wɛl e lís ke lʼewlm wɛl ↄl ɛm ab yɛji am usʼr jam: Mari Magdala yↄwi a eke ow ɛm lʼogŋ abŋ eŋuŋ lↄbŋ a; ");
INSERT INTO adj_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Jana, Erↄd e gbugŋ a ecʼes ɛw ɛs nyam eke wɛl bʼɛsŋ Kusa e yↄw; Susan lele ↄyↄw nↄnↄ gbɛl eke bʼis Jesu lele in e jam ɛsɛl ab ab abu ɛlum. ");
INSERT INTO adj_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Eke agŋ nↄnↄ anŋ baŋn baŋn am ow Jesu ogŋ, ke sica ɛl fɛŋ -lʼasr luku a, li dad wɛl odad nyandrɛ ɛm ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Lɛgŋ nyam, egb ewl ɛs nyam im ↄgm am ewl egb. Eke nʼam ufŋ egb ey ab es a, bɛb ok ebr af: agŋ uyu af ɛtŋ ↄr ow sus ij. ");
INSERT INTO adj_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Bɛb ok mebn wus af. Eke egb a ɛli a, -li wɛw es aŋke -nʼɛŋnm sɛc prↄprↄ eke -li kʼakpl. ");
INSERT INTO adj_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Bɛb ok mirŋ wus af. Kpɛkŋ mirŋ a ɛli ok ↄkm egb amamn ab ab, ɛtŋ ↄny egb amamn a awŋ es. ");
INSERT INTO adj_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ɛtŋ ɛmɛny bɛb ok wus mamn af. Egb a ɛli ɛtŋ ↄsu ey: nyam ↄsu ey ekŋ yen.» Ɛtŋ Jesu igbl lebl ogŋ dad ninɛ: «Ekʼↄnyn ↄru eke kʼirir, ke írir sɛnyn sɛnyn!» ");
INSERT INTO adj_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Eke li dad nyandrɛ ɛm ecʼodad na bake ow uwr a, in e jam ɛsɛl a am ibrmʼn odad a e nyandrɛ. ");
INSERT INTO adj_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ɛtŋ li dad wɛl ninɛ: «Ɔny, ɛŋan Nyam eci gbreŋgbi usu a ecʼów a eke lↄl es a ecʼany uw. Kↄ agŋ ɛjecʼa, ɛl -lʼuwmn any. Nyandrɛ ɛm wɛl ki dad yecʼɛtŋ ke -li bi lɛr yɛji -li kʼɛknmn; -li bʼiri yɛji -li kʼuwmn any.» ");
INSERT INTO adj_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","«Kin odad a e nyandrɛ: egb a el Nyam ecʼodad. ");
INSERT INTO adj_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ebr ab af a eke egb a ok a, el agŋ a eke bʼiri Nyam odad, ke agn bʼↄny odad a oc es ɛl ecʼɛrm ɛm yecʼɛtŋ ke -li kʼubmn nawrɛ bake -nʼɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Mebn wus a eke egb a ok a, el agŋ a eke bʼiri odad a ke bʼebʼr sos ɛm iŋn ɛm a, kↄ ow ókm min ɛl ɛm. -Lʼubmn nawrɛ ow ibnm, ɛtŋ eke -li bʼↄbr gbre a -li bi digŋ ɛl ecʼↄmn a -lʼɛlu es. ");
INSERT INTO adj_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Wus a eke mirŋ nↄnↄ anŋ af ke egb a ok af a, el agŋ a eke bʼiri odad a ke bʼebr wus na ecʼowr anŋ ecʼɛrmij a, bʼↄl ob ↄny lel ɛb ij owi ab es a. Ów amua na bʼↄny awŋ ɛl es, ɛtŋ -li kokmn ów amamn. ");
INSERT INTO adj_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Wus mamn a el agŋ eke bʼiri odad a ke bʼeb ɛw es ɛl ecʼɛrm tasi ab ɛm a; -li bʼij nɛnyɛmbri nyam ɛtŋ -li bi kok ów amamn.» ");
INSERT INTO adj_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Ɛmɛny Jesu dad nyandrɛ ɛm ecʼodad na ninɛ: «Ɛgŋ ígŋm kɛniɛ uburm es lↄfu ew, oglog kofa ew. Kↄ bʼigŋ kɛniɛ a, ke ítm es ob es itm ob af, yecʼɛtŋ ke agŋ eke bʼok akŋ a ám ɛkn usuayl a. ");
INSERT INTO adj_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Low eke lↄl es agŋ ɛ́knm a, -li bʼow -lʼɛkn; ɛtŋ low eke agŋ úwm any a, -li bʼow -lʼuw any ke -lʼiri yɛji. ");
INSERT INTO adj_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Na sosiɛm, ɛ̀wr ɛrm elel eke am iririr ab ɛm! Aŋke ɛgŋ ekʼiri odad a ke ucu ↄny es a, Nyam bʼow obnʼn; kↄ ɛgŋ ekʼirim kaka a, tɛl a eke nʼam tutr eke lʼiri a yɛji, wɛl bʼow ↄny ocʼr es ɛrm af.» ");
INSERT INTO adj_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesu lis lele lisijimɛl ab ow ok yogŋ a eke Jesu anŋ a, kↄ -lʼↄtum eke -li kʼim bake -li titm ow bieku a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ɛtŋ agŋ a ekʼanŋ yogŋ a am dad Jesu ɛsɛ: «Kin esŋ lele esŋ jimɛl ab ekʼow inym es gbeŋ. -Nʼam erur eke -li kʼɛknʼŋ.» ");
INSERT INTO adj_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Kↄ Jesu dad agŋ a fɛŋ ninɛ: «Ɛm lis lele ɛm lisijimɛl ab a el agŋ a eke am iri Nyam ecʼodad ke am ɛlum a.» ");
INSERT INTO adj_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Lɛgŋ nyam Jesu lele in e jam ɛsɛl ab ab ok mijɛtŋ nyam ɛm ɛtŋ li dad wɛl ninɛ: «Sʼúbr mij lekpl na e jam a!» Ɛtŋ -lʼok lɛtŋ ab ɛm -nʼaam. ");
INSERT INTO adj_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Eke -nʼam ↄr mij -nʼim a, Jesu am ɛru mɛmn. Kpru ɛm lidgbegb ligbɛl nyam igb mij lekpl ab af, ɛtŋ mij am ok ɛl lɛtŋ ɛm toŋ batŋ ow am iy, ɛtŋ jam ɛsɛl a anŋ ɛrmij ɛm. ");
INSERT INTO adj_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","-Nʼim -nʼam uwr Jesu ɛtŋ -nʼam ↄg -li dad -lʼɛsɛ: «Ɛgŋ gbɛl, ɛgŋ gbɛl, sʼam uw!» Jesu ufŋm es ɛtŋ dad lidgbegb a lele mra ab ab odad lebl tuↄtuↄ ɛm ɛtŋ -lʼadr. Ɛtŋ usu a fɛŋ irm es tiŋ. ");
INSERT INTO adj_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Sica lʼibrm in e jam ɛsɛl a ninɛ: «Bogŋ ↄny ecʼↄmn ab a ee?» Kↄ erŋn am ↄny ɛl, low iti ɛl any ɛtŋ -nʼam dadarir ɛl ↄfr -lʼɛsɛ: «Kↄ bwo ecʼɛgŋ el ɛgŋ na ee? Li bi dad lɛf lele mij ab odad, ɛtŋ wɛl bʼɛlumʼn!» ");
INSERT INTO adj_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Jesu lele in e jam ɛsɛl ab ab ubr mij lekpl a jam. Ca -nʼim -lʼok Geraseni wus af ekʼanŋ Galile any af a. ");
INSERT INTO adj_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Eke Jesu anŋ lɛtŋ ɛm us es wus a, baŋn a ecʼɛgŋ nyam am ow ↄbrʼr. Ɛgŋ a abŋ eŋuŋ bʼijrʼr gbre. Lɛgŋ kpekpe ɛtŋ li bʼanŋ sos ↄfr; nʼánm akŋ kↄ suwↄmu ɛm ↄfr li bʼanŋ. ");
INSERT INTO adj_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Eke li bʼɛkn Jesu a, li barm ɛtŋ lʼɛy lʼubu es ow ecʼany af, ɛtŋ nʼam dad odad lebl tuↄtuↄ ɛm lʼɛsɛ: «Jesu, Nyam ekʼanŋ afr kpekpe ecʼIy, kↄ bla lowi anŋ ɛy araŋn ee? Mʼam ŋↄŋnʼŋ, kʼìjrʼm gbre!» ");
INSERT INTO adj_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Nʼam dad ɛbɛn aŋke Jesu am ogŋ abŋ ŋuŋ a eke kʼɛy ↄkm in ɛm. Sakp nↄnↄ, eke abŋ akpasu na bʼɛyʼr af a, wɛl bʼawŋʼn akr lele sabu ab ŋgbraka ɛm am ↄsuʼr. Kↄ li bi dɛdŋ ŋgbraka ab es, ɛtŋ abŋ a bʼoc ɛluʼl loj nʼam adŋ es. ");
INSERT INTO adj_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesu ibrmʼn ninɛ: «Kↄ ayaf wɛl bʼɛsŋnʼŋ ee?» Ɛtŋ li dad ninɛ: «Ɛm e nin el “Bubutɛ” » (eke abŋ eŋuŋ nↄnↄ anŋʼn ɛm a sosiɛm). ");
INSERT INTO adj_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ɛtŋ abŋ eŋuŋ a am ŋↄŋn Jesu dad ɛsɛ: «Kʼògŋ ɛy si kʼim si kʼok nↄmu croŋ gbɛl ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Lafɛny nyam anŋ yogŋ eke gbroko nↄnↄ anŋ af am ij ob. Abŋ eŋuŋ a am ŋↄŋn Jesu eke ow kʼↄ́ŋ ɛl abusu -nʼim -lʼok sigbroko ab ɛm, ɛtŋ nʼↄŋ wɛl abusu. ");
INSERT INTO adj_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Abŋ eŋuŋ a ok ↄkm igŋ ab ɛm im ok sigbroko ab ɛm, ɛtŋ gbroko a fɛŋ anŋ lafɛny ab af uru es im ok mij lekpl ab ɛm, ɛtŋ -nʼɛmn. ");
INSERT INTO adj_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Eke agŋ a ekʼam ↄsu sigbroko a bʼɛkn low na ekʼɛy a, -lʼuru es -nʼim -lʼↄb amani -lʼok baŋn a lele sikpukpu ɛm ab ab ecʼagŋ a. ");
INSERT INTO adj_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Agŋ a fɛŋ ekʼiri low na ekʼɛy a ok ↄkm aam ɛkn. -Lʼow -nʼɛŋn Jesu ɛtŋ -lʼɛkn igŋ a eke abŋ eŋuŋ anŋ ɛm ok ↄkm a eke sus mob sig es Jesu saw, ke nuŋ ɛm ayal. Ɛtŋ agŋ a erŋn am ↄny. ");
INSERT INTO adj_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Agŋ ekʼɛkn low na a am dad ɛl elel eke abŋ eŋuŋ ɛs a ewl a. ");
INSERT INTO adj_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ɛtŋ Geraseni eyŋ a ow nↄnↄ am dad Jesu eke kʼŋgboŋ ɛl e wus ab af, eke erŋn am ↄny ɛl a sosiɛm. Ɛtŋ Jesu ɛy lɛtŋ ɛm eke kʼim. ");
INSERT INTO adj_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Sica igŋ a eke lʼogŋ abŋ eŋuŋ ok ↄkm in ɛm a am ŋↄŋnʼn eke li kʼanŋ ow ab. Kↄ Jesu dadʼr ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","«Ɛ̀wl mɛny im gbugŋ ke ↄ́b low a eke Nyam kokʼŋ a ecʼamani ok agŋ.» Igŋ a ɛwl im ɛtŋ am dad baŋn a nimum ecʼagŋ a, low a eke Jesu kok ↄŋʼn a e low. ");
INSERT INTO adj_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Eke Jesu anŋ mij jam a ow a, agŋ a ekʼim am ekuʼr a ebʼr. ");
INSERT INTO adj_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Igŋ nyam eke wɛl bʼɛsŋ Jayirus ow ɛŋnʼn; lʼel Jwifɛl e Nyam nuŋ igŋ usu a ecʼes ɛw ɛs nyam. Lʼok ↄwrↄkp wus Jesu ecʼany af, ɛtŋ nʼam ŋↄŋn ow eke ow kʼow in ogŋ a, ");
INSERT INTO adj_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","aŋke nʼↄny iy yↄwli ekpↄbi ekʼij akpo lɛw yony ke am uw. Ɛtŋ kpɛkŋ Jesu igb aam yogŋ. Eke nʼaam a, agŋ nↄnↄ iwr ɛlul il ɛm am atrʼr sel. ");
INSERT INTO adj_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Yogŋ, yↄw nyam eke bʼub abu ke mebl a ɛ́dŋm es toŋ ow ij akpo lɛw yony a anŋ. Ni ŋuŋn in ecʼob eke nʼↄny a sos kok ɛsɛl ogŋ, kↄ ɛbɛn yɛji ɛgŋ kaka ↄtum ewlamʼn. ");
INSERT INTO adj_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Lʼɛcr jam jam eci lʼow li titm Jesu ɛtŋ lʼitŋn ow e mob sus ɛm a eci ɛnyɛmbri a abu, ɛtŋ kpɛkŋ mebl a ekʼam okʼr a ɛdŋ es. ");
INSERT INTO adj_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jesu ibrm ninɛ: «Kↄ bwo itŋnʼm abu ee?» Ɛtŋ ɛl fɛŋ -nʼam dad eke ɛl ɛknm. Kↄ Piɛr dad ninɛ: «Low yɛgm agŋ ɛs, kↄ ɛ́knm bieku na ekʼiwr did ɛlulʼŋ ɛm am atrʼŋ sel ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Kↄ Jesu dad ninɛ: «Nawrɛ tasi, ɛgŋ ɛkn piy ɛtŋ itŋnʼm abu, aŋke mʼɛkn eke lɛc nyam ɛy ↄkm ɛm ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Yↄw a bʼɛkn eke low a lↄlm es a, sos ufŋ ɛm lʼow lʼɛy Jesu ecʼakr af a, ɛtŋ li dad agŋ a fɛŋ ecʼany af low a sosiɛm eke lʼitŋn ow abu, ke kpɛkŋ lʼewl a. ");
INSERT INTO adj_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ɛtŋ Jesu dad yↄw a ninɛ: «Ɛm jↄw, ŋ ecʼↄmn a ewlmʼŋ! Ìm ɛrm es ɛy ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesu odad anŋ nɛnym am dad, ɛtŋ wɛl ɛrm ɛgŋ nyam anŋ Jayirus ogŋ a ow. Nʼam dad ow lʼɛsɛ: «Ejↄŋ uw! Kʼìjr low yɛgm agŋ ɛs gbre ↄfr ↄfr.» ");
INSERT INTO adj_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Eke Jesu bʼiri ɛbɛn a, li dad Jayirus ninɛ: «Kʼùru erŋn, kↄ ↄny ↄmn sↄny coco cɛ; li bʼow lʼigb.» ");
INSERT INTO adj_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Eke nʼim lʼɛy gbugŋ a, nʼↄↄm ɛgŋ kaka abusu eke kʼɛy akŋ a in ab, ekʼow elm Piɛr, Jan, Jak, lele iy ɛs a lele iy lis ab cɛ. ");
INSERT INTO adj_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Agŋ a fɛŋ am ikŋ ↄŋn ok sabu ɛrmni iy a sosiɛm. Kↄ Jesu dad ɛl ninɛ: «Kʼìkŋn ↄŋn! Dedyↄwli a lʼuwm kↄ mɛmn nʼam ɛru.» ");
INSERT INTO adj_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kↄ eke Jesu dad ɛbɛn a, -nʼam kokr ow miyɛr aŋke -lʼuw any eke dedyↄwli a uw. ");
INSERT INTO adj_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Kↄ Jesu im ucu iy a abu ↄny ɛtŋ dad lebl tuↄtuↄ ɛm ninɛ: «Dedyↄwli, ìgb wus!» ");
INSERT INTO adj_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Dedyↄwli a ɛwl anŋ owr ɛtŋ kpɛkŋ igb wus. Ɛtŋ Jesu dad ɛl ninɛ: «Ɔ̀ŋn in ob lʼíj.» ");
INSERT INTO adj_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Iy ɛs a lele iy lis ab ab low iti any, kↄ Jesu ɛdŋn ɛl eke -li ki dadmn low a ekʼɛy a -lʼokmn ɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Lɛgŋ nyam Jesu as in e jam ɛsɛl lɛw yony a luku, ɛtŋ nʼↄŋ wɛl abusu lele lɛc ab eke -li kʼogŋ abŋ eŋuŋ fɛŋ ke -lʼewlm ↄl ɛsɛl. ");
INSERT INTO adj_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɛtŋ lʼɛrm wɛl eke -li kʼim -li dad Nyam e gbreŋgbi usu a ecʼodad, ke -lʼewlm ↄ́lu. ");
INSERT INTO adj_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nʼↄm wɛl ów ninɛ: «Kʼòcr usu im ecʼob kaka kʼↄnymn ab: kpama, ekpr, ob ij, os yɛji. Ke ↄny ɛm ecʼɛgŋ kaka kʼócm mob sus ɛm ɛjeci akrm af. ");
INSERT INTO adj_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Usu fɛŋ eke wɛl bʼow eb ↄny a, ànŋn gbugŋ a cɛ toŋ bake ŋ́gbroŋn yogŋ a. ");
INSERT INTO adj_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Usu fɛŋ eke agŋ kʼow ɛgŋm ebm ↄny a, ŋ̀gbroŋn ɛl ecʼɛb ab ɛm, ke cícr ↄny ecʼakr sɛc a okr ɛl es. Na bʼow ij ɛl e nuŋ af e daŋku Nyam ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Jam ɛsɛl a im ɛtŋ am ɛc baŋn baŋn fɛŋ dad Amani Mamn a ecʼodad, ɛtŋ usu a fɛŋ -nʼam ewlm ↄ́lu. ");
INSERT INTO adj_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lɛgŋ ab ɛm a, Erↄd Antipas ekʼel Galile wus af ecʼes ɛw ɛs a iri wɛl am dad ów a ekʼam ɛy a ecʼamani. Ɛtŋ lʼúwm elel eke li ki dadr any, aŋke agŋ bɛb am dad ɛsɛ Jan mij ok nuŋ ɛs ekʼin uw a, in igb luw ɛm. ");
INSERT INTO adj_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Agŋ oglog am dad eke owʼn bʼow in el kokoba ↄb ɛs Eli anake in ɛwl in ow a. Ɛtŋ bɛb am dad eke owʼn bʼow in el godo godo e kokoba ↄb ɛsɛl a e nyam anake in igb luw ɛm a. ");
INSERT INTO adj_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Kↄ Erↄd am tutr ów dad ɛsɛ: «Kↄ mʼubr Jan nuŋ; ɛtŋ bogŋ ecʼɛgŋ anake mʼam iri in e lís ecʼów ab ee?» Ɛtŋ nʼam ↄl eke li kʼɛkn Jesu. ");
INSERT INTO adj_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Eke ɛrm ɛsɛl a ɛwl mɛny ow a, -nʼam dad Jesu ów a fɛŋ eke -li kokr a e low. Ɛtŋ Jesu ot ɛl ab im baŋn nyam eke wɛl bʼɛsŋ Bɛtsayida e saw eke -li kʼanŋ ɛl sↄny. ");
INSERT INTO adj_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Kↄ eke -lʼokr yogŋ a, agŋ nↄnↄ gbɛl uw any ɛtŋ am usʼr jam im. Jesu eb ɛl ɛtŋ am dad ɛl Nyam e gbreŋgbi usu a e low ɛtŋ nʼam ewlm ↄ́lu a ekʼam ibrm eke kʼewl a. ");
INSERT INTO adj_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Eke lɛgŋ am ew es a, jam ɛsɛl lɛw yony a ow ɛŋn Jesu ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, òk bieku ab es ím baŋn baŋn lele sikpukpu ɛm ab yecʼɛtŋ ke -nʼɛŋn ob ij lele es ɛru usu ab, aŋke aŋa eke sʼanŋ a el usu saw ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Kↄ li dad wɛl ninɛ: «Ɔny obi, ↄŋn ɛl ob -lʼij!» Ɛtŋ jam ɛsɛl a ↄdu eb ninɛ: «Futufutu yen lele ↄcn yony ab cɛ sʼↄnym ab. Kↄ erur eke si kʼim sʼↄl ob ij ɛbm agŋ nↄnↄ na ee?» ");
INSERT INTO adj_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Agŋ egŋ ekʼanŋ ɛl ɛm yogŋ a ↄtu ekʼij agŋ fandi yen). Jesu dad in e jam ɛsɛl ninɛ: «Dàdr ɛl -lʼok es eku eku ɛm ekʼↄtu eke kʼij agŋ ekŋ yony lele lɛw lɛw ab.» ");
INSERT INTO adj_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jam ɛsɛl a ɛlum ɛtŋ ↄŋ ɛl -lʼok es ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jesu oc futufutu yen a lele ↄcn yony ab ab igbl any ogŋ afr, ɛtŋ ɛlu Nyam bia. Li bubr ɛm nʼↄŋ in jam ɛsɛl a, ɛtŋ -li cɛc -nʼↄŋ bieku a. ");
INSERT INTO adj_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Agŋ a fɛŋ ij ob a lok iy, ɛtŋ ɛmɛny ow wal es. Ɛtŋ jam ɛsɛl a ot ekpr a eke wal es a as luku, ɛtŋ ow iy mulu lɛw yony. ");
INSERT INTO adj_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Lɛgŋ nyam, Jesu ocr sos es im Nyam ŋↄŋn ɛm; jam ɛsɛl a yɛji im in ab. Nʼam ibrm wɛl lʼɛsɛ: «Kↄ ayaf agŋ a bi dadr ɛm e lís ee?» ");
INSERT INTO adj_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","-Lʼↄdu -lʼeb -li dad ninɛ: «Agŋ bɛb bi dad eke ŋ Jan mij ok nuŋ ɛs. Agŋ oglog bʼɛsɛ ŋ Eli. Ɛtŋ bɛb bi dad ɛsɛ ŋ godo godo e kokoba ↄb ɛsɛl ab ɛm e nyam eke in igb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Eke -li dadr ɛbɛn a, Jesu ibrm ɛl ninɛ: «Ɛtŋ kↄ ↄny obi ↄny obi a ayaf bʼocarʼm ee?» Ɛtŋ Piɛr ↄdu eb dad ninɛ: «Ŋ el Nyam e Mesi!» ");
INSERT INTO adj_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Eke Piɛr dad ɛbɛn a, Jesu ijl ɛl nɛny kpoŋ kpoŋ kpoŋ ninɛ: «Kì dadr low na kʼokr ɛgŋ kaka.» ");
INSERT INTO adj_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ɛtŋ ɛmɛny li dad ninɛ: «Ow it ekʼɛgŋ ecʼIy kʼij gbre nↄnↄ, ke agŋ ekpekp, egb waw ɛsɛl ɛgbɛl, lele ol e low yɛgm ɛsɛl ab ígŋ ɛluʼl es, ↄ́ŋ wɛl ibiʼr ke sɛgŋ nyahan lʼígb agŋ ekʼuw ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Ɛtŋ li dad agŋ a fɛŋ ninɛ: «Ekʼɛgŋ nyam am erur eke kʼusʼm jam a, ow it ke li kí tutrm in e lís owi, ke sɛgŋ fɛŋ lʼábu in obi ecʼolikŋ a, ke lʼúsʼm jam. ");
INSERT INTO adj_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Tasi ɛm a, ɛgŋ yecʼeke bʼow erur eke ki dogŋn in e sel a bʼow irmn. Gbɛkↄ ɛgŋ yecʼeke bʼow irmn in e sel a bʼow ɛŋn. ");
INSERT INTO adj_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Eke ɛgŋ nyam ↄny wus ecʼob a fɛŋ ɛtŋ lʼirmn in e sel a, ke bla ow bʼow eel il ab ee? ");
INSERT INTO adj_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ekʼɛgŋ ɛ́s bʼↄny ɛm sosiɛm lele ɛm ecʼodad ab ecʼa, ɛbɛn ɛgŋ ecʼIy yɛji ɛ́s bʼow ↄny in e lís, lɛgŋ eke li bʼow lʼow in ecʼanygbɛl ɛm a, anygbɛl ekʼel Ɛs lele afr ɛrm ɛsɛl lala ab eci. ");
INSERT INTO adj_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Low nawrɛ mʼam dad ↄny: agŋ a eke anŋ aŋa a e bɛb bʼow ɛkn Nyam ecʼes ɛw a gbuŋ ke -lʼuw.» ");
INSERT INTO adj_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Eke ow ij sɛgŋ niwn eke li dad odad na a, Jesu uyu lafɛny nyam af, in lele Piɛr, Jan lele Jak ab eke li ki ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Eke nʼam ŋↄŋn Nyam a, in ecʼany a itŋn ɛtŋ in e mob sus ɛm a yɛji ufu toŋ am jɛjn. ");
INSERT INTO adj_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Kpɛkŋ agŋ yony ok ↄkm am dad ów Jesu ab: ow el Mois lele Eli ab eke anŋ Nyam ecʼusuayl ekʼam jɛjn ab ɛm okm sos ↄkm. -Nʼam dad elel eke Jesu bʼow uw Jerusalɛm, ke ow ɛm in e juma bʼow iy nɛny a. ");
INSERT INTO adj_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Low na ekʼam ɛy a, Piɛr lele lawlɛl ab ab mɛmn ibi. Eke any bʼok ɛl es a, -lʼɛkn Jesu ekʼanŋ Nyam ecʼusuayl ab ɛm lele agŋ yony eke inym es ab. ");
INSERT INTO adj_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Eke agŋ a kʼɛlu Jesu es im a, Piɛr dadʼr ninɛ: «Ɛgŋ gbɛl, ow akpl eke si kʼanŋ aŋa! Sʼús nuŋ igŋ usu nyahan: ŋ e nyam, Mois e nyam lele Eli e nyam ab.» (Odad cɛ ekʼɛyʼr nɛnym ke li dad.) ");
INSERT INTO adj_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Eke nʼam dad odad ɛbɛn a, kpɛkŋ jru ɛy ɛtŋ ubur ɛl fɛŋ es. Eke -lʼɛkan jru na ow am ubur ɛl es a, jam ɛsɛl a erŋn am ↄny. ");
INSERT INTO adj_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ɛtŋ lebl nyam anŋ jru ab ɛm am ikŋ dad ɛsɛ: «Ɛgŋ na el ɛm ecʼIy eke mi sↄsum mʼoc. Ìrir in e low!» ");
INSERT INTO adj_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Eke lebl a ikŋ dad odad na bake ok es a, jam ɛsɛl a ɛkn Jesu sↄny coco eke inym es. Low na eke jam ɛsɛl a iri ke ɛkn a, lɛgŋ ab ɛm a -li dadm -lʼokm ɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Eke lɛgŋ ɛny a, Jesu lele in e jam ɛsɛl ab ab anŋ lafɛny ab af us es ɛtŋ agŋ nↄnↄ ow am ↄbrʼr. ");
INSERT INTO adj_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Bieku ab ɛm yogŋ, ɛgŋ nyam am ɛlu lebl ↄg dad ɛsɛ: «Low yɛgm agŋ ɛs, mʼam ŋↄŋnʼŋ, ìs any lɛr ɛm ecʼiy na, lʼel ɛm ecʼiy igŋ ekpↄbi! ");
INSERT INTO adj_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Abŋ ŋuŋ a bʼɛyʼr ɛm a ke nʼam ↄg, ow ám ↄny ufŋʼn lɛc ɛm ke sar ám iflʼl nɛny. Ow bʼijrʼr gbre toŋ bake sos kiknʼn es gbuŋ ke ow ɛ́luʼl es. ");
INSERT INTO adj_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mi dad ŋ e jam ɛsɛl a ow ekʼogŋ abŋ ikŋ na, kↄ -lʼↄtum.» ");
INSERT INTO adj_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Eke igŋ a dad ɛbɛn a, Jesu igbl lebl ogŋ dad agŋ a fɛŋ ninɛ: «Wew! Ɔny eel agŋ eŋuŋ eke ↄmn anm ɛm tasi! Ɛmɛny sɛgŋ abi mʼit eke mi kʼanŋ ↄny ab ee? Ɛtŋ ɛmɛny sakp abi ow it eke mi kʼɛgŋ low na mʼeb ee?» Ɛtŋ ca li dad iy ɛs a ninɛ: «Òc ŋ ecʼiy a ow aŋa!» ");
INSERT INTO adj_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Eke iy a am ow titmʼn a, abŋ a ↄny ɛluʼl wus ɛtŋ am ↄny ufŋʼn lɛc ɛm. Kↄ Jesu dad odad lebl tuↄtuↄ ɛm ogŋ abŋ ŋuŋ a, ewlm iy a, ɛtŋ lʼoc nʼↄŋ ow ɛs. ");
INSERT INTO adj_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Low na ekʼɛy ɛbɛn a, ow iti agŋ a fɛŋ any, Nyam ecʼabusu ligbɛl na ekʼɛy ↄkm a sosiɛm. Ekʼɛgŋ ɛgŋ low am iti any Jesu e low na eke kok a sosiɛm a, li dad in e jam ɛsɛl a ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","«Low na eke ca mʼam ow mi dad ↄny a, ùcur ↄnyn es: wɛl bʼow ↄny ɛgŋ ecʼIy ɛlu agŋ abu ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Kↄ -lʼirim odad a okm ɛl es sos ɛm, aŋke Nyam lↄl odad na e nyandrɛ ab es yecʼɛtŋ ke -li kʼuwmn any; ɛtŋ ɛmɛny -nʼam uru eke -li kʼibrm Jesu low na ecʼakr otar a. ");
INSERT INTO adj_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sica jam ɛsɛl a am atar ów es eke kʼuw ɛl ɛm ecʼɛgŋ eke kʼel ɛl ecʼanymu ab any. ");
INSERT INTO adj_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Kↄ Jesu uw ɛl e tutr ab any. Lʼɛsŋ iyli nyam ow inymʼn es saw, ");
INSERT INTO adj_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ɛtŋ li dad in e jam ɛsɛl a ninɛ: «Ɛgŋ ekʼeb iyli na ɛm sosiɛm a, ke ɛm anake lʼebʼm a; ɛtŋ ɛgŋ ekʼebʼm a, eb ɛgŋ a ekʼɛrm im a yɛji. Tasi ɛm a, ɛgŋ ekʼel ↄny ɛm e likekli a, in ana lʼagb lʼakm ↄny a.» ");
INSERT INTO adj_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Eke Jesu dad ɛbɛn a, Jan ↄdu eb dad ninɛ: «Ɛgŋ gbɛl, sʼɛkn ɛgŋ nyam eke oc ŋ e nin a am kokr juma ogŋn abŋ eŋuŋ. Sʼɛdŋn in, eke lʼelm ɛy ecʼɛgŋ a sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ɛtŋ Jesu dad ninɛ: «Ɛgŋ kʼɛ́dŋn in, aŋke ɛgŋ eke ifnm ↄny a el ↄny eci.» ");
INSERT INTO adj_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Eke sɛgŋ a eke Jesu kʼuyu afr a ow titm a, ca li bɛbm tasi eke li kʼim Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Lʼɛrm agŋ ikŋʼn anym. Eke ɛ́rmu a us ejagb a, -nʼim -lʼok Samari eyŋ e baŋn nyam eke -li ki bɛbm ow e lís e low. ");
INSERT INTO adj_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Kↄ ɛb eyŋ a erurm eke kʼebʼr aŋke -lʼerurmn eke Jwifɛl kʼɛcr ɛl ogŋ a eci im Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Eke jam ɛsɛl Jak lele Jan ab bʼɛkn ɛbɛn a, -li dad ninɛ: «Ɛgŋ gbɛl, kↄ erur eke si kʼↄŋ al anŋ afr ow ɛtul ɛl ee?» ");
INSERT INTO adj_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jesu ɛwl mɛny lɛr ɛl ɛtŋ ɛnym ɛl abr lebl tuↄtuↄ ɛm. ");
INSERT INTO adj_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ɛtŋ -nʼim baŋn ɛjeci. ");
INSERT INTO adj_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Eke -nʼanŋn ejagb -nʼaam a, ɛgŋ nyam dad Jesu ninɛ: «Mʼow mʼusʼŋ jam usu fɛŋ eke bʼow im a.» ");
INSERT INTO adj_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesu dadʼr ninɛ: «Ɛkrɛ bʼↄny ɛl ecʼↄmu wus ɛm eke bʼɛru ɛm, ↄr yɛji bʼↄny ɛl e mel; kↄ ɛgŋ ecʼIy ↄnym usu nuŋ nyam ekʼↄtu eke kʼɛru es eb sel.» ");
INSERT INTO adj_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Ɛmɛny li dad ɛgŋ ɛjeci nyam ninɛ: «Ùsʼm jam.» Kↄ ɛgŋ a dadʼr ninɛ: «Ɛgŋ gbɛl, ↄŋʼm abusu mʼím mʼoc ɛm ɛs es gbuŋ ke mʼów.» ");
INSERT INTO adj_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Kↄ Jesu dadʼr ninɛ: «Yɛ̀b agŋ ekʼuw abŋ ɛm a ót ɛl ecʼagŋ ekʼuw ab es; kↄ ŋ, ìm dad Nyam e gbreŋgbi usu a ecʼodad.» ");
INSERT INTO adj_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɛmɛny ɛgŋ ɛjeci nyam dadʼr ninɛ: «Ɛgŋ gbɛl, mʼow mʼusʼŋ jam; gbɛkↄ yɛ̀b mʼím mʼibrm ɛm e gbugŋ ecʼagŋ a abusu gbuŋ ke mʼów.» ");
INSERT INTO adj_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Kↄ in yɛji Jesu dadʼr ninɛ: «Ɛgŋ eke bʼagbr wus, ke bʼɛdŋ mɛny a, akplm Nyam e gbreŋgbi usu a eci.» ");
INSERT INTO adj_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Eke na bʼɛc a, Ɛs Kↄtↄkↄ Jesu sↄsum jam ɛsɛl ɛjeci ekŋ nyahan lele lɛw yony ab ot. Lʼɛrm wɛl yony yony wɛl ikŋ anym im ɛb ɛb ɛm lele susu susu ekʼin obi yɛji li bʼow nʼim a. ");
INSERT INTO adj_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ɛtŋ li dad wɛl ninɛ: «Egb ub a ufu es nↄnↄ, kↄ juma kok ɛsɛl ɛnym. Ow sosiɛm, ìbrmn egb ↄgm ɛs a, ke lʼɛ́rm juma kok ɛsɛl nↄnↄ im in ecʼegb ub ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Ìmn gↄŋ! Mʼam ɛrm ↄny ɛsɛ mɛcɛb ey af sibotimbo ecʼaraŋn. ");
INSERT INTO adj_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Kʼòcr os, ekpr, lele cↄkrukpↄ ab. Eke aamn a, kʼìrmnin lɛgŋ ejagb af kʼɛ̀sŋnin ɛgŋ. ");
INSERT INTO adj_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gbugŋ nyam eke bʼow im okr a, ìkŋn anym dadr ɛsrɛ: “Ke Nyam ecʼɛrm es ɛy a ánŋ gbugŋ na ecʼagŋ ab ab!” ");
INSERT INTO adj_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Eke yogŋ ɛgŋ nyam anŋ ekʼerur Nyam ecʼɛrm es ɛy a, ke ↄny ecʼɛrm es ɛy a bʼow anŋ in ab. Eke ɛgŋ nɛnɛ anm a, ɛrm es ɛy a bʼow ɛwl anŋ ↄny ab. ");
INSERT INTO adj_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ànŋn gbugŋ yogŋ ijr ob, ke ɛ́gŋn yecʼeke wɛl bʼow ↄŋ ↄny a, aŋke juma kok ɛs it eke kʼↄny in e labm sↄg. Kʼɛ̀cr gbugŋ gbugŋ. ");
INSERT INTO adj_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Eke bʼɛyr ɛb nyam ɛm ɛtŋ -lʼeb ↄny a, ìjr ob yecʼeke -li bʼow -nʼↄŋ ↄny a. ");
INSERT INTO adj_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Èwlmn ↄ́lu ekʼanŋ ɛb ab ɛm a, ke dádr ɛb eyŋ a ɛsrɛ: “Nyam e gbreŋgbi usu a ow titm ↄny.” ");
INSERT INTO adj_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Kↄ eke bʼɛyr ɛb nyam ɛm ɛtŋ -lʼɛgŋm -lʼebm ↄny a, ɛ̀cr ɛb ab ɛm, ke dádr ɛsrɛ: ");
INSERT INTO adj_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Sʼam cic ↄny ecʼɛb ab ɛm ecʼakr sɛc a sʼók ↄny es. Gbɛkↄ ùwr low na any: Nyam e gbreŋgbi usu a ow titm ↄny.” ");
INSERT INTO adj_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mʼam dad ↄny: jɛj ok e lɛgŋ a, Sodↄm e low ŋuŋ a eke Nyam ki kok a bʼow ↄdŋ tɛl akm ɛb na ecʼa.» ");
INSERT INTO adj_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","«Korasin ecʼagŋ, gbre él ↄny eci! Bɛtsayida ecʼagŋ, gbre él ↄny eci! Aŋke sakrowa a eke wɛl kok ↄny ogŋ a, blel ow el Tir lele Sidↄn ab wɛl kok ana, ke blel -lʼɛw sↄrŋ e sos, -li kpakp milakŋ, -lʼok fandi ɛrm ɛm itŋn eci ow yɛ́gm eke -lʼerur eke -li kʼitŋn ɛrm ɛm. ");
INSERT INTO adj_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Na sosiɛm jɛj ok e lɛgŋ a, Tir lele Sidↄn ab e low ŋuŋ eke Nyam ki kok a bʼow ↄdŋ akm ↄny ecʼa. ");
INSERT INTO adj_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ɛtŋ ŋ Kapɛrnayum, am tutr eke any ij ɛm bʼow agb toŋ bake ím titm afr ee? Njaŋ, bʼow is es toŋ bake ígŋ ↄŋnes baŋn.» ");
INSERT INTO adj_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Ɛtŋ ɛmɛny li dad jam ɛsɛl a ninɛ: «Ɛgŋ eke bʼiri ↄny e low a, iri ɛm e low. Ɛgŋ eke ebm ↄny a, ebm im; ɛtŋ ɛgŋ eke ebm im a, ebm ɛgŋ a ekʼɛrm im a.» ");
INSERT INTO adj_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Agŋ ekŋ nyahan lele lɛw yony ab ab eke wɛl ɛrm a ɛwl mɛny ow sos ɛm iŋn ɛm ɛtŋ am dad ɛsɛ: «Ɛgŋ gbɛl, eke sʼim a, abŋ eŋuŋ yɛji ɛlum ɛy ŋ e nin ɛm!» ");
INSERT INTO adj_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesu ↄdu eb dad ɛl ninɛ: «Mʼɛkn Satan ekʼanŋ afr ɛy wus ɛsɛ nyam eke bʼɛŋn af. ");
INSERT INTO adj_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kin, mʼↄŋ ↄny abusu eke kʼaan es morŋn lele sibↄban ab af, ke ákmn ifnu ecʼabusu fɛŋ es; ɛtŋ ob kaka kʼow kokm ↄny. ");
INSERT INTO adj_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Ɛbɛn yɛji sos ɛm kʼíŋn ↄny eke abŋ eŋuŋ ɛlum ↄny a sosiɛm. Kↄ sos ɛm íŋn ↄny eke afr wɛl nↄn ↄny ecʼen a sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Wanci ab af cɛ, Abŋ Lala ↄŋ Jesu sos ɛm am iŋn toŋ batŋ li dad ninɛ: «Ɛm Ɛs, ŋ ekʼel afr lele wus ab ecʼƐs Kↄtↄkↄ a, mʼam ɛluʼŋ bia, ów a ekʼot lↄl es, ɛsɛwru lele nuŋ ɛm ↄny ɛsɛl ab ecʼany af, ke yɛgm etuey uw any a eci. Ɛɛ! Ɛm Ɛs, erur ekʼow kʼel ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Ɛm Ɛs ocr in sosi ɛlulʼm abu ɛm. Ɛgŋ kaka uwm Iy ab any eke ow elm Ɛs sↄny coco cɛ, ɛtŋ ɛgŋ kaka uwm Ɛs any eke ow elm Iy a sↄny coco cɛ lele agŋ eke Iy a erur eke kʼɛlu ↄkm yɛgmʼn ab ab.» ");
INSERT INTO adj_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ca Jesu ɛwl sos mɛny ɛtŋ am dad in e jam ɛsɛl a sↄny cɛ ɛsɛ: «Na eke ɛkan a, ehe el ↄny ecʼŋ̂! ");
INSERT INTO adj_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Kↄ mʼam dad ↄny, godo godo e kokoba ↄb ɛsɛl nↄnↄ lele ɛ́b ebu nↄnↄ ab erur eke kʼɛkn low na ekʼam ɛkan a, kↄ -lʼɛknm, iri low na ekʼam irir a, kↄ -lʼirim.» ");
INSERT INTO adj_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Ca ol e low any uw ɛs nyam ↄdu odad eb ɛtŋ ibrm Jesu ɛbm ɛkn ɛm ninɛ: «Low yɛgm agŋ ɛs, kↄ ayaf mi ki kokr ke mʼɛ́ŋn sel ekʼↄnym uwr ee?» ");
INSERT INTO adj_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesu dadʼr ninɛ: «Kↄ bla lowi wɛl nↄn ol ab ɛm ee? Ɛtŋ eke bʼawl a, ayaf bʼirir ee?» ");
INSERT INTO adj_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Li dad ow ninɛ: «Bʼow erur Asŋ Kↄtↄkↄ ŋ e Nyam ŋ eci ɛrm fɛŋ ɛm, ŋ ecʼabŋ fɛŋ ɛm, ŋ e lɛc fɛŋ ɛm, lele ŋ e tutr pupukpaŋ ab; ke érur ɛgŋ kaka fɛŋ ɛsɛ ŋ obi af.» ");
INSERT INTO adj_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Ɛtŋ Jesu ɛgŋ ninɛ: «Ow anake dad a. Kòk ɛbɛn cɛ ke bʼow ɛŋn sel ekʼↄnym uwr.» ");
INSERT INTO adj_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Kↄ eke ol e low any uw ɛs a erur eke in e low kʼij low a, li dad Jesu ninɛ: «Kↄ bwo el ɛgŋ ɛjecʼab ee?» ");
INSERT INTO adj_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Jesu ↄdu eb dadʼr ninɛ: «Ɛgŋ nyam igb Jerusalɛm am us nuŋ es im Jeriko baŋn ɛtŋ lʼɛy elu abu ɛm. Wɛl ↄrʼr, ebʼr mob ɛtŋ wɛl digŋ ɛluʼl es im. Ɛtŋ nʼanŋ luw lele owr anŋ ab ecʼaraŋn. ");
INSERT INTO adj_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Egb waw ɛs nyam eb ejagb a aam. Eke li bʼuyum ow ab a, lʼaru lʼɛgb ow es nʼim. ");
INSERT INTO adj_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Leviɛl ɛm ecʼɛgŋ nyam ekʼeb ejagb a am ow a, ɛknʼn, ɛtŋ in yɛji lʼaru lʼɛgb ow es nʼim. ");
INSERT INTO adj_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Kↄ Samari iy nyam ekʼaam usu a, im ok yogŋ. Eke li bʼɛkn ow a, ow e low ↄnyʼn sↄrŋ. ");
INSERT INTO adj_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lʼɛri nʼim li titm ow, lʼoc mar li yↄyↄg ow abi ab es, lʼok mun ɛm ɛtŋ nʼawŋ ow abi ab es. Lʼoc ow in e gbaŋkↄ ab af, lʼoc nʼim ow etu eb usu. ");
INSERT INTO adj_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Eke lɛgŋ ɛny a, lʼoc os yony nʼↄŋ etu eb usu a ecʼes ɛw ɛs a, ɛtŋ li dad ow ninɛ: “Kòk ɛgŋ na sɛkp sɛnyn sɛnyn. Ekʼos a obn a, ɛm e mɛny ɛwl ow ɛm a, mʼow mi sↄgʼŋ fɛŋ.” » ");
INSERT INTO adj_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Ɛtŋ Jesu ibrmʼn ninɛ: «Kↄ agŋ nyahan amua ɛm a, bwo el ɛgŋ eke elu a ↄr eb mob a e lawl ee?» ");
INSERT INTO adj_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ɛtŋ ol e low any uw ɛs a ninɛ: «Ɛgŋ a ekʼikŋʼn sↄrŋ a anake el lawl a.» Ɛtŋ Jesu dadʼr ninɛ: «Ìm ke ŋ yɛji kók ɛbɛn.» ");
INSERT INTO adj_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Eke Jesu lele in e jam ɛsɛl ab ab us ejagb aam a, -nʼim -lʼok baŋn nyam. Yogŋ yↄw nyam eke wɛl bʼɛsŋ Mart eb Jesu in e gbugŋ a. ");
INSERT INTO adj_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Nʼↄny lisijↄw nyam eke wɛl bʼɛsŋ Mari, ke ow sig es Ɛs Kↄtↄkↄ e saw am iri ow ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mart eke akŋ e juma kok afŋn es a ow ɛŋn Jesu ɛtŋ dad ninɛ: «Ɛgŋ gbɛl, kↄ ow ám kokmʼŋ low kaka sos ɛm eke ɛm lisijↄw ɛluʼm es ɛm sↄny mʼam kok akŋ e juma na ab ee? Dàdʼr ke lʼów lʼɛlum im abu.» ");
INSERT INTO adj_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ɛs Kↄtↄkↄ dadʼr ninɛ: «Mart, Mart, am ebr ɛrmij lul es ów nↄnↄ eci, ");
INSERT INTO adj_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","kↄ low nyam sↄny coco cɛ akpl: Mari sↄsum yecʼa eke akpl a oc, ɛtŋ ɛgŋ kʼↄtum ebmʼn abu ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Lɛgŋ nyam Jesu im usu nyam am ŋↄŋn Nyam. Eke ni ŋↄŋn Nyam bake ow uwr a, in e jam ɛsɛl ab ɛm ecʼɛgŋ nyam ibrmʼn ninɛ: «Ɛgŋ gbɛl, yɛ̀gm ɛy elel eke si ki ŋↄŋan Nyam, ɛsɛ elel eke Jan mij ok nuŋ ɛs yɛgmn in e jam ɛsɛl ab af.» ");
INSERT INTO adj_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesu dad ɛl ninɛ: «Eke bʼow ŋↄŋan Nyam a, ke dàdr ɛsrɛ: Ɛs, ke ŋ e nin lala a ↄ́ny ɛlum, ke ŋ ecʼes ɛw a ów. ");
INSERT INTO adj_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ɔ̀ŋ ɛy lɛgŋ lɛgŋ ecʼob ij ekʼit a. ");
INSERT INTO adj_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Àp ɛy e sikpl, eke ɛy yɛji si bʼap agŋ eke bi kok ɛy low ŋuŋ a. Kì yɛb ɛy si kʼɛ̀y ɛbm owi ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ɛmɛny Jesu dad ɛl ninɛ: «Sʼóc low nyam sʼɛbmn: ↄny ɛm ecʼɛgŋ nyam im njijm ɛm ɛŋn lawl nyam ɛtŋ am ibrmʼn ɛsɛ: “Ɛm lawl, àbmnʼm futufutu nyahan. ");
INSERT INTO adj_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Ɛm lawl nyam ekʼɛc aam usu a ow ɛm ogŋ a, ɛtŋ mʼↄnym ob kaka eke mi kʼↄŋʼn lʼij.” ");
INSERT INTO adj_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɛtŋ lawl a ekʼanŋ akŋ a dadʼr ninɛ: “Kʼìjrʼm gbre! Mʼabl êl ŋ̂. Ɛm lele ɛm ecʼey ab sʼɛru es ŋ̂. Mi kʼↄtum mʼigbm mʼↄↄmʼŋ futufutu!” ");
INSERT INTO adj_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Eke ow el lawl yɛji, li kʼow lʼigbm nʼↄↄm ow futufutu a eke ow ibrm a. Kↄ eke nʼam at lʼibrm ow a, li bʼow lʼigb nʼↄŋ ow ob fɛŋ a eke ow am ibrmʼn a, ɛ́s eke kʼↄnymʼn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Eke ow el ɛbɛn a, mʼam dad ↄny: ìbrmn ob eke erurir a, Nyam bʼow ↄŋ ↄny. Ɔ̀ↄl es, ɛtŋ Nyam bʼow ↄŋ ↄny ɛŋnʼn. Ìcmn lisany abu, ɛtŋ Nyam bʼow fig ↄny. ");
INSERT INTO adj_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Kↄ ɛgŋ fɛŋ eke bʼibrm ob eke lʼerur a, Nyam bʼↄŋʼn; ɛgŋ fɛŋ eke bʼↄl ob eke lʼerur a es a, Nyam bʼↄŋ nʼɛŋn; ɛtŋ Nyam bi fig ɛgŋ fɛŋ eke bʼicmʼn lisany abu a. ");
INSERT INTO adj_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ɔny ɛm aŋa, bwo ecʼɛgŋ el iy ɛs eke jim bʼibrmʼn futufutu, ke lʼóc lebn nʼↄŋ ow ee? Oglog jim bʼibrmʼn ↄcn, ke lʼóc lorŋn nʼↄŋ ow ee? ");
INSERT INTO adj_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ɛmɛny ow bʼibrmʼn ŋgↄs mbue, ke lʼóc bↄban nʼↄŋ ow ee? ");
INSERT INTO adj_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ɔny nana ekʼeel agŋ eŋuŋ a bʼuwr ob amamn any ↄŋn ↄny ecʼey; ayaf Nyam ekʼanŋ afr a kʼow kokm ow afŋm es ee? Agŋ eke am ibrmʼn Abŋ Lala a, li bʼow nʼↄŋ wɛl.» ");
INSERT INTO adj_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Lɛgŋ nyam, Jesu am ogŋ abŋ ŋuŋ ekʼanŋ igŋ nyam ɛm, ke ow ↄŋʼn lʼel ɛbrm. Eke abŋ ŋuŋ a ɛy ↄkm a, ɛbrm a am dad odad ɛtŋ agŋ a low am iti any. ");
INSERT INTO adj_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Kↄ agŋ oglog am dad ɛsɛ: «Bɛlsebul ekʼel abŋ eŋuŋ ecʼes ɛw ɛs a anake bʼↄŋʼn abusu lʼogŋ abŋ eŋuŋ amua a!» ");
INSERT INTO adj_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Agŋ oglog erur eke kʼɛbmʼn odad ebl ɛm. -Nʼam ibrm eke ow ki kok mɛny ɛwr yɛgm eke ow ecʼabusu bʼanŋ Nyam ogŋ ow. ");
INSERT INTO adj_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Kↄ Jesu uw ɛl ecʼów tutr ab any, ɛtŋ li dad wɛl ninɛ: «Es ɛw fɛŋ eke in ecʼagŋ a ubr ɛm a bʼuŋ; ɛbɛn nɛnyɛmbri nyam akŋ ekʼubr ɛm a yɛji bʼuŋ. ");
INSERT INTO adj_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Eke Satan ubr ɛm sakp yony, ke in ecʼes ɛw a ↄtu eke kʼanŋ ee? Ɔny bi dadr eke Bɛlsebul ecʼabusu ɛm mʼam ogŋ abŋ eŋuŋ. ");
INSERT INTO adj_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Eke ow el ɛbɛn, ke ↄny agŋiyɛl ecʼa eke bʼogŋ a, kↄ bwo bʼↄŋ ɛl abusu ee? Ɛl obi -nʼam yɛgm eke ↄnymn low ij! ");
INSERT INTO adj_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Tasi ɛm a, Nyam ecʼabusu ɛm anake mʼam ogŋ abŋ eŋuŋ a; ow am yɛgm eke Nyam ecʼes ɛw a ow ↄny ecʼaraŋn ŋ̂. ");
INSERT INTO adj_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Eke lɛc ɛs nyam ok ar mob sos am ↄsu in e gbugŋ a, in ecʼob ↄny fɛŋ bʼanŋ tiŋ. ");
INSERT INTO adj_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Kↄ eke lɛc ɛs ɛjeci nyam ow ɛŋnʼn ɛtŋ akmʼn es a, ow bʼebʼr ar mob a eke nʼam ↄmn a, ke ow eci mob eke lʼeb a, li cɛ́c nʼↄŋ agŋ. ");
INSERT INTO adj_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Ɛgŋ ekʼanm ɛm ab a, el ɛm ecʼifnu; ɛtŋ ɛgŋ eke ɛ́luam im abu sʼasm Nyam ecʼey luku a, am ↄmun ɛl es.» ");
INSERT INTO adj_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Ɛmɛny Jesu dad ninɛ: «Ekʼabŋ ŋuŋ nyam anŋ ɛgŋ ɛm ɛy ↄkm a, li bʼanŋ usu wɛwɛ nʼam rereb usu a, nʼám ↄl usu eke li kʼir. Eke sica nʼɛ́ŋnm a, ke nʼám dad in ɛm lʼɛsɛ: “Mi bʼow mʼɛwl mʼim mʼɛy ɛm ecʼakŋ a eke mʼanŋ mʼɛy ↄkm a.” ");
INSERT INTO adj_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Eke li bʼɛwl mɛny lʼow a, li bʼɛkn eke wɛl apl akŋ ab es ayl, wɛl nyinyimn ow akpl. ");
INSERT INTO adj_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Sica li bʼɛwl nʼim lʼɛsŋ lawlɛl abŋ eŋuŋ lↄbŋ ekʼuŋ akmʼn, -li bʼokr af -lʼir yogŋ. Ow e jam a, abŋ amua bʼijr ɛgŋ na gbre akm krɛkrɛ ecʼa.» ");
INSERT INTO adj_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Eke Jesu dad odad na ɛbɛn ok es a, yↄw nyam anŋ bieku ab ɛm ↄdu odad eb dad ninɛ: «Ehe el yↄw na eke ewʼŋ ke ↄŋʼŋ mɛny a eci!» ");
INSERT INTO adj_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ɛtŋ Jesu dad ninɛ: «Nawrɛ, kↄ ehe tasi el agŋ a ekʼam iri Nyam ecʼodad ke am ɛlum a eci!» ");
INSERT INTO adj_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Eke agŋ a am ow Jesu ogŋ egbekl ɛm a, li dad wɛl ninɛ: «Yɛfɛnyna ecʼagŋ eŋuŋ amua am ibrm mɛny ɛwr, kↄ wɛl kʼow kokm mɛny ɛwr kaka ↄↄm ɛl, eke ow elm Jonas ecʼa cɛ. ");
INSERT INTO adj_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Tasi ɛm a, ɛsɛ elel eke Jonas el Ninif baŋn eyŋ e mɛny ɛwr ab af a, ɛbɛn cɛ ɛgŋ ecʼIy yɛji bʼow el yɛfɛnyna ecʼagŋ a e mɛny ɛwr. ");
INSERT INTO adj_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jɛj ok e lɛgŋ a, Seba ecʼes ɛw lis a bʼow igb inym es yɛfɛnyna ecʼagŋ a ecʼany af, ɛtŋ bʼow ↄb ɛl low, aŋke nʼanŋ usu kpekpe lʼow yecʼɛtŋ ke lʼíri Salomↄ e sɛwr e sodad a. Ɛtŋ kin, ɛgŋ anŋ ekʼagb akm Salomↄ! ");
INSERT INTO adj_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Jɛj ok e lɛgŋ a, Ninif baŋn eyŋ bʼow igb yɛfɛnyna ecʼagŋ a ecʼany af ɛtŋ bʼow ↄb ɛl low, aŋke eke -lʼirir Jonas eci Nyam odad a, -lʼitŋn ɛrm ɛm. Ɛtŋ kin, ɛgŋ anŋ ekʼagb akm Jonas!» ");
INSERT INTO adj_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","«Ɛgŋ ígŋm kɛniɛ itam es ob ew, kↄ wɛl bʼigŋ kɛniɛ a, ob gege af wɛl bʼitm es yecʼɛtŋ ke agŋ eke bʼok akŋ a ɛ́kn usuayl. ");
INSERT INTO adj_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ŋ ecʼanyamn a el ŋ e sos megl a e kɛniɛ: ekʼanyamn akplʼŋ a, ŋ e sos megl a fɛŋ anŋ usuayl ɛm; kↄ ekʼanyamn akplmʼŋ a, ke ŋ e sos megl a yɛji anŋ ncebn ɛm ŋ̂. ");
INSERT INTO adj_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Na sosiɛm a, ɛ̀w ɛrm ke usuayl ekʼanŋʼŋ ɛm a kʼélm ncebn. ");
INSERT INTO adj_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Eke ŋ e sos megl ikpr kaka anm ncebn ɛm, ɛtŋ fɛŋ anŋ usuayl ɛm a, sos a nimum bʼow anŋ usuayl ɛm, ɛsɛ elel eke kɛniɛ bi jɛjn in ecʼusuayl mamn okʼŋ af ab af.» ");
INSERT INTO adj_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Eke Jesu dad odad bake ow uwr a, Farisi nyam ɛsŋʼn ob ij. Jesu ɛgŋ ɛtŋ im ɛy akŋ a sig es ob ij usu a in ab. ");
INSERT INTO adj_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Gbuŋ ke -lʼij ob a, Jesu yↄgm sabu ɛsɛ elel eke ɛl ecʼol a dad ab af; low na iti Farisi a any. ");
INSERT INTO adj_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kↄ Ɛs Kↄtↄkↄ uw in ecʼów tutr ab any ɛtŋ dadʼr ninɛ: «Kin elel eke ↄny Farisiɛl anŋnin: ↄny, bʼɛtŋn mij kpↄk lele nagbeŋ ab eci jam jam ab es; kↄ ↄny e lokm a, ów eŋuŋ bʼiy ɛm: bʼerurir ob ↄny toŋ él ↄny mil, ɛtŋ bi kokr lokm suŋ owi. ");
INSERT INTO adj_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Anyamb agŋ! Kↄ ow elm Nyam a eke kok sos af a kokm lokm a yɛjʼee? ");
INSERT INTO adj_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gbuŋ ke ↄny e low a áyl akpl tasi a, ↄŋn ↄgbↄru ↄny e magbeŋ ɛm ecʼob a lele kpↄk ɛm ecʼab ab. ");
INSERT INTO adj_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Farisiɛl, gbre él ↄny eci! Aŋke bʼↄŋn Nyam ↄny ecʼob fɛŋ eke bʼewal a eci sakp lɛw ɛm toŋ alaf mob yɛji, gbɛkↄ ɛ́wmn Nyam ecʼerur a eke kʼↄnyn a lele low nɛnyɛmbri nyam e kok ab e low any. Ke tasi ɛm a, low na anake wɛl ki kok a, ke ow e likpr a yɛji wɛl kʼigŋm ɛlum es. ");
INSERT INTO adj_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Farisiɛl, gbre él ↄny eci! Aŋke bʼerurir Nyam nuŋ igŋ susu e mɛkpn anym e sisigr, ɛtŋ dedeku ɛm bʼerurir eke wɛl kʼɛsŋn ↄny ɛlum ɛm. ");
INSERT INTO adj_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Gbre él ↄny eci! Aŋke anŋn ɛsɛ uwↄmu eke wɛl ɛwrm mɛny, ke any uwm ɛm, wɛl bʼuyu af af!» ");
INSERT INTO adj_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ol e low any uw ɛsɛl ɛm ecʼɛgŋ nyam dadʼr ninɛ: «Low yɛgm agŋ ɛs, eke am dad ɛbɛn, ke ɛy anake am wɛwr ɛy a!» ");
INSERT INTO adj_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jesu ↄdu eb dadʼr ninɛ: «Ol e low any uw ɛsɛl, ↄny yɛji gbre él ↄny eci! Aŋke bʼuyulil agŋ ɛrɛkp legleg ɛtŋ érurmn eke kʼɛlumn ɛl abu -lʼuyu ɛrɛkp a. ");
INSERT INTO adj_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Gbre él ↄny eci! Aŋke bi kokr suwↄmu amamn ↄŋʼn Nyam e kokoba ↄb ɛsɛl ekʼↄny ɛsɛl ibi a! ");
INSERT INTO adj_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Na bi yɛgm eke ↄny ɛsɛl ecʼów eke kok a ↄny yɛji erurir, aŋke -lʼibi kokoba ↄb ɛsɛl, ɛtŋ ↄny yɛji bi kokr ɛl eci suwↄmu! ");
INSERT INTO adj_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Na sosiɛm Nyam, in e sɛwr ab ɛm dad ninɛ: “Mʼow mʼawŋ ɛl kokoba ↄb ɛsɛl lele ɛrm ɛsɛl ab; -li bʼow -lʼibi wɛl ɛm ecʼagŋ bɛb, ɛtŋ -li bʼow -lʼijr bɛb gbre.” ");
INSERT INTO adj_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Na sosiɛm, Nyam bʼow kok yɛfɛnyna ecʼagŋ a low ŋuŋ, kokoba ↄb ɛsɛl eke ɛl lagŋɛl ibi wus na eci kok ɛm ɛtŋ sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ow ↄb nuŋ Abɛl ecʼibi ɛm toŋ im igŋ Zakari eke wɛl ibi egb waw usu a lele usu lala ab ab ecʼaraŋn a. Ɛɛ, low nawrɛ mʼam dad ↄny: Nyam bʼow kok yɛfɛnyna ecʼagŋ a low ŋuŋ, agŋ na fɛŋ eke wɛl ibi a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Ol e low any uw ɛsɛl, gbre él ↄny eci! Aŋke ocr low any uw e safuɛ a eke bʼↄŋ ɛgŋ abusu uw low any a; ↄny obi a yɛji ókmn ɛm, ɛtŋ bʼɛdŋnin agŋ eke am erur eke kʼok ɛm a yɛji.» ");
INSERT INTO adj_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Eke Jesu ŋgboŋ yogŋ a, ol e low yɛgm ɛsɛl lele Farisiɛl ab ɛrm ebl ligbɛl ɛtŋ -nʼam bibrm ow ów nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","-Nʼam uk ow meb eke -li kʼↄny ow eke batŋ yadŋ ɛm ecʼodad ka anŋʼn nɛnym ɛy ↄkm. ");
INSERT INTO adj_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lɛgŋ ab ɛm a, agŋ fandi fandi as luku toŋ batŋ am yuyurir af. Ɛtŋ Jesu ikŋ anym am dad in e jam ɛsɛl a odad ɛsɛ: «Mʼam dad ↄny, ↄsur sos Farisiɛl e lijru a ekʼel ɛnyɛmbri yony yony owi a e lís. ");
INSERT INTO adj_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Low fɛŋ eke lↄl es a bʼow ɛy ↄkm, ɛtŋ low fɛŋ ekʼel asre ɛm ecʼa, wɛl bʼow uw any. ");
INSERT INTO adj_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Low fɛŋ eke bʼow dadr saw ɛm a, wɛl bʼow dad ok ↄkm agŋ a fɛŋ ecʼany af; ɛtŋ yecʼeke bʼow abal êl anŋn akŋ dadr ów sɛsl ɛm, okr ↄny lawlɛl ↄru ɛm a, wɛl bʼow oc uyu luw af ɛlul lebl agŋ iri.» ");
INSERT INTO adj_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","«Ɛm lawlɛl, mʼam dad ↄny, kʼùrur agŋ a eke bʼibi sos megl, ke ow e jam a kʼↄtum kokm low kaka fɛŋ ij a. ");
INSERT INTO adj_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mʼam ow mi yɛgm ↄny ɛgŋ eke kʼurur a: ùrur Nyam eke luw e jam a, ↄny abusu ekʼoc ↄwl ↄny gbre ij usu a. Ɛɛ, mʼam dad ↄny, in anake ↄtur eke kʼurur ir a! ");
INSERT INTO adj_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Kↄ wɛl ↄ́lm yay yen íjm lɛl yony ee? Ɛbɛn yɛji Nyam íjlm ɛl ɛm e nyam es. ");
INSERT INTO adj_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ɛtŋ ɛmɛny ↄny ecʼa, ↄny e sin nuŋ bↄbↄ yɛji Nyam awl uw any. Kʼùrur erŋn: ↄny, iil an akmn siyay!» ");
INSERT INTO adj_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","«Mʼam dad ↄny, ekʼɛgŋ nyam bi dad dedeku ecʼany af eke in el ɛm eci, afr, ɛgŋ ecʼIy yɛji bʼow dad Nyam ecʼɛrm ɛsɛl ecʼany af ɛsɛ: “Lʼel ɛm eci.” ");
INSERT INTO adj_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Kↄ ekʼɛgŋ nyam bi dad dedeku ecʼany af ekʼin uwm im any, ɛbɛn afr, ɛgŋ ecʼIy yɛji bʼow dad Nyam ecʼɛrm ɛsɛl ecʼany af ɛsɛ: “Mʼuwmʼn any.” ");
INSERT INTO adj_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Ɛgŋ fɛŋ eke bi dad odad ŋuŋ ok ɛgŋ ecʼIy af a, Nyam bʼow oc apʼr; kↄ ɛgŋ yecʼeke dad odad ŋuŋ ok Abŋ Lala af a, Nyam kʼow ocm apmʼn. ");
INSERT INTO adj_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Eke wɛl bʼot im ↄny jɛj ok ɛm Nyam nuŋ igŋ susu, ow kʼↄdm es ɛw ɛsɛl ecʼany af, ke ɛrmij kʼók ↄny low yecʼeke ki dadr ɛdŋnin ↄny sosi abu any a eci, ");
INSERT INTO adj_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","aŋke wanci ab af cɛ Abŋ Lala bʼow yɛgm ↄny low yecʼeke ki dadr a.» ");
INSERT INTO adj_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Bieku ab ɛm, ɛgŋ nyam dad Jesu ninɛ: «Low yɛgm agŋ ɛs, dàd ɛm lisijim cɛc in lel ɛm ab ecʼob ↄny a eke ɛy ɛs ɛw ɛy es a.» ");
INSERT INTO adj_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ɛtŋ Jesu dadʼr ninɛ: «Ɛm lawl, wɛl ɛwm im eke mi ki jɛj ↄny ecʼów mʼók, ke mi cɛ́c ↄny yony a ecʼob ↄny a mʼↄŋ ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Ɛmɛny li dad wɛl fɛŋ ninɛ: «Ɛ̀wr ɛrm, ke ↄ́sur sos ob ↄny ecʼerur fɛŋ e lís. Kↄ ɛgŋ ecʼowr anŋ tasi a anm in ecʼob ↄny ab ɛm eke lʼel gbreŋgbi yɛji.» ");
INSERT INTO adj_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Na sosiɛm li dad wɛl nyandrɛ ɛm ecʼodad na ninɛ: «Gbreŋgbi nyam ↄny wus eke egb ↄsu af nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ɛtŋ in ɛm nʼam tutr ów li dad lʼɛsɛ: “Kↄ ayaf mi ki kokr ee? Mʼↄnym usu eke mi kʼub ɛm ecʼegb na fɛŋ mʼok.” ");
INSERT INTO adj_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Tutr nyam owʼr ɛrm ɛm ɛtŋ li dad ninɛ: “Kin ow eke mi ki kok: mi bʼow mʼufŋ ɛm ecʼegbel amua fɛŋ es, ke mʼus mel ɛgbɛl ɛjeci, ke mʼás ɛm ecʼegb a fɛŋ lele ob ↄny a fɛŋ ab luku ɛm yogŋ. ");
INSERT INTO adj_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ke mi dádr ɛm sosi mʼɛsɛ: Mʼↄny nuŋ mamn gbɛ! Mʼↄny ob nↄnↄ mʼɛw es akpo nↄnↄ eci. Ow it cɛ ke mi síg es mʼam ij, ke mʼám ɛgŋ, ke mʼám kok sos ɛm iŋn!” ");
INSERT INTO adj_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Kↄ Nyam dadʼr ninɛ: “Nyamb ɛgŋ! Ncok a cɛ ŋ ecʼowr anŋ a bʼow uwr. Ɛtŋ sica ob na fɛŋ eke ot ok es a, bwo ecʼɛgŋ eci ow bʼow el ab ee?” » ");
INSERT INTO adj_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Ɛmɛny Jesu dad ninɛ: «Ɛbɛn nɛnyɛmbri nyam ow bʼow el ɛgŋ eke bʼas ob ↄny luku in obi eci, ke ↄ́lm Nyam ogŋ ecʼob ↄny es a.» ");
INSERT INTO adj_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ɛmɛny li dad in e jam ɛsɛl a ninɛ: «Na sosiɛm a, mʼam dad ↄny: kʼèbar ob eke kʼijr ɛsŋn sel oglog ob sos ɛw e low ɛrmij, ");
INSERT INTO adj_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","aŋke owr anŋ akpl akm ob ij, ɛtŋ sos megl akpl akm ob sos ɛw. ");
INSERT INTO adj_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ɛkan ebl kpↄm yɛji: -lʼewlmn egb, -lʼubmn egb. -Nʼↄnymn oj, -nʼↄnymn egbel -lʼokmn egb ɛm, gbɛkↄ Nyam bi gbagbl ɛl. Ɔny iil an nↄnↄ akmn ↄr amua! ");
INSERT INTO adj_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ɔny ɛm, bwo ecʼɛgŋ ↄtu eke in ecʼɛrmij ebr ɛm kʼobn in ecʼowr anŋ e sɛgŋ a tɛl ee? ");
INSERT INTO adj_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Eke low tɛɛli ɛm ↄtumn eke ki kokr low kaka, ke bla ɛtŋ bʼebar low ɛjeci ekʼanŋ a ecʼɛrmij ee? ");
INSERT INTO adj_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Lɛ̀ɛr ↄgm e suw ↄdↄdↄ ecʼelel eke bʼɛlil: -li kokmn juma, -lʼolmn gbad. Gbɛkↄ mʼam dad ↄny eke Salomↄ ekʼↄny ob nↄnↄ a yɛji, ↄnym ob sos ɛw ekʼakpl akm suw ↄdↄdↄ amua ɛm e nyam. ");
INSERT INTO adj_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nyam bʼɛw ↄgm e suw ekʼanŋ yɛfɛnyna, ke efi wɛl bʼow oc ↄwl alm a ob sos. Sakp abi ↄny yɛji li kʼow lʼɛwm ↄny ob sos ɛbɛn ee? Ɔmn ufum ↄny es gbɛ! ");
INSERT INTO adj_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Kì lulil es kʼↄↄl ob yecʼeke kʼijr ke ɛ́gŋn a es. ");
INSERT INTO adj_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Tasi ɛm a, wus na eci Nyam any uwm ɛsɛl anake sakp sakp fɛŋ bʼↄl ów amua es a. Ɔny ecʼa, ↄny Ɛs uw any eke ↄnyn ow ecʼes abur. ");
INSERT INTO adj_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Nyam e gbreŋgbi usu a e low ókr ↄny ɛrmij, ke ow e likpr a fɛŋ Nyam bʼow igŋ af ↄŋ ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","«Ɔny agŋ lukuli na ekʼam usrʼm jam a, kʼùrur erŋn, aŋke ↄny Ɛs erur eke kʼↄŋ ↄny in ecʼes ɛw ab ɛm ecʼↄwrↄ. ");
INSERT INTO adj_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ɔ̀ↄl ↄny ecʼob ↄny a ijr, òcr ow ecʼos ekʼɛŋan a apr ↄgbↄru. Ɔ̀ↄl ob eke ugŋm es a es. Àsr ↄny ecʼob ↄny a luku afr, yogŋ ow kʼↄtum iram, elu yɛji kʼↄtum itŋnm abu, ɛtŋ sisŋ yɛji kʼↄtum ŋuŋnm. ");
INSERT INTO adj_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Tasi ɛm a, yogŋ eke ↄny ecʼob ↄny bʼanŋ a, yogŋ cɛ ↄny ecʼɛrm a yɛji bʼanŋ.» ");
INSERT INTO adj_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","«Ɛ̀wr ob sos, gìgŋn al ám iri, ke ínymn es juma kok eci. ");
INSERT INTO adj_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ànŋn ɛsɛ juma kok ɛsɛl ekʼam eku ɛl ecʼakŋ ɛs eke bʼow anŋ mɛbi ecʼɛs gbɛgbl ɛm ow af, yecʼɛtŋ ke li bʼow eke li bʼicm lisany abu a, ke -li fig ow. ");
INSERT INTO adj_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ehe él juma kok ɛsɛl amua eke gbugŋ ɛs a bʼow ɛŋan any owr a eci! Low nawrɛ mʼam dad ↄny: li bʼow lʼɛw ob sos, nʼↄ́ŋ wɛl ok es, ke nʼↄ́ŋ wɛl ob ij. ");
INSERT INTO adj_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Eke lʼow lɛgŋ usu ɛm, oglog ow afŋ es yɛji, ɛtŋ nʼɛŋan wɛl any owr, ke ehe el ɛl eci! ");
INSERT INTO adj_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ìrir low na ow ók ↄny es sos ɛm sɛnyn sɛnyn: blel akŋ ɛs bʼuw wanci eke ulu kʼow ab any ana, ke blel li kí yɛbm ow ɛpirm ɛymʼn akŋ. ");
INSERT INTO adj_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ɔny yɛji bɛ̀bmn sos aŋke ɛgŋ ecʼIy bʼow ow wanci af eke kʼow ↄmnmn a.» ");
INSERT INTO adj_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Na sosiɛm Piɛr ibrmʼn ninɛ: «Ɛgŋ gbɛl, kↄ ɛy sↄny cɛ ecʼodad am dad nyandrɛ ɛm, kↄ agŋ a fɛŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ɛtŋ Ɛs Kↄtↄkↄ dad ninɛ: «Bwo ecʼɛgŋ el juma kok ɛs mamn, nuŋ ɛm ↄny ɛs ee? Lʼel ɛgŋ eke in ecʼes ɛw ɛs a ↄŋ abusu eke kʼɛkn juma kok ɛsɛl ɛjecʼa e lís e low, ke nʼↄ́ŋ wɛl ob ij wanci a ekʼow bʼit a. ");
INSERT INTO adj_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Ehe él juma kok ɛs ikŋ na eci, eke in eci es ɛw ɛs a eci mɛny ɛwl ow ɛm, bʼow ɛŋan am kok juma a! ");
INSERT INTO adj_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Low nawrɛ mʼam dad ↄny: es ɛw ɛs a bʼow afl in ecʼob ↄny a fɛŋ es ɛlul il abu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Gbɛkↄ eke sica juma kok ɛs ikŋ na bi dadr in sosi eke in ecʼes ɛw ɛs a in kʼow in owm caca, ɛtŋ li bʼow lʼↄb nuŋ nʼam ↄr juma kok ɛsɛl ɛjecʼa, egŋ lel ↄyↄw ab, nʼám ij ob ke nʼám ɛgŋ mar ow ám ↄnyʼn, ");
INSERT INTO adj_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","es ɛw ɛs a bʼow ɛwl ow lɛgŋ eke li kʼow nʼↄmnm, wanci af eke li kʼow lʼuwm any. Li bʼow lʼogŋ juma kok ɛs a, ke nʼↄ́ŋ ow Nyam any uwm ɛsɛl eci gbre ij a. ");
INSERT INTO adj_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Juma kok ɛs yecʼekʼuw low yecʼeke in e es ɛw ɛs a bʼerur any ke am kokm a, wɛl bʼow ↄrʼr ŋgbre ɛm sakp nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Gbɛkↄ juma kok ɛs yecʼekʼuwm low yecʼeke in e es ɛw ɛs erur ab any ke kok low ekʼit eke wɛl kʼↄrʼr a, wɛl bʼow ↄrʼr ŋgbre abi ka ɛm cɛ. Ɛgŋ a eke wɛl ↄŋ nↄnↄ a, wɛl bʼow ibrmʼn nↄnↄ; ɛgŋ yecʼeke wɛl abul nↄnↄ a, wɛl bʼow ibrmʼn ow ok af.» ");
INSERT INTO adj_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","«Mʼism Nyam e jɛj ok ecʼal ab wus na, ɛtŋ mʼam erur eke jɛj ok a kʼel caca. ");
INSERT INTO adj_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Mʼow mʼɛy gbre ij ligbɛl ɛm ekʼel mij ok nuŋ mum nyam, ɛtŋ ow am ijrʼm gbre ɛrm ɛm toŋ lɛgŋ a eke low na bʼow iy nɛny a. ");
INSERT INTO adj_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Kↄ am tutar ekʼɛrm es ɛy mʼis wus ee? Njaŋ, mʼam dad ↄny eke na ɛm bubr! ");
INSERT INTO adj_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Sica jam aŋa, bosu nyam ɛm ecʼagŋ yen ekʼanŋ a bʼow ubr ɛm: nyahan bʼow inym es, ɛtŋ yony yɛji bʼow inym es ke -nʼam ifanin. ");
INSERT INTO adj_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Iy ɛs bʼow ifn jim ɛtŋ jim yɛji bʼow ifnʼn. Iy lis bʼow ifn jↄw ɛtŋ jↄw yɛji bʼow ifnʼn. Jim ɛy bʼow ifn ɛc lis ɛtŋ ɛc lis yɛji bʼow ifnʼn.» ");
INSERT INTO adj_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Sica Jesu dad bieku a yɛji ninɛ: «Eke bʼɛkan afr ibr es ligbn es ɛru usu a, kpɛkŋ bi dadr eke Nyam bʼow an, ɛtŋ ow bʼel ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ɛtŋ eke bʼɛkan eke lɛf gbagba igb ɛb esr a, bi dadr eke elubu bʼow ow, ɛtŋ ow bʼel ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ɛnyɛmbri yony yony ɛsɛl! Eke bi lɛɛr afr lele wus ab a, bʼuwr lɛgŋ ecʼelel eke ow bʼow anŋn ab any: bla ɛtŋ úwmn lɛgŋ na ekʼanŋ ↄny any af a e nyandrɛ ab any ee?» ");
INSERT INTO adj_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","«Kↄ bla ɛtŋ ↄny obi ɛm am jɛjmn okmn kokmn yecʼeke akpl ab ee? ");
INSERT INTO adj_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Eke batŋ ɛgŋ ↄŋʼŋ dedeku ɛtŋ aamn jɛj ok usu ↄny yony mum a, ke ejagb ekʼaamn a, dàdr low a okar ɛm yecʼɛtŋ ke li kʼócm nʼiimʼŋ jɛj ok ɛs ogŋ; ke jɛj ok ɛs yɛji kʼócm ɛlumʼŋ usu ↄsu ɛsɛl abu ɛm ɛlumʼŋ sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mʼam dadʼŋ eke kʼow ɛym ↄkm yogŋ eke sↄgm ŋ e labm a fɛŋ ekʼↄny a uwarm.» ");
INSERT INTO adj_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Lɛgŋ ab ɛm, agŋ bɛb ow am dad Jesu: «Es ɛw ɛs Pilat ↄŋ wɛl ibi Galile ecʼagŋ ekʼim am kok egb waw ↄŋ Nyam a.» ");
INSERT INTO adj_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesu dad ɛl ninɛ: «Kↄ am tutar eke Galile ecʼagŋ amua eke wɛl ibi a, -lʼel sikpl ɛsɛl ɛgbɛl -lʼakm Galile ecʼagŋ a fɛŋ ee? ");
INSERT INTO adj_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Njaŋ! Mʼam dad ↄny; eke itŋnmn ɛrm ɛm, ↄny fɛŋ bʼow uwr ɛsɛ ɛl af. ");
INSERT INTO adj_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ɛtŋ kↄ agŋ lɛw niwn a eke Silowe yogŋ, êl gege a bubm ok af ibi a, kↄ ɛl -lʼel agŋ eŋuŋ -lʼakm Jerusalɛm ecʼɛb eyŋ a fɛŋ ee? ");
INSERT INTO adj_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Njaŋ! Mʼam dad ↄny: eke itŋnmn ɛrm ɛm, ↄny yɛji bʼow uwr ɛsɛ ɛl af.» ");
INSERT INTO adj_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Ɛtŋ Jesu dad ɛl odad nyandrɛ ɛm ninɛ: «Igŋ nyam ewl babm e likŋ in ecʼegb ↄgm a. Li bʼow ↄgm a eke li kʼↄw babm a, nʼɛŋnm. ");
INSERT INTO adj_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Ɛtŋ li dad juma kok ɛs a ninɛ: “Ɛ̀kn: akpo nyahan ɛtŋ eke mi bʼow e mi kʼↄw babm na, kↄ mʼɛ́ŋnm. Ùbrʼr es! Kↄ bla ɛtŋ li kʼeb wus nʼↄnym ab ↄfr ↄfr nɛnɛ!” ");
INSERT INTO adj_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Kↄ juma ɛs a ninɛ: “Ɛgŋ gbɛl, yɛ̀bʼr nʼánŋ lakpo na yɛji; mʼow mʼagbr wus mi dídʼr, mʼókʼr suw egŋun. ");
INSERT INTO adj_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ow kʼↄdm lakpo ekʼam ow a, li bʼow lʼↄsu ey. Ekʼow elm ɛbɛn a, ke ↄ́ŋ wɛl ubrʼr es.” » ");
INSERT INTO adj_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Nɛnɛgŋ nyam, Jesu am yɛgm agŋ low Jwifɛl e Nyam nuŋ igŋ usu. ");
INSERT INTO adj_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Yogŋ a ↄl lis nyam anŋ. Ow ij akpo lɛw niwn, eke abŋ ŋuŋ nyam ↄny ibnʼn es ɛtŋ lʼↄ́tum eke li kʼinym es. ");
INSERT INTO adj_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Eke Jesu bʼɛknʼn a, lʼɛsŋ ow ɛtŋ li dad ow ninɛ: «Wɛl eb ɛluʼŋ es ŋ ecʼↄl na ɛm ŋ̂!» ");
INSERT INTO adj_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Jesu atʼr abu nuŋ, ɛtŋ kpɛkŋ nʼinym es ceŋ ɛtŋ nʼam kↄklm Nyam. ");
INSERT INTO adj_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ɛbɛn a, Nyamel a ecʼes ɛw ɛs a ebl ɛrm ewlm owi na eke Jesu kok nɛnɛgŋ e lɛgŋ a sosiɛm. Li dad dedeku a ninɛ: «Sɛgŋ nↄhↄn anŋ eke wɛl ki kok juma; blel ówr lɛgŋ ab ɛm wɛl éwlm ↄny, ke ow kʼelm nɛnɛgŋ e lɛgŋ!» ");
INSERT INTO adj_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɛs Kↄtↄkↄ eb odad ɛtŋ am dadʼr ɛsɛ: «Ɛnyɛmbri yony yony ɛsɛl! Nɛnɛgŋ e lɛgŋ ↄny ɛm ecʼɛgŋ nyam nyam bi mↄmu in ecʼid ekʼanŋ ob ij usu a es ɛy ↄkm, ow kʼↄdm ni mↄmu in e gbaŋkↄ es nʼim nʼↄŋ ow mij ow ɛ́gŋ. Kↄ yadŋ ee? ");
INSERT INTO adj_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ɛtŋ yↄw na ekʼel Abraham e lilaw, ke Satan ↄny ibn es ij akpo lɛw niwn a, ke ow akplm eke wɛl ki mↄmuʼn es éb ɛluʼl es nɛnɛgŋ e lɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Jesu ecʼodad ebl na eke dad a, ↄŋ in ecʼefnu a fɛŋ ɛ́s. Kↄ dedeku a fɛŋ gbɛ sos ɛm am iŋn sijuma ɛgbɛl amamn amua eke nʼam kok a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesu dad ninɛ: «Kↄ bla lowi Nyam e gbreŋgbi usu a ot es ee? Bla lowi wɛl kʼoc ɛbmn ab ee? ");
INSERT INTO adj_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nʼanŋ ɛsɛ likŋ e liy nyam eke ɛgŋ nyam oc ewl in ecʼↄgm af. Lʼɛli lʼagb lʼel likŋ ligbɛl ɛtŋ ↄr ow us mel in ecʼál ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Ɛmɛny Jesu dad ninɛ: «Kↄ bla lowi mi kʼoc mʼɛbmn Nyam e gbreŋgbi usu ab ab ee? ");
INSERT INTO adj_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Ow anŋ ɛsɛ lijru eke yↄw nyam oc wuwlm ma toy likŋ lele yen ab toŋ bake ma a nimum inŋ eb es ab af.» ");
INSERT INTO adj_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesu am ɛc baŋn ekekey lele ɛgbɛl ɛm ab yɛgm agŋ low ejagb a ekʼaamn Jerusalɛm ogŋ ogŋ a. ");
INSERT INTO adj_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Ɛgŋ nyam ibrmʼn ninɛ: «Ɛgŋ gbɛl, kↄ agŋ tɛl cɛ bʼow ɛŋn sel ee?» Jesu dad ɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Àtar sos es okr akŋ lisany likekli ɛm ogŋ. Kↄ low nawrɛ mʼam dad ↄny: agŋ nↄnↄ bʼow ɛbm eke kʼok akŋ, kↄ -li kʼow -lʼↄtumn. ");
INSERT INTO adj_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Eke gbugŋ ɛs a bʼow igb abl lisany a safuɛ ɛm a, ↄny bʼow anŋn gbeŋ icmn lisany abu ke dádr ɛsrɛ: “Gbugŋ ɛs, fìg ɛy lisany!” Li bʼow li dad ↄny lʼɛsɛ: “Mʼuwm yogŋ ekʼanŋn am owr ab any!” ");
INSERT INTO adj_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ɛtŋ ↄny bʼow dadr ir ɛsrɛ: “Sʼij ob, sʼɛgŋ ŋ ab; yɛgm agŋ low ɛy ecʼɛb ab ɛm.” ");
INSERT INTO adj_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ɛmɛny li bʼow li dad ↄny lʼɛsɛ: “Mʼuwm yogŋ ekʼanŋn am owr any. Ŋ̀gbroŋn ɛm e lís, ↄny eke bi kokr ów eŋuŋ a!” ");
INSERT INTO adj_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lɛgŋ eke bʼow ɛkan Abraham, Isak, Jakↄb lele kokoba ↄb ɛsɛl a fɛŋ ab Nyam e gbreŋgbi usu a, ke wɛl bʼow ogŋ ok ↄny gbeŋ a, yogŋ anake ca bʼow ikŋn ↄŋn sasagar an ɛm a! ");
INSERT INTO adj_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Agŋ bʼow anŋ susu susu fɛŋ ow ok es Nyam e gbreŋgbi usu ecʼob ij usu a. ");
INSERT INTO adj_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ɛtŋ agŋ bɛb a ekʼel ajamu a, sica bʼow el ánymu. Ɛtŋ ánymu a bʼow el ajamu.» ");
INSERT INTO adj_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Lɛgŋ ab ɛm a, Farisiɛl ecʼagŋ bɛb ow titm Jesu ɛtŋ dadʼr ninɛ: «Ŋ̀gboŋ aŋa ìm usu ɛjeci, kↄ Erↄd Antipas am erur eke kʼibiʼŋ.» ");
INSERT INTO adj_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ɛtŋ Jesu dad ɛl ninɛ: «Ìmn dadr kprakpru na ɛsrɛ: “Mʼow mʼogŋ abŋ eŋuŋ, mʼewlm ↄ́lu yɛfɛnyna lele efi ab, ɛtŋ sɛgŋ nyahan mʼow mʼuwar ɛm e juma.” ");
INSERT INTO adj_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ow akpl eke mi kʼimn anym eci ɛm ecʼejagb us ab ɛm, yɛfɛnyna, efi lele lɛgŋ ekʼanŋ anym am ow ab ab. Tasi ɛm a, ow akplm eke Nyam e kokoba ↄb ɛs kʼuw usu ɛjeci, ke ow kʼelm Jerusalɛm.» ");
INSERT INTO adj_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Ɛmɛny Jesu low am ɛy sos ɛm toŋ batŋ nʼam dad lʼɛsɛ: «Jerusalɛm, Jerusalɛm, ŋ eke bʼibi kokoba ↄb ɛsɛl ke bʼↄr agŋ eke Nyam bʼɛrm ow ŋ ogŋ a mebn ɛm a! Sakp abi mʼerur eke mi kʼas ŋ ecʼey luku ɛm e lís, ɛsɛ elel eke ŋgↄs ey lis bʼas in ecʼey luku ↄw éw ab af, ɛtŋ ɛ́gŋmn! ");
INSERT INTO adj_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ow sosiɛm kin, Nyam bʼow digŋ ↄny ecʼakŋ a ɛlu es foŋ. Mʼam dad ↄny: kʼow ɛknmnʼm toŋ bake lɛgŋ a ow; yogŋ anake bʼow dadr ɛsrɛ: “Ke Nyam ɛ́dŋ ɛgŋ a ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ a!” » ");
INSERT INTO adj_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Nɛnɛgŋ nyam, Jesu im Farisiɛl ecʼes ɛw ɛs nyam ogŋ ob ij ɛm. Agŋ ekʼanŋ yogŋ a am ɛwʼr nyamn. ");
INSERT INTO adj_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ɛtŋ igŋ nyam ekʼↄl ↄny bake ir ɛw fↄŋ a ow inymʼn es any af. ");
INSERT INTO adj_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesu ↄdu odad eb ɛtŋ ibrm ol e low any uw ɛsɛl a lele Farisiɛl ab ab ninɛ: «Kↄ ɛy ecʼol a ↄŋ abusu eke nɛnɛgŋ e lɛgŋ wɛl kʼéwlm ɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Kↄ -lʼerurm eke -li ki dad odad. Ɛtŋ Jesu itŋn ↄlu a abu, ewlmʼn ɛtŋ ɛluʼl es nʼim. ");
INSERT INTO adj_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ɛtŋ li dad wɛl ninɛ: «Kↄ eke ↄny ɛm ecʼɛgŋ nyam ↄny in ecʼiy, ow kʼↄdm in ecʼid ekʼɛy mijↄmu ɛm, kↄ li kʼow nʼiim kpɛkŋ nʼↄnym lʼocm ow es eke ow el nɛnɛgŋ e lɛgŋ yɛji ee?» ");
INSERT INTO adj_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Low na ɛm a, -lʼↄtum -li dadm ow odad kaka ij. ");
INSERT INTO adj_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesu ɛbmn nyamn ɛkn eke agŋ eke wɛl bʼɛsŋ ob ij a, bʼerur eke ki sig es susu amamn. Na sosiɛm li dad agŋ a fɛŋ nyandrɛ ɛm ecʼodad na: ");
INSERT INTO adj_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Ekʼɛgŋ nyam ɛsŋʼŋ mɛbi ecʼob ij ɛm, ke kʼìm ki sig es usu mamn a. Ow kʼↄdm ke wɛl ɛ́sŋ ɛgŋ nyam ekʼↄny any akmʼŋ a yɛji ob ij ab ɛm; ");
INSERT INTO adj_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ɛgŋ a ekʼɛsŋ ↄny, ↄny yony mum a, bʼow ow dadʼŋ ɛsɛ: “Ìgb aŋa im sig es jam a!”, kpɛkŋ ɛ́s ɛm bʼow igb im sig es jam a. ");
INSERT INTO adj_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Kↄ eke wɛl ɛsŋʼŋ ob ij ɛtŋ im a, sìg es jam. Eke ow e wanci a bʼow ow a, ɛgŋ a ekʼɛsŋʼŋ ob ij a bʼow dadʼŋ ɛsɛ: “Ɛgŋ gbɛl, òw anym aŋa sig es any ɛsɛl ecʼusu na.” Ow ɛm a, ow bʼow el ŋ ecʼanygbeŋ agŋ a fɛŋ ekʼanŋ ob ij usu a ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Tasi ɛm a, ɛgŋ fɛŋ eke am igblʼl in sosi ogŋ a, Nyam bʼow ↄny isʼr es, ɛtŋ ɛgŋ ekʼam is es a Nyam bʼow ↄny igblʼl ogŋ.» ");
INSERT INTO adj_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Ɛtŋ sica Jesu dad ɛgŋ a ekʼɛsŋʼn ob ij a ninɛ: «Eke bʼow ɛsŋ agŋ ob ij ɛm a, ke kʼɛ́sŋ awlŋɛl, esŋ jimɛl, ŋ ecʼakŋ ecʼagŋ lele awlŋɛl egbreŋgbi ab; ɛl yɛji -lʼↄtu eke -li kʼɛsŋʼŋ ob ij, ke yecʼa eke kok a e labm -nʼam sↄgʼŋ a. ");
INSERT INTO adj_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kↄ ekʼam kok low ɛtŋ kʼɛsŋ agŋ ob ij a, ke ɛ̀sŋ ↄgbↄru, sos ɛ́yru, akr kpɛcɛ ɛsɛl lele ány eflu ab. ");
INSERT INTO adj_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Ehe bʼow el ŋ eci aŋke agŋ amua kʼow ↄtum ↄwrm ↄↄmʼŋ. Kↄ Nyam bʼow sↄgʼŋ ow e labm lɛgŋ eke agŋ eke kok ów amamn a bʼow igb luw ɛm anŋ owr a.» ");
INSERT INTO adj_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Agŋ ekʼanŋ ob ij usu a ecʼɛgŋ nyam ekʼiri odad na a, dad Jesu ninɛ: «Ehe él ɛgŋ eke bʼow ij ob Nyam e gbreŋgbi usu a eci!» ");
INSERT INTO adj_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ɛtŋ Jesu dadʼr nyandrɛ ɛm ecʼodad na ninɛ: «Igŋ nyam ɛsŋ agŋ nↄnↄ gbɛl ob ij. ");
INSERT INTO adj_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ekʼow sig ob ij e wanci a, lʼɛrm in e juma kok ɛs a im am ɛsŋ agŋ a eke lʼɛsŋ ob ij a eke kʼow, aŋke sica fɛŋ iy nɛny ŋ̂. ");
INSERT INTO adj_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Kↄ ɛl fɛŋ, ɛgŋ ɛgŋ am dad in ecʼes abur owi. Krɛkrɛ ɛm ɛs a dad juma kok ɛs a ninɛ: “Dàd ɛgŋ gbɛl a, mʼↄl ↄgm nyam, ow it eke mi kʼim mʼɛkn. Mʼam ŋↄŋnʼn, mʼↄny es abur; mi kʼow mʼↄtum mʼowm.” ");
INSERT INTO adj_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Yony ɛm ɛs a dad juma kok ɛs a ninɛ: “Dàd ɛgŋ gbɛl a, mʼↄl sed lɛw eke mi kʼim mʼɛbm mʼɛkn ɛl, mʼam ŋↄŋnʼn, mʼↄny es abur; mi kʼow mʼↄtum mʼowm.” ");
INSERT INTO adj_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Nyahan ɛm ɛs a yɛji dad juma kok ɛs a ninɛ: “Dàd ɛgŋ gbɛl a, catŋ mʼɛbi yↄw mʼoc mʼow mʼɛlu akŋ. Na sosiɛm mi kʼow mʼↄtum mʼowm.” ");
INSERT INTO adj_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Juma kok ɛs a ɛwl mɛny im ɛŋn in ecʼes ɛw ɛs a, ɛtŋ dadʼr agŋ a ecʼodad eke dad a. Kↄ es ɛw ɛs a ebl ɛrm ɛtŋ dad in e juma kok ɛs a ninɛ: “Ìm fafa sɛbɛrŋ ɛm, sejagb af lele susu fɛŋ ab ɛsŋ ↄgbↄru, sos ɛ́yru, ány eflu lele akr kpɛcɛ ɛsɛl ab!” ");
INSERT INTO adj_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Eke ow bʼibn tɛl a juma kok ɛs a ow ɛtŋ dad ninɛ: “Ɛm ecʼes ɛw ɛs, ow eke dad a, wɛl kok ɛtŋ ɛmɛny usu anŋ.” ");
INSERT INTO adj_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Es ɛw ɛs a dad in e juma kok ɛs a ninɛ: “Ìm sakp ɛm ejagb lele sebr af ab, ke átrm agŋ ów ok akŋ yecʼɛtŋ ke ɛm ecʼêl a íy gbↄŋ.” ");
INSERT INTO adj_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Kↄ mʼam dad ↄny, agŋ amua eke mʼɛsŋ ob ij ke ɛgŋm owm a, ɛl ɛm ecʼɛgŋ kaka kʼow ijm ɛm ecʼob na!» ");
INSERT INTO adj_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Agŋ nↄnↄ gbɛl am us Jesu jam ejagb af. Lʼɛwl mɛny lʼↄkŋ wɛl any ɛtŋ li dad wɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«Ɛgŋ ekʼerur eke kʼusʼm jam a, lʼérurʼm lʼakm ɛs, lis, in e yↄw, in ecʼey, lisijimɛl, lisijↄwɛl, lele in obi in obi ecʼowr anŋ ab. Ekʼow elm ɛbɛn a, li kʼↄtum lʼelm ɛm e jam ɛs. ");
INSERT INTO adj_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ɛtŋ ɛgŋ ekʼocm in obi ecʼolikŋ abum usm im jam a, ↄtum eke kʼel ɛm e jam us ɛs. ");
INSERT INTO adj_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ɔny ɛm a, ekʼɛgŋ erur eke kʼus êl ligbɛl nyam, li bʼow li sig es lʼub os abi eke li kʼↄny ke lʼúwar êl a. ");
INSERT INTO adj_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Eke ow elm ɛbɛn, ɛtŋ lʼɛlu lebn nↄmu ɛm, ɛtŋ ca lʼↄtum lʼusm êl a lʼuwarm a, agŋ a fɛŋ eke bʼow ɛkn êl a, bʼow kokrʼr miyɛr, ");
INSERT INTO adj_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","dad ɛsɛ: “Ɛgŋ na am us êl ɛtŋ ca ow akmʼn!” ");
INSERT INTO adj_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Ɛbɛn nɛnyɛmbri nyam, ekʼes ɛw ɛs nyam erur eke kʼogŋ ar lawl es ɛw ɛs ɛjecʼab a, li bʼow sig es li bɛbm lʼɛkn, eke lʼↄtu eke agŋ fandi lɛw ab li bʼow lʼogŋ lawl a ekʼam an es ↄbrʼr agŋ fandi likŋ ab a ar. ");
INSERT INTO adj_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Eke lʼↄtum ij a, ke lʼɛ́rm agŋ im ibrm es ɛw ɛs yecʼa ekʼanŋ akpoj am ow a ɛrm es ɛy.» ");
INSERT INTO adj_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ɛtŋ Jesu dad uwar ninɛ: «Ɔny ɛm ecʼɛgŋ kaka kʼↄtum elm ɛm e jam us ɛs, eke lʼigŋm ów fɛŋ eke nʼↄny a lʼɛlum es.» ");
INSERT INTO adj_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","«Mok el ob mamn. Kↄ eke lʼirmn in e ded a, ayaf wɛl ↄtu eke ki kokrʼr ke lʼɛwl li ded ee? ");
INSERT INTO adj_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ɛgŋ kʼↄtum ocm kokrm wus e juma kaka; kↄ lirŋ af cɛ ow it eke wɛl kʼoc ↄwlʼl. Ekʼↄnyn ↄru eke kʼirir, ke írir sɛnyn sɛnyn!» ");
INSERT INTO adj_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Wus labm eb ɛsɛl lele sikpl ɛsɛl ab ow ɛŋn Jesu eke kʼiri in ecʼodad. ");
INSERT INTO adj_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Kↄ Farisiɛl lele ol e low yɛgm ɛsɛl ab am ebl ɛrm ɛl ↄfr ɛm ɛtŋ am dad ɛsɛ: «Igŋ na bʼeb sikpl ɛsɛl ɛtŋ bʼij ob ɛl ab!» ");
INSERT INTO adj_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Na ɛm a, Jesu dad ɛl odad nyandrɛ ɛm ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«Ekʼↄny ɛm ecʼɛgŋ nyam ↄny mɛcɛb ekŋ yen ɛtŋ nyam irm a, kↄ li kʼow lʼokm ekŋ yar lele lɛw libarm ab ab es egb ij usu yogŋ, nʼiim lʼↄlm yecʼa ekʼirm a toŋ bake nʼɛ́ŋnm ow ee? ");
INSERT INTO adj_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Eke nʼɛŋn ow a, nʼanŋ sos ɛm iŋn ɛm. Lʼoc lʼɛw ow ↄbↄw af, ");
INSERT INTO adj_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ɛtŋ lʼow lʼɛy gbugŋ. Lʼɛsŋ lawlɛl lele agŋ ekʼir titmʼn ab ab, ɛtŋ li dad wɛl ninɛ: “Kòkr sos ɛm iŋn ɛm ab, kↄ ɛm e licɛbli a ekʼirm a, mʼɛŋnʼn ŋ̂!” ");
INSERT INTO adj_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Ɛbɛn nɛnyɛmbri nyam mʼam dad ↄny, eke sikpl ɛs nyam itŋn ɛrm ɛm a, afr yogŋ wɛl bʼow kok sos ɛm iŋn ligbɛl akm agŋ ekŋ yar lɛw libarm eke bʼocr ɛl sosi nɛnyɛmbri nyam ɛsɛl ke ibram ɛrm ɛm itŋn a.» ");
INSERT INTO adj_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","«Eke yↄw nyam ↄny os lɛw, ɛtŋ nyam irm a, kↄ li kʼow lʼigŋm kɛniɛ, li paplm akŋ ab es, lʼↄlm ɛrm ɛw ɛm toŋ bake nʼɛ́ŋnm lʼocm ee? ");
INSERT INTO adj_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Eke nʼɛŋn lʼoc a, li bʼow lʼɛsŋ lawlɛl lele agŋ a ekʼir in ab ab, ke li dad wɛl lʼɛsɛ: “Kòkr sos ɛm iŋn ɛm ab, aŋke ɛm ecʼos a ekʼirm a, mʼɛkn mʼoc ŋ̂!” ");
INSERT INTO adj_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Ɛbɛn nɛnyɛmbri nyam mʼam dad ↄny, eke sikpl ɛs nyam cɛ itŋn ɛrm ɛm a, Nyam ecʼafr ɛrm ɛsɛl sos ɛm bʼow iŋn!» ");
INSERT INTO adj_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Ɛmɛny Jesu dad ninɛ: «Igŋ nyam ↄny in ecʼey yony. ");
INSERT INTO adj_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Lɛgŋ nyam, jam ɛs a dad ɛs ninɛ: “Ɛm ɛs, ↄŋʼm ɛm ecʼob ↄny ekʼↄtu eke kʼɛbm im a.” Ɛtŋ ɛs cɛc ɛl in ecʼob ↄny a. ");
INSERT INTO adj_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Eke sɛgŋ bɛb bʼɛc a, jam ɛs a oc in ecʼaja ↄl ij oc ow ecʼos a fɛŋ ab im usu kpekpe, ɛb ɛjecʼɛm. Yogŋ ni ŋuŋn in ecʼob ↄny a fɛŋ nfaci ij ɛm. ");
INSERT INTO adj_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Eke ni ŋuŋn in ecʼob ↄny fɛŋ bake ow uwr a, lek ligbɛl ɛy ɛb ab ɛm, ɛtŋ sica nʼam ↄny low fɛŋ ecʼes abur. ");
INSERT INTO adj_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Nʼim ɛb ab ɛm ecʼigŋ nyam ogŋ, ɛtŋ ow ɛrmʼn ↄgm eke li kʼim lʼↄsu gbroko. ");
INSERT INTO adj_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Namn ↄnyʼn toŋ batŋ nʼam erur eke li kʼij gbroko a ecʼob eke bʼij a, kↄ yeci yɛji wɛl ↄↄmʼn. ");
INSERT INTO adj_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Eke li bʼɛkn eke low a e li kok a akplm a, ow ↄŋ ɛtŋ nʼam tutr in ecʼɛrm ɛm li dad lʼɛsɛ: “Juma kok ɛsɛl a fɛŋ ekʼanŋ ɛm ɛs ogŋ a bʼɛŋn ɛl ecʼob ij sɛnyn sɛnyn. Ɛtŋ ɛm, mʼanŋ aŋa namn am ↄnyʼm toŋ afŋn es! ");
INSERT INTO adj_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mʼow mʼigb mʼim ɛm ɛs ogŋ a, ke mi dádʼr mʼɛsɛ: Ɛm ɛs, mi kok sikpl Nyam ecʼany af lele ŋ e lís ab. ");
INSERT INTO adj_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mʼitm eke kʼɛsŋʼm ŋ ecʼiy ij, kↄ èbʼm ɛsɛ ŋ e juma kok ɛsɛl ab ɛm e nyam af.” ");
INSERT INTO adj_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Ɛtŋ kpɛkŋ lʼigb nʼaam ɛs ogŋ a. Eke nʼim toŋ bake nʼam ok yogŋ a, nʼanŋ akpoj ɛtŋ ɛs ɛknʼn. Ow e low ↄnyʼn sↄrŋ, ɛtŋ lʼuru es nʼim lʼɛy ow af. ");
INSERT INTO adj_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Iy a dadʼr ninɛ: “Ɛm ɛs, mi kok sikpl Nyam ecʼany af lele ŋ e lís ab. Mʼitm eke kʼɛsŋʼm ŋ ecʼiy ij.” ");
INSERT INTO adj_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Kpɛkŋ ɛs dad in eci juma kok ɛsɛl a ninɛ: “Òcr mob sus ɛm mamn a owr susr ir, ɛ̀lul il kpatrowa abuli, ke ókr ir cↄkrukpↄ! ");
INSERT INTO adj_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Ɔ̀nyn id igŋ mamn a owr ibir; sʼíjr ob si kokr sos ɛm iŋn! ");
INSERT INTO adj_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Kↄ ɛm ecʼiy na ekʼɛm gbɛ mʼɛsɛ lʼuw a, njɛ nʼanŋ owr. Lʼirm ɛtŋ wɛl ɛŋnʼn.” Ɛtŋ nʼam kok es gbɛgbl a sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ke lɛgŋ a, igŋ a ecʼiy kpekp a im akp ɛm. Eke nʼam ow bake nʼam titm gbugŋ a, nʼam iri ɛj ub e likekr. ");
INSERT INTO adj_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Lʼɛsŋ juma kok ɛsɛl ab ɛm e nyam ɛtŋ lʼibrm ow ninɛ: “Kↄ bla lowi am ɛy ee?” ");
INSERT INTO adj_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Juma kok ɛs a dadʼr ninɛ: “Esŋ jim ɛwl ow. Eke ɛs ɛknʼn eke nʼanŋ sɛnyn sɛnyn a, lʼibi id igŋ mamn a.” ");
INSERT INTO adj_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Eke iy kpekp a iri ɛbɛn a, lʼebl ɛrm ɛtŋ lʼerurm eke li kʼɛy gbugŋ a. Ɛs ɛy ↄkm ow am ŋↄŋnʼn eke li kʼɛy gbugŋ, ");
INSERT INTO adj_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","kↄ li dad ɛs ninɛ: “Kin akpo akpo eke mʼanŋ ŋ ab, ke lɛgŋ fɛŋ mi bi kok yecʼa eke bi dadʼm a. Ɛtŋ lɛgŋ kaka ↄↄm im cani mi kokrm sos ɛm iŋn ɛm lawlɛl ab yɛji. ");
INSERT INTO adj_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Eke sica ejimŋ ow a, in eke ni ŋuŋn ŋ ecʼob afacyↄw ab a, in sosiɛm ibi id igŋ mamn a.” ");
INSERT INTO adj_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɛs dadʼr ninɛ: “Ɛm jim, anŋ ɛm ab sɛgŋ fɛŋ, ɛtŋ fɛŋ a eke mʼↄny a, ŋ eci. ");
INSERT INTO adj_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ow akpl ke si kók sos ɛm iŋn, aŋke esŋ jim na eke sʼɛsɛ lʼuw a, njɛ nʼanŋ owr. Lʼirm, ɛtŋ sica wɛl ɛŋnʼn!” » ");
INSERT INTO adj_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesu dad in e jam ɛsɛl a ninɛ: «Gbreŋgbi nyam ↄny in ecʼob ↄsu ɛs nyam. Ɛtŋ wɛl ow dadʼr eke ob ↄsu ɛs a in am ŋuŋn ŋ ecʼob ↄny a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Gbreŋgbi a ɛsŋʼn ɛtŋ ibrmʼn ninɛ: “Kↄ bla lowi anake mʼam iri ŋ e lís ab ee? Bʼow awl ob a eke mʼabulʼŋ a ecʼelel eke kokr a okʼm. Kↄ kʼↄtum elm ɛm ecʼob ↄsu ɛs ij.” ");
INSERT INTO adj_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Eke ow ɛwar ir ɛbɛn a, ob ↄsu ɛs a am dad in ɛm ɛsɛ: “Ɛm ɛgŋ gbɛliy am ow ogŋʼm juma ɛm; ke sica ayaf mi ki kokr ab ee? Mʼijm lɛc wus ob kok owi ɛm, ɛtŋ ob sasm owi ɛm yɛji ɛ́s bʼↄnyʼm. ");
INSERT INTO adj_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Mʼuw yecʼeke mʼow mi kok ab any ba eke lʼogŋʼm juma ɛm a, ke agŋ ébʼm ɛl ogŋ a!” ");
INSERT INTO adj_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Ɛtŋ nʼam ɛsŋ agŋ a fɛŋ a ekʼij in ɛgŋ gbɛliy eci labm a nyam nyam ɛm. Li dad krɛkrɛ ɛm ɛs a ninɛ: “Kↄ os abi e labm ij ɛm ɛgŋ gbɛliy ogŋ ee?” ");
INSERT INTO adj_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ow dadʼr ninɛ: “Mun baro ekŋ yen e labm.” Ɛtŋ ob ↄsu ɛs dadʼr ninɛ: “Eke ŋ e labm a el na, ke sìg es fafa, ke nↄ́n ekŋ yony lele lɛw ab.” ");
INSERT INTO adj_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ɛmɛny li dad yony ɛm ɛs a ninɛ: “Ɛtŋ kↄ ŋ, os abi e labm ij ee?” Ɛtŋ ow dad ninɛ: “Egb ey eke wɛl ok fandi ɛm toŋ ij ekŋ yen.” Ɛtŋ ob ↄsu ɛs a dadʼr ninɛ: “Ekʼow el na, ke nↄn ekŋ yar.” ");
INSERT INTO adj_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Eke -lʼawal mob a, gbreŋgbi a am aw in e juma kok ɛs a eke kok juma kprakpr ɛm a. Tasi ɛm a, wus na ecʼagŋ bi kok ów kprakpr ɛm ↄŋanin akm usuayl ecʼagŋ a.» ");
INSERT INTO adj_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Ɛmɛny Jesu dad igŋ af ninɛ: «Kↄ mʼam dad ↄny, òcr wus na ecʼob ↄny a eke bʼɛju ɛgŋ a, ke ow ɛm ɛ́ŋan alawl. Sica lɛgŋ eke kʼow ↄnym os ij a, ke Afr éb ok ↄny ɛb ir usu a ekʼↄnym uwr ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Ɛgŋ ekʼij nɛnyɛmbri nyam ów ekekey ɛm a, bʼow ij nɛnyɛmbri nyam ów ɛgbɛl ɛm yɛji. Ɛgŋ ekʼijm nɛnyɛmbri nyam ów ekekey ɛm a, kʼow ijm nɛnyɛmbri nyam ów ɛgbɛl ɛm yɛji. ");
INSERT INTO adj_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Eke ijmn nɛny nyam wus na ecʼob ↄny e lís, ke bʼow ecʼɛgŋ anake bʼow abul ↄny ob ↄny tasi ab ee? ");
INSERT INTO adj_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ekʼijmn nɛny nyam ob ekʼel ɛgŋ ecʼa ecʼↄsu ɛm, ke bwo ecʼɛgŋ anake bʼow ↄŋ ↄny ob él ↄny ecʼab ee? ");
INSERT INTO adj_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Aduigŋ kaka kʼↄtum kokm es ɛw ɛsɛl yony e juma; oglog li bʼow lʼifn krɛkrɛ ecʼa ke lʼérur yony ɛm ecʼa; oglog li bʼow lʼij nɛny nyam, nyam e lís, ke li kʼɛwm nyam e low any. Ɔtumn eke ki kokr Nyam e juma ke kokr jɛtɛ yɛji eci juma.» ");
INSERT INTO adj_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Farisiɛl ekʼam iri Jesu e sodad amua a am kokrʼr miyɛr, aŋke -li bʼerur os owi. ");
INSERT INTO adj_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesu am dad ɛl ɛsɛ: «Agŋ ecʼany af a bʼocar ↄny sosi ɛsɛ nɛnyɛmbri nyam ɛsɛl af, kↄ Nyam uw ↄny ecʼɛrm ab any. Yecʼeke agŋ bʼoc ɛw low ligbɛl a, el low eke Nyam ifn. ");
INSERT INTO adj_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Mois ecʼol a e lɛgŋ a lele kokoba ↄb ɛsɛl a ecʼodad ab ab anŋ toŋ ok Jan mij ok nuŋ ɛs e lɛgŋ a. Lɛgŋ a ɛtŋ wɛl am ↄb Nyam e gbreŋgbi usu a ecʼAmani Mamn a, ɛtŋ ɛgŋ ɛgŋ am atr sos es eke kʼɛy ɛm. ");
INSERT INTO adj_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Afr lele wus ab bʼow ɛc gbuŋ ke ol a e mↄni nyam oc es. ");
INSERT INTO adj_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Igŋ fɛŋ eke ɛlu in e yↄw es, ke im ɛbi ɛjecʼa, ij nfaci ŋ̂; ɛtŋ igŋ eke ɛbi yↄw ekʼɛc ogŋ a yɛji ij nfaci.» ");
INSERT INTO adj_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Ɛmɛny Jesu oc nyandrɛ ɛm odad am dad ɛsɛ: «Gbreŋgbi nyam anŋ eke bi sus mob amamn eke bʼil an, ɛw dandany ebl af. Sɛgŋ fɛŋ li bi kok sos, nʼám ij, nʼám ɛgŋ, nʼám kok sos ɛm iŋn. ");
INSERT INTO adj_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Gbↄru nyam eke wɛl bʼɛsŋ Lasar ke abi ok a, bʼanŋʼn lisany. ");
INSERT INTO adj_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Li bʼerur eke li kʼij gbreŋgbi a ecʼob eke bʼij ecʼekprey a eke bʼok es wus a. Ɛtŋ ɛmɛny mↄwr bʼow ám irmʼn abi a. ");
INSERT INTO adj_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Ɛbɛn ɛbɛn toŋ batŋ gbↄru a uw, ɛtŋ afr ɛrm ɛsɛl ow oc in ecʼabŋ a im sigm es Abraham e lís. Eke ow bʼibn tɛl a, gbreŋgbi a yɛji uw, ɛtŋ wɛl ocʼr es. ");
INSERT INTO adj_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Kↄ ↄŋnes baŋn yogŋ, gbreŋgbi a am ij gbre nↄnↄ gbɛl. Eke li bʼigbl any ogŋ a, lʼɛkn Lasar akpoj ɛm eke sig es Abraham e lís. ");
INSERT INTO adj_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ɛtŋ nʼam ɛlu lebl li dad lʼɛsɛ: “Ɛm ɛs Abraham ìkŋʼm sↄrŋ, ke ɛ́rm Lasar usm abuli mij ɛm ow tatʼm anm adarʼm ɛrm, aŋke mʼam ij gbre nↄnↄ al na ɛm.” ");
INSERT INTO adj_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Kↄ Abraham dadʼr ninɛ: “Ɛm jim, ↄkn eke ŋ ecʼowr anŋ ɛm anŋ ehe ɛm ɛtŋ Lasar anŋ gbre ɛm. Ca kin eke aŋa nʼanŋ ɛrm es ɛy ɛm ke ŋ am ij gbre. ");
INSERT INTO adj_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Ɛtŋ ɛmɛny ɛy lele ↄny ab ecʼaraŋn a, nↄmu ligbɛl nyam anŋ. Ekʼɛgŋ erur eke kʼow ↄny ogŋ a, oglog ow ɛy yogŋ a yɛji, li kʼↄtum.” ");
INSERT INTO adj_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Ɛtŋ gbreŋgbi a dad ninɛ: “Eke ow el ɛbɛn, ke mʼam ŋↄŋnʼŋ: ɛ̀rm Lasar im ɛm ɛs e gbugŋ a, ");
INSERT INTO adj_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","aŋke mʼↄny ɛm lisijimɛl yen. Nʼím lʼɛwar wɛl yecʼɛtŋ ke ɛl yɛji -li kʼowmn gbre ij usu na.” ");
INSERT INTO adj_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abraham ↄdu eb dad ninɛ: “Esŋ jimɛl ecʼa, -nʼↄny Mois lele kokoba ↄb ɛsɛl ab eke am ɛwar ɛl. Ow akpl ke -lʼiri wɛl ecʼa!” ");
INSERT INTO adj_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Kↄ gbreŋgbi a dad ninɛ: “Ɛm ɛs Abraham, ow elm ow. Kↄ eke agŋ ekʼuw ab ɛm ecʼɛgŋ bʼim dad ɛl a, -li bʼow -lʼitŋn ɛrm ɛm.” ");
INSERT INTO adj_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ɛtŋ Abraham dadʼr ninɛ: “Eke -lʼerurm eke -li kʼiri Mois lele kokoba ↄb ɛsɛl ab ecʼa, ɛbɛn cɛ -li kʼow -lʼirimn ɛgŋ ekʼuw ke bʼow igb im dad ɛl a ecʼa yɛji.” » ");
INSERT INTO adj_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Sica ɛmɛny Jesu dad in e jam ɛsɛl a ninɛ: «Ów eke bʼↄŋ agŋ kok sikpl a, bʼow anŋ sɛgŋ fɛŋ. Gbɛkↄ gbre él ɛgŋ a eke sikpl bʼɛcr in ɛm ow ɛŋn ɛgŋ a eci! ");
INSERT INTO adj_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ɛgŋ eke bʼↄny ɛgŋ ekʼↄny ↄmn ɛm ɛm ɛsɛ iy af ɛlu wus a, low ŋuŋ a eke li kʼɛŋn a agb nↄnↄ. Eke wɛl oc meb ucur lob ligbɛl ucuʼr ɛmn ɛtŋ wɛl ↄny ɛman in okij a, ow akpl akm low ŋuŋ a eke wɛl ki kokʼr a. ");
INSERT INTO adj_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ɔny obi a, ɛ̀wr ɛrm sɛnyn sɛnyn! Eke esŋ jim kok low ↄbr ŋ e lís, ke ↄmʼn ów mɛwl ɛm. Eke lʼiri ɛtŋ lʼuw in ecʼów ↄbr ab any a, òc apʼr. ");
INSERT INTO adj_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Eke lɛgŋ nyam af li kok low ↄbr sakp lↄbŋ ŋ e lís ɛtŋ lʼow sakp lↄbŋ mum nʼam ŋↄŋnʼŋ a, ke òc apʼr.» ");
INSERT INTO adj_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ɛrm ɛsɛl a dad Jesu ninɛ: «Ɛgŋ gbɛl, òbn ɛy ecʼↄmn a.» ");
INSERT INTO adj_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Ɛtŋ Ɛs Kↄtↄkↄ dad ɛl ninɛ: «Blel ↄnyn ↄmn ɛw likekli ɛsɛ likŋ e liy af ana, ↄtur eke ki dadr likŋ gbɛl na ɛsrɛ: “Ìil es im inym es okij ɛm!”, li bʼow lʼɛlum ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ɛmɛny Jesu dad ninɛ: «Kin low nyam: ↄny ɛm a, ɛgŋ nyam ↄny juma kok ɛs eke bi kok ↄgm juma oglog bʼↄsu mindey. Eke li bʼanŋ juma kok ɛm ba li bʼow a, kↄ in ecʼakŋ ɛs a bʼow dadʼr eke li kʼow fafa li sig es lʼij ob ee? ");
INSERT INTO adj_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kↄ li kʼow li dadm ow kpɛkŋ lʼɛsmɛ: “Kòk ɛm ecʼob ij a! Ɛ̀w ob sos, ke ↄ́ŋʼm ob mʼij mʼɛgŋ gbuŋ ke ŋ yɛji íj ob ɛgŋ ee?” ");
INSERT INTO adj_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ɛkan eke nʼↄↄm in e juma kok ɛs a bia, ów a eke li dad ow, ke ow kok ↄŋʼn a ecʼab ee? ");
INSERT INTO adj_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ɛbɛn ↄny yɛji, eke kokr low fɛŋ eke Nyam ↄŋ ↄny eke ki kokr a yɛji, dadr ɛsrɛ: “Ɛy juma kok ɛsɛl cɛ sʼel; ow ekʼit eke si ki kok a, ow ana.” » ");
INSERT INTO adj_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Sica Jesu eb ejagb aam Jerusalɛm, ɛtŋ nʼam ɛcr Samari lele Galile ab e ligber a ogŋ ogŋ. ");
INSERT INTO adj_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Eke nʼim bake nʼam titm baŋn nyam a, kokobe ɛsɛl agŋ lɛw anŋ akpoj am ow ↄbrʼr, ");
INSERT INTO adj_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ɛtŋ -nʼam ɛlu ow lebl -li dad -lʼɛsɛ: «Ɛgŋ gbɛl Jesu, ìkŋ ɛy sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jesu ɛkn ɛl ɛtŋ dad ɛl ninɛ: «Ìmn yɛgmn egb waw ɛsɛl sos!» Ɛtŋ -lʼɛwl mɛny -nʼaam. Eke -nʼaam a, ɛl fɛŋ -lʼewl. ");
INSERT INTO adj_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Ɛl ɛm ecʼɛgŋ nyam ekʼɛkn eke lʼewl a, lʼɛwl mɛny lʼow yogŋ, ɛtŋ nʼam kↄklm Nyam lebl gege. ");
INSERT INTO adj_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Lʼok ↄwrↄkp wus, lʼubu any es Jesu ecʼany af, ɛtŋ nʼam ↄŋ ow bia. Igŋ na elm Jwif kↄ Samari ecʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jesu ibrmʼn ninɛ: «Kↄ ow elm ↄny lɛw mum ewlmn ee? Ɛtŋ kↄ bogŋ libarm ab a ee? ");
INSERT INTO adj_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Kↄ ŋ sↄny cɛ ekʼel utu ɛgŋ a anake ow am ɛlu Nyam bia ab ee? Ɛtŋ kↄ ɛl a gbɛ, ɛgŋ kaka tutrm eke kʼow ɛlu Nyam bia ee?» ");
INSERT INTO adj_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Ɛtŋ Jesu dadʼr ninɛ: «Ìgb ke ím, kↄ ŋ ecʼↄmn a eb ɛluʼŋ es.» ");
INSERT INTO adj_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Lɛgŋ nyam Farisiɛl ow am ibrm Jesu ɛsɛ: «Kↄ bogŋ lɛgŋ iy Nyam ecʼes ɛw a bʼow ow bake agŋ ɛkn ee?» Ɛtŋ li dad wɛl ninɛ: «Nyam ecʼes ɛw a kʼow owm ɛsɛ ob eke wɛl bʼɛkn af. ");
INSERT INTO adj_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Wɛl kʼow dadm ɛsmɛ: “Kin nʼanŋ aŋa, ow kʼↄdm nʼanŋ yogŋ a!” Tasi ɛm a, Nyam ecʼes ɛw a anŋ ↄny ecʼaraŋn.» ");
INSERT INTO adj_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ɛtŋ ɛmɛny nʼam dad jam ɛsɛl a lʼɛsɛ: «Sɛgŋ am ow eke bʼow erurir eke kʼɛkan ɛgŋ ecʼIy lɛgŋ nyam cɛ, gbɛkↄ kʼow ɛknmn in. ");
INSERT INTO adj_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Wɛl bʼow dad ↄny ɛsɛ: “Nʼanŋ aŋa!”, ow kʼↄdm “Nʼanŋ yogŋ a!”, kↄ kʼùrur es kʼusr jam kʼìmn! ");
INSERT INTO adj_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ɛsɛ elel eke nyam bʼɛŋn ke bʼayal afr nimum fɛŋ a, ɛbɛn nɛnyɛmbri nyam ow bʼow ɛcr ɛgŋ ecʼIy e mowrer e lɛgŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Gbɛkↄ gbuŋ ke low na ɛ́y a, ow it ke lʼíj gbre nↄnↄ, ke yɛfɛnyna ecʼagŋ ígŋ ɛluʼl es. ");
INSERT INTO adj_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Low a eke ɛy Noe e lɛgŋ a, ɛbɛn cɛ ow bʼow ɛy ɛgŋ ecʼIy e mowrer e lɛgŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Lɛgŋ a, agŋ a fɛŋ am ij ob, ɛtŋ am ɛgŋ. Egŋ lel ↄyↄw ab am ɛbirir toŋ batŋ ow it lɛgŋ a eke Noe ɛy mijɛtŋ gbɛl ab ɛm a, ɛtŋ mij gbɛl a iy ow bubur ɛl es ibi ɛl. ");
INSERT INTO adj_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ɛmɛny ow bʼow anŋ ɛsɛ Lↄt e lɛgŋ a ecʼab af: yogŋ yɛji agŋ am ij ob, am ɛgŋ, am ↄl án, am ewl egb, am us mel. ");
INSERT INTO adj_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ɛtŋ eke Lↄt anŋ Sodↄm baŋn ɛy ↄkm a, Nyam ↄŋ al lele mebn eke ler ab am an ok wus ɛsɛ mij af, toŋ ibi agŋ a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ɛbɛn cɛ ow bʼow ɛy ɛgŋ ecʼIy e mowrer e lɛgŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Lɛgŋ ab ɛm a, ɛgŋ eke bʼow anŋ in ecʼêl af e lɛf eb usu a, ke bʼow ↄny in e mob anŋ akŋ a, kʼúsm es ɛym akŋ ocm ob. Ɛbɛn ɛgŋ eke bʼow anŋ ↄgm a yɛji, kʼɛ́wlm ij. ");
INSERT INTO adj_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ɔ̀kan Lↄt e yↄw a eke lɛr jam a e low a yɛji. ");
INSERT INTO adj_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɛgŋ eke bʼerur eke ki dogŋn in e sel a, bʼow irmn; kↄ ɛgŋ a eke bʼow irmn in e sel a, bʼow anŋ owr. ");
INSERT INTO adj_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mʼam dad ↄny, lɛgŋ a eci ncok a, agŋ yony eke bʼow ɛru es ob ɛrur ob nyam af a, wɛl bʼow oc nyam, ke wɛl ígŋ nyam ɛlu es. ");
INSERT INTO adj_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ekʼↄyↄw yony am bɛbm sos ob iny eci, wɛl bʼow oc nyam, ke wɛl ígŋ nyam ɛlu es. ");
INSERT INTO adj_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Eke agŋ yony anŋ ↄgm, wɛl bʼow oc nyam, ke wɛl ígŋ nyam ɛlu es.» ");
INSERT INTO adj_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sica in e jam ɛsɛl a ibrmʼn ninɛ: «Ɛgŋ gbɛl, kↄ low na bogŋ ow bʼow ɛy ee?» Ɛtŋ Jesu dad ɛl ninɛ: «Yogŋ eke sos megl ugŋn bʼow anŋ a, yogŋ anake sikaka bʼow as luku a.» ");
INSERT INTO adj_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ɛmɛny Jesu dad in e jam ɛsɛl a nyandrɛ ɛm odad yɛgm ɛl ekʼow akpl ke sɛgŋ fɛŋ -ni ŋↄŋn Nyam, sos kʼↄ́wm ɛl es. ");
INSERT INTO adj_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Li dad wɛl ninɛ: «Ɛb nyam ɛm a, jɛj ok ɛs nyam anŋ eke ɛ́luam Nyam ke ám tutrm ɛgŋ yɛji. ");
INSERT INTO adj_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Ɛb nyam ab ɛm cɛ, iŋnyↄw nyam yɛji anŋ eke sakp nↄnↄ bʼow ɛŋnʼn ke ám ibrmʼn eke ow ki jɛj in lele in ecʼifnu ab e low ok nɛnyɛmbri nyam ɛm ↄ́ŋʼn. ");
INSERT INTO adj_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Lɛgŋ kpekpe ɛm ɛtŋ, jɛj ok ɛs a ɛ́gŋm jɛjm in e low a okm, ɛtŋ nʼam dad in ɛm lʼɛsɛ: “Nawrɛ tasi mʼɛluam Nyam, ɛtŋ mʼam tutrm ɛgŋ yɛji, ");
INSERT INTO adj_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","gbɛkↄ iŋnyↄw na am ijrʼm gbre nↄnↄ. Mi bʼow mi jɛj in e low a mʼok, yecʼɛtŋ ke li kʼówm lʼijrm im gbre ij.” » ");
INSERT INTO adj_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ɛtŋ ɛmɛny Ɛs Kↄtↄkↄ igŋ af dad ninɛ: «Kↄ irir jɛj ok ɛs ŋuŋ na ecʼodad eke dad ab ee? ");
INSERT INTO adj_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ɛtŋ Nyam ekʼↄny in ecʼagŋ eke bʼɛluʼl lebl ncok lele lɛgŋ owr ab a, li bʼow lʼɛw wɛl eci jɛj ok owi a es ow ibn ee? ");
INSERT INTO adj_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Low nawrɛ mʼam dad ↄny: li bʼow lʼogŋ es li jɛj wɛl e low lʼok. Kↄ lɛgŋ eke ɛgŋ ecʼIy bʼow ow a, li bʼow nʼɛŋn ↄmn ɛsɛl wus na af ee?» ");
INSERT INTO adj_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Ɛmɛny Jesu dad nyandrɛ ɛm odad ok agŋ a eke bʼubr ɛl sosi nɛnyɛmbri nyam ɛsɛl ke bʼifn agŋ ɛjecʼa ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«Agŋ yony im ok Nyamel gbɛl a e gbugŋ a Nyam ŋↄŋn eci; nyam el Farisi ɛtŋ nyam el wus labm eb ɛs. ");
INSERT INTO adj_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Farisi a igb inym es am ŋↄŋn Nyam ɛrm ɛm dad ɛsɛ: “O Nyam, mʼam ɛluʼŋ bia eke mʼanm ɛsɛ agŋ amua na ekʼel elu, ów eŋuŋ kok ɛsɛl, afacu, oglog ɛsɛ wus labm eb ɛs na af a. ");
INSERT INTO adj_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nɛnɛgŋ gber nyam af, mi bʼɛnŋ nɛny sakp yony. Ɛtŋ mi bʼoc ɛm ecʼob fɛŋ eke mi kok a eci lɛw ɛm mʼapʼŋ.” ");
INSERT INTO adj_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Kↄ wus labm eb ɛs a gbɛ kpab es agŋ a e lís inym es saw ɛm, ↄ́tum eke kʼigbl any ogŋ lɛr afr yɛji, ɛtŋ am ok sabu ɛrmni dad ɛsɛ: “O Nyam, ìkŋʼm sↄrŋ aŋke mʼel sikpl ɛs.” ");
INSERT INTO adj_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Low nawrɛ mʼam dad ↄny: wus labm eb ɛs a, eke lʼɛwl mɛny nʼaam akŋ a, Nyam oc in e sikpl a apʼr; kↄ ow elm Farisi a gbɛ. Tasi ɛm a, ɛgŋ fɛŋ eke bʼigblʼl in sosi ogŋ a, Nyam bʼow ↄny isʼr es; ɛtŋ ɛgŋ eke bʼisr in sosi es a, Nyam bʼow ↄny igblʼl ogŋ.» ");
INSERT INTO adj_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Ca agŋ ot ey mɛny nɛnym yɛji ow eke Jesu kʼat ɛl abu nuŋ. Eke jam ɛsɛl a bʼɛkn ɛbɛn a, -nʼam ɛnym agŋ a abr. ");
INSERT INTO adj_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Kↄ Jesu ↄŋ wɛl ot etuey a owʼr lís ɛtŋ li dad ninɛ: «Yɛ̀br etuey ow ɛm ogŋ! Ɛgŋ kʼɛ́dŋn ɛl, aŋke tasi ɛm a, Nyam e gbreŋgbi usu a, agŋ a ekʼanŋ ɛsɛ ɛl af a eci. ");
INSERT INTO adj_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Low nawrɛ mʼam dad ↄny: ɛgŋ kaka fɛŋ ekʼɛgŋm Nyam e gbreŋgbi usu a ebm ɛsɛ iyli af a, ɛgŋ ikŋ na, lɛgŋ kaka li kʼow lʼↄtum lʼɛym ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jwifɛl ecʼany ɛs nyam ibrm Jesu ninɛ: «Low yɛgm agŋ ɛs mamn, kↄ ayaf mi ki kokr ke mʼíj sel ekʼↄnym uwr ecʼaja ee?» ");
INSERT INTO adj_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesu dadʼr ninɛ: «Kↄ bla ɛtŋ am ɛsŋʼm ɛgŋ mamn ee? Ɛgŋ kaka elm ɛgŋ mamn, ekʼow elm Nyam sↄny coco cɛ. ");
INSERT INTO adj_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kↄ uw sol ab any ee? Kʼíjm nfaci, kʼíbim ɛgŋ, kʼíym mil, kʼíjm daŋku yadŋ ɛm ɛgŋ e nuŋ af, ɛ́lum asŋ lele esŋ ab.» ");
INSERT INTO adj_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Any ɛs a dad ninɛ: «Likekli ɛm ɛtŋ mi bʼɛlum sol amua fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Eke Jesu bʼiri odad na a, li dad ow ninɛ: «Eke kok ɛbɛn ke ow akpl, gbɛkↄ ow anŋʼŋ low nyam: ↄl ŋ ecʼob fɛŋ ekʼↄny a ij, òc ow ecʼos a cɛc ↄgbↄru, ke bʼow ɛŋn ob ↄny afr, ca ɛ́wl mɛny ow usʼm jam.» ");
INSERT INTO adj_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Eke any ɛs a iri odad na a, sos ↄwʼr es aŋke nʼↄny ob nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesu is any lɛrʼr ɛtŋ ɛkn eke sos ↄwʼr es; li dad ninɛ: «Nyam e gbreŋgbi usu a ecʼɛm ɛy a ɛw tuↄtuↄ agŋ a ekʼↄny ob nↄnↄ a eci gbɛ! ");
INSERT INTO adj_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gbaŋkↄ kedebnam eci fɛfn ↄmu ɛm eke kʼɛcr a ɛw fuɛfuɛ akm gbreŋgbi eci Nyam e gbreŋgbi usu a ecʼɛm ɛy a.» ");
INSERT INTO adj_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Agŋ a eke iri odad na a am dad ɛsɛ: «Kↄ sica bwo ecʼɛgŋ ↄtu ekʼɛŋn sel ee?» ");
INSERT INTO adj_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesu ↄdu eb dad ninɛ: «Yecʼeke ɛw tuↄtuↄ agŋ ecʼa, Nyam ogŋ a ow ɛw fuɛfuɛ.» ");
INSERT INTO adj_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Piɛr dad ninɛ: «Ŋ obi yɛji ɛkn, sʼigŋ ɛy ecʼob ↄny fɛŋ sʼɛlu es sʼam usʼŋ jam!» ");
INSERT INTO adj_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: ekʼɛgŋ igŋ in ecʼakŋ, in e yↄw, lisijimɛl, in ecʼagŋ oglog in ecʼey ab ɛlu es Nyam e gbreŋgbi usu a sosiɛm, ");
INSERT INTO adj_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","li bʼow nʼɛŋn amua na fɛŋ bubu af lɛgŋ na ɛm, ɛtŋ lɛgŋ ekʼanŋ anym am ow ab ɛm a, li bʼow nʼɛŋn sel ekʼↄnym uwr.» ");
INSERT INTO adj_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesu ɛsŋ in e jam ɛsɛl lɛw yony a ow ɛŋnʼn saw ɛm ɛtŋ am dad ɛl ɛsɛ: «Ìsr any ɛkan, kin Jerusalɛm anake sʼam uyu sʼim a. Yogŋ anake low a fɛŋ eke kokoba ↄb ɛsɛl nↄn ɛgŋ ecʼIy e lís a bʼow iy nɛny a. ");
INSERT INTO adj_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Wɛl bʼow oc ɛluʼl Nyam e low any uwm ɛsɛl ecʼabu ɛm. -Li bʼow -li kokr ow miyɛr, -li wɛwr ow, -lʼafl ow sar any. ");
INSERT INTO adj_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","-Li bʼow -lʼↄr ow ŋgbre ɛm, ke ca -lʼibi ow. Ɛtŋ sɛgŋ nyahan li bʼow lʼigb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Kↄ jam ɛsɛl a irim odad eke nʼam dad wɛl a okm ɛl es sos ɛm; odad a eci liy a kʼɛym ↄkm, ɛtŋ -lʼuwm low yecʼa eke Jesu am dad a e nyandrɛ ab any. ");
INSERT INTO adj_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Eke -nʼimn toŋ bake -nʼam titm Jeriko a, any eflu nyam sig es ejagb saw am sasm ob. ");
INSERT INTO adj_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Nʼam iri dedeku a ekʼam ow a e lebl, ɛtŋ nʼam ibrm lʼɛsɛ: «Kↄ bla lowi ee?» ");
INSERT INTO adj_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wɛl dadʼr ekʼow el Nasarɛt e Jesu anake am ɛc a. ");
INSERT INTO adj_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ɛtŋ kpɛkŋ nʼam ↄg li dad lʼɛsɛ: «Jesu, David eci lilaw, ìkŋʼm sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Agŋ ekʼanŋ anym am an es im a, am ɛnymʼn abr eke li ki yewal, gbɛkↄ nʼam at lebl es lʼↄg li dad lʼɛsɛ: «David e lilaw, ìkŋʼm sↄrŋ!» ");
INSERT INTO adj_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Eke nʼam ↄg ɛbɛn a, Jesu inym es ɛtŋ ↄŋ ɛgŋ ɛsŋʼn. Eke any eflu a ow titmʼn a, Jesu ibrmʼn ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","«Kↄ bla lowi am erur eke mi ki kok mʼↄŋʼŋ ee?» Any eflu a dadʼr ninɛ: «Ɛgŋ gbɛl, mʼam erur eke mi kʼɛkn es.» ");
INSERT INTO adj_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesu dadʼr ninɛ: «Ŋ ecʼↄmn a ewlmʼŋ; ɛ̀kn es gↄŋ!» ");
INSERT INTO adj_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kpɛkŋ any eflu a am ɛkn es, ɛtŋ nʼam us Jesu jam li kↄklm Nyam. Ɛtŋ agŋ a fɛŋ eke ɛkn low na a yɛji am kↄklm Nyam. ");
INSERT INTO adj_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Eke Jesu ɛy Jeriko baŋn am ubr im a, ");
INSERT INTO adj_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","gbreŋgbi nyam eke wɛl bʼɛsŋ Zashe, ke el wus labm eb ɛsɛl ecʼɛgŋ ligbɛl a anŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Nʼam ↄl eke li kʼɛkn ɛgŋ a eke el Jesu a, kↄ bieku a sosiɛm, lʼↄ́tum eke li kʼɛkn ow aŋke lʼel ɛgŋ kpɛtɛŋni. ");
INSERT INTO adj_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Ɛtŋ lʼuru es nʼim lʼuyu sikomor ikŋ nyam lʼɛy ɛm eke li kʼɛkn Jesu, eke ow bʼow ɛcr yogŋ ecʼa sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Eke Jesu ow ba bʼigŋ yogŋ a, lʼigbl any ogŋ ɛtŋ li dad ow ninɛ: «Zashe, ògŋ es fafa us es; ow it eke yɛfɛnyna mi kʼɛy ŋ e gbugŋ a.» ");
INSERT INTO adj_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Ɛtŋ kpɛkŋ Zashe ogŋ es us es, oc Jesu ab im gbugŋ ɛtŋ ebʼr sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Agŋ a fɛŋ ekʼɛkn low na a am sɛsl ów dad ɛsɛ: «Ɛgŋ na gbɛ, sikpl ɛs ogŋ anake nʼim nʼam ij etu a!» ");
INSERT INTO adj_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Kↄ Zashe igb inym es Ɛs Kↄtↄkↄ ecʼany af ɛtŋ dad ninɛ: «Ɛgŋ gbɛl, mʼow mʼoc ɛm ecʼob e mʼↄny a e likpr mʼap ↄgbↄru. Ɛtŋ eke mʼeb ɛgŋ nyam ecʼob dufre ɛm, mil ɛm, ke mʼↄ́wr sakp yar mʼↄŋʼn.» ");
INSERT INTO adj_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ɛtŋ Jesu dadʼr ninɛ: «Yɛfɛnyna sel ɛŋn ɛy akŋ aŋa, aŋke ɛgŋ na yɛji el Abraham e lilaw. ");
INSERT INTO adj_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Tasi ɛm a, ɛgŋ ecʼIy ow am ↄl eke kʼeb agŋ ekʼirm a ɛlu es.» ");
INSERT INTO adj_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Eke -nʼam iri sodad amua a, ɛmɛny Jesu dad nyandrɛ ɛm ecʼodad nyam aŋke nʼam titm Jerusalɛm, ɛtŋ agŋ a am tutr eke Nyam ecʼes ɛw a am ow ɛy ↄkm kpɛkŋ. ");
INSERT INTO adj_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Ɛtŋ kin odad eke lʼoc nʼam dad: «Akŋ nyam ecʼany ɛs nyam aam usu kpekpe ɛb nyam ɛm eke kʼeb es ɛw ecʼabusu, ke ɛ́wl mɛny ow. ");
INSERT INTO adj_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Gbuŋ eke li kʼim a, lʼɛsŋ in eci juma kok ɛsɛl ab ɛm e lɛw, ɛtŋ nʼↄŋ ɛgŋ ɛgŋ os ekŋ yen, ɛtŋ li dad wɛl ninɛ: “Òcr kokar juma ɛŋan mij toŋ ke mʼɛ́wl mɛny mʼow.” ");
INSERT INTO adj_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Kↄ in ecʼɛb eyŋ a ifnʼn, ɛtŋ -lʼɛrm agŋ usʼr jam im dad eke ɛl erurm eke ɛgŋ ikŋ na in kʼɛw ɛl es. ");
INSERT INTO adj_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Eke nʼim lʼeb es ɛw ecʼabusu a bake lʼɛwl lʼow a, lʼɛsŋ in eci juma kok ɛsɛl a eke li cɛc os nʼↄŋ a eke li kʼuw ɛgŋ ɛgŋ e juma e kok a e mij ekʼɛŋn ab any. ");
INSERT INTO adj_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Krɛkrɛ ɛs a ow ɛtŋ dadʼr ninɛ: “Ɛgŋ gbɛl, ŋ e os ekŋ yen ab ɛm, mʼɛŋn os fandi.” ");
INSERT INTO adj_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Es ɛw ɛs a dadʼr ninɛ: “Juma kok ɛs mamn, ow akpl gbɛ! Eke ij nɛny nyam low likekli na ɛm a, ow sosiɛm mʼam ↄŋʼŋ abusu ekʼɛw ɛb lɛw es.” ");
INSERT INTO adj_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Yony ɛm ecʼa yɛji ow ɛtŋ dadʼr ninɛ: “Ɛgŋ gbɛl, ŋ e os ekŋ yen ab ɛm, mʼɛŋn os ekŋ yen yen sakp yen.” ");
INSERT INTO adj_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Li dad ow ninɛ: “Mʼam ↄŋʼŋ abusu ekʼɛw ɛb yen es.” ");
INSERT INTO adj_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Nyahan ɛm e juma kok ɛs a ow ɛtŋ dad ninɛ: “Ɛgŋ gbɛl, kin ŋ e os a eke mʼucu es ↄhↄny ɛm mʼɛwʼŋ es. ");
INSERT INTO adj_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mʼuruʼŋ aŋke mʼuw any eke ŋ el ɛgŋ tuↄtuↄ. Ɛtŋ bʼoc ob yecʼeke ŋ ɛwm es a, bʼub egb yecʼeke ewlm a.” ");
INSERT INTO adj_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Eke li dad ɛbɛn a, es ɛw ɛs a dadʼr ninɛ: “Ŋ el juma kok ɛs ŋuŋ; mʼow mʼoc ŋ ecʼodad ebl a mʼↄbrʼŋ low. Uw any eke mʼel ɛgŋ tuↄtuↄ, ke mi bʼoc ob yecʼeke mʼɛwm es, ke mi bʼub egb yecʼeke mʼewlm a; ");
INSERT INTO adj_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ɛtŋ kↄ bla ɛtŋ ocm ɛm e os a iim ɛwm es os es ɛw usu, ow kokm juma bake, ɛsɛ elel eke mʼow ab af a, ke mʼóc os a lele ow e mij ab ab ee?” ");
INSERT INTO adj_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Kpɛkŋ es ɛw ɛs a ɛwl mɛny ɛtŋ dad agŋ a ekʼanŋ yogŋ a ninɛ: “Èbr ir os a abu ɛm ↄŋn ɛgŋ a ekʼↄny fandi a.” ");
INSERT INTO adj_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Kↄ -li dad ow ninɛ: “Ɛgŋ gbɛl, in nʼↄny os fandi ɛtŋ, ke ɛmɛny wɛl ↄŋʼn ee?” ");
INSERT INTO adj_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Lʼↄdu lʼeb li dad ninɛ: “Low nawrɛ mʼam dad ↄny: ɛgŋ fɛŋ eke ↄnym ob ab a, wɛl bʼow obnʼn; kↄ ɛgŋ eke ↄnym ob kaka a, tɛl a eke nʼↄny a yɛji, wɛl bʼow ↄdu ebʼr abu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Kↄ sica ɛm ecʼefnu a ekʼerurm eke mi kʼel ɛl ecʼes ɛw ɛs a, ↄnyn owr ɛl aŋa, ke íbir ɛl ɛm ecʼany af!” » ");
INSERT INTO adj_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Eke li dad ɛbɛn a, Jesu ikŋ bieku a anym am uyu im Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Eke nʼim bake nʼam titm Bɛtfaje lele Betani ab ekʼel Olivie lafɛny a ecʼogog a, Jesu ɛrm in e jam ɛsɛl ab ɛm ecʼagŋ yony, ");
INSERT INTO adj_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","ɛtŋ li dad wɛl ninɛ: «Ìmn baŋn a ekʼanŋ anym a. Eke bʼow okr ɛm a, bʼow ɛkan gbaŋkↄ kpɛtɛŋni nyam eke wɛl ucur es, ke ɛgŋ kaka kʼuyum af. Ɔ̀nyn mↄmun in es ocr owr ir. ");
INSERT INTO adj_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ekʼɛgŋ bʼibrm ↄny low a sosiɛm eke am mↄmun gbaŋkↄli ab es a, dàdr ir ɛsrɛ: “Ɛgŋ gbɛl a ↄny ow ecʼes abur.” » ");
INSERT INTO adj_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Agŋ a eke lʼɛrm a im ɛtŋ -lʼɛkn low a ɛsɛ elel eke Jesu dad ɛl ab af. ");
INSERT INTO adj_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Eke -nʼam mↄmu gbaŋkↄli a es a, ow ecʼɛsɛl a am ibrm ɛl ɛsɛ: «Kↄ bla ɛtŋ am mↄmun gbaŋkↄli ab es ee?» ");
INSERT INTO adj_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ɛtŋ ɛrm ɛsɛl yony a dad ɛl ninɛ: «Ɛgŋ gbɛl a ↄny ow esʼabur.» ");
INSERT INTO adj_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ɛtŋ kpɛkŋ -lʼoc gbaŋkↄ kpɛtɛŋni a -lʼis Jesu. -Lʼoc ɛl eci sigbad -li faf ow af, ɛtŋ -nʼↄŋ Jesu uyu af. ");
INSERT INTO adj_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Eke -nʼam an es -nʼimn anym ecʼa, agŋ am ot ɛl e sigbad faf ejagb. ");
INSERT INTO adj_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Eke nʼam titm Jerusalɛm, ejagb a ekʼam us nuŋ es imn Olivie lafɛny af ecʼa, agŋ a fɛŋ ekʼam usʼr jam a sos ɛm iŋn ɛm am kↄklm Nyam lebl gege, sakrowa a fɛŋ eke -lʼɛkan a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","-Nʼam dad -lʼɛsɛ: «Ke Nyam ɛ́dŋ Ɛb Ebu ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ! Sʼam kↄklm Nyam, ɛrm es ɛy lele anygbɛl ab ekʼanŋ afr a sosiɛm eci!» ");
INSERT INTO adj_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farisiɛl bɛb ekʼanŋ agŋ ab ɛm a, dad Jesu ninɛ: «Low yɛgm agŋ ɛs, ɛ̀dŋn ŋ e jam ɛsɛl a yéwal.» ");
INSERT INTO adj_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Kↄ Jesu dad ɛl ninɛ: «Eke -li yewal yɛji, mebn amua bʼow ↄg kↄklm im!» ");
INSERT INTO adj_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","42","Eke Jesu im titm Jerusalɛm ke bʼɛkn ɛb a, nʼam ikŋ ow ecʼↄŋn li dad lʼɛsɛ: «O Jerusalɛm, blel ŋ yɛji uw lɛgŋ na ɛm ecʼelel eke kʼɛŋn ɛrm es ɛy any ana! Kↄ sica ow lↄlʼŋ es any af. ");
INSERT INTO adj_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kↄ lɛgŋ am ow eke ŋ ecʼefnu bʼow awŋ lakp iwr did ɛlulʼŋ ɛm, ebʼŋ susu fɛŋ, aburʼŋ es atrʼŋ sel. ");
INSERT INTO adj_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","-Li bʼow -ni ŋuŋnʼŋ nimum, ŋ lele ŋ ecʼɛb eyŋ ab ab. Ɛtŋ lebn kaka kʼow anm lawl lebn af ij, aŋke ŋ uwm lɛgŋ eke Nyam ow eke kʼɛlumʼŋ abu ab any!» ");
INSERT INTO adj_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Sica Jesu im lʼɛy Nyamel gbɛl a e gbugŋ a, lʼogŋ án ↄlu a lʼok ↄkm, ");
INSERT INTO adj_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ɛtŋ li dad wɛl ninɛ: «Nyam Lɛl ɛm a, Nyam dad ninɛ: Ɛm ecʼêl a bʼow el Nyam ŋↄŋn ecʼêl. Ɛtŋ ↄny, am ocr kokr elu eci ɛŋanin usu!» ");
INSERT INTO adj_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Sɛgŋ fɛŋ Jesu bʼim yɛgm agŋ low Nyamel gbɛl ab ɛm. Ɛtŋ egb waw ɛsɛl ɛgbɛl a, ol e low yɛgm ɛsɛl a, lele Jwifɛl ɛm ecʼany ɛsɛl ab ab, am ↄl eke kʼibiʼr. ");
INSERT INTO adj_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Kↄ -lʼuwmn elel eke -li kʼɛŋan ow any, aŋke agŋ a fɛŋ bʼiri in e low sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Lɛgŋ nyam, Jesu am yɛgm agŋ low Nyamel gbɛl a e gbugŋ a, ɛtŋ nʼam dad Amani Mamn ecʼodad. Egb waw ɛsɛl ɛgbɛl a, ol e low yɛgm ɛsɛl a lele agŋ ekpekp ab ab ow ");
INSERT INTO adj_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ɛtŋ am ibrm ɛsɛ: «Dàd ɛy ↄ! Kↄ bogŋ ecʼabusu ɛm am kok ów amua ee? Kↄ bwo ↄŋʼŋ na eci kok ecʼabusu ee?» ");
INSERT INTO adj_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Ɛtŋ Jesu dad ɛl ninɛ: «Ɛm yɛji mʼam ow mʼibrm ↄny low nyam cɛ. Dàdrʼm, ");
INSERT INTO adj_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","kↄ bwo ↄŋ Jan abusu ow ok agŋ mij nuŋ ee? Kↄ Nyam oglog agŋ ee?» ");
INSERT INTO adj_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ɛtŋ -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Eke si dad eke Nyam ↄŋʼn lʼow, li bʼow lʼibrm ɛy lʼɛsɛ: “Kↄ bla sosiɛm ubmn in nawrɛ ee?” ");
INSERT INTO adj_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ɛtŋ ɛmɛny eke si dad eke agŋ ↄŋʼn abusu lʼow, ow bʼow ↄŋ agŋ a fɛŋ ot mebn eke kʼibi ɛy, aŋke -lʼuw any eke Jan el Nyam e kokoba ↄb ɛs tasi.» ");
INSERT INTO adj_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ɛtŋ sica -li dad Jesu ninɛ: «Sʼuwm ɛgŋ ekʼↄŋʼn abusu lʼow lʼok agŋ mij nuŋ ab any.» ");
INSERT INTO adj_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ɛtŋ in yɛji li dad wɛl ninɛ: «Eke ow el ɛbɛn a, ɛm yɛji mi kʼow mi dadm ↄny abusu yecʼɛm eke mi bi kok ów amua fɛŋ a.» ");
INSERT INTO adj_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ɛmɛny Jesu am dad agŋ a nyandrɛ odad na ɛsɛ: «Lɛgŋ nyam ↄgm ɛs nyam ewl viny in ecʼↄgm a, lʼoc lʼabul ↄgm juma kok ɛsɛl, ɛtŋ nʼim usu lɛgŋ kpekpe eci. ");
INSERT INTO adj_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Eke egb ub e lɛgŋ ow a, lʼɛrm in ecʼabu ɛlum ɛs nyam im ɛŋn juma ɛsɛl a eke wɛl kʼↄŋʼn egb a, in ecʼeke kʼɛbmʼn a. Eke abu ɛlum ɛs a im a, juma ɛsɛl a ↄrʼr, ɛtŋ -lʼogŋ ow ow ɛwl abu ↄfr. ");
INSERT INTO adj_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ɛmɛny ↄgm ɛs a ɛrm abu ɛlum ɛs ɛjeci nyam. Kↄ in yɛji juma ɛsɛl a ↄrʼr, wɛwrʼr, ɛtŋ -lʼogŋ ow; ow ɛwl eke -nʼↄↄm ow ob kaka. ");
INSERT INTO adj_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ɛmɛny sakp nyahan ɛm, lʼɛrm abu ɛlum ɛs nyam im. Na ecʼa gbɛ, -lʼↄr ow -li kok ow mob, ɛtŋ -nʼↄny -lʼↄwl ow lakp jam a. ");
INSERT INTO adj_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Eke egb ↄgm ɛs a bʼɛkn ɛbɛn a, li dad ninɛ: “Oho! Kↄ sica ayaf mi ki kokr ab ee? Mi bʼow mʼɛrm ɛm ecʼiy eke mʼerur tasi a; ow kʼↄdm ke -nʼↄny ow ecʼɛlum.” Ɛtŋ lʼɛrm jim im. ");
INSERT INTO adj_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Gbɛkↄ eke -lʼɛkan ow a, -nʼam dadarir ɛl ↄfr -lʼɛsɛ: “Kin ɛgŋ a eke godo godo bʼow el aja ij ɛs a! Sʼíbiʼr ke ↄgm a él ɛy eci.” ");
INSERT INTO adj_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ɛtŋ -nʼↄny -lʼↄwl ow ↄgm a e lakp jam a, ɛtŋ -lʼibi ow.» Sica Jesu ibrm ɛl ninɛ: «Kↄ na, bla lowi ↄgm ɛs a bʼow kok ↄgm juma kok ɛsɛl ab ee? ");
INSERT INTO adj_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Li bʼow lʼow, lʼibi juma kok ɛsɛl a, ke lʼóc ↄgm a nʼↄŋ agŋ ɛjeci.» Eke agŋ a iri sodad amua a, -li dad ninɛ: «Ow kʼow ɛym ɛbɛn!» ");
INSERT INTO adj_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Kↄ Jesu lɛr ɛl ɛtŋ ibrm ɛl ninɛ: «Kↄ Nyam odad na e nyandrɛ el ayaf ee? Lebn a eke êl us ɛsɛl a oc ↄwl a, ɛwl el êl lↄy ɛm e lebn tasi. ");
INSERT INTO adj_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ɛgŋ fɛŋ eke bʼow ɛy lebn na af a, bʼow kikn es, ɛtŋ ɛgŋ fɛŋ eke lebn a bʼow ɛy af a, bʼow piplm ɛm el siflefl.» ");
INSERT INTO adj_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Eke ol e low yɛgm ɛsɛl lele egb waw ɛsɛl ɛgbɛl ab ab uw any eke ɛl sosiɛm anake Jesu ub nyandrɛ na a, -nʼam ↄl eke li kʼↄny ow ke -lʼɛdŋn ow e juma a, gbɛkↄ -nʼam uru agŋ a. ");
INSERT INTO adj_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ow sosiɛm -nʼam ↄsu Jesu kprakpr ɛm. -Li bʼɛrm agŋ ow ɛsɛ nɛnyɛmbri nyam ɛsɛl af, eke kʼↄny Jesu in ecʼodad ebl ɛm, yecʼɛtŋ ke -lʼoc -lʼɛlu ow Jude ecʼes ɛw ɛs a abu ɛm. ");
INSERT INTO adj_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","-Nʼam ibrm Jesu low ikŋ na -lʼɛsɛ: «Low yɛgm agŋ ɛs, sʼuw any eke ŋ e Nyam e low eke bi dad ke bi yɛgm agŋ a el nawrɛ ɛtŋ úrum ɛgŋ any ɛ́s; Nyam ecʼelel eke am ibrm eke si kʼiir ɛb a, bi yɛgm ow ecʼejagb a kpɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Kↄ dàd ɛy ↄ! Ɛy ecʼol ↄŋ abusu eke si ki sↄg wus labm sʼↄŋ Sesar ee?» ");
INSERT INTO adj_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Eke -li dadr ɛbɛn a, Jesu uw ɛl e kprakpr ab any, ɛtŋ dad ɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","«Yɛ̀gmnʼm os nyam.» Ɛtŋ -lʼoc ɛl ecʼos a e nyam -nʼam yɛgm ow. Ɛtŋ Jesu ibrm ɛl ninɛ: «Mɛny ɛwr na lele nin na eke wɛl nↄn os na af a, bwo ecʼɛgŋ ecʼow el ee?» Ɛtŋ -li dad ninɛ: «Sesare eci.» ");
INSERT INTO adj_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ɛtŋ Jesu dad ɛl ninɛ: «Eke ow el ɛbɛn a, ke ↄŋn Sesar yecʼekʼel in ecʼa, ke ↄ́ŋn Nyam yɛji yecʼekʼel in ecʼa.» ");
INSERT INTO adj_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Na ɛm yɛji -lʼↄtum -nʼↄnym ow odad ebl ɛm agŋ a ecʼany af. Kↄ odad eke li dad wɛl a iti ɛl any, ɛtŋ -li bubur ɛnyɛmbri. ");
INSERT INTO adj_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Ow e jam a, Sadusiɛl ecʼagŋ bɛb ow ɛŋn Jesu. (Ke Sadusiɛl anake bi dad ɛsɛ luw ɛm anŋ igb in anm a.) -Nʼam ibrm Jesu low na lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","«Low yɛgm agŋ ɛs, Mois nↄn ol na ↄŋ ɛy dad ninɛ: Eke igŋ nyam ɛbi yↄw ɛtŋ lʼewm iy kaka toŋ lʼuw, ow akpl ke lisijim éb iŋnyↄw a ɛbi, ke éw ey in ab ɛw lisijim nin es. ");
INSERT INTO adj_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Kin agŋ lisijimɛl lↄbŋ e low ekʼɛŋn: likpekp a ɛbi yↄw, lʼewm iy kaka ow ab ɛtŋ lʼuw. ");
INSERT INTO adj_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Li bʼuw a, yony ɛm ecʼa eb iŋnyↄw a ɛbi. In yɛji lʼewm iy toŋ batŋ lʼuw. ");
INSERT INTO adj_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Eke in yɛji li bʼuw a, nyahan ɛm ecʼa yɛji eb iŋnyↄw a ɛbi. Ɛbɛn ɛbɛn toŋ ɛl lↄbŋ mum -lʼɛbi iŋnyↄw a ɛtŋ -lʼuw eke -lʼewm ey kaka. ");
INSERT INTO adj_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ɛtŋ ow ecʼuwr ɛm a, yↄw a yɛji uw. ");
INSERT INTO adj_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kↄ sica lɛgŋ eke agŋ ekʼuw a bʼow igb luw ɛm a, bwo ecʼɛgŋ e yↄw tasi li bʼow lʼel ab ee? Aŋke ɛl a fɛŋ ɛgŋ ɛgŋ ɛbiʼr ow el in e yↄw.» ");
INSERT INTO adj_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesu dad ɛl ninɛ: «Wus na ecʼegŋ lele ↄyↄw ab bʼɛbirir; ");
INSERT INTO adj_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","kↄ egŋ a lele ↄyↄw ab ab ekʼit eke kʼanŋ luw ɛm igb, ke ir ɛb afr a kʼow ɛbirm ij. ");
INSERT INTO adj_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","-Li kʼow -lʼↄtumn -lʼuwmn ij aŋke -nʼanŋ ɛsɛ afr ɛrm ɛsɛl af. Sica -lʼel Nyam ecʼey, aŋke -nʼanŋ luw ɛm -lʼigb. ");
INSERT INTO adj_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Mois dad ayal eke agŋ ekʼuw a bʼow anŋ owr, aŋke kati a ekʼam iri al ab ɛm a, lʼɛsŋ Ɛs Kↄtↄkↄ Abraham e Nyam, Isak e Nyam, Jakↄb e Nyam. ");
INSERT INTO adj_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Kↄ agŋ eke uw a e Nyam li kʼel ee? Njaŋ, lʼel agŋ ekʼuw ke anŋ owr a e Nyam, aŋke in ecʼa agŋ amua fɛŋ anŋ owr.» ");
INSERT INTO adj_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ɛtŋ ol e low yɛgm ɛsɛl bɛb eb odad ɛtŋ dad ninɛ: «Low yɛgm agŋ ɛs, uw dad.» ");
INSERT INTO adj_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Low na eke li dad wɛl ɛbɛn a, ɛgŋ kaka úsm af ibramʼn low ij. ");
INSERT INTO adj_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Sica Jesu ibrm ol e low any uw ɛsɛl a ninɛ: «Ayaf wɛl ↄtu eke ki dad eke Mesi el David eci lilaw ee? ");
INSERT INTO adj_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Aŋke Selu e lɛl ab ɛm a, David in obi am dad ɛsɛ: Ɛs Kↄtↄkↄ Nyam dad ɛm e Kↄtↄkↄ ninɛ: “Òw sig es ɛm e lidr abu af ");
INSERT INTO adj_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","toŋ bake mʼót ŋ ecʼefnu a mʼokʼŋ akr ew.” ");
INSERT INTO adj_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ɛkan, eke sica David bʼɛsŋʼn “Ɛs Kↄtↄkↄ”, ke ayaf Mesi a ↄtu eke kʼel David e lilaw ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Eke agŋ dedeku a am iri in ecʼodad a, Jesu dad in e jam ɛsɛl a ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Ɔ̀sur sos ol e low yɛgm ɛsɛl e lís, ɛl eke -li bʼerur eke -li ki sus mob akpakp -nʼam ɛcm ab, ke -li bʼerur eke dedeku ɛm wɛl kʼɛsŋn ɛl ɛlum ɛm, ɛtŋ Nyam nuŋ igŋ susu a -li bi dogŋn mɛkpn anym es. Es gbɛgbl ecʼob ij owi ɛm yɛji -li bʼerur susu amamn. ");
INSERT INTO adj_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","-Li bʼufŋ eŋnyↄw ɛb es, ɛtŋ -li bi kok nyandrɛ -lʼↄfur Nyam ŋↄŋn yecʼɛtŋ ke wɛl ót ɛl agŋ amamn. Na sosiɛm anake ɛl e jɛj ok a bʼow ɛw tuↄtuↄ a.» ");
INSERT INTO adj_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ow e jam a, Nyamel gbɛl ab ɛm yogŋ cɛ, eke Jesu bʼis any a, lʼɛkn egbreŋgbi ekʼam ɛlu Nyam bia ok ɛl ecʼob ap a kↄprↄ ebr mob ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ɛmɛny lʼɛkn iŋnyↄw gbↄr yↄw nyam yɛji ekʼam ɛlu os ekekey yony kↄprↄ ebr ob ab ɛm; ");
INSERT INTO adj_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ɛtŋ li dad ninɛ: «Low nawrɛ mʼam dad ↄny: iŋnyↄw gbↄr yↄw na ap ob akm agŋ a fɛŋ ecʼa, ");
INSERT INTO adj_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","aŋke ɛl ecʼa -nʼↄŋ ɛl ecʼob eke -nʼↄnyn a ecʼow ekʼigŋ af a, kↄ iŋnyↄw a ecʼa, nʼↄŋ in e gbↄr ɛm ecʼa eke nʼↄny a, ow kpra kpra a eke li kʼiir ɛb af a.» ");
INSERT INTO adj_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sica agŋ bɛb am dad Nyamel gbɛl a e sakpl owi, mebn amamn lele mob amamn ab eke wɛl ap Nyam a e low. Eke Jesu bʼiri a, li dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","«Lɛgŋ am ow eke mebn amua ekʼam ɛkan a, kaka kʼow usrm lawl lebn af anm, aŋke fɛŋ bʼow ɛr ok wus.» ");
INSERT INTO adj_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Odad na eke Jesu dad ab ɛm -lʼibrm ow ninɛ: «Low yɛgm agŋ ɛs, kↄ bogŋ lɛgŋ iy low na bʼow ɛy ee? Ɛtŋ bogŋ e mɛny ɛwr ɛm, wɛl bʼow uw wanci a eke ów amua bʼow ɛy ab any ee?» ");
INSERT INTO adj_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɛtŋ Jesu dad ninɛ: «Ɛ̀wr ɛrm! Kì yɛbr ɛgŋ kʼirmn ↄny! Tasi ɛm a, agŋ nↄnↄ bʼow ow ɛm e nin ɛm dad eke ɛl el Mesi a, ɛtŋ -li bʼow -li dad eke lɛgŋ es abal el a in ow ŋ̂! Kↄ kʼùsr ɛl jam. ");
INSERT INTO adj_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Eke batŋ am irir wɛl am dad ↄny ar owi lele ɛb e bↄbↄr owi ab a, ke erŋn kʼↄ̀ny ↄny. Ow it eke ów amua kʼɛy, kↄ ow elm wus na e nuŋ ɛdŋ. ");
INSERT INTO adj_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Tasi ɛm a, ɛbr nyam ecʼagŋ bʼow im ɛŋn ɛbr ɛjeci nyam ogŋ ar; es ɛw nyam bʼow im ɛŋn es ɛw ɛjeci nyam ar ogŋ eci; ");
INSERT INTO adj_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","wus bʼow umu tuↄtuↄ, ɛtŋ susu nↄnↄ gbɛl af lek bʼow ɛy, ↄl eŋuŋ bʼow ↄny agŋ nↄnↄ; ów erŋn erŋn bʼow ɛy ɛtŋ mɛny ɛwr ɛgbɛl ɛgbɛl bʼow anŋ afr ok ↄkm. ");
INSERT INTO adj_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Gbɛkↄ gbuŋ ke ów amua ɛ́y a, wɛl bʼow ↄny ↄny ke wɛl ijr ↄny gbre, wɛl bʼow ot im ↄny jɛj ok ɛm Nyam nuŋ igŋ susu ɛtŋ wɛl bʼow ok ↄny sobel ɛm, ɛtŋ wɛl bʼow ot ok ↄny ɛ́b ebu lele es ɛw ɛsɛl ab abu ɛm, ekʼeel ɛm e jam ɛsɛl a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Na anake bʼow ↄŋ ijr ɛm e daŋku. ");
INSERT INTO adj_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Ow sosiɛm a èbr ɛwr es nuŋ ɛm ke ɛrmij kʼíkŋm anym okm ↄny low eke bʼow dadr dogŋnin ↄny sosi a eci. ");
INSERT INTO adj_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Ɛm obi mʼow mʼↄŋ ↄny sodad ebl lele sɛwr ab eke bʼow ↄŋ ↄny ecʼefnu a ecʼɛgŋ kaka kʼow ↄtum dadm odad akam ↄny es. ");
INSERT INTO adj_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ɔny ɛsɛl bↄbↄ yɛji, ↄny lisɛl, ↄny lisijimɛl, ↄny ecʼagŋ lele ↄny lawlɛl ab bʼow ↄny ↄny ot im ↄny abusu ɛsɛl ecʼany af; wɛl bʼow ↄb ↄny low, ibi ↄny ɛm ecʼagŋ nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ɛm sosiɛm agŋ a fɛŋ bʼow ifn ↄny, ");
INSERT INTO adj_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","kↄ ↄny e sin nuŋ bↄbↄ yɛji, kaka kʼow iram. ");
INSERT INTO adj_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ìnymn es kikri ɛbɛn cɛ; na ɛm anake bʼow ɛŋan sel a.» ");
INSERT INTO adj_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Ɛmɛny Jesu dad ninɛ: «Eke bʼɛkan áru ekʼiwr did ɛlul Jerusalɛm ɛm a, ke lɛgŋ ab anake bʼow uwr any eke wɛl bʼow ŋuŋnʼn a. ");
INSERT INTO adj_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Kpɛkŋ agŋ a eke bʼow anŋ Jude a, ow akpl ke -lʼuru es -nʼim mafɛny ɛm; agŋ eke bʼow anŋ Jerusalɛm baŋn a -nʼim akpoj, ke agŋ eke bʼow anŋ sikpukpu ɛm a kʼɛ́ym baŋn a ij, ");
INSERT INTO adj_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","aŋke ow bʼow el jɛj ok e sɛgŋ. Yogŋ anake ów a fɛŋ eke Nyam Lɛl dad a bʼow iy nɛny a. ");
INSERT INTO adj_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sɛgŋ amua bʼow ɛw tuↄtuↄ molok ab lisɛl lele ɛl ekʼam ↄŋ ey mɛny ab ab eci, aŋke sɛgŋ a ow bʼow el sↄrŋ ligbɛl eke bʼow ɛy ɛb ab ɛm. Ɛɛ, Nyam bʼow ɛlu in ecʼɛrm bebl ↄkm agŋ a e lís! ");
INSERT INTO adj_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wɛl bʼow ibi ɛl ar ɛm, ɛtŋ wɛl bʼow ot im ɛl madu ↄkr ɛm ɛbr ɛbr fɛŋ ɛm; ɛtŋ Nyam e low any uwm ɛsɛl bʼow eb Jerusalɛm ↄnym ab toŋ bake ɛl e lɛgŋ yɛji úwr.» ");
INSERT INTO adj_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Eke li dad na a, ɛmɛny Jesu ninɛ: «Sɛgŋ am ow eke mɛny ɛwr bʼow anŋ ligbn ɛm, awl ɛm lele mílɛ́l ɛm ab ok ↄkm. Eke wus na af ecʼɛbr ɛbr a fɛŋ bʼow iri okij lele mra ab e likekr a, -li bʼow -nʼↄny ɛrmij. ");
INSERT INTO adj_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Agŋ erŋn bʼow ↄny toŋ úw, eke -li bʼow -li tutr ów a eke bʼow ɛy wus na af e low, aŋke nyam afr ecʼabusu a bʼow ufŋ. ");
INSERT INTO adj_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Yogŋ anake wɛl bʼow ɛkn ɛgŋ ecʼIy eke bʼow anŋ jru ɛm ow, abusu ligbɛl lele anygbɛl ɛm ab a. ");
INSERT INTO adj_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Eke ów amua bʼow ↄb nuŋ am ow a, ke átar sos es inymn es lɛɛr afr, aŋke ↄny ecʼes eb ɛlu e lɛgŋ a ow titm ŋ̂.» ");
INSERT INTO adj_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ɛmɛny Jesu oc nyandrɛ ɛm ecʼodad na ɛtŋ am dad ɛsɛ: «Ɛ̀kan babm e likŋ lele ekŋ ɛjecʼab ab; ");
INSERT INTO adj_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","eke -nʼam gigŋ ↄdↄdↄ a, kpɛkŋ bʼuwr any eke mewij ow titm. ");
INSERT INTO adj_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ɛbɛn nyam coco, eke bʼow ɛkan ów amua ow a, ke kpɛkŋ úwr any eke Nyam e gbreŋgbi usu a ow titm. ");
INSERT INTO adj_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Low nawrɛ mʼam dad ↄny: yɛfɛnyna ecʼagŋ a fɛŋ kʼow uwm ow uwrm, ɛtŋ ów amua bʼow ɛy. ");
INSERT INTO adj_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Afr lele wus ab bʼow ɛc, kↄ ɛm ecʼodad ebl a kʼow ɛcm.» ");
INSERT INTO adj_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","«Ow sosiɛm, ɛ̀wr ɛrm! Kʼòcar ↄny sosi kʼɛlulil es gbɛgbl owi, mar ↄny owi, lele owr anŋ ecʼɛrmij ebr owi ab ɛm, bake íjal sos es lɛgŋ a ów okr ↄny es kpru, ");
INSERT INTO adj_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ɛsɛ asawa eke bʼok ob af ↄny af; tasi ɛm a, ow bʼow okr wus na ecʼagŋ a fɛŋ es. ");
INSERT INTO adj_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kʼɛ̀rur mɛmn, kↄ sɛgŋ fɛŋ ŋↄŋan Nyam yecʼɛtŋ ke ↄ́nyn lɛc akmn ów amua eke bʼow ɛy ab es, ke ↄ́tur inymn es ɛgŋ ecʼIy ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sɛgŋ fɛŋ Jesu bʼim yɛgm agŋ low Nyamel gbɛl a e gbugŋ a ɛtŋ lɛgŋ uk ɛm, li bʼim lʼɛru Olivie lafɛny af. ");
INSERT INTO adj_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ɛtŋ ibribr fafa agŋ a fɛŋ bʼow Nyamel gbɛl a e gbugŋ a eke kʼiri in ecʼodad. ");
INSERT INTO adj_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Sica Futufutu eke ejru ánm ɛm ecʼes gbɛgbl ekʼel Pak a e lɛgŋ a ow titm. ");
INSERT INTO adj_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Egb waw ɛsɛl ɛgbɛl lele ol e low yɛgm ɛsɛl ab am ↄl ew ew ɛm elel eke -li ki kokr bake -lʼibi Jesu, gbɛkↄ erŋn am ↄny ɛl agŋ a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ɛbɛn a, kpɛkŋ Satan ɛy Judas eke wɛl bʼɛsŋ Iskariↄt, jam ɛsɛl lɛw yony a ecʼɛgŋ nyam ɛm. ");
INSERT INTO adj_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ow ↄŋ ɛtŋ nʼim nʼɛŋn Jwifɛl ecʼegb waw ɛsɛl ɛgbɛl a lele Nyamel gbɛl a ecʼↄsu ɛsɛl ekpekp ab ab, ɛtŋ -lʼiririr elel eke li kʼoc Jesu lʼɛlu wɛl abu ɛm a. ");
INSERT INTO adj_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Low na eke Judas dad ɛl a iŋn ɛl sos ɛm toŋ afŋn es, ɛtŋ -lʼɛwar ow eke -li bʼow -li sↄg ow labm. ");
INSERT INTO adj_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Judas ɛgŋ eb, ɛtŋ sica nʼam ↄl akunda sɛnyn yecʼɛm eke li kʼↄny Jesu nʼↄŋ wɛl yecʼɛtŋ ke dedeku a kʼúwm any. ");
INSERT INTO adj_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Lɛgŋ a ekʼel Futufutu ekʼejru ánm ɛm ecʼes gbɛgbl e lɛgŋ eke wɛl kʼibi mɛcɛb kok Pak ecʼob ij a ow. ");
INSERT INTO adj_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ɛtŋ Jesu ɛrm Piɛr lele Jan ab dad ɛl ninɛ: «Ìmn bɛbmn ɛy e Pak ecʼob ij a ecʼusu.» ");
INSERT INTO adj_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Odad na eke ow dad ab ɛm, -lʼibrm ow ninɛ: «Kↄ bogŋ erur eke si kʼim si bɛbm ow e sos ee?» ");
INSERT INTO adj_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Ɛtŋ Jesu dad ɛl ninɛ: «Kin, eke bʼimn ba bʼɛyr baŋn a, bʼow ɛŋan igŋ nyam ekʼuyu mijel. Ùsr ir jam toŋ ↄny yɛji ókr gbugŋ a eke li bʼow lʼɛy a. ");
INSERT INTO adj_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Eke bʼokr gbugŋ a, dàdr gbugŋ ɛs a ɛsrɛ: “Low yɛgm agŋ ɛs am ibrm akŋ yecʼeke in kʼij Pak ecʼes gbɛgbl ecʼob in e jam ɛsɛl ab ab.” ");
INSERT INTO adj_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ɛtŋ li bʼow li yɛgm ↄny êl afr a ecʼakŋ gbɛl nyam ekʼakŋ eci mob fɛŋ iy nɛny ɛm. Yogŋ anake bʼow bɛbmn ɛy ecʼob ij a e sos a.» ");
INSERT INTO adj_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Eke -nʼimn a, -lʼɛkn low a fɛŋ eke Jesu dad ɛl a, ɛtŋ -li bɛbm Pak ecʼob ij a e sos -lʼɛw es. ");
INSERT INTO adj_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Eke wanci ow bɛbmn ab a, Jesu lele in ecʼɛrm ɛsɛl ab ab ow ok es ob ij usu a. ");
INSERT INTO adj_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Eke -nʼam ij ob a, Jesu dad ɛl ninɛ: «Mʼerur tasi eke mi kʼij Pak ecʼob na ↄny ab gbuŋ ke mʼíj gbre. ");
INSERT INTO adj_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Kↄ mʼam dad ↄny eke mi kʼow mʼijm ob na ij, toŋ bake es gbɛgbl ikŋ na e liy a ɛ́y ↄkm Nyam e gbreŋgbi usu a.» ");
INSERT INTO adj_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Eke li dad odad na a, kpɛkŋ lʼoc mij kpↄk, lʼɛlu Nyam bia ɛtŋ li dad ninɛ: «Èbr mij kpↄk na ke ɛ́gŋn ↄny fɛŋ. ");
INSERT INTO adj_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Kↄ mʼam dad ↄny eke ɛmɛny mi kʼow mʼɛgŋm mar na ij toŋ bake Nyam ecʼes ɛw a ów.» ");
INSERT INTO adj_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɛmɛny lʼoc futufutu. Lʼɛlu Nyam bia ɛtŋ nʼↄny lʼubr ɛm, nʼↄŋ wɛl ɛtŋ li dad ninɛ: «Na el ɛm e sos megl eke mʼam ↄŋ ↄny. Kòkr low na ɛm ecʼↄkn eci.» ");
INSERT INTO adj_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Eke -lʼijr ob bake ow uwr a yɛji, lʼoc mij kpↄk eke mar anŋ ɛm nʼↄŋ wɛl ɛtŋ li dad ninɛ: «Mij kpↄk na el sinm owr eke Nyam kok ɛm e mebl eke ok es ↄny sosiɛm a eci. ");
INSERT INTO adj_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Gbɛkↄ kin: ↄny ɛm ecʼɛgŋ nyam ekʼam ↄl ijʼm a anŋ ob ij usu na ɛm ab! ");
INSERT INTO adj_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nawrɛ ɛm, ɛgŋ ecʼIy bʼow uw ɛsɛ elel eke Nyam bɛbm ɛw es ab af, kↄ gbre él ɛgŋ a ekʼↄl ijʼr a eci!» ");
INSERT INTO adj_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Low na eke -lʼirir a ↄŋ ɛtŋ -nʼam bibrmn ɛl ↄfr -lʼɛsɛ: «Kↄ bwo ecʼɛgŋ anake ki kok low na ɛy ɛm ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Eke low na ɛc a, jam ɛsɛl a am atar ów es tuↄtuↄ eke kʼuw ɛgŋ eke ɛl ɛm a kʼel anymu ab any. ");
INSERT INTO adj_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ow sosiɛm Jesu dad ɛl ninɛ: «Ɛb ɛb ɛm eci ɛ́b ebu bʼɛw agŋ es, ɛtŋ ɛl ecʼabusu ab ɛm -li bi dad wɛl eke wɛl kʼɛsŋ ɛl ów amamn kok ɛsɛl. ");
INSERT INTO adj_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Kↄ ↄny ecʼa, ow kʼow elm ɛbɛn. Ɛgŋ eke kʼel ↄny ecʼanymu a, nʼánŋ ɛsɛ iyli af; ke ɛgŋ eke kʼel es ɛw ɛs a, ánŋ ɛsɛ ob oc ↄŋ ɛs af. ");
INSERT INTO adj_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Tasi ɛm a, bwo ecʼɛgŋ el anymu ee? Kↄ ɛgŋ eke bi sig es am ij ob a, oglog ɛgŋ eke bʼoc ob ↄŋ agŋ ab ee? Nawrɛ ɛm, ɛgŋ eke sig es am ij ob a el anymu, kↄ yadŋ ee? Ɛtŋ kin, ɛm mʼanŋ ↄny ecʼaraŋn ɛsɛ ob oc ↄŋ ɛs af. ");
INSERT INTO adj_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Ɛtŋ ↄny yɛji anŋn ɛm ab, ɛm e gbre ijr fɛŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Ɛsɛ elel eke ɛm Ɛs ↄŋʼm abusu eke mi kʼɛw agŋ es a, ɛbɛn ɛm yɛji mʼow mʼↄŋ ↄny abusu nɛnyɛmbri nyam a cɛ. ");
INSERT INTO adj_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ɛm ecʼes ɛw ab ɛm a, bʼow ijr ob, ɛgŋn, ɛtŋ bʼow ɛcr okr es mɛkpn af ɛ́wr Israɛl ecʼeb lɛw yony a es.» ");
INSERT INTO adj_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Eke li dad low na bake ow uwr a, Jesu am lɛr Piɛr ɛtŋ dad ninɛ: «Simↄ, ìgŋ lↄru es iri! Satan ibrm abusu eke bʼow ↄny ufŋ ↄny ɛsɛ egbey eke wɛl bi cic suw es ɛm af. ");
INSERT INTO adj_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Kↄ mi ŋↄŋn Nyam mʼↄŋʼŋ yecʼɛtŋ ke ŋ ecʼↄmn a kʼↄ́bm mɛny. Kↄ ŋ yɛji, lɛgŋ eke bʼow ɛwl ow el ɛm ecʼa, àtr esŋ jimɛl a sos es.» ");
INSERT INTO adj_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Low na eke li dad a, Piɛr ↄdu odad eb ɛtŋ dadʼr ninɛ: «Ɛgŋ gbɛl, mi bɛbm sos eke mi kʼɛy sobel ɛm ŋ ab, ke mʼúw ŋ ab.» ");
INSERT INTO adj_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Kↄ Jesu dadʼr ninɛ: «Piɛr mʼam dadʼŋ, ncok a cɛ, ŋgↄs kʼow ikŋm ɛtŋ bʼow ɛgbr sakp nyahan dad eke uwm im any.» ");
INSERT INTO adj_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Ɛmɛny Jesu dad ɛl ninɛ: «Lɛgŋ a eke mʼɛrm ↄny ke ocmn os, ekpr lele cↄkrukpↄ ab ke imn a, kↄ ↄnyn low nyam ecʼes abur ee?» -Li dad ow ninɛ: «Sʼↄnym low kaka ecʼes abur!» ");
INSERT INTO adj_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ɛtŋ ninɛ: «Kↄ sica, ↄny ecʼɛgŋ ekʼↄny os a, lʼóc gↄŋ. Ɛgŋ ekʼↄny ekpr a yɛji lʼóc; ke ɛgŋ ekʼↄnym lab a, lʼↄ́l in e mob sus ɛm a lʼij ke lʼↄ́l lab. ");
INSERT INTO adj_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Kↄ mʼam dad ↄny nawrɛ ɛm, ow akpl ke Nyam Lɛl ɛm ecʼodad na eke wɛl nↄn ɛm e lís a íy nɛny: Wɛl awlʼl low ŋuŋ kok ɛsɛl ɛm a. Ɛɛ, ɛm e lís e low a eke wɛl nↄn a bʼow iy nɛny!» ");
INSERT INTO adj_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɛtŋ jam ɛsɛl a dadʼr ninɛ: «Ɛgŋ gbɛl, kin sʼↄnym mab ler ɛm yony ab!» Ɛtŋ Jesu ubr odad a es ninɛ: «Na cɛ ow ɛny ŋ̂!» ");
INSERT INTO adj_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Sica Jesu ɛy ↄkm im Olivie lafɛny af ɛsɛ elel eke li bi kok godʼɛtŋ ab af. In e jam ɛsɛl a yɛji usʼr jam ab im. ");
INSERT INTO adj_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Eke -nʼimn ba -li bʼok yogŋ a, li dad wɛl ninɛ: «Ŋↄŋan Nyam, yecʼɛtŋ ke kʼɛ́ymn ɛbm ɛkn owi ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Lʼɛlu wɛl es nʼim anym kpekpe tɛl, ɛtŋ yogŋ lʼok ↄwrↄkp wus nʼam ŋↄŋn Nyam li dad lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","«Ɛs, eke erur, ke ↄny gbre ij e mij kpↄk na kpabʼm es lís. Ke fɛŋ ɛm a, ow kʼél yecʼa eke mʼam erur a, kↄ yecʼa eke am erur a.» ");
INSERT INTO adj_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Kpɛkŋ afr ɛrm ɛs nyam ow ɛŋnʼn ɛtŋ am atrʼr sos es. ");
INSERT INTO adj_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kↄ ɛbɛn yɛji, Jesu am ij ɛrm ɛm e gbre ɛtŋ am ŋↄŋn Nyam lɛc ɛm toŋ law am okʼr. Ɛtŋ in e law a am sus ok wus ɛsɛ mebl ekuey af. ");
INSERT INTO adj_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Eke ni ŋↄŋn Nyam bake ow uwr a, lʼigb wus ɛtŋ lʼɛwl mɛny lʼow nʼɛŋn jam ɛsɛl a, kↄ sos ↄw ɛl es toŋ ow el ɛl mɛmn. ");
INSERT INTO adj_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Eke nʼɛŋan wɛl mɛmn ɛru ɛm a, lʼuwr wɛl ɛtŋ li dad ninɛ: «Kↄ bla ɛtŋ am ɛrur mɛmn ee? Ìgbr wus ke ŋↄ́ŋan yecʼɛtŋ ke kʼɛ́ymn ɛbm ɛkn owi ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesu odad anŋ nɛnym am dad, ɛtŋ kpɛkŋ agŋ nↄnↄ gbɛl ilm any. Ɛtŋ Judas ekʼel jam ɛsɛl lɛw yony ab ɛm e nyam a anake am nyimn ɛl a. Eke -lʼowr -lʼokr yogŋ a, Judas im titm Jesu eke kʼɛyʼr. ");
INSERT INTO adj_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Kↄ Jesu ibrmʼn ninɛ: «Judas, kↄ af ɛy ɛm am ↄl ɛgŋ ecʼIy ij ee?» ");
INSERT INTO adj_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Eke jam ɛsɛl a am ɛkn low a eke am ow ɛy a, -lʼibrm Jesu ninɛ: «Ɛgŋ gbɛl, kↄ sʼógŋ ɛl mum ɛy e mab ler ɛm ab ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ɛtŋ kpɛkŋ ɛl ɛm ecʼɛgŋ nyam iyr egb waw ɛs ligbɛl ecʼabu ɛlum ɛs a lab, ɛtŋ lʼubr ow lidr e lↄru ab es. ");
INSERT INTO adj_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Kↄ Jesu dad ninɛ: «Ow ínym es gↄŋ!» Ɛtŋ lʼitŋn igŋ a e lↄru a abu, ɛtŋ lʼewlm ow. ");
INSERT INTO adj_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Sica li dad egb waw ɛsɛl a, Nyamel gbɛl a ecʼↄsu ɛsɛl ecʼagŋ ɛgbɛl a lele Jwifɛl ecʼagŋ ekpekp a eke ow ɛl ab in ecʼↄny ecʼa ninɛ: «Kↄ ɛm ecʼↄny a ibrm eke kʼotr ekŋ ekpr lele mab ler ɛm ab owr ɛsɛ low ŋuŋ kok ɛs ɛm el af ee? ");
INSERT INTO adj_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Sɛgŋ eke mʼanŋ ↄny ab Nyamel gbɛl ab ɛm a ↄnymnʼm. Kↄ sica ↄny e wanci eke kʼↄnynʼm a ow ŋ̂; catŋ ncebn ecʼabusu a ow a.» ");
INSERT INTO adj_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Sica -nʼↄny Jesu ɛtŋ -lʼoc ow ab -nʼim egb waw ɛs ligbɛl a e gbugŋ a. Piɛr anŋ akpoj ɛm am us ɛl jam. ");
INSERT INTO adj_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Wɛl fuf al lakp a ecʼaraŋn, agŋ ok es did al ɛlul ɛm a, ɛtŋ Piɛr yɛji im sig es ɛl ab. ");
INSERT INTO adj_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ob oc ↄŋ lis nyam ɛknʼn eke li sig es al saw a, lʼok ow anyamn af nʼam lɛr ow gbiy, ɛtŋ ninɛ: «Igŋ na yɛji, nʼanŋ Jesu ab!» ");
INSERT INTO adj_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Kↄ Piɛr ɛgbr Jesu ɛtŋ dad ob oc ↄŋ lis a ninɛ: «Yↄw, mʼuwmʼn any.» ");
INSERT INTO adj_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eke ow ibn tɛl a, ɛgŋ ɛjeci nyam yɛji ɛknʼn ɛtŋ dadʼr ninɛ: «Ŋ yɛji, el ɛl ɛm ecʼɛgŋ nyam.» Kↄ li dad igŋ a ninɛ: «Njaŋ, mʼanm ɛl ɛm!» ");
INSERT INTO adj_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ow ibn toŋ kʼij wanci nyam ka, ɛtŋ ɛmɛny ɛgŋ ɛjeci nyam at dad ninɛ: «Nawrɛ tasi ɛgŋ na yɛji el in ecʼagŋ ab ɛm e nyam, aŋke lʼel Galile iy.» ");
INSERT INTO adj_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Kↄ Piɛr dadʼr ninɛ: «Mʼuwm ŋ e low yeci eke am erur eke ki dad ab any!» Odad na anŋʼn nɛnym nʼam dad ɛtŋ kpɛkŋ ŋgↄs ikŋ. ");
INSERT INTO adj_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ɛtŋ Ɛs Kↄtↄkↄ ɛwl mɛny ↄkŋʼn any am lɛrʼr gbiy. Ow ↄŋ Piɛr ↄkn odad a eke Ɛs Kↄtↄkↄ dadʼr a: «Gbuŋ ke yɛfɛnyna ŋgↄs íkŋ a, bʼow dad sakp nyahan eke uwm im any.» ");
INSERT INTO adj_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ɛtŋ Piɛr ɛy ↄkm im gbeŋ am ikŋ low dudu ecʼↄŋn. ");
INSERT INTO adj_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Agŋ ekʼam ↄsu Jesu a am kokrʼr miyɛr ɛtŋ am ↄrʼr. ");
INSERT INTO adj_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","-Nʼawŋ ow any es, -nʼam ↄr ow kukuta ɛm, -nʼam ibrm ow -lʼɛsɛ: «Ekʼel Nyam e kokoba ↄb ɛs, ke dád ɛy ɛgŋ ekʼiyrʼŋ ob a!» ");
INSERT INTO adj_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ɛtŋ -nʼam dad ów eŋuŋ nↄnↄ gbɛl -lʼok ow af miyɛr kokr ɛm. ");
INSERT INTO adj_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Eke lɛgŋ ɛny a, Jwifɛl ɛm ecʼagŋ ekpekp a ekʼel egb waw ɛsɛl ɛgbɛl a lele ol e low yɛgm ɛsɛl ab ab as luku. -Nʼↄŋ wɛl oc Jesu ow Sanedrɛn ecʼagŋ a ecʼany af, ");
INSERT INTO adj_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ɛtŋ -lʼibrm ow ninɛ: «Dàd ɛy sʼíri gↄŋ! Kↄ ŋ el Mesi ee?» Ɛtŋ li dad wɛl ninɛ: «Eke mi dad ↄny yɛji, kʼow ubmn nawrɛ; ");
INSERT INTO adj_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ɛtŋ eke mʼibrm ↄny low yɛji, kʼow ɛgŋmn dadmnʼm. ");
INSERT INTO adj_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Kↄ jam aŋa ɛgŋ ecʼIy bʼow sig es Nyam Abusu Ɛs e lidr abu af.» ");
INSERT INTO adj_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɛl fɛŋ -li dad ninɛ: «Ke Nyam ecʼIy el a!» Ɛtŋ li dad wɛl ninɛ: «Ow kpɛŋ anake ↄny obi dadr a.» ");
INSERT INTO adj_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ɛtŋ -li dad ninɛ: «Ow akplm eke si kʼibrm adaŋku ij! Sica ɛy obi yɛji sʼiriʼr nɛnym ŋ̂!» ");
INSERT INTO adj_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Eke -li jɛjr Jesu ecʼów -lʼokr bake ow uwr a, dedeku a nimum igb wus ɛtŋ oc Jesu ab im Pilat ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Yogŋ, kpɛkŋ -nʼam cicr ow -li dad -lʼɛsɛ: «Sʼɛbmn nyamn sʼɛkn eke ɛgŋ na am irmn ɛy ecʼagŋ a; li bi dad wɛl eke wɛl kí sↄgm wus labm ɛtŋ li bʼocr in sosi Mesi, ɛb ebu nyam.» ");
INSERT INTO adj_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ɛtŋ Pilat ibrmʼn ninɛ: «Kↄ nawrɛ, ŋ Jwifɛl ecʼɛb ebu ee?» Ɛtŋ Jesu dadʼr ninɛ: «Ŋ obi dad.» ");
INSERT INTO adj_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ɛbɛn a, Pilat dad egb waw ɛsɛl ɛgbɛl a lele bieku ab ab ninɛ: «Mʼɛŋnm low ↄbr kaka igŋ na ɛm.» ");
INSERT INTO adj_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Gbɛkↄ -nʼam at lebl es -li dad lɛc ɛm -lʼɛsɛ: «Ɛgŋ na bi dad agŋ eke kʼↄbr ɛb any. Lʼↄb ow e low yɛgm nuŋ Galile ɛtŋ, toŋ lʼow lʼok Jude wus af, ɛtŋ sica lʼow aŋa yɛji.» ");
INSERT INTO adj_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Eke Pilat iri odad na a, lʼibrm ninɛ: «Kↄ ɛgŋ na Galile ecʼɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Eke wɛl dadʼr eke Jesu el Galile ecʼɛgŋ, ke lʼuw any eke yogŋ anŋ Erↄd ecʼes ɛw ɛm a, nʼↄŋ wɛl oc Jesu im ow ecʼany af, aŋke Erↄd in obi yɛji lɛgŋ ab ɛm a, nʼanŋ Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Eke lʼɛkn ow a, sos ɛm am iŋnʼn aŋke lʼiri wɛl dadʼr ow e lís e low, ɛtŋ lɛgŋ kpekpe ɛtŋ nʼam erur eke li kʼɛŋn ow bake ow kok mɛny ɛwr nyam lʼɛ́kn. ");
INSERT INTO adj_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Li bibrm ow ów nↄnↄ, kↄ Jesu ↄbm kpu kaka ↄↄmʼn. ");
INSERT INTO adj_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Egb waw ɛsɛl ɛgbɛl a lele ol e low yɛgm ɛsɛl ab ab yɛji ekʼanŋ yogŋ a am cicr Jesu lɛc ɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ɛtŋ Erↄd lele in eci srↄda eyŋ ab ab am kokr Jesu miyɛr, ɛtŋ am ocʼr ɛsɛ ɛgŋ keskes af. -Lʼɛw ow mob sus ɛm mamn sos, ɛtŋ lʼɛwlm ow mɛny ow im Pilat ogŋ a. ");
INSERT INTO adj_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Lɛgŋ a cɛ, Erↄd lele Pilat ab eke lɛgŋ ekʼɛc ab ɛm ijarm a, ɛwl el agŋ lawlɛl. ");
INSERT INTO adj_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Eke Pilat am ɛkn eke low ↄbr kaka anm Jesu ɛm a, lʼas egb waw ɛsɛl ɛgbɛl a, es ɛw ɛsɛl a lele dedeku a fɛŋ ab luku, ");
INSERT INTO adj_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ɛtŋ li dad wɛl ninɛ: «Ocr ɛgŋ na isrʼm ɛtŋ am dadr eke owʼn am irmn agŋ. Na sosiɛm mʼibrmʼn low ↄny ecʼany af. Kↄ kin, mʼɛŋnm low ŋuŋ kaka eke li kok ke ow sosiɛm am ↄŋn in dedeku a. ");
INSERT INTO adj_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ɛbɛn nyam coco, Erↄd yɛji ɛŋnm low ↄbr kaka in ɛm, ɛtŋ ow sosiɛm lʼɛwlm ow mɛny. Mʼam ɛkn ke ɛgŋ na kokm low ↄbr kaka ekʼit eke wɛl kʼibiʼr. ");
INSERT INTO adj_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Gbɛkↄ mʼow mʼↄŋ wɛl ↄrʼr ŋgbre ɛm, ke mʼɛ́luʼl es.» ");
INSERT INTO adj_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pak ecʼes gbɛgbl fɛŋ e lɛgŋ a, ow akpl ke Pilat ɛ́lu sobel ɛm ɛs nyam eke dedeku a bʼerur a es. ");
INSERT INTO adj_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Eke Pilat dad ɛl ɛbɛn a, kpɛkŋ -nʼam ↄg ɛl fɛŋ -li dad -lʼɛsɛ: «Ìbi ɛgŋ na, ke ɛ́lu Barabas es ↄŋ ɛy!» ");
INSERT INTO adj_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Ke Barabas na, lɛgŋ ab ɛm eke bↄbar ɛy Jerusalɛm baŋn a, in anake wɛl ɛluʼl sobel ɛm a, aŋke lʼↄbr ɛb any, ɛtŋ lʼibi ɛgŋ yɛji.) ");
INSERT INTO adj_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Gbɛkↄ eke Pilat am erur eke kʼɛlu Jesu es a, ɛmɛny lʼibrm eke li kʼiri dedeku a nɛnym. ");
INSERT INTO adj_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Kↄ -nʼam ɛlu Pilat lebl -li dad -lʼɛsɛ: «Ɛ̀wʼr olikŋ af! Ɛ̀wʼr olikŋ af!» ");
INSERT INTO adj_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Ɛmɛny Pilat eb odad sakp nyahan ɛm ɛtŋ ibrm ɛl ninɛ: «Bla low ↄbr iy li kok ee? Ɛm gbɛ mʼɛknm low ↄbr kaka in ɛm ekʼit eke wɛl kʼibiʼr; gbɛkↄ mʼow mʼↄŋ wɛl ↄ́rʼr ŋgbre ɛm, ke mʼɛ́luʼl es.» ");
INSERT INTO adj_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Kↄ dedeku a nɛny anŋ ɛm cɛ am ibrm sↄ́g ɛm eke wɛl kʼɛw Jesu olikŋ af. Ɛtŋ ɛl e sↄ́g e lebl a akm Pilat es. ");
INSERT INTO adj_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ɛtŋ Pilat ɛgŋ dedeku a ecʼa ekʼam ibrm a eb. ");
INSERT INTO adj_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Lʼɛlu Barabas ekʼↄbr ɛb any, ibi ɛgŋ ke ow sosiɛm wɛl ɛlu sobel ɛm a es. Ɛtŋ lʼoc Jesu nʼↄŋ dedeku a yecʼɛtŋ -li kok ow ɛl e low eke -nʼam erur a. ");
INSERT INTO adj_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Eke -lʼocr ow ab -nʼaam a, -lʼↄbr Sirɛn baŋn iy nyam eke wɛl bʼɛsŋ Simↄ ekʼanŋ akp ɛm am ow. Eke srↄda eyŋ a bʼɛknʼn a, -nʼↄny ow lɛc ɛm ɛtŋ -lʼoc Jesu ecʼolikŋ a -nʼↄŋ ow eke ow kʼabu us ow jam. ");
INSERT INTO adj_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Agŋ nↄnↄ gbɛl am usʼr jam, ɛtŋ ↄyↄw nↄnↄ ekʼanŋ ɛl ɛm a am ikŋ ↄŋn ok sabu ɛrmni in sosiɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Eke Jesu bʼɛwl mɛny a, nʼam lɛr wɛl ɛtŋ li dad ninɛ: «Jerusalɛm ecʼↄyↄw, kʼìkŋn ↄŋn ɛm sosiɛm; kↄ ìkŋn ↄny lele ↄny ecʼey ab eci! ");
INSERT INTO adj_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Kↄ lɛgŋ am ow eke agŋ bʼow dad ɛsɛ: “Ehe él etr yↄw eke ewm ey, ke ↄↄm ey mɛny lɛgŋ kaka a eci!” ");
INSERT INTO adj_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Lɛgŋ ab anake agŋ bʼow dad ɛsɛ: “Mafɛny, bùbmn okr ɛy af! Egigl, bùburir ɛy es a!” ");
INSERT INTO adj_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Tasi ɛm a, eke wɛl am kok likŋ ekʼanŋ owr a nɛnɛ, ke likŋ wɛwɛ ecʼa ayaf wɛl bʼow kokrʼr ab ee?» ");
INSERT INTO adj_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Srↄda eyŋ a oc agŋ ɛjeci yony ekʼel ów eŋuŋ kok ɛsɛl yɛji ow eke wɛl kʼibi ɛl Jesu ab. ");
INSERT INTO adj_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Eke -nʼimn usu a eke wɛl bʼɛsŋ “Nuŋ kpↄk ecʼusu a”, -lʼɛw Jesu lele ów eŋuŋ kok ɛsɛl yony ab ab olikŋ af; Jesu anŋ araŋn, nyam anŋʼn lidr abu af, ɛtŋ nyam anŋʼn nɛmn abu af. ");
INSERT INTO adj_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ɛtŋ Jesu dad ninɛ: «Ɛm Ɛs, òc ap ɛl aŋke -lʼuwm yecʼeke -nʼam kok ab any.» Srↄda eyŋ a cɛc in e mob sus ɛm sↄsum oc kok ɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Agŋ a ekʼanŋ yogŋ a am lɛrʼr. Ɛtŋ Jwifɛl ecʼes ɛw ɛsɛl a am kokrʼr miyɛr dad ɛsɛ: «Lʼeb agŋ ɛjeci lʼɛlu es; eke lʼel Mesi eke Nyam sↄsum oc a, ke lʼébr in sosi sʼɛkn!» ");
INSERT INTO adj_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Srↄda eyŋ a yɛji am kokrʼr miyɛr. -Li bʼim -li titm ow, -lʼoc ɛl e mar a -nʼam ↄkŋ ow ke -nʼam dad -lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","«Ekʼel Jwifɛl ecʼɛb ebu, ke ébr ŋ sosi ɛlu es gↄŋ!» ");
INSERT INTO adj_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","In ecʼolikŋ a e nuŋ af a, -ni nↄn odad na -lʼaru: “Ɛgŋ na el Jwifɛl ecʼɛb ebu.” ");
INSERT INTO adj_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ów eŋuŋ ɛsɛl a eke wɛl ok olikŋ af ab ɛm a yɛji, nyam am wɛwr Jesu dad ɛsɛ: «Kↄ ow elm ŋ elm Mesi ee? Ekʼel Mesi, ke èbr ŋ sosi ɛlu es, bake ɛy yɛji éb ɛlu ɛy es ↄ!» ");
INSERT INTO adj_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Odad na eke li dad a, lawl a am ɛymʼn abr dad ɛsɛ: «Kↄ ɛ́luam Nyam ee? Ŋ yɛji am ij gbre ɛsɛ in af. ");
INSERT INTO adj_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ɛy ecʼa, ow it eke si kʼij gbre, aŋke ɛy ecʼów eŋuŋ e si kok a e labm sↄg anake sʼɛŋn a. Kↄ in, li kokm low ŋuŋ kaka!» ");
INSERT INTO adj_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Eke li dad odad na a, ɛmɛny li dad ninɛ: «Jesu, kʼìjlʼm es lɛgŋ eke bʼow ow ŋ ecʼes ɛw ab ɛm a.» ");
INSERT INTO adj_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Ɛtŋ Jesu dadʼr ninɛ: «Mʼam dadʼŋ nawrɛ ɛm, yɛfɛnyna cɛ bʼow anŋ ɛm ab Nyam ecʼusu mamn a.» ");
INSERT INTO adj_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Sica ow anŋ tɛl ke lɛgŋ úyu nuŋ, ɛtŋ ligbn a ekʼam afŋ a irm es; ncebn ɛy wus na nimum af toŋ ncebles eci wanci nyahan ɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ɛtŋ Nyamel ab ɛm eci gbad gbɛl gbada a eke wɛl ɛw ɛdŋn usu lala ab any a, igŋ afr ɛm a ɛtŋ agbr ɛm araŋn didi toŋ ok esr ɛm a. ");
INSERT INTO adj_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ɛtŋ Jesu barm lebl tuↄtuↄ dad ninɛ: «Ɛm Ɛs, mʼoc ɛm ecʼabŋ a mʼɛluʼŋ abu ɛm.» Li dad odad na ba li bʼok es, ɛtŋ lʼuw. ");
INSERT INTO adj_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Eke Rom eci srↄda eyŋ a ecʼanym ɛs a ɛkn low a ekʼɛy a, nʼam kↄklm Nyam li dad lʼɛsɛ: «Nawrɛ tasi, ɛgŋ na el nɛny nyam ɛs!» ");
INSERT INTO adj_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Agŋ a ekʼow yogŋ a yɛji ɛkn low a ekʼɛy a. Ɛl e mɛny ɛwl ɛm a, -nʼam ok sabu ɛrmni low dudu ɛm -nʼim. ");
INSERT INTO adj_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ɛtŋ Jesu lawlɛl lele ↄyↄw a ekʼusʼr jam Galile ɛtŋ a, inym es akpoj, ɛtŋ am ɛkn low na ekʼam ɛy a. ");
INSERT INTO adj_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Ɛgŋ nyam eke wɛl bʼɛsŋ Josɛf, Jwifɛl eci baŋn eke wɛl bʼɛsŋ Arimate ecʼɛgŋ, erur eke kʼoc Jesu im oc es. Lʼel ɛgŋ mamn, nɛny nyam ɛs, ekʼↄmn ɛm am eku Nyam e gbreŋgbi usu a e mowrer. Ɛtŋ ɛmɛny lʼel Jwifɛl e Sanedrɛn ab ɛm ecʼɛgŋ nyam, kↄ lʼerurm low a eke lawlɛl a bɛbm Jesu ecʼibi ecʼa. ");
INSERT INTO adj_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Na sosiɛm, nʼim nʼɛŋn Pilat ɛtŋ lʼibrm eke ow kʼoc Jesu eci sos megl a ↄŋʼn. ");
INSERT INTO adj_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Eke Pilat ɛlu abusu es a, Josɛf ↄny sos megl a usm es olikŋ ab af, lʼoc gbad ufu nyam li wiwrm ow ab, ɛtŋ lʼoc nʼim lʼoc ow es uwↄmu lob eke nʼↄŋ wɛl ur ab ɛm, ke lɛgŋ kaka wɛl ocm ɛgŋ es ɛm. ");
INSERT INTO adj_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Lɛgŋ a el nɛnɛgŋ e sos bɛbm e lɛgŋ, ɛtŋ nɛnɛgŋ a yɛji ow titm. ");
INSERT INTO adj_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Eke Josɛf aam oc Jesu es a, ↄyↄw a eke am us Jesu jam Galile ɛtŋ a, ow yogŋ ɛtŋ ɛkn uwↄmu a lele elel eke wɛl ɛrumʼn es ab ab. ");
INSERT INTO adj_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","-Lʼɛwl mɛny -nʼim ɛl ogŋ a, ɛtŋ -li kok mun sŋↄsŋↄ lele simijey ab eke -li ki kpakp Jesu e sos megl a. Gbɛkↄ eke lɛgŋ a el nɛnɛgŋ e lɛgŋ a, ow sosiɛm -nʼam eb sel ɛsɛ elel eke Jwifɛl ecʼol a dad ab af. ");
INSERT INTO adj_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Sica lɛgŋ krɛkrɛ a ecʼibribr fafa a, ↄyↄw a ot mun sŋↄsŋↄ eke -li kokr ab ab aam Jesu ecʼuwↄmu ab af. ");
INSERT INTO adj_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Eke -li bʼok yogŋ a, -lʼɛkn eke lob a eke abl uwↄmu a ecʼɛm ɛy usu ab es a wuwl oc es, ");
INSERT INTO adj_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ɛtŋ -lʼok uwↄmu ab ɛm. Gbɛkↄ -lʼɛknm Ɛs Kↄtↄkↄ Jesu e sos megl a, ");
INSERT INTO adj_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ɛtŋ ca -lʼuwmn elel eke -li ki dadr any. Kpɛkŋ Nyam ecʼafr ɛrm ɛsɛl yony eke sus mob ekʼam jɛjn a ok ↄkm ɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Eke ↄyↄw a bʼɛkn ɛl a, erŋn am ↄny ɛl -li sis any es, ɛtŋ ow ↄdm eke -li ki lɛr wɛl. Ɛtŋ ɛrm ɛsɛl a dad ɛl ninɛ: «Kↄ bla ɛtŋ am ↄↄl agŋ ekʼuw ab ɛm, ɛgŋ ekʼanŋ owr ab ee? ");
INSERT INTO adj_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Nʼanm aŋa; lʼigb luw ɛm. Ɔ̀kan ow a eke li dad ↄny lɛgŋ a eke nʼanŋ Galile a: ");
INSERT INTO adj_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","“Ow akpl ke wɛl óc ɛgŋ ecʼIy ɛ́lu sikpl ɛsɛl ecʼabu ɛm, ke wɛl báblʼl ecigbrↄ olikŋ af, ke sɛgŋ nyahan nʼánŋ luw ɛm lʼigb.” » ");
INSERT INTO adj_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ɛtŋ ↄyↄw a ↄkn odad a eke Jesu dad ɛl a. ");
INSERT INTO adj_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","-Nʼŋgboŋ uwↄmu ab af, ɛtŋ -nʼim -nʼam dad ów a fɛŋ ekʼɛy a -lʼok jam ɛsɛl lɛw nyam a lele agŋ ɛjecʼa fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ɔyↄw a el: Mari, Magdala yↄwi a, Jana, lele Mari, Jak lis ab. Ɛtŋ ↄyↄw bɛb a ekʼanŋ ɛl ab yɛji, dad odad nɛnyɛmbri nyam a cɛ ok ɛrm ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Kↄ ɛrm ɛsɛl a am tutr eke ow el yadŋ owi, ɛtŋ -nʼↄnym ↄmn odad a eke ↄyↄw a dad ɛl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ɛbɛn a Piɛr uru es im uwↄmu ab af, lʼis any li lɛr uwↄmu ab ɛm, ɛtŋ lʼɛkn gbad a eke wɛl oc wiwrm sos megl ab ab a cɛ ekʼɛru es. Low na eke lʼɛkn a itiʼr any, ɛtŋ lʼɛwl mɛny nʼim. ");
INSERT INTO adj_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Lɛgŋ a cɛ, jam ɛsɛl ab ɛm ecʼagŋ yony aam baŋn nyam eke wɛl bʼɛsŋ Emayus, ke Jerusalɛm ab a, án es wanci yony gbuŋ ke ók yogŋ. ");
INSERT INTO adj_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Ejagb ab af eke -nʼaam a, -nʼam dad low a ekʼɛy a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Eke -nʼam dad odad -lʼatar ów es a, Jesu in obi ow ɛŋn ɛl, ɛtŋ us ejagb ɛl ab aam. ");
INSERT INTO adj_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","-Nʼam ɛkn ow gↄŋ, kↄ -lʼuwmn ow any. ");
INSERT INTO adj_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ɛtŋ Jesu ibrm ɛl ninɛ: «Bla ów iy am atarir es ee?» Sos ↄw ɛl es, ɛtŋ -lʼuk -nʼinym es. ");
INSERT INTO adj_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ɛl ɛm ecʼɛgŋ nyam eke wɛl bʼɛsŋ Kleopas dadʼr ninɛ: «Kↄ ŋ sↄny cɛ el ɛgŋ ekʼir Jerusalɛm aŋa, ke uwm low na ekʼɛy sɛgŋ amua ɛm ab any ee?» ");
INSERT INTO adj_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesu ibrm ninɛ: «Kↄ bla lowi ɛy?» Ɛtŋ -li dad ow ninɛ: «Nasarɛt iy Jesu e lís e low. Ɛgŋ na el kokoba ↄb ɛs abusu ɛs; ɛtŋ lʼɛlu ow e low ↄkm in e juma kok ɛm lele in ecʼodad ebl ɛm ab, Nyam ecʼany af lele agŋ ecʼany af ab. ");
INSERT INTO adj_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kↄ ɛy ecʼegb waw ɛsɛl ɛgbɛl a lele ɛy e Nyamel ecʼes ɛw ɛsɛl ab oc imʼn wɛl ↄbʼr low, ɛwʼr olikŋ af wɛl ibiʼr. ");
INSERT INTO adj_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ɛy sʼↄmn eke in anake li bʼow li sↄg Israɛl a. Ɛtŋ kin, yɛfɛnyna ab ow ij sɛgŋ nyahan eke lʼuw wɛl ocʼr es. ");
INSERT INTO adj_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Gbɛkↄ ɛy ɛm ecʼↄyↄw bɛb dad ɛy low any iti owi tasi. Ibribr a -lʼigb fafa -nʼim uwↄmu ab af, ");
INSERT INTO adj_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ɛtŋ -lʼɛknm ow e sos megl a. -Lʼɛwl mɛny -lʼow -li dad ɛy eke afr ɛrm ɛsɛl yony in ok ↄkm in dad ɛl eke Jesu in anŋ owr. ");
INSERT INTO adj_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ɛy ɛm ecʼagŋ bɛb yɛji im uwↄmu ab af ɛtŋ -lʼɛkn low a ɛsɛ elel eke ↄyↄw a dad ɛy ab af. Gbɛkↄ ow gbɛ, -lʼɛknm ow.» ");
INSERT INTO adj_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","-Li dad odad na ba -li bʼok es, ɛtŋ Jesu dad ɛl ninɛ: «Oy! Anyamb agŋ, úbmn kokoba ↄb ɛsɛl ecʼodad eke dad a nawrɛ! ");
INSERT INTO adj_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Kↄ uwmn any eke Mesi a kʼij gbre ɛbɛn gbuŋ ke lʼɛ́y in ecʼanygbɛl ab ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Ɛtŋ nʼam otar ów a fɛŋ eke Nyam Lɛl dad in e lís a e low akr lʼok wɛl. Lʼↄb nuŋ Mois ecʼol ab ɛm toŋ lʼigŋ kokoba ↄb ɛsɛl ecʼów a e dad ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Eke -nʼimn bake -nʼam titm baŋn a, Jesu kok ɛsɛ anym eci owʼn kʼimn af. ");
INSERT INTO adj_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Kↄ agŋ yony a dadʼr ninɛ: «Kʼìm; ànŋ ɛy ab eke lɛgŋ am uk, ke ncebn am ow a sosiɛm.» Ɛtŋ nʼim nʼɛŋn wɛl -nʼanŋ. ");
INSERT INTO adj_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Eke ow sig wanci eke -li kʼij ob a, Jesu oc futufutu a, lʼɛlu Nyam bia, lʼubr ɛm nʼↄŋ wɛl. ");
INSERT INTO adj_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kpɛkŋ jam ɛsɛl yony a anyamn ɛm ayl, ɛtŋ -lʼuw ow any; kpɛkŋ lʼirm wɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ɛtŋ -nʼam dadarir -lʼɛsɛ: «Eke sʼus ejagb sʼam ow, ke nʼam otar Nyam Lɛl ɛm ecʼów akr lʼok ɛy a, lɛfr mɛnŋ am itr ɛy sos!» ");
INSERT INTO adj_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kpɛkŋ -lʼɛwl mɛny -nʼim Jerusalɛm, ɛtŋ -nʼɛŋn jam ɛsɛl lɛw nyam a eke as luku lele ɛl lawlɛl ab ab, ");
INSERT INTO adj_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ke ok es am dad ɛsɛ: «Nawrɛ tasi, Ɛs Kↄtↄkↄ igb luw ɛm batŋ Simↄ ɛknʼn!» ");
INSERT INTO adj_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ɛtŋ ɛl yɛji -nʼam dad low a eke -lʼɛkan ejagb af a, lele elel eke -lʼuwr Jesu any, futufutu a eke nʼam ubr ɛm ab ɛm. ");
INSERT INTO adj_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Eke odad anŋ ɛl nɛnym -nʼam dad a, Jesu in obi ɛy ↄkm ɛl ecʼaraŋn ɛtŋ ɛsŋn ɛl: «Ɛrm es ɛy ánŋ ↄny ab!» ");
INSERT INTO adj_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kpɛkŋ erŋn ligbɛl am ↄny ɛl aŋke -nʼam tutr eke ↄŋn abŋ anake -lʼɛkan a. ");
INSERT INTO adj_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Kↄ Jesu dad ɛl ninɛ: «Kↄ bla ɛtŋ erŋn am ↄny ↄny ufŋn ee? Bla ɛtŋ úbmn nawrɛ ee? ");
INSERT INTO adj_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ɛ̀kan ɛm e sabu araŋn a lele ɛm ecʼakr ab ab; ɛm obi ana! Ìtŋninʼm abu ke ɛ́kan. Ɔŋnabŋ ɛ́lim sos megl lele ew ab ɛsɛ elel eke mʼɛli am ɛkan ab af!» ");
INSERT INTO adj_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Eke li dad wɛl odad na a, li yɛgm wɛl in e sabu araŋn a lele in ecʼakr ab ab. ");
INSERT INTO adj_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Sos ɛm am iŋn ɛl, gbɛkↄ ow am iti ɛl any ɛtŋ -li kʼubm nawrɛ tasi. Ow ↄŋ Jesu ibrm ɛl ninɛ: «Kↄ ↄnyamn ob ij tɛl ab aŋa ee?» ");
INSERT INTO adj_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɛtŋ -lʼoc ↄcn ikpr eke wɛl ↄw a -nʼↄŋ ow. ");
INSERT INTO adj_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jesu eb ↄcn a ij ɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Sica li dad wɛl ninɛ: «Ɛ̀kan ów amua, mi dad ↄny ow e low lɛgŋ a eke mʼanŋ ↄny ab a. Mi dad ↄny eke ów a fɛŋ eke wɛl nↄn ɛm e lís ke anŋ Mois ecʼol ab ɛm, kokoba ↄb ɛsɛl e lɛl ɛm, toŋ igŋ Selu e lɛl ɛm a bʼow iy nɛny.» ");
INSERT INTO adj_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Ɛtŋ nʼↄŋ wɛl abusu eke wɛl kʼiri Nyam Lɛl ɛm ecʼodad a ók ɛl es sos ɛm. ");
INSERT INTO adj_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ca lʼↄkn wɛl ów a li dad ninɛ: «Kin ow eke wɛl nↄn: ow akpl ke Mesi úw, ke sɛgŋ nyahan nʼánŋ luw ɛm lʼigb, ");
INSERT INTO adj_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ke wɛl yɛ́gm ɛbr ɛbr fɛŋ low in e nin ɛm, yecʼɛtŋ ke agŋ ítŋn ɛrm ɛm, ke -nʼɛŋn ɛl e sikpl a ecʼoc ap. Ow ↄ́b nuŋ Jerusalɛm, ");
INSERT INTO adj_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ɛtŋ ↄny bʼow eel ów amua ecʼadaŋku. ");
INSERT INTO adj_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ɛtŋ mʼow mʼawŋ ↄny Abŋ Lala a eke ɛm Ɛs ɛwar ow e low a. Gbɛkↄ ànŋn baŋn toŋ bake afr ecʼabusu a ów ɛŋn ↄny.» ");
INSERT INTO adj_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Eke li dad wɛl ów amua bake ow uwr a, ca Jesu ot ok ɛl ↄkm, ɛtŋ ɛl ab -nʼim -li titm Betani, ɛtŋ yogŋ li gbigbl sabu ogŋ lʼɛdŋ wɛl ↄwrↄ. ");
INSERT INTO adj_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Eke nʼam ɛdŋ wɛl ↄwrↄ a, lʼɛlu wɛl es ɛtŋ nʼim afr. ");
INSERT INTO adj_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Jam ɛsɛl a igŋʼn nuŋ, ɛtŋ ɛwl mɛny ow Jerusalɛm sos ɛm iŋn ligbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Sɛgŋ fɛŋ -li bʼanŋ Nyamel gbɛl ab ɛm -li kↄklm Nyam.");
INSERT INTO adj_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Nuŋ ↄb ɛm e low fɛŋ e kok ɛm a, ke Odad anŋ ŋ̂. Ɛgŋ a eke el odad a okr af Nyam ab, ɛtŋ Odad a el Nyam. ");
INSERT INTO adj_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Nuŋ ↄb ɛm ɛtŋ Odad okr af Nyam ab. ");
INSERT INTO adj_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nyam ocʼr kokrʼr ob fɛŋ; ob kaka anm eke wɛl kok ke nʼanm ɛm; ");
INSERT INTO adj_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","fɛŋ a eke wɛl kok a ɛŋn sel in ɛm. Sel ikŋ na el agŋ eci usuayl. ");
INSERT INTO adj_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Usuayl am afŋ ncebn ɛm ɛtŋ ncebn ebmʼn. ");
INSERT INTO adj_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Nyam ɛrm ɛgŋ nyam eke wɛl bʼɛsŋ Jan ow. ");
INSERT INTO adj_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Nʼam ow ɛsɛ daŋku af, ke lʼíj usuayl e daŋku yecʼɛtŋ ke in ɛm agŋ a fɛŋ úb nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","In obi a lʼelm usuayl, kↄ usuayl eci daŋku cɛ lʼij. ");
INSERT INTO adj_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Usuayl ikŋ na el usuayl tasi a ekʼam ow wus af aŋa ayal agŋ fɛŋ a. ");
INSERT INTO adj_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Odad a anŋ wus af aŋa. Nyam ocʼr kokrʼr wus, kↄ wus uwmʼn any. ");
INSERT INTO adj_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Lʼow in ecʼagŋ ɛm, kↄ in ecʼagŋ ɛgŋm ebmʼn. ");
INSERT INTO adj_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Gbɛkↄ agŋ bɛb ebʼr ɛtŋ ↄny ↄmn in ɛm; nʼↄŋ wɛl abusu eke wɛl kʼel Nyam ecʼey. ");
INSERT INTO adj_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ow elm sos megl af e mew ab ɛm, oglog ɛgŋ ecʼerur ɛm -lʼelm Nyam ecʼey, kↄ Nyam ecʼerur ɛm -lʼel Nyam ecʼey. ");
INSERT INTO adj_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Odad a ɛwl el ɛgŋ ɛtŋ ir ɛb ɛy ab; Nyam ecʼerur eke ítŋnm lele nɛny nyam ij ab iyʼr ɛm gbↄŋ. Sʼɛkn in ecʼanygbɛl a, anygbɛl eke Iy bʼɛŋn Ɛs ɛm. ");
INSERT INTO adj_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Jan ij in e daŋku. Lʼɛlu lebl ninɛ: «Lɛgŋ a eke mʼam dad mʼɛsɛ: “Ɛgŋ nyam anŋʼm jam am ow, kↄ nʼↄny any lʼakmʼm aŋke lʼikŋ anym nʼanŋ gbuŋ ɛtŋ mʼanŋ a,” ke in ecʼodad anake mʼam dad a.» ");
INSERT INTO adj_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Tasi ɛm a, ɛy fɛŋ sʼɛŋn in eci aja ab ɛm eci ↄwrↄ a, tasi li yibr ɛy ow bobn. ");
INSERT INTO adj_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sʼɛŋn ol Mois ɛm, kↄ Nyam ecʼerur ekʼítŋnm a lele nɛny nyam ij ab a, anŋ Jesu Krist ɛm ow. ");
INSERT INTO adj_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Lɛgŋ kaka ɛgŋ ɛknm Nyam, kↄ Iy ekpↄbi a sↄny coco eke el Nyam ke anŋ Ɛs ab a cɛ ɛluʼl ↄkm. ");
INSERT INTO adj_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Jwifɛl e nuŋ af ɛsɛl ekʼel Jerusalɛm ecʼa ɛrm egb waw ɛsɛl lele Leviɛl ab Jan ogŋ a eke -li kʼibrm ow -lʼɛsɛ: «Kↄ ŋ bwo el ŋ ee?» Kin Jan eci daŋku ekʼij. ");
INSERT INTO adj_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jan ↄnynm sos es odad a e dad ɛm ɛtŋ agŋ a fɛŋ eci any af li dad lʼɛrum mar ninɛ: «Ɛm, mʼelm Mesi a.» ");
INSERT INTO adj_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","-Lʼibrm ow ninɛ: «Ɛtŋ ŋ bwo ee? Kↄ ŋ Eli ee?» Li dad ninɛ: «Njaŋ, mʼelm Eli.» -Lʼibrm ow ninɛ: «Kↄ ŋ Kokoba ↄb ɛs ab ee?» Ninɛ: «Njaŋ.» ");
INSERT INTO adj_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ɛmɛny -lʼibrm ow ninɛ: «Ke sica ŋ bwo el ŋ ee? Agŋ a ekʼɛrm ɛy a, odad si kʼↄny si dad ɛl. Kↄ ŋ ayaf am ocr ŋ sosi ee?» ");
INSERT INTO adj_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Li dad ninɛ: «Ɛm, mʼel ɛgŋ a ekʼanŋ loj am ɛlu lebl dad ɛsɛ: Kòkr Ɛs Kↄtↄkↄ ecʼejagb a ínym sɛnyn sɛnyn a!» (Kokoba ↄb ɛs Esayi ecʼodad eke dad ab ana.) ");
INSERT INTO adj_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Ke ɛ́rmu ab ɛm Farisiɛl anŋ eke ɛmɛny am ibrmʼn ɛsɛ: «Eke batŋ elm Mesi a, elm Eli, elm Kokoba ↄb ɛs a, ke bla kʼↄŋ kʼam ok agŋ mij nuŋ ee?» ");
INSERT INTO adj_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jan dad ɛl ninɛ: «Ɛm, mʼam ok ↄny mij nuŋ mij ɛm; gbɛkↄ ↄny ecʼaraŋn a, ɛgŋ nyam anŋ eke uwmn any. ");
INSERT INTO adj_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Nʼanŋʼm jam nʼam ow, ɛtŋ mʼitm bↄbↄ yɛji eke mi ki mↄmu in e cↄkrukpↄ meb ab es.» ");
INSERT INTO adj_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ów amua fɛŋ am ɛy Betani ɛb ɛm Jurdɛn jam, yogŋ a eke Jan am ok agŋ mij nuŋ a. ");
INSERT INTO adj_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Eke lɛgŋ ɛny akr af a, Jan ɛkn Jesu ekʼam ow in ogŋ ɛtŋ li dad ninɛ: «Kin Nyam e licɛbli a eke bʼow ↄny wus na e sikpl oc es a. ");
INSERT INTO adj_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Lɛgŋ a eke mʼam dad mʼɛsɛ: “Ɛgŋ nyam anŋʼm jam am ow, nʼↄny any lʼakmʼm, aŋke lʼikŋ anym nʼanŋ gbuŋ ɛtŋ mʼanŋ a,” ke in ecʼodad anake mʼam dad a. ");
INSERT INTO adj_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mʼuwm ɛgŋ a ekʼow kʼel ab any, gbɛkↄ mʼow eke mi kʼok agŋ mij nuŋ mij ɛm, yecʼɛtŋ ke mʼↄ́ŋ Israɛl ecʼagŋ a uwʼr any.» ");
INSERT INTO adj_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Ɛmɛny lʼij daŋku li dad ninɛ: «Mʼɛkn Abŋ Lala ekʼanŋ afr us es ɛsɛ kel af ke sigʼr es af. ");
INSERT INTO adj_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ke mi kʼuwm ɛgŋ eke lʼel ab any, gbɛkↄ Nyam eke ɛrmʼm mʼow eke mi kʼok agŋ mij nuŋ mij ɛm a dadʼm ninɛ: “Bʼow ɛkn Abŋ eke bʼow us es ke sig es ɛgŋ nyam af, in anake li bʼow lʼok agŋ mij nuŋ Abŋ Lala ɛm a.” ");
INSERT INTO adj_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Mʼɛkn low na ɛtŋ mʼam ij daŋku eke ɛgŋ na el Nyam ecʼIy.» ");
INSERT INTO adj_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Eke lɛgŋ ɛny akr af a, ɛmɛny Jan lele in e jam ɛsɛl yony ab anŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Eke lʼɛkn Jesu ekʼam ɛc a, li dad ninɛ: «Kin Nyam eci licɛbli a ↄ!» ");
INSERT INTO adj_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Eke Jan eci jam ɛsɛl yony a iri odad na a, -lʼus ow jam. ");
INSERT INTO adj_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesu ɛwl sos mɛny, lʼɛkn eke agŋ yony am usʼr jam, ɛtŋ lʼibrm wɛl ninɛ: «Kↄ ↄny, bla am ↄↄl ee?» -Lʼibrm ow ninɛ: «Rabi, kↄ ŋ bogŋ ir ee?» (Rabi e nyandrɛ el “Low yɛgm agŋ ɛs.”) ");
INSERT INTO adj_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Li dad wɛl ninɛ: «Òwr, bʼow ɛkan.» Ke ow am titm ncebles eci wanci yar. -Nʼim -lʼɛkn yogŋ a eke lʼir a, ɛtŋ -nʼanŋ ow ab lɛgŋ ikpr a. ");
INSERT INTO adj_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Agŋ a ekʼiri Jan eci sodad a ke us Jesu jam a e nyam el Andre, Simↄ Piɛr lisijim. ");
INSERT INTO adj_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Lʼikŋ anym nʼim lʼɛkn lisijim Simↄ ɛtŋ li dad ow ninɛ: «Sʼɛŋn Mesi a.» (Mesi a e nyandrɛ el “Krist”.) ");
INSERT INTO adj_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andre ɛwl Simↄ Jesu ogŋ a. Jesu lɛrʼr seŋ ɛtŋ dadʼr ninɛ: «Ŋ Simↄ, Jan jim; wɛl bʼow ɛsŋʼŋ Kefas.» (Ow e nyandrɛ el “Lob”.) ");
INSERT INTO adj_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Eke lɛgŋ ɛny akr af a, Jesu ɛw eke kʼim Galile ɛtŋ lʼↄbr Filip. Li dad ow ninɛ: «Ùsʼm jam!» ");
INSERT INTO adj_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Filip a Bɛtsayida ɛb ɛm ecʼɛgŋ; ɛb na anake Andre lele Piɛr ab yɛji el ow ecʼagŋ a.) ");
INSERT INTO adj_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip ↄbr Natanaɛl ɛtŋ dadʼr ninɛ: «Natanaɛl, ɛgŋ a eke Mois dad in ecʼodad ol e lɛl ab ɛm, ke kokoba ↄb ɛsɛl dad ow ecʼodad a, sʼɛŋnʼn. Ɛgŋ a, Nasarɛt e Jesu, Josɛf jim.» ");
INSERT INTO adj_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natanaɛl dadʼr ninɛ: «Kↄ Nasarɛt yɛji, low mamn ↄtu eke kʼanŋ ow ee?» Filip dadʼr ninɛ: «Òw, ke ɛ́kn.» ");
INSERT INTO adj_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Eke Jesu ɛkn Natanaɛl ekʼam ow titmʼn a, nʼam dad ow e lís e low lʼɛsɛ: «Kin Israɛl iy tasi; in ɛm mɛju owi kaka anm.» ");
INSERT INTO adj_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natanaɛl ibrmʼn ninɛ: «Kↄ ayaf uwrʼm any ee?» Li dad ninɛ: «Eke anŋ babm e likŋ a ecʼew a, gbuŋ ke Filip ɛ́sŋʼŋ a, ke mʼɛknʼŋ.» ");
INSERT INTO adj_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Af yogŋ Natanaɛl dadʼr ninɛ: «Low yɛgm agŋ ɛs, ŋ Nyam ecʼIy tasi, ŋ Israɛl ecʼɛb ebu tasi!» ");
INSERT INTO adj_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jesu dadʼr ninɛ: «Mi bi dad mʼɛsɛ, mʼɛknʼŋ babm e likŋ a ecʼew a ekʼanŋ a, ke kpɛkŋ úbʼm nawrɛ ee? Bʼow ɛkn ów ekʼagb akm na!» ");
INSERT INTO adj_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Ɛtŋ lʼigŋ af li dad ninɛ: «Low nawrɛ mʼam dad ↄny: bʼow ɛkan afr eke bʼow fig ke Nyam ecʼafr ɛrm ɛsɛl ám uyu, ke ám us es ɛgŋ ecʼIy e nuŋ af.» ");
INSERT INTO adj_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Eke sɛgŋ yony ɛc a, mɛbi ecʼes gbɛgbl nyam ɛy Kana ɛb ɛm, Galile wus af; Jesu lis yɛji anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Wɛl ɛw Jesu lele in e jam ɛsɛl ab ab yɛji abu. ");
INSERT INTO adj_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Eke ow bʼinŋn ebr a, mar uwr. Jesu lis am dad Jesu ɛsɛ: «Mar uwr ɛl.» ");
INSERT INTO adj_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Kↄ li dad ow ninɛ: «Ɛm lis, bla ɛtŋ am ɛluʼm low na ɛm ee? Ɛm e wanci a kʼowm.» ");
INSERT INTO adj_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ɛbɛn yɛji lis dad juma kok ɛsɛl a ninɛ: «Kòkr low yecʼa eke li bʼow lʼibrm ↄny a.» ");
INSERT INTO adj_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ke yogŋ mijel nↄhↄn eke wɛl kok lebn ɛm anŋ. Mijel amua eke nyam ↄtu eke kʼij litr ekŋ yen a anake Jwifɛl bʼoc kokr ɛl eci sayl owi Nyam ecʼany af a. ");
INSERT INTO adj_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jesu dad juma kok ɛsɛl a ninɛ: «Òkr mij mijel amua ɛm ow íy.» -Lʼok ɛm ow iy ok ɛnyɛmbri a. ");
INSERT INTO adj_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ɛtŋ Jesu dad ɛl ninɛ: «Sica àwr mij a tɛl ke ócr imn ↄŋn es gbɛgbl a e nyimn ɛs a.» Juma kok ɛsɛl a kok ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Li tat mij a ekʼitŋn el mar a anm, lʼuwm yogŋ eke mar a anŋ ow ab any, gbɛkↄ juma kok ɛsɛl a ekʼaw mij a gbɛ uw any. Lʼɛsŋ mɛbi ɛs a, ");
INSERT INTO adj_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","lʼigbl ow abu ogŋ ɛtŋ sica ninɛ: «Agŋ a fɛŋ mar mamn -li bʼↄb nuŋ -nʼↄŋ agŋ ɛgŋ; eke agŋ a e wɛl ɛw abu a ɛgŋ mar nↄnↄ a, ke sica -nʼↄŋ wɛl mar mij mij a gↄŋ. Gbɛkↄ ŋ ecʼa, ɛw mar mamn a es toŋ it wanci na!» ");
INSERT INTO adj_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Kin elel eke Kana ɛb ɛm Galile wus af, Jesu ɛlul in eci mɛny ɛwr krɛkrɛ a ↄkm. Lʼɛlu in ecʼany gbɛl ↄkm ɛtŋ jam ɛsɛl a ubʼr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Eke low na ɛy oc es a, in obi in obi, lis, lisijimɛl lele in e jam ɛsɛl ab ab -lʼus nuŋ es -nʼim Kapɛrnayum. -Nʼanŋ yogŋ -li kok sɛgŋ waa cɛ. ");
INSERT INTO adj_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Jwifɛl eci Pak ecʼes gbɛgbl a titm, ɛtŋ Jesu uyu im Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Nyamel gbɛl a e gbugŋ a, lʼɛkn agŋ ekʼam ↄl sed, mɛcɛb lele prɛndrɛ ab ij; nʼɛŋn jɛtɛ titŋn ɛsɛl yɛji eke ok es ɛl eci an ↄl usu a. ");
INSERT INTO adj_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Li kok say ɛtŋ ɛl fɛŋ eke -nʼanŋn Nyamel gbɛl a e gbugŋ a, lʼogŋ lʼok wɛl ↄkm, ɛl e mɛcɛb lele ɛl e sed ab ab; nʼↄny jɛtɛ titŋn ɛsɛl ecʼos a lele ɛl eci sitabl ab ab lʼok wus; ");
INSERT INTO adj_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ɛtŋ lʼɛwar prɛndrɛ ↄl ij ɛsɛl a ninɛ: «Kʼòcr ɛm Ɛs ecʼêl a ɛsɛ an ↄl êl af! Ɔ̀nyn mob amua fɛŋ otr es aŋa!» ");
INSERT INTO adj_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","In eci jam ɛsɛl a ↄkn Nyam Lɛl ab ɛm e sodad amua: O Admaga, ŋ ecʼêl a ecʼerur eke mʼↄny a, bʼow ɛtulʼm ɛsɛ al eke bʼɛtul ob af. ");
INSERT INTO adj_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Af yogŋ, Jwifɛl ecʼes ɛwɛl a am ibrmʼn ɛsɛ: «Bogŋ e mɛny ɛwr ↄtu eke ki kok, ke ow yɛgm ɛy eke low na eke kok a, ↄny ow ecʼabusu eke ki kok ɛbɛn ee?» ");
INSERT INTO adj_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jesu dad ɛl ninɛ: «Eke ŋuŋan Nyamel na, ow bi kok sɛgŋ nyahan mʼow mʼusr ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","-Li dad ow ninɛ: «Wɛl ɛw akpo ekŋ yony miy nↄhↄn us Nyamel gbɛl na, ɛtŋ ŋ am dad eke bʼow usr ɛm sɛgŋ nyahan ee?» ");
INSERT INTO adj_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Ke Nyamel a eke Jesu am dad ow ecʼodad a, in e sos megl ab ana. ");
INSERT INTO adj_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Ow ↄŋ, lɛgŋ a eke Jesu igb agŋ ekʼuw ab ɛm a, in e jam ɛsɛl a ↄkn eke lʼikŋ anym li dad odad na; ɛtŋ ow ɛm -lʼub Nyam Lɛl lele Jesu eci sodad eke dad ab ab a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Lɛgŋ ab ɛm a eke Jesu anŋ Jerusalɛm, Pak ecʼes gbɛgbl a ecʼa, agŋ nↄnↄ ubʼr nawrɛ simɛny ɛwr eke nʼam kok ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Gbɛkↄ Jesu ↄnym ↄmn ɛl ɛm aŋke ɛl fɛŋ lʼuw wɛl any sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lʼibram eke wɛl kʼotar ɛgŋ kaka fɛŋ e lís e low akr okʼr, aŋke in obi ɛm li bʼuw ɛgŋ e low eke bʼanŋ ɛrm ɛm ab any. ");
INSERT INTO adj_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Lɛgŋ ab ɛm a, Farisiɛl ɛm ecʼɛgŋ nyam anŋ eke wɛl bʼɛsŋ Nikodɛm, lʼel Jwifɛl ecʼanym ɛsɛl ab ɛm ecʼɛgŋ nyam. ");
INSERT INTO adj_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ncok nyam, lʼow nʼɛŋn Jesu ɛtŋ nʼam ibrm ow lʼɛsɛ: «Low yɛgm agŋ ɛs, sʼuw any eke Nyam ɛrmʼŋ ow eke ki yɛgm ɛy low, aŋke ow it ke Nyam ánŋ ɛgŋ ab ab gbuŋ ke lʼↄ́tu li kok mɛny ɛwr amua ɛsɛ elel eke am kok ab af.» ");
INSERT INTO adj_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jesu dadʼr ninɛ: «Low nawrɛ mʼam dadʼŋ: ɛgŋ kaka kʼↄtum ɛknm Nyam e gbreŋgbi usu a, eke ow elm afr ecʼabusu ɛm wɛl ewrmʼn ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodɛm ibrm Jesu ninɛ: «Ɛgŋ ekʼusu a, ayaf wɛl ↄtu eke kʼewar ɛm ee? Kↄ lʼↄtu eke li kʼim lʼɛy lis e lokm wɛl ewar ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jesu dad ninɛ: «Ɛɛ, low nawrɛ mʼam dadʼŋ, ɛgŋ kaka kʼↄtum ɛym Nyam eci gbreŋgbi usu a eke wɛl ewmʼn mij ɛm lele abŋ ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Lʼow yecʼeke bʼanŋ agŋ ɛm ow a, bʼel sos megl eci; ɛtŋ low yecʼeke bʼanŋ Nyam ecʼAbŋ ɛm ow a, bʼel Abŋ eci. ");
INSERT INTO adj_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Eke mi dadʼŋ eke ↄny fɛŋ wɛl kʼewr ↄny ɛm afr ecʼabusu ɛm, ke ow kʼítiʼŋ any. ");
INSERT INTO adj_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Yogŋ eke lɛf bʼerur a, li bʼɛlu nʼimn; bʼiri in ecʼɛlu a, gbɛkↄ úwm yogŋ eke li bʼanŋ lʼow lele yogŋ eke li bʼim ab any. Ɛgŋ fɛŋ eke wɛl ew Nyam ecʼAbŋ ɛm a, ɛbɛn ekʼow bʼɛcr ana.» ");
INSERT INTO adj_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Af yogŋ, Nikodɛm dadʼr ninɛ: «Kↄ ayaf ow ↄtu eke kʼɛcr ee?» ");
INSERT INTO adj_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jesu dadʼr ninɛ: «Ŋ kʼel Israɛl wus af eci low yɛgm ɛs ligbɛl nyam, ke kʼúwm ów amua any ee? ");
INSERT INTO adj_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Ɛɛ, low nawrɛ mʼam dadʼŋ: low yecʼa eke sʼuw any a, ow ecʼodad sʼam dad, ɛtŋ low yecʼa eke sʼɛkn a, sʼam ij ow eci daŋku; gbɛkↄ ɛy eci daŋku ij a, ɛ́gŋmn ebmn. ");
INSERT INTO adj_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Eke mi bi dad ↄny wus ecʼów a, úbmnʼm nawrɛ; eke sica mʼam dad ↄny Afr ecʼów, ke ayaf bʼow ubrʼm nawrɛ ab ee? ");
INSERT INTO adj_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Ɛgŋ kaka uyum afr ekʼow elm ɛgŋ ecʼIy sↄny cɛ ekʼanŋ afr us es a! ");
INSERT INTO adj_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ɛsɛ elel eke Mois oc lowi ɛm lorŋn ucu likŋ kʼigbl ogŋ loj a, ɛbɛn ow it eke wɛl kʼigbl ɛgŋ ecʼIy yɛji ogŋ, ");
INSERT INTO adj_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","yecʼɛtŋ ke ɛgŋ kaka fɛŋ eke bʼow ubʼr nawrɛ a, ɛ́ŋn sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Tasi ɛm a, Nyam erur wus ecʼagŋ a afŋn es toŋ nʼↄŋ wɛl in ecʼIy ekpↄbi a, yecʼɛtŋ ke ɛgŋ kaka fɛŋ ekʼↄny ↄmn in ɛm a kʼúwm, kↄ ke nʼɛ́ŋn sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Tasi ɛm a, Nyam ↄↄm in ecʼIy owm wus ecʼagŋ ogŋ eke li kʼↄb wɛl low, kↄ ke Jim ɛm a, li sↄ́g wɛl. ");
INSERT INTO adj_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Ɛgŋ ekʼub Iy a nawrɛ a, Nyam kʼow ↄbmʼn low; gbɛkↄ ɛgŋ ekʼubm nawrɛ a, ke Nyam ↄbʼr low ŋ̂, aŋke lʼubm Nyam ecʼIy ekpↄbi a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Sica kin elel eke low ↄb a bʼɛcr: usuayl ow wus ecʼagŋ ogŋ, ɛtŋ agŋ erur ncebn akm usuayl aŋke -li bi kok ów eŋuŋ. ");
INSERT INTO adj_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Ɛgŋ kaka fɛŋ ekʼam kok low ŋuŋ a, ↄny usuayl eci sifn ɛtŋ am kpabʼr es lís, aŋke nʼam uru eke in ecʼów eŋuŋ a kʼok ↄkm usuayl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Gbɛkↄ agŋ a eke bi kok Nyam ecʼerur a, bʼim titm usuayl, yecʼɛtŋ ke agŋ ɛ́kn sɛnyn sɛnyn eke ɛl ecʼów a e kok a ɛcr Nyam ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Sica eke ów amua ɛc a, Jesu lele in e jam ɛsɛl ab ab im Jude ecʼogog a. Nʼanŋ yogŋ wɛl ab lʼok agŋ mij nuŋ sɛgŋ bɛb. ");
INSERT INTO adj_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan yɛji, Ayinↄn a eke titm Salim a, nʼam ok agŋ mij nuŋ aŋke yogŋ mij nↄnↄ anŋ. Agŋ am ow in ogŋ ok mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ke wɛl kʼɛlum Jan sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Sica ów es atar ɛy Jan eci jam ɛsɛl bɛb lele Jwif nyam ab ecʼaraŋn, ów eke wɛl bi kok Nyam ecʼany af sos ayal ecʼa sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","-Nʼim -nʼɛŋn Jan ɛtŋ -nʼam dad ow -lʼɛsɛ: «Low yɛgm agŋ ɛs, Jurdɛn jam a ecʼɛgŋ a eke anŋ ŋ ab, ke ij in e daŋku a, kↄ am ↄkn in e low ee? Aŋ! Sicaca ɛm a, nʼam ok agŋ mij nuŋ ɛtŋ agŋ a fɛŋ bʼim am ɛknʼn!» ");
INSERT INTO adj_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan dad ɛl ninɛ: «Ɛgŋ kaka kʼↄtum ɛŋnm low ecʼabusu eke Afr ↄↄmʼn. ");
INSERT INTO adj_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ɔtur eke ↄny obi yɛji kʼijr daŋku; mi dad mʼɛsɛ: “Mʼelm Mesi a, kↄ eke wɛl ikŋ anym ɛrmʼm cɛ.” ");
INSERT INTO adj_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Mɛbi ɛs anake mɛbi lis bʼel in ecʼa; kↄ mɛbi ɛs e lawl a, mɛbi ɛs a e saw li bʼanŋ ke nʼám iri ow e low; ɛtŋ eke li bʼiri mɛbi ɛs a e lebl a, li bʼanŋ sos ɛm iŋn ɛm. Ɛm eci sos ɛm iŋn ab ana, ɛtŋ sicaca ɛm a, ow iy nɛny fɛŋ. ");
INSERT INTO adj_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Ow it eke in ecʼany gbɛl a ám agb, ke ɛm ecʼa ís es. ");
INSERT INTO adj_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ɛgŋ ekʼel Afr ecʼa, anŋ fɛŋ eci nuŋ af; ɛgŋ ekʼel wus ecʼa el wus eci, ɛtŋ bi dad wus ecʼów. Ɛgŋ ekʼow Afr eci nin ɛm a, anŋ fɛŋ eci nuŋ af; ");
INSERT INTO adj_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","li bʼij low eke lʼɛkn ke lʼiri a eci daŋku, kↄ ɛgŋ ɛ́gŋm in e daŋku ij a ebm. ");
INSERT INTO adj_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ɛgŋ eke bʼɛgŋ in e daŋku ij a eb a, am ɛgŋ eb eke Nyam el low nɛnyɛmbri nyam. ");
INSERT INTO adj_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ɛgŋ eke Nyam ɛrm a bi dad Nyam ecʼodad, aŋke Nyam bʼɛlu ɛgŋ a in ecʼAbŋ a nimum fɛŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Nyam erur Iy a ɛtŋ nʼↄŋ ow abusu a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ɛgŋ yecʼeke ↄny ↄmn Iy ab ɛm a, ɛŋn sel ekʼↄnym uwr; ɛgŋ eke bi yayr Iy a kʼow ɛŋnm sel ikŋ na, ɛtŋ li bʼow nʼanŋ Nyam ecʼɛrm bebl a ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Farisiɛl iri wɛl am dad eke Jesu am ↄŋ wɛl am ok agŋ mij nuŋ nↄnↄ akm Jan, ɛtŋ nʼam ɛŋn jam ɛsɛl yɛji lʼakm ow. (Tasi ɛm a, Jesu in obi lʼokm ɛgŋ kaka mij nuŋ, kↄ in e jam ɛsɛl anake am ok agŋ mij nuŋ a.) Eke Jesu iri ów amua eke wɛl am dad a, nʼŋgboŋ Jude ɛtŋ lʼɛwl nʼim Galile. ");
INSERT INTO adj_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ke nʼím a, ow it eke li kʼɛcr Samari wus af eci. ");
INSERT INTO adj_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lʼow li titm Samari eci baŋn nyam eke wɛl bʼɛsŋ Sikar. Baŋn a titm Jakↄb ecʼↄgm a ekʼↄŋ jim Josɛf a. ");
INSERT INTO adj_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Yogŋ anake Jakↄb eci mijↄmu a anŋ a. Eke Jesu sos kikn es usu im ab ɛm a, li sig es mijↄmu a e saw. Ow ↄtu eke ki bɛbmn lɛgŋ uyu nuŋ ab. ");
INSERT INTO adj_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Samari yↄwi nyam ow am aw mij, ɛtŋ Jesu dadʼr ninɛ: «Yↄw na ee! Ɔ̀ŋʼm mij tɛl mʼɛ́gŋ.» ");
INSERT INTO adj_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ke in e jam ɛsɛl a im baŋn a eke kʼↄl ob ij.) ");
INSERT INTO adj_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Samari yↄwi a dad Jesu ninɛ: «Kↄ ŋ, eke el Jwif a, ayaf tasi ɛm eke mʼel Samari yↄwi a, am sus tasi ibrm im mij eke kʼɛgŋ ee?» (Tasi ɛm a, Samari eyŋ lele Jwifɛl ab nɛny ókrm af.) ");
INSERT INTO adj_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jesu dadʼr ninɛ: «Blel uw Nyam ecʼob ap a, lele ɛgŋ a ekʼam ibrmʼŋ mij eke kʼɛgŋ ab any ana, ke ŋ anake blel ɛ́wl ibrmʼn mij eke kʼɛgŋ, ke blel nʼↄ́ŋ mij ewl mij a.» ");
INSERT INTO adj_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Yↄw a ↄdu eb dad ninɛ: «Ɛgŋ gbɛl, mijↄmu a im ɛm, ɛtŋ ɛmɛny sonu yɛji ↄnyam ab; bogŋ bʼow ɛŋn mij ewl mij ikŋ na ee? ");
INSERT INTO adj_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Mijↄmu na, ɛy lagŋ Jakↄb ↄŋ ɛy, in obi lʼɛgŋ mij a, in ecʼey lele in e mɛbob ab yɛji ɛgŋ mij na. Kↄ am tutr eke agb akm Jakↄb ee?» ");
INSERT INTO adj_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jesu dadʼr ninɛ: «Ɛgŋ fɛŋ eke bʼow ɛgŋ mij na a, ɛmɛny mijamn bʼow ↄnyʼn; ");
INSERT INTO adj_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","gbɛkↄ ɛgŋ eke bʼow ɛgŋ mij a eke mʼow mʼↄŋʼn a, mijamn kʼow ↄnymʼn lɛgŋ kaka. Mij a eke mʼow mʼↄŋʼn a bʼow ɛwl el mij ewl mij ekʼow ɛm sel ekʼↄnym uwr bʼow jɛjn ok ↄkm.» ");
INSERT INTO adj_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Yↄw a dadʼr ninɛ: «Ɛgŋ gbɛl, ↄŋʼm mij ikŋ na yecʼɛtŋ ke mijamn kʼↄ́nym im mʼowm aŋa mʼawm mij ij.» ");
INSERT INTO adj_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jesu dadʼr ninɛ: «Ìm ɛsŋ acŋ ke ɛ́wl mɛny ow aŋa.» ");
INSERT INTO adj_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Yↄw a dadʼr ninɛ: «Mʼↄnym igŋ.» Jesu dadʼr ninɛ: «Ŋ e low ij eke dad ekʼↄnym igŋ a, ");
INSERT INTO adj_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","aŋke ikŋ anym ↄny egŋ yen, ɛtŋ lɛgŋ na ɛm ecʼɛgŋ a ekʼin ab ir a yɛji elm ŋ ecʼigŋ. Dad low nɛnyɛmbri nyam.» ");
INSERT INTO adj_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ɛtŋ yↄw a dadʼr ninɛ: «Ɛgŋ gbɛl, mʼam uw any eke ŋ kokoba ↄb ɛs. ");
INSERT INTO adj_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ɛy lagŋɛl Samari eyŋ igŋ Nyam nuŋ lafɛny na af, ɛtŋ ↄny Jwifɛl bi dadr eke yogŋ eke wɛl kʼigŋ Nyam nuŋ a el Jerusalɛm.» ");
INSERT INTO adj_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jesu dadʼr ninɛ: «Yↄw, ùbʼm nawrɛ: lɛgŋ am ow ɛtŋ yogŋ eke bʼow igŋn Ɛs Nyam nuŋ a, ow kʼow elm lafɛny na af, ow kʼow elm Jerusalɛm yɛji. ");
INSERT INTO adj_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ɔny, Samari eyŋ, ↄny e Nyam eke bʼigŋn nuŋ a, uwmn in any; ɛy Jwifɛl, ɛy ecʼa eke si bʼigŋ nuŋ a, sʼuwʼr any, aŋke Jwifɛl ɛm es eb ɛlu anŋ ow. ");
INSERT INTO adj_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Lɛgŋ am ow, ɛtŋ lɛgŋ a ow yɛjʼŋ̂, yogŋ, Nyam nuŋ igŋ ɛsɛl tasi a bʼow igŋ Ɛs nuŋ abŋ ɛm, ɛsɛ elel eke Jim ɛluʼl ↄkm ab af; tasi ɛm a, Nyam nuŋ igŋ ɛsɛl amua anake Ɛs am ↄl es a. ");
INSERT INTO adj_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Nyam el abŋ, ow sosiɛm agŋ a eke kʼigŋʼn nuŋ a, -lʼit eke -li kʼigŋ ow nuŋ abŋ ɛm ɛsɛ elel eke Jim ɛluʼl ↄkm ab af.» ");
INSERT INTO adj_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Yↄw a dadʼr ninɛ: «Mʼuw any eke Mesi a bʼow ow. (Mesi a ow e nyandrɛ el Krist.) Lɛgŋ a eke li bʼow lʼow a, li bʼow lʼotar ów a fɛŋ akr lʼok ɛy.» ");
INSERT INTO adj_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jesu dadʼr ninɛ: «Ɛm eke mʼam dadʼŋ odad a, ɛm ana.» ");
INSERT INTO adj_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ɛtŋ wanci ab af, Jesu eci jam ɛsɛl a ɛwl ow, ɛtŋ -nʼɛŋan ow eke ow am dad odad yↄw ab; eke -lʼɛkan ow a, ow e low iti ɛl any. Gbɛkↄ ɛl ɛm ecʼɛgŋ kaka ↄtum ibramʼn low ɛsmɛ: «Kↄ bla am ↄl ee? Kↄ bla ɛtŋ am dad ów in ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Yↄw a ɛw in e mijel a es yogŋ, ɛtŋ lʼɛwl nʼim baŋn a, nʼam dad agŋ lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","«Òwr ɛkan ɛgŋ eke dadʼm ɛm e low fɛŋ eke mi kok a. Kↄ ow kʼelm Mesi ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Agŋ a ok ↄkm baŋn a ɛtŋ aam yogŋ a eke Jesu anŋ a. ");
INSERT INTO adj_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ke ow eci wanci ab af, jam ɛsɛl a am ŋↄŋn Jesu ɛsɛ: «Ɛgŋ gbɛl, ìj ob tɛl ↄ!» ");
INSERT INTO adj_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Kↄ li dad wɛl ninɛ: «Mʼↄny ob ij eke uwmn any.» ");
INSERT INTO adj_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Jam ɛsɛl a am bibrmn in ɛl ↄfr ɛsɛ: «Kↄ ɛgŋ ka kʼisʼr ob ij ee?» ");
INSERT INTO adj_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jesu dad ɛl ninɛ: «Eke mi kok ɛgŋ a ekʼɛrmʼm a ecʼerur, ɛtŋ mʼuwar juma a eke lʼabulʼm a, ke ɛm ecʼob ij ab ana. ");
INSERT INTO adj_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ɔny, bʼewal egb a, bi dadr ɛsrɛ: “Ɛmɛny ow anŋ awl yar gbuŋ ke egb ub e lɛgŋ bɛ́bmn ab.” Gbɛkↄ ɛm, mʼam dad ↄny eke ki lɛɛr sↄgm a sɛnyn sɛnyn: egb a ebl, ow bɛbmn ub ab! ");
INSERT INTO adj_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ɛgŋ ekʼam ub egb a, kpɛkŋ bʼɛŋn in e labm sↄg a, ɛtŋ li bʼas egb a luku sel ekʼↄnym uwr eci; ow ɛm a, ɛgŋ ekʼam ewl lele ɛgŋ ekʼam ub ab ab bʼokr af kok sos ɛm iŋn. ");
INSERT INTO adj_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ɛɛ, nyandrɛ odad na ekʼam dad ɛsɛ: “Ɛgŋ nyam bʼewl, ke ɛgŋ ɛjeci nyam bʼub a,” el low nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ɔgm nyam ɛm eke kokmn juma a, mʼɛrm ↄny imn ubr egb yogŋ; agŋ ɛjeci ikŋ anym kok juma yogŋ, ɛtŋ ↄny ɛŋan gbre eke -lʼijr a e liy.» ");
INSERT INTO adj_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Yↄw a dad Samari eyŋ a ninɛ: «Ɛgŋ na dadʼm low fɛŋ eke mi kok a.» Ow ɛm a, agŋ a ub nawrɛ aŋke yↄw a dad ɛl. ");
INSERT INTO adj_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ow sosiɛm, eke Samari eyŋ a im ɛŋn Jesu a, -ni ŋↄŋn ow ekʼow kʼɛgŋ anŋ ɛl ab; ɛtŋ Jesu anŋ yogŋ sɛgŋ yony. ");
INSERT INTO adj_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Ɛtŋ sica Jesu, in obi ecʼodad eke nʼam dad a sosiɛm, agŋ a ekʼam ubʼr nawrɛ a am ɛny afŋn es; ");
INSERT INTO adj_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ɛtŋ -nʼam dad yↄw a -lʼɛsɛ: «Sica ow elm ŋ ecʼodad a eke dad a sosiɛm cɛ sʼubm nawrɛ ij, kↄ ɛy obi sʼiriʼr nɛnym, ɛtŋ sʼuw any eke lʼel wus na ecʼEs Eb Ɛlu Ɛs tasi.» ");
INSERT INTO adj_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Eke sica Jesu kok sɛgŋ yony usu a, lʼigb yogŋ nʼim Galile. ");
INSERT INTO adj_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Tasi ɛm a, in obi lʼikŋ anym li dad ninɛ: «Kokoba ↄb ɛs ↄ́nym any in ecʼɛb tasi ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Gbɛkↄ sica eke nʼim lʼɛy Galile wus af a, yogŋ ecʼagŋ a ebʼr sɛnyn sɛnyn, aŋke agŋ amua yɛji im Jerusalɛm Pak ecʼes gbɛgbl ab ɛm ɛtŋ -lʼɛkn ów a fɛŋ eke Jesu kok es gbɛgbl a e lɛgŋ a. ");
INSERT INTO adj_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Sica ɛmɛny lʼɛwl lʼow Galile Kana baŋn, yogŋ a eke lʼoc mij li kokr mar a. Ɛb ebu a eci juma idr ɛs ligbɛl a anŋ yogŋ. In ecʼiy ekʼanŋ Kapɛrnayum a ↄl am ↄny. ");
INSERT INTO adj_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Eke juma idr ɛs a iri eke Jesu anŋ Jude ow Galile a, nʼim nʼɛŋn ow ɛtŋ nʼam ŋↄŋn ow ekʼow kʼow Kapɛrnayum ewlm jim ekʼam uw a. ");
INSERT INTO adj_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jesu dadʼr ninɛ: «Ɔny gbɛ sɛgŋ fɛŋ, eke ɛknmn mɛny ɛwr lele ów any iti owi ab a, kʼↄtumn ubmn nawrɛ.» ");
INSERT INTO adj_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Juma idr ɛs a dadʼr ninɛ: «Ɛgŋ gbɛl, òw ɛm ogŋ a gbuŋ ke ɛm ecʼiy a úw.» ");
INSERT INTO adj_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jesu dadʼr ninɛ: «Ɛ̀wl im ŋ ogŋ a, kↄ ejimŋ sos ok es.» Lʼub odad a eke Jesu dadʼr a nawrɛ ɛtŋ nʼim gbugŋ. ");
INSERT INTO adj_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Eke kpɛkŋ lʼus ejagb nʼaam a, in eci juma kok ɛsɛl a ekʼam usʼr jam ow a ↄbrʼr ɛtŋ dadʼr ninɛ: «Ejimŋ sos ok es!» ");
INSERT INTO adj_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Kpɛkŋ nʼam ibrm wɛl wanci ab af eke in ecʼiy a sos ok es a, ɛtŋ -li dad ow ninɛ: «Efi ncebles eci wanci nyam ɛm, lɛgŋ na af anake lɛfr a ocʼr es lís a.» ");
INSERT INTO adj_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Odad a ok iy ɛs a es sos ɛm ekʼow el wanci ab af a cɛ eke Jesu dadʼr eke ejimŋ sos ok es a, ɛtŋ in lele in ecʼakŋ ab ab a fɛŋ -nʼↄny ↄmn Jesu ɛm. ");
INSERT INTO adj_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sakp yony ɛm e mɛny ɛwr eke Jesu kok, Jude eke nʼanŋ nʼim Galile ab ana. ");
INSERT INTO adj_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Eke ów amua ɛc a, Jwifɛl am kok Nyam nuŋ igŋ ɛm ecʼes gbɛgbl nyam Jerusalɛm, ɛtŋ Jesu im yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Baŋn a e lakp a e lisany nyam eke wɛl bʼɛsŋ Mɛcɛb e lisany a, ow e saw a usu nyam anŋ eke wɛl kok ok mij ɛm, ke ↄny lɛf eb usu yen, usu a Ebre ɛm wɛl bʼɛsŋʼn Betɛsda. ");
INSERT INTO adj_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Yogŋ, ↄ́lu nↄnↄ gbɛl ɛsɛ ány eflu, akr kpɛcɛ ɛsɛl, lele sos es wɛw ɛsɛl ab lɛru es.  ");
INSERT INTO adj_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɔlu nyam ekʼanŋ ↄl ɛm akpo likŋ lele lɛw lele niwn ab anŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Eke Jesu ɛkn ↄlu a eke ɛgŋm es wus yogŋ, ke lʼiri eke owʼn anŋ ↄl ɛm lɛgŋ kpekpe ɛtŋ a, lʼibrm ow ninɛ: «Kↄ erur eke kʼewl ee?» ");
INSERT INTO adj_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Li dad ow ninɛ: «Ɛgŋ gbɛl, ɛm ecʼa mij a bʼumu a, mʼↄnym ɛgŋ eke kʼↄny ɛluʼm ɛm. Eke mi bʼↄl eke mi kʼim mʼɛy mij ab ɛm a, ɛgŋ ɛjeci bʼɛc afŋʼm es ɛy ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Li dad ow ninɛ: «Ìgb, òc ŋ eci ajraŋka a ke án es.» ");
INSERT INTO adj_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kpɛkŋ ↄlu a ewl, lʼoc in ecʼajraŋka a ɛtŋ nʼam an es. Ke low na, nɛnɛgŋ e lɛgŋ ow am ɛy. ");
INSERT INTO adj_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Jwifɛl ecʼes ɛwɛl a am ibrm ɛgŋ a eke wɛl ewlm a ɛsɛ: «Yɛfɛnyna nɛnɛgŋ e lɛgŋ, abusu ɛrumʼŋ es eke kʼoc ŋ ecʼajraŋka ↄnym ab.» ");
INSERT INTO adj_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Li dad wɛl ninɛ: «Ɛgŋ a eke ewlm im a dadʼm eke mi kʼoc ɛm ecʼajraŋka a ke mʼán es.» ");
INSERT INTO adj_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ɛtŋ -lʼibrm ow ninɛ: «Bwo ecʼɛgŋ dadʼŋ eke kʼoc ŋ ecʼajraŋka a ke án es ee?» ");
INSERT INTO adj_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Kↄ ɛgŋ a uwm ɛgŋ a ekʼewlmʼn ab any, aŋke Jesu irm agŋ a ekʼanŋ yogŋ ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Eke ow bʼinŋn ebr a, Jesu ɛŋnʼn Nyamel gbɛl a e gbugŋ a ɛtŋ dadʼr ninɛ: «Sica kin eke ewl. Kì kok sikpl ij bake ɛ́ŋn low eke agb akm na.» ");
INSERT INTO adj_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɔlu a im ɛtŋ dad Jwifɛl ecʼes ɛwɛl a ekʼow el Jesu anake ewlmʼn a. ");
INSERT INTO adj_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ow sosiɛm Jwifɛl a at ɛŋn Jesu, low na eke li kok nɛnɛgŋ a eci. ");
INSERT INTO adj_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Gbɛkↄ Jesu dad ɛl ninɛ: «Sɛgŋ fɛŋ ɛm Ɛs abu anŋ juma kok ɛm ɛtŋ ɛm yɛji abu anŋʼm juma kok ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Odad na sosiɛm, sica ɛmɛny Jwifɛl ecʼes ɛwɛl a am at tasi eke kʼibi Jesu aŋke ow elm nɛnɛgŋ ecʼol a eke lʼↄb es a cɛ, kↄ ɛmɛny nʼam dad eke Nyam in el Ɛs tasi. Na ɛm a, nʼam ocr in sosi ɛsɛ Nyam af. ");
INSERT INTO adj_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ow ɛm a, Jesu ɛwl eb odad ɛtŋ dad ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: Iy kʼↄtum kokm low kaka in obi ɛm; yecʼeke li bʼɛkn Ɛs kok a, ow li bi kok. Tasi ɛm a, low fɛŋ eke Ɛs a bi kok a, low nyam coco a cɛ Iy a yɛji bi kok, ");
INSERT INTO adj_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","aŋke Iy Ɛs a bʼerur Iy a ɛtŋ li bi yɛgm ow in obi e low eke li bi kok a. Ɛtŋ ɛmɛny li bʼow li yɛgm ow ów eke bʼow agb akm amua, ɛtŋ ow bʼow iti ↄny any. ");
INSERT INTO adj_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Tasi ɛm a, ɛsɛ elel eke Iy Ɛs a bʼigbm agŋ ekʼuw a ke bʼↄŋ ɛl sel a, ɛbɛn nyam coco Iy a yɛji bʼↄŋ ɛgŋ eke li bʼerur a sel. ");
INSERT INTO adj_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Ɛtŋ ɛmɛny ɛgŋ fɛŋ e lís e jɛj ok owi a, Iy Ɛs a ɛ́knm ow e low, kↄ nʼↄŋ Iy a jɛj ok owi ecʼabusu a fɛŋ, ");
INSERT INTO adj_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","yecʼɛtŋ ke agŋ a fɛŋ ↄ́ny Iy a eci sos usr ɛsɛ elel eke -li bʼↄny Iy Ɛs a eci sos usr ab af. Ɛgŋ yecʼeke usrm Iy a sos a, usrm Iy Ɛs a ekʼɛrmʼn a yɛji sos. ");
INSERT INTO adj_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Ɛɛ, low nawrɛ mʼam dad ↄny: ɛgŋ kaka fɛŋ eke bʼiri ɛm e sodad a, ke bʼub ɛgŋ a eke ɛrmʼm a nawrɛ a, nʼɛŋn sel ekʼↄnym uwr ŋ̂. Nʼↄnym jɛj ok ij, ɛtŋ ow ↄŋ lʼubr luw ɛm lʼɛy owr anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Ɛɛ, low nawrɛ mʼam dad ↄny: lɛgŋ am ow, ɛtŋ lɛgŋ a lʼow yɛjʼŋ̂; lɛgŋ na ɛm agŋ ekʼuw a bʼow iri Nyam ecʼIy e lebl, ɛtŋ agŋ a eke bʼow iri lebl a, bʼow anŋ owr. ");
INSERT INTO adj_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ɛsɛ elel eke tasi ɛm a Iy Ɛs a el sel e nuŋ a, ɛbɛn nyam coco nʼↄŋ Iy a yɛji abusu eke kʼel sel e nuŋ. ");
INSERT INTO adj_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ɛtŋ eke Iy a el ɛgŋ ecʼIy a sosiɛm a, nʼↄŋ ow jɛj ok owi ecʼabusu. ");
INSERT INTO adj_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ow kʼíti ↄny any. Lɛgŋ am ow, ɛtŋ ow ɛm, agŋ a fɛŋ ekʼuw wɛl ot es a bʼow iri in e lebl, ");
INSERT INTO adj_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ɛtŋ ɛgŋ ɛgŋ bʼow anŋ uwↄmu ɛm ɛy ↄkm. Agŋ a eke kok ów amamn a bʼow igb ke ɛ́ŋn sel, gbɛkↄ agŋ a eke kok ów eŋuŋ a, bʼow igb jɛj ok eci. ");
INSERT INTO adj_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Ɛm obi ɛm, mi kʼↄtum mi kokm low kaka fɛŋ. Nyam e low eke bi dadʼm ab af mi bi jɛj ɛgŋ e low mʼok, ɛtŋ ɛm e jɛj ok a el nawrɛ, aŋke mʼↄlm ɛm e low eke mʼam erur ab es, kↄ ɛgŋ a eke ɛrmʼm a ecʼa eke bʼerur a, mʼam ↄl es.» ");
INSERT INTO adj_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","«Eke ɛm, mʼam ij ɛm e nuŋ af e daŋku, liy kʼow anm ɛm e daŋku ij ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kↄ ɛgŋ ɛjeci anake am ij ɛm e nuŋ af e daŋku a, ɛtŋ mʼuw any eke daŋku ij na el nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Ɔny, ɛrmn agŋ Jan ogŋ, ɛtŋ lʼij low nɛnyɛmbri nyam e daŋku. ");
INSERT INTO adj_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ɛm, mʼibram eke ɛgŋ kʼij ɛm e nuŋ af e daŋku, kↄ mʼam dad ɛbɛn yecʼɛtŋ ke Nyam sↄ́g ↄny. ");
INSERT INTO adj_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan ɛw ɛsɛ kɛniɛ eke wɛl igŋ kʼam iri ayal usu af, ɛtŋ ɛgŋn ebr kokr sos ɛm iŋn in ecʼusuayl ab ab wanci tɛl eci cɛ. ");
INSERT INTO adj_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Kↄ ɛm e daŋku ij a eke mʼↄny a, agb akm Jan ecʼa: ów amua eke mʼam kok a, amua tasi eke ɛm Ɛs ↄŋʼm eke mi ki kok a, am ij ɛm e nuŋ af e daŋku, ɛtŋ am yɛgm eke ɛm Ɛs ɛrmʼm. ");
INSERT INTO adj_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ɛtŋ ɛm Ɛs eke ɛrmʼm a yɛji am ij ɛm e nuŋ af e daŋku. Gbɛkↄ tasi lɛgŋ kaka irimn in e lebl ɛtŋ ɛmɛny lɛgŋ kaka ɛknmn in ecʼelel eke nʼanŋn a. ");
INSERT INTO adj_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","In eci sodad a írm ↄny ɛm, aŋke úbmn ɛgŋ a eke lʼɛrm a nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Bi wewar Nyam e Silɛl a mɛwl ɛm eke kʼuwr any, aŋke bi tutar eke kʼɛŋan sel ekʼↄnym uwr ɛl ɛm. Ke tasi ɛm a, sodad amua anake am ij ɛm e nuŋ af e daŋku a! ");
INSERT INTO adj_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ɛtŋ ɛbɛn yɛji, érurmn eke kʼowr ɛm ogŋ ɛŋan sel tasi a ekʼↄnym uwr a. ");
INSERT INTO adj_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Ɛm, mʼↄlm agŋ ecʼes susm ab es. ");
INSERT INTO adj_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kↄ ↄny ecʼa, mʼuw ↄny any: mʼuw any eke ↄnymn Nyam ecʼerur. ");
INSERT INTO adj_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Mʼow ɛm Ɛs e nin ɛm ɛtŋ ɛgŋmn ebmnʼm. Gbɛkↄ ekʼɛgŋ ɛjeci nyam ow in obi e nin ɛm bʼow ebr ir! ");
INSERT INTO adj_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Bʼerurir ↄny ↄfr ɛm ecʼes susmnin owi, ɛtŋ ↄ́lmn Nyam sↄny coco ogŋ ecʼes susm owi ab es; ke ayaf ↄtur eke kʼubrʼm nawrɛ ab ee? ");
INSERT INTO adj_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ɛm Ɛs ecʼany af a, kì tutar eke mʼow mʼok ↄny ów af; kↄ Mois anake bʼow ok ↄny ów af a, in ɛm eke ocr ↄny ecʼↄmn a ɛlul a. ");
INSERT INTO adj_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Tasi ɛm a, eke ubr Mois nawrɛ ke ɛm yɛji bʼow ubrʼm nawrɛ, aŋke ɛm e lís e low anake Mois nↄn a. ");
INSERT INTO adj_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Kↄ eke sica yecʼa eke Mois nↄn ɛm e lís a ubmn nawrɛ, ke ayaf ↄtur eke kʼubr ɛm e sodad a nawrɛ ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Eke low na ɛc a, Jesu imn Galile ogog a e mij lekpl a eke wɛl bʼɛsŋ Tiberiad yɛjʼa e jam. ");
INSERT INTO adj_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Agŋ nↄnↄ am usʼr jam aŋke -nʼam ɛkn mɛny ɛwr eke nʼam kok ↄ́lu a ecʼewlm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ow ↄŋ Jesu uyu ligigl nyam af ɛtŋ sig es yogŋ jam ɛsɛl ab ab. ");
INSERT INTO adj_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Pak ekʼel Jwifɛl ecʼes gbɛgbl a e lɛgŋ titm. ");
INSERT INTO adj_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Eke Jesu bʼigbl any ogŋ a, lʼɛkn agŋ nↄnↄ ekʼam ow in ogŋ, ɛtŋ lʼibrm Filip ninɛ: «Bogŋ sʼↄtu eke si kʼↄl futufutu sʼↄŋ agŋ a fɛŋ ij ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Tasi ɛm a, low a eke Jesu am ow kok a, in obi lʼuw any, kↄ lʼibrm Filip low na eke li kʼɛbm ow a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip dadʼr ninɛ: «Eke ow el os ekŋ lɛw yɛji, si kʼↄtum sʼɛŋnm futufutu ekʼɛgŋ ɛgŋ kʼɛŋn likpr liy nyam bↄbↄ yɛji.» ");
INSERT INTO adj_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Andre, Simↄ Piɛr lisijim ekʼel in e jam ɛsɛl ab ɛm ecʼɛgŋ nyam a dadʼr ninɛ: ");
INSERT INTO adj_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","«Aŋa, iyli nyam ↄnym futufutu yen lele ↄcn yony ab. Gbɛkↄ na yɛji ow elm low kaka agŋ bubutɛ na ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ɛtŋ Jesu dad ninɛ: «Ɔ̀ŋn agŋ a fɛŋ ok es.» (Ke usu a, suw owr anŋ nↄnↄ.) Sica ɛl fɛŋ -lʼok es; -lʼↄtu eke -li kʼij egŋ fandi yen. ");
INSERT INTO adj_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jesu ot futufutu a, lʼɛlu Nyam bia, ɛtŋ nʼↄŋ wɛl cɛc ↄŋ agŋ a ekʼok es yogŋ a. Li kok ɛbɛn ↄcn ab ab yɛji, nʼↄŋ wɛl ow a fɛŋ eke -nʼam ibrm a. ");
INSERT INTO adj_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Eke sica agŋ a fɛŋ ij ob lok iy a, Jesu dad in e jam ɛsɛl a ninɛ: «Kↄkŋn ekpr a eke wawal es a yecʼɛtŋ ke kaka kʼíram.» ");
INSERT INTO adj_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","-Li kↄkŋ futufutu yen a eke -lʼijr a ecʼekpr eke wawal es a, ɛtŋ ow iy mulu ɛgbɛl lɛw yony. ");
INSERT INTO adj_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Eke agŋ a ɛkn mɛny ɛwr na eke Jesu kok a, -li dad ninɛ: «Ɛgŋ na, Kokoba ↄb ɛs tasi a eke kʼow wus af aŋa ab ana.» ");
INSERT INTO adj_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jesu uw any ekʼagŋ a bʼow ↄnyʼn lɛc ɛm ɛwʼr ɛb ebu. Ow sosiɛm ɛmɛny lʼɛwl mɛny nʼim ligigl ab af in sↄny. ");
INSERT INTO adj_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Eke lɛgŋ ew es a, Jesu e jam ɛsɛl a us nuŋ es mij nɛny a, ");
INSERT INTO adj_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ɛtŋ ok mijɛtŋ nyam ɛm am ubr mij lekpl a imn Kapɛrnayum eci. Lɛgŋ yɛji am ukm ab, ɛtŋ Jesu yɛji kʼiim kʼɛŋnm ɛl. ");
INSERT INTO adj_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Lɛf am ɛlu lɛc ɛm ɛtŋ mra am ɛlu mij lekpl ab af. ");
INSERT INTO adj_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","-Lʼↄr mij ba ow kʼij kilo yen oglog nↄhↄn ɛtŋ kpɛkŋ -lʼɛkn Jesu ekʼam an es mij ab af ow titm mijɛtŋ a, ɛtŋ erŋn am ↄny ɛl. ");
INSERT INTO adj_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Gbɛkↄ Jesu dad ɛl ninɛ: «Erŋn kʼↄ́ny ↄny, kↄ ɛm!» ");
INSERT INTO adj_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Jam ɛsɛl a erur eke kʼↄny ɛluʼl mijɛtŋ ab ɛm, ɛtŋ kpɛkŋ mijɛtŋ a itr es yogŋ a eke -nʼaam a e nanu a. ");
INSERT INTO adj_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Eke lɛgŋ ɛny akr af a, agŋ a ekʼanŋ mij lekpl a e jam a, ɛkn ekʼow el mijɛtŋ nyam cɛ anake anŋ yogŋ ncebles ɛm a; -lʼuw any eke jam ɛsɛl a im ɛl sↄny, eke Jesu ɛym ɛl e mijɛtŋ ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Gbɛkↄ simijɛtŋ ɛjeci ekʼanŋ Tiberiad am ow a, ow itr es usu a eke Ɛs Kↄtↄkↄ oc futufutu ɛlu Nyam bia ke -lʼijr a. ");
INSERT INTO adj_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Eke agŋ a ɛkn eke Jesu lele in e jam ɛsɛl ab ab anm yogŋ a, -lʼok simijɛtŋ ab ɛm -nʼim Kapɛrnayum -nʼam ↄl Jesu. ");
INSERT INTO adj_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ɛtŋ eke -nʼɛŋan Jesu mij lekpl a e jam a, -nʼam ibrm ow -lʼɛsɛ: «Low yɛgm agŋ ɛs, kↄ bogŋ eci wanci af ɛtŋ ow aŋa ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: am ↄↄlʼm ekʼijr futufutu molok iy ↄny a sosiɛm, kↄ ow elm ɛm e mɛny ɛwr a e nyandrɛ a eke irir a eci. ");
INSERT INTO adj_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Kì kokr ob eke bʼugŋ es a e juma, kↄ kòkr yecʼa eke bʼibn ke el sel ekʼↄnym uwr a e juma. Ɛgŋ ecʼIy bʼow ↄŋ ↄny ob ij ikŋ na, aŋke tasi ɛm a, Ɛs Nyam in obi oc in ecʼabusu a e mɛny ɛwr a ɛwʼr af.» ");
INSERT INTO adj_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Ɛtŋ sica -nʼam ibrm ow -lʼɛsɛ: «Kↄ juma a eke Nyam am erur a, ayaf si ki kokr ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jesu dad ɛl ninɛ: «Juma a eke Nyam am ibrm ↄny a el: ke ↄ́nyn ↄmn ɛgŋ a eke lʼɛrm ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","-Li dad ow ninɛ: «Bogŋ eci mɛny ɛwr ↄtu eke ki kok yɛgm ɛy ke ow af, sʼúbʼŋ nawrɛ ee? Ŋ eci juma ekʼam kok a el bogŋ ecʼee? ");
INSERT INTO adj_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Loj yogŋ, ɛy lagŋɛl ij futufutu ɛsɛ elel eke wɛl nↄn Nyam Lɛl ɛm ab af: nʼↄŋ wɛl futufutu ekʼanŋ afr ow a -lʼij.» ");
INSERT INTO adj_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ɛtŋ Jesu dad ɛl ninɛ: «Low nawrɛ, mʼam dad ↄny: afr eci futufutu a, ow elm Mois ↄↄm ↄny, kↄ ɛm Ɛs anake ↄŋ ↄny afr eci futufutu tasi a. ");
INSERT INTO adj_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Tasi ɛm a, Nyam eci futufutu a eke bʼↄŋ ɛgŋ a, el ɛgŋ a eke bʼanŋ afr ow, ke bʼↄŋ wus na nimum ecʼagŋ a fɛŋ sel a.» ");
INSERT INTO adj_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Ɛtŋ -li dad ow ninɛ: «Ɛgŋ gbɛl, sɛgŋ fɛŋ ↄŋ ɛy futufutu ikŋ na.» ");
INSERT INTO adj_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jesu dad ɛl ninɛ: «Mʼel sel e futufutu. Ɛgŋ yecʼeke bʼow ow ɛm ogŋ a, lɛgŋ kaka namn kʼow ↄnymʼn, ɛtŋ ɛgŋ yecʼeke bʼow ↄny ↄmn ɛm ɛm a, lɛgŋ kaka mijamn kʼow ↄnymʼn. ");
INSERT INTO adj_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Gbɛkↄ mʼikŋ anym mi dad ↄny: ɛkanʼm ɛtŋ ubmn nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ɛgŋ liy nyam nyam fɛŋ eke ɛm Ɛs bʼow ↄŋʼm a, bʼow ow ɛm ogŋ, ɛtŋ lɛgŋ kaka mi kʼow mʼogŋm ɛgŋ eke bʼow ow ɛm ogŋ a, ");
INSERT INTO adj_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","aŋke mʼanŋ afr mʼow wus af aŋa, ow elm ɛm ecʼerur kok eci, kↄ ɛgŋ ekʼɛrmʼm a ecʼerur mi ki kok. ");
INSERT INTO adj_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ɛtŋ kin ɛgŋ a ekʼɛrmʼm a e low ekʼam erur: ke mi kʼírmnm agŋ a fɛŋ a eke lʼabulʼm a e nyam, kↄ ke lɛgŋ es abal el ɛm a, mʼígbm ɛl luw ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ɛɛ, tasi ɛm a, kin low ekʼɛm Ɛs am erur: ke agŋ a fɛŋ ekʼɛkn Iy a ke ↄny ↄmn in ɛm a, ɛ́ŋn sel ekʼↄnym uwr, ke lɛgŋ es abal el ɛm a, mʼígbm ɛl luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jwifɛl a am ɛny abr ok Jesu af aŋke li dad ninɛ: «Mʼel futufutu ekʼanŋ afr us es.» ");
INSERT INTO adj_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ow sosiɛm -nʼam dad -lʼɛsɛ: «Kↄ ow elm Josɛf jim Jesu ee? Ɛs lele lis ab a, sʼuw ɛl any sɛnyn sɛnyn. Ke sica ayaf lʼↄtu eke li ki dad lʼɛsɛ: “Mʼanŋ afr mʼus es” ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jesu dad ɛl ninɛ: «Kʼɛ̀nyn abr ↄny ↄfr ɛm ↄ! ");
INSERT INTO adj_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɛgŋ kaka kʼↄtum owm ɛm ogŋ eke ɛm Ɛs ekʼɛrmʼm a nyimnmʼn; ke sica ɛm, lɛgŋ es abal el ɛm a, mʼígbmʼn luw ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kokoba ↄb ɛsɛl e silɛl ab ɛm e nyam ɛm wɛl nↄn: Nyam bʼow yɛgm ɛl fɛŋ low any uw. Ɛgŋ fɛŋ ekʼiri ɛm Ɛs ecʼodad ke ɛgŋ in e low yɛgm a e low eb a, ke ɛm ogŋ nʼam ow a. ");
INSERT INTO adj_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ow elm ke ɛgŋ ɛkn ɛm Ɛs nyamn ɛm; ɛgŋ a cɛ eke Nyam ɛrm a cɛ ɛkn Ɛs. ");
INSERT INTO adj_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Low nawrɛ mʼam dad ↄny: ɛgŋ ekʼↄny ↄmn ɛm ɛm a, ↄny sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ɛm anake mʼel futufutu a eke bʼↄŋ ɛgŋ sel a. ");
INSERT INTO adj_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ke loj yogŋ ↄny lagŋɛl ij futufutu cɛ ɛtŋ -lʼuw. ");
INSERT INTO adj_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Gbɛkↄ futufutu a ekʼanŋ afr us es a, el futufutu ekʼɛgŋ bʼij ke úwm. ");
INSERT INTO adj_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ɛm, mʼel owr anŋ eci futufutu ekʼanŋ afr us es. Ɛgŋ yecʼeke bʼow ij futufutu ikŋ na a, bʼow ɛŋn sel sɛgŋ fɛŋ. Futufutu a eke mʼam ↄŋ ↄny a, ke ɛm eci sos megl ana; mʼam oc mʼↄŋ ↄny yecʼɛtŋ ke wus nimum ɛ́ŋn sel.» ");
INSERT INTO adj_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ow sosiɛm, Jwifɛl a ɛl ↄfr ɛm am atar ów es lebl tuↄtuↄ ɛm dad ɛsɛ: «Kↄ ayaf ɛgŋ na kʼↄŋn ɛy in eci sos megl a sʼij ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jesu dad ɛl ninɛ: «Low nawrɛ mʼam dad ↄny: eke ijmn ɛgŋ ecʼIy eci sos megl, ɛtŋ ɛgŋmn in eci mebl a, sel ɛŋn kʼow anm ↄny ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɛgŋ yecʼeke bʼow ij ɛm eci sos megl ke bʼow ɛgŋ ɛm eci mebl a ↄny sel ekʼↄnym uwr, ɛtŋ lɛgŋ es abal el ɛm, mʼow mʼigbmʼn luw ɛm; ");
INSERT INTO adj_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","aŋke ɛm eci sos megl a el ob ij tasi, ɛtŋ ɛm eci mebl a el mar tasi eke wɛl bʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɛgŋ yecʼeke bʼij ɛm eci sos megl a, ke bʼɛgŋ ɛm eci mebl a okr af ɛm ab, ɛtŋ ɛm yɛji in yↄny sʼokr af. ");
INSERT INTO adj_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Ɛm Ɛs ekʼɛrmʼm a anŋ owr ɛtŋ in ɛm, ɛm yɛji mʼanŋ owr; ɛbɛn nyam coco, ɛgŋ yecʼeke bʼow ocʼm gbagbal in sosi a, bʼow anŋ owr ɛm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Futufutu a ekʼanŋ afr us es a, in ecʼelel eke nʼanŋn ana. Nʼanm ɛsɛ yecʼa ekʼↄny lagŋɛl ikŋ anym ij ke uw ab af. Gbɛkↄ ɛgŋ eke bʼow ij futufutu na a, bʼow anŋ owr sɛgŋ fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ke Kapɛrnayum eci Nyam nuŋ igŋ usu a eke nʼanŋ nʼam yɛgm agŋ low a anake nʼam dad sodad amua a. ");
INSERT INTO adj_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Eke -lʼirir Jesu ecʼodad a bake ow uwr a, jam ɛsɛl ab ɛm ecʼagŋ nↄnↄ am dad ɛsɛ: «Sica aŋa ow am ɛw low agbr ɛm! Bwo ecʼɛgŋ ↄtu eke kʼɛgŋ odad tuↄtuↄ na e low eb ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Jesu uw any eke jam ɛsɛl a am cacakʼr odad na af. Na sosiɛm anake nʼam dad wɛl lʼɛsɛ: «Kↄ low na gbre ow am ijr ↄny ee? ");
INSERT INTO adj_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Kↄ sica lɛgŋ eke bʼow ɛkan ɛgŋ ecʼIy uyu im yogŋ a eke lʼikŋ anym nʼanŋ lʼow a, ke ayaf ow bʼow kokr ↄny ab ee? ");
INSERT INTO adj_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Nyam ecʼAbŋ a anake bʼↄŋ ɛgŋ sel a; sos megl sↄny ↄnym low kaka ecʼabusu. Sodad a eke mi dad ↄny a el abŋ lele sel ab. ");
INSERT INTO adj_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Gbɛkↄ ↄny ɛm ecʼagŋ nyam nyam ubm nawrɛ.» (Ke tasi ɛm a, nuŋ ↄb ɛm ɛtŋ, Jesu uw agŋ a ekʼubm nawrɛ ab any, ɛtŋ lʼuw ɛgŋ a eke bʼow ↄl ijʼr ab any.) ");
INSERT INTO adj_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Lʼigŋ af li dad ninɛ: «Na sosiɛm anake mi dad ↄny, eke ɛgŋ kaka kʼↄtum owm ɛm ogŋ eke Nyam ↄↄmʼn ow ecʼabusu.» ");
INSERT INTO adj_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Ow eci wanci ab af, jam ɛsɛl nↄnↄ ocr sos es ɛtŋ ɛgŋm usmʼn jam ij. ");
INSERT INTO adj_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesu am dad jam ɛsɛl lɛw yony a ɛsɛ: «Ɔny yɛji erurir eke kʼimn ee?» ");
INSERT INTO adj_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simↄ Piɛr dadʼr ninɛ: «Ɛgŋ gbɛl, kↄ bwo ecʼɛgŋ ogŋ si kʼim ee? Ŋ ↄny sodad eke bʼↄŋ ɛgŋ sel ekʼↄnym uwr a. ");
INSERT INTO adj_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Sʼuw any ɛtŋ sʼub nawrɛ: ŋ el Ɛgŋ Lala eke Nyam ɛrm ow.» ");
INSERT INTO adj_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jesu dad ɛl ninɛ: «Kↄ ow elm ↄny lɛw yony mum mi sↄsuam mʼotm ↄny ee? Gbɛkↄ ↄny ɛm ecʼɛgŋ nyam el agn!» ");
INSERT INTO adj_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ke Judas, Simↄ Iskariↄt iy a ecʼiy ecʼodad Jesu am dad, aŋke Judas, eke lʼel jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ yɛji, li bʼow lʼↄl Jesu lʼij. ");
INSERT INTO adj_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ów amua e jam a, Jesu am ɛc ɛlul Galile ɛm; lʼerurm eke li kʼim Jude aŋke Jwifɛl ecʼes ɛw ɛsɛl a am ↄl eke kʼↄŋ wɛl ibiʼr. ");
INSERT INTO adj_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Jwifɛl eci Mɛf ecʼes gbɛgbl e lɛgŋ ow titm, ");
INSERT INTO adj_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ɛtŋ Jesu lisijimɛl am dadʼr ɛsɛ: «Ìgb im Jude yecʼɛtŋ ke ŋ e jam ɛsɛl a yɛji ɛ́kn ów a eke am kok a. ");
INSERT INTO adj_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ɛgŋ ekʼam erur eke kʼil nin a, ↄ́tum kokm low es lↄl ɛm. Ɛsɛ elel eke am kok ów amua ab af a, ɛ̀lu sos ↄkm yecʼɛtŋ ke agŋ ɛ́knʼŋ.» ");
INSERT INTO adj_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Tasi ɛm a, lisijimɛl bↄbↄ yɛji ↄ́nym ↄmn in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesu dad ɛl ninɛ: «Ɛm ecʼes gbɛgbl ɛm a eke mi kʼim a e lɛgŋ tasi ki bɛbmnm ab. Ɔny ecʼa, sɛgŋ a fɛŋ akpl. ");
INSERT INTO adj_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ɔny, wus ecʼagŋ kʼↄtum ↄnym ↄny e sifn; gbɛkↄ ɛm, -nʼↄny ɛm e sifn aŋke mi bi dad ɛl eci ów eŋuŋ a eke -li bi kok a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ɔny, ìmn es gbɛgbl ab ɛm. Ɛm mi kʼowm yɛ aŋke ɛm ecʼa, ow ki bɛbmnm ab.» ");
INSERT INTO adj_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Eke li dad odad na bake ow uwr a, in gbɛ nʼanŋ Galile. ");
INSERT INTO adj_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Eke lisijimɛl a im es gbɛgbl ab ɛm a, Jesu yɛji im, gbɛkↄ lʼɛlum sos ↄkm ekʼagŋ kʼɛknʼn: ow ɛw es lↄl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Jwifɛl ecʼes ɛw ɛsɛl a am ↄlʼl es gbɛgbl ab ɛm ɛtŋ am ibrm agŋ ɛsɛ: «Kↄ bogŋ nʼanŋ ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Bieku ab ɛm, wɛl am sɛsl ów nↄnↄ in e nuŋ af. Bɛb am dad ɛsɛ: «Lʼel nimamn kok ɛs.» Ɛtŋ likpr am dad ɛsɛ: «Njaŋ, li bʼirmn agŋ.» ");
INSERT INTO adj_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Gbɛkↄ ɛgŋ kaka ɛ́lum sos ↄkm dadm in ecʼodad aŋke ɛl fɛŋ -nʼam uru Jwifɛl ecʼes ɛw ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Es gbɛgbl a ok araŋn, ɛtŋ ca Jesu ow ɛy Nyamel gbɛl a e gbugŋ a ɛtŋ am yɛgm agŋ low. ");
INSERT INTO adj_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Jwifɛl a low iti any ɛtŋ am dad ɛsɛ: «Ɛgŋ na eke wewrm low yɛjʼa, ayaf li bʼↄtu lʼuw ów amua any ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jesu dad ɛl ninɛ: «Low a eke mi bi yɛgm agŋ a ánm ɛm ɛm owm, kↄ Nyam ekʼɛrmʼm a ogŋ ow bʼanŋ ow. ");
INSERT INTO adj_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Eke ɛgŋ am erur eke ki kok Nyam ecʼerur a, li bʼow lʼuw any eke ɛm e low yɛgm a bʼanŋ Nyam ɛm ow, oglog ɛm obi ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɛgŋ eke bi dad in obi e nin ɛm ecʼodad a, bʼↄl in obi ecʼany gbɛl es. Gbɛkↄ ɛgŋ eke am kok juma ↄl ɛgŋ a ekʼɛrmʼn a ecʼany gbɛl es a am dad low nɛnyɛmbri nyam; yadŋ owi kaka anm in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kↄ bla ɛtŋ am ↄↄl eke kʼibirʼm ee? Mois ↄↄm ↄny ol a ee? Gbɛkↄ ↄny ɛm ecʼɛgŋ kaka ánm es ol ab af.» ");
INSERT INTO adj_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Agŋ a dadʼr ninɛ: «Abŋ ŋuŋ anŋʼŋ ɛm tasi, kↄ bwo am ↄl eke kʼibiʼŋ ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jesu dad ɛl ninɛ: «Mɛny ɛwr nyam cɛ mi kok, ɛtŋ kin eke ↄny fɛŋ low a am iti ↄny any! ");
INSERT INTO adj_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Mois ↄŋ abusu eke wɛl kʼubr agŋ likr es, ɛtŋ ɛgŋn ow e kok e low ebr nɛnɛgŋ e lɛgŋ yɛji. (Ke tasi ɛm a, low na anm Mois ɛm owm, kↄ lagŋɛl krɛkrɛ ab ɛm ow anŋ ow.) ");
INSERT INTO adj_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Eke wɛl bʼubr ɛgŋ likr es nɛnɛgŋ e lɛgŋ ɛtŋ ow ↄ́nym Mois ecʼol a ocm es, ke sica bla sosiɛm ɛtŋ am ebal ɛrm okrʼm af, ɛgŋ nimum eke mʼewlm nɛnɛgŋ e lɛgŋ ab ee? ");
INSERT INTO adj_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ɛ̀wr ↄny e sos af e jɛj ok ab es, kↄ jɛ̀jr okr low nɛnyɛmbri nyam ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Agŋ a ekʼir Jerusalɛm a eci bɛb am dad ɛsɛ: «Kↄ ow elm ɛgŋ a eke wɛl am ↄl eke kʼibi ab ana ee? ");
INSERT INTO adj_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Ɛ̀kan, nʼam dad odad dedeku ecʼany af ɛtŋ wɛl ↄbm kpu yɛji ↄↄmʼn! Kↄ ɛy ecʼes ɛwɛl a kʼuw any ɛgŋ eb tasi eke lʼel Mesi ab ee? ");
INSERT INTO adj_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Gbɛkↄ lɛgŋ a eke Mesi a bʼow ow a, ɛgŋ kaka kʼow uwm yogŋ eke li bʼow nʼanŋ lʼow ab any, kↄ ɛgŋ na ecʼa, sʼuw yogŋ eke nʼanŋ lʼow ab any.» ");
INSERT INTO adj_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Jesu ekʼanŋ Nyamel gbɛl a e gbugŋ a am yɛgm agŋ low a, igbl lebl ogŋ dad ninɛ: «Uwr ɛgŋ a tasi eke mʼel ab any, ɛtŋ uwr yogŋ eke mʼanŋ mʼow ab any ee? Ow elm ɛm obi ɛm mʼowm, kↄ ɛgŋ a ekʼɛrmʼm a el nɛnyɛmbri nyam ɛs, kↄ uwmn in any. ");
INSERT INTO adj_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Ɛm, mʼuwʼr any aŋke in ogŋ mʼanŋ mʼow ɛtŋ in lʼɛrmʼm yɛji.» ");
INSERT INTO adj_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ow sosiɛm, -nʼam ↄl eke -li kʼↄny Jesu, kↄ ɛgŋ ↄtum ↄnymʼn, aŋke in e wanci a ki bɛbmnm ab. ");
INSERT INTO adj_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Gbɛkↄ dedeku ab ɛm, agŋ nↄnↄ ubʼr nawrɛ ɛtŋ am dad ɛsɛ: «Lɛgŋ a eke Mesi a bʼow ow a, kↄ li bʼow li kok mɛny ɛwr lʼakm ɛgŋ na ecʼab ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farisiɛl a iri Jesu e lís ecʼów eke bieku ab ɛm wɛl am dad ów sɛsl ɛm. Ow sosiɛm, egb waw ɛsɛl ɛgbɛl a lele Farisiɛl ab ab ɛrm usu ↄsu ɛsɛl eke kʼim ↄnyʼn. ");
INSERT INTO adj_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jesu dad ninɛ: «Ɛmɛny mʼanŋ ↄny ab lɛgŋ tɛl eci gbuŋ ke mʼɛ́wl mʼim ɛgŋ a ekʼɛrmʼm a ogŋ. ");
INSERT INTO adj_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Bʼow ↄↄlʼm ɛtŋ kʼow ɛŋnmnʼm, aŋke kʼow ↄtumn iimn yogŋ a eke mʼow mʼanŋ a.» ");
INSERT INTO adj_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Jwifɛl a am ibrmn ɛl sosi ɛsɛ: «Kↄ bogŋ li bʼow nʼim ɛtŋ si kʼow sʼↄtum sʼɛŋnmʼn ee? Kↄ tutr nʼↄny eke li kʼim Jwifɛl a eke mↄmun es agŋ a ekʼelm Jwifɛl a ogŋ ee? Lʼerur eke li kʼim li yɛgm agŋ ekʼelm Jwifɛl a low ee? ");
INSERT INTO adj_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Sodad amua eke li dad: “Bʼow ↄↄlʼm ɛtŋ kʼow ɛŋnmnʼm, kʼow ↄtumn iimn yogŋ a eke mʼow mʼanŋ a” e nyandrɛ el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Es gbɛgbl a e lɛgŋ es abal el a, el es gbɛgbl a eci lɛgŋ ligbɛl. Ow e lɛgŋ a, Jesu igb inym es ɛtŋ igbl lebl ogŋ dad ninɛ: «Eke ɛgŋ mij amn am ↄny, lʼów ɛm ogŋ ke lʼɛ́gŋ mij. ");
INSERT INTO adj_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Ɛgŋ eke bʼow ubʼm nawrɛ a, mij ewl mij bʼow ewlʼl ɛrm ɛm ok ↄkm ɛsɛ elel eke Nyam Lɛl dad ab af.» ");
INSERT INTO adj_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesu am dad ɛbɛn yɛgm Abŋ Lala a eke agŋ a ekʼↄny ↄmn in ɛm a kʼɛŋn a ecʼodad. Tasi ɛm a, lɛgŋ ab ɛm, wɛl kʼɛ́ŋnm Abŋ Lala aŋke Jesu kʼɛym anygbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Sica eke dedeku ab ɛm ecʼagŋ iri sodad amua a, nyam nyam am dad ɛsɛ: «Ɛgŋ na Kokoba ↄb ɛs a tasi ana!» ");
INSERT INTO adj_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Bɛb am dad ɛsɛ: «Mesi ab ana!» Ɛtŋ likpr am dad ɛsɛ: «Kↄ Mesi a gbɛ ↄtu eke kʼanŋ Galile ow ee? ");
INSERT INTO adj_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kↄ Nyam Lɛl dadm eke Mesi a bʼow el David e bosu ɛm ecʼɛgŋ eke bʼow anŋ Bɛtlehɛm, David e baŋn a ow ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jesu sosiɛm dedeku a ubr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Agŋ nyam nyam erur eke wɛl kʼↄnyʼn, gbɛkↄ ɛgŋ kaka ɛwmʼn abu af. ");
INSERT INTO adj_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Usu ↄsu ɛsɛl a ɛwl mɛny im egb waw ɛsɛl ɛgbɛl a lele Farisiɛl ab ab ogŋ, ɛtŋ wɛl am ibrm ɛl ɛsɛ: «Kↄ bla sosiɛm ɛtŋ ocmn Jesu ab owmn ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Usu ↄsu ɛsɛl a dad ninɛ: «Lɛgŋ kaka ɛgŋ dadm odad ɛsɛ in ecʼab af!» ");
INSERT INTO adj_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Farisiɛl a am ibrm ɛl ɛsɛ: «Ɔny yɛji, yɛbr lʼɛju ↄny ee? ");
INSERT INTO adj_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kↄ es ɛw ɛsɛl ab ɛm ecʼɛgŋ nyam oglog Farisiɛl ɛm ecʼɛgŋ nyam ubʼr nawrɛ ee? ");
INSERT INTO adj_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Dedeku a ekʼubʼr nawrɛ a uwm ol ab any, -lʼel agŋ eke wɛl ofn!» ");
INSERT INTO adj_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Nikodɛm eke lɛgŋ ekʼɛc ab ɛm im ɛkn Jesu a, el Farisiɛl ab ɛm ecʼɛgŋ ekʼanŋ low ab ɛm. Nʼam dad wɛl lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","«Kↄ ɛy ecʼol a bʼↄb ɛgŋ low eke wɛl irimʼn nɛnym oglog wɛl uwm low a eke li kok ab any ee?» ");
INSERT INTO adj_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","-Li dad ow ninɛ: «Ŋ yɛji, kↄ Galile iy el ee? Àpl Nyam e Silɛl ab ɛm bʼow ɛkn eke lɛgŋ kaka kokoba ↄb ɛs ánm Galile owm.»  ");
INSERT INTO adj_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ɛtŋ ɛgŋ ɛgŋ eb ejagb im gbugŋ. ");
INSERT INTO adj_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Kↄ Jesu gbɛ im Olivie lafɛny af. ");
INSERT INTO adj_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Eke lɛgŋ ɛny akr af a, ibribr fafa ɛm a, lʼɛwl mɛny lʼow Nyamel gbɛl a e gbugŋ a ɛtŋ agŋ a fɛŋ ow ɛŋnʼn. Li sig es ɛtŋ nʼam yɛgm wɛl low. ");
INSERT INTO adj_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ol e low yɛgm ɛsɛl lele Farisiɛl ab oc yↄw nyam eke wɛl okr es nfaci ↄkr ɛm a isʼr. -Nʼↄny -nʼinymn ow es dedeku a fɛŋ ecʼany af ");
INSERT INTO adj_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ɛtŋ -li dad Jesu ninɛ: «Low yɛgm agŋ ɛs, wɛl okr yↄw na es nfaci ↄkr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mois dad ɛy ol ab ɛm eke ↄyↄw nɛnɛ a, wɛl kʼↄr ɛl mebn ɛm ibi ɛl. Kↄ ŋ bʼɛsɛ ayaf ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","-Nʼam dad ɛbɛn -lʼuk ow meb yecʼɛtŋ ke -lʼↄtu -lʼok ow ów af. Gbɛkↄ Jesu is any es ɛtŋ am nↄn wus abuli ɛm. ");
INSERT INTO adj_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Eke -nʼam at -lʼibrm ow lʼow a, Jesu igbl sos ogŋ ɛtŋ dad ɛl ninɛ: «Ke ↄny ɛm ecʼɛgŋ nyam eke lɛgŋ kaka kokm sikpl a, íkŋ anym ↄwlʼl lebn krɛkrɛ.» ");
INSERT INTO adj_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Ɛmɛny lʼɛwl lʼis any es ɛtŋ nʼam nↄn wus. ");
INSERT INTO adj_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Eke -lʼirir ów amua a, -nʼim nyam nyam, ow ↄb nuŋ agŋ ɛgbɛl ab ɛm toŋ batŋ Jesu anŋ in sↄny, yↄw a eke inymʼn es any af ab ab. ");
INSERT INTO adj_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Jesu ɛwl igbl sos ogŋ ɛtŋ dadʼr ninɛ: «Sica yↄw, bogŋ agŋ a im ee? Kↄ ɛgŋ kaka dadm ŋ ecʼibi e low ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Li dad ninɛ: «Low yɛgm agŋ ɛs, ɛgŋ kaka dadm ɛm ecʼibi e low.» Jesu dadʼr ninɛ: «Ɛm yɛji mi dadm ŋ ecʼibi owi. Ɔtu eke kʼim, gbɛkↄ jam kì kok sikpl ij.» ");
INSERT INTO adj_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ɛmɛny Jesu am dad dedeku a ɛsɛ: «Mʼel wus nimum ecʼusuayl. Ɛgŋ eke bʼow usʼm jam a, bʼow ɛŋn owr anŋ eci usuayl ɛtŋ lɛgŋ kaka li kʼow nʼanm es ncebn ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Farisiɛl a dadʼr ninɛ: «Ŋ, am ij ŋ obi e daŋku; ŋ e daŋku ij na ↄnym any.» ");
INSERT INTO adj_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jesu dad ɛl ninɛ: «Eke mʼam ij ɛm obi e daŋku yɛji, ɛm e daŋku ij a el nawrɛ, aŋke mʼuw yogŋ eke mʼanŋ mʼow ab any ɛtŋ mʼuw yogŋ eke mʼaam ab any; kↄ ↄny, uwmn yogŋ eke mʼanŋ mʼow ab any, ɛtŋ yogŋ eke mʼaam a yɛji uwmn any. ");
INSERT INTO adj_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ɔny, bi jɛjr okr agŋ ɛm eci; ɛm, mi jɛ́jm ɛgŋ e low mʼokm ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Ɛtŋ eke batŋ mi jɛj low mʼok, ke ɛm e jɛj ok a bʼel nɛny nyam ɛm eci, aŋke mi jɛ́jm mʼokm ɛm sↄny, kↄ ɛm Ɛs eke ɛrmʼm a bʼanŋ ɛm ab. ");
INSERT INTO adj_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ɔny ecʼol ab ɛm wɛl nↄn: ekʼagŋ yony nɛny okr af daŋku ij nyam ɛm, ke daŋku ij ekʼel nawrɛ ana. ");
INSERT INTO adj_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mʼam ij ɛm obi e daŋku ɛtŋ ɛm Ɛs ekʼɛrmʼm a yɛji am ij ɛm e daŋku.» ");
INSERT INTO adj_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","-Nʼam ibrm ow -lʼɛsɛ: «Kↄ bogŋ asŋ a ee?» Jesu dad ɛl ninɛ: «Uwmnʼm any, uwmn ɛm Ɛs yɛjʼany. Blel uwrʼm any, ke blel úwr ɛm Ɛs yɛjʼany.» ");
INSERT INTO adj_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nʼam dad sodad amua Nyamel gbɛl a e gbugŋ a, eke nʼanŋ nʼam yɛgm agŋ low a, yogŋ a eke kↄprↄ ebr mob anŋ a. Ɛtŋ ɛgŋ kaka ɛdŋnmʼn aŋke in e wanci a kʼowm. ");
INSERT INTO adj_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Ɛmɛny Jesu am dad ɛl ɛsɛ: «Mʼow mʼim; bʼow ↄↄlʼm gbɛkↄ bʼow uwr ↄny e sikpl ab ɛm. Kʼↄtumn iimn yogŋ a eke mʼaam a.» ");
INSERT INTO adj_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Jwifɛl a am dadarir ɛl ↄfr ɛsɛ: «Eke nʼam dad lʼɛsɛ ɛs kʼↄtum ɛs iim yogŋ a eke in aam a, kↄ ɛmn nʼam ow nʼim lʼɛdŋn ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jesu dad ɛl ninɛ: «Ɔny wus ecʼagŋ, kↄ ɛm afr mʼanŋ mʼow. Ɔny eel wus na eci, kↄ ɛm mʼelm wus na eci. ");
INSERT INTO adj_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Na sosiɛm anake mi dad ↄny eke bʼow uwr ↄny e sikpl ab ɛm a. Tasi ɛm a, eke ubmn nawrɛ eke “Ɛm, anŋ anŋ” bʼow uwr ↄny e sikpl ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","-Nʼam ibrm ow -lʼɛsɛ: «Ke ŋ bwo el ŋ ee?» Jesu dad ɛl ninɛ: «In a eke mi dad ↄny in e low nuŋ ↄb ɛm ɛtŋ a. ");
INSERT INTO adj_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Ɔny e lís a, mʼↄny ów nↄnↄ eke mi ki dad ke mi jɛ́j mʼok yɛji. Gbɛkↄ ɛgŋ a ekʼɛrmʼm mʼow a el nɛny nyam ɛs, yecʼa eke mi wewr in e lís a, mʼam ↄb ow ecʼamani mʼok ↄny ekʼeel wus ecʼagŋ a.» ");
INSERT INTO adj_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","-Lʼirim eke ow el Ɛs ecʼodad eke nʼam dad wɛl a. ");
INSERT INTO adj_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Ɛtŋ Jesu dad ɛl ninɛ: «Lɛgŋ a eke bʼow igbal ɛgŋ ecʼIy ogŋ a, bʼow uwr any eke “Ɛm, anŋ anŋ”; bʼow uwr any yɛjʼeke mi kókm low kaka ɛm obi ɛm: yecʼa cɛ eke ɛm Ɛs yɛgmʼm a e low cɛ mi bi dad. ");
INSERT INTO adj_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɛgŋ a ekʼɛrmʼm a anŋ ɛm ab; lʼɛ́lum im es ɛm sↄny aŋke sɛgŋ fɛŋ mi bi kok low yecʼa eke li bʼerur a.» ");
INSERT INTO adj_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Eke Jesu am dad ɛbɛn a, agŋ nↄnↄ ubʼr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Jesu am dad Jwifɛl a ekʼubʼr nawrɛ a ɛsɛ: «Eke bʼinymn es ɛm e sodad ab af a, bʼow eel ɛm e jam ɛsɛl tasi; ");
INSERT INTO adj_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","af yogŋ bʼow uwr low nɛnyɛmbri nyam any ɛtŋ low nɛnyɛmbri nyam a bʼow ↄŋ ↄny eel ewi.» ");
INSERT INTO adj_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","-Lʼↄdu -lʼeb -li dad ow ninɛ: «Ɛy, Abraham ecʼalaw; lɛgŋ kaka sʼelm ɛgŋ kaka e madu. Ayaf ↄtu eke ki dad ɛy ɛsɛ si bʼow sʼel ewi ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jesu dad ɛl ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: ɛgŋ fɛŋ ekʼam kok sikpl a, el sikpl ecʼadu. ");
INSERT INTO adj_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Adu élm akŋ a ecʼɛgŋ sɛgŋ fɛŋ eci; kↄ iy ecʼa, sɛgŋ a fɛŋ li bʼel akŋ a ecʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Eke Iy a bi sↄg ↄny, bʼow eel ewi tasi. ");
INSERT INTO adj_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mʼuw any eke eel Abraham ecʼalaw; gbɛkↄ am ↄↄl eke kʼibirʼm, aŋke ɛm e sodad a anm ↄny ɛrm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ɛm, mʼam dad low yecʼa eke mʼɛkn ɛm Ɛs ogŋ a, kↄ ↄny, am kokr low yecʼa eke ↄny ɛs dad ↄny a.» ");
INSERT INTO adj_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","-Lʼeb ow odad nɛnym ninɛ: «Ɛy ɛs a, Abraham.» Jesu dad ɛl ninɛ: «Blel eel Abraham ecʼey tasi ana, ke blel kókr ów eke li kok a. ");
INSERT INTO adj_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Mi dad ↄny low nawrɛ a eke mʼuw any Nyam e lís a, ɛtŋ am ↄↄl eke kʼibirʼm. Lɛgŋ kaka Abraham kokm low nɛnɛ! ");
INSERT INTO adj_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɔny, bi kokr ów nyam a cɛ ɛsɛ ↄny ɛs af.» -Lʼↄdu -lʼeb li dad ow ninɛ: «Ɛy sʼelm egŋ ot iy. Sʼↄny ɛy ɛs nyam coco, in lʼel Nyam.» ");
INSERT INTO adj_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jesu dad ɛl ninɛ: «Blel Nyam el ↄny ɛs ana, ke blel érurirʼm, aŋke Nyam ogŋ mʼanŋ mʼow, ɛtŋ mʼanŋ aŋa in e nin ɛm. Ow elm ɛm obi ɛm mʼowm, kↄ in lʼɛrmʼm. ");
INSERT INTO adj_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Bla sosiɛm ɛtŋ ↄ́tumn irimn odad a eke mi bi dad ab ee? Aŋke ijmn ɛm e sodad a ecʼiri e lɛc. ");
INSERT INTO adj_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ɔny ɛs a el agn, ɛtŋ bʼerurir eke ki kokr low yecʼa eke ↄny ɛs bʼerur a. Nuŋ ↄb ɛm ɛtŋ lʼel ɛgŋ ibiu. Lɛgŋ kaka nʼanm low nɛnyɛmbri nyam owi ɛm, aŋke low nɛnyɛmbri nyam anm in ɛm. Eke li bʼↄny yadŋ, ke in ecʼelel eke nʼanŋn ke ɛcmʼn ab a ana, aŋke lʼel yadŋu ɛtŋ lʼel yadŋ ecʼɛs. ");
INSERT INTO adj_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Gbɛkↄ ɛm ecʼa, low nawrɛ eke mi bi dad a sosiɛm anake úbmnʼm nawrɛ a. ");
INSERT INTO adj_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Ɔny ɛm aŋa, bwo ecʼɛgŋ ↄtu eke ki dad ɛlu ↄkm eke mi kok sikpl ee? Ɛtŋ sica eke mʼam dad ↄny low nɛnyɛmbri nyam, bla sosiɛm ɛtŋ úbmnʼm nawrɛ ee? ");
INSERT INTO adj_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ɛgŋ ekʼel Nyam ecʼa, bʼiri Nyam e sodad a. Gbɛkↄ ↄny, elmn Nyam eci, na sosiɛm anake írimn a.» ");
INSERT INTO adj_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Jwifɛl a dadʼr ninɛ: «Sʼam dad eke ŋ Samari iy ɛtŋ ↄny abŋ ŋuŋ yɛji. Kↄ yadŋ sʼↄny ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jesu dad ninɛ: «Mʼↄnym abŋ ŋuŋ, kↄ ɛm Ɛs mi bʼɛlum ɛtŋ ↄny, ɛ́gŋmn eke kʼɛlumnʼm. ");
INSERT INTO adj_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mʼↄlm ɛm obi ecʼanygbɛl es; ɛgŋ anŋ ekʼam kok ow e low ke am jɛj ok. ");
INSERT INTO adj_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Ɛɛ, low nawrɛ mʼam dad ↄny: ɛgŋ eke bʼɛlum ɛm e sodad a, lɛgŋ kaka li kʼow lʼuwm.» ");
INSERT INTO adj_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Jwifɛl a dadʼr ninɛ: «Sica sʼuw any eke ↄny abŋ ŋuŋ tasi! Abraham uw, kokoba ↄb ɛsɛl a yɛji uw, ɛtŋ ŋ, am dad ɛsɛ: “Ɛgŋ eke bʼɛlum ɛm e sodad a, lɛgŋ kaka li kʼow lʼuwm.” ");
INSERT INTO adj_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ɛy ɛs Abraham uw. Kↄ am tutr eke ↄny any akmʼn ee? Kokoba ↄb ɛsɛl a yɛji uw. Kↄ ayaf bʼocr ŋ sosi ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jesu dad ninɛ: «Blel mʼam ↄŋn ɛm sosi any ana, ke blel ow elm low kaka. Ɛgŋ a eke am ↄŋʼm any a, ɛm Ɛs. In e lís e low eke bi dadr a el: “Lʼel ɛy e Nyam”, ");
INSERT INTO adj_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ke uwmn in any. Kↄ ɛm, mʼuwʼr any. Blel mi dad eke mʼuwmʼn any, blel mʼél yadŋu ɛsɛ ↄny af. Gbɛkↄ mʼuwʼr any ɛtŋ mi bʼɛlum in e sodad a. ");
INSERT INTO adj_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ɔny ɛs Abraham in e tutr ɛm ɛlu sos ɛm iŋn ↄkm ɛm e mowrer a ecʼɛkn eci; lʼɛkn ɛtŋ nʼↄny sos ɛm iŋn.» ");
INSERT INTO adj_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ow ↄŋ Jwifɛl a dadʼr ninɛ: «Kↄ ŋ, kʼↄnym akpo ekŋ yony lele lɛw ab yɛji ke kpɛkŋ ɛ́kn Abraham ee?» ");
INSERT INTO adj_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jesu dad ɛl ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: gbuŋ ke wɛl éw Abraham a, “Ɛm, anŋ anŋ.” » ");
INSERT INTO adj_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ow sosiɛm -lʼot mebn eke -li kʼↄↄr ow. Gbɛkↄ Jesu ɛy ↄkm Nyamel gbɛl a e gbugŋ a es lↄl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Eke Jesu am ɛc a, lʼɛkn ɛgŋ nyam ekʼany efl mew ɛm ɛtŋ. ");
INSERT INTO adj_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","In e jam ɛsɛl a am ibrmʼn ɛsɛ: «Low yɛgm agŋ ɛs, bla sosiɛm ɛtŋ ɛgŋ na any efl in e mew ɛm ɛtŋ ee? Kↄ in obi ɛm e sikpl, oglog ɛs lele lis ab e sikpl sosiɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jesu dad ninɛ: «Ow elm in obi ɛm e sikpl, oglog ɛs lele lis ab e sikpl sosiɛm. Kↄ any eflʼl yecʼɛtŋ ke Nyam e juma kok a e low ɛ́y ↄkm in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Eke lɛgŋ anŋ owr a, ow akpl eke si ki kokr ɛgŋ a ekʼɛrmʼm a e juma. Lɛgŋ uk am ow, ekʼɛgŋ kʼow ↄtum kokm juma. ");
INSERT INTO adj_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Eke mʼanŋ wus af aŋa a, mʼow mʼel wus na ecʼusuayl.» ");
INSERT INTO adj_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Eke li dad sodad amua bake uwr a, lʼifi sar lʼok wus ɛtŋ li kok kↄdↄg sar ab ab, lʼoc lʼudu any eflu a ecʼanyamn a, ");
INSERT INTO adj_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ɛtŋ li dad ninɛ: «Ìm yↄg any Silowe e mij ab ɛm.» (Silowe e nyandrɛ el “ɛrmu”.) Any eflu a im yↄg any, ɛtŋ eke lʼɛwl lʼow a, nʼam ɛkn es! ");
INSERT INTO adj_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","In e saw saw ecʼagŋ lele agŋ ɛjecʼeke lɛgŋ sig ɛm ɛknʼn nʼam sasm ob a am ibrm ɛsɛ: «We! Kↄ ow elm ɛgŋ a eke bi sig es am sasm ob ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Agŋ nyam nyam am dad eke ow in ana. Bɛb am dad ɛsɛ: Njaŋ, owʼn elm ow, kↄ es cɛ owʼn bʼot ow. Ɛtŋ ɛgŋ a dad ninɛ: «Tasi, ɛm ana.» ");
INSERT INTO adj_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","-Nʼam ibrm ow -lʼɛsɛ: «Kↄ ayaf kokr ɛtŋ ŋ ecʼanyamn a ayl ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Li dad ninɛ: «Ɛgŋ a eke wɛl bʼɛsŋ Jesu a kok kↄdↄg uduʼm anyamn ɛtŋ li dadʼm eke mi kʼim Silowe e mij ab ɛm mi yↄg any. Mʼim yogŋ, ɛtŋ eke mi yↄg any uwr a, mʼam ɛkn es.» ");
INSERT INTO adj_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","-Lʼibrm ow ninɛ: «Ɛgŋ a, bogŋ in a!» Li dad ninɛ: «Mʼɛknmʼn.» ");
INSERT INTO adj_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Sica wɛl ɛwl ɛgŋ a eke wɛl ewlm a Farisiɛl ogŋ. ");
INSERT INTO adj_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ke nɛnɛgŋ e lɛgŋ anake Jesu oc kↄdↄg kok ewlmʼn anyamn a. ");
INSERT INTO adj_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Na sosiɛm Farisiɛl a yɛji am ibrm ɛgŋ a ɛsɛ: «Kↄ ayaf kokr ɛtŋ am ɛkn es ee?» Li dad ninɛ: «Lʼuduʼm kↄdↄg tɛl anyamn, mi yↄg any ɛtŋ mʼam ɛkn es.» ");
INSERT INTO adj_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Farisiɛl bɛb am dad ɛsɛ: «Ɛgŋ ikŋ na eke kok low na a kʼↄtum anm Nyam ogŋ owm, aŋke lʼɛluam nɛnɛgŋ e ecʼol a.» Gbɛkↄ agŋ likpr a ↄdu eb ɛtŋ am dad ɛsɛ: «Kↄ ayaf sikpl ɛs nyam ↄtu eke ki kok mɛny ɛwr amua ee?» Ɛtŋ ɛl ↄfr a -li bubr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ɛmɛny Farisiɛl a am ibrm any eflu a ekʼewl a ɛsɛ: «Ɛtŋ kↄ ŋ eke lʼewlmʼŋ anyamn a, ayaf am dadr ee?» Li dad ninɛ: «Lʼel kokoba ↄb ɛs.» ");
INSERT INTO adj_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","19","Jwifɛl ecʼes ɛwɛl a kʼubm nawrɛ eke li kʼel any eflu ke sica lʼéwl nʼam ɛkn es. Ow sosiɛm -lʼɛsŋ ɛs lele lis ab low ibrm eci, ɛtŋ -nʼam ibrm wɛl -lʼɛsɛ: «Kↄ iy na ↄny ecʼiy ee? Am ɛgŋn ebr eke lʼel any eflu mew ɛm ɛtŋ ee? Ayaf ɛtŋ sica nʼam ɛkn es ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","In ecʼagŋ a dad ninɛ: «Sʼuw any cɛ eke lʼel ɛy jim ɛtŋ wɛl ewʼr any eflu. ");
INSERT INTO adj_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Gbɛkↄ elel eke ow ɛcr ke sica nʼam ɛkn es a sʼuwm any, ɛtŋ ɛgŋ a eke kʼewlmʼn anyamn a yɛji sʼuwmʼn any. Any atʼr es, ìbrmn in, in obi lʼↄtu eke li ki dad!» ");
INSERT INTO adj_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","-Nʼam dad ɛbɛn aŋke -nʼam uru Jwifɛl ecʼes ɛwɛl a. Tasi ɛm a, Jwifɛl ecʼes ɛwɛl a ikŋ anym iririr eke ɛgŋ fɛŋ eke bʼow ɛgŋ eb eke Jesu el Mesi a, -lʼogŋ ow ɛl e Nyam nuŋ igŋ usu a. ");
INSERT INTO adj_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Low na sosiɛm anake iy ɛs a lele iy lis ab ab dad ninɛ: «Any atʼr es, ìbrmn in, in obi lʼↄtu eke li ki dad a.» ");
INSERT INTO adj_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ɛmɛny Farisiɛl ɛsŋ ɛgŋ a eke wɛl ewlm a sakp yony ɛm ɛtŋ am dadʼr ɛsɛ: «Ɛy sʼuw any eke ɛgŋ na sikpl ɛs! Dàd low nɛnyɛmbri nyam Nyam ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Li dad ninɛ: «Ke lʼél sikpl ɛs oglog li kʼelm sikpl ɛs yɛji, mʼuwm any. Gbɛkↄ low nyam cɛ mʼuw any: mʼel any eflu, ɛtŋ sica mʼam ɛkn es.» ");
INSERT INTO adj_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","-Nʼam ibrm ow -lʼɛsɛ: «Kↄ ayaf li kokrʼŋ ee? Ayaf lʼewlmʼŋ anyamn ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Li dad ninɛ: «Mʼikŋ anym mi dad ɛtŋ erurmn eke kʼirir. Kↄ bla ɛtŋ am erurir eke ɛmɛny mi ki dadr ɛm ee? Kↄ ↄny yɛji in e jam ɛsɛl am erurir eke kʼeel ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","-Nʼam wɛwr ow -li dad -lʼɛsɛ: «Ŋ el ɛgŋ nɛnɛ na e jam us ɛs! Ɛy Mois e jam us ɛsɛl sʼel. ");
INSERT INTO adj_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Mois ecʼa Nyam dadʼr odad; kↄ ɛgŋ ikŋ na ecʼa, yogŋ eke nʼanŋ lʼow bↄbↄ yɛji sʼuwm any!» ");
INSERT INTO adj_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɛgŋ a eke wɛl ewlm a dad ɛl ninɛ: «Kin low ekʼɛw any iti owi: uwmn yogŋ eke nʼanŋ lʼow ab any, gbɛkↄ lʼewlm im! ");
INSERT INTO adj_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Sʼuw any eke Nyam írim sikpl ɛsɛl e lebl; gbɛkↄ ɛgŋ fɛŋ eke bʼɛlum Nyam ke bi kok in ecʼerur a, Nyam bʼiriʼr lebl. ");
INSERT INTO adj_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Lɛgŋ kaka wɛl dadm ɛy sʼirim eke ɛgŋ nyam ewlm ɛgŋ eke mew ɛm ɛtŋ el any eflu. ");
INSERT INTO adj_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Blel ɛgŋ na anm Nyam ogŋ owm, blel lʼↄtum li kokm low kaka.» ");
INSERT INTO adj_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","-Lʼↄdu -lʼeb -li dad ow ninɛ: «Ŋ e mew ɛm ɛtŋ, ŋ nimum a anŋ sikpl ɛm ɛtŋ am erur eke ki yɛgm ɛy low ee?» Ɛtŋ -lʼogŋ ow Nyam nuŋ igŋ usu a. ");
INSERT INTO adj_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Eke Jesu iri eke wɛl ogŋ any eflu a, nʼim nʼɛŋn ow ɛtŋ li dad ow ninɛ: «Kↄ ↄny ↄmn ɛgŋ ecʼIy ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɛgŋ a dadʼr ninɛ: «Ɛgŋ gbɛl, dàdʼm ɛgŋ a yecʼɛtŋ ke mʼↄ́ny ↄmn in ɛm ↄ!» ");
INSERT INTO adj_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jesu dadʼr ninɛ: «Aah! Am ɛknʼn; caca ɛm a, in anake nʼam dadʼŋ odad a!» ");
INSERT INTO adj_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ɛgŋ a dadʼr ninɛ: «Ɛgŋ gbɛl, mʼↄny ↄmn.» Ɛtŋ lʼok ↄwrↄkp wus Jesu ecʼany af. ");
INSERT INTO adj_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ɛtŋ Jesu dad ninɛ: «Mʼow wus af aŋa jɛj ok eci: ke ány eflu ɛ́kn es, ke agŋ ekʼam ɛkn es a any éfl.» ");
INSERT INTO adj_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farisiɛl bɛb a eke anŋ in ab a iri sodad amua, ɛtŋ am ibrmʼn ɛsɛ: «Kↄ ɛy yɛji ány eflu si kʼel ee?» ");
INSERT INTO adj_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jesu dad ɛl ninɛ: «Blel eel ány eflu, blel elmn sikpl ɛsɛl; gbɛkↄ eke am dadr eke am ɛkan es a, eel sikpl ɛsɛl.» ");
INSERT INTO adj_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesu dad ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: ɛgŋ eke ɛ́crm lisany a eci ɛym mɛcɛb lakp ab ɛm, ke bʼuyu usu ɛjeci ɛy ɛm a, ɛgŋ a ulu, ów gaŋgaŋ ɛs. ");
INSERT INTO adj_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Gbɛkↄ ɛgŋ eke bʼɛcr lisany a ecʼa, el mɛcɛb a ecʼↄsu ɛs. ");
INSERT INTO adj_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ɛgŋ a, usu ↄsu ɛs a bi figʼr lisany ɛtŋ mɛcɛb a bʼiriʼr lebl. Li bʼɛsŋ in e mɛcɛb a ecʼen nyam nyam ɛm, ɛtŋ li bʼok wɛl ↄkm. ");
INSERT INTO adj_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Eke li bʼok wɛl ↄkm fɛŋ a, li bʼikŋ wɛl anym ke wɛl ám usʼr jam, aŋke mɛcɛb a uwʼr lebl any. ");
INSERT INTO adj_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Gbɛkↄ ɛgŋ eke -lʼuwm any a, -lʼusmn ow jam. Eke -lʼɛkn ow, -li bʼuru -nʼↄmu es aŋke -lʼuwm ow lebl any.» ");
INSERT INTO adj_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesu oc nyandrɛ ɛm odad na am dad ɛl, kↄ low yecʼa eke nʼam erur eke li kʼɛlu ↄkm a kʼokm agŋ a es sos ɛm. ");
INSERT INTO adj_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ɛmɛny Jesu dad ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: mʼel mɛcɛb lakp a e lisany. ");
INSERT INTO adj_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Agŋ a fɛŋ eke ikŋ anym ow a, elu, ów gaŋgaŋ ɛsɛl; kↄ mɛcɛb a ɛgŋm irim ɛl ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ɛm, mʼel lisany. Ɛgŋ eke bʼow ɛcr ɛm ɛm ɛy ɛm a, bʼow ɛŋn sel; lʼↄtu eke li kʼɛy ɛm lʼɛy ↄkm ɛtŋ li bʼow nʼɛŋn in ecʼob ij. ");
INSERT INTO adj_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ulu ecʼa, li bʼow cɛ eke li kʼiy, lʼibi ke ni ŋúŋn. Ɛm, mʼow eke agŋ kʼɛŋn sel, ke -nʼɛŋn sel a nↄnↄ ɛm. ");
INSERT INTO adj_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Ɛm, mʼel mɛcɛb ↄsu ɛs mamn. Mɛcɛb ↄsu ɛs mamn bʼoc in e sel a ↄŋ in e mɛcɛb a. ");
INSERT INTO adj_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ɛgŋ ekʼam kok juma ke ow el os sosiɛm cɛ ecʼa, elm mɛcɛb ↄsu ɛs tasi; mɛcɛb a elm in eci. Eke li bʼɛkn botimbo ekʼam ow a, li bʼigŋ lʼok wɛl es, ke lʼúru es nʼim. Ke sica botimbo a ↄ́ny mɛcɛb a bɛb ke ↄ́mun ɛl es. ");
INSERT INTO adj_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ɛgŋ a ekʼam kok juma ke ow el os sosiɛm cɛ ecʼa, ɛbɛn eke ow bʼɛcr ana. Lʼútrm mɛcɛb a e low. ");
INSERT INTO adj_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Ɛm, mʼel mɛcɛb ↄsu ɛs mamn a. Ɛsɛ elel eke ɛm Ɛs uwʼm any ke ɛm yɛji mʼuwʼr any ab af a, ɛbɛn nyam coco mʼuw ɛm e mɛcɛb ab any, ɛtŋ ɛl yɛji -lʼuwʼm any. Ɛm e sel a mʼɛgŋ mʼeb eke mi kʼoc mʼↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ɛmɛny mʼↄny mɛcɛb ɛjeci eke anm lakp na ɛm. Ɛl yɛji ow it ke mi nyímn ɛl; -li bʼow -lʼiriʼm lebl ɛtŋ -li bʼow -lʼel mɛbob nyam eke bʼow ↄny ↄsu ɛs nyam coco. ");
INSERT INTO adj_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Ɛm Ɛs bʼerurʼm aŋke mʼɛgŋ mʼeb eke mi kʼoc ɛm e sel a mʼↄŋ ɛl, ke ɛmɛny mʼɛ́wl mʼoc. ");
INSERT INTO adj_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɛgŋ kaka ébm im sel a abu ɛm, kↄ ɛm obi mi bʼoc sel a mʼↄŋ ɛl; mʼↄny abusu eke mi kʼoc sel a mʼↄŋ ɛl, ɛtŋ ɛmɛny mʼↄny abusu eke mi kʼeb. Ɛm Ɛs ecʼol a eke ↄŋʼm ab ana.» ");
INSERT INTO adj_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Sodad amua sosiɛm, ɛmɛny Jwifɛl a ubr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Ɛl ɛm ecʼagŋ nↄnↄ am dad ɛsɛ: «Nʼↄny abŋ ŋuŋ! Nuŋ ɛm uŋʼn! Kↄ bla ɛtŋ am irir in ecʼodad ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Bɛb am dad ɛsɛ: «Ɛgŋ eke ↄny abŋ ŋuŋ a kʼↄtum dadm odad nɛnɛ. Abŋ ŋuŋ ɛs ↄtu eke kʼewlm ány eflu ee?» ");
INSERT INTO adj_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Sica Nyamel gbɛl a e fig ecʼes gbɛgbl ɛy Jerusalɛm ɛtŋ ow el lɛfr lɛgŋ iy. ");
INSERT INTO adj_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesu am nyinymn es Nyamel gbugŋ a, lɛf eb usu a eke ij Salomↄ e nin a. ");
INSERT INTO adj_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Jwifɛl a iwr did ɛlul il ɛm ɛtŋ am ibrmʼn ɛsɛ: «Kↄ bʼow ↄny ɛy es bɛbar na ɛm cɛ ee? Dàd ɛy nɛnyɛmbri nyam eke ow el ŋ el Mesi a.» ");
INSERT INTO adj_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jesu dad ɛl ninɛ: «Mʼikŋ anym mi dad ↄny, kↄ ubmnʼm nawrɛ. Ów a eke mʼam kok ɛm Ɛs e nin ɛm a am ij ɛm e daŋku. ");
INSERT INTO adj_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ɛtŋ ↄny, úbmn nawrɛ aŋke elmn mɛcɛb a ekʼel ɛm ecʼa. ");
INSERT INTO adj_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ɛm e mɛcɛb a bʼiriʼm lebl, mʼuw ɛl any ɛtŋ -li bʼusʼm jam. ");
INSERT INTO adj_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mi bʼↄŋ ɛl sel eke ↄnym uwr; lɛgŋ kaka -li kʼow -lʼuwmn ɛtŋ lɛgŋ kaka ɛgŋ kʼↄtum dↄgrm ebm ɛl ɛm ecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ɛm Ɛs a eke ot ɛl ↄŋʼm a, lʼagb lʼakm ob ob fɛŋ, ɛtŋ ɛgŋ kaka ↄnym abusu eke ki dↄgr ob eke anŋ ɛm Ɛs abu ɛm a eb. ");
INSERT INTO adj_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ɛm lele ɛm Ɛs ab a, sʼel nyam coco.» ");
INSERT INTO adj_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ɛmɛny Jwifɛl a ot mebn as luku eke ki wↄwlʼl. ");
INSERT INTO adj_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Kↄ Jesu dad ɛl ninɛ: «Ɛm Ɛs ɛm, mi kok ów amamn nↄnↄ mi yɛgm ↄny. Ów amua, bogŋ ecʼanake ow af am ↄↄl eke kʼibirʼm mebn ɛm ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jwifɛl a dadʼr ninɛ: «Ow elm ke bi kok low nimamn ke sʼíbiʼŋ mebn ɛm, kↄ Nyam eke am wɛwr a sosiɛm. Ɛgŋ cɛ elʼŋ, ɛtŋ am ocr ŋ sosi Nyam!» ");
INSERT INTO adj_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jesu dad ninɛ: «Nyam dad wɛl nↄn ↄny ecʼol ab ɛm ninɛ: Ɔny eel “sinyam”. ");
INSERT INTO adj_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Agŋ a eke Nyam odad a ot es a, Nyam ɛsŋ ɛl “sinyam”. Ke sʼuw any eke Nyam Lɛl ecʼodad eke dad a, wɛl kʼↄtum ↄnym ocm es. ");
INSERT INTO adj_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ɛtŋ ɛm, ɛm Ɛs usmʼm abu es ɛtŋ ɛrmʼm wus na af; ayaf ↄtur eke ki dadr ɛsrɛ mʼam wɛwr Nyam aŋke mi dad eke mʼel Nyam ecʼIy ee? ");
INSERT INTO adj_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Eke mi kokm ɛm Ɛs ecʼów a, kʼùbrʼm nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Gbɛkↄ eke mi bi kok a, eke ubmn ɛm e sodad a nawrɛ yɛji, ùbr ów amua nawrɛ yecʼɛtŋ ke ow ók ↄny es sos ɛm kpɛkŋ kpɛkŋ eke ɛm Ɛs ir ɛm ɛm ɛtŋ ɛm yɛji mʼanŋ ɛm Ɛs ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","-Nʼam ↄl ekʼɛmɛny -li kʼɛw ow abu af, kↄ lʼakm wɛl. ");
INSERT INTO adj_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ɛmɛny Jesu ɛwl im mij ewl mij a ekʼel Jurdɛn a e jam a, yogŋ a eke Jan ikŋ anym ok agŋ mij nuŋ a, ɛtŋ nʼanŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Agŋ nↄnↄ am ow in ogŋ ɛtŋ -nʼam dad -lʼɛsɛ: «Jan kokm mɛny ɛwr kaka, gbɛkↄ ɛgŋ a e low a eke li dad a el nawrɛ.» ");
INSERT INTO adj_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ɛtŋ sica agŋ nↄnↄ ubʼr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Ɛgŋ nyam eke wɛl bʼɛsŋ Lasar ↄny lisijↄwɛl yony, Mart lele Mari ab; -lʼir Betani baŋn. Mari a, ke yↄw a eke ok Ɛs Kↄtↄkↄ mijey akr ke oc in e sin nuŋ tɛtŋ es ab ana. Lisijim Lasar ɛy ↄl tuↄtuↄ. ");
INSERT INTO adj_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Agŋ lisijↄwɛl yony a ɛrm ɛgŋ eke kʼim dad Jesu eke in ecʼɛgŋ a eke li bʼerur a ↄl am ↄny. ");
INSERT INTO adj_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Eke Jesu iri amani na a, li dad ninɛ: «Ɔl ikŋ na kʼow ibimʼn, ow el Nyam ecʼanygbɛl a eci, yecʼɛtŋ ke Nyam ecʼIy ecʼanygbɛl a ɛ́y ↄkm.» ");
INSERT INTO adj_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ke Jesu bʼerur Mart, ow lisijↄw lele Lasar ab sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Ow sosiɛm Lasar ecʼↄl owi a eke lʼiri a, nʼanŋ usu a eke nʼanŋ a li kok sɛgŋ yony lʼok af. ");
INSERT INTO adj_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ɛtŋ ca li dad in e jam ɛsɛl a ninɛ: «Sʼɛ́wal sʼimn Jude.» ");
INSERT INTO adj_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Jam ɛsɛl a dadʼr ninɛ: «Low yɛgm agŋ ɛs, yogŋ anake wɛl ↄl eke kʼibiʼŋ mebn ɛm a, ↄrↄfn kʼɛtum es yɛji ɛtŋ ɛmɛny am erur eke kʼɛwl im ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jesu dad ɛl ninɛ: «Lɛgŋ mum ɛm a wanci lɛw yony bʼanŋ, kↄ yadŋ ee? Eke lɛgŋ owr ɛgŋ am an es, lʼuyuam ob ab aŋke nʼam ɛkn wus na ecʼusuayl a. ");
INSERT INTO adj_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Kↄ eke ɛgŋ am an es ncok ɛm, li bʼuyum ob ab aŋke usuayl anm in ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Eke li dad ów amua bake ow uwr a, lʼigŋ af li dad ninɛ: «Ɛy lawl a mɛmn nʼam ɛru, kↄ mʼow mʼim mʼuwrʼr.» ");
INSERT INTO adj_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Jam ɛsɛl a dad ninɛ: «Ɛgŋ gbɛl, eke ow el mɛmn nʼam ɛru tasi, li bʼow lʼewl.» ");
INSERT INTO adj_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Tasi ɛm a, Lasar e luw a ecʼodad anake Jesu am dad a, ɛtŋ jam ɛsɛl a e tutr ɛm a, ow el mɛmn cɛ. ");
INSERT INTO adj_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ow ↄŋ Jesu dad ulm ɛl es ninɛ: «Lasar uw. ");
INSERT INTO adj_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Eke mʼiim yogŋ a, sos ɛm am iŋnʼm ↄny eci yecʼɛtŋ ke úbrʼm nawrɛ. Gbɛkↄ ɛy fɛŋ sʼímn in ogŋ a.» ");
INSERT INTO adj_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ɛtŋ Toma, eke wɛl igŋ nin af Oli a, dad jam ɛsɛl ɛjecʼa ninɛ: «Ɛy yɛji, sʼímn yogŋ ke sʼúwr in ab.» ");
INSERT INTO adj_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Eke Jesu im ok yogŋ a, lʼiri eke Lasar anŋ uwↄmu ɛm ij sɛgŋ yar. ");
INSERT INTO adj_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Eke Betani titm Jerusalɛm ke ow ijm kilo nyahan yɛjʼa, ");
INSERT INTO adj_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Jwifɛl nↄnↄ ow Mart lele Mari ab ogŋ eke kʼatr ɛl sos es ɛl lisijim e luw na sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Eke Mart iri eke Jesu am ow a, nʼim ow ecʼↄbr ɛm, kↄ Mari gbɛ sig es gbugŋ. ");
INSERT INTO adj_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mart dad Jesu ninɛ: «Ɛgŋ gbɛl, blel anŋ aŋa, ɛm lisijim blel uwm. ");
INSERT INTO adj_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Gbɛkↄ mʼuw any, eke caca ɛm yɛji, low fɛŋ eke bʼow ibrm Nyam a, li bʼow nʼↄŋʼŋ.» ");
INSERT INTO adj_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jesu dadʼr ninɛ: «Esŋ jim bʼow igb luw ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Mart dad ninɛ: «Mʼuw any eke lɛgŋ es abal el ɛm a eke agŋ ekʼuw a bʼow igb luw ɛm a, in yɛji li bʼow lʼigb.» ");
INSERT INTO adj_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jesu dadʼr ninɛ: «Mʼel luw ɛm anŋ igb lele sel ab. Ɛgŋ ekʼↄny ↄmn ɛm ɛm a, eke lʼuw yɛji, li bʼow nʼanŋ owr abŋ ɛm; ");
INSERT INTO adj_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ɛtŋ ɛgŋ ekʼanŋ owr ke ↄny ↄmn ɛm ɛm a, li kʼow lʼuwm lɛgŋ kaka. Kↄ ↄny ↄmn low na ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Li dad ninɛ: «Ɛgŋ gbɛl, mʼub nawrɛ eke el Mesi a, Nyam ecʼIy eke kʼow wus na af a.» ");
INSERT INTO adj_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Eke lʼɛw nɛny es a, nʼim lʼɛsŋ lisijↄw Mari ɛtŋ nʼam dad ow lebl es is ɛm lʼɛsɛ: «Low yɛgm agŋ ɛs a ow anŋ aŋa, ɛtŋ nʼam ɛsŋʼŋ.» ");
INSERT INTO adj_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Eke Mari bʼiri sodad amua a, kpɛkŋ lʼigb es ogŋ ɛm nʼim nʼɛŋn Jesu. ");
INSERT INTO adj_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ke Jesu kʼɛym baŋn a yɛji, kↄ nʼanŋ usu a cɛ eke Mart ↄbrʼr a. ");
INSERT INTO adj_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Eke Jwifɛl a anŋ akŋ am atr Mari sos es, ke lʼigb es ogŋ ɛm lʼɛy ↄkm a, -lʼus ow jam. -Li tutr ekʼow aam uwↄmu af ikŋ ↄŋn. ");
INSERT INTO adj_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mari im ok yogŋ a eke Jesu anŋ a. Kpɛkŋ eke li bʼɛkn ow a, lʼok ↄwrↄkp wus ow ecʼany af ɛtŋ nʼam dad ow lʼɛsɛ: «Ɛgŋ gbɛl, blel anŋ aŋa, ɛm lisijim blel uwm.» ");
INSERT INTO adj_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Jesu ɛkn eke nʼam ikŋ ↄŋn agŋ a ekʼigŋʼn ab ow ab ab. Ow e low a ↄwrʼr sos es afŋn es, ");
INSERT INTO adj_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ɛtŋ nʼam ibrm wɛl lʼɛsɛ: «Kↄ bogŋ ɛwr ir ee?» -Li dad ow ninɛ: «Ɛgŋ gbɛl, òw cɛ bʼow ɛkn.» ");
INSERT INTO adj_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jesu ikŋ ↄŋn. ");
INSERT INTO adj_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Jwifɛl a dad ninɛ: «Ɛ̀kan, lʼerur ow tasi!» ");
INSERT INTO adj_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Gbɛkↄ ɛl ɛm ecʼagŋ nyam nyam am dad ɛsɛ: «In eke lʼewlm any eflu a, kↄ li kʼↄtum lʼɛdŋnm Lasar eke kʼúwm ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ɛmɛny Jesu low ɛy sos ɛm toŋ ow afŋn es, ɛtŋ im uwↄmu ab af. Ow el nↄmu ekʼanŋ mób ɛm, ke wɛl oc lob abl ow ecʼɛm ɛy usu ab es. ");
INSERT INTO adj_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jesu dad ninɛ: «Ɔ̀nyn lob a ocr es.» Lɛgŋuw a e lisijↄw Mart dadʼr ninɛ: «Ɛgŋ gbɛl, sɛgŋ emum yar ɛtŋ anake nʼanŋ aŋa a, lʼit eke li kʼewŋ.» ");
INSERT INTO adj_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jesu dadʼr ninɛ: «Kↄ mi dadmʼŋ mʼɛsmɛ, eke ↄny ↄmn, bʼow ɛkn Nyam ecʼanygbɛl ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sica wɛl ↄny lob a oc es, ɛtŋ Jesu igbl any ogŋ afr ɛtŋ dad ninɛ: «Ɛm Ɛs, mʼɛluʼŋ bia eke iri ɛm e lebl. ");
INSERT INTO adj_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mʼuw any eke sɛgŋ a fɛŋ bʼiriʼm lebl, gbɛkↄ mʼam dadʼŋ agŋ amua ekʼɛlulʼm ɛm a eci, yecʼɛtŋ ke -lʼub nawrɛ eke ɛrmʼm.» ");
INSERT INTO adj_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Li bʼuwar odad a ɛtŋ li barm lebl tuↄtuↄ ɛm ninɛ: «Lasar, ɛ̀y ↄkm!» ");
INSERT INTO adj_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lɛgŋuw a ɛy ↄkm, gbad og wiwrmʼn sabu lele akr ab ɛtŋ gbad wiwrmʼn nuŋ ab. Jesu dad ɛl ninɛ: «Mↄmun in es, ke ɛ́gbar ir es nʼim.» ");
INSERT INTO adj_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jwifɛl a ekʼow Mari ogŋ a ɛkn ów a eke Jesu kok a ɛtŋ ɛl ɛm e nↄnↄ ub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Gbɛkↄ ɛl ɛm ecʼagŋ bɛb gbɛ im ɛŋn Farisiɛl a ɛtŋ otar ów a eke Jesu kok a e low akr ok ɛl. ");
INSERT INTO adj_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Egb waw ɛsɛl ɛgbɛl lele Farisiɛl ab ɛsŋ Sanedrɛn ecʼagŋ a luku as ɛm, ɛtŋ am dad ɛsɛ: «Ɛgŋ na am kok mɛny ɛwr owi nↄnↄ! Kↄ ayaf si ki kokr ab ee? ");
INSERT INTO adj_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Eke sʼam yɛbʼr li kok ɛbɛn, agŋ a fɛŋ bʼow ubʼr nawrɛ; ow bʼow ↄŋ Rom ecʼes ɛwɛl a ow ok low na ɛm ŋuŋn ɛy e Nyamel gbɛl na lele ɛy ecʼɛb na nimum ab!» ");
INSERT INTO adj_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ɛl ɛm ecʼɛgŋ nyam eke wɛl bʼɛsŋ Kayif, ke lakpo ab af el egb waw ɛs ligbɛl a am dad ɛl ɛsɛ: «Low na kʼokm ↄny es sos ɛm kaka! ");
INSERT INTO adj_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Kʼuwmn any eke ow akpl ↄny eci ekʼɛgŋ nyam kʼuw dedeku a fɛŋ eci, ke ow ɛm a ɛb a nimum kʼuŋm ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ke ow elm in ɛm li dadm odad na, gbɛkↄ eke lakpo ab af lʼel egb waw ɛs ligbɛl a, nʼam ɛwar li dad eke owʼn it eke Jesu in kʼuw Jwifɛl fɛŋ eci, ");
INSERT INTO adj_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ke owʼn kʼelm wɛl sↄny cɛ eci, kↄ ke in ás Nyam ecʼey a eke in mↄmun es a luku sos megl nyam ɛm. ");
INSERT INTO adj_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Lɛgŋ a cɛ, Jwifɛl ecʼes ɛwɛl a bɛbm eke kʼibi Jesu. ");
INSERT INTO adj_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ow sosiɛm Jesu ɛ́cm Jwifɛl a ecʼany af ij. Nʼim wus ikpr nyam eke titm loj a, baŋn a eke wɛl bʼɛsŋ Efrayim ab ɛm; nʼanŋ yogŋ in e jam ɛsɛl ab ab. ");
INSERT INTO adj_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Pak ecʼes gbɛgbl ekʼel Jwifɛl ecʼa e lɛgŋ titm, ɛtŋ wus ab af ecʼagŋ nↄnↄ im Jerusalɛm eke kʼayal sos gbuŋ ke es gbɛgbl a e lɛgŋ ów. ");
INSERT INTO adj_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","-Nʼam ↄl Jesu, ɛtŋ eke -nʼanŋn Nyamel gbɛl ab ɛm a, -nʼam ibrmnin ɛl ↄfr -lʼɛsɛ: «Kↄ ayaf am ɛkanin ee? Li bʼow lʼow, kↄ li kʼow lʼowm es gbɛgbl na ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ke egb waw ɛsɛl ɛgbɛl a lele Farisiɛl ab ab dad ekʼɛgŋ in uw yogŋ eke Jesu in anŋ any, owʼn yɛ́gm ɛl yecʼɛtŋ kʼɛl ↄ́ny ow. ");
INSERT INTO adj_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sica ow anŋ sɛgŋ nↄhↄn ke Pak ɛ́y, ɛtŋ Jesu im Betani, yogŋ a eke Lasar eke lʼigbm luw ɛm a anŋ a. ");
INSERT INTO adj_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yogŋ, Mart kok ob ij ↄŋʼn. Agŋ a ekʼanŋ ob ij lↄfu lís Jesu ab a, Lasar yɛji anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mari oc mijey litr ikpr ekʼil an ke wɛl kok nar tasi ɛm ok Jesu akr; ɛtŋ lʼoc in e sin nuŋ a li tɛtŋ ow akr es. Akŋ a nimum el mijey sↄsŋ ↄfr. ");
INSERT INTO adj_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Ɛtŋ Judas Iskariↄt, Jesu e jam ɛsɛl ab ɛm ecʼɛgŋ nyam, in a tasi eke bʼow ↄl ijʼr a dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","«Wɛl ↄtu eke kʼↄl mijey na ij os ekŋ yen yen sakp nyahan, óc ow ecʼos a ↄŋ ↄgbↄru.» ");
INSERT INTO adj_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Nʼam dad odad na ow elm ↄgbↄru e sↄrŋ ikŋ eke li kʼↄny eci, kↄ eke lʼel ulu a sosiɛm eci, aŋke os ekpr a eke li bʼↄnym ab a, li bʼot os a eke wɛl bʼok ɛm a. ");
INSERT INTO adj_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ɛtŋ Jesu dad ninɛ: «Ɛ̀gbʼr es tiŋ! Li kok low na lɛgŋ a eke wɛl bʼow ɛluʼm uwↄmu ɛm a eci. ");
INSERT INTO adj_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ɔgbↄru anŋ ↄny ab sɛgŋ fɛŋ, kↄ ɛm ecʼa, mi kʼow mʼanm ↄny ab sɛgŋ fɛŋ.» ");
INSERT INTO adj_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Jwifɛl a ecʼagŋ nↄnↄ iri eke Jesu anŋ Betani. -Nʼim yogŋ ow elm Jesu sosiɛm eci cɛ, kↄ Lasar yɛji eke Jesu igbm luw ɛm a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Egb waw ɛsɛl ɛgbɛl a ɛgŋ eb eke kʼibi Lasar yɛji, ");
INSERT INTO adj_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","aŋke Jwifɛl nↄnↄ am ŋgboŋ ɛl ɛm Lasar sosiɛm ɛtŋ am ub Jesu nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Eke lɛgŋ ɛny akr af a, agŋ nↄnↄ a eke ow Pak ecʼes gbɛgbl ab ɛm a iri eke Jesu am ow Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Agŋ a fɛŋ ot sarikŋ ay ɛtŋ ok ↄkm baŋn a aam ↄbrʼr, -nʼam ↄg -li dad -lʼɛsɛ: «Hosana! Ke Nyam ɛ́dŋ ɛgŋ a ekʼam ow Ɛs Kↄtↄkↄ e nin ɛm a ↄwrↄ! Ke Nyam ɛ́dŋ Israɛl ecʼɛb ebu a ↄwrↄ!» ");
INSERT INTO adj_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesu ɛŋn gbaŋkↄ kpɛtɛŋni nyam ɛtŋ sig es af ɛsɛ elel eke Nyam Lɛl dadr ab af: ");
INSERT INTO adj_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Siↄn eci dedyↄwli, erŋn kʼↄ́nyʼŋ! Ìs any lɛr, ŋ ecʼɛb ebu a am ow, li sig gbaŋkↄ kpɛtɛŋni e liy af. ");
INSERT INTO adj_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ke ów amua kʼokm in e jam ɛsɛl a es sos ɛm; gbɛkↄ eke Jesu ɛy in ecʼanygbɛl ɛm bake ow uwr a, -lʼↄkn eke Nyam Lɛl ikŋ anym dad in e lís e low na, ɛtŋ ow anake ow ɛy a. ");
INSERT INTO adj_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Bieku ab ɛm ecʼagŋ a eke ɛkn Jesu igbm Lasar luw ɛm a, am dad low a eke -lʼɛkan a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Bieku a iri mɛny ɛwr a e li kok a ecʼodad: na sosiɛm anake -lʼowr -nʼam ↄbr ow a. ");
INSERT INTO adj_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ca Farisiɛl a am dad ɛl ↄfr ɛm ɛsɛ: «Am ɛkan, si kʼↄtumn low kaka fɛŋ ecʼij! Agŋ a fɛŋ am usʼr jam!» ");
INSERT INTO adj_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Es gbɛgbl a e lɛgŋ a, agŋ a ekʼuyu im Jerusalɛm eke kʼigŋ Nyam nuŋ a, Grɛkɛl a e bɛb anŋ ɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ɛl, -nʼim -nʼɛŋn Filip ekʼel Bɛtsayida baŋn Galile wus af ecʼɛgŋ a, ɛtŋ -li dad ow ninɛ: «Ɛgŋ gbɛl, sʼam erur eke si kʼɛkn Jesu.» ");
INSERT INTO adj_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip im dad ok Andre ɛtŋ ɛl yony mum -nʼim -li dad -lʼok ow. ");
INSERT INTO adj_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jesu dad ɛl ninɛ: «Wanci ow eke ɛgŋ ecʼIy bʼow ɛy in anygbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Low nawrɛ mʼam dad ↄny: likŋ e liy nyam eke wɛl ɛlu nↄmu ɛm ke anŋ tiŋ ugŋm es a bʼanŋ in ecʼelel a cɛ. Gbɛkↄ eke sel a ugŋ es, li bʼↄsu ey nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ɛgŋ eke bʼerur in e sel a, li bʼow lʼirmn ow; kↄ ɛgŋ eke wus af aŋa kʼow ebrm in e sel a e low ɛrm mij a, bʼow ɛŋn sel ekʼↄnym uwr. ");
INSERT INTO adj_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Ɛgŋ eke am erur e ki kok ɛm e lís e low a, ow it ke lʼúsʼm jam; ow ɛm a, li bʼow nʼanŋ yogŋ a eke mʼow mʼanŋ a. Ɛgŋ a eke bʼow kok ɛm e lís e low a, ɛm Ɛs bʼow usrʼr sos. ");
INSERT INTO adj_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Wanci na af ɛrmni ɛdŋʼm es. Ɛtŋ ayaf mi ki dadr ee? Mi dád mʼɛsɛ: ɛm Ɛs, ↄny ocʼm es gbre e wanci na af ee? Ke tasi ɛm a, wanci na ecʼanake mʼow a. ");
INSERT INTO adj_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ɛm Ɛs, ↄŋ ŋ e nin a anygbɛl!» Ɛtŋ kpɛkŋ lebl nyam anŋ afr dad ninɛ: «Mʼↄŋʼn anygbɛl lɛgŋ ɛtŋ, ɛtŋ ɛmɛny mʼow mʼↄŋʼn anygbɛl sakp yony ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Bieku a eke anŋ yogŋ ke iri lebl a am dad ɛsɛ: «Na nyamgbrany!» Ɛtŋ agŋ bɛb am dad ɛsɛ: «Afr ɛrm ɛs nyam dadʼr odad!» ");
INSERT INTO adj_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ɛtŋ Jesu dad ɛl ninɛ: «Lebl na ikŋm ɛm sosiɛm, kↄ ↄny sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Catŋ anake wus na e jɛj ok e wanci a ow a; sicaca ɛm a, wɛl bʼow ogŋ wus na ecʼes ɛw ɛs a. ");
INSERT INTO adj_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ɛtŋ ɛm ecʼa, lɛgŋ eke wɛl bʼow igblʼm ogŋ afr a, mʼow mʼↄdu agŋ a fɛŋ mʼeb.» ");
INSERT INTO adj_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Sodad amua ɛm, Jesu am yɛgm in e luw a ecʼelel eke bʼow ɛcr. ");
INSERT INTO adj_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Agŋ a dadʼr ninɛ: «Ɛy e sol a e silɛl ab ɛm sʼiri eke Mesi a bʼow anŋ owr sɛgŋ fɛŋ. Ayaf ↄtu eke ki dad eke ow it eke wɛl kʼigbl ɛgŋ ecʼIy ogŋ afr ee? Ɛgŋ ecʼIy a, ke bwo ecʼɛgŋ ana ee?» ");
INSERT INTO adj_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jesu am dad ɛl ɛsɛ: «Ɛmɛny usuayl anŋ ↄny ecʼaraŋn lɛgŋ tɛl eci cɛ. Eke ↄnyn usuayl a, àan es usuayl ɛm, yecʼɛtŋ ke ncebn kʼókrm ↄny es. Ɛgŋ eke am an es ncebn ɛm a úwm usu eke nʼaam ab any. ");
INSERT INTO adj_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Eke ↄnyn ɛgŋ a eke el usuayl a, ↄnyn ↄmn in ɛm yecʼɛtŋ ke éel usuayl ecʼey.» Eke li dad sodad amua uwr a, Jesu ocr sos es agŋ a sosiɛm im kpekpe lↄl es. ");
INSERT INTO adj_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Mɛny ɛwr nↄnↄ na eke li kok bieku a ecʼany af a yɛji ↄↄm ɛl -lʼubm ow nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ow ɛm kokoba ↄb ɛs Esayi ecʼodad eke dad a iy nɛny: Ɛs Kↄtↄkↄ, kↄ bwo ecʼɛgŋ iri ɛy eci odad ab ee? Kↄ bwo ecʼɛgŋ Ɛs Kↄtↄkↄ okm sos ↄkm yɛgm ee? ");
INSERT INTO adj_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ɛtŋ ɛmɛny Esayi in cɛ li dad low a sosiɛm eke agŋ amua kʼↄtum ubm nawrɛ a: ");
INSERT INTO adj_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Nyam efal ɛl any, lʼirmn wɛl e nuŋ ɛm ↄny a yecʼɛtŋ ke ɛl eci anyamn a kʼɛ́knm es, ke -li kʼuwmn low any. Ɛtŋ kin low a sosiɛm eke -li kʼɛwlmn -lʼowmn Nyam ogŋ bake lʼéwlm wɛl a. ");
INSERT INTO adj_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Esayi dad odad na aŋke lʼɛkn Jesu ecʼanygbɛl a, ɛtŋ ow el ow ecʼodad anake nʼam dad a. ");
INSERT INTO adj_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gbɛkↄ, Jwifɛl ecʼes ɛwɛl a, ɛl ɛm a yɛji agŋ nↄnↄ ub Jesu nawrɛ. Gbɛkↄ Farisiɛl a sosiɛm, -lʼokamn sos ↄkm bake wɛl ogŋ ɛl Nyam nuŋ igŋ usu a. ");
INSERT INTO adj_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","-Li bʼerur sos usr a eke bʼanŋ agŋ ɛm ow a -lʼakm Nyam ɛm ecʼa. ");
INSERT INTO adj_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jesu igbl lebl ogŋ dad ninɛ: «Ɛgŋ eke ↄny ↄmn ɛm ɛm a, ow elm ɛm ɛm sↄny cɛ nʼↄnym ↄmn, kↄ ɛgŋ a ekʼɛrmʼm ab ɛm yɛji. ");
INSERT INTO adj_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɛgŋ eke am ɛknʼm a, am ɛkn ɛgŋ a eke ɛrmʼm a. ");
INSERT INTO adj_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ɛm, mʼel usuayl, mʼow wus af aŋa yecʼɛtŋ ke ɛgŋ kaka fɛŋ eke ↄny ↄmn ɛm ɛm a, kʼánm ncebn ɛm. ");
INSERT INTO adj_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Eke batŋ ɛgŋ am iri ɛm e sodad a, ɛtŋ lʼↄ́sum a, ke ow elm ɛm mʼↄbmʼn low ij, aŋke tasi ɛm a, mʼow eke mi ki sↄg wus ecʼagŋ a, kↄ ow elm ɛl e low ↄb eci. ");
INSERT INTO adj_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ɛgŋ eke am igŋʼm, ke ébm ɛm e sodad a, bʼɛŋn in e low ↄb a ow ɛm; lɛgŋ es abal el ɛm a, ɛm e low yɛgm a anake bʼow ↄbʼr low a. ");
INSERT INTO adj_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Tasi ɛm a, ow elm ɛm obi ɛm mi dadm, kↄ ɛm Ɛs eke ɛrmʼm a in obi, nʼↄŋʼm yecʼa eke mi ki dad ke mi yɛgm agŋ a ecʼabusu. ");
INSERT INTO adj_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ɛtŋ mʼuw any eke yecʼa eke li bi dad a bʼↄŋ ɛgŋ sel ekʼↄnym uwr. Yecʼa eke mʼam dad a, mʼam dad ɛsɛ elel eke ɛm Ɛs ↄŋʼm ow ecʼabusu ab af.» ");
INSERT INTO adj_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Gbuŋ ke Pak ecʼes gbɛgbl a e lɛgŋ ɛ́y a, Jesu uw any eke lɛgŋ owʼr eke li kʼŋgboŋ wus af aŋa nʼim Ɛs ogŋ. Lʼerur in ecʼagŋ a eke anŋ wus af aŋa a, ɛtŋ sica li bʼow li yɛgm wɛl eke nʼↄny wɛl ecʼerur kpɛkŋ kpɛkŋ. ");
INSERT INTO adj_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jesu lele in eci jam ɛsɛl ab ab am ij ncebles ecʼob; ke Judas, Simↄ Iskariↄt jim gbɛ, agn ebʼr eke li kʼↄl Jesu lʼij. ");
INSERT INTO adj_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesu in obi lʼuw any eke nʼanŋ Nyam ogŋ lʼow eke li bʼow lʼɛwl nʼim ow ogŋ, ɛtŋ Ɛs ↄŋʼn low fɛŋ ecʼabusu. ");
INSERT INTO adj_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Lʼigb ob ij lↄfu lís yogŋ, nʼↄny in e mob af ɛw a lʼoc es, ɛtŋ lʼoc gbad lʼucu er. ");
INSERT INTO adj_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ow e jam a, lʼoc mij lʼok kpokpo ɛm ɛtŋ nʼam yↄyↄg jam ɛsɛl a akr es; li bʼoc gbad a eke lʼucu er a li tɛtŋn wɛl akr es. ");
INSERT INTO adj_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Li bʼok Simↄ Piɛr ogŋ a, ow dadʼr ninɛ: «Ɛgŋ gbɛl, kↄ ŋ ki yↄyↄgʼm akr es ee?» ");
INSERT INTO adj_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jesu dadʼr ninɛ: «Caca ɛm e low eke mʼam kok a kʼirim, gbɛkↄ lɛgŋ ekʼam ow ab ɛm bʼow iri.» ");
INSERT INTO adj_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piɛr ninɛ: «Kʼow yↄyↄgm im akr es lɛgŋ kaka!» Jesu ninɛ: «Eke mi yↄyↄgmʼŋ es, kʼow elm ɛm eci.» ");
INSERT INTO adj_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Simↄ Piɛr ninɛ: «Ɛgŋ gbɛl, ow kʼél akr sↄny ij, kↄ nuŋ lele sabu ab yɛji!» ");
INSERT INTO adj_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jesu ninɛ: «Ow itm eke ɛgŋ eke ok mij a kʼok mij ij, ekʼow elm akr cɛ, aŋke lʼayl fɛŋ. Ɔny, ayal, gbɛkↄ ow elm ↄny fɛŋ gbɛ.» ");
INSERT INTO adj_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesu uw ɛgŋ a eke bʼow ↄl ijʼr ab any sɛnyn sɛnyn; na sosiɛm anake li dad eke owʼn elm wɛl fɛŋ wɛʼn aylm a. ");
INSERT INTO adj_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Eke li yↄyↄg wɛl akr es bake ow uwr a, lʼus in e mob sus ɛm a, lʼɛwl nʼim ob ij lↄfu lís a li sig es ɛtŋ nʼam dad wɛl lʼɛsɛ: «Kↄ low a eke mi kok ↄny a, uwr ow e nyandrɛ ab any ee? ");
INSERT INTO adj_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Bʼɛsŋnʼm “Low yɛgm agŋ ɛs” lele “Ɛgŋ gbɛl” ab ɛtŋ ↄny e low yɛji ij aŋke mʼel. ");
INSERT INTO adj_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Eke batŋ ɛm eke mʼel Ɛgŋ gbɛl lele Low yɛgm agŋ ɛs ab a mi yↄyↄg ↄny akr es, ke ↄny yɛji, ↄny ↄfr a, ow it eke ki yↄyↄgr ir akr es. ");
INSERT INTO adj_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mʼↄŋ ↄny sɛwl eke ki kokr ɛsɛ elel eke mi kok ab af. ");
INSERT INTO adj_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Ɛɛ, low nawrɛ mʼam dad ↄny: adu ágbm akam in ecʼes ɛw, ɛtŋ ɛrmu yɛji ágbm akam ɛgŋ a ekʼɛrmʼn a. ");
INSERT INTO adj_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Sica eke uwr ów amua any a, eke kokr ow e low, ehe bʼow el ↄny eci. ");
INSERT INTO adj_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Ow elm ↄny fɛŋ ecʼodad mi dadm; agŋ a eke mi sↄsum mʼot a, mʼuw ɛl any. Gbɛkↄ ow it ke Nyam Lɛl ecʼodad a íy nɛny: Ɛgŋ a eke in yↄny sʼij ob a ɛwl owʼm ar. ");
INSERT INTO adj_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sicaca ɛm a, mʼam dad ↄny kpɛkŋ gbuŋ ke low a ów, yecʼɛtŋ ke lɛgŋ a eke low a bʼow ɛy a, úbr nawrɛ eke ɛm, anŋ anŋ. ");
INSERT INTO adj_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Ɛɛ, low nawrɛ mʼam dad ↄny: ɛgŋ kaka fɛŋ ekʼeb ɛgŋ eke mʼɛrm a, ɛm yɛji lʼebʼm; ɛtŋ ɛgŋ kaka fɛŋ eke ebʼm a, eb ɛgŋ a eke ɛrmʼm a.» ");
INSERT INTO adj_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Eke Jesu dad ów amua bake ɛw nɛny es a, low ɛyʼr sos ɛm afŋn es. Li dad lʼɛrum mar ninɛ: «Ɛɛ, low nawrɛ mʼam dad ↄny: ↄny ɛm ecʼɛgŋ nyam bʼow ↄl ijʼm.» ");
INSERT INTO adj_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Jam ɛsɛl a am lɛrir ɛl ↄfr ɛtŋ -lʼuwmn ɛgŋ yecʼa eke odad a ot es ab any. ");
INSERT INTO adj_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Jam ɛsɛl ab ɛm e nyam a eke Jesu bʼerur a akŋmʼn ab. ");
INSERT INTO adj_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simↄ Piɛr ɛw sos nyam yɛgmʼn eke li kʼibrm Jesu ɛgŋ yecʼa ekʼow am dad ow ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Jam ɛs a igŋ Jesu lↄru ɛtŋ am ibrmʼn ɛsɛ: «Ɛgŋ gbɛl, kↄ bwo ecʼɛgŋ ee?» ");
INSERT INTO adj_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jesu dad ninɛ: «Mʼow mʼubr futufutu mʼusm mredi ɛm; ɛgŋ a eke mʼow mʼoc mʼↄŋ a, ke in ana.» Lʼubr futufutu lʼusm mredi ɛm ɛtŋ nʼↄŋ Simↄ Iskariↄt jim Judas. ");
INSERT INTO adj_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Eke kpɛkŋ Judas eb futufutu ikpr a, Satan ɛyʼr ɛm. Jesu dadʼr ninɛ: «Low yecʼa eke ki kok a, kòk fafa.» ");
INSERT INTO adj_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Low a sosiɛm eke li dad ow odad na a, agŋ a eke ok es ob ij lↄfu lís a, ɛgŋ kaka uwm any. ");
INSERT INTO adj_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Eke ow el Judas anake bʼↄnym os ab ab a, agŋ nↄnↄ am tutr eke Jesu am ɛrmʼn eke li kʼim lʼↄl ob ekʼit es gbɛgbl a eci, oglog nʼím lʼap ↄgbↄru ob. ");
INSERT INTO adj_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Judas eb futufutu a ɛtŋ kpɛkŋ lʼɛy ↄkm. Ke lɛgŋ am uk. ");
INSERT INTO adj_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Eke sica Judas ɛy ↄkm a, Jesu dad ninɛ: «Sica ɛgŋ ecʼIy ecʼanygbɛl a e lisany a fig ɛtŋ Nyam ecʼanygbɛl a bʼow ɛy ↄkm in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Ɛtŋ eke Nyam ecʼanygbɛl a ɛy ↄkm in ɛm, Nyam yɛji in obi bʼow ɛlu Iy a ecʼanygbɛl ↄkm, ɛtŋ ow kʼow ibnm. ");
INSERT INTO adj_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ɛm ecʼey, mʼanŋ ↄny ab lɛgŋ tɛl cɛ eci. Bʼow ↄↄlʼm, kↄ mʼam mʼow mi dad ↄny low a eke mi dad mʼok Jwifɛl ɛjecʼa: “Kʼow ↄtumn iimn yogŋ a eke mʼaam a.” ");
INSERT INTO adj_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Mʼam ↄŋ ↄny ol owr: èrurir ↄny ↄfr. Tasi ow it eke kʼerurir ↄny ↄfr ɛsɛ elel eke mʼerur ↄny ab af. ");
INSERT INTO adj_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Eke erur anŋ ↄny ↄfr ɛm tasi, ke agŋ a fɛŋ bʼow uw any eke eel ɛm e jam us ɛsɛl.» ");
INSERT INTO adj_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simↄ Piɛr am ibrm Jesu ɛsɛ: «Ɛgŋ gbɛl, kↄ bogŋ aam ee?» Li dad ow ninɛ: «Sicaca ɛm kʼↄtum usm im jam owm yogŋ a eke mʼaam a; gbɛkↄ lɛgŋ ɛjecʼɛm bʼow usʼm jam ow.» ");
INSERT INTO adj_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piɛr dadʼr ninɛ: «Ɛgŋ gbɛl, kↄ bla sosiɛm ɛtŋ caca ɛm mi kʼↄtum mʼusmʼŋ jam mʼowm ee? Ɛm, mʼuw es inym eke mi kʼirmn ɛm e sel a ŋ eci!» ");
INSERT INTO adj_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jesu dad ninɛ: «Kↄ tasi uw es inym eke kʼirmn ŋ e sel a ↄŋʼm ee? Ɛɛ, low nawrɛ mʼam dadʼŋ: gbuŋ ke ŋgↄs íkŋ a, bʼow dad sakp nyahan eke uwmʼm any.» ");
INSERT INTO adj_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jesu dad in e jam ɛsɛl a ninɛ: «Ɛrm mij kʼók ↄny. Ɔ̀nyn ↄmn Nyam ɛm, ke ɛm yɛji ↄ́nyn ↄmn ɛm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ɛb ir usu nↄnↄ anŋ ɛm Ɛs e gbugŋ a; kↄ blel ow anm tasi, ke mi dad mʼɛsɛ mʼaam mi kok ↄny usu eke kʼiir ee? ");
INSERT INTO adj_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Eke mʼow mʼim mi kok ↄny usu a, mʼow mʼɛwl mɛny mʼow ke mʼót ↄny, yecʼɛtŋ ke ↄny yɛji ánŋn yogŋ a eke mʼanŋ a. ");
INSERT INTO adj_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yogŋ a eke mʼaam a ecʼejagb a uwr any.» ");
INSERT INTO adj_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Toma dadʼr ninɛ: «Ɛgŋ gbɛl, yogŋ a eke aam a, sʼuwm any, ke sica ayaf sʼↄtu eke si kʼuw ejagb ab any ee?» ");
INSERT INTO adj_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jesu dadʼr ninɛ: «Mʼel ejagb, mʼel low nɛnyɛmbri nyam, mʼel sel. Ɛgŋ kaka kʼↄtum iim Ɛs ogŋ eke lʼɛcrm ɛm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Eke uwrʼm any, bʼow uwr ɛm Ɛs yɛjʼany. Ɛtŋ sicaca ɛm a, uwr ir any ɛtŋ ɛkan in yɛji.» ");
INSERT INTO adj_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip dadʼr ninɛ: «Ɛgŋ gbɛl, yɛ̀gm ɛy Ɛs cɛ ke ow bʼow ɛyr ɛy ɛrm es.» ");
INSERT INTO adj_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jesu dadʼr ninɛ: «Filip, mʼanŋ ↄny ab lɛgŋ ibn ɛtŋ uwm im any ee? Ɛgŋ eke ɛknʼm a, ɛkn ɛm Ɛs. Ɛtŋ kↄ bla sosiɛm am dad eke mi ki yɛgmʼŋ ɛm Ɛs ee? ");
INSERT INTO adj_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Mʼanŋ ɛm Ɛs ɛm ɛtŋ ɛm Ɛs yɛji anŋ ɛm ɛm; kↄ ub nawrɛ ee? Sodad a eke mʼam dad ↄny a, ow elm ɛm ɛm ow ánm owm. Ɛm Ɛs eke ir ɛm ɛm a anake bi kok in ecʼów fɛŋ a. ");
INSERT INTO adj_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Eke mi bi dad mʼɛsɛ mʼanŋ ɛm Ɛs ɛm ɛtŋ ɛm Ɛs yɛji anŋ ɛm ɛm, ke ùbrʼm nawrɛ. Eke ɛgŋmn, ke ów amua sosiɛm gbɛ ùbr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Ɛɛ, low nawrɛ mʼam dad ↄny. Ów a eke mʼam kok a, ɛgŋ yecʼeke ↄny ↄmn ɛm ɛm a, in yɛji li bʼow li kok. Ɛtŋ li bʼow li kok ow agb afŋn es aŋke mʼaam ɛm Ɛs ogŋ. ");
INSERT INTO adj_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Low fɛŋ eke bʼow ibrmn ɛm e nin ɛm a, mʼow mi kok, yecʼɛtŋ ke Iy ɛ́lu Ɛs ecʼanygbɛl a ↄkm. ");
INSERT INTO adj_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Eke batŋ am ibrmnʼm low ɛm e nin ɛm a, mʼow mi kok.» ");
INSERT INTO adj_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","«Eke bʼerurirʼm, bʼow ↄsur ɛm e sol a. ");
INSERT INTO adj_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ɛtŋ mʼow mʼibrm ɛm Ɛs eke kʼↄŋ ↄny Abu Ɛlum Ɛs ɛjeci eke kʼanŋ ↄny ab sɛgŋ fɛŋ. ");
INSERT INTO adj_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","In lʼel low nɛnyɛmbri nyam ecʼAbŋ. Wus kʼↄtum ebmʼn, aŋke li kʼↄtum lʼɛknm ow, li kʼↄtum lʼuwm ow any. Gbɛkↄ ↄny, uwr ir any aŋke nʼanŋ ↄny ab ɛtŋ li bʼow nʼanŋ ↄny ɛm sɛgŋ fɛŋ. ");
INSERT INTO adj_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Mi kʼow mʼɛlum ↄny es ↄny sↄny ɛsɛ uwiyŋɛl af, kↄ mʼow mʼɛwl mʼow ↄny ogŋ. ");
INSERT INTO adj_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ow anŋ lɛgŋ tɛl eke wus kʼow ɛknm im ij; kↄ ↄny, bʼow ɛkanʼm, aŋke mʼow mʼɛwl mʼanŋ owr ɛtŋ ↄny yɛji bʼow anŋn owr. ");
INSERT INTO adj_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Ow e lɛgŋ a, ow bʼow ok ↄny es sos ɛm eke mʼanŋ ɛm Ɛs ɛm, ɛtŋ ↄny yɛji anŋnʼm ɛm, ɛtŋ ɛm yɛji mʼanŋ ↄny ɛm. ");
INSERT INTO adj_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ɛgŋ a eke bʼeb ɛm e sol a, ke bʼↄsu a, ke ɛgŋ a eke bʼerurʼm ab ana. Ɛgŋ eke bʼerurʼm a, ɛm Ɛs bʼow erur ir; ɛm yɛji mʼow mʼerur ir ɛtŋ mʼow mʼokm sos ↄkm in ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jud (ow elm Judas Iskariↄt) dadʼr ninɛ: «Ɛgŋ gbɛl, kↄ bla sosiɛm dad eke kʼokm sos ↄkm yɛgm ɛy ke ow kʼelm wus ecʼagŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jesu dadʼr ninɛ: «Low fɛŋ eke mʼam dad a, ɛgŋ eke bʼerurʼm a bʼow ↄsu. Ɛm Ɛs bʼow erur ir, ɛtŋ ɛm lele ɛm Ɛs ab si bʼow sʼim in ogŋ, ɛtŋ si bʼow sʼir in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɛgŋ eke érurm im a, ↄ́sum ɛm e sodad a. Low na eke mʼam dad irir a, ow elm ɛm eci, kↄ ɛm Ɛs eke ɛrmʼm a ogŋ ow anŋ ow. ");
INSERT INTO adj_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Eke mʼanŋ ↄny ab a, mʼam dad ↄny low na. ");
INSERT INTO adj_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Abu Ɛlum Ɛs a, Abŋ Lala a eke ɛm Ɛs bʼow ↄŋ ow ɛm e nin ɛm a, bʼow yɛgm ↄny low a fɛŋ ɛtŋ bʼow ↄkn ↄny ów fɛŋ eke mi dad ↄny a. ");
INSERT INTO adj_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Mʼam ɛw ↄny ɛrm es ɛy es, mʼam ↄŋ ↄny ɛm eci ɛrm es ɛy a. Mʼↄↄm ↄny ɛsɛ elel eke wus bʼↄŋn ɛgŋ ab af. Ɛrm mij kʼók ↄny, erŋn yɛji kʼↄ́ny ↄny. ");
INSERT INTO adj_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Irir mi dad mʼɛsɛ: “Mʼaam kↄ mʼow mʼɛwl mɛny mʼow.” Blel bʼerurirʼm tasi ana, ow íŋn ↄny sos ɛm uwr any eke mʼaam ɛm Ɛs ogŋ, aŋke ɛm Ɛs agb akmʼm. ");
INSERT INTO adj_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mʼam dad ↄny caca ɛm gbuŋ ke ów amua ów, yecʼɛtŋ ke lɛgŋ a eke ów amua bʼow a, úbr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mi kʼow mi dadm ów nↄnↄ ↄny ab ij, aŋke wus na ecʼes ɛw ɛs a am ow. Ow elm ke nʼↄ́ny abusu ɛm e nuŋ af, ");
INSERT INTO adj_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","kↄ ow it eke wus kʼuw any eke mʼↄny ɛm Ɛs ecʼerur. Ow sosiɛm low yecʼa eke ɛm Ɛs bʼibrm a, mi bi kok. Ìgbr, sʼŋ́gbroŋn aŋa!» ");
INSERT INTO adj_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","«Mʼel viny e likŋ lis tasi a, ɛtŋ ɛm Ɛs el ↄgm a e juma kok ɛs. ");
INSERT INTO adj_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Likŋ lal fɛŋ eke bʼucuʼm ke ↄ́sum ey a, li bʼubr ow es, gbɛkↄ lal fɛŋ eke bʼↄsu ey a, li bʼot ow ɛm es, lʼayal ow, yecʼɛtŋ ke ɛmɛny lʼↄ́su ey nↄnↄ lʼobn. ");
INSERT INTO adj_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Low yɛgm a eke mʼↄŋ ↄny a, ayal ↄny lɛgŋ a ɛtŋ. ");
INSERT INTO adj_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ùcurʼm ɛsɛ elel eke mʼucu ↄny ab af. Likŋ lal kʼↄtum ↄsum ey in obi ɛm, eke lʼucum likŋ lis a; ɛbɛn nyam coco ↄny yɛji, kʼↄtumn ↄsumn ey eke ucumnʼm. ");
INSERT INTO adj_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Mʼel viny e likŋ a eci lis, ɛtŋ ↄny eel likŋ a ecʼál a. Ɛgŋ eke ucuʼm ke ɛm yɛji mʼucuʼr a bʼↄsu ey nↄnↄ. Tasi ɛm a, kʼↄtumn kokmn low kaka fɛŋ eke mʼanm ɛm. ");
INSERT INTO adj_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ɛgŋ eke ucum im a, wɛl bʼoc ↄwlʼl gbeŋ ɛsɛ likŋ lal eke ↄ́sum ey af; li bi wɛw es, ɛtŋ wɛl bʼot ekŋ ál wɛwɛ a wↄwl alm iri ok es. ");
INSERT INTO adj_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Eke bʼanŋn ɛm ɛm ɛtŋ ɛm e sodad a yɛji bʼanŋ ↄny ɛm a, ìbrmn ɛm Ɛs low yecʼa eke erurir a, li bʼow nʼↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Eke bʼↄsur ey nↄnↄ a, bʼow yɛgmn eke eel ɛm e jam us ɛsɛl; ow ɛm anake ɛm Ɛs ecʼanygbɛl a bʼow ɛy ↄkm a. ");
INSERT INTO adj_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Ɛsɛ elel eke ɛm Ɛs bʼerurʼm ab af a, ɛm yɛji mi bʼerur ↄny ɛbɛn. Ànŋn ɛm ecʼerur ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Bʼow anŋn ɛm ecʼerur ab ɛm eke bʼↄsur ɛm e sol a, ɛsɛ elel eke mʼↄsu ɛm Ɛs e sol a ke mʼanŋ in ecʼerur ab ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Mi dad ↄny low na yecʼɛtŋ ke ɛm eci sos ɛm iŋn a ánŋ ↄny ɛm, ke ow ↄ́ŋ ↄny e sos ɛm iŋn a iy nɛny. ");
INSERT INTO adj_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Kin ɛm ecʼol a eke mʼam ↄŋ ↄny a: èruririr ↄny ↄfr ɛsɛ elel eke mʼerur ↄny ab af. ");
INSERT INTO adj_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Erur ligbɛl a eke ɛgŋ ↄtu eke kʼɛlu ↄkm a cɛ el ke lʼírmn in e sel a lawlɛl e nuŋ af. ");
INSERT INTO adj_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Eke bi kokr low yecʼa eke mʼam ibrm ↄny a, ke eel ɛm lawlɛl ŋ̂. ");
INSERT INTO adj_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mi kʼow mʼɛsŋʼm ↄny madu ij, aŋke adu úwm in ecʼes ɛw ɛs e low eke bi kok ab any. Mʼam ɛsŋ ↄny ɛm lawlɛl aŋke ɛm Ɛs ɛm e low fɛŋ eke mi wewr a, mi yɛgm ↄny. ");
INSERT INTO adj_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ow elm ↄny sↄsuamn ocmnʼm, kↄ ɛm mi sↄsum mʼot ↄny; mʼɛw ↄny eke kʼimn ↄsur ey, ↄ́sur ey eke bʼanŋ ibn. Ow bʼow ↄŋ ɛm Ɛs ↄŋ ↄny low fɛŋ eke am ibrmn ɛm e nin ɛm a. ");
INSERT INTO adj_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Low a eke mʼam ibrm ↄny a el: èruririr ↄny ↄfr.» ");
INSERT INTO adj_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","«Eke wus ↄny ↄny e sifn, ↄkan eke ɛm lʼikŋ anym lʼifnʼm. ");
INSERT INTO adj_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Blel eel wus ecʼana, wus ↄ́ny ↄny ecʼerur eke eel in ecʼa sosiɛm. Kↄ mi sↄsum mʼot mʼok ↄny saw, elmn wus ecʼij: na sosiɛm anake wus bʼifn ↄny a. ");
INSERT INTO adj_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Ɔ̀kan low a eke mi dad ↄny a: “Adu ágbm akam in ecʼes ɛw a.” Eke agŋ ijrʼm gbre, ↄny yɛji -li bʼow -lʼijr ↄny gbre; eke -lʼɛlum ɛm e low yɛgm a, -li bʼow -nʼↄny ↄny ecʼa yɛji ecʼɛlum. ");
INSERT INTO adj_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ɛtŋ ɛm sosiɛm -li bʼow -li kok ↄny ów amua fɛŋ, aŋke ɛgŋ a eke ɛrmʼm a, -lʼuwm ow any. ");
INSERT INTO adj_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Blel mʼowm, ɛtŋ blel mi dadm ɛl odad ana, ke blel ow elm ɛl sikpl. Kↄ caca ɛm a, -nʼↄnym low eke -li ki dad -li dogŋn sos ij. ");
INSERT INTO adj_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ɛgŋ ekʼↄny ɛm e sifn a, ↄny ɛm Ɛs yɛji eci sifn. ");
INSERT INTO adj_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Blel ɛl ecʼaraŋn a mi kokm ów eke ɛgŋ ɛjeci kʼↄtum kokm ana, ke blel ow elm ɛl sikpl. Kin, ca -lʼɛkn ɛm ecʼów a ɛtŋ ɛm lele ɛm Ɛs ab -nʼam ifn ɛy. ");
INSERT INTO adj_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Gbɛkↄ ów amua am ɛy yecʼɛtŋ ke odad na eke wɛl nↄn ɛl ecʼol ab ɛm a íy nɛny: -Nʼↄny ɛm e sifn ów ↄbr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Abu Ɛlum Ɛs a bʼow ow: in lʼel low nɛnyɛmbri nyam ecʼAbŋ eke anŋ ɛm Ɛs ogŋ am ow. Ɛm Ɛs bʼow ocʼr ↄŋʼm mʼↄŋ ↄny, ɛtŋ li bʼow lʼij ɛm e daŋku. ");
INSERT INTO adj_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ɛtŋ ↄny yɛji, bʼow ijr ɛm e daŋku aŋke anŋn ɛm ab nuŋ ↄb ɛm ɛtŋ.» ");
INSERT INTO adj_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","«Mʼam dad ↄny ów amua yecʼɛtŋ ke kʼↄ́wrmn ↄny ecʼↄmn a. ");
INSERT INTO adj_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Wɛl bʼow ogŋ ↄny Nyam nuŋ igŋ susu. Ɛtŋ ɛmɛny lɛgŋ anŋ anym am ow eke agŋ a eke bʼow ibi ↄny a bʼow tutr eke ow el Nyam juma anake -nʼam kok a. ");
INSERT INTO adj_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","-Li bʼow -li kok ɛbɛn aŋke -lʼuwm ɛm Ɛs any, ɛtŋ ɛm obi ɛm obi yɛji -lʼuwmʼm any. ");
INSERT INTO adj_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Gbɛkↄ mi dad ↄny low na yecʼɛtŋ ke lɛgŋ a eke ow bʼow ow a, ↄ́kan eke mʼikŋ anym mi dad ↄny.» «Mi dadm ↄny low na nuŋ ↄb ɛm ɛtŋ aŋke mʼanŋ ↄny ab. ");
INSERT INTO adj_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Sica mʼaam ɛgŋ a ekʼɛrmʼm a ogŋ, ɛtŋ ↄny ɛm ecʼɛgŋ kaka íbram im yogŋ a eke mʼaam a. ");
INSERT INTO adj_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nɛnɛ eke mi dad a, sos ↄw ↄny es nimum. ");
INSERT INTO adj_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Gbɛkↄ mʼam dad ↄny tasi eke ow akpl ↄny eci eke mi kʼim; tasi ɛm a, eke mʼiim, Abu Ɛlum Ɛs a kʼow owm. Kↄ eke mʼim a, mʼow mʼↄŋʼn lʼow. ");
INSERT INTO adj_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ɛtŋ lɛgŋ eke li bʼow lʼow a, li bʼow li yɛgm wus ecʼagŋ a ɛl eci wus ɛy sikpl owi ab ɛm, low nɛnyɛmbri nyam owi ab ɛm, lele Nyam e jɛj ok owi ab ɛm ab. ");
INSERT INTO adj_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","-Lʼok wus sikpl owi ɛm aŋke -lʼubmnʼm nawrɛ; ");
INSERT INTO adj_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","-lʼok wus low nɛnyɛmbri nyam owi ɛm aŋke mʼaam ɛm Ɛs ogŋ ɛtŋ -li kʼow -lʼɛknmnʼm ij; ");
INSERT INTO adj_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","-lʼok wus jɛj ok owi ɛm aŋke wus ecʼabusu ɛs a, wɛl ↄbʼr low ŋ̂. ");
INSERT INTO adj_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Sicaca ɛm a, mʼↄny ów nↄnↄ eke mi ki dad ↄny, kↄ kʼow ↄtumn irimn ij. ");
INSERT INTO adj_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Gbɛkↄ lɛgŋ a eke low nɛnyɛmbri nyam ecʼAbŋ a bʼow ow a, li bʼow ni nyimn ↄny low nɛnyɛmbri nyam fɛŋ ɛm. Li kʼow li dadm in obi e nin ɛm ecʼodad, kↄ li bʼow li dad yecʼa eke lʼiri a, ɛtŋ li bʼow lʼɛwar ↄny low yecʼeke bʼow ɛy a. ");
INSERT INTO adj_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Li bʼow lʼɛlu ɛm ecʼanygbɛl a ↄkm, aŋke li bʼow lʼot yecʼa ekʼel ɛm ecʼa, ɛtŋ li bʼow li dad ↄny ow e low. ");
INSERT INTO adj_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ɛm Ɛs ecʼob fɛŋ eke ↄny a, el ɛm eci; ow sosiɛm anake mi dad mʼɛsɛ: Abŋ bʼow eb yecʼekʼel ɛm ecʼa ɛtŋ li bʼow li dad ↄny ow e low.» ");
INSERT INTO adj_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","«Ow kʼow ibnm eke kʼow ɛknmnʼm ij, ɛtŋ ɛmɛny eke ow bʼow kok sɛgŋ waa a, bʼow ɛwal ɛkanʼm.» ");
INSERT INTO adj_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ɛtŋ in e jam ɛsɛl ab ɛm e bɛb am dad ɛl ↄfr ɛm ɛsɛ: «Ke na in e nyandrɛ el ayaf ee? Li dad ɛy eke owʼn kʼow in ibnm eke ɛs kʼow ɛs ɛknmʼn ij; ɛtŋ ɛmɛny owʼn bʼow in kok sɛgŋ waa, ɛs bʼow ɛs ɛwl ɛs ɛknʼn. Ɛtŋ ɛmɛny li dad eke in aam Ɛs ogŋ. ");
INSERT INTO adj_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sɛgŋ waa a eke nʼam dad ow ecʼodad a e nyandrɛ el bogŋ ecʼee? Low yecʼa eke nʼam erur eke li ki dad a, si kʼirim!» ");
INSERT INTO adj_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jesu am uw any eke jam ɛsɛl a am ↄl eke kʼibrmʼn low. Ow ↄŋ li dad wɛl ninɛ: «Mi dad ↄny eke ow kʼow ibnm eke kʼow ɛknmnʼm ij, ɛtŋ ɛmɛny eke ow bʼow kok sɛgŋ waa a, bʼow ɛwal ɛkanʼm. Kↄ na ecʼanake ↄny ↄfr ɛm a am ↄↄl ow e nyandrɛ ab ee? ");
INSERT INTO adj_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Ɛɛ, low nawrɛ mʼam dad ↄny: bʼow ikŋn ↄŋn kokr sↄrŋ, kↄ wus gbɛ bʼow anŋ sos ɛm iŋn ɛm; bʼow anŋn sos es ↄw ɛm, kↄ ↄny eci sos es ↄw a bʼow itŋn el sos ɛm iŋn. ");
INSERT INTO adj_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Yↄw ám ew iy a, li bʼanŋ gbre ij ɛm, aŋke in e gbre ij e lɛgŋ a ow ŋ̂. Kↄ li bʼew iy a, li bʼijl gbre ij ab es, iy a eke lʼew a eci sos ɛm eke am iŋnʼn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ɛbɛn eke sicaca ɛm a, anŋn gbre ij ɛm ana, gbɛkↄ ɛmɛny mʼow mʼɛwl mʼɛkn ↄny ɛtŋ bʼow anŋn sos ɛm iŋn ɛm; sos ɛm iŋn ikŋ na, ɛgŋ kaka kʼↄtum ebm ↄny abu ɛm. ");
INSERT INTO adj_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Eke lɛgŋ ikŋ na bʼow a, kʼow ibramnʼm low kaka fɛŋ ij. Ɛɛ, low nawrɛ mʼam dad ↄny: ob fɛŋ eke bʼow ibrmn ɛm Ɛs ɛm e nin ɛm a, li bʼow nʼↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Toŋ ke it yɛfɛnyna a, ibramn low kaka ɛm e nin ɛm. Ke ↄny e sos ɛm iŋn a ágb a, ìbrmn, bʼow ɛŋan.» ");
INSERT INTO adj_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","«Mʼoc nyandrɛ ɛm odad mi dad ↄny ów amua fɛŋ. Lɛgŋ am ow eke mi kʼow mi dadm ↄny ɛbɛn ij, kↄ yogŋ anake mʼow mi dad ↄny ɛm Ɛs e lís e low a lala ɛm a. ");
INSERT INTO adj_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Ow e lɛgŋ ab ɛm a, bʼow ibrmn ɛm Ɛs low ɛm e nin ɛm; mi dadm ↄny eke mʼow mi ŋↄŋnʼn mʼↄŋ ↄny, ");
INSERT INTO adj_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","aŋke ɛm Ɛs in obi li bʼerur ↄny. Li bʼerur ↄny aŋke bʼerurirʼm ɛtŋ bʼubr nawrɛ eke mʼanŋ Nyam ogŋ mʼow. ");
INSERT INTO adj_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mʼanŋ ɛm Ɛs ogŋ mʼow mʼɛy wus af aŋa. Sica mʼam ɛlu wus es ke mʼɛ́wl mʼim ɛm Ɛs ogŋ a.» ");
INSERT INTO adj_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","In e jam ɛsɛl a am dadʼr ɛsɛ: «Sica am dad ów a ɛrum mar, ócm odad nyandrɛ ɛm dadrm odad ij. ");
INSERT INTO adj_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sica sʼuw any eke uw low low fɛŋ any, ɛtŋ bʼikŋ anym uw low yecʼa eke wɛl kʼibrm ŋ ab any. Ɛm aŋa anake sʼub nawrɛ eke anŋ Nyam ogŋ ow a.» ");
INSERT INTO adj_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jesu dad ɛl ninɛ: «Catŋ ubr nawrɛ ee? ");
INSERT INTO adj_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ɛɛ, wanci am ow, ɛtŋ wanci a ow yɛji ŋ̂; yogŋ ↄny fɛŋ bʼow ↄmun es, ke ɛgŋ ɛgŋ ím in ogŋ ke ow ↄ́ŋ igŋn ɛlulʼm es ɛm sↄny. Njaŋ, tasi ɛm a, mʼanm ɛm sↄny aŋke ɛm Ɛs anŋ ɛm ab. ");
INSERT INTO adj_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mi dad ↄny ów amua fɛŋ yecʼɛtŋ ke ɛm ɛm a, ɛ́ŋan ɛrm es ɛy. Bʼow ijr gbre wus af aŋa, kↄ ɛrm úsu ↄny lokm aŋke mʼakm wus es.» ");
INSERT INTO adj_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Sica eke Jesu dad sodad amua bake ow uwr a, lʼigbl any ogŋ afr ɛtŋ li dad ninɛ: «Ɛm Ɛs, wanci a ow ŋ̂; ɛ̀lu Ejimŋ ecʼanygbɛl a ↄkm yecʼɛtŋ ke Ejimŋ yɛji ɛ́lu ŋ ecʼa ↄkm, ");
INSERT INTO adj_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ke nʼↄ́ŋ agŋ a eke ot abul il a sel ekʼↄnym uwr, abusu a eke ↄŋʼn agŋ e nuŋ af ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Sel ekʼↄnym uwr a el: ke wɛl úwʼŋ any, ŋ eke el Nyam nawrɛ nyam coco a, ke wɛl úw Jesu Krist eke ɛrm a yɛjʼany. ");
INSERT INTO adj_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mʼɛlu ŋ ecʼanygbɛl a ↄkm wus af aŋa, juma a eke ↄŋʼm eke mi ki kok ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sica ɛm Ɛs, anygbɛl a eke mʼɛŋn ŋ e lís gbuŋ ke wus anŋ a, ɛ̀luʼm anygbɛl ikŋ na ↄkm ŋ ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","«Wus ecʼagŋ a eke ot abulʼm a, mʼocʼŋ mi yɛgm ɛl. -Lʼel ŋ eci ɛtŋ ot abulʼm ɛtŋ -lʼↄsu ŋ ecʼodad ebl a. ");
INSERT INTO adj_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Sica -lʼuw any eke ob fɛŋ eke mʼↄny a, ŋ ogŋ ow anŋ ow, ");
INSERT INTO adj_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","aŋke mʼↄŋ ɛl odad a eke ↄŋʼm a, ɛtŋ -lʼeb. Tasi -lʼɛgŋ -lʼeb eke mʼanŋ ŋ ogŋ a mʼow, ɛtŋ -lʼub nawrɛ eke ɛrmʼm. ");
INSERT INTO adj_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Mʼam ŋↄŋnʼŋ ɛl eci; ow elm wus eci mi ŋↄŋnm, kↄ agŋ a eke abulʼm a sosiɛm aŋke -lʼel ŋ eci. ");
INSERT INTO adj_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ob fɛŋ eke mʼↄny a ŋ eci, ɛtŋ ŋ ecʼeke ↄny a yɛji el ɛm eci, ɛtŋ ɛm ecʼanygbɛl a bʼɛy ↄkm ɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mi kʼow mʼanm wus ij, kↄ ɛl gbɛ -nʼanŋ; ɛm, mʼam ow ŋ ogŋ. Ɛm Ɛs lala, ↄsu ɛl ŋ e nin a ekʼↄŋʼm ab ɛm, yecʼɛtŋ ke -lʼel nyam, ɛsɛ elel eke ɛm lele ŋ ab sʼel nyam ab af. ");
INSERT INTO adj_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Eke mʼanŋ ɛl ab a, mʼↄsu ɛl ŋ e nin ɛm, nin a eke ↄŋʼm ab ɛm. Mi bʼɛw ɛl nyamn af, ɛtŋ ɛl ɛm ecʼɛgŋ kaka iram, ekʼow elm in a cɛ ekʼit eke kʼirm, ke Nyam Lɛl a íy nɛny a. ");
INSERT INTO adj_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Sica mʼam ow ŋ ogŋ, ɛtŋ ɛmɛny eke mʼanŋ wus a, mʼam dad ɛbɛn yecʼɛtŋ ke ɛl ɛm a, -nʼɛŋn ɛm e sos ɛm iŋn a, sos ɛm iŋn a nimum. ");
INSERT INTO adj_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mʼↄŋ ɛl ŋ ecʼodad a ɛtŋ wus ↄny ɛl e sifn, aŋke -lʼelm wus eci ɛsɛ elel eke ɛm yɛji mʼelm wus ecʼab af. ");
INSERT INTO adj_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mi ŋↄŋnm eke kʼↄny ot ɛl es wus af aŋa, kↄ eke kʼↄsu ɛl Low Ŋuŋ Ɛs e lís. ");
INSERT INTO adj_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","-Lʼelm wus eci ɛsɛ elel eke mʼelm wus ecʼab af. ");
INSERT INTO adj_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Ŋ ecʼodad a el low nɛnyɛmbri nyam. Low nɛnyɛmbri nyam ab ɛm, kòk ɛl -lʼel ŋ eci kpɛkŋ kpɛkŋ. ");
INSERT INTO adj_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mʼam ɛrm ɛl wus ecʼagŋ ɛm ɛsɛ elel eke ɛm yɛji ɛrmʼm wus ecʼagŋ ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mʼam ocr ɛm sosi nimum mʼↄŋʼŋ ɛl eci, yecʼɛtŋ ke ɛl yɛji -lʼel ŋ eci kpɛkŋ kpɛkŋ.» ");
INSERT INTO adj_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","«Ow elm ɛl sↄny cɛ eci Nyam mi ŋↄŋnm kↄ agŋ a eke ɛl yɛji bʼow ubʼm nawrɛ jam ɛsɛl a eci daŋku ij ab ɛm a. ");
INSERT INTO adj_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mʼam ŋↄŋn eke ɛl fɛŋ -li kʼel nyam. Ɛm Ɛs, ow it eke -li kʼokr af ɛy ab ɛsɛ elel eke mʼanŋ ŋ ɛm ke ŋ yɛji anŋ ɛm ɛm ab af, yecʼɛtŋ ke wus ecʼagŋ a úb nawrɛ eke ow el ŋ ɛrmʼm. ");
INSERT INTO adj_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ɛtŋ mʼↄŋ ɛl anygbɛl a eke ↄŋʼm a yecʼɛtŋ ke -lʼel nyam ɛsɛ elel eke ŋ lele ɛm ab sʼel nyam ab af. ");
INSERT INTO adj_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mʼanŋ ɛl ɛm ɛtŋ ŋ yɛji anŋ ɛm ɛm; ow ɛm anake -li bʼow -lʼↄtu -lʼel nyam tasi a, yecʼɛtŋ ke wus úw any eke ɛrmʼm ɛtŋ bʼerur ɛl ɛsɛ elel eke bʼerurʼm ab af. ");
INSERT INTO adj_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ɛm Ɛs, ot ɛl ↄŋʼm, ɛtŋ mʼerur eke yogŋ a eke mʼanŋ a, ɛl yɛji -nʼanŋ ɛm ab yecʼɛtŋ ke -lʼɛkn ɛm ecʼanygbɛl a, anygbɛl a ekʼↄŋʼm a, aŋke erurʼm gbuŋ eke wɛl ki kok wus a. ");
INSERT INTO adj_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Ɛm Ɛs, Low Nyim Nyim Ɛs, wus uwmʼŋ any, kↄ ɛm mʼuwʼŋ any ɛtŋ agŋ amua uw any eke ow el ŋ ɛrmʼm. ");
INSERT INTO adj_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mʼocʼŋ mi yɛgm ɛl ɛtŋ ɛmɛny mʼow mʼocʼŋ mi yɛgm ɛl yecʼɛtŋ ke ɛm ecʼerur a eke ↄny a ánŋ ɛl ɛm, ke ɛm obi yɛji mʼánŋ ɛl ɛm.» ");
INSERT INTO adj_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Eke Jesu dad ów amua bake ow uwr a, in e jam ɛsɛl ab ab, -nʼim Sedrↄn eci mij ewl mij a e jam a. Yogŋ, egb lakp nyam anŋ eke in e jam ɛsɛl ab ab -nʼimn -lʼokr ɛm. ");
INSERT INTO adj_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas eke am ↄl Jesu ij a yɛji uw usu ab any, aŋke sakp nↄnↄ Jesu lele in e jam ɛsɛl ab ab bʼas luku yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Egb waw ɛsɛl ecʼagŋ ɛgbɛl a lele Farisiɛl ecʼogog ecʼagŋ ab ab ot srↄda eyŋ lele usu ↄsu ɛsɛl ab ↄŋ Judas, ɛtŋ lʼot wɛl ab nʼim egb lakp ab ɛm. Ar mob anŋ ɛl abu ɛm ɛtŋ -nʼↄnym es ɛkan mob lele mrabri ab. ");
INSERT INTO adj_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ɛtŋ eke Jesu uw low a fɛŋ eke bʼow ɛŋnʼn ab any a, nʼim li titm wɛl ɛtŋ nʼam ibrm wɛl lʼɛsɛ: «Kↄ bwo am ↄↄl ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","-Li dad ow ninɛ: «Nasarɛt e Jesu.» Jesu dad ɛl ninɛ: «Ɛm ana.» Ke Judas eke am ↄny Jesu ↄŋ ɛl a anŋ ɛl ab. ");
INSERT INTO adj_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Kpɛkŋ eke Jesu bi dad ɛl ekʼow el in a, -li kpukŋ -nʼim jam ɛtŋ -lʼok wus. ");
INSERT INTO adj_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ɛmɛny Jesu am ibrm ɛl ɛsɛ: «Kↄ bwo am ↄↄl ee?» -Li dad ninɛ: «Nasarɛt e Jesu.» ");
INSERT INTO adj_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jesu dad ɛl ninɛ: «Mʼikŋ anym mi dad ↄny eke ɛm ana. Eke ow el ɛm am ↄↄlʼm, ke ɛ̀gbr agŋ likpr a es im.» ");
INSERT INTO adj_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Elel eke odad a eke li dad a kʼiyr nɛny ana: «Ɛm Ɛs, mʼirmnm ŋ ecʼagŋ a eke abulʼm a e nyam yɛji.» ");
INSERT INTO adj_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Sica Simↄ Piɛr ↄny lab ler ɛm eke nʼↄnym ab a lʼↄsm es, ɛtŋ lʼiyr egb waw ɛs ligbɛl a ecʼabu ɛlum ɛs a, ɛtŋ lʼubr ow lidr e lↄru ab es. (Abu ɛlum ɛs a e nin a el Malkus.) ");
INSERT INTO adj_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Kↄ Jesu dad Piɛr ninɛ: «Òc ŋ e lab ler ɛm a ɛlu ow ecʼekpr ab ɛm. Kↄ am tutr eke mi kʼow mʼɛgŋm gbre e mij kpↄk a eke ɛm Ɛs ↄŋʼm ab ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Srↄda eyŋ a lele ɛl eci nyimn ɛs ab ab, Jwifɛl ecʼes ɛw ɛl a eci usu ↄsu ɛsɛl a okr af ↄny Jesu ɛtŋ -nʼawŋ ow. ");
INSERT INTO adj_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","-Lʼikŋ anym -lʼoc ow -nʼim An ogŋ a. An el Kayif eke lakpo ab af el egb waw ɛs ligbɛl a eci anu. ");
INSERT INTO adj_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ke Kayif anake ↄm Jwifɛl ecʼes ɛw ɛl a ów dad eke: owʼn akpl ↄny eci eke ɛgŋ nyam in kʼuw dedeku a fɛŋ ecʼa. ");
INSERT INTO adj_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simↄ Piɛr lele jam ɛs ɛjeci nyam ab am us Jesu jam. Eke jam ɛs na el ɛgŋ eke egb waw ɛs ligbɛl a uw any a, ow ↄŋ lʼɛy ow e gbugŋ a Jesu ab. ");
INSERT INTO adj_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Kↄ Piɛr gbɛ anŋ gbeŋ lisany a. Ɛtŋ jam ɛs a eke egb waw ɛs ligbɛl a uw any a ɛy ↄkm ow dad yↄw a eke am ↄsu lisany a odad ɛtŋ nʼↄŋ Piɛr yɛji ɛy gbugŋ a. ");
INSERT INTO adj_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Yↄw a dad Piɛr ninɛ: «Kↄ ŋ yɛji, elm ɛgŋ na e jam ɛsɛl ab ɛm ecʼɛgŋ nyam ee?» Piɛr dadʼr ninɛ: «Mʼelm in e jam ɛs.» ");
INSERT INTO adj_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ow el lɛfr lɛgŋ iy, ow sosiɛm anake madu a lele usu ↄsu ɛsɛl ab ab fuf al ke ok es am ↄgbu a. Piɛr yɛji anŋ ɛl ɛm ɛtŋ am ↄgbu al a. ");
INSERT INTO adj_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Egb waw ɛs ligbɛl a am ibrm Jesu low eke ↄn in e jam ɛsɛl a lele in e low yɛgm ab ab es. ");
INSERT INTO adj_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jesu dadʼr ninɛ: «Mi dad agŋ a fɛŋ ecʼany af; sɛgŋ a fɛŋ mi bi yɛgm agŋ low Nyam nuŋ igŋ susu a lele Nyamel gbɛl ɛm ab, yogŋ eke Jwifɛl fɛŋ bʼas luku a ɛtŋ mi dádm low kaka es lↄl ɛm. ");
INSERT INTO adj_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kↄ bla sosiɛm ɛtŋ am ibrm im low ee? Ìbrm agŋ a eke iri yecʼa eke mi dad ɛl a; ɛl, -lʼuw yecʼa eke mi dad ɛl ab any sɛnyn sɛnyn.» ");
INSERT INTO adj_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Eke Jesu dad nɛnɛ a, usu ↄsu ɛsɛl ab ɛm e nyam ekʼanŋ yogŋ a ɛdŋ Jesu any af ɛtŋ am dad ɛsɛ: «Kↄ ɛbɛn eke am dad egb waw ɛs ligbɛl odad ana ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jesu dadʼr ninɛ: «Eke mi dad low eke akplm, ɛ̀lu ↄkm; sica eke low a eke mi dad a akpl, ke bla sosiɛm ɛtŋ am ↄrʼm ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Ɛtŋ An ↄŋ wɛl oc Jesu eke anŋ meb ɛm a im egb waw ɛs ligbɛl Kayif ogŋ a. ");
INSERT INTO adj_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Wanci ab af cɛ, Simↄ Piɛr gbɛ anŋ yogŋ a cɛ am ↄgbu al. Wɛl am ibrmʼn ɛsɛ: «Kↄ ŋ yɛji elm ɛgŋ na e jam ɛsɛl ab ɛm ecʼɛgŋ nyam ee?» Kↄ Piɛr ɛgbr dad ninɛ: «Mʼelm in e jam ɛsɛl ab ɛm ecʼɛgŋ.» ");
INSERT INTO adj_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Egb waw ɛs ligbɛl a e madu ab ɛm e nyam, eke el ɛgŋ a eke Piɛr akpr lↄru es a ecʼɛgŋ a, dadʼr ninɛ: «Kↄ mʼɛknmʼŋ in ab egb lakp ab ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Kↄ ɛmɛny Piɛr ɛgbr. Ɛtŋ ow e wanci ab af cɛ ŋgↄs ikŋ. ");
INSERT INTO adj_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Ibribr fafa ɛm a, wɛl igŋ Kayif ogŋ a ɛtŋ oc Jesu im Pilat eke Rom ɛw Jude ecʼes ɛw ɛs a eci gbugŋ a. Jwifɛl ecʼes ɛwɛl a okm gbugŋ a bake -li kʼ uwmn anŋ, Pak ecʼob eke -li kʼↄtu -lʼij a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Ow sosiɛm Pilat ow ɛŋn ɛl gbeŋ ɛtŋ am ibrm ɛl ɛsɛ: «Kↄ bla lowi af am cicar ɛgŋ na ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","-Li dad ow ninɛ: «Blel lʼelm low ŋuŋ kok ɛs, blel sʼocmʼn sʼismʼŋ.» ");
INSERT INTO adj_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat dad ɛl ninɛ: «Òcr ir ↄny obi ke ↄny ecʼol ab ɛm, jɛ́jr in e low okr.» -Li dad ninɛ: «Sʼↄnym abusu eke si kʼↄb ɛgŋ low luw eci.» ");
INSERT INTO adj_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jesu eci luw owi a eke dad ow ecʼodad a ecʼelel eke kʼiyr nɛny ana. ");
INSERT INTO adj_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɛtŋ Pilat ɛwl ɛy gbugŋ; nʼↄŋ wɛl ɛsŋ Jesu ow ɛtŋ nʼam ibrm ow lʼɛsɛ: «Kↄ ŋ, Jwifɛl ecʼɛb ebu ab ana ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jesu dad ninɛ: «Kↄ eke tutr ŋ obi ɛtŋ am dad, oglog agŋ dadʼŋ ɛm e lís e low ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat dad ninɛ: «Kↄ ɛm Jwif mʼel ee? Ŋ ecʼɛbr ecʼagŋ lele egb waw ɛsɛl ɛgbɛl ab ocʼŋ isʼm; kↄ bla kok ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jesu dad ninɛ: «Ɛm ecʼes ɛw a elm wus na eci; blel ɛm ecʼes ɛw a el wus na eci, ke blel ɛm eci juma kok ɛsɛl a ógŋ mum. -Li kʼɛgŋmn wɛl ocm im ↄↄm Jwifɛl ecʼes ɛwɛl a. Njaŋ, ɛm ecʼes ɛw a elm wus na eci.» ");
INSERT INTO adj_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ɛtŋ Pilat dadʼr ninɛ: «Njɛ ŋ, ɛb ebu ee?» Jesu dad ninɛ: «Ŋ dad eke mʼel ɛb ebu. Ɛm, wɛl ewʼm mʼow wus af aŋa eke mi kʼij low nɛnyɛmbri nyam e daŋku. Ɛgŋ fɛŋ eke el low nɛnyɛmbri nyam ecʼa bʼiri ɛm ecʼodad.» ");
INSERT INTO adj_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat dad ninɛ: «Low nɛnyɛmbri nyam, ke bla?» Eke Pilat dad ów amua bake ow uwr a, ɛmɛny lʼɛwl nʼim gbeŋ nʼɛŋn Jwifɛl a, ɛtŋ li dad wɛl ninɛ: «Mi kʼɛknm low sosiɛm eke mi kʼↄb ɛgŋ na low a. ");
INSERT INTO adj_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Gbɛkↄ ↄny ecʼol a eke ↄnyn ab ɛm, sakp sakp fɛŋ Pak ecʼes gbɛgbl e lɛgŋ a, mi bʼɛlu ↄny sobel ɛm ɛs nyam es. Kↄ am erurir eke mi kʼɛlu Jwifɛl ecʼɛb ebu ab es mʼↄŋ ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","-Li dad ow sↄg ɛm ninɛ: «Njaŋ, ow elm in! Ɛy, Barabas sʼam erur!» Ke Barabas a ɛgŋ ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ɛtŋ Pilat ↄŋ abusu wɛl oc Jesu ow eke wɛl kʼↄrʼr ŋgbre ɛm. ");
INSERT INTO adj_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Srↄda eyŋ a ol mirŋ tufɛ ɛtŋ usʼr; -lʼus ow mob sus ɛm ebl yɛji. ");
INSERT INTO adj_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","-Lʼow -li titm ow ɛtŋ -li dad ow ninɛ: «Jwifɛl ecʼɛb ebu, sʼam ibrmʼŋ!» Ɛtŋ -nʼam dɛdŋ ow any af. ");
INSERT INTO adj_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ɛmɛny Pilat ɛwl ɛy ↄkm ɛtŋ am dad dedeku a ɛsɛ: «Mʼow mʼocʼr mʼis ↄny gbeŋ aŋa yecʼɛtŋ ke úwr any eke mʼɛŋnm low eke mi kʼↄbr ɛgŋ na low.» ");
INSERT INTO adj_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ca Jesu ɛy ↄkm; lʼus mirŋ tufɛ a lele mob sus ɛm ebl ab ab. Pilat dad ɛl ninɛ: «Kin ɛgŋ a!» ");
INSERT INTO adj_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gbɛkↄ kpɛkŋ eke egb waw ɛsɛl ecʼes ɛwɛl a lele usu ↄsu ɛsɛl ab ab ɛknʼn a, -nʼam ↄg -li dad -lʼɛsɛ: «Ɛ̀wʼr olikŋ af! Ɛ̀wʼr olikŋ af!» Pilat dad ɛl ninɛ: «Ìmn ↄny obi ɛwr ir olikŋ af, kↄ ɛm ɛm tasi a, mʼɛŋnm low kaka eke mi kʼoc mʼↄbrʼr low.» ");
INSERT INTO adj_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Jwifɛl a dadʼr ninɛ: «Ɛy sʼↄny ol, ɛtŋ ol ab ɛm lʼit eke li kʼuw, aŋke lʼurum ɛtŋ li dad ekʼin Nyam ecʼIy.» ");
INSERT INTO adj_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Eke Pilat iri sodad amua a, in eci erŋn a obn. ");
INSERT INTO adj_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Lʼɛwl lʼɛy gbugŋ ɛtŋ nʼam ibrm Jesu lʼɛsɛ: «Kↄ ŋ, bogŋ iy ee?» Kↄ Jesu cicm sar okmʼn es. ");
INSERT INTO adj_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ɛtŋ Pilat dadʼr ninɛ: «Erurm eke ki dadʼm odad ee? Kↄ uwm any eke mʼↄny abusu eke mi kʼɛluʼŋ es, ɛtŋ ɛmɛny mʼↄny abusu yɛji eke mi kʼↄŋ wɛl ɛwʼŋ olikŋ af ee?» ");
INSERT INTO adj_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jesu dadʼr ninɛ: «Ŋ obi ɛm a, ↄnym abusu kaka ɛm af eke ow elm yecʼa eke Nyam ↄŋʼŋ a. Na sosiɛm anake ɛgŋ a eke oc owʼm ŋ ogŋ a kok sikpl akm ŋ a.» ");
INSERT INTO adj_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wanci ab af cɛ Pilat am ↄl elel eke kʼɛlul Jesu es. Gbɛkↄ Jwifɛl a am ↄg dad ɛsɛ: «Eke ɛlu ɛgŋ na es, kʼow elm Sesar e lawl ij! Ɛgŋ fɛŋ eke urum ke am ocr in sosi ɛb ebu a, el Sesar ecʼifnu!» ");
INSERT INTO adj_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Eke Pilat iri sodad amua a, nʼↄŋ wɛl oc Jesu ow gbeŋ; nʼↄŋ ow ow sig es jɛj ok usu a eke wɛl bʼɛsŋ “Usu eke wɛl kok mebn ɛm” (ke Ebre ɛm wɛl bʼɛsŋ “Gabata”). ");
INSERT INTO adj_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ow el Pak ecʼes gbɛgbl a e nɛnɛgŋ krɛkrɛ a e sos bɛbm e lɛgŋ. Eke lɛgŋ am uyu nuŋ a, Pilat dad Jwifɛl a ninɛ: «Kin ↄny eci ɛb ebu a!» ");
INSERT INTO adj_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Gbɛkↄ -nʼam ↄg -li dad -lʼɛsɛ: «Wɛl íbiʼr! Wɛl íbiʼr! Ɛ̀wʼr olikŋ af!» Pilat dad ɛl ninɛ: «Kↄ ow it eke mi kʼɛw ↄny ecʼɛb ebu a olikŋ af ee?» Egb waw ɛsɛl ɛgbɛl a dad ninɛ: «Sʼↄnym ɛb ebu ɛjeci eke ow elm Sesar cɛ.» ");
INSERT INTO adj_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ɛtŋ sica Pilat ɛlu Jesu es ↄŋ ɛl eke -li kʼɛw ow olikŋ af. Ɛtŋ -nʼↄny Jesu -lʼoc ab -nʼim. ");
INSERT INTO adj_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Lʼabu in ecʼolikŋ a in obi ɛtŋ lʼɛy ↄkm baŋn a nʼim usu nyam eke wɛl bʼɛsŋ “Nuŋ kpↄk ecʼusu” (ke Ebre ɛm wɛl bʼɛsŋ “Gↄlgota”). ");
INSERT INTO adj_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yogŋ anake srↄda eyŋ a ɛw Jesu olikŋ af a. -Lʼɛw agŋ ɛjeci yony yɛji olikŋ af, ɛtŋ Jesu anŋ ɛl araŋn. ");
INSERT INTO adj_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat ↄŋ wɛl nↄn lɛl aru olikŋ a; kin ow eke wɛl nↄn: “Nasarɛt e Jesu, Jwifɛl ecʼɛb ebu”. ");
INSERT INTO adj_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Jwifɛl nↄnↄ awl lɛl a aŋke yogŋ a eke wɛl ɛw Jesu olikŋ af a titm baŋn a, ɛtŋ lɛl a eke wɛl nↄn a el Ebre ɛm, Latɛn ɛm lele Grɛk ɛm ab. ");
INSERT INTO adj_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ow ↄŋ Jwifɛl ecʼegb waw ɛsɛl ecʼes ɛwɛl a im am dad Pilat ɛsɛ: « “Jwifɛl ecʼɛb ebu a” eke wɛl nↄn a, kʼɛ̀w es, kↄ nↄn dad ɛsɛ: “Ɛgŋ na ninɛ: mʼel Jwifɛl ecʼɛb ebu”.» ");
INSERT INTO adj_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat dad ninɛ: «Ow a eke mi ki nↄn a ow mi nↄn a.» ");
INSERT INTO adj_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Eke srↄda eyŋ a ɛw Jesu olikŋ af a, -lʼoc ow eci mob sos ɛw a, ɛtŋ -li cɛc sakp yar; ɛgŋ ɛgŋ akp nyam ɛbm. -Lʼoc ow eci mob sus ɛm gbɛl a ekʼel mrumru, ke ow el ol ɛm wɛl ol a. ");
INSERT INTO adj_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Srↄda eyŋ a am dadarir ɛsɛ: «Si kʼↄnyn mob sus ɛm gbɛl na si ki gbagbrmn ɛm, kↄ si kókr sↄsum oc, sʼuwr ɛgŋ eke ow kʼel in ecʼab any.» Ow ↄŋ Nyam Lɛl a íy nɛny: -Li cɛc ɛm ecʼob sos ɛw a ɛl ↄfr ɛtŋ -li kok ɛm e mob sus ɛm gbɛl a eci sↄsum oc. Srↄda eyŋ a e low a eke kok ab ana. ");
INSERT INTO adj_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Jesu lis ena, lis lisijↄw, Klopas ɛy Mari lele Mari Magdala baŋn yↄwi ab ab anŋ olikŋ a e saw. ");
INSERT INTO adj_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Jesu ɛkn lis ɛtŋ lʼɛkn jam ɛs a eke li bʼerur a ekʼanŋ lis saw. Li dad ow ninɛ: «Ɛm lis, kin ejimŋ.» ");
INSERT INTO adj_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ɛtŋ li dad jam ɛs a ninɛ: «Kin esŋ.» Ow e lɛgŋ a ɛtŋ anake jam ɛs a eb ɛwʼr es in ogŋ a. ");
INSERT INTO adj_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Eke low na bʼɛc a, Jesu uw any eke low fɛŋ uwr ŋ̂. Ke sica Nyam Lɛl ecʼodad a íy nɛny a, li dad ninɛ: «Mij amn am ↄnyʼm.» ");
INSERT INTO adj_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Mijel nyam anŋ yogŋ eke srↄda eyŋ a eci mar anŋ ɛm, ɛtŋ -lʼoc mbra -lʼusm mar ab ɛm, -lʼoc -lʼucur likŋ ɛtŋ -lʼigŋ Jesu nɛny. ");
INSERT INTO adj_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Eke lʼɛgŋ mar a, li dad ninɛ: «Fɛŋ iy nɛny ŋ̂.» Li bʼis any es, ɛtŋ lʼok sel es. ");
INSERT INTO adj_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lɛgŋ a el nɛnɛgŋ e sos bɛbm e lɛgŋ; Jwifɛl érurm eke lɛgŋuw kʼanŋ olikŋ af nɛnɛgŋ e lɛgŋ, ɛtŋ ɛmɛny nɛnɛgŋ e lɛgŋ na yɛji el nɛnɛgŋ ligbɛl; ow sosiɛm, -lʼibrm eke Pilat kʼↄŋ wɛl bubm agŋ a eke anŋ olikŋ af a akr ke wɛl ↄ́ny ot ɛl es. ");
INSERT INTO adj_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Srↄda eyŋ a im ɛtŋ bubm agŋ a eke wɛl ɛw olikŋ af Jesu ab a akr. ");
INSERT INTO adj_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Eke -li bʼok Jesu ogŋ a, -lʼɛkn eke ow uw ŋ̂; ow sosiɛm anake -li bubam ow akr a. ");
INSERT INTO adj_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Gbɛkↄ srↄda eyŋ ab ɛm e nyam oc in eci mpragb a igŋ Jesu mɛnɛgb ɛm ɛtŋ kpɛkŋ mebl lele mij ab am ok es. ");
INSERT INTO adj_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ɛgŋ a ekʼam ij ów amua e daŋku a ɛkn ów a ɛtŋ in e daŋku ij a el nawrɛ; in, lʼuw any eke low nawrɛ nʼam dad. Nʼam ij ow e daŋku yecʼɛtŋ ke ↄny yɛji úbr nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Tasi ɛm a, ów amua ɛy yecʼɛtŋ ke Nyam Lɛl ecʼodad a íy nɛny: Wɛl kʼow ubmʼn luw kaka es. ");
INSERT INTO adj_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ɛtŋ ɛmɛny Nyam Lɛl ɛjecʼam dad ɛsɛ: -Li bʼow -li lɛr ɛgŋ a eke -lʼupar mɛnɛgb ɛm a. ");
INSERT INTO adj_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ów amua bʼɛc a, Josɛf, Arimate baŋn iy a ow ibrm Pilat abusu eke kʼoc Jesu eci sos megl a. Ke Josɛf a, Jesu eci jam ɛs kↄ es lↄl ɛm, aŋke li bʼuru Jwifɛl ecʼes ɛwɛl a. Pilat ↄŋʼn abusu lʼoc Jesu eci sos megl ab ab nʼim. ");
INSERT INTO adj_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodɛm a eke ncok nyam im ɛŋn Jesu a yɛji ow. Lʼism kpey eke wɛl wuwlm mijey ɛjecʼab ke ow eci leg a ↄtu eke kʼij kilo likŋ lele lɛw ab. ");
INSERT INTO adj_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Agŋ a yony mum oc Jesu eci sos megl a, ok sɛkp sŋↄsŋↄ sigbad og ab af ɛtŋ oc wiwrmʼn sos ab ɛsɛ elel eke Jwifɛl bi kok ɛgŋ es oc ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Usu a eke wɛl ɛw Jesu olikŋ af a, egb lakp nyam anŋ; ɛm yogŋ, uwↄmu owr nyam anŋ eke wɛl ocm ɛgŋ es ɛm. ");
INSERT INTO adj_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Eke ow el Jwifɛl a eci nɛnɛgŋ eci sos bɛbm e lɛgŋ, ke uwↄmu a yɛji titm a, -lʼoc ow es ɛm yogŋ. ");
INSERT INTO adj_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Dimas ibribr fafa a, ekʼusu kʼotm es a, Mari, Magdala yↄwi a im uwↄmu ab af. Lʼɛkn uwↄmu nɛny a eci lob a ekʼoc es anŋ saw. ");
INSERT INTO adj_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ow ↄŋ lʼuru es nʼim nʼɛŋn Simↄ Piɛr lele jam ɛs a eke Jesu bʼerur ab ab, ɛtŋ li dad wɛl ninɛ: «Wɛl ↄny Ɛgŋ gbɛl a oc es uwↄmu ab ɛm, ɛtŋ sʼuwm yogŋ eke wɛl oc ɛwʼr ab any.» ");
INSERT INTO adj_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ɛtŋ Piɛr lele jam ɛs yecʼab ab im yogŋ a eke uwↄmu a anŋ a. ");
INSERT INTO adj_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Agŋ a yony mum okr af am uru es im, gbɛkↄ jam ɛs yecʼa uru es fafa akm Piɛr ɛtŋ ikŋ anym im ok uwↄmu ab af. ");
INSERT INTO adj_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Lʼis es li lɛr uwↄmu ab ɛm, ɛtŋ lʼɛkn sigbad og eke ok es wus, kↄ lʼɛym uwↄmu ab ɛm gbɛ. ");
INSERT INTO adj_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simↄ Piɛr eke am usʼr jam a yɛji im ok yogŋ ɛtŋ ɛy uwↄmu ab ɛm. Lʼɛkn sigbad og eke ok es wus yogŋ, ");
INSERT INTO adj_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","lele gbad a eke wiwrm Jesu nuŋ ab a; gbad na anm sigbad og ab ab, kↄ wɛl ar es ɛw es usu ɛjeci. ");
INSERT INTO adj_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ɛtŋ jam ɛs ɛjecʼa, in a eke ikŋ anym im uwↄmu ab af a yɛji ɛy uwↄmu ab ɛm. Lʼɛkn ɛtŋ lʼub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","(Ke tasi ɛm a, toŋ wanci ab af a, jam ɛsɛl a kʼirim Nyam Lɛl ecʼodad ekʼam dad eke Jesu in bʼow in igb agŋ ekʼin uw ab ɛm a e low.) ");
INSERT INTO adj_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Ɛtŋ jam ɛsɛl yony a ɛwl im ɛl ogŋ a. ");
INSERT INTO adj_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari anŋ gbeŋ uwↄmu a saw, ɛtŋ am ikŋ ↄŋn. Ɔŋn ikŋ ab ab, lʼis any es eke li kʼɛkn uwↄmu ab ɛm; ");
INSERT INTO adj_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","lʼɛkn afr ɛrm ɛsɛl yony eke sus mob efu ok es usu a eke wɛl ɛw Jesu eci sos megl a: nyam anŋ nuŋ af ɛtŋ nyam anŋ akr esr a. ");
INSERT INTO adj_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Afr ɛrm ɛsɛl a am ibrmʼn ɛsɛ: «Yↄw, kↄ bla ɛtŋ am ikŋ ↄŋn ee?» Li dad wɛl ninɛ: «Wɛl ↄny ɛm Ɛgŋ gbɛliy oc es ɛtŋ mʼuwm yogŋ eke wɛl ɛwʼr es ab any.» ");
INSERT INTO adj_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Eke nʼam dad ɛbɛn a, lʼɛwl sos mɛny ɛtŋ lʼɛkn Jesu ekʼanŋ yogŋ, kↄ lʼuwm any eke ow el ow. ");
INSERT INTO adj_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jesu ibrmʼn ninɛ: «Yↄw, kↄ bla ɛtŋ am ikŋ ↄŋn ee? Kↄ bwo am ↄl ee?» Nʼam tutr eke ow el egb lakp a eci juma kok ɛs a, na sosiɛm li dad ow ninɛ: «Ɛgŋ gbɛl, eke ow el ŋ ocʼr ab im, ke yɛ̀gmʼm usu eke ɛwʼr a, ke mʼím mʼocʼr.» ");
INSERT INTO adj_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jesu ɛsŋʼn: «Mari!» Lʼɛwl sos mɛny ɛtŋ li dad ow Ebre ɛm ninɛ: «Rabuni!» (ekʼel nyandrɛ ɛm “Low yɛgm agŋ ɛs”). ");
INSERT INTO adj_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jesu dadʼr ninɛ: «Njaŋ, kʼùcu kʼↄnyʼm es! Mi kʼiim ɛm Ɛs ogŋ a, kↄ ìm dad ɛm lisijimɛl a eke mʼaam ɛm Ɛs a eke ↄny yɛji el ↄny Ɛs a ogŋ, mʼaam ɛm e Nyam a eke ↄny yɛji el ↄny e Nyam a ogŋ.» ");
INSERT INTO adj_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Ɛtŋ Mari, Magdala yↄwi a im ɛŋn jam ɛsɛl a ɛtŋ am ↄb ɛl amani dad ɛsɛ: «Mʼɛkn Ɛgŋ gbɛl a!» Ɛtŋ nʼam dad wɛl low yecʼa eke ow dadʼr a. ");
INSERT INTO adj_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Dimas a cɛ eci ncebles a, jam ɛsɛl a as luku êl nyam ɛm. -Li babl masany a fɛŋ safuɛ ɛm aŋke -nʼam uru Jwifɛl ecʼes ɛwɛl a. Jesu ɛy ↄkm ɛl ecʼaraŋn inym es ɛtŋ am dad ɛl ɛsɛ: «Ɛrm ɛs ɛy ánŋ ↄny ab!» ");
INSERT INTO adj_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Li bʼok odad ab es a, nʼam yɛgm wɛl in e sabu a lele in eci mɛnɛgb ɛm ab ab. Jam ɛsɛl a sos ɛm am iŋn, Ɛs Kↄtↄkↄ eke -lʼɛkan a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ɛmɛny Jesu am dad ɛl ɛsɛ: «Ɛrm es ɛy ánŋ ↄny ab! Ɛsɛ elel eke ɛm Ɛs ɛrmʼm ab af a, ɛm yɛji mʼam ɛrm ↄny.» ");
INSERT INTO adj_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Sodad amua bʼuwr a, li fuf wɛl sel ɛtŋ li dad wɛl ninɛ: «Ɛ̀ŋan Abŋ Lala! ");
INSERT INTO adj_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Agŋ a eke bʼow ocr sikpl apr a, bʼow ɛŋn oc ap; agŋ a eke kʼow ocmn sikpl apmn a, kʼow ɛŋnm oc ap.» ");
INSERT INTO adj_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Lɛgŋ a eke Jesu ow ɛl ecʼaraŋn a, jam ɛsɛl lɛw yony ab ɛm ecʼɛgŋ nyam, Toma (eke wɛl igŋ nin af Oli a) anm ɛl ab. ");
INSERT INTO adj_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Jam ɛsɛl ɛjecʼa am dadʼr ɛsɛ: «Sʼɛkn Ɛs Kↄtↄkↄ!» Kↄ Toma dad ɛl ninɛ: «Eke mʼɛknm ecigbrↄ ɛnyɛmbri in e sabu araŋn a, eke mʼocm ɛm ecʼabuli a mʼɛlum ecigbrↄ a ecʼↄmu a eke kok ab ɛm, ɛtŋ mʼocm ɛm ecʼabu a mʼujrmʼn mɛnɛgb ɛm, mi kʼow mʼubm nawrɛ.» ");
INSERT INTO adj_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Dimas gber mum bʼɛc a, ɛmɛny Jesu eci jam ɛsɛl a as luku êl ab ɛm, ɛtŋ na ecʼa, Toma yɛji anŋ ɛl ɛm. Wɛl babl mel a safuɛ ɛm, kↄ Jesu ɛy ↄkm inym es ɛl ecʼaraŋn ɛtŋ am dad ɛsɛ: «Ɛrm es ɛy ánŋ ↄny ab!» ");
INSERT INTO adj_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Ɛtŋ li dad Toma ninɛ: «Ɛ̀w ŋ ecʼabuli a aŋa ke lɛ́r ɛm e sabu a; ɛ̀gŋm ŋ ecʼabu ab es ujrʼm mɛnɛgb ɛm. Kì bɛbar, kↄ ùb nawrɛ.» ");
INSERT INTO adj_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Toma dadʼr ninɛ: «Ɛm Ɛs Kↄtↄkↄ ɛm e Nyam!» ");
INSERT INTO adj_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jesu dadʼr ninɛ: «Eke ɛknʼm a anake ub nawrɛ ab ee? Ehe bʼow el agŋ a eke kʼow ɛknm im ke bʼow ubʼm nawrɛ a eci!» ");
INSERT INTO adj_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesu kok mɛny ɛwr nↄnↄ jam ɛsɛl a ecʼany af eke wɛl dadm ow ecʼodad lɛl na ɛm. ");
INSERT INTO adj_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Gbɛkↄ yecʼa eke anŋ lɛl na ɛm a, wɛl nↄn yecʼɛtŋ ke úbr nawrɛ eke Jesu el Mesi, Nyam ecʼIy. Ɛtŋ eke bʼↄnyn ↄmn in ɛm a, bʼow ɛŋan sel in ɛm. ");
INSERT INTO adj_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Eke sɛgŋ bɛb ɛc a, ɛmɛny Jesu okm sos ↄkm yɛgm in e jam ɛsɛl a, Tiberiad eci mij lekpl a e nanu a. Kin elel eke Jesu okm sos ↄkm a: ");
INSERT INTO adj_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simↄ Piɛr, Toma (eke wɛl igŋ nin af Oli a), Natanaɛl (Kana baŋn Galile wus af ecʼa), Sebede ecʼey a, lele Jesu eci jam ɛsɛl ɛjeci yony ab anake anŋ usu nyam a. ");
INSERT INTO adj_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simↄ Piɛr dad ɛl ninɛ: «Mʼaam mij af.» -Li dad ow ninɛ: «Ɛy yɛji sʼam ow ŋ ab.» -Nʼim -lʼok mijɛtŋ ab ɛm ɛtŋ -nʼim mij af. Gbɛkↄ ncok a gbɛ, -nʼↄnym ↄcn kaka. ");
INSERT INTO adj_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Eke lɛgŋ am ɛny ow a, Jesu inym es nanu yogŋ, kↄ jam ɛsɛl a uwm any eke ow el in. ");
INSERT INTO adj_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Ɛtŋ Jesu dad ɛl ninɛ: «Ɛm jimɛl, kↄ ↄnyn ↄcn tɛl ee?» -Li dad ow ninɛ: «Njaŋ o.» ");
INSERT INTO adj_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Li dad wɛl ninɛ: «Òkr muw a mijɛtŋ a eci lidr ogog a, bʼow ↄnyn ↄcn.» -Lʼok muw a, ɛtŋ -lʼↄtumn -nʼↄnymn -lʼɛlumn ↄkm mij ab ɛm aŋke ↄcn nↄnↄ iy ɛm. ");
INSERT INTO adj_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Jam ɛs a eke Jesu bʼerur a dad Piɛr ninɛ: «Ɛgŋ a Ɛs Kↄtↄkↄ!» Eke Simↄ Piɛr iri eke ɛgŋ a Ɛs Kↄtↄkↄ a, lʼus in e mob sus ɛm a eke nʼↄny lʼoc es a, ɛtŋ lʼɛy mij ab ɛm. ");
INSERT INTO adj_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Jam ɛsɛl likpr a am ↄdu muw a eke ↄcn iy ɛm a, ɛtŋ -nʼam owr nanu eci mijɛtŋ ab ɛm. -Lʼibnm nanu ab; ow ↄtu eke kʼij abu ekŋ yen. ");
INSERT INTO adj_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Eke -li bʼus es wus a, yogŋ -lʼɛkn malel eke wɛl ok ↄcn lele futufutu ab es af. ");
INSERT INTO adj_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jesu dad ɛl ninɛ: «Òtr ↄcn a eke caca ↄnyn a eci bɛb owr.» ");
INSERT INTO adj_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simↄ Piɛr ɛwl ɛy mijɛtŋ ab ɛm, ɛtŋ usm muw a eke ↄcn ɛgbɛl nↄnↄ anŋ ɛm ab es. Ɔcn a ij ekŋ lↄbŋ lele lɛw lele nyahan ab. Ɔcn a ekʼiy ɛm a bↄbↄ yɛji, ↄↄm muw a gbagbram es. ");
INSERT INTO adj_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jesu dad ɛl ninɛ: «Òwr ijr ob.» Jam ɛsɛl ab ɛm ecʼɛgŋ kaka ócm any tuↄtuↄ ɛm dadm ɛsmɛ: «Kↄ ŋ, bwo elʼŋ ee?» Tasi ɛm a, -lʼuw any sɛnyn sɛnyn eke Ɛs Kↄtↄkↄ ana. ");
INSERT INTO adj_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Jesu kpukŋ im ɛŋn ɛl, oc futufutu a ɛtŋ cɛc ɛl; nʼↄŋ wɛl ↄcn a yɛji. ");
INSERT INTO adj_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Luw ɛm a eke Jesu igb a ɛtŋ a, sakp nyahan ɛm eke nʼam yɛgm in e jam ɛsɛl a sos ana. ");
INSERT INTO adj_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Eke -lʼijr ob ow uwr a, Jesu ibrm Simↄ Piɛr ninɛ: «Jan jim Simↄ, kↄ ɛm eci erur a eke ↄny a agb akm agŋ amua ecʼa ee?» Li dad ninɛ: «Ɛɛ, Ɛs Kↄtↄkↄ, mi bʼerurʼŋ, uw any.» Jesu dadʼr ninɛ: «Ɔ̀su ɛm e mɛcɛb ey a.» ");
INSERT INTO adj_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Ɛmɛny lʼibrm ow sakp yony ɛm ninɛ: «Jan jim Simↄ, kↄ erurʼm ee?» Li dad ninɛ: «Ɛɛ, Ɛs Kↄtↄkↄ, mi bʼerurʼŋ, uw any.» Jesu dadʼr ninɛ: «Ɔ̀su ɛm e mɛcɛb a.» ");
INSERT INTO adj_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Ɛmɛny lʼibrm ow sakp nyahan ɛm ninɛ: «Jan jim Simↄ, kↄ erurʼm ee?» Piɛr sos ↄw es eke Jesu kʼibrmʼn odad nyam a cɛ sakp nyahan. Ɛtŋ li dad ow ninɛ: «Ɛs Kↄtↄkↄ, ŋ uw low fɛŋ any; uw any eke mi bʼerurʼŋ!» Jesu dadʼr ninɛ: «Ɔ̀su ɛm e mɛcɛb a. ");
INSERT INTO adj_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Ɛɛ, low nawrɛ mʼam dad ↄny: eke anŋ ŋgbafrɛ a, ŋ obi bi sus ŋ e mob, ɛtŋ bʼim yogŋ eke bʼerur a; gbɛkↄ susu bʼowʼŋ sos a bʼow gɛgŋm sabu es, ɛgŋ ɛjeci bʼow susʼŋ mob ɛtŋ bʼow oc im ŋ yogŋ eke kʼow erurm eke kʼim a.» ");
INSERT INTO adj_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sodad amua ɛm, Jesu am yɛgm Piɛr ecʼelel eke bʼow uwr ke ow ɛm nʼↄ́ŋ Nyam anygbɛl a. Sica Jesu dadʼr ninɛ: «Ùsʼm jam!» ");
INSERT INTO adj_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piɛr bʼɛdŋ sos mɛny a, lʼɛkn jam ɛs a eke Jesu bʼerur a ekʼanŋ ɛl jam. (Ke ɛgŋ a eke ub nuŋ ɛw Jesu af, ob ij lↄfu lís a eke -nʼanŋn, ke am ibrmʼn ɛgŋ a eke bʼow ↄlʼl ijʼr a e low a, in ana.) ");
INSERT INTO adj_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piɛr ɛknʼn ɛtŋ dad Jesu ninɛ: «Ɛs Kↄtↄkↄ, ɛtŋ kↄ in, bla lowi bʼow ɛŋnʼn ee?» ");
INSERT INTO adj_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jesu dadʼr ninɛ: «Ɛtŋ eke mʼerur eke li kʼanŋ owr toŋ ke mʼɛ́wl mʼow, ke ŋ e low ee? Ŋ ecʼa, ùsʼm jam cɛ!» ");
INSERT INTO adj_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Amani a eb es agŋ lisijimɛl ab ɛm eke jam ɛs na in kʼow in uwm ij. Ke tasi ɛm a, Jesu dadm Piɛr eke owʼn kʼow in uwm, kↄ li dad: ɛtŋ eke in erur eke owʼn kʼanŋ owr toŋ ke in ɛ́wl in ow, ke ow e low ee? ");
INSERT INTO adj_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Jam ɛs nyam na cɛ anake am ij ów amua e daŋku ke nↄn yɛjʼa, ɛtŋ sʼuw any eke in e daŋku ij a el nawrɛ. ");
INSERT INTO adj_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Ɛmɛny Jesu kok ów ɛjeci nↄnↄ. Blel wɛl am nↄn ów amua nyam nyam, ke ɛm e tutr ɛm a, blel yecʼa eke wɛl nↄn a íy wus na nimum wal es.");
INSERT INTO adj_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ɛgŋ gbɛl Teofil, ɛm eci lɛl krɛkrɛ ab ɛm, mi dad ów a fɛŋ eke Jesu kok, ke yɛgm nuŋ ↄb ɛm ɛtŋ ");
INSERT INTO adj_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","toŋ igŋ lɛgŋ a eke Nyam oc imʼn afr a. Gbuŋ ke lʼúyu afr a, agŋ a eke li sↄsum lʼot ɛsɛ ɛrm ɛsɛl af a, nʼↄŋ wɛl sol Abŋ Lala ecʼabusu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Tasi ɛm a, in e luw a e jam a, lʼɛlu sos ↄkm li yɛgm in ecʼɛrm ɛsɛl a sakp ɛrŋ ɛrŋ ɛm eke nʼanŋ owr. Sɛgŋ ekŋ yony ɛtŋ eke lʼɛlu sos ↄkm li yɛgm wɛl, ke li dad wɛl Nyam e gbreŋgbi usu a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Lɛgŋ nyam, eke nʼam ij ob wɛl ab a, lʼijl wɛl nɛny ninɛ: «Kì kpabr es Jerusalɛm e lís, kↄ ànŋn low a ekʼɛm Ɛs ɛwar ↄny a, ob ap a eke mi dad ↄny ow e low a ecʼeku ɛm: ");
INSERT INTO adj_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jan ok agŋ mij nuŋ mij ɛm, kↄ ↄny, lɛgŋ tɛl ɛm, wɛl bʼow ok ↄny mij nuŋ Abŋ Lala ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Ɛrm ɛsɛl a ekʼɛlul Jesu ɛm a ibrmʼn ninɛ: «Ɛs Kↄtↄkↄ, kↄ lɛgŋ na ɛm anake bʼow ɛwl sigm Israɛl ecʼes ɛw ab es ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jesu dad ɛl ninɛ: «Ow elm ↄny itmn eke kʼuwr sɛgŋ a lele wanci ab ab e low any, kↄ ɛm Ɛs bɛbm ɛw es in obi ecʼabusu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Gbɛkↄ ↄny bʼow ɛŋan lɛc nyam lɛgŋ a ekʼAbŋ Lala bʼow us ↄny es nuŋ af a. Ɛtŋ ↄny bʼow eel ɛm ecʼadaŋku, dadr ɛm ecʼodad Jerusalɛm, Jude e wus a nimum af lele Samari ab, toŋ okr wus e nuŋ.» ");
INSERT INTO adj_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Eke li dad ów amua uwr ke -nʼam lɛr ow a, Jesu am uyu afr, ɛtŋ jru ow ɛdŋn ɛl any. ");
INSERT INTO adj_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Eke ɛrm ɛsɛl a ecʼany a kↄkŋ afr cɛ ke -nʼam lɛr yogŋ a eke Jesu am uyu im a, kpɛkŋ agŋ yony eke sus mob efu anŋ ɛl any af ");
INSERT INTO adj_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","ɛtŋ dad ɛl ninɛ: «Galile ecʼagŋ, bla sosiɛm ɛtŋ iymn es aŋa am lɛɛr afr ee? Jesu na eke ŋgboŋ ↄny ecʼaraŋn aam afr a, bʼow ɛwl mɛny ow elel a cɛ eke ɛkan in nʼaam a.» ");
INSERT INTO adj_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Sica ɛrm ɛsɛl a anŋ lafɛny eke wɛl bʼɛsŋ Olivie lafɛny a ogŋ, ɛtŋ ɛwl mɛny ow Jerusalɛm. Lafɛny a, baŋn a e saw cɛ ow anŋ: yogŋ lele baŋn ab ab kilo nyam cɛ. ");
INSERT INTO adj_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Eke -lʼowr -lʼokr Jerusalɛm a, -lʼuyu -nʼim êl afr a eke -li bʼanŋ sɛgŋ fɛŋ a. Kin ɛrm ɛsɛl a ekʼanŋ yogŋ a ecʼen: Piɛr, Jan, Jak lele Andre ab, Filip lele Toma ab, Bartelemi lele Matie ab, Jak ekʼel Alfe jim, Simↄ ɛb dogŋn ɛs lele Jud ekʼel Jak jim ab. ");
INSERT INTO adj_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ɛl lele ↄyↄw a lele Jesu lis Mari lele Jesu lisijimɛl ab ab sɛgŋ fɛŋ -li bʼas luku usu nyam -ni ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Sɛgŋ ab ɛm e nyam ɛm, ↄmn ɛsɛl ekʼↄtu eke kʼij agŋ ekŋ nↄhↄn as luku. Piɛr igb ɛl ecʼaraŋn ɛtŋ dad ɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Agŋ lisijimɛl, ow it eke yecʼa ekʼAbŋ Lala dad Nyam e Lɛl ɛm a kʼiy nɛny. Lʼikŋ anym lʼɛcr David ɛm, lʼɛwar Judas eke nyimn agŋ a ekʼɛdŋn Jesu a e lís e low. ");
INSERT INTO adj_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Ke Judas yɛji, ɛy ɛrm ɛsɛl ab ɛm e nyam ekʼin yɛji ↄny in eci juma. ");
INSERT INTO adj_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ɛtŋ in eci low ŋuŋ e li kok a eci labm eke wɛl sↄgʼr ab ɛm, lʼↄl ↄgm nyam, ɛtŋ yogŋ nʼanŋ afr lʼɛy wus nuŋ nuŋ lʼↄb lok es ɛtŋ in e sugŋ a fɛŋ ok ↄkm. ");
INSERT INTO adj_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Jerusalɛm ecʼagŋ a fɛŋ iri low na, ow sosiɛm ɛl ecʼɛbr ab ɛm -lʼɛsŋ ↄgm a “Akɛldama”, ekʼel nyandrɛ ɛm “Mebl ecʼↄgm”. ");
INSERT INTO adj_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Ɛtŋ Selu e lɛl ab ɛm kin yecʼeke wɛl nↄn: Ke in ecʼêl a ɛ́ru es ↄfr, ke ɛgŋ kaka kʼírm ɛm. Ɛtŋ ɛmɛny wɛl nↄn: Ke ɛgŋ ɛjeci úsrʼr usu in eci juma ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","Ow sosiɛm, ow akpl ekʼɛgŋ nyam kʼow akr ɛy af ij Ɛs Kↄtↄkↄ Jesu e luw ɛm anŋ igb a e daŋku. Ke ɛgŋ a él agŋ a eke bʼanŋ ɛy ab sɛgŋ fɛŋ, usu a fɛŋ eke sʼɛc Ɛs Kↄtↄkↄ Jesu ab a ecʼɛgŋ nyam, lɛgŋ a ɛtŋ eke Jan okʼr mij nuŋ a toŋ ke igŋ lɛgŋ a eke nʼŋgboŋ ɛy ecʼaraŋn nʼim afr a.» ");
INSERT INTO adj_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Wɛl ok agŋ yony ↄkm ɛl ecʼaraŋn: Josɛf eke wɛl bʼɛsŋ Barsabas ke wɛl bʼok en es Justus, lele Matias ab. ");
INSERT INTO adj_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ɛtŋ dedeku a nimum ŋↄŋn Nyam dad ninɛ: «Ɛs Kↄtↄkↄ, ŋ eke uw agŋ fɛŋ ecʼɛrm ab any a, yɛ̀gm ɛy ɛl yony na ɛm ecʼɛgŋ eke sↄsum oc ");
INSERT INTO adj_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","eke kʼel ɛrm ɛs, ke ídr juma a eke Judas igŋ ɛlu es im usu a ekʼel in ecʼa.» ");
INSERT INTO adj_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","-Li kok sↄsum oc ɛtŋ ow ɛy Matias af; ɛtŋ lʼɛy ɛrm ɛsɛl lɛw nyam a ecʼeb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Eke Pantekↄt ecʼes gbɛgbl e lɛgŋ ow a, ↄmn ɛsɛl a fɛŋ as luku usu nyam. ");
INSERT INTO adj_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kpru ɛm, likekr ligbɛl nyam anŋ afr ow. Likekr a anŋ ɛsɛ lɛf ligbɛl eke bʼɛlu ab af, ɛtŋ ow eb akŋ a nimum eke -nʼanŋ a. ");
INSERT INTO adj_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Kpɛkŋ -lʼɛkn mob ekʼanŋ ɛsɛ sanm al af eke ok ↄkm; -li kpakpab es ɛtŋ -nʼim -li sisig es ɛgŋ nyam nyam e nuŋ af. ");
INSERT INTO adj_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Kpɛkŋ Abŋ Lala iy ɛl fɛŋ ɛm, ɛtŋ -nʼam dad odad sɛbr ɛjecʼɛm ɛsɛ elel eke Abŋ Lala am ↄŋ ɛl eke -li ki dad ab af. ");
INSERT INTO adj_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ke Jwifɛl ekʼanŋ susu susu a ow ir Jerusalɛm; -lʼel Nyam nuŋ igŋ ɛsɛl tasi. ");
INSERT INTO adj_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Eke likekr a ikŋ wɛl iri a, -lʼuru es -lʼow -lʼas luku. Ɛl fɛŋ low am at ɛl sel afŋn es, aŋke ɛl ɛm ecʼɛgŋ fɛŋ am iri ↄmn ɛsɛl a dad odad in ecʼɛbr ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ɛl fɛŋ low am iti ɛl any ɛtŋ am iŋn ɛl sos ɛm. -Nʼam dad -lʼɛsɛ: «Agŋ amua fɛŋ ekʼam dad sodad a, kↄ -lʼelm Galile ecʼagŋ ee? ");
INSERT INTO adj_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ɛtŋ sica ayaf ɛtŋ ɛy ɛm ecʼɛgŋ fɛŋ am iri -li dad odad in ecʼɛbr eke wɛl ewʼr ow ɛm ab ee? ");
INSERT INTO adj_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ɛy ecʼaraŋn a, agŋ anŋ Part, Medi lele Elam wus af ab ow: bɛb anŋ Mesopotami, Jude, Kapadↄs, Pↄŋ lele Azi wus af ab ow; ");
INSERT INTO adj_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","bɛb yɛji anŋ Friji, Panfili, Ejipt lele Sirɛn e wus ikpr ekʼanŋ Libi ab ab ow. Ɛtŋ agŋ anŋ Rom yɛji ow, ");
INSERT INTO adj_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","(Rom ecʼagŋ eke mew ɛm ɛtŋ el Jwif, lele agŋ ekʼɛgŋ ɛl eci Nyam nuŋ igŋ a e low eb ab ab), Krɛt ecʼagŋ lele Arabi eyŋ ab. Ɛtŋ kin eke sʼam iri -nʼam dad Nyam ecʼów ɛgbɛl eke kok a ɛy e sɛbr ab ɛm!» ");
INSERT INTO adj_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ɛl fɛŋ -nʼanŋ low any iti ligbɛl ɛm, ɛtŋ -lʼuwmn low eke -li ki tutr any. -Nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Ke na, ow e nyandrɛ el bogŋ ecʼee?» ");
INSERT INTO adj_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Gbɛkↄ agŋ bɛb am kokr ↄmn ɛsɛl a miyɛr dad ɛsɛ: «-Lʼɛgŋ mar am ↄny ɛl!» ");
INSERT INTO adj_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Sica Piɛr ekʼanŋ ɛrm ɛsɛl lɛw nyam ab ab a, igb inym es ɛtŋ lebl tuↄtuↄ ɛm am dad dedeku a ɛsɛ: «Ɔny Jwifɛl lele agŋ a fɛŋ ekʼir Jerusalɛm ab ab, ow it eke kʼuwr low ekʼam ɛy ab any, ke ígŋn lↄru es irir yecʼa eke mʼow mi dad a. ");
INSERT INTO adj_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Agŋ amua ow elm mar ↄnym ɛl ɛsɛ elel ekʼam tutar ab af, aŋke sʼanŋ ibribr e wanci libarm ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Gbɛkↄ sica low a eke kokoba ↄb ɛs Joɛl dad a ɛy tasi ŋ̂. ");
INSERT INTO adj_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kin low eke Nyam dad eke bʼow ɛy sɛgŋ es abal el ɛm a: Mi bʼow mʼↄmun ɛm ecʼAbŋ ab es agŋ a fɛŋ af; ↄny ecʼey egŋ a lel ey ↄyↄw ab ab bʼow ↄb ɛm e kokoba, ↄny eci ŋgbafrɛ a bʼow ɛkan nuŋ ɛm, ɛtŋ ↄny ecʼagŋ esu a bʼow ɛkn ów mɛmn ɛrur ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ɛɛ, sɛgŋ amua ɛm, mi bʼow mʼↄmun ɛm ecʼAbŋ ab es ɛm eci juma kok ɛsɛl a lele juma kok lisɛl ab ab af, ɛtŋ -li bʼow -lʼↄb ɛm e kokoba. ");
INSERT INTO adj_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mi bʼow mi kok ów ɛgbɛl nↄnↄ afr, ɛtŋ mi bʼow mi kok mɛny ɛwr owi nↄnↄ wus aŋa. Mebl, al, lele mregbn eke anŋ ɛsɛ jru af bʼow anŋ ɛm, ");
INSERT INTO adj_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ligbn bʼow irmn in ecʼafŋ a, ɛtŋ awl bʼow ebl es kondoŋ ɛsɛ mebl af, gbuŋ ke Ɛs Kↄtↄkↄ e lɛgŋ a ów, anygbɛl e lɛgŋ ligbɛl a. ");
INSERT INTO adj_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ɛtŋ ɛgŋ kaka fɛŋ eke bʼow ɛsŋ Ɛs Kↄtↄkↄ e nin a, bʼow ɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Israɛl ecʼagŋ, ìgŋn lↄru es irir low a eke mʼam mʼow mi dad a: Nyam yɛgm ↄny eke nʼↄŋ Nasarɛt e Jesu in eci abusu a. Nawrɛ ɛm a, Nyam ɛcr in ɛm kok sakrowa nↄnↄ ↄny ecʼaraŋn, li kok ów ɛgbɛl nↄnↄ eke bʼiti any, lele mɛny ɛwr owi ab; ↄny uwr any yɛji. ");
INSERT INTO adj_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ɛgŋ ikŋ na, wɛl ɛluʼl es ↄŋ ↄny ɛsɛ elel eke Nyam tutr ke ikŋ anym bɛbm ow e low ɛw es ab af. Ɛtŋ ↄny, ibir ir olikŋ af eke ↄŋn agŋ ekʼuwm Nyam any a ɛwʼr ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Gbɛkↄ Nyam igbmʼn luw ɛm, nʼↄny lʼoc ow es luw e gbre ijr ab ɛm, aŋke ow itm eke luw ecʼabusu a kʼucu ↄnyʼn es. ");
INSERT INTO adj_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Tasi ɛm a, kin yecʼeke David dad in e lís: Sɛgŋ fɛŋ mʼam ɛkn Ɛs Kↄtↄkↄ ɛm ecʼany af, nʼanŋʼm saw yecʼɛtŋ ke mi kí mumum. ");
INSERT INTO adj_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Na sosiɛm, ɛm ecʼɛrm sos ɛm am iŋn, ɛtŋ ɛm e nɛny am ɛgŋ ehe ecʼɛj. Ɛtŋ uwↄmu ɛm yɛji, ɛm e sos megl a bʼow ɛru es am ↄmn low. ");
INSERT INTO adj_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Nawrɛ tasi, kʼow igŋm ɛlum im es ↄŋnes baŋn, kʼow yɛbm ŋ e libↄwi mamn e sos megl a ugŋm es uwↄmu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ŋ, yɛgmʼm sebr a eke bi nyimn ɛgŋ sel ɛŋn ɛm a, ɛtŋ ŋ e sos eke bʼow ɛlu ↄkm ɛm ecʼany af a, bʼow ↄŋʼm sos ɛm iŋn. ");
INSERT INTO adj_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Agŋ lisijimɛl, abusu ɛruʼm es eke mi ki dad ↄny lala ɛm ɛy lagŋ David e lís e low. Lʼuw, wɛl ocʼr es ɛtŋ in ecʼuwↄmu a yɛfɛnyna yɛji anŋ ɛy ogŋ aŋa. ");
INSERT INTO adj_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Gbɛkↄ lʼel kokoba ↄb ɛs ɛtŋ lʼuw any eke Nyam ij nɛny ɛwar ir ekʼin ecʼalaw ab ɛm ɛgŋ nyam bʼow usrʼr usu el ɛb ebu. ");
INSERT INTO adj_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David ikŋ anym ɛkn low a eke bʼow ɛy a, ɛtŋ ow sosiɛm li dad Mesi ecʼuwↄmu ɛm anŋ igb a e low ninɛ: Wɛl igŋm ɛlumʼn es ↄŋnes baŋn, ɛtŋ in e sos megl a ugŋm es uwↄmu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Jesu na eke mʼam dad in e low a, Nyam igbmʼn agŋ ekʼuw ab ɛm, ɛtŋ ɛy fɛŋ sʼij ow e daŋku. ");
INSERT INTO adj_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Sica, wɛl igblʼl ogŋ Nyam e lidr abu af, ɛtŋ Ɛs ɛm nʼɛŋn Abŋ Lala a eke wɛl ɛwar ow e low a, ɛtŋ nʼↄmun es ɛy af. Ow e low anake am ɛkan, ke am irir a. ");
INSERT INTO adj_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Tasi ɛm a, David in obi lʼuyum afr, gbɛkↄ li dad ninɛ: Ɛs Kↄtↄkↄ Nyam dad ɛm Ɛs Kↄtↄkↄ ninɛ: “Òw sig es ɛm e lidr abu af, ");
INSERT INTO adj_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","toŋ bake mʼót ŋ ecʼefnu mʼok ŋ ecʼakr ew a.” ");
INSERT INTO adj_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sica ow it eke Israɛl ecʼagŋ fɛŋ kʼuw any tasi eke Jesu a ekʼɛwr olikŋ af a cɛ anake Nyam oc ɛw Kↄtↄkↄ lele Mesi ab a.» ");
INSERT INTO adj_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Eke agŋ a iri sodad amua a, ow ɛy ɛl sos ɛm nↄnↄ. -Lʼibrm Piɛr lele ɛrm ɛsɛl likpr ab ab ninɛ: «Agŋ lisijimɛl, ayaf si ki kokr ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Piɛr ↄdu eb ninɛ: «Ìtŋnin ɛrm ɛm, ke ↄny ɛm ecʼɛgŋ fɛŋ ɛ́gŋ eb wɛl okʼr mij nuŋ Jesu Krist e nin ɛm, yecʼɛtŋ ke Nyam óc ↄny e sikpl a ap ↄny, ke ɛ́ŋan Nyam ecʼob ap a ekʼel Abŋ Lala a, ");
INSERT INTO adj_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","aŋke Nyam ecʼob ekʼɛwar a, ↄny lele ↄny eyŋɛl ab eci, ɛtŋ ow el agŋ a ekʼelm Jwifɛl a yɛji eci, agŋ a fɛŋ eke Ɛs Kↄtↄkↄ Nyam bʼow ɛsŋ a.» ");
INSERT INTO adj_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Ɛmɛny Piɛr dad ɛl sodad nↄnↄ, ↄm ɛl ów, atr ɛl sos es ninɛ: «Ɛ̀gŋn sel ɛŋn a e low ebr, yecʼɛtŋ ke kʼↄ́nymn abu ɛyr ɛsɛ agŋ a ekʼirm ab af.» ");
INSERT INTO adj_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ɛl ɛm ecʼagŋ nↄnↄ ɛgŋ Piɛr e sodad a eb, ɛtŋ wɛl ok ɛl mij nuŋ. Lɛgŋ a, agŋ ekʼↄtu eke kʼij agŋ fandi nyahan ow obn ɛl a ekʼↄny ↄmn a. ");
INSERT INTO adj_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Sɛgŋ fɛŋ ari at ɛm, -li bʼas luku -nʼam iri ɛrm ɛsɛl a e low yɛgm a, -lʼir ɛb ɛsɛ agŋ lisijimɛl af, -lʼij ob lↄfu nyam ɛm, -ni ŋↄŋn Nyam usu nyam. ");
INSERT INTO adj_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Agŋ a fɛŋ am ↄny Nyam ecʼɛlum, aŋke Nyam am ɛcr ɛrm ɛsɛl ab ɛm kok mɛny ɛwr nↄnↄ lele sakrowa ab. ");
INSERT INTO adj_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Agŋ a fɛŋ ekʼↄny ↄmn a bʼokr af ɛtŋ ɛl ↄfr -li bi cɛc ob eke -nʼↄnyn a. ");
INSERT INTO adj_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","-Li bʼↄl ɛl ecʼob eke -nʼↄnyn a -lʼij ɛtŋ ow ɛm ecʼos eke -li bʼɛŋn a, -li bi cɛc ɛl fɛŋ, ɛgŋ ɛgŋ ecʼes abur ekʼↄny a e kokr eci. ");
INSERT INTO adj_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Lɛgŋ nyam nyam fɛŋ, ow ↄ́pim, -li bʼas luku Nyamel gbɛl ab ɛm, ɛl ecʼakŋ akŋ a -li bʼij ob usu nyam ɛtŋ ob ij a bʼel sos ɛm iŋn ɛm lel ɛrm frↄrↄ ɛm ab. ");
INSERT INTO adj_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","-Nʼam kↄklm Nyam ɛtŋ agŋ a fɛŋ am ↄny ɛl ecʼerur. Ɛtŋ lɛgŋ nyam nyam fɛŋ Ɛs Kↄtↄkↄ bʼot agŋ eke nʼam eb lʼɛlu es a, lʼok wɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Lɛgŋ nyam, Piɛr lele Jan ab aam Nyamel gbɛl ab ɛm ncebles e wanci nyahan e Nyam ŋↄŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Nyamel gbɛl a e gbugŋ e lisany nyam eke wɛl bʼɛsŋ “Lisany Sↄbↄ” a e saw, ɛgŋ nyam anŋ eke in e mew ɛm ɛtŋ bubm es. Lɛgŋ nyam nyam fɛŋ, wɛl bʼoc owʼr sigmʼn es yogŋ, yecʼɛtŋ ke lʼↄ́tu li sism agŋ a eke bʼok Nyamel gbɛl a e gbugŋ a os. ");
INSERT INTO adj_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Eke ↄlu a bʼɛkn Piɛr lele Jan ab ekʼam ow ok akŋ a, nʼam sism wɛl ob. ");
INSERT INTO adj_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Piɛr lele Jan ab okʼr anyamn af, ɛtŋ Piɛr dadʼr ninɛ: «Lɛ̀r ɛy!» ");
INSERT INTO adj_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ɛgŋ a am lɛr ɛl gbiy, aŋke nʼam tutr eke wɛl bʼow ↄŋʼn ob. ");
INSERT INTO adj_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Kↄ Piɛr dadʼr ninɛ: «Mʼↄnym jɛtɛ, mʼↄnym sika, kↄ mʼam ↄŋʼŋ yecʼa e mʼↄny a: Nasarɛt e Jesu e nin ɛm, ìgb ke án es.» ");
INSERT INTO adj_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ɛtŋ Piɛr ucu lidr abu ↄnyʼn, ɛlumʼn abu lʼigb. Kpɛkŋ ↄlu a ecʼakr a lel akr ɛmn ɛm ab ab ok ɛm fɛŋ; ");
INSERT INTO adj_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","lʼigb lʼus es, nʼinym es ceŋ ɛtŋ nʼam an es. Lʼigŋ Piɛr lele Jan ab lʼɛy Nyamel gbɛl a e gbugŋ a, nʼam an es, nʼam igb li sus es ɛtŋ nʼam kↄklm Nyam. ");
INSERT INTO adj_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Agŋ a fɛŋ ɛknʼn eke nʼam an es, ke nʼam kↄklm Nyam. ");
INSERT INTO adj_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Sica eke -lʼuwr any eke ow el ↄlu a eke bi sig es Lisany Sↄbↄ a saw sism ob a, ɛl fɛŋ ow ɛw ɛl erŋn ɛtŋ ow am iti ɛl any yɛji, low a ekʼɛŋn ow a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Sica ekʼɛgŋ a ɛ́lum Piɛr lele Jan ab es a, agŋ a fɛŋ anŋ low any iti ɛm, ɛtŋ -lʼuru es -lʼow -nʼɛŋn wɛl Nyamel gbɛl a eci lɛf eb usu a ekʼij Salomↄ e nin a. ");
INSERT INTO adj_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Eke Piɛr bʼɛkn ɛbɛn a, li dad agŋ a ninɛ: «Israɛl eyŋ, bla sosiɛm ɛgŋ na ecʼewlm a e low am iti ↄny any ee? Kì lɛɛr ɛy ɛbɛn! Ɛgŋ na, ow elm ɛy obi ecʼabusu ɛm, oglog ɛy e Nyam nuŋ igŋ sɛnyn ɛm nʼanm es, ");
INSERT INTO adj_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","kↄ Nyam a ekʼel Abraham, Isak lele Jakↄb ab e Nyam, ke el ɛy lagŋɛl e Nyam a, ɛlu in e libↄwi Jesu any ↄkm. Ɔny obi a ↄↄl ijr ir es ɛw ɛsɛl ecʼabu ɛm, ɛtŋ igŋn ɛlul il es Pilat ecʼany af, ke lʼerur eke li kʼɛlu ow es cɛ. ");
INSERT INTO adj_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ɔny igŋn Ɛgŋ Lala a, Nɛnyɛmbri Nyam Ɛs a ɛlul es ɛtŋ ibrmn eke Pilat kʼɛlu ɛgŋ ibiu ab es ↄŋ ↄny. ");
INSERT INTO adj_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɛtŋ ibir Sel Ɛŋn ecʼIdr Ɛs a. Gbɛkↄ Nyam igbmʼn luw ɛm ɛtŋ sʼel ow ecʼadaŋku. ");
INSERT INTO adj_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ɛgŋ na ekʼam ɛkan a, uwr ir any. Jesu e nin a ecʼabusu a eke ow ɛm sʼↄny ↄmn a anake ewlmʼn a. Jesu ɛm ecʼↄmn a eke sʼↄny a anake ↄŋ ɛgŋ na ewl nimum ↄny fɛŋ ecʼany af a. ");
INSERT INTO adj_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Gbɛkↄ agŋ lisijimɛl, mʼuw any eke ↄny lele ↄny ecʼes ɛw ɛsɛl ab ab, ow el low any uwm ɛm e low eke kokr Jesu e lís. ");
INSERT INTO adj_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Gbɛkↄ Nyam kok yecʼa eke likŋ anym lʼɛwar lɛgŋ ekʼɛc ab ɛm kokoba ↄb ɛsɛl fɛŋ e nɛny ɛm a. Li dad eke Mesi a kʼij gbre. ");
INSERT INTO adj_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Ìtŋnin ɛrm ɛm gↄŋ, ke ɛ́wal -lɛɛr Nyam, yecʼɛtŋ ke li tɛ́tŋ ↄny e sikpl ab es, ");
INSERT INTO adj_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ɛtŋ Nyam bʼow ↄŋ ↄny sel eb mamn e sɛgŋ, ɛtŋ li bʼow lʼis ↄny Mesi a eke lʼikŋ anym li sↄsum lʼoc ↄny ecʼa: ke Jesu ana. ");
INSERT INTO adj_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Gbɛkↄ sicaca ɛm a, ow it eke Jesu Krist kʼanŋ afr, toŋ ow ok lɛgŋ ekʼów a fɛŋ bʼow ɛwl el owr a. Godʼɛtŋ Nyam ɛwar low na in e kokoba ↄb ɛsɛl lala a e nɛny ɛm. ");
INSERT INTO adj_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Tasi ɛm a, Mois dad ninɛ: Ɛs Kↄtↄkↄ ↄny e Nyam bʼow ↄŋ ↄny kokoba ↄb ɛs nyam ɛsɛ ɛm af, eke bʼow el ↄny ɛm ecʼɛgŋ nyam. Bʼow irir ów a fɛŋ eke li bʼow li dad ↄny a. ");
INSERT INTO adj_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ɛtŋ ɛgŋ kaka fɛŋ eke kʼow irim kokoba ↄb ɛs na e low a, wɛl bʼow ogŋʼn Nyam ecʼagŋ a ecʼaraŋn ke wɛl íbiʼr. ");
INSERT INTO adj_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ɛtŋ kokoba ↄb ɛsɛl a fɛŋ eke Samiɛl e lɛgŋ ɛm ɛtŋ dad ów toŋ ke igŋ yɛfɛnyna a, ɛgŋ ɛgŋ dad ów amua eke am ɛy sɛgŋ amua ɛm a e low. ");
INSERT INTO adj_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Low a eke Nyam ɛcr kokoba ↄb ɛsɛl ɛm ɛwar a el ↄny eci, ɛtŋ ↄny yɛji anŋn sinm a eke Nyam kok ↄny lagŋɛl ab a ɛm, lɛgŋ a eke li dad Abraham ninɛ: Ŋ ecʼalaw ɛm mʼow mʼɛcr mʼɛdŋ eb eb a fɛŋ ekʼanŋ wus na a ↄwrↄ. ");
INSERT INTO adj_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ɛtŋ ↄny sosiɛm Nyam sↄsum in e libↄwi oc, ɛtŋ lʼikŋ anym lʼoc nʼↄŋ ↄny. Lʼɛrm ow ow ow eke ow kʼɛdŋ ↄny ↄwrↄ, ɛtŋ li bʼow nʼↄŋ ↄny ɛm ecʼɛgŋ nyam nyam igŋ in ecʼów eŋuŋ kok a ɛlu es.» ");
INSERT INTO adj_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Eke Piɛr lele Jan ab odad anŋ nɛnym am dad agŋ a, egb waw ɛsɛl, Nyamel gbɛl a ecʼↄsu ɛsɛl ecʼɛgŋ ligbɛl a, lele Sadusiɛl ab ow ɛŋn ɛl. ");
INSERT INTO adj_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ɛrm am ebl ɛl nↄnↄ eke ɛrm ɛsɛl yony a am yɛgm agŋ a low, ke am dad ɛl Jesu e luw ɛm ekʼigb a e low, ke ow ɛm am ij nɛny eke agŋ eke in bʼuw a yɛji in ↄtu eke in kʼigb luw ɛm. ");
INSERT INTO adj_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","-Nʼↄny Piɛr lele Jan ab, ɛtŋ -lʼot -nʼim -lʼok wɛl sobel ɛm toŋ lɛgŋ ɛny, aŋke lɛgŋ ler im nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ɛbɛn yɛji, agŋ a ekʼiri ɛrm ɛsɛl a ecʼamani a e nↄnↄ gbɛl ub nawrɛ, ɛtŋ ow ↄŋ ↄmn ɛsɛl a e nɛny a obn toŋ ↄtu ekʼij agŋ fandi yen. ");
INSERT INTO adj_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Eke lɛgŋ ɛny akr af a, Jwifɛl ecʼes ɛw ɛsɛl, agŋ ekpekp lele ol e low yɛgm ɛsɛl ab ab as luku Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Agŋ a ekʼanŋ ɛl ɛm a el: egb waw ɛs ligbɛl An, Kayif, Jan, Alesandr lel egb waw ɛs ligbɛl a ecʼagŋ a fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","-Nʼↄŋ wɛl ↄny Piɛr lele Jan ab ow ɛl ecʼany af ɛtŋ -lʼibrm wɛl ninɛ: «Bwo ecʼɛgŋ ecʼabusu ɛm oglog bwo ecʼɛgŋ e nin ɛm ewlmn ɛgŋ na ee?» ");
INSERT INTO adj_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ɛtŋ Piɛr ekʼAbŋ Lala iy ɛm a dad ɛl ninɛ: «Ɛb ecʼes ɛw ɛsɛl lele agŋ ekpekp ab, ");
INSERT INTO adj_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","yɛfɛnyna wɛl am ibrm ɛy low, low nimamn eke si kok sʼↄŋ ɛgŋ nyam eke bubm es a sosiɛm, ɛtŋ wɛl am ibrm ɛy elel ekʼɛgŋ ikŋ na kʼewl a e low. ");
INSERT INTO adj_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ɛɛ, ↄny fɛŋ ow it eke kʼuwr any, ke Israɛl eyŋ fɛŋ yɛji úw any: ekʼɛgŋ na inym ↄny es any af sos tuↄtuↄ ab, ke Jesu Krist, Nasarɛt iy a e nin a ecʼabusu ɛm. Ɛwr ir olikŋ af kↄ Nyam igbmʼn agŋ ekʼuw ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Jesu el ɛgŋ a eke Nyam Lɛl dad in e low ninɛ: Lebn a eke ↄny, êl us ɛsɛl, waal ɛlul es a ɛwl el êl lↄy ɛm e lebn tasi. ");
INSERT INTO adj_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","In ɛm cɛ anake sʼↄtu eke si kʼɛŋn sel a, aŋke wus na nimum af, Nyam ↄↄm agŋ ɛgŋ ɛjeci kaka ekʼin ɛm si kʼɛŋn sel.» ");
INSERT INTO adj_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sanedrɛn ecʼagŋ a low am iti any, aŋke -nʼam ɛkn elel eke Piɛr lele Jan ab am dad odad ɛrm susu ɛm a, ɛtŋ ow am ok ɛl es sos ɛm eke ow el agŋ nɛnɛ cɛ eke wewrm low yɛjʼa. Ɛtŋ -lʼuw wɛl any eke wɛl bʼanŋ Jesu ab. ");
INSERT INTO adj_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Gbɛkↄ, eke -nʼam ɛkn ɛgŋ a ekʼewl inym ɛl es saw a, Sanedrɛn ecʼagŋ a ɛknm low eke ki dad. ");
INSERT INTO adj_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ow sosiɛm, -nʼↄŋ wɛl ok ↄkm luku as usu a ɛtŋ ɛl ↄfr -nʼam bɛbm ów. ");
INSERT INTO adj_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","-Nʼam dadarir -lʼɛsɛ: «Ke sica bla lowi si ki kok agŋ amua ab ee? Tasi ɛm a, Jerusalɛm ecʼagŋ a fɛŋ uw any tasi ekʼow el ɛl -li kokr akrowa na; si kʼↄtum sʼɛgbrm kaka. ");
INSERT INTO adj_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Gbɛkↄ, ke low na ecʼamani a kí cɛcrm es dedeku ab ɛm fɛŋ a; sʼók ɛl erŋn lokm sʼɛdŋn ɛl yecʼɛtŋ ke -li ki dadmn ɛgŋ kaka fɛŋ odad Jesu e nin ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Eke -li bɛbmn ów a uwr a, -lʼɛsŋ Piɛr lele Jan ab ɛtŋ -lʼijl wɛl nɛny, -lʼɛdŋn wɛl eke wɛl kí dadm Jesu e nin a ecʼodad, yɛgam agŋ Jesu e lís e low kaka fɛŋ. ");
INSERT INTO adj_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Gbɛkↄ Piɛr lele Jan ab dad ɛl ninɛ: «Jɛ̀jr okr ↄny obi ɛm, eke tasi Nyam ecʼany af ow el ↄny si kʼɛlum ↄny oglog Nyam si kʼɛlum. ");
INSERT INTO adj_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Gbɛkↄ ɛy, si kʼↄtum sʼablm nɛny low yecʼeke sʼɛkn ke sʼiri a eci.» ");
INSERT INTO adj_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ɛmɛny Sanedrɛn ecʼagŋ a ok ɛl erŋn lokm ɛtŋ wal ok ɛl es. -Lʼɛknm elel eke -li ki kokr wɛl low ŋuŋ, aŋke dedeku a nimum am kↄklm Nyam low a ekʼɛy a eci. ");
INSERT INTO adj_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɛgŋ a eke in ecʼewlm a e low ɛw any iti a, ij akpo ekŋ yony afŋ es. ");
INSERT INTO adj_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Kpɛkŋ eke wɛl ɛlu ɛl es a, Piɛr lele Jan ab im ɛŋn ɛl lawlɛl a, ɛtŋ otar ów a fɛŋ ekʼegb waw ɛsɛl ecʼes ɛw ɛsɛl a lele agŋ ekpekp ab ab dad a e low akr. ");
INSERT INTO adj_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Eke -lʼirir odad na a, nɛny af okr ɛm, ↄmn ɛsɛl a fɛŋ ŋↄŋn Nyam dad ninɛ: «Es Ɛw, ŋ anake kok afr, wus, okij lele ob fɛŋ ekʼanŋ ɛl ɛm ab ab a. ");
INSERT INTO adj_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Ŋ anake ɛcr Abŋ Lala ɛm ↄŋ ɛy lagŋ David ekʼel ŋ e juma kok ɛs a am dad ɛsɛ: Kↄ bla sosiɛm ɛb ɛb ecʼagŋ ab ɛm likekr am ɛy ee? Ɛb eyŋ a ut ɛm ecʼasre kↄ ow el ↄfr ↄfr! ");
INSERT INTO adj_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wus ecʼɛ́b ebu a bɛbm sos ar ogŋ eci ɛtŋ es ɛw ɛsɛl okr af sifn ɛm im Nyam lel in e Mesi ab ab ar. ");
INSERT INTO adj_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Nawrɛ tasi, ɛb na ɛm Erↄd Antipas, Pↄns Pilat, etu agŋ lel Israɛl ecʼagŋ ab ab okr af ogŋ Jesu ekʼel ŋ e libↄwi lala a eke sↄsum oc a ar. ");
INSERT INTO adj_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ow ↄŋ -li kok ów a fɛŋ eke ŋ ecʼabusu ɛm lele ŋ ecʼerur ɛm ab ikŋ anym bɛbm ɛw es a iy nɛny. ");
INSERT INTO adj_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sica Ɛs Kↄtↄkↄ, ɛ̀kn ɛl e gbre e -nʼam ↄl eke -li kʼijr ɛy a, ke ↄ́ŋ ŋ ecʼↄbↄwi a dád ŋ ecʼodad a lokm susu ɛm tasi. ");
INSERT INTO adj_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ɛ̀lu ŋ ecʼabusu a ↄkm yecʼɛtŋ ke wɛl éwlm agŋ, kók sakrowa lele mɛny ɛwr ab ŋ e libↄwi lala Jesu e nin ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Eke -ni ŋↄŋan Nyam uwr a, yogŋ a eke -lʼasr luku a umu. Ɛl fɛŋ Abŋ Lala iy ɛl ɛm ɛtŋ sica -nʼam dad Nyam ecʼodad a ɛrm susu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ɔmn ɛsɛl a fɛŋ okr af tasi, ɛrm ɛm lele ów tutr ɛm ab. Ɛl ɛm ecʼɛgŋ kaka ɛsmɛ in ecʼob ekʼin ↄny a, in sↄny cɛ eci, kↄ ɛl ↄfr ɛm a, ob fɛŋ eke -nʼↄnyn a el dedeku a fɛŋ ecʼob. ");
INSERT INTO adj_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Abusu ligbɛl ɛm, ɛrm ɛsɛl a am ij Ɛs Kↄtↄkↄ Jesu ecʼuwↄmu ɛm anŋ igb a e daŋku, ɛtŋ ɛl fɛŋ Nyam am ɛdŋ ɛl ↄwrↄ nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","35","Ɛl ɛm ecʼɛgŋ kaka ↄ́nym ob kaka ecʼes abur. Tasi ɛm a, agŋ a fɛŋ ekʼↄny sↄgm oglog mel a bʼↄl ij, ɛtŋ bʼeb ow ecʼos eke bʼanŋ ɛm ɛy ↄkm a ow ↄŋ ɛrm ɛsɛl a, ɛtŋ wɛl bi cɛc os a ɛgŋ ɛgŋ ecʼes abur ekʼↄny a eci. ");
INSERT INTO adj_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kin low any ↄkŋn nyam: igŋ nyam anŋ eke wɛl bʼɛsŋ Josɛf, ke ɛrm ɛsɛl a igŋʼn nin af Barnabas. (Ow e nyandrɛ el “ɛgŋ eke bʼatr ɛgŋ sos es”.) Lʼel Levi ecʼeb ɛm ecʼɛgŋ eke wɛl ew Sipr. ");
INSERT INTO adj_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Nʼↄny ↄgm nyam eke lʼↄl lʼij, ɛtŋ lʼoc ow ecʼos a lʼis ɛrm ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Gbɛkↄ igŋ nyam eke wɛl bʼɛsŋ Ananias, lele ɛy Safira ab, nɛny af okr ɛm, ↄl ɛl ecʼↄgm nyam ij. ");
INSERT INTO adj_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","-Lʼiririr ɛy ab ɛtŋ ↄgm a eke lʼↄl lʼij a, lʼubr ow ecʼos ab es, ɛtŋ lʼoc likpr a nʼim nʼↄŋ ɛrm ɛsɛl a. Li dad wɛl eke os a fɛŋ cɛ ana. ");
INSERT INTO adj_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Kↄ Piɛr dadʼr ninɛ: «Ananias, bla sosiɛm ɛtŋ Satan ↄtu ɛyʼŋ ɛrm ɛm, ↄny yadŋ ↄŋ Abŋ Lala ɛtŋ ɛdŋn ↄgm a ekʼↄl ij a ecʼos a e likpr ɛw es ee? ");
INSERT INTO adj_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Gbuŋ ke ↄ́l ↄgm a ij a, ow el ŋ eci, ɛtŋ ekʼↄl ij a yɛji ow ecʼos a el ŋ eci, kↄ yadŋ ee? Ayaf ɛtŋ ↄny tutr kok low akpasu na ee? Ow elm agŋ ↄnym yadŋ ↄↄm, kↄ Nyam.» ");
INSERT INTO adj_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Eke Ananias iri sodad amua a, lʼɛy wus ɛtŋ lʼuw. Agŋ a fɛŋ ekʼiri low na a erŋn ligbɛl am ↄny. ");
INSERT INTO adj_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Ŋgbafrɛ oto ow oc sos megl a wiwrm gbad ab ɛtŋ im oc es. ");
INSERT INTO adj_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Eke wanci nyahan ɛc a, Ananias e yↄw a ekʼuwm low a ekʼɛy ab any a ow ɛy akŋ. ");
INSERT INTO adj_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Piɛr ibrmʼn ninɛ: «Dàdʼm ↄ! Ɔny ecʼↄgm a ekʼↄↄl ijr a ecʼos a e nɛny a, ow ow el na cɛ ee?» Ɛtŋ lʼↄdu lʼeb ninɛ: «Ɛɛ, ow e nɛny a cɛ ana.» ");
INSERT INTO adj_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɛtŋ Piɛr dadʼr ninɛ: «Ayaf tasi ↄtur okar nɛny af ŋ lel acŋ ab ɛbmn Nyam ecʼAbŋ ab ee? Kin, agŋ a ekʼoc acŋ es a ow igŋ lisany, ɛtŋ ŋ yɛji -li bʼow -lʼoc -nʼimʼŋ.» ");
INSERT INTO adj_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wanci ab af cɛ lʼɛy wus Piɛr ecʼakr esr a ɛtŋ lʼuw. Ŋgbafrɛ oto a ok akŋ ɛtŋ ɛknʼn eke lʼuw; -lʼoc ow -nʼim ɛtŋ -lʼoc ow es ɛc eci saw yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Sica Nyamel nimum lel agŋ a fɛŋ ekʼiri ów amua a erŋn ligbɛl am ↄny. ");
INSERT INTO adj_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ɛrm ɛsɛl a am kok mɛny ɛwr lele low any iti owi nↄnↄ gbɛl ab bieku a ecʼaraŋn. Ɔmn ɛsɛl a fɛŋ bʼas luku Nyamel gbɛl a e lɛf eb usu a ekʼij Salomↄ e nin a. ");
INSERT INTO adj_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ɛgŋ ɛjeci kaka ɛ́gŋm owm ɛym ɛl ɛm; ke agŋ a bʼaw ɛl nↄnↄ cɛ. ");
INSERT INTO adj_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Kↄ agŋ nↄnↄ gbɛl, egŋ lel ↄyↄw ab, am ub Ɛs Kↄtↄkↄ nawrɛ ɛtŋ -nʼam ɛny, ");
INSERT INTO adj_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","toŋ wɛl am ot ↄ́lu yɛji ow ɛbɛrŋ ɛm, ɛ́rum ɛl es faja ɛm oglog sogo af yecʼɛtŋ ke ba Piɛr bʼubr ɛc a, ke in e lↄw a ɛ́cr ɛl ɛm ecʼagŋ abi ka af. ");
INSERT INTO adj_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Agŋ nↄnↄ am anŋ Jerusalɛm eci baŋn saw saw ab ɛm ow; -li bʼism ↄ́lu lel agŋ ekʼↄny abŋ eŋuŋ ab, ɛtŋ ɛl fɛŋ -li bʼewl. ");
INSERT INTO adj_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ow sosiɛm, egb waw ɛs ligbɛl a lel agŋ a fɛŋ ekʼanŋ in ab, ke el Sadusiɛl ecʼogog ecʼagŋ a, ɛrm ɛsɛl a e low ↄny ɛl nyamn ɛyr afŋn es toŋ batŋ -lʼɛgŋ -lʼeb eke -li ki kok ow e low. ");
INSERT INTO adj_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","-Nʼↄŋ wɛl ↄny ɛrm ɛsɛl a ok dedeku fɛŋ eci sobel ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Gbɛkↄ ncok ɛm, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ow fifig sobel a e masany a, ↄny ɛrm ɛsɛl a ok ↄkm ɛtŋ dad ɛl ninɛ: ");
INSERT INTO adj_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Ìmn Nyamel gbɛl a e gbugŋ a, ke ↄ́br sel ɛŋn owr a e kokoba okr bieku a nimum.» ");
INSERT INTO adj_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ɛrm ɛsɛl a ɛlum ɛtŋ ibribr fafa, igb im Nyamel gbɛl a e gbugŋ a am yɛgm agŋ low. Eke egb waw ɛs ligbɛl a lel agŋ a fɛŋ ekʼanŋ in ab a ow a, -lʼas Sanedrɛn ekʼel Jwifɛl ecʼów bɛbm ɛsɛl a fɛŋ luku, ɛtŋ -lʼɛrm Nyamel gbɛl a ecʼabu af ɛsɛl a eke kʼim sobel ab ɛm ɛsŋ ɛrm ɛsɛl a ow. ");
INSERT INTO adj_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Kↄ eke -nʼimn -lʼokr sobel ab ɛm a, -nʼɛŋnm ɛrm ɛsɛl a. -Lʼɛwl mɛny -lʼow -nʼↄŋ Sanedrɛn ecʼagŋ a amani; ");
INSERT INTO adj_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","-li dad ninɛ: «Eke sʼim a, sʼɛkn sobel a ekʼabl anŋ tiŋ, ke usu ↄsu ɛsɛl a inym es lisany, ɛgŋ ɛgŋ ecʼusu a ekʼit a. Kↄ eke si fifig masany a, sʼɛŋnm ɛgŋ kaka lokm yogŋ.» ");
INSERT INTO adj_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Eke Nyamel gbɛl a eci abu af ɛsɛl a ecʼes ɛw ɛs a lel egb waw ɛsɛl ɛgbɛl a ecʼes ɛw ɛsɛl ab ab iri amani na a, -lʼuwm low yecʼeke -li ki tutr ab any, ɛtŋ -nʼam ibrm low yecʼekʼɛŋn ɛrm ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Kↄ ɛgŋ nyam anŋ ow ɛtŋ dad ɛl ninɛ: «Ìrir ↄ! Agŋ a ekʼↄnyn okr sobel ɛm a anŋ Nyamel gbɛl a e gbugŋ a, ɛtŋ -nʼam yɛgm bieku a low yogŋ.» ");
INSERT INTO adj_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kpɛkŋ abu af ɛsɛl a ecʼes ɛw ɛs a lele in ecʼagŋ ab ab im ɛtŋ ot ɛrm ɛsɛl a ow. Gbɛkↄ -lʼɛwm lɛc ɛm, aŋke -nʼam uru eke bieku a ki wↄwl ɛl mebn. ");
INSERT INTO adj_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Sica eke -lʼotr wɛl -lʼowr a, -lʼot wɛl -nʼim Sanedrɛn ecʼagŋ a ecʼany af, ɛtŋ egb waw ɛs ligbɛl a am bibrm ɛl ów. ");
INSERT INTO adj_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","Li dad wɛl ninɛ: «Ɛy, sʼɛdŋn ↄny kpoŋ kpoŋ kpoŋ eke kí yɛgamn agŋ low ɛgŋ na e nin ɛm. Kↄ kin, ↄmunin ↄny e low yɛgm ab es Jerusalɛm ecʼɛb a nimum ɛm ɛtŋ am ocr in e luw a e low ɛwr ɛy af.» ");
INSERT INTO adj_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Kↄ Piɛr lel ɛrm ɛsɛl bɛb ab ab dad ninɛ: «Ow it eke si kʼɛlum Nyam, kↄ ow elm agŋ. ");
INSERT INTO adj_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ɔny, ɛwr Jesu olikŋ af, ibir ir, kↄ ɛy lagŋɛl e Nyam a igbmʼn luw ɛm. ");
INSERT INTO adj_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nyam ↄny igblʼl ogŋ in e lidr abu af ɛtŋ ɛwʼr Es Ɛw Ɛs lele Sↄg Ɛs ab, yecʼɛtŋ ke ow ↄ́ŋ Israɛl eyŋ abusu itŋn ɛrm ɛm, ke ɛ́ŋn ɛl e sikpl a ecʼoc ap. ");
INSERT INTO adj_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ɛy, sʼij ów amua e daŋku, ɛy lel Abŋ Lala a eke Nyam ↄŋ agŋ a eke bʼↄny in ecʼɛlum ab ab.» ");
INSERT INTO adj_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Eke Sanedrɛn ecʼagŋ a iri sodad amua a, ɛrm ebl ɛl afŋn es, ɛtŋ -nʼam erur eke -li kʼibi ɛrm ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Gbɛkↄ ɛl ɛm a, Farisi nyam anŋ eke wɛl bʼɛsŋ Gamaliɛl, ol e low yɛgm ɛs ligbɛl eke dedeku a bʼɛlum. Lʼigb Sanedrɛn ecʼagŋ a ecʼaraŋn ɛtŋ lʼibrm eke wɛl kʼↄŋ ɛrm ɛsɛl a ok ↄkm tɛl yɛ; ");
INSERT INTO adj_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ɛtŋ li dad wɛl ninɛ: «Israɛl ecʼagŋ, low yecʼeke bʼow kokr agŋ amua na a, ɛ̀wr ow e low ɛrm. ");
INSERT INTO adj_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ɔ̀kan eke ow ibnm yɛji, ɛtŋ Tedas ɛy ↄkm am ocr in sosi any ɛs ligbɛl, ɛtŋ agŋ eke kʼij agŋ duw im ɛŋnʼn. Kↄ eke wɛl ibiʼr a, agŋ a fɛŋ ekʼusʼr jam a ↄmu es, ɛtŋ ɛl e low a yɛji oc es. ");
INSERT INTO adj_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","In e jam a, agŋ awl e lakpo ab af, Judas Galile iy a ɛy ↄkm, ɛtŋ agŋ nↄnↄ usʼr jam. Kↄ in yɛji, eke wɛl ibiʼr a, agŋ a fɛŋ ekʼusʼr jam a ↄmu es. ");
INSERT INTO adj_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ow sosiɛm a, mʼam dad ↄny, kʼùsr agŋ amua e low jam ij, kↄ ɛ̀lul ɛl es -nʼim. Eke ɛl e low a lel ɛl e juma ab ab el agŋ ɛm eci, ow bʼow oc es. ");
INSERT INTO adj_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Gbɛkↄ ekʼow el Nyam ɛm eci tasi, kʼↄtumn ↄnymn ŋuŋnmn. Ɛ̀wr ɛrm ke ow kʼelm Nyam ogŋmn ar!» Sanedrɛn ecʼagŋ a ɛgŋ Gamaliɛl ecʼodad a eb. ");
INSERT INTO adj_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","-Lʼɛwl -lʼɛsŋ ɛrm ɛsɛl a ow, -nʼↄŋ wɛl ↄr wɛl ɛtŋ -lʼijl wɛl nɛny eke wɛl ki dadm odad Jesu e nin ɛm ij, ɛtŋ -li wal -lʼok wɛl es. ");
INSERT INTO adj_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ɛrm ɛsɛl a ok ↄkm Sanedrɛn ecʼagŋ a ecʼaraŋn sos ɛm iŋn ɛm, aŋke Nyam ɛkn eke -lʼel agŋ ekʼit eke wɛl kʼijr gbre Jesu e nin a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ɛtŋ sɛgŋ fɛŋ, Nyamel gbɛl a e gbugŋ a lel akŋ akŋ ab, abu anŋ ɛl ɛm -nʼam yɛgm agŋ low ɛtŋ -nʼam ↄb Mesi a ekʼel Jesu a ecʼAmani Mamn a e kokoba. ");
INSERT INTO adj_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Lɛgŋ ab ɛm eke jam ɛsɛl a e nɛny a am bobn a, ɛl ɛm eci Jwifɛl eke bʼɛbr Grɛk a am ebl ɛrm ok ɛl a eke bʼɛbr Ebre ab af, dad eke wɛʼn ɛ́wm ɛl ecʼeŋnyↄw a e low any eke owʼn bi sig ob cɛc e wanci a. ");
INSERT INTO adj_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ɛrm ɛsɛl lɛw yony a as jam ɛsɛl a nimum luku ɛtŋ dad ɛl ninɛ: «Ow ɛbam eke si kʼɛw Nyam ecʼodad a e dad es, ke sʼam ɛkn ob ij e cɛc owi. ");
INSERT INTO adj_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ow sosiɛm agŋ lisijimɛl, sↄsumn ↄny ecʼaraŋn a agŋ amamn lↄbŋ ekʼAbŋ Lala lele sɛwr ab iy ɛm gbↄŋ otr, ke sʼóc juma ikŋ na e low sʼabul ɛl. ");
INSERT INTO adj_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ow bʼow ↄŋ ɛy abusu ke sʼúcu Nyam ŋↄŋn lele Nyam odad dad ab e low sʼↄny es sʼam kok.» ");
INSERT INTO adj_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Jam ɛsɛl a nimum ɛgŋ low a eb, ɛtŋ kin agŋ a eke -li sↄsumn -lʼotr a ecʼen: Etiɛn ekʼↄmn lel Abŋ Lala ab iy ɛm gbↄŋ, Filip, Prokↄr, Nikanↄr, Timↄ, Parmenas lele Nikola ekʼel Antiↄs ɛb ɛm ecʼɛgŋ, ke lɛgŋ ekʼɛc ab ɛm ɛgŋ Jwifɛl e Nyam nuŋ igŋ a e low eb a. ");
INSERT INTO adj_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sica -lʼot -li yɛgm wɛl ɛrm ɛsɛl a ɛtŋ -lʼat wɛl abu nuŋ -ni ŋↄŋn Nyam -nʼↄŋ wɛl. ");
INSERT INTO adj_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Nyam ecʼodad a am eb es, jam ɛsɛl a am bobn nↄnↄ Jerusalɛm ɛb ɛm, ɛtŋ egb waw ɛsɛl nↄnↄ am ↄny ↄmn Jesu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Etiɛn eke Nyam ecʼↄwrↄ lele lɛc ab iy ɛm gbↄŋ a, am kok low any iti owi lele mɛny ɛwr ɛgbɛl ab ɛb eyŋ a ecʼaraŋn. ");
INSERT INTO adj_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Nyam nuŋ igŋ usu a eke wɛl bʼɛsŋ “Madu e wɛl eb ɛlu es” ecʼagŋ nyam nyam am atar ów es Etiɛn ab. -Lʼel Jwifɛl ekʼanŋ Sirɛn ɛb ɛm, Alesandri ɛb ɛm, Silisi wus af lele Azi wus af ab ecʼagŋ ekʼir Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","-Lʼↄtumn -lʼakamn ow es ów es atar ab ɛm, aŋke nʼam dad ów Abŋ Lala e sɛwr a ekʼam ↄŋʼn ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ow sosiɛm, -lʼub agŋ abu es, yecʼɛtŋ ke agŋ a dád ɛsɛ: «Sʼiri -li dad ów -lʼↄbr Mois lele Nyam ab any!» ");
INSERT INTO adj_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Nɛnɛ ɛm anake -nʼam ok dedeku a, agŋ ekpekp a lele ol e low yɛgm ɛsɛl ab ab al lokm a. -Lʼokr Etiɛn es, -nʼↄny ow ɛtŋ -lʼoc -nʼim ow Sanedrɛn ecʼagŋ a ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","-Lʼot agŋ ekʼam ij daŋku yadŋ ɛm ok Etiɛn af a yɛji -lʼow, ɛtŋ -nʼam dad -lʼɛsɛ: «Ɛgŋ na, wanci kpaŋ nɛny bʼanŋʼn ɛm nʼam dad ów eŋuŋ lʼok ɛy e Nyamel gbɛl lala na lele Mois ecʼol ab ab af! ");
INSERT INTO adj_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Sʼiri li dad eke Nasarɛt e Jesu in bʼow in bubm ɛy e Nyamel gbɛl na in ok, ke owʼn titŋn ɛb ir a eke Mois in ↄŋ ɛy a.» ");
INSERT INTO adj_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Agŋ a fɛŋ ekʼanŋ Sanedrɛn e luku as ab ɛm a am lɛr Etiɛn gbiy ɛtŋ -lʼɛkn eke ow ecʼany a anŋ ɛsɛ afr ɛrm ɛs ecʼany ab af. ");
INSERT INTO adj_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Egb waw ɛs ligbɛl a ibrm Etiɛn ninɛ: «Ów amua eke wɛl am dad ŋ e lís a, kↄ nawrɛ ee?» ");
INSERT INTO adj_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Etiɛn ↄdu eb dad ninɛ: «Agŋ lisijimɛl lel agŋ ɛsɛl ab, ìgŋn lↄru es irir: eke ɛy lagŋ Abraham anŋ Mesopotami wus af a, gbuŋ eke li kʼim lʼir Aran a, anygbɛl e Nyam ɛlu sos ↄkm yɛgmʼn. ");
INSERT INTO adj_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Li dad ow ninɛ: “Ŋ̀gboŋ ŋ ecʼɛb na lele ŋ ecʼeb na ɛm ab, ke ím ɛb a eke mi bʼow mʼↄkŋʼŋ abu ab ɛm!” ");
INSERT INTO adj_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ow sosiɛm Abraham ŋgboŋ Kalde eyŋ ecʼɛb ab ɛm ɛtŋ im ir Aran. Sica eke ɛs uw oc es a, Nyam oc owʼr ɛb na ɛm eke iir lɛgŋ na ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ɛb na ɛm, Nyam ↄↄm Abraham usu kaka, lʼubrm usu logli yɛji nʼↄↄm ow; gbɛkↄ Nyam ij nɛny eke bʼow oc wus a nimum ↄŋʼn, ke in ecʼalaw a eke bʼow anŋ in ɛm ok ↄkm a, ɛl yɛji idr wus a. Ke lɛgŋ ab ɛm a, Abraham ↄnym iy kaka. ");
INSERT INTO adj_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Kin yecʼeke Nyam dadʼr: “Ŋ ecʼalaw bʼow ir etu ɛb, ɛtŋ yogŋ -li bʼow -lʼel madu wɛl ijr ɛl gbre toŋ akpo duw. ");
INSERT INTO adj_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Gbɛkↄ ɛb a eke ŋ ecʼalaw a bʼow el madu ɛl ecʼabu ɛm a, mi bʼow mi jɛj ɛl e low mʼok. Ow e jam a, -li bʼow -lʼigb yogŋ ke -lʼow -lʼigŋʼm nuŋ aŋa na.” ");
INSERT INTO adj_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Ɛtŋ Nyam kok sinm na Abraham ab ekʼow e mɛny ɛwr el likr es ubr. Ow ɛm Abraham ubr jim Isak likr es eke lʼew ow ba ow bʼij sɛgŋ niwn a; ɛbɛn nɛny nyam Isak yɛji bubr Jakↄb likr es, ɛtŋ Jakↄb yɛji bubr jimɛl ekʼel ɛy lagŋɛl lɛw yony a ekr es. ");
INSERT INTO adj_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Sica ɛy lagŋɛl ↄnyn Josɛf nyamn ɛyr, ɛtŋ -lʼↄl -lʼij ow eke ow kʼel adu Ejipt. Gbɛkↄ Nyam anŋ in ab; ");
INSERT INTO adj_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","lʼeb lʼɛlu ow es gbre fɛŋ ɛm. Nʼↄŋ ow nuŋ ɛm ↄny ɛtŋ Faraↄn ekʼel Ejipt ecʼɛb ebu a ecʼany af, lʼakpal ow. Faraↄn ɛw Josɛf Ejipt ɛb a lel in ecʼakŋ a ecʼob fɛŋ ab ecʼes ɛw ɛs. ");
INSERT INTO adj_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Lek ligbɛl ɛy Ejipt ɛb ɛm lele Kana ɛb ɛm ab. Ow ↄŋ gbre am afŋn es, ɛtŋ ɛy lagŋɛl ɛ́ŋnm ob kaka eke kʼij. ");
INSERT INTO adj_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Eke Jakↄb iri ekʼob ij anŋ Ejipt a, lʼɛrm jimɛl ekʼel ɛy lagŋɛl a im akp nyam. ");
INSERT INTO adj_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Sica eke -nʼimn sakp yony ɛm a, Josɛf okm sos ↄkm lisijimɛl a uwʼr any, ɛtŋ ow ↄŋ Faraↄn uw Josɛf ecʼagŋ ab any. ");
INSERT INTO adj_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Ɛtŋ Josɛf ↄŋ wɛl im oc ɛs Jakↄb lel in ecʼagŋ a fɛŋ ekʼij agŋ ekŋ nyahan agŋ lɛw yen a ow. ");
INSERT INTO adj_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakↄb ow ir Ejipt toŋ uw yogŋ, ɛy lagŋɛl a yɛji. ");
INSERT INTO adj_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Wɛl ot ɛl e sos megl a im Sikɛm, ɛtŋ uwↄmu a ekʼAbraham ↄl os ɛm Amↄr jimɛl ecʼabu ɛm Sikɛm baŋn a wɛl ot ɛl es. ");
INSERT INTO adj_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Sica eke lɛgŋ ow titm eke Nyam ki kok ów a fɛŋ eke lʼɛwar Abraham a, ɛy ecʼagŋ a am ɛny bobn Ejipt ɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ɛtŋ ɛb ebu ɛjeci nyam eke uwm Josɛf any a, ɛy ↄkm am nyimn ɛb a. ");
INSERT INTO adj_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ɛb ebu na ɛju ɛy ecʼagŋ a ɛtŋ ↄnyn ɛy lagŋɛl milↄlu, ↄny ɛl lɛc ɛm -li digŋ ɛl ecʼey mɛny nɛnym -lʼok es eke kʼuw. ");
INSERT INTO adj_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Lɛgŋ ab ɛm anake wɛl ew Mois a; lʼel iy ekʼakpl ke Nyam erur. Wɛl gbagblʼl ɛs ecʼakŋ a toŋ awl nyahan. ");
INSERT INTO adj_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Sica eke wɛl igŋ ɛluʼl es a, Faraↄn jↄw a ocʼr ɛtŋ gbagblʼl ɛsɛ in ecʼiy lokm af. ");
INSERT INTO adj_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Ow ↄŋ Mois uw Ejipt eyŋ e low fɛŋ any, ɛtŋ lʼel ɛgŋ gbawru odad ebl ɛm lel ów kok ɛm ab. ");
INSERT INTO adj_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Eke Mois ↄny akpo ekŋ yony a, lʼerur eke li kʼim lʼɛkn Israɛl eyŋ ekʼel in ecʼɛbr ecʼagŋ a. ");
INSERT INTO adj_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Lʼɛkn Ejipt iy nyam ekʼam ↄnyn Israɛl iy nyam milↄlu; lʼeb ow ecʼusu a eke li ki dogŋn ow, ɛtŋ low a eke li ki kok lʼↄbar any ab ɛm lʼibi Ejipt iy a. ");
INSERT INTO adj_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Li tutr eke lisijimɛl Israɛl eyŋ a bʼow iri eke Nyam am ow ɛcr in ɛm eb ɛlu ɛl es, kↄ -lʼirim ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Eke lɛgŋ ɛny a, Mois uyum Israɛl eyŋ yony ekʼam ogŋ mum ab, ɛtŋ lʼerur eke li kʼↄny lʼokr wɛl ɛm. Li dad wɛl ninɛ: “Ɛm lawlɛl, ↄny agŋ lisijimɛl ↄfr eel, bla sosiɛm ɛtŋ am ↄnyanin milↄlu ee?” ");
INSERT INTO adj_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Kↄ ɛgŋ nyam a ekʼam ↄnyn lawl a milↄlu a itr Mois ɛtŋ dadʼr ninɛ: “Kↄ ŋ, bwo ɛwʼŋ ɛsɛ ɛy ecʼes ɛw ɛs af, ɛsɛ ɛy e jɛj ok ɛs af ee? ");
INSERT INTO adj_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Am erur eke kʼibiʼm ɛsɛ elel eke efi cɛ, ibi Ejipt iy ab af ee?” ");
INSERT INTO adj_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Eke Mois iri sodad amua a, lʼuru es nʼim lʼir Madian ɛtŋ lʼew ey yony yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Eke akpo ekŋ yony ɛcʼa, loj a e titm Sinayi lafɛny ab ɛm, afr ɛrm ɛs nyam yɛgm Mois sos, duw luku ekʼam iri al ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Eke Mois ɛkn ɛbɛn a, ow ɛwʼr any iti. Gbɛkↄ eke lʼerur e li kʼɛri nʼim li titm ke lʼɛ́kn a, lʼiri Ɛs Kↄtↄkↄ e lebl ekʼam dadʼr ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Mʼel alagŋɛl e Nyam, Abraham, Isak lele Jakↄb ab e Nyam.” Mois erŋn am ↄny ufŋ ɛtŋ ↄ́tum igblm any ogŋ. ");
INSERT INTO adj_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Ɛtŋ Ɛs Kↄtↄkↄ dadʼr ninɛ: “Ɔ̀ny ŋ eci cↄkrukpↄ a ot es akr ɛm, aŋke usu a ekʼinym es a, usu lala. ");
INSERT INTO adj_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mʼɛkn ɛm ecʼagŋ a e gbre ekʼam ij Ejipt a, mʼiri ɛl e sↄmu ikŋ a ɛtŋ mʼus es eke mi ki sↄg ɛl. Òw, ke sica mʼɛ́rmʼŋ Ejipt.” ");
INSERT INTO adj_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Mois nyam a cɛ eke Israɛl eyŋ ogŋ ke dadʼr ninɛ: “Bwo ecʼɛgŋ ɛwʼŋ ɛsɛ ɛy ecʼes ɛw ɛs lele ɛy e jɛj ok ɛs af a,” in cɛ Nyam ɛrmʼn ɛsɛ es ɛw ɛs lele sↄg ɛs af, afr ɛrm ɛs a eke ɛlu sos ↄkm yɛgmʼn duw luku ab ɛm a ecʼabu ɛlum ɛm. ");
INSERT INTO adj_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mois anake ↄny Israɛl eyŋ ok ↄkm Ejipt, low any iti owi lele mɛny ɛwr owi e li kok ɛb ab ɛm, Okij Ebl a ogŋ a lele loj ab ɛm eke -nʼanŋn toŋ ij akpo ekŋ yony a. ");
INSERT INTO adj_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ɛmɛny Mois na cɛ anake dad Israɛl eyŋ ninɛ: “Nyam bʼow awŋ ↄnykokobaↄb ɛs nyam ɛsɛ ɛm afeke bʼow el ↄny ecʼagŋ ab ɛm ecʼɛgŋ nyam.” ");
INSERT INTO adj_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Eke Israɛl eyŋ as luku loj a, Mois anake anŋ ɛy lagŋɛl lele afr ɛrm ɛs a eke am dadʼr odad Sinayi lafɛny af a ecʼaraŋn a; ɛtŋ lʼeb sel ɛŋn e sodad Nyam ogŋ lʼow nʼↄŋ ɛy. ");
INSERT INTO adj_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Gbɛkↄ ɛy lagŋɛl ɛgŋm ↄnym in ecʼɛlum; -lʼigŋ ow ɛtŋ -lʼerur eke -li kʼɛwl mɛny -nʼim Ejipt. ");
INSERT INTO adj_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","-Li dad Arↄn ninɛ: “Kòk sinyam eke bʼan es ɛy ecʼany af ↄŋ ɛy, kↄ Mois ekʼↄny ok ɛy ↄkm Ejipt a, sʼuwm low yecʼeke ɛŋnʼn ab any.” ");
INSERT INTO adj_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","-Li kok id ewli ɛsɛ nyàm af ɛtŋ -li waw egb -nʼↄŋ ow, -li gbɛgbl es nyàm na ekʼɛl obi -li kokr a eci. ");
INSERT INTO adj_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Nyam ↄny nyamn oc ɛl es af ɛtŋ ɛgb ɛl es -lʼigŋ afr e mílɛ́l nuŋ, ɛsɛ elel eke wɛl nↄn kokoba ↄb ɛsɛl e lɛl ɛm ab af: Israɛl eyŋ, tasi, ɛm aprʼm mindey lele segb waw ɛjecʼab loj a eke anŋn toŋ ow ij akpo ekŋ yony ab ee? ");
INSERT INTO adj_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Njaŋ! Gbɛkↄ abur ↄny e nyàm Molↄk eci nuŋ igŋ êl a lele ↄny e lɛ́l nyàm Refan e mɛny ɛwr ab ab owr, ekŋ ɛm nyàm amua eke kokr eke kʼigŋn nuŋ a. Na sosiɛm anake mi bʼow mʼɛwl ↄny madu ↄkr ɛm, usu eke ibn akm Babilↄn. ");
INSERT INTO adj_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Gbad ɛm êl a eke sinm a e lɛl anŋ ɛm a, ɛy lagŋɛl ↄnym ab loj a. Wɛl usʼr kpɛ kpɛ kpɛ ɛsɛ elel eke Nyam yɛgmn Mois ab af. ");
INSERT INTO adj_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Gbad ɛm êl ikŋ na wɛl ocʼr ↄŋ ey a ekʼusr ɛy lagŋɛl usu a; -lʼoc ab -nʼim lɛgŋ ab ɛm eke Joswe am nyimn ɛl a. Nyam ogŋ ɛb ɛb a ekʼanŋ ɛl anym a, ɛtŋ -lʼeb sɛb a. Êl a gbɛ anŋ toŋ igŋ David e lɛgŋ ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David ɛŋn bibm Nyam ecʼany af ɛtŋ lʼibrm ow abusu eke li kʼus êl nyam nʼↄŋ Jakↄb e Nyam a. ");
INSERT INTO adj_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Gbɛkↄ, Salomↄ anake us êl a. ");
INSERT INTO adj_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Ke Afr Kpekpe e Nyam a írm mel ekʼagŋ ecʼabu bʼus ab ɛm, ɛsɛ elel eke kokoba ↄb ɛs a dad ab af: ");
INSERT INTO adj_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","Nyam dad ninɛ: “Afr el ɛm ecʼɛb ir usu, ɛtŋ wus el ɛm ecʼakr es ok usu. Bogŋ ecʼêl tasi ↄtur eke kʼusr ↄŋnʼm ee? Bogŋ ogŋ tasi mʼↄtu eke mi kʼir ee? ");
INSERT INTO adj_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ɛtŋ kↄ ow elm ɛm obi mi kokm mob amua fɛŋ ee?” ");
INSERT INTO adj_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Ɔny agŋ és ɛfuu ekʼↄny ecʼɛrm lel ↄru ab babl Nyam ecʼɛsŋ a e lís; sɛgŋ fɛŋ am atarir Abŋ Lala ab cɛ! Ɔny anŋn ɛsɛ ↄny lagŋɛl ab af! ");
INSERT INTO adj_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Bogŋ eci kokoba ↄb ɛs ↄny lagŋɛl ijrm gbre ee? -Lʼibi agŋ a ekʼↄb ɛl Nɛny Nyam Ɛs nyam coco a eke kʼow a e kokoba a; ɛtŋ sica in anake ↄny ɛjur ir ke ibir ir a. ");
INSERT INTO adj_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ɔny eke Nyam ɛcr in ecʼafr ɛrm ɛsɛl ab ɛm ↄŋ ↄny in ecʼol a, ↄny, ɛluamn ol ikŋ na!» ");
INSERT INTO adj_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Sanedrɛn ecʼagŋ a ɛrm ebl afŋn es sodad amua eke -lʼirir a sosiɛm, ɛtŋ -nʼam sasagr an ɛm -lʼok Etiɛn af. ");
INSERT INTO adj_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Kↄ ekʼAbŋ Lala iyʼr ɛm a, nʼam lɛr afr, ɛtŋ lʼɛkn Nyam ecʼanygbɛl a lele Jesu ekʼinym es Nyam e lidr abu af ab. ");
INSERT INTO adj_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Li dad ninɛ: «Ɛ̀kan, mʼam ɛkn afr eke fig lele ɛgŋ ecʼIy ekʼinym es Nyam e lidr abu af ab.» ");
INSERT INTO adj_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Eke -li bʼiri ɛbɛn a, -li babl ↄru es ɛtŋ -nʼam babarm. Ɛl fɛŋ -lʼok Etiɛn af, ");
INSERT INTO adj_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","-lʼↄdu -lʼɛlu ow ↄkm baŋn a, ɛtŋ -nʼam ↄr ow mebn ɛm eke -li kʼibi ow. Adaŋku a ok ɛl e mob sus ɛm ab es ŋgbafrɛ nyam eke wɛl bʼɛsŋ Sↄl a ecʼanym eke kʼↄsu. ");
INSERT INTO adj_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Eke wɛl am ↄrʼr mebn ɛm a, Etiɛn am ŋↄŋn Nyam ɛsɛ: «Ɛs Kↄtↄkↄ Jesu, èb ɛm ecʼabŋ a!» ");
INSERT INTO adj_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Ow e jam a, lʼok ↄwrↄkp wus ɛtŋ li barm lebl tuↄtuↄ ɛm ninɛ: «Ɛs Kↄtↄkↄ, kʼↄ̀ŋ ɛl -li kʼebr ɛm e luw na e ligbↄw!» Eke li dad sodad amua ba ow bʼuwr a, lʼok sel es. ");
INSERT INTO adj_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sↄl ɛgŋ Etiɛn ecʼibi a e low eb. Lɛgŋ a cɛ gbre ijr ligbɛl ↄbr Nyamel ekʼanŋ Jerusalɛm a. Agŋ a ekʼↄny ↄmn a fɛŋ uru ↄmu es Jude lele Samari ab e wus ab af; ɛrm ɛsɛl a gbɛ urum es. ");
INSERT INTO adj_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Agŋ ekʼↄny Nyam e muru a oc Etiɛn im oc es ɛtŋ ikŋ in e luw a ecʼↄŋn nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Kↄ Sↄl ekʼerur eke ki ŋuŋn Nyamel a, aam akŋ akŋ ↄny agŋ a fɛŋ ekʼↄny ↄmn a, egŋ lele ↄyↄw ab ok sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Sica agŋ a ekʼↄny ↄmn ke ↄmu es a, am ↄb Amani Mamn e kokoba usu a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filip im Samari ecʼɛb ligbɛl ab ɛm ɛtŋ am dad ɛb eyŋ a Mesi a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Dedeku a nɛny af okr ɛm am ɛw Filip ecʼodad a ɛrm af, aŋke -nʼam iri ɛtŋ -nʼam ɛkn mɛny ɛwr a eke nʼam kok a. ");
INSERT INTO adj_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Tasi ɛm a, abŋ eŋuŋ am babarm ok ↄkm ↄ́lu nↄnↄ ɛm, ɛtŋ agŋ e bubm es lel akr kpɛcɛ ɛsɛl nↄnↄ ab yɛji am ewl. ");
INSERT INTO adj_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ow ↄŋ sos ɛm iŋn ligbɛl ɛy ɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Igŋ nyam eke wɛl bʼɛsŋ Simↄ ikŋ anym anŋ baŋn a. Li bi kok cam owi ɛtŋ li bʼↄŋ Samari eyŋ nimum anŋ low any iti ligbɛl ɛm. Li bʼocr in sosi any ɛs, ");
INSERT INTO adj_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ɛtŋ agŋ a fɛŋ, igŋ ŋgbafrɛ toŋ agŋ ekpekp a bʼɛw in e low ɛrm af. Wɛl bi dad ɛsɛ: «Ɛgŋ na “Nyam ecʼabusu”, yecʼa eke wɛl bʼɛsŋ “Abusu Ligbɛl a.” » ");
INSERT INTO adj_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","-Li bʼɛw ow e low ɛrm af nↄnↄ, aŋke lɛgŋ kpekpe ɛtŋ, li kok ów any iti owi nʼↄŋ wɛl in e cam owi ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Gbɛkↄ sica Filip ↄb ɛl Amani Mamn a, Nyam e gbreŋgbi usu a lele Jesu Krist e nin ab ab e kokoba. Agŋ a fɛŋ ekʼub nawrɛ a, egŋ lele ↄyↄw ab, wɛl ok ɛl mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simↄ in obi yɛji ub nawrɛ ɛtŋ wɛl okʼr mij nuŋ; li bʼanŋ Filip saw ɛtŋ mɛny ɛwr ɛgbɛl a lele sakrowa ab ab eke nʼam ɛkn ow am kok a e low am itiʼr any. ");
INSERT INTO adj_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Eke ɛrm ɛsɛl ekʼanŋ Jerusalɛm a iri eke Samari eyŋ ɛgŋ Nyam ecʼodad a eb a, -lʼɛrm Piɛr lele Jan ab im yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Eke -nʼimn -lʼokr yogŋ a, -ni ŋↄŋn Nyam agŋ a ekʼub nawrɛ a eci, yecʼɛtŋ ke wɛl ɛ́ŋn Abŋ Lala. ");
INSERT INTO adj_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Tasi ɛm a, Abŋ Lala kʼusm es ɛl ɛm ecʼɛgŋ kaka af; kↄ mij nuŋ gbɛ wɛl ok ɛl Ɛs Kↄtↄkↄ Jesu e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ca Piɛr lele Jan ab at ɛl abu nuŋ ɛtŋ -nʼɛŋn Abŋ Lala. ");
INSERT INTO adj_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Eke Simↄ ɛkn eke ɛrm ɛsɛl a am at agŋ a ekʼub nawrɛ a abu nuŋ ke -nʼam ɛŋn Abŋ Lala a, nʼam ↄl eke li kʼↄŋ Piɛr lele Jan ab os. ");
INSERT INTO adj_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Nʼam dad lʼɛsɛ: «Ɛm yɛji, ↄŋnʼm abusu ikŋ na, yecʼɛtŋ ke ɛgŋ yecʼeke mi bʼat abu nuŋ a ɛ́ŋn Abŋ Lala.» ");
INSERT INTO adj_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Kↄ Piɛr dadʼr ninɛ: «Ke ŋ ecʼos a lele ŋ obi ab úgŋn es, aŋke ŋ e tutr ɛm a, wɛl ↄtu eke kʼↄl Nyam ecʼob ap a os ɛm! ");
INSERT INTO adj_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Low na otmʼŋ es ɛtŋ ŋ e low yɛji anm ɛm, aŋke ŋ ecʼɛrm a inyam Nyam ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ìgŋ ŋ ecʼów tutr eŋuŋ a ok es, ke ŋↄ́ŋn Ɛs Kↄtↄkↄ yecʼɛtŋ ke ekʼow it, lʼóc tutr na ekʼↄny a lʼapʼŋ. ");
INSERT INTO adj_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Tasi ɛm a, mʼam ɛkn ekʼów tutr lolo iyʼŋ ɛm gbↄŋ ɛtŋ el sikpl ecʼadu.» ");
INSERT INTO adj_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simↄ dad Piɛr lele Jan ab ninɛ: «Ɔny obi ŋↄŋan Ɛs Kↄtↄkↄ ↄŋnʼm, yecʼɛtŋ ke ów amua fɛŋ eke dadr a kʼɛ́ŋnm im.» ");
INSERT INTO adj_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Sica eke ɛrm ɛsɛl yony a ij daŋku ke dad Ɛs Kↄtↄkↄ ecʼodad a, -lʼɛwl -nʼim Jerusalɛm. Ejagb eke -lʼusr -nʼaam a, -lʼↄb Amani Mamn e kokoba Samari e sɛb nↄnↄ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Sica Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam dad Filip ninɛ: «Bʼow imn esr ɛm ecʼa, ebr a ekʼam usr mɛny es Jerusalɛm ɛtŋ imn Gaza ecʼab af, yecʼa ekʼɛcr loj a.» ");
INSERT INTO adj_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kpɛkŋ Filip igb im. Ɛtŋ ebr ab af, nʼɛŋn igŋ nyam; ow el Etiopi iy igŋ agbru nyam, juma ɛs ligbɛl eke bʼↄsu Etiopi ecʼɛb eb yↄw Kandas a ecʼob ↄny a fɛŋ. Lʼow Jerusalɛm lʼigŋ Nyam nuŋ ");
INSERT INTO adj_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","batŋ nʼam ɛwl mɛny nʼim in ogŋ a. Li sig es in e lɛtŋ a eke gbaŋkↄ bʼↄdu ab ɛm nʼam awl kokoba ↄb ɛs Esayi e lɛl a. ");
INSERT INTO adj_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Abŋ Lala dad Filip ninɛ: «Ìm toŋ ke títm lɛtŋ a.» ");
INSERT INTO adj_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip uru es im titm lɛtŋ a ɛtŋ iri Etiopi iy a ekʼam awl kokoba ↄb ɛs Esayi e lɛl a. Lʼibrm ow ninɛ: «Kↄ lɛl a ekʼam awl a ow am okʼŋ es sos ɛm ee?» ");
INSERT INTO adj_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Igŋ a ↄdu eb ninɛ: «Ayaf ow ↄtu eke kʼokʼm es sos ɛm ekʼɛgŋ otarm akr okm im ee?» Ɛtŋ li dad Filip eke kʼɛy lɛtŋ ab ɛm ke sígʼr es saw. ");
INSERT INTO adj_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Lɛl a e nʼam awl a el na: Ɛsɛ licɛb eke wɛl bʼoc im ibi usu af, ɛsɛ licɛbli eke baram agŋ a ekʼam iriʼr suw es a ecʼany af ab af, li dadm low kaka. ");
INSERT INTO adj_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Nʼɛŋn ɛ́s ɛtŋ ɛmɛny wɛl ɛgŋm in e low ij a ↄↄmʼn. Kↄ bwo bʼow dad in ecʼey ecʼodad ee? Tasi ɛm a, in e sel uwr wus na af. ");
INSERT INTO adj_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Igŋ a ibrm Filip ninɛ: «Mʼam ŋↄŋnʼŋ dadʼm, kokoba ↄb ɛs a, bwo ecʼɛgŋ ecʼodad nʼam dad ee? Kↄ in obi e low oglog ɛgŋ ɛjeci e low nʼam dad ee?» ");
INSERT INTO adj_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Filip ↄb nuŋ odad ikpr na af, ɛtŋ am otar Jesu ecʼAmani Mamn a ecʼów akr okʼr. ");
INSERT INTO adj_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Eke -nʼanŋn ejagb ab af -nʼaam a, -lʼok usu nyam eke mij anŋ ɛtŋ igŋ a dad ninɛ: «Kin mij, bla lowi am ɛdŋnʼm eke mi kʼok mij nuŋ ee?»  ");
INSERT INTO adj_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filip dadʼr ninɛ: «Eke ↄny ↄmn ŋ ecʼɛrm fɛŋ ɛm, ↄtu eke kʼok mij nuŋ.» Ɛtŋ ɛgŋ a dadʼr ninɛ: «Mʼↄny ↄmn eke Jesu Krist el Nyam ecʼIy.» ");
INSERT INTO adj_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Ɛtŋ nʼↄŋ lɛtŋ a inym es. Filip lele igŋ ab ab us es mij ab ɛm ɛtŋ Filip okʼr mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Eke -nʼanŋn mij ab ɛm -lʼokr ↄkm a, kpɛkŋ Ɛs Kↄtↄkↄ ecʼAbŋ ↄny Filip oc es ɛtŋ igŋ a ɛknmʼn ij; gbɛkↄ sos ɛm iŋn ɛm Etiopi iy a eb ejagb aam. ");
INSERT INTO adj_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ɛtŋ kpɛkŋ Filip ɛkn eke ow el Asↄt baŋn anake nʼanŋ a, ɛtŋ nʼam ɛc lʼↄb Amani Mamn e kokoba baŋn baŋn a toŋ lʼok Sesare. ");
INSERT INTO adj_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Lɛgŋ ab ɛm a, Sↄl ecʼɛrmij ebr a el ke nʼám ↄↄr Ɛs Kↄtↄkↄ e jam ɛsɛl a abr wɛl ecʼibi eci. Nʼim nʼɛŋn egb waw ɛs ligbɛl a ");
INSERT INTO adj_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ɛtŋ lʼibrm ow eke ow kʼↄŋʼn silɛl ekʼow ɛm Damas ɛb ɛm e Nyam nuŋ igŋ susu a wɛl kʼuwrʼr any, yecʼɛtŋ eke nʼɛ́ŋn agŋ, egŋ oglog ↄyↄw ekʼam us Ɛs Kↄtↄkↄ Jesu ecʼejagb a, lʼↄ́tu nʼↄny wɛl ke lʼót wɛl lʼow Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Eke Sↄl us ejagb aam Damas ke nʼam titm yogŋ a, kpru ɛm, usu ayl anŋ afr ɛjn iwr ɛlul il ɛm. ");
INSERT INTO adj_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Lʼɛy wus ɛtŋ lʼiri lebl nyam eke am dadʼr ɛsɛ: «Sↄl, Sↄl, kↄ bla sosiɛm ɛtŋ am ijrʼm gbre ee?» ");
INSERT INTO adj_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Lʼibrm ow ninɛ: «Ɛgŋ gbɛl, kↄ bwo elʼŋ ee?» Ɛtŋ lebl a ↄdu eb dadʼr ninɛ: «Ɛm Jesu ekʼam ijr gbre a. ");
INSERT INTO adj_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Sica ìgb wus, ìm ɛb ab ɛm, yogŋ wɛl bʼow dadʼŋ low yecʼekʼit eke ki kok a.» ");
INSERT INTO adj_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Agŋ a ekʼus ejagb Sↄl ab a uk inym es ɛtŋ -lʼↄtumn -li dadmn low kaka; -nʼam iri lebl a gↄŋ, kↄ -lʼɛknmn ɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sↄl anŋ wus igb ɛtŋ pig pig anyamn, kↄ lʼↄtum lʼɛknm low kaka. Wɛl ↄnyʼn abu ocʼr im Damas. ");
INSERT INTO adj_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Sɛgŋ emum nyahan eke lʼↄtum lʼɛknm es, lʼijm ob kaka ke lʼɛgŋm mij yɛji. ");
INSERT INTO adj_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Damas yogŋ jam ɛs nyam anŋ eke wɛl bʼɛsŋ Ananias. Ɛs Kↄtↄkↄ yɛgmʼn sos es ɛkn ɛm ɛtŋ dadʼr ninɛ: «Ananias!» Lʼɛgŋ ninɛ: «Ɛs Kↄtↄkↄ, kin ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ɛs Kↄtↄkↄ dadʼr ninɛ: «Ìgb caca cɛ im ɛbɛrŋ eke wɛl bʼɛsŋ “Nyim Nyim” ab ɛm, ke Judas ecʼakŋ a, íbrm ɛgŋ nyam eke wɛl bʼɛsŋ Sↄl, Tars iy. Nʼanŋ Nyam ŋↄŋn ɛm wanci na af. ");
INSERT INTO adj_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ɛtŋ es ɛkn ɛm, lʼɛkn ɛgŋ nyam eke wɛl bʼɛsŋ Ananias ekʼam ɛy akŋ atʼr abu nuŋ yecʼɛtŋ ke ɛmɛny lʼↄ́tu lʼɛkn es.» ");
INSERT INTO adj_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ananias ↄdu eb dadʼr ninɛ: «Ɛs Kↄtↄkↄ, agŋ nↄnↄ dadʼm ɛgŋ na e low ɛtŋ -li dadʼm ów eŋuŋ fɛŋ eke li kok ŋ ecʼagŋ ekʼanŋ Jerusalɛm a e lís. ");
INSERT INTO adj_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ɛtŋ lʼow aŋa abusu a ekʼegb waw ɛsɛl ɛgbɛl ↄŋʼn ab ab eke li kʼↄny agŋ a eke bʼɛsŋ ŋ e nin a.» ");
INSERT INTO adj_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Gbɛkↄ Ɛs Kↄtↄkↄ dadʼr ninɛ: «Ìm, aŋke mi sↄsum ɛgŋ na mʼoc ɛtŋ mi bʼow mʼɛcr in ɛm mʼɛlu ɛm e nin a ↄkm ɛbr ɛbr ɛjecʼa ecʼagŋ eci, ɛl eci ɛ́b ebu a lel Israɛl ecʼagŋ ab ab ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Ɛm obi ɛm obi mi bʼow mi yɛgmʼn gbre fɛŋ eke li bʼow lʼij ɛm e nin a ecʼa.» ");
INSERT INTO adj_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Sica Ananias im ɛtŋ eke lʼɛy akŋ a, lʼat Sↄl abu nuŋ ɛtŋ li dad ow ninɛ: «Ɛm lisijim Sↄl, ejagb a eke ebr am ow a, Ɛs Kↄtↄkↄ ɛlu sos ↄkm yɛgmʼŋ. In anake lʼɛrmʼm mʼow a. Lʼɛrmʼm mʼow yecʼɛtŋ ke ɛmɛny ↄ́tu ɛkn es, ke Abŋ Lala íyʼŋ ɛm gbↄŋ.» ");
INSERT INTO adj_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kpɛkŋ ob ekʼanŋ ɛsɛ ↄcn sel af a anŋ Sↄl ecʼanyamn ab ɛm ok wus ɛtŋ ɛmɛny lʼↄtu lʼɛkn es. Lʼigb ɛtŋ wɛl okʼr mij nuŋ; ");
INSERT INTO adj_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ɛtŋ eke lʼij ob a, lɛc owʼr ɛm. Sↄl anŋ jam ɛsɛl a ekʼir Damas ab ab sɛgŋ bɛb. ");
INSERT INTO adj_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Kpɛkŋ nʼam ↄb kokoba Nyam nuŋ igŋ susu, li dad eke Jesu in el Nyam jim. ");
INSERT INTO adj_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Agŋ a fɛŋ ekʼam iriʼr lebl a low am iti any ɛtŋ am dad ɛsɛ: «Kↄ ow elm ɛgŋ a eke Jerusalɛm am ijr agŋ a eke bʼɛsŋ Jesu e nin a gbre ab ee? Ɛtŋ aŋa eke lʼow a gbɛ, ow elm eke li kʼↄny wɛl ke lʼɛ́wl wɛl egb waw ɛsɛl ecʼes ɛwɛl a ogŋ ee?» ");
INSERT INTO adj_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Eke Sↄl am yɛgm Jwifɛl a ekʼir Damas a eke Jesu in el Mesi a, nʼam dad low a lɛc ɛm toŋ Jwifɛl a ɛ́knm low eke ki dad. ");
INSERT INTO adj_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Eke ow ibn a, Jwifɛl a ut asre eke kʼↄŋ wɛl ibi Sↄl, ");
INSERT INTO adj_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","kↄ Sↄl iri ɛl ecʼasre ut a e low. Ow ↄŋ ncok lele lɛgŋ owr ab, wɛl am ↄsu baŋn a e masany a yecʼɛtŋ ke wɛl íbiʼr. ");
INSERT INTO adj_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ow sosiɛm, ncok nyam Sↄl e jam ɛsɛl a ↄny ɛluʼl ulu nyam ɛm ɛtŋ ↄny usmʼn es baŋn a e lakp jam a. ");
INSERT INTO adj_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Eke Sↄl im ɛy Jerusalɛm a, lʼↄl eke li kʼɛy jam ɛsɛl ab ɛm, kↄ ɛl fɛŋ in e low am ↄny ɛl erŋn, aŋke -li kʼubm nawrɛ eke ow kʼel jam ɛs tasi. ");
INSERT INTO adj_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Barnabas ocʼr ab im ɛtŋ ɛwlʼl ɛrm ɛsɛl a ogŋ. Ɛtŋ lʼotar elel eke Sↄl ɛkan Ɛs Kↄtↄkↄ ejagb af, lele elel eke Ɛs Kↄtↄkↄ dadr Sↄl odad ab a, e low akr lʼok wɛl. Ɛmɛny lʼotar elel eke lokm susu ɛm Sↄl ↄb Jesu e nin a e kokoba Damas a yɛji e low akr lʼok wɛl. ");
INSERT INTO adj_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Yogŋ ɛtŋ Sↄl anŋ ɛl ab, ɛtŋ Jerusalɛm ɛb ab ɛm nʼam ɛc lʼↄb kokoba ↄmn ɛm tasi Ɛs Kↄtↄkↄ e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Li bi dad odad lʼok Jwifɛl eke bʼɛbr Grɛk a yɛji, ɛtŋ wɛl ab li bʼatar ów es; kↄ agŋ amua am erur eke kʼↄŋ wɛl ibiʼr. ");
INSERT INTO adj_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Eke agŋ lisijimɛl a iri ow e low a, -lʼoc Sↄl -lʼus nuŋ es -nʼim Sesare ɛb ɛm ɛtŋ -nʼↄŋ ow imn Tars eci. ");
INSERT INTO adj_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Sica Nyamel anŋ ɛrm es ɛy ɛm Jude wus af nimum, Galile lele Samari ab. Nʼam agb ↄmn ɛm ɛtŋ nʼam ir ɛb Ɛs Kↄtↄkↄ ecʼɛlum ɛm. Abŋ Lala ecʼabu ɛlum ɛm a, nawrɛ ub ɛsɛl a am bobn. ");
INSERT INTO adj_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Eke Piɛr am ɛc usu a fɛŋ a, lɛgŋ nyam nʼim lʼok Lida baŋn ecʼagŋ a ekʼub nawrɛ a ogŋ. ");
INSERT INTO adj_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Yogŋ, nʼɛŋn igŋ nyam eke wɛl bʼɛsŋ Ene eke ɛru es ob ɛrur ob af toŋ akpo niwn, aŋke li bubm es. ");
INSERT INTO adj_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Piɛr dadʼr ninɛ: «Ene, Jesu Krist am ewlmʼŋ! Ìgb ke ár ŋ ecʼob ɛrur ob ab es ŋ obi.» Kpɛkŋ Ene anŋ wus igb. ");
INSERT INTO adj_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Lida baŋn ecʼagŋ a fɛŋ lele Sarↄn wus pɛtɛ ab af ecʼagŋ a ekʼɛkn Ene ecʼewlm owi a, itŋn ɛrm ɛm ɛtŋ el Ɛs Kↄtↄkↄ eci. ");
INSERT INTO adj_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Jope baŋn, jam us lis nyam anŋ eke wɛl bʼɛsŋ Tabita. (Nin a Grɛk ɛm a “Dↄrkas”, ɛtŋ ow e nyandrɛ el “ndeyɛgŋ”.) Sɛgŋ fɛŋ abu bʼanŋʼn low nimamn e kok ɛm lele ↄgbↄru ecʼabu ɛlum owi ɛm ab. ");
INSERT INTO adj_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Lɛgŋ nyam lʼɛy ↄl ɛtŋ luw ibiʼr. Eke wɛl okʼr mij bake ow uwr a, wɛl kokʼr sos ɛtŋ wɛl ocʼr im ɛrumʼn es êl afr a ecʼoj nyam ɛm. ");
INSERT INTO adj_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Eke Lida titm Jope ke jam ɛsɛl a ekʼanŋ Jope a iri eke Piɛr in anŋ yogŋ a, -lʼɛrm agŋ yony eke kʼim ↄŋʼn amani na: «Sʼam ŋↄŋnʼŋ, ìgbm ab kpɛkŋ ow ɛy ogŋ aŋa.» ");
INSERT INTO adj_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Eke Piɛr ɛŋn amani a, kpɛkŋ lʼigb nʼim ɛ́rmu ab ab. Eke lʼow lʼɛy yogŋ a, wɛl oc imʼn êl afr a ecʼoj ab ɛm. Eŋnyↄw a fɛŋ ow titmʼn am ikŋ ↄŋn, ɛtŋ am yɛgmʼn sikotu a lele simob af ɛw a eke Tabita kok in ecʼowr anŋ ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Piɛr ↄŋ agŋ a fɛŋ ok gbeŋ ɛtŋ lʼok ↄwrↄkp wus ni ŋↄŋn Nyam. Sica lʼɛwl lʼↄkŋ lɛgŋuw ab any ɛtŋ li dad ninɛ: «Tabita, ìgb wus!» Lɛgŋuw a fig fig anyamn ɛtŋ eke lʼɛkn Piɛr a, lʼigb li sig es. ");
INSERT INTO adj_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piɛr ucu abu ↄnyʼn ɛlumʼn abu lʼigb nʼinym es. Ow e jam a, lʼɛsŋ eŋnyↄw a lele ↄmn ↄny ɛsɛl ab ab ɛtŋ li yɛgm wɛl Tabita ekʼanŋ owr. ");
INSERT INTO adj_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Low a eb es Jope baŋn a nimum ɛtŋ agŋ nↄnↄ ↄny ↄmn Ɛs Kↄtↄkↄ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Piɛr anŋ Jope kok sɛgŋ nↄnↄ, ndey lɛl juma kok ɛs nyam eke wɛl bʼɛsŋ Simↄ a ecʼakŋ. ");
INSERT INTO adj_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Sesare ɛb ɛm, igŋ nyam anŋ eke wɛl bʼɛsŋ Kↄrnɛy. Rom eci srↄda eyŋ ekŋ yen ecʼeb nyam eke wɛl bʼɛsŋ “Itali eb a”, lʼel ow ecʼanym ɛs. ");
INSERT INTO adj_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Lʼel Nyam nuŋ igŋ ɛs tasi; in lel in ecʼakŋ a fɛŋ ab -lʼↄpimn Nyam nuŋ igŋ. Sakp nↄnↄ li bʼɛlum Jwifɛl ɛm ecʼↄgbↄru abu ɛtŋ li bi ŋↄŋn Nyam sɛgŋ fɛŋ. ");
INSERT INTO adj_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ncebles nyam eci wanci nyahan ɛm, lʼɛkn es, kpata Nyam ecʼafr ɛrm ɛs nyam ekʼɛy in ecʼakŋ a ke ɛsŋʼn: «Kↄrnɛy!» ");
INSERT INTO adj_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Li lɛr afr ɛrm ɛs a erŋn ab ɛtŋ lʼibrm ow ninɛ: «Ɛgŋ gbɛl, kↄ bla lowi ee?» Afr ɛrm ɛs a dadʼr ninɛ: «Nyam ɛgŋ ŋ e ŋↄŋn a lele ↄgbↄru ecʼabu eke bʼɛlum ab ab e low eb, ɛtŋ lʼijlm ŋ es. ");
INSERT INTO adj_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Sica, ↄŋ agŋ ím Jope ɛsŋ ɛgŋ nyam eke wɛl bʼɛsŋ Simↄ Piɛr a ow. ");
INSERT INTO adj_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Nʼanŋ ndey lɛl juma kok ɛs nyam eke wɛl bʼɛsŋ Simↄ, ekʼin ecʼêl a anŋ okij nɛny a ogŋ.» ");
INSERT INTO adj_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Ekʼafr ɛrm ɛs a e dadʼr odad a im a, Kↄrnɛy ɛsŋ in ecʼakŋ juma kok ɛsɛl ab ɛm e yony lel in e srↄda eyŋ ab ɛm e nyam eke bʼanŋʼn saw, ke el Nyam nuŋ igŋ ɛs tasi ab ab ow. ");
INSERT INTO adj_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Lʼotar low a fɛŋ ekʼɛy a akr lʼok wɛl ɛtŋ lʼɛrm wɛl Jope. ");
INSERT INTO adj_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Eke lɛgŋ ɛny akr af, ke ɛ́rmu nyahan a ekʼus ejagb a am titm Jope a, Piɛr uyu êl luw af pɛtɛ ab af Nyam ŋↄŋn eci. Ke lɛgŋ uyu nuŋ ŋ̂, ");
INSERT INTO adj_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ɛtŋ namn owʼr sos; eke wɛl am kok in ecʼob ij owi a, nʼam ɛkan nuŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Lʼɛkn afr ekʼagbr ɛm ɛtŋ ob nyam anŋ ɛm am us es: ob ekʼanŋ ɛsɛ gbad ligbɛl af eke wɛl ucu ow ecʼɛnyɛmbri yar a ↄny es ke am is es wus. ");
INSERT INTO adj_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Gbad ab af mindey ɛrŋ ɛrŋ a fɛŋ ekʼɛli akr yar, lel ɛl eke bʼɛrir es wus wus, lele ↄr ɛrŋ ɛrŋ a fɛŋ ab anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Lebl nyam dad ninɛ: «Piɛr, ìgb, ìbi ke íj!» ");
INSERT INTO adj_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Gbɛkↄ Piɛr ↄdu eb dad ninɛ: «Ɛs Kↄtↄkↄ, mi kʼↄtum, aŋke lɛgŋ kaka mʼijm ob eke wɛl ɛdŋn oglog ob ekʼaylm ŋ eci any af a.» ");
INSERT INTO adj_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Ɛmɛny lebl a ikŋn ɛm ɛtŋ dad ninɛ: «Kì lɛr ob yecʼeke Nyam ayal a ɛsɛ ob ekʼaylm af.» ");
INSERT INTO adj_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Low a ɛy ↄkm kpa kpa kpa sakp nyahan ɛtŋ kpɛkŋ ob a ɛwl mɛny im afr. ");
INSERT INTO adj_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Piɛr am tutr low na eke lʼɛkn es ɛkn ɛm a e nyandrɛ. Kↄ wanci ab af, agŋ a eke Kↄrnɛy ɛrm a bi bibrm uw yogŋ eke Simↄ ecʼêl a kʼanŋ ab any, ɛtŋ sica -lʼow -lʼok lisany a. ");
INSERT INTO adj_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","-Nʼam ibrm -lʼɛsɛ: «Kↄ aŋa anake Simↄ Piɛr anŋ ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Piɛr anŋ am tutr es ɛkn a e nyandrɛ, ɛtŋ Abŋ dadʼr ninɛ: «Kin agŋ nyahan anŋ aŋa am ↄlʼŋ. ");
INSERT INTO adj_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Ìgb, ùs es, ke ím ɛl ab; kì bɛbar aŋke ɛm mʼɛrm ɛl -lʼow.» ");
INSERT INTO adj_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Piɛr us es im ɛŋn agŋ a ɛtŋ dad ɛl ninɛ: «Ɛm, ɛgŋ a ekʼam ↄↄl ab ana. Kↄ bla sosiɛm owr ee?» ");
INSERT INTO adj_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","-Li dad ninɛ: «Ɛy, ɛy ecʼanym ɛs Kↄrnɛy e nin ɛm sʼow. Lʼel nɛny nyam ɛs eke bʼigŋ Nyam nuŋ ɛtŋ Jwifɛl a fɛŋ bʼawʼr. Nyam ecʼɛrm ɛs nyam ow dadʼr eke li kʼɛsŋʼŋ ow in ogŋ a, ke lʼíri yecʼa eke bʼow ↄny dadʼr a.» ");
INSERT INTO adj_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ɛtŋ sica Piɛr eb ok ɛl akŋ ncok a eci. Eke lɛgŋ ɛny a, lʼus ejagb wɛl ab, ɛtŋ Jope ecʼagŋ lisijimɛl bɛb ɛwlʼl. ");
INSERT INTO adj_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Eke ɛmɛny lɛgŋ ɛny akr af a, lʼɛy Sesare. Kↄrnɛy lel in ecʼakŋ ecʼagŋ a lele lawlɛl tasi eke lʼɛw abu ow a, anŋ ɛl ecʼeku ɛm. ");
INSERT INTO adj_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Wanci ab af eke Piɛr am ow ɛy akŋ a, Kↄrnɛy igb ow ↄbrʼr ɛtŋ ok ↄwrↄkp wus in ecʼany af, ɛsŋn in ɛlum ligbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Kↄ Piɛr ↄny igbmʼn ɛtŋ dadʼr ninɛ: «Ìgb, aŋke ɛm yɛji ɛgŋ cɛ mʼel.» ");
INSERT INTO adj_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ɛtŋ eke nʼam ot nɛnym Kↄrnɛy ab a, lʼɛy akŋ a; yogŋ, lʼɛkn agŋ nↄnↄ eke as luku. ");
INSERT INTO adj_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Li dad wɛl ninɛ: «Uwr any eke Jwif eci Nyam nuŋ igŋ ebr a ↄↄm abusu eke li kʼim lʼɛkn utu ɛgŋ oglog lʼɛy ow ecʼakŋ a. Kↄ ɛm, Nyam yɛgmʼm eke mi kʼócm ɛgŋ kaka fɛŋ ɛsɛ ɛgŋ eke aylm oglog ɛgŋ ekʼitm eke wɛl kʼim ɛkn af. ");
INSERT INTO adj_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Na sosiɛm, eke ɛsŋnʼm a, mʼↄnym nɛny mʼocm es ɛtŋ mʼow. Sica mʼam erur eke mi kʼuw low a nuŋ af eke ɛsŋʼm ab any.» ");
INSERT INTO adj_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kↄrnɛy ↄdu eb dad ninɛ: «Ow ij sɛgŋ nyahan eke wanci nɛnɛ af ekʼel ncebles e wanci nyahan ɛm a eke mʼanŋ ɛm ogŋ a Nyam ŋↄŋn ɛm a, kpru ɛm ɛgŋ nyam eke sus mob ekʼam jɛjn a inymʼm es anym. ");
INSERT INTO adj_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Li dadʼm ninɛ: “Kↄrnɛy, Nyam iri ŋ e ŋↄŋn e lebl a ɛtŋ lʼijlm abu ɛlum ekʼↄŋ ↄgbↄru ab es. ");
INSERT INTO adj_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Ɛ̀rm agŋ ím Jope ɛsŋ Simↄ Piɛr ow. Nʼanŋ ndey lɛl juma kok ɛs nyam eke wɛl bʼɛsŋ Simↄ a ecʼêl ekʼanŋ okij nɛny ab ɛm.” ");
INSERT INTO adj_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kpɛkŋ mʼɛrm agŋ ow ɛsŋʼŋ ɛtŋ erur ow. Sica ɛy fɛŋ sʼanŋ aŋa Nyam ecʼany af eke si kʼiri ów a fɛŋ eke Ɛs Kↄtↄkↄ abulʼŋ eke ki dad ɛy a.» ");
INSERT INTO adj_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Piɛr eb odad ɛtŋ dad ninɛ: «Sica ow am okʼm es sos ɛm tasi eke njɛ Nyam am jɛjm agŋ es, ");
INSERT INTO adj_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","kↄ ɛb kaka fɛŋ ɛm, ɛgŋ kaka fɛŋ eke bʼↄny in ecʼɛlum ke bi kok low nyim nyim a, li bʼeb ow. ");
INSERT INTO adj_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Nʼawŋ Israɛl ecʼagŋ in ecʼamani a: Amani Mamn a el ɛrm es ɛy a ekʼanŋ Jesu Krist a ekʼel agŋ fɛŋ ecʼƐs Kↄtↄkↄ ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Eke Jan ↄb kokoba ke ok agŋ mij nuŋ bake ow uwr a, low yecʼa eke ikŋ anym ɛy Galile toŋ ke eb Israɛl nimum ɛm a, uwr any. ");
INSERT INTO adj_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Uwr elel eke Nyam ↄŋn Nasarɛt e Jesu in ecʼAbŋ Lala a lele abusu ab ab any. Uwr elel yɛjʼeke Jesu ɛcr wus nimum af kok ów amamn, ke ewlm agŋ a fɛŋ ekʼanŋ agn ecʼes ɛw ab ɛm a, aŋke Nyam anŋ in ab. ");
INSERT INTO adj_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ɛtŋ ɛy sʼij ów a fɛŋ eke li kok Jerusalɛm lele Israɛl wus af ab a e daŋku. Wɛl ɛwʼr olikŋ af ɛtŋ lʼuw, ");
INSERT INTO adj_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","gbɛkↄ eke ow bi kok sɛgŋ nyahan a, Nyam ↄŋʼn nʼanŋ owr, ɛtŋ ow ↄŋʼn abusu eke li kʼɛlu sos ↄkm. ");
INSERT INTO adj_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Ow elm agŋ a fɛŋ ecʼany af lʼɛlum sos ↄkm, kↄ ɛy a cɛ eke Nyam ikŋ anym sↄsum ot ɛsɛ adaŋku af a ecʼany af. Eke Nyam igbmʼn agŋ ekʼuw ab ɛm a, sʼij ɛtŋ sʼɛgŋ in ab. ");
INSERT INTO adj_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Nʼↄŋ ɛy abusu eke si kʼↄb kokoba sʼok agŋ a, ke si dad eke in anake Nyam ɛwʼr eke li ki jɛj agŋ ekʼuw lel agŋ ekʼanŋ owr ab ab e low lʼok a. ");
INSERT INTO adj_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Kokoba ↄb ɛsɛl a fɛŋ dad in e low ekʼɛgŋ kaka fɛŋ ekʼin ub ow nawrɛ a, ɛgŋ a e sikpl a in bʼow in ↄny oc ap ow e nin a ecʼabusu ab ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Eke Piɛr odad anŋ nɛnym kʼuwrm a, Abŋ Lala us es agŋ a fɛŋ eke am iri in ecʼodad ab af. ");
INSERT INTO adj_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ɔmn ɛsɛl a ekʼel Jwifɛl ke igŋ Piɛr ab ow a, low am iti any eke Nyam ecʼAbŋ Lala a eke bʼↄŋ agŋ a, kʼim ɛŋn agŋ ekʼelm Jwifɛl a. ");
INSERT INTO adj_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Tasi ɛm a, -nʼam iri wɛl am dad sodad sɛbr eke wɛl uwm any ɛm, ɛtŋ wɛl am kↄklm Nyam e sagb a. Ow sosiɛm Piɛr dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","«Kↄ wɛl ↄtu eke kʼɛdŋn agŋ amua mij ok nuŋ, sica eke -nʼɛŋan Abŋ Lala ɛsɛ ɛy af ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Ɛtŋ nʼↄŋ abusu eke wɛl kʼok wɛl mij nuŋ Jesu Krist e nin ɛm. Ow e jam a, -lʼibrm eke Piɛr kʼanŋ ɛl ab sɛgŋ bɛb. ");
INSERT INTO adj_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ɛrm ɛsɛl a lel agŋ lisijimɛl a ekʼanŋ Jude ab ab iri ekʼagŋ ekʼelm Jwifɛl a yɛji ɛgŋ Nyam ecʼodad a eb. ");
INSERT INTO adj_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Eke Piɛr ɛwl mɛny uyu ow Jerusalɛm a, Jwifɛl ekʼↄny ↄmn a am okʼr ów af ");
INSERT INTO adj_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","dad ɛsɛ: «Ɛ̀ɛ́! Im ɛy agŋ ekʼelm Jwifɛl a ogŋ ɛtŋ ij ob ɛl ab!» ");
INSERT INTO adj_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ow sosiɛm, Piɛr otar low a ekʼɛy a akr mɛwl ɛm ok ɛl. Li dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«Mʼanŋ Jope ɛb ab ɛm, ɛtŋ eke mʼam ŋↄŋn Nyam a, mʼam ɛkn es. Mʼɛkn ob nyam ekʼam us es ow ɛŋnʼm, ob ekʼanŋ ɛsɛ gbad ligbɛl af ke wɛl cucu ow ecʼɛnyɛmbri yar a ↄny es, ke anŋ afr am us es toŋ ow titmʼm. ");
INSERT INTO adj_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Mʼok any es mi lɛr lokm a ɛtŋ mʼɛkn mindey eke bʼɛli akr yar, akp ɛm ndey, mindey eke bʼɛrir es lele ↄr ab. ");
INSERT INTO adj_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Ɛtŋ mʼiri lebl nyam ekʼam dadʼm ɛsɛ: “Piɛr, ìgb, ìbi ke íj!” ");
INSERT INTO adj_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Gbɛkↄ mi dad mʼɛsɛ: “Njaŋ o, Ɛs Kↄtↄkↄ! Aŋke lɛgŋ kaka ob e wɛl ɛdŋn oglog ob ekʼaylm ŋ ecʼany af a ɛymʼm nɛnym.” ");
INSERT INTO adj_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ɛmɛny lebl a anŋ afr ikŋ dad ninɛ: “Ob eke Nyam dad eke ow ayl a, ŋ, kì dad kʼɛsɛ ow aylm.” ");
INSERT INTO adj_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Low a ɛy ɛbɛn ɛbɛn sakp nyahan ɛtŋ ob a ɛwl im afr. ");
INSERT INTO adj_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Wanci ab af cɛ, agŋ nyahan ow ok êl a eke sʼanŋ ɛm a ogŋ; Sesare ɛb ɛm ɛtŋ wɛl ɛrm ɛl -lʼow ɛm eci. ");
INSERT INTO adj_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Abŋ Lala dadʼm eke mi kʼim ɛl ab, ke bɛbar kʼánm ɛm ɛm. Agŋ lisijimɛl nↄhↄn na eke mʼot ab mʼow aŋa a, ɛwlʼm Sesare, ɛtŋ ɛy fɛŋ sʼok Kↄrnɛy ecʼakŋ a. ");
INSERT INTO adj_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Lʼotar elel eke lʼɛkan afr ɛrm ɛs nyam ekʼinym es in ecʼakŋ a, ke am dadʼr eke li kʼɛrm agŋ im Jope ɛsŋʼm mʼów, ");
INSERT INTO adj_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","mi dádʼr sodad eke bʼow el in lele in ecʼakŋ a nimum ab e sↄg eci. ");
INSERT INTO adj_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mʼↄb nuŋ mʼam dad ɛl odad, ɛtŋ kpɛkŋ Abŋ Lala us ɛl es af ɛsɛ elel eke ɛy yɛji lʼus ɛy es af nuŋ ↄb ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Kpɛkŋ mʼↄkn low yecʼa eke Ɛs Kↄtↄkↄ dad a: “Jan ok agŋ mij nuŋ mij ɛm, kↄ ↄny, wɛl bʼow ok ↄny mij nuŋ Abŋ Lala ɛm.” ");
INSERT INTO adj_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Ɛl yɛji Nyam ↄŋ ɛl ob ap nɛnyɛmbri nyam a eke nʼↄŋ ɛy lɛgŋ a eke sʼub Ɛs Kↄtↄkↄ Jesu Krist nawrɛ a: sica bwo elʼm eke mi kʼɛdŋn Nyam, low yecʼeke lʼerur eke li ki kok ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Eke sica -lʼirir sodad amua bake ow uwr a, -nʼↄny ɛrm es ɛy ɛtŋ -li kↄklm Nyam -li dad ninɛ: «Nawrɛ tasi, Nyam ↄŋ agŋ ekʼelm Jwifɛl a yɛji abusu eke kʼitŋn ɛrm ɛm ke ɛ́ŋn owr anŋ tasi a.» ");
INSERT INTO adj_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Etiɛn ekʼuw oc es e gbre ijr ekʼɛy a, ↄŋ ↄmn ɛsɛl a ↄmu es; ɛl ɛm ecʼagŋ bɛb im toŋ ok Fenisi, Sipr lele Antiↄs ɛb ɛm ab, gbɛkↄ agŋ ekʼel Jwifɛl a sↄny cɛ -nʼam dad Nyam ecʼodad a -lʼok. ");
INSERT INTO adj_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Kↄ ↄmn ɛsɛl bɛb ekʼel Sipr lele Sirɛn ɛb ɛm ecʼa, ow ok Antiↄs, ɛtŋ dad agŋ ekʼelm Jwifɛl a Ɛs Kↄtↄkↄ Jesu e lís ecʼAmani Mamn a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ɛs Kↄtↄkↄ ecʼabusu a anŋ ɛl ab, ow ↄŋ agŋ nↄnↄ gbɛl ub nawrɛ ɛtŋ itŋn ɛrm ɛm el Ɛs Kↄtↄkↄ eci. ");
INSERT INTO adj_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Jerusalɛm e Nyamel ecʼagŋ a iri low na ɛtŋ -lʼɛrm Barnabas im Antiↄs. ");
INSERT INTO adj_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Eke nʼim lʼɛy yogŋ ke lʼɛkn elel eke Nyam eci bibm a kokr ↄmn ɛsɛl a, sos ɛm iŋnʼn ɛtŋ lʼatr wɛl sos es eke wɛl kʼↄny ɛrm susu, úcu Ɛs Kↄtↄkↄ ↄny es. ");
INSERT INTO adj_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Tasi ɛm a, Barnabas el ɛgŋ sɛnyn sɛnyn eke Abŋ Lala lele ↄmn ab iy ɛm gbↄŋ. Agŋ nↄnↄ gbɛl ɛgŋ Ɛs Kↄtↄkↄ owi eb. ");
INSERT INTO adj_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Ow ↄŋ Barnabas im Tars eke kʼɛsŋ Sↄl. ");
INSERT INTO adj_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Eke nʼɛŋn ow a, lʼoc ow ab lʼɛwl lʼow Antiↄs. -Nʼanŋ yogŋ e Nyamel ab ɛm ɛl yony mum toŋ lakpo mum, ɛtŋ -li yɛgm agŋ nↄnↄ gbɛl low. Antiↄs ɛb ɛm anake wɛl ↄg es ɛsŋ jam ɛsɛl a “kretiɛnɛl a”. ");
INSERT INTO adj_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Lɛgŋ ab ɛm a, kokoba ↄb ɛsɛl anŋ Jerusalɛm ow Antiↄs. ");
INSERT INTO adj_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Abŋ Lala nyimn ɛl ɛm ecʼɛgŋ nyam eke wɛl bʼɛsŋ Agabus ɛtŋ am ↄb amani dad eke owʼn kʼow in ibnm ɛtŋ lek ligbɛl in bʼow in ɛy wus na nimum af. (Lek a ɛy tasi, lakpo ab af eke Klod el Sesar a.) ");
INSERT INTO adj_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ow ↄŋ jam ɛsɛl a ɛgŋ eb eke ɛgŋ ɛgŋ kʼↄŋ yecʼa eke nʼↄny ow ecʼabusu a, yecʼa ekʼↄtu eke kʼɛlum lisijimɛl ekʼanŋ Jude a abu a. ");
INSERT INTO adj_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","-Li kok ɛbɛn, ɛtŋ -lʼoc abu ɛlum a -nʼↄŋ Barnabas lele Sↄl ab oc im ↄŋ Jude wus af e Nyamel a ecʼagŋ ekpekp a. ");
INSERT INTO adj_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Lɛgŋ ab ɛm a, ɛb ebu Erↄd Agripa am ijr Nyamel ecʼagŋ nyam nyam gbre. ");
INSERT INTO adj_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nʼↄŋ wɛl ibi Jak ekʼel Jan lisijim a lab ler ɛm ɛm. ");
INSERT INTO adj_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","4","Sica eke lʼɛkn ekʼow akpl Jwifɛl a sos ɛm a, Futufutu eke ejru ánm ɛm ecʼes gbɛgbl e lɛgŋ ab ɛm, nʼↄŋ wɛl ↄny Piɛr ɛlu sobel ɛm, ɛtŋ nʼↄŋ srↄda eyŋ eb yar yar sakp yar am ↄsu ow. Nʼↄny tutr eke li ki jɛj ow e low lʼok dedeku a ecʼany af eke Pak ecʼes gbɛgbl a bʼoc es. ");
INSERT INTO adj_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kↄ eke Piɛr anŋ sobel ɛm a, Nyamel ecʼagŋ a am ŋↄŋn Nyam ↄŋʼn ↄmn ɛm tasi. ");
INSERT INTO adj_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ncok a eke lɛgŋ kʼɛny ke Erↄd jɛj in e low ok dedeku a ecʼany af a, Piɛr am ɛru mɛmn srↄda eyŋ yony ecʼaraŋn. Wɛl okʼr ŋgbraka yony ɛtŋ usu ↄsu ɛsɛl inym es, ɛgŋ ɛgŋ anŋ in ecʼusu sobel lisany a. ");
INSERT INTO adj_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kpru ɛm Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam ilm any ɛtŋ usuayl ɛjn ok sobel akŋ a. Afr ɛrm ɛs a iyr Piɛr abu mɛnɛgb ɛm, uwrʼr ɛtŋ dadʼr ninɛ: «Ìgb fafa!» Ŋgbraka a ekʼanŋʼn sabu a ɛr ok wus. ");
INSERT INTO adj_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Ɛtŋ afr ɛrm ɛs a dadʼr ninɛ: «Sùs ŋ e mob a, ke ók ŋ e cↄkrukpↄ a.» Piɛr ɛlumʼn ɛtŋ afr ɛrm ɛs a igŋ af dad ninɛ: «Sùs ŋ e mob af ɛw a ke úsʼm jam.» ");
INSERT INTO adj_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piɛr igŋ afr ɛrm ɛs a ugŋ ɛy ↄkm sobel ab ɛm. Li kʼↄnym ↄmn eke low a eke afr ɛrm ɛs a am kok a kʼel nawrɛ tasi: nʼam tutr eke ow el es ɛkn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","-Lʼafŋ krɛkrɛ ecʼusu ↄsu usu ab es, yony ɛm ecʼa yɛji ɛtŋ -nʼim -lʼok lowi lisany a ekʼↄkŋ baŋn ab any a ogŋ. Ɛl ecʼany af lisany a fig in obi ɛtŋ -lʼok ↄkm. -Nʼim -lʼok ɛbɛrŋ nyam ɛm, ɛtŋ kpru ɛm afr ɛrm ɛs a ɛluʼl es. ");
INSERT INTO adj_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Sica low a ekʼɛy a ok Piɛr es sos ɛm ɛtŋ li dad ninɛ: «Ca gbɛ, mʼam ɛkn ekʼow el nawrɛ tasi: Ɛs Kↄtↄkↄ anake ↄŋ in ecʼafr ɛrm ɛs ow eb ɛluʼm es Erↄd ecʼabusu ab ɛm eke mʼanŋ lele Jwifɛl e low ŋuŋ fɛŋ ekʼam tutr eke ki kok ɛm e lís ab ab a.» ");
INSERT INTO adj_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Sica eke ow okʼr es sos ɛm a, nʼim Mari ekʼel Jan Mark lis ecʼakŋ a. Yogŋ agŋ nↄnↄ gbɛl as luku anŋ Nyam ŋↄŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Piɛr cicm lisany abu, ɛtŋ akŋ juma kok lis nyam eke wɛl bʼɛsŋ Rod igb ow eke ki figʼr lisany a. ");
INSERT INTO adj_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Eke lʼiri lebl a ke lʼuw any ekʼow el Piɛr a, sos ɛm iŋnʼn toŋ lʼijl es eke li ki fig ow lisany a, kↄ lʼuru es nʼim li dad agŋ a eke Piɛr in anŋ lisany. ");
INSERT INTO adj_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","-Li dad ow ninɛ: «Nuŋ ɛm am uŋʼŋ!» Kↄ nɛny am atʼr es eke ow el low nawrɛ tasi. Ɛtŋ -li dad -lʼusr af ninɛ: «Ɛbɛn ke in ecʼafr ɛrm ɛs ana.» ");
INSERT INTO adj_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ɛbɛn yɛji Piɛr abu anŋ ɛm am cicm lisany a abu. Eke sica -li figr lisany a, -lʼɛkn ow ɛtŋ ow ɛw ɛl any iti. ");
INSERT INTO adj_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Li tat wɛl abu eke wɛl ki yewal ɛtŋ lʼotar elel eke Ɛs Kↄtↄkↄ ↄny ɛluʼl ↄkm sobel ab ɛm a e low akr lʼok wɛl. Ɛtŋ li dad ninɛ: «Dàdr low a okr Jak lel agŋ lisijimɛl bɛb ab ab.» Ɛtŋ lʼɛy ↄkm lʼeb ejagb nʼim usu ɛjeci. ");
INSERT INTO adj_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Sica eke usu ot es a, bↄbar ligbɛl ɛy srↄda eyŋ a ecʼaraŋn ɛtŋ -nʼam ibrm ɛl sosi low yecʼekʼɛŋn Piɛr a. ");
INSERT INTO adj_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Erↄd ↄŋ wɛl ↄl Piɛr es, kↄ wɛl ɛŋnmʼn. Li bibrm usu ↄsu ɛsɛl a low ɛtŋ nʼↄŋ abusu eke wɛl kʼibi ɛl. Ow e jam a, nʼanŋ Jude nʼim Sesare ɛtŋ yogŋ nʼanŋ sɛgŋ bɛb. ");
INSERT INTO adj_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Sica lɛgŋ nyam Erↄd ↄny ɛrm bebl ligbɛl Tir baŋn eyŋ lele Sidↄn baŋn eyŋ ab e lís. Baŋn a yony mum nɛny okr af eke kʼim ɛknʼn. In e saw ecʼɛgŋ ekʼel Blastus ɛm -lʼɛcr -nʼim -lʼibrm Erↄd eke ɛrm es ɛy kʼanŋ, aŋke ɛl e baŋn a yony mum bʼↄl ob ij ɛb ebu ecʼɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Eke lɛgŋ a eke wɛl ɛw a ow a, Erↄd sus in ecʼɛb es ɛw ɛs e mob sus ɛm a, li sig es ɛb ebu e lɛkpn af ɛtŋ nʼam dad wɛl ów dedeku ɛm. ");
INSERT INTO adj_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Dedeku a ↄg dad ninɛ: «Na nyàm anake am dad odad a, kↄ ow elm ɛgŋ.» ");
INSERT INTO adj_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Kↄ, kpru ɛm, Ɛs Kↄtↄkↄ ecʼafr ɛrm ɛs nyam kok Erↄd low, aŋke anygbɛl a ekʼel Nyam ecʼa lʼɛgŋm nʼↄↄm ow, ɛtŋ sɛgŋ bɛb bʼɛc a sisŋ ijʼr lʼuw. ");
INSERT INTO adj_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nyam ecʼodad a gbɛ am eb es obn. ");
INSERT INTO adj_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Eke Barnabas lele Sↄl ab uwar ɛl e juma Jerusalɛm a, -lʼoc Jan Mark -lʼɛwl mɛny ab -nʼim Antiↄs. ");
INSERT INTO adj_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Antiↄs e Nyamel ab ɛm, kokoba ↄb ɛsɛl lele low yɛgm ɛsɛl ab ekʼanŋ a ecʼen el: Barnabas, Simeↄn (eke wɛl igŋ nin af Nijɛr), Lusius (Sirɛn baŋn iy), Manayɛn (ekʼel Galile ecʼes ɛw ɛs Erↄd Antipas e mew ɛm e lawl), lele Sↄl ab. ");
INSERT INTO adj_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Lɛgŋ nyam, eke -nʼam ŋↄŋn Nyam ke -nʼam ɛnŋ nɛny a, Abŋ Lala dad ɛl ninɛ: «Òcr Barnabas lele Sↄl ab ɛwr saw yecʼɛtŋ ke -li kok juma a eke mʼɛsŋ ɛl ow ecʼa.» ");
INSERT INTO adj_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Ow sosiɛm, eke -nʼɛnŋn nɛny, -ni ŋↄŋan Nyam toŋ ke ow uwr a, -lʼat Barnabas lele Sↄl ab abu nuŋ ɛtŋ -nʼↄŋ wɛl abusu wɛl im. ");
INSERT INTO adj_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","EkʼAbŋ Lala ɛrm Barnabas lele Sↄl ab a, -nʼim -lʼok Selesi baŋn ɛtŋ yogŋ, -lʼeb mijɛtŋ -nʼim Sipr lekr ɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Eke -nʼimn -lʼokr Salamin baŋn a, -nʼam dad Nyam odad Jwifɛl e Nyam nuŋ igŋ susu a. Jan Mark yɛji anŋ ɛl ab ɛl eci abu ɛlum eci. ");
INSERT INTO adj_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","-Lʼubr lekr a kpɛkŋ kpɛkŋ toŋ -lʼok Pafↄs ekʼanŋ nuŋ a. Yogŋ, -nʼɛŋn cam ɛs nyam eke wɛl bʼɛsŋ Bar Jesu; lʼel Jwif nyam eke bʼocr in sosi kokoba ↄb ɛs. ");
INSERT INTO adj_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Lʼir Sɛrgius Polus, lekr a ecʼes ɛw ɛs ekʼel nuŋ ɛm ↄny ɛs a ogŋ. Nʼↄŋ wɛl ɛsŋ Barnabas lele Sↄl ab aŋke lʼerur eke li kʼiri Nyam odad. ");
INSERT INTO adj_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Gbɛkↄ cam ɛs eke wɛl bʼɛsŋ Grɛk ɛm Elimas a bʼatar Barnabas lele Sↄl ab ów es ɛtŋ am ↄl eke kʼirmn es ɛw ɛs a ecʼↄmn a eke kʼↄny a. ");
INSERT INTO adj_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Sↄl eke wɛl bʼɛsŋ Pↄl yɛji, ke Abŋ Lala iy ɛm a, ↄkŋ cam ɛs ab any ");
INSERT INTO adj_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","ɛtŋ dadʼr ninɛ: «Yadŋ gbɛl ɛs eke low ŋuŋ kok eb sos! Agn e liy! Low mamn fɛŋ ecʼifnu! Ɛs Kↄtↄkↄ ecʼów amamn a eke bɛbm ok es a, bʼↄl eke kʼↄny wuwal. Kↄ kʼow walm ow e low ɛlum es ee? ");
INSERT INTO adj_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sica ìri gↄŋ: Ɛs Kↄtↄkↄ bʼow efalʼŋ any ɛtŋ kʼow ɛknm ligbn ecʼusuayl a sɛgŋ bɛb.» Kpɛkŋ Elimas any efl ɛtŋ anŋ ncebn ɛm; nʼam bↄbrm lʼↄl ɛgŋ eke kʼↄnyʼn abu. ");
INSERT INTO adj_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Eke es ɛw ɛs ɛkn low a ekʼɛy a, lʼub nawrɛ ɛtŋ Ɛs Kↄtↄkↄ e lís e low yɛgm a okʼr es sos ɛm nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Sica Pↄl lele agŋ a ekʼam usʼr jam ab ab eb mijɛtŋ Pafↄs nanu ɛtŋ im ok Pɛrj, Panfili wus af. Ɛtŋ Jan Mark ɛlu ɛl es yogŋ ɛwl im Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ɛl gbɛ, -lʼigŋ Pɛrj -lʼus ejagb kpɛkŋ kpɛkŋ toŋ -nʼim -lʼok Pisidi wus af ecʼAntiↄs a. Eke nɛnɛgŋ e lɛgŋ ow a, -lʼok Nyam nuŋ igŋ usu a -lʼok es. ");
INSERT INTO adj_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Eke wɛl awl lɛl ol e silɛl ab ɛm lele kokoba ↄb ɛsɛl ecʼab ɛm uwr a, Nyam nuŋ igŋ usu a ecʼes ɛw ɛsɛl a ↄŋ ɛgŋ im dad ɛl ninɛ: «Agŋ lisijimɛl, ekʼↄnyn ów ↄm ecʼodad eke ki dadr atar dedeku a sos es, ke ↄtur eke ki dadr gↄŋ.» ");
INSERT INTO adj_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Pↄl igb tat ɛl abu ɛtŋ dad ninɛ: «Israɛl ecʼagŋ lele ↄny ekʼelmn Jwifɛl ke anŋn aŋa Nyam nuŋ igŋ ecʼa, ìgŋn lↄru es irir! ");
INSERT INTO adj_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Nyam ekʼel Israɛl ecʼagŋ a e Nyam a sↄsum ɛy lagŋɛl ot. Nʼɛnyn agŋ amua lɛgŋ ab ɛm eke -lʼiir etuɛb Ejipt wus af a. Ɛtŋ in e lɛc ab ɛm nʼↄny lʼot wɛl es Ejipt. ");
INSERT INTO adj_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Loj yogŋ, nʼↄnym wɛl ab ow ij akpo ekŋ yony. ");
INSERT INTO adj_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Kana wus af a, ni ŋuŋn ɛb lↄbŋ ɛtŋ lʼoc wɛl eci wus a nʼↄŋ in ecʼagŋ a ɛsɛ ɛl ecʼaja ob cɛ af. ");
INSERT INTO adj_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ów amua fɛŋ ↄtu eke kʼij akpo duw akpo ekŋ yony lele lɛw ab. Low na bʼɛc a, nʼↄŋ ɛy lagŋɛl jɛj ok ɛsɛl toŋ ow ok kokoba ↄb ɛs Samiɛl e lɛgŋ ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sica -lʼibrm ɛb ebu nyam ɛtŋ Nyam ↄŋ ɛl Saul, Kis jim, Bɛnjamɛ ecʼeb ɛm ecʼɛgŋ ekʼɛw ɛb ab es ow ij akpo ekŋ yony. ");
INSERT INTO adj_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Eke sica Nyam igŋ Saul ɛlu es a, nʼↄŋ wɛl David ɛsɛ ɛb ebu af. Nʼam dad David e lís e low lʼɛsɛ: Mʼɛŋn Jese jim David: lʼel ɛm ecʼɛrm ecʼerur, li bʼow li kok low fɛŋ e mʼerur eke li ki kok a. ");
INSERT INTO adj_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","David ecʼalaw ab ɛm e nyam el Jesu eke Nyam oc ɛw Israɛl eci Es Eb Ɛlu Ɛs, ɛsɛ elel eke lʼɛwar lʼɛw es ab af. ");
INSERT INTO adj_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Gbuŋ ke Jesu ów a, Jan dad Nyam odad ibrm ekʼIsraɛl ecʼagŋ a nimum kʼitŋn ɛrm ɛm ke ók mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Eke sica Jan am uwar in e juma a, nʼam dad lʼɛsɛ: “Kↄ ↄny, bwo ecʼɛgŋ am ocrʼm eke mʼel ee? Mʼelm ɛgŋ a ekʼam ekur a. Gbɛkↄ ìrir, ɛgŋ nyam anŋʼm jam am ow, ɛtŋ mʼitm bↄbↄ yɛji eke mi kʼↄny in e cↄkrukpↄ meb a mi mↄmuʼn es akr ɛm.” ");
INSERT INTO adj_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Agŋ lisijimɛl, ↄny ekʼeel Abraham ecʼalaw lele ↄny ekʼelmn Jwifɛl ke anŋn aŋa Nyam nuŋ igŋ ecʼa, ɛy fɛŋ anake wɛl is ɛy es eb ɛlu ecʼodad na a. ");
INSERT INTO adj_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Tasi ɛm a, Jerusalɛm ecʼagŋ a lele ɛl eci es ɛw ɛsɛl ab ab uwm ɛgŋ a ekʼel Jesu ab any, ɛtŋ kokoba ↄb ɛsɛl eci silɛl eke wɛl bʼawl nɛnɛgŋ fɛŋ a, -lʼirim ow okm ɛl es sos ɛm. Gbɛkↄ eke -lʼↄbr Jesu low a, -nʼↄŋ sodad a fɛŋ iy nɛny. ");
INSERT INTO adj_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","-Nʼɛŋnm low kaka ekʼow ɛm -li kʼibi ow, kↄ -li dad Pilat eke kʼibiʼr. ");
INSERT INTO adj_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Eke -li kokr fɛŋ a eke Nyam Lɛl ɛwar Jesu eci lís a, -lʼusm ow es olikŋ af ɛtŋ -lʼɛlu ow uwↄmu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Gbɛkↄ Nyam igbmʼn luw ɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Sɛgŋ nↄnↄ gbɛl, agŋ a ekʼus Jesu jam Galile ɛtŋ toŋ im ok Jerusalɛm a ecʼany af, lʼokm sos ↄkm ɛtŋ sica agŋ a el in ecʼadaŋku Israɛl ecʼagŋ ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","33","Ɛy obi yɛji, sʼam is ↄny Amani Mamn na. Sica eke Nyam igbm Jesu luw ɛm a, low yecʼa eke lʼɛwar ɛy lagŋɛl a, li kok ow iy nɛny ɛy eke sʼel ɛl ecʼey a eci, ɛsɛ elel eke wɛl nↄn Selu yony ɛm ab af: “Ŋ ɛm ecʼiy, yɛfɛnyna ɛm a, mʼel asŋ”. ");
INSERT INTO adj_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Nyam ikŋ anym ɛwar eke in bʼow in igbm Jesu luw ɛm yecʼɛtŋ ke owʼn kʼɛ́wlm in ugŋm es ij. Li dad ninɛ: “Mʼow mʼↄŋ ↄny ów amamn a eke ɛm obi mʼɛwar eke mi kʼↄŋ David a, ɛtŋ ↄtur eke kʼↄnyn ↄmn ow ɛm.” ");
INSERT INTO adj_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Na sosiɛm anake Nyam Lɛl ɛjecʼɛm nʼam dad lʼɛsɛ: Kʼow yɛbm ŋ e libↄwi mamn ugŋm es uwↄmu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","David e lɛgŋ ɛm a, li kok Nyam e juma e bɛbm ɛw es a toŋ batŋ lʼuw, wɛl ocʼr es lagŋɛl e saw ɛtŋ lʼugŋ es; ");
INSERT INTO adj_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","kↄ in a eke Nyam igbm luw ɛm a, lʼugŋm es. ");
INSERT INTO adj_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","39","Agŋ lisijimɛl, ow it eke kʼuwr any eke Jesu ɛm anake ↄtur ↄnyn sikpl eci oc ap a. Mois ecʼol a ↄtum ebm ɛlum ↄny es ↄny e sikpl ab ɛm, kↄ agŋ fɛŋ eke ↄny ↄmn Jesu ɛm a, Nyam ot ɛl ɛsɛ agŋ nyim nyim af. ");
INSERT INTO adj_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Sica ɛ̀wr ɛrm yecʼɛtŋ ke low na eke kokoba ↄb ɛsɛl dad a kʼɛ́ŋnm ↄny: ");
INSERT INTO adj_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","“Ɛ̀kan, ↄny, Nyam e miyɛr kokr ɛsɛl, low a íti ↄny any, ke írmn ocr es! Aŋke ↄny ecʼowr anŋ ɛm, mʼow mi kok low nyam eke kʼow ubmn nawrɛ, eke ɛgŋ am dad ↄny ow ecʼodad bↄbↄ yɛji.” » ");
INSERT INTO adj_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Eke Pↄl lele Barnabas ab ok ↄkm Nyam nuŋ igŋ usu a, wɛl ibrm eke nɛnɛgŋ ekʼam ow a, -li kʼɛwl mɛny -lʼow -li dad odad nyam na cɛ. ");
INSERT INTO adj_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Eke luku as a uwr a, Jwifɛl nↄnↄ lele agŋ a ekʼɛgŋ ɛl e Nyam nuŋ igŋ e low eb a, am us Pↄl lele Barnabas ab jam. -Nʼam dad wɛl eke -li kʼinym es kikri Nyam eci lɛc a eke bʼↄŋ ɛl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Eke nɛnɛgŋ ow a, ow anŋ ɛsɛ ɛb ab ɛm ecʼagŋ a fɛŋ cɛ in im in am iri Ɛs Kↄtↄkↄ ecʼodad af. ");
INSERT INTO adj_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Eke Jwifɛl ɛkn dedeku na a, ow ↄny ɛl nyamnɛyr; -nʼam wɛwr Pↄl ɛtŋ -nʼam ↄny odad -lʼoc ow es nɛnym. ");
INSERT INTO adj_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Pↄl lele Barnabas ab am dad ɛl odad tasi ɛsɛ: «Ɔny, ow it eke wɛl kʼikŋ anym dad ↄny Nyam ecʼodad a yɛ; gbɛkↄ eke ebmn odad a, ke am ocar ↄny sosi ɛsɛ agŋ eke kʼↄtum ɛŋnm sel ekʼↄnym uwr a, sica si bʼow sʼim agŋ ekʼelm Jwifɛl a ogŋ! ");
INSERT INTO adj_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Kin low yecʼeke Ɛs Kↄtↄkↄ ↄŋ ɛy ow ecʼabusu a: Mʼocʼŋ ɛsɛ ɛbr ɛbr a fɛŋ ecʼusuayl af, yecʼɛtŋ ke yɛ́gm wus na nimum ecʼagŋ a, elel eke -li kʼɛŋan sel a.» ");
INSERT INTO adj_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Eke agŋ ekʼelm Jwifɛl a iri ów amua a, sos ɛm iŋn ɛl ɛtŋ -nʼam ɛlu Ɛs Kↄtↄkↄ bia odad na eci; ɛtŋ agŋ a fɛŋ eke Nyam ikŋ anym ɛw sel ekʼↄnym uwr ecʼa, ub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Nyam ecʼodad a eb es wus a nimum af. ");
INSERT INTO adj_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Kↄ Jwifɛl a ok bosu amamn ɛm ecʼↄyↄw a eke bʼigŋ Nyam nuŋ a lele ɛb a eci nyimn ɛsɛl ab ab al lokm; -lʼijr Pↄl lele Barnabas ab gbre ɛtŋ -lʼogŋ wɛl ɛl eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Pↄl lele Barnabas ab cic akr sɛc ok ɛl es ɛtŋ im Ikoniↄm. ");
INSERT INTO adj_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Jam ɛsɛl a ekʼanŋ Antiↄs a ecʼa, sos ɛm iŋn ligbɛl lele Abŋ Lala eke -nʼɛŋan ab a afŋn ɛl es. ");
INSERT INTO adj_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ɛsɛ Antiↄs ecʼab af, eke Pↄl lele Barnabas ab im ok Ikoniↄm ɛb ɛm yogŋ a, -nʼim -lʼok Jwifɛl e Nyam nuŋ igŋ usu a, ɛtŋ -nʼam dad Nyam odad toŋ batŋ Jwifɛl lele agŋ ekʼelm Jwifɛl ab ab e nↄnↄ ub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Gbɛkↄ Jwifɛl a ekʼerurm eke kʼub nawrɛ a, itr agŋ a ekʼelm Jwifɛl a toŋ -nʼↄny agŋ lisijimɛl a e tutr ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kↄ Pↄl lele Barnabas ab ubrm ɛl e lɛgŋ ab es. Eke -nʼↄnyn ↄmn nↄnↄ Ɛs Kↄtↄkↄ ɛm a, -nʼam dad Nyam eci sↄrŋ ikŋ a ecʼodad ɛrm susu ɛm. Ɛs Kↄtↄkↄ am ↄŋ ɛl abusu -li kok simɛny ɛwr lele ów any iti owi ab, ɛtŋ ow ɛm a, nʼam yɛgm eke wɛl ecʼodad a el nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ɛb ab ɛm ecʼagŋ a ubr ɛm yony: agŋ likpr inym es Jwifɛl a eci, ɛtŋ bɛb inym es ɛrm ɛsɛl a eci. ");
INSERT INTO adj_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Jwifɛl lele ɛl ekʼelm Jwifɛl a lele ɛl ecʼes ɛw ɛsɛl ab ab, am bɛbm eke kʼijr Pↄl lele Barnabas ab gbre ke íbi ɛl mebn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Eke -li bʼuw any a, -lʼuru es -nʼimn Likaoni wus af e sɛb ab a ekʼel Lisr, Dɛrb, lele ow e saw saw ab ab eci. ");
INSERT INTO adj_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Yogŋ yɛji, -nʼam ↄb Amani Mamn a e kokoba. ");
INSERT INTO adj_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Lisr yogŋ, ɛgŋ nyam anŋ eke bi sig es cɛ aŋke li bubm es. In e mew ɛm ɛtŋ sos ɛyrʼr ɛtŋ lɛgŋ kaka lʼↄtum nʼanm es. ");
INSERT INTO adj_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Lɛgŋ nyam Pↄl am dad odad ɛtŋ nʼam iri. Pↄl okʼr anyamn af am lɛrʼr ɛtŋ lʼɛkn eke ɛgŋ a ↄny ↄmn eke kʼewl. ");
INSERT INTO adj_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Li dad ow lebl tuↄtuↄ ɛm ninɛ: «Ìgb, ìnym es ceŋ!» Ɛgŋ a igb us es ɛtŋ am an es. ");
INSERT INTO adj_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Eke dedeku a ɛkn low a eke Pↄl kok a, -lʼↄg -li dad ɛl ecʼɛbr ekʼel Likaoni ab ɛm ninɛ: «Sinyam itŋn sos el agŋ ow ɛŋn ɛy!» ");
INSERT INTO adj_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","-Nʼam ɛsŋ Barnabas “Zes” ɛtŋ -nʼam ɛsŋ Pↄl “Ɛrmɛs”, aŋke Pↄl anake bʼↄb amani a. ");
INSERT INTO adj_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Zes eci nyam ŋↄŋn usu a anŋ ɛb a ecʼɛm ɛy usu a. In ecʼegb waw ɛs a ot sed lele suw amamn ab ow lisany a ecʼany af; lʼerur eke dedeku ab ab -li ki waw egb -nʼↄŋ Barnabas lele Pↄl ab. ");
INSERT INTO adj_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Gbɛkↄ eke Barnabas lele Pↄl ab iri low na a, -nʼↄny ɛl eci mob sus ɛm a -li gbagbrm ɛm, ɛtŋ -lʼuru es -lʼok dedeku ab ɛm -nʼam ɛlu lebl -li dad -lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«Agŋ lisijimɛl, kↄ bla ɛtŋ am kokr ɛbɛn ee? Agŋ cɛ sʼel ɛsɛ ↄny af. Sʼam is ↄny Amani Mamn a eke kʼigŋn ↄny e sinyam ekekey na ekʼel ob ↄfr ↄfr a okr es, ke ɛ́wal lɛɛr Nyam ekʼanŋ owr ke kok afr, wus, okij lele ob fɛŋ ekʼanŋ ɛm ab ab a. ");
INSERT INTO adj_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Godo godo a, li yɛb ɛbr ɛbr a fɛŋ eb ɛl obi ecʼejagb eke -lʼerurir. ");
INSERT INTO adj_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Gbɛkↄ sɛgŋ fɛŋ li bʼokm sos ↄkm in ecʼɛrm mamn ↄny ab ɛm: li bʼↄŋ mij anŋ afr ɛtŋ an ok ↄny wus ɛtŋ li bʼↄŋ ↄny egb eke kʼubr ekʼow e lɛgŋ bʼow a; li bʼↄŋ ↄny ob ij ɛtŋ li bi yibr ↄny ecʼɛrm a sos ɛm iŋn.» ");
INSERT INTO adj_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Sodad amua e dad ɛm bↄbↄ yɛji, ɛrm ɛsɛl a ij gbre eke kʼɛdŋn dedeku a eke ki waw egb ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Jwifɛl ekʼanŋ Pisidi eci Antiↄs a lele Ikoniↄm ab a ow ɛtŋ eb dedeku a. -Lʼↄr Pↄl mebn ɛm ibi eci, ɛtŋ -lʼↄdu -lʼɛlu ow ↄkm baŋn a aŋke -li tutr ekʼow uw ŋ̂. ");
INSERT INTO adj_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Sica eke jam ɛsɛl a ow ar ɛlul il ɛm a, lʼigb wus lʼɛwl lʼɛy baŋn a. Eke lɛgŋ bʼɛny a, Barnabas ab -nʼim Dɛrb. ");
INSERT INTO adj_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pↄl lele Barnabas ab im ↄb Amani Mamn e kokoba Dɛrb ɛb ɛm; yogŋ, -li kok agŋ nↄnↄ el jam ɛsɛl. Sica -lʼɛwl mɛny -nʼim Lisr, Ikoniↄm, lele Pisidi eci Antiↄs ab ab. ");
INSERT INTO adj_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","-Lʼusur jam ɛsɛl a ɛrm, -lʼatr wɛl sos es eke wɛl kʼinym es tuↄtuↄ wɛl ecʼↄmn ab ɛm ɛtŋ -nʼam dad wɛl -lʼɛsɛ: «Ow it eke si kʼijr gbre nↄnↄ gbuŋ ke sʼók Nyam e gbreŋgbi usu a.» ");
INSERT INTO adj_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Nyamel fɛŋ ɛm, -li bʼɛnm agŋ ekpekp -nʼↄŋ wɛl ɛtŋ eke -li bʼɛnŋ nɛny -ni ŋↄŋn Nyam a, -li bʼafl wɛl es -nʼↄŋ Ɛs Kↄtↄkↄ eke agŋ amua ↄny ↄmn in ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Ɛmɛny -lʼubr Pisidi wus a ɛtŋ -nʼim -lʼok Panfili eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Pɛrj ɛb ɛm yogŋ, -lʼↄb Nyam ecʼAmani Mamn a e kokoba ɛtŋ sica -nʼim -lʼok Atali ɛb ɛm. ");
INSERT INTO adj_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","-Lʼigb yogŋ mijɛtŋ ɛm -nʼaam Siri ecʼAntiↄs a. Ɛb na ɛm anake wɛl ot ok ɛl Nyam eci nyimn mamn ab ɛm juma na eke sica -li kokr -lʼuwarir a ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Eke -nʼimn -lʼokr yogŋ a, -lʼas Nyamel ecʼagŋ a luku -li dad wɛl ów a fɛŋ eke Nyam ɛcr ɛl ɛm kok a, lele elel eke Nyam figr agŋ ekʼelm Jwifɛl a yɛji ↄmn e lakp a. ");
INSERT INTO adj_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","-Nʼanŋ yogŋ jam ɛsɛl ab ab ow ibn nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Agŋ bɛb anŋ Jude ow Siri eci Antiↄs a ɛtŋ am yɛgm agŋ lisijimɛl a low dad ɛsɛ: «Eke ubrmn likr es ɛsɛ elel eke Mois ecʼol a am ibrm ab af a, kʼow ↄtumn ɛŋnmn es eb ɛlu.» ");
INSERT INTO adj_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pↄl lele Barnabas ab ɛgŋm low na ebm ɛtŋ -lʼatar ów es ligbɛl agŋ ab ab. Wɛl ɛgŋ eb eke Pↄl, Barnabas lele Antiↄs ecʼagŋ bɛb ab kʼim Jerusalɛm ke ɛrm ɛsɛl a lele agŋ ekpekp ab ab -li dad odad na. ");
INSERT INTO adj_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Ɛtŋ Nyamel a ɛkn ɛl ecʼusu im a e low. -Lʼɛcr Fenisi lele Samari ab eci, ɛtŋ -nʼam awl elel ekʼagŋ ekʼelm Jwifɛl a ocr any ↄkŋn Nyam a e low; amani na ↄŋ agŋ lisijimɛl a ↄny sos ɛm iŋn ligbɛl. ");
INSERT INTO adj_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Eke -lʼokr Jerusalɛm a, Nyamel a, ɛrm ɛsɛl a, lele agŋ ekpekp ab ab eb ɛl, ɛtŋ ów a fɛŋ eke Nyam ɛcr ɛl ɛm kok a, -nʼam awl -lʼok wɛl. ");
INSERT INTO adj_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Gbɛkↄ Farisiɛl ecʼogog ecʼagŋ bɛb ekʼↄny ↄmn a, igb ɛtŋ am dad ɛsɛ: «Ke wɛl búbr agŋ a ekʼↄny ↄmn kʼelm Jwifɛl a ekr es ke wɛl ↄ́ŋ ɛl -lʼɛlum Mois ecʼol a.» ");
INSERT INTO adj_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Ɛrm ɛsɛl a lele agŋ ekpekp ab ab as luku ɛtŋ am ↄny odad na igbl ogŋ ɛkn. ");
INSERT INTO adj_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Eke -lʼatarir ów es kpekpe a, Piɛr eb odad ɛtŋ dad ninɛ: «Agŋ lisijimɛl, uwr any eke lɛgŋ a ɛtŋ Nyam sↄsum ocʼm ↄny ecʼaraŋn eke mi kʼↄb Amani Mamn e kokoba mʼók agŋ ekʼelm Jwifɛl a, yecʼɛtŋ ke -lʼiri ke -lʼub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ɛtŋ Nyam eke uw agŋ eci mɛrm ab any a, ɛlu ↄkm yɛgm eke lʼeb wɛl; nʼↄŋ wɛl Abŋ Lala ɛsɛ ɛy af. ");
INSERT INTO adj_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Ɛl lele ɛy ab ecʼaraŋn a, lʼokm ereb kaka: lʼayal wɛl ecʼɛrm a aŋke -nʼↄny ↄmn. ");
INSERT INTO adj_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ɛtŋ sica bla sosiɛm am sismn Nyam odad agŋ a ekʼↄny ↄmn a ecʼɛrɛkp leg leg ecʼuyul ɛm, ɛrɛkp ekʼɛy lagŋɛl lele ɛy obi ɛy obi ab, sʼↄtum sʼuyum ab ee? ");
INSERT INTO adj_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ke tasi ɛm a, sʼub nawrɛ eke Ɛs Kↄtↄkↄ Jesu eci sↄrŋ ikŋ ab ɛm wɛl sↄg ɛy ɛsɛ ɛl af.» ");
INSERT INTO adj_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Sica dedeku a fɛŋ yewal tiŋ, ɛtŋ wɛl am iri Pↄl lele Barnabas ab dad mɛny ɛwr lele low any iti owi ab eke Nyam ɛcr ɛl ɛm kok ↄŋ agŋ a ekʼelm Jwifɛl a. ");
INSERT INTO adj_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Eke Pↄl lele Barnabas ab dad odad a ok es a, Jak ↄdu eb ɛtŋ dad ninɛ: «Agŋ lisijimɛl, ìrir ɛm ecʼodad na! ");
INSERT INTO adj_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simↄ dad elel eke kpↄkpↄ ɛm ɛtŋ Nyam ɛw ɛb ɛb ecʼagŋ ekʼelm Jwifɛl a e low any, ke ɛl ɛm a ot agŋ eb mum nyam el in eci. ");
INSERT INTO adj_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Ɛtŋ low na lele kokoba ↄb ɛsɛl ecʼodad ab ab okr af, aŋke Nyam Lɛl am dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ow e jam a, mʼow mʼɛwl mʼow, ke David ecʼêl a ekʼɛy wus a mʼúsr ɛm, in e êl ekʼuŋ a, mi kókr ɛm, ke mʼínymn in es. ");
INSERT INTO adj_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Ɛtŋ agŋ ɛjecʼa fɛŋ bʼow ↄl Ɛs Kↄtↄkↄ es; ɛɛ, ɛbr ɛbr a fɛŋ eke mʼɛsŋ eke kʼel ɛm ecʼa, bʼow ↄlʼm es. Na el Ɛs Kↄtↄkↄ ecʼodad eke dad; ");
INSERT INTO adj_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","lɛgŋ a ɛtŋ lʼɛlu in ecʼów amua ↄkm li yɛgm.» ");
INSERT INTO adj_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jak igŋ af dad ninɛ: «Na sosiɛm, mʼerurm eke wɛl kʼijr agŋ a ekʼelm Jwifɛl ke oc any ↄkŋ Nyam a gbre. ");
INSERT INTO adj_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Gbɛkↄ sʼáwŋ ɛl lɛl si dad ɛl eke -li kʼijmn ndey eke wɛl oc wawr egb ↄŋ sɛkp, -lʼijmn nfaci, -lʼijmn ndey eke wɛl okm mebl es, -lʼɛgŋmn mebl; ");
INSERT INTO adj_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","aŋke godo godo ɛtŋ, ɛb ɛb fɛŋ ɛm, wɛl am dad Mois eci sol amua ecʼodad ɛtŋ Nyam nuŋ igŋ susu yɛji sɛgŋ fɛŋ nɛnɛgŋ e lɛgŋ wɛl bʼawl.» ");
INSERT INTO adj_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Ow sosiɛm ɛrm ɛsɛl a, agŋ ekpekp a, lele Nyamel a fɛŋ ab ɛgŋ eb eke kʼot ɛl ɛm ecʼagŋ igŋ Pↄl lele Barnabas ab af im Siri ecʼAntiↄs a. -Li sↄsum Jud eke wɛl bʼɛsŋ Barsabas lele Silas ab -lʼot; -lʼel agŋ lisijimɛl ab ɛm ecʼany ɛsɛl yony. ");
INSERT INTO adj_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Kin lɛl eke wɛl ↄŋ ɛl a: «Ɛrm ɛsɛl a lele agŋ ekpekp ab ab, ekʼel ↄny lisijimɛl a, am ↄŋ agŋ lisijimɛl a ekʼelm Jwif kʼir Antiↄs, Siri lele Silisi ab a lebl. ");
INSERT INTO adj_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Sʼiri ekʼagŋ anŋ ɛy ogŋ aŋa ow ↄŋ ↄny ɛwr jeŋjeŋ, ebr ɛrmij ɛl eci sodad ebl ab ɛm. Ow elm ɛy sʼↄↄm ɛl abusu low na e kok eci. ");
INSERT INTO adj_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Na sosiɛm, ɛy a fɛŋ eci nɛny af okr ɛm, si sↄsum agŋ sʼot eke si kʼɛrm ɛl ↄny ogŋ a, -lʼɛwl ɛy lawlɛl Barnabas lele Pↄl ab, ");
INSERT INTO adj_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","eke blel irmn ɛl ecʼowr anŋ a ɛy Ɛs Kↄtↄkↄ Jesu Krist e juma kok ɛm. ");
INSERT INTO adj_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Sʼam ɛrm Jud lele Silas ab ↄny ogŋ a eke ki dad ↄny ɛl obi ɛm, lɛl na eke sʼam nↄn aŋa a e low. ");
INSERT INTO adj_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Tasi ɛm a, ɛy lele Abŋ Lala ab, sʼɛgŋ sʼeb eke si kʼↄↄm ↄny ɛrɛkp ɛjeci ekʼow elm sol amua ekʼit a cɛ: ");
INSERT INTO adj_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","kʼìjr ndey eke wɛl oc wawr egb ↄŋ sɛkp, kʼɛ̀gŋn mebl, kʼìjr ndey eke wɛl okm mebl es, kʼìjmn nfaci. Eke ↄsur ów amua, ow bʼow akpl. Agŋ lisijimɛl, sʼam ɛsŋn ↄny!» ");
INSERT INTO adj_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wɛl ɛlu agŋ a eke wɛl ɛrm ab es, ɛtŋ -nʼim -lʼok Antiↄs. Yogŋ -lʼas agŋ a fɛŋ ekʼↄny ↄmn a luku ɛtŋ -nʼↄŋ wɛl lɛl a. ");
INSERT INTO adj_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wɛl awl lɛl a ɛtŋ agŋ a fɛŋ sos ɛm am iŋn, sos es atr ecʼodad ekʼanŋ ɛm a eci. ");
INSERT INTO adj_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jud lele Silas ab ekʼɛl obi yɛji el kokoba ↄb ɛsɛl a, dad ↄmn ɛsɛl a odad kpekpe sos es atr eci; -nʼↄŋ wɛl ecʼↄmn a ij lɛc obn. ");
INSERT INTO adj_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","-Nʼanŋ yogŋ sɛgŋ bɛb, ɛtŋ ɛrm es ɛy ɛm, ↄmn ɛsɛl a ↄŋ ɛl ejagb -lʼɛwl -nʼim agŋ a ekʼɛrm ɛl a ogŋ.  ");
INSERT INTO adj_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Silas gbɛ ɛgŋ eb eke kʼanŋ yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Gbɛkↄ Pↄl lele Barnabas ab gbɛ anŋ Antiↄs. Agŋ ɛjeci nↄnↄ ab -nʼam yɛgm agŋ low, ɛtŋ -nʼam ↄb Ɛs Kↄtↄkↄ ecʼodad a ecʼamani. ");
INSERT INTO adj_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Eke -nʼanŋn Antiↄs yogŋ toŋ ow ibn a, Pↄl dad Barnabas ninɛ: «Sʼɛ́wl mɛny sʼim ɛb a fɛŋ ɛm eke sʼↄb Ɛs Kↄtↄkↄ ecʼodad a ecʼamani a, sʼɛ́kn agŋ lisijimɛl a ekʼↄny ↄmn a, sʼɛ́kn elel eke -nʼam aan es a.» ");
INSERT INTO adj_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Barnabas erur eke Jan Mark kʼigŋ ɛl ab im, ");
INSERT INTO adj_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","kↄ Pↄl gbɛ erurm aŋke Jan Mark igŋ ɛlu ɛl es Panfili, ɛtŋ ɛmɛny lʼɛwlm wɛl juma ab ɛm ij. ");
INSERT INTO adj_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","-Lʼatar ów es sɛnyn sɛnyn toŋ -lʼɛlulil es. Barnabas oc Mark ɛtŋ eb mijɛtŋ im Sipr; ");
INSERT INTO adj_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pↄl gbɛ oc Silas, ɛtŋ eke ↄmn ɛsɛl a ot ok ɛl Ɛs Kↄtↄkↄ eci nyimn mamn ab ɛm a, nʼim. ");
INSERT INTO adj_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Lʼɛcr Siri lele Silisi wus af ab eci nʼam atr Nyamel a fɛŋ sos es ↄmn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pↄl im ɛy Dɛrb ɛtŋ ɛmɛny im ɛy Lisr. Yogŋ, jam ɛs nyam anŋ eke wɛl bʼɛsŋ Timote; lis a Jwif ekʼin yɛji ↄny ↄmn; ɛs a gbɛ Grɛk. ");
INSERT INTO adj_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Agŋ lisijimɛl a e kʼir Lisr lele Ikoniↄm baŋn ab a, bi dad Timote e lís ecʼów amamn nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pↄl erur eke kʼↄny ɛcmʼn ab; lʼoc ow ab nʼim ɛtŋ lʼubr ow likr es, Jwifɛl a ekʼanŋ yogŋ a eke -li bʼow -lʼɛc a sosiɛm, aŋke agŋ a fɛŋ uw any eke ɛs a Grɛk. ");
INSERT INTO adj_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ɛb a fɛŋ ɛm eke -nʼam ɛc a, -nʼam dad agŋ a ekʼↄny ↄmn a ów a fɛŋ eke ɛrm ɛsɛl a lele Jerusalɛm ecʼagŋ ekpekp ab ab dad ucu es a, ɛtŋ -nʼam ibrm eke wɛl kʼɛlum ów amua. ");
INSERT INTO adj_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sinyamel a am ɛy lɛc ↄmn ɛm, ɛtŋ lɛgŋ liy nyam nyam fɛŋ agŋ am bobn. ");
INSERT INTO adj_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Abŋ Lala ɛ́gbm Pↄl lele Silas ab es eke -li ki dad Nyam ecʼodad a Azi ogog a; ow ↄŋ -lʼubr Friji lele Galasi ab eci wus ab af. ");
INSERT INTO adj_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Eke -li titmn Misi wus af a, -nʼam bɛbm eke -li kʼim Bitini wus af, gbɛkↄ Jesu ecʼAbŋ a yɛbm ɛl. ");
INSERT INTO adj_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Ow sosiɛm -lʼubr Misi ɛtŋ -nʼim Troas baŋn eci nanu a. ");
INSERT INTO adj_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ncok ɛm a, Pↄl ɛrur mɛmn: lʼɛkn Maseduan iy nyam ekʼinym es ke am ŋↄŋnʼn dad ɛsɛ: «Ɛ̀c Maseduan ke ów ɛlum ɛy abu!» ");
INSERT INTO adj_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kpɛkŋ eke mɛmn ɛrur na bʼoc es a, si bɛbm sos sʼus ejagb Maseduan im eci, aŋke sʼub nawrɛ eke Nyam ɛsŋ ɛy eke si kʼɛwl yogŋ ecʼagŋ a Amani Mamn a. ");
INSERT INTO adj_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Sʼeb mijɛtŋ Troas, sʼigb yogŋ kpɛkŋ kpɛkŋ toŋ sʼim sʼok Samotras lekr ɛm, ɛtŋ eke lɛgŋ ɛny a, sʼim sʼok Neapolis baŋn. ");
INSERT INTO adj_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Sʼigb yogŋ sʼim Filip, Maseduan eci wus a eci ɛb gbɛl ekʼanŋ Rom ecʼes ɛw ɛm a. Sʼanŋ ɛb ab ɛm si kok sɛgŋ wa cɛ. ");
INSERT INTO adj_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Nɛnɛgŋ e lɛgŋ a, sʼok ↄkm baŋn a sʼim mij nɛny a; yogŋ si tutr eke si bʼow sʼɛŋn Jwifɛl ekʼanŋ Nyam ŋↄŋn ɛm usu nyam. Sʼok es yogŋ ɛtŋ ↄyↄw a ekʼas luku anŋ yogŋ a, si dad ɛl odad. ");
INSERT INTO adj_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ɔyↄw ab ɛm e nyam e nin el Lidi, Tiatir baŋn yↄwi eke bʼↄl sigbad ebl amamn ij ke bʼigŋ Nyam nuŋ. Nʼam iri ɛy ecʼodad a, ɛtŋ Nyam ↄŋʼn abŋ eke li kʼɛw Pↄl e sodad a ɛrm af. ");
INSERT INTO adj_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ow ↄŋ wɛl okʼr mij nuŋ, in lele in ecʼakŋ ab ab. Lʼɛw ɛy abu li dad ninɛ: «Eke am ɛkan eke mʼub Ɛs Kↄtↄkↄ nawrɛ tasi, ke òwr anŋn ɛm ogŋ a.» Ɛtŋ lʼatrm ɛy sʼɛgŋ sʼeb. ");
INSERT INTO adj_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Lɛgŋ nyam sʼaam Nyam ŋↄŋn ɛm, ɛtŋ adyↄwli nyam am ↄbr ɛy. In ɛm a, abŋ ŋuŋ nyam anŋ eke bʼↄŋʼn lʼɛkn efi e low ekʼam ow a li dad. Ów amua eke li bʼɛkn li dad a bʼↄŋ in ecʼes ɛwɛl a os nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ɛy lele Pↄl ab, nʼam us ɛy jam lʼɛlu lebl li dad lʼɛsɛ: «Agŋ amua, Afr Kpekpe e Nyam a e juma kok ɛsɛl! -Nʼam dad ↄny ejagb a eke bʼɛwl ɛgŋ sel ɛŋn ɛm a ecʼodad!» ");
INSERT INTO adj_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Yↄwli a am kok ɛbɛn sɛgŋ nↄnↄ. Ow bʼafŋn es a, Pↄl ɛrm ebl toŋ batŋ ɛwl mɛny dad abŋ ŋuŋ a ninɛ: «Jesu Krist e nin ɛm, ɛ̀y ↄkm in ɛm!» Ɛtŋ wanci ab af cɛ abŋ a ɛy ↄkm yↄwli ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Eke adyↄwli a ecʼes ɛwɛl a am ɛkn eke -li kʼow -nʼɛŋnmn os ow ɛm ij a, -nʼↄny Pↄl lele Silas ab -lʼow ɛbɛrŋ ɛm es ɛwɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","-Lʼot wɛl -nʼim Rom e jɛj ok ɛsɛl ekʼanŋ yogŋ a ecʼany af, ɛtŋ -li dad ninɛ: «Agŋ amua am is odad ɛy ecʼɛb na ɛm; ");
INSERT INTO adj_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ɛl Jwifɛl, ɛtŋ -nʼam yɛgm agŋ ɛb ir owr. Ɛy Rom eyŋ; ɛy ecʼol a ↄↄm abusu eke si kʼɛgŋ sʼeb oglog si kok ow e low.» ");
INSERT INTO adj_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Dedeku a yɛji ebl ɛrm ok Pↄl lele Silas ab af. Jɛj ok ɛsɛl a ↄŋ wɛl eb Pↄl lele Silas ab mob sos ɛtŋ ↄŋ abusu eke wɛl kʼↄr ɛl likŋni ɛm. ");
INSERT INTO adj_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Ɛtŋ eke wɛl ↄr ɛl sɛnyn sɛnyn bake ow uwr a, wɛl ok ɛl sobel ɛm, ɛtŋ wɛl ↄŋ usu ↄsu ɛs eke kʼɛw ɛl nyamn af sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Eke nʼɛŋn abusu ikŋ na a, lʼot lʼok wɛl sobel ab ɛm ecʼakŋni nyam ekʼanŋ sobel a e nuŋ kↄkↄ a, ɛtŋ nʼawŋm wɛl akr ekŋ ekpr ab. ");
INSERT INTO adj_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ncok eci lɛgŋ uyu nuŋ ɛm a, Pↄl lele Silas ab am ŋↄŋn Nyam ɛgŋ ɛj kↄklmʼn ɛtŋ sobel ɛm ɛsɛl a am iri. ");
INSERT INTO adj_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kpru ɛm, wus umu tuↄtuↄ, ↄny sobel a mumu. Kpɛkŋ masany a fɛŋ fifig ok es ɛtŋ sobel ɛm ɛsɛl a eci ŋgbraka a fɛŋ mↄmu es. ");
INSERT INTO adj_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Usu ↄsu ɛs a ufŋm es, eke li bʼɛkn eke sobel a eci masany a fifig a, lʼↄdu in e lab ler ɛm a lʼɛlu ↄkm eke li kʼibir in sosi, aŋke nʼam tutr eke sobel ɛm ɛsɛl a uru es im. ");
INSERT INTO adj_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Kↄ Pↄl barm in e lɛc fɛŋ ɛm ninɛ: «Kì kokr ŋ sosi low ŋuŋ! Ɛy fɛŋ sʼanŋ aŋa!» ");
INSERT INTO adj_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Usu ↄsu ɛs a ibrm eke wɛl kʼigŋ al; lʼuru es lʼɛy akŋ a, sos ufŋ ɛm, erŋn ab, lʼok ↄwrↄkp wus Pↄl lele Silas ab ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Nʼↄŋ wɛl ok ↄkm ɛtŋ li dad wɛl ninɛ: «Agŋ ɛgbɛl, kↄ ayaf mi ki kokr ke mʼɛ́ŋn sel ee?» ");
INSERT INTO adj_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","-Li dad ow ninɛ: «Ùb Ɛs Kↄtↄkↄ Jesu nawrɛ ke ŋ lele ŋ ecʼakŋ ab ɛ́ŋan sel.» ");
INSERT INTO adj_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Ɛtŋ -nʼam dad ow Ɛs Kↄtↄkↄ ecʼodad, in lele agŋ a fɛŋ ekʼanŋʼn akŋ ab ab. ");
INSERT INTO adj_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ncok a eci wanci ab af cɛ, usu ↄsu ɛs a ot ɛl ab im ɛtŋ yↄyↄg ɛl abi ɛnyɛmbri ab es. Kpɛkŋ in ecʼagŋ ab ab wɛl ok ɛl mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Lʼoc Pↄl lele Silas ab nʼim in ecʼakŋ a ɛtŋ nʼↄŋ wɛl ob ij. Ɛgŋ na lele in ecʼakŋ ab ab sos ɛm am iŋn aŋke -lʼub Nyam nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Eke lɛgŋ ɛny a, Rom e jɛj ok ɛsɛl a ɛrm agŋ ow dad usu ↄsu ɛs a ninɛ: «Ɛ̀lu agŋ a es.» ");
INSERT INTO adj_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Usu ↄsu ɛs a ow dad Pↄl ninɛ: «Jɛj ok ɛsɛl a ↄŋ abusu eke wɛl kʼɛlu ↄny es. Ɔtur eke sica kʼokr ↄkm imn ɛrm es ɛy ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Kↄ Pↄl dad agŋ a ninɛ: «Wɛl jɛjm ɛy e low okm, ɛtŋ -nʼↄŋ wɛl ↄr ɛy dedeku ecʼany af, ke ɛy Rom ecʼagŋ cɛ! Ɛtŋ -nʼↄny -lʼok ɛy sobel ɛm. Sica -nʼam erur eke -li kʼok ɛy ↄkm es lↄl ɛm ee? Sʼɛgŋm! -Lʼow ɛl obi -lʼok ɛy es!» ");
INSERT INTO adj_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Agŋ a im ɛwl jɛj ok ɛsɛl a sodad a eke Pↄl dad a. Eke -lʼirir eke Pↄl lele Silas ab el Rom eyŋ tasi a, ɛrmni ɛdŋ ɛl es. ");
INSERT INTO adj_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","-Lʼow -lʼɛgŋ low ij -nʼↄŋ wɛl, ɛtŋ -nʼↄny -lʼok wɛl ↄkm sobel ab ɛm ɛtŋ -ni ŋↄŋn wɛl eke wɛl kʼok ↄkm baŋn a. ");
INSERT INTO adj_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Eke Pↄl lele Silas ab ok ↄkm sobel ab ɛm a, -nʼim Lidi ogŋ a. Eke -lʼɛkan agŋ lisijimɛl a, ke -lʼatar wɛl sos es a, -nʼim. ");
INSERT INTO adj_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Sica Pↄl lele Silas ab ɛcr Anfipolis baŋn lele Apoloni baŋn ab eci im ok Tesaloni; yogŋ, Jwifɛl eci Nyam nuŋ igŋ usu anŋ. ");
INSERT INTO adj_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Ɛsɛ elel eke sakp sakp fɛŋ li bi kok ab af a, Pↄl im ɛy Nyam nuŋ igŋ usu a. Nɛnɛgŋ kpa kpa kpa sakp nyahan, lʼatar ów es Nyam odad nuŋ af agŋ a ekʼanŋ yogŋ ab ab. ");
INSERT INTO adj_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nʼam ayal lʼok wɛl ɛtŋ nʼam yɛgm wɛl eke Nyam Lɛl ɛm a, ow akpl eke Mesi a kʼij gbre ke ánŋ luw ɛm igb. Nʼam dad wɛl lʼɛsɛ: «Jesu na eke mʼam dad ↄny in ecʼodad a, in anake lʼel Mesi a.» ");
INSERT INTO adj_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Jwifɛl ab ɛm e bɛb odad a ok es sos ɛm ɛtŋ -lʼow -nʼɛŋn Pↄl lele Silas ab. Grɛkɛl nↄnↄ ekʼam igŋ Nyam nuŋ a lele bosu amamn ɛm ecʼↄyↄw nↄnↄ ab yɛji kok ɛbɛn. ");
INSERT INTO adj_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Gbɛkↄ Jwifɛl a nyamnɛyr am ↄny. -Lʼas ów marɛm marɛm ɛsɛl eke -nʼɛŋan ɛbɛrŋ ɛm a luku, -nʼam is odad agŋ ab ɛm, ɛtŋ -nʼam bubr agŋ ɛm baŋn a. Ca -lʼigb -lʼok Jasↄn ecʼakŋ a, -nʼam ↄl Pↄl lele Silas ab eke -li kʼↄny -lʼot -nʼim dedeku a ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Eke -nʼɛŋnm wɛl a, -lʼↄdu Jasↄn lele agŋ lisijimɛl bɛb ab es -lʼow baŋn a ecʼes ɛw ɛsɛl a ecʼany af, ɛtŋ -nʼam ↄg -li dad -lʼɛsɛ: «Agŋ amua inymn wus na nimum es afr; sica ɛy ogŋ a -lʼok a! ");
INSERT INTO adj_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ɛtŋ Jasↄn eb ok ɛl akŋ! Agŋ amua fɛŋ am kok ów ekʼelm Sesar ecʼol a eci, aŋke -nʼam dad eke es ɛw ɛs ɛjeci nyam in anŋ eke wɛʼn bʼɛsŋ Jesu.» ");
INSERT INTO adj_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Sodad amua ↄŋ dedeku a lele ɛb a ecʼes ɛw ɛsɛl ab ab sos inym es afr. ");
INSERT INTO adj_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","-Nʼↄŋ Jasↄn lele agŋ lisijimɛl ab ab ɛw os es gbuŋ ɛtŋ -lʼɛlu wɛl es. ");
INSERT INTO adj_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kpɛkŋ eke lɛgŋ uk a, agŋ lisijimɛl a ↄŋ Pↄl lele Silas ab im Bere. Eke -lʼokr yogŋ a, -nʼim Jwifɛl e Nyam nuŋ igŋ usu a. ");
INSERT INTO adj_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Bere e Jwifɛl a bʼɛgŋ low eb akm Tesaloni ecʼa; -lʼeb Nyam odad a ɛl e sos ɛm iŋn fɛŋ ɛm. Ɛtŋ sɛgŋ fɛŋ -li bi wewr Nyam Lɛl a, yecʼɛtŋ ke -lʼɛkn eke Pↄl ecʼodad eke bi dad ɛl a el nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ɛl ɛm ecʼagŋ nↄnↄ ub nawrɛ; ɛtŋ Grɛkɛl ab ɛm, bosu amamn ɛm ecʼↄyↄw nↄnↄ lele egŋ nↄnↄ ab yɛji ub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Kↄ eke Tesaloni e Jwifɛl a iri eke Pↄl am dad Nyam odad Bere baŋn ɛm yɛjʼa, -lʼow -nʼam ŋuŋn dedeku a mɛrm ɛm -nʼↄŋ wɛl ɛw jeŋ jeŋ. ");
INSERT INTO adj_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ow sosiɛm, kpɛkŋ agŋ lisijimɛl a ↄŋ Pↄl imn okij any a eci; gbɛkↄ Silas lele Timote ab gbɛ anŋ Bere. ");
INSERT INTO adj_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Agŋ a ekʼaam nyimn Pↄl a im ɛwlʼl toŋ ok Atɛn baŋn, ɛtŋ -lʼɛwl -nʼim Bere Silas lele Timote ab ecʼamani a eke Pↄl ↄŋ ab ab. Amani ab ɛm, nʼam ibrm eke wɛl kʼow fafa ɛŋnʼn. ");
INSERT INTO adj_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Eke Pↄl am eku Silas lele Timote ab Atɛn yogŋ a, low am ɛyʼr sos ɛm eke ɛb na kʼel sɛkp eci nuŋ igŋ ↄfr. ");
INSERT INTO adj_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Nyam nuŋ igŋ usu yogŋ, li bʼatar ów es Jwifɛl lele agŋ a ekʼelm Jwifɛl ke am igŋ Nyam nuŋ ab ab, ɛtŋ ɛbɛrŋ ɛm yɛji sɛgŋ fɛŋ li bʼatar ów es agŋ ɛjeci eke li bʼɛŋn ab ab. ");
INSERT INTO adj_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Epikurɛl lele Sitoyikɛl eci low yɛgm ɛsɛl ab ab yɛji am atar ów es Pↄl ab. Ɛl ɛm ecʼagŋ bɛb am ibrm ɛsɛ: «Nɛnym gbɛl ɛs na, bla odad iy nʼam dad gbɛ ee?» Eke agŋ bɛb am iri Pↄl dad Jesu ecʼodad lele luw ɛm anŋ igb owi ab a, -nʼam dad -lʼɛsɛ: «Ɛgŋ na, ɛsɛ etu e sinyam a cɛ ecʼodad owʼn am dad af.» ");
INSERT INTO adj_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ow sosiɛm -lʼoc Pↄl ab -nʼim baŋn a ecʼów bɛbm ɛsɛl a ecʼany af, ɛtŋ -li dad ow ninɛ: «Kↄ sʼↄtu eke si kʼuw low yɛgm owr na eke am dad ow ecʼodad ab any ee? ");
INSERT INTO adj_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Eke am dad ɛy ów eke am iti ɛy any a sosiɛm, sʼam erur eke si kʼuw ow e nyandrɛ ab any.» ");
INSERT INTO adj_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Tasi ɛm a, Atɛn eyŋ a fɛŋ lele etu agŋ a ekʼir ɛl ab a, bʼeb sɛgŋ nↄnↄ am iri oglog am dad ów owr ecʼodad cɛ. ");
INSERT INTO adj_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pↄl inym es ów bɛbm ɛsɛl a ecʼany af ɛtŋ dad ninɛ: «Atɛn eyŋ, mʼam ɛbmn nyamn eke low low fɛŋ ɛm eel Nyam nuŋ igŋ ɛsɛl tasi. ");
INSERT INTO adj_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Tasi ɛm a, eke mʼam ɛc ↄny eci baŋn ɛm a ke mʼam ɛkn ↄny e sinyam nuŋ igŋ e mob a, mʼɛkn egb waw usu nyam eke wɛl nↄn: “Nyàm eke wɛl uwm any eci”. Ɛɛ! Yecʼa eke am igŋn nuŋ ke uwmn any a anake mʼam ow mi dad ↄny in ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Nyam a eke kok wus na nimum lele mob fɛŋ ekʼanŋ ɛm ab a, anake el afr lele wus ab eci Ɛs Kↄtↄkↄ a, ɛtŋ lʼírm Sinyamel ekʼagŋ us ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Lʼibram eke agŋ kʼↄŋʼn ob kaka fɛŋ ɛsɛ owʼn ↄnym ob af; tasi ɛm a, in anake li bʼↄŋ agŋ a fɛŋ owr anŋ, sel lele mob mob fɛŋ ab a. ");
INSERT INTO adj_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Ɛgŋ nyam coco ɛm, li kok ɛbr ɛbr a fɛŋ ɛtŋ lʼok wɛl wus na nimum af. Lʼok akpo nʼↄŋ wɛl, ɛtŋ susu susu a eke -li kʼir a yɛji, lʼɛdŋ ow e sereb a. ");
INSERT INTO adj_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Li kok ɛbɛn yecʼɛtŋ ke agŋ a ↄ́lʼl es. Ɛtŋ eke es ↄl a am ɛw bↄbrm ɛm yɛji, kʼaw ke -lʼↄtu eke -li kʼɛŋn ow, aŋke Nyam anm kpekpe ɛgŋ kaka eci. ");
INSERT INTO adj_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Tasi ɛm a, ↄny e lɛl nↄn ɛsɛl a yɛji dad ninɛ: “In ɛm sʼanŋ owr, sʼↄtu eke si kʼan es sʼɛc, ɛtŋ sʼanŋ.” Ɛtŋ lɛl nↄn ɛs ɛjeci nyam yɛji dad ninɛ: “Sʼel in ecʼey.” ");
INSERT INTO adj_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Eke sʼel in ecʼey a, si kʼↄ́nyn tutr eke Nyam anŋ ɛsɛ sika ɛm nyàm, os ɛm nyàm oglog lebn ɛm nyàm ekʼagŋ ij mɛwl kok ɛl ecʼów tutr ɛm af. ");
INSERT INTO adj_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Agŋ ecʼany uwm ɛm ecʼów eke kok lɛgŋ a ekʼɛc ab ɛm a, Nyam ɛwm ɛrm af ij, kↄ nʼam ibrm susu a fɛŋ ecʼagŋ a eke kʼitŋn ɛl ecʼes an a. ");
INSERT INTO adj_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Lʼoc lɛgŋ nyam lʼɛw es, eke ɛgŋ a eke li sↄsum lʼoc ab ɛm, li bʼow li jɛj wus e low lʼok nɛnyɛmbri nyam ɛm. Lʼɛlu ow e low ↄkm agŋ fɛŋ ecʼany af ɛgŋ na eke lʼigbm luw ɛm ab ɛm!» ");
INSERT INTO adj_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Eke -lʼirir Pↄl dad luw ɛm anŋ igb ecʼodad a, agŋ bɛb am kokrʼr miyɛr, ɛtŋ oglog am dad ɛsɛ: «Lɛgŋ ɛjeci ke sʼíri ŋ ecʼodad na.» ");
INSERT INTO adj_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Af aŋa anake Pↄl ɛlu ɛl es a. ");
INSERT INTO adj_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Kↄ agŋ bɛb gbɛ ɛgŋ in e low a eb ɛtŋ ub nawrɛ. Ɛl ɛm a, Denis ekʼel ów bɛbm ɛsɛl ab ɛm ecʼɛgŋ a, yↄw nyam eke wɛl bʼɛsŋ Damaris a lele agŋ ɛjecʼab anŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Eke ów amua bʼɛc a, Pↄl igb Atɛn im ɛy Korɛnt. ");
INSERT INTO adj_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Yogŋ nʼɛŋn Jwif nyam eke wɛl bʼɛsŋ Akilas; wɛl ewʼr Pↄŋ eci wus ab af. Nʼanŋ Rom, Itali wus af lʼow ɛy Prisil ab ow kʼibnm, aŋke yogŋ Sesar Klod ↄŋ abusu wɛl ogŋ Jwifɛl a fɛŋ. Pↄl im ɛŋn ɛl, ");
INSERT INTO adj_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ɛtŋ eke -nʼↄnyn juma nyam ekʼel ndey lɛl ɛm lɛ́f e kok a, lʼir wɛl ab ɛtŋ -li bʼokr af -li kok juma. ");
INSERT INTO adj_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Nɛnɛgŋ fɛŋ, Pↄl bʼim Nyam nuŋ igŋ usu a, ɛtŋ eke li bʼeb odad a, li bʼↄl eke li kʼeb Grɛkɛl lele Jwifɛl ab. ");
INSERT INTO adj_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Sica eke Silas lele Timote ab anŋ Maseduan ow a, Pↄl bʼoc in e lɛgŋ a fɛŋ am dad Jwifɛl a Nyam odad am ij nɛny dad eke Mesi a Jesu. ");
INSERT INTO adj_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Kↄ Jwifɛl a ɛ́gŋm in e low a ebm ɛtŋ bi wɛwrʼr; ow sosiɛm lʼufŋ in e mob sus ɛm a e siflefl ab es lʼok wɛl es, ɛtŋ li dad wɛl ninɛ: «Eke batŋ irmn, ke ↄny obi ɛm ana; ow elm ɛm e low ij. Sicaca ɛm a, mʼow mʼoc any mʼↄkŋ agŋ ekʼelm Jwifɛl a.» ");
INSERT INTO adj_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Pↄl igb yogŋ im ir Titius Justus ogŋ, ekʼin ecʼêl a titm Nyam nuŋ igŋ usu a. Lʼelm Jwif kↄ lʼel ɛgŋ nyam eke ɛgŋ ɛl eci Nyam nuŋ igŋ owi a eb. ");
INSERT INTO adj_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispus ekʼel Nyam nuŋ igŋ usu a ecʼes ɛw a, lele in ecʼakŋ ab ab ub Ɛs Kↄtↄkↄ nawrɛ. Korɛnt baŋn eyŋ nↄnↄ ekʼiri Pↄl ecʼodad a yɛji ub nawrɛ ɛtŋ ok mij nuŋ. ");
INSERT INTO adj_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Sica ncok nyam, Pↄl am ɛrur mɛmn ɛtŋ Ɛs Kↄtↄkↄ am dadʼr ɛsɛ: «Kʼùru erŋn! Nɛny ánŋʼŋ ɛm am dad! Kʼàbl nɛny, ");
INSERT INTO adj_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","aŋke mʼanŋ ŋ ab. Ɛgŋ kaka kʼↄtum kokmʼŋ low ŋuŋ aŋke ɛb na ɛm, agŋ nↄnↄ el ɛm eci.» ");
INSERT INTO adj_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Pↄl anŋ Korɛnt kok lakpo nyam awl nↄhↄn ɛtŋ am yɛgm agŋ Nyam odad. ");
INSERT INTO adj_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lakpo ab af eke Galiↄn eb Rom ecʼes ɛw Akayi ogog ecʼa, Jwifɛl okr af irŋn Pↄl. -Lʼoc ow -nʼim jɛj ok ecʼany af ");
INSERT INTO adj_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ɛtŋ -li dad ninɛ: «Ɛgŋ na am ↄl eke kʼeb agŋ igŋ Nyam nuŋ ekʼotm ol a ecʼab es.» ");
INSERT INTO adj_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Eke Pↄl ↄl eke ki dad odad a, Galiↄn dad Jwifɛl a ninɛ: «Ɔny Jwifɛl, tasi ɛm a, blel ow el low ŋuŋ li kok, oglog low ligbɛl marɛm anake li kok a, ke blel mʼók sos es mʼiri ↄny ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Kↄ ekʼow el ów es atar odad ebl owi af, en owi af lele ↄny obi e sol owi af ab a, na ↄny obi e low eke kʼɛkan ana. Sodad nɛnɛ a, mʼérurm eke mi kʼel ow e jɛj ok ɛs!» ");
INSERT INTO adj_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ɛtŋ lʼogŋ wɛl jɛj ok usu a. ");
INSERT INTO adj_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Ɛl fɛŋ -nʼↄny Sↄstɛn ekʼel Nyam nuŋ igŋ usu a ecʼes ɛw ɛs a, ɛtŋ -nʼam ↄr ow jɛj ok ɛsɛl a ecʼany af; gbɛkↄ Galiↄn cicm sar okm ɛl es. ");
INSERT INTO adj_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pↄl anŋ Korɛnt ibn. Sica lʼɛlu agŋ lisijimɛl a es, ɛtŋ lʼeb mijɛtŋ lʼot Prisil lele Akilas ab nʼim Siri. Gbuŋ ke -lʼeb mijɛtŋ a, Saŋkre ɛb ɛm yogŋ, Pↄl ↄŋ wɛl ɛrʼr sin aŋke lʼij nɛny. ");
INSERT INTO adj_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","-Nʼim -lʼok Efɛs ɛtŋ Pↄl ɛlu ɛl es yogŋ. Nʼim lʼɛy Nyam nuŋ igŋ usu a ɛtŋ Jwifɛl ab ab -nʼam atar ów es. ");
INSERT INTO adj_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","-Lʼibrm ow ekʼow kʼanŋ ɛl ab ibn, kↄ lʼɛgŋm. ");
INSERT INTO adj_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Ke lʼɛ́lu wɛl es a, li dad wɛl ninɛ: «Eke Nyam ɛgŋ, lɛgŋ ɛjeci mʼow mʼɛwl mɛny mʼow ↄny ogŋ aŋa.» Ɛtŋ lʼigb Efɛs nʼimn mijɛtŋ ɛm eci. ");
INSERT INTO adj_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Eke lʼitr es Sesare a, lʼuyu nʼim Jerusalɛm lʼɛsŋn Nyamel ecʼagŋ a, gbuŋ ɛtŋ nʼim Antiↄs. ");
INSERT INTO adj_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Li kok sɛgŋ bɛb yogŋ ɛtŋ nʼim. In ecʼim ɛm a, lʼɛcr Galasi lele Friji e wus ab af eci ɛtŋ nʼam atr jam ɛsɛl a sos es. ");
INSERT INTO adj_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Jwif nyam eke wɛl bʼɛsŋ Apolↄs ke wɛl ew Alesandri a, ow ɛy Efɛs. Lʼel odad ebl mamn ɛs eke uw Nyam Lɛl any sɛnyn sɛnyn yɛji. ");
INSERT INTO adj_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Wɛl yɛgmʼn Ɛs Kↄtↄkↄ Jesu ecʼejagb a e low, ɛtŋ ari at ɛm, nʼam ↄb kokoba li yɛgm agŋ Jesu e lís e low fɛŋ cɛcɛ ɛm; gbɛkↄ Jan eci mij ok nuŋ a cɛ e low lʼuw any. ");
INSERT INTO adj_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Nʼam dad ów ↄmn ɛm tasi Nyam nuŋ igŋ usu yogŋ. Eke Prisil lele Akilas ab iriʼr lebl a, -lʼoc ow ɛtŋ -lʼotar Ɛs Kↄtↄkↄ Jesu ecʼejagb a e low akr tasi -lʼok ow. ");
INSERT INTO adj_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Sica eke Apolↄs am erur eke kʼim Akayi wus af a, agŋ lisijimɛl a atrʼr sos es, ɛtŋ -li kok lɛl -nʼawŋ ɛb ab ɛm eci jam ɛsɛl a yecʼɛtŋ ke wɛl ébʼr sɛnyn sɛnyn. Eke nʼim lʼɛy yogŋ a, agŋ a eke Nyam e bibm ɛm ↄny ↄmn a, lʼɛlum wɛl abu nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Tasi ɛm a, dedeku fɛŋ ecʼany af nʼam ot ów tasi li yɛgm eke Jwifɛl a ↄnym low ij: Nyam Lɛl ɛm, nʼam ɛlu ↄkm eke Mesi a Jesu. ");
INSERT INTO adj_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","EkʼApolↄs anŋ Korɛnt a, Pↄl ebr mafɛny ɛm eci im ɛy Efɛs. Nʼɛŋn jam ɛsɛl bɛb yogŋ ");
INSERT INTO adj_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ɛtŋ lʼibrm wɛl ninɛ: «Kↄ eke ubr nawrɛ a, ɛŋan Abŋ Lala ee?» -Li dad ow ninɛ: «EkʼAbŋ Lala nyam anŋ yɛji, sʼirim; wɛl dadm ɛy ow e low.» ");
INSERT INTO adj_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Ow ↄŋ Pↄl ibrm ɛl ninɛ: «Ke sica bogŋ e mij ok nuŋ ɛŋan ee?» -Li dad ow ninɛ: «Jan eci mij ok nuŋ a eke yɛgm agŋ a.» ");
INSERT INTO adj_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pↄl dad ɛl ninɛ: «Lɛgŋ ab ɛm a, Jan am ok agŋ a ekʼɛgŋ eb eke kʼitŋn ɛrm a mij nuŋ ɛtŋ nʼam dad Israɛl ecʼagŋ a eke kʼub ɛgŋ a eke bʼow anŋʼn jam ow a nawrɛ, ɛgŋ a el Jesu.» ");
INSERT INTO adj_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Eke -lʼirir ów amua a, -nʼↄŋ wɛl ok ɛl mij nuŋ Ɛs Kↄtↄkↄ Jesu e nin ɛm. ");
INSERT INTO adj_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pↄl at ɛl abu nuŋ ɛtŋ -nʼɛŋn Abŋ Lala. -Nʼam ɛbr sɛbr eke wɛl uwm any ɛtŋ -nʼam iri Nyam ogŋ ecʼodad -li dad. ");
INSERT INTO adj_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Agŋ a fɛŋ ↄtu ekʼij agŋ lɛw yony. ");
INSERT INTO adj_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pↄl bʼim Nyam nuŋ igŋ usu a, ɛtŋ yogŋ awl emum nyahan, li bi dad ów ↄmn ɛm tasi. Nʼam dad Nyam e gbreŋgbi usu a ecʼodad ɛtŋ nʼam ↄl elel eke li kʼeb agŋ a ekʼam iri in ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Gbɛkↄ agŋ nↄnↄ am ↄny lↄru aru, ɛ́gŋm ekʼub nawrɛ ɛtŋ dedeku a ecʼany af, am cak Ɛs Kↄtↄkↄ Jesu ecʼejagb a e low. Ow sosiɛm Pↄl ɛlu ɛl es, ot jam ɛsɛl ab ab im, ɛtŋ sɛgŋ fɛŋ am dad Nyam odad Tiranus e lɛl êl ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Low na ibn toŋ ij akpo yony; ow ↄŋ agŋ a ekʼir Azi ogog a, Jwifɛl lele agŋ ekʼelm Jwifɛl ab ab iri Ɛs Kↄtↄkↄ ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","12","Pↄl ɛm, Nyam am kok sakrowa ɛgbɛl toŋ batŋ agŋ bʼot sigbad, oglog nuŋ es awŋ eke Pↄl ɛw sos a ís ↄ́lu a: ↄl a bʼoc ɛl es lís ɛtŋ abŋ eŋuŋ a bʼok ↄkm ɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Jwifɛl bɛb eke bʼɛc susu susu ogŋ abŋ eŋuŋ eke bʼanŋ ↄ́lu ɛm a, ɛl yɛji am ɛbm oc Ɛs Kↄtↄkↄ Jesu e nin a ogŋn abŋ eŋuŋ ok ↄkm. -Li bi dad abŋ eŋuŋ a -lʼɛsɛ: «Jesu a eke Pↄl am dad in e low a e nin ɛm, mʼam dad ↄny eke kʼokr ↄkm!» ");
INSERT INTO adj_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ɛbɛn eke egb waw ɛs ligbɛl nyam, Jwif eke wɛl bʼɛsŋ Seva a, ecʼey lↄbŋ a yɛji bi kok ana. ");
INSERT INTO adj_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Kↄ lɛgŋ nyam, abŋ ŋuŋ nyam dad ɛl ninɛ: «Mʼuw Jesu any ɛtŋ mʼuw ɛgŋ ekʼel Pↄl ab any, ɛtŋ kↄ ↄny, bwo el ↄny ee?» ");
INSERT INTO adj_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ɛtŋ ɛgŋ a eke abŋ ŋuŋ ir ɛm a ɛy ɛl af, ɛtŋ lʼɛy lɛc lʼakm wɛl fɛŋ; lʼↄr wɛl lɛc ɛm toŋ batŋ mob kok kok ɛl; -lʼuru es -lʼok ↄkm akŋ a -nʼim sos ↄfr. ");
INSERT INTO adj_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Efɛs ecʼagŋ a, Jwifɛl lel agŋ ekʼelm Jwifɛl ab ab, iri low na; ɛl fɛŋ erŋn am ↄny ɛl ɛtŋ agŋ am ↄny Ɛs Kↄtↄkↄ Jesu e nin a ecʼɛlum ligbɛl. ");
INSERT INTO adj_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Agŋ nↄnↄ a eke ub nawrɛ a ow dedeku a fɛŋ ecʼany af ɛgŋ ów eŋuŋ a eke -li kokr a e low eb. ");
INSERT INTO adj_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Agŋ nↄnↄ a eke kok cam owi a ot ɛl e silɛl a ow, ɛtŋ dedeku a fɛŋ ecʼany af -lʼofŋ. Wɛl ub silɛl a ecʼos abi ekʼↄtu eke kʼij a, ɛtŋ ɛl ecʼos ab ɛm, ow ij jɛtɛ efu fandi ekŋ yony lele lɛw ab. ");
INSERT INTO adj_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Elel eke Ɛs Kↄtↄkↄ ecʼabusu ɛm, Nyam ecʼodad a am eb es ke am ɛlu in e lɛc a ↄkm ana. ");
INSERT INTO adj_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Eke ów amua ɛc ok es a, Abŋ Lala nyimn Pↄl eke kʼɛcr Maseduan lele Akayi ab eci, ke im Jerusalɛm. Nʼam dad eke ekʼin im yogŋ, owʼn it ke in ím Rom yɛji. ");
INSERT INTO adj_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ow sosiɛm nʼↄŋ in ecʼabu ɛlum ɛsɛl yony, Timote lele Eras ab ikŋ anym im Maseduan, kↄ in obi a gbɛ ɛmɛny nʼanŋ Azi sɛgŋ bɛb. ");
INSERT INTO adj_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Lɛgŋ na af, ɛrm bebl ligbɛl ɛy Ɛs Kↄtↄkↄ Jesu ecʼejagb a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Sika iny ɛs nyam eke wɛl bʼɛsŋ Demetrius bʼoc jɛtɛ ufu kokr nyàm yↄw Artemis eci nyamel ekekey, ɛtŋ ow bʼↄŋ juma kok ɛsɛl a bʼɛŋn os nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Lʼas in e juma kok ɛsɛl a lele agŋ ɛjecʼa eke ɛl e juma a ot in ecʼa es a luku ɛtŋ li dad wɛl ninɛ: «Agŋ o, uwr any eke ow el juma na anake bʼↄŋ ɛy sʼir ɛb sɛnyn sɛnyn a. ");
INSERT INTO adj_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Am ɛkan ɛtŋ am irir low eke Pↄl ikŋ na am kok a: tasi ɛm a, nʼam dad eke sinyam a eke agŋ in kok a, in elm nyàm, ɛtŋ lʼeb agŋ nↄnↄ, ow elm Efɛs aŋa sↄny cɛ, kↄ Azi wus nimum af yɛji. ");
INSERT INTO adj_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Low na ↄtu eke ki ŋuŋn ɛy e juma a, ke ɛmɛny ow ↄ́ŋ nyàm yↄw Artemis e nyamel gbɛl a irmn in ecʼany a; nyàm yↄw na eke Azi lele wus na nimum ecʼagŋ a fɛŋ ab bʼigŋ nuŋ a e sagb a bʼow oc es!» ");
INSERT INTO adj_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Eke -lʼirir sodad amua a, agŋ a ɛrm ebl afŋn es ɛtŋ am ↄg dad ɛsɛ: «Efɛs eci Artemis a el ligbɛl!» ");
INSERT INTO adj_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Ɛrm bebl a eb es ɛb a fɛŋ ɛm. Agŋ a ↄny Gayus lele Aritak ab, Maseduan wus af eyŋ yony eke bʼɛwl Pↄl usu, ɛtŋ dedeku ɛm -lʼub -lʼok dedeku a e luku as usu a. ");
INSERT INTO adj_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pↄl am erur eke kʼokm sos ↄkm dedeku a ecʼany af, kↄ jam ɛsɛl a ɛdŋn in. ");
INSERT INTO adj_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Azi wus ab af eci idr ɛsɛl bɛb a ekʼel lawlɛl a, ↄŋʼn bↄwl ŋↄŋnʼn eke li kʼiim dedeku a e luku as usu a. ");
INSERT INTO adj_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Wanci ab af a, luku as a wuwal: agŋ bɛb bʼↄny na ke dad, amua bʼↄny na ke dad, ɛtŋ nↄnↄ gbɛl ecʼa, -lʼuwm low a sosiɛm eke -nʼanŋn luku as ab ɛm ab any. ");
INSERT INTO adj_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Jwifɛl a akŋ ów a ok Alesandr nɛnym ɛtŋ -lʼikŋm ow anym eke li ki dad. Alesandr igbl abu ogŋ: lʼerur eke dedeku a ecʼany af li kʼeb odad li dad lʼotar akr. ");
INSERT INTO adj_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Gbɛkↄ sica eke ow ok ɛl es sos ɛm eke ow el Jwif a, ɛl fɛŋ -lʼↄg lebl nyam toŋ ow kok wanci ↄmu yony: «Efɛs eci Artemis a el ligbɛl!» ");
INSERT INTO adj_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Sↄg a anŋ ɛm toŋ ɛtŋ sica ɛb a eci es ɛw ɛs a ↄtu ɛdŋn dedeku a ɛtŋ dad ninɛ: «Efɛs ecʼagŋ, yewalil ↄ! Agŋ a fɛŋ uw any eke Efɛs ecʼɛb a bʼↄsu Artemis gbɛl a e nuŋ igŋ usu a lele in e lebn ɛm nyàm ekʼanŋ afr ɛy wus ab ab. ");
INSERT INTO adj_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Ow itim ɛgŋ kaka any. Ow sosiɛm ↄtur eke ki yewalil tiŋ, kì kokr nyamb owi. ");
INSERT INTO adj_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Kin, otr agŋ amua owr aŋa, -lʼiym nyamel gbɛl a e mil ɛtŋ -li wɛwrm ɛy e nyàm yↄw a yɛji. ");
INSERT INTO adj_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Eke Demetrius lele in e juma kok ɛsɛl ab ab ↄny low ɛgŋ ab a, ow ↄny sɛgŋ eke wɛl bi jɛj ów ok ɛtŋ es ɛw ɛsɛl yɛji anŋ: yogŋ anake -li kʼim -li jɛj -lʼok a. ");
INSERT INTO adj_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ɛtŋ ɛmɛny eke ↄnyn low eke kʼibrmn a, wɛl bʼow dad ow ecʼodad luku as gbɛl a eke bʼan es ol af a ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Tasi ɛm a, yɛfɛnyna e low na ekʼɛy a, af yogŋ a, wɛl ↄtu eke kʼot ɛy ɛsɛ agŋ low ɛgŋm ebm ɛsɛl af, aŋke low kaka anm ekʼam ayal ɛy ecʼɛŋanin na, ɛtŋ si kʼow sʼↄnym odad ebl ekʼow af si kʼotar ɛŋanin na e low akr sɛnyn sɛnyn.» ");
INSERT INTO adj_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Eke li dad ów amua uwr a, lʼigbl luku as a ecʼagŋ a sos ogŋ. ");
INSERT INTO adj_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Eke ów wuwal a fɛŋ ok sel a, Pↄl as jam ɛsɛl a luku ɛtŋ am atr ɛl sos es. Ow bʼuwr a, lʼɛlu wɛl es nʼim Maseduan. ");
INSERT INTO adj_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Lʼɛcr wus ab af eci, lʼatr ↄmn ɛsɛl a sos es, sodad nↄnↄ a eke li dad wɛl ab ɛm. Ɛtŋ nʼim Grɛs, ");
INSERT INTO adj_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","nʼanŋ yogŋ lʼij awl nyahan. Sica eke nʼam bɛbm sos eke li kʼeb mijɛtŋ nʼim Siri a, lʼiri eke Jwifɛl a am ut in ecʼasre. Ow sosiɛm lʼɛwl mɛny lʼebr Maseduan eci. ");
INSERT INTO adj_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Agŋ a ekʼim am ɛwlʼl a el: Sopatɛr Pirus jim, Bere iy, Aritak lele Sekundus ab ekʼel Tesaloni eyŋ, Gayus, Dɛrb iy, Timote, Tisik lele Trofim ab, Azi wus af ecʼagŋ. ");
INSERT INTO adj_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Agŋ amua ikŋ anym im Troas am eku ɛy. ");
INSERT INTO adj_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ɛy gbɛ, eke Futufutu eke ejru anm ɛm ecʼes gbɛgbl a uwr a, sʼeb mijɛtŋ Filip ɛb ɛm Maseduan wus af; ɛtŋ eke sɛgŋ yen ɛc a, sʼim sʼɛŋn ɛl Troas, sʼanŋ yogŋ si kok sɛgŋ lↄbŋ. ");
INSERT INTO adj_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ma ɛy ncebles a, sʼɛŋanin eke si kʼubr futufutu ɛm, ɛtŋ Pↄl am dad dedeku a odad. Eke lɛgŋ bʼow ɛny ke li bʼow nʼim a sosiɛm, li dad odad toŋ lɛgŋ usu ubr ɛm. ");
INSERT INTO adj_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Oj ab ɛm a eke sʼas luku êl afr yogŋ a, kɛniɛ nↄnↄ anŋ. ");
INSERT INTO adj_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Ŋgbafrɛ nyam eke wɛl bʼɛsŋ Etikus sig es finɛtr nɛny af a. Pↄl ecʼodad a ekʼam ↄfu nɛnym a, ↄŋ mɛmn ɛwlʼl. Mɛmn a afŋn in es toŋ nʼanŋ êl afr nyahan ɛm a lʼɛy wus. Wɛl ↄny igblʼl ogŋ, kↄ lʼuw. ");
INSERT INTO adj_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Pↄl us es, im ubuʼr af, ocʼr ɛtŋ dad agŋ a ninɛ: «Ɛrmij kʼók ↄny: nʼanŋ owr!» ");
INSERT INTO adj_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Ɛmɛny Pↄl ɛwl uyu êl afr a, lʼubr futufutu ab ɛm li cɛc, ɛtŋ in yɛji lʼij. Ɛmɛny li dad odad ibn kpekpe toŋ ligbn ɛjn ɛy ↄkm ɛtŋ nʼim. ");
INSERT INTO adj_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Iy a gbɛ anŋ owr, wɛl ocʼr im ɛtŋ ow el agŋ a fɛŋ ecʼɛrm es ɛy. ");
INSERT INTO adj_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Sʼikŋ anym sʼim eke si kʼeb mijɛtŋ ot im ɛy Asos; yogŋ anake si kʼoc Pↄl a, aŋke tasi ɛm a, li dad eke li kʼɛcr wus wus eci. ");
INSERT INTO adj_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Eke lʼow nʼɛŋn ɛy Asos a, sʼocʼr mijɛtŋ ab ɛm ɛtŋ sʼim Mitilɛn. ");
INSERT INTO adj_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Sʼigb yogŋ sʼim ɛtŋ lɛgŋ bʼɛny a, sʼow sʼok lekr a eke wɛl bʼɛsŋ Kio a ecʼany af. Lɛgŋ bʼɛny a, sʼow sʼok Samↄs, ɛtŋ ɛmɛny lɛgŋ bʼɛny akr af a, sʼow sʼok Mile. ");
INSERT INTO adj_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Tasi ɛm a, Pↄl ɛgŋ eb eke kʼinyam es Efɛs irmnm lɛgŋ Azi wus af. Nʼam ogŋ es yecʼɛtŋ ekʼow it ke nʼánŋ Jerusalɛm Pantekↄt e lɛgŋ a. ");
INSERT INTO adj_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Pↄl anŋ Mile awŋ bↄwl Efɛs eke Nyamel ecʼagŋ ekpekp a kʼow. ");
INSERT INTO adj_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Eke -lʼowr -nʼɛŋan ow a, li dad wɛl ninɛ: «Sɛgŋ a fɛŋ eke mʼanŋ ↄny ab a, uwr elel eke mʼaan es ab any, lɛgŋ krɛkrɛ a ɛtŋ eke mʼow Azi wus na af a. ");
INSERT INTO adj_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Es is ɛm, mi kok Ɛs Kↄtↄkↄ e juma ↄŋn ikŋ ɛm, Jwifɛl eci asre eke bʼut ɛm e gbre ijr ecʼa sosiɛm. ");
INSERT INTO adj_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Uwr any ɛkan eke low fɛŋ ekʼↄtu eke kʼakpl ↄny ecʼa, mʼocm mi lↄlm es. Dedeku fɛŋ ecʼany af, ↄny ecʼakŋ akŋ, mi dad ↄny ɛtŋ mi yɛgm ↄny yɛji. ");
INSERT INTO adj_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mʼɛsŋ Jwifɛl lele agŋ ekʼelm Jwifɛl ab ab eke kʼitŋn ɛrm ɛm, oc any ↄkŋ Nyam ke ↄ́ny ↄmn ɛy Ɛs Kↄtↄkↄ Jesu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Sica mʼaam Jerusalɛm ɛsɛ elel eke Abŋ Lala am atʼm eke mi ki kok ab af. Low yecʼa eke bʼow ɛŋnʼm yogŋ a, mʼuwm any. ");
INSERT INTO adj_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Low a cɛ eke mʼuw any a el: ɛb fɛŋ ɛm eke mi bʼɛc a, Abŋ Lala bʼɛwarʼm ɛm e gbre ij nↄnↄ lele sobel ɛm eke mʼow mʼɛy ab ab a e low. ");
INSERT INTO adj_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Gbɛkↄ mʼam ɛkn eke ɛm ecʼa, ɛm ecʼowr anŋ a ↄnym any; low a cɛ ekʼↄny any a el ke mʼím toŋ mʼigŋ ɛm eci es uru a e nuŋ, ke mi kók juma a eke Ɛs Kↄtↄkↄ Jesu abulʼm a, toŋ ke mʼúwar; juma a el ke mʼↄ́b Amani Mamn a ekʼel Nyam eci sↄrŋ ikŋ a e kokoba. ");
INSERT INTO adj_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","Mʼɛc ↄny fɛŋ ecʼaraŋn mi dad Nyam e gbreŋgbi usu a ecʼodad; gbɛkↄ sicaca ɛm a, mʼuw any ekʼↄny ɛm ecʼɛgŋ kaka kʼow ɛknm im ij. ");
INSERT INTO adj_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Na sosiɛm anake yɛfɛnyna mʼam igbl lebl ogŋ mi dad mʼɛsɛ: ekʼↄny ɛm ecʼɛgŋ nyam am irm, ke ow elm ɛm e low ij, ");
INSERT INTO adj_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","aŋke mi dad ↄny Nyam e low a fɛŋ eke bɛbm ɛw es a; mʼocm kaka mi lↄlm es. ");
INSERT INTO adj_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ɔ̀surir ↄny obi lele Abŋ Lala eci mɛbob a ekʼↄŋ ↄny eke kʼↄsur ab ab. Ɛsɛ elel eke mɛcɛb ↄsu ɛs bʼɛw in e mɛcɛb a nyamn af ab af a, ɛ̀wr Nyamel a eke Nyam ↄl jim lokm e mebl ab ɛm a e low ɛrm. ");
INSERT INTO adj_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mʼuw any tasi eke ɛm eci im ɛm a, agŋ ekʼanŋ ɛsɛ mindey eŋuŋ af bʼow ok ↄny ecʼaraŋn ɛtŋ kʼow yɛbm mɛbob a kaka. ");
INSERT INTO adj_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ɛtŋ ↄny ɛm a yɛji, agŋ bʼow ok ↄkm am ↄny yadŋ, yecʼɛtŋ ke ↄmn ɛsɛl a ús ɛl jam. ");
INSERT INTO adj_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Ɔ̀sur sos! Ke ↄ́kan ekʼakpo emum nyahan, ncok lele lɛgŋ owr ab, ↄŋn ikŋ ɛm, mʼↄpim ↄny ɛm ecʼɛgŋ nyam nyam ecʼów ↄm. ");
INSERT INTO adj_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","Sica mʼam oc mʼɛlul ↄny Nyam lele in eci sↄrŋ ikŋ eci odad ab ab abu ɛm. Nʼↄny abusu eke li kʼagbr ↄny ↄmn ɛm ke nʼↄ́ŋ ↄny aja a fɛŋ eke lʼoc lʼɛw es agŋ a ekʼel in ecʼa ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mʼocm nyamn mʼɛwm ɛgŋ kaka fɛŋ ecʼos, sika, lele simob sus ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ɔny obi yɛji uwr any eke ow el ɛm e sabu ab ɛm mi kok juma mʼɛŋn yecʼekʼit a agŋ a ekʼam ɛwlʼm a, lele ɛm obi ab ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Sɛgŋ a fɛŋ mi yɛgm ↄny eke ki kokr juma ɛbɛn ke ɛ́lumn ↄgbↄru abu. Ɔ̀kan Ɛs Kↄtↄkↄ Jesu eci sodad amua eke dad a: “Eke wɛl bʼↄŋ ɛgŋ ob a, wɛl bʼɛŋn sos ɛm iŋn nↄnↄ akm yecʼeke wɛl bʼɛŋn ɛgŋ ɛm a.” » ");
INSERT INTO adj_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Eke odad a uwr a, Pↄl ok ↄwrↄkp wus ɛl fɛŋ ab ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Agŋ a fɛŋ am ikŋ ↄŋn ɛtŋ am ɛy Pↄl af es ɛlulil eci. ");
INSERT INTO adj_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sos ↄw ɛl es nↄnↄ aŋke Pↄl dad ɛl eke wɛʼn kʼow in ɛknmʼn ij. Ɛtŋ -lʼɛwl ow toŋ -lʼok mijɛtŋ a e lís. ");
INSERT INTO adj_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Eke sica sʼɛlu ɛl es a, sʼimn mijɛtŋ ɛm eci, kpɛkŋ kpɛkŋ toŋ sʼok Kↄs lekr ɛm; lɛgŋ bʼɛny a, sʼim sʼok Rod lekr ɛm, ɛtŋ sʼigb yogŋ sʼim sʼok Patara baŋn. ");
INSERT INTO adj_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Yogŋ, sʼɛŋn mijɛtŋ nyam ekʼam ow im Fenisi ɛtŋ sʼok ɛm sʼim. ");
INSERT INTO adj_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Sʼɛkn Sipr lekr a kpekpe ɛm, sʼɛcr ow ecʼesr ɛm a, ɛtŋ sʼimn Siri eci. Sʼitr es Tir eci nanu gbɛl a, yogŋ a eke mijɛtŋ a kʼusm in ecʼɛrɛkp ab es a. ");
INSERT INTO adj_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Yogŋ sʼɛŋn jam ɛsɛl ɛtŋ sʼanŋ ɛl ab ow ij nɛnɛgŋ mum nyam. Eke Abŋ Lala ɛwar ɛl a, -li dad Pↄl eke kʼúyum iim Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Gbɛkↄ eke nɛnɛgŋ gber mum a oc es a, sʼɛwl sʼebr ɛy ecʼusu im ab ɛm. Ɛl fɛŋ -lʼow -lʼɛwl ɛy, ɛl ecʼↄyↄw lele ɛl ecʼey ab toŋ sʼok ↄkm baŋn a. Okij nɛny yogŋ, sʼok ↄwrↄkp wus si ŋↄŋn Nyam. ");
INSERT INTO adj_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Eke sica sʼɛlulil es a, sʼok mijɛtŋ ab ɛm ɛtŋ ɛl gbɛ -lʼɛwl -nʼim gbugŋ gbugŋ. ");
INSERT INTO adj_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Sica eke sʼigb Tir a, sʼim sʼok Pitolemais, ɛtŋ sʼuwar ɛy ecʼusu im mij af ecʼa. Yogŋ sʼɛkanin ɛb ab ɛm ecʼagŋ lisijimɛl ab ab, ɛtŋ sʼanŋ ɛl ab lɛgŋ nyam cɛ. ");
INSERT INTO adj_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Lɛgŋ bʼɛny a, sʼim sʼok Sesare. Yogŋ, sʼok Amani Mamn a ecʼes ↄmun ɛs Filip ecʼakŋ a ɛtŋ sʼanŋ in ogŋ a. Lʼel agŋ lↄbŋ a eke wɛl sↄsum ot Jerusalɛm a e nyam. ");
INSERT INTO adj_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nʼↄny ey ↄyↄw yar eke ɛbim egŋ, ke bʼↄb kokoba dad odad eke Nyam bʼↄŋ ɛl a. ");
INSERT INTO adj_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Sʼanŋ yogŋ ow kok sɛgŋ nↄnↄ toŋ ɛtŋ kokoba ↄb ɛs nyam eke wɛl bʼɛsŋ Agabus anŋ Jude ow. ");
INSERT INTO adj_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Lʼow ɛy ogŋ a, lʼoc Pↄl eci meb er ɛm a, nʼawŋ in ecʼakr a lele sabu ab ab, ɛtŋ li dad ninɛ: «Kin Abŋ Lala ecʼodad eke am dad: ɛgŋ a eke meb er ɛm na el in ecʼa, Jerusalɛm yogŋ, Jwifɛl bʼow awŋʼn ɛbɛn, ke -lʼoc -lʼɛlu ow agŋ ekʼelm Jwifɛl a abu ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Eke sʼiri ów amua a, ɛy obi ɛy obi lele Sesare ecʼɛy lisijimɛl ab ab, si ŋↄŋn Pↄl eke kʼúyum iim Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Gbɛkↄ li dad ninɛ: «Kↄ bla sosiɛm ɛtŋ am ikŋn ↄŋn ↄwarʼm sos es ee? Ɛm, mi bɛbm sos, ow elm ɛm ecʼawŋ a cɛ eci, kↄ ke mʼúw Jerusalɛm Ɛs Kↄtↄkↄ Jesu sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Eke sʼↄtum sʼebmʼn odad ebl ɛm a, sʼatramʼn ij ɛtŋ si dad sʼɛsɛ: «Ke ow él yecʼa ekʼƐs Kↄtↄkↄ am erur a!» ");
INSERT INTO adj_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Eke sica sʼanŋ yogŋ si kok sɛgŋ bɛb a, si bɛbm sos sʼam uyu sʼimn Jerusalɛm eci. ");
INSERT INTO adj_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Sesare eci jam ɛsɛl a ow ɛwl ɛy Jerusalɛm; -lʼoc ɛy -nʼim ɛgŋ nyam eke kʼeb ok ɛy akŋ a ogŋ; wɛl bʼɛsŋʼn Minasↄn, Sipr lekr ɛm ecʼɛgŋ ekʼel jam ɛs lɛgŋ kpekpe, ke ir Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Yogŋ eke sʼok a, ɛy lisijimɛl a eb ɛy sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Eke lɛgŋ ɛny a, Pↄl ot ɛy ab im Jak ogŋ a; yogŋ, Nyamel ecʼagŋ ekpekp a fɛŋ as luku. ");
INSERT INTO adj_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pↄl ɛsŋn ɛl, ɛtŋ mɛwl ɛm am dad ɛl in e juma ab ɛm ecʼów fɛŋ eke Nyam kok agŋ a ekʼelm Jwifɛl a ecʼaraŋn a. ");
INSERT INTO adj_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Eke -lʼirir ow ecʼodad a uwr a, -li kↄklm Nyam; ɛtŋ -li dad Pↄl ninɛ: «Ɛy lisijim, am ɛkn eke Jwifɛl fandi fandi ub Jesu nawrɛ, ke ɛl fɛŋ -li bʼucu ol a -nʼↄny es sɛnyn sɛnyn a. ");
INSERT INTO adj_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Wɛl dad ɛl eke ŋ bi yɛgm Jwifɛl a fɛŋ ekʼin ir lutu a low eke wɛʼn kʼigŋ Mois ecʼol a in ɛlu es, ɛtŋ ɛmɛny ŋ bi dad wɛl eke wɛʼn kʼúbrm wɛl ecʼey a ekr es, wɛʼn kí kokm Jwifɛl ecʼów a. ");
INSERT INTO adj_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","-Li bʼow -lʼiri tasi eke ŋ ow aŋa. Ayaf si ki kokr ab ee? ");
INSERT INTO adj_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Ow akpl ke kók ow a eke si bʼow si dadʼŋ a. Aŋa, sʼↄny agŋ yar ekʼij nɛny Nyam ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Òc ɛl ab im, ànŋ ɛl ab sos ayal eci low kok ab ɛm, ke sↄ́g ɛl e low kok a e labm, yecʼɛtŋ ke -lʼↄtu -lʼɛr sin. Ow ɛm a, agŋ a fɛŋ bʼow uw any eke ów a fɛŋ e wɛl dad ŋ e lís a elm nawrɛ; ow bʼow yɛgm eke ŋ yɛji anŋ Mois ecʼol a ecʼɛlum ɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Agŋ a ekʼelm Jwifɛl ke ub nawrɛ a ecʼa, si kok lɛl sʼawŋ ɛl si dad ɛl ów yecʼa eke si bɛbm a. Kin ów a: -li kʼijmn ndey eke wɛl oc wawr egb ↄŋ sɛkp, -lʼɛgŋmn mebl, -lʼijmn ndey eke wɛl okm mebl es, -lʼijmn nfaci.» ");
INSERT INTO adj_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Af yogŋ, Pↄl oc agŋ yar amua ab im, ɛtŋ eke lɛgŋ ɛny a, -nʼim wɛl ab sos ayal eci low kok ab ɛm. Ɛmɛny nʼim Nyamel gbɛl ab ɛm ɛtŋ nʼam dad wɛl dedeku ɛm lɛgŋ yecʼaf eke sos ayal eci low kok a bʼow uwr ke wɛl bʼow waw ɛl ɛm ecʼɛgŋ nyam nyam ecʼegb a. ");
INSERT INTO adj_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Eke sos ayal eci sɛgŋ lↄbŋ a am ow uwr a, kpɛkŋ Azi ogog eci Jwifɛl a ɛkn Pↄl Nyamel gbɛl a e gbugŋ a. -Lʼij abra -nʼↄŋ dedeku a fɛŋ ɛtŋ -nʼↄny ow; ");
INSERT INTO adj_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","-nʼam ↄg -li dad -lʼɛsɛ: «Israɛl ecʼagŋ, ɛ̀lumn ɛy abu! Kin ɛgŋ a eke usu fɛŋ, agŋ fɛŋ ecʼany af bi dad ów eŋuŋ ok Israɛl ecʼagŋ af, Mois ecʼol ab af lele Nyamel gbɛl na af ab a. Ɛtŋ sicaca ɛm a, lʼot agŋ ekʼelm Jwifɛl lʼok Nyamel gbɛl ab ɛm; ow ɛm a, -ni ŋuŋn usu lala a Nyam ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Tasi ɛm a, -nʼam dad ɛbɛn aŋke -lʼɛkn Efɛs iy Trofim Pↄl ab ɛb ab ɛm. -Nʼam tutr eke Pↄl oc ɛluʼl Nyamel gbɛl a e gbugŋ lokm a. ");
INSERT INTO adj_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Likekr a eb es ɛb ab ɛm ɛtŋ ↄy ↄy a fɛŋ ɛm agŋ am anŋ ow. -Nʼↄny Pↄl -lʼↄdu -lʼɛlu ow ↄkm Nyamel gbɛl a e gbugŋ a ɛtŋ kpɛkŋ -li babl masany a. ");
INSERT INTO adj_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","-Nʼam ↄl eke -li kʼibi Pↄl, ɛtŋ kpɛkŋ wɛl im dad Rom e kumada a ekʼanŋ Jerusalɛm a likekr a eke eb es ɛb a fɛŋ ɛm a e low. ");
INSERT INTO adj_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Kpɛkŋ lʼot srↄda eyŋ lele ɛl ecʼanym ɛsɛl ab ab ɛtŋ lʼuru es nʼim dedeku a ogŋ a. Eke -li bʼɛkn kumada a lele srↄda eyŋ ab ab a, -lʼↄrm Pↄl ij. ");
INSERT INTO adj_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Kumada a ɛri im titm Pↄl, ↄŋ wɛl ↄnyʼn ɛtŋ ↄŋ abusu eke wɛl kʼoc ŋgbraka yony awŋnʼn; ɛtŋ lʼibrm ɛgŋ yecʼa eke lʼel a lele low yecʼa eke nʼam kok ab ab. ");
INSERT INTO adj_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Gbɛkↄ dedeku ab ɛm, agŋ amua ám dad odad na, ke bɛb ám dad ɛjeci. Kumada a ↄ́tum irim low a tasi likekr na ɛm; nʼↄŋ abusu eke wɛl kʼoc Pↄl im in eci frutu lakp ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Eke Pↄl anŋ êl a ecʼaf uyu usu a, srↄda eyŋ a ocʼr abu ɛm abu ɛm, dedeku a e lɛc ekʼam ɛlu ↄkm a sosiɛm, ");
INSERT INTO adj_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","aŋke agŋ a fɛŋ am usʼr jam ↄg dad ɛsɛ: «Wɛl íbiʼr! Wɛl íbiʼr!» ");
INSERT INTO adj_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wanci ab af eke srↄda eyŋ a am ↄl eke kʼↄny Pↄl ɛlu frutu lakp ab ɛm a, li dad kumada a ninɛ: «Kↄ mʼↄny abusu eke mi ki dadʼŋ odad tɛl ee?» Kumada a ninɛ: «Kↄ bʼɛbr Grɛk ee? ");
INSERT INTO adj_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Njɛ elm Ejipt iy a eke efnɛny a cɛ is ar ke ot áru fandi yar ab im loj ab ee?» ");
INSERT INTO adj_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pↄl dad ninɛ: «Ɛm Jwif, wɛl ewʼm Tars ɛb ɛm, Silisi wus af, ɛb ekʼↄny any ecʼɛgŋ. Mʼam ŋↄŋnʼŋ, ↄŋʼm abusu mi dád dedeku a odad.» ");
INSERT INTO adj_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kumada a ↄŋʼn abusu. Pↄl inym es êl a ecʼaf uyu usu a ɛtŋ lʼↄwl wɛl abu eke -li ki yewal. Eke -li yewalil a, Pↄl am dad ɛl odad Ebre ɛm: ");
INSERT INTO adj_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","«Agŋ lisijimɛl lele agŋ ɛsɛl ab, ìgŋn lↄru es ke írir low yecʼa eke sica mʼam ow mi dad ɛm e dogŋn ecʼa.» ");
INSERT INTO adj_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Eke sica -lʼirir ekʼow am dad ɛl odad Ebre ɛm a, usu a irm es tiŋ ɛtŋ Pↄl dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","«Ɛm Jwif, wɛl ewʼm Tars ɛb ɛm, Silisi wus af, gbɛkↄ Jerusalɛm aŋa wɛl gbagblʼm, ɛtŋ Gamaliɛl el ɛm e low yɛgm ɛs. Li yɛgmʼm mʼuw ɛy lagŋɛl ecʼol ab any sɛnyn sɛnyn. Nyam eci juma kok a eci lɛc a iyʼm ɛm nↄnↄ ɛsɛ elel eke yɛfɛnyna ↄny fɛŋ ow iy ↄny ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mʼijr agŋ a ekʼam us Ɛs Kↄtↄkↄ Jesu ecʼejagb na a gbre luw eci. Mʼↄny egŋ lele ↄyↄw ab mʼok sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Egb waw ɛs ligbɛl a lele Sanedrɛn a nimum ab ↄtu ekʼij daŋku ekʼow el odad nawrɛ eke mʼam dad. Ɛl ecʼabu ɛm, mʼɛŋn silɛl ɛy lisijimɛl Jwifɛl ekʼanŋ Damas a eci eke ow ɛm -li kʼuwrʼm any; ɛtŋ mʼim eke mi kʼↄny ↄmn ɛsɛl a ekʼanŋ a, mʼók ɛl ŋgbraka ke mʼót ɛl ab mʼow Jerusalɛm ke mi kók ɛl low ŋuŋ.» ");
INSERT INTO adj_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","«Mʼus ejagb mʼaam ɛtŋ eke mʼam titm Damas a, lɛgŋ uyu nuŋ ɛm, kpɛkŋ usuayl ligbɛl nyam eci jɛjn a anŋ afr ow uburʼm es. ");
INSERT INTO adj_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mʼɛy wus ɛtŋ mʼiri lebl nyam ekʼam dadʼm ɛsɛ: “Sↄl, Sↄl, kↄ bla ɛtŋ am ijrʼm gbre ee?” ");
INSERT INTO adj_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Mʼibrm mʼɛsɛ: “Ɛgŋ gbɛl, kↄ ŋ bwo elʼŋ ee?” Lebl a dad ninɛ: “Ɛm Nasarɛt e Jesu ekʼam ijr gbre a.” ");
INSERT INTO adj_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Agŋ a ekʼanŋ ɛm ab a ɛkn usuayl a, kↄ -lʼirim ɛgŋ a ekʼam dadʼm odad a e lebl a. ");
INSERT INTO adj_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Mʼibrm mʼɛsɛ: “Ɛs Kↄtↄkↄ, ayaf mi ki kokr ab ee?” Ɛtŋ li dadʼm ninɛ: “Ìgb wus, ìm Damas, yogŋ wɛl bʼow dadʼŋ low yecʼeke Nyam am dadʼŋ eke ki kok a.” ");
INSERT INTO adj_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Eke usuayl na ekʼam jɛjn a efalʼm any a, agŋ a ekʼanŋ ɛm ab a ↄnyʼm abu ɛtŋ ɛwlʼm Damas. ");
INSERT INTO adj_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","Yogŋ, ɛgŋ nyam anŋ eke wɛl bʼɛsŋ Ananias, Nyam nuŋ igŋ ɛs sɛnyn eke bʼɛlum ɛy ecʼol a, ke Damas e Jwifɛl a fɛŋ bʼerur in e low. ");
INSERT INTO adj_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Lʼow nʼɛŋnʼm, li titmʼm ɛtŋ li dadʼm ninɛ: “Ɛm lisijim Sↄl, ɛ̀kn es!” Wanci ab af cɛ, any efl a oc es ɛtŋ mʼam ɛknʼn. ");
INSERT INTO adj_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Lʼigŋ af li dad ninɛ: “Ɛy lagŋɛl e Nyam a ikŋ anym sↄsum ocʼŋ yecʼɛtŋ ke úw low yecʼa eke lʼerur ab any, ɛ́kn Nɛnyɛmbri Nyam Ɛs a, ke íri in obi e nɛny ɛm ecʼodad. ");
INSERT INTO adj_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Tasi ɛm a, ow it eke kʼij in e daŋku yecʼɛtŋ ke agŋ a fɛŋ ecʼany af, dád low yecʼa ekʼɛkn ke iri a. ");
INSERT INTO adj_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ɛtŋ sica bla sosiɛm kʼeku ee? Ìgb, òk mij nuŋ, ke ŋ eci sikpl a fɛŋ tɛ́tŋ es in e nin a ecʼɛsŋ ɛm.” ");
INSERT INTO adj_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Mʼɛwl mʼim Jerusalɛm, ɛtŋ eke mʼam ŋↄŋn Nyam Nyamel gbɛl a e gbugŋ a, mʼɛkan nuŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Mʼɛkn Ɛs Kↄtↄkↄ ɛtŋ li dadʼm ninɛ: “Ògŋ es ɛy ↄkm Jerusalɛm fafa, aŋke ɛm e lís e low a eke am dad a, ɛb eyŋ a kʼow ɛgŋm ow e low ebm.” ");
INSERT INTO adj_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Mi dad mʼɛsɛ: “Ɛs Kↄtↄkↄ, -lʼuw any tasi eke mi bʼim Nyam nuŋ igŋ susu mʼↄny agŋ mʼok sobel ɛm ɛtŋ mi bʼↄŋ wɛl ↄr agŋ eke bʼubʼŋ nawrɛ a. ");
INSERT INTO adj_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ɛtŋ lɛgŋ a eke wɛl ibi ŋ e daŋku ij ɛs Etiɛn a, ɛm yɛji mʼanŋ yogŋ. Agŋ a ekʼam ibi Etiɛn a, mʼɛgŋ ɛl e low a mʼeb ɛtŋ mʼↄsu ɛl e mob sus ɛm a.” ");
INSERT INTO adj_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ɛs Kↄtↄkↄ dadʼm ninɛ: “Ìm, aŋke mʼow mʼɛrmʼŋ usu kpekpe, agŋ a ekʼelm Jwifɛl a ogŋ.” » ");
INSERT INTO adj_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Dedeku a iri Pↄl ecʼodad a toŋ batŋ igŋ yogŋ a eke li dad ów amua na a; kↄ sica -nʼam ↄg -li dad -lʼɛsɛ: «Ìrmnin ɛgŋ na! Ìbir ir! Lʼitm eke li kʼanŋ owr!» ");
INSERT INTO adj_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","-Nʼam ↄg, -nʼam ufŋ ɛl e mob sus ɛm ab es, ɛtŋ -nʼam wↄwl sɛc afr. ");
INSERT INTO adj_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Kumada a ibrm eke wɛl kʼↄny Pↄl ɛlu in eci frutu lakp ab ɛm, ke wɛl ↄ́rʼr ŋgbre ɛm, ow ↄŋʼn li dád odad, yecʼɛtŋ ke lʼúw low a sosiɛm eke dedeku a am ↄgrʼr ab any. ");
INSERT INTO adj_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Gbɛkↄ eke wɛl awŋʼn eke kʼↄrʼr a, li dad srↄda eyŋ ekŋ yen ecʼanym ɛs a ekʼanŋ yogŋ a ninɛ: «Kↄ ↄny abusu eke kʼↄr Rom iy tasi eke wɛl jɛjm in e low okm ee?» ");
INSERT INTO adj_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Eke lʼiri ów amua a, nʼim nʼam ↄŋ in eci kumada a amani li dad lʼɛsɛ: «Bogŋ e low anake blel kok ab ee? Ɛgŋ na Rom iy tasi!» ");
INSERT INTO adj_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Kumada a ow ɛŋn Pↄl ɛtŋ am ibrmʼn ɛsɛ: «Dàdʼm ↄ, kↄ ŋ Rom iy tasi ee?» Pↄl dadʼr ninɛ: «Ɛɛ, ɛm Rom iy.» ");
INSERT INTO adj_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Ɛtŋ kumada a dad ninɛ: «Ɛm labm ligbɛl mi sↄg gbuŋ ɛtŋ mʼel Rom iy tasi.» Pↄl dad ninɛ: «Ɛm ecʼa gbɛ, mew ɛm ɛtŋ.» ");
INSERT INTO adj_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Kpɛkŋ agŋ a ekʼam ow ↄrʼr yecʼɛtŋ ke li dád odad a, ɛwl sos mɛny; kumada a in obi yɛji erŋn ↄny eke Pↄl kʼel Rom iy tasi ke nʼↄŋ wɛl ↄny awŋ ow ŋgbraka ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Kumada a am erur eke kʼuw low a tasi ekʼow sosiɛm Jwifɛl a am ok Pↄl ów af ab any; na sosiɛm, eke lɛgŋ ɛny a, nʼↄŋ wɛl mↄmu Pↄl es ŋgbraka ab ɛm, ɛtŋ lʼibrm egb waw ɛsɛl ecʼes ɛwɛl a lele Sanedrɛn a fɛŋ ab eke kʼas luku. Lʼoc Pↄl lʼow ɛtŋ nʼinymn ow es ɛl ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pↄl ok Sanedrɛn ecʼagŋ a anyamn af ɛtŋ am dad ɛl ɛsɛ: «Agŋ lisijimɛl, Nyam ab ecʼɛb eke mʼir toŋ ke kʼit yɛfɛnyna a, ɛm tutr ɛm a, mʼↄnym low kaka eke mi kokr ɛm sosi ów af.» ");
INSERT INTO adj_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Egb waw ɛs ligbɛl Ananias ↄŋ abusu ekʼagŋ a ekʼanŋ Pↄl saw a, ki bↄbmʼn nɛny es. ");
INSERT INTO adj_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ow ↄŋ Pↄl dadʼr ninɛ: «Ŋ anake Nyam bʼow ↄrʼŋ a; ŋ, êl eke wɛl ufur! Anŋ aŋa eke ki jɛj ɛm e low ok ol ɛm, kↄ ol ibrm eke kʼↄŋ wɛl ↄrʼm ee?» ");
INSERT INTO adj_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Agŋ a ekʼanŋ Pↄl saw a am dadʼr ɛsɛ: «Nyam ecʼegb waw ɛs ligbɛl a am wɛwr ee?» ");
INSERT INTO adj_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pↄl dad ninɛ: «Lisijimɛl, mʼuwm any ekʼow el egb waw ɛs ligbɛl ab ab ↄ! Tasi ɛm a, Nyam Lɛl am dad ɛsɛ: Kí dadm ŋ ecʼɛb ecʼes ɛw a e nin ŋuŋ.» ");
INSERT INTO adj_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Pↄl uw any eke Sanedrɛn ecʼagŋ a e bɛb a el Sadusiɛl ɛtŋ likpr a Farisiɛl; na sosiɛm anake ɛl ecʼany af lʼagbr lebl es li dad eke: «Lisijimɛl, ɛm Farisi, Farisi ecʼiy. Eke mʼub luw ɛm anŋ igb owi nawrɛ a sosiɛm anake wɛl am jɛj ɛm e low ok a.» ");
INSERT INTO adj_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Kpɛkŋ eke Pↄl dad ów amua a, Farisiɛl a lele Sadusiɛl ab ab ów es atar ɛy ɛm, ɛtŋ luku as a ecʼagŋ a ubr ɛm sakp yony. ");
INSERT INTO adj_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Tasi ɛm a, Sadusiɛl bi dad eke luw ɛm anŋ igb in anm ɛtŋ afr ɛrm ɛsɛl lele abŋ ab yɛji in anm; gbɛkↄ Farisiɛl ↄny ↄmn ów amua fɛŋ ɛm.) ");
INSERT INTO adj_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Likekr a am at es, ɛtŋ ol eci low yɛgm ɛsɛl bɛb ekʼel Farisiɛl ecʼogog ecʼagŋ a igb ɛrm bebl ɛm am dad ɛsɛ: «Sʼɛŋnm low ↄbr kaka ɛgŋ na ɛm. Ow kʼↄdm abŋ nyam oglog afr ɛrm ɛs nyam dadʼr odad!» ");
INSERT INTO adj_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ów es atar a am uyu afr toŋ kumada a erŋn am ↄny bake wɛl píplm Pↄl ɛm. Na sosiɛm anake nʼↄŋ in eci srↄda eyŋ a eke kʼim dedeku ab ɛm ↄny Pↄl oc es ɛl ecʼaraŋn, ke -lʼoc -nʼim ow frutu lakp ab ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Lɛgŋ bʼuk a, Ɛs Kↄtↄkↄ ɛlu sos ↄkm Pↄl ecʼany af ɛtŋ dadʼr ninɛ: «Sos átʼŋ es! Ij ɛm e daŋku Jerusalɛm aŋa, ɛtŋ ow it eke Rom yɛji ow kʼel ɛbɛn.» ");
INSERT INTO adj_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Lɛgŋ bʼɛny eci ibribr a, Jwifɛl bɛb ut asre; -lʼɛgŋ -lʼeb -lʼij nɛny eke -li kʼijmn ob, -lʼɛgŋmn mij eke -li kʼibim Pↄl. ");
INSERT INTO adj_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Agŋ a ekʼut asre ikŋ na a, ij agŋ ekŋ yony afŋ es. ");
INSERT INTO adj_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","-Nʼim -nʼɛŋn egb waw ɛsɛl ecʼes ɛw ɛsɛl a lel agŋ ekpekp ab ab ɛtŋ -li dad wɛl ninɛ: «Sʼɛgŋ sʼeb sʼij nɛny eke si kʼíjm ob kaka eke si kʼibim Pↄl. ");
INSERT INTO adj_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Sica ↄny lele Sanedrɛn ecʼagŋ ab ab, ìbrmn kumada a eke kʼoc Pↄl is ↄny; dàdr eke am erurir eke kʼɛkanin in e low ab ɛm sɛnyn sɛnyn. Ɛy obi ɛm a, si bɛbm sos eke si kʼibiʼr gbuŋ ke lʼów lʼok aŋa.» ");
INSERT INTO adj_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Gbɛkↄ Pↄl lisijↄw iyŋ nyam iri asre ut a ecʼodad a. Nʼim lʼɛy frutu lakp ab ɛm lʼɛwar ɛyu. ");
INSERT INTO adj_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Ow ↄŋ Pↄl ɛsŋ srↄda eyŋ ekŋ yen ecʼanym ɛsɛl ab ɛm e nyam ɛtŋ dadʼr ninɛ: «Ɛ̀wl ŋgbafrɛli na ŋ e kumada a ogŋ; nʼↄny low eke li ki dad ow.» ");
INSERT INTO adj_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Srↄda eyŋ ecʼanym ɛs a ocʼr ab im kumada a ogŋ ɛtŋ dad ninɛ: «Pↄl, sobel ɛm ɛs a ɛsŋʼm ɛtŋ dadʼm eke mi kʼisʼŋ ŋgbafrɛli na, nʼↄny low eke li dadʼŋ.» ");
INSERT INTO adj_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Kumada a ↄny ŋgbafrɛli a abu ab im saw ɛm, ɛtŋ am ibrmʼn ɛsɛ: «Bla odad iy ki dadʼm ee?» ");
INSERT INTO adj_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Li dad ninɛ: «Jwifɛl nɛny okr af eke efi kʼibrmʼŋ oc Pↄl ow Sanedrɛn ecʼagŋ ecʼany af; -nʼam iwr -li dad eke Sanedrɛn ecʼagŋ a in am ↄl eke in kʼɛkan low ab ɛm sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Gbɛkↄ kʼùb ɛl nawrɛ! Aŋke ɛl ɛm ecʼagŋ ekŋ yony ekʼafŋ es bʼow lↄl es ↄnyʼn. -Lʼɛgŋ -lʼeb -lʼij nɛny eke -li kʼijmn ob, -lʼɛgŋmn mij toŋ ke -lʼibi ow. Caca ɛm a, -li bɛbm sos, -nʼam eku ŋ ecʼodad ebl cɛ.» ");
INSERT INTO adj_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Li dad ŋgbafrɛli a ninɛ: «Kì dad odad na eke dadʼm a kʼok ɛgŋ kaka.» Ɛtŋ kumada a ɛluʼl es nʼim. ");
INSERT INTO adj_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Ow e jam a, kumada a ɛsŋ in e srↄda eyŋ ekŋ yen ecʼanym ɛsɛl ab ɛm e yony ɛtŋ li dad wɛl ninɛ: «Àsr srↄda eyŋ agŋ ekŋ lɛw, gbaŋkↄ af uyu ɛsɛl agŋ ekŋ nyahan lele lɛw, lele mpioro ↄwl ɛsɛl agŋ ekŋ lɛw ab luku ke ↄny fɛŋ bɛ́bmn sos imn Sesare ncebles e wanci libarm ɛm. ");
INSERT INTO adj_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Sigbaŋkↄ a yɛji eke kʼoc Pↄl im sɛnyn sɛnyn es ɛw ɛs Felis ogŋ a, bɛ̀bmn ɛl sos.» ");
INSERT INTO adj_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ɛtŋ kumada a nↄn lɛl na: ");
INSERT INTO adj_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","«Klod Lisias am ɛsŋn in ecʼes ɛw ɛs mamn Felis. ");
INSERT INTO adj_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Jwifɛl ↄny ɛgŋ na aam ibi; eke mʼiri eke lʼel Rom iy tasi a, mʼim ɛm e srↄda eyŋ ab ab mʼɛdŋn in abu any ɛtŋ mʼeb mʼɛluʼl es. ");
INSERT INTO adj_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Eke mʼerur eke mi kʼuw low a sosiɛm eke Jwifɛl am okʼr ów af ab any a, mʼocʼr mʼim ɛl e Sanedrɛn ecʼagŋ a ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mʼɛkn eke ów a eke -nʼam dad -lʼok ow af a, el ɛl obi ɛm ecʼol a ecʼów, gbɛkↄ wɛl ↄtum ɛŋnm low ↄbr ekʼow ɛm li kʼɛŋn luw oglog ke wɛl ɛluʼl sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ɛtŋ eke wɛl ɛwarʼm eke Jwifɛl am ut in ecʼasre a, mʼerur eke mi kʼocʼr mʼis ŋ ɛtŋ mʼibrm agŋ a ekʼam okʼr ów af a eke kʼↄŋʼn dedeku ŋ ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Srↄda eyŋ a ɛlum ol a eke wɛl ↄŋ ɛl a: -lʼoc Pↄl ɛtŋ ncok ɛm -lʼɛwl ow toŋ -lʼok Antipatris. ");
INSERT INTO adj_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Lɛgŋ bʼɛny a, srↄda eyŋ a ekʼim lakr ɛm a, ɛwl ow frutu lakp ab ɛm ɛtŋ ɛlu gbaŋkↄ af uyu ɛsɛl ab es aam usu a Pↄl ab. ");
INSERT INTO adj_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Eke -nʼimn -lʼokr Sesare a, gbaŋkↄ af uyu ɛsɛl a oc lɛl a ↄŋ es ɛw ɛs a ɛtŋ -lʼoc Pↄl -lʼɛlu ow abu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Es ɛw ɛs a awl lɛl a ɛtŋ ibrm Pↄl wus yecʼaf ecʼɛgŋ eke li kʼel a. Eke lʼiri ekʼow el Silisi wus af ecʼɛgŋ a, ");
INSERT INTO adj_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","li dad ow ninɛ: «Ŋ ecʼagŋ a ekʼam okʼŋ ów af a bʼow ow a, mʼow mʼibrmʼŋ low.» Ɛtŋ nʼↄŋ abusu eke wɛl kʼɛw Pↄl es Erↄd ecʼêl gbɛl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Sɛgŋ yen bʼɛc a, egb waw ɛs ligbɛl Ananias ow Sesare agŋ ekpekp bɛb ab lele awoka nyam eke wɛl bʼɛsŋ Tɛrtulus ab. -Lʼow es ɛw ɛs Felis ecʼany af eke -li kʼↄŋ Pↄl dedeku. ");
INSERT INTO adj_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wɛl ɛsŋ Pↄl, ɛtŋ Tɛrtulus am okʼr ów af sodad amua ɛm: «Es ɛw mamn, ŋ e nin ɛm, sʼam ir ɛb ɛrm es ɛy ɛm, ɛtŋ ŋ e nyimn sɛnyn ɛm anake ów amua tititŋn akpl ɛy ecʼɛb na ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Sɛgŋ fɛŋ, usu fɛŋ ecʼów eke si bʼɛŋn a, sʼam ɛluʼŋ ow e bia ɛrm nyam ɛm. ");
INSERT INTO adj_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Gbɛkↄ mʼerurm eke mi kʼirmnʼŋ lɛgŋ nↄnↄ, na sosiɛm anake mʼam ŋↄŋn ŋ ekʼɛrm kʼɛy ŋ es, ke íri ɛy ecʼodad a; ow kʼow ibnm. ");
INSERT INTO adj_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Sʼɛkn ekʼɛgŋ na el ɛgŋ ɛm e nuŋuŋ: li bʼis odad wus na nimum eci Jwifɛl ab ɛm, ɛtŋ lʼel Nasariɛl ecʼogog a ecʼes ɛw ɛs. ");
INSERT INTO adj_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Lʼɛw eke li ki ŋuŋn Nyamel gbɛl a sos; ow sosiɛm sʼɛwʼr abu af. Sʼerur eke si ki jɛj in e low sʼok ɛy ecʼol ab ɛm, ");
INSERT INTO adj_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","kↄ kumada Lisias ɛdŋn abu any ɛtŋ lɛc ɛm lʼeb ow ɛy ecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Nʼↄŋ abusu eke agŋ a ekʼam okʼr ów af a kʼow ŋ ecʼany af. Eke ibrmʼn low, ↄtu eke ŋ obi yɛji kʼuw low a tasi ekʼow sosiɛm sʼam okʼr ów af ab any.» ");
INSERT INTO adj_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Jwifɛl a akr lebl af, dad ekʼow el low nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Es ɛw ɛs Felis ↄwl Pↄl abu eke ki dad odad ɛtŋ Pↄl eb odad dad ninɛ: «Mʼuw any eke akpo nↄnↄ ɛm el ɛb na eci jɛj ok ɛs, ow anake mʼↄny ↄmn ke mʼam ow ŋ ecʼany af eke mi kʼayal sos a. ");
INSERT INTO adj_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Ɛsɛ elel eke ↄtu eke ŋ obi kʼotar akr ab af a, ow kokm sɛgŋ lɛw yony afŋm es eke mʼow Jerusalɛm Nyam nuŋ igŋ eci. ");
INSERT INTO adj_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Wɛl ɛŋnm im mʼatarm ów es Nyamel gbɛl a e gbugŋ a ɛgŋ kaka fɛŋ ab, ɛtŋ mʼokm dedeku a al ɛm Nyam nuŋ igŋ susu oglog ɛb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ɛtŋ sicaca ɛm a, agŋ amua kʼↄtum ayalm ów a eke -nʼam okʼm af a e low. ");
INSERT INTO adj_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Gbɛkↄ low na gbɛ, ŋ ecʼany af, mʼam mʼɛgŋ mʼeb: Ɛs Kↄtↄkↄ Jesu ecʼejagb a ecʼus ɛm a, ke ɛm lagŋɛl e Nyam a anake mʼam igŋ nuŋ a. Jwifɛl bi dad ekʼow el ejagb yadŋ, kↄ ɛm mʼub ol e silɛl a lele kokoba ↄb ɛsɛl e silɛl ab ab nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Mʼↄny ↄmn ikŋ na Nyam ɛm, ↄmn a eke ɛl obi yɛji -nʼↄnyn, eke Nyam bʼow igbm agŋ amamn lele eŋuŋ ab luw ɛm a. ");
INSERT INTO adj_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Na sosiɛm anake mʼam atr sos es eke mi kokrm ɛm sosi ów af Nyam ecʼany af lele agŋ ecʼany af ab a. ");
INSERT INTO adj_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","Eke mʼↄpi Jerusalɛm akpo nↄnↄ a, mʼɛwl mɛny mʼim eke mi kʼɛlum ɛm ecʼɛb a abu os ɛm, ke mʼáp Nyam ob. ");
INSERT INTO adj_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Eke -nʼɛŋanʼm Nyamel gbɛl a e gbugŋ a, ke mʼuwar sos ayal ecʼes gbɛgbl a ŋ̂; agŋ nↄnↄ anm ɛm ab, ɛtŋ sↄ́g yɛji anm. ");
INSERT INTO adj_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Gbɛkↄ Azi eci Jwifɛl nyam nyam anŋ yogŋ, ɛtŋ blel -nʼↄnyn low ɛm ab, ɛl anake blel -nʼinym es ŋ ecʼany af aŋa ke -lʼokʼm ów af a. ");
INSERT INTO adj_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Oglog ekʼagŋ amua ekʼanŋ aŋa a ɛkn low ŋuŋ eke mi kok lɛgŋ a eke mʼanŋ Sanedrɛn ecʼagŋ a ecʼany af a, -lʼↄtu eke -li ki dad. ");
INSERT INTO adj_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mʼinym es ɛl ecʼany af mʼigbl lebl ogŋ mi dad eke mʼub luw ɛm anŋ igb e low nawrɛ; kↄ low na cɛ eci anake yɛfɛnyna wɛl inymnʼm es ↄny ecʼany af jɛj ok ecʼab ee?» ");
INSERT INTO adj_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Felis ekʼiri Ɛs Kↄtↄkↄ Jesu eci ejagb owi a ok es sos ɛm sɛnyn sɛnyn a, oc jɛj ok a ɛw lɛgŋ ɛjeci ɛtŋ dad ɛl ninɛ: «Lɛgŋ eke kumada Lisias bʼow ow a, mʼow mi dad ↄny ecʼodad a.» ");
INSERT INTO adj_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Nʼↄŋ srↄda eyŋ ekŋ yen ecʼanym ɛs a abusu eke kʼɛw Pↄl es sobel ɛm, gbɛkↄ lʼɛw ow abusu es eke ow lawlɛl a ki kok ow e lís e low. ");
INSERT INTO adj_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Sɛgŋ bɛb bʼɛc a, Felis lele ɛy Drusiy Jwif yↄwi ab ab ow. Nʼↄŋ wɛl ɛsŋ Pↄl ow ɛtŋ nʼam iri ↄmn eke ow ↄny Jesu Krist ɛm a ecʼodad. ");
INSERT INTO adj_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Gbɛkↄ eke Pↄl ↄb nuŋ am dad es an mamn ecʼodad, sos es ↄnyn e low lele jɛj ok e lɛgŋ e low ab a, ow am ↄr Felis ɛtŋ li dad ninɛ: «Sica ↄtu eke kʼim gↄŋ. Lɛgŋ eke mʼow mʼɛŋn abusu a, mʼow mʼɛwl mʼɛsŋʼŋ.» ");
INSERT INTO adj_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","In ecʼↄmn ɛm a ke Pↄl bʼow ↄŋʼn os; na sosiɛm anake sakp nↄnↄ li bʼɛsŋ Pↄl ow ot nɛnym in ab a. ");
INSERT INTO adj_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Ɛbɛn ɛbɛn a cɛ toŋ akpo yony ɛc, ɛtŋ Pↄrsius Fɛstus usr Felis usu ɛsɛ es ɛw ɛs af. Eke Felis erur eke kʼeb sↄdŋ Jwifɛl ogŋ a, lʼɛw Pↄl es sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Sica Fɛstus ow ɛy in eci wus ab af eb juma; kpɛkŋ ekʼow ij sɛgŋ nyahan a, lʼigb Sesare lʼuyu nʼim Jerusalɛm. ");
INSERT INTO adj_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Egb waw ɛsɛl ɛgbɛl a lele Jwifɛl ecʼany ɛsɛl tasi ab ab ow in ogŋ a am ok Pↄl dedeku es. -Nʼam at -lʼibrm ow ");
INSERT INTO adj_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","eke ow kʼɛgŋ ɛl nɛnym ↄŋ Pↄl ow Jerusalɛm; tasi ɛm a, -lʼut Pↄl ecʼasre ɛtŋ -lʼerur eke -li kʼibi ow ejagb us ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Gbɛkↄ Fɛstus dad ninɛ: «Pↄl anŋ sobel ɛm Sesare ɛtŋ; ɛm obi yɛji ow kʼow ibnm mʼow mʼɛwl mʼim yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Ow akpl ke ↄny e any ɛsɛl a ów ɛwlʼm Sesare ke ekʼɛgŋ ikŋ na kok low ŋuŋ a, ókar ir dedeku es.» ");
INSERT INTO adj_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fɛstus kok sɛgŋ niwn oglog sɛgŋ lɛw cɛ ɛl ab, ɛtŋ lʼɛwl nʼim Sesare. Lɛgŋ bʼɛny a, nʼim jɛj ok ɛm ɛtŋ nʼↄŋ abusu eke wɛl kʼoc Pↄl ow. ");
INSERT INTO adj_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Eke Pↄl ow a, Jwifɛl a ekʼanŋ Jerusalɛm ow a, ɛlul il ɛm ɛtŋ am ↄny yadŋ ɛgbɛl okʼr af ekʼɛl obi yɛji -lʼↄtumn eke -li kʼayal. ");
INSERT INTO adj_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Gbɛkↄ Pↄl am dogŋn sos dad ɛsɛ: «Mi kokm low ↄbr kaka Jwifɛl ecʼol a e lís, Nyamel gbɛl a e lís lele Sesar e lís ab.» ");
INSERT INTO adj_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Fɛstus ekʼerur eke kʼeb sↄdŋ Jwifɛl ecʼany af a, ibrm Pↄl ninɛ: «Erur eke kʼim Jerusalɛm wɛl jɛj low na ok ɛm ecʼany af ee?» ");
INSERT INTO adj_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pↄl dad ninɛ: «Aŋa eke mʼinym es a, el Sesar eci jɛj ok usu nyam, ɛtŋ aŋa anake wɛl ki jɛj ɛm e low ok a. Ɛsɛ elel eke ŋ obi ŋ obi uw any ab af a, mi kokm Jwifɛl low ŋuŋ kaka. ");
INSERT INTO adj_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Eke mi kok low ekʼow ɛm mi kʼuw, ke mʼɛgbrm eke mi kʼuw. Gbɛkↄ eke ów a eke -nʼam dad -lʼokʼm af a elm nawrɛ a, ɛgŋ kaka kʼↄtum ocm im ↄↄm ɛl. Mʼam ibrm eke mi kʼɛkn Sesar!» ");
INSERT INTO adj_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Sica eke Fɛstus dad ów in ecʼów ↄm ɛsɛl ab ab bake ow uwr a, li dad ninɛ: «Ibrm eke kʼɛkn Sesar, bʼow im in ecʼany af.» ");
INSERT INTO adj_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Sɛgŋ bɛb bʼɛc a, ɛb ebu Erↄd Agripa lele lisijↄw Berenis ab ow Sesare eke kʼɛsŋn Fɛstus. ");
INSERT INTO adj_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Eke -nʼanŋn yogŋ -li kokr sɛgŋ nↄnↄ a, Fɛstus dad Pↄl ecʼodad ok Agripa. Kin odad a: «Ɛgŋ nyam anŋ aŋa eke Felis ɛw es sobel ɛm. ");
INSERT INTO adj_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Eke mʼim Jerusalɛm a, egb waw ɛsɛl ɛgbɛl a lele Jwifɛl ecʼagŋ ekpekp ab ab okʼr dedeku es ɛtŋ ibrm eke mi kʼↄbʼr low. ");
INSERT INTO adj_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Mi dad ɛl eke ow ɛcam Rom eyŋ ab eke kʼɛlu ɛgŋ eke wɛl am cicr ab es ↄŋ agŋ eke okʼr dedeku es a, eke lʼↄbarm any wɛl ab; ow it eke wɛl kʼↄŋʼn abusu li dad in e cicr a ecʼodad yɛ. ");
INSERT INTO adj_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Ow sosiɛm -lʼow aŋa ɛm ab ɛtŋ mʼirmnm lɛgŋ; eke lɛgŋ ɛny a, mʼim jɛj ok usu a ɛtŋ mʼↄŋ abusu eke wɛl kʼoc ɛgŋ a ow. ");
INSERT INTO adj_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","In eci cicr ɛsɛl a ow, gbɛkↄ -li cicrm ow ów eŋuŋ a ekʼow ɛm mʼↄny tutr a e kaka af. ");
INSERT INTO adj_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","-Lʼatar ów es ow ab ɛl obi eci Nyam nuŋ igŋ owi ɛm lele ɛgŋ nyam eke wɛl bʼɛsŋ Jesu eke uw ke Pↄl am at dad eke owʼn nʼanŋ owr a e low af. ");
INSERT INTO adj_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mʼuwm elel eke mi ki kokr low nɛnɛ ɛm ab any; na sosiɛm anake mʼibrm Pↄl eke kʼim Jerusalɛm yecʼɛtŋ ke yogŋ wɛl jɛ́j low na ok a. ");
INSERT INTO adj_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Gbɛkↄ Pↄl ɛgŋm; lʼibrm eke li kʼel sobel ɛm ɛs toŋ ke Sesar ↄny low dadʼr. Mʼↄŋ abusu eke wɛl kʼɛwʼr es toŋ ke mʼↄ́ŋʼn nʼim Sesar ogŋ a.» ");
INSERT INTO adj_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Agripa dad Fɛstus ninɛ: «Mʼerur tasi ekʼɛm obi yɛji mi kʼiri ɛgŋ na nɛnym.» Fɛstus dad ninɛ: «Efi bʼow iriʼr nɛnym.» ");
INSERT INTO adj_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Lɛgŋ bʼɛny a, Agripa lele Berenis ab ow agŋ ekʼus any ab ɛtŋ ok luku as usu a ecʼarabu ab ɛm kumadaɛl lele ɛb ab ɛm ecʼany ɛsɛl ab. Fɛstus ibrm eke wɛl kʼoc Pↄl ow. ");
INSERT INTO adj_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Ɛtŋ li dad ninɛ: «Ɛb ebu Agripa lele ↄny fɛŋ eke anŋn aŋa ɛy ab a, am ɛkan ɛgŋ na: in sosiɛm Jwifɛl nↄnↄ ow ɛknʼm Jerusalɛm lele aŋa ab, ɛtŋ am dad ekʼowʼn kʼánm owr ij. ");
INSERT INTO adj_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ɛm gbɛ, mʼɛkn eke li kokm low kaka ekʼow ɛm li kʼuw. Gbɛkↄ eke in obi lʼibrm eke li kʼɛkn Sesar a, mʼɛgŋ mʼeb eke mi kʼↄŋʼn nʼim yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mʼↄnym low tasi eke mi ki nↄn in e nuŋ af mʼↄŋ Sesar; na sosiɛm anake mʼocʼr mʼow ↄny ecʼany af, ŋ ɛb ebu Agripa ecʼany af tasi, yecʼɛtŋ ke wɛl bʼibrmʼn low, ke mʼↄ́ny low nyam mi nↄn. ");
INSERT INTO adj_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ow am ɛwʼm es adŋ sos ɛm eke tasi ɛm a, wɛl kʼoc sobel ɛm ɛs im Rom, ke wɛl kʼayalm ów a sosiɛm eke ow af wɛl am cicrʼr a!» ");
INSERT INTO adj_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Erↄd Agripa dad Pↄl ninɛ: «Abusu ɛruʼŋ es eke ki dad odad dogŋn sos.» Ɛtŋ Pↄl igbl abu ogŋ am dogŋn sos sodad amua ɛm: ");
INSERT INTO adj_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","«Ɛb ebu Agripa, sos ɛm am iŋnʼm eke yɛfɛnyna mi kʼow ŋ ecʼany af mi dad odad mi dogŋn sos ów a fɛŋ eke ow af Jwifɛl am cicrʼm a eci. ");
INSERT INTO adj_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Tasi ɛm a, uw Jwifɛl ecʼɛb ir owi lele ɛl eci ów es atar ab ab any. Ow sosiɛm, mʼam ŋↄŋnʼŋ eke kʼiri ɛm ecʼodad a ɛrm es ok ɛm. ");
INSERT INTO adj_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","Ɛm eci ŋgbafrɛ ɛm ɛtŋ ecʼes eke mʼan a, Jwifɛl fɛŋ uw any; -lʼuw elel eke nuŋ ↄb ɛm ɛtŋ mʼiir ɛm ecʼɛbr a ecʼaraŋn lele Jerusalɛm ab ab any. ");
INSERT INTO adj_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","-Lʼuwʼm any lɛgŋ kpekpe; eke -lʼerur, -lʼↄtu eke -li ki dad low nawrɛ: mʼel Farisiɛl ecʼogog ecʼɛgŋ ekʼɛl e Nyam nuŋ igŋ owi ɛw tuↄtuↄ akm ɛl lawlɛl a fɛŋ ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ɛtŋ sicaca ɛm mʼanŋ jɛj ok ecʼany af aŋke mʼↄny ↄmn Nyam e low a ekʼɛwar ɛy lagŋɛl ɛw es ab ɛm. ");
INSERT INTO adj_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Ɛy ecʼeb lɛw yony a ecʼagŋ a yɛji am ↄmn ɛwar na eke kʼɛy ↄkm; ow sosiɛm -nʼam igŋ Nyam nuŋ ari at ɛm, ncok lele lɛgŋ owr ab. Ɛb ebu Agripa, ↄmn ikŋ na sosiɛm ecʼanake Jwifɛl am okʼm ów af a! ");
INSERT INTO adj_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ɔny Jwifɛl, ke Nyam ígbm agŋ luw ɛm a, bla ɛtŋ am ubr ekʼow el low ekʼↄtu ee? ");
INSERT INTO adj_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","Ɛm obi yɛji, lɛgŋ sig ɛm a, mʼↄny tutr eke akunda kaka fɛŋ ɛm ow akpl eke mi kʼogŋ Nasarɛt e Jesu e nin a ar. ");
INSERT INTO adj_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Low na anake mi kok Jerusalɛm a. Egb waw ɛsɛl ɛgbɛl a ↄŋʼm abusu akpasu mum nyam eke mi kʼok ↄmn ɛsɛl nↄnↄ sobel ɛm, ɛtŋ mi bʼɛlu abusu es lɛgŋ eke wɛl bʼↄb ɛl low luw ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Sakp nↄnↄ mi bʼim Nyam nuŋ igŋ susu mʼↄŋ wɛl ijr ɛl gbre yecʼɛtŋ ke -lʼↄwr sar ɛl ecʼↄmn ↄny ab ɛm. Ɛl ecʼɛrm bebl eke mʼↄny a agb nↄnↄ, toŋ ow bʼↄŋ mʼim sɛb ɛjecʼɛm mʼijr ɛl gbre.» ");
INSERT INTO adj_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","«Ɛbɛn lɛgŋ nyam egb waw ɛsɛl ɛgbɛl a ↄŋʼm abusu eke mi kʼim Damas mi kok juma. ");
INSERT INTO adj_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ɛb ebu Agripa, mʼus ejagb ɛtŋ lɛgŋ uyu nuŋ ɛm a, mʼɛkn usuayl ekʼanŋ afr am ɛjn ow; jɛjn a afŋn ligbn ecʼab es, ɛtŋ am ok ɛm lele agŋ a eke ɛl ab mʼus ejagb ab ab af. ");
INSERT INTO adj_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Ɛy fɛŋ sʼok wus ɛtŋ mʼiri lebl nyam ekʼam ikŋ dadʼm Ebre ɛm ɛsɛ: “Sↄl, Sↄl, bla ɛtŋ am ijrʼm gbre ee? Kↄ bla ɛtŋ am ɛlu lɛc ↄkm ɛsɛ id eke in ecʼes ɛw ɛs bʼiyr likŋ af ee? Lɛc ↄfr ↄfr cɛ am ij.” ");
INSERT INTO adj_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Mʼibrm mʼɛsɛ: “Ɛgŋ gbɛl, kↄ bwo el ŋ ee?” Ɛtŋ Ɛs Kↄtↄkↄ dad ninɛ: “Ɛm Jesu a eke am ij gbre a. ");
INSERT INTO adj_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Sica ìgb inym es. Mʼɛlu sos ↄkm mi yɛgmʼŋ eke mi kʼocʼŋ el ɛm e juma kok ɛs; bʼow ij ɛm e daŋku dád ok agŋ elel eke ɛkanʼm yɛfɛnyna, ke dád yecʼa eke ɛmɛny mʼow mi yɛgmʼŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Mʼow mʼↄsuʼŋ Jwifɛl ecʼany af lele agŋ ɛjecʼa eke mʼow mʼɛrmʼŋ ɛl ogŋ ab ab ecʼany af. ");
INSERT INTO adj_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Mʼam ɛrmʼŋ eke kʼim fig fig ɛl anyamn, ↄny ot ɛl es ncebn ɛm ot ok ɛl usuayl ɛm, Satan ecʼabusu ab ɛm eke -nʼanŋn a ot ↄŋ ɛl Nyam. Eke -li bʼↄny ↄmn ɛm ɛm a, -li bʼow -nʼɛŋn ɛl e sikpl a ecʼoc ap lele es sig usu nyam agŋ a ekʼel Nyam ecʼab ab.” » ");
INSERT INTO adj_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","«Ɛb ebu Agripa, ɛbɛn a, es ɛkn owi a ekʼanŋ afr ow ke mʼɛkn a, mʼɛgbrm ow e low ij. ");
INSERT INTO adj_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Kↄ mʼikŋ anym mi dad Nyam odad mʼok Damas ecʼagŋ a lele Jerusalɛm ecʼab ab, Jude ecʼagŋ a lele ɛb ɛjecʼɛm ecʼagŋ ab; ɛl fɛŋ, mʼibrm ɛl eke -li kʼitŋn ɛrm ɛm, -lʼɛwl -li lɛr Nyam, ke -li kok ów eke bi yɛgm ɛl ecʼitŋn ikŋ na tasi a. ");
INSERT INTO adj_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Na sosiɛm anake Nyamel gbɛl a e gbugŋ a eke mʼanŋ a, Jwifɛl ↄnyʼm ke ↄl eke kʼibiʼm a. ");
INSERT INTO adj_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Gbɛkↄ Nyam ↄsuʼm toŋ it yɛfɛnyna ɛtŋ mʼanŋ eke mi kʼij daŋku agŋ fɛŋ ecʼany af, kʼow el agŋ ekʼↄny any, kʼow el agŋ ekʼↄnym any. Mi dadm odad ɛjeci ekʼow elm kokoba ↄb ɛsɛl lele Mois ab ecʼa eke dad eke bʼow ɛy a cɛ: ");
INSERT INTO adj_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Mesi a bʼow ij gbre, bʼow el ɛgŋ krɛkrɛ ekʼigb luw ɛm, bʼow ↄb usuayl a e kokoba ok ɛy ecʼɛb a lele ɛbr ɛjeci ecʼagŋ ekʼelm Jwifɛl a.» ");
INSERT INTO adj_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Eke Pↄl am dad ów in e sos dogŋn ecʼa, Fɛstus barmʼn es lebl tuↄtuↄ ɛm ninɛ: «Pↄl, nuŋ ɛm am uŋʼŋ! Wewr lɛl nↄnↄ toŋ ow am ɛwʼŋ nuŋ ɛm uŋ!» ");
INSERT INTO adj_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pↄl dadʼr ninɛ: «Ɛgŋ gbɛl, nuŋ ɛm uŋmʼm. Sodad a eke mʼam dad a el nuŋ ɛm es ok e sodad lele low nawrɛ tasi ab. ");
INSERT INTO adj_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Ɛb ebu Agripa otar ów amua akr uw any, ow sosiɛm in ecʼany af mʼↄtu eke mi ki dad ↄmn ɛm. Mʼuw any tasi eke lʼuw ów a fɛŋ any, aŋke ow elm es lↄl ɛm e low. ");
INSERT INTO adj_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Ɛb ebu Agripa, kokoba ↄb ɛsɛl ecʼodad a eke dad a ub nawrɛ ee? Mʼuw any ekʼub nawrɛ!» ");
INSERT INTO adj_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa dad Pↄl ninɛ: «Am tutr eke lɛgŋ tɛl na ɛm cɛ ↄtu eke kʼitŋnʼm mʼel kretiɛn ee?» ");
INSERT INTO adj_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pↄl dadʼr ninɛ: «Kʼow él lɛgŋ tɛl ɛm oglog sɛgŋ nↄnↄ ɛm, mʼam ŋↄŋn Nyam ekʼow kʼélm ŋ sↄny cɛ, kↄ ↄny fɛŋ ekʼam irir ɛm ecʼodad yɛfɛnyna a anake kʼanŋn ɛsɛ elel eke mʼanŋn ab af a, kↄ ŋgbraka amua gbɛ kʼánm ɛm!» ");
INSERT INTO adj_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Ɛb ebu a, es ɛw ɛs a, Berenis lele agŋ a eke -nʼanŋn yogŋ ab ab igb, ");
INSERT INTO adj_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ɛtŋ eke -nʼimn saw ɛm a, -nʼam dadarir ɛl ↄfr ɛm -lʼɛsɛ: «Ɛgŋ na kokm low ↄbr owi ekʼow ɛm li kʼuw, oglog kʼow ɛm wɛl ɛluʼl sobel ɛm.» ");
INSERT INTO adj_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Ɛtŋ Agripa dad Fɛstus ninɛ: «Blel ɛgŋ na ibram eke kʼɛkn Sesar ana, ke blel wɛl ɛ́luʼl es.» ");
INSERT INTO adj_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Sica wɛl ɛgŋ eb eke si bʼow sʼim Itali mijɛtŋ ɛm eci. Wɛl oc Pↄl lele sobel ɛm ɛsɛl ɛjeci bɛb ab abul srↄda eyŋ ekŋ yen ecʼanym ɛs nyam eke wɛl bʼɛsŋ Julius. Lʼel Rom eci srↄda eyŋ a ecʼeb a eke wɛl bʼɛsŋ “Sesar Ogust eci eb” a ecʼanym ɛs. ");
INSERT INTO adj_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Sʼok Adramit eci mijɛtŋ nyam eke kʼimn Azi e manu a ecʼa, ɛtŋ sʼim. Aritak yɛji anŋ ɛy ab; lʼel Tesaloni, Maseduan wus af a ecʼɛgŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Eke lɛgŋ bʼɛny a, sʼow sʼok Sidↄn. Julius eke am ↄny Pↄl sɛnyn sɛnyn a, ↄŋʼn abusu eke li kʼim lʼɛkn lawlɛl yecʼɛtŋ ke wɛl kók in e lís e low. ");
INSERT INTO adj_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Eke ɛmɛny sʼanŋ yogŋ sʼigb sʼaam a, sʼaru Sipr lekr a eke bʼɛdŋn lɛf any a, aŋke lɛf am ɛlu ↄbr ɛy. ");
INSERT INTO adj_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Sʼubr okij a eke titm Silisi wus lele Panfili wus ab a, ɛtŋ sʼim sʼok Mira, Lisi wus af. ");
INSERT INTO adj_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Yogŋ, Julius ɛŋn Alesandri eci mijɛtŋ nyam ekʼaam Itali ɛtŋ lʼot lʼok ɛy ɛm. ");
INSERT INTO adj_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Sʼus mij pɛtɛ pɛtɛ sɛgŋ nↄnↄ ɛtŋ gbre ɛm kpa, sʼim sʼok Nid baŋn any af. Eke lɛf a yɛbm ɛy eke si kʼↄkŋ any sʼim kpekpe a, sʼɛcr wus a ekʼusm owr Salamone ɛb a ecʼa sʼok Krɛt lekr a ecʼesr ɛm a eke bʼɛdŋn lɛf any a. ");
INSERT INTO adj_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Gbre ɛm ɛbɛn, sʼaru ligigl a sʼim sʼok usu nyam eke wɛl bʼɛsŋ Manu Amamn, ekʼanŋ Lase baŋn saw. ");
INSERT INTO adj_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Sʼirmn lɛgŋ nↄnↄ, ɛtŋ mij us a yɛji am ɛw tuↄtuↄ aŋke lakpo am uwr. Ow sosiɛm Pↄl am ɛwar ɛl dad ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","«Agŋ lawlɛl, mʼam ɛkn eke usu im a bʼow ɛw tuↄtuↄ: mijɛtŋ a lele sɛrɛkp ab ab bʼow uŋ, ɛtŋ ɛy obi yɛji sʼↄtu eke si kʼuw.» ");
INSERT INTO adj_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Gbɛkↄ srↄda eyŋ ekŋ yen ecʼanym ɛs a ↄny ↄmn mijɛtŋ nyimn ɛs a lele mijɛtŋ ɛs ab ab ɛm akm Pↄl e sodad a. ");
INSERT INTO adj_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ɛtŋ ɛmɛny nanu a akplm eke lɛtŋ kʼanŋ yogŋ lɛfr lɛgŋ iy na ɛm. Na sosiɛm agŋ nↄnↄ a ekʼanŋ mijɛtŋ ab ɛm a erur eke kʼigb yogŋ: -lʼerur eke -lʼↄtu, ke -nʼim -lʼok Fenis, Krɛt eci nanu nyam eke ↄkŋ esr ɛm eci nɛmn ogog a lele afr ɛm eci nɛmn ogog ab ab. Yogŋ anake -li kʼanŋ -lʼuwar lɛfr lɛgŋ iy a. ");
INSERT INTO adj_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Esr ɛm eci lɛf a am ɛlu pɛtɛ pɛtɛ, ɛtŋ -nʼam tutr eke ɛl eci tutr a bʼow ɛy af. -Nʼↄŋ mijɛtŋ a aam ɛtŋ am aru Krɛt eci ligigl a saw saw. ");
INSERT INTO adj_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Gbɛkↄ wanci ab af cɛ lɛf ligbɛl nyam eke wɛl bʼɛsŋ “afr ɛm e lidr ogog e lɛf” anŋ lekr a e mafɛny ab ɛm am ɛlu ow. ");
INSERT INTO adj_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Lɛf a oc mijɛtŋ ab ab aam: ow ɛw tuↄtuↄ eke wɛl kʼↄny mijɛtŋ ab es, ɛtŋ si yɛb ow oc ɛy ab im. ");
INSERT INTO adj_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Sʼɛcr esr ogog eci lekr liy nyam eke wɛl bʼɛsŋ Koda a, ɛtŋ ow ɛdŋn ɛy abu any. Gbre ij kpa ɛm, sʼↄtu sʼↄny es eb ɛlu e lɛtŋ likekli a ekʼucur mijɛtŋ gbɛl a. ");
INSERT INTO adj_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Mij ɛsɛl a ɛwl oc ɛluʼl mijɛtŋ ab ɛm. Sica -lʼoc meb -li cucu mijɛtŋ gbɛl a -lʼɛlul ɛm. Eke -nʼam uru eke li kʼim -lʼitr es mrici af Libi ogog a, -lʼɛlu dondo nuŋ a erŋ ɛtŋ -li yɛb lɛf a am oc ɛl ab im. ");
INSERT INTO adj_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Lidgbegb a abu anŋ ɛm am ɛlul ɛy tuↄtuↄ toŋ lɛgŋ ɛnyn ɛy ɛtŋ -nʼam ot sɛrɛkp a -lʼok erŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Lɛgŋ bʼɛny akr af a, ɛl obi ecʼabu ɛm -lʼot mijɛtŋ a e mob a -li wↄwl erŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Sɛgŋ nↄnↄ eke wɛl ɛknm ligbn, ɛknm mílɛ́l ɛtŋ lidgbegb a abu anŋ ɛm am ɛlu lɛc ɛm cɛ. Sʼↄnym ↄmn kaka eke si bʼow sʼↄtu sʼanŋ owr. ");
INSERT INTO adj_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Lɛgŋ kpekpe ekʼagŋ a ekʼus mij a ijm ob kaka. Pↄl igb ɛl ecʼany af ɛtŋ am dad ɛl ɛsɛ: «Agŋ lawlɛl, blel irir ɛm ecʼodad a eke mʼam dad eke si kʼókmn ↄkm Krɛt a, ke blel sʼↄbrmn es abur na, sʼirmnmn mob. ");
INSERT INTO adj_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Gbɛkↄ sicaca ɛm a, mʼam ibrm eke kʼↄnyn ɛrm susu, aŋke ↄny ɛm ecʼɛgŋ kaka kʼow irmnm in e sel a, kↄ mijɛtŋ a sↄny coco cɛ bʼow uŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Tasi ɛm a, ncok a ɛm e Nyam a eke mi bi kok in e juma a ecʼafr ɛrm ɛs nyam owʼm saw ");
INSERT INTO adj_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","ɛtŋ dadʼm ninɛ: “Pↄl, erŋn kʼↄ́nyʼŋ! Ow it eke kʼim Sesar ecʼany af, ke Nyam ecʼerur a eke ↄny ŋ ecʼa sosiɛm, li sↄ́g agŋ a ekʼus mij ŋ ab a.” ");
INSERT INTO adj_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Na sosiɛm, agŋ lawlɛl, ↄnyn ɛrm susu aŋke mʼↄny ↄmn Nyam ɛm: ow bʼow el ɛsɛ elel eke li dadrʼm ab af. ");
INSERT INTO adj_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Gbɛkↄ si bʼow sʼuŋ sʼinym es lekr nyam af.» ");
INSERT INTO adj_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Ncok lɛw yar ɛm eke sʼanŋ mij af ke lidgbegb a am oc ɛy ab im Mediterane eci okij ab af ana. Ncok eci lɛgŋ uyu nuŋ ɛm, mij ɛsɛl a am ɛkn ɛsɛ wus cɛ wɛʼn am titm af. ");
INSERT INTO adj_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","-Lʼɛlu meb eke wɛl ucu ob leg leg erŋ eke -li ki bɛbmn ɛtŋ -lʼɛkn eke mij a eci sibn a ij abu likŋ lele lɛw lↄbŋ ab; -li bʼim kpekpe tɛl a, ɛmɛny -lʼɛlu meb a erŋ ɛtŋ yogŋ ow ij abu likŋ lele niwn ab. ");
INSERT INTO adj_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","-Nʼam uru eke mijɛtŋ a kʼↄb lob, ow sosiɛm, lɛtŋ jam a -lʼɛlu magbis yar ɛrŋ eke -li kʼↄny lɛtŋ ab es, ɛtŋ -nʼam eku es ogŋ ɛm eke lɛgŋ kʼɛny. ");
INSERT INTO adj_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Mij ɛsɛl a am ↄl eke kʼok ↄkm lɛtŋ ab ɛm; -lʼusm es eb ɛlu e lɛtŋ ab es erŋ ɛtŋ -nʼam ub nyandrɛ -lʼɛsɛ: «Sʼaam lɛtŋ a ecʼanym a sʼucur lɛtŋ es ↄnyn ob ab es.» ");
INSERT INTO adj_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Gbɛkↄ Pↄl dad Julius lele srↄda eyŋ a ab ab ninɛ: «Eke agŋ amua anm mijɛtŋ ab ɛm, kʼow ↄtumn anmn owr.» ");
INSERT INTO adj_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Ow sosiɛm, srↄda eyŋ a bubr simeb a ekʼↄnyn es eb ɛlu e lɛtŋ ab es a ɛtŋ -li yɛb ow im. ");
INSERT INTO adj_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Gbuŋ ke usu ót es a, Pↄl ibrm ekʼagŋ a fɛŋ kʼij ob ɛtŋ am dad ɛsɛ: «Kin, yɛfɛnyna ab a, sɛgŋ lɛw yar eke am ekur ɛrm mij ab ke kʼijmn ob kaka. ");
INSERT INTO adj_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Mʼam ibrm eke kʼijr ob aŋke ow el ↄny e sel ɛŋn eci. Ɔny ɛm ecʼɛgŋ kaka kʼow irmnm in e sin nuŋ a e nyam.» ");
INSERT INTO adj_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Eke li dad ów amua uwr a, lʼoc futufutu, lʼɛlu Nyam bia wɛl ecʼany af, lʼubr ɛm ɛtŋ nʼam ij. ");
INSERT INTO adj_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Agŋ a fɛŋ sos at es ɛtŋ ɛl yɛji -lʼij ob a. ");
INSERT INTO adj_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Ɛy fɛŋ eke sʼanŋ mijɛtŋ ab ɛm a, sʼij agŋ ekŋ yen yen sakp yony agŋ ekŋ nyahan agŋ lɛw nↄhↄn. ");
INSERT INTO adj_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Eke -lʼijr ob molok iy ɛl a, -lʼot egb a eke -lʼotr ab -nʼaam a -lʼok erŋ eke mijɛtŋ a kʼɛw fuɛfuɛ. ");
INSERT INTO adj_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Eke lɛgŋ ɛny a, mij ɛsɛl a uwm wus a eke -li titmn ab any, gbɛkↄ -nʼam ɛkn wus ekʼusm ɛw lↄy kʼɛlu mrici ɛtŋ -lʼerur ekʼabusu ɛru es, -lʼitr mijɛtŋ ab es yogŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","-Ni mↄmu magbis ab es -lʼok erŋ, ɛtŋ -ni mↄmu mɛtŋbar eke wɛl bi nyiman lɛtŋ a e simeb a yɛjʼes. Ɛbɛn a, -lʼɛw gbad lɛtŋ nɛny a eke lɛf kʼitr lɛtŋ a, ɛtŋ -nʼimn mrici a ogŋ. ");
INSERT INTO adj_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Kↄ -nʼim -lʼↄbr sɛc ekʼanŋ mij any yony ecʼaraŋn ɛtŋ mijɛtŋ a abal inym es yogŋ. Lɛtŋ anym a ɛmn mrici ab ɛm ɛtŋ ↄtum iim ij, ɛtŋ mra am bↄbm lɛtŋ jam ab es lɛc ɛm. ");
INSERT INTO adj_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Srↄda eyŋ a am erur eke kʼibi sobel ɛm ɛsɛl a yecʼɛtŋ ke ɛl ɛm ecʼɛgŋ kaka kʼábŋm mij ɛym ↄkm. ");
INSERT INTO adj_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Gbɛkↄ Julius a am erur eke kʼeb Pↄl ɛlu es, ɛtŋ lʼɛdŋn wɛl eke -li ki kokmn low a eke -nʼↄnyn ow e tutr a. Nʼↄŋ agŋ a eke bʼabŋ mij a abusu eke kʼikŋ anym ok erŋ im ákpaf; ");
INSERT INTO adj_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","agŋ likpr a ot ↄgↄg og oglog mijɛtŋ a eci mob ekpr a us ɛl jam. Ɛbɛn ekʼagŋ a fɛŋ im itr es ke sos irm es ana. ");
INSERT INTO adj_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Eke sica sʼok ↄkm es abur na ɛm a, sʼiri eke wɛl bʼɛsŋ lekr a Malt. ");
INSERT INTO adj_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","In ecʼɛb eyŋ a eb ɛy sɛnyn sɛnyn, ɛtŋ eke mij am an ok wus ke lɛfr yɛji am ow a, -li fuf al ligbɛl nyam ekʼɛy fɛŋ sʼiwr sʼɛlul ɛm. ");
INSERT INTO adj_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pↄl oc milɛl eke wɛl abal eke kʼok al, kↄ al a ↄŋ lorŋn ɛy ↄkm arumʼn abu ab. ");
INSERT INTO adj_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Eke lekr a ecʼagŋ a ɛkn lorŋn ekʼarum Pↄl abu ab a, -nʼam dad ɛl ↄfr ɛm -lʼɛsɛ: «Ɛgŋ na ɛgŋ ibiu tasi; lʼɛy ↄkm okij ab ɛm, kↄ Nyam ɛm e jɛj ok a ↄↄm abusu eke li kʼanŋ owr.» ");
INSERT INTO adj_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Gbɛkↄ Pↄl ufŋ abu es ↄwl lorŋn a alm, ɛtŋ ob kaka kokmʼn. ");
INSERT INTO adj_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Agŋ a am eku eke kʼɛknʼn lʼew oglog lʼɛy luw kpru ɛm. Gbɛkↄ eke -lʼekur ow ibn ke -lʼɛkan eke ob kaka kokm Pↄl a, -lʼitŋn tutr ɛtŋ -nʼam dad ekʼow el nyàm mum nyam. ");
INSERT INTO adj_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Saw yogŋ, lekr a ecʼes ɛw ɛs gbɛl a eke wɛl bʼɛsŋ Publius a ecʼusu anŋ. Ɛgŋ ikŋ na eb ɛy erur ɛm ɛtŋ ↄŋ ɛy es ɛru usu toŋ sɛgŋ nyahan. ");
INSERT INTO adj_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Publius ɛs a ɛru es aŋke lɛfr ↄl am ↄnyʼn ɛtŋ nʼam ↄs sob yɛji. Pↄl im ɛknʼn, atʼr abu nuŋ, ŋↄŋn Nyam ↄŋʼn ɛtŋ ewlmʼn. ");
INSERT INTO adj_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Na bʼɛc a, lekr a ecʼↄ́lu ɛjecʼa yɛji ow ɛtŋ -lʼewl. ");
INSERT INTO adj_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Agŋ a ɛlu ɛl ecʼɛlum fɛŋ ↄkm ɛy e lís, ɛtŋ wanci a eke sʼam ow sʼigb sʼim a, -nʼↄŋ ɛy ob fɛŋ ekʼit usu imn ecʼa. ");
INSERT INTO adj_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Eke ow kok awl nyahan a, sʼeb Alesandri eci mijɛtŋ nyam eke anŋ lekr ab ɛm lɛfr lɛgŋ iy a nimum a sʼim. Wɛl bʼɛsŋ mijɛtŋ a “Sinyam Oli”. ");
INSERT INTO adj_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Sʼow sʼok Sirakus ecʼɛb ab ɛm, sʼanŋ yogŋ sɛgŋ nyahan. ");
INSERT INTO adj_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Yogŋ sʼɛcr ligigl a eci sʼim sʼok Rejio ɛb ɛm. Lɛgŋ bʼɛny a, esr ɛm eci lɛf a ↄb nuŋ am ɛlu ɛtŋ sʼeb sɛgŋ yony sʼim sʼok Pusↄl. ");
INSERT INTO adj_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Ɛb ab ɛm, sʼɛŋn agŋ lisijimɛl ekʼibrm eke si kʼanŋ ɛl ab sɛgŋ lↄbŋ, ɛtŋ sica sʼigb sʼaam Rom. ");
INSERT INTO adj_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Rom ecʼagŋ lisijimɛl a iri ɛy ecʼamani ɛtŋ ow toŋ ok usu eke wɛl bʼɛsŋ Apius ecʼAn Ɔl Usu a ɛy ecʼↄbr eci. Agŋ ɛjeci ɛŋn ɛy usu eke wɛl bʼɛsŋ Ɛŋanin Usu Nyahan a. Eke Pↄl ɛkn ɛl a, lʼɛlu Nyam bia ɛtŋ sos atʼr es. ");
INSERT INTO adj_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Eke sʼow sʼok Rom a, wɛl ↄŋ Pↄl abusu eke kʼir in ogŋ a ke srↄda iy nyam am ↄsuʼr. ");
INSERT INTO adj_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Ow bi kok sɛgŋ nyahan a, Pↄl ɛw Rom eci Jwifɛl ecʼes ɛwɛl a abu in ogŋ a. Eke -lʼasr luku a, Pↄl dad ɛl ninɛ: «Agŋ lisijimɛl, mi kokm low ŋuŋ ɛy ecʼagŋ a e lís, ɛy lagŋɛl a ecʼɛb ir owi e lís ɛtŋ wɛl ɛwʼm abu af Jerusalɛm, ocʼm ↄŋ Rom eyŋ. ");
INSERT INTO adj_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","-Lʼibrm im ów ɛtŋ -lʼerur eke -li kʼɛluʼm es aŋke ɛm ɛm a, -nʼɛŋnm low ekʼow af -li kʼↄbʼm low luw eci. ");
INSERT INTO adj_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Gbɛkↄ Jwifɛl a erurm ɛtŋ ow ↄŋ mʼibrm eke mi kʼɛkn Sesar ke wɛl ebr ɛm ecʼodad ab ɛm, kↄ ow elm ɛm ecʼɛb a eke mi kʼↄŋ dedeku eci. ");
INSERT INTO adj_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Kin low a sosiɛm eke mʼerur eke mi kʼɛkn ↄny ke mi dad ↄny odad a. Tasi ɛm a, mʼanŋ ŋgbraka na ɛm ɛgŋ a eke Israɛl ecʼagŋ a bʼↄny ↄmn in ɛm a sosiɛm.» ");
INSERT INTO adj_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","-Li dad ow ninɛ: «Sʼɛŋnm ŋ e lís e lɛl kaka eke kʼanŋ Jude ow ɛtŋ ɛy lisijimɛl kaka anm yogŋ owm tↄkŋm ów okm ɛy oglog dadm ɛy ŋ ecʼodad ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Kↄ sʼam erur eke ki dad low yecʼa ekʼam tutr a sʼiri, aŋke sʼuw any ekʼusu a fɛŋ agŋ erurm Nyam eb na ekʼanŋ ɛm a e low.» ");
INSERT INTO adj_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","-Lʼɛw lɛgŋ nyam Pↄl ab ɛtŋ lɛgŋ a bʼow a, -lʼow nↄnↄ -nʼɛŋn ow yogŋ a eke lʼir a. Ibribr toŋ ncebles, Pↄl am otar ów a akr ok ɛl: nʼam dad wɛl Nyam ecʼes ɛw a ecʼodad ɛtŋ Mois ecʼol a lele kokoba ↄb ɛsɛl e silɛl a eke nʼam dad ow ecʼodad ab ɛm, nʼam ↄl eke li kʼeb wɛl Jesu eci. ");
INSERT INTO adj_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Agŋ bɛb ów a ok es sos ɛm, kↄ likpr a ɛgŋm eke kʼub nawrɛ. ");
INSERT INTO adj_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ɛl ↄfr ɛm a nɛny okrm ɛl af, ɛtŋ -lʼigb -nʼaam. Pↄl dad ɛl odad na ninɛ: «Abŋ Lala ↄny low ij tasi lɛgŋ a eke nʼam dad ↄny lagŋɛl odad kokoba ↄb ɛs Esayi e nɛny ɛm lʼɛsɛ: ");
INSERT INTO adj_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","Ìm dad agŋ amua a: Ow bʼow ok ↄny ↄru ɛm sɛnyn sɛnyn, kↄ kʼow irimn; bʼow lɛɛr sɛnyn sɛnyn, kↄ kʼow ɛknmn. ");
INSERT INTO adj_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Tasi ɛm a, agŋ amua itŋn ɛw tuↄtuↄ; -li babl ↄru es, -li bubur anyamn, yecʼɛtŋ ke ɛl eci anyamn a kʼɛ́knm es, ɛl ecʼↄru a kʼírim ów, ɛl e nuŋ ɛm ↄny a kʼánm es, -lʼɛwlmn -lʼowmn ɛm ogŋ bake mʼéwlm ɛl.» ");
INSERT INTO adj_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Pↄl igŋ af dad ninɛ: «Sica úwr any eke Nyam eci sel ɛŋn ecʼodad a ow agŋ a ekʼelm Jwifɛl a eci: ɛl gbɛ, -li bʼow -lʼiri!»  ");
INSERT INTO adj_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Eke Pↄl dad ów amua a, Jwifɛl a ɛl ↄfr am atar ów es im lebl tuↄtuↄ ɛm. ");
INSERT INTO adj_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pↄl anŋ êl a eke lʼeb ab ɛm akpo yony. Li bʼeb agŋ a fɛŋ eke bʼow ɛknʼn a. ");
INSERT INTO adj_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Li bi dad Nyam eci es ɛw a ecʼodad ɛtŋ li bi yɛgm agŋ Ɛs Kↄtↄkↄ Jesu Krist owi ↄmn ɛm tasi, ɛtŋ ɛgŋ ɛdŋnmʼn.");
INSERT INTO adj_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Ɛm Pↄl Jesu Krist e juma kok ɛs, ɛm mʼam awŋ ↄny lɛl na. Nyam ɛsŋʼm eke mi kʼel ɛrm ɛs ɛtŋ lʼoc lʼɛwʼm saw eke mi kʼↄb in ecʼAmani Mamn a e kokoba. ");
INSERT INTO adj_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Amani Mamn na, Nyam ɛcr in e kokoba ↄb ɛsɛl ɛm ɛwar ow e low godʼɛtŋ in eci Silɛl lala ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","Amani Mamn a am dad Jim Jesu Krist ɛy Ɛs Kↄtↄkↄ ecʼodad. Yecʼekʼel in e mew ɛm ecʼa, wɛl ewʼr ɛb ebu David, lagŋ ecʼeb ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","Eke Abŋ Lala igbmʼn luw ɛm a, Nyam yɛgm eke lʼel Nyam ecʼIy ekʼↄny abusu fɛŋ. ");
INSERT INTO adj_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Jesu Krist kokʼm bibm mʼel ɛrm ɛs, yecʼɛtŋ ke in e nin a e sos usr sosiɛm a, mʼↄ́ŋ ɛbr ɛbr fɛŋ ecʼagŋ eke uwm Nyam any a, úbʼr nawrɛ ke ↄ́ny in ecʼɛlum. ");
INSERT INTO adj_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Ɔny yɛji, anŋn agŋ amua ɛm, eke Jesu Krist ɛsŋ ↄny a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Ɔny fɛŋ eke anŋn Rom a, ↄny eel Nyam ecʼɛrm erur ɛtŋ lʼɛsŋ ↄny eke kʼow anŋn in ecʼagŋ ab ɛm, ke íir ɛb in eci. Ke Nyam ɛy Ɛs lele Ɛs Kↄtↄkↄ Jesu Krist ab ɛ́dŋ ↄny ↄwrↄ ke ↄ́ŋ ↄny ɛrm es ɛy! ");
INSERT INTO adj_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Mʼam ikŋ anym mʼɛcr Jesu Krist ɛm mʼɛlu Nyam bia, ↄny fɛŋ eci, aŋke wɛl am dad ↄny ecʼↄmn a ecʼodad wus nimum af. ");
INSERT INTO adj_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Tasi ɛm a, eke mi bʼↄb Nyam Jim ecʼAmani Mamn a, ke Nyam eci juma anake mʼam kok ɛm ecʼɛrm fɛŋ ɛm a. Ɛtŋ in, lʼij ɛm e daŋku eke mʼↄ́pim ↄny ecʼↄkn ɛm e Nyam ŋↄŋn fɛŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mi bʼibrmʼn sɛgŋ fɛŋ eke li kʼↄŋʼm abusu mʼow ↄny ogŋ a, eke ow el in ecʼerur tasi, ");
INSERT INTO adj_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","aŋke ↄny ecʼɛkn am awʼm tasi yecʼɛtŋ ke mʼísm ↄny Abŋ Lala eci ob ap ab, ke ínymn es kikri. ");
INSERT INTO adj_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Nawrɛ tasi ɛm a, kʼaw ke mi bʼow mʼɛŋn ↄny a, ↄmn a eke ↄny lele ɛm ab sʼↄny a, ↄ́ŋ ke sʼátarir sos es. ");
INSERT INTO adj_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Agŋ lisijimɛl, mʼerur eke kʼuwr any eke sakp nↄnↄ mi tutr eke mi kʼow ↄny ogŋ yogŋ, kↄ toŋ sicaca ɛm a, mʼↄtum mʼɛŋnm ow ecʼabusu. Mʼam ↄmn eke ɛm e juma a, ↄny ogŋ yogŋ yɛji bʼow ↄsu ey amamn ɛsɛ ɛbr ɛjecʼɛm ecʼab af. ");
INSERT INTO adj_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Ow it eke mi ki kok agŋ fɛŋ e juma, Grɛkɛl lele Barbarɛl ab, agŋ ekʼuw low any lele agŋ eke uwm low any ab ab. ");
INSERT INTO adj_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Ow sosiɛm anake, ow am awʼm tasi eke mi kʼↄb ↄny Amani Mamn e kokoba, ↄny yɛji eke iir Rom a. ");
INSERT INTO adj_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Tasi ɛm a, Amani Mamn a ecʼↄb a ↄ́nym im ɛ́s, aŋke lʼel Nyam e lɛc ɛgŋ kaka fɛŋ ekʼub nawrɛ a e sↄg eci: krɛkrɛ ɛm a Jwifɛl, ke sica agŋ ekʼelm Jwifɛl a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Amani Mamn a bi yɛgm elel eke Nyam bʼocr agŋ nyim nyim in ecʼany af a: ow bʼↄb nuŋ ↄmn a eke -li bʼoc -lʼɛlu ow ɛm ab ɛm ɛtŋ ow bʼuwr ↄmn ab ɛm cɛ. Ɛɛ, Nyam Lɛl ɛm a wɛl bʼawl: Ɛgŋ yecʼekʼel nyim nyim Nyam ecʼany af a bʼow anŋ owr in ecʼↄmn a eke lʼoc lʼɛlu ow ɛm a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Afr kpekpe ɛtŋ Nyam am ɛlu in ɛcʼɛrm bebl a ↄkm aŋke agŋ el sikpl ɛsɛl ɛtŋ -li bi kok low ŋuŋ. Ɛl ecʼów eŋuŋ kok ab ɛm, -li bʼɛdŋn low nɛnyɛmbri nyam eke ki kok low. ");
INSERT INTO adj_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Ɛɛ, low eke wɛl ↄtu eke kʼuw any Nyam e lís a, ayl ɛl eci, aŋke Nyam in obi ayal ↄŋ ɛl. ");
INSERT INTO adj_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Nyam ecʼabusu a ekʼↄnym nuŋ a lele fɛŋ a eke in obi in obi a lʼel ab ab a, el ów nawrɛ eke wɛl ɛ́knm. Gbɛkↄ lɛgŋ a ɛtŋ eke wɛl kok wus a, ɛgŋ fɛŋ ↄtu eke kʼɛkn ɛl eke li bi lɛr ów a fɛŋ eke Nyam kok a. Ow sosiɛm a, agŋ ↄnym sos dogŋn eb kaka ij. ");
INSERT INTO adj_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Tasi ɛm a, -lʼuw Nyam any, kↄ -lʼusrm ow sos ɛtŋ -nʼↄↄm ow bia. Ke ow tasi ekʼow it eke wɛl ki kok Nyam ecʼana. Kↄ ɛl e sow tutr a itŋn el nyamb e sow tutr, ɛtŋ ɛl ecʼɛrm a eke low any uw anm ɛm a, irmn usuayl a. ");
INSERT INTO adj_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","-Li bʼocr ɛl sosi ɛsɛwru, kↄ -lʼel eŋ ɛm eŋuŋ ɛsɛl. ");
INSERT INTO adj_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Ow a eke -li kʼigŋ anygbɛl e Nyam a ekʼúwm a nuŋ a, -lʼigŋ ekŋ ekpr nuŋ. Ekŋ ekpr amua wɛl aku ɛl nʼanŋ ɛsɛ ɛgŋ eke bʼuw, oglog ↄr, oglog mindey ekʼɛli akr yar lele morŋn ab af. ");
INSERT INTO adj_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Ow sosiɛm a, Nyam ɛgb ɛl es -li kok ɛl ecʼɛrm ɛm ecʼów eke bʼaw ɛl a, ɛtŋ ɛbɛn a ɛl obi ɛm, -li bʼibar ɛl eci sos megl a ɛ́s ɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","-Nʼↄny Nyam e lís e low nawrɛ a -lʼitŋn ów yadŋ ɛm, yecʼa eke Nyam kok a -lʼigŋ ow nuŋ ɛtŋ -li kok ow e lís owi Kok Ɛs a ecʼusu a. Anygbɛl él in eci sɛgŋ fɛŋ! Amɛn! ");
INSERT INTO adj_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Na sosiɛm anake Nyam ɛgb ɛl es -lʼusr ów aw a eke bʼↄŋ ɛl ɛ́s a jam a. Ɛl ecʼↄyↄw a ɛ́ruam egŋ ab ij, kↄ ↄyↄw ɛjecʼab -li bʼɛru, ɛtŋ ow el low eke wɛl am kokm agŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Egŋ yɛji bi kok low nyam a cɛ. -Lʼɛruamn ↄyↄw ab ij, kↄ ɛl lawlɛl egŋ ecʼerur bʼaw ɛl. -Li bʼɛru ɛl egŋ ↄfr ɛtŋ ow el ɛ́s! Ow ↄŋ -li bʼɛŋn ɛl obi ɛm a es abur eke ɛl eci es an ŋuŋ a ism ab. ");
INSERT INTO adj_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Eke -lʼerurm eke -li kʼuw Nyam any a, Nyam ɛgb ɛl es -lʼus ɛl eci sow tutr yadŋ a jam, ɛtŋ -nʼam kok yecʼekʼitm eke wɛl ki kok a. ");
INSERT INTO adj_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Ów ɛnyɛmbri yony yony iy ɛl ɛm gbↄŋ. -Li bi kok low ŋuŋ, -li bʼerur ob ekʼel ɛl lawlɛl ecʼa, -lʼel agŋ eŋuŋ ɛtŋ nyamnɛyr iy ɛl ɛm gbↄŋ. -Li bʼibi agŋ, -li bʼatar ów es, -li bʼɛju ɛl lawlɛl ɛtŋ -li bi kok low mɛju ecʼabŋ ab. -Li bi dad ów eŋuŋ -lʼok agŋ af, ");
INSERT INTO adj_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","ɛtŋ -li bi cacak wɛl. -Lʼel Nyam ecʼefnu, -li bi wɛwr ɛl lawlɛl, es ɛfu iy ɛl ɛm, -li bʼij nɛny, ɛtŋ -li bʼɛcr akunda fɛŋ ɛm -li kok low ŋuŋ. -Lʼɛluamn agŋ a eke ew ɛl a. ");
INSERT INTO adj_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","-Lʼel anyambu, -lʼɛluamn ɛl eci nɛny eke -li bʼij a, ɛtŋ -lʼel agŋ eke ↄnym ɛrm lele sↄrŋ ikŋ ab. ");
INSERT INTO adj_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Ke -lʼuw Nyam eci jɛj ok ab any tasi cɛ. Agŋ a eke bi kok nɛnɛ a it eke kʼuw. Sica -li bi kok ów amua, kↄ ɛmɛny, -li bʼerur agŋ a eke bi kok a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Ow sosiɛm anake, ŋ eke bi jɛj awlŋɛl ecʼów ok a, ke él Jwif, ke kʼélm Jwif, ŋ ecʼa ↄnym sos dogŋn eb kaka, aŋke ŋ bi jɛj awlŋɛl ecʼów ok, kↄ bi kok ɛsɛ ɛl af! Na sosiɛm, eke bi jɛj ɛl ecʼów ok a, ow el ŋ sosi eke am ↄbr low. ");
INSERT INTO adj_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Ɛɛ, ɛy sʼuw any eke Nyam eci jɛj ok a el tasi agŋ eke bi kok nɛnɛ a e lís. ");
INSERT INTO adj_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ŋ bi jɛj agŋ a eke bi kok ów amua a ok, gbɛkↄ bi kok ɛsɛ ɛl af! Ŋ am ↄny ↄmn tasi eke Nyam eci jɛj ok a kʼow ↄbmʼŋ low ee? ");
INSERT INTO adj_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Nyam ↄny ɛrm mamn, li bʼɛgŋ low lʼeb, ɛtŋ li bʼeku low. Kↄ na anake erurm ab ee? Kↄ ŋ, uwm any eke Nyam ecʼɛrm mamn na am ↄŋ abusu eke kʼitŋn ŋ ecʼes an ab ee? ");
INSERT INTO adj_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Gbɛkↄ kʼerurm eke kʼiri, kʼerurm eke kʼitŋn. Na sosiɛm anake am eb ɛrm bebl ligbɛl ɛw es ŋ e lís ɛrm bebl e lɛgŋ a ecʼa. Lɛgŋ a, Nyam bʼow ɛlu ↄkm eke nɛnyɛmbri nyam ɛm li bi jɛj agŋ ecʼów lʼok. ");
INSERT INTO adj_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Ɛtŋ li bʼow nʼↄŋ ɛgŋ ɛgŋ ecʼów eke kok a e yecʼa ekʼit a. ");
INSERT INTO adj_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Agŋ bɛb bʼucu ↄny es kok low mamn, yecʼɛtŋ ke -nʼanŋ Nyam ecʼanygbɛl ab ɛm. -Li bʼↄl yɛjʼeke Nyam ki susm ɛl es, ɛtŋ -li bʼↄl owr anŋ a eke úwrm ab es. Agŋ amua, Nyam bʼow ↄŋ ɛl -nʼanŋ owr in ab sɛgŋ fɛŋ eci. ");
INSERT INTO adj_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Agŋ bɛb bʼↄbrʼr any, -lʼɛluamn low nɛnyɛmbri nyam kↄ -li bi yɛb low ŋuŋ am nyimn ɛl. Agŋ amua ecʼa, Nyam bʼow yɛgm ɛl in ecʼɛrm bebl ligbɛl a. ");
INSERT INTO adj_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","Gbre lele erŋn ab bʼow ↄny agŋ a fɛŋ eke bi kok low ŋuŋ a, ow bʼow ↄb nuŋ Jwifɛl ɛm, ke ow ɛ́ŋn agŋ ekʼelm Jwifɛl a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Sica Nyam ecʼanygbɛl a, es susm a lele ɛrm es ɛy ab ab, li bʼow nʼↄŋ agŋ a fɛŋ eke bi kok low mamn a, ow bʼow ↄb nuŋ Jwifɛl ɛm, ke ow ɛ́ŋn agŋ ekʼelm Jwifɛl a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","Tasi ɛm a, Nyam okm ereb agŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Agŋ a fɛŋ eke am kok sikpl ke úwm Mois e sol ab any a, bʼow uw eke -lʼuwm ol ab any yɛji. Gbɛkↄ agŋ a fɛŋ eke uw Mois ecʼol ab any ke ɛbɛn yɛji am kok sikpl a, ol a bʼow jɛj ɛl e low ok. ");
INSERT INTO adj_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Bwo ecʼɛgŋ Nyam bʼoc ɛsɛ ɛgŋ nyim nyim af in ecʼany af ee? Ow elm agŋ a eke bʼiri Mois ecʼol a nɛnɛ cɛ a. Njaŋ, kↄ agŋ eke bʼɛlum ol a. ");
INSERT INTO adj_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Agŋ a eke elm Jwifɛl a uwm Mois ecʼol ab any. Gbɛkↄ ɛl ɛm ecʼagŋ bɛb bi kok ɛsɛ elel eke ol a bi dad ab af. Agŋ amua -lʼuwm ol any, gbɛkↄ ow anŋ ɛsɛ ɛbɛn ol a cɛ wɛl yɛji wɛʼn uw any af. ");
INSERT INTO adj_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Aŋa ɛm a, -li bi yɛgm low nyam: ów a eke ol bi dad a nↄn ɛl ecʼɛrm ab ɛm, sow tutr eke -li bʼↄny ɛl obi ɛm a bʼɛlu ow e low ↄkm. Sakp oglog ɛl e sow tutr a bi dad eke -lʼuwm kok, ke sakp bɛb ecʼa wɛl dad eke -lʼuw kok. ");
INSERT INTO adj_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Ów amua fɛŋ eke mi dad a bʼow ok ↄkm kpata jɛj ok e lɛgŋ a, ɛsɛ elel eke Amani Mamn na eke mʼam ↄb a am dad ab af. Lɛgŋ a, Nyam bʼow ɛcr Jesu Krist ɛm jɛj fɛŋ a eke lↄl es agŋ ecʼɛb ir ɛm a e low ok. ");
INSERT INTO adj_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Ŋ eke bʼij en ɛsɛ in Jwif a, ol af anake bʼeb lɛc a ɛtŋ ntotŋ bʼokʼŋ ŋ e Nyam a eci. ");
INSERT INTO adj_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","Ŋ uw yecʼa eke li bʼerur ab any, ɛtŋ ol bʼɛlumʼŋ abu sↄsum yecʼa eke akpl a oc. ");
INSERT INTO adj_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","Ŋ bi tutr eke ↄtu eke ki nyimn ány eflu, ke él agŋ ekʼanŋ ncebn ɛm a ecʼusuayl, ");
INSERT INTO adj_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","agŋ ekʼuwm low any a lel ɛl ekʼɛw fuɛfuɛ ↄmn ɛm ab ab eci low yɛgm ɛs. Ɛɛ, ŋ bi tutr eke ol eke ↄny a ↄŋʼŋ ↄny low any uw lele low nɛnyɛmbri nyam tasi ab. ");
INSERT INTO adj_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","Eke ow el ɛbɛn, ŋ eke bi yɛgm awlŋɛl low a, ám yɛgmnmʼŋ sosi low! Ŋ bi dad eke ɛgŋ kʼiy mil, ke ŋ ám iy! ");
INSERT INTO adj_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ŋ bʼɛdŋn nfaci ij, ke ŋ ám ij. Ŋ bʼↄny sinyam yadŋ eci sifn, kↄ bʼiy ɛl e Sinyamel ab ɛm e simob a! ");
INSERT INTO adj_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ŋ ntotŋ bʼokʼŋ ol ekʼↄny a eci, gbɛkↄ ɛ́luam ol, ow bʼↄŋ ↄny Nyam ecʼany a oc es. ");
INSERT INTO adj_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Tasi ɛm, kin yecʼeke wɛl bʼawl Nyam Lɛl ɛm: ↄny sosiɛm, agŋ a eke elm Jwifɛl a bi yayr Nyam e nin a. ");
INSERT INTO adj_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Eke bi kok low yecʼa eke ol bi dad a, ke nawrɛ tasi likr es ubr el low akplu. Kↄ eke ɛ́luam ol, ɛtŋ ubr likr es bↄbↄ yɛji, anŋ ɛsɛ ɛgŋ eke ubrm es ab af. ");
INSERT INTO adj_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kin low nyam: ɛgŋ nyam ubrm likr es, gbɛkↄ li bʼɛlum Nyam ecʼol a. Kↄ Nyam kʼow ɛgŋm ebmʼn ɛsɛ likr cɛ owʼn ubr es af ee? ");
INSERT INTO adj_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Ɛgŋ ikŋ na ubrm sos megl af e likr es, gbɛkↄ li bʼɛlum ol. Eke ow el ɛbɛn a, in anake li bʼow li jɛj ŋ owi lʼok, ŋ eke ɛluam ol a. Ke ŋ nana ↄny ol a eke wɛl nↄn a lele likr es ubr ab! ");
INSERT INTO adj_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Tasi ɛm a, Jwif tasi a, elm ɛgŋ a eke bʼan es sos megl af ɛsɛ Jwif af a, ɛtŋ likr es ubr tasi a yɛji, elm sos lɛl a eke wɛl bʼubr es a. ");
INSERT INTO adj_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Kↄ Jwif tasi a, in lʼel ɛgŋ a eke el Jwif ɛrm ɛm a, ɛtŋ likr es ubr tasi a, el ɛrm ɛm ecʼa. Likr es ubr na, Nyam ecʼAbŋ ab ɛm li bʼanŋ lʼow, kↄ ow elm ol eke wɛl nↄn ab ɛm. Jwif tasi a ɛ́ŋnm in ecʼaw a agŋ ɛm, kↄ Nyam ɛm li bʼɛŋn. ");
INSERT INTO adj_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Eke ow el ɛbɛn, ke bla lowi Jwifɛl ↄny eke agŋ likpr a ↄnym ee? Ɛtŋ kↄ ob nyam anŋ eke wɛl bʼɛŋn likr es ubr ab ɛm ee? ");
INSERT INTO adj_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","Ɛɛ, wɛl bi lɛr ɛkn a, ob ligbɛl anŋ ɛm! Aŋke Jwifɛl anake Nyam ikŋ anym abul in e sodad ebl a. ");
INSERT INTO adj_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Kↄ sica, eke Jwifɛl bɛb ijm nɛny nyam, ke ow bʼow ɛdŋn Nyam eke kʼij nɛny nyam ee? ");
INSERT INTO adj_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Njaŋ ow kʼow elm ɛbɛn! Kin yecʼekʼit eke si kʼuw any: Nyam el nɛny nyam ɛs, kↄ agŋ a fɛŋ anake el ayadŋu a. Tasi ɛm a, Nyam Lɛl dad Nyam e lís ninɛ: Ow it eke wɛl kʼuwʼŋ any nyim nyim ŋ e sodad ebl ɛm. Ɛtŋ eke wɛl bi jɛj ŋ owi ok, ke ↄ́ny low ij jɛj ok ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Kↄ eke ɛgŋ nyam bi tutr eke low ŋuŋ eke sʼam kok a am ɛlum abu wɛl ɛkn eke Nyam el nɛny nyam ɛs, wɛl ↄtu eke ki dad ɛsɛ Nyam ijm nɛny nyam eke li bʼↄr ɛy in ecʼɛrm bebl ab ɛm ab ee? (Aŋa mʼam dad odad ɛsɛ ɛgŋ kaka fɛŋ af.) ");
INSERT INTO adj_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Njaŋ ow kʼow elm ɛbɛn! Tasi ɛm a, blel Nyam ijm nɛny nyam, ke ayaf lʼↄtu eke li ki jɛj wus e low lʼok ee? ");
INSERT INTO adj_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Ɛgŋ nyam ↄtu eke ki dadr in sosi ɛsɛ: eke ɛm eci yadŋ ab ɛm Nyam e low nɛnyɛmbri nyam a bʼɛy ↄkm kpata in ecʼanygbɛl a eci, ke sica bla sosiɛm ɛtŋ, ɛm, ɛmɛny mʼↄny es abur ɛsɛ sikpl ɛs af ee? ");
INSERT INTO adj_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ow otarir es eke wɛl ki dad ɛsɛ: «Si kók low ŋuŋ, yecʼɛtŋ ke low nimamn ánŋ ɛm ɛy ↄkm!» Agŋ bɛb bʼok ɛy ów af ɛtŋ bi dad ɛsɛ low na anake ɛs bi yɛgm a. Ow it eke agŋ amua na kʼɛŋn gbre. ");
INSERT INTO adj_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Sica ayaf sʼↄtu eke si ki dadr a? Kↄ ɛy Jwifɛl, sʼagb sʼakm agŋ likpr a fɛŋ ee? Njaŋ ow elm ɛbɛn! Mʼikŋ anym mʼɛlu low nyam ↄkm: Jwifɛl lele agŋ a fɛŋ eke elm Jwifɛl ab ab anŋ sikpl ecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Ɛtŋ kin yecʼeke Nyam Lɛl dad: Ɛgŋ kaka anm eke el nyim nyim, ɛgŋ nyamni bↄbↄ yɛji anm! ");
INSERT INTO adj_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","Ɛgŋ kaka ↄnym nuŋ ɛm, ɛgŋ kaka ↄ́lm Nyam es! ");
INSERT INTO adj_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Ɛl fɛŋ -nʼŋgboŋ ejagb mamn ab af, ɛtŋ -nʼuŋ ɛl fɛŋ. Ɛgŋ kaka am kokm low mamn, ɛgŋ nyamni bↄbↄ yɛji! ");
INSERT INTO adj_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Ɛl eci ɛmn geg a el uwↄmu eke anŋ foŋ; ɛl eci anm ab ɛm li bʼewl mɛju, ɛtŋ ɛl eci nɛnym lokm a, labŋ eci sar a anŋ. ");
INSERT INTO adj_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Ɛl e nɛny ab ɛm ofn e sodad lele sodad eke bi bubm ɛgŋ ew es ab iy gbↄŋ. ");
INSERT INTO adj_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Ɛgŋ ibi ecʼa, -li bʼuru es fafa -nʼim -lʼibi. ");
INSERT INTO adj_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","-Li bi ŋuŋn ob fɛŋ ɛl eci ejagb ab af ɛtŋ -li bʼewl gbre usu a fɛŋ. ");
INSERT INTO adj_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Ɛl, -lʼuwm ɛrm es ɛy eci ejagb ab any, ");
INSERT INTO adj_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ɛtŋ -lʼel agŋ eke ↄnym Nyam ecʼɛlum kaka. ");
INSERT INTO adj_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Gbɛkↄ sʼuw any eke low fɛŋ eke ol am dad a, ow el agŋ a eke kʼɛlum ol a nʼam dad. Ow sosiɛm ɛgŋ kaka kʼↄtum dogŋnm sos, kↄ wus nimum ɛy udu Nyam ecʼany af. ");
INSERT INTO adj_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Na sosiɛm anake ɛgŋ yecʼeke kʼɛlum Nyam ecʼol a e low fɛŋ ekʼanŋ ɛm a, ke ow sosiɛm Nyam ócʼr ɛsɛ ɛgŋ nyim nyim af in ecʼany af a, ɛgŋ kaka kʼanm eke kʼↄtu kok ɛbɛn a. Tasi ɛm a, ol, low nyam cɛ li bi kok: li bʼↄŋ agŋ abusu uw any eke -nʼↄny sikpl. ");
INSERT INTO adj_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Sica gbɛ, Nyam ɛlu elel eke li bʼↄŋ ɛy sʼel nyim nyim in ecʼany af ke ow élm ol eci ɛlum ɛm a ↄkm. Ɛtŋ Mois ecʼol a lele kokoba ↄb ɛsɛl ab yɛji dad ow e low. ");
INSERT INTO adj_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Nyam bʼↄŋ agŋ él nyim nyim in ecʼany af ɛl ecʼↄmn a eke -li bʼoc -lʼɛlu Jesu Krist ɛm a sosiɛm. Li bi kok low na nʼↄŋ agŋ a fɛŋ eke bʼↄny ↄmn Krist ɛm a, aŋke ɛl fɛŋ -lʼel kpɛŋ kpɛŋ: ");
INSERT INTO adj_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","ɛl fɛŋ -nʼↄny sikpl, ɛtŋ ɛgŋ kaka ↄ́tum kokm low sↄbↄ a eke Nyam am ibrm a iym nɛny. ");
INSERT INTO adj_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Gbɛkↄ Nyam in ecʼɛrm mamn ab ɛm, bʼɛcr Jesu Krist eke bi sↄg ɛl sikpl ecʼabu ɛm a, ↄŋ ɛl -lʼel nyim nyim ↄfr ɛm. ");
INSERT INTO adj_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","26","Nyam ikŋ anym bɛbm ɛw es eke Jesu kʼok in e mebl ab es egb waw ɛm. Ɛtŋ in ecʼegb waw ab ɛm, Jesu ɛŋn agŋ a ekʼↄny ↄmn in ɛm a e sikpl a ecʼoc ap. Nɛnɛ a, Nyam erur eke ki yɛgm elel eke lʼel nyim nyim sɛgŋ fɛŋ a: lɛgŋ sig ɛm a, lʼeku low ɛtŋ lʼɛwm low nʼↄↄm agŋ ɛl e sikpl a eci. Kↄ yɛfɛnyna ɛm a, Nyam am yɛgm elel eke li bʼↄŋ agŋ el nyim nyim in ecʼany af a. Tasi ɛm a, nʼam erur eke li kʼel nyim nyim ke nʼↄ́ŋ agŋ a ekʼↄny ↄmn Jesu ɛm a yɛji él nyim nyim. ");
INSERT INTO adj_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Sica, kↄ sʼↄny ów ɛjeci eke ow ɛm si kʼɛw sos ee? Njaŋ, ow anm ij! Bla sosiɛm ecʼee? Aŋke yecʼeke el ow tasi a, ow elm ol ecʼɛlum a, kↄ ke ↄ́ny ↄmn. ");
INSERT INTO adj_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Ɛɛ, kin ow eke sʼam tutr a: agŋ bʼel nyim nyim aŋke -li bʼↄny ↄmn, kↄ ow elm eke -li bi kok ol ecʼów a fɛŋ ekʼam ibrm a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Sica Nyam na, kↄ Jwifɛl sↄny cɛ eci Nyam lʼel ee? Kↄ lʼelm agŋ ɛjecʼa gbɛ e Nyam ee? Kaka! Lʼel ɛbr ɛjeci ecʼagŋ a yɛji e Nyam, ");
INSERT INTO adj_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","aŋke Nyam nyam coco cɛ anŋ. In anake li bʼow nʼↄŋ Jwifɛl eke wɛl bubr ekr es a, él nyim nyim ɛl ecʼↄmn a sosiɛm a, ɛtŋ ɛmɛny in cɛ anake li bʼow nʼↄŋ ɛbr ɛjeci ecʼagŋ a eke wɛl bubrm ekr es a yɛji él nyim nyim ɛl ecʼↄmn a sosiɛm a. ");
INSERT INTO adj_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Nɛnɛ a, eke si bʼↄny ↄmn, ke ol ob ↄfr ↄfr sʼam ↄŋʼn lʼel ab ee? Njaŋ, ow elm ɛbɛn! Kↄ ol ecʼany a nana anake sʼam ɛlu ↄkm tasi a. ");
INSERT INTO adj_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Sica bla lowi sʼↄtu eke si ki dad Abraham ɛy lagŋ eci lís ab ee? In obi e lɛc ɛm, bla obi lʼↄtu nʼɛŋn ee? ");
INSERT INTO adj_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Blel ow el in ecʼów eke li kok a sosiɛm Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af ana, lʼↄtu eke li kʼij nɛny, kↄ ow elm Nyam ecʼany af gbɛ. ");
INSERT INTO adj_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Tasi ɛm a, bla Nyam Lɛl dad ee? Abraham ↄny ↄmn Nyam ɛm, ow ↄŋ Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af in ecʼↄmn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Eke ɛgŋ bi kok juma a, wɛl bi sↄgʼr labm. Labm sↄg na elm ob ap, kↄ ob ekʼit eke wɛl kʼↄŋʼn. ");
INSERT INTO adj_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Sica, ɛgŋ nyam kí kokm juma kaka, ke nʼↄ́ny ↄmn Nyam eke bʼↄŋ sikpl ɛs él nyim nyim ab ɛm, ɛgŋ ikŋ na, Nyam bʼocʼr ɛsɛ ɛgŋ nyim nyim af, in ecʼↄmn a eke nʼↄny a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Na sosiɛm anake David am dad ɛgŋ a eke Nyam bʼoc ɛsɛ ɛgŋ nyim nyim af, ke ow élm in ecʼów kok sosiɛm a e low ɛsɛ: ");
INSERT INTO adj_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","Ehe ɛsɛl a el agŋ a eke Nyam ↄny ɛl ecʼów ↄbr oc es, ke tɛtŋ ɛl eci sikpl ab es a. ");
INSERT INTO adj_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Ehe el ɛgŋ a eke Nyam úsm in e low ↄbr e low jam a eci. ");
INSERT INTO adj_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Kↄ ehe na, Jwifɛl eke bi bubr ekr es a sↄny cɛ ecʼee? Agŋ ɛjecʼa eke am bubrm ekr es a ɛl gbɛ ow elm ɛl ecʼee? Mʼikŋ anym mi dad mʼɛsɛ: Abraham ↄny ↄmn Nyam ɛm, ow ↄŋ Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af in ecʼↄmn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ɛtŋ kↄ bogŋ e lɛgŋ ɛm Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af ee? Kↄ lɛgŋ ab ɛm eke lʼubr likr es a, oglog ow a eke li kʼubrm es ab ee? Njaŋ, ow elm lɛgŋ ab ɛm eke lʼubr likr es a, kↄ lɛgŋ ab ɛm eke li kʼubrm es a. ");
INSERT INTO adj_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Gbuŋ ke lʼúbr likr es a, ke Abraham el nyim nyim Nyam ecʼany af ŋ̂, in ecʼↄmn a eke lʼoc lʼɛlu ow ɛm a sosiɛm, ɛtŋ sica ow e jam a, nʼɛŋn likr a eke lʼubr es a eci mɛny ɛwr. Ɛtŋ mɛny ɛwr na bi yɛgm eke in ecʼↄmn a eke lʼoc lʼɛlu Nyam ɛm a sosiɛm ow ↄŋ ɛtŋ Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af. Nɛnɛ a ow ↄŋ Abraham el agŋ a fɛŋ ekʼↄny ↄmn Nyam ɛm a ecʼɛl ɛs, eke -lʼubrm likr es yɛji. Ɛtŋ agŋ amua ekʼubrm likr es a, Nyam bʼoc ɛl ɛsɛ agŋ nyim nyim af. ");
INSERT INTO adj_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Ɛtŋ Abraham cɛ, el Jwifɛl eke bubr ekr es a ecʼɛl ɛs. Aŋa mʼerur eke mi ki dad agŋ eke ɛl eci likr es ubr a elm sos af eci cɛ, kↄ ke ɛmɛny bʼucu ɛy ɛs Abraham eci sɛwl a ↄny es a e low: in, lʼikŋ anym lʼoc ↄmn lʼɛlu Nyam ɛm gbuŋ ɛtŋ lʼow lʼubr likr es. ");
INSERT INTO adj_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Nyam ɛwar Abraham lel in ecʼalaw a eke bʼow ok ↄkm in ɛm a, eke -li bʼow -lʼij wus aja. Gbɛkↄ low ɛwar na, ow elm eke Abraham ɛlum ol a sosiɛm Nyam dadm ɛwm es. Li dad aŋke lʼoc Abraham ɛsɛ ɛgŋ nyim nyim af ow ecʼↄmn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Sica eke aja a eci ij a el ke kók ol ecʼów a eke am ibrm a, ke ↄmn elm low kaka, ɛtŋ Nyam eci low a eke ɛwar a yɛji elm low ij. ");
INSERT INTO adj_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Tasi ɛm a, ol ecʼɛluam a bʼɛsŋ Nyam ecʼɛrm bebl, kↄ eke ol anm a, wɛl kʼↄtum ↄbm ol es. ");
INSERT INTO adj_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Ow sosiɛm a, ↄmn eke wɛl bʼoc ɛlu Nyam ɛm a anake bʼↄŋ ɛgŋ ij aja a, ɛtŋ ow el bibm eke wɛl bʼɛŋn ↄfr ɛm tasi. Na sosiɛm ob a eke Nyam ɛwar ɛw es a el agŋ a fɛŋ eke el Abraham ecʼalaw a eci. Ɛtŋ ow elm agŋ a eke bʼɛlum ol a sↄny, kↄ agŋ a ekʼↄny ↄmn Nyam ɛm ɛsɛ Abraham eke el ɛy fɛŋ eci ɛy ɛs af a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Ɛɛ, Nyam Lɛl dad ninɛ: Mi kokʼŋ el bieku nↄnↄ ecʼɛl lagŋ. Abraham el ɛy ɛs Nyam ecʼany af. Ow ɛm anake nʼↄny ↄmn a, Nyam a eke bʼↄŋ agŋ eke uw a igb anŋ owr, ke ↄny abusu eke ob ekʼanm wɛl ɛ́knm a, kok ow anŋ wɛl am ɛkn a. ");
INSERT INTO adj_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Low ↄmn kaka anm low a eke Nyam ɛwar a eci lís ij, gbɛkↄ ɛbɛn yɛji Abraham ↄmn cɛ. Lʼoc in ecʼↄmn a lʼɛlu Nyam ɛm ɛtŋ ow sosiɛm, lʼel bieku nↄnↄ ecʼɛl ɛs. Nyam Lɛl dad ninɛ: Agŋ eke bʼow anŋ ŋ ɛm ok ↄkm a bʼow ɛny nↄnↄ. ");
INSERT INTO adj_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Ɛtŋ eke ow anŋ akpo tɛl cɛ ke nʼↄny akpo ekŋ yen a yɛji, in ecʼↄmn a digrm kaka. Ɛtŋ lʼuw any yɛjʼeke in e sos megl a anŋ ɛsɛ ob eke uw af, ɛtŋ ɛy Sara yɛji kʼↄtum ewm iy ij. ");
INSERT INTO adj_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","Ɛbɛn yɛji, Abraham irmnm in ecʼↄmn a ɛtŋ bɛbarm kaka, Nyam e low ɛwar a e lís. Catŋ nana anake in ecʼↄmn a obn ke li kↄklm Nyam a. ");
INSERT INTO adj_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Lʼuw low nyam gbɛ any tasi: yecʼa eke Nyam ɛwar a, nʼↄny abusu nↄnↄ eke li ki kok. ");
INSERT INTO adj_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Na sosiɛm Nyam ocʼr ɛsɛ ɛgŋ nyim nyim af. ");
INSERT INTO adj_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Ba Nyam Lɛl bi dad ɛsɛ: Nyam oc Abraham ɛsɛ ɛgŋ nyim nyim af, ke sodad amua elm Abraham cɛ eci. ");
INSERT INTO adj_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","Kↄ ɛy yɛji ow ot ɛy es, ɛtŋ Nyam bʼow lɛr ɛy ecʼↄmn a. Tasi ɛm a, in eke lʼigbm ɛy Ɛs Kↄtↄkↄ Jesu luw ɛm a, in ɛm sʼↄny ↄmn. ");
INSERT INTO adj_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Ɛy e sikpl a sosiɛm Nyam ↄŋ wɛl ibi Jesu, gbɛkↄ Nyam igbmʼn luw ɛm yecʼɛtŋ ke sʼél agŋ nyim nyim. ");
INSERT INTO adj_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Nɛnɛ anake Nyam oc ɛy ɛsɛ agŋ nyim nyim af ɛy ecʼↄmn a sosiɛm a; ɛtŋ sica sʼanŋ ɛrm es ɛy ɛm in ab, ɛy Ɛs Kↄtↄkↄ Jesu Krist sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Jesu anake kok ke sʼↄtu sʼucu ↄmn ɛm, bibm eke sʼɛŋn a sʼↄny es a. Ɛtŋ sʼanŋ sos ɛm iŋn ɛm aŋke sʼam ↄmn eke si bʼow sʼanŋ Nyam ecʼanygbɛl ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Ow eke akpl tasi a el, si bʼanŋ sos ɛm iŋn ɛm eke ow el gbre sʼam ij yɛji. Ɛtŋ sʼuw any tasi eke gbre ij bʼↄŋ ɛgŋ ↄny ɛrm susu, ");
INSERT INTO adj_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","ɛtŋ ɛgŋ eke bʼↄny ɛrm susu a, li bʼij lɛc eke ses babur bʼanŋ yɛji. Ɛgŋ eke bʼij lɛc es abur ɛm a, li bʼↄny low ↄmn, ");
INSERT INTO adj_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","ɛtŋ low ↄmn na ɛ́jum ɛgŋ. Tasi ɛm a, Abŋ Lala ɛm Nyam ɛcr yibr ɛy e mɛrm a in ecʼerur a. ");
INSERT INTO adj_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Tasi, eke sʼanŋ ke sʼↄnym lɛc kaka sikpl ecʼany af a, yogŋ anake Krist ɛgŋ eb uw ów eŋuŋ ɛsɛl eci, lɛgŋ ab af eke Nyam bɛbm ɛw es a. ");
INSERT INTO adj_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Sʼuw any eke ow ɛw tuↄtuↄ eke ɛgŋ kʼɛgŋ eb uw ɛgŋ nyim nyim eci. Sica ów amamn kok ɛs ecʼa, kʼaw ke ɛgŋ átr sos es ɛgŋ eb uw. ");
INSERT INTO adj_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Gbɛkↄ kin elel eke Nyam yɛgm ɛy in ecʼerur eke nʼↄny ɛy ecʼa: nʼↄŋ Krist ow uw ɛy eci, lɛgŋ ab ɛm eke sʼel sikpl ɛsɛl a. ");
INSERT INTO adj_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Sica, eke in ecʼegb waw a ↄŋ ɛy sʼel agŋ nyim nyim, ow ayl tasi yɛjʼeke li bʼow li sↄg ɛy Nyam ecʼɛrm bebl a e lís. ");
INSERT INTO adj_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Ɛɛ, lɛgŋ ab ɛm eke sʼel Nyam ecʼefnu a, nʼↄny lʼokr ɛy ɛm in ab Jim eci luw ab ɛm. Sica eke nʼↄny lʼokr ɛy ɛm a, ow ayl tasi yɛji eke li bʼow li sↄg ɛy Jim eci sel ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Ɛtŋ ow elm na cɛ! Ɛy si bʼoc ɛy eci sos ɛm iŋn a sʼɛlu Nyam ɛm ɛy Ɛs Kↄtↄkↄ Jesu Krist sosiɛm, in eke sica nʼↄny lʼokr ɛy ɛm Nyam ab a. ");
INSERT INTO adj_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","Ɛgŋ nyam sosiɛm anake sikpl ow wus af aŋa a. Ɛgŋ a el Adam. Ɛtŋ sikpl ism luw ab. Ɛtŋ luw ɛbmn agŋ fɛŋ es, aŋke agŋ fɛŋ ↄny sikpl. ");
INSERT INTO adj_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Gbuŋ ke Nyam ↄ́ŋ Mois ol a, ke sikpl ikŋ anym anŋ wus na ŋ̂. Gbɛkↄ eke ol anm a, Nyam usm sikpl e low jam tasi. ");
INSERT INTO adj_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kↄ ɛbɛn yɛji, igŋ Adam e lɛgŋ ab ɛm toŋ Mois a, luw eb wus nimum ↄnym ab. Ɛtŋ agŋ eke kokm sikpl eke otarir es Adam ecʼa eke ɛgŋm ɛluam Nyam ecʼodad a yɛji, luw bʼibi ɛl. Adam anake el ɛgŋ a eke kʼow a eci any ↄkŋnin a. ");
INSERT INTO adj_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Gbɛkↄ ereb ligbɛl anŋ Nyam ecʼob ap ↄfr ɛm a lele Adam eci sikpl ab ab ecʼaraŋn. Ɛɛ, Adam, ɛgŋni nyam a eci sikpl a sosiɛm cɛ anake agŋ nↄnↄ gbɛl uw a. Gbɛkↄ Nyam ecʼob ap ↄfr ɛm a leg nↄnↄ ligbɛl. Ob ap na, Nyam ɛcr ɛgŋ nyam ɛm ɛluʼl ↄkm. Ɛgŋ a in lʼel Jesu Krist. Ɛtŋ ɛbɛn a, nʼↄmun in eci ów amamn ab es ↄfr ɛm agŋ nↄnↄ gbɛl af. ");
INSERT INTO adj_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Nyam ecʼob ap a bi kok low eke otarm es ɛgŋ nyam a eci sikpl a ecʼab ab. Tasi ɛm a, Adam ɛgŋni nyam a eci sikpl a e jam a, Nyam eci jɛj ok a el ke ɛgŋ fɛŋ úw. Gbɛkↄ, kin eke ɛl e sikpl nↄnↄ gbɛl a e jam a, Nyam ecʼob ap ↄfr ɛm a ↄŋ ɛl -lʼeel agŋ nyim nyim. ");
INSERT INTO adj_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Ɛɛ, ɛgŋ nyam cɛ kok sikpl ɛtŋ luw ibi agŋ fɛŋ ɛgŋ nyam a cɛ e sikpl a sosiɛm. Gbɛkↄ, Jesu Krist ɛgŋ nyam sosiɛm cɛ agŋ fɛŋ ɛl yɛji bʼɛŋn ów nↄnↄ Nyam e lís: -li bʼɛŋn Nyam ecʼɛrm mamn ligbɛl a, ɛtŋ ow eci ob ap ↄfr ɛm a bʼↄŋ ɛl -lʼel agŋ nyim nyim ow ecʼany af. Krist sosiɛm, -li bʼow -nʼanŋ owr ɛtŋ -li bʼow -lʼɛw es ow ab. ");
INSERT INTO adj_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Ow eke si ki dad sʼuwar a el, sʼam ɛkn eke ɛgŋ nyam cɛ eci sikpl a eke kok a anake is agŋ fɛŋ e luw a. Ɛbɛn cɛ, ɛgŋ nyam eci low nyim nyim e kok a, ↄŋ ɛtŋ Nyam oc agŋ fɛŋ ɛsɛ agŋ nyim nyim af in ecʼany af, ɛtŋ li bʼↄŋ wɛl sel. ");
INSERT INTO adj_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Lɛgŋ sig ɛm a, ɛgŋ nyam ɛgŋm eke kʼɛlum Nyam, ɛtŋ ow ↄŋ agŋ nↄnↄ gbɛl el sikpl ɛsɛl. Ɛbɛn cɛ, ɛgŋ nyam eke ɛlum Nyam a sosiɛm, agŋ nↄnↄ gbɛl el nyim nyim Nyam ecʼany af. ");
INSERT INTO adj_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Sica ol ow, ɛtŋ sikpl ɛny eb es nↄnↄ ligbɛl. Gbɛkↄ yogŋ a eke sikpl ɛny eb es a, Nyam eci sↄrŋ ikŋ a bʼɛny bubu af. ");
INSERT INTO adj_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Lɛgŋ sig ɛm a, sikpl ↄny abusu fɛŋ eke kʼↄŋ agŋ uw. Ɛbɛn lɛgŋ na ɛm, Nyam eci sↄrŋ ikŋ a ↄny abusu fɛŋ eke kʼↄŋ agŋ el nyim nyim Nyam ecʼany af. Ɛtŋ ɛbɛn a, sʼↄtu eke si kʼɛŋn sel ekʼↄnym uwr Nyam ab, ɛy Ɛs Kↄtↄkↄ Jesu Krist sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Sica ayaf si ki dadr ab ee? Kↄ sikpl ow it eke abu kʼanŋ ɛy ɛm sʼam kok yecʼɛtŋ ke Nyam e sↄrŋ ikŋ a ám ɛny bobn ee? ");
INSERT INTO adj_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Njaŋ, ow elm ɛbɛn! Ɛy sʼɛcr luw eke ↄny kpab ɛy es sikpl e lís ab ɛm. Ayaf ɛmɛny sʼↄtu eke si kʼir sikpl ecʼɛb ee? ");
INSERT INTO adj_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ɔny uwr any tasi eke: eke wɛl ok ɛy mij nuŋ Jesu Krist e nin ɛm a, yogŋ ɛtŋ sʼokr af in e luw ab ab. ");
INSERT INTO adj_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Ow sosiɛm, eke wɛl ok ɛy mij nuŋ a, sʼuw ɛtŋ wɛl oc ɛy es in ab. Gbɛkↄ, Nyam ecʼanygbɛl ecʼabusu ligbɛl a igbm Krist agŋ ekʼuw ab ɛm, yecʼɛtŋ ke ɛy yɛji, sʼↄ́ny ɛb ir owr. ");
INSERT INTO adj_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Tasi ɛm a, sʼokr af nimum in ab lɛgŋ a eke sʼuw in ab a. Ɛbɛn cɛ, si bʼow sʼokr af in ab lɛgŋ a eke ɛy yɛji si bʼow sʼigb luw ɛm ɛsɛ elel eke lʼigb ab af a. ");
INSERT INTO adj_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Sʼírir low na sɛnyn sɛnyn: ɛy ecʼelel eke sʼanŋn anym ɛm a, wɛl oc lele Krist ab ↄbm olikŋ. Ow ↄŋ, sikpl a eke anŋ ɛy ɛm a uŋ, ɛtŋ sʼelm in eci madu ij. ");
INSERT INTO adj_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","Ɛɛ, ɛgŋ eke uw a anm sikpl e low ɛm ij. ");
INSERT INTO adj_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Eke sica sʼuw Krist ab a, sʼub nawrɛ eke ow el in ab si bʼow sʼanŋ owr. ");
INSERT INTO adj_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Sʼuw any tasi eke lɛgŋ a ɛtŋ eke Krist igb agŋ ekʼuw ab ɛm a, li kʼow lʼuwm ij, ɛtŋ luw ↄnym abusu kaka in af. ");
INSERT INTO adj_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Krist uw, ɛtŋ in e luw a ↄny kpabʼr es sikpl e lís nimum nimum, akp nyam sɛgŋ fɛŋ eci. Sica nʼanŋ owr, ɛtŋ in ecʼowr anŋ a nimum el Nyam eci. ");
INSERT INTO adj_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Ɔny yɛji, ocar ↄny sosi ɛsɛ agŋ eke sikpl ecʼabusu a ɛwm es ij, ke Jesu Krist ab ecʼaf okr ab ɛm am ir ɛb Nyam ecʼaf. ");
INSERT INTO adj_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Ɔny, sikpl ↄtum eke kʼↄny abusu ↄny af ij. Ɔny eci sos megl a bʼow uw lɛgŋ nyam. Ow sosiɛm, ow itm eke kʼɛlumn in ecʼów eŋuŋ a eke bʼawʼr a ij. ");
INSERT INTO adj_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Kʼòcr ↄny eci sos a eci susu susu a kʼɛwr es sikpl eci, ɛsɛ ejagb eke ɛru es low ŋuŋ kok ecʼaf. Kↄ nana, òcr ↄny nimum kokr Nyam e low, ɛsɛ agŋ ekʼanŋ luw ɛm igb anŋ owr af. Òcr ↄny eci sos a eci susu susu a ɛwr es ɛsɛ ejagb eke ɛru es low nyim nyim e kok ecʼaf. ");
INSERT INTO adj_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Sica eke ow elm ol ɛwm ↄny es ij, ke ow el Nyam eci sↄrŋ ikŋ ab anake ɛw ↄny es a, sikpl kʼↄtum ↄnym abusu ↄny af ij. ");
INSERT INTO adj_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Nawrɛ, ɛy ow elm ol ɛwm ɛy es ij, kↄ Nyam eci sↄrŋ ikŋ a ɛw ɛy es. Ow sosiɛm a, kↄ abusu ɛ́ru ɛy es eke si ki kok sikpl ab ee? Njaŋ, ow elm ɛbɛn! ");
INSERT INTO adj_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ɔny uwr any tasi eke, eke bʼɛgŋn ebr am kokr ɛgŋ eci juma ɛsɛ madu af a, ↄny eel ɛgŋ a eke am ɛlumn a eci madu. Ow sosiɛm a, oglog ↄny eel sikpl e madu, ke sikpl óc im ɛlu ↄny luw ɛm, oglog ↄny eel Nyam e madu, ke ↄ́nyn ɛb ir nyim nyim in ecʼany af, aŋke bʼↄnyn in ecʼɛlum. ");
INSERT INTO adj_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Sʼↄ́ŋ Nyam bia! Lɛgŋ sig ɛm a, ↄny eel sikpl eci madu. Jam aŋa ɛm a, ↄny ɛgŋn ebr eke kʼɛlumn ↄny ecʼɛrm fɛŋ ɛm, Amani Mamn a eke wɛl babul agŋ fɛŋ a. ");
INSERT INTO adj_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Ɔny dogŋnin sos ebr sikpl ecʼabu ɛm ɛtŋ am kokr low nyim nyim eci juma. ");
INSERT INTO adj_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mʼam oc agŋ ɛm e low mi bɛbmn aŋke ↄny eci low iri a bʼↄtu nↄnↄ. Lɛgŋ sig ɛm a, ɛsɛ madu af, ↄny ocr ↄny eci sos megl a ɛwr es ɛb ir eke el sikpl lele suksuk ab eci, ɛtŋ ow eci low ekʼanŋ ɛm ɛy ↄkm a, el Nyam eci any ↄbr. Ɛbɛn, yɛfɛnyna yɛji ɛsɛ madu af, òcr ↄny eci sos megl a ɛwr es ɛb ir eke el low nyim nyim eci, ɛtŋ ow eci low eke bʼow anŋ ɛm ɛy ↄkm a, bʼow el ɛb ir lala eke bʼakpl Nyam sos ɛm. ");
INSERT INTO adj_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Ow a eke eel sikpl eci madu a, low nyim nyim eci kok a áwm ↄny. ");
INSERT INTO adj_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Ow e lɛgŋ ab af a, bogŋ ecʼey ↄsur ee? Yɛfɛnyna, ow am ↄny ↄny ɛ́s, aŋke ow eci ey eke ow ↄsu a el luw. ");
INSERT INTO adj_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Sica jam aŋa, wɛl sↄg ↄny sikpl e lís ɛtŋ ɛwal eel Nyam eci madu. Na sosiɛm am ir ɛb eke bʼakpl Nyam sos ɛm, ɛtŋ ow eci low ekʼanŋ ɛm ɛy ↄkm a, el Nyam ab ecʼɛb ir sɛgŋ fɛŋ a. ");
INSERT INTO adj_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Nawrɛ, aŋke sikpl eci labm sↄg ekʼanŋ ɛm a el luw; kↄ Nyam eci ob ap a el sel a ekʼↄnym uwr, ke li bʼↄŋ ɛy, ɛy Ɛs Kↄtↄkↄ Jesu Krist ab ecʼaf okr ab ɛm a. ");
INSERT INTO adj_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Agŋ lisijimɛl, ɛm mʼuw any eke ow el agŋ eke uw Nyam ecʼol ab any a, mʼam dad odad. Ol ↄny abusu ɛy af eke sʼanŋ owr a cɛ. Ɛtŋ ow el low eke uwr any tasi. ");
INSERT INTO adj_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Kin low ɛbmn nyam: ol ɛm a, yↄw eke ɛbi igŋ a okr af in ecʼigŋ ab ab eke igŋ a anŋ owr a. Kↄ eke igŋ a bʼuw a, yↄw a sos bʼok es ol a ekʼↄny okrʼr af ɛc ab a e lís. ");
INSERT INTO adj_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Lɛgŋ ab ɛm eke ɛc anŋ owr a, eke nʼim lʼɛbi igŋ ɛjeci, ke nfaci lʼij a. Kↄ eke ɛc uw a, ol ɛm a abusu ɛruʼr es; lʼↄtu eke li kʼɛbi igŋ ɛjeci gↄŋ, li kʼow lʼelm facyↄw. ");
INSERT INTO adj_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","Ɛm lisijimɛl, ↄny ecʼa yɛji ɛbɛn cɛ. Ɔny okar af Krist eke uw ɛy sosiɛm olikŋ af ab ab; ow sosiɛm, ↄny kpabr es nimum Mois ecʼol a e lís. Sica eel ɛgŋ ɛjeci nyam eci; ɛgŋ ɛjecʼa, in lʼel ɛgŋ a ekʼigb luw ɛm a. Ɛtŋ ɛbɛn ɛm a sʼↄtu eke ɛy fɛŋ si kʼↄsu ey Nyam e juma kok ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Ɛɛ, lɛgŋ sig ɛm a, eke sʼam kok ów eke bʼakpl ɛy sos ɛm a, Mois ecʼol a ecʼów a tasi eke bi dɛdŋn a bʼitr ów aw eŋuŋ a eke ki kok low ɛy e sos ab ɛm, ɛtŋ ow e low ekʼanŋ ɛm ɛy ↄkm a, el luw. ");
INSERT INTO adj_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Gbɛkↄ sica, si kpab es nimum nimum Mois ecʼol a eke ↄny awŋ ɛy es a e lís; sʼↄtu eke sica si ki kok Nyam e low a sɛwl owr ɛm, sʼám ɛlum Abŋ Lala, ke si kí kokm Nyam e low a ɛsɛ lɛgŋ sig ɛm ecʼa eke sʼanŋ ol a eke wɛl nↄn a eci es ɛw ɛm ab af. ");
INSERT INTO adj_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Sica ayaf si ki dadr ab ee? Kↄ Mois ecʼol na, sikpl eci juma nʼam kok ee? Njaŋ, ow elm ɛbɛn! Gbɛkↄ ol anake ↄŋ mʼuw sikpl any a. Tasi ɛm a, blel ol dadm ɛsmɛ: Kʼow ocm nyamnɛyr ɛm erurm awlŋ ecʼob, blel mi kʼuwm any eke ow el low ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Gbɛkↄ sikpl ɛcr ol na ɛm ɛtŋ ↄsu ɛm ɛm ów aw eŋuŋ ↄrŋ ↄrŋ a fɛŋ, aŋke blel ol anm ana, sikpl blel ↄnym abusu kaka. ");
INSERT INTO adj_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","Lɛgŋ sig ɛm a, eke mʼuwm ol any a, mʼel ɛgŋ ekʼanŋ owr. Kↄ sica eke mʼuw ol any a, sikpl anake ɛwl mɛny anŋ owr a, ");
INSERT INTO adj_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","ɛtŋ ɛm, mʼel ɛgŋ eke uw. Ɛtŋ ol a eke ki nyimnʼm mʼanŋ owr a, nyimnʼm luw ɛm. ");
INSERT INTO adj_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Ɛɛ, sikpl ɛcr ol ɛm ɛluʼm wus ɛtŋ ɛbɛn a, nʼↄŋʼm mʼuw. ");
INSERT INTO adj_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Gbɛkↄ ol, in obi a lʼel lala, ɛtŋ ów ey nyam nyam eke anŋʼn ɛm a yɛji el lala, nyim nyim lele nimamn ab. ");
INSERT INTO adj_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Sica eke ow el ɛbɛn, ke ob mamn ↄtu eke kʼismʼm luw ab ee? Njaŋ, ow elm ɛbɛn! Gbɛkↄ sikpl ɛcr ob mamn ɛm ↄŋʼm luw. Nɛnɛ anake ol ↄŋ wɛl ɛkn elel eke sikpl e lɛc a el ob ŋuŋ kↄ kↄ kↄ a. ");
INSERT INTO adj_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Ɛɛ, ɛy sʼuw any eke ol, Nyam ogŋ ow anŋ ow, gbɛkↄ ɛm, mʼel ɛgŋ fuɛfuɛ eke wɛl ↄl ij ɛsɛ adu af sikpl ogŋ. ");
INSERT INTO adj_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Nawrɛ tasi, yecʼa eke mʼam kok a mi kʼirim, aŋke yecʼa eke mʼam erur a, mi kókm, ɛtŋ mi bi kok yecʼa eke mʼérurm a. ");
INSERT INTO adj_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Eke mi bi kok yecʼa eke mʼérurm a, mi bʼɛgŋ mʼeb eke ol el ob mamn. ");
INSERT INTO adj_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Sica mʼuw any eke ow elm ɛm mi kókm ɛbɛn, kↄ sikpl a eke ir ɛm ɛm a anake bʼitrʼm mi kok ɛbɛn a. ");
INSERT INTO adj_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Ɛɛ, mʼuw any eke low mamn irm ɛm ɛm, ɛm e sos ↄnym ab ɛm. Ɛm ecʼa, mi bʼerur eke mi ki kok ów eke akpl a, kↄ mʼↄ́tum mi kokm. ");
INSERT INTO adj_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Tasi ɛm a, low nimamn eke mi bʼerur a, mʼↄ́tum mi kokm, ɛtŋ low ŋuŋ eke mʼérurm a, mi bi kok. ");
INSERT INTO adj_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Sica, eke mi bi kok low eke mʼérurm a, ke ow elm ɛm mi kokm ɛbɛn, kↄ sikpl a eke ir ɛm ɛm a anake bʼitrʼm mi kok ɛbɛn a. ");
INSERT INTO adj_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Ɛtŋ kin ol ɛjeci nyam eke mʼuyum ab: eke mi bʼerur eke mi ki kok low mamn a, ke low ŋuŋ kpɛkŋ inymʼm es any af. ");
INSERT INTO adj_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Ɛm ecʼɛrm ab ɛm, mi bʼerur Nyam ecʼol a. ");
INSERT INTO adj_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Gbɛkↄ ɛm obi ɛm a, mi bʼuyum ol ɛjeci nyam ab, eke bʼatarir Nyam ecʼol a eke in ab nɛny okr ɛy af ab ab. Ɛtŋ ol na, in lʼel sikpl ecʼol a eke bi kok juma ɛm ɛm, ke bʼↄnyʼm ɛsɛ in eci sobel ɛm ɛs af a. ");
INSERT INTO adj_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Kin eke mʼel gbre ecʼɛgŋ! Bwo ecʼɛgŋ bʼow sↄgʼm sos megl na eke bʼoc im ɛluʼm luw ɛm a e lís ee? ");
INSERT INTO adj_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Sʼɛ́lu Nyam bia, aŋke Jesu Krist ɛy Ɛs Kↄtↄkↄ sↄgʼm! Ɛtŋ ɛbɛn a, ɛm eci tutr ab ɛm, mi bʼɛgŋ Nyam ecʼol a mʼeb, gbɛkↄ ɛm eci sos ↄnym ɛm a, mi bʼɛlum sikpl ecʼol a. ");
INSERT INTO adj_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Sica low ↄb kaka anm agŋ a eke okr af Jesu Krist ab a eci ij. ");
INSERT INTO adj_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Nawrɛ tasi, eke wɛl okr af Jesu Krist ab a, ke Abŋ Lala ecʼol a anake bʼↄŋ ɛgŋ sel a, ɛtŋ ol na sↄgʼm sikpl ecʼol a eke bʼↄŋ ɛgŋ luw a ecʼabu ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Mois ecʼol a ↄtum eke ki kok ɛbɛn, aŋke agŋ eci sos ↄnym a ↄↄmʼn ow e kok ecʼabusu. Gbɛkↄ Nyam ↄtu kok: lʼɛrm Jim ɛli sos eke otarir es sikpl ɛsɛl ecʼab ab ow sↄg ɛl sikpl ecʼabu ɛm. Ɛtŋ nɛnɛ a, Nyam ↄŋ sikpl a eke am kok juma agŋ e sos ɛm a abur es. ");
INSERT INTO adj_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","Li kok nɛnɛ, yecʼɛtŋ ke sʼↄ́ny abusu sʼir ɛb nyim nyim a eke ol am ibrm a. Sica, ow elm elel eke agŋ bʼir ɛb a sʼirm ij, kↄ ɛsɛ elel eke Abŋ Lala bʼerur ab af. ");
INSERT INTO adj_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Tasi ɛm a, agŋ a eke bʼir ɛb ɛsɛ elel eke -nʼam ɛkan ab af a, bʼɛlum ɛl ecʼów eke bʼakpl ɛl sos ɛm a, gbɛkↄ agŋ eke bʼir ɛb ɛsɛ elel eke Abŋ Lala bʼerur ab af a, bʼɛlum yecʼa eke Abŋ Lala bʼerur a. ");
INSERT INTO adj_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Ɛgŋ eke bʼus ów eke li bʼerur a jam a, li bʼim luw ɛm, kↄ eke li bʼus Abŋ Lala jam a, li bʼim sel eke ↄnym uwr lele ɛrm es ɛy ab ogŋ. ");
INSERT INTO adj_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Tasi, ɛgŋ ecʼów eke bʼerur a ókrm af Nyam ecʼab ab, -lʼɛluamn Nyam ecʼol a. Ɛl ecʼa, ow el low eke -li kʼↄtumn -li kokmn. ");
INSERT INTO adj_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Ɛtŋ agŋ a eke bʼus ów aw amua jam a, e low kʼↄtum akplm Nyam sos ɛm ij. ");
INSERT INTO adj_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Gbɛkↄ ↄny ecʼa, írmn ɛb ɛsɛ elel eke bʼerurir ab af, kↄ ɛsɛ Abŋ Lala ecʼelel eke bʼerur ab af, aŋke Nyam ecʼAbŋ a anŋ ↄny ecʼɛrm ab ɛm. Eke Krist ecʼAbŋ a anm ɛgŋ ɛm, ɛgŋ ikŋ a, lʼelm Krist eci. ");
INSERT INTO adj_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Nawrɛ eke ↄny e sos megl a bʼow uw sikpl sosiɛm, gbɛkↄ eke Krist anŋ ↄny ɛm a, Abŋ Lala bʼow ↄŋ ↄny sel, aŋke Nyam oc ↄny ɛsɛ agŋ nyim nyim af. ");
INSERT INTO adj_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Nyam igbm Jesu luw ɛm. Eke in ecʼAbŋ a anŋ ↄny ɛm, in a cɛ eke lʼigbm Jesu agŋ ekʼuw ab ɛm a, li bʼow lʼɛcr Abŋ Lala ɛm nʼↄŋ ↄny e sos megl a eke bʼow uw a bↄbↄ yɛji sel. ");
INSERT INTO adj_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Na sosiɛm agŋ lisijimɛl, sʼↄny labm. Gbɛkↄ ow elm ɛy ecʼów a eke bʼaw ɛy a e labm sʼↄnym. Ow sosiɛm, ow itm eke si kʼir ɛb eke ɛy ecʼów aw a bʼerur a. ");
INSERT INTO adj_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Eke am iir ɛb ów a eke bʼaw ↄny ke bʼerurir a e kok eci, bʼow uwr; kↄ eke Abŋ Lala ecʼabu ɛlum ɛm waal ↄny e sos megl ecʼów a e bʼerur e ki kok a ɛlul es a, bʼow anŋn owr. ");
INSERT INTO adj_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Nawrɛ ɛm a, agŋ a fɛŋ eke Nyam ecʼAbŋ a bi nyimn a, el Nyam ecʼey. ");
INSERT INTO adj_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Ɛtŋ Abŋ a eke ɛŋan a, ↄ́ↄm ↄny elmn madu eke ɛmɛny am uru Nyam, kↄ li bʼↄŋ ↄny eel Nyam ecʼey. Ɛtŋ Abŋ na eci abu ɛlum ɛm, si bʼɛlu Nyam lebl si dad sʼɛsɛ: «Aba! Ɛs!» ");
INSERT INTO adj_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Abŋ Lala in obi bʼij daŋku dad ɛy ecʼabŋ a eke sʼel Nyam ecʼey. ");
INSERT INTO adj_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Ow sosiɛm, eke sʼel Nyam ecʼey a, si bʼow sʼij aja a eke Nyam bɛbm ɛw in ecʼagŋ es a, ɛtŋ aja na, Krist ab si bʼow sʼij. Ɛɛ, eke sʼanŋ in e gbre ij a e low ɛm, si bʼow sʼanŋ in ecʼanygbɛl a yɛji e low ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Ayaf sʼↄtu eke si kʼoc yɛfɛnyna e gbre a si bɛbmn lɛgŋ ekʼam ow ab ɛm eci anygbɛl a eke Nyam bʼow yɛgm ɛy kpata ab ab ee? Ɛm e sos ɛm a, yɛfɛnyna e gbre a elm low kaka. ");
INSERT INTO adj_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Am ɛkan eke wus nimum a eke Nyam kok a am eku lɛgŋ a eke Nyam bʼow ɛlu in ecʼey ecʼanygbɛl ↄkm a. ");
INSERT INTO adj_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Mob amua fɛŋ eke Nyam kok a, itŋn el mob ↄfr ↄfr. Ow elm mob a eke Nyam kok a erurm ɛbɛn, kↄ Nyam anake ↄŋ ɛl -nʼanŋn nɛnɛ a. Gbɛkↄ wus nimum a eke Nyam kok a ↄtu eke ɛmɛny kʼↄmn low. ");
INSERT INTO adj_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Ɛtŋ ɛsɛ elel eke adu bʼŋgboŋ adu el ɛm a, mob mob a fɛŋ eke Nyam kok a bʼow ŋgboŋ ɛl e mob ekʼam ugŋn ɛl es ab ɛm. Ɛtŋ -li bʼow -nʼanŋ Nyam ecʼey a e lewi ij a lele anygbɛl ab ab e low ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Sʼuw any tasi eke mob mob a fɛŋ eke Nyam kok a am ikŋ sↄmu ɛtŋ ɛmɛny am ij gbre caca ɛm a, ɛsɛ yↄw eke bʼew iy ab af, ");
INSERT INTO adj_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","gbɛkↄ ow elm ɛl sↄny cɛ. Ɛy obi yɛji, sʼam ikŋ sↄmu ɛy e mɛrm ab ɛm, ɛtŋ sʼam eku eke Nyam kʼeb ɛy ɛsɛ in ecʼey tasi af, ke sʼél ewi kpɛkŋ kpɛkŋ. Gbɛkↄ sʼikŋ anym sʼɛŋn Abŋ Lala, ɛsɛ ob ap a eke Nyam ɛwar ɛw es ab ɛm eci krɛkrɛ af. ");
INSERT INTO adj_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Tasi ɛm a, sʼɛŋn sel, kↄ ow el low ↄmn ɛm cɛ. Eke wɛl bʼɛkn ob eke wɛl am ↄmn a, ke wɛl úbmʼn ɛsɛ low ↄmn ob af ij. Ob eke wɛl am ɛkn a, kↄ wɛl ↄtu eke ɛmɛny wɛl kʼↄmnʼn ee? ");
INSERT INTO adj_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Gbɛkↄ eke sʼam ↄmn ob eke sʼɛknm a, si bʼanŋ ow eci eku ɛm ɛrm susu ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","Ɛtŋ ɛmɛny, ɛy eke sʼↄnym sos a, Abŋ Lala bʼɛlum ɛy abu. Sʼúwm any si ŋↄŋnm Nyam ɛsɛ elel eke ow it ab af. Ow bʼↄŋ Abŋ Lala in obi bi ŋↄŋn Nyam ɛy usu iy, íbrm ów sↄmu ikŋ ebl ɛm eke ɛgŋ e nɛny kʼↄtum dadm. ");
INSERT INTO adj_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Gbɛkↄ Nyam eke bʼɛkn mɛrm lokm a, bʼuw yecʼeke Abŋ Lala erur eke kʼibrm ab any. Ɛɛ, Abŋ Lala bi ŋↄŋn Nyam ɛsɛ elel eke Nyam bʼerur ab af ↄŋ agŋ a eke el Nyam ecʼa. ");
INSERT INTO adj_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Ɛmɛny sʼuw any eke agŋ a ekʼↄny Nyam ecʼerur ecʼa, low fɛŋ eke bʼɛŋn ɛy a, Nyam anake bi kok a, yecʼɛtŋ ke ow ɛ́lum ɛy abu sʼɛŋn low nimamn. Ow el agŋ a eke lʼikŋ anym li bɛbm wɛl ecʼɛsŋ e low lʼɛw es a. ");
INSERT INTO adj_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Tasi ɛm a, agŋ amua eke Nyam ikŋ anym sↄsum ot ecʼa, lʼikŋ anym li bɛbm yɛji eke li ki kok wɛl, wɛl ot in ecʼIy ab es, ke ow ↄ́ŋ in ecʼIy a el bosu ligbɛl a e liy likpekp. ");
INSERT INTO adj_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Sica agŋ a eke Nyam ikŋ anym sↄsum ot a, lʼɛsŋ wɛl yɛji. Agŋ a eke lʼɛsŋ a, lʼot wɛl ɛsɛ agŋ nyim nyim af, ɛtŋ agŋ a eke lʼot ɛsɛ agŋ nyim nyim af a, lʼot lʼok wɛl in ecʼanygbɛl a yɛji ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Bla odad iy si ki dad sʼigŋ af ee? Eke Nyam anŋ ɛy ecʼogog, ke bwo ↄtu eke ki kok ɛy low ŋuŋ ee? ");
INSERT INTO adj_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","In eke lʼɛdŋnm in ecʼIy lokm a abu any, ke nʼↄŋ ow uw ɛy fɛŋ e sel ɛŋn sosiɛm ecʼa, ayaf eke sʼokr af ow ab, li kʼow nʼↄↄm ɛy ↄfr ɛm, ów amamn fɛŋ ee? ");
INSERT INTO adj_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Bwo ecʼɛgŋ ↄtu eke kʼok agŋ a eke Nyam sↄsum ot a ów af ee? Ɛgŋ kaka anm! Aŋke Nyam in obi ot ɛl ɛsɛ agŋ nyim nyim af. ");
INSERT INTO adj_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Bwo ecʼɛgŋ ↄtu eke kʼↄb agŋ low luw ecʼee? Ɛgŋ kaka anm! Tasi ɛm a, Jesu Krist uw, gbɛkↄ nʼanŋ luw ɛm lʼigb, nʼanŋ Nyam e lidr abu af a ɛtŋ nʼam ŋↄŋn Nyam ɛy eci. ");
INSERT INTO adj_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Bla obi ↄtu eke kʼↄny kpab ɛy es Krist ecʼerur ekʼↄny ɛy ecʼa e lís ee? Kↄ es abur oglog ɛrmij ebr ee? Kↄ agŋ eci milↄlu e bʼↄnyn ɛy ɛy ecʼↄmn a sosiɛm ab ee? Kↄ namn oglog gbↄr ee? Kↄ low ɛyr eke bʼokr ɛy es a oglog luw ee? ");
INSERT INTO adj_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Nyam Lɛl dad ninɛ: ŋ sosiɛm anake sɛgŋ fɛŋ sʼam uw, ke wɛl am kok ɛy ɛsɛ mɛcɛb eke wɛl bʼↄny im ibi usu af a. ");
INSERT INTO adj_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Gbɛkↄ fɛŋ ɛm a, si bʼok ↄkm agbawru, ɛgŋ a eke erur ɛy a eci abu ɛlum ɛm. ");
INSERT INTO adj_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","39","Ɛɛ, mʼↄny ↄmn tasi, eke ob kaka kʼↄtum ↄnym kpabm ɛy es erur a eke Nyam ɛlu ↄkm, ɛy Ɛs Kↄtↄkↄ Jesu Krist ɛm a e lís. Ke ow él luw oglog owr anŋ, ke ow él afr ɛrm ɛsɛl oglog es ɛw ɛsɛl oglog lɛc ekʼanŋ lɛf ɛm, ke ow él lɛgŋ na ɛm, lɛgŋ ekʼanŋ anym am ow ab ɛm, ke ow él afr e lɛc oglog wus aŋa e lɛc, ke ow él mob mob fɛŋ eke wɛl kok, ob kaka kʼↄtum ↄnym kpabm ɛy es Nyam ecʼerur ekʼↄny ɛy ecʼa e lís! ");
INSERT INTO adj_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Ɛm mʼel Krist eci, ow sosiɛm, low a eke mʼam mʼow mi dad a el low nawrɛ, mi kʼↄtum mʼↄnym yadŋ. Ɛm e tutr a eke Abŋ Lala am nyimn a yɛji am dadʼm eke ow el low nawrɛ. ");
INSERT INTO adj_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","Ɛm ecʼɛrm a sos ↄw es nↄnↄ ligbɛl ɛtŋ mʼam ij gbre eke úwrm. ");
INSERT INTO adj_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Mi bʼow mʼɛgŋ mʼeb eke Nyam kʼigŋ ↄwlʼm ke mi kpáb es Krist e lís, eke ow ↄtu cɛ eke kʼeb ɛm lisijimɛl Jwifɛl ɛlu es. ");
INSERT INTO adj_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Bla ecʼee? -Lʼel Israɛl eyŋ, Nyam ot ɛl -lʼel ow ecʼey. Wɛl ecʼaraŋn nʼanŋ in ecʼanygbɛl ab ɛm, lʼɛgŋ sinm wɛl ab, nʼↄŋ wɛl in ecʼol a, li yɛgm wɛl sɛwl yecʼɛm eke wɛl kʼigŋʼn nuŋ a, ɛtŋ li dad wɛl ów eke li bɛbm lʼɛw es wɛl ecʼa. ");
INSERT INTO adj_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Ɛl -lʼel ɛl lagŋɛl ekpekp a eci alaw. Ɛl ecʼaraŋn anake wɛl ew Krist ɛsɛ ɛgŋ owr af, in eke lʼel Nyam ekʼanŋ ob fɛŋ e nuŋ af a! Kↄklm él in eci sɛgŋ fɛŋ! Amɛn! ");
INSERT INTO adj_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Ow elm ke wɛl dad ɛsɛ Nyam e low a eke ɛwar ɛw es a ɛlu ok es. Tasi ɛm a, agŋ a eke wɛl ew ɛy lagŋ Israɛl ɛm a, ɛl fɛŋ -lʼelm Israɛl eyŋ tasi. ");
INSERT INTO adj_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Ɛtŋ agŋ a bↄbↄ eke wɛl ew ɛy lagŋ Abraham ecʼeb ab ɛm a yɛji, ow elm ɛl fɛŋ -lʼelm ow ecʼey tasi, aŋke Nyam dad Abraham ninɛ: Isak ɛm anake bʼow ɛŋn alaw eke bʼow ɛlu ŋ e nin a ↄkm a. ");
INSERT INTO adj_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Kin sodad na ecʼiri tasi a: ow elm ey a eke wɛl ew igŋ nyam lele yↄw nyam ab ecʼerur ɛm a elm Nyam ecʼey. Kↄ ey tasi a, ɛl -lʼel Nyam ecʼɛwar ecʼey a. ");
INSERT INTO adj_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","Kin ɛwar a e sodad a: mʼow mʼɛwl mɛny mʼow ŋ ogŋ a lakpo yecʼa, lɛgŋ nɛnɛ af, ɛtŋ ayŋ Sara bʼow ew iy igŋ nyam. ");
INSERT INTO adj_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","Ɛtŋ ow elm na sↄny cɛ: kↄ Rebeka ecʼa yɛji. Lʼew ey yony ɛy lagŋ Isak ab. ");
INSERT INTO adj_vpl VALUES ("RM9_11","075_9_11","ROM","9","11","13","Ey yony a, wɛl kʼewm kokm ɛl wus, -li ki kokm low ŋuŋ oglog low nimamn. Gbɛkↄ Nyam dad Isak ɛw es eke: likpekp a bʼow anŋ jam ɛs a eci es ɛw ɛm. Ɛtŋ usu ɛjecʼɛm a, Nyam Lɛl dad ninɛ: mʼerur Jakↄb mʼoc ɛtŋ mi wal Esayu mʼɛlu es. Low na ɛcr nɛnɛ, yecʼɛtŋ ke Nyam e low a eke bɛbm ɛw es a ɛ́li any. Nyam bi sↄsum agŋ ot ɛsɛ elel eke li bʼerur ab af, ɛtŋ sↄsum oc a elm agŋ a ecʼów e bi kok a sosiɛm, kↄ Nyam cɛ eke bʼɛsŋ ɛgŋ ab ɛm ow bʼanŋ ow. ");
INSERT INTO adj_vpl VALUES ("RM9_14","075_9_14","ROM","9","14","14","Sica ayaf si ki dadr ab ee? Kↄ Nyam ɛnyɛmbri yony yony ɛs lʼel ee? Njaŋ, ow elm ɛbɛn! ");
INSERT INTO adj_vpl VALUES ("RM9_15","075_9_15","ROM","9","15","15","Tasi ɛm a, li dad Mois ninɛ: Mi bʼow mʼikŋ ɛgŋ e mʼerur eke mi kʼikŋ sↄrŋ a sↄrŋ, ɛtŋ mi bʼow mʼↄnyn ɛgŋ eke mʼerur eke mi kʼↄnyn ɛrm mamn a ɛrm mamn. ");
INSERT INTO adj_vpl VALUES ("RM9_16","075_9_16","ROM","9","16","16","Ow sosiɛm a, Nyam e sↄrŋ ikŋ a ánm agŋ e low e bʼerur ab ɛm, oglog sos eke bʼatr es ab ɛm, kↄ Nyam cɛ eke ↄny sↄrŋ ikŋ ab ɛm ow bʼanŋ ow. ");
INSERT INTO adj_vpl VALUES ("RM9_17","075_9_17","ROM","9","17","17","Nyam Lɛl ɛm, Nyam dad Ejipt ecʼɛb ebu a ninɛ: Mʼɛwʼŋ ɛb ebu, yecʼɛtŋ ke ŋ ɛm mʼɛ́lu ɛm ecʼabusu a ↄkm, ke mi kók ɛm e nin a eb es wus na nimum af. ");
INSERT INTO adj_vpl VALUES ("RM9_18","075_9_18","ROM","9","18","18","Wɛl bʼɛkn eke Nyam bʼikŋ ɛgŋ eke lʼerur eke li kʼikŋ sↄrŋ a sↄrŋ, ɛtŋ li bʼↄtur ɛgŋ eke lʼerur eke li kʼↄtur ɛrm a ɛrm. ");
INSERT INTO adj_vpl VALUES ("RM9_19","075_9_19","ROM","9","19","19","Gbɛkↄ, kʼaw ke ɛgŋ íbrm im ɛsɛ: sica, eke ow el nɛnɛ, bla sosiɛm ɛmɛny Nyam kʼɛnym ɛy abr ee? Bwo ecʼɛgŋ ↄtu eke ki dogŋn low eke li bʼerur ab ee? ");
INSERT INTO adj_vpl VALUES ("RM9_20","075_9_20","ROM","9","20","20","Kↄ ŋ gbɛ, bwo elʼŋ eke kʼatar Nyam ab ee? Kↄ mijel bʼibrm ɛgŋ a eke kokʼr a ɛsɛ: bla sosiɛm ɛtŋ kokʼm mijel ee? ");
INSERT INTO adj_vpl VALUES ("RM9_21","075_9_21","ROM","9","21","21","Kↄ mijel kok ɛs ↄtum eke ki kok low e lʼerur kpeŋ ab ab ee? Kↄ lʼↄtum eke kpeŋ nyam a cɛ, li kʼitl li kok lɛ́w sↄbↄ nyam oglog lɛ́w kprakasa nyam ee? ");
INSERT INTO adj_vpl VALUES ("RM9_22","075_9_22","ROM","9","22","22","Nyam erur eke kʼɛlu in ecʼɛrm bebl ↄkm ke yɛ́gm in ecʼabusu a. Gbɛkↄ agŋ a eke nʼↄny ɛrm bebl wɛl ab, ke it eke kʼirm ↄgbu es a, lʼɛgŋ wɛl e low lʼeb low eku ligbɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("RM9_23","075_9_23","ROM","9","23","23","Lʼɛgŋ low nɛnɛ lʼeb, yecʼɛtŋ ke lʼɛ́lu in eci anygbɛl a e sagb a ↄkm agŋ eke lʼerur eke li ki yɛgm in e sↄrŋ ikŋ a e lís. Ow el agŋ a eke lʼikŋ anym li bɛbm lʼɛw es eke kʼɛŋn anygbɛl na a. ");
INSERT INTO adj_vpl VALUES ("RM9_24","075_9_24","ROM","9","24","24","Ɛtŋ ɛy sʼel agŋ amua eke lʼɛsŋ a. Ow elm Jwifɛl ecʼaraŋn cɛ lʼɛsŋm ɛy, kↄ agŋ eke elm Jwifɛl ecʼaraŋn ecʼagŋ a yɛji. ");
INSERT INTO adj_vpl VALUES ("RM9_25","075_9_25","ROM","9","25","25","Nyam dad low na kokoba ↄb ɛs Ose e lɛl ab ɛm: Agŋ a eke elm ɛm ecʼagŋ a, mi bʼow mʼɛsŋ ɛl “ɛm ecʼagŋ”. Ɛtŋ agŋ a eke mʼérurm a, mi bʼow mʼɛsŋ ɛl “agŋ e mʼerur”. ");
INSERT INTO adj_vpl VALUES ("RM9_26","075_9_26","ROM","9","26","26","Ɛtŋ yogŋ a eke wɛl dad agŋ eke: «Ɔny elmn ɛm ecʼagŋ a,» wɛl bʼow ɛsŋ ɛl Nyam ekʼanŋ owr ecʼey. ");
INSERT INTO adj_vpl VALUES ("RM9_27","075_9_27","ROM","9","27","27","Esayi, in am ɛlu lebl Israɛl ecʼagŋ e lís ɛsɛ: Eke batŋ Israɛl eyŋ ɛny nↄnↄ ɛsɛ okij any e mirici af yɛji, agŋ tɛl a eke wal es a cɛ bʼow ɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("RM9_28","075_9_28","ROM","9","28","28","Tasi ɛm a, Nyam Admaga bʼow kok low a eke li dad a wus af aŋa, li bʼow li kok fafa toŋ lʼigŋ nuŋ. ");
INSERT INTO adj_vpl VALUES ("RM9_29","075_9_29","ROM","9","29","29","Ɛtŋ low na anake Esayi yɛji ikŋ anym dad a: blel Nyam Abusu Ɛs okm ɛy alaw bɛb es, ke blel sʼánŋ ɛsɛ Sodↄm eyŋ af, ke sʼótarir es Gomↄr eyŋ ab. ");
INSERT INTO adj_vpl VALUES ("RM9_30","075_9_30","ROM","9","30","30","Ke ayaf si ki dadr ab ee? Nawrɛ, agŋ eke elm Jwifɛl a, ↄ́lm eke kʼel nyim nyim Nyam ecʼany af. Gbɛkↄ -lʼɛkn eke Nyam ɛgŋ eb ɛl, ɛl ecʼↄmn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM9_31","075_9_31","ROM","9","31","31","Ke Israɛl ecʼagŋ a am ↄl eke kʼel nyim nyim eke -li bʼɛlum Nyam ecʼol a sosiɛm. Kↄ ɛl -lʼↄwl -lʼok es. ");
INSERT INTO adj_vpl VALUES ("RM9_32","075_9_32","ROM","9","32","32","Bla sosiɛm ee? -lʼↄwl -lʼok es, aŋke -lʼↄlm nyim nyim el na es ↄmn ɛm, -li tutr eke ɛl ecʼów kok ɛm -li bʼow -nʼɛŋn. Ɛbɛn a, -lʼuyum lebn a eke bʼɛlu ɛgŋ wus ab ab. ");
INSERT INTO adj_vpl VALUES ("RM9_33","075_9_33","ROM","9","33","33","Tasi ɛm a, Nyam Lɛl dad ninɛ: Siↄn ɛb ɛm, mʼam ɛw lebn nyam eke bʼeb agŋ akr, lob eke bʼɛlu ɛgŋ wus es. Ɛgŋ yecʼeke bʼoc ↄmn ɛluʼl ɛm a, sos kʼow ↄwm es lɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("RM10_1","075_10_1","ROM","10","1","1","Agŋ lisijimɛl, mʼam erur ɛm ecʼɛrm fɛŋ ɛm eke Jwifɛl kʼɛŋn sel, ɛtŋ mʼam ibrm Nyam low na ɛl eci. ");
INSERT INTO adj_vpl VALUES ("RM10_2","075_10_2","ROM","10","2","2","Nawrɛ, mʼↄtu eke mi kʼij ɛl e lís e daŋku mʼɛsɛ: Nyam e kok owi anŋ ɛl ɛrm ɛm tasi, kↄ -lʼuwm ow ecʼejagb ab any tasi. ");
INSERT INTO adj_vpl VALUES ("RM10_3","075_10_3","ROM","10","3","3","-Lʼirim elel eke Nyam bʼocr agŋ nyim nyim a, ɛtŋ -lʼↄl ɛl ecʼelel eke agŋ bʼeel nyim nyim ab es. Ow ↄŋ -lʼɛgŋm -lʼebm elel a eke Nyam bʼocr agŋ ɛsɛ agŋ nyim nyim af a. ");
INSERT INTO adj_vpl VALUES ("RM10_4","075_10_4","ROM","10","4","4","Tasi ɛm a, Krist kok Mois ecʼol a e low iy nɛny, yecʼɛtŋ ke Nyam óc agŋ fɛŋ eke bʼub Krist nawrɛ a agŋ nyim nyim. ");
INSERT INTO adj_vpl VALUES ("RM10_5","075_10_5","ROM","10","5","5","Mois in obi nↄn elel eke wɛl ↄtu eke kʼeel nyim nyim ol ecʼɛlum sosiɛm a ninɛ: ɛgŋ yecʼeke bi kok ol ecʼów a fɛŋ ekʼanŋ ɛm a, bʼow anŋ owr in ɛm. ");
INSERT INTO adj_vpl VALUES ("RM10_6","075_10_6","ROM","10","6","6","Gbɛkↄ kin yecʼeke li dad agŋ a eke Nyam bʼoc ɛsɛ agŋ nyim nyim af ɛl ecʼↄmn a sosiɛm a e lís: kì dad ŋ ecʼɛrm ab ɛm kʼɛsɛ: bwo ecʼɛgŋ bʼow uyu afr ee? Ɛsɛ ɛbɛn eke wɛl am ibrm, kↄ bwo bʼow uyu afr ↄny Krist usm es ee? ");
INSERT INTO adj_vpl VALUES ("RM10_7","075_10_7","ROM","10","7","7","Ɛmɛny kì dad kʼɛsɛ: bwo ecʼɛgŋ bʼow us es wus lokm ee? Ɛsɛ ɛbɛn eke wɛl am ibrm, kↄ bwo bʼow us es yogŋ ↄny Krist ɛlu ↄkm agŋ ekʼuw ab ɛm ee? ");
INSERT INTO adj_vpl VALUES ("RM10_8","075_10_8","ROM","10","8","8","Ow elm ɛbɛn, aŋke wɛl nↄn: odad a anŋʼŋ saw, ŋ e nɛny ab ɛm lele ŋ ecʼɛrm ɛm ab ab. Ɛtŋ odad na, in anake lʼel ↄmn ecʼamani a eke sʼam ↄb a. ");
INSERT INTO adj_vpl VALUES ("RM10_9","075_10_9","ROM","10","9","9","Eke ŋ e nɛny bi dad agŋ fɛŋ ecʼany af ɛsɛ Jesu el Ɛs Kↄtↄkↄ, ɛtŋ ub nawrɛ ŋ ecʼɛrm ab ɛm eke Nyam igbmʼn luw ɛm a, ow bʼow ↄŋʼŋ ɛŋn sel. ");
INSERT INTO adj_vpl VALUES ("RM10_10","075_10_10","ROM","10","10","10","Tasi ɛm a, eke si bʼub nawrɛ ɛy ecʼɛrm fɛŋ ɛm a, Nyam bʼoc ɛy ɛsɛ agŋ nyim nyim af, ɛtŋ eke si bʼɛlu ɛy ecʼↄmn a ↄkm agŋ fɛŋ ecʼany af a, li bi sↄg ɛy. ");
INSERT INTO adj_vpl VALUES ("RM10_11","075_10_11","ROM","10","11","11","Ɛɛ, Nyam Lɛl dad ninɛ: Ɛgŋ yecʼeke bʼoc ↄmn ɛluʼl ɛm a, sos kʼow ↄwm es lɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("RM10_12","075_10_12","ROM","10","12","12","Ow sosiɛm a, ereb anm Jwifɛl lel agŋ ekʼelm Jwifɛl ab ab ecʼaraŋn ij. Ɛl fɛŋ Ɛs Kↄtↄkↄ nyam cɛ -nʼↄny, ɛtŋ li bʼↄŋ agŋ a fɛŋ eke bʼɛluʼl lebl a in ecʼów amamn a. ");
INSERT INTO adj_vpl VALUES ("RM10_13","075_10_13","ROM","10","13","13","Nyam Lɛl dad ninɛ: Ɛs Kↄtↄkↄ bʼow sↄg agŋ a fɛŋ eke bʼow ɛluʼl lebl a. ");
INSERT INTO adj_vpl VALUES ("RM10_14","075_10_14","ROM","10","14","14","Sica ayaf -li bʼow -lʼɛlul Ɛs Kↄtↄkↄ lebl, eke -lʼubm ow nawrɛ ee? Ɛtŋ ayaf -li bʼow -lʼub ow nawrɛ, eke -lʼirim ow e lís owi ee? Ɛtŋ ɛmɛny ayaf -li bʼow -lʼiri ow e lís owi, eke ɛgŋ ↄbm ɛl ow ecʼamani ee? ");
INSERT INTO adj_vpl VALUES ("RM10_15","075_10_15","ROM","10","15","15","Ɛtŋ ayaf ɛgŋ kʼↄbr ow ecʼamani, eke wɛl ɛram ɛgŋ ow ecʼee? Ow sosiɛm wɛl nↄn Nyam Lɛl ɛm: Ɛbɛn tasi eke ow akpl eke wɛl ki lɛr agŋ a eke bʼↄb samani amamn a eci mowrer ana! ");
INSERT INTO adj_vpl VALUES ("RM10_16","075_10_16","ROM","10","16","16","Gbɛkↄ, ow elm agŋ a fɛŋ ɛluam Amani Mamn a. Tasi ɛm a, Esayi dad ow e low ninɛ: Ɛs Kↄtↄkↄ, kↄ bwo ecʼɛgŋ ub ɛy e Nyam odad a nawrɛ ee? ");
INSERT INTO adj_vpl VALUES ("RM10_17","075_10_17","ROM","10","17","17","Njɛ, eke ɛgŋ bʼiri amani a, ow anake li bʼub Ɛs Kↄtↄkↄ nawrɛ a, ɛtŋ amani na, ow ow el Krist e lís ecʼodad a. ");
INSERT INTO adj_vpl VALUES ("RM10_18","075_10_18","ROM","10","18","18","Ow sosiɛm mʼam ibrm mʼɛsɛ: kↄ Jwifɛl amua, -lʼirim odad na e low ee? Yadŋ, -lʼiri! Tasi ɛm a, Nyam Lɛl dad ninɛ: Wɛl iri ɛl e lebl wus nimum af ɛtŋ ɛl e sodad ebl im toŋ ok wus e nuŋ. ");
INSERT INTO adj_vpl VALUES ("RM10_19","075_10_19","ROM","10","19","19","Ow sosiɛm ɛmɛny mʼam ibrm mʼɛsɛ: Kↄ Israɛl ecʼagŋ na, -li kʼirim low a kʼokm ɛl es sos ɛm ee? Ke Mois ikŋ anym dad ɛl Nyam ecʼodad a ninɛ: Mi bʼow mʼↄŋ nyamn ɛyr ↄny ↄny agŋ na ekʼel agŋ ekʼↄnym any a e lís. Mi bʼow mʼↄŋ ɛrm ebl ↄny agŋ ekʼↄnym low any uw kaka a e lís. ");
INSERT INTO adj_vpl VALUES ("RM10_20","075_10_20","ROM","10","20","20","Ɛtŋ Esayi oc lokm susu ɛm dad ninɛ: kin low eke Nyam dad: Agŋ a eke ↄlmʼm es a, ɛl -nʼɛŋnʼm. Ɛtŋ mʼɛlu sos ↄkm mi yɛgm agŋ a eke ibram im low kaka a. ");
INSERT INTO adj_vpl VALUES ("RM10_21","075_10_21","ROM","10","21","21","Gbɛkↄ Israɛl ecʼagŋ a e lís a, Nyam dad ninɛ: Lɛgŋ nimum a, mʼɛgŋm abu es bieku nyam eke ɛ́luam low, ke ɛ́gŋm ɛm e low ebm a e lís. ");
INSERT INTO adj_vpl VALUES ("RM11_1","075_11_1","ROM","11","1","1","Sica mʼam ibrm mʼɛsɛ: kↄ Nyam in ecʼagŋ na es lʼigŋ lʼok wɛl ee? Njaŋ! Aŋke ɛm mʼel Israɛl iy, Abraham e lilaw lele Bɛnjamɛ ecʼeb ɛm ecʼɛgŋ ab. ");
INSERT INTO adj_vpl VALUES ("RM11_2","075_11_2","ROM","11","2","2","Nyam igŋm in ecʼagŋ a eke in obi lʼikŋ anym li sↄsum lʼot a, lʼɛlum es. Eke mʼↄnym yadŋ, ke uwr Eli e sodad eke anŋ Nyam Lɛl ɛm ab any, yogŋ a eke nʼam ok Israɛl eyŋ dedeku es Nyam ogŋ a. ");
INSERT INTO adj_vpl VALUES ("RM11_3","075_11_3","ROM","11","3","3","Ɛtŋ kin odad a: Ɛs Kↄtↄkↄ, -lʼibi ŋ eci kokoba ↄb ɛsɛl a, -ni ŋuŋn ŋ e segb waw usu a. Ɛm sↄny cɛ anake mʼanŋ a, ɛtŋ ɛm yɛji -nʼam erur eke -li kʼibiʼm. ");
INSERT INTO adj_vpl VALUES ("RM11_4","075_11_4","ROM","11","4","4","Ɛtŋ Nyam ecʼeke dad ↄŋʼn a el bogŋ ecʼee? Anm ŋ sↄny! Mʼɛdŋn agŋ fandi lↄbŋ mʼɛw es ɛm eci, agŋ a eke ókm ↄwrↄkp wus igŋm Baal nuŋ a. ");
INSERT INTO adj_vpl VALUES ("RM11_5","075_11_5","ROM","11","5","5","Yɛfɛnyna yɛji low nyam a cɛ. Agŋ tɛl anŋ eke Nyam in ecʼɛrm mamn ab ɛm ɛdŋn ɛw es. ");
INSERT INTO adj_vpl VALUES ("RM11_6","075_11_6","ROM","11","6","6","Eke Nyam in ecʼɛrm mamn ab ɛm sↄsum ot ɛl, ke ow elm ɛl ecʼów eke -li kokr a sosiɛm. Blel ow el ɛbɛn, ke Nyam ecʼɛrm mamn ɛm ecʼob ap a elm bibm ↄfr ɛm ij. ");
INSERT INTO adj_vpl VALUES ("RM11_7","075_11_7","ROM","11","7","7","Sica ayaf si ki dadr ab ee? Israɛl eyŋ ɛŋnm ob a eke -nʼam ↄl es a, kↄ agŋ a cɛ eke Nyam sↄsum ot a ɛŋn ob a; agŋ likpr a ↄny ɛrm tuↄtuↄ, ");
INSERT INTO adj_vpl VALUES ("RM11_8","075_11_8","ROM","11","8","8","ɛtŋ ɛsɛ elel eke wɛl nↄn Nyam Lɛl ɛm ab af: toŋ ke igŋ yɛfɛnyna a, Nyam ↄŋ ɛl eci low iri a anŋ ɛsɛ ob eke uw af, nʼↄↄm abusu eke ɛl ecʼanyamn a kʼɛkn es, ke ɛl ecʼↄru a íri ów. ");
INSERT INTO adj_vpl VALUES ("RM11_9","075_11_9","ROM","11","9","9","Ɛb ebu David yɛji dad ninɛ: Ke ɛl eci ob ij ɛgbɛl a ítŋn el meb eke wɛl uk ɛl, nↄmu e wɛl ɛdŋ, ɛl e wus ok eci, ke Nyam kók ɛl ow e low. ");
INSERT INTO adj_vpl VALUES ("RM11_10","075_11_10","ROM","11","10","10","Ke -lʼel ány eflu, -li kʼɛknmn low kaka fɛŋ! Ke Nyam úyul ɛl ɛrɛkp leg leg ↄny ibn ɛl es sɛgŋ fɛŋ! ");
INSERT INTO adj_vpl VALUES ("RM11_11","075_11_11","ROM","11","11","11","Sica mʼam ibrm mʼɛsɛ: kↄ Jwifɛl na wus -lʼok kpɛkŋ kpɛkŋ ab ee? Njaŋ! Gbɛkↄ ɛl eci low any ↄbr a ↄŋ ɛtŋ bieku ɛjeci ecʼagŋ a ↄtu ɛŋn sel. Ɛbɛn a, ow ↄŋ Israɛl eyŋ am ogŋ ɛl ŋkre. ");
INSERT INTO adj_vpl VALUES ("RM11_12","075_11_12","ROM","11","12","12","Israɛl eci low any ↄbr a ism wus ów amamn ɛgbɛl ɛgbɛl ab, ɛtŋ in eci wus ɛy a ism agŋ ekʼelm Jwifɛl a ów amamn ɛgbɛl ɛgbɛl ab. Sica, lɛgŋ a eke Jwifɛl a fɛŋ bʼow ɛwl ɛgŋ Nyam e low eb a, ow ayl tasi eke Nyam ecʼów amamn ɛgbɛl a ɛmɛny bʼow agb bobn. ");
INSERT INTO adj_vpl VALUES ("RM11_13","075_11_13","ROM","11","13","13","Sica, ↄny eke elmn Jwifɛl a, ↄny anake mʼam dad ↄny odad a. Ɛm mʼel Krist ecʼɛrm ɛs agŋ a ekʼelm Jwifɛl a eci, ɛtŋ mʼↄny sos ɛm iŋn ɛm e juma na ɛm. ");
INSERT INTO adj_vpl VALUES ("RM11_14","075_11_14","ROM","11","14","14","Juma na eci kok ɛm a, mʼam ↄny tutr eke mi bʼow mʼobn ɛm lisijimɛl Jwifɛl eci ŋkre ogŋ a, ke ow ↄ́ŋ mʼeb agŋ nyam nyam ɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("RM11_15","075_11_15","ROM","11","15","15","Tasi ɛm a, eke Nyam ɛw ɛl saw a, lʼokr ɛm wus ab. Sica, lɛgŋ a eke li bʼow lʼɛwl lʼeb wɛl a, bla lowi bʼow ɛy ab ee? Agŋ eke uw a bʼow ɛwl anŋ owr. ");
INSERT INTO adj_vpl VALUES ("RM11_16","075_11_16","ROM","11","16","16","Eke futufutu ecʼogog nyam el Nyam eci, ke futufutu a nimum yɛji in ecʼana. Ɛtŋ eke likŋ nyam eci min a fɛŋ el Nyam eci, ke ál a yɛji in ecʼana. ");
INSERT INTO adj_vpl VALUES ("RM11_17","075_11_17","ROM","11","17","17","Israɛl eyŋ anŋ ɛsɛ olivie ikŋ eke wɛl ewl ↄgm, ke Nyam bubr in ecʼál bɛb es af. Ɛtŋ ŋ, eke elm Jwif ke anŋ ɛsɛ akp ↄfr ɛm ecʼolivie ikŋ af a, lʼoc lʼujrʼŋ likŋ lis ab ɛm, wuwlm ekŋ ál tasi a eke cucu likŋ lis a eke wɛl ewl ab ab. Ɛtŋ sica, ↄtu eke in ecʼekŋ ál ab ab kʼɛ́ŋn mij a eke bʼanŋ in e min ab ɛm ow a. ");
INSERT INTO adj_vpl VALUES ("RM11_18","075_11_18","ROM","11","18","18","Ow sosiɛm, kʼìm ekŋ ál a ecʼany af kʼíj en! Eke erur eke kʼij en, ↄkn eke ow elm ŋ ecʼabu ɛm likŋ a e min a anm, kↄ ŋ likŋ a e min a ecʼabu ɛm anŋ. ");
INSERT INTO adj_vpl VALUES ("RM11_19","075_11_19","ROM","11","19","19","Ŋ bʼow dad ɛsɛ: wɛl bubr ekŋ ál es ɛtŋ ɛm, wɛl oc ujrʼm likŋ lis ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM11_20","075_11_20","ROM","11","20","20","Na low nawrɛ! Wɛl bubr ɛl es aŋke -nʼↄnym ↄmn, ɛtŋ ŋ akŋm likŋ lis ab ab, aŋke ↄny ↄmn. Ŋ kʼɛ̀w sos, kↄ erŋn anake kʼↄnyʼŋ a. ");
INSERT INTO adj_vpl VALUES ("RM11_21","075_11_21","ROM","11","21","21","Ɛɛ, aŋke eke Nyam ɛgbm Jwifɛl eke el likŋ caŋ a ecʼál ab es, ŋ yɛji li kʼow lʼɛgbmʼŋ es. ");
INSERT INTO adj_vpl VALUES ("RM11_22","075_11_22","ROM","11","22","22","Ɛ̀bmn nyamn ɛkn elel eke Nyam bʼɛlu in ecʼɛrm mamn ↄny lel in e tuↄtuↄ el ab ab ↄkm a: lʼɛlu in e tuↄtuↄ el a ↄkm agŋ eke ok wus a e lís, ɛtŋ lʼɛlu ɛrm mamn ↄkm ŋ e lís. Gbɛkↄ ow it eke kʼanŋ in ecʼɛrm mamn ↄny ab ɛm, ekʼow elm ɛbɛn, ŋ yɛji li bʼow lʼubrʼŋ es ɛsɛ likŋ lal af. ");
INSERT INTO adj_vpl VALUES ("RM11_23","075_11_23","ROM","11","23","23","Eke batŋ Jwifɛl igŋ ɛl eci ɛrm tuↄtuↄ a ɛlu es, Nyam bʼow ɛwl oc ujr ɛl yogŋ a eke anym ɛm a -nʼanŋn a, aŋke nʼↄny abusu eke li kʼujr wɛl ɛm. ");
INSERT INTO adj_vpl VALUES ("RM11_24","075_11_24","ROM","11","24","24","Tasi ɛm a, ŋ, akp ↄfr ɛm e likŋ lal el. Nyam ubrʼŋ es ɛtŋ oc ujrʼŋ likŋ eke wɛl ewl ɛm, ŋ ecʼa ow elm elel eke wɛl ki kokr a. Jwifɛl ecʼa, ɛl -lʼel likŋ a eke wɛl ewl a ecʼál. Ow sosiɛm, ow bʼow ɛw fuɛfuɛ eke Nyam kʼujr ɛl likŋ na eke ow el ow ɛm -lʼɛlil -lʼokr ↄkm a. ");
INSERT INTO adj_vpl VALUES ("RM11_25","075_11_25","ROM","11","25","25","Agŋ lisijimɛl, kin Nyam e lís e low e lↄl es ke mʼerur eke mi ki yɛgm ↄny uwr any, yecʼɛtŋ ke ↄny eke elmn Jwifɛl a, kʼócrmn ↄny sosi eke eel ɛsɛwru. Israɛl eyŋ ecʼogog nyam kʼow ɛgŋm eke kʼiri low, ɛtŋ ow bʼow anŋ ibn toŋ bake ɛb ɛb ɛjecʼa e nɛny a nimum ɛwl ow Nyam ogŋ. ");
INSERT INTO adj_vpl VALUES ("RM11_26","075_11_26","ROM","11","26","26","Ɛtŋ ɛbɛn a Israɛl eyŋ tasi a fɛŋ bʼow ɛŋn sel, ɛsɛ elel eke wɛl nↄn Nyam Lɛl ɛm ab af: Es Eb Ɛlu Ɛs a bʼow anŋ Jerusalɛm ow. Li bʼow nʼↄny Jakↄb ecʼeb a eci low any ↄbr a lʼoc es. ");
INSERT INTO adj_vpl VALUES ("RM11_27","075_11_27","ROM","11","27","27","Ɛtŋ Admaga igŋ af dad ninɛ: kin sinm a eke mi bʼow mi kok ɛl ab lɛgŋ a eke mi bʼow mʼↄny ɛl e sikpl a mʼoc es a. ");
INSERT INTO adj_vpl VALUES ("RM11_28","075_11_28","ROM","11","28","28","-Lʼɛgŋm Amani Mamn a -lʼebm, ow ↄŋ -lʼɛwl -lʼel Nyam ecʼefnu ɛtŋ ɛbɛn a, ↄny, ow akpl ↄny eci. Ke Nyam eke sↄsum ot ɛl a, in ecʼagŋ eke wɛl kʼel eci. Li bʼerur wɛl ɛl lagŋɛl sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM11_29","075_11_29","ROM","11","29","29","Tasi ɛm a, lɛgŋ kaka Nyam ɛwlm ébm ob eke li bʼↄŋ ɛgŋ a, ɛtŋ agŋ a eke li bi sↄsum lʼot a, lʼígŋm lʼɛlum wɛl es lɛgŋ kaka. ");
INSERT INTO adj_vpl VALUES ("RM11_30","075_11_30","ROM","11","30","30","Lɛgŋ sig ɛm a, ↄny ↄbar Nyam any, kↄ caca ɛm a, Jwifɛl anake ↄbr Nyam any, ke ow ↄŋ, ↄny ɛŋan Nyam eci sↄrŋ ikŋ a. ");
INSERT INTO adj_vpl VALUES ("RM11_31","075_11_31","ROM","11","31","31","Ɛtŋ ɛl ecʼa yɛji ɛbɛn cɛ ow bʼow el: sica ɛl yɛji, -li bʼow -lʼↄtu -nʼɛŋn Nyam e sↄrŋ ikŋ a, ↄny eci sↄrŋ ikŋ a eke Nyam ↄny a sosiɛm eci. ");
INSERT INTO adj_vpl VALUES ("RM11_32","075_11_32","ROM","11","32","32","Tasi ɛm a, agŋ a fɛŋ ↄnym ɛlum, ow sosiɛm Nyam ɛgb ɛl es -li kok ów eke -lʼerurir a, yecʼɛtŋ ke li yɛ́gm wɛl fɛŋ in eci sↄrŋ ikŋ a. ");
INSERT INTO adj_vpl VALUES ("RM11_33","075_11_33","ROM","11","33","33","Nyam ecʼob ↄny a agb nawrɛ tasi! In e sɛwr a lel in e low any uw ab ab ↄtu nↄnↄ, ɛgŋ kaka kʼↄtum uwm in ecʼów eke li bi dad lʼucu es ab any, ɛgŋ kaka kʼↄtum irim in ecʼów eke li bɛbm lʼok es a. Nyam Lɛl dad ninɛ: ");
INSERT INTO adj_vpl VALUES ("RM11_34","075_11_34","ROM","11","34","34","Bwo uw Ɛs Kↄtↄkↄ eci tutr ab any ee? Bwo ↄtu eke kʼↄmʼn ów ee? ");
INSERT INTO adj_vpl VALUES ("RM11_35","075_11_35","ROM","11","35","35","Bwo ikŋ anym ↄŋ Nyam ob, eke sica Nyam yɛji kʼↄwr ↄŋʼn ee? ");
INSERT INTO adj_vpl VALUES ("RM11_36","075_11_36","ROM","11","36","36","Ɛgŋ kaka, aŋke in ɛm fɛŋ bʼanŋ ow, in ɛm fɛŋ ɛcr anŋ ɛtŋ el in eci. Anygbɛl él Nyam eci sɛgŋ fɛŋ! Amɛn! ");
INSERT INTO adj_vpl VALUES ("RM12_1","075_12_1","ROM","12","1","1","Agŋ lisijimɛl, Nyam ↄny ɛy eci sↄrŋ ikŋ. Ow sosiɛm, mʼam ↄm ↄny ów eke kʼocr ↄny ecʼɛgŋ el a nimum lele ↄny ecʼowr anŋ ab ab ápr ir, ɛsɛ egb waw ekʼayl ke akpl af. Na anake el nuŋ igŋ tasi a ekʼit eke kʼↄŋn in a. ");
INSERT INTO adj_vpl VALUES ("RM12_2","075_12_2","ROM","12","2","2","Kʼùsr wus eke sʼir af a ecʼagŋ ɛm ecʼów a jam, kↄ yɛ̀br Nyam itŋn ↄny e tutr a nimum. Ɛbɛn ke ↄ́tur uwr yecʼeke lʼerur ab any: yecʼeke akpl, yecʼeke akplʼl sos ɛm lele yecʼeke iy nɛny bɛbmn ab ab. ");
INSERT INTO adj_vpl VALUES ("RM12_3","075_12_3","ROM","12","3","3","Bibm ɛm ecʼob ap ↄfr ɛm a eke Nyam ↄŋʼm a sosiɛm, mʼam dad ↄny ɛm ecʼɛgŋni nyam nyam fɛŋ eke kʼocrm in sosi ɛgŋ ligbɛl. Kↄ òkr nuŋ ɛm es, ke jɛ́jr ↄny sosi okr ↄmn a eke Nyam ↄŋ ɛy ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM12_4","075_12_4","ROM","12","4","4","Tasi ɛm a, ɛy e sos megl ab ɛm susu ogog nↄnↄ anŋ, kↄ ɛl fɛŋ -li kokmn juma nɛnyɛmbri nyam a. ");
INSERT INTO adj_vpl VALUES ("RM12_5","075_12_5","ROM","12","5","5","Nɛnɛ anake sʼanŋ Krist ab ecʼaf okr ab ɛm a. Sʼɛny nↄnↄ, kↄ ɛy fɛŋ a sʼel sos megl nyam. Ɛtŋ ɛy fɛŋ sʼokr af ɛy ↄfr ɛm, ɛgŋ ɛgŋ ecʼusu ekʼanŋ a, ɛsɛ sos megl nyam ecʼogog ogog ecʼab af. ");
INSERT INTO adj_vpl VALUES ("RM12_6","075_12_6","ROM","12","6","6","Bibm ɛm, Nyam ↄŋ ɛy sob ap ↄfr ɛm, ɛtŋ ɛgŋ ɛgŋ ɛŋn in eci. Ow sosiɛm, ekʼɛgŋ nyam ɛŋn bibm ekʼel odad dad eci ɛsɛ kokoba ↄb ɛs af a, ke li dád yecʼa eke okr af ɛy ecʼↄmn ab ab a. ");
INSERT INTO adj_vpl VALUES ("RM12_7","075_12_7","ROM","12","7","7","Ekʼɛgŋ nyam ɛŋn bibm ekʼel juma ecʼabu ɛlum eci, ke nʼám kok abu ɛlum ɛs e juma, ekʼɛgŋ nyam ɛŋn bibm ekʼel low yɛgm eci, ke nʼám yɛgm agŋ low, ");
INSERT INTO adj_vpl VALUES ("RM12_8","075_12_8","ROM","12","8","8","ke ɛgŋ ekʼɛŋn bibm ɛgŋ e sos es atr ecʼa, ám atr agŋ sos es. Ɛgŋ ekʼam ↄŋ agŋ ob a, ↄ́ŋ ɛrm nyam ɛm, ɛgŋ ekʼam nyimn agŋ a, nyímn ɛl gbragbra kok ɛm. Ɛgŋ ekʼam ɛlum ↄgbↄru abu a, ɛ́lum ɛl abu sos ɛm iŋn ɛm. ");
INSERT INTO adj_vpl VALUES ("RM12_9","075_12_9","ROM","12","9","9","Ke ↄny ecʼerur a él nɛnyɛmbri nyam ɛm; ìfan low ŋuŋ kok, ke úcur low mamn e kok ↄnyn es. ");
INSERT INTO adj_vpl VALUES ("RM12_10","075_12_10","ROM","12","10","10","Èrurir ↄny ↄfr ɛrm frↄrↄ ɛm, ɛsɛ Krist ɛm ecʼagŋ lisijimɛl af. Èel agŋ eke bʼogŋ es ɛlum ɛl lawlɛl. ");
INSERT INTO adj_vpl VALUES ("RM12_11","075_12_11","ROM","12","11","11","Kòkr Ɛs Kↄtↄkↄ eci juma gbragbra kok ɛm, ke sos am kaka kʼánm ɛm, ke ow él ↄny ecʼɛrm fɛŋ ɛm. ");
INSERT INTO adj_vpl VALUES ("RM12_12","075_12_12","ROM","12","12","12","Ànŋn sos ɛm iŋn ɛm ↄny e low ↄmn a sosiɛm. Ɔ̀nyn ɛrm susu gbre ij ɛm, ùcur Nyam ŋↄŋn ↄnyn es. ");
INSERT INTO adj_vpl VALUES ("RM12_13","075_12_13","ROM","12","13","13","Ɛ̀lumn Nyam ecʼagŋ ekʼↄny es abur a abu, ke sɛgŋ fɛŋ bɛ́bmn sos ebr agŋ a eke bʼow ↄny ogŋ a sɛnyn sɛnyn. ");
INSERT INTO adj_vpl VALUES ("RM12_14","075_12_14","ROM","12","14","14","Ìbrmn Nyam e low mamn ↄŋn agŋ eke bʼijr ↄny gbre a, ìbrmn low mamn, kↄ ow kʼél low ŋuŋ. ");
INSERT INTO adj_vpl VALUES ("RM12_15","075_12_15","ROM","12","15","15","Ànŋn sos ɛm iŋn ɛm agŋ a eke bʼanŋ sos ɛm iŋn ɛm ab ab, ke íkŋn ↄŋn, agŋ a eke am ikŋ ↄŋn ab ab. ");
INSERT INTO adj_vpl VALUES ("RM12_16","075_12_16","ROM","12","16","16","Nɛny ókr ↄny af ↄny ↄfr ɛm. Kʼèel es ɛfuu, kↄ ɛ̀gŋn es is ɛm e juma kok ebr. Kʼↄ̀nyn tutr eke ↄny eel agŋ eke uw low fɛŋ any. ");
INSERT INTO adj_vpl VALUES ("RM12_17","075_12_17","ROM","12","17","17","Low ŋuŋ eke ɛgŋ kok ↄny a, kì kokr kʼↄbar ir any, kↄ ↄↄl low mamn kok es agŋ fɛŋ ecʼany af. ");
INSERT INTO adj_vpl VALUES ("RM12_18","075_12_18","ROM","12","18","18","Eke ow el ↄny obi ɛm, ɛtŋ ow ↄtu eke ow kʼel ɛbɛn, ìir ɛb ɛrm es ɛy ɛm agŋ fɛŋ ab. ");
INSERT INTO adj_vpl VALUES ("RM12_19","075_12_19","ROM","12","19","19","Erur ɛm ecʼagŋ lawlɛl, low eke ɛgŋ kok ↄny a, ↄny obi kì kokr ir, kↄ ɛ̀gbr Nyam ecʼɛrm bebl ab es kok ow e low. Tasi ɛm a, Nyam Lɛl ɛm a, Nyam dad ninɛ: Ɛm mi bʼusr ɛgŋ usu mi kok low eke wɛl kokʼr a! Ɛm mi bʼow mʼↄŋ ɛgŋ ɛgŋ ecʼekʼit eke kʼɛbm a! ");
INSERT INTO adj_vpl VALUES ("RM12_20","075_12_20","ROM","12","20","20","Gbɛkↄ li dad yɛjʼeke: Eke ŋ ecʼifnu namn am ↄny, ↄŋʼn ob lʼíj, eke mij amn am ↄnyʼn, ↄŋʼn mij lʼɛ́gŋ. Eke batŋ bi kok ɛbɛn a, ow anŋ ɛsɛ almali ekʼam ot okʼr nuŋ af. ");
INSERT INTO adj_vpl VALUES ("RM12_21","075_12_21","ROM","12","21","21","Kì yɛb low ŋuŋ kʼakmʼŋ es, kↄ òc low mamn akmn low ŋuŋ es. ");
INSERT INTO adj_vpl VALUES ("RM13_1","075_13_1","ROM","13","1","1","Ow it ekʼɛgŋ fɛŋ kʼɛlum agŋ ekʼↄnym es ɛw ab a. Tasi ɛm a, Nyam ɛm es ɛw fɛŋ bʼanŋ ow, ɛtŋ agŋ a ekʼↄnym es ɛw ab a, bʼɛw agŋ es aŋke Nyam ↄŋ abusu. ");
INSERT INTO adj_vpl VALUES ("RM13_2","075_13_2","ROM","13","2","2","Ow sosiɛm, eke ɛgŋ nyam am ↄny low es ɛw ɛsɛl ab a, ke Nyam e low a eke ɛgŋ eb ab ab anake nʼↄny low a, ɛtŋ agŋ a eke ɛ́gŋm ɛluam ɛl a, ɛl obi ɛl obi am eb jɛj ok ɛw sos. ");
INSERT INTO adj_vpl VALUES ("RM13_3","075_13_3","ROM","13","3","3","Eke wɛl am kok low mamn, wɛl ↄtum eke kʼuru agŋ ekʼɛw ɛy es a, kↄ wɛl ↄtu eke kʼuru ɛl eke wɛl am kok low ŋuŋ. Erurm eke kʼuru es ɛw ɛsɛl ee? Ekʼow el ɛbɛn a, kòk low mamn, -li bʼow -lʼawʼŋ. ");
INSERT INTO adj_vpl VALUES ("RM13_4","075_13_4","ROM","13","4","4","Tasi ɛm a, es ɛw ɛsɛl am kok Nyam eci juma yecʼɛtŋ ke -ni nyimnʼŋ ɛy low mamn ɛm. Gbɛkↄ eke am kok low ŋuŋ, ow it eke erŋn kʼↄnyʼŋ. Tasi ɛm a, es ɛw ɛsɛl ↄny abusu eke kʼɛw low ↄŋʼŋ, ɛtŋ ow elm ↄfr ↄfr nɛnɛ cɛ! Eke es ɛw ɛsɛl bʼɛw low ↄŋ ɛgŋ, ke -nʼam kok Nyam e juma, -nʼam ɛlu Nyam ecʼɛrm bebl a ↄkm ɛgŋ eke bi kok low ŋuŋ a e lís. ");
INSERT INTO adj_vpl VALUES ("RM13_5","075_13_5","ROM","13","5","5","Na sosiɛm ow it eke si kʼɛlum es ɛw ɛsɛl, ɛtŋ ow elm Nyam ecʼɛrm bebl a eke si kʼaru sʼɛgb es a cɛ eci, kↄ eke ɛy e tutr ɛm a, sʼuw any eke ow el low mamn a sosiɛm. ");
INSERT INTO adj_vpl VALUES ("RM13_6","075_13_6","ROM","13","6","6","Ɛtŋ low na sosiɛm yɛji anake bʼɛnmn nɛmpo a. Tasi ɛm a, juma kok ɛsɛl a eke bʼibr ow eci labm a, Nyam in obi abul ɛl ow e juma. ");
INSERT INTO adj_vpl VALUES ("RM13_7","075_13_7","ROM","13","7","7","Ɔ̀ŋn ɛgŋ ɛgŋ fɛŋ yecʼa ekʼit eke ki kokr ↄŋn in a: nɛmpo fɛŋ ekʼit eke ki sↄgr ↄŋn in a, sↄgr ↄŋn in; ke kↄprɛ ekʼit eke ki sↄgr ↄŋn in a, sↄgr ↄŋn in. Eke ow el ɛlum kʼɛlumn ɛgŋ, ɛ̀lumn in. Ɛtŋ ekʼow el sos kʼusar ɛgŋ, ùsar ir sos. ");
INSERT INTO adj_vpl VALUES ("RM13_8","075_13_8","ROM","13","8","8","Kʼↄ̀nymn ɛgŋ kaka ecʼob ab, ekʼow elm erur eke kʼↄnyn ↄny ↄfr ɛm a cɛ e labm. Ɛgŋ yecʼeke bʼerur agŋ ɛjecʼa, kok ol a e low fɛŋ iy nɛny. ");
INSERT INTO adj_vpl VALUES ("RM13_9","075_13_9","ROM","13","9","9","Tasi ɛm a, sol a fɛŋ eke uwr any ɛsɛ: Kʼɛ́jum ŋ e yↄw oglog ŋ ecʼigŋ. Kʼíbim ɛgŋ. Kʼíym mil. Kʼócm nyamn ɛyr ɛm erurm ob ekʼelm ŋ ecʼa, lele ɛjecʼa fɛŋ ab, ↄb okr af anŋ ol nyam na ɛm: Bʼow erur ɛgŋ kaka fɛŋ ɛsɛ ŋ obi af. ");
INSERT INTO adj_vpl VALUES ("RM13_10","075_13_10","ROM","13","10","10","Eke ɛgŋ ↄny erur, li kʼↄtum li kokm ɛgŋ ɛjeci low ŋuŋ, ɛtŋ ɛbɛn a, ow bʼↄŋ wɛl kok ol a e low fɛŋ iy nɛny. ");
INSERT INTO adj_vpl VALUES ("RM13_11","075_13_11","ROM","13","11","11","Ɔny uwr lɛgŋ eke sʼanŋ ɛm ab any: ow el wanci eke kʼufŋmn es ↄny e mɛmn ɛru ab ɛm! Tasi ɛm a, sel ɛŋn a titm ɛy akm lɛgŋ a eke sʼub Krist nawrɛ a. ");
INSERT INTO adj_vpl VALUES ("RM13_12","075_13_12","ROM","13","12","12","Ow kʼow ibnm, lɛgŋ uk bʼow uwr ɛtŋ lɛgŋ owr bʼow ɛy ↄkm. Ow sosiɛm, sʼíil ɛy ecʼów eŋuŋ a fɛŋ eke si bi kok ncok ɛm ab es. Ke si bɛ́bm sos usuayl ɛm ecʼɛb ir eci. ");
INSERT INTO adj_vpl VALUES ("RM13_13","075_13_13","ROM","13","13","13","Sʼíir ɛb low nɛnyɛmbri nyam ɛm, ɛsɛ lɛgŋ owr fitaŋ af: sʼáru ob ij nↄnↄ lele mar ɛgŋ nↄnↄ ab sʼɛgb es. Si kʼágbr lↄsŋn ɛgŋ kaka fɛŋ ab, si kʼír ɛb suksuk kok owi ɛm, ke si kʼánm ów es atar lele uwerŋ ogŋ ab e low ɛm. ");
INSERT INTO adj_vpl VALUES ("RM13_14","075_13_14","ROM","13","14","14","Ànŋn ɛsɛ elel eke Ɛs Kↄtↄkↄ Jesu Krist anŋ ab af. Eke ów aw eŋuŋ a ekʼanŋ ↄny ɛm a bʼerur eke kʼↄdu im ok ↄny low ŋuŋ ɛm, kʼↄ̀ŋan in abusu. ");
INSERT INTO adj_vpl VALUES ("RM14_1","075_14_1","ROM","14","1","1","Ɛ̀gŋn ɛgŋ eke ɛw fuɛfuɛ ↄmn ɛm a ebr, ke kí dadmn low ŋuŋ in e tutr eke li bʼↄny ab af. ");
INSERT INTO adj_vpl VALUES ("RM14_2","075_14_2","ROM","14","2","2","Oglog ke ɛgŋ nyam ↄny tutr eke lʼↄtu e li kʼij ob fɛŋ, ke ɛgŋ ɛjeci nyam eke ɛw fuɛfuɛ ↄmn ɛm a, kʼíjm ndey ke nʼam ij suw obi. ");
INSERT INTO adj_vpl VALUES ("RM14_3","075_14_3","ROM","14","3","3","Ɛgŋ a eke bʼij ob fɛŋ a itm eke kʼifn ɛgŋ a eke íjm ob bɛb a. Ɛtŋ ɛgŋ a eke íjm ob bɛb a itm eke ki jɛj ɛgŋ a eke bʼij ob fɛŋ a e low ok, aŋke Nyam in obi ɛgŋ ebʼr. ");
INSERT INTO adj_vpl VALUES ("RM14_4","075_14_4","ROM","14","4","4","Ŋ, bwo elʼŋ eke ki jɛj Ɛs Kↄtↄkↄ e juma kok ɛs e low ok ee? Ke nʼínym es afr oglog ke lʼɛ́y wus, na in ecʼEs Ɛw Ɛs a e low. Ɛtŋ li bʼow nʼinym es afr, aŋke Ɛs Kↄtↄkↄ ↄny abusu eke kʼucu ↄnyʼn es. ");
INSERT INTO adj_vpl VALUES ("RM14_5","075_14_5","ROM","14","5","5","Ɛgŋ nyam ↄtu ekʼam tutr eke sɛgŋ bɛb ↄny any akm sɛgŋ ɛjecʼa, ke ɛgŋ ɛjeci nyam in am tutr eke -li bɛbmn ɛl fɛŋ. Ow akpl cɛ ekʼɛgŋ ɛgŋ kʼↄny ↄmn tasi ow eke nʼam tutr ab ɛm. ");
INSERT INTO adj_vpl VALUES ("RM14_6","075_14_6","ROM","14","6","6","Ɛgŋ a ekʼam ok ereb sɛgŋ ecʼaraŋn a, am kok ɛbɛn Ɛs Kↄtↄkↄ eci. Ɛgŋ a ekʼam ij ob fɛŋ a, am kok ɛbɛn Ɛs Kↄtↄkↄ eci, aŋke li bʼↄŋ Nyam bia in ecʼob ij a eci. Ɛtŋ ɛgŋ a ekʼíjm ob fɛŋ a, am kok ɛbɛn Ɛs Kↄtↄkↄ eci, aŋke in yɛji li bʼↄŋ Nyam bia. ");
INSERT INTO adj_vpl VALUES ("RM14_7","075_14_7","ROM","14","7","7","Ɛy ɛm a, ɛgŋ kaka ánm owr in obi eci, ɛtŋ ɛgŋ kaka úwm in obi eci. ");
INSERT INTO adj_vpl VALUES ("RM14_8","075_14_8","ROM","14","8","8","Eke sʼanŋ owr, ke Ɛs Kↄtↄkↄ eci sʼanŋ owr, eke sʼam uw, ke Ɛs Kↄtↄkↄ eci sʼam uw. Fɛŋ ɛm a, sʼel Ɛs Kↄtↄkↄ eci. ");
INSERT INTO adj_vpl VALUES ("RM14_9","075_14_9","ROM","14","9","9","Ɛɛ, Krist uw ɛtŋ nʼanŋ luw ɛm lʼigb, yecʼɛtŋ ke lʼɛ́w agŋ a fɛŋ ekʼubʼr nawrɛ ab es, ɛl a eke uw lele ɛl a eke anŋ owr ab ab. ");
INSERT INTO adj_vpl VALUES ("RM14_10","075_14_10","ROM","14","10","10","Kↄ ŋ, bla sosiɛm am jɛj esŋ jim e low ok ee? Ɛtŋ ŋ gbɛ, bla sosiɛm am ifn esŋ jim ee? Tasi ɛm a, ɛy fɛŋ si bʼow sʼim Nyam ecʼany af, ke li jɛ́j ɛy e low lʼok. ");
INSERT INTO adj_vpl VALUES ("RM14_11","075_14_11","ROM","14","11","11","Nyam Lɛl ɛm wɛl nↄn: Ɛm, Ɛs Kↄtↄkↄ ekʼanŋ owr, mʼam ij nɛny mʼɛsɛ: ob ob pupukpaŋ bʼow ok ↄwrↄkp wus ɛm ecʼany af ɛtŋ ɛl fɛŋ -li bʼow 