﻿USE sofia;
DROP TABLE IF EXISTS sofia.acuNT_vpl;
CREATE TABLE acuNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acuNT_vpl WRITE;
INSERT INTO acuNT_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Nunangkamtaik mash atsuinai, Yuska nayaimpincha tura nungkancha mash najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Antsu nungkaka juun entsajai pachimnaikiau ayayi. Juun entsaka aya kuna ayayi. Turasha aya tee ayayi. Tura asamtai Yuse Wakani juun entsa yakiinini atu wee, tura ataksha juni wini, tu nanaaki pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Nuniangka Yus chichaak: —Paantin ati —tamati, paantin wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Tura asamtai Yus paaniun wainak: —Pengkeraitai —timiayi. Tura asa paaniuncha tura teencha akankamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Tura paaniunka tsawai inaikiamiayi. Tura teenka kashi inaikiamiayi. Nu najankamunam kichik kinta kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Nunia Yus chichaak: —Yakiiya yumi juun entsajai akankamu ati, —timiayi. Yus tamati, nunisang turunamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Tura asa nungkaka juun entsa amurmau ati tusa Yus akankamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Nunia Yus chichaak: —Ju angkakuka nayaim tutai ati —timiayi. Nu najankamunam jimiar kinta kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Nunia Yus ataksha chichaak: —Entsa nungkan amurua juka kuyuati, tura nungka mujurti, —Yus tamati nunisang turunamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Tura Yus chichaak: —Mujukash wajasa juka nungka tutai ati, tura entsa iruntrarua juka juun entsa tutai ati —timiayi. Tura nuna mash umis jiis Yus: —Pengeraitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Tura chichaak: —Arak ainau tura numi ainausha niish niish nungkanam tsapainiar nerekarti, —Yus tamati nunisang turunamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Tura asa nungkanmaka árak ainau tura numi ainausha araachmaitiat, ningki tsapainiar nerekarmiayi. Tuminamtai Yus nuna mash jiis: —Pengkeraitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Nu najankamunam tres kinta kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","15","Nunia Yus chichaak: —Tsawai tsantratnuka tura kashi tsantratin ainausha nayaimpinam keemsarti. Musach, tura nantu tura esat atincha, tura yumi jeatniusha paan nekaatisha iruniarti, —timiayi. Yus tamati nunisang turunamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Tura asamtai Yus tsantratniun jimiaran najanamiayi. Tsawai kakaram tsantratniun timiá juuntan najanamia nuka tsaayaitai. Tura kashi mushatmin kapaa nuka nantuitai. Tura yaa ainauncha najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","18","Tura tsawaisha tura kashisha tsantrarti tusa, Yus ni najanamu ainaun kentsamiayi. Nujai tsawaartincha, tura kintamratniuncha paan nekaawarti —tusa turuamiayi. Tura nuna mash jiis: —Pengkeraitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Nu najankamunam cuatro kinta kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Nunia ataksha Yus chichaak: —Entsanam matsamsatin ainauka tura nanamtin ainausha nungkanam yujararti, —tamati nunisang turunamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Tura asa entsa kanajin matsaminauncha, tura nanamtin ainauncha Yus najanamiayi. Tura najana umis, jiis: —Pengeraitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Tura entsanam matsamin ainaun chicharak: —Nukap yujartaram, turasha juun entsasha netkataram. Tura nanamtin ainausha mash nungkanam yujararti, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Nu najankamunam cinco kinta kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Nunia Yus ataksha chichaak: —Mash nungkanam wekain ainauka yujararti. Kuntin yutai ainauka tura tangku ainausha, tura pachim namangken yu ainausha, tura netsepejai nungkanam wekain ainausha niish niish mash nungkanam yujararti, —Yus tamati nunisang umikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Tura nuna mash umik, Yus nuna jiis: —Pengkeraitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Nunia Yus chichaak: —Yamaikia iiya tumau ati tusar, aincha najanami. Tura nu aintska namak ainaun, tura nanamtin ainauncha, tura tangku ainauncha, tura pachim ainauncha, tura netsepejai nungkanam wekainauncha mash inarti —tusa, Yus aintsun najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Tura aints atsau asamtai, Yus niiya tumaun aintsun najanak, aishmangkun tura nuwancha najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Tura najana umis, pengker awajsatas chicharak: —Nukap yujartaram. Tura mash nungka ainaun netkataram. Tura namak ainau, tura nanamtin ainausha, tura tangku ainausha, tura netsepejai wekain ainausha nepetkau ataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Nunia Yus aintsun, tura nuwancha chicharak: —Anturtuktaram, arakrintin ainaun tura numi jingkiajintin ainauncha mash atum yuwataram tusan suajrume. ");
INSERT INTO acuNT_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Tura pachim ainau, tura nanamtin ainau, tura netsepejai wekain ainausha numi nereen, tura nupaa ainauncha yuwarti tusan suajai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Tura ni najanamurin mash jiis: —Nekas pengkeraitai —timiayi. Nu najankamunam seis kintan kintamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Yus nayaimpincha, tura nungkancha tura nuni mash iruna nuna tu najanak umismiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Tura ni najanamurin seis kintan umisu asa, nu najankamunam siete kinta tsawaarmaunum Yus ayamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Tura nu kintatin mash najana umis ayamrau asa, nu kintan pengkermamtikiamiayi. Tura asamtai chichaak: —Ju kintaka ayamratin kinta asamtai, mash aints ainausha wina nintimtursarti tusan pengkermamtikjai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Yus nayaimpin tura nungkancha tu najanamiayi. Ii Apuri Yus nayaimpin tura nungkancha najanak, ");
INSERT INTO acuNT_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","yumin jitumtikchau asamtai, kichik numiksha, tura áraksha atsuarmiayi. Tura aintsnasha najanachmauyayi. Tura asamtai nuni takakmastincha atsuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Turayat yurangkim nungkanmaya takuni mash nungka ainaun sanamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Nunia ii Apuri Yus nungkan juki, aishmangkun najanamiayi. Tura ni nujin umpui mayajin engketa, iwiaaku ati tusa awajsamiayi. Tura Yus ni mayajin engketamtai, iwiaaku wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Nunia ii Apuri Yus tsaa winitinmanini nungka Edén tutainum ajan umis, nu aishmangkun nuni pujsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Tura numi nekas pengker aina nuna tsapamtikiamiayi. Nunia yurang ainaun neremtikiamiayi. Nunia nu aja japen nushaa numi jimiaran awajsamiayi. Kichik numi yurangken yuwinaunka pujut nangkaakashtinun sukartinuyayi. Tura chikich numi yurangken yuwinaunka pengker aina nuna, tura tunau aina nunasha nekaawartin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Tura Edén nungkanmaya entsa tsapuimiayi. Tura nu entsa tsengkeak-mauringkia nu ajanam ukatmiayi. Nunia cuatro entsa tsengkermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Entsa yamai nangkamchak tsengkeakuka Pisón naartinuyayi. Nu entsaka nungka Havila tutainum kuri amaunum nuni iruna nuna teenkauyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Nu nungkanmaya kuri timiá pengkeraitai. Tura nu nungkanmaya numi bedelio tutai aina nuna numpe nekas kungkurmaitai. Tura kaya ónice tutaisha irunniayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Tura chikich entsa tsengkeakmauka Gihón naartinuyayi. Tura nu entsaka nungka Cus tutainum teenkawaitai. ");
INSERT INTO acuNT_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Tura chikich entsaka Tigris naartinuyayi. Nu entsaka tsaa winitinmanini nungka Asiria tutainum awai. Tura chikich entsaka Eufratis naartinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Nunia ii Apuri Yus nu nungka Edén tutainum aishmangkun chicharak: —Ju nungka juka ame takakmakum wainkata tusan suajme. ");
INSERT INTO acuNT_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Tura asamtai numi iruna juna nere mash yuwamnawaitme. ");
INSERT INTO acuNT_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","Antsu kichik numi aa nuka tunaun aina nuna nekamtikin asa, nuna nerengka yuwashtinuitme. Nu yuwakmeka nekas jakatatme tajame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Nunia ii Apuri Yus chichaak: —Aishmang ningki pujakka pengkerka pujatsui. Tura asamtai chikich yaingtin niijai tsanias pujusti tusan najatatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","20","Kame, Apu Yus kuntin ainaun tura nanamtin ainauncha mash najanak, ni inairati tusa, aishmang Adán naartinnum ikiankamiayi. Turamtai tangku ainaun, tura nanamtin ainauncha, tura pachim ainauncha mash, ni naari tu ati tusa inairamiayi. Tura asamtai Adán inairamia nu naartinuk tuke ainawai. Antsu niin yaingtinun niya tumaunaka pengké wainkachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Tura asamtai Apu Yus Adánkan kanurti tusa kiantramiayi. Kanuramtai ni namangken nitkayan pajen juruki, ataksha achimtuamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Tura nu pajen achik, Apu Yus nuwan najana, aishmangkun inaktusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Turamtai nuna wainak Adán chichaak: —¡Maj, juka nekas wina namangkruitai. Turasha nekas wina ukunchruitai! Wina namangkrunia jukimu asa, nuwa tutai atinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Yus nuna turau asamtai, aishmang ni aparin tura nukurincha ukuki, nuwarijai tsaning, jimiaraitiat kichkia nunisang atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Tura Adán ni nuwarijai mai misu pujuinayat natsannaicharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Apu Yus mash najankamia nuna nangkamasang napi timiá anangkartin asa, nuwan jeari iniak: —¿Numi ajanam mash nerekar wajaina nu kichkiksha yuwairap Yus turamiakuram? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Tama nuwa ayaak: —Atsa, numi ajanam wajaina nuna yurangkenka mash yuwatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","Antsu Yus iin chichartamak: Numi aja japen waja au yurangkenka yuwairap tura takasairap jakairam turammaji —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Tama napi nuwan chicharak: —Atsa, jakashtatrume. ");
INSERT INTO acuNT_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Antsu au yuwarmeka Yusjai metek pengker aina nuka tura tunau aina nusha mash nekaatnuitrume. Tura Yus nuna nekau asa suritramarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Tamati nuna antuk, nuwasha numin jiij pujurmiayi. Tura nintimias: —¡Nekas shiirmapita! Juna yuwanka Yus neka nunasha nekaawainjapi —tusa numi yurangken wakerak akak yuwamiayi. Tura: —Amesha yuwata —tusa aishrincha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Tura nuna yukama, shintarua nunisarang misu wajainau wainmamkar, mai higo nuken jukiar peawartas aparmararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Tura tsaa jeak mikianmati, Apu Yus ajanam wekaamun antukarmiayi. Tura asaramtai shaminak, iin waitmakai tusar numi untsuri wajainamunam anumkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Tura Yus nekayat Adánkan untsuak: —¿Aishmangkua, tunia pujame? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Tama Adán ayaak: —Ame ajanam wekaamun nekaan, misu asan shamkartakun anumkajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Tama Yus iniak: —¿Ya amin misuwaitme turama? ¿Numi yurangken yuwaip timiajmena nu yuwachumek? —tu iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Tama Adán ayaak: —Nuwarmijai tsaniasam pujusta tusam surusmame nu numi yurangken surusamtai yuwajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Tamati Apu Yus nuwan iniak: —¿Warukamtai antutskesha yuwame? —timiayi. Tu iniam nuwa ayaak: —Napi anangkruamtai yuwajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Tamati Apu Yus napin chicharak: —Ame ju aitkau asam, chikich wi najanamu ainaun nangkamasmek ameka yumingkramu atatme. Tura asam yamai nangkamsam netsepmijai wekain atatme, tura nungka tsetserin yuu atatme. ");
INSERT INTO acuNT_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Tura asam nuwajai tuke nemasnaikiatnuitme. Tura ami wearam ainauka nuwa weari ainaujaingkia tuke nemasnaikiartinuitai. Tura ni weari ainauka muukmin najatmin artinuitai. Tuminamtai ami wearam ainauka ni sangkanin esau artinuitai, —Yus napin timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Tura nuwan chicharak: —Ameka japrukmesha wait wajau atinuitme. Tura uchi jerertasam jatemam nukap najaimin atinuitme. Turayatum aishrumjai tuke pujutka wakeritatme. Tumamning aishrum inatmin atinuitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Tura aishmangkun Yus chicharak: —Nuwarmi chichame umirkum: Nu numi yurangke yuwaip tusan timiaja nu yuwau asakmin, wina chichamur umirkachmaurmijai nungkaka pase yumingkramu atatui. Tura asamtai iwiaaku pujakum, tuke wait wajakum kakaram takakmakum nungkanmaya arak tsapaitin ainau yu atinuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Turamin wainiat jangkisha tura narasha nukap tsapau artinuitai. Turamtai saatnum yurang iruna nu yuwatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Tura kakaram takakmakum searam yutairam yu atinuitme. Tu pujakum jakatnuitme. Ameka nungka jukir najanamu asam, jaakmesha ataksha nungka najanartinuitme, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Adánka ni nuwarin Eva inaikiamiayi. Evaka mash aintsu nukuri atin asamtai, tu inaikiamiayi. (Evaka iwiaaku taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Tura Adán ni nuwarijai mai misu asaramtai, Apu Yus kuntinun maa, nuwapen juki, mai kachumawarti tusa, Adánkan tura Evancha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Nunia chichaak: —Ju aintska iiya nunisarang pengker turatniun tura tunaun takastinasha mash nekawai. Tura asa numi tuke pujutan sukartinua nuna yurangken akak yuwak tunaarintin ayat tuke iwiaaku pujustinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Nuna turunawai tusa, ii Apuri Yus Adánkan Edén ajanmaya jiiki: Nungka najanamu asa, nungkanam takakmasti tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Nunia numi tuke pujutan sukartinua nuna yurangken aints kichkisha yuwai tusa, tsaa winitinmanini Yus ni awemamurin nanamtin ainau Edén ajanka wainkarti tusa akupkamiayi. Turamtai saapi jiya tumau kapaun takusar peret jintan waikmawar kirtuawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Nunia Adánka ni nuwarin japrumtikiamiayi. Turam japruk uchi eemkaurin Caín naartinun jurermiayi. Tura Eva chichaak: —Yus surusu asamtai aishmangkun jurerjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Tura ukunam Evaka Caínka yachiin Abelan jurermiayi. Abelka tsakar ovejan wainuyayi. Tura Caínka tsakar ajan takauyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Tura ukunam Caín Yusen warinak susataj tusa, ningki nintimias ni ajarinia arak ainaun juuk: —Ainchiksha Yusen susataj —tusa epeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Tura Abelsha Yusnasha warinak susataj tusa, oveja timiá pengkeran nekas jaerun, eemak akiiniaun ainaunka achik maa, Yusen susatas epeamiayi. Turamtai Yus Abelan pengker nintimtusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Antsu Caínnaka pengkerka nintimtuschamiayi, tura ni susamurinka jiis, pengkerka awajsachmiayi. Tura asamtai Caínka napchau nintimiar yachiin kajerkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Turamtai Yus Caínkan chicharak: —¿Waruka napchau nintimsamsha kajekume? ");
INSERT INTO acuNT_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Ame pengker nintimsam pujakmeka, pangkaim jiirsainme. Antsu napchau nintimsam pujakmeka, tunau amin nepettamkatas wakerutmawai. Tura wainiatum ame wakerakmeka, tunauka nepetkatnuitme, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Yuska tamaitiat jumchik arus Caín yachiin chicharak: —Ajanam iijai wemi —timiayi. Tamati Abel ayu tusa yachiijai ajanam wemiayi. Tura jea Caín yachiin awati maamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Caín yachiin mau asamtai Yus Caínkan iniak: —¿Yachim tuning puja? —tu iniam Caín ayaak: —Chaa, nekatsjai. ¿Wikia yatsurun wainukitaj? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Tamati Apu Yus chicharak: —¿Waruka aitkame? Yachimi numpe nungkanmak ukarmaun paan wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Yachim mau asakmin yumingkramuitme. Tura asam ju nungkanam yachimi numpe ukarmame ju nungkanmayanka amin jiikin akupajme. ");
INSERT INTO acuNT_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Ame aja tuke takaa takakmakam pujayatum, arakrumka pengké nerekchatnuitai. Tura asamtai ayamtsuk aya tuke wekain atinuitme —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Tama Caín Yusen chicharak: —Wikia timiá wait wajaktinnaka pengké atsantrachminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Yamaikia ju nungkanmaya jiirkin asam, pengké ayamtsuk jeachat aya wekain atinuitme turutme. Tura asakmin aints wina eatkar pachitsuk mantuawartinuitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Tamaitiat Apu Yus ayaak: —Atsa, turutmachartinuitai. Antsu amin mantaminamtaikia siete wait wajaktintrin susatnuitjai —timiayi. Nunia aints ainau maawarai tusa, Apu Yus Caínkian maachmin awajsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Tura Caín Yusjai chichas Edénnumia jiinki, tsaa winitinmanini nungka Nod tutainum pujustas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Caín nuwan nuwatkau asamtai, nuwari japrukmiayi. Tura uchirin jureramtai, naari Enoc inaikiamiayi. Ukunam Caín yaktama nu yaaktanka ni uchiri naarinak inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Enocka Iradta apari ayayi. Tura Iradka Mehujaela apari ayayi. Tura Mejujaelka Metusaela apari ayayi. Nunia Metusaelka Lamecka apari ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Lamecka nuwa jimiaran nuwatkamiayi. Chikich nuwaringkia Ada naartinuyayi. Chikichka Zila naartinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Tura Adaka Jabalan jurermiayi. Tura nuna weari ainauka nuwap jeanam pujusar vaca wainin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Jabala yachiingkia Jubal naartinuyayi. Nuna weari ainauka arpan awatin tura nagkun umpuin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Lamecka nuwari Zila naartin uchin Tubal-caín naartinun jurermiayi. Tubal-caínka jiru bronce tutain, tura chikich hierro tutaincha takakminuyayi. Tubal-caín umaji Naama naartinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Chikich kintati Lamec ni nuwari Ádan tura Zilancha chicharak: —Wi titatjarme nu pengker anturtuktaram. Aints natsa wina ijuti numpturu asamtai maamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Yus Caín chicharak: Amin mantamunka siete wait wajaktintrin susatnuitjai timiayi. Tura wina mantuawaramtaikia nuna nangkamas setenta y siete yapaijkiartin ainawai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Nunia Adánka nuwari Eva ataksha japruk, chikich uchin jurermiayi. Tura nintimias: Caín nii yachiin Abelan mau asamtai, yamaikia Yus chikich uchin surusi tusa, uchirin Set inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Tura Setcha uchin yajutmarmia nuna Enós inaikiamiayi. Nuniangka aints ainau Apu Yuse naarin pachisar seatan nangkamawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Adánka weari naari ainau juni aarmawaitai: Nunangkamtaik Yus aintsun najanamia nunaka niiya tumaun najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Tura aishmangkun nuwajai najanak pengker awajsamiayi. Tura “aints tutai” artatui —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Adán ciento treinta musach pujamtai, uchiri niiya tumau akiinamiayi. Turamtai naari Set ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Tura Set akiinamia nuni Adán ochocientos musach pujumiayi. Tura asa uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Tura mash irumram Adánka novecientos treinta musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Tura Setka ciento cinco musach pujamtai ni uchiri Enós naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Nunia ataksha ochocientos siete musach pujus, chikich uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Kame, mash irumram Setka novecientos doce musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enos noventa musach pujamtai, uchiri Cainán naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Nunia ochocientos quince musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Kame, mash irumram Enóska novecientos cinco musach jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Tura Cainán setenta musach pujamtai, uchiri Mahalaleel akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Nunia ataksha ochocientos cuarenta musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Kame, mash irumram Cainán novecientos diez musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Tura Mahalaleel sesenta y cinco musach pujamtai, Jared akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Nunia ataksha ochocientos musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Kame, mash irumram Mahalaleel ochocientos noventa y cinco musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Tura Jared ciento sesenta y dos musach pujamtai, uchiri Enoc naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Nunia Jared ataksha ochocientos musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Kame, mash irumram novecientos noventa y dos musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Tura Enoc sesenta y cinco musach pujamtai, uchiri Matusalén akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Tura Enocka Yuse wakeramurin tuke turinuyayi. Tura Matusalén akiinamtai, trescientos musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Enocka pujusmauri mash irumram trescientos sesenta y cinco musach pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Enocka Yuse wakeramurin tuke turin asa, chikich kintati Yus iwiaakunak jukimiayi. Tura asamtai aya mengkakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Tura Matusalén ciento ochenta y siete musach pujamtai, Lamec akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Nunia setecientos ochenta y dos musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Tura mash irumram novecientos sesenta y nueve musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Lamec ciento ochenta y dos musach pujamtai, uchiri akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Tura nuna naari Noé ati tusa timiayi. Tu inaikiamu asa chichaak: —Apu Yus nungkan yumingkrau asamtai, iikia kakaram takakmakur wait wajaji. Tura wainiat ju uchikia iinka ayamtikramratnuitji, —timiayi. (Kame, Noé ayamtikramratin taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Noé akiinamia nuni Lamec quinientos noventa y cinco musach pujus, uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Tura mash irumram setecientos setenta y siete musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Noé quinientos musach pujus, ni uchiri Sem, tura Cam tura Jafet naartinun yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Aints ainau nukap yujar, ni nawantri ainaun untsuri nawantrumrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Tura Yuse uchiri ainau aintsu nawantrin wainkar, ni wakeramun pachitsuk nuwatkaru armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Tuminamtai Apu Yus chichaak: —Aints timiá untsuri musach pujusarti tusanka yamaikia nakitajai. Antsu tunaun timiá untsuri takainau asaramtai, aya ciento veinte musach pujusarti —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Yuse uchiri ainau aintsu nawantrin nuwatkaru asaramtai, ni uchiri ainau nekasar nayau tsakararmiayi. Nu nungkanmaka nu aints ainauka nekasar kakaram tura pengké shamchau asar, ni wakeramurin pachitsuk najanin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Tura aints juun tunaun untsuri turinak, tuke tunau nintimsar pujuinau asaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Apu Yus nintimias: —Pengké nangkami aintsun najanamiajai —tusa, wake mesek ");
INSERT INTO acuNT_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","chichaak: —Aints ainaun tura pachim ainaun, tura kuntin ainauncha, tura netsepejai wekain ainauncha tura nanamtin ainauncha mash amuktatjai. ¿Warukanak aintsarang arti tutsuksha najankaya? ¡Nunaka pengké nakitajai! —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Antsu Noéka Yusen pengker nintimas umirkau asamtai, wait anentramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Kame, mash aints ainaujai apatkam jiisam, Noéka ningki nekas pengke aints ayayi. Tura asa ningki tuke Yuse wakeramurin najanak niin umirnuyayi. Watska, juwaitai Noé turamuri: ");
INSERT INTO acuNT_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Noé uchiri tres armiayi. Nuka Sem, nunia Cam, nunia Jafet armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","12","Kame, mash nungkanam pujuinaun Yus jiis, tuke tunaun takainaun tura maaninak pujuinaun wainkau asa, ");
INSERT INTO acuNT_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Noén chicharak: —Yamaikia mash nungkanam aints ainau pujuina nuka tuke maanikiar, ni tunaari ainaujai nungkan mesraru asaramtai, aints ainaunka ni nungkarijai metek amuktatjai. Antsu ningki wiasmatmamkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Tura asaramtai ameka numi wári mamurchamniau eakam, juun kanu najanam, yakiirisha tau ainaujai nukukam, nitkarin tesarta. Tura entsa utuawai tusam nitkarisha, tura aarisha pengker sekatrata. ");
INSERT INTO acuNT_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Kanu esanti ciento treinta y cinco metros ati. Tura wangkantisha veintidos metros nunia japchiri ati. Tura yakiiri trece metros nunia japchiri ati. ");
INSERT INTO acuNT_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Tura pata ainau tres najanata. Tura paantin ati tusam, wenurmau angkaakurincha yakí patanam nukukmaunmaya metro japchiri chingkiata. Tura kichik yantamen waaiti najanata. ");
INSERT INTO acuNT_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Tura nu umisakmin yumi nukap jitumtikratatjai. Tura asamtai mash nungkanam pujuinauka kajinkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Antsu amijai chichaman najanatatjai. Ameka ami uchiram ainaujai, tura nuwarmijai, tura najatmijai juun kanunam engkemaatatrume. ");
INSERT INTO acuNT_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Turakrum mash nungkanam kuntin tura pachim iruna nusha aishmang nuwajai apatkam, amijai metek iwiaaku pujusarti tusam engkeawarta. ");
INSERT INTO acuNT_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Tura mash nanamtin ainausha, tura tangku ainausha, tura netsepejai wekain ainausha iwiaaku pujusarti tusam, aishmang nuwajai apatkam engkeawarta. ");
INSERT INTO acuNT_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Turakrum tsukajai wait jakarai tusam, ni yuwatniurisha, tura atumi yutairisha mash chumpiata, —Yus tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Tamati Yus timia nunisang Noé mash umismiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Turamtai Yus Noén chicharak: —Mash aints ainau yamai matsatina nunia amek wi wakeramurka metek umikume. Tura asakmin yamaikia ami jeemin matsatina nujai juun kanunam engkemataram. ");
INSERT INTO acuNT_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Tura asam mash kuntin yutai ainauka aishmangkrisha siete tura nuwasha siete irumram chumpiata. Antsu yuchatai ainauka aishmang nuwajai apatkam nuke engkeawarta. ");
INSERT INTO acuNT_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Tura nanamtin ainausha aishmangkrisha siete tura nuwarisha siete irumram engkeawarta. ");
INSERT INTO acuNT_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Kame, siete kinta nangkamaramtai, yumin jitumtikratatjai. Nunia cuarenta kinta tsawaisha tura kashisha yumin jitumtikratatjai. Tura asamtai wi najankamu ainau nungkanam matsatina nuka mash kajingkiartatui, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Tura Yus timiaun Noéka miatrusang umikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Nujang nungkan amurmia nuni Noé seiscientos musach pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nunia yumi jitur nujangkruatin asamtai, Noéka ni uchiri ainaujai tura nuwarijai tura najati ainaujai uwemrami tusar, juun kanunam engkemawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","9","Tura mash nungkanam wekain yutai ainau tura yuchatai ainausha, nanamtin ainausha, tura netsepejai wekain ainausha, aishmangkri nuwarijai apatkar Yus timia nunisarang juun kanunam engkemrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Tura mash engkemawaramtai, siete kinta nangkamaru aing, Yus yumin jitumtikramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Noé seiscientos musach pujai, nu musachti kichik nantu nunia diecisiete kinta nangkamaru aing, Yus nayaimpinmaya yumin tuna tumaun akupkamiayi. Tura nungka nitkarinia entsa tsapuiniarti tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Tura asa cuarenta kinta tsawaisha tura kashisha chiwiatsuk Yus yumin chij jitumtikramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Yumi jiturtin nangkamamtai, Noéka ni nuwarijai, tura uchiri Sem, Cam, nunia Jafetjai, tura ni najati tres ainaujai juun kanunam engkemawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","15","Tura nijai tsaniasar pachim ainausha, tura tangku ainausha, tura netsepejai japinas wekain ainausha, tura nanamtin ainausha mash jimiarchik jimiarchik engkemawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Kame, Yus timia nunisarang aishmangri nuwarijai jimiarchik jimiarchik engkemawaramtai, Apu Yus juun kanu waitirin epenmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Turamtai cuarenta kinta yumi nangkantsuk jituramtai, nujang nujangkrak juun kanu kukar tepaun wampumamtikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Nujang nangkantsuk nujangkruamtai, juun kanuka entsa japen nanaasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Maj, timiá nujangkrau asa, nujang mura ainaun mash amurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Tura mash amur tuke siete metros nangkakimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Turunamtai aints ainauka mash kajingkiarmiayi. Tura nanamtin ainau, tura tangku ainau, tura pachim ainau, tura netsepejai japinas wekain ainausha nunisarang mash kajingkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Kame, mash nungkanam matsamin ainauka kajingkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Tura wainiat Noéjai juun kanunam engkemawaru ainauka uwemrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Tura ciento cincuenta kinta nujang nungkan amur kuyutsuk pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Tura Noénka juun kanunam niijai mash pujuarmia nuna Yus kajinmatsuk nintimtusmiayi. Tura asa nujang kuyuati tusa, nasen akupkamiayi. Turamtai kuyutan nangkamamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Tura yumi jitamuka paparmiayi. Tura nungkanmaya entsa ainau jiintrarmia nuka nangkankarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Nunia yaitas kuyuki weak, ciento cincuenta kinta tuke kuyuki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Tura seis nantu nunia diecisiete kinta nangkamaramtai, juun kanuka mura Ararat tutainum patamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Tura diez nantua nuna yamai nangkamtaik tsawaamunam mura tsakari ainau tsapuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Tura ataksha cuarenta kinta nangkamaramtai, Noé wenurmau angkaakurin jiimsatas uraimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","Tura urai, nujang warukawak, kuyuawash tusa nekaatas shanashnan jiiki akupkamiayi. Turam entsa kuyuachiash tusa, nanaki wee, tatsuk tuke mengkamakiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Turamtai ataksha entsa kuyuawash tusa nekaatas, yapangman jiiki akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Antsu kuyuachu asamtai, nusha nanamas weka wekaaka, keemsatatkama tujintak ataksha waketki taamtai, Noé uwejen kutsmar nuni keemsamtai, ataksha juun kanunam engkeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Nunia siete kinta nangkamaramtai, Noé ataksha yapangman jiiki akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Turam kiarai olivo nuken iju itamiayi. Turamtai yamai kuyuawapi tusa Noéka nekaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Tura siete kintan nakas yapangman ataksha akupkamiayi. Antsu akupkamaitiat nuniangka tachamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Noé seiscientos un musachrintin ai, nungkaka mujukash jakmiayi. Tura nunangkamtaik nantua nu kinta tsawaamunam Noé kanu nukukmaurin urai, nungkan jiis: Mujukashitai tusa nekaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Tura jimiar nantua nuni veintisiete kinta jeamtai, nungkaka mash mujurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Nunia Yus Noén chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","—Yamaikia nuwarmijai, tura uchiram ainaujai, tura najatim ainaujaisha juun kanunmaya jiinkitaram. ");
INSERT INTO acuNT_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Turaram kuntin ainau, tura tangku ainausha, tura nanamtin ainausha, tura netsepejai japinas wekainausha mash nungkanam wekaasar yujararti tusam jiirarta, —tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Tama Noé nuwarijai, tura uchiri ainaujai, tura najati ainaujai jiinkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Tura asar tangku ainau tura tangkuchu ainausha, tura netsepejai japinas yujau ainausha tura nanamtin ainausha jiintrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nunia Apu Yusen pengker awajsatas Noéka tangku epeatniurin najanamiayi. Tura vaca uchirin, tura oveja uchirincha, tura yapangmancha achik maa epeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Turamtai Apu Yus nuna kungkurmarin nekaper, Noén pengker nintimtusmiayi. Tura chichaak: —Aints ainau uchichitiatang tuke pase nintimin iruninawai. Tura wainiatun nungkanam pujuinaunka nujangjai amukchartinuitjai. Tura kuntin ainauncha nunisnak amukchartinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","Nungkaka meseatsaing, árak araatnusha, tura juuktincha tuke atinuitai. Tura esatcha atinuitai. Tura tsetseksha michasha tuke atinuitai. Yumisha jiturtinuitai. Tura seekisha atinuitai. Tura tsawai paaniusha, tura kashi teeka tuke atinuitai, —Apu Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Yus Noén tura uchiri ainauncha pengker awajsatas chicharak: —Uchi yajutmakrum tura nawantrumraram nukap yujartaram. ");
INSERT INTO acuNT_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Mash nungkanam kuntin ainau, tura kuntinchau ainausha, tura nanamtin ainausha, tura entsanam yujainausha nepetkatin asakrumin, atumin shamraminak kurartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Yamaikia kuntinu namangke tura árak ainausha wakerakrumka pachitsuk yuwamnawaitrume, tusan tsangkatkatatjarme. ");
INSERT INTO acuNT_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Antsu kuntinu namangke numpentuk pengké yuwashtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Aints chikichan maamtaikia, tura yukartin aintsun maamtaisha, wi yapaijkiatatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","Kame, wiiya numamtinak aintsnaka najanamiajai. Tura asamtai aints chikichan maamtaingkia, niisha nunisang maamai atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Antsu atumka nukap yujaarum mash nungka ainaun netkataram, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Nunia Noén tura uchiri ainauncha chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","—Anturtuktaram. Atumjai tura atumi weari ainaujai yamai chichaman najanatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Nunia juun kanunmaya atumjai jiinkiarmia nujaisha nanamtin ainaujai, tura namangken yuchau ainaujaisha, tura namangken yu ainaujaisha, mash nungkanam yujaina nujaisha chichaman najanatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Wi tajarme nunaka pengké yapajiashtatjai. Mash nungkanam pujuinaunka nujangjaingkia ataksha pengké amukchatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","13","Nekasan tajarme tusan, atumjai tura mash nungkanam iruna nujai chichaman najanamunka pengké yapajiashtinuitjai tusan, tungkiangkun yurangminam pujsatatjai. Tura asamtai tungkiang jiisrum, pengker nintimsaram pujustaram tajarme. ");
INSERT INTO acuNT_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Tura wi tajarme nuka kajinmatkiram tusan, yurangminam tungkiangkun pujsatatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","Wi turau asan, ju chichamnaka pengké kajinmakchatnuitjai. Tura mash nungkanam matsatina nusha ju chichamnaka nintimrartinuitai: Wikia ataksha nujangjaingkia nungkanka pengké mesrashtinuitjai tajarme. ");
INSERT INTO acuNT_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Tungkiang yurangminam pujamtaikia, nuna jiisan, mash aints ainaujai tura mash nungkanam yujau ainaujaisha chichaman najanamiajana nunaka kajinmakchatnuitjai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Ayu, wi tuke —pengké turashtinuitjai tusan, mash aints ainaujai, tura mash nungkanam matsatina nujaisha chichaman najanaja juka kajinmatkirap tusan, tungkiangkun yurangminam pujsatatjai tusan, Yus asan nekasan tajarme, —tusa Yus Noén timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Noé ni uchiri ainaujai juun kanunmaya jiinkiarmia nuka ju armiayi: Sem, Cam, tura Jafet. Camka Canaánka apari ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Noé uchiri tres armia nuka ni weari ainaujai mash nungkanam yujartin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Tura Noéka arakan arakmatan nangkama uvancha arakmakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Tura nu arakmaunumia uva ainaun juuk, uva yumirin kariaun umur nampek, nii jeen nuwap najanamunam japen misu kanur tepesmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Turamtai Canaánka apari, Cam naartin aa nuka, apari misu tepaun wainak, aanam jiinki yachii ainaun ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Tura ujakam Sem Jafetjai apari misu tepaun jiitan nakitinau asar, tarachin jukiar yakajin awangkeasar jukiar, yajá jiimsar aparin nukukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nunia Noé nampekmaurin tsaar nantaki, uchiri Cam misu tepau wainkamun nekaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","Turamtai Canaánkan pachis chichaak: —¡Canaánka yumingkramuitai! Nuka chikich inati nangkamasang ni yachii ainaun inatiri atinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nunia chichaak: —Semnaka wina Yusur yaingti. Antsu Canaánka ni inatiri ati —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Tura Jafetan pachis chichaak: —Jafetnaka Yus pengker awajsati, tura Sem pujamunam apujsati. Turamtai Canaánka ni inatiri ati, —tusa Noé timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Nu juun nujang nangkamaramtai Noéka trescientos cincuenta musach iwiaaku pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Kame, mash irumram novecientos cincuenta musach pujus jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Juun nujang nangkamarmia nunia Noé uchiri Semka, tura Camsha, tura Jafetcha ni uchiri ainaun yajutmararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ni weari ju armiayi: Jafeta uchiri ainau Gomer, Magog, Madai, Javán, Tubal, Mesec, tura Tiras armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Tura Gomera uchiri ju armiayi: Askenaz, Rifat tura Togarma. ");
INSERT INTO acuNT_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Javána uchirisha ju armiayi: Elisa, Taris, Quintim tura Rodanim. ");
INSERT INTO acuNT_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Kame, Jafeta weari nu aints armiayi. Nuka juun entsa kaanmatkarin puju armiayi. Tura ni nungkarin pujusar, ni chichamenak chichau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Cama uchiri ju armiayi: Cus, Mizraím, Fut tura Canaán. ");
INSERT INTO acuNT_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Cusa uchirisha ju armiayi: Seba, Havila, Sabta, Raama tura Sabteca. Raama uchiri Seba tura Dedán armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Cusa chikich uchiri Nimrod naartin amiayi. Nimrodka nuwaa eemak kakaram aints wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Apu Yus wakerau asamtai Nimrodka pengker tuku ayayi. Tura asamtai pengker tuku ainaun pachisar: —Maj, Apu Yus wakerau asamtai, nuka Nimrodjai metek pengker tukuwitai, —tinu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Nimrodka cuatro yaktanam pujuinaun inarmiayi. Nu yakta naari ju ainawai: Babel, Erec, Acad nunia Calne. Nu yakat ainauka Sinar nungkanmaya yakat ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","12","Nu nungkanam aints Asur naartin pujumiayi. Nuka ju yakat ainaun yaktamamiayi: Nínive, Rehobot, Ir, Cala nunia juun yakat Resén tutai. Nu yaktaka Nínive yaktanmaya Cala weamunam japen ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Tura Mizraíma weari ainau ju armiayi: Ludeo ainau, ananeo ainausha, lehabita ainausha, naftuhita ainausha, ");
INSERT INTO acuNT_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","patruseo ainausha, casluhita ainausha, tura cafturita ainausha. Tura filisteo ainauka caftorita weari armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Tura Canaánka uchiri eemkau akiinamia nuka Sidón naartin ayayi. Chikich uchiri Het naartin ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Canaánka weari ainauka ju armiayi: Jebuseo ainau, amorreo ainausha, gergeseo ainausha, ");
INSERT INTO acuNT_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","heveos ainausha, araceo ainausha, sineo ainausha, ");
INSERT INTO acuNT_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","arvadeo ainausha, zemareo ainausha, tura hamateo ainausha Canaánka weari armiayi. Ukunam Canaánka weari ainauka kanararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","Tura ni nungkari Gerar nungkanam jeakuyayi. Tura Sidón yaktanmaya Gazanam jeakuyayi. Tura tsaa winitinmanini yakat Sodoma tura Gomorrasha, tura Admasha, tura Zeboímsha timiá arák Lasa yaktanam jeakuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Nu ainauka mash Cama weari armiayi. Nu aints ainauka ni nungkarin pujusar, ni chichamenak chichau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Nunia Jafeta yachii eemkauri Sem naartin uchi ainauncha yajutmarmiayi. Kame, Hebera uchiri armia nuka mash Sema weari armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Sema uchiri ju armiayi: Elam, Asur, Arfaxad, Lud tura Aram. ");
INSERT INTO acuNT_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Tura Arama uchiri ju armiayi: Uz, Hul, Geter tura Mas. ");
INSERT INTO acuNT_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Tura Arfaxada uchiri Sala ayayi. Tura Sala uchiri Heber ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Nunia Hebera uchiringkia jimiar armiayi. Kichik uchi Peleg naartin ayayi. Nuka kanakmau taku tawai. Kame, ni akiinamunam aints ainau kanararmiayi. Tura ni yachii Joctán naartin ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Tura Joctánka uchiri ju armiayi: Almodad, Selef, Hazar-mavet, Jera, ");
INSERT INTO acuNT_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Adoram, Uzal, Dicla, ");
INSERT INTO acuNT_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obal, Abimael, Seba, ");
INSERT INTO acuNT_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofir, Havila, tura Jobab. Nuka mash Joctána uchiri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Ni nungkari Mesa nungkanmaya tsaa winitinmanini mura irunmia nuni Sefar nungkanam jeakuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Kame, nuka mash Sema weari armiayi. Nu aints ainauka ni nungkarin pujusar, ni chichamenak chichau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Nu aints ainauka mash irumram Noé weari armiayi. Juun nujang tuke kuyuamia nunia nukap yujarar nunia kanarar atu atu chikich nungkanam wear nuni pujuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Yaanchuikkia aints ainau kichik chichamnak chichau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Tura tsaa winitinmanini jiinkiar, paka nungkanam Sinar tutainum jear nuni pujusarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Tura asar chichainak: —Watska, nuwe najanar jiinum inarkarmi —tiarmiayi. Tura jean jeaminak kayanka takatsuk ladrillojai ni jeen jeamin armiayi, tura kantsejai kantserarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Tura ataksha chichainak: —Watska, yamaikia kichik yaktanam mash pujusar, jea nekas nayaimp antitiak jeamkarmi. Turakrikia mash iruntrar pujusar, ataksha chikich nungkanam pujustasrikia kanakchatatji. Tura asakrin chikich aints ainauka ii yaktarin jiisar: Atumi yaktari nekas jiijamnawaitai turamiartin ainawai, meemasar —miajuitji —tusar tunainiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","6","Tu nintiminamtai Apu Yus ni yaktarin tura nekas juun jean jeamkatasar nangkamawarmia nunasha jiis nintimias: —Ju aints ainauka untsuri ainayat, mash kichik chichamnak chichainau asar, miajuitji tumamsar ju takatan nangkamawaru asar, ni wakeramurin najantan pengké inaisachartatui. ");
INSERT INTO acuNT_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Tura asaramtai mai nuamtak anturnaichau arti tusan, ni chichamen pachimratatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","9","Tura asa nu aints ainau chichamen pachimramiayi. Turamtai anturnainachak pujusar, juun jean jeamtan inaisar, atu atu shiakar, kanakar chikich nungkanam wearmiayi. Tura Yus mash aints ainau chichamen pachimramu asamtai, nu yakta naaringkia Babel ayayi. (Nuka pachimramu taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sema weari ju armiayi: Nujang kuyuamu jimiar musach nangkamaru ai, Sem cien musachrintin pujamtai, uchiri Arfaxad naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Tura quinientos musach pujus uchiri ainaun yajutmar, nawantrincha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Tura Arfaxad treinte y cinco musach pujamtai, uchiri Sala akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Nunia cuatro cientos tres musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Tura Sala treinta musach pujamtai, uchiri Héber naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Nunia Sala cuatro cientos tres musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Tura Héberka treinta y cuatro musach pujamtai, uchiri Peleg akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Nunia Héberka cuatrocientos treinta musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Tura Pelegka treinta musach pujamtai, uchiri Reu naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Nunia Pelegka doscientos nueve musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Tura Reu treinta y dos musach pujamtai, uchiri Serug akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Nunia Reuka doscientos siete musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Tura Serugka treinta musach pujamtai, uchiri Nacor naartin akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Nunia Serugka doscientos musach pujus, chikich uchi ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Tura Nacor veintinueve musach pujamtai, uchiri Taré akiinamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Nunia Nacor ciento diecinueve musach pujus, chikich uchiri ainaun yajutmar, nawantri ainauncha nawantrumramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Tura Taréka setenta musach pujamtai, ni uchiri Abram, tura Nacor, tura Harán naartin akiinawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Taré weari ainauka ju armiayi: Abram, tura Nacor, Tura Harán Taré uchiri armiayi. Tura Harán ni uchiri Lotan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Tura ni apari Taré iwiaaku pujai, Haránka Caldea nungkanam akiinamia nuni yakat Ur tutainum jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Tura Abram ni kana umajin Sarai naartinun nuwatkamaiyi. Tura Nacorka nuwan Milca naartinun nuwatkamiayi. Milcaka Haránka nawantriyayi. Tura Isca umajiyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saraika kaa asa uchin jurechuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taréka yakat Urnum caldeo nungkanam pujus, nunia jiinki, Canaán nungkanam weak, uchiri Abraman, tura tirangki Lotan, tura najati Sarainasha ayamiayi. Antsu Canaánnumka jeatsuk, yakat Haránnum jear, nuni pujusarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Tura nuni pujuinai, Taréka Haránnum pujus doscientos cinco musachrintin jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Abramka Ur yaktanam caldeo nungkanam pujamtai, Apu Yus Abrahaman chicharak: —Ami nungkarminia jiinkim, ami wearam ainau tura aparmi jeesha mash ukukim, chikich nungkanam wi inaktustatjame nuni weta. ");
INSERT INTO acuNT_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","Tura nuni jeakmin, aminka yujratnuitjame, tura pengker awajsatnuitjame. Wi turamtai amesha chikich aints ainauncha pengker awajsatnuitme. Wi turatin asamtai, ami naarmin pachisar aints ainau mash pengker chichasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Aints ainau amin pengker awajtaminamtaikia wisha nunisnak pengker awajsartinuitjai. Antsu amin pase awajtaminamtaikia, wisha pase awajsartinuitjai. Ame wina umirtin asakmin, mash nungkanmaya aints ainaun amijai pengker awajsartinuitjai —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Yus timiau asa, Abramka timiatrusang umirak, yakat Haránnumia jiinkimia nuningkia setenta y cinco musach pujus, Canaán nungkanam pujustas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Tura ni nuwari Sarain tura awe Lotancha ayas, tura Harán nungkanam pujus, aints ainaun sumarmia nunasha mash ayas, warinchu ainauncha mash yaruak, Canaán nungkanam jeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Tura yakat Siquem tutainum jear, canaánnumia ainau pujuinamunam numi juun encina tutain wainkarmiayi. Nu numinam More tutainum canaánnumia ainau ni yusrin seau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Tura nu nungkanam Apu Yus Abraman wantintuk: —Ami wearam ainau pujustinnun ju nungkan susatnuitjai, —timiayi. Yus tama Abramka Yusen maaketai titas, kayan yaruak irumramunam tangkurin maa epeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","9","Tura nunia jiinki muranam yakat Betel tutainum wemiayi. Tura nuni nuwap jea ainaun entsamtai entsakar itaarmia nujai yaktamawarmiayi. Tura ni pujamurinia yakat Betelka tsaa jeamunmanini amiayi. Tura chikich yakat Hai tutai tsaa winitinmanini amiayi. Tura nuni ataksha Yusen pengker awajsatas kayan irumramunam tangku epetin najanamiayi. Tura nuni Apu Yusen seamiayi. Tura nunia jiinki Néguev nungkanam jeatas Abram nuwap jeanam pujuki pujuki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Tura Néguev nungkanam ni yuwatniuri atsau asamtai, Ejipto nungkanam pujustas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Tura Ejipto nungkanam jeatak wajak, nuwarin chicharak: —Ameka nekas shiirmaitme. ");
INSERT INTO acuNT_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Tura asakmin Ejiptonam pujuinau amin waitmakar: Au nuwarintai tusar, wina mantinak aminka juramkiarmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Tura asamtai amin ininminamtaikia: Juka wina umaaruitai turuttia. Turutkumningkia mantuwarchatatui, —tusa nuwarin timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Nuna tusa Abram ni nuwarijai Ejipto nungkanam jearamtai, Ejiptonam pujuinauka Sarain nekas shiirman wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Tura Ejipto apuri inatiri ainausha niin wainkar, apu faraón tutain ujakarmiayi. Turam faraónka: —Nu nuwanka jearun jeekataram —tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Tura faraónka: Ni umajichuashi, tu nintimias Abraman pengker awajsamiayi. Tura oveja ainaun, vaca ainauncha, burro ainauncha, tura camello ainauncha, inati aishmang ainaun tura nuwa ainauncha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Tura Abrama nuwarin jurukin asamtai, Yus faraónkan tura ni weari ainauncha wait wajaktiniun akuptukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Tura asamtai faraón: Sarai Abrama nuwarintai tusa nekaa, Abraman untsuk: —¿Waruka wina nuwaruitai turutsuksha anangkruamame? ¿Waruka aitkame? ");
INSERT INTO acuNT_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Umaaruitai turutu asakmin, nuwarmin nuwatkataj tusan wakerukmajai. Pai, yamaikia nuwaram jukim weta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Tura ni inatiri ainaun chicharak: —Abram ni nuwarijai tura ni ayaakmaurijai warirtuk Ejiptonmaya jiikrum akupkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Turamtai Abram nuwartuk tura tangkurtuk Néguevnum waketkiarmiayi. Tura awe Lotcha niijai waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abram kurirtin, tura kuikiartin, tura tangkurtin asa, nekas juun kuikiartinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Tura Néguevnumia jiinki, ni jee nuwap najanamun apuuki apuuki yakat Betelnum jea, Betel yakat tura Hai yakta japen yaanchuik pujusmaurin pujustas waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Nu nungkanam Abram yaanchuik kayan irumar tangku epetirin najanamia nuni ataksha Apu Yusen seauyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Abrama awe Lotcha ovejartin, tura vacartin, tura inatirtin asa, jiichri Abramjai metek kuikiartin ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","7","Tura tangkuri timiá untsuri asar, tangku ainau chirichrin wári amukarmiayi. Tura asaramtai Abrama tangkuri wainin ainau Lota tangkuri wainin ainaujai maanikiarmiayi. Tura cananeo ainau tura ferezeo ainausha tuke nuni pujuinau asaramtai, mai tsaniasar pujustatkamawar yumatkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Tuminamtai Abram Lotan chicharak: —Ameka wina awer asakmin, iikia kajernaikiachminuitji. Tura ami tangkurmi wainin ainausha wina tangkuru wainin ainaujaisha kajernaikiacharminuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Tura asamtai yamaikia kanakar pujusmi. Nungka mash angkantaitai. Ame warukua wakerame nuka jiista. Ame menanmanini pujustajai takumningkia, wikia untsurnumanini pujustajai. Antsu untsurnumanini pujustajai takumningkia, wikia menanmanini pujustajai, —Abram timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Tamati Lot ¿Tuning weentaj? tusa pangkai jiimkama, nungka Jordánnum jeakun paka aun entsa wainkamiayi. Nu nungkaka aja numamtin yaktachinam Zoar naartinnum tutainum jeakuyayi. Tura Ejipto nungka tumau asamtai, tangku ainau entsa umurtincha nukap amiayi. (Kame, Apu Yus yakat Sodoma tura Gomorra tutain mestsaing nu nungkaka paka asa, nekas pengker nungka ayayi.) ");
INSERT INTO acuNT_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Tura asamtai Lotka: Nungka paka Jordán entsanam jeakun wakerajai —timiayi. Tura nuniangka tsaa winitinmanini wemiayi. Tura asamtai Abram Lotjai kanakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Tura Abramka Canaán nungkanam juwakmiayi. Antsu Lotka yakat Sodomanam jeatak we, ni jeen nuwap najanamu amia nuna apuuki apuuki Sodoma yaktanam jeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Tura Sodomanam pujuinauka timiá tunau asar, Apu Yusnasha umirtan nakitin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Lot Sodomanam weai, Yus Abraman chicharak: —Ame wajame nuni pangkaim jiimkum, tsaa winitinmanini tura tsaa jeamunmaninisha, nujinmaninisha tura nungkaninisha mash jiista. ");
INSERT INTO acuNT_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Ame nungka wainme aunka mash amin susatatjame. Tura tuke aminuk tura wearminuk ati tusan mash susatatjame. ");
INSERT INTO acuNT_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ami wearam yaikmia nunisarang nekapmarchamin untsuri yujrartin ainawai. ¿Yaikmin yáki nekapmarain? Tura asar ami wearam nekapmarchamin artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Watska, nungkan amastatja nuna esantiri tura wangkantirisha wekaatusam jiista. Ame jiistatme nunaka mash susatatjame, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Yus tama Abramka ni aintsri ainaujai nuwap jea ainaun jukiar, yakat Hebrónnum jeatak nungka Mamre naartinnum numi encina tutai irunmaunum pujustas wemiayi. Tura nuni jea, Yusen maaketai titas tangku epeatniun najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Nu musachti aints Amrafel naartin Sinar nungkanmaya apuri ayayi. Tura aints Arioc naartin Elasar nungkanmaya apuri ayayi. Tura aints Quedorlaomer naartin Elam nungkanmaya apuri ayayi. Tura aints Tidal naartin Goim nungkanmaya apuri ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Nu apu ainauka Sodomanmaya apu Berajai, tura Gomoranmaya apu Birsajai, tura Admanumia apu Sinabjai, tura Zeboimnumia apu Semeberjai, tura yakat Zoarnumia apu Belajai mesetan najanawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Nu apu cinco armia nuka meset najanatai tusar, juun entsa miaaku tutai kaanmatkarin nungka pakarin Sidim tutainum iruntrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Kame, Apu Quedorlaomer nu apu ainaunka nepetak doce musach inarmiayi. Tura trece musach jeamia nuni nangkamamunam nu cinco apu ainauka apu Quedorlaomerjai mesetan najanatai tusar chichasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Tura catorce musach nangkamamunam nuni apu Quedorlaomer chikich apu ainau niijai tsaniasar pujuarmia nuka ni suntari ainaujai nungka Astarot Carnaim tutainum wearmiayi. Turawar refaita ainaun nepetkar, zuzita ainauncha Save-quiriataimnasha nepetkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","Tura horeo ainaun mura Seir tutainum nepetkar, papeekiar paka nungkanam Parán tutainum jeeniarmiayi. Nu nungkaka aints atsamunam ayaamsaintai. ");
INSERT INTO acuNT_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Tura Quedorlaomerka niijai tsaniasar maaniawarmia nuka nujai waketkiar En-mispatnum jearmiayi. Chikich naaringkia Cadesaitai. Turawar amalecita ainaun, tura amorreo ainauncha mash maawar, waririncha mesrarmiayi. Nu amorreo ainauka nungka Hazezon-tamar tutainum pujuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","9","Tura Sodoma apuri Gomorra apurijai tura Adma apurijaisha Seboima apurijaisha, tura Bela apurijaisha nungka Sidimnum jearmiayi. Nu cinco apu ainauka nuni jear, chikich cuatro apu ainau, Quedorlaomer, Tidal, Amrafel, tura Arioc naartin nu ainaujai maaniawarmiayi. Nu cuatro apu ainauka Elamnumia, tura Goimnumia, tura Sinarnumia, tura Elasarnumia apuri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Kame, Sidim paka nungkanam waa untsuri armiayi. Nuni kantsea tumautiat kuta pajamramu armiayi. Tura asaramtai Sodoma apuri tura Gomorra apurisha ni suntari ainausha maaniamunam tupikiaktatkamawar nu waa irunmaunum ayararmiayi. Antsu chikich apu ainauka muranam tupikiakiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Tuminamtai nepetmin ainauka Sodoma tura Gomorra yaktanmasha aintsu yutairi tura wariri iruniarmia nunasha yaruakar wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Tura Sodomanam Abrama awe Lot pujumia nunasha achikiar mash waririntuk yaaruakar jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Turawaramtai chikich aints uwemramia nuka weri Hebreo aints Abraman mash ujaktas tamiayi. Abramka amorreo aints Mamre naartinu irutkamuri ayayi. Nuka numi encina tutai arakmaunam pujumiayi. Mamreka jimiar yachi Escol tura Anerjai iruntrar pujuarmiayi. Nu tres yachi ainauka Abrama amikri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Tura Abram awe Lotan achikiaru tamaun antuk, inatiri ni jeen akiinawaru ainaun mash yaruak, trescientos dieciocho aintsrijai apu ainaun papeekar Dan yaktanam jearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Tura kashi Abram ni aintsri ainaujai aneachmau apu ainaun amankiar, Damasco yaktan nangkaikiar yakat Hoba tutainum papeekarmiayi. Tura mesetnum nepetmakar, ");
INSERT INTO acuNT_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","warí ainaun yaruakmaunka mash atankiar, Lotnasha tura chikich aints ainauncha tura nuwa ainauncha mesatak jukiarmaun mash angkanmamtikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Nunia Abram apu Quedorlaomeran, tura chikich apu niijai irutkau ainaun maaniamunam nepetak waketki, Sodoma apuri Abramjai chichastas Save pakanam wemiayi. Kame, Save pakarisha Apu Pakarintai tinu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Turamtai Salema apuri Melquisedec, Apu Yuse sacerdoteri aina nuna juuntri asa, pangkan tura vinoncha ita, Abraman susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","Tura chicharak: —Yus yakí puja nuka yainmakti. ");
INSERT INTO acuNT_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Tura Yus mash iruna nuna nangkamasang kakaram aa nuka ami nemasem ainaunka nepetkau asamtai, tuke Yus juuntapita tiarmi —timiayi. Tamati Abram apu ainaun nepetak waririn cien jurukin asa, nunia Melquisedecan diez susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Turamtai Sodoma apuri Abraman chicharak: —Wina aintsur ainaun ame angkanmamtikiamame nunak yaruaktajai. Nu tsangkatrukta. Antsu warinchu ainauka mash jurumkita, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Tamaitiat Abram aimiak: —Atsa apuru, Yusek nayaimpin tura nungkancha najanamia nuna naarin pachisan tajame: ");
INSERT INTO acuNT_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","Abramka wi susamujai kuikiartin wajasuitai, ame turutim tusan nakitajai. Tura asan aminu aintsrumi warinchurin jiyuchirinkesha, tura sapatri jingkiatairinkesha pengké jurukchatatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Antsu wina inatir ainau yaparinak yurumamunka pachisnaka nunaka tatsujme. Antsu ju aints Aner, Escol tura Mamre nemartusarma nuka kichik kichik ni akankamurin jukiarti, —tusa Abram timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Nunia Apu Yus Abraman karanma nunisang wantintuk: —Abrama, shamkaip. Amin ayamruktinnaka Wiitjai. Tura asan wi susatatjame nuka nukapetai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","3","Tamaitiat Abram ayaak: —Apuru, ame Yus asam, wi uchirtichuitjai tusam nekame. ¿Tura asakmin ame wina surustatme nunasha itiurkatjak? Ame uchi chikichkisha yajutmarta tusamka tsangkatrukchawaitme. Tura asakmin wi jakamtai wina inatir Damasconmaya aints Eliezer naartin wi takakja nunaka mash jukitnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Tamaitiat Yus Abraman ayaak: —Atsa, nuka turashtinuitai. Antsu ami nekas uchiram mash jukitnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Tura Abraman aanam jiiki chicharak: —Pangkaim yamaikia nayaim jiisam ¿yaa ainau nekapmarminkaitam? Ami wearam yaa aina nunisarang nekapmarchamin artinuitai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Tama Abram Yusen nekasampita timiayi. Tura asamtai Apu Yuska Abrama nintimaurin nekau asa, Abraman pachis: Wina nekasampita turutu asamtai, tunaachawa nunisang pujaun jiajai, tu nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Nunia Yus Abraman chicharak: —Wiitjai Juun Yusnaka. Tura asan caldeo nungkanam yakat Ur tutainum pujamin, ju nungka juka tuke aminu ati tusan nu nungkanmaya jiikmiajme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Yus tamaitiat Abram ayaak: —Antsu Juun Yusru, ju nungkaka nekas winaruitai tusanka ¿itiurkanak nekaatnuitaj? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Tama Yus ayaak: —Kichik vaca, tura kichik chivo, tura kichik carnero tres musachrintin ainaun, nunia kichik kayuk suwe, tura kichik yapangkam juni ikiankata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Tama Abramka Yus tímia nunisang nu tangku ainaun ikiaanak maa, tangku namangken jimia akanak japen nakak matsarmiayi. Antsu tangku nanamtin ainaun nakatsuk inaisamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Tura chiwiang ainau tangku namangken yuwatasar kautinamtai, Abram kiikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Tura pujus, yamai kintiamai kari nepeteam Abram kanurmiayi. Tura karanam kirit tee wajamtai shamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Nunia Apu Yus chicharak: —Nusha nekaata. Ami wearam ainau chikich nungkanam pujusar, nu nungkanmaya aints ainau inatiri wajasar, cuatro cientos musach nukap wait wajakartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Tura wainiatun wikia nu nungkanmaya ainaunka ni pase turatniurin yapaijkiatnuitjai. Tura asan ami wearam ainaun angkanmamtikian, nukap kuikiartin arti tusan pengker awajsatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Antsu nuka turunatsaing ameka angkan juunmaram jakatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Amorreo ainauka yamai nukap tunaun takaina nuna nangkamasarang juun tunaarintin wajasaramtai, wait wajaktinun susartinuitjai. Turakun ami uchiram, tura tirangkim, tura nuna tirangkisha mash jakaramtai, nunia nukap arus ni weari ainaunka ataksha ju nungkanam ikiankartinuitjai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Nunia kashi tee wajasu ai, Abram karanma nunisang namang inarkamunmaya ji mukuntiurin jiinun wainmiayi. Nunia shirikip kiapaamua tumau tangku namangke nakakmau tepemia nuna japen nangkaamakmauncha wainmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Nunia Apu Yus Abramjai chichaman najanak: —Nungkan ami wearam ainaun susatnuitja nuka Ejipto entsarinia nangkama entsa nampuram, Eufrates tutainum jeekatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Nu nungkaka yamaikia ju aints ainau nungkarintai: Ceneceos, cadmoneos, ");
INSERT INTO acuNT_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","hititas, ferezeos, refaítas, ");
INSERT INTO acuNT_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","amorreos, cananeos, gergeseos, tura jebuseos aina nuna nungkarin ami wearam ukunam akiinatin ainaun susatnuitjai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Abrama nuwari Sarai naartin kaa asa, uchin jerechuyayi. Turayat inatiri Agar naartin Ejipto nungkanmaya itamu asa, niijai tsanias pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Tura asamtai Sarai Abraman chicharak: —Anturtukta. Apu Yus winaka uchi jurertinun suritruku asamtai, uchi yajutmarta tusan inatirun susatjame. Tura uchin jureramtaikia, wina uchirua nunisang atinuitai, —timiayi. Tama Abramka timiatrusang umikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Tura Canaán nungkanam diez musach pujusar, Sarai ni inatirin Agar naartinun Abraman susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Tura susam Abram nijai kanuru asamtai Agar japrukmiayi. Tura japruk pujus, Sarai inamaitiat umirtan nakitmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Turamtai Sarai Abraman chicharak: —Ame Agarjai kanurta tusan susamjame nuka yamaikia japruk pujus, winaka pajaki airak umirtutan nakitrawai. Tu pujau asamtai amin wiasmakjame. Antsu Yusek ningki jiirmasti, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Tamati Abram ayaak: —Watska, inatirmeka tuke aminuitai. Warí wakerame nuka turata —timiayi. Tama Sarai ni inatirin pase awajsau asamtai, Agar tupikiakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Tura aints atsamunam Shur nungkanam jinta jeakua nuni weamtai, Yuse awemamuri yumi taimunam wajas Agaran wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Tura iniak: —Agara, Sarai inatiriya ¿tuniaya winame turasha tua weame? —tama ayaak: —Wina iniatniunka ajapan ukukin tupikiajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Tamati Yuse awemamuri chicharak: —Waketkita, tura inatmin taa nuka mash umirkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Nunia Yuse awemamuri ataksha chicharak: —Ami wearam timiá untsuri arti tusan yujratnuitjai. Timiá untsuri asaramtai, nuna nekapmartatkamawar yumatkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ame jamtin asakmin, Yus ami wait wajamurmin waitmau asamtai, uchi aishmang jurertatme. Tura asam ni naari Ismael ati tusam tu inaikiata. (Nuka Yus antawai taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Kame, nuka juunmar yupiram asa, mash aints ainaujai maanin atinuitai. Turamtai chikich aints ainau mash niijai maanikiartinuitai. Tura ni yachii ainau waininamunam pujustinuitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Tura Agarka Yusjai chichasu asa, Waikratin Yusetai inaikiamiayi. Tura chichaak: —Kame, Yus wina waitak pujamtai tuke iwiaakjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tura asamtai nu yumi taimu naaringkia: “Tuke Pujuu wina waitnuka yumi taimurintai” tu inaikiamiayi. Nu yumi taimuka jimiar yakat Cades tura Bered tutaiya nuna japenintai. ");
INSERT INTO acuNT_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Tura, Agar Abrama pujutirin waketki, nuni uchi aishmangkun jereramtai, Abram ni naari Ismael inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Agar Ismaelan jereramtai, Abram ochenta y seis musachrinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Tura Abram noventa y nueve musachrintin pujamtai, Yus niin wantintuk: —Wiitjai, Yusetjai. Tuke tujinkachuitjai. Tura asamtai winak umirtakum tunaarinchau pujusta. ");
INSERT INTO acuNT_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ami wearam timiá untsuri arti tusan, amijai chichaman najanatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Tamati nuna antuk Abram nijajijai nungkan antitnak tsuntsumamtai, Yus ataksha chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","—Amijai chichaman najanatja nuka juwaitai: Ameka untsuri aints ainau apachri atinuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Turatin asam, yamai nangkamsamka naarmeka Abramka achatatui, antsu Abraham atatui. (Abrahamka “Untsuri aintsu apari” taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ami wearam ainauka nukap yujratnuitjai. Tura asamtai ami wearam untsuri nungkanam pujusar, nu nungkanmaya ainaunka inarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Chichaman amijai najanaja juka ukunmasha mash ami wearmijai najanatnuitja nuka juwaitai: Wikia tuke ami Yusrum atatjai. Turasha ami wearam ainau Yusri tuke atinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Yamai Canaán nungkanam pujame nu nungkan amin tura ami wearmincha: Juni pujustaram tusan takamtsuk susatjarme. Tura asan tuke ni Yusri atinuitjai, —Yus Abrahaman timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Nunia chicharak: —Wi chichaman najanaja nuka ameka tura ami wearam ainausha mash umiktaram. ");
INSERT INTO acuNT_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Juwaitai atumjai chichaman najanaja nuka: Mash ami wearam ainausha umirkartin ainawai. Ami wearam aishmang ainau mash katii nuwapchirin charutkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Atum nuwapchiram charukrumka, Wijai chicham najanamun timiatrusrik umiktatji titatrume. ");
INSERT INTO acuNT_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Yamai nangkamsang uchi aishmang akiinamunmaya ocho kinta nangkamaramtai, nuwapchirin charutkarti. Kame, aishmang atumi jeen akiinawaru ainauka, tura kuikiajai sumakmau ainausha nunisarang nuwapchirin charutkarti. ");
INSERT INTO acuNT_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Atumi jeen akiinawaru ainauka, tura kuikiajai sumakmau ainausha tuke inaitsuk nunisarang turawartin ainawai. Nu turawartin ainauka iwiaaku pujuinai: Wikia Yusjai chichaman najanamiajai tu nintimsar pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Antsu aishmang katii nuwapen charutkachmauka Wijai chicham najanamun umirkachu asaramtai, atumjaingkia pengké pujuschartin ainawai, —Yus tusa Abrahaman timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Nunia Yus Abrahaman chicharak: —Nuwarmi naaringkia yamaikia Sarai achatatui. Antsu yamai nangkamsang Sara atatui. ");
INSERT INTO acuNT_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Niincha pengker awajsatatjai. Wina kakarmarjai ame uchi yajutmarakmin, Sara japruktatui. Tura wi nekasan nuwarmin timiá pengker awajsau asamtai, untsuri nungkanmaya aints ainau nukuchri atinuitai. Tura asamtai ni weari ainauka nu nungkanmaya ainau apuri artinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Yus tamati Abraham nijajin nungkan antitnak tsuntsuma, ¿aints cien musachrintincha uchin yajutmartinkai? ¿Tura Sarasha noventa musach puja nuka uchin jererminkai? tu nintimias wishikmamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Tura asa Yusen chicharak: —Uchir Ismaelka pengker awajsata. ¿Nu maakchaukai? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Tamaitiat Yus ayaak: —Nekasan tajame: Nuwaram Sara uchirmin jerertatui, turamtai Isaac inaikiatatme. Turakmin chichaman amijai najanamiaja nunaka niijai tura ni weari ainaujaisha najanatnuitjai. (Isaacka: Wishikmamramu taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Tura Ismael pachisam turutme nunasha anturkajai. Tura asan ni uchirisha untsuri arti, tura ni wearisha untsuri arti tusan, pengker awajsatnuitjai. Tura ni weari ainamunam doce apu wajasartinuitai. Tura ni weari ainauncha nukap yujratnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Tura kichik musach ju nantu atata nuni Sara uchi Isaac naartinun jurertata nujai wi amijai chichaman najanaja nunisang niijaisha najanatatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Tura Yus Abramjai chichas umis nunia jiinki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Turamtai nu kintati Yus timia nunisang Abraham ni uchiri Ismaelan, tura inatiri ni jeen akiinawarua nunasha, tura kuikiarijai sumakaru ainauncha, tura ni jeen pujusarua nuna katii nuwapchirin charukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","25","Kame, nu turamunam Abrahamka noventa y nueve musachrintin ai, uchiri Ismaelka trece musachrintin wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","27","Nu kintati Abrahamka ni uchirijai, ni jeen pujuarmia nujai tura ni jeen akiinawaru ainaujai, tura chikich nungkanmaya aints kuikiari sumakaru ainaujaisha mash katii nuwapen charutkamu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Chikich kintati tsaa tupin wajasai, numi encina tutai Mamrenam irunua nuni Abraham nuwap jea waitirin pujamtai, Apu Yus wantintukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Turamtai Abraham pangkai jiimkama, tres aints naka wajainaun wainak, wári wajaki ingkiuniktas jiinki, nijajin nungkan antitnak tsuntsumruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Tura chicharak: —Apu ainautiram, wina pengker nintimturkurmeka wait aneasrum nangkatukirap. ");
INSERT INTO acuNT_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Atum pengkeraitai takurmeka, atumi nawe nijartinun inatirun yumi utita tusan akupkatjai. Turamtai mikinnum pujusrum ayamsataram. ");
INSERT INTO acuNT_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Wi atumi umirin asamtai, atum wi pujamunam tau asakrumin, ayuratasan wakerajrume. Tura yutain itaamtai, nunia yuwarum tura ayamsaram wetaram tusan akupkatatjarme, —timiayi. Tamati —ayu —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Tu tinam Abraham nuwap jeanam waya, Saran chicharak: —Harina timiá pengker irunua nuka veinte kilos jukim, wári pang najanata —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Nunia jiinki, vaca matsatmaunam ampuki we, vaca uchiri timiá pengkeran jiis, ni inatirin: —Juka wári maam inartuata —tusa inarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Tura ni inatiri mash umisaramtai, vaca uchiri namangken itaa, vaca muntsurincha tura vaca muntsuri ijuramuncha pataatniurijai yuawarti tusa itamiayi. Tura nu aints ainau numi nantujen pujusar yuwinai, Abrahamka naka wajamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Turamtai yuwar umisar Abrahaman chicharinak: —¿Nuwaram tuni puja? —tu iniinam —Jea pujawai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Tamati kichik aints chicharak: —Chikich musachtin ataksha ju nantutin ataksha jiitjame. Tura nuni Sara uchirin takakun wainkatatjai, —timiayi. Tamati Sara nuwap jeanam wajas anumak antukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abraham ni nuwarijai mai juuntach armiayi. Tura Sáraka nantu waintancha inangnakuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Tura asa ningki nintimias: —Wina aishrujai timiá juuntach arincha, ¿itiur jurertajak? —tusa wishikmamramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Turamtai Apu Yus Abrahaman chicharak: —¿Warukaya Sarasha wishikmamua? ¿Timiá juunchincha uchinka jurerchamnawaitjai, tu nintimias pujatsuash? ");
INSERT INTO acuNT_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Warí, ¿Yuse tujinkamuri kichkisha awak? Chikich musachtin ataksha jiitjame. Tura nuni Saraka uchirin takakun wainkatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Tamati Sara nuna antuk shamak: —Wishirchajai —timiayi. Tamaitiat Apu Yus ayaak: —Nekasam wishirume tusan nekajme —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Nunia irau ainauka wajakiar: —Sodomanam weaji —tinamtai, Abrahamka: —Ausaran akupkartajai —tusa niijai wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Turamtai Apu Yus nintimias: —¿Wi turatatja nuna Abrahaman uurkatniukitja? ");
INSERT INTO acuNT_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Atsa, niisha untsuri aints kakaram aina nuna apachri atinuitai. Tura ni apachri asamtai, mash nungkanam pujuinaunka pengker awajsartinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Tura wi ukunam atiniun pachisan chichaman najanamia nu umiktasan Abrahaman chicharkun, ni uchirin tura ni weari ainauncha: Wina chichamur umiakrum, pengker aa nunaka turataram tusan eakmiajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Tu nintimias Apu Yus Abrahaman chicharak: —Sodoma yaktanam tura Gomorra yaktanam aints timiá pasen turinau asar, juun tunaarintin ainawai, ");
INSERT INTO acuNT_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","tamaun antukjai. Tura asan nekasashi tusan nekaatasan wetatjai. Tura nuni jean nekaatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Nuna tusa jimiar irau Sodoma yaktanam pujuinaun jiisartas weenai, Abrahamka Apu Yusjai juwakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Tura tejuwach wajas Abraham Yusen chicharak: —¿Tunaun takachu ainaunka tunaarintin ainausha metekak amuktatam? ");
INSERT INTO acuNT_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","¿Nu yaktanam cincuenta aints tunaun takachu pujuinamtaikia, tsangkurtsukek mashik amuktatam? ");
INSERT INTO acuNT_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ameka mash nungkanmaya aintsu ninti nekaru asam, aya pengkera nuke turamnawaitme. Tura asam aints tunaun takachu ainauka tunau takau ainaujaingkia metek amukaip, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Tamati Apu Yus ayaak: —Atsa, Sodoma yaktanam cincuenta aints tunaun turichu pujuinamtaikia, niin wait anentau asan, mash nuni pujuinaun tsangkuratatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Tamati Abrahamka ataksha chicharak: —Apuru, tsangkutrurta. Ameka nekas Yusetme. Antsu wikia aya aintsutiatnak titatjame nuka anturtukta: ");
INSERT INTO acuNT_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Antsu cincuenta jeachamtaikia, cuarenta y cinco tunaun turichu iruninamtaikia, ¿nu yaktanka mesratmesh? —tamaitiat Apu Yus ayaak: —Atsa, cuarenta y cinco tunaun turichu iruninamtaikia, nu yaktanka mesrashtatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Tamati Abraham ataksha iniak: —¿Antsu cuarentachik iruninamtaikia itiurkatme? —tama Yus ayaak: —Cuarenta iruninamtaikia yaktanka mesrashtatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Tamati Abraham ataksha chicharak: —Apuru, wait aneasam kajertukaip. Ataksha iniajme: —¿Aya treintachik iruninamtaikia itiurkatme? —tama Yus ayaak: —Treinta iruninamtaikia nu yaktanka mesrashtatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Yus tamati Abraham ataksha iniak: —Apuru, pengké natsaamtsuk iniajme. ¿Veinte aints tunaun turichu iruninamtaikia, itiurkatme? —tamaitiat Yus ayaak: —Veinte aints tunaun turichu ainauka iruninamtaikia, yaktanka mesrashtatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Tamati Abraham ataksha Yusen chicharak: —Apuru, wait aneasam kajertukaip. Yamaikia inangnamunam juchinak iniastajme. Nuniangka ataksha ititka awajsashtatjame. ¿Aya diezchik tunaun takachuka iruninamtaikia, itiurkatme? —tu iniam Yus ayaak: —Aya diezchik amatisha, yaktanka mesrashtatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Tura Yus Abrahamjai chichas umis weau asamtai, Abrahamsha ni pujutirin waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Nu kintati kiarai Lot Sodoma yakta waitirin jintumas pujamtai, Yuse awemamuri jimiar aintsua tumau taarmiayi. Tura arakchichu wininai, Lot nuna wainak ingkiungtas wajaki nijajin nungkan antitnak tsuntsumruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Tura chicharak: —Juun ainautiram, wait aneasrum wina jearun kanurtaram tusan seajrume. Turakrumin nawemin nijatramrarti, kashin kashik wemintrum tajarme —timiayi. Tamaitiat aiminak: —Atsa, aanumkesha kanurtaji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Tinamaitiat Lot ayaak: —Atsa, nekasrum wina jearun kanurtaram, —Lot tama, nunia —ayu —tusar Lota jeen wearmiayi. Tura jeanam wayawaramtai, Lot yutain umis, pangnasha levadurajai pachimtsuk inarkamtai yuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Tura kanurtai tusar pujuinai, aanum aishmang juuntach tura natsa ainausha mash kaunkar, Lota jeenka tentakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Turawar untsuminak: —¿Ju kashia jui jeemin aints taara nusha tunia pujuinawa? Nu jiikiarta. Iisha niijai tepestasar wakeraji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Tu untsuiniamaitiat Lot jeanmaya jiinki, waitin epenmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Tura nu aints ainaun chicharak: —Sair irunutiram, tunau timiá pase aa nuka turuwairap. ");
INSERT INTO acuNT_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Antsu wina nawantur jimiar aints takashtai pujuina juna jirkitjarme. Turamtai atum warí wakerarme nuka turataram. Antsu irau juni wayawaruka wi ipiaamu asaramtai, nuka takasairap —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Tamaitiat Lotan kajerinak: —¡Engkasta! ¿Chikich nungkanmaya aintsutiatmesha ii apuri wajastasmesha wakerame? Antsu ipiaamurmin nangkamasrik aminka timiá pase awajsatnuka nekamata tusar, Lotan pase awajsatnuncha nangkamawar, jea waitirincha kupiktai tusar wakeriarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Tura waininayat Yuse awemamuri mai waitin urakar, Lotan achikiar, jea nitkarin engkewar, waitin epeniarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Tura natsa ainau tura juuntach ainau jiincha kusumtikramiayi. Turam waitin eainayat wainkartatkamawar tujinkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Nunia ni ipiaamuri Lotan chicharinak: —¿Ami wearmesha ju yaktanmasha iruninawak? ¿Uchiram tura nawantrumsha tura awemsha juni pujuinauka, kame, ami wearam ainausha mash jukim ju yaktanmaya jiikta. ");
INSERT INTO acuNT_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Junia aints ainau timiá pase asaramtai, Yus nuna wainak iinka: Ju yaktaka mesrataram tusa akuptamkaji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Tu tinamtai Lot awe wajasartin ainau pujuinamunam we chicharak: —Apu Yus ju yakat mesratin asamtai, wári jiinkiram wetaram —timiayi. Tamaitiat nangkami tatsuash tusar pachischarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Tura tsawaatak wajai, Yuse awemamuri Lotan chicharinak: —Ju yaktanka meseakrin, jakai tusam, wári nantakim nuwem tura nawantrumsha mai jukim yaktanmaya jiinkita, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Tinamaitiat wárikia wetsuk wajainai, Apu Yus niin wait anentrau asamtai, Yuse awemamuri mai Lota uwejen, tura nuwari uwejen, tura nawantri mai uwejen achikiar, yaktanmaya jiikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Tura chicharinak: —Uwemratasam wakerakmeka muranam wári tupikiakta. Antsu pajasam jiisaip, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Tinamaitiat Lot ayaak: ");
INSERT INTO acuNT_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","—Wina apur ainautiram, wait aneasrum tsangkutrurtaram. Atumka wina nukap yaingkarume, tura wait anentruru asaram uwemtikrurume. Antsu muranam wetatkaman tujintajai. Atum yakat epeakrumin, wi jinta wekain, yakat keamtai mukuntiuri wina amantukchatpiash, tura nunia jakashtajash. ");
INSERT INTO acuNT_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Antsu chikich yaktawach arakchichu aa nuni tupikiakminuitjai. Wait aneasrum, nuni uwemrataram tusaram tsangkatruktaram. Warí, nu yaktaka nekas tuupchitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Tamati kichik Yuse awemamuri chicharak: —Takumka, ame tame nunaka turatatjai. Tura asan nu yaktanka mesrashtatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Tura asamtai wári weta. Ame nuni jeatsmining, chikich yakat ainaunka mesrachminuitjai —timiayi. Tura asamtai nu yakta naarinka Zoar inaikiamu amiayi. (Nuka “tuupich” taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Tura tsaa yamai jiinai, Lot yakat Zoarnum jeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Tura jeamtai Apu Yus Sodoma yaktanam tura Gomorra yaktanmasha ji azufrejai pachimramun akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Tura nu yaktanam aints pujuinaunka mash jijai epeamiayi. Tura yaktancha tura paka nungkancha mash mesramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Turamu wainiat Lota ukurin nuwari winak, pajas jiikma jaka, wee kaya tumau wichi najanar wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Kashin tsawaar Abraham Apu Yusjai yaau chichasma nuni wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Tura nuni jea wajas, Sodoma tura Gomorra pakaria nuni jiikma, ji timiá keau asamtai, nu yakta ainamunmaya tura pakanmaya mukunit shuwin jiinun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Tura asamtai Lot pujamu yakat irunun Yus tu epeamiayi. Antsu Abrahama seamurin nintimias, Yus nu yaktanka epeatsaing Lotnaka jiiki uwemtikramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Nunia Lot Zoarnum pujutan shamau asa, nawantrin mai ayas juki murá wemiayi. Tura nuni pampa waanam pujusarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Tura nuni pujuinai Lota nawantri eemkauri kain chicharak: Ii aparingkia juuntach wajasi. Tura tuke nuwatnaina nunisarka juni iin nuwatramkartinka aints pengké atsawai. ");
INSERT INTO acuNT_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Tura asamtai ii apari anamkar, nunia niijai tepesmi. Tura asar japruktinuitji, —kain timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Tu tinu asamtai nu kashi umuti kariaun aparin susar anamkarmiayi. Nunia eemkauri aparijai tsaning tepesmiayi. Tura wainiat aparingkia nawantri tepesmaurin tura nantakmaurincha nekaachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Turamtai kashin tsawaar eemkauri kain chicharak: —Wikia yaau kashi ii aparijai tsaningkian tepesmiajai. Tura asamtai ju kashikia ataksha nunisrik anamkami. Turakrin ameka niijai tsaningkiam tepesta. Turakmin iikia mai japruktatji —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Tu tinu asamtai nu kashi ataksha aparin anamkarmiayi. Tura nawantri ekeri aparijai tsaning tepesmiayi. Tura wainiat aparingkia nawantri tepesmaurin tura nantakmaurincha pengké nekaachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Tura asar Lota nawantri mai ni apariniunak japrukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Tura eemkauri uchi aishmangkun jurer Moab inaikiamiayi. Nuka yamai moabita ainau tutai apari ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Tura ekerisha uchi aishmangkun jurer Behami inaikiamiayi. Nuka yamai amonita ainau tutai apari ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Nunia Abrahamka ni pujamunmaya jiinki, Néguev nungkanam yakat Gerar tutainum pujustas wemiayi. Gerar yaktaka Cades tura Shur yakta japen awai. ");
INSERT INTO acuNT_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Tura Abrahamka nuni pujus, ni nuwari Saran pachis: Juka wina umaaruitai tau asamtai, Gerarnumia apu Abimelec naartin Saran nuwatkatas: —Utitaram —tusa inatirin akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Turamtai Yus Abimeleckan karanam chicharak: —Ameka nu nuwa nuwatkataj tame nuka aishrinuitai. Tura asamtai ame jakatatme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Tamaitiat Abimelec Saran takaschau asa, Yusen ayaak: —Apuru, ¿nu nuwan takaschau aingkik, jakatatme tusam turutam? ");
INSERT INTO acuNT_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abraham ningki chichartak: Juka wina umaaruitai turutmayi. Tura niisha nunisang: Abrahamka wina umaruitai turutmayi. Tu tinamtai nekaskai tutsuk, nekasampita tusan jukiyatun, nu nuwanka takaschau asan, tunaanaka pengké takaschajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Tamati Yus ataksha karanam chicharak: —Pengker nintimjai turamame nunaka nekas paan nekau asan, tunaun takasai tusan, nu nuwanka takaschati tusan surimkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Antsu yamaikia Abrahama nuwari awangtukta. Turakminkia niisha Yuse etserin asa, amin pachitmas: Iwiaaku pujusti tusa seatramtatui. Antsu ni nuwari awangtachkumka amesha tura ami wearam ainiaujai mash jakatatrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Yus tu timiau asa, kashik nantaki Abimelec ni inatiri ainaun untsuk, nunia kaunkaramtai Yus karanam timiaunka mash ujakmiayi. Turamtai niisha nuna antukar nukap shamkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Nunia Abimelec Abrahaman untsuk chicharak: —¿Waruka aitkamame? Wina tura wina aintsur ainaunka nekas juun tunaun turataram tusam ¿itiur amatiya nuwaram au wainiatum umaaruitai turutmame? ¡Nuka pengké turachminuitai! ");
INSERT INTO acuNT_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","¿Ju aitkaratasmesha itiura nintimsame? —tusa Abimelec Abrahaman jiyakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Tamati Abraham ayaak: —Ju nungkanmaya ainauka Yusen nintimtichu asaramtai, wina nuwarun wakerinak, mantuawaraing tu nintimsan nuna timiajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Antsu Saraka wina aparu nawantri asa, nekas wina umaaruitai. Tura wina nukurka jererchau asamtai, niin nuwatkamiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Tura Yus: Ame nungkarminia jiinkita turutin asamtai, Saran chicharkun: Ii tuning jeataij nuningkia wina pachitsam: Umaaruitai turuttia tusan timiajai, —Abraham timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Tamati Abimelec Abrahama nuwarin awangtukmiayi. Tura ovejancha, tura vacancha, tura inatirin aishmang ainaun, tura nuwa ainauncha nangkami susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Tura chicharak: —Jiisia, juka mash wina nungkaruitai. Tura asamtai ame tuní pujustasam wakerame nunisha pujusta —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Tura Saran chicharak: —Umaimin suaja nuka mil kuikian jea nuna nangkamnak suajai. Tura nujai mash aints amijai pujuina nuka amin pachitmasarka pase chichartakacharmin ainawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","18","Abimelec Saran jukimtai, Amalecka jeen nuwa pujuinauka uchin jurechu arti tusa, Apu Yus kaa awajsamiayi. Tura Abraham Yusen seamtai, Yuska Abimeleckan tura ni nuwarincha tsuwarmiayi, tura ni inatiri ainauncha mash uchin ataksha jurerarti tusa tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Apu Yus Saran chicharak: —Ame uchi jurertatme —tusa, ni timiaurinka timiatrusang umikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Tura mai timiá juuntach ainayatang, Sara japruk Yus timia nunisang uchin jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Tura uchin jereramtai Abrahamka ni uchirin Isaac inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Tura ocho kinta nangkamaramtai, Yus timia nunisang Isaacka nuwapchirin charutkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Isaac akiinamtai, Abraham cien musach pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Tura asamtai Sara nintimias: —Yuska wina wishimtikruru asamtai, mash aints ainau wi uchi jerermaun nekaawar, wijai pengker nintimsar wishikrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Abrahama nuwengka uchinka jererchamnawapi, tu nintiminau wainiatun, tura Abrahamsha juuntach aing, uchin jurerjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Isaac tsakar muntsu tsurakamtai, Abrahamka yutain nukap umis, namperan najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Turamtai ejiptonmaya nuwa Agar naartinu uchiri Abrahamnau amia nuka Isaackan wishikiaun Saraka wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Turamtai wainak Abrahaman weri chicharak: —Ame jakaakmin, wina uchir Isaacka aminu aa nunaka mash jukitnuitai. Antsu inatiru uchiringkia nunaka jukishtinuitai. Tura asamtai inatir Agarka ni uchirijai akupkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Tamati Abraham nuna antuk, Ismaelan yajutmaru asa, wake mesekmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Turamaitiat Yus Abrahaman chicharak: —Ami uchiram tura inatiram pachismesha napchauka nintimtsuk asata. Ami uchiram Isaacnaka pengker awajsan nukap yujratnuitjai. Tura asamtai Sara turama nunismek turata. ");
INSERT INTO acuNT_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Tura inatirmi uchirincha ame yajutmaru asakmin, nunasha nunisnak nukap yujratnuitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Yus timiau asa, Abraham kashik nantaki, pangkan juki, tura yumi murtinun juki, Agar entsakti tusa susa, ni uchirijai weti tusa, aujas akupkamiayi. Tura akupkamu asa, Beerseba nungkanmanini jintachunam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Tura nuni wekaasar wearai, tsaa sukuam, yumi mash amuk, uchirinka numi wamketin pujsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Tura uchin ukuki, jumchik wekaas: Uchir jaun jiitnaka nakitajai tu nintimias keemsamiayi. Tusa pujai uchiri juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Turamtai Yus uchi juutun anturkamiayi. Tura Yuse awemamuri nayaimpinmaya chicharak: —¿Waruka aitkame, Agara? Yus uchi juutmaun anturkau asamtai, shamkaip. ");
INSERT INTO acuNT_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Uchi inankim jukim, uwejen achikiam pengké akupkaip. Wikia uchirmin nukap yujratnuitjai —tusa, ");
INSERT INTO acuNT_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Yus Agaran yumi nungkanmaya jinun inaktusmiayi. Turamtai Agar nuni we, yumin shikik, uchirin aarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","21","Yus yayamu asa, uchikia tsakar Parán nungkanam aints atsamunam pujus, nangki ekketan nuimiatramiayi. Nunia nukap arus ukuri Ejiptonmaya nuwan nuwatkati tusa nuwatmamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Chikich kintiati apu Abimelec suntara apuri Ficol naartinjai Abrahaman chichastas wemiayi. Tura Abrahamnum jeariar, Abimelec chicharak: —Ame mash turame nuka Yuse yaimkejai turame, tusar nekaji. ");
INSERT INTO acuNT_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Tura asamtai tajame: Yuse naarin pachisam: Wikia aminka, tura uchiram ainauncha, tura ni weari ainauncha pengker awajsatatjai, tusam Yusjai tajame turuttia. Tura wikia amin pengker awajtamsamiaja nunismek ameka wina, tura yamai pujame junia aints ainauncha pengker awajsatatme, Yusjai tajame takumka, chicham najanami, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Tama Abraham ayaak: —Yuse naarin pachisan: Ayu, nekasan tajame. ");
INSERT INTO acuNT_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Antsu inatiram ainau yumi taimun atantrukarun pachisan amijai chichastasan wakerajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Tama Abimelec ayaak: —Ameka nu pachismeka ujatkachuitme. Tura asakmin ¿yáki nuna turaya? tusanka nekatsjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kame, nu kintati Abraham Abimelecjai chichaman najanawarmiayi. Turawaramtai Abraham oveja ainaun tura vaca ainauncha achik Abemeleckan susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Tura siete ovejan achik akankamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Turamtai Abimelec iniak: —¿Waruka ju siete ovejan akankame? —tu iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Tu iniam Abrahamka ayaak: —Ju siete ovejan nangkamnak suajme. Tura asan nu yumi taimunka nekasan wikia taimiajai tusan, junajai aints mash paan nekaawarti tusan turajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tura nu nungkanam Yuse naarijai chicham najanamu asamtai, juka Beersheba ati tusar inaikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Tura Beersebanam chichaman najanawar umisar, Abimelec suntara apuri Ficoljai filisteo nungkarin waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Waketkiaramtai Abrahamka Beersebanam numi tamarisco tutain arakmakmiayi. Tura nuni Apu Yus tuke pujuwa nuna naarin pachis Yusen seamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Tura Abrahamka filisteo nungkarin untsuri musach pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Nukap arus Yus Abrahaman ¿Nekasash wina umirta? tusa nekapsatas untsuak: —¿Abrahama, pujamek? —timiayi. Tu iniam Abraham ayaak: —Ja ai, juni pujajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Tama Yus chicharak: Ami uchiram Isaac kichik aa nu nekasam nukap aneame nu jukim, nungka Moriah tutainum weta. Tura nuni jeam, mura wi inaktustatjame nuni uchiram maam epeakum, wina surusta —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Tama Abraham ayu tusa, kashik nantaki, chapuman nakak, entsamtai burro tutai chapuman entsakti tusa umis, Isaacjai tura natsa jimiarjai mura Yus inaktustinnum wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Tura dos kinta jinta kanur nu kinta tsawaarmaunum wekaa wekaaka mura arák aun wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Tura wainkar Abraham natsa jimiaran chicharak: —Juni burrojai nakarsataram. Tura wikia uchirjai muranam wakatatjai. Tura wakar Yus: Ameketme Apum titasar wakeraji. Nu tiri ataksha waketkir juni taatatji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Nunia Isaac chapuman nanasti tusa susam, shirikpin kapaun takus, tura kuchiinasha takus, Abraham uchirin ayas muranam wakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Tura wakar, Isaac aparin iniak: —Apaachia, chapum takakji. Tura shirikipsha takakji. ¿Antsu oveja Yus susatasar ii maatin tuwaita? —tu iniam, ");
INSERT INTO acuNT_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abraham ayaak: —Uchiru, oveja ii maatniunka Yus inakturmastatji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Tura Yus timia nunisarang nu muranam wakaar, Abraham kayan juki tangku epeatniun najanatas irumramiayi. Tura chapuman patas, nunia Isaackan jingkia chapumnum patasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Nunia kuchiinasha achik uchirin maatas wajamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Turamaitiat Yuse awemamuri nayaimpinmaya untsuak: —Abrahama, Abrahama, —tama nuna antuk, nii ayaak: —Juni wajajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Tama Yuse awemamuri chicharak: —Uchirmeka maatsuk asata. Uchiram kichik au wainiatum suritrukchau asakmin, Yus nekas umirkawaitme tusan nekajme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Tamati Abraham pangkai jiimkama, oveja aishmangkri antirin numi kanawen wangkemak wajaun wainkamiayi. Tura nuna wainak maa, Yusen susatas epeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Turamu asa Abraham nu mura naari Yus yuumamun sukartawai tu inaikiamiayi. Tura asamtai yamaiya juisha: —Ju muranam Apu Yus yuumamun sukartawai —tinu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Nunia Yuse awemamuri nayaimpinmaya ataksha chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","—Apu Yus chichartamak: Wikia Yus asan, nekasan tajame: Uchiram kichik aa nuka suritrukchau asakmin, ");
INSERT INTO acuNT_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","nekasan nukap yaingtinuitjame. Tura yaa timiá untsuri pengké nekapmarchamin nayaimpinam irunina nunisnak, tura juun entsa yantame yaikmiri timiá untsuri irunina nunisnak ami wearmin yujratnuitjai. Tura nunia ni nemase ainauncha tuke nepetin artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Tura wina umirtuku asakmin, mash nungkanmaya ainauncha nekasan pengker awajsartinuitjai, Yus turamui —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Tamati Abraham uchirijai natsa juwakarmia nuni waketkiar, niijai iruntrar Abrahama pujutirin Beersebanam waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","22","Abraham Beersebanam pujus, ni yachi Nacora nuwari, Milca naartin, ocho uchin jureri tamaun antukmiayi. Nu uchi naari nu ainawai: Uz, Buz, tura Kemuel. Kemuelka Arama apari ayayi. Tura nunia akiinawaruka nu ainawai: Quesed, Hazo, Pildas, Jidlaf, tura Betuel. ");
INSERT INTO acuNT_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Nu Betuelka Rebeca apari ayayi. Nu ocho uchi ainauka Abrahama yachi Nacora nuwari Milca jurermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Nuniasha Nacorka chikich nuwari, Reuma naartin cuatro uchin jurermiayi. Nuna naari nu ainawai: Teba, Gaham, Tahas, tura Maaca. ");
INSERT INTO acuNT_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","2","Abrahama nuwari Saraka ciento veintisiete musach pujus, Canaán nungkanam Hebrón yaktanam jakamiayi. Hebrón yaktaka chikich naari Quiriat Arba inaikiamuitai. Tura aints jakamtai juutkur turutaiya nunisang Abrahamsha juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Tura Sara jaka tepemia nunia jiinki, hititas ainaun chichastas weri, nuni jea chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","—Wikia chikich nungkanmaya ayatnak seajrume: Wait aneasrum, nuwarun iwiarsatasan wakerakun, kuikiajai atumi nungkari sumamtikruktaram, —tusa seamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Tamati hitita ainau aiminak: ");
INSERT INTO acuNT_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","—Juunta, wait aneasam anturkartukta. Yus eakmawaitme tusar nekaji. Tura asam ii jakmarar iwiartairi mash jiisam, tua timiá pengkeraita tusam eakam, nuni nuwem iwarsata. Ii ainatikia ii iiwartairinka surimkatnuka pengké atsawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Tu tinam Abraham wajaki, hitita ainaun tsuntsumruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Tura chichaak: —Atumka wina nuwar jakauka juni iwiarsata turutkurmeka, wait aneasrum wina pachitsaram Zohara uchiri Efrón naartinun ujakrum, ju titaram: ");
INSERT INTO acuNT_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Ni nungkari yantamen pampanam waa aa nuna kuikiajai sumamtikrukti. Nu waa akikrikia metek akiktatjai. Tura asan nu jakau iwiartaikia tuke winar atinuitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Tamati Efrónsha nuni wajau irutkamuri ainau tura chikich aints nuni nangkaaminausha mash antukarti tusa, Abrahaman ayaak: ");
INSERT INTO acuNT_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","—Atsa, juunta, wait aneasam anturtukta. Wina irutkamur ainau antinamunam tajame: Nu nungkanka tura waancha nangkamnak susatjame. Ami nuwaram jakama nuka pachitsuk ani iwiarsata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Tamati Abraham nu aints irunun tsuntsumrua, ");
INSERT INTO acuNT_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","mash aints antinamunam Efrónkan ayaak: —Wait aneasam, winasha anturtukta. Nungka akikrin metek akiktasan wakerajme. Tura eemkan akikmakan, nunia nuwarnaka iwiarsatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Abraham tamati Efrónka ayaak: ");
INSERT INTO acuNT_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","—Juunta, anturtukta. Nungka akikringkia cuatrocientos jeawai. Nu pachisrikia chichaj pujuchmi. Tura sumakam nuwaram iwiarsata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Tamati Abraham ayu tusa, hitita ainau antiniamunam Efrónka timiaurijai metek nu kuikian akikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Tura asamtai Efrónka ajari Macpela nungkanam amia nunaka sumakmiayi. Nuka Mamre nungkanmaya tsaa taakmanumanini awai. Kame, aya nungkanak sumakchamiayi. Antsu pampa waarincha ajarintuk tura numirintuk sumak, nuka mash ");
INSERT INTO acuNT_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","Abrahamnau wajasmiayi. Kame, nu sumakmaun hitita ainau tura yakta waitirin nangkaaminauka mash nekaawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Nunia Macpelanam pampa waari amia nuni Abrahamka nuwarin iwiarsamiayi. Macpelaka Canaán nungkanam Mamre yaktanka chikich naari Hebrón inaikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Kame, nunia nangkamsang nu nungkaka waarintuk jakau iwiartai ati tusar, hitita ainau Abrahaman kuikiajai surukarmia nuka tuke Abrahamnau amiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Abraham nekas juuntach pujau wainiat, Yuska tuke pengker awajnuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","4","Turamu asa Abrahama inatiri nekas juun amia nuka warinchurin wainin asamtai, Abraham niin chicharak: —Wina uchir Isaacka Canaánnum wi pujaja juni nuwan nuwatkati tusamka tsangkamkaip. Antsu wi wear pujuinamunam weme, uchir nuwan nuwatkatin sumartuta. Tura ame tame nunaka metek umiktatjai takum, Yus nayaimpin tura nungkancha najanamia nuna naarin pachisam, Yusjai tajai tusam, uwejem makuru wamkerin weakta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tamati inatiri ayaak: —¿Antsu nuwa ami wearmi nungkarinia wijai winitan nakitamtaikia, itiurkatjak? ¿Uchirmincha ami wearmi nungkarincha ayatjash? —tu iniam, ");
INSERT INTO acuNT_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abraham ayaak: —Atsa, uchirka nu nungkanmaka ayaip. ");
INSERT INTO acuNT_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Apu Yus nayaimpinam pujuwa nuka wina aparu jeenia tura wina wearu nungkarnia jiirak, chicham yapajiachminun wina chichartak: Ju nungkanka ami wearam ainaun susatnuitjai turutmiayi. Tu tinu asamtai, uchiru nuwari atinun juni itati tusa, ni awemamuri amina eemak akupkatatui. ");
INSERT INTO acuNT_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Tura nu nuwaka amijai winitan nakitamtaikia, ukukim chicham umikta tajame nuka umitsuk pujayatum angkantaitme. Antsu uchirka nuningkia pengké jurutkiip —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Tamati inatirisha ni apuri makui wamkerin uwejen weak chicharak: —Ame turutme nunaka metek umiktatjai. Yusjai tajame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Nunia Abrahama wariri timiá pengker irunmia nuna juki: Nuni jean susatatjai tusa, camello ainau waririn entsatkarat tusa diezan yaruak, Mesopotamia nungkanam Nacora yaktarin wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Tura jinta wekaa wekaaka Nacora yaktarin jeatak camello ainau ayamrarat tusa yumi taimu yantamen wajramiayi. Kame, tsaa nungka wajasamtai, nuwa ainau yumin shikikiartas yaktanmaya jiinkiar, nuni tuke kaunin asaramtai nakak, ");
INSERT INTO acuNT_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Abrahama inatiri Yusen seak: —Apuru Yus, ¿wina apuru Abrahama Yusrichukitiam? Wait aneasam, yainkata. Tura wina apursha pengker awajsata. ");
INSERT INTO acuNT_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Jiirsata. Juni nawan ainau yumin shikikiartas kauninamtai, yumi taimunam pujutatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Tura nawan yumin shikiktas winamtai, wi chicharkun: Wait aneasam, yumi shikikiam surusta, amurtaj wi tamati, ni airak: Ayu, amea amurta tura ami camellormincha yumin shikikian aartatjai turutmataikia, nuka Isaacka nuwari atin ame eakmauka atatui. Nu metek umikiamtai, ame wina apur Abrahaman nekasam pengker nintimtame tusan nekaatatjai, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Tura Yusen seak pujai, Betuela nawantri, Rebeca naartin, yumi shikitirin yakajin ekenas winimiayi. Nu Betuelka Nacora uchiri ayayi, tura Nacorka Abrahama yachi ayayi. Tura Betuela nukuri Milca ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Rebecaka nekas shiiram ayayi, tura aints takashtai ayayi. Tura yumi taimunam we, yumin shikik waketmatai, ");
INSERT INTO acuNT_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Abrahama inatiri nawantan wári weri chicharak: —Wait aneasam, yumi shikikiam surusta, wisha murtaj —tamati, ");
INSERT INTO acuNT_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Rebeca ayu tusa: —Apachi, pachitsuk murta —timiayi. Tura yumi shikitiri yakajinum ekenkamun kuwaki, yumin shikik aarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Tura umur umisamtai, Rebeca chicharak: —Camellormesha ni wakeramun umurarti tusa yumin shikirkan aartajai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Nuna tusa wári yumi aatainam yumin yarak ukuki, ataksha yumi aimiak itamiayi. Nuna tura mash tutuararamtai inaisamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Tura camello ainaun yumin aaramtai, Abrahama inatiri Rebecan jiij wajas, Apu Yus yainkachiash tu nintimias chichatsuk wajamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Tura camello ainau yumin umurar umisaramtai, Abrahama inatiri tukunu kuri najanamun Rebecan susamiayi. Nunia patakui kuri najanamun jimiaran kuri mermari kichik kichik 100 gramos nangkamas jeaun susa, ");
INSERT INTO acuNT_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","nunia iniak: —¿Amesha yana nawantrinme? ¿Tura aparmi jeen wina aintsur ainaujai kanurtincha angkan awash? Wait aneasam turuttia, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Tamati Rebeca ayaak: —Wikia Betuela nawantrinjai. Nukurka Milcaitai, tura apachruka Nacoraitai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Tura ii jeenka atum kanurtinka angkantaitai, tura camello yuwatniurisha nukap irunui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Tamati Abrahama inatiri Yusen maaketai titas tikishmatar Apu Yusen seak: ");
INSERT INTO acuNT_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","—¡Apu Yus, nekasam pengkeraitme. Wina apur Abrahama Yusrinme! Tura niin pengker awajsau asam, tura wait anengkratin asam, wi jinta winamtai waitkau asakmin, wina apuru weari pujamurin jeajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Tamati Rebeca ni jeen wári waketki, nukurin ni wainkamurin ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","30","Tura Rebeca umaji Labán naartin tukunun tura patakuincha wainkau asa, tura Abrahama inatirin pachis umaji timiaurincha antuk, nu aintsun wainkataj tusa, ampukraja we, yumi taimunam jea, Abrahama inatirin wainak ");
INSERT INTO acuNT_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","chicharak: —Yus yainmaku asamtai taume. Tura asam pujutirun winita. ¿Warukamtai aanumsha pujame? ¡Atumi kanurtintrin tura camello kanurtintrincha yanchuk umisjai! —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Tura Abrahama inatirin ni aintsri ainaujai jearmiayi, tura camello ainau waririn entsakarmia nuna mash kuwar yuramiayi. Tura Abrahama inatiri ni aintsri ainaujai nawen nijarartas yumin shikikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Tura yuwataram tamaitiat, Abrahama inatiri chicharak: —Chichaman etsertsukka yuwachmin nekapeajai, —timiayi. Tamati: —Watska etserkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Tamati Abrahama inatiri chicharak: —Ayu, wikia Abrahama inatirinjai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Apu Yus apur Abrahaman pengker awajsau asa kuikiartinuitai. Tura asa ovejartin, tura vacartin, tura camellortin, tura burrortin, tura inatirintin asa, aishmang ainaun tura nuwa ainauncha ayaakui. Tura kurincha tura kuikiancha nukap takakui. ");
INSERT INTO acuNT_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Tura nuwari Sara yaanchuik juunmariat uchin kichik jurermiayi. Turasha apur jakamtaikia, niinu aa nuka mash ni uchirinu atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Tura asamtai wina chichartak: —Canaán nungkanam wi pujaja junia nuwanka uchir nuwatkati tusamka tsangkamkaip. ");
INSERT INTO acuNT_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","Antsu aparu weari pujuinamunam weme, uchir nuwan nuwatkatin nuni sumartuta turutmati, ");
INSERT INTO acuNT_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","wi chichaakun: Apuru, nu nawanka wijai nemas tatiniun nakitamtaikia, ¿itiurkatjak? timiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Wi tamati apur airak: Wikia Apu Yuse jintin tuke wekaajai. Tura asamtai ame wina aparu weari pujuina nuniangka nawan uchir nuwatkatniun juni itatasam, Yus ni awemamurin akupturmaktatui. ");
INSERT INTO acuNT_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Antsu wi wear ainau nawantan akuptan arantak nakitinamtaikia, Yusjai tajame turutmame nunaka umitsuk pujayatum angkantaitme turutmayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","Turutmatai wikia nunia jiinkin, ju kiarai yumi taimunam jean, Apu Yusen seamjai. Tura sean: Wina apuru Abrahama Yusriya, ju wekaamunam nekasam wina pengker awajtustasam wakerakminka, ");
INSERT INTO acuNT_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","yamaikia seajme: Wi juni yumi taimunam pujai, nawan yumin shikiktas winamtai, wikia: Wait aneasam yumi shikikiam surusta, wisha murtaj tamati, ");
INSERT INTO acuNT_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","wina airak: Ayu, amea murta, tura camellormincha yumin shikirkan aartajai turutmataikia, nuka wina apuru uchiri nuwari atin ame, Apu Yus, eakmawaitme tusan nekamtikruata, tu seamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Tura Yusen seakun pujai, Rebeca yumi shikitirin yakajin ekenas winaun wainkamjai. Tura yumi taimunam winamtai, wikia chicharkun: Wait aneasam, yumi shikikiam surusta, wisha murtaj timiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Wi tamati, yumi shikitirin nungka pujas: Ayu, amea murta, tura camellormincha yumin shikirkan aartajai, tusa yumin aarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Turamtai wikia iniakun: ¿Yana nawantrinme? timiajai. Wi tamati: Wikia Betuela nawantrinjai. Apachruka Nacoraitai, tura nukuchruka Milcaitai turutin asamtai, tukunun tura patakuin jimiaran susamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Tura Apu Yus wi jintá wekaamurnasha yainkau asamtai, tura apuru yachí tirangki Isaacka nuwari at tusa nekamtikrau asamtai, apuru Abrahama Yusrin maaketai titasan tikishman: Apu Yus, nekasam pengkeraitme, timiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Tura asan yamaikia atumsha wina apur pengker awajsatasrum wakerakrumka turuttiaram. Antsu nuka turachminuitai turutkurminkia, nunasha nekaatasan wakerajai, —tamati ");
INSERT INTO acuNT_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Labán tura apari Betuelsha Abrahama inatirin chicharinak: —Yus nunaka mash turau asamtai, iikia pengkeraitai tura paseetai tichamnawaitji. ");
INSERT INTO acuNT_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Watska, Rebeca jukim waketkita. Yus wakerau asamtai, apurmi uchiri nuwe ati —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tu tinam Abrahama inatiri Yusen maaketai titas, nijiajijai nungkan antitnak tikishmatramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Nunia wajaki, warinchun kuri najanamun tura kuik najanamuncha tura entsati ainauncha Rebecan susamiayi. Tura umajincha tura nukurincha warinchun susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Nunia Abrahama inatiri ni aintsri ainaujai yutancha yuwar, tura umutincha umurar umisar, nunia kanurarmiayi. Tura kashin tsawaaramtai Abrahama inatiri chichaak: —Yamaikia apuru jeen waketkitniun tsangkatruktaram —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Tamaitiat Rebeca umaji tura nukurisha aiminak: —Nuwawach diez kinta iijai pujusti. Nuniangka amijai weti —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Tinamaitiat Abrahama inatiri ayaak: —Atsa, nukap kintaka pujtusairap. Yus wi wekaamurun nekas pengker ati tusa yainkau asamtai, yamaikia apuru jeen waketkitniur tsangkatruktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Tamati aiminak: —Watska, Rebeca untsukmi. ¿Niisha warintimpia? —tusar ");
INSERT INTO acuNT_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Rebecan untsukar nunia iniinak: —¿Yamaikik aujai wetasam wakeram? —tu iniinam: —Ja ai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Tamati nuniangka Rebecan tura nuwa niin tsakatmarua nujai tura Abrahama inatirijai, tura ni aintsri ainaujaisha wearti tusar akupkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Tura Yus yainmakti tusar aujinak: —Ii umaji asam, nukap yujarta. Turakmin ami wearam ainauka ni nemase ainauncha tuke nepetin arti, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Tinamtai Rebeca ni tsakatmarujai camellonam keemsar, Abrahama inatirin nemarkarmiayi. Tura jinta wekaa wekaaka Abrahama pujutirin wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Isaac Néguev nungkanam pujuu asa, yumi taimu Tuke Pujuu wina waitkatnuitai tutain jiis nunia waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Tura kiarai wekaak, pangkai jiimkama arák camello wininaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Turamtai Rebecasha Isaackan wainak camellonmaya kuankimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","Tura Abrahama inatirin iniak: —¿Au aintska iin ingkungmaktas winá ausha yaita? —timiayi. Tu iniam: —Auka wina apuruitai —tamati, tarachin juki yapiin nukukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Turamtai Abrahama inatiri ni wekaasamurin pachis Isaackan mash ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Tura nuniangka Isaac Rebeckan ni nukuri jakamia nuna jeen nuwap najanamunam jukimiayi. Tura nuniangka Rebecan nuwatkamiayi. Tura niincha nukap aneau asa, nukuri jakamtai juutmaurin nutsurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Ukunam Abraham chikich nuwan, Cetura naartiniun nuwatkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Nuna uchiri ju armiayi: Zimram, Jocsán, Medán, Madián, Isbac, tura Súa, juke armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Jocsánka uchiri Seba tura Dedán armiayi. Tura Dedánka weari ainau tu inain armiayi: Asureos, letuseos, tura leumeos, ju armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Tura Madiánka uchiri ju armiayi: Efa, Efer, Hanoc, Abida, tura Elda. Nu aints ainauka Cetura weari armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Kame, Abrahamka ni takakuya nunaka mash takamchau Isaackan susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Tura iwiaaku pujai, Abrahamka chikich nuwanam uchi ainaun yajutmarmia nunaka warinchun nangkami susa, ni uchiri Isaacnumia jiiki, tsaa winitinmanini akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahamka ciento setenta y cinco musach pujus, ");
INSERT INTO acuNT_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","juuntach jakamiayi. Tura asa ni yaanchuik juuntri ainaujai iruntramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","10","Tura jakamtai ni uchiri Isaac Ismaeljai Macpelanam pampa waari amia nuni Abrahaman iwiarsarmiayi. Macpelaka Mamre yaktanmaya tsaa winitinmanini awai. Nu nungkanka hitita aints Zoar naartinu uchiri Efrón naartin Abrahaman yaanchuik sumamtikiamiayi. Tura nuni ni nuwari Sara iwiarsamunam Abrahamnasha iwiarsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Kame, Abraham jakamtai, Yus Isaackan pengker awajsamiayi. Isaacka yumi taimu: Tuke Pujuu wina waitkatnuitai tutainum tuke pujuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Kame, Sara inatiri Ejiptunmaya nuwa Agar naartinun Abraham nuwatak uchin yajutmarmia nuka Ismael naartinuyayi. Tura Ismaela uchiri ju armiayi: ");
INSERT INTO acuNT_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Eemkauri Nebaiot naartin ayayi. Nunia Cedar, Adbeel, Mibsam, ");
INSERT INTO acuNT_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Misma, Duma, Masa, ");
INSERT INTO acuNT_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadar, Tema, Jetur, Nafis, tura Cedema, ju armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ismaela uchiri doce armia nuka ni nungkarincha tura pujutirincha ni naarinak inaikiaru armiayi. Tura asar mash aintsu inakratniusha armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ismaelka ciento treinta y siete musach pujus jakamiayi. Tura jaka ni juuntri ainaujai iwiarsamunam iruntramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Tura ni weari ainauka Ejipto nungka ayaamsar, Havila nungka tura Shur nungka japen pujuu armiayi. Nu nungkanam jinta Asirianam jeatniuka amaktinuitai. Tura nuni pujuinayat, ni yachí ainaujai tuke kajernain armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Abrahama uchiri Isaac pachis timiauka juwaitai: ");
INSERT INTO acuNT_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Isaacka cuarenta musach pujus, Rebecan nuwatkamiayi. Rebecaka Betuela nawantri tura Labánka umaji ayayi. Tura Labánka Padan-aramnum pujau asamtai, arameo aints ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Rebeca kaa asa, uchin jerechu asamtai, Isaac Yusen seamiayi. Tura Yus ni seamurin anturkau asamtai, Rebeca japrukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Tura wakenam uchi timiá muchitmaunum itit nekapeak Rebeca chichaak: —¿Waruka miatcha muchitua? Tuke aintsanak pujaknasha warukatjak? ¿Itiur pujustajak? —tu nintimramiayi. Tura asa nuna pachis Yusen iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Tura iniam Yus ayaak: —Wakemin uchi jimiar engketui. Nu uchikia mai aintsu apuri wajasartinuitai. Kichik timiá kakaram atinuitai. Antsu eemkauri ni yachiin ekerin umirkatnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Tura jerertin kinta jeamtai, Rebeca uchin jimiaran jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Turamtai eemak jiinkimia nuka shaarmayayi. Uranchmiari kapantin asamtai, ni naari Esaú inaikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Tura ekeri yachí sangkanin achimiak jurentrau asamtai, naarinka Jacob inaikiarmiayi. (Nuka sangkannum achimkau taku tawai.) Rebeca uchin mai jereramtai, Isaac sesenta musach pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Uchi mai tsakararmiayi. Esaúka nangkami wekainuyayi. Tura pengker tukuu ayayi. Antsu Jacobka nuna nakitak jean pujustas wakerinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Esaúka kuntinun untsuri tukuu asamtai, Isaac nukap aneenuyayi. Antsu Rebeca Jacobon timiá aneenuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Chikich kintati Jacob yutain inarak pujai, Esaú nangkami wekajutas weyat, kuntinun waintsuk taa, Jacob masamrua pujaun wainkau asa, ");
INSERT INTO acuNT_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","chicharak: —Chua, ushurjai pimpikin jaajai. Wait aneasam yutai kapantakun painkame nu surusta, —timiayi. Kame, Esaú yutai kapantakun yuwamia nuna pachis chikich naari Edom tutai inaikiaruitai. (Edom taa nuka kapantin taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yachi tamaitiat Jacob ayaak: —Ame eemkam akiinau asam: Ii apari jakamtai, winar mash atinua nuka mash aminu ati turutkumningkia, mash susatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Tamati Esaú yachiin chicharak: —¿Warí, tsukajai timiá wait wajaknasha nukap arusan jukitnuitja nuka yamaikia itiurak yainkat? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Tamati Jacob chicharak: —Watska, yamaik Yus wainmaunum: Ukunam winar atinua nuka yamaikia mash aminuitai tajame tita, —timiayi. Tamati Esaúka eemak akiinayat: —Ayu, nuna Yusjai tajame —timiayi. Tu tinu asamtai nukap arus niinu atinua nuka mash Jacobnau ati —tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Tu tinu asamtai Jacobka yachiin pangkan tura masamur kapanniuncha tura umurtinasha susamiayi. Tura mash yuwa umis, wari wajaki jiinki wemiayi, tura eemak akiinamurinka pengké pachischamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Abraham iwiaaku pujai, tsuka amia nujai metek nu nungkanmasha tsuka amiayi. Tura asamtai Isaacka filisteo ainau apuri Abimelec naartinu pujamurin Gerar nungkanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Tura nuni pujai, Yus wantintuk: —Ejipto nungkanmaka weep. Antsu ame pujustiniun wi ujaktatjame. ");
INSERT INTO acuNT_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Yamaikia juni pujusta. Turakmin wikia amijai pujustin asan, pengker awajsatatjame. Ami aparam Abrahaman chicharkun: Amin tura ami wearmincha ju nungkan mash susatnuitjai tusan timiaja nu timiaunka mash umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","5","Aparam Abrahamka wina chichamrun miatrusang umirtuku asamtai, ami wearam ainaun yaa nekapmarchamnawa nunisnak nukap yujratnuitjai. Tura ju nungkancha mash susartinuitjai. Wi turamtai ami wearam ainauka mash nungkanmaya ainauncha pengker awajsartin ainawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yus tu tinu asamtai, Isaac Gerar nungkanam pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Tura nuni pujamtai nu nungkanmaya aints ainau Isaackan iniinak: —¿Rebeca ami nuwemkai? —tu ininamtai Isaac nintimias: Rebeca shiiram asamtai, nuwaruitai tamataikia, wina mantuawarmin ainawai tusa: —Wina umaaruitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Isaac nu nungkanam nukap kinta pujamtai, jea angkamurin apu Abimelec jiimia pujai, Isaac Rebecan minakas wasurun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tura wainak Abimelec Isaackan untsuk chicharak: —Rebeca nekas nuwaram au wainiatum, ¿warukamtai umaaruitai timiame? —tu iniam Isaac ayaak: —Nuwaruitai tamataikia, nuwarun wakerinak mantuawaraing tusan umaaruitai timiajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Tamati Abimelec Isaackan jiyaak: —¿Warukamtai nangkamisha tsanukratme? Ame tu tinu asakmin, junia aints aneachmau nuwarminka jurutramak niijai tepesamtaikia, nu tunaujaingkia wiasmakratkatnuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Nuna tusa Abimelec ni aintsri ainaun chicharak: —Ju aintsun tura ni nuwarincha paseen awajuka maanatnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Nu musachtin Isaac nu nungkanam arakan arakmamiayi. Tura Yus yayamu asa, nukap juukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Nu turamu asa, nukap kuikiartin wajas, nukap warirtin wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Tura ovejari ainauka, vacari ainausha, tura inatiri ainausha timiá untsuri wajasaramtai, filisteo ainauka Isaackan suwirpiaku jiisarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kame, Isaacka apari Abraham iwiaaku pujai, ni inatiri ainau nungkan taurar, yumi taimunka najanawarmiayi. Tura filisteo ainauka nuna nekainau asar, nu yumi taimunka nungkajai yukuararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Nunia Abimelec Isaackan chicharak: —Ameka ii ainautin nangkamasam timiá kuikiartin wajasu asam, juniangka jiinkim weta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Tamati Isaac nunia jiinki, Gerar nungkanam we, nuni pakanam pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Tura ni apari iwiaaku pujai, ni inatiri ainau nungkan tainiar yumi taimun najanawarmia nuna apari jakamtai, filisteo ainau ukunam yukuawarmiayi. Tura nu yumi taimunka ataksha iwiar, apari ni naarin yaanchuik inaikiamia nu inaikiamunak ataksha inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tura chikich kintati Isaacka inatiri ainau paka nungkan tainiar, entsa pukunin wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tura Gerarnumia tangkuri wainin ainau Isaacka tangkuri wainin ainaujai: —Ju yumi taimuka iinuitai —tusar, suritnaikiar maanikiarmiayi. Turawaru asaramtai Isaac nu yumi taimu naarin Maaniamu inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Tura ukukiar Isaacka inatiri ainau chikich yumi taimun tainiarmiayi. Tura waininayat ataksha: —Ju yumi taimuka iinuitai —tusar, filisteo inatiri ainauka niijai maanikiarmiayi. Turawaru asaramtai Isaac nu yumi taimu naarin Nemasnaikiamu inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Tura asa ukuki Isaac arák wemiayi. Tura ni inatiri ainau chikich yumi taimun tainiarmiayi. Tura nuni maanikcharu asaramtai, Isaac yumi taimu naarin Angkantin inaikiamiayi. Kame, Isaac nintimias: —Yamaikia Apu Yus juni angkan takakmastaram tusa, iinka pengker awajtamsau asa angkanmamtikramaji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Nunia Isaac Beersebanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Tura jeamtai Apu Yus kashi wantintuk: —Wiitjai aparmi Abrahama Yusrinka. Tura amijai pujau asamtai shamkaip. Wina inatir Abraham wina umirtuku asamtai, amincha pengker awajsatatjame, tura ami wearam ainauncha nukap yujratnuitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yus tamati, Isaac Yusen maaketai titas, nuni kayan irumar tangku epetin najanamiayi. Nuniangka yaktan yaktamamiayi. Tura inatiri ainausha yumi taimunka tainiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Chikich kintati Abimelec Gerar yaktanmaya jiinki, Isaacjai chichastas wemiayi. Tura ni amikri Ahuzat tura suntara kapitantri Ficol naartin nemarkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Turamtai Isaac chicharak: —Atumka wina nakitrakrum, atumi nungkarinia jiirkiram akuptukiatrumsha, ¿warukamtai jiirsatasrumsha tarutniurme? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Tamaitiat aiminak: —Yus amijai pujawai tusar iikia nekaji. Tura asar amijai pengker chichasar, chicham najanatai tusar taaji. Nu chichamka juwaitai: ");
INSERT INTO acuNT_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Ii ainautikia amincha pase awajtsuk, antsu tuke pengker awajsar, pengker aujnaisar akupnaikiamiaji. Tura yamaikia Apu Yus amincha pengker awajtamsau asamtai, iincha pase awajkartusaip, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Tu tinamtai Isaac yutan nukap umismiayi. Turamtai nuna yuwar, umutincha umurarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Tura kashin tsawar nantakiar, Yuse naarin pachisar chichaman najanawarmiayi. Tura nuna turawar umisar, Isaacka tura irau ainausha pengker aujnaisar ukuniarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Tura nu kintati Isaacka inatiri ainau yumi taimun najanami tusar, nungkan tainiar nitak yumi pukuaun wainkar, —ujakmi —tusar taarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Turawar Isaackan ujakarmiayi. Tinamtai Isaac yumi taimu naarin Seba inaikiamiayi. (Nuka Chicham Najanamu taku tawai.) Tura asamtai yakat aa nuka yamaiya juisha tuke Beerseba inaikiamuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Nunia Esau cuarenta musach pujus, nuwa Judit naartinun nuwatkamiayi. Juditka hitita aints Beeri naartinu nawantriyayi. Tura chikich nuwan Basemat naartinnasha nuwatkamiayi. Basematka hitita aints Elón naartinu nawantriyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Turamtaii nu jimiar nuwaka Esaú apari Isaackan tura nukuri Rebecancha katsuram nintimtikrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Isaac nekas juuntach wajasu asamtai, jiisha kusurmiayi. Tura chikich kintati uchiri eemkaurin: Uchiru Esaúwa, —tusa untsukmiayi. Tamati Esaú ayaak: —Apaachia, ¿warinme? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Tamati Isaac chicharak: —Jiisia, wikia yamaikia nekas juuntach asan, warutik jakatja tusanka nekatsjai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tura asamtai tishimkuram jukim, nangkami wekaasam kuntin eakam maam itata. ");
INSERT INTO acuNT_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Nunia wi wakeraja nunismek inarkam itartita. Turakmin nuna yuwan umisan, ame eemkau akiinau asakmin, amin pengker awajtamsati tusan Yusen seatasan wakerajai. Nuniangka wikia angkan jakamnawaitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Tura Isaac Esaún aujak pujai, Rebeca anumak antukmiayi. Tura asa Esaú kuntinun eaktas weamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Rebeca Jacobon chicharak: —Aparam yachimin timia nuna antukjai. Tura niin chicharak: ");
INSERT INTO acuNT_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","—Kuntin eakam maam, kungkuram inarkam itartita. Turakmin nuna yuwan umisan, amin pengker awajtamsati tusan, Yusen seatasan wakerajai. Nuniangka angkan jakamnawaitjai tu aujak pujaun anturkajai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Tura asamtai yamaikia wina chichamur pengker anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Tangku matsatmaunam weme, chivo uchiri apu aina nu jiisam, jimiar achikiam itata. Turakmin aparam wakera nunisnak kungkurman inarkatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Tura wi turamtai, ame jukim aparam susatatme. Tura yuwa umis, amin pengker awajtamsati tusa Yusen seatatui. Nuniangka angkan jakamnawaitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Tamaitiat Jacob nukurin ayaak: —Yatsuru uranchmiari nukapetai, antsu winaruka atsawai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Apar wina achirak: Esaúchawaitme tusa nekaratatui. Tura chichartak: Wishikrurtasmek aitkaram tusa, pengkerka awajtsuk usukrurtatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Tamaitiat nukuri ayaak: —Uchiru, shamkaip. Amin pase chichartamkamtaikia, nuka winii juwakti. Turatin asamtai, wi tajame nuke turata, tura chivo uchiri jimiar itartita, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Tamati Jacob we chivo uchirin jimiaran achik maa, nukurin itamiayi. Tura itaamtai, aishri wakeramun kungkurman inarkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Nunia Esaú wejmakrin timiá pengker amia nuna juki, Jacobon antsramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Tura uranchmiari atsau asamtai, chivo urejai kunturincha, tura kuntujnumsha nukurkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Tura chivo namangke inarkamurin pangjai uchirin susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Turamtai nuna juki aparin jeari chicharak: —Apaachia, ¿pujamek? —tama Isaac ayaak: —Juni pujajai, uchiru, ¿amesha yaachitme? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Tu iniam Jacob anangkak: —Wiitjai, Esaúwaitjai. Wiyaa akiinamiaja nuwaitjai. Ame turutmame nunaka timiatrusnak umisjai. Wait aneasam, nantakim, keemsam kuntinun maan inarkan itarjame ju yuwata. Tura yuta umisam Yus seam, pengker awajtusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Tamati Isaac chicharak: —¿Itiurkamea te wárisha kuntincha wainkame? —tu iniam Jacob ayaak: —Ami Yusrum kuntinun wina inaktursau asamtai, kakarmachu wainkajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Tamaitiat Isaac chicharak: —Uchiru, ayaamkata. ¿Nekasmek Esaúwaitam? tusan takastasan wakerajme. Tura takasan nekaatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Tamati Jacob aparin takaras jiiras nekarat tusa yaamkamiayi. Tura Isaac Jacobon takas chichaak: —chichameka Jacobo chichamea tumawaitai, antsu kunturmeka Esaú kunturijai metekaitai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Tura Esaú kunturijai metek urentin asamtai, Esaúchawaitai tusa nekaachmiayi. Turayat Yus uchirin pengker awajsati tusa Yusen seatas, ");
INSERT INTO acuNT_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","ataksha iniak: —Maj, ¿nekasmek Esaúkaitam? —tu iniam Jacob waitrak: —Ja ai, wiitjai, Esaúwaitjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Tamati apari chicharak: Uchiru, ame kuntin maam inarkam itaame nuka surusta. Yuwatjai, tura tutuaran pengker awajsatjame —timiayi. Tamati Jacob yutain tura vinoncha susamiayi. Turamtai Isaac yutan yuwa, tura umutincha umur, ");
INSERT INTO acuNT_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","nunia uchirin chicharak: —Ayaamkata, uchiru, tura mejentsata —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Tura ayaaamak aparin mejeamtai, Isaac ni uchiri wejmakri kungkurmari nekapramiayi. Tura uchirin pengker awajas chichaak: —Juka wina uchiru kungkurmarintai. Apu Yus yainmau asamtai, aja kungkua nunismek kungkuame. ");
INSERT INTO acuNT_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Ame ajarmin araatatme nuningkia Yus jiturti tusa, yumin nukap akupturmakti. Tura juuktin kinta jeamtai, Yus trigon tura vinoncha nukap suramsati. ");
INSERT INTO acuNT_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Tura aints untsuri amin umirtamkarti. Tura untsuri nungkanmaya aints ainau amin tarutmiar tikishmatramin arti. Tura ami yachim ainausha amin tikishmatraramtai, ni inakratniuka atatme. Tura amin pase awajtaminamtaikia, usukramu artinuitai. Antsu amin pengker awajtaminauka pengker awajsamu artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yus yainmakti tusa Isaac Jacobon tu chichasmiayi. Tura Yus seatim Jacob jiinai, Esaúsha kuntinun mau asa tamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Nusha nunisang ni painkamurin kungkurman aparin itari chicharak: —Apaachi, kuntinun maan, inarkan itaaja ju nantakim yuwata. Tura yuta umisam, Yus seam wina pengker awajtusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Tamaitiat apari iniak: —¿Amesha yaachitme? —timiayi. Tu iniam ni aimiak: —Wiitjai, Esaúwaitjai, wiyaa akiinamiaja nuwaitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Tamati Isaac nuna antuk napchau nintimias Esaún iniak: —Maj, ¿painkamun itartimia nusha yaachiayi? Ame taatsmining nuna yuwan umisan Yusen sean: Yus pengker awajtamsati timiajai. Tura Yusjai tajame tinu asan, nu pengker awajsamun yaunchuk jukiyi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Tamati nuna antuk kajes juutak: —Apaachi, winasha pengker awajtusam Yusjai tajame turuttia, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Tamaitiat Isaac ayaak: —Chua, yachim eemak taa, wina anangkruau asamtai, aminu atinua nunaka niinu ati tusan timiajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Tamati Esaú ayaak: —Maj, yamaikia jujaingkia jimiaran anangkruayi. Nuiksha wi eemkauri au wainiat, eemkaurinu atiniun atantruk, yamaisha ame winaka pengker awajtustincha atantruki. ¡Naari Jacob inaikiamuka timiá nekasketai! ¿Antsu winaka pengker awajsatniuka kichkiksha pengké atsawak? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Tamaitiat Isaac ayaak: —Uchiru, nintimrata. Ameka eemkam akiinamiame wainiatun, wina angkruau asamtai, yachim amin inatmarti tusan, tura ami wearam ainau mash ni inatiri wajasarti timiajai. Tura ni ajarnia trigon tura vinoncha nukap juukti tinu asan, uchiru, ¿amincha yamai warí titajmek? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Tamati Esaú kakar juutak: —¿Antsu, apaachi, wina pengker awajtursatniuka kichkiksha atsawak? Winasha pengker awajtusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Tamati Isaac chicharak: —Ameka nungka pengkernum árak nekas pengker tsapainiamunam pujutsuk, yajá weme yumi jitiurchatniunam pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ami nangkirmijai ayamrumaktinuitme. Tura yachimi inatiri wajastinuitme. Antsu kakaram wajasam angkanmamtikiatnuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Isaac Jacobon pengker awajsau asamtai, Esaú yachiin kajerak suwirpiaku jiismiayi. Tura nintimias: Apar jakatin kintia jeatak wajasi. Tura jakamtai yatsurun maatatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Tu nintimatai Rebeca nuna nekaa, Jacobon untsuk chicharak: —Antukta uchiru, yachim yapaijkiataj tusa, amin mantamatas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tura asamtai yamaikia wári wina umaar Labán Haránnum puja nuni weta. ");
INSERT INTO acuNT_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Tura nuni pujakmin, yachimi suwiri nangkaamarti. ");
INSERT INTO acuNT_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Tura ame turamurmin kajinmarti. Turamtai winita tusan, chichaman akuptuktatjame. Kichik kintatik mai uchirtiram mengkaturkairam tusan nakitajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Nuniangka Rebeca Isaackan chicharak: —Hitita nawantrin Esaú nuwatkamia nuna nakitau asan, pengkerka pujuschamin nekapeajai. Tura asan Jacobka juni pujus, Canaán nungkanmaya nuwan nuwatkamtaikia, wake mesekan jakamin nintimratnuitjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Tamati Isaac Jacobon untsuk: —Juni Canaánnum nuwa pujuinauka pengké nuwatkaip. ");
INSERT INTO acuNT_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Antsu Padan-aramnum apachrumin Betuel pujamunam weme, jiichrumi nawantri nuwatkata. ");
INSERT INTO acuNT_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Turakmin Yus nekas kakaram aa nuka amin yainmakti, tura nukap yujtamrati. Tura asamtai ami wearam ainauka untsuri nungkanam pujusarti tusa, amin pengker awajtamsati. ");
INSERT INTO acuNT_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Tura Yus wina apar Abrahaman yaanchuik chicharak: Ju nungkanam tuke pujustaram tusan, ju nungkanka susatnuitjarme timia nunisang ju nungkanam yamaikia iraawa nunisrik pujaji nuna amin, tura ami wearam ainauncha suramsarti —tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Nuna tusa Isaac Jacobon Padan-aramnum akupkamiayi. Akupkamu asa Labán pujamunam wemiayi. Labánka Aramnumia aints Betuel naartinu uchiri ayayi. Tura Rebeca umaji ayayi. Tura Rebecaka Jacobo tura Esaúwa nukuriyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Tura Isaac Jacobon pengker awajak: —Canaán nungkanmaya nuwan nuwatsuk, Padan-aramnum weme, nunia nuwa nuwatkata tusa akupkamun Esaú antukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Tura apari tura nukuri timiaurincha antuk, Jacob Padan-aramnum wemia nunasha nekaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Tura asamtai Esaúka: Aparka Canaánnumia nuwanka nakitawapi tu nintimias, ");
INSERT INTO acuNT_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Abrahama uchiri Ismael pujamunam we, Ismaela nawantrin Mahalatan nuwatkamiayi. Nuka Nebaiota umaji ayayi. Kame, Esaúka Mahalatan nuwatak, chikich jimiar nuwa iruniarmia nujai apatkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Jacob Beersebanmaya jiinki, yakat Haránnum jeataj tusa wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Tura jeatak jintá kintamramiayi. Tura asa kanurtas kayan juki tamruk tepes kanurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Tura kanur karanam watai nayaimpinam achitkamunam Yuse awemamuri ainau wakar, tura kuankiar wajainaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Tuminai Apu Yus niinini ayaamas wajaun wainkamiayi. Tura Yus chicharak: —Wiitjai Yusetjai. Apachrum Abrahama Yusrinjai. Tura aparmi Isaacka Yusrinjai. Nungka tepame junaka amin tura ami wearmincha susartinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Tura ami wearam ainauka nungka juyuria nunisarang pengké nekapmarchamin timiá untsuri artinuitai. Tura asar tsaa winitinmanini tura tsaa jeamunmaninisha, tura nujinmaninisha, tura nungkaninisha yujarartin ainawai. Tura amin pengker awajsau asan, tura ami wearam ainauncha pengker awajsamu asar, mash nungkanmaya ainausha nekasar pengker awajsamu artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Tura asaramtai wikia amijaingkia pujajai. Tura asan ame tuning wetatme nunisha amincha tuke wainkatnuitjai. Tura ataksha ju nungkanmasha itatnuitjame. Tura amin timiajme nunaka umitskeka, amincha ajapanka ukukchatnuitjame, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yus tamati Jacob shintar shamak: Maj, Apu Yuska nekas juni pujawai. Antsu wikia nunaka nekaachmajai, tu nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Tura timiá shamak: —Ju nungkaka Yuse nungkarintai. Juwaitai Yuse jee, tura nayaimpi waitirintai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Tura kashik nantaki, kaya tamrukmaurin piangkimiayi. Tura Yusen maaketai titas, olivo macharin kayanam ukatramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Tura nuni yaanchuik yakat Luz naartin tu inaikiamu amia nuna naarin Jacobka yapaijtua Betel iniakiamiayi. (Nuka Yuse Jee taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Nunia chichak: —Ju wekaamunam Yus wijai wekaamtaikia, tura wina waitak yutairun tura entsatirnasha surusamtaikia, ");
INSERT INTO acuNT_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","tura wina aparu jeen waketkun pengker jeanka, Yuska wina Apur atatui tusan titatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Tura kayan piangkin ukuaja juka Yuse jee atatui. Tura winar atata nunasha cien amataikia, Yusnasha diez tuke susatnuitjai —tusa Jacob timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Tura Jacob nunia jiinki, tsaa winitinmanini aints pujuinamunam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Tura weka wekaaka yumi taimunam jeamiayi. Tura jea tres oveja wainin ainau ni ovejari ainau ayaminai entsan aarartas nakasarmiayi. Nu yumi taimu juun kayajai nukukmau asamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","oveja ainau yumin umurartas kaunkaramtai, kayan uratkar yumin aarar ataksha nukukar uku armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Tura Jacob nuni jea, oveja wainin ainaun iniak: —Sair ainautiram ¿atumsha tunia aintsuitrume? tu iniam aiminak: —Iikia Haránnumia ainaji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Tu tinam: —¿Atumsha Nacora uchiri Labán nekatsrumek? —tu iniam aiminak: —Ja ai, nekaji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Tu tinam: —¿Nuka pengkerak puja? —Jacob tu iniam aiminak: —Ja ai, pengker pujawai. Jiisia, ani ni nawantri Raquel naartin ovejarin yumin aartas winawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Tu tinam Jacob chicharak: —Tsaa akaachu aingkia, oveja ainau yamaikikia epenchatayi. ¿Warukamtai entsa aakrum ataksha chirichri yuwarti tusaram juwatsrume? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Tamaitiat: —Atsa, nuka turachminuitji. Antsu oveja ainauka mash kaunkarti tusar nakaji. Nunia oveja wainin ainau mash kaunkar, kaya nukukmaun urakar, oveja ainaun entsa aartinuitji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Tura Jacobka nijai chichaj wajai, Raquelka apari ovejari wainin asa, ovejarijai tamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Tura Jacob ni jiichri nawantrin winaun wainak, pe jaki yumi taimunam we, kaya nukukmau amia nuna urak, oveja ainaun entsan aarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Tura umis, nunia aints ainau tuke turin asaramtai, Raquelan mejeas juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Tura chicharak: —Wikia Rebeca uchirinjai, tura Labánka aweeyaintjai —timiayi. Tamati Raquel aparin ujaktas ampuki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Tura ujakam, Labánka: Umaimi uchiri Jacob tayi tamaun antuk, winita titas wári ni jeenia jiinki, yumi taimunam wemiayi. Tura ingkiunik minakas, yapin mejeas ni jeen jukimiayi. Tura jeanam jea Jacobka ni wekaasamurin mash ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Tura ujakamtai Labán chicharak: —Nekasam wi weawitme, nekasam wina numparniayainme. Tura asam: Iijai pujusta —timiayi. Tamati Jacobka kichik nantu Labanjai pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Tura kichik nantu Jacob pujamtai, Labán chicharak: —Ameka wi wear asakmin, nangkamikia yainkashtinuitme. ¿Antsu warutma akirkat tusamea wakerame? nu turuttia, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Labanka nawantri jimiar ayayi. Eemkauri Lea naartinuyayi. Tura ekeri Raquel ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Tura Lea jiiri mianchau amiayi. Antsu Raquelka nekas shiiram ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Kame, Jacob Raquelan aneau asa, Labánkan ayaak: —Wikia ami nawantrum ekeria nuna nuwatkataj tusan, siete musach takatan yaingtajme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Tamati Labán ayaak: —Takumka wijai pujusta. Nuniangka chikich aintsnasha sutsuk, amin susatatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Tu tinu asamtai Jacob Raquelan nuwatkataj tusa, siete musachin Labánkan yaingmiayi. Kame, Jacob Raquelan timiá aneau asa, nu siete muchachkia nukap takakmayat, jumchik kinta takakmasua nunisang nekapramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Tura siete musach nangkamaramtai, Jacob Labánkan chicharak: —Siete musach amin yaingtatjame timiaja nuka mash umisjai. Tura asamtai nawantrum surusta, nuwatkatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Tu tamau asa Labánka: —Ayu —tusa, ni nawantrin nuwatkat tusa, irutkamurin mash ipiaa, fiestan najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Turayat kashi tee wajasamtai, Labán Lean juki, Jacob tepamunam itiarmiayi. Turamtai Jacobka Leajai kanurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Tura Labánka ni inatiri Zilpa naartiniun Lea inatiri ati tusa susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Tura Jacob tsawaar, Leajai kanurmaun nekaamiayi. Tura nekaa Labankan chicharak: —¿Waruka anangkruame? ¿Ami takatrumin yaingmijam Raquel surusminam tusan tichamkajam? ¿Waruka aitkarame? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Tamatitiat Labán ayaak: —Junia ainautikia eemak akiiniauka surutskeka, ekechirinka surukchamnawaitji. ");
INSERT INTO acuNT_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Tura asakrin Raquel nuwatkataj tusam wakerakmeka, ataksha siete musach takakmasta. Nu turakmeka, ame Lea nuwatkamuram siete kinta nangakamaramtai, Raquelnasha susamjinam, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Tamati Jacob ayu tusa, Leajai siete kinta tsaning pujamtai, Labán Raquelnasha nuwatkat tusa, Jacobon susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Tura ni inatiri Bilha naartiniun: —Ame inarta —tusa Raquelan susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Turamtai Jacobsha Raqueljaingkia tsaning karnurmiayi. Kame, Lean nangkamasang Raquelan aneau asa, ataksha siete musach Labánkan yaingmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Tura Jacob Lean aneachu asamtai, Apu Yus Lea uchi ainaun jererti tusa tsangkatkamiayi. Antsu Raquelnaka uchin jererchati —tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Tura asamtai Lea japruk uchin jerer chichaak: —Wi wake mesemar pujamun Yus nekau asa, uchin surusi. Tura uchirtin asamtai, wina aishur yamaikia anentatui —tusa uchirin Rubén inaikiamiayi. (Rubénka naari: Jiisia uchi taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Tura ataksha Lea uchin jerer chichaak: —Aishur timiá anenchau asamtai, chikich uchin surusi, —tusa uchirin Simeón inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Tura ataksha uchin jerer chichaak: —Yamaikia uchin tres jereru asamtai, aishur wijai tsaning pujustatui, —tusa, naari Leví ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Tura ataksha Lea uchin jerer chichaak: —Yamaikia Yusen maaketai titatjai, —tusa uchiri naarin Judá inaikiamiayi. Tura nuniangka uchi jeretan inangnakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raquel uchin jerechu asa, kain Lean suwirpiaku jiismiayi. Tura aishrin chicharak: —Winasha uchi surusta. Turachkumningkia maj, jakatatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Tamati Jacob Raquelan kajerak: —¿Warí, wi Yuskaitaj? ¿Uchin jerechu awajtamsauka Yuskechukai? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Tamati aishrin chicharak: —Antsu yamaikia wina inatir Bilhajai tsaningta. Turakminkia uchin jerertata nuka wina uchirua nunisarang artinuitai. Tura asamtai wisha uchirtin wajastinuitjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Tu tinu asa Raquelka ni inatiri Bilha aishrijai tsaningti tusa, Jacobon susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Tura asamtai Bilha uchin Jacobnaun jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Turamtai Raquel chichaak: —Wi seamun Yus anturtuku asa, pengker awajtak uchin surusi —tusa, naari Dan ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Tura nunia Bilha chikich uchin Jacobnaun jereramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raquel chichaak: —Uchin jerechu asan, kairjai nekapnaisamunam kairun nepetkajai —tusa uchi naari Neftali ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Tura nunia Lea uchin jererchamin nekapeak, ni inatiri Zilpa aishrijai tsaningti tusa susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Tura Zilpaka uchin Jacobnaun jereramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Lea chichaak: —Pengker nintimsan pujajai, —tusa nu uchi naaringkia Gad inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Nunia ataksha Zilpa chikich uchin Jacobnaun jereramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Lea chichaak: —Yamaikia waraajai. Chikich nuwa ainauka wina pachitsar: Nekas waraawai, tiartinuitai. Tinau asaramtai ju uchi naaringkia Aser ati —tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Nunia trigo juwamunam Rubén ajanam we, numi kangkapen mandrágora tutain wainak, nukuri Lean itarmiayi. Tura Raquel nuna wainak, kain chicharak: —Wait aneasam, uchiram numi kangkapen itama nu surusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Tamaitiat Lea ayaak: —¿Warí, aishruka atantrukmiame nuka maakchaukai? ¿Turayatmek yamaisha mandrágora ainaun uchir surusma nusha atantruktaj tamek? —timiayi. Tamati Raquel chicharak: —Uchiram mandrágoran itarma nuka surusakminkia, arum kashi Jacob amijai kanurtatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Tama Lea ayu timiau asa, Jacob kiarai takatnumia taamtai, Lea jintá ingkiunik Jacobon chicharak: —Uchir mandrágora ainaun itartimia nujai sumakjame, —timiayi. Tama nu kashi Jacob Leajai kanurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Tura Leaka Yusen seak: —Uchi surusta —timiayi. Tura Yus nu seamun anturkau asamtai, Lea uchin Jacobnaun jerermiayi. Nujaingkia Lea uchiri cinco armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Tura asa chichaak: —Wina inatirun aishrun susau asamtai, Yus ju uchin surusi —tusa ni naaringkia Isacar inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Nunia Lea ataksha uchin jerer, nujaingkia uchiri seis armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Tura chichaak: —Yus uchi pengkeran nangkami surusi. Wikia aishrun uchi seisan susau asamtai, wina nekas anentatui —tusa ju uchi naaringkia Zabulón inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Tura inangnamunam Lea nuwachin jerer, naari Dina ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Nunia Raquel seamuncha Yus anturkau asa, uchin jererti tusa tsangkatkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Tura asamtai uchi eemkaurin jerer chichaak: —Uchin jerechu asan, natsanmamin ayaja nunaka Yus japrutayi —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Tura asa: —Yus ataksha chikich uchin surusti —tu nintimias, uchi eemkaurin José inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","26","Raquel Josén jereramtai, Jacob Labánkan chicharak: —Wait aneasam, wina uchir ainaujai tura wina nuwar ainaujaisha wina nungkarun waketkitniuka tsangkatrukta. Wikia nuwarun sumaktasan amin yainuyaja nunaka mash nekame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Tamaitiat Labán ayaak: —Wait aneasam ukurkiip. Ame wijai pujau asakmin, Apu Yus winasha pengker awajtusmamun nekaamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Kame, warutam akirkati tusamea wakeram nunaka timiatrusnak akiktatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Tamati Jacob chicharak: —Wikia kakaram takakmakun, tangkuram ainaunka pengker wainkamiaja nuka paan nekame. ");
INSERT INTO acuNT_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wikia taachaing tangkurmeka jumchik armiayi. Tura wi juni taamtai Yus wina pengker awajtusu asamtai, tangkurmeka nukap yujararmiayi. ¿Antsu warutik winaruncha takastaj? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Tamati Labán ataksha iniak: —¿Warutma akirkat tusamea wakeram? —timiayi. Tamaitiat Jacob ayaak: —Kame, pengkesha akirkaip. Antsu wi titatjame nu antukam ayu takumningkia, tangkurmin ataksha wainkatatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Watska, yamaikia ovejaram matsatina nuni wena, oveja uchiri mukusa aina nuna, tura chivo uchiri tsake tura antutramu aina nunasha akantratjai. Nu ainauka winar artatui. ");
INSERT INTO acuNT_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Turamu asaramtai ukunam wina tangkur ainau jiistasam winakmeka, oveja mukusachuka tura chivo tsakechu tura antutramchausha wainkamka: Juka wina kasartukume turutminuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Jacob tamati Labán chicharak: —Ame tame nuka pengkeraitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Antsu nu kintati Labán chivo tsake tura antutramu ainaun tura cabra tsake tura antutramu tura painch ainauncha tura oveja mukusa ainauncha yaruak, uchiri ainaun chicharak: —Ju ainauka atum akankaram wainkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Nunia nu tangku ainaun yaruak, tres kinta jeatinam wemiayi. Antsu Jacobka chikich tangku ainau Labánnaun wainin ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Tura asa álamo numi kanawen charuk, tura almendro numi kanawencha charuk, tura castanio numi kanawencha charuk, pújuri jiintrati tusa tseret pakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","39","Tura nu numi kanawe pakarmaun yumi aatainam matsamiayi. Turamu asamtai tangku ainau nuni yumi umurartas kaunkar achinikiar uchiri tsake tura antutramu tura painch jurertin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Turinamtai oveja uchiri ainau tura chivo uchiri ainausha Labánnau kanakar pujusarti tusa, Labánka tangkuri ainau ni tangkuri ainaujai akanumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Tura tangku jaeru ainauka achinikiartas yumi aatainam kaunkarmia nuni numi kanawe pakarmaun wainkarti tusa, Jacob tuksamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Antsu tangku watsaru ainauka achinikiartas yumi aatainam kaunkaramtai, numi kanawe pakarmaunka tuksachmiayi. Turamu asar, watsaru ainau uchiringkia Labánnau armiayi. Antsu jaeru ainau uchiringkia Jacobnau armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Nu turamujai Jacob kuikiartin wajas, ni ovejari ainau, camello ainausha, tura burro ainausha tura inati aishmang tura nuwasha untsuri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Kame, Labánka uchiri ainau nuna nekaawar chichainak: —Jacobka ii aparinun mash jukin asa, kuikiartin wajasi —tusar tinamun Jacob nekamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Tura Labán yaanchuik Jacobon pengker awajnutiat, nuniangka pengkerka awajtsuk pujau asamtai, Labánka kajertawapi tusa nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Turamtai Apu Yus Jacobon chicharak: —Aparmi nungkarin tura ami wearmi pujamurin waketkita. Turakmin wisha amijai tsaniasan wekaasatatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Yus tama, Jacob ni nuwari Raquelan tura Leancha chichaman akuptak: —Oveja ainaun wainkun pujaja juni winitaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Tura taaramtai nuwarin chicharak: —Juuntruka yaanchuik wina pengker awajtimia nunaka yamaikia turatsui. Tura wainiat wina aparu Yusringkia tuke wijai pujuwitai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Tura asamtai atumi apari tangkurin pengker wainkamiaja nuka atumsha paan nekarme. ");
INSERT INTO acuNT_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Turayat wina akirkatniua nunaka tsanur yapaijturayi. Tura wainiat Yuska wina pase awajtursatniunka pengké tsangkamrukchayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Antsu atumi apari chichartak: Tangku antutramu akiinauka aminu arti turutmati, uchirin mash antutramun jererarmiayi. Turasha chichartak: Tangku tsake akiinauka aminu arti turutmati, uchirin mash tsaken jererarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Nu turamuka atumi apariniun atanki, wina surustas Yus turamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","Nuik chivo achiniktin kinta jeau asamtai, karanam chivo tsaake tura antutramu tura painch ainausha cabran entsamrinaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Tura nu karanam Yuse awemamuri wina naarun pachis untsurmatai, wi ayaakun: Juni pujajai timiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Wi tama chichartak: Watska, pe jiista. Chivo ainau cabran entsamrina nuka mash tsake, tura antutramu, tura painchiarmausha ainawai. Labánka amin anangkramak pengker akiirmachu asamtai aitkajai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ame yakat Betelnum kanakum, karanam wantintukmiajme nu Yusetjai. Nuni wi umirkatjame turutkum, kayanam olivo macharin ukarmiame. Watska, yamaikia ju nungkaka ukukim, ame akiinamiame nu nungkanam waketkita turutmiayi, —tusa Jacob nuwari ainaun timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Tamati Raquel Leajai aiminak: —Wetai. Yamaikia ii apari iin suramsatniuka pengké atsawai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Antsu iinka chikich nungkanmaya nuwa nunisang nintimturmaji. Tura surutmaksha warinchu akik surutia nunisang surutmaku asa, nu kuikiancha mash amutramkamiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Yus ii apariniun atankimia nuka yamaikia iinuitai, tura ii uchirinuitai. Iin kasartamkau asamtai, Yus turama nuka timiatrusmek umikta, —tusar tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","18","Tura Jacob ni waririn mash yaruak, apari pujuya nuni wetas, uchiri ainaun tura nuwari ainauncha camellonam entsamtikiamiayi. Tura Padan-aram nungkanam pujus, tangku ainaun ni takatrijai sumakmia nujai jiinkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Tura Labánka oveja uren awartas weai, Raquel ni apari jeen itarkanam waya, apari yusri ainaun, Yuschau waininayat aints ainau najanamun kasamak jukimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Kame, Jacob ni juuntri wainiat, arameo aints Labán naartinun: Weajai tutsuk uumruk ukukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Tura niinu ainaunka mash juki wemiayi. Tura entsa Eufrates tutain katingkiar, Galaad muranmanini wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Jacob wemau tres kintia nangkamarai: —Awem Jacob weyi —tusar, Labánkan ujakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Tura ujakaram, Labán ni weari ainaujai Jacobon papeekarmiayi. Tura siete kintia nangkamarai, Galaad muranam amankiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Tura wainiat nu kashi Yus Labánkan karanam wantintuk: —¡Antukta! Jacob pase chicharkaip, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Tu chichaamtai, tsawaarak Labán Galaad muranam Jacob ni weari ainaujai kanamunam amankau asa, Labánsha nuni nuwap jea ainaun jeamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Tura Labán Jacobon weri jiyak: —¿Waruka anangkruam nawantrusha mesatkan juwinawa nunismeksha jurutkinme? ");
INSERT INTO acuNT_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","¿Waruka weajai turuttsuksha uumrutkamsha wemame? Ame weajai tusam ujatkaakminkia, wikia namperan najankun, tampurjai tura kitarjaisha waramtiksan akupkaajme. ");
INSERT INTO acuNT_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Tura wainiatum ameka nawantrumka tura tirangmesha aujsam tura mejeasam akupkata turutsuk, aints waurin warukamnawaita numamtin wajasume. ");
INSERT INTO acuNT_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Atum ainautirmin pase awajsatasan wakerayatun turachminuitjai. Yaau kashi aparmi Yusri wina karanam chichartak: Antukta. Jacob pase chicharkaip turutmayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Tura aparmi jeen waketkitasam timiá wakerayatmesh, ¿waruka wina yusrusha kasartukmame? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Tamati Jacob Labánkan ayaak: —Nuwarun atantruki tusan shamkartakun ainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Antsu wijai wekau kichkiksha ami yusrumin takaku wainkakminkia, nuka jakati. Juni ii weari ainau antinamunam tajame: Wi aminun takakii ame wainkamka, pachitsuk jurumkita, —timiayi. Antsu Raquel apari yusri ainaun kasamkamunka Jacobka nekaachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Tamati Labán Jacobo kanutirin wayaa, nunia Lea kanutirincha wayaa, tura jimiar inatiri ainau kanutirincha wayaa, ea eaka waintsachmak jiinki, nunia Raquela kanutirincha wayaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","35","Turamtai Raquel chicharak: —Apaachia, kajertukaip. Nuwati nantu waintaiya nujai pujajai. Tura asan wajakchamin nekapeajai, —timiayi. Tamati ni apari yusri ainaun camello keemtainam uurkau asa, nuni keemas pujumiayi. Tura asamtai Labán ea eaksha pengké wainkachmiayi. Tura wainkachu asamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Jacob kajek Labánkan jiyak: —¿Tuwaita wina tunaarsha? ¿Tura wari paséna takasja? ¿Waruka winasha timiá papeetkamsha wekaame? ");
INSERT INTO acuNT_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Warir ainauka mash jiisume. ¿Antsu aminun wi jukimusha tuwa waitrukume? ¡Watska, nu yaruakam, ami wearam ainau tura wi wear ainau irunina juni ikiaunkam: Ju jurutkinume turuttia! —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Tura ataksha chicharak: —Wikia veinte musach amin yainkamiajme nuningkia oveja tura chivosha kichkiksha pengké shimtikiachmiajai. Tura oveja uchirinkesha aminun kichkiksha pengké yuwachmiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Tura yukartin maamunkesha jukinka itarchayajme. Antsu tangku mengkakamtaikia, wiki nunaka akiiminuyajai. Tura tsawaisha tura kashisha tangkurmin kasamkaramtaisha: Ameka akirkata turutnuyame. ");
INSERT INTO acuNT_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Tsawaikia seemakun waitninuyajai. Tura kashisha tsetsemakun kanutsuk tsawainuyajai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Tu takakmakun veinte musach ami jeemin pujusuitjai. Tura ami nawantrumin nuwatkataj tusan, catorce musach takakmasmiajai. Nunia tangkuram ainaun seis musach wainkamiajai. Tura wainiatum wina akirkatniusha tuke yapaijnuyame. ");
INSERT INTO acuNT_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Wina apachru Abrahama Yusri wina apar Isaac tuke pengker awajnuya nuka wijai pujachmataikia, winasha misu weta tusam akuptukmin awajtusmiame. Antsu Yuska wi waitnasmaurun tura kakaram takakmasmaurun nekau asa, yaau kashi amin chichartamak: Jacob pase chicharkaip turammayi, —tusa Jacob Labánkan timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Tamati Labán Jacobon ayaak: —Nuwa aina juka wina nawantur ainawai. Tura uchi aina jusha wina tirangkur ainawai. Tura oveja aina jusha winar ainawai. Tura juni mash wainme juka winar ainawai. Tura asamtai nawantruncha, tura ni uchiri ainauncha ¿warukamtaik pasenash awajsatjak? ");
INSERT INTO acuNT_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Tura asamtai juni winita. Iisha pengker awajnaisar chicham najanami, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Tamati Jacob kayan juki piangkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Tura ni weari ainauncha chicharak: —¡Kaya irumrataram! —tamati kayan irumramiayi. Tura kaya irumramunam pujusar mash iruntrar yuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Turawar Labán kaya irumramun ni chichamejai Jegar Sahaduta inaikiamiayi. Antsu Jacobka ni chichamejai Galaad inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Nunia Labán chichaak: —Kaya irumramua juka ii pengker awajnaisar chicham najanaji nuna paan iwainturmaji. Tura asamtai nuna naaringkia Galaad inaikiamuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Nunia Labán Jacobon chicharak: —Wi amijai kanakamtai, wainaitsuk pujustin asakrin, Apu Yus tuke iinka waitmaktaji —timiayi. Tu tinu asamtai nu kaya irumramun Mizpa inaikiarmiayi. (Mizpaka waitmaktaji tamaujai metekaitai.) ");
INSERT INTO acuNT_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Tura Labán ataksha Jacobon chicharak: —Wina nawantur ainaun pase awajkumningkia, tura chikich nuwa ainaun nuwatkumningkia, wikia nunaka wainkashtinuitjai. Antsu Yuska tuke waitmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","52","Jiisia, ju kaya irumramua juka, tura kaya piangkimu jusha iijai chicham najanamun antukua tumaun ukuajai. Tura asamtai pase awajnaisatasar ameka turawisha juni nangkamakchatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Ame apachrum Abrahama Yusri, tura wina apachru Nacora Yusriya nusha iin jiirmasar nekaamawartin ainawai, —Labán timiayi. Tamati Jacobsha chichaak: —Wina apar Isaac Yusen tuke seaya nuna naari pachisan tajai: Yuska itiur nintimji nuna mash nekawa nuka iincha waitmaji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Nunia Jacob nu muranam tangkun maa, Yusen susatas epeamiayi. Tura ni weari ainaun: Mash yuwitaram tusa untsukmiayi. Turamtai mash iruntrar yuwaar umisar nu muranam kanurarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Tura kashin tsawar Labánka nantaki ni tirangki ainaun mejeas, tura nawantrincha mai mejeas: —Yus atumin waitmakti —tusa ni nungkarin waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Jacob jinta we ai, Yuse awemamuri ainau ingkuniktasar tariarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Turinamtai Jacob nuna wainak: —Yuse suntari untsuri wininawai, —timiayi. Tura asa nu nungkanka Mahanaim inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","4","Nunia Jacob ni inatiri ainaun akatar akupak: —Yatsur Esaú Seir nungkanam Edomnum pujamunam werum, yachim winawai tusaram ujaktaram. Tura chichaakrum: Yachim Jacob chichaman akupturmak: Jiichur Labánjai untsuri musach pujusan, yamaikia inatiram atasan waketkin winajai. ");
INSERT INTO acuNT_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Tura vacartuk, tura burrortuk, tura ovejartuk, wina inatir aishmang tura nuwa ainaujai winau asan, tura wisha ami inatiram asan, pengker nintimtunisar wainaikiami tusan wakerajai, tawai tusaram ujaktaram, —tusa ni inatiri ainaun akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Tamati nu chichaman jukiar, Esaúnum jeariar ujakarmiayi. Tura ataksha tariar Jacobon ujainak: —Ame timiame nunisrik Esaúka ujakmaji. Turam yamaikia amin ingkungmaktas ni aintsri cuatrocientos yaruak, nujai winitramui —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","8","Tura ujainam Jacob yachiin shamak napchau nintimias, ni aintsri ainaun jimia apatuk akanak ovejarincha, vacarincha, tura camellorincha jimia apatuk akankamiayi. Tura: Esaúkichik akankamun juamtai, chikich akankamuka tupikiakchatpiash tu nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Tura Yusen seak: —Apaachiru Yus, wina apachur Abrahama Yusrinme. Tura wina apar Isaacka Yusrinme. Ame wina chichartakum: Ame nungkarmin waketkita. Turakmin pengker awajsatatjame turutmiame. ");
INSERT INTO acuNT_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Wi tunau aing, wina pengker awajtusam, ajapruamka ukurkichmiame. Wikia aya ushkrumtairun takusan Jordán entsan katingmiajai. Turayat yamaikia ame surusmau ainauka jimiar akankamu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Tura asamtai wait aneasam yatsurnia uwemtikrurta. Yatsur aneachmau winaksha nuwarnaksha tura uchirnaksha manturtuawai tusan shamajai. ");
INSERT INTO acuNT_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Antsu ame wina chichartakum: Amin pengker awajsatatjame tura ami wearam yaikmia nunisarang pengké nekapmarchamin untsuri yujratatjame turutmiame, —tusa Jacob Yusen seak timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","15","Tura nu kashi Jacob nuni kanur tsawaar, doscientas cabras, veinte chivos, doscientas ovejas, veinte carneros, nunia treinta camellos nuwari uchin yamai jererun uchirtuk, nunia vaca ainaun cuarenta, nunia vaca uchiri aishmang ainaun diez, nunia burras veinte, tura burro ainaun diez ni yachi Esaún susataj tusa akankamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Nunia ni inatiri ainaun tangku akankamurin susa chicharak: —Akankamu ainauka angkan angkan jukirum estaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Tura eemak akupamurin inatirin chicharak: —Yatsur Esaú ingkuakmeka, chichartamak: ¿Yana inatirinme? ¿Turasha tua weame? ¿Ju tangku ainau yaruakam winame jusha yanawaita? turamataikia: ");
INSERT INTO acuNT_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","Apuru Esaúwa, juka inatiram Jacobnawaitai. Ningka ukunam winak: Ju ainau jukirum eemtikiaram, nangkamrum wina yatsur susataram turutmayi tita, —tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Tura chikich inatiri ainauncha akatar akupak: —Atumsha yatsur Esaújai ingkunikrumsha, nuke titaram. ");
INSERT INTO acuNT_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Tura kajinmatsuk: Ami inatiram Jacob iin ukurin winawai titaram, —timiayi. Kame, Jacobka nintimias: Ju tangku ainaun eemkan akuptukmaun nangkami jukiti tinamtai, kajertuk pujayat, yatsur nuna wainak tsangkur wina pengker awajtuschatpiash. Nuniangka wikia niijai ingkiuniktatjai, tu nintimias nunaka turamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Tura tangku ainaun nangkami yachiin susartinnaka eemak ni inatiri ainaujai akupkau asa, Jacobka ni weari ainaujai juwak nuni kanurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","23","Tura kashi japeng nantaki, Jacob ni nuwarincha mai, tura nuwari inatirincha mai, tura uchirin once amia nuna entsa Jabocnum jear: Tumajin katingtaram tusa, nunia tangkurisha mash ni aintsri ainaujai katingkiarti tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Tura Jacobka ningki juwakmiayi. Turamtai Yuse awemamuri aintsua tumau tari, nijai nekapnaisami tusa, achiinikiar maa maaninai tsawaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Tura Yuse awemamuri Jacobon nepetkatatkama tujintak, yantajnum ijuu muunmamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Tura Jacobon chicharak: —Akuptukta, tsawaarui tama, Jacob ayaak: —Atsa, Yus amin pengker awajtamsati turutchakminka akupkashtatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Tama Yuse awemamuri Jacobon iniak: —¿Amesha yaachitme? —timiayi. Tu iniam: —Jacoboitjai —timiayi. (Nuka anangkartin taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Tamati Yuse awemamuri chicharak: —Ame Yusjai tura aintsjaisha maaniakmesha nepetmaku asam, yamai nangkamsamka Jacob tutai achatatme. Antsu Israel tutai atatme, —timiayi. (Yamaram naaringkia Yusjai maaniawai taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Tamati Jacobsha iniak: —¿Amesha yaachitme? —timiayi. Tamaitiat ni ayaak: —¿Waruka yaachitme turutme? Yus amin pengker awajtamsati —tusa wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yuse awemamuri weamtai, Jacob nintimias: —Yusen wina jiirujai wainkajai. Turayatun jakachjai, —tusa nu nungkanka Penuel inaikiamiayi. (Nuka Yuse yapii taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Tsaa taakmatai Jacob munmamtikiamu asa, wekaasatatkama shitua shitua wekaimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kame, Yuse awemamuri Jacobon yantajnum ijumu asamtai, yamaiya juisha Israela weari ainauka kuntinu mamingkurin yaap iruna nunaka yuchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","2","Jacob nunia pangkai jiimkama, Esaú cuatrocientos aintsrijai wininaun wainak, Leancha ni uchiri ainaujai, tura Raquelnasha ni uchiri ainaujai, tura ni inatiri jimiaran ni uchiri ainaujai akantramiayi. Tura inatiri jimiar ni uchiri ainaujai eemtikramiayi. Nunia nuna ukurin Lean ni uchiri ainaujai awajsamiayi. Nunia nuna ukurin Raquelnasha ni uchiri Joséjai awajsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Nunia Jacob nuwarin awajas ukuki eemkamiayi. Tura yachi wajamunam jeatak nijajin nungkan antitnak siete waingki tsuntsumamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Turamtai Esaú wári tari Jacobon minakas mejeasmiayi. Tura mai metek juutiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Nuniasha Esaú nuwa ainaun uchirijai wajainaun wainak: —¿Jusha yaa ainawa? —tu iniam Jacob ayaak: —Ami inatirmin Yus susamu ainawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Tamati Lea inatiri tura Raquela inatirisha ni uchiri ainaujai tariar, nijajin nungkan antitnak tsuntsumruawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Tura Leasha ni uchiri ainaujai nunisarang turawarmiayi. Tura inangnamunam José ni nukuri Raqueljai nunisarang Esaún tsuntsumruawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Tura Esaú pangkai jiis yachiin iniak: ¿Jinta winakun tangku ainaun timiá untsuri wainkamja nusha itur nintimsamea aitkamame? —tama Jacob ayaak: —Pengker nintimtikran amin amastasan aitkamjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Tamaitiat Esaú chicharak: —Atsa, yatsuru, winarusha untsuriyaintai. Aminu aina nuka tuke aminuk arti, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Tamaitiat Jacob chicharak: —Atsa, yatsuru, wait aneasam, wi akuptukmajmena nukeka jurumkita. Ame nekas pengker nintimturkum jurukin asakmin, yapimin wainkau asan, Yuse yapiin wainkan nintimtumaschainja nunisnak nintimjai. ");
INSERT INTO acuNT_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Yus wina tangkur ainaun nukap yujrau asamtai, wikia yuumatsuk pujajai. Tura asamtai wait aneasam, wi itiarjame nuka jurumkita —timiayi. Tama tama Esaú ayu timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Tura yachiin chicharak: —Wetai, wikia eemajatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Tamaitiat Jacob ayaak: —Yatsuru, wina uchir tuupich ainawai. Tura oveja ainau tura vaca ainausha yama jereru asar, wári weamunmayangka pimpikiar jakamin ainawai. Amesha nuka nekasaintai tusam nekame. ");
INSERT INTO acuNT_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Yatsuru, ameka eemajata. Wikia tangkur ainaun, tura uchir ainauncha yaruakan yaaitasan winitatjai. Tura Seir nungkanam ingkiuniktatji —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Tamati Esaú yachiin chicharak: —Antsu wina nemarinauka amin yainmakarti tusan ukurkitjame, —timiayi. Tamaitiat Jacob ayaak: —Wait aneasam, nuka turuwaip. Nunaka yuumatsjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tamati Esaú nu kintati Seirnum waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Turamtai Jacob jintá wekaak, Sucotnum wemiayi. Tura nuni jea, jean jeamkamiayi. Tura tangkuri ainau pujustinasha aakmakmiayi. Tura asamtai nu nungkan Sucot inaikiamiayi. (Sucotka aakmakmau taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Jacob Padan-aramnumia jiinki, Canaánnum pengker jeamiayi. Tura yakat Siquemnum jeatak pujusmi tusa, jea ainaun jeamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Tura Siquema apari Hamoran cien kuikian akimiak, nungkarin sumak nuni pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Tura nuni kayan irumrar, Yusen maaketai titas, tangku epetin najanamiayi. Tura najana umis, El-Elohe-Israel inaikiamiayi. (Nuka Israela Yusrintai taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Chikich kintati Lea nawantri Dina naartin Jacob yajutmarmia nuka nu nungkanmaya nuwa ainaun jiistas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Tura weai Hamora uchiri Siquem Dinan wainkamiayi. Kame, nu Hamorka heveo aintsuyayi. Tura nu yakta apuri ayayi. Tura Siquemka Dinan achik, ni wakerachmaitiat tepersamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Turayat nu nuwachin aneak, niisha anenti tusa wakerimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Tura aparin chicharak: —Au nuwan nuwatkatasan wakerajai. Tura asamtai aparin weme sumartukta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Turamtai Siquem ni nawantrin pase awajsamun Jacobka nekaamiayi. Antsu nekayat ni uchiri ainauka tangku ainaun waininak pujuinau asaramtai, ni taarti tusa pachischamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Tura Siquema apari Jacobjai chichastas werimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Tura Jacobo uchiri ainauka tangku ainaun waininak pujuinau taar, Siquem Dinan pase awajsamun nekaawar, ni turamurin pachisar: —Aints kichkisha nuka pengké turachminuitai —tusar kakaram kajekarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Turinamaitiat Hamor niin chicharak: Wina uchir Siquem atumi umaji nukap aneawai. Tura asamtai wait aneasrum nuwatkat tusaram tsangkatkataram. ");
INSERT INTO acuNT_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Turaram atumsha ii weari wajastatrume. Turakrumin wi wear ainauka atumi nawantri ainaun nuwatkarti, tura atumsha nunisrumek ii nawantri nuwatkataram. ");
INSERT INTO acuNT_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Turaram atumsha iijai pujustaram. Nungkaka angkantaitai. Tura asamtai waring achat mash surakrum tura sumakrumsha nungka ainausha sumaktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Tura apari chichas umisamtai, Siquemsha Dina aparin tura umaji ainaun chicharak: —Wait aneasrum ayu titaram. Turaram atum warí wakerarme nunaka seatkurminkia susatjarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Kame, nuwa nuwatkur tuke sunaisatniun aa nuna nangkamasmek surusta turutkurminkia, nunasha pachitsuk susatjarme. Antsu nuwawach wina ninumkati tusaram tsangkatruktaram —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Tamaitiat Siquem Dinan pase awajsau asamtai, Jacobo uchiri ainau Siqueman tura ni apari Hamornasha anangkinak: ");
INSERT INTO acuNT_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","—Iikia tujintaji. Ii aintstikia aishmangku nuwapchirin charutkachmauka, nuwan nuwatkatnuka natsanpiakuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Antsu atumsha iijai metek iiya nunisrumek atumi nuwapchirin charukakrumningkia, ayu timinuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Turakrumningkia atumi uchiri ii nawantrin nuwatin artinuitai. Tura ii uchiri ainausha atumi nawantrin nuwatin artinuitai. Turuniakrikia ii kichik pataachiria nunisrik wajasminuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Antsu atum nu nakitakrumningkia, ii umaji jukir juniangka jiinkitatji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Tinamtai Hamor ni uchiri Siquemjai mai: —Ayu, iisha nuka metek umiktatji —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","20","Siquemka Jacobo nawantrin nukap wakeruku asa, numatik kati nuwapen charukmiayi. Tura Siquemka ni jeen chikich ainaun nangkamas chichaman antin asa, ni aparijai yakta waitirin wearmiayi. Kame, nuningkia tuke iruntrartin armiayi. Tura jear, aishmang ainau iruntramunam chicharinak: ");
INSERT INTO acuNT_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","—Israela weari ainauka pengker ainawai. ¿Ii nungkaringkia nekas angkanchaukai? Tura asamtai yamaikia iijai iruntrar pujusartin ainawai. Tura waring achat mash surukmin tura sumakmincha ainawai. Tura asaramtai iikia ni nawantrin nuwatin artinuitji. Tura niisha ii nawantrincha nuwatin artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Antsu ii kichik pataachiria nunisrik pujusrikia, ni tuke turin aina nunisrik aishmang ainautikia ii kati nuwapen mash charuktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Tura asamtai ni tina nuka umikiarmi. Tura asakrin ni wariri ainau tura tangkuri ainausha mash iinu artinuitai, tura iijai pujusartin ainawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Tinamtai nu yaktanmaya aishmang suntar naamkatin armia nuka nuna antukar, ayu tusar, mash kati nuwapen charukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Turawaru asaramtai Jacobo uchiri Simeón, tura Levisha, Dina umaji armia nuka tres kinta tsawaaru ai, yaktanam wear, aishmang ainau charumakaru asar, najaiminak kakaarchamin nekapenau asaramtai, saapijai mash maawar ukukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Tura Hamornasha tura uchiri Siquemnasha maawar, umaji Dinanka Siquema jeenia jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Turawaramtai Jacobo uchiri chikich ainauka tariar, jaka tepearmia nuna waririn pachitsuk yaruakar jukiarmiayi. Ni umaji pase awajsamunka tu yapaijkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Tura oveja ainaun, vaca ainauncha, tura burro ainauncha yaruakar, yaktanam mash irunmia nunasha yaruakar, ajanam irunmia nunasha yaruakar, mash jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Tura jeanam pachitsuk wayaawar, warinchu ainaun yaruakar, uchi ainaun tura nuwa ainauncha misatkan achikiar jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Turawaramtai Jacob Simeónkan tura Levincha chicharak: —Atumka wina itiurkachmin awajtusurme. Wi wear ainauka jumchik asakrin, cananeo tura ferezeo ju nungkanam pujuinauka irunturar mesetan najanawar ii ainautinka mash mantamatnuitji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Tamaitiat niisha aparin aimainak: —¿Ii umajijai kungkatpia nunisang tepestinkai? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Nunia Yus Jacobon chicharak: —Yamaikia junia jiinkim, Betelnum weme nuni pujusta. Yachim Esaú shamakum weaamin wantintukmiajme nuni wina maaketai turuttia. Tura asam tangku epetin najanata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yus tamati Jacob ni weari ainaun tura niin nemarin armia nuna chicharak: —Atumi yusri aints najanamu ainauka mash juni itataram. Turaram maakrum atumi entsatiri nijarum pakuichau entsartaram. ");
INSERT INTO acuNT_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Turakrumin arutsuk Betelnum wearmi. Tura yaanchuik wi itiurkachminum pujai, Yus wina yainkau asamtai, tura tuni wekaimiaja nuni tuke wina nemartuku asamtai, Yusen maaketai titasan tangku epeatniun najanatatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Tu tinu asamtai ni yusri aints ainau najanamun, tura kuwishnum nenaatai ainauncha mash yaruakar, Jacobon susarmiayi. Turinamtai Jacob nuna mash juki, numi encina tutai Siquemnum arakchichu wajamunam tai warinchun chumpia yukuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Tura Jacob ni weari ainaujai Betelnum weenamtai, nu nungkanmaya ainau mash Israela weari ainaun papeekcharti tusa Yus sapijmamtikiamiayi. Tura asamtai papeekcharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Jacob ni weari ainaujai Canaán nungkanam yakat Luz tutainum jearmiayi. Nu yaktaka chikich aints ainau Betel tutai inaikiaru armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Tura Betelnum jearamtai, nuni yachiin shamak yaanchuik tupikiaki weak kashi kanamtai, Yus niin wantintukmiayi. Tura asamtai Jacob nuni Yusen maaketai titas, kaya ainaun irumar tangku epeatniun najana El-Betel inaikiamiayi. (Nuka Betela Yusri taku tawai.) ");
INSERT INTO acuNT_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Nuniangka Rebeca wainiuri Débora naartin jakamiayi. Tura jakamtai, Betelnum jeatak numi encina tutai wajamunam iwiarsarmiayi. Tura asaramtai nu numikia “juutmiu numi” inaikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Kame, Jacob Padan-aram nungkanmaya waketkin asamtai, Yus ataksha wantintuk, pengker awajak, ");
INSERT INTO acuNT_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","chicharak: Ameka Jacob naartinuitme. Antsu yamai nangkamsamka naarmeka Jacobka achatatui, antsu Israel atatui —timiayi. Yus Jacobo naarin yapaijtua ");
INSERT INTO acuNT_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","chicharak: —Wiitjai Yusetjai. Mash aina nuna nangkamasang nekasan kakarmaitjai. Tura asan tajame: Ami wearmin ainauka nukap yujararti. Tura asaramtai ami wearam untsuri nungkanam pujusar, nu nungkanmaya ainauncha inarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Tura Abrahaman tura Isaacnasha nungkan susamiaja nunaka amincha suajme, tura ami wearmincha susartinuitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Tura Yus Jacobon chichas umis weamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Jacob kayan juki, Yusjai chichasmau tutai ati tusa piangkimiayi. Tura Yusen maaketai titas, olivo macharin tura vinoncha kayanam ukatramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Nuna tura nu nungkan Betel inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Tura Betelnumia jiinkiar, yakat Efratanam jeatak wajasar, Raquelka uchin jerertatkama yuumatkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Tura uchin jerertas jateemaa nukap wait wajak uchin jereramtai, jurin chicharak: —Shamkaip, aishmang jererume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Tamati Raquelka jakatas wakerak, nu uchin Benoni inaik jakamiayi. Antsu apari Benjamin inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Raquelka tu jakamiayi. Tura jakamtai jinta Efrata yakat jeakunam iwiarsarmiayi. Tura nu yaktaka yamaikia Belén inaikiamuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Tura Jacobka Raquela iwiarsamurin kaya najanamun awajsamiayi. Tura yamaiya juisha nuka Raquela iwiarsamurintai tusar inakmasaru ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Tura Israel ukuki nunia tuke jintanam weak, jea juuntan jeamkamun nangkaiki wee pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Tura nu nungkanam pujuinai, Rubénka ni apari chikich nuwari Bilha naartiniun pase awajsamiayi. Turamtai Israel nuna nekaa nukap kajekmiayi. Jacobo uchiri doce armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Lea jerermau ainauka Rubén, Simeón, Leví, Judá, Isacar, tura Zabulón, ju armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Raquel jerermauka José tura Benjamín armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Raquela inatiri Bilha jerermauka Dan tura Neftali armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Tura Lea inatiri Zilpa jerermauka Gad tura Aser armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Nunia Jacobka ni apari Isaackan yakat Mamre tutainum jiista tusa wemiayi. Nu yakta naari jimiaraitai. Arba tura Hebrón nu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","29","Isaacka juuntach wajas, ni kintari jeamtai, ciento ochenta musachrintin jakamiayi. Tura jakamtai ni uchiri Esaú Jacobjai iwiarsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","2","Esaú, chikich naari Edom Canaán nungkanmaya nawantrin nuwatkamia nuka ju ainawai: Hitita aints Elón naartinu nawantri Ada, tura chikich aints Aná naartinu nawantri Aholibama. Nuka heveo aints Zebeón naartinu tirangki ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","Nunia chikich nuwan Basemat naartinun nuwatkamia nuka Ismaela nawantri tura Nebaiota umaji ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Esaú uchiri Adanam yajutmarmia nuka Elifaz ayayi. Tura Besematka ni uchirin Reuel naartinun jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Tura Aholibama ni uchiri ainaun Jeús, Jaalam tura Coré jerermiayi. Esaú Canaán nungkanam pujamtai, nu uchi ainauka nuni akiinawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","8","Ni yachi Jacobjai kanaktaj tusa, Esaú ni nuwari ainaun, tura uchiri nunia nawantri ainauncha, tura ni jeen pujuinauncha, tura tangkuri ainauncha tura Canaán nungkanam pujus, waririn takakuya nuna mash yaruak, mura Seir tutainum wemiayi. Kame, mai metek timiá untsuri tangkurtin asar, tangku ainau yuwatniurisha jeachuyayi. Tura nuna nangkamaska nungka angkan atsuyayi. Tura asamtai tsaniasar pujustatkamawar tujinkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Esaú edomita ainau apachri ayayi. Nu aints ainau mura Seir tutainum puju armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Kame, Esaú uchiri naari ju ainawai: Esaú uchiri Adanam yajutmarmia nuka Elifaz ayayi. Tura Basematnum yajutmarmia nuka Reuel ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Elifaza uchiri ju armiayi: Teman, Omar, Zefo, Gatam tura Cenaz. ");
INSERT INTO acuNT_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Tura Elifazka chikich nuwan apatkamia nuna naari Timna ayayi. Nuka uchin jerer, Amalec inaikiamiayi. Nuka Esaú nuwari Ada naartinu tirangki ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Tura Reuela uchiri ju armiayi: Nahat, Zera, Sama tura Miza. Kame, nusha Esaú nuwari Basemata tirangki armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Esaú chikich nuwari Aholibama uchiri ju armiayi: Jeús, Jaalam tura Coré. Aholibamaka Aná nawantri ayayi. Tura Zibeónka tirangki ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Esaú weari apu naamkaru ju armiayi: Esaú uchiri eemkauri Elifaz naartinu weari ainauka Temán, Omar, Zefo, tura Cenaz, ");
INSERT INTO acuNT_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Coré, Gatam tura Amalec mash apu naamkaru armiayi. Nuka Edom nungkanam pujusar, Elifaza weari asar, mash Ada tirangki armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Tura Esaú uchiri Reuel naartinu uchiri ainausha aintsu apuri armiayi. Ni naaringkia ju ainawai: Nahat, Zera, Sama, tura Miza. Nuka mash Reuela uchiri apu naamkaru armiayi. Tura nusha Edom nungkanam pujusar, Basemata tirangki armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Tura Aná nawantri Aholibama naartin Esaú nuwatkamia nuna uchirisha aintsu apuri wajasarmia nuka ju armiayi: Jeús, Jaalam tura Coré. ");
INSERT INTO acuNT_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Nuka mash Esaú weari amiayi. Esaú chikich naaringkia Edom amiayi. Kame, nuka mash aintsu apuri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","21","Horeo aints Seir naartinu uchiri Edom nungkanam pujuarmia nuka ju armiayi: Lotán, Sobal, Zibeón, Aná, Disón, Ezer tura Disan. Nu aints ainauka Horeo ainau apuri armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Tura Lotana uchiri ju armiayi: Hori tura Hemam. Timnasha Lotana umaji ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Sobala uchiri ju armiayi: Alván, Manahat, Ebal, Sefo, tura Onam. ");
INSERT INTO acuNT_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Zebeónka uchiri ju armiayi: Aja tura Aná. Anáka aints atsamunam ni apari burrorin wainak pujus, entsa pukuni ainaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Aná uchirisha Disón naartin amiayi. Tura nawantri Aholibama naartincha amiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Disónka uchiri ju armiayi: Hemdán, Esbán, Itrán tura Querán. ");
INSERT INTO acuNT_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ezera uchiri ju armiayi: Bilhán, Zaaván, tura Acán. ");
INSERT INTO acuNT_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Disánka uchirisha Uz tura Arán armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Horeo apuri ju armiayi: Lotán, Sobal, Zibeón, Aná, ");
INSERT INTO acuNT_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Disón, Ezer tura Disán. Nu Horeo apuri ainauka ni weari ainaujai Seir nungkanam pujuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israela weari apuri atsaing, Edom nungkanmasha ju aints ainauka apu naamkaru armiayi: ");
INSERT INTO acuNT_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Beora uchiri Bela naartin Edomnum yakat Dinaba tutainum apu wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Tura Bela jakamtai, Zera uchiri Jobab naartin apu wajasmiayi. Nuka Bosra nungkanmaya aintsuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Tura Jobab jakamtai, Temánmaya aints Husam apu wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Tura Husam jakamtai, Bedada uchiri Hadad apu naamkamiayi. Nuka Moab nungkanam Madián aints ainaun nepetkamiayi. Nuka yakat Avit tutainumia aintsuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Tura Hadad jakamtai, yakat Masreca tutainumia aints Samla naartin apu naamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Tura Samla jakamtai, aints Saúl naartin apu naamkamiayi. Nuka yakat Rehobot tutainumia aintsuyayi. Nu yaktaka entsa ayaamas ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Tura Saúl jakamtai, Acbora uchiri Baal-hanán apu naamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Tura Baal-hanán jakamtai, Pau yaktanmaya aints Hadad naartin apu naamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Esaú weari ni nungkari ainau naarisha ju ainawai: Timna, Alva, Jetet, ");
INSERT INTO acuNT_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Aholibama, Ela, Pinón, ");
INSERT INTO acuNT_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Cenaz, Temán, Mibzar, ");
INSERT INTO acuNT_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdiel, tura Iram. Esaú chikich naari Edom tutai amiayi. Kame, nu aints ainauka Edom nungkanam apu naamkaru armiayi. Tura ni yaktari naarisha mash inaikiamu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Jacobka Canaán nungkanam yaanchuik ni apari pujuya nuni pujusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Juwaitai Jacob ni uchiri ainaujai turamuri: Jacobo uchiri José dieciciete musachrintin asa, ni kaná yachi ainaujai oveja wainuyayi. Tura ni kaná yachi nukuri Bilha tura Zilpa armiayi. Nu jimiar nuwaka Jacobo nuwari inatiri armiayi. Tura Joséka ni yachi ainau pase turamurin aparin ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Kame, Israelsha timiá juuntach ayat yajutmaru asa, chikich uchiri ainaun nangkamasang Josén timiá aneemiayi. Tura asa entsati nekas sarman tura shiirman najatamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Tura asamtai José yachi ainau nuna wainkar: —¿Warukamtai aparka Josén timiá aneawa? Antsu iinka miatka anenmatsji tusar, Josénka suwirpiaku jiinak kajerkarmiayi. Tura asar aujnaitsuk pengkerka awajsacharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","8","Chikich kintati José karamramiayi. Tura asa ni yachii ainaun chicharak: —Wi karanam wainkaja nuna ujaktatjarme. Anturtuktaram: Karanam ii ainautikia ajanam trigo numirin charurar mujurti tusar jingkiar piangkimji. Tura wina jingkiamur tupin wajasamtai, atumi jingkiamuri ainau wina jingkiamurun tsuntsumruawarmayi, —timiayi. Tu tamati ni yachii ainau kajerkar chicharinak: —¿Ameka ii apuri wajasam iin inakratkatasmek wakeram? —tiarmiayi. Tura José ni karamramurin ujaam, ni yachi ainau nuna nangkamasarang kajerkar suwirpiaku jiisarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Nunia José ataksha karamramiayi. Tura yachii ainaun ujaak: —Wi karanam wainkaja nuka nekaataram. Karanam tsaasha tura nantusha tura yaa once aina nusha wina tsuntsumrutawarun wainkajai, ");
INSERT INTO acuNT_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","—aparin tura yachii ainaun ujakmiayi. Tamati apari chicharak: —¿Ame karamramuram warimpita? ¿Wiyaash nukurmijai tura yachim ainaujiash amin tsuntsumruataij? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Nunia ni yachii ainauka Josén nukap suwirpiaku jiisarmiayi. Antsu Jacobka: —¿Warukakung tuusha karamra? —tusa nukap nintimias pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Chikich kintiati José yachii ainau apari ovejari ainau yuwatniurin eakartas, Siquem nungkanam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Tura nuni pujuinai, Israel Josén chicharak: —Anturtukta. Yachim ainau Siquemnum ovejan waininak pengkerash pujuina tusam nekauta, —timiayi. Tama José ayu timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Ayu tamati, Israel chicharak: —¿Yachim ainau tura oveja ainausha pengkerash pujuina tusam jiisam, ataksha tame ujatkata, —tusa Hebrónka pakarinia akupkam, José Siquemnum jeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","Tura yachii ainau pujuinamunam jeatatkama, waak wekai aints wainak: —¿Warí eakmea wekaame? —tu iniam, ");
INSERT INTO acuNT_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","José ayaak: —Yatsur ainaun eakun wekaajai. ¿Antsu tuni ovejan waininak pujuina tusam nekatsmek? ");
INSERT INTO acuNT_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","—tama ayaak: —Yachim ainauka juniangka jiinkiar, Dotannum wearmi tinaun anturkarmajai, —tu tama, Joséka yachii ainaun eaak wekaas Dotannum pujuinaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Tura José winamtai, yachii ainauka Josén arák winaun wainkar, maatniun chichaman najanawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Tura mai nuwamtak chichainak: —¡Jiistaram, karamin winawai! ");
INSERT INTO acuNT_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Watska, tati. Tura taamtai maar, waanam ajuarmi. Turar ii aparin jearir ujaakur: ¿Pachim yuwachiash? timi. Tura ni karamramurisha warukating? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Tinamtai Rubén nuna antuk Josén ayamruktas wakerau asa, yachii ainaun chicharak: —Atsa, maachmi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Antsu maatsuk waa yumi atsamunam engkeataram. Kame, maami timauka inaisataram, —timiayi. Tura arum jiikin apar pujamunam akupkatjai, tu nintimias nunaka timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Nunia José ni yachii pujuinamunam tamiayi. Tura taamtai, achikiar wejmakri shiirman aitkar jurukiar, ");
INSERT INTO acuNT_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","waa yumi atsamunam ujuararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Turawar yurumkan yuwatasar keemsarmiayi. Tura yuwinak pujuinai, Galaad nungkanmaya ismaelita ainau perfume, tura bálsamo ainauncha, tura mirra Ejiptonam surukmi tusar, camellonam aantsar wininaun wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Tura wainkar Judá ni yachii ainaun chicharak: —Ii yachi maarkia tura uukrikia, ¿warijing kuikiasha achiktaij? ");
INSERT INTO acuNT_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Antsu maatsuk ismaelita ainamunam surukmi. ¿Wari? ¿Ii yachiinchukait? —timiayi. Tamati ni yachii ainau ayu tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Tura ismaelita ainau Madian nungkanmaya winiarmia nuka nangkaaminamtai, Josén waanmaya jiikiar, veinte kuikiajai surukarmiayi. Tura surukaram, Josén Ejiptonam jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Turawaru ai, Rubén nuni pujachu asa, ataksha waanam waketki, Josén wainkachmiayi. Tura napchau nintimias entsatirin jaakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Nunia ni yachii pujuinamunam we chichaak: —¡Yatsurka waanmangka atsawai! ¿Tura asamtai aparnasha warí titajak? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Nunia cabra uchirin maawar, nuna numpejai José entsatirin yakararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Tura aparin José entsatirin akuptinak: —Ju wainkamji. Tenapkesam nekaata. ¿Nekas uchirmi entsatirinchukai? —tusar chichaman akuptukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Tura chichaman akupkaramtai, Jacob entsatin wainak nekaa: —Nekas uchiru entsatirintai. ¿Pachim yuwachiash? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Tura uchir jakayi tusa, wake mesek wejmakrin jaak, jakmarar entsatin entsar, untsuri kintia juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Tu pujai, ni uchiri ainau tura nawantri ainausha mash jikiamtan nutsumtikrartas wakeriarmiayi. Antsu nakitau asa: —Wikia uchir jakamun pachisan juu juutkan nunia jakan, niijai iruntran inaisatjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Nunia Madianmaya ainauka Ejiptonam jear, suntara apuri Potifar naartinnum Josén surukarmiayi. Nu Potifarka Ejipto apuri faraónka yaintri ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Nu musachtin Judá ni yachi ainaun ukuki, yakat Adulamnumia aints Hira naartinu jeen pujustas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Tura nuni pujus, Canaán nungkanmaya aints Sua naartinu nawantrin nuwatkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Tura nuwatak, nuwari japruk uchin jerer Er inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Tura ataksha japruk, uchin jerer Onán inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Tura Judá Quezib nungkanam pujus, nuwari chikich uchin jerer, Sela inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Tura Judá nuni pujus, uchiri eemkauri Eran nuwa Tamar naartinjai nuwatmamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Tura Erka Apu Yusen pengkerka awajsachmiayi. Tura asamtai Yus jakramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Tura Er jakamtai, Judá Onánkan chicharak: —Wajerim wajemau asamtai, ame niijai tepesam uchi yajutmarta. Turakmin uchi akiinawartin ainauka yachimi uchiria nunisarang tsakatmarta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Tamaitiat Onán: —Uchi akiinawartin ainauka winaruchu artinuitai —tusa, nuna nekau asa, wikia japrumtikiashtatjai tusa, wajerijai kanaksha yajá turamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Onán nuna turamtai, Apu Yus kajerak: Niisha jakati tusa jakramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Yus turamtai, Judáka najati Tamaran chicharak: —Aparmi jeen weme, nuni nakasta. Tura uchir Sela tsakar nuwatramkati, —timiayi. Tamati Tamarka apari jeen pujustas wemiayi. Antsu Júdaka ningki nintimias: Selaka nekas ni yachi ainau jakarmia nunisang jakamnawaitai, tu nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Nukap arus Judá nuwari Súa nanwantri amia nuka jakamiayi. Tura jikiamtan nutsuru asa, Timnat yaktanam ni ovejari uren awartin ainau pujuinamunam ni amikri adulamita aints Hira naartinjai wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Turamtai ni najati Tamar: Juuntur ovejari uren awartas wemayi tusa nuna nekau asa, ");
INSERT INTO acuNT_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wajema entsatin aikmiayi. Tura aints ainau nekarawarai tusa, yapiin tarachjai nukukmiayi. Tura Enaim yakta waitirin jea, jinta Timnatnum jeakunam ayaamas keemsamiayi. Kame, Selaka nampuaru wainiat apari Tamarjai nuwemtikachmau asamtai, nunaka turamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Turamtai Judáka nangkamak najati yapiin nukuk pujaun wainak, kungkatip nuwachuashi tu nintimsamiayi. Antsu najatruapita tusangka pengké nekaachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Tura asa jeari, chicharak: —Iijai tepesmi —timiayi. Tama ayaak: —¿Wijai tepesmesha warí surustatam? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Tu iniam Judá ayaak: —Cabra uchirin akuptuktatjame, —timiayi. Tamati niisha chicharak: —Pengkeraitai. Antsu warí ame takakme nu ukurtukta. Tura cabra uchiri akupturkakmin awangtukmijam —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Tama Judá ayaak: —¿Warina ukurtukit tusamea wakeram? —timiayi. Tama: —Ame ushukrutairmesha, nunia sello cordónjaisha ukurtukta, —timiayi. Tama ayu tusa, nuna susa, Judá nijai tepes japrumtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Turam Tamarka waketki, ni jeen jea, tarach nukumakmaurin aik ukuki, ataksha wajema entsatin entsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Tura nunia Judáka ni amikri adulamita aintsun chicharak: —Ame cabra uchiri kichik jukim, nu nuwan suakum, warinchur wi ukukmaja nu seam itartita tusa, akupkamaitiat nuni jeari, nu nuwanka susatatkama wainkachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Tura aints nuni pujuinaunka iniak: —¿Enaimnumia kungkatip nuwa jinta ayaamas pujumia nusha tuning puja? —timiayi. Tamaitiat ni chichainak: —Kungkatip nuwa juningkia atsuinawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Tu tinam waketki Judán ujaak: —Nu nuwanka wainkachjai. Tura aints nuni pujuinauka: Kungkatip nuwa juningkia atsuinawai turutiarmayi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Tamati Judá ayaak: —Maj, warinchun wi susamja nunaksha jukiti. Warí, ataksha werir eakrinkia wishikrurchartimpiash. Tura nu nuwaka wainkachu asam, wikia cabra uchirin akuptukja nuka susachume. Nuka nekasaintai tusam amesha nekame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Tura tres nantu nangkamaramtai, aints ainau Judán tariar ujainak: —Najatim Tamar chikich aintsnau japruki, —tiarmiayi. Tu tinam Judá kajek: —¡Maj, aa jiikrum keemaktaram! —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Tamati aa keemakmi tusar ni jeen jearamtai, Tamar ni juuntrin chichaman akuptak: Ju warinchu ainau ushukrutai, tura sello cordónjai wina surusua nu aintsnaun jamtinuitjai. Watska, ju yanauk aina tusa nekaati —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Tamati Judánam wearamtai, Judá ni susamu ainaun nekaa chichaak: —Najatur wina nangkatuk pengkeraitai. Uchirjai nuweemtikiachmau asa aitkarayi, —timiayi. Nunia nijai ataksha pengké kanurchamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Tura ukunam Tamarka uchin jimiaran jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Kame, jateema pujai, uchi uweje jiinkimiayi. Turamtai juurin uwejen jiyu kapanniujai jingkia chicharak: —Juwaitai eemkauri, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Antsu nu uchikia kunturin waingkimtai, ni yachi eemak akiinamiayi. Turamtai juurin chichaak: —Maj, ¿itiur jiinkinme? —tusa naarin Fares inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Nunia chikich uchisha jiyu kapanniujai uwejen jingkiamua nusha akiinamiayi. Tura ni naarin Zara inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Ismael aints ainau Ejiptonam jearamtai, suntara apuri Potifar naartin Josén sumakmiayi. Nu Potifarka faraónka yaintri ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Tura Apu Yus Josénka pengker awajsamiayi. Tura asa suntara apuri jeen pujaksha pengker pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Turamu asa Yus Josén yaingmaurin suntara apuri nekaamiayi. Tura José ni takatrin pengker takakmasu asamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Josén pengker nintimtus, ni jeen iruna nuna mash wainkatas, ni jeen wainin ati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Turamtai nu kintanmaya nangkamasang Apu Yus Potifara jeen pujuinaun tura ajan takakminauncha pengker awajsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tura Joséka nuni mash iruna nuna wainin asamtai, Potifarka aya ni yutairin yuwatniunak nintimtus wajasmiayi. Kame, Joséka nekas shiirmachiyayi. Tura asamtai aints ainau niin wainkar: —Jiijamnawaitai —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Turinau asaramtai jumchik arus Potifara nuwari Josén jiij pujurmiayi. Tura chikich kintati: —Iijai tepesmi —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Tamaitiat José nakitak: —Atsa, ame nintimrata. Aishrum: Winar aina nuka mash wainkata tusa, wina mash akaturmayi. Tura niinu aina nuka mengkakamin ainawai tusangka nintimtsui. ");
INSERT INTO acuNT_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Ju jeanmangka wina nangkatukuka kichkisha pengké atsawai. Tura aishrumka niinu ainaunka mash suritrutsuk, antsu ameka ni nuwari asakmin, aya aminak surimramawai. Tura asamtai ¿itiurkanak amijai tepestaja? Maj, Yuska nunaka surimiau asamtai, ¿itiurkanak nu tunaunaka turatjak? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Tu nintimias pujau wainiat, kintajai metek Potifara nuwari Josén chicharak: —Iijai tsaniasar pujusmi, tura iijai tepesmi —tamaitiat, Joséka pachischamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Chikich kintati José takakmastaj tusa Potifara jeen wayaamiayi. Tura aintska jeanam atsuinau asaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Potifara nuwari José wejmakrin achirak ataksha: —Iijai tepesmi —timiayi. Tamaitiat Joséka wejmakrin aik ukuki jiinki tupikiakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Turamtai nu nuwaka José wejmakrin juruki, ");
INSERT INTO acuNT_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","inati ainaun untsuk, kaunkaramtai chicharak: —Ju jiistaram. Aishur hebreo aintsun itama nuka wijai tepestas wayaayi. Antsu wikia kakaram untsummatai, ");
INSERT INTO acuNT_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","ni wejmakrin ajapa ukuki tupikiaki, —waitrak timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Tura: Aishur taamtai inaktusmi tusa, José wejmakrin tuksamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Tura aishri taamtaisha nunisang ujak: —Ame hebreo aints itamame nuka kanutirun wayaa wina pase awajtustas wakerukmayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Tura wainiatun wikia kakaran untsummatai, ni wejmakrin ajapa ukuki tupikiaki. ");
INSERT INTO acuNT_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","¡Ainuka ami yainmin! —tusa ujakmiayi. Tura ujakam José apuri nuna antuk nukap kajekmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tura Josén achik, faraónka inatiri achikmau ainau engketainam engkeataram —timiayi. Turamtai kársernum pujau wainiat, ");
INSERT INTO acuNT_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Apu Yus tuke Joséjai pujus, pengker awajnuyayi. Tura kársera wainusha Josén wait anentrati tusa pengker nintimtikramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Tura asamtai kársera wainin Josén chicharak: —Kársernam achikmau pujuina nuka mash wainkata timiayi. Timiau asa nuni irununka mash wainuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Kame, Joséka Apu Yus yayaamu asa, ni takatrin pengker takau asamtai, kársera apuringkia ni takasmauri pengkerashi tusangka jiitsuk pujuyayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","2","José kársernum pujai, Ejipto apuri, faraón tutain aints jimiar pasen awajsarmiayi. Turinamtai faraónkan amurtiniun tuke su armia nuna, tura pang faraónnaun tuke najanin armia nunasha kajerak, ");
INSERT INTO acuNT_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","suntara apuri jeen kárser amia nuni nu jimiar aints engkeataram —timiayi. Tura nu kársernumsha Joséka pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Tura nuni pujamtai, kapitán Josén chicharak: —Ame ju jimiar aints wainkarta —timiayi. Tu tinam nukap kinta achikmau pujusarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Tura nuni pujusar faraónka amutirin sukartinka tura pangkan najaniusha mash kashi nishá nishá karamrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Tura nunia José kashik nantaki, nu aints achikmau pujuinamunam wayaa, mai wake mesekar pujuinaun wainak: ");
INSERT INTO acuNT_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","8","—¿Waruka yamaikia timiá wake mesekrumsha tsawaarurme? —tu iniam, mai chichainak: —Mesekramraji. Antsu mesekramramuka warimpita tusar nekamtikramatnuka pengké atsawai, —tiarmiayi. Tinamtai José ayaak: —¿Warí, Yusek mesekramramunka nekatsuash? Watska, mesekramramurmesha wina ujatkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","10","Tamati faraónka amutirin suuka Josén ujaak: —Uva naekrin tresan wainkajai. Tura nu naeknumak uva yangkurkar nunia arumak nerekar tsamainaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Tura asan apu piningkrin achikian, uvan namukan faraónkan susamjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Tamati José chicharak: —Karamrame nuka nuwaitai: Tres naek wainkame nuka tres kintaitai. ");
INSERT INTO acuNT_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Tura tres kinta nangkamaramtai, faraón amin junia jiirmaktatui. Turamtai nuwik amuti suyame nunismek ataksha amutiringkia suu atatme. ");
INSERT INTO acuNT_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Tura jiinkimka, winasha kajinmatrukiip, antsu apurmijai chichasam, wait aneas wina junia jiirkiti. ");
INSERT INTO acuNT_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Hebreo aints aing, winaka jurukiarmiayi. Antsu tunaunaka kichkisha pengké turachu asan, kársernumka pujuschamnawaitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Tura José apu amutirin suu karamramurin nekas pengker nekaamtai, pangkan najannusha niin chicharak: —Wikia mesekramkun tres changkinnum pang púju chumpiamun muukrun ekentsaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Tura changkin yakí aa nuni pang yumin nekas pengker najanamu chumpiamun faraónnaun wainkamjai. Tura wainiatun chingki ainau kautkar nuna yuwinaun wainkamjai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Tamati José ayaak: —Maj, mesekramame nuka nuwaitai: Ame tres changkin wainkamame nuka tres kintaitai. ");
INSERT INTO acuNT_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Tura asamtai tres kinta nangkamaramtai, faraón suntarin akupkam, amin junia jiirmak, kuntujmin jingkiatrama numinam nenaawar mantamawartatui. Turutmawaramtai chiwiang tarutmiar namangmin yuramawartatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Kame, tres kinta nangkamaramtai, faraónka akiinamu kinta asamtai, ipiaamu ainau kaunkaramtai, faraón juun jiistan najanamiayi. Tura asa mash antinamunam chichaak: —Amutirun surinuya nuka tura pangkan najanua nusha juni taarti tusaram kársernumia utitaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Tamati amuti suya nuka ni takatrin ataksha takasti —tusa tsangkuramiayi. Turam nuwik amutin suuya nunisang ataksha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Antsu pangkan najanniunka tsangkurachmiayi. Tura asa José timia nunisang suntarin akupak: —Jiyuwaskajai kuntujen jingkiaram pangkan najanniuka numinam nenaataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Kame, apu amutirin suuya nuka nekas iwiaaku pujayat, Josénka pengké nintimtutsuk kajinmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Jimia musach nangkamaramtai, faraónka karanam Nilo entsa yantamen wajamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Turai siete vacas shiiram pengké jaerun entsanmaya jiinkiar, saakin yuwinak pujuinaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Tura nuna ukurin chikich siete vacas pengké watsaru tsuutmain ainausha entsanmaya jiinkiar, vaca jaeru ainaujai tsaniasar wajasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Nunia aneachmau vaca watsaru armia nuka chikich siete vacas jaeru armia nunaka yuwinaun karanam wainkamiayi. Tura nunia shintarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Turayat ataksha kanur, ataksha mesekramramiayi. Trigo kichik numirinmaya jingkiaji nekas pengker sangkanmarun amia nuna siete wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Nunia chikich trigo numirinmang siete pengké pasechiri tura pimpischiri sangkanmarun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Nunia nu trigo kukarua nuka chikich pengker armia nunaka mash amuinaun wainkamiayi. Nunia kuraat shintar, karanam tu wainkajai —tusa nekaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Tura tsawaaramtai napchau nintimias ni inatiri ainaun untsuk: —Atum werum Ejiptonmaya nekau aints ainau tura mesekramramun nekaamin ainausha yaruakrum, mash taarti tusaram untsuktaram —tusa akupkamiayi. Tura kaunkaramtai mesekramramurin etserkamaitiat nekaracharu asar, kichkisha ujaktatkamawar tujinkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Tujinkaramtai amutirin suuya nuka faraónkan chicharak: —Wi pase turamiaja nunaka yamaikia nintimjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Apuru, ameka wina tura pangka najaniujai kajerkartukam, suntara apuri jeen kárser aa nuni akupkartukmiame. ");
INSERT INTO acuNT_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tura kichik kintati kashi niishaa mesekramramiayi. Tura wishaa karamramiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Tura nuni kapitani inatiri hebreo natsa iijai pujumia nuka ii karamramuri warimpita tusa nekamtikramamiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Tura ni timia nunisang mash turunamiayi. Wikia ataksha wina takatrun takakmasmiajai. Antsu chikichnaka kuntujen jingkiawar numinam nenaawar maawarmiayi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tamati numatik faraón chichaman akupak: —José karsernumia utitaram, —timiayi. Tamati Josén wari karsernumia jiikiaramtai, intashin awamar, tura wejmak pakuichaun aantsar faraónnum wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Tura faraónnum jeamtai, nuka Josén chicharak: —Mesekramrajai, antsu warimpita tusangka nekaamin kichkisha juni atsawai. Aminka pachitmasar mesekramramu nekawaitai tusar, turaminamtai untsukjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Tamati José ayaak: —Apuru, wichawaitjai, antsu ame karanam wainkamun nekawa nuka Yusketai. Tura asa amin pengker awajtamsatas nekamtikramatatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Tama faraón Josén chicharak: —Anturtukta. Wi mesekramurnaka ujaktatjame: Mesekramkun Nilo entsa yantamen wajamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Turai siete vacas shiiram pengké jaerun entsanmaya jiinkiar saakin yuwinak wajainaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Tura ni ukurin chikich siete vacas pengké watsaru tsuutmain ainausha entsanmaya jiinkiari. Antsu timiá watsarunka ju nungkanmaka pengké wainkachmiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Tura waininayat nu vaca watsaru aina nuka chikich siete vacas jaeru aina nunaka yuwinaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Tura mash amuinayat tuke watsarun wainkamjai. Nunia kuraat shintarmajai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Turayat ataksha kanuran, ataksha mesekramkun kichik trigo numirinmang trigo nekas pengker sangkanmarun siete wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Nunia chikich trigo numirinmang siete pasechiri tura pimpischiri sangkanmarun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Nunia nu trigo kukaruka chikich pengker aina nunaka mash amuinaun wainkamjai. Tura asan mesekramramun nekaamin ainaun ujakmajai. Tura waininayat nekaracharu asar, kichkisha warimpita tusarka ujaktatkamawar tujinkarmayi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Tamati José faraónkan ayaak: —Apuru, ame jimiar karanam wainkamame nuka kichkitai: Yuska amin ukunam atinun pachis paan inakturmastas wakerutmawai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Vacas siete shiiram aina nuka tura trigo pengker siete aina nu wainkamame nuka siete musach Ejipto nungkanam trigo nukap juukminuitai taku tawai. Nuketai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Antsu vacas watsaru tura pase ainauka trigo pimpischiri tura pasechiri ainaujai metek Ejipto nungkanam tsuka nukap atinuitai taku tawai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Wi tajame nuka nekasaintai. Yuska amin ukunam atinun pachis paan inakturmastas wakerutmawai, apuru. ");
INSERT INTO acuNT_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Ejipto nungkanam siete musach yutai nukap atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","31","Nunia Ejiptonam siete musach tsuka nukap atinuitai. Nu tsukaka ju nungkanka mesratnuitai. Tura asamtai aints ainau mash tsukamawar iwiaaku pujuschamin nekapinak, siete musach iikia nukap yuwar tsukamtsuk pujusmaji tusar, nintimtuschartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Apuru, Yus amin ni turatniurin mesekramramunam: Wi nekasan wári turatatjai tusa jimiaran nekaamtikramayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","Tura asamtai, apuru, yamaikia aints nintip tura nekaamin eakam, ami nungkemin wainin ati tusam inaikiam pengkerchawashi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Apuru, ju turatniuka pengkerchawashi: Inakratin ainau inaikiakmin, nuka wekaa wekainaka, siete musach Ejipto nungkanam aints ainau trigon nukap jukartin asaramtai, 50 kilos trigo juwamunmaya 10 kilos akankar jukiarti. ");
INSERT INTO acuNT_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Tura nu siete musachtin mash yakat ainamunam juun jea jeamkamunam ami chichamejai trigon nukap irumrar matsarar, ukunam aints ainaun susartas tenapkesar wainkarti. ");
INSERT INTO acuNT_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Nunia siete musach Ejiptonam tsuka amatai, aints ainau tsukajai jakarai tusam, trigo nukap ukusmauka atinuitai, —José faraónkan timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Kame, faraón ni inatiri ainaujai José chichamen antukaru asaramtai, nekas pengkeraitai —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Tu tinu asaramtai faraón ni inatiri ainaun chicharak: —Yuse Wakani pujura jujaingkia metek chikichkisha nekas atsawapi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Tura Josén chicharak: —Kame, Yus aminak mash nekamtikramau asamtai, timiá nekawaitme. Tura amijai metek chikich nintipka tura nekaamniuka atsawai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Tura asamtai ame wina jearun pujuinauka mash inartatme. Tura asakmin ju nungkanam pujuinauka mash amin umirtamkartin ainawai. Antsu wiki juun apu asan, amin nangkamasnak juun atinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Jiisia, mash Ejipto nungkanam pujuina nu inakratin ata tusan inaikiajme —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Nuna tusa, faraónka ni uwejnum wetairin ukuinak, Josén wemamtikiamiayi. Nunia wejmak nekas pengkeran antsrataram —tusa iniatiri ainaun inarmiayi. Tura nungkutai kuri najanamun nungkramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Nunia faraón ni karrurin tuke ukunam wininuya nu karrunka Josén susamiayi. Tura José nu karrunam wekaamtai, inati ainau eemkar wear untsuminak: —Jintanmaya menangtiaram tiarti, —tusa faraón chichaman akupkamiayi. Nu turunamujai aints ainauka mash Josén pengker awajsamun nekamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Nunia faraón Josén chicharak: —Wi apu asan tajame: Ame chichamechujaingkia Ejiptonmaya aints kichkisha warinkesha pengké turachmin ainawai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Nuna tusa faraónka Josén Ejipto aintsu naarin Safnat-panea inaikiamiayi. Tura Potifera nawantrin Asenat naartinun nuwatkati tusa nuweemtikiamiayi. Nu Potiferaka yakat Onta sacerdotiri ayayi. Turamtai Joséka Ejipto nungkanam aints ainau wainiuri wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Joseka treinta musachrintin asamtai, faraón niin karsernumia jiiki, apu ati tusa inaikiamiayi. Turamtai faraónkan aujas ukuki, Ejipto nungkanam yakat irunun jiistas wekaasamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Tura siete musach trigo nukap nerekmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Tura asamtai trigo ajanmaya juukmau apunu akankamurin José yaruak, chikich chikich yakat arakchichu amaunam juki, jea juun jeamkamunam matsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Tura trigo nekapmartatkama tujintak, nekapmatsuk matsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Tura tsukaka jeatsaing, José uchi jimiaran yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Tura: —Yus wi wait wajaktinun tura wi wear ainauncha kajinmamtikruki —tusa eemkaurin Manasés inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Tura: —Ju nungkanam wake mesekan pujai, Yus uchin surusi —tusa ekerin Efraín inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Ejiptonam siete musach árak ainau nukap nereamuka nangkamaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","José tímia nunisang mash nungka ainamunam tsuka nangkamnamiayi. Antsu Ejiptonam trigo nukap irumramu asamtai, tsukaka atsumiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Tura ukunam Ejiptonam trigo amukamtai, nunia aints ainau tsukaminak faraónkan weriar: —Apuru, trigo yuumaji, —tiarmiayi. Tinamtai faraón nu aints ainaun chicharak: —Josénam werum trigo seataram. Turaram ni titata nuka mash turataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Tura Ejiptonam yutai atsau asamtai, mash aints tsukaminak pujuinauka Josénam wininau asaramtai, trigon irumramia nuna suruktas, ukutai jea ainaun mash urakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Tura chikich nungka ainamunmasha yutai pengké atsau asamtai, nu nungkanmaya ainausha Ejiptonam sumaatai tusar, Josénam kaunkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Jacob Canaán nungkanam pujus, Ejiptonam trigo awai tamaun antuk, ni uchiri ainaun chicharak: —¿Warukaya jiinisha pujarme? ");
INSERT INTO acuNT_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ejiptonam trigo awai tinamun antukjai. Iisha tsukajai jakarai tusaram, werum trigo sumataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Tamati ni uchiri diez armia nuka trigo sumatai tusar Ejiptonam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Antsu Benjamínnaka, José nekas pataa yachinka jintá itiurkachminum jeai tusa akupkachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Canaán nungkanam tsuka asamtai, nu nungkanmaya ainau yutain sumaktasar wenamtai, Israela uchiri ainausha niijai tsaniasar wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","8","Tura jear, José Ejipto nungka wainin asa, aints ainau trigon sumaktasar kaunkaru ainaun ningki suruktin asamtai, nekainachu asar, ii yachiintai tutsuk nijajin nungkan antitnak Josén tsuntsumruawarmiayi. Antsu José ni yachii ainaun: Yatsur ainawai tusa nekaayat, nekachua nunisang niin kakar chicharak: —¿Atumsha tuniayaintrume? —timiayi. Tu iniam aiminak: —Iikia Canaán nungkanmayainji, tura trigo sumaktasar winaji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Tinamtai José yaanchuik karanam wainkamurin anear, niin chicharak: —Atsa, atumka anangmakrum: Ejipto nungkanam itiur pujuinawa tusaram wekaarme. ¿Tura asaram ukunam meset najanami tusaram wekaatsrumek? —timiayi. Tamaitiat nii aainak: ");
INSERT INTO acuNT_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","—Atsa, apuru, antsu aya trigon sumaktasar winiji. ");
INSERT INTO acuNT_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Iikia kichik aintsu uchirinji. Nekasar pengke aintsuitji. Tura asar nungka nekaataram tusar akupkamuka ainatsji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Tinamtai José chicharak: —Atsa, nekasrum anangmakrum ju nungka nekaatasrum wekaarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Tamaitiat niisha ataksha aainak: —Atsa, apuru, iikia kichik aintsu uchirinji. Canaán nungkanam pujuuwitji. Iikia doce yachintin ayatrik, ii yachii ekeringkia ii aparijai juwakmayi. Antsu kichka mengkakawaitai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Tinamaitiat José ayaak: —¡Aichua taja! Atumka nekasrum anangmakrum ju nungkanam wekaarme. ");
INSERT INTO acuNT_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Antsu yamaikia nekapsatjarme: Apu Faraóngka naarijai tajarme: Atumi yachii ekeri juni taachmataikia, atumka juniangka pengké jiinkishtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Watska, nekasrum waitrutsuk takurmeka, atumnia kichik atumi yachii ekeri utiti. Antsu chikich ainautirmeka juni achikmau karsernum pujustatrume. Atum nekasrumeash waitrutsuk chichaaram nuka nekaami. Antsu waitruarmeka nuniangka nekasrum anangmatasrum uumkuram wekaarme tusan nekawaintjai. Faraónka naarijai nekasan tajarme, —tusa José ni yachii ainaun timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Nuna tusa ni yachii ainaun mash tres kintan karsernum engkeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Tura tres kinta kanur tsawaar, ni yachii ainaun jiiki chicharak: —Wikia nekasan Yusen umirnuitjai. Tura asan wi titatjarme nu turakrumka jakashtatrume. ");
INSERT INTO acuNT_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Watska, atum nekasrum wait chicham chichachu akurmeka, atumi yachi kichik karsernam ukuakrum, chikich ainautirmeka atumi weari yuatniuri jukiram wetaram. ");
INSERT INTO acuNT_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Tura ataksha winakrum atumi yachi ekeri ayaktaram. Turakrumin atum nekasrum waitrutsuk chicharme tusan nekaaratjarme. Antsu waitrakrumningkia mantamawartinuitai, —timiayi. Tamati ayu tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Tura mai nuamtak chicharnainak: —Nekasar yaanchuik ii yachiin pase awajsau asar, iiksarik yamaikia wait wajaji. Ii yachi wait wajak: Wait anentrurtaram turamu wainiatur, iikia pachischamiaji. Tura asakrin nu tunau jurumaji, —tunainiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Tinamtai Rubén chicharak: —Natsa pase awajsairap tusan wi tamaitiatrum anturtukchamiarume. Tura yamaikia ni jakamurin pachisar itiurkachmin pujuinaji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Tamati Joséka ni chichainamunka mash antayat, antukchawa nunisang wajasmiayi. Kame, José ni yachi ainaun Ejipto chichamejai chichaamtai, chikich Ejipto aints chichaman mai nekau asa, José yachiin: Nuna taku tawai tusa ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Tura ni yachii chichainamun antuku asa, José nunia jiinki juutmiayi. Tura ataksha waketki taa, yachii ainaun mash jiis, Simeónkan inakmas ni inatirin chicharak: —Au achikrum, karsernum engkeataram —timiayi. Tamati chikich yachii ainau wainmaunum Simeónkan jingkiawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Nunia José ni yachii antinachmaunam ni iniatiri ainaun chicharak: —Au aintsu costalrin trigo chumpiataram. Turasha kuikiarisha costalnum engkeataram. Turaram jintá yuwatniusha susataram —timiayi. Tamati José yachiinkia wainchamunmak turawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Turawaramtai José yachii ainau ni costalrin jukiar, burrorin antskar waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Tura jinta kanurtinnum jear, kichik ni burrorin yuratas costalrin urak, kuikiarin patatek engketun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Tura wainak ni yachii ainaun mash ujak: Jiistaram, kuikiarnaka awangturkiari, costalnum engketun wainkajai, —timiayi. Tamati mash sapijmiakar kúra kúra wajainak: —¿Yuska junasha warukamtai jutikrama? —tunaij wajarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Nunia Canaánnum jear, ni aparin ni turunamurin mash ujakarmiayi. Tura chicharinak: ");
INSERT INTO acuNT_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","—Ejiptonmaya apuri iin kakar chichartamak: Atum aya anangmatasrum wekaarme turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Turammatai iikia: Pengke aintsuitji, tura asar anangmatasrikia wekaatsuji. ");
INSERT INTO acuNT_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Iikia kichik aintsu uchirinji. Yaanchuikkia doce yachintin ayatrik, kichka mengkakawaitai. Tura ii yachi ekeringkia ii aparijai Canaánnum juwakmayi, timiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Tu tinu asakrin, iin chichartamak: Watska, nekasrum wait chicham chichachu akurmeka, atumi yachi kichik wijai pujusti tusaram ukuakrum, chikich ainautirmeka atumi weari yuwarti tusaram, trigo jumchik jukirum wetaram. ");
INSERT INTO acuNT_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Tura ataksha winakrum, atumi yachi ekeri ayaktaram. Turakrumin atumka nekasrum pengke aintsuitrume, tura anangkatasrumka wekaatsurme tusan nekaaratjarme. Nuniangka atumi yachiin karsernumia jiiktatjai. Tura atumnasha ju nungkanam angkan wekaasatniun tsangkatkatnuitjai turammaji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Tura costalrin atiatatkamawar, ni kuikiari ijiamu engketun wainkarmiayi. Turawaramtai apari tura niisha mash sapijmiakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Tura Jacob ni uchiri ainaun chicharak: —Winaka pengké uchirtichu awajtusrume. Joséka mengkaakawaitai. Tura Simeónsha atsawai. Tura nuna nangkamasrumek yamaisha Benjamín jurutkitasrum wakerarme. ¡Chua, aitkau asakrumin, wikia itiurkachmin nekapeajai! —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Tamati Rubén aparin chicharak: —Napchauka nintimtsuk asata, apaachi. Wikia Benjamínkan tenapkesan wainkatatjai. Tura ataksha awaingkin itartatjame. Antsu niin itaachmataikia, wina uchir jimiar aina nu maata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Tamaitiat Jacob ayaak: —Uchir Benjaminnaka pengké akupkashtatjai. José jakau asamtai, ningki juwakuitai. Jinta weamunam uchir mengkatrukakrumningkia, wi juuntach asan, timiá wake mesekan jakatatjai. Antsu atumka wiasmamkatnuitrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Canaán nungkanam tsuka nukap asamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Ejiptonmaya trigo itaamun amukau asamtai, Jacob ni uchiri ainaun chicharak: —Ataksha werum trigo jumchiksha sumaataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Tamaitiat Judá aparin ayaak: —Apaachia, nu aintska iin chichartamak: Atumi yachi ekeri winichmataikia winaka jiirtsuk asataram turammaji. ");
INSERT INTO acuNT_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Tu tinu asamtai ii yachi akupakminkia sumaatatji. ");
INSERT INTO acuNT_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Antsu ii yachi akupachkumningkia wechatatji. Nu aintska iin chichartamak: Atumi yachi ekeri winachmataikia winaka jiirtsuk asataram turammiaji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Tamati Israel ayaak: —¿Waruka nu aintska atumin ininmamtaisha, ii yachii chikich pujawai timiarume? Nu tinu asakrumin, winaka pengké pase awajtusrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Tamati aiminak: —Kame, nu aintska ii weari ainaun pachis: ¿Atumi aparisha iwiaakuak? ¿Tura atumi yachi chikitcha pujawak? tusa inintrimi. Turayat: Atumi yachi itataram tusa turamtinka nekachu asar ujakmaji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Nunia Judá ni aparin chicharak: —Ame mash aints ainati tsukajai jakarai takumka, yatsur wijai weti tusam tsangkamkata. Ame ayu takumningkia, wári wetatji. Tura trigo sumakar, amesha tura iisha tura ii uchiri ainausha tsukajai jakashtatji. ");
INSERT INTO acuNT_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Watska, yatsurnaka wi wainkatatjai. Tura ataksha juni itaachmataikia, iwiaaku pujaknaka tuke wiasmamkatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Ame ju surimia pujachkumningkia, iikia trigo sumakar jimiar tamain wajainaji, —tusa Judá aparin timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Tamati apari ayaak: —Kame, chikich turamniauka atsau asamtai, yachim ayasrum wetaram. ¿Wisha iturkatjak? Turakrum ii nungkarin timiá pengker aa nuka takurtiaram. Irimi yakaamatai bálsamo tura wapasa yumirisha, tura kungkuti ainausha, tura mirra tsuaksha, tura pitusha, tura nusensesha jukirum, apu susataram. ");
INSERT INTO acuNT_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Tura kuik jukimiarume nuna nangkamasrumek nukap jukitaram. Nuwik costalnum engketu wainkamarme nuka ataksha awangtuktaram. ¿Kajinmakiar engkewar akupkacharmasha? ");
INSERT INTO acuNT_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Watska, atumi yachi yamaikia ayasrum nu aintsnum wetaram. ");
INSERT INTO acuNT_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Yuse tujinkamuri atsau asamtai, nu apu wait anengkratinu nintin susati. Turamtai wait anentramak atumi yachi emetama nuna angkan awajsati, tura Benjamíncha emetsuk akupkati. Kame, akupachmataikia, uchirtichu pujuschatjash. ¿Wisha itiurkatjak? —tusa uchiri ainaun akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Tura akupkamtai, Jacobo uchriri ainau apun warinchu nangkami susatniuncha tura kuik waingkimuncha tura chikich kuikiajai trigon sumaktinnasha jukiarmiayi. Tura Benjamíncha jukiar Ejiptonam wearmiayi. Tura nuni jearamtai, ");
INSERT INTO acuNT_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","José Benjaminkan ni yachii ainaujai winaun wainak, inatirin chicharak: —Au aints ainauka wina jearun jukita. Tura tsaa tupin ai, wijai yuwartin asaramtai, vaca maam inarkam umista, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","José tamati, ni inatiri timiatrusang ni yachi ainaun ni jeen jeekartas jukimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Turamtai sapijminak mai nuwamtak chichainak: —Kuik ii nuwik costalnum engketu wainkamji nuna pachisar juni jeetamiar, iincha achirmakar inatmarartas aitkarminatsjiash. Tura ii burrorincha atantramkiar jurutramkishtajiash, —tunaiyarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tura asar jeanam jear, waaitsuk José inatirin chicharinak: ");
INSERT INTO acuNT_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","—Maj, juunta, iikia nuwik tari, nekasar trigon sumakar waketkur, ");
INSERT INTO acuNT_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","22","jinta kanurtinnum jear, kichik kichik ii costalrin atiar, jiikmar kuik trigo sumakur akikmauka nunisang metek engketu wainkamji. Antsu yaachik engkeama nuka nekatsji. Tura asar waingkimi tusar itaaji. Tura ataksha trigo sumaktincha kuik itaaji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Tu tinam José inatiri ayaak: —Sapijmiakairap. Antsu pengker nintimsataram: Atumi Yusri, nekas atumi apari Yusriya nuka nu kuikianka atumi costalrin engkeachmasha. Kamé, atum akikmakmaunka wikia mash jukimjai, —timiayi. Nunia Simeónkan karsernumia jiiki, ni yachi pujuinamunam itamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Nunia José jeen wayaawar, ni nawen nijarartas yumin shikirkamiayi. Tura ni burrori ainau yuwatniurincha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Tura tsaa tupin ai, apujai yuwatatrume tusa ujakmau asar, warinchu ainaun itaarmia nuna susartas mash umisar nakasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Nunia Joséka ni jeen taamtai, ni yachi ainauka warinchu ainaun susar, nunia nungkan nijajin atitnak tsuntsumruawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Turinamtai José iniak: —¿Atumsha pengkerak winaram? ¿Tura atumi apari juuntach timiarume nusha iwiaakuak? ¿Nusha pengkerak puja? —tusa inintrusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Tu iniam aainak: —Ja ai, apuru, ii aparingkia iwiaakui, pengker pujau ukukji, —tusar tsuntsumruawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Tinamtai José pangkai jiis, ni nekas pataa yachin ni nukuri jerermaun, Benjaminkan wainak: —¿Atumi yachi ekeri timiarume nu jukai? —tu iniam, —Ja ai, —tiarmiayi. Tu tinam Benjaminkan chicharak: —Yus yainmakti uchiru, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Tura yachiin nukap aneau asa, juutmin nekapeak, wári ni kanutirin wayaa juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Tura juuti umis, yapiin nijar ataksha jiinki inatirin chicharak: —Yurumak misanam puusataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Tamati Josénka yurumkan chikich misanam niisha pujtusarmiayi. Tura José yachi ainauka niisha chikich misanam keemsar, tura ejiptonmaya ainausha niisha chikich misanam keemsarmiayi. Kame, ejiptonmaya ainau hebreo ainaujaingkia kichik misanmangka yuwachmin asaramtai turawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Nunia yachii ainau ni akiinamurijai metek, eemkaurinia nangkama, inangnamunam yachii ekeri keemsarti tusa kentsamiayi. Tura waininayat, nuka ii yachiintai tusarka nekainachu asar, nukap nintiminak jiinisarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Turinamtai Joséka ni misarinia ni yachii ainaun yutan susarmiayi. Antsu chikich yachi ainaun nangkamasang Benjaminkan nukap susamiayi. Turamtai pengker nintimsar iruntrar yuwar, tura amurar inangkasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Tura yutan umisaramtai, José ni inatirin chicharak: —Ju aints ainau costalrin trigo nukap chumpiata. Tura kuikiari waingkim pátatek ataksha engkeata. ");
INSERT INTO acuNT_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Antsu piningkur kuik najanamun yachi ekeri costalrin ni kuikiarijai apatkam engkeata, —timiayi. Tamati inatiri timiatrusang umismiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Tura kashin tsawaar tsaa yamai jiinai, José ni yachi ainaun: Waketkitaram tusa tamati, ni burrori ainaujai waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","5","Tura arákka wetsuk wekainai, José ni inatirin chicharak: —Nu aints yamai wearuka papeekam tura mankiam: ¿Waruka atumin pengker awajsamaitiatrum pase awajkartukurme? ¿Winia apuru umutiri tura nekaamatiri piningk kuik najanamusha waruka kasarturkarume? ¡Atumka pengké pase aitkararme! tita —tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Tamati José inatiri ayu tusa papeeki, José yachii ainaun wainak, José timia nunisang ujakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Tamati ni chichainak: —¿Warukamtai iincha nangkamisha tukartame? Iikia nuka pengké turachminuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Iikia Canaán nungkanam jear, nunia costal ainaun atiar jiikmar kuik wainkar, ataksha waingkiartaij tusar, juni winiu asar, ¿itiurkarik kurisha tura kuikiasha apu jeenia kasamkatjia? ");
INSERT INTO acuNT_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Watska, yana costalrin apu piningkri engketu wainkatam nuka maanati. Antsu chikich ainautikia apu inatiri wajastatji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Tu tinam José inatiri chicharak: —Atum tarume nuke ati. Antsu pining kuik najanamun takaka nuka wina inatir atatui. Antsu chikichtirmeka angkantaitrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tamati José yachi ainau ni costalrin wári nungkanam puusar atiwaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","José inati yachi eemkauri costalrin nangkama, ea eaka inangnamunam Benjaminka costalrin urak, nuni José piningkrinka engketun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Turamtai napchau nintimrar, wejmakrin jaakar costalrinka ataksha burrori entsakarti tusar kentsar yaktanam waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Tura Judá ni yachi ainaujai José pujamunam jear, nijajin nungkan antitnak tsunstumruawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Tuminamtai José chicharak: —¿Waruka piningkrusha kasartukmarume? ¿Wi nekaamamniaur nekatsrumek? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Tamati Judá chicharak: —Juunta, ¿iisha warintajik? Yuska ii tunaarin nekau asa, itiurkachmin awajtamsaji. Turasha kasamkachmaji titiatkamar tujintaji. Tura asakrin piningkian takaka nujai metek iikia mash ami inatiram wajastatji, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Tamaitiat José ayaak: —Atsa, nuka tumamchamnawaitrume. Antsu yana costalrin piningkur engketu wainkarma nuke wina inatir wajastatui. Antsu atumka angkan atumi aparin waketkitnuitrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Tamati Judá Josén tari chicharak: —Juunta, jumchiksha anturtukta, tusan seajme. Wait aneasam kajertukaip. Ameka nekasam faraónka tumawaitme. ");
INSERT INTO acuNT_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Ame ininkratkum: ¿Atumi aparisha iwiaakuak? ¿Tura atumi yachi chikichka pujatsuak? takumin, ");
INSERT INTO acuNT_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","iisha ayaakur: Ja ai, juunta, ii apari pengké juuntach wajas iwiaakui. Tura ii yachiisha natsa ii apari juunmar yajutmarmia nusha pujawai. Antsu maj, ni yachi jakau asamtai, nu nuwanmaya akiinamia nuka pengké kichkitai. Tura asamtai apari niin nukap aneawai tusar timiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Takurin ame iin chicharkartakum: ¿Atumi yachi juni itataram, wisha wainkatasan wakerajai tichamkum? ");
INSERT INTO acuNT_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Takumin ii chichaakur: Natsaka ni aparinia kanakchatnuitai. Ni aparinia kanakamtaikia, ii aparingkia jakamnawaitai timiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Takurin ame chichaakum: Atumi yachi itaachkurminkia, wikia atumnaka jiitnasha nakitajai timiame. ");
INSERT INTO acuNT_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Tu tinu asakmin iikia waketkir, ii apari ame timiame nuka mash ujakmaji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Tura chikich kintati ii apari chichartamak: —Ataksha werum trigo jumchiksha sumakrum utitaram turammaji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Turamkurin iikia chicharkur: Ii yachi ekeri iijai tsanias winichmataikia, pengké wechamnawaitji. Ni iijai winichmataikia, nu apunmaka pengkéj jeachminuitji timiaji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Tu chichaakrin, ii apari chichartamak: Atumka nusha nekarme: Wina nuwar Raquel uchi jimiaran jerermiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Nunia chikichka mengkakamiayi. Nuniangka wantintsui. Tura asamtai nekasampi pachim niin achik maamtai mengkakamiayi, tu nintimjai. ");
INSERT INTO acuNT_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Tura ju chikitcha jukiram, jintá mengkakakrumningkia, wi juuntach asan, timiá wake mesekan jakatatjai. Antsu atumka wiasmamkatnuitrume, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","Ii apari ni uchirin timiá aneau asamtai, niin itatsuk jeakrinkia, ");
INSERT INTO acuNT_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","uchirin wainchau asa, ii apari jakatnuitai. Turatin asamtai timiá wake mesek jakamtaikia, wiasmamkatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Wikia aparun chicharkun: Nekasan yatsurnaka wainkatatjai. Tura ataksha wainkin itachamtaikia, wikia iwiaaku pujaknaka tuke wiasmamkatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tura asamtai amin seajme: Yatsurka ni yachi ainaujai waketkiti tusam tsangkamkata. Antsu wikia juni ami inatiram wajasat tusam tsangkamrukta. ");
INSERT INTO acuNT_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Antsu yatsur wijain waketchamtaikia ¿itiurkanak aparun waketkitja? Yatsur tachamtai apar wait wajaunka jiitnaka nakitajai, —Judá timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Maj, nuna antuk, Joséka ni anengkratairin tsantratatkama tujintak, ni inatiri ainaun kakar chicharak: ¡Atumka juniangka mash jiinkitaram! —timiayi. Tamati inati ainauka mash jiinkiar, kichkiksha juwakchamiayi. Tuminamtai aya yachii ainaujaing juwak: —Wikia atumi yachiintjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Nuna tusa kakar juutmiayi. Turamtai ejiptonmaya ainausha nuna mash antukar, faraónka jeen pujuinauncha ujakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Nunia José ni yachi ainaun chicharak: —Wikia Joséyaitjai. ¿Aparsha iwiaakuak? —tusa inimiayi. Tu iniamaitiat ni yachi ainau timiá shaminak aimkatatkamawar aitske wajaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Turinamtai José yachi ainaun chicharak: —Wait aneasrum juni winitaram, —timiayi. Tama niin ayaamkaramtai, José ataksha chicharak: —Wikia nekasan atumi yachiintjai, Joséyaitjai. Ejiptonam surutkamiarme nuwaitjai. ");
INSERT INTO acuNT_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Antsu untsuri aints ainau tsukajai jakarai tusa, Yus winaka juni eemak akuptukmiayi. Tura asamtai wait aneasrum, napchau nintimsaram yamaikia pujusairap, tura wiasmamkairap. ");
INSERT INTO acuNT_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Yamaikia jimiá musach tsuka awai. Turayat yamaisha tuke cinco musach tsuka atinuitai. Tura asamtai árak araamsha tsapaichminuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kame, atum tura atumi weari ainausha tsukajai jakarai tusa, Yus atumin uwemtikratas, juni taatsrumning winaka eemtikrukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Atumka winaka ju nungkanmaka akuptukchamiarume. Antsu nuna turamia nuka Yuskeyayi. Yuska faraónka nintimtikin ati, tura faraónka jeen wainin ati tusa, tura ejiptonmaya ainau apuri ati tusa, winaka akuptukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Tura asamtai wári aparu pujutirin waketkiram, tu ujaakrum: Uchiram José chichaman akupturmak: Yus winaka ejiptonmaya ainau mash inarta tusa pujtusmiayi. Tura asamtai mengkatsuk wári jiiriti turammayi, tusaram ujatruktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Tura uchirtuk tura tirangkrintuk, tura tangkurtuk ni takaka nunaka mash yaruak, winí Gosén nungkanam taa, arakchichu pujusti. ");
INSERT INTO acuNT_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Tura pujus ni weari ainau, tura niijai pujuinauka tsukajai wait wajakarai tusan, yutai ainaun susartatjai. Kame, ju tsukaka tuke cinco musach atinuitai, tusa José turammayi tusaram ujatruktaram. ");
INSERT INTO acuNT_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","Wi tajarme juka wiitjai, Joséyaitjai. Yatsur Benjaminka tura atumsha paan antukurme. ");
INSERT INTO acuNT_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Tura asaram yatsurka Ejipto nungkanam pujuinaun inawai tusaram, tura juni wainkarume nu pachisrum mash apar ujaktaram. Yamaikia wári werum, apar itartitaram, —tusa José timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Tura ni yachi Benjaminjai minaknaisar juutiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Nuniangka José ni yachi ainaun mash mejeas juutkamaikiak minaksamiayi. Tura asamtai ni yachi ainauka arantutsuk pengker nintimsar niijai chichasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Tura faraónka jeen pujuinauka José yachi ainau taarmayi tamaun antukaramtai, faraón ni yaintri ainaujai warasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Tura faraón Josén chicharak: —Faraón tawai tusam yachim ainau ujakta: Ni burrori costal ainaun antskar Canaánnum waketkiarti. ");
INSERT INTO acuNT_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Turawar ni aparin ni weari ainaujai juni tarti tusam akupkata. Tura juni taaramtai, nungka nekas pengkeran susartatjai. Tura yutain nekas pengker ainauncha susartatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Tura ni nuwari ainaun, tura uchiri ainauncha tura ni aparincha juni itaarti tusar junia carreta ainaun jukiar nuni keemsar winiarti tusam akupkarta. ");
INSERT INTO acuNT_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Tura ni takakina nunaka ukuinaksha, nuna pachisarka napchauka nintimtsuk asarti. Juni Ejiptonam ni ukukmaurin nangkamasang timiá pengker iruna nuka niinu artatui, faraón tusa timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Tu tinu asamtai Israela uchiri ainau faraón timia nunisarang turawarmiayi. Josésha carretancha tura jintá yuwatniuncha susarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Nunia entsati yamarmancha susarmiayi. Antsu Benjaminkan kuikian trescientos tura entsatin cinco susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Ejiptonam warinchu timiá pengker iruna nuna entsakarti tusa, José aparin trigon, tura pang jintá yuwatniuncha, tura chikich yutainasha entsakarti tusa, dies burron akuptukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Tura ni yachi ainaun akupak: —Jinta wekaakuram jiyanikni wajairap —timiayi. Tamati ayu tusar niisha wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Tura Ejiptonmaya jiinkiar, Canaán nungkanam ni apari pujamunam jearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Tura nuni jear, aparin ujainak: —Maj, Joséka iwiaakuitai. Tura mash Ejipto nungkanam inakratin puja nuka nuwaitai, tu ujakaram, Israelka aya jiimiaj wajas, warinkesha tichamin nekapeak, uchiri ainau chichamen antukiat: —Nangkamiar tinatsuash, —tu nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Turayat José niin chichaman akuptukmaurincha mash ujakaram, Israel carreta ainaun ni jukitniun José akuptukma nuna wainak, pengker nintimias chichaak: ");
INSERT INTO acuNT_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","—Maaketai. Nekasampi uchir José iwiaakuitai. Tura asamtai iwiaaku pujaja juik wena, nekasnapi uchirun wainkatatja, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Nunia Israel ni weari ainaujai tangkurtuk tura warinchurtuk Beerseba yaktanam jeamiayi. Tura nuni jea, ni apari Isaac yaanchuik tangkurin maa, Yusen susatas epeamia nunisang niisha turamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Turamtai Yus kashi tari, ni yaanchuik naarin pachis untsuk: —Jacob, Jacob —tamati, Israel ayaak: —Juni pujajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","4","Tamati Yus chicharak: —Wikia Yusetjai. Ami aparmi Yusrinjai. Wikia amijai Ejipto nungkanam wetatjai. Tura nuni jeakmin, ami wearam ainaun nukap yujratnuitjai. Tura asamtai Ejipto nungkanam shamkartutsuk weta. Nunia nukap arusan ami wearam ainaunka ataksha Ejiptonmaya waingkiartinuitai. Tura ame jakatatme nuningkia Josésha amijai tsanias pujutnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Tamati Jacobo uchiri ainau Beersebanmaya jiinkiartas, ni uchiri ainaun, tura nawantri ainauncha carretanam Faraón niin yaruaktiniun akupturmia nuni engkerar jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Jacob ni weari ainaujai mash Ejiptonam wear, ni vacari tura ovejari ainaun tura Canaánnum pujusar, takutai ainauncha mash yaruakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Kame, Jacobo uchiri ainau, nawantri ainausha, tura tirangki ainausha mash wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Jacobjai Ejipto nungkanam wearmia nuka ju armiayi: Jacobo uchiri eemkauri Rubén, ");
INSERT INTO acuNT_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","tura Rubénka uchiri Hanoc, Falú, Hezrón, tura Carmi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Simeónka uchiri ju armiayi: Jemuel, Jamín, Ohad, Jaquín, Zohar, tura Saúl. Nu Saúlka nukuri Canaánnumia nuwa ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Leví uchiri ju armiayi: Gersón, Coat tura Merari. ");
INSERT INTO acuNT_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Judá uchiri ju armiayi: Er, Onán, Sela, Fares tura Zara. (Kame, Er tura Onáncha Canaán nungkanam yaanchuik jakarmiayi.) Tura Faresa uchiri jimiar ju aarmiayi: Hezrón tura Hamul. ");
INSERT INTO acuNT_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Isacara uchiri ju armiayi: Tola, Fúa, Job tura Simrón. ");
INSERT INTO acuNT_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Zabulónka uchiri ju armiayi: Sered, Elón tura Jahleel. ");
INSERT INTO acuNT_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ju aints ainauka Jacob Padán-aramnum pujus Leanam yajutmarmiayi. Tura nuni pujus nawantrincha Dina naartinnun nawantrumramiayi. Jacobo weari Leanau ainauka aishmang ainau nuwa ainaujai mash irumram treinta y tres armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Tura Gada uchiri ju armiayi: Zifión, Hagui, Ezbón, Suni, Eri, Arodi, tura Areli. ");
INSERT INTO acuNT_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Tura Asera uchiri ju armiayi: Imna, Isúa, Isúi tura Bería, tura nuna umaji Sera naartin. Bería uchiri jimiar armia nuka Heber tura Malquiel armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Nu aints ainauka Jacobnau Zilpa jerermiayi. Kame, Lea apari Labán: —Zilpa Lea inatiri ati —tusa susamiayi. Tura nuka mash irumram dieciseis armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Jacobo nuwari Raquela uchiri ju armiayi: José tura Benjamín. ");
INSERT INTO acuNT_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","José Asenatnum yajutmarmia nusha ju armiayi: Manasés tura Efraín. Nuka Ejipto nungkanam akiinawarmiayi. Tura Asenatka Potifera nawantri ayayi. Tura Potiferaka yakat Onta sacerdoteri ayayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Benjaminka uchiri ju armiayi: Bela, Bequer, Asbel, Gera, Naamán, Ehi, Ros, Mupim, Hupim tura Ard. ");
INSERT INTO acuNT_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Jacobo tura Raquela weari mash irumram catorce armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Nunia Danka uchiri kichik Husim naartin amiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Tura Neftalia uchiri ju armiayi: Jahzeel, Guni, Jezer tura Silem. ");
INSERT INTO acuNT_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Nu ainauka Jacobnau Bilha jerermiayi. Kame, Raquela apari Labán: —Bilha Raquela inatiri ati, —tusa susamiayi. Tura nuka mash irumram siete armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Aints Jacobjai Ejiptonam wearuka nuu numpak ni najatin nekapmatsuk sesenta y seis aints armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","José uchiri Ejiptonam akiinawarmia nuka jimiar armiayi. Tura asamtai nujai mash irumram Jacob ni weari ainaujai Ejiptonam jearmia nuka setenta aints armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Jacob nungka Gosénnum jeatak wajas, Joséjai nu nungkanam ingkunikmi titas, Judá emajati tusa akupkamiayi. Tura Gosén nungkanam taaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","José: Aparam Gosénnum tayi tamaun antuk, ni inatirin: —Carro iwiarturataram, aparjai ingkiungtajai —timiayi. Tura carron umisaramtai, José Gosénnum we, aparijai ingkiunik, aparin minakas waraak nukap juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Turamtai Israel Josén chicharak: —Maaketai, uchiru, yamaikia wainkajme. Nekasam iwiaakuitme. Yamaikia iimia wiki iwiaaku pujamin wainkau asan, pengker nintimsan jaaknasha jakamnawaitjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Nuniangka José ni yachi ainaun tura apari weari ainauncha chicharak: —Yamaikia faraónkan werin jiisan: Wina yatsur ainau tura aparu weari ainausha wijai pujusartas Canaánnumia kaunkari tusan ujaktajai. ");
INSERT INTO acuNT_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Turakun ni ovejari ainaun tura vacari ainauncha tura ninu ainausha mash yaruakar ikiaankari tusan ujaktatjai. ");
INSERT INTO acuNT_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Nuniangka faraón atumin untsurmak: ¿Atumsha warí takakminuitrume tusa ininmataikia?, ");
INSERT INTO acuNT_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","ayaakrum: Ii juuntri ainauka tuke oveja wainin asaramtai, iisha nunisrik oveja wainin ainaji titaram. Takurminkia ejiptonmaya ainauka oveja wainin ainaujaingkia pujuschamin asaramtai, atumka Gosén nungkanmak pujustinuitrume turamtatrume, —José timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Nuniangka José faraónkan ujaktas werimiayi. Tura ujaak: Wina apar yatsur ainaujai Canaánnumia taar, ovejarin, tura vacarincha, tura waririncha mash ikiangkar Gosénnum taari, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Tura ni yachin cinco faraónkan wainkarti tusa ayamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Tura asamtai faraón José yachi ainaun iniak: —¿Atumsha warí takakminuitrume? —timiayi. Tamati aiminak: —Apuru, iikia ii juuntrijai metek oveja wainin ainaji. ");
INSERT INTO acuNT_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Ii nungkari Canaánnum nukap tsuka asamtai, ii tangkuri yuwatniurisha atsau asamtai, juni pujustasar taaji. Tura asakrin apuru, wait aneasam, Gosén nungkanam ii pujustinka tsangkamkata, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Tu tinam faraón Josén chicharak: —Aparam tura yachim ainau amijai pujusartas kaunkaru asaramtai, ");
INSERT INTO acuNT_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Ejipto nungkanam tuni pujusartas wakerina nuni pujusarti. Kame, Gosén nungkaka timiá pengkeraitai. Tura asamtai nuni pujusartin ainawai. Tura vaca wainin pengker nekau amataikia, wina vacar ainaun waitruktin pujsata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","José ni aparincha faraónnum jukimiayi. Turam Israel faraónkan wainak, niin pengker ausamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Turamtai faraón Jacobon iniak: —¿Ame warutma musachrinuitme? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Tu iniam Jacob ayaak: —Aya wekaasanak ciento treinta musachrinuitjai. Wina apachur ainauka nukap musach pujusarmia nuningkia jeatsjai. Tura uchichik nangkamsan itiurkachminiun nukap ingkiungmiajai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Nuna tusa umis, Jacob faraónkan aujas ukukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Turamtai faraón tímia nunisang Joséka Ejipto nungkanam timiá pengker irunnia nuni nungka Ramsés tutainum ni aparin tura ni yachi ainaun pujsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Nunia ni yuwatniurin mash ni yuumamurijai metek susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Kame, mash nungka ainamunam trigo atsumiayi. Tura asamtai Ejipto nungkanam tura Canaánnumsha aints ainau tsukajai kajiniarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Tuminamtai Ejiptonam pujuinauka tura Canaánnum pujuinausha trigon kuikiajai sumakaramtai, José nu kuikianka irumar, faraónka jeen ukusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Kame, Ejipto nungkanam tura Canaán nungkanmasha aints ainau kuikiari mash amukau asamtai, Ejiptonam pujuinauka Josénam weriar chicharinak: —Wait aneasam, yutai sukartusta. Ii kuikiari mash amukau asar, tsukajai kajingtatji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Tu tinam José ayaak: —Kuikiaram atsamtaikia, atumi tangkuri itataram. Turaram nujai yutai yapajiatai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Tamati ejiptonmaya ainau caballo ainaun, oveja ainauncha, vaca ainauncha, tura burro ainauncha itaar, nujai yutai yapajiawar nu musach tsukajaingkia kajingcharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Turawar chikich musachtin ataksha Josén jeariar chicharinak: —Ii kuikiarisha yanchuk mash amukayi. Tura ii tangkurisha amin mash amasmaji. Nuniangka yutai sumaktasrikia ¿warijai yapajiataij? Ii nungkarinka surukrikia, nunia iik juwaktatji. ");
INSERT INTO acuNT_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Tura asakrin yamaikia ii nungkarijaingkia sumakratkata. Turakminkia iikia faraónka inatiri wajastatji. Turakrin ame arak jingkiaji sukartakmin, faraónka nungkarinka takarsatatji. Tura asar iikia arakmar yuwakur iwiaaku pujusartinuitji. ¿Warukamtain nangkamisha tsukajaisha kajingtaij? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Kame, tsukajai jakarai tusar, ejiptonmaya aints mash ni nungkarin surukarmiayi. Turinamtai José nu nungka ainau faraónnau arti tusa sumakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Tura asamtai Ejipto nungkanam pujuinauka mash faraónka inatiri wajasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Antsu sacerdote ainaun faraón trigon nangkami susamu asamtai, nuna yuwinau asar, ni nungkarinka surukcharu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Nunia José aints ainaun irur chicharak: —Atumka faraónka inatiri ataram tusan, atumin sumakjarme. Tura atumi nungkarisha faraónnawaitai. Tura asamtai faraónka nungkarin arakmataram tusan, yamaikia aráka jingkiajin suajrume. ");
INSERT INTO acuNT_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Antsu tsamakamtai juwakrum, cinco akankamunmaya kichik akankamuka faraónnau ati tusaram suutatrume. Tura chikich cuatro akankamu ainaunka atumka jukitatrume. Tura nuna atumi uchirijai tura atumi jeen pujuinaujaisha yuwakrum, ataksha araka jingkiaji arakmataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Tamati niisha aiminak: —Maj, ame wait anenkartusu asam, iinka tsukajai jakaraij tusam uwemtikiarturume. Tura asakrin faraónka inatiri artatji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Tinau asaramtai José chichaak: —Mash Ejipto nungkanam pujuinauka arákan arakmawar, trigon juukar, cinco akankamunmaya kichik faraónnau ati tusar susartin ainawai. Ju chichamnaka tuke umikiartinuitai. Antsu sacerdote ainauka ni nungkarin surukcharu asar, arakan arakmawar trigon juwinak, faraónkan susachartinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Tura Israela weari ainauka Gosén nungkanam pujusar nukap yujararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Tura Jacob diecisiete musach Ejiptonam pujus, mash irumram ciento cuarenta y siete musachrintin wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Nunia chikich kintati jakamin nekapeak: Wári jakashtajash, tu nintimias: José wári tati tusa chichaman akuptukmiayi. Tura José taamtai niin chicharak: —Uchiru, nekasam wina pengker nintimturkumka uwejem wina makurun weakam: Ame seatme nuna nekasan umirkatjame, Yusjai tajame, turuttia. ");
INSERT INTO acuNT_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Wi seajme nuka juwaitai: Wait aneasam, wi jakamtai Ejiptonam iwiartusaip. Antsu wina namangkur Ejipto nungkanmaya jurukim, apachrun tura aparnasha iwiarsarmia nuni iwiartusta —timiayi. Tamati José ayaak: —Ame turutme nunaka timiatrusnak umiktatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Tamaitiat —Yusjai nekasan tajame: Mash umiktatjai turuttia —timiayi. Tamati Josésha: —Yuse naarin pachisan ame tame nunaka timiatrusnak umiktatjai —timiayi. Tamati Israel peaknum tamrutinam tsuntsumamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Chikich kintati Josén ujainak: —Aparam jaawai, —tiarmiayi. Tu tinam Joséka uchiri Manasésan tura Efraínkan ayas juki aparin jiistas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Tura jeamtai Jacobon ujainak: —Uchiram José jiirmastas tayi, —tinamtai Jacob jaak tepayat nantaki keemsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Tura José wayaamtai chicharak: —Yus timiá kakaram aa nuka Canaán nungkanam yakat Luz tutainum pujumiaja nuni wantinturkamiayi. Tura wina pengker awajtustas ");
INSERT INTO acuNT_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","chichartak: Anturtukta. Ami uchirmin untsuri susatnuitjame. Tura ami wearmincha nukap yujratnuitjai. Tura yaktancha untsuri yaktamawartin ainawai. Turinamtai ju nungkaka niinu ati tusan tuke susartinuitjai turutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","Turutin asamtai wi taatsaing, juni Ejipto nungkanam uchiram Efraín tura Manasés yajutmarmiame nuka wina uchir Rubén, tura Simeón ainawa nunisarang wina uchirua tumau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Tura chikich uchi yajutmartatme nuka aminu artinuitai. Tura ame jakakminkia, niisha ni yachi asar, Efraínjai tura Manasésjai aminu atinun akankar metek jukiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Tura Paran-aramnumia waketkin, Canaánnum wekaakun, yakat Efratanam jeatsrining nukuram Raquel jakamiayi. Tura jinta Efrata jeakunam iwiarsamiajai. Tura nu yaktanka yamaikia Belén inaikiamuitai, —Jacob timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Nunia José uchirin wainak, Josén iniak: —¿Jusha yana uchiri ainawa? —tu iniam, ");
INSERT INTO acuNT_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","José ayaak: Juka wina uchir ainawai. Wi Ejipto nungkanam pujain, Yus surusmau ainawai, —timiayi. Tama apari chicharak: —Wait aneasam uchi mai ayaamturkarti. Pengker awajsatasan wakerajai —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Kame, Israelka nekas juuntach wajasu asa, jiisha kusuru asamtai, José ni uchiri mai tejuwach wajasarti tusa, aparin ayaamtukmiayi. Turamtai tirangkin mai minakas mejeasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Tura Josén chicharak: —Maj, Josén wainkainjapi tuuka nintimchamiajai. Antsu tu nintimsan pujau wainiat, ami uchiram wainkatniuncha Yus tsangkatruki, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Tamati José ni uchiri ainaun: —Menastaram —tusa, niisha nijajin nungkan antitnak aparin tsuntsumruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Nunia Efraínkan untsurijai achik, tura Manasésnasha menarijai achik juki ayaamtukmiayi. Turamtai Efraínka apachri menarinini tura Manaséska apachri untsurinini wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Tura Israel tirangkin mai pengker awajsatas ni kunturin mai takunmiayi. Tura nekayat yapajiasang Efraín ekeri au wainiat, ni muuken untsur uwejejai achik, tura Manasés eemkauri au wainiat, ni muuken mena uwejejai achikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Tura José uchirin mai pengker awajsatas Israel chichaak: —Apachur Abrahamka, tura apar Isaacsha Yusen umirkarmia nu Yuska wi akiinamunmaya wina pengker waitnua nuka, ");
INSERT INTO acuNT_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","tura ni awemamuri mash pase ainamunmaya angkanmamtikrurmia nusha ju uchinka mai pengker awajsati. Tura wina naarun pachisar, tura aparu naarin pachisar, tura apachru naarincha pachisar tuke chichau arti. Tura ju uchikia untsuri yajutmarar, mash nungkanam nukap yujararti, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Antsu apari Efraínka muuken untsur uwejjai achikmaun Joséka wainak: Mianchawaitai, tu nintimias, apari uwejen Efraínka muukenia jusa, Manasésa muuken achimtikiatas takuimiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Tura aparin chicharak: —Atsa, apaachi, eemkauringkia juwaitai. Ju untsur uwejmijai achikta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Tamaitiat Josén chicharak: —Nekajai, uchiru. Pengkeraitai. Kame, Manaséscha ukunam nukap yujartinuitai tusan nekajai. Antsu yachi ekeria juka ni yachiin nangkamasang untsuri nungkanam nukap yujartinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Tura Jacob ni tirangkin mai pengker awajsatas chichaak: —Israela weari ainauka chikich aints ainaun pengker awajsartas atumi naarin pachisar tu chichasartin ainawai: Yus Efraínkan tura Manasésnasha pengker awajsamia nunisang amincha pengker awajtamsati tinu artinuitai, —timiayi. Nuna taku nekas Efraínka ekerintai tusa nekayat, naarin eemak inaik timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Nunia Josén chicharak: —Antukta. Wikia jakatatjai. Tura wainiat Yus atumjai tuke pujau asa, atumi apachri nungkarin wetaram tusa jetamkatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Tura ami yachim ainaun nangkamasnak Siquem nungkancha susamjai. Kame, amorreo ainaun nepetkan, nu nungkanka atankimiajai, —Jacob timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Nunia Jacob ni uchiri ainaun untsuk, chicharak: —Wini ayaamkataram ukunam atiniun pachisan chichaman ujaktatjarme. Nu antuktaram. ");
INSERT INTO acuNT_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","Wina uchir ainautiram, wikia Jacob naartin wainiat, wina naarnaka Israel ati tusa Yus inaitukmiayi. Atumi apari turamtiatrume nuka antuktaram. ");
INSERT INTO acuNT_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","Rubénka, ameka nampuarurinme. Tura asam kakarmaitme. Tura asakmin aminka pengker awajtamin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Antsu nampuaruri ayatum, entsa tampaaramuri winawa nunismek atsantrachmin asam, wina nuwaru inatirijai kanurtasam, wina peakrun tepesmiame. Tura asam mianchau atatme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","Tura Simeónkan tura yachi Levíncha chicharak: —Atumka mai metek maanin aints asaram, itiurkachmin amataikia, wári meset najanatasrum wakerarme. ");
INSERT INTO acuNT_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Atumka aints ainaun kajerakrum maamiarume. Tura nangkamrumsha vaca kangkajin kupirkaru asakrumin, aints iruntrar chichainamunam atum chichaakrumka, wikia nuna antutan pengké nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","¡Atumka timiá kajeu asakrumin, nuka pengké paseetai tusan, atumi yumingkiajrume! Tura asamtai Israel nungkanmaka iruntraram pujutsuk, kanakrum pujusartin ainarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","9","Tura Judán chicharak: —Uchir Judáya, ami yachim ainauka amin pengker awajtamin ainawai. Tura nemasem ainau nepetkam, aints suwenam achiawa nunisketme. Ameka juun yawaa uchiria tumawaitme. Nuka kuntinun achik maa, juun yawaaya tumau namangken yuwa tutuar ayamak tepawa nunismek amesha ayamratnuitme. ¿Yáki amin itit awajtamin at? ");
INSERT INTO acuNT_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Apu ushukrutain kuri najanamun takus nujai aints ainaun inawa nunismek ameka nekasam aints ainaun inartinuitme. Tura asam nekas nurintin taatsaing, nu ushukrutainka atankichartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","12","Tura inakratin asa, ni burrochirin uva araamua naekrijai jingkia, ni wejmakrin uva yumirijai nijartinuitai. Tura uva yumiri ijuramun amur, ni jiisha uva yumiri nangkamasang washukuitai. Tura ni naisha muntsun nangkamasang pujuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","Tura Zabulónkan chicharak: —Ameka uchiru, juun entsa yantamen pujustinuitme. Nuni juun kanu ainau nujamkartin ainawai. Tura ami nungkemka Sidón nungkanam jeatnuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","Nunia Isacaran chicharak: —Ameka burro merman entsawa nunisketme. Tura tangku ayamtainam entsamtai ainau ayaminawa nunismek ayamsatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Nuniangka ami nungkemin pujusam, nekas pengkeraitai tu nintimsam, tura juni ayamsatniusha pengkeraitai tusam, merman entsaktinuitme. Tura nakitajai tutsuk, chikich aintsu inatiri wajastinuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","Nunia Dankan chicharak: —Israela weari ainau doce akankamuri nuni kichik aminu atinua nuni ami aintsrum ainau inartinuitme. ");
INSERT INTO acuNT_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Tura napi jintá yantamen tepes, kawainum entsatkaun nangkamaun wainak, kawai ajuarti tusa, kawain nawenam esaitnuita nunisketme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","Nunia chichaak: —Apuru Yus, ame uwemtikrurta tusan nekajme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","Tura Gadnasha chicharak: —Suntar untsuri amijai maaniawartas taartinuitai. Turamaitiatum ameka nepetmakam papeektinuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","Tura Aseran chicharak: —Uchiru, ami yutairmikia nukap atinuitai. Tura aints ainaun ipiaakminkia, apu yutairia nunisang ati tusam yutainka susatnuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","Nunia Neftalín chicharak: —Ameka japa angkan wekaawa nunisketme. Tura ami uchiram ainausha japa uchiria nunisarang shiiram artinuitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","Tura Josén chicharak: —Uchiru, ame numi entsa yantamen araamua nuka nukap nerektinua nunisketme. Numi timiá nerek wajawa nuna kanawe wenurmaunum patasu asa kupikchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Amin kajertaminak pujuinauka tishimkurin achikiar, wachin tias akupkartin ainawai. Tura asar tukee itit awajkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Antsu ameka kakaram wajastinuitme. Tura asam aints tishimkurin achikua nunisketme. ¡Maj, wina Yusur timiá kakaram asamtai, tenukap maaketai tajai! Nuka nekas oveja wainua nunisang wi wear ainaunka nekas ayamruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Aparmi Yusri timiá kakaram aa nuka amincha yainmaktinuitai, tura pengker awajtamsatnuitai. Yuska nayaimpinmaya waitmak, juun entsa nitkarin pujamnin yainmaktinuitai. Tura asa ami wearmincha angkan jererar, pengker muntsawarti tusa yainmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Wina aparka tura nukursha pengker awajtusarmia nuna nangkamasnak wikia aminka pengker awajsamiajme. Nu pengker awajtamsamuka mura ainau tuke mengkatsuk iruna nunisang atinuitai. Tura asamtai ami yachim ainiau nangkamasmek Yus eakmawaitme, —Josén timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","Nunia Benjaminkan chicharak: —Uchiru, ameka pachim yukartinua nunisketme. Yukartinka kashik kuntinun maa nanmangken yuwatnuitai. Tura angkuanmatai ampintrau ainau chikich ainau jukiarti tusa akanturtinuitai, —Israel —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Israel ni uchirin doce armia nuna kichkimias kichkimias ni ukunam atinun pachis timia nuka nuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","30","Chikich kintati Jacob ni uchiri ainaun irur chicharak: —Yamaikia nekasan jatanak wajasjai. Tura wi jakamtai, apachur Abraham Canaán nungkanam pampa waari ii weari ainau iwiarsamunam iwiartustaram. Nu pampa waaringkia Macpelaka Mamre yaktanmaya tsaa taakmanumanini awai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Tura nuni apachur Abrahamnasha, tura nuwari Sarancha, apar Isaacnasha tura nuwari Rebecancha iwiarsarmiayi. Nunia wisha nuwar Leancha nuni iwiarsamiajai. ");
INSERT INTO acuNT_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Nu pampa waarisha ajartuk hitita aints ainiamunmaya apachur Abraham kuikiajai sumakmia nuwaitai, —tusa Jacob ni uchiri ainaun timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Tura Jacob ni uchiri ainaun mash chicharak umis, peaknum tepes jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Tura jakamtai, José juuti aparin minakas mejeasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Nunia tsuwakratin ainau ni apari namangken tsuwakjai yakarartas taarti tusa, chichaman akupkamiayi. Tura taaramtai timiatrusarang umirkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Kame, tsuwakratin ainau tuke turina nunisarang cuarenta kinta Jacobo namangken yakarar umisarmiayi. Tura ejiptonmaya ainau Israela jakamurin nintimsar, setenta kinta juutiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Tura juutiar umisaramtai, José faraónka inatiri ainaun chicharak: —Wait aneasrum, wina pengker nintimturkurmeka, José tawai tusaram faraón titaram: ");
INSERT INTO acuNT_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","Aparka jatanak wajak, wina chichartak: Wi jakamtai, jakau iwiartain wi Canaán nungkanam umismiaja nuni iwiartusta, Yusjai tajame turuttia tusa turutmayi. Tu turutin asamtai, nuni wena, tura mash umisan tatajai tusan wait aneasam tsangkatrukta, turamui tusaram faraón ujatruktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Tusa akatram faraónkan jeariar: José turammayi tusar ujaam, faraón nuna antuk, Josén chichaman akuptak: —Takumka aparmi timiaurin timiatrusmek umikta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Tamati José aparin iwiarsatas we ai, faraónka jeen apu inatiri wainin ainau tura Ejipto nungkanam inakratin irunmi nusha nijai tsaniasar wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Tura Jacobo weari ainausha mash, tura José ni wearijai mash, tura José yachi ainausha mash Canaánnum wearmiayi. Antsu ni uchiri ainaun tura tangkuri ainauncha ni waintairijai Gosén nungkanam ukukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Tura carro ainamunam, tura kawai ainamunmasha entsamkar untsuri aints niijai tsaniasar wekaasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Tura Jordán entsanam tsaa taakmanumanini Goren-ha-atad tutainum jear, José ni apari jakamurin nintimtusmi tusa, siete kinta aints irunujai mash tsaniasar juutiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Tura Canaán nungkanam pujuinauka nu juutmaun wainkar, nukap nintimrar: —Ni aintsri jakau asamtai, ejiptonmaya ainauka timiá juutinak pujuinawapi —tusar nu nungkanka Abel-mizraim inaikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","13","Tura yaanchuikkia Abrahamka Canaán nungkanam pampa waari ajartuk ni weari ainau iwiarsamuri ati tusa, Macpelanam hitita aints Efrón naartinnumia sumakmia nuni Jacobo uchiri ainauka apari timia nunisarang iwiarsarmiayi. Kame, nu pampa waaringkia Mamre yaktanmaya tsaa taakmanumaninintai. ");
INSERT INTO acuNT_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Tura mash umisar José ni yachi ainaujai tura ejiptonmaya ainaujai niin nemarsar wekaasarmia nujai ataksha Ejiptonam waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Jacob jakau asamtai, José yachi ainauka ningki nintimsar: —Ii yachinka nukap pase awajsamu asakrin, iincha tuke kajertamatsjiash. Tura asa yapaijkiataj tuusha nintimtsuash —tusar, ");
INSERT INTO acuNT_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","17","chichaman akuptinak: —Aparam iwiaaku pujus iin chichartamak: José ju chichamka ujaktaram: Yachim ainauka amin timiá pase awajtamsaru wainiatmek, wait aneasam, yachimi tunaari tsangkurarta tawai titaram turammaji. Tu turamin asamtai, iisha aparmi Yusri inatiri asakrin, wait aneasam, ii tunaaringkia tsangkukratkata tusar seaji, —tusar nu chichaman Josén akuptukarmiayi. Akuptukaram José nuna antuk juutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","José juutu pujai, ni yachi ainau tariar, nijajin nungkan antitnak tsuntsumruawar chicharinak: —Yamaikia ami inatirmitji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Tinamaitiat José ayaak: —Shamrukairap. ¿Wi Yuskaitiaj? Wikia atumniaka wait wajaktinaka susashtatjarme. ");
INSERT INTO acuNT_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Kame, atumka winaka pase awajtustasrum wakerayatrum, Yus untsuri aintsun uwemtikratniun ju nungkanam akuptukmiayi. Tura asamtai nu aints ainauka yamaiya juisha iwiaaku pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Tura asamtai shamrukairap. Wikia atumin tura atumi uchiri ainauncha yutancha susatatjarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Nunia José ni yachi ainaujai tuke mash Ejiptonam pujusarmiayi. Joséka ciento diez musachrintin pujus, ");
INSERT INTO acuNT_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Efraínka tirangki uchirin wainkamiayi. Tura Manasésa uchiri Maquir naartinu uchiri ainaun ni jeen tsakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Kame, chikich kintati José ni yachi ainaun chicharak: —Wikia jatanak wajasjai. Antsu Yuska atumin yainmaktatrume. Tura asamtai ju nungkanmayangka jiirmakiar, Abrahaman tura apachru Isaackan, tura ii aparincha chicharak: Nu nungkaka atumnau ati tusa, suramsatas wakerimia nu nungkanmaka atumin jeetamkatnuitrume, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Tura ni yachi ainaun ataksha chicharak: —Yus atumnaka nekas yainmaktinuitrume. Tura wi jakamtai, atum juniangka jiinkiram weakrumka, wina ukunchrusha ukurtutsuk jukitiaram. Turatin asakrumin yamaikia: Ame akatmamkartukume nuka nekasrik umiktatji. Yuse naari pachisar tajarme tusaram turuttiaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Nuniangka José ciento diez musachrintin asa, Ejiptonam jakamiayi. Turamtai ni namangke kaurchati tusar, tsuwakratin ainauka tsuwakjai yakararmiayi. Turawar aints jakau engketainam engkeawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS1_1","020_1_1","PSA","1","1","1","Aintsti Yus nintimsar pujuinautikia pasé aints ainau pachiachu asar, nekasar pengker nintimsar warastinuitji. Tura tunau aints wekajina nuni wekaichau asar, nekasar pengker nintimsar warastinuitji. Tura Yusen umirchau ainauka wishikiartin asaramtai, nu aints ainaujai iruntsuk pujuinau asar, nekasar pengker nintimsar warastinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS1_2","020_1_2","PSA","1","2","2","Yus nintimsar pujuinautikia Yuse chichame aneau asar, tsawaisha tura kashisha nuke nintimsar pujustinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS1_3","020_1_3","PSA","1","3","3","Tu pujakrikia numi entsa yantamen araamua nunisketji. Nu numi neretiri jeamtaikia nukap nerektinuitai. Tura nukésha minarchartinuitai. Tu pujakrikia nekasar pengker aa nu turuatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS1_4","020_1_4","PSA","1","4","4","Antsu Yusen nintimchau ainauka tuuka pujuinatsui. Nuka nase trigo saapen juwawa nunisarang mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS1_5","020_1_5","PSA","1","5","5","Tura asar Yusen umirchau ainauka Yuse umirin ainaujaingkia nayaimpinmaka iruntrachartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS1_6","020_1_6","PSA","1","6","6","Antsu ii Apuri ni umirin ainautinka mash nekarmaji. Antsu Yusen nintimchau ainauka mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_1","020_2_1","PSA","2","1","1","¿Waruka Yusen umirchau ainau Yusen kajerkar shininawa? ¿Tura warukaya nangkamiarsha nintiminawa? ");
INSERT INTO acuNT_vpl VALUES ("PS2_2","020_2_2","PSA","2","2","2","Mash nungkanmaya apu ainau aintsun inau ainaujai kaunkar Yus ni Uchirin: Apu ati tusa akupkamu waininayat kajerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_3","020_2_3","PSA","2","3","3","Turasha Yusen umirtan nakitinau asar kakarar untsuminak: “Yus iin jirujai jingkiatmamuringkia yamaikia atimiami, turar nuniangka angkan wajasmi”, nangkamiar tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_4","020_2_4","PSA","2","4","4","Tinau wainiat Apu Yus nayaimpinam pujus aints ainaun ina nuka nuna antuk wishikiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_5","020_2_5","PSA","2","5","5","Nunia nu aints ainaunka kakarman kajerak Yus awaakatnuitai. Tura chicharak: ");
INSERT INTO acuNT_vpl VALUES ("PS2_6","020_2_6","PSA","2","6","6","“Wikia yanchuik wina akupkamurnaka Jerusalénnum mura pengkernum aints ainau Apuri ati tusan puusamiajai”, tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_7","020_2_7","PSA","2","7","7","Yamaikia Yus ni uchirin pachis ta nuna etserkatjai. Ni uchirin chicharak: “Ameka wina nekas uchiruitme. Ju kintati wina kakarmarun suajme”. ");
INSERT INTO acuNT_vpl VALUES ("PS2_8","020_2_8","PSA","2","8","8","“Mash nungkanmaya ainau winar arti tusam wina seattia. Turakminkia wikia aminka susatnuitjame. ");
INSERT INTO acuNT_vpl VALUES ("PS2_9","020_2_9","PSA","2","9","9","Tura apu wajasam aints kajek nangkijai muitsan awati tsayawa nunismek apu ainauka mengkaktinuitme”, Yus ni uchirin tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS2_10","020_2_10","PSA","2","10","10","Apu ainautiram, aints inau ainautirmesha ju chichamka antuktaram. Tura tenapkesrum nuimiartaram. ");
INSERT INTO acuNT_vpl VALUES ("PS2_11","020_2_11","PSA","2","11","12","Tura pengker nintimsaram Yus: Ameketme Apum titaram. Ni aneachmau atumnaka kajertamkatnuitai. Tura asamtai wina kajertukai tusaram tsuntsumruataram. Nu turachkurminkia Yus atumin kajertamkamtai, atumka jintá wekaakuram aneachmau jakai tusaram aneartaram. Antsu aints Yusen nintimsar: Wina Yusruka wina uwemtikrurtinuitai tinauka warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS3_1","020_3_1","PSA","3","1","1","Apuru wina nemasur untsuri ainawai. Tura wina nakitrinausha untsuri ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS3_2","020_3_2","PSA","3","2","2","Aints untsuri wina pachitsar chichartinak: “Yuska uwemtikramrashtinuitai”, nangkamiar turutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS3_3","020_3_3","PSA","3","3","3","Antsu Apuru ameka wina tantaarua nunisketme. Tura asam winaka tententam pujurtame. Ameka wina kakarmaruitme. Wikia napchau nintimsan pujaing, ameka pengker nintimtikrurtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS3_4","020_3_4","PSA","3","4","4","Wikia amin untsukmaikiakun: Yainkata tusan seam, ami pujutiram timiá pengker aa nunia winaka airnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS3_5","020_3_5","PSA","3","5","5","Ame wina waitu asakmin, tepesan nunia kanuran ataksha shintiaajai. ");
INSERT INTO acuNT_vpl VALUES ("PS3_6","020_3_6","PSA","3","6","6","Wina nemasur ainau untsuri wina nepetukartas tentatkar pujuinaksha winaka awaktukchartatui. ");
INSERT INTO acuNT_vpl VALUES ("PS3_7","020_3_7","PSA","3","7","7","Apuru jiirsata. Tura wina Yusur asam uwemtikrurta. Wina nemasur ainau aintsu yapiin awatinawa nunismek tura nain akarinawa nunismek nepetkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS3_8","020_3_8","PSA","3","8","8","Apuru aints ainau uwemtikratnumka ametme. Tura asam aminu aintsrum ainautin pengker awajkartusta, tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS4_1","020_4_1","PSA","4","1","1","Yusru wina ayamrutkatin asam wi untsuamka airkata. Wi wake mesekan pujamtaisha, ameka pengker awajtusmame. Tura asam yamaikia wait anentrurta tura wi seamur anturtukta, tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS4_2","020_4_2","PSA","4","2","2","Atumin miajuitjai tumamin ainautirmin tajarme: ¿Warutia wina pasé awajtutcha inaisatatrume? ¿Warutia nangkamrum nintimtairumsha inaisatatrume? ");
INSERT INTO acuNT_vpl VALUES ("PS4_3","020_4_3","PSA","4","3","3","Yus aints ainaun: Wina umirtukarti tusa wakerawai. Nuka nekaataram. Wi untsuam winaka anturtuktatui tusaram nekaataram. ");
INSERT INTO acuNT_vpl VALUES ("PS4_4","020_4_4","PSA","4","4","4","Yus shamakrum kurartaram. Tura tunaarum inaisataram. Tura takamtaik atumi peakrin tepesrum: Wina tunaar atsuash tusaram nintimrataram. ");
INSERT INTO acuNT_vpl VALUES ("PS4_5","020_4_5","PSA","4","5","5","Tura Yus wina tunaarun tsangkutrurat tusaram, tangku maaram epeataram. Turakrum Yus kajinmatsuk nintimrataram. ");
INSERT INTO acuNT_vpl VALUES ("PS4_6","020_4_6","PSA","4","6","6","Aints untsuri chichainak: ¿Yáki iincha nekas pengker aa nuna inakturmastinuitai? tinawai. Apuru iincha pengker nintimkartusam jiikratsata. ");
INSERT INTO acuNT_vpl VALUES ("PS4_7","020_4_7","PSA","4","7","7","Aints trigon tura vinoncha nukap juukar waraina nuna nangkamasmek ame wina nintirun waramtikrusmame. ");
INSERT INTO acuNT_vpl VALUES ("PS4_8","020_4_8","PSA","4","8","8","Ame Apuru wina chichartakum: Nekas shamtsuk pujusta tusam nintimtikruru asakmin, wikia tepesan pengker nintimsan wári kanurtatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS5_1","020_5_1","PSA","5","1","2","Apuru wina Apur asam, tura wina Yusur asam, wina chichamur anturtukta. Wi napchau nintimsan mayairukmaikiakun seajme. Tura amin seajme nu amesha anturtukta tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS5_3","020_5_3","PSA","5","3","3","Apuru kashik wina chichamur anturtuktatme. Tura asan wisha amin airkat tusan nakastatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS5_4","020_5_4","PSA","5","4","4","Yusru ameka pasé aa nuka nakitame. Pasé aints ainauka amijai tsaniasarka pujuscharmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS5_5","020_5_5","PSA","5","5","5","Aints miajuitjai tumamin ainauka ami pujutirminka pujuschartin ainawai. Tura asaramtai tunau takau ainauka ameka tsuutame. ");
INSERT INTO acuNT_vpl VALUES ("PS5_6","020_5_6","PSA","5","6","6","Turasha waitrin ainauka mengkaaktinuitme. Tura tsanumin ainausha tura mangkartin ainausha nakitratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS5_7","020_5_7","PSA","5","7","7","Antsu wina anentu asakmin, ami jeemin wayaamnawaitjai. Tura nuni wayaan amin nintimtusan: Ameketme juuntam titinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS5_8","020_5_8","PSA","5","8","8","Apuru wina nemasur ainau untsuri asaramtai, ame pengker asam jintim inaktursata, turasha nuni wekaamtikrusta tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS5_9","020_5_9","PSA","5","9","9","Wina nemasur ainauka nekas chichamnaka tuke chichachu ainawai. Ni nintisha tuke paseetai. Ni jangkengka jakau iwiarsamu urakmawa nunisarang pasé chichau ainawai. Tura jimia chichamtin asar tuke anangminak chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS5_10","020_5_10","PSA","5","10","10","Yusru nu aints ainau ni wait wajaktintri susarta. Turasha ni pasé nintimaurisha mengkatkarta. Aminu nemasem asar, aminu chichammin umirtan nakitin ainawai. Tura asaramtai ame nu aints ainau jiikim utsangta. ");
INSERT INTO acuNT_vpl VALUES ("PS5_11","020_5_11","PSA","5","11","12","Antsu amin nintimsar: Ayamtikrurta tinu ainautikia mash warastinuitji. Ame ayamtikramu asar tuke warasar kantamatatji. Apuru amin umirkur pujuinautin pengker awajkartusu asakmin, ame aneau asar amek nintimsar waraaji. Ame pengker asam, aints tantaaran takus ni nemase ainaun shamtsuk nakawa nunismek aminu aintsrum ainau tentakam wainu weame. ");
INSERT INTO acuNT_vpl VALUES ("PS6_1","020_6_1","PSA","6","1","1","Apuru ame kajertukam jiyatkaip. Tura aminu suwirumjai wait wajaktinka surusaip. ");
INSERT INTO acuNT_vpl VALUES ("PS6_2","020_6_2","PSA","6","2","2","Apuru wikia kakarchamin nekapeau asamtai wait anentrurta. Apuru wina namangkur kura kura wajau asamtai, wait aneasam ataksha pengker wajasta tusam inantukta. ");
INSERT INTO acuNT_vpl VALUES ("PS6_3","020_6_3","PSA","6","3","3","Wina nintirjai shamakun kuraajai. Tura asamtai Apuru ¿warutik yainkatnuitam? ");
INSERT INTO acuNT_vpl VALUES ("PS6_4","020_6_4","PSA","6","4","4","Apuru winita. Tura jakai tusam uwemtikrurta. Timiá wait anengkratin asam uwemtikrurta tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS6_5","020_6_5","PSA","6","5","5","Jakaru ainauka kichkisha aminka nintimturminatsui. ¿Jakaru ainausha iwiarsamurin tepesar: Ameketme juuntam turaminawak? ");
INSERT INTO acuNT_vpl VALUES ("PS6_6","020_6_6","PSA","6","6","6","Wikia juu juutkan pimpiran pujajai. Kashijai metek juu juutkan neaikirjai tamrutirun chupran tepajai. ");
INSERT INTO acuNT_vpl VALUES ("PS6_7","020_6_7","PSA","6","7","7","Wina nemasur ainaun nintimtusan juutu asan, jiirusha wainmakchamin mushatmari. ");
INSERT INTO acuNT_vpl VALUES ("PS6_8","020_6_8","PSA","6","8","8","Antsu Apurka wina juutmaurun anturtuku asamtai, pasé takau ainauka wijaingkia iruntsuk yajá wearti. ");
INSERT INTO acuNT_vpl VALUES ("PS6_9","020_6_9","PSA","6","9","9","Wina Apurka wi seamurnaka antukuitai. Tura wi seaja nunaka mashiapi umiktatua tusan nekajai. ");
INSERT INTO acuNT_vpl VALUES ("PS6_10","020_6_10","PSA","6","10","10","Wina nemasur ainau shaminak jakaartas wakerinawai. Turasha natsaaminak aints mitsum mitsum wajainawa nunisarang tupikiakiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_1","020_7_1","PSA","7","1","1","Apuru ameka wina Yusruitme. Tura asakmin ejarkata tusan amin seajme. Tura wina papeetina nunia uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS7_2","020_7_2","PSA","7","2","2","Turachkumningkia juun yawaa kuntinun esai yuwina nunisarang winasha mantuwartatui. Turutinamtaisha ¿yáki wina uwemtikrurat? ");
INSERT INTO acuNT_vpl VALUES ("PS7_3","020_7_3","PSA","7","3","3","Apuru ameka wina Yusruitme. ¿Wisha warí tunauna takasuitja? ¿Wikia kasakitaj? ");
INSERT INTO acuNT_vpl VALUES ("PS7_4","020_7_4","PSA","7","4","4","Wina amikur wina pengker awajtinaunka paseeka awajsachuitjai. Tura wina nemasur wina nangkami wekaatursaru ainia nunasha paseeka awajsachuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_5","020_7_5","PSA","7","5","5","Wi aints ainaun pasé awajkun pujamtaikia, wina nemasur wina pataaturak tura amantuk achirak nungkanam ajuntar wina japirkiti, tura nuna turak inatsturti tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS7_6","020_7_6","PSA","7","6","6","Apuru kakaram kajekam pasé aints ainau nepetkata. Tura wina nemasur wina kakarman kajertina nu wainkam ayamrutkata. Ame nekasam pasé aints ainau ni tunaarijai metek wait wajaktintri susam winaka yainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS7_7","020_7_7","PSA","7","7","7","Aminu keemtairam nayaimpinam puusam nuni keemsakmin, mash nungkanmaya ainau amin tentenmawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_8","020_7_8","PSA","7","8","8","Apuru mash nungkanmaya ainau tunaari itiura ainawa tusam wainuitme. Tura asam pengker takaaja nu nekartuata. Tura wina nintirun tunau atsuash tusam jiirtusta. ");
INSERT INTO acuNT_vpl VALUES ("PS7_9","020_7_9","PSA","7","9","9","Yusru ameka tunaarinchau asam, aints ainau nintimauri pengké nekaachmin ainia nu nekame. Tura asakmin pasé ainau ni turamuri inaisarti tusam mengkaakta. Turasha anangmichu ainau tuke pengker pujusarti tusam wainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS7_10","020_7_10","PSA","7","10","10","Wina waitkatnuka Yus nayaimpinam puja nuketai. Nekas pengker nintintin ainaun uwemtikratnuka nuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_11","020_7_11","PSA","7","11","11","Yuska pengké tunaarinchau asa, aints ainaun mash metek jiiawai. Turasha tuke tunau ainaun wait wajaktiniun suwitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_12","020_7_12","PSA","7","12","13","Aints ni nangkirin tsaka umisua nunisang Yus niin umirkacharu ainaun wait wajakartintrin wári umistinuitai. Tura aints tishimkurin umis wachin ketuktas wajawa nunisang Yus niin umirkacharu ainaun wait wajakartintrin akuptuktas yanchuk umismawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_14","020_7_14","PSA","7","14","14","Tunau takau ainau itiur pujuinawa tusaram nintimrataram. Nuka tunaun takasartas tuke nintiminawai. Tura ni jangkenia jiinua nuka waitaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_15","020_7_15","PSA","7","15","15","Aints nungkan tai nu waanam chikich aints aneachmau ayaarti tusa umisiat, niyá kunanam ningki ayaawa nunisang pasé aints ainauka mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_16","020_7_16","PSA","7","16","16","Ni tunaari tura ni mangkartutirisha untsuri asaramtai, ningki wiasmatmamin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS7_17","020_7_17","PSA","7","17","17","Antsu wina Apur nekas tunaarinchau asamtai, ameketme pengkeram titatjai. Tura Apur nayaimpinam puja nuna naarin pachisan kantan kantamruatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS8_1","020_8_1","PSA","8","1","1","Apuru iinu Yusri asam, mash ainia nu inawaitme. Nayaimpinam ame najanamu ainauka mash shiiram asaramtai, wikia ami naarmin pachisan: Ameketme juuntam tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS8_2","020_8_2","PSA","8","2","2","Ami nemasem ainau amin nakitraminak yapaijkiami tinu ainau itatmamtikiatasam, uchi kuwirach ainausha amin nekasar pengker awajtamsartas maaketai turutiarti tusam tsangkatu weame. ");
INSERT INTO acuNT_vpl VALUES ("PS8_3","020_8_3","PSA","8","3","3","Wikia nayaimpin ame najanamu ainaun jiisan, nantuncha tura yaancha nuni ketinau jiisan amijai chichaakun: ");
INSERT INTO acuNT_vpl VALUES ("PS8_4","020_8_4","PSA","8","4","4","Aintsti mianchau arincha, ¿waruka timiá anengkratme? Aintsti jakatin arincha, ¿waruka timiatcha nintimturkartusmesha pujame? ");
INSERT INTO acuNT_vpl VALUES ("PS8_5","020_8_5","PSA","8","5","5","Aints ainautikia yamaik jakatin asakrin, antsu ame awemamurmeka jakashtin asaramtai, aintstin nangkamasmek pengker najanamiame. Turayatum aintstinka amea tumau najakratau asam, timiá pengker awajkartusmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS8_6","020_8_6","PSA","8","6","6","Tura mash najanamuram ainaun aints ainauti inararti tusam tsangkamkamiame. Tura mash najanamuram ainau aintsti ainautin umirkarmi tusam najanamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS8_7","020_8_7","PSA","8","7","7","Uwija ainau tura waaka ainausha tura pachim ainausha, ");
INSERT INTO acuNT_vpl VALUES ("PS8_8","020_8_8","PSA","8","8","8","tura nanamtin yakí nanamin ainausha tura namak ainausha tura juun entsanmaya ainausha mash aints ainau inararti tusam tsangkamkamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS8_9","020_8_9","PSA","8","9","9","Apuru iinu Yusri asam, mash ainia nu inawaitme. Tura asakmin ami naarmin pachisan: Ameketme juuntam tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS9_1","020_9_1","PSA","9","1","1","Apuru tuke wina nintirjai amincha: Ameketme juuntam titasan wakerajme. Turasha ami turamurmin etserkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_2","020_9_2","PSA","9","2","2","Apuru nayaimpinam pujame nu, amin pachisan pengker nintimsan kakaran chichaktasan wakerajai. Turasha waraakun amin naarmin pachisan kantan kantamatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_3","020_9_3","PSA","9","3","3","Wina nemasur ainau amin shamraminak tupikinawai, tura tupikinak ayaarar jainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_4","020_9_4","PSA","9","4","4","Ame nekasam chicham iwiarin asam, aints ainau tunaari nekaatasam, tura winasha ayamtikrurtasam ami keemtairumin keemsam pujame. ");
INSERT INTO acuNT_vpl VALUES ("PS9_5","020_9_5","PSA","9","5","5","Ami chichammin umirtamchau ainau jiyakume. Tura pasé aints ainausha nepetkamame. Tura ni naarincha chikich aints ainau tuke nintimtsuk pujusarti tusam sakarume. ");
INSERT INTO acuNT_vpl VALUES ("PS9_6","020_9_6","PSA","9","6","6","Wina nemasur ainau jakaarmayi. Turasha ni yaktari ainau nijai metek mengkaakarmayi. Tura nu yakat ainauka mesramame. Tura asam nu yakta naarincha aints ainau tuke nintimtsuk pujusarti tusam sakarume. ");
INSERT INTO acuNT_vpl VALUES ("PS9_7","020_9_7","PSA","9","7","7","Antsu wina Apur tuke aints ainaun inawaitai. Tura asa aints ainau itiur pujuinawa tusa nekaatas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_8","020_9_8","PSA","9","8","8","Tura tunau nekamtikin asa, mash nungkanmaya ainaun ni tunaarijai metek ni wait wajaktintrin suwitai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_9","020_9_9","PSA","9","9","9","Aints wait wajainaunka wina Apur ejaktinuitai. Nunia wake mesekar pujuinauncha ayamruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_10","020_9_10","PSA","9","10","10","Apuru amin eatmina nuka ameka ajapamka ukuatsme. Tura asakmin amin umirtaminauka amincha nintimturminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_11","020_9_11","PSA","9","11","11","Ii Apuri Jerusalénnum ni aintsrin inawa nu nintimsaram kanta kantamataram. Turasha ni turamuringkia aints ainau ujaktaram. ");
INSERT INTO acuNT_vpl VALUES ("PS9_12","020_9_12","PSA","9","12","12","Waitnasar pujuinaunka kajinmatsuk, ni juutmaurincha Yuska kajinmatsui. Antsu aints ainaun waitkina nuna ni wait wajaktintrin suwitai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_13","020_9_13","PSA","9","13","13","Apuru wait anentrurta. Wina kajertin ainau wina pasé awajtusartas pujuina nu amesha jiisarta. Tura jakai tusam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS9_14","020_9_14","PSA","9","14","14","Wikia Jerusalénka waitirin wajasan, mash aints ainaun chicharkun, amin naarmin pachisan Yus nekas juuntaitai titaram tusan, wina uwemtikturu asakmin waraajai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_15","020_9_15","PSA","9","15","15","Amin umirtamkacharu ainau aints ejatkanam napinawa nunisarang ainawai. Aintsun achikmi tusar jintanam ningki ejatkan ukukiariat, nuni wekaasar ejatkanam napiar ni nawen jingkiawarua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_16","020_9_16","PSA","9","16","16","Apur ningki pasé aints ainaun ni turamurijai metek wait wajaktiniun suwitai tusa nekamtikui. Pasé aints ainau chikich aintsun ejatkanam achikmi tinayat, ningki napinua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_17","020_9_17","PSA","9","17","17","Nu pasé aints ainauka Yusen umirkacharu asar, nunia Yusen kajinmakiaru asar, tuke jakatniunam weartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_18","020_9_18","PSA","9","18","18","Antsu kuikiartichu ainaun Yuska tuke kajinmatsui. Turamtai Yusen nintimsar pujuinauka mengkakachartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS9_19","020_9_19","PSA","9","19","19","Apuru wajakim aints miajuitjai tumamin ainia nuna turatniuringkia tsangkatkaip. Tura amin umirtamchau ainauka ni tunau turamurijai metek ni wait wajaktintri susarta. ");
INSERT INTO acuNT_vpl VALUES ("PS9_20","020_9_20","PSA","9","20","20","Apuru wina shamrukarti tusam nintimtikrarta. Tura wisha aintsketjai turamiarat tusam nekamtikiawarta. ");
INSERT INTO acuNT_vpl VALUES ("PS10_1","020_10_1","PSA","10","1","1","Apuru ¿waruka timiá aráksha pujame? ¿Wi wait wajaisha waruka anumkamsha pujame? ");
INSERT INTO acuNT_vpl VALUES ("PS10_2","020_10_2","PSA","10","2","2","Pasé aints ainau: Wikia miajuitjai tusar, mianchau ainaun kajerinak waitkinawai. Tura ejatkan ningki puusar napinawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_3","020_10_3","PSA","10","3","3","Pasé aints ainauka ningki nintimsar: Wi wakeraknaka wina wakeramurun pachitsuk turamnawaitjai tinawai. Tu nintiminauka Yusen nakitinau asar, niin pachisar pasé chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_4","020_10_4","PSA","10","4","4","Tura meemasar pajakiar chichainak: Yuska atsawai. Turasha ameka waruka aitkame turutinka atsawai, tu nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_5","020_10_5","PSA","10","5","5","Tu nintiminauka tuke ni takatrin takakminau asar yuumatsuk pujuinawai. Tura ningki nintimsar: Wait wajaktinnasha Yuska suruschatatui, nangkamiar tinawai. Nuniasha ni nemase ainaun pachisar wishikinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_6","020_10_6","PSA","10","6","6","Tura ningki nintimtumasar: “Wina nemasur ainauka ujuntrarchatnuitai. Tura asamtai itiurkachminumka pengké pujuschatatjai”, tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_7","020_10_7","PSA","10","7","7","Tuke inaitsuk chikich ainaun jiyainak pasé chicharin ainawai. Tura waitrinak chikich ainaun pasé awajsartas anangkinak chichainawai. Tu chichainau asar chikich ainaun waitkinak pasé awajinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_8","020_10_8","PSA","10","8","8","Nu pasé aints ainauka ayamrumichun nangkamiar maawartas anumkar, yaktanmaya jiinkiti tusar nakainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_9","020_10_9","PSA","10","9","9","Juun yawaa kuntinun esai yuwatas waanam nakawa nunisang mangkartin anumak aints mianchaun nakawai. Tura wainak aneachmau nu aintsun achik japiki juwawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_10","020_10_10","PSA","10","10","10","Juun yawaa tsekengtias kaemua nunisang mangkartin aints ayamrumichun achiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_11","020_10_11","PSA","10","11","11","Pasé aints ainauka: Yuska iinka nintimturmatsji. Tura ni yapiin nukuku asa pengké wainmatsui, tu nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS10_12","020_10_12","PSA","10","12","12","Apuru wajakim uwejem yakí takuim ami aintsrum ainau ayamrukta. Tura aints wait wajainauka kajinmakiip. ");
INSERT INTO acuNT_vpl VALUES ("PS10_13","020_10_13","PSA","10","13","13","Yusru ¿warukaya pasé aints ainau amin pachitmasar pasé chichainawa? ¿Waruka ningki nintimsar: Yuska pachitmatsji tumaminawa? ");
INSERT INTO acuNT_vpl VALUES ("PS10_14","020_10_14","PSA","10","14","14","Antsu ameka nu aints ainau pasé turamuri wainkau asam, nekasam ni wait wajaktintri suwitme. Tura asakmin ayamrumichu ainauka aminak eatminawai. Tura mitaik ainau yainmeka ametme. ");
INSERT INTO acuNT_vpl VALUES ("PS10_15","020_10_15","PSA","10","15","15","Ame pasé aints ainau kakarmari nepetkata. Tura ni anumkar tunau turamurin pachisar mash uutsuk ujatkarti tusam chicharkata. ");
INSERT INTO acuNT_vpl VALUES ("PS10_16","020_10_16","PSA","10","16","16","Apuru ii Yusri asam, aints ainautin tuke inakratnuitme. Tura asam amin umirtamkacharu ainau tuke ninu nungkarinia jiiktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS10_17","020_10_17","PSA","10","17","17","Apuru mianchau ainau seamuri antu weame. Tura ni untsumauri antukam, pengker nintimtakum yayaame. ");
INSERT INTO acuNT_vpl VALUES ("PS10_18","020_10_18","PSA","10","18","18","Apuru mitaik wait wajainausha ayamrukta. Tura aints ainau nungka najanamu asaramtai, chikich ainaun waitkawarai tusam suritkata. ");
INSERT INTO acuNT_vpl VALUES ("PS11_1","020_11_1","PSA","11","1","1","Wikia Apurun wina ayamrutkati tusan seajai. Antsu chikich aints ainau wina chichartinak: “Ame nanamtinua nunismek muranam tupikiakta”, turutina nunaka pachiatsjai. ");
INSERT INTO acuNT_vpl VALUES ("PS11_2","020_11_2","PSA","11","2","2","Pasé aints ainau jiakuk ataram. Nuka anumkar tishimkun achikiar, tura wachin kunkar, kuntinun maawartas tias akupinawa nunisarang nu pasé aints ainau anumkar pengker nintintin ainaun mainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS11_3","020_11_3","PSA","11","3","3","Aints ainau umirkatin chichaman umitsuk pujuinamtaikia, ¿tunaarinchau ainausha warukawartinki? ");
INSERT INTO acuNT_vpl VALUES ("PS11_4","020_11_4","PSA","11","4","4","Antsu Yuska ni jeen nekas pengkernum pujawai. Ni keemtairi nayaimpinam puusamuitai. Tura nuni keemas aints ainaun mash jiij pujurui. ");
INSERT INTO acuNT_vpl VALUES ("PS11_5","020_11_5","PSA","11","5","5","Yuska pengke aints ainauncha tura pasé aints ainauncha wainui. Antsu mangkartutan wakerin ainaun pengké nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PS11_6","020_11_6","PSA","11","6","6","Yus pasé ainaun ni tunau turamurijai metek ni wait wajaktintri tu ati tusa, kaii azufrejai jijai pachimramun yakiiyan akuptuktinuitai. Tura nase tsuweran akupkamtai, mash aints ainauncha keemaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS11_7","020_11_7","PSA","11","7","7","Yus nekas tunaarinchau asa, tunaarinchau ainaun aneawai. Tura asamtai pengke nintintin ainau ni yapiin wainkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS12_1","020_12_1","PSA","12","1","1","Apuru aints pengker nintinuka ayá atsuinawai. Tura amin nintimturmasar pujuinauka pengké atsau asamtai uwemtikiartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS12_2","020_12_2","PSA","12","2","2","Pasé aints ainauka tsanumin ainawai. Tura chikichan pengker chicharinayat jimia nintijai chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS12_3","020_12_3","PSA","12","3","3","Apuru jimiá nintijai chichau ainauka turasha ningki nintimtumasar: Miajuitjai tumamin ainauka ame utsangta. ");
INSERT INTO acuNT_vpl VALUES ("PS12_4","020_12_4","PSA","12","4","4","Nu aints ainauka ningki nintimtumasar: ¿Ii jangkengka iinuchukai? Ii jangkejaingkia aints ainau nepetkatatji. ¿Yáki iincha inatmartascha wakerit? tumaminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS12_5","020_12_5","PSA","12","5","5","Tura asamtai Yus chichaak: “Kakaichu ainau wait wajainawai. Tura kuikiartichu ainau yuuminau asar, mayairukar napchau nintiminawai. Antsu wikia yamaikia timiá wait wajainaun yaingtatjai”, tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS12_6","020_12_6","PSA","12","6","6","Yuse chichamengka tsuwatchau asar, nekasar pengker ainawai. Jiru kuik pengké pakuichau ati tusar, ji tsutsakunam siete tseerar kuukar minaramtai, pakuichaun juwina nunisarang Yuse chichamengka nekasar pengker ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS12_7","020_12_7","PSA","12","7","7","Apuru iinka waikratkatnuitme. Tura tunau ainau iincha pasé awajtamsarai tusam iinka tuke ayamkartuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS12_8","020_12_8","PSA","12","8","8","Pasé takau ainau pachitsuk pengke aints ainaun tentakar wekainawai. Tura mash ni pasé turamurin pachisar pengkeraitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS13_1","020_13_1","PSA","13","1","1","Apuru ¿waruka winasha nintimrutsume? ¿Winaka tuke kajinmatruktatmek? ¿Waruka anumrutkamsha pujame? ");
INSERT INTO acuNT_vpl VALUES ("PS13_2","020_13_2","PSA","13","2","2","Wina nintirka kintajai metek najamrutawai. Wina nemasur wina itit awajtamurin warutik inaitusat tusan kintajai metek wake mesekan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS13_3","020_13_3","PSA","13","3","3","Apuru wina Yusur asam jiirsam airkata. Turam jakai tusam nintir paan nintimtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS13_4","020_13_4","PSA","13","4","4","Wi mianchau wajamtai, wina nemasur ainau warasarai tusam surimrukta. Turakmin wi nepetkajai turutcharti. ");
INSERT INTO acuNT_vpl VALUES ("PS13_5","020_13_5","PSA","13","5","5","Ami anengkratairmin nintimsan wikia pengkerapita tajame. Wina uwemtikruru asakmin, wina nintirjai waraajai. ");
INSERT INTO acuNT_vpl VALUES ("PS13_6","020_13_6","PSA","13","6","6","Apuru wina pengker awajtusu asakmin amin kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS14_1","020_14_1","PSA","14","1","1","Aints nintinchau ainauka: Yuska atsawai tinawai. Mash pasé nintimin ainawai. Tura mash natsanpiaku aa nuna turin ainawai. Turasha aints pengkeran turin kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_2","020_14_2","PSA","14","2","2","Nayaimpinam pujus Yuska: Aints pengker nintintin ainatsuash, tura winasha: Ameketme juuntam turutinatsuash tusa jiiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_3","020_14_3","PSA","14","3","3","Antsu mash tunau jintan amakar wekain armiayi. Mash metek natsanpiaku ainia nuna turin armiayi. Tura asamtai aints pengkeran turinka kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_4","020_14_4","PSA","14","4","4","Pasé takau ainauka paanka nintiminatsui. Antsu pangkan yuwina nunisarang wina aintsur ainaun amuinawai. Tura winasha seatchau ainawai, Yus tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_5","020_14_5","PSA","14","5","5","Antsu Yus ni chichamen umirkaru ainaujai pujau asamtai, nu pasé ainauka nuna wainkar shaminak nukap kurarartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_6","020_14_6","PSA","14","6","6","Nu pasé aints ainauka mianchau ainau chichamen pachisar wishikinawai. Antsu Yus nu aints ainaun ningki ayamrawai. ");
INSERT INTO acuNT_vpl VALUES ("PS14_7","020_14_7","PSA","14","7","7","Wikia Israel ainauti uwemtikramratin Jerusalénka murarinia tati tusan Yusen seajai. Tura ni aintsri ainautin uwemtikramramtai, Israel ainautikia mash warasartin ainiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS15_1","020_15_1","PSA","15","1","1","Apuru ¿ya aints ainawa amijaisha pujusartincha ainawa? ¿Ya aints ainawa ami murarmin pengker aa nunisha matsamsartincha ainawa? ");
INSERT INTO acuNT_vpl VALUES ("PS15_2","020_15_2","PSA","15","2","2","Aints amijai pujusartinka nu ainawai: Amin miatrusarang umirtamkaru ainia nu, tura pengkeran takau ainia nusha, tura tuke nintijai waitrutsuk chichau ainia nu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS15_3","020_15_3","PSA","15","3","3","Tura chikichan pachisar pasé chicharinachu, tura nijai tsaniasar pujuinaun pasé awajinachu, tura ni irutkamurin inatsarchau ainia nuka nu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS15_4","020_15_4","PSA","15","4","4","Yus nakita nuna nu aints ainauka nakitin ainawai. Antsu Yusen umirinaunka pengker awajin ainawai. Tura wi turatatjai tina nunasha yuuminayat mash timiatrusarang umiinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS15_5","020_15_5","PSA","15","5","5","Tura kuikiarin chikich ainaun suinak: Tumashnum akirkum nuna nangkamasmek nukap akirkata tinatsui. Tura chikich aintsun tsanuminak, amesha nunismek chichasta tusar, kuikian susatasar wakerinamtaikia: Tsa, nunaka turashtatjai tinawai. Aints tu pujuinauka tuke pengké natsaarchatin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_1","020_16_1","PSA","16","1","1","Yusru wina ayamrutkatin asakmin, waitkata tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS16_2","020_16_2","PSA","16","2","2","Wikia amin chicharkun: “Ametme wina Apur. Ame timiá pengkeraitme. Amijai metekka kichkisha atsawai”, timiajme. ");
INSERT INTO acuNT_vpl VALUES ("PS16_3","020_16_3","PSA","16","3","3","Ame wina chichartakum: “Wina aintsur ju nungkanam umirtukaru asar, pengker awajtu weenawai”, turutmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS16_4","020_16_4","PSA","16","4","4","Aints ainau Yuschau waininayat chikich yusen umirina nuka nukap wait wajakartin ainawai. Ni yusrin: Ameketme juuntam titasar tangkun mainamtaikia, wikia nuningkia pengké pachinkashtatjai. Tura ni yusri naarincha pengké inaikiashtatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_5","020_16_5","PSA","16","5","5","Apuru ameketme wina mash surustinmeka. Nekas pengker ainia nuka winaka nukap surusuitme. Wina pujutruka aminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_6","020_16_6","PSA","16","6","6","Yus wina pujutrun nekas pengker aa nunaka surusmiayi. Wi pujustiniun Yus surusmia nuka nekas shiirmaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_7","020_16_7","PSA","16","7","7","Yus: Tu pujusta tusa wina jintintrau asamtai, wikia Yusrun: Ameketme pengkeram titatjai. Tura asamtai kashisha Yus wina nintirun nintimtikrawai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_8","020_16_8","PSA","16","8","8","Wina Apurun tuke wijai pujaun wainuyajai. Niisha wina untsurunini pujurtau asamtai, wikia pengké mengkakashtatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_9","020_16_9","PSA","16","9","9","Tura wina nintirun pujurtau asamtai waraajai. Tura pengker nintimsan chichaaknasha warawarat chichaajai. Nunia nantaktinuapitja tau asan, jakancha pengker nintimsan ayamsatnuapitja tajai. ");
INSERT INTO acuNT_vpl VALUES ("PS16_10","020_16_10","PSA","16","10","10","Yusru wina wakantrusha jakatniunmaka ukurtuschatnuitme. Tura ami inatiram nekas pengker asamtai, ni namangkesha kaurti tusamka tsangkamrukchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS16_11","020_16_11","PSA","16","11","11","Tura jinta tuke iwiaaku pujustinnum jeatnuka inaktursatnuitme. Tura tuke wijai pujau asam waramtikrustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS17_1","020_17_1","PSA","17","1","1","Apuru wina chichamur nekas aa nu anturtukta. Tura wi untsuamka amesha airkata. Wikia waitrichu asamtai, wi seamur anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS17_2","020_17_2","PSA","17","2","2","Ame nekasam pengker aa nu nekau asam, wina tunaar amataikia, wait wajaktin surustasam wakerakmeka nusha turata. ");
INSERT INTO acuNT_vpl VALUES ("PS17_3","020_17_3","PSA","17","3","4","Wina nintimaur ainia nuka nekawaitme. Kashisha wina waitkatasam tarutnuyame. Tura tunaari atsuash tusam nekaprakmesha tunaaruka atsau waitnuyame. Chikich aints ainau chicham achamnaun chichaina nunisnaka chichachuyajai. Tura ami chichamem aarmaun umiakun, pasé aints ainau maanitan wakerin ainia nunisnaka turichuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS17_5","020_17_5","PSA","17","5","5","Ami jintim nekas aa nuni amaktinuyajai. Turasha aints ainau: Nu jintanmaka wekaatsuk asata, turutinau wainiatun pengké pachichuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS17_6","020_17_6","PSA","17","6","6","Yusru ame wina airkata tusan amin untsuajme. Wait aneasam wina chichamrusha anturtukam airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS17_7","020_17_7","PSA","17","7","7","Aints: Wina nemasur ainamunam ami kakarmarmijai winasha ayamrutkata turaminauka ami anengkratairum nekamtikiata. ");
INSERT INTO acuNT_vpl VALUES ("PS17_8","020_17_8","PSA","17","8","9","Aints ni jiin tenap wainina nunismek winasha waitkata. Turakum pasé aints ainau wina jiiru pujuinauka nepetkam waitkata. Wina nemasur ainau wina tentatkar mantuwartas wakerina nu nepetkam ayamtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS17_10","020_17_10","PSA","17","10","10","Nu aints ainauka pasé chichainawai. Tura ningki nintimtumasar: Wikia miajuitjai tumaminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS17_11","020_17_11","PSA","17","11","11","Tura wi wekaamtai arakchichu nemartinawai. Nunia nungká ujuarmi tusar nakarinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS17_12","020_17_12","PSA","17","12","12","Nu aints ainau juun yawaaya nunisarang ainawai. Tura juun yawaa kajewa nunisarang asar, anumkar ni nanchikijai kuntinun achikiartas nakainawa nunisarang aints ainaun nakainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS17_13","020_17_13","PSA","17","13","13","Apuru wajakim nu aints ainaujai ingkiunikiam tikishmamtikiawarta. Nu aints ainau nepetkarai tusam, ami nangkirmijai papeekam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS17_14","020_17_14","PSA","17","14","14","Apuru ami kakarmarmijai nu aints ainamunmaya angkanmamtikruata. Nu aints ainauka ju nungkanam ainia nuna wakerinak nunak nintimtinawai. Tura asaramtai kuikiartin wajasarti, tura ni uchiri yutan yuwinak ampuje pujakarti, tura ni tirangki ainausha ni ampirmaurin yuwaarti tusam tsangkatkata. ");
INSERT INTO acuNT_vpl VALUES ("PS17_15","020_17_15","PSA","17","15","15","Antsu wikia nekasan yapimin wainkatasan wakerajai. Tura kintajai metek shintaran amijai ingkiunikian nekasan maaketai titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_1","020_18_1","PSA","18","1","1","Apuru wina kakarmarka ametme. Tura asakmin wikia aneajme. ");
INSERT INTO acuNT_vpl VALUES ("PS18_2","020_18_2","PSA","18","2","2","Ametme wina ayamtikrurtin. Ametme wina uwemtikrurtin. Ametme wina angkanmamtikruatin. Ametme wina Yusur. Ameka pampa muchkachminua tumawaitme. Tura asakmin amin jean ayamsamnawaitjai. Ameka tantaara tumawaitme. Tura asam ami kakarmarmijai wina uwemtikrurtinuitme. Ame mash ainia nu nangkakau asam, wina ejarkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS18_3","020_18_3","PSA","18","3","3","Apuru amin mash aints ainau: Ameketme juuntam turamiartinuitai. Wina nemasur wininamtai, wi amin untsuam uwemtikrame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_4","020_18_4","PSA","18","4","4","Mangkartin ainau timiá untsuri wina mantuwartas winitrinamtai, wikia jakatatjapi tusan shamkamiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_5","020_18_5","PSA","18","5","5","Jata achirkawa nunisnak, tura kuntin ejatkanam achikmawa nunisnak nekapmamramiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_6","020_18_6","PSA","18","6","6","Tura timiá shamakun Apurun: Yainkata tusan untsukmiajai. Tura ni pujamurinia wina Yusur untsumaurun anturtukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_7","020_18_7","PSA","18","7","7","Wi turamtai nungka kakar uurkamiayi. Tura uurmatai mura ainau kakarman muchitkarmiayi. Yus pasé aints ainaun kajerkau asa nungkan muchkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_8","020_18_8","PSA","18","8","8","Ni nujinia mukunit shamai jiinua tumauyayi. Tura ni jangkenia ji kairia nunisang meskartin jiinua tumauyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_9","020_18_9","PSA","18","9","9","Nayaimpinam pujuutiat Yus kuanki mukunit shuwinnum wajawa tumauyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_10","020_18_10","PSA","18","10","10","Tura ni awemamuri querubínnum keemas Yus nanamua tumauyayi. Tura querubínkia nanapejai nasenam pachinak nanaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_11","020_18_11","PSA","18","11","11","Tura mukunit shuwinnum yumi jiturtas kajintramunam Yus anumkawa tumauyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_12","020_18_12","PSA","18","12","12","Turasha Yus ni pujutirin keemas charim kakar etsantua tumauyayi. Turamtai mukuntiunmaya micha kaya tumau ji kairi ainaujai pachimramu kakeerarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_13","020_18_13","PSA","18","13","13","Yus nayaimpinam puja nu ipiamtajai ni chichaamurin antumtikiamiayi. Turamtai mukuntiunmaya micha kaya tumau ji kairi keemakmau ainaujai kakeerarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_14","020_18_14","PSA","18","14","14","Tura chaarim nangkia tumau ayaararti tusa akupkamiayi. Turamtai wina nemasur ainauka shaminak atu atu tupikiararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_15","020_18_15","PSA","18","15","15","Yus kakar chichaak nasen timiá kakarman umpumtikiam, juun entsa kunari warukuita tusa paan wainmamtikiamiayi. Turasha juun entsa nitkarinini nungka paan amiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_16","020_18_16","PSA","18","16","16","Nunia Yus nayaimpinam pujus tsuntsuma aints juun entsanam jakenaun achikiar juwina nunisang ni uwejen kutsmar wina achirak nemasur ainamunmaya uwemtikrurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_17","020_18_17","PSA","18","17","17","Tura nemasur ainauka timiá kakaram armia nuka wina kajertukar pujuinamunmaya uwemtikrurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_18","020_18_18","PSA","18","18","18","Wina nemasur ainau nepetukartas wakerinamtai, pengké uwemrachmin pujai, Apurka winaka yainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_19","020_18_19","PSA","18","19","19","Tura angkanmamtikruamiayi, tura wina anentu asa Yus uwemtikrurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_20","020_18_20","PSA","18","20","21","Wikia Yusrunka pengké ukukchamiajai. Tura Yusnaka umirtan nakitajai pengké tichauyajai. Wi pengker pujau asan, tura Yuse jintin amaku asamtai, Apur winaka pengker awajtusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_22","020_18_22","PSA","18","22","22","Ni umirkatin chichamnasha kajinmichuitjai. Tura nu chichamnasha pengké inaisachuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_23","020_18_23","PSA","18","23","23","Tura nekasan Yusen nintimsan tuke pengker pujuyajai. Tura asan tunaunaka nakitnuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_24","020_18_24","PSA","18","24","24","Wi Yusen nintimsan pengker pujau asamtai, winaka pengker awajtusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_25","020_18_25","PSA","18","25","25","Apuru amin umirtaminauka amesha ajapamka ukuatsme. Tura amin pengker awajtaminak pujuinauka amesha pengker awajme. ");
INSERT INTO acuNT_vpl VALUES ("PS18_26","020_18_26","PSA","18","26","26","Tura ame pengké anangkartichu asam, anangkartichu ainauka tuke yayaame. Antsu anangkartin ainau aminu nekamtairumjai nepeteame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_27","020_18_27","PSA","18","27","27","Ameka mianchau ainau uwemtikratnuitme. Antsu wikia miajuitjai tumamin ainau mianchau arti tusam inatsaartinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS18_28","020_18_28","PSA","18","28","28","Apuru ame ji kapawa nunisketme. Yusru wikia itiurkachminum pujamtai, winaka paan nintimtikrurtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS18_29","020_18_29","PSA","18","29","29","Tura asakmin ami yaimkemjai wina nemasur ainaun nepetkatnuitjai. Tura ni yaktari wenurmau wainiatnak wayaatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_30","020_18_30","PSA","18","30","30","Yuse jintingkia nekas pengkeraitai. Yuse chichamengka nekas waitchau ainawai. Aints ainau niin nekasampita tusar nintiminaunka Yus ejaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_31","020_18_31","PSA","18","31","31","¿Chikich yus iin ayamrutmaktincha awak? Atsa, chikich yuska ii Apurijai metekka pengké atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_32","020_18_32","PSA","18","32","32","Wina kakarmarun surustinka Yusketai. Wina pujutru iwiasmatrukchatnuka nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_33","020_18_33","PSA","18","33","33","Japa tsekengki wekaawa nunisang wina kakamtikrurtinka Yusketai. Tura mura wakancha ayaatsuk wekaamtikrustinka nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_34","020_18_34","PSA","18","34","34","Wi mesetnum weamtai: Tu maaniata tusa wina jintintruatnuka Yusketai. Tura kunturun kakamtikrurtincha nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_35","020_18_35","PSA","18","35","35","Yusru ame wina uwemtikrinuyame. Tura untsur uwejmijai wina inantinuyame. Tura wait anentruram wina pengker awajtinuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_36","020_18_36","PSA","18","36","36","Wi wekaamtai angkan wekaasata tusam waitkamiame. Turasha nungkanam ayaaraim tusam nawer kakamtikrurume. ");
INSERT INTO acuNT_vpl VALUES ("PS18_37","020_18_37","PSA","18","37","37","Tura asakmin wina nemasur ainaun papeekan amankiamiajai. Tura mash amukan waketkimiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_38","020_18_38","PSA","18","38","38","Niin charukarmau asar pengké nantakcharmiayi. Antsu wina nawerun ayaamsar ayaararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_39","020_18_39","PSA","18","39","39","Yusru wi mesetnum weamtai ame kakamtikrurmiame. Tura asakmin wina umirtutan nakitin ainau wina tsuntsumrutawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_40","020_18_40","PSA","18","40","40","Wina nemasur ainau winiangka tupikiakiarti tusam tsangkamkamiame. Nu tsangkamkau asakmin, wina kajertin ainaun amukmiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_41","020_18_41","PSA","18","41","41","Ayamrutkata tinamaitiatang, aints kichkisha ayamrukcharmiayi. Tura Yusnasha untsuinamaitiat niisha aikchamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_42","020_18_42","PSA","18","42","42","Tura asamtai wikia nase umpuak nungka tsetserin juwawa nunisnak nu aints ainaun nepetkan turan nungka mirachia nunisnak najarmiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_43","020_18_43","PSA","18","43","43","Tura asamtai ame Apuru nu aints amin umirtamchau ainamunmaya uwemtikrurmiame. Tura nu nungkanmaya ainau apuri ati tusam inaitukmiame. Tura asakmin wainchati aints ainauka wina inatir ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_44","020_18_44","PSA","18","44","44","Turasha wina chichamrun antukar umirtinawai. Tura chikich nungkanmaya ainausha wina pengker awajtinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_45","020_18_45","PSA","18","45","45","Nu aints ainauka sapijminawai. Tura kurainak ni anumkamurinia jiininawai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_46","020_18_46","PSA","18","46","46","Ii Apuringkia tuke pujuuwitai. Iin Ayamtikiartin asa, timiá pengkeraitai tajai. Turasha wina Yusur wina uwemtikrurtin asamtai, ameketme juuntam tajai. ");
INSERT INTO acuNT_vpl VALUES ("PS18_47","020_18_47","PSA","18","47","47","Yus chikich nungkanmaya ainaun nepetkau asa, wina nemasur ainaunka yapaijkiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS18_48","020_18_48","PSA","18","48","48","Wina nemasur ainau kajertinamunmaya Yus wina uwemtikrurmiayi. Tura chichaman umichu ainau wina nepetukartas wakerutiarmia nu aintsnumia ayamtikrurmiayi. Ame Apuru mangkartin ainamunmaya tuke uwemtikrame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_49","020_18_49","PSA","18","49","49","Tura asakmin mash nungkanmaya ainau iruntramunam amin: Ameketme juuntam tajame. Tura amin naarmin pachisan kantan kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS18_50","020_18_50","PSA","18","50","50","Ame apu ata tusam wina inaituku asam, wina nemasur ainau nepetkata tusam kakamtikrinuyame. Tura asam winasha tura wina wear ainausha tuke ami anengkratairumjai pengker awajnuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS19_1","020_19_1","PSA","19","1","1","Nayaim jiisar Yuse kakarmari paan nekaamnawaitji. Tura nayaim jiisar, Yus najanamu pengkeraitai titinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS19_2","020_19_2","PSA","19","2","2","Kashincha kashincha tsawaarkur Yus juuntaitai titinuitji. Tura kashincha kashincha kintamkur Yus kakarmaitai titinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS19_3","020_19_3","PSA","19","3","4","Chichamengka anturchayatrik, Yus ni najanamuri mash nungkanam nekamtikiamu asar, mash nungkanmaya ainausha nuna wainkar antukarminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_5","020_19_5","PSA","19","5","5","Nayaimpinam Yus tsaanka puusamiayi. Aints yamai nuwan nuwatak ni kanutirinia nantawa nunisang tsaangka kashik taakui. Tura aints kakaram ni nemase ainaun nepetkatas ni pujutirinia jiinua nunisang tsaangka jiinui. ");
INSERT INTO acuNT_vpl VALUES ("PS19_6","020_19_6","PSA","19","6","6","Tsaangka yakí waka nunia ataksha jeawai. Tura tsaa timiá tsuwer asamtai, pengké anumkachminuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS19_7","020_19_7","PSA","19","7","7","Yus iin nuitamramuka nekas pengkeraitai. Tura asa pujut yamarman suramsatnuitji. Yus chichaman akupa nuka nekasaintai. Tura asa nekachu ainaun nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_8","020_19_8","PSA","19","8","8","Yus turataram ta nuka pengkeraitai. Tura asamtai nu chichaman antukaru ainauka nuna nintimsar warainawai. Yuse chichamengka pengker asa, aints ainaun paan nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_9","020_19_9","PSA","19","9","9","Yus umirmauka nekas pengkeraitai. Tura ni chichamengka tuke nangkankashtin asamtai, Yus umirtuktaram ta nuka nekas pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_10","020_19_10","PSA","19","10","10","Yuse chichamengka kuri nangkamasang timiá pengkeraitai. Tura wapasa nangkamasang timiá pengker asamtai nukap wakeruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_11","020_19_11","PSA","19","11","11","Wikia ami inatiram asan, ami chichamin nekaan, tunaachawa nunisnak pujustasan wakerajai. Tura nu chichaman umirkanka, pengker pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_12","020_19_12","PSA","19","12","12","Aints ningki nintimsangka ni tunaarinka nekaachminuitai. Apuru wi nekachu asan, nuwakan tunaun turinuyaja nuka tsangkutrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS19_13","020_19_13","PSA","19","13","13","Tura ami inatiram asamtai, wikia miajuitjai tutairuka jurutkita. Nu tunaun wakerutsuk pujusat tusam jurutrukin asakmin, wikia juun tunau ayatnak tunaarinchau wajastinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS19_14","020_19_14","PSA","19","14","14","Apuru wina ayamrutkatin asam, tura wina uwemtikrurtin asam, wina chichamur tura wina nintimtair nekas pengker arti tusam nintimtikrurta tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS20_1","020_20_1","PSA","20","1","1","Ame wait wajakmeka Apuram amin anturtamkati. Tura Jacobo Yusri amincha ayamrutmakti. ");
INSERT INTO acuNT_vpl VALUES ("PS20_2","020_20_2","PSA","20","2","2","Tura Yus ni pujamurinian amincha yainmakti, tura Jerusalénnumian amincha kakamtikramrati. ");
INSERT INTO acuNT_vpl VALUES ("PS20_3","020_20_3","PSA","20","3","3","Ame kuikiaram Yus susamame nunaka mash kajinmatsuk aneaku ati. Tura tangku maam epeyame nunasha pachis: Pengkeraitai turamti. ");
INSERT INTO acuNT_vpl VALUES ("PS20_4","020_20_4","PSA","20","4","4","Ame wakerame nunaka Yus mash suramsati. Tura ame: Wikia turatasan wakerajai tame nunasha mash umikta tusa tsangkatramkati. ");
INSERT INTO acuNT_vpl VALUES ("PS20_5","020_20_5","PSA","20","5","5","Ami nemasem ainaun nepetkakmin iisha nu wainkar warastatji. Tura ii Yusri naari nintimsar ii banderari yakí takuitatji. Ami Yusrum seame nunaka mash metek umikti tusar seajai. ");
INSERT INTO acuNT_vpl VALUES ("PS20_6","020_20_6","PSA","20","6","6","Yus ningki amin ni kakarmarin susa apu inaikiau asa, ni nemase ainaun nepetkatniun tsangkatkatatui, tura ame seame nuna antuk Yus nayaimpinmaya airmaktatui tusan nekajai. ");
INSERT INTO acuNT_vpl VALUES ("PS20_7","020_20_7","PSA","20","7","7","Chikich aints ainauka mesetnum weenak: Ii wekaatai ainaujai ii nemase nepetkatatji tu nintiminawai. Antsu iikia Yuse kakarmarijai ii nemase ainau nepetkakatatji tu nintimsar pujaji. ");
INSERT INTO acuNT_vpl VALUES ("PS20_8","020_20_8","PSA","20","8","8","Chikich ainauka tikishin ninukar iyainawai. Antsu Yus iijai pujau asamtai, iikia tuke ayaatsuk wajaji. ");
INSERT INTO acuNT_vpl VALUES ("PS20_9","020_20_9","PSA","20","9","9","Yusru ame apu inaikiamuram ni nemase ainau nepetkati tusam tsangkatkata. Wait aneasam ii untsumkurin aikratkata tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS21_1","020_21_1","PSA","21","1","2","Yusru ame apu kakamtikramu asa, apuka pengker nintimias pujawai. Tura ni nemase nepetkau asakmin nekas waraawai. Tura ni wakeramuri mash umikume. Tura amin seatmausha suritkachume. ");
INSERT INTO acuNT_vpl VALUES ("PS21_3","020_21_3","PSA","21","3","3","Tura apu nekasam pengker awajnuyame. Tura tsengkruti kuri najanamu tsengkrukti tusam tsangkatkamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS21_4","020_21_4","PSA","21","4","4","Apu amin untsuri musach pujustasan wakerajai tusa seatmimiayi. Turamtai untsuri musach pujusti tusam tsangakatkamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS21_5","020_21_5","PSA","21","5","5","Yusru ame apu yaingmau asa nekas kakarmaitai. Tura niin pengker awajsamu asa, nekas ni aintsri ainaun pengker inawai. ");
INSERT INTO acuNT_vpl VALUES ("PS21_6","020_21_6","PSA","21","6","6","Tura ni tuke yaingku asam, ame nijai pujusam waramtiknuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS21_7","020_21_7","PSA","21","7","7","Apu amin umirtamkau asamtai, amesha ni ajapamka ukukchatnuitme. Tura ame nayaimpinam pujau asakmin, ami anengkratairmin nintimias pujawai. ");
INSERT INTO acuNT_vpl VALUES ("PS21_8","020_21_8","PSA","21","8","8","Ami nemasem ainauka ami kakarmarmijai nepetkamnawaitme. Turasha amin kajertaminak pujuinauka ami untsur uwejmijai nepetkamnawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS21_9","020_21_9","PSA","21","9","9","Tura ami nemasem ainau nepetkam, ni tunaarijai metek wait wajakarti tusam, ji kapaamunam engkeatnuitme. Ame turakmin nu aints ainauka ji timiá tsuwernum amukartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS21_10","020_21_10","PSA","21","10","10","Nu aints ainau uchiri tura ni weari ainausha mash amuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS21_11","020_21_11","PSA","21","11","12","Tura tupikiakiarti tusam, ami tishimkurmijai nu aints ainau awaakau asakmin, amin pasé awajtamsartas wakerinayat, turasha iisha turami tusar chichaman najanawariat, nuna turatatkamawar tujinkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS21_13","020_21_13","PSA","21","13","13","Yusru wajakim amin kajertamin ainau ami kakarmarmijai nepetkau ata. Ame nu aints ainau nepetkakminkia kanta kantamatatji. ");
INSERT INTO acuNT_vpl VALUES ("PS22_1","020_22_1","PSA","22","1","1","Yusru Yusru ¿waruka ajapruamsha ukurme? ¿Waruka uwemtikrurtasam winatsme? ¿Waruka wi juutmaursha pachiatsme? ");
INSERT INTO acuNT_vpl VALUES ("PS22_2","020_22_2","PSA","22","2","2","Yusru tsawaisha tura kashisha amin untsuamsha airu weatsme. Tura asakmin ayamsatatkaman tujintajai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_3","020_22_3","PSA","22","3","3","Antsu ameka pengkeraitme. Ameka Israel ainau inawaitme. Tura asakmin Israel ainau amincha: Ameketme juuntam turaminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_4","020_22_4","PSA","22","4","4","Ii juuntri ainauka amincha: Nekasampitme tusar nintimturmin armiayi. Tura asaramtai ameka ni angkanmamtiknuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS22_5","020_22_5","PSA","22","5","5","Amincha yainkata tusar seatminamtai angkan pujusarti tusam yaingmiame. Amin nekasampita tusar nintimraru asaramtai, ameka ni ajapamka ukuchuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS22_6","020_22_6","PSA","22","6","6","Antsu wikia aintsua tumauchuitjai, antsu maachia tumau asan kakaichuitjai. Tura asamtai aints ainau wina wishikrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_7","020_22_7","PSA","22","7","7","Tura wina waitkar muuken pearar etserar wishikrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_8","020_22_8","PSA","22","8","8","Tura chichainak: “Yusnaka nekas nintimtinuyayi. Watska Yus niin angkanmamtikiati. Yus niin aneakka nekas uwemtikrati” tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_9","020_22_9","PSA","22","9","9","Antsu wina pachitsam: Ni nukuri ampujenia akiinati, tura ni nukuri muntsuri muntsati tusam, nuni nangkamsamek winaka waitnuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS22_10","020_22_10","PSA","22","10","10","Wi akiintsaing ameka winaka waitnuyame. Tura wina nukuru ampujen pujaisha tuke wina Yusruyame. ");
INSERT INTO acuNT_vpl VALUES ("PS22_11","020_22_11","PSA","22","11","11","Wina waitkarawartin ainauka arakchichu wajainawai. Tura wina yainkatnuka atsawai. Tura asamtai wait aneasam winaka ajapruamka ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS22_12","020_22_12","PSA","22","12","12","Basan nungkanmaya waaka aishmangkri nekas kajeu ainia nunisarang wina nemasur ainau tentatkar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_13","020_22_13","PSA","22","13","13","Juun yawaa kajeu kuntinun yuwatas winawa nunisarang wina nemasur ainausha winitrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_14","020_22_14","PSA","22","14","14","Wikia yumi nungkanam ukarmawa nunisketjai. Tura wina ukunchruka kuitkamua nunisarang ainawai. Tura macha tseeram yumia tumau wajawa nunisang wina nintirka kakarchamin nekapeawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_15","020_22_15","PSA","22","15","15","Wina suwerka nungka tsetseria nunisang mujuawai. Tura inairusha muchikchamin mayatairun nepeturkayi. Tura nungka tsetserin engketamua nunisnak wikia jakamin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_16","020_22_16","PSA","22","16","16","Pasé aints iruntrar yawaaya nunisarang wina jiinkichmin tententawaru asaramtai, wina uwejruncha tura nawernasha chingkiarawarua nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_17","020_22_17","PSA","22","17","17","Wina ukunchur ainauncha nekapmarminuitjai. Tura asamtai wina kajertin ainauka tuke jiiru pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_18","020_22_18","PSA","22","18","18","Tura yáki entsatiri jukit tusar suerte nakurusar, wina entsatirun jurutkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS22_19","020_22_19","PSA","22","19","19","Antsu ametme wina kakamtikrurtin. ¡Yusru ukurkiip! ¡Wina yainkatin asam wári tarata! ");
INSERT INTO acuNT_vpl VALUES ("PS22_20","020_22_20","PSA","22","20","20","Wina kajertin ainauka ni nangkirijai maawarai tusam uwemtikrurta. Tura yawaaya nunisarang maawarai tusam surimrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS22_21","020_22_21","PSA","22","21","21","Nuka juun yawaaya nunisarang asaramtai, nu aints ainamunmaya uwemtikrurta. Tura waaka aishmangkri kajeu ni pupuntrijai aintsun maamnawa nunisarang asaramtai, nu aints ainamunmaya ayamrutkata. ");
INSERT INTO acuNT_vpl VALUES ("PS22_22","020_22_22","PSA","22","22","22","Ame turakminkia wina yatsur ainaun amin pachisan ujaktinuitjai. Tura amin umirtamkaru ainaujai iruntran kantan kantamruatnuitjame. ");
INSERT INTO acuNT_vpl VALUES ("PS22_23","020_22_23","PSA","22","23","24","Aints mianchau ainau wait wajainau asaramtai, Yuska ukutsuk wait anentawai. Tura ni yainkata tusar untsumaurincha anturui. Tura asamtai Jacobo weari ainautiram, Yus nintimtau asaram: Ameketme juuntam titaram. Tura ameketme Apum titaram. Tura Israela weari asaram: Ameketme ii Yusrim titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS22_25","020_22_25","PSA","22","25","25","Yusru aints untsuri amin umirtaminak pujuinamunam wikia amin pachisan: Ami chichammin nekasam umikume titatjai. Amin ameketme juuntam turamin ainamunam wi turatatjai timiaja nunaka umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_26","020_22_26","PSA","22","26","26","Wait wajau ainautiram, nukap yuwaram atumsha tutuartaram. Tura Yus eautiram Yus: Ameketme juuntam titaram. Turaram nukap musach pujustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS22_27","020_22_27","PSA","22","27","27","Mash nungkanmaya ainautiram, tura niish niish chichau ainautiram, Yus kajinmatsuk nintimraram ni seatasrum tikishmatrataram. ");
INSERT INTO acuNT_vpl VALUES ("PS22_28","020_22_28","PSA","22","28","28","Ii Yusri mash nungkanmaya ainau Apuri asa, mash aints ainaun inawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_29","020_22_29","PSA","22","29","29","Yamaikia yuumatsuk pujuinautirmincha tajarme: Atumkeka iwiaakuka pujuschamnawaitrume. Antsu jakaram nungka tsetseri najanartinuitrume. Tura asaram atumsha tsuntsumaram: Yus ningki mash aints ainau Apurintai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS22_30","020_22_30","PSA","22","30","30","Wi wear ainau Yusen ameketme juuntam tiartin ainawai. Tura iwiaaku pujuinauka tuke niin pachisar chichasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS22_31","020_22_31","PSA","22","31","31","Tura ukunam akiinatin ainausha Yusen pachisar: Nekas pengker asa, ni aintsri ainaun uwemtiknuyayi tiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS23_1","020_23_1","PSA","23","1","1","Wina Apurka uwija wainua nunisang winaka waitui. Tura asamtai wisha yuumakchatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS23_2","020_23_2","PSA","23","2","2","Uwijan wainin ni uwijarin chirichrin yuwarat tusa weka wekaaka ayamsarti tusa, nunia mikinnum juwawa nunisang wina Apursha winasha ayamtikrurtinuitai. Tura yumin umurarat tusa, uwija wainin ni uwijarin entsa miaakunam juwawa nunisang wina Apurka yuumamurnasha surustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS23_3","020_23_3","PSA","23","3","3","Tura nintirnasha kakamtikrurtinuitai. Tura ni naarin pachisar: Yuska nekas juuntaitai tiarat tusa, nekas pengker jintanam wekaasat tusa winaka nintimtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS23_4","020_23_4","PSA","23","4","4","Apuru wijai tuke puju asam, uwijan wainin ni uwijarin ayamruktas numichin tura shukrutin takus naka wajawa nunismek winasha ayamrutkatasam waitkatnuitme. Tura asakmin jakatin ayatnak, tura wait wajaktin ayatnak shamkashtinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS23_5","020_23_5","PSA","23","5","5","Wina nemasur ainau jimia wajainai wainiatmek, ame pengker aa nu surusuitme. Tura apun inaikiartas olivo macharijai muuken ukatinawa nunismek winaka pengker awajtusuitme. Tura aints piningnum umutai yaraamun wainak waraawa nunismek nukap waramtikrustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS23_6","020_23_6","PSA","23","6","6","Ame wina pengker awajtusu asakmin, tura wait anengkratin asakmin, wikia iwiaaku pujaknaka nunaka tuke nintimsan pujustinuitjai. Tura wina Apur asakmin, jakancha tuke ami jeemin iwiaaku pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_1","020_24_1","PSA","24","1","2","Yus nungkan najanamiayi. Tura juun entsancha tura entsa kanaji ainauncha mash najanau asamtai, mash Yus najanamu ainauka Yusnau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_3","020_24_3","PSA","24","3","3","¿Yuse murarin wakartin ainau warí aintsuk ainia? ¿Turasha ni jeen pengker aa nuni pujusartin ainia nusha warí aintsuk ainia? ");
INSERT INTO acuNT_vpl VALUES ("PS24_4","020_24_4","PSA","24","4","4","Tunau takachu ainau, tura tunau nintimchau ainia nu Yuse pujutirin wayaawartin ainawai. Tura Yuschau waininayat, chikich yusen seachu ainau, tura nangkamiar anangminak: Wikia nunaka turatatjai tichau ainauk Yuse pujutirin wayaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_5","020_24_5","PSA","24","5","5","Nu aintsu Apuri ni Yusri asa, tura ni uwemtikrau asa, ni turamuri tu ainawai tusa nekawai. Tura asa ni turamurijai metek pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_6","020_24_6","PSA","24","6","6","Jacobo Yusri ni Apuri asamtai, niin eaina nuka tu pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_7","020_24_7","PSA","24","7","7","Tuke pujustinnum wayaatin waiti aa nuka uraitaram. Tura nuka epenchamu tuke atin asamtai, Inamin nekas pengker aa nuka wayaatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_8","020_24_8","PSA","24","8","8","¿Nu Inamin nekas pengker aa nusha yaachita? Nuka iinu Yusri kakaram aa nuwaitai. Nuka nekas iinu Yusrintai, nangkinam we ni nemase ainaunka shamchau aa nuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_9","020_24_9","PSA","24","9","9","Tuke pujustinnum wayaatin waiti aa nuka uraitaram. Tura nuka epenchamu tuke atin asamtai, Inamin nekas pengker aa nuka wayaatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS24_10","020_24_10","PSA","24","10","10","¿Nu Inamin nekas pengker aa nusha yaachita? Ii Apuri timiá kakaram aa nuwaitai. Inamin nekas pengker aa nuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS25_1","020_25_1","PSA","25","1","1","Apuru amin seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS25_2","020_25_2","PSA","25","2","2","Yusru amin nintimtajme. Tura asamtai wina nemasur ainau inatsturarai tura wishikrurarai tusam tsangkamrukaip. ");
INSERT INTO acuNT_vpl VALUES ("PS25_3","020_25_3","PSA","25","3","3","Tura amin nekasampita tinu ainaun kichkisha inatsararai tusam tsangkamkaip. Antsu amin umirtamchau ainauka natsararti tusam tsangkamkata. ");
INSERT INTO acuNT_vpl VALUES ("PS25_4","020_25_4","PSA","25","4","4","Apuru ami jintim inaktursata. Tura jintim wekaasata tusam jintintruata. ");
INSERT INTO acuNT_vpl VALUES ("PS25_5","020_25_5","PSA","25","5","5","Wina Yusur asam, tura wina Uwemtikrurtin asam, ami chichamim nekas aa nu nuiturta. Kintajai metek amin nintimtajme. ");
INSERT INTO acuNT_vpl VALUES ("PS25_6","020_25_6","PSA","25","6","6","Apuru ame tuke wait anengkratin asam, ame iin pengker awajkartusmauka kajinmakiip. ");
INSERT INTO acuNT_vpl VALUES ("PS25_7","020_25_7","PSA","25","7","7","Wi natsa asan, pasé turamiaja nuka nintimtsuk asata. Antsu nekasam wait anengkratin asam, tura pengker asam wina kajinmatrukiip. ");
INSERT INTO acuNT_vpl VALUES ("PS25_8","020_25_8","PSA","25","8","8","Ii Apuringkia pengkeraitai, tura nekas tunaarinchawaitai. Tura asa tunaarintin ainaun: Pengker pujustaram tusa chicharui. ");
INSERT INTO acuNT_vpl VALUES ("PS25_9","020_25_9","PSA","25","9","9","Tura jampechu ainaun: Juwaitai wina jintarka tusa inaktawai. Tura wina wakeramurka nuwaitai tusa nuikiartawai. ");
INSERT INTO acuNT_vpl VALUES ("PS25_10","020_25_10","PSA","25","10","10","Tura ni chichamen umirin ainaun Yuska tuke aneawai, tura nekas pengker awajui. ");
INSERT INTO acuNT_vpl VALUES ("PS25_11","020_25_11","PSA","25","11","11","Apuru wikia nekasan juun tunaawitjai. Tura asamtai tunaar tsangkutrurta. Amin naarmin pachisan Apuru seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS25_12","020_25_12","PSA","25","12","12","Aints Yusen umirak pujaunaka Yus: Ju jinta wekaasata tusa inaktawai, ");
INSERT INTO acuNT_vpl VALUES ("PS25_13","020_25_13","PSA","25","13","13","tura pengker awajui. Tura ni weari nu nungkanam pujuinauncha nu nungka ninu ati tusa suawai. ");
INSERT INTO acuNT_vpl VALUES ("PS25_14","020_25_14","PSA","25","14","14","Yus ni umirin ainautin amikrintai. Tura nu aints ainautin ni umiktin chichaman nintimtikramji. ");
INSERT INTO acuNT_vpl VALUES ("PS25_15","020_25_15","PSA","25","15","15","Wikia itiurkachmin pujamtaisha, wina Apurka tuke angkanmamtikrurtin asamtai, tuke niin nintimtusan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS25_16","020_25_16","PSA","25","16","16","Apuru wiki pujakun waitnasan pujaing wait aneasam jiirsata, turam wait anentrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS25_17","020_25_17","PSA","25","17","17","Wina nintirka waurkamin nekapeawai. Tura asamtai paan nintimrat tusam angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS25_18","020_25_18","PSA","25","18","18","Wi wake mesekmaurusha ame jiirsata, tura takatruncha yainkata. Turakum wina tunaar ainau tsangkutrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS25_19","020_25_19","PSA","25","19","19","Tura wina nemasur wina kajertinak mantuwartas wakerinau warutmak ainia tusam jiisarta. ");
INSERT INTO acuNT_vpl VALUES ("PS25_20","020_25_20","PSA","25","20","20","Apuru waitkata tura uwemtikrurta. Amin tuke nintimtajme. Tura asamtai wina inatsararai tusam surimrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS25_21","020_25_21","PSA","25","21","21","Apuru aminak nintimtau asan, wi amin umirkun tunaarinchau pujamtaikia winaka waitkata. ");
INSERT INTO acuNT_vpl VALUES ("PS25_22","020_25_22","PSA","25","22","22","Yusru itiurkachmin pujakrincha, Israel ainautinka tuke uwemtikiartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS26_1","020_26_1","PSA","26","1","1","Yusru wikia tunaarinchau pujau asamtai, wi itiur pujaja nusha nekarata. Apuru tuke aminak nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_2","020_26_2","PSA","26","2","2","Wi itiur pujaja tusam winasha nekaprutata. Tura wina nintimaur itiur ainawa tusam nekamtikruata. Tura wina nintirun nintimja nusha nekamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS26_3","020_26_3","PSA","26","3","3","Wikia aminu anengkratairumin pengké kajinmatsjai. Tura amincha tuke nintimnuyajme. ");
INSERT INTO acuNT_vpl VALUES ("PS26_4","020_26_4","PSA","26","4","4","Tura wait chichaman etserin ainaujaisha pengké pujuchuyajai. Tura mai nintim wajau ainaujaisha pengké iruntrachmiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_5","020_26_5","PSA","26","5","5","Pasé aints ainaujai iruntanka pengké nakitnuyajai. Tura amin umirtamtsuk pujuu ainaujaisha tsaningnasha pujuchuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_6","020_26_6","PSA","26","6","6","Wina uwejrujaingkia tunaanaka pengké takachuyajai. Apuru tu pujau asan amin: Ameketme juuntam titasan tangku epetinam jeatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_7","020_26_7","PSA","26","7","7","Tura amin: Ameketme pengkeram titasan kantan kantamruatasan wakerajme; tura ami turamurmincha etserkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_8","020_26_8","PSA","26","8","8","Apuru ami pujutiram nekas pengker aa nuna wikia aneajai. Ame paaniunam pujau asakmin, paaniurmincha wainkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_9","020_26_9","PSA","26","9","9","Wait aneasam, pasé aints ainaujai tsaniasam amesha jakata turutiip. Tura mangkartin ainau jainawa nunismek amesha jakata tusam pujutruka jurutkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS26_10","020_26_10","PSA","26","10","10","Nu aints ainauka nekasar tunaunaka tuke takainawai. Tura chikich ainaun kuikian suwinak: Ame nu aints pachisam wait chicham ujakta tinu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS26_11","020_26_11","PSA","26","11","11","Antsu nu aints ainau pasé turinamunka pengké turichuitjai. Tura asamtai wait aneasam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS26_12","020_26_12","PSA","26","12","12","Yusru wikia nungka yumpunkachminnum wajaina nunisnak amin tuke nintimsan pujajai. Tura amin umirtamin iruntramunam amincha: Ameketme pengkeram titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS27_1","020_27_1","PSA","27","1","1","Wina Apurka wina paantruitai. Tura wina uwemtikrurtinuitai. Tura asamtai ¿yanak shamkataj? Wina Apurka wina ayamrutkatin asamtai ¿warinak shamkataj? ");
INSERT INTO acuNT_vpl VALUES ("PS27_2","020_27_2","PSA","27","2","2","Pasé aints ainauka wina nakitruraru asar, wina mesturartas tura mantuwartas wakerutinawai. Turinayat tukumkar ayainawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_3","020_27_3","PSA","27","3","3","Suntar untsuri mesetan najanawartas kaunkar, wina tententawarun wainiatnak, wina nintirka kurarchatnuitai. Antsu angkan napchauka nintimtsuk pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_4","020_27_4","PSA","27","4","4","Wina Apurnaka kichkinak seayajai. Tura wi seayaja nuka nuwaitai: Iwiaaku pujaknaka wikia aints Yuse jeen pujawa nunisnak kintajai metek Yusen maaketai titasan, tura ni pengkerin wainkatasan tuke wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_5","020_27_5","PSA","27","5","5","Itiurkachminum pujamtaisha wina Apurka winaka ejarkatnuitai. Tura ni jeen jeamtaisha winaka pengker nintimtursatnuitai. Wina Apurka tuke pujú asa, pampa nunisketai. Tumau asamtai wikia Apurun nintimsan aints pampanam yakí wajawa nunisnak uwemran angkan pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_6","020_27_6","PSA","27","6","6","Tu nintimsan pujaknaka, wina nemasur ainau wina tententawaru wainiatnak shamtsuk pangkain jiistinuitjai. Tura asan Yuse jeen jean, Yusen maaketai titasan tangkun maan epeatnuitjai. Tura warasan wina Apurun kantan kantamruatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_7","020_27_7","PSA","27","7","7","Apuru amin untsuajme. Anturtukta. Wait anentruram airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS27_8","020_27_8","PSA","27","8","8","Apurun eaktaj tu nintimran, wikia nekasan wina nintirjai amin tuke eajme. ");
INSERT INTO acuNT_vpl VALUES ("PS27_9","020_27_9","PSA","27","9","9","Apuru wait aneasam anumrutkaip turasha kajertukaip. Ameketme wina yainkatnumka. Wina Yusur asam, tura wina uwemtikrurtin asam, ajapruam ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS27_10","020_27_10","PSA","27","10","10","Wina apar tura wina nukursha ukurkiaramtaisha, ame wina Apur asam, winaka ajapruamka pengké ukurkishtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS27_11","020_27_11","PSA","27","11","11","Apuru jintim inaktursata. Wina nemasur ainau eatinau asaramtai, jintim nekas pengker aa nuni wekaasata tusam nekaprutata. ");
INSERT INTO acuNT_vpl VALUES ("PS27_12","020_27_12","PSA","27","12","12","Tsanukratin ainau nangkamiar wina pachitsar wait chichaman chichartinau asaramtai, wina nemasur ainau ni wakeramurin najaninak, wina mesturarai tusam tsangkamrukaip. ");
INSERT INTO acuNT_vpl VALUES ("PS27_13","020_27_13","PSA","27","13","13","Antsu wikia iwiaaku pujaknaka, Apuru ami pengkeerumin nekasnapi wainkatnuitja tusan nekajai. ");
INSERT INTO acuNT_vpl VALUES ("PS27_14","020_27_14","PSA","27","14","14","Tura asan mash aints ainautirmin tajarme: Atumsha Apuram nintimtustaram. Tura kakartaram, turasha atsantrataram. Nekasan tajarme: Apuram nintimtustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS28_1","020_28_1","PSA","28","1","1","Yusru wina ayamrutkatin asakmin amin untsuajme. Tura wi untsuam airkata. Ame airtsuk pujakminkia, wikia yanchuk jakawa nunisnak nintimramnawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS28_2","020_28_2","PSA","28","2","2","Aminu jeem pengker aa nuni wina uwejrun Jerusalenumanini takuin amin: Yainkata tusan untsumkun pujai, wina untsummaur anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS28_3","020_28_3","PSA","28","3","3","Pasé takau ainauka anangminak: Amikmami tusar pengker chichainayat, ni ninti pasé asaramtai, tuke pasé nintiminawai. Tura asaramtai nu aints ainaujai metek mengkaakatnunmaka akuptukaip. ");
INSERT INTO acuNT_vpl VALUES ("PS28_4","020_28_4","PSA","28","4","4","Ni tunau takaamurijai metek ameka yapaijkiata. Tura ni turuwarmia nunisarang ni wait wajakartintri susarta. ");
INSERT INTO acuNT_vpl VALUES ("PS28_5","020_28_5","PSA","28","5","5","Nu aints ainauka Yuse turamurinka pachischaru asaramtai, ningki nu aints ainaunka mengkaktinuitai. Tura ataksha pengké inankishtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS28_6","020_28_6","PSA","28","6","6","Yus wina seamurun anturtuku asamtai: Ameketme pengkeram tajai. ");
INSERT INTO acuNT_vpl VALUES ("PS28_7","020_28_7","PSA","28","7","7","Yus kakaram asa wina ejarnuitai. Tura asamtai niin tuke nintimnuyajai. Wi turamtai winaka yainuyayi. Tura asamtai wina nintirjai waraakun kantan kantamatatjai. Turasha Apurun maaketai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS28_8","020_28_8","PSA","28","8","8","Yus ni aintsri ainautin kakamtikramratnuitji. Tura asa ii apuri ningki inaikiamia nunaka yaingtinuitai, tura uwemtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS28_9","020_28_9","PSA","28","9","9","Apuru ami aintsrum ainautinka uwemtikiartukta, tura pengker awajkartusta. Uwija wainin ni uwijarin tenapkes wainua nunismek iincha waitkratkata. Tura uwija wainin uwija uchirin minakas juwawa nunismek tuke iincha jukartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS29_1","020_29_1","PSA","29","1","1","Nayaimpinam pujuinautiram Yus: Ameketme juuntam titaram. Tura Yus nekas pengkeraitai tusaram: Ameketme kakarmam titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS29_2","020_29_2","PSA","29","2","2","Turasha Yuse naari pachisrum: Yus juuntaitai titaram. Tura ni jeen nekas pengker aa nuni jearam: Ameketme Yusem titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS29_3","020_29_3","PSA","29","3","3","Yuse chichaamuringkia juun entsanmasha antuukamnawaitai. Yus timiá kakaram asa, ipiamtancha akupkamnawaitai, tura juun entsancha inawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_4","020_29_4","PSA","29","4","4","Yuse chichaamuringkia nekas kakarmaitai. Ni chichaamuri antukrikia, ni kakarmari tu awai tusar nekaamnawaitji. ");
INSERT INTO acuNT_vpl VALUES ("PS29_5","020_29_5","PSA","29","5","5","Yus charpin tura nasencha akupak, numi juun wajainauncha tsairminuitai. Tura numi juun mura Líbanon tutainum wajainauncha tsairminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_6","020_29_6","PSA","29","6","6","Tura mura Líbanon tutaisha tura Sirión tutaisha muchitkarti tusa muchkamnawaitai. Waaka aishmangkri tura waaka uchiri ainau tsekena nunisarang muchitkarti tusa muran peakminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_7","020_29_7","PSA","29","7","7","Yus chichaakka nayaimpinmaya ji kapaun akupkamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_8","020_29_8","PSA","29","8","8","Tura nungka Cades tutai entsa atsamunmasha muchkamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_9","020_29_9","PSA","29","9","9","Yuse chichaamuringkia numi juun ainaun wainiat pearminuitai. Tura numi ainauncha mash kupirminuitai. Tura asamtai ni jeen kaunkaru ainau mash: Ameketme Yusem tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_10","020_29_10","PSA","29","10","10","Yus yumincha jiturti tusa akupawai. Tura tuke pujuu asa, mash ainia nuna tuke inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS29_11","020_29_11","PSA","29","11","11","Yus ni aintsri ainautin ni kakarmarin suramji. Tura ni aintsri ainautin: Tuke angkan pengker nintimsaram pujustaram tusa pengker awajtamji. ");
INSERT INTO acuNT_vpl VALUES ("PS30_1","020_30_1","PSA","30","1","1","Apuru wina angkanmamtikruau asakmin, maaketai tajame; tura wina nemasur ainau wishikrarai tusam surimruku asakmin maaketai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS30_2","020_30_2","PSA","30","2","2","Apuru wina Yusur asam, wi seam tsuwaramiame. ");
INSERT INTO acuNT_vpl VALUES ("PS30_3","020_30_3","PSA","30","3","3","Apuru ame jakai tusam wina uwemtikrurmiame, tura tsaarta tusam pujut surusmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS30_4","020_30_4","PSA","30","4","4","Yus umirkau ainautiram, Yus nintimsaram kantamataram. Tura ni naari nekas pengker aa nu pachisrum: Yus juuntaitai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS30_5","020_30_5","PSA","30","5","5","Yuska nukapka kajechu asamtai, ni kajekmauri wári nangkankatnuitai. Antsu ni wait anengkratairingkia tuke nangkankashtinuitai. Kashi juutkur pujayatrik tsawaarkurkia warastinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS30_6","020_30_6","PSA","30","6","7","Yusru wina pengker awajtusu asakmin, wikia yaanchuik wiki nintimsanak: Maj, wikia tuke angkan pengker pujustinuapitja timiajai. Turayatun ame yaintsuk pujakmin, wikia sapijmiakun napchau nintimsan pujumiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS30_8","020_30_8","PSA","30","8","8","Apuru amin seajme, tura amin untsuajme. ");
INSERT INTO acuNT_vpl VALUES ("PS30_9","020_30_9","PSA","30","9","9","Wi jakamtaisha ¿winasha pengker awajtustinkitam? Tura wina namangkrun iwiartusaramtaikia, ¿wikia amincha maaketai titinuashitjam? Jakaru ainauka aminka maaketai turamiarchatnuitai, tura ameketme pengkeram turamiarchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS30_10","020_30_10","PSA","30","10","10","Apuru anturtukam, tura wait anentruram yainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS30_11","020_30_11","PSA","30","11","11","Apuru wina juutmaur mengkatruku asakmin, yamaikia waraajai. Tura jakamin nintimaur yapaijturau asakmin, yamaikia aints entsatin shiirman entsar, fiestanam weawa nunisnak wikia waraajai. ");
INSERT INTO acuNT_vpl VALUES ("PS30_12","020_30_12","PSA","30","12","12","Tura Apuru wina Yusur asakmin, yamaikia chichatsuk pujustatkaman tujintajai. Antsu warasan kantan kantamruatjame, tura amin tuke maaketai titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS31_1","020_31_1","PSA","31","1","1","Apuru ame ejarkata tusan seajme. Nunia inatsturaip tusan seajme. Ame nekas pengker asam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS31_2","020_31_2","PSA","31","2","2","Wait aneasam tsuntsumaam tenap anturtukam, wári angkanmamtikruata. Aints pampanam wajas angkan wajawa nunismek wina ejarkata. Tura aints jea wenurmaunum ni nemasen shamtsuk pujawa nunismek pujusta tusam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS31_3","020_31_3","PSA","31","3","3","Ameka nekasam pampa muchikchamin aa nunisketme. Turasha wenuk yumpunkachmin aa nunisketme. Ame tame nuka tuke umiu asam jintintruata, tura waitkata tusan, ami naarmin pachisan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS31_4","020_31_4","PSA","31","4","4","Aints kuntinun achikiartas ajatinawa nunisarang aints ainau wina achirkartas wakerutinawai. Tura asaramtai ame wina ejarkatin asam angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS31_5","020_31_5","PSA","31","5","5","Wina wakantruka ame waitrukta. Apuru ame nekasam Yus asam wina ayamrutkata. ");
INSERT INTO acuNT_vpl VALUES ("PS31_6","020_31_6","PSA","31","6","6","Aints ainau Yuschau waininayat ni yusrin: Ameketme yusem tinaunka pengké nakitajai. Antsu wikia: Nekasampita tau asan amin nintimtusan pujajme. ");
INSERT INTO acuNT_vpl VALUES ("PS31_7","020_31_7","PSA","31","7","7","Ame anenme nuna nekau asan, pengker nintimsan waraajai. Tura wi wake mesekan pujamur nekau asam, ameka wait wajamursha waitme. ");
INSERT INTO acuNT_vpl VALUES ("PS31_8","020_31_8","PSA","31","8","8","Tura wina nemasur ainau maawarti tusamka tsangkamrukchamame. Antsu aints nungka muchkachminum pujawa nunismek pujusta tusam winaka waitnuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS31_9","020_31_9","PSA","31","9","9","Apuru wikia itiurkachminum pujau asamtai wait anentrurta. Nukap juutu asamtai, wina jiiruka najamrutak kusuri. Turasha wina namangkruka mash pimpi pimpi nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_10","020_31_10","PSA","31","10","10","Wikia najaimiakun juutu pujau asamtai, wina pujutruka kichik musachia nunisang wári amuawai. Nukap wake mesekan pujau asan, kakarchamin nekapeajai. Tura wina namangkrusha pimpi pimpi nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_11","020_31_11","PSA","31","11","11","Wina nemasur ainauka nukap wishikrinawai. Tura wina irutkamur ainausha wishikrami tusar, wina pachitsar pasé chichartinawai. Tura wi jintanam wekaamtai, wina waintair ainausha wina waitan nakitrinak ajapruwar ukurinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_12","020_31_12","PSA","31","12","12","Aints jakaun kajinmina nunisarang winasha tuke kajinmatrinawai. Tura asan wikia jakach ajapamua nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_13","020_31_13","PSA","31","13","13","Aints nangkamiar wina pachitsar shishkamsar chichartinaun anturmamjai: “Atu atu yantame itiurkachmin shamrumtin awai”. Tu tinau asar, aints untsuri wina mantuwartas chichaman najatrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_14","020_31_14","PSA","31","14","14","Antsu wikia amin nintimsan pujajme. Apuru wikia aminka tuke: Ameketme Yusur tinuyajme. ");
INSERT INTO acuNT_vpl VALUES ("PS31_15","020_31_15","PSA","31","15","15","Wina pujutruka aminuitai. Wina nemasur ainau wina papeetkar mantuwartas wakerutinamtaisha angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS31_16","020_31_16","PSA","31","16","16","Wikia ami inatirmetjai. Tura nekas pengker asam jiirsata. Tura wait anentruram uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS31_17","020_31_17","PSA","31","17","17","Apuru amin untsuajme. Wi seamsha inatsturaip. Antsu pasé aints ainau inatsaarta. Tura iwiarsamu ainau chichatsuk pujuinawa nunisarang pujusarti tusam itiatmamtikiata. ");
INSERT INTO acuNT_vpl VALUES ("PS31_18","020_31_18","PSA","31","18","18","Chikich wait chichaman chichau ainau anangkartichu ainaun pachisar wishikinak: Nuka mianchawaitai tusar, pasé chichaina nu amek itiatmamtikiata. ");
INSERT INTO acuNT_vpl VALUES ("PS31_19","020_31_19","PSA","31","19","19","Antsu amin umirtamin ainauka nekasam timiá aneame. Mash aints ainau wainminamunum amin nekasampita turamin ainau anengkratairum nekamtikiatasam inaktusume. ");
INSERT INTO acuNT_vpl VALUES ("PS31_20","020_31_20","PSA","31","20","20","Ame tuke pujau asam, amin umirtamin ainaun chikich aints ainau pasé awajsarai tusam ejaktinuitme. Ami aintsrum ainau wainkau asam, ni nemase ainau niin pachisar pasé chicharkarai tusam surimiame. ");
INSERT INTO acuNT_vpl VALUES ("PS31_21","020_31_21","PSA","31","21","21","Apuru wi wake mesekan pujai, wina wait anentrakum pengker awajtusu asakmin, nekasam pengkeraitme tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS31_22","020_31_22","PSA","31","22","22","Yusru wikia itiurkachmin pujamtai, ame winaka ajapruam ukurkimiame timiajai. Antsu wi yainkata tusan untsummatai, wina untsummaur anturtukmame. ");
INSERT INTO acuNT_vpl VALUES ("PS31_23","020_31_23","PSA","31","23","23","Yus umirkautiram atumi Apuri aneetaram. Ni umirkau ainautinka ii Apuringkia waitmaji. Antsu miajuitjai tumamin ainaunka ni wait wajaktintrin susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS31_24","020_31_24","PSA","31","24","24","Atumi Yusri nekasampita tau asaram, napchauka nintimtsuk antsu pengker nintimsaram pujustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS32_1","020_32_1","PSA","32","1","1","Yus aintsu tunaarin mash sakar tsangkuramu asa, nu aintska waraawai. ");
INSERT INTO acuNT_vpl VALUES ("PS32_2","020_32_2","PSA","32","2","2","Tura nu aintsu tunaarin mash sakturu asa, Yuska ni tunaarinka nintimtatsui. Tura asamtai nu aintska nekas waraawai. Tura wina tunaaruka atsawai tusa nekas pengker pujawai. ");
INSERT INTO acuNT_vpl VALUES ("PS32_3","020_32_3","PSA","32","3","3","Antsu wina tunaarun uukan etsertsuk pujaknaka, kintajai metek jakamin nekapeakun wake mesekan pujuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS32_4","020_32_4","PSA","32","4","4","Apuru tsawaisha tura kashisha napchau nintimrati tusam, wi wait wajaktin surusu asakmin, yangkur tsaa sukuam kaawa nunisnak nekapeakun, wina kakarmarka pengké atsumiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS32_5","020_32_5","PSA","32","5","5","Tura asamtai wikia nintimran: Apurun tunaarun ujaktajai tusan, wina tunaarunka mash uutsuk amin ujakmiajme. Wi turamtai wina tunaaruka mash tsangkutrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS32_6","020_32_6","PSA","32","6","6","Tura asamtai Yus umirkau ainautikia wake mesekar nintimrar, nujang nungkan amurmanum ujungmawa nunisrik jakatatjiapi tu nintimrar pujakrikia amek seamnawaitji. Tura nujang aintsu pujutirin amurmawa nunisang nekapeayatrik ataksha entsa kuyuak ukukmiawa nunisrik uwemratnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS32_7","020_32_7","PSA","32","7","7","Ameketme wina ejarkatnumka. Itiurkachmin pujamtaisha wina ayamrutkatnuitme. Tura wina angkanmamtikruau asakmin, warasan kantan kantamruatnuitjame. ");
INSERT INTO acuNT_vpl VALUES ("PS32_8","020_32_8","PSA","32","8","8","Wina Apur chichartak: Wikia amin wainjame, tura amincha chicharjame, tura amin nuiniartasan: Juwaitai jinta tusan nekamtikiatjame turutui. ");
INSERT INTO acuNT_vpl VALUES ("PS32_9","020_32_9","PSA","32","9","9","Kawai tura burro nintinchau asamtai, aints jirujai jangken jingkiawar, mai japi mai japi awajmawa nunisrumka airap. Antsu nu tangku ainauka jingkiatskeka atumin winichartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS32_10","020_32_10","PSA","32","10","10","Pasé aints ainauka nukap wait wajakartin ainawai. Antsu Yus nekasampita tinu ainautinka ii Apuri tuke wait anentramak waitmaji. ");
INSERT INTO acuNT_vpl VALUES ("PS32_11","020_32_11","PSA","32","11","11","Pengke aints ainautiram tura anangmichu ainautirmesha, atumi Apuri turamuri nintimraram warastaram. Tura pengker nintimu asaram, waraakrum kanta kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS33_1","020_33_1","PSA","33","1","1","Pengke aints ainautiram, ii Yusri ameketme juuntam titaram. Pengke aints ainau Yusen: Ameketme pengkeram timiauri nekas pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_2","020_33_2","PSA","33","2","2","Kitarrum tuntuyakrumsha: Yus maaketai takuram kantamataram. Tura arpasha tuntuyakrum kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS33_3","020_33_3","PSA","33","3","3","Tura yamaram kanta kantamkurmesha Yus juuntaitai titasrum nekasrum pengker tuntuyataram. ");
INSERT INTO acuNT_vpl VALUES ("PS33_4","020_33_4","PSA","33","4","4","Yuse chichamengka nekas waitchawaitai. Tura ni najanamurisha mash wainu asar, Yus nekas pengkeraitai titinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS33_5","020_33_5","PSA","33","5","5","Yuska nekas pengker aa nuna wakerawai. Ni anengkratairi mash nungka ainamunam tinamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PS33_6","020_33_6","PSA","33","6","6","Yus nayaimpincha tura nayaimpinam iruna nunasha mash ni chichamejai aya chichasang najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS33_7","020_33_7","PSA","33","7","7","Yus juun entsan najanak nekas kuna ati tusa, yumi mash nuni yarakmawa nunisang najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS33_8","020_33_8","PSA","33","8","8","Mash nungkanam pujuinautiram Yus maaketai titaram. Tura mash nungkanam matsatutirmesha, ii Apuri ameketme juuntam titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS33_9","020_33_9","PSA","33","9","9","Yus aya chichasang mash najankamiayi. Yus tu ati tinu asamtai, ni najankamuri mash nunisarang armiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS33_10","020_33_10","PSA","33","10","10","Yus niin umirkacharu ainau wakeramurin jiis, turacharti tusa surimiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_11","020_33_11","PSA","33","11","11","Antsu ni wakeramurin ningki mash miatrusang umiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_12","020_33_12","PSA","33","12","12","Aints ii Apurin: Nekas Yusketai tinu ainauka pengker nintimsar pujusartin ainawai. Tura Yus nu aints ainaunka: Nekasar wina aintsur ainawai timiau asar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_13","020_33_13","PSA","33","13","13","Yuska nayaimpinam pujus mash aints ainautin waitmaji. ");
INSERT INTO acuNT_vpl VALUES ("PS33_14","020_33_14","PSA","33","14","14","Ni pujutiriniang mash nungkanam pujuinaunka jiiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_15","020_33_15","PSA","33","15","15","Ningki aintsti nintin najatramau asa, ii takaamurincha mash nekawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_16","020_33_16","PSA","33","16","16","Ju nungkanam apu pujuinauka suntar timiá untsurin inainayat, kichkisha ningkikia uwemrartatkamawar tujintinawai. Tura aints kakaram ainayat, kichkisha ningkikia uwemrachartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_17","020_33_17","PSA","33","17","17","Kawai ainauka kakaram ainayat, aintsun kichkisha uwemtikrachartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_18","020_33_18","PSA","33","18","18","Antsu ii Apurin: Ameketme Apum tinu ainaunka tura ni anengkratairin nintimsar pujuinauncha tuke wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_19","020_33_19","PSA","33","19","19","Nu aints ainau jakarai tusa, tura tsukajai wait wajakarai tusa, uwemtikratas wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS33_20","020_33_20","PSA","33","20","20","Iikia ii Yusri nintimsar: Ningki iin yainmaktinuitji, tura ningki ejarmaktinuitji taji. ");
INSERT INTO acuNT_vpl VALUES ("PS33_21","020_33_21","PSA","33","21","21","Iikia ii Apuri nekas pengker aa nu nekasampita tusar, ni naari nintimsar ii nintijai waraaji. ");
INSERT INTO acuNT_vpl VALUES ("PS33_22","020_33_22","PSA","33","22","22","Yusru iikia tuke ame nintimsar pujau asakrin, ami anengkratairum tuke iin sukartusta taji. ");
INSERT INTO acuNT_vpl VALUES ("PS34_1","020_34_1","PSA","34","1","1","Wikia Yusrun kintajai metek: Ameketme pengkeram titatjai. Wina jangkerjai tuke Yus juuntaitai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_2","020_34_2","PSA","34","2","2","Wikia Yusrun nintimtusan: Nekas kakarmaitai tajai. Jampechu ainautirmeka nu antukrum warastaram. ");
INSERT INTO acuNT_vpl VALUES ("PS34_3","020_34_3","PSA","34","3","3","Iijai metek mash iruntrar ii Apuri naari pachisar: Yuska nekas juuntaitai tiarmi. ");
INSERT INTO acuNT_vpl VALUES ("PS34_4","020_34_4","PSA","34","4","4","Wikia Yusrun seam ni anturtukmiayi. Tura ni shamtsuk asata tusa angkanmamtikruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS34_5","020_34_5","PSA","34","5","5","Wina Yusrun nintimsar pujuinauka nukap warainawai. Tura pengké natsaamtsuk pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_6","020_34_6","PSA","34","6","6","Wikia mianchau asan, shamakun untsumkinij wajamiajai. Wi turamtai wina Yusur anturtuk: Shamtsuk pujusta tusa, itiurkachminnum pujaing angkanmamtikruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS34_7","020_34_7","PSA","34","7","7","Yuse awemamuri Yus nintimsar pujuinautin tuke waitmaku asamtai uwemtikramratnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS34_8","020_34_8","PSA","34","8","8","Yus pengkerashi tusaram nekaatasrum wakerakrumka, tenap nintimsaram nekaataram. Aints Yusen nintimsar pujuinauka nekasar pengker nintimsar pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_9","020_34_9","PSA","34","9","9","Yus umirkautiram atumi Apuri nintimtusrum: Ameketme juuntam titaram. Iikia tuke nintijai ni umirkarkia yuumakchatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS34_10","020_34_10","PSA","34","10","10","Kuikiartin ainauka kuikiartichu wajasar yuumakartin ainawai. Antsu ii Apuri seautikia nekasar pengker pujustinka yuumakchatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS34_11","020_34_11","PSA","34","11","11","Uchir ainautiram, wini winiram anturtitaram. Itiur ii Yusri pengker awajsatnuitji tusan, atumin nuiniartasan wakerajrume. ");
INSERT INTO acuNT_vpl VALUES ("PS34_12","020_34_12","PSA","34","12","12","Atumka pengker nintimsaram wara warat pujustasrum wakerakrumka, ");
INSERT INTO acuNT_vpl VALUES ("PS34_13","020_34_13","PSA","34","13","13","pasé chichamka chichatsuk asataram. Tura wait chichamsha etsertsuk asataram. ");
INSERT INTO acuNT_vpl VALUES ("PS34_14","020_34_14","PSA","34","14","14","Tura pasé aa nuka mash inaisaram, pengker aa nuke turin ataram. Turakrum angkan pengker nintimsar pujut wakerin ataram. ");
INSERT INTO acuNT_vpl VALUES ("PS34_15","020_34_15","PSA","34","15","15","Ii Apuri Yuska nekas pengke nintintin ainaun wainin asa, ni seamuncha anturui. ");
INSERT INTO acuNT_vpl VALUES ("PS34_16","020_34_16","PSA","34","16","16","Antsu tunau takau ainaunka nakitawai. Tura nu aintsu naarin chikich aints ainau nintimtsuk asarti tusa kajinmamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PS34_17","020_34_17","PSA","34","17","17","Yuska pengker nintintin ainau seamurinka anturui. Tura itiurkachminnum pujuinamtaikia, shamtsuk pujusarti tusa angkanmamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PS34_18","020_34_18","PSA","34","18","18","Ii Yusringkia arakchichuitai. Tura asa aints: Wikia mengkaakatnuapitja tusar, napchau nintimsar pujuinaunka uwemtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_19","020_34_19","PSA","34","19","19","Pengke nintintin itiurkachminnum nukap wait wajainau wainiat, ii Yusri mash angkanmamtiknuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_20","020_34_20","PSA","34","20","20","Ni kunchincha kupirkacharti tusa wainuitai. Tura asamtai kichkisha kupirkachartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_21","020_34_21","PSA","34","21","21","Pasé aints ainau ni tunaarijai jakartin ainawai. Tura pengke nintintin ainaun tsuutinauka wait wajakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS34_22","020_34_22","PSA","34","22","22","Antsu ii Yusri ni inatiri ainaun uwemtikratnuitai. Tura Yusen nekasampita tinu ainaunka wait wajaktintrinka susashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_1","020_35_1","PSA","35","1","1","Yusru wina nepetukartas wakerutina nuka amek nepeturkata. Tura wijai maanitan wakerina nujaisha amek maanikta. ");
INSERT INTO acuNT_vpl VALUES ("PS35_2","020_35_2","PSA","35","2","2","Aminu tantaarum jukim wina yainkatasam winita. ");
INSERT INTO acuNT_vpl VALUES ("PS35_3","020_35_3","PSA","35","3","3","Tura nangkiram achikiam, wina mantuwartas papeetkiar winina nuka maawarai tusam surimrukta. Tura wiitjai amin uwemtikratnunka turuttia. ");
INSERT INTO acuNT_vpl VALUES ("PS35_4","020_35_4","PSA","35","4","4","Yusru wina mantuwartas wakerutina nuka natsaarar tupikiakiarti. Tura wina pasé awajtusartas wakerutinausha nunisarang natsaarar waketkiarti. ");
INSERT INTO acuNT_vpl VALUES ("PS35_5","020_35_5","PSA","35","5","5","Tura nase umpuak chirichri kaarun juwawa nunisang ami awemamuram ainau nu aints ainaunka jukiar arák ajapawarti. ");
INSERT INTO acuNT_vpl VALUES ("PS35_6","020_35_6","PSA","35","6","6","Turinamu asar ni teenam wekaasar jinta chungkap amaunum ayaararti. Tura ami awemamuram niin papeekarti. ");
INSERT INTO acuNT_vpl VALUES ("PS35_7","020_35_7","PSA","35","7","7","Kuntinun achikiartas ejatkan ejatinawa nunisarang nu aints ainauka nangkamiar wina achirkartas ejatkan pujtursarmayi. Tura ayaarti tusar waan tautriniarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS35_8","020_35_8","PSA","35","8","8","Turinau asaramtai aneachmau nu waanmaka ayaarar mengkakarti. Tura ejatkan ningki puusarma nunisha achimkar, wait wajakarti tusan amin seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS35_9","020_35_9","PSA","35","9","9","Antsu wina uwemtikruru asakmin, maaketai tusan warastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_10","020_35_10","PSA","35","10","10","Tura wina nintirjai warasan: Amijai metek chikichkisha atsawai titatjai. Nekas kakaram ainau mianchau ainaun tura yuuminauncha nangkamiar takamtikinawai. Tura wainiatum nu aints ainamunmaya ame angkanmamtikiatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS35_11","020_35_11","PSA","35","11","11","Tsanumin aints ainauka wajakiar, wi nekachmaun pachisar inintrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_12","020_35_12","PSA","35","12","12","Wikia niin pengker awajnuyajai. Tura waitinayat winaka pasé awajtusarmayi. Tura asar wina wake mesemtikrukarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS35_13","020_35_13","PSA","35","13","13","Yaanchuik nu aints ainau jaak tepeenamtai, wikia wake mesekan yutsuk pujuyajai. Tura amin tuke nintirjai nu aints ainaun pachisan seayajme. ");
INSERT INTO acuNT_vpl VALUES ("PS35_14","020_35_14","PSA","35","14","14","Aints ni nukuri, tura ni amikri tura ni nekas yachí jakamtai, wake mesek pujawa nunisnak wisha ni jaak tepaun wainkau asan, napchau nintimsan pujuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_15","020_35_15","PSA","35","15","15","Antsu wi pasé pujau asamtai, nu aints ainau mash iruntrar wishikrin armayi. Tura wainchatiya nunisarang tuke inaitutsuk winaka pasé awajtusarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS35_16","020_35_16","PSA","35","16","16","Tura wina itit awajtusar tura wishikrinak tura kajertinak jiiru awajtiarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS35_17","020_35_17","PSA","35","17","17","Apuru ¿nu aints ainau warutam kinta jiiame? Nu aints ainau juun yawaaya nunisarang shiniinak, wina mantuwartas wakerutina nuniangka uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS35_18","020_35_18","PSA","35","18","18","Turakmin aminu aintsrum untsuri iruntramunam amincha maaketai titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS35_19","020_35_19","PSA","35","19","19","Wina nemasur ainau nangkamiar kajertina nuka warascharti tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS35_20","020_35_20","PSA","35","20","20","Nu aints ainauka maanitsuk pujusartatkamawar tujintinawai. Antsu aints angkan pengker nintimsar pujuinaun pachisar anangkinak chichaman najatinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_21","020_35_21","PSA","35","21","21","Tura jangken awarar: “Iisha ni turamuri wainkawaitji. Atumsha nekaataram”, nangkamiar waitrinak tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS35_22","020_35_22","PSA","35","22","22","Tu tinau wainiatum, ame Apuru ni turamuringkia wainkawaitme. Tura asam ame takamtaikia pujusaip. Tura wina ajapruamka ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS35_23","020_35_23","PSA","35","23","23","Yusru wina Apur asam, anearam wajakim wina turamur nekartuam ayamrutkata. ");
INSERT INTO acuNT_vpl VALUES ("PS35_24","020_35_24","PSA","35","24","24","Yusru ameka wina Apuruitme. Tura pengké tunaarinchau asam, wina tunaar atsuash tusam jiirtusta. Tura wishikrarai tusam amek surimrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS35_25","020_35_25","PSA","35","25","25","Wina pachitsar: Tu wait wajakti tusar iikia wakerukmaji. Nuka yamaikia mesraji turutiarai tusam surimrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS35_26","020_35_26","PSA","35","26","26","Tura wi wait wajamtai, wina jiirsar waraina nuka inatsarta. Tura wina pachitsar: Nuka mianchawaitai turutinauka tuke natsaaminak pujusarti tusam inatsaarta. ");
INSERT INTO acuNT_vpl VALUES ("PS35_27","020_35_27","PSA","35","27","27","Antsu wina pengker nintimtursar: Ni nemase ainaun nepetkati turutinauka warainak untsumkarti. Turasha tuke Yus juuntaitai, tura ni inatiri pengker pujusti tiarti. ");
INSERT INTO acuNT_vpl VALUES ("PS35_28","020_35_28","PSA","35","28","28","Ni turutinamtai wikia ame pengker turamurmin pachisan chichastatjai. Tura kintajai metek: Ameketme pengkeram titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS36_1","020_36_1","PSA","36","1","1","Pasé aints ainauka ni nintijai tuke pasé nintimin ainawai. Antsu nekasar Yus umirkarmi tuuka nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS36_2","020_36_2","PSA","36","2","2","Nuka ningki nintimtumasar: Wikia miajuitjai tumamin ainauka: Wikia juun tunaawitjai tuuka pengké nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS36_3","020_36_3","PSA","36","3","3","Ni chichamengka nekasar pasé ainawai. Tura wait chichamtin ainawai. Tura paanka nintiminatsui. Tura pengker turatniuncha yanchuk ukukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS36_4","020_36_4","PSA","36","4","4","Tura ni peakrin tepesar, ni pasé turatniurin nintiminawai. Tura ni tunau takatirin inaitan nakitinau asar, aints waak wekaayat nu jintan tuke amaktas wakerawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS36_5","020_36_5","PSA","36","5","5","Antsu aminu anengkratairum, Apuru aintsu anengkratairin nangkamasketai. Tura aminu penkeerumka aintsu pengkerin nangkamasketai. ");
INSERT INTO acuNT_vpl VALUES ("PS36_6","020_36_6","PSA","36","6","6","Ame aints ainau tunaari nekatirmeka mura juun ainia nuna nangkamasketai. Tura ame chicham akupamu ainauka juun entsa kunaarin nangkamasketai. Ameka Yus asam, aints ainau tura kuntin ainausha mash wainuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS36_7","020_36_7","PSA","36","7","7","Yusru ami anengkratairumka timiá pengkeraitai. Tura asamtai aints ainau amin seatmiar ejamkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS36_8","020_36_8","PSA","36","8","8","Tura amin seatmina nuka ame suame nunaka aints yutan nukap yuwina nunisarang pengker nintimsar pujuinawai. Tura aints umutin nukap uminak tutuarar pujuinawa nunisarang ami pengkeerumin nintimsar warainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS36_9","020_36_9","PSA","36","9","9","Nekasam tuke pujut sukartinmeka ametme. Tura ame paantin najanau asakmin, iisha paan nintimsar pujustinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS36_10","020_36_10","PSA","36","10","10","Ami aintsrum ainautikia pengke nintintin asakrin, ami anengkratairum tura ami pengkeerumsha sukartusta. ");
INSERT INTO acuNT_vpl VALUES ("PS36_11","020_36_11","PSA","36","11","11","Antsu ningki nintimsar: Miajuitjai tumaminauka wina najatrarai tusam surimrukta. Turasha pasé aints ainauka wina achirkarai tusam ayamrutkata. ");
INSERT INTO acuNT_vpl VALUES ("PS36_12","020_36_12","PSA","36","12","12","Nu paseen takau ainau nepeteamu asaramtai jiistaram. Nu aints nepetkamu asar, ataksha nantakiartatkamawar tuke tujintinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_1","020_37_1","PSA","37","1","2","Pasé aints ainau chirichri charukmawa nunisarang wári mengkakartin ainawai. Tura nupaa jajatua nunisarang wári mengkakartin ainawai. Tura mengkaakartin asaramtai, nu aints ainau kajerkaip. Tura wisha nu aintsua nunisnak pujustasan wakerajai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PS37_3","020_37_3","PSA","37","3","3","Antsu Yus nekasampita tusam nintimrata. Turasha pengker aa nuke turata. Tura ju nungkanam pujusam, nekas aa nuke nintimsam pujusta. ");
INSERT INTO acuNT_vpl VALUES ("PS37_4","020_37_4","PSA","37","4","4","Apuram nukap aneamka, ame warí timiá wakerame nunaka suramsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_5","020_37_5","PSA","37","5","5","Niin nekasampita tusam nintimsam: Apuru wina pujutruka aminuitai tita. Tu pujakminka aminka yainmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_6","020_37_6","PSA","37","6","6","Tura tsaa yakí waakak etsantua nunisang ame pengker turamurmin tura ame tunaarinchau pujamurmin Yus chikich aints ainaun paan nekamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_7","020_37_7","PSA","37","7","7","Tura asamtai Yusrum takamtaik nintimrata. Turasha wina yainkati tusam jaimiasam nakasta. Chikich aints yuumatsuk pujamtai, suwirpiaku jiisam: Wisha nu aintsua nunisnak pujustasan wakerajai tiip. Tura pasé aints tunau takastas wakeramtai ¿waruka aitkawa? tiip. ");
INSERT INTO acuNT_vpl VALUES ("PS37_8","020_37_8","PSA","37","8","8","Ame kajekmaurumka inaisata. Tura chikich aints suwirpiaku jiiamurmesha inaisata. Ame chikich ainau kajeru pujakmeka pengkerka pujuschatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS37_9","020_37_9","PSA","37","9","9","Pasé aints ainauka mengkakartin ainawai. Antsu Yusen umirkaru ainauka yamaram nungkanam pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_10","020_37_10","PSA","37","10","10","Jumchik arusar pasé aints ainau mengkaakartinuitai. Tura asaramtai atum eaakrumsha pengké wainkashtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PS37_11","020_37_11","PSA","37","11","11","Antsu jampechu ainau yamaram nungkanam pujusar, nuni angkan pengker nintimsar pujusartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_12","020_37_12","PSA","37","12","12","Pasé aints ainau pengke aints ainaun pasé awajsartas nintiminawai. Tura asar suwirpiaku jiinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_13","020_37_13","PSA","37","13","13","Antsu Yus pasé ainau mengkakartin kinta jeartinun nekau asa, niin wishikiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_14","020_37_14","PSA","37","14","14","Pasé aints ainau ni nangkirin jukiar, tura tishimkurincha achikiar, mianchau ainaun tura jampechu ainauncha pasé awajsartas wakerinawai. Tura pengkeran takau ainaun maawartas wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_15","020_37_15","PSA","37","15","15","Turinayat ni nangkirijai ningki ni nintin ijumiar jakartin ainawai. Tura ni tishimkurin ningki kupikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_16","020_37_16","PSA","37","16","17","Yus pasé aints ainaun amuktin asamtai, ni kuikiarin nukap kiaungkarmia nunaka mash ukukiartin ainawai. Antsu pengke aints ainauka Yus wainmau asar, ni warinchurin jumchik takakinayat kuikiartinun nangkamasarang pengker pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_18","020_37_18","PSA","37","18","18","Yuska tunau takachu ainaun wainuitai. Tura asa ukunam pujut nangkankashtinun susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_19","020_37_19","PSA","37","19","19","Tsuka amatikia, chikich aints ainau yutairi atsau waininayat, tunau takachu ainau yutairi nukap atin asamtai, natsaarchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_20","020_37_20","PSA","37","20","20","Pasé aints ainau nupaa kaarua nunisarang keekartin ainawai. Tura Yuse nemase ainauka ji mukuntiuri mengkawa nunisarang mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_21","020_37_21","PSA","37","21","21","Pasé aints ainau kuikian ikiatsata tusar, kuikian jurukiariat awangtutsuk pujuu ainawai. Antsu pengke aints ainauka kuikiarin surimtsuk wait anengkratin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_22","020_37_22","PSA","37","22","22","Pengke aints ainaun Yuska pengker awajak, yamaram nungkanam pujusarti tusa jeekatnuitai. Antsu ni yumingkramu ainauka tuke mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_23","020_37_23","PSA","37","23","23","Yuska aints ainautin: Wina jintar amakrum wekaasataram turamji. Tura nu jintanam wekaasaram wi wakeraja nu umirtuktaram turamji. ");
INSERT INTO acuNT_vpl VALUES ("PS37_24","020_37_24","PSA","37","24","24","Ii aintsti tunaunum ayaarakrincha, Yus ii uwejen achirmak: Ataksha nantakta tusa inantamkitnuitji. Tura asamtai tunaanumka tukeka pujuschatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS37_25","020_37_25","PSA","37","25","25","Wikia yaanchuik natsa pujaknasha, tura yamai juunmatnumsha, aints Yusen tuke umirinayat yuuminak pujuinaunka wainchawaitjai. Tura ni uchiri ainau chikich aintsnum yutan seaminauncha wainchawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_26","020_37_26","PSA","37","26","26","Pengke aints ainau tuke wait anengkratin ainawai, tura kuikiaram ikiatsata tinamsha suritinatsui. Turinau asaramtai, ni uchirisha chikich aints ainauncha pengker awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_27","020_37_27","PSA","37","27","27","Amesha tunaarumka inaisam, pengker aa nuke turata. Tu pujakmeka tuke ami pujustintrum wainkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS37_28","020_37_28","PSA","37","28","28","Yuska nekas pengker aa nunak wakerawai. Tura niin umirinaunka ajapangka ukukchatnuitai. Antsu pasé aints ainaunka tura ni weari ainauncha amuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_29","020_37_29","PSA","37","29","29","Pengke aints ainau yamaram nungkanam tuke pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_30","020_37_30","PSA","37","30","30","Nu aints ainauka ni nekaina nunaka antujamniun chichainawai. Tura asar nekas pengker aa nunak chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_31","020_37_31","PSA","37","31","31","Yus ni nekamtairincha ni nintin engketamu asar, tuke Yuse jinti ayaatsuk wekaasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_32","020_37_32","PSA","37","32","32","Pasé aints ainau pengke aints ainaun maawartas anumkar wekaatinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_33","020_37_33","PSA","37","33","33","Antsu Yus pengke aints ainaun maawarti tusangka tsangkamkashtinuitai. Tura asa nu pengke aints ainaunka chikich aints wiasmamtikiashti tusa surimkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_34","020_37_34","PSA","37","34","34","Yus nekasampita tusam umirkata. Ame turakminkia amin pengker awajtamak yamaram nungkanam jeetamkatnuitai. Tura pasé aints ainau mengkaakatniuri amesha wainkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS37_35","020_37_35","PSA","37","35","35","Pasé aints ainau numi juun wajawa nunisarang: Wikia miajuitjai tusar, jampesarang wajainaun wainkamiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_36","020_37_36","PSA","37","36","36","¿Antsu tutsuk wearia? Wi eaknasha wainkatatkaman tujinkamiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_37","020_37_37","PSA","37","37","37","Aints anangkartichu tunaun pengké takachu asamtai jiij pujurtia. Nu aintska ukunam angkan pengker nintimias pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_38","020_37_38","PSA","37","38","38","Antsu pasé aints ainauka tuke mengkaakartin asar, ukunmasha tuke nantakchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_39","020_37_39","PSA","37","39","39","Yuska pengke aints ainia nuna yaingtinuitai. Tura itiurkachminnum pujuinamtaisha, nu aints ainaun ayamruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS37_40","020_37_40","PSA","37","40","40","Nu aints ainau Yusen seainak: Ejarkata tinu asaramtai, Yus nu aints ainaun yaingmau asa, pasé aints ainamunmaya angkanmamtikiatnuitai tura uwemtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_1","020_38_1","PSA","38","1","1","Yusru wina kajertakmesha wait aneasam jiyatkaip. Tura wina kajertukam pujayatmek wait aneasam wait wajaktinka surusaip. ");
INSERT INTO acuNT_vpl VALUES ("PS38_2","020_38_2","PSA","38","2","2","Aints tishimkurijai chikich aintsun kettuk ijumua nunisnak nekapmamjai. Tura ami uwejem yakairun meram patatua nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_3","020_38_3","PSA","38","3","3","Wina tunaar jiisam kajertuku asakmin namangkruka mash najamrutawai. Tura wina ukunchrusha kupinakua nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_4","020_38_4","PSA","38","4","4","Tura wina tunaaruka piakuitai tu nekapmamu asan, merman entsakua nunisnak tsantrachmin nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_5","020_38_5","PSA","38","5","5","Wikia timiá nintinchau asan tunaun takau asamtai, wina namangkruka kuchap kawaawa nunisang mejeawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_6","020_38_6","PSA","38","6","6","Tura asamtai wikia kintajai metek wake mesekan tsuntsuman wekaajai. Tura pengker nintimsan pujustatkaman tujintajai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_7","020_38_7","PSA","38","7","7","Wi tsuweamtai, wina tuntupruka ji kapawa nunisnak nekapmamkun, wina namangkruka mash najamrutawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_8","020_38_8","PSA","38","8","8","Tura wina kakarmarka pengké atsau asamtai, wikia napchau nintimsan juutmin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_9","020_38_9","PSA","38","9","9","Apuru wina nintimauruka mash nekau asakmin, wi chichaktatkaman mayairukan pujaja nusha waitme. ");
INSERT INTO acuNT_vpl VALUES ("PS38_10","020_38_10","PSA","38","10","10","Wina nintirka kakarman teetui. Tura wina kakarmarka atsawai. Tura jiirusha kusuawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_11","020_38_11","PSA","38","11","11","Tura wina amikur pengker ainia nu tura wina wear ainausha kuchaprun wainkar, winaka jiirtancha nakitrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_12","020_38_12","PSA","38","12","12","Tura wina mantuwartas wakerutinauka ejatkanam kuntinun achikiartas wakerina nunisarang achirkartas wakerutinawai. Tura wina pasé awajtusartas wakerutinauka kintajai metek mesturartas chichaman najatrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_13","020_38_13","PSA","38","13","13","Antsu wikia aints antichua nunisnak pasé aints ainau chichamenka antutsuk pujajai. Turasha chichachua nunisnak takamtaik pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_14","020_38_14","PSA","38","14","14","Wikia aints antichua tumau asan, ayamrumaktatkaman chichaschamin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_15","020_38_15","PSA","38","15","15","Apuru wina Yusur asakmin, ameketme wina ayamrutkatnumka tusan, wina nemasur ainau amek nepetkata tusan nakajme. ");
INSERT INTO acuNT_vpl VALUES ("PS38_16","020_38_16","PSA","38","16","16","Antsu wina nepetukar warasarai tura wishikrurarai tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS38_17","020_38_17","PSA","38","17","17","Wikia nekasan jatanak wajasjai. Tura asan tuke najaimiamur mijantratsui. ");
INSERT INTO acuNT_vpl VALUES ("PS38_18","020_38_18","PSA","38","18","18","Wina tunaar ainau waurmamtikrinau asaramtai, wikia etserkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_19","020_38_19","PSA","38","19","19","Wina nemasur nukap yujarari. Tura nangkamiar kajertin ainausha untsurintai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_20","020_38_20","PSA","38","20","20","Niinka wikia pengker awajinamaitiat, winaka pasé awajtusarmayi. Wi pengker aa nunak takastasan wakerai waitinayat, wina nakitrinak pasé nintimtursar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS38_21","020_38_21","PSA","38","21","21","Apuru winaka ajapruamka ukurkiip. Yusru wijai tuke pujusta. ");
INSERT INTO acuNT_vpl VALUES ("PS38_22","020_38_22","PSA","38","22","22","Yusru wina uwemtikrurtin asakmin, wári yainkata tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS39_1","020_39_1","PSA","39","1","1","Pasé aints ainau wina jiiru pujuinaing, wikia wiki nintimsan: Nekasan pengker pujustatjai tau asan, pasé chichamnasha pengké chichakchatatjai timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS39_2","020_39_2","PSA","39","2","2","Tura asan wikia pasé chichamnasha chichatsuk, tura pengker chichamnasha chichatsuk takamtaik pujusmajai. Turayatun atsantrachmin nekapeakun, ");
INSERT INTO acuNT_vpl VALUES ("PS39_3","020_39_3","PSA","39","3","3","wina nintir ji keawa nunisnak nekapeakun, wina Yusrun kakarman untsuakun: ");
INSERT INTO acuNT_vpl VALUES ("PS39_4","020_39_4","PSA","39","4","4","“Apuru ¿wina jakatniur warutik at? tusam nekaamtikruata. Turasha ¿warutam kintak iwiaaku pujustaj? tusan nekaatasan wakerajai”, timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS39_5","020_39_5","PSA","39","5","5","Wina pujutruka ame surusmiame nuka wári mengkaakatnuitai. Tura asamtai nukap kinta pujuschamin nekapeajai. Aintsti pujutri kichik mayatmaujai metekaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS39_6","020_39_6","PSA","39","6","6","Tura mash aints ainauti mikin wári mengkawa tumawaitji. Tumau asar ii warinchuri untsuri kiaungkar pujayatrik, ii jakaakrincha yáki nuna jukit tusarsha nekatsji. ");
INSERT INTO acuNT_vpl VALUES ("PS39_7","020_39_7","PSA","39","7","7","Tu pujau asan ¿wisha itiurkatjak? tusan Apuru aminak nakajme. ");
INSERT INTO acuNT_vpl VALUES ("PS39_8","020_39_8","PSA","39","8","8","Wina tunaarunia angkanmamtikruata. Tura nintinchau ainau wina wishikrurarai tusam surimrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS39_9","020_39_9","PSA","39","9","9","Ami turamurmin nintimsan, chichatsuk takamtaik pujusmajai. ");
INSERT INTO acuNT_vpl VALUES ("PS39_10","020_39_10","PSA","39","10","10","Wina wait wajaktin surusu asakmin, wikia jakamin nekapeajai. Tura asamtai wait aneasam winaka wait wajaktinka nukapka surusaip. ");
INSERT INTO acuNT_vpl VALUES ("PS39_11","020_39_11","PSA","39","11","11","Aints ainauti tunau asakrin: Tunaarum inaisataram tusam, wait wajaktin sukartame. Aintstikia mash nangkamir nintimsar pujau asakrin, warí nukap wakeraji nuka nungka tsetseria tumau ati tusam tsairtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS39_12","020_39_12","PSA","39","12","12","Tura asam wi seajme nu anturtukta Apuru. Juutmaur antukam, wina neaikir jiisam airkata. Ameka chikich aints wainchatiya nunismek winaka jiirme. Tura asakmin ii juuntri yaanchuik pujuarmia nunisketjai. Tura asan chingki taa keemtsuk weawa nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS39_13","020_39_13","PSA","39","13","13","Wikia jaatsuk pujaing, winaka kajertukaip. Tura wi jaatsaing jumchik iwiaaku pujusti tusam tsangkatrukta. ");
INSERT INTO acuNT_vpl VALUES ("PS40_1","020_40_1","PSA","40","1","1","Wikia Apurun nintimran: Yainkata tusan untsukmiajai. Wi tamati wina Yusur anturtukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS40_2","020_40_2","PSA","40","2","2","Tura jakatniunmaya wina uwemtikrurmiayi. Tura mengkaakai tusa ayamrutkamiayi. Tura aints mura yakí ayaatsuk wajawa nunisang angkan pujusti tusa, winaka angkanmamtikruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS40_3","020_40_3","PSA","40","3","3","Tura yamaram kanta kantamata tusa, winaka nintimtikrurmiayi. Turamtai nu kantajai ii Yusrin: Ameketme juuntam timiajai. Wi tamatai aints untsuri nuna antukar nukap nintimrar ii Apurin nekasampita tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS40_4","020_40_4","PSA","40","4","4","Aints Yusen nekasampita tinauka, tura Yusen umirtan nakitin ainaujai pachintsuk pujuinauka, tura wait chichamtin ainaujai tsaniitsuk pujuinauka nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_5","020_40_5","PSA","40","5","5","Apuru wina Yusur asam, amijai metekka ju nungkanmaka kichkisha atsawai. ¿Ami wainchati takatrum warutmak ainia? tusanka nekaachminuitjai. Timiá untsuri asaramtai, ami najankamurmin pachisan chichastatkaman tujintajai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_6","020_40_6","PSA","40","6","6","Aints amin chichartaminak: Tunaar tsangkutrurta tusar, tangku ainaun maawar, wina surusarti tusamka ameka wakeratsme. Antsu wina antutir kuwishur uratrukuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS40_7","020_40_7","PSA","40","7","8","Tura asakmin wisha amin timiajme: Yusru wina pachitas papinum aarmawa nunisnak ami wakeramurmin umiktasan taawitjai. Ami chichamem nintirun engkemawaitai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS40_9","020_40_9","PSA","40","9","10","Ami aintsrum untsuri iruntramunam wikia nekas chichaman nekamtikiamiajai. Apuru wikia ami chichammin pengké uukchamiaja nusha nekame. Wikia amin pachisan: Ni tímia nunaka miatrusnak umikuitjai. Nunia iincha tuke uwemtikramratnuitji timiajai. Ami aintsrum untsuri iruntramunam aminu anengkratairmin tu awai tusan nekamtikiamiajai. Turasha aminu chichamem nekas chicham asamtai, pengké uukchamiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_11","020_40_11","PSA","40","11","12","Wina wait wajamurka untsuri asaramtai, wikia nekapmartatkaman tujintajai. Tura asamtai Apuru tajame: Wait aneasam ami anengkratairum uutrukaip. Ami anengkratairumjai tura ami chichamijai yainkata. Wina tunaaruka wina intashru nangkamasang untsuri ainawai. Tura asan napchau nintimran jakamin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_13","020_40_13","PSA","40","13","13","Apuru wári tunaanumia angkanmamtikruata. Tura wári yainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS40_14","020_40_14","PSA","40","14","14","Aints wina mantuwartas wakerutinauka ame inatsaarta. Tura ame inatsaarmau asar, wina pasé awajtukartas wakerutina nuka natsaarar tupikiakiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_15","020_40_15","PSA","40","15","15","Wina wishikruraru ainauka natsaararu asar tupikiakiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_16","020_40_16","PSA","40","16","16","Antsu amin eatminauka amin nintimturmasar nukap warasartinuitai. Tura uwemrartas wakerin ainauka tuke amin pachitmasar: Yus juuntaitai turamiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS40_17","020_40_17","PSA","40","17","17","Antsu wi wait wajau asamtai, Apuru kajinmatrukiip. Yusru wina yainkatin asam, tura wina angkanmamtikruatin asam, wári yainkata tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS41_1","020_41_1","PSA","41","1","1","Aints kakaichu tura mianchau ainausha pengker awajinaunka Yuska pengker awajsatnuitai. Tura nisha wait wajamtaisha, Yuska angkanmamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_2","020_41_2","PSA","41","2","2","Tura niincha ejaktinuitai. Turasha ju nungkanam pujus pengker nintimias pujusti tusa, pujutan susatnuitai, tura warastinnasha susatnuitai. Tura ni nemase ainau niin itit awajsarai tusa surimkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_3","020_41_3","PSA","41","3","3","Tura najaimiak tepamtaisha, Yus kakamtikratnuitai. Tura ataksha tsaarti tusa inankitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_4","020_41_4","PSA","41","4","4","Tura asamtai wikia Apurun chicharkun: “Apuru wait anentruram wikia aminka umirchamaitiatmek, ataksha pengker wajasta tusam tsuwaarata” timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_5","020_41_5","PSA","41","5","5","Wina nemasur ainau wina pachitsar pasé chichartinawai. Tura inintrinak: “¿Warutik jaka mengkakat?” turutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_6","020_41_6","PSA","41","6","6","Tura wina jiirsartas wininayat, pengker nintimsarka wininatsui. Antsu pasé chichaman antukar chikich aintsnum wayaawar aujmatrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_7","020_41_7","PSA","41","7","7","Wina kajertin ainauka iruntrar wina pachitsar chichainak: “Ningki wiasmamak wait wajawai”, turutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_8","020_41_8","PSA","41","8","8","Tura ataksha chichainak: “Ni jatairingkia iwianchnumiayaintai. Ni peakrin jaak tepa auka pengké nantakchatnuitai” tusar aujmatrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_9","020_41_9","PSA","41","9","9","Turutinai wina nekas amikruka wikia: Wina nekas amikruitai tamaitiat, wijai yuya nuka wina nemasur wajasi. ");
INSERT INTO acuNT_vpl VALUES ("PS41_10","020_41_10","PSA","41","10","10","Antsu Apuru ame wait anentrurta, tura ataksha inantukta. Ame turakmin wina kajertin ainaun yapaijkiatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_11","020_41_11","PSA","41","11","11","Tura wina nemasur ainau wina nepetukcharamtaikia, amin pachisan Yusrun pengker awajnuyajai tusan nekaamnawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS41_12","020_41_12","PSA","41","12","12","Tura wikia tunaun takatsuk pujau asamtai, winaka tuke pengker awajtusta. Tura tuke wijai pujusti tusam waitkata. ");
INSERT INTO acuNT_vpl VALUES ("PS41_13","020_41_13","PSA","41","13","13","Apuru ami aintsrum ainauti Yusri asakmin, yamaisha tura tuke: Ameketme pengkeram tajame. Tu ati. ");
INSERT INTO acuNT_vpl VALUES ("PS42_1","020_42_1","PSA","42","1","1","Yusru japa kitamak entsan eaawa nunisnak amincha eajme. ");
INSERT INTO acuNT_vpl VALUES ("PS42_2","020_42_2","PSA","42","2","2","Yusru ameketme pujut sukartinmeka. Tura asakmin aints kitakjai wait wajak entsan eawa nunisnak amincha eajme. ¿Warutik ataksha ami jeemnisha wayaatnuitja? tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_3","020_42_3","PSA","42","3","3","Tura asan tsawaisha, tura kashisha yutancha yutsuk juutkun pujajai. Wi turamtai aints wina inintinak: ¿Yusrumsha pujawak? turutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_4","020_42_4","PSA","42","4","4","Tura nuna nintimsan, nukap wake mesekan pujakun: Yaanchuikia aints ainau warainak, Yusen maaketai tiartas ni jeen wearti tusan jeemiajai. Tura asamtai aints ainau fiestanam weenawa nunisrik Yus seati jeanam wemiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS42_5","020_42_5","PSA","42","5","5","¿Warukanak napchau nintimrataj? ¿Warukanak wake meseknasha pujustaj? Wikia Yusen nintimsan pujajai. Tura asan: Ameketme Yusem titatjai. Ningki wina Yusur asa uwemtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_6","020_42_6","PSA","42","6","6","Wikia wake mesekan napchau nintimsan pujajai. Tura asan amincha nukap nintimtusan pujakun, mura Hermón tutainum tura mura Mizar tutainum Yus pujatsuash, tura entsa Jordánka nujin ");
INSERT INTO acuNT_vpl VALUES ("PS42_7","020_42_7","PSA","42","7","7","túna uutmauri aa nuni Yus pujatsuash, tu nintimsan pujajai. Nu entsaka ame najanamiame nuni jakerua nunisnak wikia nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_8","020_42_8","PSA","42","8","8","Antsu tsawai wina Apurka ni anengkratairin nekamtikiartawai. Tura kashisha wina Yusur pujutan sukartinua nuna nintimtusan, tuke kantan kantamrakun, nuniasha Yusen seakun pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_9","020_42_9","PSA","42","9","9","Turayatun Yusrun chicharkun: Wina ejarin ayatmesha, ¿warukamtaiya winasha kajinmatrukniume? Wina nemasur ainauka wina itit awajtusaru asaramtai, ¿warukanak timiá wake meseknasha pujustaj? ");
INSERT INTO acuNT_vpl VALUES ("PS42_10","020_42_10","PSA","42","10","10","Wina nemasur ainauka wina inatsturartas kintajai metek inintinak: ¿Ami Yusrumsha pujawak? turutinawai. Tuke turutinau asaramtai, wina ukunchrusha najamrutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS42_11","020_42_11","PSA","42","11","11","¿Warukanak napchau nintimrataj? ¿Warukanak wake meseknasha pujustaj? Wikia Yusen nintimsan pujajai. Tura asan ameketme Yusem titatjai. Ningki wina Yusur asa uwemtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS43_1","020_43_1","PSA","43","1","2","Apuru wina Yusur asam, tura wina ejarin asam, wikia tunau takatan nakitau asamtai, aminu chichammin umirtamkacharu ainamunmaya ayamrutkata. Tura anangkartin ainamunmaya tura chikich pasé aints ainamunmaya angkanmamtikruata. Wina nemasur ainauka wina itit awajtusaru asaramtai, ¿warukanak timiá wake meseknasha pujustaj? ¿Warukamtaiya winasha kajinmatrukniume? ");
INSERT INTO acuNT_vpl VALUES ("PS43_3","020_43_3","PSA","43","3","3","Ami pujutirmin jeatnuka aminu jintim juwaitai tusam, tura aminu chichamem nekas aa nu paan nekamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS43_4","020_43_4","PSA","43","4","4","Yusru ame wina nukap waramtikrustin asakmin, wikia ami jeemin jean amincha: Ameketme Yusem tusan, kitarran tuntuyakun kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS43_5","020_43_5","PSA","43","5","5","¿Warukanak napchau nintimrataj? ¿Warukanak wake meseknasha pujustaj? Wikia Yusen nintimsan pujajai. Tura asan ameketme Yusem titatjai. Ningki wina Yusur asa uwemtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS44_1","020_44_1","PSA","44","1","1","Yusru ii juuntri ainau iincha ame yaanchuik turamurmin pachisar ujatmakaru asaramtai, iisha nuka antukuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_2","020_44_2","PSA","44","2","2","Tura asakrin amin umirtamchau ainia nuka ami kakarmarmijai ni nungkarinia jiikim wait wajaktin susam, ii juuntri ainau nuni pujusarti tusam, nu nungkaka ni susawitme. ");
INSERT INTO acuNT_vpl VALUES ("PS44_3","020_44_3","PSA","44","3","3","Antsu ni kakarmarijaingkia tura ni nangkirijaingkia ni nemase ainaunka nepetchau armiayi. Tura ningkikia ni nemase nungkarincha atankichu armiayi. Antsu ii juuntri ainau aneau asam paaniunam pujusam, ami kakarmarmijai turamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS44_4","020_44_4","PSA","44","4","4","Apuru ameka wina Yusruitme. Tura asam ami aintsrum ainauka ni nemase nepetkarti tusam, ami kakarmaram suyame. ");
INSERT INTO acuNT_vpl VALUES ("PS44_5","020_44_5","PSA","44","5","6","Tura asakmin iinu tishimkuri tura iinu nangkirisha nintimsar: Nujaingkia ii nemase ainaunka nepetkatatjiapi, tuuka nintimchau ayaji. Antsu ame iinka yaingkratkau asakmin, iin nepetamkartas wakeriarmia nuka ami chichammijai nepetnuyaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_7","020_44_7","PSA","44","7","7","Ii nemase ainau nepetnuyame nuka ametme. Tura iin suwirpiaku jiirmin armia nu inatsartinmeka ametme. ");
INSERT INTO acuNT_vpl VALUES ("PS44_8","020_44_8","PSA","44","8","8","Iisha ame pachisar tuke: Ameketme Yusem titinuitji. Turasha tuke ami naaram pachisar: Ameketme juuntam titinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_9","020_44_9","PSA","44","9","9","Antsu iinka nakikratkum inatskartame. Tura yamaikia ii suntari ainaujaingkia mesetnumka weatsme. ");
INSERT INTO acuNT_vpl VALUES ("PS44_10","020_44_10","PSA","44","10","10","Tura asakmin ii nemase ainau jiisar shamakur tuntupear ukuaji. Tura asakrin iin kajertaminak pujuinauka ii jeen wayaawar kasartaminak ni wakerina nuna juwinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS44_11","020_44_11","PSA","44","11","11","Tura asamtai uwijan maawartas juwina nunisarang iincha juramkiarti tusam tsangkamkartukmiame. Turasha amin umirtamchau ainamunam pachinkaram pujustaram tusam iinka ukukratkimiame. ");
INSERT INTO acuNT_vpl VALUES ("PS44_12","020_44_12","PSA","44","12","12","Tura ami aintsrum ainautin ii nemase nepetkarti tusam tsangkamkartukmame. Turayatum ameka aints ni warinchurin akikchaujai surawa nunismek iin surukratkamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS44_13","020_44_13","PSA","44","13","13","Tura iin pachitmasar pasé chichasarti tusam tsangkamkartukmame. Tura asakmin iin irutkau ainausha iincha itit awajtaminak wishikraminaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_14","020_44_14","PSA","44","14","14","Tura amin umirtamchau ainau iin wishikrarti tusam tsangkamkartukmame. Tura asakmin nu aints ainau iin waitmakar muuken pearar wishikraminaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_15","020_44_15","PSA","44","15","16","Tura wina nemasur ainau wina yapaijtukartas itit awajtusar pasé chichartinau asaramtai, wikia tuke natsaamakun pujajai. Tura nukap natsaamau asan, yapirka kapantran pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS44_17","020_44_17","PSA","44","17","17","Antsu iikia aminu chichamem tuke umirnuyaji. Tura ameka kajinmichuyaji. Tura waininayat iinka pasé awajtamsarmiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_18","020_44_18","PSA","44","18","18","Tura wainiatrik ame ukutka nakitnuyaji. Tura asar aminu jintimin tuke wekainuyaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_19","020_44_19","PSA","44","19","19","Tura wainiatum ameka ajapkartuam ukukratkimiame. Tura asakmin iikia teenam pujuinawa nunisrik pujumiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_20","020_44_20","PSA","44","20","20","Yusru iikia ame kajinmakir chikich yus, Yuschau wainiatur seakrincha, ");
INSERT INTO acuNT_vpl VALUES ("PS44_21","020_44_21","PSA","44","21","21","ameka mash aints ainau nintimaurisha nekau asam, nusha amek nekaamnawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS44_22","020_44_22","PSA","44","22","22","Antsu ame nemarin asakrin, uwijan maawartas juwinawa nunisarang kintajai metek iincha mantamawartas wakerutminaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_23","020_44_23","PSA","44","23","23","Apuru wait aneasam shintaram anturtukta. ¿Waruka kanurua nunismeksha pujame? Turam iincha tuke ajapkartuamka ukukratkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS44_24","020_44_24","PSA","44","24","24","¿Waruka aints anumak pujawa nunismeksha pujame? ¿Waruka ii timiá wait wajarnisha kajinmakratkinua nunismeksha pujame? ");
INSERT INTO acuNT_vpl VALUES ("PS44_25","020_44_25","PSA","44","25","25","Iikia maach nungkanam tepawa nunisrik natsaamakur napchau nintimsar pujaji. ");
INSERT INTO acuNT_vpl VALUES ("PS44_26","020_44_26","PSA","44","26","26","Apuru wajakim yaingkratkata. Tura iin nukap anengkratau asam, uwemtikiartukta tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS46_1","020_46_1","PSA","46","1","1","Yusketai iin ejarmaktinka. Tura iin kakamtikramratnuka nuketai. Ii shamakur pujakrincha, iin yainmaktinka nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS46_2","020_46_2","PSA","46","2","2","Tura asamtai nungka yumpunmataisha, tura mura ainau juun entsa kunarin ujungmau amataisha shamkashtinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS46_3","020_46_3","PSA","46","3","3","Tura juun entsa tampari timiá wej wajamtaisha, tura mura ainau Yuse kakarmarijai muchitinamtaisha shamkashtinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS46_4","020_46_4","PSA","46","4","4","Kichik entsa ni kanaichirijai Yus ni yaktarin pujuinaun waramtikui. Nu yaktaka chikich yakat ainaun nangkamasang nekas Yuse yaktarintai. ");
INSERT INTO acuNT_vpl VALUES ("PS46_5","020_46_5","PSA","46","5","5","Yuska nu yakta japen pujau asa, chikich aints ainaun yumpungkai tusa wainui. Kintajai metek tsawaaramtai, Yuska ni aintsri ainaun yayaawai. ");
INSERT INTO acuNT_vpl VALUES ("PS46_6","020_46_6","PSA","46","6","6","Yus chichaamtai, chikich nungkanmaya ainauka nuna antukar shiniinawai. Tura apu ainausha kurainawai. Tura nungkaka ningki yumpuunui. ");
INSERT INTO acuNT_vpl VALUES ("PS46_7","020_46_7","PSA","46","7","7","Yus timiá kakaram aa nuka iijai pujawai. Jacobo Yusringkia iin ejarmaktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS46_8","020_46_8","PSA","46","8","8","Yus wainchati takatan mash nungkanam turamia nuka jiitaram. ");
INSERT INTO acuNT_vpl VALUES ("PS46_9","020_46_9","PSA","46","9","9","Mash nungka ainamunam meset inaisataram tusa surimrukmiayi. Tura asa tishimuk ainaun kupikmiayi. Tura nangki ainauncha charukmiayi. Nuniasha mesetnum wekaatai ainauncha keemakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS46_10","020_46_10","PSA","46","10","10","Nintimrataram. Turasha juuwaitai Yus tusaram nekarataram. Yus chichaak: Wikia mash nungkanmaya ainaun inawaitjai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS46_11","020_46_11","PSA","46","11","11","Yus timiá kakaram aa nuka iijai pujawai. Jacobo Yusringkia iin ejarmaktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS47_1","020_47_1","PSA","47","1","2","Yus nayaimpinam puja nuka nekas kakarmaitai. Mash nungka ainia nuna Apurintai. Tura asamtai mash yaktanmaya ainautiram atumi Yusri wararkuram uwejem awattitaram. Turasha kakarum untsuakrum atumi Yusri warartustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS47_3","020_47_3","PSA","47","3","3","Yuska chikich nungkanmaya ainaun nepetak iincha: Atum inartaram tusa tsangkatramkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS47_4","020_47_4","PSA","47","4","4","Yuska Jacobon aneau asa, ni weari ainautinka: Nungka nekas pengkernum pujustaram tusa suramsamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS47_5","020_47_5","PSA","47","5","5","Yuse aintsri ainau warainak tura untsuminak tura pupunan pupuntrinak pujuinai, Yus ni keemtairin keemsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS47_6","020_47_6","PSA","47","6","6","Yus pachisrum kanta kantamataram. Ii Apuri pachisrum kanta kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS47_7","020_47_7","PSA","47","7","7","Mash nungkanmaya ainau Apuri asamtai, pengker nintimsaram Yus pachisrum kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS47_8","020_47_8","PSA","47","8","8","Yuska mash nungkanmaya ainau Apuri asa, ni keemtairin nekas pengkernum pujawai. ");
INSERT INTO acuNT_vpl VALUES ("PS47_9","020_47_9","PSA","47","9","9","Ju nungkanmaya apu ainauka Yusnau ainawai. Tura asamtai mash ainia nuna Yuska inawai. Tura asamtai chikich nungkanmaya apu ainauka Abrahama Yusri aintsri ainaujai iruninawai. ");
INSERT INTO acuNT_vpl VALUES ("PS48_1","020_48_1","PSA","48","1","1","Ii Apuringkia juuntaitai. Ni yaktarin pujuinautikia tura ni murarin nekas pengker aa nuni kaunkarutikia ii Yusri: Ameketme juuntam titinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS48_2","020_48_2","PSA","48","2","2","Yakta pajenini mura Sión tutai timiá pengkeraitai. Apu nekas kakaram aa nuna yaktari asamtai, mash nungka ainau warartutintai. ");
INSERT INTO acuNT_vpl VALUES ("PS48_3","020_48_3","PSA","48","3","3","Yuska yakat Jerusalénnumia ainau matsamtainum pujawai. Turasha wikia atumin ejaktinuitjarme tusa, ni aintsri ainautin nekamtikramamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS48_4","020_48_4","PSA","48","4","4","Apu ainau Jerusalén yumpungtai tusar kaunkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS48_5","020_48_5","PSA","48","5","5","Antsu nu yaktanka wainkar shaminak tupikiakiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS48_6","020_48_6","PSA","48","6","6","Tura sapijminak kurainiarmiayi. Nuniasha nuwa uchin jateemawa nunisarang najaimin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS48_7","020_48_7","PSA","48","7","7","Yus tsaa taakmanumanini nasen kakarman akupak, yakat Tarsisnumia juun kanu ainaun kupiawa nunisang nu apu ainaunka kiishmakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS48_8","020_48_8","PSA","48","8","8","Ii yaanchuik antukmiaji nunaka miatrusang umiku wainkamiaji: Yuska timiá kakaram asa, ni yaktarin Jerusalénnum pujuinaunka tuke inaitsuk wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS48_9","020_48_9","PSA","48","9","9","Yusru ami jeemin wayaarkia, aminu anengkratairum tuke nintimu weaji. ");
INSERT INTO acuNT_vpl VALUES ("PS48_10","020_48_10","PSA","48","10","10","Yusru ame timiá juun asakmin, mash nungkanmaya ainau amin naarmin pachisar: Ameketme juuntam turaminawai. Ame timiá kakaram asam, aints ainausha tuke inawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS48_11","020_48_11","PSA","48","11","11","Mura Sión tutainum pujuinauka warasarti. Tura ame aints ainaun pengker inau asakmin, Judá yaktarin pujuinauka nukap warasarti. ");
INSERT INTO acuNT_vpl VALUES ("PS48_12","020_48_12","PSA","48","12","14","Ii Yusringkia tuke pujawai. Ningki iinka jintintramak pujustinuitai. Sión mura tentakrum jea jeamkamuri ainau tura kayajai wenurmaurisha jiisrum, ukunam akiinawartin ainauka nekaawarti tusaram etserkatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PS49_1","020_49_1","PSA","49","1","2","Mash nungkanam pujuinautiram, kuikiartin ainautiram tura kuikiartichu ainautirmesha, nunia miajuitjai tumamin ainautiram tura mianchau ainautirmesha, ju chichamka tenapkesrum antuktaram. ");
INSERT INTO acuNT_vpl VALUES ("PS49_3","020_49_3","PSA","49","3","3","Yamaikia Yuse nekamtairin pachisan chicham yumtin ainaun nekamtikiatjarme. ");
INSERT INTO acuNT_vpl VALUES ("PS49_4","020_49_4","PSA","49","4","4","Kitarran tuntuikiamaikiakun chichaman nekaachminun kantamkun nekamtikiatjarme. ");
INSERT INTO acuNT_vpl VALUES ("PS49_5","020_49_5","PSA","49","5","5","Pasé kinta jeamtaisha, tura wina nemasur ainau tentatkaramtaisha ¿warukanak shamkataj? ");
INSERT INTO acuNT_vpl VALUES ("PS49_6","020_49_6","PSA","49","6","6","Nu aints ainauka ni kuikiarin nintimsar: Wikia yuumakchatatjai tinawai. Nuniasha wikia nukap warinchurtinuitjai tumaminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_7","020_49_7","PSA","49","7","7","Antsu aints kichkisha ningkikia uwemrachartinuitai. Tura Yus uwemtikrurti tusarka kuikianka kichkisha akiimiakchartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_8","020_49_8","PSA","49","8","9","Tuke jatsuk pujusmi tusarkia, kuikiajaingkia pengké akiimiatmamkachminuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS49_10","020_49_10","PSA","49","10","10","Aints nintip ainauka tura nintinchau ainausha mash metek jainawai. Tura ni kuikiarinka chikichan ukurinawai tusar, paan nekaamnawaitji. ");
INSERT INTO acuNT_vpl VALUES ("PS49_11","020_49_11","PSA","49","11","11","Aints ni nungkarin tura ni yaktarin ni naarijai inaikiamu ainayat, ni tuke iwiarsamurin matsamsartin ainawai. Tura tuke mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_12","020_49_12","PSA","49","12","12","Aints ainauka kuikiartin ainayat, tukeka pujuschartin ainawai. Antsu kuntin jaina nunisarang jakaartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_13","020_49_13","PSA","49","13","13","Aints ningki nintimtumasar: Wikia kuikiartinuitjai tumamin ainauka tuke mengkaakartin ainawai. Tura miajuitjai tumamin ainausha nunisarang tuke amukartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_14","020_49_14","PSA","49","14","14","Aints miajuitjai tumamin ainau kakarmaringkia yaitas mengkawai. Tura asar tuke iwiarnastinnum jeainawai. Uwija wainin ni uwijarin achik juwawa nunisang jataka nu aints ainaunka achiktinuitai. Tura asamtai ukunam pengke aints ainau jakamunmaya nantakiar, nu pasé aints ainaun inarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_15","020_49_15","PSA","49","15","15","Antsu winaka Yus jakamunmaya uwemtikrurtinuitai. Tura ni pujamurin juruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_16","020_49_16","PSA","49","16","16","Chikich aints kuikiartin asa, ni jeen warinchu untsuri itau wainkurmesha napchauka nintimrairap. ");
INSERT INTO acuNT_vpl VALUES ("PS49_17","020_49_17","PSA","49","17","17","Nuna turinutiat ni jaakka, ninu aa nunaka kichkisha jukichminuitai. Tura ni warinchuri ainauncha ni iwiarnatniurinka jeekachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_18","020_49_18","PSA","49","18","18","Ni iwiaaku pujakka kuikiartin asa nukap waraawai. Tura kuikiartin asamtai, chikich aints ainau pengker nintimtuti ayat, ");
INSERT INTO acuNT_vpl VALUES ("PS49_19","020_49_19","PSA","49","19","19","ni jakatniuri kintaka jeartinuitai. Turamtai nuniangka paaniunka pengké wainkashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS49_20","020_49_20","PSA","49","20","20","Aints ainauka kuikiartin ainayat, tukeka pujuschartin ainawai. Antsu kuntin jaina nunisarang jakaartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_1","020_50_1","PSA","50","1","1","Ii Apuringkia mash aints ainau yusri Yusrintai. Ni tsaa taakmanumaninisha tura tsaa jeamunmaninisha mash nungkanam pujuinaun chicharkamia nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_2","020_50_2","PSA","50","2","2","Yus ni yaktari Sión tutainum timiá pengker aa nuni pujus ni paaniurincha akupawai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_3","020_50_3","PSA","50","3","3","Ii Yusringkia tatinuitai. Antsu winakka takamtaikia winishtinuitai. Tura ni tatintri jeatsaing, ji tsuweran eemak akupkatnuitai. Turamtai ipiamat kakaram niinka tenteatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_4","020_50_4","PSA","50","4","4","Yuska yakiiya chichaak: “Wina aintsur turamuri jiirmatai, atumsha jiitaram” tusa, nayaimpinam tura nungkanam pujuinauncha untsuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_5","020_50_5","PSA","50","5","5","Tura untsuak: “Wina umirtukaru ainauka wina umirtukartas tangkurin main armia nuka irurtaram” titinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_6","020_50_6","PSA","50","6","6","Yus tamati nayaimpinam pujuinauka: Yus aints ainaun tunaarin nekamtikin asa, nekas pengkeraitai tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_7","020_50_7","PSA","50","7","7","Yus Israel ainautin chichartamak: “Wina aintsur ainautiram anturtuktaram. Atumjaingkia tépaan chichastatjarme: ¡Wikia Yusetjai, atumi Yusrinjai! ");
INSERT INTO acuNT_vpl VALUES ("PS50_8","020_50_8","PSA","50","8","8","Atumi tangkuri maaram tuke epee wearme nuna pachisnaka: Nuka paseetai tatsujrume. ");
INSERT INTO acuNT_vpl VALUES ("PS50_9","020_50_9","PSA","50","9","9","Turasha wikia atumniaka: Waaka uchiri maaram, tura chipu aishmangkrisha maaram wina surustaram tatsujrume. ");
INSERT INTO acuNT_vpl VALUES ("PS50_10","020_50_10","PSA","50","10","10","Kuntin ainau tura tangku ainau muranam irunuka mash winar ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_11","020_50_11","PSA","50","11","11","Muranam nanamin ainausha tura paka nungkanam yujainausha mash winar ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS50_12","020_50_12","PSA","50","12","12","Mash nungka ainauka winar ainawai. Tura mash nungkanam iruna nusha winar asaramtai, wi tsukamakun pujaknasha atumniaka ujakchatnuitjarme. ");
INSERT INTO acuNT_vpl VALUES ("PS50_13","020_50_13","PSA","50","13","13","¿Wikia waaka namangken yuukitaj? ¿Tura chipu numpen uminkitaj? ");
INSERT INTO acuNT_vpl VALUES ("PS50_14","020_50_14","PSA","50","14","14","Nunaka pengké yuumatsjai. Antsu winaka tuke maaketai turuttiaram tusan nunak wakerajai. Tura wi turatatjai turutmiarume nuke umiktaram. ");
INSERT INTO acuNT_vpl VALUES ("PS50_15","020_50_15","PSA","50","15","15","Shamakrum pujakrumka wina seattiaram. Turuakrumningkia wikia atumin angkanmamtikiatatjarme. Wi turamtai atumka wina warartursataram”, Yus turamji. ");
INSERT INTO acuNT_vpl VALUES ("PS50_16","020_50_16","PSA","50","16","17","Antsu pasé aints ainaun Yus chicharak: “Atumi tunaari inaisataram tamaitiatrum, nu antut nakitau asaram, wina chichamur tuntupearam ukuarme. Tura asaram wina chichamur etserkachmin ayatrumsha ¿warukaya wina chichamrusha etserume? ");
INSERT INTO acuNT_vpl VALUES ("PS50_18","020_50_18","PSA","50","18","18","Atumka kasa ainau wainkaram nujai amikmaram, tura kajmin ainausha wainkaram nujai iruntraram pujarme. ");
INSERT INTO acuNT_vpl VALUES ("PS50_19","020_50_19","PSA","50","19","19","Tura pasé chicham chichastasrum atumi jangke awaa wearme. ");
INSERT INTO acuNT_vpl VALUES ("PS50_20","020_50_20","PSA","50","20","20","Tura atumi yachí pachisrum aujmatu wearme nunia jiyaa wearme. ");
INSERT INTO acuNT_vpl VALUES ("PS50_21","020_50_21","PSA","50","21","21","Nunaka mash nekayatun wikia chichakchamiajai. Atumek nintimsaram: Yuska iijai metekaitai tarume. Tu nintimu asakrumin atumin wiasmatkatatjarme. Tura atumi nintimaurincha tu awai tusan nekamtikiatatjarme. ");
INSERT INTO acuNT_vpl VALUES ("PS50_22","020_50_22","PSA","50","22","22","Atum wina kajinmatrukrum pujau asaram, tenapkesrum anturtuktaram. Antsu wina anturtutsuk pujakrumningkia, wikia atumin tsairtinuitjarme. Wi turamtaisha ¿yáki atumnasha uwemtikramrarat? ");
INSERT INTO acuNT_vpl VALUES ("PS50_23","020_50_23","PSA","50","23","23","Antsu wina maaketai turutinauka winaka waramtikrusartin ainawai. Tura wina jintarun wekainaunka wikia uwemtikratnuitjai”, Yus tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS51_1","020_51_1","PSA","51","1","1","Yusru ame timiá wait anengkratin asam, wait anentrurta. Tura timiá pengker asam, wina tunaaruka tsangkutrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS51_2","020_51_2","PSA","51","2","2","Wi tunau asamtai nintir nijatrurta. Tura pasé aints asamtai nintir japitrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS51_3","020_51_3","PSA","51","3","3","Wikia ami chichamin umirkachuitjai tusan nekajai. Tura wina tunaarunka tuke nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS51_4","020_51_4","PSA","51","4","4","Ameka jiimia pujamning, ame nakitame nuna takasmiajai. Tura asan ame tunaawaitme turutme nunaka nekasaintai tajame. Tura ame tunau asam wait wajaktatme turutme nunasha pengkeraitai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS51_5","020_51_5","PSA","51","5","5","Wikia nekasan akiinamunmayang tunaawaitjai. Tura nukuru muntsurin muntsuyaja nuning tunau ayajai. ");
INSERT INTO acuNT_vpl VALUES ("PS51_6","020_51_6","PSA","51","6","6","Tu ataing nekasam pengke nintintin ata tusam wakerutame. Tura asam paan nintimratnusha surusuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS51_7","020_51_7","PSA","51","7","7","Tura asamtai wisha seajme: Wina nintir japitrurta. Turutakminkia tunaarinchau wajastatjai. Turasha tunaar tsangkutrurta. Turutakminkia angkan wajastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS51_8","020_51_8","PSA","51","8","8","Tura tunaawitme turutiatmek ataksha waramtikrusta tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS51_9","020_51_9","PSA","51","9","9","Wina tunaar ainauka mengkaatrukta. Tura wina pasé turutir ainausha mash sakturata. ");
INSERT INTO acuNT_vpl VALUES ("PS51_10","020_51_10","PSA","51","10","10","Yusru nintir tunaarinchau awajtursata. Turasha yamaram nintimau tupin nintimratin aa nu surusta. ");
INSERT INTO acuNT_vpl VALUES ("PS51_11","020_51_11","PSA","51","11","11","Aminka jiitnaka nakitajme turutiip. Tura ami Wakanim pengker aa nu jurutrukiip. ");
INSERT INTO acuNT_vpl VALUES ("PS51_12","020_51_12","PSA","51","12","12","Tura nekasan uwemrawaitjai, tu nintimsan warastinka ataksha surusta. Tura ami pengker Wakanmijai kakamtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS51_13","020_51_13","PSA","51","13","13","Tura asakmin ami chichammin umirtan nakitinaunka ataksha ami jintimin wekaasarti tusan jintintawartinuitjai. Tura asamtai tunaarintin ainau ni tunaarincha inaisar aminak umirtamkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS51_14","020_51_14","PSA","51","14","14","Yusru wina uwemtikruru asam, aints maawaip tusam ame surimrukta. Turakmin amin pachisan: Aints pengker inawaitme tusan kantan kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS51_15","020_51_15","PSA","51","15","15","Apuru wina jangker uratriniakminkia amin: Ameketme pengkeram tusan kantan kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS51_16","020_51_16","PSA","51","16","16","Ame tangku maata turutkumningkia, nunaka umiktinuitjai. Tura tangku epeata turutkumnisha wikia turamnawaitjai. Turayatun nujaingkia pengkerka awajsachainjame. ");
INSERT INTO acuNT_vpl VALUES ("PS51_17","020_51_17","PSA","51","17","17","Antsu Yus asam, ame nekasam wakerame nuka juwaitai: Aints tunau asa, miajuitjai tumamtsuk, antsu napchau nintimias: Tunaawapitja tusa ni tunaarin inais, amin nintimturmas pujauka, Yusru nu aintsnaka tsuutajai pengké tichatatme. ");
INSERT INTO acuNT_vpl VALUES ("PS51_18","020_51_18","PSA","51","18","18","Ame wakerau asam, Sión yaktaka pengker awajsata. Tura kayajai wenukri ataksha inankiarti tusam tsangkamkata. ");
INSERT INTO acuNT_vpl VALUES ("PS51_19","020_51_19","PSA","51","19","19","Turakmin tangkun maawar epee armia nuna ataksha turinamtai, nuka pengkeraitai titatme. Turasha amin suramsartas epeena nuka jiisam, pengkeraitai titatme. Nu turakminkia tangku epetinam ataksha waaka uchirin epetan nangkamawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS52_1","020_52_1","PSA","52","1","1","¿Warukaya timiá kakaram autiatmesha pasé turamiame nu pachismesha wi aitkajai tame? ¡Yuse wait anengkratairingkia nangkaankashtinuitai! ");
INSERT INTO acuNT_vpl VALUES ("PS52_2","020_52_2","PSA","52","2","2","Ameka tuke tunau nintimsam pujau asam, ami inaijmikia kuchí ere tsakamua tumawaitai. Tumau asamtai anangkartutai chicham chichaame. ");
INSERT INTO acuNT_vpl VALUES ("PS52_3","020_52_3","PSA","52","3","3","Pengker aa nuka nintimtsuk pasé aa nuke timiá nintimme. Turakum nekas chichamka wakerutsuk, wait chichama nuke wakerame. ");
INSERT INTO acuNT_vpl VALUES ("PS52_4","020_52_4","PSA","52","4","4","Anangkartutai chicham chichau asam, tuke pasé chicham aa nuke timiá wakerame. ");
INSERT INTO acuNT_vpl VALUES ("PS52_5","020_52_5","PSA","52","5","5","Tura asakmin Yus amincha tuke mengkaatmaktinuitai. Tura amin achirmak ami jeemnia jiirmaki mantamaatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS52_6","020_52_6","PSA","52","6","6","Yusen umirin ainau nuna wainkar shamkartin ainawai. Antsu nu aintsun pachisar wishikinak: ");
INSERT INTO acuNT_vpl VALUES ("PS52_7","020_52_7","PSA","52","7","7","Au aintska jiistaram. Nuka Yus ayamrukmaunka nintimtsuk, antsu ni kuikiarin nintimias tuke tunaun nintimui tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS52_8","020_52_8","PSA","52","8","8","Antsu wikia numi olivo samek wajawa nunisnak Yuse jeen pujajai. Tura asan wikia tuke Yuse anengkratairin nintimratatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS52_9","020_52_9","PSA","52","9","9","Yusru ami turamurmin pachisan tuke maaketai titatjame. Ame pengker asakmin, amin umirtaminak pujuinamunam tuke amincha nintimtustatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS54_1","020_54_1","PSA","54","1","1","Yusru uwemtikrurta tusan, amin naarmin pachisan seajme. Tura ami kakarmarmijai ayamrutkata. ");
INSERT INTO acuNT_vpl VALUES ("PS54_2","020_54_2","PSA","54","2","2","Yusru wina seamur anturtukta. Tura wina chichaamur tenapkesam anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS54_3","020_54_3","PSA","54","3","3","Mangkartin ainau: Wikia miajuitjai tumamina nuka wina mantuwartas wakerutinak aminka nintimturminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS54_4","020_54_4","PSA","54","4","4","Turutinau wainiatun wiki nintimsanak: Wina Yusur winaka yaintui. Tura wina Apur iwiaaku pujusti tusa winaka waitui, tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS54_5","020_54_5","PSA","54","5","5","Wina nemasur ainauka timiá pasé pujuinau asaramtai, Yusur ningki yapaijkiatnuitai, tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS54_6","020_54_6","PSA","54","6","7","Apuru ame tuke pengker asam, nu aints ainau mengkaakarta. Ameka wi shamrumtinnum pujai, angkantin awajtusmame. Nu turau asam, wina nemasur nepetkamame nunasha wainkamjai. Tura ame pengker asakmin, wiki nimtimsanak tangkurun maan amin susatasan epeatatjai. Nunia amin naarmin pachisan warartustatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS55_1","020_55_1","PSA","55","1","1","Yusru wi seajme nu anturtukta. Wi seamur anturtutskeka pujusaip. ");
INSERT INTO acuNT_vpl VALUES ("PS55_2","020_55_2","PSA","55","2","3","Antsu pengker nintimtursam airkata. Wi napchau nintimsan pujau asan tajame: Wina nemasur ainau chichainamurin tura pasé aints ainau shiniinamurin antukan kuraajai. Nu aints ainauka wait wajaktiniun untsuri surusar, kajertukar nepetukartas wakerutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_4","020_55_4","PSA","55","4","4","Tura asamtai wina nintirka sapijmiakun nukap teetui. Wikia jakatatjapi tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_5","020_55_5","PSA","55","5","5","Tura tenukap shamau asan, sapijmiakun kuraajai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_6","020_55_6","PSA","55","6","6","Tura asan yapangkam nanamina nunisnak nanamin akunka, nanaminapi ayamsainja tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_7","020_55_7","PSA","55","7","7","Tura nanamnuitkunka arák wena aints atsamunam pujusminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_8","020_55_8","PSA","55","8","8","Tura nase kakarman nasenmataikia, tura ipiamtasha untsuri patinamtaisha, nanamin akunka anumkatasan wári tupikiakminuitjai, tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_9","020_55_9","PSA","55","9","9","Apuru wikia mangkartin ainau turamurin wainkan, tura ni maaniamurincha wainkau asamtai, wina nemasur ainau mengkaakarta, tura ni chichamesha nuwamtikiarta. ");
INSERT INTO acuNT_vpl VALUES ("PS55_10","020_55_10","PSA","55","10","10","Nu mangkartin ainau tsawaisha tura kashisha yaktanam wekajinawai. Tura asar yaktanam tuke pasé aa nuna turinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_11","020_55_11","PSA","55","11","11","Nu yaktanmaka aya mangkartutiri tura waitrutiri nukap ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_12","020_55_12","PSA","55","12","12","Wina nemasruka winaka paseenaka awajtuscharmayi. Nu pasé awajtinamtaisha wikia tsantramnauyajai. Tura wina kajertin ainausha winaka eatkacharmayi. Wina eatinamtaisha wikia anumkamnauyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_13","020_55_13","PSA","55","13","13","Antsu nuka nekas wina tsaniakmauruketai. Turasha wina nekas amikur ayayi. ");
INSERT INTO acuNT_vpl VALUES ("PS55_14","020_55_14","PSA","55","14","14","Nijai pengker nintimsar chichasmi tusar, tuke Yuse jeen irunnuyaji. Tura nijai aints iruntramunmasha wekainuyaji. ");
INSERT INTO acuNT_vpl VALUES ("PS55_15","020_55_15","PSA","55","15","15","Wina nemasur ainau aneachmau jakaarti. Ni ninti tunau piaku asaramtai, iwiaaku ainayatang jakau iwiarsamunam ayaararti. ");
INSERT INTO acuNT_vpl VALUES ("PS55_16","020_55_16","PSA","55","16","16","Antsu wikia Yusen seatatjai. Wi turamtai wina Apur uwemtikrurtatui. ");
INSERT INTO acuNT_vpl VALUES ("PS55_17","020_55_17","PSA","55","17","17","Kashiksha tura tsaa tupnisha tura kashisha Apurun untsukan seatatjai. Wi untsuam wina chichamrun anturtuktatui. ");
INSERT INTO acuNT_vpl VALUES ("PS55_18","020_55_18","PSA","55","18","18","Wina nemasur untsuri au wainiatang wina Apurka angkan awajtustatui. Tura maawarai tusa uwemtikrurtatui. ");
INSERT INTO acuNT_vpl VALUES ("PS55_19","020_55_19","PSA","55","19","19","Wina nemasur ainauka Yusnasha nintimtsuk pujuinau asar, ni pujutrinka yapajiachartin ainawai. Turinau wainiatang Yus aints ainaun tuke ina nuka wina nemasur ainaun inatsaartatui. Turak winasha anturtuktatui. ");
INSERT INTO acuNT_vpl VALUES ("PS55_20","020_55_20","PSA","55","20","20","Tura amikmami tinayat, nu chichamnaka umiinatsui. Antsu ni amikrinak maawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_21","020_55_21","PSA","55","21","21","Ni chichamenka jaimiasar chichainayat, mesetan nintimin ainawai. Ni chichamenka antujamniau chichainayat, nangki tsakamua tumau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS55_22","020_55_22","PSA","55","22","22","Aints Yusen umirak pujaunaka ayaarti tusangka, Yuska pengké tsangkatkashtatui. Tura asamtai ame napchau nintimsam pujamurminka ii Apuri jurutkiti tusam tsangkatkata. Ame turakminka ukurmakchatatui. ");
INSERT INTO acuNT_vpl VALUES ("PS55_23","020_55_23","PSA","55","23","23","Yusru mangkartin ainau tura wait chichaman chichau ainau chikich aints ainaujai metekka nukapka pujuschartin ainawai. Ameka nu aints ainau jakaar iwiarsamunam ayaararti tusam akupkatnuitme. Antsu wikia amin nintimtajme. ");
INSERT INTO acuNT_vpl VALUES ("PS56_1","020_56_1","PSA","56","1","1","Yusru aints ainau wina papeetinau asaramtai, wait anentrurta. Kintajai metek wina nepetukartas wakerutinawai. Tura asar napchau nintimtikrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_2","020_56_2","PSA","56","2","2","Kintajai metek wina papeetinawai. Untsuri aints miajuitjai tusar, wina nepetukartas wakerutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_3","020_56_3","PSA","56","3","3","Tura asaramtai shamaknasha tuke amin nintimtajme. ");
INSERT INTO acuNT_vpl VALUES ("PS56_4","020_56_4","PSA","56","4","4","Yusrun nekasampita tau asan ni chichamen wararjai. Yusrun nekasampita tau asan shamkartatsjai. ¿Aints ainausha winasha itiurtukarting? ");
INSERT INTO acuNT_vpl VALUES ("PS56_5","020_56_5","PSA","56","5","5","Wina nemasur ainauka kintajai metek ni chichamejai wina pasé nintimtikrinawai. Nuka tuke wina pasemamtikrurartas nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_6","020_56_6","PSA","56","6","6","Tura anumkar tuke wekaaturinawai. Tura wina mantuwartas nakarinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_7","020_56_7","PSA","56","7","7","¿Ni pasé turamurin inaisartimpiash? Yusru ame kajekmaurumjai nu tunau aints ainauka mengkaakarta. ");
INSERT INTO acuNT_vpl VALUES ("PS56_8","020_56_8","PSA","56","8","8","Wi tupikiakmiaurusha ameka mash nekaamame. Turasha wina neaikirka mash nekapmame. ¿Wina neaikir ami papirumin mash aarchamukai? ");
INSERT INTO acuNT_vpl VALUES ("PS56_9","020_56_9","PSA","56","9","9","Wi yainkata tusan seamtai, wina nemasur ainauka waketinawai. Waketinau asaramtai Yuska wijai pujawai tusan nekajai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_10","020_56_10","PSA","56","10","10","Yusur wina Apur asamtai, nekasampita tau asan ni chichamen wararjai. ");
INSERT INTO acuNT_vpl VALUES ("PS56_11","020_56_11","PSA","56","11","11","Yusrun nekasampita tau asan shamkartatsjai. ¿Aints ainausha winasha itiurtukarting? ");
INSERT INTO acuNT_vpl VALUES ("PS56_12","020_56_12","PSA","56","12","13","Yusru wikia jakatniunam pujaing, tuke ami paaniurmin iwiaaku pujustinnum pujusmi tusam uwemtikrurmame. Turasha ayaartinnumiasha angkan awajtusmame. Tura asamtai wi amin turatatjai timiaja nunaka amin wararkun umiktinuitjai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS57_1","020_57_1","PSA","57","1","1","Yusru wait anentrurta. Tura ayamrutkata tusan seajme. Shamrumtin ainau nangkamarti tusan ami kakarmarmin ejamkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_2","020_57_2","PSA","57","2","2","Yus timiá juun aa nuna wina yainkatin asamtai untsuktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_3","020_57_3","PSA","57","3","3","Yus ni wait anengkratairin tura ni chichamen nekas aa nuna nayaimpinmayan akupkatatui. Tura wina kajertinak papeetinamtaisha uwemtikrurtatui. ");
INSERT INTO acuNT_vpl VALUES ("PS57_4","020_57_4","PSA","57","4","4","Juun yawaa aintsun esai yuwinawa tumaunum wikia nungkanam ajuarmawaitjai. Nu aints ainau naingkia nangkia tumau ainawai, turasha wachia tumau ainawai. Tura ni inajingkia saapi tsakamua tumau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_5","020_57_5","PSA","57","5","5","Yusru ameka nayaimpisha nangkaikim pujuuwitme. Aminu paaniurmeka mash nungka ainaun tinamui. ");
INSERT INTO acuNT_vpl VALUES ("PS57_6","020_57_6","PSA","57","6","6","Wina nemasur ainau wina pasé nintimtikrurartas aints ejatkajai achikmi tinawa nunisarang armiayi. Tura waanam ujuarmi tinawa nunisarang armiayi. Turinayat waan wina tautriniarmia nuni ningki ayaararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS57_7","020_57_7","PSA","57","7","7","Yusru wina nintirjai amincha kantan kantamruatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_8","020_57_8","PSA","57","8","8","Kinta yama tsawaa nuning wisha shintartatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_9","020_57_9","PSA","57","9","9","Apuru aints untsuri iruntramunam kantan kantamkun amincha wararsatatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS57_10","020_57_10","PSA","57","10","10","Ami anengkratairumka nayaimpinam jeawai. Tura ami pengkeerumka nayaim kingkiaya nuni jeawai. ");
INSERT INTO acuNT_vpl VALUES ("PS57_11","020_57_11","PSA","57","11","11","Yusru ameka nayaimpisha nangkaikim pujuuwitme. Aminu paaniurmeka mash nungka ainaun tinamui. ");
INSERT INTO acuNT_vpl VALUES ("PS59_1","020_59_1","PSA","59","1","1","Yusru wina nemasur ainamunmaya angkanmamtikruata. Tura wina nepetukartas wakerutina nunia uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS59_2","020_59_2","PSA","59","2","3","Aints kakaram ainau wina mantuwartas nakarinawai. Tura asamtai pasé turina nunia angkanmamtikruata. Turasha mangkartin ainamunmaya uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS59_4","020_59_4","PSA","59","4","4","Apuru wikia ami chichamminka umirtanka nakitchau ayajai. Tura tunaanasha takachu ayajai. Turai waitinayat wina nepetukartas wakerutinawai. Apuru wajakim wina ingkiunkam jiirsata. ");
INSERT INTO acuNT_vpl VALUES ("PS59_5","020_59_5","PSA","59","5","5","Apuru ameka timiá kakaram asam, tura ii Yusri asam, amin umirtamchau ainau ni wait wajakartintri susarta. Nu pasé aints ainau chikich ainaun anangkawar surukartas wakerina nuka wait anentsuk asarta. ");
INSERT INTO acuNT_vpl VALUES ("PS59_6","020_59_6","PSA","59","6","6","Kashi yawaa ainminawa nunisarang yaktan tentakar wekajinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS59_7","020_59_7","PSA","59","7","7","Turasha kuchi kajeak sauran apawa nunisarang ainawai. Turasha wishiinak: “¿Yaachik iincha anturtamkataij?” tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS59_8","020_59_8","PSA","59","8","8","Tura wainiatum Apuru ameka nu amin umirtamchau ainauka wishiku pujame. ");
INSERT INTO acuNT_vpl VALUES ("PS59_9","020_59_9","PSA","59","9","9","Yusru ameka wina kiakatratnuitme, turasha wina ayamrutkatnuitme. Tura asakmin wikia amin ejamkatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS59_10","020_59_10","PSA","59","10","10","Yusru wina anentu asam, wijai ingkiuniktinuitme. Turasha wina nemasur ainaun nepetkatin inaktursatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS59_11","020_59_11","PSA","59","11","11","Wina aintsur ainau kajinmakiarai tusam, wina nemasur ainau maatka maawaip. Antsu niish niish tupikiakiarti tusam, ami kakarmarmijai akupkarta, turasha inatsaarta. Ii Apuri asam, iin ayamrutmaktinmeka ametme. ");
INSERT INTO acuNT_vpl VALUES ("PS59_12","020_59_12","PSA","59","12","12","Nu pasé aints ainauka tuke tunau chichaman chichainak: Wikia miajuitjai tumamsar wait chichaman chichainau asar, achikmawa nunisarang arti. ");
INSERT INTO acuNT_vpl VALUES ("PS59_13","020_59_13","PSA","59","13","13","Yusru ame kajekmaurumjai nu aints ainauka wári amukarta. Ame turakmin Jacobo Yusringkia ni nungkari Apurintai tusar nekaawarti. Tura mash nungka ainau Apuringkia Yusketai tusar nekaawarti. ");
INSERT INTO acuNT_vpl VALUES ("PS59_14","020_59_14","PSA","59","14","15","Nu pasé aints ainauka kashi yaktanam taar, yawaa ainminawa nunisarang yaktanam yutain eainaksha wainkachar juutiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS59_16","020_59_16","PSA","59","16","16","Apuru ameka wina yamrutin ayame. Tura shamakun pujamtaisha, wina waitin ayame. Tura asakmin wikia kashik aminka kantan kantamruatjame. Tura kakaran chichaakun ami anengkratairumin pachisan, tura ami kakarmarmincha pachisan chichastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS59_17","020_59_17","PSA","59","17","17","Yusru wina kakamtikrurtinmeka ametme. Tura ametme ejarkatnumka. ¡Yusru ameka winaka tuke anentin asakmin, kantan kantamruatjame! ");
INSERT INTO acuNT_vpl VALUES ("PS61_1","020_61_1","PSA","61","1","1","Yusru wi wait wajakun untsumaur anturtukta. Turasha wi seamur anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS61_2","020_61_2","PSA","61","2","3","Jakamin nekapeakun timiá arák pujayatnak wina nintirjai amincha seajme. Ame wina ayamrutkam ejarin asam, turasha pampa juun yumpuunkachminua nunismek asam, winaka waitkata. Ameka jea murá jeamkamua nunisketme. Tura asam wina nemasur ainau yamrutkatnumka ametme. ");
INSERT INTO acuNT_vpl VALUES ("PS61_4","020_61_4","PSA","61","4","4","Ami jeemin pujusan, ami kakarmarmin ejamkan tuke pujustasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS61_5","020_61_5","PSA","61","5","5","Yusru ameka wi turatatjai timiaja nuka mash anturtukmiame. Tura amin naarmin pachisar: Ameketme pengkeram turamin ainau ukunam jukitin aa nu: Aminu ati tusam winasha surusmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS61_6","020_61_6","PSA","61","6","6","Yusru ii apuri ju nungkanam inamak puja nu untsuri musach pujusti tusam tsangkatkata. ");
INSERT INTO acuNT_vpl VALUES ("PS61_7","020_61_7","PSA","61","7","7","Turasha ni aintsritin tuke pengker nintimias inatmarti tusam tsangkatkata. Ami anengkratairumjai tura ami pengkeerumjai tuke ii apuri wainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS61_8","020_61_8","PSA","61","8","8","Ame turakminkia amin naarmin pachisan tuke: Ameketme pengkeram titatjame. Turasha wi turatatjai timiaja nunaka mash kintajai metek umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_1","020_62_1","PSA","62","1","1","Yusnau asan angkantaitjai. Iin uwemtikramratnuka nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_2","020_62_2","PSA","62","2","2","Ningki wina uwemtikrurtinuitai. Ningki wina ejarkatnuitjai. Ningkitai wina waitkatnuka. Tura asamtai wikia natsaamtsuk pujusminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_3","020_62_3","PSA","62","3","3","¿Wina nemasur ainausha waruka winasha nepetukartascha wakerutinawa? Wikia wenuk pukuutanak wajasua nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_4","020_62_4","PSA","62","4","4","Tuke nepetukartas nintimturinawai. Turasha wait chichaman tuke wakerinawai. Ni jangkejaingkia pengke aintsuitme turutinayat, ni nintimaurijaingkia pasé nintimturinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_5","020_62_5","PSA","62","5","5","Antsu Yus wina yainkati tusan nakajai. Angkan pujustinka Yusnumiayaintai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_6","020_62_6","PSA","62","6","6","Ningki wina uwemtikrurtinuitai. Ningki ejarkatnuitai. Ningkitai wina waitkatnuka. Tura asamtai wikia natsaamtsuk pujusminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_7","020_62_7","PSA","62","7","7","Yusketai wina uwemtikrurtinka. Tura asa ningki wina pengker awajtustinuitai. Tura ningkitai wina ejarkatnuka. Turasha ningki winaka waitkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_8","020_62_8","PSA","62","8","8","Wi wear ainautiram, Yus tuke nintimtustaram. Tura Yus seakrumka, pengker nintimsaram nijai chichastaram. ¡Ningkitai iin waitmaktinka! ");
INSERT INTO acuNT_vpl VALUES ("PS62_9","020_62_9","PSA","62","9","9","Aints kuikiartichu ainausha tura kuikiartin ainausha mash nangkamiar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS62_10","020_62_10","PSA","62","10","10","Atumka mangkartutka tura chikich ainau jeen wayaaram warinchurin kasamkaram jukitnuka nintimsairap. Tura kuikiartin wajakrumsha, atumi kuikiaringkia wararsairap. ");
INSERT INTO acuNT_vpl VALUES ("PS62_11","020_62_11","PSA","62","11","12","Yus tímia nunaka untsuri antinuyajai. Wi anturnuyaja nuka nuwaitai: Kakarmaka tura wait anengkrataisha Yusnumiayaintai. Tura ningki aints ainautin ii turamurijai metek yapaijtamkiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS63_1","020_63_1","PSA","63","1","1","Yusru ameka wina Apuruitme. Kashik amincha eajme. Yumi jitachu asamtai, yumi jiturat tusa, nungka nukap yuumawa nunisnak wisha amincha nukap yuumajme. ");
INSERT INTO acuNT_vpl VALUES ("PS63_2","020_63_2","PSA","63","2","2","Ami jeemin wayaan kakarmarmin tura paaniurmincha wainkatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS63_3","020_63_3","PSA","63","3","3","Wikia iwiaaku pujustasan wakerayatun, nuna nangkamasnak ami anengkratairum itiur awak tusan nekaatasan wakerajai. Tura nuna nekaan wina jangkerjai warartustatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS63_4","020_63_4","PSA","63","4","4","Tura iwiaaku pujaknaka: Ameketme pengkeram titatjame. Tura asan amin seakun uwejrun yakí takurtatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS63_5","020_63_5","PSA","63","5","5","Aints yutan nekas kunturman nukap yuwa tutuarua nunisnak wikia naku nakut pujustatjai. Tura asan wina jangkerjai warartakun: Ameketme juuntam titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS63_6","020_63_6","PSA","63","6","7","Yusru ameketme wina yainkatnumka. Tura asakmin kashisha peaknum tepesnasha aminka nintimtusan pujajme. Atashu uchichiri ni nukuri nanapen weamkar pujuinawa nunisnak pengker nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS63_8","020_63_8","PSA","63","8","8","Iwiaaku pujaknaka tuke amijai tsaniasan pujustasan wakerajai. Ami untsur uwejmijai winaka akuptatsme. ");
INSERT INTO acuNT_vpl VALUES ("PS63_9","020_63_9","PSA","63","9","9","Antsu wina mantuwartas wakerutinauka aints jakau iwiartainum tepesartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS63_10","020_63_10","PSA","63","10","10","Tura nangkijai ijum jakaartin ainawai. Tura asaramtai ni namangkenka yukartin ainau yuwaartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS63_11","020_63_11","PSA","63","11","11","Tuminamtai wikia Yusen maaketai tusan warastinuitjai. Wikia Yusnawaitjai tinu ainauka mash Yusen maaketai tiartas kantamawartin ainawai. Antsu wait chichamrintin ainaunka Yus chichamtikiashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_1","020_64_1","PSA","64","1","1","Yusru wi ujaajme nu anturtukta. Wina nemasur kakaram ainia nunia ejarkata. ");
INSERT INTO acuNT_vpl VALUES ("PS64_2","020_64_2","PSA","64","2","2","Tura pasé aints ainau anumkar chichaman najatrina nunia uurkata. Tura nu aints ainau chichaman najatrina nunia angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS64_3","020_64_3","PSA","64","3","3","Ni inajingkia saapi tsakamua nunisarang ainawai. Tura ni chichamengka tsentsak tseasjai paingmawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_4","020_64_4","PSA","64","4","4","Tura anumkar aints tunaarinchau ainaun nangkirin ketinawai. Nuna turinak aneachmau shamtsuk turinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_5","020_64_5","PSA","64","5","5","Tura mai nuwamtak pasé turami tusar nintimtiknainawai. Tura anumkar ejatak puusami tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_6","020_64_6","PSA","64","6","6","Tura asar aints kichkisha iincha waitmakchatnuitji tu nintiminawai. Antsu nu aintsu nintimaurinka uukmau wainiat, Yusek ni pasé nintimaurincha nekaamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_7","020_64_7","PSA","64","7","7","Yus aneachmau nu pasé aints ainaunka ni nangkirijai ijutnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_8","020_64_8","PSA","64","8","8","Turamtai ni pasé chichatirijai ningki wiasmatmamkartin ainawai. Turinau asaramtai chikich aints ainau niin wainkar wishikrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_9","020_64_9","PSA","64","9","9","Mash aints ainau Yusen: Ameketme juuntam tiartinuitai, tura Yuse turamurin pachisar chichainak: Yus aitkayi tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS64_10","020_64_10","PSA","64","10","10","Tura asaramtai pengke aints ainau ni Apurin warartusartinuitai. Iin waitkartukta tusar, Yusen seartin ainawai. Tura aints anangmichu ainauka mash pengker nintimsar pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS65_1","020_65_1","PSA","65","1","2","Yusru ameka ii Yusrinme. Mash aints ainauti warartustinmeka ametme. Ameka seamurka anturtau asakmin, aints wikia pengker aa nuna turatatjai tinu ainauka ni timiaurinka umikiartinuitai. Mash nungkanmaya ainauka amin winiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS65_3","020_65_3","PSA","65","3","3","Ii tunaaringkia iin inatminua nunisarang ainawai. Turinau wainiatum ameka ii tunaaringkia tsangkukratkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_4","020_65_4","PSA","65","4","4","Yusru ame aints ainau winar arti tusam, tura wina pujutirun wijai pujusarti takumningkia, nu aints ainausha nekasar pengker nintimsar pujusartin ainawai. Tura ami jeemin pujakrinkia, ami pengkeerumjai ii nintin piatkartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS65_5","020_65_5","PSA","65","5","5","Yusru ameka iin uwemtikiartuktin asam, mash aints ainautin metek jiikratsam, pasé aints ainauka wait wajaktin suwitme. Tura amin umirtaminak pujuinauka pengker awajnuitme. Tura asakmin mash nungkanam pujuinauka, tura juun entsanam wekajinausha aminak nintimturmasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS65_6","020_65_6","PSA","65","6","6","Ameka mura ainau muchitsuk wajasarti tusam ami kakarmarmijai wainuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_7","020_65_7","PSA","65","7","7","Ameka juun entsa tampaaramurin: Miaaku wajasti tusam inawaitme. Tura aints ainau taetet wajainauka: Titú pujustaram tusam itatmamtiknuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_8","020_65_8","PSA","65","8","8","Aints timiá arák pujuinausha ami wainchati takatrumin wainkar kurarartin ainawai. Tsaa taakmaunumanini tsaa jeamunmaninisha aints ainau amin pachitmasar warainak untsumkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS65_9","020_65_9","PSA","65","9","9","Ame aja ainauka wainnuitme. Tura yumisha jitumtiknuitme. Tura arak ainausha tsapamtiknuitme. Ameka entsa ainau nungkan chuprarat tusam najanawaitme, turasha trigo nerekat tusam neremtiknuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_10","020_65_10","PSA","65","10","10","Ameka nungka mujukash tsairmau aa nu chupratnuitme. Tura nungka minarat tusam yumisha jitumtiknuitme. Turasha árak ainau pengker nerekarat tusam neremtiknuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_11","020_65_11","PSA","65","11","11","Ameka aja ainau musaachjai metek nerekarat tusam, yumi nukap jitumtiknuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_12","020_65_12","PSA","65","12","12","Numi atsamunam tura mura ainamunam waaka ainau tura uwija ainausha chirichri nukap yuwaarat tusam samek najanuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS65_13","020_65_13","PSA","65","13","13","Ame turau asakmin, paka nungkanam waaka ainau tura uwija ainausha untsuri iruninawai. Tura trigo arakmau ainausha untsuri ainawai. Tura asaramtai aints ainau mash kantan kantamkamaikiak warainak untsuminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS66_1","020_66_1","PSA","66","1","1","Mash nungkanmaya ainautiram warasrum Yus pachisrum kanta kantamruataram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_2","020_66_2","PSA","66","2","2","Yuse naari timiá pengker aa nu pachisrum kanta kantamruataram. Tura Yus pachisrum: Ameketme pengkeram tusaram kanta kantamruataram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_3","020_66_3","PSA","66","3","3","Tura Yus chicharkuram: “Aminu najanamuram ainauka nekasar shiiram ainawai. Ame timiá kakaram asakmin, ami nemasem ainau shamraminak amin eemkiar ayaarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS66_4","020_66_4","PSA","66","4","4","Tura asaramtai mash nungkanmaya ainau amincha: Ameketme juuntam turamiartin ainawai. Nunia amin naarmin pachisar kantan kantamawartin ainawai” Yus titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_5","020_66_5","PSA","66","5","5","Mash nungkanmaya ainautiram, Yuse turamuri ainau wainkatasrum winitaram. Turasha aints ainautin yainmaktas wainchatin shiirman najanamia nu wainkatasrum winitaram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_6","020_66_6","PSA","66","6","6","Ningki juun entsa mujukash ati tusa najanamiayi. Yus turamtai ii juuntri ainau yaanchuik nu juun entsanka kukarak katingkiarmiayi. Tura asamtai ii Yusringkia warartusmi. ");
INSERT INTO acuNT_vpl VALUES ("PS66_7","020_66_7","PSA","66","7","7","Yus ni kakarmarijai tuke aints ainautin inatmartinuitji. Tura niin umirtan nakitin ainauka umirtutsuk pujusarai tusa mash nungkanmaya ainaun jiij pujurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS66_8","020_66_8","PSA","66","8","9","Yus iinka iwiaaku pujustaram tusa tura ayaarairap tusa waitkartukmiayi. Tura asamtai mash nungkanmaya ainautiram, ii Yusri pengker awajsataram. Turasha Yus pachisrum kanta kantamkuram antumtikiataram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_10","020_66_10","PSA","66","10","10","Ii Yusriya ameka tuke iinka nekapkartinuyame. Aints ainau jiru kuik pakuichau at tusar, jiinam jiyaar shiiram najaninawa nunismek iincha pengker awajkartustasam nekapkartinuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS66_11","020_66_11","PSA","66","11","11","Aints ainau kuntinun kutrinawa nunismek iincha chikich ainau achikiarti tusam tuke tsangkamkartin ayame. Tura asam aints ainau merman entsamtikina nunismek ameka iinka tuke nekapkartinuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS66_12","020_66_12","PSA","66","12","12","Tura aints ainau pachitsuk najararti tusam tsangkamkartinuyame. Ame turau asakmin, iisha entsanam jakerua nunisrik tura jiinmasha epeamua nunisrik nekapmamnuyaji. Turarin wainiatum ukunam nungka pengkernum pujusarti tusam pujkartusmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS66_13","020_66_13","PSA","66","13","14","Tura asakmin ami jeemin wayaan, amin naarmin pachisan tangkurun maan epeatatjai. Nuna turakun yaanchuik shamrumtinnum pujakun: Wikia junia iwiaaku jiinkinka tangkurun maan susatatjame timiaja nunaka umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS66_15","020_66_15","PSA","66","15","15","Tangku epetinam ami jeem aa nuni tangkurun epeatatjai. Waaka aishmangkri ainaun tura chipu ainauncha tura uwija aishmangkri kungkuram ainia nuna aminka susatatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS66_16","020_66_16","PSA","66","16","16","Yus timiatrusrumek umirkau ainautiram mash winitaram. Tura Yus wina pengker awajtusmaurun pachisan etsermatai nu antuitaram. ");
INSERT INTO acuNT_vpl VALUES ("PS66_17","020_66_17","PSA","66","17","17","Wina jangkerjai Yusrun seamiajai tura wararsamiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS66_18","020_66_18","PSA","66","18","18","Wikia tunau nintimsan pujawaitmataikia, wina Apurka winaka anturtukchamin ayayi. ");
INSERT INTO acuNT_vpl VALUES ("PS66_19","020_66_19","PSA","66","19","19","Turayat wi seamurnaka anturtinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS66_20","020_66_20","PSA","66","20","20","Tura wi seamurnaka anturtuk ni anengkratairin suritrukchau asamtai, Yusrunka ameketme pengkeram tajai. ");
INSERT INTO acuNT_vpl VALUES ("PS67_1","020_67_1","PSA","67","1","2","Ii Yusriya wait anengkratkata, tura pengker awajkartusta. Mash nungkanmaya ainau ami wakeramurmin nekaawarti tusam, tura ame uwemtikiartutai chichaman antukarti tusam pengker awajkartusta. ");
INSERT INTO acuNT_vpl VALUES ("PS67_3","020_67_3","PSA","67","3","3","Ii Yusri asakmin, mash nungkanmaya ainau: Ameketme pengkeram turamiarti. Turasha ameketme juuntam turamiarti. ");
INSERT INTO acuNT_vpl VALUES ("PS67_4","020_67_4","PSA","67","4","4","Mash nungkanmaya ainau amek inawaitme. Tura mash nungkanmaya ainau winak umirtukarti tusam jintinnuitme. Tura asakmin mash nungkanmaya ainau amincha warartamsar untsurmakarti. ");
INSERT INTO acuNT_vpl VALUES ("PS67_5","020_67_5","PSA","67","5","5","Ii Yusri asakmin mash nungkanmaya ainau: Ameketme pengkeram turamiarti. Turasha ameketme juuntam turamiarti. ");
INSERT INTO acuNT_vpl VALUES ("PS67_6","020_67_6","PSA","67","6","6","Ajanam árak ainau nerekarti tusa, ii Yusri iincha pengker awajtamsamji. ");
INSERT INTO acuNT_vpl VALUES ("PS67_7","020_67_7","PSA","67","7","7","¡Yus iincha pengker awajkartamtai, mash nungkanmaya ainau niincha: Ameketme Yusem tiarti! ");
INSERT INTO acuNT_vpl VALUES ("PS71_1","020_71_1","PSA","71","1","1","Apuru wina ejarkat tusan amin seajme. Wina ajapruam pengké ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS71_2","020_71_2","PSA","71","2","2","Tura angkanmamtikruata. Tura timiá pengker asam uwemtikrurta. Tura anturtukam yainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS71_3","020_71_3","PSA","71","3","3","Wikia aints pampanam anuminawa nunismek anumkata tusam tsangkamrukta. Ame wina uurkatin asam, wina ejarkatin ata, turasha wina uwemtikrurtin ata. ");
INSERT INTO acuNT_vpl VALUES ("PS71_4","020_71_4","PSA","71","4","5","Yusru wikia natsa akuncha tuke aminka eayajme. Tura wina Yusur asakmin, pasé aints ainau tura mangkartin ainau amin umirtamchau asaramtai, nu aints ainamunmaya angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS71_6","020_71_6","PSA","71","6","6","Nukuru ampujenia wina jiirkimiame. Tura akiinamunmayan winaka waitnuyame. Tura asakmin amincha tuke: Ameka wina Yusruitme titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS71_7","020_71_7","PSA","71","7","7","Aints ainau untsuri wina waitkar nukap nintiminawai. Turinau wainiatum ame wina ejarkatin tuke ayame. ");
INSERT INTO acuNT_vpl VALUES ("PS71_8","020_71_8","PSA","71","8","8","Kintajai metek ami pengkeerumin nintimsan: Ameketme pengkeram tinuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_9","020_71_9","PSA","71","9","9","Tura asamtai juuntach amatisha tuke waitkata. Tura wina kakarmar atsamtaisha ajapruamka ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS71_10","020_71_10","PSA","71","10","10","Wina nemasur ainau mantuwartas iruntrar chichaman najatrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_11","020_71_11","PSA","71","11","11","Nuka chichainak: “Yus niin ajapa ukukin asamtai, aints kichkisha ayamrukchatnuitai. Tura asamtai papeekrum achiktaram”, turutinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_12","020_71_12","PSA","71","12","12","Yusru tu tinau asaramtai, winaka ajapruam ukurkiip, antsu wári yainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS71_13","020_71_13","PSA","71","13","13","Wina nemasur ainau inatsaaram mengkaakta. Wina pasé awajtusartas wakerutin ainaunka chikich aints ainau wishikrarti tusam inatsaarta. ");
INSERT INTO acuNT_vpl VALUES ("PS71_14","020_71_14","PSA","71","14","14","Antsu wikia amin kintajai metek ame tati tusan nakastatjame. Turakun ameketme Yusem tuke titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS71_15","020_71_15","PSA","71","15","15","Kintajai metek aints ainaun ujaakun: “Yuska iincha uwemtikramnuyaji, turasha iincha pengker awajtamnuyaji”, titatjai. Antsu ¿itiur uwemtikramrayajik? nunaka nintimratatkaman pengké tujintajai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_16","020_71_16","PSA","71","16","16","Apuru amin pachisan: Yus ni kakarmarijai ni nemase ainaun nepetnuyayi, tusan aints ainaun ujaktatjai. Turasha amin pachisan: Ningki aints ainaun mash metek inawai, tusan etserkatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_17","020_71_17","PSA","71","17","17","Yusru wi natsa amatikia, tuke wina unuitinuyame. Tura asakmin juuntach ayatun, amin pengker turamurmin pachisan etseru weajai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_18","020_71_18","PSA","71","18","18","Yusru wikia weamran tura jemperukan pujaing waitiatum winaka ajapruam ukurkiip. Tuke ami kakarmarmin pachisan yamai pujuinaun tura ukunam akiinatin ainauncha ujakminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_19","020_71_19","PSA","71","19","19","Yusru nayaimpinam pujau asam, aints ainau mash metek inawaitme. Tura ame wainchati takat timiá untsuri takaawitme. Amijai metek kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_20","020_71_20","PSA","71","20","20","Winaka itit awajtukmaur tura wait wajaktincha wainmamtikrin ayame. Turayatum wi jakamtai, winaka inantukim tuke pujusti tusam, iwiarsamunmaya inantuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS71_21","020_71_21","PSA","71","21","21","Tura aints ainau wina pachitsar: Pengke aintsuitai tiarti tusam, tura wijai pengker nintimias pujusti tusam, winaka pengker awajtustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS71_22","020_71_22","PSA","71","22","22","Tura asakmin Yusru wikia amin pachisan kantan kantamruatjame. Turasha ameka tuke pengkeraitme titatjame. Ameka Israela pengkerinme tusan, amin kitarran tura arpancha tuntuikiamaikiakun kantan kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS71_23","020_71_23","PSA","71","23","23","Tura wina uwemtikruru asakmin, jangkerjaingkia kantan kantamkun nintirjaingkia warastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS71_24","020_71_24","PSA","71","24","24","Wina pasé awajtusartas wakerutin ainauka pengké natsaarar pujuu armiayi. Turinau asaramtai wikia kintajai metek aints ainaun ame pengker turamurmin pachisan chichastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_1","020_73_1","PSA","73","1","1","Yus pengke nintintin ainaun nekas pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_2","020_73_2","PSA","73","2","3","Antsu wikia jampesarang pujuinaun suwirpiaku jiakun, tura pasé aints ainauncha suwirpiaku jiakun, aints iyaachak wajawa nunisnak tunau jurumachak wajakjai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_4","020_73_4","PSA","73","4","4","Pasé aints ainau najaimiatsuk pujuinau asar ni jakatniurinka nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS73_5","020_73_5","PSA","73","5","5","Tura chikich aints wait wajaina nunisarka waitka wajainatsui. Tura chikich aintska itiurkachminnum pujuina nunisarka pujuinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS73_6","020_73_6","PSA","73","6","6","Tura asar jampesarang pujuinawai, tura chikich aints ainauncha pasé awajinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_7","020_73_7","PSA","73","7","7","Ni namangkengka apuitai. Turayat tuke ni nintijai tunau nintimin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_8","020_73_8","PSA","73","8","8","Chikich aints ainaun wishikinawai. Tura jampesarang: Wi wakeraknaka pachitsuk pasé aa nunaka turamnawaitjai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_9","020_73_9","PSA","73","9","9","Yusnasha pachisar pasé chichainawai, tura aintsnasha pachisar tuke aujmatinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_10","020_73_10","PSA","73","10","10","Tu pujuinau asaramtai, chikich aints ainau niin pachisar: Nekasar pengker pujuinawai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_11","020_73_11","PSA","73","11","11","Tura nintiminak: ¿Itiur pujuinawa nuna Yus nekawash? ¿Tura Yus nayaimpinam puja nuka nu aintsu turamurinka nekawash? tinawai. Ni inintramuri tu awai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_12","020_73_12","PSA","73","12","12","Nu pasé aints ainau jiij pujurtaram. Pachitsuk ni kuikiarin yujinawai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_13","020_73_13","PSA","73","13","13","Tu tinau wainiatnak, wikia nangkamnak nintir tunaarinchau ati tusan wakerukmajai. Turasha nangkamnak tunau takatsuk pujustaj timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_14","020_73_14","PSA","73","14","14","Turayatnak pachitsuk kintajai metek wait wajajai, tura kashincha kashincha wina katsumrinawai, tu nintimsan pujumjai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_15","020_73_15","PSA","73","15","15","Antsu tu chichaaknaka Yusen umirkaru ainaun pasé nintimtiknuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_16","020_73_16","PSA","73","16","16","¿Timiá tunau ainayat warukaya timiá yuumatskesha pujuinawa? tusan nuna tenapkesan nintimratatkaman pengké yumtin nintimsan pujuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_17","020_73_17","PSA","73","17","17","Antsu nuniangka Yuse jeen wayaan, Yusen nintimran iniakun: ¿Nu pasé aints ainauka tuni pujusartinui? tu iniam, Yus winaka nekamtikruamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS73_18","020_73_18","PSA","73","18","18","Nu aints ainauka iyaatnak wajainawai, tura mengkaatanak wajainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_19","020_73_19","PSA","73","19","19","Nuka aneachmau mengkaakartin ainawai. Turasha sapijjai amukartin ainawai turutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS73_20","020_73_20","PSA","73","20","20","Apuru ame aints shintarua nunismek nu pasé aints ainauka amuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS73_21","020_73_21","PSA","73","21","22","Wikia pasé aints ainau pujutrin wainkan, tangku nintinchawa nunisnak katsurman nintimsan pujuyajai. Turamtai nintir najamnuyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS73_23","020_73_23","PSA","73","23","23","Turayatnak tuke amijai pujuyajai. Tura asamtai tunaanum ayaaraim tusam, untsur uwejrun achirkamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS73_24","020_73_24","PSA","73","24","24","Wina chichamur umirtukta tusam, chichamem akupturkamiame. Tura wi jakamtaikia, wina pengker awajtusam juruktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS73_25","020_73_25","PSA","73","25","25","¿Warukanak nayaimpinam winitnasha wakeraja? Nayaimpinam wininka aminak wainkatasan wakerajme. Amijai pujaknaka ju nungkanam ainia nunaka pengké wakerukchatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_26","020_73_26","PSA","73","26","26","Wina pujutruka amukatnuitai. Antsu tuke Yusnum pujustin asamtai, Yus wina nintirun kakamtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_27","020_73_27","PSA","73","27","27","Aints Yusen nintimtsuk pujuinauka tuke mengkakartin ainawai. Tura asaramtai niin umirtsuk pujuinaunka Yus amuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS73_28","020_73_28","PSA","73","28","28","Antsu wikia tuke Yusen nintimsan pujusminuitjai. Kame tu pujaknaka timiá pengker pujustinuitjai. Apuru wina Yusur asam, wina ejarkatnumka ametme. Tura asakmin ame turamurmin wikia aints ainaun mash nekamtikiatnuitjai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS77_1","020_77_1","PSA","77","1","1","Yus wina anturtukat tusan kakarman untsuajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_2","020_77_2","PSA","77","2","2","Tsawai wake mesekan pujakun, Apurun seajai. Tura kashisha tuke inaitsuk uwejrun takuin, Yusnasha seajai. Turayatun tuke napchau nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_3","020_77_3","PSA","77","3","3","Wikia Yusen nintimsan pujakun juutjai. Turasha nukap nintimsan pujaknaka katsurman nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_4","020_77_4","PSA","77","4","4","Apuru ameka kanurta tusamka tsangkamrukchamame. Timiá wake mesekan pujau asan chichakchamin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_5","020_77_5","PSA","77","5","5","Turayatun yaanchuik pujuyaja nuna nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_6","020_77_6","PSA","77","6","6","Turasha kashi kantamnuyaja nunasha aneakjai. Tura nintirjai nintimsan ininmamkun: ");
INSERT INTO acuNT_vpl VALUES ("PS77_7","020_77_7","PSA","77","7","7","¿Apurka iinka tuke kajertamkatatjik? ¿Tura iinka ataksha pengkerka awajtamkashtatjik? ");
INSERT INTO acuNT_vpl VALUES ("PS77_8","020_77_8","PSA","77","8","8","¿Turasha ni anengkratairingkia amukamkia? ¿Turasha Yus yaanchuik wi turatatjai tímia nunaka tuke umitsuk pujustatuak? ");
INSERT INTO acuNT_vpl VALUES ("PS77_9","020_77_9","PSA","77","9","9","¿Turasha Yuska ni pengkerinka kajinmarmakia? ¿Turasha iincha timiá kajertamkau asa, wait anentramtsuk pujustatuak? tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_10","020_77_10","PSA","77","10","10","Yus nayaimpinam puja nuka yamaikia iijaingkia pujatsui, tu nintimsan pujakun nintir najamrutawai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_11","020_77_11","PSA","77","11","11","Antsu ii Apuri yaanchuik pengké wainchatin turinuya nunaka aneartatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_12","020_77_12","PSA","77","12","12","Turasha ni turinamurin mash nintimratatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_13","020_77_13","PSA","77","13","13","Yusru ami turamuram nekasar pengker ainawai. Amijai metek Yuska pengké atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS77_14","020_77_14","PSA","77","14","14","Amek Yus asam, wainchati takat untsuri turinuyame. Tura mash nungkanmaya ainau ami kakarmaram nekamtiknuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS77_15","020_77_15","PSA","77","15","15","Tura ami kakarmarmijai ami aintsrum ainau angkanmamtiknuyame. ");
INSERT INTO acuNT_vpl VALUES ("PS77_16","020_77_16","PSA","77","16","16","Yusru ame nase akupkam, juun entsaka akankamiame. Tura asakmin entsa timiá kuna ayat kukar wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS77_17","020_77_17","PSA","77","17","17","Tura mukuntiuka yumin jitumtikramiayi. Turasha nayaimpinam ipiamat untsuri chichaarmiayi. Turasha chaarim untsuri ayaararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS77_18","020_77_18","PSA","77","18","18","Tura katurang winamtai, ipiamtancha antukarmiayi. Tura chaarim ayainamtai, nungka jiitsumir wajakmiayi. Tura uu uurmatai, nungkaka muchikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS77_19","020_77_19","PSA","77","19","19","Yusru juun entsanam ame kukarak katingtaj tusam, entsaka akankamiame. Antsu ami nawemjai najamamunka wainkacharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS77_20","020_77_20","PSA","77","20","20","Uwija wainin ni uwijarin ayas wekaamtikua nunismek ami aintsrum ainau wekaamtiksarti tusam, Moisés tura Aarónsha inarmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS79_1","020_79_1","PSA","79","1","1","Yusru amin umirtamchau ainau Jerusalén yaktanam kaunkarmiayi. Tura ami jeemnasha pasemamtikrarmiayi. Tura ami yaktarmin yumpungkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS79_2","020_79_2","PSA","79","2","2","Tura ami inatiram ainaun chiwiang ainau yuwaarat tusar, tura pachim ainausha yuwaarat tusar, kajengkar iwiartsuk ukukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS79_3","020_79_3","PSA","79","3","3","Tura aintsu numpe yumi ukaawa nunisarang Jerusalénnum ukararmiayi. Tura ni iwiaratniurisha atsuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS79_4","020_79_4","PSA","79","4","4","Tura asaramtai chikich aints ainau iincha tentatmakar pujusar wishikraminaji. ");
INSERT INTO acuNT_vpl VALUES ("PS79_5","020_79_5","PSA","79","5","5","Apuru ¿warutik suwirumsha inaisatam? ¿Ami suwirumka ji kapaawa nunisang tuke atatuak? ");
INSERT INTO acuNT_vpl VALUES ("PS79_6","020_79_6","PSA","79","6","7","Amin umirtamchau ainauka aminka nekarminatsui. Tura amincha seatmichu ainawai. Nu aints ainauka Jacobo weari ainaun amukarmiayi. Tura ii yaktarin mesraru asaramtai, nu aints ainamunam ami suwirum akupkata. ");
INSERT INTO acuNT_vpl VALUES ("PS79_8","020_79_8","PSA","79","8","8","Ii juuntri yaanchuik pasé pujusarmaunum iinka wait wajaktinka sukartusaip. Antsu iikia timiá wake mesekar pujuinau asakrin, ami wait anengkratairum akupkartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS79_9","020_79_9","PSA","79","9","9","Yusru iin uwemtikratkatin asam yaimkartukta. Turasha angkanmamtikiartukta. Turasha ii tunaaringkia tsangkukratkata. Ame pengker asakmin, ami naarmin pachisan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS79_10","020_79_10","PSA","79","10","10","Amin umirtamchau ainau wishikrinak: ¿Atumi Yusri tuwaita? turutiarai tusam yaimkartukta. Ami inatiram ainau jakarmaurin ame yapaijkumin, iisha nu wainkatasar wakeraji. Tura amin umirtamchau ainausha Yus aitkarmaji tusar niisha nekaawarti. ");
INSERT INTO acuNT_vpl VALUES ("PS79_11","020_79_11","PSA","79","11","11","Tura achikmau ainau juutinamurisha amesha antukta. Tura achikmau ainaun: Atumsha jakatatrume tinau wainiatmek nu aints ainausha ami kakarmarmijai angkanmamtikiata. ");
INSERT INTO acuNT_vpl VALUES ("PS79_12","020_79_12","PSA","79","12","12","Apuru aints amin pasé awajtamkarmia nu nukap yapaijkiata. ");
INSERT INTO acuNT_vpl VALUES ("PS79_13","020_79_13","PSA","79","13","13","Ame turakminkia, iikia ami aintsrum asar, tuke inaitsuk ameka maaketai titatji. Tura ame warartakur kanta kantamatatji. Tura ii uchiri ainausha tura ii tirangki ainausha tura nuna uchiri ainausha nunisarang tuke turuwartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS81_1","020_81_1","PSA","81","1","1","Yuska iin kakamtikramratnuitji tusaram, warasrum kantamataram. Tura Jacobo Yusri warartakrum kakarum chichaktaram. ");
INSERT INTO acuNT_vpl VALUES ("PS81_2","020_81_2","PSA","81","2","2","Tura tampurjai tura kitarrjai tura arpajaisha tuntuikiamaikiakrum kanta kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS81_3","020_81_3","PSA","81","3","3","Tura nantu takaamtai pupun pupuntruataram. Nuniasha nantu pamau yuwamtaisha, ii fiestari kinta asamtai, pupun pupuntruataram. ");
INSERT INTO acuNT_vpl VALUES ("PS81_4","020_81_4","PSA","81","4","4","Ii Yusri ni aintsri ainautin nu chichamka umiktaram tusa akupturmakmiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS81_5","020_81_5","PSA","81","5","5","Tura Yus Ejiptonmaya ainaun nepetkatas nu chichamnaka Josén akuptukmiayi. Nunia wi antushtain chichaman antukmiaja nu nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("PS81_6","020_81_6","PSA","81","6","6","“Atum meram entsakua nunisrumek pujarmin, takatrum uyumtin amia nunia angkan awajsamiajrume. ");
INSERT INTO acuNT_vpl VALUES ("PS81_7","020_81_7","PSA","81","7","7","Atumka wait wajakrum pujau asaram, wina untsurkamiarme. Nu turakrumin wikia uwemtikramiajrume. Tura mukuntiunmaya ipiamat chichamia nunian wikia aikmiajrume. Tura juun entsa kaanmatkarin Meriba tutainum atumnasha nekapsamiajrume. ");
INSERT INTO acuNT_vpl VALUES ("PS81_8","020_81_8","PSA","81","8","8","Wina aintsur ainautiram anturtuktaram. Wikia atumin chicharkatatjarme. Israel ainautiram, wina anturtuktaram tusan wakerajrume. ");
INSERT INTO acuNT_vpl VALUES ("PS81_9","020_81_9","PSA","81","9","9","Chikich nungkanmaya aints ainau yusringkia seairap. Turasha chikich nungkanmaya aints ainau yusrin seatasrum tsuntsumruwairap. ");
INSERT INTO acuNT_vpl VALUES ("PS81_10","020_81_10","PSA","81","10","10","Wiitjai atumi Apuri. Wiitjai atumi Yusri. Wiki atumniaka Ejipto nungkanmaya jiikmiajrume. Tura asamtai yamaikia atumi jangke awaartaram. Turakrumin wi atumin yuratatjarme. ");
INSERT INTO acuNT_vpl VALUES ("PS81_11","020_81_11","PSA","81","11","11","Wi tamaitiat wina aintsur ainau wina chichamrun antutnasha tura umirtutnasha nakitrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS81_12","020_81_12","PSA","81","12","12","Tuminau asaramtai tuuksha pujusarti tusan inaisamiajai. Wi turam ni wakeramurin pujusarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS81_13","020_81_13","PSA","81","13","14","Wina aintsur ainau wina anturtukaruitmatikia, aints mitsum mitsum wajawa nutiksanak ni nemase ainaunka mengkatkartinuyajai. Tura Israela weari ainau wina jintarun amakaruitmatikia, ni nemase ainaunka wait wajaktintrin susartinuyajai”, Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS81_15","020_81_15","PSA","81","15","15","Ii Yus umirkawaitkurningkia, ii Apurin nakitina nuka shamraminak ayaararmin ainawai. Turasha tuke mengkaakarmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS81_16","020_81_16","PSA","81","16","16","Ii Yusri anturkamuitkungka, ni aintsri ainautinka yuta nekas pengker aa nuna yurtamamnauyaji. Tura kitaknasha mikturmamnauyaji. ");
INSERT INTO acuNT_vpl VALUES ("PS84_1","020_84_1","PSA","84","1","1","¡Apuru ameketme kakarmam! Ami pujutirmeka nekas shiirmaitai tajame. ");
INSERT INTO acuNT_vpl VALUES ("PS84_2","020_84_2","PSA","84","2","2","Wikia ami jeemin tenukap pujustasan wakerajai. Ame pujut sukartame nuna pachisan tuke nintirjai warasan kantamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_3","020_84_3","PSA","84","3","3","Apuru ameketme kakarmam. Tura wina Apur asam, tura wina Yusur asakmin tajame: Suwich tura shuwirpip ainau ami jeemin engkemawar pengker nintimsar pasungminawai. Tura ni uchichirin pengker nintimsar tsakatminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_4","020_84_4","PSA","84","4","4","Ami jeemin pujuinauka tuke inaitamtsuk amincha: Ameketme juuntam tusar nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_5","020_84_5","PSA","84","5","5","Turasha aints aminian ni kakarmarin juwina nuka nekasar warasartin ainawai. Tura tuke nintijai: Wisha Yuse jintin wekaasatasan wakerajai tinu asar, nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_6","020_84_6","PSA","84","6","6","Aints ainau yumi jitachmatai, ni arakri mash kaar mengkainamtai, juutu pujuinawai. Antsu yumi jitamtaikia, nuniangka warainawai. Amin umirtaminak pujuinausha juutu pujuinayat, aminak nintimsar ataksha warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_7","020_84_7","PSA","84","7","7","Tura ami kakarmarmijai tuke kakartin ainawai. Turasha mura Sión tutainum jear, amincha waitmakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS84_8","020_84_8","PSA","84","8","8","Apuru ameketme kakarmam. Jacobo Yusriya, wi seamur anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS84_9","020_84_9","PSA","84","9","9","Yusru iin ejakratin asam, ami aintsrumi apuri ati tusam, aints inaikiamiame nu pengker nintimsam wainkata. ");
INSERT INTO acuNT_vpl VALUES ("PS84_10","020_84_10","PSA","84","10","11","Kichik kintak ami jeemin wayaar nuni pujustinka timiá pengkeraitai. Antsu warang kintasha ami jeemin waaitsuk pujustinka paseetai. Yus ii Apuri asa, iincha paan nintimtikramji, turasha iincha ejarmaji. Tura asamtai wikia aminu jeemin wainin atasan timiá wakerajai. Antsu pasé aints ainaujai tsaniasan pujutnaka nakitajai. Ii Apuri timiatrusrik umirmaka iincha anenmaji turasha warartamji. Turasha pengker aa nunaka kichkisha suritramtsuji. ");
INSERT INTO acuNT_vpl VALUES ("PS84_12","020_84_12","PSA","84","12","12","Apuru ameketme kakarmam. Tura asakmin aints ainau amin nintimturmasar pujuinauka nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS85_1","020_85_1","PSA","85","1","1","Apuru ami aintsrum ainauka pengker awajnuyame. Tura Jacobo weauri ainausha ataksha waramtiksamame. ");
INSERT INTO acuNT_vpl VALUES ("PS85_2","020_85_2","PSA","85","2","2","Tura ami aintsrum ainau tunaari tura ni pasé turamu risha mash tsangkuramame. ");
INSERT INTO acuNT_vpl VALUES ("PS85_3","020_85_3","PSA","85","3","3","Tura kajekartukmaurumsha tuke mash inaisamame. ");
INSERT INTO acuNT_vpl VALUES ("PS85_4","020_85_4","PSA","85","4","4","Yusru iin tunaanumia uwemtikiartin asam, yamaisha tuke uwemtikiartukta. Tura yamaikia iinka kajerkartutsuk pengker awajkartusta. ");
INSERT INTO acuNT_vpl VALUES ("PS85_5","020_85_5","PSA","85","5","6","¿Iinka tuke paseeka awajkartutsuk wina aintsur ainau wina warartursarti tusamka, pujut yamarmaka ataksha sukartuschatmeash? ");
INSERT INTO acuNT_vpl VALUES ("PS85_7","020_85_7","PSA","85","7","7","Apuru ami anengkratairam iwianturkata. Turam tunaanumia uwemtikiartukta tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS85_8","020_85_8","PSA","85","8","8","Ataksha nintinchau pujusarai tusa, ii Apuri umirkatin ainautin pengker nintimsar angkan pujusartinniun pachis chichartamkatatji. Tura asamtai ii Apuri titata nunasha wisha antuktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS85_9","020_85_9","PSA","85","9","9","Yus ni kakarmarijai ii nungkarin pujustas wakerawai. Tura ni umirkur pujuinautinka nekas uwemtikramratas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PS85_10","020_85_10","PSA","85","10","10","Yus iijai pujamtaikia, ni wait anengkratairi tura ni chichame nekas aa nunaka iin suramsatnuitji. Tura angkantin pengker nintimsar pujustinasha tura tunaarinchau pujustinasha iin suramsatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS85_11","020_85_11","PSA","85","11","11","Tura asamtai ju nungkanam pujuinautisha nekas chicham aa nuke chichastinuitji. Nu turakrin Yus nayaimpinam puja nu iincha pengker awajtamsatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS85_12","020_85_12","PSA","85","12","12","Turasha ningki yumin jitumtikratnuitai. Tura ii nungkarinian arakan tsapamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS85_13","020_85_13","PSA","85","13","13","Tura ni pengker awajsamurin iin iwianturmak: Atumsha tu pujustaram tusa jintintramatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS86_1","020_86_1","PSA","86","1","1","Apuru wikia wait wajakun yuumakun pujau asamtai, wait aneasam anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_2","020_86_2","PSA","86","2","2","Tura amin nintimtakun pujau asamtai, wina yainkata. Ameka wina Yusruitme. Wikia aminu inatiram asan, amin nintimtajme. Tura asamtai uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_3","020_86_3","PSA","86","3","3","Apuru kintajai metek seajme. Tura asamtai wait anentrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_4","020_86_4","PSA","86","4","4","Yusru aminu inatiram asan, amin tuke seajme. Tura asamtai nintir waramtikrusta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_5","020_86_5","PSA","86","5","5","Apuru ame nekas pengker asam, aintsu tunaari tsangkuratnuitme. Tura amin seatmin ainauka pengker awajsatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS86_6","020_86_6","PSA","86","6","6","Yusru wi seamur anturtukta, tura anturtukam nekartuata. ");
INSERT INTO acuNT_vpl VALUES ("PS86_7","020_86_7","PSA","86","7","7","Wi napchau nintimsan amin untsuam anturtuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS86_8","020_86_8","PSA","86","8","8","Apuru amijai metekka Yuska atsawai. Tura aminu turamurmijai metekka kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS86_9","020_86_9","PSA","86","9","9","Apuru mash nungkanmaya ainau najanamiame nuka amin jear: Ameketme juuntam turamiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS86_10","020_86_10","PSA","86","10","10","Amek Yus asam, nekas juuntaitme. Tura asam wainchati takatcha mash najanawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS86_11","020_86_11","PSA","86","11","11","Yusru jintim nekamtikruata. Nu turakminka tuke nemarsatnuitjame. Tura ami naarmin pachisan: Ameketme juuntam titin nintimtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_12","020_86_12","PSA","86","12","12","Apuru wina Yusur asakmin, tuke wina nintirjai: Ameketme pengkeram titatjame. Tura ami naarmin pachisan: Ameketme kakarmam tuke titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS86_13","020_86_13","PSA","86","13","13","Wina nukap anentruru asam, mengkakatnunam we tusam uwemtikrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS86_14","020_86_14","PSA","86","14","14","Yusru jampesarang pujuinauka aminka nintimtsuk pujuinau asar, wina pasé awajtinak mantuwartas winitrinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS86_15","020_86_15","PSA","86","15","15","Antsu ameka Apuru nekasam Yus asam, jaimiasam wait anengkratnuitme. Tura asamtai anengkratairumka nangkankashtinuitai. Tura ami chichamim nekas aa nuka tuke nangkankashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS86_16","020_86_16","PSA","86","16","16","Wina jiirsam wait anentrurta. Turam kakarmaram surusta. Wikia ami inatiram asamtai uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS86_17","020_86_17","PSA","86","17","17","Ami pengkeerum inaktursata. Tura wina pengker awajtakmin, wina kajertin ainauka nuna wainkar natsaarartinuitai. Apuru ameka wina yainkau asam, wina pengker nintimtikrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS88_1","020_88_1","PSA","88","1","1","Apuru wina Yusur asam, turasha wina uwemtikrurtin asakmin, tsawaisha tura kashisha yainkata tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS88_2","020_88_2","PSA","88","2","2","Tura wi seajme nu anturtukam airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS88_3","020_88_3","PSA","88","3","3","Wikia timiá pasé pujau asan, jakamin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_4","020_88_4","PSA","88","4","4","Wina kakarmar atsau asamtai, wina pachitsar wári jakatatui tiarminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_5","020_88_5","PSA","88","5","5","Wikia aints jakau iwiarsamunam ukusmawa tumawaitjai. Tura aints maaniamunam maamua tumawaitjai. Turasha aints amin ejamunka waintsuk kajinminawa tumawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_6","020_88_6","PSA","88","6","6","Tura wikia waa jiitamranam tee amaunum ajuarmawa tumawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_7","020_88_7","PSA","88","7","7","Ame kajekmaurum akupturkau asakmin, aints entsa tampaaramunam ujungmawa tumawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_8","020_88_8","PSA","88","8","8","Turamtai wina amikur ainau ajapruwar ukukiarti tura tsuutrarti tusam aitkaramame. Tura asan wikia aints kársernum engkeamua tumawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_9","020_88_9","PSA","88","9","9","Tura timiá juutu asan, wainmichua nunisketjai. Apuru kintajai metek amincha uwejrun takuin seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS88_10","020_88_10","PSA","88","10","10","¿Jakaru ainau wainchati takat wainmamtikiatmeash? ¿Tura jakaru ainau amin maaketai turaminawak? ");
INSERT INTO acuNT_vpl VALUES ("PS88_11","020_88_11","PSA","88","11","11","¿Jakaru ainau iwiarsamunam ami nekas chichammin pachisar, tura ami anengkratairumin pachisar chichainawak? ");
INSERT INTO acuNT_vpl VALUES ("PS88_12","020_88_12","PSA","88","12","12","¿Tura jakaru ainamunam aints kichkisha ami pengker turamurmin tura ami wainchati takatrumin nintiminawak? ");
INSERT INTO acuNT_vpl VALUES ("PS88_13","020_88_13","PSA","88","13","13","Antsu wikia Apuru amin seajme. Kashik amincha wina seamurnaka antumtikiajme. ");
INSERT INTO acuNT_vpl VALUES ("PS88_14","020_88_14","PSA","88","14","14","Apuru ¿waruka winasha nakitrame? ¿Waruka winasha anumrutme? ");
INSERT INTO acuNT_vpl VALUES ("PS88_15","020_88_15","PSA","88","15","15","Wikia natsa akunka wait wajayajai, tura jatancha wakerin ayajai. Tura ame wina itiurkachmin akupturkumnisha atsannuyajai. Turayatun yamaikia atsantrachmin nekapeajai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_16","020_88_16","PSA","88","16","16","Ami suwirum winaka nepetuki. ");
INSERT INTO acuNT_vpl VALUES ("PS88_17","020_88_17","PSA","88","17","17","Tura asamtai aints nujang nujangkruamunam japen wajawa tumawaitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS88_18","020_88_18","PSA","88","18","18","Wina amikur ainau tura wina irutkamur ainausha yajá akupkamu ainawai. Tura asaramtai wikia teenam pujuinawa nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS90_1","020_90_1","PSA","90","1","1","Apuru ameka tuke iin ejakratin ayame. ");
INSERT INTO acuNT_vpl VALUES ("PS90_2","020_90_2","PSA","90","2","2","Ameka mash najanchayatmek, tura murasha mash najanchayatmek, Yus asam tuke pujayame, tura tuke pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS90_3","020_90_3","PSA","90","3","4","Ame aintsti pachisam chichaakum: Ataksha nungka ati takumningkia, ataksha nungka wajastinuitji. Ameka mil (1,000) musach wainiatum, kinta yaau nangkamarua tumau nintime. Tura mil (1,000) musach wainiatum, jumchik hora tumau wári nangkamartin ainawai, tu nintime. ");
INSERT INTO acuNT_vpl VALUES ("PS90_5","020_90_5","PSA","90","5","5","Nujang aintsun jakatniunam juwawa nunisrik aji. Tura ii karanam nintimu weaji nunisrik mengkakatin ainiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS90_6","020_90_6","PSA","90","6","6","Tura nupaaya nunisrik ainiaji. Nupaa tsapai kashik yangkurui. Turayat kiaraikia jajatar kakarmachu minayi. ");
INSERT INTO acuNT_vpl VALUES ("PS90_7","020_90_7","PSA","90","7","7","Ami suwirumjai aints ainautinka amukratme. Tura kajekakminkia, napchau nintimsar pujaji. ");
INSERT INTO acuNT_vpl VALUES ("PS90_8","020_90_8","PSA","90","8","8","Ii tunaaringkia tura ii pasé nintimtairisha ameka paan nekame. ");
INSERT INTO acuNT_vpl VALUES ("PS90_9","020_90_9","PSA","90","9","9","Ame kajekakminkia, ii iwiaakmauringkia aints mayairawa nunisang wári nangkaankatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS90_10","020_90_10","PSA","90","10","10","Iikia setenta (70) musach pujusminuitji. Tura kakaram akurkia ochenta (80) musach pujusminuitji. Ii musachri wári nangkamartin asaramtai, wári jakatnuitji. Antsu sungkurjai wait wajayatrik, tura najaimiayatrik jampesrik: Miajuitjai taji. ");
INSERT INTO acuNT_vpl VALUES ("PS90_11","020_90_11","PSA","90","11","11","Yusru ¿ame suwirumnasha yáki neka? ¿Tura ame kajekmaurumnasha yáki neka? ");
INSERT INTO acuNT_vpl VALUES ("PS90_12","020_90_12","PSA","90","12","12","Apuru jumchik musach iwiaaku pujarme tusam nintimtikiartukta. Nu turakmin nekasar paan nintimratnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS90_13","020_90_13","PSA","90","13","13","Apuru yaimkartukta, tura suwirum inaisata. Iikia aminu inatiram asakrin, ame wait anengkratairum nekamtikiartukta. ");
INSERT INTO acuNT_vpl VALUES ("PS90_14","020_90_14","PSA","90","14","14","Ame anengkratairum kashik ii nintin piaku ati tusam wakeruku ata. Turakmin iisha tuke warasar kantamatatji. ");
INSERT INTO acuNT_vpl VALUES ("PS90_15","020_90_15","PSA","90","15","15","Iikia untsuri musach wait wajayaji nuna nangkamasmek untsuri musach warastaram tusam sukartusta. ");
INSERT INTO acuNT_vpl VALUES ("PS90_16","020_90_16","PSA","90","16","16","Iikia ami inatiram asar, ami kakarmaram wainkatasar wakeraji. Tura ii wearisha ame pengkeerumin wainkarti tusam nintimtikrarta. ");
INSERT INTO acuNT_vpl VALUES ("PS90_17","020_90_17","PSA","90","17","17","Apuru ii Yusri asam, ame pengkeerum sukartusta. Tura ii takatrin takakmakur pujakrincha, nekasam pengker awajkartusta tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_1","020_91_1","PSA","91","1","2","Aints Yus wina ejarkati tusa, Yusen nekas juuntan tura nekas kakarman seatas wakerakka tu seatnuitai: “Ameketme wina ayamrutkatnumka, tura wina ejarkatnumka. Tura wina Yusur asakmin, wikia amin nintimtusan pujajme”. ");
INSERT INTO acuNT_vpl VALUES ("PS91_3","020_91_3","PSA","91","3","3","Yusek ningki amin ayamrutmaktinuitai. Tura sungkur ainamunmasha ningki amin tsuwarmartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS91_4","020_91_4","PSA","91","4","4","Atash ni uchichirin nanapejai tektuk pujawa nunisang waitmaktinuitai. Tura ni wait anengkratairi tantaara tumau asamtai, nekasam wina ejarkatnuitme tusam, pengker nintimsam pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_5","020_91_5","PSA","91","5","5","Tura kashisha mantuwarai tusam, tura tsawaisha tsentsak wina tukuri tusam, shamtsuk pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_6","020_91_6","PSA","91","6","6","Tura teetisha iwianch achirkai tusam, tura tsawai sungkur achirkai tusam, nuka nintimtsuk shamtsuk pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_7","020_91_7","PSA","91","7","7","Ame menarminini untsuri aints sungkurjai jainau wainiatmek, tura ami untsurminini untsuri aintsun maainau wainiatmek, ameka jakashtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_8","020_91_8","PSA","91","8","8","Yus pasé ainaun wait wajaktiniun susatnuitai, antsu ameka waitka wajakchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_9","020_91_9","PSA","91","9","10","Yus nayaimpinam puja nuka wina ejarkatnuitai tusam, tura wina ayamrutkatnuitai tau asam, pasé aa nuka wainkashtinuitme, turasha sungkursha jeemningkia utuashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS91_11","020_91_11","PSA","91","11","11","Ame tuni wekaame nunisha Yus ni awemamuri irunun amin waitmakarat tusa inatmartatui. ");
INSERT INTO acuNT_vpl VALUES ("PS91_12","020_91_12","PSA","91","12","12","Tura nawemin kayan tukumkai tusar, ni uwejejai achirmakartatui. ");
INSERT INTO acuNT_vpl VALUES ("PS91_13","020_91_13","PSA","91","13","13","Tura asamtai juun yawaa tura napisha tura titingsha tura pachim ainamunmasha wekaasatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS91_14","020_91_14","PSA","91","14","14","Yus chichaak: “Aints wina anentinak: Ameketme Apum turutinaunka wikia uwemtikratnuitjai, turan ayamruktinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS91_15","020_91_15","PSA","91","15","15","Tura wina yainkata turutinamtaikia, wikia yaingtinuitjai, tura nijai tsaniasan pujustinuitjai. Tura napchau nintimsar pujuinamtaikia angkanmamtikiatnuitjai. Tura nu aintsnaka pachisan: Nekas pengkeraitai titinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS91_16","020_91_16","PSA","91","16","16","Tura nukap musach pujusti tusan wainkatnuitjai, tura pujut nangkankashtinun susatnuitjai”, Yus tawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_1","020_92_1","PSA","92","1","1","Apuru nayaimpinam pujame nu, amin maaketai titasan wakerajme. Tura ameketme juuntam tusan, amincha kantan kantamruatasan wakerajme. ");
INSERT INTO acuNT_vpl VALUES ("PS92_2","020_92_2","PSA","92","2","3","Tura kashiksha tura angkuanmataisha arawirjai tura arpajaisha tura kitarrjaisha ami wait anengkratairmin pachisan, tura ami pengkeerumin pachisan aints ainaun ujakartasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_4","020_92_4","PSA","92","4","4","Apuru ami turamurmijai winaka pengker awajtusuitme. Tura asakmin ami takatrumin nintimsan pujaknaka waraajai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_5","020_92_5","PSA","92","5","5","Apuru ami takatrum timiá pengker ainawai, tura ami nintimaurumka nekasar paan ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_6","020_92_6","PSA","92","6","6","Aya nintinchau ainauka nunaka nekaachmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_7","020_92_7","PSA","92","7","7","Pasé aints ainau tura mangkartin ainau nupaaya nunisarang yujartin ainawai. Tura yujainayat tuke mengkaakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_8","020_92_8","PSA","92","8","8","Antsu ameka Apuru tuke nayaimpinam yakí pujuwitme. ");
INSERT INTO acuNT_vpl VALUES ("PS92_9","020_92_9","PSA","92","9","9","Apuru ami nemasem ainauka nekasar mengkaakartin ainawai. Tura tunau takau ainausha mash niish niish tupikiakiar mengkaakartin ainawai tusan nekajai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_10","020_92_10","PSA","92","10","10","Ami kakarmaram waaka aishmangkria nunisang ati tusam kakamtikruruitme. Tura kungkutijai muukrun ukatrurua nunisketme. ");
INSERT INTO acuNT_vpl VALUES ("PS92_11","020_92_11","PSA","92","11","11","Wina nemasur ainau ayainaun wainkatnuitjai. Turasha nu mangkartin ainau juutmaurincha antuktinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_12","020_92_12","PSA","92","12","12","Antsu pengke aints ainauka kungkuk nereawa nunisarang artinuitai. Turasha kanu muranam shaung tsakainawa nunisarang artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_13","020_92_13","PSA","92","13","13","Pengke aints ainauka Yuse jeen tu pujuinau asar pengker nintiminawai. Tura ii Yusri pujutirin tsakararua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_14","020_92_14","PSA","92","14","14","Weamraru ainayat tuke numi nerekua nunisarang ainawai. Tura asar natsa nunisarang tuke kakaram ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS92_15","020_92_15","PSA","92","15","15","Tura aints ainaun ujainak: Apurka wina ejarnuitai. Turasha pengker aa nunak tuke turawai. Antsu tunaunaka pengké takachuitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS93_1","020_93_1","PSA","93","1","1","Ii Apuringkia mash nungkanmaya ainaun inawai. Turasha tuke paaniunam pujuwitai. Tura timiá kakaram asa, nungka muchikchati tusa tuke wainui. ");
INSERT INTO acuNT_vpl VALUES ("PS93_2","020_93_2","PSA","93","2","2","Apuru ameka tuke pujuu asam, ami keemtairmin keemsam nayaimpinam pujuuwitme. ");
INSERT INTO acuNT_vpl VALUES ("PS93_3","020_93_3","PSA","93","3","3","Entsa tampaaramuri wej wajau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS93_4","020_93_4","PSA","93","4","4","Antsu ameka Apuru nayaimpinam pujame nu, entsa wej wajau nangkamasmek kakarmaitme. Tura juun entsa tampaaramurin nangkamasmek kakarmaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS93_5","020_93_5","PSA","93","5","5","Apuru ame chicham akupamurmeka yapajiachmin ainawai. Tura asaramtai aminu aintsrum ainauka ami jeemin wayaawar, tuke tunaarinchau arti tusam wakerame. ");
INSERT INTO acuNT_vpl VALUES ("PS95_1","020_95_1","PSA","95","1","1","Ii Apuri warartakur kantamruami tusaram winitaram. Iin ejarmak uwemtikramin asamtai kantamruami. ");
INSERT INTO acuNT_vpl VALUES ("PS95_2","020_95_2","PSA","95","2","3","Ii Apuringkia Yusketai tura juuntaitai. Tura mash aints ainau yusri nangkamasketai. Tura asamtai maaketai tusar ni pujamurin wayaawarmi. Turasha ameketme juuntam tusar kantamruami. ");
INSERT INTO acuNT_vpl VALUES ("PS95_4","020_95_4","PSA","95","4","4","Nungka nitkarin ainia nusha mash niinu ainawai. Tura mura timiá juun ainausha niinu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS95_5","020_95_5","PSA","95","5","5","Tura juun entsancha tura nungkancha ningki ni uwejejai najanau asa niinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS95_6","020_95_6","PSA","95","6","6","Yus iinka najatmau asamtai, tikishmatrar ii Yusri warartusmi tusaram winitaram. Tura ii Apuri maaketai takur tikishmatrarmi. ");
INSERT INTO acuNT_vpl VALUES ("PS95_7","020_95_7","PSA","95","7","7","Ningki ii Yusrintai. Tura asamtai iisha ni aintsri ainiaji. Tura asakrin uwija wainin ni uwijarin wainua nunisang iincha waitmaji. Yus atumin turama nuka yamaikia antuktaram: ");
INSERT INTO acuNT_vpl VALUES ("PS95_8","020_95_8","PSA","95","8","8","“Yamaikia wina chichamur antukrumka, nakitsuk pengker anturtuktaram. Atumi juuntri ainau yaanchuik nungka Meriba tutainum tura chikich nungka Masa tutainum aints atsamunam wekainak wina chichamrun nakitrarmia nunisrumka nakitrairap. ");
INSERT INTO acuNT_vpl VALUES ("PS95_9","020_95_9","PSA","95","9","9","Nuningkia wi turamurun waininayat, atumi juuntri ainau winaka nekaprinak umirtukcharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS95_10","020_95_10","PSA","95","10","10","Turinau asaramtai wikia cuarenta (40) musach nu aints ainaun kajerkaran: Nuka tuke nintinchawa nunisarang asar, wina chichamrun umirtutan nakitinawai timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS95_11","020_95_11","PSA","95","11","11","Tura kajerkaran chicham yapajiachminun chichaarinakun: Wi Yus asan, pengke nungkanam tuke pujustinnaka tsangkatkashtatjarme timiajai”. ");
INSERT INTO acuNT_vpl VALUES ("PS96_1","020_96_1","PSA","96","1","1","Ii Apuri yamaram kanta kantamruami. Mash nungkanmaya ainautiram, ii Apuri pachisrum kanta kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_2","020_96_2","PSA","96","2","2","Ii Apuri kantamrakrum ni naari pachisrum pengkeraitai titaram. Tura Yus aints ainautin uwemtikramratas wakerutmaji tusaram, kintajai metek etserkataram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_3","020_96_3","PSA","96","3","4","Ii Apuringkia juuntaitai. Tura asamtai tuke ni: Ameketme juuntam titinuitji. Ii Yusringkia chikich nungkanmaya ainau yusri nangkamasang timiá kakarmaitai. Tura asamtai mash nungkanmaya ainamunam Yuse kakarmari tura ni pengkeeri pachisrum chichastaram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_5","020_96_5","PSA","96","5","5","Chikich nungkanmaya ainau yusringkia Yuschau ainawai. Antsu ii Yusringkia nayaimpin najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS96_6","020_96_6","PSA","96","6","6","Yuse paaniuringkia jiitsumraitai. Tura ni pujamurinka ni kakarmari tura ni pengkerisha ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS96_7","020_96_7","PSA","96","7","7","Mash nungkanmaya ainautiram, ii Yusri: Ameketme kakarmam tura ameketme pengkeram titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_8","020_96_8","PSA","96","8","8","Ii Yusringkia tuke warartakrum: Ameketme juuntam titaram. Tura Yuse jeen wayaaram, Yus warí susatasrum wakerarme nu itataram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_9","020_96_9","PSA","96","9","9","Nunia Yuse jee timiá pengkernum wayaaram: Ameketme Yusem titaram. Mash nungkanmaya ainau niin shaminak kurarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS96_10","020_96_10","PSA","96","10","10","Atumka mash nungkanmaya aints ainau chicharkuram: Ii Apuringkia mash nungkanmaya aints ainaun metek inawai. Tura atumnasha mash inatmak puja nuka nungka muchikai tusa wainui titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS96_11","020_96_11","PSA","96","11","11","¡Nayaim tura nungka ainausha ii Yusrin mash wararsarti! ¡Turasha juun entsa tampaarisha tura juun entsa nitkarin irunusha ii Yusrin mash wararsarti! ");
INSERT INTO acuNT_vpl VALUES ("PS96_12","020_96_12","PSA","96","12","13","¡Tura nungkanam wekain ainausha ii Yusrin mash wararsarti! ¡Tura ii Apuri tatin asamtai, numi ainausha mash ii Yusrin wararsarti! Ii Apuringkia nekas ii nungkarin tatinuitai. Tura taa aints ainaun mash nekas pengker inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_1","020_97_1","PSA","97","1","1","Mash nungkanmaya ainautiram warastaram. Chikich nungkanmaya ainautirmesha arák pujayatrum atumsha warastaram. Ii Apuringkia mash nungkanmaya ainau Apurintai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_2","020_97_2","PSA","97","2","2","Mukunit shuwin ii Apurinka tentenawai. Nuni ni keemtairin keemas aints ainaunka mash metek inawai. Pengke aints ainaun ni turamurijai metek pengker awajsatnuitai. Tura pasé aints ainauncha ni pasé takasmaurijai metek wait wajaktiniun susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_3","020_97_3","PSA","97","3","3","Yus ni nemase ainaun niin tentakar wajainaun wainak jiin akuptuk aasatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_4","020_97_4","PSA","97","4","4","Tura charpin akupak nungkan paan najanatnuitai. Tura mash nungkanam pujuinau nuna jiisar kurarartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_5","020_97_5","PSA","97","5","5","Ii Apuringkia mash nungka ainau nurinuri asa, ni wakerakka mura ainau wapasa mikiaria nunisarang minararti tusa najanatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_6","020_97_6","PSA","97","6","6","Nayaimpinmayang Yus aints ainaun iniartas mash metek jiiawai. Tura asamtai mash nungkanam pujuinauka ni paaniurincha waininawai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_7","020_97_7","PSA","97","7","7","Aints ainau ni yusrin Yuschau waininayat ningki najanawar jampesarang: Juka ii yusrintai tinu ainaunka ii Yusringkia inatsaartinuitai. Aints ainau ni yusrin najanamu asar, ii nekas Yusrin tsuntsumruwartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_8","020_97_8","PSA","97","8","9","Apuru nayaimpinam pujame nu, mash nungkanmaya ainau inawaitme. Tura mash nungkanmaya ainau yusri nangkawaitme. Tura asakmin Jerusalén yaktanam pujuinauka tura Judá nungkanam pujuinausha ami chichammin nintimsar nukap warainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_10","020_97_10","PSA","97","10","10","Ii Apuri aneetiri ainautiram, pasé turutinkia nakitrataram. Ningki ni umirin ainautinka waitmaktinuitji. Tura pasé aints ainamunmaya angkanmamtikramatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS97_11","020_97_11","PSA","97","11","11","Pengke aints ainauka tura anangkartichu ainausha warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS97_12","020_97_12","PSA","97","12","12","¡Pengke aints ainautirmeka atumi Apuri warartustaram! ¡Tura ni naari pachisrum: Ameketme Yusem titaram! ");
INSERT INTO acuNT_vpl VALUES ("PS98_1","020_98_1","PSA","98","1","1","¡Ii Apuringkia wainchati takatan untsuri takasu asamtai, yamaram kanta kantamruami! Ni nemase ainaun ni kakarmarijai nepetkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS98_2","020_98_2","PSA","98","2","2","Ii Apuringkia ni aintsri ainautin ayamrutmakmaurin mash nungka ainamunam nekamtikiamiayi. Pengke aints ainaun ayamruktinuitai, tura pasé aints ainaunka nepetkatnuitai tusa nekamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS98_3","020_98_3","PSA","98","3","3","Tura Israela weari ainaun wait anentramia nunaka tura niin pengker awajsamia nunasha kajinmakchamiayi. Tura asamtai mash nungka ainamunam ii Yusri ni aintsri ainautin uwemtikramramiaji nuna wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS98_4","020_98_4","PSA","98","4","4","Mash nungkanmaya ainautiram, ii Yusrin wararsaram kantamruataram. Tura ii Yusrin nukap wararsaram, Yus kanta ainau kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS98_5","020_98_5","PSA","98","5","5","Tura ii Apurin kantamrakrum arpajaisha tura kitarrjaisha kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS98_6","020_98_6","PSA","98","6","6","Turasha warasrum, ii Apuri Yus kantamrakrum, nangku umpungmaikiakrum kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS98_7","020_98_7","PSA","98","7","7","Juun entsa tampaarisha, tura juun entsanam nanaminausha tura mash nungkanam pujuinausha ii Yusrin mash wararsarti. ");
INSERT INTO acuNT_vpl VALUES ("PS98_8","020_98_8","PSA","98","8","8","Tura entsa wej wajainausha Yusnak mash wararsarti. Tura mura ainausha mash iruntrar ii Apurin wararsarti. ");
INSERT INTO acuNT_vpl VALUES ("PS98_9","020_98_9","PSA","98","9","9","Ii Apuringkia mash nungkanmaya ainaun inartas winitnuitai. Tura nekas pengker asa pengke aints ainaun ni turamurijai metek pengker awajas, tura pasé aints ainauncha ni pasé takasmaurijai metek wait wajaktiniun susa inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS99_1","020_99_1","PSA","99","1","1","Ii Apuringkia mash nungkanmaya ainau inawai. Ni keemtairingkia Yuse awemamuri yakinini puusamuitai. Tura asamtai mash nungkanmaya ainau shaminak kurarartinuitai. Tura nungka ainausha muchitkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS99_2","020_99_2","PSA","99","2","2","Ii Apuri nekas juun aa nuka mura Sión tutainum pujuwitai. Turasha mash nungkanmaya aints ainaun inawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS99_3","020_99_3","PSA","99","3","3","Tura asamtai mash nungkanmaya aints ainau: Ameketme juuntam tura ameketme timiá kakarmam tiarti. ¡Yuska pengké tunaarinchawaitai! ");
INSERT INTO acuNT_vpl VALUES ("PS99_4","020_99_4","PSA","99","4","4","Ame nekas kakaram inakratin asam, aints ainausha mash metek iname. Tura asam Jacobo weari ainau ni pengker turamurijai metek pengker awajnuyame. Tura pasé aints ainausha ni pasé turamurijai metek wait wajaktin suyame. ");
INSERT INTO acuNT_vpl VALUES ("PS99_5","020_99_5","PSA","99","5","5","Ii Apuri ii Yusri asamtai, warartustasrum tikishmatrataram. ¡Yuska pengké tunaarinchawaitai! ");
INSERT INTO acuNT_vpl VALUES ("PS99_6","020_99_6","PSA","99","6","6","Moisés tura Aarónsha Yuse chichame etserin armiayi. Samuelsha chikich aints ainaujai Yuse naarin pachis: Ameketme juuntam timiayi. Tura Apuru yainkata tinamtai, niisha anturak yainuyayi. ");
INSERT INTO acuNT_vpl VALUES ("PS99_7","020_99_7","PSA","99","7","7","Yus mukuntiunmaya niijai chichasmiayi. Turamtai ni chicham akupkamuncha umirkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS99_8","020_99_8","PSA","99","8","8","Apuru ii Yusri asam, ami chichammin etserin ainau amin seatminamtai anturnuyame. Ame tsangkukratin asam, ni tunaari ainausha tsangkurnuyame. Antsu ami chichammin umirtan nakitin ainauka ni wait wajaktintrisha suyame. ");
INSERT INTO acuNT_vpl VALUES ("PS99_9","020_99_9","PSA","99","9","9","Ii Apuri ii Yusri asamtai, warartusrum ni murarin nekas pengker aa nuni wakaram maaketai titasrum tikishmatrataram. ¡Ii Yusri, ii Apuri aa nuka pengké tunaarinchawaitai! ");
INSERT INTO acuNT_vpl VALUES ("PS100_1","020_100_1","PSA","100","1","1","Mash nungkanmaya ainautiram, warasrum Yus nintimsaram kanta kantamataram. ");
INSERT INTO acuNT_vpl VALUES ("PS100_2","020_100_2","PSA","100","2","2","Ii Yusri nintimsaram warasrum ni umirkataram. Tura warasrum ii Apuri: Ameketme juuntam titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS100_3","020_100_3","PSA","100","3","3","Yuska iinu Apurintai titaram. Ni najatmamiaji. Tura asamtai niinuitji. Ni aintsri asakrin, aints ni uwijarin wainua nunisang iincha waitmaji. ");
INSERT INTO acuNT_vpl VALUES ("PS100_4","020_100_4","PSA","100","4","5","Ii Apuri pengkeraitai, tura ni anengkratairi nangkankashtinuitai. Tura ni timiaurinka tuke umiktinuitai. Tura asamtai Yuse jeen wayaaram Yus maaketai takuram kanta kantamataram. Tura ameketme juuntam tusaram wayaataram. Tura ni naari pachisrum nekas pengkeraitai tusaram, Yus maaketai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS101_1","020_101_1","PSA","101","1","1","Yusru wikia ami anengkratairmin tura ami pengkeerumnasha warartustasan wakerajai. Tura asan amincha kantamruatasan wakerajme. ");
INSERT INTO acuNT_vpl VALUES ("PS101_2","020_101_2","PSA","101","2","2","Turasha tunaarinchau pujustasan wakerajai. ¿Amesha winisha warutik winitam? Wina jearun pujaknasha pengké tunaarinchau pujustasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_3","020_101_3","PSA","101","3","3","Tura pasé turutniunka wikia pengké nintimrashtatjai. Yusen umirtan nakitinaunka wikia nakitajai. Tura asan wini pengké winicharti tusan nakitratatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_4","020_101_4","PSA","101","4","4","Tura pasé nintimtancha pengké nintimrashtatjai. Tura pasé aa nunaka turutnasha nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_5","020_101_5","PSA","101","5","5","Aints anumkar ni irutkamurin pachisar pasé chichari nauncha itatmamtikiatatjai. Tura miajuitjai tumamin ainaunka jiitnasha nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_6","020_101_6","PSA","101","6","6","Antsu aints anangmichu ainau wijai tsaniasar pujusarti titatjai. Tura Yusen umirkaru ainau nuke wina inatir arti tusan tsangkatkatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_7","020_101_7","PSA","101","7","7","Anangkartin ainauka kichkisha wina jearningkia pujuschartin ainawai. Tura wait chichamrintin ainausha kichkisha wijaingkia tsaningchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS101_8","020_101_8","PSA","101","8","8","Kintajai metek wina nungkarun pasé aints ainaunka itatmamtikiatnuitjai. Tura pasé takau ainaunka mash Yuse yaktarinian jiiktinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_1","020_102_1","PSA","102","1","1","Apuru wi seamur anturtukta. Tura wi untsummataisha, wait aneasam anturtukta. ");
INSERT INTO acuNT_vpl VALUES ("PS102_2","020_102_2","PSA","102","2","2","Wi shamakun pujamtaisha, winaka anturtutskeka pujusaip. Antsu wait aneasam anturtukta. Tura wi seamsha wári airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS102_3","020_102_3","PSA","102","3","3","Wina iwiaakmauruka mukuntinua nunisang mengkaawai. Tura ukunchrusha kaii keenawa nunisarang kuntur awajtinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_4","020_102_4","PSA","102","4","4","Tura wina nintirsha nupaa jaawa nunisang kakarchamin nekapeawai. Tura asan yutancha nintimtsujai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_5","020_102_5","PSA","102","5","5","Wi timiá juutuj pujau asamtai, wina nuwaprusha ukunchrun nujatinawa nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_6","020_102_6","PSA","102","6","6","Tura asan ampush jea itarkanam pujawa nunisketjai. Ampush jea yumpunkamunam pujus shinawa nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_7","020_102_7","PSA","102","7","7","Wikia kanutnasha kanatsjai. Antsu suwich ningki jea tuntupen keemas pujawa nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_8","020_102_8","PSA","102","8","8","Wina nemasur ainauka tuke jiyatinawai. Tura wina naarun pachisar pasé chichartinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_9","020_102_9","PSA","102","9","10","Ame wina kajertuku asam, yakí wakata turutiatum, nungka ajuarmawa nunisnak nekapmamjai. Tura asan wikia pangkan yuwayatun, yukuun yuwawa nunisnak nekapmamjai. Tura umutirun umaknasha, neaikirjai pachimran umajai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_11","020_102_11","PSA","102","11","11","Wina kintarka mukuntiua nunisang nangkaaminawai. Tura asaramtai nupaa jajatua nunisnak nekapmamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_12","020_102_12","PSA","102","12","12","Antsu Apuru ameka aints ainauka nekasam tuke inawaitme. Tura asakmin amin naarminka tuke kajinmakchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_13","020_102_13","PSA","102","13","13","Apuru ame tsangkukratkatin kintaka yanchuk jeau asamtai, wári ami aintsrum ainau wait anentrarta. ");
INSERT INTO acuNT_vpl VALUES ("PS102_14","020_102_14","PSA","102","14","14","Ami inatiram ainauka ami jeem yumpunkaun nintimsar aneenawai. Tura ami jeem yumpunkaun jiisar wake mesekar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_15","020_102_15","PSA","102","15","17","Ii Apuri ataksha mura Sión tutainum wina jear jeartuktaram tusa, ni paaniurijai nuni wantintuk, ayamrumichu ainau seamurin antuk pachistinuitai. Turatin asamtai mash nungkanmaya aints ainau ii Apuri naari nekas pengker aa nuna pachisar: Ameketme juuntam tiartinuitai. Tura mash nungkanmaya apu ainausha ii Apuri pengkerin wainkar: Ameketme pengkeram tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_18","020_102_18","PSA","102","18","18","Ukunam akiinawartin ainausha ii Apurin warartusarti tusar ju chichamka aarmau atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_19","020_102_19","PSA","102","19","20","Ii Apuri kársernum achikmau pujuinau juutinamurin antuktas, tura maawartin ainauncha angkanmamtikiatas, nayaimpinmayang nungkan jiismayi. ");
INSERT INTO acuNT_vpl VALUES ("PS102_21","020_102_21","PSA","102","21","22","Mash nungkanmaya aints ainau ii Apurin warartusartas iruntrarti, tura Jerusalén yaktanam mura Sión tutainum ni naarin pachisar chichasarti tusa, ii Apuri nayaimpinmayang nungkan jiismayi. ");
INSERT INTO acuNT_vpl VALUES ("PS102_23","020_102_23","PSA","102","23","23","Wikia aints jinta wekaa wekaaka japening pimpirua nunisketjai. Tura musaachrisha jumchik ati tusa Yus pujutrun jurutkinua nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_24","020_102_24","PSA","102","24","24","Tura asan Yusrun chicharkun: “Jumchik musaach pujusu asan, wina pujutruka jurutkiip”, tajai. ¡Ameka tuke pujuwitme! ");
INSERT INTO acuNT_vpl VALUES ("PS102_25","020_102_25","PSA","102","25","25","Apuru nu nangkamtaik nungkasha tura nayaimpisha najanamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS102_26","020_102_26","PSA","102","26","26","Nuka mai mengkaakartin ainawai. Antsu ameka tuke pujustinuitme. Nungkasha tura nayaimpisha tarach arut mamuawa nunisarang mengkaakartinuitai. Aints wejmakan aik chikichan entsawa nunismek nayaimpisha tura nungkasha yapajiatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS102_27","020_102_27","PSA","102","27","27","Antsu ameka yapaijmiamashtinuitme. Tura asam ami pujutrumka pengké nangkankashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS102_28","020_102_28","PSA","102","28","28","Ami inatirmi weari ainausha shamtsuk pujusarti tusam, ameka pengker awaasatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS103_1","020_103_1","PSA","103","1","1","Wikia tuke nintirjai Apurun maaketai titatjai. Ni naarin pachisan tuke: Yus pengkeraitai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_2","020_103_2","PSA","103","2","2","Wikia tuke nintirjai Apurun maaketai titatjai. Wina pengker awajtusmia nunaka pengké kajinmakchatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_3","020_103_3","PSA","103","3","3","Ningki wina tunaarunka mash tsangkutrurtinuitai. Tura wina najaimiamurun mash tsuwaaratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_4","020_103_4","PSA","103","4","4","Tura mengkakai tusa tuke uwemtikrurtinuitai. Tura ni anengkratairijai tuke pengker awajtustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_5","020_103_5","PSA","103","5","5","Tura pengker aa nuna mash surustinuitai. Tura juunmaran pujayatnak, kukui yakí nanamina nunisnak kakaram wajastinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_6","020_103_6","PSA","103","6","6","Chikich aintsun pasé awajinamtaisha, ii Yusri nekas tunaarinchau asa, nu wait wajainaunka ayamruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_7","020_103_7","PSA","103","7","7","Moisésnasha tura Israel ainautincha ni wakeramurin tura ni turamurincha nekamtikramamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_8","020_103_8","PSA","103","8","8","Ii Yusri iin wait anentramji. Tura asa wárikia kajechuitai. Tura iincha nukap anenmaji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_9","020_103_9","PSA","103","9","9","Yuska iinka kintajai metekka paseetme turamtsuji, tura asa tukeka kajertamkashtinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_10","020_103_10","PSA","103","10","10","Iikia tunau arining, wait anentramu asa, iinka amutmakchamiaji. Tura ii pasé turamurincha yapaijtamtsuk tsangkutramramiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_11","020_103_11","PSA","103","11","11","Yus ni umirkautinka tuke anenmaji. Nayaim nangkatkamurisha atsau asamtai, Yuse anengkratairingkia pengké nangkankashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_12","020_103_12","PSA","103","12","12","Tura tsaa taakmau tsaa jeamujai pengké tsaningchamin aa nunisang Yuska atumi tunaaringkia pengké wainkashtinuitrume tusa yaja japrutmamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_13","020_103_13","PSA","103","13","14","Yus iin itiur najanamiaja tusa paan nekawai. Iinka nungka tsetseri najatmau asa, aints ni uchirin wait anentawa nunisang Yus ni umirin ainautinka wait anentramaji. ");
INSERT INTO acuNT_vpl VALUES ("PS103_15","020_103_15","PSA","103","15","15","Aintsu pujutri nupaaya tumawaitai. Nupaa tsapai yangkurui. ");
INSERT INTO acuNT_vpl VALUES ("PS103_16","020_103_16","PSA","103","16","16","Tura nase kakaram nasenmatai, yangkurka mengkawai. Tura tuning aya tusarsha aints kichkisha nekaacharminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_17","020_103_17","PSA","103","17","18","Antsu ni chichamen kajinmatsuk umirinauka Yuse anengkratairi tuke nangkankashtinuitai tusar nekainawai. Tura ni weari ainauncha Yus tuke wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_19","020_103_19","PSA","103","19","19","Ii Yusri keemtairi nayaimpinam pujawai. Tura nuni keemas mash nungkanmaya ainauncha inawai. ");
INSERT INTO acuNT_vpl VALUES ("PS103_20","020_103_20","PSA","103","20","20","Yuse awemamuri timiá kakaram ainautiram Yuse chichamen tuke antukrum umirkau asaram ii Apuri ameketme juuntam titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS103_21","020_103_21","PSA","103","21","21","Yuse awemamuri ainautiram, ni inatiri asaram, tura ni wakeramuri umirkau asaram, mash ii Apuri ameketme juuntam titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS103_22","020_103_22","PSA","103","22","22","Mash najanamu ainausha mash nungkanam pujuina nu ii Apurin ameketme pengkeram tiarti. Wikia tuke nintirjai Apurun maaketai titatjai. Nuke ati. ");
INSERT INTO acuNT_vpl VALUES ("PS104_1","020_104_1","PSA","104","1","1","Wina nintirjai tuke Yus pengkeraitai titatjai. Yusru ameketme juuntam. Ameketme kakarmam. ");
INSERT INTO acuNT_vpl VALUES ("PS104_2","020_104_2","PSA","104","2","2","Ameka paantin asam, tarachia tumau nayaimpisha najanawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS104_3","020_104_3","PSA","104","3","4","Ameka entsa ainausha najanawaitme. Tura mukuntiunam wekainuitme. Tura nase najanau asam, tuke nase akupnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS104_5","020_104_5","PSA","104","5","5","Ameka nungka pengké muchikchati tusam metamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS104_6","020_104_6","PSA","104","6","6","Tura juun entsa timiá kuna asa, nungkan netkati tusam, ame tsangkamkamiame. Tura asakmin juun entsaka murancha netkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS104_7","020_104_7","PSA","104","7","7","Tura wainiatum ameka juun entsa kuyuati tusam chicharkamiame. Tura asakmin juun entsaka ami chichammin ipiamta tumaun antuk wári kuyuamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS104_8","020_104_8","PSA","104","8","9","Juun entsa kuyuamtai, mura ainau tsapuiniarmiayi. Tura juun entsaka ataksha nungkanka mashkia netchau ati tusam surimkau asakmin, ataksha ni nangkaankatniurin kuyuamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS104_10","020_104_10","PSA","104","10","10","Tura muranam pukuni ainia nu entsa arti tusam, amek akupnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS104_11","020_104_11","PSA","104","11","11","Tura pachim ainau yumin umurarat tusam, entsa muranmasha tura paka nungkanmasha akupnuitme. Pachim yupiram ainia nusha umurarmi tusam, entsasha najanawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PS104_12","020_104_12","PSA","104","12","13","Nanamtin ainau entsa yantamen pujuinauka shiniinawai. Yumi umurarat tusam mukuntiunmaya yumi akupnuitme. Ameka mash najanau asam, ni yutairisha suame. ");
INSERT INTO acuNT_vpl VALUES ("PS104_14","020_104_14","PSA","104","14","15","Chirichri waaka ainau yuwaarat tusam najanawaitme. Aints ainausha yutancha yuwaarti tusam, ni yutairisha suame. Tura yutai nereu ainau aints nungkanmaya uweniar yuwaarti tusam suame. Nunia olivo macharijai ni namangken yakararti tusam suame. Nunia ni yutairisha tuke suame. Tura umutirincha umurarti tusam suame. ");
INSERT INTO acuNT_vpl VALUES ("PS104_16","020_104_16","PSA","104","16","16","Numi ainau juun wajasarti tusam numpesha suame. Kanu ainausha amek araawitme. ");
INSERT INTO acuNT_vpl VALUES ("PS104_17","020_104_17","PSA","104","17","17","Nanamtin ainauka numinam pasungminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_18","020_104_18","PSA","104","18","18","Tura chipu yupiram ainau muranam yakí wekajinawai. Chikich kuntin ainausha waanam matsatinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_19","020_104_19","PSA","104","19","19","Aints ainau nantun nekaawarti tusam, nantusha najanamiame. Tura tsaasha ame najanamu asa, kintajai metek jeawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_20","020_104_20","PSA","104","20","20","Ame tee ati tama tee wajawai. Pachim ainau tura kuntin ainausha kashisha wekainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_21","020_104_21","PSA","104","21","21","Juun yawaa ainau ni uchiri yutairincha eatinawai. Turinamtai Yus ni yutairincha suawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_22","020_104_22","PSA","104","22","22","Tura tsawaarmatai ataksha waanam wayaawar tepeenawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_23","020_104_23","PSA","104","23","23","Aints ainau tsawaarar jeanmaya jiinkiar, ni takatrin takakmasartas weenawai. Nunia kiarai waketkiar, ataksha ni jeen waketinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_24","020_104_24","PSA","104","24","24","Yusru ami takatrum timiá untsurintai. Ame nekamtairumjai mash najanawaitme. Ame najanamu asar mash nungkanam yujainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_25","020_104_25","PSA","104","25","25","Juun entsasha sarmaitai. Nuni namak juuncha tura tuupchisha yujainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_26","020_104_26","PSA","104","26","26","Nuni kanu juunnum aints engkemawar wekainawai. Apuupsha nuni wekainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_27","020_104_27","PSA","104","27","27","Ame mash yujaina nuna yutairisha suame. ");
INSERT INTO acuNT_vpl VALUES ("PS104_28","020_104_28","PSA","104","28","28","Ame suam ni yutairincha juwinawai. Ame uwejem yapaarakmin tutuarar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_29","020_104_29","PSA","104","29","29","Ame yuta suachmaka wake mesekar pujuinawai. Ame mayatairisha juramka, aints ainausha jakar ataksha nungka tsetseri najanartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_30","020_104_30","PSA","104","30","30","Ame ni mayatairi suamu asar, ataksha nungkanam yujarmi tusar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_31","020_104_31","PSA","104","31","31","Yuse kakarmari tuke nangkankashtinuitai. Ni takatri ainaujai Yuska waraawai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_32","020_104_32","PSA","104","32","32","Yus uurkat tama nungkaka muchiawai. Tura muran takasamtai, mukunit jiinui. ");
INSERT INTO acuNT_vpl VALUES ("PS104_33","020_104_33","PSA","104","33","33","Tura asamtai Yusen tuke nintimsan kantamatajai. Iwiaaku pujaknaka Yusrun Salmon kantamruatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_34","020_104_34","PSA","104","34","34","Wikia Yusrun tuke pengker nintimtusan pujajai. Tura Yusnum tuke warastinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS104_35","020_104_35","PSA","104","35","35","Tunaarintin ju nungkanam matsatinau mengkakartin ainawai. Tura Yusen umirtan nakitinausha mash mengkakartin ainawai. Antsu wikia tuke nintirjai Yus pengkerapita tura Yus juuntapita titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS105_1","020_105_1","PSA","105","1","1","Ii Apuri maaketai titaram. Tura ni naari pachisrum aints ainau ujaktaram. Turuaram ni turamurisha mash aints ainau nekamtikiataram. ");
INSERT INTO acuNT_vpl VALUES ("PS105_2","020_105_2","PSA","105","2","2","Ii Apuri pengker awajsatasrum kanta kantamataram. Tura ni wainchati takatrin pachisrum chichastaram. ");
INSERT INTO acuNT_vpl VALUES ("PS105_3","020_105_3","PSA","105","3","3","Tura ni naari pachisrum: Yus pengkeraitai titaram. Tura ii Yusri seakrumka tuke nintimjai warartustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS105_4","020_105_4","PSA","105","4","4","Tuke kintajai metek ii Apuri seataram. Tura ni kakarmarisha wakerin ataram. ");
INSERT INTO acuNT_vpl VALUES ("PS105_5","020_105_5","PSA","105","5","6","Atumka Yuse inatiri Abrahama weari ainiarme. Tura Jacobo uchiri ainaun Yus wina umirtuktaram timiau asaram, ni weari ainiarme. Tura asaram Yus timiá kakaram asa, wainchati takatan untsurin turamia nu nintimrau ataram. ");
INSERT INTO acuNT_vpl VALUES ("PS105_7","020_105_7","PSA","105","7","7","Ii Yusringkia iinu Apurintai. Ningki mash nungkanmaya ainaunka inawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS105_8","020_105_8","PSA","105","8","9","Warang musaach nangkamaru wainiat Yuska Abrahaman wi turatatjai tímia nunaka pengké kajinmakchatnuitai. Nuniasha ni uchiri Isaacan: “Wi Yus asan tajame” tímia nunasha pengké kajinmakchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS105_10","020_105_10","PSA","105","10","11","Yus Jacobon chicharak: “Wikia nungka Canaán tutai amincha tura ami wearmincha susartatjai”, tímia nunaka tuke sakarchatin asamtai, Israela weari ainauncha tuke atumnau ati tusa akatar akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_12","020_105_12","PSA","105","12","12","Israela weari jumchik armiayi. Tura asar iraawa nunisarang Canaán nungkanam wekaasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_13","020_105_13","PSA","105","13","13","Tura chikich chikich nungkanam wekaa wekaakar, nuni jear jumchik arusar ataksha chikich nungkanam jearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_14","020_105_14","PSA","105","14","14","Tuminau wainiat Yus niin pasé awajsarai tusa surimkamiayi. Tura apu ainauncha chicharak: ");
INSERT INTO acuNT_vpl VALUES ("PS105_15","020_105_15","PSA","105","15","15","“Wina umirtin ainauka paseeka awajkairap. Tura wina chichamrun etserin ainauka wait wajaktinka susairap”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_16","020_105_16","PSA","105","16","16","Tura nu nungkanam tsuka ati tusa, árak ainau mash nerekcharti tusa suritkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_17","020_105_17","PSA","105","17","17","Turayat Josén chikich nungkanam surukarti tusa tsangkamkamiayi. Tura asa Josén nuná eemak Ejiptonam akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_18","020_105_18","PSA","105","18","18","Antsu Josénka kársernum engkeenak jirujai nawen chanuntawar kuntujen jirujai jingkiawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_19","020_105_19","PSA","105","19","19","Yus Josénka karanam tímia nuna umiatsaing, ¿wina chichamrun nekasash tiya? tusa nekapsatas nakasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_20","020_105_20","PSA","105","20","20","Nunia Ejipto apuri aintsun untsurin inarmia nu Joséncha angkanmamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_21","020_105_21","PSA","105","21","21","Tura José wina jear tura winar ainia nunaka mash wainkati tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_22","020_105_22","PSA","105","22","22","Tura ni nungkari apuri ainaun nuiniarti, tura yakta juuntri ainauncha ni nekamtarin nekamtikiawarti tusa inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_23","020_105_23","PSA","105","23","23","Nunia Jacob, chikich naari Israel, Ejipto nungkanam jeamiayi. Tura chikich nungkanmaya ayat nuni pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_24","020_105_24","PSA","105","24","24","Nuni pujamtai Yus niin nukap yujramiayi. Tura Ejipto ainau nangkamasarang kakaram wajasarti tusa kakamtikrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_25","020_105_25","PSA","105","25","25","Antsu Ejipto ainau Israel ainaun nakitrarti tusa, Yus nintimtikramiayi. Tura Yuse aintsri ainaun anangkawarti tusa tsangkamkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_26","020_105_26","PSA","105","26","26","Nunia Moisésan tura ni yachí Aarónnasha untsuk Ejiptonam akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_27","020_105_27","PSA","105","27","27","Tura Yus akupkamu asar, Moisés Aarónjai numi atsamunam wainchati takatan untsuri turuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_28","020_105_28","PSA","105","28","28","Yus Ejiptonam tsawai wainiat teen akupkamiayi. Tura waininayat Ejipto ainau Yuse chichamenka pachischarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_29","020_105_29","PSA","105","29","29","Tura ni entsarincha numpa najatamiayi. Turamtai namaksha mash kajingkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_30","020_105_30","PSA","105","30","30","Turasha parungkach ainau ni nungkarin tinamturti tusa, tura apu peakrincha tinamrarti tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_31","020_105_31","PSA","105","31","31","Tura Yus chichaamtai, anchii tetejai pachinir mukuntiua nunisarang Ejipto nungkanam jearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_32","020_105_32","PSA","105","32","32","Nunia yumincha jitumtiktsuk micha kaya tumaun jijai pachimramun yakiiya kakeerarti tusa nungkanam akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_33","020_105_33","PSA","105","33","33","Yus turamtai Ejipto nungkanam uva naekri ainauncha mash tsurintrarmiayi. Turamtai yurang higo tutaisha kakeekarmiayi. Tura numi ainau kanawesha mash kupintrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_34","020_105_34","PSA","105","34","34","Tura Yus ataksha chichaamtai, manchi ainau kaunkarmiayi. Timiá untsuri asaramtai nekapmartatkamawar tujinkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_35","020_105_35","PSA","105","35","35","Tura asar ajanam arak arakmauncha mash amukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_36","020_105_36","PSA","105","36","36","Nunia Yuse awemamuri kichik kichik jeanam waya Ejipto ainau uchiri eemkaurin maamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_37","020_105_37","PSA","105","37","37","Nunia Yus ni aintsri ainaun Ejiptonmaya jiikmiayi. Turamtai kurin takusar, tura kuikiancha takusar, timiá arák wekainayat juwicharmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_38","020_105_38","PSA","105","38","38","Ni jiinkiaramtai Ejipto ainau sapijin wait wajainau asar warasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_39","020_105_39","PSA","105","39","39","Nunia Yus mukuntiun ni aintsri ainaun uukat tusa akupkamiayi. Tura kashi paan wekaasatniurinka ji kapaun akuptukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_40","020_105_40","PSA","105","40","40","Tura tsukaminak: Iikia yuta yuumaji tinamtaisha, nanamtin ainaun waachia tumaun akuptukmiayi. Tura nayaimpinmaya maná pangka tumaun akuptukam yuwaar tutuararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_41","020_105_41","PSA","105","41","42","Nunia Moisés pampan awatiamtai, pampanmaya yumi tsapuimiayi. Tura entsa nunisang wej wajamiayi. Yus yaanchuik ni inatiri Abrahaman chicharak: “Ami wearam ainaun angkanmamtikiatnuitjai”, tímia nunisang ");
INSERT INTO acuNT_vpl VALUES ("PS105_43","020_105_43","PSA","105","43","43","ni aintsri ainaun Ejipto nungkanmaya jiikmiayi. Yus turamtai mash warainak untsumkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS105_44","020_105_44","PSA","105","44","45","Nunia Yus wina nuikiarturmaurun umirkarti tusa, ni aintsri ainaun chikich aints pujuarmia nuna nungkarin susarmiayi. Tura ninu yaktari ainia nunasha mash susarmiayi. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS111_1","020_111_1","PSA","111","1","1","¡Ii Apuri warartusmi! Anangkartichu ainau iruntramunam tura mash aints ainau kawengmaunum Apurun tuke nintirjai maaketai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS111_2","020_111_2","PSA","111","2","2","Ii Apuringkia timiá juun aa nuna takatringkia untsurintai. Tura asamtai nuna nekaawartas wakerinauka nuna pachisar nuiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS111_3","020_111_3","PSA","111","3","3","Yuse turamuringkia ni kakarmarijai turamia nuka nekas shiiram ainawai. Tura asaramtai Yus aints ainaun ni pengker turamurijai metek pengker awajsatnuitai. Tura pasé aints ainauncha ni pasé turamurijai metek wait wajaktiniun susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS111_4","020_111_4","PSA","111","4","4","Yus wainchati takatrinka pengké kajinmakchatniun najanamiayi. Ii Apuringkia aints ainautinka jaimias wait anentramji. ");
INSERT INTO acuNT_vpl VALUES ("PS111_5","020_111_5","PSA","111","5","5","Tura niin ameketme juuntam tinu ainaunka yutancha susatnuitai. Tura Yus wi turatatjai tímia nunaka pengké kajinmakchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS111_6","020_111_6","PSA","111","6","6","Tura ni aintsri ainautinka ni kakarmarin inakturmasmiaji. Tura asa niin umirkacharu ainau nungkarin ni aintsri ainautin suramsamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS111_7","020_111_7","PSA","111","7","8","Ni tura nuka nekas pengkeraitai. Ni chicham akupkamuringkia pengké yapajiachmin ainawai. Tura nekasar pengker ainawai. Tura asamtai ni chicham akupamuringkia tuke nintimrarminuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS111_9","020_111_9","PSA","111","9","9","Ii Yusri ni aintsri ainautinka angkan awajtamsamiaji. Tura Yus wi turatatjai tímia nunaka tuke umiktinuitai. Ii Yusringkia pengké tunaarinchawaitai. Tura timiá kakarmaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS111_10","020_111_10","PSA","111","10","10","Tura asamtai nekasar nintip ainauka iinu Apurinka: Ameketme juuntam tinu ainawai. Aints tu nintimsar pujuinauka pengker nintimsar pujuinawai. ¡Ii Yusringkia tuke warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS112_1","020_112_1","PSA","112","1","1","¡Ii Apuri warartusmi! Yusen pengkeraitme tinauka tura ni chicham akupamuri umirinak pujuinauka warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_2","020_112_2","PSA","112","2","2","Anangmichu ainau uchirinka chikich aints ainausha pengker awajsartin ainawai. Tura anangmichu ainau chichamenka pengker anturkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_3","020_112_3","PSA","112","3","3","Ni jeen warinchu untsuri iruninawai. Tura tuke wait anengkratin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_4","020_112_4","PSA","112","4","4","Tura nu aints ainau anangmichu asar, chikich anangmichu ainaun pengker awajinamuri ji teeti tsantua nunisketai. Nu aints ainau wait anengkratin tura jaimiasar nintimin tura anangmichu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_5","020_112_5","PSA","112","5","5","Pengke aints ainauka ikiatsata tinamsha suriminatsui. Tura chikich aints ainauncha anangtan nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_6","020_112_6","PSA","112","6","6","Tura asar mengkaakachartin ainawai. Tura asamtai chikich ainausha anangmichu ainaunka tuke pachiu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_7","020_112_7","PSA","112","7","7","Anangmichu ainauka shamarumtinun antukarsha shamchau ainawai. Tura ni Apurin nintiminau asar, ni nintisha kurarchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_8","020_112_8","PSA","112","8","8","Ni nintisha kurarchartin asaramtai shaminatsui. Tura asar ni nemase ainauncha pachinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS112_9","020_112_9","PSA","112","9","9","Tura aints yuuminak pujuinaun su asar, tuke wait anengkratin ainawai. Turin asar chikich aintsjai ingkiunikiar natsaamtsuk pangkainiar jiininawai. ");
INSERT INTO acuNT_vpl VALUES ("PS112_10","020_112_10","PSA","112","10","10","Antsu pasé aints ainauka nuna suwirpiaku jiinak kajerinawai. Turayat nu anangmichu ainaun pasé awajsatatkamawar tujinkartin ainawai. Antsu ni pasé turamuringkia mengkaakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS113_1","020_113_1","PSA","113","1","1","¡Ii Apuri warartusmi! Ii Apuri inatiri ainautiram, ni naari pachisrum: Yus juuntaitai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS113_2","020_113_2","PSA","113","2","2","Yamai nangkamsaram tuke ii Apuri naari pachisrum: Yus pengkeraitai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS113_3","020_113_3","PSA","113","3","3","Tsaa taakmanumaninisha tura tsaa jeamunmaninisha ii Apuri naari pachisrum: Yus kakarmaitai titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS113_4","020_113_4","PSA","113","4","4","Ii Apuringkia mash nungkanmaya ainaun inawaitai. Tura asa ni kakarmaringkia nayaimpincha nangkawai. ");
INSERT INTO acuNT_vpl VALUES ("PS113_5","020_113_5","PSA","113","5","5","Ii Yusringkia yakiiyang mash aints ainaun inawai. Tura asamtai ii Apurijai metek kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS113_6","020_113_6","PSA","113","6","6","Turayat tsuntsuma nayaimpincha tura nungkancha mash wainui. ");
INSERT INTO acuNT_vpl VALUES ("PS113_7","020_113_7","PSA","113","7","8","Ii Apuringkia yuuminak pujuinaunka wait anentawai. Turasha ni yakta apuri ainaujai turasha kuikiartin ainaujai iruntrar pujusarti tusa, Yus niin pengker awajsartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS113_9","020_113_9","PSA","113","9","9","Nuwa kaa ainausha uchin jurerarti tusa, tura ni uchiri ainaujai pujusarti tusa Yus waramtiksartinuitai. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS115_1","020_115_1","PSA","115","1","1","Apuru timiá wait anengkratin asam, tura nekas chicham nekamtikin asam, aints ainauka iinka: Pengkeraitme turamtsuk antsu aminak: Pengkeraitme turamiarti. ");
INSERT INTO acuNT_vpl VALUES ("PS115_2","020_115_2","PSA","115","2","2","¿Warukaya aints ainau amin umirtamtsuk pujusarsha iincha: Atumi Yusri tuwaita turaminaji? ");
INSERT INTO acuNT_vpl VALUES ("PS115_3","020_115_3","PSA","115","3","3","Ii Yusringkia nayaimpinam pujawai. Tura ni wakera nunaka mash umiawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_4","020_115_4","PSA","115","4","4","Antsu Yusen umirkacharu ainau yusringkia kuritai nuniasha kuikaitai. Ni yusri ainauka aints najanamu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_5","020_115_5","PSA","115","5","5","Ni yusri nakumkamuri jangkentin ainayat chichachu ainawai. Tura jiintin ainayat wainmichu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_6","020_115_6","PSA","115","6","6","Tura kuwishtin ainayat antutnasha antichu ainawai. Tura nujintin ainayat mayatchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_7","020_115_7","PSA","115","7","7","Tura uwejentin ainayat achimchau ainawai. Tura nawentin ainayat wekaichau ainawai. Tura chichatsuk aya takamtaik puju ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_8","020_115_8","PSA","115","8","8","Tura asaramtai aints ni yusrin najaninauka tura: Ameka wina yusruitme tinu ainauka ni yusrijai metek ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_9","020_115_9","PSA","115","9","9","Israel ainautiram, Yusek nekasampita titaram. Ningki iin yainmaktinuitji, tura ejarmaktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS115_10","020_115_10","PSA","115","10","10","Sacerdote ainautiram, Yusek nekasampita titaram. Ningki atumin yainmaktinuitai, tura ejarmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_11","020_115_11","PSA","115","11","11","Mash aints ainautiram, ii Apuri: Ameketme Yusem tinu asaram, nekasampita titaram. Ningki iin yainmaktinuitji, tura ejarmaktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS115_12","020_115_12","PSA","115","12","12","Ii Apuri ni aintsri ainautin kajinmatramtsuk nekas pengker awajtamsatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS115_13","020_115_13","PSA","115","13","13","Tura juun ainau tura uchi ainausha niin: Ameketme Yusem tinaunka nekas pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_14","020_115_14","PSA","115","14","14","Ii Apuringkia atumin nukap yujtamratnuitai, tura atumi uchirincha nunisang nukap yujratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_15","020_115_15","PSA","115","15","15","Ii Apuri nayaimpin tura nungkancha najanamia nuka atumin pengker awajtamsati. ");
INSERT INTO acuNT_vpl VALUES ("PS115_16","020_115_16","PSA","115","16","16","Nayaimpikia iinu Apurinuitai. Antsu nungkanka aints ainautin suramsamiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS115_17","020_115_17","PSA","115","17","17","Yaanchuik jakaru ainauka chichakchamin asar, iinu Apurinka maaketai tichartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS115_18","020_115_18","PSA","115","18","18","Antsu iikia iinu Apuringka yamaikia tuke maaketai titatji. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS116_1","020_116_1","PSA","116","1","1","Wina Apurka wi seamurun anturtuku asamtai, wikia Apurun aneajai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_2","020_116_2","PSA","116","2","2","Wi seamurun anturtuku asamtai, iwiaaku pujaknaka tuke niin seatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_3","020_116_3","PSA","116","3","3","Jata wina achirkamtai, jakatatjapi tusan shamkamjai. Tura timiá shamakun tura timiá najaimiakun achikmawa nunisnak nekapmamramjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_4","020_116_4","PSA","116","4","4","Tu nintimsan pujakun Apuru naarin pachisan uwemtikrurti tusan seamjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_5","020_116_5","PSA","116","5","5","Ii Apuringkia mash aints ainaun: Metek ainawai tu nintimui. Tura asa ii Yusringkia iincha tuke wait anentramak pengker awajtamji. ");
INSERT INTO acuNT_vpl VALUES ("PS116_6","020_116_6","PSA","116","6","6","Ii Apuringkia mianchau ainauncha wainui. Tura asa wikia pengké kakarchamin nekapeai wainiat winaka uwemtikrurmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS116_7","020_116_7","PSA","116","7","7","Apurka wina pengker awajtusu asamtai, yamaikia pengker nintimtusan pujusminuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_8","020_116_8","PSA","116","8","8","Yus jakatniunmaya wina uwemtikruru asamtai, tura juutmauruncha jurutrukin asamtai, yamaikia jakashtatjapi tusan, pengker nintimsan pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_9","020_116_9","PSA","116","9","9","Yamaikia iwiaaku pujaknaka: Apurun umirkatatjapi titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_10","020_116_10","PSA","116","10","10","Wikia timiá wait wajayatnak Apurun nekasampita timiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_11","020_116_11","PSA","116","11","11","Waurkamin nekapeakun: Mash aints ainau wait chichamrintin ainawai tu nintimmiajai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_12","020_116_12","PSA","116","12","12","¿Apur wina timiá pengker awajtusuncha warinak susaintaj? ");
INSERT INTO acuNT_vpl VALUES ("PS116_13","020_116_13","PSA","116","13","13","Mash aints antinamunam: Apurka uwemtikrurmayi titatjai. Tura ni naarin pachisan: Ameketme Yusem titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_14","020_116_14","PSA","116","14","14","Wina Apurun: Nuna turatatjai timiaja nunaka mash aints antinamunam umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_15","020_116_15","PSA","116","15","15","Ni aneetiri ainau jakatniurinka ii Apuri nukap nintimtawai. ");
INSERT INTO acuNT_vpl VALUES ("PS116_16","020_116_16","PSA","116","16","16","Apuru wikia aminu inatirmetjai. Wikia aminu nawantrumi uchirinjai. Wikia jingkiamua nunisnak pujaing winaka atitamiame. ");
INSERT INTO acuNT_vpl VALUES ("PS116_17","020_116_17","PSA","116","17","17","Apuru amin maaketai titasan tangkurun maan epeatatjai. Tura ami naarmin pachisan seatatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS116_18","020_116_18","PSA","116","18","19","Apuru Jerusalén yakta japen ami jeemin wayaan, wi amincha nunaka turatatjai timiaja nunaka mash aints antinamunam umiktatjai. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS117_1","020_117_1","PSA","117","1","2","Ii Apuringkia iincha timiá anenmau asamtai, mash nungkanmaya aints ainautiram, ii Apuringkia: Ameketme juuntam titaram. Ningkia pengké yapaijmiamachminuitai. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS119_1","020_119_1","PSA","119","1","1","Aints tunaarinchau ainauka ii Apuri nuikiartamurin nintimtinau asar, nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_2","020_119_2","PSA","119","2","2","Tura Yus chichaman akupamun páchina nuka tura tuke nintijai niin nintimtina nuka nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_3","020_119_3","PSA","119","3","3","Tura pasé aa nuna takatsuk pujusar, ii Apuri jintin amainauka nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_4","020_119_4","PSA","119","4","4","Apuru ame chichaakum: Wina chichamur tuke umirtuktaram timiame. ");
INSERT INTO acuNT_vpl VALUES ("PS119_5","020_119_5","PSA","119","5","5","Tura asakmin wiki nintimsanka: Tuke inaitsuk ame chicham akupamurmin umirkatasan wakerajai tajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_6","020_119_6","PSA","119","6","6","Wikia ami chichammin mash umirkanka pengké natsaarchatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_7","020_119_7","PSA","119","7","7","Tura ame chicham akupkamiame nuka timiá pengker ainia nuna nuimiarnaka, amincha tuke nintirjai maaketai titatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS119_8","020_119_8","PSA","119","8","8","Ame chicham akupkamiame nuna umiktasan wakerajai. Tura asamtai ajapruamka pengké ukurkiip. ");
INSERT INTO acuNT_vpl VALUES ("PS119_9","020_119_9","PSA","119","9","9","¿Natsa ainausha itiur tunaarinchausha pujusarminuita? Ami chichammin umirinak nekasar tunaarinchau pujusarminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_10","020_119_10","PSA","119","10","10","Wikia aminka tuke nintirjai nintimtajme. Ameka wi chicham akupamurun umitsuk pujusti tusamka tsangkamrukaip. ");
INSERT INTO acuNT_vpl VALUES ("PS119_11","020_119_11","PSA","119","11","11","Wikia amin umirtsuk pujusai tusan, ami chichammin nintirun tuke ukuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_12","020_119_12","PSA","119","12","12","¡Apuru aminka pengkeraitme tajame. Tura asamtai ame chicham akupamuram nuiturta! ");
INSERT INTO acuNT_vpl VALUES ("PS119_13","020_119_13","PSA","119","13","13","Ame chicham akupame nunaka aints ainaun mash ujakartatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_14","020_119_14","PSA","119","14","14","Ame chicham akupamurmin umirkunka, chikich aints ainau ni kuikiarin nintimsar waraina nuna nangkamasnak wikia warastinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_15","020_119_15","PSA","119","15","15","Ame chicham akupamurmin nintimsan pujakun, ami wakeramurmin nintimsan pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_16","020_119_16","PSA","119","16","16","Tura ame umirkatin chichamnasha nintimsan warastinuitjai. Tura ami chichamminka kajinmarchatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_17","020_119_17","PSA","119","17","17","Apuru wikia aminu inatiram asamtai ¡tuke pujut surusta! Turakminka ami chichammin umiktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_18","020_119_18","PSA","119","18","18","Ami unuikiartutiram timiá pengker aa nuna nintimratasan wakerau asamtai, ame jiiru uratrita. ");
INSERT INTO acuNT_vpl VALUES ("PS119_19","020_119_19","PSA","119","19","19","Wikia ju nungkanmaka irawa nunisnak pujau asamtai, amin umirkatin chichamka uutrukaip. ");
INSERT INTO acuNT_vpl VALUES ("PS119_20","020_119_20","PSA","119","20","20","Wikia ame chicham akupamurmin nekaatasan timiá wakerau asan, nekachkun kintajai metek napchau nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_21","020_119_21","PSA","119","21","21","Aints miajuitjai tumamin ainauka ami chichammin umirtan nakitinau asar yumingkramu ainawai. Tura asaramtai nu aints ainauka ni tunaari inaisarti tusam chicharkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS119_22","020_119_22","PSA","119","22","22","Wikia ami chichammin umirkau asamtai, wina jiyatkar pasé awajtusartin ainauka winiangka kiishmakta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_23","020_119_23","PSA","119","23","23","Aints timiá kakaram ainauka wina pasé awajtusartas wakerutinau wainiatun, wikia aminu inatiram asan, ami chichammin nintimratatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_24","020_119_24","PSA","119","24","24","Tura ame chicham akupkamu ainaun nintimran wikia waraajai. Ame chicham akupamuram wina chichartuktin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_25","020_119_25","PSA","119","25","25","Yusru wikia jakamin nekapeajai. Tura asamtai ame timiame nunismek yamaram pujut surusta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_26","020_119_26","PSA","119","26","26","Wikia itiur pujaja tusan amin ujakmajme. Wi turamtai ameka airkamame. ¡Wait aneasam ami wakeramuram nuiturta! ");
INSERT INTO acuNT_vpl VALUES ("PS119_27","020_119_27","PSA","119","27","27","Ami wainchati takatirmin nintimratasan wakerajai. Tura asamtai wina umirtuktin chichaman umirtukat tusam nekamtairam surusta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_28","020_119_28","PSA","119","28","28","Wikia timiá wake mesekan pujau asan juutkamaikiakun pujajai. Tura asamtai ame turutmiame nutiksamek kakamtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_29","020_119_29","PSA","119","29","29","Tura wait chichamtinu jintin amakai tusam surimrukta. Antsu wait aneasam nuiturta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_30","020_119_30","PSA","119","30","30","Nekas chichamtinu jintin wekaasatasan wakerajai. Turasha ami umirkatin chichammin umiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_31","020_119_31","PSA","119","31","31","Apuru wikia ame chicham akupamurminka inaiyatsjai. Tura asamtai winaka inatsatraip. ");
INSERT INTO acuNT_vpl VALUES ("PS119_32","020_119_32","PSA","119","32","32","Wina nintir waramtikrusu asakmin, ami umirkatin chichammin miatrusnak umiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_33","020_119_33","PSA","119","33","33","Apuru ami chichamem nuiturta. Ame turakminkia iwiaaku pujaknaka tuke umiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_34","020_119_34","PSA","119","34","34","Ami nuikiartutirmin umiktasan wakerau asamtai, nekamtairam surusta. Tura asakmin tuke mash wina nintirjai umiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_35","020_119_35","PSA","119","35","35","Ame chicham akupamur umikiam, wina jintiar amakta tusam nintimtikrurta. Ame turakminkia, wikia pengker nintimsan pujustatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_36","020_119_36","PSA","119","36","36","Apuru ame wina chichamrun wakerukat tusam nintimtikrurta. Antsu kuikianka wakerutsuk asati tusam nusha nintimtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_37","020_119_37","PSA","119","37","37","Tura chikich aints ainau wakerina nuna nintimrai tusam surimrukta. Antsu wina jintiar amakta tusam pujut surusta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_38","020_119_38","PSA","119","38","38","Wikia ami inatirmetjai. Tura asamtai amin umirtaminak pujuinaun: Wi turatnuitjai timiame nuka winasha turuttia. ");
INSERT INTO acuNT_vpl VALUES ("PS119_39","020_119_39","PSA","119","39","39","Wikia ami chichammin umiktasan timiá wakerau asamtai, inatsararai tusam ame pasé aa nuka kiishmakta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_40","020_119_40","PSA","119","40","40","Wikia ami chichammin wakerau asamtai, ame pengker asam yamaram pujut surusta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_41","020_119_41","PSA","119","41","41","Apuru ame timiame nunismek ami anengkratairam inaktursata, turam uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS119_42","020_119_42","PSA","119","42","42","Aints wina inatsatratas wishikrinamtaisha, wikia ami chichammin nekasampita tau asan kajertsuk aiktinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_43","020_119_43","PSA","119","43","43","Wina chichamur umirtukta tame nuna nintimsan pujau asamtai, nekas chicham aa nuka jurutrukiip. ");
INSERT INTO acuNT_vpl VALUES ("PS119_44","020_119_44","PSA","119","44","44","Wikia ami chichammin tuke inaitsuk umiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_45","020_119_45","PSA","119","45","45","Tura ami chichammin umirkau asan, angkan pujustinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_46","020_119_46","PSA","119","46","47","Wikia ame chicham akupamurmin aneau asan, nuna nintimsan waraajai. Tura asan ami chichammin apu ainauncha ujaaknasha natsaarchatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_48","020_119_48","PSA","119","48","48","Wikia amin umirkatin chichaman timiá wakerau asan, pengker nintimsan umiajai. Tura ami chichammin nukap nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_49","020_119_49","PSA","119","49","49","Apuru wikia ami inatirmetjai. Yaanchuik turutmiame nuka ame nintimrata. Nu chichamka winaka nintimtikrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS119_50","020_119_50","PSA","119","50","50","Wi wake mesekan pujamtai: Amin tuke pujutan susatnuitjame tusam turutmiame nu chichamjai kakamtikrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS119_51","020_119_51","PSA","119","51","51","Aints miajuitjai tumamin ainauka winaka tuke inangnatsuk wishikrinawai. Tura wainiatun ame nuiturmiame nunaka wikia tuke kajinmatsjai. ");
INSERT INTO acuNT_vpl VALUES ("PS119_52","020_119_52","PSA","119","52","52","Apuru ame yaanchuik chicham akupkamiame nunaka kajinmatsjai. Tura nuna nintimran pengker nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_1","020_121_1","PSA","121","1","1","Wiki nintimsanak muran jiisan: ¿Tuniang wina yainkatnusha winitnuinta? tu nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_2","020_121_2","PSA","121","2","2","Turayatun wina yainkatnuka muranmakeka pujatsui. Antsu wina yainkatnuka nayaimpin tura nungkancha najanamia nuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_3","020_121_3","PSA","121","3","3","Nuka tunaanum pujusta, tusangka tsangkamramkashtinuitai. Amin waitma nuka pengké kanurchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_4","020_121_4","PSA","121","4","4","Nekas amin waitma nuka Israel ainaun wainin asa, pengké kanichuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_5","020_121_5","PSA","121","5","5","Yusketai amin waitminka. Tura amin ejarmaktincha nuketai. Tura amin yainmaktincha amijai tsanias puja nuketai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_6","020_121_6","PSA","121","6","6","Tsaangka tsawaingkia aminka ititka awajtamsashtinuitai. Tura nantusha nunisang kashisha turutmashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_7","020_121_7","PSA","121","7","7","Shamrumtin amaunumiasha Apuram ejarmaktinuitai. Tura ami pujutrumnasha pasemarai tusa waitramkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS121_8","020_121_8","PSA","121","8","8","Ame tuni wekaame nunisha ami Apuram yamaisha ejarma nu tuke ejarmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS126_1","020_126_1","PSA","126","1","1","Achikmau ainautin Yus: Ataksha Jerusalénnum waketkitaram tusa, angkanmamtikiamu asar iisha karanma nunisrik pujusmiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS126_2","020_126_2","PSA","126","2","2","Tura asar wararkur wishirmiaji. Tura wararkur kantamamiaji. Turakrin Yusen umirchau ainau nuna wainkar chichainak: “Ni Yusri niin nekas pengker awajsayi”, tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS126_3","020_126_3","PSA","126","3","3","Nu tina nunaka nekasar tiarmiayi. Ii Apuringkia nekas iin pengker awajtamsamiaji. Tura asamtai iisha warasmiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS126_4","020_126_4","PSA","126","4","4","Apuru yumi atsamunam ataksha yumi jitamtai, entsa wej wajainawa nunismek iincha ataksha pengker awajkartusta. ");
INSERT INTO acuNT_vpl VALUES ("PS126_5","020_126_5","PSA","126","5","5","Aints ni arakri jumchik asamtai, juutkamaikiak araamramia nunaka ukunam nerekamtai waras juuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS126_6","020_126_6","PSA","126","6","6","Ni arakrin araamratas jumchik asamtai juutkamaikiak ni jeenian jiinkiat, nuniangka nukap juuku asa, waras kantan kantamki ni jeen waketkitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS127_1","020_127_1","PSA","127","1","1","Ii Apuri yaimkechujai ii jee jeamkurkia, jea jeamin ainautisha nangkamir takakmastinuitji. Tura ii Yusri ii yaktarin waintsuk pujamtaikia, yakta wainin ainausha nangkamiar ii yaktarincha wainkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS127_2","020_127_2","PSA","127","2","2","Atumsha atumi yutairi wainkatasrum kashik nantakrum, waitnasrum takaa takakmakrum tsaa jeamtai inangnakrumsha nangkamrum takakmastinuitrume. Antsu Yus ni aneetiri ainautinka kanurarti tusa karan suramji. ");
INSERT INTO acuNT_vpl VALUES ("PS127_3","020_127_3","PSA","127","3","5","Aints uchin untsuri yajutmaruka aints kuntinun tukutas tsentsakan untsuri takus wekaawa nunisketai. Tura asamtai aints uchin untsuri yajutmarunka Yuska nekas pengker awajui. Tura asamtai nu aintska pengker nintimias warastinuitai. Tura ni uchiri ayamrukartinka untsuri asaramtai, ni nemase ainau nu aintsun pachisar pasé chichainayat inatsarchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS130_1","020_130_1","PSA","130","1","1","Apuru timiá napchau nintimsan pujau asan amin seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS130_2","020_130_2","PSA","130","2","2","Apuru wina chichamur anturtukta. Tura wait anentrurta tusan seamka tenap anturtukam airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS130_3","020_130_3","PSA","130","3","3","Apuru ¿tunaur tsangkutrachkumnisha yáki uwemtikrurat? ");
INSERT INTO acuNT_vpl VALUES ("PS130_4","020_130_4","PSA","130","4","4","Antsu wina ameketme Yusem turutiarti tusam, ii tunaaringkia tsangkukratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS130_5","020_130_5","PSA","130","5","5","Wikia tuke wina nintirjai Apurun nintimtajai. Tura ni chichamencha tuke nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS130_6","020_130_6","PSA","130","6","6","Yakta wainin kashi iwiainak: ¿Warutik tsawaarat? tusar nakainawa nunisnak wikia Apurun: ¿Warutik tat? tusan nakajai. ");
INSERT INTO acuNT_vpl VALUES ("PS130_7","020_130_7","PSA","130","7","7","Ii Apuri timiá wait anengkratin asa, iinka tuke angkanmamtikramatnuitji. Tura asamtai Israela weari ainautiram, atumi Apuri nintimrataram. ");
INSERT INTO acuNT_vpl VALUES ("PS130_8","020_130_8","PSA","130","8","8","Ningki atumi tunaarinka mash tsangkutramratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS131_1","020_131_1","PSA","131","1","1","Apuru wikia miajuitjai tumamtanka nakitajai. Tura nuwancha jiijamniauka jiiatsjai. Turasha wikia mash nekawitjai tatsujai. ");
INSERT INTO acuNT_vpl VALUES ("PS131_2","020_131_2","PSA","131","2","2","Antsu uchi muntsun tsurak muntsunka nintimtsuk pujawa nunisnak wikia tunaunaka nintimtsuk antsu aminak nintimsan pujajai. ");
INSERT INTO acuNT_vpl VALUES ("PS131_3","020_131_3","PSA","131","3","3","Israela weari ainautiram, atumi Apuri yamaisha tuke nintimrataram. ");
INSERT INTO acuNT_vpl VALUES ("PS134_1","020_134_1","PSA","134","1","1","Ii Apuri inatiri ainautiram, kashi kanutsuk iruntai jeanam Yus seatasrum kaunkau asaram, ii Apuri ameketme pengkeram titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS134_2","020_134_2","PSA","134","2","2","Tura atumi uweje takuiram ii Apuri ameketme pengkeram titaram. ");
INSERT INTO acuNT_vpl VALUES ("PS134_3","020_134_3","PSA","134","3","3","Turakrumningkia ii Apuri nayaimpin tura nungkancha najanamia nuka ni pujamuriniang atumin pengker awajtamsarti. ");
INSERT INTO acuNT_vpl VALUES ("PS139_1","020_139_1","PSA","139","1","1","Yusru wina nintirka nekame. ");
INSERT INTO acuNT_vpl VALUES ("PS139_2","020_139_2","PSA","139","2","2","Wi itiur pujaja nusha waitme. Ame arák pujayatum, wi nintimaursha mash nekawitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_3","020_139_3","PSA","139","3","3","Wi wekaamtaisha tura ayamkun pujamtaisha, nunismek waitme. Wina jintarun wi wekaaja nusha mash waitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_4","020_139_4","PSA","139","4","4","Wina chichamrun tuke chichaaja nuka ameka mash anturtukuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_5","020_139_5","PSA","139","5","5","Ame wina eemkim tura ukurninisha pujurtame. Uwejmijaisha wina takarme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_6","020_139_6","PSA","139","6","6","Nunaka mash nekayatun nintimratatkaman yuumatajai. ");
INSERT INTO acuNT_vpl VALUES ("PS139_7","020_139_7","PSA","139","7","7","Aminu Wakanim tuke pujurtau asamtai, ¿wisha tuki wetaj? Ame mash nungkanmaya ainau nekau asakmin ¿wisha itiur tupikiakminuitja? ");
INSERT INTO acuNT_vpl VALUES ("PS139_8","020_139_8","PSA","139","8","8","Wikia nayaimpinam waakmatisha, ameka tuke nuni pujurtame. Tura nungka taimunam nitak pujamtaisha winaka tuke waitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_9","020_139_9","PSA","139","9","10","Wikia kashik nantakin, nasejai juun entsa amajin wekaamtaisha, ai wekaasata tusam uwejmijai tuke wina achirkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_11","020_139_11","PSA","139","11","12","Antsu wikia teenam anumkatasan wakerai wainiatmek, ameka tsawaisha tura kashisha tuke nunismek waitme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_13","020_139_13","PSA","139","13","14","Wina namangkur najanau asam, tura wina nukuru ampujesha najatau asakmin, amincha maaketai tajame. Aminu itiurkachmintrum atsau asamtai, wikia: Ame pengké tujinkachuitme tusan nekajme. ");
INSERT INTO acuNT_vpl VALUES ("PS139_15","020_139_15","PSA","139","15","16","Wina mash nekaru asakmin, wikia anumkachminuitjai. Chikich ainau winaka waitinatsaing ameka najatamiame. Wina nukuru ampujen pujai waitiatum, wina kintarka warutmak at tusam mash nekaamiame. Aminu papirumin wina kintarka warutmak at tusam mash aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PS139_17","020_139_17","PSA","139","17","18","Ami takatrum nekas pengker aina nuka untsuri ainawai. Tura asaramtai nuna nekapmartatkaman tujintajai. ");
INSERT INTO acuNT_vpl VALUES ("PS139_19","020_139_19","PSA","139","19","20","Yusru aints ainau amin nakitramina nuna pujutringkia jurukiarta. Nuka nangkamiar amin naarmin pachisar pasé chichainawai. Tura asaramtai mangkartin ainau wina takarsacharti tusam waitkata. ");
INSERT INTO acuNT_vpl VALUES ("PS139_21","020_139_21","PSA","139","21","21","Apuru amin nakitramin ainaunka wikia nakitajai. Tura amin umirtamtan nakitin ainaunka nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("PS139_22","020_139_22","PSA","139","22","22","Nu aints ainauka wina nemasrua nunisarang asaramtai, tuke wina nintirjai nu aints ainaunka tsuutajai. ");
INSERT INTO acuNT_vpl VALUES ("PS139_23","020_139_23","PSA","139","23","23","Yusru nintimaur nekame. Tura asam nintirka jiirtusta. Tura nintirun tunau atsuash tusam nekartuata. ");
INSERT INTO acuNT_vpl VALUES ("PS139_24","020_139_24","PSA","139","24","24","Tura tunau jintanam wekaamtaisha tuke nekamtikruata. Tura tuke pujut nangkankashtinnum pujusminam tusam jintintruata. ");
INSERT INTO acuNT_vpl VALUES ("PS142_1","020_142_1","PSA","142","1","1","Wikia Apurun kakaran untsuakun: Wait anentrurta tusan seajai. ");
INSERT INTO acuNT_vpl VALUES ("PS142_2","020_142_2","PSA","142","2","3","Napchau nintimsan pujaknaka, Apurun wake mesekmaurun nekamtikjai. Tura wait wajamurnasha ujaajai. Apuru wi pujamurka nekame. Wi wekaasatniunam ejatkan puusarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS142_4","020_142_4","PSA","142","4","4","Tura pajaasan jiimkuncha, wina yainkatnunka waintsujai. Tura wina ayamrutkatnusha atsawai. Tura wina nintimtursatcha kichkisha atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS142_5","020_142_5","PSA","142","5","5","Tura asamtai amincha Apuru untsuajme. Ametme wina ejarkatnumka. Nuniangka chikich wina ayamrutkatnuka aya atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PS142_6","020_142_6","PSA","142","6","6","Wina kakarmar atsau asamtai, wina untsumaur anturtukta. Tura wina nemasur ainau wina nangkamasang kakaram ainamunmaya angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS142_7","020_142_7","PSA","142","7","7","Amin waramtiksatasan wakerau asamtai, wikia achikmawa nunisnak pujaing nuniangka jiirkita. Ame winaka pengker awajtau asakmin, anangmichu ainauka winaka tentatkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS143_1","020_143_1","PSA","143","1","1","Apuru wi seamur anturtukta. Turasha wi inintramur anturtukta. Ame timiame nuka tuke umiktin asam, wi seamur airkata. ");
INSERT INTO acuNT_vpl VALUES ("PS143_2","020_143_2","PSA","143","2","2","Mash aints ainau tunaarintin ainawai tusam nekame. Antsu wikia aminu inatiram asamtai, winaka wait wajaktinka surusaip. ");
INSERT INTO acuNT_vpl VALUES ("PS143_3","020_143_3","PSA","143","3","3","Wina nemasur ainauka wina papeetkar nungkanam ujuarmawa nutikruwarmayi. Tura aints jakawa nunisang teenam pujusti tusar, wina pasé awajtusarmayi. ");
INSERT INTO acuNT_vpl VALUES ("PS143_4","020_143_4","PSA","143","4","4","Wikia timiá napchau nintimsan pujau asamtai, nintirsha kurawai. ");
INSERT INTO acuNT_vpl VALUES ("PS143_5","020_143_5","PSA","143","5","5","Wi yaanchuik pujuyaja nuna aneakjai. Tura ami turamurmin mash nintimjai. ");
INSERT INTO acuNT_vpl VALUES ("PS143_6","020_143_6","PSA","143","6","6","Wikia nungka mujurua tumawaitjai. Tura asan nungka mujuramtai, aints ainau yumi jiturti tusar, uwejen takuiniar amin seatmina nunisnak amincha seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS143_7","020_143_7","PSA","143","7","7","Apuru wina mayatair nangkantanak jasi. Tura asamtai wári airkata. Ame yaimkem suritrukaip. Nu turakminka wikia jakawa nunisnak pujustatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS143_8","020_143_8","PSA","143","8","8","Wikia amin nintimsan pujau asamtai, kashik shintaramtai, ami anengkratairmin tu awai tusam nekamtikruata. Tura ame nu jinta wekaasata tusam jintim nekamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS143_9","020_143_9","PSA","143","9","9","Apuru ameka wina ejarin asam, wina nemasur ainamunmaya angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS143_10","020_143_10","PSA","143","10","10","Tura wina Yusur asam, wina wakeramur najanata tusam nuiturta. Ami Wakanim nekas pengker aa nu: Ju jinta tupnik amakta tusa, wina jintintruati tusan seajme. ");
INSERT INTO acuNT_vpl VALUES ("PS143_11","020_143_11","PSA","143","11","11","Apuru pujut surusta tusan, amin naarmin pachisan seajme. Ame tuke pengker asam, wi wait wajamunmayangka jiirkita. ");
INSERT INTO acuNT_vpl VALUES ("PS143_12","020_143_12","PSA","143","12","12","Wikia ami inatiram asamtai, wait anentruram wina nemasur ainauka nepetkam mash mengkaakta. ");
INSERT INTO acuNT_vpl VALUES ("PS144_1","020_144_1","PSA","144","1","1","Wina ejarkatnuka wina Apuruitai. Tura asamtai ameketme pengkeram titatjai. Ningki mesetnum wetinnaka nuiturtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS144_2","020_144_2","PSA","144","2","2","Ningki wina amikur asa wina ejarkatnuitai. Tura pampanam wi anumkatnua tumau asa, winaka angkanmamtikruatnuitai. Tura tantaara tumau asa, wina ayamrutkatnuitai. Tura chikich nungkanmaya ainaun nepetkata tusa kakamtikrurtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS144_3","020_144_3","PSA","144","3","3","Apuru aintsti mianchau arincha ¿waruka timiá anengkratme? Aintsti jakatin arincha, ¿waruka timiatcha nintimkartusmesha pujame? ");
INSERT INTO acuNT_vpl VALUES ("PS144_4","020_144_4","PSA","144","4","4","Aintstikia aintsu mayatmauriya nunisrik wári mengkakatnuitji. Tura asar mikinta nunisrik nangkamaji. ");
INSERT INTO acuNT_vpl VALUES ("PS144_5","020_144_5","PSA","144","5","5","Apuru nayaimpinam mukunit shuwinnum pujuuwitiatum tarata. Tura mura ainausha keekarti tusam takasta. ");
INSERT INTO acuNT_vpl VALUES ("PS144_6","020_144_6","PSA","144","6","6","Tura chaarim nangkia tumau akupkata. Turasha nemasem ainau atu atu tupikiakiarti tusam awemata. ");
INSERT INTO acuNT_vpl VALUES ("PS144_7","020_144_7","PSA","144","7","7","Yakiiyang uwejem kutsmarta. Tura aints juun entsanam jakeawa nunisnak pujaing uwemtikrurta. Tura chikich nungkanmaya aints ainamunmaya angkanmamtikruata. ");
INSERT INTO acuNT_vpl VALUES ("PS144_8","020_144_8","PSA","144","8","8","Nu aints ainauka wait chichaman etserin ainawai. Tura ni uwejen takuiniar anangminak Yusjai tajai tinawai. Tuminau asaramtai nu aints ainamunmaya uwemtikrurta. ");
INSERT INTO acuNT_vpl VALUES ("PS144_9","020_144_9","PSA","144","9","9","Apuru yamaikia yamaram kantan kantamruatjame. Tura kitarran tuntuikiamaikiakun kantan kantamruatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS144_10","020_144_10","PSA","144","10","10","Ame apu ainau nepetkatniuka surusuitme. Tura asam winasha jakatniunmaya uwemtikrurmiame. ");
INSERT INTO acuNT_vpl VALUES ("PS144_11","020_144_11","PSA","144","11","11","Tura yamaisha nunismek winasha jakatniunmaya uwemtikrurta. Tura chikich nungkanmaya aints ainamunmaya angkanmamtikruata. Nu aints ainauka wait chichaman etserin asar, uwejen takuiniar anangminak: Yusjai tajai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS144_12","020_144_12","PSA","144","12","12","Ii uchiri ainauka árak arakmawa nunisarang tsakainawai. Tura ii nawantri ainausha Yuse jeen paini shaung wajainawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS144_13","020_144_13","PSA","144","13","13","Ii jeesha árak juukmaujai piakaru ainawai. Tura ii tangkurisha untsuri warang yujainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS144_14","020_144_14","PSA","144","14","14","Ii waakarisha japrukaru ainayat ni uchirisha shimkimuka ainatsui. Tura ii yaktarinka taetet wajamusha atsuyi. ");
INSERT INTO acuNT_vpl VALUES ("PS144_15","020_144_15","PSA","144","15","15","Tu pujakrikia nekasar warasartin ainiaji. Yus ii Apuri aa nu iijai pujamtaikia, nekasar warasartin ainiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS145_1","020_145_1","PSA","145","1","1","Yusru wina Apur asakmin, ami kakarmarmin pachisan chichastatjai. Tura ami naarmin pachisan: Ameketme juuntam titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_2","020_145_2","PSA","145","2","2","Aminka kintajai metek: Ameketme pengkeram titatjai. Tura tuke amin naarmin pachisan warartustatjame. ");
INSERT INTO acuNT_vpl VALUES ("PS145_3","020_145_3","PSA","145","3","3","Ii Apuri asam nekasam juuntaitme. Tura asakmin mash aints ainau: Ameketme juuntam turamiarti. Tura timiá juun asakmin, iikia warukuita tusar nintimratatkamar tujintaji. ");
INSERT INTO acuNT_vpl VALUES ("PS145_4","020_145_4","PSA","145","4","4","Aints ainau ni uchiri ainaun nuininak ami turamurmin pachisar: Nuka nekas pengker ainawai tiartinuitai. Nunia ami kakarmarmijai najanamiame nunasha pachisar ni uchiri ainaun ujakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_5","020_145_5","PSA","145","5","5","Tura asaramtai aints ainau mash ami paaniurmin tura ami kakarmarmincha pachisar chichasartin ainawai. Turinamtai wisha ami wainchati takatrumin pachisan chichastatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_6","020_145_6","PSA","145","6","6","Tura ami kakarmarmijai ami nemasem ainau nepetnuyame nuna pachisar chichasartin ainawai. Turinamtai wisha amin pachisan: Yus juuntaitai tusan aints ainaun ujaktatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_7","020_145_7","PSA","145","7","7","Wi ujaam, aints ainau amin pachitmasar: Yus timiá pengkeraitai tiartinuitai. Tura kantan kantaminak: Yuska pengké tunaachawaitai tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_8","020_145_8","PSA","145","8","8","Ii Yusringkia jaimias aints ainautin wait anentramji. Turasha wári kajechu asa iincha tuke anenmaji. ");
INSERT INTO acuNT_vpl VALUES ("PS145_9","020_145_9","PSA","145","9","9","Ii Apuringkia mash aints ainautin pengker awajtamsatas wakerutmaji. Tura ni najanamurinka mash jaimias wainui. ");
INSERT INTO acuNT_vpl VALUES ("PS145_10","020_145_10","PSA","145","10","10","Apuru ami najanamurmin pachisar aints ainau mash warasarti. Tura amin umirtaminak pujuinauka mash amin warartamsarti. ");
INSERT INTO acuNT_vpl VALUES ("PS145_11","020_145_11","PSA","145","11","12","Tura aints ainau mash ami kakarmarmin pachisar chichasarti, turasha ame aints ainau timiá pengker inamurmin pachisar warasarti. Tura amin pachitmasar: Mash nungkanmaya ainaun nekas pengker inawai turamiarti. Nunia ami paaniurmincha pachisar chichasarti. ");
INSERT INTO acuNT_vpl VALUES ("PS145_13","020_145_13","PSA","145","13","13","Aminu inamtairumka pengké nangkankashtinuitai. Tura asamtai ameka aints ainauka tuke inangnatsuk inartinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PS145_14","020_145_14","PSA","145","14","14","Ii Apuringkia jakaartas wakerinauncha kiakartinuitai. Tura mianchawaitjai tumamin ainauncha inankitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_15","020_145_15","PSA","145","15","15","Apuru mash iwiaaku ainauka yutairin yuuminak surusat tusar amin nakarminawai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_16","020_145_16","PSA","145","16","16","Tura uwejem yapaarakminka, mash iwiaaku ainau tutuarar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_17","020_145_17","PSA","145","17","17","Ii Apuringkia aints ainautinka tuke mash metek jiirmaji. Turasha ni tura nunaka iin wait anentramak tuke turawai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_18","020_145_18","PSA","145","18","18","Ii Apuringkia ni seau ainautinka anturtamji. Tura anangmichu ainau seamsha anturui. ");
INSERT INTO acuNT_vpl VALUES ("PS145_19","020_145_19","PSA","145","19","19","Tura ii Apurinka: Ameketme Apum tinu ainau wakeramurin umiktinuitai. Tura Apuru yainkata tinamtaikia, ni seamurinka anturkatnuitai tura uwemtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_20","020_145_20","PSA","145","20","20","Ii Apuringkia niin aneenaunka ejaktinuitai. Antsu pasé aints ainaunka mengkaaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS145_21","020_145_21","PSA","145","21","21","Wina jangkerjai wina Apurun tuke maaketai titatjai. Tura mash nungkanmaya ainau ii Apuri naarin nekas pengker aa nuna pachisar: Ameketme pengkeram tuke inangnatsuk tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_1","020_146_1","PSA","146","1","1","¡Ii Apuri warartusmi! Tuke wina nintirjai Apurun maaketai titatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_2","020_146_2","PSA","146","2","2","Tura iwiaaku pujaknaka tuke Apurun maaketai titatjai. Tura wina Yusrun kantan kantamruatatjai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_3","020_146_3","PSA","146","3","4","Atumka aints miajuitjai tumamin ainau timiá kakaram ainawai tiirap. Nu ainauka áya aintsuk ainawai. Tura jakaar nungka najanarar, nu kintatik ni takaamurinka mash inaisartin ainawai. Tura timiá kakaram ainau wina uwemtikrurartinuitai tuuka nintimsairap. ");
INSERT INTO acuNT_vpl VALUES ("PS146_5","020_146_5","PSA","146","5","5","Ii Yusri yayaamutirmeka warastaram. Jacobo Yusri atumi Apuri asamtai, niin nintimsaram pujuinautirmeka warastaram. ");
INSERT INTO acuNT_vpl VALUES ("PS146_6","020_146_6","PSA","146","6","6","Yuska nayaimpincha tura nungkancha tura juun entsancha tura numi mash iruna nunasha najanamiayi. Tura asa ni chichamencha tuke umiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_7","020_146_7","PSA","146","7","7","Tura wait wajakartin ainaunka Yuska pengker awajsatnuitai. Tura tsukaminak pujuinauncha ni yutairincha susatnuitai. Tura achikmau ainauncha angkanmamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_8","020_146_8","PSA","146","8","8","Ii Apuri wainmichu ainaun wainmamtikiatnuitai. Tura iyaaru ainauncha inankitnuitai. Tura anangmichu ainauncha aneetnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_9","020_146_9","PSA","146","9","9","Tura chikich nungkanmaya ainauncha wainkatnuitai. Tura mitaik ainauncha tura waje ainauncha ni yuumamurincha susatnuitai. Antsu pasé aints ainaunka mengkaaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS146_10","020_146_10","PSA","146","10","10","Yuse aintsri ainautirmin ii Apuri tuke inatmartinuitrume. Tura atumi Yusri tuke inangnatsuk mash nungkanmaya ainaun inartinuitai. ¡Ii Apuri warartusmi! ");
INSERT INTO acuNT_vpl VALUES ("PS147_1","020_147_1","PSA","147","1","1","¡Ii Apuri warartusmi! Ii Yusri kantamruatnuka nekas shiirmaitai. Tura ii Yusri warartustinka nekas pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_2","020_147_2","PSA","147","2","2","Ii Apuri ni yaktarin Jerusalén tutain ataksha jeamkarti tusa, ni aintsri ainautin kakamtikramji. Tura Israela weari ainautin atu atu chikich nungkanam akuptamramiaji nunaka ataksha itarmimiaji. ");
INSERT INTO acuNT_vpl VALUES ("PS147_3","020_147_3","PSA","147","3","3","Tura napchau nintimsar pujuinauncha ataksha pengker nintimtikratnuitai. Tura katsumkamu ainauncha tsuwartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_4","020_147_4","PSA","147","4","4","Yuska yaa ainausha warutmak ainia tusa nekawai, tura kichik kichik yaa ainauncha naarin inaiyawai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_5","020_147_5","PSA","147","5","5","Ii Yusringkia juuntaitai, tura kakarmaitai. Tura asamtai ni nintimauringkia nekaachminuitji. ");
INSERT INTO acuNT_vpl VALUES ("PS147_6","020_147_6","PSA","147","6","6","Wikia mianchawaitjai tumamin ainaunka ii Apuringkia inankitnuitai. Antsu pasé aints ainaunka tuke inatsartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_7","020_147_7","PSA","147","7","7","Ii Apuri maaketai tusaram kanta kantamruataram. Tura ii Yusri warartakrum kitarrjai kanta tuntuyataram. ");
INSERT INTO acuNT_vpl VALUES ("PS147_8","020_147_8","PSA","147","8","8","Yuska nayaimpinam mukunit ati tusa akupawai. Tura yumi jiturti tusa umiawai. Tura muranam chirichri tsakarti tusa tsapamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PS147_9","020_147_9","PSA","147","9","9","Kuntin ainauncha Yus yurui. Tura kantserkapi uchiri juutinamtaisha Yus yurui. ");
INSERT INTO acuNT_vpl VALUES ("PS147_10","020_147_10","PSA","147","10","10","Kawai ainausha tura aints ainausha ni kakarmarijaingkia Yusnaka pengkerka awajinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PS147_11","020_147_11","PSA","147","11","11","Antsu niin umirin ainauka tura ni anengkratairin nintimsar pujuinauka Yusnaka pengker awajinawai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_12","020_147_12","PSA","147","12","12","Jerusalénnum pujuinautiram, ii Apuri warartustaram. ");
INSERT INTO acuNT_vpl VALUES ("PS147_13","020_147_13","PSA","147","13","13","Ni wakerau asamtai, atum shamtsuk pengker nintimtusrum pujuyarme. Tura asakrumin atumi uchiri ainauncha Yus pengker awajsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS147_14","020_147_14","PSA","147","14","14","Atumi nungkari pengker nintimsaram angkan pujustaram tusa, Yus atumin pengker awajtamrume. Tura yutancha pengkeran atumin suramrume. ");
INSERT INTO acuNT_vpl VALUES ("PS147_15","020_147_15","PSA","147","15","15","Ningki ni chichamenka nungkanam akupawai. Turamtai ni chichamengka wári mash nungka ainamunam jeawai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_16","020_147_16","PSA","147","16","16","Yuscha michan yukuuya tumaun nungkanam akupawai. ");
INSERT INTO acuNT_vpl VALUES ("PS147_17","020_147_17","PSA","147","17","17","Tura kaya tumau micha yakiiya kakeerarti tusa akupawai. Turasha entsa waininayat, aints ainau nungkanam wekajina nunisarang katingkiarti tusa, entsanka pisu najanui. ");
INSERT INTO acuNT_vpl VALUES ("PS147_18","020_147_18","PSA","147","18","18","Antsu ni chichamen akupak: Entsa pisu amia nu ataksha yumi ati tusa najanui. Tura nasen tsuweran akupak: Entsa ataksha wej wajati tusa najanui. ");
INSERT INTO acuNT_vpl VALUES ("PS147_19","020_147_19","PSA","147","19","19","Yus ni chichamen Jacobo weari ainaun nekamtikiamiayi. Tura ni umirkatin chichamnaka Israela weari ainau umirkarti tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PS147_20","020_147_20","PSA","147","20","20","Antsu chikich nungkanmaya ainaunka ni chichamenka nekamtikiachmiayi. Tura asamtai ni umirkatin chichamnaka pengké nekaacharmiayi. ¡Ii Apuri warartusmi!");
INSERT INTO acuNT_vpl VALUES ("PR1_1","021_1_1","PRO","1","1","1","Wikia Davida uchiri Salomónkaitjai. Israela apurinjai. Ju chicham ainaun aaran, ");
INSERT INTO acuNT_vpl VALUES ("PR1_2","021_1_2","PRO","1","2","2","aints ainau nekas chicham aa nuna nintimrarti, tura pengker aa nuna nuimiararti, tura nuikiartutai chichamnasha nekaawarti, ");
INSERT INTO acuNT_vpl VALUES ("PR1_3","021_1_3","PRO","1","3","3","tura pengker aa nuna nuimiarar, waurtsuk paan nintimrar, nekas pengker aa nuna turawarti, tura chikich ainauncha anangtsuk, pengker aa nuna awajsatniuncha nekamtikiatasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_4","021_1_4","PRO","1","4","4","Tura natsa nekachu ainau nintip arti tusan, tura paan nintimrar nekau arti tusan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_5","021_1_5","PRO","1","5","5","Tura nekau ainau ju chichaman antukar, nuna nangkamasar nekawartinuitai. Tura nintip ainau nuna nangkamasar nuimiarartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_6","021_1_6","PRO","1","6","6","Tura nuikiartutai chichaman, tura metektaku chichamnasha, tura nekashtai chichamnasha nintijai nekatniusha mash nuimiararti tusan ju chichamnasha aajai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_7","021_1_7","PRO","1","7","7","Nekau ataj takurkia, iinu Apuri Yus miatrusrik umirkatnuitji. Antsu nintinchau ainau nekas aa nuna nintimratniuncha tura pengker aa nu nuimiatincha nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_8","021_1_8","PRO","1","8","8","Uchiru, aparmi chicharkatamauri antukta. Turasha nukuru nuikiartamuringkia pachiatsjai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR1_9","021_1_9","PRO","1","9","9","Pengker aa nu nuinakmeka, tawaaspajai shiiram etsengkrakua nunismek, turasha shaak shiiram nungkurtinua nunismek pengker nintimsam pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR1_10","021_1_10","PRO","1","10","12","Uchiru, pase aints ainau amin anangkraminak: Iin pachinkata. Iikia anumkar aints anearchau wekaamtai, nu maar waa taimunam ajuarar, nunia yukuarar ukuktatji, tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_13","021_1_13","PRO","1","13","13","Turakur iikia kuik tura warinchu ainausha waring achat mash jurukir, ii jeen chumpiami. ");
INSERT INTO acuNT_vpl VALUES ("PR1_14","021_1_14","PRO","1","14","14","Watska, iin pachinkata. Nunia iikia mash metek kuikiartin jaktatji, turaminamtaisha, ");
INSERT INTO acuNT_vpl VALUES ("PR1_15","021_1_15","PRO","1","15","15","uchiru, nu pase turin aina nujaingkia tsaningkaip. Tura ni tina nuka antukaip. ");
INSERT INTO acuNT_vpl VALUES ("PR1_16","021_1_16","PRO","1","16","16","Pase turin aina nuka mangkartuataj tusar, aya waurkamin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_17","021_1_17","PRO","1","17","17","Nintimrata. ¿Chingki achiktai tusar, chingki ainaun wainkar, jiimiaj eketinai ejatkajai achikminkai? Atsa. ");
INSERT INTO acuNT_vpl VALUES ("PR1_18","021_1_18","PRO","1","18","18","Nu mangkartin ainauka aya ningki amuninawai. Tura ningki mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_19","021_1_19","PRO","1","19","19","Aints ainau aya warinchun achiktai tusar wakerina nuka ni wakeramurin umitsuk aya jakatniunam weenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_20","021_1_20","PRO","1","20","21","Paan nintimratniuka nekas wakeruktinuitai. Yus yaktanam aints untsuri wekaatinam wajas, untsuawa nunisang aints ainaun chicharak: ");
INSERT INTO acuNT_vpl VALUES ("PR1_22","021_1_22","PRO","1","22","22","Nintinchau ainautiram ¿warutik nintinchau wajatisha inaisatrum? Wishikiartin ainautirmesha, ¿warutik chikich aints ainau pachisrum wishiktsuk pujustaram? Tura netse ainautirmesha ¿warutik nekas chicham antut nakitaisha inaisatrum? ");
INSERT INTO acuNT_vpl VALUES ("PR1_23","021_1_23","PRO","1","23","23","Wi taja nuka antuktaram. Turakrumka wina wakantrunka atumi nintin engkean piatkatnuitjai. Tura wi nintimaurun paan nekamtikiatnuitjarme. ");
INSERT INTO acuNT_vpl VALUES ("PR1_24","021_1_24","PRO","1","24","24","Wikia atumin: Winitaram tusan untsuamaitiatrum, atumka umirtuktinka nakitrurmarme. ");
INSERT INTO acuNT_vpl VALUES ("PR1_25","021_1_25","PRO","1","25","25","Wi tamaitiatrum, nuikiartamur antukchamarme, tura chicharkartamursha nakitramarme. ");
INSERT INTO acuNT_vpl VALUES ("PR1_26","021_1_26","PRO","1","26","27","Tura asamtai wina chichamur nakitrau asakrumin, atumi wait wajaktintri jeamtaikia, wait anentrashtinuitjarme, antsu sapijmiakrum pujakrumin wishikratinuitjarme. Kame, juun nase, katurang meskartin shamarmena tumau nukap wait wajaktin jeamtaikia, wait anentrashtatjarme. ");
INSERT INTO acuNT_vpl VALUES ("PR1_28","021_1_28","PRO","1","28","29","Nuniangka aints ainau untsurkartatui, turutinaunak wikia aikchatatjai. Turasha waurinak winaka eatkartatui, antsu paan nintimratniunka nakitinak, wina umirtutan nakitruraru asar, winaka pengkej waitkachartatui. ");
INSERT INTO acuNT_vpl VALUES ("PR1_30","021_1_30","PRO","1","30","30","Turasha wi nuikiartamurun nakitrar, wi chicharkartamurun pachischaru asar, ");
INSERT INTO acuNT_vpl VALUES ("PR1_31","021_1_31","PRO","1","31","31","ni turutairijaingkia aints ni yutairin nukap yuwinau asar, tangkar iniukmin nekapenawa nunisarang ni pase nintimaurijai wait wajakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_32","021_1_32","PRO","1","32","32","Nintinchau ainauka ni turutairijai jakartin ainawai. Tura netse ainauka nangkamiar: Iikia nekasar pengker pujaji, tinayat mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR1_33","021_1_33","PRO","1","33","33","Antsu wina chichamrun umiina nuka angkan pujusar, pasenasha shamtsuk matsamsartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_1","021_2_1","PRO","2","1","2","Uchiru, wi tajame nu antukam, wina umirtuktin chichamsha kajinmatsuk aneakmeka, tura paan nintimratasam wakerakmeka, turasha pengker aa nu nekatasam wakerakmeka, ");
INSERT INTO acuNT_vpl VALUES ("PR2_3","021_2_3","PRO","2","3","3","tuke nu wakerau asam, ¿itiur nekas pengker pujustaj? tusam, tu pujustincha seata. ");
INSERT INTO acuNT_vpl VALUES ("PR2_4","021_2_4","PRO","2","4","5","Tura aints ainau kuikian tura kurincha timiá wakerinauka nunak eaina nunismek: ¿Yus warukuita? tusam nekatasam wakerakmeka, Yuska tu awai tusam nekaatnuitme, tura iinu Apuri miatrusrik umirkatnuitji tusam nintimratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_6","021_2_6","PRO","2","6","6","Nekas paan nintimratniunka ii Apuri suramji. Tura ni chichamen nintimrar: Yus tu awai tusar nekaatnuitji. Turasha ¿itiur iinu Apuri umirkatnuitji tusar nintimratnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR2_7","021_2_7","PRO","2","7","7","Aints ainau Yusen miatrusarang umirina nunaka paan nintimrarti tusa iinu Apuri yainkatinuitai. Tura tunaunaka nakitajai tinu ainaun yamruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_8","021_2_8","PRO","2","8","8","Yus ni umirin ainaun nekas wainui. Tura pengkera nuna turatasan wakerina nunasha ejawitai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_9","021_2_9","PRO","2","9","9","Turamtai: Mash pengker aa nunaapi nintimratatja, tusam tura: Tunaarinchawapi pujustatja tusam, tura: Tupin nintimsanapi pujustatja titatme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_10","021_2_10","PRO","2","10","10","Kame, tu pujakmeka paan nintimratnuitme, turasha nekau aints wajastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_11","021_2_11","PRO","2","11","11","Tu pujakmeka itiurkachmintrumka atsutnuitai. Tura nintip wajasam nuwakchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_12","021_2_12","PRO","2","12","12","Tu pujakmeka tunau jintanam wekasashtatme. Tura pase chichainamunmasha pachinkashtatme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_13","021_2_13","PRO","2","13","13","Nu aints ainauka tupin nintimtsuk pengker jintan ukukiar teenam wekainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_14","021_2_14","PRO","2","14","14","Tura tunaunaka turinak warainawai. Tura pase aa nunak wakerinak: Maj, nuka nekas pengkeraitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_15","021_2_15","PRO","2","15","15","Tura tuni wekaina nuni tunau turin ainawai. Tura jinta tupin aa nuna ukukiar, waaktin jintanam wekainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_16","021_2_16","PRO","2","16","16","Tura nuwa ainau kuntuji chichasar, anangkramatasar wakerinamtaikia, nuna chichamen antutsuk angkanmamtikiatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR2_17","021_2_17","PRO","2","17","17","Kame, nu nuwa natsan ninumkar, Yus wainmaka nuwatnaikiatin chichaman najana nunaka umitsuk aishrin ukuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_18","021_2_18","PRO","2","18","18","Nu nuwa jeen wayawaru ainauka jakatniunam weenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_19","021_2_19","PRO","2","19","19","Tura nuni wayawaru ainauka nunia jiintsuk tuke iwiaaku pujustinnum jintanmaka ataksha wekainatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR2_20","021_2_20","PRO","2","20","20","Tura asamtai pengker aints ainau pengker jintan amaina nuni amesha wekasata. Tura asam Yusen umirin ainau turina nusha turata. ");
INSERT INTO acuNT_vpl VALUES ("PR2_21","021_2_21","PRO","2","21","21","Yuse umirin ainau ju nungkanam pengker pujusar tura tunaarinchau pujusar, tuke pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR2_22","021_2_22","PRO","2","22","22","Antsu Yusen umirtsuk pujuinauka pase asaramtai, aints ainau nupaan uweenawa nunisarang ajapawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_1","021_3_1","PRO","3","1","1","Uchiru, wi akupamurun unuiniajme nu kajinmatsuk tuke nintimin ukusta. ");
INSERT INTO acuNT_vpl VALUES ("PR3_2","021_3_2","PRO","3","2","2","Nuka timiatrusmek umirkumka, nukap musach pengker nintimsam pujusam warastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR3_3","021_3_3","PRO","3","3","3","Tura nekas chicham ainauka tura wait anengkrataisha pengkej inaisaip. Antsu aints ainau shaak nungkurtinua nunismek kajinmatsuk nintinam nintimsam pujusta. ");
INSERT INTO acuNT_vpl VALUES ("PR3_4","021_3_4","PRO","3","4","4","Nu turakminka Yuscha aminka pengker nintimturmastinuitai, tura aints ainausha nunisarang amin pengker nintimturmasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_5","021_3_5","PRO","3","5","5","Ami Apuram Yus tuke nintimaurmijai nintimtusta. Antsu amek: Wikia nintipitjai, tuuka nintimtumasaip. ");
INSERT INTO acuNT_vpl VALUES ("PR3_6","021_3_6","PRO","3","6","6","Ame warí turame nuka Apuram nintimsam turata. Nu turakminkia ni jinti nekas tupin aa nuna inakturmastatui. ");
INSERT INTO acuNT_vpl VALUES ("PR3_7","021_3_7","PRO","3","7","7","Wikia mash nekajai. Witsukaitja chikich ainaun nangkamasnak timia nekauna tuuka nintimtumasaip. Antsu Apuram pengker awajsata, tura tunausha inaisata. ");
INSERT INTO acuNT_vpl VALUES ("PR3_8","021_3_8","PRO","3","8","8","Nuka tsuwakan nangkamasang pengkeraitai. Tu pujakmeka namangkem kakamtikratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR3_9","021_3_9","PRO","3","9","9","Kuik juwame nuka tuu ajanmaya araka juwame nusha akankam Yus tuke susata. ");
INSERT INTO acuNT_vpl VALUES ("PR3_10","021_3_10","PRO","3","10","10","Nu turakmeka ajanmaya juuktatme nuka nukap yujartinuitai. Tura amutirmesha amukashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_11","021_3_11","PRO","3","11","12","Uchiru, aints ni uchirin aneau asa, pengke aints ati tusa, wait wajaktinun susatnuitai. Tura asamtai, uchiru, Apuram amin anenmau asa, wait wajaktinun suramsamtaisha nuka nakitraip. ");
INSERT INTO acuNT_vpl VALUES ("PR3_13","021_3_13","PRO","3","13","14","Nekatniuka kuikian nangkamasang pengkeraitai, tura paan nintimratniuka kurin nangkamasang iin yainmaktinuitji. Aints paan nintimratniunka tura nekaatniunka juwawa nuka nekas warastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_15","021_3_15","PRO","3","15","15","Paan nintimratnuka kaya nekas akik aina nuna nangkamasang paan nintimratniuka timiá wakerumaintia. Tura asamtai nuna nangkamaska timiá pengkerka atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_16","021_3_16","PRO","3","16","16","Apurka paan nintimratnunka nukap suramji. Nunia nukap musach pujustinun, tura yuumatsuk pujustinun, turasha iin pengker awajtamsatniurincha suramji. ");
INSERT INTO acuNT_vpl VALUES ("PR3_17","021_3_17","PRO","3","17","17","Nujaingkia angkan nekas pengker pujusminuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR3_18","021_3_18","PRO","3","18","18","Paan nintimratin iin pujurtamatinkia, tuke iwiaaku pujustinuitji. Tura nekasar warastinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR3_19","021_3_19","PRO","3","19","19","Ii Apuri Yuska ni nekatairijaingkia ningki nintimias nungkancha, tura nayaimpincha najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR3_20","021_3_20","PRO","3","20","20","Tura nekas timiá nekau asa: Yakiya yumi nungkaya entsajai akankamu ati tusa akankamiayi. Tura yumin tura sanancha akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR3_21","021_3_21","PRO","3","21","21","Uchiru, paan nintimram nintip wajasta. Kame, pengker aa nu jiisam, tura tunausha jiisam, warí pengkeraita tura warí pengkerchawaita tusam nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("PR3_22","021_3_22","PRO","3","22","22","Tu pujakmeka nekas pengker pujustinuitme, tura aints ainau amin waitmakar: “Nuka nintipitai” tusar, aints shaakun nungkurar wekainawa nunisarang amin waitmakartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_23","021_3_23","PRO","3","23","23","Tura asamtai pengker nintimsam jintanam angkan wekasatnuitme, turasha tukumkayatmek ayaarchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR3_24","021_3_24","PRO","3","24","24","Tura kanakmesha shamkashtinuitme, tura sapijmiatsuk pengker kanurtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR3_25","021_3_25","PRO","3","25","25","Tura aneachmau itiurchat akungka, tura tunau aints ainaun Yus wait wajaktinun akupkamtaikia, ameka shamkashtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR3_26","021_3_26","PRO","3","26","26","Nu kintia jeamtaikia, itiurchatnum iyaaraim tusa Apuram: Shamkaip tusa waitmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_27","021_3_27","PRO","3","27","27","Aints ainau yuminamtaikia, ame yaingmin akumka, wait anentakum pachitsuk yaingta. ");
INSERT INTO acuNT_vpl VALUES ("PR3_28","021_3_28","PRO","3","28","28","Tura ami irutkamuram yuminamtaikia, yamaik takakumka: Kashin winita, turakminka susamjinam tutsuk, yamaik susata. ");
INSERT INTO acuNT_vpl VALUES ("PR3_29","021_3_29","PRO","3","29","29","Amijai patas puja nuna pasen awajsataj tuuka nintimraip. ¿Nuka amin pengker nintimturmas pujatsuash? ");
INSERT INTO acuNT_vpl VALUES ("PR3_30","021_3_30","PRO","3","30","30","Aints amin pase awajtamtsuk pujamtaikia, ameka nangkami nijai maanitsuk asata. ");
INSERT INTO acuNT_vpl VALUES ("PR3_31","021_3_31","PRO","3","31","31","Pase aints wainkam: Wikia nijai metek kuikiartin wajasan, kakaram wajastasan wakerajai, tusam suwirpiaku nintimtusaip. Turasha ni tura nunasha turatasan wakerajai tuuka nintimtusaip. ");
INSERT INTO acuNT_vpl VALUES ("PR3_32","021_3_32","PRO","3","32","32","Ii Apuri pase nintintin ainaun nakitawai. Antsu pengker nintintin ainaun ni amikria nunisang pengker awajui. ");
INSERT INTO acuNT_vpl VALUES ("PR3_33","021_3_33","PRO","3","33","33","Pase aints ainaun ni weari ainaujai ii Apuri kajerawai. Antsu pengker aints ainaun pengker awajui. ");
INSERT INTO acuNT_vpl VALUES ("PR3_34","021_3_34","PRO","3","34","34","Wishikiartin ainaunka ii Apurisha wishikratnuitai. Antsu jampechu ainaun wait anentratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR3_35","021_3_35","PRO","3","35","35","Paan nintintin ainauka pengker awajsamu ainawai. Antsu netse ainauka natsanpiaku asaramtai, jiitnasha nakitin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_1","021_4_1","PRO","4","1","1","Uchitiram, wina chichamur pengker nintimsaram anturtuktaram. Nu antukrumka paan nintimin atinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PR4_2","021_4_2","PRO","4","2","2","Wikia atumin pengker nuiniartatjarme. Tura asaram wi nuikiartamur umirkuram inaisairap. ");
INSERT INTO acuNT_vpl VALUES ("PR4_3","021_4_3","PRO","4","3","3","Wikia uchi asan, aparu jeen pujain, nukuru uchiri chikichik asamtai, ");
INSERT INTO acuNT_vpl VALUES ("PR4_4","021_4_4","PRO","4","4","4","apar nuitiak: Wina chichamur tuke nintimtusam pujusta. Tura asam wi akupamur umirkumka, nekasam pengker pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR4_5","021_4_5","PRO","4","5","5","Paan nintimratniuka tura pengker nekatniuka wakerukta. Wina chichamur kajinmakiip, turasha umirtsuk pujusaip. ");
INSERT INTO acuNT_vpl VALUES ("PR4_6","021_4_6","PRO","4","6","6","Paan nintimratniuka inaisaip. Tura nu aneakmeka, amin ayamrutmaktinutai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_7","021_4_7","PRO","4","7","7","Mash pengker aina nuka nuna nangkamasmek paan nintimratniuka wakerukta. Kame, warinchu mash takakmena nuna nangkamasmek pengker nekatniuka wakerukta. ");
INSERT INTO acuNT_vpl VALUES ("PR4_8","021_4_8","PRO","4","8","8","Nekatniuka mash aina nuna nangkamasmek pengkeraitai tusam nintimtusta. Nu turakmeka pengker pujustinuitme. Kame, nuwa winiaksam pengker awajsatnua nunismek paan nintimratniuka nukap wakerukta. Turakminka amincha pengker nintimturmastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_9","021_4_9","PRO","4","9","9","Turakminka aints ainau tawaaspan shiirmachin etsengkrukar iwiarmamina nunismek pengker nintimsam pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR4_10","021_4_10","PRO","4","10","10","Tura asamtai uchiru, wina chichamur antukta. Tura wi tajame nu miatrusmek turata. Turakmeka untsuri musach iwiaaku pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR4_11","021_4_11","PRO","4","11","11","Wikia paan nintimratniun jintanmaka wekasata tusan nuiniarjame, tura jinta tupin amaunmasha wekamtikjame. ");
INSERT INTO acuNT_vpl VALUES ("PR4_12","021_4_12","PRO","4","12","12","Nu jintanam wekakmeka tukumkashtinuitme. Tura ampuakmesha iyaarchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR4_13","021_4_13","PRO","4","13","13","Wi nuiniarmiajme nuka kajinmatkiip. Tura mash umirkam pengker pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR4_14","021_4_14","PRO","4","14","14","Tura asamtai, uchiru, tunau ainau wekaina nu jintanmaka wekaasaip. Tura ni turutirisha turawaip. ");
INSERT INTO acuNT_vpl VALUES ("PR4_15","021_4_15","PRO","4","15","16","Yusen umirkacharu ainau tunaun takatsuk pujusar kanurchartin ainawai. Tura chikich aintsun tunaun takamtiksacharu asar, kanurtatkamawar tujintinawai. Tura asamtai Yusen umirkacharu ainau jinti wekatsuk asata. Pengké inaisata tajame. ");
INSERT INTO acuNT_vpl VALUES ("PR4_17","021_4_17","PRO","4","17","17","Aints ainauti yurumak tura umuti wakerajina nunisarang nu aints ainau tunaun wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_18","021_4_18","PRO","4","18","18","Antsu Yusen umirnu jintikia tsaa yamai jiinai, paan tsantua nunisang, tura tupnitak eketai, te paan tsantua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_19","021_4_19","PRO","4","19","19","Tura Yusen umirchau aina nuna jintikia teeyaitai. Tura asamtai aneachmau warinmak tukumkarang iyaina nunaka nekaminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR4_20","021_4_20","PRO","4","20","20","Tura asamtai uchiru, wi tajame nuka tenapkesam antukta. ");
INSERT INTO acuNT_vpl VALUES ("PR4_21","021_4_21","PRO","4","21","21","Tura pengké kajinmatsuk wina chichamur tuke nintimin ukusta. ");
INSERT INTO acuNT_vpl VALUES ("PR4_22","021_4_22","PRO","4","22","22","Nu chichaman antinauka tsuwakan kujarua nunisarang pengker pujusartinuitai. Turasha pengker pujustinnun wainkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR4_23","021_4_23","PRO","4","23","23","Mash warinchu ainaun nangkamasmek nintim wainkata. ¿Waruka? Nujaingkia iwiaaku pujustinuitme tajame. ");
INSERT INTO acuNT_vpl VALUES ("PR4_24","021_4_24","PRO","4","24","24","Pase chicham chichastinka inaisam, wait chichamsha pengké chichakaip. ");
INSERT INTO acuNT_vpl VALUES ("PR4_25","021_4_25","PRO","4","25","25","Tura jiimkumka, tunau juninisha jiimtsuk, tura atuninisha jiimtsuk tupnik jiimsata. ");
INSERT INTO acuNT_vpl VALUES ("PR4_26","021_4_26","PRO","4","26","26","Ame tuni wekame nuni mash pengker jiisam, tunaunum ayaaraim anearam wekasata. ");
INSERT INTO acuNT_vpl VALUES ("PR4_27","021_4_27","PRO","4","27","27","Pengker jintanam wekame nunia jiinkip. Antsu tunau jintanam wekakmeka, nunia jiinkim pengker jintanam wekasata. ");
INSERT INTO acuNT_vpl VALUES ("PR5_1","021_5_1","PRO","5","1","1","Uchiru, wikia paan nintimratniunka nuiniajme nuka tenapkesam nintimram antukta. ");
INSERT INTO acuNT_vpl VALUES ("PR5_2","021_5_2","PRO","5","2","2","Wi tajame nu turutai pengkeraitai, antsu chikich turutai paseetai tusam nintimin ukusta. Tura nu mash nekau asam, chichaakmeka nekas pengker chichastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR5_3","021_5_3","PRO","5","3","3","Kungkatip nuwa aishmangkun nekas yuminchin chicharui, tura: Wi turaja nuka nekas pengkeraitai tusa anangkeawai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_4","021_5_4","PRO","5","4","4","Antsu inangnamunam ni turamuri saapi ere etsakamua tumawaitai, tura yapauwa tumau nekapratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_5","021_5_5","PRO","5","5","5","Nu nuwaka mengkakatniunam jeakui, tura niin nemarina nusha tuke jakatniunam wenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_6","021_5_6","PRO","5","6","6","Nu nuwaka tuke iwiaaku pujustin jintanmaka pengke wekatsui. Mai nintim weau asa, pujutruka jinta tuninua nunisketai tusangka nintimtsui. ");
INSERT INTO acuNT_vpl VALUES ("PR5_7","021_5_7","PRO","5","7","7","Tura asamtai uchitiram, anturtuktaram. Turaram wi tajarme nuka kajinmatkirap. ");
INSERT INTO acuNT_vpl VALUES ("PR5_8","021_5_8","PRO","5","8","8","Kungkatip nuwa pujamunmaka pengké jirasairap. Turaram ni jeenka wayawairap. ");
INSERT INTO acuNT_vpl VALUES ("PR5_9","021_5_9","PRO","5","9","9","Atumi kakarmari chikichan susairam tusan, tura atumi iwiaakmari mengkakchati tusan juna tajarme. Atum mengkakatatrume tusar nu nuwa ainauka pengké pachinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR5_10","021_5_10","PRO","5","10","10","Nuna jeen wayaakrumka, atum takakmakrum waitnasrum atumi kuikiari irumrarume nuka nangkamrum ajapatatrume. Turakrumka chikich kuikiartin wajasti tusaram atumi kuikiari susatatrume. ");
INSERT INTO acuNT_vpl VALUES ("PR5_11","021_5_11","PRO","5","11","11","Turakrum ukunam atumi namangke yaitas amuki amuki weamtai, ¿warukanak timiá nintimtsuk aitkamiaja? tusaram eaartinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PR5_12","021_5_12","PRO","5","12","12","Nunia juutkuram: “Warukanak chicharmaitiatnasha, nintimtsuk pengké antukchaya? ");
INSERT INTO acuNT_vpl VALUES ("PR5_13","021_5_13","PRO","5","13","13","¿Warukanak nuikiartin ainau chichamen antutan pengké nakitnuyaja? ");
INSERT INTO acuNT_vpl VALUES ("PR5_14","021_5_14","PRO","5","14","14","“Yamaikia mash aints iruntramunmasha wi pase turamurun nekaawaru asaramtai, wikia natsaamakun jakatasan wakerajai titatrume”. ");
INSERT INTO acuNT_vpl VALUES ("PR5_15","021_5_15","PRO","5","15","15","Tura asamtai chikicha maatirinkia wetsuk, atumi maatirin werum, nuni maaitiaram. ");
INSERT INTO acuNT_vpl VALUES ("PR5_16","021_5_16","PRO","5","16","16","¿Warí, atumi kakarmari yaktanmasha ajapatniukaitrum? ");
INSERT INTO acuNT_vpl VALUES ("PR5_17","021_5_17","PRO","5","17","17","Atumi kakarmari atumnauk atinuitai, antsu chikichnau achatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_18","021_5_18","PRO","5","18","18","Atumi nuwarijai nekasrum pengker pujustaram. Tumakrum atumi nuwarijaingkia wararnaisataram. ");
INSERT INTO acuNT_vpl VALUES ("PR5_19","021_5_19","PRO","5","19","19","Kame, atumi nuwaringkia tangkuchia nunisrumek minaksaramaneetaram. Tura asakrumin atumi nuwari ni aneamurijaingkia tuke atumin waramtikramsarti. ");
INSERT INTO acuNT_vpl VALUES ("PR5_20","021_5_20","PRO","5","20","20","Tura asamtai uchiru, ¿warukamtiya nuwa aminuchusha chikichnau wainiatum, nujai minaknaisam tsanirmatatme? ");
INSERT INTO acuNT_vpl VALUES ("PR5_21","021_5_21","PRO","5","21","21","Warí, ii Apuringkia aintsu pujuntrin mash wainuitai. Turasha ni turamuringkia mash nekaawaintai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_22","021_5_22","PRO","5","22","22","Pase aintsu tunaari ainauka angkan pujuschamnaun chapikjai jingkiamua nunisarang metawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR5_23","021_5_23","PRO","5","23","23","Tumau asaramtai ni namangke wakeramurin najaninauka pengké nintinchau asar, jakatnunam wenawai, tura timiá tunaarintin asar, wait wajaktinnum jeainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_1","021_6_1","PRO","6","1","1","Uchiru, ami irutkamuram chichartamak: Wikia tumashitjai. Antsu akiimiakchamin asamtai, ukunam akikmijinam tusan, ame tumaashruka akiimiaktrukta tamataikia, ");
INSERT INTO acuNT_vpl VALUES ("PR6_2","021_6_2","PRO","6","2","2","ame ayu takumka, ami chichammijiaing chapikjiai jingkiamua nunisketme. ");
INSERT INTO acuNT_vpl VALUES ("PR6_3","021_6_3","PRO","6","3","3","Turakmeka uchiru, chikich aintsu tumaashrin akiktatjai tinu asam, yamaik angkanmamtikiata. Turakum wake mesekam ami irutkamuram werim: Tumaashrum akimiakchamnau asamtai tsangkutrurta tita. ");
INSERT INTO acuNT_vpl VALUES ("PR6_4","021_6_4","PRO","6","4","4","Tura irutkamurmin wetsuk pujakmeka, kanutsuk asata. Tura nijai chichatsuk pujakmeka pengké ayamraip. ");
INSERT INTO acuNT_vpl VALUES ("PR6_5","021_6_5","PRO","6","5","5","Angkan wajastaj takumka, japa waitmak tsekea nunismek, tura chingki ejatkan wainak nanaki yaja weawa nunismek angkanmamtikiata. ");
INSERT INTO acuNT_vpl VALUES ("PR6_6","021_6_6","PRO","6","6","6","Ame naki akumka, week ainau takakminak wekaina nu jiisam, takakmastin nuimiarta. ");
INSERT INTO acuNT_vpl VALUES ("PR6_7","021_6_7","PRO","6","7","7","Kame, takata apuri atsayat, tura juuntri: Tu takakmastai tachamaitiat, ");
INSERT INTO acuNT_vpl VALUES ("PR6_8","021_6_8","PRO","6","8","8","weekka ni wakeramurijai kintajai metek takakminawai. Tura yumitin ayamsarmi tusa, esati takakmasar, nuka ainaun juukar ukuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_9","021_6_9","PRO","6","9","9","Maj, amesha naki akumka, ¿warutam arusmek nantaktiamek? ¿Warutam arusmek shintaram takat nangkamatam? ");
INSERT INTO acuNT_vpl VALUES ("PR6_10","021_6_10","PRO","6","10","11","Jumchiksha kanurtajai. Jumchiksha ayamsatjai tu nintimsam pujakminka, aneachmau tsuka mangkartinua nunisang nepetmaktinuitai. Tura kasa aints warinchurmin kasamkatas aneachmau jeemin wayaawa nunisang winamtai yuumaktinuitme. Tura asamtai kakaaram takakmasta tajame. ");
INSERT INTO acuNT_vpl VALUES ("PR6_12","021_6_12","PRO","6","12","12","Aints pase nintintin warukuita tusan nuiniajrume: Nu aintska nangkami chichaakka, wait chichaman etserui. ");
INSERT INTO acuNT_vpl VALUES ("PR6_13","021_6_13","PRO","6","13","13","Tura aintsun anangkatas, jiijai mitsum wajaayi. Tura nawejai tura uwejejai inakmas wajaayi. ");
INSERT INTO acuNT_vpl VALUES ("PR6_14","021_6_14","PRO","6","14","14","Ni nintimauri pase asamtai, tuni wekaawa nunisha tuke aints ainaun anangkatas wakerawai. Turasha aints ainau chichainamtai, maaniawarti tu nintimias chichaawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_15","021_6_15","PRO","6","15","15","Tura asamtai nu aintsu waitnastintri aneachmau jeatnuitai. Tura pengké ayamrukchamin mengkakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_16","021_6_16","PRO","6","16","16","Yuse nakitamuringkia seisaitai. Kame, nekas siete ainawai: ");
INSERT INTO acuNT_vpl VALUES ("PR6_17","021_6_17","PRO","6","17","17","Aints: Wikia miajuitjai tusa, chikich aintsnaka: Mianchawaitai tusa suwirpiaku jiinaunka Yuska naktitawai. Tura wait chichaman etserin ainauncha nakitawai. Tura anangmichu ainaun mainauncha Yuska nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_18","021_6_18","PRO","6","18","18","Tura aints tunau nintimsar pujuinauncha, tura chikich ainaun pase awajsartas wakerina nunasha Yuska nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_19","021_6_19","PRO","6","19","19","Tura chikich aints ainaun tsanuminak pujuinauncha, tura aints chikich aintsun ni yachijai kajernaikiati tusa nintimtikniuncha Yuska nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_20","021_6_20","PRO","6","20","20","Uchiru, wina chichamur umirkam, nukuram nuitamramia nusha kajinmatkiip. ");
INSERT INTO acuNT_vpl VALUES ("PR6_21","021_6_21","PRO","6","21","21","Nekasan kajinmatkii tusam, tuke nintimin ukusta. ");
INSERT INTO acuNT_vpl VALUES ("PR6_22","021_6_22","PRO","6","22","22","Tsawaisha tuni wekaame nunisha nu chichamnaka nuitamrartinuitai. Tura kashi tepakmincha nunisha aminka waitmakartinuitai. Nunia tsawaarkum shintaram nunisha nu nuikiarturmauka nintimratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR6_23","021_6_23","PRO","6","23","23","Nu umirkatin chicham ainauka namparin kapawa nunisarang ainawai. Tura shirikip kea nunisarang ainawai. Nuka itiur timiá pengker pujusminuita tusar nuitamrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_24","021_6_24","PRO","6","24","24","Tura kungkatip nuwa amin anangkramatas chichamtaisha, umirkatin chicham ainauka amin angkan awajtamsartinuitai. Tura aishrintin amin anangkramatas wakeramtaikia, nunia kiishmaktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR6_25","021_6_25","PRO","6","25","25","Nuka shiirmachitai, tuuka nintimraip. Kame, amin waitmak jimiaj wajamtaisha, ameka jiisaip. ");
INSERT INTO acuNT_vpl VALUES ("PR6_26","021_6_26","PRO","6","26","26","Kungkatip nuwa ainauka aya kuikian wakerinak aishmangkun juinawai. Tura aishrintin ainauka amijai tsanirminak ami pujutrumka mesertin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_27","021_6_27","PRO","6","27","27","¿Ji kapaun aints minaksatas wakerakka, wejmakringka aesachminkai? ");
INSERT INTO acuNT_vpl VALUES ("PR6_28","021_6_28","PRO","6","28","28","Tura ji kapamunam sapatrin wejtsuk aints najamtaikia ¿nawencha aesachminkai? ");
INSERT INTO acuNT_vpl VALUES ("PR6_29","021_6_29","PRO","6","29","29","Aints aishrinujai kanurtas tepawa nunisketai. Aishrinun takau ainauka mash ni waitnastintrin jukiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_30","021_6_30","PRO","6","30","30","Aints yaparak tsukajai jakai tusa yurumkan kasamak juwa nunaka chikich aints ainauka tsuutinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR6_31","021_6_31","PRO","6","31","31","Turamaitiat chikich aints nuna wainak achik: Ame kasamkame nuka siete awangturkita tawai. Nu atsamtaikia, ni jeen warinchu iruna nuna mash suruk, kichik kasamkamunam siete akiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_32","021_6_32","PRO","6","32","32","Tura aints aishrinujai kanauka pengké nintinchawaitai. Ningki mestumawai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_33","021_6_33","PRO","6","33","33","Nuka natsanpiakun najanau asamtai, numijai katsumkartatui, tura aints ainauka ni turamurin mash nekainau asar, nu aintsnasha jiitnasha nakitrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_34","021_6_34","PRO","6","34","34","Nu nuwa aishri nekas timiá suwirpiaku nu aintsun kajerak wait anentsuk pengké tsangkurashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR6_35","021_6_35","PRO","6","35","35","Aints: Tsangkutrurta tamaitiat, pengké anturkashtinuitai. Tura kuikian warinchuncha susatjame tamaitiat: Nunasha nakitajai, titinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_1","021_7_1","PRO","7","1","1","Uchiru, ameka wina chichamur umikta, tura nintimin ukusta. ");
INSERT INTO acuNT_vpl VALUES ("PR7_2","021_7_2","PRO","7","2","2","Amin nuiniarmiajme nu umirkata. Aints ni jiin tenap wainina nunismek chichamur umirkumka, nekasam angkan nintimsam pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR7_3","021_7_3","PRO","7","3","3","Tura asam uwejnum wejtai kuri najanamu tuke wejkar wekajina nunismek nu chicham inaitsuk umirkata. Tura nintimin aarmawa nunismek nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("PR7_4","021_7_4","PRO","7","4","4","Tura paan nintimratnuka umaimia nunismek pengker nintimtusta. Tura nekatai aina nuka ami irutkamurmea nunismek pengker awajsata. ");
INSERT INTO acuNT_vpl VALUES ("PR7_5","021_7_5","PRO","7","5","5","Turakmeka kungkatip nuwa kiishmaktinuitme, tura aishrintin anangkramatas chichaamtaisha anturkashtinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR7_6","021_7_6","PRO","7","6","6","Chikich kintiati wikia jearun pujusan, jiimiaj pujumjai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_7","021_7_7","PRO","7","7","7","Tura jimiaj pujai natsa ainau iruntrar wajainamunam natsa chikichkin pengké nintimchaun wainkamjai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_8","021_7_8","PRO","7","8","9","Nu natsaka jea tsukintrin nangkaamak jintian amak, —kungkatip nuwa jeenini kintiamramtai wemayi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_10","021_7_10","PRO","7","10","10","Turamtai nu kungkatip nuwaka shiiram iwiarmamas natsajai ingkiuniktas jiintukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_11","021_7_11","PRO","7","11","11","Nu nuwa ainauka natsaamtsuk chichainawai. Tura ni jeenka pujutan nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_12","021_7_12","PRO","7","12","12","Antsu jea tsukintrin wajasar, tura jintanmasha wekaasar, aints nangkaminaunka jiisar, tsanirmataj tusar nakamkini wajainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_13","021_7_13","PRO","7","13","13","Kame, nu nuwaka natsan tapit achik minakas mejeas, yapin jiiras chicharak: ");
INSERT INTO acuNT_vpl VALUES ("PR7_14","021_7_14","PRO","7","14","14","Wikia Yusrun pengker awajsatasan tangku namangken susan yamai umikjai. Tura nu namangsha jeanam ukusmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_15","021_7_15","PRO","7","15","15","Tura asan amin eaktasan jeanmaya jiinkin, aneachmau wainkajme. ");
INSERT INTO acuNT_vpl VALUES ("PR7_16","021_7_16","PRO","7","16","17","Tura tarach kapantin Ejiptonmaya itamun nunajai peakrun ainkan, kungkuti nekas kungkurmajai yakaran ukukjai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_18","021_7_18","PRO","7","18","18","Tura asamtai winita. Iinu namangke wakeramu sunaisami. Tura minaknaisar tepesar tsawaramtai ukunikmi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_19","021_7_19","PRO","7","19","19","Aishruka jeanmaka pujatsu ai arák iramayi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_20","021_7_20","PRO","7","20","20","Kuikian nukap juki weak: Nantu pamaun yuwamtai tatajai, turutmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_21","021_7_21","PRO","7","21","21","Tura timiá yuminun chichaa chichaaka natsa nintin ikiajtukmayi. ");
INSERT INTO acuNT_vpl VALUES ("PR7_22","021_7_22","PRO","7","22","23","Turamtai waaka uchiri: Yamai jakatjai tuuka nintimtsuk namang surutinam umainak, tura japa entsanam weamtai, maataj tusar nakainak, tura chingki ejatkan waintsuk wayaawa nunisang nu natsaka nuwan nemaras jeanam wayami. ");
INSERT INTO acuNT_vpl VALUES ("PR7_24","021_7_24","PRO","7","24","24","Tura asamtai uchitiram anturtuktaram. Turaram wi tajarme nuka kajinmatkirap. ");
INSERT INTO acuNT_vpl VALUES ("PR7_25","021_7_25","PRO","7","25","25","Nu nuwan nintimtustaj, tuuka nintimrairap. Tura ni wekamunmasha wekasairap. ");
INSERT INTO acuNT_vpl VALUES ("PR7_26","021_7_26","PRO","7","26","26","Nu nuwa ainauka untsuri aintsun anangkawar tunaun takamtikinawai. Tura nu tunaujai jakaru ainauka untsurintai. ");
INSERT INTO acuNT_vpl VALUES ("PR7_27","021_7_27","PRO","7","27","27","Nu nuwa ainau pujuinamunam wearuka jakar mengkakatniunam jeainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_1","021_8_1","PRO","8","1","1","¿Paan nintimrataram ta nuka kakarman untsuatsuash? ");
INSERT INTO acuNT_vpl VALUES ("PR8_2","021_8_2","PRO","8","2","3","Tura muranam jinta tsengkeakunam aints nangkaminaun, tura yakta waitirin untsuri aints wayawartin ainaun jiis untsuak: ");
INSERT INTO acuNT_vpl VALUES ("PR8_4","021_8_4","PRO","8","4","4","Aints ainautirmin wikia untsuajrume. Tura mash antuktaram tusan chicharjarme. ");
INSERT INTO acuNT_vpl VALUES ("PR8_5","021_8_5","PRO","8","5","5","Nekachutiram, nintip ataj tusaram wakerakrumka nuimiartaram. Tura nintinchau ainautirmesha, paan nintimratniusha nekaataram. ");
INSERT INTO acuNT_vpl VALUES ("PR8_6","021_8_6","PRO","8","6","6","Wikia timiá pengker chichaman ujaktasan wakerajrume. Tura asamtai anturtuktaram. ");
INSERT INTO acuNT_vpl VALUES ("PR8_7","021_8_7","PRO","8","7","7","Wi tajarme nuke nekasaintai. Anangkartin chichamnaka arantak nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_8","021_8_8","PRO","8","8","8","Wina chichamruka mash nekas chicham ainawai. Kame, chichamruka mash wait chichamchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_9","021_8_9","PRO","8","9","9","Nintip ainau wina chichamrun antinauka mash: Nu chichamka nekasar paan ainawai, tura nekau ainausha: Nuka waitchau ainawai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_10","021_8_10","PRO","8","10","10","Tura asamtai wi nuikiartamur kuikian tura kurincha nangkamasrum wakeruktaram tajarme. ");
INSERT INTO acuNT_vpl VALUES ("PR8_11","021_8_11","PRO","8","11","11","Kame, paan nintimratniuka kaya timiá akik aina nuna nangkamasang pengkeraitai. Tura asamtai ju nungkanam aints ainau wakerina nujai metek chikichkisha atsawai tajarme. ");
INSERT INTO acuNT_vpl VALUES ("PR8_12","021_8_12","PRO","8","12","12","Wiitjai paan nintimtikiartinaka. Wikia chichakchamin ayatun, nunak titasan wakerajrume. Wikia nekatijaingkia tsaniasan pengker pujajai. Tura asan paan chicharkartin ainauka winar ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_13","021_8_13","PRO","8","13","13","Iinu Apuri Yus umirkatniuka tunau nakitamujai metekaitai. Tura asan miajuitjai tumamunka, tura pase turatniunka, tura tunau chichamnasha mash nakitajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_14","021_8_14","PRO","8","14","14","Chikich ainaun pengker chicharkartinasha, tura nuka pengkeraitai, antsu nusha nekas paseetai titincha wini wininauka paan nekaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_15","021_8_15","PRO","8","15","15","Apu ainauka paan nintimtikrartin asar, ni aintsri ainaun inarartinuitiai. Tura inakratin ainausha ni aintsri ainau umirkarti tusar, umirkatin chichaman najaninawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_16","021_8_16","PRO","8","16","16","Wijaingkia ju nungkanmaya juun ainau ni aintsri ainaun akupinawai. Tura chichaman nekamtikin ainau wijai ni aintsri ainaun inainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_17","021_8_17","PRO","8","17","17","Wina anentina nunaka wisha nunisnak aneajai. Tura wina eatinauka waitkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_18","021_8_18","PRO","8","18","18","Wikia aints ainaun kuikiartin wajasarti tusan yaingtinuitjai. Tura chikich aints ainauncha iniararti tusan pengker awajsartinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_19","021_8_19","PRO","8","19","19","Wikia aints ainaun suaja nuka kurin nangkamasang tura kuikian nangkamasang timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_20","021_8_20","PRO","8","20","20","Wina jintarka tupin asamtai, aints ainau nu jintan amakar, nuni wekajinau asar, nuka chikich aints ainaunka pengker awajsartas wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_21","021_8_21","PRO","8","21","21","Tura wina anentina nuka kuikiartin wajasarti tusan tsangkatkatnuitjai, tusa Yus turamji ");
INSERT INTO acuNT_vpl VALUES ("PR8_22","021_8_22","PRO","8","22","22","Apu Yus nu nangkamtaik nungkan najantsuk wina najatamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR8_23","021_8_23","PRO","8","23","23","Tura nungkanka najantsuk nekamtikin ata tusa eemak inaitukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR8_24","021_8_24","PRO","8","24","24","Tura juun entsa, nunia, mash entsa ainausha atsuinai, wikia tuke pujuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_25","021_8_25","PRO","8","25","25","Tura mura ainauncha najantsuk Yuska wina najatamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR8_26","021_8_26","PRO","8","26","26","Tura nungkancha tura ajancha, tura nungka tsetserin najantsuk wina najatamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR8_27","021_8_27","PRO","8","27","27","Yus nayaimpin najanamtai, juun entsa yakinini wikia nijai pujuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_28","021_8_28","PRO","8","28","28","Tura yurangmincha mukuntiuncha najanak, juun entsa nekas kuna aina nuna najanamurincha wainak. ");
INSERT INTO acuNT_vpl VALUES ("PR8_29","021_8_29","PRO","8","29","29","Tura Yuus chichaak: Entsa nungkan amuru kuyuati tura mujurti tusa, tura juun entsa nujangkruashti tusa, nungka esantiri tura wangkantirisha nekapmarmia nuni ");
INSERT INTO acuNT_vpl VALUES ("PR8_30","021_8_30","PRO","8","30","30","wisha ni chichamen antinuyajai. Tura kintiajai metek nuna mash wainkan, nijai tsaniasan pujau asan wararnuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_31","021_8_31","PRO","8","31","31","Yus nungkan mash najanau asa, aintsun najanau asamtai, nukap warasan pengker nintimnuyajai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_32","021_8_32","PRO","8","32","32","Tura asamtai uchitiram, yamaikia anturtuktaram. Wi tajarme nu umiakrumka warastinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PR8_33","021_8_33","PRO","8","33","33","Wi unuiniarjarme nuka antukrum nintip wajasrum, nakitsuk umirtuktaram. ");
INSERT INTO acuNT_vpl VALUES ("PR8_34","021_8_34","PRO","8","34","34","Aints wina anturtuk kintiajai metek wina jearun jea nakawa nuka nekas warastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_35","021_8_35","PRO","8","35","35","Tura, aints paan nintimratniurin eakka, tuke iwiaaku pujustinasha eawai. Tura asamtai Apu Yus niin pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR8_36","021_8_36","PRO","8","36","36","Antsu aints wina eatsuk tuntupea nuka ningki wiasmamkatnuitai. Tura, wina nakitrina nuka mash tuke jakatniunam wetasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_1","021_9_1","PRO","9","1","1","Paan nintimratniuka aints jean jeamin siete painin charuk nujai ni jeen jeamua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_2","021_9_2","PRO","9","2","2","Tura nu aintska nuna mash umis, kuntinu namangken inara, tura umutirincha najana, misanam keemsatniuncha umisi. ");
INSERT INTO acuNT_vpl VALUES ("PR9_3","021_9_3","PRO","9","3","4","Tura nuna mash umik, ni inatirin akupak: Yakta yakiinini mura wakaram, natsa nintimchau ainau untsukrum: Wini winiram jea wayataram. ");
INSERT INTO acuNT_vpl VALUES ("PR9_5","021_9_5","PRO","9","5","5","Wina yutair yuwamniuram, tura umutir wi najanaja nu umurmintrum tusan untsuajrume. ");
INSERT INTO acuNT_vpl VALUES ("PR9_6","021_9_6","PRO","9","6","6","Nintimchau pujut inaisaram, nekau aints wajastasrum pengker nintimsaram pujustaram, tawai titaram timiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR9_7","021_9_7","PRO","9","7","7","Aints wishikiartiniun nunia pase aintsun chicharkartas wakerinauka, aya ningki katsekrukti turasha pajaki airkar pasenasha chichakarti tusar turinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_8","021_9_8","PRO","9","8","8","Aints pase chichamtiniun chicharkatasam wakerakmeka, wina kajertukti tusam nuka turame. Antsu pengker nintintiniun chicharinamtaikia, niisha pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_9","021_9_9","PRO","9","9","9","Aints pengker nintiniun nuininamtaikia, nuka nuna nangkamas pengker nintimratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_10","021_9_10","PRO","9","10","10","Paan nintimin ataj takurkia, iinu Apuri Yus miatrusrik umirkatnuitji. Yus nekas tunaarinchau asamtai, timiá pengkeraitai tu nintimtakrikia, nekasar nekau aints artinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR9_11","021_9_11","PRO","9","11","11","Aints paan nintimniuka untsuri musaach iwiaaku pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_12","021_9_12","PRO","9","12","12","Aints paan nintimin wajasamtaikia, ni paan nintimtairi niin yaingtinuitai. Antsu wishiikiartin ningki wakerak wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_13","021_9_13","PRO","9","13","13","Aints nintimchau ainauka nuwa aujmakratinua nunisarang, tura nuwa nintinchawa nunisarang, turasha nuwa nekachua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_14","021_9_14","PRO","9","14","14","Nu nuwaka yakta yakiinini jea aarin keemtainam keemas, jiimiaj pujuwitai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_15","021_9_15","PRO","9","15","15","Tura aishmang tupin jintanam nangkaminaunka untsuk: ");
INSERT INTO acuNT_vpl VALUES ("PR9_16","021_9_16","PRO","9","16","16","Natsa nintinchau ainautiram, juni winiram wayaataram tusa, nintimchau ainaun untsuawai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_17","021_9_17","PRO","9","17","17","Yumi kasamkamuka nekas timiá yuminuitai. Tura yutai uukmau yuatniuka timiá pengkeraitai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR9_18","021_9_18","PRO","9","18","18","Tura ipiakratamun anturina nuka: Nu nuwaka jakau matsamtainum jukartinuitai, tusarka pengké nekainatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR10_1","021_10_1","PRO","10","1","1","Uchi pengkerka aparin waramtikui. Antsu uchi nintinchauka nukurin wake mesemtikui. ");
INSERT INTO acuNT_vpl VALUES ("PR10_2","021_10_2","PRO","10","2","2","Aints chikich aintsun anangka kuikiarin achiawa nuka waraschatnuitai. Antsu anangmichu ainauka tuke jakatniunmaya uwemrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_3","021_10_3","PRO","10","3","3","Apu Yus pengker nintinniunka tsukajai wait wajakti tusangka tsangkatkashtinuitai. Turasha pase nintiniuka ni wakeramurinak najanati tusa suritkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_4","021_10_4","PRO","10","4","4","Naki aints takatan nakitakka kuikiartichu wajastinuitai. Antsu nakichuka nukap takakmawa nuka ni takatrijai kuikian achiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_5","021_10_5","PRO","10","5","5","Aints nintip esat aing ajan takakmak pujakka ni araamurin ukunam juuktinuitai. Antsu chikich aints esati ni araamuri tsamak yanchuk juukmin aing, tsawai kanú tepa nuka natsanpiakuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_6","021_10_6","PRO","10","6","6","Aints pengker nintiniun Yus ni pengkerin susatnuitai. Antsu pase aints tuke maanitan wakerau asa wait wajastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_7","021_10_7","PRO","10","7","7","Aints pengkeran turina nuna turamurin pachisar chikich aints ainau kajinmatsuk chichau ainawai. Antsu pase aintsu naarin pachisar chikich aints ainauka namang kaurua nunisarang kajinmaktasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_8","021_10_8","PRO","10","8","8","Aints paan nintimua nuka chikicha akupamurin umirkatnuitai. Antsu aints nintinchau nangkami chichaa nuka itiurkachminnum jeatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_9","021_10_9","PRO","10","9","9","Aints tumaashmiatsuk pujauka chikich ainaun shamtsuk: Akirkata turutiarti tusangka pujatsui. Antsu aints pase nintimias pujauka wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_10","021_10_10","PRO","10","10","10","Aints pase nintimias mitsuma nuka chikich ainaun pase nintimtikratnuitai. Tura aints nangkami chichaa nuka itiurkachminnum jeatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_11","021_10_11","PRO","10","11","11","Aints pengker chichaa nuka entsa pukuni tuke pujutan sukartinua tumawaitai. Antsu aints pase chichaa nuka maaniatniun jukitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_12","021_10_12","PRO","10","12","12","Aints chikich aintsun kajerak pujauka maanitan wakerawai. Antsu aints chikich ainaun aneakka, chikicha tunaari untsuri au wainiat tsangkurui. ");
INSERT INTO acuNT_vpl VALUES ("PR10_13","021_10_13","PRO","10","13","13","Aints paan nintimua nuka pengker nintimias chichastinuitai. Antsu aints paan nintimtsuk pujuinaunka nintimrarti tusar awatrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_14","021_10_14","PRO","10","14","14","Aints paan nintimina nuka nekau aints ainawai. Antsu aints nintimchau chichaina nuka itiurkachminnum jeartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_15","021_10_15","PRO","10","15","15","Kuikiartin ainauka ni kuikiarijai ayamrumakartinuitai. Tura kuikiartichu ainauka itiurkachminum jear yamrumichu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_16","021_10_16","PRO","10","16","16","Aints tunaun takachu ainauka tuke iwiaaku pujusartin ainawai. Antsu tunaun takau ainauka ni tunau takasmaurijai metek wait wajakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_17","021_10_17","PRO","10","17","17","Aints chikich aintsun chicharkam, nekas pengker antukka jinta tuke iwiaaku pujustinnum jeatnuitai. Antsu chikich aints chikich aintsun chicharkamsha, pengké antichua nuka jinta mengkakatniunam wetinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_18","021_10_18","PRO","10","18","18","Waitrin ainauka nintijai kajeenayat, ni jangkejai pengker chichau ainawai. Tura chikich ainaun nangkamiar tsanurmina nuka nintimchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_19","021_10_19","PRO","10","19","19","Aints nukap chichauka nukap nuwaktinuitai. Antsu aints paan nintimias pujauka jumchik chichastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_20","021_10_20","PRO","10","20","20","Pengker nintiniu chichamengka kuikian nangkamasang pengkeraitai. Antsu pase aints ainau nintimina nuka pengké nangkamiar nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_21","021_10_21","PRO","10","21","21","Pengker nintintin ainauka untsuri aintsun nuininawai. Antsu nintinchau ainauka paanka nintimtsuk pujuinau asar, jakatniunam weenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_22","021_10_22","PRO","10","22","22","Apu Yus ni pengkerijai aints ainaun nekas pengker awajsatnuitai. Tura wake mesekmaunka susashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_23","021_10_23","PRO","10","23","23","Aints nintimchauka pase takatan takaakka waraawai. Tura aints paan nintiniuka ni nekaamurijai warastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_24","021_10_24","PRO","10","24","24","Sapij aints ainauka tuke sapijmiakar pujuinau asar, sapijjai wait wajakartinuitai. Antsu tunaun takachu ainaun Yus ni wakerina nunaka susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_25","021_10_25","PRO","10","25","25","Katurang wári nangkaamawa nunisang pase aints ainau wári mengkainawai. Antsu Yusen umirin ainauka tuke pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_26","021_10_26","PRO","10","26","26","Aints nakia nuka akupkamaitiat wetan nakitau asa, churinun apawa nunisketai. Tura ji mukuntiuri jiinam engkema najamniua nunisang niin akupniuka itit nintimui. ");
INSERT INTO acuNT_vpl VALUES ("PR10_27","021_10_27","PRO","10","27","27","Yusen umirin ainauka untsuri musach pujusartin ainawai. Antsu pase aints ainau musaach nukapka pujuschartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_28","021_10_28","PRO","10","28","28","Pengker nintimin ainauka tuke warasar pujustiniun nakainawai. Tura pase aints ainauka ni wakerina nunaka nangkamiar nakasar wait wajaktinnum weartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_29","021_10_29","PRO","10","29","29","Apu Yus pengkeran turinaunka ayamruktinuitai, antsu pasen turinaunka mengkaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_30","021_10_30","PRO","10","30","30","Yusen nintimsar pujuinauka mengkakachartin ainawai. Antsu pase ainauka ni nungkarin tuke pujuschartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_31","021_10_31","PRO","10","31","31","Yusen nintimsar pujuinauka tuke paan nintimsar chichainawai. Tura pase nintintin ainau tuke pase chichainau asaramtai, chikich aints ainau inajin charinawa nunisarang itiatkataram tusar, ni chichamen antutan nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR10_32","021_10_32","PRO","10","32","32","Yusen nintimsar pujuinauka antujamniaun chichainawai. Tura pase nintitin ainauka aya pase chichamnak chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_1","021_11_1","PRO","11","1","1","Meram nekapmatai ainau metekchau arti tusangka Apu Yuska nakitawai. Antsu tuke metek arti tusa wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_2","021_11_2","PRO","11","2","2","Wikia miajuitjai tumamin ainaun chikich aints ainau nakitinawai. Tura jampechu ainauka paan nintimrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_3","021_11_3","PRO","11","3","3","Aints pengker nintimsar pujuinauka ni turinamurinka tuke pengker nintimsar turinawai. Antsu jimiar nintimtin ainauka jimiaran nintimu asaramtai, mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_4","021_11_4","PRO","11","4","4","Yus mash aints ainau takatrin tura nintimaurincha itiur ainawa tusa jiistin kintia jeamtai, nu aintsu kuikiaringkia niin pengké yaingchatnuitai. Antsu Yusen nintimsar pujuinauka tuke jakatniunam wetsuk uwemrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_5","021_11_5","PRO","11","5","5","Tunau takachu ainauka pengker nintimu asar, jinta tupin aa nuni wekaasartin ainawai. Antsu tunau takau ainauka ni tunaarijai iyainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_6","021_11_6","PRO","11","6","6","Aints Yusen nintimsar pujuinauka tu nintimu asar, angkanmamtikiatin ainawai. Antsu anangkartin ainauka ni pase wakeramurijai ejatkanam achikmawa nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_7","021_11_7","PRO","11","7","7","Aints Yusen nintimtichu jakamtai, ni wakeramuri mash amukaru asaramtai, jakausha ¿warinak nakasat? ");
INSERT INTO acuNT_vpl VALUES ("PR11_8","021_11_8","PRO","11","8","8","Yusen nintimsar pujuinauka kuntuchu pujuinamtai, Yus niin angkan awajsartinuitai. Tura Yusen nintimtichu ainauka kuntuchu pujusar wait wajaktinnum weartiniutai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_9","021_11_9","PRO","11","9","9","Pase aints ni tunau chichaamurijai chikich aints ainaun meseawai. Tura pengker nintitin ni nekaamurijai chikich aints ainaun angkanmamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_10","021_11_10","PRO","11","10","10","Pengker nintintin ainau takatrijai emtikiar pengker wajainamtai, nu yaktanam pujuinauka warainawai. Antsu pase aints ainau jainamtaikia, aints mash warainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_11","021_11_11","PRO","11","11","11","Pengker nintintin ainau yayamujai aints ainau yaktan eemtikin ainawai. Antsu pase aints ainau ni pase chichaamurijai nu yaktanka mesen ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_12","021_11_12","PRO","11","12","12","Aints nintimchauka ni irutkamurin pachis pase chichaayi. Tura pengker nintiniuka chichatsuk pujuuyi. ");
INSERT INTO acuNT_vpl VALUES ("PR11_13","021_11_13","PRO","11","13","13","Aints aujmakratin ainau chichaman jukiar, etserkaip tinamaitiat, pachitsuk etserkini wekain ainawai. Antsu aujmakartichau ainauka chichaman antukariat etserchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_14","021_11_14","PRO","11","14","14","Aintsu apuri ni aintsrin tu pujustaram tutsuk pujamtai, nu yaktanmangka itiurkachmin nukap atinuitai. Antsu chicharkartin nintip untsuri pujusar, ni yaktarin emtikiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_15","021_11_15","PRO","11","15","15","Aints wainchatai chikich aintsun chicharak: Wikia tumaashitjai. Antsu akiimiakchamin asamtai, wina tumaashruka akiimiaktrukta, ukunam akikmijinam tamataikia, ni ayu tinu asa, nekas itit nintimtuminiutia. Antsu chikich aints: Atsa, turashtatjai tusa nakitnua nuka itit nintimtsuk angkan pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_16","021_11_16","PRO","11","16","16","Tsangka nuwanka pengker nintimtusmin ainawai. Tura aintsun takamtikin ainauka kuikian nukap achiinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_17","021_11_17","PRO","11","17","17","Aints wait anengkratnuka ningki pengker awajmamui. Antsu aints wait anengkratchauka ningki timiá pase awajmamui. ");
INSERT INTO acuNT_vpl VALUES ("PR11_18","021_11_18","PRO","11","18","18","Aints anangkartin asa, chikich ainaun anangkak kuikian achiawai. Antsu pengke aints pengkeran takaawa nuka ukunam tuke pengker pujustinasha jukitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_19","021_11_19","PRO","11","19","19","Aints pengker nintitin ainauka tuke iwiaaku pujusartin ainawai. Antsu tuke pase turuki turuki weenauka tuke jakatniunam jeartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_20","021_11_20","PRO","11","20","20","Apu Yus pase nintintin ainaun nakitawai. Antsu tunaarinchau ainaun jiis waraawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_21","021_11_21","PRO","11","21","21","Pase aints ainauka nekasar ni wait wajaktintrin jukiartin ainawai. Antsu pengker nintintin ainauka angkan pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_22","021_11_22","PRO","11","22","22","Nuwa shiirmawach ayat, nintinchau pujakka, uwejnum uwejtai kuri najanamun kuchi nujin nujkamua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_23","021_11_23","PRO","11","23","23","Aints pengker nintintiniu wakeramuri tuke pengker artinuitai. Antsu pase aints ainau ni wakeramurijai tuke suwiran sumamtikinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_24","021_11_24","PRO","11","24","24","Aints surichu ni waririn suritsuk chikich aints ainaun suinayat, ni waririn nuna nangkamasarang untsurin jukiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_25","021_11_25","PRO","11","25","25","Aints surichu kuikiartin wajastinuitai. Tura aints chikichan ni yuumamurin sua nusha ni yuumamurincha tuke wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_26","021_11_26","PRO","11","26","26","Aints trigon uuk ukuawa nunaka usukrartin ainawai. Antsu aints ainau: Wait aneasam sumamtikrukta tinamtai, suritsuk surawa nu aintsnaka: Yus yainmakti tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_27","021_11_27","PRO","11","27","27","Aints pengkeran turataj tusa tu nintimias pujaunka pachisar: Nuka nekas pengkeraitai tiartinuitai. Antsu aints tunaun turatas wakerakka, nekas pase pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_28","021_11_28","PRO","11","28","28","Aints kuikiartin: Wina kuikiarjai yuumatsuk pujajai tauka itiurkachminnum iyaartinuitai. Tura asa numi nukee kaarua nunisketai. Antsu pengker nintinniuka numi nukee samek aina nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_29","021_11_29","PRO","11","29","29","Aints ni jeen pujuinaun wait anentsuk pujauka ukunam ningki juwaktinuitai. Tura aints nintinchauka tuke aints paan nintimniu inatiri atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_30","021_11_30","PRO","11","30","30","Pengker nintintin ainauka numi nerek wajawa nunisarang ainawai. Tura asar tuke iwiaaku pujusartinuitai. Tura chikich ainaun: Yus umirkata. Turakmeka uwemratatme tinu ainauka nekasar paan nintimsar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR11_31","021_11_31","PRO","11","31","31","Yusen umirkaru ainauka ju nungkanam ni turamurijai metek pengkeran juwinamtai, Yusen umirkacharu ainauka tunau asar, ni turamurijai metek wait wajakartiniun juinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_1","021_12_1","PRO","12","1","1","Aints nuimiartasar wakerina nuka nekaatniuncha nukap wakerinawai. Antsu aints chicharmasha antutan nakitina nuka nintinchau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_2","021_12_2","PRO","12","2","2","Pengkeran turina nunaka Apu Yuska: Ame turame nuka pengkeraitai tawai. Antsu anangkartinun: Ame turame nuka paseetai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_3","021_12_3","PRO","12","3","3","Aints tunaun takaina nuka tuke iwiaaku pujuschartin ainawai. Antsu pengker nintintin ainauka numi kangkaptuk uwerchamin wajaina nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_4","021_12_4","PRO","12","4","4","Pengker nuwaka aishrin pengker awajui. Antsu nuwa paseka aishri kunchin kaamtikua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_5","021_12_5","PRO","12","5","5","Aints pengker nintintin ainauka tuke pengkeran nintiminawai. Antsu pase aints ainauka chikich ainaun anangkataj tusar nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_6","021_12_6","PRO","12","6","6","Pase aints ainauka: Itiurkanak aintsun maatnuitja tu nintimsar chichainawai. Antsu pengke aints ainau ni chichamejaingkia aints ainaun uwemtikratasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_7","021_12_7","PRO","12","7","7","Pase aints ainau tuke tunaun nintimin asar, mengkakartin ainawai. Antsu Yusen nintimsar pujuinauka tuke pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_8","021_12_8","PRO","12","8","8","Aints paan nintimratniunka ni nekamurijai metek pengker awajsartin ainawai. Antsu nintimchau ainaunka aya tuke nakitin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_9","021_12_9","PRO","12","9","9","Aints chikich aintsun pachis mianchawaitai tu nintimsar pujuinau wainiat, nu aintsu inatiri niin pengker umirmataikia, nekas pengker pujawai. Tura chikich aints miajuitjai tumamua nuka yutan yuumak pujakka nekas mianchawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_10","021_12_10","PRO","12","10","10","Pengker nintintin ni tangkuri warínia yuumina nunaka nekawai. Antsu pase aints tangkurin pengké wait anentsuk pase awajui. ");
INSERT INTO acuNT_vpl VALUES ("PR12_11","021_12_11","PRO","12","11","11","Aints ni ajarin pengker takakmak pujauka yurumkan nukap takakui. Antsu aints nintimchauka ajarin takakmatsuk aya nangkami wekaakinij wajawitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_12","021_12_12","PRO","12","12","12","Pase aints ainau ejatkanam achikmawa nunisarang pasenak turatasar wakerinawai. Antsu pengker nintintin ainau turamuringkia numi nerektinua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_13","021_12_13","PRO","12","13","13","Pase aints ainauka wait chicham ainaujaingkia jingkiamua nunisarang ainawai. Antsu pengker nintintin ainauka itiurkachminumian jiinkiar angkan pujusartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_14","021_12_14","PRO","12","14","14","Aints ni pengker chichaamurijai metek pengker aina nuna jukitnuitiai. Turasha ni takaamurijai metek, tura ni yuumamurijai metek waring achat mash jukitnuitiai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_15","021_12_15","PRO","12","15","15","Aints nintimchauka ningki nintimias: Wi turaja nuka mash pengkeraitai tu nintimui. Tura aints paan nintimuka chikich aintsu chicharkartamurin anturui. ");
INSERT INTO acuNT_vpl VALUES ("PR12_16","021_12_16","PRO","12","16","16","Aints nintimchau te wári kajektinuitai. Antsu aints pengker nintimtikiartinka chikich aints niin katsekeamtaikia: Ningki titi tusa pachiatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR12_17","021_12_17","PRO","12","17","17","Aints tuke nekas chichaman etserniuka pachitsuk nekas chichaman etserniayi. Antsu chikich aints wait chichaman etserin asa, tuke wait chichaman etserniayi. ");
INSERT INTO acuNT_vpl VALUES ("PR12_18","021_12_18","PRO","12","18","18","Aints wait chichaman chichaa nuka chikich ainaun nangkijai ijuawa nunisang waitkatnuitai. Antsu paan nintimtikiartinu chichamengka tsuakan nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_19","021_12_19","PRO","12","19","19","Aints nekas chichaman chichaa nuka tuke pujustinuitai. Tura waitrin ainauka nukapka pujuschartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_20","021_12_20","PRO","12","20","20","Pase nintintin ainauka tuke chikich ainaun anangkinawai. Antsu maanichu ainauka pengker nintimsar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_21","021_12_21","PRO","12","21","21","Pengker nintintin ainauka pasenaka wainkachartin ainawai. Antsu pase aints ainauka tuke itiurkachminnum pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_22","021_12_22","PRO","12","22","22","Apu Yus waitrin ainaun kajerawai. Antsu tuke nekas aa nuna nintimsar pujuina nunaka jiis waraawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_23","021_12_23","PRO","12","23","23","Aints ainau iniinam, nintipka ni nekamurin etserniayi. Tura aints nintimchawa nuka iniinachmaitiatang pachitsuk nangkami chichaawitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_24","021_12_24","PRO","12","24","24","Aints kakaram takakminak pujuinauka chikich aints ainaun nepetkartin ainawai. Antsu naki ainauka chikich aintsu inatiri wajasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_25","021_12_25","PRO","12","25","25","Aints napchau nintimias pujakka jakamin nekapeawai. Tura pengker nintintin ainauka antujamniaun chichainau asar, chikich ainaun waramtikinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_26","021_12_26","PRO","12","26","26","Pengker nintintin ainauka chikich ainaun jintintiamin ainawai. Antsu pase aints ainau waaktin jintan amainau asar mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_27","021_12_27","PRO","12","27","27","Aints nakia nuka kuntinun maa itayat iniaratniunka nakitnuitai. Antsu aints asumpia nuka kakaram takakmau asa, nukap warirtin atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR12_28","021_12_28","PRO","12","28","28","Yusen umirinak pujuinauka, tuke Yusnum iwiaaku pujusartinuitai. Tura asar tuke jakatniunamka weenatsui. Antsu Yusen nintimtsuk pujuinauka tuke jakatniunam wenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_1","021_13_1","PRO","13","1","1","Uchi nintimuka ni apari chicharam antuktinuitai. Antsu wishikiartinka chikich aints chicharmasha pachiatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR13_2","021_13_2","PRO","13","2","2","Pengker chichamtin ainauka ni chichaamurijai metek pengker aa nuna wainkartin ainawai. Antsu chikich ainaun anangkinauka aya mangkartutnak nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_3","021_13_3","PRO","13","3","3","Tunau chichamnaka nakitajai tinauka pengker awajmaminawai. Antsu aints nintimtsuk nukap chichainauka, ningki mesmamrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_4","021_13_4","PRO","13","4","4","Nakia nuka aya wakeru pujuwitai. Antsu asumpia nuka takakmak pujau asa, yuumatsuk pujawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_5","021_13_5","PRO","13","5","5","Aints waitrichuka wait chichaman nakitnuitai. Tura pase aintsnaka chikich aints ainau nakitinau asaramtai, nuka natsanpiaku pujuwitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_6","021_13_6","PRO","13","6","6","Pengker nintintin pase turatniunka nakitau asa, angkan pujuwitai. Antsu pase aintsnaka ni tunaaringkia mesratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_7","021_13_7","PRO","13","7","7","Aints kuikiartichu irunuka kuikiartinua tumau pujuinawai. Tura chikich aints ainau kuikiartichua tumau pujuinayat, kuikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_8","021_13_8","PRO","13","8","8","Kuikiartinun ni kuikiari ayamruktinuitai. Tura kuikiartichu ainau kuikiari atsau asamtai, itit awajsacham pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_9","021_13_9","PRO","13","9","9","Yusen umirinauka namparing kapaawa nunisarang ainawai. Antsu pase aintska namparing keemakmaitiat wári kajinua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_10","021_13_10","PRO","13","10","10","Wikia miajuitjai tumamaina nuka aya maanitan chichau ainawai. Antsu paan nintimtikiartin ainauka chikich aintsu chichamen anturin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_11","021_13_11","PRO","13","11","11","Anangkartinu kuikiari wári mengkawai. Antsu aints tuke takakmak, kuikiarin japtsuk yaitas irumrawa nuka ukunam kuikiartin wajasminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_12","021_13_12","PRO","13","12","12","Aints ni nakamurin wári wainchakka wake mesek pujuwitai. Antsu aints ni nakamurin wankangka nukap waraawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_13","021_13_13","PRO","13","13","13","Aints chichaman umitan nakitakka, ningki wait wajaktinnun jukitnuitai. Antsu aints chichaman antuk umiakka, pengkeran wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_14","021_13_14","PRO","13","14","14","Aints pengker nintintinu nuikiartamun antuk umiakka, tuke iwiaaku pujustinun wainkatnuitai. Kame, jinta tuke jakatniunam jeatnua nuna amatsuk angkan wekasatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_15","021_13_15","PRO","13","15","15","Aints chikich aintsjai pengker chichasar pujuinauka mai metek pengker nintimtunisar pujuinawai. Antsu anangkartin ainauka itiurkachminnum wenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_16","021_13_16","PRO","13","16","16","Nintipka ni nekaamurijai takakmawai. Antsu aints nintinchauka ni nintimchau takaamurin paan wainmamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PR13_17","021_13_17","PRO","13","17","17","Pase aints chicham akupkamun tenap etserchauka itiurkachminnum jeatnuitai. Antsu chichaman umiuka chicham akupkamun tenap etseruka chikich ainaun pengker nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_18","021_13_18","PRO","13","18","18","Aints chicharmasha antichuka kuikiartichu asa, natsanpiaku pujuwitai. Antsu chikich aints chicharkam antukamtikia, aints ainauka: Nekas pengker aintsuitai tusar nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_19","021_13_19","PRO","13","19","19","Aints ningki nintimias: Nuna turatasan wakerajai tusa, nuna mash umik warastinuitai. Tura nintimchau ainauka ni pase turutirin inaitan arantak nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_20","021_13_20","PRO","13","20","20","Aints nekau ainaujai tsanias pujauka nekau aints wajastinuitai. Antsu netse ainaujai tsanias puja nuka wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_21","021_13_21","PRO","13","21","21","Tunaarintin ainauka pase pujusartin ainawai. Antsu Yusen umirkaru ainauka pengker pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_22","021_13_22","PRO","13","22","22","Aints Yusen umirin jakauka, wariri ainaun ni tirangki jukiarti tusa ukuktinuitai. Tura pase aints kuikiartin jakauka, wariri ainaun chichaman umiu jukiarti tusa ukuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_23","021_13_23","PRO","13","23","23","Kuikiartichu ajarin árak ainau untsuri tsapainawai. Antsu tunau nekamin atsau asamtai, kuikiarin pachitsuk atankiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_24","021_13_24","PRO","13","24","24","Aints ni uchirin chichartsuk pujakka, uchirin aneatsui. Antsu uchirin aneakka, pengker pujusti tusa chicharkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR13_25","021_13_25","PRO","13","25","25","Aints tunaun turachuka ni yutairin wakerak pachitsuk yuawai. Antsu pase nintiniuka ni yutairin tunau nintimias yuak tutuarchamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_1","021_14_1","PRO","14","1","1","Nuwa pengker nintimtikiartin ni weari ainaun kiakartinuitai. Antsu nuwa nintinchauka ni wearinka kiakaatsuk aya mesertinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_2","021_14_2","PRO","14","2","2","Aints tunaun nakitakka Apu Yusen pengker awajui. Antsu aints tunau jintan amak wekaa nuka Yusnasha pengkerka awajtsui. ");
INSERT INTO acuNT_vpl VALUES ("PR14_3","021_14_3","PRO","14","3","3","Aints netse: Miajuitjai tumamui. Tura paan nintimtikiartin ainauka ni chichamejaingkia chikich ainaun ayamrumakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_4","021_14_4","PRO","14","4","4","Jacha atsamtaikia, yurumak atsutnuitai. Antsu jacha amatikia, yurumak nukap awai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_5","021_14_5","PRO","14","5","5","Aints waitrichuka nekas aa nunak chichaawai. Antsu waitrinka aya tuke waitan etserniayi. ");
INSERT INTO acuNT_vpl VALUES ("PR14_6","021_14_6","PRO","14","6","6","Wishiikiartinka: Wikia nekau aints ataj tayat, nekau aints wajastatkama tujintawai. Antsu nintipka: Wikia nekau aints ataj ta nuka kakarmachu nekau aints wajastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_7","021_14_7","PRO","14","7","7","Aints nintimchau nekatiri atsau asamtai, nijai tsaningkiam pujakmeka, nekau aintska wajaschatnuitme. Tura asamtai nijai tsaningkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR14_8","021_14_8","PRO","14","8","8","Aints paan nintimnuka: ¿Wikia itiur pujaja? tusa paan nintimratnuitai. Antsu aints nintimchauka nintimchau ayat: Wikia nintipitjai tusa anangmamui. ");
INSERT INTO acuNT_vpl VALUES ("PR14_9","021_14_9","PRO","14","9","9","Netse ainauka ni tunaarin pachisar wishikinawai. Tura anangmichu ainauka mai nuamtak pengker nintimtunisar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_10","021_14_10","PRO","14","10","10","Aints napchau nintimias pujakka, ningki ¿waruka tu pujaja? tusa nekamawai. Kame, ni waraakka aints wainchati ¿waruka timiá waraawa? tusangka nekaachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_11","021_14_11","PRO","14","11","11","Pase aintsu jee wári mesertinuitai. Tura anangmichu kuikiari jumchik ayat, anangtsuk irumramu asamtai, yaitas ekemkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_12","021_14_12","PRO","14","12","12","Yusen umirkacharu ainau ningki nintimsar: Ju jintan wekaaknaka nekasan tupnik jeatatjai tu nintiminayat, nu jintaka jakatniunam jeakui tusarka nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR14_13","021_14_13","PRO","14","13","13","Aintsu ninti najaimiayat, nangkami wishirtinuitai. Turasha aints ainau yamai warainayat, ukunam juutiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_14","021_14_14","PRO","14","14","14","Netse aints ainauka ni turamurijai metek wait wajakartinuitai. Tura pengke aints ainauka ni turamurijai metek warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_15","021_14_15","PRO","14","15","15","Aints uchia nunisang nintimuka ni antukma nunaka mash nekasaintai tawai. Antsu nintipka: ¿Wikia tuning wekasataj? tusa nintimias wekasatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_16","021_14_16","PRO","14","16","16","Aints paan nintimtin: Wikia tunaunaka nakitajai tusa, Yusen umirak pujawai. Antsu netseka: Wi wakeramurnaka pachitsuk turamnawaitjai tu nintimtumas, chikich ainaunka pengké pachiatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR14_17","021_14_17","PRO","14","17","17","Aints wári kajeakka paanka nintimtsuk pujuwitai. Turasha pase aints ainaunka nakitrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_18","021_14_18","PRO","14","18","18","Aints nintimchau ainauka netse aints ainau turina nunasha turinawai. Tura nintip ainauka ni nekaina nuna nangkamasarang nukap nekaatasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_19","021_14_19","PRO","14","19","19","Yusen nintimtichu ainauka ukunam pengke aints wajainamunam tsuntsumruawartinuitai. Tura pase ainau Yusen umirkaru jeen jear, waitinam tsuntsumruawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_20","021_14_20","PRO","14","20","20","Aints kuikiartichun ni irutkamuri ainau jiitnaka nakitinawai. Antsu kuikiartinu amikri untsuri ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_21","021_14_21","PRO","14","21","21","Aints ni irutkamurin nakitakka tunaun turawai. Antsu kuikiartichu ainaun wait anenta nunaka Yus waramtiksatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_22","021_14_22","PRO","14","22","22","Aints: Wi paseen turatjai, tu nintiminauka nekasar mengkakartin ainawai. Antsu: Wi pengkeran turatjai, tu nintiminaunka wait anentrartin tura pengker awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_23","021_14_23","PRO","14","23","23","Kakaram takakmin ainauka pengkeran wainkartin ainawai. Aya chichaa pujuinauka kuikiartichu wajasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_24","021_14_24","PRO","14","24","24","Aints paan nintimsar pujuinauka tawaaspan tsengkrakina nunisarang wajainawai. Antsu nintimchau ainauka tuke nintimchau asar, tu jakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_25","021_14_25","PRO","14","25","25","Aints waitrichuka chikich aints ainaun angkanmamtikratnuitai. Antsu aints anangkartinka tuke wait chichaman etserniayi. ");
INSERT INTO acuNT_vpl VALUES ("PR14_26","021_14_26","PRO","14","26","26","Apu Yusen umirkaru ainauka niin pengker awajsartin asaramtai, ni uchiri ainausha nuna wainkau asar, nu nintimaurijai tuke sapijmiatsuk matsamsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_27","021_14_27","PRO","14","27","27","Apu Yusen umirkaru ainauka tuke pujusartin ainawai. Kame, aints ainau tuke sapijmiakar jingkiamua nunisarang jakatniunam weenawa nuka tuuka pujutsuk, angkanmawaru ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_28","021_14_28","PRO","14","28","28","Apu inamurin aints untsuri pujuinamtaikia, apuka pengker nintimias pujustinuitai. Antsu aints jumchik iruninamtaikia, ni inamuri mengkakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_29","021_14_29","PRO","14","29","29","Aints wári kajechunka wainkar, chikich aints ainau: Nuka nekas nekau aintsuitai tinawai. Antsu aints tewari kajeuka ni netse nintaimtairin paan inakmawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_30","021_14_30","PRO","14","30","30","Angkan pengker nintimias nekapratniuka aintsu namangken pengkermamtikui. Antsu aints chikichnaun waring achat wakerak puja nuka ni namangken, tura ukunchincha pasemamtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_31","021_14_31","PRO","14","31","31","Aints kuikiartichun wait anentsuk puja nuka mash aintstin najatmamia nuna pengkerka awajtsui. Antsu aints kuikiartichun wait anentak pengker awajuka Yusnasha pengker awajui. ");
INSERT INTO acuNT_vpl VALUES ("PR14_32","021_14_32","PRO","14","32","32","Pase aints ainaun ni tunaari mesratnuitai. Tura Yusen umirkaru ainau jakatin kintiari jeamtai, Nekasan Yusnumapi pujustinuitjai tusar pengker nintimsar jakartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_33","021_14_33","PRO","14","33","33","Aints paan nintimias puja nuna nintin nekati pujurui. Tura nintimchau ainau nintinka nekati pengké atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_34","021_14_34","PRO","14","34","34","Aints pengker nintintin ainauka nekasar ni nungkarin eemtikiatin ainawai. Antsu aints ainau tunaun turina nuka natsanpiaku ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR14_35","021_14_35","PRO","14","35","35","Apu inatiri pengker umiuka ni apurin pengker nintimtikui. Tura inatiri natsanpiaku turamtaikia, apuri niin kajerkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_1","021_15_1","PRO","15","1","1","Chicham kakaram atsamtaikia, kajeamuka mengkakatnuitai. Antsu pajaki aimkamu amataikia, pajaki aimkamuka nuka nuna nangkamasang kajektinka nukap jurumaji. ");
INSERT INTO acuNT_vpl VALUES ("PR15_2","021_15_2","PRO","15","2","2","Aints paan nintimias puja nuka nekau aintsu chichameng chichaawai. Tura aints nintinchawa nuka nintinchau chichaawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_3","021_15_3","PRO","15","3","3","Apu Yus mash nungkanmaya pase aints ainaun tura pengker aints ainauncha jiij pujurui. ");
INSERT INTO acuNT_vpl VALUES ("PR15_4","021_15_4","PRO","15","4","4","Aints pengker chichaawa nuka numi sameka nunisketai. Tura tsuakan nunisang asa, jau ainaun pengker awajsatnuitai. Antsu anangkartinua chichamengka aintsu wakanin mesratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_5","021_15_5","PRO","15","5","5","Uchi netse apari chichamen antutan nakitawai. Antsu chikich uchi ni apari chichamen pengker antuk umirua nuka nekas nintipitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_6","021_15_6","PRO","15","6","6","Aints anangkartichu jeenka warinchuka untsuri irunui. Antsu pase aintska ni kuikiarin nangkami ajapui. ");
INSERT INTO acuNT_vpl VALUES ("PR15_7","021_15_7","PRO","15","7","7","Aints paan nintimuka ni pengker nekamurin chikich aints ainaun nekamtikiatnuitai. Antsu aints nintimchau pengker nekamuri atsau asamtai, chikich aints ainaun nekamtikiatatkama tujintawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_8","021_15_8","PRO","15","8","8","Apu Yus pase aints ainau ni tangkurin maawar surusarti tusangka wakeratsui. Antsu niin umirkaru ainau seamurin antuktas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_9","021_15_9","PRO","15","9","9","Apu Yus pase aints ainau turutirin jiitnasha nakitawai, antsu tunaarinchau pujusartas wakerinaun aneawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_10","021_15_10","PRO","15","10","10","Aints Yuse jintin wekaayat, nunia ukuawa nunaka Yus antukat tusa, wait wajaktiniun susatnuitai. Kame, aints Yuse chicharkartamurin nakita nuka tuke jakatniunam wetinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_11","021_15_11","PRO","15","11","11","Jakau ainau iwiarsamurin tura ni wakani matsamtairisha Apu Yus paan wainui. Tura asamtai ¿aintsu nintimtairincha itiur nekarashti? ");
INSERT INTO acuNT_vpl VALUES ("PR15_12","021_15_12","PRO","15","12","12","Aints katsekmin: Wina chichartukarti tusanka nakitajai tawai. Tura asa paan nintintin ainaujaingka tsanitian nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_13","021_15_13","PRO","15","13","13","Aints nintijai waraak pujamtaikia, chikich aints ainau yapiin jiisar: Nuka kuntu nintimias pujawai, tusar nekaawartin ainawai. Tura wake mesekar pujuinauncha nunisarang nekaawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_14","021_15_14","PRO","15","14","14","Aints paan nintimias pujauka nukap nekaatas wakerawai. Antsu nintimchau ainauka tuke nintinchau chichaman antuktasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_15","021_15_15","PRO","15","15","15","Aints kintajai metek wake mesek pujawa nuka tuke itiurkachmin nintimui. Antsu aints tuke waraak puja nuka nampernum pujawa nunisang nekapeawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_16","021_15_16","PRO","15","16","16","Aints kuikiartichu kuikian nukap takakchau ayat, Apu Yusen umirkauka pengker nintimias pujustinuitai. Antsu aints kuikiartin ayat, tuke itiurkachminnum pujus, pengker nintimias pujustatkama pengké tujintawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_17","021_15_17","PRO","15","17","17","Aints ainau yurumkanak yuwinak, kajernaitsuk aneenisar pujuinauka nekasar pengker pujuinawai. Antsu chikich aints ainau tuke namangken apatsuk yuwinayat, surimshim yuwinak kajernaikiar pujuinauka pengkerka pujuinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR15_18","021_15_18","PRO","15","18","18","Aints wári kajeuka maanitan wakerawai. Antsu aints wári kajechuka: Maanikairap tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_19","021_15_19","PRO","15","19","19","Aints nakia nuna jintingkia jangki irumramua nunisang nekapeak takatan nakitnuitai. Antsu nakichuka paka tura wangkaram jinta nunisang takatrin nekapeawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_20","021_15_20","PRO","15","20","20","Uchi nintimniuka ni aparin waramtikui. Tura uchi nintimchauka nukurin waramtiktsui. ");
INSERT INTO acuNT_vpl VALUES ("PR15_21","021_15_21","PRO","15","21","21","Aints nintinchauka ni nintinchau turamurin nintimias wararsatnuitai. Tura nintipkia ningki nintimias: ¿Itiur pujaja? tusa pase turamuri amataikia, nuna inaisatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_22","021_15_22","PRO","15","22","22","Jintinkartin atsamtaikia, aints ainau ni turatniurin umiktasar wakerina nunaka umikchartinuitai. Antsu jintinkartin untsuri amataikia, aints ainau ni turatniurin umikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_23","021_15_23","PRO","15","23","23","Aints ainau inintrinamtai, nekau aints nekas pengker aimkamurin antukar warasartinuitai. Kame, aints aneachmau antujamnau chichaamtai, ¡nekas pengkerapita! timinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_24","021_15_24","PRO","15","24","24","Aints paan nintimina nuka jinta tuke yakí iwiaaku pujustinnum wekainawai. Tura asar jinta tuke jakatniunam jeatniun tuntupeawar ukuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_25","021_15_25","PRO","15","25","25","Aints jampesarang: Miajuitjai tumamina nuna jeen Apu Yus mesratnuitai. Antsu waje ajarin atankicharti tusa wainkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_26","021_15_26","PRO","15","26","26","Pase aints ainau nintaimtairingka Apu Yus nakitnuitai. Antsu aints ainau paseka nintimtsuk chichainamurin antuktas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_27","021_15_27","PRO","15","27","27","Aints nukap warirtin wajastaj tu nintimias pujauka ni weari ainaun itit awajui. Antsu chikich aintsun kuikian suak: Ame nu aints pachisam wait chicham ujakta tamaitiat, nunaka nakitajai ta nuka Yusnum pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_28","021_15_28","PRO","15","28","28","Pengker nintintin ainauka inintramun aimkartas, nuna eemak nintimratjai tusar aimtsuk wajainawai. Antsu pase aints ainau nintimtsuk aya pase chichamnak chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_29","021_15_29","PRO","15","29","29","Apu Yus niin nintimtichu ainaun tuntupeawai. Antsu niin umirkaru ainau seamurin anturui. ");
INSERT INTO acuNT_vpl VALUES ("PR15_30","021_15_30","PRO","15","30","30","Aints pengker nintimias jiimsatnuringkia aints ainaun waramtiksartin ainawai. Turasha pengker chicham aina nuna antinaunka kiakar waramtiksartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_31","021_15_31","PRO","15","31","31","Chicharkartin iwiaaku pujustiniun chichaman chichaamtai, aints nuna anturak pachiawa nuka nekas nekau atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_32","021_15_32","PRO","15","32","32","Aints chikich aintsun nuiniartas chicharmaitiat, antutan nakitniuka ningki wiasmamkatnuitai. Antsu aints chichamtai, antuk pengker umirua nuka nekas anturnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR15_33","021_15_33","PRO","15","33","33","Nekau aints wajastasar wakerinauka Yusen pengker awajsatniunka nuiminawai. Turasha: Wina pengker awajtursarti tinu ainauka eemkar: Wikia mianchawaitjai tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_1","021_16_1","PRO","16","1","1","Aints ainautikia: Nunaka turatatjai tarining, Yuska aintsu turatniuri tu ati tusa ningki tsangkatkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_2","021_16_2","PRO","16","2","2","Aints ningki nintimias: Wi turaja nuka mash pengkeraitai tau wainiat, ¿waruka tu nintimua? nuka Yusek nekawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_3","021_16_3","PRO","16","3","3","Waring achat mash ame turatasam wakerame nuka Yusrum ujakta. Yus wakeramtaikia, ame turatasam wakerame nunaka mash tsangkatramkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_4","021_16_4","PRO","16","4","4","Yuska mash iwiaaku ainauka wina umirtukarti tusa najankauwitai. Tura asa aints tunaun takainauka wait wajaktiniun susamij tusa umikuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_5","021_16_5","PRO","16","5","5","Aints miajuitjai tu nintimtumasar pujuinaun Yus nakitawai. Tura ni kintiari jeamtai, ni wait wajaktintrin susatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_6","021_16_6","PRO","16","6","6","Nekas Yuse wait anengkratairijai aintsu tunaari tsangkuramuitai. Tura asamtai aints Yusen umirak pujauka tunaun inaisatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_7","021_16_7","PRO","16","7","7","Aints Yusen pengker umirmatai, ni nemase ainauka nu aintsjai kajernaitsuk pujusarti tusa nintimtikrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_8","021_16_8","PRO","16","8","8","Aints ni takatrin takakmak pujus, kuikian jumchik achia nuka nekas pengker nintimias pujustinuitai. Antsu aints chikich aints ainaun anangkak kuikian nukap juwauka pengker nintimsangka pujuschatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_9","021_16_9","PRO","16","9","9","Aints ainautikia iik wakerakur: Nunaka turatatjai tarining, nuna turati ta nuka Yusketai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_10","021_16_10","PRO","16","10","10","Yus ta nujai metek aintsu apuri umiktinuitai. Tura nuna nangkamaska aintsun wait wajaktinun susashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_11","021_16_11","PRO","16","11","11","Meram nekapmatai ainau Yuska metek arti tusa wakerawai. Tura asa nekapmatai metekchau ainaunka arantak nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_12","021_16_12","PRO","16","12","12","Apu ainau ni aintsri tunaun turuwarti tusarka wakerinatsui. Antsu pengker pujusarti tusar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_13","021_16_13","PRO","16","13","13","Aints ainau nekas chichaman chichainamtai, aintsu apuri ainau warainawai. Tura asar aints ainaun wainkar: Nuka pengker aintsuitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_14","021_16_14","PRO","16","14","14","Aintsu apuri kajerak: Nu aints maataram timinuitai. Tura asamtai apu kajerkamuri atsuti tusar, nekau aints ainau yaitasar: Nuka turuwaip tusar tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_15","021_16_15","PRO","16","15","15","Aints ainau ni apuri waraamurin wainkar: Iikia jakashtatji tinawai. Tura asamtai apu pengker nintimias pujakka, yumi arakan tsakatmawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_16","021_16_16","PRO","16","16","16","Kuri akik aa nuna nangkamasang paan nintimratniuka timiá pengkeraitai. Tura kuik timiá wakerumi ayat, pengker nekatniuka nuna nangkamasang timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_17","021_16_17","PRO","16","17","17","Yusen umirkaru ainau tunaun tuntupeawartas wakerinawai. Aints tumau ainauka ni pujutri itiurak aa tusar anearar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_18","021_16_18","PRO","16","18","18","Aints: Miajuitjai ta nuka itiurkachminnum jeatnuitai. Tura meemin ainauka aneachmau tunaunum iyaarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_19","021_16_19","PRO","16","19","19","Miajuitjai tumamin ainaujai tsaningkiar kuikiartin wajasaruka pengkerka pujuinatsui. Antsu kuikiartichu ainaujai tsaningtasar wakerinauka timiá pengker pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_20","021_16_20","PRO","16","20","20","Yuse chichamen nintiminauka pengker aa nuna wainkartin ainawai. Tura Apu Yusen nintimsar pujuinauka nekasar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_21","021_16_21","PRO","16","21","21","Aints paan nintimin ainaun pachisar: Nintipitai tinawai. Tura yaitasar chichainauka aints ainaun pengker nuinin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_22","021_16_22","PRO","16","22","22","Aints paan nintimin ainauka entsa pukunia nunisarang ainawai. Antsu nintinchau ainaun pengké jintintachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_23","021_16_23","PRO","16","23","23","Aints paan nintimin antujamniaun chichau asa, chikich ainaun pengker jintintatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_24","021_16_24","PRO","16","24","24","Aints yaitas chichaa nuna chichame wapasa yumiria tumawaitai. Tura aintsu nintin kiakartin asamtai, tsuakan nunisang wakerumaintai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_25","021_16_25","PRO","16","25","25","Aints ainau ningki nintimsar: Ju jintan wekaaknaka, nekasan tupnik jeatatjai, tu nintiminayat, nu jintiaka jakatniunam jeakui tusar nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR16_26","021_16_26","PRO","16","26","26","Aintsu tsukamamuri kakaram takakmasti tusa aintsun takamtikui. ");
INSERT INTO acuNT_vpl VALUES ("PR16_27","021_16_27","PRO","16","27","27","Pase aintska tuke tunaun nintimias pujawai. Tura asa chichamesha jiya nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_28","021_16_28","PRO","16","28","28","Pase aintska aya maaniktas wakerawai. Turasha aujmakratin amikrintin ainau kajernaikiarti tusa pase nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_29","021_16_29","PRO","16","29","29","Maanin aintska ni irutkamurin pase jintan amakti tusa anangkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_30","021_16_30","PRO","16","30","30","Aints tunaun turataj tu nintimias waja nuka ni jiin mitsum mitsum wajaayi. Tura wenencha muchitu weawai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_31","021_16_31","PRO","16","31","31","Aints pengker, juuntach wajas, jempeerintin pujak, tawaspan etsengkruk pujawa nunisang pujuuyi. ");
INSERT INTO acuNT_vpl VALUES ("PR16_32","021_16_32","PRO","16","32","32","Aints wári kajechuka aints kakarma nuna nangkamasang pengkeraitai. Tura aints ni kajetirin nepetkauka untsuri aintsun nepetina nuna nangkamasang pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR16_33","021_16_33","PRO","16","33","33","Aints ainau ¿yáki juna jukit? Tusar, “suerten” nakurinawai. Tura wainiat Yus ni wakeramurin tuke umiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_1","021_17_1","PRO","17","1","1","Aints yutan jumchik yuwayat, angkan pengker nintimias pujakka, nekas pengker pujawai. Antsu chikich aints ainauka fiestan tuke najaninak, namperar maani pujuinauka pengkerka pujuinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR17_2","021_17_2","PRO","17","2","2","Aintsu inatiri asump ni inámniu uchirin nangkamasang pengker nintintin asa, inámniu uchiri ainaujai metek inámniu waririn jukitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_3","021_17_3","PRO","17","3","3","Aints ainau: Kurisha tura kuikiasha pengkerashi tusar, jinum jiyamin ainawai. Yuscha nunisang aintsu ninti pengkerashi tusa ningki nekawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_4","021_17_4","PRO","17","4","4","Pase ainau tura waitrin ainausha pase chichaman anturin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_5","021_17_5","PRO","17","5","5","Aints kuikiartichu ainaun wishikina nuka niin najanamia nuna wishikinawai. Turasha yuuminak pujuinaun wishikinak waraina nuka wait wajakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_6","021_17_6","PRO","17","6","6","Junntach ainauka tirangkin wainkar warainawai. Tura uchi ainausha aparin tura nukurincha pachisar pengker chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_7","021_17_7","PRO","17","7","7","Nintimchau ainauka pengkeran chichatnaka nuimiarchau ainawai. Tura aintsu juuntri ainauka wait chichamnaka chichakchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_8","021_17_8","PRO","17","8","8","Aints chikich ainaun kuikian nangkami suakka, pachitsuk waring achat mash kiaungkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_9","021_17_9","PRO","17","9","9","Aints chikich aintsu tunaarin etsertsuk pujamtaikia, tunaarinnuka niin nukap aneetnuitai. Antsu aintsu tunaarin chikichan etsermatikia, amikri ainauka niin kiishminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_10","021_17_10","PRO","17","10","10","Aints uchirin paan nintiniunka antukti tusar chicharkartinuitai. Turamtai pengker antuktinuitai. Antsu aints nintinchaun antukti tusar kichik pachak awatrarmaitiat, pengké antatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR17_11","021_17_11","PRO","17","11","11","Aints chichaman umichuka aya maanitian wakerawai. Tura asamtai apuri ni inatirin akupkamtai, nuka maanin aintsnaka pengké wait anentrashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_12","021_17_12","PRO","17","12","12","Juun yawaa ni uchirin jurukmiaujai ingkiuniktinka shamrumtinuitai. Tura netse aintsjai ingkiuniktincha timiá shamrumtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_13","021_17_13","PRO","17","13","13","Aints chikich aintsun pengker awajmaitiat, nuka nu aintsun pengkerka awajtsuk pase awajsatniua nuna kajinmatsuk ni weari ainaunka tuke mash pase awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_14","021_17_14","PRO","17","14","14","Jiyaniamuka entsa nujangkrak nungkan amuawa umurtinua nunisketai. Tura asamtai nukap kajernaikiaij tusar chichatsuk inaisartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_15","021_17_15","PRO","17","15","15","Aints pase takaun pachis: Nuka pengkeran turayi tusar tsangkuratin, tura tunaun takaschaun pachis: Nuka paseen turayi tusar wiasmamtikiatnunka mai metek Yus arantak nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_16","021_17_16","PRO","17","16","16","Aints nekachuka nuimiartas akikmaksha ¿timiá nintimchausha itiur nuimiarti? ");
INSERT INTO acuNT_vpl VALUES ("PR17_17","021_17_17","PRO","17","17","17","Ii amikrijai tuke anenin atinuitji. Tura itiurkachminnum pujakrikia, ii amikrikia ii yachia nunisang yainmaktinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR17_18","021_17_18","PRO","17","18","18","Aints nintimchauka ni irutkamu tumaashrin akimiatak iiksang tumaashmiak pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_19","021_17_19","PRO","17","19","19","Aints jiyaanitan wakera nuka maaniatniuncha wakerawai. Tura miajuitjai tumamuka ningki mestumawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_20","021_17_20","PRO","17","20","20","Aints aya tunaun nintimniuka pengkera nuna pengké wainkashtinuitai. Tura anangkartinka itiurkachminnum iyaartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_21","021_17_21","PRO","17","21","21","Uchi netseka aparin wake mesemtikniayi. Uchi nintinchau pujamtaikia, apari wararsashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_22","021_17_22","PRO","17","22","22","Aints inintijai waraawa nuka tsuaka nunisketai. Tura napchau nintimsar pujuinauka kakarchamin nekapenawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_23","021_17_23","PRO","17","23","23","Aints tunaun takasua nuka chichaman nekamtiknujai kanak pujus chicharak: Nu aintska pengkeraitai, tunaunaka turichuitai tita. Turakminka kuikian susatjame tamataikia, nu pase chichaman nekamtikniuka kuikianka juki, wait wajaktinka sutsuk akupawai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_24","021_17_24","PRO","17","24","24","Nekau aintska tuke paan nintimias pujustinuitai. Tura nekachuka paanka nintimtsuk nangkami nintimnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_25","021_17_25","PRO","17","25","25","Uchi netseka aparin kajkatnuitai. Turamtai nukuri: Nu uchinka wikia nangkamin jerermiajai titinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_26","021_17_26","PRO","17","26","26","Aints tunaun turichu ainaun wait wajaktincha susashtinuitai. Tura juun ainau pengker aints ainau wainiatang awatratniuka paseetai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_27","021_17_27","PRO","17","27","27","Nekau ainauka jumchik chichainayat, antujamin chichasartinuitai. Tura nintip ainauka waurtsuk anturin artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR17_28","021_17_28","PRO","17","28","28","Aints nintimchausha nukapka chichatsuk pujamtai, chikich aints ainau: Nintipchawashi tu nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_1","021_18_1","PRO","18","1","1","Surikia aya ninunak eatmamui. Tura asa chikich ainau chicharnaikiar pujuinamtaikia, tuke itit awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_2","021_18_2","PRO","18","2","2","Aints nintimchauka nuimiartaska wakerichuitai. Antsu ni nintimaurinak chikich ainaun ujaktas wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_3","021_18_3","PRO","18","3","3","Pase aints chicham natsanpiakun chichawitai. Turasha ningki nintimtumas: Miajuitjai ta nuna chichamenka chikich aints ainauka antutan arantak nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_4","021_18_4","PRO","18","4","4","Aintsu chichamengka entsa kunaria tumawaitai. Tura ni nekatiringkia entsa pukuni nungkanmaya jiinua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_5","021_18_5","PRO","18","5","5","Aints tunaun takasua nuna chichamen nekamtikin ainau antukar: Nuka tunaunaka turichuitai tichamin ainawai. Tura chikich aints tunaun takachun pachisar: Nuka tunaawitai tusar nangkamiar wiasmamtikiatniuka paseetai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_6","021_18_6","PRO","18","6","6","Aints netse chichaa nuka maanitan wakerawai. Tura ni chichaamtai, chikich aints ainau awatrartas wakerukartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_7","021_18_7","PRO","18","7","7","Aints netsea nuka ni chichamejaingkia ningki mestumawai. Tura asa chapikjai kuntujnum jingkiamua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_8","021_18_8","PRO","18","8","8","Aujmakratniu chichamengka yuta yumínua nunisarang ainawai. Turasha nuna antinauka nintinam ukusar kajinmakchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_9","021_18_9","PRO","18","9","9","Takatan nakimshim takainauka meskartinua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_10","021_18_10","PRO","18","10","10","Apu Yuse naaringkia jea kaya jeamkamua nunisketai. Timianu asa niin umirkaru ainauka nu jeanam wayaawarua nunisarang uwemraru ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_11","021_18_11","PRO","18","11","11","Kuikiartin ainauka: Iikia kuikiartin asar, yakat pengker wenurmawa nunisrik pujaji. Tura asakrin ii kuikiarinka pengké atantramkichartinuitai, tu nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_12","021_18_12","PRO","18","12","12","Aints ningki nintimias: Miajuitjai tumamin aneachmau itiurkachminnum jeatnuitai. Antsu aints ainau: Wina pengker awajtursarti tinu ainauka eemkar: Wikia mianchawaitjai tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_13","021_18_13","PRO","18","13","13","Aints chikicha chichamen antutsuk ningki aimua nuka nintimchau asa, natsanpiaku chichaawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_14","021_18_14","PRO","18","14","14","Aints jau pengker nintimias pujakka, jatan nepetkatnuitai. Antsu jau napchau nintimias pujakka, jatanka nepetkashtinuitai. ¿Yáki inankit? ");
INSERT INTO acuNT_vpl VALUES ("PR18_15","021_18_15","PRO","18","15","15","Paan nintimin ainauka nukap nuimiartasar wakerinawai. Tura nintip ainausha aya antukar nuiminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_16","021_18_16","PRO","18","16","16","Aints apu ainaujai chichastas wakerakka, warinchun takus winamtai, apu ainauka wári waitin uratinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_17","021_18_17","PRO","18","17","17","Chichaman nekamtikniunam aints taa, ni turamurin pachis: Tu awai tusa etsermatai, ¿nekasash taj? tusa tenapkeska nekaachminuitai. Turamaitiat ni nemase taa, nu aintska waitaitai tusa, ni inintramurijai paan nekaawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_18","021_18_18","PRO","18","18","18","¿Jimiar kakaram aintsu kajernaikiamurin itiur iwiaaratnuita? Yáki nepetmakat tusar nakuruti “suerte” tutain nakurusartinuitai. Tura asaramtai mai metek kakarma waininayat tu akankartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_19","021_18_19","PRO","18","19","19","Aints ni yachijai kajernai pujuinakka, juun yakat kaya wenurmawa tumawaitai. Tura asa nu yakta waitiri jiru najanamua nunisketai. Tura nu jimiar yachi ainau suwiri waiti epenmiawa nunisang asamtai, chichaman pengké iwiaarachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_20","021_18_20","PRO","18","20","20","Aints ainau ni chichaamurijai tutuarua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_21","021_18_21","PRO","18","21","21","Tunau chichamnaka nakitajai tinauka pengker awajmaminawai. Antsu aints nintimtsuk nukap chichainauka ningki mesmamrartin ainawai. Turasha napchau nintimrarti tusar maamnawaitji. Tura asar ii chichamengka árak araamua nunisarang ainawai. Ii turaji nunasha iincha turutmatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR18_22","021_18_22","PRO","18","22","22","Aints nuwan nuwatkatas wakerakka, nuwan eaktinuitai. Yus nuka pengkeraitai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_23","021_18_23","PRO","18","23","23","Kuikiartichuka ni tumaashrin akiktatkama tujintak: Wait anentrata tusa seamnuitai. Antsu kuikiartin wait anentsuk kakaram chichaak aimkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR18_24","021_18_24","PRO","18","24","24","Aintsu amikri untsuri pujuinamtaikia, itiurkachminnum jeartinuitai. Antsu nekas amikringkia ni yachia nuna nangkamasang pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_1","021_19_1","PRO","19","1","1","Aints kuikiartichu ayat, anangmichuka nekas pengkeraitai. Antsu netse aints chikich aints ainaun tsanumak puja nuka nekas paseetai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_2","021_19_2","PRO","19","2","2","Aints nuimiarchauka waurak takatrin wári umistas wakerakka, nukap nuwaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_3","021_19_3","PRO","19","3","3","Aints ainau ningki wakerinak pase pujuinauka Apu Yusen wiasmatkatin— ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_4","021_19_4","PRO","19","4","4","Kuikiartinu amikingkia untsuri ainawai. Tura kuikiartichu amikringka niin ajapawar ukukiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_5","021_19_5","PRO","19","5","5","Aints nekas aa nuna nekayat, anangkak chicham nekaschaun etsera nuka ni wait wajaktintrin nekas jukitnuitai. Tura waitrin ainauka angkanka pujuschartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_6","021_19_6","PRO","19","6","6","Aints tsangka nuna aints untsuri eainawai. Tura tsangkamin asamtai, aints ainau mash ni amikri wajasartas wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_7","021_19_7","PRO","19","7","7","Aints kuikiartichun ni yachii ainauka jiitnasha nakitinawai. Tura asaramtai ¿ni amikri ainausha iturak niin ajapawar ukukcharting? Tura yainkata tusa untsukmasha mash ukukmiausha ¿yáki yainkat? ");
INSERT INTO acuNT_vpl VALUES ("PR19_8","021_19_8","PRO","19","8","8","Aints pengker nintimniuka nangkamikia anenmamakapujatsui. Antsu nintip wajastaj tusa, nukap nuimiaru asa, nekas pengker pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_9","021_19_9","PRO","19","9","9","Aints nekas aa nuna nekayat, chicham nekaschaun anangkak etsera nuka ni wait wajaktintrin nekas jukitnuitai. Turasha waitrinka nekas jakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_10","021_19_10","PRO","19","10","10","Aints nintinchauka kuikian tura warinchuchin nukap achik nuna inakmaschatnuitai. ¿Tura aintsu inatirisha iturak apu ainaun iniartinuita? ");
INSERT INTO acuNT_vpl VALUES ("PR19_11","021_19_11","PRO","19","11","11","Aints paan nintimniuka wárikia kajekchatnuitai. Tura chikich aints ainau niin pachisar pase chichainamtai, ningki titi tusa pachischatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_12","021_19_12","PRO","19","12","12","Aintsu apuri kajetiri juun yawaa kajeawa nunisketai. Tura ni wait anengkratairi sana chirichrinam tepawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_13","021_19_13","PRO","19","13","13","Uchi nintinchauka aparin wake mesemtikui. Tura nuwa katsekmin kichkitiat itit awajkartinua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_14","021_19_14","PRO","19","14","14","Uchirtin ainauka ni uchirin jeancha, tura kuikiancha susartin ainawai. Antsu nuwa pengker nintinniuka Yusnumiayaintai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_15","021_19_15","PRO","19","15","15","Aints nakia nuka aya kanú tepestas wakerawai. Tura aints takakmichuka tsukajai waitjaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_16","021_19_16","PRO","19","16","16","Aints umiktin chichaman Apu Yus akupkamia nuna umirak pujakka, wikia itur pujaja tusa wainkatnuitai. Antsu nuna umirtan nakitniuka jakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_17","021_19_17","PRO","19","17","17","Aints kuikiartichun waring achat susatata nuka Apu Yusen ikiastinuitai. Tura asamtai Apu Yus ni ikiasmaurin awangtuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_18","021_19_18","PRO","19","18","18","Uchiram anturtamchamtaikia chicharkata. Tura mesrai tu nintaimsam waurtsuk turata. ");
INSERT INTO acuNT_vpl VALUES ("PR19_19","021_19_19","PRO","19","19","19","Aints nukap kajeunka ni wait wajaktintrin susatnuitai. Nu turachmaka nuna nangkamasang pase wajastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_20","021_19_20","PRO","19","20","20","Aints ainau amin chichartaminamtaikia umirkata. Turasha nuitaminamtaikia pengker anturkata. Nu turakmeka ukunam paan nintimin atinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR19_21","021_19_21","PRO","19","21","21","Aints ainau ningki wakerinak: Wikia nuna turatatjai tusar nukap nintimsar pujuinawai. Antsu Apu Yus ningki wakerak: Tu ati tusa tsangkatkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_22","021_19_22","PRO","19","22","22","Aints ainau wait anengkratin arti tusar timiá wakeruktinuitai. Turasha anangkartin wajatsuk kuikiartichu wajastinka nekas pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_23","021_19_23","PRO","19","23","23","Apu Yusen umirinak pujuinauka tuke iwiaaku pujusartin ainawai. Tura asar aints tu pujuinauka pengker nintimsar pujusar iturkachminaka waintsuk ayamsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_24","021_19_24","PRO","19","24","24","Aints nakia nuka tachaun achiayat, yutairin yuatniunka pachis: Nuka takataintai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_25","021_19_25","PRO","19","25","25","Wishiikiartiniun awatraramtai, nintinchau ainauka nuna jiisar: Winasha turutawarai tusar nuimiarartinuitai. Tura paan nintimin ainauka aya chicharam nuimiarartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_26","021_19_26","PRO","19","26","26","Aints ni apariniun kasamak puja nuka tura ni nukurin ni jeenian jiiki akupkauka nekas paseetai, turasha natsanpiakuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_27","021_19_27","PRO","19","27","27","Uchiru, wi chicharkartamur antutsuk pujakmeka, nekatai chichamka nuimiarchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR19_28","021_19_28","PRO","19","28","28","Aints waitrina nuka wait chichaman etserin asa, chichaman nekamtikniunka anangkatnuitai. Tura pase nintiniuka aya pase chichamnak chichaawai. ");
INSERT INTO acuNT_vpl VALUES ("PR19_29","021_19_29","PRO","19","29","29","Wishiikiartin ainaun tura nintinchau ainauncha antukarat tusar awatrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_1","021_20_1","PRO","20","1","1","Umuti kariau aina nuna aints ainau uminakka, nampekar pase chichau ainawai. Nunia natsamchau ainawai. Aints nampek pujakka, paanka nintimrachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_2","021_20_2","PRO","20","2","2","Aintsu apuri kajetiringkia juun yawaa shaamai chichaawa nunisketai. Tura asamtai niin kajkartin ainauka mantamawai tusar shamkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_3","021_20_3","PRO","20","3","3","Aints jiyaanitan nakitinauka nekasar pengker nintimsar pujuinawai. Antsu netse ainauka pachitsuk chikich ainaun jiyaktasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_4","021_20_4","PRO","20","4","4","Nakia nuka takakmastin ayat takakmatsui. Nunia ukunam juuktaj takusha pengké wainkashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_5","021_20_5","PRO","20","5","5","Aintsu nintimtairingkia entsa timiá kunanam iruna tumawaitai. Tumau wainiatang aints nintip: ¿Itiur nintimua? tusa nekaatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_6","021_20_6","PRO","20","6","6","Aints untsuri chichainak: Amin ajapanka pengké ukukchatatjame nangkamiar tinawai. Antsu nekas chichaman chichainaunka ¿yáki wainkamnawaita? ");
INSERT INTO acuNT_vpl VALUES ("PR20_7","021_20_7","PRO","20","7","7","Aints tunaarinchau nekas pengker pujakka ni uchiri ainaun waramtiksatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_8","021_20_8","PRO","20","8","8","Aintsu apuri ni aintsri tunaarin nekaatas apu ekemtainam ekemas pujus, nu aintsun aya jimiaj pujus ni tunaurin nekaatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_9","021_20_9","PRO","20","9","9","Wikia pengké tunaarinchawaitjai. ¿Wina nintirka tunau nekas atsawai tusa, anangtsuk yáki titinuita? ");
INSERT INTO acuNT_vpl VALUES ("PR20_10","021_20_10","PRO","20","10","10","Meram nekapmatai tura esanti nekapkesha metekchau aina nunaka Apu Yus tsuutawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_11","021_20_11","PRO","20","11","11","Uchi umiu tura pengker nintiniuka yáki tusar ni turamurijai paan nekamawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_12","021_20_12","PRO","20","12","12","Aintsu kuwishin antutirin tura jiijai jiimtairincha Apu Yus mai metek najankauwitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_13","021_20_13","PRO","20","13","13","Aya karap wajasaip. Tu pujakmeka yuumaktatme. Antsu shintaram takakmakmeka yuumakchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR20_14","021_20_14","PRO","20","14","14","Warinchu sumin warinchun jiis chichaak: Nuka pengké paseetai tayat, nunia majachik sumak ukuki: Maj, nekasan nintipitjai tumamui. ");
INSERT INTO acuNT_vpl VALUES ("PR20_15","021_20_15","PRO","20","15","15","Kuri nekas akikaitai. Tura kaya akiksha sumakmin ainawai. Antsu paan nintimin ainauka jumchik irunui. Nu aints ainauka kurin nangkamasarang tura kaya akikian nangkamasarang timiá pengker ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_16","021_20_16","PRO","20","16","16","Aints nekashtai tumashmamtai, chikich aints: Wi akimiatkatatjai tamataikia, nuna wejmakri aitkam jurukim ukusta. Tura nekashtai tumashrin akimiatkamtaikia, wejmakrinka ataksha susata. ");
INSERT INTO acuNT_vpl VALUES ("PR20_17","021_20_17","PRO","20","17","17","Anangkartin chikich aintsun anangka yutan majachikjai sumak nuna yuwak: Nuka nekas yuminuitai tayat, ukunam nungka tsetserin apakua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_18","021_20_18","PRO","20","18","18","Aints ainau ni nintimauringkia itiur aina tusar aujnaisar, chichaman najanawartin ainawai. Turinau asaramtai aints ainau mesetnum wetasar, nunaa eemkar ni nintimaurin pachisar chichainak, mesetnasha najanawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_19","021_20_19","PRO","20","19","19","Aujmakratniuka chikicha chichamen uurkashtinuitai. Tura asamtai aujmakratin ainaujaingkia tsaningkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR20_20","021_20_20","PRO","20","20","20","Aints aparin tura nukurincha numingkia nuka ukunam kirit teenam pujuinawa nunisang jakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_21","021_20_21","PRO","20","21","21","Aints ainau kakarmachu kuikian irumina nuka ukunmaka nu kuikiajaingkia wararsachartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_22","021_20_22","PRO","20","22","22","Nu aintska wina pase awajtusmiana nunaka wikia yapaijkiatatjai tiip. Antsu Apu Yus turati tusam, jaimiasam nakasta. Ningki yapaijkiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_23","021_20_23","PRO","20","23","23","Meram nekapmatai metekchau ainaunka Apu Yus tsuutawai. Tura meram nekapmataijai aints ainaun anangkinauncha arantak nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_24","021_20_24","PRO","20","24","24","Apu Yus aints ainautin: Ju jinta amakrum wekaasataram turamji. Tura asamtai aints ningki nintimias: Wikia ju jintan amakan wekaasatjai tayat, Yus tsangkatachmataikia pengké turachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_25","021_20_25","PRO","20","25","25","Aints tenap nintimtsuk: Yusjai tajai: Juka Yusnau ati tayat, nunia wake nintimiar. Yusnau achati ta nuka itiurkachminum pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_26","021_20_26","PRO","20","26","26","Aints ainau trigon juukar jingkiajincha tura saapencha akankartas su su umpuinawa nunisang aintsu apuri nekauka pase aints ainaun arák akupkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_27","021_20_27","PRO","20","27","27","Apu Yus aintsun ni wakanin susau asamtai, nuka aintsu paaniurintai. Tura asa aintsu wakani ni nintimauri pengker arti tusa pengker awajsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_28","021_20_28","PRO","20","28","28","Aintsu apuri nekas chichaman aneak, wait anengkratin asa, ni aintsri ainaun tuke pengker inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_29","021_20_29","PRO","20","29","29","Natsa ainau kakaram asar, wikia warimpitja tumaminawai. Tura juuntach ainausha nekainau asar, wikia jemperinuitjai tumamainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR20_30","021_20_30","PRO","20","30","30","Pase ainau pengker wajasarat tusar awatinamtaikia, nuka tsuaka nunisketai. Tura asamtai ni tunaarin nintimrarti tusar awatratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_1","021_21_1","PRO","21","1","1","Apu Yus entsa tu weti tusa inawa nunisang aintsu apuri ni wakeramurin timiatrusang umirtukti tusa nintimtikui. ");
INSERT INTO acuNT_vpl VALUES ("PR21_2","021_21_2","PRO","21","2","2","Aints ningki nintimias: Wi turaja nuka mash pengkeraitai tayat, Apu Yus: Waruka tu nintimua tusa nekawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_3","021_21_3","PRO","21","3","3","Aints ainau tangkun Yusen susartas maina nuna nangkamasarang pengker nintimsar ni wakeramurin umirkarti tusa, Apu Yus timiá wakerawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_4","021_21_4","PRO","21","4","4","Ni jiijai suwirpiaku jiimsatin, tura wikia miajuitjai tumamtin, tura aintsu pase nintimtairisha mash tunau ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_5","021_21_5","PRO","21","5","5","Aints nunaa eemak pengker nintimiar: Tu takakmastajai tusa, takatan nangkamawa nuka nukap eemtikiatnuitai. Antsu chikich aints waurak: Wári takatan umistajai tusa, takatrin tu nangkamawa nuka nukap nuwaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_6","021_21_6","PRO","21","6","6","Anangkartin ainau warinchurin nukap kiaungkarmia nuka yurangkim tsaa sukuamunam mengkawa nunisketai. Aints wári kuikiartin wajastasar wakerinauka wári jakatasar wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_7","021_21_7","PRO","21","7","7","Pase aints ainau pengkeran turatniun nakitinawai. Antsu tuke maanitan wakerinau asar mengkakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_8","021_21_8","PRO","21","8","8","Aints wait chichaman etsera nuka mengkakatnuitai. Antsu anangmichu aina nuna turutiringkia jinta tupnik jeatnua nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_9","021_21_9","PRO","21","9","9","Juun jea shiiram iwiaramunam katsekmin nuwajai pujustinka mianchawaitai. Antsu jea tiupchinam ningki pujustinka timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_10","021_21_10","PRO","21","10","10","Aints paseka tuke pase turatniunka nintimias pujawai. Tura asa ni irutkamuri ainaunka mash wait anentsuk pujawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_11","021_21_11","PRO","21","11","11","Wishiikiartinun awatraramtai, nintinchau ainau nuna jiisar: Turunawai tusar nuimiarartinuitai. Tura paan nintimniunka aya chicharinam, wári nuimiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_12","021_21_12","PRO","21","12","12","Yus nekas tunaarinchawa nuka pase aintsu pujutrin jii pujurui. Tura asa pase aints ainau itiurkachminnum wearti tusa akupkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_13","021_21_13","PRO","21","13","13","Yuuminak pujuinauka yainkata tinamaitiat, chikich aints ainau antutsuk pujuinauka ukunam yuuminak yainkata tinamtaikia, chikich ainauka pengké pachischartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_14","021_21_14","PRO","21","14","14","Kajeu aintsun chikich aints warinchun nangkami suamtai, warinchun shishkamsang susamun jukitata nuka timiá kajeu pujayat, kajekmaurin wári inaisatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_15","021_21_15","PRO","21","15","15","Chichaman nekamtikin pase turinaun pachis: Achikrum karsernum akupkataram tamatai, tunau turichu ainau warainawai. Antsu pase turin ainauka shaminak kurainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_16","021_21_16","PRO","21","16","16","Aints paan nintimratniun jintanmaya jiinki weakka, wári jakau iwiartainium ayamsatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_17","021_21_17","PRO","21","17","17","Aints nampetan wakerak, nangkami pujus, perfumen akikian sumaktas wakerakka, kuikiartichu atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_18","021_21_18","PRO","21","18","18","Anangkartin tura pase aints ainauka wait wajakartin ainawai. Antsu anangmichu tura pengkeran turin ainauka uwemrartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_19","021_21_19","PRO","21","19","19","Nuwa kajeu tura katsekminjai pujustinka mianchawaitai. Tura asamtai aints atsamunam ningki pujustinka timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_20","021_21_20","PRO","21","20","20","Paan nintimniu jeenka kuik tura yutaisha nukap irunui. Antsu aints nintinchauka ni takaka nuna mash nangkami ajapui. ");
INSERT INTO acuNT_vpl VALUES ("PR21_21","021_21_21","PRO","21","21","21","Aints tupin nintimias tura wait anenkartin pujakka, chikich ainauka: Nuka pengker aintsuitai tiartinuitai. Tura jakayat tuke Yusnum iwiaaku pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_22","021_21_22","PRO","21","22","22","Aints timiá paan nintimniuka ni nekamurijai chikich ainaun nepetkatnuitai. Tura nekasan kakarmaitjai taunka ni pase nintimaurincha ni nekamurijai nepetkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_23","021_21_23","PRO","21","23","23","Aints nangkamikia chichatsuk tuke yaitas chichawa nuka itiurkachminumka jeashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_24","021_21_24","PRO","21","24","24","Aints miajuitjai tumamin meemas tura katsekmak pujau asamtai, ni naaringkia wishikiartin naartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_25","021_21_25","PRO","21","25","26","Aints nakikia aya tuke wakerinuitai. Tura takakmastinasha nintimchau asa, waring achat mash wakerinuitai. Turayat jukichu asa kintajai metek jakamin nekapeawai. Antsu asumkia takatan shamtsuk pujus, surimtsuk tuke chikich aints ainaun yayaawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_27","021_21_27","PRO","21","27","27","Pase aints ainau pase nintimsar tangkun maawar Yusen susartas epeena nunaka Apu Yus tsuutawai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_28","021_21_28","PRO","21","28","28","Aints wait chichaman etsera nuka jakatnuitai. Antsu aints antuj puja nuna inininamtaikia, antujamniaun chichastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_29","021_21_29","PRO","21","29","29","Pase aints ainauka: Wikia nekau aintsuitjai tusar chikich aints ainaun anangkawartinuitai. Antsu aints anangmichuka: ¿Itiur pujaja? tusa paan nintimias pujuwitai. ");
INSERT INTO acuNT_vpl VALUES ("PR21_30","021_21_30","PRO","21","30","30","Aintstikia nekau akurkia, tura nintip akurkia, turasha paan nintimsar pujakrikia, Apu Yuse pengké anangkashtinuitji. ");
INSERT INTO acuNT_vpl VALUES ("PR21_31","021_21_31","PRO","21","31","31","Suntar ainau mesetnum weartas ni kawairin tenapkesar iwiarinawai. Antsu ni nemase ainaun nepetkatniun Yusek ningki tsangkatkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_1","021_22_1","PRO","22","1","1","Aints ainau iin pachitmasar: Nuka pengke aintsuitai tiartinka kurin tura kuikian nangkamasang timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_2","021_22_2","PRO","22","2","2","Aints kuikiartin ainauncha tura kuikiartichu ainauncha mai metek Apu Yuska najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR22_3","021_22_3","PRO","22","3","3","Aints paan nintimua nuka itiurchatnaka wári nekaa kiishmaktinuitai. Antsu aints nintinchauka itiurchatnaka nekaatsuk wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_4","021_22_4","PRO","22","4","4","Aints: Wikia mianchawaitjai tumaminauka Apu Yusen umirkar pujusar yumakchartin ainawai. Turinamtai chikich aints ainauka niin pachisar: Pengke aintsuitai tiartin ainawai. Tura asaramtai untsuri musach pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_5","021_22_5","PRO","22","5","5","Pase aintsu nintinka jinta jangki irunmaunum tura ejatak untsuri ukusmauwa tumawaitai. Antsu aints tuke Yusnum pujustas wakerakka nu jintanam wekaasatniunka arantak nakitawai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_6","021_22_6","PRO","22","6","6","Uchi pengker pujusti tusam nuiniarta. Tura nunia juunmar ame chicharkamurmin pengké kajinmakchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_7","021_22_7","PRO","22","7","7","Kuikiartin ainauka kuikiartichu ainau apuri ainawai. Tura aints tumaashmiaunka niin tumaashin susamia nuna inatairi wajawai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_8","021_22_8","PRO","22","8","8","Aints pasen turauka ukunam itiurkachminnum jeatnuitai. Tura tuke paseen takau asamtai, Apu Yus ni suirijai mengkaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_9","021_22_9","PRO","22","9","9","Aints wait anengkratniuka yuuminak pujuinaun yurumkan ajamin asamtai, pengker awajsamu atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_10","021_22_10","PRO","22","10","10","Aints katsekminiun jiikiar awemaru asaramtai, katsumnaikiatniusha, tura jiyaniktincha tura maaniktincha atsutnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_11","021_22_11","PRO","22","11","11","Aints pengker nintiniuka yaitas chichau asamtai, ni apuri amikri atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_12","021_22_12","PRO","22","12","12","Apu Yus paan nintimniun wainui. Antsu anangkartinka antujachminun chichasti tusa nintimtikui. ");
INSERT INTO acuNT_vpl VALUES ("PR22_13","021_22_13","PRO","22","13","13","Aints nakia nuka takatan nakitau asa: Juun yawaa jinta wajas yuruawai tusan jea pujajai, tu pujuwitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_14","021_22_14","PRO","22","14","14","Kungkatip nuwa chichamengka waa kuna taurmawa tumawaitai. Aints Yus yumingkramu ainauka nu waanam iyarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_15","021_22_15","PRO","22","15","15","Uchi nintimchau chichaman antutan nakitau asamtai, jumchik awatratnuitai. Tura asamtai paan nintimiar tunau turutin inaisatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_16","021_22_16","PRO","22","16","16","Kuikiartin nukap kiauntumkataj tusa, kuikiartichu waririn atanta nuka tura aints kuikiartiniun kuikian nangkami sua nusha mai metek kuikiartichu wajasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_17","021_22_17","PRO","22","17","17","Paan nintimin aina nuna chichame tenapkesam antukta. Tura wi nuiniartatjame nuka nintimin ukusam tenapkesam nuimiarta. ");
INSERT INTO acuNT_vpl VALUES ("PR22_18","021_22_18","PRO","22","18","18","Nu turakmeka pengker nintimtin atinuitme, tura nu chichama nintimin ukusu asam, chichaakmesha nusha etserkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR22_19","021_22_19","PRO","22","19","19","Tura Apu Yus timiatrusmek nintimtusta tusan, yamai amincha ujaktajme. ");
INSERT INTO acuNT_vpl VALUES ("PR22_20","021_22_20","PRO","22","20","20","¿Nuikiartin chichaman tura nekaatin chichamnasha nekas pengkera nuna treintan aatrachmakjam? ");
INSERT INTO acuNT_vpl VALUES ("PR22_21","021_22_21","PRO","22","21","21","Nu nekas chicham ainaun pengker nekaamka, chikich aints ainau amin ininminamtaikia, nu chichamsha ujaktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR22_22","021_22_22","PRO","22","22","22","Aints kuikiartichu asamtai, ni warinchurin pengké atankiip. Tura yamrumichu ainaun chicham nekamtikniunam jukimka waitkasaip. ");
INSERT INTO acuNT_vpl VALUES ("PR22_23","021_22_23","PRO","22","23","23","Kame, Apu Yus kuikiartichu ainaun ayamrin asa, yamrumichu ainaun waitkina nunasha nunisang waitkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_24","021_22_24","PRO","22","24","24","Aints suir nekapniujai tsaningkaip. Turasha aints kajeu aina nujaisha iruntsuk asata. ");
INSERT INTO acuNT_vpl VALUES ("PR22_25","021_22_25","PRO","22","25","25","Tura ni turamurin jiisam, wisha nunisnak aitkataj tu nintimsaip. Turakmeka chapikjai jingkiamua nunismek wait wajaktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR22_26","021_22_26","PRO","22","26","26","Aints tumaashmiau wainkam: Wi tumaashrumnaka akimiatkatjame tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR22_27","021_22_27","PRO","22","27","27","Takumka akimiaktin kinta jeamtai, akimiakchakminka apamrumnasha atantramkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR22_28","021_22_28","PRO","22","28","28","Juuntrum ainau yanchuik nungka akankamunam: Juka wina nungkaruitai tusar, painin jintawarmia nuka kuinkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR22_29","021_22_29","PRO","22","29","29","¿Aints ni takatrin pengker takakmawa nu wainukitam? Nu aintska takatrin nekamtikin asa, aints mianchau takarnuri wajaschatnuitai, antsu apu ainau takarniuri wajastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_1","021_23_1","PRO","23","1","1","Aintsu apurijai yuwatasam keemsamka, warí yutaina itainawa nu anearam yuwata. ");
INSERT INTO acuNT_vpl VALUES ("PR23_2","021_23_2","PRO","23","2","2","Tura nukap yaparayatmek jumchik yuwata. ");
INSERT INTO acuNT_vpl VALUES ("PR23_3","021_23_3","PRO","23","3","3","Nu yutai kungkuram au wainiatum: Anangkruwartimpiash tusam anearta. ");
INSERT INTO acuNT_vpl VALUES ("PR23_4","021_23_4","PRO","23","4","4","Wikia kuikiartin wajastaj, tuuka nintimraip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_5","021_23_5","PRO","23","5","5","Antsu paan nintimsam: Kuikiartinu kuikiaringkia nanamtin wári nanamina nunisang mengkawai tusam nekaamnawaitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_6","021_23_6","PRO","23","6","6","Aints suria nuna yutairingka yuwaip. Turamka ni yutairi nekas pengker iwiaaramun au wainiatum nuka wakerukaip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_7","021_23_7","PRO","23","7","7","Nu aintska tuke yutai akikaitai tuu nintimui. Amin: Yuwata turasha murta tayat, suri asa pengker nintimsangka nunaka turamtsui. ");
INSERT INTO acuNT_vpl VALUES ("PR23_8","021_23_8","PRO","23","8","8","Tura asamtai yurumak yuwamame nuka arumak iniuktatme. Tura asam: Pengker yuwajai tayatum, nuka nangkami timiame. ");
INSERT INTO acuNT_vpl VALUES ("PR23_9","021_23_9","PRO","23","9","9","Aints nintimchau antamunam chichakaip. Ame paan nintimsam chichasume nuna antuk amin wishikramratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_10","021_23_10","PRO","23","10","10","Yanchuik juuntrum ainau nungkan akankamunam painin jintawarmia nuka kuinkaip. Tura mitaikia nungkarisha atankiip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_11","021_23_11","PRO","23","11","11","Warí, uchi mitaik aina nuna ayamrinka nekas kakarmaitai. Tura asa mitaik ainaun ayamruktas amin nepetamkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_12","021_23_12","PRO","23","12","12","Amin nuitaminamtai nintimjai pengker nintimtusta. Tura paan nintimram, nuikiartamu antukume nuka kajinmakiip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_13","021_23_13","PRO","23","13","14","Uchi chicharkatniuka inaisaip. Uchi jumchik awatramka jakashtatui. Kame, antukat tusam awatramka, Yusen umirak pujus tuke jakatniunam wetsuk uwemtikratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_15","021_23_15","PRO","23","15","15","Uchiru, ame paan nintimramka, winasha nukap waramtikrame. ");
INSERT INTO acuNT_vpl VALUES ("PR23_16","021_23_16","PRO","23","16","16","Tura nekas pengker chichaakminkia, nuna antukan nukap warastinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_17","021_23_17","PRO","23","17","17","Tunaarintin ainauka nekasar pengker pujuinawai, tuuka nintimraip. Antsu ami Apuram Yus tuke pengker awajsata. ");
INSERT INTO acuNT_vpl VALUES ("PR23_18","021_23_18","PRO","23","18","18","Nu turakmeka ukunam jakamin nekapeakmeka: Yusnumapi wetatja tu nintimratnuitme. Nunia jakamsha nekasam Yusnum tuke iwiaaku pujustinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_19","021_23_19","PRO","23","19","19","Uchiru, anturtukta turakum pengker nuimiarta. Tura jinta Yusnum jeatniunam tuke wekasata. ");
INSERT INTO acuNT_vpl VALUES ("PR23_20","021_23_20","PRO","23","20","20","Antsu nampeu ainaujaingkia tura ushu yutancha nukap wakerin ainaujaisha iruntsuk asata. ");
INSERT INTO acuNT_vpl VALUES ("PR23_21","021_23_21","PRO","23","21","21","Nampeu ainauka tura ushu ainausha wait wajakartin ainawai. Tura naki ainau kuikiartichu asar, mamurar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_22","021_23_22","PRO","23","22","22","Aparam amin yajutmarmia nu anturkata. Tura nukuram juuntach wajasamtaisha nakitraip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_23","021_23_23","PRO","23","23","23","Chicham nekas aina nuka, tura paan nintimratniusha, tura nuimiartincha, tura pengker nekatniusha nukap wakerukta. Antsu nunaka nakitajai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_24","021_23_24","PRO","23","24","24","Aintsu uchiri pengker tura nintip pujakka aparin nukap waramtiksatnuitai. Tura ni yajutmaru asa: Maj, uchirka nekas pengkerapita titinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_25","021_23_25","PRO","23","25","25","Tura asamtai aparam tura nukurmesha amin jeretmarmia nuka mai metek waramtiksarta. ");
INSERT INTO acuNT_vpl VALUES ("PR23_26","021_23_26","PRO","23","26","26","Uchiru, wina tuke nintimtursata, tura wi turaja nu jiista. ");
INSERT INTO acuNT_vpl VALUES ("PR23_27","021_23_27","PRO","23","27","27","Kungkatip nuwaka waa taimu nitak wangkarmachua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_28","021_23_28","PRO","23","28","28","Nu nuwaka kasa aints aneachmau aintsu waririn kasamkatas naka wajawa nunisketai. Tura asa aishmangkun untsurin mengkakatniunam juawai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_29","021_23_29","PRO","23","29","29","¿Ya aintsua wait wajaktinuita? ¿Tura ya aintsua najaimiatnuita? ¿Turasha ya aintsua nangkami juutnuita? ¿Tura ya aintsua maanitan wakeruktinuita? ¿Turasha ya aintsua nangkami numpartinuita? ¿Tura ya aintsua mushatminun jiimsatnuita? ");
INSERT INTO acuNT_vpl VALUES ("PR23_30","021_23_30","PRO","23","30","30","Nampetan pengke inaichau ainau tura umutain wainchatain timiá kariaun nekapin ainau tu pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR23_31","021_23_31","PRO","23","31","31","Umutai nampetai ainaun tenapkesan jiistaj tiip. ¿Warí, yarakmasha timiá kapanniuchukai? ¿Tura shiirmachukai? ¿Nuna umuran suwerka nekas tsuwer jakchatpiash? tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR23_32","021_23_32","PRO","23","32","32","Antsu jumchik arus napi esatma nunisang najaimiakum wait wajaktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_33","021_23_33","PRO","23","33","33","Nu umutaingkia nekaachminun jiimtikramratnuitai. Tura nintinchau wajasam, natsanpiaku chichastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_34","021_23_34","PRO","23","34","34","Tura timiá nampekam karamramuram kanú tsakarin tepamin, ukantinua nunismek tunau nekapratnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR23_35","021_23_35","PRO","23","35","35","Tura shintaram chichaakum: Katsumrinaunak najaimiarchamjai. Tura chapikjai awatinaunak nekaprachmajai. Turayatun tsaarnaka ataksha umuki wetatjai titinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR24_1","021_24_1","PRO","24","1","1","Pase aints ainauka pengker pujuinawai, tuuka nintimraip. Tura niijai iruntratasan wakerajai tuusha nintimraip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_2","021_24_2","PRO","24","2","2","Kame, pase aints ainauka tuke maaniatnun nintimsar pujuinawai. Tura asar pase turatniun pachisar tuke chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_3","021_24_3","PRO","24","3","3","Jea jeamin ainau nekau asar jean jeaminawai. Tura paan nintimsar painin jintatin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_4","021_24_4","PRO","24","4","4","Tura ni nekamurijai jea tesakmauri mash pengker arti tusar tesawar, warinchu shiiram iruna nuna piirkanam kentsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_5","021_24_5","PRO","24","5","5","Aints paan nintimniuka aints kakarman nepetkatnuitai. Turasha aints nekamtikiartinka aints kakarmanka nangkamaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_6","021_24_6","PRO","24","6","6","Tura asamtai mesetan najanawartas: Itiurkamnawaita tusar nintip ainaun yuuminawai. Tura ni nemase ainaun nepetkartas chichaman najanin ainaun untsuri wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_7","021_24_7","PRO","24","7","7","Aints nintinchauka nekau ataj tayat jeachminuitai. Tura asa juun ainau iruntramunam chichaktatkama tujintawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_8","021_24_8","PRO","24","8","8","Aints chikich ainaun tuke pase awajsatas wakerina nuna pachisar: Nuka pase nintintinuitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_9","021_24_9","PRO","24","9","9","Aints netsea nuka aya tunaanak nintimratnuitai. Tura asamtai aints ainau katsekmin ainaun arantak nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_10","021_24_10","PRO","24","10","10","Itiurkachminnum atsantrachmin nekapeakmeka, kakarmarka jumchikita tusam paan nekaatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR24_11","021_24_11","PRO","24","11","11","Nangkamiar maawartinnum jukimu ainauka angkanmamtikiata. Tura nangkamiar: Nu aints maataram tinu ainaunmaya nu aintska uwemtikrata. ");
INSERT INTO acuNT_vpl VALUES ("PR24_12","021_24_12","PRO","24","12","12","Wikia nekaachmajai takumningkia, aintsu nintin mash nekawa nuka: ¿Ameka nekaachmashum tusa, nekas a nuka nekarmashtatuak? ¿Tura amin jakai tusa wainu weawa nuka nekaashtatuak? Yus aintsti ainauti turamurinka mash jiirmastinuitji. Tura asa pengker aa nuna turinauka pengker aa nuna jukiartin ainawai. Antsu pase aa nuna turinauka pase aa nuna jukiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_13","021_24_13","PRO","24","13","13","Uchiru, wapasa yumiri mukunata. Wapasa jee jukimka, nuka nekas yuminuitai tusam nekapsatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR24_14","021_24_14","PRO","24","14","14","Paan nintimratniuka tura nukap nekaatniuka wapasa yumiria tumawaitai. Nu wainkamka ukunam pengker pujustinuitme. Tura: Nuna turatasan wakerajai takumka, nukap arusam nusha turatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR24_15","021_24_15","PRO","24","15","15","Aints anangmichu pachisam: Pase awajsatatjai tu nintimraip. Tura ni pujutirin mesraip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_16","021_24_16","PRO","24","16","16","Kame, pengker turin aina nuka sieten iyainayat, ataksha nantakiartin ainawai. Antsu pase aints ainauka wait wajaktinnum iyarartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_17","021_24_17","PRO","24","17","17","Ami nemasem itiurkachminnum pujamtai warasaip. Tura tukumak iyaramtaikia pengkeraitai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_18","021_24_18","PRO","24","18","18","Apu Yus nunaka jiitnaka nakitawai. Antsu wait anentak ami nemasem tsangkuratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_19","021_24_19","PRO","24","19","19","Pase aints ainau jiisam kajerkaip. Tura ni pachisam: Maj, wisha nijai metek yuumatsuk pujustasan wakerajai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_20","021_24_20","PRO","24","20","20","Pase aints ainau tuke pengkerka pujuschartin ainawai, antsu ni iwiaakmari namparing kajinua nunisang amuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_21","021_24_21","PRO","24","21","21","Uchiru, Apu Yus tura aintsu apurisha umirkata. Tura ni chichamen umirtan nakitin ainaujai pachinkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_22","021_24_22","PRO","24","22","22","Pase aints ainau aneachmau itiurchatniunam waitnasar pujusartin ainawai. Turasha Apu Yus aintsu apurijai ¿warí wait wajaktinnasha akupkartinuita tusar yáki nekaat? ");
INSERT INTO acuNT_vpl VALUES ("PR24_23","021_24_23","PRO","24","23","24","Jusha nukap nekau aina nuna chichamentai: Aintsu apuri ainau tunau turamun nekaawartas eketinauka tunaun turaun chicharinak: Ame pengke aints asam jiinkita tinamtaikia, nuka paseetai. Chikich aints ainau nuna antukar nu apun pachisar pase chichasartin ainawai. Tura chikich nungkanmaya ainausha niin nakitrartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_25","021_24_25","PRO","24","25","25","Antsu apu ainau tunau ainaun ni wait wajaktintrin suina nuka nekasar pengker pujusartin ainawai. Tura asaramtai aints ainau mash niin: Yus yainmakti tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_26","021_24_26","PRO","24","26","26","Aints chikich aintsun pengker aimu wea nuna chichamenka chikich aints ainau pengker nintimsar anturin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_27","021_24_27","PRO","24","27","27","Numi ajaktin umisam, tura árak tenapkesam araam, nuniangka jeemin jeamkata. ");
INSERT INTO acuNT_vpl VALUES ("PR24_28","021_24_28","PRO","24","28","28","Ami irutkamuram pachisam nangkami wait chichaman chichaakum wiasmakaip. Tura wait chichamjai chikich aints tsanuraip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_29","021_24_29","PRO","24","29","29","Chikich aints amin pase awajtamak pujumia nu pachisam: Maj, wikia yapaijkiatjai tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR24_30","021_24_30","PRO","24","30","30","Nuik aints nakia nuna ajarin tura nintinchawa nuna saakarincha nangkamakmajai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_31","021_24_31","PRO","24","31","31","Tura ajarin jangkik nupak, tura wenukrisha yumpungkaun wainkamjai. Tura nuna wainkan nukap nintimramjai. ");
INSERT INTO acuNT_vpl VALUES ("PR24_32","021_24_32","PRO","24","32","32","Tura nuna wainkau asan wi nuimiarja nuka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("PR24_33","021_24_33","PRO","24","33","33","Ame tamrukam kánakum, karamin asam, pengker kanurtasam minakmamsam tepamin, ");
INSERT INTO acuNT_vpl VALUES ("PR24_34","021_24_34","PRO","24","34","34","ami yuumaktintrum yaitas kasa aintsua nunisang amin kuikiartichun awajtamsatas aneachmau winitramtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_1","021_25_1","PRO","25","1","1","Ju chicham ainauka Salomónka chichamentai. Tura wainiat Juda apuri Ezequías naartin ni inatiri ainaun aamtikramiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR25_2","021_25_2","PRO","25","2","2","Yus mash nekawa nuka ni nintimtairinka uuktinuitai. Tura aintsu apuri ainau: Tenapkesan nekaatasan wakerajai tusar nekaamawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_3","021_25_3","PRO","25","3","3","¿Nayaim warutam yakingkit? ¿Tura nungka nitkaringkia warutam kunaita? tusar aints ainau nekaachmin ainawai. Turinau asaramtai apu nintimtairisha nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_4","021_25_4","PRO","25","4","4","Jiru wincha ati tusar, tseerar saurin utsanin ainiawai, nunia nu jirun piningkian shiirman najanin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_5","021_25_5","PRO","25","5","5","Turasha apu pujamunmayangka pase aints ainau jiikim akupakmeka, apu inamuri pujuinauka mash apun timiatrusarang umirkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_6","021_25_6","PRO","25","6","6","Apu pujamunam wayaakmeka: Wikia miajuitjai tuuka nintimtumasaip. Tura aints kakaram iruna nujaingkia pachinkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR25_7","021_25_7","PRO","25","7","7","Antsu apu chichartamak: Winim juni keemsata turamat, ame pengker nintimtusam nuni keemsatnuitme. Antsu apu tichamtaikia, kakaram irunu jiiminamunam natsanpiaku wajastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR25_8","021_25_8","PRO","25","8","8","Aints turachminun turau wainkamka, wárikia chichaman nekamtikniunam nuna etserkataj tusamka weep. Turakmeka chikich aints amin pachitmas: Nuka waitaitai tamataikia, ame itiurkachmin nekapeakum natsaartinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR25_9","021_25_9","PRO","25","9","9","Amin pachitmasar wait chichaman etserinamtaikia, nuchawaitai tusam chichaman iwiaarata. Antsu chikich aints ainau chichaman uukar amin etsertaminamtaikia, un pachisam chichakaip. ");
INSERT INTO acuNT_vpl VALUES ("PR25_10","021_25_10","PRO","25","10","10","Turachkumka chikich aints ami chichakmaurmin antuk amin pachitmas natsanpiakun etserkatnuitai. Turamtai ame iwiaarachmin asam, itiurkachmin pujakum natsaartinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR25_11","021_25_11","PRO","25","11","11","Pengker chichaman antujamniaun etsermauka pining shiiram iwiaaramua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_12","021_25_12","PRO","25","12","12","Aints paan nintimniuka chikich aintsu chicharkamurin takamtaik antawa nuka nungkutai nekas pengker kuri najanamua tumawaitai. Turasha uwejnum uwejtai kuri najanamua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_13","021_25_13","PRO","25","13","13","Aints anangmichuka arák wekaas, pengker chichaman itiawa nuka ni akupamurin waramtiksatnuitai. Turasha esat amaunum aints entsa atsamunam arák wekaas yaweru pujamtai, chikich aints entsa michan itawa nunisang ni akupamurin waramtiksatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_14","021_25_14","PRO","25","14","14","Aints nangkami waitrak: Ukunam susamjinam tayat, sutsuk puja nuka nase nasentak kintuim, yumi jitutsuk pujaa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_15","021_25_15","PRO","25","15","15","Aints ni apurin jaimiasar chicharinamtai, apu ni kajekmaurin inaisatnuitai. Turasha yaitasar chichainauka katsuram nintiniunka pengker nintimtikrartniutia. ");
INSERT INTO acuNT_vpl VALUES ("PR25_16","021_25_16","PRO","25","16","16","Wapasa yumirin wainkamka, jumchik mukunata. Nukap mukunamka iniuktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR25_17","021_25_17","PRO","25","17","17","Ame irutkamurmin jiistasam ni jeen nukapka wayaawaip. Nukap wayaakminka yawetramar nakitramratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_18","021_25_18","PRO","25","18","18","Aints ni irutkamurin pachis wait chichaman etsera nuka kuchí erea tumawaitai, turasha nangki erea tumawaitai, turasha weartaia tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_19","021_25_19","PRO","25","19","19","Itiurkachminum pujakur, chikich aintsu chicharkur: Ayamrukta takurkia, ni ayu tayat, yaingkratchau asa, nai shuki yuamua tumawaitai, turasha nawe muunkamua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_20","021_25_20","PRO","25","20","20","Aints yaweru pujamtai wararkur kantamtai kantamruatnuka aints tsetsemak wejmakrin aik misu pujawa tumawaitai, turasha charumakmaunam ween yakaawa tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_21","021_25_21","PRO","25","21","22","Atumi nemase yaparinamtaikia yurataram, tura kitaminamtaisha umutisha artaram. Tu pujakrumka pase awajtamina nuna inatsartinuitrume. Turasha Yus atumin pengker awajtamsatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("PR25_23","021_25_23","PRO","25","23","23","Nase arakia nasentak yumin itaawa nunisang aujmatkartinka aints ainaun napchau nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_24","021_25_24","PRO","25","24","24","Jea shiiram iwiaaramunam jiyanin nuwajai maaniniak pujustinka mianchawaitai. Antsu jea tuupchinam ningki pujustinka timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_25","021_25_25","PRO","25","25","25","Yajaya pengker chicham akupkamu antuktinka nekas kitamamunam entsa micha umurtinka mai metek nekas pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_26","021_25_26","PRO","25","26","26","Aints anangmichuka pase aintsun shamak un chichamen antuk kurawa nuka nungka taimunmaya entsa pakui jinua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_27","021_25_27","PRO","25","27","27","Wapasa yumirin nukap mukunatniuaka napchawaitai. Tura wikia miajuitjai tumamtinka nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR25_28","021_25_28","PRO","25","28","28","Aints ni wakeramurin tuke najanatas wakerakka, yakta wenukri meseawa tumawaitai. Yakta wenukri meseramtai, nemase ainau nu yaktanmaka tuke pachitsuk wayaawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_1","021_26_1","PRO","26","1","1","¿Esat amaunum micha kaya tumau ayaartin pengkerkai? ¿Tura juuktin kintia jeamtai, yumi jiturti timinkai? ¿Turasha aints netsen wainkar tikishmatrar: Ameka juuntaitme timinkai? ");
INSERT INTO acuNT_vpl VALUES ("PR26_2","021_26_2","PRO","26","2","2","Chingki tura chinim nangkami juni we tura atu we: ¿Tuning wetaj? tusa nintimtsui. Tura aints chikich aintsun tichamin ayat: Usukiajme ta nuka nangkami tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_3","021_26_3","PRO","26","3","3","Kawai umirtukti tusar chapikjai awatrartin ainawai. Tura burro tupikiaki tusar jingkiawartin ainawai. Tura aints netsenka antukat tusar numijai katsumkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_4","021_26_4","PRO","26","4","4","Aints nintimchawa nuka amin nintinchau chichartamak pujamtaikia, ni chichaawa nunismeka aimkaip. ");
INSERT INTO acuNT_vpl VALUES ("PR26_5","021_26_5","PRO","26","5","5","Aints nintimchawa nuka chichartamak: pujamtaikia, amesha nunismek aimkakminkia, nuka: Wisha nintipitjai tu nintimias pujusminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_6","021_26_6","PRO","26","6","6","Aints nintimchaun: Ame tawai tusam tita tusa chichaman akupua nuka aints ni nawen awatmamak pujawa nunisketai. Turasha aints umutai jatan umawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_7","021_26_7","PRO","26","7","7","Aints nintimchau nuikiar tutai chichaman etsera nuka aints makuin kupinak ashua ashua wekaawa tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_8","021_26_8","PRO","26","8","8","Aints ainau netse aintsun wainkar: Ame nintipitme tinu ainauka kaya merman jukiar, chingki maatainam engkear nangkimina nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_9","021_26_9","PRO","26","9","9","Aints nintinchau nuikiar tutai chichaman etsera nuka aints nampek jangkin pachitsuk achiawa tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_10","021_26_10","PRO","26","10","10","Aints netsen chicharak: Wijai takakmasta tauka aints tishimkun achik aints nangkaminaun pachitsuk ekettuk tukuawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_11","021_26_11","PRO","26","11","11","Aints nintinchau tuke nintimtsuk chichak pujawa nuka yawaa inukiat ataksha wakeki ni iniukmaurinak yuwawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_12","021_26_12","PRO","26","12","12","Aints ningki nintimtumas: Nintipitjai tumamua nuka pengké yapajiachminuitai. Antsu aints nintinchaun Yus wakerakka yapajiamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_13","021_26_13","PRO","26","13","13","Aints nakia nuka takatan nakitau asa, juun yawaa nekas kajeu jintanam wekaawai, tu pujuwaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_14","021_26_14","PRO","26","14","14","Waiti epentairi uraimua nuka mai yantá mai yantá muchiawa nujai metek naki aints ni peakrin tepes mai yantá mai yantá tepes kánawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_15","021_26_15","PRO","26","15","15","Aints nakia nuka tachaun achiayat, yutairin yuatniunka takataitai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_16","021_26_16","PRO","26","16","16","Aints nakia nuka ningki nintimtumas: Wikia siete nekau aints aina nuna nangkamasnak nintipitjai tumamui. ");
INSERT INTO acuNT_vpl VALUES ("PR26_17","021_26_17","PRO","26","17","17","Aints jimiar jiyanikiar wajainamtai, chikich aints untsuachmaitiat nuni pachinkauka yawaa kuwishnum achikiar takutnua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_18","021_26_18","PRO","26","18","19","Aints ni irutkamurin anangkayat: Wikia aya nakurusan nangkami timiajai ta nuka, waurin nangkin ekettuk aintsnum nangkimua nunisketai. Turasha aints nangkin jinum kiaparti tusa jeanam nangkimua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_20","021_26_20","PRO","26","20","20","Ji keemaktin atsamtaikia, ji kajintratnuitai. Turasha aujmakratin atsamtaikia, kajernaiyamuka atsutnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_21","021_26_21","PRO","26","21","21","Ji kairi amataikia, ji wári kiapartinuitai. Tura keemaktinka atsamtaikia, jikia kapaichminuitai. Turasha aints maaniktas wakerin pujamtaikia, aints ainau wári kajernaikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_22","021_26_22","PRO","26","22","22","Aujmakratniu chichamengka yuta yuuminua nunisketai. Turasha nu chichaman nintinam ukusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_23","021_26_23","PRO","26","23","23","Aints chikich ainaun pase awajsatas wakerayat antujamniun chichauka muits jakukutiat shiiram ati tusa patatkeng ipiakjai yakarmawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_24","021_26_24","PRO","26","24","25","Aints chikich ainaun kajerak pujauka nekaaracharti tusa pengker chichaayat, pase nintimias pujawai. Tura: Wikia aneajme tau wainiatum, nekasashi tiip. ");
INSERT INTO acuNT_vpl VALUES ("PR26_26","021_26_26","PRO","26","26","26","Nu aintska ni kajekmaurinka uuktas wakerau wainiat, aints ainau mash paan nekaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_27","021_26_27","PRO","26","27","27","Aints chikich aintsun pase awajsatas wakerakka, nu aintska waa taimunam ayaarti tusa, waan taimia nuni ningki ayaartinuitai. Tura aints chikich aintsun mesratas pampa wakenam kankekati tusa wakerakka, ningki nekemaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR26_28","021_26_28","PRO","26","28","28","Aints tsanumniuka chikich aints ainaun pase awajsatas wakerau asa, nekas chichaman nakitawai. Tura aints nangkami anangkak: Aneajme ta nuka aints ainaun pachimian nintimtikratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_1","021_27_1","PRO","27","1","1","Kashin wi warukatjak tusam nekachu asam: Wikia kashin nunaka turatatjai tuuka nintimraip ");
INSERT INTO acuNT_vpl VALUES ("PR27_2","021_27_2","PRO","27","2","2","Amek anenmamsam: Wikia pengke aintsuitjai tiip. Antsu chikich aints ainau turutiarti tita. ");
INSERT INTO acuNT_vpl VALUES ("PR27_3","021_27_3","PRO","27","3","3","Kaya ainau tura yaikmisha meram asar, aints ainauka nuna entsakaramtai itit awajsartin ainawai. Tura netse kajetirisha aints ainaun nuna nangkamasarang itit awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_4","021_27_4","PRO","27","4","4","Aintsu kajetirisha aints ainaun mesrartin ainawai. Tura aints nuwan kasmatina nunasha ¿yáki atsantrat? ");
INSERT INTO acuNT_vpl VALUES ("PR27_5","021_27_5","PRO","27","5","5","Aints ainaun chichaman uutsuk chicharkatniuka niin uukar aneetniunka nangkamasang pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_6","021_27_6","PRO","27","6","6","Ii amikri iin anenmau asa, paan chichartamak: Ame turame nuka paseetai turama nuka pengkeraitai. Antsu ii nemase anangmak: Ameka pengke aintsuitme tayat ¿nekasash taj? tusam nekaachminuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR27_7","021_27_7","PRO","27","7","7","Aints tutuaruka wapasa yumirincha nakitawai. Tura aints yaparak pujus, yapaunasha yuwayat, yuminua nunisketai tusa nekapratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_8","021_27_8","PRO","27","8","8","Chingki ni pasungkenia jiinki yaja weawa nuka aints ni nungkenia jiinki wekaakini wajawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_9","021_27_9","PRO","27","9","9","Kungkutin ukatmamkar pengker awajmamsartinuitji. Turasha ii amikri iin chichartaminak: Pengker pujusatasam wakerakmeka tu pujusta tina nuka ii nintincha kiakatmartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_10","021_27_10","PRO","27","10","10","Amikrumsha tura aparmi amikrisha pengke ukukiip. Tura itiurkachminnum pujakmeka yachimi jeenka weep. Ii irutkamuri arakchichu pujuina nuka ii yachi arak puja nuna nangkamasarang kakarmachu iin yaingkratin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_11","021_27_11","PRO","27","11","11","Uchiru, nekau ata. Turakmeka waramtikrustinuitme. Tura asakmin wina pase chichartin ainaunka natsamtsuk aimkatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_12","021_27_12","PRO","27","12","12","Aints nintipkia nuka itiurkachminiun wainak ayamrumaktinuitai. Antsu aints nintimchauka iturkachminiun waintsuk wait wajaktinnum wetinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_13","021_27_13","PRO","27","13","13","Aints nekashtai tumashmamtai, chikich aints: Wi akimiakatatjai tamatikia, nuna wejmakrin aitkam, jurukim ukusta. ");
INSERT INTO acuNT_vpl VALUES ("PR27_14","021_27_14","PRO","27","14","14","Aints kashik ni amikri jeen we kakaram untsumak: ¿Tsawaarumek? tamataikia, nuka itit awajtustas tatsuash tu nintimratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_15","021_27_15","PRO","27","15","15","Nuwa jiyakratnuka kinta yumi tsawaamunam makis kitiak itit awajkartinua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_16","021_27_16","PRO","27","16","16","¿Nasengka metatniukai? ¿Tura uwejjai asaitisha achikminkai? Atsa. Turasha nu nuwa jangkenka pengke metachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_17","021_27_17","PRO","27","17","17","Aints ainau jirun chikich jirujai tsakatin ainawai. Turasha jimiar aints mai nuwamtak chichasar pujusar yainikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_18","021_27_18","PRO","27","18","18","Aints arakan araak pengker wainua nuka nerencha yuatnuitai. Tura ni juuntrincha pengker wainua nuka niincha pengker awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_19","021_27_19","PRO","27","19","19","Aints ainau ni yapiin entsanam paan wainu wenawa nunisarang aints anturnaikiar itiur nintimina nunasha paan nekaamawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_20","021_27_20","PRO","27","20","20","Aints ainauka mash jakartin ainawai. Tura asaramtai iwiartainum tuke ukusartin ainawai. Antsu aints ainau ni wakeramuringkia: Nuke ati tusar metachartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_21","021_27_21","PRO","27","21","21","Aya kurik juwakat tusar, turasha aya jiruk juwakat tusar, kurisha tura jirusha pengkerashi tusar, aints ainau jiinum tseerar, jiyamun sumin ainawai. Aints ainau chikich aintsun pachisar: Warukuita tusar nekaatasar wakerinauka, aya chicharinak: Ameka pengker aintsuitme tinu ainauka kakarmachu nekaamawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_22","021_27_22","PRO","27","22","22","Netse aintsun trigo neketainam engkeawar, nekea nekea awajinamaitiat tuke netsek juwaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR27_23","021_27_23","PRO","27","23","24","Kuikiartin ainauka tukeka kuikiartinka wajasarchartin ainawai. Tura apu uchirisha tura tirangki ainausha tukeka apuka wajaschartin ainawai. Tura asaramtai ami tangkuram ainausha tenapkesam wainkata. ");
INSERT INTO acuNT_vpl VALUES ("PR27_25","021_27_25","PRO","27","25","26","Muranmaya saak mash juukakmin, yamaram saak ataksha tsapaitnuitai. Turamtai uwija uree awaram, nuwa ainau ureen kutaminak entsartintrumin wantawartin ainawai. Turinamtai chipu ainau surukam aja sumaktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR27_27","021_27_27","PRO","27","27","27","Tura amesha tura uchiram ainausha tura amijai takakminak pujuinauka kapra muntsurin umurartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_1","021_28_1","PRO","28","1","1","Papeachmaitiat pase aintska nukap sapijmiaku asa tupikiaktinuitai. Antsu pengkera nuna turinauka juun yawaaya nunisarang sapijmiatsuk wajainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_2","021_28_2","PRO","28","2","2","Pase aints yujainamtaikia, aints untsuri chikich ainaun inarartas wakerinawai. Antsu apu paan nintimniuka tura nekauka aints ainau taetet wajascharti tusa pengker inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_3","021_28_3","PRO","28","3","3","Pase aints kuikiartichu ainaun itit awajea nuka yumi nukap jitur arakan meseawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_4","021_28_4","PRO","28","4","4","Umiktin chichaman umirchau ainauka pase aintsun pachisar: Nuke pengkeraitai tinawai. Antsu umiktin chichaman umirinauka pase aints ainaun kiishmakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_5","021_28_5","PRO","28","5","5","Pase aints ainauka pengker turatniunka nekainatsui. Antsu Apu Yusen seaina nuka pengker turatniuka warimpita tusar mash nekaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_6","021_28_6","PRO","28","6","6","Aints kuikiartichu ayat, anangmichuka nekas pengkeraitai. Antsu kuikiartin pase nintimias puja nuka nekas paseetai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_7","021_28_7","PRO","28","7","7","Aintsu uchiri Yusen umiktin chichaman umirkauka, nekas paan nintimias pujawai. Antsu chikich aints aya yurumkanak wakerin ainaujai tsanias pujakka, aparin inatsartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_8","021_28_8","PRO","28","8","8","Aints kuikian ikiasuka niin tumaashmawaru ainaun chicharak: Atum akirkamarume nuna nangkamasrumek akirkataram taa nuka jakamtai, kuikian nukap ikiauntukmia nuna chikich aints wait anenkartin kuikiartichu ainaun susati tusa ukuktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_9","021_28_9","PRO","28","9","9","Aints Yusen umiktin chichaman umitan nakitamtaikia, Yus ni seamurincha antukchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_10","021_28_10","PRO","28","10","10","Aints pengke aintsun tunaun takamtikin asa, kuntin ejatkanam niapua nunisang mengkakatnuitai. Antsu tunaun nakitin ainau Yusnum pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_11","021_28_11","PRO","28","11","11","Aints kuikiartin ningki nintimtumas: Wikia nintipitjai tumamui. Antsu kuikiartichuka nintip asa, nu kuikiartinka paanka nintimtsui tusa nekamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_12","021_28_12","PRO","28","12","12","Pengker turin ainauka pase aints ainaun nepetinamtai, aints mash warasartinuitai. Antsu pase aints ainauka pengker ainaun nepetinamtai, aints mash anumkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_13","021_28_13","PRO","28","13","13","Aints ni tunaarin uwauka pengkerka pujuschamnawaitai. Antsu ni tunaarin ujaak nunia inaiyamtaikia, Yus tsangkuratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_14","021_28_14","PRO","28","14","14","Yusen tuke umirak puja nuka nukap warastinuitai. Antsu Yusen umiitan nakitauka itiurkachminnum wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_15","021_28_15","PRO","28","15","15","Apu pase nintiniuka ni aintsri kuikiartichu ainaun wait anentsuk inawa nuka juun yawaa kajeu tura yaparak pujawa nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_16","021_28_16","PRO","28","16","16","Apu wait anengkratchauka: Aintsur kuikiartichu ainawai tusa nekayat, kuikian nukap akirkarti ta nuka nintinchawaitai. Antsu aints kuikian nukapka nakitauka untsuri musach angkan pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_17","021_28_17","PRO","28","17","17","Aints mangkartinka ni turamurin tuke kajinmatsuk nintimua nuka wekaakini waja wajaka jakatnuitai. Tura mangkartin asamtai, chikich aints ainau: Iijai pujusmi tichartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_18","021_28_18","PRO","28","18","18","Aints anangmichuka itiurkachminnum pujayat, angkan wajastinuitai. Antsu pase nintiniuka itiurkachminnum aneachmau mengkakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_19","021_28_19","PRO","28","19","19","Aints ni ajarin takakmawa nuka tsukamashtinuitai. Antsu naki ainaujai tsanias wekawa nuka kuikiartichu wajastinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_20","021_28_20","PRO","28","20","20","Aints anangmichun pachisar chikich aints ainau: Nuke pengke aintsuitai tiartin ainawai. Tura chikich aints waurak wári kuikiartin wajastas wakerakka, wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_21","021_28_21","PRO","28","21","21","Aints ainauti mash metek ainaji. Turayatrik aints yaparak tantan kasamak juwawa nuna pachis: Nu aintska paseetai tichamin ainaji. ");
INSERT INTO acuNT_vpl VALUES ("PR28_22","021_28_22","PRO","28","22","22","Aints wári kuikiartin wajastas wakerayat: Ukunmaka kuikiartichu wajastinuitjai tusangka nekaachminuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_23","021_28_23","PRO","28","23","23","Aints chikich aintsun chicharkamia nuna pachis ukunam: Nuka pengke aintsuitai titinuitai. Tura chikich aints anangkak: Ameka pengke aintsuitme ta nuna chichamenka wári kajinmaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_24","021_28_24","PRO","28","24","24","Aints ni aparin tura nukurincha kasarkayat: Wi turaja nuka tunaachawaitai tauka meskartinu amikrintai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_25","021_28_25","PRO","28","25","25","Wikia miajuitjai tumamtinka maaniktas wakerawai. Antsu Apu Yusen nintimtina nuka waring achat ni turina nuka mash pengker turinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_26","021_28_26","PRO","28","26","26","Aints ningki nintimtumas: Nintipitjai ta nuka nintimchawaitai. Antsu paan nintimniuka angkan pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_27","021_28_27","PRO","28","27","27","Aints kuikiartichun yayaa nuka pengké yuumakchatnuitai. Antsu kuikiartichun yaaitan nakitina nuka nukap usukramu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR28_28","021_28_28","PRO","28","28","28","Pase aints ainauka pengker aints ainaun nepetinamtai, aints ainau anumrukartin ainawai. Antsu pase aints ainau mengkakaramtai, pengker nintintin ainauka eemkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_1","021_29_1","PRO","29","1","1","Aints chikich aintsun chicharak: Tunaarum inaisata tusa nukap chicharmaitiat, nu aintska antutsuk, tunaun inaitsuk turakka, aneachmau mengkakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_2","021_29_2","PRO","29","2","2","Pengker nintintin ainau ni yaktarin eemtikinamtaikia, aints ainau warainawai. Antsu pase aints ainau chikich ainaun ínainamtaikia, chikich aints ainau wait wajainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_3","021_29_3","PRO","29","3","3","Natsa nekas paan nintimias pujakka, aparin waramtikui. Antsu natsa kungkatpijai tsanias pujauka apari kuikiarin nangkami ajapui. ");
INSERT INTO acuNT_vpl VALUES ("PR29_4","021_29_4","PRO","29","4","4","Inakratin ni aintsri ainaun nekas pengker inauka ni yaktarin eemtikiatnuitai. Antsu chikich inakratniuka ni aintsri ainaun tuke: Akirkataram ta nuka ni yaktarin mesratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_5","021_29_5","PRO","29","5","5","Aints tuke nangkami anangkak chikich aintsun chicharak: Ameka pengke aintsuitme tauka aints kuntinun achiktas ejatkan ejatua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_6","021_29_6","PRO","29","6","6","Aintsu tunaari ainauka aints kuntinun achiktas ejatkan najanawarua nunisarang ainawai. Antsu anangmichu ainauka pengker nintimsar warasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_7","021_29_7","PRO","29","7","7","Aints pengker nintintin ainauka kuikiartichu ainau yuumamurin nintimsar pujuinawai. Antsu pase aints ainauka nunaka pengké pachinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR29_8","021_29_8","PRO","29","8","8","Aints taetet awajsartin ainauka yaktanam pujuinaun itit awajsartin ainawai. Tura paan nintimtin ainauka aints ainau kajernaiyamuri atsuti tusar pengker chichasartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_9","021_29_9","PRO","29","9","9","Aints paan nintimniuka netse aintsjai chichaman nakuirtas chicham iwiaaratniunam weak, netseka niin wishiku pujamt kajerkatnuitai. Antsu nuniangka chichaman iwiaaratatkama pengké tujintawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_10","021_29_10","PRO","29","10","10","Mangkartin aints ainauka aints anangmichun wainkar nukap kajerkatin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_11","021_29_11","PRO","29","11","11","Aints netseka pachitsuk ni wakeramurin najanui. Antsu paan nintintin ainauka ni wakeramurin metatin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_12","021_29_12","PRO","29","12","12","Aintsu apuri wait chichaman pachitsuk anturak pujakka, ni inatiri ainaun mash pasemamtikiatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_13","021_29_13","PRO","29","13","13","Aints yamrumichun tura niin itit awajniuncha Apu Yuska mai metek ni jiijai ni turamurin jiisarti tusa najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("PR29_14","021_29_14","PRO","29","14","14","Inakratin kuikiartichu ainaun mash metek pengker awajua nuka tuke ni aintsri ainaun pengker inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_15","021_29_15","PRO","29","15","15","Uchi ainaun paan nintimin arti tusar chicharkartinuitai. Tura chicharmasha antichu ainaunka awatrartinuitai. Tura waininayat uchi pachishtai ainauka nukurin inatsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_16","021_29_16","PRO","29","16","16","Pase aints ainau yujainamtaikia, tunausha nukap yujaawai. Antsu anangmichu ainauka pase aints ainau mengkakatniurin wainkartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_17","021_29_17","PRO","29","17","17","Uchiram chicharkumka amin pengker nintimtikramratnuitai. Turamtai ni jiisam warastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR29_18","021_29_18","PRO","29","18","18","Yuse chichame etserin atsamtaikia, aints ainau pachitsuk tunaun takainawai. Antsu Yuse chichamen umirinauka nekasar pengker nintimsar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_19","021_29_19","PRO","29","19","19","Aints ni inatirinka aya chichasang nuiniarchatnuitai. Kame, antayatang umirkashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_20","021_29_20","PRO","29","20","20","¿Aints wárik chichaun wainukaitam? Kame, aints nintimchau ainauka niin nangkamasarang nuimiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_21","021_29_21","PRO","29","21","21","Aints ni inatirin uchichinak tsakatmaruka ukunam ni tsakatkaringkia ni wakeramurinak najanatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_22","021_29_22","PRO","29","22","22","Aints kajeuka tuke maaniktas wakerawai. Tura nu aintska tunaun nukap turatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_23","021_29_23","PRO","29","23","23","Aints ningki nintimtumasang: Miajuitjai taunka Yuska: Ameka mianchawaitme tawai. Antsu aints: Mianchawaitjai tumamunka Yuska: Miajuitme tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_24","021_29_24","PRO","29","24","24","Aints kasa aintsjai tsanias wekaas kasamua nuka ninki wiasmamkatnuitai. Tura aints ainau niin chicharinak: Ame nekame nuka Yusjai tajai tusam etserkata tinamaitiat pengké etsertsui. ");
INSERT INTO acuNT_vpl VALUES ("PR29_25","021_29_25","PRO","29","25","25","Aints ainaun shaminauka chingki ejatkanam achikmawa nunisarang ainawai. Antsu Apu Yusen nintimratin ainauka ejamkaru ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_26","021_29_26","PRO","29","26","26","Aints untsuri aya apurinak wait anentrurti tusar seainawai. Antsu Apu Yusen seaina nuka angkan pujusartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR29_27","021_29_27","PRO","29","27","27","Pengke aints ainauka pase aints ainaunka nakitinawai. Tura pase aints ainauka anangmichu ainaunka nakitinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_1","021_30_1","PRO","30","1","1","Jakeh uchiri Agurka Ithielan, tura Ucalnasha ju chicham ainaun ujakmiayi. Nuka Masanmaya aintsuyayi. ");
INSERT INTO acuNT_vpl VALUES ("PR30_2","021_30_2","PRO","30","2","2","Wikia nekasan chikich aints ainaun nangkamasnak timiá nekachuitjai. Aintsu nintimtairingkia winaruka atsawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_3","021_30_3","PRO","30","3","3","Wikia paan nintimratniuncha nuimiatrachuitjai. Turasha Yuse nekatiringkia nekachuitjai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_4","021_30_4","PRO","30","4","4","¿Ya nayaimpinam waka, ataksha taramiayi? ¿Ya ni uwejejai nasen metamnawaita? ¿Ya juun entsanka tarachjai pempeawa? ¿Nungka mash irunina nuna najankauka yáki? ¿Ni naarisha yaita? ¿Tura uchirisha yaachita? ¿Ameka nuka nekamek? ");
INSERT INTO acuNT_vpl VALUES ("PR30_5","021_30_5","PRO","30","5","5","Yuse chichamengka nekasaintai. Tura asamtai aints ainau niin nintiminaunka Apu Yus ejaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_6","021_30_6","PRO","30","6","6","Yus ta nuke ati tusam chikich chicham patatkashtinuitme. Ame turakmeka Yus amin chichartamak: Waitaitme turamtinuitai. Turamatai waitrin wajastinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR30_7","021_30_7","PRO","30","7","7","Yusru, aya jimiarchinak seajme. Wikia jaatsain wait aneasam nuka surusta. ");
INSERT INTO acuNT_vpl VALUES ("PR30_8","021_30_8","PRO","30","8","8","Anangkartin wajasai tura wait chichaman etserin wajasai tusam nuka tsangkatrukta. Turasha kuikiartinka tura kuikiartichusha wajasai tusam nusha tsangkatrukta. Tura asam yurumak wi yuumaja nuke surusta. ");
INSERT INTO acuNT_vpl VALUES ("PR30_9","021_30_9","PRO","30","9","9","Kame, yurumkar ampintramtaikia wikia: Maj, Yusnaka yuumatsjai timinuitjai. Tura yurumkan yuumaknaka chikichnaun kasarkatnuitjai. Tura nuna turaknaka chikich aints ainau amin naarmin pachisar natsanpiakun chichasarai tusan nunaka seajme. ");
INSERT INTO acuNT_vpl VALUES ("PR30_10","021_30_10","PRO","30","10","10","Aintsu inatiri antuj wajamtai, takamtikniuri antamunam ni pachisam pase chichakaip. Nu turakminkia nuka amincha pachitmas pase chichastinuitai. Turamtai amek wiasmatramkatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR30_11","021_30_11","PRO","30","11","11","Aints aparin usukratniuka irunui. Turasha nukurin pengker awajchausha irunui. ");
INSERT INTO acuNT_vpl VALUES ("PR30_12","021_30_12","PRO","30","12","12","Kame, aints ni pase turutirin inaisachariat, ningki nintimtumasar: Wikia nekasan pengke aintsuitjai tumamin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_13","021_30_13","PRO","30","13","13","Tura chikich aints ainau jampesarang: Miajuitjai tumamsar chikich aints ainaun suwirpiaku jiisar: Nuka mianchawaitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_14","021_30_14","PRO","30","14","14","Chikich aints ainau naingkia saapia nunisarang ainawai. Tura juun nai ainausha kuchii ere tsakamua nunisarang ainawai. Tura asar ni nungkarin kuikiartichu ainaun tura yuuminak pujuinauncha amukartas wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_15","021_30_15","PRO","30","15","15","Ichachi nawantri jimiaraitai. Nuka tuke: Surusta, surusta tinawai. Tutuarchatin kampatam ainawai. Kame, nekas cuatroitai. Nuka tuke maaketai tinatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR30_16","021_30_16","PRO","30","16","16","Ju ainawai: Jakau iwiarsamuka, nunia nuwa kaamauka, nunia nungka entsa pajamrachuka, nunia ji kiapamuka, nu ainauka tuke maaketai tichamin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_17","021_30_17","PRO","30","17","17","Apartin niin yajutmarmaitiat nuna: Mianchawaitai tusa jiia nuna jiin kukui kuinkartin ainawai. Tura chiwiangku uchiri kautkar ni namangken yuwar amukartinka nekas pengker atinuitai. Turasha nukuri juuntach: Antukta tamaitiat pajaki aikratniunka nunisarang turuwaramtaikia nekas pengker atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_18","021_30_18","PRO","30","18","18","Ju cuatro ainaun antukan, nintir jearchawitai: ");
INSERT INTO acuNT_vpl VALUES ("PR30_19","021_30_19","PRO","30","19","19","Kukui itiur yakí nanamua nuka, tura napi nawe atsayat, ¿itiur pampanam wekaawa? nunasha, tura ¿juun entsanam kanu itiur nasejai wekaawa? nunasha, tura ¿aishmang itiur nuwanam tsakaawa? nunasha nintir jearchawitai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_20","021_30_20","PRO","30","20","20","Nuwa aishrintin aishrin ajapu ukuki, chikich aintsjai kanauka yutancha yuwa, jangken japirua nunisang natsamtsuk: Wikia tunaanaka turachmajai tawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_21","021_30_21","PRO","30","21","21","Ju cuatro iruna nuka tsantrachminuitai. Mash nungkanmaya ainau nuna pachisar: Nuka turachminuitai tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_22","021_30_22","PRO","30","22","22","Ju ainawai: Aintsu inatiri apu wajasua nuka, turasha aints nintimchautiat ushuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_23","021_30_23","PRO","30","23","23","Turasha nuwa aints mash tsuutina nuka aintsun ninurtuk pujauka, turasha nuwa inatiri ni inaun kintruk inawa nu ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_24","021_30_24","PRO","30","24","24","Nunia ju nungkanam cuatro timiá tuupich aina nuka aints nintip aina nuna nangkamasarang nintip ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_25","021_30_25","PRO","30","25","25","Ju ainawai: Week ainauka kakaichu ainayat ni yuwatniurin esati juukar ukuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_26","021_30_26","PRO","30","26","26","Kushi ainausha untsurinchu asar, waanam anumkar kaninawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_27","021_30_27","PRO","30","27","27","Manchi ainau apuri atsau waininayat pekaankar nanaminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_28","021_30_28","PRO","30","28","28","Shampiusha timiá yupichuwach asaramtai, uwejjai achikmin ainayat, pachitsuk apu jeen wayaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_29","021_30_29","PRO","30","29","29","Tura cuatro meemasar: Miajuitjai tumamsar wekainauka ju ainawai: ");
INSERT INTO acuNT_vpl VALUES ("PR30_30","021_30_30","PRO","30","30","30","Juun yawaa kajeuka aintsnaka tura pachim ainauncha shamchawa nuka, ");
INSERT INTO acuNT_vpl VALUES ("PR30_31","021_30_31","PRO","30","31","31","tura atashu aishmangkri jampe jampet wekainuitai. Tura chivoka aintsun paperkuta ni kuwishijai shitaktinuitai. Turasha aintsu apuri ni suntarin timiá untsuri ainaun inartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR30_32","021_30_32","PRO","30","32","32","Ameka nintimchau akumka, wikia miajuitjai tumamsam pujakum, aints ainau pase awajsatasam wakerakmeka nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("PR30_33","021_30_33","PRO","30","33","33","Waaka muntsuri macharati tusam, nukap shitakmeka muntsu machari jukitnuitme. Tura kakaram shiikmakmeka nujim numpartinuitai. Tura aints kajerkam jiyakmeka maaniktinuitme. ");
INSERT INTO acuNT_vpl VALUES ("PR31_1","021_31_1","PRO","31","1","1","Masanmaya apu Lemuel naartinu chichame ni nukuri nuiniarmia nuka juwaitai: ");
INSERT INTO acuNT_vpl VALUES ("PR31_2","021_31_2","PRO","31","2","2","Uchiru, amin jerermiajme. Wi Yusen seamtai akiinamiame. Nuna nangkamasnak ¿warinak titajak? ");
INSERT INTO acuNT_vpl VALUES ("PR31_3","021_31_3","PRO","31","3","3","Uchiru, ami kakarmaram nuwanam ajapawaip. Warí, nuwa ainauka aintsu apuri pimpiru wajasti tusar mesratin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_4","021_31_4","PRO","31","4","4","Uchiru Lemuela, apu ainauka umuti nekas kariau aina nuna umurchartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_5","021_31_5","PRO","31","5","5","Tuminamtai nampekar umiktin chichaman kajinmakiar ayamrumichu ainau wait wajainamtai, itiurchat awajkarai tusan tajame. ");
INSERT INTO acuNT_vpl VALUES ("PR31_6","021_31_6","PRO","31","6","6","Aints pimpiru ainauka tura wake mesekaru ainauka umuti kariaun umurarti tusam tsangkatkata. ");
INSERT INTO acuNT_vpl VALUES ("PR31_7","021_31_7","PRO","31","7","7","Nu aints ainauka nuna umurar ni yuumamurin tura ni wait wajakmaurincha kajinmakiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_8","021_31_8","PRO","31","8","9","Yamrumichu ainau tura yuuminak pujuinausha, tura kuikiartichu ainausha angkan pujusarti tusam nu aints ainaun pachisam chichasta turasha yamrukta. ");
INSERT INTO acuNT_vpl VALUES ("PR31_10","021_31_10","PRO","31","10","10","¿Nuwa nekas pengkera nuna yáki wainkat? Nu nuwa ainauka kaya ákik aina nuna nangkamasarang timiá wakeruktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_11","021_31_11","PRO","31","11","11","Nu nuwa ainauka nekasar timiá pengker asaramtai, aishrisha niin pengker nintimtumasar pujuinawai. Tura asar kuikian tura wariri ainauncha nangkami ajaptsuk tenapkesar jeanam ukuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_12","021_31_12","PRO","31","12","12","Turinamtai kintajai metek aishrin paseka awajtsuk pujuinau asaramtai, aishri ainau tuke pengker awajsartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_13","021_31_13","PRO","31","13","13","Nu nuwa ainauka uwija ureen sumakar, tura uruchnasha sumakar, tura kutamrar, kanetinam pujusar, tarachin najanin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_14","021_31_14","PRO","31","14","14","Nu nuwa ainauka asum asar, arakia yurumkan tura warinchu ainaun ikiaaninawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_15","021_31_15","PRO","31","15","15","Tura tsawaatsaing nantakiar ni uchirin tura ni jeen pujuinauncha yuratin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_16","021_31_16","PRO","31","16","16","Tura aja pengkeran wainkaru asar, nuna sumakar arak ainaun arawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_17","021_31_17","PRO","31","17","17","Ni kunturi kakaram ainawai. Tura asaramtai kakaram takakminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_18","021_31_18","PRO","31","18","18","Tura waririn surukar, kuikian irumramun wainkar, warutmaita tusar nekainawai. Tura kashisha lamparingkian ikianatsuk takakminawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_19","021_31_19","PRO","31","19","19","Kashisha kutaminawai, turasha tarachin najanatin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_20","021_31_20","PRO","31","20","20","Tura kuikiartichu ainaun tura yuuminak pujuinauncha ni yuumamurin suwinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_21","021_31_21","PRO","31","21","21","Micha amataikia ni weari ainauka entsati uwija uren najanamun entsarinau asar tsetseminatsui. Turinau asar warinak entsarat tusar nintimtsuk pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_22","021_31_22","PRO","31","22","22","Tura sekmati ainaun ningki najaninawai. Turasha kuikiartin entsarina nujai metek entsatin entsarartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_23","021_31_23","PRO","31","23","23","Turinau asaramtai aishrisha yaktanam chichamrin aina nujai irunin asaramtai, mash aints ainau: Nuna aishrintai tusar nekawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_24","021_31_24","PRO","31","24","24","Nu nuwa ainauka entsatai ainaun tura senta ainauncha najaninak tarachin surin ainamunam surinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_25","021_31_25","PRO","31","25","25","Tura kakaram asar, kashin wi warukatjak tusar nintiminatsui. ");
INSERT INTO acuNT_vpl VALUES ("PR31_26","021_31_26","PRO","31","26","26","Chichainaksha paan nintimsar chichainawai. Tura wait anengkratin asar, chikich ainaun nuikiartinak, yaitasar nuikiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_27","021_31_27","PRO","31","27","27","Tura ni jeen pujuinauka itiur pujuinawa tusar wainu weenawai. Turasha takakmatskeka pujuschartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_28","021_31_28","PRO","31","28","29","Ni uchiri ainau tura aishri ainausha niin pengker nintiminau asar nuwarin chicharinak: aina nuka untsuri irunui. Antsu ameka mash nuwa ainau nangkamasmek timiá pengkeraitme tinawai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_30","021_31_30","PRO","31","30","30","Nuwa shiiram ainau anangmaminak: Wikia chikich nuwa ainaun nangkamasnak timiá shiirmaitjai tumamina nuka nangkamiar tinawai. Antsu nuwa Apu Yusen umirkauka timiá pengkeraitai. ");
INSERT INTO acuNT_vpl VALUES ("PR31_31","021_31_31","PRO","31","31","31","¡Yaktanam pujuinautiram, mash nu nuwa ainaun pachisrum: Nekasar pengker ainawai titaram! ¡Tura ni turamurijai metek pengker awajsataram! Maaketai.");
INSERT INTO acuNT_vpl VALUES ("EC1_1","022_1_1","ECC","1","1","1","Extra text to get Indesign started. ");
INSERT INTO acuNT_vpl VALUES ("EC12_1","022_12_1","ECC","12","1","1","Ame natsa akumsha, amin najatmamia nu kajinmakiip. Tura najaimiatsuk pujakmesha amin najatmamia nu nintimrata. Ukunam najaimiakmeka: Wikia pengkerka pujatsjai titinuitme. ");
INSERT INTO acuNT_vpl VALUES ("EC12_2","022_12_2","ECC","12","2","2","Tsaasha tura nantusha tura yaasha paan wainme juwik ami Yusrum nintimrata. Tura yumi jiturmaunum tungkiang paan wainme juwik ami Yusrum nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("EC12_3","022_12_3","ECC","12","3","3","Ameka kuratsme juwik, tura punusam wekaatsume juwik ami Yusrum nintimrata. Tura naimsha akaatsu juwik tura jiimisha kusuatsu juwik ami Yusrum nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("EC12_4","022_12_4","ECC","12","4","4","Juuntach wajakmikia ameka jeá pujutnuitme. Tura antichu asam aanum takakminausha antukchatnuitme. Tura nanamtin shiniinausha antukchatnuitme. Tura aints kantan kantaminausha antukchatnuitme. ");
INSERT INTO acuNT_vpl VALUES ("EC12_5","022_12_5","ECC","12","5","5","Tura jea yakí wakatatkamam ayaarai tusam shamkatnuitme. Tura jinta wekaakmesha ayaartinuitme. Tura jakamin nekapeakum yutasha nintimtsuk pujustinuitme. Tura aints ainau amin nintimturmasar: Yamaiyapi jakatatua tusar nukap juutiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("EC12_6","022_12_6","ECC","12","6","6","Tura asam iwiaaku pujame juwik Yusrum nintimrata. ");
INSERT INTO acuNT_vpl VALUES ("EC12_7","022_12_7","ECC","12","7","7","Ame jakamka namangmeka nungka najanartinuitai. Tura Yus wakanmin suramsau asa, ataksha Ni jukitnuitai. ");
INSERT INTO acuNT_vpl VALUES ("EC12_8","022_12_8","ECC","12","8","8","Wi nekau asan tajame: Aints ainauka mash nangkamiar pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("EC12_9","022_12_9","ECC","12","9","9","Tura nekau nekas chichaman nekau asa, aints ainauncha ni nekaamia nuna nuiniarmiayi. Tura nuikiartutai chichamnasha untsuri aar nunasha antumtikiamiayi. Tura warina takua tawa tusa aints ainaun nekamtikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("EC12_10","022_12_10","ECC","12","10","10","¿Tura aints ainaun warí chichamnak ujaktaj? tu nintimias ni chichamen timiá paan ati tusa nintimramiayi. Tura nekas chicham paan ati tusa nintimramiayi. ");
INSERT INTO acuNT_vpl VALUES ("EC12_11","022_12_11","ECC","12","11","11","Nintip ainau chichaman chichainamtaikia, aints ainau te paan antukar nintimrar pujuinawai. Tura aints nintipka nekas chichaman pengké kajinmakchamniaun etserui. ");
INSERT INTO acuNT_vpl VALUES ("EC12_12","022_12_12","ECC","12","12","12","Turamtai nu chichaman antukaru asar, aints ainau timiá pengker pujusartinuitai. Papi untsuri najanatnuka pengké umischamnawaitai. Kichik umisar ataksha chikich najanatnuitai. Tura papi jiajiaka yawetrarminuitai. ");
INSERT INTO acuNT_vpl VALUES ("EC12_13","022_12_13","ECC","12","13","14","Yus iincha ii pengker turamurin pachis, tura ii pasé turamurincha pachis mash ininmastinuitji. Iikia uukar pasé aa nu turakrinka, Yuska mash aa nuna nekau asa, nuna pachischa iincha ininmastinuitji. Tura asamtai Yus nintimrata. Tura ni chichame umirkata. Nuna nangkamasang pengker pujustinka atsawai. Nunia tita tamauka atsawai.");
INSERT INTO acuNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ju papikia Jesucristo pachisar aarmawaitai. Jesucristo Davidta weari ayayi. Tura Davidcha Abrahama weari ayayi. Tura Abrahama weari ainau, tura Davidta weari ainau naaringkia ju papinum aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham Isaacan yajutmarmiayi. Tura Isaac Jacobon yajutmarmiayi. Tura Jacob Judán tura Judá yachí ainauncha yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tura Judá Tamaran nuwatak, ni uchirin Faresan tura chikich uchirin Zara naartinun yajutmarmiayi. Tura Fares Esroman yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Tura Esrom Araman yajutmarmiayi. Tura Aram Aminadaban yajutmarmiayi. Tura Aminadab Naasónkan yajutmarmiayi. Tura Naasón Salmónkan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Tura Salmón Rahaban nuwatak Boozan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Tura Isaí apu Davidtan yajutmarmiayi. Davidka Israela apuri ayayi. Tura David Uríasa nuwarin nuwatak, ni uchirin Salomónkan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Tura Salomón Roboaman yajutmarmiayi. Tura Roboam Abíasan yajutmarmiayi. Tura Abías Asan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Tura Asa Josafatan yajutmarmiayi. Tura Josafat Joraman yajutmarmiayi. Tura Joram Oseasan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Tura Oseas Jotaman yajutmarmiayi. Tura Jotam Acazan yajutmarmiayi. Tura Acaz Ezequíasan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Tura Ezequías Manasésan yajutmarmiayi. Tura Manasés Amónkan yajutmarmiayi. Tura Amón Josíasan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tura Josías Jeconíasan tura Jeconíasa yachí ainaun yajutmarmiayi. Tura Babilonianmaya apuri Israel ainaun nepetkau asamtai, Israel ainaun achikiar Babilonianam jukiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tura Jeconías nuni pujus Salatielan yajutmarmiayi. Tura Salatiel Zorobabelan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Tura Zorobabel Abiudan yajutmarmiayi. Tura Abiud Eliaquiman yajutmarmiayi. Tura Eliaquim Azoran yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Tura Azor Sadócan yajutmarmiayi. Tura Sadóc Aquiman yajutmarmiayi. Tura Aquim Eliudan yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Tura Eliud Eleazaran yajutmarmiayi. Tura Eleazar Matánan yajutmarmiayi. Tura Matán Jacobon yajutmarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Tura Jacob Josén, Marí aishrin yajutmarmiayi. Marísha Jesúsan jurermiayi. Tura Jesúska Yus akupkamu asamtai Mesías inaikiamuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tura Jesúsa weari Abrahamnumia nángkamas Davidnum jeatak catorce (14) weari inaikiamu armiayi. Tura Davidnumia nángkamas Israel ainau Babilonianam achikmau jeakuri catorce (14) wearisha inaikiamu armiayi. Nuni nángkamas Mesíasjai mash irumram ataksha catorce (14) weari inaikiamu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jesucristo tu akiinamiayi. Jesúsa nukuri Marín nuwatkataj tusa, José niin chichasmiayi. Tu chichasar kanakar pujuinai, Yuse Wakani kakarmarijai Marí japrukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Marí japrukamtai, José nuna nekaa, pengker nintintin asa, aints ainau nuna nekaawarai tusa, takamtaik uuk inaisatas wakerimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Tu nintimias pujamtai, Yuse awemamuri Josén karanam wantintukmiayi. Tura chicharak: —Joséya Davidta weariya, ame chichasmaurum María japruku wainiatmek natsaamtsuk jeemin jukita. Yuse Wakani aitkamu asa japruki. ");
INSERT INTO acuNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Tura asamtai uchin jurertatui. Turamtai nu uchikia aints ainaun tunaanumia uwemtikratin asamtai, nu uchikia Jesús inaikiatatme, —timiayi. Nuna naaringkia Uwemtikiartin taku tawai. ");
INSERT INTO acuNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nu turunatnunka yaanchuik Yuse chichamen etserin aarmia nunisang umikmiayi. Nu aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Antuktaram. Nawan aintsjai tumichu japruktinuitai. Tura asa uchin jurertinuitai. Tura uchin Emanuel inaikiatnuitai”. Nuna ta nuka “Yus iijai pujawai” taku tawai. ");
INSERT INTO acuNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Turamtai José shintar, Yuse awemamuri timiaun miatrusang umikmiayi. Tura Marín ni jeen jukimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Tura uchi eemkauri akiintsaing, ni jeen jukiyat, nijaingkia tumatsuk pujus, Marí uchin jurermiayi. Tura uchin jurer, naarin Jesúsan inaikiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Herodes Judea nungkanam apu pujai, Jesús Belén yaktanam Judea nungkanam akiinamiayi. Jesús akiinau asamtai, nekau aints ainau tsaa taakmanumanini jiinkiar Jerusalénnum jearmiayi. Tura apu Herodes pujamunam jear, ");
INSERT INTO acuNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Herodesan iniinak: —¿Judío apuri akiina nusha tuning puja? Iikia tsaa taakmanumanini angkuaji wainkau asar, apu akiinayi tusar: Ameka Apu wajastatme titasar winiji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tinamtai apu Herodes nuna antuk: Wikitjai apunka tusa, napchau nintimramiayi. Turamtai Jerusalénnum pujuinausha mash napchau nintimrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Tura asaramtai apu Herodeska sacerdote juuntri ainaun mash untsuk, tura Moisésa chichame nuikiartin ainauncha mash irur: —¿Tuning akiinatnuita Cristoa? —tu iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Tu iniam, Yuse chichamen etserin tu aarmau asamtai aiminak: —Belén yaktanam Judá nungkanam nuni akiinatnuitai. Cristo akiinatniuri pachis aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yus chichaak: “Judá nungkanam yakat Belén tutai mianchauka achatnuitai. Antsu nu yaktanam juun apu akiinatnua nuka Israela weari ainaun inartinuitai. Tura asamtai nu yaktaka chikich yakat Judá nungkanam aa nuna nangkamasang juun atinuitai”. Yus timiayi. Tu aarmawaitai, —tusar aimkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Tu aiminamtai, apu Herodes nekataj tusa, nekau ainaun tsaa taakmanumanini winiarmia nunaka akanak juki: —¿Angkuajisha nekasrumsha warutia wainkamarume? —tu iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tura nuna nekaa, Belén yaktanam awemak: —Nuni wetaram. Turaram uchi pujatsuash tusaram, tenapkesrum nekaataram. Tura wainkaram umisrum waketkiram winasha ujatkataram. Turakrumin wisha wena uchin: Ameka apu wajastatme, titasan wakerajai, —anangkak timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Apu Herodes tu akatramu asar, nekau ainau apu jeenia jiinkiar, Belénnum wearmiayi. Tura jinta weenak, angkuajin tsaa taakmanumanini wainkarmia nunaka ataksha wainkarmiayi. Tura nuna wainkar nukap warasarmiayi. Tura uchi pujamunam tupnik angkuaji ketun jiisar, nuke wear jean wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Tura jean wainkar nuni wayaawar, uchi nukuri Maríjai pujuinaun wainkarmiayi. Tura wainkar tikishmatrar: —Ameka apu atatme, —tiarmiayi. Tura kichik kichik ni kajurin urakar, ni kajurinia kurin, tura keematai kungkurman, nunia shirikpin mirra tutain uchin susarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Tura arum kashi kaninamtai, Yus nu nekau aints ainaun karanam chicharak: —Judío apuringkia ujatsuk, tupnik atumi nungkari waketkitaram, —timiayi. Tu timiau asar, chikich jintak ni nungkarin waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Nekau ainau waketkiaramtai, Yuse awemamuri Josén karanam aneachmau wantintukmiayi. Tura chicharak: —Joséya nantakta. Tura nantakim uchi nukurijai jukim, Egipto nungkanam weta. Apu Herodes uchin eak maatas wakerau asamtai turata. Tura nuni pujakmin, waketkita tusan ujaktatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Tamati Josésha wári nantaki, uchin nukurijai juki, kashi Egipto nungkanam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Tura Egiptonam jear: Herodes jakamtai waketkimi tusar nakasarmiayi. Nu turatnunka pachis yaanchuik Yus ni chichamen etsernun aamtikramiayi. Yus nuna miatrusang umikti tusa turamiayi. Nu aarmauka nuwaitai: “Egipto nungkanmaya wina Uchirun untsukmiajai”. ");
INSERT INTO acuNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Apu Herodes nekau ainaun taarti tusa naka nakaka ni tacharamtai, wina anangkrua tusa, nukap kajekmiayi. Tura nekau ainaun: ¿Angkuajin warutia wainkamarume? nuwik tu iniasu asa, nuna paan nekaa, ni suntarin akupak: “Uchi aishmang yamai akiinau ainau tura yamai wekaarau ainausha, tura yamai chicharu ainausha, tres musach jeatak Belén yaktanam pujuinau, tura arakchichu pujuinausha mash amuktaram”, tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Tu akatramu asar, uchi ainaun mash maawarmiayi. Nu uchi ainaun maamurin pachis Yuse chichamen etserin Jeremías yaanchuik aarmia nuna miatrusarang umikiarmiayi. Nu aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ramá yaktanam nuwa kakar juutmau antuukatnuitai. Nuwa juutu puja nuka Raquelaitai. Ni uchiri mash amutkamu asa, jikiamak kakar juutui. Antsu jikiamtsuk asata tinamaitiat antatsui”. Tu aarmawaitai. Nu aarmauka apu Herodeska akiintsaing, ukunam atiniun pachis aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tura apu Herodes jakamtai, José Egiptonam pujai, Yuse awemamuri nayaimpinmaya ataksha tari, karanam wantintuk chicharak: ");
INSERT INTO acuNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“Joséya nantakta. Uchin maatas wakerimia nuka yanchuk jakau asamtai, uchi nukurijai jukim Israel nungkanam waketkita”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Tamati José nantaki uchin nukurijai juki, Israel nungkanam waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Tura nuni jear, ni apari jakau asamtai, Herodesa uchiri Arequelao naartin Judea nungkanam aints ainaun inawai tamaun antuk, José nuni wetan shamiayi. Tura karanam: Israel nungkanam weep timiaun antuku asa, Galilea nungkanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Tura Galilea nungkanam pujustas, Nazaret yaktanam wemiayi. Nu turunamuka yaanchuik Yuse chichamen etserin timiaun miatrusang umikmiayi. Nu Jesúsan pachis timiauka nuwaitai: “Nazaretnumia aintsuitai tiartinuitai”. ");
INSERT INTO acuNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Jesús tuke Nazaretnum pujamtai, imiakratin Juan Judea nungkanam taa, numi atsamunam Yuse chichamen etsermiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Tura aints ainaun chicharak: —Yus aints ainaun nayaimpinmaya inartin kinta jeau asamtai, atumi tunaari inaisaram tuke Yus nemarkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Yaanchuik Juankun pachis Yuse chichame etserin Isaías aarmia nuna miatrusang umikmiayi. Nu aarmauka nuwaitai: Numi atsamunam aints taa kakar chichaak: “Aints ainau apu wekaasatniun jintan tupin iwiarina nunisrumek atumi ninti iwiarataram”, timiayi. Tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan kamiyu uren kachumnuyayi. Tura peetirincha nuwap najanamun peeyayi. Tura manchincha yuyayi. Tura wapasa yumirincha uminuyayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tura Yuse chichamen etsermatai, Jerusalénnumia aints ainau, tura Judea nungkanmaya ainausha, tura Jordán entsanam arakchichu pujuinausha untsuri Juan etsermaun antukartas kaunkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Tura aints ainau: Yus wína tunaarun sakturat tusar ni tunaarin etserkaramtai, Juan nu aints ainaun Jordánnum imaimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Turamtai fariseo ainau, tura saduceo ainausha untsuri Juan aints ainaun imiaamun jiisartas kaunkarmiayi. Tura kaunkaramtai, Juan nu aints ainaun chicharak: —Atumka napia tumau ainarmincha ¿yaachia atumin mairam uwemratatrume turamiarume? Atumka nangkamrum: Wisha mainka uwemrainjapi, tura Yuska winaka wait wajaktinnaka suruschaintapi ¿tu nintimsarmesha pujarme? ");
INSERT INTO acuNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Nekasrum uwemratasrum wakerakrumka, atumi tunaaringkia inaisaram ukuktaram. ");
INSERT INTO acuNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Atumka nangkamrum: Iikia Abrahama uchirinji, tura asar Yuse aintsri ainiaji tarume. Antsu wikia tajarme: Yuska ju kaya tepa junaka juki: Juka Abrahama weari ati tusa, ningki wakerakka turamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Atumka numi nerechua nunisketrume. Tura aints jachan juki numi nerechun ajak nuna kanawen charur epeawai. Yuska nu aintsua nunisketai. Atumi tunaari inait nakitakrumka, nekasrum wait wajaktinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Atumi tunaari inaisaram Yus umirkataram tusan, wikia aya entsanmak imiajrume. Antsu wína ukurun winitata nuka wína nangkatusang kakaram atatui. Wikia mianchau asan, natsaamakun ni sapatrin takuschatnuitjai. Yuse Wakani Yusnau ainautirmi nintin piatramkatatrume. Antsu Yus umirchau ainautirminka ji kajintrashtinnum japramatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Niisha Yusnau ainaun, tura Yusen umirchau ainauncha akantratnuitai. Aints trigon pakawa nunisang turatnuitai. Trigo jingkiajincha, tura saapencha akankatas pear su su umpui jingkiajinak juwawai tura jeanam ukuawai. Antsu saapen epeawai. Yuscha nunisang niinu ainaunka ni jeen jukiartinuitai. Antsu niin umirchau ainaunka ji kajintrashtinnum japatnuitai, —Juan etserak timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nunia Jesús Galilea nungkanmaya jiinki, Jordán entsanam wína imiatti tusa Juankun werimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tura wainiat Juan Jesúsan imaichmin nekapeak chicharak: —Ame nekasam wína imiatmin ayatum ¿wína imiatit tusam winam? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Tu iniam Jesús ayaak: —Ja ai, yamaikia imiatia. Yus turataram turamin asamtai, nuka mash umikminuitji, —timiayi. Tamati Juan Jesúsan imaimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tura imiaim, Jesús entsanmaya jiinki, nayaim uranniun wainkamiayi. Turamtai Yuse Wakani yapangma tumau Jesúsa muuken winitmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Turamtai nayaimpinmaya chichaman antukarmiayi. Nu chichamka nuwaitai. —Juka wína Uchiruitai, wína aneetiruitai. Niin pengker nintimtusan pujajai, —Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Yuse Wakani Jesúsan engkemtuau asa, aints atsamunam Jesús Satanásjai nekapnaisati tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Tura akupkamu asa, nu nungkanam cuarenta (40) kinta ijiarma pujus yaparmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Tura timiá tsukamak pujamtai, Satanás nuna wainak: Watska, wína chichamrun umirtukchatpiash tusa, Jesúsan nekapsatas chicharak: —Nekasam Yuse Uchiritkumka ¿waruka nangkamisha yaparusha pujame? ¿Warukaya kaya tepa ju jukim yuwatasam pang najantsume? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Tamaitiat Jesús ayaak: —Atsa, turashtatjai. Yuse chichame tu aarmawaitai: “Aints aya yutanak yutanak nintimtinauka tukeka pujuschartinuitai. Antsu Yuse chichamen nintimtinauka nekasar tuke pujusartinuitai”, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nuniangka Satanás Jesúsan ayas, pengker yaktanam Jerusalén tutainum umamiayi. Tura Yus seatai juun jea yakí wajakmanum iwiak, ");
INSERT INTO acuNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ataksha nekapsatas chicharak: —Nekasam Yuse Uchiritkumka, tsekengkim yakiiya ayaarta. Yuse chichamesha tu aarmawaitai: “Yus ni awemamuri irunun amin waitmakarti tusa inartinuitai. Turamtai nawemin kayan tukumkai tusar, Yuse awemamuri ainau ni uwejejai achirmakartatui” tu aarmau asamtai, tsekengkim yakiiya ayaarta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Tamaitiat Jesús ayaak: —Atsa, turashtatjai. Chikich aarmausha tu aarmawaitai: “Atumi Yusri atumi Apuri asamtai, nangkamrum nekapsatasrum wakerukairap”, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Tamati nunia Satanás Jesúsan ataksha ayas, mura nekas juunnum iwiakmiayi. Tura nuni mash nungka aa nuna, tura nu nungkanmaya yakat ainauncha, nekas pengker aa nunasha mash inaktusmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Tura Satanás chicharak: —Ju nungka ainau mash winaruitai. Turayatun tikishmatruram: Ameka wína Apuruitme turutkumningkia, junaka mash aminu ati tusan susatatjame, —anangkak timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Tamaitiat Jesús ayaak: —Satanása weta. Yuse chichame tu aarmawaitai: “Atumi Yusri atumi Apuri asamtai: Ameketme Apum titaram. Turaram atumi Yusri nuke umirkataram”, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Tamati Satanás Jesúsan nepetkatatkama tujintak ukukmiayi. Turamtai Yuse awemamuri nayaimpinmaya Jesúsan kakamtikrartas kautkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Imiakratin Juankun achikiar kársernum engkewaramtai, Jesús Galilea nungkanam waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Tura Nazaretnum jea, nuningkia pujuschamiayi, antsu nunia jiinki Zabulón nungkanam, tura Neftalí nungkanmasha Capernaum yaktanam juun kucha yantamen pujustas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Tura asa yaanchuik Yuse chichamen etserin Isaías naartin nu nungkanmaya ainaun pachis aarmia nunaka miatrusang umikmiayi. Nu aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Yaanchuik Israela uchiri Zabulón naartinu weari ainausha nunia Neftalí weari ainausha juun kucha yantamen puju armiayi. Nu nungkasha Galilea tutayi. Nuni Israelchau ainau untsuri pujusar, Jordán entsa majincha untsuri pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Nunia aints ainau tunau asar, teenam pujuinawa nunisarang pujú armiayi. Tura nuni pujuinau yamaikia uwemratin chichaman antukar, aints paaniun waininawa nunisarang pujusarmiayi. Nu aints ainau jakawa nunisarang teenam pujuinayat, nu paaniunka wainkarmiayi”. Tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Nunia Jesús Yuse chichamen etsertan nangkamamiayi. Tura chichaak: —Yus nayaimpinmaya aints ainaun inartin kinta jeatak wajasi. Tura asamtai atumi tunaari inaisaram tuke Yus nemarkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús Galilea nungkanam juun kucha kaanmatkarin wekaas, namakan achiun jimiaran wainkamiayi. Nuka namakan achikiartas reden juun kuchanam ujungkarmiayi. Nu aintsu naaringkia Simón Pedroyayi. Nuna yachí naaringkia Andrésuyayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Tura Jesús nu aintsun wainak chicharak: —Wína nemartustaram. Tura namak achiarme nutiksarmek aints ainau wina chichamur ujakmintrum, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tamati nuna antukar, ni rederin japawar ukukiar, Jesúsjai tsaniasar wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Tura arakchichu wekaasar, juun Zebedeo naartiniun ni uchiri Santiagojai, tura Juanjai ni rederin kanunam apainak pujuinaun wainkamiayi. Tura wainak Jesús chicharak: —Wína nemartustaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tamati Santiagosha, tura Juansha ayu tusar, kanunmaya jiinkiar ni aparinka ukukiar, Jesúsjai tsaniasar wekaasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Tura Jesús Galilea nungkanam wekaas, chikich chikich yaktanam iruntai jeanam waya, nunia aints ainaun nuiniarmiayi. Tura nuiniak: Yus aints ainaun tu inartinuitai tusa, Yusnum uwemratin chichaman etserkamiayi. Tura aints sungkurmakar pujuinaun, tura najaiminak pujuinauncha mash tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Tura asamtai Siria nungkanam pujuinausha Jesús tsuwakratmaun nekawarmiayi. Tura nuna nekawar, jainauncha tura sungkurintin ainauncha, tura najaiminak pujuinauncha, tura iwianchrintin ainauncha, tura waurinak pujuinauncha, tura wekaichau ainauncha Jesúsnum itaarmiayi. Tura itaaramtai Jesús nu aints ainaun tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Tura asamtai Galilea nungkanmaya ainau, tura Decápolis yaktanmaya ainausha, tura Jerusalén yaktanmaya ainausha, tura Judea nungkanmaya ainausha, tura Jordán entsa amajin pujuinausha untsuri Jesúsan nemariarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Aints timiá untsuri kaunkaru asaramtai, Jesús nu aints ainaun ukuki, mura waka nuni keemsamiayi. Turamtai ni nuiniatiri ainausha nuni wakaar, nijai tsaniasar keemsarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Tura keemsaramtai, Jesús nuiniatan nangkamamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","Nunia Jesús ni nuiniatirin nuiniak: “Aints ainau: Iikia nekasar Yuse Wakani yuumaji, tu nintimsar pujuinauka Yusnum tuke pujusartin asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Tura ni tunaarin nintimsar wake mesekar juutinak pujuinauka Yus ni tunaarin tsangkuramu asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Tura jampechu ainaun Yus yamaram nungkanam pujusarti timiau asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Tura yaparinawa nunisarang tura kitaminawa nunisarang Yuse wakeramurin najanawartas wakerinauka, Yus turuwarti tusa yaingmau asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Tura chikich ainaun wait anentin ainaunka Yuscha niincha nunisang wait anentamu asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Tura péngke nintintin ainau Yusnum jear, Yusen wainkartin asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Tura aints chikich ainaun: Maanitsuk asataram tinu ainaunka pachis Yus: Wína uchir ainawai timiau asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Tura aints Yuse wakeramurin najaninak wait wajainauka tuke nangkantsuk Yusnum pujusartin asar warasartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Atumka wína umirtuku asakrumin, aints ainau atumin jiyatminak, tura pasé awajtaminak, atumin pachitmasar waitrinak pasé chichainamtaisha warastinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Yaanchuik atum akiintsurmining, Yuse chichamen etserin ainauncha nunisarang pasé awajin armiayi. Tura asar atumnasha nunisarang pasé awajtaminamtaisha, atumsha nunisrumek wait wajau asaram, nayaimpinam Yusnum pujustinuitrume. Tura asaram pengker nintimsaram pujustaram. Tura nukap warastaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Nunia Jesús ataksha nuiniak: “Atumka weea tumawaitrume. Weesha tuke wakeruktinuitai. Tura wee michumangka ¿itiur ataksha yapaktinuita? Wee michumangka, waríksha itiurkachmin asamtai, aints ainau nuna aanum aints wekaatainum japawar ukukmiaun nawejai najainawai. Turamu asaramtai atumsha Yus umirtsuk pujakrumningkia, Yuska atumin wee michu aanum japamua nunisang japrama ukurmaktinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Atumka ju nungkanam paaniua nunisrumek pujau asaram, aints ainaun paan nintimtikratnuitrume. Atumka yakat muranam aa nusha paan wainkatnuitrume. Tura asamtai atumsha yakta nunisrumek anumkachminuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Aints ainau kantiin akawar chingnanmaka engkeenatsui, antsu yakí kentsar jeanam pujuinaun mash paan wainmamtikinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Atumsha nunisrumek nekas pengker aa nu turau asaram, aints ainau atumi pengker pujamurmin waitmakar, Yuska juuntaitai tiarat, tu nintimsaram pujustaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Nunia Jesús ataksha nuiniak: “Atumka wína pachitsaram: Nuka Moisésa chichamen sakartas taawitai, tuuka nintimrairap. Tura Yuse chichamen etserin ainau aarmaurincha sakartas taawitai, tuuka nintimrairap. Wikia nunaka turashtatjai. Antsu Moisésa aarmaurin tura Yuse chichame etserin ainau aarmaurincha nekasan umiktasan taawitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nunasha tajarme: Nayaimpisha tura nungkasha meseatsaing, Moisésa aarmauringkia pengké kichkisha yapaijnaiyashtinuitai. Antsu mash aarmawa nunisang umiktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tura aints Moisésa chichamen pengké tuupchincha pachischauka, tura chikich ainaun nuiniak: Nu chicham pachischatnuitrume tauka Yusnum jea, nekas mianchau atinuitai. Antsu Moisésa aarmauringkia umirak, tura chikich aints ainaun nuiniak: Nu chicham umirkataram tauka Yusnum jea nekas juun atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nunia atumka fariseo ainau tura Moisésa chichamen nuikiartin ainausha nangkamasrumek pengker pujachkurmeka, Yuse pujutirinka wayaashtinuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Nunia Jesús ataksha nuiniak: “Yaanchuik juun ainau Moisésa chichamen etserinak: Aints maawairap. Antsu aintsun maunaka yapaijkiartinuitai tiarmiayi. Nu tamauka antukmiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Tura wainiatnak wikia atumin tajarme: Aints ni yachiin kajerak pujakka, wait wajaktiniun jukitnuitai. Tura ni yachiin suwirpiaku jiis, pasé chichaman chichaunaka junia apu ainausha wait wajaktiniun susartinuitai. Tura aints kichan kajerak katsekeak pujauka ji nekas kajintrashtinnum engkema tuke wait wajaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Atumka Yus maaketai titasrum, Yusen waring achat susatasrumsha ni jeen wayaakrumningkia, nuni wayaaram, atumi yachí kajertaminak pujuinau aneakrumka, ");
INSERT INTO acuNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","Yus susatasrum wakerarme nuka ukukrum, atumi yachí jiistaram. Tura nijai chichasrum tsangkurnairataram. Nuniangka waketkiram, Yus susatasrum wakerarme nuka Ni susataram. ");
INSERT INTO acuNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Atumka tumaashitkurmeka, chikich aints atumin: Akirkata tusa, apu pujamunam jeetamiartas achirmakaramtaikia, nijai tsaniasrum jinta weakrum chicham iwiarataram. Nu turachkurmeka, apu achirmak suntar ainaun akupturmak: Ju aints kársernum engkeataram titinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nekasan tajarme: Atumi tumaashri mash metek akiimiatsuk pujakrumka, nuniangka pengké jiinkishtinuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Nunia Jesús ataksha nuiniak: “Yaanchuik juun ainau chichaman etserinak: ‘Nuwa aishrinujai tsanirmawairap’, tinamuka antukmiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Tura wainiatnak wikia atumin tajarme: Aints nuwan jiis, nijai tsanitan wakerau asa, ni nintijai yanchuk tunaun turawai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Tura asamtai atumi jiisha atumin tunau nintimtikramataikia, atumi jii untsurnumanini kut kuinkawa nunisrumek tunaarum japaram ukuktaram. Jii kichik mengkakau wainiatrumek, nayaimpinam tuke pujustinka timiá pengkeraitai. Antsu mai jiintukka namangmesha pengker ayat, ji kajintrashtinnum engkematnuka nekas pengké paseetai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Tura untsur uwejmijai tunau takastasrum wakerakrumka, tunau takasai tusaram, atumi uweje met charawa nunisrumek tunaarum japaram ukuktaram. Uwej kichik met charukmau wainiatrumek, nayaimpinam tuke pujustinka timiá pengkeraitai. Antsu namangmeka pengker ayat, mai uwejtukka ji kajintrashtinnum engkematnuka nekas paseetai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Nunia Jesús ataksha nuiniak: “Tura yaanchuik juun ainau etserinak: ‘Aints nuwarin ukuktias wakerakka, papin aar: Nuwarun ukuajai tusa, nu papinka nuwarin susatnuitai’, tinu armiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Antsu wikia tajarme: Nuwari kichjai pujachu wainiat, aints ni nuwarin ukuakka, chikich aintsun ninumkamtai, nu aintska nuwarin ukukin asa, nuwarin tunau takamtikui. Tura nuwa japamun nuwatkausha nunisang tunau wajawai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Nunia Jesús ataksha nuiniak: “Yaanchuik juun ainau etserinak: ‘Atumka ii Apuri naarin pachisrum: Yusjai tajai, nunaka turatatjai, tarume nuka umitskeka inaisairap’, tinu armiayi. Nu tamauka antukmiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Tura wainiatnak wikia atumin tajarme: Nangkamrumka Yusjai tajai, pengké tiirap. Yusjai tajai, nayaimpinmasha tuke nunisang au asamtai, wisha nunisnak waitrutsuk chichaajai takurmeka, nayaimpisha Yuse pujutiri asamtai nusha tiirap. ");
INSERT INTO acuNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Tura Yusjai tajai, ju nungkasha tuke nunisang au asamtai, wisha waitrutsuk chichaajai takurmeka, ju nungkancha Yus wainu asamtai nuka tiirap. Tura Jerusalén yaktasha pachisrum: Jerusalén nekas Juun Apu yaktari asamtai, wisha waitrutsuk chichaajai, Yusjai tajai tiirap. ");
INSERT INTO acuNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Atumka jemperuktaj takurmesha, atumkeka jemperukchatnuitrume. Tura atumi jemperi ataksha tuke shuwin ati tayatrumek nusha turachminuitrume. Tura atumi muuken pachisrum: Nekasnak waitrutsuk Yusjai tajai tiirap. Tura asaram atumek nintimsaram: Wi wakeraknaka nuna turatatjai titasrum: Yusjai tajai tiirap. ");
INSERT INTO acuNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Tura atumin ininminamtaikia: Ja ai titasrum wakerakrumka tupnik: Ja ai titaram. Antsu atsa titasrum wakerakrumka tupnik: Atsa titaram. Nuna nangkamasrumek: Yusjai tajai takurmeka nuka paseetai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Nunia Jesús ataksha nuiniak: “Yaanchuik juun ainau Moisésa chichamen etserinak: ‘Aints ijutminak jiimin mesturmaramtaikia, amesha nunismek yapaijkum ni jii mesturta. Tura ni ijutminak naimin akartamkamtaikia, amesha nunismek yapaijkum ni naisha akarkata’, tinu armiayi. Atumka nu etsermau antukmiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Antsu wikia atumin tajarme: Pasé aints ainau yapaijtsuk asataram. Antsu aints atumi yapiin awaturminamtaisha, atumka yapaijtsuk atusha awatita tusaram tsangkatkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aints tumaashnum akirkata tusa, atumi wejmakri jurutramataikia, atumi punchurisha jukiti tusaram tsangkatkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Tura aints atumin inatmak: ‘Ju mermaka kichik kilómetro entsatrukta’, turamataikia, jimiarchik kilometrosha pengker nintimsaram nuka entsatkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Tura aints: Yuumamur surusta turamataikia, ni yuumamuri surittsuk susataram. Tura aints atumin: Warirmesha tsangkatrukta turamataisha, surittsuk ikiastaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Nunia Jesús ataksha nuiniak: “Yaanchuikia aints ainau chichainak: ‘Ame irutkamurmek aneeta. Antsu nemasmeka suwirpiaku jiista’, tinu armiayi. Atumka nu tamau antukmiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Antsu wikia tajarme: Atumi nemase ainau aneetaram. Tura atumin pasé chichartaminamtaisha, Yus yainmakti titaram. Tura atumin suwirpiaku jiirminamtaisha pengker awajsataram. Tura atumin jiyatminamtaisha, tura pasé awajtaminamtaisha, nu aints pachisrum Yus seattiaram. ");
INSERT INTO acuNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Tu pujakrumka atumi Apaachiri nayaimpinam puja nuna wakeramuri umiu asaram, nekasrum ni uchiri ainiarme. Yus aints ainaun mash wait anentau asa, pasé aints ainamunmasha, tura pengke aints ainamunmasha tsaa tsantrati tusa tuke tsangkatawai. Tura Yusen umirin ainamunmasha, tura Yusen umirchau ainamunmasha yumi jiturti tusa yumincha tuke akupawai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Tura asamtai atumin anenminak pujuinau nuke aneakrumningkia, ¿Yus atumin: ‘Nekasrum pengke aintsuitrume’, turamtatuak? Atsa. Antsu kuikian juu ainau tunau ainayat, niin aneenauncha nunisarang aneenawai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Tura atumi weari ainaujaing chichaakrumka ¿Yusen umirchau ainau nuna nangkamasrumek pengker nintimsarmek pujaram? Atsa, Yusen umirchau ainausha ni weari ainaujai chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Tura asamtai atumi Apaachiri nayaimpinam puja nujai metek nekas pengker ataram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Nunia Jesús ataksha nuiniak: “Atumka: Aints ainau wína pengker turamurun wainkarat tu nintimsarmeka pengker aa nuka turuwairap. Tu nintimsaram chikich ainaun pengker awajsamin wainiat, atumi Apaachiri nayaimpinam puja nuka atumin pengkerka awajtamsashtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tura asamtai yuuminak pujuinau yaingkrumsha, chikich ainausha antukarat tusaram etserkairap. Antsu aints ainau wina mash jiirsar: Pengke aintsuitme, turutiarat tu nintimsar, iruntai jeanam wajasar tura jinta wekaasar: Yuuminak pujuinaun yayaajai, tusar etserinawai. Antsu wikia nekasan tajarme: Chikich ainau nuna jiisar: Nuka pengke aintsuitai tinau asaramtai, Yuska nu aintsnaka pengkerka awajsashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Tura asamtai yuuminak pujuinaun yuumamuri susamsha: ‘Yuumamurin susamjai’, tutsuk, aints kichkisha ujakairap. ");
INSERT INTO acuNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Antsu takamtaik uukrum chikich ainau yuumamuringkia susataram. Turakrumningkia atumi Apaachiri mash aintsun wainua nuka atum turamuncha wainak, atumin pengker awajtamsatnuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Nunia Jesús ataksha nuiniak: “Tura Yus seakrum, anangkartin ainau Yusen seaina nunisrumka Yuska seairap. Anangkartin ainau wina jiirsarat tusar, iruntai jeanmasha tura aints untsuri wekaatainmasha wajasar Yusen seainawai. Nekasan tajarme: Aints nuna jiisar: Nekas pengke aintsuitai, tu nintimtinau asaramtai, tu seau ainaunka Yuska pengkerka awajsachartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Tura Yus seakrum, aints atsamunmasha atumi kanutirincha atumek pujusrum, atumi Apaachiri Yus seataram. Turakrumningkia atumi Apaachiri mash aintsun wainua nuka atum turamuncha wainak, atumin pengker awajtamsatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Yus seakrum nangkamrum nukap chichaj pujuirap. Nuka Yusen nekachu ainau tuminawai. Nuka ningki nintimsar: Wikia nukap chichaamtaikia Yuska anturtawapi, tu nintiminawai. ");
INSERT INTO acuNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Antsu nu aints ainau Yusen seainawa nunisrumka Yuska seairap. Atumka seatsrumning, atumi Apaachiri Yus atum yuumamuncha mash nekawai. ");
INSERT INTO acuNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Tura asamtai atumka Yus tu seataram: “Ii Apaachiri Yus, nayaimpinam pujame nu ii nekas Apaachirinme. Aints mash amin naarmin pachisar: Ameketme pengkeram turamiarti. ");
INSERT INTO acuNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ame aints inartin kinta wári jeati. Ame wakeramuram nayaimpinmasha tura nungkanmasha tuke ati. ");
INSERT INTO acuNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ju kintaka ii yutairi yuumaji nu sukartusta. ");
INSERT INTO acuNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Tura chikich aints iin pasé awajtamsaru ainau tsangkurau akurningkia, ii tunaarisha iincha nunismek tsangkukratkata. ");
INSERT INTO acuNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Tura tunaanum jearai tusam japkartuam ukukratkiip, antsu iwianchnumia uwemtikiartukta. Maaketai. Tu Yuska seataram. ");
INSERT INTO acuNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nuniasha tajarme: Atumin pasé awajtaminausha tsangkurakrumningkia, atumi Apaachiri nayaimpinam puja nusha nunisang atumin tsangkutramratatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Antsu atumin pasé awajtaminausha tsangkurchakrumningkia, atumi Apaachiri nayaimpinam puja nusha atumin tsangkutramrashtatrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Nunia Jesús ataksha nuiniak: “Ataksha tajarme: Atum Yus seatasrum ijarmarmesha wake mesekairap. Anangkartin ainau: Aints wína jiirsar: Ijarmayapi turutiarat tusar tuminawai. Tura asamtai wikia nekasan tajarme: Chikich aints: Pengke aintsuitai tu nintimtursarat tusar, ijarmawar pujuinaunka Yuska pengkerka awajsashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Antsu atumka ijarmaram pujakrumsha, aints nekarawai tusaram, atumi yapi nijarum pengker temashmiartaram. Aints ijarmayapi turutiarai tusaram nuka turataram. Chikich aintska nekarminachu wainiat, atumi Apaachiri Yus mash aa nuna nekau asa, atumin pengker awajtamsatatrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Nuniasha Jesús ataksha chichaak: “Wikia nunasha tajarme: Ju nungkanam warinchu ainau sengka wári mesratin asaramtai, tura warinchusha mengkakartin asaramtai, tura kasa ainau jea wayaawar kasamkartin asaramtai, kuik kiaungkairap. ");
INSERT INTO acuNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","21","Antsu nayaimpinmaka warinchu atsuinau asaramtai nuningkia mamurchatnuitrume, tura warinchurmesha mengkakashtinuitai. Tura kasa ainau kasamkartas wayaachartinuitai. Tura asamtai atumka nukap wakerarme nuka atumi nintijai tuke nintimsaram pujarme. Tura asaram ¿itiurak nekasan nayaimpinam jeataj? tu nintimsaram pujustaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","23","Nunia Jesús ataksha nuiniak: “Atumi jiingkia kantii kapaawa nunisketai. Atumi jii pengkeraitmataikia, paan wainmaktinuitrume. Antsu atumi jii paseetmataikia, teenam pujawa nunisketrume. Atum waintrume nuka atumi nintijai nintimu wearme. Atumi ninti pengkeraitmataikia paan nintimratnuitrume. Antsu atumi jiingkia pengker ayat, atumi ninti paseetmataikia, atumsha teenam pujawa nunisrumek nintimuwearme. Atum tu nintimsaram pujakrumka, nekasrum timiá pasé pujarme”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Nunia Jesús ataksha nuiniak: “Apu jimiar metek nintimtsuk pujuinaunka aints kichkisha umirkartatkama tujintinawai. Antsu kichnaka nakitak, kichan aneetnuitai. Tura kichkin umirak kichnaka pachischatnuitai. Tura asamtai atumka warinchu ainau aneakrumka, aya nuke aneetaram. Tura Yus aneakrumka, aya Yusek aneetaram. Antsu mai aneakrumka nuka yumtinuitai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Nunia Jesús ataksha nuiniak: “Tura asamtai tajarme: Warinak yuwataj, tura warinak umurtaj, tura warinak entsartaj tusaram, nuke nintimsarmeka pujusairap. Yus tuke iwiaaku pujustaram tusa, pujutan suramu asa, atumi yutairincha, tura atumi entsatirincha suramsatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chingki yakí nanamin ainau itiur pujuinawa tusaram nintimrataram. Nuka araknaka arainatsui. Tura arakan juukar jeanmasha ukuinatsui. Tu pujuinau wainiat, atumi Apaachiri nayaimpinam puja nuka ni yuwatniurin suwawai. Yus atumin chingkin nangkamasang nukap anenmau asa ¿atum yuumamunka itiur suramsashting? ");
INSERT INTO acuNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Tura untsuri kinta pujustaj takurmesha kichik horaksha inangkakchamnawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Tura ¿warukaya atumi entsatiri pachisrum: Warinak entsartaj tusaram, nangkamrumsha nintimsarmesha pujarme? Yangkur ainau nangkamiar yangkurkar wajainau nintimrataram. Nuka takakminatsui. Tura uruchnasha kutaminatsui. ");
INSERT INTO acuNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tura apu Salomón yaanchuik pujumia nuka entsatirin timiá pengker entsariat, yangkura nuniskeka timiá pengkerka iwiarmamrachmiayi, tusan tajarme. ");
INSERT INTO acuNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nupaa ainau yamaikia shiiram au waininayat, kashin aints charukar jinum epeawartinun wainiat, Yuska shiirman iwiarmamtikin asa, atumnasha yangkuran nangkamasang entsatincha shiirman suramsatnuitrume. Tura asamtai ¿warukaya Yuska nekasrum nintimtsurme? ");
INSERT INTO acuNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Tura asaram warinak yuwataj, tura warinak umurtaj, tura warinak entsartaj tusaram napchau nintimtsuk asataram. ");
INSERT INTO acuNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Yusen nekachu ainau tuke inaitsuk tu nintimsar pujuinawai. Antsu atumi Apaachiri nayaimpinam puja nuka atumi yuumamurmin mash nekau asamtai, tuuka nintimtsuk asataram. ");
INSERT INTO acuNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Antsu Yuse wakeramuri tura ni nekas pengker awajtamsamuri nuwá eemkaram nintimrataram. Turakrumningkia atumi yuumamurin mash suramsatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Tura asamtai kinta tsawaatsaing eemkaram: ¿Kashin wi warukatjak? tuuka nintimtsuk asataram. Kashin yumtin atin wainiatrum, yamaikikia nintimtsuk pujustaram. Chikich kinta yumtin amataikia, Yuska winaka waitui, tu nintimsaram pujustaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Nunia Jesús ataksha nuiniak: “Yus wínaka wait wajaktiniun surusai tusaram, chikich aints pachisrum pasé chichakairap. ");
INSERT INTO acuNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Atumka chikich ainau pachisrum pasé chichaakrumningkia, Yuska atumin wait wajaktiniun suramsatnuitrume. Tura atum chikich ainau pengker awajkurminkia Yuscha nunisang atumin pengker awajtamsatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Tura chikich aints tunaun jumchik takau asamtai, atumka tunau nukap takautiatrumsha ¿waruka nu aintcha tunaawaitai tarume? Tunau pachisrum chichaakrumka, aints ni jiin tsetsee juun engketu wainiat, nunaka waintsuk chikich aintsu jiin tsetseen tuupchin engketun wainak, nuna jiij pujurua tumawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Tura atumi tunaari nukap aa nu nintimtsuk pujayatrum ¿chikicha tunaari jumchik aa nuka pachisrumsha atumsha itiur chichastarmek? Tu pujakrumka aints ni jiin tsetsee juun engketun wainiat, nunaka waintsuk, chikich aintsu jiin tsetseen tuupchin engketun wainak: ‘Tsetsee jiimin engketun ashiitjai. Wait aneasam tsangkatrukta’, tu chichaawa tumawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Tu chichaakrumka chikich ainau anangkuram: ‘Auka péngke aintsuitai turutiarat’, tu nintimsaram pujarme. Tura asaram nuwá eemkaram atumi tunaari nukap aa nu inaisaram, nuniangka paan nintimraram, chikich aints chicharkuram: Tunaari jumchik aa nuna inaisati tusaram chichastinuitrume. Tu pujakrumka aints nuwá eemak ni jiinian tsetsee juuntan ashii japa, nunia paan jiimias, chikich aintsu jiinia tsetsee tuupchin ashiawa tumawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Nuniangka ataksha tajarme: Aints Yuse chichamen nakitinauka Yuse chichamengka ujakairap. Antsu nu aints ainau Yuse chichame ujaakrumningkia, nuka atumin kajertamkatnuitrume. Nu aints ainau yawaa kajeawa nunisarang ainawai. Yawaa kajeu yutan pengker aa nunaka suamaitiat, aintsun esaitas wakerawai. Tura Yuse chichamen antutan nakitinau kúchia nunisarang ainawai. Kúchi nintinchau asar, shaakun najarar tsuringmin ainawai. Tura asamtai kúchi ainau shaak akik aa nuka susashtinuitai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Nunia Jesús ataksha chichaak: “Aints warinak seamina nunaka juwinawai. Tura warinak eaina nunasha waininawai. Tura winájai tinaunaka waitin uratinawai. Tura asamtai tuke Yus seataram. Turakrumningkia atumi yuumamurmin suramsatnuitrume. Tura Yuse wakeramurin nekaatasrum wakerakrumningkia, Yuska nunasha nekamtikramatnuitrume. Tura Yus pujamunam jeatasrum wakerakrumningkia, Yuska waitin uratramtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Nusha nintimrataram. ¿Yaachia uchiri yaparak yurumkan seamaitiat kayan sua? ");
INSERT INTO acuNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Tura ¿yaachia uchiri namakan seamaitiat napin sua? ");
INSERT INTO acuNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Atumka tunau ayatrumek, nekasrum atumi uchiri pengker aa nuke suwarme. Atumka Yus seakrumningkia ¿atumi Apaachiri nayaimpinam puja nu nekas pengker asa, itiur suritramkating? ");
INSERT INTO acuNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Aints ainau wína pengker awajtusarat tusaram nu wakerau asaram, atumsha nunisrumek chikich aints ainausha pengker awajsataram. Nu chichamnaka Moiséscha, tura yaanchuik Yuse chichame etserin puju armia nusha mash umiktaram tusar aararmiayi”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","14","Nunia Jesús ataksha chichaak: “Wikia ataksha tajarme: Yusnum pujustasrum wakerakrumka, waiti tuupchinam wayaataram. Waiti tuupich asamtai, aints ainau nuni wayaawar, jinta tsererchinam tuke iwiaaku pujustinnum weenauka untsurinchuitai. Antsu chikich waiti wangkaram asamtai, aints nuni wayaawar, tungkajin jintanam wait wajaktinnum jeartinka untsurintai”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Nunia Jesús ataksha chichaak: “Wikia nunasha tajarme: Wait chichaman etserin ainau nangkamiar: Wikia Yuse chichamen etsernuitjai tinauka wina anangkruwai tusaram aneartaram. Nuka uwijaya nunisarang winitraminayat, yawaa kajeawa nunisarang atumin mestamrartas winitramiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Atumka numi neré jiisrum: ¿Warí numita? tusaram nekaatnuitrume. Tura asaram nu aints ainau turamurisha jiisrum: ¿Warí aintski? tusaram nekaatnuitrume. Numi jangkirtincha jiisrum, uva yurangkenka juukchamnawaitrume. Tura higo ainau narajnumianka juukchamnawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Numi nekas pengker ainia nuka neren pengkeran nerenawai. Antsu numi pasé ainauka neren paseen nerenawai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Tura numi pengker ainauka paseenaka nerenatsui. Tura numi pasé ainauka pengkernaka nerenatsui. ");
INSERT INTO acuNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Tura numi nere pasé amataikia, aints ainau numin ajakar kanawen jinum epeenawai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Tura aints ainau numi neren jiisar: ¿Warí numiki? tusar nekainawa nunisrumek atumka aints ainau turamurisha jiisrum: ¿Warí aintski? tusaram nekaatnuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nunia Jesús ataksha chichaak: “Wikia nunasha tajarme: Aints ainau nangkamiar: ‘Apurua, Apurua’, turutinauka mash Yuse pujutirin nayaimpinmaka jeachartinuitai, antsu wina Apaachir nayaimpinam puja nuna wakeramurin najanin ainauka ni pujutirin jeartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nungka amukatin kinta jeamtai, aints untsuri wína chichartinak: ‘Apurua, Apurua, iikia amin pachisar ami chichamim etsernuyaji, tura ami naaram pachisar aintsnumia iwianch ainau jiirnuyaji. Tura ami kakarmarmijai wainchati takatcha takakmasmiaji’, turutiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Tura wainiatnak wikia ayaakun: ‘Atumin pengké wainchawaitjarme. Tunau takau ainautiram, winíangka jiinkiram wetaram’, titinuitjai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Nunia Jesús ataksha chichaak: “Wikia nunasha tajarme. Aints wína chichamrun antuk, tura miatrusang umirtak pujauka aints jea jeamtan nekau nungka pisu amanum jea jeamkamua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tura yumi nukap jituriat, tura entsasha nujangkruayat, tura nasesha kakarman nasentiat, nu jea nungka pisunam jeamkamu asamtai, yumpungtatkama tujinkatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Tura aints wína chichamrun antukiat, umirtutsuk pujauka aints nintinchau jean yaikminam jeamua tumawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tura yumi nukap jitak, entsasha nujangkrak, tura nasesha kakarman nasentak nu jeanka pukuuktinuitai. Turamtai nu jeaka mengkakatnuitai”, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","29","Tura chichas umisamtai, Moisésa chichame nuikiartin ainaujai metekchau, antsu Yuse kakarmarijai nuikiartau asamtai, aints Jesúsa chichamen antukaruka nukap nintimrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesús nu muranmaya wangkenmatai, aints ainau untsuri nemariarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Turinai aints kuchapruku tari, Jesús wekaamunam tikishmatar seak: —Apuru, ame wakerutakmeka wína tsuwaramnawaitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Tamati Jesús ni uwejejai kuchapruku namangken takas: —Ja ai, wakerajme. Pengker wajasta, —timiayi. Tamati nu tamaujai metek tsaar pengker wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Turamtai Jesús chicharak: —Antukta. Ami turunamuram pengké etserkaip. Antsu sacerdotenam weta. Nuni weme namangkem pengker tsuwamaru asam inakmasta. Tura aints ainau mash pengker wajasmaurun nekaawarat tusam, Moisés tímia nunismek turata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Tura ukuki, Capernaum yaktanam jeamtai, Romanmaya kapitán tari, Jesúsan seak: ");
INSERT INTO acuNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Apuru, wína inatir jaawai. Pengké nantakchamin kakarman najaimiak jearun juutu tepawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Tamati Jesús chicharak: —Wikia tsuwartasan winitatjai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","9","Tamaitiat kapitán ayaak: —Apuru, wikia judíochu asan, ameka wína jearun wayaata tichamin nintimjai. Wikia suntara apuri umirnuitjai. Tura wikia suntar ainaun inau asan, kichan: Weta, tama nusha weawai. Tura kichan: Winiti, tama nusha winawai. Tura wina inatirun takatan inamka, miatrusarang umirtinawai. Tura asamtai amesha nunismek apu asam, juni wajasam chichaamning inatirka tsaartatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tamati Jesús nuna antuk, nukap nintimias niin nemarinaun chicharak: —Nekasan tajarme. Ju aintsua nunisarang Yus nekas tujinkachuitai tinaunka kichkisha wainkachuitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nunasha tajarme: Israel ainau untsuri tsaa taakmanumanini, tura tsaa jeamunmaninisha Yuse pujutirin nayaimpinam kaunkar Abrahamjai, tura Isaacjai, tura Jacobjaisha iruntrar yuwaartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Antsu Israela weari ainau Yuse pujutirin wayaamin ainayat, wína nekasampita turutchau asar, nekasar teenam japar ukukmiawa nunisarang wait wajakartinuitai. Tura asar nuni juutinak, nain esainiar katertinak matsamiartinuitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Tura kapitanin chicharak: —Jeemin yamaikia waketkita. Ame wína inatir nekasampi tsuwartinuitme turutu asakmin nuke ati tajame, —Jesús timiayi. Tamati ni tamaujai metek kapitani inatiri pengker wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Nunia Pedro jeen waya, Jesús Pedro tsatsarin tsuweak peaknum tepaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Tura nu nuwan wainak Jesús uwejen achikiam, tsuweamurin michatramiayi. Tura michatar wajaki, irasartas taarun yurtan nangkamamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Tsaa jeamtai iwianchrintin ainaun, tura jau ainauncha untsuri Jesúsnum itaarmiayi. Tura itarim Jesús aya chichasang iwianch ainaun jiikmiayi. Tura jau ainau itamuncha mash tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yuse chichame etserin Isaías yaanchuik chichaak: “Ii pimpirmaurincha tura ii najaimiamurincha ningki jurutramkimiaji”, tímia nuna umiktas Jesús aints ainaun tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aints ainau timiá untsuri tentakaram, Jesús ni nuiniatiri ainaun akatar akupak: —Tumajin katingmi tusaram kanu umistaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Tamati Moisésa chichame nuikiartin tari Jesúsan chicharak: —Nuikiartinu, ame tuning wekaasatme nunisha amin nemarsatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Tamati Jesús ayaak: —Kujancham ainau waanam kaninawai. Tura chingki ainausha keemtairin keemsar kaninawai. Antsu wikia Yus akupkamutiatnak, aints ayatun kanurmintruka atsawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Nunia chikich nemarnuri Jesúsan chicharak: —Apuru, jeemin waketkita tusam tsangkamrukta. Antsu wína apar jakamtai, iwiarsan umisan nuniangka amincha nemarsatjame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Tamati Jesús ayaak: —Atsa, wina umirtukcharu ainau jakawa nunisarang pujuinau asar, ni weari jakaramtai iwiarsarti. Antsu ameka yamaik wína nemartusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Nunia ukuki Jesús kanunam engkemramtai, ni nuiniatiri ainau nijai tsaniasar engkemawar kuchan katiniarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tura katinai nase kakarman nasenmiayi. Timiá nasenmatai, yumi kanunam yaranak piakmiayi. Turamaitiat Jesúska kanur tepemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Kanuramtai Jesúsan shintinak: —Apurua, uwemtikiarturta. Ukantatji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Tinamtai Jesús ayaak: —¿Waruka timiatcha shamarme? ¿Waruka Yus nekasampita tutsuksha? —timiayi. Nunia nantaki nasencha tura kucha tamparauncha chicharkamiayi. Turamtai nasesha, tura kuchasha miaaku wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Turamtai kanunam engkemrar pujuinau nintiminak: —¿Ausha warí aints asamtaiya nasesha tura tampaasha umirinawa? —tunaiyarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Nunia Jesús ni nuiniatiri ainaujai kuchan katingkiar, tumajin jear Gadara nungkanam nujamkar kanunmaya jiinkiaramtai, jimia aints jakau iwiartainumia jiinkiar Jesúsnum winiarmiayi. Nu mai iwianchrintin timiá kajeu asamtai, aints ainau nuke nangkamatnasha shamiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tura asaramtai nu jimia iwianchrintin kakarar untsuminak: —Jesúsa, Yuse uchiriya ¿waruka iincha waitkartuktasmesha winame? Ii wait wajaktin kinta jeatsaing, ¿waruka iincha wait wajaktinnum akupkartuktasmesha junisha winame? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Tinamtai arakchichu kúchi untsuri shushungminak wajaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Turinamtai iwianch ainau nu aintsu namangkenia Jesúsan seainak: —Ju aintsnumia jiikratkumka, au kuchinam engkemataram tusam akupkartukta, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Tinamtai Jesús ayaak: —Ayu, nuni engkemataram, —tamati iwianch ainau nu aintsnumia jiinkiar kuchinam engkemawaramtai, kúchi ainau wakenam mash pisarar, kuchanam ayangkar kajingkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Tuminamtai kuchi wainin nuna wainkar, shamkar ampukiar yaktanam jear, ni wainkamurin, tura iwianchrintin turunamurincha mash etserkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Tura etserinamtai, nunia aints ainau mash ni yaktarinia jiinkiar, Jesúsnum jear niincha jiisar chicharinak: —Wait aneasam, ii nungkarinia jiinkim weta, —tusar Jesúsan searmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Tu tinam Jesús nunia aints ainaun ukuki, kanunam engkema tumajin kating ni pujamu yaktanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Tura nuni jeamtai aints pimpirun Jesús pujamunam itaarmiayi. Tura pimpirun itaarmia nuka: Jesús nekasampi tsuwaratatua, tu nintiminau asaramtai, Jesús nuna nekaa pimpirun chicharak: —Natsachi, napchauka nintimtsuk asata. Tunaarumka yamaikia tsangkuramuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tamati Moisésa chichame nuikiartin ainau nu chichaman antukar napchau nintiminak: “¿Juka nangkami Yusetjai tumamtsuash? Nu titinka paseetai”, tu nintimrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tu nintimraru asaramtai, Jesús nuna nekau asa chicharak: —¿Waruka timiá napchau nintimsarmesha pujarme? ");
INSERT INTO acuNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Warí timiá yumtinuita? ¿Tunaarum tsangkuramuitme titin yumtinkai? Antsu nu turachkursha pimpirun: ¿Wajakim wekaasata titinka yumtinkai? ");
INSERT INTO acuNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Wikia aints ayatnak Yus akuptuku asamtai, ju nungkanmaya ainau tunaarin tsangkuratnuitjai. Tura wi turamnawaitjai tusan yamaikia nekamtikiatjarme, —timiayi. Tura pimpirun chicharak: —Amin tajame: Nantakim tampuram jukim jeemin waketkita, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tamati pimpiru wajaki ni jeen waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Tura waketkiamtai Yus ni kakarmarin aintsun susau asamtai, nuna wainkaru asar shaminak: Yus juuntaitai tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Jesús nunia jiinki jinta weak winasha waitkamiayi. Wikia Mateowaitjai. Wikia apu akupkamu asan, apu akitinam keemsan, aints ainau kuikiarin apun susatasan juyajai. Wi turamtai Jesús nangkamak wína waitak: —Wína nemartusam wina nuiniatir ata, —turutmiayi. Turutmatai wikia: Ayu tusan wajakin Jesúsan nemarkamiajai. ");
INSERT INTO acuNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Tura asan wi Jesúsan: Yuwita tusan wína jearun jeemiajai. Turamtai wína jearun yuwinak pujuinai, Jesúsjai tsaniasar kuikian juu ainau untsuri, tura judío umirkatin chichaman umikchau ainausha, tura Jesúsa nuiniatiri ainausha nijai iruntrar yuwaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Yuwaar umisaramtai, fariseo ainau wína jearun Jesús iruntramunam yuwaun wainkaru asar, Jesúsa nuiniatiri ainaun iniinak: —¿Atumin nuitamin warukaya kuikian juu ainaujai iruntrar yuwawa? Tura ¿waruka judío umirkatin chichaman umikchau ainaujai iruntrarsha yuwawa? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tu tinam Jesús nuna antuk aimiak: —Aints pengker pujuinauka tsuwakratnunka yuuminatsui. Antsu najaiminak pujuinauka tsuwakratnun yuuminawai. ");
INSERT INTO acuNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wikia pengke aintsuitjai tinaunka: Nintimaurum yapajiataram titasnaka tachawitjai, antsu tunaawitjai tinaun: Nintimaurum yapajiaram Yus umirkataram titasan tawitjai. Tura asamtai atumsha werum Yuse chichame aarmawa nu nekaaram, nunaka taku tawai tusaram nuimiartaram. Nu chichamka nuwaitai. Yus chichaak: ‘Tangku ainauka maaram wina surustaram tusanka wakeratsjai. Antsu aints ainau wait anentrataram tusan wikia wakerajai’, timiayi. Tu aarmawaitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Tura Imiakratnu Juanku nuiniatiri Jesúsan jeariar iniinak: —Iikia Juanku nuiniatiri ainautikia fariseo ainaujai metek Yus nintimrami tusar ijarmar yutsuk pujaji. ¿Antsu ami nuiniatirmeka waruka ijarminatsua? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Tu iniinam Jesús aimkatas nuikiartamun etserkamiayi. Tura etserak: —Aints yamai nuwan nuwatak ni amikrijai tsanias pujamtai ¿ni amikri ijarmawar wake mesekar pujusarminkai? Atsa, antsu aints yamai nuwan nuwatkaun jukiartin kinta jeamtai, nuniangka ni amikri wake mesekar ijarmawartinuitai. Wikia wína nuiniatir ainaujai iruntran pujamtai, nuka ijarminatsui. Antsu wína jurukiaramtai, nuniangka ijarmawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Chikich chichamsha antuktaram: Wejmak arut jaankamtai, ju nungkanam aints kichkisha tarachin yamarman nujtuk aparchamnawaitai. Nu turamka nunia nijaram, yamaram tarach setur tuupich wajayi. Tura asa arutri chingkiana, nuna nangkamasang nukap jaankatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Umuti vino tutai yamai kariauka nuwap aparmau mamurunam yarakchatnuitai. Nu turamka, vino kariak wapakrak nuwap aparmaun pujkatnuitai. Tura pujak nuwap aparmau mesertinuitai, tura vino ukaratnuitai. Antsu vino yamaram aa nu nuwap najanamu yamarmanam kantsejai kantsermanum yaraktinuitai. Turamka vino yamaram ayat, nuwapen pujkashtinuitai, tura vino ukarashtinuitai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesús chichaak pujai, judío juuntri taa, Jesúsan wainak tikishmatramiayi. Tura seak: —Nawantur yamai jakaun ukukjai. Tura wainiatum ame winim uwejmijai ni antingmaka iwiaaku pujustatui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Tamati Jesús: Ayu tusa wári wajaki, ni nuiniatiri ainautijai tsaniasar judío juuntrijai wemiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Jinta wearin nuwa doce (12) musach numpan nangkantsuk pujumia nuka Jesúsa wejmakrin antingtas tuntupenini winitmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Tura wejmakrin antingnaka pengkerapi wajasainja, tu nintimias wejmakrin antimiakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Tura antingkiam Jesús pajas jiis nuwan wainak: —Nawantru, napchau nintimtsuk asata. Ameka wína nekasampita turutu asam pengker wajasume, —timiayi. Nu tamaujai metek nu nuwaka tsaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Tura pengker wajasamtai, Jesús judío juuntri jeen jea, aints nuni pujuinau wake mesekar nangkun umpuinaun wainak, tura untsuminak juutinak pujuinaun wainak, ");
INSERT INTO acuNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","nu aints ainaun chicharak: —Mash jiinkitaram. Nuwachikia jakachi, antsu kanuri, —timiayi. Tamati aints ainau: “Nangkami tawai”, tusar wishikiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Antsu Jesús aints ainaun jiiki nuwawach tepamunam waya uwejen achirkam nuwachikia nantakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Nuwawach jaka nantakin asamtai, nu nungkanmaya ainau nuna pachisar untsuri etserkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Tura nuwachin inanki ukuki, jinta wekai aints wainmichu jimiar Jesúsan nemarsar weenak: —Apu Davidta weariya, wait anengkratkata, —tu untsuminaun antukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Tu untsuminaun wainiat Jesús jeanam wayaamiayi. Tura jeanam wayaamtai, wainmichu irunu nemarkaram Jesús chicharak: —¿Atumka nekasampi iincha pengker tsuwarmartatji turutrumek? —tu iniam aiminak: —Ja ai, Apuru, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tinamtai Jesús nu aintsu jiin antintak chicharak: —Atum nekasampita turutu asaram, pengker wainmaktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Tamati pengker wajasar paan wainmakaramtai, Jesús akatar akupak: —Pengké kichkisha etserkairap, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Tamaitiat jeanmaya jiinkiar, nu nungkanmaya ainaun mash Jesúsa turamurin pachisar etserkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nunia jiinkiaramtai, aints chichachun iwianchrukun Jesúsnum itaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Tura itaaramtai Jesús iwianchin jiiki akupkau asamtai, nu chichachu aints chichatan nangkamamiayi. Tura asamtai aints ainau nuna wainkar nintimrar: —Israel nungkanam pujautikia nu turamuka kichkisha wainchawaitji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Tinau waininayat fariseo ainau chichainak: —Iwianchi apuri kakarmarijai iwianchin jiiki akupawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús wekaa wekaaka chikich chikich yakat juunnumsha, tura tuupchinmasha iruntai jeanam waya, nuni aints ainaun nuiniarmiayi. Tura Yus aints ainaun tu inartinuitai tusa, Yusnum uwemratin chichaman etserkamiayi. Tura sungkurintin ainaun, tura najaiminak pujuinauncha tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Tura uwijaya nunisarang pujuinau asaramtai, uwija wainin atsawa nunisarang wait wajainauncha, tura kuntuchu nintimsar pujuinauncha Jesús wainkau asa, wait anentramiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Tura aints ainaun wait anentak ni nuiniatiri ainautin chichartamak: —Ju aints ainau nekasar trigo tsamakua nunisarang ainawai. Tura juuktin kinta jeau waininayat, juukartin jumchik ainawa nunisarang Yuse chichame etserin jumchik ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tura asamtai Yus ni chichamen etserin ainaun akupkati tusaram Yus seataram, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Tura Jesús ni nuiniatiri doce (12) ainautin untsurmak: “Iwianchrintin jiirkiram akupkataram, tura sungkurintin ainausha, tura najaiminak pujuinausha mash tsuwartaram”, tusa ni kakarmarin suramsamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Jesúsa nuiniatiri ainautikia ii naaringkia nuwaitji: Simón chikich naari Pedron Jesús inaikiamiayi, tura Pedro yachí Andrés, tura Zebedeo uchiri Santiago, tura Santiago yachí Juan, ");
INSERT INTO acuNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","tura Felipe, tura Bartolomé, tura Tomás, tura wi, kuikian juyaja nuwaitjai. Tura Alfeo uchiri Santiago, tura Tadeo, ");
INSERT INTO acuNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","tura Simón yaanchuik mesetan najanin amia nu, tura Judas Iscariote, Jesúsan ukunam anangka surukmia nuwaitai. Ainchik: Wi akupkatnuitjarme tusa Jesús inaitamkamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Tura Jesús ni nuiniatiri doce (12) ainautin chichartamak: “Judíochu nungkarin wekaasairap. Tura Samaria yaktanmasha weerap. ");
INSERT INTO acuNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Antsu Israel ainau uwija mengkakawa nunisarang pujuinamunam wína chichamur etserkatasrum wetaram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Tura werum: Yus yamaikia nayaimpinmaya aints ainaun inartin kinta jeayi tusaram etserkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Turaram jau ainausha tsuwartaram. Tura jakau ainausha inankitaram. Tura kuchaprintin ainausha tsuwartaram. Tura iwianchrintin ainausha jiirkitaram. Yuse kakarmari akikchaujai jukin asaram akikchaujai turataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","“Tura jinta weakrum, kuik engkearam jukirap. Kurisha, tura jiru kuikiasha jukirap. ");
INSERT INTO acuNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Tura pitakrumsha jukirap. Tura wejmak kichik entsarum wekaasataram. Tura sapatrumsha takutsuk tura waisha takutsuk aintsarmek wetaram. Atumka Yuse chichame takau asakrumin, aints ainau atumnasha ayurtamatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Tura asaram chikich yaktanam werum: ¿Yaachia juni pengke nintintin puja? tusaram nekaataram. Tura nekaaram nu yaktanmasha pujusrum, ");
INSERT INTO acuNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","nu aintsu jeen wayaaram nuning tuke pujustaram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Tura asakrumin nu jeanam pengke nintintin pujamtaikia atum: ‘Pengker pujustaram’, tarume nunisang Yus nu aints ainaun pengker awajsatnuitai. Antsu nu jeanam pasé nintintin atumin pengker awajtamtsuk pujuinamtaikia: Yus atumin pengkerka awajtamsashtatui titaram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Tura atumin: Juni wayaawairap turaminamtaikia, tura atumi chichamen antutan nakitinamtaikia, nu jeanmayangka tura nu yaktanmayangka jiinkiram ukuktaram. Tura ukuakrum atumi nawe japirum: Nu aints ainaun Yus jiisti tusaram, aints ainau mash nekamtikiataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","“Nekasan tajarme: Wait wajakartin kinta jeamtai, yaanchuik Sodoma yaktanam pujuinau, tura Gomorra yaktanam pujuinausha tunau asar, wait wajakarmia nuna nangkamasarang nu yaktanam pujuinausha nukap wait wajakartin ainawai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Nunia ataksha iin chichartamak: “Aneartaram. Wisha atumin uwijaya nunisrumek arumin, juun yawaa pujamunam akupajrume. Tura asaram napia nunisrumek nintip ataram. Tura yapangma nunisrumek chikich ainau pasé awajtsuk asataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Aints ainau atumin achirmakar, apu ainamunam surutmakartinuitai. Turinamtai iruntai jea ainamunam numijai awatamrartinuitai. Tura asaramtai wainkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Tura wína umirtin asakrumin, romano apuri ainausha, tura atumi apuri ainausha atumin wait wajaktiniun suramsarat tusar juramkiartinuitai. Tura asaramtai judío apuri ainau, tura judíochu apuri ainausha wína pachitsaram ujaktinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Tura wína aintsur asakrumin atumin achirmakar, apu ainamunam juraminamtaikia ¿itiurak chichaktaj? tura ¿warintuk aiktaj? tuuka nintimrairap. Antsu aneachmau Yus chichamtikramkatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Tura asaram atumka chichaakrumsha atumek nintimsarmeka chichakchatatrume, antsu atumi Apaachiri Wakani atumin chichamtikramkatatrume. ");
INSERT INTO acuNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Aints ainau ni yachiin waininayat: Maawarat tusar surukartinuitai. Nunia uchirtin ainausha ni uchirin waininayat: Maawarat tusar surukartinuitai. Nuniasha chikich aints ni aparin waininayat: Maawarat tusar surukartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Atumka wina aintsur asakrumin, aints ainau atumin mash kajertamkartinuitai. Antsu tunaun nepetkaram jakarmeka, atumka tuke Yusnum pujustinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","“Chikich yaktanmaya ainau atumin mantamawartas wakerutminamtaikia, chikich yaktanam tupikiaktaram. Atumka Israel yakat ainamunam wína chichamur etserat umiatsrumning, wisha aintsutiatnak Yus akupkamu asan ataksha taratnuitjai. Wi taja nuka nekasaintai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Nuniasha tajarme: Aintsu nuiniatiri ni nuikiartinaka nangkakashtinuitai. Tura aintsu inatiri ni inamurin nangkakashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Aints nuikiartiniun nakitinamtaikia, ni nuiniatirincha nakitrartinuitai. Tura aints inakratnuncha nakitinamtaikia, ni inatiri ainauncha nakitrartinuitai. Tura asamtai wína pachitsar aujmatrinak: Iwianchi apurintai tinauka wína umirtin ainauncha nunisarang aujmatinak pasé chichasartinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Nunia Jesús ataksha iin chichartamak: “Tura asamtai aints ainau shamkairap. Yamai uukar chichakmauncha ukunam paan nekaawartinuitai. Tura yamaikia aintsu turamurin nekaachminun waininayat, ukunam paan nekaawartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","“Wikia kashi atumin shishkamsan nekamtikiamiajrume nuka, aints ainau mash antukarti tusaram, tsawaisha paan etserkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Aints atumin mantaminamtaisha shamkairap. Atumi namangkenka mantaminayat, atumi wakaninka maachartinuitai. Antsu Yuska ni umirchau ainau namangkencha, tura wakanincha ji kajintrashtinnum tuke chumpiatin asamtai, aya Yusek shamkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“Atumka chingki jimiarchik kichik jiru kuikiajai sumakminuitrume. Chingki timiá akikchau sumakminun wainiat, atumi Apaachiri surimiamtaikia, chingki kichkisha nungká ayaarchamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Tura Yuska atumin chingkin nangkamasang timiá anenmau asa, atumi intashi warutmak awa tusa nekapmarmawaitai. Tura asamtai atumin mantamawartas wakerutminamtaisha shamtsuk asataram”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Nunia ataksha iin chichartamak: “Nunasha tajarme: Aints ainau wína pachitsar aints antinamunam: Wikia Jesúsnawaitjai taunka wisha nunisnak wína Apaachirun nayaimpinam pujaun ujaakun: Juka wína aintsruitai titinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Antsu aints chikich ainau antinamunam wína pachitsar: Wikia Jesúsnauchuitjai taunka wisha nunisnak wína Apaachirun nayaimpinam pujaun ujaakun: Juka wína aintsruchuitai titinuitjai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Nunia Jesús ataksha iin chichartamak: “Atumka wína pachitsaram: Ju nungkanam pujuinau maanitsuk pengker nintimtunisar angkan pujusarat tusa tamiayi, tuuka nintimsairap. Wikia ju nungkanam tau asamtai, aints ainau maanikiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Wi tau asamtai, aints ni aparijai kajernaikiartinuitai, tura nuwasha ni nukurijai kajernaikiartinuitai. Tura najatisha ni tsatsarijai kajernaikiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Tura asamtai aints ainau ni wearijai nemasnaikiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Aints ni aparincha, tura nukurincha wína nangkatusang aneauka wína aintsur achatnuitai. Tura aints ni uchirincha, tura ni nawantrincha wína nangkatusang aneauka wína aintsur achatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Tura aints wína nemartustas wakerayat, wait wajaktiniun shamauka wína aintsruchuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Nunasha tajarme: Aints wína umirtukiat, jatan shamak wína pachitas: Nuna umirchawaitjai tauka tuke mengkakatnuitai. Antsu wína umirtukuka maawarmaitiat, tuke iwiaaku pujusartinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Nunia Jesús ataksha chichartamak: “Nunasha tajarme: Wína umirtuku asakrumin, atumin anturtaminauka winasha anturtinawai. Tura winasha anturtinauka wína akuptukuncha anturinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","“Aints Yuse chichamen etsernun Yus akupkamu asamtai, ni jeen wayaati taunaka Yus ni chichamen etsernun pengker awaja nunisang nu aintsun pengker awajui. Tura aints chikich aints pengke nintinnun: Jearun wayaata taunaka Yus pengke nintinnun pengker awaja nunisang nu aintsun pengker awajui. ");
INSERT INTO acuNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tura aints mianchaun wainiat, wina nemartin asamtai, nu aintsun yumin shikirak aramtaikia, Yus nu aintsnasha nekas pengker awajsatnuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesús ni nuiniatiri doce (12) ainautin nuikiartutai chichaman akatamar umisu asa, nunia jiinki nu nungkanam yakat ainamunam aints ainaun nuiniartas tura Yuse chichamen etserkatas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Imiakratin Juan kársernum engkeamu pujus, Cristo turamurin pachis chichaman antuku asa, ni nuiniatirin chicharak: —Jesús wainkaram chicham nekartuataram, —tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Akupkamu asar Jesúsan jeariar iniinak: —¿Yus uwemtikiartinun akupkatnuitjai tímia nuka amekitam? ¿Amechuitkumningkia chikichash nakastaij? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Tinamtai Jesús ayaak: “Atumka waketkiram atum wainkarume tura antukmarume nuka Juan mash ujaktaram. ");
INSERT INTO acuNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Tura ujaakrum: Wainmichu ainau paan ataksha wainminawai. Tura wekaichau ainausha ataksha wekainawai. Tura kuchaprintin ainausha tsaarar pengker wajainawai. Tura antichu ainausha paan antinawai. Tura jakau ainausha ataksha nantakiar iwiaaku pujuinawai. Tura mianchau ainauncha Yusnum uwemratin chichaman ujaawai titaram. ");
INSERT INTO acuNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Aints wína turamurun wainkar, nekasampita turutin ainauka nekasar warasartinuitai tusaram Juan ujaktaram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Tamati Juanku nuiniatiri waketkiaramtai, Jesús aints nuni juwakaru ainaun Juankun pachis nuikiartutan nangkamamiayi. Tura etserak: “Aints atsamunam Juan wainkatasrum ¿waruka wemiarume? Karis nase umpuam, mai we mai we waja nunisang ¿aints tu pujau wainkatasrumek wemiarum? Atsa. ");
INSERT INTO acuNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Turachkurmesha ¿aints wejmakan shiirman akikian entsaru wainkatasrumek wemiarum? Atsa. Aints wejmakan akikian entsaruka apu jeen pujuinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Tura warí wainkatasrumea wemiarum? Atumka nekasrum Yuse chichamen etserin wainkatasrum wemiarume. Tura Juan wainkaram, chikich aints Yuse chichamen etsernun nangkamasang pengke aints wainkamiarume. ");
INSERT INTO acuNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juankun pachis yaanchuik Yuse chichame etserin aarmia nuka nuwaitai: ‘Nintimrataram. Yus Mesíasan chicharak: Ame weatsmining jintimin iwiarati tusan, wína akupamurun eemkan akupajai timiayi’. Tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","“Nekasan tajarme: Yuse chichame etserin ju nungkanam puju armia nuka kichkisha Juankun nangkamaska atsumiayi. Antsu yamaikia Yuse umirin mianchau ainausha wi turatnun wainkartin asar, Juankun nangkamasarang Yuse pujutirin jeaartin ainawai, tajarme. ");
INSERT INTO acuNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Nuniasha tajarme: Imiakratin Juan aints ainaun Yus inartinun pachis chichaman etsermia nuni nangkamsar, yamaisha nunisarang kajeu ainausha nu chichaman pengké nakitinawai. Tura kajeu ainau nu chichamnaka nakitinau asar, chikich ainausha Yusnum jeacharti tusar suriminawai. ");
INSERT INTO acuNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Yaanchuik Juan akiintsaing, Yuse chichame etserin ainau tura Moiséscha: Yus aints ainaun tu inartinuitai tusar etserkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Tura asaramtai yaanchuik Yuse chichame etserin: ‘Cristo taatsaing, Elías eemak tatinuitai’, timiayi. Tura nu chichaman nekaatasrum wakerakrumka: Juanka Elíasa tumawaitai titinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ju chichaman antinauka nintimrarti. ");
INSERT INTO acuNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Junia aints ainau itiur nintiminawa nunaka nekamtikiatjarme. Junia aints ainau uchia nunisarang nintiminawai. Uchi ainau ni amikrijai nakurusmi tusar aints aanum iruntramunam chicharnainak: ");
INSERT INTO acuNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Iikia nangkuwach umpuarnisha ¿waruka yaamtsurme? Tura nangkamir nakurusmi tusar, aints jakamunam nampearnisha ¿waruka juuttsurme?’ Uchi tu nintimina nunisrumek pujarme. ");
INSERT INTO acuNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Juan pangnaka yutsuk, tura vinoncha umutsuk pujamtai, atumka ni chichame antut nakitau asaram: Iwianchrinuitai tarume. ");
INSERT INTO acuNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Tura wikia Yus akupkamutiatnak, chikich aintsua nunisnak yutancha pachitsuk yuwan, tura umutnasha pachitsuk umin asamtai, wína nakitrin ainau: Ushuitai tura nampewitai turutinawai. Tura tunaarintin ainau amikrintai, tura kuikian juu ainau amikrintai turutinawai. Tura waininayat Yusen umirin ainau Yuse nekamtairin jukin asar: ¿Warukaya nunasha tinawa? tusar nekainawai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nuniangka Jesús chikich chikich yaktanam Yuse kakarmarijai wainchatai takatan untsuri takasu waininayat, nu yaktanmaya ainau ni tunaarin inaisacharu asaramtai, Jesús nu aints ainaun chicharkamiayi. Tura chicharak: ");
INSERT INTO acuNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Corazín yaktanmaya ainautirmin, Betsaida yaktanmaya ainautirmincha aneartaram tajarme. Atumka nukap wait wajaktinuitrume. Tiro yaktanmaya ainau, tura Sidón yaktanmaya ainausha Yusen umirchau ainayat, Yuse kakarmarijai wainchati takatan atum wainkamiarume nunaka wainkachariat, nu wainkarkia yaanchuik: Yus tunaarun japitrurti tusar, entsatin pushun entsarar, tura muuken yukuujai yukuarar Yusnum uwemin armiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Tura atumsha wainchati takatcha wainkayatrumek, atumi tunaari inait nakitau asaram, tunau jiistin kinta jeamtai, atumka Tironmaya ainau, tura Sidónnumia ainau nangkamasrumek nukap wait wajaktinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“Capernaum yaktanmaya ainautirmincha tajarme: Atumka anangmamkuram: Iikia nayaimpinam pujustatjiapi, ¿tu nintimsarmek pujaram? Antsu atumka jakau matsamtainum mengkakatnuitrume tajarme. Sodoma yaktanmaya ainau Yuse kakarmarijai wainchati takatan wainkachu ainayat, nuna wainkaramtaikia, ni yaktari yumpuntsuk yamaisha tuke atinuyayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Tura asamtai tajarme: Tunau ainau jiistin kinta jeamtai, atumka Sodoma yaktanmaya ainau nangkamasrumek nukap wait wajaktinuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Nuniangka Jesús Yusen seak: “Apaachiru, ameka mash nayaimpinmaya ainau Apurinme. Tura mash nungkanmaya ainau Apurinme. Tura asam aints ningki nintimsar: ‘Wikia nekau aintsuitjai’, tinauka ju chichaman nekaacharti tusam uukuitme. Antsu uchia nunisarang nintiminau ju chichaman paan nekaawarti tusam nekamtikiawaitme. Tura asakmin maaketai tajame. ");
INSERT INTO acuNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Apaachiru, tu ati tau asakmin, maaketai tajame”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tura Yusen sea umis, ataksha aints ainaun chicharak: “Wína Apaachir mash aa nuna wina surusmiayi. Aints kichkisha Yuse Uchiri itiurak awa tusarka nekainatsui. Tura wína Apaachir itiurak awa tusarsha nunasha nekainatsui. Antsu Yuse Uchiri asan, tu awai tusan paan nekajai. Tura aints ainaun: Wína Apaachirka tu awai tusan, wi nekamtikiatasan wakeraknaka nekamtikiatnuitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Mash pimpikniutirmesha, tura itiurkachmin pujautirmesha wini winitaram. Turakrumningkia wikia ayamtiksatatjarme. ");
INSERT INTO acuNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","30","Wikia pengké kajechu asan, miajuitjai tumamtsuk pujajai. Tura asamtai wini winiram nuimiartaram. Tura wína chichamrun miatrusarang umirtukartinka yumtichuitai. Tura wína takatrun takainauka itiurkachmin ainawai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ayamtai kinta tsawaaramtai, Jesús ni nuiniatirijai aja japen nangkaaminak, ni nuiniatiri ainauti yaparakur trigo jingkiajin achikiar majurar yukir wemiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Turarin fariseo irunu nuna wainkar, Jesúsan chicharinak: —Jiisia, Moisés ayamtai kintati takakmasairap tusa, surimkau waininayat, ami nuiniatiram ainau aunka aitkinawai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Tinamtai Jesús chicharak: —¿Waruka tuusha chichaarme? ¿Yaanchuik apu Davidta turamuri pachisrum aujchaukitrum? Nuka ni aintsri ainaujai tsukaminak, ");
INSERT INTO acuNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Yus seati juun jeanam wayaawar, Yus inaktustin pang aya sacerdote yutairi asamtai, chikich aintska nunaka yuwachminun wainiat, Davidcha nuna yuwak ni aintsri ainauncha susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Atumsha Moisés umirkatin chichaman aarmia nuka aujchaukitrum? Sacerdote ainauka ayamtai kintati Yus seatai juun jeanam ayamtsuk takainau wainiat, Yuska nuna pachis tunaawitai tatsui. ");
INSERT INTO acuNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tura asamtai nekasan tajarme: Atumka Yus seatai juun jean nintimtarme nuna nangkamasrumek wína nintimtursatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yuse chichamesha tu aarmawaitai. Yus chichaak: ‘Tangku ainauka maaram wina surustaram tusanka wakeratsjai. Antsu aints ainau wait anentrataram tusan wikia wakerajai’, timiayi. Nu aarmau antukuitkurmeka, aints tunau takachu ainaun: Nuka tunau turayi tichamnawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wi aints ayatun Yus akupkamu asan, ayamtai kintati tu pujusarti tusan, aints ainaun inartinuitjai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Nunia jiinki, Jesús iruntai jeanam wayaamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tura nuni waya, aints uwejen mutchaun wainkamiayi. Turamtai fariseo ainau: Ju aintsun tsuwaramtaikia, nuka tunau wajasi timi, tu nintimsar Jesúsan iniinak: —¿Ayamtai kintati aints tsuwartin pengkerkai? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Tu iniinam Jesús aimiak: —¿Atumi uwijari waanam ayaaramtaikia atum ainautirmesha ayamtai kintati ashiitai tusarmeka wechaintrumek? Atumka nekasrum nu uwijaka ashiitnuitrume tajarme. ");
INSERT INTO acuNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Tura aints uwijan nangkamasketai. Tura asamtai ayamtai kintati aints wait anentamuka nekas pengkeraitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nunia uwejen mutchau aintsun chicharak: —Uwejem kutsmarta, —timiayi. Tamati ni uwejen kutsmaramtai, chikich uwejejai metek pengker wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Turamtai fariseo ainau iruntai jeanmaya jiinkiar iruntrar chichainak: Jesús maami tusar chichaman najatiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Turinamtai Jesús nuna nekaa, nunia jiinki weai, aints untsuri niin nemariarmiayi. Turinamtai jainauncha mash tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Tura aints ainaun akatar akupak: “Wi turamurka aints kichkisha nekaawarai tusaram, pengké etserkairap”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Jesúsa turamuringkia yaanchuik Yuse chichame etserin Isaías aarmia nunisang umikmiayi. Nu aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Yus chichaak: “Juwaitai wína inatir, wi akupkamiaja nuka wína aneetiruitai. Tura asan niin wainkan waraajai. Ni nintin Wakantrun engketatatjai. Wi turamu asa, mash nungkanmaya ainaun uwemratin chichaman etserkatnuitai. Tura nu chichaman umirkaru ainaun uwemtikratnuitai. Tura nu chichaman umikchau ainaunka uwemtikrashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","“Wína inatirka aints ainaun jiyakchatnuitai. Tura anturtuktaram tusangka untsumkashtinuitai. Tura asamtai jintanam wekainausha ni etsermataisha anturkachartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","“Tunau jiistin kinta jeatsaing, kakaichau ainaun yaingtinuitai, tura niin jumchikesh umirinak pujuinaunka japashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Turatin asamtai mash nungkanmaya ainau niin pachisar: Wári tati tusar nakasartinuitai”. Tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Nunia aints iwianchrinun Jesús pujamunam itaarmiayi. Nu aintska wainmichu tura chichachuyayi. Tura itarim Jesús niin tsuwarmiayi. Tsuwaaram niisha paan wainmak, chichatnasha paan chichakmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Tura pengker wajakiamtai, aints ainau nuna wainkar mash nintimrar: “¿Davidta wearin pachis Yuse chichame etserin: Uwemtikiartin tatinuitai tiarmia nuchawashi?” tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Tinamtai fariseo ainau nuna antukar chicharnainak: —Juka iwianchi apuri Beelzebún umirnuitai. Tura asa nuna kakarmarijai aintsu iwianchrin jiiru weawai, —tu nintimrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Tu nintiminamtai, Jesús nuna nekau asa chicharak: —Nintimrataram. Chikich nungkanmaya apu ainau kajernaikiar kanakar pujusar maaninamtaikia, nu nungkanka wári mesratnuitai. Tura aints ainau chikich yaktanam, tura chikich jeanam iruntrar kajernaikiar pujuinauka, nu jeancha tura nu yaktancha wári ukukiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Tura ¿itiurak Satanása kakarmarijaingkia Satanása inatiri ainaun jiiki akupkatnuita? Nuka pengké turashtinuitai. Antsu atumka wina pachitsaram: Nuka Satanása kakarmarijai iwianch ainaun jiiru weawai turutrume nuka nekaschawaitai. Nuka nekasainmatikia, Satanáska ningki nepetmamkatnuitai. Tura nuka nekasainmatikia, Satanása kakarmari wári mengkakatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Atumka wína pachitsaram: Nuka Beelzebú naartinu kakarmarijai aintsu iwianchrin jiiru weawai turutrume. Antsu nuka nekasainmatikia ¿atumi nuiniatiri ainau yana kakarmarijia iwianch ainaun jiiru weenawa? ¿Atumka nusha Satanása kakarmarijai iwianch ainaun jiiru weenawai tatsurmeash? Tura nisha: Satanása kakarmarijai turichuitji tinau asaramtai ¿itiurak winasha: Satanása kakarmarijai turawai turutiaram? Atumka tau asaram nuwaarme. ");
INSERT INTO acuNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Antsu wikia Yuse kakarmarijai iwianch ainaun jiikin asamtai, atumsha paan nintimsaram: Yuska aints ainaun tu inawai tusaram nekaamnawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Aints nekas kakaram aa nuka jea waitirin naka pujamtai ¿nu aints jingkiatskeka, ni jeen wayaar wariri jurukminkai? Atsa, antsu nu aints jingkiar wariri jurukminuitai. Tura asamtai Satanás jingkiatskeka ninu aa nuka jurukchamnawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Wína amikruchuka wína nemasruitai. Tura wína yaintsuk pujauka aints araka jingkiajin irumtsuk aya mengkakarti tusa, japua nunisang iwianchin yayaawai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Tura asamtai atumin tajarme: Aintsu tunaari ainia nunaka mash Yus tsangkuratnuitai. Tura Yusen pachisar pasé chichainaunka Yus mash tsangkuratnuitai. Antsu Yuse Wakanin pachisar pasé chichainaunka pengké tsangkurashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Tura wi aints ayatun, Yus akuptuku waitinayat, wína pachitsar pasé chichainamtaisha, nu tunaunasha tsangkuratnuitai. Antsu Yuse Wakanin pachisar pasé chichainaunka yamaisha tuke nu tunaunaka pengké tsangkurashtinuitai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Nunia ataksha Jesús chichaak: “Nunasha tajarme: ¿Numi jiisrum nerekuashi? tusaram paan nekaatnuitrume. Numi tenap piantramka pengker nereeyi. Antsu numi piantrachmauka mianchaun nereeyi. Atumsha nunisketrume. ");
INSERT INTO acuNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Atumka napi uchiriya tumau asaram ¿itiurak pengker aa nusha chichastarme? Aints ni nintijai nintimina nunaka páchitsuk chichainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","“Aints pengker aa nuna nintimu asa, nekas pengker aa nunak chichaawai. Tura aints pasé aa nuna nintimu asa pasé aa nunak chichaawai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nunasha tajarme: Tunau jiistin kinta jeamtai, aints nangkamiar chichau armia nu chichamnaka mash Yusen paan ujakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Tura asamtai atumsha pengker aa nu chichaakrumningkia, Yuska atumin pengker awajtamsatnuitrume. Antsu pasé aa nu chichaakrumka wait wajaktinuitrume”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Tamati fariseo ainau, tura Moisésa chichame nuikiartin ainausha Jesúsan chicharinak: —Nuikiartinu, ame wainchati takat turata tusar, iikia wainkatasar wakeraji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Tinamtai Jesús aimiak: —Junia pasé nintintin ainau Yusen umirchau ainayat, wainchati takatan wainkartas wakerinawai. Tura wainiatun wainchati takatnaka turashtatjai. Antsu Yuse chichame etserin Jonás turunamia nunisang wainchati takatnaka wainkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","“Jonás kampatam kinta tsawaisha tura kashisha juun namaka ampujen engkema, jakawa nunisang pujumia nunisnak wikia Yus akupkamutiatnak aints asan, jakan kampatam kinta tsawaisha tura kashisha iwiarsamunam tepestinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Jonás Nínive yaktanam Yuse chichamen etsermatai, nunia aints ainau ni tunaarin mash inaisarmiayi. Wi Jonásan nangkamasnak pujai waitinayat, junia aints ainau wi etsermaurunka antinatsui. Tura Yus tunau jiistin kinta jeamtai, Nínive yaktanmaya jakaru ainau nantakiar, yamai pujuinaun pachisar Yusen: Nu aints tunau armiayi tiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","“Nuniasha yaanchuik Yus Salomónkan ni nekamtairin susamu asamtai, chikich nungkanmaya apu nawantri arakia Salomónka chichamen antuktas tarimiayi. Wikia Salomónka nangkamasnak ai waitinayat, junia nungkanmaya ainau wi etsermaunaka antinatsui. Antsu Yus tunau ainaun jiistin kinta jeamtai, nu nuwaka jakamunmaya nantaki, yamai pujuinaun pachis Yusen ujaak: Nu aints ainau tunau ainawai titinuitai”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Tura Jesús ataksha chichaak: —Iwianch aintsnum engkema pujuu nunia jiinkin asa, aints atsamunam wekaas nuni ayamsatatkama tujintak: Ataksha waketkitaj tu nintimratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Tura asa chichaak: Wi jiinkimiaja nuni waketkitjai tusa nu aintsnum waketki, jea itarka tumaun pakuichau pengker iwiaramua nunisang nu aintsu nintin wainak, ");
INSERT INTO acuNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","nunia waketki, chikich siete (7) iwianchin niin nangkamasarang timiá pasé ainaun juki, tura nujai nu aintsu nintin engkemawartinuitai. Tura engkemtuam nu aintska nuwik pasé pujumia nuna nangkamasang pasé pujustinuitai. Tura asamtai junia nungkanmaya ainau wína nakitrinau asar, yaanchuik pasé puju armia nuna nangkamasarang timiá pasé pujusartin ainawai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús aints ainaun nuiniak pujai, ni nukuri ni yachí ainaujai tariarmiayi. Tura tariar aanum wajasar Jesúsan aujsartas wakeriarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Tura aanum wajasaramtai, chikich aints Jesúsan ujaak: —Nukuram yachim ainaujai aanum wajasar, amijai chichasartas wakerinawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Tamaitiat Jesús nu aintsun chicharak: —¿Yaa ainawa wína nukursha, tura wína yatsursha? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Tu iniam aimkacharamtai, ni nuiniatiri ainaun inakmas: —Juka wína yatsur tura wína nukur ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Aints wína Apaachir nayaimpinam puja nuna wakeramurin umirinauka wína yatsur nunia wína umaar nunia wína nukur ainawai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Nu kintati Jesús jeanmaya jiinki, juun kucha yantamen keemsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Tura aints untsuri kautkaram, Jesús kanunam engkema nuni keemsamtai, aints ainau kucha kaanmatkarin wajasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Turinamtai untsuri nuikiartutai chichamjai aints ainaun nuiniartas chicharak: “Anturtuktaram. Aints arakan tsaamratas ni jeenia jiinkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Tura arak tsaamam, araka jingkiaji jintá kakeekamiayi. Jintá kakeekamtai, chingki kautkar jingkiajin yuwaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Chikich jingkiaji kayanam nungka jumchik amanum kakeekamiayi. Tura kakeak nungka jumchik ayat kakarmachu tsapaimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tura tsapaiyat, tsaa yakí waakak sukuam kaarmiayi. “Tura kangkape atsau asamtai jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Chikich jingkiajisha jangki amanum kakeekamiayi. Jangki tsakar pempearam, araksha nerekchamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Chikich jingkiajisha nungka pengkernum kakeekamiayi. Tura nekas pengker tsapai nerekmiayi. Chikich jingkiaji cien (100) nerekmiayi, tura kitcha sesenta (60) nerekmiayi, tura kitcha treinta (30) jingkiajin nerekmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Aints ainautiram ju chicham antukrum nintimrataram”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Chichas umisamtai ni nuiniatiri ainauti Jesús chicharkur: —¿Waruka aints ainausha nuikiartutai chichamsha ujaa weame? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Takurin Jesús iin chichartamak: —Yus nayaimpinmaya aints ainaun itiur inartinuita tusar, chikich ainau paan nekaachmin wainiatrum, atumka paan nekamtikiamuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Tura asamtai Yuse chichamen antinak nekasar pengker nintinam ukusar, nukap nintimrar pujuinaunka chikich chichamnasha nuna nangkamasang Yus paan nekamtikiatnuitai. Antsu chikich ainau wina chichamrun jumchik antinayat, antutan nakitinau asar, jumchik antukarmia nuka ataksha wári kajinmakiartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tura asamtai nu aints ainau wína chichamrun paan nekatan nakitinau asar, ni jiijaingkia paan waininayat, wainmichua nunisarang ainawai. Tura antutnasha antinayat jampekua nunisarang: Warintua tusar nekaawartatkamawar yuumatinawai. Turinau asaramtai, nu aints ainaun wikia aya nuikiartutai chichaman ujainajai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Nu aints ainaun pachis Yuse chichame etserin Isaías tímia nunaka mash umikuitai. Nu aarmauka nuwaitai. “Yus Isaíasan chicharak: “ ‘Nu aints ainau jiisam chicharkata: Atumka paan antayatrumek antukchatnuitrume. Tura paan wainmatcha wainmayatrumek nekaashtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Nu aints ainau katsuram nintintin asar, kuwishi epekua nunisarang antukartatkamawar tujintinawai. Tura wainmichua nunisarang wainmaktatkamawar tujintinawai. Tu ainiachkungka paan nekaawarminuitai. Tura nekasar antukarminuitai. Tura nintijai paan nintimsar ni tunaarin inaisaramtaikia, wikia nu aints ainaun uwemtikratnuitjai’, Yus Isaíasan timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","17","“Nekasan tajarme: Yaanchuik Yuse chichame etserin ainau, tura pengké aints ainau untsuri atum waintrume nunasha wainkartas wakerinayat wainkacharmiayi. Tura atum antuwearme nunasha antukartas wakerinayat antukcharmiayi. Tura atumka wi turamu wainkau asaram, tura wína chichamur antuku asaram, nekasrum warastinuitrume”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Nunia Jesús ataksha iin chichartamak: “Yamaikia nuikiartutai chichamjai arak tsaamramun pachisan wi takun tajai tamati anturtuktaram. ");
INSERT INTO acuNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Yus aints ainaun nayaimpinmaya inartinun pachisar etsermaun antinayat ¿warina takua tawa? tusar, tenapka nekainachu asaramtai, iwianch tari, ni antukmaurin nintin ukuscharti, antsu wári kajinmakiarti tusa kajinmamtikui. Nu aintska árak jinta kakeekaun chingki kautkar yuwamua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","21","Arak kayanam kakeekamia nuka chikich aintsua nunisarang ainawai. Nu nangkamtaik nu aints ainau Yuse chichamen pengker nintimsar antinayat, nuniangka itiurkachmin amatai, Yusen nakitin ainau wishikinam, Yuse chichamen umirkachmin nintiminak umirtan wári inainawai. Tura asar árak kayanam kakeekamia nunisarang ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Arak jangki amanum kakeekamia nuka chikich aintsua nunisarang ainawai. Nuka Yuse chichamen paan antinayat, ju nungkanmaya aa nuna nintiminawai. Tura kuikiartin wajastaj tu nintimsar, Yuse chichamen nintimtsuk pujuinawai. Tura asar árak jangki amanum kakeekamia nuka pengké nerekchatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Antsu árak pengke nungkanam kakeekamia nuka chikich aintsua nunisarang ainawai. Nu aints ainau Yuse chichamen antukar nintinam ukuinawai. Tura miatrusarang umirinak, Yusen nintimsar pujuinawai. Tura asar cien (100), tura kitcha sesenta (60), tura kitcha treinta (30) nerekua nunisarang ainawai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Nunia Jesús chikich nuikiartutai chichaman nuitamak: “Yus aints ainaun nayaimpinmaya inartinka aints ni ajarin trigon pengkeran araamua nunisketai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Tura aints ainauka mash kaninamtai, ajartinu nemase kashi tari, nu ajanam nupaa jingkiajin trigoa nunisang tsapaiti tusa araamiayi. Tura araa umis waketkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","27","Tura trigo tsapaamtai, nupaasha tsapaimiayi. Tura nupaa tsapaamtai, aja takau ainau nuna wainkar, ajartinun weriar iniinak: ‘Apua ¿ameka pengke trigo araachmakum? ¿Tura nupaasha pasé aa nusha itiurak tsapaiya?’ tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Tu iniinam ajartin aimiak: ‘Wína nemasur aitkayi’, timiayi. Tamati ni inatiri ainau ataksha iniinak: ‘¿Tura nu nupaa pasé aa nuka waruka uwertaram tatsume?’ ");
INSERT INTO acuNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Tu iniinam nuka aimiak: ‘Atsa, turuwairap. Nupaa uweakrum trigo uweni tusaram inaisataram. ");
INSERT INTO acuNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mai metek tsakararti tajarme. Tura mai metek tsakaramtai, juuktin kinta jeamtai, chikich ajan takau ainaun akupkan: Nupaa eemkar uwerar irumrar jingkiawar epeewarti. Nuniasha trigon juukar chumpiwar, jeanam ukusarti tusan akupkatatjai’, ajartin timiayi”. Jesús tu nuikiartutai chichamjai iin nuitamramiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","32","Nunia Jesús ataksha chikich nuikiartutai chichaman ujatmak: “Yuse aintsri itiur yujainawa tusan, chikich nuikiartutai chichamnasha nekamtikiatjarme. Anturtuktaram. Mostaza jingkiaji chikich jingkiaji nangkamasang tuupchitai. Aints nuna ni ajarin araam, tsapai tura tsakar chikich arakan nangkamasang numia nunisang juun wajaayi. Tura kanawe timiá saram asamtai, chingki yakiiya kaunkar, mostaza kanawen pasungminawai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Nunia ataksha chikich nuikiartutai chichaman ujatmak: “Nuwa pangkan najanatas trigo sairin nekapmar, pang pachimtaijai pachimui. Yus aints ainaun nayaimpinmaya ina nuka nu nuwa turawa nunisang turawai”, turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús nuikiartutai chichaman untsuri aints ainaun nuinimiayi. Antsu nuikiartutai chichamchaujaingkia aints ainaun nuinichmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Jesús aints ainaun tu nuiniaru asa, yaanchuik Yuse chichame etserin aarmaurin miatrusang umikmiayi. Nu aarmauka nuwaitai: “Aints ainaun nuikiartutai chichamjai ujaktinuitjai. Yus nu nangkamtaik nintimramia nuna aints pengké nekaachminun wainiatnak, wikia aints ainaun chichasan nekamtikiatnuitjai”, tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Jesús aints ainaun ukuki, jea wayaamtai, ni nuiniatiri ainautisha jea wayaar Jesús chicharkur: “Nupaa trigojai pachimramu ajanam araamu nuikiartutai chichamka nuwaitai tusam ujakratkata”, timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Takurin Jesús iin airmak: “Ayu, anturtuktaram. Wikia aints ayatun Yus akupkamu asan, aints trigo jingkiajin araawa nunisketjai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Tura ajan pachisan taja nunaka mash nungkanmaya ainaun takun tajai. Tura trigo jingkiaji taja nunaka Yusen nekasampita tinu ainaun takun tajai. Antsu nupaa pasé aa nuna pachisan taja nunaka Satanásan umirkaru ainaun takun tajai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Aints nupaan pasé araamia nuna pachisan taja nunaka Satanásan takun tajai. Tura trigon juukmaun pachisan taja nunaka nungka amuamunam Yus aints ainaun mash irurmanum ni takatrin jiistin takun tajai. Tura ajan takau ainaun pachisan taja nunaka Yuse awemamuri ainau aints pasé ainaun, tura pengker ainauncha irurtinuitai takun tajai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","41","Wikia aints ayatun Yus akupkamu asan, Yuse awemamuri ainaun akupkan, chikich aintsun tunau takamtikin ainaun, tura tunau takau ainauncha mash irurarti tusan awematnuitjai. Ajan takau ainau nupaan yaruakar keemakartas jinum japinawa nunisarang Yuse awemamuri ainau tunau ainaun irurartinuitai. Nungka amuamunam tu atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Tura tunau ainaun ji tuke kajintrashtinnum chumpiawaram, nuni wait wajainak juutinak tura nain katertinak matsamsartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Tura Yuse wakeramuri umirkaru ainau ni Apaachiri Yuse pujutirin jear, tsaa jiitsumir tsantua nunisarang pujusartinuitai. Atumka wi etsermaur antuku asaram nintimrataram”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Nunia Jesús ataksha iin nuitamak: “Yusnum pujustinun pachis chikich nuikiartutai chicham antuktaram. Yusnum pujustinka kuri kajunam chumpiar nungka taimunam uukmawa tumawaitai. Tura asamtai nu kajun uukmia nuka jakamtai, chikich aints nungkan tai kajun aneachmaun wainak urak jiis waras, nunia ataksha epeni nungkajai yukuar ni jeen waketki, ninu aa nuna mash suruk, nunia kuikiancha mash irur, nu kuikiajai ajanka sumawai. Tura ajan sumaku asa, nu kajuka niinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Nunia Jesús ataksha nuitamak: “Kichnasha tajarme: Yusnum pujustin pachisrum chicham antuktaram. Aints shaakun sumin shaak nekas akik shiiram wawiknumia jukimun eaktinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Tura wekaa wekaaka kichik shaakun timiá akikian wainak, sumaktatkama kuikiari jeachu asamtai, ninu aa nunaka mash suruk, nujai nu shaakun sumaktinuitai. Nu shaakun timiá akikian aints wakerina nuna nangkamasarang Yusnum pujustinnaka nekasar wakerukartinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Nunia Jesús ataksha iin nuitamak: “Kichnasha tajarme: Yusnum pujustinka red sarma tumawaitai. Kuchanam reden nangkimiawar namaknasha mash pachitsuk achiinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Nunia red piakamtai, namakan achiu ainau japikiar kaanmatkanam tuksar, namakan jiisar, pengker ainaun changkinnum chumpinawai. Antsu yuchatai ainaun kuchanam japinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Nungka amumanum aints namakan achiinawa nunisarang Yuse awemamuri tunau nintintin ainaun akankar, tura pengke nintintin ainauncha akankar irurartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Tura tunau ainaun ji tuke kajintrashtinnum chumpiawaram, nuni wait wajainak juutinak tura nain katertinak matsamsartinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Nunia ni nuiniatiri ainauti ininmak: —¿Atumsha wi etserkaja nu paantak antukuram? —turammiaji. Tu ininmamtai: —Ja ai, Apuru, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Tu aimkau asakrin ataksha chichartamak: —Yus aints ainaun nayaimpinmaya inawa nuna pachis Yuse chichame nekau chichaman nuimiaru asa, chikich ainaun nuiniartas wakerakka, jeenua tumawaitai. Jeentin ni aintsrin yuumamurin suwak, yaanchuik sumakmia nuna, tura yamai sumakma nunasha ni aintsri yuumamurijai metek suawai, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Nu nuikiartutai chichaman mash umis, Jesús nunia jiinki, ");
INSERT INTO acuNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ni tsakarmaurin wemiayi. Tura nuni jea, iruntai jeanam waya, aints ainaun nuiniatan nangkamamiayi. Tura nuininam aints ainau untsuri Jesúsa chichamen antukar nintiminak: —¿Junasha yáki ni nekamtairincha nuiniaria? ¿Wainchati takatan turati tusasha, yáki kakarmarincha susaya? ");
INSERT INTO acuNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Juka tau takakminu uchirinchukai? ¿Ni nukuri Maríchukai? ¿Tura ni yachí Santiago, tura José, tura Simón, tura Judas naartinchaukai? ");
INSERT INTO acuNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ni umaji iijai pujuinauka mash wainiaji. ¿Tuniana jusha nekamtairincha tura kakarmarincha juwawa? —tunaiyarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tura asar Jesúsan suwirpiaku jiinak pachischarmiayi. Pachischaram Jesús chicharak: —Yuse chichame etsernun aints mash anturinawai. Antsu ni nungkarin pujuinausha ni weari ainausha anturinatsui, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Tura nunia aints ainau niin nekasampita tichau asaramtai, Jesús nuningkia wainchati takatnaka untsurinka turachmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Jesúsan pachisar untsuri chichainamtai, Galilea apuri Herodes nu chichamnasha antukmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Tura asa ni inatiri ainaun chicharak: “Nekas Imiakratin Juankuitai. Nuka jakayat jakamunmaya nantakin asa, Yuse kakarmarijai wainchati takatan takaawai”, ningki nintimias timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Herodes ni yachí Felipe iwiaaku pujaun wainiat, yachí nuwarin nuwatkamiayi. Nu nuwaka Herodías naartinuyayi. Tura asamtai Juan apu Herodesan chicharak: “Yachim iwiaaku pujau wainiatum, ni nuwari nuwatkamiame nunaka Yus surimiawai”, timiayi. Tamati apu Herodes: Turutam tusa, Juankun maatas wakerayat, aints ainau chichainak: “Juan nekas Yus akupkamu asa, Yuse chichamen etserui”, tinu asaramtai, Herodes aints ainaun shamak: Juankun maataj tutsuk ni suntari ainaun akupak: “Aya achikrum kársernum engkeataram”, tama suntar ainau Juankun achikiar kársernum engkewarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Turuwaramtai apu Herodesa akiinamuri kinta tsawaaramtai, Herodes: Jiiritaram tusa, ni aintsri ainaun untsukmau asar, mash Herodes pujamunam iruntraramtai, Herodíasa nawantri waya ningki jiaamramiayi. Tura jiaamak apu Herodesan timiá pengker awajam, ");
INSERT INTO acuNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","nuka nawantan chicharak: “Yusjai nekasan tajame: Waring achat ame seatkumningkia, nunaka nekasan surittsuk susatatjame”, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tamati ni nukurin weri: —¿Warinak seataj? —tu iniam, tu tita tusa akatramu asa, nu nawanka apu Herodesan weri: —Imiakratin Juanku muuke puwatnum engkeam surusta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Tama nuna antuk, apu Herodes wake mesekiat, irau ainausha mash antinamunam Yusjai tajai tinu asa, ayu timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Tura ni suntarin akatar akupak: —Juanku muuke akakrum itataram, —tama suntar ainau kársernum weriar muuken akakar, ");
INSERT INTO acuNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","puwatnum engkewar nawantan susarmiayi. Tura susam nawan puwatun juki nukurin susamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Turamtai Juanku nuiniatiri ainau kaunkar ni namangken jukiar, aints iwiartainum iwiarsarmiayi. Nuna turuwar Jesúsan ujakartas wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús Galilea nungkanam pujus, Juan maamun chichaman antuk kanunam engkema, ningki aints atsamunam wemiayi. Weamtai aints ainau nuna nekaawar, kucha yantamen Jesús nujamkatnunam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Tura nuni jearamtai, Jesús nujamak aints timiá untsurin wainak wait anentramiayi. Tura asa jaun itaarmia nuna tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Tsaa akaamtai, ni nuiniatiri ainauti Jesús chicharkur: —Tsaa akaawai. Juni aintsu pujutiri atsau asamtai, yakat arakchichu amaunum werum, yurumak sumaataram tusam aints ainau akupkarta, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Tu takurin Jesús chichartamak: —Ju aints ainauka wecharminuitai. Antsu atumek ni yuwatniuri susataram, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Turammatai iikia chicharkur: —Pang iinuka ju uwejchik nuke arutramji. Namaksha jimiarchik nuke arutramji, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Tu takurin Jesús chichartamak: —Nuka wína surustaram, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Tura aints ainau chirichrinam pujusarat tusa akatram, mash chirichrinam pujusaramtai, Jesús pangkan ju uwejchik takus, tura namaknasha jimiarchik takus nayaimpinmanini pangkai jiimias, Yusen maaketai timiayi. Nunia pangkan puuk, ni nuiniatiri ainautin suramsamtai, iisha aints ainau mash susarmiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","21","Tura susaram mash yuwaar tutuararmiayi. Nuna yuwaruka nuwa ainausha, tura uchi ainausha nekapmatsuk aishmangkuk aishmangkuk cinco warang (5,000) yuwarmiayi. Tura yuwaar umisaramtai, ampintrausha doce (12) changkin chumpiar jukimiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Nunia Jesús ni nuiniatiri ainautin chichartamak: “Kanunam engkemaram katingkrum eemajataram. Wikia aints ainaun aujsan umisan winitatjai”, turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tura aints ainaun aujas ukuki, ningki Yusjai chichastas muranam wakamiayi. Tura kashi japeng ningki Yusen seak pujai, ");
INSERT INTO acuNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","kanuka kucha japen wemiayi. Tura weai, nase nujinmanini kakar nasenmatai, kucha tamparamuri chaker chaker wajamtai, kanu ukantias wakerimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Atash shinutnak wajai, Jesús juun kuchanam nungkanma nunisang nawejai najamas wekaas winimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Jesús winamtai, ni nuiniatiri ainauti nu wainkar shamakur kakarar chichaakur: —Wakanchawashi, —tunaimiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tu takurin Jesús chichartamak: —Kakaram wajastaram. Wiitjai shamrukairap, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Tama Pedro chicharak: —Apuru, nekasam ametkumka, ame wekaame ani winasha winita turutta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Tama Jesús ayaak: —Ayu, winita, —timiayi. Tama Pedro kanunmaya jiinki, kuchanam nawejai najamas wekaas, Jesúsnum jeatas wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Turayat nase kakaram nasentun wainak Pedroka shamkamiayi. Tura shamau asa, kuchanam wayaak untsumak: —Apuru, uwemtikrurta, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Nu tamaujai metek Jesús ni uwejen achik chicharak: —¿Waruka nekasampita turutsume? ¿Waruka tujinkachuitme tu nintimturtsume? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Tura Jesús Pedrojai kanunam engkemawaramtai, nasengka nangkamarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Turamtai ni nuiniatiri ainauti Jesús naka tikishmatrar: —Nekasam Yuse Uchirinme, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Tura juun kuchan katingkiar, Genesaret nungkanam nujamkamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Tura nujamkakrin nunia aints ainau nuna wainkar: “Auka Jesúsaitai”, tusar nuna nekaawar, nu nungkanmaya ainausha mash nekaawarat tusar chichaman akupkaramtai, jau ainaun Jesús pujamunam itaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Tura asaramtai jau ainau Jesúsan seainak: “Wejmakrumi ninukmaurinak antingtasan wakerajai. Nu tsangkatrukta”, tiarmiayi. Tura nuna antingkiaruka mash tsaararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Tura fariseo ainau Moisésa chichame nuikiartin ainaujai Jerusalénnumia tariar, Jesúsan iniinak: ");
INSERT INTO acuNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—Ami nuiniatiram ainau ¿waruka yaanchuik ii juuntrin akupkamu umirtsuksha uwejen ikimiatskesha yuwinawa? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Tinamtai Jesús aimiak: —Yus: Wína chichamur umirtuktaram tusa, atumin akupturmakmia nu umirtsuk pujayatrumsha ¿waruka aintsu chichamesha juun ainau tinu armia nusha umirume? ");
INSERT INTO acuNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Yus chichaak: ‘Aparmesha tura nukurmesha pengker awajsataram. Tura aints ni aparincha, tura ni nukurincha pachis pasé chichaamtaikia, nu aintsnaka maawarti’, Yus timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Antsu atumka chichaakrum: Aints ni aparincha, tura ni nukurincha chicharak: ‘Wikia winar aa nunaka mash Yusen susamjai. Tura asan atumin susatasan wakerayatun yamaikia tujintajai’. ");
INSERT INTO acuNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Tu tinu ainauka ni aparincha, tura ni nukurincha yaaitsuk pujusartinuitai tarume. Tu tinu asaram atumi juuntri tinu armia nu umiktasrum, Yus winia chichamur umirtuktaram tímia nuka inaiyarme. ");
INSERT INTO acuNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Waitrin ainautiram, yaanchuik Yuse chichame etserin Isaías atumin pachis aarmia nuka nekasaintai. Nu aarmauka nuwaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Yus chichaak: ‘Nu aints ainauka aya chichasarang: Ameketme juuntam turutinawai. Antsu nintijai yaja nintimsar, wínaka nintimturinatsui. ");
INSERT INTO acuNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","“ ‘Tura aintsu akupamurinak nuininayat wínaka nangkamiar: Ameketme juuntam turutinawai’, timiayi. Isaías tu aarmiayi, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nunia fariseo ainaujai tura Moisésa chichamen nuikiartin ainaujaisha chichas umis, ataksha aints ainaun untsuk chicharak: —Anturtuktaram. Tura wi taja nuka nekaataram. ");
INSERT INTO acuNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Aintsu jangken waring achat waya nujaingkia tunauka wajaschatnuitai. Antsu aintsu nintinia jiinua nuka aints ainaun tunau awajmamtikui, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Tama ni nuiniatiri ainauti Jesús aujsatasar tarir chicharkur: —¿Fariseo ainau chicharkum tame nuna antukar kajertamina nu nekamek? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Tu tama Jesús iin airmak: —Ja ai, nekajai. Nuka wína Apaachir nayaimpinam puja nuna aintsrinchu asaramtai, nupaa kangkaptuk uwerar japatnua nunisarang artinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Inaisataram. Nuka wína chichamrun umitan nakitinau asar, aints wainmichua nunisarang ainawai. Aints wainmichu ayat, chikich wainmichun jintan inaktustas wakera nunisarang ainawai. Aints wainmichu chikich wainmichun jintan inaktustas wakerayat, jinta weenak mai waanam iyaartinuitai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Turammatai Pedro Jesúsan chicharak: —Aintsu jangken waring achat waya nujaingkia tunauka wajaschatnuitai, tame nuka ¿warí pachismea tame? Nuka paan ujakratkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Tama Jesús chichartamak: —¿Atumka nuka nekatsrumek? ");
INSERT INTO acuNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Aints yurumkan yuwamu jangkenam wayaangka nintinam wayaachu asamtai tunauka wajatsui. Tura wakenam wayau asa, nuniangka ataksha jiini. ¿Nuka nintimtsurmek? ");
INSERT INTO acuNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Antsu aintsu chichame ni jangkenia jiina nuka nintinia jiinkin asa, nuka aintsun tunau awajmamtikui. ");
INSERT INTO acuNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Tunau nintimtai ainauka aintsu nintinia jiinui. Tura aints maatnusha, tura aishrintin wakeruktincha, tura nuwentin wakeruktincha, tura tsanirmatnusha, tura kasamkatnusha, tura anangkartuatnusha, tura Yusen pachis, nunia aintsun pachisar pasé chichastincha nintinmaya jiinu asa, ");
INSERT INTO acuNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","aintsun tunau awajmamtikui. Antsu ikimiatsuk yuta yuwatniuka aintsu nintin tunau awajmamtiktsui, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús ni nuiniatiri ainaujai nu nungkanmaya jiinki, chikich nungkanam Tiro yaktanam, tura Sidón yaktanmasha wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Tura nuni jea, Canaánnumia nuwa judíochutiat, Jesúsan jiistas tari untsuak: —Apu Davidta weariya, wait anentrurta. Iwianch nawantru namangken engkemtuamu asa, nukap wait wajawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Tamaitiat Jesúska aimtsuke wajamiayi. Turamtai ni nuiniatiri ainauti tarir chicharkur: —Iin nemartamas untsumkinij waja juka akupkata, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Tu takurin Jesús nuwan chicharak: —Israel ainau uwija mengkakawa nunisarang pujuinau asaramtai, Israelnumak wína Yus akuptukmiayi, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Tama nu nuwaka Jesúsan naka tikishmatar seak: —Apuru, yainkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Tu seamaitiat Jesús nuikiartutai chichamjai ayaak: —Uchi pangkan yuwinau atankir yawaa uchiri suamuka napchawaitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Tamaitiat nu nuwaka ayaak: —Nekasam tame, Apuru. Antsu uchi yutairi misa wamketin ayaarunka yawaa uchiri nekasar yuwinawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Tama Jesús chicharak: —Nuwachi, wína nekasampita turutu asam, ame wakerame nunisang ati, —timiayi. Tama nu chichaamujai metek ni nawantri pengker wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús nu nungkanmaya jiinki, Galilea nungkanam wekaas, juun kucha yantamen nangkamaki, mura waka nuni keemsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Turamtai aints wekaichau ainauncha, tura wainmichu ainauncha, tura chichachu ainauncha, tura uweje kupirkamu ainauncha, tura chikich najaiminak pujuinauncha Jesús pujamunam itaar, nawen ayaamsar pujsarmiayi. Nu jau ainaun itaaramtai, Jesús mash tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Turamtai aints ainau nuna wainkar chichachu ainausha chichainamtai, tura uweje kupirkamu pengker wajainamtai, tura wekaichau ainausha pengker wekainamtai, tura wainmichu ainausha pengker wainminamtai, nuna mash wainkar nintimrarmiayi. Tura Israel ainau Yusri nekas kakarmaitai tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Nunia Jesús ni nuiniatiri ainautin untsurmak mash irutmar chichartamak: —Ju aints ainaun wait anentajai. Kampatam kinta wijai iruntrar pujuinau asar, yutancha yutsuk pujuinawai. Tura asar jinta weenak, tsukarijai juwikcharai tusan, yurtsuk ni jeen awematnaka nakitajai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Turamatai ni nuiniatiri ainauti chicharkur: —Tura juni aints atsamunmasha aints timiá untsuri yuratasrisha ¿tuniang yurumkasha sumaktaij? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Tu takurin Jesús ininmak: —¿Pangsha warutma takakrume? —tu ininmamtai iikia aimkur: —Siete (7) takakji, namakchisha jumchik takakji, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Tu takurin aints ainaun chicharak: —Nungkanam mash pujustaram, —tamati ni tímia nunisarang pujusaramtai, ");
INSERT INTO acuNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Jesús pangkan siete (7) amia nuna takus, tura namaknasha takus, Yusen maaketai tusa, pangkan puuk ni nuiniatiri ainautin suramsamiaji. Turamtai iisha aints ainau kichik kichik mash susamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Turakrin mash yuwaar tutuararmiayi. Tura ampintramuri changkin siete (7) amia nuni chumpiamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Tura nuna yuwaaruka nuwa ainausha tura uchi ainausha nekapmatsuk, aishmangkuk aishmangkuk cuatro warang (4,000) armiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Nunia Jesús nu aintsun: Weajai tusa kanunam engkema Magdala nungkanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Jesús nuni jeamtai, fariseo ainau saduceo ainaujai iisha nekaatai tusar taarmiayi. Tura taar Jesúsan seainak: —Nayaimpinmaya kakarmarijai wainchati takat turata. Iisha wainkatasar wakeraji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Tu tinam Jesús ayaak: “Atum chichaakrum: ‘Tsaa jeaak nayaim kapantin wajasamtai, kashin kinta pengker tsawartatui’, tinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Tura tsawaarkuram: ‘Mukunit nukap au asamtai, tura nayaim kapantin wajasamtai yumi jiturtatui’, tinuitrume. Nayaim jiisrumka: Kinta tu atatui tusaram nekaamnawaitrume. Antsu wi turaja nuka wainkayatrumek, Yus atumin nekamtikramatas wakera nuka nintimtsurme. ");
INSERT INTO acuNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Junia pasé nintintin ainau Yusen umirchau ainayat, wainchati takatan wainkartas wakerinawai. Tura wainiatnak wainchati takatnaka turashtatjai. Antsu Jonása turunamuriya tumau wainchatai takatnaka nunak wainkartinuitai”, tusa ukuki tumajin katingmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Tura Jesús ni nuiniatiri ainautijai tumajin katingkiar, pang kajinmakir jukichmiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Turakrin Jesús chichartamak: —Fariseo pang pachimtairi jurukirap, tura saduceo pang pachimtairisha jurukirap, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Turamkurin ni nuiniatiri ainauti chicharnaiyakur: —Pang kajinmakin asakrin turamtsujiash, —tunaimiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Tu chichaakur pujarin Jesús nuna antuk iin chichartamak: —¿Waruka pang kajinmakmiau pachisrumsha chichaarme? ¿Waruka wína chichamrusha nintimtsuksha pujarme? ");
INSERT INTO acuNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Pang cinco (5) amia nujai cinco warang (5,000) aints yuramuka nuka aneaktsurmek? Tura ampintramuri ¿warutam changkina jukimiarume nusha aneaktsurmek? ");
INSERT INTO acuNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Nuniasha pang siete (7) amia nujai cuatro warang (4,000) aints yuramuka nuka aneaktsurmek? ¿Tura ampintramuri warutam changkina jukimiarume nuka aneaktsurmek? ");
INSERT INTO acuNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Waruka wína chichamur nintimtsuksha pujarme? Fariseo pang pachimtairi jurukirap, tura saduceo pang pachimtairisha jurukirap, taja nuka wikia pangnaka tatsujrume, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Turammatai ni nuiniatiri ainauti paan nintimrar: “Pang pachimtai pachiska turamtsuji, antsu fariseo ainau, tura saduceo ainauka anangkartin asaramtai, ni nuikiartamuka anturkairap tusa turamji”, tusar nekaamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Nunia Jesús ni nuiniatiri ainautijai Cesarea Filipos nungkanam jinta weamunam Jesús iin ininmak: —Wikia aints ayatun Yus akupkamu asan, chikich aints ainau wína pachitsar: ¿Warí aintsuita turutinawa? —tu ininmasmiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Tu iningkratmatai aimkur: —Chikich ainau amin pachitmasar: Imiakratin Juankun maawarmia nuchawashi turaminawai. Tura chikitcha Elíaschawashi turaminawai. Tura chikitcha: Jeremíaschawashi turaminawai, antsu nuchawaitkusha, chikich yaanchuik Yuse chichame etserin pujumia nuwashi turaminawai, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Tu tinu asakrin Jesús ataksha ininmak: —¿Tura atumsha winasha warintrutrume? —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Tu iniam Simón Pedro aimiak: —Ameka Mesíasaitme. Yus tuke iwiaaku puja nuna Uchirinme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Tama Jesús chicharak: —Nekasam tame, Jonása uchiri Simónka. Aints kichkisha aminka nunaka nekamtikramacharmayi, antsu wina Apaachir nayaimpinam puja nu amin nekamtikramau asamtai tame. Ame turutin asakmin, Yus amincha waramtikramsati tajame. ");
INSERT INTO acuNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Tura nunasha tajame: Ameka kaya tumau asakmin Pedro inaikiamuitme. Tura aints ainau kaya pisujai jean jeamina nunisnak wína nekasampita turutin ainauka wína aintsur arti tusan inaikiatnuitjai. Tura Yuse nemase ainausha tuke mengkakatnunam weenausha wína aintsur ainaun maawartin ainayat, niin nepetkartatkamawar pengké tujinkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Tura asamtai ameka aints waiti yawikmaun urawa nunismek ju nungkanam pujuinau wína chichamur nayaimpinam jeatin pachisam etserkumningkia, aints ainau nu chichaman nekasampita tinauka nayaimpinmasha jeartinuitai. Tura nayaimpisha yawikmawa nunisang au asamtai, ju nungkanam nu chichaman nekasampita ticharu ainauka nayaimpinmaka jeachartin ainawai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nunia ni nuiniatiri ainautin chichartamak: —Wína pachitsaram: Auka Mesíasaitai tusarmeka aints kichkisha ujakairap, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Nu kintati Jesús ni nuiniatiri ainautin ni jakatniurin pachis ujatmatan nangkamamiayi. Tura ujatmak: —Wikia Jerusalénnum wetin ajai. Tura nuni wi jeamtai, judío juuntri ainau, tura sacerdote juuntri ainausha, tura Moisésa chichame nuikiartin ainausha nukap wait wajakti tusar, wína mantuwartatui. Tura wainiatnak kampatam kinta jakan tepayatun, ataksha nantaktatjai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Tama Pedro Jesúsan akanak juki chicharak: —Apuru, Yus surimramkati. Aminka nunaka turutmacharti, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Pedro Satanása nunisang chichau asamtai, Jesús Pedron ayanmatar chicharak: —Satanása weta. Ameka winaka itit awajtame. Ameka Yuse wakeramuringkia nintimtsume, antsu aints wakerina nuke nintimme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Nunia ni nuiniatiri ainautin chichartamak: —Aints wína nemartustas wakerakka ni wakeramurinka inais, wikia mianchawaitjai tusa, aya wínak nemartusti. Tura wína nemartakka, aints ni krusrin juwawa nunisang ni jakatniurin shamtsuk wínak nemartusti. ");
INSERT INTO acuNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aints ningki nintimias: Wikia jakashtatjai tauka jakatnuitai. Antsu aints wína anentak jakatata nuka jakayat tuke iwiaaku pujustinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","“Nintimrataram. Aints ju nungkanam aa nuna mash sumak, pengké yuumatsuk pujayat, ni wakani tuke mengkakamtaikia, ¿itiurak tuke iwiaakusha pujusting? Tura aints nekas uwemratas wakerakka, tura tuke Yusnum pujustas wakerakka ¿warutam kuikianak akiimiak uwemratnuita? ");
INSERT INTO acuNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Wisha aintsutiatnak Yus akupkamu asan, wína Apaachiru kakarmarijai winakun, tura ni awemamurijai winakun, aints ainaun mash ni turamurijai metek pengker ainauncha pengker awajsartinuitjai, tura tunau ainauncha wait wajaktinnasha susartinuitjai. ");
INSERT INTO acuNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“Nekasan tajarme: Wikia aints ayatun Yus akupkamu asan, Yuse kakarmarijai aints ainaun inartatja nunaka wijai juni tsaniasar pujuinauka jatsuk waitkartatui, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis (6) kinta nangkamaramtai, Jesús Pedroncha, tura Santiagoncha, tura ni yachiin Juannasha akanak juki, mura juunnum wakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Tura wakaarai, Jesús aneachmau yapaijmiama jiitsumir wajaun wainkarmiayi. Tura yapiisha tsaa tsantua nunisang tura entsatirisha nekas puju tsaa tsantua nunisang jiitsumir amiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Nunia Moisésnasha, tura Elíasnasha, Jesúsjai chichainaun wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Nuna wainak Pedro Jesúsan chicharak: —Apuru, juni ii pujustincha nekas pengkeraitai. Ame wakerakminkia, kampatam jeawach jeamkami, kichik aminu, tura kitcha Moisésnau, tura kitcha Elíasnau ati, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Pedro tu chichaak wajai, yurangkim nekas puju winimiayi. Turamtai mikinnum wajainai, nu yurangminmaya chichaun antukarmiayi. Yus niin chicharak: —Juka wína Uchiruitai, wína aneetiruitai. Junaka pengker nintimtusan pujajai. Juka nekasrum anturkataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","—Yus tamati nu chichaman antukar, Jesúsa nuiniatiri ainau nukap shaminak pinakumrar tepesarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Tuminamtai Jesús taa, ni nuiniatiri namangken anting chicharak: —Shamkairap, antsu wajaktaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Tama pangkainiar jiisar, aya Jesúsnak wainkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nunia muranmaya kuankiar, Jesús ni nuiniatiri ainaun akatar akupak: —Aints ayatun Yus akupkamu asan, wikia jakamunmaya nantaatsain atum waitkarume nuka pengké etserkairap, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Tama ni nuiniatiri ainausha Jesúsan iniinak: —¿Moisésa chichame nuikiartin ainausha warukaya Mesíaska taatsaing, Elías eemak tatinuitai tinawa? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Tu tinam Jesús aimiak: —Nekas Elías eemak taa mash iwiaratnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Tura wisha atumin tajarme: Elíaska yaanchuik tamiayi. Tura waininayat aints ainau: Juwaapita tusar pengké nekaacharmiayi. Antsu pasé asar, niin pasé awajsartas wakeriarmia nunaka mash turuwarmiayi. Tura wínaka Yus akuptuku waitinayat aints asamtai, winasha nunisarang wait wajakti tusar, pasé awajtukartatui, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Tama ni nuiniatiri ainau nintimsar: Imiakratin Juankun pachisampi tawa tusar nekaawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ataksha aints pujuinamunam jearamtai, aints tari Jesúsan naka tikishmatramiayi. Tura chicharak: ");
INSERT INTO acuNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Apuru, uchir wait anentrata. Nukap wait wajawai. Tuke wichi wajaki, nuniangka ji kapaamunam ayaaweawai. Tura entsanmasha pe ayaaweawai. ");
INSERT INTO acuNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Tura asamtai ami nuiniatiram ainaun uchirun tsuwatrurarat tusan itarmiajai. Turayat tujinkari, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Tama Jesús chicharak: —Maj, Yus nintimchau asaram, winasha nekasampita turutaram tusanka ¿warutam musachik atumjaisha pujustaj? Tura tupin nintimrataram tusanka ¿warutam musachik atumnasha nakastajrume? Watska, uchi itartitaram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Tama uchin itarim, Jesús uchi namangkenia iwianchin jiiki jiyak akupkamiayi. Turam nu uchikia pengker wajasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Turamtai jumchik arus ni nuiniatiri ainauti Jesúsjai kanakar iik pujusar Jesús chicharkur: —¿Warukakrik iikia iwianch jiiktatkamarsha tujinkamji? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Tu takurin Jesús chichartamak: —Yus miatrusrumek nintimtachu asaram, iwianch jiiktatkamaram tujintarme. Nekasan tajarme: Mostaza jingkiaji timiá tuupich ayat nuka tsapai, chikich nupaa nangkamasang nekas juun wajaayi. Atumsha mianchau ayatrumek, winaka nintimtursaram: Nekasam tujinkachuitme turutkurminkia, wi turataram tinu asamtai, mura nekas juun wainkaram, nu mura chicharkuram: ‘Juni mengkakam ataksha atu tsapuitia’, takurminkia turunamnawaitai. Aints wína: Nekasampi tujinkachuitme turutuka ni tujinkamuringkia pengké atsutnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Antsu ijiarmaram Yus nukap seatkuram nu iwianch ainau jiiktinuitrume, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nunia jiinkir Galilea nungkanam iruntrar wekaasar, Jesús ni nuiniatiri ainautin chichartamak: —Wikia Yus akupkamutiatnak aints asamtai, aints ainau wína mantuwartas achirkartatui. ");
INSERT INTO acuNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Tura maamaitiatnak kampatam kinta tepayatun ataksha nantaktatjai, —turammiaji. Turamin asamtai ni nuiniatiri ainauti nu chicham antukar nukap wake mesekmiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Nunia jiinkir Jesús ni nuiniatiri ainautijai Capernaum yaktanam jeamiaji. Tura nuni jearin, Yus seatai juun jea iwiarami tusar kuikian juu ainau Pedron jiisar iniinak: —¿Yuse jee iwiaratnun akiimina nunasha atumi nuitamnusha akiimiaktimpiash? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Tu iniinam Pedro: —Ja ai, —timiayi. Tura jea waya chichaatsaing, Jesús niin chicharak: —Simónka ¿amesha itiur nintime? ¿Junia apu ainausha yana kuikiarina juwinawa? ¿Ninu aintsri kuikiarinak juriina? ¿Antsu turachkungka chikich aintsu kuikiarinak juriina? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Tu iniam Pedro aimiak: —Nekasar chikich ainau kuikiarin juriinawai, —tamati Jesús chicharak: —Nekasam tame. Ii nungkarin akiinautikia akiimiakchatnuitji. ");
INSERT INTO acuNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Antsu iin kajertamkarai tusar akiimiakmi. Ame tsau jukim kuchanam weta. Tura nangkimiam namak nu nangkamtaik tsaun yuwa nu wakemim, jangke iwiankam kuik engketu wainkatatme. Nu kuik jukim, Yus seatai jeanam weme, jean iwiararti tusam, aminusha tura winarusha ati tusam akiimiakta, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Nu kintati ni nuiniatiri ainauti Jesús tarir chicharkur: —¿Yuse pujutiri nayaimpinmaka aints ainau jeartinua nuka chikich ainaun nangkamasarkesha ya ainia? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Tu iniam Jesús uchin untsuk japen awajas ni nuiniatiri ainautin ");
INSERT INTO acuNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","chichartamak: —Nekasan tajarme: Atumi nintimtairi yapajiaram uchia nunisrumek wína nintimturchakrumka, Yuse pujutirin nayaimpinmaka jeashtinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Tura asamtai aints miajuitjai tutsuk, antsu ju uchia nunisang nintimturas pujauka chikich ainaun nangkamasang Yuse pujutirin jeatnuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Aints wína nintimturas pujauka ju uchia nunisang aints mianchau ainaun nekas pengker awajuka winasha nunisang pengker awajtawai, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Nunia Jesús nuikiartutai chichamjai iin nuitamak: “Tura aints uchin wína umirtinak pujuinaun tunaun takamtikmataikia, nuna turashti tusar, tunau takamtiknu kuntujen kaya juuntan jingkiatawar, juun kunanam ujungkaramtaikia, timiá pengker atinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Chikichan tunau takamtikin ainauka tuke irunui. Antsu tunau takamtikin ainau tuke wait wajakartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Tura asamtai atumi uweje tunau takamtikramataikia, ataksha tunau takasai tusaram, atumi uweje met charawa nunisrumek tunaarum japaram ukuktaram. Tura tunaanum wekaakurmeka, atumi nawe met charawa nunisrumek tunaarum japaram ukuktaram. Nekasrum kichik uwejjai, tura kichik nawejaisha tuke iwiaaku pujustinnum jeatin timiá pengkeraitai. Antsu mai uwejtuk, tura mai nawentuk ji kajintrashtinnum jeatnuka timiá paseetai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Tura atumi jiijaisha tunau aa nu jiiakrumka, atumi jii kuinua nunisrumek tunaarum japaram ukuktaram. Nekasrum kichik jiijai tuke iwiaaku pujustinnum jeatnuka timiá pengkeraitai. Antsu mai jiintuk ji kajintrashtinnum jeatnuka timiá paseetai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Nunia Jesús ataksha iin nuitamak: “Tura asamtai atumin tajarme: Yuse awemamuri aints mianchau ainaun wainin asar, wína Apaachir nayaimpinam puja nuna nakaj pujuinawai. Tura asar atumi turamurincha wína Apaachirnasha ujainawai. Tura asaramtai mianchau ainau ju uchia nunisarang pujuinauka nakitrairap. ");
INSERT INTO acuNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wisha aints ayatun Yus akuptuku asamtai, aints mengkakaru ainaun uwemtikratasan tamiajai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Nintimrataram. Aints cien (100) uwijartin ayat, uwijari kichik menakamtai, chikich noventa y nueve (99) mengkakacharu ainau muranam pujusarat tusa ukuki, kichik mengkakaun wainkataj tusa eawai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Tura nu uwija mengkakaun wainak nukap waraawai. Antsu chikich noventa y nueve (99) mengkakacharu ainaun wainkangka miatruska waraatsui. ");
INSERT INTO acuNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Tura atumi Apaachiri nayaimpinam puja nusha nunisang aints mianchau kichkisha mengkakarti tusangka wakeratsui”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Nunia ataksha Jesús iin nuitamak: “Aints Yusen nemarin amin pasé awajtamatikia, amek ningki akankam chichasta. Tura nijai chichaakum, ni pasé turamuri ujakta. Turakum ni anturtamkamtaikia, nu aintska uwemrati tusam yaingkume. ");
INSERT INTO acuNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Antsu amin anturtamkachamtaikia, aints kichik tura jimiarchiksha jukim, ataksha jiistasrum weritaram. Tura chichaman paan nekaati tusaram iruntraram chicharkataram. ");
INSERT INTO acuNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Tura pengké anturtamkachamtaikia, Yuse aintsri iruntramunam nu aints pachisrum chicharkataram. Tura nuni chicharmaitiat, tuke antukchamtaikia, nuka Yusen umirkachua nunisketai tusaram, tura kuikian kasamnua nunisketai, tu nintimsaram inaisataram. ");
INSERT INTO acuNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Nekasan tajarme: Atumka ju nungkanmaya ainau tunaari tsangkurakrumningkia, nayaimpinmasha ni tunaarisha tsangkuratnuitai. Tura ju nungkanmaya ainau tunaarin tsangkurchakrumningkia, nayaimpinmasha ni tunaarinka tsangkurashtinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","20","“Ataksha tajarme: Aints jimiarchiksha, tura kampatmaksha wína nintimtursar iruntrar pujuinamtaikia, wisha nijai tsaniasan pujustinuitjai. Tura asamtai ju nungkanmasha wína nintimtursaram pujautirmeka, jimiarchiksha metek nintimsaram pujusrum wína Apaachir nayaimpinam puja nu seakrumningkia, atum searme nunaka mash umiktinuitai”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Tama nunia Pedro Jesúsan weri iniak: —Apuru, wína yatsur pasé awajtus pujamtaisha ¿warutmanak tsangkurataj? ¿Sietenkeash tsangkurataj? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Tu iniam Jesús ayaak: —Atsa. Sietik tsangkurata tatsujme, antsu pachitsuk tsangkurata tajame, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Nunia Jesús ataksha nuitamak: “Tura asamtai Yus aints ainaun nayaimpinmaya inawa nuka junia apua tumawaitai. Nu apuka ni inatiri ainaun untsuk: ‘Tumashnum akirkataram’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Tura untsuam, nu nangkamtaik nukap tumashmiaun itaarmiayi. Nuka pengké akiimiakchamniaun tumashmiamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Tura itaaram nu aints ni tumashrin akiimiaktatkama tujinkau asamtai, nu apuka chikich inatiri ainaun chicharak: ‘Tumashrin akiimiakti tusaram, nuwartuk tura uchirtuk, tura warinchurtuk mash surutkataram’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Tama nu aintska apurin nakaj tikishmatar: ‘Apuru, wait aneasam nakarsata. Tumashnumka mash akiktatjame’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Tama nu aintsun wait anentar tumashrin mash tsangkur: ‘Akirtsuksha weta’, tusa inatirin angkan akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Akupamu asa, nu aintska jiinki, aneachmau ni apuri inatirin kichan wainkamiayi. Tura wainak, nu aintska jumchik tumashmiau asamtai, tsekengki suwenam achik chicharak: ‘Tumashmiame nuka yamaik akirkata’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Tama nu aintska tikishmatar: ‘Wait aneasam nakarsata. Tumashnumka mash akiktatjame’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Tamaitiat pachischamiayi, antsu wait anentsuk nu aintsun juki: ‘Tumashnum mash akiimiak jiinkiti’, tusa kársernum engkeamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Turamtai nu apu inatiri chikich ainau nuna wainkar napchau nintimrarmiayi. Tura apurin weriar, nu aintsu turamurin mash ujakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Mash ujakaram, apuka nuna antuk, nu aints utitaram tusa, ni aintsrin akupkamiayi. Tura itaaramtai, nu aintsun chicharak: ‘Netsetme. Wína wait anentrurta turutu asakmin, tumashnum mash akirtsuk asata tusan inaisamjame. ");
INSERT INTO acuNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","¿Wi amin wait anentajme aintsamek chikich amin tumashmiarmausha waruka wait anentsuksha waitkame?’ timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Tura nu aintsun kajerak suntarin untsurak: ‘Juka achikrum tumashrin akiimiakchau asamtai, tuke wait wajakti tusaram awatrataram’, tusa ni aintsrin akatar akupkamiayi”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Nunia inangnamunam chichaak: —Atumnasha tajarme: Nu aintsua nunisrumek atumi yachí ainau tuke napchau nintimtusrum tsangkurtsuk pujakrumningkia, nu apua nunisang wína Apaachir nayaimpinam puja nuka atumnasha tsangkutramrashtinuitrume, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesús nuna tina ukuki Galilea nungkanmaya jiinki, Jordán entsa amajin Judea nungkanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Tura nuni jeamtai, aints untsuri Jesúsan nemarkarmiayi. Turinamtai Jesús jau ainauncha tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Tura fariseo ainau Jesúsan nekapsartas iniinak: —¿Aints ni nuwarin pachitsuk japa ukukminkai? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Tu iniinam Jesús ayaak: —Atsa. ¿Atumka Yuse papiri aarmauringkia aujchaukitrum? Tu aarmawaitai: ‘Nu nangkamtaik Yus aishmangnasha, tura nuwancha najanamiayi’. ");
INSERT INTO acuNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","“Tura nusha aarmawaitai: ‘Tura asamtai aishmang ni aparincha, tura ni nukurincha ukuki, nuwarijai tsaning jimiaraitiat kichkia nunisang atinuitai’. ");
INSERT INTO acuNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tu aarmau asamtai, jimiar ayat kichkia nunisketai. Tura Yus tu tinu asamtai, aints kichkisha nuwarin japashtinuitai, tura nuwasha kichkisha aishrin ukukchatnuitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Tama chicharinak: —Tura Moisés chichaak: Aints papin aar: Nuwarun ukuajai tusa, nuna nuwarin nu papin susa ukuktinuitai ¿waruka nuka timiayi? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Tu tinam Jesús aimiak: —Atumi nintijai timiá katsuram nintimu asakrumin, Moisés nunaka tsangkatramkamiarume. Antsu nu nangkamtaikia nuniska achamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Tura asamtai atumin tajarme: Aints ni nuwarin kichjai pujachu wainiat, niin ajapa ukuki chikich nuwan nuwatkungka, tunau wajastinuitai. Tura aints nuwan ajapamun nuwatkungka, nusha nunisang tunau wajastinuitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Tama ni nuiniatiri ainauti Jesús chicharkur: —Nekas nuwa ajapar ukukchamnawaitmatikia, nuwasha nuwatkachminuitai, —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Tu takurin Jesús airmak: —Nuwan nuwatsuk pujustin pachis chichamnaka aints mash antukminka ainatsui. Antsu Yus nekamtikiamu ainauka ju chichaman antukmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Chikich aints uchin yajutmarchamnausha akiinawaru ainawai. Tura kitcha uchin yajutmarchami tusar kaamtikiamu ainawai. Antsu kitcha Yuse takatrin takakmasartas nuwan tuke nuwatsuk pujuinawai. Ju chichaman antukarmin ainauka antukarti tajarme, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Nunia aints ainau uchi irunun itariar, Jesúsan seainak: —Ame uchi muuken achikiam Yus seatrita, —tusar itariarmiayi. Tinamtai ni nuiniatiri ainauti chicharkur: —¿Waruka apusha waitkarme? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Tu tarin wainiat Jesús chichartamak: —Uchi irunu wini winiarat tusaram tsangkatruktaram. Aints ju uchia nunisarang nintimsar pujuinauka Yuse pujutirin nayaimpinam jeartinuitai. Tura asaramtai suritrukairap, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Tura uchi muuken kichnasha kichnasha achik, Yusen seati umis, nuniangka jiinki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Nunia natsa Jesúsan jiistas jeari chicharak: —Nuikiartinu, nekas pengkeraitme. Tura asakmin iniajme: Pujut nangkankashtinun jukitasnasha ¿warí pengker aa nuna takakmasminuitja? Nu ujatkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Tama Jesús ayaak: —¿Waruka pengkeraitme turutme? Nekas pengker aa nuka kichkitai. Nuka Yusketai. Ameka tuke iwiaaku pujusmi takumka Yus: Wína chichamur umirtuktaram tímia nuka miatrusmek umirkata, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Jesús tama nu natsaka iniak: —¿Tu chichama nekas umiktinuita? —tama Jesús ayaak: —Nu umiktin chichamka nuwaitai: Mangkartuwairap. Tura tsanirmawairap. Tura kasamkairap. Tura aints kichkisha pachisrum tsanurairap. ");
INSERT INTO acuNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Tura aparmesha tura nukurmesha umirkataram. Tura atumi namangke anearme nunisrumek chikich aints ainausha aneetaram, tu aarmawaitai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jesús tama nu natsa chicharak: —Ame tame nunaka uchiwach asanak tuke mash umikuitjai. ¿Nuniasha warina umiktinuitja? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Tu iniam Jesús ayaak: —Nekas pengker ata takumka, ame wariram aa nu mash surukta. Tura kuikian yuuminau susata. Nunia wína nemartusta. Turakum nekasam nayaimpinam yuumatsuk pujustinuitme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Jesús tama nu natsaka nuna antuk, nekas kuikiartin asa, kuikiarin aneak wake mesek nunia jiinki wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Tura ukukim Jesús ni nuiniatiri ainautin chichartamak: —Nekasan tajarme: Kuikiartin ainau Yus pujamunam wayaawartatkamawar nekasar tujinkartinuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ataksha tajarme: ¿Kamiyusha juun asa, akusha jiin wayaamnaukai? Atsa, nuka pengké yumtinuitai. Tura kuikiartinka Yus pujamunam wayaatnuka timiá yumtinuitai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tu turamin asamtai ni nuiniatiri ainauti nu antukar nukap nintimrar chicharkur: —Tu amataisha ¿yaachik nuniasha uwemramnawaita? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Tu iniam Jesús mash jiimias chichartamak: —Aints ningki nintimsangka uwemrachminuitai. Antsu Yuska pengké tujinkachu asa, aints ainaun uwemtikratnuitai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Turammatai Pedro chicharak: —Apuru, iinu amia nuka mash ukukir, ame nemarkamiaji. ¿Iincha waring arutramtaij? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Tu iniam Jesús ayaak: —Nekasan tajame: Ukunam ju nungka aa nuka mash yamaram najanatin awai. Nuniangka wikia aints ayatun, Yus akupkamu asan, mash aints ainaun inartinuitjai. Tura wikia juun apu keemtairin keemsamtai, atumsha wína nemartuku asaram, Israela uchiri doce (12) amia nuna weari ainau inartasrum, atumsha nunisrumek apu keemtairin doce (12) atinua nuni keemsatnuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tura aints ainau wína anentu asar, ni jeencha ukukiar, tura yachiincha, tura umajincha, tura aparincha, tura nukurincha, tura uchirincha, tura nungkarincha ukukin asar, ni ukukiarmia nuna nangkamasarang untsuri wainkartin ainawai, tura ukunmasha pujut nangkankashtinun jukiartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Aints untsuri ningki nintimsar: Wikia chikich ainaun nangkamasketjai tinu ainau nu kinta jeamtai mianchau artinuitai. Tura yamai mianchau ainauka ukunam chikich ainaun nangkamasarang artinuitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Nunia Jesús ataksha nuitamak: “Yus aints ainaun nayaimpinmaya inawa nuka ajartinua tumawaitai. Uva yurangke tsamaramtai, ajartin uva yurangken juuktas, aints ainaun ipiaatas kashik jiinkimiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Tura jiinki aints ainaun wainak: ‘Ju kinta wína ajarun takakmastaram tusan, kichik kuik denario tutain akiktatjarme’, tama niisha ‘ayu’ tusar ajanam takakmasartas wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Tura nuni wearamtai, tsaa yakí wajasai, ataksha jiinki yaktanam weak, jea aarin nangkamiar wajainaun wainak chicharak: ");
INSERT INTO acuNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","‘Atumsha wína ajarun werum, uva yurangke juwaakrum yainkataram. Turakrumningkia atumi takatrin metek akiktatjarme’, tama nusha nunisarang ‘ayu’, tusar takakmasartas wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wearamtai tsaa tupin wajasamtai, nunia tsaa yantantiamtai, ajartin ataksha jiinki aints ainaun: ‘Atumsha takakmastaram’, tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Nunia tsaa nungka wajasai, ataksha ajanmaya jiinki yaktanam we, nuni aints nangkamiar wajainaun wainak: ‘¿Waruka pengké takakmatskesha wajarme?’ tu iniasmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Tu iniam aiminak: ‘Maj, aints kichkisha ipiatminachu asaramtai takakmatsji’, tinamtai ajartin chicharak: ‘Atumsha wína ajarun werum takatur yainkataram. Turakrumningkia atumi takatrincha metek akiktatjarme’, tama nusha nunisarang ajanam wearmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Kintamramtai ajartin ajan wainiun untsuk: ‘Ajan takau ainau untsukam akikiarta. Tsaa nungká wajasai nangkamawaru ainau nuwá eemkam akikiarta, tura kashik nangkamawaru ainauka inangnamunam akikiarta’, tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Tama ajan takau ainaun untsuk, angkuanmatai nangkamawaru ainaun nuná eemak kichik kichik kuikian denario tutain akikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Nuniasha takatan kashik nangkamawaru ainau: Iiyá takatka nangkamau asakrin, ¿iincha nukap akirmakchatjiash? tu nintiminau wainiat, chikich ainaun akikmia nunisang nu aints ainauncha kichik kuikianak akikmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Tura nunak jukiaru asar, napchau nintimrar ajartinun jiisartas weriarmiayi, tura jeariar ajartinun jiyainak: ");
INSERT INTO acuNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘¿Waruka aitkame? Uku takakmasaru ainau aya kichik uranak takakmasaru wainiatmesha ¿warukaya meteksha akikratkame? Antsu iikia kintajai metek tsaa sukutmau wainiatur takakmakur wait wajakmaji’, tu jiyakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Tinamtai ajartin nu aintsun chicharak: ‘Sairua, wikia aminka pengké kasartsujme. Kichik denario akiktatjame, wi tama ¿ameka ayu tichamkum? ");
INSERT INTO acuNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Pai, kuikiaram jukim weta. Tura wi ukunam takakmasaru ainaun amijai metek akiktasan wakerajai. ");
INSERT INTO acuNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Wina kuikiar asamtai, wi wakeramurun turamnawaitjai. Wikia pengker asan, chikich ainaun wait anentrai wainiatmesha ¿waruka winasha suwirpiaku jiirsamsha napchau nintimtursamsha pujame?’ timiayi”, Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesús nu nuikiartamun iin nuitamak: “Yuse aintsri ainausha aja takakminua nunisarang ainawai. Eemkar Yusen nemarkaru ainau ukunam nayaimpinam jeartinuitai. Tura ukunam Yusen nemarkaru ainau nuwá eemkar nayaimpinam jeartinuitai”, taku turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesús Jerusalénnum jinta wekaak, ni nuiniatiri ainautin akantamak chichartamak: ");
INSERT INTO acuNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Anturtuktaram. Jerusalénnum weaji. Tura Yus akupkamutiatnak aints asan, sacerdote juuntri ainamunam tura Moisésa chichame nuikiartin ainamunam wína surutkar: Maataram turutiartatui. ");
INSERT INTO acuNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tura romano ainau wína wishikrurar, nunia katsumrukar numi winangmanum maawarti tusar surutkartatui. Tura mantuwaramtai kampatam kinta jakan tepayatun ataksha nantaktatjai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Nunia Zebedeo uchiri Santiago, nunia Juansha ni nukurijai Jesúsnum jear, ni nukuri Jesúsan seatas tikishmatramiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Turamtai Jesús iniak: —¿Warí itiurtukat tusamea wakerutame? —timiayi. Tu iniam ni ayaak: —Wi wakeramurka nuwaitai: Ami pujutrumin Apu pujakminkia wína uchir kichka ami untsurumnini pujus, kitcha menarminini pujus, mai apu arti tusan seajme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Tamaitiat Jesús Santiagon, tura Juannasha chicharak: —Atumka wína seatrume nuka warimpita tusaram nekatsrume. ¿Wi wait wajaktatja nunisrumeash atumsha wait wajaktaram? —tu iniam: —Ja ai, turunamnawaitji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Tu aimkaramtai, Jesús chicharak: —Nekasrum tarume. Wi wait wajaktatja nunisrumek atumsha wait wajaktinuitrume. Antsu wína untsuruninisha, tura wína menarninisha atum keemsatnunka tsangkatkashtinuitjarme. Antsu wína Apaachir nuni keemsartinun tsangkatkamu ainauk keemsartin ainawai, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Jesús tama chikich diez (10) nuiniatiri ainauti nu antukar, Santiagosha tura Juansha kajerkamiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Tura kajerakrin Jesús ni nuiniatiri ainautin mash untsurmak, irutmar chichartamak: —Atumka nekarme: Mash nungkanmaya apu ainau ni aintsrin akatrar pe akupinawai. Tura ni juuntri ainausha miajuitjai tusar, ni aintsri ainauncha tuke inarartas wakerinawai. ");
INSERT INTO acuNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Antsu atumka nuka turashtinuitrume. Tura chikich ainau nangkakatasrum wakerakrumka, chikich aintsu inatiria nunisrumek atinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tura apu wajastasrum wakerakrumka, chikich ainau umirin atinuitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Wikia Yus akupkamutiatnak aints asan, aints ainau wina yainkarat tusanka tachamiajai, antsu aints ainaun yaingtaj tusan taawitjai. Tura aintsun untsuri angkanmamtikiawartasan mantuwarti tusan taawitjai, —Jesús turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesús Jericó yaktanmaya jiinmatai, aints untsuri niin nemarkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Nuni wekaamunam aints wainmichu jimiar jinta yantamen keemsar, Jesús winawai tamaun antukar untsuminak: —Apurua, Davidta weariya, iincha wait anengkratkata, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Tu untsuminamtai aints irunu niin jiyainak: Itatkataram tinamaitiat nuna nangkamasarang kakar untsuminak: —Apurua, Davidta weariya, iincha wait anengkratkata, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Miatrusar untsumkaramtai, Jesús nuni wajas, wainmichun mai winiarti tusa untsukmiayi. Tura iniak: —¿Itiurtukat tusarmea wakerutarme? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Tamati aiminak: —Apuru, wainmachkur wainmaktasar wakeraji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Tinamtai Jesús wait anentar ni jiin antinkamiayi. Turam mai paan wainmakarmiayi. Tura Jesúsan nemarkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Jesús ni nuiniatiri ainautijai Jerusalénnum weakur Betfagé yaktanam jeamiaji. Nu yaktaka Olivo Muranam yaatkauyayi. Tura nuni jear, Jesús ni nuiniatiri jimiaran akupak: ");
INSERT INTO acuNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","—Atunini yaktachinam werum, nuni jearam burro juun jingkiamu, tura uchiri yama tsakamach wainkatatrume. Nu wainkaram atiaram mai itataram. ");
INSERT INTO acuNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu turakrumin aints kichkisha ininminak: ‘¿Warukaya atiarme?’ turaminamtaikia: ‘Ii Apuri yuumau asamtai juwaji. Tura wári wainkitatui’, titaram, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Yuse chichame etserin yaanchuik Jesúsan pachis tímia nunaka miatrusnak umiktaj tusa, nunaka timiayi. Ni timiauri tu aarmawaitai: ");
INSERT INTO acuNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Sión yaktanmaya ainau antukarat tusaram titaram: Jiistaram. Atumi Apuri wikia miajuitjai tumamtsuk, burrochinam keemas winitramui. Nuka apua nuniska winitramtsui, antsu burro uchiri warinchu jutainum keemas winitramui”, tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Tura akupkamu asar ni nuiniatiri wear, Jesús tímia nunisarang turuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Tura yaktanam wear burron wainkar, uchirtuk mai jukiar Jesúsnum itaar, ni wejmakrin aimiakar burronam awantsarmiayi. Turuwaramtai Jesús keemsamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Tura jinta weamtai, aints untsuri jintanam wajainau: Ii Apurinme tiartas, ni wejmakrin aimiakar, jinta japen burro wetinnum aitkarmiayi. Chikich ainausha chapi nukea tumaun charukar jintanam aitkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Tura eemkar wearmia nusha tura uku winiarmia nusha warainak Jesúsan pachisar untsumiarmiayi. Tura untsuminak: —Ii juuntri Davidta weari nekas juuntaitai. Yus akupkamu winá nuka nekas pengkeraitai. Yus nayaimpinam puja nuka nekas juuntaitai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Tura Jesús Jerusalénnum jeamtai, aints mash taetet wajainak inintrinak: —¿Ausha yaachita? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Tu inintrinamtai chikich aints aiminak: —Auka Yuse chichame etserin Jesúsaitai. Nazaret yaktanmayaintai. Tura Galilea nungkanmayaintai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús Yus seatai juun jeanam waya, aints ainau nuni surinak tura suminak wajainaun aanum jiiki akupkamiayi. Tura kuikian yapajinau misarin ayanturmiayi. Tura kayuk suwen surinaun tutangkrincha ayanturmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Tura chicharak: —Yuse chichame tu aarmawaitai. Yus chichaak: ‘Wína jearka Yus seatai jeaitai’, tu aarmau wainiatrum atumka kasa aints juni kuikian kasamkarat tusaram tsangkatkarume, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Nuna tura inais nuni wajai, wainmichu ainau tura wekaichau ainausha wayaawaramtai, Jesús mash tsuwarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Turamtai sacerdote juuntri ainausha, tura Moisésa chichame nuikiartin ainausha Jesús wainchati takatan turaun wainkar, tura uchi ainau Yuse jeen wayaawaru asar: Juun apu Davidta weari nekas juuntaitai tu untsuminamtai Jesúsan kajerkarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Tura iniinak: —¿Ju uchi tina nu antamek? —tiarmiayi. Tu tinam Jesús ayaak: —Ja ai, antajai. ¿Atumka Yuse chichame juna pachis aarmawa nuka aujchaukitrum? Tu aarmawaitai. David Yusen chicharak: ‘Uchi ainau tura kuwirach ainausha amin nekasar pengker awajtamsartas maaketai turamiarti tusam tsangkatu weame’, timiayi. Tu aarmawaitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nuna tusa ukuki, Jerusalénnumia jiinki, Betania yaktanam we nuni kanurmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Kashin tsawaar, Jesús Jerusalénnum wetaj tusa jinta weak yaparmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Tura numi higuera tutain jinta yantamen wajaun wainak, neren akarmaktaj tusa werimiayi. Turamaitiat nukak nukak nerenchaun wainkamiayi. Tura numin chicharak: —Ameka tuke nerechu atatme, —timiayi. Tu tinu asamtai nu tamaujai metek numikia kukarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Turamtai ni nuiniatiri ainauti nu wainkar Jesús chicharkur: —¿Warukaya kakarmachusha kukari? —timiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Tu iniam Jesús chichartamak: —Nekasan tajarme: Yus nekasrum nintimtakrumka tura: Nekasash turat, tu nintimtsuk pujakrumka, higueran aitkaja aintsarmek atumsha ainkamnawaitrume. Tura ju murasha chicharkuram: ‘Juni wajatsuk juun entsanam ayangta’, takurmeka nusha turamnawaitrume. ");
INSERT INTO acuNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Tura Yus nekas turuatatuapi, tu nintimsaram seakrumningkia, nunaka mash turuatnuitai, —turammiaji. ");
INSERT INTO acuNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Nunia Yus seatai juun jeanam waya, Jesús aints ainaun nuiniak pujamtai, sacerdote juuntri ainau, tura judío juuntri ainausha Jesúsan tariar chicharinak: —¿Ame aitkame jusha yana chichamejiya aitkame? ¿Tura yaachia aitkata tusasha amincha akuptamkama? —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Tu iniinam Jesús aimiak: —Wisha atumnasha kichan iniastajrume. Nu aimkakrumningkia, yaki winasha akuptukma tusan nunasha ujaktatjarme. ");
INSERT INTO acuNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Watska ¿yáki Juankun aints imaita tusasha akupkaya? ¿Yuseash akupkaya? ¿Turachkusha aintsuash akupkaya? —tu iniam mai nuwamtak chicharnainak: —¿Iisha warintajik? Yus akupkamuitai takurningkia ¿waruka ni nekasampita tichamiarume? iincha turami tusar tichamnawaitji. ");
INSERT INTO acuNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Antsu aints akupkamuitai takurningkia, aints mash: Juan Yus akupkamuitai tinau asar, iin kajertamkarai tusar shamaji, —tunaiyarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Tura Jesúsan aiinak: —¿Juan aints ainau imaita tusasha yáki akupkaya? tusarsha iikia nekatsji, —tiarmiayi. Tinamtai Jesús aimiak: —Ayu, tu tau asakrumin, yáki wina akuptukia tusancha, wisha nunisnak atumnasha ujakchatatjarme, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Tura Jesús ataksha chicharak: —Ju nuikiartutai chicham nintimrataram. Aintsu uchiri jimiar pujú armiayi. Tura asaramtai nu aintska uchirin kichkin chicharak: ‘Uchiru, ajarun weme uva yurangke juuta’, tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Tu akupam uchiri ayaak: ‘Atsa, nakimiajai’, tayat atak nintimiar ajanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Turamtai chikich uchirin nunasha nunisang: ‘Amesha ajarun weme uva yurangke juuta’, tamati nuka: ‘Ayu apaachi, wetajai’, tayat wechamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Nu uchi jimiaran pachisan taja nuna ¿tua ni apari wakeramurin umirkamia? —tu iniam aiminak: —Eemak nakimiajai tayat, nunia wemia nuwaitai, —tiarmiayi. Tinamtai Jesús chicharak: —Nekasan tajarme: Kuikian juu ainau, tura kungkatip ainausha ni tunaarin mash inaisar, atumin nangkamasarang Yuse pujutirin wayaawartin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Imiakratin Juan chichaak: ‘Pujutrum tu yapajiaram uwemratnuitrume’, tusa atumin nuitamratas winitramu wainiatrum nekasampita tichamiarume. Antsu kuikian juu ainau tura kungkatip ainausha Juanku chichamen antukar nekasampita tiarmiayi. Atumka nuka nekayatrumek, ni umirkatasrumka atumi tunaaringkia inaisachmiarume, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Nunia Jesús ataksha aints ainaun nuiniak: “Chikich nuikiartamu antuktaram: Aints uva naekrin ni ajarin araamiayi. Tura ajanka wenurmiayi. Tura uva yumiri juutai nu ajanmak najanamiayi. Tura ajan wainkatnun wenurmaunum yakí wajatirin najatamiayi. Tura mash pengker iwiar, aints ainaun eak: ‘Ajar waitruktaram’, tusa ukuki, chikich nungkanam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Tura juuktin kinta jeamtai, ni inatiri ainaun akatar akuptak: ‘Yamaikia werum, ajarun takau ainau uva yumiri winar aa nunaka akupturkarti’, tawai tita tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Akuptukmaitiat ajan takau ainau ajartinu inatiri ainaun achikiar, kichnaka katsumkar, tura kichnasha maawar, tura kichnasha kayajai tukuarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Turinamtai ajartin ataksha ni inatirin nuna nangkamasang untsurin akuptukmiayi. Akuptukmaitiat nu ajan takau ainau nunisarang turuawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Nuna turuawaramtai nuniangka: ‘Wína uchirnaka nekasar anturkarchanpiash’, tu nintimias ni uchirin akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Apari akupkamu waininayat, ajan takau ainau ajartinu uchirin wainkar chicharnainak: ‘Auka ajartinu uchirintai. Apari jakamtai, ju ajaka ninu atatui. Watska maatai. Au maarkia ajaka iinu achaintak’, tunaiyarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Tura ajartinu uchirin achikiar ajanmaya jiikiar maawarmiayi”, Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tura nu nuikiartamun antukaru ainaun iniak: —¿Atumsha itiur nintimrume? ¿Ajartin taa, nu ajan takau ainaun itiurkatnuita? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Tu iniam aiminak: —Nu aints timiá pasé asaramtai, wait anentsuk maawartinuitai. Nunia nu ajartin chikich ajan takau ainaun eak: ‘Ajar waitruktaram. Tura juuktin kinta jeamtai, winar aa nuka surustaram’, tusa ajarin takakmasarti tusa akupkatnuitai, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tinamtai Jesús chicharak: —Nekasrum tarume. ¿Nu pasé aints ainau pachisrum atumka Yuse papirin aujchaukitrum? Tu aarmawaitai: ‘Jeamin ainau kaya jean jeamkar, chikich kayan wainkar chichainak: Ju kayaka paseetai tusar japawarmiayi. Japinau wainiat Yuska: Nu kayaka timiá pengkeraitai timiayi. Apu Yus nunaka wakeruku asamtai, iisha nu nintimsar pujaji’. Tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Tura asamtai tajarme: Yusnum tuke pujustinka atumin suritramak, chikich nungkanmaya ainau tuke Yusnum pujustinka tsangkamkamuitai. ");
INSERT INTO acuNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Aints ainau nu kaya nekas pengker aa nunaka tukumkar kupinakartinuitai. Tura nu kaya aintsnum ayaarkungka, nu aintsun tsairtinuitai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tama sacerdote juuntri ainau, tura fariseo ainausha Jesús nuikiartamun antukar: Iin pachitmas turamji tusar nintimrarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Tura yamaik achiktai tinayat, chikich aints ainau Jesúsan pachisar: Yus akupkamu asa, nu chichamnaka etserui tinau asaramtai, shamkar inaisarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Nunia Jesús ataksha nuikiartutai chichamjai etsertan nangkamamiayi. Tura chichaak: ");
INSERT INTO acuNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—Yus aints ainaun inawa nuka junia apua nunisketai. Apu uchiri nuwan nuwatkatin asamtai, fiestan najanamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Tura ni inatiri irunun aints ainau untsukarti tusa akupkamiayi. Untsuamaitiat nakiararmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ataksha chikich inatiri ainaun akatar akupak: Ataksha werum untsukmau ainau ujatruktaram: Waaka ainausha mau asar, tura tangku jaerusha mau asar, atum yuwatin yanchuk mash umismawaitai. Tura asamtai nuwenmaunum winiarti, tawai titaram timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Tamaitiat untsukmau ainau nakiararmiayi. Antsu chikich ni ajarin jiistas wemiayi. Tura kitcha sumatinam wemiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Tura chikich ainauka apu inatiri ainaun achikiar pasé awajsarmiayi, tura kichnasha maawarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Turinamtai apu nuna antuk kajek, ni suntari ainaun chicharak: ‘Wina aintsrun mau irunu mash maataram. Tura ni jeesha mash keematkataram’, tusa akupkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ni suntari ainaun akupkam jiinkiaramtai, nunia ni inatiri ainaun ataksha chicharak: ‘Nuwenmau fiesta mash umismawaitai. Antsu nuwik untsukmau ainauka pasé aints asar winicharmin ainawai. ");
INSERT INTO acuNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Tura asaramtai yakta jinti ainamunam werum, aints atum wainmauka: Nuwenmaunum winiarti tusaram untsuktaram’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Tama ni inatiri ainau jiinkiar, yakta jintin wekajinaun pasé ainauncha tura pengker ainauncha mash untsukarmiayi. Tura asar apu jeen piakarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Jea piakaramtai nu apuka untsukmau ainaun jiistaj tusa wayaamiayi. Nuni waya jiis, aints nuwenkur entsatinka entsatsuk pujaun wainkamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Tura nu aintsun chicharak: ‘Sairua ¿waruka nuwenkur entsati entsatskesha junisha wayaame?’ timiayi. Tamaitiat nu aintska aimtsuke pujumiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Turamtai apu yurumkan surin ainaun untsuk: ‘Juka achikrum, nawencha tura uwejencha jingkiaram aanum jiikrum, tee amanum japataram. Nuni juutak, tura nain katertak nintimratatui’, timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Nu nuikiartutai chichaman wi taja nuka: ¿Warina takua tawa? tusaram yamaikia nekaataram. Aints untsuri nayaimpinam wayaawarti tusa Yus untsukmau ainayat jumchik wayaawartin ainawai, —Jesús timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Tama fariseo ainau nuna antukar, nunia jiinkiar kanakar pujusar, chichaman najatawar: Aints ainau Jesúsa chichamen antukar: Nunaka timiayi tusar tsanumrarmi, tu nintimtiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Tura ni aintsri ainausha tura apu Herodesa nemarin ainausha Jesús iniam, ¿nisha warintintak? tusar, ni chichamen anturkar, nuna jukiarat tusar akupkarmiayi. Tura akupkamu asar, Jesúsan jeariar chicharinak: —Nuikiartinu, ameka nekas chicham chichaame. Iikia nuka nekaji. Chikich ainauka antutsuk, ameka nekasam Yuse jinti tu awai tusam tupin nuikiartame. Tura aints ainau wína pengker nintimtursarat tusamka ameka pachiatsme. ");
INSERT INTO acuNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Tura asakmin itiur nintime tusar, nekaatasar taji. ¿Apu César ni aintsrin akupak: Kuik irumrataram tamati, ii kuikiari akiimiaktin pengkerkai? ¿Antsu akiimiatsuk pujustinka timiá pengkerkai? Nu nekaatasar wakeraji, —tiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Tu iniinam Jesús ni pasé nintimaurincha nekau asa chicharak: —Anangkartin ainautiram ¿waruka winasha anangkruaram nekaprustasrumsha wakerarme? ");
INSERT INTO acuNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Watska, apu César akiktin kuik itataram, —timiayi. Tama nu kuikian itaarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Itaaramtai nuna jiis, Jesús iniak: —¿Jusha yana yapiya nakumkamuita? Tura ¿yana naariya aarmawaita? —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Tu iniam aiminak: —Apu Césarnawaitai, —tiarmiayi. Tinamtai Jesús chicharak: —Tu tinu asaram, juun apu Césarnau aa nuka ni susataram. Tura Yusnau aa nuka Yus susataram, —timiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tama nuna antukar nukap nintimrarmiayi. Tura Jesúsan ukukiar waketkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Nu kintati saduceo ainau: Aints jakamunmaya nantakchatnuitai, tinu ainauka Jesúsan tariarmiayi. Tura Jesús warintintak tusar chicharinak: ");
INSERT INTO acuNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Nuikiartinu, Moisés chichaman aarmia nu chichamka nuwaitai: ‘Aints uchin yajutmatsuk jakamtaikia, yachí uchin yajutmartas wajerin nuwatkati. Tura uchin yajutmarka nuka ni yachí jakau uchiriya nunisang atinuitai’, tu aarmawaitai. ");
INSERT INTO acuNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ayu, juni iijai iruntrar siete (7) yachintin pujú armiayi. Tura eemkauri nuwan nuwatak, uchin yajutmatsuk jakamtai, chikich yachiisha wajerin nuwatkayat, ");
INSERT INTO acuNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","nusha nunisang uchin yajutmatsuk jakamiayi. Tura nusha nunisang jakamtai, chikich yachí wajerin nuwatkayat, nusha nunisang uchin yajutmatsuk jakamiayi. Tura kitcha kitcha siete (7) yachintin nu nuwan nuwatinayat, mash uchin yajutmatsuk kajingkiarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Nunia nuwasha ukunam jakamiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Tura nu siete (7) yachintin mash nu nuwan nuwatkaru asar ¿jakamunmaya nantakiar nu nuwaka yana nuwariya atinuita? —tu iniasarmiayi. ");
INSERT INTO acuNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Tu iniinam Jesús ayaak: —Yuse chichame nekachu asaram, tura Yuse kakarmarisha wainkachu asaram, jakamunmaya nantaktin atsawai takuram pe nuwaarme. ");
INSERT INTO acuNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Nintimrataram. Jakamunmaya nantak