﻿USE sofia;
DROP TABLE IF EXISTS sofia.acrTNT_vpl;
CREATE TABLE acrTNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acrTNT_vpl WRITE;
INSERT INTO acrTNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri Kanimajawal Jesucristo e ralcꞌoꞌal can ri David y ralcꞌoꞌal can ri Abraham. E ri quipetebem lo che ri Abraham e tak waꞌ: ");
INSERT INTO acrTNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri ralcꞌoꞌal ri Abraham, Isaac rubiꞌ; ri ralcꞌoꞌal ri Isaac, Jacob rubiꞌ; tak ri ralcꞌoꞌal ri Jacob, e ri Judá cucꞌ ri ratz-uchakꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Tak ri ralcꞌoꞌal ri Judá, e ri Fares y ri Zara yey rubiꞌ ri quichu e Tamar; ri ralcꞌoꞌal ri Fares, Esrom rubiꞌ; ri ralcꞌoꞌal ri Esrom, Aram rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri ralcꞌoꞌal ri Aram, Aminadab rubiꞌ; ri ralcꞌoꞌal ri Aminadab, Naasón rubiꞌ; ri ralcꞌoꞌal ri Naasón, Salmón rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri ralcꞌoꞌal ri Salmón, Booz rubiꞌ yey ruchu ri Booz e Rahab. Ri ralcꞌoꞌal ri Booz, Obed rubiꞌ yey rubiꞌ ruchu ri Obed e Rut. Ri ralcꞌoꞌal ri Obed, Isaí rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri ralcꞌoꞌal ri Isaí, e ri rey David y ri ralcꞌoꞌal ri David, Salomón rubiꞌ yey ruchu ri Salomón e ri rixokil ri Urías. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri ralcꞌoꞌal ri Salomón, Roboam rubiꞌ; ri ralcꞌoꞌal ri Roboam, Abías rubiꞌ; ri ralcꞌoꞌal ri Abías, Asa rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri ralcꞌoꞌal ri Asa, Josafat rubiꞌ; ri ralcꞌoꞌal ri Josafat, Joram rubiꞌ; ri ralcꞌoꞌal ri Joram, Uzías rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri ralcꞌoꞌal ri Uzías, Jotam rubiꞌ; ri ralcꞌoꞌal ri Jotam, Acaz rubiꞌ; ri ralcꞌoꞌal ri Acaz, Ezequías rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri ralcꞌoꞌal ri Ezequías, Manasés rubiꞌ; ri ralcꞌoꞌal ri Manasés, Amón rubiꞌ; ri ralcꞌoꞌal ri Amón, Josías rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Tak ri ralcꞌoꞌal ri Josías, e ri Jeconías cucꞌ ri ratz-uchakꞌ; rique xebalax chupa tak ri kꞌij echiriꞌ raj Israel xecꞌam bi Babilonia. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Echiriꞌ ecꞌamom chubi Babilonia, xalax jun ralcꞌoꞌal ri Jeconías, Salatiel rubiꞌ; ri ralcꞌoꞌal ri Salatiel, Zorobabel rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri ralcꞌoꞌal ri Zorobabel, Abiud rubiꞌ; ri ralcꞌoꞌal ri Abiud, Eliaquim rubiꞌ; ri ralcꞌoꞌal ri Eliaquim, Azor rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri ralcꞌoꞌal ri Azor, Sadoc rubiꞌ; ri ralcꞌoꞌal ri Sadoc, Aquim rubiꞌ; ri ralcꞌoꞌal ri Aquim, Eliud rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri ralcꞌoꞌal ri Eliud, Eleazar rubiꞌ; ri ralcꞌoꞌal ri Eleazar, Matán rubiꞌ; ri ralcꞌoꞌal ri Matán, Jacob rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri ralcꞌoꞌal ri Jacob e ri José, ri rachijil ri María, ruchu ri Jesús. Yey ri Jesús e ri cabiꞌx “Cristo” che. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jecꞌulaꞌ chi conoje ri ticawex ujekebem lo chwi ri Abraham cꞌa chwach ri David, xebicꞌow cajlajuj lemaꞌj; chwi lo ri David cꞌa chwach echiriꞌ xecꞌam bi raj Israel pa ri tinamit Babilonia, xebicꞌow cajlajuj lemaꞌj; yey chwi lo echiriꞌ xecꞌam bi raj Israel pa ri tinamit Babilonia cꞌa chwach ri ralaxibal ri Cristo, xebicꞌow cajlajuj lemaꞌj. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jewaꞌ xuꞌan ri ralaxibal ri Kanimajawal Jesucristo: Ri María, ruchu ri Jesús, unimam chic cacꞌuliꞌ rucꞌ ri José. Ecꞌuchiriꞌ cꞌamajaꞌ caquijunimaj quib, ri María xcanaj yewaꞌ ixok ruma ruchukꞌab ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri José, ri rachijil ri María, ruma lic jusucꞌ rubinic y ruma na caraj taj cuya uqꞌuix ri María chiquiwach ri winak, xraj cꞌut cuya canok e laꞌ na jinta cꞌo quenaꞌben re. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ecꞌuchiriꞌ cuchꞌob rakan puwi waꞌ, xakicꞌateꞌt jun ángel re ri Dios xucꞌut rib pa uwachicꞌ y xubiꞌij che: «José, at ralcꞌoꞌal can ri David, maxiꞌij awib che cacꞌam ri María re cuꞌan awixokil, ma rumatzem rire, ucꞌulum ruma ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Calax cꞌu jun ralab y Jesús rubiꞌ cacojo, ma Rire quebucolobej rutinamit che ri quimac» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronoje waꞌ xuꞌano chaꞌ e cuꞌana janipa ri cubiꞌij Ruchꞌaꞌtem ri Dios echiriꞌ ri kꞌalajisanel re ri Dios xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Chitanapeꞌ: Jun chomilaj kꞌapoj ali cacanaj yewaꞌ ixok y calax jun ralab. Ecꞌu rubiꞌ cabiꞌxic: Emanuel xchaꞌ. Waꞌ queꞌelawi “Dios xoꞌljekel kucꞌ”. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ecꞌuchiriꞌ xcꞌun sak chwach ri José, e xuꞌan ri xtak che ruma ri ángel re ri Dios; xucꞌam cꞌu ri María re rixokil. ");
INSERT INTO acrTNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero xuchajij na ruchomal ri María ma na xcꞌojiꞌ ta rucꞌ cꞌa echiriꞌ xalax na ri ralco ralab. Y Jesús rubiꞌ xucojo. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalax chilaꞌ Belén re Judea echiriꞌ e rey ri Herodes. Xebopon cꞌu Jerusalem jujun achijab e petinak pa relebal lo ri kꞌij. Rique lic cꞌo quinaꞌoj puwi tak ri chꞌumil. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jecꞌuwaꞌ caquibiꞌij: —¿Pa cꞌo wi ri rey que raj judiꞌab alaxinak? Ma riꞌoj xkil ruchꞌumil cꞌa pa relebal lo ri kꞌij; yey e waꞌ oj petinak chaꞌ coꞌlkalokꞌnimaj ukꞌij —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Echiriꞌ xuta waꞌ ri rey Herodes, lic xsach unaꞌoj che y jelaꞌ xquicꞌulumaj conoje ri winak e aj Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xumol cꞌu quichiꞌ conoje ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab y xutzꞌonoj cꞌu chique pa calax wi ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rique xquibiꞌij che: —Ri Cristo calax pa raldea Belén re Judea, ma jewaꞌ utzꞌibam can ri kꞌalajisanel chupa Ruchꞌaꞌtem ri Dios: ");
INSERT INTO acrTNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Riꞌat Belén at cꞌo pa ri luwar re Judea, tob lic at chꞌutiꞌn, riꞌat lic cꞌo awach chiquiwach raj wach e cꞌo Judea, ma awucꞌ riꞌat cape wi ri Jun Takanel; ecꞌu Rire cuꞌana chajinel que ri nutinamit Israel —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ri Herodes ruma ri xuto, xa xeꞌlakꞌay xebusiqꞌuij rachijab e aj naꞌoj puwi tak ri chꞌumil y xutzꞌonoj cꞌu chique jampa xwinakir waꞌ wa chꞌumil. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tecꞌuchiriꞌ, xebutak bi Belén, jewaꞌ xubiꞌij chique: —Oj alak y lic tzucuj alak chi utz ri ralco acꞌa. We xrik cꞌu alak, coꞌlbiꞌij alak chwe pa cꞌo wi chaꞌ jelaꞌ quinꞌec riꞌin y quiꞌnlokꞌnimaj ukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tecꞌuchiriꞌ rachijab e aj naꞌoj xquita ri xubiꞌij ri rey, xquimaj chubi ri quibe. Ecꞌu ri chꞌumil quilom lo cꞌa pa relebal lo ri kꞌij, nabe bi chiquiwach y xtaqꞌuiꞌ cꞌu chwi ri luwar pa cꞌo wi ri ralco acꞌa. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rique echiriꞌ xquil ri chꞌumil, lic xequiꞌcot che. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ecꞌuchiriꞌ xeboc pa ri ja, xquil ri ralco acꞌa rucꞌ ruchu María. Xexuquiꞌic y xquilokꞌnimaj ukꞌij. Xquijak cꞌu uchiꞌ ri quicaxa y xquiya tak sipanic che, waꞌ re oro, re incienso y re mirra lic quiꞌ ruxlab. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chakꞌab cꞌu riꞌ, xkꞌalajisax chique pa wachicꞌ na quetzelej ta chi pa cꞌo wi ri Herodes. Ruma cꞌu riꞌ, xetzelej pa quitinamit pa jun chic be. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Echiriꞌ rachijab e aj naꞌoj ebelinak chubi rucꞌ ri Jesús, xucꞌut rib jun ángel re ri Dios pa uwachicꞌ ri José y xubiꞌij che: «Chatyactajok, chebacꞌama bi racꞌa y ruchu. Chixanimaj bi cꞌa Egipto y chixcanaja chilaꞌ cꞌate cambiꞌij chiwe jampa quixpetic, ma ri Herodes cutak utzucuxic racꞌa chaꞌ cacamisaxic» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Xyactaj cꞌu bi ri José chakꞌab, xebucꞌam bi racꞌa y ruchu, y xebec Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chilaꞌ cꞌut xecꞌojiꞌ wi cꞌa che rucamic ri Herodes. Xuꞌan cꞌu waꞌ chaꞌ e cuꞌana rubiꞌim lo ri Dios ruma ri kꞌalajisanel echiriꞌ jewaꞌ xubiꞌij: «Cꞌa chilaꞌ Egipto xinsiqꞌuij wi lo ri Nucꞌajol» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ri Herodes, echiriꞌ xretaꞌmaj xsocosoꞌx can cuma rachijab e aj naꞌoj, lic xpe royowal. Ruma cꞌu riꞌ, xutak quicamisaxic conoje ri raltak co chꞌutiꞌk alabo cꞌamajaꞌ caquiqꞌuis queb junab, chique ri e cꞌo Belén y pa tak ri luwar e cꞌo lo chunakaj. Ecꞌu xucꞌam re riꞌ ri xquibiꞌij ri e aj naꞌoj puwi rukꞌijol echiriꞌ xwinakir ri chꞌumil. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jecꞌulaꞌ e xuꞌana ri tzꞌibital can ruma ri kꞌalajisanel Jeremías echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xtataj jun kulaj pa Ramá, okꞌej y sicꞌ rucꞌ bis. E ri Raquel querokꞌej ri ralcꞌoꞌal y na caraj tane cabochiꞌix ucꞌuꞌx ruma ri quicamic ri ralcꞌoꞌal xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tecꞌuchiriꞌ caminak chi ri Herodes, jun ángel re ri Dios xucꞌut rib pa uwachicꞌ ri José chilaꞌ Egipto y xubiꞌij che: ");
INSERT INTO acrTNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Chatyactajok, chebacꞌama bi racꞌa junam rucꞌ ruchu y chixtzelej tanchi Israel, ma ya xecam conoje ri cacaj caquicamisaj racꞌa» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xyactaj cꞌu ri José, xebucꞌam bi racꞌa y ruchu, y xtzelej lo Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero xuxiꞌij rib queꞌec Judea, ma xretaꞌmaj e ri Arquelao rucꞌajol ri Herodes ri xcanaj can rey re Judea pucꞌaxel rukaw. Ruma cꞌu ri xkꞌalajisax che pa jun chic uwachicꞌ, xumaj bi ube Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Echiriꞌ xebopon chilaꞌ, xeꞌjekela pa ri tinamit Nazaret, chaꞌ e xuꞌana ri xquibiꞌij ri kꞌalajisanelab chwi ri Jesús: “Rire cabiꞌx che aj Nazaret.” ");
INSERT INTO acrTNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xopon rukꞌijol echiriꞌ ri Juan Aj Yaꞌl Bautismo catzijon pa tak ri luwar catzꞌintzꞌotic re Judea. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jecꞌuwaꞌ cubiꞌij: «Tzelej tzij alak chwach ri Dios, ma rutakanic ri Dios petinak chilaꞌ chicaj lic xa nakaj chi cꞌo wulok» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ri kꞌalajisanel Isaías xutzꞌibaj can puwi waꞌ wa Juan echiriꞌ xubiꞌij: Catataj ukul jun tzijonel casiqꞌuin chupa ri luwar catzꞌintzꞌotic, jewaꞌ cubiꞌij: “Yijbaꞌ pana alak ri be re ri Kanimajawal; sucꞌupij alak rube Rire” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Rukꞌuꞌ ri Juan ucojom ꞌanom rucꞌ rismal camello y rupas ximil che rupa e jun tzꞌuꞌum; ri cutijo e tak ri sacꞌ y uwaꞌal cab re upa tak juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ri ejekel pa ri tinamit Jerusalem cucꞌ conoje ri e cꞌo pa ri luwar re Judea y ri ejekel chuchiꞌ ri nimayaꞌ Jordán, xebel lo che utayic ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Caquitzꞌonoj cꞌu cuybal quimac chwach ri Dios, y ri Juan cuya ri bautismo chique pa ri nimayaꞌ Jordán. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ecꞌu ri Juan echiriꞌ xrilo lic e qꞌui chique ri fariseos y ri saduceos xecꞌun ruma ri bautismo cuyaꞌo, xubiꞌij chique: «¡Ralak pachaꞌ alak jupuk chi cumatz! ¿China xbiꞌn re we utz quesaj ib alak chwach ri unimal cꞌaxcꞌobic cutak lo ri Dios pawiꞌ alak? ");
INSERT INTO acrTNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bina alak jusucꞌ chaꞌ jelaꞌ cakꞌalajinic jalcꞌatim chi ri binic silabic alak, jelaꞌ pachaꞌ ri takal chique ri quitzelem chi quitzij. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","»Y machꞌob ne alak chi ibil ib alak waꞌ: “Riꞌoj utz kaꞌanom, ma oj ralcꞌoꞌal can ri Abraham.” Ma riꞌin cambiꞌij che alak: We xraj ri Dios, utz cuꞌan ralcꞌoꞌal ri Abraham tob ne che tak waꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yey jiquil chi ne uwach rukꞌatbal tzij ri Dios pawiꞌ alak, e pachaꞌ juna achi uyacom chi ri icaj chwi ri ratzꞌayak ri cheꞌ; ecꞌu tak ri cheꞌ na cuya ta chomilaj jikꞌobal, capokꞌix bi y cacꞌak pa akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","»Riꞌin pakatzij wi canya ri bautismo che alak rucꞌ yaꞌ, cꞌutubal re tzelem chi tzij alak chwach ri Dios. Noꞌj cꞌu ri Jun catajin lo chwij riꞌin, cꞌo pukꞌab cuya ri bautismo che alak rucꞌ ri Santowilaj Ruxlabixel ri Dios y rucꞌ akꞌ. Rire más cꞌo uchukꞌab chinuwach riꞌin; na takal tane chwe tob xa canmolej ruxajab. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ecꞌu Rire coluꞌkꞌata tzij paquiwi ri ticawex chaꞌ jelaꞌ cuya ri tojbal takal chique chiquijujunal. E pachaꞌ juna achi rucꞌaꞌam chi ri puꞌbal uwach ri trigo pukꞌab chaꞌ naꞌl cujoskꞌij waꞌ y caresaj rupucꞌ chupa. Tecꞌuchiriꞌ, cujoc ri trigo y cucꞌol chupa rucꞌolibal. Ecꞌu rupucꞌ cuporoj pa ri jun akꞌ na jinta utakexic catenowic» xcha ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ecꞌuchiriꞌ ri Jesús petinak Galilea, xopon chuchiꞌ ri nimayaꞌ Jordán chaꞌ ri Juan cuya ri bautismo che. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero ri Juan na xraj taj cuya ri bautismo che ri Jesús, jecꞌuwaꞌ xubiꞌij che: —Ri lic usucꞌ e rilal ri cayaꞌw la ri bautismo chwe riꞌin. ¿Yey e cami caꞌaj la riꞌ canya riꞌin ri bautismo cheꞌla? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ecꞌu ri Jesús xucꞌul uwach: —E chaꞌana woꞌora saꞌ ri cambiꞌij riꞌin chawe, ma lic chirajawaxic e cakaꞌan janipa ri lic usucꞌ chwach ri Dios —xchaꞌ. Jecꞌulaꞌ ri Juan xuya ri bautismo che. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tecꞌuchiriꞌ ri Jesús xucꞌul ri bautismo, xel lo pa ri yaꞌ. Y na jampatana cꞌu riꞌ xjakataj ruwa caj y xrilo echiriꞌ ri Ruxlabixel ri Dios xkaj lo puwiꞌ pachaꞌ juna palomax. ");
INSERT INTO acrTNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ecꞌuchiriꞌ, xchꞌaw lo Jun chilaꞌ chicaj, jewaꞌ xubiꞌij: «E Nucꞌajol waꞌ ri lic cꞌax cannaꞌo y lic quinquiꞌcot che» xcha ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tecꞌuchiriꞌ, ri Jesús xcꞌam bi ruma ri Ruxlabixel ri Dios pa jun luwar catzꞌintzꞌotic chaꞌ cacꞌam upa ruma ritzel winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús xcꞌojiꞌ chilaꞌ yey cuarenta kꞌij y cuarenta akꞌab cꞌu riꞌ na jinta cꞌo xutijo. Qꞌuisbal re waꞌ xpe numic che. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xkib cꞌu ritzel winak rucꞌ ri Jesús re cucꞌam upa chaꞌ catzak pa mac, jewaꞌ xubiꞌij che: —We katzij at Ucꞌajol ri Dios, chat-takan che chaꞌ tak waꞌbaj cuꞌan wa —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ri Jesús xucꞌul uwach: —Jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Na xew ta ruma ri wa e cꞌas ri ticawex, ma e cꞌaslic ruma ronoje tak chꞌaꞌtem quel lo puchiꞌ ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ecꞌuchiriꞌ, ritzel winak xucꞌam bi pa ri santowilaj tinamit Jerusalem cꞌa chicaj che ruwi ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Xubiꞌij cꞌu che: —We katzij at Ucꞌajol ri Dios, chacꞌaka bi awib cꞌa chuꞌlew y na jinta cꞌo cacꞌulumaj, ma jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Ri Dios quebutak lo ru ángeles awucꞌ chaꞌ catquichajij. Catquichap cꞌu rucꞌ ri quikꞌab chaꞌ na caꞌchika ta rawakan che juna abaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ri Jesús xucꞌul uwach: —Jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Macꞌam upa ri Dios Kajawxel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ecꞌuchiriꞌ, ritzel winak xucꞌam tanchi ubi ri Jesús chutzaꞌm jun nimalaj juyub y xucꞌut cꞌu chwach, ronoje ri takanic caꞌan puwi tak ri tinamit che ruwachulew rucꞌ ronoje ruchomalil tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xubiꞌij cꞌu che: —Ronoje tak waꞌ canya pakꞌab we caxucubaꞌ awib chinuwach y calokꞌnimaj nukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ecꞌu ri Jesús xubiꞌij che: —Chatela chinuwach Satanás, ma jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Lic chalokꞌnimaj ukꞌij ri Dios Kajawxel y xew Rire chanimaj ukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ecꞌu ritzel winak xuya can ri Jesús y xel bi chiriꞌ. Xecꞌun cꞌu lo jujun ángeles y xquijeko caquinimaj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ri Jesús, echiriꞌ xuto cꞌo ri Juan pa cárcel, xeꞌec tanchi Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xel bi pa ri tinamit Nazaret y xeꞌjekela pa ri tinamit Capernaúm. Waꞌ jun tinamit cꞌo chuchiꞌ ri mar pa ri luwar re Zabulón y re Neftalí. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Xuꞌan cꞌu waꞌ chaꞌ e cuꞌana janipa rutzꞌibam can ri kꞌalajisanel Isaías echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Pa ri luwar re Zabulón y re Neftalí, ri cꞌo pa rubeyal ri mar, chꞌaka yaꞌ che ri nimayaꞌ Jordán, pa tak ri luwar re Galilea pa ejekel wi uqꞌuiyal winak na e ta aj judiꞌab; ");
INSERT INTO acrTNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ri ticawex ejekel pa kꞌekuꞌm xquil ri Kꞌijsak yey ri ejekel pa ri kꞌekuꞌm re camic, xwon ri Kꞌijsak paquiwiꞌ xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chwi cꞌu lo riꞌ xujek ri Jesús catzijonic, jewaꞌ cubiꞌij: «Tzelej tzij alak chwach ri Dios, ma rutakanic ri Dios petinak chilaꞌ chicaj lic xa nakaj chi cꞌo wulok» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Echiriꞌ cabin ri Jesús chuchiꞌ ri mar re Galilea, xril pan quiwach queb achijab quichakꞌ quib, jun Simón rubiꞌ (Pedro quecha che) y ri jun chic Andrés rubiꞌ. Rique e aj chapal car, yey e riꞌ quetajin che ucꞌakic ri qui atarraya pa ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ecꞌu ri Jesús xubiꞌij chique: —Chixpetok, chixterej lo chwij, y riꞌin canꞌan chiwe ix aj molol ticawex, jelaꞌ pachaꞌ iꞌanom lo chique ri car —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Y na jampatana xquiya can ri qui atarraya y xeterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xbin cꞌu pan jubikꞌ chic y xeril chi pan queb achijab quichakꞌ quib, jun Jacobo rubiꞌ y ri jun chic Juan rubiꞌ. Wa caꞌib e ucꞌajol ri Zebedeo. Rique e cꞌo chupa jun barco junam rucꞌ ri quikaw y quetajin che ucꞌojoxic ri qui atarraya. Ecꞌu ri Jesús xebusiqꞌuij bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y na jampatana rique xquiya can ri quibarco y ri quikaw, y xeterej cꞌu bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús xicꞌow che ronoje tinamit re Galilea. Cacꞌutun pa tak sinagogas chujujunal tinamit, cutzijoj ri Utzilaj Tzij re rutakanic ri Dios y cucunaj ronoje uwach yabil cꞌo chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Conoje ri e cꞌo pa tak ri tinamit re Siria xquetaꞌmaj tak ri cuꞌan ri Jesús. Xequicꞌam cꞌu lo chwach Rire conoje ri ticawex rucꞌ tak uqꞌuiyal cꞌaxcꞌolil. Waꞌ e ri e cꞌo pa yabil, ri cꞌax quicꞌulumam, ri e cꞌo paquikꞌab itzel uxlabixel, ri quebumaj tew y ri e sic. Ecꞌu ri Jesús xebucunaj conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lic e qꞌui cꞌu ri xeterej bi chirij. Waꞌ e petinak Jerusalem y che jujun chic luwar re Judea, cucꞌ ri e petinak pa tak ri tinamit re Galilea, re Decápolis y che jujun chic tinamit e cꞌo chꞌaka yaꞌ che ri nimayaꞌ Jordán. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ri Jesús, echiriꞌ xeril ruqꞌuiyal winak, xakꞌan chwa ri juyub y xtzꞌuyiꞌic. Ecꞌu rutijoꞌn xquimol quib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jecꞌuwaꞌ ri xujek ucꞌutic chiquiwach: ");
INSERT INTO acrTNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nim quikꞌij calaxic ri caquetaꞌmaj lic chirajawaxic ri Ruxlabixel ri Dios chique, ma rutakanic ri Dios petinak chilaꞌ chicaj cuꞌana que. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nim quikꞌij calaxic ri quebokꞌic, ma ri Dios e cabochiꞌin quicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nim quikꞌij calaxic ri quiꞌanom chꞌutiꞌn che quib chwach ri Dios, ma cayaꞌ na chique, ri luwar ubiꞌtisim chi ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nim quikꞌij calaxic ri lic cacha quicꞌuꞌx che utzukuxic ri jusucꞌ binic silabic chwach ri Dios, ma ri Dios e cayaꞌw waꞌ chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nim quikꞌij calaxic ri caquicꞌut ri cꞌaxnaꞌbal quicꞌuꞌx chique jujun chic, ma ri Dios cucꞌut ri cꞌaxnaꞌbal ucꞌuꞌx chique rique. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nim quikꞌij calaxic ri uꞌanom chom ri canimaꞌ chwach ri Dios, ma rique caquil na uwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nim quikꞌij calaxic ri caquitzucuj utzil chomal chiquiwach, ma cabiꞌx chique rique e ralcꞌoꞌal ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nim quikꞌij calaxic ri queternabex rucꞌ cꞌaxcꞌobic ruma ri caquiꞌan ri jusucꞌ chwach ri Dios, ma rutakanic ri Dios petinak chilaꞌ chicaj cuꞌana que. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","»Nim ikꞌij iwalaxic riꞌix echiriꞌ wuma riꞌin quixternabex rucꞌ cꞌax, cacꞌak bi ikꞌij y cabiꞌx ronoje ri na utz taj chiwij yey waꞌ xa rakꞌubal. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chixquiꞌcotok y chixbixonok, ma lic nim ri rajil ucꞌaxel quicꞌul chilaꞌ chicaj. Macam cꞌu iwanimaꞌ che echiriꞌ quixyaꞌ pa cꞌax, ma jelaꞌ xꞌan chique ri kꞌalajisanelab ojertan, ri xenabej lo chiwach riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","»Wara che ruwachulew riꞌix lic quixajawax chique ri ticawex jelaꞌ pachaꞌ ratzꞌam lic cajawaxic. Yey we xsach rutzayul ratzꞌam, ¿suꞌanic tanchi caꞌan tza che? Riꞌ na jinta chi cꞌana uchac; queꞌcꞌak cꞌu bi y caxajaxoꞌx can uwiꞌ cuma ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","»Riꞌix ix kꞌijsak che ruwachulew. E juna tinamit cꞌo lo chwi juna juyub na utz taj quewaxic. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yey na utz tane catzij juna akꞌ y cachꞌuk uwiꞌ rucꞌ juna mulul re pajbal, ma ri caꞌan che e cayaꞌiꞌ lo chupa rucꞌolibal chicaj chaꞌ jelaꞌ cutzij quiwiꞌ conoje ri e cꞌo pa ri ja. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jecꞌulaꞌ riꞌix, ix kꞌijsak chiquiwach ri ticawex chaꞌ caquil ri chomilaj chac quiꞌano y jelaꞌ e caquiyac ukꞌij ri Kakaw Dios cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","»Michꞌob cꞌu riꞌix we riꞌin in cꞌuninak re coꞌlnusacha uwach Rutzij Upixab ri Dios tzꞌibital can cuma ri Moisés y ri kꞌalajisanelab. Ma na in cꞌuninak ta che usachic uwach waꞌ; e in cꞌuninak re coꞌlnukꞌalajisaj rusucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Pakatzij wi cambiꞌij chiwe: Xalokꞌ cꞌa tiquil rukꞌijol ruwa caj y ruwachulew, na quesax ta cꞌana juna letra yey na quesax tane tob xa juna ralco juchꞌ che Rutzij Upixab ri Dios, ma e cuꞌana na ronoje ri tzꞌibitalic. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","»Ruma cꞌu waꞌ, china ri cupalajij juna takanic tob ne lic chꞌutiꞌn chwach rire yey e tanchi ucꞌutic cuꞌan chiquiwach ri ticawex, riꞌ na jinta uwach chupa rutakanic ri Dios petinak chilaꞌ chicaj. China cꞌu ri cucoj Rutzij Upixab ri Dios yey jelaꞌ cucꞌut chiquiwach jujun chic chaꞌ e caquiꞌano, riꞌ lic cꞌo uwach chupa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","»Pakatzij wi cambiꞌij chiwe: Xew quixoc riꞌix chupa wa takanic petinak chilaꞌ chicaj, we ribinic isilabic e más jusucꞌ chwa ri quibinic raj cꞌutunel re ri tzijpixab y ri fariseos. Noꞌj we na je ta laꞌ, riꞌ na takal ta chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","»Riꞌix itom ri xbiꞌx lo chique ri ticawex ojertan chupa Rutzij Upixab ri Dios: “Matcamisanic”; yey china cꞌu ri cacamisanic, riꞌ cakꞌat tzij puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","»Noꞌj riꞌin cambiꞌij chiwe: China ri cape royowal chirij juna ratz-uchakꞌ, riꞌ cakꞌat tzij puwiꞌ. China cꞌu ri cucꞌak bi ukꞌij ri ratz-uchakꞌ, riꞌ cacꞌam bi chwach ri kꞌatbal tzij re ri tinamit. Yey china ri cubiꞌij che juna ratz-uchakꞌ: “¡Na jinta cꞌana achac!”, riꞌ catewun puwiꞌ queꞌec pa akꞌ chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","»Ruma cꞌu laꞌ, echiriꞌ cacꞌam bi rakasaꞌn chwa raltar yey chiriꞌ cacꞌun chacꞌuꞌx cꞌo juna awatz-achakꞌ cꞌo royowal chawij, ");
INSERT INTO acrTNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chayaꞌa na can rakasaꞌn chwa raltar y jat nabe rucꞌ rawatz-achakꞌ, jaꞌana utzil chomal rucꞌ. Ecꞌuchiriꞌ, utz catpe tanchi chwa raltar y caya cꞌu riꞌ rakasaꞌn chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","»We cꞌo junok cucoj amac y catucꞌam bi pa kꞌatbal tzij, nabe chaꞌana pan utzil chomal rucꞌ pa be chaꞌ jelaꞌ na catuꞌyaꞌa ta chi pukꞌab raj kꞌatal tzij. Ma we na xaꞌan ta riꞌ, raj kꞌatal tzij catuya bi pukꞌab ri ausiliar chaꞌ catuꞌyaꞌa pa cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Pakatzij wi cambiꞌij chawe: Na catel tana lo pa ri cárcel we na xatoj ta can ronoje ramac. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","»Riꞌix itom ri xbiꞌx lo ojertan chupa Rutzij Upixab ri Dios: “Matmacun chirij ri cꞌulaniquil.” ");
INSERT INTO acrTNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","»Noꞌj riꞌin cambiꞌij chiwe: We cꞌo junok caril juna ixok y curayij uwach re camacun rucꞌ, riꞌ ya xmacun rucꞌ pa ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","»E uwariꞌche, we e rawach uwiquikꞌab ri catzakisan awe pa ri mac, chawesaj y chacꞌaka bi; ma xa ne cuya riꞌ e cajam jun che rawach, chwa ri catcꞌak bi rucꞌ ronoje racuerpo chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We e rakꞌab uwiquikꞌab ri catzakisan awe pa ri mac, chakꞌataꞌ y chacꞌaka bi; ma xa ne cuya riꞌ e cajam jun che rakꞌab, chwa ri catcꞌak bi rucꞌ ronoje racuerpo chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","»Jenewaꞌ xbiꞌx lo ojertan: “We juna achi caraj cujach bi ri rixokil, xew chuyaꞌa bi ruwujil re jachbal ib che.” ");
INSERT INTO acrTNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","»Noꞌj riꞌin cambiꞌij: We rachi cuya bi ruwujil re jachbal ib che ri rixokil tob rixok na macuninak ta chirij ri cꞌulaniquil, riꞌ e cumin ri rixokil pa ri mac. Ma we rixok jachom bi cucꞌam jun chic achi, camacun cꞌu riꞌ chirij ri cꞌulaniquil. Yey e rachi cacꞌuliꞌ rucꞌ rixok jachom bi, riꞌ jenelaꞌ camacun chirij ri cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","»Riꞌix itom ri xbiꞌx lo chique ri ticawex ojertan: “Matsocon rucꞌ ri cajiquibaꞌ uwach; e lic chaꞌana janipa rajiquibam uwach chwach ri Dios” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","»Noꞌj riꞌin cambiꞌij chiwe: Lic macꞌo mijiquibaꞌ uwach pubiꞌ junok. Macꞌo ne mijiquibaꞌ uwach pa rubiꞌ ri caj, ma ri chilaꞌ chicaj e tzꞌulibal pa catakan wi ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Macꞌo mijiquibaꞌ uwach pubiꞌ ruwa ulew, ma ruwa ulew e utacꞌalibal ri rakan ri Dios. Macꞌo ne mijiquibaꞌ uwach pubiꞌ ri tinamit Jerusalem, ma waꞌ e utinamit ri Nimalaj Takanel Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Macꞌo mijiquibaꞌ uwach pubiꞌ ruwiꞌ ijolom, ma riꞌix na quirik tane uꞌanic sak o kꞌek che riwiꞌ, tob tane xa jun chi wiꞌaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E chibiꞌij ri jusucꞌ. We lic katzij, xew chibiꞌij: “Katzij.” We na katzij taj, xew chibiꞌij: “Na katzij taj.” Ma ri cacojiꞌ uwiꞌ ri cabiꞌxic, waꞌ rucꞌ ritzel winak petinak wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","»Riꞌix itom ri xbiꞌx lo ojertan: We cꞌo junok cupuchꞌ rawach, riꞌ takal che capuchꞌ ri riꞌre. We cꞌo junok cutor bi juna aweꞌ, riꞌ takal che cator bi ri riꞌre. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","»Noꞌj riꞌin cambiꞌij chiwe: Miꞌan ucꞌaxel che ri cuꞌan ri na utz taj chiwe. We cꞌo cꞌu junok cupachꞌ kꞌab xeꞌ aweꞌ pawiquikꞌab, chayaꞌa luwar che cupachꞌ ri pa mox. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We cꞌo junok catuchap pa chꞌaꞌoj pa kꞌatbal tzij re cumaj racoton, asu chayaꞌa ne can rakꞌuꞌ re pisbal awij che. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We cꞌo junok catumin bi chuxeꞌ ekaꞌn chaꞌ cawekaj bi jun kilómetro che, asu queb kilómetro chawekaj bi che. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chatsipan che ri nibaꞌ we cutzꞌonoj toꞌbal chawe. We cꞌo junok cachikꞌiman chawe, maꞌan xuꞌyal che. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","»Itom cꞌu ri xbiꞌx lo ojertan: Cꞌax chanaꞌa rawatz-achakꞌ yey tzel chawila ri tzel quilow awe. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","»Noꞌj riꞌin cambiꞌij chiwe: Cꞌax chebinaꞌa ri e aj retzelal cꞌuꞌx chiwij. Chitzꞌonoj ri rutzil ucꞌuꞌx ri Dios paquiwi ri caquitzꞌonoj ri na utz taj piwi riꞌix. Chiꞌana ri utz chique ri tzel quebilow iwe. Chiꞌana cꞌu orar paquiwi janipa ri caquicꞌak bi ikꞌij y ri quixquiternabej rucꞌ cꞌaxcꞌobic ");
INSERT INTO acrTNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","chaꞌ jelaꞌ cakꞌalajinic ix ralcꞌoꞌal ri Kakaw Dios cꞌo chilaꞌ chicaj. Ma Rire cuꞌan che ri kꞌij quel lo paquiwi ri ticawex caquiꞌan ri utz y paquiwi ri caquiꞌan ri na utz taj, yey cutak lo ri jab paquiwi ri jusucꞌ quibinic quisilabic y paquiwi ri na jusucꞌ ta quibinic quisilabic. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","»Ma we xew cꞌax quebinaꞌ ri cꞌax quenaꞌw iwe, ¿saꞌ cꞌu riꞌ ri rajil ucꞌaxel quicꞌulu? Ma jenelaꞌ caquiꞌan raj tzꞌonol puak re tojonic. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","We xew quiya rutzil quiwach ri iwatz-ichakꞌ riꞌix, ¿saꞌ cꞌu riꞌ ri utz quixtajin che uꞌanic? Ma jenelaꞌ caquiꞌan ri na quetaꞌam ta uwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chiꞌana cꞌu jusucꞌ che ri ibinic isilabic jelaꞌ pachaꞌ ri usucꞌliquil ri Kakaw Dios cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","»Miꞌan ri quicꞌut ri jusucꞌ ibinic isilabic chiwachil xa re quixilitaj cuma ri ticawex; ma we jelaꞌ quiꞌano, na jinta rajil ucꞌaxel quicꞌul che Rikaw Dios cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","E uwariꞌche, echiriꞌ quiya limoxna che juna nibaꞌ, mitzijoj chique ri ticawex, pachaꞌ ri caquiꞌan ri xa queb quipalaj pa tak sinagogas y pa tak be. Ma rique jelaꞌ caquiꞌano xew chaꞌ cayac quikꞌij. Noꞌj riꞌin pakatzij wi cambiꞌij chiwe: Rucꞌ cꞌu wa yacbal quikꞌij, ya e laꞌ xquicꞌul ri rajil ucꞌaxel ri xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E uwariꞌche, echiriꞌ quiya limoxna chique ri nibaꞌib, miꞌan chiwachil. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jecꞌulaꞌ na jinta cꞌo canaꞌben re, xew Rikaw Dios quetaꞌman waꞌ. Ecꞌu Rire cuya na ri rajil ucꞌaxel chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","»Echiriꞌ quixchꞌaꞌt rucꞌ ri Dios, miꞌan iweꞌix pachaꞌ ri caquiꞌan ri xa queb quipalaj. Ma rique lic cucꞌul quicꞌuꞌx ri caquibololej oración e laꞌ e tacꞌal pa tak sinagogas y pa tak jachbal be chaꞌ jelaꞌ quebilitaj cuma ri ticawex. Noꞌj riꞌin pakatzij wi cambiꞌij chiwe: Rucꞌ cꞌu wa yacbal quikꞌij, ya e laꞌ xquicꞌul ri rajil ucꞌaxel ri xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Noꞌj riꞌix echiriꞌ quixchꞌaꞌt rucꞌ ri Dios, chixoc pa ja, chitzꞌapij lo ri puerta y chixchꞌaꞌt rucꞌ Rikaw Dios xa ituquel; jecꞌulaꞌ Rikaw Dios caril ri quiꞌan xa ituquel y cuya na cꞌu ri rajil ucꞌaxel chiwe chiwachil. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","»Ecꞌuchiriꞌ quixchꞌaꞌt rucꞌ ri Dios, miwererej chꞌaꞌtem uqꞌuiyal laj pachaꞌ caquiꞌan ri na quetaꞌam ta uwach ri Dios; ma e caquichꞌob rique ruma ri caquiwererej chꞌaꞌtem, quetataj ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Miꞌan cꞌu iweꞌix pachaꞌ ri caquiꞌan rique, ma Rikaw Dios lic retaꞌam chic saꞌ ri cajawax chiwe echiriꞌ cꞌamajaꞌ ne quitzꞌonoj che. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","»Ecꞌu riꞌix echiriꞌ quixchꞌaꞌt rucꞌ ri Dios utz jewaꞌ tak ri quibiꞌij: Kakaw Dios, Lal cꞌo la chilaꞌ chicaj, ¡lic chetaꞌmaxok nim ukꞌij ri biꞌ la! ");
INSERT INTO acrTNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Peta la, takana la pakawiꞌ; chuꞌana cꞌu ri rajawal cꞌuꞌx la wara che ruwachulew, jelaꞌ pachaꞌ ri caꞌan chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yaꞌa co la wakꞌij ri kawa, ri cajawax chike ronoje kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cuyu co la kamac, jelaꞌ pachaꞌ riꞌoj cakacuy quimac ri emacuninak chikij. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y maya co la luwar chike cojtzak pa mac; e lic chojcolobej la chwach ritzel winak. Ma pakꞌab Rilal cꞌo wi ronoje takanic y chukꞌab; y xew che Rilal takal wi ri yacbal kꞌij na jinta utakexic. Amén. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","»Ma we riꞌix quicuy quimac tak ri ticawex, jecꞌulaꞌ riꞌ cuꞌan ri Kakaw Dios cꞌo chilaꞌ chicaj, cucuy imac riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Noꞌj we riꞌix na quicuy ta quimac tak ri ticawex, jecꞌulaꞌ riꞌ cuꞌan ri Kakaw Dios, na cucuy ta imac riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","»Echiriꞌ riꞌix quiꞌan ayuno, micꞌut bis che ripalaj pachaꞌ ri caquiꞌan ri xa queb quipalaj. Ma rique caquiꞌan waꞌ xa pachaꞌ quebilitaj cuma ri winak. Pakatzij wi cambiꞌij chiwe: Rucꞌ cꞌu wa yacbal quikꞌij, ya e laꞌ xquicꞌul ri rajil ucꞌaxel ri xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Noꞌj riꞌix echiriꞌ quiꞌan ayuno, chichꞌaja ripalaj y chixiya riwiꞌ chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jecꞌulaꞌ ri ticawex na caquil taj we riꞌix ix cꞌo pa ayuno. Xew cꞌu Rikaw Dios, ri na quilitaj ta uwach, caril ri na caquil ta ri ticawex. Ecꞌu riꞌ Rire cayaꞌw na ri rajil ucꞌaxel chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","»Mixchacun xa re quimol ucꞌuꞌxibal beyomalil re ruwachulew, ma ri wara e tak ri icꞌolom xa capoqꞌuiric y cuꞌan mojos, yey queboc ne elekꞌomab che relekꞌaxic bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","We quiwaj quirik ri sakil beyomalil, e chiꞌana wara che ruwachulew janipa ri lic cꞌo uchac chwach ri Dios chaꞌ jelaꞌ cꞌo cutikoj chiwe riꞌix chilaꞌ chicaj. Ma ri icꞌolom chilaꞌ na capoqꞌuir taj y na cuꞌan ta mojos, yey na jinta ne elekꞌomab queboc che relekꞌaxic bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma pa cꞌo wi ribeyomalil riꞌix, puwi waꞌ queꞌec wi icꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","»Ri kawach e pachaꞌ candil re ri kacuerpo, ma ruma waꞌ cojtzuꞌnic chaꞌ utz cojbinic. Jecꞌulaꞌ, we ri kawach utz uꞌanom, ronoje ri kacuerpo nojinak che kꞌijsak y cakil cꞌu ronoje chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Noꞌj we ri kawach na utz taj, ronoje ri kacuerpo cꞌo pa kꞌekuꞌm. Jecꞌulaꞌ, we ri kꞌijsak cꞌo kucꞌ uꞌanom junam rucꞌ ri kꞌekuꞌm, ¡coꞌl chi lo kꞌekuꞌmalil riꞌ oj cꞌo wi! ");
INSERT INTO acrTNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","»Lic cꞌayew we juna aj chac e caꞌib ri rajaw. Ma laj tzel caril ri jun yey cꞌax cunaꞌ ri jun chic; o laj cuyac ukꞌij ri jun yey cucꞌak bi ukꞌij ri jun chic. Ruma cꞌu laꞌ, na utz taj we junok cuya rib che unimaxic ri Dios yey cuya rib che utzucuxic ri beyomalil re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","»E uwariꞌche cambiꞌij chiwe riꞌix: Mubisoj icꞌuꞌx ricꞌaslem; mubisoj ne icꞌuꞌx saꞌ riwa y rimikꞌinaꞌ quitijo o saꞌ rikꞌuꞌ quicojo. ¿Na e ta neba más cꞌo uwach ricꞌaslem riꞌix chwach ri quitijo? ¿Yey na e ta neba más cꞌo uwach ri cuerpo chwach rikꞌuꞌ quicojo? ");
INSERT INTO acrTNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","»Chebiwilape ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj. Rique na queticoꞌnaj taj, na caquiꞌan tane quimolonic y na jinta ne pa caquicꞌol wi ri quimolonic. Na rucꞌ ta cꞌu riꞌ, Rikaw Dios cꞌo chilaꞌ chicaj quebutzuku. ¡Macꞌuwariꞌ riꞌix, ri Dios quixuchajij, ma e más cꞌo iwach riꞌix chiquiwa ri tzꞌiquin! ");
INSERT INTO acrTNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","»¿Cꞌo neba junok chiwe riꞌix curik cunajtirisaj jun chic kꞌij che rucꞌaslem wara che ruwachulew? Na jinta junok, tob ne lic cutij ukꞌij che. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Suꞌbe cꞌu riꞌ lic cubisoj icꞌuꞌx rikꞌuꞌ quicojo? Chiwilapeꞌ suꞌanic queqꞌuiy ri cotzꞌiꞌj pa tak juyub; waꞌ na quechacun taj y na quequeman ta nenareꞌ chaꞌ caquiꞌan ri quikꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yey riꞌin cambiꞌij chiwe: Ri rey Salomón, tob lic cꞌo uchomal rukꞌuꞌ xucojo, waꞌ na xumaj ta cꞌana ruchomalil tak ri cotzꞌiꞌj. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jecꞌulaꞌ we ri Dios uꞌanom chom che ri akꞌes cꞌo wakꞌij pa juyub yey chweꞌk xa caporox pa akꞌ, ¿na cuya ta cami riꞌ ri Dios rikꞌuꞌ cajawax chiwe? ¡Riꞌix lic xa jubikꞌ ri cubulibal icꞌuꞌx rucꞌ ri Dios! ");
INSERT INTO acrTNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","»Cambiꞌij cꞌu chiwe: Mubisoj icꞌuꞌx y mibiꞌij: “¿Saꞌ ri kawa, saꞌ ri kamikꞌinaꞌ cakatijo? ¿Saꞌ ri kakꞌuꞌ cakacojo?” ");
INSERT INTO acrTNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ma jenelaꞌ caquiꞌan ri winak na quetaꞌam ta uwach ri Dios, e cubisoj quicꞌuꞌx tak waꞌ. Noꞌj riꞌix cꞌo jun Ikaw chilaꞌ chicaj lic retaꞌam cajawax ronoje tak waꞌ chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","»Ri lic chirajawaxic chiwe nabe e lic chixoc il che rutakanic ri Dios y che ri jusucꞌ binic silabic caraj Rire chiwe. Yey ronoje tak cꞌu ri cajawaxic, xa uwiꞌ chic cayaꞌtaj chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mubisoj pan icꞌuꞌx ri quiwil chweꞌk, ma chujujunal kꞌij ucꞌamom chi lo rucꞌayewal. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","»Miꞌan ri xa piwe riꞌix quixuꞌan aj kꞌatal tzij paquiwi jujun chic, chaꞌ jelaꞌ na cakꞌat ta tzij piwi riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ma e ruꞌanic quikꞌat tzij riꞌix paquiwi jujun chic, jelaꞌ cuꞌan ri Dios piwi riꞌix; ma rucꞌ ri pajbal quixpajan wi, rucꞌ laꞌ quixpaj wi riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","»¿Suꞌchac e lic catzutzaꞌ rucꞌaj cheꞌ cꞌo chupa ruwach rawatz-achakꞌ yey e na catoc ta cꞌu il che resaxic ri cheꞌ kꞌebel chupa rawach riꞌat? ");
INSERT INTO acrTNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Y we kꞌebel la jun cheꞌ chupa rawach riꞌat, ¿utz nawi cabiꞌij che rawatz-achakꞌ: “Chayaꞌa luwar chwe canwesaj la jun ucꞌaj cheꞌ cꞌo chupa rawach”? ¡Na utz taj! ");
INSERT INTO acrTNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Xa queb apalaj! Nabe na chawesaj lo la cheꞌ kꞌebel chupa rawach riꞌat, y jelaꞌ cat-tzuꞌn chi utz chaꞌ catoꞌ rawatz-achakꞌ che resaxic lo rucꞌaj cheꞌ cꞌo chupa ruwach rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","»Miya chiquiwa ri tzꞌiꞌ janipa ri lic chom chwach ri Dios, ma cꞌaxtaj quepe chiwij y caquirakachꞌij ipa; jecꞌulaꞌ micꞌak chiquiwach ri ak ri perlas cꞌo iwucꞌ, ma cꞌaxtaj xa caquixikꞌixaꞌ uwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","»Janipa ri cajawax chiwe, chitzꞌonoj che ri Dios y cayaꞌiꞌ chiwe; chitzucuj rucꞌ Rire janipa ri cajawax chiwe y quiriko; chichꞌaꞌbej Rire y lic quixucajmaj lok. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ma china ri cutzꞌonoj ri cajawax che, cucꞌul na; china ri cꞌo cutzucuj, curik na; y china ri cachꞌaw pan che ruchiꞌ ja, cajakiꞌ na lo che. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","»¿Cꞌo neba juna achi chixoꞌl, we rucꞌajol cutzꞌonoj pam, cuya juna abaj che; ");
INSERT INTO acrTNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o we cutzꞌonoj car, cumatz ri cuya che? ¡Na jintaj junok! ");
INSERT INTO acrTNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ecꞌu riꞌ riꞌix tob xa ix ticawex na lic ta utz icꞌuꞌx, na rucꞌ ta cꞌu riꞌ, quirik uyaꞌic chomilaj tak sipanic chique riwalcꞌoꞌal. ¡Macꞌuwariꞌ ri Kakaw Dios cꞌo chilaꞌ chicaj cuya chomilaj tak sipanic chique ri quetzꞌonow re che! ");
INSERT INTO acrTNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","»Ecꞌu riꞌix chiꞌana chique ri ticawex jelaꞌ pachaꞌ ri quiwaj caquiꞌan rique chiwe. Ma e utakanic waꞌ Rutzij Upixab ri Dios tzꞌibital can cuma ri Moisés y ri kꞌalajisanelab. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","»Chixoc bi che ri oquibal chꞌutiꞌn uwach. Ma ri oquibal y ri be queꞌec chi xibalbaꞌ lic nim uwach, yey lic e qꞌui ri queboc bi chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Noꞌj ri oquibal y ri be queꞌec chi cꞌaslemal na jinta utakexic, lic chꞌutiꞌn uwach, yey na e ta qꞌui ri queboc bi chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","»Lic chichajij iwib chiquiwach ri caquibiꞌij e kꞌalajisanelab re ri Dios yey xa e socosoꞌnel. Ma waꞌ quecꞌun iwucꞌ riꞌix lic chacojoꞌ utz quicꞌuꞌx, noꞌj chupa ri canimaꞌ xa pachaꞌ e utiw lic e bikꞌonel. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ecꞌu riꞌix quiwetaꞌmaj saꞌ ri cꞌo pa canimaꞌ ri ticawex ruma ri caquiꞌano, we utz o na utz taj. »E pachaꞌ tak ri cheꞌ: ri qꞌuix, na uva ta rujikꞌobalil cuyaꞌo; yey ri xuluquej, na higos ta rujikꞌobalil cuyaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jecꞌulaꞌ juna chomilaj cheꞌ, lic chom rujikꞌobalil cuyaꞌo; noꞌj ri cheꞌ na chom taj, na jinta uchac rujikꞌobalil cuyaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ri chomilaj cheꞌ na ube taj we na chom ta rujikꞌobalil cuyaꞌo; jecꞌulaꞌ ri cheꞌ na chom taj na cuya ta ujikꞌobalil chom. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yey ronoje cheꞌ we na chom taj rujikꞌobalil cuyaꞌo, cachet bi y caporox pa akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Riꞌix quiwetaꞌmaj cꞌu uwach juna cheꞌ ruma rujikꞌobalil cuyaꞌo; jecꞌulaꞌ cakꞌalajinic saꞌ tak ri cꞌo pa canimaꞌ ri ticawex ruma ri quibinic quisilabic. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","»Na conoje ta ri caquibiꞌij chwe “Kajawal, Kajawal” queboc chilaꞌ chicaj pa rutakanic ri Dios, ma xew queboc ri caquiꞌan ri rajawal ucꞌuꞌx ri Nukaw cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Copon cꞌu rukꞌijol echiriꞌ ri Dios cukꞌat tzij paquiwi ri ticawex, yey chupa laꞌ la kꞌij lic e qꞌui ri caquibiꞌij chwe: “Wajawal, Wajawal, riꞌoj xkaꞌan kꞌalajisanic chupa ri biꞌ la chique ri ticawex. Yey chupa ri biꞌ la xekesaj bi ri itzel uxlabixel y pa ri biꞌ la xkaꞌan uqꞌuiyal milagros” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ecꞌuchiriꞌ, riꞌin jewaꞌ cambiꞌij chique: “Na xinwetaꞌmaj ta cꞌana iwach, chixela wucꞌ; ma riꞌix xew ix ꞌanal re ri lic itzel uwach.” ");
INSERT INTO acrTNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","»China cꞌu ri cataw re ri nutzij yey cuꞌan janipa ri cambiꞌij, canjunimaj rucꞌ jun achi lic cꞌo unaꞌoj ma xutzꞌak lo ri rocho paꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xpe cꞌu lo ri jab, lic xnimar tak ri nimayaꞌ y xpe lo unimal cakjikꞌ y xumachꞌ rib che ri ja; na rucꞌ ta cꞌu riꞌ, ri ja na xtzak ta ubi, ma paꞌbaj tzꞌakom lo wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Noꞌj cꞌu ri cuta ri nutzij yey na cuꞌan ta janipa ri cambiꞌij, canjunimaj rucꞌ jun achi na jinta unaꞌoj, ma xuꞌan ri rocho pa sanyeb. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xpe cꞌu lo ri jab, xenimar tak ri nimayaꞌ, xpe lo unimal cakjikꞌ y xumachꞌ rib che ri ja. Ecꞌu riꞌ ri ja xwuluwub bi y xsach uwach» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Echiriꞌ xuqꞌuis ubiꞌxic waꞌ ri Jesús, ri winak lic caminak canimaꞌ che rucꞌutunic, ");
INSERT INTO acrTNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ma ruma rucꞌutunic cakꞌalajinic lic cꞌo uwach, na xa ta pachaꞌ ri caquiꞌan raj cꞌutunel re ri tzijpixab. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ecꞌuchiriꞌ xkaj lo ri Jesús chwa ri juyub, lic uqꞌuiyal winak xeterej lo chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tecꞌuchiriꞌ, xopon jun achi cꞌo ri yabil lepra che, xuxuc rib chwach ri Jesús y xubiꞌij che: —Wajawal, we caꞌaj co la, joskꞌij la ri nucuerpo che wa yabil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ecꞌu ri Jesús xuchap pana rucꞌ rukꞌab y jecꞌuwaꞌ xubiꞌij che: —Cuaj, chuꞌana ba chom riꞌ racuerpo —xchaꞌ. Xew cꞌu xuqꞌuis ubiꞌxiquil waꞌ, na jampatana xsach ri yabil cꞌo che rachi. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ecꞌu ri Jesús xubiꞌij che: —Chatapeꞌ, lic matzijoj che junok riꞌin xatincunaj. Jat chwach raj chacunel pa Rocho Dios chaꞌ rire carilo na jinta chi lepra chawe, y chayaꞌa chwach ri Dios ri kasaꞌn xtakan can ri Moisés che chaꞌ cakꞌalajin chiquiwach ri ticawex at cunutajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Echiriꞌ xopon ri Jesús pa ri tinamit Capernaúm, xopon jun capitán que ri soldados aj Roma rucꞌ y xujek lic quelaj che, ");
INSERT INTO acrTNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","jewaꞌ cubiꞌij: —Wajawal, ri waj chac lic yewaꞌ cꞌo chwa uwarabal chiwocho. Rire xuꞌan sic y lic cꞌo pa cꞌax —cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xubiꞌij che: —Riꞌin quinꞌec y cancunaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ecꞌu ri capitán xubiꞌij che: —Wajawal, riꞌin lic na takal ta chwe coc la chiwocho. Xew biꞌij la: “Chatcunutajok”, y rucꞌ ri chꞌaꞌtem la, cacunutaj ri waj chac. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma e pachaꞌ riꞌin, in cꞌo pukꞌab jun takanel y rire ebuyaꞌom uqꞌuiyal soldados panukꞌab. We cambiꞌij cꞌu che junok “Jat”, queꞌec; o cambiꞌij che junok chic “Chatpetok”, capetic. Yey we cambiꞌij che juna waj chac “Chaꞌana waꞌ”, cuꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ri Jesús echiriꞌ xuta waꞌ, lic xcam ranimaꞌ che y jewaꞌ xubiꞌij chique ri eteran chirij: —Pakatzij wi cambiꞌij chiwe: Na nurikom tane chiquixoꞌl raj Israel junok lic cꞌo unimal cubulibal ucꞌuꞌx pachaꞌ wa jun achi. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Cambiꞌij cꞌu chiwe: Lic e qꞌui ri quepe pa relebal lo ri kꞌij y e qꞌui ri quepe putzakibal ri kꞌij y queboc chwa ri mexa pa waꞌim rucꞌ ri Abraham, rucꞌ ri Isaac y rucꞌ ri Jacob chupa rutakanic ri Dios cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Noꞌj tak cꞌu ri caquichꞌobo takal chique caquicꞌul rutakanic ri Dios ruma e ratz-uchakꞌ can ri Abraham, riꞌ quebesax bi y quecꞌak bi pa ri kꞌekuꞌm; chiriꞌ cꞌu riꞌ quebokꞌ wi y cakichꞌichꞌ ruwi queꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ecꞌuchiriꞌ, xubiꞌij ri Jesús che ri capitán: —Oj chi ocho la, ma jelaꞌ cuꞌanaꞌ pachaꞌ ri xcubiꞌ cꞌuꞌx la che —xchaꞌ. Chupa cꞌu laꞌ la jokꞌotaj xcunutaj ri raj chac. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ri Jesús xopon chirocho ri Pedro. Chiriꞌ cꞌu riꞌ xril ruchu-ujiꞌ ri Pedro cꞌo chwa uwarabal y lic cꞌo akꞌ chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ecꞌu ri Jesús xuchap rukꞌab y jecꞌulaꞌ xicꞌow ri akꞌ chirij. Ecꞌuchiriꞌ, rixok xyactajic y xujek quebunimaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Echiriꞌ xoc rakꞌab, xequicꞌam lo chwach ri Jesús uqꞌuiyal ticawex e cꞌo paquikꞌab itzel uxlabixel. Ecꞌu ri Jesús rucꞌ ruchꞌaꞌtem xeberesaj bi tak ri itzel uxlabixel chique y xebucunaj conoje ri yewaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Xuꞌan waꞌ chaꞌ e cuꞌana ri utzijom can ri kꞌalajisanel Isaías echiriꞌ xubiꞌij: Rire xucꞌam bi ri kayabil, y xucꞌam bi ri kacꞌaxcꞌolil xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ri Jesús echiriꞌ xrilo uqꞌuiyal winak quisutum rij, xebutak rutijoꞌn chaꞌ quekꞌax chꞌaka yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ecꞌu laꞌ la jokꞌotaj xopon rucꞌ ri Jesús jun achi aj cꞌutunel re ri tzijpixab y xubiꞌij che: —Lal tijonel, riꞌin quinterej bi chiꞌij la tob pachawi queꞌec wi la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ri Jesús xucꞌul uwach: —Ri yac cꞌo quijul y ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj cꞌo quisoc; noꞌj Ralaxel Chiquixoꞌl Ticawex na jinta ne uluwar tob xa pa cuxlan wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Cꞌo chi jun chique rutijoꞌn xubiꞌij che ri Jesús: —Wajawal, yaꞌa la luwar chwe canwoyꞌej cacam na ri nukaw y canmuk canok; tecꞌuchiriꞌ, quinterej chiꞌij la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ecꞌu ri Jesús xucꞌul uwach: —Riꞌat chat-terej lo chwij; chayaꞌa can chique ri ecaminak chwach ri Dios chaꞌ e rique quemukuw ri catz-quichakꞌ quecamic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ecꞌuchiriꞌ, xoc ri Jesús pa jun barco y rutijoꞌn xebec rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tecꞌuchiriꞌ, xpe jun nimalaj cakjikꞌ chwi ri mar y xujeko canoj ri barco che yaꞌ. Yey ri Jesús cawaric. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ecꞌu rutijoꞌn xeꞌquicꞌosoj y xquibiꞌij che: —¡Kajawal! ¡Chojcolobej la, ma cojcamic! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ri Jesús xucꞌul uwach: —¿Suꞌchac lic quixiꞌij iwib? Riꞌix lic xa jubikꞌ ri cubulibal icꞌuꞌx wucꞌ —xchaꞌ. Ecꞌuchiriꞌ xyactajic, xukꞌatej ri cakjikꞌ y ri yaꞌ. Xtaniꞌ cꞌu riꞌ ri cakjikꞌ y ri yaꞌ xyeniꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Rutijoꞌn lic xcam canimaꞌ che y xquibiꞌij: «¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tob ne e ri cakjikꞌ y ri yaꞌ caquicoj utzij!» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Echiriꞌ xopon ri Jesús chꞌaka mar pa ri luwar re Gadara, xoꞌlcꞌul cuma queb achijab ebelinak lo chuxoꞌl tak mukubal que animaꞌ. Quicabichal e cꞌo paquikꞌab itzel uxlabixel y lic itzel quiwachlibal, ma cuma rique na jinta junok quicꞌow chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E tak cꞌu riꞌ waꞌ xquijeko lic co quesiqꞌuinic, jewaꞌ xquibiꞌij: —¿Suꞌchac coꞌlmina ib la kucꞌ, Jesús, Lal Ucꞌajol ri Dios? ¿Petinak cami la re cojya la pa cꞌax echiriꞌ cꞌamajaꞌ ne copon ri kakꞌij? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E cꞌo cꞌu uqꞌuiyal ak quewaꞌ lo chinimanaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ecꞌu ri itzel uxlabixel lic xebelaj che ri Jesús: —We cojesaj bi la, yaꞌa la luwar chike cojoc bi cucꞌ ri ak —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ecꞌuchiriꞌ, xubiꞌij ri Jesús chique: —Jix riꞌ —xchaꞌ. Tak ri itzel uxlabixel xebel bi chique rachijab y xeboc cucꞌ ri ak. Tecꞌuchiriꞌ, conoje ri ak xeꞌquicꞌaka bi quib chwi jun siwan, xebeꞌtzaka cꞌa chupa ri mar y chiriꞌ xejikꞌ wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ecꞌu ri e chajinel que ri ak xebanimajic. Y echiriꞌ xebopon pa ri tinamit, xquijek utzijoxic ronoje ri xquicꞌulumaj ri ak y ri xuꞌan ri Jesús chique ri queb achijab echiriꞌ xeberesaj paquikꞌab ri itzel uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Conoje cꞌu ri winak re ri tinamit xepe pa cꞌo wi ri Jesús. Echiriꞌ xquil uwach, lic xquitzꞌonoj che chaꞌ quel bi chiriꞌ pa tak ri quiluwar. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ecꞌuchiriꞌ, xoc ri Jesús pa jun barco, xkꞌax chꞌaka yaꞌ y xopon pa ri tinamit pa jekel wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E cꞌo cꞌu jujun achijab xquicꞌam lo jun achi sic chwach ri Jesús, quitelem lo chwa jun chꞌat. Echiriꞌ ri Jesús xril ri cubulibal quicꞌuꞌx rucꞌ, xubiꞌij che rachi sic: —Wal, chanimarisaj acꞌuꞌx, ma ronoje ramac cuytajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E cꞌo cꞌu jujun chique raj cꞌutunel re ri tzijpixab jewaꞌ xquichꞌobo: «Wa jun achi lic camacun chirij ri Dios, ma na yaꞌtal ta pukꞌab junok cubiꞌij waꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Noꞌj ri Jesús xunaꞌbej saꞌ ri caquichꞌobo; ruma cꞌu riꞌ, xubiꞌij chique: —¿Suꞌchac cachꞌob alak ri na utz taj? ");
INSERT INTO acrTNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Saꞌ cꞌu ri na cꞌayew taj cambiꞌij: “Ronoje ramac cuytajinak chic” o “Chatyactajok y chatbinok”? ");
INSERT INTO acrTNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","E cuaj cꞌut quetaꞌmaj alak waꞌ: Ralaxel Chiquixoꞌl Ticawex yaꞌtal pukꞌab cucuy tak ri mac que ri winak che ruwachulew —xchaꞌ. Xubiꞌij cꞌu riꞌ che ri sic: —Chatyactajok, chacꞌama bi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xyactaj cꞌu ri sic y xeꞌec chirocho. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Echiriꞌ xquil waꞌ ri winak, lic xcam canimaꞌ che y xquiyac ukꞌij ri Dios ruma uyaꞌom chique ri ticawex caquiꞌan tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xel cꞌu bi ri Jesús chiriꞌ y xril jun achi aj tzꞌonol puak re tojonic, Mateo rubiꞌ, tzꞌul pa ri luwar pa caꞌan wi ri tojonic che ri gobierno, y xubiꞌij che: —Chat-terej lo chwij —xchaꞌ. Y ri Mateo xyactajic y xterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ecꞌu ri Jesús xumaj bi chirocho waꞌchi y xeboc chwa ri mexa cucꞌ rutijoꞌn. Xebopon cꞌu uqꞌuiyal aj tzꞌonol puak re tojonic y uqꞌuiyal aj maquib y xetzꞌuyiꞌ junam cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Echiriꞌ xquil waꞌ ri fariseos, xquibiꞌij chique rutijoꞌn ri Jesús: —¿Suꞌchac ri tijonel iwe riꞌix cawaꞌ junam cucꞌ raj tzꞌonol puak re tojonic y cucꞌ raj maquib? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Echiriꞌ xuta waꞌ ri Jesús, xubiꞌij chique: —E janipa ri utz quiwach, na cajawax ta aj cunanel chique; ma waꞌ xew chique ri e yewaꞌib cajawax wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oj cꞌu alak y maja na alak saꞌ queꞌelawi ri cubiꞌij ri Dios chupa Ruchꞌaꞌtem: Ri lic cuaj riꞌin chiwe e ri cꞌutubal re ri cꞌaxnaꞌbal cꞌuꞌxaj, na e ta ri cacamisax awaj re kasaꞌn chinuwach cachaꞌ. »Riꞌin na in petinak ta che quisiqꞌuixic ri jusucꞌ quibinic quisilabic, ma in petinak che quisiqꞌuixic raj maquib chaꞌ caquijalcꞌatij ri quibinic quisilabic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ecꞌuchiriꞌ, rutijoꞌn ri Juan Aj Yaꞌl Bautismo xekib rucꞌ ri Jesús y xquitzꞌonoj che: —¿Suꞌchac riꞌoj y ri fariseos lic cakaꞌan ayuno yey ri tijoꞌn rilal na caquiꞌan taj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xucꞌul uwach: —¿Utz neba quecꞌojiꞌ pa bis ri esiqꞌuim pa cꞌulaniquil we cꞌa cꞌo rala cacꞌuliꞌic chiquixoꞌl? Na utz taj. Noꞌj copon na ri kꞌij echiriꞌ quesax bi rala chiquixoꞌl; cꞌa ecꞌuchiriꞌ caquiꞌan ayuno. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na jinta junok cucꞌojoj rukꞌuꞌ kꞌeꞌl rucꞌ cꞌojobal cꞌasak, ma ri cꞌojobal cꞌasak, we xcꞌolotaj upa, e cujecꞌ ri cꞌul kꞌeꞌl y más ne curichꞌij bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","»Jecꞌulaꞌ ri vino cꞌacꞌ ꞌanom na cakꞌej ta chupa juna surun kꞌeꞌl. Ma we caꞌaniꞌ waꞌ, ri vino cꞌacꞌ echiriꞌ canajtir ukꞌij, curakij ri surun, catix cꞌu riꞌ ri vino y ri surun na jinta chi uchac. Ruma cꞌu laꞌ, ri vino cꞌacꞌ ꞌanom chirajawaxic wi cakꞌej chupa ri surun cꞌasak chaꞌ ucabichal waꞌ cacowinic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Echiriꞌ catajin ri Jesús che ubiꞌxiquil tak waꞌ, xcꞌun lo jun achi aj wach re ri tinamit, xuxuc rib chwach y xubiꞌij che: —Ri numiꞌal lic cꞌa e laꞌ xcamic. We ta rilal queꞌec la wucꞌ y queꞌyaꞌa ri kꞌab la puwiꞌ, rire cacꞌastaj tanchic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ri Jesús xyactajic y xeꞌec rucꞌ rachi, junam cucꞌ rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ecꞌu laꞌ, cꞌo jun ixok lic yewaꞌ, e cablajuj lo junab riꞌ na cataniꞌ ta ri yabil re upa icꞌ che. Xkib cꞌu pana chirij ri Jesús y xuchap ruchiꞌ rukꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma xuchꞌob pa ranimaꞌ: «Tob tane xew luꞌkꞌuꞌ canchapo, rucꞌ riꞌ quincunutajic.» ");
INSERT INTO acrTNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús xtzuꞌn lo chirij, xutzuꞌ uwach rixok y jewaꞌ xubiꞌij che: —Ixok, nimarisaj cꞌuꞌx la, ma xcunutaj la ruma xcubiꞌ cꞌuꞌx la wucꞌ —xchaꞌ. Chupa cꞌu riꞌ la jokꞌotaj rixok asu xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ecꞌuchiriꞌ xoc bi ri Jesús chirocho rachi aj wach, quebutzutzaꞌ ri caquichꞌawisaj suꞌ y ri winak quewokokic. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xubiꞌij cꞌu ri Jesús chique: —Chixelubi, ma wa ralco ali na caminak taj, xa cawaric —xchaꞌ. Yey xa xquitzeꞌej cꞌu ri xubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ecꞌuchiriꞌ xebesax lo ri winak, ri Jesús xoc bi pa cꞌo wi ri ralco ali; xuchap cꞌu rukꞌab y waꞌli xyactajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Xeꞌec cꞌu utzijoxic riꞌ waꞌ che ronoje tak la luwar. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Echiriꞌ xel bi ri Jesús chiriꞌ, xeterej bi caꞌib potzꞌ chirij, lic co quesiqꞌuin che, jewaꞌ caquibiꞌij: —¡Choj-juchꞌ caꞌn co cheꞌla, lal Ralcꞌoꞌal can ri rey David! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Echiriꞌ xoc ri Jesús chuchiꞌ jun ja, xekib ri caꞌib potzꞌ rucꞌ y Rire xubiꞌij chique: —¿Quicoj riꞌix we riꞌin cꞌo panukꞌab canya ri itzuꞌnibal? —xchaꞌ. Rique xquibiꞌij: —Cakacojo, Kajawal —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ecꞌu ri Jesús xuya rukꞌab puwi ri quiwach y xubiꞌij chique: —Chuꞌana waꞌ iwucꞌ e chirij ri cubulibal icꞌuꞌx —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jecꞌulaꞌ xcunutaj ri quiwach. Ewi ri Jesús lic xebupixabaj, jewaꞌ xubiꞌij chique: —Lic mitzijoj waꞌ che junok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Noꞌj rique xew xebel bi, xquijek caquitzijoj pa ronoje tak laꞌ la luwar ri xuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Echiriꞌ catajin bi quelic ri queb achijab xcunutaj ri quiwach, ri winak xquicꞌam lo chwach ri Jesús jun achi meꞌt cꞌo pukꞌab jun itzel uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ecꞌuchiriꞌ ri Jesús xresaj bi ri itzel uxlabixel che, ri meꞌt xcunutajic y xujek cachꞌaꞌtic. E tak cꞌu ri winak lic xcam canimaꞌ che waꞌ y xquibiꞌij chiquiwach: «Na kilom ta cꞌana waꞌ wara Israel pachaꞌ wa xkil woꞌora» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Noꞌj ri fariseos xquibiꞌij: «Laꞌ la Jesús queberesaj bi itzel uxlabixel ruma ruchukꞌab ri cajawal ri itzel uxlabixel» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Echiriꞌ ri Jesús xicꞌow pa tak ronoje tinamit y aldeas, cacꞌutun chupa tak ri sinagogas chujujunal luwar, cutzijoj ri Utzilaj Tzij re rutakanic ri Dios y cucunaj ronoje yabil y cꞌaxcꞌobic. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ecꞌuchiriꞌ xeril ruqꞌuiyal winak, lic xejuchꞌ caꞌn pa ranimaꞌ, ma rique pachaꞌ e bexex e sachinak, quiquichom quib y na jinta chi chajinel que. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xubiꞌij cꞌu chique rutijoꞌn: «Pakatzij wi cambiꞌij chiwe: Ri molonic cajawax uꞌanic, lic nim; noꞌj raj chac na e qꞌui taj. ");
INSERT INTO acrTNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","E uwariꞌche, chitzꞌonoj che ri Dios, ri Rajaw ri molonic, chaꞌ quebutak lo aj chac chupa ruchac» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ecꞌu ri Jesús xebusiqꞌuij ri cablajuj utijoꞌn y xuya paquikꞌab quebequesaj bi itzelilaj uxlabixel y caquicunaj ronoje yabil y ronoje cꞌaxcꞌobic. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","E quibiꞌ tak waꞌ wa cablajuj e takoꞌn: Nabe e Simón ri cabiꞌx Pedro che y ruchakꞌ Andrés, Jacobo y ruchakꞌ Juan (wa caꞌib e ucꞌajol ri Zebedeo), ");
INSERT INTO acrTNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ri aj tzꞌonol puak re tojonic, Jacobo rucꞌajol ri Alfeo, Lebeo ri cabiꞌx Tadeo che, ");
INSERT INTO acrTNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón ri cabiꞌx che “ri Cananista”, qꞌuisbal re, e Judas aj Iscariot, ri xcꞌayin re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ri Jesús xebutak bi ri cablajuj y e pixabanic waꞌ xuya bi chique: «Mixꞌec pa tak ri luwar que ri na e ta aj judiꞌab, mixoc ne pa tak ri tinamit re Samaria. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jix cꞌu nabe cucꞌ ri bexex e sachinak, waꞌ e ri e aj judiꞌab re ri tinamit Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jix y jewaꞌ chitzijoj: “Rutakanic ri Dios petinak chilaꞌ chicaj xa nakaj chi cꞌo wulok.” ");
INSERT INTO acrTNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","»Chebicunaj conoje ri yewaꞌib cucꞌ tak ri cꞌo ri yabil lepra chique, chebicꞌastajisaj ri ecaminak y chebiwesaj bi itzel uxlabixel. Wa chukꞌab quicꞌul riꞌix e rutzil nucꞌuꞌx chiwe; jecꞌulaꞌ mitzꞌonoj rajil ri chac quiꞌan rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","»Micꞌam bi imeyo re oro, re plata o re cobre. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Micꞌam ne bi teb re ubitak iwe, micꞌam bi jun chic icoton, jun chic molaꞌj ixajab o jun chic ichꞌamiꞌy. Ma e junok cachacunic, lic takalic cayaꞌiꞌ janipa ri cajawax che. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","»Echiriꞌ quixopon pa juna tinamit o pa juna aldea, chitzucuj junok jusucꞌ ubinic usilabic y chixcanaj cꞌu can chirocho cꞌate quixel bi chiriꞌ echiriꞌ quixꞌec pa jun chic tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","»Echiriꞌ quixoc chuchiꞌ juna ja, chiyaꞌa rutzil quiwach ri e cꞌo chiriꞌ, quitzꞌonoj cꞌu ri utzil chomal re ri Dios paquiwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","We quixquicꞌul cꞌu ri e cꞌo pa ri ja, cacanaj ri utzil chomal itzꞌonom can paquiwiꞌ. Noꞌj we rique na quixquicꞌul taj, ri utzil chomal catzelej tanchi lo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","»We na quixquicꞌul taj y na cacaj tane caquita ri quitzijoj, chixelubi chupa ri ja o pa ri tinamit yey chipupaꞌ can rulew cꞌo che ri iwakan. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma pakatzij wi cambiꞌij chiwe: Chupa rukꞌijol ri kꞌatbal tzij, más lic cꞌax ri cape paquiwi ri tinamit na xquicꞌul ta ri Utzilaj Tzij, chwa ri cape paquiwi ri e aj Sodoma y ri e aj Gomorra. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","»Chitapeꞌ: Riꞌin quixintak bi pachaꞌ ix bexex chiquixoꞌl utiw. Lic chichajij cꞌu iwib chi utz jelaꞌ pachaꞌ ruꞌanic cuchajij rib ri cumatz, yey chiꞌana pachaꞌ ri palomax na jinta cꞌo cuꞌan che junok. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","»Lic chichajij cꞌu iwib chiquiwach ri winak, ma quixquicꞌam bi pa tak kꞌatbal tzij y caquijichꞌ ipa pa tak sinagogas. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wuma riꞌin, quixquicꞌam ne bi chiquiwach tak raj kꞌatal tzij y ri takanelab. Rucꞌ cꞌu riꞌ waꞌ, utz quikꞌalajisaj nuwach riꞌin chiquiwach rique y chiquiwach conoje tak ri tinamit che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ecꞌuchiriꞌ quixquiya chiquiwach, mubisoj icꞌuꞌx saꞌ ri quibiꞌij; ma echiriꞌ copon ruꞌorayil re quixchꞌaꞌtic, e ri Dios cayaꞌw lo ichꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma na ix ta ri quixchꞌaꞌtic, e ri Ruxlabixel Rikaw; e Rire cuya ichꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","»E tak cꞌu ri ticawex quequiya ri catz-quichakꞌ pa camic; ri cꞌo calcꞌoꞌal quequiya tak ri calcꞌoꞌal pa camic; ri calcꞌoꞌal queyactaj chiquij quichu-quikaw y quequiya pa camic. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tak ri winak lic tzel quixquil riꞌix xa ruma icojom ri nubiꞌ; noꞌj china cꞌu ri cuchukꞌubej rib cꞌa chupa ri qꞌuisbal re, e riꞌ ri cacolobetajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Echiriꞌ lic quixternabex rucꞌ cꞌaxcꞌobic pa juna tinamit, jix che jun chic. Ma pakatzij wi cambiꞌij chiwe, cꞌamajaꞌ ne quiqꞌuiso quixicꞌow chupa ronoje tak ri tinamit re Israel, echiriꞌ cacꞌun tanchi Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","»Na jinta juna tijoꞌn más cꞌo uwach chwa rutijonel y na jinta ne juna aj chac más cꞌo uwach chwa ri rajaw. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Juna tijoꞌn cubulok we xuꞌana jelaꞌ pachaꞌ rutijonel y juna aj chac cubulok we xuꞌana pachaꞌ ri rajaw. We cabiꞌx “Beelzebú” che ri quikaw racꞌalab, ¿macꞌuwariꞌ ri cabiꞌx chique ri ralcꞌoꞌal? ");
INSERT INTO acrTNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","»Mixiꞌij iwib chiquiwach ri winak. Ma copon ri kꞌij echiriꞌ janipa ri na kꞌalajisam taj, cakꞌalajisax na; yey janipa ri ewatalic, quetaꞌmaxic. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","E janipa ri cambiꞌij riꞌin xew chiwe riꞌix, chibiꞌij riꞌix chiwachil; yey ri canweswaꞌ riꞌin chiwe, chixsiqꞌuin che ubiꞌxiquil pa tak be. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","»Mixiꞌij iwib chiquiwach ri cꞌo paquikꞌab quixquicamisaj, ma waꞌ xew che ri cuerpo caquiꞌan wi, noꞌj na jinta paquikꞌab caquisach uwach rucꞌaslem junok chwach ri Dios. E chixiꞌij iwib chwach ri Jun cꞌo pukꞌab quebucꞌak bi ri ticawex junam rucꞌ ri quicuerpos y ri canimaꞌ, chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","»Iwetaꞌam, caꞌib raltak co tzꞌiquin quecꞌayix xa chwa jun ralco meyo. Na rucꞌ ta cꞌu riꞌ, na catzak tane junok chique pulew we ri Kakaw na cuya ta luwar. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Macꞌuwariꞌ riꞌix lic pukꞌab ix cꞌo wi, ma xa ne chujujunal riwiꞌ ajilam ruma Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","E uwariꞌche, mixiꞌij iwib; ma riꞌix más cꞌo iwach chiquiwach ri raltak co tzꞌiquin. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","»E junok cukꞌalajisaj chiquiwach ri winak, cubiꞌij: “In tijoꞌn re ri Jesús”; jecꞌuriꞌlaꞌ canꞌan riꞌin che rire, cambiꞌij chwach ri Nukaw cꞌo chilaꞌ chicaj: “Katzij, wa jun e nutijoꞌn” quinchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","»Noꞌj cꞌu ri cubiꞌij chiquiwach ri winak: “Riꞌin na in ta tijoꞌn re ri Jesús.” Jecꞌuriꞌlaꞌ canꞌan riꞌin che rire, cambiꞌij chwach ri Nukaw cꞌo chilaꞌ chicaj: “Katzij, wa jun na nutijoꞌn taj” quinchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","»Michꞌobo we ri nucꞌunic che ruwachulew cucꞌam lo utzil chomal. Na e ta riꞌ, ma e cucꞌam lo chꞌaꞌoj chiquixoꞌl tak ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ruma cꞌu ri nucꞌunic, ri ticawex caquijek quechꞌoꞌjin chiquiwach rala rucꞌ rukaw, rali rucꞌ ruchu y ralibatz rucꞌ ruchu-ralib. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ecꞌu riꞌ ri tzel quebilow re juna ticawex, e mismo ri e cꞌo pa rocho. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","»China ri más lic e cꞌax quebunaꞌ ruchu-ukaw chinuwach riꞌin, na takal ta che caterej chwij; jecꞌulaꞌ china ri más lic e cꞌax quebunaꞌ ri ralcꞌoꞌal chinuwach riꞌin, riꞌ na takal ta che caterej chwij. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","»China ri na caraj taj cutij cꞌax ruma e nutijoꞌn, riꞌ na takal ta che caterej chwij. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","China ri cutij ukꞌij lic quel chi utz rucꞌaslem wara che ruwachulew, riꞌ e cujam ri cꞌaslemal chilaꞌ chicaj; noꞌj ri cuya ranimaꞌ rucꞌaslem wuma riꞌin, riꞌ e curik ri chomilaj ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","»China ri cacꞌuluw iwe riꞌix, in ri quinucꞌulu; yey china ri cacꞌuluw we riꞌin, e cucꞌul ri Jun takayom lo we. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","China ri cacꞌuluw re juna kꞌalajisanel ruma e kꞌalajisay re rutzij ri Dios, ri rajil ucꞌaxel cucꞌulu e jelaꞌ pachaꞌ ri cucꞌul juna kꞌalajisanel. China ri cacꞌuluw re juna ticawex ruma jusucꞌ rubinic chwach ri Dios, ri rajil ucꞌaxel cucꞌulu e jelaꞌ pachaꞌ ri cucꞌul ri jusucꞌ ubinic usilabic chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","China cꞌu ri cusipaj tob xa juna tzima yaꞌ joron che junok chique waꞌ wa chꞌutiꞌk ruma e nutijoꞌn, pakatzij wi cambiꞌij chiwe, riꞌ na cujam ta cꞌana ri rajil ucꞌaxel» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Echiriꞌ ri Jesús xuqꞌuis quipixabaxic ri cablajuj utijoꞌn, xel bi chiriꞌ re cacꞌutunic y re cutzijoj Ruchꞌaꞌtem ri Dios chupa tak ri quitinamit rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri Juan cꞌo pa cárcel echiriꞌ xuta ri cuꞌan ri Cristo. Xebutak cꞌu lo caꞌib chique rutijoꞌn rucꞌ Rire, ");
INSERT INTO acrTNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chaꞌ queꞌquitzꞌonoj che: —¿E rilal Ruchaꞌoꞌn lo ri Dios, ri Jun biꞌtal chic cacꞌunic, o cakoyꞌej chi junok chic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ri Jesús xucꞌul uwach: —Jix y chitzijoj che ri Juan ronoje wa quixtajin che utayic y che rilic. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma ri e potzꞌ quetzuꞌnic, ri e sic quebinic, ri cꞌo yabil lepra chique quecunutajic, ri e tꞌoꞌc quetanic, ri ecaminak quecꞌastajic y chique ri nibaꞌib catzijox ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nim ukꞌij ralaxic cꞌu riꞌ ri na casach ta ri cubulibal ucꞌuꞌx wucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ecꞌuchiriꞌ xebec rique, ri Jesús xujek cachꞌaꞌt puwi ri Juan chique ri winak, jewaꞌ xubiꞌij: «¿Saꞌ ri xeꞌila alak pa ri luwar catzꞌintzꞌotic? ¿Xeꞌila neba alak jun achi na jinta ucowil xa pachaꞌ tani cajabajoꞌx ruma ri tew? ");
INSERT INTO acrTNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Saꞌ ri xeꞌila alak? ¿Xeꞌila neba alak jun achi uwikom rib rucꞌ chomilaj cꞌul? Na e ta riꞌ, ma etaꞌam alak ri lic quewikikic, riꞌ pa cocho e aj wach ejekel wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Cantzꞌonoj cꞌu riꞌ: ¿Saꞌ ri xeꞌila alak? ¿Xeꞌila alak jun kꞌalajisanel? Areꞌ, yey pakatzij wi cambiꞌij che alak: Rire e más cꞌo uwach chiquiwa ri jujun chic kꞌalajisanelab. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ma jewaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios puwi ri Juan: Riꞌin cannabesaj bi ri waj chac chawach Riꞌat chaꞌ cuyijbaꞌ ri be chwach pan rawoponibal cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","»Pakatzij wi cambiꞌij che alak: Na jinta junok chique ri ticawex ebalaxinak wara che ruwachulew más cꞌo uwach chwa ri Juan Aj Yaꞌl Bautismo. Pero chwi cꞌu riꞌ waꞌ wa queꞌec, china ri coc chupa rutakanic ri Dios petinak chilaꞌ chicaj, tob na jinta uwach, más nim ukꞌij ralaxic chwa ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","»Rucꞌ ri Juan Aj Yaꞌl Bautismo xjek lo utzijoxic ri Utzilaj Tzij puwi rutakanic ri Dios petinak chilaꞌ chicaj, y waꞌ cꞌa catajin utzijoxic wakꞌij ora, tob e cꞌo ri caquitij ukꞌij caquikꞌatej waꞌ. Na rucꞌ ta cꞌu riꞌ, e ri lic caquitij ukꞌij caquitzucuj wa takanic, cayaꞌtaj chique queboc chupa. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ma lic chwach pana echiriꞌ xujek catzijon ri Juan, ri kꞌalajisanelab y ri Moisés quitzꞌibam chi lo chupa ri Tzij Pixab chwi rucꞌunibal rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","We quiwaj cꞌu riꞌix quicojo, ri Juan e ri Elías, ri jun biꞌtal chic cacꞌunic. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","»¿China cꞌu rucꞌ canjunimaj wi quiwach wa winak re wakꞌij ora? E canjunimaj cucꞌ ri cꞌoꞌmab quebeꞌtzꞌula pa cꞌayibal y lic quesiqꞌuin chiquiwach, ");
INSERT INTO acrTNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","caquibiꞌij: Echiriꞌ riꞌoj xkachꞌawisaj suꞌ chiwe, riꞌix na xiwaj taj quix-xajawic; yey echiriꞌ xkatunaj bix bisobal uwach chiwe, na xiwaj taj quixjuyuyic quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","»Jecꞌulaꞌ caquiꞌan tak ri winak, ma echiriꞌ xcꞌun ri Juan Aj Yaꞌl Bautismo, rire lic cuꞌan ayuno y na cutij tane vino. Yey ri winak caquibiꞌij: “Waꞌ waꞌchi cꞌo pukꞌab jun itzel uxlabixel” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","»Xcꞌun cꞌu lo Ralaxel Chiquixoꞌl Ticawex. Rire cutij ronoje ri cayaꞌ chwach, yey tak ri winak caquibiꞌij: “Waꞌ wa jun achi lic japjatel y kꞌabaꞌrel, cachbiꞌil raj tzꞌonol puak re tojonic y raj maquib” quechaꞌ. Noꞌj cakꞌalajin na cꞌut china tak ri lic cꞌo runaꞌoj ri Dios cucꞌ ruma ri quiꞌanom» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ecꞌuchiriꞌ, ri Jesús lic xebuyaj ri winak re tak ri tinamit pa uꞌanom wi uqꞌuiyal milagros, ma rique na xquitzelej ta quitzij chwach ri Dios. Jecꞌuwaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«¡Lic tokꞌoꞌ iwach ri ix aj Corazín! ¡Lic tokꞌoꞌ iwach ri ix aj Betsaida! Ma we ta chupa ri tinamit Tiro y ri tinamit Sidón xilitaj wi wa cꞌutubal re ruchukꞌab ri Dios xinꞌan chiwach riꞌix, cꞌo tan kꞌij ta lo riꞌ xquitzelej quitzij chwach ri Dios, quicojom chi cꞌu quikꞌuꞌ cꞌax rij y quitzꞌuyubam quib pa chaaj ruma ri quibis. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E uwariꞌche cambiꞌij chiwe: Echiriꞌ copon ri kꞌij re ri kꞌatbal tzij, más nim ri cꞌaxcꞌobic cape piwi riꞌix chwa ri cꞌaxcꞌobic cape paquiwi ri winak re ri tinamit Tiro y ri tinamit Sidón. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","»Yey ri ix aj Capernaúm, e chiwach riꞌix lic yacom chi ikꞌij cꞌa chicaj; yey na e ta riꞌ, ma lic cacꞌak ne bi ikꞌij y quixcꞌak ne bi cꞌa chi xibalbaꞌ re tijbal cꞌax. Ma we ta pa ri tinamit Sodoma xilitaj wi wa milagros xinꞌan chiwach riꞌix ix aj Capernaúm, riꞌ laꞌ la tinamit cꞌa cꞌo tane woꞌora. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ecꞌu cambiꞌij waꞌ chiwe: Pa ri kꞌij re ri kꞌatbal tzij, lic nim ri cꞌaxcꞌobic cape piwi riꞌix chwa ri xpe paquiwi ri winak re ri tinamit Sodoma» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ecꞌu laꞌ la jokꞌotaj ri Jesús xuꞌan orar chwach Rukaw, jewaꞌ xubiꞌij: «Nukaw, canyac kꞌij la, Lal Rajaw ruwa caj y ruwachulew, ma ri kꞌalajisam la chique ri lic caquiꞌan chꞌutiꞌn che quib, waꞌ ewam la chiquiwach ri lic cꞌo quinaꞌoj y lic cꞌo quimajom. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jelaꞌ xꞌan la, Nukaw, ma e xꞌaj la riꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tecꞌuchiriꞌ, xubiꞌij chique ri ticawex: «Ronoje tak ri cꞌolic yaꞌtal lo panukꞌab ruma ri Nukaw. Na jinta cꞌu junok lic umajom usucꞌ chi utz saꞌ ruwach Rucꞌajol ri Dios, xew ri Kakaw Dios etaꞌmayom re. Y na jinta ne junok umajom usucꞌ chi utz saꞌ ruwach ri Kakaw Dios, xew Rucꞌajol ri Dios etaꞌmayom re; yey pukꞌab cꞌu riꞌ Rucꞌajol cꞌo wi china chique caraj cukꞌalajisaj wi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","»Chixpeta wucꞌ, iwonoje ri ix cosinak y cꞌo iwekaꞌn, ma riꞌin canya uxlanem chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chiyaꞌa iwib chuxeꞌ ri nuyucu cancoj riꞌin chiwe. Chimaja cꞌu iweꞌix chwij, ma riꞌin utz nucꞌuꞌx y na canꞌan ta nim che wib chiwach. We quiꞌan cꞌu riꞌ waꞌ, quirik na ri utzil chomal piwanimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma ri nuyucu riꞌin, na cꞌayew ta rucꞌaxic bi y ri ekaꞌn canya bi chiwe na al taj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chupa tak cꞌu riꞌ laꞌ la kꞌij pa jun kꞌij re uxlanibal, ri Jesús cucꞌ rutijoꞌn e riꞌ quebicꞌow pa tak ticoꞌn re trigo. Ecꞌu rutijoꞌn, ruma lic quenumic, xquijek caquichꞌupilaꞌ bi ri trigo; tecꞌuchiriꞌ, caquikil rucꞌ ri quikꞌab y caquitijo. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Echiriꞌ ri fariseos xquil waꞌ, xquibiꞌij che ri Jesús: —Chilape la, ri e tijoꞌn la caquiꞌan ri na takal taj caꞌaniꞌ chupa ri kꞌij re uxlanibal —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ecꞌu ri Jesús xucꞌul uwach: —¿Na ajilam ta neba alak ri xuꞌan ri David julaj echiriꞌ rire cucꞌ ri rachbiꞌil xenumic? ");
INSERT INTO acrTNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xoc cꞌu chupa ri Rocho Dios y junam cucꞌ ri rachbiꞌil xquitij ri pam yaꞌtal chi pukꞌab ri Dios; tob na takal ta chique rique caquitijo, ma waꞌ xew takal chique raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","»¿Na iwajilam ta neba ri tzꞌibital can ruma ri Moisés chupa ri Tzij Pixab? Ma cubiꞌij e raj chacunel pa Rocho Dios na quebuxlan ta chupa ri kꞌij re uxlanibal; na rucꞌ ta cꞌu riꞌ, waꞌ na mac ta chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","»Cambiꞌij cꞌu riꞌin chiwe: Cꞌo jun wara más nim ukꞌij chwa ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","We ta riꞌix imajom usucꞌ saꞌ queꞌelawi ri cubiꞌij ri Dios chupa Ruchꞌaꞌtem: Ri lic cuaj Riꞌin chiwe e ri cꞌutubal re ri cꞌaxnaꞌbal cꞌuꞌxaj, na e ta ri cacamisax awaj re kasaꞌn chinuwach cachaꞌ; we ta cꞌu lic quimaj usucꞌ waꞌ, riꞌ na quikꞌat ta tzij paquiwi ri na jinta mac quiꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ma Ralaxel Chiquixoꞌl Ticawex e rajaw ri kꞌij re uxlanibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Echiriꞌ xel ri Jesús chiriꞌ, xoc chupa ri sinagoga re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Cꞌo cꞌu jun achi chiriꞌ chakijinak jun ukꞌab. Yey e tak ri lic caquitzucuj suꞌanic caquitzꞌak uchiꞌ ri Jesús, xquitzꞌonoj che: —¿Ube nawi cacunax juna yewaꞌ chupa ri kꞌij re uxlanibal? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ri Jesús xucꞌul uwach: —¿Cꞌo nawi junok che alak we pa ri kꞌij re uxlanibal tzakinak juna ubexex pa siwan, na queꞌresaj tulok? ");
INSERT INTO acrTNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿China cꞌu ri más cꞌo uwach, e rachi o e ri bexex? Ruma cꞌu riꞌ, takalic caꞌan ri utz chupa ri kꞌij re uxlanibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ecꞌuchiriꞌ, xubiꞌij ri Jesús che rachi chakijinak ukꞌab: —Chasucꞌupij rakꞌab —xchaꞌ. Ecꞌu rachi xuyuk rukꞌab y waꞌ xutziric, rukꞌab xuꞌan tanchi jelaꞌ pachaꞌ ri jun chic. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Xebel cꞌu bi ri fariseos y xquichꞌaꞌtibej chiquiwach suꞌanic caquisach uwach ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús retaꞌam saꞌ ri cacaj caquiꞌan che; ruma cꞌu laꞌ, xel bi chiriꞌ y lic e qꞌui ri winak xeterej bi chirij. Ecꞌu Rire xebucunaj conoje ri yewaꞌib ");
INSERT INTO acrTNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yey lic xebupixabaj chaꞌ na caquikꞌalajisaj taj china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Xuꞌan tak waꞌ chaꞌ e xuꞌana rubiꞌim ri Dios ruma ri kꞌalajisanel Isaías: ");
INSERT INTO acrTNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","E waj chac waꞌ, ri Jun nuchaꞌom lok. Riꞌin lic cꞌax cannaꞌo y lic quinquiꞌcot rucꞌ. Canya cꞌu ri Wuxlabixel puwi Rire chaꞌ cutzijoj ri lic usucꞌ canꞌan Riꞌin chiquiwach conoje tak ri tinamit che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na rucꞌ ta yaj, na rucꞌ ta sicꞌ cuꞌan waꞌ; Na jinta cꞌu junok riꞌ cataw re cayajanic o casiqꞌuin pa tak be. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yey Rire na cusach tane uwach ri xa chꞌitil chic. E pachaꞌ junok na queꞌec ta che ukꞌepic juna suꞌ cotoquic y na cuyubij tane juna mecha xa cabutzutz chic; ma cucꞌut ri rutzil ucꞌuꞌx chique tak ri paxinak quicꞌuꞌx y ri na jinta chi quichukꞌab. Jecꞌuriꞌlaꞌ cuꞌano copon na ri kꞌij echiriꞌ na jinta chi junok cachꞌijow uchukꞌab ri lic usucꞌ canꞌan Riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Conoje tak cꞌu riꞌ ri tinamit che ruwachulew lic caquicubaꞌ pan quicꞌuꞌx rucꞌ Rire xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ecꞌuchiriꞌ, xquicꞌam bi chwach ri Jesús jun achi potzꞌ y meꞌt yey cꞌo pukꞌab jun itzel uxlabixel. Ecꞌu ri Jesús xucunaj y jecꞌulaꞌ waꞌchi xtzuꞌnic y xujek cachꞌaꞌtic. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Conoje cꞌu ri winak lic xcam canimaꞌ che y xquibiꞌij: «¿Cꞌaxtaj e rire ri Ralcꞌoꞌal can ri rey David?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ecꞌu ri fariseos echiriꞌ xquita waꞌ, xquibiꞌij: «Waꞌ wa jun achi queberesaj bi ri itzel uxlabixel ruma ruchukꞌab ri Beelzebú, ri cajawal ri itzel uxlabixel» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ri Jesús retaꞌam saꞌ ri caquichꞌobo; ruma cꞌu riꞌ, xubiꞌij chique: «We ri takanelab re juna tinamit quijachom quipa ruma quechꞌoꞌjin chiquiwach, riꞌ na canajtir ta ri quitakanic. Yey we ri ejekelel pa juna tinamit o pa juna ja quijachom quipa ruma quechꞌoꞌjin chiquiwach, riꞌ na quetiquiꞌ ta chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jecꞌulaꞌ, we ta ri Satanás caresaj bi ri Satanás chique ri winak, riꞌ e pachaꞌ cachꞌoꞌjin chiribil rib y utuquel cujach upa rutakanic. ¿Saꞌ cꞌu uꞌanic riꞌ canajtir rutakanic? ");
INSERT INTO acrTNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","»Ralak cabiꞌij alak riꞌin quebenuwesaj bi tak ri itzel uxlabixel rucꞌ ruchukꞌab ri Beelzebú. We ta e riꞌ, ¿china cꞌu cayaꞌw quichukꞌab riꞌ ri e tijoꞌn alak chaꞌ quequesaj bi tak ri itzel uxlabixel? ¿Rucꞌ nawi ruchukꞌab ritzel winak caquiꞌano? Tzꞌonoj cꞌu alak riꞌ chique ri e tijoꞌn alak we e uꞌanom riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero we riꞌin quebenuwesaj bi tak ri itzel uxlabixel rucꞌ ruchukꞌab ri Ruxlabixel ri Dios, waꞌ e cꞌutubal re cꞌuninak chi rutakanic ri Dios chixoꞌlibal alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","»Tape alak: ¿Suꞌanic coc juna elekꞌom pa rocho junok lic cꞌo uchukꞌab yey carelekꞌaj cꞌu lo rubitak re pa ja, we na cuyut ta nabe ri rajaw ja? Ma we relekꞌom uyutum chi ri rajaw ja, cꞌa ecꞌuchiriꞌ utz carelekꞌaj bi ronoje la cꞌo pa ri ja. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","»China cꞌu ri na uꞌanom ta re wucꞌ riꞌin, riꞌ aj chꞌaꞌoj chwij. Yey china ri na catoꞌb ta wucꞌ riꞌin che quicꞌamic lo jujun chic, riꞌ e cuwulij wa chac canꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","»E uwariꞌche cambiꞌij che alak: Cꞌo pukꞌab ri Dios cucuy ronoje tak ri mac que ri ticawex rucꞌ ronoje tak ri na utz taj caquibiꞌij, noꞌj na cucuy ta umac ri cachꞌaꞌt chirij ri Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","China ri tzel cachꞌaꞌt chirij Ralaxel Chiquixoꞌl Ticawex, riꞌ cacuytaj umac we cutzelej utzij. Noꞌj ri tzel cachꞌaꞌt chirij ri Santowilaj Ruxlabixel ri Dios, riꞌ na cacuytaj ta cꞌana umac che waꞌ wa kꞌij oj cꞌo wi y na cacuytaj tane cꞌana umac tob ne che rukꞌijol ri cꞌaslemal catajin lok. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","»E juna chomilaj cheꞌ, lic chom rujikꞌobalil cuyaꞌo; yey ri cheꞌ na chom taj, na chom ta rujikꞌobalil cuyaꞌo. Ma ri cheꞌ quetaꞌmax uwach ruma rujikꞌobalil. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ralak pachaꞌ alak jupuk chi cumatz! ¿Suꞌanic cꞌu riꞌ cachꞌaꞌtibej alak ri utz we itzel cꞌuꞌx alak? Ma rucꞌ ruchꞌaꞌtem ri ticawex cakꞌalajin ronoje ri ucꞌolom chupa ri ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jecꞌulaꞌ e junok utz ucꞌuꞌx, echiriꞌ cachꞌaꞌtic, e caresaj lo ri chom ucꞌolom chupa ri ranimaꞌ. Yey e junok itzel ucꞌuꞌx, echiriꞌ cachꞌaꞌtic, e caresaj lo ri na chom taj ucꞌolom chupa ri ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","»Riꞌin cambiꞌij cꞌu che alak: Chupa ri kꞌij re ri kꞌatbal tzij, chiquijujunal ri ticawex cataꞌ quichiꞌ ruma ronoje ri chꞌulilaj chꞌaꞌtem quel lo chwa queꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma chijujunal alak, we utz ri chꞌaꞌtem alak, riꞌ cakꞌalajinic alak jusucꞌ; noꞌj we na chom ta ri chꞌaꞌtem alak, riꞌ cakꞌat tzij pawiꞌ alak» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ecꞌuchiriꞌ, jujun chique ri fariseos y raj cꞌutunel re ri tzijpixab, xquibiꞌij che ri Jesús: —Lal tijonel, riꞌoj cakaj cakilo caꞌan la juna cꞌutubal re ri chukꞌab la chikawach —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri Jesús xucꞌul uwach: —Ri caquitzꞌonoj cꞌutubal re ruchukꞌab ri Dios e ri winak re wakꞌij ora, ri itzel quicꞌuꞌx y na jusucꞌ ta ri canimaꞌ chwach ri Dios. Noꞌj na cayaꞌtaj ta cꞌu waꞌ chique, ma xew cayaꞌtaj ri cꞌutubal xꞌaniꞌ ojertan rucꞌ ri kꞌalajisanel Jonás. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ma jelaꞌ pachaꞌ ri Jonás xcꞌojiꞌ oxib kꞌij y oxib akꞌab chupa ri nimalaj car, jecꞌulaꞌ Ralaxel Chiquixoꞌl Ticawex oxib kꞌij y oxib akꞌab camukiꞌ pulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","»Ri winak aj Nínive re ojertan queyactaj chupa ri kꞌij re kꞌatbal tzij y caquicoj quimac ri ticawex re wakꞌij ora. Ma rique xquitzelej quitzij chwach ri Dios ruma ri tzijonic xuꞌan ri Jonás chiquiwach. Noꞌj ri ticawex re wakꞌij ora, cꞌo jun chiquixoꞌl más cꞌo uwach chwa ri Jonás, yey na queboc tane il che. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","»Jecꞌulaꞌ echiriꞌ copon ri kꞌij re ri kꞌatbal tzij, cayactaj lo ri reina re pa sur y cucoj quimac ri ticawex re wakꞌij ora. Ma rojertan lic naj petinak wi rire chaꞌ coluꞌxiquinaj runaꞌoj ri rey Salomón. Noꞌj ri ticawex re wakꞌij ora, cꞌo jun chiquixoꞌl más cꞌo uwach chwa ri Salomón, yey na queboc tane il che. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","»Echiriꞌ juna itzelilaj uxlabixel quel bi che juna ticawex, ri cuꞌano e casutin pa tak luwar catzꞌintzꞌotic, cutzucuj pa cajekiꞌ wi. Yey we na curik taj, ");
INSERT INTO acrTNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","cubiꞌij cꞌu chiribil rib: “Quintzelej pe chupa ri wocho pa xinel lo wi” cachaꞌ. Ecꞌuchiriꞌ coponic, cuꞌrika rachi pachaꞌ juna ja cꞌa jinta rajaw, mesom upa y yijbital chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Queꞌec cꞌut, quebuꞌcꞌama chi lo wukub rach itzelilaj uxlabixel más itzel quiwachlibal chwa rire; y conoje cꞌu riꞌ queboquic y quejekiꞌ chiriꞌ. Jecꞌuriꞌlaꞌ, rubinic rachi más cayojtaj chwa ri petinak lok. Ecꞌu caquicꞌulumaj waꞌ ri winak itzel quicꞌuꞌx wakꞌij ora —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ecꞌu ruchu y tak ruchakꞌ ri Jesús xecꞌun lok echiriꞌ Rire cꞌa cachꞌaꞌt ne cucꞌ ri winak. Xecꞌojiꞌ cꞌu lo pa be yey lic cacaj quechꞌaꞌt rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Cꞌo cꞌu jun xubiꞌij pan che ri Jesús: —Ri chu la y tak ri chakꞌ la e cꞌo pa be yey lic cacaj quechꞌaꞌt ucꞌ la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ecꞌu ri Jesús xubiꞌij che ri xbiꞌn pan che: —Chawach riꞌat, ¿china cꞌu ri nuchu y china tak ri nuchakꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ecꞌuchiriꞌ, rucꞌ rukꞌab xebucꞌut rutijoꞌn y xubiꞌij: —Wa e cꞌo wara e nuchu y e tak nuchakꞌ riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ma china ri cuꞌan janipa ri caraj ri Nukaw cꞌo chilaꞌ chicaj, waꞌ e nuchakꞌ, e wanab y e nuchu riꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupa laꞌ la kꞌij, ri Jesús xel bi pa ri ja y xeꞌtzꞌula chuchiꞌ ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y uqꞌuiyal winak cꞌut xemolotaj chiriꞌ pa cꞌo wi Rire. Ruma laꞌ, ri Jesús xoc chupa jun barco, xtzꞌuyiꞌ chupa y conoje ri winak xecanaj can chuchiꞌ ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yey Rire xujek uyaꞌic uqꞌuiyal cꞌutunic chiquiwach rucꞌ tak cꞌambal naꞌoj, jewaꞌ xubiꞌij chique: «Jun awanel xel bi chaꞌ queꞌawanok. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ecꞌuchiriꞌ catajin che ujopopexic rijaꞌ, cꞌo xtzak can chuchiꞌ ri be. Xecꞌun cꞌu lo tzꞌiquin y xoꞌlquitija bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","»Cꞌo ijaꞌ xtzak can pa tak abaj; yey ruma na jinta uqꞌuiyal ulew chuxeꞌ, xel tan lo rijaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ecꞌuchiriꞌ xel lo ri kꞌij, xcꞌatic; yey ruma na jinta ratzꞌayak, xchakijic. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","»Cꞌo ijaꞌ xtzak can pa tak qꞌuix. Ecꞌu ri qꞌuix xqꞌuiyic yey rijaꞌ xjikꞌ can chuxeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","»Noꞌj cꞌo ijaꞌ xtzak can pa chomilaj ulew. Ecꞌu riꞌ waꞌ lic xuꞌan rekaꞌn. Cꞌo ne jujun rakan xuya jun ciento, cꞌo jujun chic xuya sesenta y cꞌo xuya treinta. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ecꞌu rutijoꞌn xekib rucꞌ ri Jesús y xquitzꞌonoj che: —¿Suꞌbe cacꞌutun la chiquiwach ri winak rucꞌ tak cꞌambal naꞌoj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xucꞌul uwach: —Chiwe riꞌix yaꞌtalic cakꞌalajisax runaꞌoj ri Dios chwi rutakanic petinak chilaꞌ chicaj; noꞌj chique tak ri winak, na yaꞌtal taj. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma china ri cꞌo umajom chic, riꞌ cayaꞌtaj ne che chaꞌ más cꞌo cumajo. Noꞌj china ri na jinta cꞌo umajom, camaj ne che ri cuchꞌobo umajom chic. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ruma laꞌ quinchꞌaꞌt cucꞌ rique xa rucꞌ tak cꞌambal naꞌoj. Ma tob rique quetzuꞌnic, e junam rucꞌ na quetzuꞌn taj; tob quetanic, e junam rucꞌ na quetan taj y e riꞌ na jinta cꞌo caquimaj usucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ma ri quicꞌulumam rique e cuꞌana pachaꞌ rubiꞌim can ri Dios ruma ri kꞌalajisanel Isaías: Riꞌix tob quixtanic, na jinta cꞌo quimaj usucꞌ che ri quito; y tob ne quixtzuꞌnic, na jinta cꞌo quimaj usucꞌ che ri quiwilo. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma wa tinamit lic uꞌanom co ri canimaꞌ; e pachaꞌ lic cꞌayew chique quetanic, y ri quiwach e pachaꞌ yupulic. Jecꞌulaꞌ na jinta cꞌo caquilo, na jinta cꞌo caquito y na jinta cꞌo caquimaj usucꞌ; yey na caquitzelej tane quitzij chinuwach chaꞌ jelaꞌ quebenucunaj xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","»Noꞌj riꞌix lic nim ikꞌij iwalaxic, ma ri Dios cuya chiwe quiwilo y quita janipa ri cuꞌan Rire wuma riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Pakatzij wi cambiꞌij chiwe: Ojertan uqꞌuiyal kꞌalajisanelab y ticawex jusucꞌ quibinic quisilabic lic xcaj caquil bi janipa ri quiwil riꞌix woꞌora; pero na xquimaj ta chi rilic bi. Lic xcaj caquita bi janipa ri quita riꞌix woꞌora, pero na xquimaj ta chi utayic bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","»Chita cꞌut saꞌ queꞌelawi ri cꞌambal naꞌoj puwi ri awanel. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Rijaꞌ xtzak can chuchiꞌ ri be, e pachaꞌ ri ticawex quetaw re ri chꞌaꞌtem chwi rutakanic ri Dios yey na caquimaj ta usucꞌ. Cacꞌun cꞌu lo ritzel winak y caresaj bi ri chꞌaꞌtem xtiquiꞌ pa canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","»Rijaꞌ xtzak can pa tak abaj, e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios y caquicoj rucꞌ quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ruma na e tiquil ta chi utz, na quecowin taj. Ma echiriꞌ cacꞌun lo cꞌambal quipa o queternabex rucꞌ cꞌax ruma quicꞌulum Ruchꞌaꞌtem ri Dios, quepajtaj cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","»Rijaꞌ xtzak can pa tak qꞌuix e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios. Pero rubis quicꞌuꞌx chwi tak ri cajawax chique, rucꞌ ri socosoꞌnic re tak ri beyomalil, cusachisaj uwach Ruchꞌaꞌtem ri Dios cꞌo pa canimaꞌ. Ruma cꞌu riꞌ, na jinta cꞌana quijikꞌobalil quilitaj che ri quibinic. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","»Noꞌj rijaꞌ xtzak can pa chomilaj ulew e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios, lic caquimaj usucꞌ y lic cꞌo cꞌu quijikꞌobalil quilitaj che ri quibinic. E jelaꞌ pachaꞌ rijaꞌ lic xuꞌan rekaꞌn; cꞌo ne jujun rakan xuya jun ciento, cꞌo jujun chic xuya sesenta y cꞌo xuya treinta —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xutzijoj tanchi jun cꞌambal naꞌoj chique: «Ri cuꞌana pa rutakanic ri Dios petinak chilaꞌ chicaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ jun achi xutic chomilaj ijaꞌ trigo chwa ri rulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ecꞌuchiriꞌ quewar conoje ri ticawex, xopon jun achi tzel caril ri rajaw rulew; xeꞌlakꞌay cꞌu riꞌ xutic can rakꞌes cizaña chuxoꞌl ri trigo y xeꞌec cꞌut. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Xel cꞌu lo ri trigo y echiriꞌ xpokꞌic, xkꞌalajin rakꞌes cꞌo chupa. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ecꞌu ri aj chaquib xeꞌquibiꞌij che ri rajaw ri ticoꞌn: “Kajawal, we chomilaj ijaꞌ xeꞌtica la chwa rulew la, ¿pachawi cꞌu riꞌ xpe wi rakꞌes xel lo chupa?” ");
INSERT INTO acrTNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","»Yey ri rajaw ri ticoꞌn xubiꞌij chique: “Cꞌo junok laꞌ tzel quinrilo xoluꞌtica chupa.” Xquibiꞌij cꞌu ri raj chaquib che: “We caꞌaj la, queꞌkamichꞌa ronoje rakꞌes chupa.” ");
INSERT INTO acrTNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","»Ecꞌu ri rajaw ri ticoꞌn xubiꞌij chique: “Na quiꞌmichꞌa taj; ma we ximichꞌ rakꞌes, cꞌaxtaj quimichꞌ ri trigo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chiyaꞌa luwar cheqꞌuiy na junam, copon na rukꞌijol ri molonic. Ma cꞌa e chiriꞌ quebenutak ri waj chac chaꞌ caquimol na rakꞌes nabe, caquiꞌan chiyataꞌj y caquixim upa re caporoxic. Tecꞌuchiriꞌ, caquimol ri trigo y queꞌquiyaꞌa pa cacꞌoliꞌ wi ri trigo weꞌin”» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xutzijoj tanchi jun cꞌambal naꞌoj chique: «Rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ juna ijaꞌ re moxtasa xutic jun achi chwa ri rulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Pakatzij wi, laꞌ liꞌjaꞌ e más chꞌutiꞌn chwa tak rijaꞌ; noꞌj we xqꞌuiyic, más canimar chwa tak rakꞌes y cuꞌana pachaꞌ jun cheꞌ. Quecꞌun ne ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj y caquiꞌan quisoc puwi tak rukꞌab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xutzijoj wa jun chic cꞌambal naꞌoj chique: «Rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ ri levadura. Ma echiriꞌ juna ixok cuꞌan pam, cucꞌam jubikꞌ levadura y cutuc chuxoꞌlibal oxib pajbal harina; yey ri levadura cusipowirisaj upa ronoje ri kꞌor» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ri Jesús xucꞌut ronoje waꞌ chique ri winak rucꞌ tak cꞌambal naꞌoj y na jinta cꞌo xucꞌutu we na rucꞌ ta cꞌambal naꞌoj xuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E xuꞌan waꞌ chaꞌ e cuꞌana rubiꞌim can ri jun kꞌalajisanel echiriꞌ xutzꞌibaj: Rucꞌ tak cꞌambal naꞌoj quincꞌutunic; e cankꞌalajisaj ri na etaꞌmatal ta chwi lo ri jekebal re ruwachulew xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ecꞌuchiriꞌ, ri Jesús xebuchꞌaꞌbej can ri winak y xoc bi pa ja. Xekib cꞌu rutijoꞌn rucꞌ y xquitzꞌonoj che: —Kajawal, kꞌalajisaj la chike saꞌ queꞌelawi ri cꞌambal naꞌoj puwi rakꞌes cizaña —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ecꞌu ri Jesús xucꞌul uwach: —Rachi caticow re ri chomilaj ijaꞌ e Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Rulew pa catic wi ri ticoꞌn e ruwachulew. Ri chomilaj ijaꞌ e tak ri ticawex e cꞌo chupa rutakanic ri Dios. Rijaꞌ re rakꞌes cizaña e tak ri ticawex eteran chirij ritzel winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri jun itzel ucꞌuꞌx xutic rakꞌes e ritzel winak. Ri molonic e ri qꞌuisbal re ruwachulew, yey ri queꞌanaw re ri molonic e ri ángeles. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","»Jecꞌulaꞌ pachaꞌ ri caꞌan che rakꞌes cizaña, camolic y caporox pa akꞌ, jelaꞌ ri cuꞌana che ri qꞌuisbal re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ralaxel Chiquixoꞌl Ticawex quebutak bi ru ángeles chaꞌ quequimolo y quequesaj chupa rutakanic conoje ri equiminom jujun chic pa mac y ri caquiꞌan ri na utz taj. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Quebequicꞌak bi pa ri orna cajomow akꞌ chupa; chiriꞌ cꞌu riꞌ quebokꞌ wi y cakichꞌichꞌ ruwi queꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noꞌj ri jusucꞌ quibinic quisilabic e jelaꞌ pachaꞌ ri kꞌij quewon chilaꞌ pa catakan wi ri quikaw Dios. China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ jun beyomalil ewatal can chupa juna ulew. Cꞌo cꞌu jun achi queꞌtzak lo puwiꞌ y carewaj tanchi canok. Queꞌec cꞌu chirocho y cuꞌcꞌayij ronoje rubitak re; tecꞌuchiriꞌ, culokꞌ ri ulew pa cꞌo wi ri beyomalil. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","»Rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ ri cuꞌan juna aj cꞌay cutzucuj tak chomilaj abaj perla. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ecꞌuchiriꞌ curik juna chomilaj perla lic qꞌui rajil, queꞌec y cuꞌcꞌayij ronoje rubitak re; tecꞌuchiriꞌ, culokꞌ ri chomilaj abaj perla. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","»Ri cuꞌan chupa rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ ri cuꞌano echiriꞌ cacꞌak bi juna atarraya pa ri mar chaꞌ quebuꞌchapa lo uqꞌuiyal quiwach tak car. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","»Echiriꞌ nojinak chi ri atarraya che car, raj chapal car caquesaj lo chuchiꞌ ri mar, quetzꞌuyiꞌ cꞌut y quequichaꞌ quipa ri car. E tak cꞌu ri utzilaj car, quequiya pa chacach; noꞌj tak cꞌu ri na e ta utz, quequicꞌak bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","»Jecꞌulaꞌ cuꞌana che ri qꞌuisbal re ruwachulew. Quebel bi ri ángeles y quequesaj cꞌu ri ticawex itzel quicꞌuꞌx chiquixoꞌl ri e jusucꞌ chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Quebequicꞌak cꞌu bi pa ri orna cajomow akꞌ chupa; chiriꞌ cꞌu riꞌ quebokꞌ wi y cakichꞌichꞌ ruwi queꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ecꞌuchiriꞌ, ri Jesús xutzꞌonoj chique: —¿Quimaj usucꞌ riꞌix ronoje tak waꞌ? —xchaꞌ. Rique xquicꞌul uwach che ri Jesús: —Cakamaj usucꞌ, Kajawal —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ecꞌu ri Jesús xubiꞌij chique: —E juna aj cꞌutunel re ri tzijpixab, we lic cꞌo cumaj chwi rutakanic ri Dios petinak chilaꞌ chicaj, e pachaꞌ juna achi rajaw ja caresaj lo che rubeyomalil ucꞌolom, tak ri cꞌacꞌ y ri xex chi cꞌo wi; yey ucabichal waꞌ cuchapabej. Ma ri aj cꞌutunel cacꞌutun chwi tak ri cꞌacꞌ umajom, junam rucꞌ tak ri xex chi umajom lok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ri Jesús echiriꞌ xuqꞌuis ubiꞌxic tak wa cꞌambal naꞌoj chique, xel bi chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Echiriꞌ xopon pa rutinamit, xujek cacꞌutun chiriꞌ pa ri sinagoga. Ecꞌu ri winak lic xcam canimaꞌ che y xquibiꞌij: —¿Pa xuꞌmaja wi waꞌchi luꞌnaꞌoj? ¿Suꞌanic cuꞌan tak wa milagros? ");
INSERT INTO acrTNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Na e ta neba ucꞌajol waꞌ ri jun carpintero yey ralab ri María? ¿Na e ta neba catzixel ri Jacobo, ri José, ri Simón y ri Judas? ");
INSERT INTO acrTNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Na ejekel ta neba ri ranab wara chikaxoꞌl? ¿Pa cꞌu xuꞌmaja wi ronoje tak riꞌ wa cuꞌano? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ewi lic e qꞌui tzel xquita ri xubiꞌij. Noꞌj ri Jesús xubiꞌij chique: —Chupa ronoje luwar cayac ukꞌij juna kꞌalajisanel; noꞌj chupa rutinamit o chiquiwach ri ratz-uchakꞌ, na cayac ta ukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y ri Jesús na xuꞌan ta uqꞌuiyal milagros chiriꞌ ruma na xquicoj taj china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupa cꞌu laꞌ la kꞌij, ri Herodes ri rey re Galilea xuta puwi ri chom uchꞌaꞌtibexic ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ri Herodes xubiꞌij cꞌu chique ri raj chaquib: «Laꞌ e Juan Aj Yaꞌl Bautismo xcꞌastaj lo chiquixoꞌl ri ecaminak; e uwariꞌche cꞌo uchukꞌab che uꞌanic wa milagros» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Xubiꞌij waꞌ ma e rire ri xutak uchapic ri Juan chaꞌ cayaꞌiꞌ pa carena y queyoꞌk pa cárcel. Xuꞌan waꞌ ri Herodes ma ri Juan xuchꞌaꞌbej upa ruma uꞌanom rixokil che ri Herodías, yey waꞌ wiꞌxok e rixokil ri Felipe ruchakꞌ ri Herodes. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jewaꞌ ri xubiꞌij ri Juan che: «Lic na ube taj ꞌanom ixokil la che ri rixokil ri chakꞌ la» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ruma cꞌu waꞌ ri Herodes lic xraj cucamisaj ri Juan, noꞌj lic cuxiꞌij rib chique ri tinamit ma chiquiwach rique ri Juan e jun kꞌalajisanel re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ecꞌuchiriꞌ xuqꞌuis ujunab ri Herodes, xꞌaniꞌ jun nimakꞌij. Ecꞌu ri ralit rixok Herodías xajaw chiquiwach ri esiqꞌuim pa ri nimakꞌij, y waꞌ lic xucꞌul ucꞌuꞌx ri Herodes. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ruma cꞌu riꞌ, xubiꞌtisij cuya che rali tob saꞌ ri caraj cutzꞌonoj, y lic xujiquibaꞌ uwach cuꞌan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ecꞌu rali nabe na xuꞌtzꞌonoj che ruchu y waꞌ xuya lo itzel naꞌoj che. Xubiꞌij cꞌu rali che ri Herodes: «Yaꞌa la rujolom ri Juan Aj Yaꞌl Bautismo chwe pa juna plato» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ri rey lic xbisonic ruma ri xtzꞌonox che. Noꞌj ruma cꞌu ri xujiquibaꞌ uwach che rali chiquiwach conoje ri e cꞌo rucꞌ pa ri waꞌim, xtakan cꞌu che chaꞌ cayaꞌiꞌ na che rali ri cutzꞌonoj. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xtakan cꞌu che cacꞌatzix rujolom ri Juan pa ri cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jelaꞌ xcꞌam lo rujolom ri Juan pa jun plato, xyaꞌ cꞌu che rali y rali xuꞌyaꞌa che ruchu. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tecꞌuchiriꞌ, rutijoꞌn ri Juan xoꞌlquicꞌama rucuerpo y xeꞌquimukuꞌ. Xebec cꞌut, xeꞌquibiꞌij che ri Jesús saꞌ ri xucꞌulumaj ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Echiriꞌ ri Jesús xretaꞌmaj puwi rucamic ri Juan, xoc bi pa jun barco re queꞌec pa jun luwar catzꞌintzꞌotic pa na e jinta wi winak. Yey ri winak echiriꞌ xquetaꞌmaj, xebel lo pa tak ri tinamit y chakan xebec chaꞌ coꞌlquirika ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Echiriꞌ ri Jesús xel lo pa ri barco, xrilo e cꞌo chi uqꞌuiyal winak chiriꞌ. Lic cꞌut xejuchꞌ caꞌn pa ranimaꞌ y xebucunaj conoje ri e yewaꞌib chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ecꞌuchiriꞌ ya coc rakꞌab, rutijoꞌn ri Jesús xekib rucꞌ y xquibiꞌij che: —Kajawal, wa luwar oj cꞌo wi lic catzꞌintzꞌotic y benak kꞌij chic. Utz we quetak bi la ri winak chaꞌ quebec pa tak raldeas re queꞌquilokꞌo quiwa —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Noꞌj ri Jesús xubiꞌij chique: —Na cajawax taj quebec; chebitzuku riꞌix —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rique xquibiꞌij che ri Jesús: —Na qꞌui ta ri waꞌim kucꞌaꞌam, xew woꞌob pam y caꞌib car cꞌo kucꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Xubiꞌij cꞌu ri Jesús chique: —Chicꞌama lo laꞌ chwe —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ecꞌuchiriꞌ, xtakan che quetzꞌuyiꞌ ri winak pa tak ri qꞌuim. Xucꞌam cꞌu ri woꞌob pam rucꞌ ri caꞌib car, xtzuꞌn chicaj y xtioxin chwach ri Dios. Tecꞌuchiriꞌ, xuwechꞌ upa ri pam, xuya chique rutijoꞌn y rique xquijach chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Conoje cꞌu ri winak xewaꞌic y xenoj chi utz. Tecꞌuchiriꞌ, xquimol ri chꞌakaꞌtaꞌk quikax y rucꞌ waꞌ xnoj lo cablajuj chacach. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ri xewaꞌic laj e lo woꞌob mil chi achijab yey na xebajilax tane rixokib y racꞌalab. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tecꞌuchiriꞌ, ri Jesús xebutak rutijoꞌn chaꞌ queboc bi chupa ri barco, quenabej bi chwach y quekꞌax cꞌa chꞌaka yaꞌ xalokꞌ Rire quebuchꞌaꞌbej tak can ruqꞌuiyal winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Echiriꞌ ebuchꞌaꞌbem chi canok, xpakiꞌ chwa ri juyub chaꞌ cuꞌana orar. Xoc cꞌu rakꞌab, y ri Jesús utuquel cꞌo chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ecꞌu ri barco pa ebenak wi rutijoꞌn cꞌo chi pan chunicꞌajal ri mar, yey cꞌo cꞌu jun cakjikꞌ lic curoj rib che ri barco, ma waꞌ pube ri cakjikꞌ benak wi. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lic anim tan cꞌut, ri Jesús xeꞌec cucꞌ rutijoꞌn, e riꞌ cabin chwi ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Rutijoꞌn echiriꞌ xquilo cabin ri Jesús chwi ri mar, lic xsach quinaꞌoj che, xesiqꞌuin cꞌu rucꞌ xiꞌin ib: —¡Leꞌ jun espíritu! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ecꞌu ri Jesús xchꞌaw chique, jewaꞌ xubiꞌij: —Chinimarisaj icꞌuꞌx, ma riꞌin in Jesús; mixiꞌij cꞌu iwib —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ecꞌuchiriꞌ, xchꞌaw pan ri Pedro che, jewaꞌ xubiꞌij: —Wajawal, we katzij e rilal, biꞌij la chwe quinꞌec ucꞌ la, e laꞌ quimbin chwi ri mar cꞌa pa cꞌo wi la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri Jesús xubiꞌij che: —Chatpeta riꞌ —xchaꞌ. Ecꞌuchiriꞌ ri Pedro xel bi pa ri barco, xujeko cabin chwi ri mar chaꞌ queꞌec pa cꞌo wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero echiriꞌ xril ruchukꞌab ri cakjikꞌ, xoc xiꞌin ib rucꞌ y xujek e riꞌ camukutajic. Xsiqꞌuin cꞌu pan riꞌ che ri Jesús, jewaꞌ xubiꞌij: —¡Chincolobej la, Wajawal! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na jampatana ri Jesús xuchapalaꞌ pan che rukꞌab y xubiꞌij che: —Pedro, ¡na nim ta cꞌana ri cubulibal acꞌuꞌx wucꞌ! ¿Suꞌbe xuxiꞌij rib acꞌuꞌx? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Echiriꞌ ri Jesús y ri Pedro xeboc chupa ri barco, xtaniꞌ ri cakjikꞌ chwi ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ecꞌuchiriꞌ, ri e cꞌo pa ri barco xekib rucꞌ ri Jesús y xquilokꞌnimaj ukꞌij, jewaꞌ xquibiꞌij: —Pakatzij wi lal Ucꞌajol ri Dios —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Echiriꞌ xekꞌax chꞌaka yaꞌ, xebopon pa ri luwar re Genesaret. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri winak, echiriꞌ xquito cꞌo ri Jesús chiriꞌ, xquitak ubiꞌxiquil pa tak ronoje laꞌ la luwar. Xequicꞌam cꞌu lo conoje ri yewaꞌib pa cꞌo wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lic xebelaj cꞌu che ri Jesús chaꞌ cuya luwar chique tob xew caquichap ruchiꞌ rukꞌuꞌ. Conoje cꞌu ri xebanaw waꞌ, xecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ecꞌuchiriꞌ, jujun chique ri fariseos y raj cꞌutunel re ri tzijpixab e petinak Jerusalem, xekib rucꞌ ri Jesús y xquitzꞌonoj che: ");
INSERT INTO acrTNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Suꞌchac ri tijoꞌn la caquipalajij ri quicꞌutuꞌn can ri katiꞌ-kamam? Ma rique na caquichꞌaj ta ri quikꞌab nabe na echiriꞌ quewaꞌic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ecꞌu ri Jesús xutzꞌonoj chique: —¿Suꞌchac ralak capalajij alak Rutzij Upixab ri Dios ruma e caꞌan alak tak ri quicꞌutuꞌn can ri mam alak? ");
INSERT INTO acrTNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ma ri Dios jewaꞌ xtakan che: Chalokꞌoj quikꞌij rachu-akaw yey We cꞌo junok quebuyaj ruchu-ukaw rucꞌ itzel chꞌaꞌtem, riꞌ lic takal che cacamisaxic xcha ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","»Noꞌj ralak cabiꞌij alak: “Utz we junok cubiꞌij chique ruchu-ukaw: Na utz taj cantoꞌ alak, ma ri toꞌbal cajawax che alak, nubiꞌtisim chic re nukasaꞌn chwach ri Dios.” ");
INSERT INTO acrTNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yey chiwach ralak, china ri cabiꞌn re waꞌ, na chirajawaxic ta chi che quebutoꞌ ruchu-ukaw. Jecꞌulaꞌ ꞌanom alak che Rutzij Upixab ri Dios pachaꞌ na jinta uchac, ma e takem alak ri xa noꞌjibal alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","»¡Xa queb palaj alak! Lic cꞌu katzij ri ubiꞌim lo ri Dios pawiꞌ alak ruma ri kꞌalajisanel Isaías, echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Waꞌ wa tinamit xa rucꞌ ruwaqueꞌ caquiyac nukꞌij, noꞌj ri canimaꞌ lic naj cꞌo wi chwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na jinta cꞌana cutikoj caquilokꞌoj nukꞌij, ma ri cꞌutunic caquiꞌano xa takanic que achijab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ecꞌuchiriꞌ, xebusiqꞌuij ruqꞌuiyal winak y xubiꞌij chique: —Lic tape alak y lic maja alak usucꞌ waꞌ: ");
INSERT INTO acrTNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri coc bi puchiꞌ ri ticawex na e ta ri cachꞌulan re; noꞌj ri chꞌaꞌtem quel lo puchiꞌ, e waꞌ ri cachꞌulan re —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E tak cꞌu rutijoꞌn xekib rucꞌ y xquibiꞌij che: —Kajawal, ¿xetaꞌmaj la lic xpe coyowal ri fariseos echiriꞌ xquita ri xbiꞌij la? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri Jesús xucꞌul uwach: —Waꞌ waꞌchijab na jinta runaꞌoj ri Dios cucꞌ, pachaꞌ e ticoꞌn na e ta ticom ruma ri Nukaw cꞌo chilaꞌ chicaj; ruma cꞌu riꞌ, camichꞌ bi cꞌa pa ratzꞌayak. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mixoc il chique, ma rique pachaꞌ e potzꞌ e cꞌamal quiwach cach e potzꞌ. Yey we juna potzꞌ cucꞌam uwach juna chic potzꞌ, quicabichal cꞌu riꞌ quebeꞌtzak bi pa siwan —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ecꞌuchiriꞌ, ri Pedro xubiꞌij che ri Jesús: —Kꞌalajisaj la chike saꞌ queꞌelawi wa jun cꞌambal naꞌoj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Xubiꞌij cꞌu ri Jesús chique: —¿Ix neba cuqꞌuil ri na jinta quinaꞌoj puwi waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Na quimaj ta neba usucꞌ? Ma e janipa ri coc bi puchiꞌ ri ticawex queꞌec pa rupa y tecꞌuchiriꞌ, cuꞌpamaj bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Noꞌj ri chꞌaꞌtem quel lo puchiꞌ, pa ranimaꞌ cawinakir wulok y ecꞌu waꞌ ri cachꞌulan re ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma pa ranimaꞌ ri ticawex quel wi lo tak waꞌ: ritzel naꞌoj, ri camisanic, ri macunic chirij ri cꞌulaniquil, ri caretzꞌabej uwa ukꞌij rucꞌ jun chic na ucꞌulel taj, ri elekꞌ, ri rakꞌubal y ri itzel chꞌaꞌtem chirij junok. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E tak waꞌ ri cachꞌulan que ri ticawex. Noꞌj ri cawaꞌ junok yey na cuchꞌaj ta rukꞌab nabe, waꞌ na cuchꞌulaj ta rubinic junok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ri Jesús xel bi chiriꞌ y xopon pa tak ri luwar re Tiro y re Sidón. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Cꞌo cꞌu jun ixok aj Canaán jekel chiriꞌ, rire casiqꞌuinic xcꞌun chwach ri Jesús, jewaꞌ cubiꞌij: —¡Wajawal, lal ri Ralcꞌoꞌal can ri rey David, chinjuchꞌ caꞌn co cheꞌla! Ma cꞌo jun walit lic cꞌax ucꞌulumam ruma cꞌo pukꞌab jun itzel uxlabixel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Noꞌj ri Jesús na xucꞌul ta cꞌana uwach. Ecꞌu rutijoꞌn xekib rucꞌ y lic xebelaj che ri Jesús: —Chꞌaꞌbej can la liꞌxok ma lic casiqꞌuinic teran lo chikij —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ecꞌuchiriꞌ, xubiꞌij ri Jesús: —Riꞌin intakom lo xew cuma rutinamit ri Dios e aj Israel, ri pachaꞌ e bexex e sachinak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Noꞌj rixok xkib rucꞌ ri Jesús, xuxuc rib chwach y xubiꞌij che: —¡Wajawal, chintoꞌo co la! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xubiꞌij che: —Na usucꞌ taj we cꞌo junok cumaj ri quiwa ri ralcꞌoꞌal y cucꞌak chiquiwa ri tzꞌiꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xubiꞌij cꞌu rixok: —Katzij, Wajawal, pero ri tzꞌiꞌ caquitij ne rucꞌaj ri wa catzak chuxeꞌ rumexa ri cajaw —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ecꞌuchiriꞌ, xubiꞌij ri Jesús che: —¡Ixok, lic nim ri cubulibal cꞌuꞌx la! E chuꞌana ucꞌ la saꞌ ri caꞌaj la —xchaꞌ. Chupa cꞌu riꞌ la jokꞌotaj ri ralit xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús xel bi chiriꞌ y xicꞌow chuchiꞌ ri mar re Galilea; tecꞌuchiriꞌ, xakꞌan chwa ri juyub y xtzꞌuyiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Uqꞌuiyal cꞌu winak xebopon chilaꞌ pa cꞌo wi Rire. Yey xequicꞌam lo ri e sic, ri e potzꞌ, ri e meꞌt, ri e tꞌum cakan quikꞌab y uqꞌuiyal yewaꞌib chic. Xequiya cꞌu chwach ri Jesús, y Rire xebucunaj conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ecꞌu ri winak lic xcam canimaꞌ che echiriꞌ xquilo xechꞌaw ri e meꞌt, ri e tꞌum cakan quikꞌab quecunutajic, ri e sic quebinic, ri e potzꞌ quetzuꞌnic. Y xquijek cꞌu caquiyac ukꞌij ri Dios re Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ecꞌuchiriꞌ, ri Jesús xebusiqꞌuij rutijoꞌn y xubiꞌij chique: —Lic cajuchꞌ caꞌn nucꞌuꞌx chique wa ticawex, ma e urox kꞌij waꞌ e cꞌo wucꞌ yey na jinta chi quiwa. Na cuaj taj quebenutak bi chicocho e laꞌ na jinta cꞌo quitijom, ma cꞌaxtaj quebeꞌkꞌochkꞌob pa be —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Xquibiꞌij cꞌu rutijoꞌn che: —¿Pa queꞌkarika wi wa re quebekatzuk wa uqꞌuiyal ticawex? Ma chupa wa luwar na jinta ne cꞌo e jekelic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ri Jesús xutzꞌonoj chique: —¿Janipa chi pam cꞌo iwucꞌ? —xchaꞌ. Rique xquibiꞌij: —Wukub pam cꞌo kucꞌ y jujun raltak co car —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ecꞌuchiriꞌ, ri Jesús xtakan che quetzꞌuyiꞌ ri ticawex chuꞌlew. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Xucꞌam cꞌu ri wukub pam pukꞌab rucꞌ tak ri car, y xtioxin chwach ri Dios puwi waꞌ. Tecꞌuchiriꞌ xuwechꞌ upa y xuya bi chique rutijoꞌn yey rique xquijach chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Conoje xewaꞌic y lic xenoj chi utz. Tecꞌuchiriꞌ, rucꞌ tak rukax ri waꞌim xquimolo, xquinojisaj wukub chacach. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ri xewaꞌic e cajib mil chi achijab yey na xebajilax tane rixokib y racꞌalab. ");
INSERT INTO acrTNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ecꞌuchiriꞌ, ri Jesús xebuchꞌaꞌbej can ri winak; xoc bi pa jun barco y xeꞌec pa tak ri luwar re Magdala. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri fariseos y ri saduceos xebopon rucꞌ ri Jesús re caquicꞌam upa. Xquitzꞌonoj cꞌu che cuꞌan juna cꞌutubal re chilaꞌ chicaj chiquiwach chaꞌ jelaꞌ cakꞌalajinic we Rire takom lo ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ecꞌu ri Jesús xucꞌul uwach: «Echiriꞌ queꞌec la kꞌij, ralak cabiꞌij alak: “Lic utz ri katiempo ma cak ruwa caj.” ");
INSERT INTO acrTNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Echiriꞌ anim tan, cabiꞌij alak: “Wakꞌij lic na utz ta ri katiempo. ma cak ruwa caj y kꞌekmuj.” ¡Ralak xa queb palaj alak! Ma carik alak uchꞌobic chi utz saꞌ ruꞌanom ruwa caj, yey na camaj tane alak usucꞌ saꞌ tak ri catajin ri Dios che ucꞌutic chiwach alak wakꞌij ora. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri caquitzꞌonoj cꞌutubal re ruchukꞌab ri Dios e ri winak re wakꞌij ora, ri itzel quicꞌuꞌx y na jusucꞌ ta ri canimaꞌ chwach ri Dios. Pero na cayaꞌtaj ta cꞌu waꞌ chique, ma xew cayaꞌiꞌ chiquiwach ri cꞌutubal xꞌaniꞌ ojertan rucꞌ ri kꞌalajisanel Jonás» xchaꞌ. Ecꞌuchiriꞌ, xebuya canok y xeꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Echiriꞌ xebopon rutijoꞌn chꞌaka mar, xcꞌun chiquicꞌuꞌx na xquicꞌam tubi pam. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Xubiꞌij cꞌu ri Jesús chique: —Chitapeꞌ: Lic chichajij iwib chwa ri levadura que ri fariseos y ri saduceos —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rutijoꞌn xa chiquiwach xquibiꞌij: «Rire cubiꞌij waꞌ, ma na xkacꞌam ta lo pam» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ri Jesús xretaꞌmaj saꞌ ri caquichꞌaꞌtibej chiquiwach, xubiꞌij cꞌu chique: —¡E riꞌix na nim ta cꞌana ri cubulibal icꞌuꞌx wucꞌ! ¿Suꞌchac e cubisoj icꞌuꞌx ri na jinta pam iwucꞌaꞌam lok? ");
INSERT INTO acrTNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Cꞌamajaꞌ neba quimaj usucꞌ? ¿Na cacꞌun ta neba chicꞌuꞌx echiriꞌ xebenutzuk ri woꞌob mil chi achijab rucꞌ woꞌob pam y janipa lo chacach xinojisaj rucꞌ ri quikax? ");
INSERT INTO acrTNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Yey na cacꞌun ta neba chicꞌuꞌx echiriꞌ xebenutzuk cajib mil chi achijab rucꞌ wukub pam y janipa lo chacach xinojisaj rucꞌ ri quikax? ");
INSERT INTO acrTNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chaꞌtaj na ximaj ta usucꞌ na e ta chwi ri pam xinchꞌaꞌt wi echiriꞌ ximbiꞌij: “Chichajij iwib che ri levadura que ri fariseos y ri saduceos”? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Cꞌa ecꞌuchiriꞌ xquimaj usucꞌ na chwi ta ri levadura re ri pam xchꞌaꞌt wi ri Jesús, ma e chwi ri quicꞌutunic ri fariseos y ri saduceos. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Cꞌo jun kꞌij xebopon ri Jesús che tak ri luwar re ri tinamit Cesarea re Filipo, y xutzꞌonoj cꞌu chique rutijoꞌn: —Chiquiwa ri winak, ¿china nawi Ralaxel Chiquixoꞌl Ticawex? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rutijoꞌn xquibiꞌij che: —Cꞌo quebiꞌn re e Juan Aj Yaꞌl Bautismo; jujun chic caquibiꞌij e Elías; y jujun chic, e Jeremías o junok chic chique ri kꞌalajisanelab re ojertan —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ecꞌuchiriꞌ, xubiꞌij chique rutijoꞌn: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ecꞌu ri Simón Pedro xubiꞌij che: —Rilal lal ri Cristo, lal Rucꞌajol ri Dios cꞌaslic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ri Jesús xucꞌul uwach: —Lic nim akꞌij awalaxic riꞌat Simón at ucꞌajol ri Jonás; ma na e ta juna ticawex xkꞌalajisan waꞌ chawe, e ri Nukaw cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Riꞌin cambiꞌij cꞌu chawe: Riꞌat at Pedro. Y chwi cꞌu waꞌ waꞌbaj cantic wubi ri nu iglesia, yey ruchukꞌab ri camic na cuchꞌij tane cꞌana usachic uwach ri nu iglesia. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Y riꞌin canya pakꞌab riꞌat ri lawe re rutakanic ri Dios petinak chilaꞌ chicaj. Ecꞌu janipa ri caxim wara che ruwachulew, caximitaj chilaꞌ chicaj; yey janipa ri caquir wara che ruwachulew, caquiritaj chilaꞌ chicaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ecꞌu ri Jesús xebutak rutijoꞌn che chaꞌ na caquitzijoj ta cꞌana che junok we Rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chwi cꞌu riꞌ, ri Jesús xujek ukꞌalajisaxic chique rutijoꞌn janipa ri cucꞌulumaj: E lic chirajawaxic che queꞌec Jerusalem, cayaꞌiꞌ na cꞌu pa cꞌax cuma tak ri nimak winak re Israel, ri nimak e aj chacunel pa Rocho Dios y raj cꞌutunel re ri tzijpixab, yey cacamisaxic; noꞌj churox kꞌij cacꞌastaj lok. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ecꞌu ri Pedro xresaj bi ri Jesús chiquixoꞌl y xuchꞌaꞌbej upa, jewaꞌ xubiꞌij che: —¡Wajawal, lic ne muya luwar riꞌ ri Dios e cacꞌulumaj la waꞌ! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ecꞌu ri Jesús xutzuꞌ lo uwach ri Pedro y xubiꞌij che: —¡Chatel chinuwach, Satanás! Riꞌat at latzꞌanel chwe, ma na e ta cachꞌob puwi ri uchꞌobom lo ri Dios, xew e cachꞌob jelaꞌ pachaꞌ ri caquichꞌob ri winak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ecꞌuchiriꞌ, xubiꞌij ri Jesús chique rutijoꞌn: —We cꞌo junok caraj caterej lo chwij, lic chirajawaxic che muꞌan xew ri caraj rire, e chucuyu ri cꞌax cape puwiꞌ ruma ucojom ri nubiꞌ, y tereja lo chwij. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ma china ri na cuya ta ranimaꞌ rucꞌaslem, riꞌ e cujam ri chomilaj cꞌaslemal chwach ri Dios; noꞌj ri cuya ranimaꞌ rucꞌaslem wuma riꞌin, riꞌ e curik ri chomilaj ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma ¿saꞌ cꞌu cutikoj riꞌ che ri ticawex we cuꞌan rajaw ronoje ruwachulew yey cusach cꞌu uwach rucꞌaslemal? ¿O cꞌo nawi rajil cutoj rachi chwa rucꞌaslemal chaꞌ jelaꞌ na cujam taj? ¡Na jintaj! ");
INSERT INTO acrTNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","»Ma Ralaxel Chiquixoꞌl Ticawex cacꞌun rucꞌ runimal yacbal ukꞌij Rukaw y cucꞌ tak ru ángeles. Ecꞌuchiriꞌ cuya chique chiquijujunal ri ticawex, ri rajil ucꞌaxel e chirij tak ri quiꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Pakatzij wi cambiꞌij chiwe: E cꞌo jujun chique wa e cꞌo wara na quecam tana we na xquil tubi Ralaxel Chiquixoꞌl Ticawex cacꞌun che rutakanic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wakib kꞌij cꞌu ubiꞌxiquil riꞌ waꞌ echiriꞌ ri Jesús xebuchaꞌ ri Pedro, ri Jacobo y ri Juan ruchakꞌ ri Jacobo; y xebucꞌam bi chwa jun nimalaj juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chilaꞌ cꞌut xjalcꞌatitaj uwach ri Jesús chiquiwach. Rupalaj lic xwonic jelaꞌ pachaꞌ ruwonibal ri kꞌij; yey rukꞌuꞌ xujek cawolkꞌinic jelaꞌ pachaꞌ ri kꞌijsak. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xakicꞌateꞌt cꞌut chiquiwach xewinakir ri Moisés y ri Elías, kꞌalajisanelab re ojertan; e riꞌ quechꞌaꞌt rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ecꞌu ri Pedro xubiꞌij che ri Jesús: —Kajawal, lic utz xyaꞌtaj chike riꞌoj oj cꞌo wara. We caꞌaj la, cakaꞌan oxib rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Cꞌa cachꞌaꞌt ne ri Pedro echiriꞌ jun sutzꞌ lic cawonic xuchꞌuk quiwiꞌ. Y chupa cꞌu ri sutzꞌ xquita rukul ri Dios, jewaꞌ xubiꞌij: «E Nucꞌajol waꞌ ri lic cꞌax cannaꞌo y lic quinquiꞌcot che. E chita utzij Rire» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Echiriꞌ rutijoꞌn xquita waꞌ, xexuquiꞌic, xquikasaj quimejelem cꞌa chuꞌlew y xoc jun nimalaj xiꞌin ib cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ecꞌuchiriꞌ, xkib ri Jesús cucꞌ, xebuchapo y xubiꞌij chique: —Chixyactajok, mixiꞌij iwib —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Echiriꞌ xetzuꞌn apanok, na jinta junok chic xquilo, xew ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ecꞌuchiriꞌ xekaj lo chwa ri juyub, ri Jesús xebutak che: —Mitzijoj cꞌana che junok janipa ri xcꞌut chiwach, cꞌate quitzijoj echiriꞌ Ralaxel Chiquixoꞌl Ticawex cꞌastajinak chi lo chiquixoꞌl ri ecaminak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ecꞌuchiriꞌ, rutijoꞌn xquitzꞌonoj che: —¿Suꞌbe cꞌut caquibiꞌij raj cꞌutunel re ri tzijpixab: “Lic chirajawaxic wi cacꞌun na ri Elías nabe”? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ri Jesús xucꞌul uwach: —Katzij, ri Elías nabe cacꞌunic y cuyijbaꞌ pan ronoje chwach rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noꞌj cankꞌalajisaj cꞌu waꞌ chiwe: Ri Elías ya xcꞌunic, yey ri winak na xquetaꞌmaj ta uwach. Xquiꞌan cꞌu riꞌ che janipa ri xcaj rique; jecꞌulaꞌ Ralaxel Chiquixoꞌl Ticawex cutij na ri cꞌax paquikꞌab rique —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ecꞌu rutijoꞌn xquetaꞌmaj e cachꞌaꞌt puwi ri Juan Aj Yaꞌl Bautismo. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Echiriꞌ xebopon pa e cꞌo wi tak ri winak, cꞌo jun achi xkib rucꞌ ri Jesús, xuxuc rib chwach y xubiꞌij che: ");
INSERT INTO acrTNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wajawal, cꞌutu co ri cꞌaxnaꞌbal cꞌuꞌx la che ri nucꞌajol, ma rire xa cumaj tew y lic cutij cꞌax ruma waꞌ; uqꞌuiyal laj tzakinak pa akꞌ y pa yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xincꞌam lo cucꞌ wa tijoꞌn la, pero rique na quichꞌijom ta ucunaxic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ecꞌu ri Jesús xucꞌul uwach: —¡E ri ix ticawex re wakꞌij ora na cubul ta icꞌuꞌx wucꞌ yey ix sachinak! ¿Janipa chi lo kꞌij cajawaxic quincꞌojiꞌ iwucꞌ chaꞌ cacubiꞌ icꞌuꞌx wucꞌ? ¿Janipa chi lo kꞌij quixincuyu e laꞌ jelaꞌ iꞌanom? Chicꞌama lo rala wara —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ecꞌuchiriꞌ, ri Jesús xutak ri itzel uxlabixel chaꞌ quel bi che rala. Y chwi cꞌu riꞌ asu xcunutaj rala. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tecꞌuchiriꞌ, rutijoꞌn ri Jesús xekib rucꞌ re quechꞌaꞌt rucꞌ quituquel y xquitzꞌonoj cꞌu che: —¿Suꞌbe riꞌoj na xkachꞌij ta resaxic bi waꞌ wa itzel uxlabixel? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ri Jesús xubiꞌij chique: —E ruma na nim ta ri cubulibal icꞌuꞌx rucꞌ ri Dios. We ta ri cubulibal icꞌuꞌx caqꞌuiyic jelaꞌ pachaꞌ ri caqꞌuiy rijaꞌ re moxtasa, utz ne riꞌ quibiꞌij che wa juyub: “Chatela bi wara y chatkꞌax pan jelaꞌ”, y e cuꞌanaꞌ. Riꞌ na jinta cꞌayew chiwach riꞌix we ta lic cꞌo cubulibal icꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Noꞌj waꞌ wa juchꞌob itzel uxlabixel xew utz quebesax bi rucꞌ oración y ayuno —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ecꞌuchiriꞌ e cꞌo pa tak ri luwar re Galilea, ri Jesús xubiꞌij chique rutijoꞌn: «Ralaxel Chiquixoꞌl Ticawex cayaꞌiꞌ paquikꞌab rachijab ");
INSERT INTO acrTNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","y cacamisax cuma; noꞌj churox kꞌij cacꞌastaj lok» xchaꞌ. Echiriꞌ xquita waꞌ rutijoꞌn, lic xquibisoj. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Echiriꞌ ri Jesús cucꞌ rutijoꞌn xebopon pa ri tinamit Capernaúm, raj tzꞌonol puak re ri tojonic xeꞌquila ri Pedro y xquitzꞌonoj che: —¿Ri tijonel iweꞌix na cutoj ta cami riꞌ ri tojonic caꞌanic re ri Rocho Dios? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ecꞌu ri Pedro xubiꞌij: —Rire cutojo —xchaꞌ. Ecꞌuchiriꞌ xoc ri Pedro pa ri ja, ri Jesús nabe na xchꞌaw che, jewaꞌ xubiꞌij: —Chawach riꞌat, ¿e juna rey che ruwachulew, china chique cutzꞌonoj wi tak ri tojonic caꞌanic? ¿Chique ri e ralcꞌoꞌal o chique ri na e ta ralcꞌoꞌal? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xubiꞌij cꞌu ri Pedro: —Chique ri na e ta ralcꞌoꞌal —xchaꞌ. Tecꞌuchiriꞌ, xubiꞌij ri Jesús che: —Ecꞌu ri e ralcꞌoꞌal na jinta cꞌo catzꞌonox chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Noꞌj chaꞌ na cakapetisaj ta cꞌu royowal junok, jat chuchiꞌ ri mar y chacꞌaka ri anzuelo chupa. Ecꞌu ri nabe car cachapo, chajaka rupuchiꞌ y carik jun meyo chupa. Rucꞌ cꞌu riꞌ, chayaꞌa ri tojonic canꞌan riꞌin y ri tojonic caꞌan riꞌat —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chupa cꞌu laꞌ la kꞌij, rutijoꞌn ri Jesús xekib rucꞌ y xquitzꞌonoj che: —¿China ri más cꞌo uwach chupa rutakanic ri Dios petinak chilaꞌ chicaj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ecꞌuchiriꞌ, ri Jesús xusiqꞌuij jun ralco cꞌoꞌm y xuya chiquinicꞌajal rique. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Xubiꞌij cꞌu chique: —Pakatzij wi cambiꞌij chiwe: We na quijalcꞌatij ta ribinic isilabic chaꞌ quixuꞌan pachaꞌ raltak co acꞌalab, na quixoc ta riꞌ chupa rutakanic ri Dios petinak chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jecꞌulaꞌ, china ri cuꞌan chꞌutiꞌn che rib pachaꞌ wa ralco cꞌoꞌm, e lic cꞌo uwach riꞌ pa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yey china ri cucꞌul chupa ri nubiꞌ junok na jinta uwach pachaꞌ wa ralco cꞌoꞌm, e junam rucꞌ e in ri quinucꞌulu. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","»China ri caminow pa mac junok chique wa chꞌutiꞌk cubul quicꞌuꞌx wucꞌ, e ne más utz catzayabax bi pukul juna nimalaj caꞌ re queꞌem y cacꞌak cꞌu bi pa ri mar chaꞌ camukutaj cꞌa chuxeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Tokꞌoꞌ quiwach ri ticawex ma lic cꞌo ri catzakisan que chupa ri na utz taj! Ma che ruwachulew lic cꞌo tak waꞌ. Pero ¡lic tokꞌoꞌ cꞌu uwach ri jun cumin junok chic pa mac, ma e cape ri kꞌatbal tzij re ri Dios puwiꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","»E uwariꞌche, we rakꞌab o rawakan e catzakisan awe pa mac, chakꞌata bi y chawesaj bi chawe. Ma xa ne cuya tob at tꞌum o at jetzꞌ catopon pa ri cꞌaslemal chilaꞌ chicaj, chwa ri cꞌo ucabichal rakꞌab y ucabichal rawakan yey catcꞌak bi chi xibalbaꞌ pa cꞌo wi ri akꞌ na jinta chi uchupic. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yey we rawach e catzakisan awe pa mac, chawesaj bi y chacꞌaka bi. Ma xa ne cuya tob xa jun rawach catopon pa ri cꞌaslemal chilaꞌ chicaj, chwa ri cꞌo ucabichal rawach yey catcꞌak bi pa akꞌ chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","»Micꞌak bi ukꞌij junok chique wa e chꞌutiꞌk cubul quicꞌuꞌx wucꞌ. Ma cambiꞌij cꞌu chiwe, ri ángeles e chajal que rique xaki e cꞌo chwach ri Nukaw Dios chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma Ralaxel Chiquixoꞌl Ticawex xcꞌunic re quebucolobej ri e sachinak. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Saꞌ quichꞌob riꞌix cuꞌan juna achi we cꞌo jun ciento ubexex yey casach cꞌu junok chique? ¿Na quebucꞌol ta neba can riꞌ ri noventa y nueve y queꞌec chwa ri juyub che utzucuxic ri jun xsach canok? ");
INSERT INTO acrTNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","We xurik cꞌut, pakatzij wi cambiꞌij chiwe: E más caquiꞌcot ruma ri jun bexex chiquiwa ri noventa y nueve na e ta sachinak. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jecꞌuriꞌlaꞌ, ri Nukaw cꞌo chilaꞌ chicaj na caraj taj casach junok chique ri chꞌutiꞌk cubul quicꞌuꞌx wucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","»E uwariꞌche, we rawatz-achakꞌ cuꞌan ri na utz taj chawe, chatchꞌaꞌt rucꞌ e laꞌ ituquel; chabiꞌij che saꞌ ri na utz taj uꞌanom chawe. We xatuta cꞌut, riꞌ xacoj chi utzil chomal rawatz-achakꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Noꞌj we na xatuta taj, jat tanchi rucꞌ; chacꞌama cꞌu bi jun o caꞌib awachbiꞌil awucꞌ chaꞌ jelaꞌ e queb oxib che utayic saꞌ ri cabiꞌxic. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We na xebuta ta cꞌu wa queb oxib, ecꞌuchiriꞌ chatzijoj chiquiwach rutinamit ri Dios. Yey we na xoc ta cꞌu il chique waꞌ, chiꞌana cꞌu riꞌ che pachaꞌ e cuqꞌuil ri na quetaꞌam ta uwach ri Dios y e cuqꞌuil raj tzꞌonol puak re tojonic. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Pakatzij wi cambiꞌij chiwe: Janipa ri quixim riꞌix wara che ruwachulew, caximitaj chilaꞌ chicaj. Janipa ri quiquir riꞌix wara che ruwachulew, caquiritaj chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Cambiꞌij cꞌu chiwe: We e cꞌo caꞌibok chiwe wara che ruwachulew cuꞌan junam quicꞌuꞌx chwi ri caquitzꞌonoj pa oración, ri Nukaw cꞌo chilaꞌ chicaj cuya na chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ma pa quimolom wi quib queb oxib pa ri nubiꞌ, chiriꞌ in cꞌo wi riꞌin chiquinicꞌajal rique —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ecꞌuchiriꞌ, ri Pedro xkib rucꞌ ri Jesús y xutzꞌonoj che: —Wajawal, ¿janipa laj cancuy umac juna watz-nuchakꞌ we xuꞌan ri na utz taj chwe? ¿Cꞌa pa wukub laj nawi? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri Jesús xucꞌul uwach: —Na cambiꞌij ta chawe xa pa wukub laj, ma cꞌa wukub laj chi setenta. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","»Ma ri cuꞌan chupa rutakanic ri Dios petinak chilaꞌ chicaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ juna takanel xraj carilo we na jinta quicꞌas ri raj chaquib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ecꞌu riꞌ xujek rajilaxic, xrikitaj lo jun aj chac lic uqꞌuiyal rucꞌas rucꞌ y xcꞌam lo chwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ecꞌu wa aj chac ruma na cuchꞌij ta chi utojic rucꞌas, xtakan rupatrón che chaꞌ cacꞌayix bi rire, junam rucꞌ ri rixokil, ri ralcꞌoꞌal y rucꞌ ronoje rubitak re chaꞌ jelaꞌ catojtaj rucꞌas. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pero wa aj chac xuxucubaꞌ rib chwach rupatrón y lic cꞌu xutzꞌonoj che: “Lal wajaw, lic chinoyꞌej co cꞌana la ma cantoj ronoje ri nucꞌas cheꞌla” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ecꞌu rupatrón lic xjuchꞌ caꞌn ucꞌuꞌx che ri raj chac. Xucuy cꞌu umac che ronoje rucꞌas y xuya bi luwar che xeꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","»Noꞌj cꞌu wa aj chac xew xel bi, xuꞌcꞌulu lo jun rach aj chac yey waꞌ cꞌo jubikꞌ ucꞌas rucꞌ. Xuchapij cꞌu pukul e riꞌ pachaꞌ cujitzꞌaj, jewaꞌ xubiꞌij che: “¡Chatojolaꞌ racꞌas wucꞌ!” xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","»Ecꞌu ri rach aj chac xuxucubaꞌ rib chwach y lic xutzꞌonoj che: “Chacuyu co numac, chinawoyꞌej na qꞌuenok ma cantoj ronoje ri nucꞌas chawe” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","»Noꞌj rire na xraj taj xroyeꞌej waꞌ. Ri xuꞌano e xuꞌyaꞌa ri jun chic rach aj chac pa cárcel; yey cꞌa ecꞌu quesax lok we xutoj na rucꞌas. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","»Echiriꞌ xquil tak waꞌ ri cach aj chaquib, lic xoc chiquicꞌuꞌx. Xebec cꞌut, xeꞌquibiꞌij che ri quipatrón ronoje ri xuꞌan ri jun aj chac. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ecꞌuchiriꞌ, rupatrón xutak ucꞌamic y xubiꞌij che: “¡At jun aj chac itzel acꞌuꞌx! Riꞌin xincuy amac riꞌat che ronoje racꞌas, ma lic e xatzꞌonoj riꞌ chwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ta ne e xaꞌan riꞌat jelaꞌ pachaꞌ ri xinꞌan riꞌin chawe, ta e xacꞌut ri cꞌaxnaꞌbal acꞌuꞌx che rawach aj chac; noꞌj na e ta cꞌu ri xaꞌano” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","»Ecꞌu rupatrón lic xpe royowal y xtakan che cayaꞌiꞌ pa cꞌax y cꞌa e quesax lo chupa waꞌ we xutoj na ronoje rucꞌas. ");
INSERT INTO acrTNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","»Jecꞌulaꞌ cuꞌan ri Nukaw cꞌo chilaꞌ chicaj iwucꞌ riꞌix we cꞌo junok chiwe na cucuy ta umac ri ratz-uchakꞌ rucꞌ ronoje ranimaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Echiriꞌ xuqꞌuis ubiꞌxic waꞌ ri Jesús, xel bi Galilea y xeꞌec pa tak ri luwar re Judea y xopon pa tak ri luwar cꞌo chꞌaka yaꞌ che ri nimayaꞌ Jordán. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lic cꞌut e qꞌui ri winak xeterej bi chirij y xebucunaj ri yewaꞌib chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E cꞌo cꞌu jujun chique ri fariseos xekib rucꞌ ri Jesús xa re caquicꞌam upa y xquitzꞌonoj che: —¿Ube nawi che juna achi, xa tob saꞌ ri cujal wi uchiꞌ ri rixokil, cuya bi ruwujil re jachbal ib che? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ri Jesús xucꞌul uwach: —¿Na ajilam ta neba alak saꞌ ri tzꞌibital can pa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ cubiꞌij: Che ri jekebal lo ruwachulew echiriꞌ ri Dios xebuꞌan ri ticawex, chi achi chi ixok xebuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y cubiꞌij: Ruma cꞌu riꞌ, rachi echiriꞌ cacꞌuliꞌic, caresaj rib chiquij ruchu-ukaw chaꞌ cajekiꞌ rucꞌ ri rixokil y quicabichal cꞌu riꞌ quebuꞌana xa e jun chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jecꞌuriꞌlaꞌ na e ta chi caꞌib, ma xebuꞌana xa e jun. E uwariꞌche, ri xebujunimaj ri Dios, na yaꞌtal ta che ri ticawex cujach upa —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ecꞌuchiriꞌ, xquitzꞌonoj che: —¿Suꞌchac cꞌu riꞌ ri Moisés xubiꞌij we juna achi caraj cujach bi ri rixokil, xew chuyaꞌa bi ruwujil re jachbal ib che y jecꞌulaꞌ na rixokil ta chic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri Jesús xubiꞌij chique: —Waꞌ e ruma lic co ri animaꞌ alak. Ruma laꞌ ri Moisés xuya luwar cayaꞌiꞌ ruwujil re jachbal ib; noꞌj che lo ri jekebal ruwachulew na je ta laꞌ ri xraj ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Cambiꞌij cꞌu riꞌin che alak: China junok cuya ruwujil re jachbal ib che ri rixokil tob ri rixokil na macuninak ta chirij ri cꞌulaniquil, yey cacꞌuliꞌ tanchi rucꞌ juna chic ixok, riꞌ camacun chirij ri cꞌulaniquil. Y china ri cacꞌuliꞌ rucꞌ rixok jachom canok, riꞌ jenelaꞌ camacun chirij ri cꞌulaniquil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ecꞌu rutijoꞌn xquibiꞌij che: —We jelaꞌ cucꞌulumaj rachi rucꞌ ri cꞌulaniquil, más ne utz riꞌ we junok na cacꞌuliꞌ taj —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ri Jesús xubiꞌij chique: —Na conoje ta cꞌu ri ticawex caquichꞌij waꞌ; ma xew ri yaꞌtal lo chique ruma ri Dios, caquichꞌij uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","E cꞌo achijab na quecꞌuliꞌ taj ma calaxibem pachaꞌ e eunucos. E cꞌo jujun chic na quecꞌuliꞌ taj ma ꞌanom eunucos chique. Yey e cꞌo ri na quecꞌuliꞌ taj ma quiyaꞌom quib che ri chac re rutakanic ri Dios petinak chilaꞌ chicaj. China ri cachꞌijow uꞌanic waꞌ, chuchꞌija cꞌu riꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","E cꞌo jujun raltak co acꞌalab xecꞌam lo chwach ri Jesús chaꞌ cuya rukꞌab paquiwiꞌ y jelaꞌ cutzꞌonoj che ri Dios quebuchajij. Yey rutijoꞌn xequiyaj ri ecꞌamayom lo que. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Noꞌj ri Jesús xubiꞌij chique: «Chiyaꞌa luwar chique ri raltak co acꞌalab chepeta na wucꞌ. Mebikꞌatej; ma ri caquiꞌan e jelaꞌ pachaꞌ rique, riꞌ cuꞌan que rutakanic ri Dios petinak chilaꞌ chicaj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Xuya cꞌu rukꞌab paquiwi ri raltak co acꞌalab. Tecꞌuchiriꞌ, xel bi pa ri luwar. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Cꞌo cꞌu jun cꞌacꞌal achi xcꞌun rucꞌ ri Jesús y xutzꞌonoj che: —Lal utzilaj tijonel, ¿saꞌ ri utz canꞌano chaꞌ cꞌo nucꞌaslemal na jinta utakexic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xucꞌul uwach: —¿Suꞌbe cabiꞌij la “utz” chwe? Ma xa jun ri lic utz cꞌolic, waꞌ e ri Dios. Yey we caꞌaj la coc la pa ri cꞌaslemal na jinta utakexic rucꞌ Rire, e takej la Rutzij Upixab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rachi xubiꞌij che ri Jesús: —¿Pachique cꞌu riꞌ ri tzijpixab? —xchaꞌ. Ri Jesús xubiꞌij che: —“Matcamisanic. Matmacun chirij ri cꞌulaniquil. Matelekꞌic. Maꞌan rakꞌubal chirij junok. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chalokꞌoj quikꞌij rachu-akaw” y “Cꞌax chanaꞌa rawatz-achakꞌ jelaꞌ pachaꞌ cꞌax canaꞌ awib riꞌat” —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rachi xubiꞌij che ri Jesús: —Ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal. ¿Saꞌ cꞌu riꞌ ri cꞌa chirajawaxic chwe canꞌano? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xubiꞌij che: —We caꞌaj la e caꞌan la janipa ri caraj ri Dios che ri binic silabic la, cꞌayij la ronoje tak ri beyomalil la y jacha cꞌu la chique ri nibaꞌib; jecꞌuriꞌlaꞌ cꞌo beyomalil la chilaꞌ chicaj. Tecꞌuchiriꞌ, peta la, terej lo la chwij y cuyu la ri cꞌax cape pawiꞌ la ruma lal nutijoꞌn —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Rachi echiriꞌ xuta waꞌ, lic cabisonic xeꞌec ma rire lic rajawal beyom. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ecꞌuchiriꞌ, xubiꞌij ri Jesús chique rutijoꞌn: —Pakatzij wi cambiꞌij chiwe: Juna beyom lic cꞌayew che coc chupa rutakanic ri Dios petinak chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Cambiꞌij tanchi cꞌu chiwe: E ne más cꞌayew ri coc juna beyom chupa rutakanic ri Dios chwa ri quicꞌow juna camello chupa rutel juna acuxaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Echiriꞌ xquita waꞌ rutijoꞌn, lic xcam canimaꞌ che y xquitzꞌonoj chiquiwach: —We e riꞌ, ¿china cꞌu riꞌ ri cacolobetajic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xutzuꞌ quiwach y xubiꞌij chique: —Ri ticawex na caquicolobej ta quib quituquel ma waꞌ lic cꞌayew chiquiwach; noꞌj ri Dios ronoje cuꞌano ma na jinta cꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ecꞌuchiriꞌ, xubiꞌij ri Pedro che: —Kajawal, riꞌoj kayaꞌom can ronoje y oj teran chiꞌij la. ¿Saꞌ cꞌu riꞌ ri cakacꞌul riꞌoj? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij chiwe: Copon cꞌu riꞌ ri kꞌij echiriꞌ ronoje cuꞌan cꞌacꞌ, waꞌ echiriꞌ Ralaxel Chiquixoꞌl Ticawex queꞌtzꞌula chupa ri chomilaj tzꞌulibal re rutakanic. Jecꞌulaꞌ riꞌix quixeꞌtzꞌula chupa cablajuj tzꞌulibal re quixtakan paquiwi ri cablajuj tinamit re Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yey china cꞌu ri uyaꞌom can rocho, ebuyaꞌom can ri ratz-uchakꞌ, ruchu-ukaw, ri rixokil, ri ralcꞌoꞌal o ri rulew ruma ucojom ri nubiꞌ, riꞌ cucꞌul na jun ciento chic chwa ronoje laꞌ yey cucꞌul cꞌu ri cꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","»Lic cꞌu e qꞌui chique ri lic cꞌo quiwach woꞌora, chwach apanok na jinta chi quiwach; yey lic e qꞌui chique ri na jinta quiwach woꞌora, e lic cacꞌojiꞌ quiwach chwach apanok. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","»Ri cuꞌan chupa rutakanic ri Dios petinak chilaꞌ chicaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ juna rajaw chac anim tan xel bi che quitzucuxic aj chaquib quebajawax chupa ruticoꞌn re uva. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xchꞌaꞌt cucꞌ raj chaquib puwi ri cajil y xcanajic cuya jun denario re jun kꞌij chac chique. Tecꞌuchiriꞌ, xebutak bi chupa ruticoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Laj che ri ubelej ora anim, xel tanchi ubi y xeburik jujun chic quimolom quib pa cꞌayibal na jinta caquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","»Xubiꞌij cꞌu chique: “Jix riꞌix, jixeꞌchacuna wucꞌ chupa ri nuticoꞌn re uva y tzꞌakat quixintojo” xchaꞌ. Ecꞌu rique xebec. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","»Pa tiqꞌuil kꞌij cꞌu riꞌ, ri rajaw ri chac xel tanchi ubi che quitzukuxic más aj chac. Yey je tanchi laꞌ xuꞌan che ri urox ora benak kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","»Laj che cꞌu ri uroꞌ ora benak kꞌij, xel tanchi ubi y xebuꞌrika lo jujun chic na jinta caquiꞌano. Xubiꞌij cꞌu chique: “¿Suꞌchac riꞌix ix cꞌo wara y na jinta cꞌo xiꞌan wa jun kꞌij?” ");
INSERT INTO acrTNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","»Xquicꞌul cꞌu uwach rique: “E ruma na jinta junok xojchocowic.” »Ecꞌuchiriꞌ, xubiꞌij ri rajaw ri chac chique: “Jix, jixeꞌchacuna chupa ri nuticoꞌn re uva y tzꞌakat quixintojo.” ");
INSERT INTO acrTNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","»Echiriꞌ xoc rakꞌab, ri rajaw ri chac xubiꞌij che ri caporal: “Chebasiqꞌuij conoje raj chaquib y chebatojo bi. E quebatoj nabe ri xeboc cꞌunaj, y qꞌuisbal cꞌu re, quebatoj ri xeboc nabe pa chac.” ");
INSERT INTO acrTNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","»Ecꞌuchiriꞌ, xecꞌun raj chac ri xeboc benak kꞌij che ri uroꞌ ora. Y chiquijujunal cꞌu riꞌ xquicꞌul jun denario. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tecꞌuchiriꞌ, xecꞌun lo ri eboquinak nabe pa chac. E chiquiwa rique más qꞌui ri cajil caquicꞌulu. Noꞌj na je ta laꞌ xuꞌano, ma xquicꞌul chiquijujunal jun denario, pachaꞌ ri xquicꞌul ri jujun chic. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","»Echiriꞌ xquicꞌul ri cajil re jun kꞌij, xquijeko quechꞌaꞌt chirij ri rajaw ri ticoꞌn, ");
INSERT INTO acrTNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","jewaꞌ xquibiꞌij che: “Waꞌ wa xeboc benak kꞌij chic, xa jun ora xechacunic yey xetoj la junam kucꞌ riꞌoj, tob cꞌu riꞌ riꞌoj xkacuy lo rucꞌatanil ri kꞌij” xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","»Noꞌj ri rajaw chac xucꞌul uwach, jewaꞌ xubiꞌij che jun chique: “Wamigo, mabiꞌij we na usucꞌ ta ri xinꞌan chawe. ¿Na xojcanaj ta neba laꞌ catintoj jun denario? ");
INSERT INTO acrTNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chacꞌama cꞌu rawajil riꞌat y jat. Yey we riꞌin cuaj canya che ri xoc cꞌunaj pa chac, junam rucꞌ ri xinya chawe riꞌat, ");
INSERT INTO acrTNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿na jinta neba panukꞌab riꞌin canꞌan saꞌ ri cuaj rucꞌ ri nupuak? ¿O cꞌax acꞌuꞌx chwij xa ruma xincꞌut ri rutzil nucꞌuꞌx chique jujun chic?” xcha ri rajaw ri chac. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","»Jelaꞌ cꞌu riꞌ, lic e qꞌui chique ri na jinta quiwach woꞌora, e lic cacꞌojiꞌ quiwach chwach apanok; yey lic cꞌu e qꞌui chique ri lic cꞌo quiwach woꞌora, chwach apanok na jinta chi quiwach. Ma lic e qꞌui ri esiqꞌuim, tob cꞌu xa e jujun ri echaꞌtalic —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Echiriꞌ cꞌo chi ri Jesús chi be re queꞌec Jerusalem, xebucꞌam bi ri cablajuj utijoꞌn quituquel pa jun luwar y xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Chitapeꞌ: E waꞌ cojpakiꞌ Jerusalem, yey ecꞌu Ralaxel Chiquixoꞌl Ticawex cayaꞌ paquikꞌab ri nimak e aj chacunel pa Rocho Dios y raj cꞌutunel re ri tzijpixab chaꞌ caquikꞌat tzij puwiꞌ re camic. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tecꞌuchiriꞌ, caquiya paquikꞌab ri na e ta aj judiꞌab chaꞌ rique caquichꞌamij, caquijichꞌ upa y caquicamisaj chwa cruz. Noꞌj churox kꞌij cꞌut cacꞌastaj bi chiquixoꞌl ri ecaminak» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ecꞌuchiriꞌ, xkib rucꞌ ri Jesús ri quichu ri queb ucꞌajol ri Zebedeo, y ecꞌu laꞌ e rachbiꞌil ri ralab; xuxucubaꞌ rib chwach ri Jesús ma cꞌo caraj cutzꞌonoj che. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xutzꞌonoj che: —¿Saꞌ ri caꞌaj la? —xchaꞌ. Rixok xucꞌul uwach: —Wajawal, yaꞌa la chique wa queb walab quetzꞌuyiꞌ ucꞌ la pa ri takanic la, jun pawiquikꞌab la y ri jun chic, pa mox la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ecꞌu ri Jesús xucꞌul uwach, y jewaꞌ xubiꞌij chique ri queb utijoꞌn: —Riꞌix na iwetaꞌam taj saꞌ ri quitzꞌonoj. ¿Quichꞌij neba riꞌix ri quinicꞌow wi riꞌin y ri cꞌax cape panuwiꞌ? —xchaꞌ. Rique xquibiꞌij: —Cakachꞌijo —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ri Jesús xubiꞌij chique: —Katzij, riꞌix quichꞌij na ri cꞌax quinicꞌow wi riꞌin y ri cꞌaxcꞌobic cape panuwiꞌ. Pero ri quixtzꞌuyiꞌ pa nuwiquikꞌab y pa numox, riꞌ na in ta quinyaꞌw re. Ma xew cayaꞌtaj chique ri echaꞌtal chi ruma ri Nukaw chaꞌ cuꞌana na que —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Echiriꞌ xquita waꞌ ri lajuj chic utijoꞌn, lic xpe coyowal chiquij ri queb quichakꞌ quib. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ecꞌu ri Jesús xebusiqꞌuij y xubiꞌij chique: —Iwetaꞌam riꞌix, ri quetakan paquiwi ri nimak tinamit quebuꞌana pachaꞌ e rajaw ronoje; yey ri lic cꞌo quiwach quicꞌow uwiꞌ ri takanic caquiꞌan paquiwi ri eyaꞌtal paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Noꞌj chixoꞌl riꞌix na ube taj jelaꞌ cuꞌano. Ma we cꞌo junok chiwe riꞌix caraj cuꞌana aj wach, e chuyaꞌa rib cuꞌan nimanel iweꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yey e junok chiwe caraj cuꞌana nabe chixoꞌlibal, e chuyaꞌa rib cuꞌan nimanel que conoje ");
INSERT INTO acrTNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","jelaꞌ pachaꞌ ri cuꞌan Ralaxel Chiquixoꞌl Ticawex. Ma Rire na xcꞌun taj re canimaxic; xcꞌunic re coꞌlnimanok y re coluꞌyaꞌa rib pa camic che quicolobexic uqꞌuiyal ticawex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Echiriꞌ ri Jesús cucꞌ rutijoꞌn catajin bi quelic pa ri tinamit Jericó, lic uqꞌuiyal winak xeterej bi chirij Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E cꞌo cꞌu caꞌib potzꞌ etzꞌul chuchiꞌ ri be. Echiriꞌ xquito catajin ricꞌowic ri Jesús, lic xesiqꞌuin pan che: —¡Kajawal, lal ri Ralcꞌoꞌal can ri rey David, choj-juchꞌ caꞌn co cheꞌla! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ecꞌu ri winak xequichꞌaꞌbej quipa chaꞌ na quesiqꞌuin ta chic, noꞌj ri caꞌib potzꞌ más ne co xesiqꞌuinic, xquibiꞌij: —¡Kajawal, lal ri Ralcꞌoꞌal can ri rey David, choj-juchꞌ caꞌn co cheꞌla! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ecꞌuchiriꞌ, xtaqꞌuiꞌ ri Jesús, xebusiqꞌuij y xutzꞌonoj chique: —¿Saꞌ ri quiwaj canꞌan chiwe? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri caꞌib potzꞌ xquicꞌul uwach: —Kajawal, chojcunaj co la chaꞌ cojtzuꞌnic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ecꞌu ri Jesús xejuchꞌ caꞌn pa ranimaꞌ y xuya rukꞌab puwi ri quiwach. Na jampatana cꞌu riꞌ xetzuꞌnic y xeterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ri Jesús cucꞌ rutijoꞌn xa nakaj chic e cꞌo che ri tinamit Jerusalem, ya e riꞌ queboc pa raldea Betfagé, ri cꞌo chwach ri juyub Olivos. Ecꞌuchiriꞌ, ri Jesús xebutak bi caꞌib chique rutijoꞌn chaꞌ quenabej apanok, ");
INSERT INTO acrTNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jewaꞌ xubiꞌij chique: «Jix pa raldea cꞌo pan chikawach. Chiriꞌ quiꞌrika jun axna yukulic yey cꞌo ri ral rucꞌ. Chiquira lok y chebicꞌama lo chwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","We cꞌo cꞌu junok cutzꞌonoj chiwe saꞌ ri quiꞌano, jewaꞌ chibiꞌij che: “Rawaj quebajawax che ri Kajawal, yey cꞌate cutak tanchi ulok” quixchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E xuꞌan waꞌ chaꞌ e cuꞌana rubiꞌim can ri kꞌalajisanel echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chibiꞌij chique ri e aj Sion: “Chiwilapeꞌ, ri Rey iweꞌix cacꞌun iwucꞌ, uꞌanom lo chꞌutiꞌn che rib; ucojom lo jun buru, waꞌ jun kꞌapoj buru, ral jun awaj aj ekaꞌn” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ecꞌuchiriꞌ, xebec rutijoꞌn y xquiꞌano janipa ri xubiꞌij bi ri Jesús chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xquicꞌam cꞌu lo ri axna junam rucꞌ ri ral y xquirip ri quimanta chiquij. Tecꞌuchiriꞌ, ri Jesús xucoj bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Uqꞌuiyal winak xquiwik ri be pa quicꞌow wi ri Jesús, xquilicꞌ tak ri quimanta pa ri be; yey e cꞌo jujun chic xquikꞌat raltak co ukꞌab cheꞌ y xquilem pa la be re yacbal ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ecꞌu ri winak e nabe chwach cucꞌ ri eteran lo chirij xquijeko lic quesiqꞌuinic, caquibiꞌij: «¡Kayaca ukꞌij ri Ralcꞌoꞌal can ri rey David! ¡Nim ukꞌij ralaxic ri jun petinak chupa rubiꞌ ri Dios Kajawxel! ¡Kayaca ukꞌij ri Dios cꞌo chilaꞌ chicaj!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Echiriꞌ xoc ri Jesús Jerusalem, xetucuc conoje ri winak re ri tinamit y lic e qꞌui ri caquitzꞌonobej chiquiwach: —¿China nawi wa jun achi? —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ecꞌu ri winak caquibiꞌij: —E ri kꞌalajisanel Jesús, ri aj Nazaret re Galilea —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ecꞌuchiriꞌ, xoc ri Jesús pa ri Rocho Dios y xeberesaj bi conoje ri quecꞌayinic y ri quelokꞌow chupa. Xucꞌakalaꞌ tak bi ri quimexa raj jachal uwach puak y tak ri quixila raj cꞌay palomax. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xubiꞌij cꞌu chique: «Ri Dios jewaꞌ cubiꞌij chupa Ruchꞌaꞌtem: Che ri Wocho cabiꞌxic: “E luwar re oración” cachaꞌ. Noꞌj ralak ꞌanom alak che ri Wocho e jun luwar que elekꞌomab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chiriꞌ cꞌu riꞌ chupa ri Rocho Dios, xekib rucꞌ ri Jesús jujun potzꞌ cucꞌ jujun sic, y ri Jesús xebucunaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab lic xpe coyowal echiriꞌ xquil wa milagros y xquito lic quesiqꞌuin racꞌalab pa ri Rocho Dios, caquibiꞌij: «¡Kayaca ukꞌij ri Ralcꞌoꞌal can ri rey David!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xquibiꞌij cꞌu riꞌ che ri Jesús: —¿Cata la saꞌ ri caquibiꞌij racꞌalab cheꞌla? —xechaꞌ. Ecꞌu ri Jesús xucꞌul uwach: —Katzij wi canto. ¿Na ajilam ta neba alak ri cubiꞌij Ruchꞌaꞌtem ri Dios paquiwi racꞌalab? Ma jewaꞌ cubiꞌij: Chiquichiꞌ racꞌalab y ri quetzꞌumanic yijbam la ri chomilaj bix re yacbal kꞌij la —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ecꞌuchiriꞌ, xebuya canok y xel bi pa ri tinamit; xeꞌec cꞌu Betania y chiriꞌ xcanaj can wi la jun akꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Anim tan, echiriꞌ ri Jesús catzelej tanchi pa ri tinamit, xpe numic che. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xril cꞌu jun cheꞌ re higo cꞌo chuchiꞌ ri be. Xeꞌrilaꞌ cꞌut yey na xurik ta tob xa juna uwach ri cheꞌ, xew ruxak cꞌolic. Ecꞌuchiriꞌ, xubiꞌij ri Jesús che ri cheꞌ: —¡Na jinta chi cꞌana ajikꞌobalil cayaꞌo! —xchaꞌ. Y na jampatana xchakij ri cheꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Echiriꞌ xquil waꞌ rutijoꞌn, lic xcam canimaꞌ che y xquitzꞌonoj cꞌu che: —¿Chaꞌtaj xchakij tan wa cheꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij chiwe: We ta lic cꞌo cubulibal icꞌuꞌx rucꞌ ri Dios y na queb ta cꞌana ipa rucꞌ, riꞌ na xew ta jewaꞌ quiꞌan riꞌix pachaꞌ wa xinꞌan riꞌin che ri higo. Ma utz ne riꞌ quibiꞌij che wa juyub: “Chatela wara y jateꞌcꞌola chupa ri mar” quixchaꞌ y e cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jecꞌulaꞌ riꞌ, e janipa ri quitzꞌonoj che ri Dios rucꞌ cubulibal icꞌuꞌx, quicꞌul na —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Echiriꞌ xopon ri Jesús pa ri Rocho Dios, xujek cacꞌutunic. Ecꞌu ri nimak e aj chacunel re ri Rocho Dios cucꞌ ri nimak winak re ri tinamit xekib rucꞌ y xquitzꞌonoj che: —¿China xyaꞌw pakꞌab la caꞌan tak la waꞌ? ¿China xtakaw la che caꞌan tak la waꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xucꞌul uwach: —Riꞌin canꞌan jun tzꞌonobal che alak. We xcꞌul alak uwach chwe, cambiꞌij cꞌu riꞌ che alak china yaꞌyom panukꞌab canꞌan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿China cꞌu xtakaw re ri Juan cuya ri bautismo? ¿E ri Dios o e rachijab? —xchaꞌ. Ecꞌu rique xquijek quechꞌaꞌt chiquiwach puwi waꞌ: «We xkacꞌul uwach che: “E ri Dios xtakaw re”, riꞌ cubiꞌij rire chike: “¿Suꞌchac cꞌu riꞌ na xcoj ta alak ri xubiꞌij?” cacha chike. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yey cakaxiꞌij kib cakabiꞌij: “Xa achijab xetakaw re” ma conoje ri tinamit caquichꞌobo ri Juan e jun kꞌalajisanel re ri Dios» xecha chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Xquibiꞌij cꞌu che ri Jesús: —Na ketaꞌam taj —xechaꞌ. Ecꞌu ri Jesús xubiꞌij chique: «Jecꞌuriꞌlaꞌ, riꞌin na cambiꞌij ta che alak china yaꞌyom panukꞌab canꞌan tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","»Yey chiwach ralak ¿saꞌ queꞌelawi waꞌ? Cꞌo jun achi e cꞌo caꞌib ucꞌajol y xubiꞌij che jun chique: “Nucꞌajol, jat wakꞌij pa chac, ma canꞌan numolonic re uva.” ");
INSERT INTO acrTNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","»Rucꞌajol xucꞌul uwach: “Na cuaj taj” xchaꞌ. Pero cꞌate na xujalcꞌatij runaꞌoj y xeꞌec pa ruchac rukaw. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tecꞌuchiriꞌ, rachi xkib rucꞌ ri jun chic ucꞌajol y xubiꞌij che pachaꞌ ri xubiꞌij che ri ratzixel. »Ecꞌu rala xucꞌul uwach: “Utz riꞌ, tat, quinꞌec pa ri chac” xchaꞌ. Yey na xeꞌec ta cꞌu riꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Xutzꞌonoj cꞌu ri Jesús chique ri e aj wach: —Chiwach ralak, ¿china nawi chique wa caꞌib alabo e xuꞌan ri caraj ri quikaw? —xchaꞌ. Xquibiꞌij cꞌu rique: —E ri nabe —xechaꞌ. Ecꞌu ri Jesús xubiꞌij chique: «Pakatzij wi cambiꞌij chiwe: E raj tzꞌonol puak re tojonic y rixokib na chom ta ri quibinic quisilabic, e rique ri nabe nenareꞌ queboc chupa rutakanic ri Dios chiwach ralak. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ma ri Juan Aj Yaꞌl Bautismo xcꞌun chiwach ralak, xoluꞌcꞌutuꞌ suꞌanic cajekiꞌ alak chi jusucꞌ che ruwachulew, yey ralak na xcoj ta alak. Noꞌj cꞌu raj tzꞌonol puak re tojonic y rixokib na chom ta ri quibinic quisilabic, rique xquicojo. Ecꞌu ralak, tob xil alak waꞌ, na xjalcꞌatij ta ri naꞌoj alak chaꞌ cacoj alak rutzij. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","»Tape alak wa jun chic cꞌambal naꞌoj: Cꞌo jun achi rajaw jun ulew. Ecꞌu rire xuꞌan ticoꞌn re uva chwach. Xusut rij rucꞌ coral, xucꞌot jun luwar pa cayitzꞌ wi ruwaꞌal ri uva y xuyac jun ja naj uwiꞌ re chajibal re. Xuya cꞌu can pa tunulic chique jujun aj chaquib. Tecꞌuchiriꞌ, xeꞌec naj. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","»Echiriꞌ xopon rukꞌijol ri molonic, xebutak lo jujun raj chaquib chaꞌ caquitzꞌonoj chique raj tunulel ri takalic cucꞌul rire che ri molonic. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Noꞌj raj tunulel xequichap raj chaquib ebutakom lok. Lic xquiꞌan cꞌax che jun chique, xquicamisaj jun chic y cꞌo jun chic xquiꞌan paꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","»Ecꞌu ri rajaw xebutak tanchi lo más aj chaquib, yey waꞌ más e qꞌui chwa ri xebutak lo nabe. Ewi raj tunulel je tanchi laꞌ xquiꞌano pachaꞌ ri xquiꞌan chique ri e nabe. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","»Qꞌuisbal cꞌu re, ri rajaw ri ticoꞌn e xutak lo rucꞌajol cucꞌ raj tunulel, ma xuchꞌobo: Caquicꞌul na chi utz wa nucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","»Noꞌj raj tunulel echiriꞌ xquil uwach rucꞌajol, jewaꞌ xquibiꞌij chiquiwach: “Waꞌ e ucꞌajol ri rajaw rulew, ri cuꞌana na rajaw we xcam rukaw. Joꞌ jeꞌkacamisaj chaꞌ rulew cuꞌan can keꞌoj” xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","»Ewi xquichapo, xquesaj bi chupa waꞌ wuꞌlew y xquicamisaj» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tecꞌuchiriꞌ, xutzꞌonoj chique ri e aj wach: —Chiwach ralak, echiriꞌ cacꞌun ri rajaw rulew, ¿saꞌ nawi cuꞌan chique raj tunulel? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rique xquicꞌul uwach: —Na cucuy ta cꞌana quimac. Cusach na cꞌu quiwach ri itzel quiwachlibal y cuya tanchi ri rulew pa tunulic chique jujun chic aj chaquib, yey rique caquiya na ri molonic che chupa rukꞌijol —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tecꞌuchiriꞌ, xubiꞌij ri Jesús chique: —¿Na ajilam ta neba ralak ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ cubiꞌij: E rabaj cꞌakital can cuma raj yacal ja, e abaj waꞌ lic xajawaxic chaꞌ catiquiꞌ lo ri ja. Waꞌ e ri Dios Kajawxel xꞌanaw re y riꞌoj lic cacam kanimaꞌ che cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ecꞌu uwariꞌche cambiꞌij che alak: Camajataj na cꞌu che alak rutakanic ri Dios y cayaꞌtaj chique jujun chic tinamit chaꞌ cuya ri jikꞌobalil caraj ri Dios che rutakanic. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","China cꞌu ri catzak puwi laꞌ laꞌbaj, lic cꞌax ri cucꞌulumaj; yey we rabaj catzak puwi junok, riꞌ xa jumul cusach uwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Echiriꞌ ri nimak e aj chacunel pa Rocho Dios cucꞌ ri fariseos xquita tak ri cꞌambal naꞌoj xutzijoj ri Jesús, xquimaj usucꞌ chiquij rique xbiꞌx wi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ruma cꞌu riꞌ waꞌ, lic xcaj caquichap ri Jesús; noꞌj e xquixiꞌij quib chique ri tinamit ma rique caquichꞌobo ri Jesús e jun kꞌalajisanel re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ri Jesús xujek tanchic cacꞌutun rucꞌ tak cꞌambal naꞌoj chiquiwach, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ri cuꞌana chupa rutakanic ri Dios petinak chilaꞌ chicaj e pachaꞌ ri xucꞌulumaj jun rey echiriꞌ xuꞌan jun nimalaj nimakꞌij re rucꞌulaniquil rucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","»Echiriꞌ xopon ri kꞌij re ri cꞌulaniquil, ri rey xebutak bi ri raj chaquib cucꞌ ri esiqꞌuim pa ri cꞌulaniquil chaꞌ queꞌquibiꞌij chique quepetic, pero rique na xcaj taj xepetic. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","»Ewi xebutak tanchi ubi jujun chic raj chaquib, xubiꞌij bi chique: “Chibiꞌij chique ri esiqꞌuim chic: Ri kajaw uyijbam chi ronoje ri waꞌim; tak ri nawiloꞌib y tak ri mekꞌ etiꞌoꞌjirisam chic, ya xecamisaxic. Ronoje cꞌu riꞌ yijbital chic. Peta cꞌu alak riꞌ pa ri nimakꞌij re cꞌulaniquil” quixchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","»Noꞌj ri esiqꞌuim chic, na xeboc ta il che. Jun chique xeꞌrila ri rulew, jun chic xeꞌec pa cꞌayij. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yey jujun chic xequichap ri raj chaquib ri rey, lic xquiꞌan cꞌax chique y jelaꞌ xequicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","»Ecꞌuchiriꞌ xuta waꞌ ri rey, lic xpe royowal che. Xebutak cꞌu bi rusoldados re queꞌquisacha quiwach ri e camisanel y queꞌquiporoj ri quitinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","»Tecꞌuchiriꞌ, xubiꞌij chique ri raj chaquib: “Ronoje yijbital chi che ri cꞌulaniquil; noꞌj cꞌu ri esiqꞌuim nabe, na takal ta chi chique queboc pa ri nimakꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jix cꞌu riꞌ woꞌora pa tak nimabe y chebisiqꞌuij lo pa ri cꞌulaniquil janipa tak ri winak quebiriko” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","»Xebel cꞌu bi ri raj chaquib pa tak be y xequimol lo quichiꞌ conoje tak ri winak xequiriko xa tob e chinok; jecꞌuriꞌlaꞌ ri luwar pa caꞌan wi ri cꞌulaniquil xnoj che winak cꞌacꞌ esiqꞌuim. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ecꞌuchiriꞌ, xoc bi ri rey y xeril ri esiqꞌuim chic. Xril cꞌu jun achi cꞌo chiriꞌ y na ucojom ta rukꞌuꞌ re cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","»Xubiꞌij cꞌu che: “Wamigo, ¿chaꞌtaj xatoc lo wara we na acojom ta rakꞌuꞌ re cꞌulaniquil?” xchaꞌ. Noꞌj rachi na xchꞌaw ta qꞌuenok. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","»Ecꞌuchiriꞌ, xubiꞌij ri rey chique ri queniman chwa ri mexa: “Wa jun achi na uwikom ta rib, chiyutu tak ri rakan y rukꞌab y chicꞌaka bi pa ri kꞌekuꞌm. Chiriꞌ cꞌu riꞌ cokꞌ wi y cakichꞌichꞌ wi ruwi reꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","»Ma tob lic e qꞌui ri esiqꞌuim, xa e jujun ri echaꞌtal chique» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xebel cꞌu bi ri fariseos chiriꞌ y xquichꞌaꞌtibej chiquiwach suꞌanic caquicꞌam upa ri Jesús rucꞌ tak ri cubiꞌij chaꞌ caquicoj umac. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xequitak cꞌu bi ri quitijoꞌn rique junam cucꞌ jujun chique ri quitakem ri rey Herodes. Ecꞌu rique xquibiꞌij che ri Jesús: —Lal tijonel, riꞌoj ketaꞌam lic katzij ri cabiꞌij la y lic jusucꞌ cacꞌutun la chwi ri be re ri Dios. Yey na caxiꞌij tane ib la che tak ri caquibiꞌij ri ticawex; ma rilal junam quiwach quebil la conoje, tob cꞌo quiwach o na jinta quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Biꞌij cꞌu la chike: ¿Usucꞌ nawi cakaꞌan tojonic che ri nimalaj takanel re Roma o na usucꞌ taj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri Jesús, ruma retaꞌam ri retzelal quicꞌuꞌx, jewaꞌ xubiꞌij chique: —¡Xa queb palaj alak! ¿Suꞌchac cacꞌam alak nupa? ");
INSERT INTO acrTNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Cꞌutu pe alak chwe juna meyo re caꞌan tojonic rucꞌ —xchaꞌ. Ecꞌuchiriꞌ, xquicꞌut jun denario che. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ecꞌu ri Jesús xutzꞌonoj chique: —¿China re wa cꞌaxwach y china re wa biꞌaj cꞌo chwach wa meyo? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rique xquicꞌul uwach: —Re ri nimalaj takanel re Roma —xechaꞌ. Xubiꞌij cꞌu ri Jesús chique: —Yaꞌa alak che ri nimalaj takanel re Roma janipa ri takal che rire, yey yaꞌa cꞌu alak che ri Dios janipa ri takal che ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Echiriꞌ xquita waꞌ, lic xcam canimaꞌ che. Xquiya cꞌu can ri Jesús y xebec. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chupa cꞌu laꞌ la jun kꞌij, xecꞌun rucꞌ ri Jesús jujun chique ri saduceos, ri caquibiꞌij na jinta cꞌastajibal chique ri ecaminak. Xquitzꞌonoj cꞌu che ri Jesús, ");
INSERT INTO acrTNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","jewaꞌ xquibiꞌij: —Lal tijonel, ri Moisés xubiꞌij canok: “We cꞌo juna achi xcamic yey na e jinta can ralcꞌoꞌal, ecꞌu riꞌ ruchakꞌ cacꞌuliꞌ rucꞌ rixok malcaꞌn canok y jecꞌulaꞌ quecꞌojiꞌ ralcꞌoꞌal rucꞌ pubiꞌ ri ratz xcamic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","»Julaj e cꞌo wukub achijab quichakꞌ quib xejekiꞌ chikaxoꞌl. Ri nabe chique xcꞌuliꞌic yey ecꞌu riꞌ waꞌ xcamic y na e jinta can ralcꞌoꞌal rucꞌ ri rixokil. Ewi rucaꞌm xcꞌuliꞌ rucꞌ rixok malcaꞌn canok. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jelaꞌ cꞌu riꞌ rucaꞌm xcamic y na e jinta can ralcꞌoꞌal rucꞌ rixok. Yey je tanchi laꞌ xucꞌulumaj rurox, rucaj y chiquijujunal ri wukub achijab. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Qꞌuisbal cꞌu re, e xcam rixok. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","»Chupa cꞌu rukꞌijol ri cꞌastajibal, ¿chinok chique ri wukub achijab cuꞌana rachijil rixok? Ma conoje xecꞌuliꞌ rucꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús xucꞌul uwach: —Ralak lic sachinak alak, ma na majom ta alak usucꞌ Ruchꞌaꞌtem ri Dios y ruchukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ma echiriꞌ quecꞌastaj lo ri ecaminak, na quecꞌuliꞌ ta chic yey na quequiya ta chi ne ri calcꞌoꞌal pa cꞌulaniquil; quebuꞌana cꞌu pachaꞌ ri ángeles re ri Dios chilaꞌ chicaj, ma ri ángeles na quecꞌuliꞌ taj. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yey puwi ri cꞌastajibal que ri ecaminak, ¿na ajilam ta neba alak rubiꞌim ri Dios echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“In ri Dios re ri Abraham, re ri Isaac y re ri Jacob”? Yey ri Dios na e ta Dios que ri ecaminak, ma e Dios que ri e cꞌaslic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Echiriꞌ xquita waꞌ, ri winak lic xcam canimaꞌ che tak rucꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ri fariseos xquimol quib echiriꞌ xquetaꞌmaj ri saduceos na xquirik ta chi ucꞌulic uwach ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Cꞌo cꞌu jun chique raj cꞌutunel re ri tzijpixab xraj xucꞌam upa ri Jesús, jewaꞌ xutzꞌonoj che: ");
INSERT INTO acrTNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Lal tijonel, chupa Rutzij Upixab ri Dios, ¿pachique ri takanic más chirajawaxic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xubiꞌij che: —“Cꞌax chanaꞌa ra Dios Kajawxel rucꞌ ronoje awanimaꞌ, rucꞌ ronoje acꞌuꞌx y rucꞌ ronoje anaꞌoj.” ");
INSERT INTO acrTNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Waꞌ e nabe tzijpixab lic chirajawaxic y e ucꞌuꞌxibal Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yey rucaꞌm jewaꞌ cubiꞌij: “Cꞌax chanaꞌa rawatz-achakꞌ jelaꞌ pachaꞌ ri cꞌax canaꞌ awib riꞌat.” ");
INSERT INTO acrTNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ucabichal waꞌ e ucꞌuꞌxibal Rutzij Upixab ri Dios tzꞌibital can ruma ri Moisés y cuma ri kꞌalajisanelab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ecꞌuchiriꞌ cꞌa quimolom quib ri fariseos, ri Jesús xutzꞌonoj chique: ");
INSERT INTO acrTNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Saꞌ ri cachꞌob alak chwi ri Cristo, Ruchaꞌoꞌn lo ri Dios? ¿China che upetebem wi lo rire? —xchaꞌ. Xquicꞌul cꞌu uwach: —E ralcꞌoꞌal can ri rey David —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ecꞌuchiriꞌ, ri Jesús xutzꞌonoj chique: —¿Chaꞌtaj cabiꞌx che ri Cristo e ralcꞌoꞌal can ri David? Ma ruma ri Ruxlabixel ri Dios, ri David xubiꞌij “Wajawal” che ri Cristo echiriꞌ rire xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Dios Kajawxel xubiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwiquikꞌab, y chawoyeꞌej na ri kꞌij echiriꞌ quebenuya ri tzel quebilow awe chuxeꞌ rawakan” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ecꞌu ri David cubiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbe cꞌu riꞌ cabiꞌxic e Ralcꞌoꞌal can ri rey David? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y na jinta junok xrikow ucꞌulic uwach. Chwi cꞌu riꞌ laꞌ la jun kꞌij, conoje caquixiꞌij quib caquiꞌan tzꞌonobal che. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique ri winak y chique rutijoꞌn: ");
INSERT INTO acrTNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Raj cꞌutunel re ri tzijpixab y ri fariseos yaꞌtal paquikꞌab caquikꞌalajisaj tak rutzijpixab can ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ruma cꞌu riꞌ, riꞌix chiꞌana janipa ri caquibiꞌij puwi wa tzijpixab; noꞌj miꞌan cꞌu iweꞌix ri na utz taj caquiꞌan rique, ma junwi ri caquiꞌan rique chwa ri caquicꞌutu. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","»Ri quitakanic rique e pachaꞌ nimak tak ekaꞌn lic al y lic cꞌayew rucꞌaxic; quequitak cꞌu ri winak chaꞌ caquekaj bi yey rique na cacaj tane cꞌana quetoꞌb rucꞌ waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","»Ronoje tak ri caquiꞌano xew e chaꞌ quebilitaj cuma ri winak. Caquiꞌan che quib pachaꞌ lic e jusucꞌ chwach ri Dios; ruma cꞌu laꞌ, e ri quifilacterias ximital chucurusil ri quipalaj y che ri quikꞌab, lic caquiꞌan nim che; yey tak ri cordón carabab che ri quikꞌuꞌ, caquiꞌan lic naj rakan che. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pa tak ri sinagogas y pa tak waꞌim, lic e cucꞌul quicꞌuꞌx quetzꞌuyiꞌ chupa ri tzꞌulibal que ri lic cꞌo quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yey lic cucꞌul quicꞌuꞌx cayaꞌ rutzil quiwach pa quebilitaj wi y cabiꞌx chique: “¡Lal tijonel!” ");
INSERT INTO acrTNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","»Ecꞌu riꞌix miwoyꞌej cabiꞌx “¡Lal tijonel!” chiwe, ma xa jun ri tijonel iwe, waꞌ e ri Cristo. Yey ruma Rire xixuꞌan iwatz-ichakꞌ iwib. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mibiꞌij “Nukaw” che junok wara che ruwachulew, ma xa jun Rikaw cꞌolic, y waꞌ e Rikaw cꞌo chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Miya luwar cabiꞌx “¡Lal Aj Cꞌamal Kawach!” chiwe, ma xa jun ri Aj Cꞌamal Iwach, waꞌ e ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","»Ecꞌu ri cꞌo uwach chixoꞌlibal riꞌix e chuyaꞌa rib cuꞌan nimanel iweꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma china ri lic cuꞌan nim che rib, ri Dios cukasaj uwa ukꞌij; noꞌj china ri cuꞌan chꞌutiꞌn che rib, ri Dios cuyac ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","»¡Lic cꞌu tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! E tzꞌapim alak ri oquibal re rutakanic ri Dios petinak chilaꞌ chicaj chaꞌ na jinta cꞌo queboc bi; ma na coc tane ubi ralak y na caya tane alak luwar chique jujun chic queboc bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ma camaj alak ri cocho rixokib e malcaꞌnib. Yey chaꞌ na cakꞌalajin ta ri na utz taj caꞌan alak, e cawererej alak unimal chꞌabal echiriꞌ caꞌan alak orar. Ruma cꞌu wa caꞌan alak, lic unimal cꞌaxcꞌolil cacꞌul na alak echiriꞌ cakꞌat tzij pawiꞌ alak ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ralak cakꞌaxuj alak uwi tak mar y cabinibej alak tak ri luwar che ruwachulew chaꞌ juna ticawex cuꞌan tijoꞌn alak. Yey echiriꞌ uꞌanom chi tijoꞌn alak, caꞌan alak che ri ticawex calaj más itzel uwachlibal chiwach ralak. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","»Lic tokꞌoꞌ wach ralak alak pachaꞌ potzꞌ cꞌamal quiwach jujun chic, ma cabiꞌij alak: “We cꞌo junok cujiquibaꞌ uwach juna tzij pa rubiꞌ ri Rocho Dios, riꞌ na chirajawaxic ta che cuꞌan ri ubiꞌim; noꞌj we cujiquibaꞌ uwach juna tzij pa rubiꞌ ri oro re ri Rocho Dios, riꞌ chirajawaxic che cuꞌan janipa ri ubiꞌim” cacha alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","»¡Na jinta naꞌoj alak y alak potzꞌ! ¿Pachique ri más cꞌo uwach? ¿E ri oro o e ri Rocho Dios, ri cuꞌan santo che ri oro? ");
INSERT INTO acrTNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jenewaꞌ ri cabiꞌij ralak: “We cꞌo junok cujiquibaꞌ uwach juna tzij pa rubiꞌ raltar, na chirajawaxic ta che cuꞌan ri ubiꞌim; noꞌj we cujiquibaꞌ uwach juna tzij pa rubiꞌ ri kasaꞌn cꞌo chwi raltar, riꞌ chirajawaxic che cuꞌan janipa ri ubiꞌim” cacha alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","»¡Sachinak ri naꞌoj alak y alak potzꞌ! ¿Pachique ri más cꞌo uwach? ¿E ri kasaꞌn o e raltar ri cuꞌan santo che ri kasaꞌn? ");
INSERT INTO acrTNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma china ri cujiquibaꞌ uwach juna tzij pa rubiꞌ raltar, riꞌ na xew ta cuꞌan pa rubiꞌ raltar, ma cuꞌan pa rubiꞌ ronoje ri cꞌo chwi raltar. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jecꞌulaꞌ, china ri cujiquibaꞌ uwach juna tzij pa rubiꞌ ri Rocho Dios, na xew ta cuꞌan pa rubiꞌ ri Rocho Dios, ma riꞌ e cuꞌan tzij pa rubiꞌ ri Dios, ri Jun jekel chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jecꞌulaꞌ, china ri cujiquibaꞌ uwach juna tzij pa rubiꞌ ri caj, riꞌ cuꞌan pa rubiꞌ ri tzꞌulibal pa catakan wi ri Dios y cuꞌan pa rubiꞌ ri Jun tzꞌul chupa. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ma caya alak che ri Dios ri diezmo alak re ri arweno, re ri anix y re ri cominox. Noꞌj na coc ta alak il che rucꞌuꞌxibal ri Tzij Pixab re ri Dios: Waꞌ e ri caꞌan alak ri usucꞌ, ri cacꞌut alak ri cꞌaxnaꞌbal cꞌuꞌx alak chique jujun chic y ri cacubiꞌ cꞌuꞌx alak rucꞌ ri Dios. Lic chirajawaxic cꞌu riꞌ caꞌan alak tak waꞌ, junam rucꞌ ri caya ri diezmo alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","»¡Alak pachaꞌ potzꞌ cꞌamal quiwach jujun chic! Ma ri caꞌan alak e pachaꞌ junok lic cuchajij rib chaꞌ na cubikꞌ tubi tob xa juna ralco us, pero cubikꞌ bi ri nimak tak awaj pachaꞌ ri camello. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ma xew cachꞌaj alak chi utz ri rij ri vaso y ri lak, pero na coc ta alak il che uchꞌajic rupa. Jecꞌuriꞌlaꞌ ralak lic coc alak il che ri joskꞌinic re ri cuerpo, pero lic cꞌo chꞌulil pa animaꞌ alak ruma relekꞌ y ri na usucꞌ taj ꞌanom alak. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Rilal fariseo, lal potzꞌ! Nabe na chꞌaja la rupa ri vaso y ri lak; jecꞌuriꞌlaꞌ cuꞌan chom rupa y ri rij. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ma ralak alak pachaꞌ mukubal que animaꞌ xew ꞌanom sak che ri rij; chom catzuꞌnic, noꞌj cꞌu rupa nojinak che quibakil animaꞌ y che uqꞌuiyal chꞌul. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jecꞌulaꞌ ri ꞌanom ralak, ma ri binic silabic alak e quilitajic pachaꞌ lic jusucꞌ chiquiwach ri winak; noꞌj xa queb palaj alak, ma ri cꞌuꞌx alak nojinak che uqꞌuiyal chꞌulil. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","»¡Lic tokꞌoꞌ wach alak aj cꞌutunel re ri tzijpixab y alak fariseos! ¡Xa queb palaj alak! Ma cayac alak chomilaj mukubal chique ri kꞌalajisanelab re ojertan y cawik alak ri mukubal que ri ticawex lic jusucꞌ xebinic. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yey cabiꞌij cꞌu alak: “We ta oj cꞌo chi riꞌoj echiriꞌ xecꞌasiꞌ ri katiꞌ-kamam ojertan, na cakaꞌan ta keꞌoj riꞌ cucꞌ ri xecamisan ri kꞌalajisanelab” cacha alak. Pero ¡na e ta cꞌana uꞌanom! ");
INSERT INTO acrTNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Rucꞌ cꞌu ri catajin alak che uꞌanic, cakꞌalajinic alak calcꞌoꞌal can ri xecamisan que ri kꞌalajisanelab. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Qꞌuisa cꞌu alak uꞌanic riꞌ ri na utz taj xquijek lo uꞌanic ri chuꞌkaw alak ojertan! ");
INSERT INTO acrTNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","»¡Ralak pachaꞌ alak jupuk chi cumatz! ¿Suꞌanic quesaj ib alak chuxeꞌ ri kꞌatbal tzij re ri Dios echiriꞌ cutak bi alak chi xibalbaꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","E uwariꞌche riꞌin quebenutak lo ucꞌ alak kꞌalajisanelab, waj chac lic cꞌo quinaꞌoj y aj cꞌutunel re Rutzij Upixab ri Dios. Pero ralak quecamisaj alak jujun chique rique. E cꞌo ne ri quecamisaj alak chwa cruz, jujun chic cajichꞌ alak quipa pa tak sinagogas y jujun chic queternabej alak rucꞌ cꞌaxcꞌobic pa tak tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ruma cꞌu riꞌ cape pawiꞌ alak ronoje ri cꞌaxcꞌobic takal chique ri xecamisan que rachijab jusucꞌ xebinic, ujekebem lo chwi rucamic ri Abel ri jun ala lic jusucꞌ, cꞌa chwa rucamic ri Zacarías, rucꞌajol ri Berequías, ri xcamisaj alak chuxoꞌl raltar y ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Pakatzij wi cambiꞌij che alak: Ronoje waꞌ cape paquiwi ri winak e cꞌo wakꞌij ora» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tecꞌuchiriꞌ, xubiꞌij: «¡Jerusalem, Jerusalem, riꞌix quebicamisaj ri kꞌalajisanelab y quebiꞌan paꞌbaj janipa ri ebutakom lo ri Dios iwucꞌ! E riꞌin, uqꞌuiyal laj lic xuaj xinmol quichiꞌ riwalcꞌoꞌal riꞌix, jelaꞌ pachaꞌ cuꞌan juna atiꞌ acꞌ chique tak ruwiꞌch echiriꞌ cumol quichiꞌ chuxeꞌ tak ruxicꞌ; pero riꞌix na xiwaj ta qꞌuenok. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","»Chitape cꞌut: Cꞌo jun kꞌij ri iwocho riꞌix cawulix canok. ");
INSERT INTO acrTNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Cambiꞌij cꞌu chiwe riꞌix: Chwi cꞌu woꞌora na quiwil ta chi cꞌana nuwach riꞌin cꞌa echiriꞌ copon na rukꞌijol quibiꞌij riꞌix: Lic nim ukꞌij ri jun petinak chupa rubiꞌ ri Dios Kajawxel quixchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Echiriꞌ xel bi ri Jesús pa ri Rocho Dios yey e riꞌ queꞌec, xekib rutijoꞌn rucꞌ re caquicꞌut che, ruchomalil ri nimak tak ja re ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ecꞌu ri Jesús xucꞌul uwach: —¿Quiwil riꞌix ronoje waꞌ? Pakatzij wi cambiꞌij chiwe, wara na cacanaj ta chi can juna abaj puwi juna chic, ma ronoje cawulixic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tecꞌuchiriꞌ, xebopon chwa ri juyub Olivos. Yey echiriꞌ xtzꞌuyiꞌ ri Jesús, xekib rutijoꞌn rucꞌ, y ecꞌu laꞌ xa quituquel xquijek caquitzꞌonoj che: —Biꞌij co la chike, ¿jampa nawi cuꞌana tak riꞌ waꞌ? ¿Yey saꞌ ri cꞌutubal re ri cꞌunibal la y re ri qꞌuisbal re ruwachulew? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ecꞌu ri Jesús xucꞌul uwach: «Lic chichajij iwib chaꞌ na jinta junok casocow iweꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ma lic e qꞌui ri ticawex quecꞌunic y xa caquichikꞌimaj uwach ri nubiꞌ, jewaꞌ caquibiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios” quechaꞌ. Y lic e qꞌui ri quesocotaj cuma rique. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","»Quita cꞌu riꞌ cꞌo chꞌaꞌoj jewaꞌ y cꞌo chꞌaꞌoj jelaꞌ. Mixiꞌij cꞌu iwib che, ma lic chirajawaxic wi cuꞌana tak waꞌ; noꞌj na e ta waꞌ ri qꞌuisbal re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ma e cꞌo tinamit queyactaj chiquij jujun chic tinamit y e cꞌo takanelab queyactaj chiquij jujun chic takanelab. Cape cꞌu numic y yabil yey cuꞌan tak cabrakan che uqꞌuiyal luwar. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ronoje waꞌ e jekebal re tak ri cꞌaxcꞌobic cacꞌunic. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","»Ecꞌuchiriꞌ, quixyaꞌ riꞌix pa tak cꞌaxcꞌobic y quixcamisaxic; yey conoje tak ri tinamit che ruwachulew lic tzel quixquilo ruma icojom ri nubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chupa tak laꞌ laꞌ kꞌij, lic e qꞌui ri caquesaj quib chirij ri Dios, caquijek lic tzel caquil quib chiquiwach y caquicꞌayij quib chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","»Lic e qꞌui ri kꞌalajisanelab xa e socosoꞌnel queyactajic y lic e qꞌui ri winak quesocotaj cuma rique. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ruma cꞌu ruqꞌuiyaric tak uwach ri mac, lic e qꞌui ri cakꞌob ri rutzil cꞌuꞌxaj pa canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","China cꞌu ri lic cuchukꞌubej rib chwach tak waꞌ wa cꞌaxcꞌobic cꞌa chupa ri qꞌuisbal re, e riꞌ ri cacolobetajic. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","»Yey wa Utzilaj Tzij re rutakanic ri Dios catzijox na chique ruqꞌuiyal quiwach tak ri ticawex e cꞌo che ruwachulew chaꞌ conoje caquetaꞌmaj cꞌu riꞌ waꞌ; tecꞌuchiriꞌ, cacꞌun lo ri qꞌuisbal re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","»E uwariꞌche echiriꞌ quiwil riꞌix ri lic chꞌul y lic qꞌuixbal uwach cayaꞌ chupa ri Luwar Santo, jelaꞌ pachaꞌ ri xutzꞌibaj can ri kꞌalajisanel Daniel; (china cꞌu ri cajilan re waꞌ, chumaja usucꞌ), ");
INSERT INTO acrTNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ecꞌu ri e cꞌo pa tak ri luwar re Judea chebanimaj ubi chwa tak ri juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","China cꞌu ri cꞌo lo chwi ri rocho, makaj ne lo che ucꞌamic bi ubitak re pa ja. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yey china ri cꞌo lo pa juyub, matzelej ne lo che ucꞌamic bi rukꞌuꞌ re pisbal rij. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","»Chupa tak cꞌu laꞌ la kꞌij, lic tokꞌoꞌ quiwach ri e yewaꞌ ixokib y ri quetzꞌumtisanic. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lic cꞌu chitzꞌonoj che ri Dios chaꞌ echiriꞌ quixanimaj bi, na e ta ukꞌijol echiriꞌ cꞌax tew y cꞌo jab yey na chupa tane juna kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ma cacꞌun cꞌu jun unimal cꞌaxcꞌobic, waꞌ na uꞌanom ta cꞌana julajok chwi lo ri jekebal ruwachulew y na cuꞌana ta chi ne cꞌana julajok. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","We ta ri Kakaw Dios na cukꞌatij ta tak laꞌ la kꞌij re runimal cꞌaxcꞌobic, riꞌ na jinta junok cacꞌasiꞌ canok; pero ruma cꞌu cꞌax quebunaꞌ ri ebuchaꞌom, cukꞌatij rukꞌijol waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","»We cꞌo cꞌu junok riꞌ cabiꞌn chiwe: “¡Chiwilapeꞌ, wara cꞌo wi ri Cristo!” o “¡Chiwilapeꞌ, leꞌ cꞌolic!”, mixoc il che. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma quecꞌun ri caquiꞌan “Cristo” che quib y ri caquiꞌan “e kꞌalajisanelab re ri Dios” che quib, pero xa e socosoꞌnel. Ecꞌu rique caquiꞌan nimak tak cꞌutubal y milagros re quesocosoꞌn rucꞌ, yey cꞌo ne pa sak quesocotaj jujun chique ri ebuchaꞌom ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","»Chita cꞌu riꞌ ma ximbiꞌij waꞌ chiwe riꞌix echiriꞌ cꞌamajaꞌ ne cuꞌanaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","E uwariꞌche tob cabiꞌx chiwe: “Chiwilapeꞌ, leꞌ ri Cristo cꞌo pa ri luwar catzꞌintzꞌotic”, mixꞌec che rilic. Tob ne cabiꞌx chiwe: “Chiwilapeꞌ, leꞌ ri Cristo cꞌo lo pa ja”, mixoc il che. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ma jelaꞌ pachaꞌ echiriꞌ cayocꞌ caꞌn ruxeꞌ caj pa relebal lo ri kꞌij y quilitaj cꞌa putzakibal ri kꞌij, jelaꞌ cuꞌan rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma lic cakꞌalajin rucꞌunibal chiquiwach conoje ri winak; e jelaꞌ pachaꞌ lic cakꞌalajin pa cꞌo wi juna caminak, ma puwi waꞌ caquimol wi quib tak ri cꞌuch. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","»Xew cꞌu quicꞌow ri cꞌaxcꞌobic chupa tak laꞌ la kꞌij, cuꞌan kꞌekuꞌm uwach ri kꞌij, ri icꞌ na cuya ta chi ruwonibal, ri chꞌumil quetzak lo che ruwa caj yey conoje ri cꞌo quichukꞌab che ruwa caj queyiquiyoꞌxic. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ecꞌuchiriꞌ, quilitaj che ruwa caj ri cꞌutubal re rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. Conoje cꞌu ruqꞌuiyal quiwach tak ri ticawex e cꞌo che ruwachulew quebokꞌic y caquil cꞌu Ralaxel Chiquixoꞌl Ticawex cacꞌun lo pa sutzꞌ chwa ri caj rucꞌ ruchukꞌab y rucꞌ runimal uchomalil. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Quebutak cꞌu ru ángeles rucꞌ unimal uchꞌawibal trompeta re caquimol quichiꞌ conoje ri ebuchaꞌom ri Dios pa tak ronoje luwar che rucajchal rajlibal ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","»E chimaja ri jun cꞌambal naꞌoj puwi ri cheꞌ re higo: Echiriꞌ cujek catux lo cꞌacꞌ ukꞌab y cujek cꞌut catux ruxak, ruma cꞌu laꞌ quiwetaꞌmaj xa nakaj chi cꞌo wi lo rukꞌijol echiriꞌ cabucbutic y na jinta jab. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jecꞌuriꞌlaꞌ riꞌix, echiriꞌ quiwilo cuꞌana ronoje tak waꞌ, chiwetaꞌmaj cꞌu riꞌ xa nakaj chi cꞌo wi lo rukꞌijol rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Pakatzij wi cambiꞌij chiwe: E cꞌo ticawex che tak laꞌ la kꞌij na quecam tana we na caquil tubi ronoje waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ruwa caj y ruwachulew xa casach uwach, noꞌj tak ri nuchꞌaꞌtem na casach ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","»Ecꞌu chwi rukꞌijol y ruꞌorayil waꞌ, na jinta junok etaꞌmayom re; na quetaꞌam tane ri ángeles e cꞌo chilaꞌ chicaj, ma xew ri Nukaw etaꞌmayom re. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma jelaꞌ pachaꞌ ri xuꞌan chupa tak ri kꞌij re ri Noé, jelaꞌ cuꞌana pa rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ma chupa tak laꞌ la kꞌij echiriꞌ cꞌamajaꞌ cape ri unimal jab, tak ri winak xew caquitij quiwa, caquitij quiyaꞌ, quecꞌuliꞌic y quequiya ri calcꞌoꞌal pa cꞌulaniquil. Ecꞌu quetajin riꞌ che uꞌaniquil echiriꞌ xopon rukꞌijol xoc bi ri Noé chupa ri nimalaj barco. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na xquinaꞌbej tane ri xpe paquiwiꞌ, cꞌate cꞌu xquinaꞌo xcꞌun lo ri unimal jab; ri yaꞌ xebucꞌam bi ri winak y xecam cꞌu conoje. Jecꞌulaꞌ cuꞌano echiriꞌ cacꞌun tanchi Ralaxel Chiquixoꞌl Ticawex, ma xakicꞌateꞌt cacꞌunic. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","»Chupa cꞌu laꞌ la kꞌij, cꞌo cuꞌana wi e cꞌo queb achijab chwa juyub; jun cacꞌam bi y ri jun chic cayaꞌiꞌ canok. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","O e cꞌo queb ixokib junam quequeꞌnic, jun cꞌu cacꞌam bi y ri jun chic cayaꞌiꞌ canok. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lic cꞌut mawar iwach riꞌix, ma na iwetaꞌam ta ruꞌorayil rucꞌunibal ri Iwajawal. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","»Ecꞌu chiwetaꞌmaj waꞌ: Juna achi rajaw ja we ta caretaꞌmaj ri ora echiriꞌ copon relekꞌom, riꞌ na cawar ta qꞌuenok y na cuya ta luwar coc relekꞌom pa ri rocho. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E uwariꞌche riꞌix chiyijbaꞌ iwib che rucꞌunibal Ralaxel Chiquixoꞌl Ticawex, ma cꞌaxtaj cacꞌunic echiriꞌ na jinta inaꞌbem. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","»¿Chinok chiwe e pachaꞌ juna aj chac lic jusucꞌ y cꞌo unaꞌoj, ri yaꞌom pukꞌab quebutzuk chupa ruꞌorayil conoje ri e cꞌo pa rocho rupatrón? ");
INSERT INTO acrTNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lic cꞌu nim ukꞌij ralaxic riꞌ ri aj chac we xcꞌun lo rupatrón, coluꞌrikaꞌ catajin che uꞌanic ruchac. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma pakatzij wi cambiꞌij chiwe: Rupatrón cuꞌana takanel che rire puwi ronoje rubitak re. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","»Noꞌj we waꞌ wa jun aj chac cuꞌan ri na utz taj y cubiꞌij cꞌu pa ranimaꞌ: “Ri nupatrón cꞌamajaꞌ catzelej lok” ");
INSERT INTO acrTNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y cujek cꞌu quebuchꞌay ri rach aj chaquib; yey ecꞌu rire xew cawaꞌic y cakꞌabar cucꞌ kꞌabaꞌrelab, ¿saꞌ cꞌu riꞌ ri cucꞌulumaj? ");
INSERT INTO acrTNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Cacꞌun lo riꞌ rupatrón chupa ri kꞌij y ri ora echiriꞌ waꞌ wa aj chac na royeꞌem taj. ");
INSERT INTO acrTNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Cukꞌat cꞌu tzij riꞌ puwi ri raj chac y lic cuya pa cꞌax junam cucꞌ ri xa queb quipalaj, chiriꞌ cꞌu riꞌ cokꞌ wi y cakichꞌichꞌ wi ruwi reꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","»Ri cuꞌana pa rutakanic ri Dios petinak chilaꞌ chicaj, e jelaꞌ pachaꞌ ri xquicꞌulumaj lajuj kꞌapoj alito echiriꞌ xquicꞌam bi ri quicandil y xebec pa jun cꞌulaniquil re queꞌquicꞌulu rala cacꞌuliꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E cꞌo cꞌu woꞌob chique lic cꞌo quinaꞌoj y ri woꞌob chic na jinta quinaꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","»Ri woꞌob na jinta quinaꞌoj xquicꞌam bi ri quicandil, pero na xquicꞌam tubi aceite re caquinojisaj tanchic. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ecꞌu ri cꞌo quinaꞌoj quinojisam bi ri quicandil che aceite, yey pa rewi cucꞌaꞌam aceite pa jun chic cꞌolibal. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ecꞌu rala cacꞌuliꞌic xmayin che ri roponic. Ruma cꞌu riꞌ, ralito xquijeko queyuxcꞌaꞌtic y xoc lo quiwaram. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","»Pa tiqꞌuil akꞌab cꞌut, xtataj jun casiqꞌuinic, jewaꞌ cubiꞌij: “¡Rala xcꞌunic! ¡Chixela lo che ucꞌulic!” ");
INSERT INTO acrTNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Conoje cꞌu ri kꞌapoj alito xeyactajic y xquijek uyijbaxic ri quicandil. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","»Ecꞌu ri woꞌob alito na jinta quinaꞌoj jewaꞌ xquibiꞌij chique ri lic cꞌo quinaꞌoj: “Chiyaꞌa jubikꞌ kaceite che ri cꞌo iwucꞌ riꞌix, ma ri kacandil riꞌoj catajin uchupic.” ");
INSERT INTO acrTNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","»Noꞌj ri woꞌob chic jewaꞌ xquicꞌul uwach: “We cakaya iwe riꞌix, na cuꞌan ta riꞌ ke konoje. Jiꞌtzucuj cꞌu iweꞌix pa cacꞌayix wi y chilokꞌoꞌ.” ");
INSERT INTO acrTNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","»Ecꞌuchiriꞌ ebelinak bi ri woꞌob che ulokꞌic aceite, xcꞌun lo rala. Ralito cꞌo quinaꞌoj, ri quiyijbam chi pan ri quicandil, xeboc junam rucꞌ rala pa cꞌulaniquil y xtzꞌapix cꞌu lo ri puerta. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","»Tecꞌuchiriꞌ, xetzelej lo ri woꞌob alito y xechꞌaw apanok: “Kajawal, kajawal, jaka lo la ri puerta chike.” ");
INSERT INTO acrTNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","»Ecꞌu rala cacꞌuliꞌic xucꞌul lo uwach: “Pakatzij wi cambiꞌij chiwe: Na wetaꞌam ta cꞌana iwach.” ");
INSERT INTO acrTNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","»Mawar cꞌu iwach riꞌ riꞌix, ma na iwetaꞌam tane rukꞌijol y ruꞌorayil echiriꞌ cacꞌun lo Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","»Ri cuꞌana pa rutakanic ri Dios petinak chilaꞌ chicaj, e pachaꞌ ri xuꞌan jun achi echiriꞌ xeꞌec pa jun luwar lic naj; xebusiqꞌuij cꞌu ri raj chaquib y xuya can rupuak paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Che jun xuya can woꞌob mil, che jun chic xuya can caꞌib mil y che jun chic xuya can mil. Wa xyaꞌ can chique e chirij ri caquichꞌij uchacuxic. Ecꞌuchiriꞌ, xeꞌec naj. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","»Ecꞌu raj chac xcꞌamaw can ri woꞌob mil, xuꞌan ucꞌay rucꞌ y jelaꞌ xuchꞌac chi woꞌob mil puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jecꞌulaꞌ xuꞌan ri xcꞌamaw can queb mil, xuchꞌac chi queb mil puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Noꞌj ri xcꞌamaw can jun mil, xucꞌot jun jul y chupa waꞌ xrewaj ri puak yaꞌtal pukꞌab ruma ri rajaw. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","»Icꞌowinak chi cꞌu uqꞌuiyal kꞌij, xtzelej tanchi lo ri cajaw raj chaquib y xutzꞌonoj cꞌu chique saꞌ ri xquiꞌan rucꞌ rupuak. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nabe xopon ri raj chac ri ucꞌamom can woꞌob mil. Xuya cꞌu che ri rajaw ri woꞌob mil chic xuchꞌac puwi ri yaꞌom can che y jewaꞌ xubiꞌij: “Wajaw, riꞌ ri woꞌob mil xya can la chwe y riꞌ chi woꞌob mil, waꞌ e xinchꞌac puwi ri xya can la chwe” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","»Ri rajaw xubiꞌij cꞌu che: “Utz riꞌ, riꞌat at utzilaj waj chac y lic at jusucꞌ; ma jusucꞌ xachacuj ri xa jubikꞌ yaꞌtal can pakꞌab. E uwariꞌche woꞌora lic qꞌui ri canya pakꞌab. Chatocok y chatquiꞌcota wucꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","»Tecꞌuchiriꞌ, xopon raj chac ri ucꞌamom can caꞌib mil y xubiꞌij che: “Wajawal, riꞌ ri caꞌib mil xya can la chwe y riꞌ chi caꞌib mil canya cheꞌla, waꞌ e xinchꞌac puwi ri xya can la chwe” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","»Ri rajaw xubiꞌij cꞌu che: “Utz riꞌ, at utzilaj waj chac y lic at jusucꞌ; ma jusucꞌ xachacuj ri xa jubikꞌ yaꞌtal can pakꞌab. E uwariꞌche woꞌora lic qꞌui ri canya pakꞌab. Chatocok y lic chatquiꞌcota wucꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","»Ecꞌuchiriꞌ, xopon ri jun chic aj chac ri yaꞌom can xa jun mil che, y jewaꞌ xubiꞌij che ri rajaw: “Wajaw, riꞌin wetaꞌam lal jun achi lic titzꞌitic, ma caꞌan la molonic pa na awaninak ta wi la yey camolon ne la pa na jinta jopopem wi la. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","E uwariꞌche riꞌin lic xinxiꞌij wib. Xinꞌec cꞌut y xinmuk ri puak la pulew. Riꞌ ri mil yaꞌom can la chwe, ma e la” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","»Ri rajaw xubiꞌij che: “At jun waj chac lic na utz taj y at xepu. We xachꞌobo canꞌan molonic pa na in awaninak ta wi yey canmol pa na jinta nujopopem wi, ");
INSERT INTO acrTNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xaꞌyaꞌa ta cꞌu riꞌ ri nupuak pa juna banco chaꞌ echiriꞌ quintzelej lok, cancꞌul ri nupuak junam rucꞌ ruchꞌacom chic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","»Tecꞌuchiriꞌ, xubiꞌij chique jujun chic raj chac e cꞌo chiriꞌ: “Chimaja che wa jun aj chac ri mil cꞌo rucꞌ y chiyaꞌa che ri cꞌo lajuj mil rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ma china ri lic qꞌui cꞌo rucꞌ, cayaꞌiꞌ más che y jelaꞌ cacꞌojiꞌ ne uwiꞌ ri cꞌo rucꞌ. Noꞌj ri na jinta cꞌo rucꞌ, camaj ne che ri xa jubikꞌ cꞌo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ecꞌu waꞌ wa jun aj chac na jinta uchac, jiꞌcꞌaka bi pa ri kꞌekuꞌm; chiriꞌ cꞌu riꞌ cokꞌ wi y cakichꞌichꞌ wi ruwiꞌ reꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","»Echiriꞌ Ralaxel Chiquixoꞌl Ticawex cacꞌun rucꞌ runimal uchukꞌab cucꞌ conoje ri santowilaj ángeles, catzꞌuyiꞌ na cꞌu riꞌ chupa ri chomilaj tzꞌulibal re rutakanic. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Conoje tak cꞌu ri tinamit che ruwachulew caquimol quib chwach y Rire cujach quipa chiquijujunal, jelaꞌ pachaꞌ cuꞌan juna chajinel queberesaj ri bexex chiquixoꞌl ri caprux. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Quebuya cꞌu ri bexex puwiquikꞌab Rire yey ri caprux quebuya pumox. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","»Ecꞌuchiriꞌ, ri rey cubiꞌij chique ri e cꞌo puwiquikꞌab Rire: “¡Chixpetok! ¡Lic nim ikꞌij iwalaxic riꞌix! Chixoc cꞌu chupa rutakanic ri Dios y chicꞌulu janipa ri uyijbam chi pan chiwe chwi lo ri jekebal re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ma xincꞌojiꞌ pa numic y riꞌix xiya nuwa; xincꞌojiꞌ pa tzajin chiꞌ y riꞌix xiya numikꞌinaꞌ; xintzucuj pa quincanaj can wi y riꞌix xinicꞌul pa iwocho. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na jinta co nukꞌuꞌ y riꞌix xiya nukꞌuꞌ; xincꞌojiꞌ pa yabil y xixeꞌbina wucꞌ; xincꞌojiꞌ pa cárcel y xiniꞌwilaꞌ” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","»Ecꞌu ri e jusucꞌ echiriꞌ caquita waꞌ, jewaꞌ caquibiꞌij: “Kajawal, ¿jampalaꞌ xkil la lal cꞌo la pa numic y xkaya wa la? ¿Jampalaꞌ xkil la lal cꞌo la pa tzajin chiꞌ y xkaya mikꞌinaꞌ la? ");
INSERT INTO acrTNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jampalaꞌ xkil la catzucuj la pa cacanaj can wi la y xkacꞌul la pa kocho? ¿Jampalaꞌ xkil la na jinta kꞌuꞌ la y xkaya kꞌuꞌ la? ");
INSERT INTO acrTNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampalaꞌ xkil la lal yewaꞌ o cꞌo la pa cárcel yey xeꞌkila la?” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","»Y ri rey cucꞌul uwach chique: “Pakatzij wi cambiꞌij chiwe: Ronoje cꞌu ri xiꞌan chique wa watz-nuchakꞌ na jinta co quiwach, chwe riꞌin xiꞌan wi” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","»Ecꞌuchiriꞌ, cubiꞌij ri rey chique ri e cꞌo pumox: “Riꞌix itzel iwachlibal, chixela wucꞌ; quixꞌec cꞌu chupa ri akꞌ na cachup ta chic, ri yijbital chi pan che ritzel winak cucꞌ conoje ru ángeles eteran chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ma riꞌin xincꞌojiꞌ pa numic yey riꞌix na xiya ta nuwa; xincꞌojiꞌ pa tzajin chiꞌ, yey riꞌix na xiya ta numikꞌinaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Xintzucuj pa quincanaj can wi, yey riꞌix na xinicꞌul ta pa iwocho. Na jinta co nukꞌuꞌ, yey riꞌix na xiya ta nukꞌuꞌ. Xincꞌojiꞌ pa yabil y xincꞌojiꞌ pa cárcel, yey riꞌix na xiniꞌwila taj” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","»Ecꞌuchiriꞌ, caquibiꞌij rique che: “Kajawal, ¿jampalaꞌ xkil la canum la yey catzajin chiꞌ la? ¿Jampalaꞌ xkil la catzucuj la pa cacanaj can wi la? ¿Jampalaꞌ xkil la na jinta kꞌuꞌ la? ¿Jampalaꞌ xkil la lal yewaꞌ o cꞌo la pa cárcel, yey riꞌoj na xkanimaj ta la?” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","»Ri rey cucꞌul cꞌu uwach chique: “Pakatzij wi cambiꞌij chiwe: Ronoje ri na xiꞌan ta chique wa watz-nuchakꞌ na jinta co quiwach, chwe riꞌin na xiꞌan ta wi” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","»Conoje cꞌu riꞌ waꞌ quebec pa ri cꞌaxcꞌobic na jinta utakexic, noꞌj ri e jusucꞌ quebec pa ri cꞌaslemal na jinta utakexic» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Echiriꞌ ri Jesús xuqꞌuis ubiꞌxiquil ronoje waꞌ, jewaꞌ xubiꞌij chique rutijoꞌn: ");
INSERT INTO acrTNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Riꞌix iwetaꞌam pa queb kꞌij cacꞌun lo ri nimakꞌij Pascua; chupa cꞌu riꞌ wa nimakꞌij, Ralaxel Chiquixoꞌl Ticawex cayaꞌ pa camic chwa cruz» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ecꞌu ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab y ri nimak winak e aj wach re ri tinamit, xquimol quib che ruwa ja re ri palacio re ri Caifás, ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chiriꞌ xquichꞌaꞌtibej chiquiwach suꞌanic caquichap ri Jesús rucꞌ socosoꞌnic re caquicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xquibiꞌij cꞌu chiquiwach: «Na cakaꞌan ta pa ri nimakꞌij chaꞌ ri tinamit na quetucuc ta ruma waꞌ» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ri Jesús cꞌo pa ri tinamit Betania chirocho ri Simón, ri jun xcꞌojiꞌ ri yabil lepra che. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xcꞌun cꞌu jun ixok rucꞌaꞌam jun cꞌolibal nojinak che cunabal lic quiꞌ ruxlab y lic qꞌui rajil. Xkib cꞌu rucꞌ ri Jesús y xukꞌej ri cunabal chuꞌjolom echiriꞌ Rire tzꞌul chwa ri mexa. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Echiriꞌ xquil waꞌ rutijoꞌn, lic xpe coyowal che y jewaꞌ xquibiꞌij chiquiwach: —¿Suꞌchac wa cunabal xtzꞌiloꞌxic? ");
INSERT INTO acrTNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma ri lic usucꞌ e ta xcꞌayix waꞌ chi uqꞌuiyal puak, y rucꞌ cꞌu riꞌ quetoꞌ ri nibaꞌib —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ecꞌu ri Jesús retaꞌam saꞌ ri caquibiꞌij chiquiwach; ruma cꞌu riꞌ, jewaꞌ xubiꞌij chique: —¿Suꞌchac quixchꞌaꞌt chirij ri xuꞌan wiꞌxok? Ma ri xuꞌan chwe e jun utzilaj chac. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri nibaꞌib e laꞌ xaki e cꞌo iwucꞌ; noꞌj riꞌin na xaki ta in cꞌo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yey wa xuꞌan wiꞌxok echiriꞌ xukꞌej wa cunabal panuwiꞌ, waꞌ re uyijbaxic pan ri nucuerpo re ri mukubal we. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Pakatzij wi cambiꞌij chiwe: Pa tak catzijox wi wa Utzilaj Tzij che ronoje ruwachulew, cacuxtax cꞌu wiꞌxok ruma ri xuꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jun cꞌu chique ri cablajuj utijoꞌn ri Jesús, Judas aj Iscariot rubiꞌ, xeꞌec cucꞌ ri nimak e aj chacunel pa Rocho Dios ");
INSERT INTO acrTNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y jewaꞌ xubiꞌij chique: —¿Saꞌ ri caya alak chwe we canya ri Jesús pakꞌab alak? —xchaꞌ. Ecꞌu rique xquibiꞌij caquitoj treinta sakil puak re plata che. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chwi cꞌu riꞌ, ri Judas xujek utzucuxic suꞌanic cuya ri Jesús paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chupa cꞌu ri nabe kꞌij re ri nimakꞌij echiriꞌ catij ri pam na jinta levadura che, rutijoꞌn ri Jesús xekib rucꞌ y xquitzꞌonoj che: —¿Pa caꞌaj wi la queꞌkayijbaꞌ wi ri cena re ri nimakꞌij Pascua? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri Jesús xubiꞌij cꞌu chique: —Jix pa ri tinamit y chilaꞌ quiꞌrika jun achi; chibiꞌij cꞌu che: “Ri tijonel keꞌoj jewaꞌ cubiꞌij: Ri nukꞌijol riꞌin xa nakaj chi cꞌo wulok, y chupa ri ocho la canꞌan wi ri nimakꞌij Pascua junam cucꞌ ri nutijoꞌn” —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rutijoꞌn ri Jesús e xquiꞌano jelaꞌ pachaꞌ ri xebutak Rire che, xeꞌquiyijbaꞌ cꞌu ri cena re ri nimakꞌij Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Echiriꞌ xoc rakꞌab, ri Jesús xoc chwa ri mexa junam cucꞌ ri cablajuj utijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ecꞌuchiriꞌ quewaꞌic, ri Jesús xubiꞌij chique: —Pakatzij wi cambiꞌij chiwe: Cꞌo jun chiwe riꞌix cacꞌayin we —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ecꞌuchiriꞌ, rutijoꞌn lic xebuchap bis y xquijek chiquijujunal caquitzꞌonoj che: —Kajawal, ¿cꞌaxtaj in riꞌ? —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri Jesús xucꞌul uwach: —E ri cumuꞌ lo rupam junam wucꞌ chupa ri lak, e riꞌ ri cacꞌayin we riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Pakatzij wi Ralaxel Chiquixoꞌl Ticawex e catajin che ricꞌowibexic janipa ri tzꞌibital can puwi Rire chupa Ruchꞌaꞌtem ri Dios. Pero ¡lic tokꞌoꞌ uwach rachi cacꞌayin re! E ne más utz che waꞌchi tamaji xalaxic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ecꞌuchiriꞌ, xchꞌaw ri Judas, ri jun cucꞌayij ri Jesús, jewaꞌ xubiꞌij: —Wajawal, ¿cꞌaxtaj in riꞌ? —xchaꞌ. Ri Jesús xucꞌul uwach: —Areꞌ; at xatbiꞌn re —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Xalokꞌ cꞌu riꞌ quewaꞌic, ri Jesús xucꞌam ri pam y xutioxij che ri Dios. Tecꞌuchiriꞌ xuwechꞌo, xujach chique rutijoꞌn y jecꞌuwaꞌ xubiꞌij: —Chicꞌamaꞌ y chitijaꞌ, ma e nucuerpo waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tecꞌuchiriꞌ xucꞌam ri cꞌolibal cꞌo vino chupa, xutioxij che ri Dios, xuya chique y jecꞌuwaꞌ xubiꞌij: —Chitija iwonoje chuchiꞌ waꞌ wa cꞌolibal cꞌo vino chupa, ");
INSERT INTO acrTNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ma e nuquiqꞌuel waꞌ, ri caturuw na cuma uqꞌuiyal ticawex re cuybal quimac, yey e cujiquibaꞌ uwach ri cꞌacꞌ tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Y cambiꞌij cꞌu chiwe: Chwi woꞌora na cantij ta chi ruwaꞌal uva cꞌate quiꞌntija tanchi junam iwucꞌ chupa rukꞌijol rutakanic ri Nukaw —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Echiriꞌ xquiqꞌuis ubixoxic ri bix, xebec chwa ri juyub Olivos. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique: —Wakꞌab iwonoje riꞌix quiwesaj na iwib chwij, ma e pachaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios: Cancamisaj raj chajinel y tak rubexex caquiquich bi quib cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Noꞌj echiriꞌ quincꞌastaj lo chiquixoꞌl ri ecaminak, quinnabej bi chiwach cꞌa Galilea —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ecꞌu ri Pedro xucꞌul uwach: —Tob ne conoje caquesaj quib chiꞌij la, riꞌin na canꞌan ta cꞌana waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yey ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij chawe: Wa jun akꞌab echiriꞌ cꞌamajaꞌ ne cabixon ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Xubiꞌij cꞌu ri Pedro che: —Tob ne chirajawaxic quincam junam ucꞌ la, riꞌin na canwewaj taj wetaꞌam wach la —xchaꞌ. Jecꞌulaꞌ riꞌ xquibiꞌij conoje rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tecꞌuchiriꞌ, ri Jesús xebucꞌam bi rutijoꞌn pa jun luwar Getsemaní rubiꞌ, y xubiꞌij cꞌu chique: —Chixtzꞌula can wara, noꞌj riꞌin quiꞌnꞌana orar chileꞌ apanok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yey xebucꞌam cꞌu bi ri Pedro y ri queb ucꞌajol ri Zebedeo rucꞌ. Y xujek cꞌu riꞌ lic cabisonic y lic cacꞌaxcꞌob ri ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ecꞌuchiriꞌ, xubiꞌij chique: —Cꞌo jun unimal bis re camic chinucꞌuꞌx. Chixcꞌola can wara; mixwaric, e lic chiꞌana orar wucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tecꞌuchiriꞌ, Rire xkib chi pan jubikꞌ chwach, xuxucubaꞌ rib y xukasaj umejelem cꞌa chuꞌlew, y xuꞌan cꞌu orar, jewaꞌ xubiꞌij: «Lal Nukaw, ꞌana co la riꞌ chincolobej co la chaꞌ na quinicꞌow ta chupa waꞌ wa cꞌaxcꞌobic. Noꞌj na e ta cꞌu chuꞌana ri cuaj riꞌin, ma e chuꞌana janipa ri caꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tecꞌuchiriꞌ, xtzelej lo pa e cꞌo wi can rutijoꞌn y xeboꞌluꞌrikaꞌ quewaric. Xubiꞌij cꞌu che ri Pedro: —¿Lic cami na xichꞌij ta cꞌana ri waram chaꞌ quiꞌan orar wucꞌ, tob tane xa juna ora? ");
INSERT INTO acrTNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mixwar cꞌut y lic chiꞌana orar chaꞌ quichꞌij uchukꞌab ri cꞌambal ipa capetic. Pakatzij wi, lic cacha icꞌuꞌx che uꞌanic ri utz, pero waꞌ lic cꞌayew chiwe ma e ri itiꞌjil na jinta ucowil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xeꞌec tanchi chucalaj, xuꞌana orar, jewaꞌ xubiꞌij: «Lal Nukaw, we lic chirajawaxic quinicꞌow na che wa cꞌaxcꞌobic, e chuꞌana cꞌu riꞌ janipa ri caꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tecꞌuchiriꞌ, xtzelej tanchi lo cucꞌ rutijoꞌn y xeboꞌluꞌrikaꞌ quewaric, ma ri quiwach lic na cucuy ta chi ri waram. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xebuya tanchi canok y xuꞌana orar churox laj, yey e mismo ri xutzꞌonoj che ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ecꞌuchiriꞌ, xeꞌec tanchi pa e cꞌo wi can rutijoꞌn y xubiꞌij chique: —¿Cꞌa quixwar cami riꞌ riꞌix? ¿Cꞌa quixuxlanic? Ma e waꞌ xopon ruꞌorayil chaꞌ Ralaxel Chiquixoꞌl Ticawex cayaꞌ paquikꞌab raj maquib. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Chixwaꞌlijok! ¡Joꞌ! Ma ri cacꞌayin we riꞌin e laꞌ xcꞌunic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Cꞌa cachꞌaꞌt ne ri Jesús echiriꞌ xcꞌun lo ri Judas, jun chique ri cablajuj utijoꞌn. Ecꞌu rire erachbilam lo uqꞌuiyal winak cucꞌaꞌam lo espada y cheꞌ. Tak waꞌ etakom lo cuma ri nimak e aj chacunel pa Rocho Dios y cuma ri nimak winak re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ecꞌu ri Judas, ri cayaꞌw bi re paquikꞌab, ubiꞌim chi lo chique suꞌanic caquetaꞌmaj china ri caquichapo, jewaꞌ ubiꞌim: «E ri jun cantzꞌub uchiꞌ, e riꞌ rire. Chapa cꞌu bi alak.» ");
INSERT INTO acrTNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xkib cꞌu ri Judas rucꞌ ri Jesús y xuya rutzil uwach, xubiꞌij che: —Wajawal —xchaꞌ. Y xutzꞌub uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ecꞌu ri Jesús xubiꞌij che: —Wamigo, ¿saꞌ ri colaꞌanaꞌ? —xchaꞌ. Tecꞌuchiriꞌ, xekib ri winak rucꞌ y xquichapo chaꞌ caquicꞌam bi pa kꞌatbal tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Cꞌo cꞌu jun chique ri e cꞌo rucꞌ ri Jesús, xresaj lo ru espada y xujochij bi jun uxiquin ri raj chac ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ecꞌu ri Jesús xubiꞌij che: —Chacꞌolo ra espada chupa rucꞌolibal; ma conoje ri quechꞌoꞌjin rucꞌ espada, rucꞌ espada quecamic. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Na awetaꞌam ta cami, we ta cuaj riꞌin cantzꞌonoj che ri Nukaw woꞌora, Rire quebutak lo juna cablajuj legiones re ángeles wucꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Noꞌj we ta e xinꞌan riꞌ, ¿suꞌanic cꞌu riꞌ cuꞌana janipa ri cubiꞌij Ruchꞌaꞌtem ri Dios panuwi riꞌin? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ecꞌuchiriꞌ, xubiꞌij chique ri soldados: —¿Suꞌchac petinak alak rucꞌ espada y cheꞌ? ¿Petinak cami alak che ucꞌamic bi juna elekꞌom? Wa petinak lok ronoje kꞌij waꞌ cꞌut in tzꞌuyiꞌnak chiwach alak, e laꞌ quincꞌutun pa ri Rocho Dios. ¿Suꞌchac cꞌu riꞌ cꞌa e laꞌ quinoꞌlchapa alak? ");
INSERT INTO acrTNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Noꞌj jecꞌuwaꞌ cuꞌano chaꞌ e cuꞌana ri quikꞌalajisam can ri kꞌalajisanelab pa Ruchꞌaꞌtem ri Dios —xchaꞌ. Tecꞌuchiriꞌ, conoje rutijoꞌn xebanimajic y jelaꞌ xquiya can ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xechapaw bi ri Jesús xquicꞌam bi chwach ri Caifás, ri cajawal raj chacunel pa Rocho Dios, pa quimolom wi quib raj cꞌutunel re ri tzijpixab y ri nimak winak re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ecꞌu ri Pedro xa naj teran pan chirij ri Jesús, jelaꞌ xeꞌela che ruwa ja re ri rocho ri cajawal raj chacunel pa Rocho Dios. Xoc cꞌu bi y xeꞌtzꞌula cucꞌ ri e chajinel chaꞌ carilo saꞌ ri cuqꞌuisbej ronoje waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ri nimak e aj chacunel pa Rocho Dios cucꞌ tak ri nimak winak y conoje ri uchapom wi rib ri kꞌatbal tzij, caquitzucuj suꞌanic caquitzꞌak uchiꞌ ri Jesús chaꞌ jelaꞌ utz cakꞌat tzij re camic puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Noꞌj na jinta cꞌo xquirik chirij, tob uqꞌuiyal winak xquinucꞌ rakꞌubal chirij. Tecꞌuchiriꞌ, xebopon na caꞌib xeꞌquitzꞌaka uchiꞌ rucꞌ rakꞌubal, ");
INSERT INTO acrTNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jewaꞌ xquibiꞌij: —Waꞌ waꞌchi jewaꞌ xubiꞌij: “Riꞌin cꞌo panukꞌab canwulij ri Rocho Dios y xa pa oxib kꞌij canyac tanchic” —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ewi ri cajawal raj chacunel pa Rocho Dios xyactajic y xubiꞌij che ri Jesús: —¿E cami laꞌ na jinta cꞌana cabiꞌij riꞌat? ¿Saꞌ cꞌu ri cacꞌulubej uwach puwi wa quetajin che ucojic chawij? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noꞌj ri Jesús na jinta cꞌo xubiꞌij. Ecꞌuchiriꞌ, jewaꞌ xubiꞌij ri cajawal raj chacunel pa Rocho Dios: —Chabiꞌij chupa rubiꞌ ri Dios cꞌaslic, we riꞌat at ri Cristo, Rucꞌajol ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ri Jesús xubiꞌij che: —Areꞌ, e ri xbiꞌij la. Y cambiꞌij cꞌu che onoje alak: Quil na cꞌu alak Ralaxel Chiquixoꞌl Ticawex tzꞌul puwiquikꞌab ri Dios, ri lic cꞌo unimal uchukꞌab yey quil cꞌu alak riꞌ echiriꞌ cacꞌun lo pa sutzꞌ chwa ri caj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ecꞌu ri cajawal raj chacunel pa Rocho Dios xurichꞌij rukꞌuꞌ y xubiꞌij: —Waꞌ waꞌchi lic xmacun chirij ri Dios rucꞌ wa xubiꞌij. ¡Na jinta chi uchac más e aj cojol umac! Ma lic e laꞌ xta alak xubiꞌij ri na takal ta che. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Saꞌ cꞌu riꞌ cabiꞌij ralak che? —xchaꞌ. Rique xquibiꞌij: —Lic chirij umac y takal cꞌu che cacamisaxic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ewi e cꞌo jujun xquijek caquichubaj rupalaj y lic caquiꞌan pa tꞌoꞌy. E cꞌo jujun chic xquipachꞌ kꞌab chupalaj ");
INSERT INTO acrTNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","y caquibiꞌij che: —At ri Cristo, Ruchaꞌoꞌn lo ri Dios, ¡chanaꞌij pe cꞌu riꞌ china xchꞌayaw awe! —quecha che. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ecꞌu ri Pedro tzꞌul che ruwa ja echiriꞌ jun ali aj chac xkib rucꞌ y xubiꞌij che: —Rilal lal jun chique ri eteran chirij ri Jesús, ri jun aj Galilea —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Noꞌj ri Pedro xrewaj chiquiwach conoje, jewaꞌ xubiꞌij: —Riꞌin na wetaꞌam tane saꞌ puwiꞌ catchꞌaꞌt wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ecꞌu riꞌ quel bi ri Pedro chuchiꞌ ri puerta yey xilitaj ruma jun chic ali aj chac, y waꞌli jewaꞌ xubiꞌij chique ri e cꞌo chiriꞌ: —Waꞌ wa jun achi e jun chique ri eteran chirij ri Jesús ri aj Nazaret —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ri Pedro xrewaj tanchic y lic xujiquibaꞌ uwach ubiꞌxiquil: —Riꞌin na wetaꞌam ta cꞌana uwach laꞌ laꞌchi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Jokꞌotaj cꞌu riꞌ, ri e cꞌo chiriꞌ xekib rucꞌ ri Pedro y xquibiꞌij che: —Pakatzij wi rilal lal jun chique rutijoꞌn; ma lic kꞌalaj, ri cachꞌaꞌt la e junam rucꞌ ri quechꞌaꞌt rique —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ecꞌu ri Pedro xujek ubiꞌxiquil itzel tak tzij y lic xujiquibaꞌ uwach, xubiꞌij: —Riꞌin na wetaꞌam ta cꞌana uwach laꞌ laꞌchi —xchaꞌ. Xew xuqꞌuis ubiꞌxiquil waꞌ, xbixon lo ri teren. ");
INSERT INTO acrTNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ecꞌuchiriꞌ, xcꞌun lo chucꞌuꞌx ri Pedro ri xbiꞌx lo che ruma ri Jesús: «Cꞌamajaꞌ ne cabixon ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach.» Ewi xel bi ri Pedro chiriꞌ y lic xokꞌic ruma rucꞌaxcꞌolil ucꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Echiriꞌ xsakiric, conoje ri nimak e aj chacunel pa Rocho Dios cucꞌ ri nimak winak re ri tinamit, xquiꞌan tzij chiquiwach puwi ri caquiꞌano chaꞌ cakꞌat tzij re camic puwi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yutum cꞌu ri Jesús, xquicꞌam bi y xeꞌquiyaꞌa chwach ri takanel Poncio Pilato. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ri Judas ri xcꞌayin re ri Jesús, echiriꞌ xrilo xkꞌat tzij re camic puwi ri Jesús, lic xoc chucꞌuꞌx ri xuꞌano. Xeꞌec cꞌut y xutzelej ri treinta sakil puak chique ri nimak e aj chacunel pa Rocho Dios y chique ri nimak winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xubiꞌij cꞌu chique: —Riꞌin lic in macuninak, ma xincꞌayij pa camic jun achi na jinta umac —xchaꞌ. Pero rique xquibiꞌij che: —Na jinta ke riꞌoj che laꞌ; laꞌ amac riꞌat —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ecꞌuchiriꞌ, ri Judas xuꞌcꞌaka can ri puak pa ri Rocho Dios y xeꞌec cꞌut xuꞌjitzꞌaj rib. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ri nimak e aj chacunel pa ri Rocho Dios xeꞌquimolo ri puak y xquibiꞌij: «Waꞌ wa puak na ube ta qꞌuenok cakaya pa ri caxa re kasaꞌn, ma waꞌ rajil uquiqꞌuel jun achi» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tecꞌuchiriꞌ, xquiꞌan tzij chiquiwach chaꞌ rucꞌ waꞌ wa puak caquilokꞌ juchꞌakap ulew rubiꞌ “Luwar re ri aj tzꞌakal xokꞌoꞌl”, chaꞌ cuꞌana jun luwar re mukubal que ri na e ta aj Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ruma cꞌu laꞌ, la jun ulew cꞌa e ubiꞌ wakꞌij ora “Luwar re quicꞌ”. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ecꞌu xuꞌan pachaꞌ ri tzꞌibital can ruma ri kꞌalajisanel Jeremías pa Ruchꞌaꞌtem ri Dios, pa cubiꞌij wi: Xquicꞌam cꞌu ri treinta sakil puak, ma e rajil riꞌ cojotal cuma raj Israel. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y rucꞌ cꞌu wa puak, xquilokꞌ ri jun luwar rubiꞌ “Luwar re ri aj tzꞌakal xokꞌoꞌl”, jelaꞌ pachaꞌ ri ubiꞌim lo ri Dios chwe. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ecꞌuchiriꞌ xcꞌam bi ri Jesús chwach ri takanel Pilato, rire xutzꞌonoj che ri Jesús: —¿Lal cami riꞌ ri rey que raj judiꞌab? —xchaꞌ. Ri Jesús xubiꞌij che: —Lal cabiꞌn la re —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yey echiriꞌ ri nimak e aj chacunel pa Rocho Dios cucꞌ ri nimak winak re Israel xquitzꞌak uchiꞌ ri Jesús, Rire na xucꞌul ta cꞌana uwach ri caquibiꞌij rique. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ruma cꞌu riꞌ, ri Pilato xutzꞌonoj che ri Jesús: —¿Na cata ta cami la janipa ri caquibiꞌij chiꞌij la? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús na xucꞌul ta cꞌana uwach; ruma cꞌu riꞌ, ri takanel lic xcam ranimaꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chupa cꞌu ri nimakꞌij Pascua, ri takanel romano xex cuꞌan wi cuyolopij bi jun chique ri e cꞌo pa cárcel, yey e ri winak quechaꞌwic china ri cacaj cayolopix bi. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Cꞌo cꞌu jun achi pa cárcel lic etaꞌmatal uwach, Barrabás rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ecꞌuchiriꞌ ri winak quimolom chi quib, ri Pilato xutzꞌonoj chique: —¿China ri quiwaj riꞌix canyolopij bi, e ri Barrabás o e ri Jesús, ri cabiꞌx che “e ri Cristo”, Ruchaꞌoꞌn lo ri Dios? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Xutzꞌonoj cꞌu waꞌ ma retaꞌam e cꞌo jujun cꞌax quicꞌuꞌx chirij ri Jesús, y xa ruma cꞌu riꞌ quiyaꞌom ri Jesús chwach. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ecꞌuchiriꞌ tzꞌul ri Pilato pa ri kꞌatbal tzij, ri rixokil xutak ubiꞌxiquil che: «Macꞌo maꞌan la che wa jun achi jusucꞌ ubinic usilabic, ma wakꞌij lic cabison nucꞌuꞌx ruma xinꞌan jun wachicꞌ puwi rire yey lic xibibal uwach ri xinwachicꞌaj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Noꞌj ri nimak e aj chacunel pa Rocho Dios cucꞌ tak ri nimak winak re Israel xquicoj pa quijolom ri uqꞌuiyal winak chaꞌ e caquitzꞌonoj cayolopix bi ri Barrabás yey e cacamisax ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ri takanel xchꞌaꞌt tanchi cucꞌ ri winak, jewaꞌ xutzꞌonoj chique: —¿China chique wa caꞌib quiwaj canyolopij bi? —xchaꞌ. Rique xquibiꞌij: —E yolopij bi la ri Barrabás —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tecꞌuchiriꞌ, xutzꞌonoj ri Pilato chique: —¿Yey saꞌ cꞌu riꞌ canꞌan che ri Jesús, ri cabiꞌx che “e ri Cristo”, Ruchaꞌoꞌn lo ri Dios? —xchaꞌ. Conoje xquicꞌul uwach: —¡Camisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ecꞌu riꞌ ri Pilato xubiꞌij chique: —¿Saꞌ cꞌu rumac uꞌanom? —xchaꞌ. Pero ri winak más co xesiqꞌuinic: —¡Camisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ri Pilato xrilo na jinta cutikoj cuꞌan más tzꞌonobal chique ma más ne quetucuc ri winak; ruma cꞌu riꞌ, xutak ucꞌamic yaꞌ y ecꞌu laꞌ chiquiwach ri winak xuchꞌaj rukꞌab, y jewaꞌ xubiꞌij: —Na jinta cꞌu numac riꞌin che rucamic waꞌchi jusucꞌ rubinic, ma waꞌ imac riꞌix —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Conoje cꞌu ri winak xquicꞌul uwach, jewaꞌ xquibiꞌij: —Riꞌoj cucꞌ ri kalcꞌoꞌal cakaya kib chuxeꞌ rucamic rire —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ewi ri Pilato xuyolopij bi ri Barrabás. Tecꞌuchiriꞌ, xtakan che cajichꞌ upa ri Jesús y xuya paquikꞌab ri soldados chaꞌ caquicamisaj chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ecꞌuchiriꞌ, ri soldados re ri takanel xquicꞌam bi ri Jesús pa ri palacio y xquimol cꞌu quichiꞌ conoje ri soldados chaꞌ caquisut rij. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xquesaj cꞌu bi rukꞌuꞌ y xquirip jun manta chirij yey waꞌ cakcoj catzuꞌnic. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Che rujolom xquicoj jun corona pachꞌum rucꞌ qꞌuix y xquiya jucutaj tani pa rukꞌab uwiquikꞌab. Tecꞌuchiriꞌ, xexuquiꞌ chwach y xquijek uchꞌamixic, jewaꞌ caquibiꞌij che: —¡Nim ukꞌij ri rey que raj judiꞌab! —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yey xquichubaj rupalaj, xquimaj cꞌu ri jucutaj tani pukꞌab y rucꞌ laꞌ xquichꞌay rujolom. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Echiriꞌ xquitanabaꞌ uchꞌamixic, xquesaj ri manta quiripom chirij y xquicoj tanchi rukꞌuꞌ. Tecꞌuchiriꞌ, xquicꞌam bi re queꞌquicamisaj chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Echiriꞌ catajin quelic bi, xquicꞌul jun achi aj Cirene, Simón rubiꞌ, y xquitak che cutelej bi ri cruz re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ecꞌuchiriꞌ, xebopon pa ri luwar Gólgota rubiꞌ, waꞌ queꞌelawi “luwar re ubakil ujolom animaꞌ”. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xquiya cꞌu che ri Jesús vinagre yijbam rucꞌ akꞌes lic cꞌa; pero Rire echiriꞌ xunaꞌ waꞌ, na xraj taj xutijo. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Echiriꞌ quiyaꞌom chi ri Jesús chwa ri cruz, ri soldados rucꞌ jun sorteo xquijach quib puwi rukꞌuꞌ. Jecꞌulaꞌ e xuꞌana pachaꞌ rubiꞌim lo ri kꞌalajisanel chupa Ruchꞌaꞌtem ri Dios: Xquijach quib puwi ri nukꞌuꞌ, ma xquiꞌan sorteo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tecꞌuchiriꞌ, xetzꞌuyiꞌ chiriꞌ chaꞌ caquichajij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chwi cꞌu lo rucruz ri Jesús tzꞌibitalic suꞌbe xkꞌat tzij puwiꞌ, jewaꞌ cubiꞌij: «E JESÚS WAꞌ, RI REY QUE RAJ JUDIꞌAB.» ");
INSERT INTO acrTNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xequiya cꞌu caꞌib elekꞌomab chwa cruz, jun puwiquikꞌab y jun pumox ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ecꞌu ri winak quebicꞌow chiriꞌ caquiyokꞌ canok, caquiyiriyaꞌ ri quijolom che, ");
INSERT INTO acrTNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","y jewaꞌ caquibiꞌij: —At peꞌ ri abiꞌim cawulij ri Rocho Dios y xa pa oxib kꞌij cayac tanchic; chacolobej cꞌu awib riꞌ. We pakatzij wi at Ucꞌajol ri Dios, chatkaj lo chwa ri cruz —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jenelaꞌ riꞌ xquiꞌan ri nimak e aj chacunel pa Rocho Dios junam cucꞌ raj cꞌutunel re ri tzijpixab, ri fariseos y ri nimak winak re ri tinamit; lic xquichꞌamij, jewaꞌ xquibiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Lic waꞌ cꞌut e qꞌui ri xebucolobej che tak yabil y che camic, yey na curik ta waꞌ cꞌu ucolobexic rib rire. We ta pakatzij wi e Rey re ri katinamit Israel, kaja lo riꞌ utuquel chwa ri cruz chaꞌ jelaꞌ cakacojo e rire ri Uchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ma lic waꞌ cꞌut xcubiꞌ ucꞌuꞌx rucꞌ ri Dios. Yey we ta ri Dios lic cꞌax cunaꞌo, chucolobej riꞌ woꞌora, ma rire ubiꞌim e Ucꞌajol ri Dios —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jenelaꞌ riꞌ xquibiꞌij relekꞌomab eyaꞌom chwa cruz pa tak utzal, lic xquichꞌamij. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Echiriꞌ xticꞌoj ri kꞌij, xoc kꞌekuꞌm che ruwachulew y waꞌ xuꞌqꞌuisa cꞌa che ri urox ora benak kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chupa cꞌu laꞌ laꞌ ora, ri Jesús lic co xsiqꞌuinic, jewaꞌ xubiꞌij pa ri chꞌaꞌtem cachꞌaꞌt wi Rire: —Elí, Elí, ¿lama sabactani? —xchaꞌ. Waꞌ queꞌelawi: “Lal nu Dios, Lal nu Dios, ¿suꞌbe xinokꞌotaj can la?” ");
INSERT INTO acrTNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jujun cꞌu chique ri e cꞌo chiriꞌ, echiriꞌ xquita waꞌ, xquibiꞌij: —Waꞌ waꞌchi e cusiqꞌuij ri kꞌalajisanel Elías —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y na jampatana, cꞌo jun chique rique lic canic xeꞌec, xuꞌcꞌama lo jun esponja y xumuꞌ pa vinagre. Xuxim cꞌu chutzaꞌm jun tani y xuya pan che ri Jesús re cutzꞌubu. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ecꞌu ri jujun chic xquibiꞌij che: —Maya che, kila peꞌ we cacꞌun ri Elías re coluꞌcolobej —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tecꞌuchiriꞌ, ri Jesús lic co xsiqꞌuin tanchic y xukꞌatisaj cꞌu ri ranimaꞌ pukꞌab ri Dios, asu xcamic. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ecꞌu laꞌ la jokꞌotaj ri telón cꞌo chupa ri Rocho Dios xrichꞌrob chunicꞌajal; xujek lo puwiꞌ y xoꞌlqꞌuis cꞌa chuxeꞌ. Rulew lic xbarbatic y ri nimak tak abaj xejakajob upa. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Y xejakataj tak ri mukubal yey uqꞌuiyal ticawex re rutinamit ri Dios ecaminak chic, xecꞌastaj lok ");
INSERT INTO acrTNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xebel lo chupa tak ri mukubal. Ecꞌuchiriꞌ cꞌastajinak chubi ri Jesús, rique xeboc pa ri santowilaj tinamit yey chilaꞌ xebilitaj cuma uqꞌuiyal winak. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ecꞌu ri capitán y ri soldados echajiyom re ri Jesús, echiriꞌ xquil ri cabrakan y ronoje tak ri xuꞌano, lic xquixiꞌij quib y jewaꞌ xquibiꞌij: —¡Pakatzij wi, waꞌ waꞌchi e Ucꞌajol ri Dios! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E cꞌo cꞌu uqꞌuiyal ixokib chiriꞌ caquitzutzaꞌ pana chinimanaj; waꞌ e tak ri e petinak rucꞌ ri Jesús chwi xel lo Galilea y lic quinimam lok. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chiquixoꞌl waꞌ wiꞌxokib cꞌo ri María ri aj Magdala, cꞌo ri María ri quichu ri Jacobo y ri José, yey cꞌo ri quichu ri queb ucꞌajol ri Zebedeo. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Cꞌo jun achi aj Arimatea, José rubiꞌ; rire beyom y e jun chique rutijoꞌn ri Jesús. Benak kꞌij rire ");
INSERT INTO acrTNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","xeꞌec cꞌu rucꞌ ri Pilato re cuꞌtzꞌonoj rucuerpo ri Jesús. Ecꞌu ri Pilato xtakan che cayaꞌiꞌ lo rucuerpo ri Jesús che rire. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ri José xucꞌam cꞌu bi rucuerpo ri Jesús, xupis bi pa jun manta lic sak ");
INSERT INTO acrTNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","y xuꞌyaꞌa pa jun mukubal re rire, waꞌ cꞌacꞌ cꞌotom paꞌbaj. Xutak cꞌu uquetebaxic can jun nimalaj abaj chuchiꞌ re tzꞌapibal re; tecꞌuchiriꞌ, xeꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","E cꞌo cꞌu chiriꞌ ri María ri aj Magdala y ri jun chic María, etzꞌul chwach ri mukubal. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Icꞌowinak chi cꞌu ri kꞌij echiriꞌ raj judiꞌab caquiyijbaꞌ pan janipa ri cajawax chique pa ri kꞌij re uxlanibal. Ecꞌuchiriꞌ, ri nimak e aj chacunel pa Rocho Dios cucꞌ ri fariseos xquimol quib rucꞌ ri Pilato ");
INSERT INTO acrTNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","y xquibiꞌij che: —Kajawal, xcꞌun chikacꞌuꞌx, laꞌ la jun achi socosoꞌnel echiriꞌ cꞌa cꞌaslic jewaꞌ xubiꞌij: “Purox kꞌij quincꞌastaj lo chiquixoꞌl ri ecaminak.” ");
INSERT INTO acrTNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E uwariꞌche, taka la uchajixic chi utz ri mukubal cꞌa che rurox kꞌij, chaꞌ na quecꞌun ta rutijoꞌn chakꞌab, coꞌlquelakꞌaj bi rucuerpo y tecꞌuchiriꞌ, caquibiꞌij chique ri winak: “Xcꞌastaj lo chiquixoꞌl ri ecaminak.” We ecꞌu xuꞌan riꞌ, cuꞌana ne más unimal rakꞌubal riꞌ chwa ri nabe uꞌanom lok echiriꞌ xubiꞌij e Ruchaꞌoꞌn lo ri Dios —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ri Pilato xubiꞌij chique: —Checꞌama bi alak waꞌ wa e chajinel y jeꞌtzꞌapij alak chi utz ri mukubal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xebec cꞌut, xeꞌquitzꞌapij uchiꞌ ri mukubal chi utz, xquicoj jun sello puwi ri nimalaj abaj tzꞌapibal uchiꞌ y xequiya cꞌu can ri e chajinel chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Icꞌowinak chi ri kꞌij re uxlanibal, e riꞌ catajin usakiric ri nabe kꞌij che ri semana, ri María ri aj Magdala y ri jun chic María xeꞌquila ri mukubal. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xakicꞌateꞌt xpe jun nimalaj cabrakan, yey waꞌ e xꞌanaw jun ángel re ri Dios xkaj lo chicaj. Echiriꞌ xopon chwach ri mukubal, xresaj rabaj utzꞌapim uchiꞌ ri mukubal y xtzꞌuyiꞌ cꞌu puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri ángel lic cawolkꞌinic, catzuꞌn jelaꞌ pachaꞌ ruxeꞌ caj echiriꞌ cayocꞌ caꞌnic; yey rukꞌuꞌ lic sak pachaꞌ ri nieve. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ri soldados echiriꞌ xquil ri ángel, lic xquixiꞌij quib che; xquijek quebirbotic y xecanaj canok pachaꞌ chi ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ecꞌuchiriꞌ, xubiꞌij ri ángel chique rixokib: —Mixiꞌij iwib. Ma riꞌin wetaꞌam e quitzucuj ri Jesús, ri xcamisax chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rire na jinta chi wara, ma cꞌastajinak chubi jelaꞌ pachaꞌ rubiꞌim chi ulok. Choꞌliwilape wa luwar pa xyaꞌiꞌ wi ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jix cꞌu riꞌix, lic chiwilij bi y jiꞌbiꞌij chique rutijoꞌn: “Ri Jesús xcꞌastaj bi chiquixoꞌl ri ecaminak. Chiwilapeꞌ, Rire queꞌec Galilea, canabej bi chiwach; chilaꞌ cꞌu riꞌ quiꞌwila wi uwach.” Ecꞌu xoꞌlnubiꞌij waꞌ chiwe —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Echiriꞌ rixokib xebel bi chuchiꞌ ri mukubal, lic quixiꞌim quib pero cꞌo unimal quiꞌcotemal cucꞌ. Queban cꞌu riꞌ xebec chaꞌ queꞌquibiꞌij chique rutijoꞌn janipa ri xquilo y ri xbiꞌx bi chique. E cꞌo cꞌu chi be ");
INSERT INTO acrTNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","echiriꞌ ri Jesús xebucꞌulu y xuya rutzil quiwach. Ecꞌu rique xekib rucꞌ y xquixuc quib chwach; xquilakꞌapuj ri rakan y xquilokꞌnimaj ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ri Jesús xubiꞌij cꞌu chique: —Mixiꞌij iwib. Jix, jiꞌbiꞌij chique ri nu hermanos chaꞌ quebec chilaꞌ Galilea y chiriꞌ caquil wi nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ecꞌuchiriꞌ e cꞌo pan rixokib pa be, jujun chique ri e chajinel xebec pa ri tinamit y xeꞌquitzijoj chique ri nimak e aj chacunel pa Rocho Dios ronoje ri xquicꞌulumaj. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ecꞌu ri nimak e aj chacunel pa Rocho Dios cucꞌ ri nimak winak re ri tinamit, xquichꞌaꞌbej quib chaꞌ caquiꞌan tzij chiquiwach. Xquiya cꞌu uqꞌuiyal puak chique ri soldados ");
INSERT INTO acrTNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y xequitak che jewaꞌ caquibiꞌij: «Echiriꞌ oquinak lo kawaram chakꞌab, xecꞌun rutijoꞌn ri Jesús y xquelakꞌaj bi rucuerpo. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yey we xretaꞌmaj waꞌ ri takanel, riꞌoj cakacoj pujolom chaꞌ na jinta cꞌo cuꞌan chiwe» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados xquicꞌam cꞌu ri puak y e xquiꞌano janipa ri xbiꞌx chique. Ecꞌu raj judiꞌab cꞌa e ubiꞌxiquil waꞌ caquiꞌan wakꞌij ora. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E tak cꞌu ri junlajuj utijoꞌn xebec Galilea chwa ri jun juyub pa ubiꞌim wi ri Jesús chique. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Echiriꞌ xquil uwach ri Jesús, lic xquilokꞌnimaj ukꞌij, tob cꞌu e cꞌo jujun chique cꞌamajaꞌ caquicojo we pakatzij wi ri Jesús xcꞌastaj lo chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ecꞌuchiriꞌ, xkib ri Jesús cucꞌ y xubiꞌij chique: —Riꞌin yaꞌtal lo panukꞌab ronoje ri takanic chilaꞌ chicaj y che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ruma cꞌu waꞌ, jix cucꞌ conoje ruqꞌuiyal quiwach tak ri tinamit che ruwachulew, chiꞌana cꞌu e nutijoꞌn chique y chiyaꞌa ri bautismo chique pa rubiꞌ ri Kakaw Dios, Rucꞌajol y ri Santowilaj Ruxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chicꞌutu chiquiwach rique chaꞌ e caquiꞌan ronoje janipa ri ixnutakom riꞌin che. Lic chiwetaꞌmaj cꞌut: Riꞌin quincꞌojiꞌ iwucꞌ ronoje kꞌij cꞌa che ri qꞌuisbal re ruwachulew —xchaꞌ. Amén. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Waꞌ e jekebal re ri Utzilaj Tzij re ri Kanimajawal Jesucristo, Rucꞌajol ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","E xuꞌana pachaꞌ ri tzꞌibital can ruma ri kꞌalajisanel Isaías puwi ri ubiꞌim lo ri Dios: Riꞌin cannabesaj bi chawach riꞌat, ri waj chac aj tzijol weꞌin, chaꞌ cuyijbaꞌ ri be chwach pan rawoponibal. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Catataj ukul jun tzijonel casiqꞌuin chupa ri luwar catzꞌintzꞌotic, jewaꞌ cubiꞌij: “Yijbaꞌ pana alak ri be re ri Kanimajawal; sucꞌupij alak rube Rire” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri Juan catajin che uyaꞌic ri bautismo pa jun luwar catzꞌintzꞌotic. E cubiꞌij chique ri winak caquitzelej quitzij chwach ri Dios, caquicꞌul ri bautismo, y jecꞌulaꞌ cacuytaj ri quimac. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ewi conoje ri ticawex e cꞌo pa tak ri luwar re Judea y conoje ri e cꞌo Jerusalem, xebel lo che utayic ri Juan. Caquitzꞌonoj cꞌu cuybal quimac chwach ri Dios, yey ri Juan cuya ri bautismo chique chupa ri nimayaꞌ Jordán. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ecꞌu rukꞌuꞌ ri Juan ꞌanom rucꞌ rismal camello, y rupas ximil che rupa e jun tzꞌuꞌum. Yey ri cutijo e ri sacꞌ y uwaꞌal cab re upa tak juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jecꞌuwaꞌ ri tzijonic cuꞌano: «Cꞌo Jun catajin lo chwij más nim ruchukꞌab chinuwa riꞌin, ma na takal tane chwe quinyuxiꞌic re canquir ruwach ruxajab. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Pakatzij wi, riꞌin xinya ri bautismo che alak rucꞌ yaꞌ; noꞌj ri bautismo cuya Rire che alak, e rucꞌ ri Santowilaj Ruxlabixel ri Dios» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chupa tak cꞌu laꞌ la kꞌij, ri Jesús xel lo Nazaret, (waꞌ e jun tinamit re Galilea), y xꞌan cꞌu bautizar ruma ri Juan chupa ri nimayaꞌ Jordán. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na jampatana xel lo ri Jesús pa ri yaꞌ, xrilo echiriꞌ xjakataj ruwa caj y ri Ruxlabixel ri Dios pachaꞌ juna palomax xkaj lo puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y xchꞌaw lo Jun chilaꞌ chicaj, jewaꞌ cubiꞌij: «At riꞌat Nucꞌajol y lic cꞌax catinnaꞌo. Lic quinquiꞌcot chawe» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tecꞌuchiriꞌ, ri Jesús xcꞌam bi ruma ri Ruxlabixel ri Dios pa jun luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ri Jesús xcꞌojiꞌ chilaꞌ cuarenta kꞌij chiquixoꞌl itzel tak awaj. Yey chupa tak laꞌ la kꞌij, lic xcꞌam upa ruma ri Satanás. Icꞌowinak chi cꞌu waꞌ, ri ángeles xquijek caquinimaj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Echiriꞌ yaꞌom chi ri Juan pa cárcel, ri Jesús xeꞌec Galilea che utzijoxic ri Utzilaj Tzij re rutakanic ri Dios, ");
INSERT INTO acrTNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","jewaꞌ cubiꞌij: «Xopon cꞌu rukꞌijol echiriꞌ rutakanic ri Dios xa nakaj chi cꞌo lo wi; tzelej cꞌu tzij alak chwach ri Dios y cojo alak ri Utzilaj Tzij» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Echiriꞌ cabin ri Jesús chuchiꞌ ri mar re Galilea, xeril pan ri Simón rucꞌ ruchakꞌ Andrés, e riꞌ caquicꞌak ri qui atarraya chupa ri yaꞌ, ma rique e aj chapal car. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ecꞌu ri Jesús xubiꞌij chique: —Chixpetok, chixterej lo chwij y riꞌin canꞌan chiwe ix aj molol ticawex jelaꞌ pachaꞌ iꞌanom lo chique ri car —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rique xquiya can ri qui atarraya y xeterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xbin cꞌu pan jubikꞌ chic y xeril ri Jacobo rucꞌ ruchakꞌ Juan, ri queb ucꞌajol ri Zebedeo. Rique e cꞌo chupa jun barco y quetajin che ucꞌojoxic ri qui atarraya. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ecꞌu ri Jesús xebusiqꞌuij; ruma cꞌu riꞌ, rique xquiya can ri quikaw Zebedeo cucꞌ ri quimocom chupa ri barco y xeterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xeboc cꞌu pa ri tinamit Capernaúm. Y chupa ri kꞌij re uxlanibal ri Jesús xoc pa ri sinagoga y xujek cacꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xetaw re lic xcam canimaꞌ che, ma ruma rucꞌutunic cakꞌalajinic lic cꞌo uwach, na pachaꞌ ta ri caquiꞌan raj cꞌutunel re ri tzijpixab. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chupa cꞌu ri sinagoga cꞌo jun achi cꞌo pukꞌab jun itzelilaj uxlabixel. Waꞌ xujek casiqꞌuinic, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Lal Jesús, aj Nazaret, ¿suꞌchac coꞌlmina ib la kucꞌ? ¿E laꞌ lal petinak re coꞌlsacha la kawach? Riꞌin wetaꞌam lal chinok, lal ri Santo Cꞌajolaxel re ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ecꞌu ri Jesús xukꞌatej ri itzel uxlabixel, jewaꞌ xubiꞌij che: —¡Matchꞌaꞌt chic! Chatelubi che laꞌchi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzelilaj uxlabixel xucꞌak laꞌchi pulew y lic co xujabajaꞌ; yey casiqꞌuinic xel bi che laꞌchi. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Conoje cꞌu ri ticawex lic xcam canimaꞌ che y caquitzꞌonobej tak chiquiwach: «¿Saꞌ waꞌ? ¿Saꞌ chi cꞌacꞌ cꞌutunic waꞌ? Ma cꞌo ne pukꞌab catakan paquiwi itzelilaj uxlabixel y waꞌ caquicoj utzij» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y na jampatana, pa tak ronoje ri luwar re Galilea xeꞌec utzijoxic janipa tak ri cuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Echiriꞌ ri Jesús cucꞌ ri Jacobo y ri Juan xebel bi chupa ri sinagoga, xebec chirocho ri Simón y ri Andrés. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ecꞌu ruchu-ujiꞌ ri Simón cꞌo chwa uwarabal, cꞌo akꞌ chirij. Xquitzijoj cꞌu riꞌ waꞌ che ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ewi ri Jesús xkib rucꞌ la yewaꞌ, xuchap rukꞌab y xutoꞌo chaꞌ cayactajic. Na jampatana cꞌu riꞌ xicꞌow ri akꞌ chirij rixok y xujeko quebunimaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Echiriꞌ benak chi ri kꞌij e riꞌ cayubub chic, xecꞌam lo chwach ri Jesús conoje ri yewaꞌib y ri e cꞌo paquikꞌab itzel uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y conoje ri ticawex re ri tinamit xetꞌikiꞌ chuchiꞌ ri puerta re ri ja. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ecꞌu ri Jesús xebucunaj uqꞌuiyal yewaꞌib che uqꞌuiyal uwach tak yabil y xeberesaj bi uqꞌuiyal itzel uxlabixel; pero na xuya ta luwar chique quechꞌawic ma rique quetaꞌam china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lic anim tan echiriꞌ lic cꞌa kꞌekuꞌm, xwaꞌlij bi ri Jesús, xel cꞌu bi chupa ri tinamit y xeꞌec pa jun luwar catzꞌintzꞌotic chaꞌ cuꞌana orar. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ecꞌu ri Simón cucꞌ ri rachbiꞌil xebec che utzucuxic. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Echiriꞌ xquiriko, xquibiꞌij che: —Conoje ri winak caquitzucuj la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ecꞌu Rire xubiꞌij chique: —Joꞌ che utzijoxic ri Utzilaj Tzij pa tak ri luwar e cꞌo lo xa nakaj, ma e nuwach riꞌ in petinak Riꞌin —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Xebec cꞌu riꞌ, y ri Jesús catzijon chupa tak ri sinagogas che tak ronoje ri luwar re Galilea yey queberesaj cꞌu bi itzel uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xopon cꞌu rucꞌ ri Jesús jun achi cꞌo ri yabil lepra che y xuxucubaꞌ rib chwach. Lic xelaj cꞌu che, jewaꞌ xubiꞌij: —We caꞌaj co la, joskꞌij la ri nucuerpo che wa yabil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ecꞌu ri Jesús xjuchꞌ caꞌn ucꞌuꞌx che rachi yewaꞌ. Xuchap pana rucꞌ rukꞌab y jecꞌuwaꞌ xubiꞌij che: —Cuaj, chuꞌana ba chom riꞌ racuerpo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xew cꞌu xuqꞌuis ubiꞌxiquil waꞌ, xa pa jokꞌotaj ri yabil xsachic y rachi xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ecꞌuchiriꞌ, ri Jesús xuqꞌuisbej ruchꞌaꞌtem rucꞌ y lic xupixabaj, ");
INSERT INTO acrTNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","jewaꞌ xubiꞌij che: —Chatapeꞌ, macꞌo matzijoj che junok. Jat chwach raj chacunel pa Rocho Dios chaꞌ rire carilo na jinta chi lepra chawe. Y ruma rajoskꞌiquil, chayaꞌa cꞌu chwach ri Dios ri kasaꞌn xtakan can ri Moisés che, chaꞌ cakꞌalajin chiquiwach ri ticawex at cunutajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Noꞌj laꞌchi echiriꞌ xeꞌec, lic xujek utzijoxic ri xuꞌan ri Jesús che y jecꞌulaꞌ lic xtataj waꞌ cuma ri winak. Ruma cꞌu riꞌ, na utz ta chic coc ri Jesús chiwachil pa ri tinamit; xujek cꞌu cacanaj can chinimanaj che ri tinamit pa tak luwar catzꞌintzꞌotic. Na rucꞌ ta cꞌu riꞌ, uqꞌuiyal ticawex re ronoje luwar xebopon rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Echiriꞌ icꞌowinak chi queb oxib kꞌij, xoc tanchi ubi ri Jesús pa ri tinamit Capernaúm. Tak ri winak xquito Rire cꞌo chuchiꞌ jun ja. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Y na jampatana xemolotaj uqꞌuiyal winak y ruma ri quiqꞌuiyal na queboc ta chi ne chuchiꞌ ri puerta. Ecꞌu ri Jesús cutzijoj Ruchꞌaꞌtem ri Dios chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ecꞌuchiriꞌ, xecꞌun cajib achijab quitelem lo jun achi sic. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yey na xquirik taj suꞌanic caquiya pan chwach ri Jesús cuma ruqꞌuiyal winak. Ewi xquitekꞌebaꞌ ruwi ri ja pa cꞌo wi ri Jesús, xquesaj julepaj che. Chiriꞌ cꞌu riꞌ xquikasaj wubi la chꞌat pa cotzꞌol wi ri sic. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ecꞌu ri Jesús echiriꞌ xril ri cubulibal quicꞌuꞌx rucꞌ, jewaꞌ xubiꞌij che ri sic: —Wal, ronoje ramac cuytajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chiriꞌ cꞌut etzꞌul jujun aj cꞌutunel re ri tzijpixab y jewaꞌ catajin chiquicꞌuꞌx: ");
INSERT INTO acrTNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«¿Suꞌchac jewaꞌ cachꞌaꞌt waꞌchi? Rucꞌ wa cubiꞌij camacun chirij ri Dios. Ma ¿na xew ta neba ri Dios aj cuyul mac?» ");
INSERT INTO acrTNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chupa cꞌu laꞌ la jokꞌotaj, ri Jesús xunaꞌbej saꞌ la caquichꞌobo; ruma cꞌu riꞌ, xubiꞌij chique: —¿Suꞌchac jelaꞌ catajin chicꞌuꞌx alak? ");
INSERT INTO acrTNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Saꞌ cꞌu ri na cꞌayew taj cambiꞌij che rachi sic: “Ronoje ramac cuytajinak chic” o “Chatyactajok, chacꞌama bi rachꞌat y chatbinok”? ");
INSERT INTO acrTNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","E cuaj cꞌut quetaꞌmaj alak waꞌ: Ralaxel Chiquixoꞌl Ticawex yaꞌtal pukꞌab cucuy tak ri mac que ri winak che ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Xubiꞌij cꞌu riꞌ che ri sic: —Chatyactajok, chacꞌama bi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na jampatana xyactaj rachi, xutelej bi ruchꞌat y chiquiwach conoje xel bi. Conoje cꞌu riꞌ xcam canimaꞌ che la xquilo y xquijek caquiyac ukꞌij ri Dios, jewaꞌ caquibiꞌij: «¡Na jinta cꞌana kilom wi waꞌ!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tecꞌuchiriꞌ, xeꞌec tanchi ri Jesús chuchiꞌ ri mar. Conoje ri winak xekib rucꞌ, y Rire xujek cacꞌutun chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ecꞌu riꞌ catajin ricꞌowic pa ri luwar pa caꞌan wi ri tojonic che ri gobierno, xril pana jun aj tzꞌonol puak re tojonic tzꞌul chiriꞌ. Waꞌ Leví rubiꞌ yey ucꞌajol ri Alfeo. Xubiꞌij cꞌu ri Jesús che: —Chat-terej lo chwij —xchaꞌ. Xyactajic cꞌu ri Leví y xterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ecꞌu ri Jesús xumaj bi chirocho ri Leví. Xeboc cꞌu chwa ri mexa cucꞌ rutijoꞌn, junam cucꞌ uqꞌuiyal aj tzꞌonol puak re tojonic y uqꞌuiyal aj maquib; ma lic e qꞌui ri quiternabem bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ecꞌu raj cꞌutunel re ri tzijpixab cucꞌ ri fariseos, echiriꞌ xquilo cawaꞌ ri Jesús cucꞌ raj maquib y raj tzꞌonol puak re tojonic, xquibiꞌij chique rutijoꞌn ri Jesús: —¿Suꞌchac ri tijonel iwe riꞌix cawaꞌ junam cucꞌ raj tzꞌonol puak re tojonic yey cucꞌ raj maquib? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Echiriꞌ xuta waꞌ ri Jesús, xubiꞌij chique: —E janipa ri utz quiwach, na cajawax ta aj cunanel chique; ma waꞌ xew chique ri e yewaꞌib cajawax wi. Jelaꞌ cꞌu riꞌ, riꞌin na in petinak ta che quisiqꞌuixic ri jusucꞌ quibinic quisilabic, ma e in petinak che quisiqꞌuixic raj maquib —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rutijoꞌn ri Juan Aj Yaꞌl Bautismo y ri quitijoꞌn ri fariseos echiriꞌ e cꞌo pa ayuno, xebopon rucꞌ ri Jesús y xquitzꞌonoj che: —¿Suꞌbe rutijoꞌn ri Juan y ri quitijoꞌn ri fariseos lic caquiꞌan ayuno, yey ri tijoꞌn rilal na caquiꞌan ta waꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ri Jesús xucꞌul uwach: —¿Ube nawi caquiꞌan ayuno ri esiqꞌuim pa juna cꞌulaniquil we rala cacꞌuliꞌic cꞌa cꞌo cucꞌ? Na ube taj, ma cꞌa cꞌo rala chiquixoꞌl. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Noꞌj copon na ri kꞌij echiriꞌ quesax bi rala chiquixoꞌl; cꞌa ecꞌuchiriꞌ, caquiꞌan ayuno. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","»Na jinta junok cucꞌojoj rukꞌuꞌ kꞌeꞌl rucꞌ cꞌojobal cꞌasak; ma ri cꞌojobal cꞌasak, we xcꞌolotaj upa, e cujecꞌ ri cꞌul kꞌeꞌl y más ne curichꞌij bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jecꞌulaꞌ ri vino cꞌacꞌ na cakꞌej ta chupa juna surun kꞌeꞌl. Ma we caꞌaniꞌ waꞌ, ri vino cꞌacꞌ echiriꞌ canajtir ukꞌij, curakij ri surun, catix cꞌu riꞌ ri vino y ri surun na jinta chi uchac. Ruma cꞌu laꞌ, ri vino cꞌacꞌ ꞌanom chirajawaxic wi cakꞌej chupa juna surun cꞌasak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chupa cꞌu jun kꞌij re uxlanibal, ri Jesús cucꞌ rutijoꞌn e riꞌ quebicꞌow pa tak ticoꞌn re trigo. Ecꞌu rutijoꞌn xquijek caquichꞌupilaꞌ bi ri trigo. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ruma waꞌ ri fariseos xquitzꞌonoj che ri Jesús: —Chilape la, ¿suꞌbe ri tijoꞌn la caquiꞌan ri na takal taj caꞌaniꞌ chupa ri kꞌij re uxlanibal? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ecꞌu ri Jesús xucꞌul uwach: —¿Na ajilam ta neba alak ri xuꞌan ri David cucꞌ ri rachbiꞌil echiriꞌ cꞌo xajawax chique y xenumic? ");
INSERT INTO acrTNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Echiriꞌ ri Abiatar e cajawal raj chacunel pa Rocho Dios, ri David xoc pa ri Rocho Dios y xutij ri pam yaꞌtal chi pukꞌab ri Dios, yey waꞌ na takal ta chique rique caquitijo. Na rucꞌ ta cꞌu riꞌ, xuya ne que ri e rachbiꞌil. Yey waꞌ wa pam, xew takal chique raj chacunel pa Rocho Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y jewaꞌ xubiꞌij tanchi chique: —Ri kꞌij re uxlanibal xuya can ri Dios re toꞌbal que ri ticawex; na e ta xeꞌaniꞌ ri ticawex ruma ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yey Ralaxel Chiquixoꞌl Ticawex e ne rajaw ri kꞌij re uxlanibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jumul chic ri Jesús xoc chupa ri sinagoga y chiriꞌ cꞌo jun achi chakijinak jun ukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","E cꞌo cꞌu jujun lic quicꞌacꞌalem we ri Jesús cucunaj waꞌchi chupa wa kꞌij re uxlanibal, chaꞌ jelaꞌ utz caquitzꞌak uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xubiꞌij cꞌu ri Jesús che rachi chakijinak rukꞌab: —Chatyactajok y chatcꞌola chikawach konoje —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ecꞌuchiriꞌ, xutzꞌonoj chique ri caquitzutzaꞌ: —¿Saꞌ ri lic usucꞌ caꞌaniꞌ pa ri kꞌij re uxlanibal: E caꞌaniꞌ ri utz o e ri na utz taj? ¿Utz cacolobex rucꞌaslem junok o cayaꞌ luwar che cacamic? —xchaꞌ. Yey na jinta cꞌu junok chique xcꞌuluw uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ecꞌuchiriꞌ, ri Jesús xebutzuꞌ rucꞌ oyowal tak ri quisutum rij y lic xoc bis chucꞌuꞌx ruma lic uꞌanom co ri canimaꞌ. Xubiꞌij cꞌu che rachi: —Chasucꞌupij rakꞌab —xcha che. Rachi xuyuk rukꞌab y waꞌ xutziric. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xebel cꞌu bi ri fariseos, xquimol quib cucꞌ jujun chique ri quitakem ri rey Herodes, y junam xquichꞌaꞌtibej suꞌanic caquisach uwach ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ri Jesús xel bi y xeꞌec chuchiꞌ ri mar junam cucꞌ rutijoꞌn. Y uqꞌuiyal ticawex xeterej bi chirij. Waꞌ e petinak pa tak ri tinamit re Galilea y re Judea ");
INSERT INTO acrTNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","y pa ri tinamit Jerusalem; e petinak pa tak ri tinamit re Idumea, pa tak ri tinamit e cꞌo chꞌaka yaꞌ che ri nimayaꞌ Jordán, yey pa tak ri tinamit e cꞌo chunakaj ri tinamit Tiro y ri tinamit Sidón. Conoje waꞌ e petinak ruma xquito janipa ri catajin ri Jesús che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ecꞌu ri Jesús xubiꞌij chique rutijoꞌn, xaki quiyijbaꞌ na ri barco re cakꞌax chupa we xajawax che, chaꞌ jelaꞌ na capitzꞌipoꞌx ta cuma ruqꞌuiyal winak; ");
INSERT INTO acrTNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ma lic e qꞌui ri xebucunaj. Jecꞌulaꞌ conoje ri yewaꞌib caquiminimaꞌ quib rucꞌ, ruma cacaj caquichapo chaꞌ quecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ecꞌu ri winak e cꞌo paquikꞌab itzelilaj uxlabixel, echiriꞌ caquil uwach ri Jesús, quexuquiꞌ chwach y quesiqꞌuinic caquibiꞌij: «¡Rilal lal Rucꞌajol ri Dios!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Noꞌj ri Jesús lic quebukꞌatej chaꞌ na caquikꞌalajisaj taj china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tecꞌuchiriꞌ, xakꞌan ri Jesús chwa jun juyub y xebusiqꞌuij china tak ri xraj quebuchaꞌo, y rique xquimol quib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xebuchaꞌ cꞌu cablajuj chique waꞌ chaꞌ quecꞌojiꞌ rucꞌ y quebutak bi che utzijoxic ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y xuya bi quichukꞌab re quequicunaj yewaꞌib y re quebequesaj bi itzel uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ecꞌu quibiꞌ waꞌ wa cablajuj xebuchaꞌo: Simón ri xcoj Pedro che, ");
INSERT INTO acrTNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo y ruchakꞌ Juan (rique e ucꞌajol ri Zebedeo y xcoj ne quibiꞌ “Boanerges”, waꞌ queꞌelawi “E ralcꞌoꞌal ruchꞌawibal jab”), ");
INSERT INTO acrTNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo rucꞌajol ri Alfeo, Tadeo, Simón, ri cabiꞌx che “ri Cananista”, ");
INSERT INTO acrTNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judas aj Iscariot, ri xcꞌayin re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tecꞌuchiriꞌ, xoc ri Jesús chuchiꞌ jun ja y xemolotaj tanchi uqꞌuiyal winak. Y ruma cꞌu riꞌ, ri Jesús cucꞌ rutijoꞌn na utz ta chi ne quewaꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Echiriꞌ xquita ri ratz-uchakꞌ ri Jesús, xecꞌunic y xcaj caquicꞌam bi cucꞌ, ma rique caquibiꞌij xsach runaꞌoj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Noꞌj raj cꞌutunel re ri tzijpixab, ri e petinak Jerusalem, xquibiꞌij: «Ri Jesús cꞌo pukꞌab ri Beelzebú» y «Ruma cꞌu ruchukꞌab waꞌ wa cajawal ri itzel uxlabixel, queberesaj bi itzel uxlabixel» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ecꞌu ri Jesús xebusiqꞌuij y rucꞌ cꞌambal naꞌoj xubiꞌij chique: «¿Saꞌ nawi we ta ri Satanás caresaj bi ri Satanás chique ri winak? ");
INSERT INTO acrTNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","We ri takanelab re juna tinamit quijachom quipa ruma quechꞌoꞌjin chiquiwach, riꞌ na quetiquiꞌ ta chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yey we ri ejekelel pa juna ja quijachom quib ruma quechꞌoꞌjin chiquiwach, riꞌ na quetiquiꞌ ta chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jecꞌulaꞌ, we ta ri Satanás cayactaj chiribil rib y utuquel cujach upa rutakanic, riꞌ na canajtir ta rutakanic, xa casach uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","»Na jinta cꞌu juna elekꞌom coc pa rocho junok lic cꞌo uchukꞌab yey carelekꞌaj cꞌu lo rubitak re pa ja, we na cuyut ta nabe ri rajaw ja. Ma we relekꞌom uyutum chi ri rajaw ja, cꞌa ecꞌuchiriꞌ utz carelekꞌaj bi ronoje la cꞌo pa ri ja. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Pakatzij wi cambiꞌij chiwe: Cꞌo pukꞌab ri Dios cucuy ronoje tak ri mac que ri ticawex, rucꞌ ronoje tak ri na utz taj caquibiꞌij, tob china chirij; ");
INSERT INTO acrTNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","noꞌj china ri tzel cachꞌaꞌt chirij ri Santowilaj Ruxlabixel ri Dios, riꞌ na cacuytaj ta cꞌana umac. Ma ri caꞌanaw waꞌ, cꞌo chi ri kꞌatbal tzij puwiꞌ na jinta utakexic» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Xubiꞌij waꞌ ma rique quibiꞌim: «Rire cꞌo pukꞌab jun itzelilaj uxlabixel.» ");
INSERT INTO acrTNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tecꞌuchiriꞌ, ruchu y tak ruchakꞌ ri Jesús xecꞌunic y xecꞌojiꞌ lo pa be, yey xquitak usiqꞌuixic ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ecꞌu ri ticawex etzꞌulic, ri quisutum rij ri Jesús, jewaꞌ xquibiꞌij che: —Ri chu la y tak ri chakꞌ la e cꞌo pa be, e laꞌ caquitzucuj la —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ecꞌu ri Jesús xucꞌul uwach: —¿China ri nuchu y china tak ri nuchakꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tecꞌuchiriꞌ, xebutzuꞌ ri etzꞌulic quisutum rij y jewaꞌ xubiꞌij chique: —Wa e cꞌo wara e nuchu y e tak nuchakꞌ riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ma china ri cuꞌan janipa ri caraj ri Dios, waꞌ e nuchakꞌ, e wanab y e nuchu riꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ri Jesús xujek tanchi cacꞌutun chuchiꞌ ri mar y lic e qꞌui ri ticawex xemolotaj chiriꞌ pa cꞌo wi Rire. Ruma cꞌu riꞌ xoc chupa jun barco cꞌo chwi ri mar, xtzꞌuyiꞌ chupa y conoje ri ticawex e cꞌo pana chuchiꞌ la mar. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xujek cꞌu cacꞌutun chiquiwach rucꞌ uqꞌuiyal tak cꞌambal naꞌoj, yey jun che tak rucꞌutunic e waꞌ: ");
INSERT INTO acrTNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«¡Chitapeꞌ! Cꞌo jun awanel xel bi chaꞌ queꞌawanok. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ecꞌuchiriꞌ catajin che ujopopexic rijaꞌ, cꞌo xtzak can chuchiꞌ ri be. Xecꞌun cꞌu lo tzꞌiquin, y xoꞌlquitija bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","»Cꞌo ijaꞌ xtzak can pa tak abaj; yey ruma na jinta uqꞌuiyal ulew chuxeꞌ, xel tan lo rijaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ecꞌuchiriꞌ xel lo ri kꞌij, xcꞌatic; yey ruma na jinta ratzꞌayak, xchakijic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","»Cꞌo ijaꞌ xtzak can pa tak qꞌuix. Echiriꞌ ri qꞌuix xqꞌuiyic, rijaꞌ xjikꞌ can chuxeꞌ; ruma cꞌu riꞌ, na jinta rekaꞌn xuyaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","»Noꞌj cꞌo ijaꞌ xtzak can pa chomilaj ulew. Ecꞌu riꞌ waꞌ xel lok, xqꞌuiyic y lic xuꞌan rekaꞌn. Cꞌo jujun rakan xuya treinta, jujun chic xuya sesenta y cꞌo ne xuya jun ciento» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ecꞌuchiriꞌ, ri Jesús xubiꞌij tanchi chique: «China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Echiriꞌ ri Jesús xcanaj can utuquel, ri e cꞌo chunakaj y ri cablajuj utijoꞌn xekib rucꞌ, xquitzꞌonoj cꞌu che saꞌ queꞌelawi wa cꞌambal naꞌoj xuya chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ecꞌu ri Jesús xubiꞌij chique: «Chiwe riꞌix yaꞌtalic cakꞌalajisax runaꞌoj ri Dios chwi rutakanic. Noꞌj chique tak ri winak na e jinta chupa rutakanic, xa rucꞌ tak cꞌambal naꞌoj cabiꞌx ronoje chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ma tob rique quetzuꞌnic, e junam rucꞌ na quetzuꞌn taj; tob quetanic, e junam rucꞌ na quetan taj y e riꞌ na jinta cꞌo caquimaj usucꞌ. Na cacaj ta cꞌu riꞌ caquitzelej quitzij chaꞌ jelaꞌ cacuytaj quimac» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ecꞌuchiriꞌ, xutzꞌonoj chique: «¿Na quimaj ta cami usucꞌ riꞌ wa cꞌambal naꞌoj? ¿Saꞌ cꞌu uꞌanic riꞌ quimaj usucꞌ ronoje tak ri cꞌambal naꞌoj cancꞌut chiwach? ");
INSERT INTO acrTNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","»Ri awanel e pachaꞌ ri caticow Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","»E cꞌo cꞌu jujun ticawex e pachaꞌ rijaꞌ xtzak can chuchiꞌ ri be; waꞌ xtic Ruchꞌaꞌtem ri Dios pa canimaꞌ y caquita ne riꞌ. Pero cacꞌun cꞌu lo ri Satanás y cumaj bi ri Chꞌaꞌtem xtiquiꞌ pa canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","»E cꞌo jujun chic e pachaꞌ rijaꞌ xtzak can pa tak abaj. Waꞌ e ri caquita Ruchꞌaꞌtem ri Dios y na jampatana caquicꞌul rucꞌ quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero ruma na e tiquil ta chi utz, na quecowin taj. Ma echiriꞌ cacꞌun lo ri cꞌambal quipa o queternabex rucꞌ cꞌax ruma quicꞌulum Ruchꞌaꞌtem ri Dios, quepajtaj cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","»E cꞌo jujun chic e pachaꞌ rijaꞌ xtzak can pa tak qꞌuix. Waꞌ e ri quetaw Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero rubis quicꞌuꞌx chwi tak ri cajawax chique, rucꞌ ri socosoꞌnic re ri beyomalil y ri quirayibal che tak ronoje ri cꞌolic; ronoje cꞌu waꞌ e cusach uwach Ruchꞌaꞌtem ri Dios cꞌo pa canimaꞌ. Ruma tak cꞌu riꞌ waꞌ na jinta cꞌana quijikꞌobalil quilitaj che ri quibinic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","»E cꞌo cꞌu jujun e jelaꞌ pachaꞌ rijaꞌ xtzak pa chomilaj ulew. Waꞌ e ri caquita Ruchꞌaꞌtem ri Dios, caquicꞌul chi utz y lic cꞌo quijikꞌobalil quilitaj che ri quibinic. E jelaꞌ pachaꞌ rijaꞌ lic xuꞌan rekaꞌn; cꞌo jujun rakan xuya treinta, jujun chic xuya sesenta y cꞌo ne xuya jun ciento» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ri Jesús xubiꞌij tanchi chique: «¿Cꞌo neba junok cutzij juna akꞌ y cuchꞌuk uwiꞌ rucꞌ juna mulul re pajbal o cujuꞌ chuxeꞌ ruwarabal? ¿Na re ta neba cuya lo chupa rucꞌolibal chicaj? ");
INSERT INTO acrTNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma copon ri kꞌij echiriꞌ janipa ri na kꞌalajisam taj, cakꞌalajisax na; yey janipa ri ewatalic, quetaꞌmaxic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jewaꞌ xubiꞌij tanchi chique: «Lic chita chi utz janipa ri cambiꞌij chiwe, ma “rucꞌ ri pajbal quixpajan wi riꞌix, rucꞌ tanchi wa pajbal caꞌan pajanic chiwe.” Ecꞌu ri Dios cuya na chiwe lic quimaj usucꞌ ri cambiꞌij, we lic e quita ri nutzij. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma china ri cucꞌul chi utz janipa ri cacꞌut chwach, riꞌ cacꞌut ne más chwach y jecꞌulaꞌ cumaj más. Yey china ri na cucꞌul ta ri cacꞌut chwach, riꞌ camaj ne che janipa ri cuchꞌobo umajom chi usucꞌ» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xubiꞌij tanchi ri Jesús chique: «Rutakanic ri Dios e jelaꞌ pachaꞌ juna achi cutic rijaꞌ pulew. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rachi chakꞌab queꞌwarok y pakꞌij cawaꞌlij tanchic; yey na cumaj ta usucꞌ suꞌanic quel lo rijaꞌ y caqꞌuiyic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ma rulew utuquel cuꞌan rib che uqꞌuiyisaxic ri ticoꞌn. Nabe na e quel lo ri rakan ri ticoꞌn, teran cꞌu lo rutzicꞌ; tecꞌuchiriꞌ, cawachinic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ecꞌuchiriꞌ ya xriꞌjobic, catzak bi ri jos che ma e riꞌ xopon rukꞌijol molonic» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xubiꞌij tanchi ri Jesús: «¿Saꞌ rucꞌ cakajunimaj wi rutakanic ri Dios, o saꞌ juna cꞌambal naꞌoj cukꞌalajisaj waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E pachaꞌ rijaꞌ re moxtasa echiriꞌ catic pulew. Ma e ijaꞌ waꞌ más chꞌutiꞌn chwa tak rijaꞌ cꞌo che ruwachulew, ");
INSERT INTO acrTNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero echiriꞌ tiquital chic, we xqꞌuiyic más canimar chwa tak ri ticoꞌn cꞌo pa ri werta. Quel cꞌu lo nimak tak ukꞌab y quecꞌun lo ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj y quejekiꞌ chuxeꞌ rumuꞌj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rucꞌ uqꞌuiyal tak cꞌambal naꞌoj pachaꞌ tak waꞌ, xcꞌutun ri Jesús puwi Ruchꞌaꞌtem ri Dios, e chirij ri caquimaj usucꞌ ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Y na jinta cꞌo xucꞌutu we na rucꞌ ta cꞌambal naꞌoj xuꞌano; noꞌj chique rutijoꞌn xukꞌalajisaj ronoje echiriꞌ e cꞌo quituquel. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chupa cꞌu laꞌ la jun kꞌij echiriꞌ xoc rakꞌab, ri Jesús xubiꞌij chique rutijoꞌn: —Joꞌ, chojkꞌax chꞌaka yaꞌ —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Echiriꞌ ebuchꞌaꞌbem chi can ruqꞌuiyal winak, rutijoꞌn xquicꞌam bi ri Jesús e laꞌ chupa ri barco pa tzꞌul wi Rire, yey e cꞌo chi jujun barcos ecachbilam bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xpe cꞌu jun nimalaj cakjikꞌ chwi ri mar. Ecꞌu ri yaꞌ curoj rib che ri barco; y waꞌ xujek canoj che yaꞌ, ya laj camukutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ecꞌu ri Jesús cꞌo pa ri barco puqꞌuisbal re chirij, cawar chwi jun chꞌacat. Rutijoꞌn xeꞌquicꞌosoj y jewaꞌ xquibiꞌij che: —¡Kajawal! ¿Na coc ta cami la il chike? ¡Ma ya cojcamic! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ecꞌu ri Jesús xyactajic, xukꞌatej ri cakjikꞌ y jewaꞌ xubiꞌij che ri yaꞌ: —¡Chat-tanalok! ¡Chatcubulok! —xcha che. Ri cakjikꞌ xtaniꞌic y ri yaꞌ xyeniꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tecꞌuchiriꞌ, xubiꞌij chique rutijoꞌn: —¿Suꞌchac lic quixiꞌij iwib? ¿Suꞌbe na cubul ta icꞌuꞌx wucꞌ? —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ewi xoc lo jun xiꞌin ib cucꞌ y xquibiꞌij chiquiwach: —¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tob ne e ri cakjikꞌ y ri yaꞌ caquicoj utzij! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xebopon cꞌu chꞌaka yaꞌ pa ri luwar re Gadara. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Echiriꞌ xel lo ri Jesús chupa ri barco, na jampatana xoꞌlcꞌul ruma jun achi elinak lo chuxoꞌl tak mukubal que animaꞌ, yey waꞌ cꞌo pukꞌab jun itzelilaj uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Waꞌ waꞌchi jekel pa quemuk wi ri animaꞌ y na jinta chi cꞌana junok cachꞌijow uximic, tob ne rucꞌ carena. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ma lic uqꞌuiyal laj xyut ri rakan y rukꞌab rucꞌ tak chꞌichꞌ y carena; pero rire curakaraꞌ upa, cuꞌan ucꞌaj che y na jinta cꞌo cachꞌijow uchukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chipakꞌij chichakꞌab xaki casutin chwi tak ri juyub y chuxoꞌl tak mukubal que animaꞌ, casiqꞌuinic y cuꞌan cꞌax che rib rucꞌ abaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ecꞌuchiriꞌ chinimanaj xril pana ri Jesús, cacꞌalalic xkib rucꞌ y xuxucubaꞌ rib chwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y lic co xchꞌawic, jewaꞌ xubiꞌij: —¿Suꞌchac coꞌlmina ib la wucꞌ, Jesús lal Ucꞌajol ri Dios cꞌo chilaꞌ chicaj? Cantzꞌonoj cꞌu cheꞌla pa rubiꞌ ri Dios, minya la pa cꞌax —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Xubiꞌij waꞌ ma ri Jesús xubiꞌij che: «At itzelilaj uxlabixel, chatelubi che waꞌchi» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ecꞌu ri Jesús xutzꞌonoj che: —¿Saꞌ rabiꞌ? —xcha che. Rire xucꞌul uwach: —Legión ri nubiꞌ, ma lic oj qꞌui —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yey ritzelilaj uxlabixel lic xucoj rib chwach ri Jesús chaꞌ na quetak tubi cꞌa naj che tak laꞌ la luwar. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Xa chiriꞌ cꞌu riꞌ e cꞌo lo uqꞌuiyal ak quewaꞌ chwa ri juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","E tak cꞌu ri itzelilaj uxlabixel xquicoj quib chwach ri Jesús y jewaꞌ xquibiꞌij che: —Chojtaka bi la cucꞌ la ak chaꞌ cojoc bi cucꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Y ri Jesús xuya luwar chique. Xebel cꞌu bi che rachi y xeboc bi cucꞌ ri ak. Waꞌ wa ak laj e juna queb mil. Ecꞌu laꞌ conoje xeꞌquicꞌaka bi quib chwi jun siwan, xebeꞌtzak cꞌa chupa ri mar y chiriꞌ xejikꞌ wi. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ecꞌu ri e chajinel que ri ak, xebanimajic. Y janipa ri xquilo xebec che utzijoxic chupa ri tinamit y pa tak juyub. Xepe cꞌu ri winak che rilic saꞌ ri xꞌaniꞌ chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Echiriꞌ xecꞌun pa cꞌo wi ri Jesús, xquil rachi ri lic xꞌan cꞌax che cuma ritzelilaj uxlabixel; e riꞌ tzꞌulic, ucojom chi ukꞌuꞌ y jusucꞌ chi runaꞌoj. Ruma waꞌ, lic xquixiꞌij quib. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y ri xebilow waꞌ xquitzijoj chique ri cꞌacꞌ xecꞌunic; xquitzijoj suꞌanic xebel bi ritzelilaj uxlabixel che rachi y saꞌ ri xquicꞌulumaj tak ri ak. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ewi ri winak xquijeko quebelaj che ri Jesús chaꞌ quel bi chiriꞌ pa tak ri quiluwar. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ecꞌuchiriꞌ, ri Jesús xoc bi chupa ri barco. Ecꞌu rachi ebelinak bi ritzelilaj uxlabixel che, xelaj che ri Jesús chaꞌ cuya luwar che caterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Noꞌj ri Jesús na xuya ta luwar che, jenewaꞌ xubiꞌij che: —Jat chaꞌwocho cucꞌ rawatz-achakꞌ y chatzijoj chique ronoje ri utz uꞌanom ri Dios awucꞌ, ma e xucꞌut ri cꞌaxnaꞌbal ucꞌuꞌx chawe —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Rachi xeꞌec y xujek utzijoxic pa ri tinamit re Decápolis ronoje ri utz xꞌan che ruma ri Jesús, y conoje ri ticawex lic cacam canimaꞌ che waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Echiriꞌ xtzelej tanchi ri Jesús chꞌaka yaꞌ chupa ri barco, uqꞌuiyal ticawex xquimoc rij y Rire xcꞌojiꞌ chuchiꞌ ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xcꞌun cꞌu lo jun achi Jairo rubiꞌ, rire e jun chique ri e aj wach re ri sinagoga. Xew cꞌu xril uwach ri Jesús, xucꞌak rib xeꞌrakan ukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y lic xucoj rib chwach, jewaꞌ xubiꞌij che: —Ri numiꞌal cajecꞌowic. Joꞌ co la wucꞌ, queꞌyaꞌa ri kꞌab la puwiꞌ chaꞌ cacunutajic y jelaꞌ na cacam taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xeꞌec cꞌu ri Jesús rucꞌ rachi, yey uqꞌuiyal winak xeterej bi chirij y lic caquipitzꞌipaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chiquixoꞌlibal cꞌu riꞌ cꞌo jun ixok lic yewaꞌ, e cablajuj lo junab riꞌ na cataniꞌ ta ruyabil re upa icꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Y lic utijom cꞌax paquikꞌab uqꞌuiyal e aj cun, y uqꞌuisom chi ne ronoje ri cꞌo rucꞌ; yey na jinta cꞌana xutikoj che, ma catajin ne unimitajic ri jujun kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Echiriꞌ xuta ri caquibiꞌij puwi ri Jesús, xumin bi rib chiquixoꞌlibal tak ri winak. Xkib cꞌu pana chirij ri Jesús y xuchap rukꞌuꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ma xuchꞌob pa ranimaꞌ: «Tob tane xew luꞌkꞌuꞌ canchapo, rucꞌ riꞌ quincunutajic.» ");
INSERT INTO acrTNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y na jampatana xtaniꞌ ruyabil y lic xunaꞌ chiribil rib xcunutaj che ri cꞌaxlaj yabil cꞌo wi. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ecꞌu ri Jesús echiriꞌ xunaꞌ chiribil rib cꞌo uchukꞌab xelic, xebutzuꞌ conoje ri winak y xutzꞌonoj: —¿China xchapaw ri nukꞌuꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rutijoꞌn xquibiꞌij che: —Rilal quil la ri winak caquipitzꞌipaꞌ la. ¿Suꞌchac cꞌu riꞌ catzꞌonoj la: “China xchapaw weꞌin”? —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús xtzuꞌn pa tak utzal che rilic china xchapaw re. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ecꞌu rixok cabirbot ruma xiꞌin ib, ma rire e etaꞌmayom saꞌ ri xucꞌulu. Xeꞌec cꞌut y xuxucubaꞌ rib xeꞌrakan ukꞌab ri Jesús. Yey xutzijoj che Rire ronoje rucꞌulumam y saꞌ ri xuꞌan la jokꞌotaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ecꞌu ri Jesús xubiꞌij che: —Ixok, ruma ri cubulibal cꞌuꞌx la wucꞌ, xcunutaj la. Oj cꞌu la riꞌ chi utzil chomal, ma lal chi cunutajinak che ri cꞌaxcꞌolil la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cꞌa cachꞌaꞌt ne ri Jesús echiriꞌ xecꞌun lo jujun achijab e petinak chirocho ri aj wach re ri sinagoga y xoꞌlquibiꞌij che: —Ri miꞌal la ya xcamic; na jinta chi cutikoj cabayabaꞌ la ri tijonel —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ecꞌu ri Jesús, echiriꞌ xuta wa xoꞌlbiꞌxok, xubiꞌij che raj wach re ri sinagoga: —Muxiꞌij rib cꞌuꞌx la, xew lic cubula cꞌuꞌx la wucꞌ —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ri Jesús na xuya ta chi luwar che junok caterej bi chirij; xew xebucꞌam bi ri Pedro, ri Jacobo y ri Juan ruchakꞌ ri Jacobo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ecꞌuchiriꞌ xopon chirocho raj wach re ri sinagoga, xeril ri winak quetucuquic, quebokꞌic y rucꞌ sicꞌ quetunanic. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ecꞌu ri Jesús xoc bi y xubiꞌij chique: —¿Suꞌbe lic quixtucuquic y quixokꞌic? Ri ralco ali na caminak taj, xa cawaric —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yey xa xquitzeꞌej cꞌu ri xubiꞌij. Pero Rire xeberesaj lo conoje ri e cꞌo pa ja, xew xebucoj bi ruchu-ukaw ri ralco ali cucꞌ rutijoꞌn eteran bi chirij. Xoc cꞌu bi pa telan wi ri ralco ali. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Xuchap cꞌu rukꞌab y jewaꞌ xubiꞌij pa ri chꞌaꞌtem arameo: —¡Talita cumi! —xcha che. (Waꞌ e queꞌelawi: “Ali chuuy, ¡Chatwaꞌlijok!”) ");
INSERT INTO acrTNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Y na jampatana ri ralco ali xwaꞌlijic y xbinic. (Rali cablajuj rujunab.) Y ri winak lic xquixiꞌij quib che wa xquilo. ");
INSERT INTO acrTNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ecꞌu ri Jesús lic xpixaban che chaꞌ na jinta cꞌo caquitzijoj wi y xtakan cꞌu che chaꞌ cayaꞌ uwa ri ralco ali. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ri Jesús xel bi chiriꞌ y xopon pa rutinamit. Ecꞌu rutijoꞌn xeterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Echiriꞌ xopon ri kꞌij re uxlanibal, xujek cacꞌutun chupa ri sinagoga. Yey uqꞌuiyal winak xquito y lic xcam canimaꞌ che, jecꞌuwaꞌ caquibiꞌij: —¿Pa xuꞌmaja wi waꞌchi ronoje tak waꞌ? ¿Saꞌ chi naꞌoj wa yaꞌtal che, yey suꞌanic cuꞌan tak wa milagros? ");
INSERT INTO acrTNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Na e ta neba jun achi carpintero; ralab ri María y catzixel ri Jacobo, ri José, ri Judas y ri Simón? ¿Na ejekel ta neba ri ranab wara chikaxoꞌl? —quechaꞌ. Ewi lic e qꞌui tzel xquita ri xubiꞌij y xquijek caquicꞌak bi ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ecꞌu ri Jesús xubiꞌij chique: —Chupa ronoje luwar cayac ukꞌij juna kꞌalajisanel. Noꞌj chupa rutinamit, chiquixoꞌl ri ratz-uchakꞌ y pa rocho, na cayac ta ukꞌij —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chupa cꞌu riꞌ rutinamit xa e queb oxib ri xuya rukꞌab paquiwiꞌ y xebucunaj, noꞌj na utz taj xuꞌan juna chic milagro ");
INSERT INTO acrTNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ma ri ticawex na caquicoj taj china Rire. Ecꞌu ri Jesús lic xcam ranimaꞌ che waꞌ. Xicꞌow cꞌu pa tak ri aldeas cꞌo chunakaj ri tinamit e riꞌ cacꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tecꞌuchiriꞌ, xebusiqꞌuij ri cablajuj utijoꞌn, xebutak bi pa cacab y xuya paquikꞌab quebequesaj bi itzelilaj uxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yey xebutak che na jinta cꞌo caquicꞌam bi re pa be; xew caquicꞌam bi ri quichꞌamiꞌy. Na caquicꞌam tane bi quiteb, quiwa o quimeyo chwi ri quipas. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yey utz caquicoj bi quixajab; noꞌj na utz taj caquicꞌam bi jumolaj chic quikꞌuꞌ, xew ri quicojom. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y xubiꞌij bi chique: «We quixcꞌul pa juna ja, chixcꞌola chiriꞌ; cꞌate quixel bi echiriꞌ quixꞌec pa jun chic tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Noꞌj we chupa juna tinamit na quixcꞌul taj y na cacꞌul tane ri Utzilaj Tzij quitzijoj, chixelubi chiriꞌ yey chipupaꞌ can rulew cꞌo che ri iwakan; waꞌ e cꞌutubal re na utz ta quiꞌanom ri ejekel chiriꞌ. Pakatzij wi cambiꞌij chiwe: Chupa rukꞌijol ri kꞌatbal tzij, más cꞌax ri cape paquiwi rique chwa ri cape paquiwi ri e aj Sodoma y Gomorra» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xebel cꞌu bi rutijoꞌn che utzijoxic chique ri ticawex puwi ri lic chirajawaxic caquitzelej quitzij chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xebequesaj bi uqꞌuiyal itzel uxlabixel yey xquicoj aceite paquiwi uqꞌuiyal yewaꞌib y xequicunaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri rey Herodes xuta puwi ri chom uchꞌaꞌtibexic ri Jesús, ma lic xetaꞌmax rubiꞌ pa tak ronoje luwar. Ecꞌu ri Herodes xubiꞌij: «Laꞌ e ri Juan Aj Yaꞌl Bautismo xcꞌastaj lo chiquixoꞌl ri ecaminak; e uwariꞌche cꞌo uchukꞌab che uꞌanic wa milagros» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yey e cꞌo jujun chic quebiꞌn re: «Rire e Elías» y jujun chic quebiꞌn re: «E juna kꞌalajisanel o laj junok chique ri kꞌalajisanelab re ojertan.» ");
INSERT INTO acrTNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Echiriꞌ xuta waꞌ ri Herodes, xubiꞌij: «Laꞌ e ri Juan ri jun xintak ukꞌatic rujolom, xcꞌastaj lo chiquixoꞌl ri ecaminak» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Xubiꞌij waꞌ ma e rire ri xutak uchapic ri Juan chaꞌ cayaꞌiꞌ pa carena y queꞌyoꞌk pa cárcel. Xuꞌan waꞌ ri Herodes ma ri Juan xuchꞌaꞌbej upa ruma uꞌanom rixokil che ri Herodías, yey waꞌ wiꞌxok e rixokil ri Felipe ruchakꞌ ri Herodes. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jewaꞌ ri xubiꞌij ri Juan che: «Lic na ube taj ꞌanom ixokil la che ri rixokil ri chakꞌ la» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ruma cꞌu laꞌ, rixok Herodías lic xutzucuj saꞌ cuꞌan che ri Juan. Lic xraj cucamisaj; pero na curik taj saꞌ uꞌanic cuꞌano, ");
INSERT INTO acrTNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ma ri Herodes cuxiꞌij ne rib chwach ri Juan. Yey utakom ne uchajixic chaꞌ na jinta cucꞌulumaj, ma retaꞌam ri Juan e jun achi lic jusucꞌ y lic uyaꞌom rib pukꞌab ri Dios. Echiriꞌ ri Herodes cuta rucꞌutunic ri Juan, tob na cumaj ta usucꞌ, lic cacha ucꞌuꞌx che utayic. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ewi xopon jun kꞌij echiriꞌ ri Herodes xuqꞌuis ujunab y xuya jun nimalaj waꞌim chique tak raj wach e cꞌo rucꞌ, cucꞌ ri e takanelab que rusoldados y ri e aj Galilea lic cꞌo quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Xoc cꞌu bi ri ralit rixok Herodías pa cꞌo wi ri Herodes cucꞌ conoje tak ri e cꞌo chwa ri mexa, y xujek caxajaw chiquiwach. Waꞌ lic xucꞌul quicꞌuꞌx conoje ri e cꞌo chiriꞌ. Ewi ri Herodes jewaꞌ xubiꞌij che laꞌli: «Chatzꞌonoj saꞌ ri cawaj, ma riꞌin canya chawe» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Y xujiquibaꞌ cꞌu uwach che: «Ronoje ri catzꞌonoj, canya chawe, tob ne pa nicꞌaj che tak ri cꞌo panukꞌab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ewi rali xel bi chaꞌ cuꞌtzꞌonoj che luꞌchu: «¿Saꞌ nawi ri cantzꞌonoj?» xchaꞌ. «E chatzꞌonoj rujolom ri Juan Aj Yaꞌl Bautismo» xcha ruchu che. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na jampatana cꞌu riꞌ, rali lic canic xoc bi chwa ri rey Herodes y jewaꞌ xubiꞌij che: «Cuaj caya la chwe woꞌora pa juna plato rujolom ri Juan Aj Yaꞌl Bautismo» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ri rey lic xbisonic ruma ri xtzꞌonox che. Pero ruma cꞌu ri xujiquibaꞌ uwach che rali chiquiwach conoje ri e cꞌo rucꞌ pa waꞌim, na xraj ta chic xujecꞌ ruchꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ewi xutakalaꞌ bi jun soldado chaꞌ queꞌec y cucꞌam lo rujolom ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ri soldado xeꞌec pa ri cárcel y xucꞌatzij rujolom ri Juan. Xucꞌam lo pa jun plato y xuya cꞌu che rali, y rali xuꞌyaꞌa che ruchu. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Echiriꞌ xquita waꞌ rutijoꞌn ri Juan, xoꞌlquicꞌama rucuerpo y xeꞌquimukuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Echiriꞌ rutakoꞌn ri Jesús xetzelej lo che utzijoxic ri Utzilaj Tzij, xquimol quib rucꞌ Rire y xquitzijoj che janipa ri xquiꞌano y xquicꞌutu. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ecꞌu ri Jesús xubiꞌij chique: —Chixpeta wucꞌ ituquel, joꞌ chaꞌ cojeꞌuxlan qꞌuenok pa juna luwar pa na e jinta wi winak —xchaꞌ. Jelaꞌ xubiꞌij chique ma lic e qꞌui ri winak, e cꞌo ri quebec y e cꞌo ri quecꞌunic yey rique na utz ta chi ne quewaꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xeboc cꞌu bi ri Jesús cucꞌ rutijoꞌn quituquel chupa jun barco y xebec pa jun luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero lic e qꞌui ri xebilowic echiriꞌ xebec y xquetaꞌmaj uwach ri Jesús. Ewi uqꞌuiyal winak xebec chakan, waꞌ ebelinak lo pa tak ri tinamit. Nabe cꞌu riꞌ xebopon chwa ri Jesús yey echiriꞌ Rire xoponic, xquimol quib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Echiriꞌ xel lo ri Jesús pa ri barco, xrilo e cꞌo chi uqꞌuiyal winak chiriꞌ. Lic cꞌut xejuchꞌ caꞌn pa ranimaꞌ, ma pachaꞌ e bexex na jinta chajinel que. Ecꞌu ri Jesús xujek cuya uqꞌuiyal cꞌutunic chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Echiriꞌ lic benak kꞌij chic, xekib lo rutijoꞌn rucꞌ y jewaꞌ xquibiꞌij che: —Kajawal, wa luwar oj cꞌo wi lic catzꞌintzꞌotic y benak kꞌij chic. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Utz we quetak bi la ri winak chaꞌ quebec pa tak raldeas y pa tak ri luwar cꞌo lo xa nakaj re queꞌquilokꞌo quiwa, ma ri wara na jinta cꞌo catijic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Noꞌj ri Jesús xucꞌul uwach: —Chebitzuku riꞌix —xcha chique. Rique xquibiꞌij che: —¿E cami caꞌaj la riꞌ queꞌkalokꞌo quiwa conoje wa ticawex chaꞌ quekatzuku? ¡Ri rajil waꞌ e junam rucꞌ queb ciento kꞌij re chac! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ri Jesús xubiꞌij chique: —¿Janipa chi pam cꞌo iwucꞌ? Jix jiꞌwilapeꞌ —xcha chique. Echiriꞌ xquetaꞌmaj, xquibiꞌij che: —Xa woꞌob chi pam y caꞌib chi car —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ecꞌu ri Jesús xtakan che quetzꞌuyiꞌ conoje ri ticawex chimutzaꞌj pa tak ri rax qꞌuim. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Xetzꞌuyiꞌ cꞌu chimutzaꞌj re jujun ciento y re nicꞌaj ciento. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ecꞌu ri Jesús xucꞌam ri woꞌob pam rucꞌ ri caꞌib car, xtzuꞌn chicaj y xtioxin chwach ri Dios. Tecꞌuchiriꞌ, xuwechꞌ upa ri pam y xuya chique rutijoꞌn chaꞌ caquijach chique ri winak. Y jelaꞌ xuꞌan rucꞌ ri queb car, xjachiꞌ cꞌu riꞌ waꞌ chique conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Conoje cꞌu ri winak xewaꞌic y xenoj chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tecꞌuchiriꞌ, xquimol ri chꞌakaꞌtaꞌk pam y car, y rucꞌ waꞌ xnoj lo cablajuj chacach. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yey ri xewaꞌic e lo woꞌob mil chi achijab. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tecꞌuchiriꞌ, ri Jesús xebutak rutijoꞌn chaꞌ queboc bi chupa ri barco, quenabej bi chwach y quekꞌax cꞌa chꞌaka yaꞌ che ri tinamit Betsaida, xalokꞌ Rire quebuchꞌaꞌbej tak can ruqꞌuiyal winak. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Echiriꞌ ebuchꞌaꞌbem chi canok, xel bi chwa ri juyub chaꞌ cuꞌana orar. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Echiriꞌ xoc rakꞌab, ri barco cꞌo chi punicꞌajal ri mar, yey ri Jesús utuquel canajinak can chuꞌlew. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anim tan cꞌu riꞌ, ri Jesús xeril pan rutijoꞌn lic rucꞌ cꞌax quetajin che ubinisaxic ri barco ruma runimal tew petinak chiquiwach. Ecꞌu ri Jesús xeꞌec cucꞌ; e riꞌ cabin chwi ri mar, ya e riꞌ quicꞌow chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero rutijoꞌn echiriꞌ xquilo cabin chwi ri yaꞌ, xquichꞌobo e juna espíritu. Xquijek cꞌu riꞌ quesiqꞌuinic, ");
INSERT INTO acrTNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ma conoje xquilo y lic xquixiꞌij quib che. Tecꞌuchiriꞌ, ri Jesús xebuchꞌaꞌbej, jewaꞌ xubiꞌij chique: —Chinimarisaj icꞌuꞌx, ma riꞌin in Jesús; mixiꞌij cꞌu iwib —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xoc cꞌu bi ri Jesús cucꞌ chupa ri barco; ecꞌu runimal tew xtaniꞌic. Rutijoꞌn lic xcam canimaꞌ che, ");
INSERT INTO acrTNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ma cꞌamajaꞌ ne caquimaj usucꞌ ri xuꞌan ri Jesús echiriꞌ xuꞌan qꞌui che ri pam, ma e pachaꞌ chꞌukutal ri quinaꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ecꞌuchiriꞌ xquikꞌaxuj ri yaꞌ, xebopon che ri luwar re Genesaret y xquixim ri barco chuchiꞌ ri yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Echiriꞌ xebel lo chupa ri barco, na jampatana ri winak xquetaꞌmaj uwach ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xebec cꞌu riꞌ re caquitzijoj puwi ri Jesús pa tak ronoje ri luwar re Genesaret. Yey ri winak re ronoje tak luwar xquijek quequicꞌam tak lo yewaꞌib e telem lo chwa chꞌat cꞌa pa ri luwar pa quitom cꞌo wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y tob pa tak chawi xoc wi ri Jesús, pa tak tinamit, pa tak aldeas o pa tak juyub, e cꞌo ri quequiya ri yewaꞌib chuchiꞌ tak ri be y caquicoj cꞌu quib chwach ri Jesús chaꞌ cuya luwar chique tob ne xew ruchiꞌ rukꞌuꞌ caquichapo. Conoje cꞌu ri quebanaw waꞌ, quecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ecꞌu ri fariseos cucꞌ jujun chique raj cꞌutunel re ri tzijpixab e petinak Jerusalem, xquimol quib rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waꞌ waꞌchijab xquijek quequichꞌaꞌtibej jujun chique rutijoꞌn ri Jesús ma xequilo quewaꞌic yey na quichꞌajom ta ri quikꞌab. Y waꞌ na e ta quicꞌutuꞌn can ri catiꞌ-quimam. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ma ri fariseos y ri nicꞌaj chic aj judiꞌab e lic quitakem ri quicꞌutuꞌn can ri catiꞌ-quimam. Rique na quewaꞌ taj we na caquichꞌaj ta nabe ri quikꞌab chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y echiriꞌ quetzelej lo pa cꞌaybal, na jinta cꞌo caquitijo we na caquichꞌaj ta nabe ri quikꞌab, jelaꞌ pachaꞌ ri cꞌutum can chique. Yey quitakem uqꞌuiyal cꞌutunic xa quimajom can chiquij catiꞌ-quimam, jelaꞌ pachaꞌ ruꞌanic cachꞌaj tak upa ri tijbal yaꞌ, ri xaro, rubitak saꞌch re chꞌichꞌ y rujoskꞌixic ri chꞌat re warabal. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ruma cꞌu laꞌ ri fariseos y raj cꞌutunel re ri tzijpixab xquitzꞌonoj che ri Jesús: —¿Suꞌbe ri tijoꞌn la na quitakem ta ri quicꞌutuꞌn can ri katiꞌ-kamam? Ma rique quewaꞌic tob e laꞌ na quichꞌajom ta ri quikꞌab —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ecꞌu ri Jesús xucꞌul uwach: —¡Xa queb palaj alak! Lic katzij ri tzꞌibital can ruma ri kꞌalajisanel Isaías pawiꞌ alak. Ma jewaꞌ xutzꞌibaj canok: Waꞌ wa tinamit xa rucꞌ ruwaqueꞌ caquiyac nukꞌij, noꞌj ri canimaꞌ lic naj cꞌo wi chwe. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na jinta cꞌana cutikoj caquilokꞌoj nukꞌij, ma ri cꞌutunic caquiꞌano xa takanic que achijab. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ecꞌu ralak e yaꞌom can alak Rutzij Upixab ri Dios y e lic coc alak il che uꞌanic ri quicꞌutuꞌn can ri ticawex, pachaꞌ caꞌan alak rucꞌ rujoskꞌixic ri tijbal yaꞌ y ruchꞌajic upa ri xaro; yey cꞌo ne jujun chic pachaꞌ tak waꞌ caꞌan alak xa majom can alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Je tanchi cꞌu waꞌ xubiꞌij chique: —Ralak ꞌanom alak che Rutzij Upixab ri Dios pachaꞌ na jinta uchac, ruma e lic catajin alak che uꞌanic ri quicꞌutuꞌn can ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ma ri Moisés jewaꞌ utzꞌibam can ojertan: Chalokꞌoj quikꞌij rachu-akaw yey We cꞌo junok quebuyaj ruchu-ukaw rucꞌ itzel chꞌaꞌtem, riꞌ lic takal che cacamisaxic xcha ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","»Noꞌj ralak cabiꞌij alak: “Utz we juna achi xew cubiꞌij chique ruchu-ukaw: Na utz taj cantoꞌ alak, ma ri toꞌbal cajawax che alak, nubiꞌtisim chic re nukasaꞌn chwach ri Dios.” ");
INSERT INTO acrTNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yey chiwach ralak, china ri cabiꞌn re waꞌ, na chirajawaxic ta chi che quebutoꞌ ruchu-ukaw. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jecꞌuriꞌlaꞌ ꞌanom alak che Rutzij Upixab ri Dios pachaꞌ na jinta uchac, ruma tak ri noꞌjibal petinak lo chique ri chuꞌkaw alak. Yey takem alak uqꞌuiyal cꞌutunic pachaꞌ tak waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tecꞌuchiriꞌ, ri Jesús xebusiqꞌuij conoje ruqꞌuiyal ticawex y jewaꞌ xubiꞌij chique: —Lic tanape onoje alak y lic maja alak usucꞌ waꞌ: ");
INSERT INTO acrTNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ri cachꞌulan ri ranimaꞌ ri ticawex na e ta ri cutij bi, ma e ri quel lo pa ranimaꞌ, e waꞌ ri cachꞌulan re. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ! —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ecꞌu ri Jesús xebuya can ruqꞌuiyal ticawex y xoc bi che jun ja. Tecꞌuchiriꞌ rutijoꞌn xquiꞌan tzꞌonobal che puwi wa cꞌambal naꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ewi rire xubiꞌij chique: —¿Ix neba jun riꞌix chique ri na jinta quinaꞌoj puwi waꞌ? ¿Na quimaj ta neba usucꞌ e ri cachꞌulan ri ranimaꞌ ri ticawex na e ta ri cutij bi? ");
INSERT INTO acrTNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ma e janipa ri cutij bi, riꞌ na coc ta chupa ri ranimaꞌ; xa chupa rupa queꞌec wi. Tecꞌuchiriꞌ, cuꞌpamaj bi —xchaꞌ. Rucꞌ waꞌ ri Jesús xraj xubiꞌij e ronoje tak ri re catijic, lic utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Je tanchi waꞌ xubiꞌij chique: —E ri quel lo pa ranimaꞌ ri ticawex, e waꞌ ri cachꞌulan re. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ma pa ranimaꞌ ri ticawex quel wi lo tak ritzel naꞌoj, ri macunic chirij ri cꞌulaniquil, ri caretzꞌabej uwa ukꞌij rucꞌ jun chic na ucꞌulel taj, ri camisanic, ");
INSERT INTO acrTNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ri elekꞌ, ri rayinic re puak, ri retzelal cꞌuꞌxaj, ri socosoꞌnic; ri rayibal re ri tiꞌjil, ri cꞌax cꞌuꞌxaj chirij jun chic, ri itzel chꞌaꞌtem chirij junok, ri cuꞌan nim chiribil rib, ri na cuchꞌob tana saꞌ ri cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronoje tak waꞌ wa itzel uwach, chupa ri ranimaꞌ ri ticawex quel wulok y e cachꞌulan re rubinic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xel bi ri Jesús chiriꞌ y xopon pa tak ri luwar re Tiro y re Sidón. Xoc cꞌu chuchiꞌ jun ja. Na xraj taj cꞌo quetaꞌman re we Rire cꞌo chiriꞌ; na rucꞌ ta cꞌu riꞌ, xquetaꞌmaj ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Cꞌo cꞌu jun ixok, e ri ralit cꞌo pukꞌab jun itzel uxlabixel. Xew xuto cꞌo ri Jesús chiriꞌ, xcꞌunic y xucꞌak rib xeꞌrakan ukꞌab ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ecꞌu rixok na cuqꞌuil ta ri aj judiꞌab yey alaxel pa ri luwar re Sirofenicia. Xelaj cꞌu che chaꞌ caresaj bi ri itzel uxlabixel che ri ralit. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ecꞌu ri Jesús xubiꞌij che: —Chirajawaxic na nabe quewaꞌic y quenoj ri e ralcꞌoꞌal ri rajaw ja, ma na usucꞌ taj we junok cumaj ri quiwa ri ralcꞌoꞌal y cucꞌak bi chiquiwa ri tzꞌiꞌ —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Rixok xucꞌul uwach: —Katzij, Kajawal, pero ¿na quewaꞌ ta neba ri tzꞌiꞌ rucꞌ rucꞌaj quiwa racꞌalab catzak chuxeꞌ ri mexa? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ri Jesús xubiꞌij che: —Ruma wa xabiꞌij, canya chawe ri xatzꞌonoj. Jat cꞌu woꞌora ma ri itzel uxlabixel elinak chubi che rawalit —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ecꞌuchiriꞌ xopon rixok chirocho, xuꞌrika ri ralit cotzꞌol chwa uwarabal yey elinak chubi ri itzel uxlabixel che. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ecꞌuchiriꞌ, xel tanchi ubi ri Jesús che tak ri luwar re Tiro y xicꞌow pa ri tinamit Sidón. Xopon cꞌu chuchiꞌ ri mar re Galilea y xeꞌela pa tak ri luwar re Decápolis. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiriꞌ xquicꞌam lo chwach ri Jesús jun achi tꞌoꞌc y cachꞌikchꞌotic, yey ri ecꞌamayom lok xebelaj che chaꞌ cuya rukꞌab puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ecꞌu ri Jesús xresaj bi rachi chiquixoꞌl ri winak. Tecꞌuchiriꞌ xujuꞌ ruwi tak ukꞌab puxiquin rachi y xucoj jubikꞌ ucꞌaxaj tzaꞌm ri rakꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Xtzuꞌn chicaj, xuqꞌuis ucꞌuꞌx y jecꞌuwaꞌ xubiꞌij che rachi: «¡Efata!» (Waꞌ pa ri chꞌaꞌtem arameo queꞌelawi “chatjakatajok”.) ");
INSERT INTO acrTNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na jampatana cꞌu riꞌ, rachi xjakataj ruxiquin, xquiritaj ri rakꞌ y xujeko cachꞌaꞌt chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ecꞌu ri Jesús lic xebupixabaj ri winak chaꞌ na jinta cꞌana cꞌo caquitzijoj wi, noꞌj ri winak tob ne quepixabaxic, más ne xebec che utzijoxic. ");
INSERT INTO acrTNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lic cꞌu cacam canimaꞌ ri winak che y jewaꞌ caquibiꞌij: «Ronoje ri cuꞌano lic utz, ma ri e tꞌoꞌc cuꞌan chique quetanic yey ri e meꞌt cuꞌan chique quechꞌawic.» ");
INSERT INTO acrTNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupa tak laꞌ la kꞌij xquimol quib uqꞌuiyal ticawex. Y ruma na jinta quiwa re caquitijo, ri Jesús xebusiqꞌuij rutijoꞌn y xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Lic cajuchꞌ caꞌn nucꞌuꞌx chique wa ticawex ma e urox kꞌij waꞌ e cꞌo wucꞌ y na jinta chi quiwa. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yey we e laꞌ quebenutak bi chicocho y na jinta cꞌo quitijom, riꞌ quebeꞌkꞌochkꞌob pa be, ma e cꞌo jujun chique lic naj e petinak wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rutijoꞌn xquibiꞌij che: —Pero, ¿pa carikitaj wi wa re quetzuk wa uqꞌuiyal ticawex? Ma chupa wa luwar na jinta ne cꞌo e jekelic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ri Jesús xutzꞌonoj cꞌu chique: —¿Janipa chi pam cꞌo iwucꞌ? —xcha chique. —Wukub —xecha rique. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ewi ri Jesús xtakan che quetzꞌuyiꞌ ri ticawex chuꞌlew. Xucꞌam cꞌu ri wukub pam y xtioxin chwach ri Dios. Tecꞌuchiriꞌ, xuwechꞌ upa y xuya chique rutijoꞌn chaꞌ caquijach chique ruqꞌuiyal ticawex; y rique e xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yey cucꞌaꞌam ne jujun raltak co car. Ecꞌu ri Jesús xtioxin chwach ri Dios puwi waꞌ y xtakan cꞌu che cajachiꞌ chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewaꞌ cꞌut y lic xenoj chi utz. Tecꞌuchiriꞌ, xmol ri chꞌakaꞌtaꞌk quikax y rucꞌ waꞌ xnoj wukub chacach. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xewaꞌic, laj e juna cajib mil ticawex. Ecꞌu ri Jesús xebuchꞌaꞌbej canok, ");
INSERT INTO acrTNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","xoc cꞌu bi chupa ri barco cucꞌ rutijoꞌn y xebec pa tak ri luwar re Dalmanuta. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Cꞌo jun kꞌij ri fariseos xebopon rucꞌ ri Jesús y xquijeko e laꞌ xa pa chꞌaꞌtem caquichap pa chꞌaꞌoj. Xquitzꞌonoj cꞌu che cuꞌan juna cꞌutubal re chilaꞌ chicaj chiquiwach chaꞌ cakꞌalajinic we Rire takom lo ruma ri Dios; waꞌ xquiꞌano xa re cꞌambal upa. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ecꞌu ri Jesús lic xuqꞌuis ucꞌuꞌx y xubiꞌij chique: «¿Suꞌbe ri ticawex re wakꞌij ora e caquitzꞌonoj canꞌan juna cꞌutubal chaꞌ cakꞌalajinic we intakom lo ruma ri Dios? Pakatzij wi cambiꞌij chiwe: Na jinta juna cꞌutubal cayaꞌtaj chique» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ewi xebuya canok, xoc tanchi ubi chupa ri barco y xkꞌax chꞌaka yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ecꞌu rutijoꞌn ri Jesús xicꞌow chiquicꞌuꞌx caquicꞌam bi pam y xa jun chi pam cꞌo cucꞌ chupa la barco. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ewi ri Jesús xebupixabaj, jewaꞌ xubiꞌij chique: «Lic chichajij iwib chwa ri “levadura” que ri fariseos y chwa ri “levadura” re ri Herodes» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rutijoꞌn xquibiꞌij cꞌu chiquiwach: «Cubiꞌij waꞌ ma retaꞌam na jinta pam xkacꞌam lok» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ri Jesús xretaꞌmaj saꞌ la caquichꞌaꞌtibej chiquiwach y xubiꞌij cꞌu chique: —¿Suꞌbe quichꞌaꞌtibej chiwach puwi ri na xicꞌam ta lo pam? ¿Cꞌamajaꞌ neba quimaj usucꞌ? ¿Lic cami cꞌa chꞌukutal rinaꞌoj? ");
INSERT INTO acrTNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Cꞌo waꞌ cꞌu iwach yey e pachaꞌ na quixtzuꞌn taj. Cꞌo waꞌ cꞌu ixiquin yey e pachaꞌ na quixtan taj. ¿Lic neba na cacꞌun ta chicꞌuꞌx ");
INSERT INTO acrTNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","echiriꞌ xinjach ri woꞌob pam chique ri woꞌob mil ticawex? ¿Janipa cꞌu chacach xinojisaj rucꞌ ri quikax? —xchaꞌ. Rutijoꞌn xquicꞌul uwach: —Cablajuj chacach —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xutzꞌonoj tanchi chique: —Yey echiriꞌ xinjach ri wukub pam chique ri cajib mil ticawex, ¿janipa lo chacach xinojisaj rucꞌ ri quikax? —xchaꞌ. Rique xquicꞌul uwach: —Wukub chacach —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jecꞌuwaꞌ xuqꞌuisbej cucꞌ: —¿Suꞌbe cꞌu riꞌ cꞌamajaꞌ cꞌana quimaj usucꞌ? —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tecꞌuchiriꞌ, xebopon pa ri tinamit Betsaida. Tak ri winak xquicꞌam lo jun potzꞌ chwa ri Jesús y xebelaj cꞌu che chaꞌ cucunaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ecꞌu ri Jesús xuchap rukꞌab ri potzꞌ, xresaj bi chupa ri tinamit y xchuban che tak ruwach. Tecꞌuchiriꞌ, xuya rukꞌab puwiꞌ y xutzꞌonoj che we caril qꞌuenok. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ri potzꞌ xtzuꞌn pana chwach y xubiꞌij: —Quebenuwil rachijab pachaꞌ chi e cheꞌ quebinic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri Jesús xuya tanchi rukꞌab puwi ruwach ri potzꞌ. Jecꞌulaꞌ ri potzꞌ xcunutajic y utz xtzuꞌnic. Xtzuꞌn cꞌu pana naj y xril ronoje chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tecꞌuchiriꞌ ri Jesús xutak bi chirocho y jewaꞌ xubiꞌij che: —Matoc bi pa ri tinamit y matzijoj ne cꞌana che junok e riꞌin xatincunaj —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ri Jesús cucꞌ rutijoꞌn xebec pa tak ri aldeas re ri tinamit Cesarea re Filipo. Yey chupa cꞌu ri be, ri Jesús xutzꞌonoj chique rutijoꞌn: —Chiquiwa ri winak, ¿in china nawi riꞌin? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rique xquicꞌul uwach che: —Cꞌo quebiꞌn re, lal ri Juan Aj Yaꞌl Bautismo; jujun chic caquibiꞌij lal ri Elías; y jujun chic, lal junok chique tak ri kꞌalajisanelab re ojertan —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tecꞌuchiriꞌ, xutzꞌonoj chique: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. Ri Pedro xucꞌul uwach: —Rilal lal ri Cristo, Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ewi ri Jesús xebutak che na caquitzijoj ta che junok china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Xujek cꞌu ubiꞌxiquil chique: «Lic chirajawaxic che Ralaxel Chiquixoꞌl Ticawex cutij na ri cꞌax y cacꞌak bi ukꞌij cuma ri nimak winak re ri tinamit, ri nimak e aj chacunel pa Rocho Dios y raj cꞌutunel re ri tzijpixab. Tecꞌuchiriꞌ, cacamisaxic; noꞌj churox kꞌij cacꞌastaj lok» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Waꞌ xukꞌalajisaj chi utz chique. Ecꞌu ri Pedro xresaj bi ri Jesús chiquixoꞌl y xuchꞌaꞌbej upa ruma ri xubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Noꞌj ri Jesús xutzuꞌ lo quiwach rutijoꞌn y xuchꞌaꞌbej cꞌu upa ri Pedro, jewaꞌ xubiꞌij che: —¡Chatel chinuwach, Satanás! Ma riꞌat na e ta cachꞌob puwi ri uchꞌobom lo ri Dios, xew e cachꞌob jelaꞌ pachaꞌ ri caquichꞌob ri winak —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ecꞌuchiriꞌ, xebusiqꞌuij ri winak y rutijoꞌn, y jecꞌuwaꞌ xubiꞌij chique: «We cꞌo junok caraj caterej lo chwij, lic chirajawaxic che muꞌan xew ri caraj rire, e chucuyu ri cꞌax cape puwiꞌ ruma ucojom ri nubiꞌ yey tereja lo chwij. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma china ri na cuya ta ranimaꞌ rucꞌaslem, riꞌ e cujam ri chomilaj cꞌaslemal chwach ri Dios; noꞌj ri cuya ranimaꞌ rucꞌaslem wuma riꞌin y ruma ri Utzilaj Tzij, riꞌ e curik ri chomilaj ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma ¿saꞌ cꞌu cutikoj riꞌ che ri ticawex we cuꞌan rajaw ronoje ruwachulew yey cusach cꞌu uwach rucꞌaslemal? ");
INSERT INTO acrTNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿O cꞌo nawi rajil cutoj rachi chwa rucꞌaslemal chaꞌ na cujam taj? ¡Na jintaj! ");
INSERT INTO acrTNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","»Mixqꞌuix cꞌu chwe riꞌin y che ri nuchꞌaꞌtem chiquiwach raj maquib re wakꞌij ora, ri na jusucꞌ ta ri canimaꞌ chwach ri Dios. Ma ri caꞌanaw waꞌ, ri in Alaxel Chiquixoꞌl Ticawex quinqꞌuix che rire echiriꞌ quincꞌun lo rucꞌ runimal uchomalil ri Nukaw y cucꞌ tak ri santowilaj ángeles» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tecꞌuchiriꞌ, xubiꞌij chique: —Pakatzij wi cambiꞌij chiwe: E cꞌo jujun chique wa e cꞌo wara, na quecam tana we na xquil tubi rucꞌunibal rutakanic ri Dios rucꞌ unimal chukꞌab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wakib kꞌij cꞌu ubiꞌxiquil riꞌ waꞌ, echiriꞌ ri Jesús xebuchaꞌ ri Pedro, ri Jacobo y ri Juan y xebucꞌam bi quituquel chwa jun nimalaj juyub. Chilaꞌ cꞌut xjalcꞌatitaj uwach ri Jesús chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Rukꞌuꞌ lic cawolkꞌinic, xuꞌan lic sak pachaꞌ ri nieve; rusakil xilitajic na jinta cꞌo caꞌanaw re che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xakicꞌateꞌt cꞌut chiquiwach xewinakir ri Elías y ri Moisés, kꞌalajisanelab re ojertan; e riꞌ quechꞌaꞌt rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ecꞌu ri Pedro xubiꞌij che ri Jesús: —Kajawal, lic utz xyaꞌtaj chike riꞌoj oj cꞌo wara. Kaꞌana oxib rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro xubiꞌij waꞌ ruma na cunaꞌ taj saꞌ ri cubiꞌij, ma rire cucꞌ ri queb chic rachbiꞌil lic quixiꞌim quib. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ecꞌuchiriꞌ, xkaj lo jun sutzꞌ y xuꞌan muꞌj paquiwiꞌ. Chupa cꞌu riꞌ ri sutzꞌ xquita rukul ri Dios, jewaꞌ xubiꞌij: «E Nucꞌajol waꞌ ri lic cꞌax cannaꞌo; e chita utzij Rire» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Cꞌate cꞌu xquilo, xew chi ri Jesús cꞌo cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Echiriꞌ xekaj lo chwa ri juyub, ri Jesús xebutak che na caquitzijoj ta cꞌana che junok janipa ri xquilo; cꞌate caquitzijoj echiriꞌ Ralaxel Chiquixoꞌl Ticawex cꞌastajinak chi lo chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ecꞌu rique lic xquicꞌol pa canimaꞌ ri xbiꞌx chique y xquijek caquitzꞌonobej chiquiwach puwi saꞌ queꞌelawi ri cꞌastajibal lo re Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ecꞌuchiriꞌ, xquitzꞌonoj che ri Jesús: —¿Suꞌbe raj cꞌutunel re ri tzijpixab caquibiꞌij lic chirajawaxic nabe na cacꞌun ri Elías chwach pan rucꞌunibal Ralaxel Chiquixoꞌl Ticawex? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ecꞌu ri Jesús xucꞌul uwach: —Katzij, lic chirajawaxic nabe na cacꞌun ri Elías y cuyijbaꞌ pan ronoje chwach rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. Pero ¿saꞌ quichꞌob riꞌix puwi ri tzꞌibital can chupa Rutzij Upixab ri Dios? Ma cubiꞌij lic chirajawaxic na, Ralaxel Chiquixoꞌl Ticawex cutij cꞌax y na jinta ukꞌij caꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Noꞌj cꞌu riꞌin cankꞌalajisaj waꞌ chiwe: Ri Elías ya xcꞌunic yey ri winak xquiꞌan che janipa ri xcaj rique, jelaꞌ pachaꞌ ri tzꞌibital can puwi rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Echiriꞌ xebopon pa e cꞌo wi can ri jujun chic utijoꞌn, xquilo e cꞌo uqꞌuiyal winak quisutum quij yey raj cꞌutunel re ri tzijpixab quequichapalaꞌ che chꞌaꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Conoje cꞌu ri winak lic xequiꞌcotic echiriꞌ xquil ri Jesús. Quebanic xeꞌquicꞌuluꞌ apanok y xquiya rutzil uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xutzꞌonoj cꞌu Rire chique: —¿Saꞌ puwi cachapalaꞌ wi ib alak cucꞌ rique? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Cꞌo cꞌu jun chiquixoꞌl ruqꞌuiyal winak jewaꞌ xucꞌul uwach: —Lal tijonel, nucꞌamom lo ri nucꞌajol chiwach la, ma rire cꞌo pukꞌab jun itzel uxlabixel uꞌanom meꞌt che. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Xa tob pa cuchap wi, cucꞌak pulew. Ecꞌuchiriꞌ, rala cujek capuluwan rucꞌaxaj, cakichꞌichꞌ ruwi tak reꞌ y cacanaj can junchi chucꞌuchic. Xintzꞌonoj cꞌu chique ri tijoꞌn la chaꞌ caquesaj bi ri itzel uxlabixel, pero rique na xquichꞌij ta resaxic bi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ecꞌu ri Jesús xucꞌul uwach, jewaꞌ xubiꞌij chique: —¡E ri ix ticawex re wakꞌij ora, na cubul ta cꞌana icꞌuꞌx wucꞌ! ¿Janipa chi lo kꞌij cajawaxic quincꞌojiꞌ iwucꞌ chaꞌ cacubiꞌ icꞌuꞌx wucꞌ? ¿Janipa chi lo kꞌij quixincuyu e laꞌ jelaꞌ iꞌanom? Chicꞌama lo rala wara —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xquicꞌam cꞌu lo rala chwach. Ecꞌu ri itzel uxlabixel echiriꞌ xril uwach ri Jesús, lic co xujabajaꞌ rala. Ecꞌu rala xtzak pulew y xujeko cubalcatilaꞌ rib, capuluwan rucꞌaxaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ri Jesús xutzꞌonoj cꞌu che rukaw rala: —¿Jampa ujekom lo waꞌ che? —xchaꞌ. Rachi xucꞌul uwach: —Chuchꞌutiꞌnal upetebem lok. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Uqꞌuiyal laj ucꞌakom pa akꞌ y pa yaꞌ re camisaxic uwach. We cꞌo co pakꞌab la catoꞌ la, cꞌutu co ri cꞌaxnaꞌbal cꞌuꞌx la chike y chojtoꞌo la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ri Jesús xucꞌul uwach: —¿Suꞌbe cabiꞌij la chwe we cꞌo panukꞌab canꞌan waꞌ? Ma we cꞌo junok lic cubul ucꞌuꞌx wucꞌ, ronoje quel pana rucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ecꞌu rukaw rala na jampatana co xchꞌawic, jewaꞌ xubiꞌij: —Cubul nucꞌuꞌx ucꞌ la, xew chintoꞌo co la chaꞌ canimar ri cubulibal nucꞌuꞌx —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ecꞌu ri Jesús echiriꞌ xrilo catajin quimolotajic ruqꞌuiyal winak, xtakan puwi ri itzelilaj uxlabixel, jewaꞌ xubiꞌij che: —Itzelilaj uxlabixel, ri aꞌanom meꞌt y tꞌoꞌc che waꞌla, riꞌin catintako: Jat, chatelubi y mat-tzelej chi lo cꞌana rucꞌ —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ewi ri itzel uxlabixel xsiqꞌuinic y lic co xujabajaꞌ rala; tecꞌuchiriꞌ, xel bi. Ecꞌu rala xcanaj canok pachaꞌ caminak chic. Ruma riꞌ, lic e qꞌui ri xebiꞌn re: «Ya xcamic» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xuchap rukꞌab, xuyaco; y rala xtaqꞌuiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ecꞌuchiriꞌ, xoc bi ri Jesús chuchiꞌ jun ja. Ecꞌu rutijoꞌn xechꞌaꞌt rucꞌ xa quituquel chic, jewaꞌ xquitzꞌonoj che: —¿Suꞌbe riꞌoj na xkachꞌij tubi resaxic waꞌ wa itzel uxlabixel? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ri Jesús xucꞌul uwach: —E tak waꞌ wa juchꞌob itzel uxlabixel, xew utz quebesax bi rucꞌ oración y ayuno —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Echiriꞌ xebel bi chiriꞌ, xebicꞌow pa tak ri luwar re Galilea. Pero ri Jesús na xraj taj cꞌo quetaꞌman re, ");
INSERT INTO acrTNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ma cacꞌutun chiquiwach rutijoꞌn. Jecꞌuwaꞌ cubiꞌij chique: «Ralaxel Chiquixoꞌl Ticawex cayaꞌiꞌ paquikꞌab rachijab y cacamisax cuma, noꞌj echiriꞌ caminak chic, cacꞌastaj lo churox kꞌij» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ecꞌu rutijoꞌn na xquimaj ta usucꞌ la cubiꞌij chique, yey caquixiꞌij quib caquitzꞌonoj che ri Jesús saꞌ queꞌelawi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xebopon cꞌu chupa ri tinamit Capernaúm y echiriꞌ e cꞌo chi chuchiꞌ jun ja, xutzꞌonoj chique rutijoꞌn: —¿Saꞌ puwi quichapalaꞌ wi iwib chiwach echiriꞌ quixtajin lo chi be? —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yey na jinta cꞌu junok chique xchꞌawic; ma echiriꞌ cꞌa quetajin lo chi be, e caquichapalaꞌ quib chiquiwach puwiꞌ chinok chique cayaꞌiꞌ más uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ewi ri Jesús xtzꞌuyiꞌic, xebusiqꞌuij ri cablajuj utijoꞌn y xubiꞌij chique: —We cꞌo junok caraj e rire ri cacꞌojiꞌ nabe chiquiwach conoje, riꞌ chirajawaxic che e cacanaj can pa qꞌuisbal chique conoje y cuya rib quebunimaj —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xucꞌam cꞌu jun ralco cꞌoꞌm y xuya chiquinicꞌajal rique. Xukꞌaluj cꞌut y jewaꞌ xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—China ri cucꞌul chupa ri nubiꞌ junok na jinta uwach pachaꞌ wa ralco cꞌoꞌm, e junam rucꞌ in ri quinucꞌulu; yey china ri cacꞌuluw we riꞌin, na xew ta quinucꞌul riꞌin, ma e cucꞌul ri Jun takayom lo we riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ecꞌu ri Juan xubiꞌij che ri Jesús: —Kajawal, xkil jun achi queberesaj bi itzel uxlabixel chupa ri biꞌ la yey rire na kuqꞌuil taj. Ecꞌu riꞌoj xkabiꞌij che muꞌan chi waꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ri Jesús xucꞌul uwach: —We cꞌo caꞌanaw waꞌ, mikꞌatej, ma na jinta junok cuꞌan juna milagro chupa ri nubiꞌ yey pa jokꞌotaj cꞌu riꞌ cachꞌaꞌt lo chwij. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ma china ri na cachꞌoꞌjin ta chikij, riꞌ e kuqꞌuil. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","China ri cusipaj juna tzima iyaꞌ chupa ri nubiꞌ ruma ix re ri Cristo, pakatzij wi cambiꞌij chiwe, riꞌ na cujam ta cꞌana ri rajil ucꞌaxel. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","»Noꞌj china ri cumin pa mac junok chique wa chꞌutiꞌk cubul quicꞌuꞌx wucꞌ, e ne más utz catzayabax bi pukul juna nimalaj caꞌ re queꞌem y cacꞌak cꞌu bi chupa ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","»We rakꞌab e catzakisan awe pa mac, chakꞌata bi. Ma xa ne cuya tob at tꞌum catopon pa ri cꞌaslemal chilaꞌ chicaj, chwa ri cꞌo ucabichal rakꞌab yey catcꞌak bi chi xibalbaꞌ re tijbal cꞌax, chupa ri akꞌ na jinta chi uchupic ");
INSERT INTO acrTNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","pa na quecam ta wi ramoloy quetijow que waꞌ wa winak ecaminak, yey ri akꞌ na jinta chi uchupic. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","»Yey we rawakan e catzakisan awe pa mac, chakꞌata bi. Ma xa ne cuya tob at jetzꞌ catopon pa ri cꞌaslemal chilaꞌ chicaj, chwa ri cꞌo ucabichal rawakan yey catcꞌak bi chi xibalbaꞌ re tijbal cꞌax, chupa ri akꞌ na jinta chi uchupic ");
INSERT INTO acrTNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","pa na quecam ta wi ramoloy quetijow que waꞌ wa winak ecaminak, yey ri akꞌ na jinta chi uchupic. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","»Yey we rawach e catzakisan awe pa mac, chawesaj bi. Ma xa ne cuya ri xa jun rawach catoc pa rutakanic ri Dios, chwa ri cꞌo ucabichal rawach yey catcꞌak bi chi xibalbaꞌ re tijbal cꞌax ");
INSERT INTO acrTNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","pa na quecam ta wi ramoloy quetijow que waꞌ wa winak ecaminak, yey ri akꞌ na jinta chi uchupic. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","»Chirajawaxic cꞌut conoje cacꞌam na quipa, pachaꞌ quebicꞌowisax pa akꞌ. E pachaꞌ ri caꞌan rucꞌ ronoje kasaꞌn cayaꞌiꞌ chwach ri Dios: cacowisax ruma ratzꞌam. ");
INSERT INTO acrTNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","E ratzꞌam lic cajawaxic, noꞌj we xsach rutzayul, ¿suꞌanic tanchi caꞌan tza che? Chirajawaxic cꞌut lic cꞌo cutikoj ribinic isilabic riꞌix jelaꞌ pachaꞌ ratzꞌam lic curik uchac. Cꞌola cꞌu rutzil chomal chiwach chijujunal —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ri Jesús xel bi che ri tinamit Capernaúm y xeꞌec pa tak ri luwar re Judea y che tak ri luwar cꞌo chꞌaka yaꞌ che ri nimayaꞌ Jordán. E tak cꞌu ri winak xquimol quib rucꞌ, y Rire xujek cacꞌutun chiquiwach pachaꞌ ri xex cuꞌan wi. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xekib cꞌu ri fariseos rucꞌ y xquiꞌan jun tzꞌonobal che xa re cꞌambal upa: —¿Yaꞌtal nawi pukꞌab juna achi cuya bi ruwujil re jachbal ib che ri rixokil? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ecꞌu ri Jesús xucꞌul uwach: —¿Saꞌ cubiꞌij ri takanic xuꞌan can ri Moisés che alak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rique xquibiꞌij: —Ri Moisés xuya luwar che rachi cuya bi ruwujil re jachbal ib che ri rixokil y jecꞌulaꞌ na rixokil ta chic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ri Jesús xubiꞌij chique: —Xutzꞌibaj ne can riꞌ waꞌ wa jun takanic ma e ruma lic co ri animaꞌ alak. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Noꞌj Ruchꞌaꞌtem ri Dios cubiꞌij: Che ri jekebal lo ruwachulew echiriꞌ ri Dios xebuꞌan ri ticawex, chi achi chi ixok xebuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Y cubiꞌij: Ruma cꞌu riꞌ, rachi echiriꞌ cacꞌuliꞌic, caresaj rib chiquij ruchu-ukaw chaꞌ cajekiꞌ rucꞌ ri rixokil; ");
INSERT INTO acrTNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y quicabichal cꞌu riꞌ quebuꞌana xa e jun chwach ri Dios cachaꞌ. Jecꞌuriꞌlaꞌ, na e ta chi caꞌib ma xebuꞌana xa e jun. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","E uwariꞌche, ri xebujunimaj ri Dios, na yaꞌtal ta che ri ticawex cujach quipa —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ecꞌuchiriꞌ e cꞌo chi chiꞌja, rutijoꞌn xquitzꞌonoj tanchi che puwi wa xutzijoj. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ri Jesús xubiꞌij chique: —E junok cuya ruwujil re jachbal ib che ri rixokil yey cacꞌuliꞌ tanchi rucꞌ juna chic ixok, riꞌ camacun chwach ri Dios chirij ri nabe rixokil. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jecꞌulaꞌ rixok, we cuya ruwujil re jachbal ib che ri rachijil yey cacꞌuliꞌ tanchi rucꞌ juna chic achi, riꞌ jenelaꞌ camacun chirij ri cꞌulaniquil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","E cꞌo jujun raltak co acꞌalab xecꞌam lo chwach ri Jesús chaꞌ cuya rukꞌab paquiwiꞌ. Noꞌj rutijoꞌn xequiyaj ri ecꞌamayom lo que. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ri Jesús, echiriꞌ xril waꞌ, xpe royowal y jewaꞌ xubiꞌij chique: «Chiyaꞌa luwar chique ri raltak co acꞌalab chepeta na wucꞌ. Mebikꞌatej; ma ri caquiꞌan e jelaꞌ pachaꞌ rique, riꞌ cuꞌan que rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Pakatzij wi cambiꞌij chiwe: China ri na cucꞌul ta rutakanic ri Dios jelaꞌ pachaꞌ cuꞌan juna ralco cꞌoꞌm, riꞌ na coc ta chupa» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tecꞌuchiriꞌ, xebukꞌaluj ri raltak co acꞌalab, xuya rukꞌab paquiwiꞌ y xebuꞌan bendecir. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Echiriꞌ catajin bi relic ri Jesús re cumaj tanchi ubi rube, cacꞌalalic xopon jun rucꞌ, xuxucubaꞌ rib chwach y xutzꞌonoj cꞌu che: —Lal utzilaj tijonel, ¿saꞌ ri canꞌano chaꞌ cꞌo nucꞌaslemal na jinta utakexic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ri Jesús xucꞌul uwach: —¿Suꞌbe cabiꞌij la “utz” chwe? Ma xa jun ri lic utz cꞌolic, waꞌ e ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rilal etaꞌam chi la saꞌ tak Rutzij Upixab ri Dios: “Matmacun chirij ri cꞌulaniquil. Matcamisanic. Matelekꞌic. Maꞌan rakꞌubal chirij junok. Macꞌo maꞌan xa rucꞌ socosoꞌnic. Chalokꞌoj quikꞌij rachu-akaw” —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rachi xucꞌul uwach: —Lal tijonel, ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ewi ri Jesús xutzuꞌ uwach y lic xjuchꞌ can ucꞌuꞌx che. Xubiꞌij cꞌu che: —Xa jun chi ri lic chirajawaxic wi caꞌan la: Oj la, cꞌayij la ronoje tak ri beyomalil la y jacha cꞌu la chique ri nibaꞌib; jecꞌuriꞌlaꞌ cꞌo beyomalil la chilaꞌ chicaj. Tecꞌuchiriꞌ, peta la, terej lo la chwij y cuyu la ri cꞌax cape pawiꞌ la ruma lal nutijoꞌn —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ecꞌu rachi lic xuchap ranimaꞌ che ri xubiꞌij ri Jesús; lic cabisonic xeꞌec, ma rire lic rajawal beyom. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tecꞌuchiriꞌ, ri Jesús xebutzuꞌ conoje y xubiꞌij chique rutijoꞌn: —Ri e beyomab lic cꞌayew chique queboc chupa rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Rutijoꞌn ri Jesús lic xcam canimaꞌ che wa xubiꞌij. Rire xubiꞌij cꞌu chique: —Ix walcꞌoꞌal, e janipa ri lic quicubam quicꞌuꞌx rucꞌ ri quibeyomalil, lic cꞌayew chique queboc chupa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E ne más cꞌayew coc juna beyom chupa rutakanic ri Dios chwa ri quicꞌow juna camello chupa rutel juna acuxaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rique lic xcam canimaꞌ che waꞌ y xquibiꞌij cꞌu chiquiwach: «We e riꞌ, ¿china cꞌu riꞌ ri cacolobetajic?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ecꞌu ri Jesús xutzuꞌ quiwach, xubiꞌij chique: —Ri ticawex na caquicolobej ta quib quituquel ma waꞌ lic cꞌayew chiquiwach, noꞌj ri Dios ronoje cuꞌano ma na jinta cꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ecꞌu ri Pedro xujek ubiꞌxiquil che ri Jesús: —Kajawal, e riꞌoj kayaꞌom can ronoje y oj teran chiꞌij la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ri Jesús xubiꞌij: —Pakatzij wi cambiꞌij chiwe: China ri uyaꞌom can rocho, ebuyaꞌom can ri ratz-uchakꞌ, ruchu-ukaw, ri rixokil, ri ralcꞌoꞌal o rulew, ruma ucojom ri nubiꞌ riꞌin y ruma rutzijoxic ri Utzilaj Tzij, ");
INSERT INTO acrTNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","riꞌ cucꞌul wara che ruwachulew chupa tak wa kꞌij oj cꞌo wi, jun ciento ri rajil ucꞌaxel ruma tak ri uyaꞌom canok, tob lic cutij cꞌax ruma waꞌ. Yey chwach cꞌu apanok cucꞌul na ri cꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lic cꞌu e qꞌui chique ri lic cꞌo quiwach woꞌora, chwach apanok na jinta chi quiwach; yey lic e qꞌui chique ri na jinta quiwach woꞌora, e lic cacꞌojiꞌ quiwach chwach apanok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ecꞌu riꞌ quimajom bi ri be re quepakiꞌ Jerusalem, yey ri Jesús nabe bi chiquiwach. Ecꞌu rutijoꞌn lic sachinak quinaꞌoj y rucꞌ xiꞌin ib eteran chirij. Ecꞌuchiriꞌ, ri Jesús xebucꞌam tanchi ubi quituquel ri cablajuj utijoꞌn y xujek ubiꞌxiquil chique saꞌ tak ri caricꞌowibej. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jewaꞌ xubiꞌij: —Chitapeꞌ: E waꞌ cojpakiꞌ Jerusalem, yey Ralaxel Chiquixoꞌl Ticawex cayaꞌ na paquikꞌab ri nimak e aj chacunel pa Rocho Dios y raj cꞌutunel re ri tzijpixab, chaꞌ caquikꞌat tzij puwiꞌ re camic y caquiya paquikꞌab ri winak na e ta aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Cachꞌamix cꞌu riꞌ, cajichꞌ upa, cachubaxic y cacamisaxic. Noꞌj churox kꞌij cacꞌastaj bi chiquixoꞌl ri ecaminak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ecꞌu ri Jacobo y ri Juan, ri queb ucꞌajol ri Zebedeo, xekib rucꞌ ri Jesús y xquibiꞌij che: —Kajawal, cakaj caꞌan co la chike janipa wa cakatzꞌonoj cheꞌla —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Saꞌ ri quiwaj canꞌan chiwe? —xcha ri Jesús chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rique xquibiꞌij che: —E cakaj riꞌoj caya la chike chupa ri chomilaj takanic la, jun chike catzꞌuyiꞌ pawiquikꞌab la yey ri jun chic pa mox la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ri Jesús xubiꞌij cꞌu chique: —Riꞌix na iwetaꞌam taj saꞌ la quitzꞌonoj. ¿Quichꞌij neba riꞌix ri quinicꞌow wi riꞌin y ri cꞌax cape panuwiꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rique xquibiꞌij: —Cakachꞌijo —xechaꞌ. Ri Jesús xubiꞌij chique: —Katzij, riꞌix quichꞌij na ri cꞌax quinicꞌow wi riꞌin y ri cꞌaxcꞌobic cape panuwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Noꞌj cꞌu ri quixtzꞌuyiꞌ pa nuwiquikꞌab y pa numox, na in ta quinyaꞌw re, ma xew cayaꞌtaj chique ri echaꞌtal chic chaꞌ cuꞌana na que —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ri lajuj chic tijoꞌn, echiriꞌ xquita waꞌ, lic xpe coyowal chiquij ri Jacobo y ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ecꞌu ri Jesús xebusiqꞌuij y xubiꞌij chique: —Iwetaꞌam riꞌix, ri ecojtalic e takanelab paquiwi ri nimak tinamit quebuꞌana pachaꞌ e rajaw ronoje, yey ri lic cꞌo quiwach quicꞌow uwiꞌ ri takanic caquiꞌan paquiwi ri eyaꞌtal paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Noꞌj chixoꞌl riꞌix na ube taj jelaꞌ cuꞌano. Ma we cꞌo junok chiwe riꞌix caraj cuꞌana aj wach, e chuyaꞌa rib cuꞌan nimanel iweꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yey e junok chiwe caraj cuꞌana nabe chixoꞌlibal, e chuyaꞌa rib cuꞌan nimanel que conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma Ralaxel Chiquixoꞌl Ticawex na xcꞌun taj re canimaxic. Rire xcꞌunic re coꞌlnimanok y re coluꞌyaꞌa rib pa camic che quicolobexic uqꞌuiyal ticawex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ecꞌuchiriꞌ, ri Jesús cucꞌ rutijoꞌn xebicꞌow chupa ri tinamit Jericó, y uqꞌuiyal winak xeterej bi chirij. Echiriꞌ catajin bi quelic chupa ri tinamit, xebicꞌow pa tzꞌul wi ri Bartimeo, waꞌ e jun potzꞌ ucꞌajol ri Timeo. Rire e riꞌ cutzꞌonoj limoxna. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ecꞌuchiriꞌ xuto e Jesús ri aj Nazaret ri catajin ricꞌowic, xujeko casiqꞌuinic: —¡Jesús, lal ri Ralcꞌoꞌal can ri rey David, chinjuchꞌ caꞌn co cheꞌla! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Uqꞌuiyal winak xquichꞌaꞌbej upa chaꞌ na casiqꞌuin ta chic, noꞌj rire más ne co casiqꞌuinic: —¡Lal ri Ralcꞌoꞌal can ri rey David, chinjuchꞌ caꞌn co cheꞌla! —cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ecꞌu ri Jesús xtaqꞌuiꞌic y xutak usiqꞌuixic ri potzꞌ. Ri xebeꞌsiqꞌuin re xquibiꞌij che: —¡Chanimarisaj acꞌuꞌx! ¡Chatyactajok! Ri Jesús catusiqꞌuij —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri potzꞌ xucꞌak can rukꞌuꞌ uripom chirij, xyactajic y xopon pa cꞌo wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ri Jesús xubiꞌij cꞌu che: —¿Saꞌ ri cawaj canꞌan chawe? —xchaꞌ. Ri potzꞌ xucꞌul uwach: —Lal tijonel, cuaj quintzuꞌn tanchic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ecꞌu ri Jesús xubiꞌij che: —Jat chi utzil chomal, ma ruma ri cubulibal acꞌuꞌx wucꞌ, at cunutajinak chic —xchaꞌ. Chupa cꞌu riꞌ la jokꞌotaj, ri potzꞌ xtzuꞌnic y xterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ri Jesús cucꞌ rutijoꞌn xa nakaj chi e cꞌo lo che ri tinamit Jerusalem, ya e riꞌ quebopon chwach ri juyub Olivos pa tak raldeas Betfagé y Betania. Ecꞌuchiriꞌ, ri Jesús xebutak bi caꞌib chique rutijoꞌn chaꞌ quenabej apanok, ");
INSERT INTO acrTNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","jewaꞌ xubiꞌij chique: —Jix pa raldea cꞌo pan chikawach. Xew cꞌu quixoponic, quiꞌrika jun kꞌapoj buru yukulic. Waꞌ na jinta junok cojoyom re. Chiquiraꞌ y chicꞌama lok. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We cꞌo cꞌu junok cutzꞌonoj chiwe: “¿Suꞌchac quiꞌan waꞌ?”, chibiꞌij che: “Rawaj cajawax che ri Kajawal, yey cꞌate cutak tanchi ulok” —quixchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xebec cꞌut y xquirik ri kꞌapoj buru yukubam pa be chunakaj jun puerta. Ewi xquiquir lok. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jujun cꞌu chique ri e cꞌo chiriꞌ xquitzꞌonoj: —¿Saꞌ ri quiꞌano? ¿Suꞌbe quiquir ri kꞌapoj buru? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rique e xquibiꞌij janipa ri biꞌim bi chique ruma ri Jesús; ewi xyaꞌ lo chique xquiquir lok. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xquicꞌam cꞌu lo ri kꞌapoj buru y xquirip ri quimanta chirij. Ecꞌu ri Jesús xucoj bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Uqꞌuiyal winak xquiwik ri be pa quicꞌow wi ri Jesús, xquilicꞌ tak ri quimanta pa ri be; yey e cꞌo jujun chic xquikꞌat raltak co ukꞌab cheꞌ y xquilem pa la be re yacbal ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winak e nabejinak chwach cucꞌ ri eteran lo chirij xquijeko lic quesiqꞌuinic, caquibiꞌij: «¡Kayaca ukꞌij! ¡Nim ukꞌij ralaxic ri jun petinak chupa rubiꞌ ri Dios Kajawxel! ");
INSERT INTO acrTNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nim uwach ukꞌij ri takanic re ri kamam David cacꞌun lok! ¡Kayaca ukꞌij ri Dios cꞌo chilaꞌ chicaj!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xopon cꞌu ri Jesús Jerusalem y xoc chupa ri Rocho Dios. Xa xril cꞌu ronoje saꞌ tak ri cꞌo chupa; pero ruma ya e riꞌ coc rakꞌab, xeꞌec Betania cucꞌ ri cablajuj utijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chucaꞌm kꞌij cꞌut echiriꞌ xebel bi Betania, ri Jesús xpe numic che. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y chinimanaj xril pana jun cheꞌ re higo lic cꞌo uxak. Ewi xeꞌec xeꞌrilaꞌ we cꞌo ujikꞌobalil curiko. Yey echiriꞌ xopon rucꞌ, na jinta cꞌo xurik che, xew ruxak cꞌolic, ma na ukꞌijol taj cꞌo uwach ri higos. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ewi ri Jesús xubiꞌij che ri cheꞌ re higo: —Na jinta chi cꞌana junok cutij jikꞌobal chawe —xchaꞌ. Yey wa xubiꞌij, xquita rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xebopon cꞌu Jerusalem y echiriꞌ xoc bi ri Jesús chupa ri Rocho Dios, xujek lo quesaxic conoje ri quecꞌayinic y ri quelokꞌow chupa. Yey xuxulcꞌatilaꞌ tak bi ri mexa que ri e aj jachal uwach puak y tak ri xila que ri e aj cꞌay palomax. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y na xuya ta luwar che junok cꞌo rucꞌaꞌam quicꞌow pa ri Rocho Dios xa re cukꞌat ube. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xujek cꞌu cacꞌutun chiquiwach, jewaꞌ cubiꞌij: «¿Na etaꞌam ta neba alak ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios? Ma ri Dios cubiꞌij: Che ri Wocho cabiꞌxic: “E luwar re oración que conoje tak ri tinamit che ruwachulew” cachaꞌ. Noꞌj ralak, ꞌanom alak che ri Wocho e jun luwar que elekꞌomab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Waꞌ xquita raj cꞌutunel re ri tzijpixab y ri nimak e aj chacunel pa Rocho Dios. Ruma cꞌu riꞌ, caquitzucuj saꞌ uꞌanic caquicamisaj ma caquixiꞌij quib che ruma conoje ri winak lic cacam canimaꞌ che tak rucꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ecꞌuchiriꞌ xoc rakꞌab, ri Jesús xel bi chupa ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chucaꞌm kꞌij anim echiriꞌ xebicꞌow ri Jesús cucꞌ rutijoꞌn pa cꞌo wi ri cheꞌ re higo, xquilo chakijinak lo cꞌa pa ratzꞌayak. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ewi ri Pedro xcꞌun lo chucꞌuꞌx tak ri chꞌaꞌtem xubiꞌij can ri Jesús che ri cheꞌ. Xubiꞌij cꞌu riꞌ che ri Jesús: —Wajawal, chilape la, ri cheꞌ re higo ri xbiꞌij la che na cuya ta chi ujikꞌobalil, waꞌ chakijinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ri Jesús xucꞌul uwach: —Lic cubula icꞌuꞌx rucꞌ ri Dios; ");
INSERT INTO acrTNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ma pakatzij wi cambiꞌij chiwe: China junok cabiꞌn che wa jun juyub: “Chatela wara y jateꞌcꞌola chupa ri mar” yey lic cujiquibaꞌ cꞌu ucꞌuꞌx che la xubiꞌij, riꞌ lic e cuꞌanaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Uwariꞌche cambiꞌij chiwe: E janipa ri quitzꞌonoj che ri Dios yey cubul cꞌu icꞌuꞌx che cayaꞌtaj na chiwe, quicꞌul na cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jecꞌulaꞌ, echiriꞌ quiꞌan orar, we cꞌo chicꞌuꞌx ri macunic re junok chiwij, chicuyu umac chaꞌ jelaꞌ ri Kakaw cꞌo chilaꞌ chicaj cucuy imac riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma we riꞌix na quicuy ta umac junok, jecꞌulaꞌ cuꞌan ri Kakaw Dios cꞌo chilaꞌ chicaj, na cucuy ta imac riꞌix —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xebopon tanchi Jerusalem ri Jesús cucꞌ rutijoꞌn. Y echiriꞌ cabin chupa ri Rocho Dios, ri nimak e aj chacunel cucꞌ raj cꞌutunel re ri tzijpixab y ri nimak winak re ri tinamit, xekib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xquitzꞌonoj cꞌu che: —¿China xyaꞌw pakꞌab la caꞌan tak la waꞌ? ¿China xtakaw la che caꞌan tak la waꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ri Jesús xucꞌul uwach: —Riꞌin canꞌan jun tzꞌonobal che alak. We xcꞌul alak uwach, cambiꞌij cꞌu riꞌ che alak china yaꞌyom panukꞌab canꞌan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿China cꞌu xtakaw re ri Juan cuya ri bautismo? ¿E ri Dios o e rachijab? Cꞌulu alak uwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ecꞌu rique xquijek quechꞌaꞌt chiquiwach puwi waꞌ: «We xkacꞌul uwach che: “E ri Dios xtakaw re,” riꞌ cubiꞌij rire chike: “¿Suꞌchac cꞌu riꞌ na xcoj ta alak ri xubiꞌij?” cacha chike. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Yey we xkabiꞌij xa achijab xetakaw re...?» xecha chiquiwach. Yey lic caquixiꞌij quib chique ri winak, ma conoje caquichꞌobo ri Juan e jun sakil kꞌalajisanel re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xquibiꞌij cꞌu che ri Jesús: —Na ketaꞌam taj —xechaꞌ. Ecꞌu ri Jesús xubiꞌij chique: —Jecꞌuriꞌlaꞌ, riꞌin na cambiꞌij ta che alak china yaꞌyom panukꞌab canꞌan tak waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ecꞌuchiriꞌ, ri Jesús xujek cacꞌutun chiquiwach ri e aj wach rucꞌ tak cꞌambal naꞌoj, xubiꞌij chique: «Cꞌo jun achi xuꞌan ticoꞌn re uva chwach ri rulew. Xusut cꞌu rij rucꞌ coral, xucꞌot jun luwar pa cayitzꞌ wi ruwaꞌal ri uva y xuyac jun ja naj uwiꞌ re chajibal re. Xuya cꞌu can pa tunulic chique jujun aj chaquib. Tecꞌuchiriꞌ, xeꞌec naj. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","»Echiriꞌ xopon rukꞌijol ri molonic, xutak lo jun raj chac chaꞌ cuꞌtzꞌonoj chique tak raj tunulel ri takalic cucꞌul rire che ri molonic. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Noꞌj raj tunulel xquichap raj chac takom lo cucꞌ, xquichꞌayo y xquitak bi; e riꞌ na jinta xquiya bi che. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","»Ri rajaw ri ticoꞌn xutak chi lo jun raj chac cucꞌ, yey raj tunulel xquirakij rujolom rucꞌ abaj y lic xquiqꞌuixbesaj bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ri rajaw ri ticoꞌn xutak chi lo jun chic raj chac cucꞌ; ecꞌu riꞌ waꞌ asu xquicamisaj. Y xebutak chi lo jujun chic; yey chique conoje waꞌ, e cꞌo ri xequichꞌayo y e cꞌo ri xequicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","»Ecꞌu ri rajaw ri ticoꞌn xa jun chi ri cꞌo rucꞌ re cutak bi, e rucꞌajol lic cꞌax cunaꞌo. Qꞌuisbal cꞌu re, e xutak lo rucꞌajol cucꞌ raj tunulel ma xuchꞌobo: “Ruma e nucꞌajol, caquicꞌul na chi utz.” ");
INSERT INTO acrTNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","»Noꞌj raj tununel xquibiꞌij chiquiwach: “Waꞌ e ucꞌajol ri rajaw rulew, ri cuꞌana na rajaw we xcam rukaw. Joꞌ, jeꞌkacamisaj chaꞌ rulew cuꞌan can keꞌoj” xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ewi xquichapo y xquicamisaj. Tecꞌuchiriꞌ, xquesaj bi rucuerpo chupa waꞌ wuꞌlew y xeꞌquicꞌaka bi» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tecꞌuchiriꞌ, xutzꞌonoj chique ri e aj wach: —Chiwach ralak, ¿saꞌ nawi cuꞌan ri rajaw ri ticoꞌn chique raj tunulel? Riꞌin cambiꞌij: Cacꞌunic, cusach quiwach raj tunulel y cuya ruticoꞌn paquikꞌab jujun chic. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","»¿Na ajilam ta neba ralak ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ cubiꞌij: E rabaj cꞌakital can cuma raj yacal ja, e abaj waꞌ lic xajawaxic chaꞌ catiquiꞌ lo ri ja. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","E ri Dios Kajawxel xꞌanaw re waꞌ, yey chikawach riꞌoj, waꞌ lic na jinta cꞌana ilitajinak wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ecꞌu ri e aj wach lic xquitzucuj suꞌanic caquichap ri Jesús ma xquimaj usucꞌ chiquij rique xubiꞌij wi wa jun cꞌambal naꞌoj. Pero ruma cꞌu caquixiꞌij quib chiquiwach ruqꞌuiyal winak, xquiya canok y xebec. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xetak cꞌu lo rucꞌ ri Jesús jujun chique ri fariseos y jujun chique ri quitakem ri rey Herodes, re caquicꞌam upa rucꞌ tak ri cubiꞌij chaꞌ caquicoj umac. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ecꞌuchiriꞌ, xebopon rucꞌ ri Jesús y xquibiꞌij che: —Lal tijonel, riꞌoj ketaꞌam lic katzij ri cabiꞌij la. Na caxiꞌij ta ib la che tak ri caquibiꞌij ri ticawex, ma rilal junam quiwach quebil la conoje, tob cꞌo quiwach o na jinta quiwach; yey lic jusucꞌ cacꞌutun la chwi ri be re ri Dios. Cakatzꞌonoj cꞌu cheꞌla: ¿Usucꞌ nawi cakaꞌan tojonic che ri nimalaj takanel re Roma o na usucꞌ taj? ¿Cakaya nawi o na cakaya taj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ecꞌu ri Jesús, ruma retaꞌam rique xa queb quipalaj, jewaꞌ xubiꞌij chique: —¿Suꞌchac cacꞌam alak nupa? Cꞌama pe lo alak juna meyo re caꞌan tojonic rucꞌ chaꞌ canwilo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rique xquicꞌam lo jun meyo che. Ewi ri Jesús xubiꞌij chique: —¿China re wa cꞌaxwach y china re wa biꞌaj cꞌo chwach wa meyo? —xchaꞌ. Rique xquicꞌul uwach: —Re ri nimalaj takanel re Roma —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ecꞌu ri Jesús xucꞌul uwach, xubiꞌij chique: —Yaꞌa alak che ri nimalaj takanel re Roma janipa ri takal che rire, yey yaꞌa cꞌu alak che ri Dios janipa ri takal che ri Dios —xchaꞌ. Lic cꞌu xcam canimaꞌ che ri Jesús ma Rire lic xurik ucꞌulic uwach ri tzꞌonobal xquiꞌan che. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ecꞌuchiriꞌ, jujun chique ri saduceos, ri caquibiꞌij na jinta cꞌastajibal chique ri ecaminak, xecꞌun rucꞌ ri Jesús y xquitzꞌonoj cꞌu che: ");
INSERT INTO acrTNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Lal tijonel, ri Moisés xutzꞌibaj can chike: “We ri ratz junok cacamic y na e jinta can ralcꞌoꞌal rucꞌ ri rixokil, ecꞌu riꞌ ruchakꞌ utz cacꞌuliꞌ rucꞌ rixok malcaꞌn canok y jecꞌulaꞌ quecꞌojiꞌ ralcꞌoꞌal rucꞌ pubiꞌ ri ratz xcamic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","»Julaj e cꞌo wukub achijab quichakꞌ quib. Ri nabe chique xcꞌuliꞌic, yey ecꞌu riꞌ waꞌ xcamic y na e jinta can ralcꞌoꞌal rucꞌ ri rixokil. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jelaꞌ cꞌu riꞌ rucaꞌm xcꞌuliꞌ rucꞌ rixok malcaꞌn canok. Ecꞌu riꞌ waꞌ xcamic y na e jinta can ralcꞌoꞌal rucꞌ rixok. Yey je tanchi laꞌ xucꞌulumaj rurox. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jecꞌulaꞌ xquicꞌulumaj ri wukub achijab; xecamic, e riꞌ na jinta calcꞌoꞌal xquiya canok. Qꞌuisbal cꞌu re, e xcam rixok. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","»Chupa cꞌu rukꞌijol ri cꞌastajibal, echiriꞌ quecꞌastaj lo ri wukub achijab, ¿chinok chique cuꞌana rachijil rixok? Ma conoje xecꞌuliꞌ rucꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ri Jesús xucꞌul uwach: —Ralak lic sachinak alak, ma na majom ta alak usucꞌ Ruchꞌaꞌtem ri Dios y ruchukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ma echiriꞌ quecꞌastaj lo ri ecaminak, na quecꞌuliꞌ ta chic yey na quequiya ta chi ne ri calcꞌoꞌal pa cꞌulaniquil; quebuꞌana cꞌu pachaꞌ ri ángeles e cꞌo chilaꞌ chicaj, ma ri ángeles na quecꞌuliꞌ taj. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","»Noꞌj puwi cꞌu ri cꞌastajibal que ri ecaminak, ¿na ajilam ta neba alak ri xutzꞌibaj can ri Moisés puwi ri xubiꞌij ri Dios che echiriꞌ xchꞌaꞌt rucꞌ chupa ri jumocaj xuluquej? Ma jewaꞌ xubiꞌij che: “In ri Dios re ri Abraham, re ri Isaac y re ri Jacob” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yey ri Dios na e ta Dios que ri ecaminak, ma e Dios que ri e cꞌaslic. E uwariꞌche ralak lic na usucꞌ ta ri naꞌoj alak puwi ri cꞌastajibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ecꞌuchiriꞌ, xkib rucꞌ ri Jesús jun chique raj cꞌutunel re ri tzijpixab. Waꞌ waꞌchi xuto echiriꞌ ri Jesús lic xurik ucꞌulic uwach ri tzꞌonobal que ri saduceos. Xutzꞌonoj cꞌu che: —Chupa Rutzij Upixab ri Dios, ¿pachique ri takanic más chirajawaxic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xucꞌul uwach: —Rucꞌuꞌxibal ronoje ri Tzij Pixab re ri Dios e waꞌ: Chitaꞌ, ix aj Israel; ri Dios Kajawxel, xa jun Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cꞌax cꞌu chanaꞌa ra Dios Kajawxel rucꞌ ronoje awanimaꞌ, rucꞌ ronoje acꞌuꞌx, rucꞌ ronoje anaꞌoj y rucꞌ ronoje achukꞌab. E ucꞌuꞌxibal waꞌ Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yey rucaꞌm jewaꞌ cubiꞌij: Cꞌax chanaꞌa rawatz-achakꞌ jelaꞌ pachaꞌ ri cꞌax canaꞌ awib riꞌat. Na jinta chi cꞌu juna tzij más cꞌo uwach chwa tak waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jecꞌuwaꞌ xubiꞌij raj cꞌutunel re ri tzijpixab che ri Jesús: —Lic utz, lal tijonel; lic katzij ri cabiꞌij la: “Xa jun ri Dios cꞌolic y na jinta junok chic.” ");
INSERT INTO acrTNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yey ri lic chirajawaxic wi e cꞌax cakanaꞌ ri Dios rucꞌ ronoje kanimaꞌ, rucꞌ ronoje kanaꞌoj, rucꞌ ronoje kacꞌuꞌx y rucꞌ ronoje ri kachukꞌab; yey ri cꞌax quekanaꞌ ri katz-kachakꞌ jelaꞌ pachaꞌ ri cꞌax cakanaꞌ kib riꞌoj. Waꞌ e más chirajawaxic chiquiwa rawaj eporom chwi raltar rucꞌ tak ri cayaꞌiꞌ chwach ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Echiriꞌ ri Jesús xrilo lic cꞌo unaꞌoj raj cꞌutunel re ri tzijpixab, xubiꞌij che: —Lic xa nakaj lal cꞌo wi che rutakanic ri Dios —xchaꞌ. Y na jinta chi cꞌu junok xraj xuꞌan juna tzꞌonobal che. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Echiriꞌ cacꞌutun ri Jesús chupa ri Rocho Dios, jewaꞌ xubiꞌij: —¿Suꞌbe raj cꞌutunel re ri tzijpixab caquibiꞌij: “Ri Cristo, Ruchaꞌoꞌn lo ri Dios, e Ralcꞌoꞌal can ri rey David”? ");
INSERT INTO acrTNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma ri David, ruma ri Santowilaj Ruxlabixel ri Dios, jewaꞌ xubiꞌij: Ri Dios Kajawxel xubiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwiquikꞌab, y chawoyeꞌej na ri kꞌij echiriꞌ quebenuya ri tzel quebilow awe chuxeꞌ rawakan” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ecꞌu ri David cubiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbe cꞌu riꞌ cabiꞌxic e Ralcꞌoꞌal can ri rey David? —xchaꞌ. Y uqꞌuiyal winak re ri tinamit lic rucꞌ ronoje quicꞌuꞌx caquita ri cubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ecꞌu ri Jesús jewaꞌ cubiꞌij chupa rucꞌutunic: «Lic chichajij iwib; miꞌan cꞌu iweꞌix pachaꞌ ri caquiꞌan raj cꞌutunel re ri tzijpixab. Ma rique e lic cucꞌul quicꞌuꞌx ri quejurur chupa ri quikꞌuꞌ chaꞌ quilitajic lic cꞌo quiwach y ri cayaꞌ rutzil quiwach pa quebilitaj wi. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yey pa tak sinagogas y pa tak waꞌim lic cucꞌul quicꞌuꞌx ri quetzꞌuyiꞌ chupa ri tzꞌulibal que ri lic cꞌo quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rique caquimaj rubitak que rixokib e malcaꞌnib. Y chaꞌ cayac quikꞌij, caquiꞌan nimak chꞌabal echiriꞌ caquiꞌan orar. Ruma cꞌu ri caquiꞌano, rique lic unimal cꞌaxcꞌolil ri caquicꞌulu echiriꞌ cakꞌat tzij paquiwiꞌ» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ri Jesús tzꞌul pana chwach ri caxa pa cayaꞌ wi ri kasaꞌn yey lic cutzutzaꞌ echiriꞌ ri winak caquiya can ri quikasaꞌn chupa ri caxa. Y lic e qꞌui ri beyomab caquiya uqꞌuiyal kasaꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xopon cꞌu jun ixok nibaꞌ yey malcaꞌn y xuya chupa ri caxa caꞌib raltak co meyo lic na qꞌui ta rajil. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ecꞌu ri Jesús xebusiqꞌuij rutijoꞌn y xubiꞌij chique: —Pakatzij wi cambiꞌij chiwe: Chwach ri Dios, waꞌ wiꞌxok nibaꞌ y malcaꞌn, e ne xuya más pa ri caxa chwa ri xquiya conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ma conoje xa e xquiya ruwiꞌ ri quipuak; noꞌj wiꞌxok tob lic nibaꞌ e xuya ronoje ri puak cꞌo rucꞌ, waꞌ e re culokꞌ ri lic cajawax che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Echiriꞌ xel bi ri Jesús pa ri Rocho Dios, jun chique rutijoꞌn jewaꞌ xubiꞌij che: —Kajawal, ¡chilape la wa chomilaj tak abaj y wa nimak tak ja re ri Rocho Dios! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ri Jesús xucꞌul uwach: —¿Cawil waꞌ wa nimak tak ja? Wara na cacanaj ta can juna abaj chwi juna chic, ma ronoje cawulixic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ri Jesús xtzꞌuyiꞌ chwa ri juyub Olivos, ri cꞌo chwach pana ri Rocho Dios. Ecꞌu ri Pedro, ri Jacobo, ri Juan y ri Andrés, xa quituquel xquitzꞌonoj che: ");
INSERT INTO acrTNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Biꞌij co la chike, ¿jampa nawi cuꞌana tak riꞌ waꞌ? ¿Yey saꞌ ri cꞌutubal quilitajic echiriꞌ cuꞌanaꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ecꞌu ri Jesús xujek ubiꞌxiquil chique: «Lic chichajij iwib chaꞌ na jinta junok casocow iweꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ma lic e qꞌui ri ticawex quecꞌunic y xa caquichikꞌimaj uwach ri nubiꞌ, jewaꞌ caquibiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios” quechaꞌ. Y lic e qꞌui ri quesocotaj cuma rique. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","»Ecꞌuchiriꞌ quito cꞌo chꞌaꞌoj jewaꞌ y cꞌo chꞌaꞌoj jelaꞌ, mixiꞌij iwib che; ma lic chirajawaxic wi cuꞌana tak waꞌ. Noꞌj na e ta waꞌ ri qꞌuisbal re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ma e cꞌo tinamit queyactaj chiquij jujun chic tinamit y e cꞌo takanelab queyactaj chiquij jujun chic takanelab. Cuꞌan tak cabrakan che uqꞌuiyal luwar, cape tak numic y ri winak caquijeko lic quetucuquic. Ronoje waꞌ xa e jekebal re ri cꞌaxcꞌobic cacꞌunic. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","»Lic chichajij cꞌu iwib, ma quixcꞌam bi pa tak kꞌatbal tzij y cajichꞌ ne ipa chupa tak ri sinagogas. Y ruma cꞌu icojom ri nubiꞌ, quixcꞌam bi chiquiwach ri takanelab y chiquiwach ri reyes, chaꞌ jelaꞌ quikꞌalajisaj ri Utzilaj Tzij chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lic cꞌut chirajawaxic nabe na catzijox ri Utzilaj Tzij chique conoje ruqꞌuiyal quiwach tak ri ticawex e cꞌo che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yey echiriꞌ quixcꞌam bi re quixeꞌyoꞌk pa tak kꞌatbal tzij, mubisoj icꞌuꞌx y michꞌob nenareꞌ saꞌ ri quibiꞌij. Riꞌix xew chibiꞌij janipa ri cuya ri Dios chiwe chupa ri ora, ma na ix ta ri quixchꞌawic, e ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","»E tak cꞌu ri ticawex quequiya ri catz-quichakꞌ pa camic; ri cꞌo calcꞌoꞌal quequiya tak ri calcꞌoꞌal pa camic; ri e alcꞌoꞌal queyactaj chiquij quichu-quikaw y quequicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lic cꞌut tzel quixil cuma tak ri winak ruma icojom ri nubiꞌ. Pero china cꞌu ri cuchukꞌubej rib chwach tak waꞌ wa cꞌaxcꞌobic cꞌa chupa ri qꞌuisbal re, e riꞌ ri cacolobetajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","»Echiriꞌ riꞌix quiwil ri lic chꞌul y lic qꞌuixbal uwach cayaꞌ pa ri luwar pa lic na takal ta wi, jelaꞌ pachaꞌ ri xutzꞌibaj can ri kꞌalajisanel Daniel (china cꞌu ri cajilan re waꞌ, chumaja usucꞌ); ecꞌuchiriꞌ, ri e cꞌo pa tak ri luwar re Judea, chebanimaj ubi chwa tak ri juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","China cꞌu ri cꞌo lo chwi ri rocho, makaj ne lo che ucꞌamic bi ubitak re pa ja. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yey china ri cꞌo lo pa juyub, matzelej lo che ucꞌamic bi rukꞌuꞌ re pisbal rij. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","»Chupa tak cꞌu laꞌ la kꞌij, lic tokꞌoꞌ quiwach ri e yewaꞌ ixokib y ri quetzꞌumtisanic. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lic cꞌu chitzꞌonoj che ri Dios chaꞌ echiriꞌ quixanimaj bi na e ta ukꞌijol echiriꞌ cꞌax tew y cꞌo jab. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma tak laꞌ la kꞌij re unimal cꞌaxcꞌolil, na uꞌanom ta cꞌana julajok chwi lo echiriꞌ ri Dios xuꞌan ruwachulew y na cuꞌana ta chi ne cꞌana julajok. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We ta ri Kakaw Dios na cukꞌatij ta tak laꞌ la kꞌij re runimal cꞌaxcꞌobic, riꞌ na jinta junok cacꞌasiꞌ canok; noꞌj ruma cꞌu cꞌax quebunaꞌ ri ebuchaꞌom, cukꞌatij rukꞌijol waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","»We cꞌo cꞌu junok cabiꞌn chiwe: “¡Chiwilapeꞌ, wara cꞌo wi ri Cristo!” o “¡Chiwilapeꞌ, leꞌ cꞌolic!”, mixoc il che. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ma quecꞌun ri caquiꞌan “Cristo” che quib y ri caquiꞌan e kꞌalajisanelab re ri Dios che quib, pero xa e socosoꞌnel. Ecꞌu rique caquiꞌan nimak tak cꞌutubal y milagros re quesocosoꞌn rucꞌ, yey cꞌo ne pa sak quesocotaj jujun chique ri ebuchaꞌom ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lic cꞌu chichajij iwib, ma ximbiꞌij ronoje waꞌ chiwe riꞌix echiriꞌ cꞌamajaꞌ ne cuꞌanaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","»Ecꞌuchiriꞌ icꞌowinak chi ri cꞌaxcꞌobic che tak laꞌ laꞌ kꞌij, cuꞌan kꞌekuꞌm uwach riꞌ ri kꞌij, y ri icꞌ na cuya ta chi ruwonibal. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri chꞌumil quetzak lo che ruwa caj, y conoje ri cꞌo quichukꞌab che ruwa caj queyiquiyoꞌxic. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ecꞌuchiriꞌ, quilitaj Ralaxel Chiquixoꞌl Ticawex cacꞌun lo pa sutzꞌ rucꞌ runimal uchukꞌab y rucꞌ runimal uchomalil. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Quebutak cꞌu ru ángeles che umolic quichiꞌ conoje ri ebuchaꞌom ri Dios pa tak ronoje luwar che rucajchal rajlibal ruwachulew. Cujek cꞌu riꞌ che jun luwar, yey cuqꞌuisbej che jun chic. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","»E chimaja ri jun cꞌambal naꞌoj puwi ri cheꞌ re higo: Echiriꞌ cujek catux lo cꞌacꞌ ukꞌab y cujek cꞌut catux ruxak, ruma cꞌu laꞌ quiwetaꞌmaj xa nakaj chi cꞌo wi lo rukꞌijol echiriꞌ cabucbutic y na jinta jab. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jecꞌuriꞌlaꞌ riꞌix, echiriꞌ quiwilo cuꞌana ronoje tak waꞌ, chiwetaꞌmaj cꞌu riꞌ xa nakaj chi cꞌo wi lo rukꞌijol rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Pakatzij wi cambiꞌij chiwe: E cꞌo ticawex re waꞌ wa kꞌij na quecam tana we na xquil tubi ronoje waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ruwa caj y ruwachulew xa casach uwach, noꞌj tak ri nuchꞌaꞌtem na casach ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","»Ecꞌu chwi rukꞌijol y ruꞌorayil waꞌ, na jinta junok etaꞌmayom re; na quetaꞌam tane ri ángeles e cꞌo chilaꞌ chicaj, na retaꞌam tane ri Cꞌajolaxel, ma xew ri Kakaw Dios etaꞌmayom re. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","»Chiwila cꞌu riꞌ, mawar iwach y lic chiꞌana orar, ma na iwetaꞌam taj jampalaꞌ copon rukꞌijol waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ri cuꞌanaꞌ e pachaꞌ echiriꞌ juna achi queꞌec naj. Ecꞌuchiriꞌ queꞌec, cuya can ri rocho paquikꞌab ri raj chaquib y chiquijujunal waꞌ cuya can quichac. Cubiꞌij cꞌu can che ri chajinel re ri puerta: “Lic matcos che uchajixic ri ja” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jecꞌuriꞌlaꞌ riꞌix, lic mawar iwach, ma na iwetaꞌam taj jampalaꞌ cacꞌun lo ri rajaw ja; laj echiriꞌ coc rakꞌab, laj pa tiqꞌuil akꞌab, laj pa nabe uchꞌawibal ri teren o echiriꞌ quel lo ri kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mawar cꞌu iwach riꞌ, chaꞌ we xakicꞌateꞌt xcꞌun lo ri Iwajaw, na quixurik taj quixwaric. ");
INSERT INTO acrTNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ecꞌu wa cambiꞌij riꞌin chiwe riꞌix, cambiꞌij chique conoje: Lic mawar iwach» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Echiriꞌ queb kꞌij chi copon wi ri nimakꞌij Pascua y ri nimakꞌij re tijoj pam na jinta levadura che, tak ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab, lic caquitzucuj suꞌanic caquichap ri Jesús rucꞌ socosoꞌnic re caquicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xquibiꞌij cꞌut: «Na cakaꞌan ta pa wa nimakꞌij chaꞌ ri tinamit na quetucuc ta ruma waꞌ» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Cꞌo cꞌu ri Jesús pa ri tinamit Betania chirocho ri Simón, ri jun xcꞌojiꞌ ri yabil lepra che. Ecꞌuchiriꞌ tzꞌul ri Jesús chwa ri mexa, xopon jun ixok rucꞌaꞌam jun cꞌolibal nojinak che cunabal lic quiꞌ ruxlab y lic qꞌui rajil, waꞌ ꞌanatal rucꞌ sakil nardo. Rixok xutekꞌij uchiꞌ ri cꞌolibal; tecꞌuchiriꞌ, xukꞌej ri cunabal chuꞌjolom ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E cꞌo cꞌu jujun chique ri e cꞌo chiriꞌ xpe coyowal echiriꞌ xquil waꞌ, y jewaꞌ xquibiꞌij chiquiwach: —¿Suꞌchac wa cunabal xtzꞌiloꞌxic? ");
INSERT INTO acrTNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma ri lic usucꞌ e ta xcꞌayix waꞌ chi oxib ciento denarios, y rucꞌ waꞌ quetoꞌ ri nibaꞌib —xechaꞌ. Y lic cꞌu riꞌ quechꞌaꞌt chirij rixok. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ecꞌu ri Jesús xubiꞌij chique: —Micꞌak bi ukꞌij wiꞌxok. ¿Suꞌbe quixchꞌaꞌt chirij ri xuꞌano? Ma ri xuꞌan chwe e jun utzilaj chac. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri nibaꞌib e laꞌ xaki e cꞌo iwucꞌ yey utz quebitoꞌo jampalaꞌ quiwaj riꞌix, noꞌj riꞌin na xaki ta in cꞌo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wiꞌxok e xuꞌano janipa ri xuchꞌij uꞌaniquil; rucꞌ cꞌu waꞌ e xnabej pan che uyijbaxic ri nucuerpo che ri mukubal we. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Pakatzij wi cambiꞌij chiwe: Pa tak catzijox wi wa Utzilaj Tzij che ronoje ruwachulew, cacuxtax cꞌu wiꞌxok ruma ri xuꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ewi ri Judas aj Iscariot, jun chique ri cablajuj utijoꞌn ri Jesús, xeꞌec cucꞌ ri nimak e aj chacunel pa Rocho Dios re cuya ri Jesús paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rique, echiriꞌ xquita waꞌ, lic xequiꞌcot che y xquibiꞌtisij nenareꞌ caquiya puak che. Ecꞌu riꞌ ri Judas xujek utzucuxic suꞌanic cuya ri Jesús paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chupa cꞌu ri nabe kꞌij re ri nimakꞌij echiriꞌ catij ri pam na jinta levadura che y quecamisax chwi raltar tak ri kꞌapoj bexex re ri Pascua, rutijoꞌn ri Jesús xquitzꞌonoj che: —¿Pa caꞌaj wi la queꞌkayijbaꞌ wi ri cena re Pascua? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ewi xebutak bi caꞌib chique rutijoꞌn y xubiꞌij bi chique: —Jix pa ri tinamit y echiriꞌ quicꞌul jun achi rucꞌaꞌam jun curaꞌ yaꞌ, chixterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pa cꞌu coc wubi waꞌ waꞌchi, chibiꞌij che ri rajaw ja: “Jewaꞌ cubiꞌij ri tijonel keꞌoj: ¿Pachawi cꞌo wi ri luwar pa cantij wi ri cena re Pascua cucꞌ ri nutijoꞌn?” quixcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ecꞌu ri cuꞌan ri rajaw ja e cucꞌut chiwe jun nimalaj luwar chicaj pa ri caleꞌ ja, waꞌ yijbital chic. Chiriꞌ cꞌu riꞌ chiyijbaꞌ wi ri cena re Pascua —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebec cꞌu rutijoꞌn, xeboc pa ri tinamit y xeꞌquirikaꞌ jelaꞌ pachaꞌ ri xubiꞌij bi ri Jesús chique. Y xquiyijbaꞌ cꞌu ri cena re Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ecꞌuchiriꞌ xoc rakꞌab, xopon ri Jesús junam cucꞌ ri cablajuj utijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ecꞌuchiriꞌ e cꞌo chwa ri mexa, e riꞌ quewaꞌic, ri Jesús xubiꞌij: —Pakatzij wi cambiꞌij chiwe: Jun chiwe wa ix cꞌo wara wucꞌ pa waꞌim, e cacꞌayin we —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ewi rique xquijek lic quebisonic y chiquijujunal caquitzꞌonoj che: —¿Cꞌaxtaj in riꞌ? —cacha jun. —¿Cꞌaxtaj in riꞌ? —cacha jun chic. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ri Jesús xucꞌul uwach; jewaꞌ xubiꞌij: —Waꞌ e jun chiwe wa ix cablajuj, e ri cumuꞌ lo ruwa junam wucꞌ chupa ri lak. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Pakatzij wi Ralaxel Chiquixoꞌl Ticawex e catajin che ricꞌowibexic janipa ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios puwi Rire. Pero ¡lic cꞌu tokꞌoꞌ uwach rachi cacꞌayin re! E ne más utz che waꞌchi tamaji xalaxic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Xalokꞌ cꞌu riꞌ quewaꞌic, ri Jesús xucꞌam ri pam y xutioxij che ri Dios. Ewi xuwechꞌo, xujach chique y jecꞌuwaꞌ xubiꞌij: —Chitijaꞌ, ma e nucuerpo waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xucꞌam cꞌu ri cꞌolibal cꞌo vino chupa, yey echiriꞌ utioxim chi che ri Dios, xuya chique y conoje xquitij chuchiꞌ waꞌ wa cꞌolibal. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xubiꞌij cꞌu chique: —E nuquiqꞌuel waꞌ, ri caturuw na cuma uqꞌuiyal ticawex re cuybal quimac, yey waꞌ e cujiquibaꞌ uwach ri cꞌacꞌ tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Pakatzij wi cambiꞌij chiwe: Na cantij ta chi ruwaꞌal uva, cꞌate quiꞌntija tanchi chupa rukꞌijol rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Echiriꞌ xquiqꞌuis ubixoxic ri bix, xebec chwa ri juyub Olivos. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ecꞌuchiriꞌ ri Jesús xubiꞌij chique: —Wakꞌab iwonoje riꞌix quiwesaj na iwib chwij, ma e pachaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios: Cancamisaj raj chajinel yey tak cꞌu riꞌ rubexex caquiquich bi quib cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Noꞌj ecꞌuchiriꞌ quincꞌastaj lo chiquixoꞌl ri ecaminak, quinnabej bi chiwach cꞌa Galilea —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ecꞌu ri Pedro xubiꞌij: —Tob ne conoje caquesaj quib chiꞌij la, riꞌin na canꞌan ta waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yey ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij chawe: Wa jun akꞌab, echiriꞌ cꞌamajaꞌ ne cabixon calaj ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Noꞌj ri Pedro lic xujiquibaꞌ ubiꞌxiquil: —Tob ne chirajawaxic quincam junam ucꞌ la, riꞌin na canwewaj taj we wetaꞌam wach la —xchaꞌ. Jecꞌulaꞌ riꞌ xquibiꞌij conoje. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xebopon cꞌu pa jun luwar Getsemaní rubiꞌ. Ecꞌu ri Jesús xubiꞌij chique rutijoꞌn: —Chixtzꞌula can wara, noꞌj riꞌin quiꞌnꞌana orar —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yey xebucꞌam cꞌu bi ri Pedro, ri Jacobo y ri Juan rucꞌ. Xujek cꞌu riꞌ lic cabisonic y cacꞌaxcꞌob ri ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xubiꞌij cꞌu chique: —Cꞌo jun unimal bis re camic chinucꞌuꞌx. Chixcꞌola can wara; mixwaric y lic chiꞌana orar —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tecꞌuchiriꞌ, ri Jesús xkib chi pana jubikꞌ chwach, xukasaj umejelem cꞌa chuꞌlew, y xutzꞌonoj che ri Dios we ta cuya na che na quicꞌow ta chupa ruꞌorayil ri cꞌaxcꞌobic, ");
INSERT INTO acrTNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","jewaꞌ xubiꞌij: «Tat, Lal Nukaw, chiwach Rilal na jinta cꞌana cꞌayew; chincolobej co la chaꞌ na quinicꞌow ta chupa waꞌ wa cꞌaxcꞌobic. Noꞌj na e ta cꞌu chuꞌana ri cuaj riꞌin, ma e chuꞌanaꞌ janipa ri caꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tecꞌuchiriꞌ, xtzelej lo pa e cꞌo wi can rutijoꞌn y xeboꞌluꞌrikaꞌ quewaric. Xubiꞌij cꞌu che ri Pedro: —¿Catwar cami riꞌ? ¿Na xacuy ta cꞌana ri waram chaꞌ caꞌan orar wucꞌ, tob tane xa juna ora? ");
INSERT INTO acrTNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mixwar cꞌut, y lic chiꞌana orar chaꞌ quichꞌij uchukꞌab ri cꞌambal ipa capetic. Pakatzij wi, lic cacha icꞌuꞌx che uꞌanic ri utz, noꞌj waꞌ lic cꞌayew chiwe ma e ri itiꞌjil na jinta ucowil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ecꞌu ri Jesús xeꞌec tanchic, xuꞌana orar, yey e xutzꞌonoj che ri Dios ri ujekom chi lo utzꞌonoxic nabe. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tecꞌuchiriꞌ, xtzelej tanchi lo cucꞌ rutijoꞌn y xeboꞌluꞌrikaꞌ quewaric; ma ri quiwach lic na cucuy ta chi ri waram y na caquirik ta chic saꞌ ri caquibiꞌij che. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xtzelej cꞌu lo churox laj y xubiꞌij chique: —¿Cꞌa quixwar cami riꞌ riꞌix? ¿Cꞌa quixuxlanic? ¡Cuꞌan na cꞌu laꞌ! Ma e waꞌ xopon ruꞌorayil chaꞌ Ralaxel Chiquixoꞌl Ticawex cayaꞌ paquikꞌab raj maquib. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Chixwaꞌlijok! ¡Joꞌ! Chiwilaꞌ, ma ri cacꞌayin we riꞌin e laꞌ xcꞌunic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Cꞌa cachꞌaꞌt ne ri Jesús echiriꞌ xcꞌun lo ri Judas, jun chique ri cablajuj utijoꞌn. Ecꞌu rire erachbilam lo uqꞌuiyal winak cucꞌaꞌam lo espada y cheꞌ. Tak waꞌ etakom lo cuma ri nimak e aj chacunel pa Rocho Dios, tak raj cꞌutunel re ri tzijpixab y ri nimak winak re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ecꞌu ri Judas, ri cayaꞌw bi re paquikꞌab, ubiꞌim chi lo chique suꞌanic caquetaꞌmaj china ri caquichapo, jewaꞌ ubiꞌim: «E ri jun cantzꞌub uchiꞌ, e riꞌ rire. Chapa cꞌu alak y cꞌama bi alak, yey checojo bi alak e chajinel re chaꞌ na canimaj tubi» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ecꞌuchiriꞌ xcꞌunic, maji chic xkib rucꞌ ri Jesús y xubiꞌij che: —¡Wajawal, Wajawal! —xcha che. Y xutzꞌub uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ecꞌuchiriꞌ, ri winak xquichap ri Jesús chaꞌ caquicꞌam bi pa kꞌatbal tzij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Cꞌo cꞌu jun chique rutijoꞌn e cꞌo chiriꞌ, xresaj lo ru espada y xujochij bi jun uxiquin ri raj chac ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xubiꞌij cꞌu ri Jesús chique: —¿Suꞌchac petinak alak rucꞌ espada y cheꞌ? ¿Petinak cami alak che ucꞌamic bi juna elekꞌom? ");
INSERT INTO acrTNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wa petinak lok ronoje kꞌij waꞌ cꞌut quincꞌutun chiwach alak pa ri Rocho Dios. ¿Suꞌchac cꞌu riꞌ cꞌa e laꞌ quinoꞌlchapa alak? Noꞌj jecꞌuwaꞌ cuꞌano chaꞌ e cuꞌana janipa ri kꞌalajisam can chupa Ruchꞌaꞌtem ri Dios —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tecꞌuchiriꞌ, conoje rutijoꞌn xebanimajic y jelaꞌ xquiya can ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Cꞌo cꞌu jun ala teran bi chirij ri Jesús, upisom rib xa chupa jun sábana; rire xchap cuma ri soldados. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero rala xusolij can rusábana y e laꞌ chꞌanalic xanimajic. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xquicꞌam cꞌu bi ri Jesús chwach ri cajawal raj chacunel pa Rocho Dios. Tecꞌuchiriꞌ, xquimol quib ri nimak e aj chacunel cucꞌ ri nimak winak re ri tinamit y raj cꞌutunel re ri tzijpixab. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ecꞌu ri Pedro xa naj teran pan chirij ri Jesús y xoc bi cꞌa che ruwa ja re ri rocho ri cajawal raj chacunel pa Rocho Dios. Xeꞌtzꞌula cꞌu cucꞌ ri e chajinel, e riꞌ cumikꞌisaj rib chuchiꞌ ri akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ri nimak e aj chacunel pa Rocho Dios cucꞌ conoje ri uchapom wi rib ri kꞌatbal tzij, caquitzucuj suꞌanic caquicoj umac ri Jesús chaꞌ jelaꞌ utz cakꞌat tzij re camic puwiꞌ, noꞌj na jinta cꞌo xquirik chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma lic e qꞌui ri winak xquitzꞌak uchiꞌ, pero lic junwi tak ri xquibiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ewi xeyactaj jujun y xquitzꞌak uchiꞌ, jewaꞌ xquibiꞌij chirij: ");
INSERT INTO acrTNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Riꞌoj xkato echiriꞌ xubiꞌij: “Canwulij wa Rocho Dios ꞌanatal xa cuma rachijab, yey xa pa oxib kꞌij canyac jun chic na ꞌanatal ta cuma rachijab” —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na rucꞌ ta cꞌu riꞌ, lic junwi tak ri xquibiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ewi ri cajawal raj chacunel pa Rocho Dios xyactaj chiquixoꞌl y xutzꞌonoj che ri Jesús: —¿E cami laꞌ na jinta cꞌana cabiꞌij riꞌat? ¿Saꞌ cꞌu ri cacꞌulubej uwach puwi wa quetajin che ucojic chawij? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús xa xuto y na jinta cꞌo xubiꞌij. Tecꞌuchiriꞌ, xuꞌan jun chic tzꞌonobal che ri Jesús: —¿At ba riꞌ ri Cristo, Rucꞌajol ri Dios, ri Jun lic nim ukꞌij? —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ri Jesús xucꞌul uwach: —Katzij, “In Riꞌin.” Quil na cꞌu alak Ralaxel Chiquixoꞌl Ticawex tzꞌul puwiquikꞌab ri Dios, ri lic cꞌo unimal uchukꞌab yey quil cꞌu alak riꞌ echiriꞌ cacꞌun lo pa sutzꞌ chwa ri caj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ecꞌu ri cajawal raj chacunel pa Rocho Dios xurichꞌij rukꞌuꞌ y xubiꞌij: —¡Na jinta chi uchac más e aj cojol umac! ");
INSERT INTO acrTNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma lic e laꞌ xta alak xmacun chirij ri Dios echiriꞌ xubiꞌij ri lic na takal ta che. ¿Saꞌ cꞌu riꞌ cabiꞌij ralak che? —xchaꞌ. Ewi conoje xquikꞌat tzij puwi ri Jesús y xquibiꞌij lic takal che cacamisaxic. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y e cꞌo jujun xquijek caquichubaj; caquichꞌuk rupalaj, caquiꞌan pa tꞌoꞌy yey caquibiꞌij cꞌu che: —Chanaꞌij peꞌ china xchꞌayaw awe —quecha che. Yey ri e chajinel caquipachꞌ kꞌab chupalaj. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ecꞌu ri Pedro cꞌo iquem che ruwa ja echiriꞌ xcꞌun lo jun ali raj chac ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ecꞌuchiriꞌ rali xril ri Pedro cumikꞌisaj rib chuchiꞌ ri akꞌ, lic xutzutzaꞌ uwach y xubiꞌij che: —Rilal lal jun chique ri eteran chirij ri Jesús ri aj Nazaret —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ewi ri Pedro xrewaj, jewaꞌ xucꞌul uwach: —Riꞌin na wetaꞌam ta uwach y na wetaꞌam tane saꞌ puwiꞌ catchꞌaꞌt wi —xchaꞌ. Xel cꞌu bi chuchiꞌ ri puerta. Tecꞌuchiriꞌ, xchꞌaw ri teren. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ecꞌu rali aj chac echiriꞌ xril tanchi ri Pedro, xujek ubiꞌxiquil chique tak ri e cꞌo chiriꞌ: —Waꞌ waꞌchi e jun chique rutijoꞌn ri Jesús —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noꞌj ri Pedro xrewaj tanchic. Jokꞌotaj cꞌu riꞌ, e tak ri e cꞌo chiriꞌ xquibiꞌij tanchi che ri Pedro: —Pakatzij wi rilal lal jun chique rutijoꞌn; lic kꞌalaj lal aj Galilea, ma ri cachꞌaꞌt la e junam rucꞌ ri quechꞌaꞌt rique —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ewi ri Pedro xujek ubiꞌxiquil itzel tak tzij y lic xujiquibaꞌ uwach, xubiꞌij: —Riꞌin na wetaꞌam ta cꞌana uwach waꞌ waꞌchi cabiꞌij alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ecꞌu ri teren xchꞌaw chucalaj. Ewi xcꞌun lo chucꞌuꞌx ri Pedro ri xbiꞌx lo che ruma ri Jesús: «Cꞌamajaꞌ ne cabixon ri teren chucalaj, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach.» Ecꞌu catajin waꞌ pujolom, xumaj rokꞌej. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Echiriꞌ xsakiric, ri nimak e aj chacunel pa Rocho Dios cucꞌ tak ri nimak winak re ri tinamit, raj cꞌutunel re ri tzijpixab y conoje ri uchapom wi rib ri kꞌatbal tzij, quiꞌanom chi tzij chiquiwach puwi saꞌ ri caquiꞌan rucꞌ ri Jesús. Xquicꞌam cꞌu bi ri Jesús yututalic y xeꞌquiyaꞌa chwach ri takanel Pilato. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ri Pilato xutzꞌonoj cꞌu che ri Jesús: —¿Lal cami riꞌ ri rey que raj judiꞌab? —xcha che. Ri Jesús xucꞌul uwach: —Lal cabiꞌn la re —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yey ri nimak e aj chacunel pa Rocho Dios lic caquitzꞌak uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xutzꞌonoj tanchi cꞌu ri takanel Pilato che: —¿E cami laꞌ na cacꞌul ta la uwach? ¿Na cata ta cami la janipa chi mac caquicoj chiꞌij la? —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na rucꞌ ta cꞌu riꞌ, ri Jesús na xucꞌul ta uwach. Ruma cꞌu waꞌ, ri Pilato lic xcam ranimaꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chupa cꞌu ri nimakꞌij Pascua, ri takanel romano xex cuꞌan wi cuyolopij bi jun chique ri e cꞌo pa cárcel, yey e ri winak quechaꞌwic china ri cacaj cayolopix bi. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Cꞌo cꞌu jun achi Barrabás rubiꞌ, rire cꞌo pa cárcel cucꞌ jujun rachbiꞌil ruma xquiꞌan camic echiriꞌ xeyactaj chirij ri takanel aj Roma. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xebopon cꞌu uqꞌuiyal winak chwach ri takanel Pilato y xquijek utzꞌonoxic che e cuꞌan pachaꞌ tak ri uꞌanom lo ronoje junab. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ewi ri takanel Pilato xutzꞌonoj chique: —¿Caꞌaj alak canyolopij bi ri rey que raj judiꞌab? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Xubiꞌij waꞌ ma retaꞌam ri nimak e aj chacunel pa Rocho Dios xeꞌquiyaꞌa ri Jesús chwach, xa ruma cꞌax quicꞌuꞌx chirij. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ecꞌu ri nimak e aj chacunel pa Rocho Dios xquicoj pa quijolom ri uqꞌuiyal winak e caquitzꞌonoj cayolopix bi ri Barrabás. Yey rique jelaꞌ xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ri Pilato xutzꞌonoj tanchi chique: —¿Saꞌ cꞌu riꞌ caꞌaj alak canꞌan rucꞌ ri cabiꞌij alak e rey que raj judiꞌab? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yey ri winak lic xesiqꞌuin tanchi che ucꞌulic uwach: —¡Camisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ecꞌu ri takanel Pilato xutzꞌonoj chique: —¿Saꞌ cꞌu rumac uꞌanom? —xchaꞌ. Noꞌj ri winak más co xesiqꞌuinic: —¡Camisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ewi ri Pilato xa ruma xraj cacanaj can chi utz cucꞌ ruqꞌuiyal winak, e xuyolopij bi ri Barrabás. Yey xebutak ri soldados che ujichꞌic upa ri Jesús. Tecꞌuchiriꞌ, xuya bi paquikꞌab re caquicamisaj chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ri soldados xquicꞌam cꞌu bi ri Jesús che ruwa ja re rupalacio ri takanel. Chiriꞌ xmoliꞌ quichiꞌ conoje tak ri soldados. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ecꞌu ri soldados xquicoj jun cꞌul morato che ri Jesús. Che cꞌu rujolom xquicoj jun corona pachꞌum rucꞌ qꞌuix. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xquijek cꞌu quesiqꞌuin che, jewaꞌ caquibiꞌij: —¡Nim ukꞌij ri rey que raj judiꞌab! —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Caquichꞌay rujolom rucꞌ jucutaj tani y caquichubaj rupalaj. Caquixucubaꞌ cꞌu quib chwach, lic xa uꞌaniquil caquiyac ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Echiriꞌ ya lic xquichꞌamij, xquesaj ri cꞌul morato quicojom che y xquicoj tanchi rukꞌuꞌ. Xquesaj cꞌu bi chaꞌ queꞌquicamisaj chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Cꞌo cꞌu jun achi aj Cirene petinak pa juyub e riꞌ quicꞌow chiriꞌ. Ecꞌu ri soldados xquitak che cutelej bi ri cruz re ri Jesús. Rachi, Simón rubiꞌ, rire e quikaw ri Alejandro y Rufo. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y xquicꞌam bi ri Jesús pa jun luwar Gólgota cabiꞌx che, waꞌ queꞌelawi “luwar re ubakil ujolom animaꞌ”. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yey xquiyaꞌ che ri Jesús vino cojotal mirra rucꞌ; noꞌj Rire na xutij taj. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Echiriꞌ quiyaꞌom chi ri Jesús chwa ri cruz, ri soldados rucꞌ jun sorteo xquijach quib puwi rukꞌuꞌ chaꞌ caquilo saꞌ tak ri caquicꞌam bi chiquijujunal. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Anim che ri ubelej ora, xquiya ri Jesús chwa ri cruz. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chwi cꞌu lo rucruz ri Jesús tzꞌibitalic suꞌbe xkꞌat tzij puwiꞌ, jewaꞌ cubiꞌij: «RI REY QUE RAJ JUDIꞌAB.» ");
INSERT INTO acrTNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xequiya cꞌu caꞌib elekꞌomab chwa cruz, jun puwiquikꞌab y jun pumox ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ecꞌu xuꞌana riꞌ ri tzꞌibital can chupa Rutzij Upixab ri Dios: E jun Rire xajilax bi cucꞌ ri winak itzel quicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri winak quebicꞌow chiriꞌ caquiyokꞌ canok, caquiyiriyaꞌ ri quijolom che y jecꞌuwaꞌ caquibiꞌij che: —¡Ah! At peꞌ ri abiꞌim cawulij ri Rocho Dios y xa pa oxib kꞌij cayac tanchic. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chacolobej cꞌu awib riꞌ y chatkaj lo chwa ri cruz —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jenelaꞌ riꞌ xquiꞌan ri nimak e aj chacunel pa Rocho Dios junam cucꞌ raj cꞌutunel re ri tzijpixab; rique lic caquichꞌamij, jewaꞌ caquibiꞌij chiquiwach: —Lic waꞌ cꞌut e qꞌui ri xebucolobej che tak yabil y che camic, yey na curik ta waꞌ ucolobexic rib rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Laꞌ laꞌchi cabiꞌx “Cristo, Rey que Raj Israel” che, kaja lo riꞌ utuquel chwa ri cruz chaꞌ cakilo y jelaꞌ cakacojo e rire ri Uchaꞌoꞌn lo ri Dios —quechaꞌ. Y jenelaꞌ ri caꞌib eyaꞌom chwa cruz junam rucꞌ, lic xquichꞌamij Rire. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ecꞌuchiriꞌ xticꞌoj ri kꞌij, xoc kꞌekuꞌm che ruwachulew y waꞌ xuꞌqꞌuisa cꞌa che ri urox ora benak kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chupa cꞌu laꞌ la ora, ri Jesús lic co xsiqꞌuinic, jewaꞌ xubiꞌij pa ri chꞌaꞌtem cachꞌaꞌt wi Rire: —Eloi, Eloi, ¿lama sabactani? —xchaꞌ. Waꞌ queꞌelawi: “Lal nu Dios, Lal nu Dios, ¿suꞌbe xinokꞌotaj can la?” ");
INSERT INTO acrTNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jujun cꞌu chique ri e cꞌo chiriꞌ, echiriꞌ xquita waꞌ, xquibiꞌij: —Chitapeꞌ, waꞌchi e cusiqꞌuij ri kꞌalajisanel Elías —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Cꞌo cꞌu jun xeꞌec lic canic, xumuꞌ jun esponja pa vinagre, xuxim cꞌu chutzaꞌm jun tani y xuya pan che ri Jesús re cutzꞌubu, y jecꞌuwaꞌ xubiꞌij: —Kila peꞌ we cacꞌun ri Elías re coluꞌkasaj lo chwa ri cruz —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Noꞌj ri Jesús lic co xsiqꞌuinic y jelaꞌ xcamic. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ecꞌuchiriꞌ, ri telón cꞌo chupa ri Rocho Dios xrichꞌrob chunicꞌajal; xujek lo puwiꞌ y xoꞌlqꞌuis cꞌa chuxeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ecꞌu ri capitán tacꞌal chwach ri Jesús, echiriꞌ xuto xsiqꞌuinic yey xrilo saꞌ rucamic, jewaꞌ xubiꞌij: —¡Pakatzij wi, waꞌ waꞌchi e Ucꞌajol ri Dios! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E cꞌo cꞌu jujun ixokib caquitzutzaꞌ pana chinimanaj. Chiquixoꞌl waꞌ e cꞌo ri María ri aj Magdala, ri Salomé y ri María quichu ri Jacobo (ri más cꞌacꞌal) y ri José. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Waꞌ wa ixokib lic xeterej chirij ri Jesús y lic quinimam lok echiriꞌ Rire cꞌo Galilea. Rique cucꞌ jujun chic uqꞌuiyal ixokib, xepakiꞌ lo rucꞌ pa ri tinamit Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Benak kꞌij, echiriꞌ raj judiꞌab caquiyijbaꞌ pan janipa ri cajawax chique pa ri kꞌij re uxlanibal, ");
INSERT INTO acrTNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ri José aj Arimatea xoc chwach ri takanel Pilato y na xuxiꞌij ta cꞌana rib xutzꞌonoj rucuerpo ri Jesús chaꞌ cucꞌam bi. (Ri José lic cꞌo uwach chique ri uchapom wi rib ri kꞌatbal tzij yey lic royeꞌem rucꞌunibal rutakanic ri Dios.) ");
INSERT INTO acrTNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ri Pilato lic xcam ranimaꞌ che echiriꞌ xuto caminak chi ri Jesús. Ewi xusiqꞌuij ri capitán chaꞌ cutzꞌonoj che we katzij. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Echiriꞌ xuta chi uchiꞌ ri capitán caminak chi ri Jesús, xuya luwar che ri José cucꞌam bi rucuerpo. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ecꞌu ri José xulokꞌ jun manta, xukasaj lo rucuerpo ri Jesús chwa ri cruz y xupis bi chupa ri manta. Xuꞌyaꞌa cꞌu riꞌ chupa jun mukubal cꞌotom paꞌbaj y xutak uquetebaxic can jun nimalaj abaj chuchiꞌ re tzꞌapibal re. ");
INSERT INTO acrTNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yey ri María ri aj Magdala y ri María ruchu ri José, xquilo pa xmuk can wi. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Echiriꞌ xicꞌow ri kꞌij re uxlanibal, ri María ri aj Magdala, ri Salomé y ri María ruchu ri Jacobo, xquilokꞌ cunabal lic quiꞌ ruxlab re caquibal rucuerpo ri Jesús chupa. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ecꞌu ri nabe kꞌij re ri semana lic anim cꞌa e riꞌ quel lo ri kꞌij, xebec pa mukutal wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Caquibiꞌij cꞌu chiquiwach: «¿China quesan rabaj chike cꞌo chuchiꞌ ri mukubal?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero cꞌate xquilo, rabaj esam chic, yey waꞌ lic nim. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ecꞌuchiriꞌ xeboc bi chupa ri mukubal, xquil jun ala tzꞌul pa uwiquikꞌab chique, ucojom jun cꞌul sak lic naj rakan. Yey rique lic xquixiꞌij quib che. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ecꞌu rire xubiꞌij chique: —Mixiꞌij iwib. Riꞌix e quitzucuj ri Jesús ri aj Nazaret, ri xcamisax chwa cruz; Rire na jinta chi wara, ma cꞌastajinak chubi. Chiwila wa luwar pa xyaꞌiꞌ wi rucuerpo. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ecꞌu riꞌix jix, jiꞌbiꞌij chique rutijoꞌn y che ri Pedro: “Rire queꞌec Galilea, canabej bi chiwach; chilaꞌ cꞌu riꞌ quiꞌwila wi uwach, jelaꞌ pachaꞌ ri ubiꞌim chi lo chiwe” —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ecꞌu rixokib xebel bi chuchiꞌ ri mukubal lic quebirbotic ruma benak quinaꞌoj puwi ri xquilo; yey na jinta ne cꞌana cꞌo xquitzijoj wi ruma quixiꞌim quib. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ecꞌuchiriꞌ cꞌastajinak chi lo ri Jesús, anim tan che ri nabe kꞌij re ri semana, nabe xucꞌut uwach chwach ri María ri aj Magdala, ri e resam bi wukub itzel uxlabixel che. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Rire xeꞌec cꞌut chaꞌ cuꞌtzijoj rucꞌastajibal ri Jesús chique ri xeterej chirij yey xebuꞌrika cꞌu riꞌ lic quebisonic y quebokꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yey rique echiriꞌ xquito cꞌastajinak chi lo ri Jesús y xilitaj uwach ruma ri María, na xquicoj taj. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tecꞌuchiriꞌ, ri Jesús xucꞌut uwach chiquiwach caꞌib chique rutijoꞌn, noꞌj junwi uꞌaniquil xuꞌan waꞌ echiriꞌ rique e riꞌ quebinic quebec pa juyub. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ecꞌu wa caꞌib xetzelejic, xeꞌquitzijoj chique ri jujun chic tijoꞌn; yey waꞌ na xcoj tane chwiquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Qꞌuisbal chi cꞌu re, ri Jesús xucꞌut uwach chiquiwach ri junlajuj utijoꞌn echiriꞌ rique etzꞌul chwa mexa, yey xuchꞌaꞌbej quipa ruma na cubul ta quicꞌuꞌx rucꞌ y ruma uꞌanom lic co ri canimaꞌ, ma na xquicoj ta que ri xebilow re ri Jesús cꞌastajinak chic. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xubiꞌij cꞌu chique: —Jix che ronoje ruwachulew y chitzijoj ri Utzilaj Tzij chique conoje ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ecꞌu ri quecojow re y caquicꞌul ri bautismo, quecolobetajic. Noꞌj cꞌu ri na quecojow ta re, cakꞌat na tzij paquiwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yey chique ri quecojow re, quilitaj cꞌutubal re ruchukꞌab ri Dios. Pa ri nubiꞌ quebequesaj bi itzel uxlabixel, quechꞌaꞌt pa jujun chic cꞌacꞌ chꞌaꞌtem, ");
INSERT INTO acrTNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","caquichap tak ne cumatz paquikꞌab. Yey we cꞌo ri xquitijo y na quinaꞌbem taj camisabal que, na jinta cꞌo cuꞌan chique. Caquiya ri quikꞌab paquiwi tak ri yewaꞌib, y waꞌ quecunutajic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ecꞌu ri Kanimajawal echiriꞌ chꞌaꞌtinak chi cucꞌ, xcꞌul pana chilaꞌ chicaj y xtzꞌuyiꞌ puwiquikꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E tak cꞌu rutijoꞌn xebel bi che utzijoxic ri Utzilaj Tzij pa tak ronoje luwar. Yey ri Kanimajawal xebutoꞌo, xuya chique caquicꞌut ruchukꞌab ri Dios chaꞌ rucꞌ waꞌ cujiquibaꞌ uwach ri Utzilaj Tzij. Amén. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Uqꞌuiyal ticawex quitzꞌibam chi puwi saꞌ tak ri uꞌanom ri Dios chikaxoꞌl riꞌoj, ri nabe kacojom rubiꞌ ri Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Quitzꞌibam cꞌu ri cꞌutum lo chike cuma ri raj chac ri Dios, ri xebilow chi utz ri xuꞌan ri Kanimajawal Jesucristo chwi xujek lo ruchac. Yey e rique ri xquitzijoj ri Utzilaj Tzij puwi Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Riꞌin mismo lic xinwetaꞌmaj na chi utz y nuchꞌobom lo rakan puwi ronoje saꞌ tak ri xuꞌano chwi lo rucꞌunic ri Kanimajawal che ruwachulew. Yey chinuwach riꞌin, lic utz quintzꞌiban pan cheꞌla Teófilo y cantzijoj rusucꞌ waꞌ cheꞌla chucholaꞌj ");
INSERT INTO acrTNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chaꞌ quetaꞌmaj la chi utz puwi ri Kꞌijsak cꞌutum chiwach la. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Echiriꞌ ri Herodes catakan puwi ri luwar re Judea, cꞌo jun aj chacunel pa Rocho Dios, Zacarías rubiꞌ. Rire e cuqꞌuil raj Abías. Ri rixokil Elizabet e cuqꞌuil ri ralcꞌoꞌal can ri Aarón. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri Zacarías y ri Elizabet junam lic e jusucꞌ chwach ri Dios, yey lic queboc il che ronoje Rutzij Upixab ri Dios Kajawxel y na jinta junok catzꞌakaw mac chiquij. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero rique na jinta juna calcꞌoꞌal, ma ri Elizabet na utz taj calanic yey quicabichal e nimak winak chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xopon cꞌu rukꞌijol echiriꞌ ri Zacarías cucꞌ ri rachbiꞌil e aj Abías queꞌquilokꞌoj ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ecꞌu raj chacunel pa Rocho Dios caquiꞌan jun sorteo chaꞌ caquichaꞌo china chique coc chupa ri Luwar Santo pa ri Rocho Dios re cuꞌporoj incienso. Jecꞌulaꞌ xquiꞌan wa sorteo, y waꞌ xtzak puwi ri Zacarías. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Echiriꞌ xopon ruꞌorayil re caporox ri incienso, conoje ri ecꞌo chwach ri Luwar Santo quetajin che uꞌanic orar. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ecꞌuchiriꞌ, jun ángel re ri Dios Kajawxel xwinakir chwach ri Zacarías puwiquikꞌab ri altar pa caporox wi ri incienso. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Echiriꞌ ri Zacarías xril ri ángel, xcam ranimaꞌ che y lic xuxiꞌij rib. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Noꞌj ri ángel xubiꞌij che: —Zacarías, maxiꞌij awib, ma ri Dios utom chi ri atzꞌonom che. Rucꞌ cꞌu rawixokil cacꞌojiꞌ jun acꞌajol yey Juan rubiꞌ cacojo. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Cacꞌojiꞌ cꞌu quiꞌcotemal awucꞌ y lic e qꞌui ri quequiꞌcot che ri ralaxibal racꞌajol, ");
INSERT INTO acrTNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ma rire cuꞌana lic nim ukꞌij chwach ri Dios. Na cuchinaꞌaj ta vino y na cuchinaꞌaj ta yaꞌ re kꞌabaric; y e ne chiriꞌ cꞌa matzem, rucꞌaꞌam chi lo ruchukꞌab ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y ruma cꞌu Rire, lic e qꞌui chique ri e aj Israel quetzelej jumul chic rucꞌ ri Dios Kajawxel y caquiya tanchi quib pukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ecꞌu wa Juan canabej lo chwach ri Kanimajawal rucꞌ ruchukꞌab ri Ruxlabixel ri Dios jelaꞌ pachaꞌ ri kꞌalajisanel Elías re ojertan. Yey ri chac coluꞌanaꞌ e cucoj utzil chomal chiquixoꞌl ri ticawex cucꞌ ri calcꞌoꞌal y cujalcꞌatij ri quinaꞌoj ri na e ta cojol tzij chaꞌ cuꞌana pachaꞌ ri quinaꞌoj ri quebin jusucꞌ. Jecꞌuriꞌlaꞌ rire quebuyijbaꞌ ri tinamit chaꞌ caquicꞌul chi utz ri Kanimajawal —xcha ri ángel. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ri Zacarías xutzꞌonoj cꞌu che: —¿Suꞌanic cacubiꞌ nucꞌuꞌx che waꞌ? Ma riꞌin lic in nimalaj winak chic yey jenelaꞌ ri wixokil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ri ángel xucꞌul uwach, jewaꞌ xubiꞌij che: —Riꞌin in Gabriel, intakom lo ruma ri Dios Kajawxel chaꞌ quinoꞌlchꞌaꞌt awucꞌ y coꞌlnuyaꞌa wa utzilaj tzij chawe. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Noꞌj woꞌora catcanaj canok at meꞌt, y na utz ta cꞌu riꞌ catchꞌawic, ma na xacoj ta ri ximbiꞌij chawe. Copon na cꞌu ri kꞌij echiriꞌ calax racꞌajol; cꞌa ecꞌuchiriꞌ, utz catchꞌaw tanchic —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ecꞌu ri e cꞌo pan chwach ri Luwar Santo coyeꞌem jampalaꞌ quel lo ri Zacarías, yey lic xubisoj quicꞌuꞌx ma lic xmayin chupa ri Luwar Santo pa ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Echiriꞌ xel lo ri Zacarías, na utz ta cachꞌaw chique; xa cuꞌan chi cꞌutubal rucꞌ rukꞌab chique ma xcanaj can meꞌt. Y jelaꞌ xquimaj usucꞌ cꞌo xcꞌut chwach ri Zacarías chupa ri Luwar Santo. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Echiriꞌ ri Zacarías xuqꞌuis tak rukꞌijol cachacun chupa ri Rocho Dios, xeꞌec chirocho. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Cꞌa tecꞌuchiriꞌ, ri rixokil Elizabet xcanajic yewaꞌ ixok. Woꞌob icꞌ cꞌu riꞌ xuchajij rib chirocho, e riꞌ na xel tubi. Yey xaki jewaꞌ ri cuchꞌobo: ");
INSERT INTO acrTNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«E ri Nukaw Dios ꞌanayom waꞌ chwe ma xinjuchꞌ caꞌn che y xresaj ri chꞌamibal we.» ");
INSERT INTO acrTNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Icꞌowinak chi cꞌu wakib icꞌ riꞌ echiriꞌ ri ángel Gabriel xtak lo ruma ri Dios chupa jun tinamit Nazaret rubiꞌ, pa ri luwar re Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xtak lo rucꞌ jun kꞌapoj ali María rubiꞌ, yey rire lic jusucꞌ rubinic chwach ri Dios. Ri María unimam chic cacꞌuliꞌ rucꞌ jun ala José rubiꞌ, yey rire e jun chique ri ralcꞌoꞌal can ri rey David. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ecꞌuchiriꞌ, xoc bi ri ángel pa cꞌo wi ri María, y jewaꞌ ri rutzil uwach xuyaꞌo: —¡Chatquiꞌcotok! E riꞌat lic nim akꞌij awalaxic chiquixoꞌl conoje rixokib. Ma ri Dios Kajawxel cꞌo awucꞌ yey acꞌulum ri unimal rutzil ucꞌuꞌx Rire —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ri María echiriꞌ xuta waꞌ wa chꞌaꞌtem, xsach unaꞌoj puwiꞌ y jewaꞌ xutzꞌonoj chiribil rib: “¿Saꞌ queꞌelawi wa cabiꞌx chwe?” ");
INSERT INTO acrTNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ecꞌuchiriꞌ, ri ángel jewaꞌ xubiꞌij che: —María, maxiꞌij awib, ma arikom ri unimal rutzil ucꞌuꞌx ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ecꞌu woꞌora catcanajic at yewaꞌ ixok, calax jun awalab y Jesús rubiꞌ cacojo. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rire lic nim ukꞌij y cabiꞌx che e Ucꞌajol ri Jun catakan chwi ronoje. Ecꞌu ri Dios Kajawxel cuya pukꞌab cuꞌan rey jelaꞌ pachaꞌ ri rey David, rumam re ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Y cayaꞌtaj che catakan puwi ri tinamit Israel yey rutakanic na jinta utakexic —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ecꞌu ri María xutzꞌonoj che ri ángel: —¿Suꞌanic cuꞌana riꞌ waꞌ, we riꞌin cꞌa jinta ne wachijil? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ri ángel xucꞌul uwach: —E ri Santowilaj Ruxlabixel ri Dios cakaj lo pawiꞌ y ruchukꞌab ri Jun catakan chwi ronoje, cuchꞌuk awiꞌ pachaꞌ sutzꞌ. E uwariꞌche racꞌa calaxic cabiꞌx che e Santowilaj Ucꞌajol ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y chatape waꞌ, jenelaꞌ rawatz-achakꞌ Elizabet umatzem chi jun acꞌa tob lic nimalaj winak chic. E ri cabiꞌx che na utz taj calanic, woꞌora yewaꞌ ixok y e uwakib icꞌ waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ma chwach ri Dios na jinta cꞌana cꞌayew —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ecꞌuchiriꞌ, xubiꞌij ri María: —Riꞌin pukꞌab ri Nukaw Dios in cꞌo wi. Ecꞌu Rire chuꞌana wucꞌ janipa ri xbiꞌij la chwe —xchaꞌ. Ecꞌuchiriꞌ, ri ángel xel bi chwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Cꞌo cꞌu jun kꞌij ri María xuyac bi rib y lic canic xumaj bi ube chujuyub chupa jun tinamit re Judea. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Echiriꞌ xoponic, xoc chirocho ri Zacarías y xuya rutzil uwach ri Elizabet. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Xew cꞌu xuta ri Elizabet ri rutzil uwach xyaꞌ ruma ri María, racꞌa umatzem lic xuyiquij rib y ri Santowilaj Ruxlabixel ri Dios xkaj puwi ri Elizabet. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ruma cꞌu riꞌ, lic co xchꞌawic, jewaꞌ xubiꞌij: —Nim akꞌij awalaxic riꞌat chiquixoꞌlibal conoje rixokib y nim ukꞌij rawalab amatzem. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chaꞌtaj yaꞌtajinak can waꞌ chwe riꞌin coꞌlbina ruchu ri Kanimajawal wucꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma xew xinta ri rutzil nuwach xayaꞌo, na jampatana racꞌa numatzem lic xuyiquij rib ruma ruquiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nim akꞌij awalaxic riꞌat ma xacoj ronoje janipa ri xbiꞌx chawe ruma ri Dios Kajawxel yey waꞌ lic e cuꞌanaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ecꞌuchiriꞌ, ri María xubiꞌij: «Riꞌin lic canyac ukꞌij ri Dios Kajawxel, ");
INSERT INTO acrTNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","y ri wanimaꞌ lic caquiꞌcot rucꞌ ri Dios Nucolobenel; ");
INSERT INTO acrTNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ma xinjuchꞌ caꞌn che, tob in jun raj chac na jinta co nuwach. Chwi cꞌu riꞌ woꞌora conoje ri ticawex caquibiꞌij na chwe: “Lic nim akꞌij awalaxic riꞌat” ");
INSERT INTO acrTNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ma e ruchukꞌab ri Dios Kajawxel lic saꞌch tak ri utz uꞌanom wucꞌ. Ecꞌu rubiꞌ Rire lic nim ukꞌij Santo. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Y cucꞌut na ri rutzil ucꞌuꞌx chique janipa ri cꞌo xiꞌin ib pa canimaꞌ chwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Rire e ꞌanayom uqꞌuiyal chac rucꞌ ruchukꞌab. Usachisam ri quinaꞌoj ri caquiꞌan nim che quib, ");
INSERT INTO acrTNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","y resam ri takanic paquikꞌab ri e nimak takanelab; yey uyacom quikꞌij ri lic na jinta co quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chique ri quenumic, uyaꞌom quibeyomalil; noꞌj ri beyomab xebutak bi y na jinta cꞌo xuya bi chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ebutoꞌom cꞌu rutinamit Israel, tak ri raj chac Rire; yey na umescꞌutam ta ucꞌutic ri rutzil ucꞌuꞌx ");
INSERT INTO acrTNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","na jinta utakexic che ri Abraham y chique conoje ri ralcꞌoꞌal canok, jelaꞌ pachaꞌ rubiꞌtisim chique ri katiꞌ-kamam ojertan» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María laj oxib icꞌ xcanaj can chirocho ri Elizabet. Cꞌa tecꞌuchiriꞌ, xtzelej lo chirocho. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ecꞌuchiriꞌ xopon rukꞌij ri Elizabet re cutzir uwach, xalax ri ralab. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y echiriꞌ ri ejekel lo chunakaj rire y tak ri cꞌo chux che xquito xutzir uwach ruma runimal rutzil ucꞌuꞌx ri Dios cꞌutum lo che, lic xequiꞌcot junam rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Echiriꞌ racꞌa xuqꞌuis wajxakib kꞌij ralaxic, xecꞌun lo ri quecojow ri retalil re circuncisión chaꞌ caquiꞌan waꞌ che. Yey rubiꞌ xcaj caquicojo e Zacarías, jelaꞌ pachaꞌ rubiꞌ rukaw. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Noꞌj ruchu xubiꞌij chique: —Na cacoj ta Zacarías che, ma Juan rubiꞌ cacojic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xquibiꞌij cꞌu che: —¿Suꞌbe riꞌ? Ma na jinta junok chiquixoꞌl ri atz-chakꞌ la jelaꞌ rubiꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ecꞌuchiriꞌ, rucꞌ ri quikꞌab xquitzꞌonoj pan che rukaw racꞌa saꞌ ri biꞌaj caraj rire cacoj che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ecꞌu rukaw racꞌa xutzꞌonoj juperaj tzꞌalam re tzꞌibanic y jewaꞌ xutzꞌibaj chwach: «Juan rubiꞌ cacojic.» Y conoje lic xcam canimaꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Cꞌa ecꞌuchiriꞌ, ri Zacarías xjakataj ruchꞌawibal y jelaꞌ utz xchꞌaw tanchic. Y xujek cꞌu riꞌ cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y conoje ri ticawex catajin waꞌ pa quijolom rucꞌ xiꞌin ib, y xeꞌec cꞌu utzijoxic waꞌ chique conoje ri e cꞌo pa tak ri juyub re Judea. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yey janipa cꞌu ri xetaw re rutzijoxic, xquicꞌol waꞌ pa canimaꞌ y caquichꞌob cꞌu rakan: «¿Saꞌ nawi ruwach wa ralco ala echiriꞌ canimaric?» quechaꞌ. Jewaꞌ xquibiꞌij ma lic kꞌalaj ri Dios ukꞌalajisam ruchukꞌab puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ecꞌuchiriꞌ, ri Zacarías rukaw ri ralco ala xujek cakꞌalajisanic ma ri Santowilaj Ruxlabixel ri Dios xkaj lo puwiꞌ; jecꞌuwaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Lic nim ukꞌij ri Dios Kajawxel re Israel ma xcꞌun kucꞌ re cojoꞌlucolobej ri oj utinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xutak lo jun Kacolobenel lic cꞌo uchukꞌab yey Rire elinak lo chiquixoꞌl ri ralcꞌoꞌal can ri David, ri raj chac ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ma ojertan e ubiꞌim lo waꞌ cuma ri kꞌalajisanelab e jusucꞌ chwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ubiꞌim cojoꞌlucolobej paquikꞌab ri tzel quebilow ke y paquikꞌab ri quechꞌamin keꞌoj ");
INSERT INTO acrTNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","chaꞌ cucꞌut ri rutzil ucꞌuꞌx chique ri katiꞌ-kamam y na cumescꞌutaj ta ri santowilaj utzij uꞌanom lo ojertan ");
INSERT INTO acrTNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","puwi ri biꞌtisinic xuꞌan che ri kakaw Abraham. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ubiꞌtisim cojoꞌlresaj paquikꞌab ri tzel quebilow ke chaꞌ jelaꞌ na rucꞌ ta xiꞌin ib cakalokꞌnimaj ");
INSERT INTO acrTNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ronoje kꞌij che ri kacꞌaslem rucꞌ jun santowilaj kabinic kasilabic y jusucꞌ kacꞌojiꞌic chwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ecꞌu riꞌat nucꞌajol, cabiꞌx chawe at kꞌalajisanel re ri Jun catakan chwi ronoje; ma catnabej bi chwach ri Kanimajawal re cabiꞌij chique ri winak caquiyijbaꞌ ri quibinic quisilabic chwa rucꞌunibal Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Y catnabej bi chwach chaꞌ ri katinamit caquetaꞌmaj ri Dios quebucolobej ma cucuy ri quimac. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ecꞌu ri ka Dios, ruma ri unimal rutzil ucꞌuꞌx, cutak lo ri Jun kucꞌ re chilaꞌ chicaj, waꞌ e pachaꞌ ri Kꞌijsak re rusakribal ");
INSERT INTO acrTNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chaꞌ quebuya pa kꞌijsak ri e cꞌo pa kꞌekuꞌm y e cꞌo chuxeꞌ ri camic, yey cucꞌam kawach chupa ri be re ri utzil chomal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y rucꞌajol ri Zacarías catajin unimaric y catajin ucꞌojiꞌic uchukꞌab chwach ri Dios. Xjekiꞌ cꞌu pa tak luwar catzꞌintzꞌotic, xopon na rukꞌijol echiriꞌ xucꞌut uwach chiquiwach ri tinamit Israel. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chupa tak laꞌ la kꞌij, ri Augusto ri nimalaj takanel re Roma, xtakan che caꞌan jun ajilanic chique conoje ri ticawex re tak ri tinamit pa catakan wi rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","E nabe ajilanic xtakan che uꞌanic, yey xꞌaniꞌ waꞌ echiriꞌ ri Cirenio e aj wach re ri nación Siria. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ruma wa ajilanic, conoje ri ticawex quebec chiquijujunal pa ri quitinamit chaꞌ quebajilaxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E uwariꞌche ri José xel bi chiriꞌ Galilea chupa raldea Nazaret pa jekel wi, y xeꞌec Judea chupa raldea Belén pa xalax wi ri rey David, ma ri José ralcꞌoꞌal can ri David. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ruma cꞌu wa ajilanic, xeꞌec junam rucꞌ ri María, ri yaꞌtal chi che re rixokil. Yey ri María yewaꞌ ixok chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ecꞌuchiriꞌ e cꞌo chi Belén, xopon rukꞌijol cutzir uwach ri María. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ruma cꞌu na xquirik ta luwar pa mesón, xecꞌojiꞌ pa jun luwar re quiwarabal chicop. Xalax cꞌu riꞌ ri nabe ralab ri María. Rire xupis racꞌa chi utz pa cꞌul y xucotzꞌobaꞌ pa jun canawa re quiwaꞌbal chicop. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chunakaj Belén e cꞌo aj chajal bexex caquicꞌowibej rakꞌab pa juyub re quequichajij ri quibexex. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yey xakicꞌateꞌt xwinakir jun ángel re ri Dios Kajawxel chiquiwach. Ewi runimal uchomalil ri Dios xutzij quiwiꞌ y rique lic xquixiꞌij quib che. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xubiꞌij chique: «Mixiꞌij iwib, ma nucꞌamom lo utzilaj tzij chiwe re unimal quiꞌcotemal chique conoje rutinamit ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma wakꞌij pa ri tinamit re ri rey David, xalax jun Colobenel iwe; e ri Kanimajawal, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri cꞌutubal re waꞌ e quirik ri ralco acꞌa pistal pa cꞌul, cotzꞌol chupa jun canawa re quiwaꞌbal chicop» xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ecꞌu laꞌ la jokꞌotaj uqꞌuiyal ángeles re chilaꞌ chicaj xakicꞌateꞌt xewinakir rucꞌ ri jun ángel, e riꞌ caquibixoj rubiꞌ ri Dios, jewaꞌ caquibiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«¡Nim ukꞌij ri Dios cꞌo chilaꞌ chicaj! Yey che ruwachulew, cꞌola ri utzil chomal re ri Dios cucꞌ ri caquicꞌul ri rutzil ucꞌuꞌx Rire» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ecꞌuchiriꞌ xetzelej ri ángeles chilaꞌ chicaj, raj chajal bexex jewaꞌ xquibiꞌij chiquiwach: «Joꞌ riꞌ cꞌa chilaꞌ Belén. Jeꞌkila wa xoluꞌbiꞌij ri Dios Kajawxel chike» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lic cꞌu quebanic xebec y xeꞌquirika ri María, ri José yey ri ralco acꞌa cotzꞌol chupa ri canawa re quiwaꞌbal chicop. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yey echiriꞌ xquil uwach ri ralco acꞌa, xquitzijoj ri xubiꞌij ri ángel chique chwi Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y conoje ri xetaw re waꞌ, lic xcam canimaꞌ che ri caquitzijoj raj chajal bexex. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Noꞌj ri María lic ucꞌolom ronoje waꞌ pa ranimaꞌ y lic cuchꞌob rakan puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tecꞌuchiriꞌ, raj chajal bexex xetzelejic, quebixonic y caquiyac ukꞌij ri Dios ruma ronoje ri xquilo y xquito, ma e xuꞌano pachaꞌ ri biꞌim bi chique ruma ri ángel. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Echiriꞌ xuqꞌuis wajxakib kꞌij ralaxic ri ralco acꞌa, xcoj ri retalil re circuncisión che. Y Jesús rubiꞌ xcojic, ma echiriꞌ cꞌamajaꞌ ne camatzexic, ri ángel xubiꞌij e biꞌaj waꞌ cacoj che. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xopon cꞌu ri kꞌij echiriꞌ chirajawaxic ri José y ri María quebec Jerusalem ruma ri quijoskꞌiquil chwach ri Dios, jelaꞌ pachaꞌ ri cꞌo chupa ri takanic re ri Moisés. Xquicꞌam cꞌu bi ri ralco acꞌa Jerusalem chaꞌ caquiya pukꞌab ri Dios Kajawxel. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Xquiꞌan waꞌ ma jewaꞌ tzꞌibital chupa Rutzij Upixab ri Dios Kajawxel: «Conoje ri raltak co alabo quebalax nabe, queyaꞌ pukꞌab ri Dios Kajawxel» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xebec cꞌu riꞌ chaꞌ queꞌquiyaꞌa ri quikasaꞌn pachaꞌ ri cubiꞌij chupa Rutzij Upixab ri Dios Kajawxel: «Jucꞌulaj xmucur o jucꞌulaj raltak co palomax» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chiriꞌ Jerusalem cꞌo jun achi Simeón rubiꞌ. Rire lic jusucꞌ rubinic usilabic, lic cucuxtaj ri Dios y royeꞌem ri colobetajic re ri tinamit Israel. Ri Santowilaj Ruxlabixel ri Dios cꞌo rucꞌ ");
INSERT INTO acrTNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","y ukꞌalajisam chi che, na cacam tana we na caril tubi uwach Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ecꞌu waꞌchi xunaꞌ pa ranimaꞌ ruma ri Ruxlabixel ri Dios queꞌec pa ri Rocho Dios, y xeꞌec cꞌut. Ecꞌuchiriꞌ, ruchu-ukaw ri ralco acꞌa Jesús xquicꞌam lo pa ri Rocho Dios chaꞌ caquiꞌan rucꞌ pachaꞌ ri cubiꞌij ri takanic re ri Tzij Pixab. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ewi ri Simeón xukꞌaluj ri ralco acꞌa y xuyac ukꞌij ri Dios, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Lal Dios Kajawxel, riꞌin xa in jun aj chac la. Ecꞌu woꞌora utz quincam chi utzil chomal, ma xꞌan la janipa ri biꞌtisim la chwe; ");
INSERT INTO acrTNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ya xinwil uwach ri Colobenel, ");
INSERT INTO acrTNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri yaꞌom la chiquiwach conoje tak ri tinamit che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Y Rire e Kꞌijsak cukꞌalajisaj ri be re ri Dios chique conoje tak ruqꞌuiyal quiwach ri ticawex che ruwachulew, yey ruma Rire cayac ukꞌij ri tinamit la Israel» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ruchu-ukaw ri Jesús lic cacam canimaꞌ che tak ri cabiꞌx chwi ri ralco acꞌa. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ecꞌuchiriꞌ, ri Simeón xebuꞌan bendecir. Yey jewaꞌ xubiꞌij che ri María ruchu ri Jesús: —¡Chatapeꞌ! Ruma wa ralco acꞌa lic e qꞌui chique ri tinamit Israel queyactajic yey lic e qꞌui ri quetzakic. Ma Rire yaꞌtal lo ruma ri Dios re jun cꞌutubal; noꞌj uqꞌuiyal ticawex na caquicꞌul taj y lic tzel caquilo. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Y jecꞌulaꞌ cakꞌalajinic saꞌ ri cꞌo pa canimaꞌ uqꞌuiyal ticawex, we utz o na utz taj. Yey cambiꞌij cꞌu chawe riꞌat: Copon na jun kꞌij echiriꞌ lic cꞌax cunaꞌ acꞌuꞌx, ma e cuꞌana pachaꞌ quicꞌowisax juna cuchilo pa rawanimaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiriꞌ cꞌu riꞌ cꞌo jun ixok kꞌalajisanel Ana rubiꞌ, umiꞌal ri Fanuel, ri ralcꞌoꞌal can ri Aser. Rire lic nimalaj winak chic. Wukub junab cꞌuliꞌnak echiriꞌ xcam ri rachijil, ");
INSERT INTO acrTNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yey ya e ochenta y cuatro junab riꞌ malcaꞌn canok. Rire xaki cꞌo pa ri Rocho Dios y culokꞌnimaj ri Dios rucꞌ ayuno y rucꞌ oración chipakꞌij chichakꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xopon cꞌu pan riꞌ ri Ana pa cꞌo wi ri Jesús y xtioxin chwach ri Dios. Ecꞌuchiriꞌ, xujeko cachꞌaꞌt puwi ri ralco acꞌa chique conoje ri coyeꞌem ri colobetajic re Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Echiriꞌ ruchu-ukaw ri Jesús xquiqꞌuis uꞌanic ronoje ri tzꞌibital chupa Rutzij Upixab ri Dios, xetzelej tanchi Galilea chupa ri tinamit Nazaret. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ralco acꞌa catajin uqꞌuiyic, catajin ucꞌojiꞌic uchukꞌab y catajin ucꞌojiꞌic unaꞌoj. Yey ri unimal rutzil ucꞌuꞌx ri Dios cꞌo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ronoje junab ruchu-ukaw ri Jesús quebec Jerusalem re queꞌquiꞌana ri nimakꞌij Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Echiriꞌ ri Jesús xuqꞌuis cablajuj junab, ruchu-ukaw xebec Jerusalem jelaꞌ pachaꞌ xex caquiꞌan wi, yey xquicꞌam bi ri Jesús cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ecꞌuchiriꞌ xqꞌuis ri nimakꞌij, ruchu-ukaw xquimaj lo quibe. Noꞌj ri Jesús xcanaj can Jerusalem, yey waꞌ na xquinaꞌbej ta ruchu-ukaw. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E pa quinaꞌoj rique petinak ri Jesús chiquixoꞌl ri e cachbiꞌil. Xebin cꞌu jun kꞌij; cꞌa tecꞌuchiriꞌ, xquijek caquitzucuj ri Jesús chiquixoꞌl ri catz-quichakꞌ y tak ri quetaꞌam quiwach, ");
INSERT INTO acrTNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero na xquirik taj. Ruma cꞌu riꞌ, xetzelej pa ri tinamit Jerusalem chaꞌ quequitzucuj chilaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ecꞌuchiriꞌ icꞌowinak chi oxib kꞌij caquitzucuj, xeꞌquirika ri Jesús chupa ri Rocho Dios tzꞌul chiquixoꞌl doctorab re ri tzijpixab. Rire quebutataꞌ y cuꞌan tzꞌonobal chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y conoje ri quetaw re lic cacam canimaꞌ che runaꞌoj y che ri cꞌulubal uwach cuꞌan chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Echiriꞌ xquil waꞌ ruchu-ukaw, lic xcam canimaꞌ che y jewaꞌ xubiꞌij ruchu che: —Walab, ¿suꞌchac jewaꞌ caꞌan chike? Rakaw y riꞌin lic paxinak chi kacꞌuꞌx che atzucuxic —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ecꞌu ri Jesús xubiꞌij chique: —¿Suꞌchac quintzucuj alak? ¿Na etaꞌam ta neba alak pa quinrikitaj wi? Ma lic chirajawaxic quincꞌojiꞌ che ri chac re ri Nukaw —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Noꞌj rique na xquimaj tane usucꞌ ri xubiꞌij chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tecꞌuchiriꞌ, ri Jesús xtzelej Nazaret junam cucꞌ ruchu-ukaw y e riꞌ lic uyaꞌom rib chitakic cuma rique. Ecꞌu ruchu catajin chucꞌuꞌx tak waꞌ y lic ucꞌolom ronoje pa ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y ri Jesús catajin unimaric y catajin ucꞌojiꞌic más runaꞌoj ri Dios rucꞌ. Ronoje ri cuꞌano lic utz chwach ri Dios y chiquiwach conoje ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chupa ri woꞌlajuj junab re rutakanic ri nimalaj takanel Tiberio, ri aj wach re Judea e ri Poncio Pilato, ri aj wach re Galilea e ri Herodes, ri aj wach re Iturea y re Traconite e ri Felipe ruchakꞌ ri Herodes, y ri aj wach re Abilinia e ri Lisanias. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ecꞌu ri Anás y ri Caifás e cajawal raj chacunel pa Rocho Dios. Chupa tak cꞌu riꞌ laꞌ la kꞌij, ri Dios xuya rutzij che ri Juan rucꞌajol ri Zacarías, chupa ri luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rire xel bi y xeꞌec che ronoje tak ri luwar e cꞌo chuchiꞌ ri nimayaꞌ Jordán re cubiꞌij chique ri winak caquitzelej quitzij chwach ri Dios, caquicꞌul ri bautismo, y jecꞌulaꞌ cacuytaj ri quimac. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wa xuꞌan ri Juan e ri tzꞌibital can chupa ruchꞌaꞌtem ri kꞌalajisanel Isaías, pa cubiꞌij wi: Catataj ukul jun tzijonel casiqꞌuin chupa ri luwar catzꞌintzꞌotic, jewaꞌ cubiꞌij: “Yijbaꞌ pana alak ri be re ri Kanimajawal; sucꞌupij alak rube Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chirajawaxic cꞌut capakꞌ ronoje juyub y cabalix upa ronoje siwan; casucꞌupix ri nimabe na jusucꞌ taj y casucꞌupix cꞌu uwiꞌ chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y conoje cꞌu ri winak caquil na ri colobetajic cuya ri Dios” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Uqꞌuiyal cꞌu winak xecꞌun rucꞌ ri Juan chaꞌ caquicꞌul ri bautismo cuya rire. Ecꞌu rire jewaꞌ xubiꞌij chique: —¡Ralak pachaꞌ alak jupuk chi cumatz! ¿China xbiꞌn re we utz quesaj ib alak chwach ri unimal cꞌaxcꞌobic cutak lo ri Dios pawiꞌ alak? ");
INSERT INTO acrTNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bina alak jusucꞌ chaꞌ jelaꞌ cakꞌalajinic jalcꞌatim chi ri binic silabic alak, jelaꞌ pachaꞌ ri takal chique ri quitzelem chi quitzij. Y machꞌob ne alak chi ibil ib alak waꞌ: “Riꞌoj utz kaꞌanom ma oj ralcꞌoꞌal can ri Abraham.” Ma riꞌin cambiꞌij che alak, we xraj ri Dios, utz cuꞌan ralcꞌoꞌal ri Abraham tob ne che tak waꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yey jiquil chi ne uwach rukꞌatbal tzij ri Dios pawiꞌ alak, e pachaꞌ juna achi uyacom chi ri icaj chwi ri ratzꞌayak ri cheꞌ; ecꞌu tak ri cheꞌ na cuya ta chomilaj jikꞌobal, capokꞌix bi y cacꞌak pa akꞌ —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ecꞌu ri winak jewaꞌ xquitzꞌonoj che: —¿Saꞌ cꞌu riꞌ ri cakaꞌano chaꞌ cuꞌan chom ri kabinic kasilabic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y rire xucꞌul uwach chique: —China ri cꞌo caꞌib ukꞌuꞌ, chusipaj jun che ri na jinta ukꞌuꞌ; y china ri lic cꞌo catij rucꞌ, chuyaꞌa que ri na jinta cꞌo caquitijo —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ecꞌu raj tzꞌonol puak re tojonic xebopon rucꞌ ri Juan chaꞌ caquicꞌul ri bautismo y jewaꞌ xquitzꞌonoj che: —Lal tijonel, ¿saꞌ ri chirajawaxic cakaꞌan riꞌoj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y rire jewaꞌ xubiꞌij chique: —Xew chitzꞌonoj ri puak re tojonic biꞌtal ruma ri takanel romano; mitzꞌonoj uwiꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ecꞌu ri soldados xquitzꞌonoj che, jewaꞌ xquibiꞌij: —Yey riꞌoj, ¿saꞌ ri chirajawaxic cakaꞌano? —xechaꞌ. Ewi jewaꞌ xubiꞌij chique: —Mimaj ubitak re junok y miꞌan ri quixibij upa junok rucꞌ camic. Micoj umac ri na jinta umac y chixquiꞌcota rucꞌ riwajil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Tak ri winak lic coyeꞌem rucꞌunibal ri Cristo y conoje caquitzꞌonobej chiquibil quib we ri Juan e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ruma cꞌu waꞌ, ri Juan jewaꞌ xubiꞌij chique: —Riꞌin pakatzij wi canya ri bautismo che alak rucꞌ yaꞌ; noꞌj cꞌo Jun catajin lok más cꞌo uwach y más cꞌo uchukꞌab chinuwa riꞌin. Na takal tane chwe riꞌin canquir ruwach ruxajab. Ri bautismo cuya Rire che alak, e rucꞌ ri Santowilaj Ruxlabixel ri Dios y rucꞌ akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ri cuꞌano e pachaꞌ juna achi rucꞌaꞌam chi ri puꞌbal uwach ri trigo pukꞌab chaꞌ naꞌl cujoskꞌij waꞌ y caresaj rupucꞌ chupa. Tecꞌuchiriꞌ, cujoc ri trigo y cucꞌol chupa rucꞌolibal. Ecꞌu rupucꞌ cuporoj pa ri jun akꞌ na jinta utakexic catenowic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jecꞌulaꞌ, rucꞌ uqꞌuiyal pixabanic ri Juan cutzijoj ri Utzilaj Tzij chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Y xuchꞌaꞌbej ne upa ri rey Herodes ruma uꞌanom rixokil che ri Herodías yey waꞌ wiꞌxok e rixokil ri Felipe ruchakꞌ ri Herodes. Xuchꞌaꞌbej cꞌu upa ruma tak ronoje ri na utz taj uꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yey ri Herodes xuya ne más uwiꞌ ri na utz taj uꞌanom, ma xtakan che cayaꞌ ri Juan pa cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Cꞌo cꞌu jun kꞌij echiriꞌ lic uqꞌuiyal ticawex caquicꞌul ri bautismo, xopon ri Jesús y xucꞌul ri bautismo. Echiriꞌ catajin che uꞌanic orar, xjakataj ruwa caj ");
INSERT INTO acrTNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y ri Santowilaj Ruxlabixel ri Dios xkaj lo puwiꞌ pachaꞌ juna palomax. Y xchꞌaw lo Jun chilaꞌ chicaj, jewaꞌ cubiꞌij: «At riꞌat Nucꞌajol, y lic cꞌax catinnaꞌo. Lic quinquiꞌcot chawe» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ri Jesús laj treinta rujunab echiriꞌ xujek ri chac takom lo che uꞌanic ruma ri Dios. Cabiꞌx che ri Jesús, e ucꞌajol ri José. Yey ri José, e ralcꞌoꞌal ri Elí. ");
INSERT INTO acrTNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ri Elí e ralcꞌoꞌal ri Matat; ri Matat e ralcꞌoꞌal ri Leví; ri Leví e ralcꞌoꞌal ri Melqui; ri Melqui e ralcꞌoꞌal ri Jana; ri Jana e ralcꞌoꞌal ri José; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ri José e ralcꞌoꞌal ri Matatías; ri Matatías e ralcꞌoꞌal ri Amós; ri Amós e ralcꞌoꞌal ri Nahum; ri Nahum e ralcꞌoꞌal ri Esli; ri Esli e ralcꞌoꞌal ri Nagai; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ri Nagai e ralcꞌoꞌal ri Maat; ri Maat e ralcꞌoꞌal ri Matatías; ri Matatías e ralcꞌoꞌal ri Semei; ri Semei e ralcꞌoꞌal ri José; ri José e ralcꞌoꞌal ri Judá; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ri Judá e ralcꞌoꞌal ri Joana; ri Joana e ralcꞌoꞌal ri Resa; ri Resa e ralcꞌoꞌal ri Zorobabel; ri Zorobabel e ralcꞌoꞌal ri Salatiel; ri Salatiel e ralcꞌoꞌal ri Neri; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ri Neri e ralcꞌoꞌal ri Melqui; ri Melqui e ralcꞌoꞌal ri Adi; ri Adi e ralcꞌoꞌal ri Cosam; ri Cosam e ralcꞌoꞌal ri Elmodam; ri Elmodam e ralcꞌoꞌal ri Er; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ri Er e ralcꞌoꞌal ri Josué; ri Josué e ralcꞌoꞌal ri Eliezer; ri Eliezer e ralcꞌoꞌal ri Jorim; ri Jorim e ralcꞌoꞌal ri Matat; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ri Matat e ralcꞌoꞌal ri Leví; ri Leví e ralcꞌoꞌal ri Simeón; ri Simeón e ralcꞌoꞌal ri Judá; ri Judá e ralcꞌoꞌal ri José; ri José e ralcꞌoꞌal ri Jonán; ri Jonán e ralcꞌoꞌal ri Eliaquim; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ri Eliaquim e ralcꞌoꞌal ri Melea; ri Melea e ralcꞌoꞌal ri Mainán; ri Mainán e ralcꞌoꞌal ri Matata; ri Matata e ralcꞌoꞌal ri Natán; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ri Natán e ralcꞌoꞌal ri David; ri David e ralcꞌoꞌal ri Isaí; ri Isaí e ralcꞌoꞌal ri Obed; ri Obed e ralcꞌoꞌal ri Booz; ri Booz e ralcꞌoꞌal ri Salmón; ri Salmón e ralcꞌoꞌal ri Naasón; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ri Naasón e ralcꞌoꞌal ri Aminadab; ri Aminadab e ralcꞌoꞌal ri Aram; ri Aram e ralcꞌoꞌal ri Esrom; ri Esrom e ralcꞌoꞌal ri Fares; ri Fares e ralcꞌoꞌal ri Judá; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ri Judá e ralcꞌoꞌal ri Jacob; ri Jacob e ralcꞌoꞌal ri Isaac; ri Isaac e ralcꞌoꞌal ri Abraham; ri Abraham e ralcꞌoꞌal ri Taré; ri Taré e ralcꞌoꞌal ri Nacor; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ri Nacor e ralcꞌoꞌal ri Serug; ri Serug e ralcꞌoꞌal ri Ragau; ri Ragau e ralcꞌoꞌal ri Peleg; ri Peleg e ralcꞌoꞌal ri Heber; ri Heber e ralcꞌoꞌal ri Sala; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ri Sala e ralcꞌoꞌal ri Cainán; ri Cainán e ralcꞌoꞌal ri Arfaxad; ri Arfaxad e ralcꞌoꞌal ri Sem; ri Sem e ralcꞌoꞌal ri Noé; ri Noé e ralcꞌoꞌal ri Lamec; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ri Lamec e ralcꞌoꞌal ri Matusalén; ri Matusalén e ralcꞌoꞌal ri Enoc; ri Enoc e ralcꞌoꞌal ri Jared; ri Jared e ralcꞌoꞌal ri Mahalaleel; ri Mahalaleel e ralcꞌoꞌal ri Cainán; ");
INSERT INTO acrTNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ri Cainán e ralcꞌoꞌal ri Enós; ri Enós e ralcꞌoꞌal ri Set; ri Set e ralcꞌoꞌal ri Adán; yey ri Adán e ralcꞌoꞌal ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ecꞌu ri Jesús xel bi che ri luwar re ri nimayaꞌ Jordán yey lic cꞌo ri Ruxlabixel ri Dios rucꞌ. Xcꞌam cꞌu bi ruma ri Ruxlabixel ri Dios pa jun luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xcꞌojiꞌ chilaꞌ cuarenta kꞌij y xcꞌam upa ruma ritzel winak. Yey chupa tak waꞌ wa kꞌij na jinta cꞌo xutijo. Chuqꞌuisbal cꞌu re ri cuarenta kꞌij, lic xnumic. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ecꞌuchiriꞌ, ritzel winak jewaꞌ xubiꞌij che: —We katzij at Ucꞌajol ri Dios, chat-takan che chaꞌ waꞌbaj cuꞌan wa —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ri Jesús xucꞌul uwach: —Jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Na xew ta ruma ri wa e cꞌas ri ticawex; ma e cꞌaslic ruma tak ronoje rubiꞌim ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ecꞌuchiriꞌ, ritzel winak xucꞌam bi ri Jesús chutzaꞌm jun nimalaj juyub y xa pa jokꞌotaj xucꞌut cꞌu chwach, ronoje ri takanic caꞌan puwi tak ri tinamit che ruwachulew ");
INSERT INTO acrTNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","y jewaꞌ xubiꞌij che: —Ronoje wa cawilo rucꞌ ronoje ruchomalil tak waꞌ, canya pakꞌab, ma yaꞌtal can panukꞌab riꞌin yey panukꞌab cꞌo wi china che cuaj canya wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Canya cꞌu ronoje waꞌ pakꞌab riꞌat we caxucubaꞌ awib chinuwach y calokꞌnimaj nukꞌij —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ri Jesús xucꞌul uwach: —Chatela chinuwach Satanás, ma jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Lic chalokꞌnimaj ukꞌij ri Dios Kajawxel y xew Rire chanimaj ukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tecꞌuchiriꞌ, ritzel xucꞌam bi ri Jesús chupa ri tinamit Jerusalem cꞌa chicaj che ruwi ri Rocho Dios y jewaꞌ xubiꞌij che: —We katzij at Ucꞌajol ri Dios, chacꞌaka bi awib cꞌa chuꞌlew ");
INSERT INTO acrTNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","yey na jinta cꞌo cacꞌulumaj, ma jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Ri Dios quebutak lo ru ángeles awucꞌ chaꞌ catquichajij. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Catquichap cꞌu rucꞌ ri quikꞌab chaꞌ na caꞌchika ta rawakan che juna abaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ri Jesús xucꞌul uwach: —Jewaꞌ tzꞌibital can chupa Rutzij Upixab ri Dios: Macꞌam upa ri Dios Kajawxel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Echiriꞌ ritzel winak na xurik ta chic suꞌanic cucꞌam upa ri Jesús, xel chiriꞌ y xroyeꞌej na cꞌu riꞌ jampalaꞌ cucꞌam tanchi upa. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ecꞌuchiriꞌ, ri Jesús xeꞌec tanchi Galilea y lic cꞌo ruchukꞌab ri Ruxlabixel ri Dios rucꞌ. Y xeꞌec utzijoxic puwi Rire pa tak tinamit y pa tak raldeas re Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Cacꞌutun cꞌu pa tak sinagogas y conoje ri quetaw re lic caquiyac ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xopon cꞌu ri Jesús chupa ri tinamit Nazaret pa xqꞌuiy wi. Y chupa ri kꞌij re uxlanibal xoc chupa ri sinagoga jelaꞌ pachaꞌ xex cuꞌan wi. Xtaqꞌuiꞌ cꞌu riꞌ chaꞌ carajilaj Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y xyaꞌ che Rire ri jubotaj wuj re ri kꞌalajisanel Isaías. Y echiriꞌ xujak upa, xurik pa cubiꞌij wi: ");
INSERT INTO acrTNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Ruxlabixel ri Dios Kajawxel cꞌo panuwiꞌ, ma inuchaꞌom lok chaꞌ coꞌlnuyaꞌa ri Utzilaj Tzij chique ri nibaꞌib. Inutakom lok chaꞌ cambochiꞌij quicꞌuꞌx ri lic e cꞌo pa bis, coꞌlnutzijoj quelebal lo que ri e cꞌo chi presoyil, quebenutzuꞌnisaj ri e potzꞌ, quebenuwesaj lo pa cꞌax ri lic quitijom cꞌaxcꞌolil, ");
INSERT INTO acrTNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y coꞌlnutzijoj rukꞌijol ri cꞌutubal re ri rutzil ucꞌuꞌx ri Dios Kajawxel. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ecꞌuchiriꞌ xuqꞌuis rajilaxic Rutzij Upixab ri Dios, xuboto y xuya tanchi che ri aj chac re ri sinagoga, y xtzꞌuyiꞌ chiquiwach ri e cꞌo chiriꞌ. Y conoje lic caquitzutzaꞌ pan uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ecꞌuchiriꞌ, xubiꞌij chique: «Waꞌ wa xinwajilaj che Ruchꞌaꞌtem ri Dios, wakꞌij xujek bi rilic chiwach alak» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Conoje ri xetaw re, caquiyac ukꞌij y lic caminak canimaꞌ che ri chomilaj uchꞌaꞌtem, jewaꞌ caquibiꞌij: «¿Na e ta neba ucꞌajol ri José waꞌ?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xubiꞌij chique: «Laj ne cabiꞌij alak chwe: “Cunanel, chacunaj awib chawibil awib. Chaꞌana cꞌu riꞌ chupa wa tinamit tak ri cꞌutubal re ruchukꞌab ri Dios jelaꞌ pachaꞌ ri katom xaꞌan chilaꞌ Capernaúm” cacha alak chwe.» ");
INSERT INTO acrTNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xubiꞌij tanchi waꞌ: «Pakatzij wi cambiꞌij che alak: Na jinta juna kꞌalajisanel cacꞌul chi utz chupa rutinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Pakatzij wi cambiꞌij che alak: Rojertan lic e qꞌui rixokib e malcaꞌnib e cꞌo chupa ri tinamit Israel chwach ri kꞌalajisanel Elías echiriꞌ na xuꞌan ta jab oxib junab rucꞌ nicꞌaj y xpe cꞌu ri jun unimal numic chupa ronoje wa tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na rucꞌ ta cꞌu riꞌ, ri Dios na xutak tubi ri Elías rucꞌ junok chique wa malcaꞌnib aj Israel; ma e xutak bi rucꞌ jun ixok malcaꞌn aj Sarepta, jun tinamit cꞌo chunakaj ri tinamit Sidón. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yey ojertan lic e qꞌui ri cꞌo ri yabil lepra chique echiriꞌ ri kꞌalajisanel Eliseo cꞌo chupa ri tinamit Israel. Na rucꞌ ta cꞌu riꞌ, na jinta junok chique xcunutajic, ma xew xcunutaj ri Naamán, ri jun aj Siria» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Echiriꞌ xquita waꞌ, conoje ri e cꞌo chupa ri sinagoga lic xpe coyowal. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xeyactaj cꞌut y xquesaj lo ri Jesús pa ri tinamit y xquicꞌam bi cꞌa chutzaꞌm jun nimalaj juyub chaꞌ caquicꞌak bi pa siwan. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Noꞌj ri Jesús xa xicꞌow chiquixoꞌl y xeꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ri Jesús xopon chupa ri tinamit Capernaúm re Galilea y xujek cacꞌutun chiquiwach ri winak chupa tak ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y conoje lic cacam canimaꞌ che, ma ruma rucꞌutunic cakꞌalajinic lic cꞌo uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Cꞌo cꞌu chiriꞌ chupa ri sinagoga jun achi cꞌo pukꞌab jun itzelilaj uxlabixel, yey waꞌ lic co xchꞌawic, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, lal aj Nazaret, ¿suꞌchac coꞌlmina ib la kucꞌ? ¿Lal cami petinak riꞌ re coꞌlsacha la kawach? Riꞌin wetaꞌam lal chinok, rilal lal ri Santo Cꞌajolaxel re ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ecꞌu ri Jesús xukꞌatej, jewaꞌ xubiꞌij che: —¡Matchꞌaꞌt chic! Chatelubi che laꞌchi —xchaꞌ. Ewi ri itzel uxlabixel xucꞌak rachi pulew chiquixoꞌl ri winak y xel bi rucꞌ. Yey na jinta cꞌax xuꞌan can che. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y conoje ri winak lic cacam canimaꞌ che y jewaꞌ caquibiꞌij chiquiwach: «¿Saꞌ chi chꞌaꞌtemal waꞌ? Ma lic cꞌo pukꞌab quebutak bi ri itzelilaj uxlabixel. Quebutak bi rucꞌ ruchukꞌab y quebel bi» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Che ronoje tak ri luwar cꞌo lo xa nakaj, xeꞌec utzijoxic janipa tak ri cuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ecꞌuchiriꞌ xel bi ri Jesús chupa ri sinagoga, xopon chirocho ri Simón. Y ruchu-ujiꞌ ri Simón lic cakopow pa akꞌ. Xquitzꞌonoj cꞌu che ri Jesús chaꞌ cucunaj canok. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ecꞌu ri Jesús xyuxiꞌ puwiꞌ, xukꞌatej ri akꞌ chirij y jelaꞌ xicꞌow ri akꞌ chirij. Na jampatana xyactaj rixok y xujeko quebunimaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chutzakibal kꞌij conoje ri cꞌo quiyewaꞌ ruma uqꞌuiyal uwach yabil xequicꞌam lo rucꞌ ri Jesús. Rire xuya rukꞌab paquiwiꞌ chiquijujunal y xebucunaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jenelaꞌ xebel bi itzelilaj uxlabixel chique uqꞌuiyal winak. Echiriꞌ quebel bi, quesiqꞌuinic, jewaꞌ caquibiꞌij: «¡Rilal lal Rucꞌajol ri Dios!» quechaꞌ. Noꞌj ri Jesús xebukꞌatej y na xuya ta luwar chique quechꞌawic, ma rique quetaꞌam chic Rire e Uchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Echiriꞌ xsakiric, ri Jesús xel bi chupa ri tinamit y xeꞌec chupa jun luwar catzꞌintzꞌotic. Y ri winak xeꞌquitzucuj. Ecꞌuchiriꞌ xebopon cꞌa pa la cꞌo wi, xcaj caquikꞌatej chaꞌ na quebuya ta canok. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noꞌj Rire jewaꞌ xubiꞌij chique: «Lic chirajawaxic quinꞌec pa tak tinamit re cantzijoj ri Utzilaj Tzij re rutakanic ri Dios chique ri ticawex cꞌamajaꞌ caquita waꞌ, ma ruma waꞌ intakom lok» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Xeꞌec cꞌu che utzijoxic ri Utzilaj Tzij pa tak ri sinagogas re Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Cꞌo jun kꞌij ri Jesús cꞌo chuchiꞌ ri mar re Genesaret, yey uqꞌuiyal winak xeboponic lic caquiminimaꞌ quib rucꞌ che utayic Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ri Jesús xril pan caꞌib barco cꞌo chuchiꞌ ri yaꞌ; ecꞌu raj chapal car ebelinak lo chupa che uchꞌajic tak ri qui atarraya. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ecꞌuchiriꞌ, ri Jesús xoc chupa jun chique ri caꞌib barco. Y ri rajaw waꞌ e ri Simón. Xubiꞌij cꞌu ri Jesús che ri Simón cumin bi cꞌana ri barco chupa ri yaꞌ. Ecꞌu ri Jesús xtzꞌuyiꞌ chupa y xujek cacꞌutun chique ruqꞌuiyal ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Echiriꞌ xuqꞌuis rucꞌutunic, jewaꞌ xubiꞌij che ri Simón: —Woꞌora chacꞌama bi ri barco chupa ri mar pa lic cho wi y chiliqꞌuij tak cꞌu ri atarraya chiriꞌ chaꞌ jelaꞌ quebichap car —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ri Simón xucꞌul uwach: —Lal tijonel, ronoje rakꞌab xojchacunic y na jinta car xkachapo. Noꞌj we rilal quintak la, canꞌan riꞌ —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Echiriꞌ xquiliqꞌuij bi ri atarraya, xequichap uqꞌuiyal car y ri atarraya xujeko carakarobic. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ecꞌuchiriꞌ, xquiꞌan pan quikꞌab chique ri cachbiꞌil e cꞌo chupa ri jun chic barco chaꞌ quepetic y queboꞌlquitoꞌoꞌ. Echiriꞌ xebopon ri cachbiꞌil, junam xquibalij lo ri queb barco che car y ruma laꞌ ya laj quemukutajic. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ri Simón Pedro echiriꞌ xril waꞌ, xuxuc rib chwach ri Jesús y jewaꞌ xubiꞌij che: —Chel co la wucꞌ, Wajawal. Na takal ta chwe cꞌo la wucꞌ ma in jun achi aj mac —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Xubiꞌij waꞌ ri Pedro ma ruma ruqꞌuiyal car xequichapo, lic xoc xiꞌin ib rucꞌ junam cucꞌ conoje ri e cꞌo rucꞌ pa ri barco; ");
INSERT INTO acrTNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","jecꞌulaꞌ xoc xiꞌin ib cucꞌ ri Jacobo y ri Juan; rique e ucꞌajol ri Zebedeo y e rachbiꞌil ri Simón. Pero ri Jesús xubiꞌij che ri Simón: —Maxiꞌij awib; chwi woꞌora catuꞌan at aj molol ticawex pachaꞌ aꞌanom lo chique ri car —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ecꞌuchiriꞌ xquesaj lo ri barcos chupa ri mar, xquiya can ronoje waꞌ y xeterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ri Jesús cꞌo chupa jun tinamit re Galilea echiriꞌ xopon jun achi rucꞌ, yey waꞌchi lic catajin ukꞌayic rucuerpo ruma ri yabil lepra. Rire echiriꞌ xril uwach ri Jesús, xuxuc rib chwach, xukasaj rupalaj chuꞌlew y xutzꞌonoj che: —Wajawal, we caꞌaj co la, joskꞌij la ri nucuerpo che wa yabil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ecꞌuchiriꞌ, ri Jesús xuchap pana rucꞌ rukꞌab y jecꞌuwaꞌ xubiꞌij che: —Cuaj, chuꞌana ba chom riꞌ racuerpo —xchaꞌ. Xew cꞌu xuqꞌuis ubiꞌxiquil waꞌ, na jampatana xsach ri yabil cꞌo che rachi. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ecꞌu ri Jesús xutak che na cutzijoj ta waꞌ che junok. Xubiꞌij cꞌu che: —Jat chwach raj chacunel pa Rocho Dios chaꞌ rire carilo na jinta chi lepra chawe. Y ruma rajoskꞌiquil, chayaꞌa cꞌu chwach ri Dios ri kasaꞌn xtakan can ri Moisés che, chaꞌ cakꞌalajin chiquiwach ri ticawex at cunutajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na rucꞌ ta cꞌu riꞌ, e ruma tak ri cuꞌan ri Jesús, rutzijoxic Rire catajin más retaꞌmaxic cuma ri winak y lic cꞌu e qꞌui caquimol quib chaꞌ caquita ri cubiꞌij y quecunutaj bi che ri quiyabil. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Noꞌj ri Jesús quel bi, queꞌec pa tak luwar catzꞌintzꞌotic re cuꞌana orar. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","E xuꞌan waꞌ jun kꞌij echiriꞌ ri Jesús cacꞌutun chiquiwach ri winak. Etzꞌul cꞌu chiriꞌ ri fariseos y raj cꞌutunel re ri tzijpixab; rique e petinak Jerusalem y pa tak ri tinamit y raldeas re Galilea y re Judea. Yey ruchukꞌab ri Dios Kajawxel cꞌo rucꞌ ri Jesús chaꞌ cacunanic. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y xecꞌun cꞌu lo jujun achijab quitelem lo jun achi sic chwa chꞌat. Xcaj cꞌu caquicoj bi pa ja chaꞌ caquiya chwach ri Jesús, ");
INSERT INTO acrTNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero na xquirik taj saꞌ rucojic bi cuma ruqꞌuiyal winak. E uwariꞌche xebakꞌan chwi ri ja, xquesaj julepaj che ruwiꞌ, xquikasaj cꞌu lo ri sic e laꞌ cotzꞌol chwa ruchꞌat y xquiya chwach ri Jesús chiquinicꞌajal ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Echiriꞌ ri Jesús xril ri cubulibal quicꞌuꞌx rucꞌ, jewaꞌ xubiꞌij che ri sic: —Achi, ronoje ramac cuytajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ecꞌuchiriꞌ, raj cꞌutunel re ri tzijpixab y ri fariseos xquijek caquichꞌob rakan: «¿Saꞌ ruwach waꞌchi? Rire camacun chirij ri Dios echiriꞌ cubiꞌij cucuy mac. Ma ¿na xew ta neba ri Dios aj cuyul mac?» ");
INSERT INTO acrTNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ecꞌu ri Jesús xunaꞌbej saꞌ ri caquichꞌobo; ruma cꞌu riꞌ, xubiꞌij chique: —¿Suꞌchac jelaꞌ catajin chicꞌuꞌx alak? ");
INSERT INTO acrTNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Saꞌ cꞌu ri na cꞌayew taj cambiꞌij: “Ronoje ramac cuytajinak chic” o “Chatyactajok y chatbinok”? ");
INSERT INTO acrTNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","E cuaj cꞌut quetaꞌmaj alak waꞌ: Ralaxel Chiquixoꞌl Ticawex yaꞌtal pukꞌab cucuy tak ri mac que ri winak che ruwachulew —xchaꞌ. Xubiꞌij cꞌu riꞌ che ri sic: —Chatyactajok, chacꞌama bi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chupa cꞌu laꞌ la jokꞌotaj xyactaj ri sic chiquiwach. Xucꞌam cꞌu bi ruchꞌat pa ri cotzꞌol wi y xeꞌec chirocho, e riꞌ lic cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Conoje cꞌu riꞌ lic xcam canimaꞌ che y xquijek caquiyac ukꞌij ri Dios. Y ruma ri xiꞌin ib cꞌo pa canimaꞌ chwach ri Dios, xquibiꞌij: «Wakꞌij kilom ruchukꞌab ri Dios» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chuqꞌuisbal re waꞌ, xeꞌec ri Jesús y xril jun achi aj tzꞌonol puak re tojonic, Leví rubiꞌ, tzꞌul pa ri luwar pa caꞌan wi ri tojonic che ri gobierno. Y ri Jesús xubiꞌij che: —Chat-terej lo chwij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ri Leví xyactajic, xuya can ronoje y xterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ewi chirocho xuꞌan jun nimakꞌij che ri Jesús. Y lic e qꞌui ri rach e aj tzꞌonol puak re tojonic y uqꞌuiyal winak etzꞌul chwa ri mexa cucꞌ ri Jesús y rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ecꞌuchiriꞌ, raj cꞌutunel re ri tzijpixab cucꞌ ri fariseos xequichꞌaꞌtibej rutijoꞌn ri Jesús, y jewaꞌ xquibiꞌij chique: —¿Suꞌchac quixwaꞌ cucꞌ raj tzꞌonol puak re tojonic y cucꞌ raj maquib? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ecꞌu ri Jesús xucꞌul uwach: —E janipa ri utz quiwach, na cajawax ta aj cunanel chique; ma waꞌ xew chique ri e yewaꞌib cajawax wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jelaꞌ cꞌu riꞌ, riꞌin na in petinak ta che quisiqꞌuixic ri jusucꞌ quibinic quisilabic, ma e in petinak che quisiqꞌuixic raj maquib chaꞌ caquijalcꞌatij ri quibinic quisilabic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ecꞌuchiriꞌ, xquitzꞌonoj che ri Jesús: —¿Suꞌbe rutijoꞌn ri Juan Aj Yaꞌl Bautismo caquiꞌan ayuno uqꞌuiyal laj y lic caquiꞌan orar jelaꞌ pachaꞌ cakaꞌan ri oj fariseos, noꞌj ri tijoꞌn rilal xew quewaꞌic y na caquiꞌan tane ayuno? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y Rire xucꞌul uwach: —¿Utz neba caquiꞌan ayuno ri esiqꞌuim pa cꞌulaniquil we cꞌa cꞌo rala cacꞌuliꞌic chiquixoꞌl? Na utz taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Noꞌj copon na ri kꞌij echiriꞌ quesax bi rala chiquixoꞌl; cꞌa ecꞌuchiriꞌ, caquiꞌan ayuno —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tecꞌuchiriꞌ, xutzijoj jun cꞌambal naꞌoj chique, jewaꞌ xubiꞌij: «Na jinta junok cukꞌat chꞌakap che rukꞌuꞌ cꞌasak chaꞌ cucꞌojoj rukꞌuꞌ kꞌeꞌl rucꞌ. Ma we ta jelaꞌ cuꞌano, riꞌ na utz ta chi rukꞌuꞌ cꞌasak yey ne ri cꞌasak na cucꞌulaj ta rib rucꞌ rukꞌuꞌ kꞌeꞌl. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","»Jecꞌulaꞌ ri vino cꞌacꞌ ꞌanom na cakꞌej ta chupa juna surun kꞌeꞌl. Ma we caꞌaniꞌ waꞌ, ri vino cꞌacꞌ echiriꞌ canajtir ukꞌij, curakij ri surun, catix cꞌu riꞌ ri vino y ri surun na jinta chi uchac. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ruma cꞌu laꞌ, ri vino cꞌacꞌ ꞌanom chirajawaxic wi cakꞌej chupa juna surun cꞌasak chaꞌ ucabichal waꞌ cacowinic. ");
INSERT INTO acrTNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yey junok ucꞌamom rib che cutij ri vino naj chi ukꞌij, na caraj taj cutij ri cꞌacꞌ vino, ma cubiꞌij: “Ri vino naj chi ukꞌij e más utz chwa ri cꞌacꞌ vino”» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","E xuꞌan waꞌ chupa jun kꞌij re uxlanibal: Ri Jesús cucꞌ rutijoꞌn catajin quicꞌowic pa tak ticoꞌn re trigo, yey rutijoꞌn caquichꞌupilaꞌ bi ri trigo, caquikil rucꞌ ri quikꞌab y caquitijo. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ecꞌuchiriꞌ, jujun chique ri fariseos xquitzꞌonoj chique: —¿Suꞌbe quiꞌan riꞌix ri na takal taj caꞌaniꞌ chupa ri kꞌij re uxlanibal? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ecꞌu ri Jesús xucꞌul uwach: —¿Na ajilam ta neba alak ri xuꞌan ri David echiriꞌ rire cucꞌ ri rachbiꞌil xenumic? ");
INSERT INTO acrTNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xoc cꞌu chupa ri Rocho Dios y xucꞌam ri pam yaꞌtal chi pukꞌab ri Dios. Xutijo y xujach chique ri rachbiꞌil; yey waꞌ na takal ta chique caquitijo, ma xew takal chique raj chacunel pa ri Rocho Dios caquitijo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y xuqꞌuisbej cucꞌ, jewaꞌ xubiꞌij: —Ralaxel Chiquixoꞌl Ticawex e ne rajaw ri kꞌij re uxlanibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","E xuꞌan waꞌ chupa jun chic kꞌij re uxlanibal: Ri Jesús xoc chupa jun sinagoga y xujeko cacꞌutunic. Chiriꞌ cꞌu riꞌ cꞌo jun achi chakijinak rukꞌab uwiquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yey raj cꞌutunel re ri tzijpixab y ri fariseos lic quicꞌacꞌalem we ri Jesús cucunaj waꞌchi chupa wa kꞌij re uxlanibal, chaꞌ jelaꞌ caquicoj umac. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Noꞌj ri Jesús retaꞌam saꞌ ri caquichꞌobo y xubiꞌij cꞌu che rachi chakijinak rukꞌab: —Chatyactajok y chatcꞌola chikawach konoje —xchaꞌ. Ewi rachi xyactajic y xtaqꞌuiꞌ chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique: —Canꞌan jun tzꞌonobal che alak. ¿Saꞌ ri lic usucꞌ caꞌaniꞌ chupa ri kꞌij re uxlanibal: E caꞌaniꞌ ri utz, o e ri na utz taj? ¿Utz cacolobex rucꞌaslem junok o cayaꞌ luwar che cacamic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ecꞌuchiriꞌ, ri Jesús xutzuꞌ quiwach conoje ri e cꞌo chiriꞌ, y xubiꞌij che rachi: —Chasucꞌupij rakꞌab —xchaꞌ. Rachi e xuꞌano, y rukꞌab xutziric. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ecꞌu ri fariseos y ri aj cꞌutunel re ri tzijpixab lic xpe coyowal y xquijek caquichꞌaꞌtibej chiquiwach saꞌ ri caquiꞌan che ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Cꞌo jun kꞌij ri Jesús xeꞌec chwa juyub chaꞌ cuꞌana orar. Xicꞌow cꞌu jun akꞌab cachꞌaꞌt rucꞌ ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Echiriꞌ xsakiric, xebusiqꞌuij rutijoꞌn y chique waꞌ xebuchaꞌ cablajuj, y xubiꞌij rique e “takoꞌn”. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","E quibiꞌ waꞌ: Simón ri xcoj Pedro che y ruchakꞌ Andrés, Jacobo y Juan, Felipe, Bartolomé, ");
INSERT INTO acrTNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo rucꞌajol ri Alfeo, Simón ri cabiꞌx che “ri Zelote”, ");
INSERT INTO acrTNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas rucꞌajol ri Jacobo, y Judas aj Iscariot, ri xcꞌayin re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tecꞌuchiriꞌ, ri Jesús cucꞌ rutijoꞌn xekaj lo chwa ri juyub y xecꞌojiꞌ pa jun takꞌaj cucꞌ uqꞌuiyal winak re ronoje tak ri luwar re Judea, re Jerusalem yey re Tiro y re Sidón, queb tinamit e cꞌo chuchiꞌ ri mar. Rique e petinak chaꞌ caquita ri cꞌutunic re ri Jesús y chaꞌ quecunutaj bi che ri quiyabil. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yey janipa ri quitijom cꞌax cuma ri itzelilaj uxlabixel, quecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ruma cꞌu ri quiyabil, conoje ri winak cacaj caquichap ri Jesús, ma Rire rucꞌ ruchukꞌab quebucunaj conoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ecꞌuchiriꞌ, ri Jesús xutzuꞌ quiwach rutijoꞌn y xubiꞌij chique: «Nim ikꞌij iwalaxic tob ix nibaꞌ, ma ix cuqꞌuil ri e cꞌo pukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nim ikꞌij iwalaxic tob woꞌora quitij numic, ma copon na ri kꞌij echiriꞌ quixcubiꞌ chi utz ma ri Dios cuya ronoje ri cajawax chiwe. Nim ikꞌij iwalaxic tob woꞌora quixokꞌic, ma copon na ri kꞌij echiriꞌ canoj ri iwanimaꞌ che quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nim ikꞌij iwalaxic echiriꞌ lic tzel quixil cuma ri winak, quixquesaj bi chiquixoꞌl, caquicꞌak bi ukꞌij ribiꞌ, caquibiꞌij chiwe lic itzel iwachlibal ruma ix utijoꞌn Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","»Echiriꞌ caꞌan waꞌ chiwe, lic chixquiꞌcotok y chixbixonok, ma lic nim ri rajil ucꞌaxel quicꞌul chilaꞌ chicaj. Macam cꞌu iwanimaꞌ che echiriꞌ quixyaꞌ pa cꞌax; ma e tak ri queꞌanaw waꞌ chiwe, e caquiꞌano pachaꞌ ri quiꞌanom lo ri catiꞌ-quimam ojertan chique ri e kꞌalajisanelab re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Tokꞌoꞌ cꞌu wach ralak alak beyomab, ma cꞌulum chi alak ri cuya quiꞌcotemal che alak, noꞌj moyeꞌej chi cꞌu alak we cꞌa cacꞌul alak waꞌ chikawach apanok. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Tokꞌoꞌ wach alak ri lic cꞌo catij alak woꞌora, ma chikawach apanok catij alak numic. Tokꞌoꞌ wach alak ri lic caquiꞌcot alak woꞌora, ma chikawach apanok cacꞌojiꞌ alak pa bis. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Tokꞌoꞌ wach alak echiriꞌ lic cayac kꞌij alak, ma ojertan jelaꞌ xquiꞌan ri chuꞌkaw alak, e xquiyac quikꞌij ri kꞌalajisanelab xa e socosoꞌnel. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","»Woꞌora cambiꞌij chiwe riꞌix ri quixtaw we: Cꞌax chebinaꞌa ri e aj retzelal cꞌuꞌx chiwij. Chiꞌana ri utz chique ri tzel quebilow iwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chitzꞌonoj ri rutzil ucꞌuꞌx ri Dios paquiwi ri caquitzꞌonoj ri na utz taj piwi riꞌix. Chiꞌana cꞌu orar paquiwi ri tzel quechꞌaꞌt chiwij. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y we cꞌo junok cupachꞌ kꞌab xeꞌ aweꞌ, chayaꞌa luwar che cupachꞌ ri jun chic xe aweꞌ. Y we cꞌo junok cumaj rakꞌuꞌ re pisbal awij, chayaꞌa ne luwar che cucꞌam bi racoton. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chatsipan che ri nibaꞌ we cutzꞌonoj toꞌbal chawe. Y we cꞌo junok cumaj rubitak awe, matzꞌonoj tanchi che. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ecꞌu riꞌix chiꞌana chique ri ticawex jelaꞌ pachaꞌ ri quiwaj caquiꞌan rique chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","»Ma we xew cꞌax quebinaꞌ ri cꞌax quenaꞌw iwe, michꞌob rakan takal chiwe cayac ikꞌij ruma waꞌ; ma jenelaꞌ caquiꞌan tak ri winak aj maquib; rique xew cꞌax quequinaꞌ ri cꞌax quenaꞌw que. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y we xew quiꞌan ri utz chique ri caquiꞌan ri utz chiwe, michꞌob rakan we takal chiwe cayac ikꞌij ruma waꞌ; ma jenelaꞌ caquiꞌan tak ri winak aj maquib. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yey we xew quiya chakꞌiꞌm chique ri iwetaꞌam chic quicꞌul na ri chikꞌimbal re chique, michꞌob rakan we takal chiwe cayac ikꞌij ruma waꞌ; ma jenelaꞌ caquiꞌan tak ri winak aj maquib; xew quechikꞌiman chique ri caquiya chikꞌimbal re chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","»Noꞌj riꞌix, cꞌax chebinaꞌa ri tzel quebilow iwe y chiꞌana ri utz chique. Chiyaꞌa chakꞌiꞌm na jinta cꞌo quiwoyꞌej chwach. We quiꞌan waꞌ, lic nim ri sipanic quicꞌul chilaꞌ chicaj; yey ecꞌuchiriꞌ, pakatzij wi quixuꞌan ix ralcꞌoꞌal ri Jun catakan chwi ronoje, ma jelaꞌ cuꞌan Rire, cucꞌut ri rutzil ucꞌuꞌx chique ri itzel quicꞌuꞌx, ri na quetioxin ta chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Cꞌola cꞌu riꞌ ri cꞌaxnaꞌbal cꞌuꞌxaj iwucꞌ jelaꞌ pachaꞌ ri Kakaw Dios lic cꞌo cꞌaxnaꞌbal ucꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","»Miꞌan ri xa piwe riꞌix quixuꞌan aj kꞌatal tzij paquiwi jujun chic, y jelaꞌ na cakꞌat ta cꞌu tzij piwi riꞌix. Miꞌan ri cꞌax quixchꞌaw chiquij jujun chic, y jelaꞌ na caꞌan ta waꞌ chiwe riꞌix. We cꞌo junok camacun chiwij, chicuyu umac y jelaꞌ cacuytaj imac riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chixsipanok y jelaꞌ ri Dios casipan chiwe rucꞌ jun pajbal lic nim, lic tzanal upa y capulputic; ma rucꞌ ri pajbal quixpajan wi riꞌix, rucꞌ tanchi wa pajbal caꞌan pajanic chiwe» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y xubiꞌij jun cꞌambal naꞌoj chique: «¿Utz neba juna potzꞌ cucꞌam uwach jun chic potzꞌ? ¿Na quebeꞌtzak ta nawi quicabichal pa siwan? ");
INSERT INTO acrTNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Juna tijoꞌn na retaꞌam ta más chwa ri retaꞌam rutijonel. Yey we lic qꞌui ri cumajo, riꞌ e cuꞌana pachaꞌ rutijonel. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","»¿Suꞌchac e lic catzutzaꞌ rucꞌaj cheꞌ cꞌo chupa ruwach rawatz-achakꞌ yey e na catoc ta il che resaxic ri cheꞌ kꞌebel chupa rawach riꞌat? ");
INSERT INTO acrTNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y we na catoc ta cꞌu il che ri cheꞌ kꞌebel chupa rawach riꞌat, ¿utz nawi cabiꞌij che rawatz-achakꞌ: “Watz-nuchakꞌ, chayaꞌa luwar chwe canwesaj la jun ucꞌaj cheꞌ cꞌo chupa rawach”? ¡Na utz taj! ¡Xa queb apalaj! Nabe na chawesaj lo la cheꞌ kꞌebel chupa rawach riꞌat, y jelaꞌ cat-tzuꞌn chi utz chaꞌ catoꞌ rawatz-achakꞌ che resaxic lo rucꞌaj cheꞌ cꞌo chupa ruwach rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","»Jinta juna chomilaj cheꞌ cuya ujikꞌobalil na chom taj, yey juna cheꞌ na chom taj, na cuya ta ujikꞌobalil chom. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma ronoje cheꞌ etaꞌmatal uwach ruma rujikꞌobalil. Na camol ta higos che tak ri xuluquej y na camol ta uvas che tak ri xucuyeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","»Jecꞌulaꞌ e junok utz ucꞌuꞌx, echiriꞌ cachꞌaꞌtic, e quel lo ri utz ucꞌolom chupa ri ranimaꞌ. Yey e junok itzel ucꞌuꞌx, echiriꞌ cachꞌaꞌtic, e quel lo ri na utz taj ucꞌolom chupa ri ranimaꞌ. Ma rucꞌ ruchꞌaꞌtem ri ticawex, cakꞌalajinic saꞌ ri cꞌo chupa ri ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","»¿Suꞌchac quibiꞌij chwe “Kajawal, Kajawal”, yey na quiꞌan ta ri cambiꞌij chiwe? ");
INSERT INTO acrTNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Cambiꞌij cꞌu chiwe china rucꞌ cajunimax wi ri jun cape wucꞌ, cuta ri nutzij y cuꞌan janipa ri cambiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","»Waꞌ e canjunimaj rucꞌ jun achi xuyac jun rocho. Xucꞌot ri jul y lic naj xukasaj y xutzꞌak cꞌu lo ruparakan ri ja chwi abaj. Y echiriꞌ xpe lo jab, lic xnimar ri nimayaꞌ y rutzaꞌm ri yaꞌ lic xuroj rib che ri ja; yey ri ja xuchꞌij uchukꞌab, ma chwi abaj tzꞌakom lo wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Noꞌj ri jun xuta ri nutzij y na xuꞌan ta janipa ri cambiꞌij, e canjunimaj rucꞌ jun achi xuꞌan ri rocho pa sanyeb y na xucoj ta lo ucowil ruparakan ri ja. Y echiriꞌ lic xnimar ri nimayaꞌ, rutzaꞌm yaꞌ lic xuroj rib che ri ja. Ecꞌu riꞌ ri ja xwuluwub bi y xsach uwach» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ri Jesús echiriꞌ xuqꞌuis cacꞌutun chiquiwach ri ticawex, xeꞌec Capernaúm. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chiriꞌ jekel jun capitán aj Roma y cꞌo jun raj chac lic yewaꞌ yey cajecꞌowic. Ecꞌu ri capitán lic cꞌax cunaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ecꞌuchiriꞌ xuto saꞌ tak ri cabiꞌx puwi ri Jesús, xebutak bi jujun nimak winak e aj wach que raj judiꞌab chaꞌ quebeꞌelaj che capetic y coluꞌcunaj ri raj chac. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ecꞌuchiriꞌ ri nimak winak xebopon rucꞌ ri Jesús, lic xebelaj che, jewaꞌ xquibiꞌij: —Kajawal, wa jun capitán lic takal che catoꞌ la, ");
INSERT INTO acrTNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ma lic cꞌax cunaꞌ ri katinamit y xojutoꞌ ne che uyaquic ri kasinagoga —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ecꞌu ri Jesús xeꞌec cucꞌ. Ecꞌuchiriꞌ xebopon chunakaj ri ja, ri capitán xebutak lo jujun ramigos rucꞌ ri Jesús chaꞌ jewaꞌ caquibiꞌij che: «Wajawal, macosisaj ib la che cape la, ma na takal ta chwe coc la chiwocho; ");
INSERT INTO acrTNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ruma laꞌ xinchꞌobo na takal tane chwe quinopon chiwach la. Xew biꞌij la: “Chatcunutajok”, y rucꞌ ri chꞌaꞌtem la, cacunutaj ri waj chac. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma e pachaꞌ riꞌin, in cꞌo pukꞌab jun takanel y rire ebuyaꞌom uqꞌuiyal soldados panukꞌab. We cambiꞌij cꞌu che junok: “Jat”, queꞌec; o cambiꞌij che junok chic: “Chatpetok”, capetic. Yey we cambiꞌij che juna waj chac: “E chaꞌana waꞌ”, cuꞌano.» ");
INSERT INTO acrTNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Echiriꞌ ri Jesús xuta ri xubiꞌij lo ri capitán, lic xcam ranimaꞌ che. Xutzuꞌ cꞌu pan quiwach ri winak eteran chirij y jewaꞌ xubiꞌij chique: —Cambiꞌij chiwe, na nurikom tane chiquixoꞌl raj Israel junok lic cꞌo unimal cubulibal ucꞌuꞌx pachaꞌ wa jun achi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ecꞌuchiriꞌ ri etakom bi xetzelej chirocho ri capitán, xeꞌquirika ri raj chac cunutajinak chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Icꞌowinak chi waꞌ, ri Jesús xeꞌec pa jun tinamit Naín rubiꞌ. E qꞌui chique rutijoꞌn y uqꞌuiyal winak e rachbiꞌil bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Echiriꞌ xebopon chunakaj ri tinamit, xril jun animaꞌ telem, e riꞌ queꞌmukok. Yey waꞌ e jun ala ralcꞌoꞌal jun ixok malcaꞌn y xew ne co ralab riꞌ. Uqꞌuiyal cꞌu winak re ri tinamit cachbilam rixok. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Echiriꞌ ri Kanimajawal xril rixok, lic xjuchꞌ caꞌn pa ranimaꞌ y xubiꞌij che: —Mokꞌ chi la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ecꞌuchiriꞌ, ri Jesús xkib cucꞌ y xuchap ri chꞌat pa telem wi ri animaꞌ. Ecꞌu ri e teleyom re xetaqꞌuiꞌic. Y ri Jesús xubiꞌij che ri caminak: —Ala, cambiꞌij chawe: ¡Chatyactajok! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ecꞌuchiriꞌ, rala caminak chic xyactajic y xujeko cachꞌaꞌtic. Y ri Jesús xuya bi pukꞌab ruchu. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Echiriꞌ xquil waꞌ ri winak, conoje xcam canimaꞌ che y xquijeko caquiyac ukꞌij ri Dios, caquibiꞌij: —Jun nimalaj kꞌalajisanel xwinakir chikaxoꞌl. Ri Dios cꞌuninak chaꞌ cojutoꞌ ri oj utinamit —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Conoje cꞌu ri e cꞌo Judea y ri e cꞌo lo chunakaj xquetaꞌmaj ri xuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ecꞌu ri Juan xretaꞌmaj ronoje waꞌ, ma rutijoꞌn xquitzijoj che. Ecꞌuchiriꞌ, xebusiqꞌuij caꞌib chique ");
INSERT INTO acrTNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y jewaꞌ xubiꞌij: —Jix rucꞌ ri Jesús y chitzꞌonoj che we Rire e Ruchaꞌoꞌn lo ri Dios, ri Jun biꞌtalic cacꞌunic, o cakoyꞌej chi junok chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ecꞌuchiriꞌ, rutijoꞌn ri Juan xebec rucꞌ ri Jesús y jewaꞌ xquibiꞌij che: —Ri Juan Aj Yaꞌl Bautismo ojutakom lok chaꞌ cakatzꞌonoj cheꞌla we lal Ruchaꞌoꞌn lo ri Dios, ri Jun biꞌtalic cacꞌunic o cakoyꞌej chi junok chic —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chupa cꞌu laꞌ la ora ri Jesús xujek quebucunaj uqꞌuiyal winak che tak yabil y che tak cꞌaxcꞌolil, quebucolobej ri e cꞌo paquikꞌab itzel uxlabixel y quebutzuꞌnisaj uqꞌuiyal potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tecꞌuchiriꞌ, ri Jesús xucꞌul uwach ri tzꞌonobal que rutijoꞌn ri Juan: —Jix y chitzijoj che ri Juan ronoje ri xiwilo y ri xito. Ma ri e potzꞌ quetzuꞌnic, ri e sic quebinic, ri cꞌo yabil lepra chique quecunutajic, ri e tꞌoꞌc quetanic, ri ecaminak quecꞌastajic y chique ri nibaꞌib catzijox ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nim ukꞌij ralaxic cꞌu riꞌ ri na casach ta ucꞌuꞌx wucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Echiriꞌ xebec ri etakom lo ruma ri Juan, ri Jesús xujek cachꞌaꞌt puwi ri Juan chique ri winak, jewaꞌ xubiꞌij: «¿Saꞌ ri xeꞌila alak pa ri luwar catzꞌintzꞌotic? ¿Xeꞌila neba alak jun achi na jinta ucowil xa pachaꞌ tani cajabajoꞌx ruma ri tew? ");
INSERT INTO acrTNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Saꞌ ri xeꞌila alak? ¿Xeꞌila neba alak jun achi uwikom rib rucꞌ chomilaj cꞌul? Na e ta riꞌ, ma etaꞌam alak ri lic quewikikic y cꞌo cucꞌ janipa ri caquirayij, riꞌ pa cocho e aj wach ejekel wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Cantzꞌonoj cꞌu riꞌ: ¿Saꞌ ri xeꞌila alak? ¿Xeꞌila alak jun kꞌalajisanel? Areꞌ, yey pakatzij wi cambiꞌij che alak: E jun más cꞌo uwach chiquiwa ri jujun chic kꞌalajisanelab. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ma jewaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios puwi ri Juan: Riꞌin cannabesaj bi ri waj chac chawach Riꞌat chaꞌ cuyijbaꞌ ri be chwach pan rawoponibal cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Cambiꞌij cꞌu che alak: Chique ri ticawex ebalaxinak wara che ruwachulew, na jinta juna kꞌalajisanel más cꞌo uwach chwa ri Juan Aj Yaꞌl Bautismo. Pero chwi cꞌu riꞌ waꞌ wa queꞌec, china ri coc chupa rutakanic ri Dios, tob na jinta uwach, más nim ukꞌij ralaxic chwa ri Juan» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Echiriꞌ ri winak y ri aj tzꞌonol puak re tojonic xquita waꞌ, xquetaꞌmaj pakatzij wi ri Dios lic jusucꞌ. E uwariꞌche xquitzelej quitzij y xquicꞌul ri bautismo cuya ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Noꞌj ri fariseos y raj cꞌutunel re ri tzijpixab xquicꞌak bi ukꞌij ri rajawal ucꞌuꞌx ri Dios xcꞌut chique, ma na xquitzelej ta quitzij y na xquicꞌul ta ri bautismo cuya ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Je tanchi waꞌ xubiꞌij ri Jesús: «¿China cꞌu rucꞌ canjunimaj wi quiwach ri winak re wakꞌij ora? ¿Saꞌ rucꞌ e junam wi? ");
INSERT INTO acrTNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","E canjunimaj quiwach cucꞌ ri cꞌoꞌmab etzꞌul pa cꞌayibal quesiqꞌuin chiquiwach, caquibiꞌij: “Echiriꞌ riꞌoj xkachꞌawisaj suꞌ chiwe, riꞌix na xiwaj taj quix-xajawic; yey echiriꞌ xkatunaj bix bisobal uwach chiwe, na xiwaj taj quixjuyuyic” —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jecꞌulaꞌ ralak, ma echiriꞌ xcꞌun ri Juan Aj Yaꞌl Bautismo, rire lic cuꞌan ayuno y na cutij tane vino. Yey ralak cabiꞌij alak: “Waꞌ waꞌchi cꞌo pukꞌab jun itzel uxlabixel” cacha alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xcꞌun cꞌu lo Ralaxel Chiquixoꞌl Ticawex. Rire cutij ronoje ri cayaꞌ chwach, yey ralak cabiꞌij alak: “Waꞌ wa jun achi lic japjatel y kꞌabaꞌrel, cachbiꞌil raj tzꞌonol puak re tojonic y raj maquib” cacha alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero cakꞌalajin na cꞌut china tak ri lic cꞌo runaꞌoj ri Dios cucꞌ ruma ri quiꞌanom» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tecꞌuchiriꞌ, xsiqꞌuix ri Jesús ruma jun fariseo Simón rubiꞌ chaꞌ queꞌwoꞌk rucꞌ. Ecꞌu ri Jesús xeꞌec chirocho ri fariseo y xtzꞌuyiꞌ chwa ri mexa. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Cꞌo cꞌu jun ixok aj pa la tinamit na utz ta rubinic usilabic. Echiriꞌ rire xretaꞌmaj cawaꞌ ri Jesús chirocho ri fariseo, xucꞌam bi jun cꞌolibal ꞌanatal rucꞌ alabastro nojinak che cunabal lic quiꞌ ruxlab. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Cokꞌ cꞌu riꞌ xopon xeꞌrakan ri Jesús. Yey rucꞌ ruwaꞌal uwach xujek cuchꞌakabaꞌ ri rakan ri Jesús, y rucꞌ cꞌu ruwiꞌ cuchakisaj; cutzꞌub ri rakan y cusokꞌ ri cunabal lic quiꞌ ruxlab che. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Echiriꞌ xril waꞌ ri fariseo, ri siqꞌuiyom re ri Jesús, xuchꞌobo: «We ta waꞌchi pakatzij wi kꞌalajisanel, cunaꞌbej riꞌ saꞌ rubinic usilabic wiꞌxok cachapaw re, ma waꞌ wiꞌxok lic aj mac.» ");
INSERT INTO acrTNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ecꞌuchiriꞌ, ri Jesús jewaꞌ xubiꞌij che: —Simón, cꞌo cuaj cambiꞌij cheꞌla —xchaꞌ. Ri fariseo xubiꞌij che: —Biꞌij la, Wajawal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Xubiꞌij cꞌu ri Jesús: —Ecꞌo caꞌib achijab cꞌo quicꞌas rucꞌ jun achi cuya puak pa chakꞌiꞌm. Jun chique, ucꞌas woꞌob ciento denarios y ri jun chic, ucꞌas cincuenta denarios. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Quicabichal na caquirik ta chic saꞌ rutojic. Ecꞌu rachi aj yaꞌl chakꞌiꞌm xucuy quimac quicabichal che ri quicꞌas. Woꞌora, Simón, biꞌij la chwe ¿china chique wa caꞌib achijab más catioxin chwach rachi aj yaꞌl chakꞌiꞌm? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xucꞌul uwach: —Chinuwach riꞌin, e ri jun achi ri xcuytaj umac che ri cꞌas más qꞌui —xchaꞌ. Y ri Jesús xubiꞌij che: —Ri xbiꞌij la, lic areꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ecꞌuchiriꞌ, ri Jesús xutzuꞌ uwach rixok y xubiꞌij che ri Simón: —¿Quil la wa jun ixok? Echiriꞌ xinoc lo riꞌin chi ocho la, rilal na xya ta la nuyaꞌ re chꞌajbal ri wakan. Noꞌj wa jun ixok xuchꞌakabaꞌ ri wakan rucꞌ ruwaꞌal uwach y xuchakisaj rucꞌ ruwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yey rilal na xtzꞌub tane la nuchiꞌ; noꞌj rire chwi echiriꞌ xinoc lok, na rokꞌotam ta cutzꞌub ri wakan. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rilal na xsokꞌ tane la aceite chwi nujolom; noꞌj rire xusokꞌ cunabal lic quiꞌ ruxlab che ri wakan. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Cambiꞌij cꞌu cheꞌla: Rire xuꞌan waꞌ ma nucuyum chi ruqꞌuiyal umac; e uwariꞌche lic cucꞌut ri rutzil ucꞌuꞌx chwe. Noꞌj e junok na lic ta qꞌui rumac cuytajinak, riꞌ xa jubikꞌ ri rutzil ucꞌuꞌx cucꞌutu —xcha che ri Simón. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ecꞌuchiriꞌ, xubiꞌij che rixok: —Ixok, ronoje ramac cuytajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ecꞌu ri etzꞌul rucꞌ ri Jesús chwa ri mexa xquijeko caquichꞌaꞌtibej chiquiwach, jewaꞌ caquibiꞌij: «¿Saꞌ nawi ruwach wa jun achi cucuy mac?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero ri Jesús xubiꞌij che rixok: —Ruma ri cubulibal acꞌuꞌx, xatcolobetajic; jat cꞌu chi utzil chomal —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Icꞌowinak chi cꞌu waꞌ, ri Jesús cabin pa tak ronoje tinamit y aldeas cutzijoj ri Utzilaj Tzij re rutakanic ri Dios. E rachbiꞌil cꞌu ri cablajuj utijoꞌn, ");
INSERT INTO acrTNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","cucꞌ jujun ixokib ri eberesam paquikꞌab itzel uxlabixel y ebucunam che uqꞌuiyal yabil. Chiquixoꞌl e cꞌo ri María ri ebelinak wukub itzel uxlabixel che, ");
INSERT INTO acrTNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ri Juana rixokil rachi Chuza ri aj wach re rubitak re ri Rey Herodes, ri Susana cucꞌ jujun chic ixokib caquinimaj ri Jesús rucꞌ tak rubitak que. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Cꞌo jun kꞌij lic e qꞌui ri winak xebel lo pa tak tinamit y xquimol quib rucꞌ ri Jesús. Ecꞌuchiriꞌ, ri Jesús xujek cacꞌutun chiquiwach rucꞌ tak cꞌambal naꞌoj, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Julaj jun awanel xel bi che rawaxic ri rijaꞌ. Ecꞌuchiriꞌ catajin che ujopopexic rijaꞌ, cꞌo xtzak can chuchiꞌ ri be. Y waꞌ xyikꞌ uwiꞌ cuma ri quebicꞌowic y xtij bi cuma tak ri tzꞌiquin. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","»Cꞌo ijaꞌ xtzak can pa tak abaj; yey echiriꞌ xel lok, xchakijic ma na camuꞌmut ta ruxeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","»Cꞌo ijaꞌ xtzak can pa tak qꞌuix. Ecꞌu riꞌ waꞌ xqꞌuiy junam rucꞌ ri qꞌuix, pero xjikꞌ can chuxeꞌ ri qꞌuix. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","»Noꞌj cꞌo xtzak can pa chomilaj ulew. Ecꞌu riꞌ waꞌ, echiriꞌ xqꞌuiyic, lic xuꞌan rekaꞌn; chujujunal rakan xel jun ciento che» xchaꞌ. Tecꞌuchiriꞌ, lic co xchꞌaw ri Jesús, jewaꞌ xubiꞌij: «China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tecꞌuchiriꞌ, rutijoꞌn xquitzꞌonoj che: —¿Saꞌ queꞌelawi wa cꞌambal naꞌoj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ri Jesús xubiꞌij chique: «Chiwe riꞌix yaꞌtalic cakꞌalajisax runaꞌoj ri Dios chwi rutakanic. Noꞌj chique ri winak, cancꞌut xew rucꞌ cꞌambal naꞌoj. Ma tob rique quetzuꞌnic, e junam rucꞌ na quetzuꞌn taj; tob quetanic, e junam rucꞌ na quetan taj y e riꞌ na jinta cꞌo caquimaj usucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","»Woꞌora cankꞌalajisaj chiwe saꞌ queꞌelawi wa cꞌambal naꞌoj. Rijaꞌ e Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","»Ri xtzak can chuchiꞌ ri be, e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios, pero cacꞌun lo ritzel winak y caresaj waꞌ pa canimaꞌ chaꞌ na caquicoj taj y na quecolobetaj ta cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","»Ri xtzak can pa tak abaj, e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios y caquicꞌul rucꞌ quiꞌcotemal; noꞌj na e tiquil ta chi utz. Caquicoj cꞌu Ruchꞌaꞌtem xa queb oxib kꞌij; yey echiriꞌ cacꞌun lo cꞌambal quipa, caquesaj bi quib chirij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","»Ri xtzak can pa tak qꞌuix, e pachaꞌ ri ticawex caquita Ruchꞌaꞌtem ri Dios, yey na caquiꞌan taj saꞌ ri cubiꞌij. Coqꞌuil cꞌu riꞌ casach uwach Ruchꞌaꞌtem ri Dios cꞌo pa canimaꞌ ruma rubis quicꞌuꞌx, ri quibeyomalil y rukusil ruwachulew; y na chom ta cꞌu riꞌ ri quilitaj che ri quibinic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","»Noꞌj ri xtzak can pa chomilaj ulew, e pachaꞌ ri ticawex caquicꞌul pa sakil wi Ruchꞌaꞌtem ri Dios y rucꞌ ronoje quicꞌuꞌx caquicꞌol pa canimaꞌ. Lic chom cꞌu riꞌ ri quilitaj che ri quibinic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","»Na jinta junok cutzij juna akꞌ y cuchꞌuk uwiꞌ rucꞌ juna mulul re pajbal o cujuꞌ chuxeꞌ ruwarabal. Ma ri cuꞌan che, e cuya lo chupa rucꞌolibal chicaj chaꞌ jelaꞌ cutzij quiwiꞌ ri queboc bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ma copon ri kꞌij echiriꞌ janipa ri na kꞌalajisam taj, cakꞌalajisax na; yey janipa ri ewatalic, quetaꞌmaxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","E uwariꞌche chita chi utz janipa ri cambiꞌij chiwe; ma china ri cucꞌul chi utz janipa ri cacꞌut chwach, riꞌ cacꞌut ne más chwach y jecꞌulaꞌ cumaj más. Yey china ri na cucꞌul ta ri cacꞌut chwach, riꞌ camaj ne che janipa ri cuchꞌobo umajom chi usucꞌ» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Julaj echiriꞌ lic e cꞌo uqꞌuiyal winak rucꞌ ri Jesús, ruchu y tak ruchakꞌ xoꞌlquilaꞌ, yey na utz ta cꞌu xekib rucꞌ cuma ruqꞌuiyal winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ecꞌuchiriꞌ, xbiꞌx che ri Jesús: —Ri chu la y tak ri chakꞌ la e cꞌo pa be y cacaj caquil wach la. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Rire xucꞌul uwach: —E ri quetaw re Rutzij Upixab ri Dios y caquiꞌan ronoje ri cubiꞌij, waꞌ e nuchu y e tak nuchakꞌ riꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Cꞌo jun kꞌij ri Jesús xoc chupa jun barco junam cucꞌ rutijoꞌn y xubiꞌij chique: —Joꞌ, chojkꞌax chꞌaka yaꞌ —xcha chique. Y xebec cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Echiriꞌ quebin chwi ri mar, ri Jesús xwaric. Ewi xpe jun nimalaj cakjikꞌ chwi ri mar y xujek canoj ri barco che yaꞌ y e riꞌ ya laj camukutajic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na jampatana cꞌut xeꞌquicꞌosoj ri Jesús, jewaꞌ xquibiꞌij che: —¡Kajawal, Kajawal! ¡Cojcamic! —xecha che. Echiriꞌ xyactaj ri Jesús, xukꞌatej ri cakjikꞌ. Ecꞌu ri yaꞌ quel chicaj, xyeniꞌic y ri tew xtaniꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tecꞌuchiriꞌ, xubiꞌij chique rutijoꞌn: —¿Saꞌ xuꞌan ri cubulibal icꞌuꞌx wucꞌ? —xcha chique. Pero rutijoꞌn lic quixiꞌim quib y caminak canimaꞌ che. Xquibiꞌij cꞌu chiquiwach: «¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tob ne ri cakjikꞌ y ri yaꞌ caquicoj utzij!» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ecꞌuchiriꞌ, xebopon pa ri luwar re Gadara cꞌo chꞌaka yaꞌ che Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Echiriꞌ xkaj ri Jesús chuꞌlew, xoꞌlcꞌul ruma jun achi aj pa la tinamit. Cꞌo tan kꞌij waꞌchi cꞌo pukꞌab jun itzel uxlabixel. Na cucoj ta ukꞌuꞌ y na jekel ta chirocho, ma jekel pa tak mukubal que animaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Waꞌchi, echiriꞌ xril uwach ri Jesús, lic xsiqꞌuinic y xuxuc rib chwach. Y lic co xchꞌawic, jewaꞌ xubiꞌij: —¿Suꞌchac coꞌlmina ib la wucꞌ, Jesús, lal Ucꞌajol ri Dios cꞌo chilaꞌ chicaj? Cantzꞌonoj co cheꞌla na quinya ta la pa cꞌax —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Xubiꞌij waꞌ ma ri Jesús cutak ri itzelilaj uxlabixel chaꞌ quel bi che rachi. Yey lic cꞌo tan kꞌij rachi cꞌo pukꞌab waꞌ. Y tob cayut pa carena y pa griyetas, ronoje curakij y cacꞌam bi ruma ri itzel uxlabixel pa tak luwar catzꞌintzꞌotic.) ");
INSERT INTO acrTNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ecꞌu ri Jesús xutzꞌonoj che rachi: —¿Saꞌ rabiꞌ? —xchaꞌ. Rire xubiꞌij: —Legión —xchaꞌ. Xubiꞌij waꞌ ma lic e qꞌui ri itzel uxlabixel eboquinak rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ecꞌu tak ri itzel uxlabixel lic xquicoj quib chwach ri Jesús chaꞌ na quebutak tubi pa ri siwan na jinta utakexic uchoyil upa. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E cꞌo cꞌu uqꞌuiyal ak quewaꞌ chwa ri juyub y tak ri itzel uxlabixel xquitzꞌonoj chaꞌ queboc bi cucꞌ ri ak. Ecꞌu ri Jesús xuya luwar chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ecꞌuchiriꞌ, xebel bi che rachi y xeboc bi cucꞌ ri ak. Y conoje waꞌ xeꞌquicꞌaka bi quib chwi jun siwan, xebeꞌtzak chupa ri mar y xejikꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ecꞌu ri quechajin que ri ak, echiriꞌ xquil tak waꞌ, xebanimajic y janipa ri xquilo xebec che utzijoxic chupa ri tinamit y pa tak juyub. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xepe cꞌu ri winak che rilic saꞌ ri xꞌaniꞌ chiriꞌ. Echiriꞌ xecꞌun pa cꞌo wi ri Jesús, xquirik rachi ri ebelinak chubi ri itzel uxlabixel che, tzꞌul xeꞌrakan ukꞌab ri Jesús, ucojom chi ukꞌuꞌ y jusucꞌ chi runaꞌoj. Ruma waꞌ, lic xquixiꞌij quib. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y ri xebilow waꞌ xquitzijoj chique ri cꞌacꞌ xecꞌunic, suꞌanic xcolobetaj rachi ri xebel bi ri itzel uxlabixel che. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ecꞌuchiriꞌ, conoje ri winak pa tak ri luwar re Gadara xebelaj che ri Jesús quel bi chiriꞌ ma lic quixiꞌim quib che. Y ri Jesús xoc chupa ri barco chaꞌ catzelejic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ecꞌuchiriꞌ, rachi ri ebelinak bi ri itzel uxlabixel che, xelaj che ri Jesús chaꞌ cuya luwar che caterej bi chirij; pero ri Jesús xutak che cacanaj canok, jewaꞌ xubiꞌij che: ");
INSERT INTO acrTNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Chat-tzelej chaꞌwocho y chatzijoj chique ri ticawex ronoje ri utz uꞌanom ri Dios awucꞌ —xchaꞌ. Y rachi e xuꞌano; xeꞌec che utzijoxic chupa ronoje ri tinamit ri utz xꞌan che ruma ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Echiriꞌ xtzelej ri Jesús chꞌaka yaꞌ, ri winak xquicꞌul rucꞌ quiꞌcotemal ma conoje lic coyeꞌem. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ecꞌuchiriꞌ, xopon jun achi Jairo rubiꞌ, rire aj wach re ri sinagoga. Waꞌ waꞌchi xuxuc rib xeꞌrakan ukꞌab ri Jesús y lic xelaj che queꞌec chirocho, ");
INSERT INTO acrTNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ma xa jun co rumiꞌal y laj cablajuj rujunab, yey cajecꞌowic. Ecꞌuchiriꞌ xeꞌec ri Jesús rucꞌ, uqꞌuiyal winak xeterej bi chirij y lic caquipitzꞌipaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquixoꞌlibal cꞌu ri winak cꞌo jun ixok lic yewaꞌ, e cablajuj lo junab riꞌ na cataniꞌ ta ri yabil re upa icꞌ che. Ronoje ri cꞌo rucꞌ uqꞌuisom chi ne cucꞌ ri aj cun, yey na jinta junok xrikow ucunaxic ri yabil cꞌo che. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Rire xkib cꞌu pana chirij ri Jesús y xuchap ruchiꞌ rukꞌuꞌ. Y chupa cꞌu laꞌ la jokꞌotaj xtaniꞌ ruyabil. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ecꞌuchiriꞌ, ri Jesús xutzꞌonoj: —¿China ri xchapaw weꞌin? —xchaꞌ. Yey na jinta junok cuya rib chupa. Ecꞌuchiriꞌ ri Pedro y ri rachbiꞌil xquibiꞌij: —Kajawal, ri winak caquipitzꞌipaꞌ la y caquiminimaꞌ la. ¿Suꞌchac cꞌu riꞌ catzꞌonoj la: “¿China ri xchapaw weꞌin?” —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noꞌj ri Jesús xubiꞌij: —Cꞌo jun xinchapawic ma xinnaꞌo cꞌo jun xcunutaj rucꞌ ri nuchukꞌab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Echiriꞌ rixok xrilo xnaꞌbetaj ruma ri Jesús, xpetic cabirbotic. Xuxucubaꞌ cꞌu rib xeꞌrakan ukꞌab ri Jesús y xutzijoj chiquiwach conoje ri winak suꞌbe xuchap rukꞌuꞌ ri Jesús y chaꞌtaj xa pa jokꞌotaj xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ecꞌu ri Jesús xubiꞌij che: —Ixok, ruma ri cubulibal cꞌuꞌx la wucꞌ, xcunutaj la. Oj cꞌu la riꞌ chi utzil chomal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cꞌa cachꞌaꞌt ne ri Jesús, echiriꞌ xcꞌun lo jun petinak chirocho ri aj wach re ri sinagoga y xoluꞌbiꞌij che ri Jairo: —Ri miꞌal la ya xcamic; na jinta chi cutikoj cabayabaꞌ la ri tijonel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Echiriꞌ xuta waꞌ ri Jesús, xubiꞌij che ri Jairo: —Muxiꞌij rib cꞌuꞌx la, xew lic cubula cꞌuꞌx la wucꞌ y jelaꞌ cacolobetaj ri miꞌal la che ri camic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ecꞌuchiriꞌ xopon chirocho ri Jairo, ri Jesús xew xebucoj bi ri Pedro, ri Jacobo, ri Juan y ruchu-ukaw ri ralco ali; y na xuya ta luwar che junok chic coc bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Conoje ri winak quebokꞌic y lic quetunanic. Noꞌj ri Jesús xubiꞌij chique: —Mixokꞌic, ma ri ralco ali na caminak taj, xa cawaric —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ecꞌu rique xa xquitzeꞌej ri xubiꞌij, ma quetaꞌam caminak chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Noꞌj ri Jesús xuchap rukꞌab ri ralco ali y lic co xubiꞌij: —Ali chuuy, ¡chatyactajok! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ecꞌuchiriꞌ xtzelej lo ri ranimaꞌ y chupa cꞌu laꞌ la jokꞌotaj xyactajic. Y ri Jesús xebutak che uyaꞌic uwa. ");
INSERT INTO acrTNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ecꞌu ruchu-ukaw lic xcam canimaꞌ che, pero ri Jesús xebutak che na caquibiꞌij ta che junok wa xuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xumol quichiꞌ ri cablajuj utijoꞌn y xuya paquikꞌab quebequesaj bi itzelilaj uxlabixel y quequicunaj ri yewaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xebutak cꞌu bi riꞌ che utzijoxic rutakanic ri Dios y che quicunaxic ri yewaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jewaꞌ xubiꞌij chique: «Macꞌo micꞌam bi re pa be; micꞌam bi ichꞌamiꞌy, iteb, iwa, imeyo o jun chic icoton. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","We xixcꞌul pa juna ja, chixcꞌola chiriꞌ cꞌate quixel bi echiriꞌ quixꞌec pa jun chic tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We chupa juna tinamit na quixcꞌul taj, chixelubi chiriꞌ y chipupaꞌ can rulew cꞌo che ri iwakan, waꞌ e cꞌutubal re na utz ta quiꞌanom ri ejekel chiriꞌ» xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xebel cꞌu bi rutijoꞌn y xebec pa tak aldeas re caquitzijoj ri Utzilaj Tzij y re quequicunaj yewaꞌib che ronoje luwar. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri Herodes, ri rey re Galilea, xuta puwi ronoje ri cuꞌan ri Jesús. Ruma cꞌu waꞌ, lic sachinak runaꞌoj, ma e cꞌo jujun quebiꞌn re: «Laꞌ e ri Juan xcꞌastaj lo chiquixoꞌl ri ecaminak» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yey e cꞌo jujun caquibiꞌij: «Rire e Elías xwinakir lok.» Y e cꞌo jujun chic caquibiꞌij: «E junok chique ri kꞌalajisanelab re ojertan xcꞌastaj lok» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Noꞌj ri rey Herodes xubiꞌij: «Riꞌin xintak ucꞌatzixic rujolom ri Juan. ¿China cꞌu riꞌ waꞌ waꞌchi lic saꞌchi ri quintajin che utayic puwiꞌ?» xchaꞌ. Y cutzucuj cꞌut suꞌanic caril uwach ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Echiriꞌ xetzelej lo ri cablajuj utakoꞌn ri Jesús, xquitzijoj che Rire janipa tak ri xquiꞌano. Ecꞌuchiriꞌ, xecꞌam bi ruma ri Jesús y xebec quituquel pa jun luwar catzꞌintzꞌotic chunakaj jun tinamit Betsaida rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Noꞌj ri winak echiriꞌ xquetaꞌmaj, xebel lo pa tak ri tinamit y xebec chaꞌ queꞌquirika ri Jesús. Yey Rire xebucꞌul chi utz, xujek catzijon chiquiwach puwi rutakanic ri Dios y xebucunaj ri e yewaꞌib chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Echiriꞌ catajin ubenam ri kꞌij, xekib lo ri cablajuj utijoꞌn y xquibiꞌij che: —Kajawal, utz we quetak bi la ri winak pa tak raldeas y pa tak ri luwar cꞌo lo xa nakaj chaꞌ queꞌquitzucuj pa quewar wi y saꞌ ri caquitijo, ma ri wara pa oj cꞌo wi lic catzꞌintzꞌotic —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Noꞌj ri Jesús xubiꞌij chique: —Chebitzuku riꞌix —xchaꞌ. Ecꞌu rutijoꞌn xquibiꞌij che: —Xa woꞌob pam y caꞌib car cꞌo kucꞌ. Xew we e laꞌ cojꞌec y queꞌkalokꞌo waꞌim que conoje wa uqꞌuiyal winak, quekatzuk cꞌu riꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Laj e lo woꞌob mil chi achijab e cꞌo chiriꞌ. Ecꞌu ri Jesús xubiꞌij chique rutijoꞌn: —Chibiꞌij chique ri winak quetzꞌuyiꞌ chimutzaꞌj re nicꞌaj ciento chujujunal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jelaꞌ xquiꞌano, xequitzꞌuyubaꞌ conoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ecꞌuchiriꞌ ri Jesús xucꞌam ri woꞌob pam y ri caꞌib car, xtzuꞌn chicaj y xtioxin chwach ri Dios. Xuya cꞌu bi chique rutijoꞌn chaꞌ caquijach chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Conoje cꞌu ri winak xewaꞌic y xenoj chi utz. Tecꞌuchiriꞌ, xquimol ri chꞌakaꞌtaꞌk quikax y rucꞌ waꞌ xnoj lo cablajuj chacach. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Cꞌo jun kꞌij ri Jesús utuquel cachꞌaꞌt rucꞌ ri Dios, yey xew rutijoꞌn e cꞌo rucꞌ. Ewi xutzꞌonoj chique: —Chiquiwach ri winak, ¿in china nawi riꞌin? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rutijoꞌn xquicꞌul uwach che: —Cꞌo quebiꞌn re lal ri Juan Aj Yaꞌl Bautismo; jujun chic caquibiꞌij lal ri Elías; y jujun chic, lal junok chic chique ri kꞌalajisanelab re ojertan cꞌastajinak lok —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ecꞌuchiriꞌ, xutzꞌonoj tanchi chique: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. Ecꞌu ri Pedro xucꞌul uwach: —Rilal lal ri Cristo, Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús lic xebutak che na caquitzijoj ta cꞌana che junok china Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ecꞌuchiriꞌ, xubiꞌij chique: —Lic chirajawaxic che Ralaxel Chiquixoꞌl Ticawex cutij na ri cꞌax y cacꞌak bi ukꞌij cuma ri nimak winak re ri tinamit, ri nimak e aj chacunel pa Rocho Dios y raj cꞌutunel re ri tzijpixab. Tecꞌuchiriꞌ, cacamisaxic; noꞌj churox kꞌij cacꞌastaj lok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xubiꞌij tanchi cꞌu chique conoje: —We cꞌo junok caraj caterej lo chwij, lic chirajawaxic che muꞌan xew ri caraj rire, e ronoje kꞌij chucuyu ri cꞌax cape puwiꞌ ruma ucojom ri nubiꞌ; yey utz cꞌu riꞌ caterej lo chwij. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ma china ri na cuya ta ranimaꞌ rucꞌaslem, riꞌ e cujam ri chomilaj cꞌaslemal chwach ri Dios; noꞌj ri cuya ranimaꞌ rucꞌaslem wuma riꞌin, riꞌ e curik ri chomilaj ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","»¿Saꞌ cꞌu cutikoj riꞌ che juna ticawex we cuꞌan rajaw ronoje ruwachulew, yey e cujam rucꞌaslemal y jelaꞌ cusach uwach chiribil rib? ");
INSERT INTO acrTNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma china ri caqꞌuix chwe riꞌin y che ri nuchꞌaꞌtem, jelaꞌ cꞌu riꞌ ri in Alaxel Chiquixoꞌl Ticawex quinqꞌuix che rire echiriꞌ quincꞌun tanchi rucꞌ runimal nuchomalil, junam rucꞌ runimal uchomalil ri Nukaw y cucꞌ tak ri santowilaj ángeles. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riꞌin pakatzij wi cambiꞌij chiwe: E cꞌo jujun chique wa e cꞌo wara na quecam tana we na xquil tubi rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Laj wajxakib kꞌij riꞌ ubiꞌim waꞌ ri Jesús echiriꞌ xebuchaꞌ ri Pedro, ri Juan y ri Jacobo y xel bi cucꞌ chwa jun juyub chaꞌ queꞌchꞌaꞌt rucꞌ ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yey echiriꞌ cachꞌaꞌt rucꞌ ri Dios, xjalcꞌatitaj rupalaj y rukꞌuꞌ xuꞌan lic sak y cawolkꞌinic. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y xewinakir cꞌu queb achijab e riꞌ quechꞌaꞌt rucꞌ. Waꞌ e ri Moisés y ri Elías, kꞌalajisanelab re ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ecꞌu rique sututal quij rucꞌ jun chomilaj kꞌijsak. Y quechꞌaꞌt puwi rucamic ri Jesús, ri cucꞌulumaj na chilaꞌ Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ri Pedro cucꞌ ri rachbiꞌil lic cꞌo waram chique, pero xtzor caꞌn quiwach y xquil cꞌu runimal uwonibal ri Jesús y ri caꞌib achijab e cꞌo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ecꞌuchiriꞌ catajin bi quelic ri caꞌib achijab rucꞌ ri Jesús, ri Pedro xubiꞌij che ri Jesús: —Kajawal, lic utz xyaꞌtaj chike oj cꞌo wara. Kaꞌana cꞌu oxib rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. Ri Pedro xubiꞌij waꞌ ruma na cunaꞌ taj saꞌ ri cubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Cꞌa cachꞌaꞌt ne ri Pedro, echiriꞌ xpe jun sutzꞌ y xuchꞌuk quiwiꞌ. Lic cꞌu xquixiꞌij quib riꞌ echiriꞌ xechꞌukutaj ruma ri sutzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ecꞌuchiriꞌ, xquita rukul ri Dios chupa ri sutzꞌ, jewaꞌ cubiꞌij: «E Nucꞌajol waꞌ ri lic cꞌax cannaꞌo; e chita utzij Rire» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ecꞌuchiriꞌ xqꞌuis ubiꞌxiquil waꞌ, na e jinta chi ri caꞌib achijab rucꞌ ri Jesús. Chupa tak cꞌu riꞌ laꞌ la kꞌij, ri Pedro, ri Juan y ri Jacobo na xquitzijoj ta cꞌana che junok waꞌ wa xquilo. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chucaꞌm kꞌij echiriꞌ xekaj lo chwa ri juyub, uqꞌuiyal winak xebel lo che ucꞌulic ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Cꞌo cꞌu jun achi chiquixoꞌl ri winak lic co xchꞌawic, jewaꞌ xubiꞌij: —Lal tijonel, ꞌana co la riꞌ, cunaj la wa nucꞌajol, ma xew ne co walcꞌoꞌal waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rire cachaptaj ruma jun itzel uxlabixel. Yey echiriꞌ ritzel uxlabixel cuchapo, rala xakicꞌateꞌt cujek casiqꞌuinic, catzak pulew, lic co cujabajaꞌ rib y capuluwan rucꞌaxaj. Ecꞌu ri itzel uxlabixel lic cuꞌan can cꞌax che y lic na caraj taj quel bi rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya xinelaj co chique ri tijoꞌn la chaꞌ caquesaj bi ri itzel uxlabixel, pero rique na xquichꞌij ta resaxic bi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ecꞌu ri Jesús xucꞌul uwach: —¡E ri ix ticawex re wakꞌij ora, na cubul ta icꞌuꞌx wucꞌ yey ix sachinak! ¿Janipa chi lo kꞌij cajawaxic quincꞌojiꞌ iwucꞌ chaꞌ cacubiꞌ icꞌuꞌx wucꞌ? ¿Janipa chi lo kꞌij quixincuyu e laꞌ jelaꞌ iꞌanom? —xchaꞌ. Ecꞌuchiriꞌ, xubiꞌij che rachi: —Cꞌama lo ri cꞌajol la wara —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Echiriꞌ rala xkib rucꞌ ri Jesús, xcꞌak pulew y lic co xjabajoꞌx ruma ri itzelilaj uxlabixel. Pero ri Jesús xutak ri itzelilaj uxlabixel chaꞌ quel bi che rala y jecꞌulaꞌ xucunaj can rala. Tecꞌuchiriꞌ, xuya bi pukꞌab rukaw. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y conoje xcam canimaꞌ che runimal uchukꞌab ri Dios. Ruma cꞌu conoje caminak canimaꞌ che ri cuꞌan ri Jesús, Rire jewaꞌ xubiꞌij chique rutijoꞌn: ");
INSERT INTO acrTNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Lic chita chi utz waꞌ y micꞌow chicꞌuꞌx: Ralaxel Chiquixoꞌl Ticawex cayaꞌiꞌ paquikꞌab rachijab chaꞌ rique caquikꞌat tzij puwiꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Noꞌj rutijoꞌn na xquimaj ta usucꞌ la cubiꞌij, ma cꞌamajaꞌ cayaꞌtaj chique caquimaj usucꞌ waꞌ. Yey caquixiꞌij quib caquitzꞌonoj che ri Jesús saꞌ queꞌelawi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ecꞌuchiriꞌ, rutijoꞌn ri Jesús xquijeko caquichapalaꞌ quib chiquiwach puwiꞌ chinok chique cayaꞌiꞌ más uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ewi ri Jesús xunaꞌbej ri cꞌo pa canimaꞌ. Xucꞌam cꞌu jun ralco cꞌoꞌm y xuya putzal. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Xubiꞌij cꞌu chique: —China ri cucꞌul chupa ri nubiꞌ junok na jinta uwach pachaꞌ wa ralco cꞌoꞌm, e junam rucꞌ e in ri quinucꞌulu. Yey china ri cacꞌuluw we riꞌin, e cucꞌul cꞌu ri Jun takayom lo we. Ma e ri cuꞌan chꞌutiꞌn che rib, e lic cꞌo uwach riꞌ chwach ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ecꞌuchiriꞌ, ri Juan xubiꞌij che ri Jesús: —Kajawal, xkil jun achi queberesaj bi itzel uxlabixel chupa ri biꞌ la; yey riꞌoj xkabiꞌij che muꞌan chi waꞌ, ma rire na kuqꞌuil taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ecꞌu ri Jesús xubiꞌij che ri Juan: —We cꞌo caꞌanaw waꞌ, mikꞌatej; ma china ri na cachꞌoꞌjin ta chikij, riꞌ e kuqꞌuil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","E xuꞌan waꞌ echiriꞌ ya copon rukꞌijol cacꞌam pan ri Jesús chilaꞌ chicaj: Rire xa jumul xujiquibaꞌ uwach queꞌec chupa ri tinamit Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Xebunabesaj bi rutijoꞌn chwach Rire. Rique xebec y xeboc chupa jun aldea que ri aj Samaria chaꞌ caquitzucuj pa cacanaj wi ri Jesús chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri aj Samaria na xcaj taj caquicꞌulu ma xquinaꞌbej Jerusalem queꞌec wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Echiriꞌ ri Jacobo y ri Juan, ri queb utijoꞌn ri Jesús xquil waꞌ, xquibiꞌij che: —Kajawal, ¿caꞌaj la cojtakan che chaꞌ cakaj lo akꞌ chilaꞌ chicaj y jecꞌulaꞌ casach quiwach conoje, jelaꞌ pachaꞌ xuꞌan ri kꞌalajisanel Elías ojertan? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero ri Jesús xutzuꞌ quiwach y xebuyajo, jewaꞌ xubiꞌij chique: —Riꞌix na iwetaꞌam taj saꞌ chi uxlabixel xcojow waꞌ pijolom. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma ri in Alaxel Chiquixoꞌl Ticawex na in ta cꞌuninak che usachic quiwach ri ticawex; ma in petinak che quicolobexic —xchaꞌ. Ecꞌuchiriꞌ, xebec tanchi chupa jun chic aldea. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Xalokꞌ cꞌu riꞌ e cꞌo chi be, cꞌo jun xubiꞌij che ri Jesús: —Wajawal, riꞌin quinterej bi chiꞌij la tob pachawi queꞌec wi la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ecꞌu ri Jesús xubiꞌij che: —Ri yac cꞌo quijul y ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj cꞌo quisoc; noꞌj Ralaxel Chiquixoꞌl Ticawex na jinta ne uluwar tob xa pa cuxlan wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tecꞌuchiriꞌ, xubiꞌij che jun chic achi: —Chat-terej lo chwij —xchaꞌ. Ecꞌu rachi xubiꞌij che ri Jesús: —Wajawal, yaꞌa la luwar chwe canwoyꞌej cacam na ri nukaw y canmuk canok; tecꞌuchiriꞌ, quinterej chiꞌij la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ri Jesús xubiꞌij che: —Chayaꞌa can chique ri ecaminak chwach ri Dios chaꞌ e rique quemukuw ri catz-quichakꞌ quecamic; noꞌj riꞌat jat y chat-tzijon puwi rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tecꞌuchiriꞌ, cꞌo tanchi jun jewaꞌ xubiꞌij che ri Jesús: —Wajawal, riꞌin cuaj quinterej bi chiꞌij la. Pero nabe na yaꞌa la luwar chwe quebenuchꞌaꞌbej can ri watz-nuchakꞌ e cꞌo pa wocho —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ri Jesús xubiꞌij che: —Na jinta junok echiriꞌ uchapom rabixobal catzuꞌn can chirij, ma riꞌ na jusucꞌ ta ri chac cuꞌano. Jecꞌuriꞌlaꞌ, we junok na uyaꞌom ta can ronoje, na takal ta che cꞌo chupa rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tecꞌuchiriꞌ, ri Kanimajawal xebuchaꞌ chi setenta utijoꞌn y xebutak bi pa cacab chaꞌ quenabej bi chwach Rire pa ronoje tak tinamit y luwar pa queꞌec wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Echiriꞌ cꞌamajaꞌ quebel bi, ri Jesús xubiꞌij chique: «Pakatzij wi cambiꞌij chiwe: Ri molonic cajawaxic caꞌanic, lic nim; noꞌj raj chac na e qꞌui taj. E uwariꞌche chitzꞌonoj che ri Dios, ri Rajaw ri molonic, chaꞌ quebutak lo aj chac re caquiꞌan ri molonic. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Jix! Pero chitapeꞌ: Riꞌin quixintak bi pachaꞌ ix bexex chiquixoꞌl utiw. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","»Echiriꞌ quixꞌec, micꞌam bi ucꞌolibal imeyo, micꞌam bi iteb, micꞌam bi jun chic molaꞌj ixajab. Yey mixtaqꞌuiꞌ pa be re quiya can rutzil uwach junok. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","»We xixoc chuchiꞌ juna ja, ri nabe ichꞌaꞌtem quibiꞌij e waꞌ: “Cꞌola ri utzil chomal re ri Dios pawiꞌ alak.” ");
INSERT INTO acrTNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We cꞌo junok chiriꞌ lic caraj cucꞌul ri utzil chomal re ri Dios, cucꞌul cꞌu riꞌ. Noꞌj we na jinta cacꞌuluw re ri utzil chomal re ri Dios, waꞌ catzelej tanchi lo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pa quixcꞌul wi, chixcanaj chiriꞌ chupa ri ja; mixkꞌax che jujun chic ja. Utz quitij ri cayaꞌ chiwe; ma e junok cachacunic, lic takal che catojic. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","We xixoc chupa juna tinamit y xixcꞌul pa juna ja, chitijaꞌ saꞌ ri cayaꞌ lo chiwach y mitzꞌonoj ri quiwaj riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","»Chebicunaj cꞌu ri e yewaꞌib e cꞌo chupa ri tinamit y chibiꞌij chique conoje: “Rutakanic ri Dios xa nakaj chi cꞌo wi lo che alak.” ");
INSERT INTO acrTNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","»We xixoc cꞌu chupa juna tinamit yey na quixcꞌul taj, chixelubi pa tak be y chibiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tob ne rulew re wa tinamit alak cꞌo che ri kakan, cakapuꞌ canok chaꞌ quetaꞌmaj alak na utz ta ri xꞌan alak. Pero chetaꞌmaj alak chi utz waꞌ: Rutakanic ri Dios xa nakaj chi cꞌo wi lo che alak” quixchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Cambiꞌij cꞌu chiwe: Más lic cꞌax ri cape na paquiwi ri tinamit na caquicꞌul ta ri Utzilaj Tzij, chwa ri cape paquiwi ri e aj Sodoma y ri e aj Gomorra. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","»¡Lic tokꞌoꞌ iwach ri ix aj Corazín! ¡Lic tokꞌoꞌ iwach ri ix aj Betsaida! Ma we ta chupa ri tinamit Tiro y ri tinamit Sidón xilitaj wi wa cꞌutubal re ruchukꞌab ri Dios xinꞌan chiwach riꞌix, cꞌo tan kꞌij ta lo riꞌ xquitzelej quitzij chwach ri Dios, quicojom cꞌu quikꞌuꞌ cꞌax rij y quitzꞌuyubam quib pa chaaj ruma ri quibis. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E uwariꞌche echiriꞌ copon ri kꞌij re ri kꞌatbal tzij, más nim ri cꞌaxcꞌobic cape piwiꞌ chwa ri cꞌaxcꞌobic cape paquiwi ri winak re ri tinamit Tiro y ri tinamit Sidón. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ecꞌu ri ix aj Capernaúm, e chiwach riꞌix lic yacom chi ikꞌij cꞌa chicaj; yey na e ta riꞌ, ma lic cacꞌak ne bi ikꞌij y quixcꞌak ne bi cꞌa chi xibalbaꞌ re tijbal cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","»China ri cataw iweꞌix, in ri quinuto; china ri tzel quilow iwe, in ri tzel quinrilo; china ri tzel quilow we riꞌin, e tzel caril ri Jun takayom lo we riꞌin» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xebec cꞌu riꞌ ri setenta. Y ecꞌuchiriꞌ xetzelej lok, lic quequiꞌcotic. Xquitzijoj cꞌu che ri Jesús: —Kajawal, ¡tak ri itzel uxlabixel xquicoj katzij echiriꞌ chupa ri biꞌ la xojtakan che quebel bi chique ri winak! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ri Jesús xubiꞌij chique: —Riꞌin xinwil ri Satanás xcꞌak lo chicaj pachaꞌ jun rayo. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Chiwilapeꞌ! Riꞌin nuyaꞌom ichukꞌab chaꞌ quichꞌij uchukꞌab ritzel winak y na jinta cꞌo quicꞌulumaj tob ne quiyikꞌiyaꞌ quiwiꞌ cumatz y sinaꞌj. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero riꞌix mixquiꞌcot ruma caquicoj itzij ri itzel uxlabixel; e chixquiꞌcota ruma tzꞌibital ribiꞌ chilaꞌ chicaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ecꞌu laꞌ la jokꞌotaj, ri Jesús lic xquiꞌcot ruma ri Santowilaj Ruxlabixel ri Dios y xubiꞌij: «Nukaw, canyac kꞌij la, Lal Rajaw ruwa caj y ruwachulew, ma tak ri kꞌalajisam la chique ri lic caquiꞌan chꞌutiꞌn che quib, waꞌ ewam la chiquiwach ri lic cꞌo quinaꞌoj y lic cꞌo quimajom. Jelaꞌ xꞌan la, Nukaw, ma e xꞌaj la riꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tecꞌuchiriꞌ, xubiꞌij chique ri ticawex: «Ronoje tak ri cꞌolic yaꞌtal lo panukꞌab ruma ri Nukaw. Na jinta cꞌu junok umajom usucꞌ chi utz saꞌ ruwach Rucꞌajol ri Dios; xew ri Kakaw Dios etaꞌmayom re. Y na jinta ne junok umajom usucꞌ chi utz saꞌ ruwach ri Kakaw Dios, xew Rucꞌajol ri Dios etaꞌmayom re; yey pukꞌab cꞌu riꞌ Rucꞌajol cꞌo wi china chique caraj cukꞌalajisaj wi waꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tecꞌuchiriꞌ xkib cucꞌ rutijoꞌn y e laꞌ xa quituquel xubiꞌij chique: «Nim quikꞌij calaxic ri caquilo janipa ri iwilom riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ma cambiꞌij cꞌu chiwe lic e qꞌui ri kꞌalajisanelab y ri takanelab re ojertan lic xcaj caquil bi janipa ri quiwil riꞌix woꞌora, pero na xquimaj ta chi rilic bi. Lic xcaj caquita bi janipa ri quita riꞌix woꞌora, pero na xquimaj ta chi utayic bi» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Cꞌo jun aj cꞌutunel re ri tzijpixab xyactajic y jewaꞌ xubiꞌij chaꞌ cucꞌam upa ri Jesús: —Wajawal, ¿saꞌ ri canꞌano chaꞌ cꞌo nucꞌaslemal na jinta utakexic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xubiꞌij che: —¿Saꞌ ri tzꞌibital chupa Rutzij Upixab ri Dios? ¿Saꞌ ri camaj la usucꞌ che? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y raj wach xucꞌul uwach: —Jewaꞌ tzꞌibitalic: Cꞌax chanaꞌa ra Dios Kajawxel rucꞌ ronoje awanimaꞌ, rucꞌ ronoje acꞌuꞌx, rucꞌ ronoje achukꞌab y rucꞌ ronoje anaꞌoj; yey Cꞌax chanaꞌa rawatz-achakꞌ jelaꞌ pachaꞌ ri cꞌax canaꞌ awib riꞌat —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y ri Jesús xubiꞌij che: —Lic utz ri xcꞌulubej wi la uwach. ꞌAna cꞌu la waꞌ y cacꞌojiꞌ cꞌaslemal la na jinta utakexic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero raj wach na caraj taj cutzak rib y xubiꞌij cꞌu che ri Jesús: —¿Yey china ri watz-nuchakꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ri Jesús jewaꞌ xubiꞌij che: «Cꞌo jun achi xel chupa ri tinamit Jerusalem y xeꞌec pa ri tinamit Jericó. Pa be cꞌut xtzak paquikꞌab jujun elekꞌomab. Relekꞌomab xquimaj bi ronoje rubitak re y lic xquiꞌan can cꞌax che. Cajecꞌowic xquiya canok y xebec. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","»Ecꞌuchiriꞌ, chupa ri be xcꞌun lo jun aj chacunel pa Rocho Dios. Y echiriꞌ xril rachi ꞌanom can cꞌax che, xa xutzuꞌ canok y xicꞌowic. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","»Tecꞌuchiriꞌ xcꞌun lo jun chic achi aj levita, toꞌbel que raj chacunel pa Rocho Dios. Echiriꞌ xopon chunakaj rachi ꞌanom can cꞌax che, xa xutzuꞌ canok y xicꞌowic. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","»Xcꞌun cꞌu lo jun achi aj Samaria. Echiriꞌ xcꞌun chunakaj rachi ꞌanom can cꞌax che y xrilo saꞌ ruꞌanom, lic xjuchꞌ caꞌn pa ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xkib cꞌu rucꞌ, xucunaj uwach rucꞌax rucꞌ aceite y rucꞌ vino, y xuchꞌuk uwach rucꞌax rucꞌ cꞌul. Xuyac bi chwi rucawayuꞌ, xucꞌam bi chupa jun mesón y xuchajij chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Echiriꞌ xel chiriꞌ chucaꞌm kꞌij, xresaj lo caꞌib denarios pubolxa y xuya can che ri rajaw ri mesón, y jewaꞌ xubiꞌij che: “Chajij co la waꞌchi chwe. We na xuꞌan ta cꞌu wa puak canya can cheꞌla, echiriꞌ quintzelej lok, canyijbaꞌ cheꞌla” xchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tecꞌuchiriꞌ ri Jesús xubiꞌij che raj cꞌutunel: —Chiwach rilal, ¿china chique wa oxib achijab xuꞌan ratz-uchakꞌ rachi xchapataj cuma relekꞌomab pa be? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Raj cꞌutunel xubiꞌij: —Chinuwach riꞌin, e ri jun xucꞌut ri cꞌaxnaꞌbal ucꞌuꞌx che —xchaꞌ. Ecꞌuchiriꞌ xubiꞌij ri Jesús che: —Lic areꞌ. Jelaꞌ cꞌu riꞌ ꞌana la rilal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Echiriꞌ ri Jesús cꞌo chi be, xoc chupa jun aldea. Chiriꞌ cꞌo jun ixok Marta rubiꞌ y rire xucꞌul ri Jesús chirocho. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wiꞌxok Marta cꞌo jun uchakꞌ María rubiꞌ. Ecꞌu ri María xtzꞌuyiꞌ chwach ri Jesús chaꞌ cuta ri cubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Noꞌj ri Marta lic e ubis ucꞌuꞌx tak ri caꞌan pa ja. Ecꞌuchiriꞌ, xkib rucꞌ ri Jesús y jewaꞌ xubiꞌij che: —Wajawal, ¿lic cami e laꞌ na coc ta la il che ri cuꞌan ri nuchakꞌ? Ma inuyaꞌom can nutuquel chwach ri nimanic. Biꞌij co la che quinutoꞌo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Noꞌj ri Jesús xubiꞌij che: —Marta, Marta, riꞌat lic e ubis acꞌuꞌx y e sachinak anaꞌoj puwi ri caꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xa jun cꞌu ri lic chirajawaxic wi caꞌanic, waꞌ e ri más utz, y ri María e uchaꞌom waꞌ; yey na jinta junok camajaw waꞌ che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Cꞌo jun kꞌij ri Jesús cachꞌaꞌt rucꞌ ri Dios. Y echiriꞌ xuqꞌuis uꞌanic orar, jun chique rutijoꞌn xubiꞌij che: —Kajawal, cꞌutu la chike suꞌanic cakaꞌan orar, jelaꞌ pachaꞌ xuꞌan ri Juan cucꞌ rutijoꞌn —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y ri Jesús xubiꞌij chique: —Echiriꞌ quixchꞌaꞌt rucꞌ ri Dios, utz jewaꞌ quibiꞌij: Kakaw Dios, Lal cꞌo la chilaꞌ chicaj, ¡lic chetaꞌmaxok nim ukꞌij ri biꞌ la! Peta la, takana la pakawiꞌ; chuꞌana cꞌu ri rajawal cꞌuꞌx la wara che ruwachulew, jelaꞌ pachaꞌ ri caꞌan chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yaꞌa co la wakꞌij ri kawa, ri cajawax chike ronoje kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cuyu co la kamac, jelaꞌ pachaꞌ riꞌoj cakacuy quimac conoje ri emacuninak chikij. Y maya co la luwar chike cojtzak pa mac; e lic chojcolobej la chwach ritzel winak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ecꞌu ri Jesús xubiꞌij tanchi chique: «We ta e laꞌ cꞌo junok chiwe, pa tiqꞌuil akꞌab queꞌec chirocho juna ramigo y jewaꞌ cubiꞌij che: “Wamigo, maꞌan co riꞌ canjal oxib nuwa chawe, ");
INSERT INTO acrTNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ma xcꞌun jun wamigo petinak naj y na jinta chi nuwa re cantzuku” cacha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","»Ecꞌu rire cucꞌul lo uwach cꞌa pa ja, jewaꞌ cubiꞌij lo che: “Minachꞌichꞌaꞌ, ma ri puerta tzꞌapil chic y oj cotzꞌol chi cucꞌ ri walcꞌoꞌal. Na utz ta cꞌu riꞌ quinyactajic chaꞌ quiꞌnyaꞌa bi chawe” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","»Cambiꞌij cꞌu riꞌin chiwe: Rachi tob na cayactaj ta lo che utoꞌic ri ramigo ruma camigos quib, pero cutoꞌo xa ruma ri ramigo lic na xrokꞌotaj ta utzꞌonoxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","E uwariꞌche cambiꞌij riꞌin chiwe: Janipa ri cajawax chiwe, chitzꞌonoj che ri Dios y cayaꞌiꞌ chiwe; chitzucuj rucꞌ Rire janipa ri cajawax chiwe y quiriko; chichꞌaꞌbej Rire y quixucajmaj lok. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ma china ri quel uchiꞌ che utzꞌonoxic, cucꞌul na; china ri cꞌo cutzucuj, curik na; y china ri cachꞌaw pan che ruchiꞌ ja, cajakiꞌ na lo che. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","»¿Cꞌo neba juna achi chixoꞌl, we rucꞌajol cutzꞌonoj pam, cuya juna abaj che; o we cutzꞌonoj car, cuya juna cumatz che? ");
INSERT INTO acrTNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O cꞌo neba juna achi we rucꞌajol cutzꞌonoj sakmolob che, cuya juna sinaꞌj che? ¡Na jinta junok! ");
INSERT INTO acrTNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ecꞌu riꞌix tob xa ix ticawex na lic ta utz icꞌuꞌx, na rucꞌ ta cꞌu riꞌ, quirik uyaꞌic chomilaj tak sipanic chique riwalcꞌoꞌal. ¡Macꞌuwariꞌ ri Kakaw Dios cꞌo chilaꞌ chicaj cuya ne lo ri Santowilaj Ruxlabixel chique ri quetzꞌonow re!» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E xuꞌan waꞌ echiriꞌ ri Jesús caresaj bi jun itzel uxlabixel che jun achi meꞌturisam ruma ri itzel uxlabixel. Ecꞌuchiriꞌ elinak chubi ri itzel uxlabixel, rachi xujek cachꞌaꞌtic. Yey tak ri winak lic xcam canimaꞌ che waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero e cꞌo jujun chique xquibiꞌij: «Rire queberesaj bi ri itzel uxlabixel ruma ruchukꞌab ri Beelzebú, ri cajawal ri itzel uxlabixel» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y e cꞌo chi jujun xa re caquicꞌam upa ri Jesús, caquitzꞌonoj che cuꞌan juna cꞌutubal re chilaꞌ chicaj chaꞌ cakꞌalajinic we Rire takom lo ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús retaꞌam saꞌ ri caquichꞌobo; ruma cꞌu riꞌ, xubiꞌij chique: «We ri takanelab re juna tinamit quijachom quipa ruma quechꞌoꞌjin chiquiwach, riꞌ na canajtir ta ri quitakanic. Yey we ri ejekelel pa juna ja quijachom quipa ruma quechꞌoꞌjin chiquiwach, riꞌ na quetiquiꞌ ta chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jecꞌuriꞌlaꞌ, we ta ri Satanás cucꞌ ri itzel uxlabixel caquijek quechꞌoꞌjin chiquiwach, ¿suꞌanic cꞌu riꞌ catiquiꞌ rutakanic? Cambiꞌij waꞌ ma ralak cabiꞌij alak riꞌin quebenuwesaj bi ri itzel uxlabixel ruma ruchukꞌab ri Beelzebú. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","»We ta e riꞌ, ¿china cayaꞌw quichukꞌab riꞌ ri e tijoꞌn ralak chaꞌ quequesaj bi itzelilaj uxlabixel? ¿Rucꞌ nawi ruchukꞌab ritzel caquiꞌano? Tzꞌonoj cꞌu alak riꞌ chique ri e tijoꞌn alak we e uꞌanom riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero we riꞌin quebenuwesaj bi ri itzel uxlabixel rucꞌ ruchukꞌab ri Dios, waꞌ e cꞌutubal re cꞌuninak chi rutakanic ri Dios chixoꞌlibal alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","»We cꞌo juna achi lic cꞌo uchukꞌab y lic cꞌo uchapabal pukꞌab re cuchajij ri rocho, na jinta cꞌu cucꞌulumaj riꞌ rubitak re. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Noꞌj we xcꞌun lo junok chic más cꞌo uchukꞌab chwa ri rajaw ja, riꞌ cuchꞌij uchukꞌab, cumaj cꞌu che ri rajaw ja ri chapabal ri lic ucubam ucꞌuꞌx rucꞌ, cucꞌam bi ronoje rubitak re y cujach chique jujun chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Cambiꞌij cꞌu che alak: China ri na uꞌanom ta re wucꞌ riꞌin, riꞌ aj chꞌaꞌoj chwij. Yey china ri na catoꞌb ta wucꞌ riꞌin che quicꞌamic lo jujun chic, riꞌ e cuwulij wa chac canꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","»Echiriꞌ juna itzelilaj uxlabixel quel bi rucꞌ juna ticawex, ri cuꞌano e casutin pa tak luwar catzꞌintzꞌotic re cutzucuj pa cajekiꞌ wi. Yey we na curik taj, cubiꞌij cꞌu chiribil rib: “Quintzelej pe chupa ri wocho, pa xinel lo wi” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ecꞌuchiriꞌ coponic, cuꞌrika rachi pachaꞌ juna ja mesom upa y yijbital chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Queꞌec cꞌut, quebuꞌcꞌama chi lo wukub rach itzel uxlabixel más itzel quiwachlibal chwa rire; y conoje cꞌu riꞌ queboquic y quejekiꞌ chiriꞌ. Jecꞌuriꞌlaꞌ, rubinic rachi más cayojtaj chwa ri petinak lok» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Echiriꞌ cꞌa catajin ri Jesús che ubiꞌxiquil waꞌ, cꞌo jun ixok chiquixoꞌl ruqꞌuiyal winak lic co xchꞌawic, jewaꞌ xubiꞌij che: —Nim ukꞌij ralaxic rixok xyaꞌw e la chwachulew y xtzꞌumtisan e la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Noꞌj ri Jesús xubiꞌij che: —Más nim quikꞌij calaxic ri quetaw re y quecojow re Rutzij Upixab ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Echiriꞌ uqꞌuiyal winak catajin quimolotajic rucꞌ ri Jesús, rire xujek ubiꞌxiquil chique: «Ri ticawex re wakꞌij ora lic itzel quicꞌuꞌx, ma e caquitzꞌonoj canꞌan juna cꞌutubal re ruchukꞌab ri Dios chiquiwach. Noꞌj na cayaꞌtaj ta cꞌu waꞌ chique, ma xew cayaꞌtaj ri cꞌutubal xꞌaniꞌ ojertan rucꞌ ri Jonás. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ma jelaꞌ pachaꞌ ri Jonás xoluꞌana jun cꞌutubal chiquiwach ri aj Nínive, jecꞌuriꞌlaꞌ Ralaxel Chiquixoꞌl Ticawex coluꞌana jun cꞌutubal chiquiwach ri ticawex re wakꞌij ora. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","»Echiriꞌ copon ri kꞌij re kꞌatbal tzij, cayactaj lo ri reina re pa sur y cucoj quimac ri ticawex re wakꞌij ora. Ma rojertan lic naj petinak wi rire chaꞌ coluꞌxiquinaj runaꞌoj ri rey Salomón. Noꞌj ri ticawex re wakꞌij ora, cꞌo jun chiquixoꞌl más cꞌo uwach chwa ri Salomón, yey na queboc tane il che. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","»Jecꞌulaꞌ ri winak aj Nínive re ojertan queyactaj chupa ri kꞌij re kꞌatbal tzij y caquicoj quimac ri ticawex re wakꞌij ora. Ma rique xquitzelej quitzij chwach ri Dios ruma ri tzijonic xuꞌan ri Jonás chiquiwach. Noꞌj ri ticawex re wakꞌij ora, cꞌo jun chiquixoꞌl más cꞌo uwach chwa ri Jonás, yey na queboc tane il che. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","»Na jinta junok echiriꞌ cutzij juna akꞌ, queꞌrewaj lo chupa juna luwar pa na kꞌalaj ta wi. Na cuchꞌuk tane uwiꞌ rucꞌ juna mulul re pajbal; ri cuꞌan che, e cuya lo chupa rucꞌolibal chicaj chaꞌ jelaꞌ cutzij quiwiꞌ ri queboc bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","»Ri kawach e pachaꞌ candil re ri kacuerpo, ma ruma waꞌ cojtzuꞌnic chaꞌ utz cojbinic. Jecꞌulaꞌ, we ri kawach lic utz uꞌanom, ronoje ri kacuerpo nojinak che kꞌijsak y cakil cꞌu ronoje chi utz. Noꞌj we ri kawach na utz taj, ronoje ri kacuerpo cꞌo pa kꞌekuꞌm. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","»Lic cꞌu chajij ib alak; e mabiꞌij alak: “Oj cꞌo pa kꞌijsak”, yey na canaꞌbej ta alak pa kꞌekuꞌm cꞌo wi alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Noꞌj we pakatzij wi cꞌo chi alak pa kꞌijsak y na jinta chi re ri kꞌekuꞌm che alak, riꞌ ronoje cakꞌalajin chiwach alak jelaꞌ pachaꞌ juna candil cutzij ri be alak rucꞌ ruwonibal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ecꞌuchiriꞌ ri Jesús xuqꞌuis cacꞌutunic, xsiqꞌuix ruma jun fariseo chaꞌ queꞌwoꞌka chirocho. Ri Jesús xeꞌec, xoc cꞌu chupa ri ja y xtzꞌuyiꞌ chwa ri mexa. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Echiriꞌ xril waꞌ ri fariseo, lic xcam ranimaꞌ che ma na xuchꞌaj ta nabe rukꞌab jelaꞌ pachaꞌ caquiꞌan che ri quijoskꞌiquil ri fariseos. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ecꞌu ri Kanimajawal jewaꞌ xubiꞌij che: —Ralak alak fariseos lic coc alak il che ri cachꞌaj alak chi utz ri rij ri vaso y ri lak pero na coc ta alak il che uchꞌajic rupa. Jecꞌuriꞌlaꞌ ralak lic coc alak il che ri joskꞌinic re ri cuerpo, pero lic nojinak ri animaꞌ alak che rayinic y che ri na utz taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","»¡Lic na jinta cꞌana naꞌoj alak! Ri Jun xꞌanaw re ri quilitaj che ri cuerpo alak, ¿na e ta neba ri xꞌanaw re ri animaꞌ alak? ");
INSERT INTO acrTNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","We pakatzij wi caꞌaj alak cuꞌan chom ri binic silabic alak chwach ri Kakaw, sipan alak chique ri nibaꞌib rucꞌ ri cꞌo ucꞌ alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","»¡Lic tokꞌoꞌ wach ralak alak fariseos! Lic coc alak il che jujun tzijpixab, ma caya alak che ri Dios ri diezmo re ri arweno, re ri ruda y re ronoje ichaj; noꞌj na caꞌan ta alak ri lic usucꞌ y na cꞌax ta canaꞌ alak ri Dios. Yey ri lic chirajawaxic wi e caꞌan alak ri usucꞌ y cꞌax canaꞌ alak ri Dios, junam rucꞌ ri caya alak ri diezmo alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","»¡Lic tokꞌoꞌ wach ralak alak fariseos, ri lic caꞌan nim che ib alak! Ma lic cucꞌul cꞌuꞌx alak ri catzꞌuyiꞌ alak pa tak sinagogas chupa ri tzꞌulibal que ri lic cꞌo quiwach y lic cucꞌul cꞌuꞌx alak ri cayaꞌ rutzil wach alak pa quilitaj wi alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","»¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab y alak fariseos! Xa queb palaj alak, ma e quechꞌulaj alak ri winak rucꞌ ri cacꞌut alak. Pachaꞌ alak mukubal que animaꞌ na quilitaj taj; ecꞌu ri winak quebicꞌow puwiꞌ y na caquinaꞌbej taj rucꞌ waꞌ caquichꞌulaj quib» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ecꞌuchiriꞌ, jun chique ri e aj cꞌutunel re ri tzijpixab jewaꞌ xubiꞌij che ri Jesús: —Lal tijonel, echiriꞌ cabiꞌij la waꞌ, oj jun riꞌoj cojyaj la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ri Jesús xubiꞌij: «¡Lic tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab! Lic caꞌan alak cꞌax chique ri winak rucꞌ ri takanic alak. Ma wa takanic alak e pachaꞌ nimak tak ekaꞌn lic al y lic cꞌayew rucꞌaxic; quetak cꞌu alak ri winak chaꞌ caquekaj bi yey ralak na caꞌaj tane alak catoꞌb cꞌana alak rucꞌ waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","»¡Lic tokꞌoꞌ wach alak! Ma cayac alak chomilaj mukubal chique ri kꞌalajisanelab xecamisax cuma ri mam alak ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Rucꞌ ri caꞌan alak cakꞌalajisaj alak junam tzij alak cucꞌ ri mam alak. Ma rique na xquicꞌul ta ri e kꞌalajisanelab y xequicamisaj; jenelaꞌ ralak na cata ta alak ri quitzij tzꞌibital canok, tob cayijbaꞌ alak riꞌ ri quimukubal. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","»E uwariꞌche ri Dios, ri lic cꞌo sakil naꞌoj rucꞌ, jewaꞌ cubiꞌij: “Quebenutak bi e kꞌalajisanelab y e takoꞌn chiquiwach wa ticawex. Y chique cꞌu waꞌ wa aj chac weꞌin, cꞌo ri quequicamisaj y cꞌo ri quequiternabej rucꞌ cꞌax” cacha ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ecꞌu uwariꞌche, ri alak ticawex re wakꞌij ora, pawiꞌ alak cꞌo wi ri quiquiqꞌuel ri kꞌalajisanelab ecamisam chwi lo ri jekebal re ruwachulew, ");
INSERT INTO acrTNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","chwi lo rucamic ri Abel cꞌa chwa rucamic ri Zacarías, ri xcamisax chuxoꞌl raltar y ri Rocho Dios. Pakatzij wi cambiꞌij che alak, ri Dios cukꞌat tzij pawiꞌ alak ruma ri quicamic rique. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","»¡Tokꞌoꞌ wach ralak alak aj cꞌutunel re ri tzijpixab! Ma alak latzꞌanel chique ri cacaj caquetaꞌmaj ri Kꞌijsak. Ewam alak rusucꞌ Rutzij Upixab ri Dios, jecꞌulaꞌ na coc ta alak pa ri Kꞌijsak yey na caya tane alak luwar chique ri winak queboquic» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Echiriꞌ ri Jesús catajin che ubiꞌxiquil waꞌ chique, raj cꞌutunel re ri tzijpixab y ri fariseos lic xpe coyowal chirij y xquijeko caquichapalaꞌ rucꞌ uqꞌuiyal tzꞌonobal. ");
INSERT INTO acrTNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lic xquitij riꞌ che chaꞌ rire cubiꞌij ri na usucꞌ taj y rucꞌ waꞌ caquicoj umac. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Catajin quimolotajic uqꞌuiyal winak na jinta chi quitakexic, y ruma waꞌ lic caquiminimaꞌ quib chiquiwach. Ecꞌuchiriꞌ, ri Jesús xujeko cacꞌutunic; nabe xujek cachꞌaꞌt cucꞌ rutijoꞌn, jewaꞌ xubiꞌij chique: «Lic miꞌan iwe pachaꞌ ri caquiꞌan ri fariseos, ma rique xa queb quipalaj. Jelaꞌ pachaꞌ ri levadura cojotal chupa ri kꞌor re pam yey waꞌ na quilitaj taj, jecꞌulaꞌ ri fariseos quewam ri na utz taj pa canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Noꞌj copon ri kꞌij echiriꞌ ronoje ri chꞌukutal uwiꞌ woꞌora, quel lo chi sak; yey ronoje ri caꞌan xa xeꞌlakꞌay, quetaꞌmaxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","E uwariꞌche copon ri kꞌij echiriꞌ janipa ri ibiꞌim riꞌix pa kꞌekuꞌm, quel lo chi kꞌij sak; yey e ri xa iwesewoꞌm pa juna ja, quesax utzijolal pa tak be. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","»Cambiꞌij cꞌu chiwe riꞌix ix wamigos: Mixiꞌij iwib chiquiwach ri cꞌo paquikꞌab quixquicamisaj, ma waꞌ xew che ri cuerpo caquiꞌan wi; yey echiriꞌ ix caminak chic, na jinta chi caquiꞌan chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Cambiꞌij cꞌu chiwe china chwach chirajawaxic wi quixiꞌij iwib: E chixiꞌij iwib chwach ri Jun cꞌo pukꞌab caresaj ricꞌaslemal riꞌix y tecꞌuchiriꞌ quixucꞌak bi chi xibalbaꞌ re tijbal cꞌax. Pakatzij wi e chixiꞌij iwib riꞌ chwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","»Iwetaꞌam woꞌob raltak co tzꞌiquin quecꞌayix xa chwa queb oxib raltak co meyo. Na rucꞌ ta cꞌu riꞌ, ri Dios na cumescꞌutaj ta cꞌana junok chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Macꞌuwariꞌ riꞌix na quixumescꞌutaj ta qꞌuenok, ma chujujunal ne riwiꞌ ajilam ruma Rire. E uwariꞌche, mixiꞌij iwib; ma riꞌix más cꞌo iwach chiquiwa ri raltak co tzꞌiquin. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","»Pakatzij wi cambiꞌij chiwe: E junok cukꞌalajisaj chiquiwach ri winak, cubiꞌij: “In tijoꞌn re ri Jesús”, jecꞌuriꞌlaꞌ canꞌan riꞌin che rire; ri in Alaxel Chiquixoꞌl Ticawex cambiꞌij chiquiwach ri ángeles re ri Dios: “Katzij, wa jun e nutijoꞌn” quinchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Noꞌj cꞌu ri cubiꞌij chiquiwach ri winak: “Riꞌin na in ta tijoꞌn re ri Jesús”, jecꞌuriꞌlaꞌ canꞌan riꞌin che rire; cambiꞌij chiquiwach ri ángeles re ri Dios: “Katzij, wa jun na nutijoꞌn taj” quinchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","»We cꞌo junok cachꞌaꞌt chwij riꞌin, ri in Alaxel Chiquixoꞌl Ticawex, ri Dios cucuy umac we cutzelej utzij. Noꞌj china ri tzel cachꞌaꞌt chirij ri Santowilaj Ruxlabixel ri Dios, riꞌ na cacuytaj ta umac. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","»Mixiꞌij iwib echiriꞌ wuma riꞌin quixcꞌam bi chiquiwach raj wach re ri sinagogas o chiquiwach raj kꞌatal tzij y raj wach re ri tinamit; mubisoj ne icꞌuꞌx saꞌ ri cꞌulubal uwach quiꞌan chique, ");
INSERT INTO acrTNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ma ri Santowilaj Ruxlabixel ri Dios cukꞌalajisaj chiwe saꞌ ri chirajawaxic quibiꞌij» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ecꞌuchiriꞌ, jun chique ruqꞌuiyal winak xubiꞌij che ri Jesús: —Lal tijonel, biꞌij la che ri watz cuya ri takal chwe riꞌin che tak ri cuxtabal quiyaꞌom can ri kachu-kakaw —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ecꞌu ri Jesús xucꞌul uwach: —Achi, ¿china incojoyom re in aj kꞌatal tzij pawiꞌ alak chaꞌ canꞌan wa jachanic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tecꞌuchiriꞌ, xubiꞌij chique ri winak: —Tape alak, lic chajij ib alak chi utz chwach ronoje rayinic, ma na e ta rubeyomalil rachi ri cuya chomilaj cꞌaslemal che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ecꞌuchiriꞌ xutzijoj wa jun cꞌambal naꞌoj chique: «Cꞌo jun achi lic beyom yey ri rulew lic uqꞌuiyal molonic xuyaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ecꞌu ri beyom xuchꞌob rakan chiribil rib: “¿Saꞌ canꞌano? Ma na jinta chi pa cancꞌol wi wuꞌqꞌuiyal molonic xinꞌano.” ");
INSERT INTO acrTNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","»Tecꞌuchiriꞌ xubiꞌij chiribil rib: “E canꞌan waꞌ: Canwulij tak wa cꞌolibal nuꞌanom re molonic y canyac jujun chic más nimaꞌk, chaꞌ chupa cancꞌol wi ri numolonic y tak ri nubeyomalil. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y cambiꞌij cꞌu riꞌ chiwibil wib: Riꞌin lic qꞌui chi ri nubeyomalil cꞌoltalic, waꞌ cucuy re uqꞌuiyal junab. Ecꞌu woꞌora utz quinuxlanic, quinwaꞌic, cantij nuyaꞌ y canꞌan ronoje ri cuaj riꞌin.” ");
INSERT INTO acrTNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","»Noꞌj ri Dios xubiꞌij che: “Achi, lic na jinta cꞌana anaꞌoj. ¡Tokꞌoꞌ awach! Ma e wakꞌab catcamic; yey ronoje cꞌu rabeyomalil acꞌolom, ¿china re canok?” xuchixic. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","»Jecꞌuriꞌlaꞌ cucꞌulumaj juna achi we cucꞌol uqꞌuiyal beyomalil xa riꞌre, pero chwach ri Dios lic nibaꞌ» xcha ri Jesús chique ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tecꞌuchiriꞌ xubiꞌij ri Jesús chique rutijoꞌn: «E uwariꞌche cambiꞌij waꞌ chiwe: Mubisoj icꞌuꞌx ricꞌaslem; mubisoj ne icꞌuꞌx saꞌ ri quitijo y saꞌ rikꞌuꞌ quicojo. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma ri kacꞌaslemal e más cꞌo uwach chwa ri kawa, yey ri kacuerpo e más cꞌo uwach chwa ri kakꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","»Chebiwilape ri joj. Rique na queticoꞌnaj taj, na caquiꞌan tane quimolonic, na jinta ne pa caquicꞌol wi ri quimolonic; na rucꞌ ta cꞌu riꞌ ri Dios quebutzuku. ¡Macꞌuwariꞌ riꞌix, ri Dios quixuchajij! ¡Ma e más cꞌo iwach riꞌix chiquiwa ri tzꞌiquin! ");
INSERT INTO acrTNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","»¿Cꞌo neba junok chiwe riꞌix curik cunajtirisaj jun chic kꞌij che rucꞌaslem wara che ruwachulew? Na jinta junok tob ne lic cutij ukꞌij che. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ruma cꞌu riꞌ, na jinta cutikoj we lic cubisoj icꞌuꞌx ri cajawax chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","»Chiwilapeꞌ suꞌanic caqꞌuiy ri cotzꞌiꞌj pa tak juyub. Waꞌ na cachacun taj y na caqueman ta nenareꞌ chaꞌ cuꞌan rukꞌuꞌ. Yey riꞌin cambiꞌij chiwe: Ri rey Salomón, tob lic cꞌo uchomal rukꞌuꞌ xucojo, waꞌ na xumaj ta cꞌana ruchomalil tak ri cotzꞌiꞌj. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jecꞌulaꞌ we ri Dios uꞌanom chom che ri akꞌes cꞌo wakꞌij pa juyub yey chweꞌk xa caporox pa akꞌ, ¿na cuya ta cami riꞌ ri Dios rikꞌuꞌ cajawax chiwe? ¡Riꞌix lic xa jubikꞌ ri cubulibal icꞌuꞌx rucꞌ ri Dios! ");
INSERT INTO acrTNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","»Cambiꞌij cꞌu chiwe riꞌix: Mubisoj icꞌuꞌx saꞌ riwa y saꞌ rimikꞌinaꞌ quitijo. Mapax ne icꞌuꞌx che, ");
INSERT INTO acrTNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ma jenelaꞌ caquiꞌan ri winak na quetaꞌam ta uwach ri Dios, e cubisoj quicꞌuꞌx tak waꞌ. Noꞌj riꞌix cꞌo jun Ikaw lic retaꞌam cajawax tak waꞌ chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ri lic chirajawaxic chiwe e lic chixoc il che rutakanic ri Dios; yey ronoje tak cꞌu ri cajawaxic, xa uwiꞌ chic cayaꞌtaj chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","»Riꞌix ix nutijoꞌn, muxiꞌij rib icꞌuꞌx che ricꞌaslem, ma riꞌix tob na ix ta qꞌui, ri Kakaw lic caquiꞌcot che cuya chiwe riꞌix quixoc chupa rutakanic y quixtakan rucꞌ Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chicꞌayij ri beyomalil cꞌo iwucꞌ chaꞌ utz quebitoꞌ ri nibaꞌib. Ma we quiꞌan waꞌ, e pachaꞌ quicꞌol ribeyomalil pa na jinta cꞌo cucꞌulumaj wi y jelaꞌ cꞌo cutikoj chiwe chilaꞌ chicaj. Ma e tak ri cꞌo chilaꞌ chicaj na cajar taj, na capoqꞌuir taj, yey na jinta ne elekꞌomab queboc che. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma pa cꞌo wi ribeyomalil riꞌix, puwi waꞌ queꞌec wi icꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","»Lic chiyijbaꞌ iwib, pachaꞌ raj chaquib quiyijbam quib chi utz y tzijtal ri quicandil, ");
INSERT INTO acrTNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ma coyeꞌem ri cajaw catzelej lo pa ri nimakꞌij re cꞌulaniquil. Y jelaꞌ echiriꞌ rire cacꞌunic y cachꞌaw pan chwa ri puerta, caquijakalaꞌ tan lo che. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nim quikꞌij calaxic raj chaquib we xcꞌun lo ri cajaw, queboluꞌrikaꞌ na quewar taj. Pakatzij wi cambiꞌij chiwe, ri cajaw quebucoj chwa mexa y quebunimaj chiquijujunal. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lic nim quikꞌij calaxic raj chaquib, tob ri cajaw xmayinic, we xcꞌun lo pa tiqꞌuil akꞌab o pa sakribal, queboluꞌrikaꞌ na quewar taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ecꞌu chiwetaꞌmaj waꞌ: Juna achi rajaw ja, we ta caretaꞌmaj ri ora echiriꞌ copon relekꞌom, riꞌ na cawar ta qꞌuenok y na cuya ta luwar carakix ri rocho re caꞌan elekꞌ chupa. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jecꞌulaꞌ riꞌix chiyijbaꞌ iwib che rucꞌunibal Ralaxel Chiquixoꞌl Ticawex, ma cꞌaxtaj cacꞌunic echiriꞌ na jinta inaꞌbem» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ecꞌuchiriꞌ, ri Pedro xutzꞌonoj che ri Jesús: —Kajawal, ¿xew chike riꞌoj cabiꞌij la wa cꞌambal naꞌoj o chique conoje ri winak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ecꞌu ri Kanimajawal xucꞌul uwach: «¿Chinok chiwe riꞌix e pachaꞌ juna aj chac lic jusucꞌ y cꞌo unaꞌoj, yaꞌtal pukꞌab quebutzuk chupa ruꞌorayil conoje ri e cꞌo pa rocho rupatrón? ");
INSERT INTO acrTNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lic cꞌu nim ukꞌij ralaxic riꞌ ri aj chac, we xcꞌun lo rupatrón, coluꞌrikaꞌ catajin che uꞌanic ruchac. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Pakatzij wi cambiꞌij chiwe: Rupatrón cuꞌana takanel che rire puwi ronoje rubitak re. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","»Noꞌj we waꞌ wa jun aj chac jewaꞌ cubiꞌij pa ranimaꞌ: “Ri nupatrón cꞌamajaꞌ catzelej lok” y cujek cꞌu lic quebuchꞌay raj chaquib chi achijab chi ixokib; yey ecꞌu rire xew cawaꞌic y cakꞌabaric, ¿saꞌ nawi riꞌ ri caꞌan che? ");
INSERT INTO acrTNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Cacꞌun lo riꞌ rupatrón chupa ri kꞌij y ri ora echiriꞌ waꞌ wa aj chac na royeꞌem taj. Cukꞌat cꞌu tzij puwi ri raj chac y lic cuya pa cꞌax junam cucꞌ conoje ri na e ta jusucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","»Ecꞌu juna aj chac, we retaꞌam saꞌ ri caraj rupatrón pero na cucoj ta utzij y na cuꞌan ta ri biꞌim che, riꞌ lic caꞌan cꞌax che. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Noꞌj juna aj chac cuꞌan ri na utz taj yey na retaꞌam ta cꞌut we na utz ta ri cuꞌano, riꞌ na lic ta cꞌax caꞌan che. Ma china ri lic cꞌo yaꞌtal chukul, chikawach apanok lic cꞌo royeꞌem ri Dios che; yey china ri lic qꞌui yaꞌtal pukꞌab, más ne royeꞌem ri Dios che chwa ri royeꞌem che ri jun na lic ta qꞌui ri yaꞌtal pukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","»Pachaꞌ akꞌ ri coꞌlnuquikꞌa che ruwachulew. ¡Ecꞌu ri canrayij riꞌin ta asu cumaj akꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lic cꞌu chirajawaxic quinicꞌow na chupa jun unimal cꞌaxcꞌobic. ¡Na quicꞌow ta ri bis chinucꞌuꞌx, cꞌa echiriꞌ quinicꞌow chupa waꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E chiwach riꞌix, ¿ri nucꞌunic che ruwachulew cucꞌam lo utzil chomal? Na e ta riꞌ. Ma pakatzij wi cambiꞌij e cucꞌam lo jachbal quipa tak ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chwi woꞌora y chikawach apanok we e cꞌo woꞌobok pa juna ja, wuma riꞌin cꞌo pa sak caquijach quipa; ma oxib quechꞌoꞌjin cucꞌ caꞌib y caꞌib quechꞌoꞌjin cucꞌ oxib. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Quechꞌoꞌjin chiquiwach rachi rucꞌ rucꞌajol, rixok rucꞌ ri ralit y ruchu-ralib rucꞌ ralibatz» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yey xubiꞌij ri Jesús chique ruqꞌuiyal winak: «Echiriꞌ quil alak ri sutzꞌ quel lo pukajibal ri kꞌij, xew quil alak y cabiꞌij alak: “Cape jab” y e cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y echiriꞌ cajum caꞌn ri tew cape lo pa sur, cabiꞌij alak: “Lic cuꞌan buc” y e cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Xa queb palaj alak! Carik alak uchꞌobic chi utz saꞌ ruꞌanom ruwa caj y ruwachulew; ¿suꞌchac cꞌu riꞌ na camaj tane alak usucꞌ ri catajin ri Dios che ucꞌutic chiwach alak wakꞌij ora? ");
INSERT INTO acrTNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","»¿Suꞌchac na cachꞌob ta alak chi utz saꞌ ri lic usucꞌ chirajawaxic caꞌan alak? ");
INSERT INTO acrTNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","We cacꞌam bi la pa kꞌatbal tzij ruma junok ucojom mac chiꞌij la, e lic utz ri caꞌan la utzil chomal rucꞌ pa be xalokꞌ cꞌamajaꞌ copon la chwa ri aj kꞌatal tzij. Ma we na xꞌan ta la waꞌ, copon na la chwach ri aj kꞌatal tzij. Y we xopon cꞌu la chwach rire, cayaꞌ bi la pukꞌab ri ausiliar y rire cuꞌyaꞌa la pa cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Cambiꞌij cꞌut, na quel ta lo la chiriꞌ we na xtoj ta can la ronoje ri tzꞌonom chiꞌij la» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chupa waꞌ wa kꞌij e cꞌo jujun chiriꞌ xquitzijoj che ri Jesús saꞌ ri xquicꞌulumaj jujun aj Galilea, ri xecamisax ruma utzij ri takanel Pilato echiriꞌ quetajin che uyaꞌic ri quikasaꞌn re chicop chwa ri altar pa ri Rocho Dios. Yey ri quiquiqꞌuel waꞌ wa aj Galilea xquich caꞌn puwi ri quiquiqꞌuel ri chicop. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ecꞌu ri Jesús xucꞌul uwach: —¿E cachꞌob nawi alak, waꞌ wa aj Galilea xecamisaxic ma e más e aj maquib chiquiwa ri cach aj Galilea? ");
INSERT INTO acrTNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Pakatzij wi cambiꞌij che alak, na e ta riꞌ. Yey ralak, we na catzelej ta tzij alak chwach ri Dios, e ne jun ralak casach wach alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","»¿O saꞌ nawi cachꞌob alak puwi ri xquicꞌulumaj ri e dieciocho, ri xecamic echiriꞌ xtzak lo ri Torre re Siloé paquiwiꞌ? ¿E cachꞌob nawi alak, wa winak xecamic ma cꞌo más quimac chiquiwa ri cach aj Jerusalem? ");
INSERT INTO acrTNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Pakatzij wi cambiꞌij che alak, na e ta riꞌ. Yey ne ralak, we na catzelej ta tzij alak chwach ri Dios, e ne jun ralak casach wach alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Xutzijoj cꞌu wa jun cꞌambal naꞌoj chique: «Cꞌo jun achi uticom jun cheꞌ re higo chupa ruticoꞌn. Xcꞌun cꞌu lok re coluꞌtzucuj ujikꞌobalil ri higo yey na jinta xurik che. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Xubiꞌij cꞌu che ri chajinel re ruticoꞌn: “Chawilapeꞌ, e urox junab waꞌ quincꞌunic coꞌlnutzucuj ujikꞌobalil wa cheꞌ re higo, yey na jinta cꞌana ujikꞌobalil canriko. Woꞌora chacheta bi ma ¿saꞌ cutikoj cꞌo chupa waꞌ wuꞌlew?” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ecꞌu ri chajinel xubiꞌij che: “Wajaw, yaꞌa chi la wa junab che, ma cantij chi na ukꞌij cancꞌot rij y cancoj abono chuxeꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Cꞌaxtaj cuya ujikꞌobalil; noꞌj we na xuya taj, cꞌa ecꞌuchiriꞌ utz cachet bi” xchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun kꞌij re uxlanibal ri Jesús cacꞌutun chupa jun sinagoga. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Cꞌo cꞌu jun ixok chiriꞌ e dieciocho lo junab riꞌ lic cꞌuyuqꞌuic uꞌanom ri rij ruma jun itzel uxlabixel, yey na utz ta ne cusucꞌupij rib. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Y ri Jesús echiriꞌ xril rixok, xusiqꞌuij apanok y jewaꞌ xubiꞌij che: —Ixok, lal cunutajinak chi che ri yabil cꞌo wi la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya rukꞌab puwi rixok; y chupa cꞌu laꞌ la jokꞌotaj rixok xsucꞌupitajic y xujeko cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ecꞌu ri takanel re ri sinagoga lic xpe royowal chirij ri Jesús ma xcunan chupa ri kꞌij re uxlanibal, y xubiꞌij cꞌu chique ri winak: —Cꞌo wakib kꞌij re chac; chupa waꞌ utz cape alak re cacunax bi alak, pero lic na ube taj cacunax alak chupa ri kꞌij re uxlanibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ecꞌu ri Jesús xubiꞌij: —¡Xa queb palaj alak! Onoje ralak ¿na caquir ta neba alak ri boyex y ri buru chupa ri kꞌij re uxlanibal chaꞌ cacꞌam bi alak chi tijoj yaꞌ? Caꞌan ne alak waꞌ chique yey xa e awaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Macꞌuwariꞌ takal che wiꞌxok catoꞌic, ma rire ralcꞌoꞌal can ri Abraham, yey e dieciocho lo junab waꞌ “yututal” ruma ri Satanás. ¿Na utz ta cami riꞌ quesax chupa ri yabil pa ri kꞌij re uxlanibal? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Echiriꞌ xubiꞌij waꞌ ri Jesús, lic xeqꞌuix conoje ri tzel quebilow re; noꞌj conoje ri winak lic quequiꞌcot ruma ri cꞌutubal re runimal uchukꞌab ri Dios cuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ecꞌuchiriꞌ, xubiꞌij tanchi ri Jesús: «¿Saꞌ rucꞌ cajunimax wi rutakanic ri Dios? ");
INSERT INTO acrTNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Riꞌin canjunimaj rucꞌ juna ijaꞌ re moxtasa, ri xcꞌam bi ruma jun achi y xtiquiꞌ chupa ri werta. Ecꞌu riꞌ waꞌ xqꞌuiyic y lic xuꞌan bojobic; yey ri tzꞌiquin quexiqꞌuicꞌ che ruwa caj xquiꞌan quisoc puwi tak rukꞌab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y xubiꞌij tanchi ri Jesús: «¿Saꞌ rucꞌ canjunimaj wi rutakanic ri Dios? ");
INSERT INTO acrTNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E jelaꞌ pachaꞌ ri levadura, ma echiriꞌ juna ixok cuꞌan pam, cutuc jubikꞌ levadura xoꞌlibal oxib pajbal harina y ri levadura cusipowirisaj upa ronoje ri kꞌor» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Echiriꞌ ri Jesús cꞌo chi be re queꞌec Jerusalem, xicꞌow pa tak tinamit y pa tak aldeas, e riꞌ cacꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y cꞌo cꞌu jun xbiꞌn che: —Wajawal, ¿xa nawi jujun ri quecolobetajic? —xcha che. Y ri Jesús xucꞌul uwach: ");
INSERT INTO acrTNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Lic chichꞌiquiquej iwib chaꞌ quixoc chupa ri nutakanic che ri oquibal xa chꞌutiꞌn uwach, ma cambiꞌij chiwe: Copon na ri kꞌij echiriꞌ lic e qꞌui ri cacaj queboc bi, noꞌj na cayaꞌtaj ta chique queboc bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","»Ma e cuꞌana pachaꞌ ri rajaw juna ja echiriꞌ cuꞌan juna nimakꞌij. Echiriꞌ eboquinak chi conoje ri ebusiqꞌuim, cutzꞌapij lo ri puerta, y na jinta chi cꞌu junok coquic. Jecꞌulaꞌ riꞌ ri quicꞌulumaj riꞌix, na quixoc ta chubi. Quijek cꞌu riꞌ quixchꞌaw apanok: “Kajaw, Kajaw, yaꞌa co la chike cojoc bi” quixchaꞌ. »Yey Rire jecꞌuwaꞌ cucꞌul lo uwach chiwe: “Riꞌin na wetaꞌam taj pa ix petinak wi riꞌix” cacha chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","»Ecꞌuchiriꞌ, quijek ubiꞌxic: “Oj waꞌ cꞌu woꞌkinak ucꞌ la yey xcꞌutun ne la pa tak ri be re ri katinamit” quixcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","»Noꞌj Rire cubiꞌij lo chiwe: “Pakatzij wi, riꞌin na wetaꞌam taj pa ix petinak wi riꞌix. Chixela chinuwach, iwonoje ri ix ꞌanal re ri lic itzel uwach” cacha chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","»Ecꞌuchiriꞌ, lic quixokꞌic y cakichꞌichꞌ ruwi iweꞌ echiriꞌ quebiwil ri Abraham, ri Isaac y ri Jacob cucꞌ conoje ri kꞌalajisanelab e cꞌo rucꞌ ri Kakaw pa rutakanic chilaꞌ chicaj; yey ecꞌu riꞌ riꞌix na jinta pikꞌab quixoc bi cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Noꞌj e cꞌo ri na e ta aj judiꞌab e petinak pa relebal lo ri kꞌij, putzakibal ri kꞌij y pa ronoje luwar che ruwachulew, riꞌ queboc chwa ri mexa pa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","»Chiwilape cꞌu riꞌ, ma e cꞌo jujun chique ri na jinta quiwach wara che ruwachulew, e lic cacꞌojiꞌ quiwach chwach ri Dios chilaꞌ chicaj; yey e cꞌo ri lic cꞌo quiwach wara che ruwachulew, e cuꞌana na jinta quiwach chwach ri Dios chilaꞌ chicaj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chupa cꞌu waꞌ wa kꞌij xekib jujun fariseos rucꞌ ri Jesús y jewaꞌ xquibiꞌij che: —Chelubi la y oj la ma ri rey Herodes caraj cucamisaj la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Y ri Jesús xubiꞌij chique: —Oj alak y jeꞌbiꞌij alak che laꞌ laꞌchi, ri e pachaꞌ juna yac: “Wakꞌij y chweꞌk cꞌa quebenuwesaj bi ri itzel uxlabixel y canꞌan cunanic yey cabij cꞌut canqꞌuis ri nuchac” cacha alak che. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero che cꞌu woꞌxib kꞌij chirajawaxic wi cambinibej pan nube quinꞌec, ma na takal ta che juna kꞌalajisanel cacam cꞌa naj che Jerusalem —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tecꞌuchiriꞌ xubiꞌij: «¡Jerusalem, Jerusalem, riꞌix quebicamisaj ri kꞌalajisanelab y quebiꞌan paꞌbaj janipa ri ebutakom lo ri Dios iwucꞌ! E riꞌin uqꞌuiyal laj lic xuaj xinmol quichiꞌ riwalcꞌoꞌal riꞌix jelaꞌ pachaꞌ cuꞌan juna atiꞌ acꞌ chique tak ruwiꞌch echiriꞌ cumol quichiꞌ chuxeꞌ tak ruxicꞌ, noꞌj riꞌix na xiwaj ta qꞌuenok. ");
INSERT INTO acrTNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","»Chitape cꞌut, cꞌo jun kꞌij echiriꞌ ri iwocho riꞌix cawulix canok. Cambiꞌij cꞌu chiwe na quiwil ta chi nuwach cꞌa echiriꞌ copon na rukꞌijol quibiꞌij: Lic nim ukꞌij ri jun petinak chupa rubiꞌ ri Dios Kajawxel quixchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E xuꞌan waꞌ chupa jun kꞌij re uxlanibal: Ri Jesús xsiqꞌuix ruma jun fariseo lic cꞌo uwach chaꞌ queꞌwoꞌk chirocho. Y chilaꞌ e cꞌo jujun chique ri fariseos lic quicꞌacꞌalem we ri Jesús cacunan pa ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma chiriꞌ chwach Rire cꞌo jun achi lic yewaꞌ, waꞌlijinak rucuerpo. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ecꞌuchiriꞌ, ri Jesús xutzꞌonoj chique ri fariseos y raj cꞌutunel re ri tzijpixab, jewaꞌ xubiꞌij: —¿Ube nawi ri caꞌan cunanic chupa ri kꞌij re uxlanibal o na ube taj? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero rique na jinta xquicꞌulubej uwach. Ecꞌu ri Jesús xuya rukꞌab puwi ri yewaꞌ, xucunaj y xubiꞌij che utz queꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tecꞌuchiriꞌ xubiꞌij chique: —¿Cꞌo neba junok che alak, we rucawayuꞌ o ruboyex catzak pa siwan, na queꞌresalaꞌ tulok tob chupa jun kꞌij re uxlanibal? ¿China na caꞌanaw ta waꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ecꞌu rique na xquirik ta ucꞌulic uwach che. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ecꞌu ri Jesús xrilo saꞌ ri caquiꞌan ri esiqꞌuim pa ri waꞌim, conoje caquimajalaꞌ quib puwi tak ri tzꞌulibal que ri lic cꞌo quiwach. E uwariꞌche, xubiꞌij wa cꞌambal naꞌoj chique ri echocom: ");
INSERT INTO acrTNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Echiriꞌ casiqꞌuix la ruma junok pa juna nimakꞌij re cꞌulaniquil, na ube taj we queꞌtzꞌula la chupa ri tzꞌulibal que ri lic cꞌo quiwach; ma cꞌaxtaj cacꞌun lo junok chocom más cꞌo uwach chiwach rilal. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yey cakib cꞌu riꞌ ri rajaw ri nimakꞌij ucꞌ la y cubiꞌij cheꞌla: “Yaꞌa can la wa tzꞌulibal che wa jun chic” cachaꞌ. Ruma cꞌu laꞌ, cape ri qꞌuix la y queꞌtzꞌula lo la cꞌa chirij. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","»E uwariꞌche, ri chirajawaxic caꞌan la echiriꞌ casiqꞌuix la pa juna waꞌim e waꞌ: We xopon la, meꞌtzꞌula la chupa ri tzꞌulibal que ri lic cꞌo quiwach. Jelaꞌ echiriꞌ cacꞌun lo ri siqꞌuiyom e la, jewaꞌ cubiꞌij cheꞌla: “Wamigo, jeꞌtzꞌula la más chwach” cachaꞌ. Jecꞌulaꞌ catacꞌabax kꞌij la chiquiwach ri e cꞌo chwach ri mexa ucꞌ la. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ma china ri cuꞌan lic nim che rib, ri Dios cukasaj uwa ukꞌij; noꞌj china ri cuꞌan chꞌutiꞌn che rib, ri Dios cuyac ukꞌij» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tecꞌuchiriꞌ, xubiꞌij che ri fariseo, ri siqꞌuiyom re pa ri waꞌim: —Echiriꞌ caꞌan la juna waꞌim, na xew ta quesiqꞌuij la ri amigos la, ri e atz-chakꞌ la, ri e cꞌo chux cheꞌla y ri beyomab e cꞌo lo chi nakaj la. Ma we caꞌan la waꞌ, rique caquiꞌan ucꞌaxel cheꞌla, caquisiqꞌuij la pa juna waꞌim y jecꞌuriꞌlaꞌ asu cacꞌul la ri tzelebal uwach che ri xꞌan la. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","»E uwariꞌche, ri chirajawaxic caꞌan la echiriꞌ caꞌan la juna nimakꞌij, e chebesiqꞌuij la ri nibaꞌib, ri tꞌum cakan quikꞌab, ri e sic y ri e potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jecꞌuriꞌlaꞌ nim kꞌij alaxic la, ma rique na caquichꞌij ta uyaꞌic ucꞌaxel cheꞌla; pero e cacꞌul la ri rajil ucꞌaxel echiriꞌ quecꞌastaj lo ri lic e jusucꞌ chwach ri Dios —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Echiriꞌ xuta waꞌ jun chique ri etzꞌul chwa ri mexa, jewaꞌ xubiꞌij che: «¡Nim ukꞌij ralaxic china ri cawaꞌ pa ri nimalaj nimabal cuya ri Dios pa rutakanic!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ecꞌu ri Jesús xubiꞌij che: «Julaj cꞌo jun achi xuchꞌobo cuya jun nimalaj nimabal y lic e qꞌui ri xebusiqꞌuij. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ecꞌuchiriꞌ xopon ru orayil ri nimabal, xutak bi jun raj chac chaꞌ cubiꞌij chique ri echocom chic: “Peta cꞌu alak ma yijbital chi ronoje” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","»Noꞌj chiquijujunal xquijek caquitzꞌonoj cuybal quimac ruma na quebec taj. Ri nabe xubiꞌij: “Xinlokꞌ co juchꞌakap wulew y lic chirajawaxic quiꞌnwilaꞌ. Chabiꞌij co che rapatrón chucuyu numac ma na quinꞌec taj” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","»Ri jun chic xubiꞌij: “Xinlokꞌ co woꞌob yunta boyexab y ecꞌu waꞌ quiꞌntija quikꞌij pa chac. Chabiꞌij co che rapatrón chucuyu numac ma na quinꞌec taj” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","»Yey jun chic xubiꞌij: “Riꞌin lic cꞌacꞌ xincꞌuliꞌic; y ruma laꞌ na quinꞌec taj” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","»Echiriꞌ xtzelej lo raj chac, xubiꞌij ronoje waꞌ che rupatrón. Ecꞌu rupatrón lic xpe royowal y xubiꞌij che ri raj chac: “Chokꞌotan riꞌ, jat pa tak cꞌaybal y pa tak be re ri tinamit y chebacꞌama lo ri e nibaꞌib, ri tꞌum cakan quikꞌab, ri e potzꞌ y ri e sic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","»Xeꞌec cꞌu raj chac. Y echiriꞌ xtzelej lok, xubiꞌij che rupatrón: “Wajaw, ya xinꞌan ronoje ri xintak la che; na rucꞌ ta cꞌu riꞌ, lic cꞌa cꞌo luwar chwa tak ri mexa” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","»Xubiꞌij tanchi cꞌu rachi che ri raj chac: “Chatelubi tzaꞌm tinamit y jat pa tak nimabe y pa tak cuxcul be. Chamina uwach chique ri winak chaꞌ quepetic y jelaꞌ canoj uwa tak ri mexa nuyijbam chic re wa nimabal. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yey pakatzij wi cambiꞌij chawe: Na jinta junok chique ri xenusiqꞌuij nabe, cutij re ri nimabal nuyijbam” xchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Echiriꞌ ri Jesús cꞌo chi be, uqꞌuiyal winak eteran chirij. Ecꞌu Rire xtzuꞌn chirij y jewaꞌ xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«We cꞌo junok caraj caterej lo chwij, lic chirajawaxic che más cꞌax quinunaꞌ riꞌin chiquiwa conoje, ma we e más cꞌax quebunaꞌ ruchu-ukaw, ri rixokil, ri ralcꞌoꞌal, ri ratz-uchakꞌ y más ne cꞌax cunaꞌ rib rire chinuwa riꞌin, riꞌ na takal ta che cuꞌan nutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","E uwariꞌche, china ri na cuya ta ranimaꞌ cutij cꞌax ruma ri caterej lo chwij, riꞌ na takal ta che cuꞌan nutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","»Ma we cꞌo junok caraj cuꞌan nutijoꞌn, lic chuchꞌobo na rakan we cucuy ri cꞌaxcꞌobic cape puwiꞌ ruma ri caterej lo chwij. »E jelaꞌ pachaꞌ ri caꞌanic echiriꞌ cayac juna nimalaj ja. Ma ¿cꞌo neba junok che alak na cuchꞌob ta rakan chi utz nabe na puwi ri cajawax che chaꞌ cuyac ri ja y carajilaj na cꞌu riꞌ janipa ri cumaj bi chaꞌ caretaꞌmaj we xakareꞌ cuchꞌij uyaquic ri ja? ");
INSERT INTO acrTNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma we na cuꞌan ta waꞌ, echiriꞌ uticom chi cꞌu ruparakan ri ja, cuchakabaꞌ uꞌaniquil ruma na jinta chi puak re cuqꞌuiso; yey conoje cꞌu riꞌ ri quebilow re, caquijek caquichꞌamij, ");
INSERT INTO acrTNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","caquibiꞌij: “Waꞌchi xujek uyaquic wa ja, yey na xuqꞌuis ta chic” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","»Jecꞌulaꞌ ¿saꞌ nawi cuꞌan juna rey xa e lajuj mil rusoldados chwa juna chic rey petinak pa chꞌaꞌoj chirij rucꞌ veinte mil soldados? Ri cuꞌano e nabe na cuchꞌob na rakan chi utz we xakareꞌ cuchꞌij uchukꞌab ri jun chic rey e cꞌo más usoldados. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y we cuchꞌobo na cuchꞌij taj, ri cuꞌano e xalokꞌ cꞌa naj cꞌo wi lo ri jun chic rey, quebutak cꞌu bi achijab chaꞌ queꞌquiꞌana ri utzil chomal rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jecꞌuriꞌlaꞌ, we cꞌo junok che alak caraj caterej lo chwij, lic chirajawaxic che cuya can ronoje ri cꞌo rucꞌ; ma we na cuꞌan ta waꞌ, na takal ta che cuꞌan nutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","»E ratzꞌam lic cajawaxic; noꞌj we xsach rutzayul, ¿suꞌanic tanchi caꞌan tza che? ");
INSERT INTO acrTNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma na curik ta uchac che rulew y na utz ta ne caꞌan abono rucꞌ. Ecꞌu ri caꞌan che, e catix bi. China cꞌu ri cꞌo utanibal che utayic, ¡chuta cꞌu riꞌ!» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Conoje raj tzꞌonol puak re tojonic y tak raj maquib quekib rucꞌ ri Jesús chaꞌ caquita ruchꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pero ri fariseos y raj cꞌutunel re ri tzijpixab lic caquichꞌaꞌtibej, jewaꞌ caquibiꞌij: «Waꞌchi quebucꞌul raj maquib y cawaꞌ cucꞌ» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","E uwariꞌche ri Jesús xutzijoj wa jun cꞌambal naꞌoj chique, jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«¿Saꞌ nawi cuꞌan junok che alak we e cꞌo jun ciento ubexex yey casach cꞌu junok chique? ¿Na quebucꞌol ta neba can riꞌ ri noventa y nueve pa ri quiluwar y queꞌec cꞌu che utzucuxic ri jun xsach canok? Yey na cuxlan ta che utzucuxic cꞌa echiriꞌ cuꞌrika lok. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ecꞌuchiriꞌ curiko, lic caquiꞌcotic cuya lo chirij ukul. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y echiriꞌ copon chirocho, cumol quichiꞌ ri ramigos y ri ratz-uchakꞌ, y jewaꞌ cubiꞌij chique: “Chixquiꞌcota wucꞌ ma xinrik ri nubexex sachinak” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","»Cambiꞌij cꞌu riꞌin che alak: Más ne cꞌo quiꞌcotemal chilaꞌ chicaj ruma juna aj mac cutzelej utzij chwach ri Dios, chiquiwa noventa y nueve jusucꞌ e cꞌolic y na cajawax taj cacuytaj quimac. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","»We e laꞌ juna ixok cꞌo lajuj sakil puak rucꞌ yey cutzak cꞌu junok, ¿saꞌ ri cuꞌano? Cutzij akꞌ y naꞌl cumes rupa ja, cutzucuj cꞌu coqꞌuil yey na cuxlan ta che utzucuxic cꞌa echiriꞌ cuꞌrika lok. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y ecꞌuchiriꞌ urikom chic, cumol quichiꞌ ri ramigos y ri ratz-uchakꞌ y cubiꞌij cꞌu chique: “Chixquiꞌcota wucꞌ ma xinrik wa sakil puak nutzakom” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Cambiꞌij cꞌu riꞌin che alak: Jelaꞌ ri quiꞌcotemal que ri ángeles chwach ri Dios echiriꞌ juna aj mac cutzelej utzij» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Xutzijoj cꞌu wa jun cꞌambal naꞌoj chique, jewaꞌ xubiꞌij: «Cꞌo jun achi e cꞌo caꞌib ucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jun kꞌij ri chakꞌixel xubiꞌij che rukaw: “Tat, jacha la upa ri beyomalil la y asu yaꞌa la janipa ri takal chwe riꞌin” xcha che rukaw. Y rukaw e xuꞌano. Xujach cꞌu rubeyomalil, xuya ri takal che rucꞌajol atzixel y ri takal che ri chakꞌixel. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","»Cꞌamajaꞌ cꞌu naj ujachic upa, rala chakꞌixel xucꞌayij ronoje ri xyaꞌ che, xumol bi uchiꞌ ri puak y xeꞌec naj chupa jun chic tinamit. Chilaꞌ cꞌu riꞌ xutzꞌilaꞌ ronoje rubeyomalil, ma xuꞌan rucꞌ ri puak ronoje ri xraj rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ecꞌuchiriꞌ xuqꞌuis ronoje rurajil, xpe jun nimalaj numic chupa laꞌ la tinamit pa cꞌo wi. Y xujek lic cutij cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","»Xeꞌec cꞌut che utzucuxic uchac rucꞌ jun achi aj chilaꞌ. Yey rachi xutak bi pa juyub che quichajixic uqꞌuiyal ak. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ecꞌu rala xujek lic canumic, curayij uwach tob ne e ri quechaꞌ ri ak, pero na jinta junok cayaꞌw re che. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","»Tecꞌuchiriꞌ, xcꞌun runaꞌoj y chiribil rib xuchꞌob rakan: “Chilaꞌ chirocho ri nukaw lic cꞌo caquitij ruqꞌuiyal mocom; yey riꞌin wara quincam che numic. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ecꞌu woꞌora quintzelej chirocho ri nukaw y jewaꞌ cambiꞌij che: Tat, in macuninak chwach ri Dios y chiwach rilal. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na takal ta chic cabiꞌx chwe in cꞌajol la. ꞌAna la chwe pachaꞌ xa in chi jun mocom la” xcha chiribil rib. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y ecꞌu xuꞌano. Xumaj bi ube chirocho rukaw. »Ecꞌu rukaw, echiriꞌ xril pana rucꞌajol chinimanaj, lic xjuchꞌ caꞌn pa ranimaꞌ. Lic cꞌu riꞌ canic xeꞌec y xuꞌcꞌulu apanok. Xulakꞌapuj y xutzꞌub uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","»Y rala xubiꞌij che rukaw: “Nukaw, in macuninak chwach ri Dios y chiwach rilal. Na takal ta chic cabiꞌx chwe in cꞌajol la” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","»Pero rukaw xubiꞌij chique ri raj chaquib: “Jiꞌwesalaꞌ lo ri cꞌul más chom y chiwikaꞌ. Chicojo juna mapakꞌab che ruwi ukꞌab y uxajab che ri rakan. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yey jiꞌcꞌama lo ri mekꞌ lic tiꞌoꞌjirisam y chicamisaj. Katija cꞌu riꞌ, chojquiꞌcotok y kaꞌana nimakꞌij, ");
INSERT INTO acrTNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ma wa nucꞌajol e junam rucꞌ caminak chic yey woꞌora xcꞌastaj lok. Rire sachinak chic pero xrikitajic” xcha chique. Y xquijeko lic quequiꞌcotic. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","»Ecꞌu rucꞌajol atzixel benak pa juyub; yey echiriꞌ xcꞌun lo chunakaj ri ja, xuta ri música lic catꞌikowic y ri quexajaw pa ri nimakꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xusiqꞌuij cꞌu pan jun chique raj chaquib y xutzꞌonoj che saꞌ ri catajinic. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","»Raj chac xubiꞌij che: “Xcꞌun ri chakꞌ la. Ruma cꞌu laꞌ, ri kaw la lic xquiꞌcot che ma utz uwach xcꞌunic, na jinta cꞌo xucꞌulumaj. E uwariꞌche, xutak ucamisaxic ri mekꞌ tiꞌoꞌjirisam chaꞌ cakaꞌan nimakꞌij” xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","»Ecꞌu ri atzixel lic xpe royowal y na xraj taj coc bi. Xel na cꞌu lo rukaw y lic xelaj che chaꞌ coc bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Noꞌj rire xucꞌul uwach, jewaꞌ xubiꞌij che rukaw: “Rilal etaꞌam la janipa lo junab waꞌ in chacuninak ucꞌ la y na nupalajim ta tzij la julajok. Na rucꞌ ta cꞌu riꞌ, na yaꞌom tane la chwe tob xa juna ralco nucaprux chaꞌ canꞌan nimakꞌij y quinquiꞌcot cucꞌ ri wamigos. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yey ecꞌu woꞌora xcꞌun wa jun cꞌajol la, ri xa xuꞌtzꞌilaꞌ lo ri puak la cucꞌ ixokib na chom ta quibinic; na rucꞌ ta cꞌu riꞌ, ruma rire, xtak la ucamisaxic ri mekꞌ tiꞌoꞌjirisam” xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","»Ecꞌu rukaw xubiꞌij che: “Nucꞌajol, riꞌat ronoje kꞌij at cꞌo wucꞌ, yey rubitak we, ronoje aweꞌat chic. ");
INSERT INTO acrTNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Noꞌj woꞌora lic chirajawaxic wi cakaꞌan nimakꞌij y cojquiꞌcotic, ma waꞌchakꞌ e junam rucꞌ caminak chic yey woꞌora xcꞌastaj lok. Rire sachinak chic pero xrikitajic” xchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ecꞌu ri Jesús xutzijoj waꞌ chique rutijoꞌn: «Cꞌo jun achi beyom y rire cꞌo jun raj chac chajinel re ronoje rubitak re. Xopon cꞌu ubiꞌxiquil che ri beyom, ri raj chac catajin bi che uqꞌuisic rubeyomalil. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ecꞌu ri beyom xusiqꞌuij ri raj chac y jewaꞌ xubiꞌij che: “¿Saꞌ waꞌ wa canta chawe? Ma xbiꞌx chwe, riꞌat e catzꞌilaꞌ rubitak we. Ruma cꞌu riꞌ, woꞌora na at ta chi chajinel chwi rubitak we, pero chayaꞌa can chwe chucholaꞌj tzꞌibital chwa wuj saꞌ ri xaꞌan rucꞌ tak ri nuyaꞌom pakꞌab” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","»Ewi ri raj chac xuchꞌob rakan: “¿Saꞌ ri canꞌan woꞌora? Ma ri wajaw caresaj ri nuchac chwe. Yey riꞌin na cancuy taj quinchacun pa juyub y quinqꞌuix che cantzꞌonoj limoxna. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah! Wetaꞌam chic saꞌ ri canꞌano chaꞌ e cꞌo wamigos quecꞌuluw weꞌin chicocho echiriꞌ na jinta chi nuchac” xcha pa ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","»Xebusiqꞌuij cꞌu chiquijujunal ri cꞌo quicꞌas rucꞌ ri rajaw. Xutzꞌonoj che ri nabe: “¿Janipa racꞌas rucꞌ ri wajaw?” xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","»Y raj cꞌas xucꞌul uwach: “Nucꞌas jun ciento tenaꞌx aceite” xcha che. »Y raj chac xubiꞌij che: “Riꞌ ruwujil racꞌas. Chokꞌotan chat-tzꞌulok, chayojo ri jun ciento y chacojo xa nicꞌaj ciento chic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","»Tecꞌuchiriꞌ, xutzꞌonoj che jun chic: “Y riꞌat, ¿janipa racꞌas?” xchaꞌ. »Y raj cꞌas xubiꞌij: “Nucꞌas jun ciento quintal trigo” xchaꞌ. »Y raj chac xubiꞌij che: “Riꞌ ruwujil racꞌas. Chayojo ri jun ciento y chacojo xa ochenta quintal chic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","»Ecꞌu ri rajaw, echiriꞌ xretaꞌmaj saꞌ ri xuꞌan ri raj chac, jewaꞌ xubiꞌij: “¡Jaꞌ! ¡Lic cꞌo unaꞌoj wa jun achi, tob na jusucꞌ ta ri uꞌanom!” xchaꞌ.» Xubiꞌij cꞌu ri Jesús chique rutijoꞌn: «Pakatzij wi ri winak na e ta jusucꞌ, más cꞌo quinaꞌoj che uchapabexic rubitak que, chiquiwa ri e cꞌo pa ri Kꞌijsak. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","E uwariꞌche cambiꞌij chiwe: Chichapabej chi utz ri puak y rubitak iwe y rucꞌ waꞌ chebitoꞌo ri nibaꞌib y jecꞌulaꞌ rique quebuꞌana iwamigos. Ma echiriꞌ copon ri kꞌij na jinta chi puak iwucꞌ, quixcꞌul na chilaꞌ chicaj pa cayaꞌiꞌ wi chiwe ri cꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","»E junok jusucꞌ uchapabexic cuꞌan ri xa jubikꞌ yaꞌtal pukꞌab, jecꞌuriꞌlaꞌ cuꞌano we xyaꞌiꞌ qꞌui pukꞌab. Noꞌj we na jusucꞌ ta uchapabexic cuꞌan ri xa jubikꞌ yaꞌtal pukꞌab, jecꞌuriꞌlaꞌ we xyaꞌiꞌ qꞌui pukꞌab, na jusucꞌ ta ri cuꞌan rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ecꞌu riꞌ riꞌix, we na jusucꞌ ta uchapabexic iꞌanom ri beyomalil xa re ruwachulew, ¿china cꞌu cayaꞌw riꞌ pikꞌab ri sakil beyomalil re chilaꞌ chicaj? Na jinta junok. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yey we e laꞌ na jusucꞌ ta uchapabexic iꞌanom ri yaꞌom pikꞌab xa pa chakꞌiꞌm, ¿china cꞌu riꞌ caraj cuya beyomalil chiwe? Na jinta junok. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","»Lic cꞌayew we juna aj chac e caꞌib ri rajaw. Ma laj tzel caril ri jun yey cꞌax cunaꞌ ri jun chic; o laj cuyac ukꞌij ri jun yey cucꞌak bi ukꞌij ri jun chic. Ruma cꞌu laꞌ, na utz taj we junok cuya rib che cunimaj ri Dios yey cuya rib che utzucuxic ri beyomalil re ruwachulew» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Echiriꞌ xquita waꞌ ri fariseos, ri lic queꞌec quicꞌuꞌx rucꞌ ri puak, xa xquitzeꞌej ri cubiꞌij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ecꞌu Rire xubiꞌij chique: «Ralak fariseos, lic caꞌan chi ibil ib alak pachaꞌ lic alak jusucꞌ chiquiwach ri winak, pero ri Dios retaꞌam saꞌ ri cꞌo pa animaꞌ alak. Ma ronoje tak ri lic yacom ukꞌij cuma ri winak, waꞌ lic tzel quilitaj ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","»Ri kꞌalajisanelab y ri Moisés quitzꞌibam chi lo chupa ri Tzij Pixab chwi rutakanic ri Dios cacꞌun na; yey rucꞌ cꞌu ri Juan xjekiꞌ wi utzijoxic rucꞌunibal rutakanic ri Dios, y conoje cꞌu ri winak lic caquitij ukꞌij queboc chupa waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Na rucꞌ ta cꞌu riꞌ, lic cꞌo uwach wa Tzij Pixab tzꞌibital canok, ma e ne más cꞌayew cajalcꞌatix jubikꞌok che waꞌ chwa ri casach uwach ruwa caj y ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","»China junok cuya ruwujil re jachbal ib che ri rixokil yey cacꞌuliꞌ tanchi rucꞌ juna chic ixok, riꞌ camacun chirij ri cꞌulaniquil. Yey china ri cacꞌuliꞌ rucꞌ rixok jachom canok, riꞌ jenelaꞌ camacun chirij ri cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","»Cꞌo jun achi lic beyom, e tak rukꞌuꞌ cucojo ꞌanatal rucꞌ cꞌul morato y rucꞌ cꞌul lino rubiꞌ, yey waꞌ lic qꞌui rajil. Rire ronoje kꞌij cuꞌan nimak nimanic pa rocho. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Y chunakaj cꞌu ri puerta catzꞌuyiꞌ jun nibaꞌ Lázaro rubiꞌ yey waꞌ lic cakꞌolol rij che chꞌaꞌc. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ecꞌu wa nibaꞌ lic curayij pan uwach ri kax catzak chuxeꞌ rumexa ri beyom; yey quecꞌun tak ne lo ri tzꞌiꞌ y caquirikꞌiraꞌ uwach rucꞌax cakꞌololic. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","»Xopon cꞌu jun kꞌij xcam ri nibaꞌ y xcꞌam bi cuma ri ángeles y xyaꞌ cꞌu putzal ri Abraham. Tecꞌuchiriꞌ, xcam ri beyom y xmukic. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","»Ecꞌuchiriꞌ cꞌo chi pa cꞌax ri beyom chupa ri luwar que ri ecaminak, chinimanaj xril pan ri Abraham rucꞌ ri Lázaro putzal. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ecꞌu ri beyom xsiqꞌuin apanok, jewaꞌ xubiꞌij: “Nukaw Abraham, chinjuchꞌ caꞌn co cheꞌla, taka lo la ri Lázaro chaꞌ cumuꞌ ruwi ukꞌab pa yaꞌ re coluꞌjorij ri wakꞌ, ma lic cꞌax in cꞌo chupa wa akꞌ” xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","»Noꞌj ri Abraham xubiꞌij pan che: “At wal, cꞌuna chacꞌuꞌx echiriꞌ at cꞌas che ruwachulew, lic xacꞌul janipa ri xarayij; noꞌj ri Lázaro lic cꞌax ri xucꞌul rire che rucꞌaslem che ruwachulew. Ecꞌu woꞌora rire lic utz uꞌanom wara, noꞌj riꞌat at cꞌo pa ri cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yey chikaxoꞌl riꞌoj y riꞌat cꞌo jun nimalaj siwan. Ruma cꞌu waꞌ, ri e cꞌo wara na utz taj quekꞌax pan iwucꞌ; y ri e cꞌo iwucꞌ, na utz taj quekꞌax lo wara” xcha ri Abraham. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","»Xubiꞌij cꞌu ri beyom che: “Cantzꞌonoj co cheꞌla, nukaw Abraham, taka bi la ri Lázaro chirocho ri nukaw chwachulew, ");
INSERT INTO acrTNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ma chilaꞌ e cꞌo can woꞌob nuchakꞌ. Taka cꞌu bi la ri Lázaro chaꞌ quebuꞌpixabaj y jelaꞌ na quepe ta rique chupa wa luwar re cꞌax pa wa in cꞌo wi riꞌin” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","»Y ri Abraham xubiꞌij che: “Cꞌo chi paquikꞌab rique ri Tzij Pixab tzꞌibital can cuma ri Moisés y ri kꞌalajisanelab. ¡Ecꞌu quita que riꞌ!” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","»Ecꞌu ri beyom xubiꞌij che: “Nukaw Abraham, rique na queboc ta il che waꞌ. Pero we ta e laꞌ cꞌo junok cꞌastajinak bi chiquixoꞌl ri ecaminak yey cawinakir chiquiwach, riꞌ caquitzelej na quitzij chwach ri Dios” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","»Ecꞌuchiriꞌ xubiꞌij ri Abraham che: “We rique na queboc ta il che ri quitzꞌibam can ri Moisés y ri kꞌalajisanelab, na caquijalcꞌatij ta ri quibinic quisilabic tob ne cawinakir chiquiwach junok cꞌastajinak bi chiquixoꞌl ri ecaminak” xcha ri Abraham.» ");
INSERT INTO acrTNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ri Jesús xubiꞌij chique rutijoꞌn: «Che ruwachulew lic cꞌo tzakibal pa mac, pero ¡lic tokꞌoꞌ cꞌu uwach ri cumin junok chic chupa ri na utz taj, ma e cape ri kꞌatbal tzij re ri Dios puwiꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma e ne más utz cuya ri catzayabax bi pukul juna nimalaj caꞌ re queꞌem y cacꞌak cꞌu bi chupa ri mar, chwa ri cumin junok pachaꞌ wa chꞌutiꞌk chupa ri na utz taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","»Lic chiwila cꞌu iwib riꞌix. Ma we juna awatz-achakꞌ cuꞌan ri na utz taj chawe, chachꞌaꞌbej upa. Y we xutzelej utzij chawach, chacuyu umac. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tob ne cuꞌan ri na utz taj chawe wukub laj chupa ri jun kꞌij y wukub laj coluꞌtzelej utzij chawach, chacuyu umac» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ecꞌuchiriꞌ xquibiꞌij ri cablajuj e utakoꞌn che: —Nimarisaj la ri cubulibal kacꞌuꞌx —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Y ri Kanimajawal Jesucristo jewaꞌ xubiꞌij chique: —We ta ri cubulibal icꞌuꞌx caqꞌuiyic jelaꞌ pachaꞌ caqꞌuiy rijaꞌ re moxtasa, utz ne riꞌ quibiꞌij che wa jun cheꞌ: “Chumichꞌa bi rib wara y chutica rib chupa ri mar,” y e cuꞌanaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ecꞌu ri Jesús xubiꞌij: «We e laꞌ junok chiwe cꞌo juna raj chac cachacun pa abixbal o quebuchajij chicop, yey echiriꞌ catzelej lo pa juyub, ¿quibiꞌij nawi che: “Chatocok, chat-tzꞌula chwa ri mexa”? ");
INSERT INTO acrTNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Na e ta quiꞌano! Ri quibiꞌij che e waꞌ: “Chajeka uyijbaxic ri waꞌim y chayijbaꞌ awib chaꞌ caya lo ri nuwa chwa ri mexa. Ecꞌuchiriꞌ in woꞌkinak chi riꞌin, cꞌa tecꞌuchiriꞌ catwaꞌ riꞌat” quixchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Cutioxij nawi ri patrón che ri raj chac ruma xuꞌan ri xutak che? Na cutioxij taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jecꞌulaꞌ riꞌix, echiriꞌ iꞌanom chi ronoje ri ixtakom che uꞌanic ruma ri Dios, jewaꞌ chibiꞌij: “Riꞌoj xa oj mocom, na takal ta co chike cayac kakꞌij ma xew kaꞌanom ri ubiꞌim ri Dios chike” quixchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Echiriꞌ ri Jesús cꞌo chi be re queꞌec Jerusalem, catajin ricꞌowic pa ri be, ri cujach upa ri luwar re Samaria rucꞌ ri luwar re Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Echiriꞌ catajin roquic chupa jun aldea, lajuj achijab cꞌo ri yabil lepra chique xebel lo che ucꞌulic yey chinimanaj xetaqꞌuiꞌ wi lo che ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xquijek cꞌu quesiqꞌuin che, jewaꞌ caquibiꞌij: —¡Jesús, lal tijonel, choj-juchꞌ caꞌn co cheꞌla! —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ecꞌuchiriꞌ xeril pan ri Jesús, jewaꞌ xubiꞌij chique: —Oj alak, jeꞌcꞌutu ib alak chiquiwach raj chacunel pa Rocho Dios —xcha chique. Xebec cꞌut, y echiriꞌ quetajin chi be, xecunutaj che ri quiyabil. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Cꞌo cꞌu jun chique, echiriꞌ xrilo cunutajinak chic, xtzelej lok y xujeko casiqꞌuinic, lic cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xuxucubaꞌ cꞌu rib xeꞌrakan ukꞌab ri Jesús, xukasaj rupalaj cꞌa chuꞌlew y lic catioxin chwach, yey waꞌ waꞌchi aj Samaria. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ecꞌu ri Jesús jewaꞌ xubiꞌij: —¿Na e ta neba lajuj ri xecunutajic? Yey ri belejeb chic, ¿pa e cꞌo wi? ");
INSERT INTO acrTNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Suꞌchac na xetzelej ta lo rique chaꞌ caquiyac ukꞌij ri Dios? Ma xew xtzelej lo wa jun achi yey rire na aj tane Israel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xubiꞌij cꞌu che rachi: —Chatyactajok y chamaja bi abe. Ma ruma ri cubulibal acꞌuꞌx wucꞌ, xatcolobetaj che ri yabil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ri fariseos xquitzꞌonoj che ri Jesús: —¿Jampalaꞌ cacꞌun rutakanic ri Dios che ruwachulew? —xechaꞌ. Y ri Jesús xucꞌul uwach: —Ri jekebal rutakanic ri Dios na jinta cꞌutubal re quilitajic. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na jinta ne junok cubiꞌij: “¡Riꞌ cꞌo wara!” o “¡Leꞌ cꞌolic!” Ma tape alak: Rutakanic ri Dios cꞌo chi chixoꞌl alak —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ecꞌuchiriꞌ ri Jesús xubiꞌij tanchi chique rutijoꞌn: «Copon cꞌu ri kꞌij echiriꞌ lic quiwaj quiwil tob ne xa juna kꞌij che rukꞌijol Ralaxel Chiquixoꞌl Ticawex echiriꞌ catakan che ruwachulew; pero na quiwil taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Cuꞌana cꞌu riꞌ e cꞌo caquibiꞌij chiwe: “¡Riꞌ cꞌo wara!” o “¡Leꞌ cꞌolic!” Pero riꞌix mixꞌec, na quebiternabej ta nenareꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ma echiriꞌ cacꞌun Ralaxel Chiquixoꞌl Ticawex, conoje caquil rucꞌunibal jelaꞌ pachaꞌ cuꞌano echiriꞌ cayocꞌ caꞌn ruxeꞌ caj y ruwonibal waꞌ cuwonisaj ronoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero lic cꞌu chirajawaxic nabe na cutij ri cꞌax y lic cacꞌak bi ukꞌij cuma ri winak re wakꞌij ora. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","»Ma jelaꞌ pachaꞌ ri xuꞌan chupa tak ri kꞌij re ri Noé, jelaꞌ cuꞌana pa rucꞌunibal Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ma conoje ri winak caquitij quiwa, caquitij quiyaꞌ, quecꞌuliꞌic y quequiya ri calcꞌoꞌal pa cꞌulaniquil. Ecꞌu quetajin riꞌ che uꞌaniquil, echiriꞌ xopon rukꞌijol xoc bi ri Noé chupa ri nimalaj barco; cꞌa tecꞌuchiriꞌ xpe ri unimal jab y jelaꞌ xusach quiwach conoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jecꞌuriꞌlaꞌ xuꞌan ojertan chupa tak ri kꞌij re ri Lot: tak ri winak caquitij quiwa, caquitij quiyaꞌ, quelokꞌowic, quecꞌayinic, queticoꞌnajic y caquiyac cocho. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yey chupa cꞌu ri kꞌij echiriꞌ xel bi ri Lot chupa ri tinamit Sodoma, xpe lo akꞌ chicaj cajinow rucꞌ azufre y xecam conoje ri e cꞌo chupa ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jecꞌuriꞌlaꞌ cuꞌana pa rukꞌijol echiriꞌ cakꞌalajin uwach Ralaxel Chiquixoꞌl Ticawex, ma tak ri winak na cacoyꞌej ta rucꞌunibal. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","»Chupa cꞌu riꞌ la kꞌij, china ri cꞌo lo chwi ri rocho, makaj lo che ucꞌamic ubitak re pa ja; y china ri cꞌo pa juyub, matzelej lo pa ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cꞌuna chicꞌuꞌx riꞌix saꞌ ri xucꞌulumaj ri rixokil ri Lot. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","China ri lic cutij riꞌ che na cuya ta ranimaꞌ rucꞌaslem, riꞌ e cujam ri chomilaj ucꞌaslemal chwach ri Dios; noꞌj china ri cuya ranimaꞌ rucꞌaslem wuma riꞌin, riꞌ e curik ri chomilaj ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","»Pakatzij wi cambiꞌij chiwe: Chupa laꞌ laꞌkꞌab cꞌo cuꞌana wi e cꞌo caꞌibok quewar junam; jun cacꞌam bi y ri jun chic cayaꞌiꞌ canok. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O laj e cꞌo caꞌib ixokib junam quequeꞌnic; jun cacꞌam bi y ri jun chic cayaꞌiꞌ canok. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pa e cꞌo wi caꞌibok chwa juyub; jun cacꞌam bi y ri jun chic cayaꞌiꞌ canok» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ecꞌuchiriꞌ rutijoꞌn xquicꞌul uwach, jewaꞌ xquibiꞌij che: —Kajawal, ¿pachawi cuꞌana wi waꞌ? —xechaꞌ. Y ri Jesús xubiꞌij chique: —Lic cakꞌalajinic pa cuꞌana wi, jelaꞌ pachaꞌ cakꞌalajinic pa cꞌo wi juna caminak, ma puwi waꞌ caquimol wi quib tak ri cꞌuch —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ecꞌu ri Jesús xutzijoj wa jun cꞌambal naꞌoj chaꞌ cucꞌut chique rutijoꞌn ri lic chirajawaxic wi na cacokꞌotaj taj caquiꞌan orar chwach ri Dios y na capax tane quicꞌuꞌx che royꞌexic ri cꞌulubal uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jewaꞌ xubiꞌij chique: «Chupa jun tinamit cꞌo jun aj kꞌatal tzij na cuxiꞌij ta rib chwach ri Dios y na cuxiꞌij ta rib chwach juna achi. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Cꞌo cꞌu jun ixok malcaꞌn chupa wa tinamit, ronoje kꞌij cacꞌun chwach raj kꞌatal tzij y cubiꞌij che: “Kꞌata la tzij puwi jun ticawex cachꞌoꞌjin chwij” cacha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","»Ecꞌu raj kꞌatal tzij lic naj e riꞌ na xraj taj cuꞌan ri cutzꞌonoj wiꞌxok. Tecꞌuchiriꞌ, xubiꞌij pa ranimaꞌ: “Tob na canxiꞌij ta wib chwach ri Dios y na canxiꞌij ta wib chwach juna achi, ");
INSERT INTO acrTNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","canꞌan na cꞌu wa kꞌatbal tzij cutzꞌonoj wiꞌxok malcaꞌn. Ma we na cantoꞌ taj, xaki quinoꞌluchꞌichꞌaꞌ yey waꞌ na cancuy ta chic” xcha raj kꞌatal tzij.» ");
INSERT INTO acrTNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ecꞌuchiriꞌ, ri Kanimajawal xubiꞌij chique rutijoꞌn: «Xita cꞌu riꞌ saꞌ ri xubiꞌij wa aj kꞌatal tzij na utz ta ucꞌuꞌx. Xuꞌan cꞌu ri xutzꞌonoj rixok che ma rire na xrokꞌotaj ta utzꞌonoxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","»We juna achi na utz ta ucꞌuꞌx cuꞌan waꞌ, ¡macꞌuwariꞌ ri Dios cuꞌan ri usucꞌ y quebutoꞌ cꞌu ri ebuchaꞌom Rire we rique caquichꞌaꞌbej chipakꞌij chichakꞌab! ¿Camayin neba Rire che ucꞌulic uwach? ");
INSERT INTO acrTNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Cambiꞌij chiwe: Na jampatana ri Dios cucꞌulubej lo uwach y cuꞌan cꞌu ri usucꞌ chique. Pero echiriꞌ cacꞌun tanchi Ralaxel Chiquixoꞌl Ticawex, ¿cꞌa queburik nawi ticawex che ruwachulew cꞌa cꞌo cubulibal quicꞌuꞌx rucꞌ ri Dios?» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E cꞌo jujun caquichꞌobo lic e jusucꞌ; ruma cꞌu riꞌ, lic cꞌu caquicꞌak bi quikꞌij ri jujun chic. Ecꞌu ri Jesús xutzijoj wa jun cꞌambal naꞌoj chique: ");
INSERT INTO acrTNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«E cꞌo caꞌib achijab xebec pa ri Rocho Dios chaꞌ queꞌquiꞌana orar; jun e cuqꞌuil ri fariseos y ri jun chic, aj tzꞌonol puak re tojonic. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ecꞌu ri fariseo e riꞌ tacꞌalic xujek cuꞌan orar; lic cuyac ukꞌij chiribil rib, jewaꞌ cubiꞌij: “Lal Dios, cantioxij cheꞌla ma riꞌin na in ta jelaꞌ pachaꞌ ri juchꞌob achijab: ri elekꞌomab, ri na e ta jusucꞌ, ri quemacun chirij ri cꞌulaniquil. Riꞌin na in tane jelaꞌ pachaꞌ la jun aj tzꞌonol puak re tojonic. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Riꞌin calaj canꞌan ayuno ronoje semana, y canya ri nudiezmo che ronoje ri canchꞌaco” cacha ri fariseo. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","»Noꞌj raj tzꞌonol puak re tojonic xa naj xcꞌojiꞌ wi apanok. Na caraj tane catzuꞌn chicaj; cutꞌikitꞌaꞌ ruwa ucꞌuꞌx, jewaꞌ cubiꞌij: “Lal Dios Kajawxel, ¡cuyu co la numac, ma riꞌin lic in aj mac!” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","»Cambiꞌij cꞌu chiwe: Wa aj tzꞌonol puak re tojonic xtzelej chirocho ꞌanom chi jusucꞌ che ruma ri Dios; noꞌj ri fariseo, na xcuy ta rumac. Ma china ri cuꞌan nim che rib, ri Dios cukasaj uwa ukꞌij; noꞌj china ri cuꞌan chꞌutiꞌn che rib, ri Dios cuyac ukꞌij» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","E cꞌo jujun raltak co acꞌalab xecꞌam lo chwach ri Jesús chaꞌ Rire cuya rukꞌab paquiwiꞌ. Yey rutijoꞌn echiriꞌ xquil waꞌ, xequiyaj ri ecꞌamayom lo que. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Noꞌj ri Jesús xebusiqꞌuij pan racꞌalab y jewaꞌ xubiꞌij chique rutijoꞌn: «Chiyaꞌa luwar chique ri raltak co acꞌalab chepeta na wucꞌ. Mebikꞌatej; ma ri caquiꞌan e jelaꞌ pachaꞌ rique, riꞌ cuꞌan que rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Pakatzij wi cambiꞌij chiwe: China ri na cucꞌul ta rutakanic ri Dios jelaꞌ pachaꞌ cuꞌan juna ralco cꞌoꞌm, riꞌ na coc ta chupa rutakanic ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Cꞌo jun aj wach xcꞌun rucꞌ ri Jesús y xutzꞌonoj che: —Lal utzilaj tijonel, ¿saꞌ ri canꞌano chaꞌ cꞌo nucꞌaslemal na jinta utakexic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ri Jesús xucꞌul uwach: —¿Suꞌbe cabiꞌij la “utz” chwe? Ma xa Jun ri lic utz cꞌolic, waꞌ e ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rilal etaꞌam chi la saꞌ tak Rutzij Upixab ri Dios: “Matmacun chirij ri cꞌulaniquil. Matcamisanic. Matelekꞌic. Maꞌan rakꞌubal chirij junok. Chalokꞌoj quikꞌij rachu-akaw” —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rachi xubiꞌij: —Ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Echiriꞌ ri Jesús xuta waꞌ, jewaꞌ xubiꞌij che: —Cꞌa cꞌo ri lic chirajawaxic caꞌan la: E cꞌayij la ronoje tak ri beyomalil la y jacha cꞌu la chique ri nibaꞌib; jecꞌuriꞌlaꞌ cꞌo beyomalil la chilaꞌ chicaj. Tecꞌuchiriꞌ peta la y tereja lo la chwij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ecꞌuchiriꞌ xuta waꞌ rachi, lic xuchap bis, ma rire lic beyom. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Echiriꞌ ri Jesús xrilo lic xuchap bis rachi, jewaꞌ xubiꞌij: —Ri e beyomab, lic cꞌayew chique queboc chupa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma e ne más cꞌayew ri coc juna beyom chupa rutakanic ri Dios chwa ri quicꞌow juna camello chupa rutel juna acuxaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ewi ri xetaw re waꞌ, xquibiꞌij: —We e riꞌ, ¿china cꞌu riꞌ ri cacolobetajic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xubiꞌij cꞌu ri Jesús chique: —Ri ticawex na caquicolobej ta quib quituquel, ma waꞌ lic cꞌayew chiquiwach; noꞌj ri Dios cuꞌano ma na jinta cꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ecꞌuchiriꞌ, xubiꞌij ri Pedro: —Kajawal, e riꞌoj kayaꞌom can ronoje y oj teran chiꞌij la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ecꞌu ri Jesús xubiꞌij chique: —Pakatzij wi cambiꞌij chiwe: China ri uyaꞌom can rocho, ebuyaꞌom can ruchu-ukaw, ri ratz-uchakꞌ, ri rixokil o ri ralcꞌoꞌal ruma rutakanic ri Dios; ");
INSERT INTO acrTNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ruma tak cꞌu waꞌ wa uyaꞌom canok, lic qꞌui ri rajil ucꞌaxel cucꞌul wara che ruwachulew. Yey chikawach apanok cucꞌul na ri cꞌaslemal na jinta utakexic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ri Jesús xumol quichiꞌ ri cablajuj utijoꞌn y jewaꞌ xubiꞌij chique: «Chitapeꞌ. E waꞌ cojpakiꞌ Jerusalem y chilaꞌ cuꞌana ronoje ri tzꞌibital can cuma ri kꞌalajisanelab chwi Ralaxel Chiquixoꞌl Ticawex: ");
INSERT INTO acrTNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","cayaꞌ cꞌu paquikꞌab ri na e ta aj judiꞌab, cachꞌamixic, cayokꞌic y cachubaxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Echiriꞌ lic jichꞌom chi upa, cacamisaxic. Noꞌj churox kꞌij cacꞌastaj lo chiquixoꞌl ri ecaminak» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero rutijoꞌn na jinta xquimaj usucꞌ che waꞌ, ma cꞌamajaꞌ cayaꞌtaj chique caquimaj usucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E xuꞌan waꞌ echiriꞌ ri Jesús xa nakaj chi cꞌo wi che ri tinamit Jericó. Cꞌo jun potzꞌ tzꞌul chuchiꞌ ri be, cutzꞌonoj limoxna. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ecꞌuchiriꞌ xuto catajin quicꞌowic uqꞌuiyal winak, xutzꞌonobej: —¿Saꞌ laꞌ la catajin ricꞌowic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y cꞌo xebiꞌn che: —E Jesús ri aj Nazaret catajin ricꞌowic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ecꞌuchiriꞌ, rire lic co xsiqꞌuinic, jewaꞌ xubiꞌij: —¡Jesús, lal ri Ralcꞌoꞌal can ri rey David, chinjuchꞌ caꞌn co cheꞌla! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yey ri winak e nabejinak xquichꞌaꞌbej upa chaꞌ na casiqꞌuin ta chic. Noꞌj ri potzꞌ más ne co casiqꞌuinic, jewaꞌ cubiꞌij: —¡Lal ri Ralcꞌoꞌal can ri rey David, chinjuchꞌ caꞌn co cheꞌla! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ecꞌuchiriꞌ ri Jesús xtaqꞌuiꞌic y xutak ucꞌamic ri potzꞌ. Y echiriꞌ xcꞌam lo chwach, ri Jesús xutzꞌonoj che: ");
INSERT INTO acrTNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Saꞌ ri cawaj canꞌan chawe? —xchaꞌ. Y ri potzꞌ xubiꞌij che: —Wajawal, ꞌana la chwe quintzuꞌnic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ecꞌu ri Jesús xubiꞌij che: —¡Chat-tzuꞌn ba riꞌ! Ma ruma ri cubulibal acꞌuꞌx wucꞌ, at cunutajinak chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Xakicꞌateꞌt cꞌu riꞌ xtzuꞌnic y xterej bi chirij ri Jesús, e riꞌ cuyac ukꞌij ri Dios. Y conoje ri winak xebilow re xquijeko caquibixoj rubiꞌ ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ri Jesús xopon Jericó, e riꞌ catajin ricꞌowic chupa ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Cꞌo cꞌu jun achi chiriꞌ Zaqueo rubiꞌ, aj wach que raj tzꞌonol puak re tojonic yey rire lic beyom. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rire lic cutij riꞌ che suꞌanic caril uwach ri Jesús, pero na utz taj carilo cuma ruqꞌuiyal winak, ma xa chꞌutiꞌn rakan. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lic cꞌut canic xeꞌec xnabej bi chiquiwach ri winak y xakꞌan chwi jun cheꞌ chaꞌ caril uwach ri Jesús, ma chiriꞌ quicꞌow wi Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Echiriꞌ xopon ri Jesús chuxeꞌ ri cheꞌ, xtzuꞌn chicaj y xril pan ri Zaqueo; y jecꞌuwaꞌ xubiꞌij pan che: —Zaqueo, chokꞌotan kaja lo la, ma wakꞌij lic chirajawaxic quineꞌcanaj can chi ocho la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo maji chic xkaj lok y xucꞌul ri Jesús chirocho rucꞌ quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ecꞌuchiriꞌ xquil waꞌ ri winak, conoje xquijek quechꞌaꞌt chirij ri Jesús ma xcanaj can chirocho jun achi lic aj mac. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ecꞌuchiriꞌ, ri Zaqueo xtaqꞌuiꞌic y jewaꞌ xubiꞌij che ri Kanimajawal: —Tape la, wajawal: Pa nicꞌaj che ri nubeyomalil cansipaj chique ri nibaꞌib; yey we nuꞌanom elekꞌ che junok rucꞌ socosoꞌnic, cajlaj rucꞌaxel cantzelej che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ewi ri Jesús xubiꞌij: —Wakꞌij xcꞌun ri colobetajic chupa wa rocho ri Zaqueo, ma rire e cuqꞌuil ri ralcꞌoꞌal can ri Abraham. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yey ri in Alaxel Chiquixoꞌl Ticawex, in cꞌuninak che quitzucuxic y che quicolobexic ri e sachinak pa mac —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Echiriꞌ caquitataꞌ waꞌ ri winak, ri Jesús xujek utzijoxic jun cꞌambal naꞌoj chique. Ma xa nakaj chi cꞌo wi che ri tinamit Jerusalem yey e chiquiwach ri winak, echiriꞌ ri Jesús coc chiriꞌ, cukꞌalajisaj uwach y jelaꞌ cajeker rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xubiꞌij cꞌu ri Jesús: «Cꞌo jun achi lic cꞌo uwach e riꞌ queꞌec chupa jun tinamit lic naj chaꞌ chilaꞌ caꞌan rey che; y jelaꞌ echiriꞌ catzelej lok, cujek rutakanic puwi rutinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yey echiriꞌ cꞌamajaꞌ queꞌec, xebusiqꞌuij lajuj raj chaquib y xuya can chique chiquijujunal jun sakil puak “mina” quecha che y xubiꞌij can chique: “Chixchꞌacan chirij wa puak xalokꞌ riꞌin na in jintaj, y quiya tanchi chwe echiriꞌ quintzelej lok” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","»Pero ri winak re ri tinamit lic tzel caquilo y xequitak cꞌu bi jujun achijab chaꞌ queꞌquibiꞌij che ri jun cayaꞌw re ri takanic che: “Na cakaj ta cuꞌan rey waꞌchi pakawiꞌ” quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","»Na rucꞌ ta cꞌu riꞌ, xyaꞌtaj che rachi cuꞌan rey. Ecꞌuchiriꞌ xtzelej lok, xutak quisiqꞌuixic ri raj chaquib uyaꞌom can puak paquikꞌab, ma caraj caretaꞌmaj janipa ri xquichꞌac chiquijujunal. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","»Xcꞌun ri nabe y jewaꞌ xubiꞌij che: “Wajaw, rucꞌ ri jun mina yaꞌom can la panukꞌab, xinchꞌac chi lajuj chirij” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","»Ri rey xubiꞌij che: “Utz riꞌ. At jun utzilaj aj chac. Ruma cꞌu xarik uchapabexic chi utz ri na qꞌui taj, woꞌora canya pakꞌab at takanel paquiwi lajuj tinamit” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","»Xcꞌun cꞌu lo jun chic raj chac y jewaꞌ xubiꞌij che: “Wajaw, rucꞌ ri jun mina yaꞌom can la panukꞌab, xinchꞌac chi woꞌob chirij” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","»Y ri rey jewaꞌ xubiꞌij che: “Riꞌat canya pakꞌab at takanel paquiwi woꞌob tinamit” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","»Xcꞌun cꞌu jun chic y jewaꞌ xubiꞌij che: “Wajaw, riꞌ ri jun mina la yaꞌom can la panukꞌab. Waꞌ lic nucꞌolom chi utz chupa jun suꞌt ");
INSERT INTO acrTNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ma lic xinxiꞌij wib cheꞌla ruma lic lal titzꞌitic. Rilal caꞌan e la che ri na lal ta cꞌoloyom re, yey camol ne la ri na xtic ta la” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","»Ecꞌuchiriꞌ, ri rey xubiꞌij che: “Riꞌat at jun aj chac na jinta cꞌana achac. Rucꞌ ne la chꞌaꞌtem xabiꞌij, cankꞌat tzij pawiꞌ. We xachꞌob rakan lic in titzꞌitic ma canꞌan weꞌin che ri na in ta incꞌoloyom re, yey canmol ne ri na xintic taj, ");
INSERT INTO acrTNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿suꞌbe cꞌu riꞌ na xaya ta ri nupuak pa banco chaꞌ we xintzelej lok coꞌlnucꞌamaꞌ rucꞌ ri uchꞌacom chic?” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","»Xubiꞌij cꞌu chique ri e cꞌo chiriꞌ: “Chimaja ri mina che wa jun aj chac y chiyaꞌa che ri cꞌo lajuj mina rucꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","»Ecꞌu rique xquibiꞌij che: “Kajaw, ¡pero rire cꞌo chi lajuj mina rucꞌ!” xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","»Y ri takanel xucꞌul uwach: “Pakatzij wi cambiꞌij chiwe: China ri lic qꞌui cꞌo rucꞌ, cayaꞌiꞌ ne más che; noꞌj ri na jinta cꞌo rucꞌ, camajiꞌ ne che ri xa jubikꞌ cꞌo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ecꞌu woꞌora, chebicꞌama lo wara ri winak lic tzel quinquilo, ri na xcaj taj quinuꞌan rey paquiwiꞌ, y chebicamisaj chinuwach” xchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Echiriꞌ xubiꞌij waꞌ, ri Jesús xumaj tanchi ubi ube y xpakiꞌ Jerusalem junam cucꞌ rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ecꞌuchiriꞌ xebopon chwach ri juyub Olivos, chunakaj raldeas Betfagé y Betania, ri Jesús xebutak bi caꞌib chique rutijoꞌn chaꞌ quenabej apanok, ");
INSERT INTO acrTNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","jewaꞌ xubiꞌij chique: «Jix pa raldea cꞌo pan chikawach. Y echiriꞌ quixoc chupa, quiꞌrika jun kꞌapoj buru yukulic. Waꞌ na jinta junok cojoyom re. Chiquiraꞌ y chicꞌamaꞌ lok. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We cꞌo cꞌu junok catzꞌonow chiwe: “¿Suꞌchac quiquiro?”, jewaꞌ quicꞌul uwach: “Ma cajawax che ri Kajawal” quixchaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xebec cꞌu ri caꞌib etakom bi y xquirik ri buru jelaꞌ pachaꞌ ri biꞌtal bi chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ecꞌuchiriꞌ quetajin che uquiric ri kꞌapoj buru, tak ri rajaw xquibiꞌij chique: —¿Suꞌchac quiquir la buru? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y rique xquibiꞌij: —Ma cajawax che ri Kajawal —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ewi xquicꞌam lo ri buru rucꞌ ri Jesús. Ecꞌuchiriꞌ quiripom chi ri quimanta chwi ri kꞌapoj buru, xcakꞌanisaj ri Jesús puwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Echiriꞌ catajin ricꞌowic ri Jesús, ri winak caquilicꞌ tak ri quimanta pa la be re yacbal ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y echiriꞌ catajin roponic chunakaj ri xulanic re ri juyub Olivos, conoje ruqꞌuiyal utijoꞌn xquijeko lic caquiyac ukꞌij ri Dios rucꞌ quiꞌcotemal ma quilom tak ri cꞌutubal re ruchukꞌab uꞌanom ri Jesús, ");
INSERT INTO acrTNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","jewaꞌ caquibiꞌij: «¡Lic nim ukꞌij ri Rey petinak chupa rubiꞌ ri Dios Kajawxel! ¡Utzil chomalil cꞌo chilaꞌ chicaj y lic nim uwach ukꞌij ri Dios chilaꞌ chicaj!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E cꞌo cꞌu jujun fariseos chiquixoꞌl ruqꞌuiyal winak xquibiꞌij che ri Jesús: —Lal tijonel, chebekꞌatej la ri tijoꞌn la chaꞌ na caquibiꞌij ta chi waꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Noꞌj ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij che alak, we ta rique caquitanabaꞌ ubiꞌxiquil waꞌ, e tak rabaj caquijek caquiyac nukꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y echiriꞌ ri Jesús xopon chunakaj Jerusalem y xril pan ri tinamit, xujek lic cokꞌ puwiꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","jewaꞌ xubiꞌij: «¡Tokꞌoꞌ iwach riꞌix aj Jerusalem! ¡We ta cꞌu quiwetaꞌmaj wakꞌij ora saꞌ ri cacꞌamaw lo utzil chomal chiwe! Noꞌj waꞌ pachaꞌ ewatal chiwach woꞌora. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Cacꞌun cꞌu ri kꞌij echiriꞌ ri tzel quebilow iwe caquisut rij ri tinamit Jerusalem y caquiwoc iwij chaꞌ na quixanimaj tubi. Tecꞌuchiriꞌ, quepe chiwij. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Quixquicamisaj iwonoje y caquiwulij ri tinamit chaꞌ na jinta juna ja cataqꞌuiꞌ canok. Quicꞌulumaj cꞌu waꞌ ma na xiwetaꞌmaj taj jampa xcꞌun ri Colobenel iwucꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Echiriꞌ xoc ri Jesús pa ri Rocho Dios, xujek lo quesaxic conoje ri quecꞌayinic y ri quelokꞌow chupa. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y jewaꞌ xubiꞌij chique: «Ri Dios jewaꞌ cubiꞌij chupa Ruchꞌaꞌtem: Ri Wocho e luwar re oración cachaꞌ. Noꞌj ralak ꞌanom alak che ri Wocho e jun luwar que elekꞌomab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y ronoje kꞌij cacꞌutun ri Jesús pa ri Rocho Dios; noꞌj ri nimak e aj chacunel, raj cꞌutunel re ri tzijpixab y raj wach re ri tinamit lic caquitzucuj suꞌanic caquicamisaj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero na caquirik taj suꞌanic, ma conoje ri winak lic cacaj caquita ri cubiꞌij Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Cꞌo jun kꞌij ri Jesús cacꞌutun pa ri Rocho Dios, cutzijoj ri Utzilaj Tzij chique ri winak. Xebopon cꞌu ri nimak e aj chacunel re ri Rocho Dios junam cucꞌ raj cꞌutunel re ri tzijpixab y ri nimak winak re ri tinamit, ");
INSERT INTO acrTNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","y xquitzꞌonoj che: —Biꞌij la chike: ¿China xyaꞌw pakꞌab la caꞌan tak la waꞌ? ¿China xtakaw la che caꞌan tak la waꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xucꞌul uwach: —Riꞌin canꞌan jun tzꞌonobal che alak; cꞌulu cꞌu alak uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿China xtakaw re ri Juan cuya ri bautismo? ¿E ri Dios o e rachijab? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ecꞌu rique xquijek quechꞌaꞌt chiquiwach puwi waꞌ: «We xkacꞌul uwach che: “E ri Dios”, riꞌ cubiꞌij rire chike: “¿Suꞌchac cꞌu riꞌ na xcoj ta alak ri xubiꞌij?” cacha chike. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yey we xkabiꞌij “e rachijab”, conoje riꞌ ri tinamit cojquicamisaj paꞌbaj; ma rique lic quijiquibam uwach ri Juan e jun kꞌalajisanel re ri Dios» xecha chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Xquibiꞌij cꞌu che ri Jesús: —Na ketaꞌam taj —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ecꞌu ri Jesús xubiꞌij chique: —Jecꞌuriꞌlaꞌ, riꞌin na cambiꞌij ta che alak china yaꞌyom panukꞌab canꞌan tak waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ecꞌuchiriꞌ, ri Jesús xujek utzijoxic wa cꞌambal naꞌoj chique ri winak: «Cꞌo jun achi xuꞌan ticoꞌn re uva chwach ri rulew. Tecꞌuchiriꞌ, xuya can pa tunulic chique jujun aj chaquib. Xeꞌec cꞌu riꞌ y uqꞌuiyal kꞌij xsachiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","»Echiriꞌ xopon rukꞌijol ri molonic, xutak lo jun raj chac chaꞌ cuꞌtzꞌonoj chique raj tunulel ri takalic cucꞌul rire che ri molonic. Noꞌj raj tunulel xquichꞌayo y xquitak bi; e riꞌ na jinta xquiya bi che. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","»Ecꞌu ri rajaw xutak lo jun chic raj chac. Noꞌj raj tunulel xquiꞌan cꞌax che jelaꞌ pachaꞌ xquiꞌan che ri nabe; xquichꞌayo, lic xquiqꞌuixbesaj y xquitak bi. Yey na jinta xquiya bi che. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","»Y ri rajaw xutak lo rurox aj chac. Pero raj tunulel lic xquiꞌan cꞌax che y xquesaj bi chupa waꞌ wuꞌlew. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","»Ecꞌuchiriꞌ, ri rajaw xubiꞌij chiribil rib: “¿Saꞌ ri canꞌan woꞌora? Cantak bi ri nucꞌajol lic cꞌax cannaꞌo; ma cꞌaxtaj we xquil uwach rire, caquicꞌul na chi utz.” ");
INSERT INTO acrTNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","»Noꞌj raj tunulel echiriꞌ xquil uwach rucꞌajol rachi, xechꞌaꞌt chiquiwach, jewaꞌ xquibiꞌij: “Waꞌ e ucꞌajol ri rajaw rulew, ri cuꞌana na rajaw we xcam rukaw. Joꞌ jeꞌkacamisaj chaꞌ rulew cuꞌan can keꞌoj” xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","»Xquesaj cꞌu bi rucꞌajol rachi chupa waꞌ wuꞌlew y xquicamisaj» xcha ri Jesús. Tecꞌuchiriꞌ xutzꞌonoj chique ri winak: —Chiwach ralak, ¿saꞌ nawi cuꞌan ri rajaw ri ticoꞌn chique raj tunulel? ");
INSERT INTO acrTNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Riꞌin cambiꞌij: Cacꞌunic, cusach quiwach wa aj tunulel y cuya ri rulew pa tunulic chique jujun chic —xchaꞌ. Ecꞌuchiriꞌ xquita waꞌ ri winak, xquibiꞌij: —¡Muꞌan ne co riꞌ waꞌ ri Dios chike! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero ri Jesús lic xutzutzaꞌ quiwach y jewaꞌ xubiꞌij chique: —¿Saꞌ cꞌu ri cabiꞌij alak che wa tzꞌibital can chupa Rutzij Upixab ri Dios? Ma jewaꞌ cubiꞌij: E rabaj cꞌakital can cuma raj yacal ja, e abaj waꞌ lic xajawaxic chaꞌ catiquiꞌ lo ri ja cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","China cꞌu ri catzak puwi laꞌ laꞌbaj, lic cꞌax ri cucꞌulumaj; yey we rabaj catzak puwi junok, riꞌ xa jumul cusach uwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ecꞌuchiriꞌ, ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab lic xquitzucuj suꞌanic asu caquichap bi ri Jesús, ma xquimaj usucꞌ chiquij rique xubiꞌij wi wa cꞌambal naꞌoj; noꞌj na xquiꞌan taj ruma ri quixiꞌin ib chiquiwach ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ecꞌu raj wach lic quicꞌacꞌalem ri Jesús y xequitak bi achijab quiꞌanom che quib pachaꞌ lic e jusucꞌ, chaꞌ caquicꞌam upa ri Jesús rucꞌ tak ri cubiꞌij y jelaꞌ caquicoj umac y caquiya cꞌu pukꞌab ri takanel re ri gobierno romano. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xquitzꞌonoj cꞌu che ri Jesús: —Lal tijonel, riꞌoj ketaꞌam lic usucꞌ ronoje ri cabiꞌij la y ri cacꞌut la, yey rilal lic lal jusucꞌ cucꞌ conoje ri ticawex. Pakatzij wi e cacꞌut la ri be re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Usucꞌ nawi ri cakaꞌan tojonic che ri nimalaj takanel re Roma o na usucꞌ taj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Noꞌj ri Jesús, ruma retaꞌam ri retzelal quicꞌuꞌx, jewaꞌ xubiꞌij chique: —¿Suꞌchac cacꞌam alak nupa? ");
INSERT INTO acrTNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Cꞌutu pe alak chwe juna meyo re caꞌan tojonic rucꞌ. ¿China re wa cꞌaxwach y china re wa biꞌaj cꞌo chwach wa meyo? —xchaꞌ. Rique xquicꞌul uwach: —Re ri nimalaj takanel re Roma —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Xubiꞌij cꞌu ri Jesús chique: —Yaꞌa alak che ri nimalaj takanel re Roma janipa ri takal che rire; yey yaꞌa cꞌu alak che ri Dios janipa ri takal che ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ecꞌu ri quicꞌacꞌalem ri Jesús na xquirik ta juna chꞌaꞌtem xubiꞌij chique ri winak chirij ri gobierno. E ne lic xcam canimaꞌ che ri cꞌulubal uwach xuyaꞌo y na jinta chi cꞌu xquibiꞌij che. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xecꞌun cꞌu rucꞌ ri Jesús jujun chique ri saduceos, ri caquibiꞌij na jinta cꞌastajibal chique ri ecaminak. Xquitzꞌonoj cꞌu che: ");
INSERT INTO acrTNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Lal tijonel, ri Moisés xutzꞌibaj can chike: “We ri ratz junok cacamic y na e jinta can ralcꞌoꞌal rucꞌ ri rixokil, ecꞌu riꞌ ruchakꞌ cacꞌuliꞌ rucꞌ rixok malcaꞌn canok y jecꞌulaꞌ quecꞌojiꞌ ralcꞌoꞌal rucꞌ, pubiꞌ ri ratz xcamic”. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","»Julaj e cꞌo wukub achijab quichakꞌ quib. Ri nabe chique xcꞌuliꞌic, yey ecꞌu riꞌ waꞌ xcamic y na e jinta can ralcꞌoꞌal rucꞌ ri rixokil. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jelaꞌ cꞌu riꞌ rucaꞌm xcꞌuliꞌ rucꞌ rixok malcaꞌn canok. Ecꞌu riꞌ waꞌ xcamic y na e jinta can ralcꞌoꞌal rucꞌ rixok. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yey je tanchi laꞌ xucꞌulumaj rurox. Jecꞌulaꞌ xquicꞌulumaj ri wukub achijab; xecamic, e riꞌ na jinta calcꞌoꞌal xquiya canok. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Qꞌuisbal cꞌu re, e xcam rixok. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chupa cꞌu rukꞌijol ri cꞌastajibal, ¿chinok chique ri wukub achijab cuꞌana rachijil rixok? Ma conoje xecꞌuliꞌ rucꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús xucꞌul uwach: —Wara che ruwachulew ri ticawex cꞌo quixokilal y cꞌo cachijilal yey caquiya ri calcꞌoꞌal pa cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Noꞌj ri cayaꞌtaj chique quecꞌastajic y cꞌo quicꞌaslemal na jinta utakexic chilaꞌ chicaj, rique na jinta chi quixokilal, na jinta chi cachijilal y na jinta chi ne cꞌo cuya ralcꞌoꞌal pa cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma chilaꞌ chicaj na jinta chi camic chique, quebuꞌana cꞌu pachaꞌ ri ángeles. Yey e ralcꞌoꞌal ri Dios; e uwariꞌche yaꞌtal chique quecꞌastaj chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yey puwi cꞌu ri cꞌastajibal que ri ecaminak, cꞌuna pe chicꞌuꞌx alak ri xutzꞌibaj can ri Moisés puwi ri xubiꞌij ri Dios che echiriꞌ xchꞌaꞌt rucꞌ chupa ri jumocaj xuluquej, jewaꞌ xubiꞌij ri Dios che: “In ri Dios re ri Abraham, re ri Isaac y re ri Jacob” xchaꞌ. Chiriꞌ cꞌu riꞌ xukꞌalajisaj ri Moisés cꞌo cꞌastajibal, ");
INSERT INTO acrTNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ma ri Dios na e ta Dios que ri ecaminak ma e Dios que ri e cꞌaslic. Ma conoje ri e ralcꞌoꞌal ri Dios, tob ecaminak chic, e cꞌas chwach ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ecꞌuchiriꞌ jujun chique raj cꞌutunel re ri tzijpixab, jewaꞌ xquibiꞌij che ri Jesús: —Lal tijonel, lic utz ri xbiꞌij la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y ri Saduceos na jinta chi cꞌo xquitzꞌonoj che ruma xquinaꞌ quib chwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ecꞌuchiriꞌ ri Jesús xubiꞌij: «¿Suꞌbe cabiꞌx che ri Cristo e “Ralcꞌoꞌal can ri rey David”? ");
INSERT INTO acrTNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma ri David jewaꞌ xutzꞌibaj can chupa ri libro re Salmos: ");
INSERT INTO acrTNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ri Dios Kajawxel xubiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwiquikꞌab, y chawoyeꞌej na ri kꞌij echiriꞌ quebenuya ri tzel quebilow awe chuxeꞌ rawakan” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ecꞌu ri David cubiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbe cꞌu riꞌ cabiꞌxic e Ralcꞌoꞌal can ri rey David?» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chiquiwach cꞌu ri winak quetaw re, ri Jesús xubiꞌij chique rutijoꞌn: ");
INSERT INTO acrTNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Lic chichajij iwib; miꞌan cꞌu iweꞌix pachaꞌ ri caquiꞌan raj cꞌutunel re ri tzijpixab. Ma rique lic cucꞌul quicꞌuꞌx ri quejurur chupa ri quikꞌuꞌ chaꞌ quilitajic lic cꞌo quiwach. Lic cucꞌul quicꞌuꞌx ri cayaꞌ rutzil quiwach pa quebilitaj wi. Yey pa tak sinagogas y pa tak waꞌim e lic cucꞌul quicꞌuꞌx ri quetzꞌuyiꞌ chupa ri tzꞌulibal que ri lic cꞌo quiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rique caquimaj ri cocho quicꞌolibal rixokib e malcaꞌnib; yey chaꞌ na cakꞌalajin ta ri na utz taj caquiꞌano, caquiwererej unimal chꞌabal echiriꞌ caquiꞌan orar. Ruma cꞌu wa caquiꞌano, lic unimal cꞌaxcꞌolil caquicꞌul na echiriꞌ cakꞌat tzij paquiwiꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri Jesús xebutzuꞌ pan ri beyomab echiriꞌ caquiya ri quikasaꞌn chupa ri caxa re kasaꞌn pa ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y xril cꞌu jun ixok malcaꞌn lic nibaꞌ echiriꞌ xuya chupa ri caxa caꞌib raltak co meyo lic na qꞌui ta rajil. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ecꞌu ri Jesús xubiꞌij: —Pakatzij wi cambiꞌij chiwe, chwach ri Dios wa jun ixok nibaꞌ y malcaꞌn e ne xuya más chwa ri xquiya conoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ma conoje xa e xquiya ruwiꞌ ri quipuak; noꞌj wiꞌxok tob lic nibaꞌ e xuya ronoje ri puak cꞌo rucꞌ, waꞌ e re culokꞌ ri lic cajawax che —xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chiriꞌ cꞌu riꞌ e cꞌo jujun quechꞌaꞌt chwi ri Rocho Dios, caquibiꞌij lic chom uꞌanom rucꞌ tak ri chomilaj abaj y rucꞌ tak ri chomilaj wikibal yaꞌtal cuma ri ticawex. Ecꞌu ri Jesús xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Cacꞌun cꞌu ri kꞌij echiriꞌ ronoje wa quitzutzaꞌ, cawulixic; jecꞌulaꞌ, na cacanaj ta chi juna abaj puwiꞌ jun chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tecꞌuchiriꞌ xquitzꞌonoj che ri Jesús, jewaꞌ xquibiꞌij: —Kajawal, ¿jampa nawi cuꞌana tak riꞌ waꞌ? ¿Yey saꞌ ri cꞌutubal quilitajic echiriꞌ cuꞌanaꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ri Jesús xubiꞌij cꞌu chique: —Lic chichajij iwib chaꞌ na quixsocotaj taj; ma e qꞌui ri quecꞌunic y xa caquichikꞌimaj uwach ri nubiꞌ, jewaꞌ caquibiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios, yey lic xa nakaj chi cꞌo wi lo rukꞌijol ri nutakanic,” quechaꞌ. Noꞌj riꞌix mixterej bi chiquij. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y echiriꞌ quito cꞌo chꞌaꞌoj y quetucuc ri winak che ruwachulew, mixiꞌij iwib che. Ma lic chirajawaxic nabe na cuꞌana na ronoje waꞌ, noꞌj cꞌamajaꞌ ne riꞌ ri qꞌuisbal re ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Xubiꞌij cꞌu chique: «Ecꞌo tinamit queyactaj chiquij jujun chic tinamit y e cꞌo takanelab queyactaj chiquij jujun chic takanelab. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Cuꞌan nimak tak cabrakan. Che uqꞌuiyal luwar che ruwachulew cape numic y yabil paquiwi ri ticawex. Yey che ruwa caj quilitaj nimak tak cꞌutubal xibibal uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","»Pero chwach tak cꞌu riꞌ waꞌ, riꞌix quitij na cꞌax ruma icojom ri nubiꞌ, quixchapic y quixternabex rucꞌ cꞌax, quixyaꞌ paquikꞌab raj wach re ri sinagogas chaꞌ rique caquikꞌat tzij piwiꞌ y quixcꞌam bi pa cárcel, quixcꞌam bi chiquiwach ri reyes y chiquiwach ri takanelab. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jecꞌuriꞌlaꞌ, utz quikꞌalajisaj ri Utzilaj Tzij chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mixoc il che saꞌ rucꞌulic uwach quiꞌano echiriꞌ quitoꞌ iwib chiquiwach rique; ");
INSERT INTO acrTNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ma e riꞌin quinyaꞌw ichꞌaꞌtem yey inaꞌoj chaꞌ conoje ri tzel quebilow iwe na caquirik ta chi ucꞌulic uwach chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","»Yey quixyaꞌ ne pa kꞌatbal tzij cuma richu-ikaw, cuma tak riwatz-ichakꞌ, cuma tak ri cꞌo chux chiwe y cuma ri iwamigos. Y jujun chiwe queyaꞌ pa camic. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lic cꞌu tzel quixil cuma tak ri winak ruma icojom ri nubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na rucꞌ ta cꞌu riꞌ, mubisoj icꞌuꞌx ma ix cꞌo pukꞌab ri Dios y na jinta ne tob xa juna iwiꞌ casachic. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma we quichꞌij uchukꞌab ronoje, quicꞌul na ri colobetajic y ri cꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","»Echiriꞌ quiwil ri soldados caquijek caquisut rij ri tinamit Jerusalem, chiwetaꞌmaj cꞌut e riꞌ copon ri kꞌij cawulix ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ecꞌu ri winak e cꞌo pa ri luwar re Judea, chebanimaj ubi chwa tak juyub; y ri e cꞌo chupa ri tinamit Jerusalem chebelubi; yey ri e cꞌo pa juyub, meboc chi lo Jerusalem, ");
INSERT INTO acrTNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ma waꞌ e ukꞌijol kꞌatbal tzij, echiriꞌ cuꞌanaꞌ janipa ri tzꞌibital chupa Rutzij Upixab ri Dios puwi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chupa tak cꞌu laꞌ la kꞌij, lic tokꞌoꞌ quiwach ri e yewaꞌ ixokib y ri quetzꞌumtisanic, ma lic saꞌch ri nimak cꞌaxcꞌobic cape che ruwachulew ruma ri royowal ri Dios chiquij waꞌ wa tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","»Lic e qꞌui ri quecamisax rucꞌ espada y e qꞌui quecꞌam bi chi presoyil pa jujun chic tinamit che ronoje ruwachulew. Yey ri tinamit Jerusalem cacꞌojiꞌ cꞌu paquikꞌab ri na e ta aj Israel chaꞌ quetakan puwiꞌ, cꞌa pa copon wi rukꞌijol ubiꞌim chi ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","»Chwa cꞌu riꞌ ri caj quilitaj cꞌutubal che ri kꞌij, che ri icꞌ y che tak ri chꞌumil; yey tak ri winak che ruwachulew casach quinaꞌoj y caquijek caquixiꞌij quib che ri nimalaj uchꞌawibal ri mar y che ri yaꞌ lic quel chicaj chwi ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Quekꞌocholaj tak ri winak, queꞌec ri quinaꞌoj y quetzak pulew ruma xiꞌin ib che ri cꞌaxcꞌobic cape che ruwachulew; ma e tak ri cꞌo quichukꞌab che ruwa caj queyiquiyoꞌxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Cꞌa tecꞌuchiriꞌ quilitaj Ralaxel Chiquixoꞌl Ticawex cacꞌun lo pa sutzꞌ rucꞌ ruchukꞌab y rucꞌ runimal uchomalil. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ecꞌuchiriꞌ cujek quilitaj wa cꞌutubal, lic chichukꞌubej iwib che royꞌexic ri icolobetajic chwa ri cꞌaxcꞌobic» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ri Jesús xutzijoj cꞌu wa jun cꞌambal naꞌoj chique: «Chiwilape ri cheꞌ re higo y conoje tak ri cheꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Echiriꞌ quiwilo quetuxic, iwetaꞌam xa nakaj chi cꞌo wi lo rukꞌijol echiriꞌ cabucbutic y na jinta jab. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jecꞌulaꞌ echiriꞌ quiwilo cuꞌana ronoje tak waꞌ, chiwetaꞌmaj xa nakaj chi cꞌo wi lo rukꞌijol echiriꞌ ri Dios catakan puwi ronoje. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Pakatzij wi cambiꞌij chiwe: E cꞌo ticawex re waꞌ wa kꞌij na quecam tana we na xquil tubi ronoje waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ruwa caj y ruwachulew xa casach uwach, noꞌj ri nuchꞌaꞌtem na casach ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","»Lic chichajij iwib chaꞌ na quiya ta iwib che tak ri rayinic re ri mac, che ri kꞌabaric y che rubis icꞌuꞌx re ruwachulew, ma cꞌaxtaj cacꞌun lo rukꞌijol Ralaxel Chiquixoꞌl Ticawex echiriꞌ na iwoyeꞌem taj. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ma rucꞌunibal Rire chiquiwach ri e cꞌo che ruwachulew, xakicꞌateꞌt cuꞌanaꞌ, jelaꞌ pachaꞌ echiriꞌ juna awaj xakicꞌateꞌt catzak pa laso re cachapic. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","»Mawar cꞌu iwach, xaki e chixchꞌaꞌt rucꞌ ri Dios chaꞌ cꞌo ichukꞌab chwa wa catajin lok y jelaꞌ takal chiwe quixcolobetaj chwach ronoje waꞌ, y na quixqꞌuix ta cꞌu riꞌ quixtaqꞌuiꞌ chwach Ralaxel Chiquixoꞌl Ticawex echiriꞌ cacꞌun lok» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ecꞌu riꞌ ri Jesús e tak ri pakꞌij cacꞌutun pa ri Rocho Dios yey e tak ri chakꞌab quel bi queꞌcꞌola chwa ri juyub Olivos. ");
INSERT INTO acrTNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y conoje ri winak anim tan quebopon chupa ri Rocho Dios chaꞌ queꞌquita ruchꞌaꞌtem ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xa nakaj chi cꞌo wi lo ri nimakꞌij echiriꞌ catij ri pam na jinta levadura che. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y ri nimak e aj chacunel pa Rocho Dios cucꞌ tak raj cꞌutunel re ri tzijpixab lic quetajin che utzucuxic suꞌanic caquiya ri Jesús pa camic, pero caquixiꞌij quib caquiꞌan chiwachil cuma ruqꞌuiyal winak eteran chirij. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ecꞌu ri Judas aj Iscariot, jun chique ri cablajuj utijoꞌn ri Jesús, xuya luwar che ri Satanás xoc pa ranimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xeꞌec cꞌu cucꞌ ri nimak e aj chacunel pa Rocho Dios y cucꞌ ri e aj wach que ri e chajinel re ri Rocho Dios chaꞌ cachꞌaꞌt cucꞌ puwiꞌ suꞌanic cuya ri Jesús paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rique lic xequiꞌcot che y xquibiꞌtisij meyo che ri Judas we cuꞌan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ecꞌu rire xuya uchiꞌ che y xujek cꞌu utzucuxic suꞌanic cuya ri Jesús paquikꞌab xa xeꞌlakꞌay chaꞌ na caquinaꞌbej ta ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xopon cꞌu ri nimakꞌij echiriꞌ catij ri pam na jinta levadura che. Chupa cꞌu waꞌ wa kꞌij chirajawaxic quecamisax tak ri kꞌapoj bexex re Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ecꞌu ri Jesús xebutak bi ri Pedro y ri Juan, jewaꞌ xubiꞌij bi chique: —Jix, jiꞌyijbaꞌ ri cena re Pascua chaꞌ jelaꞌ cakatijo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y rique xquitzꞌonoj che: —¿Pa caꞌaj wi la queꞌkayijbaꞌ wi? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xubiꞌij chique: —Chitapeꞌ: Echiriꞌ quixoc chupa ri tinamit, quicꞌul jun achi rucꞌaꞌam jun curaꞌ yaꞌ. Chixterej bi chirij cꞌa chuchiꞌ ri ja pa coc wubi ");
INSERT INTO acrTNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","y chibiꞌij cꞌu che rachi rajaw ja: “Jewaꞌ cubiꞌij ri tijonel keꞌoj: ¿Pachawi cꞌo wi ri luwar pa cantij wi ri cena re Pascua cucꞌ ri nutijoꞌn?” quixcha che. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ecꞌu ri cuꞌan ri rajaw ja e cucꞌut chiwe jun nimalaj luwar chicaj pa ri caleꞌ ja, waꞌ yijbital chic. Chiriꞌ cꞌu riꞌ chiyijbaꞌ ri cena re Pascua —xcha ri Jesús chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xebec cꞌu rutijoꞌn y xeꞌquirikaꞌ jelaꞌ pachaꞌ ri xubiꞌij bi ri Jesús chique. Y xquiyijbaꞌ cꞌu ri cena re Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ecꞌuchiriꞌ xopon ruꞌorayil ri cena, ri Jesús junam cucꞌ rutakoꞌn xeboc chwa ri mexa. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xubiꞌij chique: —¡Lic nurayim lo utijic junam iwucꞌ wa cena re Pascua chwach pan ri cꞌaxcꞌobic canwicꞌowibej! ");
INSERT INTO acrTNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma cambiꞌij cꞌu chiwe na cantij ta chi cꞌu juna chic cena re Pascua iwucꞌ, cꞌate na echiriꞌ copon ri kꞌij cuꞌana na janipa ri biꞌtisim lok puwi rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tecꞌuchiriꞌ, xucꞌam ri cꞌolibal cꞌo vino chupa y xutioxij che ri Dios. Xubiꞌij cꞌu chique rutijoꞌn: —Chicꞌama waꞌ y chitija iwe chuchiꞌ waꞌ wa cꞌolibal. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma cambiꞌij chiwe: Na cantij ta chi ruwaꞌal uva cꞌate na echiriꞌ catiquiꞌ rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tecꞌuchiriꞌ, xucꞌam ri pam y xutioxij che ri Dios. Xuwechꞌo y xujach chique, jecꞌuwaꞌ xubiꞌij: —E nucuerpo waꞌ, ri cayaꞌiꞌ pa camic iwuma riꞌix. Ecꞌuchiriꞌ quiꞌan tak waꞌ chikawach apanok, chiꞌanaꞌ cuxtabal we riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Qꞌuisbal cꞌu re ri cena, xucꞌam tanchi ri cꞌolibal cꞌo vino chupa y jewaꞌ xubiꞌij: —Waꞌ ri riꞌ e ri cꞌacꞌ tzij cajiquibax uwach rucꞌ ri nuquiqꞌuel caturuw iwuma riꞌix re cuybal imac. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yey ecꞌu ri cacꞌayin weꞌin, cꞌo wucꞌ junam chwa wa mexa. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ecꞌu Ralaxel Chiquixoꞌl Ticawex e caricꞌowibej janipa ri ubiꞌim lo ri Dios puwi Rire. Pero ¡lic cꞌu tokꞌoꞌ uwach rachi cacꞌayin re! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ecꞌuchiriꞌ xquijek rutijoꞌn caquitzꞌonobej chiquiwach china nawi chique caꞌanaw waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Rutijoꞌn ri Jesús caquichapalaꞌ quib chiquiwach puwiꞌ chinok chique más cꞌo uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Noꞌj ri Jesús xubiꞌij chique: «Ri reyes que ri nimak tinamit lic quicꞌow uwiꞌ ri quitakanic caquiꞌan paquiwi ri winak. Na rucꞌ ta cꞌu riꞌ, caquibiꞌij che quib: “E toꞌbel que ri tinamit.” ");
INSERT INTO acrTNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","»Noꞌj riꞌix miꞌan iwe pachaꞌ ri caquiꞌan rique. China ri lic cꞌo uwach chixoꞌl, e chuꞌana pachaꞌ na jinta uwach; yey ri cꞌo pukꞌab catakanic, e chuyaꞌa rib cuꞌan nimanel. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","»Chiquiwach ri winak, ¿china cꞌu ri más cꞌo uwach, e ri catzꞌuyiꞌ chwa ri mexa o e raj chac caniman chwa ri mexa? ¿Na e ta neba ri catzꞌuyiꞌ chwa ri mexa? Noꞌj riꞌin in cꞌo chiwach riꞌix pachaꞌ raj chac canimanic. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yey riꞌix ix cꞌojiꞌnak wucꞌ che ri cꞌaxcꞌobic in icꞌowinak wi. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","»Cambiꞌij cꞌu chiwe: Pachaꞌ ri Nukaw uyaꞌom panukꞌab riꞌin quintakanic, jecꞌulaꞌ canꞌan riꞌin chiwe riꞌix, canya pikꞌab quixtakanic ");
INSERT INTO acrTNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","chaꞌ jelaꞌ quixwaꞌ chwa ri numexa chupa ri nutakanic y quixtzꞌuyiꞌ cꞌut re quixtakan paquiwi ri cablajuj tinamit re Israel» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ecꞌu ri Kanimajawal xubiꞌij: —¡Simón, Simón, chatapeꞌ! E ri Satanás utzꞌonom che ri Dios chaꞌ cayaꞌtaj che cucꞌam ipa riꞌix. Quixuyiquiyaꞌ cꞌu riꞌ jelaꞌ pachaꞌ caꞌan che ri trigo echiriꞌ capuꞌ uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noꞌj riꞌin lic nutzꞌonom che ri Dios pawiꞌ riꞌat, chaꞌ na casach ta ri cubulibal acꞌuꞌx wucꞌ. Ecꞌu riꞌ riꞌat, echiriꞌ cacubiꞌ tanchi acꞌuꞌx wucꞌ, e chanimarisaj quicꞌuꞌx tak rawachbiꞌil —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xubiꞌij che: —Wajawal, riꞌin nuyaꞌom wanimaꞌ quinterej chiꞌij la, tob queꞌec la pa cárcel; yey we xyaꞌ ne la pa camic, riꞌin quincam junam ucꞌ la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ecꞌu ri Jesús xucꞌul uwach: —Pedro, pakatzij wi cambiꞌij chawe: Wakꞌab echiriꞌ cꞌamajaꞌ ne cabixon ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y chique rutijoꞌn xubiꞌij: —Echiriꞌ xixintak bi che utzijoxic ri Utzilaj Tzij, ximbiꞌij chiwe na quicꞌam tubi ucꞌolibal imeyo, na quicꞌam tubi iteb, na quicꞌam tubi jun chic molaꞌj ixajab, ¿cꞌo neba xajawax chiwe? —xcha chique. Y rique xquicꞌul uwach: —Na jintaj —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ecꞌuchiriꞌ, xubiꞌij chique: —Noꞌj woꞌora, china ri cꞌo ucꞌolibal umeyo, chucꞌama bi; china ri cꞌo uteb, chucꞌama bi; y china ri na jinta espada rucꞌ, chucꞌayij rukꞌuꞌ re pisbal rij y chulokꞌo juna espada. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma cambiꞌij cꞌu chiwe lic chirajawaxic wi e cuꞌana na wa tzꞌibital can panuwi riꞌin chupa Ruchꞌaꞌtem ri Dios: Xꞌan che pachaꞌ juna aj palajiy tzij cachaꞌ. Ecꞌu janipa ri tzꞌibital can panuwi riꞌin, e lic cuꞌana na —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ecꞌuchiriꞌ, xquibiꞌij rique che ri Jesús: —Kajawal, riꞌ queb espada cꞌo kucꞌ —xechaꞌ. Noꞌj rire xubiꞌij chique: —¡Cuꞌan na laꞌ! Mixchꞌaꞌt chi puwi waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tecꞌuchiriꞌ, xel bi ri Jesús. Xeꞌec chwa ri juyub Olivos, y rutijoꞌn xeterej bi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Echiriꞌ xebopon chilaꞌ, jewaꞌ xubiꞌij chique: —Lic chitzꞌonoj che ri Dios chaꞌ quichꞌij uchukꞌab ri cꞌambal ipa capetic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ecꞌuchiriꞌ, rire xbin chi pan jubikꞌ más chiquiwach, xuxucubaꞌ rib y xujek cachꞌaꞌt rucꞌ ri Dios, ");
INSERT INTO acrTNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","jewaꞌ cubiꞌij: «Lal Nukaw, we utz chiwach la, chincolobej co la chaꞌ na quinicꞌow ta chupa waꞌ wa cꞌaxcꞌobic. Noꞌj na e ta cꞌu chuꞌana ri cuaj riꞌin, ma e chuꞌana janipa ri rajawal cꞌuꞌx Rilal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ecꞌuchiriꞌ, xwinakir jun ángel re chicaj chwach re coluꞌyaꞌa unimal uchukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y chupa cꞌu riꞌ runimal ucꞌaxcꞌolil, ri Jesús xujek cuꞌan orar rucꞌ unimal uchukꞌab. Ruma cꞌu laꞌ xujeko nimak tꞌobaꞌj quicꞌ rucꞌatan catzak chwa rulew. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Echiriꞌ xuqꞌuis cuꞌan orar, xyactajic, xtzelej lo pa e cꞌo wi can rutijoꞌn y xeboꞌluꞌrikaꞌ quewaric ruma ri bis oquinak chiquicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xubiꞌij cꞌu chique: —¿Suꞌbe quixwaric? Chixyactajok y chitzꞌonoj che ri Dios chaꞌ jelaꞌ quichꞌij uchukꞌab ri cꞌambal ipa capetic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Cꞌa cachꞌaꞌt ne ri Jesús, echiriꞌ xebopon uqꞌuiyal winak lic quewokokic. Yey ri Judas, jun chique ri cablajuj utijoꞌn ri Jesús, nabe bi chiquiwach ruqꞌuiyal winak. Rire xkib rucꞌ ri Jesús chaꞌ cutzꞌub uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ecꞌu ri Jesús xubiꞌij che: —Judas, ¿e laꞌ rucꞌ jun tzꞌubuj chiꞌaj cacꞌayij Ralaxel Chiquixoꞌl Ticawex? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ri e cꞌo rucꞌ ri Jesús, echiriꞌ xquilo saꞌ ri catajinic, xquitzꞌonoj che: —Kajawal, ¿utz nawi cojchꞌoꞌjin rucꞌ espada? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ecꞌuchiriꞌ, jun chique rutijoꞌn xujochij bi ruxiquin uwiquikꞌab ri raj chac ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero ri Jesús xubiꞌij chique: —¡Miꞌan chi waꞌ! —xchaꞌ. Xuchap cꞌu ruxiquin raj chac y xucunaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tecꞌuchiriꞌ, xubiꞌij chique ri e petinak che uchapic bi, waꞌ e ri nimak e aj chacunel pa Rocho Dios, ri e aj wach que ri e chajinel re ri Rocho Dios y ri nimak winak re ri tinamit: —¿Suꞌchac petinak alak rucꞌ espada y cheꞌ? ¿Petinak cami alak che ucꞌamic bi juna elekꞌom? ");
INSERT INTO acrTNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ronoje kꞌij waꞌ cꞌut in cꞌo ucꞌ alak pa ri Rocho Dios. ¿Suꞌchac cꞌu riꞌ cꞌa e laꞌ quinoꞌlchapa alak? Noꞌj ecꞌu waꞌ xopon ri ora yaꞌtal che alak echiriꞌ ri rajaw ri kꞌekuꞌm cucꞌut ruchukꞌab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xquichap cꞌu bi ri Jesús y xquicꞌam bi chirocho ri cajawal raj chacunel pa Rocho Dios. Y ri Pedro chinimanaj teran pan chirij. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E cꞌo cꞌu jujun xquinucꞌ akꞌ che ruwa ja, y xetzꞌuyiꞌ chuchiꞌ ri akꞌ. Yey ri Pedro xtzꞌuyiꞌ chiquixoꞌl. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Cꞌo cꞌu jun ali aj chac xril ri Pedro tzꞌul chuchiꞌ ri akꞌ. Rali lic xutzutzaꞌ uwach y jewaꞌ xubiꞌij: —Waꞌ waꞌchi e jun chique ri eteran chirij ri Jesús —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Noꞌj ri Pedro jewaꞌ xubiꞌij che: —Ali, riꞌin na wetaꞌam ta uwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Jokꞌotaj cꞌu riꞌ cꞌo jun achi xrilo y jewaꞌ xubiꞌij che: —Rilal lal jun chique rutijoꞌn ri Jesús —xchaꞌ. Noꞌj ri Pedro xubiꞌij che rachi: —Riꞌin na in ta jun chique rutijoꞌn —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Laj pa jun ora cꞌu riꞌ cꞌo tanchi jun jewaꞌ xubiꞌij: —Pakatzij wi waꞌ waꞌchi e jun chique rutijoꞌn ri Jesús, ma aj Galilea —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Noꞌj ri Pedro xubiꞌij che: —Achi, riꞌin na wetaꞌam tane saꞌ puwiꞌ cachꞌaꞌt la —xchaꞌ. Cꞌa cachꞌaꞌt ne ri Pedro echiriꞌ xbixon lo ri teren. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ecꞌuchiriꞌ, ri Kanimajawal xtzuꞌn lo chirij y e xutzuꞌ lo uwach ri Pedro. Ecꞌu ri Pedro xcꞌun chucꞌuꞌx saꞌ rubiꞌim can ri Kanimajawal che: «Cꞌamajaꞌ ne cabixon ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach.» ");
INSERT INTO acrTNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ewi ri Pedro xel bi chiriꞌ y lic xokꞌic ruma rucꞌaxcꞌolil ucꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Rachijab echajiyom re ri Jesús lic caquichꞌamij y lic caquichꞌayo. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Caquichꞌuk ruwach y caquitzꞌonoj che: —¡Chanaꞌij peꞌ china xchꞌayaw awe! —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lic kabichi ri caquibiꞌij che rucꞌ cꞌaxlaj chꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Echiriꞌ xsakiric, xquimol quib ri nimak winak re ri tinamit, ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab; waꞌ e tak ri uchapom wi rib ri kꞌatbal tzij. Rique xquitak ucꞌamic ri Jesús chiquiwach y jewaꞌ xquibiꞌij che: ");
INSERT INTO acrTNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Chabiꞌij chike we at ri Cristo, Ruchaꞌoꞌn lo ri Dios —xechaꞌ. Y ri Jesús xubiꞌij chique: —Tob cambiꞌij che alak “In”, na cacoj ta alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yey we canꞌan tzꞌonobal che alak, na cacꞌul ta alak uwach y na quintzokopij tane ubi alak. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero Ralaxel Chiquixoꞌl Ticawex catzꞌuyiꞌ na cꞌu puwiquikꞌab ri Dios, ri lic cꞌo unimal uchukꞌab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tecꞌuchiriꞌ, conoje xquitzꞌonoj che ri Jesús: —¿At peꞌ riꞌ Rucꞌajol ri Dios? —xecha che. Y ri Jesús xucꞌul uwach: —E ralak xbiꞌn alak re, e riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ecꞌuchiriꞌ, xquibiꞌij rique: —Na jinta chi uchac más e aj cojol umac, ma lic oj xojtaw re ri xubiꞌij rucꞌ ruwa reꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ecꞌuchiriꞌ, xeyactaj conoje ri quimolom quib y xquicꞌam bi ri Jesús chwach ri Pilato. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y xquijek cꞌu caquitzꞌak uchiꞌ, jewaꞌ caquibiꞌij: —Karikom wa jun achi cusachisaj quinaꞌoj ri katinamit, quebukꞌatej ri winak chaꞌ na caquiꞌan ta ri tojonic caꞌan che ri nimalaj takanel re Roma y cubiꞌij e rire ri Cristo, ri chaꞌtal lo ruma ri Dios re catakan paquiwi raj judiꞌab —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xutzꞌonoj cꞌu ri Pilato che ri Jesús: —¿Lal cami riꞌ ri rey que raj judiꞌab? —xchaꞌ. Y ri Jesús xubiꞌij che: —Lal cabiꞌn la re —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ri Pilato xubiꞌij cꞌu chique ri nimak e aj chacunel pa Rocho Dios y chique conoje ri winak: —Chinuwach riꞌin, wa jun achi na jinta umac —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero ri winak más co quesiqꞌuinic, jewaꞌ caquibiꞌij: —Rucꞌ ri cucꞌutu lic catajin usachic quinaꞌoj ri ticawex chupa tak ri luwar re Judea; xujek lo waꞌ Galilea y woꞌora jelaꞌ cuꞌan wara Jerusalem —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Echiriꞌ ri Pilato xuto petinak ri Jesús Galilea, xutzꞌonobej we rire aj chilaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y echiriꞌ xretaꞌmaj aj Galilea ri Jesús, xutak bi chwach ri Herodes, ma rire e rey re chilaꞌ, yey laꞌ laꞌ kꞌij wi cꞌo ri Herodes chiriꞌ Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ecꞌuchiriꞌ ri Herodes xril uwach ri Jesús, lic xquiꞌcotic, ma lic cꞌo tan kꞌij riꞌ urayim caril uwach. Ma saꞌch tak ri utom che yey royeꞌem caril uwach chaꞌ ri Jesús cuꞌan juna cꞌutubal re ruchukꞌab chwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y xujek cꞌu uꞌanic uqꞌuiyal tzꞌonobal che, pero ri Jesús na cucꞌul ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ecꞌu ri nimak e aj chacunel pa Rocho Dios cucꞌ raj cꞌutunel re ri tzijpixab, lic quesiqꞌuin che ucojic umac ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ewi ri Herodes cucꞌ rusoldados lic xquicꞌak bi ukꞌij ri Jesús; xquiꞌan che pachaꞌ juna rey, xquicoj bi jun chomilaj cꞌul che re chꞌamibal re. Tecꞌuchiriꞌ, xtakan che cacꞌam tanchi ubi chwach ri Pilato. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chupa laꞌ la jun kꞌij ri Pilato y ri Herodes xquijek quechꞌaw tanchi chiquiwach, ma e ri petinak lok lic tzel caquil quib. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ecꞌu ri Pilato xumol quichiꞌ ri nimak e aj chacunel pa Rocho Dios cucꞌ raj wach re ri tinamit yey tak ri winak, ");
INSERT INTO acrTNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","y jecꞌuwaꞌ xubiꞌij chique: —Cꞌamom lo alak wa jun achi chinuwach y cabiꞌij alak rire catajin che usachic quinaꞌoj ri winak re ri tinamit. Noꞌj riꞌin xinꞌan tzꞌonobal che y xinta uchiꞌ chiwach alak, yey na jinta juna mac nurikom chirij pachaꞌ ri mac cacoj alak che. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y jenelaꞌ ri rey Herodes, na jinta juna mac xurik che; ma xintak bi chwach, yey rire xutak tanchi lo wucꞌ. Kꞌalaj cꞌu riꞌ na jinta mac uꞌanom re takal che cacamisaxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","E uwariꞌche xew canya pa cꞌax; tecꞌuchiriꞌ canyolopij bi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Xubiꞌij waꞌ ma ronoje junab chupa ri nimakꞌij Pascua, ri Pilato xex cuꞌan wi cuyolopij bi jun preso chiquiwach ri winak.) ");
INSERT INTO acrTNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Noꞌj conoje ruqꞌuiyal winak junam lic co xesiqꞌuin che ubiꞌxiquil: —¡E taka bi la ri Jesús pa camic yey yolopij bi la ri Barrabás! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Waꞌchi Barrabás yaꞌom pa cárcel ruma utitzꞌitiquil uꞌanom Jerusalem chirij ri gobierno romano y ruma jun camic xuꞌano.) ");
INSERT INTO acrTNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ri Pilato xchꞌaꞌt tanchi cucꞌ ri winak, ma rire e caraj cuyolopij bi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Noꞌj ri winak xesiqꞌuin tanchi che ubiꞌxiquil: —¡Camisax chwa cruz! ¡Camisax chwa cruz! —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Churox laj cꞌu riꞌ ri Pilato jewaꞌ xubiꞌij: —¿Saꞌ cꞌu rumac waꞌchi uꞌanom? Ma riꞌin na jinta juna mac nurikom chirij re takal che cacamisaxic. Canya na pa cꞌax, tecꞌuchiriꞌ canyolopij bi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noꞌj ri winak na caquitanabaꞌ taj lic co quesiqꞌuin che utzꞌonoxic cacamisax ri Jesús chwa cruz. Qꞌuisbal cꞌu re, xyaꞌtaj na chique ri cacaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ewi ri Pilato xutak uꞌanic ri caquitzꞌonoj: ");
INSERT INTO acrTNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","xuyolopij cꞌu bi ri jun yaꞌom pa cárcel ruma utitzꞌitiquil uꞌanom chirij ri gobierno romano y ruma jun camic xuꞌano, ma e xquitzꞌonoj riꞌ ri winak. Y xuya luwar cacamisax ri Jesús, jelaꞌ pachaꞌ ri cacaj rique. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ecꞌuchiriꞌ, ri soldados xquicꞌam bi ri Jesús re queꞌquicamisaj chwa ri cruz. Echiriꞌ cꞌo chi be, xquichap bi jun achi aj Cirene, Simón rubiꞌ, petinak pa juyub e riꞌ quicꞌow chiriꞌ. Y xquiya bi ri cruz chwi uteleb chaꞌ cutelej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y lic uqꞌuiyal winak eteran bi. Y e cꞌo ixokib chiquixoꞌl lic quetunanic y cacokꞌej ri Jesús, ma lic cꞌax unaꞌom quicꞌuꞌx ruma ri caꞌan che. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Noꞌj ri Jesús xebutzuꞌ pan rixokib quebokꞌic y jewaꞌ xubiꞌij chique: —Ixokib ix aj Jerusalem, miniwokꞌej riꞌin; e chiwokꞌej ri catajin lo piwi riꞌix y paquiwiꞌ ri iwalcꞌoꞌal. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","¡Chitapeꞌ! Copon na ri kꞌij echiriꞌ cabiꞌxic: “Nim quikꞌij calaxic rixokib na quebalan taj cucꞌ ri na jinta calcꞌoꞌal y ri na quetzꞌumtisan taj” jelaꞌ cabiꞌxic. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ruma cꞌu riꞌ ri unimal cꞌaxcꞌobic e cꞌo wi, ri winak cacaj quecamic y jecꞌuwaꞌ caquibiꞌij che tak ri juyub nimaꞌk y chꞌutiꞌk: Chix-tzaka lo pakawiꞌ re quichꞌuk kawiꞌ quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma we cayaꞌ pa camic junok na jinta umac, ¿saꞌ cꞌu riꞌ ri caquicꞌulumaj ri lic cꞌo quimac? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yey ecꞌamom bi junam rucꞌ ri Jesús caꞌib elekꞌomab chaꞌ quecamisax chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Echiriꞌ xebopon pa ri luwar cabiꞌx che “Luwar re Ubakil Ujolom Animaꞌ”, chiriꞌ xyaꞌ wi ri Jesús chwa ri cruz; y ri caꞌib elekꞌomab, jun xyaꞌ puwiquikꞌab y jun pumox Rire. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ewi ri Jesús xubiꞌij: —Nukaw, cuyu la quimac, ma na quimajom ta usucꞌ saꞌ wa quetajin che uꞌanic —xchaꞌ. Ecꞌu ri soldados rucꞌ jun sorteo xquijach quib puwi rukꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y ruqꞌuiyal winak xa caquitzutzaꞌ ri catajin uꞌanic. Yey ne raj wach re ri tinamit caquichꞌamij ri Jesús, jewaꞌ caquibiꞌij: —Lic waꞌ cꞌut e qꞌui ri xebucolobej che tak yabil y che camic. We ta rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios, chucolobej rib riꞌ woꞌora, —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jecꞌulaꞌ riꞌ xquiꞌan ri soldados, lic caquichꞌamij ri Jesús. Quekib rucꞌ y caquibiꞌtisij vinagre che re cutijo, ");
INSERT INTO acrTNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y jewaꞌ caquibiꞌij che: —We ta pakatzij wi at ri rey que raj judiꞌab, chacolobej cꞌu awib riꞌ —quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chwi cꞌu lo ri cruz re ri Jesús, pa ri chꞌaꞌtem griego, pa ri chꞌaꞌtem latín y pa ri chꞌaꞌtem hebreo tzꞌibital waꞌ: «WAꞌ E REY QUE RAJ JUDIꞌAB.» ");
INSERT INTO acrTNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun chique ri caꞌib elekꞌomab eyaꞌom chwa cruz, lic cuchꞌamij ri Jesús, jewaꞌ cubiꞌij: —¿Na at ta neba ri Cristo, Ruchaꞌoꞌn lo ri Dios? Chacolobej cꞌu awib riꞌ junam kucꞌ riꞌoj —cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Noꞌj ri jun chic elekꞌom xuyajo, jewaꞌ xubiꞌij che ri rachbiꞌil: —Riꞌat na caxiꞌij ta cꞌana awib chwach ri Dios, yey junam oj cꞌo pa wa cꞌaxcꞌobic kꞌatom pakawiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Riꞌat y riꞌin pakatzij wi, takal chike cakacꞌulumaj waꞌ, ma e tojbal re ri na utz taj kaꞌanom. Noꞌj waꞌchi na jinta umac —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ecꞌuchiriꞌ, xubiꞌij che ri Jesús: —Wajawal, chincꞌuna co chicꞌuꞌx la echiriꞌ coꞌltakana la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xubiꞌij che: —Pakatzij wi cambiꞌij chawe: Wakꞌij ne riꞌ catopon wucꞌ chilaꞌ chupa ri chomilaj luwar pa e cꞌo wi ri e colobetajinak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Echiriꞌ xticꞌoj ri kꞌij, xoc kꞌekuꞌm che ruwachulew y waꞌ xuꞌqꞌuisa cꞌa che ri urox ora benak kꞌij; ");
INSERT INTO acrTNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","oxib ora na xwon ta ri kꞌij. Yey chupa cꞌu ri Rocho Dios, ri telón xrichꞌrob lo chunicꞌajal. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ecꞌuchiriꞌ, ri Jesús lic co xchꞌawic, jewaꞌ xubiꞌij: —Nukaw, pakꞌab la cankꞌatisaj wi ri wanimaꞌ —xchaꞌ. Xew xubiꞌij waꞌ, asu xcamic. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ri capitán que ri soldados echiriꞌ xrilo saꞌ ri xuꞌano, xuyac ukꞌij ri Dios, jewaꞌ xubiꞌij: —Pakatzij wi waꞌchi lic jusucꞌ y na jinta umac —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ecꞌu ruqꞌuiyal winak echiriꞌ xquilo saꞌ ri xuꞌano, xebel chiriꞌ, caquitꞌikitꞌaꞌ ruwa quicꞌuꞌx ruma quixiꞌin ib. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yey cꞌu ri lic xquetaꞌmaj uwach ri Jesús cucꞌ tak rixokib e petinak rucꞌ chwi xel lo Galilea, rique xecꞌojiꞌ pana chinimanaj y xquil ronoje ri xuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Cꞌo cꞌu jun achi José rubiꞌ, aj Arimatea, jun tinamit re Judea. Rire e jun chique ri uchapom wi rib ri kꞌatbal tzij, jun achi lic utz ucꞌuꞌx y lic jusucꞌ rubinic usilabic. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yey lic royeꞌem rucꞌunibal rutakanic ri Dios. Ecꞌu rire lic na xucꞌul ta ucꞌuꞌx ri xquiꞌan ri rachbiꞌil. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xopon cꞌu chwach ri Pilato y xuꞌtzꞌonoj che cayaꞌ luwar che cumuk rucuerpo ri Jesús. Y xyaꞌ luwar che. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Xeꞌec cꞌut y xuꞌkasaj lo rucuerpo chwa ri cruz. Xupis cꞌu chupa jun manta. Tecꞌuchiriꞌ, xuꞌyaꞌa pa jun mukubal cꞌotom paꞌbaj, yey waꞌ na jinta junok mukum chupa. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ecꞌu benak kꞌij riꞌ echiriꞌ raj judiꞌab caquiyijbaꞌ pan janipa ri cajawax chique pa ri kꞌij re uxlanibal, y waꞌ ya copon ru orayil. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yey rixokib e petinak lo Galilea rucꞌ ri Jesús, xeterej bi chirij ri José y xquil ri mukubal pa xquiya wi can rucuerpo ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Echiriꞌ xetzelej lok, xquijekelaꞌ uyijbaxic cunabal lic quiꞌ ruxlab chaꞌ queꞌquicojo che rucuerpo ri Jesús. Ecꞌuchiriꞌ xoc ri kꞌij re uxlanibal, xebuxlan cꞌut pachaꞌ ri cubiꞌij Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ri nabe kꞌij re ri semana lic anim tan rixokib e petinak lo Galilea y jujun chic ixokib, xebec pa mukutal wi ri Jesús, yey cucꞌaꞌam bi cunabal lic quiꞌ ruxlab, ri quiyijbam lok. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yey xeꞌquirika rabaj esam chi chuchiꞌ ri mukubal. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xeboc cꞌu bi chupa ri mukubal, pero na xquirik ta chi rucuerpo ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lic cꞌut benak ri quinaꞌoj puwi waꞌ, echiriꞌ xakicꞌateꞌt xewinakir caꞌib achijab chiquiwach, lic cawolkꞌin ri quikꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Rixokib lic xquixiꞌij quib y xquikasaj ri quipalaj pulew. Ecꞌu ri caꞌib achijab xquibiꞌij chique: —¿Suꞌchac quitzucuj chiquixoꞌl ri ecaminak ri Jun cꞌaslic? ");
INSERT INTO acrTNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rire na jinta chi wara, ma cꞌastajinak chi lo chiquixoꞌl ri ecaminak. Cꞌuna chicꞌuꞌx saꞌ rubiꞌim lo chiwe echiriꞌ cꞌa cꞌo Galilea, ");
INSERT INTO acrTNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","echiriꞌ xubiꞌij: “Lic chirajawaxic wi Ralaxel Chiquixoꞌl Ticawex cayaꞌ paquikꞌab achijab aj maquib chaꞌ cacamisax chwa cruz, noꞌj Rire cacꞌastaj lo churox kꞌij” —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Cꞌa ecꞌuchiriꞌ xcꞌun chiquicꞌuꞌx rixokib ruchꞌaꞌtem ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Echiriꞌ xetzelej lo chilaꞌ pa ri mukubal, xquitzijoj ronoje waꞌ chique ri junlajuj takoꞌn y chique conoje ri e cꞌo cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ecꞌu ri xetzijon waꞌ e ri María ri aj Magdala, ri Juana, ri María uchu ri Santiago y jujun cachbiꞌil. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yey ri takoꞌn na xquicoj ta ri xquitzijoj rixokib, ma e chiquiwach rique, wa ixokib echꞌuꞌjerinak. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ecꞌu ri Pedro xyactaj bi y lic canic xeꞌec pa cꞌo wi ri mukubal re ri Jesús. Y echiriꞌ xochꞌin pan chupa, xrilo xew chi cꞌo can ri jutak rabaꞌj cꞌul pa xbolkꞌotix wi ri Jesús. Xeꞌec cꞌut lic caminak ranimaꞌ che ri xrilo y cutzꞌonoj chiribil rib saꞌ nawi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chupa laꞌ laꞌ kꞌij, caꞌib chique rutijoꞌn quebin chupa ri be re queꞌec pa raldea Emaús, waꞌ cꞌo lo pa once kilómetro che ri tinamit Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xalokꞌ cꞌu quebin chupa ri be, rique quechꞌaꞌt chiquiwach puwi ri cꞌacꞌ icꞌowinak. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yey echiriꞌ quechꞌaꞌt chiquiwach, ri Jesús xkib cucꞌ y xerachbilaj bi. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero rique pachaꞌ chꞌukutal ri quiwach, ma tob xquilo na xquetaꞌmaj ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ecꞌu ri Jesús xubiꞌij chique: —¿Saꞌ puwiꞌ cachꞌaꞌt wi alak chupa wa be? ¿Y suꞌchac cabison alak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun cꞌu chique, Cleofas rubiꞌ, xucꞌul uwach, jewaꞌ xubiꞌij: —Laj xew rilal chique conoje ri ebinel e cꞌo Jerusalem na etaꞌam ta la saꞌ ri cꞌacꞌ icꞌowinak chupa tak waꞌ wa kꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xubiꞌij cꞌu ri Jesús chique: —¿Saꞌ ri xuꞌano? —xchaꞌ. Ewi xquibiꞌij che: —E cojchꞌaꞌt puwi ri xucꞌulumaj ri Jesús ri aj Nazaret, ri nimalaj kꞌalajisanel lic cꞌo uchukꞌab che tak ri cuꞌano y ri cubiꞌij; rire lic yacom ukꞌij ruma ri Dios y cuma tak ri ticawex re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yey ri nimak e aj chacunel pa Rocho Dios cucꞌ raj wach re ri katinamit xquiya pukꞌab ri takanel romano chaꞌ cakꞌat tzij puwiꞌ y cacamisax chwa cruz. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Chwi cꞌu rucamic e urox kꞌij waꞌ. Yey riꞌoj xcubiꞌ kacꞌuꞌx e rire ri cucolobej ri katinamit Israel. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","»Yey quisachisam ne kanaꞌoj jujun ixokib ebare jun chikaxoꞌl riꞌoj oj utijoꞌn can ri Jesús. Ma rique lic anim tan xebopon chupa rumukubal, ");
INSERT INTO acrTNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero na xquirik ta chi rucuerpo ri Jesús. Xetzelej cꞌu lo kucꞌ, caquitzijoj chike xewinakir jujun ángeles chiquiwach, yey waꞌ xquibiꞌij chique: “Rire cꞌastajinak chi lo chiquixoꞌl ri ecaminak.” ");
INSERT INTO acrTNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Xebec cꞌu jujun chike riꞌoj chupa rumukubal y e xquilo jelaꞌ pachaꞌ ri quibiꞌim rixokib chike. Noꞌj na xquil ta uwach ri Jesús —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ecꞌu ri Jesús xubiꞌij chique: —¡Tokꞌoꞌ wach alak ma lic na camaj ta alak usucꞌ y camayin alak che ucojic janipa ri quibiꞌim can ri kꞌalajisanelab! ");
INSERT INTO acrTNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Na chirajawaxic ta neba ri Cristo, Ruchaꞌoꞌn lo ri Dios, cutij na ronoje wa cꞌaxcꞌobic y tecꞌuchiriꞌ queꞌec chilaꞌ chicaj pa cayac wi ukꞌij? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xukꞌalajisaj cꞌu chique ronoje ri cubiꞌij chupa Ruchꞌaꞌtem ri Dios chwi Rire, xujek lo rucꞌ ri tzꞌibital can ruma ri Moisés yey tecꞌuchiriꞌ xukꞌalajisaj janipa ri tzꞌibital chwi Rire cuma conoje ri kꞌalajisanelab. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ecꞌuchiriꞌ xebopon chupa raldea pa quebec wi ri queb achijab, ri Jesús xuꞌan pachaꞌ e riꞌ xumaj chubi rube. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero rique lic xebelaj che cacanaj can cucꞌ, jewaꞌ xquibiꞌij che: —Canaj can la kucꞌ, ma benak chi ri kꞌij yey ya coc rakꞌab —xechaꞌ. Ri Jesús xoc cꞌu bi y xcanaj can chiriꞌ cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Echiriꞌ e cꞌo chi chwa ri mexa, xucꞌam ri pam y xtioxin chwach ri Dios, xuwechꞌ cꞌu upa y xuya chique. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Cꞌa ecꞌuchiriꞌ xjakataj ri quiwach y xquetaꞌmaj uwach. Pero ri Jesús e laꞌ chiquiwach xmalcaꞌnic. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xquibiꞌij cꞌu riꞌ chiquiwach: —¿Na camikꞌmot ta neba kacꞌuꞌx che quiꞌcotemal echiriꞌ rire cachꞌaꞌt kucꞌ pa ri be y cukꞌalajisaj chike Rutzij Upixab ri Dios? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na jampatana xeyactajic y xetzelej Jerusalem. Chiriꞌ xeboꞌlquirika ri junlajuj takoꞌn quimolom quib cucꞌ ri cachbiꞌil. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y rique xquibiꞌij chique wa caꞌib: «¡Pakatzij wi cꞌastajinak lo ri Kanimajawal Jesucristo ma xilitaj uwach ruma ri Simón!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yey la caꞌib xquijek utzijoxic saꞌ ri xquicꞌulumaj chupa ri be echiriꞌ xebec Emaús y suꞌanic xquetaꞌmaj uwach ri Jesús echiriꞌ xuwechꞌ upa ri pam. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Cꞌa quetajin ne che uchꞌaꞌtibexic ri quilom y ri quitom, echiriꞌ ri Jesús xwinakir chiquiwach, xakicꞌateꞌt xtaqꞌuiꞌ chiquixoꞌl y jewaꞌ xubiꞌij chique: —Cꞌola utzil chomal iwucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yey rique lic xquixiꞌij quib che, ma e chiquiwach rique laj juna espíritu ri caquitzutzaꞌ uwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Noꞌj ri Jesús xubiꞌij chique: —¿Suꞌchac cuxiꞌij rib icꞌuꞌx y na quicoj taj we in cꞌaslic? ");
INSERT INTO acrTNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chiwilape ri nukꞌab y ri wakan; chichapape rucꞌ rikꞌab y jelaꞌ quiwil chi utz lic in ri in cꞌo iwucꞌ y na xa ta in juna espíritu, ma juna espíritu na jinta utiꞌjil y na jinta ubakil pachaꞌ ri quiwil chwe riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y ecꞌuchiriꞌ cubiꞌij waꞌ, xucꞌut rukꞌab y ri rakan chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ecꞌu rique lic quequiꞌcotic y caminak canimaꞌ che yey na caquirik taj suꞌanic caquicoj ri caquilo. Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique: —¿Saꞌ ri cꞌo iwucꞌ re catijic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xquiya cꞌu che, juchꞌakap car bolom y uwaꞌal cab cꞌa cꞌo pa cera. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ewi Rire xucꞌamo y xutij chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ecꞌuchiriꞌ, xubiꞌij chique: —E nubiꞌim lo waꞌ chiwe echiriꞌ cꞌa in cꞌo iwucꞌ: Lic chirajawaxic wi cuꞌana na janipa ri tzꞌibital can panuwi riꞌin chupa ri Tzij Pixab re ri Moisés, chupa ri quitzꞌibam can ri kꞌalajisanelab y chupa tak ri Salmos —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Cꞌa tecꞌuchiriꞌ xujak ri quinaꞌoj chaꞌ caquimaj usucꞌ chi utz Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xubiꞌij cꞌu chique: —Jewaꞌ ri tzꞌibital can pa Ruchꞌaꞌtem ri Dios: Lic chirajawaxic wi ri Cristo, Ruchaꞌoꞌn lo ri Dios, cutij cꞌax, cacamic y cacꞌastaj lo churox kꞌij; ");
INSERT INTO acrTNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y chupa cꞌu rubiꞌ, catzijox ri Utzilaj Tzij re tzelebal tzij y re cuybal mac chique conoje ruqꞌuiyal quiwach tak ri ticawex e cꞌo che ruwachulew, yey cajeker utzijoxic waꞌ Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Riꞌix quibiꞌij cꞌu riꞌ chique ri winak janipa tak wa xiwilo y xito. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chitapeꞌ: Riꞌin cantak lo piwi riꞌix ri Jun ubiꞌtisim lo ri Nukaw; pero chixcꞌola wara chupa wa tinamit Jerusalem chaꞌ quiwoyꞌej na quicꞌul wa chukꞌab cape chilaꞌ chicaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ecꞌuchiriꞌ, ri Jesús xebucꞌam bi rutijoꞌn y xebec chunakaj Betania. Xuyac cꞌu rukꞌab paquiwiꞌ y xebuꞌan bendecir. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Echiriꞌ catajin che uꞌanic waꞌ, xujeko xel bi chiquixoꞌl y xcꞌam cꞌu bi chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ewi rutijoꞌn lic xquilokꞌnimaj ukꞌij ri Jesús. Tecꞌuchiriꞌ xetzelej chupa ri tinamit Jerusalem rucꞌ unimal quiꞌcotemal chupa ri canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y xaki e cꞌo chupa ri Rocho Dios, quebixonic y caquiyac ukꞌij ri Dios. Amén. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Che ri jekebal lo re ruwachulew, xex chi cꞌo lo wi ri Tzij; ri Tzij xex chi cꞌo lo wi rucꞌ ri Dios yey ri Tzij e ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ecꞌu ri Jun cabiꞌx “Ri Tzij” che, xex chi cꞌo lo wi rucꞌ ri Dios chwi echiriꞌ cꞌamajaꞌ ne cajeker lo ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ruma ne Rire, ri Dios xuꞌan ronoje ri cꞌo che ruwachulew. We tamaji Rire, na cuꞌan ta riꞌ ri Dios janipa ri cꞌolic. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Rucꞌ cꞌu Rire cꞌo wi ri cꞌaslemal, yey wa cꞌaslemal e Kꞌijsak chique ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ri Kꞌijsak cawon chupa ri kꞌekuꞌm, y ri kꞌekuꞌm na cuchꞌij ta cꞌana uchupic. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Cꞌo jun achi Juan rubiꞌ yey rire takom lo ruma ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri Juan xcꞌunic chaꞌ cukꞌalajisaj ri Kꞌijsak. Xoluꞌtzijoj cꞌu ri Kꞌijsak chaꞌ jelaꞌ ri ticawex caquicoj ri Kꞌijsak. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ri Juan na e ta ri Kꞌijsak, pero rire xcꞌunic re coꞌltzijon puwi ri Kꞌijsak. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri sakil Kꞌijsak cꞌuninak che ruwachulew, e cakꞌalajisan runaꞌoj ri Dios chiquiwach tak ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tob Rire e ꞌanayom re ronoje ri cꞌo che ruwachulew; echiriꞌ xcꞌun che ruwachulew, tak ri winak na xquetaꞌmaj ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Rire xcꞌun cucꞌ rutinamit, pero rutinamit na xquicꞌul taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Conoje cꞌu riꞌ ri xquicꞌulu y xquicoj rubiꞌ, xyaꞌtaj chique quebuꞌan e ralcꞌoꞌal ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ecꞌu rique xebuꞌan ralcꞌoꞌal ri Dios, na cuma ta ri quichu-quikaw na ruma ta rayibal que ticawex, yey na ruma tane ri xraj juna achi; ma e ruma ri xraj ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ecꞌu wa Tzij xuꞌan achi, xjekiꞌ cꞌu chikaxoꞌl riꞌoj, y xkil runimal uchomalil. Y wa unimal uchomalil e ri xuya ri Dios che Rire ruma xew Ucꞌajol riꞌ, yey Rire lic cꞌo unimal rutzil cꞌuꞌxaj y sakil Kꞌijsak rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri Juan xtzijon chwi Rire, jewaꞌ xubiꞌij: «Puwi Rire nubiꞌim chi lo waꞌ: E ri Jun catajin lo chwij, más cꞌo uwach chinuwa riꞌin ma Rire xex chi cꞌo lo wi echiriꞌ cꞌamajaꞌ quinalax riꞌin» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Che ronoje tak ri cꞌo pukꞌab, kacꞌamom co keꞌoj, ma ri unimal rutzil ucꞌuꞌx kucꞌ xaki uleꞌom rib. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Tzij Pixab xyaꞌ ruma ri Moisés; noꞌj ri unimal rutzil ucꞌuꞌx ri Dios y ri Kꞌijsak e xkꞌalajin ruma ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Na jinta junok iliyom uwach ri Dios; pero riꞌoj xketaꞌmaj uwach ruma ri Jun lic xa jun ucꞌuꞌx rucꞌ ri Dios, waꞌ e Rucꞌajol ri Dios, ri lic xew Ucꞌajol riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","E cꞌo jujun e aj judiꞌab re ri tinamit Jerusalem xequitak lo raj chacunel re ri Rocho Dios y raj levitas rucꞌ, chaꞌ caquitzꞌonoj che ri Juan china rire. Yey ri cꞌulubal uwach xuyaꞌo, lic kꞌalaj; ");
INSERT INTO acrTNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","na jinta cꞌo xrewaj chique. Jecꞌuwaꞌ xukꞌalajisaj chique: —Riꞌin na in ta Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ecꞌuchiriꞌ, xquitzꞌonoj tanchi che: —¿Lal china cꞌu riꞌ? ¿Lal ri kꞌalajisanel Elías? —xechaꞌ. Y rire xubiꞌij: —Na in taj —xchaꞌ. Xquitzꞌonoj cꞌu che: —¿Laj lal riꞌ ri jun kꞌalajisanel re ri Dios koyeꞌem cacꞌunic? —xechaꞌ. Rire xucꞌul cꞌu uwach: —Na in taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ecꞌuchiriꞌ, xquibiꞌij tanchi che: —¿Lal china cꞌu riꞌ? Ma riꞌoj oj petinak re cakacꞌam bi juna cꞌulubal uwach chique ri xetakaw lo keꞌoj. Biꞌij la chike saꞌ ri wach la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y rire xucꞌul uwach: —Riꞌin in ri jun tzijonel casiqꞌuin che ubiꞌxiquil chupa ri luwar catzꞌintzꞌotic: “Sucꞌupij alak rube ri Kanimajawal” jelaꞌ pachaꞌ ri tzꞌibital can ruma ri kꞌalajisanel Isaías —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri etakom lok re queboꞌlchꞌaꞌt rucꞌ ri Juan, e cuqꞌuil ri fariseos. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xquitzꞌonoj cꞌu riꞌ che ri Juan: —¿Saꞌ cꞌu uchac riꞌ caya la ri bautismo we na lal ta Ruchaꞌoꞌn lo ri Dios, na lal tane ri Elías yey na lal tane ri jun kꞌalajisanel re ri Dios koyeꞌem cacꞌunic? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri Juan xucꞌul uwach: —Riꞌin canya ri bautismo rucꞌ yaꞌ, noꞌj chixoꞌl ralak cꞌo Jun na etaꞌam ta alak uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ecꞌu waꞌ wa Jun catajin lo chwij riꞌin, e ri Jun xex chi cꞌo lo wi echiriꞌ cꞌamajaꞌ quinalax riꞌin y na takal tane chwe riꞌin canquir ruwach ruxajab —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronoje waꞌ xuꞌan pa ri luwar Betábara, chꞌaka yaꞌ che ri nimayaꞌ Jordán, pa cuya wi bautismo ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chucaꞌm kꞌij cꞌut ri Juan xril pan ri Jesús e riꞌ catajin roponic rucꞌ y jewaꞌ xubiꞌij: «Chiwilapeꞌ, waꞌ e ri Kꞌapoj Bexex re ri Dios, ri quesan re ri quimac ri ticawex che ronoje ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Puwi rire xintzijon wi echiriꞌ ximbiꞌij: “Chwij riꞌin catajin lo jun achi; rire más cꞌo uwach chinuwach riꞌin. Waꞌ xex chi cꞌo lo wi echiriꞌ cꞌamajaꞌ quinalax riꞌin.” ");
INSERT INTO acrTNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ri petinak lok na xinwetaꞌmaj taj china ri jun catajin lok; na rucꞌ ta cꞌu riꞌ, riꞌin xincꞌunic re canya ri bautismo rucꞌ yaꞌ, chaꞌ jelaꞌ ri tinamit Israel caquetaꞌmaj uwach rire» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xubiꞌij cꞌu ri Juan: «Riꞌin xinwil ri Ruxlabixel ri Dios xkaj lo chicaj pachaꞌ juna palomax y xcꞌojiꞌ puwi rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ecꞌu ri petinak lok na xinwetaꞌmaj taj china ri jun catajin lok; pero ri xtakaw lo we riꞌin chaꞌ canya ri bautismo rucꞌ yaꞌ, jewaꞌ xubiꞌij chwe: “Echiriꞌ cawil ri Santowilaj Ruxlabixel ri Dios cakaj lok y cacꞌojiꞌ puwi jun achi, e rire ri cuya ri bautismo rucꞌ ri Ruxlabixel ri Dios.” ");
INSERT INTO acrTNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ecꞌu riꞌin xinwilo y cankꞌalajisaj cꞌu waꞌ: Pakatzij wi, rire e Ucꞌajol ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chucaꞌm kꞌij cꞌut, ri Juan cꞌo tanchi chiriꞌ junam cucꞌ caꞌib chique rutijoꞌn rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Echiriꞌ xrilo xicꞌow ri Jesús, jewaꞌ xubiꞌij: —Chiwilapeꞌ, waꞌ e ri Kꞌapoj Bexex re ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Echiriꞌ ri caꞌib utijoꞌn ri Juan xquito xubiꞌij waꞌ, xeterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ecꞌuchiriꞌ ri Jesús xtzuꞌn chirij y xrilo eteran chirij, xubiꞌij chique: —¿Saꞌ ri quitzucuj? —xchaꞌ. Rique xquibiꞌij che: —Rabí (waꞌ queꞌelawi “lal tijonel”), ¿pachawi jekel wi la? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ri Jesús xucꞌul uwach: —Chixpetok, choꞌliwilaꞌ —xchaꞌ. Xebec cꞌut, xquilo pa jekel wi Rire y xecanaj cꞌu can la jun benebal kꞌij chiriꞌ rucꞌ, ma laj ucaj ora chic. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri Andrés ruchakꞌ ri Simón Pedro, e jun chique ri caꞌib xquita ri xubiꞌij ri Juan y xeterej bi chirij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ecꞌu ri Andrés nabe na xuꞌtzucuj ri ratz Simón; y echiriꞌ xuriko, jewaꞌ xubiꞌij che: —Ya xkarik ri Mesías —xchaꞌ. (“Mesías” e queꞌelawi ri Cristo, Ruchaꞌoꞌn lo ri Dios.) ");
INSERT INTO acrTNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Xucꞌam cꞌu bi ri Simón pa cꞌo wi ri Jesús. Ecꞌu ri Jesús echiriꞌ xril uwach, jewaꞌ xubiꞌij che: —Riꞌat at Simón, rucꞌajol ri Jonás; pero woꞌora rabiꞌ cancojo e Cefas (waꞌ queꞌelok Pedro) —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chucaꞌm kꞌij cꞌut, ri Jesús xraj xeꞌec pa ri luwar re Galilea. Xeꞌec cꞌut y xucꞌul jun achi Felipe rubiꞌ y xubiꞌij che: —Chat-tereja lo chwij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri Felipe aj pa ri tinamit Betsaida, waꞌ e tinamit pa ejekel wi ri Andrés y ri Pedro. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ecꞌu ri Felipe xuꞌtzucuj ri Natanael y echiriꞌ xuriko, jewaꞌ xubiꞌij che: —Xkarik ri jun ri xtzꞌiban ri Moisés puwiꞌ chupa ri Tzij Pixab, yey ri kꞌalajisanelab jenelaꞌ xetzꞌiban puwiꞌ: Waꞌ e ri Jesús, rucꞌajol ri José ri aj Nazaret —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Xubiꞌij cꞌu ri Natanael: —¿Cꞌo neba utz quel lo chupa ri tinamit Nazaret? —xchaꞌ. Ri Felipe xucꞌul uwach: —Saꞌa, chawilapeꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ri Jesús, echiriꞌ xrilo catajin roponic ri Natanael rucꞌ, jewaꞌ xubiꞌij: —Wa jun achi catajin lo ucꞌunic, e jun sakil aj Israel y na jinta socosoꞌnic rucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ecꞌu ri Natanael xutzꞌonoj che: —¿Chaꞌtaj etaꞌam la nuwach? —xchaꞌ. Ri Jesús xubiꞌij che: —Riꞌin xinwil pan awach echiriꞌ cꞌamajaꞌ ne catusiqꞌuij ri Felipe, echiriꞌ at cꞌo chuxeꞌ ri jun cheꞌ re higo —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Xubiꞌij cꞌu ri Natanael che: —Lal tijonel, rilal lal Ucꞌajol ri Dios y ri Rey que raj Israel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ri Jesús xucꞌul uwach: —¿Cacoj cami riꞌ waꞌ xa ruma ximbiꞌij chawe xatinwil pan chuxeꞌ ri jun cheꞌ re higo? Chikawach apanok, cawil ne cꞌutubal más nimaꞌk chwa tak waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y xubiꞌij ri Jesús: —Pakatzij wi cambiꞌij chiwe: Wa chikawach apanok quiwil ne ruwa caj jakalic y quebiwil ri ángeles re ri Dios quebakꞌanic y quekaj lo chwi Ralaxel Chiquixoꞌl Ticawex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oxib kꞌij ricꞌowic waꞌ, xꞌan jun cꞌulaniquil pa ri tinamit Caná re Galilea. Ruchu ri Jesús e jun chique ri e cꞌo chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ecꞌu ri Jesús, junam cucꞌ rutijoꞌn, xesiqꞌuix pa ri cꞌulaniquil. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yey cꞌamajaꞌ ne caqꞌuis ri nimakꞌij echiriꞌ xqꞌuis ri vino. Ecꞌu ruchu ri Jesús xubiꞌij che: —Xqꞌuis ri vino quetajin che ujachic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ri Jesús xucꞌul uwach: —Tape la, ¿suꞌchac cabiꞌij la waꞌ chwe riꞌin? Ma cꞌamajaꞌ copon ri ora cankꞌalajisaj nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ecꞌu ruchu ri Jesús xubiꞌij chique ri queniman chiriꞌ: —E ꞌana alak ronoje ri cubiꞌij rire che alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chiriꞌ cꞌu riꞌ cꞌo wakib tenaꞌx ꞌanatal rucꞌ abaj, waꞌ cacꞌoliꞌ yaꞌ chupa re quijoskꞌiquil raj judiꞌab chwach ri Dios. Chujujunal tenaꞌx, laj coc juna ochenta o juna cien litros yaꞌ chupa. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ri Jesús xubiꞌij chique ri queniman chiriꞌ: —Nojisaj alak che yaꞌ tak wa tenaꞌx —xchaꞌ. Ecꞌu rique xquinojisaj chi utz. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique: —Woꞌora chesaj lo alak jubikꞌ y cꞌama bi alak che ri aj wach re wa nimakꞌij —xchaꞌ. Y rique jelaꞌ xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ecꞌu ri aj wach re ri nimakꞌij xunaꞌ ri yaꞌ ꞌanom vino che, tob na retaꞌam ta nenareꞌ pa xpe wi. Xew ri queniman chiriꞌ quetaꞌam, ma e rique xebesan lo ri yaꞌ. Ecꞌu ri aj wach xusiqꞌuij rala xcꞌuliꞌic ");
INSERT INTO acrTNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y jewaꞌ xubiꞌij che: —Conoje ri ticawex nabe na e caquijach ri chomilaj vino, yey echiriꞌ ri echocom lic qꞌui chi ri quitijom, cꞌa ecꞌuchiriꞌ cajachiꞌ ri xaki tob vino. Noꞌj riꞌat cꞌa e laꞌ xawesaj lo ri sakil vino che wa qꞌuisbal re wa nimakꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","E nabe cꞌutubal waꞌ re ruchukꞌab ri Dios xuꞌan ri Jesús chilaꞌ Caná re Galilea. Rucꞌ waꞌ xukꞌalajisaj ri unimal uwach ukꞌij y ruma laꞌ rutijoꞌn lic xcubiꞌ quicꞌuꞌx rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Echiriꞌ icꞌowinak chi waꞌ, ri Jesús rucꞌ ruchu, cucꞌ tak ruchakꞌ y rutijoꞌn xebec pa ri tinamit Capernaúm. Yey na xecꞌojiꞌ ta chiriꞌ uqꞌuiyal kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xa nakaj chi cꞌo wi lo ri Pascua, waꞌ e quinimakꞌij raj judiꞌab. Ecꞌu ri Jesús xeꞌec pa ri tinamit Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chiriꞌ pa ri Rocho Dios, xebuꞌrika ri e aj cꞌay boyexab, bexex y palomax, cucꞌ ri e aj jachal uwach puak etzꞌul chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ecꞌuchiriꞌ, ri Jesús xuꞌan jun asial y rucꞌ waꞌ xeberesaj lo pa ri Rocho Dios conoje rique junam cucꞌ tak ri bexex y ri boyexab e cꞌo pa cꞌayij. Xuxulcꞌatilaꞌ tak bi ri quimexa ri e aj jachal uwach puak, y jelaꞌ xquichicoꞌb bi ri puak. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xubiꞌij cꞌu chique raj cꞌay que palomax: —¡Chesaj bi alak tak waꞌ! ¡Maꞌan alak cꞌaybal che ri Rocho ri Nukaw! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ecꞌuchiriꞌ, xcꞌun chiquicꞌuꞌx rutijoꞌn ri tzꞌibital pa Ruchꞌaꞌtem ri Dios pa cubiꞌij wi: Ruchajixic ri Ocho la lic e ubis nucꞌuꞌx riꞌ cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ecꞌu raj judiꞌab xquitzꞌonoj che: —¿Saꞌ ri cꞌutubal caꞌan la chikawach chaꞌ cakacojo yaꞌtal pakꞌab la caꞌan la waꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ri Jesús xucꞌul uwach: —We xwulij alak wa rocho ri Dios, xa pa oxib kꞌij riꞌin canyac tanchic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xquibiꞌij cꞌu raj judiꞌab che: —Waꞌ wa Rocho Dios pa cuarenta y seis junab xutzin wi. ¿Cayac cami la riꞌ rilal pa oxib kꞌij? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri “Rocho Dios” xchꞌaꞌt ri Jesús puwiꞌ, e rucuerpo Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E uwariꞌche, echiriꞌ xcꞌastaj lo chiquixoꞌl ri ecaminak, rutijoꞌn xcꞌun chiquicꞌuꞌx ri ubiꞌim chi lo chique. Cꞌa ecꞌuchiriꞌ xquimaj usucꞌ y xquicoj ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios puwi ri Jesús y ri biꞌtal can ruma Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Echiriꞌ cꞌo ri Jesús Jerusalem pa ri nimakꞌij Pascua, lic e qꞌui ri ticawex xquicoj rubiꞌ Rire ruma xquil tak ri cꞌutubal re ruchukꞌab ri Dios xuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Noꞌj ri Jesús na xcubiꞌ ta ucꞌuꞌx cucꞌ ma lic retaꞌam quiwach conoje. ");
INSERT INTO acrTNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na xajawax tane cabiꞌx che saꞌ ri caquichꞌob rakan ri winak, ma Rire retaꞌam saꞌ ri cꞌo chupa ri canimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Cꞌo jun achi Nicodemo rubiꞌ; rire e cuqꞌuil ri fariseos yey e jun aj wach que raj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rire xeꞌbina rucꞌ ri Jesús chakꞌab y xubiꞌij che: —Lal tijonel, lic kꞌalaj lal takom lo la ruma ri Dios re coꞌlcꞌutun la chikawach, ma na jinta junok caꞌanaw janipa wa cꞌutubal caꞌan la, we na jinta ri Dios rucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ecꞌu ri Jesús xubiꞌij che: —Pakatzij wi cambiꞌij cheꞌla: E junok we na calax ta tanchic, riꞌ na cayaꞌtaj ta che coc chupa rutakanic ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ri Nicodemo xutzꞌonoj che: —¿Suꞌanic cꞌu riꞌ calax junok e laꞌ nim chic? ¿Utz neba laꞌ camatzex tanchi ruma ruchu chaꞌ calax tanchic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij cheꞌla: China ri na calax ta rucꞌ yaꞌ y rucꞌ ri Ruxlabixel ri Dios, riꞌ na takal ta che coc chupa rutakanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","E junok calax cuma ruchu-ukaw, riꞌ lic rewi e jun ticawex; noꞌj ri calax ruma ri Ruxlabixel ri Dios, riꞌ cꞌo ucꞌaslemal chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Macam cꞌu animaꞌ la che wa ximbiꞌij cheꞌla: “Lic chirajawaxic chique conoje ri ticawex quebalax na tanchic.” ");
INSERT INTO acrTNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E pachaꞌ ri tew xa tob pa cawelel wi, xew cata la cajuxuxic, pero na etaꞌam ta la pa cape wi y pa cumaj wubi. Jecꞌulaꞌ ri quebalax ruma ri Ruxlabixel ri Dios na quilitaj taj suꞌanic ri Dios cuya ri cꞌacꞌ quicꞌaslemal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ecꞌu ri Nicodemo xutzꞌonoj tanchic: —¿Suꞌanic cuꞌana waꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xucꞌul uwach: —Lal tijonel chiquiwach raj Israel, ¿yey na etaꞌam tane la waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Pakatzij wi cambiꞌij waꞌ cheꞌla: Riꞌoj e cakatzijoj janipa ri ketaꞌam y ri kilom; na rucꞌ ta cꞌu riꞌ, ralak na cacoj ta alak saꞌ ri cantzijoj che alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We na cacoj ta alak echiriꞌ quintzijon puwi tak ri xa re ruwachulew, ¿saꞌ cꞌu uꞌanic riꞌ cacoj alak echiriꞌ quintzijon chiwach alak puwi tak ri re ri Dios cꞌo chilaꞌ chicaj? ");
INSERT INTO acrTNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na jinta junok benak chilaꞌ chicaj, xew ri jun petinak chilaꞌ, waꞌ e Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ma jelaꞌ pachaꞌ xuꞌan ri Moisés echiriꞌ xuyac jun cumatz chutzaꞌm jun cheꞌ pa ri luwar catzꞌintzꞌotic; jecꞌulaꞌ lic chirajawaxic wi Ralaxel Chiquixoꞌl Ticawex cayaquiꞌ chwa jun cheꞌ ");
INSERT INTO acrTNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chaꞌ china ri cacubiꞌ ucꞌuꞌx rucꞌ Rire, na casach ta uwach, ma cꞌo ucꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","»Ri Dios lic cꞌax xebunaꞌ ri e cꞌo che ruwachulew; y ruma cꞌu waꞌ, xutak lo Rucꞌajol, ri lic xew Ucꞌajol riꞌ, chaꞌ china ri cacubiꞌ ucꞌuꞌx rucꞌ Rire na casach ta uwach, ma cꞌo ucꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ma ri Dios na xutak ta lo Rucꞌajol che ruwachulew re coluꞌkꞌata tzij paquiwi ri ticawex; ri xutak wulok e chaꞌ queboluꞌcolobej. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","China cꞌu ri cacubiꞌ ucꞌuꞌx rucꞌ Rucꞌajol ri Dios, riꞌ na jinta ri kꞌatbal tzij re ri Dios puwiꞌ; noꞌj china ri na cacubiꞌ ta ucꞌuꞌx rucꞌ, riꞌ cꞌo chi ri kꞌatbal tzij re ri Dios puwiꞌ ruma na xucoj ta rubiꞌ Rucꞌajol ri Dios, ri lic xew Ucꞌajol riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yey ri kꞌatbal tzij cuꞌan ri Dios e ruma waꞌ: Ri Kꞌijsak re ri Dios xcꞌun che ruwachulew, pero tak ri ticawex e más xucꞌul quicꞌuꞌx ri kꞌekuꞌmalil re ri mac chwa ri Kꞌijsak; ma ri quetajin che uꞌanic, lic na chom taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Conoje ri caquiꞌan ri na utz taj, tzel caquil ri Kꞌijsak y na quekib ta rucꞌ chaꞌ na cakꞌalajin ta ri na utz taj quetajin che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Noꞌj conoje ri caquitijoj quib che jun sakil binic silabic, riꞌ quekib chwach ri Kꞌijsak chaꞌ cakꞌalajinic, ri quetajin che uꞌanic e ri caraj ri Dios chique —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tecꞌuchiriꞌ, ri Jesús junam cucꞌ rutijoꞌn xebec Judea; uqꞌuiyal kꞌij xcꞌojiꞌ chiriꞌ cucꞌ y cuya ri bautismo chique ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ecꞌu ri Juan catajin che uyaꞌic ri bautismo pa ri tinamit Enón chunakaj Salim, ma chilaꞌ lic cꞌo yaꞌ. Quebopon cꞌu ri ticawex rucꞌ chaꞌ caquicꞌul ri bautismo. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ri Juan xuꞌan waꞌ echiriꞌ cꞌamajaꞌ cayaꞌiꞌ pa cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ecꞌuchiriꞌ, jujun chique rutijoꞌn ri Juan cucꞌ jujun e aj judiꞌab xquijek quechꞌaꞌt chwi tak ri takanic chwi ri quijoskꞌiquil chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xebec cꞌut xeꞌquibiꞌij che ri Juan: —Lal tijonel, tape la, e ri jun xopon ucꞌ la chꞌaka yaꞌ che ri nimayaꞌ Jordán, ri xkꞌalajisan la puwiꞌ, woꞌora catajin che uyaꞌic ri bautismo y conoje ri ticawex eteran chirij —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ecꞌu ri Juan xubiꞌij chique: «Na jinta cꞌo cucꞌul junok we na e ta ri Dios chilaꞌ chicaj cayaꞌw re che. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Riꞌix xinito echiriꞌ ximbiꞌij chiwe: Riꞌin na in ta Ruchaꞌoꞌn lo ri Dios, xa in jun kꞌalajisanel intakom lo nabe chwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","»E pachaꞌ pa juna cꞌulaniquil. Ri lic cꞌo uwach na e ta ri ramigo rala, e rala cacꞌuliꞌic ma e ucꞌaꞌyom re rali. Yey ri ramigo cꞌo putzal rala, e lic caquiꞌcot che utayic ri cubiꞌij rala. Jecꞌulaꞌ riꞌin woꞌora lic quinquiꞌcotic ma ya xcꞌun ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lic cꞌu chirajawaxic más canimarisax ukꞌij rire, chwa ri canimarisax nukꞌij riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","»Ri jun cape chilaꞌ chicaj, e más nim uwach ukꞌij chiquiwa conoje. Ecꞌu junok na re ta chilaꞌ chicaj, e re ruwachulew y e cachꞌaꞌt puwi tak ri re ruwachulew. Noꞌj ri jun cape chilaꞌ chicaj, e más lic nim uwach ukꞌij chiquiwa conoje. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yey rire e cukꞌalajisaj saꞌ ri rilom y saꞌ rutom che ri Dios; na rucꞌ ta cꞌu riꞌ, tak ri winak na caquicoj taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yey we cꞌo junok cacojow ri cukꞌalajisaj rire, riꞌ cujiquibaꞌ uwach lic katzij ri cubiꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma ri jun takom lo ruma ri Dios, e cutzijoj ri cubiꞌij ri Dios. Ma ri Dios na xuxuꞌyaj ta ri Ruxlabixel uyaꞌom che; e uwariꞌche, xaki cꞌo ri Ruxlabixel rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Dios lic cꞌax cunaꞌ Rucꞌajol yey uyaꞌom pukꞌab rire ronoje ri cꞌolic. ");
INSERT INTO acrTNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","China cꞌu ri cacubiꞌ ucꞌuꞌx rucꞌ Rucꞌajol ri Dios, cꞌo ucꞌaslemal na jinta utakexic; noꞌj china ri na caraj taj cacubiꞌ ucꞌuꞌx rucꞌ Rucꞌajol ri Dios, riꞌ na jinta ucꞌaslemal rucꞌ ri Dios yey kꞌatom chi tzij puwiꞌ ruma ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Jesús xretaꞌmaj, ri fariseos xquito más e qꞌui rutijoꞌn Rire chiquiwa rutijoꞌn ri Juan, yey más e qꞌui ri caquicꞌul ri bautismo ruma Rire chiquiwa ri caquicꞌul ri bautismo ruma ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tob na e ta cꞌu ri Jesús ri cuya ri bautismo, ma e tak rutijoꞌn ri queyaꞌw re.) ");
INSERT INTO acrTNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ruma cꞌu ri Jesús retaꞌam ri xquita rique, xel bi pa ri luwar re Judea y xtzelej tanchi pa ri luwar re Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yey chirajawaxic che ri Jesús quicꞌow pa ri luwar re Samaria. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jecꞌulaꞌ xeꞌela pa jun tinamit Sicar rubiꞌ, cꞌo che ri luwar re Samaria, chunakaj rulew xuya can ri Jacob che rucꞌajol José. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chiriꞌ cꞌo wi ri jun pozo ucꞌotom can ri Jacob. Ruma cꞌu cosinak ri Jesús che ri be uꞌanom lok, xtzꞌuyiꞌ chunakaj ri pozo echiriꞌ ya cuꞌana pa tiqꞌuil kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Xcꞌun cꞌu lo jun ixok aj Samaria, e riꞌ coꞌlresaj bi uyaꞌ pa ri pozo, yey ri Jesús xubiꞌij che: —Sipaj la jubikꞌ nuyaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yey rutijoꞌn ri Jesús ebenak pa ri tinamit xeꞌquilokꞌo quiwa. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Rixok aj Samaria xubiꞌij cꞌu che: —¿Saꞌ riꞌ laꞌ catzꞌonoj yaꞌ la chwe? Ma rilal lal cuqꞌuil raj judiꞌab yey riꞌin in aj Samaria —xchaꞌ. Xubiꞌij waꞌ ma raj judiꞌab na quechꞌaw ta chiquiwach cucꞌ raj Samaria. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ewi ri Jesús xucꞌul uwach: —We ta cꞌu quetaꞌmaj la saꞌ ri cusipaj ri Dios cheꞌla yey we ta quetaꞌmaj la in china riꞌin, ri cantzꞌonoj nuyaꞌ cheꞌla, riꞌ e ne rilal catzꞌonoj la yaꞌ chwe yey riꞌin canya cꞌu cheꞌla ri yaꞌ cuya cꞌaslemal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Rixok xubiꞌij che ri Jesús: —Wajawal, na jinta ne saꞌ rucꞌ quesaj lo la ri yaꞌ yey ri pozo lic naj upa. ¿Pachawi cꞌu riꞌ quesaj wi lo la ri yaꞌ cuya cꞌaslemal? ");
INSERT INTO acrTNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","E ri kamam Jacob xuya can wa jun pozo chike ojertan, ma wara xutij wi uyaꞌ rire cucꞌ tak ri ralcꞌoꞌal y tak ri rawaj. ¿Más neba cꞌo wach rilal chwach rire? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ri Jesús xucꞌul uwach: —Conoje ri quetijow re waꞌ wa yaꞌ, catzajin tanchi quichiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noꞌj china ri catijow re ri yaꞌ canya riꞌin, riꞌ na cachakij ta chi cꞌana uchiꞌ. Ma ri yaꞌ canya riꞌin, cuꞌan pachaꞌ jun acꞌal calax lo pa ranimaꞌ re cuya ucꞌaslemal na jinta utakexic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Xubiꞌij cꞌu rixok che: —Wajawal, yaꞌa co la weꞌin riꞌ laꞌ la yaꞌ, chaꞌ na cachakij ta chi nuchiꞌ y na quincꞌun ta chi ne riꞌ cꞌa wara re coꞌlnuwesaj bi nuyaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xubiꞌij che: —Oj la, jeꞌsiqꞌuij la ri achijil la y cꞌamaꞌ cꞌu lo la wara —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ewi rixok xubiꞌij: —Riꞌin na jinta wachijil —xchaꞌ. Xubiꞌij cꞌu ri Jesús che: —Katzij ri xbiꞌij la, na jinta achijil la. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma e woꞌob lo rachijab e cꞌojiꞌnak ucꞌ la yey rachi cꞌo ucꞌ la woꞌora na achijil ta la. Ruma cꞌu riꞌ, lic katzij ri xbiꞌij la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Echiriꞌ xuta waꞌ rixok, xubiꞌij che ri Jesús: —Wajawal, e cunaꞌ nucꞌuꞌx riꞌin, rilal lal kꞌalajisanel re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri katiꞌ-kamam ri oj aj Samaria lic xquilokꞌnimaj ukꞌij ri Dios chwach wa juyub, noꞌj ri alak aj judiꞌab cabiꞌij alak e Jerusalem ri luwar pa chirajawaxic wi calokꞌnimax wi ukꞌij ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ri Jesús xubiꞌij che: —Ixok, lic cojo la wa cambiꞌij cheꞌla, ma copon na ri kꞌij na xew ta chi calokꞌnimax ukꞌij ri Dios wara chwa wa juyub o cꞌa chilaꞌ Jerusalem, ma utz caꞌaniꞌ waꞌ pa ronoje luwar. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ralak alak aj Samaria, na etaꞌam ta alak china ri calokꞌnimaj alak ukꞌij; noꞌj riꞌoj lic ketaꞌam chi utz china ri cakalokꞌnimaj ukꞌij, ma ri colobetajic cape cucꞌ raj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Noꞌj copon na cꞌu ri kꞌij yey ecꞌu ukꞌijol waꞌ xoponic echiriꞌ e janipa ri caquilokꞌnimaj ukꞌij ri Kakaw Dios pa sakil wi, caquiꞌano ruma ri Ruxlabixel cꞌo pa canimaꞌ. Ma e caraj waꞌ ri Kakaw Dios chique conoje ri quelokꞌniman re. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma ri Dios e Uxlabixel; Rire na quilitaj ta uwach. E uwariꞌche conoje ri quelokꞌniman ukꞌij, lic chirajawaxic wi quiꞌana waꞌ pa sakil wi ruma ri Ruxlabixel cꞌo pa canimaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Xubiꞌij cꞌu rixok che ri Jesús: —Riꞌin wetaꞌam cacꞌun Ruchaꞌoꞌn lo ri Dios, ri cabiꞌx “Cristo” che; y echiriꞌ cacꞌun Rire, cukꞌalajisaj ronoje chike —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubiꞌij che: —Waꞌ wa cabiꞌij la e riꞌin, ri quinchꞌaꞌt ucꞌ la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ecꞌuchiriꞌ, xetzelej lo rutijoꞌn y lic xcam canimaꞌ che ma ri Jesús cachꞌaꞌt rucꞌ jun ixok. Na rucꞌ ta cꞌu riꞌ, na jinta junok chique xutzꞌonoj saꞌ puwiꞌ cachꞌaꞌt wi rucꞌ rixok. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ecꞌuchiriꞌ, rixok xuya can rucꞌambaꞌ, xeꞌec pa ri tinamit y jewaꞌ cubiꞌij chique ri winak: ");
INSERT INTO acrTNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Peta alak, jeꞌilaꞌ alak jun achi ubiꞌim chwe janipa ri nuꞌanom. ¿Na e ta nawi rire ri Cristo? —cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ecꞌuchiriꞌ, xebel bi ri winak pa ri tinamit y xebec chilaꞌ pa cꞌo wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Echiriꞌ cꞌamajaꞌ quebopon ri winak, rutijoꞌn xquitij riꞌ che, jewaꞌ xquibiꞌij: —Lal tijonel, tija wa la —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ri Jesús xubiꞌij chique: —Riꞌin cꞌo ri nuwa cantijo, tob riꞌix na iwetaꞌam taj saꞌ waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ecꞌu rutijoꞌn xquijek caquibiꞌij chiquiwach: «¿Cꞌo nawi junok xcꞌamaw lo uwa?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ecꞌu ri Jesús xubiꞌij chique: «Ri nuwa riꞌin e ri canꞌan ri rajawal ucꞌuꞌx ri takayom lo weꞌin y canqꞌuis na cꞌu ruchac. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Riꞌix quibiꞌij: “Cajib icꞌ chic copon wi chaꞌ caꞌan ri molonic.” Noꞌj riꞌin cambiꞌij chiwe: Chixtzuꞌn apanok y chiwila chi utz ri ticoꞌn, ma ya riꞌj chic, utz chic camolic. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri cachacun che ri molonic, cucꞌul na ri tojbal re yey janipa ri cumolo, cꞌo cutikoj che rucꞌaslemal na jinta utakexic. Jecꞌulaꞌ, ri caticow re junam quequiꞌcot rucꞌ ri camolonic. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma e cuꞌana pachaꞌ ri cabiꞌxic: “Jun ri caticow re yey jun chic ri caꞌanaw re ri molonic.” ");
INSERT INTO acrTNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Riꞌin xixintak bi re quimol ri na xitic ta riꞌix; ma e jujun chic ri xeticow re. Ecꞌu woꞌora cꞌo quicꞌul riꞌix che ri chac que rique» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E qꞌui chique ri e aj Samaria xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús ruma ri xutzijoj rixok echiriꞌ xubiꞌij chique: «Rire xubiꞌij chwe janipa ri nuꞌanom.» ");
INSERT INTO acrTNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ruma cꞌu laꞌ, rique xecꞌun rucꞌ ri Jesús y lic xebelaj che chaꞌ cacanaj cucꞌ. Ewi Rire queb kꞌij xcanaj can cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yey más e qꞌui ri xcubiꞌ quicꞌuꞌx rucꞌ ruma ri xutzijoj Rire chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xquibiꞌij cꞌu che rixok: —Woꞌora lic cubul kacꞌuꞌx rucꞌ rire na xew ta ruma ri xatzijoj riꞌat chike, ma e ruma ri xkata ruchꞌaꞌtem rire. Ketaꞌam cꞌu riꞌ rire pakatzij wi e ri Cristo, ri Colobenel re ruwachulew —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Echiriꞌ icꞌowinak chi caꞌib kꞌij, ri Jesús xel bi chiriꞌ Samaria, xumaj bi ube y xeꞌec cꞌa Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ubiꞌim chi cꞌu ri Jesús: “Juna kꞌalajisanel na cayac ta ukꞌij pa rutinamit.” ");
INSERT INTO acrTNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na rucꞌ ta cꞌu riꞌ, echiriꞌ xopon chilaꞌ Galilea, ri aj chiriꞌ lic xquicꞌul chi utz, ma rique xebopon pa ri nimakꞌij Pascua chilaꞌ Jerusalem y xquilo janipa tak ri xuꞌan ri Jesús pa ri nimakꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ecꞌuchiriꞌ, ri Jesús xtzelej pa ri tinamit Caná re Galilea pa xuꞌan wi vino che ri yaꞌ. Cꞌo cꞌu jun aj wach raj chac ri rey chilaꞌ Capernaúm, y rire cꞌo jun ucꞌajol lic yewaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wa waꞌchi echiriꞌ xuto ri Jesús petinak Judea y cꞌo chi chiriꞌ Galilea, xeꞌec cꞌu che rilic y lic xeꞌelaj che chaꞌ queꞌec chirocho re cuꞌcunaj rucꞌajol cajecꞌowic. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Xubiꞌij cꞌu ri Jesús che: —Ralak na cacubiꞌ ta cꞌuꞌx alak wucꞌ we na quil ta tak cꞌutubal re ri nuchukꞌab o tak milagros canꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ri raj chac ri rey xubiꞌij tanchi che ri Jesús: —Wajawal, peta co la wucꞌ chiwocho, ma ri nucꞌajol cajecꞌowic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Xubiꞌij cꞌu ri Jesús che: —Oj la chi ocho la, ma ri cꞌajol la na cacam taj —xchaꞌ. Rachi xucoj ri xbiꞌx che ruma ri Jesús y xeꞌec. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Echiriꞌ catajin roponic chirocho, ri raj chaquib xebel lo che ucꞌulic y xquibiꞌij che: —¡Ri cꞌajol la na xcam taj ma xcunutajic! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ecꞌu rire xutzꞌonoj chique jampalaꞌ xujeko utz uwach rucꞌajol. Y rique xquibiꞌij che: —Iwir che ri nabe ora benak kꞌij xicꞌow ri akꞌ chirij —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jecꞌulaꞌ rukaw rala xretaꞌmaj e ora riꞌ xubiꞌij ri Jesús che: «Ri cꞌajol la na cacam taj.» Ruma cꞌu riꞌ laꞌ, rire cucꞌ conoje ri e cꞌo pa rocho xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wa jun cunanic e ucaꞌm cꞌutubal re ruchukꞌab ri Dios xuꞌan ri Jesús chilaꞌ Galilea echiriꞌ tzelejinak lo Judea. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Cꞌate tanchi cꞌu riꞌ, ri Jesús xtzelej Jerusalem echiriꞌ raj judiꞌab cꞌo jun quinimakꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chupa cꞌu laꞌ la tinamit, chunakaj ri Oquibal que Bexex, cꞌo jun nimalaj atinibal, “Betesda” rubiꞌ pa ri chꞌaꞌtem hebreo. Waꞌ woꞌob uchiꞌ ja cꞌo che. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiriꞌ e cꞌo uqꞌuiyal yewaꞌib e cotzꞌerinak; e cꞌo potzꞌ, jetzꞌ y sic. Conoje rique coyeꞌem echiriꞌ casilab ri yaꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ma xa chirij ora cakaj lo jun ángel y curujuraꞌ upa ri yaꞌ. Ecꞌu riꞌ ri nabe cucꞌak bi rib chupa, riꞌ quel lok cunutajinak chic tob saꞌ ri yabil cꞌo che. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Cꞌo cꞌu jun achi e treinta y ocho junab riꞌ yewaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Echiriꞌ ri Jesús xrilo cotzꞌol chiriꞌ y xretaꞌmaj uqꞌuiyal junab jelaꞌ uꞌanom, xutzꞌonoj cꞌu riꞌ che: —¿Cawaj catcunutajic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rachi jewaꞌ xucꞌul uwach: —Wajawal, na jinta junok cacꞌamaw bi we chupa ri atinibal echiriꞌ carujurut upa ri yaꞌ. Lic nutijom chi nukꞌij che cancꞌak bi wib chupa; pero echiriꞌ cuaj canꞌano, cꞌate canwilo jun chic canabej chinuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ri Jesús xubiꞌij che: —Chatyactajok, chacꞌama bi rachꞌat y chatbinok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chupa cꞌu laꞌ la jokꞌotaj rachi xcunutajic, xucꞌam bi ruchꞌat y xujeko cabinic. Yey waꞌ xuꞌan pa jun kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ruma cꞌu riꞌ, ri e aj judiꞌab xquibiꞌij che rachi xcunutajic: —Wakꞌij e kꞌij re uxlanibal, y na ube ta chawe cawucꞌaꞌaj rachꞌat —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rachi xucꞌul cꞌu uwach chique: —Ri jun xinucunaj e xbiꞌn re chwe: “Chacꞌama bi rachꞌat y chatbinok” —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Xquitzꞌonoj cꞌu che: —¿China ri xbiꞌn chawe: “Chacꞌama bi rachꞌat y chatbinok”? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ecꞌu rachi na retaꞌam taj china ri xcunaw re, ma ri Jesús xel bi chiquixoꞌl ri ticawex e cꞌo chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tecꞌuchiriꞌ, ri Jesús xuꞌrika rachi pa ri Rocho Dios y xubiꞌij che: —Chawilapeꞌ: Woꞌora at cunutajinak chic; matmacun chi cꞌu riꞌ, ma cꞌaxtaj cape juna cꞌaxcꞌobic más nim pawiꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xeꞌec rachi y xuꞌtzijoj chique raj judiꞌab e ri Jesús xcunaw re. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ruma waꞌ, raj judiꞌab xquijek uternabexic ri Jesús y caquitzucuj suꞌanic caquicamisaj, ma rire cuꞌan cunanic pa ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ecꞌu ri Jesús xubiꞌij chique: —Ri Nukaw na rokꞌotam taj cachacunic y jecꞌulaꞌ riꞌ canꞌan riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ruma waꞌ raj judiꞌab más xquiya quib che ucamisaxic ri Jesús, ma e chiquiwach rique cupalajij ri takanic puwi ri kꞌij re uxlanibal. Y na xew ta waꞌ, ma cujunimaj ne rib rucꞌ ri Dios echiriꞌ cubiꞌij ri Dios e Ukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ecꞌu ri Jesús xubiꞌij chique: «Pakatzij wi cambiꞌij che alak: Rucꞌajol ri Dios na jinta cꞌo cuꞌan xa pa re Rire; ma xew cuꞌan pachaꞌ ri carilo cuꞌan Rukaw. Janipa tak ri cuꞌan Rukaw, jecꞌulaꞌ cuꞌan Rucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","»Ma ri Dios lic cꞌax cunaꞌ Rucꞌajol y cucꞌut cꞌu che ronoje ri cuꞌano. Yey cꞌo ne ri más nimak tak chac cucꞌut chwach. Y we xuꞌan cꞌu waꞌ, lic cacam ne animaꞌ ralak che. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ma jelaꞌ pachaꞌ ri Dios quebucꞌastajisaj ri ecaminak y cuya quicꞌaslemal, jecꞌulaꞌ Rucꞌajol cuya cꞌaslemal china che ri caraj cuya wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yey ri Dios na cukꞌat tane tzij puwi junok, ma pukꞌab Rucꞌajol uyaꞌom wi cukꞌat tzij paquiwi ri ticawex, ");
INSERT INTO acrTNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chaꞌ jelaꞌ conoje ri ticawex caquiyac ukꞌij Rucꞌajol, jelaꞌ pachaꞌ caquiꞌan che uyaquic ukꞌij ri Dios. Yey china ri na cuyac ta ukꞌij Rucꞌajol ri Dios, na cuyac ta cꞌu ukꞌij riꞌ ri Jun xtakaw lo re, waꞌ e ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","»Pakatzij wi cambiꞌij che alak: China ri lic cuta chi utz ri cambiꞌij riꞌin y cacubiꞌ ucꞌuꞌx rucꞌ ri xtakaw lo we, riꞌ cꞌo ucꞌaslemal na jinta utakexic y na cucꞌul ta ri cꞌaxcꞌolil re ri kꞌatbal tzij. Jecꞌulaꞌ, na jinta chi pukꞌab ri camic, ma asu xkꞌax chupa ri cꞌaslemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Pakatzij wi cambiꞌij che alak: Copon cꞌu ri ora y e chi ukꞌijol waꞌ echiriꞌ ri na jinta quicꞌaslem chwach ri Dios, caquita rukul Rucꞌajol ri Dios. Yey china tak cꞌu riꞌ ri caquicoj utzij, cꞌo quicꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ma pukꞌab ri Kakaw Dios cꞌo wi cuya cꞌaslemal; jecꞌulaꞌ uyaꞌom pukꞌab Rucꞌajol cuya cꞌaslemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yey ri Dios uyaꞌom ne pukꞌab Rucꞌajol cukꞌat tzij paquiwi ri ticawex, ma Rucꞌajol e Alaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","»Macam animaꞌ alak che waꞌ, ma copon ri ora echiriꞌ conoje ri ecaminak caquita rukul Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Janipa ri xquiꞌan ri utz, riꞌ queyactaj lo che jun cꞌastajibal re cꞌaslemal. Noꞌj janipa cꞌu ri xquiꞌan ri na utz taj, riꞌ queyactaj lo che ri kꞌatbal tzij caꞌan paquiwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","»Na jinta cꞌo canꞌan xa pa we riꞌin. Ri kꞌatbal tzij canꞌano e ri quinutak ri Nukaw che uꞌanic. Yey lic jusucꞌ ri kꞌatbal tzij canꞌano. Na e ta canꞌan riꞌ ri cuaj riꞌin; ma e canꞌan janipa ri caraj ri Nukaw, ri xtakaw lo we. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We ta e laꞌ xa chiwibil wib riꞌin cankꞌalajisaj saꞌ ri nuwach, riꞌ na jinta uchac ri cambiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Cꞌo cꞌu Jun cakꞌalajisan nuwach, waꞌ e ri Nukaw, y wetaꞌam cꞌut ronoje ri cukꞌalajisaj Rire panuwi riꞌin, lic katzij. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","»Ralak xtak ne bi alak utzꞌonoxic che ri Juan panuwi riꞌin; y ri cꞌulubal uwach xuꞌan lo rire, lic katzij. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero riꞌin na cajawax ta chwe cꞌo junok cukꞌalajisaj saꞌ ri nuwach. Xew cꞌu cancuxtaj che alak ri xubiꞌij ri Juan panuwi riꞌin chaꞌ cacoj alak y jelaꞌ cacolobetaj alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma ri Juan e pachaꞌ juna akꞌ carepowic y cawon chi utz. Pero ralak xa jokꞌotaj xquiꞌcot alak che ri Kꞌijsak xutzijoj. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","»Cꞌo cꞌu jun cꞌutubal más cꞌo uwach chwa ri xukꞌalajisaj ri Juan panuwi riꞌin. Ma ronoje rubiꞌim lo ri Nukaw chwe re coꞌlnuꞌanaꞌ, e ri quintajin che uꞌanic. Yey ruma tak ri canꞌano, cakꞌalajinic, e ri Nukaw ri xtakaw lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yey ri cakꞌalajisan re saꞌ ri nuwach riꞌin e ri Nukaw, ri takayom lo weꞌin. Pero lic kꞌalaj na tom ta cꞌana alak rukul ri Dios y na ilom ta alak uwach, yey ");
INSERT INTO acrTNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ruchꞌaꞌtem Rire na oquinak ta pa animaꞌ alak; ma na cubul ta cꞌuꞌx alak rucꞌ ri jun utakom lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","»Lic cꞌu catijoj ib alak che Ruchꞌaꞌtem ri Dios tzꞌibital canok; ma ralak cachꞌob alak e chupa waꞌ carikitaj wi ri cꞌaslemal na jinta utakexic. ¡Yey ecꞌu riꞌ Ruchꞌaꞌtem ri Dios ri cakꞌalajisan nuwach riꞌin! ");
INSERT INTO acrTNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Na rucꞌ ta cꞌu riꞌ, na caꞌaj ta alak cape alak wucꞌ chaꞌ jelaꞌ cacꞌul alak waꞌ wa cꞌaslemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","»Riꞌin na e ta cantzucuj ri yacbal nukꞌij caquiꞌan ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yey lic ne wetaꞌam ri cꞌuꞌx alak, ma ralak na cꞌax ta canaꞌ alak ri Dios pa sakil wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Riꞌin in petinak pa rubiꞌ ri Nukaw yey ralak na cacoj ta alak nutzij. Noꞌj we ta e laꞌ cacꞌun chi lo jun chic y xa pa re catzijonic, riꞌ e cacoj alak re. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","»¿Suꞌanic cacubiꞌ cꞌuꞌx alak wucꞌ riꞌin, we xew catzucuj yacbal kꞌij alak chiwach ralak yey na catzucuj ta alak ri sakil yacbal kꞌij, ri xew cape rucꞌ ri Dios? ");
INSERT INTO acrTNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","E chiwach ralak cancoj mac alak chwach ri Nukaw; na e ta riꞌ. Ma ri cacojow mac chiꞌij alak, e ri jun lic cubam cꞌuꞌx alak rucꞌ; waꞌ e ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma we ta e laꞌ lic cacoj alak ri ubiꞌim lo ri Moisés, riꞌ cacoj alak ri cantzijoj riꞌin. Ma rire panuwi riꞌin xtzꞌiban wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Noꞌj we na cacoj ta alak rutzꞌibam can ri Moisés, ¿saꞌ cꞌu uꞌanic riꞌ cacoj alak ri cambiꞌij riꞌin che alak?» xcha ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Cꞌate tanchi cꞌu riꞌ, ri Jesús xukꞌaxuj ri mar re Galilea, ri cabiꞌx mar re Tiberias che. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yey uqꞌuiyal winak eteran chirij ma quilom tak ri cꞌutubal re ruchukꞌab cuꞌan cucꞌ ri yewaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ecꞌuchiriꞌ, ri Jesús xel bi chwa jun juyub y xtzꞌuyiꞌ chilaꞌ junam cucꞌ rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa nakaj chi cꞌo wi lo rukꞌijol ri Pascua, ri quinimakꞌij raj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Echiriꞌ ri Jesús xeril ruqꞌuiyal winak e petinak rucꞌ, xubiꞌij cꞌu che ri Felipe: —¿Pa queꞌkalokꞌo wi quiwa conoje wuꞌqꞌuiyal winak chaꞌ quewaꞌic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xubiꞌij waꞌ che ri Felipe xa re cꞌambal upa, ma Rire retaꞌam chic saꞌ ri cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ri Felipe xucꞌul uwach: —E laꞌ calokꞌiꞌ pam rucꞌ rajil queb ciento kꞌij re chac, na cuꞌan taj tob ne xa jutak bikꞌ cayaꞌiꞌ chiquijujunal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ewi jun chique rutijoꞌn (waꞌ e ri Andrés, ri quichakꞌ quib rucꞌ ri Pedro) xubiꞌij che ri Jesús: ");
INSERT INTO acrTNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Cꞌo jun ralco ala wara rucꞌaꞌam woꞌob pam re cebada y caꞌib car; pero ¿saꞌ co uchac waꞌ che wa uqꞌuiyal winak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Xubiꞌij cꞌu ri Jesús: —Chibiꞌij chique conoje ri winak quetzꞌuyiꞌic —xchaꞌ. Lic cꞌut cꞌo rax qꞌuim pa ri e cꞌo wi y xetzꞌuyiꞌ laj e lo woꞌob mil chi achijab. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ecꞌuchiriꞌ, ri Jesús xucꞌam ri pam, xutioxij che ri Dios y xujach chique rutijoꞌn. Y rique xquijach chique ri winak etzꞌulic. Jecꞌulaꞌ xuꞌan che ri car. Xuya chiquijujunal janipa ri cacaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Echiriꞌ ri winak lic xenoj chi utz, ri Jesús xubiꞌij chique rutijoꞌn: —Chimolo ri chꞌakaꞌtaꞌk quikax chaꞌ na jinta cꞌo cacꞌak bi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xquimol cꞌu ri chꞌakaꞌtaꞌk quikax na xquitij ta che ri woꞌob pam re cebada y rucꞌ waꞌ xquinojisaj cablajuj chacach. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ecꞌu ri winak, echiriꞌ xquil wa cꞌutubal re ruchukꞌab ri Dios xuꞌan ri Jesús, jewaꞌ xquibiꞌij: «Pakatzij wi, waꞌ e ri jun Kꞌalajisanel koyeꞌem cacꞌun che ruwachulew» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero ri Jesús ruma retaꞌam chic cacaj caquicꞌam bi re caquiꞌan rey che, xresaj bi rib chiquixoꞌl y xel bi chwa ri juyub chaꞌ cacꞌojiꞌ utuquel. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Echiriꞌ xoc rakꞌab, rutijoꞌn ri Jesús xekaj chuchiꞌ ri mar. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Xeboc bi chupa jun barco y ecꞌu riꞌ quekꞌax chꞌaka yaꞌ chaꞌ quebopon Capernaúm; ma lic kꞌekuꞌm chic y ri Jesús na cꞌuninak taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xpe cꞌu jun cakjikꞌ chwi ri mar y ri tew xujek cuxulcꞌatilaꞌ ri yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Echiriꞌ ebininak chi laj woꞌob o wakib kilómetro chwi ri mar, cꞌate xquilo cabin ri Jesús chwi ri yaꞌ, e riꞌ catajin roponic chunakaj ri barco; y rique lic xquixiꞌij quib che. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Noꞌj ri Jesús xubiꞌij chique: —¡Mixiꞌij iwib, ma riꞌin in Jesús! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ewi rique lic quequiꞌcotic xquicꞌul ri Jesús chupa ri barco. Tecꞌuchiriꞌ, xebopon pa ri luwar pa quebec wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chucaꞌm kꞌij cꞌut, ri winak ecanajinak can chꞌaka mar xquinaꞌbej rutijoꞌn ri Jesús ebenak chi chupa ri barco ri xew riꞌ cꞌo chiriꞌ iwir lo riꞌ, yey ri Jesús na xeꞌec ta cucꞌ rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xecꞌun cꞌu lo jujun barcos e petinak Tiberias, chunakaj ri luwar pa xtijiꞌ wi ri pam, echiriꞌ ri Kanimajawal utioxim chi waꞌ che ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Echiriꞌ ri winak xquilo na jinta ri Jesús chiriꞌ y na e jinta ne rutijoꞌn, xeboc bi chupa wa barcos y xebec Capernaúm chaꞌ caquitzucuj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Echiriꞌ xebopon ri winak chꞌaka mar, xeꞌquirika ri Jesús y xquitzꞌonoj che: —Lal tijonel, ¿jampa xcꞌun la wara? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ecꞌu ri Jesús xubiꞌij chique: —Pakatzij wi cambiꞌij che alak: Quintzucuj alak xa ruma lic xwaꞌ alak chi utz y xnoj alak chi utz, na e ta ruma xmaj alak usucꞌ tak ri cꞌutubal re ruchukꞌab ri Dios nuꞌanom lok. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Maya cꞌu ib alak che utzucuxic ri wa xa caqꞌuisic; e lic yaꞌa ib alak che utzucuxic ri wa na quicꞌow ta cꞌana ukꞌij, ri cuya cꞌaslemal na jinta utakexic. Yey ri cayaꞌw waꞌ che alak, e Ralaxel Chiquixoꞌl Ticawex, ri chaꞌtal lo ruma ri Kakaw Dios re cuꞌan waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xquitzꞌonoj cꞌu che: —¿Saꞌ tak ri cakaꞌano chaꞌ e cakaꞌan janipa ri caraj ri Dios chike? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xucꞌul uwach: —Ri caraj ri Dios caꞌan alak, e ri cacubiꞌ cꞌuꞌx alak rucꞌ ri jun utakom lo Rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ecꞌuchiriꞌ xquitzꞌonoj che: —¿Saꞌ ri cꞌutubal re ruchukꞌab ri Dios caꞌan la chikawach chaꞌ cakilo y jelaꞌ cacubiꞌ kacꞌuꞌx ucꞌ la? ¿Saꞌ ri carik la uꞌanic? ");
INSERT INTO acrTNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ma ri katiꞌ-kamam ojertan xquitij ri maná pa ri luwar catzꞌintzꞌotic, jelaꞌ pachaꞌ ri cubiꞌij Ruchꞌaꞌtem ri Dios: Xuya pam chique, y waꞌ petinak chilaꞌ chicaj —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij che alak: Na e ta ri Moisés xyaꞌw re ri pam petinak chilaꞌ chicaj; e ri Nukaw ri cayaꞌw ri sakil pam cape chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma ri Pam cuya ri Dios e ri jun petinak chilaꞌ chicaj, ri cayaꞌw cꞌaslemal chique ri ticawex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xquitzꞌonoj cꞌu che: —Kajawal, yaꞌa co la keꞌoj riꞌ laꞌ la pam ronoje kꞌij —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ri Jesús xubiꞌij chique: —In ri in pam cuya cꞌaslemal. China ri cape wucꞌ riꞌin, na cutij ta chi numic; y china ri cacubiꞌ ucꞌuꞌx wucꞌ, riꞌ na cachakij ta chi cꞌana uchiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","»Pero e pachaꞌ ri nubiꞌim chi lo che alak: Ralak na cacubiꞌ ta cꞌuꞌx alak wucꞌ, tob ne ilom alak nuwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma conoje ri queyaꞌiꞌ chwe ruma ri Nukaw, quecꞌun wucꞌ riꞌin; yey china cꞌu riꞌ ri cape wucꞌ riꞌin, na canmachꞌaj tubi. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","»Riꞌin na ximpe ta chilaꞌ chicaj xa re coꞌlnuꞌana ri cuaj riꞌin, ma e in petinak re coꞌlnuꞌana ri caraj ri Jun xtakaw lo we. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yey ri caraj ri Nukaw, ri xintakaw lok, e na canjam ta can junok chique ri ebuyaꞌom Rire chwe; ma e quenucꞌastajisaj lo conoje waꞌ chupa ri qꞌuisbal kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ecꞌu ri lic caraj ri Nukaw, ri xtakaw lo weꞌin, e waꞌ: Conoje ri ticawex, ri caquiya ri quiwach wucꞌ ri in Ucꞌajol ri Dios y cacubiꞌ cꞌu quicꞌuꞌx wucꞌ, cacꞌojiꞌ quicꞌaslemal na jinta utakexic. Ecꞌu riꞌin quenucꞌastajisaj lo chiquixoꞌl ri ecaminak chupa ri qꞌuisbal kꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Rucꞌ cꞌu riꞌ waꞌ, raj judiꞌab xquijek quechꞌaꞌt chirij ri Jesús ruma ri xubiꞌij: «In ri in pam petinak chilaꞌ chicaj.» ");
INSERT INTO acrTNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xquibiꞌij cꞌu riꞌ: «¿Na e ta neba Jesús waꞌ, rucꞌajol ri José? Riꞌoj ketaꞌam uwach rukaw y ketaꞌam uwach ruchu. ¿Suꞌchac cꞌu riꞌ cubiꞌij petinak chilaꞌ chicaj?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Xubiꞌij cꞌu ri Jesús chique: —Mixchꞌaꞌtiben chiwach chirij wa ximbiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma na jinta junok cape wucꞌ riꞌin, we na e ta cꞌamayom lo ri Nukaw, ri takayom lo weꞌin. Yey ri cape wucꞌ, cancꞌastajisaj lo chupa ri qꞌuisbal kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","»Jewaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios chupa ri tzꞌibital can cuma ri kꞌalajisanelab: Copon na ri kꞌij echiriꞌ e ri Dios ri cacꞌutun chiquiwach conoje cachaꞌ. Y conoje ri caquita ri cubiꞌij ri Nukaw y caquimaj cꞌu que janipa ri cubiꞌij, riꞌ quecꞌun wucꞌ riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma na jinta jun chic iliyom uwach ri Kakaw Dios; xew ri jun petinak rucꞌ ri Dios, e iliyom uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","»Pakatzij wi cambiꞌij che alak: China ri cacubiꞌ ucꞌuꞌx wucꞌ riꞌin, cꞌo ucꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma in ri in pam cuya cꞌaslemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","»Ojertan ri chuꞌkaw alak xquitij ri maná pa ri luwar catzꞌintzꞌotic; na rucꞌ ta cꞌu riꞌ, rique xecamic. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Noꞌj riꞌin e quinchꞌaꞌt chwi ri pam cape chilaꞌ chicaj; yey we cꞌo junok catijow re waꞌ, riꞌ na cacam taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","»Ri pam re cꞌaslemal petinak chilaꞌ chicaj e riꞌin. China cꞌu catijow re wa pam, cꞌo ucꞌaslemal na jinta utakexic. Yey ri pam canya riꞌin, e ri nutiꞌjil canya pa cꞌax chaꞌ tak ri ticawex cꞌo quicꞌaslemal chwach ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ecꞌuchiriꞌ, raj judiꞌab xquijek caquichapalaꞌ quib chiquiwach, jewaꞌ caquibiꞌij: «¿Suꞌanic waꞌchi caraj cuya chitijic rutiꞌjil chike?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ri Jesús xubiꞌij chique: —Pakatzij wi cambiꞌij che alak: We e laꞌ na catij ta alak ri nutiꞌjil ri in Alaxel Chiquixoꞌl Ticawex y we na catij ta alak ri nuquiqꞌuel, riꞌ na jinta cꞌaslemal alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","China cꞌu ri cutij ri nutiꞌjil y ri nuquiqꞌuel, riꞌ cꞌo ucꞌaslemal na jinta utakexic, yey riꞌin cancꞌastajisaj lo chupa ri qꞌuisbal kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ma ri nutiꞌjil e sakil waꞌim y ri nuquiqꞌuel e sakil yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","China cꞌu ri cutij ri nutiꞌjil y cutij ri nuquiqꞌuel, riꞌ cacꞌojiꞌ wucꞌ y riꞌin quincꞌojiꞌ rucꞌ rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","»Ri Kakaw Dios, ri aj yaꞌl cꞌaslemal, e ri xtakaw lo weꞌin; yey cꞌo nucꞌaslemal ruma Rire. Jecꞌulaꞌ china ri cutij ri nutiꞌjil riꞌin, riꞌ cꞌo ucꞌaslemal wuma riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Quinchꞌaꞌt chwi ri pam petinak chilaꞌ chicaj. Waꞌ na e ta pachaꞌ ri maná xquitij ri chuꞌkaw alak ojertan. Ma tob xquitij ri maná, rique xecamic. Noꞌj china ri cutij re wa pam cambiꞌij riꞌin, riꞌ cꞌo ucꞌaslemal na jinta utakexic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E cꞌutunic waꞌ xuꞌan ri Jesús pa quimolom wi quib chupa ri sinagoga re Capernaúm. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Echiriꞌ xquita ri cꞌutunic xuꞌan ri Jesús, lic e qꞌui chique rutijoꞌn xquibiꞌij: «Waꞌ wa cubiꞌij, lic cꞌax utayic. ¿Cꞌo neba junok cachꞌijow ucꞌulic?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ecꞌu ri Jesús xunaꞌbej ri chꞌaꞌtibenic caquiꞌan chwi rucꞌutunic. Xutzꞌonoj cꞌu chique: —¿Cuꞌan cꞌax waꞌ che alak? ");
INSERT INTO acrTNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Saꞌ cꞌu riꞌ ri caꞌan alak we ta e laꞌ quil alak Ralaxel Chiquixoꞌl Ticawex cakꞌan chilaꞌ chicaj pa petinak wi? ");
INSERT INTO acrTNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri sakil cꞌaslemal na jinta utakexic petinak rucꞌ ri Ruxlabixel ri Dios; na e ta ri petinak xa rucꞌ ri ticawex, ma riꞌ na jinta uchac re cuya ri sakil cꞌaslemal. Ecꞌu ri chꞌaꞌtem nubiꞌim riꞌin che alak, waꞌ petinak rucꞌ ri Ruxlabixel ri Dios, ri aj yaꞌl cꞌaslemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero e cꞌo cꞌu jujun chixoꞌl alak na cubul ta quicꞌuꞌx wucꞌ —xchaꞌ. Ri Jesús xubiꞌij waꞌ ma xex chi retaꞌam wi china tak ri na cubul ta quicꞌuꞌx rucꞌ y china ri cacꞌayin re. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Xubiꞌij tanchi ri Jesús: —Ecꞌu uwariꞌche nubiꞌim che alak: Na jinta junok cape wucꞌ, we na e ta ri Nukaw cꞌamayom lo re —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chwi cꞌu riꞌ, e qꞌui chique rutijoꞌn ri Jesús xquiya canok y na xeterej ta chi chirij. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ecꞌuchiriꞌ, xutzꞌonoj ri Jesús chique ri cablajuj utijoꞌn: —¿Quiwaj neba riꞌix quiꞌan iwe quiniya canok, pachaꞌ ri xquiꞌan rique? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ri Simón Pedro xucꞌul uwach: —Kajawal, ¿china chi chirij cojꞌec wi? Ma xew ucꞌ rilal cꞌo ri chꞌaꞌtem cuya cꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Riꞌoj lic cubul chi kacꞌuꞌx ucꞌ la y lic ketaꞌam waꞌ: Lal Ruchaꞌoꞌn lo ri Dios, Rucꞌajol ri Dios cꞌaslic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ri Jesús xucꞌul uwach: —¿Na in ta neba inchaꞌyom iwe riꞌix ix cablajuj? Na rucꞌ ta cꞌu riꞌ, jun chiwe cꞌo ritzel winak pa ranimaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Echiriꞌ xubiꞌij waꞌ, ri Jesús e xchꞌaꞌt puwi ri Judas aj Iscariot rucꞌajol ri Simón; ma e ri Judas cacꞌayin re, tob e jun chique ri cablajuj utijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Cꞌate tanchi cꞌu riꞌ, ri Jesús xbin pa tak ri luwar re Galilea; na xraj taj cacꞌojiꞌ Judea ma chilaꞌ raj judiꞌab cacaj caquicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Xa cꞌu nakaj chi cꞌo wi lo rukꞌijol ri quinimakꞌij raj judiꞌab echiriꞌ caquiꞌan quirancho. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","E tak cꞌu ruchakꞌ xquibiꞌij che: —Matcanaj can wara; jat Judea chaꞌ ri jujun chic atijoꞌn e cꞌo chilaꞌ caquilo saꞌ tak ri caꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma we junok caraj quetaꞌmax uwach, ronoje ri cuꞌano cuꞌan chiwachil. E uwariꞌche, chaꞌana waꞌ chiquiwach conoje ri ticawex —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Xquibiꞌij waꞌ che ma na caquicoj taj we Rire e Ruchaꞌoꞌn lo ri Dios, tob ne rique e uchakꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Xubiꞌij cꞌu Rire chique: —Ri nukꞌijol riꞌin cꞌamajaꞌ coponic; noꞌj riꞌix, xa tob pachique kꞌij utz chiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri ticawex re ruwachulew na tzel ta quixquil riꞌix; noꞌj riꞌin lic tzel quinquilo, ma cankꞌalajisaj chi utz ri quimac. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jix riꞌix che ri nimakꞌij; noꞌj riꞌin na quinꞌec ta woꞌora, ma cꞌamajaꞌ copon ri nukꞌijol —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Xubiꞌij cꞌu waꞌ y xcanaj can Galilea. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ecꞌuchiriꞌ ebenak chi ruchakꞌ, ri Jesús xeꞌec pa ri nimakꞌij, pero na xeꞌec ta chiwachil chaꞌ tak ri winak na caquinaꞌbej taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pa ri nimakꞌij raj judiꞌab lic caquitzucuj ri Jesús, y jewaꞌ caquibiꞌij: «¿Pa nawi cꞌo wi laꞌ la jun achi?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chiquixoꞌl ri winak lic e qꞌui ri caquichꞌaꞌtibej ri Jesús. Jujun caquibiꞌij: «Laꞌ la Jesús lic utz ucꞌuꞌx» quechaꞌ. Yey e cꞌo jujun chic caquibiꞌij: «Laꞌ la Jesús lic na utz ta ri cuꞌano ma xa quebusoc ri winak» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero na jinta cꞌu junok cachꞌaꞌt puwi ri Jesús chiwachil; xa xeꞌlakꞌay quechꞌaꞌt puwiꞌ, ma caquixiꞌij quib chiquiwach raj judiꞌab e aj wach. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ecꞌu riꞌ nicꞌajarinak chi ri nimakꞌij xopon ri Jesús pa ri Rocho Dios y xujeko cacꞌutun chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Raj judiꞌab lic xcam canimaꞌ che y jewaꞌ xquibiꞌij: «¿Chaꞌtaj lic cꞌo retaꞌam yey na jinta cꞌo cꞌutuyum chwach?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ri Jesús xucꞌul uwach: —Ri quintajin che ucꞌutic na xa ta pa we riꞌin canꞌano; ma waꞌ petinak rucꞌ ri takayom lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","We cꞌo cꞌu junok lic cuya rib che uꞌanic ri caraj ri Dios, riꞌ caretaꞌmaj we ri cancꞌutu rucꞌ ri Dios cape wi, o we xa pa we riꞌin quinchꞌaꞌtic. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma china ri xa pa re cachꞌaꞌtic, riꞌ xew caraj cayac ukꞌij cuma ri winak. Noꞌj china ri caraj e cayac ukꞌij ri takayom lo re, riꞌ lic katzij ri cutzijoj y na jinta cꞌana rakꞌubal cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","»¿Na katzij ta neba laꞌ e ri Moisés xyaꞌw che alak ri Tzij Pixab? Na rucꞌ ta cꞌu riꞌ, na jinta junok che alak caꞌanaw re ronoje ri cꞌo chupa wa Tzij Pixab. ¿Suꞌchac caꞌaj alak quincamisaj alak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ecꞌu tak ri winak xquicꞌul uwach: —Lal cꞌo pukꞌab jun itzel uxlabixel. ¿China ri caraj cacamisan e la? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri Jesús xubiꞌij chique: —Riꞌin cꞌo jun cꞌutubal re ruchukꞌab ri Dios xinꞌano, yey onoje ralak lic cacam animaꞌ alak che ma xinꞌan waꞌ chupa ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","»Pakatzij wi, ri Moisés xuya che alak ri jun takanic re ri retalil re circuncisión tob na e ta rire xjekow lok, ma e xejekow lo re ri katiꞌ-kamam ojertan. Yey ralak cacoj alak ri retalil re circuncisión che junok tob pa ri kꞌij re uxlanibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Caꞌan alak waꞌ ma ri takanic re ri Moisés cutak che caꞌaniꞌ ri circuncisión pa ri uwajxak kꞌij ralaxibem juna ralco ala. Caꞌan cꞌu alak riꞌ, tob waꞌ catzak pa ri kꞌij re uxlanibal, chaꞌ na capalajij ta alak wa takanic re ri Moisés. ¿Suꞌbe cꞌu riꞌ cꞌo oyowal alak chwij riꞌin ruma xincunaj jun achi pa ri kꞌij re uxlanibal? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","»Macoj alak umac junok xa ruma cachꞌob alak etaꞌam alak ri uꞌanom; ri ꞌana alak e chꞌobo alak rucꞌ sakil naꞌoj puwi ri pakatzij wi uꞌanom, we cꞌo umac o na jintaj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","E cꞌo jujun chique ri e aj Jerusalem caquitzꞌonobej: «¿Na e ta achi waꞌ quetajin che utzucuxic re caquicamisaj? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Suꞌchac cꞌu riꞌ cayaꞌ luwar che cachꞌaꞌt chiwachil yey na jinta ne junok cakꞌaten re? ¿Quicojom chi nawi raj wach re ri tinamit rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma riꞌoj ketaꞌam chi utz pa cape wi waꞌchi; noꞌj we xcꞌun ri Cristo, riꞌ na jinta junok etaꞌmayom re pa cape wi» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ri Jesús cacꞌutun pa ri Rocho Dios echiriꞌ xuta waꞌ. Lic co cꞌu xsiqꞌuin che ubiꞌxiquil: —Cabiꞌij ralak lic etaꞌam alak nuwach y lic etaꞌam alak pa quimpe wi. Pero lic chetaꞌmaj cꞌu alak waꞌ: Riꞌin na in petinak ta xa pa we riꞌin, ma intakom lo ruma ri Jun lic ube ronoje tak ri cuꞌano. Yey ralak na etaꞌam ta alak uwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noꞌj riꞌin wetaꞌam uwach, ma rucꞌ Rire in petinak wi y e Rire takayom lo weꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ecꞌuchiriꞌ, raj wach xcaj e riꞌ caquichap bi ri Jesús; pero na jinta junok xꞌanaw re, ma cꞌamajaꞌ copon rukꞌijol. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na rucꞌ ta cꞌu riꞌ, chiquixoꞌl ruqꞌuiyal winak, lic e qꞌui xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús y caquibiꞌij: «Chiwach ralak, echiriꞌ cacꞌun Ruchaꞌoꞌn lo ri Dios, ¿cuꞌan cami más cꞌutubal riꞌ re ruchukꞌab ri Dios chwa wa cuꞌan waꞌchi?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri fariseos xquita ri caquibiꞌij ri winak puwi ri Jesús. E uwariꞌche, rique cucꞌ ri nimak e aj chacunel pa Rocho Dios xequitak bi ri e chajinel re ri Rocho Dios chaꞌ caquichap lo ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xubiꞌij cꞌu ri Jesús: —Riꞌin na naj ta chi quincꞌojiꞌ ucꞌ alak, ma quintzelej rucꞌ ri takayom lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Copon na cꞌu riꞌ ri kꞌij echiriꞌ quintzucuj alak; pero na quinrik ta alak, ma na copon ta alak pa quineꞌcꞌola wi riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ecꞌu ri e aj judiꞌab xquijek caquitzꞌonobej chiquiwach: «¿Pa nawi queꞌec wi waꞌchi yey na queꞌkarika ta riꞌoj? ¿Queꞌec nawi cucꞌ ri e aj judiꞌab ejekel chiquixoꞌl ri e aj griegos y queꞌcꞌutuna chiquiwach? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Saꞌ queꞌelawi wa xubiꞌij chike: “Quintzucuj alak; pero na quinrik ta alak, ma na copon ta alak pa quineꞌcꞌola wi riꞌin”?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Che ri qꞌuisbal re ri nimalaj nimakꞌij, ri Jesús xtaqꞌuiꞌ chiquiwach ri winak y co xsiqꞌuin che ubiꞌxiquil: «We cꞌo junok catzajin uchiꞌ, petok y chutija re ri yaꞌ cꞌo wucꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ma e pachaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios: Ri cacubiꞌ ucꞌuꞌx wucꞌ riꞌin, cuꞌana pachaꞌ cajuljut tak lo acꞌal re yaꞌ cꞌaslic pa ranimaꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rucꞌ waꞌ ri Jesús e cachꞌaꞌt puwi ri Ruxlabixel ri Dios ri caquicꞌul na janipa ri cacubiꞌ quicꞌuꞌx rucꞌ. Yey cꞌamajaꞌ cꞌu cacꞌun riꞌ ri Ruxlabixel ri Dios ma cꞌamajaꞌ ne queꞌec ri Jesús chilaꞌ chicaj pa cakꞌalajisax wi runimal uchomalil. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","E cꞌo cꞌu jujun chique ri winak, echiriꞌ xquita waꞌ, jewaꞌ caquibiꞌij: «Pakatzij wi waꞌchi e ri jun kꞌalajisanel re ri Dios koyeꞌem cacꞌunic» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jujun chic jewaꞌ caquibiꞌij: «Waꞌ waꞌchi e ri Cristo, Ruchaꞌoꞌn lo ri Dios» quechaꞌ. Yey jujun chic jewaꞌ caquibiꞌij: «¿Galilea neba cape wi lo ri Cristo? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na Galilea taj, ma tzꞌibital can chupa Ruchꞌaꞌtem ri Dios, ri Cristo calax lo chiquixoꞌl ri ratz-uchakꞌ can ri rey David pa ri tinamit Belén, rutinamit ri David» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jecꞌulaꞌ riꞌ ri winak jachatal quipa ruma junwi tak ri caquichꞌob rakan puwi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E cꞌo ne jujun chique ri winak xcaj caquichap bi ri Jesús, pero na jinta junok xꞌanaw re. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ri e chajinel re ri Rocho Dios xetzelej pa e cꞌo wi ri xetakaw lo que, waꞌ e ri fariseos y ri nimak e aj chacunel pa Rocho Dios, yey rique xquitzꞌonoj chique raj chajinel: —¿Suꞌchac na xicꞌam ta lo ri Jesús? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ri e chajinel jecꞌuwaꞌ xquicꞌul uwach: —¡Na jinta junok jelaꞌ chꞌaꞌtinak pachaꞌ cachꞌaꞌt waꞌ waꞌchi! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ecꞌu ri fariseos xquibiꞌij chique: —¿Xixsocotaj cami riꞌ riꞌix ruma rire? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Cꞌo neba junok chique raj wach re ri tinamit o chique ri fariseos xcubiꞌ ucꞌuꞌx rucꞌ waꞌ waꞌchi? ");
INSERT INTO acrTNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Noꞌj wa winak eteran chirij ri Jesús, lic itzel quiwachlibal ma na caquimaj ta cꞌana usucꞌ ri Tzij Pixab —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ecꞌu ri Nicodemo, ri jun fariseo xopon julaj chakꞌab rucꞌ ri Jesús, jewaꞌ xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Cubiꞌij ri Tzij keꞌoj, na utz taj cakꞌat tzij puwi junok, we na cataꞌ ta uchiꞌ nabe y we na quetaꞌmax ta nabe we cꞌo juna mac uꞌanom —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Xquicꞌul cꞌu uwach ri Nicodemo: —¿Lal cami aj Galilea rilal? Chajilaj la chi utz Ruchꞌaꞌtem ri Dios y jelaꞌ quetaꞌmaj la we cꞌo juna kꞌalajisanel elinak lo chiquixoꞌl raj Galilea —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ecꞌuchiriꞌ, chiquijujunal xebec chicocho. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ri Jesús xeꞌec chwa ri juyub Olivos. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Echiriꞌ xsakiric, xtzelej tanchi pa ri Rocho Dios. Conoje ri winak xekib rucꞌ y Rire xtzꞌuyiꞌ chiquiwach y xujeko cuꞌan cꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ecꞌuchiriꞌ, raj cꞌutunel re ri tzijpixab y ri fariseos xquicꞌam lo jun ixok chwach. Waꞌ wiꞌxok xquimajo e riꞌ camacun chirij ri cꞌulaniquil rucꞌ jun achi na rachijil taj. Xquiya cꞌu chiquinicꞌajal conoje ri e cꞌo chiriꞌ ");
INSERT INTO acrTNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y jewaꞌ xquibiꞌij che ri Jesús: —Lal tijonel, wa jun ixok xkamajo lic e riꞌ camacun chirij ri cꞌulaniquil rucꞌ jun achi na rachijil taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yey ri Moisés, chupa ri Tzij Pixab catakan che caꞌan paꞌbaj juna ixok we cuꞌan waꞌ. ¿Saꞌ cꞌu ri cabiꞌij rilal che? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xquibiꞌij waꞌ che ri Jesús xa re cꞌambal upa chaꞌ caquicoj umac. Ecꞌu ri Jesús xchꞌuquiꞌic y rucꞌ ruwi ukꞌab xujek catzꞌiban chwa rulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yey rique lic caquicꞌot upa chaꞌ cucꞌul uwach ri tzꞌonobal. Ecꞌu ri Jesús xtaqꞌuiꞌic y xubiꞌij chique: —We cꞌo junok che alak cunaꞌo na jinta cꞌana umac, e nabe riꞌ chucꞌaka rabaj che wiꞌxok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tecꞌuchiriꞌ, xchꞌuquiꞌ tanchic y rucꞌ ruwi ukꞌab xtzꞌiban tanchi chwa rulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Conoje rique echiriꞌ xquita waꞌ wa xubiꞌij, xquinaꞌ quib cꞌo quimac. E uwariꞌche, pa jujun xebel bi. Nabe xebel bi ri e nimak winak; tecꞌuchiriꞌ, ri e cꞌacꞌal. Echiriꞌ conoje ebelinak chubi, xew ri Jesús y rixok xecanaj can chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ecꞌuchiriꞌ xtaqꞌuiꞌ ri Jesús y xrilo na jinta chi junok chiriꞌ, xew chi rixok, xubiꞌij cꞌu che: —Ixok ¿pa e cꞌo wi ri caquicoj amac? ¿Na jinta junok xukꞌat tzij re camic pawiꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rixok xubiꞌij che: —Na jinta junok, Wajawal —xchaꞌ. Ecꞌuchiriꞌ, ri Jesús xubiꞌij che: —Jenelaꞌ riꞌin na cankꞌat ta tzij re camic pawiꞌ. Jat cꞌu riꞌ y matmacun chic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ri Jesús xchꞌaꞌt tanchi cucꞌ ri winak, jewaꞌ xubiꞌij chique: —In ri Kꞌijsak che ruwachulew. China cꞌu ri caterej lo chwij, na cabin ta chi qꞌuenok pa kꞌekuꞌm ma cꞌo ri Kꞌijsak rucꞌ yey waꞌ e ri cuya cꞌaslemal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ecꞌuchiriꞌ, ri fariseos xquibiꞌij che ri Jesús: —Na jinta uchac ri cabiꞌij la, ma xa chiꞌibil ib la cabiꞌij la saꞌ ri wach la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ri Jesús xucꞌul uwach: —Tob in ri quinkꞌalajisan re saꞌ ri nuwach, ri cambiꞌij lic katzij; ma wetaꞌam pa in petinak wi y wetaꞌam pa quinꞌec wi. Noꞌj ralak na etaꞌam ta alak pa in petinak wi y na etaꞌam tane alak pa quinꞌec wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","»Ralak, echiriꞌ cabiꞌij alak saꞌ ri cachꞌob alak puwi junok, caꞌan alak waꞌ xa rucꞌ ri naꞌoj re ruwachulew. Noꞌj riꞌin na je ta laꞌ canꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Echiriꞌ cꞌo cankꞌalajisaj chirij junok, katzij ri cambiꞌij. Ma na xa ta pa we riꞌin ri cambiꞌij; ma ri nunaꞌoj riꞌin lic junam rucꞌ runaꞌoj ri Nukaw, ri xtakaw lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","»Yey chupa ri Tzij Pixab e alak, tzꞌibital canok: “We e cꞌo caꞌib ticawex junam caquijiquibaꞌ uwach ri caquibiꞌij, e cacoj que riꞌ.” ");
INSERT INTO acrTNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri cankꞌalajisaj riꞌin chiwibil wib, cajiquibax uwach ruma ri Nukaw, ri takayom lo weꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xquitzꞌonoj cꞌu che: —¿Pa cꞌu cꞌo wi ri kaw la? —xechaꞌ. Ri Jesús xucꞌul uwach: —Ralak na etaꞌam ta alak nuwach riꞌin y na etaꞌam ta alak uwach ri Nukaw; ma we ta etaꞌam alak nuwach riꞌin, jecꞌulaꞌ riꞌ etaꞌam alak uwach ri Nukaw —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ri Jesús xubiꞌij waꞌ echiriꞌ cacꞌutun pa ri Rocho Dios, chiriꞌ pa cꞌo wi ri caxa re kasaꞌn. Noꞌj na jinta junok xchapaw bi re, ma cꞌamajaꞌ copon rukꞌijol. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xubiꞌij tanchi ri Jesús chique: —Riꞌin quinꞌec y ralak quintzucuj cꞌu alak, pero cacam na cꞌu alak riꞌ pa ri mac alak. Ma pa quinꞌec wi riꞌin, na copon ta ralak chilaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Xquibiꞌij cꞌu raj judiꞌab chiquiwach: «Laj cucamisaj rib; e uwariꞌche cubiꞌij na utz taj cojopon riꞌoj chilaꞌ pa queꞌec wi rire» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ecꞌu ri Jesús xubiꞌij chique: —Ralak na alak ta re chilaꞌ chicaj, noꞌj riꞌin in petinak chilaꞌ chicaj. Ralak alak re ruwachulew, noꞌj riꞌin na in ta re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","E uwariꞌche ximbiꞌij cacam na cꞌu alak riꞌ pa ri mac alak. Ma we na cacoj ta alak “In Riꞌin”, riꞌ cacam alak pa ri mac alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ecꞌuchiriꞌ xquitzꞌonoj che: —¿Lal china cꞌu riꞌ rilal? —xechaꞌ. Ri Jesús xucꞌul uwach: —E ri nubiꞌim chi lo che alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Riꞌin lic cꞌo wetaꞌam chiꞌij alak re cojobal mac alak y re kꞌatbal tzij pawiꞌ alak; pero xew cambiꞌij chiquiwach conoje ri ticawex saꞌ ri nutom che ri takayom lo weꞌin, yey Rire lic katzij janipa ri cubiꞌij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri Jesús e cachꞌaꞌt puwi Rukaw, pero rique na xquimaj ta usucꞌ waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","E uwariꞌche ri Jesús xubiꞌij chique: —Echiriꞌ cayac alak Ralaxel Chiquixoꞌl Ticawex y caya alak chwa ri cruz, cꞌa ecꞌuchiriꞌ quetaꞌmaj alak riꞌ: “In Riꞌin”. Yey na jinta cꞌo canꞌan xa pa we riꞌin, ma xew cambiꞌij janipa rucꞌutum ri Nukaw chwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma ri takayom lo weꞌin cꞌo wucꞌ; ri Nukaw na inuyaꞌom ta can nutuquel, ma riꞌin xew canꞌano janipa ri caraj Rire —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Echiriꞌ xubiꞌij tak waꞌ ri Jesús, lic e qꞌui ri xquicojo Rire e ri jun kꞌalajisanel coyeꞌem cacꞌunic. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique ri e aj judiꞌab xquicojo Rire e ri jun kꞌalajisanel coyeꞌem cacꞌunic. —We catakej cꞌu alak janipa wa cambiꞌij che alak, riꞌ pakatzij wi cuꞌan alak nutijoꞌn; ");
INSERT INTO acrTNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","y jecꞌulaꞌ quetaꞌmaj alak ri Kꞌijsak, y ri Kꞌijsak caresaj lo alak pukꞌab ri ajaw alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rique xquicꞌul uwach: —Riꞌoj oj ralcꞌoꞌal can ri Abraham y na oj cꞌojiꞌnak ta pukꞌab junok. ¿Suꞌbe cꞌu riꞌ cabiꞌij la chike cojesax lo pukꞌab ri kajaw? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ri Jesús xubiꞌij chique: —Pakatzij wi cambiꞌij che alak: Conoje ri quemacunic, pukꞌab ri mac e cꞌo wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juna aj chac pa ja na junam ta uwach rucꞌ rucꞌajol ri rajaw ja, ma ri aj chac xa ajilam kꞌij cꞌo pa ja; noꞌj rucꞌajol na jinta utakexic e ralcꞌoꞌal rukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","E uwariꞌche, we Rucꞌajol ri Dios caresaj lo alak che ri mac cꞌo wi alak, pakatzij wi cꞌu riꞌ caquiritaj lo alak che ri mac. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","»Riꞌin wetaꞌam alak ralcꞌoꞌal can ri Abraham; na rucꞌ ta cꞌu riꞌ, caꞌaj alak quincamisaj alak ma na cacꞌul ta alak ri cancꞌut che alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Riꞌin e cambiꞌij ri ucꞌutum ri Nukaw chwe, yey ralak e caꞌan alak janipa rubiꞌim ri kaw alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rique xquicꞌul uwach: —Ri kakaw riꞌoj e ri Abraham —xechaꞌ. Ecꞌu ri Jesús xubiꞌij chique: —We ta pakatzij wi alak ralcꞌoꞌal ri Abraham, e caꞌan alak riꞌ ri xuꞌan rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Noꞌj ralak na je ta laꞌ catajin alak che uꞌanic. Ma tob nubiꞌim che alak ri Kꞌijsak ucꞌutum ri Dios chwe, na rucꞌ ta cꞌu riꞌ, caꞌaj alak quincamisaj alak. ¡Ri Abraham na je ta laꞌ xuꞌano! ");
INSERT INTO acrTNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ralak e caꞌan alak pachaꞌ ri cuꞌan ri kaw alak —xchaꞌ. Ecꞌuchiriꞌ, xquibiꞌij rique che: —Riꞌoj na oj ta pachaꞌ ri winak na quetaꞌam taj china ri quikaw; ma xa jun ri Kakaw, e ri Dios —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Xubiꞌij cꞌu ri Jesús chique: —We ta pakatzij wi e kaw alak ri Dios, ralak lic cꞌax quinnaꞌ alak riꞌ, ma riꞌin rucꞌ ri Dios in petinak wi yey riꞌ in cꞌo chiwach alak. Na in petinak ta cꞌu xa pa we riꞌin, ma e ri Dios takayom lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","»¿Suꞌbe na camaj ta alak usucꞌ janipa ri cambiꞌij che alak? E ruma ri na caꞌaj ta alak cata alak ri cambiꞌij riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri kaw alak e ritzel winak, ma e caꞌan alak saꞌ ri caraj rire. Ritzel winak aj camisanel chwi lo ri jekebal ruwachulew. Yey rire na xtiquiꞌ ta can pa ri Kꞌijsak, y na jinta ne cꞌana Kꞌijsak rucꞌ. Echiriꞌ cuꞌan rakꞌubal, e cukꞌalajisaj saꞌ ri cꞌo pa ranimaꞌ; ma xex wi aj rakꞌul yey ronoje rakꞌubal rucꞌ rire cape wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noꞌj riꞌin e cankꞌalajisaj ri lic katzij, yey ralak na cacoj ta alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","»¿Cꞌo nawi junok che alak curik juna mac chwij? Yey we katzij ri cambiꞌij, ¿suꞌbe cꞌu riꞌ na cacoj ta alak? ");
INSERT INTO acrTNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","E junok ralcꞌoꞌal ri Dios, e cuta Ruchꞌaꞌtem ri Dios; noꞌj ralak na alak ta ralcꞌoꞌal ri Dios, ma na cata ta alak Ruchꞌaꞌtem —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ecꞌuchiriꞌ, raj judiꞌab xquibiꞌij che ri Jesús: —Lic katzij ri xkabiꞌij pawiꞌ la: Rilal lal cuqꞌuil ri aj Samaria y lal cꞌo pukꞌab jun itzel uxlabixel —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ecꞌu ri Jesús xucꞌul uwach chique: —Riꞌin na in jinta pukꞌab juna itzel uxlabixel; ri canꞌano e canyac ukꞌij ri Nukaw y ralak cacꞌak bi alak nukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Riꞌin na cantzucuj ta yacbal nukꞌij, tob cꞌo Jun caraj cayaquiꞌ nukꞌij yey pukꞌab Rire cꞌo wi cukꞌalajisaj china ri cꞌo Kꞌijsak rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Pakatzij wi cambiꞌij che alak: China ri cacojow re ri cankꞌalajisaj riꞌin, na cacam taj ma cꞌo ucꞌaslemal na jinta utakexic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ecꞌuchiriꞌ, raj judiꞌab xquicꞌul uwach: —Woꞌora cakajiquibaꞌ uwach, lal cꞌo pukꞌab jun itzel uxlabixel. Ma ri Abraham y ri kꞌalajisanelab xecamic, yey rilal cabiꞌij la: “China cacojow re ri cankꞌalajisaj, na cacam taj ma cꞌo ucꞌaslemal na jinta utakexic.” ");
INSERT INTO acrTNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Lic neba más cꞌo wach rilal chwa ri kakaw Abraham? Rire xcamic yey tak ri kꞌalajisanelab xecamic. Chiwach rilal, ¿saꞌ ri wach la? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xucꞌul uwach: —We canyac nukꞌij riꞌin chiwibil wib, riꞌ na jinta uchac ri yacbal nukꞌij canꞌano; noꞌj cꞌu ri cayacaw nukꞌij e ri Nukaw, ri cabiꞌij alak e Dios alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ecꞌu ralak na etaꞌam ta alak uwach Rire; noꞌj riꞌin lic wetaꞌam uwach. We ta e laꞌ cambiꞌij na wetaꞌam ta uwach, riꞌ quinelic in aj rakꞌul jelaꞌ pachaꞌ ralak. Noꞌj riꞌin pakatzij wi wetaꞌam uwach Rire yey lic canꞌan ronoje ri cubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham, ri mam alak ojertan, lic xquiꞌcotic echiriꞌ xretaꞌmaj quincꞌun che ruwachulew; xril pan ri nukꞌijol y lic xquiꞌcot che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ecꞌuchiriꞌ, raj judiꞌab xquibiꞌij che ri Jesús: —Cꞌamajaꞌ ne cincuenta ri junab la, ¿yey cabiꞌij la xil la uwach ri Abraham? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij che alak: Riꞌin xex chi in cꞌo lo wi echiriꞌ cꞌamajaꞌ ne calax ri Abraham —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ecꞌuchiriꞌ, ri winak xquijek caquisicꞌ abaj re caquiꞌan ri Jesús paꞌbaj; noꞌj Rire xewax chiquiwach, e laꞌ xicꞌow chiquixoꞌl y xel bi che ri Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús echiriꞌ catajin chi be, xril jun achi ralaxibem potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ecꞌu rutijoꞌn xquitzꞌonoj che: —Lal tijonel, ¿wa jun achi xalaxic potzꞌ ruma nawi quimac ruchu-ukaw o ruma umac rire? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xucꞌul uwach chique: —Na ruma ta umac rire y na ruma tane quimac ruchu-ukaw; waꞌ e uꞌanom chaꞌ ruchukꞌab ri Dios cakꞌalajin rucꞌ rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lic chirajawaxic chwe canꞌan ruchac ri takayom lo weꞌin xalokꞌ cꞌa pakꞌij, ma cacꞌun lo rakꞌab echiriꞌ na jinta chi junok utz cachacunic. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Xalokꞌ cꞌu in cꞌo riꞌin wara che wuꞌwachulew, in ri in Kꞌijsak che ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Echiriꞌ ubiꞌim chi waꞌ, ri Jesús xchuban chwa rulew, xuꞌan jubikꞌ xokꞌoꞌl rucꞌ rucꞌaxaj. Tecꞌuchiriꞌ, xusokꞌ che ruwach ri potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ecꞌuchiriꞌ, xubiꞌij che: —Jat, jaꞌchꞌaja rawach pa ri yaꞌ re Siloé —xchaꞌ. (Siloé queꞌelawi “ri Takom lok”.) Ri potzꞌ e xuꞌano; xeꞌec y xuꞌchꞌaja ruwach. Ecꞌuchiriꞌ xtzelej lok, catzuꞌn chic. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ecꞌu ri ejekel lo chunakaj ri potzꞌ y ri quilom xaki cuꞌan ulimoxna, jewaꞌ caquibiꞌij: «¿Na e ta neba achi waꞌ catzꞌuyiꞌ chiꞌ be y cuꞌan ulimoxna?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jujun chic caquibiꞌij: «Katzij, areꞌ» quechaꞌ. Jujun chic caquibiꞌij: «Na e ta rire, tob lic e catzuꞌnic» quechaꞌ. Noꞌj rachi cunutajinak chic, lic cujiquibaꞌ uwach, jewaꞌ cubiꞌij: «Katzij, in waꞌ cꞌut» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Xquitzꞌonoj cꞌu che: —¿Chaꞌta laꞌ xat-tzuꞌnic? —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rire xucꞌul uwach: —E ri jun achi Jesús ubiꞌ, xuꞌan jubikꞌ xokꞌoꞌl, xusokꞌ che ri nuwach y xubiꞌij chwe: “Jat pa cꞌo wi ri yaꞌ re Siloé y jaꞌchꞌaja rawach chupa.” Xinꞌec cꞌu riꞌ, y echiriꞌ xinchꞌaj ri nuwach, xinjek quintzuꞌnic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Xquitzꞌonoj cꞌu che: —¿Pa cꞌo wi riꞌ laꞌ laꞌchi? —xecha che. Rire xucꞌul uwach: —Na wetaꞌam taj pa cꞌo wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ecꞌuchiriꞌ xquicꞌam bi ri potzꞌ cunutajinak chic chiquiwach ri fariseos; ");
INSERT INTO acrTNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ma e pa jun kꞌij re uxlanibal echiriꞌ ri Jesús xuꞌan xokꞌoꞌl y xucunaj ri potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jenelaꞌ ri fariseos xquitzꞌonoj che chaꞌtaj xtzuꞌnic. Rire xucꞌul uwach chique: —Rachi xusokꞌ xokꞌoꞌl che ri nuwach, xinchꞌaj cꞌu ri nuwach y woꞌora quintzuꞌnic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ecꞌuchiriꞌ, jujun chique ri fariseos caquibiꞌij chiquiwach: «Laꞌ laꞌchi xꞌanaw re waꞌ, na rucꞌ ta ri Dios petinak wi; ma e cuꞌan ri na ube taj caꞌaniꞌ chupa ri kꞌij re uxlanibal» quechaꞌ. Jujun chic caquibiꞌij: «We rire aj mac, ¿suꞌanic cꞌu riꞌ cuꞌan wa cꞌutubal re ruchukꞌab ri Dios?» quechaꞌ. Ruma cꞌu laꞌ, xquijach quipa ri fariseos chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ecꞌuchiriꞌ, xquitzꞌonoj che rachi cunutajinak chic: —¿Saꞌ ri cabiꞌij riꞌat chwi rachi xutzuꞌnisaj rawach? —xechaꞌ. Rire xucꞌul uwach: —Riꞌin cambiꞌij e jun kꞌalajisanel —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero raj judiꞌab na xcaj taj caquicojo we rachi xex potzꞌ wi y woꞌora catzuꞌnic. Ruma waꞌ xequisiqꞌuij ruchu-ukaw, ");
INSERT INTO acrTNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","y xquitzꞌonoj cꞌu chique: —¿E alcꞌoꞌal alak waꞌ, ri cabiꞌij alak ralaxibem potzꞌ? ¿Chaꞌtaj catzuꞌn woꞌora? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ruchu-ukaw rachi xquicꞌul uwach: —Riꞌoj lic ketaꞌam e kalcꞌoꞌal waꞌ y xalaxic potzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Noꞌj na ketaꞌam taj chaꞌtaj catzuꞌn woꞌora, y na ketaꞌam ta nenareꞌ china xcunan re. Tzꞌonoj alak che, ma rire nim chic —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ruchu-ukaw rachi xquibiꞌij waꞌ ruma caquixiꞌij quib, ma wa aj wach que raj judiꞌab quiꞌanom chi tzij chiquiwach chaꞌ na quecꞌul ta chi pa ri sinagoga janipa ri caquijiquibaꞌ uwach ri Jesús e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","E uwariꞌche ruchu-ukaw rachi xquibiꞌij: «Tzꞌonoj alak che, ma rire nim chic.» ");
INSERT INTO acrTNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ecꞌuchiriꞌ, raj judiꞌab xquitak tanchi usiqꞌuixic rachi cunutajinak chic y xquibiꞌij che: —Woꞌora chajiquibaꞌ uwach chwach ri Dios ri cabiꞌij. Ma riꞌoj ketaꞌam waꞌ waꞌchi lic aj mac —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ecꞌu rire xubiꞌij: —We rire aj mac na wetaꞌam ta cꞌu riꞌ riꞌin, xew wetaꞌam e ri petinak lok in potzꞌ yey woꞌora quintzuꞌnic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xquitzꞌonoj tanchi che: —¿Saꞌ ri xuꞌan chawe? ¿Suꞌanic xutzuꞌnisaj rawach? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rachi xucꞌul uwach: —Riꞌin ya ximbiꞌij che alak y na xꞌaj ta cata alak. ¿Suꞌchac cꞌu riꞌ caꞌaj alak cambiꞌij tanchic? ¿Caꞌaj cami ralak cuꞌan alak utijoꞌn? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ecꞌu rique xquiyajo, jewaꞌ xquibiꞌij che: —Riꞌat e catakej laꞌ la jun achi, noꞌj riꞌoj e cakatakej rutzꞌibam can ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma riꞌoj ketaꞌam ri Dios xchꞌaꞌt rucꞌ ri Moisés; noꞌj laꞌ la jun achi, na ketaꞌam taj pa petinak wi —xecha che. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ecꞌu rire xubiꞌij chique: —¡E laꞌ la lic cacam wanimaꞌ riꞌin che! Ma ralak na etaꞌam ta alak pa petinak wi waꞌchi, yey rire xutzuꞌnisaj ri nuwach riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ketaꞌam cꞌu chi utz, ri Dios na quebuta ta raj maquib, xew quebuta ri caquilokꞌoj ukꞌij y caquiꞌan ri rajawal ucꞌuꞌx Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Chwi lo ri jekebal ruwachulew, na jinta tatajinak wi we cꞌo junok utzuꞌnisam juna ticawex potzꞌ chwi ralaxic. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We tamaji wa jun achi petinak rucꞌ ri Dios, riꞌ na jinta pukꞌab cuꞌan waꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Xquibiꞌij cꞌu che: —Riꞌat lic pa mac xatalax wi. ¿Cawaj cami riꞌ catcꞌutun chikawach? —xecha che. Chwi cꞌu riꞌ laꞌ, na xquicꞌul ta chi pa ri sinagoga. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ecꞌu ri Jesús xretaꞌmaj na caquicꞌul ta chi pa ri sinagoga rachi cunutajinak. Uwariꞌche echiriꞌ xucꞌulu, jewaꞌ xubiꞌij che: —¿Cubul acꞌuꞌx riꞌat rucꞌ Ralaxel Chiquixoꞌl Ticawex? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rachi xucꞌul uwach: —Wajawal, biꞌij la chwe china rire chaꞌ cacubiꞌ nucꞌuꞌx rucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xubiꞌij che: —Awilom chi uwach; ma in riꞌ ri quinchꞌaꞌt awucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ecꞌuchiriꞌ, rachi xuxucubaꞌ rib chwach y xulokꞌnimaj ukꞌij, jewaꞌ xubiꞌij che: —Wajawal, riꞌin cacubiꞌ nucꞌuꞌx ucꞌ la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ecꞌu ri Jesús xubiꞌij: —Riꞌin in cꞌuninak che ruwachulew chaꞌ wuma riꞌin cakꞌalajinic china ri caquicꞌul ri Kꞌijsak y china ri na caquicꞌul taj. In cꞌuninak cꞌu riꞌ chaꞌ e ri na quetzuꞌn taj, cajakataj ri quiwach y jelaꞌ caquil ri Kꞌijsak; yey ecꞌu ri “quetzuꞌnic”, cachꞌukutaj ri quiwach y na caquil ta ri Kꞌijsak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jujun cꞌu chique ri fariseos, ri e cꞌo pan chunakaj ri Jesús, echiriꞌ xquita waꞌ, xquitzꞌonoj che: —¿E cami queꞌelawi riꞌ oj potzꞌ riꞌoj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri Jesús xucꞌul uwach: —We ta caya ib alak chupa na quil ta alak ri Kꞌijsak, na jinta mac alak riꞌ. Noꞌj ruma ri cabiꞌij alak quil alak chi utz ri Kꞌijsak, e cacanaj cꞌu alak riꞌ chupa ri mac alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ri Jesús xubiꞌij: «Pakatzij wi cambiꞌij che alak: China ri na coc tubi che ruchiꞌ ri coral que ri bexex yey xa tob cꞌu pa coc wubi, riꞌ elekꞌom y e querelekꞌaj bi ri bexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Noꞌj cꞌu ri coc bi che ruchiꞌ ri coral, riꞌ e chajinel que ri bexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ecꞌu rire echiriꞌ copon chwach ruchiꞌ ri coral, ri chajinel cꞌo che ruchiꞌ coral, cujakalaꞌ lo che. Yey tak ri bexex quetaꞌam ruchꞌawibal ri chajinel que, ma rire quebusiqꞌuij rucꞌ ri quibiꞌ chiquijujunal y queberesaj bi pa ri coral. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Echiriꞌ eresam chubi conoje rubexex pa ri coral, canabej bi chiquiwach y conoje rubexex queterej bi chirij ma quetaꞌam ruchꞌawibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Noꞌj tak ri bexex na queterej tubi chirij junok we na quetaꞌam ta uwach; ri caquiꞌano e quebanimaj chwach ma na quetaꞌam ta ruchꞌawibal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xubiꞌij wa jun cꞌambal naꞌoj chique, pero rique na xquimaj ta usucꞌ saꞌ ri caraj cubiꞌij chique. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ecꞌuchiriꞌ, xubiꞌij ri Jesús: «Pakatzij wi cambiꞌij che alak: In ri in uchiꞌ ri coral pa queboc wi ri bexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Conoje ri xecꞌun nabe chinuwach riꞌin e elekꞌomab y xa e quequelekꞌaj bi ri bexex; pero ri bexex na xequicajmaj ta rique. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","»In ri in uchiꞌ ri coral que ri bexex. China ri coc bi wuma riꞌin, riꞌ cacolobetajic y cachajix chi utz pachaꞌ ri bexex queboquisax chakꞌab pa ri coral y quebesax bi pakꞌij re quebeꞌwoꞌk pa chomilaj qꞌuim. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Juna elekꞌom xew cacꞌunic re cuꞌan elekꞌ, cuꞌan camic y cusach uwach ronoje. Noꞌj riꞌin in cꞌuninak re canya cꞌaslemal che alak yey waꞌ e jun chomilaj cꞌaslemal na jinta chi uqꞌuisic. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","»In ri in utzilaj chajinel que bexex. Juna utzilaj chajinel que bexex cuya ranimaꞌ cacam cuma rubexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Noꞌj juna mocom cachacun xa ruma catojic. Echiriꞌ carilo cacꞌun lo rutiw, canimajic y quebuya can ri bexex; ma na e ta chajinel que y na e tane cajaw. E uwariꞌche cuya luwar che rutiw quebuchap ri bexex y quebuquicherisaj bi. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wa mocom canimajic ma na coc ta il chique ri bexex, xew e coc il che ri cuchꞌaco. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","»In ri in utzilaj chajinel que bexex, ma riꞌin wetaꞌam quiwach ri nubexex y rique quetaꞌam nuwach riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jelaꞌ pachaꞌ ri Nukaw retaꞌam nuwach riꞌin, jecꞌulaꞌ riꞌin wetaꞌam uwach Rire; yey canya wanimaꞌ quincam cuma ri nubexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","»E cꞌo jujun chic nubexex na e ta cuqꞌuil wa e cꞌo pa wa coral. Lic chirajawaxic wi quebeꞌnucꞌamaꞌ lok. We xebenusiqꞌuij, caquicoj nutzij y jelaꞌ quebuꞌana xa jun pa ri coral y xa jun ri chajinel que. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","»Ruma cꞌu laꞌ, ri Nukaw cꞌax quinunaꞌo, ma riꞌin canya ri nucꞌaslem pa camic yey cancꞌam tanchi waꞌ echiriꞌ quincꞌastaj lo chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Na yaꞌtal ta pukꞌab junok caresaj ri nucꞌaslem we na in ta quinyaꞌw re che. Panukꞌab riꞌin cꞌo wi canya wib pa camic y panukꞌab cꞌo wi quincꞌastaj lo chiquixoꞌl ri ecaminak. Yey waꞌ e ri Nukaw yaꞌyom panukꞌab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Echiriꞌ raj judiꞌab xquita wa chꞌaꞌtem, xquijach tanchi quipa chiquiwach, ma e cꞌo ri xecojow re y e cꞌo ri na xecojow taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E qꞌui chique jewaꞌ caquibiꞌij: «Laꞌ cꞌo pukꞌab juna itzel uxlabixel y chꞌuꞌjerinak. ¿Suꞌchac cata alak re?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Noꞌj cꞌo jujun chic jewaꞌ caquibiꞌij: «Na jinta junok jelaꞌ cachꞌaꞌtic we cꞌo pukꞌab juna itzel uxlabixel. ¿Cꞌo neba juna itzel uxlabixel quebutzuꞌnisaj ri e potzꞌ?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chupa cꞌu rukꞌijol echiriꞌ cꞌax tew y cꞌo jab, e riꞌ catajin ri nimakꞌij re ri Rocho Dios chilaꞌ Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y ri Jesús cabin che ri Rocho Dios pa ri luwar cabiꞌx che “Ruchiꞌ Ja re Salomón” ");
INSERT INTO acrTNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ecꞌu raj judiꞌab xquisut rij ri Jesús y jewaꞌ xquibiꞌij che: —¿Jampa xaki e waꞌ na cakꞌalajisaj ta la chikawach saꞌ ri wach la? We lal cꞌu Ruchaꞌoꞌn lo ri Dios, asu biꞌij la chike —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ri Jesús xucꞌul uwach: —Nubiꞌim chi che alak, yey na cacoj ta alak. Ronoje tak ri chac canꞌano, e ri Nukaw intakayom che canꞌano. Rucꞌ tak cꞌu wa canꞌano, cakꞌalajinic in china riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Noꞌj ralak na cacoj ta alak, ma na alak ta cuqꞌuil ri nubexex, jelaꞌ pachaꞌ ri nubiꞌim chi lo che alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Tak ri nubexex quetaꞌam chi ri nuchꞌawibal; yey riꞌin wetaꞌam quiwach y rique eteran chwij. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Riꞌin canya quicꞌaslemal na jinta utakexic chaꞌ jelaꞌ na casach ta cꞌana quiwach y na jinta ne junok queberesaj panukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yey e ri Nukaw ri xeyaꞌw que panukꞌab, y Rire más cꞌo uwach chiquiwa conoje. Ruma cꞌu riꞌ, na jinta junok queberesaj pukꞌab Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma ri Nukaw y riꞌin xa oj jun —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Julaj chic raj judiꞌab xquicꞌam abaj paquikꞌab re caquiꞌan ri Jesús paꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero Rire xubiꞌij chique: —Lic qꞌui ri utzilaj chac nuꞌanom chiwach alak rucꞌ ruchukꞌab ri Nukaw. ¿Ruma pachique che tak wa nuꞌanom quinꞌan alak paꞌbaj? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Raj judiꞌab xquicꞌul uwach: —Na cakaꞌan ta la paꞌbaj ruma ri utz ꞌanom la; e ruma macuninak la chirij ri Dios rucꞌ ri chꞌaꞌtem la. Ma rilal xa lal jun achi y caꞌan Dios che ib la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ecꞌuchiriꞌ, ri Jesús xubiꞌij chique: —Jewaꞌ tzꞌibital can chupa ri Tzij Pixab cꞌo ucꞌ alak: “Ximbiꞌij: Riꞌix ix dios.” ");
INSERT INTO acrTNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ri Dios xubiꞌij cꞌu “dios” chique ri xquicꞌul Ruchꞌaꞌtem, yey Ruchꞌaꞌtem na cajalcꞌatitaj taj. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Suꞌanic cꞌu riꞌ cabiꞌij alak chwe in macuninak xa ruma ri ximbiꞌij in Ucꞌajol ri Dios? ma ri Dios xinuchaꞌ lo riꞌin yey xinutak lo che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","»We na e ta canꞌan ruchac ri Nukaw, utz cꞌu riꞌ we na cacoj ta alak ri cambiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Noꞌj we e canꞌan ruchac ri Nukaw, cojo cꞌu alak riꞌ in china riꞌin ruma tak ri canꞌano, na xa ta ruma ri cambiꞌij. Y jelaꞌ quetaꞌmaj alak y cacoj alak riꞌ: Ri Nukaw wucꞌ riꞌin y riꞌin rucꞌ Rire, xa oj jun —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ecꞌu raj judiꞌab xcaj tanchic caquichapo, pero na xquichap taj ma ri Jesús xel bi chiquixoꞌl. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y xukꞌaxuj cꞌu ri nimayaꞌ Jordán pa xuya wi bautismo ri Juan y xcanaj can chilaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Uqꞌuiyal winak xebopon rucꞌ; xeꞌquilaꞌ y jewaꞌ caquibiꞌij: «Ri Juan na xuꞌan ta juna cꞌutubal re ruchukꞌab ri Dios chikawach; na rucꞌ ta cꞌu riꞌ, ronoje ri xubiꞌij can chwi waꞌ waꞌchi, lic katzij» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y lic e qꞌui ri xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús chilaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Cꞌo cꞌu jun achi yewaꞌ, Lázaro rubiꞌ. Rire aj Betania, y chilaꞌ ejekel wi ri ranab María y Marta. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Waꞌ wa María e ri xukꞌej cunabal lic quiꞌ ruxlab che ri rakan ri Jesús y xuchakisaj rucꞌ ruwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ecꞌu ri queb ixokib quichakꞌ quib jewaꞌ xquitak ubiꞌxiquil che ri Jesús: «Kajawal, ri jun lic cꞌax canaꞌ la, lic yewaꞌ.» ");
INSERT INTO acrTNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Echiriꞌ ri Jesús xuta waꞌ, jewaꞌ xubiꞌij: «Waꞌ wa yabil na re ta camic, ma re yacbal ukꞌij ri Dios y re yacbal ukꞌij Rucꞌajol ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ecꞌu ri Jesús lic cꞌax quebunaꞌ ri oxib quichakꞌ quib: Ri Marta, ri María y ri Lázaro. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na rucꞌ ta cꞌu riꞌ, echiriꞌ xuto yewaꞌ ri Lázaro, cꞌa xcanaj chi can queb kꞌij pa ri luwar pa cꞌo wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tecꞌuchiriꞌ, xubiꞌij chique rutijoꞌn: —Joꞌ tanchi Judea —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ecꞌu rutijoꞌn xquibiꞌij che: —Lal tijonel, ¿na cꞌacꞌ ta neba laꞌ raj judiꞌab ya laj xquicamisaj la paꞌbaj? Na rucꞌ ta cꞌu riꞌ, ¿woꞌora queꞌec tanchi la chilaꞌ? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ri Jesús xubiꞌij chique: —¿Na katzij ta neba laꞌ cablajuj ora cꞌo che ri jun kꞌij? Yey e junok cabin pakꞌij na cuchik ta ri rakan, ma caril rube ruma ri kꞌijsak re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Noꞌj we junok cabin chakꞌab, riꞌ cuchik ri rakan ma pa kꞌekuꞌm cꞌo wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tecꞌuchiriꞌ, xubiꞌij chique: —E ri kamigo Lázaro, cawaric. Quinꞌec cꞌu che ucꞌosoxic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xquibiꞌij cꞌu rutijoꞌn che: —Kajawal, utz we cawaric, ma riꞌ e cꞌutubal re cutzir uwach —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ri xquichꞌob rique e xa cuxlan ri Lázaro; noꞌj ri Jesús e cachꞌaꞌt puwi rucamic ri Lázaro. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","E uwariꞌche ri Jesús xukꞌalajisaj chique: —Ri Lázaro caminak chic. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yey iwuma cꞌu riꞌix, lic quinquiꞌcotic ri na in jinta chilaꞌ rucꞌ echiriꞌ xcamic, ma jelaꞌ canimar ri cubulibal icꞌuꞌx wucꞌ. Woꞌora joꞌ, jeꞌkilaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ecꞌuchiriꞌ, ri Tomás ri cabiꞌx “Yoꞌx” che, xubiꞌij chique ri jujun chic rachbiꞌil: —Cojꞌec riꞌ chaꞌ jelaꞌ cojcam junam rucꞌ ri Jesús —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Cajib kꞌij chi lo riꞌ mukutal ri Lázaro echiriꞌ ri Jesús xopon Betania. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Waꞌ xa chunakaj Jerusalem cꞌo wi, laj oxib kilómetro cꞌo wi lo che. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E qꞌui chique raj judiꞌab e petinak cucꞌ ri María y ri Marta re coꞌlquibochiꞌij quicꞌuꞌx ruma rucamic ri quixibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ecꞌuchiriꞌ ri Marta xuto catajin roponic ri Jesús, xel bi che ucꞌulic; noꞌj ri María xcanaj can chwa ja. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ecꞌu ri Marta xubiꞌij che ri Jesús: —Wajawal, we ta e laꞌ cꞌo la wara, na cacam ta riꞌ ri nuxibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na rucꞌ ta cꞌu riꞌ, lic wetaꞌam, tob ne cꞌa e waꞌ, ri Dios cuya cheꞌla ronoje ri catzꞌonoj la che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xubiꞌij che: —Raxibal cacꞌastaj lo chiquixoꞌl ri ecaminak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ri Marta xubiꞌij che: —Katzij, riꞌin wetaꞌam cacꞌastaj lo che ri qꞌuisbal kꞌij re ruwachulew echiriꞌ quecꞌastaj lo conoje ri ecaminak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xubiꞌij che: —E riꞌin ri quincꞌastajisan lo que ri ecaminak yey e riꞌin ri quinyaꞌw cꞌaslemal. China cꞌu ri cacubiꞌ ucꞌuꞌx wucꞌ, tob cacamic, cacꞌastajic. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yey conoje ri e cꞌaslic y cacubiꞌ quicꞌuꞌx wucꞌ, na quecam taj ma cꞌo quicꞌaslemal na jinta utakexic rucꞌ ri Dios. ¿Cacoj riꞌat waꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri Marta xucꞌul uwach: —Cancojo, Wajawal, ma riꞌin nucojom rilal lal ri Cristo, Rucꞌajol ri Dios, ri biꞌtisim lok cacꞌun che ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Echiriꞌ ri Marta xuqꞌuis ubiꞌxic waꞌ, xeꞌec che usiqꞌuixic ruchakꞌ María y xew che rire xubiꞌij: —Ri Kajawal cꞌo wara y catusiqꞌuij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xew xuta waꞌ ri María, na jampatana xyactaj bi y xeꞌrila ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús cꞌamajaꞌ ne coc pa ri tinamit, ma cꞌa cꞌo pa ri luwar pa xcꞌul wi ruma ri Marta. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ecꞌu raj judiꞌab e cꞌo rucꞌ ri María re caquibochiꞌij ucꞌuꞌx, xquilo echiriꞌ na jampatana xyactajic y canic xel bi. Rique xeterej cꞌu bi chirij, ma e chiquiwach rique e riꞌ queꞌec chwa ri mukubal chaꞌ queꞌrokꞌej ruxibal. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Echiriꞌ ri María xopon pa cꞌo wi ri Jesús, xew xril uwach, xuxuc rib chwach, y jewaꞌ xubiꞌij che: —Wajawal, we ta e laꞌ lal cꞌo la wara, na cacam ta riꞌ ri nuxibal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri Jesús echiriꞌ xrilo lic quebokꞌ ri María y raj judiꞌab eteran lo chirij, lic xoc chucꞌuꞌx y xuchap bis. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xubiꞌij cꞌu chique: —¿Pa ximuk wi? —xchaꞌ. Rique xquibiꞌij: —Kajawal, peta la y chilape la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ecꞌu ri Jesús xokꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Xquibiꞌij cꞌu raj judiꞌab: —¡Chilape alak, lic cꞌax cunaꞌo! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","E cꞌo jujun chique raj judiꞌab xquibiꞌij: —Wa waꞌchi e xtzuꞌnisan re ri jun potzꞌ. ¿Suꞌbe cꞌu riꞌ na jinta xuꞌano chaꞌ na cacam ta ri Lázaro? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ri Jesús lic xoc tanchi bis chucꞌuꞌx, xkib chwa ri mukubal. Waꞌ jun jul worotal paꞌbaj y tzꞌapal uchiꞌ rucꞌ jun abaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ecꞌu ri Jesús xubiꞌij: —Chiwesaj laꞌbaj —xchaꞌ. Yey ri Marta, ri ranab can ri caminak, xubiꞌij che: —Wajawal, laꞌ lic chu chic, ma e ucaj kꞌij waꞌ mukutalic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ri Jesús xubiꞌij che: —¿Na nubiꞌim ta neba chawe, we cacubiꞌ acꞌuꞌx wucꞌ, cawil runimal uwach ukꞌij ri Dios? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ewi xquesaj rabaj cꞌo chuchiꞌ ri mukubal. Ecꞌuchiriꞌ, ri Jesús xtzuꞌn chicaj y xubiꞌij: —Lal Nukaw, maltiox co cheꞌla ma intom chi la. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Riꞌin wetaꞌam lic xaki quinta la, pero cambiꞌij cꞌu waꞌ cuma wuꞌqꞌuiyal ticawex e cꞌo wara, chaꞌ rique caquicojo lal takayom lo we —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Echiriꞌ xuqꞌuis ubiꞌxiquil waꞌ, lic co xsiqꞌuin che ubiꞌxiquil: —¡Lázaro, chatelulok! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ewi ri Lázaro xel lok, bolkꞌotim ri rakan y rukꞌab pa cꞌul yey rupalaj chꞌukutal rucꞌ jun cꞌul. Ruma cꞌu laꞌ, ri Jesús xubiꞌij chique: —Chiquira ri cꞌul cꞌo che chaꞌ utz queꞌec —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","E qꞌui cꞌu chique raj judiꞌab, ri e petinak che ubochiꞌixic ucꞌuꞌx ri María, echiriꞌ xquil ri xuꞌan ri Jesús, xquicubaꞌ quicꞌuꞌx rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Noꞌj e cꞌo jujun chique xebec cucꞌ ri fariseos, y xeꞌquitzijoj chique ri xuꞌan ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ecꞌu ri nimak e aj chacunel pa Rocho Dios y ri fariseos xquimol quib cucꞌ jujun chic chique ri e aj kꞌatal tzij y jewaꞌ xquibiꞌij: —¿Saꞌ ri cakaꞌano? Ma waꞌchi lic uqꞌuiyal cꞌutubal re ruchukꞌab cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We na cakakꞌatej taj, conoje cacubiꞌ quicꞌuꞌx rucꞌ y quecꞌun cꞌu lo riꞌ raj wach re Roma chaꞌ coꞌlquiwulij wa Luwar pa cakalokꞌnimaj wi ri Dios y wa katinamit —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ecꞌuchiriꞌ ri Caifás, ri cajawal raj chacunel pa Rocho Dios che laꞌ la junab, jewaꞌ xubiꞌij chique: —Ralak na jinta etaꞌam alak. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na cachꞌob ta alak rakan chi utz, ma e más utz we xa jun chi achi cacam pucꞌaxel ri tinamit chwa ri casach quiwach conoje ri katinamit —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ri Caifás na xa ta pa re rire xubiꞌij waꞌ. Ma ruma e cajawal raj chacunel pa Rocho Dios che laꞌ la junab, ri Dios xuya che cukꞌalajisaj e cacam ri Jesús paquicꞌaxel conoje ri tinamit e aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y na xew ta cuma ri tinamit Israel xcam ri Jesús, ma xcamic chaꞌ cuꞌan xa jun chique conoje ri e ralcꞌoꞌal ri Dios equicherinak bi che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ecꞌu raj judiꞌab chwi laꞌ la kꞌij wi xquiꞌan tzij chiquiwach chaꞌ caquicamisaj ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ruma cꞌu waꞌ, ri Jesús na xbin ta chi chiquixoꞌl chiwachil. Ewi xel bi pa ri luwar re Judea y xeꞌec chunakaj ri luwar catzꞌintzꞌotic, pa jun tinamit Efraín rubiꞌ. Chiriꞌ xcanaj can wi junam cucꞌ rutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa nakaj chi cꞌo wi lo ri Pascua, waꞌ e quinimakꞌij raj judiꞌab. Uqꞌuiyal winak re tak ri tinamit xepakiꞌ Jerusalem re caquiꞌan ri quijoskꞌiquil chwach ri Dios, chaꞌ jelaꞌ takal chique caquiꞌan ri nimakꞌij Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","E tak cꞌu ri winak quetajin che utzucuxic ri Jesús, yey echiriꞌ e cꞌo pa ri Rocho Dios, caquitzꞌonobej chiquiwach: «¿Saꞌ nawi quichꞌob riꞌix? ¿Cacꞌun nawi pa wa nimakꞌij?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yey ri fariseos cucꞌ ri nimak e aj chacunel pa Rocho Dios etakaninak che we cꞌo junok caretaꞌmaj pa cꞌo wi ri Jesús, chubiꞌij chaꞌ queꞌquichapa ulok. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wakib kꞌij chi cꞌu riꞌ che ri nimakꞌij Pascua, ri Jesús xeꞌec Betania pa jekel wi ri Lázaro, ri jun xucꞌastajisaj lo che ri camic. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chiriꞌ xquiꞌan wi jun waꞌim re yacbal ukꞌij ri Jesús. Ecꞌu ri Marta e caniman ri waꞌim y ri Lázaro e jun chique ri etzꞌul chwa ri mexa rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ecꞌu ri María xucꞌam lo jun libra re sakil nardo, waꞌ e jun cunabal lic quiꞌ ruxlab y lic qꞌui rajil. Xukꞌej cꞌu riꞌ che ri rakan ri Jesús; tecꞌuchiriꞌ, xuchakisaj rucꞌ ruwiꞌ. Ronoje cꞌu rupa ja lic xmuyuy che ri ruxlab wa cunabal. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Cꞌo cꞌu chiriꞌ ri Judas aj Iscariot, jun chique rutijoꞌn ri Jesús. (E ri cacꞌayin re ri Jesús). Rire xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Suꞌbe na xcꞌayix ta waꞌ wa cunabal chi oxib ciento denarios chaꞌ rucꞌ ri rajil quetoꞌ ri nibaꞌib? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ri Judas xubiꞌij waꞌ na e ta ruma caraj quebutoꞌ ri nibaꞌib, ma e ruma rire elekꞌom. Yey pukꞌab cꞌo wi ri bolxa pa cꞌolotal wi ri puak que rutakoꞌn ri Jesús y cꞌo ne caresaj che. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ecꞌu ri Jesús xubiꞌij che ri Judas: —Matchꞌaꞌt chirij wiꞌxok, ma wa cunabal xex chi ucꞌolom re pan rukꞌijol ri mukubal we. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma tak ri nibaꞌib ronoje kꞌij e cꞌo iwucꞌ, noꞌj riꞌin na xaki ta in cꞌo iwucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","E qꞌui chique raj judiꞌab xquetaꞌmaj cꞌo ri Jesús chilaꞌ Betania. Xebec cꞌu che rilic, na xew ta ruma cacaj queꞌquila ri Jesús, ma cacaj queꞌquila ri Lázaro, ri jun xucꞌastajisaj lo chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ruma cꞌu riꞌ, ri nimak e aj chacunel pa Rocho Dios xquiꞌan tzij chiquiwach chaꞌ caquicamisaj ri Lázaro; ");
INSERT INTO acrTNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ma ruma rire, e qꞌui chique raj judiꞌab xquesaj bi quib cucꞌ y e xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","E qꞌui ri winak eboponinak Jerusalem ruma ri nimakꞌij Pascua. Chucaꞌm kꞌij cꞌu riꞌ xquetaꞌmaj copon ri Jesús pa ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Xquikꞌat cꞌu uxak palma y xebel bi che ucꞌulic. Ecꞌuchiriꞌ, xquijeko lic quesiqꞌuinic, jewaꞌ caquibiꞌij: «¡Kayaca ukꞌij! ¡Nim ukꞌij ri jun petinak chupa rubiꞌ ri Dios Kajawxel! ¡Rire e ri Rey re Israel!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri Jesús urikom lo jun kꞌapoj buru y ucojom lok, pachaꞌ tzꞌibital can chupa Ruchꞌaꞌtem ri Dios: ");
INSERT INTO acrTNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mixiꞌij iwib ri ix aj Sion. Chiwilapeꞌ, ri Rey iweꞌix cacꞌunic, ucojom lo jun kꞌapoj buru cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Echiriꞌ xuꞌan tak waꞌ, rutijoꞌn na xquimaj ta usucꞌ; cꞌa e xquimaj usucꞌ echiriꞌ lic xyac ukꞌij ri Jesús chiquiwach ruma rucꞌastajibal. Cꞌa ecꞌuchiriꞌ xcꞌun chiquicꞌuꞌx, e janipa ri xꞌaniꞌ che, ronoje waꞌ tzꞌibital can pa Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E tak ri e cꞌo rucꞌ ri Jesús echiriꞌ Rire xusiqꞌuij pan ri Lázaro chupa ri mukubal y xucꞌastajisaj lo chiquixoꞌl ri ecaminak, quetajin che utzijoxic ri xquilo. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ruma waꞌ, uqꞌuiyal winak xebel lo che ucꞌulic ri Jesús, ma xquita ri catzijox puwi wa cꞌutubal re ruchukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ecꞌuchiriꞌ, ri fariseos xquibiꞌij chiquiwach: «Quiwil cꞌu laꞌ, lic na jinta cutikoj saꞌ ri kaꞌanom chirij ri Jesús, ma ¡chiwilapeꞌ! conoje ri winak eteran chirij» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","E cꞌo jujun na e ta aj Israel chiquixoꞌl ri winak eboponinak Jerusalem re queꞌquilokꞌnimaj ukꞌij ri Dios pa ri nimakꞌij Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Waꞌ xekib rucꞌ ri Felipe, ri aj Betsaida, jun luwar re Galilea. Lic cꞌut xebelaj che, jewaꞌ xquibiꞌij: —Maꞌan co la riꞌ, chojtoꞌo la, ma riꞌoj cakaj cakil uwach ri Jesús —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xeꞌec y xutzijoj waꞌ che ri Andrés. Tecꞌuchiriꞌ xebec junam, xeꞌquitzijoj che ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ecꞌu ri Jesús xubiꞌij chique: —Xopon cꞌu rukꞌijol ri yacbal ukꞌij Ralaxel Chiquixoꞌl Ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Pakatzij wi cambiꞌij chiwe: E juna ijaꞌ re trigo echiriꞌ catzak pulew, camukic y cacamic. Yey we na jelaꞌ ta cuꞌano, cacanaj can utuquel xew ijaꞌ. Noꞌj we rijaꞌ catzak pulew, riꞌ lic cawachinic y jecꞌuriꞌlaꞌ caqꞌuiyar uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jecꞌuriꞌlaꞌ, china ri lic coc il che rucꞌaslem che ruwachulew, riꞌ e cujam ri cꞌaslemal chilaꞌ chicaj; noꞌj china ri na coc ta il che rucꞌaslem wara che ruwachulew, riꞌ na cujam ta cꞌu ri chomilaj ucꞌaslemal na jinta utakexic chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","»China ri caraj cachacun pa ri nuchac, chirajawaxic riꞌ caterej lo chwij. Jecꞌulaꞌ tob pa quincꞌojiꞌ wi riꞌin, chiriꞌ cacꞌojiꞌ wi ri waj chac. China cꞌu ri caꞌanaw ri nuchac, riꞌ cayac ukꞌij ruma ri Nukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","»Woꞌora lic paxinak nucꞌuꞌx. ¿Saꞌ nawi ri cambiꞌij? ¿Utz nawi jewaꞌ cambiꞌij: “Nukaw, chincolobej la che wa cancꞌulumaj woꞌora”? ¡Na utz taj! Ma ruma ne waꞌ in petinak. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xew cambiꞌij: “Nukaw, nimarisaj ukꞌij ri biꞌ la” —xchaꞌ. Ecꞌuchiriꞌ, xchꞌaw lo Jun chilaꞌ chicaj, jewaꞌ xubiꞌij: —Nunimarisam chic, y e waꞌ cannimarisaj tanchic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ri winak e cꞌo chiriꞌ xquita waꞌ y xquibiꞌij: «Laꞌ uchꞌawibal jab.» Yey jujun chic xquibiꞌij: «Jun ángel xchꞌaw lo che» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ecꞌu ri Jesús xubiꞌij chique: —Na wuma ta riꞌin xtataj wa jun kulaj, ma e uma ralak. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yey woꞌora cakꞌat tzij paquiwi ri winak re ruwachulew y quesax na cꞌu bi ritzel winak, ri jun catakan che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Echiriꞌ quinyaquiꞌ na lo chicaj, canꞌan chique ri ticawex che ronoje ruwachulew chaꞌ lic cacha quicꞌuꞌx che quepe wucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rucꞌ waꞌ e xukꞌalajisaj saꞌ rucamic. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ri winak xquicꞌul uwach: —Ruma Rutzij Upixab ri Dios riꞌoj ketaꞌam: Ruchaꞌoꞌn lo ri Dios na jinta utakexic rucꞌaslemal. ¿Chaꞌta cꞌu riꞌ cabiꞌij la Ralaxel Chiquixoꞌl Ticawex cayaquiꞌ che ruwachulew? ¿China cꞌu riꞌ “Ralaxel Chiquixoꞌl Ticawex” cabiꞌij la? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Xubiꞌij cꞌu ri Jesús chique: —Na naj ta chi cꞌo ri Kꞌijsak chixoꞌl alak. Bina cꞌu alak pa ri Kꞌijsak xalokꞌ cꞌa cꞌo ucꞌ alak, chaꞌ ri kꞌekuꞌm na cumaj ta alak xakicꞌateꞌt. Ma china ri cabin pa kꞌekuꞌm, na retaꞌam taj pa queꞌec wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Cojo alak ri Kꞌijsak xalokꞌ cꞌa cꞌo ucꞌ alak, chaꞌ jelaꞌ cuꞌan alak re ri Kꞌijsak —xchaꞌ. Echiriꞌ xuqꞌuis ubiꞌxic waꞌ ri Jesús, xel bi chiquixoꞌl y xeꞌec pa jun luwar pa na carikitaj ta wi cuma rique. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E cꞌo ri na xcubiꞌ ta quicꞌuꞌx rucꞌ ri Jesús, tob Rire xuꞌan uqꞌuiyal cꞌutubal re ruchukꞌab ri Dios chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jecꞌulaꞌ e xuꞌana pachaꞌ rutzꞌibam can ri kꞌalajisanel Isaías echiriꞌ xubiꞌij: Kajawal, ¿china ecojoyom re ri katzijom chic? yey ¿China tak chiquiwach cꞌutum wi ri chukꞌab la, Lal Dios Kajawxel? xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","E uwariꞌche na xcubiꞌ ta quicꞌuꞌx rucꞌ ri Jesús ma e xuꞌana pachaꞌ rutzꞌibam can ri Isaías puwi ri xukꞌalajisaj ri Dios che, echiriꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Wa tinamit uꞌanom pachaꞌ potzꞌ ri quiwach y uꞌanom co ri canimaꞌ; jecꞌulaꞌ na jinta cꞌo caquilo, na jinta cꞌo caquimaj usucꞌ y na caquitzelej tane quitzij chinuwach chaꞌ jelaꞌ quebenucunaj ");
INSERT INTO acrTNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri kꞌalajisanel Isaías xutzꞌibaj waꞌ ma xril pan runimal uchomal ri Jesús y lic cꞌo xukꞌalajisaj chwi Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na rucꞌ ta cꞌu riꞌ, e qꞌui xecojow re ri Jesús, jujun ne chique e aj wach re ri tinamit. Pero na xquikꞌalajisaj ta waꞌ chiquiwach ri cachbiꞌil ruma caquixiꞌij quib chiquiwach ri fariseos. Ma we xetaꞌmaxic, na quecꞌul ta chi pa ri sinagoga. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","E xquiꞌan waꞌ ma e más cucꞌul quicꞌuꞌx ri yacbal quikꞌij caquiꞌan ri winak, chwa ri yacbal quikꞌij cuꞌan ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ri Jesús co xsiqꞌuin che ubiꞌxiquil: «China ri cacubiꞌ ucꞌuꞌx wucꞌ, na xew ta cacubiꞌ ucꞌuꞌx wucꞌ riꞌin, ma e cacubiꞌ ucꞌuꞌx rucꞌ ri Jun takayom lo we. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","China ri quilow we riꞌin, e junam rucꞌ caril ri Jun takayom lo we. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","»In ri in Kꞌijsak in cꞌuninak che ruwachulew chaꞌ china ri cacubiꞌ ucꞌuꞌx wucꞌ riꞌin, na cacꞌojiꞌ ta pa kꞌekuꞌm. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Noꞌj we cꞌo junok xuta ri nuchꞌaꞌtem yey na cuꞌan ta ri cambiꞌij, na in ta ri quinkꞌataw tzij puwiꞌ. Ma in cꞌuninak che ruwachulew na re ta cankꞌat tzij paquiwi ri ticawex; e in cꞌuninak re quebenucolobej conoje ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","»Yey china ri cucꞌak bi nukꞌij y na cucoj ta ri nuchꞌaꞌtem, cꞌo ri cakꞌataw tzij puwiꞌ. Waꞌ e ri chꞌaꞌtem nubiꞌim, ri cakꞌataw tzij puwiꞌ che ruqꞌuisbal kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ma na xa ta pa we riꞌin quinchꞌaꞌtic; ri Nukaw ri takayom lo we, e intakayom lo che ronoje saꞌ ri cambiꞌij y ri cancꞌutu. ");
INSERT INTO acrTNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Riꞌin wetaꞌam e rutakanic ri Nukaw cucꞌam lo cꞌaslemal na jinta utakexic. Jecꞌulaꞌ, ronoje ri cambiꞌij riꞌin, e inutakom lo riꞌ ri Nukaw che ubiꞌxiquil» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xa nakaj chi cꞌo wi lo rukꞌijol ri nimakꞌij Pascua yey ri Jesús retaꞌam ya copon rukꞌijol echiriꞌ cuya can ruwachulew y queꞌec rucꞌ Rukaw chilaꞌ chicaj. Ecꞌu Rire lic cꞌax ebunaꞌom rutijoꞌn e cꞌo rucꞌ wara che ruwachulew; yey janipa kꞌij xcꞌojiꞌ cucꞌ, e laꞌ lic cꞌax xebunaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Xopon cꞌu rubenebal kꞌij echiriꞌ ri Jesús cucꞌ rutijoꞌn e riꞌ quewaꞌic. Jun cꞌu chique e ri Judas aj Iscariot rucꞌajol ri Simón. Yey cojom chi pa ranimaꞌ ruma ritzel winak cucꞌayij ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ecꞌu ri Jesús retaꞌam yaꞌtal ronoje pukꞌab ruma Rukaw, yey Rire petinak rucꞌ ri Dios y rucꞌ ri Dios catzelej wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na rucꞌ ta cꞌu riꞌ, ri Jesús xyactajic, xresaj rukꞌuꞌ uripom chirij, xucꞌam jun twayo pukꞌab y xuxim chupa. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tecꞌuchiriꞌ xukꞌej yaꞌ pa jun cꞌolibal, xujek uchꞌajic ri cakan rutijoꞌn y cuchakisaj rucꞌ ri twayo uximom chupa. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Echiriꞌ cujek uchꞌajic ri rakan ri Pedro, rire jewaꞌ xubiꞌij che ri Jesús: —Wajawal, ¿cachꞌaj cami la riꞌ ri wakan? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ri Jesús xucꞌul uwach: —Woꞌora na camaj ta usucꞌ saꞌ wa quintajin che uꞌanic; cꞌate na cꞌu riꞌ camaj usucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ecꞌu ri Pedro xubiꞌij che: —Riꞌin na canya ta cꞌana luwar cheꞌla cachꞌaj la ri wakan —xchaꞌ. Ri Jesús xubiꞌij che: —We na canchꞌaj ta laꞌ wakan, riꞌ na jinta chi awe wucꞌ riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Xubiꞌij cꞌu ri Pedro che: —We e riꞌ, Wajawal, na xew tane ri wakan cachꞌaj la; chꞌaja ne la riꞌ ri nukꞌab y ri nujolom —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ri Jesús jewaꞌ xubiꞌij che: —E junok cꞌacꞌ atininak, xew cajawaxic cachꞌajiꞌ ri rakan, ma ronoje rucuerpo chꞌajtal chic. Jecꞌulaꞌ riꞌix chwach ri Dios ix chi chꞌajtalic, tob na iwonoje taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús retaꞌam chic china ri cacꞌayin re; e uwariꞌche xubiꞌij: “Na iwonoje taj ix chꞌajtalic.” ");
INSERT INTO acrTNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Echiriꞌ xuqꞌuis uchꞌajic ri cakan rutijoꞌn, xurip tanchi rukꞌuꞌ chirij, xtzꞌuyiꞌ tanchi chwa ri mexa y xutzꞌonoj chique: —¿Quimaj usucꞌ saꞌ queꞌelawi wa xinꞌan chiwe? ");
INSERT INTO acrTNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Riꞌix quibiꞌij chwe: “Tijonel” y “Kajawal” y katzij ri quibiꞌij, ma lic e uꞌanom riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We in cꞌu Itijonel riꞌ yey in Iwajawal y xinchꞌaj cꞌu liꞌwakan, jecꞌulaꞌ riꞌ chiꞌana riꞌix; chichꞌaja cꞌu liꞌwakan chiwach riꞌix chiwibil iwib. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Riꞌin xinꞌan waꞌ re cꞌutubal chiwach, chaꞌ riꞌix jelaꞌ quiꞌano pachaꞌ ri xinꞌan riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Pakatzij wi cambiꞌij chiwe: Na jinta juna aj chac más cꞌo uwach chwa ri rajaw, yey na jinta ne juna takoꞌn más cꞌo uwach chwa ri takayom lo re. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We quimaj usucꞌ tak waꞌ y quitijoj iwib che uꞌanic, nim ikꞌij iwalaxic riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","»Pero na quinchꞌaꞌt ta piwiꞌ iwonoje, ma riꞌin wetaꞌam china ri ebenuchaꞌom. Yey e cuꞌana na ri tzꞌibital can pa Ruchꞌaꞌtem ri Dios, pa cubiꞌij wi: E ri jun cawaꞌ junam wucꞌ, e riꞌ ri yactajinak chwij. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quintajin cꞌu pan che ubiꞌxiquil chiwe woꞌora chaꞌ echiriꞌ cuꞌana waꞌ, riꞌix quicojo: “In Riꞌin.” ");
INSERT INTO acrTNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Pakatzij wi cambiꞌij chiwe: China ri cacꞌuluw re ri cantak bi riꞌin, e junam rucꞌ in ri quinucꞌulu; yey china cꞌu ri cacꞌuluw we riꞌin, e cucꞌul ri Jun takayom lo we —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Echiriꞌ xuqꞌuis ubiꞌxiquil waꞌ, ri Jesús xoc bis chucꞌuꞌx y jewaꞌ xubiꞌij: —Pakatzij wi cambiꞌij chiwe: Jun chiwe riꞌix quinucꞌayij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ecꞌuchiriꞌ, rutijoꞌn xquijek caquitzulaꞌ quiwach chiquibil quib ma na quetaꞌam taj china ri xubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Cꞌo cꞌu jun chique rutijoꞌn, waꞌ e ri lic cꞌax canaꞌ ruma ri Jesús, cawaꞌic jaꞌl putzal Rire chwa ri mexa. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ecꞌu ri Simón Pedro xuꞌan pan ukꞌab che chaꞌ cutzꞌonoj che ri Jesús china ri cubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri jun tijoꞌn jaꞌl putzal ri Jesús xutzꞌonoj cꞌu che: —Wajawal, ¿china laꞌ la cabiꞌij la? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús xucꞌul uwach: —Canmuꞌ juchꞌakap pam y china cꞌu che canya wi, e rire —xchaꞌ. Xumuꞌ cꞌu juchꞌakap pam y xuya che ri Judas aj Iscariot, rucꞌajol ri Simón. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Echiriꞌ ri Judas xucꞌam ri pam, xoc ri Satanás pa ranimaꞌ. Ecꞌu ri Jesús xubiꞌij che: —Ri cawaj caꞌano, chaꞌana laꞌ riꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yey na jinta junok chique ri quewaꞌ chwa ri mexa xumaj usucꞌ suꞌbe xubiꞌij laꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ruma cꞌu pukꞌab ri Judas cꞌo wi ri bolxa pa cꞌolotal wi ri quipuak, jujun chique xquichꞌobo laj ri Jesús xubiꞌij che cuꞌlokꞌo tan ri cajawax chique re ri nimakꞌij, o laj cꞌo cujach chique ri nibaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ecꞌuchiriꞌ ri Judas ucꞌamom chi ri pam, na jampatana xel bi yey lic chakꞌab chic. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Echiriꞌ elinak chubi ri Judas, ri Jesús xubiꞌij: —Ecꞌu woꞌora cakꞌalajin runimal uchomalil Ralaxel Chiquixoꞌl Ticawex y rucꞌ Rire cakꞌalajin wi runimal uchomalil ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yey we Ralaxel Chiquixoꞌl Ticawex cukꞌalajisaj runimal uchomalil ri Dios, jecꞌuriꞌlaꞌ e ri Dios ri cakꞌalajisan runimal uchomalil Ralaxel Chiquixoꞌl Ticawex, yey waꞌ na camayin ta che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","»Ix walcꞌoꞌal, xa jokꞌotaj chi in cꞌo iwucꞌ. Riꞌix quinitzucuj na cꞌu riꞌ; pero e pachaꞌ ri ximbiꞌij chique raj judiꞌab, na jinta pikꞌab quixꞌec chilaꞌ pa quinꞌec wi riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","»Canya wa jun cꞌacꞌ takanic chiwe: E lic cꞌax chinaꞌa iwib chiwach. Jelaꞌ pachaꞌ riꞌin lic cꞌax quixinnaꞌo, jecꞌulaꞌ lic cꞌax chinaꞌa iwib riꞌix chiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We lic cꞌu cꞌax quinaꞌ iwib chiwach, ruma waꞌ conoje ri winak caquetaꞌmaj ix nutijoꞌn —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri Simón Pedro xutzꞌonoj che ri Jesús: —Wajawal, ¿pa cꞌu queꞌec wi la? —xchaꞌ. Ri Jesús xucꞌul uwach: —E pa wa quinꞌec wi riꞌin, na yaꞌtal ta chawe cat-terej bi chwij woꞌora; noꞌj copon na cꞌu rukꞌijol echiriꞌ catopon chilaꞌ pa quinꞌec wi riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ecꞌu ri Pedro xubiꞌij che: —Wajawal, ¿suꞌchac na yaꞌtal ta chwe quinterej bi chiꞌij la woꞌora? Ma riꞌin xa jumul canya ne ri nucꞌaslem pa camic uma rilal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Y ri Jesús xucꞌul uwach: —¿Lic katzij cawaj caya awib pa camic wuma riꞌin? Pakatzij wi cambiꞌij chawe: Echiriꞌ cꞌamajaꞌ ne cabixon ri teren, riꞌat oxlaj chic abiꞌim na awetaꞌam ta nuwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","»Lic mapax icꞌuꞌx. E chicubaꞌ icꞌuꞌx rucꞌ ri Dios y chicubaꞌ icꞌuꞌx wucꞌ riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chilaꞌ pa cꞌo wi ri Nukaw lic uqꞌuiyal jeklebal cꞌolic. We ta na e ta uꞌanom, riꞌin nubiꞌim chi riꞌ chiwe. Ecꞌu waꞌ quinꞌec chaꞌ quiꞌnyijbaꞌ jun luwar iwe riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yey we xinꞌec cꞌut y xyijbitaj ri luwar iweꞌix, quincꞌun tanchic y quixoꞌlnucꞌamaꞌ chaꞌ jelaꞌ pa quineꞌcꞌola wi riꞌin, riꞌix quixeꞌcꞌola chilaꞌ wucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Riꞌix iwetaꞌam pa quinꞌec wi yey iwetaꞌam ri be —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Xubiꞌij cꞌu ri Tomás che: —Kajawal, riꞌoj na ketaꞌam taj pa queꞌec wi la. ¿Saꞌ cꞌu uꞌanic riꞌ caketaꞌmaj ri be? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ri Jesús xucꞌul uwach: —In ri in Be, in ri in Kꞌijsak yey in ri in Cꞌaslemal. Na jinta junok copon rucꞌ ri Nukaw we na wuma ta riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We iwetaꞌam nuwach riꞌin, iwetaꞌam uwach riꞌ ri Nukaw. Chwi cꞌu riꞌ woꞌora quiwetaꞌmaj uwach, ma iwilom chi uwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ecꞌu ri Felipe xubiꞌij che: —Kajawal, cꞌutu la chikawach ri Kaw la y cojcubiꞌ cꞌu riꞌ che —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xucꞌul uwach: —Felipe, uqꞌuiyal kꞌij chi waꞌ cꞌut e laꞌ in cꞌo iwucꞌ, ¿yey cꞌamajaꞌ cawetaꞌmaj nuwach? Ma china ri etaꞌmayom nuwach riꞌin, riꞌ e rilom uwach ri Nukaw. ¿Suꞌchac cꞌu riꞌ catzꞌonoj chwe cancꞌut ri Nukaw chiwach? ");
INSERT INTO acrTNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Riꞌin rucꞌ ri Nukaw y Rire wucꞌ riꞌin, xa oj jun. ¿Na cacoj ta cami riꞌ waꞌ? E janipa wa cambiꞌij chiwe, na xa ta pa we riꞌin cambiꞌij ma ri nuchꞌaꞌtem e re ri Nukaw ri jekel wucꞌ, yey Rire cuꞌan ruchac wuma riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chicojo cꞌu wa cambiꞌij chiwe: Riꞌin rucꞌ ri Nukaw y Rire wucꞌ riꞌin, xa oj jun. We na quicoj ta cꞌu waꞌ ruma ri nuchꞌaꞌtem, e chicojo ruma ri chac nuꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","»Pakatzij wi cambiꞌij chiwe: China ri cacubiꞌ ucꞌuꞌx wucꞌ riꞌin, riꞌ cuꞌan ne ri chac jelaꞌ pachaꞌ ri canꞌan riꞌin; y más ne nimak tak chac ri cuꞌano, ma e riꞌin quinꞌec pa cꞌo wi ri Nukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronoje cꞌu ri quitzꞌonoj riꞌix che ri Nukaw pa ri nubiꞌ, riꞌin canꞌano chaꞌ jelaꞌ runimal uchomalil ri Dios cakꞌalajin ruma Rucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ronoje cꞌu riꞌ ri quitzꞌonoj riꞌix pa ri nubiꞌ, riꞌin canꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","»We riꞌix cꞌax quininaꞌo, e lic chiꞌana janipa ri quixintak che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yey riꞌin e cantzꞌonoj che ri Nukaw chaꞌ cutak chi lo jun chic Toꞌbel iwe re cunimarisaj icꞌuꞌx; y asu cacꞌojiꞌ iwucꞌ na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Waꞌ e ri Uxlabixel re ri Kꞌijsak. Tak ri winak na utz taj caquicꞌulu, ma na caquil ta uwach y na quetaꞌam tane uwach. Noꞌj riꞌix iwetaꞌam uwach, ma Rire cꞌo chixoꞌlibal y coꞌlcꞌola piwanimaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","»Riꞌin na quixinwokꞌotaj ta canok, ma quintzelej lo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na naj ta chi cꞌu riꞌ, ri winak na caquil ta chi nuwach; noꞌj riꞌix quiwil tanchi nuwach. Ruma cꞌu riꞌin quincꞌastaj lo chiquixoꞌl ri ecaminak, jenelaꞌ riꞌix quixcꞌastajic. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chupa cꞌu riꞌ laꞌ la kꞌij riꞌix quiwetaꞌmaj: Riꞌin rucꞌ ri Nukaw xa oj jun, yey riꞌix xa jun iꞌanom wucꞌ riꞌin y riꞌin xa jun nuꞌanom iwucꞌ riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","China cꞌu ri ucꞌulum ri nutakanic y cuꞌan cꞌu janipa ri cambiꞌij che, riꞌ lic cꞌax quinunaꞌo. Y china ri cꞌax canaꞌw we riꞌin, cꞌax canaꞌ ruma ri Nukaw. Yey riꞌin lic cꞌax cannaꞌo y cankꞌalajisaj che, in china riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ri Judas (na e ta ri aj Iscariot) xubiꞌij: —Kajawal, ¿suꞌbe cakꞌalajisaj la chikawach riꞌoj china rilal yey chiquiwach ri winak na caꞌan ta la waꞌ? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ri Jesús xucꞌul uwach: —China ri cꞌax quinunaꞌ riꞌin, e cuꞌan janipa ri cambiꞌij che. Ecꞌu ri Nukaw cꞌax cunaꞌ rire, yey ri Nukaw y riꞌin cojoꞌljekela rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","China cꞌu ri na cꞌax ta quinunaꞌo, riꞌ na cutakej ta janipa ri cambiꞌij che. Wa tzij quixtajin che utayic, na xa ta weꞌin, e re ri Nukaw, ri xtakaw lo weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","»Ronoje waꞌ quintajin che ubiꞌxic chiwe xalokꞌ cꞌa in cꞌo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yey echiriꞌ quinꞌec, ri Nukaw cutak lo ri jun Toꞌbel pa ri nubiꞌ re cubochiꞌij icꞌuꞌx, waꞌ e ri Santowilaj Ruxlabixel ri Dios. Echiriꞌ cacꞌun Rire, cucꞌut ronoje chiwach y cucuxtaj cꞌu chiwe janipa ri nubiꞌim riꞌin chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","»Ri utzil chomal cꞌo wucꞌ riꞌin, canya can chiwe. Yey waꞌ wa utzil chomal canya riꞌin chiwe na xa ta jelaꞌ pachaꞌ ri caquiya tak ri winak. Mapax cꞌu icꞌuꞌx y mixiꞌij iwib. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","»Itom chi cꞌu ri nubiꞌim chiwe: “Quinꞌec yey quintzelej tanchi lo iwucꞌ.” We e laꞌ katzij lic cꞌax quininaꞌo, xixquiꞌcot tane cꞌu riꞌ che echiriꞌ xito quinꞌec rucꞌ ri Nukaw, ma Rire más cꞌo uwach chinuwa riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","»Cannabesaj pan ubiꞌxic waꞌ chiwe chaꞌ echiriꞌ cuꞌanaꞌ, quicoj cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na naj ta chi cꞌut quinchꞌaꞌt iwucꞌ; ma ya cacꞌun lo ritzel winak, ri jun catakan che ruwachulew, tob na jinta ne pukꞌab rire catakan panuwi riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na rucꞌ ta cꞌu riꞌ, canꞌano janipa ri quinutak ri Nukaw che uꞌanic, chaꞌ jelaꞌ ri winak che ruwachulew caquetaꞌmaj riꞌin lic cꞌax cannaꞌ ri Nukaw. »Chixyactajok; joꞌ, chojel bi wara. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","»In ri in sakil rakan uva y ri Nukaw e ri aj chacunel chupa tak ri uva. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","We cꞌo cꞌu juna ukꞌab ri uva na cuya ta uwach, Rire cukꞌat bi. Noꞌj cꞌu ri cuya uwach, xa e cujal uwiꞌ re cuꞌan chom che chaꞌ jelaꞌ cuya más uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jecꞌulaꞌ riꞌix ꞌanom chi chom chiwe ruma ri cꞌutunic nuꞌanom chiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","»Miwesaj iwib chwij, jecꞌulaꞌ xa jun kaꞌanom, riꞌix wucꞌ riꞌin y riꞌin iwucꞌ riꞌix. Ma e pachaꞌ juna ukꞌab cheꞌ na cawachin ta xa utuquel we quesax che ri rakan; jecꞌulaꞌ riꞌ riꞌix, na utz taj quixwachinic we quiwesaj iwib chwij. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","»In ri in rakan ri ticoꞌn yey riꞌix ix rukꞌab. China cꞌu ri uꞌanom xa jun wucꞌ riꞌin yey riꞌin in xa jun rucꞌ rire, riꞌ lic cawachinic. Ma we iwesam iwib chwij, na jinta quichꞌij uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","China cꞌu ri caresaj rib chwij, jelaꞌ caꞌan che pachaꞌ rukꞌab cheꞌ na jinta uchac, cachetic y cacꞌak bi. Cachakij cꞌut, tecꞌuchiriꞌ camolic y caporox pa akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","»Yey we e laꞌ xa jun iꞌanom riꞌix wucꞌ y na quicꞌow ta chicꞌuꞌx tak ri nucꞌutum chiwach, chitzꞌonoj cꞌu riꞌ saꞌ tak ri quiwaj y cayaꞌtaj na chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ri Nukaw lic cayaquiꞌ ukꞌij echiriꞌ riꞌix quiya uqꞌuiyal ijikꞌobalil y rucꞌ waꞌ cakꞌalajinic pa sakil wi ix nutijoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","»Jecꞌulaꞌ pachaꞌ ri Nukaw lic cꞌax quinunaꞌ riꞌin, jecꞌuriꞌlaꞌ riꞌin cꞌax quixinnaꞌ riꞌix. Lic cꞌut miwesaj iwib chupa ri rutzil nucꞌuꞌx chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We e quiꞌan janipa ri quixintak che, quixcꞌojiꞌ cꞌu riꞌ chupa wa rutzil nucꞌuꞌx, jelaꞌ pachaꞌ riꞌin nuꞌanom janipa ri inutakom ri Nukaw che uꞌanic yey in cꞌo chupa ri rutzil ucꞌuꞌx Rire. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","»Ximbiꞌij waꞌ chiwe chaꞌ ri nuquiꞌcotemal cacꞌojiꞌ iwucꞌ y canoj cꞌu riꞌ ri iwanimaꞌ che quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","»Ecꞌu nutakanic waꞌ canya chiwe: Lic cꞌax chinaꞌa iwib chiwach jelaꞌ pachaꞌ riꞌin lic cꞌax quixinnaꞌo. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na jinta juna cꞌutubal re ri rutzil cꞌuꞌxaj más nim chwa waꞌ: E junok cuya rucꞌaslem che utoꞌic jun chic tob ne cacam ruma. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","»Riꞌix ix wamigos we e laꞌ e quiꞌan janipa ri quixintak che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na cambiꞌij ta chi ne “waj chac” chiwe, ma e juna aj chac na retaꞌam taj saꞌ ri cuꞌan ri rajaw. Cambiꞌij cꞌu chiwe “ix wamigos”, ma nuyaꞌom chi retaꞌmaxic chiwe ronoje ri ubiꞌim lo ri Nukaw chwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na ix ta xixchaꞌw we riꞌin, in ri xinchaꞌw iwe. Yey nuyaꞌom pikꞌab quiꞌana ri nuchac y jelaꞌ quiya uqꞌuiyal ijikꞌobalil y waꞌ na jinta uqꞌuisic. Yey janipa cꞌu ri quitzꞌonoj che ri Nukaw pa ri nubiꞌ, Rire cuya na chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ecꞌu quixintak che uꞌanic waꞌ: Cꞌax chinaꞌa iwib chiwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","»We tzel quixquil ri winak che ruwachulew, chiwetaꞌmaj e riꞌin ri nabe tzel quinquilo. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We ta e laꞌ junam ribinic riꞌix cucꞌ ri ticawex re ruwachulew, riꞌ lic cꞌax quixnaꞌic. Noꞌj in xinchaꞌw iwe riꞌix chiquixoꞌl ri winak; e uwariꞌche tzel quixilic. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cꞌuna chicꞌuꞌx ri nubiꞌim chiwe: Na jinta juna aj chac más cꞌo uwach chwa ri rajaw. We riꞌin internabem rucꞌ cꞌaxcꞌobic, jelaꞌ riꞌ caꞌan chiwe riꞌix, quixternabex rucꞌ cꞌaxcꞌobic. Yey we e cꞌo ri quitakem ri nutzij riꞌin, jecꞌulaꞌ riꞌ, e cꞌo ri caquitakej ri quicꞌut riꞌix. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero ri quixquiternabej rucꞌ cꞌax ruma icojom ri nubiꞌ, e caquiꞌan waꞌ ruma na quetaꞌam ta uwach ri xintakaw lok. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","»We tamaji xincꞌun riꞌin y tamaji xincꞌut rutzij ri Nukaw chiquiwach, na jinta cꞌu quimac riꞌ ruma na xquicꞌul ta wa tzij. Noꞌj riꞌin xincꞌunic y xincꞌut rutzij ri Nukaw chiquiwach; ruma cꞌu waꞌ, na jinta junok chique utz cubiꞌij na jinta umac. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma e ri tzel quebilow we riꞌin, riꞌ e tzel caquil ri Nukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na jinta cꞌu quimac we tamaji nuꞌanom uqꞌuiyal milagros chiquiwach yey waꞌ na jinta chi ne junok ꞌanayom re. Noꞌj rique quilom ronoje tak waꞌ; y na rucꞌ ta cꞌu riꞌ, tzel quinquil riꞌin y tzel caquil ri Nukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","»Ecꞌu xuꞌan tak waꞌ chaꞌ lic e cuꞌana janipa ri tzꞌibital can pa ri Tzij Pixab cꞌo paquikꞌab rique: Tzel xinquilo tob na jinta numac cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","»Yey echiriꞌ quinopon rucꞌ ri Nukaw, cantak lo Jun Toꞌbel iwe re cunimarisaj icꞌuꞌx. Rire cape rucꞌ ri Nukaw y e Kꞌalajisanel re ri Kꞌijsak. Ecꞌuchiriꞌ cacꞌunic, cakꞌalajisan chiwach riꞌix panuwi riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yey riꞌix quixkꞌalajisan na panuwi riꞌin, ma ix cꞌojiꞌnak wucꞌ chwi ri jekebal lo ri nuchac. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","»Ximbiꞌij cꞌu ronoje waꞌ chiwe chaꞌ na casach ta ri cubulibal icꞌuꞌx wucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ma copon rukꞌijol echiriꞌ quixesax ne bi riꞌix chupa tak ri sinagogas. Y china ri cacamisan iweꞌix, e chwa rire uchac ri Dios ri cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","E caquiꞌan waꞌ ma na quetaꞌam ta cꞌana uwach ri Nukaw y na quetaꞌam tane nuwach riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Cambiꞌij waꞌ chiwe, ma we xopon rukꞌijol waꞌ, cꞌuna chicꞌuꞌx nubiꞌim chi lo waꞌ chiwe. »Na ximbiꞌij ta lo waꞌ chiwe chwi ri jekebal lok, ma cꞌa in cꞌo iwucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Noꞌj woꞌora quinꞌec chaꞌ quineꞌcꞌola rucꞌ ri takayom lo we riꞌin, yey na jinta chi ne junok chiwe cutzꞌonoj chwe pa quinꞌec wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yey ruma ne nubiꞌim waꞌ chiwe, lic xoc bis chicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero katzij wa cambiꞌij chiwe: Lic utz chiwe riꞌix we quinꞌec. Ma we na quinꞌec taj, na cacꞌun ta iwucꞌ ri Toꞌbel re cubochiꞌij icꞌuꞌx. Noꞌj we xinꞌec, cantak lo chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","»Echiriꞌ cacꞌun ri Ruxlabixel ri Dios, cuya na chi retaꞌmaxic chique ri winak re ruwachulew china ri cꞌo umac, china ri lic jusucꞌ chwach ri Dios y china puwiꞌ cꞌo wi ri kꞌatbal tzij re ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Cukꞌalajisaj cꞌut china ri cꞌo umac: Waꞌ e ri na cacubiꞌ ta ucꞌuꞌx wucꞌ riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Cukꞌalajisaj china ri lic jusucꞌ, ma riꞌin quinꞌec rucꞌ ri Nukaw yey riꞌix na quiwil ta chi nuwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yey cukꞌalajisaj, ri Dios ukꞌatom chi tzij puwi ritzel winak catakan che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","»Lic cꞌo cuaj cambiꞌij chiwe, pero na cambiꞌij tana, ma woꞌora na quimaj ta usucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Noꞌj echiriꞌ cacꞌun ri Uxlabixel re ri Kꞌijsak, riꞌ cucꞌut chiwach riꞌix ronoje ri lic katzij. Rire na xa ta pa re cachꞌaꞌtic, ma janipa ri cubiꞌij e ubiꞌim ri Dios che y jelaꞌ cuya chi retaꞌmaxic chiwe tak ri catajin lok. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ma e cukꞌalajisaj janipa ri cuaj cambiꞌij riꞌin chiwe, y jelaꞌ cunimarisaj nukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronoje ri cꞌo rucꞌ ri Nukaw, cꞌo wucꞌ riꞌin; e uwariꞌche ximbiꞌij ri Ruxlabixel e cukꞌalajisaj janipa ri cuaj cambiꞌij riꞌin chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","»Na naj ta chi cꞌu riꞌ quiwil nuwach, ma riꞌin quinꞌec chilaꞌ pa cꞌo wi ri Nukaw; pero chikawach apanok quiꞌwila tanchi nuwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ecꞌuchiriꞌ, jujun chique rutijoꞌn jewaꞌ xquitzꞌonoj chiquiwach: «¿Saꞌ queꞌelawi waꞌ? Ma cubiꞌij: “Na naj ta chi cꞌu riꞌ quiwil nuwach, ma riꞌin quinꞌec chilaꞌ pa cꞌo wi ri Nukaw; pero chikawach apanok quiꞌwila tanchi nuwach.” ");
INSERT INTO acrTNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Saꞌ queꞌelawi: “Na naj ta chi cꞌu riꞌ”? Na cakamaj ta usucꞌ saꞌ puwi cachꞌaꞌt wi» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ri Jesús xunaꞌbej cacaj caquiꞌan tzꞌonobal che. Ruma cꞌu riꞌ xubiꞌij chique: —Riꞌin ximbiꞌij chiwe: “Na naj ta chi cꞌu riꞌ quiwil nuwach, pero chikawach apanok quiꞌwila tanchi nuwach.” ¿E quitzꞌonoj saꞌ queꞌelawi waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Pakatzij wi cambiꞌij chiwe: Riꞌix quixokꞌ na y quixbison na, tob ri winak re ruwachulew quequiꞌcotic. Tob riꞌix quixbison woꞌora, wa bis cuꞌana quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","»Echiriꞌ cutzir uwach juna ixok, lic cacꞌojiꞌ pa cꞌaxcꞌolil ma xopon rukꞌij. Noꞌj echiriꞌ alaxinak chi racꞌa, na cacꞌun ta chi ne chucꞌuꞌx ri cꞌaxcꞌolil ruma ruquiꞌcotemal, ma xalax jun acꞌa che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jecꞌuriꞌlaꞌ riꞌix capax icꞌuꞌx woꞌora; noꞌj echiriꞌ quiwil tanchi nuwach, canoj cꞌu ri iwanimaꞌ che quiꞌcotemal yey waꞌ wa quiꞌcotemal na jinta junok quesan re chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chupa cꞌu riꞌ laꞌ la kꞌij na cajawax ta chic quiꞌan tzꞌonobal chwi ri nubiꞌim. »Pakatzij wi cambiꞌij chiwe: Ronoje ri quitzꞌonoj che ri Nukaw pa ri nubiꞌ, Rire cuya chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cꞌa chwi woꞌora riꞌix na jinta cꞌo itzꞌonom pa ri nubiꞌ riꞌin. Chitzꞌonoj y quicꞌulu, chaꞌ jelaꞌ canoj ri iwanimaꞌ che quiꞌcotemal. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","»Nubiꞌim waꞌ chiwe rucꞌ cꞌambal naꞌoj; noꞌj copon cꞌu ri kꞌij echiriꞌ na cajawax ta chic quinchꞌaꞌt iwucꞌ rucꞌ cꞌambal naꞌoj, ma riꞌ lic kꞌalaj chiwach riꞌix janipa ri cambiꞌij chiwe chwi ri Nukaw. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chupa cꞌu laꞌ la kꞌij, utz quitzꞌonoj che ri Nukaw chupa ri nubiꞌ janipa ri cajawax chiwe. Yey na cajawax ta cꞌu riꞌ quinelaj chwach ri Nukaw piwiꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ma ri Nukaw lic cꞌax quixunaꞌo ruma cꞌax ininaꞌom riꞌin yey lic icojom, riꞌin rucꞌ ri Dios in petinak wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Riꞌin in petinak rucꞌ ri Nukaw y xincꞌun che ruwachulew; yey woꞌora e waꞌ canya can ruwachulew y quintzelej rucꞌ ri Nukaw —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ecꞌu rutijoꞌn xquibiꞌij che: —Woꞌora lic kꞌalaj ri cabiꞌij la chike, ma na cachꞌaꞌt ta chi la rucꞌ cꞌambal naꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yey woꞌora cakamaj usucꞌ rilal lic etaꞌam la ronoje. Uwariꞌche na cajawax taj cꞌo junok cuꞌan tzꞌonobal cheꞌla, ma etaꞌam chi la saꞌ ri cakaj cakatzꞌonoj echiriꞌ cꞌamajaꞌ ne cakaꞌan ri tzꞌonobal. Ruma cꞌu laꞌ, kacojom rilal rucꞌ ri Dios petinak wi la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ri Jesús xucꞌul uwach: —¿Cꞌa e woꞌora quicoj waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Cacꞌun cꞌu rukꞌijol y waꞌ ya xujeko echiriꞌ riꞌix quixquicher bi. Chijujunal cꞌut quimaj bi ibe y quiniya can nutuquel. Pero riꞌin na quincanaj ta can nutuquel, ma ri Nukaw cꞌo wucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","»Ximbiꞌij ronoje waꞌ chiwe chaꞌ wuma riꞌin quirik utzil chomal. Che ruwachulew riꞌix lic quitij cꞌax. Pero chinimarisaj cꞌu icꞌuꞌx, ma riꞌin nuchꞌijom uchukꞌab tak ri na utz taj re ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Echiriꞌ ubiꞌim chi waꞌ, ri Jesús xtzuꞌn chicaj y xubiꞌij: «Nukaw, xopon ru orayil; yaca cꞌu la ukꞌij ri Cꞌajol la chaꞌ jelaꞌ ri Cꞌajol la cuyac kꞌij Rilal. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ma Rilal yaꞌom la che ri Cꞌajol la catakan paquiwi conoje ri ticawex, chaꞌ pukꞌab Rire cꞌo wi cuya cꞌaslemal na jinta utakexic chique conoje ri eyaꞌom la che. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ecꞌu wa cꞌaslemal na jinta utakexic e ruma ri quetaꞌmax wach la, xew Rilal Lal Dios y na jinta jun chic, yey quetaꞌmax cꞌu uwach ri Jesucristo, ri xtak lo la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","»Riꞌin nuyacom kꞌij la wara che ruwachulew y xinqꞌuis uꞌanic ri xintak lo la che uꞌanic. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ecꞌu woꞌora Nukaw, yaca la nukꞌij chilaꞌ ucꞌ la, jelaꞌ pachaꞌ ri ꞌanom la chwe echiriꞌ cꞌamajaꞌ ne cajeker ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","»Chique tak ri ticawex xeya la chwe che ruwachulew, nukꞌalajisam china Rilal. Rique e e la, y xeya la panukꞌab yey quitakem ri tzij la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Y woꞌora quetaꞌam waꞌ: Ronoje ri yaꞌom la chwe, ucꞌ la petinak wi. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma janipa ri xbiꞌij la chwe, nutzijom chique ri xeya la chwe, y rique xquicojo. Yey xquetaꞌmaj cꞌut pakatzij wi riꞌin ucꞌ la in petinak wi y Lal takayom lo la weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","»Riꞌin quinelaj co chiwach la paquiwi rique; na e ta paquiwi conoje ri ticawex, xew paquiwi ri eyaꞌom la panukꞌab, ma rique e e la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Conoje ri e cꞌo panukꞌab, e e la. Jecꞌulaꞌ riꞌ, conoje ri e cꞌo pakꞌab Rilal, e weꞌin. Y ri yacbal nukꞌij cakꞌalajin cuma rique. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","»Yey riꞌin quintzelej ucꞌ la, na quincanaj ta can che ruwachulew; noꞌj rique quecanajic. Lal Santowilaj Nukaw, chechajij co la chupa ri biꞌ la, ri eyaꞌom la chwe, chaꞌ chuꞌana xa jun quicꞌuꞌx jelaꞌ pachaꞌ nuꞌanom riꞌin ucꞌ la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Echiriꞌ riꞌin in cꞌo cucꞌ wara che wuꞌwachulew, xebenuchajij chupa ri biꞌ la ri eyaꞌom la chwe. Na jinta junok chique xsachic, xew cꞌu ri jun xex wi sachinak chic chaꞌ e cuꞌana janipa ri tzꞌibital can chupa ri Chꞌaꞌtem la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","»Ecꞌu woꞌora quintzelej tanchi ucꞌ la. Pero xalokꞌ cꞌa in cꞌo che ruwachulew, cambiꞌij tak waꞌ chique chaꞌ lic canoj ri canimaꞌ che quiꞌcotemal, jelaꞌ pachaꞌ ri quiꞌcotemal cꞌo wucꞌ riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","»Riꞌin nuyaꞌom ri Chꞌaꞌtem la chique. Yey tak ri winak re ruwachulew tzel quequilo ma na junam ta quicꞌuꞌx cucꞌ, jelaꞌ pachaꞌ riꞌin na junam ta nucꞌuꞌx cucꞌ ri e re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na e ta cꞌu quinelaj chiwach la chaꞌ quebesaj la che ruwachulew, xew lic chechajij la chwach ritzel winak. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rique na junam ta quicꞌuꞌx cucꞌ ri e re ruwachulew, jelaꞌ pachaꞌ riꞌin na junam ta nucꞌuꞌx cucꞌ ri e re ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","»Yaꞌa cꞌu la chique quebin jusucꞌ chupa ri Kꞌijsak e la, waꞌ e ri Chꞌaꞌtem la. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jelaꞌ pachaꞌ Rilal xintak lo la chiquixoꞌl ri ticawex che ruwachulew, jecꞌuriꞌlaꞌ riꞌin quebenutak bi rique chiquixoꞌl ri ticawex che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Y cuma cꞌu rique, lic nuyaꞌom wib riꞌin che uꞌanic ri rajawal cꞌuꞌx la, chaꞌ jelaꞌ rique quebin jusucꞌ chupa ri Kꞌijsak. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","»Yey na xew tane quinelaj chiwach la paquiwi rique, ma e cantzꞌonoj cheꞌla paquiwi ri cꞌamajaꞌ caquicoj ri nubiꞌ ruma caquita ri tzijonic caquiꞌan rique. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Lal Nukaw, cantzꞌonoj co cheꞌla chuꞌana xa jun quicꞌuꞌx chiquiwach junam kucꞌ riꞌoj, jelaꞌ pachaꞌ riꞌin ucꞌ la y Rilal wucꞌ riꞌin, chaꞌ ri e cꞌo che ruwachulew caquicojo e rilal takayom lo la we riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","»Ri yacbal nukꞌij yaꞌom la chwe riꞌin, xinya chique rique chaꞌ chuꞌana xa jun quicꞌuꞌx jelaꞌ pachaꞌ Rilal y riꞌin xa jun kacꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Riꞌin in cꞌo cucꞌ rique y Rilal cꞌo la wucꞌ riꞌin chaꞌ rique cuꞌan xa jun quicꞌuꞌx pa sakil wi. Jecꞌulaꞌ riꞌ conoje ri ticawex che ruwachulew caquetaꞌmaj e Rilal takayom lo la we riꞌin y lic cꞌax quenaꞌ la ri nutijoꞌn, jelaꞌ pachaꞌ lic cꞌax quinnaꞌ la riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","»Lal Nukaw, e janipa ri eyaꞌom la panukꞌab, e cuaj riꞌin quebeꞌcꞌola wucꞌ pa quineꞌcꞌola wi, chaꞌ caquil ri yacbal nukꞌij yaꞌom la. Ma xex wi cꞌax innaꞌom lo la, chwi echiriꞌ cꞌamajaꞌ ne cajeker ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nukaw, Rilal lic Lal jusucꞌ, yey ri ticawex che ruwachulew na quetaꞌam ta wach la. Noꞌj riꞌin wetaꞌam wach la yey ri nutijoꞌn quetaꞌam e Rilal takayom lo la we riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lic cꞌut nukꞌalajisam chiquiwach china Rilal y cꞌa quintajin ne che ukꞌalajisaxic waꞌ, chaꞌ ri rutzil cꞌuꞌx la chwe riꞌin, cacꞌojiꞌ cucꞌ rique y jelaꞌ quincꞌojiꞌ riꞌin pa canimaꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Echiriꞌ ri Jesús xuqꞌuis ubiꞌxiquil tak waꞌ, xel bi junam cucꞌ rutijoꞌn, xquikꞌaxuj cꞌu ri rakanaꞌ Cedrón y xeboc chupa jun werta cꞌo chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri Judas, ri cacꞌayin re ri Jesús, retaꞌam chi ri luwar, ma uqꞌuiyal laj ri Jesús cucꞌ rutijoꞌn quimolom quib chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ecꞌu ri Judas xoponic, ebucꞌamom bi uqꞌuiyal soldados y tak ri chajinel re ri Rocho Dios. Rique cucꞌaꞌam tak chapabal, yey e cꞌo ri cawolol ri qui akꞌ y e cꞌo ri xa quitzuqꞌuem qui akꞌ. Waꞌ etakom bi cuma ri nimak e aj chacunel pa Rocho Dios y ri fariseos. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ecꞌu ri Jesús ruma retaꞌam chi ronoje ri catajin lo puwiꞌ, xebuꞌcꞌulu apanok y xutzꞌonoj chique: —¿China ri quitzucuj? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rique xquicꞌul uwach: —E Jesús ri aj Nazaret —xechaꞌ. Ri Jesús xubiꞌij cꞌu chique: —In riꞌin —xchaꞌ. Yey ri Judas, ri cacꞌayin re, cꞌo chiquixoꞌl ri cacaj caquichap bi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Echiriꞌ xubiꞌij ri Jesús chique: “In riꞌin”, xetzelej chiquij y xetzak pulew. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ecꞌu ri Jesús xutzꞌonoj tanchi chique: —¿China ri quitzucuj? —xchaꞌ. Y rique xquibiꞌij: —E Jesús ri aj Nazaret —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Xubiꞌij cꞌu ri Jesús chique: —Riꞌin nubiꞌim chi che alak; “In riꞌin.” We in cꞌu ri quintzucuj alak, yaꞌa bi alak luwar chique wa nutijoꞌn chebeꞌojana —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E xubiꞌij waꞌ ri Jesús chaꞌ e cuꞌana ri ubiꞌim chic: «Na jinta junok xsach chique ri ebuyaꞌom ri Nukaw chwe.» ");
INSERT INTO acrTNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ecꞌu ri Simón Pedro rucꞌaꞌam jun espada. Xresaj cꞌu ulok y xujochij bi ruxiquin uwiquikꞌab ri raj chac ri cajawal raj chacunel pa Rocho Dios. Wa aj chac Malco rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ri Jesús xubiꞌij cꞌu che ri Pedro: —Chacꞌolo ra espada chupa rucꞌolibal. ¿Na quinicꞌow ta cami riꞌ pa ri cꞌaxcꞌobic we e ri Nukaw intakayom lo che? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ecꞌuchiriꞌ, ri soldados y ri takanel que, junam cucꞌ raj judiꞌab e chajinel re ri Rocho Dios, xquichap ri Jesús y xquiyutu. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Xquicꞌam cꞌu bi ri Jesús chwa ri Anás, rukaw-ujiꞌ ri Caifás ri cajawal raj chacunel pa Rocho Dios chupa laꞌ la junab. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yey e Caifás ri ubiꞌim chique raj judiꞌab: «E más utz we ta e laꞌ xa jun chi achi cacam cuma conoje ri tinamit.» ");
INSERT INTO acrTNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro y jun chic tijoꞌn eteran bi chirij ri Jesús. Waꞌ wa jun chic tijoꞌn etaꞌmatal uwach ruma ri cajawal raj chacunel pa Rocho Dios; ecꞌu rire xoc bi rucꞌ ri Jesús che ruwa ja re ri rocho ri aj wach. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Noꞌj ri Pedro xcanaj can chwa ri puerta pa be. Ruma cꞌu riꞌ, xel lo ri jun tijoꞌn etaꞌmatal uwach ruma ri cajawal raj chacunel pa Rocho Dios, xchꞌaꞌt rucꞌ rali aj chajal re ri puerta chaꞌ cuya luwar che ri Pedro coc bi. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ecꞌuchiriꞌ rali xutzꞌonoj che ri Pedro: —¿Na lal ta nawi jun chique rutijoꞌn laꞌ la jun achi? —xchaꞌ. Ri Pedro xucꞌul uwach: —Na in taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ruma cꞌu lic cꞌax tew, raj chaquib y ri e chajinel e tacꞌal chuchiꞌ jun akꞌ quinucꞌum re caquimikꞌisaj quib. Yey ri Pedro cꞌo cucꞌ chuchiꞌ ri akꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri cajawal raj chacunel pa Rocho Dios xujek utzꞌonoxic che ri Jesús paquiwi tak rutijoꞌn y puwi rucꞌutunic. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ri Jesús xubiꞌij che: —Riꞌin in tzijoninak chiwachil chiquiwach conoje ri winak, xaki in cꞌutuninak pa tak sinagogas y pa ri Rocho Dios pa caquimol wi quib raj judiꞌab. Na jinta cꞌo nubiꞌim xa xeꞌlakꞌay. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Suꞌchac cꞌu riꞌ catzꞌonoj alak chwe puwi ri nucꞌutunic? E tzꞌonoj alak chique ri e tayom we riꞌin, ma rique quetaꞌam saꞌ ri nucꞌutum chiquiwach —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Echiriꞌ xubiꞌij waꞌ ri Jesús, jun chique ri e chajinel xupachꞌ jun kꞌab chupalaj ri Jesús y xubiꞌij che: —¿Utz neba jelaꞌ cacꞌulubej uwach ri cajawal raj chacunel pa Rocho Dios? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ri Jesús xucꞌul uwach: —We ximbiꞌij juna chꞌaꞌtem na utz taj, biꞌij la riꞌ saꞌ ri na utz taj ximbiꞌij. Noꞌj we utz ri ximbiꞌij, ¿suꞌchac cꞌu riꞌ xinchꞌay la? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yutum chi ri Jesús, ri Anás xutak bi chwa ri Caifás, ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ecꞌu ri Pedro tacꞌal chuchiꞌ ri akꞌ, cumikꞌisaj rib. Yey e cꞌo jujun jewaꞌ xquibiꞌij che: —¿Na lal ta nawi jun chique rutijoꞌn laꞌ la jun achi? —xechaꞌ. Ri Pedro xrewaj, jewaꞌ xubiꞌij: —¡Jaꞌi! Na in taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chiriꞌ cꞌo jun raj chac ri cajawal raj chacunel pa Rocho Dios. Rire cꞌo chux che ri jun xjochix ruxiquin ruma ri Pedro. Xutzꞌonoj cꞌu che ri Pedro: —¿Na xinwil ta neba wach la chilaꞌ pa ri werta rucꞌ ri Jesús? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yey ri Pedro xrewaj tanchic, y ecꞌuchiriꞌ xbixon lo ri teren. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","E riꞌ catajin usakiric echiriꞌ xesax bi ri Jesús chwa rocho ri Caifás y xcꞌam bi pa ri palacio re ri Pilato, ri takanel aj Roma. Ecꞌu ri aj judiꞌab na xeboc ta chupa ri palacio chaꞌ na caquichꞌulaj ta quib chwach ri Dios y jecꞌulaꞌ utz caquitij ri cena re Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","E uwariꞌche, ri takanel Pilato xel lok chaꞌ cachꞌaꞌt cucꞌ y xubiꞌij chique: —¿Saꞌ rumac waꞌchi cacoj alak? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Raj judiꞌab xquicꞌul uwach: —We tamaji aj mac, na cakaya ta riꞌ pakꞌab la —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ecꞌu ri Pilato xubiꞌij chique: —Cꞌama bi alak y kꞌata alak tzij puwiꞌ jelaꞌ pachaꞌ ri cubiꞌij ri tzijpixab e alak —xchaꞌ. Pero raj judiꞌab xquicꞌul uwach: —Riꞌoj oj aj judiꞌab na jinta pakakꞌab cakakꞌat tzij re camic puwi junok —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jelaꞌ e xuꞌana pachaꞌ rubiꞌim lo ri Jesús puwi rucamic. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ri Pilato xoc tanchi ubi chupa ri palacio, xusiqꞌuij ri Jesús y xutzꞌonoj che: —¿Lal cami riꞌ ri rey que raj judiꞌab? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri Jesús xubiꞌij che: —¿Xa pa e la caꞌan la wa tzꞌonobal chwe o cꞌo ebiꞌyom re cheꞌla? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ri Pilato xucꞌul uwach: —Na jinta we riꞌin che waꞌ, ma ¿in neba cuqꞌuil raj judiꞌab? Yey ri xeyaꞌw e la panukꞌab e ri winak re ri tinamit la cucꞌ ri nimak e aj chacunel pa Rocho Dios. ¿Saꞌ cꞌu ri mac ꞌanom la? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ecꞌu ri Jesús xucꞌul uwach: —Ri nutakanic riꞌin na re ta wara che ruwachulew. Ma we ta re wara, xechꞌoꞌjin ta cꞌu riꞌ ri nutijoꞌn chaꞌ na quinyaꞌ ta paquikꞌab raj judiꞌab. Noꞌj ri nutakanic na re ta wara che ruwachulew —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xubiꞌij cꞌu ri Pilato che: —¿Katzij cami riꞌ lal rey? —xchaꞌ. Ri Jesús xucꞌul uwach: —Lal cabiꞌn la re, riꞌin in rey. Riꞌin xinalax che ruwachulew yey xincꞌunic re cankꞌalajisaj ri Kꞌijsak. Janipa cꞌu ri quitakem ri Kꞌijsak, e caquita ri cambiꞌij riꞌin —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ri Pilato xubiꞌij che: —¿Saꞌ riꞌ laꞌ la Kꞌijsak? —xchaꞌ. Echiriꞌ uꞌanom chi wa tzꞌonobal, xel tanchi ubi ri Pilato, xchꞌaꞌt tanchi cucꞌ raj judiꞌab y xubiꞌij chique: —Riꞌin na canrik ta juna umac waꞌchi. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ralak lic xex caꞌan wi alak ri coyꞌej alak pa ri nimakꞌij Pascua canyolopij bi chiwach alak juna achi cꞌo pa cárcel. ¿Caꞌaj cami alak riꞌ e canyolopij bi ri rey que raj judiꞌab? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ecꞌuchiriꞌ, conoje xquijek quesiqꞌuin tanchic: —¡Mayolopij bi la ri Jesús! ¡E yolopij bi la ri Barrabás! —xechaꞌ. Yey ri Barrabás e jun achi elekꞌom. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ecꞌu ri Pilato xtakan che cacꞌam bi ri Jesús y cajichꞌ upa. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yey ri soldados xquicoj che rujolom ri Jesús jun corona quipachꞌum rucꞌ qꞌuix. Y xquirip jun manta morato chirij. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tecꞌuchiriꞌ xekib rucꞌ y caquibiꞌij: —¡Nim ukꞌij ri rey que raj judiꞌab! —quechaꞌ. Yey caquipachꞌ kꞌab chupalaj. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri Pilato xel tanchi ulok y xubiꞌij chique raj judiꞌab: —Chilape alak, canwesaj lo waꞌchi chiwach alak. Chetaꞌmaj cꞌu alak, riꞌin na jinta juna umac canriko —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ecꞌuchiriꞌ xel lo ri Jesús, cꞌo ri corona re qꞌuix che rujolom y ripom ri manta morato chirij. Xubiꞌij cꞌu ri Pilato chique: —¡Riꞌ rachi cꞌo chiwach alak! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Echiriꞌ ri nimak e aj chacunel pa Rocho Dios cucꞌ ri e chajinel re ri Rocho Dios xquil ri Jesús, xquijek quesiqꞌuinic, jewaꞌ caquibiꞌij: —¡Camisax chwa cruz! ¡Camisax chwa cruz! —quechaꞌ. Ecꞌu ri Pilato xubiꞌij chique: —We e riꞌ, cꞌama bi ralak y camisaj alak chwa cruz, pero riꞌin na jinta juna umac canriko —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Raj judiꞌab xquicꞌul uwach: —Riꞌoj cꞌo jun takanic pakawiꞌ y cubiꞌij cꞌu riꞌ takal che rire cacamisaxic ma uꞌanom Ucꞌajol Dios che rib —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Echiriꞌ ri Pilato xuta waꞌ, xoc más xiꞌin ib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xoc cꞌu tanchi ubi pa ri palacio y xutzꞌonoj che ri Jesús: —¿Pa lal petinak wi rilal? —xchaꞌ. Pero ri Jesús na xucꞌul ta uwach. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ri Pilato xubiꞌij cꞌu che: —¿E laꞌ na cacꞌul ta la uwach wa cantzꞌonoj cheꞌla? ¿Na etaꞌam ta cami la panukꞌab riꞌin cꞌo wi cancamisaj la chwa cruz y panukꞌab cꞌo wi canyolopij bi la? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri Jesús xucꞌul uwach: —Pakatzij wi cambiꞌij cheꞌla, na jinta cꞌana pakꞌab la catakan la panuwiꞌ we tamaji e ri Dios chilaꞌ chicaj xyaꞌw cheꞌla. E uwariꞌche, china ri xinkꞌatisan pakꞌab la, e más cꞌo umac riꞌ, chiwach rilal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chwi cꞌu riꞌ, ri Pilato lic xutzucuj suꞌanic cuyolopij bi ri Jesús. Pero raj judiꞌab co quesiqꞌuin che ubiꞌxic: —¡We xyolopij bi la, na lal ta chi ramigo riꞌ ri nimalaj takanel re Roma; ma china ri cuꞌan rey che rib, riꞌ e tzel caril wa nimalaj takanel! —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Echiriꞌ xuta waꞌ ri Pilato, xutak bi resaxic ri Jesús y xtzꞌuyiꞌ pa ri luwar re kꞌatbal tzij “Tzꞌakom Abaj” quecha che, yey pa ri chꞌaꞌtem hebreo “Gabatá” rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","E kꞌij riꞌ cayijbax pan janipa ri cajawax pa ri nimakꞌij Pascua. Ecꞌuchiriꞌ xuꞌan tiqꞌuil kꞌij, ri Pilato xubiꞌij chique raj judiꞌab: —Riꞌ ri rey e alak —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Noꞌj raj judiꞌab co quesiqꞌuin che ubiꞌxic: —¡Camisax chwa cruz! ¡Camisax chwa cruz! —quechaꞌ. Ri Pilato xubiꞌij chique: —¿Cancamisaj cami riꞌ chwa cruz ri rey e alak? —xchaꞌ. Pero ri nimak e aj chacunel re ri Rocho Dios xquicꞌul uwach: —Riꞌoj na jinta juna chic karey, xew e karey ri nimalaj takanel re Roma —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ecꞌu ri Pilato xuya bi ri Jesús paquikꞌab re cacamisax chwa cruz. Ewi xcꞌam bi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ri Jesús utelem bi rucruz echiriꞌ xcꞌam bi pa ri luwar cabiꞌx che “Luwar re Ubakil Ujolom Animaꞌ”, yey pa ri chꞌaꞌtem hebreo, “Gólgota”. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chiriꞌ cꞌu riꞌ xyaꞌ wi ri Jesús chwa ri cruz junam cucꞌ queb chic achijab, jun pa tak utzal; y xcꞌojiꞌ cꞌu Rire chiquinicꞌajal. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri Pilato utakom chic catzꞌibax waꞌ y cayaꞌ cꞌu lo chwi ri cruz: «JESÚS RI AJ NAZARET, RI REY QUE RAJ JUDIꞌAB.» ");
INSERT INTO acrTNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yey waꞌ tzꞌibital pa ri chꞌaꞌtem hebreo, pa ri chꞌaꞌtem griego y pa ri chꞌaꞌtem latín. E qꞌui cꞌu chique raj judiꞌab xcajilaj waꞌ, ma ri luwar pa xyaꞌ wi ri Jesús chwa ri cruz xa nakaj cꞌo wi che ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yey ri nimak e aj chacunel re ri Rocho Dios xquibiꞌij che ri Pilato: —Na ube taj xtzꞌibaj la “Ri rey que raj judiꞌab”. Jalcꞌatij la chaꞌ jewaꞌ cubiꞌij: “Rire xubiꞌij: Riꞌin in rey que raj judiꞌab” —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero ri Pilato xubiꞌij chique: —Ri xintak utzꞌibaxic riꞌin, jelaꞌ cacanaj canok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ri soldados echiriꞌ quiyaꞌom chi ri Jesús chwa ri cruz, xquimol uchiꞌ rukꞌuꞌ, xquijach upa chaꞌ cuꞌan cajib rajaw. Jelaꞌ xcaj caquiꞌan rucꞌ rucoton; pero waꞌ xa jun upa uꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ruma cꞌu waꞌ, ri soldados jewaꞌ xquibiꞌij chiquiwach: —Makarichꞌij upa rucoton; kaꞌana jun sorteo chaꞌ jelaꞌ cakilo chinok chike cacꞌamaw bi re —xechaꞌ. Ecꞌu xuꞌana pachaꞌ ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios: Xquijach quib puwi ri nukꞌuꞌ, ma xquiꞌan sorteo rucꞌ cachaꞌ. Yey jecꞌuriꞌlaꞌ xquiꞌan ri soldados. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chunakaj cꞌu ri cruz e cꞌo ruchu ri Jesús, ruchakꞌ ruchu, ri María rixokil ri Cleofas y ri María ri aj Magdala. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Echiriꞌ ri Jesús xril pan ruchu cꞌo putzal ri jun utijoꞌn lic cꞌax cunaꞌ Rire, xubiꞌij cꞌu pan che ruchu: —Nuchu, chwi cꞌu woꞌora e alab la laꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tecꞌuchiriꞌ xubiꞌij che ri jun utijoꞌn cꞌo putzal ri María: —Ecꞌu riꞌat, chwi woꞌora e achu laꞌ —xchaꞌ. Chwi cꞌu riꞌ, wa jun utijoꞌn ri Jesús xucꞌam bi ri María chaꞌ queꞌjekela chirocho. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ecꞌu ri Jesús retaꞌam ya xuqꞌuis uꞌanic ronoje ruchac; yey chaꞌ e cuꞌana janipa ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios, jewaꞌ xubiꞌij: —Catzajin nuchiꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chiriꞌ cꞌo jun xaro nojinak che vinagre. Yey e cꞌo jujun xquichukꞌ jun esponja chupa, xquixim cꞌu chutzaꞌm jun vara re hisopo y xquiya pan chwa reꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Rire xutij ri vinagre, tecꞌuchiriꞌ xubiꞌij: —Xinqꞌuis cꞌu utzaꞌm ri nuchac —xchaꞌ. Ecꞌuchiriꞌ, xuyuxubaꞌ rujolom y xukꞌatisaj ri ranimaꞌ pukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ecꞌu kꞌij riꞌ cayijbax pan janipa ri cajawax pa ri nimakꞌij Pascua. Ruma cꞌu laꞌ, raj judiꞌab na cacaj taj cacꞌojiꞌ juna caminak chwa cruz pa ri kꞌij re uxlanibal, ma laꞌ la jun kꞌij lic nimalaj nimakꞌij. E uwariꞌche xquitzꞌonoj che ri Pilato cutak ukꞌepic ri cakan ri e cꞌo chwa cruz chaꞌ jelaꞌ quecam tan y quekasax cꞌu ulok. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xebec cꞌu ri soldados y xeꞌquikꞌepa ri cakan ri e cꞌo chwa cruz pa tak utzal ri Jesús. Xquiꞌan cꞌu riꞌ che ri nabe, tecꞌuchiriꞌ jelaꞌ xquiꞌan che ri jun chic. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero echiriꞌ xekib rucꞌ ri Jesús, xquilo caminak chic; ruma riꞌ, na xquikꞌep ta ri rakan. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Na rucꞌ ta cꞌu riꞌ, jun chique ri soldados xutokꞌ rucꞌalcꞌaꞌx ri Jesús rucꞌ rulanza y cꞌatetana chupa waꞌ xel lo quicꞌ y yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri catzijon re ronoje waꞌ e xilow re; lic katzij cꞌu ri cubiꞌij ma lic retaꞌam saꞌ ri xrilo. Yey cutzijoj cꞌu riꞌ chaꞌ cacubiꞌ cꞌuꞌx alak rucꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma ronoje tak waꞌ xuꞌano chaꞌ e cuꞌana janipa ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios, ma jewaꞌ cubiꞌij: Na cakꞌep tane junok che rubakil. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yey jewaꞌ cubiꞌij Ruchꞌaꞌtem ri Dios: Caquil na cꞌu uwach ri jun xquitokꞌ rucꞌalcꞌaꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Qꞌuisbal re tak waꞌ, ri José aj Arimatea xuꞌtzꞌonoj che ri Pilato chaꞌ cayaꞌ che cucꞌam bi rucuerpo ri Jesús. Yey ri José e jun chique rutijoꞌn ri Jesús tob xa xeꞌlakꞌay, ma cuxiꞌij rib chiquiwach ri rach e aj judiꞌab. Ecꞌu ri Pilato xuya bi che, y ri José xucꞌam bi rucuerpo ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ecꞌu ri Nicodemo, ri jun achi xeꞌchꞌaꞌta rucꞌ ri Jesús chakꞌab, xopon che utoꞌic ri José. Rucꞌaꞌam laj jun quintal cunabal lic quiꞌ ruxlab, waꞌ mirra uyijbam rucꞌ áloes. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xquicꞌam cꞌu bi rucuerpo ri Jesús y xquibolkꞌotij pa jutak rabaꞌj cꞌul cojotal ri cunabal che, ma waꞌ lic xex caquiꞌan wi raj judiꞌab che quimukic ri quecamic. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Xa nakaj che ri luwar pa xquicamisaj wi ri Jesús chwa ri cruz, cꞌo jun luwar cꞌo chomilaj cheꞌ chwach. Y chiriꞌ cꞌo jun mukubal cꞌacꞌ ꞌanom, y na jinta junok mukum chupa. ");
INSERT INTO acrTNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chiriꞌ cꞌu riꞌ xquimuk wi rucuerpo ri Jesús, ma ri mukubal xa nakaj cꞌo wi; yey xcaj camukiꞌ ri cuerpo pa ri kꞌij echiriꞌ raj judiꞌab caquiyijbaꞌ pan janipa ri cajawax chique pa ri nimakꞌij Pascua, ma na utz taj caꞌan mukunic pa ri nimakꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ri nabe kꞌij che ri semana, ri María ri aj Magdala lic anim tan, cꞌa kꞌekuꞌm nenareꞌ, xeꞌec pa mukutal wi ri Jesús. Y cꞌate xrilo esam chi rabaj chuchiꞌ ri mukubal. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ecꞌuchiriꞌ, cacꞌalalic xeꞌec pa e cꞌo wi ri Simón Pedro y ri jun chic tijoꞌn lic cꞌax canaꞌ ruma ri Jesús, y xubiꞌij cꞌu chique: —Ri Kajawal xesax bi pa mukutal wi y na ketaꞌam taj pa xyaꞌiꞌ wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Xebel cꞌu bi ri Pedro y ri jun chic tijoꞌn, y xebec pa xmukiꞌ wi ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Quicabichal quecꞌalalic xebec; pero ri jun chic tijoꞌn más xcꞌalal chwa ri Pedro y nabe xoponic. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xyuxiꞌ pan chupa ri mukubal y xew xril ri jutak rabaꞌj cꞌul pa xbolkꞌotix wi ri Jesús, pero na xoc tubi. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tecꞌuchiriꞌ xopon ri Simón Pedro, ri teran lo chirij. Ecꞌu rire asu xoc chupa ri mukubal y xril ri jutak rabaꞌj cꞌul cꞌo can chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yey ri cꞌul pa xpis wi rujolom ri Jesús, na junam ta cꞌo rucꞌ ri jutak rabaꞌj cꞌul; ma utuquel cꞌolic, busum canok. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ecꞌuchiriꞌ, xoc bi ri jun chic tijoꞌn ri xopon nabe chwach ri mukubal. Xew xril cꞌu riꞌ waꞌ, xucojo cꞌastajinak chubi ri Jesús chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma ri petinak lok rique cꞌamajaꞌ ne quimajom usucꞌ Ruchꞌaꞌtem ri Dios pa cubiꞌij wi: Ri Jesús lic chirajawaxic cacꞌastaj bi chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Y xetzelej cꞌu ri queb tijoꞌn pa e cꞌo wi ri cachbiꞌil. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero ri María cokꞌic tacꞌal can chunakaj ri mukubal. Ecꞌu laꞌ cokꞌic, xyuxiꞌ apanok y xtzuꞌn pan chupa ri mukubal. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Xeril cꞌu pan queb ángeles sak quikꞌuꞌ etzꞌul jun chuꞌjolom y jun chi rakan che ri luwar pa xyaꞌiꞌ wi rucuerpo ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ecꞌu ri ángeles xquitzꞌonoj che ri María: —Ixok, ¿suꞌchac catokꞌic? —xechaꞌ. Ri María xucꞌul uwach: —Ma xcꞌam bi ri Wajawal y na wetaꞌam taj pa xyaꞌiꞌ wi —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tecꞌuchiriꞌ, xtzuꞌn chirij. Cꞌate xrilo tacꞌal ri Jesús chiriꞌ, pero rire na xretaꞌmaj taj we e ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ecꞌu ri Jesús xutzꞌonoj che ri María: —Ixok, ¿suꞌchac catokꞌic? ¿China ri catzucuj? —xchaꞌ. Ri María xuchꞌobo wa jun achi laj e chajinel re ri werta, y jewaꞌ cꞌu xubiꞌij che: —Achi, we lal xcꞌamaw bi la re, biꞌij la chwe pa xeꞌyaꞌa wi la chaꞌ quiꞌncꞌamaꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ecꞌu ri Jesús xubiꞌij che: —¡María! —xchaꞌ. Ri María xutzuꞌ uwach y jewaꞌ xubiꞌij che: —¡Raboni! (Wa chꞌaꞌtem pa hebreo queꞌelawi: “Lal tijonel”.) ");
INSERT INTO acrTNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ri Jesús xubiꞌij che: —Chinatzokopij, ma cꞌamajaꞌ quinakꞌan rucꞌ ri Nukaw. Jat y chabiꞌij chique conoje ri nu hermanos: Riꞌin quinakꞌan pa cꞌo wi ri Nukaw yey Ikaw riꞌix; ri nu Dios riꞌin yey i Dios riꞌix —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Xeꞌec cꞌu ri María ri aj Magdala cucꞌ rutijoꞌn ri Jesús y xuꞌtzijoj chique xril uwach ri Kanimajawal. Yey xutzijoj chique janipa ri xbiꞌx bi che ruma ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Che cꞌu ri rocbal rakꞌab che ri nabe kꞌij re ri semana, rutijoꞌn ri Jesús quimolom quib, quitzꞌapim quichiꞌ ruma quixiꞌim quib chiquiwach ri e aj wach que raj judiꞌab. Ecꞌuchiriꞌ, ri Jesús xakicꞌateꞌt xwinakiric y xtaqꞌuiꞌ chiquixoꞌl rutijoꞌn. Xuya cꞌu rutzil quiwach, jewaꞌ xubiꞌij chique: —Cꞌola utzil chomal iwucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tecꞌuchiriꞌ, xucꞌut rukꞌab y rucꞌalcꞌaꞌx chiquiwach. Ecꞌu rique lic xequiꞌcotic echiriꞌ xquil uwach ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ecꞌu ri Jesús xubiꞌij tanchi chique: —Cꞌola utzil chomal iwucꞌ. Jelaꞌ pachaꞌ ri Nukaw xinutak lo riꞌin, jecꞌuriꞌlaꞌ riꞌin quixintak bi riꞌix —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ecꞌuchiriꞌ, xuxutꞌuj quiwiꞌ y xubiꞌij chique: —Chicꞌulu ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","We cꞌo junok cutzelej utzij chwach ri Dios, yaꞌtal pikꞌab quikꞌalajisaj che: “Ri Dios ucuyum chi amac.” Yey we cꞌo junok na cutzelej ta utzij chwach ri Dios, yaꞌtal pikꞌab quikꞌalajisaj che: “At tanal rucꞌ ramac chwach ri Dios” —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ri Tomás ri cabiꞌx “yoꞌx” che, e jun chique ri cablajuj utijoꞌn ri Jesús. Rire na jintaj echiriꞌ xopon ri Jesús cucꞌ rique. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ecꞌu ri jujun chic tijoꞌn echiriꞌ xquil uwach ri Tomás, jewaꞌ xquibiꞌij che: —¡Riꞌoj xkil uwach ri Kanimajawal! —xechaꞌ. Pero ri Tomás jewaꞌ xubiꞌij chique: —Riꞌin xew cancojo we nabe na canwil rutel ri clawux pukꞌab y canjuꞌ ruwi nukꞌab chupa yey canjuꞌ ri nukꞌab pucꞌalcꞌaꞌx. Noꞌj we na canꞌan ta waꞌ, riꞌ na cancoj taj —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Icꞌowinak chi cꞌu wajxakib kꞌij, ri tijoꞌn quimolom tanchi quib chupa ri ja y cꞌo ri Tomás cucꞌ. Tob quitzꞌapim cꞌu quichiꞌ, ri Jesús xakicꞌateꞌt xwinakiric y xtaqꞌuiꞌ chiquixoꞌl. Ewi xuya rutzil quiwach, jewaꞌ xubiꞌij: —Cꞌola utzil chomal iwucꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tecꞌuchiriꞌ, xubiꞌij che ri Tomás: —Chawila ri nukꞌab y chajuꞌu ruwi akꞌab wara, yey chajuꞌu pe lo laꞌkꞌab pa wa nucꞌalcꞌaꞌx. Muꞌan cꞌu ri xa queb acꞌuꞌx wucꞌ; e chacojoꞌ riꞌin in cꞌaslic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ecꞌuchiriꞌ, ri Tomás xubiꞌij che ri Jesús: —¡Lal Wajawal y Lal nu Dios! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yey ri Jesús xubiꞌij che: —Tomás, cꞌa e laꞌ xacojo ruma xawil na nuwach. Nim cꞌu quikꞌij calaxic ri na quilom ta nuwach yey na rucꞌ ta cꞌu riꞌ, caquicojo riꞌin in cꞌaslic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús xuꞌan uqꞌuiyal cꞌutubal re ruchukꞌab ri Dios chiquiwach rutijoꞌn, y waꞌ na ronoje taj tzꞌibital chupa wa libro. ");
INSERT INTO acrTNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero janipa cꞌu wa xtzꞌibaxic, e chaꞌ cacoj alak ri Jesús e ri Cristo, Rucꞌajol ri Dios, y cꞌo cꞌu cꞌaslemal alak riꞌ ruma cacoj alak rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tecꞌuchiriꞌ ri Jesús xucꞌut tanchi rib chiquiwach rutijoꞌn chuchiꞌ ri mar re Tiberias. Jewaꞌ xuꞌano: ");
INSERT INTO acrTNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Junam e cꞌo ri Simón Pedro, ri Tomás ri caquibiꞌij “Yoꞌx” che, ri Natanael ri aj Caná re Galilea, ri queb ucꞌajol ri Zebedeo y caꞌib chic chique rutijoꞌn ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ecꞌu ri Simón Pedro xubiꞌij chique: —Quinꞌec pa chapoj car —xchaꞌ. Rique xquibiꞌij che: —Cojꞌec riꞌ awucꞌ —xechaꞌ. Xebec cꞌut y xeboc bi chupa jun barco, pero laꞌ laꞌkꞌab wi na jinta cꞌana car xquichapo. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Echiriꞌ catajin usakiric, rutijoꞌn xquil jun achi tacꞌal chuchiꞌ ri mar, pero na xquetaꞌmaj taj we e ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xubiꞌij cꞌu ri Jesús chique: —Ix walcꞌoꞌal, ¿na jinta car ichapom? —xchaꞌ. Rique xquicꞌul pan uwach: —Na jintaj —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xubiꞌij cꞌu ri Jesús chique: —Chiliqꞌuij liꞌatarraya puwiquikꞌab ri barco y chiwilapeꞌ ma quebiwesaj lo car —xchaꞌ. Rique e xquiꞌano yey na caquichꞌij ta chi cꞌu lo resaxic riꞌ ri qui atarraya pa ri yaꞌ ruma ruqꞌuiyal car e cꞌo chupa. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ecꞌu ri jun tijoꞌn lic cꞌax canaꞌ ruma ri Jesús, xubiꞌij che ri Pedro: —¡E Kanimajawal! —xchaꞌ. Ri Simón Pedro xew xuto e ri Jesús, xucojolaꞌ rukꞌuꞌ resam y xucꞌak bi rib pa ri yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yey ri jujun chic tijoꞌn xecꞌun rucꞌ ri barco chuchiꞌ ri mar, quicharem ri qui atarraya nojinak che car, ma laj xa cien metros e cꞌo wi che ruchiꞌ ri yaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Echiriꞌ xekaj lo chuꞌlew, cꞌate xquilo nucꞌutal jun akꞌ, y puwi ri rachakꞌaꞌl cꞌo jun car y cꞌo pam chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Xubiꞌij cꞌu ri Jesús chique: —Chicꞌama lo jujun chique ri car, ri cꞌa e laꞌ xebichap lok —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro xoc pa ri barco y xucharej bi cꞌa chuchiꞌ ri mar ri atarraya nojinak che nimak tak car, ma e ciento cincuenta y tres ri car e cꞌo chupa. Tob lic e qꞌui ri car, na xrakaroꞌb ta ri atarraya. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ecꞌuchiriꞌ, xubiꞌij ri Jesús: —Chixpetok, chixwoꞌkok —xcha chique. Na jinta cꞌu junok chique rutijoꞌn xraj cutzꞌonoj che china Rire, ma quetaꞌam e ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ecꞌuchiriꞌ, ri Jesús xucꞌam ri pam y xuya chique, y jelaꞌ xuꞌan rucꞌ ri car. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E urox laj waꞌ xucꞌut uwach ri Jesús chiquiwach rutijoꞌn chwi lo rucꞌastajibal chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Echiriꞌ xquiqꞌuis utijic ri quiwa, ri Jesús xutzꞌonoj che ri Simón Pedro: —Simón, at ucꞌajol ri Jonás, ¿más nawi cꞌax quinanaꞌ riꞌat chwa ri cꞌaxnaꞌbal we caquiꞌan wa jujun chic? —xchaꞌ. Ri Pedro xucꞌul uwach: —Wajawal, rilal etaꞌam la cꞌo rutzil nucꞌuꞌx cheꞌla —xchaꞌ. Ri Jesús xubiꞌij che: —Chebatzuku cꞌu riꞌ ri raltak co nubexex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Xutzꞌonoj chucalaj: —Simón, at ucꞌajol ri Jonás, ¿lic cꞌax quinanaꞌ rucꞌ ronoje acꞌuꞌx? —xchaꞌ. Ri Pedro xucꞌul uwach: —Wajawal, rilal etaꞌam la cꞌo rutzil nucꞌuꞌx cheꞌla —xchaꞌ. Xubiꞌij tanchi cꞌu ri Jesús che: —Chebachajij cꞌu riꞌ ri nubexex —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Xutzꞌonoj churox laj: —Simón, at ucꞌajol ri Jonás, ¿katzij cꞌo rutzil acꞌuꞌx chwe? —xchaꞌ. Ri Pedro lic xuchap bis ruma e urox laj riꞌ xtzꞌonox che. Xubiꞌij cꞌu riꞌ: —Wajawal, rilal etaꞌam la ronoje, etaꞌam cꞌu la riꞌin cꞌo rutzil nucꞌuꞌx cheꞌla —xcha che. Xubiꞌij cꞌu ri Jesús che: —Chebatzuku cꞌu riꞌ ri nubexex. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Pakatzij wi cambiꞌij chawe: Echiriꞌ at ala, riꞌat atuquel caxim rapas y cateꞌec pa cawaj wi cateꞌec. Noꞌj echiriꞌ catuꞌana nimalaj winak, cayac laꞌkꞌab y jun chic caximow rapas y catucꞌam bi pa na cawaj ta wi cateꞌec —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri Jesús xubiꞌij waꞌ chaꞌ cukꞌalajisaj saꞌ rucamic ri Pedro caꞌanic re yacbal ukꞌij ri Dios. Tecꞌuchiriꞌ, xubiꞌij che: —¡Chat-tereja lo chwij! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Echiriꞌ xtzuꞌn ri Pedro chirij, xrilo chiquij teran lo ri jun tijoꞌn lic cꞌax canaꞌ ruma ri Jesús, waꞌ e ri xjaꞌiꞌ putzal ri Jesús pa ri jun waꞌim echiriꞌ xutzꞌonoj che: «Wajawal, ¿China ri cacꞌayin e la?» ");
INSERT INTO acrTNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ecꞌu ri Pedro echiriꞌ xril ri jun chic tijoꞌn, xutzꞌonoj che ri Jesús: —Wajawal, yey rire, ¿saꞌ ri cucꞌulumaj? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ri Jesús xucꞌul uwach: —¿Suꞌchac catzꞌonoj? We cuaj riꞌin cꞌa cꞌas rire echiriꞌ quincꞌun tanchic, na jinta awe che. Riꞌat chat-tereja lo chwij —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ruma cꞌu wa xubiꞌij ri Jesús, xeꞌec utzijoxic chiquixoꞌl ri quicojom rubiꞌ ri Cristo: «Laꞌ la jun utijoꞌn na cacam taj.» Pero ri Jesús na xubiꞌij ta che we na cacam taj, ma xew xubiꞌij waꞌ: «¿Suꞌchac catzꞌonoj? We cuaj riꞌin cꞌa cꞌas rire echiriꞌ quincꞌun tanchic, na jinta awe che.» ");
INSERT INTO acrTNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ecꞌu waꞌ wa jun tijoꞌn e ri cajiquiban uwach tak waꞌ y e xtzꞌiban waꞌ. Yey riꞌoj ketaꞌam cꞌut lic katzij ronoje wa tzꞌibitalic. ");
INSERT INTO acrTNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lic cꞌo uqꞌuiyal chac xuꞌan ri Jesús tob na ronoje ta waꞌ tzꞌibital can chupa wa libro. Yey we ta e laꞌ catzꞌibax ronoje tak ri xuꞌano, riꞌin canchꞌob rakan na coc tane che ruwachulew tak ri wuj pa catzꞌibax wi. Amén. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chupa ri nabe nulibro, xintzꞌibaj pan che rilal Teófilo, puwi tak ri xuꞌan ri Jesús y tak ri xucꞌutu chwi lo ri jekebal re ruchac ");
INSERT INTO acrTNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","cꞌa chupa ri kꞌij echiriꞌ xcꞌul chilaꞌ chicaj ruma ri Dios. Chwach cꞌu pan riꞌ rubenam chilaꞌ chicaj, Rire ruma ri Santowilaj Ruxlabixel ri Dios xuya can takanic chique rutakoꞌn ebuchaꞌom puwi tak ri chirajawaxic caquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chwi cꞌu rucamic, xcꞌastaj lo chiquixoꞌl ri ecaminak y cꞌa xcꞌojiꞌ cuarenta kꞌij che ruwachulew. Chupa tak cꞌu laꞌ la kꞌij, uqꞌuiyal laj e laꞌ xucꞌut uwach chiquiwach rutakoꞌn y xchꞌaꞌt cucꞌ puwi ri takanic re ri Dios. Jecꞌulaꞌ riꞌ, lic xucꞌutu pakatzij wi Rire cꞌaslic. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Echiriꞌ ri Jesús e laꞌ cꞌa cꞌo cucꞌ rutakoꞌn, xubiꞌij chique: —Chixcꞌola Jerusalem chaꞌ quiwoyꞌej rubiꞌtisinic ri Nukaw, ri nutzijom chi lo riꞌin chiwe; waꞌ e ri bautismo re ri Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Pakatzij wi ri Juan xuya ri bautismo rucꞌ yaꞌ; noꞌj ri bautismo quicꞌul riꞌix e rucꞌ ri Santowilaj Ruxlabixel ri Dios; yey waꞌ cuꞌana xa chupa tak waꞌ wa kꞌij catajin lok —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jun kꞌij cꞌut ri quimolom quib rucꞌ ri Jesús jewaꞌ xquitzꞌonoj che: —Kajawal, ¿chupa tak waꞌ wa kꞌij oj cꞌo wi, cayac tanchi nawi la ri takanic re ri katinamit Israel jelaꞌ pachaꞌ ri uꞌanom lo ojertan? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Y ri Jesús xucꞌul uwach: —Riꞌix na yaꞌtal ta chiwe quiwetaꞌmaj rukꞌijol y ruꞌorayil echiriꞌ cuꞌana tak waꞌ ri Nukaw, ma ronoje waꞌ xew pukꞌab Rire cꞌo wi. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero quicꞌul cꞌu ichukꞌab riꞌix echiriꞌ cakaj lo ri Santowilaj Ruxlabixel ri Dios piwiꞌ y quixuꞌana cꞌu ix tzijol weꞌin chupa wa tinamit Jerusalem, chupa ronoje ri luwar re Judea y re Samaria y cꞌa che ronoje luwar re ruwachulew —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ecꞌuchiriꞌ xuqꞌuis ubiꞌxiquil tak waꞌ, xcꞌam bi chilaꞌ chicaj; y ecꞌu laꞌ caquitzutzaꞌ rutijoꞌn xsach bi chiquiwach chupa jun sutzꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Cꞌa caquitzutzaꞌ cꞌu pan chilaꞌ chicaj pa xcꞌam wubi ri Jesús, echiriꞌ xewinakir queb achijab cucꞌ yey waꞌ lic sak ri quikꞌuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Waꞌchijab xechꞌaw cꞌu chique, jewaꞌ xquibiꞌij: —Achijab ix aj Galilea, ¿suꞌbe cꞌa quixtzutzuꞌn chicaj? Ma wa Jesús, ri xel bi chixoꞌl riꞌix y xcꞌul chilaꞌ chicaj, Rire cacꞌun tanchic. Jecꞌulaꞌ pachaꞌ xiwilo xeꞌec, jelaꞌ cacꞌun tanchic —xecha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ecꞌuchiriꞌ, ri e takoꞌn xebel bi chwach ri juyub Olivos y xetzelej Jerusalem. (Wa juyub xa nakaj cꞌo wi lo che Jerusalem, laj jun kilómetro unajtijil; jecꞌulaꞌ rique na xicꞌow ta uwiꞌ ri caquibinibej che ri yaꞌtalic e chirij ri cojobal que raj judiꞌab puwi ri kꞌij re uxlanibal.) ");
INSERT INTO acrTNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Echiriꞌ xebopon Jerusalem, xebakꞌan chicaj pa ri caleꞌ ja pa ejekel wi ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo rucꞌajol ri Alfeo; ri Simón ri cabiꞌx “ri Zelote” che y ri Judas ruchakꞌ ri Jacobo. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","E conoje rique lic xa jun quicꞌuꞌx quiyaꞌom quib pa oración, junam cucꞌ jujun ixokib, rucꞌ ri María ruchu ri Jesús yey cucꞌ tak ruchakꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chupa cꞌu tak laꞌ la kꞌij, ri Pedro xtaqꞌuiꞌ chiquiwach ri hermanos quimolom quib, laj e ciento veinte chi conoje, y jecꞌuwaꞌ xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Hermanos, lic chirajawaxic wi e cuꞌana na ri tzꞌibital can chupa Ruchꞌaꞌtem ri Dios puwi ri xubiꞌij ri Santowilaj Ruxlabixel ruma ri David echiriꞌ xchꞌaꞌt puwi ri Judas aj Iscariot. Waꞌ e ri xnabej chiquiwach ri xechapaw bi ri Jesús, ");
INSERT INTO acrTNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","tob rire e jun kachbiꞌil y xyaꞌ che xchacun junam kucꞌ chupa wa chac re ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Xlokꞌ cꞌu juchꞌakap ulew rucꞌ ri puak xyaꞌ che ri Judas ruma ri na jusucꞌ taj xuꞌano echiriꞌ xucꞌayij ri Jesús. Ecꞌu ri Judas xuꞌxulubaꞌ lo rib chwi jun cheꞌ y echiriꞌ xtzak lok, xrakaroꞌb rupa y ronoje ri rixcolob xquich caꞌnic. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Waꞌ xquetaꞌmaj conoje ri ejekel Jerusalem. E uwariꞌche, xquicoj “Acéldama” che wa jun luwar; waꞌ queꞌelawi “Luwar re Quicꞌ” pa ri quichꞌaꞌtem rique.) ");
INSERT INTO acrTNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Xubiꞌij cꞌu ri Pedro: «Jecꞌuwaꞌ tzꞌibital can puwi ri Judas chupa ri libro re ri Salmos: Ri luwar pa jekel wi chuꞌana jun luwar catzꞌintzꞌotic, y na jinta junok cajekiꞌ chiriꞌ. Y jewaꞌ cubiꞌij tanchic: Lic chirajawaxic catzucux jun chic aj chac chaꞌ cacꞌojiꞌ pucꞌaxel cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","»E cꞌo cꞌu jujun achijab chikaxoꞌl xex ojcachbilam echiriꞌ cꞌa cꞌo ri Jesús kucꞌ, ");
INSERT INTO acrTNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","chwi lo echiriꞌ xucꞌul ri bautismo ruma ri Juan y cꞌa echiriꞌ xel bi kucꞌ y xcꞌul chilaꞌ chicaj ruma ri Dios. Lic chirajawaxic cꞌut cakacoj junok chique waꞌ waꞌchijab chaꞌ junam cojtzijon puwi rucꞌastajibal ri Jesús» xcha ri Pedro chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xequichaꞌ cꞌu caꞌib achijab. Jun e ri José, ri cabiꞌx Barsabás che y cojom jun retzelal ubiꞌ “Justo” quecha che. Ri jun chic, Matías rubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Y xquiꞌan orar, jewaꞌ xquibiꞌij: «Kajawal, Rilal etaꞌam la ri quicꞌuꞌx conoje ri ticawex. Cꞌutu cꞌu la chikawach chinok chique wa caꞌib achijab chaꞌom la ");
INSERT INTO acrTNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","chaꞌ cucꞌam bi wa chac y caꞌan takoꞌn la che; jecꞌulaꞌ cacꞌojiꞌ pucꞌaxel ri Judas aj Iscariot, ri xrokꞌotaj can ri chac xyaꞌ che y xeꞌec cꞌu pa ri luwar takal che» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ecꞌuchiriꞌ, xquiꞌan jun sorteo chaꞌ cakꞌalajinic china chique wa caꞌib cacanaj can pucꞌaxel ri Judas; y waꞌ xtzak puwi ri Matías. Chwi cꞌu riꞌ, rire xuꞌana e jun cucꞌ ri junlajuj chic e takoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Echiriꞌ xopon ri nimakꞌij re Pentecostés e tak rutijoꞌn ri Jesús quimolom quib, conoje uꞌanom xa jun quicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xakicꞌateꞌt cꞌut chilaꞌ chicaj xpe pachaꞌ uchꞌawibal juna unimal tew lic cajuxuxic, yey waꞌ xunojisaj ronoje upa ri ja pa quimolom wi quib. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ecꞌuchiriꞌ, xewinakir pachaꞌ urepebal akꞌ y waꞌ xcꞌojiꞌ paquiwiꞌ chiquijujunal rique. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yey conoje ri e cꞌo chiriꞌ xquicꞌul ruchukꞌab ri Santowilaj Ruxlabixel, y xquijek cꞌu riꞌ quechꞌaꞌt pa jujun chic chꞌaꞌtem junwi. Chiquijujunal quechꞌaꞌt pa ri chꞌaꞌtem xyaꞌtaj chique ruma ri Ruxlabixel. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chiriꞌ cꞌut Jerusalem e cꞌo e aj judiꞌab lic caquilokꞌnimaj ukꞌij ri Dios. Rique e petinak pa tak uqꞌuiyal tinamit che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Echiriꞌ xquita waꞌ wa chꞌawibal, xepe che rilic. Yey lic xsach quinaꞌoj ma chiquijujunal xequito quechꞌaꞌt pa tak ri quichꞌaꞌtem que rique. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ecꞌu laꞌ lic caminak canimaꞌ che, xquijek caquibiꞌij chiquiwach: «¡Chilape alak! ¿Na e ta neba aj Galilea conoje wa quechꞌaꞌtic? ");
INSERT INTO acrTNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chaꞌta cꞌu riꞌ chikajujunal quekato quechꞌaꞌt pa tak ri kachꞌaꞌtem oj alaxinak wi riꞌoj? ");
INSERT INTO acrTNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yey lic pa uqꞌuiyal tinamit oj petinak wi. Chikaxoꞌl e cꞌo e aj Partia, e aj Media y e aj Elam. Yey e cꞌo ri ejekel Mesopotamia, Judea, Capadocia, Ponto y Asia, ");
INSERT INTO acrTNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia y Panfilia, Egipto y pa tak ri luwar re Libia chwach pana ri tinamit Cirene. Yey e cꞌo ri e petinak Roma; chiquixoꞌl waꞌ e cꞌo e aj judiꞌab y e cꞌo ne ri na e ta aj judiꞌab quitakem lo ri cꞌutunic que raj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","E cꞌo e aj Creta y ri e aj Arabia. Yey chikajujunal riꞌoj cakato quechꞌaꞌt pa kachꞌaꞌtem puwi tak ri cꞌutubal re runimal uchukꞌab ri Dios» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Conoje cꞌut lic caminak canimaꞌ che y na caquirik ta chic saꞌ ri caquichꞌob puwiꞌ, jecꞌuwaꞌ caquibiꞌij chiquiwach: «¿Saꞌ queꞌelawi waꞌ?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yey e cꞌo cꞌu jujun chic quechꞌamin que y jewaꞌ caquibiꞌij: «Laꞌ quekꞌabaric» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ecꞌuchiriꞌ, ri Pedro xtaqꞌuiꞌic junam cucꞌ ri junlaluj chic takoꞌn y lic co xchꞌawic, jewaꞌ xubiꞌij: «Achijab alak aj judiꞌab y onoje ri alak jekel wara Jerusalem, tape alak chi utz ri cankꞌalajisaj che alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma e chiwach ralak, waꞌ waꞌchijab quekꞌabaric, noꞌj ¡na e ta uꞌanom riꞌ! Ma cꞌa e ne belejeb ora laꞌ che wa anim. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Janipa wa cata alak y quil alak woꞌora, waꞌ e ri ubiꞌim chi can ri kꞌalajisanel Joel ojertan, echiriꞌ jewaꞌ xubiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Che tak ruqꞌuisbal kꞌij” cubiꞌij ri Dios, “cantak bi ri Wuxlabixel paquiwi conoje ri ticawex che ruwachulew. E tak cꞌu ri miꞌal alcꞌoꞌal alak caquikꞌalajisaj ri Nutzij. Ralabo caquilo janipa ri cancꞌut chiquiwach; yey e ri nimak winak, pa wachicꞌ caquil wi janipa ri cankꞌalajisaj chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chupa tak cꞌu riꞌ laꞌ la kꞌij, paquiwi ri e waj chac ixokib y achijab cantak bi ri Wuxlabixel chaꞌ jelaꞌ caquikꞌalajisaj ri Nutzij chiquiwach ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chwa ri caj cancꞌut tak cꞌutubal re nuchukꞌab yey waꞌ na jinta ilitajinak wi y che ruwachulew canꞌan cꞌutubal rucꞌ quicꞌ, rucꞌ akꞌ y rucꞌ mayul re sib. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ecꞌu ri kꞌij cuꞌan kꞌekuꞌm uwach yey ri icꞌ cuꞌan cak uwach pachaꞌ quicꞌ; waꞌ e cuꞌana echiriꞌ ya copon rukꞌijol ri Kanimajawal. Waꞌ wa jun kꞌij lic nim y na jinta cꞌo cajunimax wi ruchomalil. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y conoje cꞌu ri caquicoj quib chwach ri Kanimajawal re quebucolobej, riꞌ quecolobetajic” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","»Achijab alak aj Israel, tape alak janipa wa cambiꞌij che alak woꞌora: Ri Jesús ri aj Nazaret, Rire e ri Jun takom lo chixoꞌl alak ruma ri Dios. Lic etaꞌam cꞌu alak ri xuꞌan ri Dios ruma ri Jesús chixoꞌl alak, waꞌ e uqꞌuiyal milagros y tak cꞌutubal re ri unimal uchukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yey ri Dios lic uchꞌobom chi ulok y retaꞌam suꞌchac xuya ri Jesús pakꞌab alak. Ecꞌu ralak xchap bi alak y xtak alak ucamisaxic chwa cruz cuma winak na jinta Rutzij Upixab ri Dios cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ri Dios xucꞌastajisaj lok y xresaj chupa rucꞌaxcꞌolil ri camic, ma ri camic na jinta uchukꞌab puwi Rire y ruma riꞌ, Rire na xcꞌojiꞌ ta pukꞌab ri camic. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","»Rojertan xubiꞌij can ri rey David puwi ri Cristo: Riꞌin canwil ri Wajawal xaki e laꞌ cꞌo chinuwach. Ruma cꞌu cꞌo Rire pa nuwiquikꞌab, na jinta cꞌana cayuchꞌuyuꞌn weꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","E uwariꞌche ri wanimaꞌ lic xquiꞌcotic y ruchiꞌ nukul xbixon rucꞌ quiꞌcotemal. Ecꞌu riꞌin, tob ne wetaꞌam quincamic, e laꞌ cꞌo chi ri nucubam pan nucꞌuꞌx che; ");
INSERT INTO acrTNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ma Rilal na quinya ta can la chiquixoꞌl ri ecaminak, yey na caya tane la luwar cakꞌay rucuerpo ri aj chac la, ri jun lic uyaꞌom rib pakꞌab la. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Rilal xcꞌut la chinuwach ri be re cꞌaslemal. Ruma cꞌu xaki Lal cꞌo la wucꞌ riꞌin, canojisaj la ri wanimaꞌ che quiꞌcotemal xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","»Hermanos, pakatzij wi lic usucꞌ cancuxtaj waꞌ che alak: Ri rey David ojertan, xcamic y xmukic, y cꞌa kꞌalaj ne chikawach riꞌoj wakꞌij ora pa cꞌo wi rumukubal. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yey ri rey David e jun kꞌalajisanel; xretaꞌmaj cꞌu riꞌ ri Dios rucꞌ jun tzij xujiquibaꞌ uwach che rire: “Chiquixoꞌl tak ri awalcꞌoꞌal, cayactaj lo ri Cristo chaꞌ cuꞌan Rey y catzꞌuyiꞌ pacꞌaxel riꞌat.” ");
INSERT INTO acrTNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","»Yey ri rey David xchꞌaꞌtic e pachaꞌ rilom chi rucꞌastajibal ri Cristo echiriꞌ xubiꞌij: “Na cacanaj ta can Rire chiquixoꞌl ri ecaminak y na cakꞌay tane rucuerpo.” ");
INSERT INTO acrTNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ecꞌu waꞌ wa Jesús ri xucꞌastajisaj ri Dios che ri camic; yey waꞌ lic katzij, ma konoje riꞌoj xkilo. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lic cꞌu xyac ukꞌij echiriꞌ xtzꞌuyiꞌ puwiquikꞌab ri Dios. Yey xyaꞌtaj che Rire cutak lo pakawi riꞌoj ri Santowilaj Ruxlabixel, ri ubiꞌtisim lo ri Kakaw Dios chike riꞌoj. Y ecꞌu riꞌ waꞌ ri quil alak y cata alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","»Ma na e ta ri David ri xakꞌan chilaꞌ chicaj, pero e rire ri xubiꞌij: Ri Dios Kajawxel xubiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwiquikꞌab, ");
INSERT INTO acrTNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","y chawoyeꞌej na ri kꞌij echiriꞌ quebenuya ri tzel quebilow awe chuxeꞌ rawakan” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","»Tape alak onoje ri alak aj Israel, ma lic chirajawaxic quetaꞌmaj cꞌu alak: Wa Jesús ri xcamisaj alak chwa cruz, e chaꞌtal lo ruma ri Dios re cuꞌan Kajawal y Colobenel» xcha ri Pedro chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ecꞌuchiriꞌ xquita waꞌ, lic xoc bis chiquicꞌuꞌx y jewaꞌ xquibiꞌij che ri Pedro y chique ri jujun chic e takoꞌn: —Hermanos, ¿saꞌ cꞌu riꞌ cakaꞌan riꞌoj? —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Y ri Pedro xubiꞌij chique: —Tzelej tzij alak chwach ri Dios y chijujunal alak cꞌulu alak pa rubiꞌ ri Kanimajawal Jesucristo ri bautismo re cuybal mac alak y jelaꞌ cacꞌul na cꞌu alak ri Santowilaj Uxlabixel, waꞌ e sipanic re ri Dios che alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ma ri Dios ubiꞌtisim waꞌ chique conoje janipa ri quebusiqꞌuij: che ralak, chique tak ri alcꞌoꞌal alak y chique ne conoje ri ejekel lic naj che ri tinamit re Israel —xcha ri Pedro chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jecꞌulaꞌ, xebupixabaj rucꞌ uqꞌuiyal chꞌaꞌtem y jewaꞌ xujiquibaꞌ uwach chique: —Chesaj lo ib alak chiquixoꞌl waꞌ wa winak lic na jusucꞌ ta ri quiꞌanom, chaꞌ jelaꞌ cacolobetaj alak chwach ri kꞌatbal tzij cape paquiwiꞌ —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Janipa cꞌu riꞌ ri xecojow Rutzij ri Dios ruma ri xubiꞌij ri Pedro, xquicꞌul ri bautismo. Yey chupa cꞌu laꞌ la jun kꞌij, laj e oxib mil ri xquicoj rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y conoje lic junam quebin chupa ri sakil cꞌutunic que ri e takoꞌn re ri Jesús, junam quicꞌuꞌx, junam quewaꞌ chiquiwach y junam caquiꞌan orar. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Conoje cꞌu ri ticawex xoc xiꞌin ib pa canimaꞌ ruma tak ri milagros y cꞌutubal cuꞌan ri Dios cuma ri e utakoꞌn ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Conoje cꞌu ri xecojow rubiꞌ ri Cristo, lic xuꞌan xa jun quicꞌuꞌx chiquiwach y rubitak que chiquijujunal xuꞌan re chinima ronoje. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","E cꞌo ri xquicꞌayij culew y ubitak que, yey ecꞌu ri rajil waꞌ, caquijach chiquiwach e chirij tak ri cajawax wi chique chiquijujunal. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ronoje kꞌij caquimol quib chupa ri Rocho Dios. Yey pa tak ri cocho caquijach chiquiwach ri caquitijo, junam quewaꞌ rucꞌ quiꞌcotemal y rucꞌ uchꞌutiꞌnal quicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Caquiyac cꞌu ukꞌij ri Dios y lic chom ri quichꞌaꞌtibexic caꞌan cuma conoje ri ticawex re ri tinamit. Yey ronoje kꞌij e cꞌo más ticawex catajin quicolobetajic ruma ri Kanimajawal, y jelaꞌ xqꞌuiyar riglesia. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Xuꞌana cꞌu chupa jun kꞌij, ri Pedro y ri Juan junam xebec pa ri Rocho Dios che ri urox ora benak kꞌij, ma e ora riꞌ re oración. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ronoje kꞌij cꞌut cacꞌam lo jun achi ralaxibem sic y cayaꞌ chwach ri Rocho Dios pa ri oquibal cabiꞌx che “Lic Chom” chaꞌ cutzꞌonoj ulimoxna chique ri winak queboc bi. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ecꞌu rachi sic, echiriꞌ xeril ri Pedro y ri Juan e riꞌ queboc bi chupa ri Rocho Dios, xujek quelaj chique chaꞌ caquiya can ulimoxna. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ecꞌu ri Pedro junam rucꞌ ri Juan lic xquichꞌiquibaꞌ ri quiwach puwi rachi, yey ri Pedro xubiꞌij che: —Chojtzuꞌu pe la —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ewi ri sic xebutzuꞌu ma royeꞌem we cꞌo caquiya che. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero ri Pedro xubiꞌij che: —Na jinta sakil puak wucꞌ y na jinta ne kꞌana puak wucꞌ; noꞌj cꞌu ri cꞌo wucꞌ canya cheꞌla. Chupa rubiꞌ ri Kanimajawal Jesucristo ri aj Nazaret, yactaj la y bina la —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ecꞌu ri Pedro xuchap che rukꞌab uwiquikꞌab, xuyaco y chupa laꞌ la jokꞌotaj xcowir ri rakan y rukul rakan. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y rachi xchꞌoplin chicaj, xtaqꞌuiꞌic y xujeko cabinic. Junam cꞌut cucꞌ ri Pedro y ri Juan, xoc bi pa ri Rocho Dios, cabinic, cachꞌoplanic y cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Conoje cꞌu ri winak re ri tinamit xquilo rachi cabinic y lic cuyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Y xquetaꞌmaj e achi catzꞌuyiꞌic y cutzꞌonoj ulimoxna chwach ri Rocho Dios pa ri oquibal cabiꞌx che “Lic Chom”. Lic cꞌu xcam canimaꞌ che ri xꞌaniꞌ che rachi y na xquimaj ta cꞌana usucꞌ chaꞌtaj xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Rachi xcunutajic na caresaj ta chi rib chiquij ri Pedro y ri Juan. Yey conoje ri winak caminak canimaꞌ che, xemoc caꞌn pa ri luwar cabiꞌx che “Ruchiꞌ Ja re Salomón”. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ecꞌuchiriꞌ xril waꞌ ri Pedro, xubiꞌij chique ri tinamit: «Achijab alak aj Israel, ¿suꞌchac lic caminak animaꞌ alak che wa xil alak? ¿Yey suꞌchac e cojtzutzaꞌ alak riꞌoj pachaꞌ oj ri xojbinisan re waꞌchi rucꞌ ri kachukꞌab o ruma lic oj jusucꞌ riꞌoj chwach ri Dios? Na e ta riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ma e ri Dios que ri kamam ojertan, waꞌ e ri Abraham, ri Isaac y ri Jacob, ecꞌu Rire ri lic xuyac ukꞌij ri Jesús ri Raj Chac Rire. Noꞌj ralak xya alak ri Jesús pukꞌab ri Pilato. Y na xew ta laꞌ, ma xcꞌak bi alak ukꞌij chwach ri Pilato y na xya ta alak luwar che rire cuyolopij bi ri Jesús echiriꞌ xraj cuyolopij bi ruma na jinta mac xurik che. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ecꞌu riꞌ ralak na xꞌaj ta alak cayolopix bi waꞌ wa Jun lic nim ukꞌij Santo y Jusucꞌ; ma e xtzꞌonoj alak cayolopix bi ri jun camisanel. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xcamisaj cꞌu alak riꞌ ri aj yaꞌl cꞌaslemal, ri Jun xcꞌastajisax lo chiquixoꞌl ri ecaminak ruma ri Dios. Puwi cꞌu riꞌ wa cꞌastajibal cojtzijon wi riꞌoj ma lic oj xojilow re. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","»E ruma ri cubulibal cꞌuꞌxaj rucꞌ ri Jesús, xcowir ri rakan waꞌ waꞌchi quil alak y etaꞌam ne alak uwach. Yey ruma wa cubulibal cꞌuꞌxaj rucꞌ ri Jesús xcunutaj waꞌchi pa sakil wi jelaꞌ pachaꞌ catajin onoje alak che rilic. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","»Wetaꞌam cꞌut, alak katz-kachakꞌ, ri xꞌan alak e ruma na xmaj ta alak usucꞌ, y jenelaꞌ riꞌ xquiꞌan raj wach re ri tinamit alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ruma ri xꞌan alak che ri Jesús, ri Dios xuꞌana janipa rubiꞌim lo ojertan cuma ri kꞌalajisanelab echiriꞌ xubiꞌij Ruchaꞌoꞌn lo Rire cutij cꞌax. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","»E uwariꞌche tzelej tzij alak chwach ri Dios y yaꞌa cꞌu ib alak pukꞌab chaꞌ cacuytaj ri mac alak y chaꞌ ri Kajawal Dios cuya uxlanem y utzil chomal chupa ri animaꞌ alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jecꞌulaꞌ ri Dios cutak na lo ucꞌ alak ri Jesús, Ruchaꞌoꞌn lo Rire, ri biꞌtisim chi lo che alak ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tob cꞌu woꞌora lic chirajawaxic wi ri Jesús cꞌo chilaꞌ chicaj, copon na ri kꞌij echiriꞌ ri Dios cuꞌan tanchi cꞌacꞌ che ronoje jelaꞌ pachaꞌ ri xubiꞌij lo ojertan cuma ri kꞌalajisanelab ri xetak lo ruma Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","»Ma ri Moisés xubiꞌij chique ri katiꞌ-kamam ojertan: E ri Dios Kajawxel cuyac na lo chiquixoꞌlibal ri katinamit Israel jun Kꞌalajisanel jelaꞌ pachaꞌ riꞌin. Ecꞌu chita janipa ri cubiꞌij Rire chiwe. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ecꞌu ri ticawex na cucoj ta utzij wa jun Kꞌalajisanel, riꞌ quesax bi y na jinta chi re cucꞌ rutinamit ri Dios xcha ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","»Conoje cꞌu ri kꞌalajisanelab quipetebem lo chwi ri Samuel, lic etzijoninak lo chwi tak waꞌ wa kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Alak cꞌu ri cacꞌuluw re ri xubiꞌtisij ri Dios cuma ri kꞌalajisanelab y ruma ri tzij xuꞌan cucꞌ ri katiꞌ-kamam ojertan, echiriꞌ xubiꞌij che ri Abraham: Ruma cꞌu Jun chique rawalcꞌoꞌal, quebenuꞌan bendecir conoje ruqꞌuiyal quiwach tak ri ticawex che ruwachulew xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","»Ecꞌu ri Dios, echiriꞌ xucꞌastajisaj lo ri Raj Chac chiquixoꞌl ri ecaminak, xutak lo nabe ucꞌ ralak re toꞌbel e alak chaꞌ jelaꞌ chijujunal alak cajalcꞌatitaj ri binic silabic alak che ri na utz taj» xcha ri Pedro chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Cꞌa quechꞌaꞌt ne ri Pedro y ri Juan cucꞌ ri winak, echiriꞌ xecꞌun lo raj chacunel re ri Rocho Dios, ri aj wach que ri e chajinel re ri Rocho Dios y jujun saduceos. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Rique lic cꞌo coyowal chiquij ri Pedro y ri Juan ma quecꞌutun chiquiwach ri ticawex puwi rucꞌastajibal lo ri Jesús chiquixoꞌl ri ecaminak, jecꞌuwaꞌ caquibiꞌij: «Rucꞌastajibal ri Jesús e cꞌutubal re, chikawach apanok ri ticawex quecꞌastaj lo chiquixoꞌl ri ecaminak» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ecꞌu ri e aj wach re ri Rocho Dios xetakan che quechap bi ri Pedro y ri Juan. Yey ruma cꞌu lic benak kꞌij chic, xebeꞌquiyaꞌa pa cárcel chaꞌ cataꞌ quichiꞌ cꞌa chucaꞌm kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero chique ri xetaw re ri xubiꞌij ri Pedro, lic e qꞌui ri xcubiꞌ quicꞌuꞌx rucꞌ ri Jesús; yey we quebajilax xew ri achijab, laj e woꞌob mil xecojow re Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chucaꞌm kꞌij cꞌut xquimol quib pa ri tinamit Jerusalem raj wach que raj judiꞌab cucꞌ ri nimak winak re ri tinamit y raj cꞌutunel re ri tzijpixab. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Cꞌo chiriꞌ ri Anás ri cajawal raj chacunel pa Rocho Dios; yey e cꞌo ri Caifás, ri Juan, ri Alejandro y jujun chic cꞌo chux chique ri cajawal raj chacunel pa Rocho Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xequiya cꞌu ri Pedro y ri Juan chiquinicꞌajal y xquitzꞌonoj chique: —¿China xyaꞌw pikꞌab o china pubiꞌ xiꞌan riꞌix waꞌ? —xecha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ecꞌu ri Pedro, rucꞌ ruchukꞌab ri Santowilaj Ruxlabixel ri Dios, xubiꞌij chique: —Tape alak, alak aj wach re ri tinamit y alak nimak winak re Israel, ");
INSERT INTO acrTNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma e wakꞌij cataꞌ kachiꞌ puwi ri utz xꞌan che wa jun achi yewaꞌ chaꞌ quetaꞌmaxic suꞌanic xcunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ecꞌu riꞌ woꞌora cakakꞌalajisaj chiwach onoje alak y chiquiwach conoje ri tinamit Israel: Waꞌ waꞌchi cꞌo chiwach alak xcunutaj chupa rubiꞌ ri Kanimajawal Jesucristo re Nazaret, ri xcamisaj alak chwa cruz yey ri Dios xucꞌastajisaj lo chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","»E pachaꞌ ri cubiꞌij Ruchꞌaꞌtem ri Dios: E rabaj cꞌakital can cuma raj yacal ja, e abaj waꞌ lic xajawaxic chaꞌ catiquiꞌ lo ri ja cachaꞌ. Ralak e alak pachaꞌ wa e aj yacal ja yey ri Jesús e ri Abaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xew cꞌu rucꞌ ri Jesús carikitaj colobetajic, ma na jinta chi juna biꞌaj che ruwachulew yaꞌtal lo chique ri ticawex chaꞌ ruma riꞌ cojcolobetajic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ecꞌu raj wach re ri tinamit xquilo ri Pedro y ri Juan na caquixiꞌij ta cꞌana quib quetzijon puwi ri Utzilaj Tzij, tob waꞌ waꞌchijab na e ta tijotal pachaꞌ rique yey xa ne e cuqꞌuil rachijab e aj chac re ri tinamit. Lic xcam cꞌu canimaꞌ riꞌ chique y xquimaj usucꞌ e janipa tak ri caquiꞌano y ri quimajom ri Pedro y ri Juan, e ruma ri xecꞌojiꞌ rucꞌ ri Jesús, ri quitijonel. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yey na utz tane cꞌu riꞌ caquibiꞌij na cunutajinak ta ri sic, ma waꞌ waꞌchi tacꞌal chiriꞌ chiquiwach cucꞌ ri Pedro y ri Juan. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ecꞌu ri xquiꞌano e xetakan che chaꞌ ri Pedro y ri Juan quebel bi jokꞌotaj pa ri luwar re ri kꞌatbal tzij, y xew cꞌu xecanaj raj kꞌatal tzij chaꞌ quechꞌaꞌt chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jecꞌuwaꞌ xquibiꞌij chiquiwach: «¿Saꞌ ri cakaꞌan chique waꞌchijab? Ma ri cꞌutubal re cunanic ꞌanatal cuma rique, lic kꞌalajininak chiquiwach conoje ri ejekel Jerusalem yey lic na utz taj cakewaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ri kaꞌanaꞌ e kaxibij quipa chaꞌ na quetzijon ta chi cꞌana chwach junok chupa rubiꞌ wa jun achi, y jelaꞌ na queꞌec ta chi utzijoxic waꞌ» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xequisiqꞌuij cꞌu ri Pedro y ri Juan y lic xequitak che na quetzijon taj y na quecꞌutun ta chi ne cꞌana pa rubiꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ri Pedro y ri Juan xquicꞌul uwach: —Chꞌobo pe ralak: ¿Usucꞌ nawi chwach ri Dios e cakacoj tzij ralak chwa ri cakacoj utzij Rire? ");
INSERT INTO acrTNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ma riꞌoj, na utz taj cakokꞌotaj ubiꞌxiquil janipa ri kilom y ri katom —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ecꞌu ri e aj wach lic xquixibij quipa. Tecꞌuchiriꞌ, xequiyolopij bi ma na xquirik taj suꞌanic quequiya pa cꞌaxcꞌobic ruma caquixiꞌij quib chiquiwach ri winak re ri tinamit. Ma conoje lic caquiyac ukꞌij ri Dios ruma ri xquilo. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yey lic kꞌalaj e rucꞌ ruchukꞌab ri Dios xꞌaniꞌ wi ri cꞌutubal re cunanic, ma waꞌchi xcunutajic, ralaxibem sic yey icꞌowinak chi pa cuarenta rujunab. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Echiriꞌ xeyolopix bi, ri Pedro y ri Juan xebec cucꞌ ri cachbiꞌil y xquitzijoj chique janipa ri biꞌtal bi chique cuma ri nimak e aj chacunel pa Rocho Dios y ri nimak winak re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Echiriꞌ rique xquita waꞌ, conoje xa jun quicꞌuꞌx xquijek caquiꞌan orar chwach ri Dios, jewaꞌ caquibiꞌij: «¡Lal Dios Kajawxel, Lal ꞌanayom la ruwa caj, ruwachulew, ri mar y ronoje ri cꞌo che tak waꞌ! ");
INSERT INTO acrTNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yey ruma ri David ri aj chac la, jewaꞌ xbiꞌij la ojertan: ¿Suꞌchac lic quetucuc tak ri winak yey tak ri tinamit xew caquinoꞌjij ri na jinta uchac? ");
INSERT INTO acrTNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ma xquimol quib ri takanelab y ri e aj wach che ruwachulew, xquiꞌan cꞌu xa jun che quib y xebec chirij ri Dios Kajawxel y chirij ri Cristo, Ruchaꞌoꞌn lo Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Waꞌ lic katzij, ma chupa wa tinamit oj cꞌo wi, ri Herodes rucꞌ ri Poncio Pilato xquimol quib cucꞌ ri winak e aj Israel y cucꞌ ri na e ta aj Israel; yey junam cꞌu xeyactaj chirij ri Jesús, ri Santowilaj Aj Chac la, ri Jun xchaꞌ lo la. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jecꞌulaꞌ, e xquiꞌano janipa ri chꞌobom lo la ojertan chaꞌ e cuꞌana na riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","»Ecꞌu woꞌora, Kakaw, quil la ri xibibal quipa raj chaquib la quiꞌanom; yaꞌa cꞌu la ri chukꞌab la chique rique chaꞌ na caquixiꞌij ta cꞌana quib caquitzijoj ri Chꞌaꞌtem la. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yaꞌa ri kꞌab la paquiwiꞌ chaꞌ chupa rubiꞌ ri Jesús, ri Santowilaj Aj Chac la, quecunutaj ri yewaꞌib y caꞌaniꞌ tak cꞌutubal re ri chukꞌab la» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Echiriꞌ xquiqꞌuis uꞌanic orar, ri luwar pa quimolom wi quib xbarbatic y conoje xquicꞌul ruchukꞌab ri Santowilaj Ruxlabixel ri Dios y jecꞌulaꞌ na caquixiꞌij ta cꞌana quib caquitzijoj Ruchꞌaꞌtem ri Dios chiquiwach conoje ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Conoje cꞌu ruqꞌuiyal hermanos, ri xquicoj rubiꞌ ri Cristo, lic uꞌanom xa jun canimaꞌ y xa jun quinaꞌoj; y na jinta junok chique cuꞌan re che ri cꞌo rucꞌ, ma rubitak que xuꞌan re chinima ronoje. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jecꞌulaꞌ riꞌ, ri e takoꞌn re ri Cristo rucꞌ unimal quichukꞌab quetzijon chwi rucꞌastajibal ri Kanimajawal Jesús, yey ri toꞌbal re ri Dios cꞌo paquiwi conoje rique. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na jinta cꞌu junok cutij nibaꞌil chiquixoꞌl, ma janipa ri cꞌo tak culew o cꞌo tak ja cucꞌ, we cꞌo xquicꞌayij, caquicꞌam lo ri rajil ");
INSERT INTO acrTNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y caquiya cꞌu paquikꞌab ri e takoꞌn re ri Jesús chaꞌ rique caquijach chiquiwach ri hermanos e chirij tak ri cajawax wi chique chiquijujunal. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Cꞌo cꞌu jun achi José rubiꞌ, yey ri e takoꞌn caquibiꞌij Bernabé che. (Waꞌ wa biꞌaj queꞌelawi “bochiꞌinel”.) Rire aj Chipre y e cuqꞌuil ri ralcꞌoꞌal can ri Leví. ");
INSERT INTO acrTNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Waꞌ waꞌchi xucꞌayij chꞌakap rulew; tecꞌuchiriꞌ, xucꞌam lo ri rajil y xuya paquikꞌab ri e takoꞌn. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Cꞌo cꞌu jun achi Ananías rubiꞌ, junam rucꞌ ri rixokil Safira xquicꞌayij chꞌakap ulew. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ecꞌu rachi cꞌo xresaj can che ri rajil rulew, yey junam rucꞌ ri rixokil xquiꞌan tzij chiquiwach chaꞌ caquiꞌan rakꞌubal puwi ri rajil rulew. Ecꞌu ri nicꞌaj chic che ri rajil xucꞌam bi, xuꞌyaꞌa paquikꞌab ri e takoꞌn y xubiꞌij waꞌ e rajil rulew. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ecꞌu ri Pedro xubiꞌij che: —Ananías, ¿suꞌchac xaya luwar che ri Satanás coc pa awanimaꞌ chaꞌ jelaꞌ caꞌan rakꞌubal chwach ri Santowilaj Ruxlabixel ri Dios? Ma xabiꞌij xaya ronoje ri rajil rulew, pero cꞌo xawesaj can che. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Echiriꞌ cꞌamajaꞌ cacꞌayij rawulew, ¿na aweꞌat ta neba laꞌ? Y echiriꞌ acꞌayim chic, ¿na pakꞌab ta neba cꞌo wi caꞌan rucꞌ ri rajil saꞌ ri cawaj? ¿Suꞌchac cꞌu riꞌ xaꞌan waꞌ? ¡Na chiquiwach ta cꞌu achijab aꞌanom wi rakꞌubal ma e chwach ri Dios! —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Xew cꞌu xuta waꞌ wa chꞌaꞌtem, ri Ananías xtzak pulew y asu xcamic. Ruma cꞌu waꞌ, xpe jun xiꞌin ib paquiwi conoje ri xebetaꞌman re. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xecꞌun cꞌu lo jujun alabo, xquipis rucuerpo, xquicꞌam bi y xeꞌquimukuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Laj oxib ora ricꞌowic waꞌ echiriꞌ xoc lo ri Safira ri rixokil ri Ananías; yey rire na retaꞌam ta cꞌu riꞌ saꞌ ri xucꞌulumaj ri rachijil. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ecꞌuchiriꞌ, xutzꞌonoj ri Pedro che: —Chabiꞌij chwe: ¿E rajil waꞌ rulew xicꞌayij? —xcha che. Rixok xucꞌul uwach che: —Areꞌ, e rajil laꞌ —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Xubiꞌij cꞌu ri Pedro che: —¿Suꞌchac xiꞌan tzij chiwach chaꞌ quicꞌam upa ri Ruxlabixel ri Dios Kajawxel? ¡Chawilaꞌ! Ralabo catajin lo coquic che ruchiꞌ ja, e laꞌ xetzelej lo che umukic rawachijil, yey ecꞌu woꞌora e catquicꞌam bi riꞌat —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na jampatana xtzak ri Safira chwach ri Pedro y asu xcamic. Ecꞌuchiriꞌ xeboc lo ralabo, xoꞌlquirikaꞌ caminak chic. Xquicꞌam cꞌu bi y xeꞌquimuku putzal ri rachijil. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y xoc cꞌu jun unimal xiꞌin ib cucꞌ conoje ri tinamit re ri Cristo y cucꞌ conoje ri xebetaꞌman re tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Cuma cꞌu ri e takoꞌn re ri Cristo, uqꞌuiyal cꞌutubal re ruchukꞌab ri Dios y nimak tak chac catajin rilic chiquiwach tak ri ticawex. Yey tak ri quicojom rubiꞌ ri Cristo, lic xa jun quicꞌuꞌx caquimol quib pa ri luwar cabiꞌx che “Ruchiꞌ Ja re Salomón”. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","E tak cꞌu ri cꞌamajaꞌ caquicoj rubiꞌ ri Cristo, caquixiꞌij quib caquijunimaj quib cucꞌ, tob conoje ri ticawex lic caquiyac quikꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Y catajin cꞌu quiqꞌuiyaric ri quicojom rubiꞌ ri Kanimajawal, waꞌ e uqꞌuiyal achijab y uqꞌuiyal ixokib. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ruma tak cꞌu ri cꞌutubal re ruchukꞌab ri Dios caquiꞌan rutakoꞌn ri Jesús, tak ri winak quequesaj tak ne lo ri e yewaꞌib pa tak ri be. Equiyaꞌom chwa chꞌat y chwa pop, chaꞌ we xicꞌow ri Pedro, tob xew luꞌmuꞌj catzak paquiwiꞌ, quecunutaj cꞌu riꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E qꞌui ne ri e petinak pa tak ri tinamit cꞌo lo chunakaj Jerusalem. Equicꞌamom lo ri yewaꞌib y ri echꞌuꞌjerinak cuma itzelilaj uxlabixel; y conoje cꞌut quecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ri cajawal raj chacunel pa Rocho Dios y conoje ri e cꞌo rucꞌ, waꞌ e ri saduceos, xujek catiꞌtot quicꞌuꞌx chiquij rutakoꞌn ri Jesús ruma lic e qꞌui ri winak eteran chiquij. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xequichap cꞌu bi rutakoꞌn ri Jesús y xebeꞌquiyaꞌa pa ri cárcel re ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xopon cꞌu jun ángel re ri Kanimajawal chakꞌab, xuꞌjaka tak ri oquibal re ri cárcel y xeberesaj lok. Ecꞌuchiriꞌ, xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Jix, jixeꞌtacꞌala pa ri Rocho Dios y chitzijoj chique ri winak re ri tinamit ronoje puwi ri cꞌacꞌ be re cꞌaslemal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ruma cꞌu ri xquita che ri ángel, anim tan xeboc pa ri Rocho Dios y xquijek quecꞌutunic. Ecꞌu ri cajawal raj chacunel pa Rocho Dios yey ri e cꞌo rucꞌ, cꞌamajaꞌ caquinaꞌbej riꞌ we rutakoꞌn ri Jesús ebesam chi lo pa ri cárcel. Xquimol cꞌu quichiꞌ tak ri uchapom wi rib ri kꞌatbal tzij, cucꞌ conoje ri nimak winak que raj Israel. Xequitak cꞌu ri e chajinel re ri Rocho Dios che quicꞌamic rutakoꞌn ri Jesús pa ri cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ecꞌuchiriꞌ xebopon ri e chajinel pa ri cárcel, na xequirik ta chi rutakoꞌn ri Jesús. Xetzelej cꞌu lok ");
INSERT INTO acrTNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","y jewaꞌ xoꞌlquibiꞌij: «Ri cárcel xkariko lic tzꞌapil chi utz, yey raj chajinel e cꞌo ne chwach tak ri oquibal re ri cárcel. Pero echiriꞌ xkajako, na jinta chi junok chique rutakoꞌn ri Jesús chupa» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Echiriꞌ xquita waꞌ, xsach quinaꞌoj ri cajawal raj chacunel y raj wach que ri e chajinel cucꞌ ri nimak e aj chacunel re ri Rocho Dios. Conoje xquijek quechꞌaꞌt puwiꞌ, ma na quetaꞌam taj saꞌ cuqꞌuisbej wi ronoje waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ecꞌuchiriꞌ, xcꞌun lo jun y jewaꞌ xubiꞌij: «E rachijab xeyaꞌ alak pa cárcel, e cꞌo pa ri Rocho Dios y na cokꞌotam ta quecꞌutun chiquiwach ri tinamit» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ecꞌu raj wach que ri e chajinel re ri Rocho Dios xeꞌec junam cucꞌ jujun e aj chajinel y xeꞌquicꞌama lo rutakoꞌn ri Jesús. Yey na jinta cꞌo xquiꞌan chique ma caquixiꞌij quib we caquiꞌan cꞌax chique, laj queꞌan paꞌbaj cuma ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ecꞌuchiriꞌ xequicꞌam lok, xequiya chiquiwach ri uchapom wi rib ri kꞌatbal tzij. Ecꞌu ri cajawal raj chacunel pa Rocho Dios xutzꞌonoj chique rutakoꞌn ri Jesús: ");
INSERT INTO acrTNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Na xixkatak ta neba che chaꞌ na quixcꞌutun ta chi chupa rubiꞌ wa jun achi? Yey woꞌora iwuma ne riꞌix xeꞌec utzijoxic wa cꞌutunic che ronoje Jerusalem; y na xew ta laꞌ, ma quiwaj ne quiya keklabal che ruquiqꞌuel laꞌ la jun achi —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri Pedro cucꞌ ri jujun chic e takoꞌn re ri Jesús xquicꞌul uwach: —Lic chirajawaxic wi nabe na e cakacoj utzij ri Dios chwach ri cakacoj quitzij rachijab. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma ri Dios que ri katiꞌ-kamam e xcꞌastajisan lo ri Jesús chiquixoꞌl ri ecaminak. Yey e ralak ri xcamisan alak ma uma ralak xyaꞌiꞌ ri Jesús chwa ri cruz. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero ri Dios lic xuyac ukꞌij ri Jesús, xuya puwiquikꞌab y xuꞌan Kajawal y Colobenel che; chaꞌ ruma ri Jesús, raj Israel caquitzelej quitzij chwach y caquirik na ri cuybal quimac. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","»Ecꞌu riꞌoj, e janipa ri xkilo, e cakatzijoj. Yey ri Santowilaj Ruxlabixel ri Dios, ri Jun yaꞌtal chique ri caquicoj utzij ri Dios, e cajiquiban uwach waꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Echiriꞌ xquita waꞌ ri e aj wach, lic xpe coyowal chiquij rutakoꞌn ri Jesús y xcaj quequicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ecꞌuchiriꞌ, chiquixoꞌl ri e aj kꞌatal tzij xyactaj jun fariseo Gamaliel rubiꞌ, aj cꞌutunel re ri tzijpixab yey lic yacom ukꞌij ruma ri tinamit. Rire xtakan che quebesax bi jokꞌotaj ri e takoꞌn re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tecꞌuchiriꞌ, xubiꞌij: «Achijab, alak aj Israel, chꞌobo na alak rakan chi utz saꞌ ri caꞌan alak chique waꞌchijab. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ma cꞌo tan kꞌij xyactaj jun achi Teudas rubiꞌ, yey chiribil rib xubiꞌij e jun achi lic cꞌo uwach. Laj e cajib ciento rachijab xeterej chirij. Pero xopon jun kꞌij rire xcamisaxic. Y conoje ri xesocotaj ruma rire, xequicher bi; jecꞌulaꞌ, xsach uwach janipa ri xunoꞌjij. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","»Chwi cꞌu riꞌ waꞌ, xyactaj jun chic chupa tak ri kꞌij echiriꞌ xꞌan jun ajilanic. Waꞌ e ri Judas aj Galilea. Yey uqꞌuiyal ticawex xeterej chirij. Pero xopon rukꞌijol echiriꞌ xcamisaxic; y conoje cꞌu ri xesocotaj ruma rire, xequicher bi. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","»Cambiꞌij cꞌu woꞌora che alak: Mechꞌichꞌaꞌ chi alak waꞌchijab; ri ꞌana alak e cheyolopij bi alak. Ma we xa quinoꞌjibal achijab wa caquicꞌutu, riꞌ casach na uwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Noꞌj we waꞌ re ri Dios, na cachꞌij ta alak usachic quiwach; y cꞌate cꞌu canaꞌ alak riꞌ cachꞌoꞌjin alak rucꞌ ri Dios» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Conoje xucꞌul quicꞌuꞌx ri xubiꞌij ri Gamaliel. Xequisiqꞌuij cꞌu ri e takoꞌn re ri Jesús; tecꞌuchiriꞌ, xjichꞌ quipa rucꞌ colob y xequitak che na quetzijon ta chi chupa rubiꞌ ri Jesús y xequiyolopij cꞌu bi. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xebel cꞌu bi ri e takoꞌn chiquiwach raj kꞌatal tzij. Lic quequiꞌcotic ma xyaꞌtaj chique caquitij cꞌax ruma quicojom rubiꞌ ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jecꞌulaꞌ, ronoje kꞌij na cacokꞌotaj taj quecꞌutunic y caquitzijoj ri Utzilaj Tzij chwi ri Jesucristo chupa ri Rocho Dios y chiꞌ tak ja. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chupa tak laꞌ la kꞌij lic xeqꞌuiyar ri cajlibal ri quicojom rubiꞌ ri Cristo. Ecꞌu ri hermanos e aj judiꞌab ri quechꞌaꞌt pa ri chꞌaꞌtem griego, xquijek quechꞌaꞌtiben chiquij ri hermanos e aj judiꞌab ri quechꞌaꞌt pa ri chꞌaꞌtem hebreo. Ma echiriꞌ caꞌan ri jachanic chique ri e nibaꞌib, ri malcaꞌnib ri quechꞌaꞌt pa ri chꞌaꞌtem griego na quecajmax ta chi utz rucꞌ ri toꞌbal que caquicꞌul ri jujun kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ecꞌu ri cablajuj takoꞌn xquimol quichiꞌ conoje ri quicojom rubiꞌ ri Cristo y xquibiꞌij chique: «Na usucꞌ taj we riꞌoj cakatanabaꞌ utzijoxic Rutzij Upixab ri Dios chaꞌ cakaya kib che ujachic ri cajawax chique ri e nibaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ruma cꞌu laꞌ hermanos, tzucuj alak wukub achijab chixoꞌl alak, chom ri quibinic quisilabic, lic quiyaꞌom quib pukꞌab ri Ruxlabixel ri Dios y lic cꞌo quinaꞌoj, chaꞌ cakaya wa chac paquikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jecꞌulaꞌ riꞌoj xew cakaya kib che cakaꞌan orar chwach ri Dios y che rutzijoxic Ruchꞌaꞌtem» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Conoje cꞌu ri hermanos quimolom quib, xucꞌul quicꞌuꞌx wa xbiꞌx chique. Xquichaꞌ cꞌu ri Esteban, jun achi lic cubul ucꞌuꞌx rucꞌ ri Dios yey lic cꞌo ri Santowilaj Ruxlabixel ri Dios rucꞌ. Y xequichaꞌ ri Felipe, ri Prócoro, ri Nicanor, ri Timón, ri Parmenas y ri Nicolás, jun achi aj Antioquía xex utakem lo ri cꞌutunic que raj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ewi xequicꞌam lo chiquiwach rutakoꞌn ri Jesús. Ecꞌu wa takoꞌn xquiya ri quikꞌab paquiwiꞌ y xquiꞌan orar cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jecꞌuriꞌlaꞌ ri Utzilaj Tzij re ri Kanimajawal lic xeꞌec utzijoxic y lic catajin quiqꞌuiyaric ri cajlibal ri quicojom rubiꞌ ri Cristo chiriꞌ Jerusalem. E cꞌo ne uqꞌuiyal e aj chacunel pa Rocho Dios xquijek caquitakej ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ri Esteban lic cꞌo ri unimal rutzil ucꞌuꞌx y ruchukꞌab ri Dios rucꞌ. Ruma cꞌu riꞌ, cuꞌan nimak tak cꞌutubal re ruchukꞌab ri Dios chiquiwach ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ecꞌuchiriꞌ, xeyactaj jujun re ri sinagoga, ri cabiꞌx che “Ri sinagoga que ri ebelinak lo pa ri cꞌax”, yey cucꞌ rique xeyactaj jujun e aj Cirene, e aj Alejandría, e aj Chipre y e aj Asia. E tak cꞌu riꞌ waꞌ xquijeko xa pa chꞌaꞌtem quechꞌoꞌjin rucꞌ ri Esteban. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yey na caquirik ta ucꞌulic uwach ri cubiꞌij ri Esteban ma rire cachꞌaꞌt rucꞌ ri naꞌoj uyaꞌom ri Ruxlabixel ri Dios che. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ecꞌu ri xquiꞌano e xequipuakij jujun achijab chaꞌ caquibiꞌij quitom tzel cachꞌaꞌt ri Esteban chirij ri Moisés y chirij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Xa jecꞌulaꞌ xequichꞌiꞌ wi tak ri winak re ri tinamit, ri nimak winak e aj wach y raj cꞌutunel re ri tzijpixab. Conoje cꞌu riꞌ waꞌ xebec chirij ri Esteban; rucꞌ oyowal xquichapo, xquicꞌam bi y xeꞌquiyaꞌa chiquiwach tak ri uchapom wi rib ri kꞌatbal tzij. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xequicoj cꞌu achijab e aj cojol rakꞌubal chirij, jewaꞌ caquibiꞌij: «Waꞌ waꞌchi lic xaki tzel cachꞌaꞌt chirij wa Santowilaj Luwar re ri Rocho Dios y chirij Rutzij Upixab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ma katom cubiꞌij, laꞌ la Jesús ri aj Nazaret cuwulij wa luwar y cujalcꞌatij janipa ri cꞌutunic y cojobal yaꞌtal can chike ruma ri Moisés» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Conoje cꞌu ri etzꞌul pa ri kꞌatbal tzij, echiriꞌ xquitzuꞌ uwach ri Esteban, xquil rupalaj e pachaꞌ upalaj juna ángel. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ri cajawal raj chacunel pa Rocho Dios xutzꞌonoj che ri Esteban we katzij xubiꞌij waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ecꞌu rire xubiꞌij: «Alak achijab y alak nimak winak, chinta na pe alak. Ri Dios, ri Jun lic cꞌo unimal chomalil rucꞌ, xukꞌalajisaj rib chwach ri kakaw Abraham echiriꞌ rire cꞌo pa ri luwar re Mesopotamia, waꞌ e echiriꞌ cꞌamajaꞌ queꞌjekela pa ri tinamit Harán. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xubiꞌij ri Dios che: “Chatelubi chupa ratinamit y chiquixoꞌl rawatz-achakꞌ; y jat cꞌu chwach rulew pa cancꞌut wi riꞌin chawe” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ecꞌuchiriꞌ, xel bi ri Abraham chwach rulew que raj Caldea y xjekiꞌ pa ri tinamit Harán. Chwi cꞌu rucamic rukaw, xtak lo ruma ri Dios chupa wa luwar pa jekel wi alak woꞌora. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","»Pero ri Dios na xuya tane che ri Abraham cuꞌan rajaw waꞌ wuꞌlew, tob tane xa pa cuya wi juna rakan. Noꞌj xubiꞌtisij cꞌu che tob ne rire caminak chic, waꞌ wuꞌlew cuꞌana na re y que ri ralcꞌoꞌal canok; yey echiriꞌ xbiꞌx waꞌ che ri Abraham, cꞌamajaꞌ ne cꞌo juna ralcꞌoꞌal. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ecꞌu ri Dios xubiꞌij che ri Abraham: Tak rawalcꞌoꞌal canok quebeꞌjekela na pa jun ulew na culew taj. Y chiriꞌ cꞌu riꞌ caꞌaniꞌ nibaꞌib chique y queyaꞌiꞌ pa cꞌaxlaj chac cajib ciento junab cuma ri ticawex re ri tinamit pa quecꞌojiꞌ wi. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero In quinkꞌataw tzij paquiwi wa tinamit, ri caquiya pa cꞌaxlaj chac ri nutinamit. Tecꞌuchiriꞌ, ri nutinamit quebel lok y quetzelej lok y quinquilokꞌnimaj chupa wa luwar at cꞌo wi xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","»Ri Dios xuꞌan jun tzij rucꞌ ri Abraham, yey ri cꞌutubal re waꞌ wa tzij e ri retalil re circuncisión. E uwariꞌche ri Abraham xucoj ri retalil re circuncisión che rucꞌajol Isaac echiriꞌ xuqꞌuis wajxakib kꞌij ralaxic. Jecꞌulaꞌ xuꞌan ri Isaac che rucꞌajol Jacob. Y ri Jacob jelaꞌ xuꞌan chique ri cablajuj ucꞌajol, ri e kamam re ri katinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","»Ecꞌu rique xoc retzelal cꞌuꞌx pa canimaꞌ chirij ri quichakꞌ José. Ruma cꞌu riꞌ, xquicꞌayij bi chaꞌ cacꞌam bi Egipto. Pero ri Dios cꞌo rucꞌ ri José ");
INSERT INTO acrTNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","y xresaj cꞌu chupa ronoje tak ri cꞌaxcꞌobic xicꞌow wi. Xuya unaꞌoj y xuꞌan che lic xucꞌul upuwach ri faraón, ri takanel re Egipto. Ma ri faraón xuya che ri José catakan puwi ri tinamit re Egipto y xuya pukꞌab rire ronoje rubitak re. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","»Xpe cꞌu jun unimal numic chupa tak ronoje ri luwar re Egipto y re Canaán. Ruma cꞌu waꞌ xpe unimal cꞌaxcꞌobic paquiwi ri katiꞌ-kamam ma na jinta caquitijo. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","»Echiriꞌ ri Jacob xunaꞌbej chilaꞌ Egipto cꞌo catijic, xebutak bi rucꞌajol chaꞌ queꞌquilokꞌo trigo chilaꞌ. Waꞌ e ri nabe benam xquiꞌan ri kamam chilaꞌ Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ecꞌu che rucalaj quibenam, ri José xukꞌalajisaj rib chiquiwach ri ratzixelab. Jecꞌulaꞌ ri faraón xretaꞌmaj china tak ri e ratz-uchakꞌ ri José. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","»Yey ri José xutak ucꞌamic rukaw Jacob y conoje ri e ratz-uchakꞌ. Ri cajlibal rique chi conoje e setenta y cinco. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jecꞌulaꞌ xeꞌjekela ri Jacob pa ri tinamit Egipto. Chilaꞌ cꞌu riꞌ xcam wi rire y chilaꞌ xecam wi ri kamam. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xcꞌam cꞌu bi ri quibakil pa ri tinamit Siquem y xeyaꞌ pa ri mukubal ulokꞌom can ri Abraham rucꞌ uqꞌuiyal puak chique ri ralcꞌoꞌal can ri Hamor, chilaꞌ Siquem. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","»Yey ecꞌuchiriꞌ catajin roponic ri kꞌij echiriꞌ ri Dios cuꞌana na rubiꞌtisim che ri Abraham, tak ri ralcꞌoꞌal rire lic xeqꞌuiyar chilaꞌ Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tecꞌuchiriꞌ, xyactaj jun chic rey chiriꞌ Egipto; ecꞌu rire na xretaꞌmaj ta uwach ri José. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Waꞌ wa rey xebusoc ri katinamit ojertan. Lic xebuya ri katiꞌ-kamam pa cꞌaxcꞌobic, ma xtakan che quecamisax ri quichꞌutiꞌk e alabo chaꞌ jelaꞌ na caqꞌuiyar ta quiwach ri katinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","»Chupa tak cꞌu riꞌ laꞌ la kꞌij xalax ri Moisés y e jun chomilaj acꞌa chwach ri Dios. Ecꞌu rire oxib icꞌ xchajix xa xeꞌlakꞌay pa rocho rukaw. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero echiriꞌ na utz ta chi quewax pa ja, xesax bi y xeꞌrikitaj lo ruma rumiꞌal ri faraón; y waꞌli xuqꞌuiyisaj y xuꞌan pachaꞌ ralab che. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jecꞌulaꞌ, ri Moisés xtijox puwi ronoje ri naꞌoj que ri aj Egipto, y xuꞌana jun achi lic cꞌo uchukꞌab che janipa tak ri cubiꞌij y cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","»Echiriꞌ xuqꞌuis cuarenta junab, xalax pa ranimaꞌ queꞌbina cucꞌ ri ratz-uchakꞌ, ri e aj Israel. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Y xril cꞌu riꞌ lic caꞌan cꞌax che jun chique ruma jun aj Egipto. Xutoꞌ cꞌu uwiꞌ ri ratz-uchakꞌ yey xucamisaj ri aj Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E xuchꞌob rire, tak ri ratz-uchakꞌ caquimaj usucꞌ e ruma rire queberesaj bi ri Dios paquikꞌab raj Egipto; noꞌj rique na je ta laꞌ ri xquimaj usucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","»Chucaꞌm kꞌij cꞌut xebuꞌrika caꞌib aj Israel quechꞌoꞌjin chiquiwach y xraj quebuya putzil chomal. Xubiꞌij cꞌu chique: “Achijab, ralak chakꞌ ib alak. ¿Suꞌchac cꞌu riꞌ caꞌan cꞌax che ib alak chiwach alak?” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","»Ecꞌuchiriꞌ, ri jun ri cuꞌan cꞌax che ri ratz-uchakꞌ, xupakchiꞌij bi ri Moisés y xubiꞌij che: “¿China cojoyom e la re takanel y re aj kꞌatal tzij pakawi riꞌoj? ");
INSERT INTO acrTNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Caꞌaj cami la riꞌ quincamisaj la riꞌin jelaꞌ pachaꞌ xꞌan la iwir echiriꞌ xcamisaj la ri aj Egipto?” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","»Echiriꞌ xuta waꞌ wa chꞌaꞌtem, ri Moisés asu xanimaj bi, xeꞌjekela pa ri luwar re Madián, tob rire na aj ta chilaꞌ. Yey chilaꞌ xebalax caꞌib ucꞌajol. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","»Icꞌowinak chi cꞌu cuarenta junab cꞌo chilaꞌ echiriꞌ xwinakir jun ángel chwach chupa rurepebal akꞌ cꞌo che jumocaj xuluquej pa ri luwar catzꞌintzꞌotic, chunakaj ri juyub Sinaí. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Echiriꞌ xril waꞌ ri Moisés, lic xcam ranimaꞌ che ri catajin ucꞌutic chwach. Yey echiriꞌ xkib che rilic chi utz, xuta rukul ri Dios, jewaꞌ xubiꞌij che: ");
INSERT INTO acrTNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“In ri Dios que ramam ojertan, waꞌ e ri Abraham, ri Isaac y ri Jacob” xchaꞌ. »Ecꞌu ri Moisés xujek cabirbotic y ruma xiꞌin ib na xutzuꞌ ta chi ri jumocaj xuluquej. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","»Ecꞌu ri Dios xubiꞌij che: “Chajolo raxajab che rawakan ma wa luwar pa at cꞌo wi lic santo. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Pakatzij wi riꞌin wilom lic eyaꞌtal pa cꞌaxcꞌobic ri nutinamit e cꞌo Egipto, yey nutom lic quetunanic. E uwariꞌche in petinak re quebeꞌnuwesaj lok. Ecꞌu woꞌora chatpetok; ma catintak bi Egipto” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","»Ecꞌu Moisés riꞌ waꞌ, ri xcꞌak bi ukꞌij echiriꞌ xbiꞌx che: “¿China cojoyom e la re takanel y re aj kꞌatal tzij pakawi riꞌoj?” Na rucꞌ ta cꞌu riꞌ, e ri Moisés ri xtak bi ruma ri Dios re cuꞌana quitakanel rutinamit y re queberesaj ri tinamit paquikꞌab raj Egipto. Xtak cꞌu che cuꞌan waꞌ ruma ri ángel, ri xwinakir chwach pa ri jumocaj xuluquej. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moisés riꞌ waꞌ, ri xeberesaj lo rutinamit ri Dios Egipto y lic xuꞌan milagros y tak cꞌutubal re ruchukꞌab ri Dios pa ri tinamit Egipto, chupa ri Mar Rojo y chupa ri cuarenta junab xebin pa ri luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","»Ecꞌu Moisés riꞌ waꞌ, ri xbiꞌn chique raj Israel: E ri Dios Kajawxel cuyac na lo chiquixoꞌl ri katinamit Israel jun Kꞌalajisanel jelaꞌ pachaꞌ riꞌin. Ecꞌu chita janipa ri cubiꞌij Rire chiwe xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","»E Moisés riꞌ waꞌ, ri xcꞌojiꞌ chiquiwach ri tinamit echiriꞌ quimolom quib pa ri luwar catzꞌintzꞌotic, y e xesan uchiꞌ ri ángel chiquiwa ri katiꞌ-kamam echiriꞌ xchꞌaꞌt rucꞌ chwi ri juyub Sinaí. Yey e rire ri xcꞌuluw tak ri chꞌaꞌtem re cꞌaslemal chaꞌ cukꞌatisaj lo chikawach riꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","»Pero ri katiꞌ-kamam na xcaj taj caquicoj utzij; ri xquiꞌano e xquicꞌak bi ukꞌij y e xchꞌaw quicꞌuꞌx che ri quetzelej tanchi Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yey xquibiꞌij ne che ri Aarón: “Cheꞌana la katiox chaꞌ quenabej bi chikawach; ma wa Moisés, ri xesan lo keꞌoj chwach rulew re Egipto, na ketaꞌam taj saꞌ ri xucꞌulumaj.” ");
INSERT INTO acrTNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ecꞌuchiriꞌ, xquiꞌan jun tiox ucꞌaxwach toro. Xequicamisaj cꞌu awaj re quikasaꞌn chwach wa tiox y xquiꞌan nimakꞌij chupa rubiꞌ ri tiox, ri xa xquiꞌan rucꞌ ri quikꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","»Ecꞌu ri Dios xebuya can che ulokꞌnimaxic quikꞌij ronoje ri cꞌo che ruwa caj. Xquiꞌan cꞌut jelaꞌ pachaꞌ ri ubiꞌim ri Dios chupa ri tzꞌibital can cuma ri kꞌalajisanelab: Riꞌix ix aj Israel, echiriꞌ xebicamisaj chicop re kasaꞌn chupa ri cuarenta junab xixbin pa ri luwar catzꞌintzꞌotic, ¿xilokꞌnimaj neba nukꞌij riꞌin rucꞌ waꞌ? ");
INSERT INTO acrTNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na xiꞌan taj, ma e ne xitelej ri rocho ri tiox Moloc ubiꞌ y ri chꞌumil re ri tiox iweꞌix, Renfán ubiꞌ. Waꞌ e quicꞌaxwach tak ri tiox xebiꞌano re quilokꞌnimaj quikꞌij. Ruma cꞌu laꞌ quixintak bi cꞌa chwach pana ri tinamit Babilonia cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","»Echiriꞌ ri katiꞌ-kamam xebin pa ri luwar catzꞌintzꞌotic, cꞌo cucꞌ rique ri jun Rocho Dios xa caquiric, waꞌ e cꞌutubal re cꞌo ri Dios cucꞌ. Yey rique xquiꞌan wa jun Rocho Dios jelaꞌ pachaꞌ ri xtakan ri Dios che ri Moisés, e lic pachaꞌ ruꞌaniquil rilom chi rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ecꞌu ri katiꞌ-kamam xquiya can wa Rocho Dios (ri xa caquiric) paquikꞌab ri calcꞌoꞌal rique. Y wa calcꞌoꞌal xquicꞌam bi waꞌ echiriꞌ xeboc rucꞌ ri Josué chupa ri ulew que ri na e ta aj Israel, ri xebesax bi ruma ri Dios chaꞌ waꞌ wuꞌlew cacanaj can paquikꞌab rutinamit Rire. Ecꞌu waꞌ wa Rocho Dios xcꞌojiꞌ cucꞌ rutinamit ri Dios cꞌa chupa tak ri kꞌij re ri rey David. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","»Ecꞌu ri David lic cꞌo rutoꞌbal ri Dios rucꞌ. Rire xutzꞌonoj cꞌut cayaꞌtaj che cuyac jun cꞌacꞌ Rocho ri Dios chaꞌ tak ri ralcꞌoꞌal can ri Jacob caquilokꞌnimaj ukꞌij ri Dios chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Noꞌj e ri Salomón ri xyacaw waꞌ wa Rocho Dios; ");
INSERT INTO acrTNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tob ri Dios Kajawxel na xew ta cajekiꞌ pa tak ja ꞌanatal xa cuma ticawex, pachaꞌ ri cubiꞌij ri jun kꞌalajisanel: ");
INSERT INTO acrTNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ruwa caj e nutzꞌulibal re takanic, yey ruwachulew e utacꞌalibal ri wakan. ¿Saꞌ cꞌu riꞌ ri ja quiyac chwe?” cacha ri Kajawal. “¿O pachawi cꞌowi ri luwar pa quinuxlan wi? ");
INSERT INTO acrTNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Na e ta neba ri nukꞌab ꞌanayom ronoje waꞌ wa cꞌolic?” cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","»Ecꞌu ralak lic na jinta cꞌo cata alak. Ri cꞌuꞌx alak y ri tanibal alak e pachaꞌ que ri winak na jinta ri Dios cucꞌ, ma na caꞌaj ta alak cacoj alak utzij. Ralak alak pachaꞌ ri chuꞌkaw alak ojertan, ma lic na caꞌaj ta alak cata alak ri cubiꞌij ri Santowilaj Ruxlabixel ri Dios che alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿China junok chique ri kꞌalajisanelab na xternabex ta rucꞌ cꞌax cuma ri chuꞌkaw alak ojertan? Ma rique e xecamisan que ri xetzijon lo puwi rucꞌutunic ri Jun lic jusucꞌ. Yey echiriꞌ xcꞌun Rire, ralak xcꞌayij alak y xcamisaj alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ralak xcꞌul alak Rutzij Upixab ri Dios cuma tak ri ángeles, noꞌj na xtakej ta alak janipa ri cubiꞌij wa Tzij Pixab» xcha ri Esteban. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Echiriꞌ xquita ri xubiꞌij ri Esteban, lic xpe coyowal y xquijek cakichꞌichꞌ ruwi queꞌ chirij rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ri Esteban lic cꞌo ruchukꞌab ri Santowilaj Ruxlabixel ri Dios rucꞌ; xtzuꞌn cꞌu pana chicaj y xril runimal uchomalil ri Dios yey xrilo ri Jesús cꞌo puwiquikꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xubiꞌij cꞌu rire: «¡Riꞌin canwilo jakal ruwa caj y canwil pana Ralaxel Chiquixoꞌl Ticawex cꞌo puwiquikꞌab ri Dios!» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ecꞌuchiriꞌ, ri winak xquijeko lic quesiqꞌuinic, xquitzꞌapij ri quixiquin y xa jumul xebec conoje chirij ri Esteban. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xquesaj cꞌu bi chupa ri tinamit y xquijeko caquiꞌan paꞌbaj. Y ri xquimol quib chirij, xquiya can ri quikꞌuꞌ che jun ala Saulo rubiꞌ chaꞌ cuchajij waꞌ chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ecꞌuchiriꞌ quetajin che uꞌanic paꞌbaj ri Esteban, rire xuchꞌaꞌbej ri Kanimajawal, jewaꞌ xubiꞌij: «Wajawal Jesús, cꞌama la ri wanimaꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tecꞌuchiriꞌ, xuxucubaꞌ rib y co xsiqꞌuinic: «Kajawal, cuyu la quimac che wa quetajin che uꞌanic» xchaꞌ. Y rucꞌ waꞌ, xcamic. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri Saulo e jun chique ri xuya uchꞌaꞌtem chaꞌ cacamisax ri Esteban. Chupa cꞌu riꞌ laꞌ la jun kꞌij, lic xjeker quiternabexic rucꞌ cꞌax janipa ri quicojom rubiꞌ ri Cristo chilaꞌ Jerusalem. Ruma cꞌu riꞌ, conoje xequich bi chupa tak ri luwar re Judea y re Samaria. Xew chi rutakoꞌn ri Jesús xecanaj can Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","E cꞌo cꞌu jujun achijab lic quiyaꞌom quib pukꞌab ri Dios; rique xquimuk ri Esteban y lic xcokꞌej rucamic. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Noꞌj ri Saulo ebuternabem rucꞌ cꞌax ri quicojom rubiꞌ ri Cristo. Xoc cꞌu chiꞌ tak ja re quebuꞌcharej lo rachijab y rixokib yey quebuꞌyaꞌa pa cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","E tak cꞌu ri equichom bi caquitzijoj ri Utzilaj Tzij chupa ronoje luwar pa quebopon wi. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ri Felipe e jun chique. Rire xopon chupa jun tinamit re Samaria y xujek catzijon puwi ri Cristo chiquiwach ri winak. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Waꞌ wa winak xa jun quiꞌanom che utayic janipa ri cucꞌut ri Felipe, yey caquitzutzaꞌ tak ri cꞌutubal re ruchukꞌab ri Dios cuꞌan chiquiwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ma lic e qꞌui ri e cꞌo paquikꞌab itzelilaj uxlabixel, yey waꞌ wa itzelilaj uxlabixel quesiqꞌuinic quebel bi chique ri winak. Y e cꞌo uqꞌuiyal jetzꞌ y sic xecunutajic. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ruma cꞌu riꞌ waꞌ, tak ri winak re ri tinamit lic quequiꞌcotic. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Cꞌo cꞌu jun achi aj chiriꞌ Simón rubiꞌ. E ri petinak lok rire aj kꞌij chupa la tinamit; lic quebusoc ri winak e aj Samaria ma cuꞌan che rib pachaꞌ lic cꞌo uwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Conoje cꞌu ri winak chinimaꞌk chichꞌutiꞌk, lic caquita ri cubiꞌij ri Simón y jewaꞌ caquibiꞌij: «E unimal uchukꞌab ri Dios ri cꞌo rucꞌ waꞌchi» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lic caquicoj ri cubiꞌij, ma lic xex wi ebusocom rucꞌ ri kꞌijonic cuꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero echiriꞌ xquita ri Utzilaj Tzij cutzijoj ri Felipe chwi rutakanic ri Dios y chwi ri Kanimajawal Jesucristo, xquicojo y jecꞌuriꞌlaꞌ achijab yey ixokib xquicꞌul ri bautismo. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ecꞌu riꞌ waꞌchi Simón xucoj rubiꞌ ri Cristo y xucꞌul ne ri bautismo. Xujek cꞌu riꞌ carachbilaj ri Felipe y lic cacam ranimaꞌ che tak ri cꞌutubal re ruchukꞌab ri Dios carilo cuꞌan ri Felipe. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yey ri e takoꞌn re ri Cristo e cꞌo Jerusalem, echiriꞌ xquito ri e aj Samaria xquicoj ri ubiꞌim lo ri Dios puwi ri Cristo, xequitak bi ri Pedro y ri Juan chilaꞌ Samaria. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ecꞌuchiriꞌ rique xeboponic, xquijek caquiꞌan orar paquiwi ri aj Samaria ri quicojom chi rubiꞌ ri Cristo chaꞌ rique caquicꞌul ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ma ri Ruxlabixel ri Dios cꞌamajaꞌ cakaj puwi junok chique, xew quicꞌulum ri bautismo pa rubiꞌ ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yey echiriꞌ ri Pedro y ri Juan xquiya ri quikꞌab paquiwiꞌ, xquicꞌul ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ecꞌu ri Simón xrilo suꞌanic ri ticawex caquicꞌul ri Ruxlabixel ri Dios echiriꞌ ri takoꞌn caquiya ri quikꞌab paquiwiꞌ. Xubiꞌtisij cꞌu puak chique, ");
INSERT INTO acrTNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","jewaꞌ xubiꞌij: —Yaꞌa alak chwe riꞌin laꞌ la jun chukꞌab, chaꞌ jelaꞌ xa tob china puwiꞌ canya wi ri nukꞌab, cucꞌul ri Santowilaj Ruxlabixel ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ecꞌuchiriꞌ, ri Pedro jewaꞌ xubiꞌij che: —Sach na uwach rapuak junam awucꞌ riꞌat, ma e chawach riꞌat, xa rucꞌ puak calokꞌ rusipanic ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yey riꞌat na jinta cꞌana awe che wa chac cakaꞌano ma rawanimaꞌ na jusucꞌ ta chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","E uwariꞌche, chatzelej atzij chwach ri Dios che waꞌ wa amac y chatzꞌonoj che Rire cucuy amac. Laj cucuy amac che la na utz taj xachꞌobo. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ma e canwil riꞌin, lic uꞌanom cꞌax acꞌuꞌx chikij y lic at yutum ruma ri mac —xcha ri Pedro che. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ri Simón xucꞌul uwach: —Lic chꞌaw co alak panuwiꞌ chwach ri Kanimajawal chaꞌ na cancꞌulumaj ta cꞌana wa xbiꞌij alak chwe —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ecꞌuchiriꞌ ri Pedro y ri Juan quitzijom chi tak ri xquilo y xquita che ri Jesús y quikꞌalajisam chi ri Utzilaj Tzij re ri Kanimajawal, xetzelej Jerusalem. Yey xalokꞌ cꞌu xebicꞌow chupa tak uqꞌuiyal aldeas que raj Samaria, xquitzijoj ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Cꞌo jun ángel re ri Kanimajawal xchꞌaꞌt rucꞌ ri Felipe, jewaꞌ xubiꞌij che: «Chayijbaꞌ awib y jat jewaꞌ pa sur. Chamaja bi ri be quel Jerusalem, ri cakaj pa ri tinamit Gaza» xchaꞌ. (Wa be quicꞌow pa tak luwar catzꞌintzꞌotic.) ");
INSERT INTO acrTNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xyactaj cꞌu ri Felipe y xumaj bi ube yey pa ri be xuꞌrika bi jun achi “eunuco”. Waꞌ waꞌchi lic cꞌo uwach ma pukꞌab rire cꞌo wi ronoje rubeyomal ri Candace. Ecꞌu waꞌchi xopon Jerusalem chaꞌ culokꞌnimaj ukꞌij ri Dios, ");
INSERT INTO acrTNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yey e riꞌ catzelej pa rutinamit. Tzꞌul cꞌu chupa jun careta y carajilaj Ruchꞌaꞌtem ri Dios tzꞌibital can ruma ri kꞌalajisanel Isaías. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ecꞌu ri Ruxlabixel ri Dios xubiꞌij che ri Felipe: «Chatkib pana che la jun careta y chatbin putzal» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Echiriꞌ ri Felipe xkib apanok, xuto rachi e carajilaj ri tzꞌibam can ruma ri kꞌalajisanel Isaías y jecꞌuwaꞌ xutzꞌonoj che: —¿Camaj la usucꞌ la catajin la che rajilaxic? —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Rachi xucꞌul uwach: —¿Suꞌanic canmaj usucꞌ we na jinta junok cakꞌalajisan chwe? —xcha che. Y xelaj cꞌu che ri Felipe chaꞌ cakꞌan pa ri careta y catzꞌuyiꞌ rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ecꞌu ri carajilaj che Ruchꞌaꞌtem ri Dios e waꞌ: Xcꞌam bi e pachaꞌ juna bexex re cacamisaxic; e pachaꞌ juna kꞌapoj bexex na cachꞌaw ta qꞌuenok echiriꞌ casocax ri rismal; jecꞌuriꞌlaꞌ rire na jinta cꞌana xubiꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xꞌaniꞌ che pachaꞌ lic na jinta uwach; y echiriꞌ xkꞌat tzij puwiꞌ, xꞌan ri lic na e ta usucꞌ che. ¿China tak cꞌu ri ticawex caquipetebej lo che rire? Na e jintaj, ma xkꞌat ukꞌij che ruwachulew. E waꞌ ri catajin che rajilaxic. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ecꞌu waꞌchi aj Etiopía xutzꞌonoj che ri Felipe: —Maꞌan co la riꞌ biꞌij la chwe, ¿china puwi cachꞌaꞌt wi ri kꞌalajisanel echiriꞌ cubiꞌij waꞌ? ¿Chiribil rib nawi cubiꞌij wi o cachꞌaꞌt puwi junok chic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ecꞌu ri Felipe xchꞌaꞌt rucꞌ rachi puwi waꞌ. Xujek lo rucꞌ ri catajin che rajilaxic che Ruchꞌaꞌtem ri Dios y xutzijoj cꞌu che puwi ri Utzilaj Tzij re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E cꞌo chi be echiriꞌ xebopon pa jun luwar pa cꞌo wi yaꞌ. Ecꞌu riꞌ rachi aj Etiopía xubiꞌij che ri Felipe: —Wara cꞌo yaꞌ. ¿Utz nawi riꞌin cancꞌul ri bautismo? —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ri Felipe xubiꞌij che: —We cacoj la rubiꞌ ri Kanimajawal Jesucristo rucꞌ ronoje animaꞌ la, lic utz riꞌ —xcha che. Rachi xucꞌul uwach: —Riꞌin cancojo ri Kanimajawal Jesucristo e Rucꞌajol ri Dios —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Y xutak cꞌu utacꞌabaxic riꞌ ri careta. Ecꞌu ri Felipe junam rucꞌ rachi xekaj chupa ri yaꞌ. Tecꞌuchiriꞌ, ri Felipe xuya ri bautismo che. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Echiriꞌ xebel lo chupa ri yaꞌ, xakicꞌateꞌt ri Ruxlabixel ri Dios Kajawxel xucꞌam bi ri Felipe. Rachi aj Etiopía na xril ta chi uwach, pero lic caquiꞌcotic xumaj tanchi ubi rube. ");
INSERT INTO acrTNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ecꞌu ri Felipe xeꞌyoꞌk chupa jun tinamit Azoto rubiꞌ. Echiriꞌ xel bi chiriꞌ, xicꞌow pa tak tinamit yey chujujunal tinamit pa xicꞌow wi, xutzijoj ri Utzilaj Tzij. Ecꞌu riꞌ xopon cꞌa chupa ri tinamit Cesarea. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ecꞌu ri Saulo na carokꞌotaj taj cuxibij quipa rucꞌ camic janipa ri quicojom rubiꞌ ri Kanimajawal. Xeꞌec cꞌu rucꞌ ri cajawal raj chacunel pa Rocho Dios ");
INSERT INTO acrTNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","y xutzꞌonoj bi uwujil chaꞌ cayaꞌiꞌ pukꞌab coc pa tak ri sinagogas re ri tinamit Damasco. Jecꞌulaꞌ, we queburik achijab o ixokib e cuqꞌuil ri quitakem wa cꞌacꞌ Be, cꞌo cꞌu pukꞌab riꞌ quebuyut lok y quebucꞌam lo Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ecꞌu ri Saulo e riꞌ cꞌo pan chi be che uꞌanic waꞌ, catajin cꞌu roponic chunakaj ri tinamit Damasco, echiriꞌ xakicꞌateꞌt ruwonibal jun akꞌ xpe chilaꞌ chicaj, xwol caꞌn puwiꞌ y xusut rij. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ri Saulo xtzak pulew y xuta cꞌu jun kulaj, jewaꞌ cubiꞌij che: —Saulo, Saulo, ¿suꞌchac catchꞌoꞌjin chwij? —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ri Saulo xutzꞌonoj che: —¿Lal china rilal, Wajawal? —xchaꞌ. Jecꞌuwaꞌ xcꞌul uwach che: —Riꞌin in Jesús, ri Jun catchꞌoꞌjin chirij. Yey riꞌat, atuquel nenareꞌ lic caꞌan cꞌax che awib, jelaꞌ pachaꞌ juna boyex echiriꞌ cuya akan che ri puya cachꞌic lo che —xuchixic. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Cabirbot cꞌu ri Saulo y uxiꞌim rib, jewaꞌ xubiꞌij che: —Wajawal, ¿saꞌ ri caꞌaj la canꞌano? —xchaꞌ. Ri Kanimajawal xucꞌul uwach: —Chatyactajok y jat chupa ri tinamit, ma chiriꞌ cabiꞌx wi chawe saꞌ ri chirajawaxic caꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ecꞌu rachijab e rachbiꞌil ri Saulo lic quixiꞌim quib xetaqꞌuiꞌic; ma xquita ri kulaj, noꞌj na jinta junok xquil uwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ri Saulo xyactaj chwa rulew y xujak cꞌu ruwach, pero na jinta chi cꞌo carilo ma xcanaj can potzꞌ. Ewi xa xchꞌelex bi che rukꞌab cuma ri erachbilam y xcꞌam bi chupa ri tinamit Damasco. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Xcꞌojiꞌ cꞌu chilaꞌ oxib kꞌij; e laꞌ na catzuꞌn taj, na xwaꞌ taj y na jinta ne umikꞌinaꞌ xutijo. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Chilaꞌ cꞌu riꞌ Damasco cꞌo jun achi Ananías rubiꞌ; rire ucojom rubiꞌ ri Cristo. Cꞌo cꞌu jun cꞌutubal re ri Dios xkꞌalajisax chwach. Ri xrilo e ri Kanimajawal xucꞌut uwach chwach y jewaꞌ xubiꞌij che: —¡Ananías! —xcha che. Rire xucꞌul uwach: —Riꞌ in cꞌolic, Wajawal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xubiꞌij cꞌu ri Kanimajawal che: —Chatyactajok y jat chupa ri be cabiꞌx “Jusucꞌ” che. Yey chirocho cꞌu ri Judas, chatzꞌonobej puwi jun achi aj Tarso, Saulo rubiꞌ. Rire catajin pa oración ");
INSERT INTO acrTNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","y kꞌalajisam chi cꞌu jun cꞌutubal re ri Dios chwach. Chupa waꞌ xril jun achi Ananías rubiꞌ, e riꞌ coc bi y cuya rukꞌab puwiꞌ chaꞌ jelaꞌ catzuꞌn tanchic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Xubiꞌij cꞌu ri Ananías che ri Kanimajawal: —Wajawal, lic nutom ronoje ri na utz taj uꞌanom waꞌ waꞌchi chique ri quicojom ri biꞌ la chilaꞌ Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yey yaꞌtal ne lo pukꞌab cuma ri nimak e aj chacunel pa Rocho Dios quebucꞌam bi pa cárcel conoje ri quicojom ri biꞌ la —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ecꞌu ri Kanimajawal xubiꞌij che: —Jat chilaꞌ rucꞌ, ma Riꞌin nuchaꞌom rire chaꞌ cuꞌana jun waj chac re queꞌec che ukꞌalajisaxic ri nubiꞌ chiquiwach ri winak na e ta aj judiꞌab, chiquiwach ri e takanelab y chiquiwach ri e aj Israel. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yey cancꞌut cꞌu che, janipa ri cꞌaxcꞌolil chirajawaxic quicꞌow wi rire ruma cutzijoj ri nubiꞌ —xuchix ri Ananías. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ri Ananías xeꞌec cꞌut y xoc pa ri ja pa cꞌo wi ri Saulo. Xuya cꞌu rukꞌab puwiꞌ y xubiꞌij che: «Hermano Saulo, ri Kanimajawal Jesucristo, ri xukꞌalajisaj rib chawach chupa ri be pa at petinak wi, inutakom lo awucꞌ chaꞌ cat-tzuꞌn tanchic y cacꞌul cꞌu ri Santowilaj Ruxlabixel ri Dios» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chupa cꞌu laꞌ la jokꞌotaj, cꞌo ri pachaꞌ soloꞌt xtzak che ruwach ri Saulo y xtzuꞌn tanchic. Tecꞌuchiriꞌ, xyactajic y xucꞌul ri bautismo. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ecꞌuchiriꞌ xwaꞌ ri Saulo, xcꞌojiꞌ tanchi uchukꞌab y xcꞌojiꞌ jujun kꞌij cucꞌ ri quicojom rubiꞌ ri Cristo chilaꞌ pa ri tinamit Damasco. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tecꞌuchiriꞌ, ri Saulo xujek catzijon puwi ri Cristo chupa tak ri sinagogas, jewaꞌ ri cubiꞌij: «Ri Jesús e Ucꞌajol ri Dios» cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Conoje ri quetaw re lic cacam canimaꞌ che y caquibiꞌij: «¿Na e ta neba achi waꞌ ebuternabem rucꞌ cꞌax ri quicojom rubiꞌ ri Cristo chilaꞌ Jerusalem; yey cꞌuninak ne wara re quebuyut bi y quebuꞌyaꞌa paquikꞌab ri nimak e aj chacunel pa Rocho Dios?» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ri Saulo jalan catajin unimaric ruchukꞌab puwi ri cutzijoj. Ecꞌu raj judiꞌab ejekel chiriꞌ Damasco xsach quinaꞌoj che ma ri Saulo cukꞌalajisaj chiquiwach: Ri Jesús e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Icꞌowinak chi cꞌu uqꞌuiyal kꞌij, raj judiꞌab xquiꞌan tzij junam chiquiwach re caquicamisaj ri Saulo. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero waꞌ xretaꞌmaj ri Saulo. Ecꞌo cꞌu ri quichajim chipakꞌij chichakꞌab tak ri oquibal re ri tinamit chaꞌ caquichap ri Saulo y caquicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ruma cꞌu riꞌ, ri quicojom rubiꞌ ri Cristo e laꞌ chakꞌab xquikasaj bi ri Saulo chwi ri tapia chupa jun nimalaj chacach. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Echiriꞌ xopon ri Saulo Jerusalem, lic xraj cakib cucꞌ ri quicojom rubiꞌ ri Cristo. Pero conoje rique lic caquixiꞌij quib che, ma na caquicoj taj we pakatzij wi ri Saulo ucojom chi rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ecꞌu ri Bernabé xucꞌam bi y xuꞌyaꞌa chiquiwach ri e takoꞌn re ri Cristo. Xutzijoj cꞌu chique suꞌanic ri Saulo xril uwach ri Kanimajawal pa be y xchꞌaꞌt rucꞌ. Yey xutzijoj chique puwi ri tzijonic xuꞌan ri Saulo chupa rubiꞌ ri Jesús chilaꞌ Damasco yey rucꞌ unimal uchukꞌab xuꞌan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ecꞌu ri Saulo xcanaj cucꞌ chiriꞌ Jerusalem y xerachbilaj pa tak quebec wi. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lic na cuxiꞌij ta rib catzijon chupa rubiꞌ ri Kanimajawal. Cachꞌaꞌt cꞌu puwi ri Jesús cucꞌ raj judiꞌab ri quechꞌaꞌt pa ri chꞌaꞌtem griego; ruma cꞌu laꞌ, rique caquitzucuj suꞌanic caquicamisaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Echiriꞌ ri hermanos xquetaꞌmaj waꞌ, xquicꞌam bi ri Saulo cꞌa Cesarea y chiriꞌ cꞌut xquitak bi chupa ri tinamit Tarso. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","E tak cꞌu ri quicojom rubiꞌ ri Cristo pa ronoje ri luwar re Judea, re Galilea y re Samaria, xecubiꞌ chi utz ma na jinta chi ri queternabex rucꞌ cꞌax. Rique cꞌo xiꞌin ib cucꞌ chwach ri Kanimajawal. Catajin cꞌu quiqꞌuiyaric yey yaꞌom quichukꞌab y nimarisam quicꞌuꞌx ruma ri Santowilaj Ruxlabixel ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Xalokꞌ cꞌu ri Pedro catajin ricꞌowic pa tak riglesias, xopon cucꞌ ri quicojom rubiꞌ ri Cristo pa ri tinamit Lida. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chilaꞌ cꞌu riꞌ xuꞌrika jun achi Eneas rubiꞌ, yey e wajxakib lo junab riꞌ cꞌo chwa uwarabal ma xuꞌan sic. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ecꞌu ri Pedro jewaꞌ xubiꞌij che: «Eneas, ri Kanimajawal Jesucristo catucunaj. Chatyactajok y chayijbaꞌ rawarabal» xcha che. Chupa cꞌu laꞌ la jokꞌotaj ri Eneas xtaqꞌuiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Conoje cꞌu ri ejekel chupa ri tinamit Lida y pa tak ri luwar re Sarón xquilo ri Eneas cunutajinak chic; y ruma cꞌu waꞌ, xquiya quib pukꞌab ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chupa ri tinamit Jope cꞌo jun ixok ucojom rubiꞌ ri Cristo, Tabita rubiꞌ. (Pa ri chꞌaꞌtem griego “Dorcas” quecha che.) Waꞌ wiꞌxok lic uyaꞌom rib che uꞌanic ri utz y lic quebutoꞌ ri nibaꞌib. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chupa tak laꞌ la kꞌij ri Dorcas xuchap yabil y xcamic. Ecꞌuchiriꞌ xchꞌaj rucuerpo, xkꞌatisax chicaj pa ri caleꞌ ja. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ecꞌu ri hermanos e cꞌo Lida xquito cꞌo ri Pedro pa ri tinamit Jope, yey waꞌ xa nakaj cꞌo wulok. Xequitak cꞌu bi caꞌib achijab chaꞌ quebeꞌelaj che ri Pedro, jewaꞌ caquibiꞌij: «ꞌAna co la riꞌ, peta la wara kucꞌ yey mamayin la.» ");
INSERT INTO acrTNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Xyactaj cꞌu bi ri Pedro y xeꞌec cucꞌ. Echiriꞌ xoponic, xcꞌam bi chicaj pa ri caleꞌ ja. E tak ri e malcaꞌnib xquisut rij ri Pedro. Conoje waꞌ quebokꞌic y caquicꞌut tak ri cꞌul y ri quikꞌuꞌ xuꞌan ri Dorcas echiriꞌ cꞌa cꞌo cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ecꞌuchiriꞌ, ri Pedro xtakan che conoje quebel bi. Xuxucubaꞌ cꞌu rib y xuꞌan orar. Tecꞌuchiriꞌ, xutzuꞌ ri caminak, y jewaꞌ xubiꞌij che: «¡Tabita, chatyactajok!» xchaꞌ. Ecꞌu riꞌ ri Dorcas xujak ruwach; y echiriꞌ xrilo cꞌo ri Pedro chiriꞌ, asu xtzꞌuyiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ecꞌu ri Pedro xuchap rukꞌab y xuyaco. Tecꞌuchiriꞌ, xebusiqꞌuij ri quicojom rubiꞌ ri Cristo cucꞌ tak ri hermanas e malcaꞌnib, y xuya cꞌu chiquiwach e laꞌ cꞌaslic. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Waꞌ xetaꞌmax chupa ronoje ri luwar re Jope. Ruma cꞌu riꞌ, lic e qꞌui ri xquicoj rubiꞌ ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Y ri Pedro xcanaj can uqꞌuiyal kꞌij chupa ri tinamit Jope, chirocho jun achi Simón rubiꞌ, ri cutꞌis tzꞌuꞌum. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pa ri tinamit Cesarea cꞌo jun achi Cornelio rubiꞌ. Rire e capitán que ri soldados e cuqꞌuil ri cabiꞌx chique “E aj Italia”. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri Cornelio lic jusucꞌ rubinic usilabic y lic cꞌo xiꞌin ib pa ranimaꞌ chwach ri Dios junam cucꞌ conoje ri ralcꞌoꞌal. Rire lic cuya puak re toꞌbal que ri nibaꞌib e aj judiꞌab y lic cuꞌan orar chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Cꞌo cꞌu jun kꞌij riꞌ, laj che ri urox ora benak kꞌij xkꞌalajisax jun cꞌutubal re ri Dios chwach. Ri xcꞌut che, e jun ángel re ri Dios e riꞌ xoc chiriꞌ pa cꞌo wi rire y jewaꞌ xubiꞌij che: —¡Cornelio! —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ri Cornelio lic xutzuꞌ ri ángel y rucꞌ xiꞌin ib xubiꞌij che: —¿Saꞌ ri caꞌaj la, wajawal? —xchaꞌ. Ri ángel xucꞌul uwach: —E tak ra oración y ri toꞌbal que ri nibaꞌib aꞌanom riꞌat, waꞌ ucꞌulum ri Dios pachaꞌ jun kasaꞌn chwach Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ecꞌu ri caꞌan woꞌora e chebataka bi achijab pa ri tinamit Jope re queꞌquisiqꞌuij jun achi Simón rubiꞌ, ri cabiꞌx Pedro che. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Waꞌ waꞌchi jekel chuchiꞌ ri mar pa rocho ri Simón, jun aj tꞌisol tzꞌuꞌum. Waꞌ wa Pedro cubiꞌij chawe saꞌ ri lic chirajawaxic wi caꞌano —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Echiriꞌ xel bi ri ángel xchꞌaꞌt rucꞌ, ri Cornelio xebusiqꞌuij caꞌib raj chac y jun soldado lic cꞌo xiꞌin ib pa ranimaꞌ chwach ri Dios, waꞌ e jun chique ri e cꞌo pukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Xutzijoj na cꞌu chique ronoje ri xrilo; tecꞌuchiriꞌ, xebutak bi pa ri tinamit Jope. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chucaꞌm kꞌij cꞌut echiriꞌ e cꞌo pan pa be e riꞌ catajin coponic chunakaj ri tinamit, ri Pedro xakꞌan chwi ri ja chaꞌ cuꞌana orar echiriꞌ ya caticꞌoj ri kꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Xpe cꞌu jun unimal numic che y lic xraj cawaꞌic. Catajin cꞌu uyijbaxic ruwa echiriꞌ xakicꞌateꞌt cꞌo xucꞌut ri Dios chwach. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ruwa caj jakalic. Cꞌo cꞌu pachaꞌ jun nimalaj cꞌul caripipic y ximital lo che ri cajib utzaꞌm, e riꞌ cakasax lo che ruwachulew. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chupa waꞌ wa cꞌul e cꞌo ronoje quiwachlibal awaj: waꞌ e ri cꞌo cajib cakan, ri quecharar pulew yey ri quexiqꞌuicꞌ che ruwa caj. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yey xuta jun kulaj jewaꞌ xubiꞌij: —Chatyactajok Pedro; chacamisaj y chatijaꞌ —xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero ri Pedro xubiꞌij che: —Na canꞌan ta cꞌana riꞌ, Wajawal, ma riꞌin na jinta cꞌana cꞌo nutijom e laꞌ chꞌul o na takal taj catijic —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xchꞌaw tanchi cꞌu ri jun kulaj, jewaꞌ xubiꞌij che: —Ri ujoskꞌim chi ri Dios, riꞌat mabiꞌij chꞌul che —xcha che ri Pedro. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Waꞌ oxlaj xuꞌano; tecꞌuchiriꞌ, ri nimalaj cꞌul xtzelej tanchi chilaꞌ chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ecꞌu ri Pedro catajin che utzꞌonoxic chiribil rib saꞌ queꞌelawi ri xcꞌut chwach, echiriꞌ xecꞌun rachijab etakom lo ruma ri Cornelio. Rique quitzꞌonobem lo ri rocho ri Simón ri cutꞌis tzꞌuꞌum, yey woꞌora e cꞌo chwa ri puerta. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Xechꞌaw cꞌu apanok y xquitzꞌonoj we chiriꞌ jekel wi ri Simón, ri cabiꞌx Pedro che. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ecꞌu ri Pedro cꞌa catajin ne che uchꞌobic rakan puwi ri xcꞌut chwach, echiriꞌ ri Ruxlabixel ri Dios xubiꞌij che: «Chawilaꞌ, ma leꞌ oxib achijab catquitzucuj. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chatyactajok, chatkajok y jat cucꞌ. Muxiꞌij rib acꞌuꞌx cateꞌec cucꞌ, ma in ri intakayom lo que» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xkaj cꞌu lo ri Pedro pa e cꞌo wi rachijab etakom lo ruma ri Cornelio, y xubiꞌij chique: —Riꞌ in cꞌolic, in ri quintzucuj alak. ¿Saꞌ ri petinak wi alak wucꞌ? —xcha chique. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Rique xquibiꞌij che: —Cꞌo jun capitán aj Roma, Cornelio rubiꞌ. Rire e jun achi lic jusucꞌ, cꞌo xiꞌin ib rucꞌ chwach ri Dios, yey chom ruchꞌaꞌtibexic caꞌan cuma conoje raj judiꞌab. Xbiꞌx cꞌu che rire ruma jun santowilaj ángel re ri Dios, cutak lo cꞌamic la re queꞌec la chirocho y jecꞌulaꞌ cuta ri cabiꞌij la che —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ecꞌu ri Pedro xebucoj bi pa ja y xuya luwar chique quecanaj can la jun akꞌab chiriꞌ. Chucaꞌm kꞌij cꞌut xeꞌec cucꞌ, yey xecachbilaj bi jujun hermanos e aj pa ri tinamit Jope. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chucaꞌm kꞌij cꞌut xebopon pa ri tinamit Cesarea pa eroyeꞌem wi ri Cornelio. Rire umolom chi quichiꞌ ri ratz-uchakꞌ y ri ramigos ri cꞌax caquinaꞌ quib rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Echiriꞌ xopon ri Pedro, xel lo ri Cornelio che ucꞌulic y xuxucubaꞌ rib chwach re culokꞌoj ukꞌij. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ri Pedro xuyaco y xubiꞌij che: —Yactaja la, ma riꞌin xa in jun achi pachaꞌ rilal —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Cachꞌaꞌt cꞌu rucꞌ ri Cornelio, xoc bi y xebuꞌrika uqꞌuiyal ticawex quimolom quib chiriꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xubiꞌij cꞌu ri Pedro chique: —Lic etaꞌam ralak, chikaxoꞌl ri oj aj judiꞌab lic na ube taj we junok chike cujunimaj rib o cakib rucꞌ junok na e ta cuqꞌuil raj judiꞌab. Noꞌj ri Dios xucꞌut chinuwach riꞌin na ube taj canchꞌob rakan waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","E uwariꞌche, echiriꞌ xineꞌsiqꞌuixok, na jampatana ximpetic y na jinta ne xintzꞌonoj we utz canꞌan waꞌ. Ecꞌu woꞌora cantzꞌonoj che alak, ¿suꞌchac xtak alak nucꞌamic? —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ri Cornelio xucꞌul uwach: —E ucaj kꞌij waꞌ icꞌowinak je uꞌorayil waꞌ, riꞌin in cꞌo pa ayuno laj che ri urox ora benak kꞌij, yey in cꞌo pa oración chiwocho echiriꞌ xwinakir cꞌu chinuwach jun achi ucojom ukꞌuꞌ lic cawolkꞌinic ");
INSERT INTO acrTNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","y jewaꞌ xubiꞌij chwe: “Cornelio, ri Dios utom ra oración y cꞌo chucꞌuꞌx janipa ri toꞌbal que ri nibaꞌib aꞌanom. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chataka junok chupa ri tinamit Jope re cuꞌsiqꞌuij ri Simón ri cabiꞌx Pedro che. Rire cꞌo pa rocho ri Simón, jun achi aj tꞌisol tzꞌuꞌum cꞌo rocho chuchiꞌ ri mar. Yey echiriꞌ cacꞌunic, e rire ri cachꞌaꞌt awucꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","»Jecꞌuriꞌlaꞌ, xintakalaꞌ cꞌamic la; y lic utz ri xꞌan la, ma xpe la. Ecꞌu woꞌora, konoje oj cꞌo wara chwach ri Dios chaꞌ cakata ronoje ri utakom wi lo la chaꞌ cabiꞌij la chike —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ecꞌuchiriꞌ, xujek cachꞌaꞌt ri Pedro, jewaꞌ xubiꞌij: «Pakatzij wi woꞌora canmaj usucꞌ ri Dios na cachaꞌw ta chiquixoꞌl ri ticawex. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma ri cuꞌano e lic cucꞌul ucꞌuꞌx echiriꞌ ri ticawex pa tak ronoje tinamit cꞌo xiꞌin ib cucꞌ chwach Rire y caquiꞌan ri lic jusucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Cꞌo cꞌu ri xukꞌalajisaj ri Dios chique ri e aj Israel; waꞌ e ri Utzilaj Tzij, ri cucꞌam lo utzil chomal ruma ri Jesucristo ri Kajawal konoje. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","»Etaꞌam cꞌu ralak saꞌ tak ri xuꞌan ri Jesús echiriꞌ icꞌowinak chi ri tzijonic re ri Juan chwi ri bautismo rucꞌ yaꞌ. Ri tzijonic puwi ri Jesús xujek lo cꞌa Galilea y xeꞌec utzijoxic che ronoje ri luwar re Judea. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xetaꞌmaj cꞌu ralak saꞌ ri xuꞌan ri Dios; xuya che ri Jesús ri aj Nazaret lic cacꞌojiꞌ ri Santowilaj Ruxlabixel y ruchukꞌab Rire rucꞌ. Ecꞌu ri Jesús xeꞌec pa tak luwar re cuꞌan ri utz y quebucunaj conoje ri eyaꞌom pa cꞌax ruma ritzel winak. Xuꞌan tak cꞌu waꞌ ma ri Dios lic cꞌo rucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","»Ecꞌu riꞌoj lic ketaꞌam waꞌ ma xkil ronoje ri xuꞌan ri Jesús pa tak ri luwar re Judea y chilaꞌ Jerusalem. E waꞌ Rire ri xyaꞌiꞌ chwa cruz y xcamisaxic. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero churox kꞌij ri Dios xucꞌastajisaj lo ri Jesús chiquixoꞌl ri ecaminak y xuya che xucꞌut uwach chikawach. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Na xucꞌut ta uwach chiquiwach conoje ri tinamit, ma xew chiquiwach ri ebuchaꞌom chi lo ri Dios ojertan; waꞌ e riꞌoj, ri xojwaꞌ junam rucꞌ y xkatij kamikꞌinaꞌ junam rucꞌ echiriꞌ cꞌastajinak chi lo Rire chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","»Yey xojutak cꞌu che utzijoxic che ri tinamit chaꞌ cakakꞌalajisaj e Rire ri Aj Kꞌatal Tzij ucojom ri Dios paquiwi ri e cꞌaslic y ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Puwi ri Jesús xetzijon lo conoje ri kꞌalajisanelab ojertan. Rique xquibiꞌij e janipa ri quecojow re Rire, caquicꞌul ri cuybal quimac ruma quicojom rubiꞌ» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Cꞌa cachꞌaꞌt ne ri Pedro cucꞌ chwi tak waꞌ echiriꞌ xkaj ri Santowilaj Ruxlabixel ri Dios paquiwi conoje ri quetaw re. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yey e petinak rucꞌ ri Pedro jujun e aj judiꞌab quicojom rubiꞌ ri Cristo. Waꞌ lic xcam canimaꞌ che, ma ri Santowilaj Ruxlabixel ri Dios xkaj paquiwi ri na e ta aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Quequitataꞌ cꞌu riꞌ quechꞌaꞌt pa jujun chic chꞌaꞌtem yaꞌtal chique ruma ri Ruxlabixel ri Dios y lic caquiyac ukꞌij ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ecꞌu ri Pedro xubiꞌij: «¿Cꞌo neba junok cakꞌaten que caquicꞌul ri bautismo rucꞌ yaꞌ? Ma rique xquicꞌul ri Santowilaj Ruxlabixel ri Dios jelaꞌ pachaꞌ riꞌoj» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Xtakan cꞌu che cayaꞌ ri bautismo chique pa rubiꞌ ri Kanimajawal Jesucristo. Ecꞌuchiriꞌ, xebelaj che ri Pedro chaꞌ cacanaj chi queb oxib kꞌij cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ri e takoꞌn re ri Jesús cucꞌ ri hermanos e cꞌo Judea xquito e cꞌo na e ta aj judiꞌab xecojow re Rutzij ri Dios puwi ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ruma cꞌu riꞌ, echiriꞌ xtzelej ri Pedro Jerusalem, ri hermanos e aj judiꞌab lic xquichap pa chꞌaꞌoj, ");
INSERT INTO acrTNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","jewaꞌ xquibiꞌij che: «¿Suꞌchac xatoc pa cocho ri na e ta aj judiꞌab y xatwaꞌ ne cucꞌ?» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ecꞌu ri Pedro xujek utzijoxic chique chucholaꞌj suꞌanic xuꞌana waꞌ. Jecꞌuwaꞌ xubiꞌij chique: ");
INSERT INTO acrTNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«E riꞌin in cꞌo pa ri tinamit Jope e riꞌ canꞌan orar echiriꞌ xakicꞌateꞌt xkꞌalajisax jun cꞌutubal re ri Dios chinuwach. Waꞌ pachaꞌ jun nimalaj cꞌul ximital lo che ri cajib utzaꞌm, xkasax lo chilaꞌ chicaj cꞌa pa la in cꞌo wi riꞌin. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Echiriꞌ xintzuꞌ chi utz saꞌ ri cꞌo chupa waꞌ, xebenuwil cꞌu awaj cꞌo cajib cakan, itzel tak chicop re upa juyub, awaj quecharar pulew, yey ri quexiqꞌuicꞌ che ruwa caj. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","»Yey xinta cꞌu jun kulaj, jewaꞌ xubiꞌij chwe: “Chatyactajok Pedro; chacamisaj y chatijaꞌ” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","»Ximbiꞌij cꞌu riꞌin: “Na canꞌan ta cꞌana riꞌ, Wajawal, ma riꞌin na jinta cꞌana chꞌul o na takal taj catijic oquinak pa nuchiꞌ” xinchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","»Ecꞌuchiriꞌ, xchꞌaw tanchi lo ri jun kulaj chilaꞌ chicaj, jewaꞌ xubiꞌij chwe: “Ri ujoskꞌim chi ri Dios, riꞌat mabiꞌij chꞌul che” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","»Waꞌ oxlaj xuꞌano. Tecꞌuchiriꞌ, ronoje xcꞌam tanchi ubi chicaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","»Chupa cꞌu laꞌ la jokꞌotaj xecꞌun oxib achijab chwa ri ja pa in cꞌo wi; rique e petinak Cesarea, etakom lok chaꞌ quinquitzucuj. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ecꞌu ri Ruxlabixel ri Dios xubiꞌij chwe quinꞌec cucꞌ y muxiꞌij ne rib nucꞌuꞌx quinꞌec. Xinꞌec cꞌu riꞌ cucꞌ; yey waꞌ wa wakib hermanos e aj Jope e cꞌo wara wucꞌ, xojcachbilaj bi. »Echiriꞌ xojopon Cesarea, xojoc chirocho jun achi. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yey waꞌchi xutzijoj chike suꞌanic xril uwach jun ángel chirocho. Waꞌ xoꞌltacꞌal chwach rire y jewaꞌ xubiꞌij che: “Chebataka bi achijab pa ri tinamit Jope re queꞌquisiqꞌuij jun achi Simón rubiꞌ, ri cabiꞌx Pedro che. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ecꞌu rire coluꞌbiꞌij chawe suꞌanic catcolobetaj riꞌat cucꞌ conoje ri ejekel pa wocho” xcha ri ángel che. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","»Yey, echiriꞌ riꞌin xinjeko quinchꞌaꞌt cucꞌ waꞌ wa ticawex na e ta aj judiꞌab, xkaj ri Santowilaj Ruxlabixel ri Dios paquiwiꞌ jelaꞌ pachaꞌ xujekebej lok echiriꞌ xkaj pakawi ri oj aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","»Ecꞌuchiriꞌ, xcꞌun chinucꞌuꞌx rubiꞌim can ri Kanimajawal echiriꞌ xubiꞌij: “Pakatzij wi, ri Juan xuya ri bautismo rucꞌ yaꞌ, noꞌj ri bautismo quicꞌul riꞌix e rucꞌ ri Santowilaj Ruxlabixel ri Dios.” ");
INSERT INTO acrTNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","»Ecꞌu uwariꞌche, we ri Dios xuya chique rique wa sipanic jelaꞌ pachaꞌ ri xuya chike riꞌoj ri cubul chi kacꞌuꞌx rucꞌ ri Kanimajawal Jesucristo, ¿in china riꞌin chaꞌ cankꞌatej ri Dios che uꞌaniquil waꞌ?» xcha ri Pedro. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ecꞌuchiriꞌ xquita tak waꞌ, na jinta chi xquibiꞌij chirij ri Pedro, e xquijek caquiyac ukꞌij ri Dios, jewaꞌ xquibiꞌij: «¡Uyaꞌom ne riꞌ ri Dios chique ri na e ta aj judiꞌab caquitzelej quitzij chwach chaꞌ jelaꞌ cꞌo quicꞌaslemal!» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Rucꞌ rucamic ri Esteban, xjeker quiternabexic rucꞌ cꞌax janipa ri quicojom rubiꞌ ri Cristo. E tak cꞌu riꞌ waꞌ xequich bi y xebopon cꞌa chupa tak ri tinamit re Fenicia, re Chipre y ri tinamit Antioquía. Yey xew xquitzijoj can ri Utzilaj Tzij re ri Jesucristo chique ri e aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chiquixoꞌl cꞌu wa hermanos e cꞌo e aj Chipre y e aj Cirene. Ecꞌu rique echiriꞌ xeboc Antioquía, xquijek caquitzijoj ri Utzilaj Tzij re ri Kanimajawal Jesucristo chique ri na e ta aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yey ruchukꞌab ri Kanimajawal lic cꞌo paquiwi rique. Lic cꞌu e qꞌui ri ticawex xquicoj rubiꞌ ri Cristo y xquijalcꞌatij ri quibinic. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ri quicojom rubiꞌ ri Cristo e cꞌo Jerusalem, echiriꞌ xquita waꞌ, xquitak bi ri Bernabé chaꞌ queꞌec cꞌa chilaꞌ Antioquía. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Echiriꞌ xopon ri Bernabé y xril ri unimal rutzil ucꞌuꞌx ri Dios cucꞌ ri quicojom rubiꞌ ri Cristo, lic xquiꞌcot che. Y xebupixabaj conoje chaꞌ rucꞌ ronoje quicꞌuꞌx caquichukꞌubej quib chwach ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ri Bernabé e jun achi lic utz ucꞌuꞌx, ruchukꞌab ri Santowilaj Ruxlabixel ri Dios lic cꞌo rucꞌ y lic cꞌo cubulibal ucꞌuꞌx. Ruma cꞌu ruchac rire, lic e qꞌui ri ticawex xquicoj rubiꞌ ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tecꞌuchiriꞌ, ri Bernabé xeꞌec pa ri tinamit Tarso re cuꞌtzucuj ri Saulo. Echiriꞌ xuriko, xucꞌam lo Antioquía. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Xecꞌojiꞌ cꞌu cucꞌ ri tinamit re ri Cristo ronoje ri jun junab, e riꞌ quecꞌutun chiquiwach uqꞌuiyal winak. Chiriꞌ cꞌu riꞌ, nabe laj xbiꞌx “cristianos” chique ri quicojom rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chupa tak riꞌ laꞌ la kꞌij e cꞌo jujun ekꞌalajisay runaꞌoj ri Dios xebel bi Jerusalem y xebopon Antioquía. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Cꞌo jun chique waꞌ, Ágabo rubiꞌ. Rire xyactajic y ruma ri Ruxlabixel ri Dios, xukꞌalajisaj cape jun unimal numic chwi ronoje ruwachulew pa ejekel wi ri winak. (Waꞌ xuꞌana chupa rutakanic ri Claudio.) ");
INSERT INTO acrTNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ruma cꞌu waꞌ, ri quicojom rubiꞌ ri Cristo e cꞌo Antioquía xquiyijbaꞌ chiquiwach chaꞌ caquitak pan toꞌbal chique ri hermanos ejekel Judea; chiquijujunal cꞌu riꞌ xquichꞌob rakan janipa ri caquiyaꞌo, waꞌ e chirij tak ri cꞌo cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Y jelaꞌ xquiꞌano; xquitak bi ri quikasaꞌn paquikꞌab ri Bernabé y ri Saulo chaꞌ caquicꞌam bi Judea y caquiya chique ri e aj wach re riglesia. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chupa tak cꞌu riꞌ laꞌ la kꞌij ri rey Herodes xebutak jujun soldados chaꞌ quequichap jujun chique ri quicojom rubiꞌ ri Cristo re queyaꞌ pa cꞌaxcꞌobic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yey xebutak che caquicamisaj rucꞌ espada ri Jacobo ri ratzixel ri Juan. Y ri soldados jelaꞌ xquiꞌano. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ecꞌuchiriꞌ xrilo lic xucꞌul quicꞌuꞌx raj judiꞌab ri xꞌan che ri Jacobo, xutak uchapic ri Pedro. Waꞌ xuꞌan chupa ri nimakꞌij Pascua echiriꞌ catij ri pam na jinta levadura che. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ecꞌuchiriꞌ chapom chi ri Pedro, ri Herodes xutzꞌapij pa cárcel y xuya paquikꞌab cajib mutzaꞌj soldados re caquichajij, yey wa soldados e cajcaj chujujunal mutzaꞌj. Ri xuchꞌob ri Herodes e cꞌate caresaj lo ri Pedro chiquiwach ri winak re ri tinamit echiriꞌ icꞌowinak chi ri nimakꞌij Pascua. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Cꞌo cꞌu riꞌ ri Pedro pa cárcel lic chajital chi utz. Yey ri quicojom rubiꞌ ri Cristo na quebuxlan ta che uꞌanic orar chwach ri Dios puwiꞌ rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chupa cꞌu rakꞌab chwach pan ri kꞌij echiriꞌ ri rey Herodes uchꞌobom caresaj lo ri Pedro chiquiwach ri tinamit, ri Pedro e riꞌ cawar chiquixoꞌl caꞌib soldados, ximital rucꞌ caꞌib carena yukul lo chique ri soldados. Yey pa rewi raj chajal e cꞌo chwach ri oquibal re ri cárcel. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Xakicꞌateꞌt cꞌut xwinakir jun ángel re ri Kanimajawal rucꞌ, yey jun akꞌ lic xutzij upa ri cárcel. Ri ángel xuyuchꞌuyaꞌ ri Pedro pucꞌalcꞌaꞌx, xucꞌosoj y jecꞌuwaꞌ xubiꞌij che: «Chatwaꞌlijok, chawilij» xcha che. E tak cꞌu ri carena cꞌo che rukꞌab ri Pedro xtzakic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Xubiꞌij cꞌu ri ángel che: «Chaximilaꞌ bi racoton y raxajab» xcha che. Y rire jelaꞌ xuꞌano. Xubiꞌij tanchi ri ángel che: «Chacojo bi rakꞌuꞌ re pisbal awij y chat-tereja lo chwij» xcha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ri Pedro xel bi teran chirij ri ángel, tob na retaꞌam taj we katzij ri cuꞌan ri ángel rucꞌ; ma chwach rire, laj xa wachicꞌ la catajin che rilic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xebicꞌow cꞌu chiquiwach ri nabe mutzaꞌj e chajinel. Tecꞌuchiriꞌ, xebicꞌow che rucaꞌm mutzaꞌj e chajinel y xebopon cꞌu chwach ri oquibal ꞌanom rucꞌ chꞌichꞌ, waꞌ e ri quel bi pa be chupa ri tinamit. Waꞌ wa oquibal utuquel xjakataj chiquiwach y jelaꞌ xebel bi. Xebin cꞌu jubikꞌ che ri be y xakicꞌateꞌt ri ángel xuya can ri Pedro utuquel. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Cꞌa ecꞌuchiriꞌ ri Pedro xumaj usucꞌ na wachicꞌ ta ri cuꞌano. Xubiꞌij cꞌu chiribil rib: «Woꞌora pakatzij wi, canmaj usucꞌ e ri Kanimajawal utakom lo ru ángel wucꞌ. Jelaꞌ xinresaj pukꞌab ri rey Herodes y che ronoje ri cacaj caquiꞌan ruqꞌuiyal e aj judiꞌab chwe» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ecꞌu laꞌ catajin waꞌ pujolom ri Pedro, xeꞌec chirocho ri María ruchu ri Juan, ri cabiꞌx Marcos che. Chiriꞌ quimolom wi quib uqꞌuiyal hermanos quetajin pa oración chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Echiriꞌ ri Pedro xuchꞌawisaj pan ri puerta re ruwa ja, jun ali aj chac Rode rubiꞌ, xel lo che. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ecꞌuchiriꞌ xuto e ukul ri Pedro, ruma ruquiꞌcotemal na xujak ta ri puerta. Ri xuꞌano e canic xoc tanchi ubi pa ja y xuꞌtzijoj chique cꞌo ri Pedro chwach ri puerta. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ecꞌu ri e cꞌo pa ja xquibiꞌij che: —Riꞌat xatchꞌuꞌjeric —xecha che. Pero rali xujiquibaꞌ uwach chique lic katzij la cubiꞌij. Yey xquibiꞌij rique: —Laj e u ángel ri cꞌo chiriꞌ —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ecꞌu ri Pedro lic chac cꞌo che uchꞌawisaxic pan ri puerta. Ecꞌuchiriꞌ xquijako yey xquil ri Pedro, lic xcam canimaꞌ che; ma lic cꞌayew chique caquicojo we katzij ri quetajin che rilic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero ri Pedro xuꞌan jun cꞌutubal rucꞌ rukꞌab chaꞌ quetzꞌincaꞌnic. Xutzijoj cꞌu chique suꞌanic xesax lo ruma ri Kanimajawal chupa ri cárcel. Yey xubiꞌij cꞌu chique: —Tzijoj alak waꞌ che ri Jacobo y chique tak ri hermanos —xchaꞌ. Tecꞌuchiriꞌ, xel bi y xeꞌec pa jun chic luwar. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Echiriꞌ xsakiric, xoc jun sachibal naꞌoj chiquixoꞌl ri soldados. Xquijek quetucuquic ruma na quetaꞌam taj saꞌ ri xuꞌan ri Pedro, ma na jinta chic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ecꞌu ri Herodes xutak utzucuxic ri Pedro. Yey ruma na xrikitaj taj, e xuta quichiꞌ ri soldados; tecꞌuchiriꞌ, xutak quicamisaxic. Echiriꞌ xuꞌan waꞌ, ri Herodes xel bi Judea y xeꞌec pa ri tinamit Cesarea y chiriꞌ xcanaj wi. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ri rey Herodes lic cꞌo royowal chiquij ri winak e aj Tiro y e aj Sidón. Ecꞌu riꞌ wa queb tinamit xquichꞌaꞌbej quib chiquiwach re quebeꞌchꞌaꞌta rucꞌ ri rey Herodes chaꞌ caquiꞌan utzil chomal chiquiwach rucꞌ. Cꞌo cꞌu jun achi Blasto rubiꞌ, waꞌ raj chac ri rey yey lic cꞌo uwach pa ri rocho ri rey. Xquicoj cꞌu quib chwach ri Blasto y xquipuakij che chaꞌ rire cachꞌaw paquiwiꞌ chwach ri rey chaꞌ na jinta chi chꞌaꞌoj chiquiwach. Y jelaꞌ raj cꞌay re rutinamit ri Herodes utz caquicꞌayij ri cajawax chique ri e aj Tiro y aj Sidón. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ri rey Herodes xucoj cꞌu jun kꞌij chique re caquimol quib. Laꞌ la jun kꞌij xuwik rib rucꞌ chomilaj cꞌul qꞌui rajil, xtzꞌuyiꞌ pa ri kꞌatbal tzij y xuya cꞌu jujun uchꞌaꞌtem chiquiwach ri tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ecꞌu ri winak xquijeko lic co quesiqꞌuinic caquibiꞌij: «¡Waꞌ wa cakato, na ukul ta juna achi; e ukul jun tiox!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Xa pa jokꞌotaj cꞌu riꞌ jun ángel re ri Kajawal xucoj lo jun yabil che ri Herodes; ma rire xucꞌul wa yacbal ukꞌij xꞌanic, yey waꞌ xew takal che ri Dios. Jecꞌuriꞌlaꞌ xtijiꞌ cuma amolo y ruma waꞌ xcamic. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Noꞌj cꞌu ri Utzilaj Tzij re ri Kanimajawal lic xeꞌec utzijoxic y lic catajin quiqꞌuiyaric ri quecojow re. ");
INSERT INTO acrTNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Echiriꞌ ri Bernabé y ri Saulo xquiqꞌuis ri chac yaꞌom chique, xebel chiriꞌ Jerusalem y xquicꞌam bi ri Juan cucꞌ, ri cabiꞌx Marcos che. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chilaꞌ Antioquía chiquixoꞌlibal ri quicojom rubiꞌ ri Cristo, e cꞌo ekꞌalajisay runaꞌoj ri Dios y e cꞌutunel re Rutzij. Waꞌ e: ri Bernabé, ri Simón ri cabiꞌx kꞌek che, ri Lucio aj Cirene, ri Manaén ri xqꞌuiyisax pa rocho ri Herodes ri rey re Galilea y ri Saulo. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Cꞌo cꞌu jun kꞌij echiriꞌ rique quimolom quib re caquilokꞌnimaj ukꞌij ri Kanimajawal yey e cꞌo pa ayuno, ri Santowilaj Ruxlabixel ri Dios xubiꞌij chique: «Chebichaꞌa ri Bernabé y ri Saulo chwe chaꞌ caquiꞌan ri chac nuyaꞌom chi lo paquikꞌab» xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Echiriꞌ xquiqꞌuis ri oración y ayuno, xquiya ri quikꞌab paquiwi rique y xequitak cꞌu bi. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ecꞌu ri Bernabé y ri Saulo e laꞌ etakom bi ruma ri Santowilaj Ruxlabixel ri Dios, xebopon cꞌu Seleucia. Chiriꞌ xebel bi pa barco y xebec pa ri isla Chipre. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Echiriꞌ xebopon Salamina, jun tinamit re Chipre, xquijek utzijoxic Rutzij ri Dios puwi ri Kanimajawal Jesucristo pa tak sinagogas que raj judiꞌab. Yey cꞌo ri Juan cucꞌ re quitoꞌbel. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xebicꞌow cꞌu chupa ronoje ri isla Chipre y xebopon cꞌa chupa ri tinamit Pafos. Chiriꞌ xquirik jun achi e cuqꞌuil raj judiꞌab; rire aj kꞌij yey e jun kꞌalajisanel xa casocosoꞌnic. Waꞌ waꞌchi Barjesús rubiꞌ, yey pa ri chꞌaꞌtem griego “Elimas” quecha che. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Waꞌ wa aj kꞌij cꞌo rucꞌ ri takanel Sergio Paulo, jun achi lic cꞌo unaꞌoj. Ri takanel xebusiqꞌuij ri Bernabé y ri Saulo, ma lic curayij cuta Rutzij ri Dios puwi ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero rachi aj kꞌij xutij riꞌ che quebukꞌatej ri Bernabé y ri Saulo chaꞌ ri takanel na cucubaꞌ ta ucꞌuꞌx che ri Utzilaj Tzij re ri Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ecꞌu ri Saulo (ri cabiꞌx Pablo che) rucꞌ ruchukꞌab ri Santowilaj Ruxlabixel ri Dios xuchꞌiquibaꞌ ruwach puwi ri Elimas, ");
INSERT INTO acrTNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","y jewaꞌ xubiꞌij che: «¡Rilal lal nojinak che ronoje socosoꞌnic y che ronoje itz! ¡Lal ralcꞌoꞌal ritzel winak, ri jun aj retzelal cꞌuꞌx chirij ronoje ri jusucꞌ! ¿Suꞌchac na cokꞌotaj ta la ri cajechꞌij la ri jusucꞌ be re ri Kanimajawal? ");
INSERT INTO acrTNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ecꞌu woꞌora rukꞌab ri Kanimajawal cayactaj chiꞌij la y cuꞌan potzꞌ cheꞌla; xew cꞌu ri Dios etaꞌmayom janipa kꞌij na quil ta la ri kꞌijsak» xchaꞌ. Na jampatana cꞌut ronoje xuꞌan kꞌekuꞌm chwach y xujek camalal pa tak utzal y chirij, cutzucuj china cacꞌamaw bi che rukꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ecꞌuchiriꞌ ri takanel xril wa xucꞌulumaj ri Elimas, xucoj rubiꞌ ri Kanimajawal Jesucristo, y lic caminak ranimaꞌ che ri cꞌutunic chwi ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ri Pablo junam cucꞌ ri rachbiꞌil xebel bi Pafos pa barco y xebopon Perge pa ri luwar re Panfilia. Pero ri Juan xresaj can rib chiquij y xtzelej Jerusalem. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ecꞌu rique xebicꞌow Perge y xebopon Antioquía pa ri luwar re Pisidia. Chupa cꞌu jun kꞌij re uxlanibal xeboc pa ri sinagoga y xetzꞌuyiꞌic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ecꞌuchiriꞌ ajilam chi jujun che Rutzij Upixab ri Dios tzꞌibital can ruma ri Moisés y cuma ri kꞌalajisanelab, raj wach re ri sinagoga xquitak lo ubiꞌxiquil chique: «Alak katz-kachakꞌ, we cꞌo juna chꞌaꞌtem alak re pixabanic che ri tinamit, chꞌaw alak» xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Xtaqꞌuiꞌ cꞌu ri Pablo y xuꞌan jun cꞌutubal rucꞌ rukꞌab chaꞌ na jinta cꞌo cachꞌawic y xubiꞌij: «Alak achijab aj Israel y onoje alak ri cꞌo xiꞌin ib pa animaꞌ alak chwach ri Dios, tape alak. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ri Dios re wa tinamit Israel xebuchaꞌ ri katiꞌ-kamam ojertan y xuꞌan jun nimalaj tinamit chique echiriꞌ cꞌa e cꞌo Egipto, tob rique na e ta aj chiriꞌ. Rucꞌ cꞌu unimal uchukꞌab riꞌ xeberesaj lo Egipto. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","»Laj juna cuarenta junab cꞌu riꞌ xebucuy ri Dios rutinamit rucꞌ ri quimacunic pa ri luwar catzꞌintzꞌotic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tecꞌuchiriꞌ, xusach quiwach wukub nimak tinamit pa ri luwar re Canaán y xuya cꞌu chique ri katiꞌ-kamam quecanaj can rucꞌ wa ulew. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Laj icꞌowinak chi cajib ciento junab rucꞌ nicꞌaj chwi lo echiriꞌ rutinamit ri Dios xebopon Egipto, cꞌa ecꞌuchiriꞌ xecanaj can pa rulew ubiꞌtisim lo ri Dios chique. »Ecꞌuchiriꞌ, ri Dios xebuya e aj kꞌatal tzij re quetakan paquiwi rutinamit. Jelaꞌ uꞌanom cꞌa chwa ri kꞌalajisanel Samuel. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chupa cꞌu rutakanic ri Samuel, ri tinamit xquitzꞌonoj che ri Dios cuya juna quirey. Ecꞌu ri Dios xucoj ri Saúl paquiwiꞌ. Ri Saúl e ucꞌajol ri Cis, jun achi upetebem chique ri ralcꞌoꞌal can ri Benjamín. Cuarenta junab cꞌu xtakan paquiwiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ecꞌuchiriꞌ ri Dios xresaj ri rey Saúl paquiwiꞌ, e xucoj ri David re catakan pucꞌaxel. Chwi cꞌu ri David lic chom xchꞌaꞌt ri Dios, ma jewaꞌ xubiꞌij: E wilom che ri David rucꞌajol ri Isaí, rire jun achi lic caquiꞌcot nucꞌuꞌx rucꞌ ma cuya ranimaꞌ cuꞌano janipa ri cantak che xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","»Ecꞌu chirij rubiꞌtisim lo chique ri e ralcꞌoꞌal can ri David, ri Dios e xuyac ri Jesús re Colobenel que raj Israel. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Echiriꞌ ri Jesús cꞌamajaꞌ cujek ri chac takom lo che uꞌanic chiquiwach ri winak, xtzijon ri Juan puwi ri bautismo re tzelebal tzij chique conoje ri tinamit Israel. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ecꞌuchiriꞌ ri Juan catajin che uqꞌuisic ruchac, xubiꞌij: “Chiwach riꞌix ¿in china riꞌin? Riꞌin na in ta ri Colobenel oyeꞌem alak. Noꞌj catajin cꞌu lo ucꞌunic Jun chwij, yey riꞌ na takal tane chwe riꞌin canquir ruxajab che ri rakan” xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","»Alak katz-kachakꞌ, alak ralcꞌoꞌal can ri Abraham y onoje alak ri cꞌo xiꞌin ib ucꞌ alak chwach ri Dios, che cꞌu ralak takom wi lo ri Utzilaj Tzij re colobetajic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yey ri ejekel Jerusalem cucꞌ ri e aj wach que, na xquetaꞌmaj taj ri Jesús e Uchaꞌoꞌn lo ri Dios y na xquimaj tane usucꞌ ri tzꞌibital can cuma ri kꞌalajisanelab puwi ri Jesús, tob waꞌ cacajilaj ronoje kꞌij re uxlanibal. Yey echiriꞌ rique xquitzꞌonoj rucamic ri Jesús, e xquiꞌan cꞌu ri tzꞌibital can puwi Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Y tob na jinta cꞌo xquirik chirij ri Jesús re cacamisaxic, xquitzꞌonoj che ri Pilato cutak ucamisaxic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Echiriꞌ xquiqꞌuis uꞌanic rucꞌ ri Jesús janipa ri tzꞌibital can puwi Rire, xquikasaj lo chwa ri cruz y xeꞌquimukuꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","»Pero ri Dios xucꞌastajisaj lo ri Jesús chiquixoꞌl ri ecaminak. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tecꞌuchiriꞌ, ri Jesús uqꞌuiyal kꞌij xucꞌut uwach chiquiwach ri xerachbilaj chwi echiriꞌ xebel lo Galilea y xebec rucꞌ cꞌa Jerusalem. E tak cꞌu riꞌ waꞌ ri quetzijow re ri Jesús chiquiwach ri tinamit woꞌora. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","»Jecꞌulaꞌ riꞌoj cakatzijoj che alak ri Utzilaj Tzij, ri biꞌtisim lo chique ri katiꞌ-kamam ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yey wa biꞌtisinic yaꞌom chi chike riꞌoj ri oj calcꞌoꞌal can rique. Ma ri Dios xuꞌan waꞌ echiriꞌ xucꞌastajisaj lo ri Jesús chiquixoꞌl ri ecaminak, jelaꞌ pachaꞌ ri tzꞌibital chupa rucaꞌm Salmo: Riꞌat at Nucꞌajol yey Riꞌin in Akaw; wakꞌij cꞌu riꞌ cankꞌalajisaj waꞌ cachaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","»Yey ri Dios ubiꞌim cucꞌastajisaj lo ri Jesús chiquixoꞌl ri ecaminak chaꞌ jelaꞌ rucuerpo na cakꞌay taj, ma jewaꞌ xubiꞌij pa Ruchꞌaꞌtem puwi waꞌ: Cancꞌut na ri cꞌaxnaꞌbal nucꞌuꞌx chiwach, jelaꞌ pachaꞌ ri nubiꞌtisim lo che ri David. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E uwariꞌche jewaꞌ cubiꞌij pa jun chic Salmo: Rilal na caya ta la luwar che cakꞌay rucuerpo ri Jun lic uyaꞌom rib pakꞌab la xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","»Ma pakatzij wi ri David xuꞌan ri xraj ri Dios rucꞌ echiriꞌ cꞌo che ruwachulew, pero xopon ri kꞌij xcamic y xmuk pa emukum wi ruchu-ukaw, y rucuerpo xkꞌayic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Noꞌj rucuerpo ri Jun ri xucꞌastajisaj bi ri Dios, na xkꞌay taj. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","»Chetaꞌmaj cꞌu alak waꞌ, alak watz-nuchakꞌ: Ruma ri xuꞌan ri Cristo, catzijox che alak suꞌanic carik alak ri cuybal mac chwach ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ruma cꞌu ri Cristo, conoje ri cacubiꞌ quicꞌuꞌx rucꞌ Rire, caꞌaniꞌ jusucꞌ chique. Yey waꞌ na carikitaj ta cꞌana ruma ri catakex ri Tzij Pixab tzꞌibital can ruma ri Moisés. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","»Chajij cꞌu ib alak chaꞌ na cape ta pawiꞌ alak ri ubiꞌim lo ri Dios chupa ri tzꞌibital can cuma ri kꞌalajisanelab: ");
INSERT INTO acrTNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Chiwilapeꞌ, ix aj chꞌaminel re ri Nutzij, lic cacam na cꞌu iwanimaꞌ che y casach ne iwach ruma waꞌ: Riꞌin canꞌan jun chac chupa tak wa kꞌij ix cꞌo wi, jun chac na quicoj taj, tob ne cꞌo junok catzijow re chiwe xcha ri Dios.» Rucꞌ waꞌ xuqꞌuisbej ri Pablo. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ecꞌuchiriꞌ ri Pablo y ri Bernabé xebel bi pa ri sinagoga, ri e cꞌo chiriꞌ xebelaj chique chaꞌ ri jun chic kꞌij re uxlanibal quechꞌaꞌt cucꞌ rique chwi tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Echiriꞌ xebel bi conoje ri quimolom quib pa ri sinagoga, e qꞌui xeterej bi chiquij ri Pablo y ri Bernabé. Chiquixoꞌl waꞌ e cꞌo raj judiꞌab y jujun chic quitakem lo ri cꞌutunic que raj judiꞌab (tob na e ta aj judiꞌab, pero lic caquilokꞌoj ukꞌij ri Dios). Ecꞌu ri Pablo y ri Bernabé lic xequipixabaj chaꞌ quetiquiꞌ chupa ri unimal rutzil ucꞌuꞌx ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chupa cꞌu ri jun chic kꞌij re uxlanibal, ya laj conoje ri winak re ri tinamit xquimol quib chaꞌ caquita Rutzij ri Dios puwi ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero echiriꞌ raj judiꞌab xequil ruqꞌuiyal winak, xujek catiꞌtot quicꞌuꞌx chirij ri Pablo. Y xquijek cꞌu caquicꞌulaliꞌaj uwach ronoje ri cubiꞌij rucꞌ cꞌaxlaj chꞌaꞌtem. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ecꞌuchiriꞌ, ri Pablo y ri Bernabé, rucꞌ unimal quichukꞌab, xquibiꞌij chique: —Pakatzij wi lic chirajawaxic nabe na catzijox che ralak ri alak aj judiꞌab Rutzij ri Dios puwi ri Kanimajawal. Pero ruma cꞌu ri na cacꞌul ta alak, jelaꞌ cakꞌalajinic na takal ta ri cꞌaslemal na jinta utakexic che alak. Ruma cꞌu laꞌ queꞌkatzijoj chique ri na e ta aj judiꞌab, ");
INSERT INTO acrTNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ma jelaꞌ ri ojutakom lo ri Dios Kajawxel che uꞌanic. E pachaꞌ ri ubiꞌim lo Rire echiriꞌ xubiꞌij: Riꞌin atnucojom re Kꞌijsak chiquiwach tak ri tinamit chaꞌ jelaꞌ cuꞌana at cꞌamal bi re ri colobetajic cꞌa pa tak ri luwar lic naj che ruwachulew —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Echiriꞌ xquita waꞌ ri na e ta aj judiꞌab, lic xequiꞌcot che y xquijeko caquiyac ukꞌij ri Utzilaj Tzij puwi ri Kanimajawal. Jecꞌulaꞌ xquicoj rubiꞌ ri Cristo conoje ri echaꞌom chi ulok re cacꞌojiꞌ quicꞌaslemal na jinta utakexic. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Y xeꞌec utzijoxic ri Utzilaj Tzij puwi ri Kanimajawal chupa tak ronoje wa luwar. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Noꞌj raj judiꞌab xquicoj pa quijolom raj wach re ri tinamit y jujun ixokib lic cꞌo quiwach yey quitakem ri tzijpixab que raj judiꞌab, chaꞌ quequiternabej rucꞌ cꞌaxcꞌobic ri Pablo y ri Bernabé. Jecꞌulaꞌ riꞌ xebequesaj bi pa wa tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ecꞌu ri Pablo y ri Bernabé xquipupaꞌ can rulew che ri cakan, cꞌutubal re ri na utz taj xquiꞌan ri e aj chilaꞌ y xebec cꞌu pa ri tinamit Iconio. ");
INSERT INTO acrTNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero ri quicojom rubiꞌ ri Cristo chilaꞌ Antioquía lic cꞌo quiꞌcotemal cucꞌ yey ri Santowilaj Ruxlabixel ri Dios lic cꞌo cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chilaꞌ cꞌut chupa ri tinamit Iconio, ri Pablo y ri Bernabé junam xeboc chupa ri sinagoga que raj judiꞌab. Ruma cꞌu ri Utzilaj Tzij xquitzijoj, lic e qꞌui ri e aj judiꞌab y ri na e ta aj judiꞌab xquicoj rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Noꞌj ri e aj judiꞌab ri na caquicoj ta ri Utzilaj Tzij, xquitic oyowal pa canimaꞌ ri na e ta aj judiꞌab yey xequituc waꞌ wa winak chaꞌ queyactaj chiquij ri quicojom rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na rucꞌ ta cꞌu riꞌ, lic naj xecꞌojiꞌ ri Pablo y ri Bernabé chiriꞌ y na caquixiꞌij ta cꞌana quib quechꞌaꞌt chiquiwach conoje. Ecꞌu ri Kanimajawal xujiquibaꞌ uwach ri quichꞌaꞌtem chwi ri unimal rutzil ucꞌuꞌx, ma xuya chique caquiꞌan nimak tak cꞌutubal re ruchukꞌab ri Dios. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ecꞌu ri winak re ri tinamit quijachom quipa; jujun chique equiternabem raj judiꞌab y jujun chic equiternabem ri e takoꞌn re ri Jesús. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ecꞌu ri e aj judiꞌab junam cucꞌ ri na e ta aj judiꞌab xquiꞌan tzij chiquiwach cucꞌ ri e aj wach chaꞌ queyactaj chiquij ri Pablo y ri Bernabé re caquiꞌan cꞌax chique y quequiꞌan paꞌbaj. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Echiriꞌ ri Pablo y ri Bernabé xquetaꞌmaj waꞌ, xebel bi chiriꞌ y xebec pa ri luwar re Licaonia pa tak ri tinamit Listra y ri tinamit Derbe y pa tak ri luwar chunakaj wa queb tinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Y chiriꞌ cꞌu riꞌ caquitzijoj ri Utzilaj Tzij. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Chupa wa tinamit Listra cꞌo jun achi siquirinak ucabichal ri rakan y na bininak ta qꞌuenok ma ralaxibem sic. Waꞌ waꞌchi tzꞌulic, ");
INSERT INTO acrTNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","e riꞌ cutataꞌ ri cubiꞌij ri Pablo. Ecꞌuchiriꞌ ri Pablo xuchꞌiquibaꞌ ruwach puwiꞌ y xrilo cꞌo cubulibal ucꞌuꞌx chaꞌ cacunutajic, ");
INSERT INTO acrTNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","lic co xubiꞌij che: —¡Chatyactajok y chat-tacꞌala jusucꞌ chwi rawakan! —xchaꞌ. Ecꞌu rachi xchꞌoplin chicaj y xbinic. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ecꞌu ri winak echiriꞌ xquilo saꞌ ri xuꞌan ri Pablo, xquijek quesiqꞌuin pa quichꞌaꞌtem rique, waꞌ e ri chꞌaꞌtem re Licaonia. Jewaꞌ caquibiꞌij: «¡Waꞌ e tiox quiꞌanom lo achijab che quib y xekaj lo wara kucꞌ!» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Che ri Bernabé xquibiꞌij e tiox Júpiter, yey che ri Pablo xquibiꞌij e tiox Mercurio ma e rire ri más cachꞌawic. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ecꞌu raj chacunel re ri tiox Júpiter, ri cꞌo rocho pa oquibal lo re ri tinamit, xebucꞌam lo toroꞌib y cotzꞌiꞌj yijbam re wikonic chwach tak ri oquibal re ri templo. Yey junam cucꞌ ruqꞌuiyal winak xcaj quequicamisaj rawaj re quikasaꞌn chiquiwach ri Bernabé y ri Pablo. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Echiriꞌ xquita waꞌ ri queb takoꞌn Bernabé y Pablo, xquirichꞌij ri quikꞌuꞌ y xquimin quib chiquixoꞌl ruqꞌuiyal winak; quesiqꞌuinic jewaꞌ caquibiꞌij: ");
INSERT INTO acrTNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«¡Achijab!, ¿suꞌchac caꞌan alak waꞌ? Ma riꞌoj xa oj achijab junam kawach ucꞌ alak. Wa Utzilaj Tzij cakatzijoj che alak e chaꞌ caya can alak ri na il ta uwach y catzucuj alak ri Dios cꞌaslic, ri xꞌanaw re ruwa caj, ruwachulew, ri mar y ronoje ri cꞌo che tak waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tob rojertan ri Dios xuya luwar chique tak ri tinamit quebin chupa tak ri be cacaj rique, ");
INSERT INTO acrTNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","na rucꞌ ta cꞌu riꞌ, ri Dios na rokꞌotam ta cꞌana ukꞌalajisaxic china Rire ruma tak ri utz cuꞌano. Ma cuya lo ri jab y cuya lo rukꞌijol echiriꞌ lic cꞌo molonic. E Rire ri caꞌanaw re lic cꞌo cakatijo y cꞌo quiꞌcotemal chupa ri kanimaꞌ» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ri Bernabé y ri Pablo, tob quetajin che ubiꞌxiquil waꞌ, lic cꞌayew xequikꞌatej ruqꞌuiyal winak chaꞌ na quequicamisaj ta rawaj re kasaꞌn chiquiwach rique. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chupa cꞌu laꞌ laꞌ jokꞌotaj xecꞌun lo jujun aj judiꞌab e aj pa ri tinamit Antioquía y ri tinamit Iconio. Rique xquicoj pa quijolom ruqꞌuiyal winak caquiꞌan ri Pablo paꞌbaj. Y ecꞌu xquiꞌano. Tecꞌuchiriꞌ, xquichararej bi ri Pablo tzaꞌm tinamit. E chiquiwach rique, caminak chic. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero echiriꞌ ri quicojom rubiꞌ ri Cristo xquisut rij ri Pablo, rire xyactajic y xoc tanchi chupa ri tinamit. Chucaꞌm kꞌij xel bi rucꞌ ri Bernabé y junam xebec pa ri tinamit Derbe. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Xquitzijoj cꞌu ri Utzilaj Tzij chupa wa tinamit y uqꞌuiyal ticawex xquicoj rubiꞌ ri Cristo. Tecꞌuchiriꞌ, xetzelej tanchi lo chupa ri tinamit Listra, ri tinamit Iconio y ri tinamit Antioquía. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Xquinimarisaj cꞌu can quicꞌuꞌx ri hermanos y lic xequipixabaj chaꞌ catiquiꞌ chi utz ri cubulibal quicꞌuꞌx rucꞌ ri Jesús, jewaꞌ caquibiꞌij chique: «Lic chirajawaxic rucꞌ uqꞌuiyal cꞌaxcꞌobic cojoc chupa rutakanic ri Dios» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yey xequicoj can e aj wach chujujunal tak iglesia. Xquiꞌan cꞌu orar y ayunar cucꞌ. Tecꞌuchiriꞌ, xquitzꞌonoj che ri Kanimajawal quebuchajij janipa ri lic cubul quicꞌuꞌx rucꞌ Rire. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Xebicꞌow cꞌu pa tak ri luwar re Pisidia y xebopon pa ri luwar re Panfilia. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Xquitzijoj cꞌu ri Utzilaj Tzij chupa ri tinamit Perge. Tecꞌuchiriꞌ, xquimaj bi pa ri tinamit Atalia. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chiriꞌ cꞌu riꞌ xquimaj bi pa barco y xetzelej Antioquía. Waꞌ e ri tinamit pa xtzꞌonox wubi rutoꞌbal ri Dios paquiwi ri Pablo y ri Bernabé chaꞌ caquiꞌan ri chac yaꞌom paquikꞌab, yey waꞌ wa chac quiqꞌuisom chi rique. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Echiriꞌ xeboponic, xequimol quichiꞌ conoje ri quicojom rubiꞌ ri Cristo y xquitzijoj cꞌu chique ronoje ri xuꞌan ri Dios cucꞌ y suꞌanic xuya chique ri na e ta aj judiꞌab quebuꞌan xa jun cucꞌ ri quicubam quicꞌuꞌx rucꞌ ri Kanimajawal Jesucristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xecanaj cꞌu can chiriꞌ uqꞌuiyal kꞌij cucꞌ ri quicojom rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chupa tak riꞌ laꞌ la kꞌij xebopon Antioquía jujun achijab e petinak Judea y xquijek quecꞌutun chiquiwach ri quicojom rubiꞌ ri Cristo, jewaꞌ caquibiꞌij: «We na cacoj ta ri retalil re circuncisión che alak jelaꞌ pachaꞌ rutakanic can ri Moisés, riꞌ na cacolobetaj ta alak» quechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ecꞌu ri Pablo y ri Bernabé lic xebec chunimal puwi wa cꞌutunic cucꞌ waꞌchijab. Qꞌuisbal re, conoje xquichꞌob rakan saꞌ ri caquiꞌano; e quetak bi ri Pablo y ri Bernabé cucꞌ jujun chic chaꞌ quebec Jerusalem re quebeꞌchꞌaꞌt chwi waꞌ cucꞌ ri e takoꞌn re ri Jesús y jujun chic e aj wach re riglesia. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","E tak cꞌu ri etakom bi cuma riglesia re Antioquía, xebicꞌow pa tak ri tinamit re Fenicia y re Samaria, y chujujunal luwar xquitzijoj suꞌanic ri na e ta aj judiꞌab quiyaꞌom can ri quibinic re ojertan chaꞌ e caquitakej ri Dios. Ruma cꞌu riꞌ waꞌ, conoje ri hermanos xetaw re, lic xequiꞌcot che. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Echiriꞌ xebopon Jerusalem, xecꞌul cuma tak ri hermanos, ri e takoꞌn y jujun chic e aj wach re riglesia. Xquitzijoj cꞌu chique ronoje ri uꞌanom ri Dios cucꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero e cꞌo jujun chique ri quicojom rubiꞌ ri Cristo e cuqꞌuil ri aj fariseos, rique xeyactajic y jewaꞌ xquibiꞌij: —Lic chirajawaxic cacoj ri retalil re circuncisión chique tak ri na e ta aj judiꞌab caquicoj rubiꞌ ri Dios yey quetak che caquiꞌan janipa ri cubiꞌij ri Tzij Pixab re ri Moisés —xechaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Xquimol cꞌu quib ri e takoꞌn y jujun chic e aj wach re riglesia chaꞌ quechꞌaꞌt chwi waꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lic naj cꞌut xquichapalaꞌ quib chiquiwach puwi waꞌ. Tecꞌuchiriꞌ, ri Pedro xyactajic y xubiꞌij chique: —Hermanos achijab, ralak etaꞌam alak jampa chi lo kꞌij waꞌ icꞌowinak chwi xinuchaꞌ lo ri Dios chaꞌ chi nuchiꞌ riꞌin, ri na e ta aj judiꞌab caquita ri Utzilaj Tzij y caquicoj cꞌu rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ri Dios, ri retaꞌam saꞌ ri cꞌo chupa ri canimaꞌ ri ticawex, e xcꞌuluw que ri na e ta aj judiꞌab quicojom rubiꞌ ri Cristo. Yey xucꞌut waꞌ echiriꞌ xuya lo ri Santowilaj Ruxlabixel chique rique jelaꞌ pachaꞌ xuꞌan kucꞌ riꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Y junam xeril rique kucꞌ riꞌoj, ma xujoskꞌij ri canimaꞌ che ri mac ruma ri cubulibal quicꞌuꞌx. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","»Ecꞌu woꞌora, ¿suꞌchac capetisaj alak royowal ri Dios ruma ri queya alak chuxeꞌ uqꞌuiyal takanic ri na e ta aj judiꞌab quicojom rubiꞌ ri Cristo? Waꞌ e pachaꞌ ekaꞌn cacoj alak chiquikul. Yey wa ekaꞌn, na xquichꞌij tane rucꞌaxic ri katiꞌ-kamam ojertan y na kachꞌijom tane rucꞌaxic riꞌoj. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Noꞌj cꞌu riꞌoj e cakajiquibaꞌ uwach waꞌ: Xa ne ruma ri unimal rutzil ucꞌuꞌx ri Kanimajawal Jesús cojcolobetaj riꞌoj jelaꞌ pachaꞌ rique —xchaꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Conoje cꞌu riꞌ ruqꞌuiyal ticawex xetzꞌincaꞌnic y xquiya quixiquin chique ri Bernabé y ri Pablo, ma caquitzijoj ri nimak tak cꞌutubal re chukꞌab uꞌanom ri Dios cuma rique chiquixoꞌl ri na e ta aj judiꞌab. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Echiriꞌ xquiqꞌuis quechꞌaꞌt rique, ri Jacobo jewaꞌ xubiꞌij: —Hermanos, chinta na pe alak: ");
INSERT INTO acrTNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ri Simón xutzijoj puwi ri nabe laj echiriꞌ ri Dios xukꞌalajisaj rib chiquiwach ri na e ta aj judiꞌab chaꞌ chiquixoꞌl rique quebuchaꞌ janipa ri quebuꞌana utinamit. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Y waꞌ cuꞌana xaki jun rucꞌ ri quitzꞌibam can ri kꞌalajisanelab puwi ri ubiꞌim lo ri Dios: ");
INSERT INTO acrTNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Icꞌowinak cꞌu waꞌ, quintzelej lok y canyac tanchi ri rocho ri rey David wuluwubinak bi, cancꞌojoj cꞌu ri tzakinak bi che y canꞌan cꞌacꞌ che. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Canꞌan waꞌ chaꞌ ri nicꞌaj chic ticawex caquitzucuj ri Dios, waꞌ e tak ri tinamit na e ta aj judiꞌab, conoje ri e nuꞌanom nutinamit chique ma quicojom ri nubiꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","E waꞌ ri xubiꞌij ri Dios Kajawxel, yey e ri ukꞌalajisam chi lo ojertan. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ruma cꞌu laꞌ, chinuwach riꞌin na utz taj we cakasachisaj quinaꞌoj ri na e ta aj judiꞌab quicojom rubiꞌ ri Kanimajawal. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ri kaꞌanaꞌ e chojtzꞌiban pan chique y kayaꞌa pan quinaꞌoj chaꞌ caquesaj quib che tak ri cachꞌulan re junok pachaꞌ tak ri icꞌowisam chwa juna tiox, chaꞌ na caquetzꞌabej ta uwa quikꞌij cucꞌ jujun chic na quicꞌulel taj, chaꞌ na caquitij ta tiꞌij que awaj xa ejitzꞌam y chaꞌ na caquitij ta quicꞌ. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ma xex wi chwi lo ojertan, ronoje kꞌij re uxlanibal pa tak sinagogas e cꞌo ri quebajilan re y quetzijon puwi ri Tzij Pixab tzꞌibital can ruma ri Moisés —xcha ri Jacobo. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","E tak ri e takoꞌn y ri jujun chic e aj wach re riglesia cucꞌ conoje ri hermanos, xucꞌul quicꞌuꞌx ri quechaꞌ jujun achijab chiquixoꞌlibal re quetak bi pa ri tinamit Antioquía rucꞌ ri Pablo y ri Bernabé chaꞌ caquicꞌam bi jun carta re pixabanic chique ri na e ta aj judiꞌab quicojom rubiꞌ ri Cristo. Ecꞌu xequichaꞌ ri Judas ri cabiꞌx Barsabás che y ri Silas, ma lic chom ilitajinak ri quibinic quisilabic chiquiwach ri hermanos. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Xyaꞌ cꞌu bi ri carta paquikꞌab, jewaꞌ cubiꞌij: E riꞌoj oj takoꞌn re ri Cristo cucꞌ ri e aj wach re riglesia y conoje ri hermanos wara Jerusalem, cakaya pan rutzil wach alak hermanos, ri cꞌo alak chupa ri tinamit Antioquía y pa tak ri tinamit re Siria y re Cilicia. Cakatzꞌibaj cꞌu che ralak, ri na alak ta aj judiꞌab yey cojom alak rubiꞌ ri Cristo. ");
INSERT INTO acrTNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Riꞌoj katom e cꞌo jujun ebelinak chikaxoꞌl ri