﻿USE sofia;
DROP TABLE IF EXISTS sofia.acrNNT_vpl;
CREATE TABLE acrNNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acrNNT_vpl WRITE;
INSERT INTO acrNNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ri Qanimajawal Jesucristo e ralkꞌoꞌal kan ri David y ralkꞌoꞌal kan ri Abraham. E ri kipetebꞌem lo che ri Abraham e taq waꞌ: ");
INSERT INTO acrNNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ri ralkꞌoꞌal ri Abraham, Isaac rubꞌiꞌ; ri ralkꞌoꞌal ri Isaac, Jacob rubꞌiꞌ; taq ri ralkꞌoꞌal ri Jacob, e ri Judá kukꞌ ri ratz-uchaqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Taq ri ralkꞌoꞌal ri Judá, e ri Fares y ri Zara yey rubꞌiꞌ ri kichu e Tamar; ri ralkꞌoꞌal ri Fares, Esrom rubꞌiꞌ; ri ralkꞌoꞌal ri Esrom, Aram rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ri ralkꞌoꞌal ri Aram, Aminadab rubꞌiꞌ; ri ralkꞌoꞌal ri Aminadab, Naasón rubꞌiꞌ; ri ralkꞌoꞌal ri Naasón, Salmón rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Ri ralkꞌoꞌal ri Salmón, Booz rubꞌiꞌ yey ruchu ri Booz e Rahab. Ri ralkꞌoꞌal ri Booz, Obed rubꞌiꞌ yey rubꞌiꞌ ruchu ri Obed e Rut. Ri ralkꞌoꞌal ri Obed, Isaí rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Ri ralkꞌoꞌal ri Isaí, e ri rey David y ri ralkꞌoꞌal ri David, Salomón rubꞌiꞌ yey ruchu ri Salomón e ri rixoqil ri Urías. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ri ralkꞌoꞌal ri Salomón, Roboam rubꞌiꞌ; ri ralkꞌoꞌal ri Roboam, Abías rubꞌiꞌ; ri ralkꞌoꞌal ri Abías, Asa rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ri ralkꞌoꞌal ri Asa, Josafat rubꞌiꞌ; ri ralkꞌoꞌal ri Josafat, Joram rubꞌiꞌ; ri ralkꞌoꞌal ri Joram, Uzías rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ri ralkꞌoꞌal ri Uzías, Jotam rubꞌiꞌ; ri ralkꞌoꞌal ri Jotam, Acaz rubꞌiꞌ; ri ralkꞌoꞌal ri Acaz, Ezequías rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ri ralkꞌoꞌal ri Ezequías, Manasés rubꞌiꞌ; ri ralkꞌoꞌal ri Manasés, Amón rubꞌiꞌ; ri ralkꞌoꞌal ri Amón, Josías rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Taq ri ralkꞌoꞌal ri Josías, e ri Jeconías kukꞌ ri ratz-uchaqꞌ; rike xebꞌalax chupa taq ri qꞌij echiriꞌ raj Israel xekꞌam bꞌi Babilonia. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Echiriꞌ ekꞌamom chubꞌi Babilonia, xalax jun ralkꞌoꞌal ri Jeconías, Salatiel rubꞌiꞌ; ri ralkꞌoꞌal ri Salatiel, Zorobabel rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Ri ralkꞌoꞌal ri Zorobabel, Abiud rubꞌiꞌ; ri ralkꞌoꞌal ri Abiud, Eliaquim rubꞌiꞌ; ri ralkꞌoꞌal ri Eliaquim, Azor rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Ri ralkꞌoꞌal ri Azor, Sadoc rubꞌiꞌ; ri ralkꞌoꞌal ri Sadoc, Aquim rubꞌiꞌ; ri ralkꞌoꞌal ri Aquim, Eliud rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ri ralkꞌoꞌal ri Eliud, Eleazar rubꞌiꞌ; ri ralkꞌoꞌal ri Eleazar, Matán rubꞌiꞌ; ri ralkꞌoꞌal ri Matán, Jacob rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Y ri ralkꞌoꞌal ri Jacob e ri José, ri rachijil ri María, ruchu ri Jesús. Yey ri Jesús e ri kabꞌiꞌx “Cristo” che. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Jekꞌulaꞌ chi konoje ri tikawex ujeqebꞌem lo chwi ri Abraham kꞌa chwach ri David, xebꞌikꞌow kajlajuj lemaꞌj; chwi lo ri David kꞌa chwach echiriꞌ xekꞌam bꞌi raj Israel pa ri tinamit Babilonia, xebꞌikꞌow kajlajuj lemaꞌj; yey chwi lo echiriꞌ xekꞌam bꞌi raj Israel pa ri tinamit Babilonia kꞌa chwach ri ralaxibꞌal ri Cristo, xebꞌikꞌow kajlajuj lemaꞌj. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Jewaꞌ xuꞌan ri ralaxibꞌal ri Qanimajawal Jesucristo: Ri María, ruchu ri Jesús, unimam chik kakꞌuliꞌ rukꞌ ri José. Ekꞌuchiriꞌ kꞌamajaꞌ kakijunimaj kibꞌ, ri María xkanaj yewaꞌ ixoq ruma ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ri José, ri rachijil ri María, ruma lik jusukꞌ rubꞌinik y ruma na karaj taj kuya ukꞌix ri María chikiwach ri winaq, xraj kꞌut kuya kanoq e laꞌ na jinta kꞌo kenaꞌbꞌen re. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ekꞌuchiriꞌ kuchꞌobꞌ raqan puwi waꞌ, xaqikꞌateꞌt jun ángel re ri Dios xukꞌut ribꞌ pa uwachikꞌ y xubꞌiꞌij che: «José, at ralkꞌoꞌal kan ri David, maxiꞌij awibꞌ che kakꞌam ri María re kuꞌan awixoqil, ma rumatzem rire, ukꞌulum ruma ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Kalax kꞌu jun ralabꞌ y Jesús rubꞌiꞌ kakojo, ma Rire kebꞌukolobꞌej rutinamit che ri kimak» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ronoje waꞌ xuꞌano chaꞌ e kuꞌana janipa ri kubꞌiꞌij Ruchꞌaꞌtem ri Dios echiriꞌ ri qꞌalajisanel re ri Dios xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Chitanapeꞌ: Jun chomilaj qꞌapoj ali kakanaj yewaꞌ ixoq y kalax jun ralabꞌ. Ekꞌu rubꞌiꞌ kabꞌiꞌxik: Emanuel xchaꞌ. Waꞌ keꞌelawi “Dios xoꞌljeqel qukꞌ”. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Ekꞌuchiriꞌ xkꞌun saq chwach ri José, e xuꞌan ri xtaq che ruma ri ángel re ri Dios; xukꞌam kꞌu ri María re rixoqil. ");
INSERT INTO acrNNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Pero xuchajij na ruchomal ri María ma na xkꞌojiꞌ ta rukꞌ kꞌa echiriꞌ xalax na ri ralko ralabꞌ. Y Jesús rubꞌiꞌ xukojo. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ri Jesús xalax chilaꞌ Belén re Judea echiriꞌ e rey ri Herodes. Xebꞌopon kꞌu Jerusalem jujun achijabꞌ e petinaq pa relebꞌal lo ri qꞌij. Rike lik kꞌo kinaꞌoj puwi taq ri chꞌumil. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Jekꞌuwaꞌ kakibꞌiꞌij: —¿Pa kꞌo wi ri rey ke raj judiꞌabꞌ alaxinaq? Ma riꞌoj xqil ruchꞌumil kꞌa pa relebꞌal lo ri qꞌij; yey e waꞌ oj petinaq chaꞌ koꞌlqaloqꞌnimaj uqꞌij —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Echiriꞌ xuta waꞌ ri rey Herodes, lik xsach unaꞌoj che y jelaꞌ xkikꞌulumaj konoje ri winaq e aj Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Xumol kꞌu kichiꞌ konoje ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ y xutzꞌonoj kꞌu chike pa kalax wi ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Rike xkibꞌiꞌij che: —Ri Cristo kalax pa raldea Belén re Judea, ma jewaꞌ utzꞌibꞌam kan ri qꞌalajisanel chupa Ruchꞌaꞌtem ri Dios: ");
INSERT INTO acrNNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Riꞌat Belén at kꞌo pa ri luwar re Judea, tobꞌ lik at chꞌutiꞌn, riꞌat lik kꞌo awach chikiwach raj wach e kꞌo Judea, ma awukꞌ riꞌat kape wi ri Jun Taqanel; ekꞌu Rire kuꞌana chajinel ke ri nutinamit Israel —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ri Herodes ruma ri xuto, xa xeꞌlaqꞌay xebꞌusikꞌij rachijabꞌ e aj naꞌoj puwi taq ri chꞌumil y xutzꞌonoj kꞌu chike jampa xwinaqir waꞌ wa chꞌumil. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Tekꞌuchiriꞌ, xebꞌutaq bꞌi Belén, jewaꞌ xubꞌiꞌij chike: —Oj alaq y lik tzukuj alaq chi utz ri ralko akꞌa. We xriq kꞌu alaq, koꞌlbꞌiꞌij alaq chwe pa kꞌo wi chaꞌ jelaꞌ kinꞌek riꞌin y kiꞌnloqꞌnimaj uqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Tekꞌuchiriꞌ rachijabꞌ e aj naꞌoj xkita ri xubꞌiꞌij ri rey, xkimaj chubꞌi ri kibꞌe. Ekꞌu ri chꞌumil kilom lo kꞌa pa relebꞌal lo ri qꞌij, nabꞌe bꞌi chikiwach y xtakꞌiꞌ kꞌu chwi ri luwar pa kꞌo wi ri ralko akꞌa. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Rike echiriꞌ xkil ri chꞌumil, lik xekiꞌkot che. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Ekꞌuchiriꞌ xebꞌok pa ri ja, xkil ri ralko akꞌa rukꞌ ruchu María. Xexukiꞌik y xkiloqꞌnimaj uqꞌij. Xkijaq kꞌu uchiꞌ ri kikaxa y xkiya taq sipanik che, waꞌ re oro, re incienso y re mirra lik kiꞌ ruxlabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Chaqꞌabꞌ kꞌu riꞌ, xqꞌalajisax chike pa wachikꞌ na ketzelej ta chi pa kꞌo wi ri Herodes. Ruma kꞌu riꞌ, xetzelej pa kitinamit pa jun chik bꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Echiriꞌ rachijabꞌ e aj naꞌoj ebꞌelinaq chubꞌi rukꞌ ri Jesús, xukꞌut ribꞌ jun ángel re ri Dios pa uwachikꞌ ri José y xubꞌiꞌij che: «Chatyaktajoq, chebꞌakꞌama bꞌi rakꞌa y ruchu. Chixanimaj bꞌi kꞌa Egipto y chixkanaja chilaꞌ kꞌate kambꞌiꞌij chiwe jampa kixpetik, ma ri Herodes kutaq utzukuxik rakꞌa chaꞌ kakamisaxik» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Xyaktaj kꞌu bꞌi ri José chaqꞌabꞌ, xebꞌukꞌam bꞌi rakꞌa y ruchu, y xebꞌek Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chilaꞌ kꞌut xekꞌojiꞌ wi kꞌa che rukamik ri Herodes. Xuꞌan kꞌu waꞌ chaꞌ e kuꞌana rubꞌiꞌim lo ri Dios ruma ri qꞌalajisanel echiriꞌ jewaꞌ xubꞌiꞌij: «Kꞌa chilaꞌ Egipto xinsikꞌij wi lo ri Nukꞌajol» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ri Herodes, echiriꞌ xretaꞌmaj xsokosoꞌx kan kuma rachijabꞌ e aj naꞌoj, lik xpe royowal. Ruma kꞌu riꞌ, xutaq kikamisaxik konoje ri raltaq ko chꞌutiꞌq alabꞌo kꞌamajaꞌ kakikꞌis kebꞌ junabꞌ, chike ri e kꞌo Belén y pa taq ri luwar e kꞌo lo chunaqaj. Ekꞌu xukꞌam re riꞌ ri xkibꞌiꞌij ri e aj naꞌoj puwi ruqꞌijol echiriꞌ xwinaqir ri chꞌumil. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Jekꞌulaꞌ e xuꞌana ri tzꞌibꞌital kan ruma ri qꞌalajisanel Jeremías echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Xtataj jun qulaj pa Ramá, oqꞌej y sikꞌ rukꞌ bꞌis. E ri Raquel keroqꞌej ri ralkꞌoꞌal y na karaj tane kabꞌochiꞌix ukꞌuꞌx ruma ri kikamik ri ralkꞌoꞌal xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tekꞌuchiriꞌ kaminaq chi ri Herodes, jun ángel re ri Dios xukꞌut ribꞌ pa uwachikꞌ ri José chilaꞌ Egipto y xubꞌiꞌij che: ");
INSERT INTO acrNNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","«Chatyaktajoq, chebꞌakꞌama bꞌi rakꞌa junam rukꞌ ruchu y chixtzelej tanchi Israel, ma ya xekam konoje ri kakaj kakikamisaj rakꞌa» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Xyaktaj kꞌu ri José, xebꞌukꞌam bꞌi rakꞌa y ruchu, y xtzelej lo Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Pero xuxiꞌij ribꞌ keꞌek Judea, ma xretaꞌmaj e ri Arquelao rukꞌajol ri Herodes ri xkanaj kan rey re Judea pukꞌaxel ruqaw. Ruma kꞌu ri xqꞌalajisax che pa jun chik uwachikꞌ, xumaj bꞌi ubꞌe Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Echiriꞌ xebꞌopon chilaꞌ, xeꞌjeqela pa ri tinamit Nazaret, chaꞌ e xuꞌana ri xkibꞌiꞌij ri qꞌalajisanelabꞌ chwi ri Jesús: “Rire kabꞌiꞌx che aj Nazaret.” ");
INSERT INTO acrNNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xopon ruqꞌijol echiriꞌ ri Juan Aj Yaꞌl Bautismo katzijon pa taq ri luwar katzꞌintzꞌotik re Judea. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Jekꞌuwaꞌ kubꞌiꞌij: «Tzelej tzij alaq chwach ri Dios, ma rutaqanik ri Dios petinaq chilaꞌ chikaj lik xa naqaj chi kꞌo wuloq» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ri qꞌalajisanel Isaías xutzꞌibꞌaj kan puwi waꞌ wa Juan echiriꞌ xubꞌiꞌij: Katataj uqul jun tzijonel kasikꞌin chupa ri luwar katzꞌintzꞌotik, jewaꞌ kubꞌiꞌij: “Yijbꞌaꞌ pana alaq ri bꞌe re ri Qanimajawal; sukꞌupij alaq rubꞌe Rire” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ruqꞌuꞌ ri Juan ukojom ꞌanom rukꞌ rismal camello y rupas ximil che rupa e jun tzꞌuꞌum; ri kutijo e taq ri sakꞌ y uwaꞌal kabꞌ re upa taq juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ri ejeqel pa ri tinamit Jerusalem kukꞌ konoje ri e kꞌo pa ri luwar re Judea y ri ejeqel chuchiꞌ ri nimayaꞌ Jordán, xebꞌel lo che utayik ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Kakitzꞌonoj kꞌu kuybꞌal kimak chwach ri Dios, y ri Juan kuya ri bautismo chike pa ri nimayaꞌ Jordán. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ekꞌu ri Juan echiriꞌ xrilo lik e kꞌi chike ri fariseos y ri saduceos xekꞌun ruma ri bautismo kuyaꞌo, xubꞌiꞌij chike: «¡Ralaq pachaꞌ alaq jupuq chi kumatz! ¿China xbꞌiꞌn re we utz kesaj ibꞌ alaq chwach ri unimal kꞌaxkꞌobꞌik kutaq lo ri Dios pawiꞌ alaq? ");
INSERT INTO acrNNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Bꞌina alaq jusukꞌ chaꞌ jelaꞌ kaqꞌalajinik jalkꞌatim chi ri bꞌinik silabꞌik alaq, jelaꞌ pachaꞌ ri taqal chike ri kitzelem chi kitzij. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","»Y machꞌobꞌ ne alaq chi ibꞌil ibꞌ alaq waꞌ: “Riꞌoj utz qaꞌanom, ma oj ralkꞌoꞌal kan ri Abraham.” Ma riꞌin kambꞌiꞌij che alaq: We xraj ri Dios, utz kuꞌan ralkꞌoꞌal ri Abraham tobꞌ ne che taq waꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Yey jikil chi ne uwach ruqꞌatbꞌal tzij ri Dios pawiꞌ alaq, e pachaꞌ juna achi uyakom chi ri ikaj chwi ri ratzꞌayaq ri cheꞌ; ekꞌu taq ri cheꞌ na kuya ta chomilaj jiqꞌobꞌal, kapoqꞌix bꞌi y kakꞌaq pa aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","»Riꞌin paqatzij wi kanya ri bautismo che alaq rukꞌ yaꞌ, kꞌutubꞌal re tzelem chi tzij alaq chwach ri Dios. Noꞌj kꞌu ri Jun katajin lo chwij riꞌin, kꞌo puqꞌabꞌ kuya ri bautismo che alaq rukꞌ ri Santowilaj Ruxlabꞌixel ri Dios y rukꞌ aqꞌ. Rire más kꞌo uchuqꞌabꞌ chinuwach riꞌin; na taqal tane chwe tobꞌ xa kanmolej ruxajabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Ekꞌu Rire koluꞌqꞌata tzij pakiwi ri tikawex chaꞌ jelaꞌ kuya ri tojbꞌal taqal chike chikijujunal. E pachaꞌ juna achi rukꞌaꞌam chi ri puꞌbꞌal uwach ri trigo puqꞌabꞌ chaꞌ naꞌl kujosqꞌij waꞌ y karesaj rupukꞌ chupa. Tekꞌuchiriꞌ, kujok ri trigo y kukꞌol chupa rukꞌolibꞌal. Ekꞌu rupukꞌ kuporoj pa ri jun aqꞌ na jinta utaqexik katenowik» xcha ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ekꞌuchiriꞌ ri Jesús petinaq Galilea, xopon chuchiꞌ ri nimayaꞌ Jordán chaꞌ ri Juan kuya ri bautismo che. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Pero ri Juan na xraj taj kuya ri bautismo che ri Jesús, jekꞌuwaꞌ xubꞌiꞌij che: —Ri lik usukꞌ e rilal ri kayaꞌw la ri bautismo chwe riꞌin. ¿Yey e kami kaꞌaj la riꞌ kanya riꞌin ri bautismo cheꞌla? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ekꞌu ri Jesús xukꞌul uwach: —E chaꞌana woꞌora saꞌ ri kambꞌiꞌij riꞌin chawe, ma lik chirajawaxik e kaqaꞌan janipa ri lik usukꞌ chwach ri Dios —xchaꞌ. Jekꞌulaꞌ ri Juan xuya ri bautismo che. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Tekꞌuchiriꞌ ri Jesús xukꞌul ri bautismo, xel lo pa ri yaꞌ. Y na jampatana kꞌu riꞌ xjaqataj ruwa kaj y xrilo echiriꞌ ri Ruxlabꞌixel ri Dios xqaj lo puwiꞌ pachaꞌ juna palomax. ");
INSERT INTO acrNNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ekꞌuchiriꞌ, xchꞌaw lo Jun chilaꞌ chikaj, jewaꞌ xubꞌiꞌij: «E Nukꞌajol waꞌ ri lik kꞌax kannaꞌo y lik kinkiꞌkot che» xcha ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Tekꞌuchiriꞌ, ri Jesús xkꞌam bꞌi ruma ri Ruxlabꞌixel ri Dios pa jun luwar katzꞌintzꞌotik chaꞌ kakꞌam upa ruma ritzel winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Ri Jesús xkꞌojiꞌ chilaꞌ yey cuarenta qꞌij y cuarenta aqꞌabꞌ kꞌu riꞌ na jinta kꞌo xutijo. Kꞌisbꞌal re waꞌ xpe numik che. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Xqibꞌ kꞌu ritzel winaq rukꞌ ri Jesús re kukꞌam upa chaꞌ katzaq pa mak, jewaꞌ xubꞌiꞌij che: —We qatzij at Ukꞌajol ri Dios, chat-taqan che chaꞌ taq waꞌbꞌaj kuꞌan wa —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ri Jesús xukꞌul uwach: —Jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Na xew ta ruma ri wa e kꞌas ri tikawex, ma e kꞌaslik ruma ronoje taq chꞌaꞌtem kel lo puchiꞌ ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ekꞌuchiriꞌ, ritzel winaq xukꞌam bꞌi pa ri santowilaj tinamit Jerusalem kꞌa chikaj che ruwi ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Xubꞌiꞌij kꞌu che: —We qatzij at Ukꞌajol ri Dios, chakꞌaqa bꞌi awibꞌ kꞌa chuꞌlew y na jinta kꞌo kakꞌulumaj, ma jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Ri Dios kebꞌutaq lo ru ángeles awukꞌ chaꞌ katkichajij. Katkichap kꞌu rukꞌ ri kiqꞌabꞌ chaꞌ na kaꞌchiqa ta rawaqan che juna abꞌaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ri Jesús xukꞌul uwach: —Jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Makꞌam upa ri Dios Qajawxel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ekꞌuchiriꞌ, ritzel winaq xukꞌam tanchi ubꞌi ri Jesús chutzaꞌm jun nimalaj juyubꞌ y xukꞌut kꞌu chwach, ronoje ri taqanik kaꞌan puwi taq ri tinamit che ruwachulew rukꞌ ronoje ruchomalil taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Xubꞌiꞌij kꞌu che: —Ronoje taq waꞌ kanya paqꞌabꞌ we kaxukubꞌaꞌ awibꞌ chinuwach y kaloqꞌnimaj nuqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ekꞌu ri Jesús xubꞌiꞌij che: —Chatela chinuwach Satanás, ma jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Lik chaloqꞌnimaj uqꞌij ri Dios Qajawxel y xew Rire chanimaj uqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Ekꞌu ritzel winaq xuya kan ri Jesús y xel bꞌi chiriꞌ. Xekꞌun kꞌu lo jujun ángeles y xkijeqo kakinimaj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Ri Jesús, echiriꞌ xuto kꞌo ri Juan pa cárcel, xeꞌek tanchi Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Xel bꞌi pa ri tinamit Nazaret y xeꞌjeqela pa ri tinamit Capernaúm. Waꞌ jun tinamit kꞌo chuchiꞌ ri mar pa ri luwar re Zabulón y re Neftalí. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Xuꞌan kꞌu waꞌ chaꞌ e kuꞌana janipa rutzꞌibꞌam kan ri qꞌalajisanel Isaías echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Pa ri luwar re Zabulón y re Neftalí, ri kꞌo pa rubꞌeyal ri mar, chꞌaqa yaꞌ che ri nimayaꞌ Jordán, pa taq ri luwar re Galilea pa ejeqel wi ukꞌiyal winaq na e ta aj judiꞌabꞌ; ");
INSERT INTO acrNNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ri tikawex ejeqel pa qꞌequꞌm xkil ri Qꞌijsaq yey ri ejeqel pa ri qꞌequꞌm re kamik, xwon ri Qꞌijsaq pakiwiꞌ xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Chwi kꞌu lo riꞌ xujeq ri Jesús katzijonik, jewaꞌ kubꞌiꞌij: «Tzelej tzij alaq chwach ri Dios, ma rutaqanik ri Dios petinaq chilaꞌ chikaj lik xa naqaj chi kꞌo wuloq» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Echiriꞌ kabꞌin ri Jesús chuchiꞌ ri mar re Galilea, xril pan kiwach kebꞌ achijabꞌ kichaqꞌ kibꞌ, jun Simón rubꞌiꞌ (Pedro kecha che) y ri jun chik Andrés rubꞌiꞌ. Rike e aj chapal kar, yey e riꞌ ketajin che ukꞌaqik ri ki atarraya pa ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ekꞌu ri Jesús xubꞌiꞌij chike: —Chixpetoq, chixterej lo chwij, y riꞌin kanꞌan chiwe ix aj molol tikawex, jelaꞌ pachaꞌ iꞌanom lo chike ri kar —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Y na jampatana xkiya kan ri ki atarraya y xeterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xbꞌin kꞌu pan jubꞌiqꞌ chik y xeril chi pan kebꞌ achijabꞌ kichaqꞌ kibꞌ, jun Jacobo rubꞌiꞌ y ri jun chik Juan rubꞌiꞌ. Wa kaꞌibꞌ e ukꞌajol ri Zebedeo. Rike e kꞌo chupa jun barco junam rukꞌ ri kiqaw y ketajin che ukꞌojoxik ri ki atarraya. Ekꞌu ri Jesús xebꞌusikꞌij bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Y na jampatana rike xkiya kan ri kibarco y ri kiqaw, y xeterej kꞌu bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Ri Jesús xikꞌow che ronoje tinamit re Galilea. Kakꞌutun pa taq sinagogas chujujunal tinamit, kutzijoj ri Utzilaj Tzij re rutaqanik ri Dios y kukunaj ronoje uwach yabꞌil kꞌo chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Konoje ri e kꞌo pa taq ri tinamit re Siria xketaꞌmaj taq ri kuꞌan ri Jesús. Xekikꞌam kꞌu lo chwach Rire konoje ri tikawex rukꞌ taq ukꞌiyal kꞌaxkꞌolil. Waꞌ e ri e kꞌo pa yabꞌil, ri kꞌax kikꞌulumam, ri e kꞌo pakiqꞌabꞌ itzel uxlabꞌixel, ri kebꞌumaj tew y ri e sik. Ekꞌu ri Jesús xebꞌukunaj konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Lik e kꞌi kꞌu ri xeterej bꞌi chirij. Waꞌ e petinaq Jerusalem y che jujun chik luwar re Judea, kukꞌ ri e petinaq pa taq ri tinamit re Galilea, re Decápolis y che jujun chik tinamit e kꞌo chꞌaqa yaꞌ che ri nimayaꞌ Jordán. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Ri Jesús, echiriꞌ xeril rukꞌiyal winaq, xaqꞌan chwa ri juyubꞌ y xtzꞌuyiꞌik. Ekꞌu rutijoꞌn xkimol kibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Jekꞌuwaꞌ ri xujeq ukꞌutik chikiwach: ");
INSERT INTO acrNNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","«Nim kiqꞌij kalaxik ri kaketaꞌmaj lik chirajawaxik ri Ruxlabꞌixel ri Dios chike, ma rutaqanik ri Dios petinaq chilaꞌ chikaj kuꞌana ke. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nim kiqꞌij kalaxik ri kebꞌoqꞌik, ma ri Dios e kabꞌochiꞌin kikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nim kiqꞌij kalaxik ri kiꞌanom chꞌutiꞌn che kibꞌ chwach ri Dios, ma kayaꞌ na chike, ri luwar ubꞌiꞌtisim chi ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nim kiqꞌij kalaxik ri lik kacha kikꞌuꞌx che utzuquxik ri jusukꞌ bꞌinik silabꞌik chwach ri Dios, ma ri Dios e kayaꞌw waꞌ chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nim kiqꞌij kalaxik ri kakikꞌut ri kꞌaxnaꞌbꞌal kikꞌuꞌx chike jujun chik, ma ri Dios kukꞌut ri kꞌaxnaꞌbꞌal ukꞌuꞌx chike rike. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nim kiqꞌij kalaxik ri uꞌanom chom ri kanimaꞌ chwach ri Dios, ma rike kakil na uwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nim kiqꞌij kalaxik ri kakitzukuj utzil chomal chikiwach, ma kabꞌiꞌx chike rike e ralkꞌoꞌal ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nim kiqꞌij kalaxik ri keternabꞌex rukꞌ kꞌaxkꞌobꞌik ruma ri kakiꞌan ri jusukꞌ chwach ri Dios, ma rutaqanik ri Dios petinaq chilaꞌ chikaj kuꞌana ke. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","»Nim iqꞌij iwalaxik riꞌix echiriꞌ wuma riꞌin kixternabꞌex rukꞌ kꞌax, kakꞌaq bꞌi iqꞌij y kabꞌiꞌx ronoje ri na utz taj chiwij yey waꞌ xa raqꞌubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Chixkiꞌkotoq y chixbꞌixonoq, ma lik nim ri rajil ukꞌaxel kikꞌul chilaꞌ chikaj. Makam kꞌu iwanimaꞌ che echiriꞌ kixyaꞌ pa kꞌax, ma jelaꞌ xꞌan chike ri qꞌalajisanelabꞌ ojertan, ri xenabꞌej lo chiwach riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","»Wara che ruwachulew riꞌix lik kixajawax chike ri tikawex jelaꞌ pachaꞌ ratzꞌam lik kajawaxik. Yey we xsach rutzayul ratzꞌam, ¿suꞌanik tanchi kaꞌan tza che? Riꞌ na jinta chi kꞌana uchak; keꞌkꞌaq kꞌu bꞌi y kaxajaxoꞌx kan uwiꞌ kuma ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","»Riꞌix ix qꞌijsaq che ruwachulew. E juna tinamit kꞌo lo chwi juna juyubꞌ na utz taj kewaxik. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Yey na utz tane katzij juna aqꞌ y kachꞌuq uwiꞌ rukꞌ juna mulul re pajbꞌal, ma ri kaꞌan che e kayaꞌiꞌ lo chupa rukꞌolibꞌal chikaj chaꞌ jelaꞌ kutzij kiwiꞌ konoje ri e kꞌo pa ri ja. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Jekꞌulaꞌ riꞌix, ix qꞌijsaq chikiwach ri tikawex chaꞌ kakil ri chomilaj chak kiꞌano y jelaꞌ e kakiyak uqꞌij ri Qaqaw Dios kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","»Michꞌobꞌ kꞌu riꞌix we riꞌin in kꞌuninaq re koꞌlnusacha uwach Rutzij Upixabꞌ ri Dios tzꞌibꞌital kan kuma ri Moisés y ri qꞌalajisanelabꞌ. Ma na in kꞌuninaq ta che usachik uwach waꞌ; e in kꞌuninaq re koꞌlnuqꞌalajisaj rusukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Paqatzij wi kambꞌiꞌij chiwe: Xaloqꞌ kꞌa tikil ruqꞌijol ruwa kaj y ruwachulew, na kesax ta kꞌana juna letra yey na kesax tane tobꞌ xa juna ralko juchꞌ che Rutzij Upixabꞌ ri Dios, ma e kuꞌana na ronoje ri tzꞌibꞌitalik. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","»Ruma kꞌu waꞌ, china ri kupalajij juna taqanik tobꞌ ne lik chꞌutiꞌn chwach rire yey e tanchi ukꞌutik kuꞌan chikiwach ri tikawex, riꞌ na jinta uwach chupa rutaqanik ri Dios petinaq chilaꞌ chikaj. China kꞌu ri kukoj Rutzij Upixabꞌ ri Dios yey jelaꞌ kukꞌut chikiwach jujun chik chaꞌ e kakiꞌano, riꞌ lik kꞌo uwach chupa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","»Paqatzij wi kambꞌiꞌij chiwe: Xew kixok riꞌix chupa wa taqanik petinaq chilaꞌ chikaj, we ribꞌinik isilabꞌik e más jusukꞌ chwa ri kibꞌinik raj kꞌutunel re ri tzijpixabꞌ y ri fariseos. Noꞌj we na je ta laꞌ, riꞌ na taqal ta chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","»Riꞌix itom ri xbꞌiꞌx lo chike ri tikawex ojertan chupa Rutzij Upixabꞌ ri Dios: “Matkamisanik”; yey china kꞌu ri kakamisanik, riꞌ kaqꞌat tzij puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","»Noꞌj riꞌin kambꞌiꞌij chiwe: China ri kape royowal chirij juna ratz-uchaqꞌ, riꞌ kaqꞌat tzij puwiꞌ. China kꞌu ri kukꞌaq bꞌi uqꞌij ri ratz-uchaqꞌ, riꞌ kakꞌam bꞌi chwach ri qꞌatbꞌal tzij re ri tinamit. Yey china ri kubꞌiꞌij che juna ratz-uchaqꞌ: “¡Na jinta kꞌana achak!”, riꞌ katewun puwiꞌ keꞌek pa aqꞌ chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","»Ruma kꞌu laꞌ, echiriꞌ kakꞌam bꞌi raqasaꞌn chwa raltar yey chiriꞌ kakꞌun chakꞌuꞌx kꞌo juna awatz-achaqꞌ kꞌo royowal chawij, ");
INSERT INTO acrNNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","chayaꞌa na kan raqasaꞌn chwa raltar y jat nabꞌe rukꞌ rawatz-achaqꞌ, jaꞌana utzil chomal rukꞌ. Ekꞌuchiriꞌ, utz katpe tanchi chwa raltar y kaya kꞌu riꞌ raqasaꞌn chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","»We kꞌo junoq kukoj amak y katukꞌam bꞌi pa qꞌatbꞌal tzij, nabꞌe chaꞌana pan utzil chomal rukꞌ pa bꞌe chaꞌ jelaꞌ na katuꞌyaꞌa ta chi puqꞌabꞌ raj qꞌatal tzij. Ma we na xaꞌan ta riꞌ, raj qꞌatal tzij katuya bꞌi puqꞌabꞌ ri ausiliar chaꞌ katuꞌyaꞌa pa cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Paqatzij wi kambꞌiꞌij chawe: Na katel tana lo pa ri cárcel we na xatoj ta kan ronoje ramak. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","»Riꞌix itom ri xbꞌiꞌx lo ojertan chupa Rutzij Upixabꞌ ri Dios: “Matmakun chirij ri kꞌulanikil.” ");
INSERT INTO acrNNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","»Noꞌj riꞌin kambꞌiꞌij chiwe: We kꞌo junoq karil juna ixoq y kurayij uwach re kamakun rukꞌ, riꞌ ya xmakun rukꞌ pa ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","»E uwariꞌche, we e rawach uwikiqꞌabꞌ ri katzaqisan awe pa ri mak, chawesaj y chakꞌaqa bꞌi; ma xa ne kuya riꞌ e kajam jun che rawach, chwa ri katkꞌaq bꞌi rukꞌ ronoje racuerpo chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We e raqꞌabꞌ uwikiqꞌabꞌ ri katzaqisan awe pa ri mak, chaqꞌataꞌ y chakꞌaqa bꞌi; ma xa ne kuya riꞌ e kajam jun che raqꞌabꞌ, chwa ri katkꞌaq bꞌi rukꞌ ronoje racuerpo chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","»Jenewaꞌ xbꞌiꞌx lo ojertan: “We juna achi karaj kujach bꞌi ri rixoqil, xew chuyaꞌa bꞌi ruwujil re jachbꞌal ibꞌ che.” ");
INSERT INTO acrNNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","»Noꞌj riꞌin kambꞌiꞌij: We rachi kuya bꞌi ruwujil re jachbꞌal ibꞌ che ri rixoqil tobꞌ rixoq na makuninaq ta chirij ri kꞌulanikil, riꞌ e kumin ri rixoqil pa ri mak. Ma we rixoq jachom bꞌi kukꞌam jun chik achi, kamakun kꞌu riꞌ chirij ri kꞌulanikil. Yey e rachi kakꞌuliꞌ rukꞌ rixoq jachom bꞌi, riꞌ jenelaꞌ kamakun chirij ri kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","»Riꞌix itom ri xbꞌiꞌx lo chike ri tikawex ojertan: “Matsokon rukꞌ ri kajikibꞌaꞌ uwach; e lik chaꞌana janipa rajikibꞌam uwach chwach ri Dios” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","»Noꞌj riꞌin kambꞌiꞌij chiwe: Lik makꞌo mijikibꞌaꞌ uwach pubꞌiꞌ junoq. Makꞌo ne mijikibꞌaꞌ uwach pa rubꞌiꞌ ri kaj, ma ri chilaꞌ chikaj e tzꞌulibꞌal pa kataqan wi ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Makꞌo mijikibꞌaꞌ uwach pubꞌiꞌ ruwa ulew, ma ruwa ulew e utakꞌalibꞌal ri raqan ri Dios. Makꞌo ne mijikibꞌaꞌ uwach pubꞌiꞌ ri tinamit Jerusalem, ma waꞌ e utinamit ri Nimalaj Taqanel Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Makꞌo mijikibꞌaꞌ uwach pubꞌiꞌ ruwiꞌ ijolom, ma riꞌix na kiriq tane uꞌanik saq o qꞌeq che riwiꞌ, tobꞌ tane xa jun chi wiꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","E chibꞌiꞌij ri jusukꞌ. We lik qatzij, xew chibꞌiꞌij: “Qatzij.” We na qatzij taj, xew chibꞌiꞌij: “Na qatzij taj.” Ma ri kakojiꞌ uwiꞌ ri kabꞌiꞌxik, waꞌ rukꞌ ritzel winaq petinaq wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","»Riꞌix itom ri xbꞌiꞌx lo ojertan: We kꞌo junoq kupuchꞌ rawach, riꞌ taqal che kapuchꞌ ri riꞌre. We kꞌo junoq kutor bꞌi juna aweꞌ, riꞌ taqal che kator bꞌi ri riꞌre. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","»Noꞌj riꞌin kambꞌiꞌij chiwe: Miꞌan ukꞌaxel che ri kuꞌan ri na utz taj chiwe. We kꞌo kꞌu junoq kupachꞌ qꞌabꞌ xeꞌ aweꞌ pawikiqꞌabꞌ, chayaꞌa luwar che kupachꞌ ri pa mox. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We kꞌo junoq katuchap pa chꞌaꞌoj pa qꞌatbꞌal tzij re kumaj rakoton, asu chayaꞌa ne kan raqꞌuꞌ re pisbꞌal awij che. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We kꞌo junoq katumin bꞌi chuxeꞌ eqaꞌn chaꞌ kaweqaj bꞌi jun kilómetro che, asu kebꞌ kilómetro chaweqaj bꞌi che. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Chatsipan che ri nibꞌaꞌ we kutzꞌonoj toꞌbꞌal chawe. We kꞌo junoq kachiqꞌiman chawe, maꞌan xuꞌyal che. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","»Itom kꞌu ri xbꞌiꞌx lo ojertan: Kꞌax chanaꞌa rawatz-achaqꞌ yey tzel chawila ri tzel kilow awe. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","»Noꞌj riꞌin kambꞌiꞌij chiwe: Kꞌax chebꞌinaꞌa ri e aj retzelal kꞌuꞌx chiwij. Chitzꞌonoj ri rutzil ukꞌuꞌx ri Dios pakiwi ri kakitzꞌonoj ri na utz taj piwi riꞌix. Chiꞌana ri utz chike ri tzel kebꞌilow iwe. Chiꞌana kꞌu orar pakiwi janipa ri kakikꞌaq bꞌi iqꞌij y ri kixkiternabꞌej rukꞌ kꞌaxkꞌobꞌik ");
INSERT INTO acrNNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","chaꞌ jelaꞌ kaqꞌalajinik ix ralkꞌoꞌal ri Qaqaw Dios kꞌo chilaꞌ chikaj. Ma Rire kuꞌan che ri qꞌij kel lo pakiwi ri tikawex kakiꞌan ri utz y pakiwi ri kakiꞌan ri na utz taj, yey kutaq lo ri jabꞌ pakiwi ri jusukꞌ kibꞌinik kisilabꞌik y pakiwi ri na jusukꞌ ta kibꞌinik kisilabꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","»Ma we xew kꞌax kebꞌinaꞌ ri kꞌax kenaꞌw iwe, ¿saꞌ kꞌu riꞌ ri rajil ukꞌaxel kikꞌulu? Ma jenelaꞌ kakiꞌan raj tzꞌonol puaq re tojonik. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","We xew kiya rutzil kiwach ri iwatz-ichaqꞌ riꞌix, ¿saꞌ kꞌu riꞌ ri utz kixtajin che uꞌanik? Ma jenelaꞌ kakiꞌan ri na ketaꞌam ta uwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Chiꞌana kꞌu jusukꞌ che ri ibꞌinik isilabꞌik jelaꞌ pachaꞌ ri usukꞌlikil ri Qaqaw Dios kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","»Miꞌan ri kikꞌut ri jusukꞌ ibꞌinik isilabꞌik chiwachil xa re kixilitaj kuma ri tikawex; ma we jelaꞌ kiꞌano, na jinta rajil ukꞌaxel kikꞌul che Riqaw Dios kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","E uwariꞌche, echiriꞌ kiya limoxna che juna nibꞌaꞌ, mitzijoj chike ri tikawex, pachaꞌ ri kakiꞌan ri xa kebꞌ kipalaj pa taq sinagogas y pa taq bꞌe. Ma rike jelaꞌ kakiꞌano xew chaꞌ kayak kiqꞌij. Noꞌj riꞌin paqatzij wi kambꞌiꞌij chiwe: Rukꞌ kꞌu wa yakbꞌal kiqꞌij, ya e laꞌ xkikꞌul ri rajil ukꞌaxel ri xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","E uwariꞌche, echiriꞌ kiya limoxna chike ri nibꞌaꞌibꞌ, miꞌan chiwachil. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Jekꞌulaꞌ na jinta kꞌo kanaꞌbꞌen re, xew Riqaw Dios ketaꞌman waꞌ. Ekꞌu Rire kuya na ri rajil ukꞌaxel chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","»Echiriꞌ kixchꞌaꞌt rukꞌ ri Dios, miꞌan iweꞌix pachaꞌ ri kakiꞌan ri xa kebꞌ kipalaj. Ma rike lik kukꞌul kikꞌuꞌx ri kakibꞌololej oración e laꞌ e takꞌal pa taq sinagogas y pa taq jachbꞌal bꞌe chaꞌ jelaꞌ kebꞌilitaj kuma ri tikawex. Noꞌj riꞌin paqatzij wi kambꞌiꞌij chiwe: Rukꞌ kꞌu wa yakbꞌal kiqꞌij, ya e laꞌ xkikꞌul ri rajil ukꞌaxel ri xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Noꞌj riꞌix echiriꞌ kixchꞌaꞌt rukꞌ ri Dios, chixok pa ja, chitzꞌapij lo ri puerta y chixchꞌaꞌt rukꞌ Riqaw Dios xa itukel; jekꞌulaꞌ Riqaw Dios karil ri kiꞌan xa itukel y kuya na kꞌu ri rajil ukꞌaxel chiwe chiwachil. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","»Ekꞌuchiriꞌ kixchꞌaꞌt rukꞌ ri Dios, miwererej chꞌaꞌtem ukꞌiyal laj pachaꞌ kakiꞌan ri na ketaꞌam ta uwach ri Dios; ma e kakichꞌobꞌ rike ruma ri kakiwererej chꞌaꞌtem, ketataj ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Miꞌan kꞌu iweꞌix pachaꞌ ri kakiꞌan rike, ma Riqaw Dios lik retaꞌam chik saꞌ ri kajawax chiwe echiriꞌ kꞌamajaꞌ ne kitzꞌonoj che. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","»Ekꞌu riꞌix echiriꞌ kixchꞌaꞌt rukꞌ ri Dios utz jewaꞌ taq ri kibꞌiꞌij: Qaqaw Dios, Lal kꞌo la chilaꞌ chikaj, ¡lik chetaꞌmaxoq nim uqꞌij ri bꞌiꞌ la! ");
INSERT INTO acrNNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Peta la, taqana la paqawiꞌ; chuꞌana kꞌu ri rajawal kꞌuꞌx la wara che ruwachulew, jelaꞌ pachaꞌ ri kaꞌan chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Yaꞌa ko la waqꞌij ri qawa, ri kajawax chiqe ronoje qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kuyu ko la qamak, jelaꞌ pachaꞌ riꞌoj kaqakuy kimak ri emakuninaq chiqij. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Y maya ko la luwar chiqe kojtzaq pa mak; e lik chojkolobꞌej la chwach ritzel winaq. Ma paqꞌabꞌ Rilal kꞌo wi ronoje taqanik y chuqꞌabꞌ; y xew che Rilal taqal wi ri yakbꞌal qꞌij na jinta utaqexik. Amén. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","»Ma we riꞌix kikuy kimak taq ri tikawex, jekꞌulaꞌ riꞌ kuꞌan ri Qaqaw Dios kꞌo chilaꞌ chikaj, kukuy imak riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Noꞌj we riꞌix na kikuy ta kimak taq ri tikawex, jekꞌulaꞌ riꞌ kuꞌan ri Qaqaw Dios, na kukuy ta imak riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","»Echiriꞌ riꞌix kiꞌan ayuno, mikꞌut bꞌis che ripalaj pachaꞌ ri kakiꞌan ri xa kebꞌ kipalaj. Ma rike kakiꞌan waꞌ xa pachaꞌ kebꞌilitaj kuma ri winaq. Paqatzij wi kambꞌiꞌij chiwe: Rukꞌ kꞌu wa yakbꞌal kiqꞌij, ya e laꞌ xkikꞌul ri rajil ukꞌaxel ri xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Noꞌj riꞌix echiriꞌ kiꞌan ayuno, chichꞌaja ripalaj y chixiya riwiꞌ chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Jekꞌulaꞌ ri tikawex na kakil taj we riꞌix ix kꞌo pa ayuno. Xew kꞌu Riqaw Dios, ri na kilitaj ta uwach, karil ri na kakil ta ri tikawex. Ekꞌu riꞌ Rire kayaꞌw na ri rajil ukꞌaxel chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","»Mixchakun xa re kimol ukꞌuꞌxibꞌal bꞌeyomalil re ruwachulew, ma ri wara e taq ri ikꞌolom xa kapokꞌirik y kuꞌan mojos, yey kebꞌok ne eleqꞌomabꞌ che releqꞌaxik bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","We kiwaj kiriq ri saqil bꞌeyomalil, e chiꞌana wara che ruwachulew janipa ri lik kꞌo uchak chwach ri Dios chaꞌ jelaꞌ kꞌo kutiqoj chiwe riꞌix chilaꞌ chikaj. Ma ri ikꞌolom chilaꞌ na kapokꞌir taj y na kuꞌan ta mojos, yey na jinta ne eleqꞌomabꞌ kebꞌok che releqꞌaxik bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Ma pa kꞌo wi ribꞌeyomalil riꞌix, puwi waꞌ keꞌek wi ikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","»Ri qawach e pachaꞌ candil re ri qacuerpo, ma ruma waꞌ kojtzuꞌnik chaꞌ utz kojbꞌinik. Jekꞌulaꞌ, we ri qawach utz uꞌanom, ronoje ri qacuerpo nojinaq che qꞌijsaq y kaqil kꞌu ronoje chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Noꞌj we ri qawach na utz taj, ronoje ri qacuerpo kꞌo pa qꞌequꞌm. Jekꞌulaꞌ, we ri qꞌijsaq kꞌo qukꞌ uꞌanom junam rukꞌ ri qꞌequꞌm, ¡koꞌl chi lo qꞌequꞌmalil riꞌ oj kꞌo wi! ");
INSERT INTO acrNNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","»Lik kꞌayew we juna aj chak e kaꞌibꞌ ri rajaw. Ma laj tzel karil ri jun yey kꞌax kunaꞌ ri jun chik; o laj kuyak uqꞌij ri jun yey kukꞌaq bꞌi uqꞌij ri jun chik. Ruma kꞌu laꞌ, na utz taj we junoq kuya ribꞌ che unimaxik ri Dios yey kuya ribꞌ che utzukuxik ri bꞌeyomalil re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","»E uwariꞌche kambꞌiꞌij chiwe riꞌix: Mubꞌisoj ikꞌuꞌx rikꞌaslem; mubꞌisoj ne ikꞌuꞌx saꞌ riwa y rimiqꞌinaꞌ kitijo o saꞌ riqꞌuꞌ kikojo. ¿Na e ta nebꞌa más kꞌo uwach rikꞌaslem riꞌix chwach ri kitijo? ¿Yey na e ta nebꞌa más kꞌo uwach ri cuerpo chwach riqꞌuꞌ kikojo? ");
INSERT INTO acrNNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","»Chebꞌiwilape ri tzꞌikin kexikꞌikꞌ che ruwa kaj. Rike na ketikoꞌnaj taj, na kakiꞌan tane kimolonik y na jinta ne pa kakikꞌol wi ri kimolonik. Na rukꞌ ta kꞌu riꞌ, Riqaw Dios kꞌo chilaꞌ chikaj kebꞌutzuqu. ¡Makꞌuwariꞌ riꞌix, ri Dios kixuchajij, ma e más kꞌo iwach riꞌix chikiwa ri tzꞌikin! ");
INSERT INTO acrNNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","»¿Kꞌo nebꞌa junoq chiwe riꞌix kuriq kunajtirisaj jun chik qꞌij che rukꞌaslem wara che ruwachulew? Na jinta junoq, tobꞌ ne lik kutij uqꞌij che. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Suꞌbꞌe kꞌu riꞌ lik kubꞌisoj ikꞌuꞌx riqꞌuꞌ kikojo? Chiwilapeꞌ suꞌanik kekꞌiy ri kotzꞌiꞌj pa taq juyubꞌ; waꞌ na kechakun taj y na kekeman ta nenareꞌ chaꞌ kakiꞌan ri kiqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Yey riꞌin kambꞌiꞌij chiwe: Ri rey Salomón, tobꞌ lik kꞌo uchomal ruqꞌuꞌ xukojo, waꞌ na xumaj ta kꞌana ruchomalil taq ri kotzꞌiꞌj. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Jekꞌulaꞌ we ri Dios uꞌanom chom che ri aqꞌes kꞌo waqꞌij pa juyubꞌ yey chweꞌq xa kaporox pa aqꞌ, ¿na kuya ta kami riꞌ ri Dios riqꞌuꞌ kajawax chiwe? ¡Riꞌix lik xa jubꞌiqꞌ ri kubꞌulibꞌal ikꞌuꞌx rukꞌ ri Dios! ");
INSERT INTO acrNNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","»Kambꞌiꞌij kꞌu chiwe: Mubꞌisoj ikꞌuꞌx y mibꞌiꞌij: “¿Saꞌ ri qawa, saꞌ ri qamiqꞌinaꞌ kaqatijo? ¿Saꞌ ri qaqꞌuꞌ kaqakojo?” ");
INSERT INTO acrNNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Ma jenelaꞌ kakiꞌan ri winaq na ketaꞌam ta uwach ri Dios, e kubꞌisoj kikꞌuꞌx taq waꞌ. Noꞌj riꞌix kꞌo jun Iqaw chilaꞌ chikaj lik retaꞌam kajawax ronoje taq waꞌ chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","»Ri lik chirajawaxik chiwe nabꞌe e lik chixok il che rutaqanik ri Dios y che ri jusukꞌ bꞌinik silabꞌik karaj Rire chiwe. Yey ronoje taq kꞌu ri kajawaxik, xa uwiꞌ chik kayaꞌtaj chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mubꞌisoj pan ikꞌuꞌx ri kiwil chweꞌq, ma chujujunal qꞌij ukꞌamom chi lo rukꞌayewal. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","»Miꞌan ri xa piwe riꞌix kixuꞌan aj qꞌatal tzij pakiwi jujun chik, chaꞌ jelaꞌ na kaqꞌat ta tzij piwi riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ma e ruꞌanik kiqꞌat tzij riꞌix pakiwi jujun chik, jelaꞌ kuꞌan ri Dios piwi riꞌix; ma rukꞌ ri pajbꞌal kixpajan wi, rukꞌ laꞌ kixpaj wi riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","»¿Suꞌchak e lik katzutzaꞌ rukꞌaj cheꞌ kꞌo chupa ruwach rawatz-achaqꞌ yey e na katok ta kꞌu il che resaxik ri cheꞌ qꞌebꞌel chupa rawach riꞌat? ");
INSERT INTO acrNNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Y we qꞌebꞌel la jun cheꞌ chupa rawach riꞌat, ¿utz nawi kabꞌiꞌij che rawatz-achaqꞌ: “Chayaꞌa luwar chwe kanwesaj la jun ukꞌaj cheꞌ kꞌo chupa rawach”? ¡Na utz taj! ");
INSERT INTO acrNNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Xa kebꞌ apalaj! Nabꞌe na chawesaj lo la cheꞌ qꞌebꞌel chupa rawach riꞌat, y jelaꞌ kat-tzuꞌn chi utz chaꞌ katoꞌ rawatz-achaqꞌ che resaxik lo rukꞌaj cheꞌ kꞌo chupa ruwach rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","»Miya chikiwa ri tzꞌiꞌ janipa ri lik chom chwach ri Dios, ma kꞌaxtaj kepe chiwij y kakiraqachꞌij ipa; jekꞌulaꞌ mikꞌaq chikiwach ri aq ri perlas kꞌo iwukꞌ, ma kꞌaxtaj xa kakixiqꞌixaꞌ uwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","»Janipa ri kajawax chiwe, chitzꞌonoj che ri Dios y kayaꞌiꞌ chiwe; chitzukuj rukꞌ Rire janipa ri kajawax chiwe y kiriqo; chichꞌaꞌbꞌej Rire y lik kixukajmaj loq. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Ma china ri kutzꞌonoj ri kajawax che, kukꞌul na; china ri kꞌo kutzukuj, kuriq na; y china ri kachꞌaw pan che ruchiꞌ ja, kajaqiꞌ na lo che. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","»¿Kꞌo nebꞌa juna achi chixoꞌl, we rukꞌajol kutzꞌonoj pam, kuya juna abꞌaj che; ");
INSERT INTO acrNNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","o we kutzꞌonoj kar, kumatz ri kuya che? ¡Na jinta junoq! ");
INSERT INTO acrNNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ekꞌu riꞌ riꞌix tobꞌ xa ix tikawex na lik ta utz ikꞌuꞌx, na rukꞌ ta kꞌu riꞌ, kiriq uyaꞌik chomilaj taq sipanik chike riwalkꞌoꞌal. ¡Makꞌuwariꞌ ri Qaqaw Dios kꞌo chilaꞌ chikaj kuya chomilaj taq sipanik chike ri ketzꞌonow re che! ");
INSERT INTO acrNNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","»Ekꞌu riꞌix chiꞌana chike ri tikawex jelaꞌ pachaꞌ ri kiwaj kakiꞌan rike chiwe. Ma e utaqanik waꞌ Rutzij Upixabꞌ ri Dios tzꞌibꞌital kan kuma ri Moisés y ri qꞌalajisanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","»Chixok bꞌi che ri okibꞌal chꞌutiꞌn uwach. Ma ri okibꞌal y ri bꞌe keꞌek chi xibꞌalbꞌaꞌ lik nim uwach, yey lik e kꞌi ri kebꞌok bꞌi chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Noꞌj ri okibꞌal y ri bꞌe keꞌek chi kꞌaslemal na jinta utaqexik, lik chꞌutiꞌn uwach, yey na e ta kꞌi ri kebꞌok bꞌi chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","»Lik chichajij iwibꞌ chikiwach ri kakibꞌiꞌij e qꞌalajisanelabꞌ re ri Dios yey xa e sokosoꞌnel. Ma waꞌ kekꞌun iwukꞌ riꞌix lik chakojoꞌ utz kikꞌuꞌx, noꞌj chupa ri kanimaꞌ xa pachaꞌ e utiw lik e bꞌiqꞌonel. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ekꞌu riꞌix kiwetaꞌmaj saꞌ ri kꞌo pa kanimaꞌ ri tikawex ruma ri kakiꞌano, we utz o na utz taj. »E pachaꞌ taq ri cheꞌ: ri kꞌiix, na uva ta rujiqꞌobꞌalil kuyaꞌo; yey ri xulukej, na higos ta rujiqꞌobꞌalil kuyaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Jekꞌulaꞌ juna chomilaj cheꞌ, lik chom rujiqꞌobꞌalil kuyaꞌo; noꞌj ri cheꞌ na chom taj, na jinta uchak rujiqꞌobꞌalil kuyaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ri chomilaj cheꞌ na ubꞌe taj we na chom ta rujiqꞌobꞌalil kuyaꞌo; jekꞌulaꞌ ri cheꞌ na chom taj na kuya ta ujiqꞌobꞌalil chom. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Yey ronoje cheꞌ we na chom ta rujiqꞌobꞌalil kuyaꞌo, kachet bꞌi y kaporox pa aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Riꞌix kiwetaꞌmaj kꞌu uwach juna cheꞌ ruma rujiqꞌobꞌalil kuyaꞌo; jekꞌulaꞌ kaqꞌalajinik saꞌ taq ri kꞌo pa kanimaꞌ ri tikawex ruma ri kibꞌinik kisilabꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","»Na konoje ta ri kakibꞌiꞌij chwe “Qajawal, Qajawal” kebꞌok chilaꞌ chikaj pa rutaqanik ri Dios, ma xew kebꞌok ri kakiꞌan ri rajawal ukꞌuꞌx ri Nuqaw kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Kopon kꞌu ruqꞌijol echiriꞌ ri Dios kuqꞌat tzij pakiwi ri tikawex, yey chupa laꞌ la qꞌij lik e kꞌi ri kakibꞌiꞌij chwe: “Wajawal, Wajawal, riꞌoj xqaꞌan qꞌalajisanik chupa ri bꞌiꞌ la chike ri tikawex. Yey chupa ri bꞌiꞌ la xeqesaj bꞌi ri itzel uxlabꞌixel y pa ri bꞌiꞌ la xqaꞌan ukꞌiyal milagros” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ekꞌuchiriꞌ, riꞌin jewaꞌ kambꞌiꞌij chike: “Na xinwetaꞌmaj ta kꞌana iwach, chixela wukꞌ; ma riꞌix xew ix ꞌanal re ri lik itzel uwach.” ");
INSERT INTO acrNNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","»China kꞌu ri kataw re ri nutzij yey kuꞌan janipa ri kambꞌiꞌij, kanjunimaj rukꞌ jun achi lik kꞌo unaꞌoj ma xutzꞌaq lo ri rocho paꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xpe kꞌu lo ri jabꞌ, lik xnimar taq ri nimayaꞌ y xpe lo unimal kaqjiqꞌ y xumachꞌ ribꞌ che ri ja; na rukꞌ ta kꞌu riꞌ, ri ja na xtzaq ta ubꞌi, ma paꞌbꞌaj tzꞌaqom lo wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Noꞌj kꞌu ri kuta ri nutzij yey na kuꞌan ta janipa ri kambꞌiꞌij, kanjunimaj rukꞌ jun achi na jinta unaꞌoj, ma xuꞌan ri rocho pa sanyebꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xpe kꞌu lo ri jabꞌ, xenimar taq ri nimayaꞌ, xpe lo unimal kaqjiqꞌ y xumachꞌ ribꞌ che ri ja. Ekꞌu riꞌ ri ja xwuluwubꞌ bꞌi y xsach uwach» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Echiriꞌ xukꞌis ubꞌiꞌxik waꞌ ri Jesús, ri winaq lik kaminaq kanimaꞌ che rukꞌutunik, ");
INSERT INTO acrNNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ma ruma rukꞌutunik kaqꞌalajinik lik kꞌo uwach, na xa ta pachaꞌ ri kakiꞌan raj kꞌutunel re ri tzijpixabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Ekꞌuchiriꞌ xqaj lo ri Jesús chwa ri juyubꞌ, lik ukꞌiyal winaq xeterej lo chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Tekꞌuchiriꞌ, xopon jun achi kꞌo ri yabꞌil lepra che, xuxuk ribꞌ chwach ri Jesús y xubꞌiꞌij che: —Wajawal, we kaꞌaj ko la, josqꞌij la ri nucuerpo che wa yabꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ekꞌu ri Jesús xuchap pana rukꞌ ruqꞌabꞌ y jekꞌuwaꞌ xubꞌiꞌij che: —Kuaj, chuꞌana bꞌa chom riꞌ racuerpo —xchaꞌ. Xew kꞌu xukꞌis ubꞌiꞌxikil waꞌ, na jampatana xsach ri yabꞌil kꞌo che rachi. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ekꞌu ri Jesús xubꞌiꞌij che: —Chatapeꞌ, lik matzijoj che junoq riꞌin xatinkunaj. Jat chwach raj chakunel pa Rocho Dios chaꞌ rire karilo na jinta chi lepra chawe, y chayaꞌa chwach ri Dios ri qasaꞌn xtaqan kan ri Moisés che chaꞌ kaqꞌalajin chikiwach ri tikawex at kunutajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Echiriꞌ xopon ri Jesús pa ri tinamit Capernaúm, xopon jun capitán ke ri soldados aj Roma rukꞌ y xujeq lik kelaj che, ");
INSERT INTO acrNNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","jewaꞌ kubꞌiꞌij: —Wajawal, ri waj chak lik yewaꞌ kꞌo chwa uwarabꞌal chiwocho. Rire xuꞌan sik y lik kꞌo pa kꞌax —kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ri Jesús xubꞌiꞌij che: —Riꞌin kinꞌek y kankunaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ekꞌu ri capitán xubꞌiꞌij che: —Wajawal, riꞌin lik na taqal ta chwe kok la chiwocho. Xew bꞌiꞌij la: “Chatkunutajoq”, y rukꞌ ri chꞌaꞌtem la, kakunutaj ri waj chak. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma e pachaꞌ riꞌin, in kꞌo puqꞌabꞌ jun taqanel y rire ebꞌuyaꞌom ukꞌiyal soldados panuqꞌabꞌ. We kambꞌiꞌij kꞌu che junoq “Jat”, keꞌek; o kambꞌiꞌij che junoq chik “Chatpetoq”, kapetik. Yey we kambꞌiꞌij che juna waj chak “Chaꞌana waꞌ”, kuꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Ri Jesús echiriꞌ xuta waꞌ, lik xkam ranimaꞌ che y jewaꞌ xubꞌiꞌij chike ri eteran chirij: —Paqatzij wi kambꞌiꞌij chiwe: Na nuriqom tane chikixoꞌl raj Israel junoq lik kꞌo unimal kubꞌulibꞌal ukꞌuꞌx pachaꞌ wa jun achi. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Kambꞌiꞌij kꞌu chiwe: Lik e kꞌi ri kepe pa relebꞌal lo ri qꞌij y e kꞌi ri kepe putzaqibꞌal ri qꞌij y kebꞌok chwa ri mexa pa waꞌim rukꞌ ri Abraham, rukꞌ ri Isaac y rukꞌ ri Jacob chupa rutaqanik ri Dios kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Noꞌj taq kꞌu ri kakichꞌobꞌo taqal chike kakikꞌul rutaqanik ri Dios ruma e ratz-uchaqꞌ kan ri Abraham, riꞌ kebꞌesax bꞌi y kekꞌaq bꞌi pa ri qꞌequꞌm; chiriꞌ kꞌu riꞌ kebꞌoqꞌ wi y kaqichꞌichꞌ ruwi keꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús che ri capitán: —Oj chi ocho la, ma jelaꞌ kuꞌanaꞌ pachaꞌ ri xkubꞌiꞌ kꞌuꞌx la che —xchaꞌ. Chupa kꞌu laꞌ la joqꞌotaj xkunutaj ri raj chak. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ri Jesús xopon chirocho ri Pedro. Chiriꞌ kꞌu riꞌ xril ruchu-ujiꞌ ri Pedro kꞌo chwa uwarabꞌal y lik kꞌo aqꞌ chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ekꞌu ri Jesús xuchap ruqꞌabꞌ y jekꞌulaꞌ xikꞌow ri aqꞌ chirij. Ekꞌuchiriꞌ, rixoq xyaktajik y xujeq kebꞌunimaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Echiriꞌ xok raqꞌabꞌ, xekikꞌam lo chwach ri Jesús ukꞌiyal tikawex e kꞌo pakiqꞌabꞌ itzel uxlabꞌixel. Ekꞌu ri Jesús rukꞌ ruchꞌaꞌtem xebꞌeresaj bꞌi taq ri itzel uxlabꞌixel chike y xebꞌukunaj konoje ri yewaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Xuꞌan waꞌ chaꞌ e kuꞌana ri utzijom kan ri qꞌalajisanel Isaías echiriꞌ xubꞌiꞌij: Rire xukꞌam bꞌi ri qayabꞌil, y xukꞌam bꞌi ri qakꞌaxkꞌolil xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Ri Jesús echiriꞌ xrilo ukꞌiyal winaq kisutum rij, xebꞌutaq rutijoꞌn chaꞌ keqꞌax chꞌaqa yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ekꞌu laꞌ la joqꞌotaj xopon rukꞌ ri Jesús jun achi aj kꞌutunel re ri tzijpixabꞌ y xubꞌiꞌij che: —Lal tijonel, riꞌin kinterej bꞌi chiꞌij la tobꞌ pachawi keꞌek wi la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ri Jesús xukꞌul uwach: —Ri yak kꞌo kijul y ri tzꞌikin kexikꞌikꞌ che ruwa kaj kꞌo kisok; noꞌj Ralaxel Chikixoꞌl Tikawex na jinta ne uluwar tobꞌ xa pa kuxlan wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Kꞌo chi jun chike rutijoꞌn xubꞌiꞌij che ri Jesús: —Wajawal, yaꞌa la luwar chwe kanwoyꞌej kakam na ri nuqaw y kanmuq kanoq; tekꞌuchiriꞌ, kinterej chiꞌij la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Ekꞌu ri Jesús xukꞌul uwach: —Riꞌat chat-terej lo chwij; chayaꞌa kan chike ri ekaminaq chwach ri Dios chaꞌ e rike kemuquw ri katz-kichaqꞌ kekamik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Ekꞌuchiriꞌ, xok ri Jesús pa jun barco y rutijoꞌn xebꞌek rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Tekꞌuchiriꞌ, xpe jun nimalaj kaqjiqꞌ chwi ri mar y xujeqo kanoj ri barco che yaꞌ. Yey ri Jesús kawarik. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ekꞌu rutijoꞌn xeꞌkikꞌosoj y xkibꞌiꞌij che: —¡Qajawal! ¡Chojkolobꞌej la, ma kojkamik! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ri Jesús xukꞌul uwach: —¿Suꞌchak lik kixiꞌij iwibꞌ? Riꞌix lik xa jubꞌiqꞌ ri kubꞌulibꞌal ikꞌuꞌx wukꞌ —xchaꞌ. Ekꞌuchiriꞌ xyaktajik, xuqꞌatej ri kaqjiqꞌ y ri yaꞌ. Xtaniꞌ kꞌu riꞌ ri kaqjiqꞌ y ri yaꞌ xyeniꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Rutijoꞌn lik xkam kanimaꞌ che y xkibꞌiꞌij: «¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tobꞌ ne e ri kaqjiqꞌ y ri yaꞌ kakikoj utzij!» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Echiriꞌ xopon ri Jesús chꞌaqa mar pa ri luwar re Gadara, xoꞌlkꞌul kuma kebꞌ achijabꞌ ebꞌelinaq lo chuxoꞌl taq muqubꞌal ke animaꞌ. Kikabꞌichal e kꞌo pakiqꞌabꞌ itzel uxlabꞌixel y lik itzel kiwachlibꞌal, ma kuma rike na jinta junoq kikꞌow chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","E taq kꞌu riꞌ waꞌ xkijeqo lik ko kesikꞌinik, jewaꞌ xkibꞌiꞌij: —¿Suꞌchak koꞌlmina ibꞌ la qukꞌ, Jesús, Lal Ukꞌajol ri Dios? ¿Petinaq kami la re kojya la pa kꞌax echiriꞌ kꞌamajaꞌ ne kopon ri qaqꞌij? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","E kꞌo kꞌu ukꞌiyal aq kewaꞌ lo chinimanaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ekꞌu ri itzel uxlabꞌixel lik xebꞌelaj che ri Jesús: —We kojesaj bꞌi la, yaꞌa la luwar chiqe kojok bꞌi kukꞌ ri aq —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús chike: —Jix riꞌ —xchaꞌ. Taq ri itzel uxlabꞌixel xebꞌel bꞌi chike rachijabꞌ y xebꞌok kukꞌ ri aq. Tekꞌuchiriꞌ, konoje ri aq xeꞌkikꞌaqa bꞌi kibꞌ chwi jun siwan, xebꞌeꞌtzaqa kꞌa chupa ri mar y chiriꞌ xejiqꞌ wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ekꞌu ri e chajinel ke ri aq xebꞌanimajik. Y echiriꞌ xebꞌopon pa ri tinamit, xkijeq utzijoxik ronoje ri xkikꞌulumaj ri aq y ri xuꞌan ri Jesús chike ri kebꞌ achijabꞌ echiriꞌ xebꞌeresaj pakiqꞌabꞌ ri itzel uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Konoje kꞌu ri winaq re ri tinamit xepe pa kꞌo wi ri Jesús. Echiriꞌ xkil uwach, lik xkitzꞌonoj che chaꞌ kel bꞌi chiriꞌ pa taq ri kiluwar. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ekꞌuchiriꞌ, xok ri Jesús pa jun barco, xqꞌax chꞌaqa yaꞌ y xopon pa ri tinamit pa jeqel wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E kꞌo kꞌu jujun achijabꞌ xkikꞌam lo jun achi sik chwach ri Jesús, kitelem lo chwa jun chꞌat. Echiriꞌ ri Jesús xril ri kubꞌulibꞌal kikꞌuꞌx rukꞌ, xubꞌiꞌij che rachi sik: —Wal, chanimarisaj akꞌuꞌx, ma ronoje ramak kuytajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","E kꞌo kꞌu jujun chike raj kꞌutunel re ri tzijpixabꞌ jewaꞌ xkichꞌobꞌo: «Wa jun achi lik kamakun chirij ri Dios, ma na yaꞌtal ta puqꞌabꞌ junoq kubꞌiꞌij waꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Noꞌj ri Jesús xunaꞌbꞌej saꞌ ri kakichꞌobꞌo; ruma kꞌu riꞌ, xubꞌiꞌij chike: —¿Suꞌchak kachꞌobꞌ alaq ri na utz taj? ");
INSERT INTO acrNNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Saꞌ kꞌu ri na kꞌayew taj kambꞌiꞌij: “Ronoje ramak kuytajinaq chik” o “Chatyaktajoq y chatbꞌinoq”? ");
INSERT INTO acrNNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","E kuaj kꞌut ketaꞌmaj alaq waꞌ: Ralaxel Chikixoꞌl Tikawex yaꞌtal puqꞌabꞌ kukuy taq ri mak ke ri winaq che ruwachulew —xchaꞌ. Xubꞌiꞌij kꞌu riꞌ che ri sik: —Chatyaktajoq, chakꞌama bꞌi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Xyaktaj kꞌu ri sik y xeꞌek chirocho. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Echiriꞌ xkil waꞌ ri winaq, lik xkam kanimaꞌ che y xkiyak uqꞌij ri Dios ruma uyaꞌom chike ri tikawex kakiꞌan taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Xel kꞌu bꞌi ri Jesús chiriꞌ y xril jun achi aj tzꞌonol puaq re tojonik, Mateo rubꞌiꞌ, tzꞌul pa ri luwar pa kaꞌan wi ri tojonik che ri gobierno, y xubꞌiꞌij che: —Chat-terej lo chwij —xchaꞌ. Y ri Mateo xyaktajik y xterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ekꞌu ri Jesús xumaj bꞌi chirocho waꞌchi y xebꞌok chwa ri mexa kukꞌ rutijoꞌn. Xebꞌopon kꞌu ukꞌiyal aj tzꞌonol puaq re tojonik y ukꞌiyal aj makibꞌ y xetzꞌuyiꞌ junam kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Echiriꞌ xkil waꞌ ri fariseos, xkibꞌiꞌij chike rutijoꞌn ri Jesús: —¿Suꞌchak ri tijonel iwe riꞌix kawaꞌ junam kukꞌ raj tzꞌonol puaq re tojonik y kukꞌ raj makibꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Echiriꞌ xuta waꞌ ri Jesús, xubꞌiꞌij chike: —E janipa ri utz kiwach, na kajawax ta aj kunanel chike; ma waꞌ xew chike ri e yewaꞌibꞌ kajawax wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Oj kꞌu alaq y maja na alaq saꞌ keꞌelawi ri kubꞌiꞌij ri Dios chupa Ruchꞌaꞌtem: Ri lik kuaj riꞌin chiwe e ri kꞌutubꞌal re ri kꞌaxnaꞌbꞌal kꞌuꞌxaj, na e ta ri kakamisax awaj re qasaꞌn chinuwach kachaꞌ. »Riꞌin na in petinaq ta che kisikꞌixik ri jusukꞌ kibꞌinik kisilabꞌik, ma in petinaq che kisikꞌixik raj makibꞌ chaꞌ kakijalkꞌatij ri kibꞌinik kisilabꞌik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ekꞌuchiriꞌ, rutijoꞌn ri Juan Aj Yaꞌl Bautismo xeqibꞌ rukꞌ ri Jesús y xkitzꞌonoj che: —¿Suꞌchak riꞌoj y ri fariseos lik kaqaꞌan ayuno yey ri tijoꞌn rilal na kakiꞌan taj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ri Jesús xukꞌul uwach: —¿Utz nebꞌa kekꞌojiꞌ pa bꞌis ri esikꞌim pa kꞌulanikil we kꞌa kꞌo rala kakꞌuliꞌik chikixoꞌl? Na utz taj. Noꞌj kopon na ri qꞌij echiriꞌ kesax bꞌi rala chikixoꞌl; kꞌa ekꞌuchiriꞌ kakiꞌan ayuno. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Na jinta junoq kukꞌojoj ruqꞌuꞌ qꞌeꞌl rukꞌ kꞌojobꞌal kꞌasaq, ma ri kꞌojobꞌal kꞌasaq, we xkꞌolotaj upa, e kujekꞌ ri kꞌul qꞌeꞌl y más ne kurichꞌij bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","»Jekꞌulaꞌ ri vino kꞌakꞌ ꞌanom na kaqꞌej ta chupa juna surun qꞌeꞌl. Ma we kaꞌaniꞌ waꞌ, ri vino kꞌakꞌ echiriꞌ kanajtir uqꞌij, kuraqij ri surun, katix kꞌu riꞌ ri vino y ri surun na jinta chi uchak. Ruma kꞌu laꞌ, ri vino kꞌakꞌ ꞌanom chirajawaxik wi kaqꞌej chupa ri surun kꞌasaq chaꞌ ukabꞌichal waꞌ kakowinik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Echiriꞌ katajin ri Jesús che ubꞌiꞌxikil taq waꞌ, xkꞌun lo jun achi aj wach re ri tinamit, xuxuk ribꞌ chwach y xubꞌiꞌij che: —Ri numiꞌal lik kꞌa e laꞌ xkamik. We ta rilal keꞌek la wukꞌ y keꞌyaꞌa ri qꞌabꞌ la puwiꞌ, rire kakꞌastaj tanchik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ri Jesús xyaktajik y xeꞌek rukꞌ rachi, junam kukꞌ rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ekꞌu laꞌ, kꞌo jun ixoq lik yewaꞌ, e kabꞌlajuj lo junabꞌ riꞌ na kataniꞌ ta ri yabꞌil re upa ikꞌ che. Xqibꞌ kꞌu pana chirij ri Jesús y xuchap ruchiꞌ ruqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ma xuchꞌobꞌ pa ranimaꞌ: «Tobꞌ tane xew luꞌqꞌuꞌ kanchapo, rukꞌ riꞌ kinkunutajik.» ");
INSERT INTO acrNNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Pero ri Jesús xtzuꞌn lo chirij, xutzuꞌ uwach rixoq y jewaꞌ xubꞌiꞌij che: —Ixoq, nimarisaj kꞌuꞌx la, ma xkunutaj la ruma xkubꞌiꞌ kꞌuꞌx la wukꞌ —xchaꞌ. Chupa kꞌu riꞌ la joqꞌotaj rixoq asu xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ekꞌuchiriꞌ xok bꞌi ri Jesús chirocho rachi aj wach, kebꞌutzutzaꞌ ri kakichꞌawisaj suꞌ y ri winaq kewoqoqik. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Xubꞌiꞌij kꞌu ri Jesús chike: —Chixelubꞌi, ma wa ralko ali na kaminaq taj, xa kawarik —xchaꞌ. Yey xa xkitzeꞌej kꞌu ri xubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ekꞌuchiriꞌ xebꞌesax lo ri winaq, ri Jesús xok bꞌi pa kꞌo wi ri ralko ali; xuchap kꞌu ruqꞌabꞌ y waꞌli xyaktajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Xeꞌek kꞌu utzijoxik riꞌ waꞌ che ronoje taq la luwar. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Echiriꞌ xel bꞌi ri Jesús chiriꞌ, xeterej bꞌi kaꞌibꞌ potzꞌ chirij, lik ko kesikꞌin che, jewaꞌ kakibꞌiꞌij: —¡Choj-juchꞌ kaꞌn ko cheꞌla, lal Ralkꞌoꞌal kan ri rey David! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Echiriꞌ xok ri Jesús chuchiꞌ jun ja, xeqibꞌ ri kaꞌibꞌ potzꞌ rukꞌ y Rire xubꞌiꞌij chike: —¿Kikoj riꞌix we riꞌin kꞌo panuqꞌabꞌ kanya ri itzuꞌnibꞌal? —xchaꞌ. Rike xkibꞌiꞌij: —Kaqakojo, Qajawal —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Ekꞌu ri Jesús xuya ruqꞌabꞌ puwi ri kiwach y xubꞌiꞌij chike: —Chuꞌana waꞌ iwukꞌ e chirij ri kubꞌulibꞌal ikꞌuꞌx —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Jekꞌulaꞌ xkunutaj ri kiwach. Ewi ri Jesús lik xebꞌupixabꞌaj, jewaꞌ xubꞌiꞌij chike: —Lik mitzijoj waꞌ che junoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Noꞌj rike xew xebꞌel bꞌi, xkijeq kakitzijoj pa ronoje taq laꞌ la luwar ri xuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Echiriꞌ katajin bꞌi kelik ri kebꞌ achijabꞌ xkunutaj ri kiwach, ri winaq xkikꞌam lo chwach ri Jesús jun achi meꞌt kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ekꞌuchiriꞌ ri Jesús xresaj bꞌi ri itzel uxlabꞌixel che, ri meꞌt xkunutajik y xujeq kachꞌaꞌtik. E taq kꞌu ri winaq lik xkam kanimaꞌ che waꞌ y xkibꞌiꞌij chikiwach: «Na qilom ta kꞌana waꞌ wara Israel pachaꞌ wa xqil woꞌora» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Noꞌj ri fariseos xkibꞌiꞌij: «Laꞌ la Jesús kebꞌeresaj bꞌi itzel uxlabꞌixel ruma ruchuqꞌabꞌ ri kajawal ri itzel uxlabꞌixel» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Echiriꞌ ri Jesús xikꞌow pa taq ronoje tinamit y aldeas, kakꞌutun chupa taq ri sinagogas chujujunal luwar, kutzijoj ri Utzilaj Tzij re rutaqanik ri Dios y kukunaj ronoje yabꞌil y kꞌaxkꞌobꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Ekꞌuchiriꞌ xeril rukꞌiyal winaq, lik xejuchꞌ kaꞌn pa ranimaꞌ, ma rike pachaꞌ e bꞌexex e sachinaq, kikichom kibꞌ y na jinta chi chajinel ke. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Xubꞌiꞌij kꞌu chike rutijoꞌn: «Paqatzij wi kambꞌiꞌij chiwe: Ri molonik kajawax uꞌanik, lik nim; noꞌj raj chak na e kꞌi taj. ");
INSERT INTO acrNNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","E uwariꞌche, chitzꞌonoj che ri Dios, ri Rajaw ri molonik, chaꞌ kebꞌutaq lo aj chak chupa ruchak» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ekꞌu ri Jesús xebꞌusikꞌij ri kabꞌlajuj utijoꞌn y xuya pakiqꞌabꞌ kebꞌekesaj bꞌi itzelilaj uxlabꞌixel y kakikunaj ronoje yabꞌil y ronoje kꞌaxkꞌobꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","E kibꞌiꞌ taq waꞌ wa kabꞌlajuj e taqoꞌn: Nabꞌe e Simón ri kabꞌiꞌx Pedro che y ruchaqꞌ Andrés, Jacobo y ruchaqꞌ Juan (wa kaꞌibꞌ e ukꞌajol ri Zebedeo), ");
INSERT INTO acrNNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe, Bartolomé, Tomás, Mateo ri aj tzꞌonol puaq re tojonik, Jacobo rukꞌajol ri Alfeo, Lebeo ri kabꞌiꞌx Tadeo che, ");
INSERT INTO acrNNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón ri kabꞌiꞌx che “ri Cananista”, kꞌisbꞌal re, e Judas aj Iscariot, ri xkꞌayin re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ri Jesús xebꞌutaq bꞌi ri kabꞌlajuj y e pixabꞌanik waꞌ xuya bꞌi chike: «Mixꞌek pa taq ri luwar ke ri na e ta aj judiꞌabꞌ, mixok ne pa taq ri tinamit re Samaria. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Jix kꞌu nabꞌe kukꞌ ri bꞌexex e sachinaq, waꞌ e ri e aj judiꞌabꞌ re ri tinamit Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Jix y jewaꞌ chitzijoj: “Rutaqanik ri Dios petinaq chilaꞌ chikaj xa naqaj chi kꞌo wuloq.” ");
INSERT INTO acrNNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","»Chebꞌikunaj konoje ri yewaꞌibꞌ kukꞌ taq ri kꞌo ri yabꞌil lepra chike, chebꞌikꞌastajisaj ri ekaminaq y chebꞌiwesaj bꞌi itzel uxlabꞌixel. Wa chuqꞌabꞌ kikꞌul riꞌix e rutzil nukꞌuꞌx chiwe; jekꞌulaꞌ mitzꞌonoj rajil ri chak kiꞌan rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","»Mikꞌam bꞌi imeyo re oro, re plata o re cobre. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Mikꞌam ne bꞌi tebꞌ re ubꞌitaq iwe, mikꞌam bꞌi jun chik ikoton, jun chik molaꞌj ixajabꞌ o jun chik ichꞌamiꞌy. Ma e junoq kachakunik, lik taqalik kayaꞌiꞌ janipa ri kajawax che. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","»Echiriꞌ kixopon pa juna tinamit o pa juna aldea, chitzukuj junoq jusukꞌ ubꞌinik usilabꞌik y chixkanaj kꞌu kan chirocho kꞌate kixel bꞌi chiriꞌ echiriꞌ kixꞌek pa jun chik tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","»Echiriꞌ kixok chuchiꞌ juna ja, chiyaꞌa rutzil kiwach ri e kꞌo chiriꞌ, kitzꞌonoj kꞌu ri utzil chomal re ri Dios pakiwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","We kixkikꞌul kꞌu ri e kꞌo pa ri ja, kakanaj ri utzil chomal itzꞌonom kan pakiwiꞌ. Noꞌj we rike na kixkikꞌul taj, ri utzil chomal katzelej tanchi lo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","»We na kixkikꞌul taj y na kakaj tane kakita ri kitzijoj, chixelubꞌi chupa ri ja o pa ri tinamit yey chipupaꞌ kan rulew kꞌo che ri iwaqan. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ma paqatzij wi kambꞌiꞌij chiwe: Chupa ruqꞌijol ri qꞌatbꞌal tzij, más lik kꞌax ri kape pakiwi ri tinamit na xkikꞌul ta ri Utzilaj Tzij, chwa ri kape pakiwi ri e aj Sodoma y ri e aj Gomorra. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","»Chitapeꞌ: Riꞌin kixintaq bꞌi pachaꞌ ix bꞌexex chikixoꞌl utiw. Lik chichajij kꞌu iwibꞌ chi utz jelaꞌ pachaꞌ ruꞌanik kuchajij ribꞌ ri kumatz, yey chiꞌana pachaꞌ ri palomax na jinta kꞌo kuꞌan che junoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","»Lik chichajij kꞌu iwibꞌ chikiwach ri winaq, ma kixkikꞌam bꞌi pa taq qꞌatbꞌal tzij y kakijichꞌ ipa pa taq sinagogas. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wuma riꞌin, kixkikꞌam ne bꞌi chikiwach taq raj qꞌatal tzij y ri taqanelabꞌ. Rukꞌ kꞌu riꞌ waꞌ, utz kiqꞌalajisaj nuwach riꞌin chikiwach rike y chikiwach konoje taq ri tinamit che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ekꞌuchiriꞌ kixkiya chikiwach, mubꞌisoj ikꞌuꞌx saꞌ ri kibꞌiꞌij; ma echiriꞌ kopon ruꞌorayil re kixchꞌaꞌtik, e ri Dios kayaꞌw lo ichꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ma na ix ta ri kixchꞌaꞌtik, e ri Ruxlabꞌixel Riqaw; e Rire kuya ichꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","»E taq kꞌu ri tikawex kekiya ri katz-kichaqꞌ pa kamik; ri kꞌo kalkꞌoꞌal kekiya taq ri kalkꞌoꞌal pa kamik; ri kalkꞌoꞌal keyaktaj chikij kichu-kiqaw y kekiya pa kamik. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taq ri winaq lik tzel kixkil riꞌix xa ruma ikojom ri nubꞌiꞌ; noꞌj china kꞌu ri kuchuqꞌubꞌej ribꞌ kꞌa chupa ri kꞌisbꞌal re, e riꞌ ri kakolobꞌetajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Echiriꞌ lik kixternabꞌex rukꞌ kꞌaxkꞌobꞌik pa juna tinamit, jix che jun chik. Ma paqatzij wi kambꞌiꞌij chiwe, kꞌamajaꞌ ne kikꞌiso kixikꞌow chupa ronoje taq ri tinamit re Israel, echiriꞌ kakꞌun tanchi Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","»Na jinta juna tijoꞌn más kꞌo uwach chwa rutijonel y na jinta ne juna aj chak más kꞌo uwach chwa ri rajaw. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Juna tijoꞌn kubꞌuloq we xuꞌana jelaꞌ pachaꞌ rutijonel y juna aj chak kubꞌuloq we xuꞌana pachaꞌ ri rajaw. We kabꞌiꞌx “Beelzebú” che ri kiqaw rakꞌalabꞌ, ¿makꞌuwariꞌ ri kabꞌiꞌx chike ri ralkꞌoꞌal? ");
INSERT INTO acrNNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","»Mixiꞌij iwibꞌ chikiwach ri winaq. Ma kopon ri qꞌij echiriꞌ janipa ri na qꞌalajisam taj, kaqꞌalajisax na; yey janipa ri ewatalik, ketaꞌmaxik. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","E janipa ri kambꞌiꞌij riꞌin xew chiwe riꞌix, chibꞌiꞌij riꞌix chiwachil; yey ri kanweswaꞌ riꞌin chiwe, chixsikꞌin che ubꞌiꞌxikil pa taq bꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","»Mixiꞌij iwibꞌ chikiwach ri kꞌo pakiqꞌabꞌ kixkikamisaj, ma waꞌ xew che ri cuerpo kakiꞌan wi, noꞌj na jinta pakiqꞌabꞌ kakisach uwach rukꞌaslem junoq chwach ri Dios. E chixiꞌij iwibꞌ chwach ri Jun kꞌo puqꞌabꞌ kebꞌukꞌaq bꞌi ri tikawex junam rukꞌ ri kicuerpos y ri kanimaꞌ, chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","»Iwetaꞌam, kaꞌibꞌ raltaq ko tzꞌikin kekꞌayix xa chwa jun ralko meyo. Na rukꞌ ta kꞌu riꞌ, na katzaq tane junoq chike pulew we ri Qaqaw na kuya ta luwar. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Makꞌuwariꞌ riꞌix lik puqꞌabꞌ ix kꞌo wi, ma xa ne chujujunal riwiꞌ ajilam ruma Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","E uwariꞌche, mixiꞌij iwibꞌ; ma riꞌix más kꞌo iwach chikiwach ri raltaq ko tzꞌikin. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","»E junoq kuqꞌalajisaj chikiwach ri winaq, kubꞌiꞌij: “In tijoꞌn re ri Jesús”; jekꞌuriꞌlaꞌ kanꞌan riꞌin che rire, kambꞌiꞌij chwach ri Nuqaw kꞌo chilaꞌ chikaj: “Qatzij, wa jun e nutijoꞌn” kinchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","»Noꞌj kꞌu ri kubꞌiꞌij chikiwach ri winaq: “Riꞌin na in ta tijoꞌn re ri Jesús.” Jekꞌuriꞌlaꞌ kanꞌan riꞌin che rire, kambꞌiꞌij chwach ri Nuqaw kꞌo chilaꞌ chikaj: “Qatzij, wa jun na nutijoꞌn taj” kinchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","»Michꞌobꞌo we ri nukꞌunik che ruwachulew kukꞌam lo utzil chomal. Na e ta riꞌ, ma e kukꞌam lo chꞌaꞌoj chikixoꞌl taq ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ruma kꞌu ri nukꞌunik, ri tikawex kakijeq kechꞌoꞌjin chikiwach rala rukꞌ ruqaw, rali rukꞌ ruchu y ralibꞌatz rukꞌ ruchu-ralibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ekꞌu riꞌ ri tzel kebꞌilow re juna tikawex, e mismo ri e kꞌo pa rocho. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","»China ri más lik e kꞌax kebꞌunaꞌ ruchu-uqaw chinuwach riꞌin, na taqal ta che katerej chwij; jekꞌulaꞌ china ri más lik e kꞌax kebꞌunaꞌ ri ralkꞌoꞌal chinuwach riꞌin, riꞌ na taqal ta che katerej chwij. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","»China ri na karaj taj kutij kꞌax ruma e nutijoꞌn, riꞌ na taqal ta che katerej chwij. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","China ri kutij uqꞌij lik kel chi utz rukꞌaslem wara che ruwachulew, riꞌ e kujam ri kꞌaslemal chilaꞌ chikaj; noꞌj ri kuya ranimaꞌ rukꞌaslem wuma riꞌin, riꞌ e kuriq ri chomilaj ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","»China ri kakꞌuluw iwe riꞌix, in ri kinukꞌulu; yey china ri kakꞌuluw we riꞌin, e kukꞌul ri Jun taqayom lo we. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","China ri kakꞌuluw re juna qꞌalajisanel ruma e qꞌalajisay re rutzij ri Dios, ri rajil ukꞌaxel kukꞌulu e jelaꞌ pachaꞌ ri kukꞌul juna qꞌalajisanel. China ri kakꞌuluw re juna tikawex ruma jusukꞌ rubꞌinik chwach ri Dios, ri rajil ukꞌaxel kukꞌulu e jelaꞌ pachaꞌ ri kukꞌul ri jusukꞌ ubꞌinik usilabꞌik chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","China kꞌu ri kusipaj tobꞌ xa juna tzima yaꞌ joron che junoq chike waꞌ wa chꞌutiꞌq ruma e nutijoꞌn, paqatzij wi kambꞌiꞌij chiwe, riꞌ na kujam ta kꞌana ri rajil ukꞌaxel» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Echiriꞌ ri Jesús xukꞌis kipixabꞌaxik ri kabꞌlajuj utijoꞌn, xel bꞌi chiriꞌ re kakꞌutunik y re kutzijoj Ruchꞌaꞌtem ri Dios chupa taq ri kitinamit rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ri Juan kꞌo pa cárcel echiriꞌ xuta ri kuꞌan ri Cristo. Xebꞌutaq kꞌu lo kaꞌibꞌ chike rutijoꞌn rukꞌ Rire, ");
INSERT INTO acrNNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","chaꞌ keꞌkitzꞌonoj che: —¿E rilal Ruchaꞌoꞌn lo ri Dios, ri Jun bꞌiꞌtal chik kakꞌunik, o kaqoyꞌej chi junoq chik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Ri Jesús xukꞌul uwach: —Jix y chitzijoj che ri Juan ronoje wa kixtajin che utayik y che rilik. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ma ri e potzꞌ ketzuꞌnik, ri e sik kebꞌinik, ri kꞌo yabꞌil lepra chike kekunutajik, ri e tꞌoꞌk ketanik, ri ekaminaq kekꞌastajik y chike ri nibꞌaꞌibꞌ katzijox ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Nim uqꞌij ralaxik kꞌu riꞌ ri na kasach ta ri kubꞌulibꞌal ukꞌuꞌx wukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ekꞌuchiriꞌ xebꞌek rike, ri Jesús xujeq kachꞌaꞌt puwi ri Juan chike ri winaq, jewaꞌ xubꞌiꞌij: «¿Saꞌ ri xeꞌila alaq pa ri luwar katzꞌintzꞌotik? ¿Xeꞌila nebꞌa alaq jun achi na jinta ukowil xa pachaꞌ tani kajabajoꞌx ruma ri tew? ");
INSERT INTO acrNNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Saꞌ ri xeꞌila alaq? ¿Xeꞌila nebꞌa alaq jun achi uwiqom ribꞌ rukꞌ chomilaj kꞌul? Na e ta riꞌ, ma etaꞌam alaq ri lik kewiqiqik, riꞌ pa kocho e aj wach ejeqel wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kantzꞌonoj kꞌu riꞌ: ¿Saꞌ ri xeꞌila alaq? ¿Xeꞌila alaq jun qꞌalajisanel? Areꞌ, yey paqatzij wi kambꞌiꞌij che alaq: Rire e más kꞌo uwach chikiwa ri jujun chik qꞌalajisanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Ma jewaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios puwi ri Juan: Riꞌin kannabꞌesaj bꞌi ri waj chak chawach Riꞌat chaꞌ kuyijbꞌaꞌ ri bꞌe chwach pan rawoponibꞌal kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","»Paqatzij wi kambꞌiꞌij che alaq: Na jinta junoq chike ri tikawex ebꞌalaxinaq wara che ruwachulew más kꞌo uwach chwa ri Juan Aj Yaꞌl Bautismo. Pero chwi kꞌu riꞌ waꞌ wa keꞌek, china ri kok chupa rutaqanik ri Dios petinaq chilaꞌ chikaj, tobꞌ na jinta uwach, más nim uqꞌij ralaxik chwa ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","»Rukꞌ ri Juan Aj Yaꞌl Bautismo xjeq lo utzijoxik ri Utzilaj Tzij puwi rutaqanik ri Dios petinaq chilaꞌ chikaj, y waꞌ kꞌa katajin utzijoxik waqꞌij ora, tobꞌ e kꞌo ri kakitij uqꞌij kakiqꞌatej waꞌ. Na rukꞌ ta kꞌu riꞌ, e ri lik kakitij uqꞌij kakitzukuj wa taqanik, kayaꞌtaj chike kebꞌok chupa. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Ma lik chwach pana echiriꞌ xujeq katzijon ri Juan, ri qꞌalajisanelabꞌ y ri Moisés kitzꞌibꞌam chi lo chupa ri Tzij Pixabꞌ chwi rukꞌunibꞌal rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","We kiwaj kꞌu riꞌix kikojo, ri Juan e ri Elías, ri jun bꞌiꞌtal chik kakꞌunik. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","»¿China kꞌu rukꞌ kanjunimaj wi kiwach wa winaq re waqꞌij ora? E kanjunimaj kukꞌ ri kꞌoꞌmabꞌ kebꞌeꞌtzꞌula pa kꞌayibꞌal y lik kesikꞌin chikiwach, ");
INSERT INTO acrNNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","kakibꞌiꞌij: Echiriꞌ riꞌoj xqachꞌawisaj suꞌ chiwe, riꞌix na xiwaj taj kix-xajawik; yey echiriꞌ xqatunaj bꞌix bꞌisobꞌal uwach chiwe, na xiwaj taj kixjuyuyik kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","»Jekꞌulaꞌ kakiꞌan taq ri winaq, ma echiriꞌ xkꞌun ri Juan Aj Yaꞌl Bautismo, rire lik kuꞌan ayuno y na kutij tane vino. Yey ri winaq kakibꞌiꞌij: “Waꞌ waꞌchi kꞌo puqꞌabꞌ jun itzel uxlabꞌixel” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","»Xkꞌun kꞌu lo Ralaxel Chikixoꞌl Tikawex. Rire kutij ronoje ri kayaꞌ chwach, yey taq ri winaq kakibꞌiꞌij: “Waꞌ wa jun achi lik japjatel y qꞌabꞌaꞌrel, kachbꞌiꞌil raj tzꞌonol puaq re tojonik y raj makibꞌ” kechaꞌ. Noꞌj kaqꞌalajin na kꞌut china taq ri lik kꞌo runaꞌoj ri Dios kukꞌ ruma ri kiꞌanom» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ekꞌuchiriꞌ, ri Jesús lik xebꞌuyaj ri winaq re taq ri tinamit pa uꞌanom wi ukꞌiyal milagros, ma rike na xkitzelej ta kitzij chwach ri Dios. Jekꞌuwaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","«¡Lik toqꞌoꞌ iwach ri ix aj Corazín! ¡Lik toqꞌoꞌ iwach ri ix aj Betsaida! Ma we ta chupa ri tinamit Tiro y ri tinamit Sidón xilitaj wi wa kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xinꞌan chiwach riꞌix, kꞌo tan qꞌij ta lo riꞌ xkitzelej kitzij chwach ri Dios, kikojom chi kꞌu kiqꞌuꞌ kꞌax rij y kitzꞌuyubꞌam kibꞌ pa chaaj ruma ri kibꞌis. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","E uwariꞌche kambꞌiꞌij chiwe: Echiriꞌ kopon ri qꞌij re ri qꞌatbꞌal tzij, más nim ri kꞌaxkꞌobꞌik kape piwi riꞌix chwa ri kꞌaxkꞌobꞌik kape pakiwi ri winaq re ri tinamit Tiro y ri tinamit Sidón. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","»Yey ri ix aj Capernaúm, e chiwach riꞌix lik yakom chi iqꞌij kꞌa chikaj; yey na e ta riꞌ, ma lik kakꞌaq ne bꞌi iqꞌij y kixkꞌaq ne bꞌi kꞌa chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. Ma we ta pa ri tinamit Sodoma xilitaj wi wa milagros xinꞌan chiwach riꞌix ix aj Capernaúm, riꞌ laꞌ la tinamit kꞌa kꞌo tane woꞌora. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ekꞌu kambꞌiꞌij waꞌ chiwe: Pa ri qꞌij re ri qꞌatbꞌal tzij, lik nim ri kꞌaxkꞌobꞌik kape piwi riꞌix chwa ri xpe pakiwi ri winaq re ri tinamit Sodoma» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ekꞌu laꞌ la joqꞌotaj ri Jesús xuꞌan orar chwach Ruqaw, jewaꞌ xubꞌiꞌij: «Nuqaw, kanyak qꞌij la, Lal Rajaw ruwa kaj y ruwachulew, ma ri qꞌalajisam la chike ri lik kakiꞌan chꞌutiꞌn che kibꞌ, waꞌ ewam la chikiwach ri lik kꞌo kinaꞌoj y lik kꞌo kimajom. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jelaꞌ xꞌan la, Nuqaw, ma e xꞌaj la riꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Tekꞌuchiriꞌ, xubꞌiꞌij chike ri tikawex: «Ronoje taq ri kꞌolik yaꞌtal lo panuqꞌabꞌ ruma ri Nuqaw. Na jinta kꞌu junoq lik umajom usukꞌ chi utz saꞌ ruwach Rukꞌajol ri Dios, xew ri Qaqaw Dios etaꞌmayom re. Y na jinta ne junoq umajom usukꞌ chi utz saꞌ ruwach ri Qaqaw Dios, xew Rukꞌajol ri Dios etaꞌmayom re; yey puqꞌabꞌ kꞌu riꞌ Rukꞌajol kꞌo wi china chike karaj kuqꞌalajisaj wi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","»Chixpeta wukꞌ, iwonoje ri ix kosinaq y kꞌo iweqaꞌn, ma riꞌin kanya uxlanem chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chiyaꞌa iwibꞌ chuxeꞌ ri nuyuku kankoj riꞌin chiwe. Chimaja kꞌu iweꞌix chwij, ma riꞌin utz nukꞌuꞌx y na kanꞌan ta nim che wibꞌ chiwach. We kiꞌan kꞌu riꞌ waꞌ, kiriq na ri utzil chomal piwanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ma ri nuyuku riꞌin, na kꞌayew ta rukꞌaxik bꞌi y ri eqaꞌn kanya bꞌi chiwe na al taj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Chupa taq kꞌu riꞌ laꞌ la qꞌij pa jun qꞌij re uxlanibꞌal, ri Jesús kukꞌ rutijoꞌn e riꞌ kebꞌikꞌow pa taq tikoꞌn re trigo. Ekꞌu rutijoꞌn, ruma lik kenumik, xkijeq kakichꞌupilaꞌ bꞌi ri trigo; tekꞌuchiriꞌ, kakiqil rukꞌ ri kiqꞌabꞌ y kakitijo. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Echiriꞌ ri fariseos xkil waꞌ, xkibꞌiꞌij che ri Jesús: —Chilape la, ri e tijoꞌn la kakiꞌan ri na taqal taj kaꞌaniꞌ chupa ri qꞌij re uxlanibꞌal —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ekꞌu ri Jesús xukꞌul uwach: —¿Na ajilam ta nebꞌa alaq ri xuꞌan ri David julaj echiriꞌ rire kukꞌ ri rachbꞌiꞌil xenumik? ");
INSERT INTO acrNNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Xok kꞌu chupa ri Rocho Dios y junam kukꞌ ri rachbꞌiꞌil xkitij ri pam yaꞌtal chi puqꞌabꞌ ri Dios; tobꞌ na taqal ta chike rike kakitijo, ma waꞌ xew taqal chike raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","»¿Na iwajilam ta nebꞌa ri tzꞌibꞌital kan ruma ri Moisés chupa ri Tzij Pixabꞌ? Ma kubꞌiꞌij e raj chakunel pa Rocho Dios na kebꞌuxlan ta chupa ri qꞌij re uxlanibꞌal; na rukꞌ ta kꞌu riꞌ, waꞌ na mak ta chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","»Kambꞌiꞌij kꞌu riꞌin chiwe: Kꞌo jun wara más nim uqꞌij chwa ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","We ta riꞌix imajom usukꞌ saꞌ keꞌelawi ri kubꞌiꞌij ri Dios chupa Ruchꞌaꞌtem: Ri lik kuaj Riꞌin chiwe e ri kꞌutubꞌal re ri kꞌaxnaꞌbꞌal kꞌuꞌxaj, na e ta ri kakamisax awaj re qasaꞌn chinuwach kachaꞌ; we ta kꞌu lik kimaj usukꞌ waꞌ, riꞌ na kiqꞌat ta tzij pakiwi ri na jinta mak kiꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ma Ralaxel Chikixoꞌl Tikawex e rajaw ri qꞌij re uxlanibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Echiriꞌ xel ri Jesús chiriꞌ, xok chupa ri sinagoga re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Kꞌo kꞌu jun achi chiriꞌ chaqijinaq jun uqꞌabꞌ. Yey e taq ri lik kakitzukuj suꞌanik kakitzꞌaq uchiꞌ ri Jesús, xkitzꞌonoj che: —¿Ubꞌe nawi kakunax juna yewaꞌ chupa ri qꞌij re uxlanibꞌal? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ri Jesús xukꞌul uwach: —¿Kꞌo nawi junoq che alaq we pa ri qꞌij re uxlanibꞌal tzaqinaq juna ubꞌexex pa siwan, na keꞌresaj tuloq? ");
INSERT INTO acrNNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿China kꞌu ri más kꞌo uwach, e rachi o e ri bꞌexex? Ruma kꞌu riꞌ, taqalik kaꞌan ri utz chupa ri qꞌij re uxlanibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús che rachi chaqijinaq uqꞌabꞌ: —Chasukꞌupij raqꞌabꞌ —xchaꞌ. Ekꞌu rachi xuyuq ruqꞌabꞌ y waꞌ xutzirik, ruqꞌabꞌ xuꞌan tanchi jelaꞌ pachaꞌ ri jun chik. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Xebꞌel kꞌu bꞌi ri fariseos y xkichꞌaꞌtibꞌej chikiwach suꞌanik kakisach uwach ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ri Jesús retaꞌam saꞌ ri kakaj kakiꞌan che; ruma kꞌu laꞌ, xel bꞌi chiriꞌ y lik e kꞌi ri winaq xeterej bꞌi chirij. Ekꞌu Rire xebꞌukunaj konoje ri yewaꞌibꞌ ");
INSERT INTO acrNNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","yey lik xebꞌupixabꞌaj chaꞌ na kakiqꞌalajisaj taj china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Xuꞌan taq waꞌ chaꞌ e xuꞌana rubꞌiꞌim ri Dios ruma ri qꞌalajisanel Isaías: ");
INSERT INTO acrNNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","E waj chak waꞌ, ri Jun nuchaꞌom loq. Riꞌin lik kꞌax kannaꞌo y lik kinkiꞌkot rukꞌ. Kanya kꞌu ri Wuxlabꞌixel puwi Rire chaꞌ kutzijoj ri lik usukꞌ kanꞌan Riꞌin chikiwach konoje taq ri tinamit che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na rukꞌ ta yaj, na rukꞌ ta sikꞌ kuꞌan waꞌ; Na jinta kꞌu junoq riꞌ kataw re kayajanik o kasikꞌin pa taq bꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Yey Rire na kusach tane uwach ri xa chꞌitil chik. E pachaꞌ junoq na keꞌek ta che uqꞌepik juna suꞌ kotokik y na kuyubꞌij tane juna mecha xa kabꞌutzutz chik; ma kukꞌut ri rutzil ukꞌuꞌx chike taq ri paxinaq kikꞌuꞌx y ri na jinta chi kichuqꞌabꞌ. Jekꞌuriꞌlaꞌ kuꞌano kopon na ri qꞌij echiriꞌ na jinta chi junoq kachꞌijow uchuqꞌabꞌ ri lik usukꞌ kanꞌan Riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Konoje taq kꞌu riꞌ ri tinamit che ruwachulew lik kakikubꞌaꞌ pan kikꞌuꞌx rukꞌ Rire xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ekꞌuchiriꞌ, xkikꞌam bꞌi chwach ri Jesús jun achi potzꞌ y meꞌt yey kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. Ekꞌu ri Jesús xukunaj y jekꞌulaꞌ waꞌchi xtzuꞌnik y xujeq kachꞌaꞌtik. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Konoje kꞌu ri winaq lik xkam kanimaꞌ che y xkibꞌiꞌij: «¿Kꞌaxtaj e rire ri Ralkꞌoꞌal kan ri rey David?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ekꞌu ri fariseos echiriꞌ xkita waꞌ, xkibꞌiꞌij: «Waꞌ wa jun achi kebꞌeresaj bꞌi ri itzel uxlabꞌixel ruma ruchuqꞌabꞌ ri Beelzebú, ri kajawal ri itzel uxlabꞌixel» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Ri Jesús retaꞌam saꞌ ri kakichꞌobꞌo; ruma kꞌu riꞌ, xubꞌiꞌij chike: «We ri taqanelabꞌ re juna tinamit kijachom kipa ruma kechꞌoꞌjin chikiwach, riꞌ na kanajtir ta ri kitaqanik. Yey we ri ejeqelel pa juna tinamit o pa juna ja kijachom kipa ruma kechꞌoꞌjin chikiwach, riꞌ na ketikiꞌ ta chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Jekꞌulaꞌ, we ta ri Satanás karesaj bꞌi ri Satanás chike ri winaq, riꞌ e pachaꞌ kachꞌoꞌjin chiribꞌil ribꞌ y utukel kujach upa rutaqanik. ¿Saꞌ kꞌu uꞌanik riꞌ kanajtir rutaqanik? ");
INSERT INTO acrNNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","»Ralaq kabꞌiꞌij alaq riꞌin kebꞌenuwesaj bꞌi taq ri itzel uxlabꞌixel rukꞌ ruchuqꞌabꞌ ri Beelzebú. We ta e riꞌ, ¿china kꞌu kayaꞌw kichuqꞌabꞌ riꞌ ri e tijoꞌn alaq chaꞌ kekesaj bꞌi taq ri itzel uxlabꞌixel? ¿Rukꞌ nawi ruchuqꞌabꞌ ritzel winaq kakiꞌano? Tzꞌonoj kꞌu alaq riꞌ chike ri e tijoꞌn alaq we e uꞌanom riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Pero we riꞌin kebꞌenuwesaj bꞌi taq ri itzel uxlabꞌixel rukꞌ ruchuqꞌabꞌ ri Ruxlabꞌixel ri Dios, waꞌ e kꞌutubꞌal re kꞌuninaq chi rutaqanik ri Dios chixoꞌlibꞌal alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","»Tape alaq: ¿Suꞌanik kok juna eleqꞌom pa rocho junoq lik kꞌo uchuqꞌabꞌ yey kareleqꞌaj kꞌu lo rubꞌitaq re pa ja, we na kuyut ta nabꞌe ri rajaw ja? Ma we releqꞌom uyutum chi ri rajaw ja, kꞌa ekꞌuchiriꞌ utz kareleqꞌaj bꞌi ronoje la kꞌo pa ri ja. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","»China kꞌu ri na uꞌanom ta re wukꞌ riꞌin, riꞌ aj chꞌaꞌoj chwij. Yey china ri na katoꞌbꞌ ta wukꞌ riꞌin che kikꞌamik lo jujun chik, riꞌ e kuwulij wa chak kanꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","»E uwariꞌche kambꞌiꞌij che alaq: Kꞌo puqꞌabꞌ ri Dios kukuy ronoje taq ri mak ke ri tikawex rukꞌ ronoje taq ri na utz taj kakibꞌiꞌij, noꞌj na kukuy ta umak ri kachꞌaꞌt chirij ri Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","China ri tzel kachꞌaꞌt chirij Ralaxel Chikixoꞌl Tikawex, riꞌ kakuytaj umak we kutzelej utzij. Noꞌj ri tzel kachꞌaꞌt chirij ri Santowilaj Ruxlabꞌixel ri Dios, riꞌ na kakuytaj ta kꞌana umak che waꞌ wa qꞌij oj kꞌo wi y na kakuytaj tane kꞌana umak tobꞌ ne che ruqꞌijol ri kꞌaslemal katajin loq. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","»E juna chomilaj cheꞌ, lik chom rujiqꞌobꞌalil kuyaꞌo; yey ri cheꞌ na chom taj, na chom ta rujiqꞌobꞌalil kuyaꞌo. Ma ri cheꞌ ketaꞌmax uwach ruma rujiqꞌobꞌalil. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Ralaq pachaꞌ alaq jupuq chi kumatz! ¿Suꞌanik kꞌu riꞌ kachꞌaꞌtibꞌej alaq ri utz we itzel kꞌuꞌx alaq? Ma rukꞌ ruchꞌaꞌtem ri tikawex kaqꞌalajin ronoje ri ukꞌolom chupa ri ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jekꞌulaꞌ e junoq utz ukꞌuꞌx, echiriꞌ kachꞌaꞌtik, e karesaj lo ri chom ukꞌolom chupa ri ranimaꞌ. Yey e junoq itzel ukꞌuꞌx, echiriꞌ kachꞌaꞌtik, e karesaj lo ri na chom taj ukꞌolom chupa ri ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","»Riꞌin kambꞌiꞌij kꞌu che alaq: Chupa ri qꞌij re ri qꞌatbꞌal tzij, chikijujunal ri tikawex kataꞌ kichiꞌ ruma ronoje ri chꞌulilaj chꞌaꞌtem kel lo chwa keꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ma chijujunal alaq, we utz ri chꞌaꞌtem alaq, riꞌ kaqꞌalajinik alaq jusukꞌ; noꞌj we na chom ta ri chꞌaꞌtem alaq, riꞌ kaqꞌat tzij pawiꞌ alaq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ekꞌuchiriꞌ, jujun chike ri fariseos y raj kꞌutunel re ri tzijpixabꞌ, xkibꞌiꞌij che ri Jesús: —Lal tijonel, riꞌoj kaqaj kaqilo kaꞌan la juna kꞌutubꞌal re ri chuqꞌabꞌ la chiqawach —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ri Jesús xukꞌul uwach: —Ri kakitzꞌonoj kꞌutubꞌal re ruchuqꞌabꞌ ri Dios e ri winaq re waqꞌij ora, ri itzel kikꞌuꞌx y na jusukꞌ ta ri kanimaꞌ chwach ri Dios. Noꞌj na kayaꞌtaj ta kꞌu waꞌ chike, ma xew kayaꞌtaj ri kꞌutubꞌal xꞌaniꞌ ojertan rukꞌ ri qꞌalajisanel Jonás. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ma jelaꞌ pachaꞌ ri Jonás xkꞌojiꞌ oxibꞌ qꞌij y oxibꞌ aqꞌabꞌ chupa ri nimalaj kar, jekꞌulaꞌ Ralaxel Chikixoꞌl Tikawex oxibꞌ qꞌij y oxibꞌ aqꞌabꞌ kamuqiꞌ pulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","»Ri winaq aj Nínive re ojertan keyaktaj chupa ri qꞌij re qꞌatbꞌal tzij y kakikoj kimak ri tikawex re waqꞌij ora. Ma rike xkitzelej kitzij chwach ri Dios ruma ri tzijonik xuꞌan ri Jonás chikiwach. Noꞌj ri tikawex re waqꞌij ora, kꞌo jun chikixoꞌl más kꞌo uwach chwa ri Jonás, yey na kebꞌok tane il che. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","»Jekꞌulaꞌ echiriꞌ kopon ri qꞌij re ri qꞌatbꞌal tzij, kayaktaj lo ri reina re pa sur y kukoj kimak ri tikawex re waqꞌij ora. Ma rojertan lik naj petinaq wi rire chaꞌ koluꞌxikinaj runaꞌoj ri rey Salomón. Noꞌj ri tikawex re waqꞌij ora, kꞌo jun chikixoꞌl más kꞌo uwach chwa ri Salomón, yey na kebꞌok tane il che. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","»Echiriꞌ juna itzelilaj uxlabꞌixel kel bꞌi che juna tikawex, ri kuꞌano e kasutin pa taq luwar katzꞌintzꞌotik, kutzukuj pa kajeqiꞌ wi. Yey we na kuriq taj, ");
INSERT INTO acrNNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kubꞌiꞌij kꞌu chiribꞌil ribꞌ: “Kintzelej pe chupa ri wocho pa xinel lo wi” kachaꞌ. Ekꞌuchiriꞌ koponik, kuꞌriqa rachi pachaꞌ juna ja kꞌa jinta rajaw, mesom upa y yijbꞌital chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Keꞌek kꞌut, kebꞌuꞌkꞌama chi lo wuqubꞌ rach itzelilaj uxlabꞌixel más itzel kiwachlibꞌal chwa rire; y konoje kꞌu riꞌ kebꞌokik y kejeqiꞌ chiriꞌ. Jekꞌuriꞌlaꞌ, rubꞌinik rachi más kayojtaj chwa ri petinaq loq. Ekꞌu kakikꞌulumaj waꞌ ri winaq itzel kikꞌuꞌx waqꞌij ora —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ekꞌu ruchu y taq ruchaqꞌ ri Jesús xekꞌun loq echiriꞌ Rire kꞌa kachꞌaꞌt ne kukꞌ ri winaq. Xekꞌojiꞌ kꞌu lo pa bꞌe yey lik kakaj kechꞌaꞌt rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kꞌo kꞌu jun xubꞌiꞌij pan che ri Jesús: —Ri chu la y taq ri chaqꞌ la e kꞌo pa bꞌe yey lik kakaj kechꞌaꞌt ukꞌ la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ekꞌu ri Jesús xubꞌiꞌij che ri xbꞌiꞌn pan che: —Chawach riꞌat, ¿china kꞌu ri nuchu y china taq ri nuchaqꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ekꞌuchiriꞌ, rukꞌ ruqꞌabꞌ xebꞌukꞌut rutijoꞌn y xubꞌiꞌij: —Wa e kꞌo wara e nuchu y e taq nuchaqꞌ riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Ma china ri kuꞌan janipa ri karaj ri Nuqaw kꞌo chilaꞌ chikaj, waꞌ e nuchaqꞌ, e wanabꞌ y e nuchu riꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Chupa laꞌ la qꞌij, ri Jesús xel bꞌi pa ri ja y xeꞌtzꞌula chuchiꞌ ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Y ukꞌiyal winaq kꞌut xemolotaj chiriꞌ pa kꞌo wi Rire. Ruma laꞌ, ri Jesús xok chupa jun barco, xtzꞌuyiꞌ chupa y konoje ri winaq xekanaj kan chuchiꞌ ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Yey Rire xujeq uyaꞌik ukꞌiyal kꞌutunik chikiwach rukꞌ taq kꞌambꞌal naꞌoj, jewaꞌ xubꞌiꞌij chike: «Jun awanel xel bꞌi chaꞌ keꞌawanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ekꞌuchiriꞌ katajin che ujopopexik rijaꞌ, kꞌo xtzaq kan chuchiꞌ ri bꞌe. Xekꞌun kꞌu lo tzꞌikin y xoꞌlkitija bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","»Kꞌo ijaꞌ xtzaq kan pa taq abꞌaj; yey ruma na jinta ukꞌiyal ulew chuxeꞌ, xel tan lo rijaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Ekꞌuchiriꞌ xel lo ri qꞌij, xkꞌatik; yey ruma na jinta ratzꞌayaq, xchaqijik. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","»Kꞌo ijaꞌ xtzaq kan pa taq kꞌiix. Ekꞌu ri kꞌiix xkꞌiyik yey rijaꞌ xjiqꞌ kan chuxeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","»Noꞌj kꞌo ijaꞌ xtzaq kan pa chomilaj ulew. Ekꞌu riꞌ waꞌ lik xuꞌan reqaꞌn. Kꞌo ne jujun raqan xuya jun ciento, kꞌo jujun chik xuya sesenta y kꞌo xuya treinta. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ekꞌu rutijoꞌn xeqibꞌ rukꞌ ri Jesús y xkitzꞌonoj che: —¿Suꞌbꞌe kakꞌutun la chikiwach ri winaq rukꞌ taq kꞌambꞌal naꞌoj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ri Jesús xukꞌul uwach: —Chiwe riꞌix yaꞌtalik kaqꞌalajisax runaꞌoj ri Dios chwi rutaqanik petinaq chilaꞌ chikaj; noꞌj chike taq ri winaq, na yaꞌtal taj. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Ma china ri kꞌo umajom chik, riꞌ kayaꞌtaj ne che chaꞌ más kꞌo kumajo. Noꞌj china ri na jinta kꞌo umajom, kamaj ne che ri kuchꞌobꞌo umajom chik. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ruma laꞌ kinchꞌaꞌt kukꞌ rike xa rukꞌ taq kꞌambꞌal naꞌoj. Ma tobꞌ rike ketzuꞌnik, e junam rukꞌ na ketzuꞌn taj; tobꞌ ketanik, e junam rukꞌ na ketan taj y e riꞌ na jinta kꞌo kakimaj usukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ma ri kikꞌulumam rike e kuꞌana pachaꞌ rubꞌiꞌim kan ri Dios ruma ri qꞌalajisanel Isaías: Riꞌix tobꞌ kixtanik, na jinta kꞌo kimaj usukꞌ che ri kito; y tobꞌ ne kixtzuꞌnik, na jinta kꞌo kimaj usukꞌ che ri kiwilo. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ma wa tinamit lik uꞌanom ko ri kanimaꞌ; e pachaꞌ lik kꞌayew chike ketanik, y ri kiwach e pachaꞌ yupulik. Jekꞌulaꞌ na jinta kꞌo kakilo, na jinta kꞌo kakito y na jinta kꞌo kakimaj usukꞌ; yey na kakitzelej tane kitzij chinuwach chaꞌ jelaꞌ kebꞌenukunaj xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","»Noꞌj riꞌix lik nim iqꞌij iwalaxik, ma ri Dios kuya chiwe kiwilo y kita janipa ri kuꞌan Rire wuma riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Paqatzij wi kambꞌiꞌij chiwe: Ojertan ukꞌiyal qꞌalajisanelabꞌ y tikawex jusukꞌ kibꞌinik kisilabꞌik lik xkaj kakil bꞌi janipa ri kiwil riꞌix woꞌora; pero na xkimaj ta chi rilik bꞌi. Lik xkaj kakita bꞌi janipa ri kita riꞌix woꞌora, pero na xkimaj ta chi utayik bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","»Chita kꞌut saꞌ keꞌelawi ri kꞌambꞌal naꞌoj puwi ri awanel. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Rijaꞌ xtzaq kan chuchiꞌ ri bꞌe, e pachaꞌ ri tikawex ketaw re ri chꞌaꞌtem chwi rutaqanik ri Dios yey na kakimaj ta usukꞌ. Kakꞌun kꞌu lo ritzel winaq y karesaj bꞌi ri chꞌaꞌtem xtikiꞌ pa kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","»Rijaꞌ xtzaq kan pa taq abꞌaj, e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios y kakikoj rukꞌ kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Pero ruma na e tikil ta chi utz, na kekowin taj. Ma echiriꞌ kakꞌun lo kꞌambꞌal kipa o keternabꞌex rukꞌ kꞌax ruma kikꞌulum Ruchꞌaꞌtem ri Dios, kepajtaj kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","»Rijaꞌ xtzaq kan pa taq kꞌiix e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios. Pero rubꞌis kikꞌuꞌx chwi taq ri kajawax chike, rukꞌ ri sokosoꞌnik re taq ri bꞌeyomalil, kusachisaj uwach Ruchꞌaꞌtem ri Dios kꞌo pa kanimaꞌ. Ruma kꞌu riꞌ, na jinta kꞌana kijiqꞌobꞌalil kilitaj che ri kibꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","»Noꞌj rijaꞌ xtzaq kan pa chomilaj ulew e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios, lik kakimaj usukꞌ y lik kꞌo kꞌu kijiqꞌobꞌalil kilitaj che ri kibꞌinik. E jelaꞌ pachaꞌ rijaꞌ lik xuꞌan reqaꞌn; kꞌo ne jujun raqan xuya jun ciento, kꞌo jujun chik xuya sesenta y kꞌo xuya treinta —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ri Jesús xutzijoj tanchi jun kꞌambꞌal naꞌoj chike: «Ri kuꞌana pa rutaqanik ri Dios petinaq chilaꞌ chikaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ jun achi xutik chomilaj ijaꞌ trigo chwa ri rulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ekꞌuchiriꞌ kewar konoje ri tikawex, xopon jun achi tzel karil ri rajaw rulew; xeꞌlaqꞌay kꞌu riꞌ xutik kan raqꞌes cizaña chuxoꞌl ri trigo y xeꞌek kꞌut. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Xel kꞌu lo ri trigo y echiriꞌ xpoqꞌik, xqꞌalajin raqꞌes kꞌo chupa. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ekꞌu ri aj chakibꞌ xeꞌkibꞌiꞌij che ri rajaw ri tikoꞌn: “Qajawal, we chomilaj ijaꞌ xeꞌtika la chwa rulew la, ¿pachawi kꞌu riꞌ xpe wi raqꞌes xel lo chupa?” ");
INSERT INTO acrNNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","»Yey ri rajaw ri tikoꞌn xubꞌiꞌij chike: “Kꞌo junoq laꞌ tzel kinrilo xoluꞌtika chupa.” Xkibꞌiꞌij kꞌu ri raj chakibꞌ che: “We kaꞌaj la, keꞌqamichꞌa ronoje raqꞌes chupa.” ");
INSERT INTO acrNNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","»Ekꞌu ri rajaw ri tikoꞌn xubꞌiꞌij chike: “Na kiꞌmichꞌa taj; ma we ximichꞌ raqꞌes, kꞌaxtaj kimichꞌ ri trigo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Chiyaꞌa luwar chekꞌiy na junam, kopon na ruqꞌijol ri molonik. Ma kꞌa e chiriꞌ kebꞌenutaq ri waj chak chaꞌ kakimol na raqꞌes nabꞌe, kakiꞌan chiyataꞌj y kakixim upa re kaporoxik. Tekꞌuchiriꞌ, kakimol ri trigo y keꞌkiyaꞌa pa kakꞌoliꞌ wi ri trigo weꞌin”» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ri Jesús xutzijoj tanchi jun kꞌambꞌal naꞌoj chike: «Rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ juna ijaꞌ re moxtasa xutik jun achi chwa ri rulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Paqatzij wi, laꞌ liꞌjaꞌ e más chꞌutiꞌn chwa taq rijaꞌ; noꞌj we xkꞌiyik, más kanimar chwa taq raqꞌes y kuꞌana pachaꞌ jun cheꞌ. Kekꞌun ne ri tzꞌikin kexikꞌikꞌ che ruwa kaj y kakiꞌan kisok puwi taq ruqꞌabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ri Jesús xutzijoj wa jun chik kꞌambꞌal naꞌoj chike: «Rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ ri levadura. Ma echiriꞌ juna ixoq kuꞌan pam, kukꞌam jubꞌiqꞌ levadura y kutuk chuxoꞌlibꞌal oxibꞌ pajbꞌal harina; yey ri levadura kusipowirisaj upa ronoje ri qꞌor» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ri Jesús xukꞌut ronoje waꞌ chike ri winaq rukꞌ taq kꞌambꞌal naꞌoj y na jinta kꞌo xukꞌutu we na rukꞌ ta kꞌambꞌal naꞌoj xuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","E xuꞌan waꞌ chaꞌ e kuꞌana rubꞌiꞌim kan ri jun qꞌalajisanel echiriꞌ xutzꞌibꞌaj: Rukꞌ taq kꞌambꞌal naꞌoj kinkꞌutunik; e kanqꞌalajisaj ri na etaꞌmatal ta chwi lo ri jeqebꞌal re ruwachulew xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ekꞌuchiriꞌ, ri Jesús xebꞌuchꞌaꞌbꞌej kan ri winaq y xok bꞌi pa ja. Xeqibꞌ kꞌu rutijoꞌn rukꞌ y xkitzꞌonoj che: —Qajawal, qꞌalajisaj la chiqe saꞌ keꞌelawi ri kꞌambꞌal naꞌoj puwi raqꞌes cizaña —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ekꞌu ri Jesús xukꞌul uwach: —Rachi katikow re ri chomilaj ijaꞌ e Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Rulew pa katik wi ri tikoꞌn e ruwachulew. Ri chomilaj ijaꞌ e taq ri tikawex e kꞌo chupa rutaqanik ri Dios. Rijaꞌ re raqꞌes cizaña e taq ri tikawex eteran chirij ritzel winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ri jun itzel ukꞌuꞌx xutik raqꞌes e ritzel winaq. Ri molonik e ri kꞌisbꞌal re ruwachulew, yey ri keꞌanaw re ri molonik e ri ángeles. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","»Jekꞌulaꞌ pachaꞌ ri kaꞌan che raqꞌes cizaña, kamolik y kaporox pa aqꞌ, jelaꞌ ri kuꞌana che ri kꞌisbꞌal re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ralaxel Chikixoꞌl Tikawex kebꞌutaq bꞌi ru ángeles chaꞌ kekimolo y kekesaj chupa rutaqanik konoje ri ekiminom jujun chik pa mak y ri kakiꞌan ri na utz taj. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Kebꞌekikꞌaq bꞌi pa ri orna kajomow aqꞌ chupa; chiriꞌ kꞌu riꞌ kebꞌoqꞌ wi y kaqichꞌichꞌ ruwi keꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Noꞌj ri jusukꞌ kibꞌinik kisilabꞌik e jelaꞌ pachaꞌ ri qꞌij kewon chilaꞌ pa kataqan wi ri kiqaw Dios. China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","«Rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ jun bꞌeyomalil ewatal kan chupa juna ulew. Kꞌo kꞌu jun achi keꞌtzaq lo puwiꞌ y karewaj tanchi kanoq. Keꞌek kꞌu chirocho y kuꞌkꞌayij ronoje rubꞌitaq re; tekꞌuchiriꞌ, kuloqꞌ ri ulew pa kꞌo wi ri bꞌeyomalil. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","»Rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ ri kuꞌan juna aj kꞌay kutzukuj taq chomilaj abꞌaj perla. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ekꞌuchiriꞌ kuriq juna chomilaj perla lik kꞌi rajil, keꞌek y kuꞌkꞌayij ronoje rubꞌitaq re; tekꞌuchiriꞌ, kuloqꞌ ri chomilaj abꞌaj perla. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","»Ri kuꞌan chupa rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ ri kuꞌano echiriꞌ kakꞌaq bꞌi juna atarraya pa ri mar chaꞌ kebꞌuꞌchapa lo ukꞌiyal kiwach taq kar. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","»Echiriꞌ nojinaq chi ri atarraya che kar, raj chapal kar kakesaj lo chuchiꞌ ri mar, ketzꞌuyiꞌ kꞌut y kekichaꞌ kipa ri kar. E taq kꞌu ri utzilaj kar, kekiya pa chakach; noꞌj taq kꞌu ri na e ta utz, kekikꞌaq bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","»Jekꞌulaꞌ kuꞌana che ri kꞌisbꞌal re ruwachulew. Kebꞌel bꞌi ri ángeles y kekesaj kꞌu ri tikawex itzel kikꞌuꞌx chikixoꞌl ri e jusukꞌ chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Kebꞌekikꞌaq kꞌu bꞌi pa ri orna kajomow aqꞌ chupa; chiriꞌ kꞌu riꞌ kebꞌoqꞌ wi y kaqichꞌichꞌ ruwi keꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ekꞌuchiriꞌ, ri Jesús xutzꞌonoj chike: —¿Kimaj usukꞌ riꞌix ronoje taq waꞌ? —xchaꞌ. Rike xkikꞌul uwach che ri Jesús: —Kaqamaj usukꞌ, Qajawal —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ekꞌu ri Jesús xubꞌiꞌij chike: —E juna aj kꞌutunel re ri tzijpixabꞌ, we lik kꞌo kumaj chwi rutaqanik ri Dios petinaq chilaꞌ chikaj, e pachaꞌ juna achi rajaw ja karesaj lo che rubꞌeyomalil ukꞌolom, taq ri kꞌakꞌ y ri xex chi kꞌo wi; yey ukabꞌichal waꞌ kuchapabꞌej. Ma ri aj kꞌutunel kakꞌutun chwi taq ri kꞌakꞌ umajom, junam rukꞌ taq ri xex chi umajom loq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ri Jesús echiriꞌ xukꞌis ubꞌiꞌxik taq wa kꞌambꞌal naꞌoj chike, xel bꞌi chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Echiriꞌ xopon pa rutinamit, xujeq kakꞌutun chiriꞌ pa ri sinagoga. Ekꞌu ri winaq lik xkam kanimaꞌ che y xkibꞌiꞌij: —¿Pa xuꞌmaja wi waꞌchi luꞌnaꞌoj? ¿Suꞌanik kuꞌan taq wa milagros? ");
INSERT INTO acrNNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Na e ta nebꞌa ukꞌajol waꞌ ri jun carpintero yey ralabꞌ ri María? ¿Na e ta nebꞌa katzixel ri Jacobo, ri José, ri Simón y ri Judas? ");
INSERT INTO acrNNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","¿Na ejeqel ta nebꞌa ri ranabꞌ wara chiqaxoꞌl? ¿Pa kꞌu xuꞌmaja wi ronoje taq riꞌ wa kuꞌano? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ewi lik e kꞌi tzel xkita ri xubꞌiꞌij. Noꞌj ri Jesús xubꞌiꞌij chike: —Chupa ronoje luwar kayak uqꞌij juna qꞌalajisanel; noꞌj chupa rutinamit o chikiwach ri ratz-uchaqꞌ, na kayak ta uqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Y ri Jesús na xuꞌan ta ukꞌiyal milagros chiriꞌ ruma na xkikoj taj china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Chupa kꞌu laꞌ la qꞌij, ri Herodes ri rey re Galilea xuta puwi ri chom uchꞌaꞌtibꞌexik ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ri Herodes xubꞌiꞌij kꞌu chike ri raj chakibꞌ: «Laꞌ e Juan Aj Yaꞌl Bautismo xkꞌastaj lo chikixoꞌl ri ekaminaq; e uwariꞌche kꞌo uchuqꞌabꞌ che uꞌanik wa milagros» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Xubꞌiꞌij waꞌ ma e rire ri xutaq uchapik ri Juan chaꞌ kayaꞌiꞌ pa karena y keyoꞌq pa cárcel. Xuꞌan waꞌ ri Herodes ma ri Juan xuchꞌaꞌbꞌej upa ruma uꞌanom rixoqil che ri Herodías, yey waꞌ wiꞌxoq e rixoqil ri Felipe ruchaqꞌ ri Herodes. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jewaꞌ ri xubꞌiꞌij ri Juan che: «Lik na ubꞌe taj ꞌanom ixoqil la che ri rixoqil ri chaqꞌ la» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Ruma kꞌu waꞌ ri Herodes lik xraj kukamisaj ri Juan, noꞌj lik kuxiꞌij ribꞌ chike ri tinamit ma chikiwach rike ri Juan e jun qꞌalajisanel re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ekꞌuchiriꞌ xukꞌis ujunabꞌ ri Herodes, xꞌaniꞌ jun nimaqꞌij. Ekꞌu ri ralit rixoq Herodías xajaw chikiwach ri esikꞌim pa ri nimaqꞌij, y waꞌ lik xukꞌul ukꞌuꞌx ri Herodes. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ruma kꞌu riꞌ, xubꞌiꞌtisij kuya che rali tobꞌ saꞌ ri karaj kutzꞌonoj, y lik xujikibꞌaꞌ uwach kuꞌan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Ekꞌu rali nabꞌe na xuꞌtzꞌonoj che ruchu y waꞌ xuya lo itzel naꞌoj che. Xubꞌiꞌij kꞌu rali che ri Herodes: «Yaꞌa la rujolom ri Juan Aj Yaꞌl Bautismo chwe pa juna plato» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Ri rey lik xbꞌisonik ruma ri xtzꞌonox che. Noꞌj ruma kꞌu ri xujikibꞌaꞌ uwach che rali chikiwach konoje ri e kꞌo rukꞌ pa ri waꞌim, xtaqan kꞌu che chaꞌ kayaꞌiꞌ na che rali ri kutzꞌonoj. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Xtaqan kꞌu che kakꞌatzix rujolom ri Juan pa ri cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jelaꞌ xkꞌam lo rujolom ri Juan pa jun plato, xyaꞌ kꞌu che rali y rali xuꞌyaꞌa che ruchu. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Tekꞌuchiriꞌ, rutijoꞌn ri Juan xoꞌlkikꞌama rucuerpo y xeꞌkimuquꞌ. Xebꞌek kꞌut, xeꞌkibꞌiꞌij che ri Jesús saꞌ ri xukꞌulumaj ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Echiriꞌ ri Jesús xretaꞌmaj puwi rukamik ri Juan, xok bꞌi pa jun barco re keꞌek pa jun luwar katzꞌintzꞌotik pa na e jinta wi winaq. Yey ri winaq echiriꞌ xketaꞌmaj, xebꞌel lo pa taq ri tinamit y chaqan xebꞌek chaꞌ koꞌlkiriqa ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Echiriꞌ ri Jesús xel lo pa ri barco, xrilo e kꞌo chi ukꞌiyal winaq chiriꞌ. Lik kꞌut xejuchꞌ kaꞌn pa ranimaꞌ y xebꞌukunaj konoje ri e yewaꞌibꞌ chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ekꞌuchiriꞌ ya kok raqꞌabꞌ, rutijoꞌn ri Jesús xeqibꞌ rukꞌ y xkibꞌiꞌij che: —Qajawal, wa luwar oj kꞌo wi lik katzꞌintzꞌotik y bꞌenaq qꞌij chik. Utz we ketaq bꞌi la ri winaq chaꞌ kebꞌek pa taq raldeas re keꞌkiloqꞌo kiwa —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Noꞌj ri Jesús xubꞌiꞌij chike: —Na kajawax taj kebꞌek; chebꞌitzuqu riꞌix —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Rike xkibꞌiꞌij che ri Jesús: —Na kꞌi ta ri waꞌim qukꞌaꞌam, xew woꞌobꞌ pam y kaꞌibꞌ kar kꞌo qukꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Xubꞌiꞌij kꞌu ri Jesús chike: —Chikꞌama lo laꞌ chwe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ekꞌuchiriꞌ, xtaqan che ketzꞌuyiꞌ ri winaq pa taq ri kꞌim. Xukꞌam kꞌu ri woꞌobꞌ pam rukꞌ ri kaꞌibꞌ kar, xtzuꞌn chikaj y xtioxin chwach ri Dios. Tekꞌuchiriꞌ, xuwechꞌ upa ri pam, xuya chike rutijoꞌn y rike xkijach chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Konoje kꞌu ri winaq xewaꞌik y xenoj chi utz. Tekꞌuchiriꞌ, xkimol ri chꞌaqaꞌtaꞌq kiqax y rukꞌ waꞌ xnoj lo kabꞌlajuj chakach. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ri xewaꞌik laj e lo woꞌobꞌ mil chi achijabꞌ yey na xebꞌajilax tane rixoqibꞌ y rakꞌalabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Tekꞌuchiriꞌ, ri Jesús xebꞌutaq rutijoꞌn chaꞌ kebꞌok bꞌi chupa ri barco, kenabꞌej bꞌi chwach y keqꞌax kꞌa chꞌaqa yaꞌ xaloqꞌ Rire kebꞌuchꞌaꞌbꞌej taq kan rukꞌiyal winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Echiriꞌ ebꞌuchꞌaꞌbꞌem chi kanoq, xpaqiꞌ chwa ri juyubꞌ chaꞌ kuꞌana orar. Xok kꞌu raqꞌabꞌ, y ri Jesús utukel kꞌo chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ekꞌu ri barco pa ebꞌenaq wi rutijoꞌn kꞌo chi pan chunikꞌajal ri mar, yey kꞌo kꞌu jun kaqjiqꞌ lik kuroj ribꞌ che ri barco, ma waꞌ pubꞌe ri kaqjiqꞌ bꞌenaq wi. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Lik anim tan kꞌut, ri Jesús xeꞌek kukꞌ rutijoꞌn, e riꞌ kabꞌin chwi ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Rutijoꞌn echiriꞌ xkilo kabꞌin ri Jesús chwi ri mar, lik xsach kinaꞌoj che, xesikꞌin kꞌu rukꞌ xiꞌin ibꞌ: —¡Leꞌ jun espíritu! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ekꞌu ri Jesús xchꞌaw chike, jewaꞌ xubꞌiꞌij: —Chinimarisaj ikꞌuꞌx, ma riꞌin in Jesús; mixiꞌij kꞌu iwibꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ekꞌuchiriꞌ, xchꞌaw pan ri Pedro che, jewaꞌ xubꞌiꞌij: —Wajawal, we qatzij e rilal, bꞌiꞌij la chwe kinꞌek ukꞌ la, e laꞌ kimbꞌin chwi ri mar kꞌa pa kꞌo wi la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Ri Jesús xubꞌiꞌij che: —Chatpeta riꞌ —xchaꞌ. Ekꞌuchiriꞌ ri Pedro xel bꞌi pa ri barco, xujeqo kabꞌin chwi ri mar chaꞌ keꞌek pa kꞌo wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Pero echiriꞌ xril ruchuqꞌabꞌ ri kaqjiqꞌ, xok xiꞌin ibꞌ rukꞌ y xujeq e riꞌ kamuqutajik. Xsikꞌin kꞌu pan riꞌ che ri Jesús, jewaꞌ xubꞌiꞌij: —¡Chinkolobꞌej la, Wajawal! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Na jampatana ri Jesús xuchapalaꞌ pan che ruqꞌabꞌ y xubꞌiꞌij che: —Pedro, ¡na nim ta kꞌana ri kubꞌulibꞌal akꞌuꞌx wukꞌ! ¿Suꞌbꞌe xuxiꞌij ribꞌ akꞌuꞌx? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Echiriꞌ ri Jesús y ri Pedro xebꞌok chupa ri barco, xtaniꞌ ri kaqjiqꞌ chwi ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ekꞌuchiriꞌ, ri e kꞌo pa ri barco xeqibꞌ rukꞌ ri Jesús y xkiloqꞌnimaj uqꞌij, jewaꞌ xkibꞌiꞌij: —Paqatzij wi lal Ukꞌajol ri Dios —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Echiriꞌ xeqꞌax chꞌaqa yaꞌ, xebꞌopon pa ri luwar re Genesaret. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ri winaq, echiriꞌ xkito kꞌo ri Jesús chiriꞌ, xkitaq ubꞌiꞌxikil pa taq ronoje laꞌ la luwar. Xekikꞌam kꞌu lo konoje ri yewaꞌibꞌ pa kꞌo wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lik xebꞌelaj kꞌu che ri Jesús chaꞌ kuya luwar chike tobꞌ xew kakichap ruchiꞌ ruqꞌuꞌ. Konoje kꞌu ri xebꞌanaw waꞌ, xekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Ekꞌuchiriꞌ, jujun chike ri fariseos y raj kꞌutunel re ri tzijpixabꞌ e petinaq Jerusalem, xeqibꞌ rukꞌ ri Jesús y xkitzꞌonoj che: ");
INSERT INTO acrNNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Suꞌchak ri tijoꞌn la kakipalajij ri kikꞌutuꞌn kan ri qatiꞌ-qamam? Ma rike na kakichꞌaj ta ri kiqꞌabꞌ nabꞌe na echiriꞌ kewaꞌik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ekꞌu ri Jesús xutzꞌonoj chike: —¿Suꞌchak ralaq kapalajij alaq Rutzij Upixabꞌ ri Dios ruma e kaꞌan alaq taq ri kikꞌutuꞌn kan ri mam alaq? ");
INSERT INTO acrNNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Ma ri Dios jewaꞌ xtaqan che: Chaloqꞌoj kiqꞌij rachu-aqaw yey We kꞌo junoq kebꞌuyaj ruchu-uqaw rukꞌ itzel chꞌaꞌtem, riꞌ lik taqal che kakamisaxik xcha ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","»Noꞌj ralaq kabꞌiꞌij alaq: “Utz we junoq kubꞌiꞌij chike ruchu-uqaw: Na utz taj kantoꞌ alaq, ma ri toꞌbꞌal kajawax che alaq, nubꞌiꞌtisim chik re nuqasaꞌn chwach ri Dios.” ");
INSERT INTO acrNNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yey chiwach ralaq, china ri kabꞌiꞌn re waꞌ, na chirajawaxik ta chi che kebꞌutoꞌ ruchu-uqaw. Jekꞌulaꞌ ꞌanom alaq che Rutzij Upixabꞌ ri Dios pachaꞌ na jinta uchak, ma e taqem alaq ri xa noꞌjibꞌal alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","»¡Xa kebꞌ palaj alaq! Lik kꞌu qatzij ri ubꞌiꞌim lo ri Dios pawiꞌ alaq ruma ri qꞌalajisanel Isaías, echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","Waꞌ wa tinamit xa rukꞌ ruwakeꞌ kakiyak nuqꞌij, noꞌj ri kanimaꞌ lik naj kꞌo wi chwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Na jinta kꞌana kutiqoj kakiloqꞌoj nuqꞌij, ma ri kꞌutunik kakiꞌano xa taqanik ke achijabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Ekꞌuchiriꞌ, xebꞌusikꞌij rukꞌiyal winaq y xubꞌiꞌij chike: —Lik tape alaq y lik maja alaq usukꞌ waꞌ: ");
INSERT INTO acrNNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Ri kok bꞌi puchiꞌ ri tikawex na e ta ri kachꞌulan re; noꞌj ri chꞌaꞌtem kel lo puchiꞌ, e waꞌ ri kachꞌulan re —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","E taq kꞌu rutijoꞌn xeqibꞌ rukꞌ y xkibꞌiꞌij che: —Qajawal, ¿xetaꞌmaj la lik xpe koyowal ri fariseos echiriꞌ xkita ri xbꞌiꞌij la? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ri Jesús xukꞌul uwach: —Waꞌ waꞌchijabꞌ na jinta runaꞌoj ri Dios kukꞌ, pachaꞌ e tikoꞌn na e ta tikom ruma ri Nuqaw kꞌo chilaꞌ chikaj; ruma kꞌu riꞌ, kamichꞌ bꞌi kꞌa pa ratzꞌayaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mixok il chike, ma rike pachaꞌ e potzꞌ e kꞌamal kiwach kach e potzꞌ. Yey we juna potzꞌ kukꞌam uwach juna chik potzꞌ, kikabꞌichal kꞌu riꞌ kebꞌeꞌtzaq bꞌi pa siwan —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ekꞌuchiriꞌ, ri Pedro xubꞌiꞌij che ri Jesús: —Qꞌalajisaj la chiqe saꞌ keꞌelawi wa jun kꞌambꞌal naꞌoj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Xubꞌiꞌij kꞌu ri Jesús chike: —¿Ix nebꞌa kukꞌil ri na jinta kinaꞌoj puwi waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿Na kimaj ta nebꞌa usukꞌ? Ma e janipa ri kok bꞌi puchiꞌ ri tikawex keꞌek pa rupa y tekꞌuchiriꞌ, kuꞌpamaj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Noꞌj ri chꞌaꞌtem kel lo puchiꞌ, pa ranimaꞌ kawinaqir wuloq y ekꞌu waꞌ ri kachꞌulan re ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Ma pa ranimaꞌ ri tikawex kel wi lo taq waꞌ: ritzel naꞌoj, ri kamisanik, ri makunik chirij ri kꞌulanikil, ri karetzꞌabꞌej uwa uqꞌij rukꞌ jun chik na ukꞌulel taj, ri eleqꞌ, ri raqꞌubꞌal y ri itzel chꞌaꞌtem chirij junoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","E taq waꞌ ri kachꞌulan ke ri tikawex. Noꞌj ri kawaꞌ junoq yey na kuchꞌaj ta ruqꞌabꞌ nabꞌe, waꞌ na kuchꞌulaj ta rubꞌinik junoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ri Jesús xel bꞌi chiriꞌ y xopon pa taq ri luwar re Tiro y re Sidón. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Kꞌo kꞌu jun ixoq aj Canaán jeqel chiriꞌ, rire kasikꞌinik xkꞌun chwach ri Jesús, jewaꞌ kubꞌiꞌij: —¡Wajawal, lal ri Ralkꞌoꞌal kan ri rey David, chinjuchꞌ kaꞌn ko cheꞌla! Ma kꞌo jun walit lik kꞌax ukꞌulumam ruma kꞌo puqꞌabꞌ jun itzel uxlabꞌixel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Noꞌj ri Jesús na xukꞌul ta kꞌana uwach. Ekꞌu rutijoꞌn xeqibꞌ rukꞌ y lik xebꞌelaj che ri Jesús: —Chꞌaꞌbꞌej kan la liꞌxoq ma lik kasikꞌinik teran lo chiqij —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús: —Riꞌin intaqom lo xew kuma rutinamit ri Dios e aj Israel, ri pachaꞌ e bꞌexex e sachinaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Noꞌj rixoq xqibꞌ rukꞌ ri Jesús, xuxuk ribꞌ chwach y xubꞌiꞌij che: —¡Wajawal, chintoꞌo ko la! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ri Jesús xubꞌiꞌij che: —Na usukꞌ taj we kꞌo junoq kumaj ri kiwa ri ralkꞌoꞌal y kukꞌaq chikiwa ri tzꞌiꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Xubꞌiꞌij kꞌu rixoq: —Qatzij, Wajawal, pero ri tzꞌiꞌ kakitij ne rukꞌaj ri wa katzaq chuxeꞌ rumexa ri kajaw —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús che: —¡Ixoq, lik nim ri kubꞌulibꞌal kꞌuꞌx la! E chuꞌana ukꞌ la saꞌ ri kaꞌaj la —xchaꞌ. Chupa kꞌu riꞌ la joqꞌotaj ri ralit xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ri Jesús xel bꞌi chiriꞌ y xikꞌow chuchiꞌ ri mar re Galilea; tekꞌuchiriꞌ, xaqꞌan chwa ri juyubꞌ y xtzꞌuyiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ukꞌiyal kꞌu winaq xebꞌopon chilaꞌ pa kꞌo wi Rire. Yey xekikꞌam lo ri e sik, ri e potzꞌ, ri e meꞌt, ri e tꞌum kaqan kiqꞌabꞌ y ukꞌiyal yewaꞌibꞌ chik. Xekiya kꞌu chwach ri Jesús, y Rire xebꞌukunaj konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ekꞌu ri winaq lik xkam kanimaꞌ che echiriꞌ xkilo xechꞌaw ri e meꞌt, ri e tꞌum kaqan kiqꞌabꞌ kekunutajik, ri e sik kebꞌinik, ri e potzꞌ ketzuꞌnik. Y xkijeq kꞌu kakiyak uqꞌij ri Dios re Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Ekꞌuchiriꞌ, ri Jesús xebꞌusikꞌij rutijoꞌn y xubꞌiꞌij chike: —Lik kajuchꞌ kaꞌn nukꞌuꞌx chike wa tikawex, ma e urox qꞌij waꞌ e kꞌo wukꞌ yey na jinta chi kiwa. Na kuaj taj kebꞌenutaq bꞌi chikocho e laꞌ na jinta kꞌo kitijom, ma kꞌaxtaj kebꞌeꞌqꞌochqꞌobꞌ pa bꞌe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Xkibꞌiꞌij kꞌu rutijoꞌn che: —¿Pa keꞌqariqa wi wa re kebꞌeqatzuq wa ukꞌiyal tikawex? Ma chupa wa luwar na jinta ne kꞌo e jeqelik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ri Jesús xutzꞌonoj chike: —¿Janipa chi pam kꞌo iwukꞌ? —xchaꞌ. Rike xkibꞌiꞌij: —Wuqubꞌ pam kꞌo qukꞌ y jujun raltaq ko kar —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ekꞌuchiriꞌ, ri Jesús xtaqan che ketzꞌuyiꞌ ri tikawex chuꞌlew. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Xukꞌam kꞌu ri wuqubꞌ pam puqꞌabꞌ rukꞌ taq ri kar, y xtioxin chwach ri Dios puwi waꞌ. Tekꞌuchiriꞌ xuwechꞌ upa y xuya bꞌi chike rutijoꞌn yey rike xkijach chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Konoje xewaꞌik y lik xenoj chi utz. Tekꞌuchiriꞌ, rukꞌ taq ruqax ri waꞌim xkimolo, xkinojisaj wuqubꞌ chakach. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ri xewaꞌik e kajibꞌ mil chi achijabꞌ yey na xebꞌajilax tane rixoqibꞌ y rakꞌalabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ekꞌuchiriꞌ, ri Jesús xebꞌuchꞌaꞌbꞌej kan ri winaq; xok bꞌi pa jun barco y xeꞌek pa taq ri luwar re Magdala. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ri fariseos y ri saduceos xebꞌopon rukꞌ ri Jesús re kakikꞌam upa. Xkitzꞌonoj kꞌu che kuꞌan juna kꞌutubꞌal re chilaꞌ chikaj chikiwach chaꞌ jelaꞌ kaqꞌalajinik we Rire taqom lo ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ekꞌu ri Jesús xukꞌul uwach: «Echiriꞌ keꞌek la qꞌij, ralaq kabꞌiꞌij alaq: “Lik utz ri qatiempo ma kaq ruwa kaj.” ");
INSERT INTO acrNNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Echiriꞌ anim tan, kabꞌiꞌij alaq: “Waqꞌij lik na utz ta ri qatiempo. ma kaq ruwa kaj y qꞌeqmuj.” ¡Ralaq xa kebꞌ palaj alaq! Ma kariq alaq uchꞌobꞌik chi utz saꞌ ruꞌanom ruwa kaj, yey na kamaj tane alaq usukꞌ saꞌ taq ri katajin ri Dios che ukꞌutik chiwach alaq waqꞌij ora. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ri kakitzꞌonoj kꞌutubꞌal re ruchuqꞌabꞌ ri Dios e ri winaq re waqꞌij ora, ri itzel kikꞌuꞌx y na jusukꞌ ta ri kanimaꞌ chwach ri Dios. Pero na kayaꞌtaj ta kꞌu waꞌ chike, ma xew kayaꞌiꞌ chikiwach ri kꞌutubꞌal xꞌaniꞌ ojertan rukꞌ ri qꞌalajisanel Jonás» xchaꞌ. Ekꞌuchiriꞌ, xebꞌuya kanoq y xeꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Echiriꞌ xebꞌopon rutijoꞌn chꞌaqa mar, xkꞌun chikikꞌuꞌx na xkikꞌam tubꞌi pam. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Xubꞌiꞌij kꞌu ri Jesús chike: —Chitapeꞌ: Lik chichajij iwibꞌ chwa ri levadura ke ri fariseos y ri saduceos —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Rutijoꞌn xa chikiwach xkibꞌiꞌij: «Rire kubꞌiꞌij waꞌ, ma na xqakꞌam ta lo pam» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ri Jesús xretaꞌmaj saꞌ ri kakichꞌaꞌtibꞌej chikiwach, xubꞌiꞌij kꞌu chike: —¡E riꞌix na nim ta kꞌana ri kubꞌulibꞌal ikꞌuꞌx wukꞌ! ¿Suꞌchak e kubꞌisoj ikꞌuꞌx ri na jinta pam iwukꞌaꞌam loq? ");
INSERT INTO acrNNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Kꞌamajaꞌ nebꞌa kimaj usukꞌ? ¿Na kakꞌun ta nebꞌa chikꞌuꞌx echiriꞌ xebꞌenutzuq ri woꞌobꞌ mil chi achijabꞌ rukꞌ woꞌobꞌ pam y janipa lo chakach xinojisaj rukꞌ ri kiqax? ");
INSERT INTO acrNNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Yey na kakꞌun ta nebꞌa chikꞌuꞌx echiriꞌ xebꞌenutzuq kajibꞌ mil chi achijabꞌ rukꞌ wuqubꞌ pam y janipa lo chakach xinojisaj rukꞌ ri kiqax? ");
INSERT INTO acrNNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chaꞌtaj na ximaj ta usukꞌ na e ta chwi ri pam xinchꞌaꞌt wi echiriꞌ ximbꞌiꞌij: “Chichajij iwibꞌ che ri levadura ke ri fariseos y ri saduceos”? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Kꞌa ekꞌuchiriꞌ xkimaj usukꞌ na chwi ta ri levadura re ri pam xchꞌaꞌt wi ri Jesús, ma e chwi ri kikꞌutunik ri fariseos y ri saduceos. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Kꞌo jun qꞌij xebꞌopon ri Jesús che taq ri luwar re ri tinamit Cesarea re Filipo, y xutzꞌonoj kꞌu chike rutijoꞌn: —Chikiwa ri winaq, ¿china nawi Ralaxel Chikixoꞌl Tikawex? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Rutijoꞌn xkibꞌiꞌij che: —Kꞌo kebꞌiꞌn re e Juan Aj Yaꞌl Bautismo; jujun chik kakibꞌiꞌij e Elías; y jujun chik, e Jeremías o junoq chik chike ri qꞌalajisanelabꞌ re ojertan —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ekꞌuchiriꞌ, xubꞌiꞌij chike rutijoꞌn: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ekꞌu ri Simón Pedro xubꞌiꞌij che: —Rilal lal ri Cristo, lal Rukꞌajol ri Dios kꞌaslik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ri Jesús xukꞌul uwach: —Lik nim aqꞌij awalaxik riꞌat Simón at ukꞌajol ri Jonás; ma na e ta juna tikawex xqꞌalajisan waꞌ chawe, e ri Nuqaw kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Riꞌin kambꞌiꞌij kꞌu chawe: Riꞌat at Pedro. Y chwi kꞌu waꞌ waꞌbꞌaj kantik wubꞌi ri nu iglesia, yey ruchuqꞌabꞌ ri kamik na kuchꞌij tane kꞌana usachik uwach ri nu iglesia. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Y riꞌin kanya paqꞌabꞌ riꞌat ri lawe re rutaqanik ri Dios petinaq chilaꞌ chikaj. Ekꞌu janipa ri kaxim wara che ruwachulew, kaximitaj chilaꞌ chikaj; yey janipa ri kakir wara che ruwachulew, kakiritaj chilaꞌ chikaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ekꞌu ri Jesús xebꞌutaq rutijoꞌn che chaꞌ na kakitzijoj ta kꞌana che junoq we Rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Chwi kꞌu riꞌ, ri Jesús xujeq uqꞌalajisaxik chike rutijoꞌn janipa ri kukꞌulumaj: E lik chirajawaxik che keꞌek Jerusalem, kayaꞌiꞌ na kꞌu pa kꞌax kuma taq ri nimaq winaq re Israel, ri nimaq e aj chakunel pa Rocho Dios y raj kꞌutunel re ri tzijpixabꞌ, yey kakamisaxik; noꞌj churox qꞌij kakꞌastaj loq. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ekꞌu ri Pedro xresaj bꞌi ri Jesús chikixoꞌl y xuchꞌaꞌbꞌej upa, jewaꞌ xubꞌiꞌij che: —¡Wajawal, lik ne muya luwar riꞌ ri Dios e kakꞌulumaj la waꞌ! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ekꞌu ri Jesús xutzuꞌ lo uwach ri Pedro y xubꞌiꞌij che: —¡Chatel chinuwach, Satanás! Riꞌat at latzꞌanel chwe, ma na e ta kachꞌobꞌ puwi ri uchꞌobꞌom lo ri Dios, xew e kachꞌobꞌ jelaꞌ pachaꞌ ri kakichꞌobꞌ ri winaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús chike rutijoꞌn: —We kꞌo junoq karaj katerej lo chwij, lik chirajawaxik che muꞌan xew ri karaj rire, e chukuyu ri kꞌax kape puwiꞌ ruma ukojom ri nubꞌiꞌ, y tereja lo chwij. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Ma china ri na kuya ta ranimaꞌ rukꞌaslem, riꞌ e kujam ri chomilaj kꞌaslemal chwach ri Dios; noꞌj ri kuya ranimaꞌ rukꞌaslem wuma riꞌin, riꞌ e kuriq ri chomilaj ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ma ¿saꞌ kꞌu kutiqoj riꞌ che ri tikawex we kuꞌan rajaw ronoje ruwachulew yey kusach kꞌu uwach rukꞌaslemal? ¿O kꞌo nawi rajil kutoj rachi chwa rukꞌaslemal chaꞌ jelaꞌ na kujam taj? ¡Na jintaj! ");
INSERT INTO acrNNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","»Ma Ralaxel Chikixoꞌl Tikawex kakꞌun rukꞌ runimal yakbꞌal uqꞌij Ruqaw y kukꞌ taq ru ángeles. Ekꞌuchiriꞌ kuya chike chikijujunal ri tikawex, ri rajil ukꞌaxel e chirij taq ri kiꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Paqatzij wi kambꞌiꞌij chiwe: E kꞌo jujun chike wa e kꞌo wara na kekam tana we na xkil tubꞌi Ralaxel Chikixoꞌl Tikawex kakꞌun che rutaqanik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Waqibꞌ qꞌij kꞌu ubꞌiꞌxikil riꞌ waꞌ echiriꞌ ri Jesús xebꞌuchaꞌ ri Pedro, ri Jacobo y ri Juan ruchaqꞌ ri Jacobo; y xebꞌukꞌam bꞌi chwa jun nimalaj juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Chilaꞌ kꞌut xjalkꞌatitaj uwach ri Jesús chikiwach. Rupalaj lik xwonik jelaꞌ pachaꞌ ruwonibꞌal ri qꞌij; yey ruqꞌuꞌ xujeq kawolqꞌinik jelaꞌ pachaꞌ ri qꞌijsaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xaqikꞌateꞌt kꞌut chikiwach xewinaqir ri Moisés y ri Elías, qꞌalajisanelabꞌ re ojertan; e riꞌ kechꞌaꞌt rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ekꞌu ri Pedro xubꞌiꞌij che ri Jesús: —Qajawal, lik utz xyaꞌtaj chiqe riꞌoj oj kꞌo wara. We kaꞌaj la, kaqaꞌan oxibꞌ rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Kꞌa kachꞌaꞌt ne ri Pedro echiriꞌ jun sutzꞌ lik kawonik xuchꞌuq kiwiꞌ. Y chupa kꞌu ri sutzꞌ xkita ruqul ri Dios, jewaꞌ xubꞌiꞌij: «E Nukꞌajol waꞌ ri lik kꞌax kannaꞌo y lik kinkiꞌkot che. E chita utzij Rire» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Echiriꞌ rutijoꞌn xkita waꞌ, xexukiꞌik, xkiqasaj kimejelem kꞌa chuꞌlew y xok jun nimalaj xiꞌin ibꞌ kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ekꞌuchiriꞌ, xqibꞌ ri Jesús kukꞌ, xebꞌuchapo y xubꞌiꞌij chike: —Chixyaktajoq, mixiꞌij iwibꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Echiriꞌ xetzuꞌn apanoq, na jinta junoq chik xkilo, xew ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ekꞌuchiriꞌ xeqaj lo chwa ri juyubꞌ, ri Jesús xebꞌutaq che: —Mitzijoj kꞌana che junoq janipa ri xkꞌut chiwach, kꞌate kitzijoj echiriꞌ Ralaxel Chikixoꞌl Tikawex kꞌastajinaq chi lo chikixoꞌl ri ekaminaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ekꞌuchiriꞌ, rutijoꞌn xkitzꞌonoj che: —¿Suꞌbꞌe kꞌut kakibꞌiꞌij raj kꞌutunel re ri tzijpixabꞌ: “Lik chirajawaxik wi kakꞌun na ri Elías nabꞌe”? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ri Jesús xukꞌul uwach: —Qatzij, ri Elías nabꞌe kakꞌunik y kuyijbꞌaꞌ pan ronoje chwach rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Noꞌj kanqꞌalajisaj kꞌu waꞌ chiwe: Ri Elías ya xkꞌunik, yey ri winaq na xketaꞌmaj ta uwach. Xkiꞌan kꞌu riꞌ che janipa ri xkaj rike; jekꞌulaꞌ Ralaxel Chikixoꞌl Tikawex kutij na ri kꞌax pakiqꞌabꞌ rike —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Ekꞌu rutijoꞌn xketaꞌmaj e kachꞌaꞌt puwi ri Juan Aj Yaꞌl Bautismo. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Echiriꞌ xebꞌopon pa e kꞌo wi taq ri winaq, kꞌo jun achi xqibꞌ rukꞌ ri Jesús, xuxuk ribꞌ chwach y xubꞌiꞌij che: ");
INSERT INTO acrNNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Wajawal, kꞌutu ko ri kꞌaxnaꞌbꞌal kꞌuꞌx la che ri nukꞌajol, ma rire xa kumaj tew y lik kutij kꞌax ruma waꞌ; ukꞌiyal laj tzaqinaq pa aqꞌ y pa yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Xinkꞌam lo kukꞌ wa tijoꞌn la, pero rike na kichꞌijom ta ukunaxik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ekꞌu ri Jesús xukꞌul uwach: —¡E ri ix tikawex re waqꞌij ora na kubꞌul ta ikꞌuꞌx wukꞌ yey ix sachinaq! ¿Janipa chi lo qꞌij kajawaxik kinkꞌojiꞌ iwukꞌ chaꞌ kakubꞌiꞌ ikꞌuꞌx wukꞌ? ¿Janipa chi lo qꞌij kixinkuyu e laꞌ jelaꞌ iꞌanom? Chikꞌama lo rala wara —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ekꞌuchiriꞌ, ri Jesús xutaq ri itzel uxlabꞌixel chaꞌ kel bꞌi che rala. Y chwi kꞌu riꞌ asu xkunutaj rala. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Tekꞌuchiriꞌ, rutijoꞌn ri Jesús xeqibꞌ rukꞌ re kechꞌaꞌt rukꞌ kitukel y xkitzꞌonoj kꞌu che: —¿Suꞌbꞌe riꞌoj na xqachꞌij ta resaxik bꞌi waꞌ wa itzel uxlabꞌixel? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ri Jesús xubꞌiꞌij chike: —E ruma na nim ta ri kubꞌulibꞌal ikꞌuꞌx rukꞌ ri Dios. We ta ri kubꞌulibꞌal ikꞌuꞌx kakꞌiyik jelaꞌ pachaꞌ ri kakꞌiy rijaꞌ re moxtasa, utz ne riꞌ kibꞌiꞌij che wa juyubꞌ: “Chatela bꞌi wara y chatqꞌax pan jelaꞌ”, y e kuꞌanaꞌ. Riꞌ na jinta kꞌayew chiwach riꞌix we ta lik kꞌo kubꞌulibꞌal ikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Noꞌj waꞌ wa juchꞌobꞌ itzel uxlabꞌixel xew utz kebꞌesax bꞌi rukꞌ oración y ayuno —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Ekꞌuchiriꞌ e kꞌo pa taq ri luwar re Galilea, ri Jesús xubꞌiꞌij chike rutijoꞌn: «Ralaxel Chikixoꞌl Tikawex kayaꞌiꞌ pakiqꞌabꞌ rachijabꞌ ");
INSERT INTO acrNNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","y kakamisax kuma; noꞌj churox qꞌij kakꞌastaj loq» xchaꞌ. Echiriꞌ xkita waꞌ rutijoꞌn, lik xkibꞌisoj. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Echiriꞌ ri Jesús kukꞌ rutijoꞌn xebꞌopon pa ri tinamit Capernaúm, raj tzꞌonol puaq re ri tojonik xeꞌkila ri Pedro y xkitzꞌonoj che: —¿Ri tijonel iweꞌix na kutoj ta kami riꞌ ri tojonik kaꞌanik re ri Rocho Dios? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ekꞌu ri Pedro xubꞌiꞌij: —Rire kutojo —xchaꞌ. Ekꞌuchiriꞌ xok ri Pedro pa ri ja, ri Jesús nabꞌe na xchꞌaw che, jewaꞌ xubꞌiꞌij: —Chawach riꞌat, ¿e juna rey che ruwachulew, china chike kutzꞌonoj wi taq ri tojonik kaꞌanik? ¿Chike ri e ralkꞌoꞌal o chike ri na e ta ralkꞌoꞌal? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Xubꞌiꞌij kꞌu ri Pedro: —Chike ri na e ta ralkꞌoꞌal —xchaꞌ. Tekꞌuchiriꞌ, xubꞌiꞌij ri Jesús che: —Ekꞌu ri e ralkꞌoꞌal na jinta kꞌo katzꞌonox chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Noꞌj chaꞌ na kaqapetisaj ta kꞌu royowal junoq, jat chuchiꞌ ri mar y chakꞌaqa ri anzuelo chupa. Ekꞌu ri nabꞌe kar kachapo, chajaqa rupuchiꞌ y kariq jun meyo chupa. Rukꞌ kꞌu riꞌ, chayaꞌa ri tojonik kanꞌan riꞌin y ri tojonik kaꞌan riꞌat —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Chupa kꞌu laꞌ la qꞌij, rutijoꞌn ri Jesús xeqibꞌ rukꞌ y xkitzꞌonoj che: —¿China ri más kꞌo uwach chupa rutaqanik ri Dios petinaq chilaꞌ chikaj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ekꞌuchiriꞌ, ri Jesús xusikꞌij jun ralko kꞌoꞌm y xuya chikinikꞌajal rike. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Xubꞌiꞌij kꞌu chike: —Paqatzij wi kambꞌiꞌij chiwe: We na kijalkꞌatij ta ribꞌinik isilabꞌik chaꞌ kixuꞌan pachaꞌ raltaq ko akꞌalabꞌ, na kixok ta riꞌ chupa rutaqanik ri Dios petinaq chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Jekꞌulaꞌ, china ri kuꞌan chꞌutiꞌn che ribꞌ pachaꞌ wa ralko kꞌoꞌm, e lik kꞌo uwach riꞌ pa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Yey china ri kukꞌul chupa ri nubꞌiꞌ junoq na jinta uwach pachaꞌ wa ralko kꞌoꞌm, e junam rukꞌ e in ri kinukꞌulu. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","»China ri kaminow pa mak junoq chike wa chꞌutiꞌq kubꞌul kikꞌuꞌx wukꞌ, e ne más utz katzayabꞌax bꞌi puqul juna nimalaj kaꞌ re keꞌem y kakꞌaq kꞌu bꞌi pa ri mar chaꞌ kamuqutaj kꞌa chuxeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Toqꞌoꞌ kiwach ri tikawex ma lik kꞌo ri katzaqisan ke chupa ri na utz taj! Ma che ruwachulew lik kꞌo taq waꞌ. Pero ¡lik toqꞌoꞌ kꞌu uwach ri jun kumin junoq chik pa mak, ma e kape ri qꞌatbꞌal tzij re ri Dios puwiꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","»E uwariꞌche, we raqꞌabꞌ o rawaqan e katzaqisan awe pa mak, chaqꞌata bꞌi y chawesaj bꞌi chawe. Ma xa ne kuya tobꞌ at tꞌum o at jetzꞌ katopon pa ri kꞌaslemal chilaꞌ chikaj, chwa ri kꞌo ukabꞌichal raqꞌabꞌ y ukabꞌichal rawaqan yey katkꞌaq bꞌi chi xibꞌalbꞌaꞌ pa kꞌo wi ri aqꞌ na jinta chi uchupik. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Yey we rawach e katzaqisan awe pa mak, chawesaj bꞌi y chakꞌaqa bꞌi. Ma xa ne kuya tobꞌ xa jun rawach katopon pa ri kꞌaslemal chilaꞌ chikaj, chwa ri kꞌo ukabꞌichal rawach yey katkꞌaq bꞌi pa aqꞌ chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","»Mikꞌaq bꞌi uqꞌij junoq chike wa e chꞌutiꞌq kubꞌul kikꞌuꞌx wukꞌ. Ma kambꞌiꞌij kꞌu chiwe, ri ángeles e chajal ke rike xaqi e kꞌo chwach ri Nuqaw Dios chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Ma Ralaxel Chikixoꞌl Tikawex xkꞌunik re kebꞌukolobꞌej ri e sachinaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Saꞌ kichꞌobꞌ riꞌix kuꞌan juna achi we kꞌo jun ciento ubꞌexex yey kasach kꞌu junoq chike? ¿Na kebꞌukꞌol ta nebꞌa kan riꞌ ri noventa y nueve y keꞌek chwa ri juyubꞌ che utzukuxik ri jun xsach kanoq? ");
INSERT INTO acrNNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","We xuriq kꞌut, paqatzij wi kambꞌiꞌij chiwe: E más kakiꞌkot ruma ri jun bꞌexex chikiwa ri noventa y nueve na e ta sachinaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Jekꞌuriꞌlaꞌ, ri Nuqaw kꞌo chilaꞌ chikaj na karaj taj kasach junoq chike ri chꞌutiꞌq kubꞌul kikꞌuꞌx wukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","»E uwariꞌche, we rawatz-achaqꞌ kuꞌan ri na utz taj chawe, chatchꞌaꞌt rukꞌ e laꞌ itukel; chabꞌiꞌij che saꞌ ri na utz taj uꞌanom chawe. We xatuta kꞌut, riꞌ xakoj chi utzil chomal rawatz-achaqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Noꞌj we na xatuta taj, jat tanchi rukꞌ; chakꞌama kꞌu bꞌi jun o kaꞌibꞌ awachbꞌiꞌil awukꞌ chaꞌ jelaꞌ e kebꞌ oxibꞌ che utayik saꞌ ri kabꞌiꞌxik. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We na xebꞌuta ta kꞌu wa kebꞌ oxibꞌ, ekꞌuchiriꞌ chatzijoj chikiwach rutinamit ri Dios. Yey we na xok ta kꞌu il chike waꞌ, chiꞌana kꞌu riꞌ che pachaꞌ e kukꞌil ri na ketaꞌam ta uwach ri Dios y e kukꞌil raj tzꞌonol puaq re tojonik. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Paqatzij wi kambꞌiꞌij chiwe: Janipa ri kixim riꞌix wara che ruwachulew, kaximitaj chilaꞌ chikaj. Janipa ri kikir riꞌix wara che ruwachulew, kakiritaj chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Kambꞌiꞌij kꞌu chiwe: We e kꞌo kaꞌibꞌoq chiwe wara che ruwachulew kuꞌan junam kikꞌuꞌx chwi ri kakitzꞌonoj pa oración, ri Nuqaw kꞌo chilaꞌ chikaj kuya na chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ma pa kimolom wi kibꞌ kebꞌ oxibꞌ pa ri nubꞌiꞌ, chiriꞌ in kꞌo wi riꞌin chikinikꞌajal rike —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ekꞌuchiriꞌ, ri Pedro xqibꞌ rukꞌ ri Jesús y xutzꞌonoj che: —Wajawal, ¿janipa laj kankuy umak juna watz-nuchaqꞌ we xuꞌan ri na utz taj chwe? ¿Kꞌa pa wuqubꞌ laj nawi? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Ri Jesús xukꞌul uwach: —Na kambꞌiꞌij ta chawe xa pa wuqubꞌ laj, ma kꞌa wuqubꞌ laj chi setenta. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","»Ma ri kuꞌan chupa rutaqanik ri Dios petinaq chilaꞌ chikaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ juna taqanel xraj karilo we na jinta kikꞌas ri raj chakibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ekꞌu riꞌ xujeq rajilaxik, xriqitaj lo jun aj chak lik ukꞌiyal rukꞌas rukꞌ y xkꞌam lo chwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ekꞌu wa aj chak ruma na kuchꞌij ta chi utojik rukꞌas, xtaqan rupatrón che chaꞌ kakꞌayix bꞌi rire, junam rukꞌ ri rixoqil, ri ralkꞌoꞌal y rukꞌ ronoje rubꞌitaq re chaꞌ jelaꞌ katojtaj rukꞌas. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Pero wa aj chak xuxukubꞌaꞌ ribꞌ chwach rupatrón y lik kꞌu xutzꞌonoj che: “Lal wajaw, lik chinoyꞌej ko kꞌana la ma kantoj ronoje ri nukꞌas cheꞌla” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ekꞌu rupatrón lik xjuchꞌ kaꞌn ukꞌuꞌx che ri raj chak. Xukuy kꞌu umak che ronoje rukꞌas y xuya bꞌi luwar che xeꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","»Noꞌj kꞌu wa aj chak xew xel bꞌi, xuꞌkꞌulu lo jun rach aj chak yey waꞌ kꞌo jubꞌiqꞌ ukꞌas rukꞌ. Xuchapij kꞌu puqul e riꞌ pachaꞌ kujitzꞌaj, jewaꞌ xubꞌiꞌij che: “¡Chatojolaꞌ rakꞌas wukꞌ!” xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","»Ekꞌu ri rach aj chak xuxukubꞌaꞌ ribꞌ chwach y lik xutzꞌonoj che: “Chakuyu ko numak, chinawoyꞌej na kꞌenoq ma kantoj ronoje ri nukꞌas chawe” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","»Noꞌj rire na xraj taj xroyeꞌej waꞌ. Ri xuꞌano e xuꞌyaꞌa ri jun chik rach aj chak pa cárcel; yey kꞌa ekꞌu kesax loq we xutoj na rukꞌas. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","»Echiriꞌ xkil taq waꞌ ri kach aj chakibꞌ, lik xok chikikꞌuꞌx. Xebꞌek kꞌut, xeꞌkibꞌiꞌij che ri kipatrón ronoje ri xuꞌan ri jun aj chak. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ekꞌuchiriꞌ, rupatrón xutaq ukꞌamik y xubꞌiꞌij che: “¡At jun aj chak itzel akꞌuꞌx! Riꞌin xinkuy amak riꞌat che ronoje rakꞌas, ma lik e xatzꞌonoj riꞌ chwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ta ne e xaꞌan riꞌat jelaꞌ pachaꞌ ri xinꞌan riꞌin chawe, ta e xakꞌut ri kꞌaxnaꞌbꞌal akꞌuꞌx che rawach aj chak; noꞌj na e ta kꞌu ri xaꞌano” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","»Ekꞌu rupatrón lik xpe royowal y xtaqan che kayaꞌiꞌ pa kꞌax y kꞌa e kesax lo chupa waꞌ we xutoj na ronoje rukꞌas. ");
INSERT INTO acrNNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","»Jekꞌulaꞌ kuꞌan ri Nuqaw kꞌo chilaꞌ chikaj iwukꞌ riꞌix we kꞌo junoq chiwe na kukuy ta umak ri ratz-uchaqꞌ rukꞌ ronoje ranimaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Echiriꞌ xukꞌis ubꞌiꞌxik waꞌ ri Jesús, xel bꞌi Galilea y xeꞌek pa taq ri luwar re Judea y xopon pa taq ri luwar kꞌo chꞌaqa yaꞌ che ri nimayaꞌ Jordán. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Lik kꞌut e kꞌi ri winaq xeterej bꞌi chirij y xebꞌukunaj ri yewaꞌibꞌ chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E kꞌo kꞌu jujun chike ri fariseos xeqibꞌ rukꞌ ri Jesús xa re kakikꞌam upa y xkitzꞌonoj che: —¿Ubꞌe nawi che juna achi, xa tobꞌ saꞌ ri kujal wi uchiꞌ ri rixoqil, kuya bꞌi ruwujil re jachbꞌal ibꞌ che? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ri Jesús xukꞌul uwach: —¿Na ajilam ta nebꞌa alaq saꞌ ri tzꞌibꞌital kan pa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ kubꞌiꞌij: Che ri jeqebꞌal lo ruwachulew echiriꞌ ri Dios xebꞌuꞌan ri tikawex, chi achi chi ixoq xebꞌuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Y kubꞌiꞌij: Ruma kꞌu riꞌ, rachi echiriꞌ kakꞌuliꞌik, karesaj ribꞌ chikij ruchu-uqaw chaꞌ kajeqiꞌ rukꞌ ri rixoqil y kikabꞌichal kꞌu riꞌ kebꞌuꞌana xa e jun chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Jekꞌuriꞌlaꞌ na e ta chi kaꞌibꞌ, ma xebꞌuꞌana xa e jun. E uwariꞌche, ri xebꞌujunimaj ri Dios, na yaꞌtal ta che ri tikawex kujach upa —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ekꞌuchiriꞌ, xkitzꞌonoj che: —¿Suꞌchak kꞌu riꞌ ri Moisés xubꞌiꞌij we juna achi karaj kujach bꞌi ri rixoqil, xew chuyaꞌa bꞌi ruwujil re jachbꞌal ibꞌ che y jekꞌulaꞌ na rixoqil ta chik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ri Jesús xubꞌiꞌij chike: —Waꞌ e ruma lik ko ri animaꞌ alaq. Ruma laꞌ ri Moisés xuya luwar kayaꞌiꞌ ruwujil re jachbꞌal ibꞌ; noꞌj che lo ri jeqebꞌal ruwachulew na je ta laꞌ ri xraj ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Kambꞌiꞌij kꞌu riꞌin che alaq: China junoq kuya ruwujil re jachbꞌal ibꞌ che ri rixoqil tobꞌ ri rixoqil na makuninaq ta chirij ri kꞌulanikil, yey kakꞌuliꞌ tanchi rukꞌ juna chik ixoq, riꞌ kamakun chirij ri kꞌulanikil. Y china ri kakꞌuliꞌ rukꞌ rixoq jachom kanoq, riꞌ jenelaꞌ kamakun chirij ri kꞌulanikil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ekꞌu rutijoꞌn xkibꞌiꞌij che: —We jelaꞌ kukꞌulumaj rachi rukꞌ ri kꞌulanikil, más ne utz riꞌ we junoq na kakꞌuliꞌ taj —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ri Jesús xubꞌiꞌij chike: —Na konoje ta kꞌu ri tikawex kakichꞌij waꞌ; ma xew ri yaꞌtal lo chike ruma ri Dios, kakichꞌij uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","E kꞌo achijabꞌ na kekꞌuliꞌ taj ma kalaxibꞌem pachaꞌ e eunucos. E kꞌo jujun chik na kekꞌuliꞌ taj ma ꞌanom eunucos chike. Yey e kꞌo ri na kekꞌuliꞌ taj ma kiyaꞌom kibꞌ che ri chak re rutaqanik ri Dios petinaq chilaꞌ chikaj. China ri kachꞌijow uꞌanik waꞌ, chuchꞌija kꞌu riꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","E kꞌo jujun raltaq ko akꞌalabꞌ xekꞌam lo chwach ri Jesús chaꞌ kuya ruqꞌabꞌ pakiwiꞌ y jelaꞌ kutzꞌonoj che ri Dios kebꞌuchajij. Yey rutijoꞌn xekiyaj ri ekꞌamayom lo ke. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Noꞌj ri Jesús xubꞌiꞌij chike: «Chiyaꞌa luwar chike ri raltaq ko akꞌalabꞌ chepeta na wukꞌ. Mebꞌiqꞌatej; ma ri kakiꞌan e jelaꞌ pachaꞌ rike, riꞌ kuꞌan ke rutaqanik ri Dios petinaq chilaꞌ chikaj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Xuya kꞌu ruqꞌabꞌ pakiwi ri raltaq ko akꞌalabꞌ. Tekꞌuchiriꞌ, xel bꞌi pa ri luwar. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Kꞌo kꞌu jun kꞌakꞌal achi xkꞌun rukꞌ ri Jesús y xutzꞌonoj che: —Lal utzilaj tijonel, ¿saꞌ ri utz kanꞌano chaꞌ kꞌo nukꞌaslemal na jinta utaqexik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Ri Jesús xukꞌul uwach: —¿Suꞌbꞌe kabꞌiꞌij la “utz” chwe? Ma xa jun ri lik utz kꞌolik, waꞌ e ri Dios. Yey we kaꞌaj la kok la pa ri kꞌaslemal na jinta utaqexik rukꞌ Rire, e taqej la Rutzij Upixabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Rachi xubꞌiꞌij che ri Jesús: —¿Pachike kꞌu riꞌ ri tzijpixabꞌ? —xchaꞌ. Ri Jesús xubꞌiꞌij che: —“Matkamisanik. Matmakun chirij ri kꞌulanikil. Mateleqꞌik. Maꞌan raqꞌubꞌal chirij junoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Chaloqꞌoj kiqꞌij rachu-aqaw” y “Kꞌax chanaꞌa rawatz-achaqꞌ jelaꞌ pachaꞌ kꞌax kanaꞌ awibꞌ riꞌat” —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Rachi xubꞌiꞌij che ri Jesús: —Ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal. ¿Saꞌ kꞌu riꞌ ri kꞌa chirajawaxik chwe kanꞌano? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ri Jesús xubꞌiꞌij che: —We kaꞌaj la e kaꞌan la janipa ri karaj ri Dios che ri bꞌinik silabꞌik la, kꞌayij la ronoje taq ri bꞌeyomalil la y jacha kꞌu la chike ri nibꞌaꞌibꞌ; jekꞌuriꞌlaꞌ kꞌo bꞌeyomalil la chilaꞌ chikaj. Tekꞌuchiriꞌ, peta la, terej lo la chwij y kuyu la ri kꞌax kape pawiꞌ la ruma lal nutijoꞌn —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Rachi echiriꞌ xuta waꞌ, lik kabꞌisonik xeꞌek ma rire lik rajawal bꞌeyom. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús chike rutijoꞌn: —Paqatzij wi kambꞌiꞌij chiwe: Juna bꞌeyom lik kꞌayew che kok chupa rutaqanik ri Dios petinaq chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Kambꞌiꞌij tanchi kꞌu chiwe: E ne más kꞌayew ri kok juna bꞌeyom chupa rutaqanik ri Dios chwa ri kikꞌow juna camello chupa rutel juna akuxaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Echiriꞌ xkita waꞌ rutijoꞌn, lik xkam kanimaꞌ che y xkitzꞌonoj chikiwach: —We e riꞌ, ¿china kꞌu riꞌ ri kakolobꞌetajik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ri Jesús xutzuꞌ kiwach y xubꞌiꞌij chike: —Ri tikawex na kakikolobꞌej ta kibꞌ kitukel ma waꞌ lik kꞌayew chikiwach; noꞌj ri Dios ronoje kuꞌano ma na jinta kꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ekꞌuchiriꞌ, xubꞌiꞌij ri Pedro che: —Qajawal, riꞌoj qayaꞌom kan ronoje y oj teran chiꞌij la. ¿Saꞌ kꞌu riꞌ ri kaqakꞌul riꞌoj? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij chiwe: Kopon kꞌu riꞌ ri qꞌij echiriꞌ ronoje kuꞌan kꞌakꞌ, waꞌ echiriꞌ Ralaxel Chikixoꞌl Tikawex keꞌtzꞌula chupa ri chomilaj tzꞌulibꞌal re rutaqanik. Jekꞌulaꞌ riꞌix kixeꞌtzꞌula chupa kabꞌlajuj tzꞌulibꞌal re kixtaqan pakiwi ri kabꞌlajuj tinamit re Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Yey china kꞌu ri uyaꞌom kan rocho, ebꞌuyaꞌom kan ri ratz-uchaqꞌ, ruchu-uqaw, ri rixoqil, ri ralkꞌoꞌal o ri rulew ruma ukojom ri nubꞌiꞌ, riꞌ kukꞌul na jun ciento chik chwa ronoje laꞌ yey kukꞌul kꞌu ri kꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","»Lik kꞌu e kꞌi chike ri lik kꞌo kiwach woꞌora, chwach apanoq na jinta chi kiwach; yey lik e kꞌi chike ri na jinta kiwach woꞌora, e lik kakꞌojiꞌ kiwach chwach apanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","»Ri kuꞌan chupa rutaqanik ri Dios petinaq chilaꞌ chikaj e jelaꞌ pachaꞌ ri xuꞌano echiriꞌ juna rajaw chak anim tan xel bꞌi che kitzukuxik aj chakibꞌ kebꞌajawax chupa rutikoꞌn re uva. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xchꞌaꞌt kukꞌ raj chakibꞌ puwi ri kajil y xkanajik kuya jun denario re jun qꞌij chak chike. Tekꞌuchiriꞌ, xebꞌutaq bꞌi chupa rutikoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Laj che ri ubꞌelej ora anim, xel tanchi ubꞌi y xeburiq jujun chik kimolom kibꞌ pa kꞌayibꞌal na jinta kakiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","»Xubꞌiꞌij kꞌu chike: “Jix riꞌix, jixeꞌchakuna wukꞌ chupa ri nutikoꞌn re uva y tzꞌaqat kixintojo” xchaꞌ. Ekꞌu rike xebꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","»Pa tikꞌil qꞌij kꞌu riꞌ, ri rajaw ri chak xel tanchi ubꞌi che kitzuquxik más aj chak. Yey je tanchi laꞌ xuꞌan che ri urox ora bꞌenaq qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","»Laj che kꞌu ri uroꞌ ora bꞌenaq qꞌij, xel tanchi ubꞌi y xebꞌuꞌriqa lo jujun chik na jinta kakiꞌano. Xubꞌiꞌij kꞌu chike: “¿Suꞌchak riꞌix ix kꞌo wara y na jinta kꞌo xiꞌan wa jun qꞌij?” ");
INSERT INTO acrNNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","»Xkikꞌul kꞌu uwach rike: “E ruma na jinta junoq xojchokowik.” »Ekꞌuchiriꞌ, xubꞌiꞌij ri rajaw ri chak chike: “Jix, jixeꞌchakuna chupa ri nutikoꞌn re uva y tzꞌaqat kixintojo.” ");
INSERT INTO acrNNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","»Echiriꞌ xok raqꞌabꞌ, ri rajaw ri chak xubꞌiꞌij che ri caporal: “Chebꞌasikꞌij konoje raj chakibꞌ y chebꞌatojo bꞌi. E kebꞌatoj nabꞌe ri xebꞌok kꞌunaj, y kꞌisbꞌal kꞌu re, kebꞌatoj ri xebꞌok nabꞌe pa chak.” ");
INSERT INTO acrNNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","»Ekꞌuchiriꞌ, xekꞌun raj chak ri xebꞌok bꞌenaq qꞌij che ri uroꞌ ora. Y chikijujunal kꞌu riꞌ xkikꞌul jun denario. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Tekꞌuchiriꞌ, xekꞌun lo ri ebꞌokinaq nabꞌe pa chak. E chikiwa rike más kꞌi ri kajil kakikꞌulu. Noꞌj na je ta laꞌ xuꞌano, ma xkikꞌul chikijujunal jun denario, pachaꞌ ri xkikꞌul ri jujun chik. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","»Echiriꞌ xkikꞌul ri kajil re jun qꞌij, xkijeqo kechꞌaꞌt chirij ri rajaw ri tikoꞌn, ");
INSERT INTO acrNNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","jewaꞌ xkibꞌiꞌij che: “Waꞌ wa xebꞌok bꞌenaq qꞌij chik, xa jun ora xechakunik yey xetoj la junam qukꞌ riꞌoj, tobꞌ kꞌu riꞌ riꞌoj xqakuy lo rukꞌatanil ri qꞌij” xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","»Noꞌj ri rajaw chak xukꞌul uwach, jewaꞌ xubꞌiꞌij che jun chike: “Wamigo, mabꞌiꞌij we na usukꞌ ta ri xinꞌan chawe. ¿Na xojkanaj ta nebꞌa laꞌ katintoj jun denario? ");
INSERT INTO acrNNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chakꞌama kꞌu rawajil riꞌat y jat. Yey we riꞌin kuaj kanya che ri xok kꞌunaj pa chak, junam rukꞌ ri xinya chawe riꞌat, ");
INSERT INTO acrNNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿na jinta nebꞌa panuqꞌabꞌ riꞌin kanꞌan saꞌ ri kuaj rukꞌ ri nupuaq? ¿O kꞌax akꞌuꞌx chwij xa ruma xinkꞌut ri rutzil nukꞌuꞌx chike jujun chik?” xcha ri rajaw ri chak. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","»Jelaꞌ kꞌu riꞌ, lik e kꞌi chike ri na jinta kiwach woꞌora, e lik kakꞌojiꞌ kiwach chwach apanoq; yey lik kꞌu e kꞌi chike ri lik kꞌo kiwach woꞌora, chwach apanoq na jinta chi kiwach. Ma lik e kꞌi ri esikꞌim, tobꞌ kꞌu xa e jujun ri echaꞌtalik —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Echiriꞌ kꞌo chi ri Jesús chi bꞌe re keꞌek Jerusalem, xebꞌukꞌam bꞌi ri kabꞌlajuj utijoꞌn kitukel pa jun luwar y xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","«Chitapeꞌ: E waꞌ kojpaqiꞌ Jerusalem, yey ekꞌu Ralaxel Chikixoꞌl Tikawex kayaꞌ pakiqꞌabꞌ ri nimaq e aj chakunel pa Rocho Dios y raj kꞌutunel re ri tzijpixabꞌ chaꞌ kakiqꞌat tzij puwiꞌ re kamik. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Tekꞌuchiriꞌ, kakiya pakiqꞌabꞌ ri na e ta aj judiꞌabꞌ chaꞌ rike kakichꞌamij, kakijichꞌ upa y kakikamisaj chwa cruz. Noꞌj churox qꞌij kꞌut kakꞌastaj bꞌi chikixoꞌl ri ekaminaq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ekꞌuchiriꞌ, xqibꞌ rukꞌ ri Jesús ri kichu ri kebꞌ ukꞌajol ri Zebedeo, y ekꞌu laꞌ e rachbꞌiꞌil ri ralabꞌ; xuxukubꞌaꞌ ribꞌ chwach ri Jesús ma kꞌo karaj kutzꞌonoj che. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ri Jesús xutzꞌonoj che: —¿Saꞌ ri kaꞌaj la? —xchaꞌ. Rixoq xukꞌul uwach: —Wajawal, yaꞌa la chike wa kebꞌ walabꞌ ketzꞌuyiꞌ ukꞌ la pa ri taqanik la, jun pawikiqꞌabꞌ la y ri jun chik, pa mox la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ekꞌu ri Jesús xukꞌul uwach, y jewaꞌ xubꞌiꞌij chike ri kebꞌ utijoꞌn: —Riꞌix na iwetaꞌam taj saꞌ ri kitzꞌonoj. ¿Kichꞌij nebꞌa riꞌix ri kinikꞌow wi riꞌin y ri kꞌax kape panuwiꞌ? —xchaꞌ. Rike xkibꞌiꞌij: —Kaqachꞌijo —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ri Jesús xubꞌiꞌij chike: —Qatzij, riꞌix kichꞌij na ri kꞌax kinikꞌow wi riꞌin y ri kꞌaxkꞌobꞌik kape panuwiꞌ. Pero ri kixtzꞌuyiꞌ pa nuwikiqꞌabꞌ y pa numox, riꞌ na in ta kinyaꞌw re. Ma xew kayaꞌtaj chike ri echaꞌtal chi ruma ri Nuqaw chaꞌ kuꞌana na ke —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Echiriꞌ xkita waꞌ ri lajuj chik utijoꞌn, lik xpe koyowal chikij ri kebꞌ kichaqꞌ kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ekꞌu ri Jesús xebꞌusikꞌij y xubꞌiꞌij chike: —Iwetaꞌam riꞌix, ri ketaqan pakiwi ri nimaq tinamit kebꞌuꞌana pachaꞌ e rajaw ronoje; yey ri lik kꞌo kiwach kikꞌow uwiꞌ ri taqanik kakiꞌan pakiwi ri eyaꞌtal pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Noꞌj chixoꞌl riꞌix na ubꞌe taj jelaꞌ kuꞌano. Ma we kꞌo junoq chiwe riꞌix karaj kuꞌana aj wach, e chuyaꞌa ribꞌ kuꞌan nimanel iweꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Yey e junoq chiwe karaj kuꞌana nabꞌe chixoꞌlibꞌal, e chuyaꞌa ribꞌ kuꞌan nimanel ke konoje ");
INSERT INTO acrNNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","jelaꞌ pachaꞌ ri kuꞌan Ralaxel Chikixoꞌl Tikawex. Ma Rire na xkꞌun taj re kanimaxik; xkꞌunik re koꞌlnimanoq y re koluꞌyaꞌa ribꞌ pa kamik che kikolobꞌexik ukꞌiyal tikawex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Echiriꞌ ri Jesús kukꞌ rutijoꞌn katajin bꞌi kelik pa ri tinamit Jericó, lik ukꞌiyal winaq xeterej bꞌi chirij Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","E kꞌo kꞌu kaꞌibꞌ potzꞌ etzꞌul chuchiꞌ ri bꞌe. Echiriꞌ xkito katajin rikꞌowik ri Jesús, lik xesikꞌin pan che: —¡Qajawal, lal ri Ralkꞌoꞌal kan ri rey David, choj-juchꞌ kaꞌn ko cheꞌla! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ekꞌu ri winaq xekichꞌaꞌbꞌej kipa chaꞌ na kesikꞌin ta chik, noꞌj ri kaꞌibꞌ potzꞌ más ne ko xesikꞌinik, xkibꞌiꞌij: —¡Qajawal, lal ri Ralkꞌoꞌal kan ri rey David, choj-juchꞌ kaꞌn ko cheꞌla! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ekꞌuchiriꞌ, xtakꞌiꞌ ri Jesús, xebꞌusikꞌij y xutzꞌonoj chike: —¿Saꞌ ri kiwaj kanꞌan chiwe? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ri kaꞌibꞌ potzꞌ xkikꞌul uwach: —Qajawal, chojkunaj ko la chaꞌ kojtzuꞌnik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Ekꞌu ri Jesús xejuchꞌ kaꞌn pa ranimaꞌ y xuya ruqꞌabꞌ puwi ri kiwach. Na jampatana kꞌu riꞌ xetzuꞌnik y xeterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ri Jesús kukꞌ rutijoꞌn xa naqaj chik e kꞌo che ri tinamit Jerusalem, ya e riꞌ kebꞌok pa raldea Betfagé, ri kꞌo chwach ri juyubꞌ Olivos. Ekꞌuchiriꞌ, ri Jesús xebꞌutaq bꞌi kaꞌibꞌ chike rutijoꞌn chaꞌ kenabꞌej apanoq, ");
INSERT INTO acrNNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","jewaꞌ xubꞌiꞌij chike: «Jix pa raldea kꞌo pan chiqawach. Chiriꞌ kiꞌriqa jun axna yuqulik yey kꞌo ri ral rukꞌ. Chikira loq y chebꞌikꞌama lo chwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","We kꞌo kꞌu junoq kutzꞌonoj chiwe saꞌ ri kiꞌano, jewaꞌ chibꞌiꞌij che: “Rawaj kebꞌajawax che ri Qajawal, yey kꞌate kutaq tanchi uloq” kixchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","E xuꞌan waꞌ chaꞌ e kuꞌana rubꞌiꞌim kan ri qꞌalajisanel echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Chibꞌiꞌij chike ri e aj Sion: “Chiwilapeꞌ, ri Rey iweꞌix kakꞌun iwukꞌ, uꞌanom lo chꞌutiꞌn che ribꞌ; ukojom lo jun buru, waꞌ jun qꞌapoj buru, ral jun awaj aj eqaꞌn” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ekꞌuchiriꞌ, xebꞌek rutijoꞌn y xkiꞌano janipa ri xubꞌiꞌij bꞌi ri Jesús chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xkikꞌam kꞌu lo ri axna junam rukꞌ ri ral y xkirip ri kimanta chikij. Tekꞌuchiriꞌ, ri Jesús xukoj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ukꞌiyal winaq xkiwiq ri bꞌe pa kikꞌow wi ri Jesús, xkilikꞌ taq ri kimanta pa ri bꞌe; yey e kꞌo jujun chik xkiqꞌat raltaq ko uqꞌabꞌ cheꞌ y xkilem pa la bꞌe re yakbꞌal uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ekꞌu ri winaq e nabꞌe chwach kukꞌ ri eteran lo chirij xkijeqo lik kesikꞌinik, kakibꞌiꞌij: «¡Qayaka uqꞌij ri Ralkꞌoꞌal kan ri rey David! ¡Nim uqꞌij ralaxik ri jun petinaq chupa rubꞌiꞌ ri Dios Qajawxel! ¡Qayaka uqꞌij ri Dios kꞌo chilaꞌ chikaj!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Echiriꞌ xok ri Jesús Jerusalem, xetukuk konoje ri winaq re ri tinamit y lik e kꞌi ri kakitzꞌonobꞌej chikiwach: —¿China nawi wa jun achi? —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ekꞌu ri winaq kakibꞌiꞌij: —E ri qꞌalajisanel Jesús, ri aj Nazaret re Galilea —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Ekꞌuchiriꞌ, xok ri Jesús pa ri Rocho Dios y xebꞌeresaj bꞌi konoje ri kekꞌayinik y ri keloqꞌow chupa. Xukꞌaqalaꞌ taq bꞌi ri kimexa raj jachal uwach puaq y taq ri kixila raj kꞌay palomax. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xubꞌiꞌij kꞌu chike: «Ri Dios jewaꞌ kubꞌiꞌij chupa Ruchꞌaꞌtem: Che ri Wocho kabꞌiꞌxik: “E luwar re oración” kachaꞌ. Noꞌj ralaq ꞌanom alaq che ri Wocho e jun luwar ke eleqꞌomabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chiriꞌ kꞌu riꞌ chupa ri Rocho Dios, xeqibꞌ rukꞌ ri Jesús jujun potzꞌ kukꞌ jujun sik, y ri Jesús xebꞌukunaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ lik xpe koyowal echiriꞌ xkil wa milagros y xkito lik kesikꞌin rakꞌalabꞌ pa ri Rocho Dios, kakibꞌiꞌij: «¡Qayaka uqꞌij ri Ralkꞌoꞌal kan ri rey David!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Xkibꞌiꞌij kꞌu riꞌ che ri Jesús: —¿Kata la saꞌ ri kakibꞌiꞌij rakꞌalabꞌ cheꞌla? —xechaꞌ. Ekꞌu ri Jesús xukꞌul uwach: —Qatzij wi kanto. ¿Na ajilam ta nebꞌa alaq ri kubꞌiꞌij Ruchꞌaꞌtem ri Dios pakiwi rakꞌalabꞌ? Ma jewaꞌ kubꞌiꞌij: Chikichiꞌ rakꞌalabꞌ y ri ketzꞌumanik yijbꞌam la ri chomilaj bꞌix re yakbꞌal qꞌij la —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ekꞌuchiriꞌ, xebꞌuya kanoq y xel bꞌi pa ri tinamit; xeꞌek kꞌu Betania y chiriꞌ xkanaj kan wi la jun aqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Anim tan, echiriꞌ ri Jesús katzelej tanchi pa ri tinamit, xpe numik che. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xril kꞌu jun cheꞌ re higo kꞌo chuchiꞌ ri bꞌe. Xeꞌrilaꞌ kꞌut yey na xuriq ta tobꞌ xa juna uwach ri cheꞌ, xew ruxaq kꞌolik. Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús che ri cheꞌ: —¡Na jinta chi kꞌana ajiqꞌobꞌalil kayaꞌo! —xchaꞌ. Y na jampatana xchaqij ri cheꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Echiriꞌ xkil waꞌ rutijoꞌn, lik xkam kanimaꞌ che y xkitzꞌonoj kꞌu che: —¿Chaꞌtaj xchaqij tan wa cheꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij chiwe: We ta lik kꞌo kubꞌulibꞌal ikꞌuꞌx rukꞌ ri Dios y na kebꞌ ta kꞌana ipa rukꞌ, riꞌ na xew ta jewaꞌ kiꞌan riꞌix pachaꞌ wa xinꞌan riꞌin che ri higo. Ma utz ne riꞌ kibꞌiꞌij che wa juyubꞌ: “Chatela wara y jateꞌkꞌola chupa ri mar” kixchaꞌ y e kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Jekꞌulaꞌ riꞌ, e janipa ri kitzꞌonoj che ri Dios rukꞌ kubꞌulibꞌal ikꞌuꞌx, kikꞌul na —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Echiriꞌ xopon ri Jesús pa ri Rocho Dios, xujeq kakꞌutunik. Ekꞌu ri nimaq e aj chakunel re ri Rocho Dios kukꞌ ri nimaq winaq re ri tinamit xeqibꞌ rukꞌ y xkitzꞌonoj che: —¿China xyaꞌw paqꞌabꞌ la kaꞌan taq la waꞌ? ¿China xtaqaw la che kaꞌan taq la waꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ri Jesús xukꞌul uwach: —Riꞌin kanꞌan jun tzꞌonobꞌal che alaq. We xkꞌul alaq uwach chwe, kambꞌiꞌij kꞌu riꞌ che alaq china yaꞌyom panuqꞌabꞌ kanꞌan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","¿China kꞌu xtaqaw re ri Juan kuya ri bautismo? ¿E ri Dios o e rachijabꞌ? —xchaꞌ. Ekꞌu rike xkijeq kechꞌaꞌt chikiwach puwi waꞌ: «We xqakꞌul uwach che: “E ri Dios xtaqaw re”, riꞌ kubꞌiꞌij rire chiqe: “¿Suꞌchak kꞌu riꞌ na xkoj ta alaq ri xubꞌiꞌij?” kacha chiqe. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Yey kaqaxiꞌij qibꞌ kaqabꞌiꞌij: “Xa achijabꞌ xetaqaw re” ma konoje ri tinamit kakichꞌobꞌo ri Juan e jun qꞌalajisanel re ri Dios» xecha chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Xkibꞌiꞌij kꞌu che ri Jesús: —Na qetaꞌam taj —xechaꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike: «Jekꞌuriꞌlaꞌ, riꞌin na kambꞌiꞌij ta che alaq china yaꞌyom panuqꞌabꞌ kanꞌan taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","»Yey chiwach ralaq ¿saꞌ keꞌelawi waꞌ? Kꞌo jun achi e kꞌo kaꞌibꞌ ukꞌajol y xubꞌiꞌij che jun chike: “Nukꞌajol, jat waqꞌij pa chak, ma kanꞌan numolonik re uva.” ");
INSERT INTO acrNNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","»Rukꞌajol xukꞌul uwach: “Na kuaj taj” xchaꞌ. Pero kꞌate na xujalkꞌatij runaꞌoj y xeꞌek pa ruchak ruqaw. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Tekꞌuchiriꞌ, rachi xqibꞌ rukꞌ ri jun chik ukꞌajol y xubꞌiꞌij che pachaꞌ ri xubꞌiꞌij che ri ratzixel. »Ekꞌu rala xukꞌul uwach: “Utz riꞌ, tat, kinꞌek pa ri chak” xchaꞌ. Yey na xeꞌek ta kꞌu riꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Xutzꞌonoj kꞌu ri Jesús chike ri e aj wach: —Chiwach ralaq, ¿china nawi chike wa kaꞌibꞌ alabꞌo e xuꞌan ri karaj ri kiqaw? —xchaꞌ. Xkibꞌiꞌij kꞌu rike: —E ri nabꞌe —xechaꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike: «Paqatzij wi kambꞌiꞌij chiwe: E raj tzꞌonol puaq re tojonik y rixoqibꞌ na chom ta ri kibꞌinik kisilabꞌik, e rike ri nabꞌe nenareꞌ kebꞌok chupa rutaqanik ri Dios chiwach ralaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Ma ri Juan Aj Yaꞌl Bautismo xkꞌun chiwach ralaq, xoluꞌkꞌutuꞌ suꞌanik kajeqiꞌ alaq chi jusukꞌ che ruwachulew, yey ralaq na xkoj ta alaq. Noꞌj kꞌu raj tzꞌonol puaq re tojonik y rixoqibꞌ na chom ta ri kibꞌinik kisilabꞌik, rike xkikojo. Ekꞌu ralaq, tobꞌ xil alaq waꞌ, na xjalkꞌatij ta ri naꞌoj alaq chaꞌ kakoj alaq rutzij. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","»Tape alaq wa jun chik kꞌambꞌal naꞌoj: Kꞌo jun achi rajaw jun ulew. Ekꞌu rire xuꞌan tikoꞌn re uva chwach. Xusut rij rukꞌ coral, xukꞌot jun luwar pa kayitzꞌ wi ruwaꞌal ri uva y xuyak jun ja naj uwiꞌ re chajibꞌal re. Xuya kꞌu kan pa tunulik chike jujun aj chakibꞌ. Tekꞌuchiriꞌ, xeꞌek naj. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","»Echiriꞌ xopon ruqꞌijol ri molonik, xebꞌutaq lo jujun raj chakibꞌ chaꞌ kakitzꞌonoj chike raj tunulel ri taqalik kukꞌul rire che ri molonik. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Noꞌj raj tunulel xekichap raj chakibꞌ ebꞌutaqom loq. Lik xkiꞌan kꞌax che jun chike, xkikamisaj jun chik y kꞌo jun chik xkiꞌan paꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","»Ekꞌu ri rajaw xebꞌutaq tanchi lo más aj chakibꞌ, yey waꞌ más e kꞌi chwa ri xebꞌutaq lo nabꞌe. Ewi raj tunulel je tanchi laꞌ xkiꞌano pachaꞌ ri xkiꞌan chike ri e nabꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","»Kꞌisbꞌal kꞌu re, ri rajaw ri tikoꞌn e xutaq lo rukꞌajol kukꞌ raj tunulel, ma xuchꞌobꞌo: Kakikꞌul na chi utz wa nukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","»Noꞌj raj tunulel echiriꞌ xkil uwach rukꞌajol, jewaꞌ xkibꞌiꞌij chikiwach: “Waꞌ e ukꞌajol ri rajaw rulew, ri kuꞌana na rajaw we xkam ruqaw. Joꞌ jeꞌqakamisaj chaꞌ rulew kuꞌan kan qeꞌoj” xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","»Ewi xkichapo, xkesaj bꞌi chupa waꞌ wuꞌlew y xkikamisaj» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Tekꞌuchiriꞌ, xutzꞌonoj chike ri e aj wach: —Chiwach ralaq, echiriꞌ kakꞌun ri rajaw rulew, ¿saꞌ nawi kuꞌan chike raj tunulel? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Rike xkikꞌul uwach: —Na kukuy ta kꞌana kimak. Kusach na kꞌu kiwach ri itzel kiwachlibꞌal y kuya tanchi ri rulew pa tunulik chike jujun chik aj chakibꞌ, yey rike kakiya na ri molonik che chupa ruqꞌijol —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Tekꞌuchiriꞌ, xubꞌiꞌij ri Jesús chike: —¿Na ajilam ta nebꞌa ralaq ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ kubꞌiꞌij: E rabꞌaj kꞌaqital kan kuma raj yakal ja, e abꞌaj waꞌ lik xajawaxik chaꞌ katikiꞌ lo ri ja. Waꞌ e ri Dios Qajawxel xꞌanaw re y riꞌoj lik kakam qanimaꞌ che kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Ekꞌu uwariꞌche kambꞌiꞌij che alaq: Kamajataj na kꞌu che alaq rutaqanik ri Dios y kayaꞌtaj chike jujun chik tinamit chaꞌ kuya ri jiqꞌobꞌalil karaj ri Dios che rutaqanik. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","China kꞌu ri katzaq puwi laꞌ laꞌbꞌaj, lik kꞌax ri kukꞌulumaj; yey we rabꞌaj katzaq puwi junoq, riꞌ xa jumul kusach uwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Echiriꞌ ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri fariseos xkita taq ri kꞌambꞌal naꞌoj xutzijoj ri Jesús, xkimaj usukꞌ chikij rike xbꞌiꞌx wi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ruma kꞌu riꞌ waꞌ, lik xkaj kakichap ri Jesús; noꞌj e xkixiꞌij kibꞌ chike ri tinamit ma rike kakichꞌobꞌo ri Jesús e jun qꞌalajisanel re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Ri Jesús xujeq tanchik kakꞌutun rukꞌ taq kꞌambꞌal naꞌoj chikiwach, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","«Ri kuꞌana chupa rutaqanik ri Dios petinaq chilaꞌ chikaj e pachaꞌ ri xukꞌulumaj jun rey echiriꞌ xuꞌan jun nimalaj nimaqꞌij re rukꞌulanikil rukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","»Echiriꞌ xopon ri qꞌij re ri kꞌulanikil, ri rey xebꞌutaq bꞌi ri raj chakibꞌ kukꞌ ri esikꞌim pa ri kꞌulanikil chaꞌ keꞌkibꞌiꞌij chike kepetik, pero rike na xkaj taj xepetik. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","»Ewi xebꞌutaq tanchi ubꞌi jujun chik raj chakibꞌ, xubꞌiꞌij bꞌi chike: “Chibꞌiꞌij chike ri esikꞌim chik: Ri qajaw uyijbꞌam chi ronoje ri waꞌim; taq ri nawiloꞌibꞌ y taq ri meqꞌ etiꞌoꞌjirisam chik, ya xekamisaxik. Ronoje kꞌu riꞌ yijbꞌital chik. Peta kꞌu alaq riꞌ pa ri nimaqꞌij re kꞌulanikil” kixchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","»Noꞌj ri esikꞌim chik, na xebꞌok ta il che. Jun chike xeꞌrila ri rulew, jun chik xeꞌek pa kꞌayij. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yey jujun chik xekichap ri raj chakibꞌ ri rey, lik xkiꞌan kꞌax chike y jelaꞌ xekikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","»Ekꞌuchiriꞌ xuta waꞌ ri rey, lik xpe royowal che. Xebꞌutaq kꞌu bꞌi rusoldados re keꞌkisacha kiwach ri e kamisanel y keꞌkiporoj ri kitinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","»Tekꞌuchiriꞌ, xubꞌiꞌij chike ri raj chakibꞌ: “Ronoje yijbꞌital chi che ri kꞌulanikil; noꞌj kꞌu ri esikꞌim nabꞌe, na taqal ta chi chike kebꞌok pa ri nimaqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Jix kꞌu riꞌ woꞌora pa taq nimabꞌe y chebꞌisikꞌij lo pa ri kꞌulanikil janipa taq ri winaq kebꞌiriqo” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","»Xebꞌel kꞌu bꞌi ri raj chakibꞌ pa taq bꞌe y xekimol lo kichiꞌ konoje taq ri winaq xekiriqo xa tobꞌ e chinoq; jekꞌuriꞌlaꞌ ri luwar pa kaꞌan wi ri kꞌulanikil xnoj che winaq kꞌakꞌ esikꞌim. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Ekꞌuchiriꞌ, xok bꞌi ri rey y xeril ri esikꞌim chik. Xril kꞌu jun achi kꞌo chiriꞌ y na ukojom ta ruqꞌuꞌ re kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","»Xubꞌiꞌij kꞌu che: “Wamigo, ¿chaꞌtaj xatok lo wara we na akojom ta raqꞌuꞌ re kꞌulanikil?” xchaꞌ. Noꞌj rachi na xchꞌaw ta kꞌenoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","»Ekꞌuchiriꞌ, xubꞌiꞌij ri rey chike ri keniman chwa ri mexa: “Wa jun achi na uwiqom ta ribꞌ, chiyutu taq ri raqan y ruqꞌabꞌ y chikꞌaqa bꞌi pa ri qꞌequꞌm. Chiriꞌ kꞌu riꞌ koqꞌ wi y kaqichꞌichꞌ wi ruwi reꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","»Ma tobꞌ lik e kꞌi ri esikꞌim, xa e jujun ri echaꞌtal chike» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Xebꞌel kꞌu bꞌi ri fariseos chiriꞌ y xkichꞌaꞌtibꞌej chikiwach suꞌanik kakikꞌam upa ri Jesús rukꞌ taq ri kubꞌiꞌij chaꞌ kakikoj umak. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Xekitaq kꞌu bꞌi ri kitijoꞌn rike junam kukꞌ jujun chike ri kitaqem ri rey Herodes. Ekꞌu rike xkibꞌiꞌij che ri Jesús: —Lal tijonel, riꞌoj qetaꞌam lik qatzij ri kabꞌiꞌij la y lik jusukꞌ kakꞌutun la chwi ri bꞌe re ri Dios. Yey na kaxiꞌij tane ibꞌ la che taq ri kakibꞌiꞌij ri tikawex; ma rilal junam kiwach kebꞌil la konoje, tobꞌ kꞌo kiwach o na jinta kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Bꞌiꞌij kꞌu la chiqe: ¿Usukꞌ nawi kaqaꞌan tojonik che ri nimalaj taqanel re Roma o na usukꞌ taj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ri Jesús, ruma retaꞌam ri retzelal kikꞌuꞌx, jewaꞌ xubꞌiꞌij chike: —¡Xa kebꞌ palaj alaq! ¿Suꞌchak kakꞌam alaq nupa? ");
INSERT INTO acrNNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Kꞌutu pe alaq chwe juna meyo re kaꞌan tojonik rukꞌ —xchaꞌ. Ekꞌuchiriꞌ, xkikꞌut jun denario che. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ekꞌu ri Jesús xutzꞌonoj chike: —¿China re wa kꞌaxwach y china re wa bꞌiꞌaj kꞌo chwach wa meyo? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Rike xkikꞌul uwach: —Re ri nimalaj taqanel re Roma —xechaꞌ. Xubꞌiꞌij kꞌu ri Jesús chike: —Yaꞌa alaq che ri nimalaj taqanel re Roma janipa ri taqal che rire, yey yaꞌa kꞌu alaq che ri Dios janipa ri taqal che ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Echiriꞌ xkita waꞌ, lik xkam kanimaꞌ che. Xkiya kꞌu kan ri Jesús y xebꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Chupa kꞌu laꞌ la jun qꞌij, xekꞌun rukꞌ ri Jesús jujun chike ri saduceos, ri kakibꞌiꞌij na jinta kꞌastajibꞌal chike ri ekaminaq. Xkitzꞌonoj kꞌu che ri Jesús, ");
INSERT INTO acrNNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","jewaꞌ xkibꞌiꞌij: —Lal tijonel, ri Moisés xubꞌiꞌij kanoq: “We kꞌo juna achi xkamik yey na e jinta kan ralkꞌoꞌal, ekꞌu riꞌ ruchaqꞌ kakꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq y jekꞌulaꞌ kekꞌojiꞌ ralkꞌoꞌal rukꞌ pubꞌiꞌ ri ratz xkamik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","»Julaj e kꞌo wuqubꞌ achijabꞌ kichaqꞌ kibꞌ xejeqiꞌ chiqaxoꞌl. Ri nabꞌe chike xkꞌuliꞌik yey ekꞌu riꞌ waꞌ xkamik y na e jinta kan ralkꞌoꞌal rukꞌ ri rixoqil. Ewi rukaꞌm xkꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Jelaꞌ kꞌu riꞌ rukaꞌm xkamik y na e jinta kan ralkꞌoꞌal rukꞌ rixoq. Yey je tanchi laꞌ xukꞌulumaj rurox, rukaj y chikijujunal ri wuqubꞌ achijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kꞌisbꞌal kꞌu re, e xkam rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","»Chupa kꞌu ruqꞌijol ri kꞌastajibꞌal, ¿chinoq chike ri wuqubꞌ achijabꞌ kuꞌana rachijil rixoq? Ma konoje xekꞌuliꞌ rukꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ri Jesús xukꞌul uwach: —Ralaq lik sachinaq alaq, ma na majom ta alaq usukꞌ Ruchꞌaꞌtem ri Dios y ruchuqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Ma echiriꞌ kekꞌastaj lo ri ekaminaq, na kekꞌuliꞌ ta chik yey na kekiya ta chi ne ri kalkꞌoꞌal pa kꞌulanikil; kebꞌuꞌana kꞌu pachaꞌ ri ángeles re ri Dios chilaꞌ chikaj, ma ri ángeles na kekꞌuliꞌ taj. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yey puwi ri kꞌastajibꞌal ke ri ekaminaq, ¿na ajilam ta nebꞌa alaq rubꞌiꞌim ri Dios echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“In ri Dios re ri Abraham, re ri Isaac y re ri Jacob”? Yey ri Dios na e ta Dios ke ri ekaminaq, ma e Dios ke ri e kꞌaslik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Echiriꞌ xkita waꞌ, ri winaq lik xkam kanimaꞌ che taq rukꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Ri fariseos xkimol kibꞌ echiriꞌ xketaꞌmaj ri saduceos na xkiriq ta chi ukꞌulik uwach ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Kꞌo kꞌu jun chike raj kꞌutunel re ri tzijpixabꞌ xraj xukꞌam upa ri Jesús, jewaꞌ xutzꞌonoj che: ");
INSERT INTO acrNNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Lal tijonel, chupa Rutzij Upixabꞌ ri Dios, ¿pachike ri taqanik más chirajawaxik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ri Jesús xubꞌiꞌij che: —“Kꞌax chanaꞌa ra Dios Qajawxel rukꞌ ronoje awanimaꞌ, rukꞌ ronoje akꞌuꞌx y rukꞌ ronoje anaꞌoj.” ");
INSERT INTO acrNNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Waꞌ e nabꞌe tzijpixabꞌ lik chirajawaxik y e ukꞌuꞌxibꞌal Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Yey rukaꞌm jewaꞌ kubꞌiꞌij: “Kꞌax chanaꞌa rawatz-achaqꞌ jelaꞌ pachaꞌ ri kꞌax kanaꞌ awibꞌ riꞌat.” ");
INSERT INTO acrNNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ukabꞌichal waꞌ e ukꞌuꞌxibꞌal Rutzij Upixabꞌ ri Dios tzꞌibꞌital kan ruma ri Moisés y kuma ri qꞌalajisanelabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ekꞌuchiriꞌ kꞌa kimolom kibꞌ ri fariseos, ri Jesús xutzꞌonoj chike: ");
INSERT INTO acrNNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","—¿Saꞌ ri kachꞌobꞌ alaq chwi ri Cristo, Ruchaꞌoꞌn lo ri Dios? ¿China che upetebꞌem wi lo rire? —xchaꞌ. Xkikꞌul kꞌu uwach: —E ralkꞌoꞌal kan ri rey David —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ekꞌuchiriꞌ, ri Jesús xutzꞌonoj chike: —¿Chaꞌtaj kabꞌiꞌx che ri Cristo e ralkꞌoꞌal kan ri David? Ma ruma ri Ruxlabꞌixel ri Dios, ri David xubꞌiꞌij “Wajawal” che ri Cristo echiriꞌ rire xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Ri Dios Qajawxel xubꞌiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwikiqꞌabꞌ, y chawoyeꞌej na ri qꞌij echiriꞌ kebꞌenuya ri tzel kebꞌilow awe chuxeꞌ rawaqan” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ekꞌu ri David kubꞌiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbꞌe kꞌu riꞌ kabꞌiꞌxik e Ralkꞌoꞌal kan ri rey David? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Y na jinta junoq xriqow ukꞌulik uwach. Chwi kꞌu riꞌ laꞌ la jun qꞌij, konoje kakixiꞌij kibꞌ kakiꞌan tzꞌonobꞌal che. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike ri winaq y chike rutijoꞌn: ");
INSERT INTO acrNNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","«Raj kꞌutunel re ri tzijpixabꞌ y ri fariseos yaꞌtal pakiqꞌabꞌ kakiqꞌalajisaj taq rutzijpixabꞌ kan ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ruma kꞌu riꞌ, riꞌix chiꞌana janipa ri kakibꞌiꞌij puwi wa tzijpixabꞌ; noꞌj miꞌan kꞌu iweꞌix ri na utz taj kakiꞌan rike, ma junwi ri kakiꞌan rike chwa ri kakikꞌutu. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","»Ri kitaqanik rike e pachaꞌ nimaq taq eqaꞌn lik al y lik kꞌayew rukꞌaxik; kekitaq kꞌu ri winaq chaꞌ kakeqaj bꞌi yey rike na kakaj tane kꞌana ketoꞌbꞌ rukꞌ waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","»Ronoje taq ri kakiꞌano xew e chaꞌ kebꞌilitaj kuma ri winaq. Kakiꞌan che kibꞌ pachaꞌ lik e jusukꞌ chwach ri Dios; ruma kꞌu laꞌ, e ri kifilacterias ximital chukurusil ri kipalaj y che ri kiqꞌabꞌ, lik kakiꞌan nim che; yey taq ri cordón karabꞌabꞌ che ri kiqꞌuꞌ, kakiꞌan lik naj raqan che. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Pa taq ri sinagogas y pa taq waꞌim, lik e kukꞌul kikꞌuꞌx ketzꞌuyiꞌ chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Yey lik kukꞌul kikꞌuꞌx kayaꞌ rutzil kiwach pa kebꞌilitaj wi y kabꞌiꞌx chike: “¡Lal tijonel!” ");
INSERT INTO acrNNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","»Ekꞌu riꞌix miwoyꞌej kabꞌiꞌx “¡Lal tijonel!” chiwe, ma xa jun ri tijonel iwe, waꞌ e ri Cristo. Yey ruma Rire xixuꞌan iwatz-ichaqꞌ iwibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Mibꞌiꞌij “Nuqaw” che junoq wara che ruwachulew, ma xa jun Riqaw kꞌolik, y waꞌ e Riqaw kꞌo chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Miya luwar kabꞌiꞌx “¡Lal Aj Kꞌamal Qawach!” chiwe, ma xa jun ri Aj Kꞌamal Iwach, waꞌ e ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","»Ekꞌu ri kꞌo uwach chixoꞌlibꞌal riꞌix e chuyaꞌa ribꞌ kuꞌan nimanel iweꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ma china ri lik kuꞌan nim che ribꞌ, ri Dios kuqasaj uwa uqꞌij; noꞌj china ri kuꞌan chꞌutiꞌn che ribꞌ, ri Dios kuyak uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","»¡Lik kꞌu toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! E tzꞌapim alaq ri okibꞌal re rutaqanik ri Dios petinaq chilaꞌ chikaj chaꞌ na jinta kꞌo kebꞌok bꞌi; ma na kok tane ubꞌi ralaq y na kaya tane alaq luwar chike jujun chik kebꞌok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ma kamaj alaq ri kocho rixoqibꞌ e malkaꞌnibꞌ. Yey chaꞌ na kaqꞌalajin ta ri na utz taj kaꞌan alaq, e kawererej alaq unimal chꞌabꞌal echiriꞌ kaꞌan alaq orar. Ruma kꞌu wa kaꞌan alaq, lik unimal kꞌaxkꞌolil kakꞌul na alaq echiriꞌ kaqꞌat tzij pawiꞌ alaq ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ralaq kaqꞌaxuj alaq uwi taq mar y kabꞌinibꞌej alaq taq ri luwar che ruwachulew chaꞌ juna tikawex kuꞌan tijoꞌn alaq. Yey echiriꞌ uꞌanom chi tijoꞌn alaq, kaꞌan alaq che ri tikawex kalaj más itzel uwachlibꞌal chiwach ralaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","»Lik toqꞌoꞌ wach ralaq alaq pachaꞌ potzꞌ kꞌamal kiwach jujun chik, ma kabꞌiꞌij alaq: “We kꞌo junoq kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ ri Rocho Dios, riꞌ na chirajawaxik ta che kuꞌan ri ubꞌiꞌim; noꞌj we kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ ri oro re ri Rocho Dios, riꞌ chirajawaxik che kuꞌan janipa ri ubꞌiꞌim” kacha alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","»¡Na jinta naꞌoj alaq y alaq potzꞌ! ¿Pachike ri más kꞌo uwach? ¿E ri oro o e ri Rocho Dios, ri kuꞌan santo che ri oro? ");
INSERT INTO acrNNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Jenewaꞌ ri kabꞌiꞌij ralaq: “We kꞌo junoq kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ raltar, na chirajawaxik ta che kuꞌan ri ubꞌiꞌim; noꞌj we kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ ri qasaꞌn kꞌo chwi raltar, riꞌ chirajawaxik che kuꞌan janipa ri ubꞌiꞌim” kacha alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","»¡Sachinaq ri naꞌoj alaq y alaq potzꞌ! ¿Pachike ri más kꞌo uwach? ¿E ri qasaꞌn o e raltar ri kuꞌan santo che ri qasaꞌn? ");
INSERT INTO acrNNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ma china ri kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ raltar, riꞌ na xew ta kuꞌan pa rubꞌiꞌ raltar, ma kuꞌan pa rubꞌiꞌ ronoje ri kꞌo chwi raltar. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Jekꞌulaꞌ, china ri kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ ri Rocho Dios, na xew ta kuꞌan pa rubꞌiꞌ ri Rocho Dios, ma riꞌ e kuꞌan tzij pa rubꞌiꞌ ri Dios, ri Jun jeqel chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Jekꞌulaꞌ, china ri kujikibꞌaꞌ uwach juna tzij pa rubꞌiꞌ ri kaj, riꞌ kuꞌan pa rubꞌiꞌ ri tzꞌulibꞌal pa kataqan wi ri Dios y kuꞌan pa rubꞌiꞌ ri Jun tzꞌul chupa. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ma kaya alaq che ri Dios ri diezmo alaq re ri arweno, re ri anix y re ri kominox. Noꞌj na kok ta alaq il che rukꞌuꞌxibꞌal ri Tzij Pixabꞌ re ri Dios: Waꞌ e ri kaꞌan alaq ri usukꞌ, ri kakꞌut alaq ri kꞌaxnaꞌbꞌal kꞌuꞌx alaq chike jujun chik y ri kakubꞌiꞌ kꞌuꞌx alaq rukꞌ ri Dios. Lik chirajawaxik kꞌu riꞌ kaꞌan alaq taq waꞌ, junam rukꞌ ri kaya ri diezmo alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","»¡Alaq pachaꞌ potzꞌ kꞌamal kiwach jujun chik! Ma ri kaꞌan alaq e pachaꞌ junoq lik kuchajij ribꞌ chaꞌ na kubꞌiqꞌ tubꞌi tobꞌ xa juna ralko us, pero kubꞌiqꞌ bꞌi ri nimaq taq awaj pachaꞌ ri camello. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ma xew kachꞌaj alaq chi utz ri rij ri vaso y ri laq, pero na kok ta alaq il che uchꞌajik rupa. Jekꞌuriꞌlaꞌ ralaq lik kok alaq il che ri josqꞌinik re ri cuerpo, pero lik kꞌo chꞌulil pa animaꞌ alaq ruma releqꞌ y ri na usukꞌ taj ꞌanom alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Rilal fariseo, lal potzꞌ! Nabꞌe na chꞌaja la rupa ri vaso y ri laq; jekꞌuriꞌlaꞌ kuꞌan chom rupa y ri rij. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ma ralaq alaq pachaꞌ muqubꞌal ke animaꞌ xew ꞌanom saq che ri rij; chom katzuꞌnik, noꞌj kꞌu rupa nojinaq che kibꞌaqil animaꞌ y che ukꞌiyal chꞌul. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Jekꞌulaꞌ ri ꞌanom ralaq, ma ri bꞌinik silabꞌik alaq e kilitajik pachaꞌ lik jusukꞌ chikiwach ri winaq; noꞌj xa kebꞌ palaj alaq, ma ri kꞌuꞌx alaq nojinaq che ukꞌiyal chꞌulil. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","»¡Lik toqꞌoꞌ wach alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! ¡Xa kebꞌ palaj alaq! Ma kayak alaq chomilaj muqubꞌal chike ri qꞌalajisanelabꞌ re ojertan y kawiq alaq ri muqubꞌal ke ri tikawex lik jusukꞌ xebꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Yey kabꞌiꞌij kꞌu alaq: “We ta oj kꞌo chi riꞌoj echiriꞌ xekꞌasiꞌ ri qatiꞌ-qamam ojertan, na kaqaꞌan ta qeꞌoj riꞌ kukꞌ ri xekamisan ri qꞌalajisanelabꞌ” kacha alaq. Pero ¡na e ta kꞌana uꞌanom! ");
INSERT INTO acrNNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Rukꞌ kꞌu ri katajin alaq che uꞌanik, kaqꞌalajinik alaq kalkꞌoꞌal kan ri xekamisan ke ri qꞌalajisanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Kꞌisa kꞌu alaq uꞌanik riꞌ ri na utz taj xkijeq lo uꞌanik ri chuꞌqaw alaq ojertan! ");
INSERT INTO acrNNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","»¡Ralaq pachaꞌ alaq jupuq chi kumatz! ¿Suꞌanik kesaj ibꞌ alaq chuxeꞌ ri qꞌatbꞌal tzij re ri Dios echiriꞌ kutaq bꞌi alaq chi xibꞌalbꞌaꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","E uwariꞌche riꞌin kebꞌenutaq lo ukꞌ alaq qꞌalajisanelabꞌ, waj chak lik kꞌo kinaꞌoj y aj kꞌutunel re Rutzij Upixabꞌ ri Dios. Pero ralaq kekamisaj alaq jujun chike rike. E kꞌo ne ri kekamisaj alaq chwa cruz, jujun chik kajichꞌ alaq kipa pa taq sinagogas y jujun chik keternabꞌej alaq rukꞌ kꞌaxkꞌobꞌik pa taq tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ruma kꞌu riꞌ kape pawiꞌ alaq ronoje ri kꞌaxkꞌobꞌik taqal chike ri xekamisan ke rachijabꞌ jusukꞌ xebꞌinik, ujeqebꞌem lo chwi rukamik ri Abel ri jun ala lik jusukꞌ, kꞌa chwa rukamik ri Zacarías, rukꞌajol ri Berequías, ri xkamisaj alaq chuxoꞌl raltar y ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Paqatzij wi kambꞌiꞌij che alaq: Ronoje waꞌ kape pakiwi ri winaq e kꞌo waqꞌij ora» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Tekꞌuchiriꞌ, xubꞌiꞌij: «¡Jerusalem, Jerusalem, riꞌix kebꞌikamisaj ri qꞌalajisanelabꞌ y kebꞌiꞌan paꞌbꞌaj janipa ri ebꞌutaqom lo ri Dios iwukꞌ! E riꞌin, ukꞌiyal laj lik xuaj xinmol kichiꞌ riwalkꞌoꞌal riꞌix, jelaꞌ pachaꞌ kuꞌan juna atiꞌ akꞌ chike taq ruwiꞌch echiriꞌ kumol kichiꞌ chuxeꞌ taq ruxikꞌ; pero riꞌix na xiwaj ta kꞌenoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","»Chitape kꞌut: Kꞌo jun qꞌij ri iwocho riꞌix kawulix kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Kambꞌiꞌij kꞌu chiwe riꞌix: Chwi kꞌu woꞌora na kiwil ta chi kꞌana nuwach riꞌin kꞌa echiriꞌ kopon na ruqꞌijol kibꞌiꞌij riꞌix: Lik nim uqꞌij ri jun petinaq chupa rubꞌiꞌ ri Dios Qajawxel kixchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Echiriꞌ xel bꞌi ri Jesús pa ri Rocho Dios yey e riꞌ keꞌek, xeqibꞌ rutijoꞌn rukꞌ re kakikꞌut che, ruchomalil ri nimaq taq ja re ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ekꞌu ri Jesús xukꞌul uwach: —¿Kiwil riꞌix ronoje waꞌ? Paqatzij wi kambꞌiꞌij chiwe, wara na kakanaj ta chi kan juna abꞌaj puwi juna chik, ma ronoje kawulixik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Tekꞌuchiriꞌ, xebꞌopon chwa ri juyubꞌ Olivos. Yey echiriꞌ xtzꞌuyiꞌ ri Jesús, xeqibꞌ rutijoꞌn rukꞌ, y ekꞌu laꞌ xa kitukel xkijeq kakitzꞌonoj che: —Bꞌiꞌij ko la chiqe, ¿jampa nawi kuꞌana taq riꞌ waꞌ? ¿Yey saꞌ ri kꞌutubꞌal re ri kꞌunibꞌal la y re ri kꞌisbꞌal re ruwachulew? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ekꞌu ri Jesús xukꞌul uwach: «Lik chichajij iwibꞌ chaꞌ na jinta junoq kasokow iweꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Ma lik e kꞌi ri tikawex kekꞌunik y xa kakichiqꞌimaj uwach ri nubꞌiꞌ, jewaꞌ kakibꞌiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios” kechaꞌ. Y lik e kꞌi ri kesokotaj kuma rike. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","»Kita kꞌu riꞌ kꞌo chꞌaꞌoj jewaꞌ y kꞌo chꞌaꞌoj jelaꞌ. Mixiꞌij kꞌu iwibꞌ che, ma lik chirajawaxik wi kuꞌana taq waꞌ; noꞌj na e ta waꞌ ri kꞌisbꞌal re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Ma e kꞌo tinamit keyaktaj chikij jujun chik tinamit y e kꞌo taqanelabꞌ keyaktaj chikij jujun chik taqanelabꞌ. Kape kꞌu numik y yabꞌil yey kuꞌan taq kabꞌraqan che ukꞌiyal luwar. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ronoje waꞌ e jeqebꞌal re taq ri kꞌaxkꞌobꞌik kakꞌunik. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","»Ekꞌuchiriꞌ, kixyaꞌ riꞌix pa taq kꞌaxkꞌobꞌik y kixkamisaxik; yey konoje taq ri tinamit che ruwachulew lik tzel kixkilo ruma ikojom ri nubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Chupa taq laꞌ laꞌ qꞌij, lik e kꞌi ri kakesaj kibꞌ chirij ri Dios, kakijeq lik tzel kakil kibꞌ chikiwach y kakikꞌayij kibꞌ chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","»Lik e kꞌi ri qꞌalajisanelabꞌ xa e sokosoꞌnel keyaktajik y lik e kꞌi ri winaq kesokotaj kuma rike. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ruma kꞌu rukꞌiyarik taq uwach ri mak, lik e kꞌi ri kaqꞌobꞌ ri rutzil kꞌuꞌxaj pa kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","China kꞌu ri lik kuchuqꞌubꞌej ribꞌ chwach taq waꞌ wa kꞌaxkꞌobꞌik kꞌa chupa ri kꞌisbꞌal re, e riꞌ ri kakolobꞌetajik. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","»Yey wa Utzilaj Tzij re rutaqanik ri Dios katzijox na chike rukꞌiyal kiwach taq ri tikawex e kꞌo che ruwachulew chaꞌ konoje kaketaꞌmaj kꞌu riꞌ waꞌ; tekꞌuchiriꞌ, kakꞌun lo ri kꞌisbꞌal re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","»E uwariꞌche echiriꞌ kiwil riꞌix ri lik chꞌul y lik kꞌixbꞌal uwach kayaꞌ chupa ri Luwar Santo, jelaꞌ pachaꞌ ri xutzꞌibꞌaj kan ri qꞌalajisanel Daniel; (china kꞌu ri kajilan re waꞌ, chumaja usukꞌ), ");
INSERT INTO acrNNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ekꞌu ri e kꞌo pa taq ri luwar re Judea chebꞌanimaj ubꞌi chwa taq ri juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","China kꞌu ri kꞌo lo chwi ri rocho, maqaj ne lo che ukꞌamik bꞌi ubꞌitaq re pa ja. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Yey china ri kꞌo lo pa juyubꞌ, matzelej ne lo che ukꞌamik bꞌi ruqꞌuꞌ re pisbꞌal rij. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","»Chupa taq kꞌu laꞌ la qꞌij, lik toqꞌoꞌ kiwach ri e yewaꞌ ixoqibꞌ y ri ketzꞌumtisanik. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Lik kꞌu chitzꞌonoj che ri Dios chaꞌ echiriꞌ kixanimaj bꞌi, na e ta uqꞌijol echiriꞌ kꞌax tew y kꞌo jabꞌ yey na chupa tane juna qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Ma kakꞌun kꞌu jun unimal kꞌaxkꞌobꞌik, waꞌ na uꞌanom ta kꞌana julajoq chwi lo ri jeqebꞌal ruwachulew y na kuꞌana ta chi ne kꞌana julajoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","We ta ri Qaqaw Dios na kuqꞌatij ta taq laꞌ la qꞌij re runimal kꞌaxkꞌobꞌik, riꞌ na jinta junoq kakꞌasiꞌ kanoq; pero ruma kꞌu kꞌax kebꞌunaꞌ ri ebꞌuchaꞌom, kuqꞌatij ruqꞌijol waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","»We kꞌo kꞌu junoq riꞌ kabꞌiꞌn chiwe: “¡Chiwilapeꞌ, wara kꞌo wi ri Cristo!” o “¡Chiwilapeꞌ, leꞌ kꞌolik!”, mixok il che. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Ma kekꞌun ri kakiꞌan “Cristo” che kibꞌ y ri kakiꞌan “e qꞌalajisanelabꞌ re ri Dios” che kibꞌ, pero xa e sokosoꞌnel. Ekꞌu rike kakiꞌan nimaq taq kꞌutubꞌal y milagros re kesokosoꞌn rukꞌ, yey kꞌo ne pa saq kesokotaj jujun chike ri ebꞌuchaꞌom ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","»Chita kꞌu riꞌ ma ximbꞌiꞌij waꞌ chiwe riꞌix echiriꞌ kꞌamajaꞌ ne kuꞌanaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","E uwariꞌche tobꞌ kabꞌiꞌx chiwe: “Chiwilapeꞌ, leꞌ ri Cristo kꞌo pa ri luwar katzꞌintzꞌotik”, mixꞌek che rilik. Tobꞌ ne kabꞌiꞌx chiwe: “Chiwilapeꞌ, leꞌ ri Cristo kꞌo lo pa ja”, mixok il che. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ma jelaꞌ pachaꞌ echiriꞌ kayokꞌ kaꞌn ruxeꞌ kaj pa relebꞌal lo ri qꞌij y kilitaj kꞌa putzaqibꞌal ri qꞌij, jelaꞌ kuꞌan rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ma lik kaqꞌalajin rukꞌunibꞌal chikiwach konoje ri winaq; e jelaꞌ pachaꞌ lik kaqꞌalajin pa kꞌo wi juna kaminaq, ma puwi waꞌ kakimol wi kibꞌ taq ri kꞌuch. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","»Xew kꞌu kikꞌow ri kꞌaxkꞌobꞌik chupa taq laꞌ la qꞌij, kuꞌan qꞌequꞌm uwach ri qꞌij, ri ikꞌ na kuya ta chi ruwonibꞌal, ri chꞌumil ketzaq lo che ruwa kaj yey konoje ri kꞌo kichuqꞌabꞌ che ruwa kaj keyikiyoꞌxik. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ekꞌuchiriꞌ, kilitaj che ruwa kaj ri kꞌutubꞌal re rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. Konoje kꞌu rukꞌiyal kiwach taq ri tikawex e kꞌo che ruwachulew kebꞌoqꞌik y kakil kꞌu Ralaxel Chikixoꞌl Tikawex kakꞌun lo pa sutzꞌ chwa ri kaj rukꞌ ruchuqꞌabꞌ y rukꞌ runimal uchomalil. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Kebꞌutaq kꞌu ru ángeles rukꞌ unimal uchꞌawibꞌal trompeta re kakimol kichiꞌ konoje ri ebꞌuchaꞌom ri Dios pa taq ronoje luwar che rukajchal rajlibꞌal ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","»E chimaja ri jun kꞌambꞌal naꞌoj puwi ri cheꞌ re higo: Echiriꞌ kujeq katux lo kꞌakꞌ uqꞌabꞌ y kujeq kꞌut katux ruxaq, ruma kꞌu laꞌ kiwetaꞌmaj xa naqaj chi kꞌo wi lo ruqꞌijol echiriꞌ kabꞌukbꞌutik y na jinta jabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Jekꞌuriꞌlaꞌ riꞌix, echiriꞌ kiwilo kuꞌana ronoje taq waꞌ, chiwetaꞌmaj kꞌu riꞌ xa naqaj chi kꞌo wi lo ruqꞌijol rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Paqatzij wi kambꞌiꞌij chiwe: E kꞌo tikawex che taq laꞌ la qꞌij na kekam tana we na kakil tubꞌi ronoje waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ruwa kaj y ruwachulew xa kasach uwach, noꞌj taq ri nuchꞌaꞌtem na kasach ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","»Ekꞌu chwi ruqꞌijol y ruꞌorayil waꞌ, na jinta junoq etaꞌmayom re; na ketaꞌam tane ri ángeles e kꞌo chilaꞌ chikaj, ma xew ri Nuqaw etaꞌmayom re. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ma jelaꞌ pachaꞌ ri xuꞌan chupa taq ri qꞌij re ri Noé, jelaꞌ kuꞌana pa rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ma chupa taq laꞌ la qꞌij echiriꞌ kꞌamajaꞌ kape ri unimal jabꞌ, taq ri winaq xew kakitij kiwa, kakitij kiyaꞌ, kekꞌuliꞌik y kekiya ri kalkꞌoꞌal pa kꞌulanikil. Ekꞌu ketajin riꞌ che uꞌanikil echiriꞌ xopon ruqꞌijol xok bꞌi ri Noé chupa ri nimalaj barco. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Na xkinaꞌbꞌej tane ri xpe pakiwiꞌ, kꞌate kꞌu xkinaꞌo xkꞌun lo ri unimal jabꞌ; ri yaꞌ xebꞌukꞌam bꞌi ri winaq y xekam kꞌu konoje. Jekꞌulaꞌ kuꞌano echiriꞌ kakꞌun tanchi Ralaxel Chikixoꞌl Tikawex, ma xaqikꞌateꞌt kakꞌunik. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","»Chupa kꞌu laꞌ la qꞌij, kꞌo kuꞌana wi e kꞌo kebꞌ achijabꞌ chwa juyubꞌ; jun kakꞌam bꞌi y ri jun chik kayaꞌiꞌ kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","O e kꞌo kebꞌ ixoqibꞌ junam kekeꞌnik, jun kꞌu kakꞌam bꞌi y ri jun chik kayaꞌiꞌ kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Lik kꞌut mawar iwach riꞌix, ma na iwetaꞌam ta ruꞌorayil rukꞌunibꞌal ri Iwajawal. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","»Ekꞌu chiwetaꞌmaj waꞌ: Juna achi rajaw ja we ta karetaꞌmaj ri ora echiriꞌ kopon releqꞌom, riꞌ na kawar ta kꞌenoq y na kuya ta luwar kok releqꞌom pa ri rocho. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","E uwariꞌche riꞌix chiyijbꞌaꞌ iwibꞌ che rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex, ma kꞌaxtaj kakꞌunik echiriꞌ na jinta inaꞌbꞌem. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","»¿Chinoq chiwe e pachaꞌ juna aj chak lik jusukꞌ y kꞌo unaꞌoj, ri yaꞌom puqꞌabꞌ kebꞌutzuq chupa ruꞌorayil konoje ri e kꞌo pa rocho rupatrón? ");
INSERT INTO acrNNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Lik kꞌu nim uqꞌij ralaxik riꞌ ri aj chak we xkꞌun lo rupatrón, koluꞌriqaꞌ katajin che uꞌanik ruchak. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ma paqatzij wi kambꞌiꞌij chiwe: Rupatrón kuꞌana taqanel che rire puwi ronoje rubꞌitaq re. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","»Noꞌj we waꞌ wa jun aj chak kuꞌan ri na utz taj y kubꞌiꞌij kꞌu pa ranimaꞌ: “Ri nupatrón kꞌamajaꞌ katzelej loq” ");
INSERT INTO acrNNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","y kujeq kꞌu kebꞌuchꞌay ri rach aj chakibꞌ; yey ekꞌu rire xew kawaꞌik y kaqꞌabꞌar kukꞌ qꞌabꞌaꞌrelabꞌ, ¿saꞌ kꞌu riꞌ ri kukꞌulumaj? ");
INSERT INTO acrNNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Kakꞌun lo riꞌ rupatrón chupa ri qꞌij y ri ora echiriꞌ waꞌ wa aj chak na royeꞌem taj. ");
INSERT INTO acrNNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kuqꞌat kꞌu tzij riꞌ puwi ri raj chak y lik kuya pa kꞌax junam kukꞌ ri xa kebꞌ kipalaj, chiriꞌ kꞌu riꞌ koqꞌ wi y kaqichꞌichꞌ wi ruwi reꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","»Ri kuꞌana pa rutaqanik ri Dios petinaq chilaꞌ chikaj, e jelaꞌ pachaꞌ ri xkikꞌulumaj lajuj qꞌapoj alito echiriꞌ xkikꞌam bꞌi ri kicandil y xebꞌek pa jun kꞌulanikil re keꞌkikꞌulu rala kakꞌuliꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","E kꞌo kꞌu woꞌobꞌ chike lik kꞌo kinaꞌoj y ri woꞌobꞌ chik na jinta kinaꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","»Ri woꞌobꞌ na jinta kinaꞌoj xkikꞌam bꞌi ri kicandil, pero na xkikꞌam tubꞌi aceite re kakinojisaj tanchik. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ekꞌu ri kꞌo kinaꞌoj kinojisam bꞌi ri kicandil che aceite, yey pa rewi kukꞌaꞌam aceite pa jun chik kꞌolibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ekꞌu rala kakꞌuliꞌik xmayin che ri roponik. Ruma kꞌu riꞌ, ralito xkijeqo keyuxkꞌaꞌtik y xok lo kiwaram. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","»Pa tikꞌil aqꞌabꞌ kꞌut, xtataj jun kasikꞌinik, jewaꞌ kubꞌiꞌij: “¡Rala xkꞌunik! ¡Chixela lo che ukꞌulik!” ");
INSERT INTO acrNNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Konoje kꞌu ri qꞌapoj alito xeyaktajik y xkijeq uyijbꞌaxik ri kicandil. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","»Ekꞌu ri woꞌobꞌ alito na jinta kinaꞌoj jewaꞌ xkibꞌiꞌij chike ri lik kꞌo kinaꞌoj: “Chiyaꞌa jubꞌiqꞌ qaceite che ri kꞌo iwukꞌ riꞌix, ma ri qacandil riꞌoj katajin uchupik.” ");
INSERT INTO acrNNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","»Noꞌj ri woꞌobꞌ chik jewaꞌ xkikꞌul uwach: “We kaqaya iwe riꞌix, na kuꞌan ta riꞌ qe qonoje. Jiꞌtzukuj kꞌu iweꞌix pa kakꞌayix wi y chiloqꞌoꞌ.” ");
INSERT INTO acrNNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","»Ekꞌuchiriꞌ ebꞌelinaq bꞌi ri woꞌobꞌ che uloqꞌik aceite, xkꞌun lo rala. Ralito kꞌo kinaꞌoj, ri kiyijbꞌam chi pan ri kicandil, xebꞌok junam rukꞌ rala pa kꞌulanikil y xtzꞌapix kꞌu lo ri puerta. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","»Tekꞌuchiriꞌ, xetzelej lo ri woꞌobꞌ alito y xechꞌaw apanoq: “Qajawal, qajawal, jaqa lo la ri puerta chiqe.” ");
INSERT INTO acrNNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","»Ekꞌu rala kakꞌuliꞌik xukꞌul lo uwach: “Paqatzij wi kambꞌiꞌij chiwe: Na wetaꞌam ta kꞌana iwach.” ");
INSERT INTO acrNNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","»Mawar kꞌu iwach riꞌ riꞌix, ma na iwetaꞌam tane ruqꞌijol y ruꞌorayil echiriꞌ kakꞌun lo Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","»Ri kuꞌana pa rutaqanik ri Dios petinaq chilaꞌ chikaj, e pachaꞌ ri xuꞌan jun achi echiriꞌ xeꞌek pa jun luwar lik naj; xebꞌusikꞌij kꞌu ri raj chakibꞌ y xuya kan rupuaq pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Che jun xuya kan woꞌobꞌ mil, che jun chik xuya kan kaꞌibꞌ mil y che jun chik xuya kan mil. Wa xyaꞌ kan chike e chirij ri kakichꞌij uchakuxik. Ekꞌuchiriꞌ, xeꞌek naj. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","»Ekꞌu raj chak xkꞌamaw kan ri woꞌobꞌ mil, xuꞌan ukꞌay rukꞌ y jelaꞌ xuchꞌak chi woꞌobꞌ mil puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Jekꞌulaꞌ xuꞌan ri xkꞌamaw kan kebꞌ mil, xuchꞌak chi kebꞌ mil puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Noꞌj ri xkꞌamaw kan jun mil, xukꞌot jun jul y chupa waꞌ xrewaj ri puaq yaꞌtal puqꞌabꞌ ruma ri rajaw. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","»Ikꞌowinaq chi kꞌu ukꞌiyal qꞌij, xtzelej tanchi lo ri kajaw raj chakibꞌ y xutzꞌonoj kꞌu chike saꞌ ri xkiꞌan rukꞌ rupuaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nabꞌe xopon ri raj chak ri ukꞌamom kan woꞌobꞌ mil. Xuya kꞌu che ri rajaw ri woꞌobꞌ mil chik xuchꞌak puwi ri yaꞌom kan che y jewaꞌ xubꞌiꞌij: “Wajaw, riꞌ ri woꞌobꞌ mil xya kan la chwe y riꞌ chi woꞌobꞌ mil, waꞌ e xinchꞌak puwi ri xya kan la chwe” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","»Ri rajaw xubꞌiꞌij kꞌu che: “Utz riꞌ, riꞌat at utzilaj waj chak y lik at jusukꞌ; ma jusukꞌ xachakuj ri xa jubꞌiqꞌ yaꞌtal kan paqꞌabꞌ. E uwariꞌche woꞌora lik kꞌi ri kanya paqꞌabꞌ. Chatokoq y chatkiꞌkota wukꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","»Tekꞌuchiriꞌ, xopon raj chak ri ukꞌamom kan kaꞌibꞌ mil y xubꞌiꞌij che: “Wajawal, riꞌ ri kaꞌibꞌ mil xya kan la chwe y riꞌ chi kaꞌibꞌ mil kanya cheꞌla, waꞌ e xinchꞌak puwi ri xya kan la chwe” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","»Ri rajaw xubꞌiꞌij kꞌu che: “Utz riꞌ, at utzilaj waj chak y lik at jusukꞌ; ma jusukꞌ xachakuj ri xa jubꞌiqꞌ yaꞌtal kan paqꞌabꞌ. E uwariꞌche woꞌora lik kꞌi ri kanya paqꞌabꞌ. Chatokoq y lik chatkiꞌkota wukꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","»Ekꞌuchiriꞌ, xopon ri jun chik aj chak ri yaꞌom kan xa jun mil che, y jewaꞌ xubꞌiꞌij che ri rajaw: “Wajaw, riꞌin wetaꞌam lal jun achi lik titzꞌitik, ma kaꞌan la molonik pa na awaninaq ta wi la yey kamolon ne la pa na jinta jopopem wi la. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","E uwariꞌche riꞌin lik xinxiꞌij wibꞌ. Xinꞌek kꞌut y xinmuq ri puaq la pulew. Riꞌ ri mil yaꞌom kan la chwe, ma e la” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","»Ri rajaw xubꞌiꞌij che: “At jun waj chak lik na utz taj y at xepu. We xachꞌobꞌo kanꞌan molonik pa na in awaninaq ta wi yey kanmol pa na jinta nujopopem wi, ");
INSERT INTO acrNNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","xaꞌyaꞌa ta kꞌu riꞌ ri nupuaq pa juna banco chaꞌ echiriꞌ kintzelej loq, kankꞌul ri nupuaq junam rukꞌ ruchꞌakom chik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","»Tekꞌuchiriꞌ, xubꞌiꞌij chike jujun chik raj chak e kꞌo chiriꞌ: “Chimaja che wa jun aj chak ri mil kꞌo rukꞌ y chiyaꞌa che ri kꞌo lajuj mil rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Ma china ri lik kꞌi kꞌo rukꞌ, kayaꞌiꞌ más che y jelaꞌ kakꞌojiꞌ ne uwiꞌ ri kꞌo rukꞌ. Noꞌj ri na jinta kꞌo rukꞌ, kamaj ne che ri xa jubꞌiqꞌ kꞌo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ekꞌu waꞌ wa jun aj chak na jinta uchak, jiꞌkꞌaqa bꞌi pa ri qꞌequꞌm; chiriꞌ kꞌu riꞌ koqꞌ wi y kaqichꞌichꞌ wi ruwiꞌ reꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","»Echiriꞌ Ralaxel Chikixoꞌl Tikawex kakꞌun rukꞌ runimal uchuqꞌabꞌ kukꞌ konoje ri santowilaj ángeles, katzꞌuyiꞌ na kꞌu riꞌ chupa ri chomilaj tzꞌulibꞌal re rutaqanik. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Konoje taq kꞌu ri tinamit che ruwachulew kakimol kibꞌ chwach y Rire kujach kipa chikijujunal, jelaꞌ pachaꞌ kuꞌan juna chajinel kebꞌeresaj ri bꞌexex chikixoꞌl ri kaprux. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Kebꞌuya kꞌu ri bꞌexex puwikiqꞌabꞌ Rire yey ri kaprux kebꞌuya pumox. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","»Ekꞌuchiriꞌ, ri rey kubꞌiꞌij chike ri e kꞌo puwikiqꞌabꞌ Rire: “¡Chixpetoq! ¡Lik nim iqꞌij iwalaxik riꞌix! Chixok kꞌu chupa rutaqanik ri Dios y chikꞌulu janipa ri uyijbꞌam chi pan chiwe chwi lo ri jeqebꞌal re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ma xinkꞌojiꞌ pa numik y riꞌix xiya nuwa; xinkꞌojiꞌ pa tzajin chiꞌ y riꞌix xiya numiqꞌinaꞌ; xintzukuj pa kinkanaj kan wi y riꞌix xinikꞌul pa iwocho. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na jinta ko nuqꞌuꞌ y riꞌix xiya nuqꞌuꞌ; xinkꞌojiꞌ pa yabꞌil y xixeꞌbꞌina wukꞌ; xinkꞌojiꞌ pa cárcel y xiniꞌwilaꞌ” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","»Ekꞌu ri e jusukꞌ echiriꞌ kakita waꞌ, jewaꞌ kakibꞌiꞌij: “Qajawal, ¿jampalaꞌ xqil la lal kꞌo la pa numik y xqaya wa la? ¿Jampalaꞌ xqil la lal kꞌo la pa tzajin chiꞌ y xqaya miqꞌinaꞌ la? ");
INSERT INTO acrNNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Jampalaꞌ xqil la katzukuj la pa kakanaj kan wi la y xqakꞌul la pa qocho? ¿Jampalaꞌ xqil la na jinta qꞌuꞌ la y xqaya qꞌuꞌ la? ");
INSERT INTO acrNNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Jampalaꞌ xqil la lal yewaꞌ o kꞌo la pa cárcel yey xeꞌqila la?” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","»Y ri rey kukꞌul uwach chike: “Paqatzij wi kambꞌiꞌij chiwe: Ronoje kꞌu ri xiꞌan chike wa watz-nuchaqꞌ na jinta ko kiwach, chwe riꞌin xiꞌan wi” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","»Ekꞌuchiriꞌ, kubꞌiꞌij ri rey chike ri e kꞌo pumox: “Riꞌix itzel iwachlibꞌal, chixela wukꞌ; kixꞌek kꞌu chupa ri aqꞌ na kachup ta chik, ri yijbꞌital chi pan che ritzel winaq kukꞌ konoje ru ángeles eteran chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Ma riꞌin xinkꞌojiꞌ pa numik yey riꞌix na xiya ta nuwa; xinkꞌojiꞌ pa tzajin chiꞌ, yey riꞌix na xiya ta numiqꞌinaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Xintzukuj pa kinkanaj kan wi, yey riꞌix na xinikꞌul ta pa iwocho. Na jinta ko nuqꞌuꞌ, yey riꞌix na xiya ta nuqꞌuꞌ. Xinkꞌojiꞌ pa yabꞌil y xinkꞌojiꞌ pa cárcel, yey riꞌix na xiniꞌwila taj” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","»Ekꞌuchiriꞌ, kakibꞌiꞌij rike che: “Qajawal, ¿jampalaꞌ xqil la kanum la yey katzajin chiꞌ la? ¿Jampalaꞌ xqil la katzukuj la pa kakanaj kan wi la? ¿Jampalaꞌ xqil la na jinta qꞌuꞌ la? ¿Jampalaꞌ xqil la lal yewaꞌ o kꞌo la pa cárcel, yey riꞌoj na xqanimaj ta la?” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","»Ri rey kukꞌul kꞌu uwach chike: “Paqatzij wi kambꞌiꞌij chiwe: Ronoje ri na xiꞌan ta chike wa watz-nuchaqꞌ na jinta ko kiwach, chwe riꞌin na xiꞌan ta wi” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","»Konoje kꞌu riꞌ waꞌ kebꞌek pa ri kꞌaxkꞌobꞌik na jinta utaqexik, noꞌj ri e jusukꞌ kebꞌek pa ri kꞌaslemal na jinta utaqexik» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Echiriꞌ ri Jesús xukꞌis ubꞌiꞌxikil ronoje waꞌ, jewaꞌ xubꞌiꞌij chike rutijoꞌn: ");
INSERT INTO acrNNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","«Riꞌix iwetaꞌam pa kebꞌ qꞌij kakꞌun lo ri nimaqꞌij Pascua; chupa kꞌu riꞌ wa nimaqꞌij, Ralaxel Chikixoꞌl Tikawex kayaꞌ pa kamik chwa cruz» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ekꞌu ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ y ri nimaq winaq e aj wach re ri tinamit, xkimol kibꞌ che ruwa ja re ri palacio re ri Caifás, ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chiriꞌ xkichꞌaꞌtibꞌej chikiwach suꞌanik kakichap ri Jesús rukꞌ sokosoꞌnik re kakikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xkibꞌiꞌij kꞌu chikiwach: «Na kaqaꞌan ta pa ri nimaqꞌij chaꞌ ri tinamit na ketukuk ta ruma waꞌ» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ri Jesús kꞌo pa ri tinamit Betania chirocho ri Simón, ri jun xkꞌojiꞌ ri yabꞌil lepra che. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Xkꞌun kꞌu jun ixoq rukꞌaꞌam jun kꞌolibꞌal nojinaq che kunabꞌal lik kiꞌ ruxlabꞌ y lik kꞌi rajil. Xqibꞌ kꞌu rukꞌ ri Jesús y xuqꞌej ri kunabꞌal chuꞌjolom echiriꞌ Rire tzꞌul chwa ri mexa. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Echiriꞌ xkil waꞌ rutijoꞌn, lik xpe koyowal che y jewaꞌ xkibꞌiꞌij chikiwach: —¿Suꞌchak wa kunabꞌal xtzꞌiloꞌxik? ");
INSERT INTO acrNNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Ma ri lik usukꞌ e ta xkꞌayix waꞌ chi ukꞌiyal puaq, y rukꞌ kꞌu riꞌ ketoꞌ ri nibꞌaꞌibꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ekꞌu ri Jesús retaꞌam saꞌ ri kakibꞌiꞌij chikiwach; ruma kꞌu riꞌ, jewaꞌ xubꞌiꞌij chike: —¿Suꞌchak kixchꞌaꞌt chirij ri xuꞌan wiꞌxoq? Ma ri xuꞌan chwe e jun utzilaj chak. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ri nibꞌaꞌibꞌ e laꞌ xaqi e kꞌo iwukꞌ; noꞌj riꞌin na xaqi ta in kꞌo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Yey wa xuꞌan wiꞌxoq echiriꞌ xuqꞌej wa kunabꞌal panuwiꞌ, waꞌ re uyijbꞌaxik pan ri nucuerpo re ri muqubꞌal we. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Paqatzij wi kambꞌiꞌij chiwe: Pa taq katzijox wi wa Utzilaj Tzij che ronoje ruwachulew, kakuxtax kꞌu wiꞌxoq ruma ri xuꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Jun kꞌu chike ri kabꞌlajuj utijoꞌn ri Jesús, Judas aj Iscariot rubꞌiꞌ, xeꞌek kukꞌ ri nimaq e aj chakunel pa Rocho Dios ");
INSERT INTO acrNNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","y jewaꞌ xubꞌiꞌij chike: —¿Saꞌ ri kaya alaq chwe we kanya ri Jesús paqꞌabꞌ alaq? —xchaꞌ. Ekꞌu rike xkibꞌiꞌij kakitoj treinta saqil puaq re plata che. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Chwi kꞌu riꞌ, ri Judas xujeq utzukuxik suꞌanik kuya ri Jesús pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Chupa kꞌu ri nabꞌe qꞌij re ri nimaqꞌij echiriꞌ katij ri pam na jinta levadura che, rutijoꞌn ri Jesús xeqibꞌ rukꞌ y xkitzꞌonoj che: —¿Pa kaꞌaj wi la keꞌqayijbꞌaꞌ wi ri cena re ri nimaqꞌij Pascua? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ri Jesús xubꞌiꞌij kꞌu chike: —Jix pa ri tinamit y chilaꞌ kiꞌriqa jun achi; chibꞌiꞌij kꞌu che: “Ri tijonel qeꞌoj jewaꞌ kubꞌiꞌij: Ri nuqꞌijol riꞌin xa naqaj chi kꞌo wuloq, y chupa ri ocho la kanꞌan wi ri nimaqꞌij Pascua junam kukꞌ ri nutijoꞌn” —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Rutijoꞌn ri Jesús e xkiꞌano jelaꞌ pachaꞌ ri xebꞌutaq Rire che, xeꞌkiyijbꞌaꞌ kꞌu ri cena re ri nimaqꞌij Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Echiriꞌ xok raqꞌabꞌ, ri Jesús xok chwa ri mexa junam kukꞌ ri kabꞌlajuj utijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ekꞌuchiriꞌ kewaꞌik, ri Jesús xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij chiwe: Kꞌo jun chiwe riꞌix kakꞌayin we —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ekꞌuchiriꞌ, rutijoꞌn lik xebꞌuchap bꞌis y xkijeq chikijujunal kakitzꞌonoj che: —Qajawal, ¿kꞌaxtaj in riꞌ? —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ri Jesús xukꞌul uwach: —E ri kumuꞌ lo rupam junam wukꞌ chupa ri laq, e riꞌ ri kakꞌayin we riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Paqatzij wi Ralaxel Chikixoꞌl Tikawex e katajin che rikꞌowibꞌexik janipa ri tzꞌibꞌital kan puwi Rire chupa Ruchꞌaꞌtem ri Dios. Pero ¡lik toqꞌoꞌ uwach rachi kakꞌayin re! E ne más utz che waꞌchi tamaji xalaxik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ekꞌuchiriꞌ, xchꞌaw ri Judas, ri jun kukꞌayij ri Jesús, jewaꞌ xubꞌiꞌij: —Wajawal, ¿kꞌaxtaj in riꞌ? —xchaꞌ. Ri Jesús xukꞌul uwach: —Areꞌ; at xatbꞌiꞌn re —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Xaloqꞌ kꞌu riꞌ kewaꞌik, ri Jesús xukꞌam ri pam y xutioxij che ri Dios. Tekꞌuchiriꞌ xuwechꞌo, xujach chike rutijoꞌn y jekꞌuwaꞌ xubꞌiꞌij: —Chikꞌamaꞌ y chitijaꞌ, ma e nucuerpo waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Tekꞌuchiriꞌ xukꞌam ri kꞌolibꞌal kꞌo vino chupa, xutioxij che ri Dios, xuya chike y jekꞌuwaꞌ xubꞌiꞌij: —Chitija iwonoje chuchiꞌ waꞌ wa kꞌolibꞌal kꞌo vino chupa, ");
INSERT INTO acrNNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ma e nukikꞌel waꞌ, ri katuruw na kuma ukꞌiyal tikawex re kuybꞌal kimak, yey e kujikibꞌaꞌ uwach ri kꞌakꞌ tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Y kambꞌiꞌij kꞌu chiwe: Chwi woꞌora na kantij ta chi ruwaꞌal uva kꞌate kiꞌntija tanchi junam iwukꞌ chupa ruqꞌijol rutaqanik ri Nuqaw —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Echiriꞌ xkikꞌis ubꞌixoxik ri bꞌix, xebꞌek chwa ri juyubꞌ Olivos. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike: —Waqꞌabꞌ iwonoje riꞌix kiwesaj na iwibꞌ chwij, ma e pachaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios: Kankamisaj raj chajinel y taq rubꞌexex kakikich bꞌi kibꞌ kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Noꞌj echiriꞌ kinkꞌastaj lo chikixoꞌl ri ekaminaq, kinnabꞌej bꞌi chiwach kꞌa Galilea —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ekꞌu ri Pedro xukꞌul uwach: —Tobꞌ ne konoje kakesaj kibꞌ chiꞌij la, riꞌin na kanꞌan ta kꞌana waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yey ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij chawe: Wa jun aqꞌabꞌ echiriꞌ kꞌamajaꞌ ne kabꞌixon ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Xubꞌiꞌij kꞌu ri Pedro che: —Tobꞌ ne chirajawaxik kinkam junam ukꞌ la, riꞌin na kanwewaj taj wetaꞌam wach la —xchaꞌ. Jekꞌulaꞌ riꞌ xkibꞌiꞌij konoje rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Tekꞌuchiriꞌ, ri Jesús xebꞌukꞌam bꞌi rutijoꞌn pa jun luwar Getsemaní rubꞌiꞌ, y xubꞌiꞌij kꞌu chike: —Chixtzꞌula kan wara, noꞌj riꞌin kiꞌnꞌana orar chileꞌ apanoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Yey xebꞌukꞌam kꞌu bꞌi ri Pedro y ri kebꞌ ukꞌajol ri Zebedeo rukꞌ. Y xujeq kꞌu riꞌ lik kabꞌisonik y lik kakꞌaxkꞌobꞌ ri ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ekꞌuchiriꞌ, xubꞌiꞌij chike: —Kꞌo jun unimal bꞌis re kamik chinukꞌuꞌx. Chixkꞌola kan wara; mixwarik, e lik chiꞌana orar wukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Tekꞌuchiriꞌ, Rire xqibꞌ chi pan jubꞌiqꞌ chwach, xuxukubꞌaꞌ ribꞌ y xuqasaj umejelem kꞌa chuꞌlew, y xuꞌan kꞌu orar, jewaꞌ xubꞌiꞌij: «Lal Nuqaw, ꞌana ko la riꞌ chinkolobꞌej ko la chaꞌ na kinikꞌow ta chupa waꞌ wa kꞌaxkꞌobꞌik. Noꞌj na e ta kꞌu chuꞌana ri kuaj riꞌin, ma e chuꞌana janipa ri kaꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Tekꞌuchiriꞌ, xtzelej lo pa e kꞌo wi kan rutijoꞌn y xebꞌoꞌluꞌriqaꞌ kewarik. Xubꞌiꞌij kꞌu che ri Pedro: —¿Lik kami na xichꞌij ta kꞌana ri waram chaꞌ kiꞌan orar wukꞌ, tobꞌ tane xa juna ora? ");
INSERT INTO acrNNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Mixwar kꞌut y lik chiꞌana orar chaꞌ kichꞌij uchuqꞌabꞌ ri kꞌambꞌal ipa kapetik. Paqatzij wi, lik kacha ikꞌuꞌx che uꞌanik ri utz, pero waꞌ lik kꞌayew chiwe ma e ri itiꞌjil na jinta ukowil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Xeꞌek tanchi chukalaj, xuꞌana orar, jewaꞌ xubꞌiꞌij: «Lal Nuqaw, we lik chirajawaxik kinikꞌow na che wa kꞌaxkꞌobꞌik, e chuꞌana kꞌu riꞌ janipa ri kaꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Tekꞌuchiriꞌ, xtzelej tanchi lo kukꞌ rutijoꞌn y xebꞌoꞌluꞌriqaꞌ kewarik, ma ri kiwach lik na kukuy ta chi ri waram. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Xebꞌuya tanchi kanoq y xuꞌana orar churox laj, yey e mismo ri xutzꞌonoj che ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ekꞌuchiriꞌ, xeꞌek tanchi pa e kꞌo wi kan rutijoꞌn y xubꞌiꞌij chike: —¿Kꞌa kixwar kami riꞌ riꞌix? ¿Kꞌa kixuxlanik? Ma e waꞌ xopon ruꞌorayil chaꞌ Ralaxel Chikixoꞌl Tikawex kayaꞌ pakiqꞌabꞌ raj makibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","¡Chixwaꞌlijoq! ¡Joꞌ! Ma ri kakꞌayin we riꞌin e laꞌ xkꞌunik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Kꞌa kachꞌaꞌt ne ri Jesús echiriꞌ xkꞌun lo ri Judas, jun chike ri kabꞌlajuj utijoꞌn. Ekꞌu rire erachbꞌilam lo ukꞌiyal winaq kukꞌaꞌam lo espada y cheꞌ. Taq waꞌ etaqom lo kuma ri nimaq e aj chakunel pa Rocho Dios y kuma ri nimaq winaq re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Ekꞌu ri Judas, ri kayaꞌw bꞌi re pakiqꞌabꞌ, ubꞌiꞌim chi lo chike suꞌanik kaketaꞌmaj china ri kakichapo, jewaꞌ ubꞌiꞌim: «E ri jun kantzꞌubꞌ uchiꞌ, e riꞌ rire. Chapa kꞌu bꞌi alaq.» ");
INSERT INTO acrNNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Xqibꞌ kꞌu ri Judas rukꞌ ri Jesús y xuya rutzil uwach, xubꞌiꞌij che: —Wajawal —xchaꞌ. Y xutzꞌubꞌ uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ekꞌu ri Jesús xubꞌiꞌij che: —Wamigo, ¿saꞌ ri kolaꞌanaꞌ? —xchaꞌ. Tekꞌuchiriꞌ, xeqibꞌ ri winaq rukꞌ y xkichapo chaꞌ kakikꞌam bꞌi pa qꞌatbꞌal tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Kꞌo kꞌu jun chike ri e kꞌo rukꞌ ri Jesús, xresaj lo ru espada y xujochij bꞌi jun uxikin ri raj chak ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ekꞌu ri Jesús xubꞌiꞌij che: —Chakꞌolo ra espada chupa rukꞌolibꞌal; ma konoje ri kechꞌoꞌjin rukꞌ espada, rukꞌ espada kekamik. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Na awetaꞌam ta kami, we ta kuaj riꞌin kantzꞌonoj che ri Nuqaw woꞌora, Rire kebꞌutaq lo juna kabꞌlajuj legiones re ángeles wukꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Noꞌj we ta e xinꞌan riꞌ, ¿suꞌanik kꞌu riꞌ kuꞌana janipa ri kubꞌiꞌij Ruchꞌaꞌtem ri Dios panuwi riꞌin? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ekꞌuchiriꞌ, xubꞌiꞌij chike ri soldados: —¿Suꞌchak petinaq alaq rukꞌ espada y cheꞌ? ¿Petinaq kami alaq che ukꞌamik bꞌi juna eleqꞌom? Wa petinaq loq ronoje qꞌij waꞌ kꞌut in tzꞌuyiꞌnaq chiwach alaq, e laꞌ kinkꞌutun pa ri Rocho Dios. ¿Suꞌchak kꞌu riꞌ kꞌa e laꞌ kinoꞌlchapa alaq? ");
INSERT INTO acrNNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Noꞌj jekꞌuwaꞌ kuꞌano chaꞌ e kuꞌana ri kiqꞌalajisam kan ri qꞌalajisanelabꞌ pa Ruchꞌaꞌtem ri Dios —xchaꞌ. Tekꞌuchiriꞌ, konoje rutijoꞌn xebꞌanimajik y jelaꞌ xkiya kan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ri xechapaw bꞌi ri Jesús xkikꞌam bꞌi chwach ri Caifás, ri kajawal raj chakunel pa Rocho Dios, pa kimolom wi kibꞌ raj kꞌutunel re ri tzijpixabꞌ y ri nimaq winaq re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ekꞌu ri Pedro xa naj teran pan chirij ri Jesús, jelaꞌ xeꞌela che ruwa ja re ri rocho ri kajawal raj chakunel pa Rocho Dios. Xok kꞌu bꞌi y xeꞌtzꞌula kukꞌ ri e chajinel chaꞌ karilo saꞌ ri kukꞌisbꞌej ronoje waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ri nimaq e aj chakunel pa Rocho Dios kukꞌ taq ri nimaq winaq y konoje ri uchapom wi ribꞌ ri qꞌatbꞌal tzij, kakitzukuj suꞌanik kakitzꞌaq uchiꞌ ri Jesús chaꞌ jelaꞌ utz kaqꞌat tzij re kamik puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Noꞌj na jinta kꞌo xkiriq chirij, tobꞌ ukꞌiyal winaq xkinukꞌ raqꞌubꞌal chirij. Tekꞌuchiriꞌ, xebꞌopon na kaꞌibꞌ xeꞌkitzꞌaqa uchiꞌ rukꞌ raqꞌubꞌal, ");
INSERT INTO acrNNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","jewaꞌ xkibꞌiꞌij: —Waꞌ waꞌchi jewaꞌ xubꞌiꞌij: “Riꞌin kꞌo panuqꞌabꞌ kanwulij ri Rocho Dios y xa pa oxibꞌ qꞌij kanyak tanchik” —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ewi ri kajawal raj chakunel pa Rocho Dios xyaktajik y xubꞌiꞌij che ri Jesús: —¿E kami laꞌ na jinta kꞌana kabꞌiꞌij riꞌat? ¿Saꞌ kꞌu ri kakꞌulubꞌej uwach puwi wa ketajin che ukojik chawij? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Noꞌj ri Jesús na jinta kꞌo xubꞌiꞌij. Ekꞌuchiriꞌ, jewaꞌ xubꞌiꞌij ri kajawal raj chakunel pa Rocho Dios: —Chabꞌiꞌij chupa rubꞌiꞌ ri Dios kꞌaslik, we riꞌat at ri Cristo, Rukꞌajol ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ri Jesús xubꞌiꞌij che: —Areꞌ, e ri xbꞌiꞌij la. Y kambꞌiꞌij kꞌu che onoje alaq: Kil na kꞌu alaq Ralaxel Chikixoꞌl Tikawex tzꞌul puwikiqꞌabꞌ ri Dios, ri lik kꞌo unimal uchuqꞌabꞌ yey kil kꞌu alaq riꞌ echiriꞌ kakꞌun lo pa sutzꞌ chwa ri kaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ekꞌu ri kajawal raj chakunel pa Rocho Dios xurichꞌij ruqꞌuꞌ y xubꞌiꞌij: —Waꞌ waꞌchi lik xmakun chirij ri Dios rukꞌ wa xubꞌiꞌij. ¡Na jinta chi uchak más e aj kojol umak! Ma lik e laꞌ xta alaq xubꞌiꞌij ri na taqal ta che. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Saꞌ kꞌu riꞌ kabꞌiꞌij ralaq che? —xchaꞌ. Rike xkibꞌiꞌij: —Lik chirij umak y taqal kꞌu che kakamisaxik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ewi e kꞌo jujun xkijeq kakichubꞌaj rupalaj y lik kakiꞌan pa tꞌoꞌy. E kꞌo jujun chik xkipachꞌ qꞌabꞌ chupalaj ");
INSERT INTO acrNNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","y kakibꞌiꞌij che: —At ri Cristo, Ruchaꞌoꞌn lo ri Dios, ¡chanaꞌij pe kꞌu riꞌ china xchꞌayaw awe! —kecha che. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ekꞌu ri Pedro tzꞌul che ruwa ja echiriꞌ jun ali aj chak xqibꞌ rukꞌ y xubꞌiꞌij che: —Rilal lal jun chike ri eteran chirij ri Jesús, ri jun aj Galilea —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Noꞌj ri Pedro xrewaj chikiwach konoje, jewaꞌ xubꞌiꞌij: —Riꞌin na wetaꞌam tane saꞌ puwiꞌ katchꞌaꞌt wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ekꞌu riꞌ kel bꞌi ri Pedro chuchiꞌ ri puerta yey xilitaj ruma jun chik ali aj chak, y waꞌli jewaꞌ xubꞌiꞌij chike ri e kꞌo chiriꞌ: —Waꞌ wa jun achi e jun chike ri eteran chirij ri Jesús ri aj Nazaret —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ri Pedro xrewaj tanchik y lik xujikibꞌaꞌ uwach ubꞌiꞌxikil: —Riꞌin na wetaꞌam ta kꞌana uwach laꞌ laꞌchi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Joqꞌotaj kꞌu riꞌ, ri e kꞌo chiriꞌ xeqibꞌ rukꞌ ri Pedro y xkibꞌiꞌij che: —Paqatzij wi rilal lal jun chike rutijoꞌn; ma lik qꞌalaj, ri kachꞌaꞌt la e junam rukꞌ ri kechꞌaꞌt rike —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ekꞌu ri Pedro xujeq ubꞌiꞌxikil itzel taq tzij y lik xujikibꞌaꞌ uwach, xubꞌiꞌij: —Riꞌin na wetaꞌam ta kꞌana uwach laꞌ laꞌchi —xchaꞌ. Xew xukꞌis ubꞌiꞌxikil waꞌ, xbꞌixon lo ri teren. ");
INSERT INTO acrNNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ekꞌuchiriꞌ, xkꞌun lo chukꞌuꞌx ri Pedro ri xbꞌiꞌx lo che ruma ri Jesús: «Kꞌamajaꞌ ne kabꞌixon ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach.» Ewi xel bꞌi ri Pedro chiriꞌ y lik xoqꞌik ruma rukꞌaxkꞌolil ukꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Echiriꞌ xsaqirik, konoje ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri nimaq winaq re ri tinamit, xkiꞌan tzij chikiwach puwi ri kakiꞌano chaꞌ kaqꞌat tzij re kamik puwi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Yutum kꞌu ri Jesús, xkikꞌam bꞌi y xeꞌkiyaꞌa chwach ri taqanel Poncio Pilato. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Ri Judas ri xkꞌayin re ri Jesús, echiriꞌ xrilo xqꞌat tzij re kamik puwi ri Jesús, lik xok chukꞌuꞌx ri xuꞌano. Xeꞌek kꞌut y xutzelej ri treinta saqil puaq chike ri nimaq e aj chakunel pa Rocho Dios y chike ri nimaq winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xubꞌiꞌij kꞌu chike: —Riꞌin lik in makuninaq, ma xinkꞌayij pa kamik jun achi na jinta umak —xchaꞌ. Pero rike xkibꞌiꞌij che: —Na jinta qe riꞌoj che laꞌ; laꞌ amak riꞌat —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ekꞌuchiriꞌ, ri Judas xuꞌkꞌaqa kan ri puaq pa ri Rocho Dios y xeꞌek kꞌut xuꞌjitzꞌaj ribꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ri nimaq e aj chakunel pa ri Rocho Dios xeꞌkimolo ri puaq y xkibꞌiꞌij: «Waꞌ wa puaq na ubꞌe ta kꞌenoq kaqaya pa ri kaxa re qasaꞌn, ma waꞌ rajil ukikꞌel jun achi» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Tekꞌuchiriꞌ, xkiꞌan tzij chikiwach chaꞌ rukꞌ waꞌ wa puaq kakiloqꞌ juchꞌaqap ulew rubꞌiꞌ “Luwar re ri aj tzꞌaqal xoqꞌoꞌl”, chaꞌ kuꞌana jun luwar re muqubꞌal ke ri na e ta aj Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ruma kꞌu laꞌ, la jun ulew kꞌa e ubꞌiꞌ waqꞌij ora “Luwar re kikꞌ”. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Ekꞌu xuꞌan pachaꞌ ri tzꞌibꞌital kan ruma ri qꞌalajisanel Jeremías pa Ruchꞌaꞌtem ri Dios, pa kubꞌiꞌij wi: Xkikꞌam kꞌu ri treinta saqil puaq, ma e rajil riꞌ kojotal kuma raj Israel. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Y rukꞌ kꞌu wa puaq, xkiloqꞌ ri jun luwar rubꞌiꞌ “Luwar re ri aj tzꞌaqal xoqꞌoꞌl”, jelaꞌ pachaꞌ ri ubꞌiꞌim lo ri Dios chwe. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ekꞌuchiriꞌ xkꞌam bꞌi ri Jesús chwach ri taqanel Pilato, rire xutzꞌonoj che ri Jesús: —¿Lal kami riꞌ ri rey ke raj judiꞌabꞌ? —xchaꞌ. Ri Jesús xubꞌiꞌij che: —Lal kabꞌiꞌn la re —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Yey echiriꞌ ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri nimaq winaq re Israel xkitzꞌaq uchiꞌ ri Jesús, Rire na xukꞌul ta kꞌana uwach ri kakibꞌiꞌij rike. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ruma kꞌu riꞌ, ri Pilato xutzꞌonoj che ri Jesús: —¿Na kata ta kami la janipa ri kakibꞌiꞌij chiꞌij la? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Pero ri Jesús na xukꞌul ta kꞌana uwach; ruma kꞌu riꞌ, ri taqanel lik xkam ranimaꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Chupa kꞌu ri nimaqꞌij Pascua, ri taqanel romano xex kuꞌan wi kuyolopij bꞌi jun chike ri e kꞌo pa cárcel, yey e ri winaq kechaꞌwik china ri kakaj kayolopix bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Kꞌo kꞌu jun achi pa cárcel lik etaꞌmatal uwach, Barrabás rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Ekꞌuchiriꞌ ri winaq kimolom chi kibꞌ, ri Pilato xutzꞌonoj chike: —¿China ri kiwaj riꞌix kanyolopij bꞌi, e ri Barrabás o e ri Jesús, ri kabꞌiꞌx che “e ri Cristo”, Ruchaꞌoꞌn lo ri Dios? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Xutzꞌonoj kꞌu waꞌ ma retaꞌam e kꞌo jujun kꞌax kikꞌuꞌx chirij ri Jesús, y xa ruma kꞌu riꞌ kiyaꞌom ri Jesús chwach. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ekꞌuchiriꞌ tzꞌul ri Pilato pa ri qꞌatbꞌal tzij, ri rixoqil xutaq ubꞌiꞌxikil che: «Makꞌo maꞌan la che wa jun achi jusukꞌ ubꞌinik usilabꞌik, ma waqꞌij lik kabꞌison nukꞌuꞌx ruma xinꞌan jun wachikꞌ puwi rire yey lik xibꞌibꞌal uwach ri xinwachikꞌaj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Noꞌj ri nimaq e aj chakunel pa Rocho Dios kukꞌ taq ri nimaq winaq re Israel xkikoj pa kijolom ri ukꞌiyal winaq chaꞌ e kakitzꞌonoj kayolopix bꞌi ri Barrabás yey e kakamisax ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ri taqanel xchꞌaꞌt tanchi kukꞌ ri winaq, jewaꞌ xutzꞌonoj chike: —¿China chike wa kaꞌibꞌ kiwaj kanyolopij bꞌi? —xchaꞌ. Rike xkibꞌiꞌij: —E yolopij bꞌi la ri Barrabás —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Tekꞌuchiriꞌ, xutzꞌonoj ri Pilato chike: —¿Yey saꞌ kꞌu riꞌ kanꞌan che ri Jesús, ri kabꞌiꞌx che “e ri Cristo”, Ruchaꞌoꞌn lo ri Dios? —xchaꞌ. Konoje xkikꞌul uwach: —¡Kamisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ekꞌu riꞌ ri Pilato xubꞌiꞌij chike: —¿Saꞌ kꞌu rumak uꞌanom? —xchaꞌ. Pero ri winaq más ko xesikꞌinik: —¡Kamisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Ri Pilato xrilo na jinta kutiqoj kuꞌan más tzꞌonobꞌal chike ma más ne ketukuk ri winaq; ruma kꞌu riꞌ, xutaq ukꞌamik yaꞌ y ekꞌu laꞌ chikiwach ri winaq xuchꞌaj ruqꞌabꞌ, y jewaꞌ xubꞌiꞌij: —Na jinta kꞌu numak riꞌin che rukamik waꞌchi jusukꞌ rubꞌinik, ma waꞌ imak riꞌix —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Konoje kꞌu ri winaq xkikꞌul uwach, jewaꞌ xkibꞌiꞌij: —Riꞌoj kukꞌ ri qalkꞌoꞌal kaqaya qibꞌ chuxeꞌ rukamik rire —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ewi ri Pilato xuyolopij bꞌi ri Barrabás. Tekꞌuchiriꞌ, xtaqan che kajichꞌ upa ri Jesús y xuya pakiqꞌabꞌ ri soldados chaꞌ kakikamisaj chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ekꞌuchiriꞌ, ri soldados re ri taqanel xkikꞌam bꞌi ri Jesús pa ri palacio y xkimol kꞌu kichiꞌ konoje ri soldados chaꞌ kakisut rij. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xkesaj kꞌu bꞌi ruqꞌuꞌ y xkirip jun manta chirij yey waꞌ kaqkoj katzuꞌnik. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Che rujolom xkikoj jun corona pachꞌum rukꞌ kꞌiix y xkiya jukutaj tani pa ruqꞌabꞌ uwikiqꞌabꞌ. Tekꞌuchiriꞌ, xexukiꞌ chwach y xkijeq uchꞌamixik, jewaꞌ kakibꞌiꞌij che: —¡Nim uqꞌij ri rey ke raj judiꞌabꞌ! —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yey xkichubꞌaj rupalaj, xkimaj kꞌu ri jukutaj tani puqꞌabꞌ y rukꞌ laꞌ xkichꞌay rujolom. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Echiriꞌ xkitanabꞌaꞌ uchꞌamixik, xkesaj ri manta kiripom chirij y xkikoj tanchi ruqꞌuꞌ. Tekꞌuchiriꞌ, xkikꞌam bꞌi re keꞌkikamisaj chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Echiriꞌ katajin kelik bꞌi, xkikꞌul jun achi aj Cirene, Simón rubꞌiꞌ, y xkitaq che kutelej bꞌi ri cruz re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Ekꞌuchiriꞌ, xebꞌopon pa ri luwar Gólgota rubꞌiꞌ, waꞌ keꞌelawi “luwar re ubꞌaqil ujolom animaꞌ”. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Xkiya kꞌu che ri Jesús vinagre yijbꞌam rukꞌ aqꞌes lik kꞌa; pero Rire echiriꞌ xunaꞌ waꞌ, na xraj taj xutijo. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Echiriꞌ kiyaꞌom chi ri Jesús chwa ri cruz, ri soldados rukꞌ jun sorteo xkijach kibꞌ puwi ruqꞌuꞌ. Jekꞌulaꞌ e xuꞌana pachaꞌ rubꞌiꞌim lo ri qꞌalajisanel chupa Ruchꞌaꞌtem ri Dios: Xkijach kibꞌ puwi ri nuqꞌuꞌ, ma xkiꞌan sorteo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Tekꞌuchiriꞌ, xetzꞌuyiꞌ chiriꞌ chaꞌ kakichajij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Chwi kꞌu lo rucruz ri Jesús tzꞌibꞌitalik suꞌbꞌe xqꞌat tzij puwiꞌ, jewaꞌ kubꞌiꞌij: «E JESÚS WAꞌ, RI REY KE RAJ JUDIꞌABꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xekiya kꞌu kaꞌibꞌ eleqꞌomabꞌ chwa cruz, jun puwikiqꞌabꞌ y jun pumox ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ekꞌu ri winaq kebꞌikꞌow chiriꞌ kakiyoqꞌ kanoq, kakiyiriyaꞌ ri kijolom che, ");
INSERT INTO acrNNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","y jewaꞌ kakibꞌiꞌij: —At peꞌ ri abꞌiꞌim kawulij ri Rocho Dios y xa pa oxibꞌ qꞌij kayak tanchik; chakolobꞌej kꞌu awibꞌ riꞌ. We paqatzij wi at Ukꞌajol ri Dios, chatqaj lo chwa ri cruz —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Jenelaꞌ riꞌ xkiꞌan ri nimaq e aj chakunel pa Rocho Dios junam kukꞌ raj kꞌutunel re ri tzijpixabꞌ, ri fariseos y ri nimaq winaq re ri tinamit; lik xkichꞌamij, jewaꞌ xkibꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Lik waꞌ kꞌut e kꞌi ri xebꞌukolobꞌej che taq yabꞌil y che kamik, yey na kuriq ta waꞌ kꞌu ukolobꞌexik ribꞌ rire. We ta paqatzij wi e Rey re ri qatinamit Israel, qaja lo riꞌ utukel chwa ri cruz chaꞌ jelaꞌ kaqakojo e rire ri Uchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ma lik waꞌ kꞌut xkubꞌiꞌ ukꞌuꞌx rukꞌ ri Dios. Yey we ta ri Dios lik kꞌax kunaꞌo, chukolobꞌej riꞌ woꞌora, ma rire ubꞌiꞌim e Ukꞌajol ri Dios —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jenelaꞌ riꞌ xkibꞌiꞌij releqꞌomabꞌ eyaꞌom chwa cruz pa taq utzal, lik xkichꞌamij. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Echiriꞌ xtikꞌoj ri qꞌij, xok qꞌequꞌm che ruwachulew y waꞌ xuꞌkꞌisa kꞌa che ri urox ora bꞌenaq qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Chupa kꞌu laꞌ laꞌ ora, ri Jesús lik ko xsikꞌinik, jewaꞌ xubꞌiꞌij pa ri chꞌaꞌtem kachꞌaꞌt wi Rire: —Elí, Elí, ¿lama sabactani? —xchaꞌ. Waꞌ keꞌelawi: “Lal nu Dios, Lal nu Dios, ¿suꞌbꞌe xinoqꞌotaj kan la?” ");
INSERT INTO acrNNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jujun kꞌu chike ri e kꞌo chiriꞌ, echiriꞌ xkita waꞌ, xkibꞌiꞌij: —Waꞌ waꞌchi e kusikꞌij ri qꞌalajisanel Elías —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Y na jampatana, kꞌo jun chike rike lik kanik xeꞌek, xuꞌkꞌama lo jun esponja y xumuꞌ pa vinagre. Xuxim kꞌu chutzaꞌm jun tani y xuya pan che ri Jesús re kutzꞌubꞌu. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ekꞌu ri jujun chik xkibꞌiꞌij che: —Maya che, qila peꞌ we kakꞌun ri Elías re koluꞌkolobꞌej —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Tekꞌuchiriꞌ, ri Jesús lik ko xsikꞌin tanchik y xuqꞌatisaj kꞌu ri ranimaꞌ puqꞌabꞌ ri Dios, asu xkamik. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ekꞌu laꞌ la joqꞌotaj ri telón kꞌo chupa ri Rocho Dios xrichꞌrobꞌ chunikꞌajal; xujeq lo puwiꞌ y xoꞌlkꞌis kꞌa chuxeꞌ. Rulew lik xbꞌarbꞌatik y ri nimaq taq abꞌaj xejaqajobꞌ upa. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Y xejaqataj taq ri muqubꞌal yey ukꞌiyal tikawex re rutinamit ri Dios ekaminaq chik, xekꞌastaj loq ");
INSERT INTO acrNNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","y xebꞌel lo chupa taq ri muqubꞌal. Ekꞌuchiriꞌ kꞌastajinaq chubꞌi ri Jesús, rike xebꞌok pa ri santowilaj tinamit yey chilaꞌ xebꞌilitaj kuma ukꞌiyal winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Ekꞌu ri capitán y ri soldados echajiyom re ri Jesús, echiriꞌ xkil ri kabꞌraqan y ronoje taq ri xuꞌano, lik xkixiꞌij kibꞌ y jewaꞌ xkibꞌiꞌij: —¡Paqatzij wi, waꞌ waꞌchi e Ukꞌajol ri Dios! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","E kꞌo kꞌu ukꞌiyal ixoqibꞌ chiriꞌ kakitzutzaꞌ pana chinimanaj; waꞌ e taq ri e petinaq rukꞌ ri Jesús chwi xel lo Galilea y lik kinimam loq. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chikixoꞌl waꞌ wiꞌxoqibꞌ kꞌo ri María ri aj Magdala, kꞌo ri María ri kichu ri Jacobo y ri José, yey kꞌo ri kichu ri kebꞌ ukꞌajol ri Zebedeo. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kꞌo jun achi aj Arimatea, José rubꞌiꞌ; rire bꞌeyom y e jun chike rutijoꞌn ri Jesús. Bꞌenaq qꞌij rire ");
INSERT INTO acrNNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","xeꞌek kꞌu rukꞌ ri Pilato re kuꞌtzꞌonoj rucuerpo ri Jesús. Ekꞌu ri Pilato xtaqan che kayaꞌiꞌ lo rucuerpo ri Jesús che rire. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ri José xukꞌam kꞌu bꞌi rucuerpo ri Jesús, xupis bꞌi pa jun manta lik saq ");
INSERT INTO acrNNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","y xuꞌyaꞌa pa jun muqubꞌal re rire, waꞌ kꞌakꞌ kꞌotom paꞌbꞌaj. Xutaq kꞌu uketebꞌaxik kan jun nimalaj abꞌaj chuchiꞌ re tzꞌapibꞌal re; tekꞌuchiriꞌ, xeꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","E kꞌo kꞌu chiriꞌ ri María ri aj Magdala y ri jun chik María, etzꞌul chwach ri muqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Ikꞌowinaq chi kꞌu ri qꞌij echiriꞌ raj judiꞌabꞌ kakiyijbꞌaꞌ pan janipa ri kajawax chike pa ri qꞌij re uxlanibꞌal. Ekꞌuchiriꞌ, ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri fariseos xkimol kibꞌ rukꞌ ri Pilato ");
INSERT INTO acrNNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","y xkibꞌiꞌij che: —Qajawal, xkꞌun chiqakꞌuꞌx, laꞌ la jun achi sokosoꞌnel echiriꞌ kꞌa kꞌaslik jewaꞌ xubꞌiꞌij: “Purox qꞌij kinkꞌastaj lo chikixoꞌl ri ekaminaq.” ");
INSERT INTO acrNNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E uwariꞌche, taqa la uchajixik chi utz ri muqubꞌal kꞌa che rurox qꞌij, chaꞌ na kekꞌun ta rutijoꞌn chaqꞌabꞌ, koꞌlkelaqꞌaj bꞌi rucuerpo y tekꞌuchiriꞌ, kakibꞌiꞌij chike ri winaq: “Xkꞌastaj lo chikixoꞌl ri ekaminaq.” We ekꞌu xuꞌan riꞌ, kuꞌana ne más unimal raqꞌubꞌal riꞌ chwa ri nabꞌe uꞌanom loq echiriꞌ xubꞌiꞌij e Ruchaꞌoꞌn lo ri Dios —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ri Pilato xubꞌiꞌij chike: —Chekꞌama bꞌi alaq waꞌ wa e chajinel y jeꞌtzꞌapij alaq chi utz ri muqubꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Xebꞌek kꞌut, xeꞌkitzꞌapij uchiꞌ ri muqubꞌal chi utz, xkikoj jun sello puwi ri nimalaj abꞌaj tzꞌapibꞌal uchiꞌ y xekiya kꞌu kan ri e chajinel chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ikꞌowinaq chi ri qꞌij re uxlanibꞌal, e riꞌ katajin usaqirik ri nabꞌe qꞌij che ri semana, ri María ri aj Magdala y ri jun chik María xeꞌkila ri muqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Xaqikꞌateꞌt xpe jun nimalaj kabꞌraqan, yey waꞌ e xꞌanaw jun ángel re ri Dios xqaj lo chikaj. Echiriꞌ xopon chwach ri muqubꞌal, xresaj rabꞌaj utzꞌapim uchiꞌ ri muqubꞌal y xtzꞌuyiꞌ kꞌu puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ri ángel lik kawolqꞌinik, katzuꞌn jelaꞌ pachaꞌ ruxeꞌ kaj echiriꞌ kayokꞌ kaꞌnik; yey ruqꞌuꞌ lik saq pachaꞌ ri nieve. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ri soldados echiriꞌ xkil ri ángel, lik xkixiꞌij kibꞌ che; xkijeq kebꞌirbꞌotik y xekanaj kanoq pachaꞌ chi ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ekꞌuchiriꞌ, xubꞌiꞌij ri ángel chike rixoqibꞌ: —Mixiꞌij iwibꞌ. Ma riꞌin wetaꞌam e kitzukuj ri Jesús, ri xkamisax chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Rire na jinta chi wara, ma kꞌastajinaq chubꞌi jelaꞌ pachaꞌ rubꞌiꞌim chi uloq. Choꞌliwilape wa luwar pa xyaꞌiꞌ wi ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Jix kꞌu riꞌix, lik chiwilij bꞌi y jiꞌbꞌiꞌij chike rutijoꞌn: “Ri Jesús xkꞌastaj bꞌi chikixoꞌl ri ekaminaq. Chiwilapeꞌ, Rire keꞌek Galilea, kanabꞌej bꞌi chiwach; chilaꞌ kꞌu riꞌ kiꞌwila wi uwach.” Ekꞌu xoꞌlnubꞌiꞌij waꞌ chiwe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Echiriꞌ rixoqibꞌ xebꞌel bꞌi chuchiꞌ ri muqubꞌal, lik kixiꞌim kibꞌ pero kꞌo unimal kiꞌkotemal kukꞌ. Kebꞌan kꞌu riꞌ xebꞌek chaꞌ keꞌkibꞌiꞌij chike rutijoꞌn janipa ri xkilo y ri xbꞌiꞌx bꞌi chike. E kꞌo kꞌu chi bꞌe ");
INSERT INTO acrNNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","echiriꞌ ri Jesús xebꞌukꞌulu y xuya rutzil kiwach. Ekꞌu rike xeqibꞌ rukꞌ y xkixuk kibꞌ chwach; xkilaqꞌapuj ri raqan y xkiloqꞌnimaj uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ri Jesús xubꞌiꞌij kꞌu chike: —Mixiꞌij iwibꞌ. Jix, jiꞌbꞌiꞌij chike ri nu hermanos chaꞌ kebꞌek chilaꞌ Galilea y chiriꞌ kakil wi nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ekꞌuchiriꞌ e kꞌo pan rixoqibꞌ pa bꞌe, jujun chike ri e chajinel xebꞌek pa ri tinamit y xeꞌkitzijoj chike ri nimaq e aj chakunel pa Rocho Dios ronoje ri xkikꞌulumaj. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Ekꞌu ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri nimaq winaq re ri tinamit, xkichꞌaꞌbꞌej kibꞌ chaꞌ kakiꞌan tzij chikiwach. Xkiya kꞌu ukꞌiyal puaq chike ri soldados ");
INSERT INTO acrNNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y xekitaq che jewaꞌ kakibꞌiꞌij: «Echiriꞌ okinaq lo qawaram chaqꞌabꞌ, xekꞌun rutijoꞌn ri Jesús y xkelaqꞌaj bꞌi rucuerpo. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Yey we xretaꞌmaj waꞌ ri taqanel, riꞌoj kaqakoj pujolom chaꞌ na jinta kꞌo kuꞌan chiwe» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ri soldados xkikꞌam kꞌu ri puaq y e xkiꞌano janipa ri xbꞌiꞌx chike. Ekꞌu raj judiꞌabꞌ kꞌa e ubꞌiꞌxikil waꞌ kakiꞌan waqꞌij ora. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","E taq kꞌu ri junlajuj utijoꞌn xebꞌek Galilea chwa ri jun juyubꞌ pa ubꞌiꞌim wi ri Jesús chike. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Echiriꞌ xkil uwach ri Jesús, lik xkiloqꞌnimaj uqꞌij, tobꞌ kꞌu e kꞌo jujun chike kꞌamajaꞌ kakikojo we paqatzij wi ri Jesús xkꞌastaj lo chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ekꞌuchiriꞌ, xqibꞌ ri Jesús kukꞌ y xubꞌiꞌij chike: —Riꞌin yaꞌtal lo panuqꞌabꞌ ronoje ri taqanik chilaꞌ chikaj y che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Ruma kꞌu waꞌ, jix kukꞌ konoje rukꞌiyal kiwach taq ri tinamit che ruwachulew, chiꞌana kꞌu e nutijoꞌn chike y chiyaꞌa ri bautismo chike pa rubꞌiꞌ ri Qaqaw Dios, Rukꞌajol y ri Santowilaj Ruxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chikꞌutu chikiwach rike chaꞌ e kakiꞌan ronoje janipa ri ixnutaqom riꞌin che. Lik chiwetaꞌmaj kꞌut: Riꞌin kinkꞌojiꞌ iwukꞌ ronoje qꞌij kꞌa che ri kꞌisbꞌal re ruwachulew —xchaꞌ. Amén. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Waꞌ e jeqebꞌal re ri Utzilaj Tzij re ri Qanimajawal Jesucristo, Rukꞌajol ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","E xuꞌana pachaꞌ ri tzꞌibꞌital kan ruma ri qꞌalajisanel Isaías puwi ri ubꞌiꞌim lo ri Dios: Riꞌin kannabꞌesaj bꞌi chawach riꞌat, ri waj chak aj tzijol weꞌin, chaꞌ kuyijbꞌaꞌ ri bꞌe chwach pan rawoponibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Katataj uqul jun tzijonel kasikꞌin chupa ri luwar katzꞌintzꞌotik, jewaꞌ kubꞌiꞌij: “Yijbꞌaꞌ pana alaq ri bꞌe re ri Qanimajawal; sukꞌupij alaq rubꞌe Rire” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ri Juan katajin che uyaꞌik ri bautismo pa jun luwar katzꞌintzꞌotik. E kubꞌiꞌij chike ri winaq kakitzelej kitzij chwach ri Dios, kakikꞌul ri bautismo, y jekꞌulaꞌ kakuytaj ri kimak. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Ewi konoje ri tikawex e kꞌo pa taq ri luwar re Judea y konoje ri e kꞌo Jerusalem, xebꞌel lo che utayik ri Juan. Kakitzꞌonoj kꞌu kuybꞌal kimak chwach ri Dios, yey ri Juan kuya ri bautismo chike chupa ri nimayaꞌ Jordán. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ekꞌu ruqꞌuꞌ ri Juan ꞌanom rukꞌ rismal camello, y rupas ximil che rupa e jun tzꞌuꞌum. Yey ri kutijo e ri sakꞌ y uwaꞌal kabꞌ re upa taq juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Jekꞌuwaꞌ ri tzijonik kuꞌano: «Kꞌo Jun katajin lo chwij más nim ruchuqꞌabꞌ chinuwa riꞌin, ma na taqal tane chwe kinyuxiꞌik re kankir ruwach ruxajabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Paqatzij wi, riꞌin xinya ri bautismo che alaq rukꞌ yaꞌ; noꞌj ri bautismo kuya Rire che alaq, e rukꞌ ri Santowilaj Ruxlabꞌixel ri Dios» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Chupa taq kꞌu laꞌ la qꞌij, ri Jesús xel lo Nazaret, (waꞌ e jun tinamit re Galilea), y xꞌan kꞌu bautizar ruma ri Juan chupa ri nimayaꞌ Jordán. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Na jampatana xel lo ri Jesús pa ri yaꞌ, xrilo echiriꞌ xjaqataj ruwa kaj y ri Ruxlabꞌixel ri Dios pachaꞌ juna palomax xqaj lo puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Y xchꞌaw lo Jun chilaꞌ chikaj, jewaꞌ kubꞌiꞌij: «At riꞌat Nukꞌajol y lik kꞌax katinnaꞌo. Lik kinkiꞌkot chawe» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Tekꞌuchiriꞌ, ri Jesús xkꞌam bꞌi ruma ri Ruxlabꞌixel ri Dios pa jun luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ri Jesús xkꞌojiꞌ chilaꞌ cuarenta qꞌij chikixoꞌl itzel taq awaj. Yey chupa taq laꞌ la qꞌij, lik xkꞌam upa ruma ri Satanás. Ikꞌowinaq chi kꞌu waꞌ, ri ángeles xkijeq kakinimaj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Echiriꞌ yaꞌom chi ri Juan pa cárcel, ri Jesús xeꞌek Galilea che utzijoxik ri Utzilaj Tzij re rutaqanik ri Dios, ");
INSERT INTO acrNNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","jewaꞌ kubꞌiꞌij: «Xopon kꞌu ruqꞌijol echiriꞌ rutaqanik ri Dios xa naqaj chi kꞌo lo wi; tzelej kꞌu tzij alaq chwach ri Dios y kojo alaq ri Utzilaj Tzij» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Echiriꞌ kabꞌin ri Jesús chuchiꞌ ri mar re Galilea, xeril pan ri Simón rukꞌ ruchaqꞌ Andrés, e riꞌ kakikꞌaq ri ki atarraya chupa ri yaꞌ, ma rike e aj chapal kar. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ekꞌu ri Jesús xubꞌiꞌij chike: —Chixpetoq, chixterej lo chwij y riꞌin kanꞌan chiwe ix aj molol tikawex jelaꞌ pachaꞌ iꞌanom lo chike ri kar —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Rike xkiya kan ri ki atarraya y xeterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xbꞌin kꞌu pan jubꞌiqꞌ chik y xeril ri Jacobo rukꞌ ruchaqꞌ Juan, ri kebꞌ ukꞌajol ri Zebedeo. Rike e kꞌo chupa jun barco y ketajin che ukꞌojoxik ri ki atarraya. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ekꞌu ri Jesús xebꞌusikꞌij; ruma kꞌu riꞌ, rike xkiya kan ri kiqaw Zebedeo kukꞌ ri kimokom chupa ri barco y xeterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xebꞌok kꞌu pa ri tinamit Capernaúm. Y chupa ri qꞌij re uxlanibꞌal ri Jesús xok pa ri sinagoga y xujeq kakꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Y ri xetaw re lik xkam kanimaꞌ che, ma ruma rukꞌutunik kaqꞌalajinik lik kꞌo uwach, na pachaꞌ ta ri kakiꞌan raj kꞌutunel re ri tzijpixabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chupa kꞌu ri sinagoga kꞌo jun achi kꞌo puqꞌabꞌ jun itzelilaj uxlabꞌixel. Waꞌ xujeq kasikꞌinik, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Lal Jesús, aj Nazaret, ¿suꞌchak koꞌlmina ibꞌ la qukꞌ? ¿E laꞌ lal petinaq re koꞌlsacha la qawach? Riꞌin wetaꞌam lal chinoq, lal ri Santo Kꞌajolaxel re ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ekꞌu ri Jesús xuqꞌatej ri itzel uxlabꞌixel, jewaꞌ xubꞌiꞌij che: —¡Matchꞌaꞌt chik! Chatelubꞌi che laꞌchi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ri itzelilaj uxlabꞌixel xukꞌaq laꞌchi pulew y lik ko xujabꞌajaꞌ; yey kasikꞌinik xel bꞌi che laꞌchi. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Konoje kꞌu ri tikawex lik xkam kanimaꞌ che y kakitzꞌonobꞌej taq chikiwach: «¿Saꞌ waꞌ? ¿Saꞌ chi kꞌakꞌ kꞌutunik waꞌ? Ma kꞌo ne puqꞌabꞌ kataqan pakiwi itzelilaj uxlabꞌixel y waꞌ kakikoj utzij» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y na jampatana, pa taq ronoje ri luwar re Galilea xeꞌek utzijoxik janipa taq ri kuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Echiriꞌ ri Jesús kukꞌ ri Jacobo y ri Juan xebꞌel bꞌi chupa ri sinagoga, xebꞌek chirocho ri Simón y ri Andrés. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ekꞌu ruchu-ujiꞌ ri Simón kꞌo chwa uwarabꞌal, kꞌo aqꞌ chirij. Xkitzijoj kꞌu riꞌ waꞌ che ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ewi ri Jesús xqibꞌ rukꞌ la yewaꞌ, xuchap ruqꞌabꞌ y xutoꞌo chaꞌ kayaktajik. Na jampatana kꞌu riꞌ xikꞌow ri aqꞌ chirij rixoq y xujeqo kebꞌunimaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Echiriꞌ bꞌenaq chi ri qꞌij e riꞌ kayubꞌubꞌ chik, xekꞌam lo chwach ri Jesús konoje ri yewaꞌibꞌ y ri e kꞌo pakiqꞌabꞌ itzel uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Y konoje ri tikawex re ri tinamit xetꞌiqiꞌ chuchiꞌ ri puerta re ri ja. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ekꞌu ri Jesús xebꞌukunaj ukꞌiyal yewaꞌibꞌ che ukꞌiyal uwach taq yabꞌil y xebꞌeresaj bꞌi ukꞌiyal itzel uxlabꞌixel; pero na xuya ta luwar chike kechꞌawik ma rike ketaꞌam china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Lik anim tan echiriꞌ lik kꞌa qꞌequꞌm, xwaꞌlij bꞌi ri Jesús, xel kꞌu bꞌi chupa ri tinamit y xeꞌek pa jun luwar katzꞌintzꞌotik chaꞌ kuꞌana orar. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ekꞌu ri Simón kukꞌ ri rachbꞌiꞌil xebꞌek che utzukuxik. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Echiriꞌ xkiriqo, xkibꞌiꞌij che: —Konoje ri winaq kakitzukuj la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ekꞌu Rire xubꞌiꞌij chike: —Joꞌ che utzijoxik ri Utzilaj Tzij pa taq ri luwar e kꞌo lo xa naqaj, ma e nuwach riꞌ in petinaq Riꞌin —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Xebꞌek kꞌu riꞌ, y ri Jesús katzijon chupa taq ri sinagogas che taq ronoje ri luwar re Galilea yey kebꞌeresaj kꞌu bꞌi itzel uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xopon kꞌu rukꞌ ri Jesús jun achi kꞌo ri yabꞌil lepra che y xuxukubꞌaꞌ ribꞌ chwach. Lik xelaj kꞌu che, jewaꞌ xubꞌiꞌij: —We kaꞌaj ko la, josqꞌij la ri nucuerpo che wa yabꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ekꞌu ri Jesús xjuchꞌ kaꞌn ukꞌuꞌx che rachi yewaꞌ. Xuchap pana rukꞌ ruqꞌabꞌ y jekꞌuwaꞌ xubꞌiꞌij che: —Kuaj, chuꞌana bꞌa chom riꞌ racuerpo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Xew kꞌu xukꞌis ubꞌiꞌxikil waꞌ, xa pa joqꞌotaj ri yabꞌil xsachik y rachi xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ekꞌuchiriꞌ, ri Jesús xukꞌisbꞌej ruchꞌaꞌtem rukꞌ y lik xupixabꞌaj, ");
INSERT INTO acrNNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","jewaꞌ xubꞌiꞌij che: —Chatapeꞌ, makꞌo matzijoj che junoq. Jat chwach raj chakunel pa Rocho Dios chaꞌ rire karilo na jinta chi lepra chawe. Y ruma rajosqꞌikil, chayaꞌa kꞌu chwach ri Dios ri qasaꞌn xtaqan kan ri Moisés che, chaꞌ kaqꞌalajin chikiwach ri tikawex at kunutajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Noꞌj laꞌchi echiriꞌ xeꞌek, lik xujeq utzijoxik ri xuꞌan ri Jesús che y jekꞌulaꞌ lik xtataj waꞌ kuma ri winaq. Ruma kꞌu riꞌ, na utz ta chik kok ri Jesús chiwachil pa ri tinamit; xujeq kꞌu kakanaj kan chinimanaj che ri tinamit pa taq luwar katzꞌintzꞌotik. Na rukꞌ ta kꞌu riꞌ, ukꞌiyal tikawex re ronoje luwar xebꞌopon rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Echiriꞌ ikꞌowinaq chi kebꞌ oxibꞌ qꞌij, xok tanchi ubꞌi ri Jesús pa ri tinamit Capernaúm. Taq ri winaq xkito Rire kꞌo chuchiꞌ jun ja. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Y na jampatana xemolotaj ukꞌiyal winaq y ruma ri kikꞌiyal na kebꞌok ta chi ne chuchiꞌ ri puerta. Ekꞌu ri Jesús kutzijoj Ruchꞌaꞌtem ri Dios chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ekꞌuchiriꞌ, xekꞌun kajibꞌ achijabꞌ kitelem lo jun achi sik. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yey na xkiriq taj suꞌanik kakiya pan chwach ri Jesús kuma rukꞌiyal winaq. Ewi xkiteqꞌebꞌaꞌ ruwi ri ja pa kꞌo wi ri Jesús, xkesaj julepaj che. Chiriꞌ kꞌu riꞌ xkiqasaj wubꞌi la chꞌat pa kotzꞌol wi ri sik. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ekꞌu ri Jesús echiriꞌ xril ri kubꞌulibꞌal kikꞌuꞌx rukꞌ, jewaꞌ xubꞌiꞌij che ri sik: —Wal, ronoje ramak kuytajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Chiriꞌ kꞌut etzꞌul jujun aj kꞌutunel re ri tzijpixabꞌ y jewaꞌ katajin chikikꞌuꞌx: ");
INSERT INTO acrNNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","«¿Suꞌchak jewaꞌ kachꞌaꞌt waꞌchi? Rukꞌ wa kubꞌiꞌij kamakun chirij ri Dios. Ma ¿na xew ta nebꞌa ri Dios aj kuyul mak?» ");
INSERT INTO acrNNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Chupa kꞌu laꞌ la joqꞌotaj, ri Jesús xunaꞌbꞌej saꞌ la kakichꞌobꞌo; ruma kꞌu riꞌ, xubꞌiꞌij chike: —¿Suꞌchak jelaꞌ katajin chikꞌuꞌx alaq? ");
INSERT INTO acrNNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Saꞌ kꞌu ri na kꞌayew taj kambꞌiꞌij che rachi sik: “Ronoje ramak kuytajinaq chik” o “Chatyaktajoq, chakꞌama bꞌi rachꞌat y chatbꞌinoq”? ");
INSERT INTO acrNNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","E kuaj kꞌut ketaꞌmaj alaq waꞌ: Ralaxel Chikixoꞌl Tikawex yaꞌtal puqꞌabꞌ kukuy taq ri mak ke ri winaq che ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Xubꞌiꞌij kꞌu riꞌ che ri sik: —Chatyaktajoq, chakꞌama bꞌi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Na jampatana xyaktaj rachi, xutelej bꞌi ruchꞌat y chikiwach konoje xel bꞌi. Konoje kꞌu riꞌ xkam kanimaꞌ che la xkilo y xkijeq kakiyak uqꞌij ri Dios, jewaꞌ kakibꞌiꞌij: «¡Na jinta kꞌana qilom wi waꞌ!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Tekꞌuchiriꞌ, xeꞌek tanchi ri Jesús chuchiꞌ ri mar. Konoje ri winaq xeqibꞌ rukꞌ, y Rire xujeq kakꞌutun chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ekꞌu riꞌ katajin rikꞌowik pa ri luwar pa kaꞌan wi ri tojonik che ri gobierno, xril pana jun aj tzꞌonol puaq re tojonik tzꞌul chiriꞌ. Waꞌ Leví rubꞌiꞌ yey ukꞌajol ri Alfeo. Xubꞌiꞌij kꞌu ri Jesús che: —Chat-terej lo chwij —xchaꞌ. Xyaktajik kꞌu ri Leví y xterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ekꞌu ri Jesús xumaj bꞌi chirocho ri Leví. Xebꞌok kꞌu chwa ri mexa kukꞌ rutijoꞌn, junam kukꞌ ukꞌiyal aj tzꞌonol puaq re tojonik y ukꞌiyal aj makibꞌ; ma lik e kꞌi ri kiternabꞌem bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Ekꞌu raj kꞌutunel re ri tzijpixabꞌ kukꞌ ri fariseos, echiriꞌ xkilo kawaꞌ ri Jesús kukꞌ raj makibꞌ y raj tzꞌonol puaq re tojonik, xkibꞌiꞌij chike rutijoꞌn ri Jesús: —¿Suꞌchak ri tijonel iwe riꞌix kawaꞌ junam kukꞌ raj tzꞌonol puaq re tojonik yey kukꞌ raj makibꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Echiriꞌ xuta waꞌ ri Jesús, xubꞌiꞌij chike: —E janipa ri utz kiwach, na kajawax ta aj kunanel chike; ma waꞌ xew chike ri e yewaꞌibꞌ kajawax wi. Jelaꞌ kꞌu riꞌ, riꞌin na in petinaq ta che kisikꞌixik ri jusukꞌ kibꞌinik kisilabꞌik, ma e in petinaq che kisikꞌixik raj makibꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Rutijoꞌn ri Juan Aj Yaꞌl Bautismo y ri kitijoꞌn ri fariseos echiriꞌ e kꞌo pa ayuno, xebꞌopon rukꞌ ri Jesús y xkitzꞌonoj che: —¿Suꞌbꞌe rutijoꞌn ri Juan y ri kitijoꞌn ri fariseos lik kakiꞌan ayuno, yey ri tijoꞌn rilal na kakiꞌan ta waꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ri Jesús xukꞌul uwach: —¿Ubꞌe nawi kakiꞌan ayuno ri esikꞌim pa juna kꞌulanikil we rala kakꞌuliꞌik kꞌa kꞌo kukꞌ? Na ubꞌe taj, ma kꞌa kꞌo rala chikixoꞌl. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Noꞌj kopon na ri qꞌij echiriꞌ kesax bꞌi rala chikixoꞌl; kꞌa ekꞌuchiriꞌ, kakiꞌan ayuno. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","»Na jinta junoq kukꞌojoj ruqꞌuꞌ qꞌeꞌl rukꞌ kꞌojobꞌal kꞌasaq; ma ri kꞌojobꞌal kꞌasaq, we xkꞌolotaj upa, e kujekꞌ ri kꞌul qꞌeꞌl y más ne kurichꞌij bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jekꞌulaꞌ ri vino kꞌakꞌ na kaqꞌej ta chupa juna surun qꞌeꞌl. Ma we kaꞌaniꞌ waꞌ, ri vino kꞌakꞌ echiriꞌ kanajtir uqꞌij, kuraqij ri surun, katix kꞌu riꞌ ri vino y ri surun na jinta chi uchak. Ruma kꞌu laꞌ, ri vino kꞌakꞌ ꞌanom chirajawaxik wi kaqꞌej chupa juna surun kꞌasaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Chupa kꞌu jun qꞌij re uxlanibꞌal, ri Jesús kukꞌ rutijoꞌn e riꞌ kebꞌikꞌow pa taq tikoꞌn re trigo. Ekꞌu rutijoꞌn xkijeq kakichꞌupilaꞌ bꞌi ri trigo. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Ruma waꞌ ri fariseos xkitzꞌonoj che ri Jesús: —Chilape la, ¿suꞌbꞌe ri tijoꞌn la kakiꞌan ri na taqal taj kaꞌaniꞌ chupa ri qꞌij re uxlanibꞌal? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ekꞌu ri Jesús xukꞌul uwach: —¿Na ajilam ta nebꞌa alaq ri xuꞌan ri David kukꞌ ri rachbꞌiꞌil echiriꞌ kꞌo xajawax chike y xenumik? ");
INSERT INTO acrNNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Echiriꞌ ri Abiatar e kajawal raj chakunel pa Rocho Dios, ri David xok pa ri Rocho Dios y xutij ri pam yaꞌtal chi puqꞌabꞌ ri Dios, yey waꞌ na taqal ta chike rike kakitijo. Na rukꞌ ta kꞌu riꞌ, xuya ne ke ri e rachbꞌiꞌil. Yey waꞌ wa pam, xew taqal chike raj chakunel pa Rocho Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Y jewaꞌ xubꞌiꞌij tanchi chike: —Ri qꞌij re uxlanibꞌal xuya kan ri Dios re toꞌbꞌal ke ri tikawex; na e ta xeꞌaniꞌ ri tikawex ruma ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Yey Ralaxel Chikixoꞌl Tikawex e ne rajaw ri qꞌij re uxlanibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jumul chik ri Jesús xok chupa ri sinagoga y chiriꞌ kꞌo jun achi chaqijinaq jun uqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","E kꞌo kꞌu jujun lik kikꞌakꞌalem we ri Jesús kukunaj waꞌchi chupa wa qꞌij re uxlanibꞌal, chaꞌ jelaꞌ utz kakitzꞌaq uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Xubꞌiꞌij kꞌu ri Jesús che rachi chaqijinaq ruqꞌabꞌ: —Chatyaktajoq y chatkꞌola chiqawach qonoje —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ekꞌuchiriꞌ, xutzꞌonoj chike ri kakitzutzaꞌ: —¿Saꞌ ri lik usukꞌ kaꞌaniꞌ pa ri qꞌij re uxlanibꞌal: E kaꞌaniꞌ ri utz o e ri na utz taj? ¿Utz kakolobꞌex rukꞌaslem junoq o kayaꞌ luwar che kakamik? —xchaꞌ. Yey na jinta kꞌu junoq chike xkꞌuluw uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ekꞌuchiriꞌ, ri Jesús xebꞌutzuꞌ rukꞌ oyowal taq ri kisutum rij y lik xok bꞌis chukꞌuꞌx ruma lik uꞌanom ko ri kanimaꞌ. Xubꞌiꞌij kꞌu che rachi: —Chasukꞌupij raqꞌabꞌ —xcha che. Rachi xuyuq ruqꞌabꞌ y waꞌ xutzirik. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Xebꞌel kꞌu bꞌi ri fariseos, xkimol kibꞌ kukꞌ jujun chike ri kitaqem ri rey Herodes, y junam xkichꞌaꞌtibꞌej suꞌanik kakisach uwach ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ri Jesús xel bꞌi y xeꞌek chuchiꞌ ri mar junam kukꞌ rutijoꞌn. Y ukꞌiyal tikawex xeterej bꞌi chirij. Waꞌ e petinaq pa taq ri tinamit re Galilea y re Judea ");
INSERT INTO acrNNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","y pa ri tinamit Jerusalem; e petinaq pa taq ri tinamit re Idumea, pa taq ri tinamit e kꞌo chꞌaqa yaꞌ che ri nimayaꞌ Jordán, yey pa taq ri tinamit e kꞌo chunaqaj ri tinamit Tiro y ri tinamit Sidón. Konoje waꞌ e petinaq ruma xkito janipa ri katajin ri Jesús che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ekꞌu ri Jesús xubꞌiꞌij chike rutijoꞌn, xaqi kiyijbꞌaꞌ na ri barco re kaqꞌax chupa we xajawax che, chaꞌ jelaꞌ na kapitzꞌipoꞌx ta kuma rukꞌiyal winaq; ");
INSERT INTO acrNNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ma lik e kꞌi ri xebꞌukunaj. Jekꞌulaꞌ konoje ri yewaꞌibꞌ kakiminimaꞌ kibꞌ rukꞌ, ruma kakaj kakichapo chaꞌ kekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ekꞌu ri winaq e kꞌo pakiqꞌabꞌ itzelilaj uxlabꞌixel, echiriꞌ kakil uwach ri Jesús, kexukiꞌ chwach y kesikꞌinik kakibꞌiꞌij: «¡Rilal lal Rukꞌajol ri Dios!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Noꞌj ri Jesús lik kebꞌuqꞌatej chaꞌ na kakiqꞌalajisaj taj china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Tekꞌuchiriꞌ, xaqꞌan ri Jesús chwa jun juyubꞌ y xebꞌusikꞌij china taq ri xraj kebꞌuchaꞌo, y rike xkimol kibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Xebꞌuchaꞌ kꞌu kabꞌlajuj chike waꞌ chaꞌ kekꞌojiꞌ rukꞌ y kebꞌutaq bꞌi che utzijoxik ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Y xuya bꞌi kichuqꞌabꞌ re kekikunaj yewaꞌibꞌ y re kebꞌekesaj bꞌi itzel uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Ekꞌu kibꞌiꞌ waꞌ wa kabꞌlajuj xebꞌuchaꞌo: Simón ri xkoj Pedro che, ");
INSERT INTO acrNNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jacobo y ruchaqꞌ Juan (rike e ukꞌajol ri Zebedeo y xkoj ne kibꞌiꞌ “Boanerges”, waꞌ keꞌelawi “E ralkꞌoꞌal ruchꞌawibꞌal jabꞌ”), ");
INSERT INTO acrNNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, Jacobo rukꞌajol ri Alfeo, Tadeo, Simón, ri kabꞌiꞌx che “ri Cananista”, ");
INSERT INTO acrNNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","y Judas aj Iscariot, ri xkꞌayin re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Tekꞌuchiriꞌ, xok ri Jesús chuchiꞌ jun ja y xemolotaj tanchi ukꞌiyal winaq. Y ruma kꞌu riꞌ, ri Jesús kukꞌ rutijoꞌn na utz ta chi ne kewaꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Echiriꞌ xkita ri ratz-uchaqꞌ ri Jesús, xekꞌunik y xkaj kakikꞌam bꞌi kukꞌ, ma rike kakibꞌiꞌij xsach runaꞌoj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Noꞌj raj kꞌutunel re ri tzijpixabꞌ, ri e petinaq Jerusalem, xkibꞌiꞌij: «Ri Jesús kꞌo puqꞌabꞌ ri Beelzebú» y «Ruma kꞌu ruchuqꞌabꞌ waꞌ wa kajawal ri itzel uxlabꞌixel, kebꞌeresaj bꞌi itzel uxlabꞌixel» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ekꞌu ri Jesús xebꞌusikꞌij y rukꞌ kꞌambꞌal naꞌoj xubꞌiꞌij chike: «¿Saꞌ nawi we ta ri Satanás karesaj bꞌi ri Satanás chike ri winaq? ");
INSERT INTO acrNNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","We ri taqanelabꞌ re juna tinamit kijachom kipa ruma kechꞌoꞌjin chikiwach, riꞌ na ketikiꞌ ta chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Yey we ri ejeqelel pa juna ja kijachom kibꞌ ruma kechꞌoꞌjin chikiwach, riꞌ na ketikiꞌ ta chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Jekꞌulaꞌ, we ta ri Satanás kayaktaj chiribꞌil ribꞌ y utukel kujach upa rutaqanik, riꞌ na kanajtir ta rutaqanik, xa kasach uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","»Na jinta kꞌu juna eleqꞌom kok pa rocho junoq lik kꞌo uchuqꞌabꞌ yey kareleqꞌaj kꞌu lo rubꞌitaq re pa ja, we na kuyut ta nabꞌe ri rajaw ja. Ma we releqꞌom uyutum chi ri rajaw ja, kꞌa ekꞌuchiriꞌ utz kareleqꞌaj bꞌi ronoje la kꞌo pa ri ja. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Paqatzij wi kambꞌiꞌij chiwe: Kꞌo puqꞌabꞌ ri Dios kukuy ronoje taq ri mak ke ri tikawex, rukꞌ ronoje taq ri na utz taj kakibꞌiꞌij, tobꞌ china chirij; ");
INSERT INTO acrNNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","noꞌj china ri tzel kachꞌaꞌt chirij ri Santowilaj Ruxlabꞌixel ri Dios, riꞌ na kakuytaj ta kꞌana umak. Ma ri kaꞌanaw waꞌ, kꞌo chi ri qꞌatbꞌal tzij puwiꞌ na jinta utaqexik» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Xubꞌiꞌij waꞌ ma rike kibꞌiꞌim: «Rire kꞌo puqꞌabꞌ jun itzelilaj uxlabꞌixel.» ");
INSERT INTO acrNNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Tekꞌuchiriꞌ, ruchu y taq ruchaqꞌ ri Jesús xekꞌunik y xekꞌojiꞌ lo pa bꞌe, yey xkitaq usikꞌixik ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Ekꞌu ri tikawex etzꞌulik, ri kisutum rij ri Jesús, jewaꞌ xkibꞌiꞌij che: —Ri chu la y taq ri chaqꞌ la e kꞌo pa bꞌe, e laꞌ kakitzukuj la —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ekꞌu ri Jesús xukꞌul uwach: —¿China ri nuchu y china taq ri nuchaqꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Tekꞌuchiriꞌ, xebꞌutzuꞌ ri etzꞌulik kisutum rij y jewaꞌ xubꞌiꞌij chike: —Wa e kꞌo wara e nuchu y e taq nuchaqꞌ riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ma china ri kuꞌan janipa ri karaj ri Dios, waꞌ e nuchaqꞌ, e wanabꞌ y e nuchu riꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ri Jesús xujeq tanchi kakꞌutun chuchiꞌ ri mar y lik e kꞌi ri tikawex xemolotaj chiriꞌ pa kꞌo wi Rire. Ruma kꞌu riꞌ xok chupa jun barco kꞌo chwi ri mar, xtzꞌuyiꞌ chupa y konoje ri tikawex e kꞌo pana chuchiꞌ la mar. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Xujeq kꞌu kakꞌutun chikiwach rukꞌ ukꞌiyal taq kꞌambꞌal naꞌoj, yey jun che taq rukꞌutunik e waꞌ: ");
INSERT INTO acrNNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","«¡Chitapeꞌ! Kꞌo jun awanel xel bꞌi chaꞌ keꞌawanoq. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ekꞌuchiriꞌ katajin che ujopopexik rijaꞌ, kꞌo xtzaq kan chuchiꞌ ri bꞌe. Xekꞌun kꞌu lo tzꞌikin, y xoꞌlkitija bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","»Kꞌo ijaꞌ xtzaq kan pa taq abꞌaj; yey ruma na jinta ukꞌiyal ulew chuxeꞌ, xel tan lo rijaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Ekꞌuchiriꞌ xel lo ri qꞌij, xkꞌatik; yey ruma na jinta ratzꞌayaq, xchaqijik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","»Kꞌo ijaꞌ xtzaq kan pa taq kꞌiix. Echiriꞌ ri kꞌiix xkꞌiyik, rijaꞌ xjiqꞌ kan chuxeꞌ; ruma kꞌu riꞌ, na jinta reqaꞌn xuyaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","»Noꞌj kꞌo ijaꞌ xtzaq kan pa chomilaj ulew. Ekꞌu riꞌ waꞌ xel loq, xkꞌiyik y lik xuꞌan reqaꞌn. Kꞌo jujun raqan xuya treinta, jujun chik xuya sesenta y kꞌo ne xuya jun ciento» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij tanchi chike: «China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Echiriꞌ ri Jesús xkanaj kan utukel, ri e kꞌo chunaqaj y ri kabꞌlajuj utijoꞌn xeqibꞌ rukꞌ, xkitzꞌonoj kꞌu che saꞌ keꞌelawi wa kꞌambꞌal naꞌoj xuya chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ekꞌu ri Jesús xubꞌiꞌij chike: «Chiwe riꞌix yaꞌtalik kaqꞌalajisax runaꞌoj ri Dios chwi rutaqanik. Noꞌj chike taq ri winaq na e jinta chupa rutaqanik, xa rukꞌ taq kꞌambꞌal naꞌoj kabꞌiꞌx ronoje chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ma tobꞌ rike ketzuꞌnik, e junam rukꞌ na ketzuꞌn taj; tobꞌ ketanik, e junam rukꞌ na ketan taj y e riꞌ na jinta kꞌo kakimaj usukꞌ. Na kakaj ta kꞌu riꞌ kakitzelej kitzij chaꞌ jelaꞌ kakuytaj kimak» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ekꞌuchiriꞌ, xutzꞌonoj chike: «¿Na kimaj ta kami usukꞌ riꞌ wa kꞌambꞌal naꞌoj? ¿Saꞌ kꞌu uꞌanik riꞌ kimaj usukꞌ ronoje taq ri kꞌambꞌal naꞌoj kankꞌut chiwach? ");
INSERT INTO acrNNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","»Ri awanel e pachaꞌ ri katikow Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","»E kꞌo kꞌu jujun tikawex e pachaꞌ rijaꞌ xtzaq kan chuchiꞌ ri bꞌe; waꞌ xtik Ruchꞌaꞌtem ri Dios pa kanimaꞌ y kakita ne riꞌ. Pero kakꞌun kꞌu lo ri Satanás y kumaj bꞌi ri Chꞌaꞌtem xtikiꞌ pa kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","»E kꞌo jujun chik e pachaꞌ rijaꞌ xtzaq kan pa taq abꞌaj. Waꞌ e ri kakita Ruchꞌaꞌtem ri Dios y na jampatana kakikꞌul rukꞌ kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Pero ruma na e tikil ta chi utz, na kekowin taj. Ma echiriꞌ kakꞌun lo ri kꞌambꞌal kipa o keternabꞌex rukꞌ kꞌax ruma kikꞌulum Ruchꞌaꞌtem ri Dios, kepajtaj kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","»E kꞌo jujun chik e pachaꞌ rijaꞌ xtzaq kan pa taq kꞌiix. Waꞌ e ri ketaw Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Pero rubꞌis kikꞌuꞌx chwi taq ri kajawax chike, rukꞌ ri sokosoꞌnik re ri bꞌeyomalil y ri kirayibꞌal che taq ronoje ri kꞌolik; ronoje kꞌu waꞌ e kusach uwach Ruchꞌaꞌtem ri Dios kꞌo pa kanimaꞌ. Ruma taq kꞌu riꞌ waꞌ na jinta kꞌana kijiqꞌobꞌalil kilitaj che ri kibꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","»E kꞌo kꞌu jujun e jelaꞌ pachaꞌ rijaꞌ xtzaq pa chomilaj ulew. Waꞌ e ri kakita Ruchꞌaꞌtem ri Dios, kakikꞌul chi utz y lik kꞌo kijiqꞌobꞌalil kilitaj che ri kibꞌinik. E jelaꞌ pachaꞌ rijaꞌ lik xuꞌan reqaꞌn; kꞌo jujun raqan xuya treinta, jujun chik xuya sesenta y kꞌo ne xuya jun ciento» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ri Jesús xubꞌiꞌij tanchi chike: «¿Kꞌo nebꞌa junoq kutzij juna aqꞌ y kuchꞌuq uwiꞌ rukꞌ juna mulul re pajbꞌal o kujuꞌ chuxeꞌ ruwarabꞌal? ¿Na re ta nebꞌa kuya lo chupa rukꞌolibꞌal chikaj? ");
INSERT INTO acrNNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ma kopon ri qꞌij echiriꞌ janipa ri na qꞌalajisam taj, kaqꞌalajisax na; yey janipa ri ewatalik, ketaꞌmaxik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Jewaꞌ xubꞌiꞌij tanchi chike: «Lik chita chi utz janipa ri kambꞌiꞌij chiwe, ma “rukꞌ ri pajbꞌal kixpajan wi riꞌix, rukꞌ tanchi wa pajbꞌal kaꞌan pajanik chiwe.” Ekꞌu ri Dios kuya na chiwe lik kimaj usukꞌ ri kambꞌiꞌij, we lik e kita ri nutzij. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ma china ri kukꞌul chi utz janipa ri kakꞌut chwach, riꞌ kakꞌut ne más chwach y jekꞌulaꞌ kumaj más. Yey china ri na kukꞌul ta ri kakꞌut chwach, riꞌ kamaj ne che janipa ri kuchꞌobꞌo umajom chi usukꞌ» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Xubꞌiꞌij tanchi ri Jesús chike: «Rutaqanik ri Dios e jelaꞌ pachaꞌ juna achi kutik rijaꞌ pulew. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Rachi chaqꞌabꞌ keꞌwaroq y paqꞌij kawaꞌlij tanchik; yey na kumaj ta usukꞌ suꞌanik kel lo rijaꞌ y kakꞌiyik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ma rulew utukel kuꞌan ribꞌ che ukꞌiyisaxik ri tikoꞌn. Nabꞌe na e kel lo ri raqan ri tikoꞌn, teran kꞌu lo rutzikꞌ; tekꞌuchiriꞌ, kawachinik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ekꞌuchiriꞌ ya xriꞌjobꞌik, katzaq bꞌi ri jos che ma e riꞌ xopon ruqꞌijol molonik» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Xubꞌiꞌij tanchi ri Jesús: «¿Saꞌ rukꞌ kaqajunimaj wi rutaqanik ri Dios, o saꞌ juna kꞌambꞌal naꞌoj kuqꞌalajisaj waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","E pachaꞌ rijaꞌ re moxtasa echiriꞌ katik pulew. Ma e ijaꞌ waꞌ más chꞌutiꞌn chwa taq rijaꞌ kꞌo che ruwachulew, ");
INSERT INTO acrNNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","pero echiriꞌ tikital chik, we xkꞌiyik más kanimar chwa taq ri tikoꞌn kꞌo pa ri werta. Kel kꞌu lo nimaq taq uqꞌabꞌ y kekꞌun lo ri tzꞌikin kexikꞌikꞌ che ruwa kaj y kejeqiꞌ chuxeꞌ rumuꞌj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Rukꞌ ukꞌiyal taq kꞌambꞌal naꞌoj pachaꞌ taq waꞌ, xkꞌutun ri Jesús puwi Ruchꞌaꞌtem ri Dios, e chirij ri kakimaj usukꞌ ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Y na jinta kꞌo xukꞌutu we na rukꞌ ta kꞌambꞌal naꞌoj xuꞌano; noꞌj chike rutijoꞌn xuqꞌalajisaj ronoje echiriꞌ e kꞌo kitukel. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Chupa kꞌu laꞌ la jun qꞌij echiriꞌ xok raqꞌabꞌ, ri Jesús xubꞌiꞌij chike rutijoꞌn: —Joꞌ, chojqꞌax chꞌaqa yaꞌ —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Echiriꞌ ebꞌuchꞌaꞌbꞌem chi kan rukꞌiyal winaq, rutijoꞌn xkikꞌam bꞌi ri Jesús e laꞌ chupa ri barco pa tzꞌul wi Rire, yey e kꞌo chi jujun barcos ekachbꞌilam bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Xpe kꞌu jun nimalaj kaqjiqꞌ chwi ri mar. Ekꞌu ri yaꞌ kuroj ribꞌ che ri barco; y waꞌ xujeq kanoj che yaꞌ, ya laj kamuqutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ekꞌu ri Jesús kꞌo pa ri barco pukꞌisbꞌal re chirij, kawar chwi jun chꞌakat. Rutijoꞌn xeꞌkikꞌosoj y jewaꞌ xkibꞌiꞌij che: —¡Qajawal! ¿Na kok ta kami la il chiqe? ¡Ma ya kojkamik! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ekꞌu ri Jesús xyaktajik, xuqꞌatej ri kaqjiqꞌ y jewaꞌ xubꞌiꞌij che ri yaꞌ: —¡Chat-tanaloq! ¡Chatkubꞌuloq! —xcha che. Ri kaqjiqꞌ xtaniꞌik y ri yaꞌ xyeniꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Tekꞌuchiriꞌ, xubꞌiꞌij chike rutijoꞌn: —¿Suꞌchak lik kixiꞌij iwibꞌ? ¿Suꞌbꞌe na kubꞌul ta ikꞌuꞌx wukꞌ? —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ewi xok lo jun xiꞌin ibꞌ kukꞌ y xkibꞌiꞌij chikiwach: —¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tobꞌ ne e ri kaqjiqꞌ y ri yaꞌ kakikoj utzij! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Xebꞌopon kꞌu chꞌaqa yaꞌ pa ri luwar re Gadara. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Echiriꞌ xel lo ri Jesús chupa ri barco, na jampatana xoꞌlkꞌul ruma jun achi elinaq lo chuxoꞌl taq muqubꞌal ke animaꞌ, yey waꞌ kꞌo puqꞌabꞌ jun itzelilaj uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Waꞌ waꞌchi jeqel pa kemuq wi ri animaꞌ y na jinta chi kꞌana junoq kachꞌijow uximik, tobꞌ ne rukꞌ karena. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ma lik ukꞌiyal laj xyut ri raqan y ruqꞌabꞌ rukꞌ taq chꞌichꞌ y karena; pero rire kuraqaraꞌ upa, kuꞌan ukꞌaj che y na jinta kꞌo kachꞌijow uchuqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chipaqꞌij chichaqꞌabꞌ xaqi kasutin chwi taq ri juyubꞌ y chuxoꞌl taq muqubꞌal ke animaꞌ, kasikꞌinik y kuꞌan kꞌax che ribꞌ rukꞌ abꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Ekꞌuchiriꞌ chinimanaj xril pana ri Jesús, kakꞌalalik xqibꞌ rukꞌ y xuxukubꞌaꞌ ribꞌ chwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Y lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: —¿Suꞌchak koꞌlmina ibꞌ la wukꞌ, Jesús lal Ukꞌajol ri Dios kꞌo chilaꞌ chikaj? Kantzꞌonoj kꞌu cheꞌla pa rubꞌiꞌ ri Dios, minya la pa kꞌax —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Xubꞌiꞌij waꞌ ma ri Jesús xubꞌiꞌij che: «At itzelilaj uxlabꞌixel, chatelubꞌi che waꞌchi» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ekꞌu ri Jesús xutzꞌonoj che: —¿Saꞌ rabꞌiꞌ? —xcha che. Rire xukꞌul uwach: —Legión ri nubꞌiꞌ, ma lik oj kꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Yey ritzelilaj uxlabꞌixel lik xukoj ribꞌ chwach ri Jesús chaꞌ na ketaq tubꞌi kꞌa naj che taq laꞌ la luwar. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Xa chiriꞌ kꞌu riꞌ e kꞌo lo ukꞌiyal aq kewaꞌ chwa ri juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","E taq kꞌu ri itzelilaj uxlabꞌixel xkikoj kibꞌ chwach ri Jesús y jewaꞌ xkibꞌiꞌij che: —Chojtaqa bꞌi la kukꞌ la aq chaꞌ kojok bꞌi kukꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Y ri Jesús xuya luwar chike. Xebꞌel kꞌu bꞌi che rachi y xebꞌok bꞌi kukꞌ ri aq. Waꞌ wa aq laj e juna kebꞌ mil. Ekꞌu laꞌ konoje xeꞌkikꞌaqa bꞌi kibꞌ chwi jun siwan, xebꞌeꞌtzaq kꞌa chupa ri mar y chiriꞌ xejiqꞌ wi. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ekꞌu ri e chajinel ke ri aq, xebꞌanimajik. Y janipa ri xkilo xebꞌek che utzijoxik chupa ri tinamit y pa taq juyubꞌ. Xepe kꞌu ri winaq che rilik saꞌ ri xꞌaniꞌ chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Echiriꞌ xekꞌun pa kꞌo wi ri Jesús, xkil rachi ri lik xꞌan kꞌax che kuma ritzelilaj uxlabꞌixel; e riꞌ tzꞌulik, ukojom chi uqꞌuꞌ y jusukꞌ chi runaꞌoj. Ruma waꞌ, lik xkixiꞌij kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Y ri xebꞌilow waꞌ xkitzijoj chike ri kꞌakꞌ xekꞌunik; xkitzijoj suꞌanik xebꞌel bꞌi ritzelilaj uxlabꞌixel che rachi y saꞌ ri xkikꞌulumaj taq ri aq. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ewi ri winaq xkijeqo kebꞌelaj che ri Jesús chaꞌ kel bꞌi chiriꞌ pa taq ri kiluwar. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ekꞌuchiriꞌ, ri Jesús xok bꞌi chupa ri barco. Ekꞌu rachi ebꞌelinaq bꞌi ritzelilaj uxlabꞌixel che, xelaj che ri Jesús chaꞌ kuya luwar che katerej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Noꞌj ri Jesús na xuya ta luwar che, jenewaꞌ xubꞌiꞌij che: —Jat chaꞌwocho kukꞌ rawatz-achaqꞌ y chatzijoj chike ronoje ri utz uꞌanom ri Dios awukꞌ, ma e xukꞌut ri kꞌaxnaꞌbꞌal ukꞌuꞌx chawe —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Rachi xeꞌek y xujeq utzijoxik pa ri tinamit re Decápolis ronoje ri utz xꞌan che ruma ri Jesús, y konoje ri tikawex lik kakam kanimaꞌ che waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Echiriꞌ xtzelej tanchi ri Jesús chꞌaqa yaꞌ chupa ri barco, ukꞌiyal tikawex xkimok rij y Rire xkꞌojiꞌ chuchiꞌ ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Xkꞌun kꞌu lo jun achi Jairo rubꞌiꞌ, rire e jun chike ri e aj wach re ri sinagoga. Xew kꞌu xril uwach ri Jesús, xukꞌaq ribꞌ xeꞌraqan uqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Y lik xukoj ribꞌ chwach, jewaꞌ xubꞌiꞌij che: —Ri numiꞌal kajekꞌowik. Joꞌ ko la wukꞌ, keꞌyaꞌa ri qꞌabꞌ la puwiꞌ chaꞌ kakunutajik y jelaꞌ na kakam taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Xeꞌek kꞌu ri Jesús rukꞌ rachi, yey ukꞌiyal winaq xeterej bꞌi chirij y lik kakipitzꞌipaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Chikixoꞌlibꞌal kꞌu riꞌ kꞌo jun ixoq lik yewaꞌ, e kabꞌlajuj lo junabꞌ riꞌ na kataniꞌ ta ruyabꞌil re upa ikꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Y lik utijom kꞌax pakiqꞌabꞌ ukꞌiyal e aj kun, y ukꞌisom chi ne ronoje ri kꞌo rukꞌ; yey na jinta kꞌana xutiqoj che, ma katajin ne unimitajik ri jujun qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Echiriꞌ xuta ri kakibꞌiꞌij puwi ri Jesús, xumin bꞌi ribꞌ chikixoꞌlibꞌal taq ri winaq. Xqibꞌ kꞌu pana chirij ri Jesús y xuchap ruqꞌuꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ma xuchꞌobꞌ pa ranimaꞌ: «Tobꞌ tane xew luꞌqꞌuꞌ kanchapo, rukꞌ riꞌ kinkunutajik.» ");
INSERT INTO acrNNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Y na jampatana xtaniꞌ ruyabꞌil y lik xunaꞌ chiribꞌil ribꞌ xkunutaj che ri kꞌaxlaj yabꞌil kꞌo wi. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ekꞌu ri Jesús echiriꞌ xunaꞌ chiribꞌil ribꞌ kꞌo uchuqꞌabꞌ xelik, xebꞌutzuꞌ konoje ri winaq y xutzꞌonoj: —¿China xchapaw ri nuqꞌuꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Rutijoꞌn xkibꞌiꞌij che: —Rilal kil la ri winaq kakipitzꞌipaꞌ la. ¿Suꞌchak kꞌu riꞌ katzꞌonoj la: “China xchapaw weꞌin”? —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Pero ri Jesús xtzuꞌn pa taq utzal che rilik china xchapaw re. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ekꞌu rixoq kabꞌirbꞌot ruma xiꞌin ibꞌ, ma rire e etaꞌmayom saꞌ ri xukꞌulu. Xeꞌek kꞌut y xuxukubꞌaꞌ ribꞌ xeꞌraqan uqꞌabꞌ ri Jesús. Yey xutzijoj che Rire ronoje rukꞌulumam y saꞌ ri xuꞌan la joqꞌotaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ekꞌu ri Jesús xubꞌiꞌij che: —Ixoq, ruma ri kubꞌulibꞌal kꞌuꞌx la wukꞌ, xkunutaj la. Oj kꞌu la riꞌ chi utzil chomal, ma lal chi kunutajinaq che ri kꞌaxkꞌolil la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Kꞌa kachꞌaꞌt ne ri Jesús echiriꞌ xekꞌun lo jujun achijabꞌ e petinaq chirocho ri aj wach re ri sinagoga y xoꞌlkibꞌiꞌij che: —Ri miꞌal la ya xkamik; na jinta chi kutiqoj kabꞌayabꞌaꞌ la ri tijonel —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ekꞌu ri Jesús, echiriꞌ xuta wa xoꞌlbꞌiꞌxoq, xubꞌiꞌij che raj wach re ri sinagoga: —Muxiꞌij ribꞌ kꞌuꞌx la, xew lik kubꞌula kꞌuꞌx la wukꞌ —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ri Jesús na xuya ta chi luwar che junoq katerej bꞌi chirij; xew xebꞌukꞌam bꞌi ri Pedro, ri Jacobo y ri Juan ruchaqꞌ ri Jacobo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ekꞌuchiriꞌ xopon chirocho raj wach re ri sinagoga, xeril ri winaq ketukukik, kebꞌoqꞌik y rukꞌ sikꞌ ketunanik. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Ekꞌu ri Jesús xok bꞌi y xubꞌiꞌij chike: —¿Suꞌbꞌe lik kixtukukik y kixoqꞌik? Ri ralko ali na kaminaq taj, xa kawarik —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Yey xa xkitzeꞌej kꞌu ri xubꞌiꞌij. Pero Rire xebꞌeresaj lo konoje ri e kꞌo pa ja, xew xebꞌukoj bꞌi ruchu-uqaw ri ralko ali kukꞌ rutijoꞌn eteran bꞌi chirij. Xok kꞌu bꞌi pa telan wi ri ralko ali. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Xuchap kꞌu ruqꞌabꞌ y jewaꞌ xubꞌiꞌij pa ri chꞌaꞌtem arameo: —¡Talita kumi! —xcha che. (Waꞌ e keꞌelawi: “Ali chuuy, ¡Chatwaꞌlijoq!”) ");
INSERT INTO acrNNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Y na jampatana ri ralko ali xwaꞌlijik y xbꞌinik. (Rali kabꞌlajuj rujunabꞌ.) Y ri winaq lik xkixiꞌij kibꞌ che wa xkilo. ");
INSERT INTO acrNNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ekꞌu ri Jesús lik xpixabꞌan che chaꞌ na jinta kꞌo kakitzijoj wi y xtaqan kꞌu che chaꞌ kayaꞌ uwa ri ralko ali. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ri Jesús xel bꞌi chiriꞌ y xopon pa rutinamit. Ekꞌu rutijoꞌn xeterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Echiriꞌ xopon ri qꞌij re uxlanibꞌal, xujeq kakꞌutun chupa ri sinagoga. Yey ukꞌiyal winaq xkito y lik xkam kanimaꞌ che, jekꞌuwaꞌ kakibꞌiꞌij: —¿Pa xuꞌmaja wi waꞌchi ronoje taq waꞌ? ¿Saꞌ chi naꞌoj wa yaꞌtal che, yey suꞌanik kuꞌan taq wa milagros? ");
INSERT INTO acrNNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Na e ta nebꞌa jun achi carpintero; ralabꞌ ri María y katzixel ri Jacobo, ri José, ri Judas y ri Simón? ¿Na ejeqel ta nebꞌa ri ranabꞌ wara chiqaxoꞌl? —kechaꞌ. Ewi lik e kꞌi tzel xkita ri xubꞌiꞌij y xkijeq kakikꞌaq bꞌi uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ekꞌu ri Jesús xubꞌiꞌij chike: —Chupa ronoje luwar kayak uqꞌij juna qꞌalajisanel. Noꞌj chupa rutinamit, chikixoꞌl ri ratz-uchaqꞌ y pa rocho, na kayak ta uqꞌij —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Chupa kꞌu riꞌ rutinamit xa e kebꞌ oxibꞌ ri xuya ruqꞌabꞌ pakiwiꞌ y xebꞌukunaj, noꞌj na utz taj xuꞌan juna chik milagro ");
INSERT INTO acrNNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ma ri tikawex na kakikoj taj china Rire. Ekꞌu ri Jesús lik xkam ranimaꞌ che waꞌ. Xikꞌow kꞌu pa taq ri aldeas kꞌo chunaqaj ri tinamit e riꞌ kakꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Tekꞌuchiriꞌ, xebꞌusikꞌij ri kabꞌlajuj utijoꞌn, xebꞌutaq bꞌi pa kakabꞌ y xuya pakiqꞌabꞌ kebꞌekesaj bꞌi itzelilaj uxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Yey xebꞌutaq che na jinta kꞌo kakikꞌam bꞌi re pa bꞌe; xew kakikꞌam bꞌi ri kichꞌamiꞌy. Na kakikꞌam tane bꞌi kitebꞌ, kiwa o kimeyo chwi ri kipas. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Yey utz kakikoj bꞌi kixajabꞌ; noꞌj na utz taj kakikꞌam bꞌi jumolaj chik kiqꞌuꞌ, xew ri kikojom. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Y xubꞌiꞌij bꞌi chike: «We kixkꞌul pa juna ja, chixkꞌola chiriꞌ; kꞌate kixel bꞌi echiriꞌ kixꞌek pa jun chik tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Noꞌj we chupa juna tinamit na kixkꞌul taj y na kakꞌul tane ri Utzilaj Tzij kitzijoj, chixelubꞌi chiriꞌ yey chipupaꞌ kan rulew kꞌo che ri iwaqan; waꞌ e kꞌutubꞌal re na utz ta kiꞌanom ri ejeqel chiriꞌ. Paqatzij wi kambꞌiꞌij chiwe: Chupa ruqꞌijol ri qꞌatbꞌal tzij, más kꞌax ri kape pakiwi rike chwa ri kape pakiwi ri e aj Sodoma y Gomorra» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Xebꞌel kꞌu bꞌi rutijoꞌn che utzijoxik chike ri tikawex puwi ri lik chirajawaxik kakitzelej kitzij chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xebꞌekesaj bꞌi ukꞌiyal itzel uxlabꞌixel yey xkikoj aceite pakiwi ukꞌiyal yewaꞌibꞌ y xekikunaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Ri rey Herodes xuta puwi ri chom uchꞌaꞌtibꞌexik ri Jesús, ma lik xetaꞌmax rubꞌiꞌ pa taq ronoje luwar. Ekꞌu ri Herodes xubꞌiꞌij: «Laꞌ e ri Juan Aj Yaꞌl Bautismo xkꞌastaj lo chikixoꞌl ri ekaminaq; e uwariꞌche kꞌo uchuqꞌabꞌ che uꞌanik wa milagros» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Yey e kꞌo jujun chik kebꞌiꞌn re: «Rire e Elías» y jujun chik kebꞌiꞌn re: «E juna qꞌalajisanel o laj junoq chike ri qꞌalajisanelabꞌ re ojertan.» ");
INSERT INTO acrNNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Echiriꞌ xuta waꞌ ri Herodes, xubꞌiꞌij: «Laꞌ e ri Juan ri jun xintaq uqꞌatik rujolom, xkꞌastaj lo chikixoꞌl ri ekaminaq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Xubꞌiꞌij waꞌ ma e rire ri xutaq uchapik ri Juan chaꞌ kayaꞌiꞌ pa karena y keꞌyoꞌq pa cárcel. Xuꞌan waꞌ ri Herodes ma ri Juan xuchꞌaꞌbꞌej upa ruma uꞌanom rixoqil che ri Herodías, yey waꞌ wiꞌxoq e rixoqil ri Felipe ruchaqꞌ ri Herodes. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jewaꞌ ri xubꞌiꞌij ri Juan che: «Lik na ubꞌe taj ꞌanom ixoqil la che ri rixoqil ri chaqꞌ la» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ruma kꞌu laꞌ, rixoq Herodías lik xutzukuj saꞌ kuꞌan che ri Juan. Lik xraj kukamisaj; pero na kuriq taj saꞌ uꞌanik kuꞌano, ");
INSERT INTO acrNNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ma ri Herodes kuxiꞌij ne ribꞌ chwach ri Juan. Yey utaqom ne uchajixik chaꞌ na jinta kukꞌulumaj, ma retaꞌam ri Juan e jun achi lik jusukꞌ y lik uyaꞌom ribꞌ puqꞌabꞌ ri Dios. Echiriꞌ ri Herodes kuta rukꞌutunik ri Juan, tobꞌ na kumaj ta usukꞌ, lik kacha ukꞌuꞌx che utayik. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ewi xopon jun qꞌij echiriꞌ ri Herodes xukꞌis ujunabꞌ y xuya jun nimalaj waꞌim chike taq raj wach e kꞌo rukꞌ, kukꞌ ri e taqanelabꞌ ke rusoldados y ri e aj Galilea lik kꞌo kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Xok kꞌu bꞌi ri ralit rixoq Herodías pa kꞌo wi ri Herodes kukꞌ konoje taq ri e kꞌo chwa ri mexa, y xujeq kaxajaw chikiwach. Waꞌ lik xukꞌul kikꞌuꞌx konoje ri e kꞌo chiriꞌ. Ewi ri Herodes jewaꞌ xubꞌiꞌij che laꞌli: «Chatzꞌonoj saꞌ ri kawaj, ma riꞌin kanya chawe» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Y xujikibꞌaꞌ kꞌu uwach che: «Ronoje ri katzꞌonoj, kanya chawe, tobꞌ ne pa nikꞌaj che taq ri kꞌo panuqꞌabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ewi rali xel bꞌi chaꞌ kuꞌtzꞌonoj che luꞌchu: «¿Saꞌ nawi ri kantzꞌonoj?» xchaꞌ. «E chatzꞌonoj rujolom ri Juan Aj Yaꞌl Bautismo» xcha ruchu che. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Na jampatana kꞌu riꞌ, rali lik kanik xok bꞌi chwa ri rey Herodes y jewaꞌ xubꞌiꞌij che: «Kuaj kaya la chwe woꞌora pa juna plato rujolom ri Juan Aj Yaꞌl Bautismo» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Ri rey lik xbꞌisonik ruma ri xtzꞌonox che. Pero ruma kꞌu ri xujikibꞌaꞌ uwach che rali chikiwach konoje ri e kꞌo rukꞌ pa waꞌim, na xraj ta chik xujekꞌ ruchꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ewi xutaqalaꞌ bꞌi jun soldado chaꞌ keꞌek y kukꞌam lo rujolom ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ri soldado xeꞌek pa ri cárcel y xukꞌatzij rujolom ri Juan. Xukꞌam lo pa jun plato y xuya kꞌu che rali, y rali xuꞌyaꞌa che ruchu. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Echiriꞌ xkita waꞌ rutijoꞌn ri Juan, xoꞌlkikꞌama rucuerpo y xeꞌkimuquꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Echiriꞌ rutaqoꞌn ri Jesús xetzelej lo che utzijoxik ri Utzilaj Tzij, xkimol kibꞌ rukꞌ Rire y xkitzijoj che janipa ri xkiꞌano y xkikꞌutu. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ekꞌu ri Jesús xubꞌiꞌij chike: —Chixpeta wukꞌ itukel, joꞌ chaꞌ kojeꞌuxlan kꞌenoq pa juna luwar pa na e jinta wi winaq —xchaꞌ. Jelaꞌ xubꞌiꞌij chike ma lik e kꞌi ri winaq, e kꞌo ri kebꞌek y e kꞌo ri kekꞌunik yey rike na utz ta chi ne kewaꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Xebꞌok kꞌu bꞌi ri Jesús kukꞌ rutijoꞌn kitukel chupa jun barco y xebꞌek pa jun luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Pero lik e kꞌi ri xebꞌilowik echiriꞌ xebꞌek y xketaꞌmaj uwach ri Jesús. Ewi ukꞌiyal winaq xebꞌek chaqan, waꞌ ebꞌelinaq lo pa taq ri tinamit. Nabꞌe kꞌu riꞌ xebꞌopon chwa ri Jesús yey echiriꞌ Rire xoponik, xkimol kibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Echiriꞌ xel lo ri Jesús pa ri barco, xrilo e kꞌo chi ukꞌiyal winaq chiriꞌ. Lik kꞌut xejuchꞌ kaꞌn pa ranimaꞌ, ma pachaꞌ e bꞌexex na jinta chajinel ke. Ekꞌu ri Jesús xujeq kuya ukꞌiyal kꞌutunik chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Echiriꞌ lik bꞌenaq qꞌij chik, xeqibꞌ lo rutijoꞌn rukꞌ y jewaꞌ xkibꞌiꞌij che: —Qajawal, wa luwar oj kꞌo wi lik katzꞌintzꞌotik y bꞌenaq qꞌij chik. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Utz we ketaq bꞌi la ri winaq chaꞌ kebꞌek pa taq raldeas y pa taq ri luwar kꞌo lo xa naqaj re keꞌkiloqꞌo kiwa, ma ri wara na jinta kꞌo katijik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Noꞌj ri Jesús xukꞌul uwach: —Chebꞌitzuqu riꞌix —xcha chike. Rike xkibꞌiꞌij che: —¿E kami kaꞌaj la riꞌ keꞌqaloqꞌo kiwa konoje wa tikawex chaꞌ keqatzuqu? ¡Ri rajil waꞌ e junam rukꞌ kebꞌ ciento qꞌij re chak! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ri Jesús xubꞌiꞌij chike: —¿Janipa chi pam kꞌo iwukꞌ? Jix jiꞌwilapeꞌ —xcha chike. Echiriꞌ xketaꞌmaj, xkibꞌiꞌij che: —Xa woꞌobꞌ chi pam y kaꞌibꞌ chi kar —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ekꞌu ri Jesús xtaqan che ketzꞌuyiꞌ konoje ri tikawex chimutzaꞌj pa taq ri rax kꞌim. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Xetzꞌuyiꞌ kꞌu chimutzaꞌj re jujun ciento y re nikꞌaj ciento. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ekꞌu ri Jesús xukꞌam ri woꞌobꞌ pam rukꞌ ri kaꞌibꞌ kar, xtzuꞌn chikaj y xtioxin chwach ri Dios. Tekꞌuchiriꞌ, xuwechꞌ upa ri pam y xuya chike rutijoꞌn chaꞌ kakijach chike ri winaq. Y jelaꞌ xuꞌan rukꞌ ri kebꞌ kar, xjachiꞌ kꞌu riꞌ waꞌ chike konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Konoje kꞌu ri winaq xewaꞌik y xenoj chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Tekꞌuchiriꞌ, xkimol ri chꞌaqaꞌtaꞌq pam y kar, y rukꞌ waꞌ xnoj lo kabꞌlajuj chakach. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Yey ri xewaꞌik e lo woꞌobꞌ mil chi achijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Tekꞌuchiriꞌ, ri Jesús xebꞌutaq rutijoꞌn chaꞌ kebꞌok bꞌi chupa ri barco, kenabꞌej bꞌi chwach y keqꞌax kꞌa chꞌaqa yaꞌ che ri tinamit Betsaida, xaloqꞌ Rire kebꞌuchꞌaꞌbꞌej taq kan rukꞌiyal winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Echiriꞌ ebꞌuchꞌaꞌbꞌem chi kanoq, xel bꞌi chwa ri juyubꞌ chaꞌ kuꞌana orar. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Echiriꞌ xok raqꞌabꞌ, ri barco kꞌo chi punikꞌajal ri mar, yey ri Jesús utukel kanajinaq kan chuꞌlew. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anim tan kꞌu riꞌ, ri Jesús xeril pan rutijoꞌn lik rukꞌ kꞌax ketajin che ubꞌinisaxik ri barco ruma runimal tew petinaq chikiwach. Ekꞌu ri Jesús xeꞌek kukꞌ; e riꞌ kabꞌin chwi ri mar, ya e riꞌ kikꞌow chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Pero rutijoꞌn echiriꞌ xkilo kabꞌin chwi ri yaꞌ, xkichꞌobꞌo e juna espíritu. Xkijeq kꞌu riꞌ kesikꞌinik, ");
INSERT INTO acrNNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ma konoje xkilo y lik xkixiꞌij kibꞌ che. Tekꞌuchiriꞌ, ri Jesús xebꞌuchꞌaꞌbꞌej, jewaꞌ xubꞌiꞌij chike: —Chinimarisaj ikꞌuꞌx, ma riꞌin in Jesús; mixiꞌij kꞌu iwibꞌ —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Xok kꞌu bꞌi ri Jesús kukꞌ chupa ri barco; ekꞌu runimal tew xtaniꞌik. Rutijoꞌn lik xkam kanimaꞌ che, ");
INSERT INTO acrNNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ma kꞌamajaꞌ ne kakimaj usukꞌ ri xuꞌan ri Jesús echiriꞌ xuꞌan kꞌi che ri pam, ma e pachaꞌ chꞌuqutal ri kinaꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Ekꞌuchiriꞌ xkiqꞌaxuj ri yaꞌ, xebꞌopon che ri luwar re Genesaret y xkixim ri barco chuchiꞌ ri yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Echiriꞌ xebꞌel lo chupa ri barco, na jampatana ri winaq xketaꞌmaj uwach ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Xebꞌek kꞌu riꞌ re kakitzijoj puwi ri Jesús pa taq ronoje ri luwar re Genesaret. Yey ri winaq re ronoje taq luwar xkijeq kekikꞌam taq lo yewaꞌibꞌ e telem lo chwa chꞌat kꞌa pa ri luwar pa kitom kꞌo wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Y tobꞌ pa taq chawi xok wi ri Jesús, pa taq tinamit, pa taq aldeas o pa taq juyubꞌ, e kꞌo ri kekiya ri yewaꞌibꞌ chuchiꞌ taq ri bꞌe y kakikoj kꞌu kibꞌ chwach ri Jesús chaꞌ kuya luwar chike tobꞌ ne xew ruchiꞌ ruqꞌuꞌ kakichapo. Konoje kꞌu ri kebꞌanaw waꞌ, kekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ekꞌu ri fariseos kukꞌ jujun chike raj kꞌutunel re ri tzijpixabꞌ e petinaq Jerusalem, xkimol kibꞌ rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Waꞌ waꞌchijabꞌ xkijeq kekichꞌaꞌtibꞌej jujun chike rutijoꞌn ri Jesús ma xekilo kewaꞌik yey na kichꞌajom ta ri kiqꞌabꞌ. Y waꞌ na e ta kikꞌutuꞌn kan ri katiꞌ-kimam. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Ma ri fariseos y ri nikꞌaj chik aj judiꞌabꞌ e lik kitaqem ri kikꞌutuꞌn kan ri katiꞌ-kimam. Rike na kewaꞌ taj we na kakichꞌaj ta nabꞌe ri kiqꞌabꞌ chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Y echiriꞌ ketzelej lo pa kꞌaybꞌal, na jinta kꞌo kakitijo we na kakichꞌaj ta nabꞌe ri kiqꞌabꞌ, jelaꞌ pachaꞌ ri kꞌutum kan chike. Yey kitaqem ukꞌiyal kꞌutunik xa kimajom kan chikij katiꞌ-kimam, jelaꞌ pachaꞌ ruꞌanik kachꞌaj taq upa ri tijbꞌal yaꞌ, ri xaro, rubꞌitaq saꞌch re chꞌichꞌ y rujosqꞌixik ri chꞌat re warabꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Ruma kꞌu laꞌ ri fariseos y raj kꞌutunel re ri tzijpixabꞌ xkitzꞌonoj che ri Jesús: —¿Suꞌbꞌe ri tijoꞌn la na kitaqem ta ri kikꞌutuꞌn kan ri qatiꞌ-qamam? Ma rike kewaꞌik tobꞌ e laꞌ na kichꞌajom ta ri kiqꞌabꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ekꞌu ri Jesús xukꞌul uwach: —¡Xa kebꞌ palaj alaq! Lik qatzij ri tzꞌibꞌital kan ruma ri qꞌalajisanel Isaías pawiꞌ alaq. Ma jewaꞌ xutzꞌibꞌaj kanoq: Waꞌ wa tinamit xa rukꞌ ruwakeꞌ kakiyak nuqꞌij, noꞌj ri kanimaꞌ lik naj kꞌo wi chwe. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Na jinta kꞌana kutiqoj kakiloqꞌoj nuqꞌij, ma ri kꞌutunik kakiꞌano xa taqanik ke achijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ekꞌu ralaq e yaꞌom kan alaq Rutzij Upixabꞌ ri Dios y e lik kok alaq il che uꞌanik ri kikꞌutuꞌn kan ri tikawex, pachaꞌ kaꞌan alaq rukꞌ rujosqꞌixik ri tijbꞌal yaꞌ y ruchꞌajik upa ri xaro; yey kꞌo ne jujun chik pachaꞌ taq waꞌ kaꞌan alaq xa majom kan alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Je tanchi kꞌu waꞌ xubꞌiꞌij chike: —Ralaq ꞌanom alaq che Rutzij Upixabꞌ ri Dios pachaꞌ na jinta uchak, ruma e lik katajin alaq che uꞌanik ri kikꞌutuꞌn kan ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Ma ri Moisés jewaꞌ utzꞌibꞌam kan ojertan: Chaloqꞌoj kiqꞌij rachu-aqaw yey We kꞌo junoq kebꞌuyaj ruchu-uqaw rukꞌ itzel chꞌaꞌtem, riꞌ lik taqal che kakamisaxik xcha ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","»Noꞌj ralaq kabꞌiꞌij alaq: “Utz we juna achi xew kubꞌiꞌij chike ruchu-uqaw: Na utz taj kantoꞌ alaq, ma ri toꞌbꞌal kajawax che alaq, nubꞌiꞌtisim chik re nuqasaꞌn chwach ri Dios.” ");
INSERT INTO acrNNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Yey chiwach ralaq, china ri kabꞌiꞌn re waꞌ, na chirajawaxik ta chi che kebꞌutoꞌ ruchu-uqaw. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Jekꞌuriꞌlaꞌ ꞌanom alaq che Rutzij Upixabꞌ ri Dios pachaꞌ na jinta uchak, ruma taq ri noꞌjibꞌal petinaq lo chike ri chuꞌqaw alaq. Yey taqem alaq ukꞌiyal kꞌutunik pachaꞌ taq waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Tekꞌuchiriꞌ, ri Jesús xebꞌusikꞌij konoje rukꞌiyal tikawex y jewaꞌ xubꞌiꞌij chike: —Lik tanape onoje alaq y lik maja alaq usukꞌ waꞌ: ");
INSERT INTO acrNNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Ri kachꞌulan ri ranimaꞌ ri tikawex na e ta ri kutij bꞌi, ma e ri kel lo pa ranimaꞌ, e waꞌ ri kachꞌulan re. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ! —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ekꞌu ri Jesús xebꞌuya kan rukꞌiyal tikawex y xok bꞌi che jun ja. Tekꞌuchiriꞌ rutijoꞌn xkiꞌan tzꞌonobꞌal che puwi wa kꞌambꞌal naꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ewi rire xubꞌiꞌij chike: —¿Ix nebꞌa jun riꞌix chike ri na jinta kinaꞌoj puwi waꞌ? ¿Na kimaj ta nebꞌa usukꞌ e ri kachꞌulan ri ranimaꞌ ri tikawex na e ta ri kutij bꞌi? ");
INSERT INTO acrNNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Ma e janipa ri kutij bꞌi, riꞌ na kok ta chupa ri ranimaꞌ; xa chupa rupa keꞌek wi. Tekꞌuchiriꞌ, kuꞌpamaj bꞌi —xchaꞌ. Rukꞌ waꞌ ri Jesús xraj xubꞌiꞌij e ronoje taq ri re katijik, lik utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Je tanchi waꞌ xubꞌiꞌij chike: —E ri kel lo pa ranimaꞌ ri tikawex, e waꞌ ri kachꞌulan re. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Ma pa ranimaꞌ ri tikawex kel wi lo taq ritzel naꞌoj, ri makunik chirij ri kꞌulanikil, ri karetzꞌabꞌej uwa uqꞌij rukꞌ jun chik na ukꞌulel taj, ri kamisanik, ");
INSERT INTO acrNNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ri eleqꞌ, ri rayinik re puaq, ri retzelal kꞌuꞌxaj, ri sokosoꞌnik; ri rayibꞌal re ri tiꞌjil, ri kꞌax kꞌuꞌxaj chirij jun chik, ri itzel chꞌaꞌtem chirij junoq, ri kuꞌan nim chiribꞌil ribꞌ, ri na kuchꞌobꞌ tana saꞌ ri kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ronoje taq waꞌ wa itzel uwach, chupa ri ranimaꞌ ri tikawex kel wuloq y e kachꞌulan re rubꞌinik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xel bꞌi ri Jesús chiriꞌ y xopon pa taq ri luwar re Tiro y re Sidón. Xok kꞌu chuchiꞌ jun ja. Na xraj taj kꞌo ketaꞌman re we Rire kꞌo chiriꞌ; na rukꞌ ta kꞌu riꞌ, xketaꞌmaj ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Kꞌo kꞌu jun ixoq, e ri ralit kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. Xew xuto kꞌo ri Jesús chiriꞌ, xkꞌunik y xukꞌaq ribꞌ xeꞌraqan uqꞌabꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ekꞌu rixoq na kukꞌil ta ri aj judiꞌabꞌ yey alaxel pa ri luwar re Sirofenicia. Xelaj kꞌu che chaꞌ karesaj bꞌi ri itzel uxlabꞌixel che ri ralit. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ekꞌu ri Jesús xubꞌiꞌij che: —Chirajawaxik na nabꞌe kewaꞌik y kenoj ri e ralkꞌoꞌal ri rajaw ja, ma na usukꞌ taj we junoq kumaj ri kiwa ri ralkꞌoꞌal y kukꞌaq bꞌi chikiwa ri tzꞌiꞌ —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Rixoq xukꞌul uwach: —Qatzij, Qajawal, pero ¿na kewaꞌ ta nebꞌa ri tzꞌiꞌ rukꞌ rukꞌaj kiwa rakꞌalabꞌ katzaq chuxeꞌ ri mexa? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ri Jesús xubꞌiꞌij che: —Ruma wa xabꞌiꞌij, kanya chawe ri xatzꞌonoj. Jat kꞌu woꞌora ma ri itzel uxlabꞌixel elinaq chubꞌi che rawalit —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ekꞌuchiriꞌ xopon rixoq chirocho, xuꞌriqa ri ralit kotzꞌol chwa uwarabꞌal yey elinaq chubꞌi ri itzel uxlabꞌixel che. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ekꞌuchiriꞌ, xel tanchi ubꞌi ri Jesús che taq ri luwar re Tiro y xikꞌow pa ri tinamit Sidón. Xopon kꞌu chuchiꞌ ri mar re Galilea y xeꞌela pa taq ri luwar re Decápolis. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chiriꞌ xkikꞌam lo chwach ri Jesús jun achi tꞌoꞌk y kachꞌiqchꞌotik, yey ri ekꞌamayom loq xebꞌelaj che chaꞌ kuya ruqꞌabꞌ puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Ekꞌu ri Jesús xresaj bꞌi rachi chikixoꞌl ri winaq. Tekꞌuchiriꞌ xujuꞌ ruwi taq uqꞌabꞌ puxikin rachi y xukoj jubꞌiqꞌ ukꞌaxaj tzaꞌm ri raqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Xtzuꞌn chikaj, xukꞌis ukꞌuꞌx y jekꞌuwaꞌ xubꞌiꞌij che rachi: «¡Efata!» (Waꞌ pa ri chꞌaꞌtem arameo keꞌelawi “chatjaqatajoq”.) ");
INSERT INTO acrNNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Na jampatana kꞌu riꞌ, rachi xjaqataj ruxikin, xkiritaj ri raqꞌ y xujeqo kachꞌaꞌt chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ekꞌu ri Jesús lik xebꞌupixabꞌaj ri winaq chaꞌ na jinta kꞌana kꞌo kakitzijoj wi, noꞌj ri winaq tobꞌ ne kepixabꞌaxik, más ne xebꞌek che utzijoxik. ");
INSERT INTO acrNNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Lik kꞌu kakam kanimaꞌ ri winaq che y jewaꞌ kakibꞌiꞌij: «Ronoje ri kuꞌano lik utz, ma ri e tꞌoꞌk kuꞌan chike ketanik yey ri e meꞌt kuꞌan chike kechꞌawik.» ");
INSERT INTO acrNNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Chupa taq laꞌ la qꞌij xkimol kibꞌ ukꞌiyal tikawex. Y ruma na jinta kiwa re kakitijo, ri Jesús xebꞌusikꞌij rutijoꞌn y xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Lik kajuchꞌ kaꞌn nukꞌuꞌx chike wa tikawex ma e urox qꞌij waꞌ e kꞌo wukꞌ y na jinta chi kiwa. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Yey we e laꞌ kebꞌenutaq bꞌi chikocho y na jinta kꞌo kitijom, riꞌ kebꞌeꞌqꞌochqꞌobꞌ pa bꞌe, ma e kꞌo jujun chike lik naj e petinaq wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Rutijoꞌn xkibꞌiꞌij che: —Pero, ¿pa kariqitaj wi wa re ketzuq wa ukꞌiyal tikawex? Ma chupa wa luwar na jinta ne kꞌo e jeqelik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ri Jesús xutzꞌonoj kꞌu chike: —¿Janipa chi pam kꞌo iwukꞌ? —xcha chike. —Wuqubꞌ —xecha rike. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ewi ri Jesús xtaqan che ketzꞌuyiꞌ ri tikawex chuꞌlew. Xukꞌam kꞌu ri wuqubꞌ pam y xtioxin chwach ri Dios. Tekꞌuchiriꞌ, xuwechꞌ upa y xuya chike rutijoꞌn chaꞌ kakijach chike rukꞌiyal tikawex; y rike e xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Yey kukꞌaꞌam ne jujun raltaq ko kar. Ekꞌu ri Jesús xtioxin chwach ri Dios puwi waꞌ y xtaqan kꞌu che kajachiꞌ chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Xewaꞌ kꞌut y lik xenoj chi utz. Tekꞌuchiriꞌ, xmol ri chꞌaqaꞌtaꞌq kiqax y rukꞌ waꞌ xnoj wuqubꞌ chakach. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ri xewaꞌik, laj e juna kajibꞌ mil tikawex. Ekꞌu ri Jesús xebꞌuchꞌaꞌbꞌej kanoq, ");
INSERT INTO acrNNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","xok kꞌu bꞌi chupa ri barco kukꞌ rutijoꞌn y xebꞌek pa taq ri luwar re Dalmanuta. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Kꞌo jun qꞌij ri fariseos xebꞌopon rukꞌ ri Jesús y xkijeqo e laꞌ xa pa chꞌaꞌtem kakichap pa chꞌaꞌoj. Xkitzꞌonoj kꞌu che kuꞌan juna kꞌutubꞌal re chilaꞌ chikaj chikiwach chaꞌ kaqꞌalajinik we Rire taqom lo ruma ri Dios; waꞌ xkiꞌano xa re kꞌambꞌal upa. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ekꞌu ri Jesús lik xukꞌis ukꞌuꞌx y xubꞌiꞌij chike: «¿Suꞌbꞌe ri tikawex re waqꞌij ora e kakitzꞌonoj kanꞌan juna kꞌutubꞌal chaꞌ kaqꞌalajinik we intaqom lo ruma ri Dios? Paqatzij wi kambꞌiꞌij chiwe: Na jinta juna kꞌutubꞌal kayaꞌtaj chike» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Ewi xebꞌuya kanoq, xok tanchi ubꞌi chupa ri barco y xqꞌax chꞌaqa yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Ekꞌu rutijoꞌn ri Jesús xikꞌow chikikꞌuꞌx kakikꞌam bꞌi pam y xa jun chi pam kꞌo kukꞌ chupa la barco. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ewi ri Jesús xebꞌupixabꞌaj, jewaꞌ xubꞌiꞌij chike: «Lik chichajij iwibꞌ chwa ri “levadura” ke ri fariseos y chwa ri “levadura” re ri Herodes» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Rutijoꞌn xkibꞌiꞌij kꞌu chikiwach: «Kubꞌiꞌij waꞌ ma retaꞌam na jinta pam xqakꞌam loq» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ri Jesús xretaꞌmaj saꞌ la kakichꞌaꞌtibꞌej chikiwach y xubꞌiꞌij kꞌu chike: —¿Suꞌbꞌe kichꞌaꞌtibꞌej chiwach puwi ri na xikꞌam ta lo pam? ¿Kꞌamajaꞌ nebꞌa kimaj usukꞌ? ¿Lik kami kꞌa chꞌuqutal rinaꞌoj? ");
INSERT INTO acrNNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Kꞌo waꞌ kꞌu iwach yey e pachaꞌ na kixtzuꞌn taj. Kꞌo waꞌ kꞌu ixikin yey e pachaꞌ na kixtan taj. ¿Lik nebꞌa na kakꞌun ta chikꞌuꞌx ");
INSERT INTO acrNNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","echiriꞌ xinjach ri woꞌobꞌ pam chike ri woꞌobꞌ mil tikawex? ¿Janipa kꞌu chakach xinojisaj rukꞌ ri kiqax? —xchaꞌ. Rutijoꞌn xkikꞌul uwach: —Kabꞌlajuj chakach —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Xutzꞌonoj tanchi chike: —Yey echiriꞌ xinjach ri wuqubꞌ pam chike ri kajibꞌ mil tikawex, ¿janipa lo chakach xinojisaj rukꞌ ri kiqax? —xchaꞌ. Rike xkikꞌul uwach: —Wuqubꞌ chakach —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jekꞌuwaꞌ xukꞌisbꞌej kukꞌ: —¿Suꞌbꞌe kꞌu riꞌ kꞌamajaꞌ kꞌana kimaj usukꞌ? —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Tekꞌuchiriꞌ, xebꞌopon pa ri tinamit Betsaida. Taq ri winaq xkikꞌam lo jun potzꞌ chwa ri Jesús y xebꞌelaj kꞌu che chaꞌ kukunaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ekꞌu ri Jesús xuchap ruqꞌabꞌ ri potzꞌ, xresaj bꞌi chupa ri tinamit y xchubꞌan che taq ruwach. Tekꞌuchiriꞌ, xuya ruqꞌabꞌ puwiꞌ y xutzꞌonoj che we karil kꞌenoq. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ri potzꞌ xtzuꞌn pana chwach y xubꞌiꞌij: —Kebꞌenuwil rachijabꞌ pachaꞌ chi e cheꞌ kebꞌinik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ri Jesús xuya tanchi ruqꞌabꞌ puwi ruwach ri potzꞌ. Jekꞌulaꞌ ri potzꞌ xkunutajik y utz xtzuꞌnik. Xtzuꞌn kꞌu pana naj y xril ronoje chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Tekꞌuchiriꞌ ri Jesús xutaq bꞌi chirocho y jewaꞌ xubꞌiꞌij che: —Matok bꞌi pa ri tinamit y matzijoj ne kꞌana che junoq e riꞌin xatinkunaj —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ri Jesús kukꞌ rutijoꞌn xebꞌek pa taq ri aldeas re ri tinamit Cesarea re Filipo. Yey chupa kꞌu ri bꞌe, ri Jesús xutzꞌonoj chike rutijoꞌn: —Chikiwa ri winaq, ¿in china nawi riꞌin? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Rike xkikꞌul uwach che: —Kꞌo kebꞌiꞌn re, lal ri Juan Aj Yaꞌl Bautismo; jujun chik kakibꞌiꞌij lal ri Elías; y jujun chik, lal junoq chike taq ri qꞌalajisanelabꞌ re ojertan —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Tekꞌuchiriꞌ, xutzꞌonoj chike: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. Ri Pedro xukꞌul uwach: —Rilal lal ri Cristo, Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ewi ri Jesús xebꞌutaq che na kakitzijoj ta che junoq china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Xujeq kꞌu ubꞌiꞌxikil chike: «Lik chirajawaxik che Ralaxel Chikixoꞌl Tikawex kutij na ri kꞌax y kakꞌaq bꞌi uqꞌij kuma ri nimaq winaq re ri tinamit, ri nimaq e aj chakunel pa Rocho Dios y raj kꞌutunel re ri tzijpixabꞌ. Tekꞌuchiriꞌ, kakamisaxik; noꞌj churox qꞌij kakꞌastaj loq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Waꞌ xuqꞌalajisaj chi utz chike. Ekꞌu ri Pedro xresaj bꞌi ri Jesús chikixoꞌl y xuchꞌaꞌbꞌej upa ruma ri xubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Noꞌj ri Jesús xutzuꞌ lo kiwach rutijoꞌn y xuchꞌaꞌbꞌej kꞌu upa ri Pedro, jewaꞌ xubꞌiꞌij che: —¡Chatel chinuwach, Satanás! Ma riꞌat na e ta kachꞌobꞌ puwi ri uchꞌobꞌom lo ri Dios, xew e kachꞌobꞌ jelaꞌ pachaꞌ ri kakichꞌobꞌ ri winaq —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ekꞌuchiriꞌ, xebꞌusikꞌij ri winaq y rutijoꞌn, y jekꞌuwaꞌ xubꞌiꞌij chike: «We kꞌo junoq karaj katerej lo chwij, lik chirajawaxik che muꞌan xew ri karaj rire, e chukuyu ri kꞌax kape puwiꞌ ruma ukojom ri nubꞌiꞌ yey tereja lo chwij. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Ma china ri na kuya ta ranimaꞌ rukꞌaslem, riꞌ e kujam ri chomilaj kꞌaslemal chwach ri Dios; noꞌj ri kuya ranimaꞌ rukꞌaslem wuma riꞌin y ruma ri Utzilaj Tzij, riꞌ e kuriq ri chomilaj ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Ma ¿saꞌ kꞌu kutiqoj riꞌ che ri tikawex we kuꞌan rajaw ronoje ruwachulew yey kusach kꞌu uwach rukꞌaslemal? ");
INSERT INTO acrNNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿O kꞌo nawi rajil kutoj rachi chwa rukꞌaslemal chaꞌ na kujam taj? ¡Na jintaj! ");
INSERT INTO acrNNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","»Mixkꞌix kꞌu chwe riꞌin y che ri nuchꞌaꞌtem chikiwach raj makibꞌ re waqꞌij ora, ri na jusukꞌ ta ri kanimaꞌ chwach ri Dios. Ma ri kaꞌanaw waꞌ, ri in Alaxel Chikixoꞌl Tikawex kinkꞌix che rire echiriꞌ kinkꞌun lo rukꞌ runimal uchomalil ri Nuqaw y kukꞌ taq ri santowilaj ángeles» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Tekꞌuchiriꞌ, xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij chiwe: E kꞌo jujun chike wa e kꞌo wara, na kekam tana we na xkil tubꞌi rukꞌunibꞌal rutaqanik ri Dios rukꞌ unimal chuqꞌabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Waqibꞌ qꞌij kꞌu ubꞌiꞌxikil riꞌ waꞌ, echiriꞌ ri Jesús xebꞌuchaꞌ ri Pedro, ri Jacobo y ri Juan y xebꞌukꞌam bꞌi kitukel chwa jun nimalaj juyubꞌ. Chilaꞌ kꞌut xjalkꞌatitaj uwach ri Jesús chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Ruqꞌuꞌ lik kawolqꞌinik, xuꞌan lik saq pachaꞌ ri nieve; rusaqil xilitajik na jinta kꞌo kaꞌanaw re che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xaqikꞌateꞌt kꞌut chikiwach xewinaqir ri Elías y ri Moisés, qꞌalajisanelabꞌ re ojertan; e riꞌ kechꞌaꞌt rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ekꞌu ri Pedro xubꞌiꞌij che ri Jesús: —Qajawal, lik utz xyaꞌtaj chiqe riꞌoj oj kꞌo wara. Qaꞌana oxibꞌ rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ri Pedro xubꞌiꞌij waꞌ ruma na kunaꞌ taj saꞌ ri kubꞌiꞌij, ma rire kukꞌ ri kebꞌ chik rachbꞌiꞌil lik kixiꞌim kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ekꞌuchiriꞌ, xqaj lo jun sutzꞌ y xuꞌan muꞌj pakiwiꞌ. Chupa kꞌu riꞌ ri sutzꞌ xkita ruqul ri Dios, jewaꞌ xubꞌiꞌij: «E Nukꞌajol waꞌ ri lik kꞌax kannaꞌo; e chita utzij Rire» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Kꞌate kꞌu xkilo, xew chi ri Jesús kꞌo kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Echiriꞌ xeqaj lo chwa ri juyubꞌ, ri Jesús xebꞌutaq che na kakitzijoj ta kꞌana che junoq janipa ri xkilo; kꞌate kakitzijoj echiriꞌ Ralaxel Chikixoꞌl Tikawex kꞌastajinaq chi lo chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ekꞌu rike lik xkikꞌol pa kanimaꞌ ri xbꞌiꞌx chike y xkijeq kakitzꞌonobꞌej chikiwach puwi saꞌ keꞌelawi ri kꞌastajibꞌal lo re Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ekꞌuchiriꞌ, xkitzꞌonoj che ri Jesús: —¿Suꞌbꞌe raj kꞌutunel re ri tzijpixabꞌ kakibꞌiꞌij lik chirajawaxik nabꞌe na kakꞌun ri Elías chwach pan rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ekꞌu ri Jesús xukꞌul uwach: —Qatzij, lik chirajawaxik nabꞌe na kakꞌun ri Elías y kuyijbꞌaꞌ pan ronoje chwach rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. Pero ¿saꞌ kichꞌobꞌ riꞌix puwi ri tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios? Ma kubꞌiꞌij lik chirajawaxik na, Ralaxel Chikixoꞌl Tikawex kutij kꞌax y na jinta uqꞌij kaꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Noꞌj kꞌu riꞌin kanqꞌalajisaj waꞌ chiwe: Ri Elías ya xkꞌunik yey ri winaq xkiꞌan che janipa ri xkaj rike, jelaꞌ pachaꞌ ri tzꞌibꞌital kan puwi rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Echiriꞌ xebꞌopon pa e kꞌo wi kan ri jujun chik utijoꞌn, xkilo e kꞌo ukꞌiyal winaq kisutum kij yey raj kꞌutunel re ri tzijpixabꞌ kekichapalaꞌ che chꞌaꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Konoje kꞌu ri winaq lik xekiꞌkotik echiriꞌ xkil ri Jesús. Kebꞌanik xeꞌkikꞌuluꞌ apanoq y xkiya rutzil uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Xutzꞌonoj kꞌu Rire chike: —¿Saꞌ puwi kachapalaꞌ wi ibꞌ alaq kukꞌ rike? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Kꞌo kꞌu jun chikixoꞌl rukꞌiyal winaq jewaꞌ xukꞌul uwach: —Lal tijonel, nukꞌamom lo ri nukꞌajol chiwach la, ma rire kꞌo puqꞌabꞌ jun itzel uxlabꞌixel uꞌanom meꞌt che. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Xa tobꞌ pa kuchap wi, kukꞌaq pulew. Ekꞌuchiriꞌ, rala kujeq kapuluwan rukꞌaxaj, kaqichꞌichꞌ ruwi taq reꞌ y kakanaj kan junchi chukꞌuchik. Xintzꞌonoj kꞌu chike ri tijoꞌn la chaꞌ kakesaj bꞌi ri itzel uxlabꞌixel, pero rike na xkichꞌij ta resaxik bꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ekꞌu ri Jesús xukꞌul uwach, jewaꞌ xubꞌiꞌij chike: —¡E ri ix tikawex re waqꞌij ora, na kubꞌul ta kꞌana ikꞌuꞌx wukꞌ! ¿Janipa chi lo qꞌij kajawaxik kinkꞌojiꞌ iwukꞌ chaꞌ kakubꞌiꞌ ikꞌuꞌx wukꞌ? ¿Janipa chi lo qꞌij kixinkuyu e laꞌ jelaꞌ iꞌanom? Chikꞌama lo rala wara —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xkikꞌam kꞌu lo rala chwach. Ekꞌu ri itzel uxlabꞌixel echiriꞌ xril uwach ri Jesús, lik ko xujabꞌajaꞌ rala. Ekꞌu rala xtzaq pulew y xujeqo kubꞌalkatilaꞌ ribꞌ, kapuluwan rukꞌaxaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ri Jesús xutzꞌonoj kꞌu che ruqaw rala: —¿Jampa ujeqom lo waꞌ che? —xchaꞌ. Rachi xukꞌul uwach: —Chuchꞌutiꞌnal upetebꞌem loq. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ukꞌiyal laj ukꞌaqom pa aqꞌ y pa yaꞌ re kamisaxik uwach. We kꞌo ko paqꞌabꞌ la katoꞌ la, kꞌutu ko ri kꞌaxnaꞌbꞌal kꞌuꞌx la chiqe y chojtoꞌo la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ri Jesús xukꞌul uwach: —¿Suꞌbꞌe kabꞌiꞌij la chwe we kꞌo panuqꞌabꞌ kanꞌan waꞌ? Ma we kꞌo junoq lik kubꞌul ukꞌuꞌx wukꞌ, ronoje kel pana rukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Ekꞌu ruqaw rala na jampatana ko xchꞌawik, jewaꞌ xubꞌiꞌij: —Kubꞌul nukꞌuꞌx ukꞌ la, xew chintoꞌo ko la chaꞌ kanimar ri kubꞌulibꞌal nukꞌuꞌx —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ekꞌu ri Jesús echiriꞌ xrilo katajin kimolotajik rukꞌiyal winaq, xtaqan puwi ri itzelilaj uxlabꞌixel, jewaꞌ xubꞌiꞌij che: —Itzelilaj uxlabꞌixel, ri aꞌanom meꞌt y tꞌoꞌk che waꞌla, riꞌin katintaqo: Jat, chatelubꞌi y mat-tzelej chi lo kꞌana rukꞌ —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ewi ri itzel uxlabꞌixel xsikꞌinik y lik ko xujabꞌajaꞌ rala; tekꞌuchiriꞌ, xel bꞌi. Ekꞌu rala xkanaj kanoq pachaꞌ kaminaq chik. Ruma riꞌ, lik e kꞌi ri xebꞌiꞌn re: «Ya xkamik» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Pero ri Jesús xuchap ruqꞌabꞌ, xuyako; y rala xtakꞌiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ekꞌuchiriꞌ, xok bꞌi ri Jesús chuchiꞌ jun ja. Ekꞌu rutijoꞌn xechꞌaꞌt rukꞌ xa kitukel chik, jewaꞌ xkitzꞌonoj che: —¿Suꞌbꞌe riꞌoj na xqachꞌij tubꞌi resaxik waꞌ wa itzel uxlabꞌixel? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ri Jesús xukꞌul uwach: —E taq waꞌ wa juchꞌobꞌ itzel uxlabꞌixel, xew utz kebꞌesax bꞌi rukꞌ oración y ayuno —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Echiriꞌ xebꞌel bꞌi chiriꞌ, xebꞌikꞌow pa taq ri luwar re Galilea. Pero ri Jesús na xraj taj kꞌo ketaꞌman re, ");
INSERT INTO acrNNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ma kakꞌutun chikiwach rutijoꞌn. Jekꞌuwaꞌ kubꞌiꞌij chike: «Ralaxel Chikixoꞌl Tikawex kayaꞌiꞌ pakiqꞌabꞌ rachijabꞌ y kakamisax kuma, noꞌj echiriꞌ kaminaq chik, kakꞌastaj lo churox qꞌij» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ekꞌu rutijoꞌn na xkimaj ta usukꞌ la kubꞌiꞌij chike, yey kakixiꞌij kibꞌ kakitzꞌonoj che ri Jesús saꞌ keꞌelawi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xebꞌopon kꞌu chupa ri tinamit Capernaúm y echiriꞌ e kꞌo chi chuchiꞌ jun ja, xutzꞌonoj chike rutijoꞌn: —¿Saꞌ puwi kichapalaꞌ wi iwibꞌ chiwach echiriꞌ kixtajin lo chi bꞌe? —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Yey na jinta kꞌu junoq chike xchꞌawik; ma echiriꞌ kꞌa ketajin lo chi bꞌe, e kakichapalaꞌ kibꞌ chikiwach puwiꞌ chinoq chike kayaꞌiꞌ más uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ewi ri Jesús xtzꞌuyiꞌik, xebꞌusikꞌij ri kabꞌlajuj utijoꞌn y xubꞌiꞌij chike: —We kꞌo junoq karaj e rire ri kakꞌojiꞌ nabꞌe chikiwach konoje, riꞌ chirajawaxik che e kakanaj kan pa kꞌisbꞌal chike konoje y kuya ribꞌ kebꞌunimaj —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Xukꞌam kꞌu jun ralko kꞌoꞌm y xuya chikinikꞌajal rike. Xuqꞌaluj kꞌut y jewaꞌ xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—China ri kukꞌul chupa ri nubꞌiꞌ junoq na jinta uwach pachaꞌ wa ralko kꞌoꞌm, e junam rukꞌ in ri kinukꞌulu; yey china ri kakꞌuluw we riꞌin, na xew ta kinukꞌul riꞌin, ma e kukꞌul ri Jun taqayom lo we riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ekꞌu ri Juan xubꞌiꞌij che ri Jesús: —Qajawal, xqil jun achi kebꞌeresaj bꞌi itzel uxlabꞌixel chupa ri bꞌiꞌ la yey rire na qukꞌil taj. Ekꞌu riꞌoj xqabꞌiꞌij che muꞌan chi waꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ri Jesús xukꞌul uwach: —We kꞌo kaꞌanaw waꞌ, miqꞌatej, ma na jinta junoq kuꞌan juna milagro chupa ri nubꞌiꞌ yey pa joqꞌotaj kꞌu riꞌ kachꞌaꞌt lo chwij. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ma china ri na kachꞌoꞌjin ta chiqij, riꞌ e qukꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","China ri kusipaj juna tzima iyaꞌ chupa ri nubꞌiꞌ ruma ix re ri Cristo, paqatzij wi kambꞌiꞌij chiwe, riꞌ na kujam ta kꞌana ri rajil ukꞌaxel. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","»Noꞌj china ri kumin pa mak junoq chike wa chꞌutiꞌq kubꞌul kikꞌuꞌx wukꞌ, e ne más utz katzayabꞌax bꞌi puqul juna nimalaj kaꞌ re keꞌem y kakꞌaq kꞌu bꞌi chupa ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","»We raqꞌabꞌ e katzaqisan awe pa mak, chaqꞌata bꞌi. Ma xa ne kuya tobꞌ at tꞌum katopon pa ri kꞌaslemal chilaꞌ chikaj, chwa ri kꞌo ukabꞌichal raqꞌabꞌ yey katkꞌaq bꞌi chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax, chupa ri aqꞌ na jinta chi uchupik ");
INSERT INTO acrNNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","pa na kekam ta wi ramoloy ketijow ke waꞌ wa winaq ekaminaq, yey ri aqꞌ na jinta chi uchupik. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","»Yey we rawaqan e katzaqisan awe pa mak, chaqꞌata bꞌi. Ma xa ne kuya tobꞌ at jetzꞌ katopon pa ri kꞌaslemal chilaꞌ chikaj, chwa ri kꞌo ukabꞌichal rawaqan yey katkꞌaq bꞌi chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax, chupa ri aqꞌ na jinta chi uchupik ");
INSERT INTO acrNNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","pa na kekam ta wi ramoloy ketijow ke waꞌ wa winaq ekaminaq, yey ri aqꞌ na jinta chi uchupik. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","»Yey we rawach e katzaqisan awe pa mak, chawesaj bꞌi. Ma xa ne kuya ri xa jun rawach katok pa rutaqanik ri Dios, chwa ri kꞌo ukabꞌichal rawach yey katkꞌaq bꞌi chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax ");
INSERT INTO acrNNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","pa na kekam ta wi ramoloy ketijow ke waꞌ wa winaq ekaminaq, yey ri aqꞌ na jinta chi uchupik. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","»Chirajawaxik kꞌut konoje kakꞌam na kipa, pachaꞌ kebꞌikꞌowisax pa aqꞌ. E pachaꞌ ri kaꞌan rukꞌ ronoje qasaꞌn kayaꞌiꞌ chwach ri Dios: kakowisax ruma ratzꞌam. ");
INSERT INTO acrNNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","E ratzꞌam lik kajawaxik, noꞌj we xsach rutzayul, ¿suꞌanik tanchi kaꞌan tza che? Chirajawaxik kꞌut lik kꞌo kutiqoj ribꞌinik isilabꞌik riꞌix jelaꞌ pachaꞌ ratzꞌam lik kuriq uchak. Kꞌola kꞌu rutzil chomal chiwach chijujunal —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ri Jesús xel bꞌi che ri tinamit Capernaúm y xeꞌek pa taq ri luwar re Judea y che taq ri luwar kꞌo chꞌaqa yaꞌ che ri nimayaꞌ Jordán. E taq kꞌu ri winaq xkimol kibꞌ rukꞌ, y Rire xujeq kakꞌutun chikiwach pachaꞌ ri xex kuꞌan wi. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Xeqibꞌ kꞌu ri fariseos rukꞌ y xkiꞌan jun tzꞌonobꞌal che xa re kꞌambꞌal upa: —¿Yaꞌtal nawi puqꞌabꞌ juna achi kuya bꞌi ruwujil re jachbꞌal ibꞌ che ri rixoqil? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ekꞌu ri Jesús xukꞌul uwach: —¿Saꞌ kubꞌiꞌij ri taqanik xuꞌan kan ri Moisés che alaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Rike xkibꞌiꞌij: —Ri Moisés xuya luwar che rachi kuya bꞌi ruwujil re jachbꞌal ibꞌ che ri rixoqil y jekꞌulaꞌ na rixoqil ta chik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ri Jesús xubꞌiꞌij chike: —Xutzꞌibꞌaj ne kan riꞌ waꞌ wa jun taqanik ma e ruma lik ko ri animaꞌ alaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Noꞌj Ruchꞌaꞌtem ri Dios kubꞌiꞌij: Che ri jeqebꞌal lo ruwachulew echiriꞌ ri Dios xebꞌuꞌan ri tikawex, chi achi chi ixoq xebꞌuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Y kubꞌiꞌij: Ruma kꞌu riꞌ, rachi echiriꞌ kakꞌuliꞌik, karesaj ribꞌ chikij ruchu-uqaw chaꞌ kajeqiꞌ rukꞌ ri rixoqil; ");
INSERT INTO acrNNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","y kikabꞌichal kꞌu riꞌ kebꞌuꞌana xa e jun chwach ri Dios kachaꞌ. Jekꞌuriꞌlaꞌ, na e ta chi kaꞌibꞌ ma xebꞌuꞌana xa e jun. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","E uwariꞌche, ri xebꞌujunimaj ri Dios, na yaꞌtal ta che ri tikawex kujach kipa —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Ekꞌuchiriꞌ e kꞌo chi chiꞌja, rutijoꞌn xkitzꞌonoj tanchi che puwi wa xutzijoj. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ri Jesús xubꞌiꞌij chike: —E junoq kuya ruwujil re jachbꞌal ibꞌ che ri rixoqil yey kakꞌuliꞌ tanchi rukꞌ juna chik ixoq, riꞌ kamakun chwach ri Dios chirij ri nabꞌe rixoqil. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Jekꞌulaꞌ rixoq, we kuya ruwujil re jachbꞌal ibꞌ che ri rachijil yey kakꞌuliꞌ tanchi rukꞌ juna chik achi, riꞌ jenelaꞌ kamakun chirij ri kꞌulanikil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","E kꞌo jujun raltaq ko akꞌalabꞌ xekꞌam lo chwach ri Jesús chaꞌ kuya ruqꞌabꞌ pakiwiꞌ. Noꞌj rutijoꞌn xekiyaj ri ekꞌamayom lo ke. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ri Jesús, echiriꞌ xril waꞌ, xpe royowal y jewaꞌ xubꞌiꞌij chike: «Chiyaꞌa luwar chike ri raltaq ko akꞌalabꞌ chepeta na wukꞌ. Mebꞌiqꞌatej; ma ri kakiꞌan e jelaꞌ pachaꞌ rike, riꞌ kuꞌan ke rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Paqatzij wi kambꞌiꞌij chiwe: China ri na kukꞌul ta rutaqanik ri Dios jelaꞌ pachaꞌ kuꞌan juna ralko kꞌoꞌm, riꞌ na kok ta chupa» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Tekꞌuchiriꞌ, xebꞌuqꞌaluj ri raltaq ko akꞌalabꞌ, xuya ruqꞌabꞌ pakiwiꞌ y xebꞌuꞌan bendecir. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Echiriꞌ katajin bꞌi relik ri Jesús re kumaj tanchi ubꞌi rubꞌe, kakꞌalalik xopon jun rukꞌ, xuxukubꞌaꞌ ribꞌ chwach y xutzꞌonoj kꞌu che: —Lal utzilaj tijonel, ¿saꞌ ri kanꞌano chaꞌ kꞌo nukꞌaslemal na jinta utaqexik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ri Jesús xukꞌul uwach: —¿Suꞌbꞌe kabꞌiꞌij la “utz” chwe? Ma xa jun ri lik utz kꞌolik, waꞌ e ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Rilal etaꞌam chi la saꞌ taq Rutzij Upixabꞌ ri Dios: “Matmakun chirij ri kꞌulanikil. Matkamisanik. Mateleqꞌik. Maꞌan raqꞌubꞌal chirij junoq. Makꞌo maꞌan xa rukꞌ sokosoꞌnik. Chaloqꞌoj kiqꞌij rachu-aqaw” —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Rachi xukꞌul uwach: —Lal tijonel, ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ewi ri Jesús xutzuꞌ uwach y lik xjuchꞌ kan ukꞌuꞌx che. Xubꞌiꞌij kꞌu che: —Xa jun chi ri lik chirajawaxik wi kaꞌan la: Oj la, kꞌayij la ronoje taq ri bꞌeyomalil la y jacha kꞌu la chike ri nibꞌaꞌibꞌ; jekꞌuriꞌlaꞌ kꞌo bꞌeyomalil la chilaꞌ chikaj. Tekꞌuchiriꞌ, peta la, terej lo la chwij y kuyu la ri kꞌax kape pawiꞌ la ruma lal nutijoꞌn —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ekꞌu rachi lik xuchap ranimaꞌ che ri xubꞌiꞌij ri Jesús; lik kabꞌisonik xeꞌek, ma rire lik rajawal bꞌeyom. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Tekꞌuchiriꞌ, ri Jesús xebꞌutzuꞌ konoje y xubꞌiꞌij chike rutijoꞌn: —Ri e bꞌeyomabꞌ lik kꞌayew chike kebꞌok chupa rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Rutijoꞌn ri Jesús lik xkam kanimaꞌ che wa xubꞌiꞌij. Rire xubꞌiꞌij kꞌu chike: —Ix walkꞌoꞌal, e janipa ri lik kikubꞌam kikꞌuꞌx rukꞌ ri kibꞌeyomalil, lik kꞌayew chike kebꞌok chupa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","E ne más kꞌayew kok juna bꞌeyom chupa rutaqanik ri Dios chwa ri kikꞌow juna camello chupa rutel juna akuxaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Rike lik xkam kanimaꞌ che waꞌ y xkibꞌiꞌij kꞌu chikiwach: «We e riꞌ, ¿china kꞌu riꞌ ri kakolobꞌetajik?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ekꞌu ri Jesús xutzuꞌ kiwach, xubꞌiꞌij chike: —Ri tikawex na kakikolobꞌej ta kibꞌ kitukel ma waꞌ lik kꞌayew chikiwach, noꞌj ri Dios ronoje kuꞌano ma na jinta kꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ekꞌu ri Pedro xujeq ubꞌiꞌxikil che ri Jesús: —Qajawal, e riꞌoj qayaꞌom kan ronoje y oj teran chiꞌij la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ri Jesús xubꞌiꞌij: —Paqatzij wi kambꞌiꞌij chiwe: China ri uyaꞌom kan rocho, ebꞌuyaꞌom kan ri ratz-uchaqꞌ, ruchu-uqaw, ri rixoqil, ri ralkꞌoꞌal o rulew, ruma ukojom ri nubꞌiꞌ riꞌin y ruma rutzijoxik ri Utzilaj Tzij, ");
INSERT INTO acrNNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","riꞌ kukꞌul wara che ruwachulew chupa taq wa qꞌij oj kꞌo wi, jun ciento ri rajil ukꞌaxel ruma taq ri uyaꞌom kanoq, tobꞌ lik kutij kꞌax ruma waꞌ. Yey chwach kꞌu apanoq kukꞌul na ri kꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Lik kꞌu e kꞌi chike ri lik kꞌo kiwach woꞌora, chwach apanoq na jinta chi kiwach; yey lik e kꞌi chike ri na jinta kiwach woꞌora, e lik kakꞌojiꞌ kiwach chwach apanoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ekꞌu riꞌ kimajom bꞌi ri bꞌe re kepaqiꞌ Jerusalem, yey ri Jesús nabꞌe bꞌi chikiwach. Ekꞌu rutijoꞌn lik sachinaq kinaꞌoj y rukꞌ xiꞌin ibꞌ eteran chirij. Ekꞌuchiriꞌ, ri Jesús xebꞌukꞌam tanchi ubꞌi kitukel ri kabꞌlajuj utijoꞌn y xujeq ubꞌiꞌxikil chike saꞌ taq ri karikꞌowibꞌej. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Jewaꞌ xubꞌiꞌij: —Chitapeꞌ: E waꞌ kojpaqiꞌ Jerusalem, yey Ralaxel Chikixoꞌl Tikawex kayaꞌ na pakiqꞌabꞌ ri nimaq e aj chakunel pa Rocho Dios y raj kꞌutunel re ri tzijpixabꞌ, chaꞌ kakiqꞌat tzij puwiꞌ re kamik y kakiya pakiqꞌabꞌ ri winaq na e ta aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Kachꞌamix kꞌu riꞌ, kajichꞌ upa, kachubꞌaxik y kakamisaxik. Noꞌj churox qꞌij kakꞌastaj bꞌi chikixoꞌl ri ekaminaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ekꞌu ri Jacobo y ri Juan, ri kebꞌ ukꞌajol ri Zebedeo, xeqibꞌ rukꞌ ri Jesús y xkibꞌiꞌij che: —Qajawal, kaqaj kaꞌan ko la chiqe janipa wa kaqatzꞌonoj cheꞌla —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Saꞌ ri kiwaj kanꞌan chiwe? —xcha ri Jesús chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Rike xkibꞌiꞌij che: —E kaqaj riꞌoj kaya la chiqe chupa ri chomilaj taqanik la, jun chiqe katzꞌuyiꞌ pawikiqꞌabꞌ la yey ri jun chik pa mox la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ri Jesús xubꞌiꞌij kꞌu chike: —Riꞌix na iwetaꞌam taj saꞌ la kitzꞌonoj. ¿Kichꞌij nebꞌa riꞌix ri kinikꞌow wi riꞌin y ri kꞌax kape panuwiꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Rike xkibꞌiꞌij: —Kaqachꞌijo —xechaꞌ. Ri Jesús xubꞌiꞌij chike: —Qatzij, riꞌix kichꞌij na ri kꞌax kinikꞌow wi riꞌin y ri kꞌaxkꞌobꞌik kape panuwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Noꞌj kꞌu ri kixtzꞌuyiꞌ pa nuwikiqꞌabꞌ y pa numox, na in ta kinyaꞌw re, ma xew kayaꞌtaj chike ri echaꞌtal chik chaꞌ kuꞌana na ke —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Ri lajuj chik tijoꞌn, echiriꞌ xkita waꞌ, lik xpe koyowal chikij ri Jacobo y ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ekꞌu ri Jesús xebꞌusikꞌij y xubꞌiꞌij chike: —Iwetaꞌam riꞌix, ri ekojtalik e taqanelabꞌ pakiwi ri nimaq tinamit kebꞌuꞌana pachaꞌ e rajaw ronoje, yey ri lik kꞌo kiwach kikꞌow uwiꞌ ri taqanik kakiꞌan pakiwi ri eyaꞌtal pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Noꞌj chixoꞌl riꞌix na ubꞌe taj jelaꞌ kuꞌano. Ma we kꞌo junoq chiwe riꞌix karaj kuꞌana aj wach, e chuyaꞌa ribꞌ kuꞌan nimanel iweꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Yey e junoq chiwe karaj kuꞌana nabꞌe chixoꞌlibꞌal, e chuyaꞌa ribꞌ kuꞌan nimanel ke konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ma Ralaxel Chikixoꞌl Tikawex na xkꞌun taj re kanimaxik. Rire xkꞌunik re koꞌlnimanoq y re koluꞌyaꞌa ribꞌ pa kamik che kikolobꞌexik ukꞌiyal tikawex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ekꞌuchiriꞌ, ri Jesús kukꞌ rutijoꞌn xebꞌikꞌow chupa ri tinamit Jericó, y ukꞌiyal winaq xeterej bꞌi chirij. Echiriꞌ katajin bꞌi kelik chupa ri tinamit, xebꞌikꞌow pa tzꞌul wi ri Bartimeo, waꞌ e jun potzꞌ ukꞌajol ri Timeo. Rire e riꞌ kutzꞌonoj limoxna. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Ekꞌuchiriꞌ xuto e Jesús ri aj Nazaret ri katajin rikꞌowik, xujeqo kasikꞌinik: —¡Jesús, lal ri Ralkꞌoꞌal kan ri rey David, chinjuchꞌ kaꞌn ko cheꞌla! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ukꞌiyal winaq xkichꞌaꞌbꞌej upa chaꞌ na kasikꞌin ta chik, noꞌj rire más ne ko kasikꞌinik: —¡Lal ri Ralkꞌoꞌal kan ri rey David, chinjuchꞌ kaꞌn ko cheꞌla! —kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ekꞌu ri Jesús xtakꞌiꞌik y xutaq usikꞌixik ri potzꞌ. Ri xebꞌeꞌsikꞌin re xkibꞌiꞌij che: —¡Chanimarisaj akꞌuꞌx! ¡Chatyaktajoq! Ri Jesús katusikꞌij —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ri potzꞌ xukꞌaq kan ruqꞌuꞌ uripom chirij, xyaktajik y xopon pa kꞌo wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ri Jesús xubꞌiꞌij kꞌu che: —¿Saꞌ ri kawaj kanꞌan chawe? —xchaꞌ. Ri potzꞌ xukꞌul uwach: —Lal tijonel, kuaj kintzuꞌn tanchik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ekꞌu ri Jesús xubꞌiꞌij che: —Jat chi utzil chomal, ma ruma ri kubꞌulibꞌal akꞌuꞌx wukꞌ, at kunutajinaq chik —xchaꞌ. Chupa kꞌu riꞌ la joqꞌotaj, ri potzꞌ xtzuꞌnik y xterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ri Jesús kukꞌ rutijoꞌn xa naqaj chi e kꞌo lo che ri tinamit Jerusalem, ya e riꞌ kebꞌopon chwach ri juyubꞌ Olivos pa taq raldeas Betfagé y Betania. Ekꞌuchiriꞌ, ri Jesús xebꞌutaq bꞌi kaꞌibꞌ chike rutijoꞌn chaꞌ kenabꞌej apanoq, ");
INSERT INTO acrNNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","jewaꞌ xubꞌiꞌij chike: —Jix pa raldea kꞌo pan chiqawach. Xew kꞌu kixoponik, kiꞌriqa jun qꞌapoj buru yuqulik. Waꞌ na jinta junoq kojoyom re. Chikiraꞌ y chikꞌama loq. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We kꞌo kꞌu junoq kutzꞌonoj chiwe: “¿Suꞌchak kiꞌan waꞌ?”, chibꞌiꞌij che: “Rawaj kajawax che ri Qajawal, yey kꞌate kutaq tanchi uloq” —kixchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Xebꞌek kꞌut y xkiriq ri qꞌapoj buru yuqubꞌam pa bꞌe chunaqaj jun puerta. Ewi xkikir loq. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Jujun kꞌu chike ri e kꞌo chiriꞌ xkitzꞌonoj: —¿Saꞌ ri kiꞌano? ¿Suꞌbꞌe kikir ri qꞌapoj buru? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Rike e xkibꞌiꞌij janipa ri bꞌiꞌim bꞌi chike ruma ri Jesús; ewi xyaꞌ lo chike xkikir loq. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Xkikꞌam kꞌu lo ri qꞌapoj buru y xkirip ri kimanta chirij. Ekꞌu ri Jesús xukoj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ukꞌiyal winaq xkiwiq ri bꞌe pa kikꞌow wi ri Jesús, xkilikꞌ taq ri kimanta pa ri bꞌe; yey e kꞌo jujun chik xkiqꞌat raltaq ko uqꞌabꞌ cheꞌ y xkilem pa la bꞌe re yakbꞌal uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ri winaq e nabꞌejinaq chwach kukꞌ ri eteran lo chirij xkijeqo lik kesikꞌinik, kakibꞌiꞌij: «¡Qayaka uqꞌij! ¡Nim uqꞌij ralaxik ri jun petinaq chupa rubꞌiꞌ ri Dios Qajawxel! ");
INSERT INTO acrNNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Nim uwach uqꞌij ri taqanik re ri qamam David kakꞌun loq! ¡Qayaka uqꞌij ri Dios kꞌo chilaꞌ chikaj!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Xopon kꞌu ri Jesús Jerusalem y xok chupa ri Rocho Dios. Xa xril kꞌu ronoje saꞌ taq ri kꞌo chupa; pero ruma ya e riꞌ kok raqꞌabꞌ, xeꞌek Betania kukꞌ ri kabꞌlajuj utijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chukaꞌm qꞌij kꞌut echiriꞌ xebꞌel bꞌi Betania, ri Jesús xpe numik che. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Y chinimanaj xril pana jun cheꞌ re higo lik kꞌo uxaq. Ewi xeꞌek xeꞌrilaꞌ we kꞌo ujiqꞌobꞌalil kuriqo. Yey echiriꞌ xopon rukꞌ, na jinta kꞌo xuriq che, xew ruxaq kꞌolik, ma na uqꞌijol taj kꞌo uwach ri higos. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ewi ri Jesús xubꞌiꞌij che ri cheꞌ re higo: —Na jinta chi kꞌana junoq kutij jiqꞌobꞌal chawe —xchaꞌ. Yey wa xubꞌiꞌij, xkita rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Xebꞌopon kꞌu Jerusalem y echiriꞌ xok bꞌi ri Jesús chupa ri Rocho Dios, xujeq lo kesaxik konoje ri kekꞌayinik y ri keloqꞌow chupa. Yey xuxulkꞌatilaꞌ taq bꞌi ri mexa ke ri e aj jachal uwach puaq y taq ri xila ke ri e aj kꞌay palomax. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Y na xuya ta luwar che junoq kꞌo rukꞌaꞌam kikꞌow pa ri Rocho Dios xa re kuqꞌat ubꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Xujeq kꞌu kakꞌutun chikiwach, jewaꞌ kubꞌiꞌij: «¿Na etaꞌam ta nebꞌa alaq ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios? Ma ri Dios kubꞌiꞌij: Che ri Wocho kabꞌiꞌxik: “E luwar re oración ke konoje taq ri tinamit che ruwachulew” kachaꞌ. Noꞌj ralaq, ꞌanom alaq che ri Wocho e jun luwar ke eleqꞌomabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Waꞌ xkita raj kꞌutunel re ri tzijpixabꞌ y ri nimaq e aj chakunel pa Rocho Dios. Ruma kꞌu riꞌ, kakitzukuj saꞌ uꞌanik kakikamisaj ma kakixiꞌij kibꞌ che ruma konoje ri winaq lik kakam kanimaꞌ che taq rukꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ekꞌuchiriꞌ xok raqꞌabꞌ, ri Jesús xel bꞌi chupa ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Chukaꞌm qꞌij anim echiriꞌ xebꞌikꞌow ri Jesús kukꞌ rutijoꞌn pa kꞌo wi ri cheꞌ re higo, xkilo chaqijinaq lo kꞌa pa ratzꞌayaq. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ewi ri Pedro xkꞌun lo chukꞌuꞌx taq ri chꞌaꞌtem xubꞌiꞌij kan ri Jesús che ri cheꞌ. Xubꞌiꞌij kꞌu riꞌ che ri Jesús: —Wajawal, chilape la, ri cheꞌ re higo ri xbꞌiꞌij la che na kuya ta chi ujiqꞌobꞌalil, waꞌ chaqijinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ri Jesús xukꞌul uwach: —Lik kubꞌula ikꞌuꞌx rukꞌ ri Dios; ");
INSERT INTO acrNNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ma paqatzij wi kambꞌiꞌij chiwe: China junoq kabꞌiꞌn che wa jun juyubꞌ: “Chatela wara y jateꞌkꞌola chupa ri mar” yey lik kujikibꞌaꞌ kꞌu ukꞌuꞌx che la xubꞌiꞌij, riꞌ lik e kuꞌanaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Uwariꞌche kambꞌiꞌij chiwe: E janipa ri kitzꞌonoj che ri Dios yey kubꞌul kꞌu ikꞌuꞌx che kayaꞌtaj na chiwe, kikꞌul na kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Jekꞌulaꞌ, echiriꞌ kiꞌan orar, we kꞌo chikꞌuꞌx ri makunik re junoq chiwij, chikuyu umak chaꞌ jelaꞌ ri Qaqaw kꞌo chilaꞌ chikaj kukuy imak riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ma we riꞌix na kikuy ta umak junoq, jekꞌulaꞌ kuꞌan ri Qaqaw Dios kꞌo chilaꞌ chikaj, na kukuy ta imak riꞌix —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Xebꞌopon tanchi Jerusalem ri Jesús kukꞌ rutijoꞌn. Y echiriꞌ kabꞌin chupa ri Rocho Dios, ri nimaq e aj chakunel kukꞌ raj kꞌutunel re ri tzijpixabꞌ y ri nimaq winaq re ri tinamit, xeqibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Xkitzꞌonoj kꞌu che: —¿China xyaꞌw paqꞌabꞌ la kaꞌan taq la waꞌ? ¿China xtaqaw la che kaꞌan taq la waꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ri Jesús xukꞌul uwach: —Riꞌin kanꞌan jun tzꞌonobꞌal che alaq. We xkꞌul alaq uwach, kambꞌiꞌij kꞌu riꞌ che alaq china yaꞌyom panuqꞌabꞌ kanꞌan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","¿China kꞌu xtaqaw re ri Juan kuya ri bautismo? ¿E ri Dios o e rachijabꞌ? Kꞌulu alaq uwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ekꞌu rike xkijeq kechꞌaꞌt chikiwach puwi waꞌ: «We xqakꞌul uwach che: “E ri Dios xtaqaw re,” riꞌ kubꞌiꞌij rire chiqe: “¿Suꞌchak kꞌu riꞌ na xkoj ta alaq ri xubꞌiꞌij?” kacha chiqe. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿Yey we xqabꞌiꞌij xa achijabꞌ xetaqaw re...?» xecha chikiwach. Yey lik kakixiꞌij kibꞌ chike ri winaq, ma konoje kakichꞌobꞌo ri Juan e jun saqil qꞌalajisanel re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Xkibꞌiꞌij kꞌu che ri Jesús: —Na qetaꞌam taj —xechaꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike: —Jekꞌuriꞌlaꞌ, riꞌin na kambꞌiꞌij ta che alaq china yaꞌyom panuqꞌabꞌ kanꞌan taq waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Ekꞌuchiriꞌ, ri Jesús xujeq kakꞌutun chikiwach ri e aj wach rukꞌ taq kꞌambꞌal naꞌoj, xubꞌiꞌij chike: «Kꞌo jun achi xuꞌan tikoꞌn re uva chwach ri rulew. Xusut kꞌu rij rukꞌ coral, xukꞌot jun luwar pa kayitzꞌ wi ruwaꞌal ri uva y xuyak jun ja naj uwiꞌ re chajibꞌal re. Xuya kꞌu kan pa tunulik chike jujun aj chakibꞌ. Tekꞌuchiriꞌ, xeꞌek naj. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","»Echiriꞌ xopon ruqꞌijol ri molonik, xutaq lo jun raj chak chaꞌ kuꞌtzꞌonoj chike taq raj tunulel ri taqalik kukꞌul rire che ri molonik. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Noꞌj raj tunulel xkichap raj chak taqom lo kukꞌ, xkichꞌayo y xkitaq bꞌi; e riꞌ na jinta xkiya bꞌi che. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","»Ri rajaw ri tikoꞌn xutaq chi lo jun raj chak kukꞌ, yey raj tunulel xkiraqij rujolom rukꞌ abꞌaj y lik xkikꞌixbꞌesaj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ri rajaw ri tikoꞌn xutaq chi lo jun chik raj chak kukꞌ; ekꞌu riꞌ waꞌ asu xkikamisaj. Y xebꞌutaq chi lo jujun chik; yey chike konoje waꞌ, e kꞌo ri xekichꞌayo y e kꞌo ri xekikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","»Ekꞌu ri rajaw ri tikoꞌn xa jun chi ri kꞌo rukꞌ re kutaq bꞌi, e rukꞌajol lik kꞌax kunaꞌo. Kꞌisbꞌal kꞌu re, e xutaq lo rukꞌajol kukꞌ raj tunulel ma xuchꞌobꞌo: “Ruma e nukꞌajol, kakikꞌul na chi utz.” ");
INSERT INTO acrNNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","»Noꞌj raj tununel xkibꞌiꞌij chikiwach: “Waꞌ e ukꞌajol ri rajaw rulew, ri kuꞌana na rajaw we xkam ruqaw. Joꞌ, jeꞌqakamisaj chaꞌ rulew kuꞌan kan qeꞌoj” xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ewi xkichapo y xkikamisaj. Tekꞌuchiriꞌ, xkesaj bꞌi rucuerpo chupa waꞌ wuꞌlew y xeꞌkikꞌaqa bꞌi» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Tekꞌuchiriꞌ, xutzꞌonoj chike ri e aj wach: —Chiwach ralaq, ¿saꞌ nawi kuꞌan ri rajaw ri tikoꞌn chike raj tunulel? Riꞌin kambꞌiꞌij: Kakꞌunik, kusach kiwach raj tunulel y kuya rutikoꞌn pakiqꞌabꞌ jujun chik. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","»¿Na ajilam ta nebꞌa ralaq ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios? Ma jewaꞌ kubꞌiꞌij: E rabꞌaj kꞌaqital kan kuma raj yakal ja, e abꞌaj waꞌ lik xajawaxik chaꞌ katikiꞌ lo ri ja. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","E ri Dios Qajawxel xꞌanaw re waꞌ, yey chiqawach riꞌoj, waꞌ lik na jinta kꞌana ilitajinaq wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ekꞌu ri e aj wach lik xkitzukuj suꞌanik kakichap ri Jesús ma xkimaj usukꞌ chikij rike xubꞌiꞌij wi wa jun kꞌambꞌal naꞌoj. Pero ruma kꞌu kakixiꞌij kibꞌ chikiwach rukꞌiyal winaq, xkiya kanoq y xebꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xetaq kꞌu lo rukꞌ ri Jesús jujun chike ri fariseos y jujun chike ri kitaqem ri rey Herodes, re kakikꞌam upa rukꞌ taq ri kubꞌiꞌij chaꞌ kakikoj umak. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ekꞌuchiriꞌ, xebꞌopon rukꞌ ri Jesús y xkibꞌiꞌij che: —Lal tijonel, riꞌoj qetaꞌam lik qatzij ri kabꞌiꞌij la. Na kaxiꞌij ta ibꞌ la che taq ri kakibꞌiꞌij ri tikawex, ma rilal junam kiwach kebꞌil la konoje, tobꞌ kꞌo kiwach o na jinta kiwach; yey lik jusukꞌ kakꞌutun la chwi ri bꞌe re ri Dios. Kaqatzꞌonoj kꞌu cheꞌla: ¿Usukꞌ nawi kaqaꞌan tojonik che ri nimalaj taqanel re Roma o na usukꞌ taj? ¿Kaqaya nawi o na kaqaya taj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ekꞌu ri Jesús, ruma retaꞌam rike xa kebꞌ kipalaj, jewaꞌ xubꞌiꞌij chike: —¿Suꞌchak kakꞌam alaq nupa? Kꞌama pe lo alaq juna meyo re kaꞌan tojonik rukꞌ chaꞌ kanwilo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Rike xkikꞌam lo jun meyo che. Ewi ri Jesús xubꞌiꞌij chike: —¿China re wa kꞌaxwach y china re wa bꞌiꞌaj kꞌo chwach wa meyo? —xchaꞌ. Rike xkikꞌul uwach: —Re ri nimalaj taqanel re Roma —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ekꞌu ri Jesús xukꞌul uwach, xubꞌiꞌij chike: —Yaꞌa alaq che ri nimalaj taqanel re Roma janipa ri taqal che rire, yey yaꞌa kꞌu alaq che ri Dios janipa ri taqal che ri Dios —xchaꞌ. Lik kꞌu xkam kanimaꞌ che ri Jesús ma Rire lik xuriq ukꞌulik uwach ri tzꞌonobꞌal xkiꞌan che. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ekꞌuchiriꞌ, jujun chike ri saduceos, ri kakibꞌiꞌij na jinta kꞌastajibꞌal chike ri ekaminaq, xekꞌun rukꞌ ri Jesús y xkitzꞌonoj kꞌu che: ");
INSERT INTO acrNNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Lal tijonel, ri Moisés xutzꞌibꞌaj kan chiqe: “We ri ratz junoq kakamik y na e jinta kan ralkꞌoꞌal rukꞌ ri rixoqil, ekꞌu riꞌ ruchaqꞌ utz kakꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq y jekꞌulaꞌ kekꞌojiꞌ ralkꞌoꞌal rukꞌ pubꞌiꞌ ri ratz xkamik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","»Julaj e kꞌo wuqubꞌ achijabꞌ kichaqꞌ kibꞌ. Ri nabꞌe chike xkꞌuliꞌik, yey ekꞌu riꞌ waꞌ xkamik y na e jinta kan ralkꞌoꞌal rukꞌ ri rixoqil. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Jelaꞌ kꞌu riꞌ rukaꞌm xkꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq. Ekꞌu riꞌ waꞌ xkamik y na e jinta kan ralkꞌoꞌal rukꞌ rixoq. Yey je tanchi laꞌ xukꞌulumaj rurox. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Jekꞌulaꞌ xkikꞌulumaj ri wuqubꞌ achijabꞌ; xekamik, e riꞌ na jinta kalkꞌoꞌal xkiya kanoq. Kꞌisbꞌal kꞌu re, e xkam rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","»Chupa kꞌu ruqꞌijol ri kꞌastajibꞌal, echiriꞌ kekꞌastaj lo ri wuqubꞌ achijabꞌ, ¿chinoq chike kuꞌana rachijil rixoq? Ma konoje xekꞌuliꞌ rukꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ri Jesús xukꞌul uwach: —Ralaq lik sachinaq alaq, ma na majom ta alaq usukꞌ Ruchꞌaꞌtem ri Dios y ruchuqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Ma echiriꞌ kekꞌastaj lo ri ekaminaq, na kekꞌuliꞌ ta chik yey na kekiya ta chi ne ri kalkꞌoꞌal pa kꞌulanikil; kebꞌuꞌana kꞌu pachaꞌ ri ángeles e kꞌo chilaꞌ chikaj, ma ri ángeles na kekꞌuliꞌ taj. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","»Noꞌj puwi kꞌu ri kꞌastajibꞌal ke ri ekaminaq, ¿na ajilam ta nebꞌa alaq ri xutzꞌibꞌaj kan ri Moisés puwi ri xubꞌiꞌij ri Dios che echiriꞌ xchꞌaꞌt rukꞌ chupa ri jumokaj xulukej? Ma jewaꞌ xubꞌiꞌij che: “In ri Dios re ri Abraham, re ri Isaac y re ri Jacob” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yey ri Dios na e ta Dios ke ri ekaminaq, ma e Dios ke ri e kꞌaslik. E uwariꞌche ralaq lik na usukꞌ ta ri naꞌoj alaq puwi ri kꞌastajibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Ekꞌuchiriꞌ, xqibꞌ rukꞌ ri Jesús jun chike raj kꞌutunel re ri tzijpixabꞌ. Waꞌ waꞌchi xuto echiriꞌ ri Jesús lik xuriq ukꞌulik uwach ri tzꞌonobꞌal ke ri saduceos. Xutzꞌonoj kꞌu che: —Chupa Rutzij Upixabꞌ ri Dios, ¿pachike ri taqanik más chirajawaxik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ri Jesús xukꞌul uwach: —Rukꞌuꞌxibꞌal ronoje ri Tzij Pixabꞌ re ri Dios e waꞌ: Chitaꞌ, ix aj Israel; ri Dios Qajawxel, xa jun Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Kꞌax kꞌu chanaꞌa ra Dios Qajawxel rukꞌ ronoje awanimaꞌ, rukꞌ ronoje akꞌuꞌx, rukꞌ ronoje anaꞌoj y rukꞌ ronoje achuqꞌabꞌ. E ukꞌuꞌxibꞌal waꞌ Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Yey rukaꞌm jewaꞌ kubꞌiꞌij: Kꞌax chanaꞌa rawatz-achaqꞌ jelaꞌ pachaꞌ ri kꞌax kanaꞌ awibꞌ riꞌat. Na jinta chi kꞌu juna tzij más kꞌo uwach chwa taq waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jekꞌuwaꞌ xubꞌiꞌij raj kꞌutunel re ri tzijpixabꞌ che ri Jesús: —Lik utz, lal tijonel; lik qatzij ri kabꞌiꞌij la: “Xa jun ri Dios kꞌolik y na jinta junoq chik.” ");
INSERT INTO acrNNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Yey ri lik chirajawaxik wi e kꞌax kaqanaꞌ ri Dios rukꞌ ronoje qanimaꞌ, rukꞌ ronoje qanaꞌoj, rukꞌ ronoje qakꞌuꞌx y rukꞌ ronoje ri qachuqꞌabꞌ; yey ri kꞌax keqanaꞌ ri qatz-qachaqꞌ jelaꞌ pachaꞌ ri kꞌax kaqanaꞌ qibꞌ riꞌoj. Waꞌ e más chirajawaxik chikiwa rawaj eporom chwi raltar rukꞌ taq ri kayaꞌiꞌ chwach ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Echiriꞌ ri Jesús xrilo lik kꞌo unaꞌoj raj kꞌutunel re ri tzijpixabꞌ, xubꞌiꞌij che: —Lik xa naqaj lal kꞌo wi che rutaqanik ri Dios —xchaꞌ. Y na jinta chi kꞌu junoq xraj xuꞌan juna tzꞌonobꞌal che. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Echiriꞌ kakꞌutun ri Jesús chupa ri Rocho Dios, jewaꞌ xubꞌiꞌij: —¿Suꞌbꞌe raj kꞌutunel re ri tzijpixabꞌ kakibꞌiꞌij: “Ri Cristo, Ruchaꞌoꞌn lo ri Dios, e Ralkꞌoꞌal kan ri rey David”? ");
INSERT INTO acrNNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Ma ri David, ruma ri Santowilaj Ruxlabꞌixel ri Dios, jewaꞌ xubꞌiꞌij: Ri Dios Qajawxel xubꞌiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwikiqꞌabꞌ, y chawoyeꞌej na ri qꞌij echiriꞌ kebꞌenuya ri tzel kebꞌilow awe chuxeꞌ rawaqan” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ekꞌu ri David kubꞌiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbꞌe kꞌu riꞌ kabꞌiꞌxik e Ralkꞌoꞌal kan ri rey David? —xchaꞌ. Y ukꞌiyal winaq re ri tinamit lik rukꞌ ronoje kikꞌuꞌx kakita ri kubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ekꞌu ri Jesús jewaꞌ kubꞌiꞌij chupa rukꞌutunik: «Lik chichajij iwibꞌ; miꞌan kꞌu iweꞌix pachaꞌ ri kakiꞌan raj kꞌutunel re ri tzijpixabꞌ. Ma rike e lik kukꞌul kikꞌuꞌx ri kejurur chupa ri kiqꞌuꞌ chaꞌ kilitajik lik kꞌo kiwach y ri kayaꞌ rutzil kiwach pa kebꞌilitaj wi. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yey pa taq sinagogas y pa taq waꞌim lik kukꞌul kikꞌuꞌx ri ketzꞌuyiꞌ chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Rike kakimaj rubꞌitaq ke rixoqibꞌ e malkaꞌnibꞌ. Y chaꞌ kayak kiqꞌij, kakiꞌan nimaq chꞌabꞌal echiriꞌ kakiꞌan orar. Ruma kꞌu ri kakiꞌano, rike lik unimal kꞌaxkꞌolil ri kakikꞌulu echiriꞌ kaqꞌat tzij pakiwiꞌ» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ri Jesús tzꞌul pana chwach ri kaxa pa kayaꞌ wi ri qasaꞌn yey lik kutzutzaꞌ echiriꞌ ri winaq kakiya kan ri kiqasaꞌn chupa ri kaxa. Y lik e kꞌi ri bꞌeyomabꞌ kakiya ukꞌiyal qasaꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Xopon kꞌu jun ixoq nibꞌaꞌ yey malkaꞌn y xuya chupa ri kaxa kaꞌibꞌ raltaq ko meyo lik na kꞌi ta rajil. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ekꞌu ri Jesús xebꞌusikꞌij rutijoꞌn y xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij chiwe: Chwach ri Dios, waꞌ wiꞌxoq nibꞌaꞌ y malkaꞌn, e ne xuya más pa ri kaxa chwa ri xkiya konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ma konoje xa e xkiya ruwiꞌ ri kipuaq; noꞌj wiꞌxoq tobꞌ lik nibꞌaꞌ e xuya ronoje ri puaq kꞌo rukꞌ, waꞌ e re kuloqꞌ ri lik kajawax che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Echiriꞌ xel bꞌi ri Jesús pa ri Rocho Dios, jun chike rutijoꞌn jewaꞌ xubꞌiꞌij che: —Qajawal, ¡chilape la wa chomilaj taq abꞌaj y wa nimaq taq ja re ri Rocho Dios! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ri Jesús xukꞌul uwach: —¿Kawil waꞌ wa nimaq taq ja? Wara na kakanaj ta kan juna abꞌaj chwi juna chik, ma ronoje kawulixik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ri Jesús xtzꞌuyiꞌ chwa ri juyubꞌ Olivos, ri kꞌo chwach pana ri Rocho Dios. Ekꞌu ri Pedro, ri Jacobo, ri Juan y ri Andrés, xa kitukel xkitzꞌonoj che: ");
INSERT INTO acrNNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—Bꞌiꞌij ko la chiqe, ¿jampa nawi kuꞌana taq riꞌ waꞌ? ¿Yey saꞌ ri kꞌutubꞌal kilitajik echiriꞌ kuꞌanaꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ekꞌu ri Jesús xujeq ubꞌiꞌxikil chike: «Lik chichajij iwibꞌ chaꞌ na jinta junoq kasokow iweꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Ma lik e kꞌi ri tikawex kekꞌunik y xa kakichiqꞌimaj uwach ri nubꞌiꞌ, jewaꞌ kakibꞌiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios” kechaꞌ. Y lik e kꞌi ri kesokotaj kuma rike. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","»Ekꞌuchiriꞌ kito kꞌo chꞌaꞌoj jewaꞌ y kꞌo chꞌaꞌoj jelaꞌ, mixiꞌij iwibꞌ che; ma lik chirajawaxik wi kuꞌana taq waꞌ. Noꞌj na e ta waꞌ ri kꞌisbꞌal re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Ma e kꞌo tinamit keyaktaj chikij jujun chik tinamit y e kꞌo taqanelabꞌ keyaktaj chikij jujun chik taqanelabꞌ. Kuꞌan taq kabꞌraqan che ukꞌiyal luwar, kape taq numik y ri winaq kakijeqo lik ketukukik. Ronoje waꞌ xa e jeqebꞌal re ri kꞌaxkꞌobꞌik kakꞌunik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","»Lik chichajij kꞌu iwibꞌ, ma kixkꞌam bꞌi pa taq qꞌatbꞌal tzij y kajichꞌ ne ipa chupa taq ri sinagogas. Y ruma kꞌu ikojom ri nubꞌiꞌ, kixkꞌam bꞌi chikiwach ri taqanelabꞌ y chikiwach ri reyes, chaꞌ jelaꞌ kiqꞌalajisaj ri Utzilaj Tzij chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Lik kꞌut chirajawaxik nabꞌe na katzijox ri Utzilaj Tzij chike konoje rukꞌiyal kiwach taq ri tikawex e kꞌo che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Yey echiriꞌ kixkꞌam bꞌi re kixeꞌyoꞌq pa taq qꞌatbꞌal tzij, mubꞌisoj ikꞌuꞌx y michꞌobꞌ nenareꞌ saꞌ ri kibꞌiꞌij. Riꞌix xew chibꞌiꞌij janipa ri kuya ri Dios chiwe chupa ri ora, ma na ix ta ri kixchꞌawik, e ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","»E taq kꞌu ri tikawex kekiya ri katz-kichaqꞌ pa kamik; ri kꞌo kalkꞌoꞌal kekiya taq ri kalkꞌoꞌal pa kamik; ri e alkꞌoꞌal keyaktaj chikij kichu-kiqaw y kekikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Lik kꞌut tzel kixil kuma taq ri winaq ruma ikojom ri nubꞌiꞌ. Pero china kꞌu ri kuchuqꞌubꞌej ribꞌ chwach taq waꞌ wa kꞌaxkꞌobꞌik kꞌa chupa ri kꞌisbꞌal re, e riꞌ ri kakolobꞌetajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","»Echiriꞌ riꞌix kiwil ri lik chꞌul y lik kꞌixbꞌal uwach kayaꞌ pa ri luwar pa lik na taqal ta wi, jelaꞌ pachaꞌ ri xutzꞌibꞌaj kan ri qꞌalajisanel Daniel (china kꞌu ri kajilan re waꞌ, chumaja usukꞌ); ekꞌuchiriꞌ, ri e kꞌo pa taq ri luwar re Judea, chebꞌanimaj ubꞌi chwa taq ri juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","China kꞌu ri kꞌo lo chwi ri rocho, maqaj ne lo che ukꞌamik bꞌi ubꞌitaq re pa ja. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Yey china ri kꞌo lo pa juyubꞌ, matzelej lo che ukꞌamik bꞌi ruqꞌuꞌ re pisbꞌal rij. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","»Chupa taq kꞌu laꞌ la qꞌij, lik toqꞌoꞌ kiwach ri e yewaꞌ ixoqibꞌ y ri ketzꞌumtisanik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Lik kꞌu chitzꞌonoj che ri Dios chaꞌ echiriꞌ kixanimaj bꞌi na e ta uqꞌijol echiriꞌ kꞌax tew y kꞌo jabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Ma taq laꞌ la qꞌij re unimal kꞌaxkꞌolil, na uꞌanom ta kꞌana julajoq chwi lo echiriꞌ ri Dios xuꞌan ruwachulew y na kuꞌana ta chi ne kꞌana julajoq. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","We ta ri Qaqaw Dios na kuqꞌatij ta taq laꞌ la qꞌij re runimal kꞌaxkꞌobꞌik, riꞌ na jinta junoq kakꞌasiꞌ kanoq; noꞌj ruma kꞌu kꞌax kebꞌunaꞌ ri ebꞌuchaꞌom, kuqꞌatij ruqꞌijol waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","»We kꞌo kꞌu junoq kabꞌiꞌn chiwe: “¡Chiwilapeꞌ, wara kꞌo wi ri Cristo!” o “¡Chiwilapeꞌ, leꞌ kꞌolik!”, mixok il che. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Ma kekꞌun ri kakiꞌan “Cristo” che kibꞌ y ri kakiꞌan e qꞌalajisanelabꞌ re ri Dios che kibꞌ, pero xa e sokosoꞌnel. Ekꞌu rike kakiꞌan nimaq taq kꞌutubꞌal y milagros re kesokosoꞌn rukꞌ, yey kꞌo ne pa saq kesokotaj jujun chike ri ebꞌuchaꞌom ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Lik kꞌu chichajij iwibꞌ, ma ximbꞌiꞌij ronoje waꞌ chiwe riꞌix echiriꞌ kꞌamajaꞌ ne kuꞌanaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","»Ekꞌuchiriꞌ ikꞌowinaq chi ri kꞌaxkꞌobꞌik che taq laꞌ laꞌ qꞌij, kuꞌan qꞌequꞌm uwach riꞌ ri qꞌij, y ri ikꞌ na kuya ta chi ruwonibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Ri chꞌumil ketzaq lo che ruwa kaj, y konoje ri kꞌo kichuqꞌabꞌ che ruwa kaj keyikiyoꞌxik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ekꞌuchiriꞌ, kilitaj Ralaxel Chikixoꞌl Tikawex kakꞌun lo pa sutzꞌ rukꞌ runimal uchuqꞌabꞌ y rukꞌ runimal uchomalil. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Kebꞌutaq kꞌu ru ángeles che umolik kichiꞌ konoje ri ebꞌuchaꞌom ri Dios pa taq ronoje luwar che rukajchal rajlibꞌal ruwachulew. Kujeq kꞌu riꞌ che jun luwar, yey kukꞌisbꞌej che jun chik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","»E chimaja ri jun kꞌambꞌal naꞌoj puwi ri cheꞌ re higo: Echiriꞌ kujeq katux lo kꞌakꞌ uqꞌabꞌ y kujeq kꞌut katux ruxaq, ruma kꞌu laꞌ kiwetaꞌmaj xa naqaj chi kꞌo wi lo ruqꞌijol echiriꞌ kabꞌukbꞌutik y na jinta jabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Jekꞌuriꞌlaꞌ riꞌix, echiriꞌ kiwilo kuꞌana ronoje taq waꞌ, chiwetaꞌmaj kꞌu riꞌ xa naqaj chi kꞌo wi lo ruqꞌijol rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Paqatzij wi kambꞌiꞌij chiwe: E kꞌo tikawex re waꞌ wa qꞌij na kekam tana we na xkil tubꞌi ronoje waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ruwa kaj y ruwachulew xa kasach uwach, noꞌj taq ri nuchꞌaꞌtem na kasach ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","»Ekꞌu chwi ruqꞌijol y ruꞌorayil waꞌ, na jinta junoq etaꞌmayom re; na ketaꞌam tane ri ángeles e kꞌo chilaꞌ chikaj, na retaꞌam tane ri Kꞌajolaxel, ma xew ri Qaqaw Dios etaꞌmayom re. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","»Chiwila kꞌu riꞌ, mawar iwach y lik chiꞌana orar, ma na iwetaꞌam taj jampalaꞌ kopon ruqꞌijol waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ri kuꞌanaꞌ e pachaꞌ echiriꞌ juna achi keꞌek naj. Ekꞌuchiriꞌ keꞌek, kuya kan ri rocho pakiqꞌabꞌ ri raj chakibꞌ y chikijujunal waꞌ kuya kan kichak. Kubꞌiꞌij kꞌu kan che ri chajinel re ri puerta: “Lik matkos che uchajixik ri ja” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Jekꞌuriꞌlaꞌ riꞌix, lik mawar iwach, ma na iwetaꞌam taj jampalaꞌ kakꞌun lo ri rajaw ja; laj echiriꞌ kok raqꞌabꞌ, laj pa tikꞌil aqꞌabꞌ, laj pa nabꞌe uchꞌawibꞌal ri teren o echiriꞌ kel lo ri qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mawar kꞌu iwach riꞌ, chaꞌ we xaqikꞌateꞌt xkꞌun lo ri Iwajaw, na kixuriq taj kixwarik. ");
INSERT INTO acrNNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ekꞌu wa kambꞌiꞌij riꞌin chiwe riꞌix, kambꞌiꞌij chike konoje: Lik mawar iwach» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Echiriꞌ kebꞌ qꞌij chi kopon wi ri nimaqꞌij Pascua y ri nimaqꞌij re tijoj pam na jinta levadura che, taq ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ, lik kakitzukuj suꞌanik kakichap ri Jesús rukꞌ sokosoꞌnik re kakikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xkibꞌiꞌij kꞌut: «Na kaqaꞌan ta pa wa nimaqꞌij chaꞌ ri tinamit na ketukuk ta ruma waꞌ» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Kꞌo kꞌu ri Jesús pa ri tinamit Betania chirocho ri Simón, ri jun xkꞌojiꞌ ri yabꞌil lepra che. Ekꞌuchiriꞌ tzꞌul ri Jesús chwa ri mexa, xopon jun ixoq rukꞌaꞌam jun kꞌolibꞌal nojinaq che kunabꞌal lik kiꞌ ruxlabꞌ y lik kꞌi rajil, waꞌ ꞌanatal rukꞌ saqil nardo. Rixoq xuteqꞌij uchiꞌ ri kꞌolibꞌal; tekꞌuchiriꞌ, xuqꞌej ri kunabꞌal chuꞌjolom ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","E kꞌo kꞌu jujun chike ri e kꞌo chiriꞌ xpe koyowal echiriꞌ xkil waꞌ, y jewaꞌ xkibꞌiꞌij chikiwach: —¿Suꞌchak wa kunabꞌal xtzꞌiloꞌxik? ");
INSERT INTO acrNNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Ma ri lik usukꞌ e ta xkꞌayix waꞌ chi oxibꞌ ciento denarios, y rukꞌ waꞌ ketoꞌ ri nibꞌaꞌibꞌ —xechaꞌ. Y lik kꞌu riꞌ kechꞌaꞌt chirij rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ekꞌu ri Jesús xubꞌiꞌij chike: —Mikꞌaq bꞌi uqꞌij wiꞌxoq. ¿Suꞌbꞌe kixchꞌaꞌt chirij ri xuꞌano? Ma ri xuꞌan chwe e jun utzilaj chak. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ri nibꞌaꞌibꞌ e laꞌ xaqi e kꞌo iwukꞌ yey utz kebꞌitoꞌo jampalaꞌ kiwaj riꞌix, noꞌj riꞌin na xaqi ta in kꞌo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Wiꞌxoq e xuꞌano janipa ri xuchꞌij uꞌanikil; rukꞌ kꞌu waꞌ e xnabꞌej pan che uyijbꞌaxik ri nucuerpo che ri muqubꞌal we. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Paqatzij wi kambꞌiꞌij chiwe: Pa taq katzijox wi wa Utzilaj Tzij che ronoje ruwachulew, kakuxtax kꞌu wiꞌxoq ruma ri xuꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ewi ri Judas aj Iscariot, jun chike ri kabꞌlajuj utijoꞌn ri Jesús, xeꞌek kukꞌ ri nimaq e aj chakunel pa Rocho Dios re kuya ri Jesús pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Rike, echiriꞌ xkita waꞌ, lik xekiꞌkot che y xkibꞌiꞌtisij nenareꞌ kakiya puaq che. Ekꞌu riꞌ ri Judas xujeq utzukuxik suꞌanik kuya ri Jesús pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Chupa kꞌu ri nabꞌe qꞌij re ri nimaqꞌij echiriꞌ katij ri pam na jinta levadura che y kekamisax chwi raltar taq ri qꞌapoj bꞌexex re ri Pascua, rutijoꞌn ri Jesús xkitzꞌonoj che: —¿Pa kaꞌaj wi la keꞌqayijbꞌaꞌ wi ri cena re Pascua? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ewi xebꞌutaq bꞌi kaꞌibꞌ chike rutijoꞌn y xubꞌiꞌij bꞌi chike: —Jix pa ri tinamit y echiriꞌ kikꞌul jun achi rukꞌaꞌam jun kuraꞌ yaꞌ, chixterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pa kꞌu kok wubꞌi waꞌ waꞌchi, chibꞌiꞌij che ri rajaw ja: “Jewaꞌ kubꞌiꞌij ri tijonel qeꞌoj: ¿Pachawi kꞌo wi ri luwar pa kantij wi ri cena re Pascua kukꞌ ri nutijoꞌn?” kixcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ekꞌu ri kuꞌan ri rajaw ja e kukꞌut chiwe jun nimalaj luwar chikaj pa ri kaleꞌ ja, waꞌ yijbꞌital chik. Chiriꞌ kꞌu riꞌ chiyijbꞌaꞌ wi ri cena re Pascua —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Xebꞌek kꞌu rutijoꞌn, xebꞌok pa ri tinamit y xeꞌkiriqaꞌ jelaꞌ pachaꞌ ri xubꞌiꞌij bꞌi ri Jesús chike. Y xkiyijbꞌaꞌ kꞌu ri cena re Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ekꞌuchiriꞌ xok raqꞌabꞌ, xopon ri Jesús junam kukꞌ ri kabꞌlajuj utijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ekꞌuchiriꞌ e kꞌo chwa ri mexa, e riꞌ kewaꞌik, ri Jesús xubꞌiꞌij: —Paqatzij wi kambꞌiꞌij chiwe: Jun chiwe wa ix kꞌo wara wukꞌ pa waꞌim, e kakꞌayin we —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ewi rike xkijeq lik kebꞌisonik y chikijujunal kakitzꞌonoj che: —¿Kꞌaxtaj in riꞌ? —kacha jun. —¿Kꞌaxtaj in riꞌ? —kacha jun chik. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ri Jesús xukꞌul uwach; jewaꞌ xubꞌiꞌij: —Waꞌ e jun chiwe wa ix kabꞌlajuj, e ri kumuꞌ lo ruwa junam wukꞌ chupa ri laq. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Paqatzij wi Ralaxel Chikixoꞌl Tikawex e katajin che rikꞌowibꞌexik janipa ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios puwi Rire. Pero ¡lik kꞌu toqꞌoꞌ uwach rachi kakꞌayin re! E ne más utz che waꞌchi tamaji xalaxik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Xaloqꞌ kꞌu riꞌ kewaꞌik, ri Jesús xukꞌam ri pam y xutioxij che ri Dios. Ewi xuwechꞌo, xujach chike y jekꞌuwaꞌ xubꞌiꞌij: —Chitijaꞌ, ma e nucuerpo waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Xukꞌam kꞌu ri kꞌolibꞌal kꞌo vino chupa, yey echiriꞌ utioxim chi che ri Dios, xuya chike y konoje xkitij chuchiꞌ waꞌ wa kꞌolibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xubꞌiꞌij kꞌu chike: —E nukikꞌel waꞌ, ri katuruw na kuma ukꞌiyal tikawex re kuybꞌal kimak, yey waꞌ e kujikibꞌaꞌ uwach ri kꞌakꞌ tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Paqatzij wi kambꞌiꞌij chiwe: Na kantij ta chi ruwaꞌal uva, kꞌate kiꞌntija tanchi chupa ruqꞌijol rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Echiriꞌ xkikꞌis ubꞌixoxik ri bꞌix, xebꞌek chwa ri juyubꞌ Olivos. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ekꞌuchiriꞌ ri Jesús xubꞌiꞌij chike: —Waqꞌabꞌ iwonoje riꞌix kiwesaj na iwibꞌ chwij, ma e pachaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios: Kankamisaj raj chajinel yey taq kꞌu riꞌ rubꞌexex kakikich bꞌi kibꞌ kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Noꞌj ekꞌuchiriꞌ kinkꞌastaj lo chikixoꞌl ri ekaminaq, kinnabꞌej bꞌi chiwach kꞌa Galilea —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ekꞌu ri Pedro xubꞌiꞌij: —Tobꞌ ne konoje kakesaj kibꞌ chiꞌij la, riꞌin na kanꞌan ta waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yey ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij chawe: Wa jun aqꞌabꞌ, echiriꞌ kꞌamajaꞌ ne kabꞌixon kalaj ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Noꞌj ri Pedro lik xujikibꞌaꞌ ubꞌiꞌxikil: —Tobꞌ ne chirajawaxik kinkam junam ukꞌ la, riꞌin na kanwewaj taj we wetaꞌam wach la —xchaꞌ. Jekꞌulaꞌ riꞌ xkibꞌiꞌij konoje. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Xebꞌopon kꞌu pa jun luwar Getsemaní rubꞌiꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike rutijoꞌn: —Chixtzꞌula kan wara, noꞌj riꞌin kiꞌnꞌana orar —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Yey xebꞌukꞌam kꞌu bꞌi ri Pedro, ri Jacobo y ri Juan rukꞌ. Xujeq kꞌu riꞌ lik kabꞌisonik y kakꞌaxkꞌobꞌ ri ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xubꞌiꞌij kꞌu chike: —Kꞌo jun unimal bꞌis re kamik chinukꞌuꞌx. Chixkꞌola kan wara; mixwarik y lik chiꞌana orar —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Tekꞌuchiriꞌ, ri Jesús xqibꞌ chi pana jubꞌiqꞌ chwach, xuqasaj umejelem kꞌa chuꞌlew, y xutzꞌonoj che ri Dios we ta kuya na che na kikꞌow ta chupa ruꞌorayil ri kꞌaxkꞌobꞌik, ");
INSERT INTO acrNNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","jewaꞌ xubꞌiꞌij: «Tat, Lal Nuqaw, chiwach Rilal na jinta kꞌana kꞌayew; chinkolobꞌej ko la chaꞌ na kinikꞌow ta chupa waꞌ wa kꞌaxkꞌobꞌik. Noꞌj na e ta kꞌu chuꞌana ri kuaj riꞌin, ma e chuꞌanaꞌ janipa ri kaꞌaj Rilal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Tekꞌuchiriꞌ, xtzelej lo pa e kꞌo wi kan rutijoꞌn y xebꞌoꞌluꞌriqaꞌ kewarik. Xubꞌiꞌij kꞌu che ri Pedro: —¿Katwar kami riꞌ? ¿Na xakuy ta kꞌana ri waram chaꞌ kaꞌan orar wukꞌ, tobꞌ tane xa juna ora? ");
INSERT INTO acrNNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Mixwar kꞌut, y lik chiꞌana orar chaꞌ kichꞌij uchuqꞌabꞌ ri kꞌambꞌal ipa kapetik. Paqatzij wi, lik kacha ikꞌuꞌx che uꞌanik ri utz, noꞌj waꞌ lik kꞌayew chiwe ma e ri itiꞌjil na jinta ukowil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ekꞌu ri Jesús xeꞌek tanchik, xuꞌana orar, yey e xutzꞌonoj che ri Dios ri ujeqom chi lo utzꞌonoxik nabꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Tekꞌuchiriꞌ, xtzelej tanchi lo kukꞌ rutijoꞌn y xebꞌoꞌluꞌriqaꞌ kewarik; ma ri kiwach lik na kukuy ta chi ri waram y na kakiriq ta chik saꞌ ri kakibꞌiꞌij che. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Xtzelej kꞌu lo churox laj y xubꞌiꞌij chike: —¿Kꞌa kixwar kami riꞌ riꞌix? ¿Kꞌa kixuxlanik? ¡Kuꞌan na kꞌu laꞌ! Ma e waꞌ xopon ruꞌorayil chaꞌ Ralaxel Chikixoꞌl Tikawex kayaꞌ pakiqꞌabꞌ raj makibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","¡Chixwaꞌlijoq! ¡Joꞌ! Chiwilaꞌ, ma ri kakꞌayin we riꞌin e laꞌ xkꞌunik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Kꞌa kachꞌaꞌt ne ri Jesús echiriꞌ xkꞌun lo ri Judas, jun chike ri kabꞌlajuj utijoꞌn. Ekꞌu rire erachbꞌilam lo ukꞌiyal winaq kukꞌaꞌam lo espada y cheꞌ. Taq waꞌ etaqom lo kuma ri nimaq e aj chakunel pa Rocho Dios, taq raj kꞌutunel re ri tzijpixabꞌ y ri nimaq winaq re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Ekꞌu ri Judas, ri kayaꞌw bꞌi re pakiqꞌabꞌ, ubꞌiꞌim chi lo chike suꞌanik kaketaꞌmaj china ri kakichapo, jewaꞌ ubꞌiꞌim: «E ri jun kantzꞌubꞌ uchiꞌ, e riꞌ rire. Chapa kꞌu alaq y kꞌama bꞌi alaq, yey chekojo bꞌi alaq e chajinel re chaꞌ na kanimaj tubꞌi» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Ekꞌuchiriꞌ xkꞌunik, maji chik xqibꞌ rukꞌ ri Jesús y xubꞌiꞌij che: —¡Wajawal, Wajawal! —xcha che. Y xutzꞌubꞌ uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ekꞌuchiriꞌ, ri winaq xkichap ri Jesús chaꞌ kakikꞌam bꞌi pa qꞌatbꞌal tzij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Kꞌo kꞌu jun chike rutijoꞌn e kꞌo chiriꞌ, xresaj lo ru espada y xujochij bꞌi jun uxikin ri raj chak ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Xubꞌiꞌij kꞌu ri Jesús chike: —¿Suꞌchak petinaq alaq rukꞌ espada y cheꞌ? ¿Petinaq kami alaq che ukꞌamik bꞌi juna eleqꞌom? ");
INSERT INTO acrNNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Wa petinaq loq ronoje qꞌij waꞌ kꞌut kinkꞌutun chiwach alaq pa ri Rocho Dios. ¿Suꞌchak kꞌu riꞌ kꞌa e laꞌ kinoꞌlchapa alaq? Noꞌj jekꞌuwaꞌ kuꞌano chaꞌ e kuꞌana janipa ri qꞌalajisam kan chupa Ruchꞌaꞌtem ri Dios —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Tekꞌuchiriꞌ, konoje rutijoꞌn xebꞌanimajik y jelaꞌ xkiya kan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kꞌo kꞌu jun ala teran bꞌi chirij ri Jesús, upisom ribꞌ xa chupa jun sábana; rire xchap kuma ri soldados. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Pero rala xusolij kan rusábana y e laꞌ chꞌanalik xanimajik. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Xkikꞌam kꞌu bꞌi ri Jesús chwach ri kajawal raj chakunel pa Rocho Dios. Tekꞌuchiriꞌ, xkimol kibꞌ ri nimaq e aj chakunel kukꞌ ri nimaq winaq re ri tinamit y raj kꞌutunel re ri tzijpixabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ekꞌu ri Pedro xa naj teran pan chirij ri Jesús y xok bꞌi kꞌa che ruwa ja re ri rocho ri kajawal raj chakunel pa Rocho Dios. Xeꞌtzꞌula kꞌu kukꞌ ri e chajinel, e riꞌ kumiqꞌisaj ribꞌ chuchiꞌ ri aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ri nimaq e aj chakunel pa Rocho Dios kukꞌ konoje ri uchapom wi ribꞌ ri qꞌatbꞌal tzij, kakitzukuj suꞌanik kakikoj umak ri Jesús chaꞌ jelaꞌ utz kaqꞌat tzij re kamik puwiꞌ, noꞌj na jinta kꞌo xkiriq chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Ma lik e kꞌi ri winaq xkitzꞌaq uchiꞌ, pero lik junwi taq ri xkibꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ewi xeyaktaj jujun y xkitzꞌaq uchiꞌ, jewaꞌ xkibꞌiꞌij chirij: ");
INSERT INTO acrNNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Riꞌoj xqato echiriꞌ xubꞌiꞌij: “Kanwulij wa Rocho Dios ꞌanatal xa kuma rachijabꞌ, yey xa pa oxibꞌ qꞌij kanyak jun chik na ꞌanatal ta kuma rachijabꞌ” —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Na rukꞌ ta kꞌu riꞌ, lik junwi taq ri xkibꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ewi ri kajawal raj chakunel pa Rocho Dios xyaktaj chikixoꞌl y xutzꞌonoj che ri Jesús: —¿E kami laꞌ na jinta kꞌana kabꞌiꞌij riꞌat? ¿Saꞌ kꞌu ri kakꞌulubꞌej uwach puwi wa ketajin che ukojik chawij? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Pero ri Jesús xa xuto y na jinta kꞌo xubꞌiꞌij. Tekꞌuchiriꞌ, xuꞌan jun chik tzꞌonobꞌal che ri Jesús: —¿At bꞌa riꞌ ri Cristo, Rukꞌajol ri Dios, ri Jun lik nim uqꞌij? —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ri Jesús xukꞌul uwach: —Qatzij, “In Riꞌin.” Kil na kꞌu alaq Ralaxel Chikixoꞌl Tikawex tzꞌul puwikiqꞌabꞌ ri Dios, ri lik kꞌo unimal uchuqꞌabꞌ yey kil kꞌu alaq riꞌ echiriꞌ kakꞌun lo pa sutzꞌ chwa ri kaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ekꞌu ri kajawal raj chakunel pa Rocho Dios xurichꞌij ruqꞌuꞌ y xubꞌiꞌij: —¡Na jinta chi uchak más e aj kojol umak! ");
INSERT INTO acrNNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ma lik e laꞌ xta alaq xmakun chirij ri Dios echiriꞌ xubꞌiꞌij ri lik na taqal ta che. ¿Saꞌ kꞌu riꞌ kabꞌiꞌij ralaq che? —xchaꞌ. Ewi konoje xkiqꞌat tzij puwi ri Jesús y xkibꞌiꞌij lik taqal che kakamisaxik. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Y e kꞌo jujun xkijeq kakichubꞌaj; kakichꞌuq rupalaj, kakiꞌan pa tꞌoꞌy yey kakibꞌiꞌij kꞌu che: —Chanaꞌij peꞌ china xchꞌayaw awe —kecha che. Yey ri e chajinel kakipachꞌ qꞌabꞌ chupalaj. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ekꞌu ri Pedro kꞌo ikem che ruwa ja echiriꞌ xkꞌun lo jun ali raj chak ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Ekꞌuchiriꞌ rali xril ri Pedro kumiqꞌisaj ribꞌ chuchiꞌ ri aqꞌ, lik xutzutzaꞌ uwach y xubꞌiꞌij che: —Rilal lal jun chike ri eteran chirij ri Jesús ri aj Nazaret —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ewi ri Pedro xrewaj, jewaꞌ xukꞌul uwach: —Riꞌin na wetaꞌam ta uwach y na wetaꞌam tane saꞌ puwiꞌ katchꞌaꞌt wi —xchaꞌ. Xel kꞌu bꞌi chuchiꞌ ri puerta. Tekꞌuchiriꞌ, xchꞌaw ri teren. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ekꞌu rali aj chak echiriꞌ xril tanchi ri Pedro, xujeq ubꞌiꞌxikil chike taq ri e kꞌo chiriꞌ: —Waꞌ waꞌchi e jun chike rutijoꞌn ri Jesús —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Noꞌj ri Pedro xrewaj tanchik. Joqꞌotaj kꞌu riꞌ, e taq ri e kꞌo chiriꞌ xkibꞌiꞌij tanchi che ri Pedro: —Paqatzij wi rilal lal jun chike rutijoꞌn; lik qꞌalaj lal aj Galilea, ma ri kachꞌaꞌt la e junam rukꞌ ri kechꞌaꞌt rike —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ewi ri Pedro xujeq ubꞌiꞌxikil itzel taq tzij y lik xujikibꞌaꞌ uwach, xubꞌiꞌij: —Riꞌin na wetaꞌam ta kꞌana uwach waꞌ waꞌchi kabꞌiꞌij alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ekꞌu ri teren xchꞌaw chukalaj. Ewi xkꞌun lo chukꞌuꞌx ri Pedro ri xbꞌiꞌx lo che ruma ri Jesús: «Kꞌamajaꞌ ne kabꞌixon ri teren chukalaj, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach.» Ekꞌu katajin waꞌ pujolom, xumaj roqꞌej. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Echiriꞌ xsaqirik, ri nimaq e aj chakunel pa Rocho Dios kukꞌ taq ri nimaq winaq re ri tinamit, raj kꞌutunel re ri tzijpixabꞌ y konoje ri uchapom wi ribꞌ ri qꞌatbꞌal tzij, kiꞌanom chi tzij chikiwach puwi saꞌ ri kakiꞌan rukꞌ ri Jesús. Xkikꞌam kꞌu bꞌi ri Jesús yututalik y xeꞌkiyaꞌa chwach ri taqanel Pilato. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ri Pilato xutzꞌonoj kꞌu che ri Jesús: —¿Lal kami riꞌ ri rey ke raj judiꞌabꞌ? —xcha che. Ri Jesús xukꞌul uwach: —Lal kabꞌiꞌn la re —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Yey ri nimaq e aj chakunel pa Rocho Dios lik kakitzꞌaq uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Xutzꞌonoj tanchi kꞌu ri taqanel Pilato che: —¿E kami laꞌ na kakꞌul ta la uwach? ¿Na kata ta kami la janipa chi mak kakikoj chiꞌij la? —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Na rukꞌ ta kꞌu riꞌ, ri Jesús na xukꞌul ta uwach. Ruma kꞌu waꞌ, ri Pilato lik xkam ranimaꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Chupa kꞌu ri nimaqꞌij Pascua, ri taqanel romano xex kuꞌan wi kuyolopij bꞌi jun chike ri e kꞌo pa cárcel, yey e ri winaq kechaꞌwik china ri kakaj kayolopix bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Kꞌo kꞌu jun achi Barrabás rubꞌiꞌ, rire kꞌo pa cárcel kukꞌ jujun rachbꞌiꞌil ruma xkiꞌan kamik echiriꞌ xeyaktaj chirij ri taqanel aj Roma. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Xebꞌopon kꞌu ukꞌiyal winaq chwach ri taqanel Pilato y xkijeq utzꞌonoxik che e kuꞌan pachaꞌ taq ri uꞌanom lo ronoje junabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ewi ri taqanel Pilato xutzꞌonoj chike: —¿Kaꞌaj alaq kanyolopij bꞌi ri rey ke raj judiꞌabꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Xubꞌiꞌij waꞌ ma retaꞌam ri nimaq e aj chakunel pa Rocho Dios xeꞌkiyaꞌa ri Jesús chwach, xa ruma kꞌax kikꞌuꞌx chirij. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ekꞌu ri nimaq e aj chakunel pa Rocho Dios xkikoj pa kijolom ri ukꞌiyal winaq e kakitzꞌonoj kayolopix bꞌi ri Barrabás. Yey rike jelaꞌ xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ri Pilato xutzꞌonoj tanchi chike: —¿Saꞌ kꞌu riꞌ kaꞌaj alaq kanꞌan rukꞌ ri kabꞌiꞌij alaq e rey ke raj judiꞌabꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yey ri winaq lik xesikꞌin tanchi che ukꞌulik uwach: —¡Kamisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ekꞌu ri taqanel Pilato xutzꞌonoj chike: —¿Saꞌ kꞌu rumak uꞌanom? —xchaꞌ. Noꞌj ri winaq más ko xesikꞌinik: —¡Kamisax chwa cruz! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ewi ri Pilato xa ruma xraj kakanaj kan chi utz kukꞌ rukꞌiyal winaq, e xuyolopij bꞌi ri Barrabás. Yey xebꞌutaq ri soldados che ujichꞌik upa ri Jesús. Tekꞌuchiriꞌ, xuya bꞌi pakiqꞌabꞌ re kakikamisaj chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ri soldados xkikꞌam kꞌu bꞌi ri Jesús che ruwa ja re rupalacio ri taqanel. Chiriꞌ xmoliꞌ kichiꞌ konoje taq ri soldados. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ekꞌu ri soldados xkikoj jun kꞌul morato che ri Jesús. Che kꞌu rujolom xkikoj jun corona pachꞌum rukꞌ kꞌiix. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Xkijeq kꞌu kesikꞌin che, jewaꞌ kakibꞌiꞌij: —¡Nim uqꞌij ri rey ke raj judiꞌabꞌ! —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Kakichꞌay rujolom rukꞌ jukutaj tani y kakichubꞌaj rupalaj. Kakixukubꞌaꞌ kꞌu kibꞌ chwach, lik xa uꞌanikil kakiyak uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Echiriꞌ ya lik xkichꞌamij, xkesaj ri kꞌul morato kikojom che y xkikoj tanchi ruqꞌuꞌ. Xkesaj kꞌu bꞌi chaꞌ keꞌkikamisaj chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Kꞌo kꞌu jun achi aj Cirene petinaq pa juyubꞌ e riꞌ kikꞌow chiriꞌ. Ekꞌu ri soldados xkitaq che kutelej bꞌi ri cruz re ri Jesús. Rachi, Simón rubꞌiꞌ, rire e kiqaw ri Alejandro y Rufo. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Y xkikꞌam bꞌi ri Jesús pa jun luwar Gólgota kabꞌiꞌx che, waꞌ keꞌelawi “luwar re ubꞌaqil ujolom animaꞌ”. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Yey xkiyaꞌ che ri Jesús vino kojotal mirra rukꞌ; noꞌj Rire na xutij taj. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Echiriꞌ kiyaꞌom chi ri Jesús chwa ri cruz, ri soldados rukꞌ jun sorteo xkijach kibꞌ puwi ruqꞌuꞌ chaꞌ kakilo saꞌ taq ri kakikꞌam bꞌi chikijujunal. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Anim che ri ubꞌelej ora, xkiya ri Jesús chwa ri cruz. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Chwi kꞌu lo rucruz ri Jesús tzꞌibꞌitalik suꞌbꞌe xqꞌat tzij puwiꞌ, jewaꞌ kubꞌiꞌij: «RI REY KE RAJ JUDIꞌABꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xekiya kꞌu kaꞌibꞌ eleqꞌomabꞌ chwa cruz, jun puwikiqꞌabꞌ y jun pumox ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ekꞌu xuꞌana riꞌ ri tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: E jun Rire xajilax bꞌi kukꞌ ri winaq itzel kikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ri winaq kebꞌikꞌow chiriꞌ kakiyoqꞌ kanoq, kakiyiriyaꞌ ri kijolom che y jekꞌuwaꞌ kakibꞌiꞌij che: —¡Ah! At peꞌ ri abꞌiꞌim kawulij ri Rocho Dios y xa pa oxibꞌ qꞌij kayak tanchik. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Chakolobꞌej kꞌu awibꞌ riꞌ y chatqaj lo chwa ri cruz —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Jenelaꞌ riꞌ xkiꞌan ri nimaq e aj chakunel pa Rocho Dios junam kukꞌ raj kꞌutunel re ri tzijpixabꞌ; rike lik kakichꞌamij, jewaꞌ kakibꞌiꞌij chikiwach: —Lik waꞌ kꞌut e kꞌi ri xebꞌukolobꞌej che taq yabꞌil y che kamik, yey na kuriq ta waꞌ ukolobꞌexik ribꞌ rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Laꞌ laꞌchi kabꞌiꞌx “Cristo, Rey ke Raj Israel” che, qaja lo riꞌ utukel chwa ri cruz chaꞌ kaqilo y jelaꞌ kaqakojo e rire ri Uchaꞌoꞌn lo ri Dios —kechaꞌ. Y jenelaꞌ ri kaꞌibꞌ eyaꞌom chwa cruz junam rukꞌ, lik xkichꞌamij Rire. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ekꞌuchiriꞌ xtikꞌoj ri qꞌij, xok qꞌequꞌm che ruwachulew y waꞌ xuꞌkꞌisa kꞌa che ri urox ora bꞌenaq qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Chupa kꞌu laꞌ la ora, ri Jesús lik ko xsikꞌinik, jewaꞌ xubꞌiꞌij pa ri chꞌaꞌtem kachꞌaꞌt wi Rire: —Eloi, Eloi, ¿lama sabactani? —xchaꞌ. Waꞌ keꞌelawi: “Lal nu Dios, Lal nu Dios, ¿suꞌbꞌe xinoqꞌotaj kan la?” ");
INSERT INTO acrNNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jujun kꞌu chike ri e kꞌo chiriꞌ, echiriꞌ xkita waꞌ, xkibꞌiꞌij: —Chitapeꞌ, waꞌchi e kusikꞌij ri qꞌalajisanel Elías —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Kꞌo kꞌu jun xeꞌek lik kanik, xumuꞌ jun esponja pa vinagre, xuxim kꞌu chutzaꞌm jun tani y xuya pan che ri Jesús re kutzꞌubꞌu, y jekꞌuwaꞌ xubꞌiꞌij: —Qila peꞌ we kakꞌun ri Elías re koluꞌqasaj lo chwa ri cruz —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Noꞌj ri Jesús lik ko xsikꞌinik y jelaꞌ xkamik. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ekꞌuchiriꞌ, ri telón kꞌo chupa ri Rocho Dios xrichꞌrobꞌ chunikꞌajal; xujeq lo puwiꞌ y xoꞌlkꞌis kꞌa chuxeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ekꞌu ri capitán takꞌal chwach ri Jesús, echiriꞌ xuto xsikꞌinik yey xrilo saꞌ rukamik, jewaꞌ xubꞌiꞌij: —¡Paqatzij wi, waꞌ waꞌchi e Ukꞌajol ri Dios! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","E kꞌo kꞌu jujun ixoqibꞌ kakitzutzaꞌ pana chinimanaj. Chikixoꞌl waꞌ e kꞌo ri María ri aj Magdala, ri Salomé y ri María kichu ri Jacobo (ri más kꞌakꞌal) y ri José. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Waꞌ wa ixoqibꞌ lik xeterej chirij ri Jesús y lik kinimam loq echiriꞌ Rire kꞌo Galilea. Rike kukꞌ jujun chik ukꞌiyal ixoqibꞌ, xepaqiꞌ lo rukꞌ pa ri tinamit Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bꞌenaq qꞌij, echiriꞌ raj judiꞌabꞌ kakiyijbꞌaꞌ pan janipa ri kajawax chike pa ri qꞌij re uxlanibꞌal, ");
INSERT INTO acrNNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ri José aj Arimatea xok chwach ri taqanel Pilato y na xuxiꞌij ta kꞌana ribꞌ xutzꞌonoj rucuerpo ri Jesús chaꞌ kukꞌam bꞌi. (Ri José lik kꞌo uwach chike ri uchapom wi ribꞌ ri qꞌatbꞌal tzij yey lik royeꞌem rukꞌunibꞌal rutaqanik ri Dios.) ");
INSERT INTO acrNNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ri Pilato lik xkam ranimaꞌ che echiriꞌ xuto kaminaq chi ri Jesús. Ewi xusikꞌij ri capitán chaꞌ kutzꞌonoj che we qatzij. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Echiriꞌ xuta chi uchiꞌ ri capitán kaminaq chi ri Jesús, xuya luwar che ri José kukꞌam bꞌi rucuerpo. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ekꞌu ri José xuloqꞌ jun manta, xuqasaj lo rucuerpo ri Jesús chwa ri cruz y xupis bꞌi chupa ri manta. Xuꞌyaꞌa kꞌu riꞌ chupa jun muqubꞌal kꞌotom paꞌbꞌaj y xutaq uketebꞌaxik kan jun nimalaj abꞌaj chuchiꞌ re tzꞌapibꞌal re. ");
INSERT INTO acrNNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Yey ri María ri aj Magdala y ri María ruchu ri José, xkilo pa xmuq kan wi. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Echiriꞌ xikꞌow ri qꞌij re uxlanibꞌal, ri María ri aj Magdala, ri Salomé y ri María ruchu ri Jacobo, xkiloqꞌ kunabꞌal lik kiꞌ ruxlabꞌ re kakibꞌal rucuerpo ri Jesús chupa. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ekꞌu ri nabꞌe qꞌij re ri semana lik anim kꞌa e riꞌ kel lo ri qꞌij, xebꞌek pa muqutal wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Kakibꞌiꞌij kꞌu chikiwach: «¿China kesan rabꞌaj chiqe kꞌo chuchiꞌ ri muqubꞌal?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Pero kꞌate xkilo, rabꞌaj esam chik, yey waꞌ lik nim. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Ekꞌuchiriꞌ xebꞌok bꞌi chupa ri muqubꞌal, xkil jun ala tzꞌul pa uwikiqꞌabꞌ chike, ukojom jun kꞌul saq lik naj raqan. Yey rike lik xkixiꞌij kibꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ekꞌu rire xubꞌiꞌij chike: —Mixiꞌij iwibꞌ. Riꞌix e kitzukuj ri Jesús ri aj Nazaret, ri xkamisax chwa cruz; Rire na jinta chi wara, ma kꞌastajinaq chubꞌi. Chiwila wa luwar pa xyaꞌiꞌ wi rucuerpo. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ekꞌu riꞌix jix, jiꞌbꞌiꞌij chike rutijoꞌn y che ri Pedro: “Rire keꞌek Galilea, kanabꞌej bꞌi chiwach; chilaꞌ kꞌu riꞌ kiꞌwila wi uwach, jelaꞌ pachaꞌ ri ubꞌiꞌim chi lo chiwe” —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ekꞌu rixoqibꞌ xebꞌel bꞌi chuchiꞌ ri muqubꞌal lik kebꞌirbꞌotik ruma bꞌenaq kinaꞌoj puwi ri xkilo; yey na jinta ne kꞌana kꞌo xkitzijoj wi ruma kixiꞌim kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ekꞌuchiriꞌ kꞌastajinaq chi lo ri Jesús, anim tan che ri nabꞌe qꞌij re ri semana, nabꞌe xukꞌut uwach chwach ri María ri aj Magdala, ri e resam bꞌi wuqubꞌ itzel uxlabꞌixel che. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Rire xeꞌek kꞌut chaꞌ kuꞌtzijoj rukꞌastajibꞌal ri Jesús chike ri xeterej chirij yey xebꞌuꞌriqa kꞌu riꞌ lik kebꞌisonik y kebꞌoqꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Yey rike echiriꞌ xkito kꞌastajinaq chi lo ri Jesús y xilitaj uwach ruma ri María, na xkikoj taj. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Tekꞌuchiriꞌ, ri Jesús xukꞌut uwach chikiwach kaꞌibꞌ chike rutijoꞌn, noꞌj junwi uꞌanikil xuꞌan waꞌ echiriꞌ rike e riꞌ kebꞌinik kebꞌek pa juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ekꞌu wa kaꞌibꞌ xetzelejik, xeꞌkitzijoj chike ri jujun chik tijoꞌn; yey waꞌ na xkoj tane chwikiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Kꞌisbꞌal chi kꞌu re, ri Jesús xukꞌut uwach chikiwach ri junlajuj utijoꞌn echiriꞌ rike etzꞌul chwa mexa, yey xuchꞌaꞌbꞌej kipa ruma na kubꞌul ta kikꞌuꞌx rukꞌ y ruma uꞌanom lik ko ri kanimaꞌ, ma na xkikoj ta ke ri xebꞌilow re ri Jesús kꞌastajinaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xubꞌiꞌij kꞌu chike: —Jix che ronoje ruwachulew y chitzijoj ri Utzilaj Tzij chike konoje ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ekꞌu ri kekojow re y kakikꞌul ri bautismo, kekolobꞌetajik. Noꞌj kꞌu ri na kekojow ta re, kaqꞌat na tzij pakiwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Yey chike ri kekojow re, kilitaj kꞌutubꞌal re ruchuqꞌabꞌ ri Dios. Pa ri nubꞌiꞌ kebꞌekesaj bꞌi itzel uxlabꞌixel, kechꞌaꞌt pa jujun chik kꞌakꞌ chꞌaꞌtem, ");
INSERT INTO acrNNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","kakichap taq ne kumatz pakiqꞌabꞌ. Yey we kꞌo ri xkitijo y na kinaꞌbꞌem taj kamisabꞌal ke, na jinta kꞌo kuꞌan chike. Kakiya ri kiqꞌabꞌ pakiwi taq ri yewaꞌibꞌ, y waꞌ kekunutajik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ekꞌu ri Qanimajawal echiriꞌ chꞌaꞌtinaq chi kukꞌ, xkꞌul pana chilaꞌ chikaj y xtzꞌuyiꞌ puwikiqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E taq kꞌu rutijoꞌn xebꞌel bꞌi che utzijoxik ri Utzilaj Tzij pa taq ronoje luwar. Yey ri Qanimajawal xebꞌutoꞌo, xuya chike kakikꞌut ruchuqꞌabꞌ ri Dios chaꞌ rukꞌ waꞌ kujikibꞌaꞌ uwach ri Utzilaj Tzij. Amén. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ukꞌiyal tikawex kitzꞌibꞌam chi puwi saꞌ taq ri uꞌanom ri Dios chiqaxoꞌl riꞌoj, ri nabꞌe qakojom rubꞌiꞌ ri Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kitzꞌibꞌam kꞌu ri kꞌutum lo chiqe kuma ri raj chak ri Dios, ri xebꞌilow chi utz ri xuꞌan ri Qanimajawal Jesucristo chwi xujeq lo ruchak. Yey e rike ri xkitzijoj ri Utzilaj Tzij puwi Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Riꞌin mismo lik xinwetaꞌmaj na chi utz y nuchꞌobꞌom lo raqan puwi ronoje saꞌ taq ri xuꞌano chwi lo rukꞌunik ri Qanimajawal che ruwachulew. Yey chinuwach riꞌin, lik utz kintzꞌibꞌan pan cheꞌla Teófilo y kantzijoj rusukꞌ waꞌ cheꞌla chucholaꞌj ");
INSERT INTO acrNNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","chaꞌ ketaꞌmaj la chi utz puwi ri Qꞌijsaq kꞌutum chiwach la. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Echiriꞌ ri Herodes kataqan puwi ri luwar re Judea, kꞌo jun aj chakunel pa Rocho Dios, Zacarías rubꞌiꞌ. Rire e kukꞌil raj Abías. Ri rixoqil Elizabet e kukꞌil ri ralkꞌoꞌal kan ri Aarón. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ri Zacarías y ri Elizabet junam lik e jusukꞌ chwach ri Dios, yey lik kebꞌok il che ronoje Rutzij Upixabꞌ ri Dios Qajawxel y na jinta junoq katzꞌaqaw mak chikij. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Pero rike na jinta juna kalkꞌoꞌal, ma ri Elizabet na utz taj kalanik yey kikabꞌichal e nimaq winaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xopon kꞌu ruqꞌijol echiriꞌ ri Zacarías kukꞌ ri rachbꞌiꞌil e aj Abías keꞌkiloqꞌoj uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ekꞌu raj chakunel pa Rocho Dios kakiꞌan jun sorteo chaꞌ kakichaꞌo china chike kok chupa ri Luwar Santo pa ri Rocho Dios re kuꞌporoj incienso. Jekꞌulaꞌ xkiꞌan wa sorteo, y waꞌ xtzaq puwi ri Zacarías. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Echiriꞌ xopon ruꞌorayil re kaporox ri incienso, konoje ri ekꞌo chwach ri Luwar Santo ketajin che uꞌanik orar. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ekꞌuchiriꞌ, jun ángel re ri Dios Qajawxel xwinaqir chwach ri Zacarías puwikiqꞌabꞌ ri altar pa kaporox wi ri incienso. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Echiriꞌ ri Zacarías xril ri ángel, xkam ranimaꞌ che y lik xuxiꞌij ribꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Noꞌj ri ángel xubꞌiꞌij che: —Zacarías, maxiꞌij awibꞌ, ma ri Dios utom chi ri atzꞌonom che. Rukꞌ kꞌu rawixoqil kakꞌojiꞌ jun akꞌajol yey Juan rubꞌiꞌ kakojo. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kakꞌojiꞌ kꞌu kiꞌkotemal awukꞌ y lik e kꞌi ri kekiꞌkot che ri ralaxibꞌal rakꞌajol, ");
INSERT INTO acrNNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ma rire kuꞌana lik nim uqꞌij chwach ri Dios. Na kuchinaꞌaj ta vino y na kuchinaꞌaj ta yaꞌ re qꞌabꞌarik; y e ne chiriꞌ kꞌa matzem, rukꞌaꞌam chi lo ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Y ruma kꞌu Rire, lik e kꞌi chike ri e aj Israel ketzelej jumul chik rukꞌ ri Dios Qajawxel y kakiya tanchi kibꞌ puqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ekꞌu wa Juan kanabꞌej lo chwach ri Qanimajawal rukꞌ ruchuqꞌabꞌ ri Ruxlabꞌixel ri Dios jelaꞌ pachaꞌ ri qꞌalajisanel Elías re ojertan. Yey ri chak koluꞌanaꞌ e kukoj utzil chomal chikixoꞌl ri tikawex kukꞌ ri kalkꞌoꞌal y kujalkꞌatij ri kinaꞌoj ri na e ta kojol tzij chaꞌ kuꞌana pachaꞌ ri kinaꞌoj ri kebꞌin jusukꞌ. Jekꞌuriꞌlaꞌ rire kebꞌuyijbꞌaꞌ ri tinamit chaꞌ kakikꞌul chi utz ri Qanimajawal —xcha ri ángel. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Ri Zacarías xutzꞌonoj kꞌu che: —¿Suꞌanik kakubꞌiꞌ nukꞌuꞌx che waꞌ? Ma riꞌin lik in nimalaj winaq chik yey jenelaꞌ ri wixoqil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ri ángel xukꞌul uwach, jewaꞌ xubꞌiꞌij che: —Riꞌin in Gabriel, intaqom lo ruma ri Dios Qajawxel chaꞌ kinoꞌlchꞌaꞌt awukꞌ y koꞌlnuyaꞌa wa utzilaj tzij chawe. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Noꞌj woꞌora katkanaj kanoq at meꞌt, y na utz ta kꞌu riꞌ katchꞌawik, ma na xakoj ta ri ximbꞌiꞌij chawe. Kopon na kꞌu ri qꞌij echiriꞌ kalax rakꞌajol; kꞌa ekꞌuchiriꞌ, utz katchꞌaw tanchik —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ekꞌu ri e kꞌo pan chwach ri Luwar Santo koyeꞌem jampalaꞌ kel lo ri Zacarías, yey lik xubꞌisoj kikꞌuꞌx ma lik xmayin chupa ri Luwar Santo pa ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Echiriꞌ xel lo ri Zacarías, na utz ta kachꞌaw chike; xa kuꞌan chi kꞌutubꞌal rukꞌ ruqꞌabꞌ chike ma xkanaj kan meꞌt. Y jelaꞌ xkimaj usukꞌ kꞌo xkꞌut chwach ri Zacarías chupa ri Luwar Santo. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Echiriꞌ ri Zacarías xukꞌis taq ruqꞌijol kachakun chupa ri Rocho Dios, xeꞌek chirocho. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Kꞌa tekꞌuchiriꞌ, ri rixoqil Elizabet xkanajik yewaꞌ ixoq. Woꞌobꞌ ikꞌ kꞌu riꞌ xuchajij ribꞌ chirocho, e riꞌ na xel tubꞌi. Yey xaqi jewaꞌ ri kuchꞌobꞌo: ");
INSERT INTO acrNNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","«E ri Nuqaw Dios ꞌanayom waꞌ chwe ma xinjuchꞌ kaꞌn che y xresaj ri chꞌamibꞌal we.» ");
INSERT INTO acrNNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ikꞌowinaq chi kꞌu waqibꞌ ikꞌ riꞌ echiriꞌ ri ángel Gabriel xtaq lo ruma ri Dios chupa jun tinamit Nazaret rubꞌiꞌ, pa ri luwar re Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xtaq lo rukꞌ jun qꞌapoj ali María rubꞌiꞌ, yey rire lik jusukꞌ rubꞌinik chwach ri Dios. Ri María unimam chik kakꞌuliꞌ rukꞌ jun ala José rubꞌiꞌ, yey rire e jun chike ri ralkꞌoꞌal kan ri rey David. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Ekꞌuchiriꞌ, xok bꞌi ri ángel pa kꞌo wi ri María, y jewaꞌ ri rutzil uwach xuyaꞌo: —¡Chatkiꞌkotoq! E riꞌat lik nim aqꞌij awalaxik chikixoꞌl konoje rixoqibꞌ. Ma ri Dios Qajawxel kꞌo awukꞌ yey akꞌulum ri unimal rutzil ukꞌuꞌx Rire —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ri María echiriꞌ xuta waꞌ wa chꞌaꞌtem, xsach unaꞌoj puwiꞌ y jewaꞌ xutzꞌonoj chiribꞌil ribꞌ: “¿Saꞌ keꞌelawi wa kabꞌiꞌx chwe?” ");
INSERT INTO acrNNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ekꞌuchiriꞌ, ri ángel jewaꞌ xubꞌiꞌij che: —María, maxiꞌij awibꞌ, ma ariqom ri unimal rutzil ukꞌuꞌx ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Ekꞌu woꞌora katkanajik at yewaꞌ ixoq, kalax jun awalabꞌ y Jesús rubꞌiꞌ kakojo. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Rire lik nim uqꞌij y kabꞌiꞌx che e Ukꞌajol ri Jun kataqan chwi ronoje. Ekꞌu ri Dios Qajawxel kuya puqꞌabꞌ kuꞌan rey jelaꞌ pachaꞌ ri rey David, rumam re ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Y kayaꞌtaj che kataqan puwi ri tinamit Israel yey rutaqanik na jinta utaqexik —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Ekꞌu ri María xutzꞌonoj che ri ángel: —¿Suꞌanik kuꞌana riꞌ waꞌ, we riꞌin kꞌa jinta ne wachijil? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ri ángel xukꞌul uwach: —E ri Santowilaj Ruxlabꞌixel ri Dios kaqaj lo pawiꞌ y ruchuqꞌabꞌ ri Jun kataqan chwi ronoje, kuchꞌuq awiꞌ pachaꞌ sutzꞌ. E uwariꞌche rakꞌa kalaxik kabꞌiꞌx che e Santowilaj Ukꞌajol ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Y chatape waꞌ, jenelaꞌ rawatz-achaqꞌ Elizabet umatzem chi jun akꞌa tobꞌ lik nimalaj winaq chik. E ri kabꞌiꞌx che na utz taj kalanik, woꞌora yewaꞌ ixoq y e uwaqibꞌ ikꞌ waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Ma chwach ri Dios na jinta kꞌana kꞌayew —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Ekꞌuchiriꞌ, xubꞌiꞌij ri María: —Riꞌin puqꞌabꞌ ri Nuqaw Dios in kꞌo wi. Ekꞌu Rire chuꞌana wukꞌ janipa ri xbꞌiꞌij la chwe —xchaꞌ. Ekꞌuchiriꞌ, ri ángel xel bꞌi chwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Kꞌo kꞌu jun qꞌij ri María xuyak bꞌi ribꞌ y lik kanik xumaj bꞌi ubꞌe chujuyubꞌ chupa jun tinamit re Judea. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Echiriꞌ xoponik, xok chirocho ri Zacarías y xuya rutzil uwach ri Elizabet. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Xew kꞌu xuta ri Elizabet ri rutzil uwach xyaꞌ ruma ri María, rakꞌa umatzem lik xuyikij ribꞌ y ri Santowilaj Ruxlabꞌixel ri Dios xqaj puwi ri Elizabet. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Ruma kꞌu riꞌ, lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: —Nim aqꞌij awalaxik riꞌat chikixoꞌlibꞌal konoje rixoqibꞌ y nim uqꞌij rawalabꞌ amatzem. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Chaꞌtaj yaꞌtajinaq kan waꞌ chwe riꞌin koꞌlbꞌina ruchu ri Qanimajawal wukꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Ma xew xinta ri rutzil nuwach xayaꞌo, na jampatana rakꞌa numatzem lik xuyikij ribꞌ ruma rukiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nim aqꞌij awalaxik riꞌat ma xakoj ronoje janipa ri xbꞌiꞌx chawe ruma ri Dios Qajawxel yey waꞌ lik e kuꞌanaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ekꞌuchiriꞌ, ri María xubꞌiꞌij: «Riꞌin lik kanyak uqꞌij ri Dios Qajawxel, ");
INSERT INTO acrNNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","y ri wanimaꞌ lik kakiꞌkot rukꞌ ri Dios Nukolobꞌenel; ");
INSERT INTO acrNNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ma xinjuchꞌ kaꞌn che, tobꞌ in jun raj chak na jinta ko nuwach. Chwi kꞌu riꞌ woꞌora konoje ri tikawex kakibꞌiꞌij na chwe: “Lik nim aqꞌij awalaxik riꞌat” ");
INSERT INTO acrNNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ma e ruchuqꞌabꞌ ri Dios Qajawxel lik saꞌch taq ri utz uꞌanom wukꞌ. Ekꞌu rubꞌiꞌ Rire lik nim uqꞌij Santo. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Y kukꞌut na ri rutzil ukꞌuꞌx chike janipa ri kꞌo xiꞌin ibꞌ pa kanimaꞌ chwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Rire e ꞌanayom ukꞌiyal chak rukꞌ ruchuqꞌabꞌ. Usachisam ri kinaꞌoj ri kakiꞌan nim che kibꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","y resam ri taqanik pakiqꞌabꞌ ri e nimaq taqanelabꞌ; yey uyakom kiqꞌij ri lik na jinta ko kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Chike ri kenumik, uyaꞌom kibꞌeyomalil; noꞌj ri bꞌeyomabꞌ xebꞌutaq bꞌi y na jinta kꞌo xuya bꞌi chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ebꞌutoꞌom kꞌu rutinamit Israel, taq ri raj chak Rire; yey na umeskꞌutam ta ukꞌutik ri rutzil ukꞌuꞌx ");
INSERT INTO acrNNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","na jinta utaqexik che ri Abraham y chike konoje ri ralkꞌoꞌal kanoq, jelaꞌ pachaꞌ rubꞌiꞌtisim chike ri qatiꞌ-qamam ojertan» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Y ri María laj oxibꞌ ikꞌ xkanaj kan chirocho ri Elizabet. Kꞌa tekꞌuchiriꞌ, xtzelej lo chirocho. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ekꞌuchiriꞌ xopon ruqꞌij ri Elizabet re kutzir uwach, xalax ri ralabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Y echiriꞌ ri ejeqel lo chunaqaj rire y taq ri kꞌo chux che xkito xutzir uwach ruma runimal rutzil ukꞌuꞌx ri Dios kꞌutum lo che, lik xekiꞌkot junam rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Echiriꞌ rakꞌa xukꞌis wajxaqibꞌ qꞌij ralaxik, xekꞌun lo ri kekojow ri retalil re circuncisión chaꞌ kakiꞌan waꞌ che. Yey rubꞌiꞌ xkaj kakikojo e Zacarías, jelaꞌ pachaꞌ rubꞌiꞌ ruqaw. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Noꞌj ruchu xubꞌiꞌij chike: —Na kakoj ta Zacarías che, ma Juan rubꞌiꞌ kakojik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Xkibꞌiꞌij kꞌu che: —¿Suꞌbꞌe riꞌ? Ma na jinta junoq chikixoꞌl ri atz-chaqꞌ la jelaꞌ rubꞌiꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ekꞌuchiriꞌ, rukꞌ ri kiqꞌabꞌ xkitzꞌonoj pan che ruqaw rakꞌa saꞌ ri bꞌiꞌaj karaj rire kakoj che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ekꞌu ruqaw rakꞌa xutzꞌonoj juperaj tzꞌalam re tzꞌibꞌanik y jewaꞌ xutzꞌibꞌaj chwach: «Juan rubꞌiꞌ kakojik.» Y konoje lik xkam kanimaꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kꞌa ekꞌuchiriꞌ, ri Zacarías xjaqataj ruchꞌawibꞌal y jelaꞌ utz xchꞌaw tanchik. Y xujeq kꞌu riꞌ kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Y konoje ri tikawex katajin waꞌ pa kijolom rukꞌ xiꞌin ibꞌ, y xeꞌek kꞌu utzijoxik waꞌ chike konoje ri e kꞌo pa taq ri juyubꞌ re Judea. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Yey janipa kꞌu ri xetaw re rutzijoxik, xkikꞌol waꞌ pa kanimaꞌ y kakichꞌobꞌ kꞌu raqan: «¿Saꞌ nawi ruwach wa ralko ala echiriꞌ kanimarik?» kechaꞌ. Jewaꞌ xkibꞌiꞌij ma lik qꞌalaj ri Dios uqꞌalajisam ruchuqꞌabꞌ puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ekꞌuchiriꞌ, ri Zacarías ruqaw ri ralko ala xujeq kaqꞌalajisanik ma ri Santowilaj Ruxlabꞌixel ri Dios xqaj lo puwiꞌ; jekꞌuwaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","«Lik nim uqꞌij ri Dios Qajawxel re Israel ma xkꞌun qukꞌ re kojoꞌlukolobꞌej ri oj utinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Xutaq lo jun Qakolobꞌenel lik kꞌo uchuqꞌabꞌ yey Rire elinaq lo chikixoꞌl ri ralkꞌoꞌal kan ri David, ri raj chak ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ma ojertan e ubꞌiꞌim lo waꞌ kuma ri qꞌalajisanelabꞌ e jusukꞌ chwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ubꞌiꞌim kojoꞌlukolobꞌej pakiqꞌabꞌ ri tzel kebꞌilow qe y pakiqꞌabꞌ ri kechꞌamin qeꞌoj ");
INSERT INTO acrNNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","chaꞌ kukꞌut ri rutzil ukꞌuꞌx chike ri qatiꞌ-qamam y na kumeskꞌutaj ta ri santowilaj utzij uꞌanom lo ojertan ");
INSERT INTO acrNNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","puwi ri bꞌiꞌtisinik xuꞌan che ri qaqaw Abraham. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ubꞌiꞌtisim kojoꞌlresaj pakiqꞌabꞌ ri tzel kebꞌilow qe chaꞌ jelaꞌ na rukꞌ ta xiꞌin ibꞌ kaqaloqꞌnimaj ");
INSERT INTO acrNNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ronoje qꞌij che ri qakꞌaslem rukꞌ jun santowilaj qabꞌinik qasilabꞌik y jusukꞌ qakꞌojiꞌik chwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ekꞌu riꞌat nukꞌajol, kabꞌiꞌx chawe at qꞌalajisanel re ri Jun kataqan chwi ronoje; ma katnabꞌej bꞌi chwach ri Qanimajawal re kabꞌiꞌij chike ri winaq kakiyijbꞌaꞌ ri kibꞌinik kisilabꞌik chwa rukꞌunibꞌal Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Y katnabꞌej bꞌi chwach chaꞌ ri qatinamit kaketaꞌmaj ri Dios kebꞌukolobꞌej ma kukuy ri kimak. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ekꞌu ri qa Dios, ruma ri unimal rutzil ukꞌuꞌx, kutaq lo ri Jun qukꞌ re chilaꞌ chikaj, waꞌ e pachaꞌ ri Qꞌijsaq re rusaqribꞌal ");
INSERT INTO acrNNT_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","chaꞌ kebꞌuya pa qꞌijsaq ri e kꞌo pa qꞌequꞌm y e kꞌo chuxeꞌ ri kamik, yey kukꞌam qawach chupa ri bꞌe re ri utzil chomal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Y rukꞌajol ri Zacarías katajin unimarik y katajin ukꞌojiꞌik uchuqꞌabꞌ chwach ri Dios. Xjeqiꞌ kꞌu pa taq luwar katzꞌintzꞌotik, xopon na ruqꞌijol echiriꞌ xukꞌut uwach chikiwach ri tinamit Israel. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Chupa taq laꞌ la qꞌij, ri Augusto ri nimalaj taqanel re Roma, xtaqan che kaꞌan jun ajilanik chike konoje ri tikawex re taq ri tinamit pa kataqan wi rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","E nabꞌe ajilanik xtaqan che uꞌanik, yey xꞌaniꞌ waꞌ echiriꞌ ri Cirenio e aj wach re ri nación Siria. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Ruma wa ajilanik, konoje ri tikawex kebꞌek chikijujunal pa ri kitinamit chaꞌ kebꞌajilaxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","E uwariꞌche ri José xel bꞌi chiriꞌ Galilea chupa raldea Nazaret pa jeqel wi, y xeꞌek Judea chupa raldea Belén pa xalax wi ri rey David, ma ri José ralkꞌoꞌal kan ri David. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Ruma kꞌu wa ajilanik, xeꞌek junam rukꞌ ri María, ri yaꞌtal chi che re rixoqil. Yey ri María yewaꞌ ixoq chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Ekꞌuchiriꞌ e kꞌo chi Belén, xopon ruqꞌijol kutzir uwach ri María. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Ruma kꞌu na xkiriq ta luwar pa mesón, xekꞌojiꞌ pa jun luwar re kiwarabꞌal chikop. Xalax kꞌu riꞌ ri nabꞌe ralabꞌ ri María. Rire xupis rakꞌa chi utz pa kꞌul y xukotzꞌobꞌaꞌ pa jun kanawa re kiwaꞌbꞌal chikop. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Chunaqaj Belén e kꞌo aj chajal bꞌexex kakikꞌowibꞌej raqꞌabꞌ pa juyubꞌ re kekichajij ri kibꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Yey xaqikꞌateꞌt xwinaqir jun ángel re ri Dios Qajawxel chikiwach. Ewi runimal uchomalil ri Dios xutzij kiwiꞌ y rike lik xkixiꞌij kibꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Pero ri ángel xubꞌiꞌij chike: «Mixiꞌij iwibꞌ, ma nukꞌamom lo utzilaj tzij chiwe re unimal kiꞌkotemal chike konoje rutinamit ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Ma waqꞌij pa ri tinamit re ri rey David, xalax jun Kolobꞌenel iwe; e ri Qanimajawal, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ri kꞌutubꞌal re waꞌ e kiriq ri ralko akꞌa pistal pa kꞌul, kotzꞌol chupa jun kanawa re kiwaꞌbꞌal chikop» xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Ekꞌu laꞌ la joqꞌotaj ukꞌiyal ángeles re chilaꞌ chikaj xaqikꞌateꞌt xewinaqir rukꞌ ri jun ángel, e riꞌ kakibꞌixoj rubꞌiꞌ ri Dios, jewaꞌ kakibꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","«¡Nim uqꞌij ri Dios kꞌo chilaꞌ chikaj! Yey che ruwachulew, kꞌola ri utzil chomal re ri Dios kukꞌ ri kakikꞌul ri rutzil ukꞌuꞌx Rire» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Ekꞌuchiriꞌ xetzelej ri ángeles chilaꞌ chikaj, raj chajal bꞌexex jewaꞌ xkibꞌiꞌij chikiwach: «Joꞌ riꞌ kꞌa chilaꞌ Belén. Jeꞌqila wa xoluꞌbꞌiꞌij ri Dios Qajawxel chiqe» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Lik kꞌu kebꞌanik xebꞌek y xeꞌkiriqa ri María, ri José yey ri ralko akꞌa kotzꞌol chupa ri kanawa re kiwaꞌbꞌal chikop. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Yey echiriꞌ xkil uwach ri ralko akꞌa, xkitzijoj ri xubꞌiꞌij ri ángel chike chwi Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Y konoje ri xetaw re waꞌ, lik xkam kanimaꞌ che ri kakitzijoj raj chajal bꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Noꞌj ri María lik ukꞌolom ronoje waꞌ pa ranimaꞌ y lik kuchꞌobꞌ raqan puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Tekꞌuchiriꞌ, raj chajal bꞌexex xetzelejik, kebꞌixonik y kakiyak uqꞌij ri Dios ruma ronoje ri xkilo y xkito, ma e xuꞌano pachaꞌ ri bꞌiꞌim bꞌi chike ruma ri ángel. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Echiriꞌ xukꞌis wajxaqibꞌ qꞌij ralaxik ri ralko akꞌa, xkoj ri retalil re circuncisión che. Y Jesús rubꞌiꞌ xkojik, ma echiriꞌ kꞌamajaꞌ ne kamatzexik, ri ángel xubꞌiꞌij e bꞌiꞌaj waꞌ kakoj che. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Xopon kꞌu ri qꞌij echiriꞌ chirajawaxik ri José y ri María kebꞌek Jerusalem ruma ri kijosqꞌikil chwach ri Dios, jelaꞌ pachaꞌ ri kꞌo chupa ri taqanik re ri Moisés. Xkikꞌam kꞌu bꞌi ri ralko akꞌa Jerusalem chaꞌ kakiya puqꞌabꞌ ri Dios Qajawxel. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Xkiꞌan waꞌ ma jewaꞌ tzꞌibꞌital chupa Rutzij Upixabꞌ ri Dios Qajawxel: «Konoje ri raltaq ko alabꞌo kebꞌalax nabꞌe, keyaꞌ puqꞌabꞌ ri Dios Qajawxel» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Xebꞌek kꞌu riꞌ chaꞌ keꞌkiyaꞌa ri kiqasaꞌn pachaꞌ ri kubꞌiꞌij chupa Rutzij Upixabꞌ ri Dios Qajawxel: «Jukꞌulaj xmukur o jukꞌulaj raltaq ko palomax» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Chiriꞌ Jerusalem kꞌo jun achi Simeón rubꞌiꞌ. Rire lik jusukꞌ rubꞌinik usilabꞌik, lik kukuxtaj ri Dios y royeꞌem ri kolobꞌetajik re ri tinamit Israel. Ri Santowilaj Ruxlabꞌixel ri Dios kꞌo rukꞌ ");
INSERT INTO acrNNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","y uqꞌalajisam chi che, na kakam tana we na karil tubꞌi uwach Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ekꞌu waꞌchi xunaꞌ pa ranimaꞌ ruma ri Ruxlabꞌixel ri Dios keꞌek pa ri Rocho Dios, y xeꞌek kꞌut. Ekꞌuchiriꞌ, ruchu-uqaw ri ralko akꞌa Jesús xkikꞌam lo pa ri Rocho Dios chaꞌ kakiꞌan rukꞌ pachaꞌ ri kubꞌiꞌij ri taqanik re ri Tzij Pixabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Ewi ri Simeón xuqꞌaluj ri ralko akꞌa y xuyak uqꞌij ri Dios, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","«Lal Dios Qajawxel, riꞌin xa in jun aj chak la. Ekꞌu woꞌora utz kinkam chi utzil chomal, ma xꞌan la janipa ri bꞌiꞌtisim la chwe; ");
INSERT INTO acrNNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ya xinwil uwach ri Kolobꞌenel, ");
INSERT INTO acrNNT_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ri yaꞌom la chikiwach konoje taq ri tinamit che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Y Rire e Qꞌijsaq kuqꞌalajisaj ri bꞌe re ri Dios chike konoje taq rukꞌiyal kiwach ri tikawex che ruwachulew, yey ruma Rire kayak uqꞌij ri tinamit la Israel» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ruchu-uqaw ri Jesús lik kakam kanimaꞌ che taq ri kabꞌiꞌx chwi ri ralko akꞌa. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Ekꞌuchiriꞌ, ri Simeón xebꞌuꞌan bendecir. Yey jewaꞌ xubꞌiꞌij che ri María ruchu ri Jesús: —¡Chatapeꞌ! Ruma wa ralko akꞌa lik e kꞌi chike ri tinamit Israel keyaktajik yey lik e kꞌi ri ketzaqik. Ma Rire yaꞌtal lo ruma ri Dios re jun kꞌutubꞌal; noꞌj ukꞌiyal tikawex na kakikꞌul taj y lik tzel kakilo. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Y jekꞌulaꞌ kaqꞌalajinik saꞌ ri kꞌo pa kanimaꞌ ukꞌiyal tikawex, we utz o na utz taj. Yey kambꞌiꞌij kꞌu chawe riꞌat: Kopon na jun qꞌij echiriꞌ lik kꞌax kunaꞌ akꞌuꞌx, ma e kuꞌana pachaꞌ kikꞌowisax juna kuchilo pa rawanimaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Chiriꞌ kꞌu riꞌ kꞌo jun ixoq qꞌalajisanel Ana rubꞌiꞌ, umiꞌal ri Fanuel, ri ralkꞌoꞌal kan ri Aser. Rire lik nimalaj winaq chik. Wuqubꞌ junabꞌ kꞌuliꞌnaq echiriꞌ xkam ri rachijil, ");
INSERT INTO acrNNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","yey ya e ochenta y cuatro junabꞌ riꞌ malkaꞌn kanoq. Rire xaqi kꞌo pa ri Rocho Dios y kuloqꞌnimaj ri Dios rukꞌ ayuno y rukꞌ oración chipaqꞌij chichaqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Xopon kꞌu pan riꞌ ri Ana pa kꞌo wi ri Jesús y xtioxin chwach ri Dios. Ekꞌuchiriꞌ, xujeqo kachꞌaꞌt puwi ri ralko akꞌa chike konoje ri koyeꞌem ri kolobꞌetajik re Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Echiriꞌ ruchu-uqaw ri Jesús xkikꞌis uꞌanik ronoje ri tzꞌibꞌital chupa Rutzij Upixabꞌ ri Dios, xetzelej tanchi Galilea chupa ri tinamit Nazaret. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Y ri ralko akꞌa katajin ukꞌiyik, katajin ukꞌojiꞌik uchuqꞌabꞌ y katajin ukꞌojiꞌik unaꞌoj. Yey ri unimal rutzil ukꞌuꞌx ri Dios kꞌo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Ronoje junabꞌ ruchu-uqaw ri Jesús kebꞌek Jerusalem re keꞌkiꞌana ri nimaqꞌij Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Echiriꞌ ri Jesús xukꞌis kabꞌlajuj junabꞌ, ruchu-uqaw xebꞌek Jerusalem jelaꞌ pachaꞌ xex kakiꞌan wi, yey xkikꞌam bꞌi ri Jesús kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ekꞌuchiriꞌ xkꞌis ri nimaqꞌij, ruchu-uqaw xkimaj lo kibꞌe. Noꞌj ri Jesús xkanaj kan Jerusalem, yey waꞌ na xkinaꞌbꞌej ta ruchu-uqaw. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","E pa kinaꞌoj rike petinaq ri Jesús chikixoꞌl ri e kachbꞌiꞌil. Xebꞌin kꞌu jun qꞌij; kꞌa tekꞌuchiriꞌ, xkijeq kakitzukuj ri Jesús chikixoꞌl ri katz-kichaqꞌ y taq ri ketaꞌam kiwach, ");
INSERT INTO acrNNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","pero na xkiriq taj. Ruma kꞌu riꞌ, xetzelej pa ri tinamit Jerusalem chaꞌ kekitzukuj chilaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ekꞌuchiriꞌ ikꞌowinaq chi oxibꞌ qꞌij kakitzukuj, xeꞌkiriqa ri Jesús chupa ri Rocho Dios tzꞌul chikixoꞌl doctorabꞌ re ri tzijpixabꞌ. Rire kebꞌutataꞌ y kuꞌan tzꞌonobꞌal chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Y konoje ri ketaw re lik kakam kanimaꞌ che runaꞌoj y che ri kꞌulubꞌal uwach kuꞌan chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Echiriꞌ xkil waꞌ ruchu-uqaw, lik xkam kanimaꞌ che y jewaꞌ xubꞌiꞌij ruchu che: —Walabꞌ, ¿suꞌchak jewaꞌ kaꞌan chiqe? Raqaw y riꞌin lik paxinaq chi qakꞌuꞌx che atzukuxik —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ekꞌu ri Jesús xubꞌiꞌij chike: —¿Suꞌchak kintzukuj alaq? ¿Na etaꞌam ta nebꞌa alaq pa kinriqitaj wi? Ma lik chirajawaxik kinkꞌojiꞌ che ri chak re ri Nuqaw —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Noꞌj rike na xkimaj tane usukꞌ ri xubꞌiꞌij chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Tekꞌuchiriꞌ, ri Jesús xtzelej Nazaret junam kukꞌ ruchu-uqaw y e riꞌ lik uyaꞌom ribꞌ chitaqik kuma rike. Ekꞌu ruchu katajin chukꞌuꞌx taq waꞌ y lik ukꞌolom ronoje pa ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Y ri Jesús katajin unimarik y katajin ukꞌojiꞌik más runaꞌoj ri Dios rukꞌ. Ronoje ri kuꞌano lik utz chwach ri Dios y chikiwach konoje ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Chupa ri woꞌlajuj junabꞌ re rutaqanik ri nimalaj taqanel Tiberio, ri aj wach re Judea e ri Poncio Pilato, ri aj wach re Galilea e ri Herodes, ri aj wach re Iturea y re Traconite e ri Felipe ruchaqꞌ ri Herodes, y ri aj wach re Abilinia e ri Lisanias. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ekꞌu ri Anás y ri Caifás e kajawal raj chakunel pa Rocho Dios. Chupa taq kꞌu riꞌ laꞌ la qꞌij, ri Dios xuya rutzij che ri Juan rukꞌajol ri Zacarías, chupa ri luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Rire xel bꞌi y xeꞌek che ronoje taq ri luwar e kꞌo chuchiꞌ ri nimayaꞌ Jordán re kubꞌiꞌij chike ri winaq kakitzelej kitzij chwach ri Dios, kakikꞌul ri bautismo, y jekꞌulaꞌ kakuytaj ri kimak. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Wa xuꞌan ri Juan e ri tzꞌibꞌital kan chupa ruchꞌaꞌtem ri qꞌalajisanel Isaías, pa kubꞌiꞌij wi: Katataj uqul jun tzijonel kasikꞌin chupa ri luwar katzꞌintzꞌotik, jewaꞌ kubꞌiꞌij: “Yijbꞌaꞌ pana alaq ri bꞌe re ri Qanimajawal; sukꞌupij alaq rubꞌe Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Chirajawaxik kꞌut kapaqꞌ ronoje juyubꞌ y kabꞌalix upa ronoje siwan; kasukꞌupix ri nimabꞌe na jusukꞌ taj y kasukꞌupix kꞌu uwiꞌ chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Y konoje kꞌu ri winaq kakil na ri kolobꞌetajik kuya ri Dios” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Ukꞌiyal kꞌu winaq xekꞌun rukꞌ ri Juan chaꞌ kakikꞌul ri bautismo kuya rire. Ekꞌu rire jewaꞌ xubꞌiꞌij chike: —¡Ralaq pachaꞌ alaq jupuq chi kumatz! ¿China xbꞌiꞌn re we utz kesaj ibꞌ alaq chwach ri unimal kꞌaxkꞌobꞌik kutaq lo ri Dios pawiꞌ alaq? ");
INSERT INTO acrNNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Bꞌina alaq jusukꞌ chaꞌ jelaꞌ kaqꞌalajinik jalkꞌatim chi ri bꞌinik silabꞌik alaq, jelaꞌ pachaꞌ ri taqal chike ri kitzelem chi kitzij. Y machꞌobꞌ ne alaq chi ibꞌil ibꞌ alaq waꞌ: “Riꞌoj utz qaꞌanom ma oj ralkꞌoꞌal kan ri Abraham.” Ma riꞌin kambꞌiꞌij che alaq, we xraj ri Dios, utz kuꞌan ralkꞌoꞌal ri Abraham tobꞌ ne che taq waꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Yey jikil chi ne uwach ruqꞌatbꞌal tzij ri Dios pawiꞌ alaq, e pachaꞌ juna achi uyakom chi ri ikaj chwi ri ratzꞌayaq ri cheꞌ; ekꞌu taq ri cheꞌ na kuya ta chomilaj jiqꞌobꞌal, kapoqꞌix bꞌi y kakꞌaq pa aqꞌ —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Ekꞌu ri winaq jewaꞌ xkitzꞌonoj che: —¿Saꞌ kꞌu riꞌ ri kaqaꞌano chaꞌ kuꞌan chom ri qabꞌinik qasilabꞌik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Y rire xukꞌul uwach chike: —China ri kꞌo kaꞌibꞌ uqꞌuꞌ, chusipaj jun che ri na jinta uqꞌuꞌ; y china ri lik kꞌo katij rukꞌ, chuyaꞌa ke ri na jinta kꞌo kakitijo —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Ekꞌu raj tzꞌonol puaq re tojonik xebꞌopon rukꞌ ri Juan chaꞌ kakikꞌul ri bautismo y jewaꞌ xkitzꞌonoj che: —Lal tijonel, ¿saꞌ ri chirajawaxik kaqaꞌan riꞌoj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Y rire jewaꞌ xubꞌiꞌij chike: —Xew chitzꞌonoj ri puaq re tojonik bꞌiꞌtal ruma ri taqanel romano; mitzꞌonoj uwiꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Ekꞌu ri soldados xkitzꞌonoj che, jewaꞌ xkibꞌiꞌij: —Yey riꞌoj, ¿saꞌ ri chirajawaxik kaqaꞌano? —xechaꞌ. Ewi jewaꞌ xubꞌiꞌij chike: —Mimaj ubꞌitaq re junoq y miꞌan ri kixibꞌij upa junoq rukꞌ kamik. Mikoj umak ri na jinta umak y chixkiꞌkota rukꞌ riwajil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Taq ri winaq lik koyeꞌem rukꞌunibꞌal ri Cristo y konoje kakitzꞌonobꞌej chikibꞌil kibꞌ we ri Juan e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ruma kꞌu waꞌ, ri Juan jewaꞌ xubꞌiꞌij chike: —Riꞌin paqatzij wi kanya ri bautismo che alaq rukꞌ yaꞌ; noꞌj kꞌo Jun katajin loq más kꞌo uwach y más kꞌo uchuqꞌabꞌ chinuwa riꞌin. Na taqal tane chwe riꞌin kankir ruwach ruxajabꞌ. Ri bautismo kuya Rire che alaq, e rukꞌ ri Santowilaj Ruxlabꞌixel ri Dios y rukꞌ aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Ri kuꞌano e pachaꞌ juna achi rukꞌaꞌam chi ri puꞌbꞌal uwach ri trigo puqꞌabꞌ chaꞌ naꞌl kujosqꞌij waꞌ y karesaj rupukꞌ chupa. Tekꞌuchiriꞌ, kujok ri trigo y kukꞌol chupa rukꞌolibꞌal. Ekꞌu rupukꞌ kuporoj pa ri jun aqꞌ na jinta utaqexik katenowik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Jekꞌulaꞌ, rukꞌ ukꞌiyal pixabꞌanik ri Juan kutzijoj ri Utzilaj Tzij chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Y xuchꞌaꞌbꞌej ne upa ri rey Herodes ruma uꞌanom rixoqil che ri Herodías yey waꞌ wiꞌxoq e rixoqil ri Felipe ruchaqꞌ ri Herodes. Xuchꞌaꞌbꞌej kꞌu upa ruma taq ronoje ri na utz taj uꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Yey ri Herodes xuya ne más uwiꞌ ri na utz taj uꞌanom, ma xtaqan che kayaꞌ ri Juan pa cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Kꞌo kꞌu jun qꞌij echiriꞌ lik ukꞌiyal tikawex kakikꞌul ri bautismo, xopon ri Jesús y xukꞌul ri bautismo. Echiriꞌ katajin che uꞌanik orar, xjaqataj ruwa kaj ");
INSERT INTO acrNNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y ri Santowilaj Ruxlabꞌixel ri Dios xqaj lo puwiꞌ pachaꞌ juna palomax. Y xchꞌaw lo Jun chilaꞌ chikaj, jewaꞌ kubꞌiꞌij: «At riꞌat Nukꞌajol, y lik kꞌax katinnaꞌo. Lik kinkiꞌkot chawe» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ri Jesús laj treinta rujunabꞌ echiriꞌ xujeq ri chak taqom lo che uꞌanik ruma ri Dios. Kabꞌiꞌx che ri Jesús, e ukꞌajol ri José. Yey ri José, e ralkꞌoꞌal ri Elí. ");
INSERT INTO acrNNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Ri Elí e ralkꞌoꞌal ri Matat; ri Matat e ralkꞌoꞌal ri Leví; ri Leví e ralkꞌoꞌal ri Melqui; ri Melqui e ralkꞌoꞌal ri Jana; ri Jana e ralkꞌoꞌal ri José; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ri José e ralkꞌoꞌal ri Matatías; ri Matatías e ralkꞌoꞌal ri Amós; ri Amós e ralkꞌoꞌal ri Nahum; ri Nahum e ralkꞌoꞌal ri Esli; ri Esli e ralkꞌoꞌal ri Nagai; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ri Nagai e ralkꞌoꞌal ri Maat; ri Maat e ralkꞌoꞌal ri Matatías; ri Matatías e ralkꞌoꞌal ri Semei; ri Semei e ralkꞌoꞌal ri José; ri José e ralkꞌoꞌal ri Judá; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ri Judá e ralkꞌoꞌal ri Joana; ri Joana e ralkꞌoꞌal ri Resa; ri Resa e ralkꞌoꞌal ri Zorobabel; ri Zorobabel e ralkꞌoꞌal ri Salatiel; ri Salatiel e ralkꞌoꞌal ri Neri; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ri Neri e ralkꞌoꞌal ri Melqui; ri Melqui e ralkꞌoꞌal ri Adi; ri Adi e ralkꞌoꞌal ri Cosam; ri Cosam e ralkꞌoꞌal ri Elmodam; ri Elmodam e ralkꞌoꞌal ri Er; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ri Er e ralkꞌoꞌal ri Josué; ri Josué e ralkꞌoꞌal ri Eliezer; ri Eliezer e ralkꞌoꞌal ri Jorim; ri Jorim e ralkꞌoꞌal ri Matat; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ri Matat e ralkꞌoꞌal ri Leví; ri Leví e ralkꞌoꞌal ri Simeón; ri Simeón e ralkꞌoꞌal ri Judá; ri Judá e ralkꞌoꞌal ri José; ri José e ralkꞌoꞌal ri Jonán; ri Jonán e ralkꞌoꞌal ri Eliaquim; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ri Eliaquim e ralkꞌoꞌal ri Melea; ri Melea e ralkꞌoꞌal ri Mainán; ri Mainán e ralkꞌoꞌal ri Matata; ri Matata e ralkꞌoꞌal ri Natán; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ri Natán e ralkꞌoꞌal ri David; ri David e ralkꞌoꞌal ri Isaí; ri Isaí e ralkꞌoꞌal ri Obed; ri Obed e ralkꞌoꞌal ri Booz; ri Booz e ralkꞌoꞌal ri Salmón; ri Salmón e ralkꞌoꞌal ri Naasón; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ri Naasón e ralkꞌoꞌal ri Aminadab; ri Aminadab e ralkꞌoꞌal ri Aram; ri Aram e ralkꞌoꞌal ri Esrom; ri Esrom e ralkꞌoꞌal ri Fares; ri Fares e ralkꞌoꞌal ri Judá; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ri Judá e ralkꞌoꞌal ri Jacob; ri Jacob e ralkꞌoꞌal ri Isaac; ri Isaac e ralkꞌoꞌal ri Abraham; ri Abraham e ralkꞌoꞌal ri Taré; ri Taré e ralkꞌoꞌal ri Nacor; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ri Nacor e ralkꞌoꞌal ri Serug; ri Serug e ralkꞌoꞌal ri Ragau; ri Ragau e ralkꞌoꞌal ri Peleg; ri Peleg e ralkꞌoꞌal ri Heber; ri Heber e ralkꞌoꞌal ri Sala; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ri Sala e ralkꞌoꞌal ri Cainán; ri Cainán e ralkꞌoꞌal ri Arfaxad; ri Arfaxad e ralkꞌoꞌal ri Sem; ri Sem e ralkꞌoꞌal ri Noé; ri Noé e ralkꞌoꞌal ri Lamec; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ri Lamec e ralkꞌoꞌal ri Matusalén; ri Matusalén e ralkꞌoꞌal ri Enoc; ri Enoc e ralkꞌoꞌal ri Jared; ri Jared e ralkꞌoꞌal ri Mahalaleel; ri Mahalaleel e ralkꞌoꞌal ri Cainán; ");
INSERT INTO acrNNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ri Cainán e ralkꞌoꞌal ri Enós; ri Enós e ralkꞌoꞌal ri Set; ri Set e ralkꞌoꞌal ri Adán; yey ri Adán e ralkꞌoꞌal ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ekꞌu ri Jesús xel bꞌi che ri luwar re ri nimayaꞌ Jordán yey lik kꞌo ri Ruxlabꞌixel ri Dios rukꞌ. Xkꞌam kꞌu bꞌi ruma ri Ruxlabꞌixel ri Dios pa jun luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Xkꞌojiꞌ chilaꞌ cuarenta qꞌij y xkꞌam upa ruma ritzel winaq. Yey chupa taq waꞌ wa qꞌij na jinta kꞌo xutijo. Chukꞌisbꞌal kꞌu re ri cuarenta qꞌij, lik xnumik. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ekꞌuchiriꞌ, ritzel winaq jewaꞌ xubꞌiꞌij che: —We qatzij at Ukꞌajol ri Dios, chat-taqan che chaꞌ waꞌbꞌaj kuꞌan wa —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Ri Jesús xukꞌul uwach: —Jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Na xew ta ruma ri wa e kꞌas ri tikawex; ma e kꞌaslik ruma taq ronoje rubꞌiꞌim ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ekꞌuchiriꞌ, ritzel winaq xukꞌam bꞌi ri Jesús chutzaꞌm jun nimalaj juyubꞌ y xa pa joqꞌotaj xukꞌut kꞌu chwach, ronoje ri taqanik kaꞌan puwi taq ri tinamit che ruwachulew ");
INSERT INTO acrNNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","y jewaꞌ xubꞌiꞌij che: —Ronoje wa kawilo rukꞌ ronoje ruchomalil taq waꞌ, kanya paqꞌabꞌ, ma yaꞌtal kan panuqꞌabꞌ riꞌin yey panuqꞌabꞌ kꞌo wi china che kuaj kanya wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kanya kꞌu ronoje waꞌ paqꞌabꞌ riꞌat we kaxukubꞌaꞌ awibꞌ chinuwach y kaloqꞌnimaj nuqꞌij —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Ri Jesús xukꞌul uwach: —Chatela chinuwach Satanás, ma jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Lik chaloqꞌnimaj uqꞌij ri Dios Qajawxel y xew Rire chanimaj uqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Tekꞌuchiriꞌ, ritzel xukꞌam bꞌi ri Jesús chupa ri tinamit Jerusalem kꞌa chikaj che ruwi ri Rocho Dios y jewaꞌ xubꞌiꞌij che: —We qatzij at Ukꞌajol ri Dios, chakꞌaqa bꞌi awibꞌ kꞌa chuꞌlew ");
INSERT INTO acrNNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","yey na jinta kꞌo kakꞌulumaj, ma jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Ri Dios kebꞌutaq lo ru ángeles awukꞌ chaꞌ katkichajij. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Katkichap kꞌu rukꞌ ri kiqꞌabꞌ chaꞌ na kaꞌchiqa ta rawaqan che juna abꞌaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ri Jesús xukꞌul uwach: —Jewaꞌ tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios: Makꞌam upa ri Dios Qajawxel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Echiriꞌ ritzel winaq na xuriq ta chik suꞌanik kukꞌam upa ri Jesús, xel chiriꞌ y xroyeꞌej na kꞌu riꞌ jampalaꞌ kukꞌam tanchi upa. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ekꞌuchiriꞌ, ri Jesús xeꞌek tanchi Galilea y lik kꞌo ruchuqꞌabꞌ ri Ruxlabꞌixel ri Dios rukꞌ. Y xeꞌek utzijoxik puwi Rire pa taq tinamit y pa taq raldeas re Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Kakꞌutun kꞌu pa taq sinagogas y konoje ri ketaw re lik kakiyak uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Xopon kꞌu ri Jesús chupa ri tinamit Nazaret pa xkꞌiy wi. Y chupa ri qꞌij re uxlanibꞌal xok chupa ri sinagoga jelaꞌ pachaꞌ xex kuꞌan wi. Xtakꞌiꞌ kꞌu riꞌ chaꞌ karajilaj Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Y xyaꞌ che Rire ri jubꞌotaj wuj re ri qꞌalajisanel Isaías. Y echiriꞌ xujaq upa, xuriq pa kubꞌiꞌij wi: ");
INSERT INTO acrNNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","Ri Ruxlabꞌixel ri Dios Qajawxel kꞌo panuwiꞌ, ma inuchaꞌom loq chaꞌ koꞌlnuyaꞌa ri Utzilaj Tzij chike ri nibꞌaꞌibꞌ. Inutaqom loq chaꞌ kambꞌochiꞌij kikꞌuꞌx ri lik e kꞌo pa bꞌis, koꞌlnutzijoj kelebꞌal lo ke ri e kꞌo chi presoyil, kebꞌenutzuꞌnisaj ri e potzꞌ, kebꞌenuwesaj lo pa kꞌax ri lik kitijom kꞌaxkꞌolil, ");
INSERT INTO acrNNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","y koꞌlnutzijoj ruqꞌijol ri kꞌutubꞌal re ri rutzil ukꞌuꞌx ri Dios Qajawxel. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Ekꞌuchiriꞌ xukꞌis rajilaxik Rutzij Upixabꞌ ri Dios, xubꞌoto y xuya tanchi che ri aj chak re ri sinagoga, y xtzꞌuyiꞌ chikiwach ri e kꞌo chiriꞌ. Y konoje lik kakitzutzaꞌ pan uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Ekꞌuchiriꞌ, xubꞌiꞌij chike: «Waꞌ wa xinwajilaj che Ruchꞌaꞌtem ri Dios, waqꞌij xujeq bꞌi rilik chiwach alaq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Konoje ri xetaw re, kakiyak uqꞌij y lik kaminaq kanimaꞌ che ri chomilaj uchꞌaꞌtem, jewaꞌ kakibꞌiꞌij: «¿Na e ta nebꞌa ukꞌajol ri José waꞌ?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Y ri Jesús xubꞌiꞌij chike: «Laj ne kabꞌiꞌij alaq chwe: “Kunanel, chakunaj awibꞌ chawibꞌil awibꞌ. Chaꞌana kꞌu riꞌ chupa wa tinamit taq ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios jelaꞌ pachaꞌ ri qatom xaꞌan chilaꞌ Capernaúm” kacha alaq chwe.» ");
INSERT INTO acrNNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Y xubꞌiꞌij tanchi waꞌ: «Paqatzij wi kambꞌiꞌij che alaq: Na jinta juna qꞌalajisanel kakꞌul chi utz chupa rutinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Paqatzij wi kambꞌiꞌij che alaq: Rojertan lik e kꞌi rixoqibꞌ e malkaꞌnibꞌ e kꞌo chupa ri tinamit Israel chwach ri qꞌalajisanel Elías echiriꞌ na xuꞌan ta jabꞌ oxibꞌ junabꞌ rukꞌ nikꞌaj y xpe kꞌu ri jun unimal numik chupa ronoje wa tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Na rukꞌ ta kꞌu riꞌ, ri Dios na xutaq tubꞌi ri Elías rukꞌ junoq chike wa malkaꞌnibꞌ aj Israel; ma e xutaq bꞌi rukꞌ jun ixoq malkaꞌn aj Sarepta, jun tinamit kꞌo chunaqaj ri tinamit Sidón. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Yey ojertan lik e kꞌi ri kꞌo ri yabꞌil lepra chike echiriꞌ ri qꞌalajisanel Eliseo kꞌo chupa ri tinamit Israel. Na rukꞌ ta kꞌu riꞌ, na jinta junoq chike xkunutajik, ma xew xkunutaj ri Naamán, ri jun aj Siria» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Echiriꞌ xkita waꞌ, konoje ri e kꞌo chupa ri sinagoga lik xpe koyowal. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Xeyaktaj kꞌut y xkesaj lo ri Jesús pa ri tinamit y xkikꞌam bꞌi kꞌa chutzaꞌm jun nimalaj juyubꞌ chaꞌ kakikꞌaq bꞌi pa siwan. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Noꞌj ri Jesús xa xikꞌow chikixoꞌl y xeꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ri Jesús xopon chupa ri tinamit Capernaúm re Galilea y xujeq kakꞌutun chikiwach ri winaq chupa taq ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Y konoje lik kakam kanimaꞌ che, ma ruma rukꞌutunik kaqꞌalajinik lik kꞌo uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Kꞌo kꞌu chiriꞌ chupa ri sinagoga jun achi kꞌo puqꞌabꞌ jun itzelilaj uxlabꞌixel, yey waꞌ lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesús, lal aj Nazaret, ¿suꞌchak koꞌlmina ibꞌ la qukꞌ? ¿Lal kami petinaq riꞌ re koꞌlsacha la qawach? Riꞌin wetaꞌam lal chinoq, rilal lal ri Santo Kꞌajolaxel re ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Ekꞌu ri Jesús xuqꞌatej, jewaꞌ xubꞌiꞌij che: —¡Matchꞌaꞌt chik! Chatelubꞌi che laꞌchi —xchaꞌ. Ewi ri itzel uxlabꞌixel xukꞌaq rachi pulew chikixoꞌl ri winaq y xel bꞌi rukꞌ. Yey na jinta kꞌax xuꞌan kan che. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Y konoje ri winaq lik kakam kanimaꞌ che y jewaꞌ kakibꞌiꞌij chikiwach: «¿Saꞌ chi chꞌaꞌtemal waꞌ? Ma lik kꞌo puqꞌabꞌ kebꞌutaq bꞌi ri itzelilaj uxlabꞌixel. Kebꞌutaq bꞌi rukꞌ ruchuqꞌabꞌ y kebꞌel bꞌi» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Che ronoje taq ri luwar kꞌo lo xa naqaj, xeꞌek utzijoxik janipa taq ri kuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Ekꞌuchiriꞌ xel bꞌi ri Jesús chupa ri sinagoga, xopon chirocho ri Simón. Y ruchu-ujiꞌ ri Simón lik kaqopow pa aqꞌ. Xkitzꞌonoj kꞌu che ri Jesús chaꞌ kukunaj kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Ekꞌu ri Jesús xyuxiꞌ puwiꞌ, xuqꞌatej ri aqꞌ chirij y jelaꞌ xikꞌow ri aqꞌ chirij. Na jampatana xyaktaj rixoq y xujeqo kebꞌunimaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Chutzaqibꞌal qꞌij konoje ri kꞌo kiyewaꞌ ruma ukꞌiyal uwach yabꞌil xekikꞌam lo rukꞌ ri Jesús. Rire xuya ruqꞌabꞌ pakiwiꞌ chikijujunal y xebꞌukunaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Jenelaꞌ xebꞌel bꞌi itzelilaj uxlabꞌixel chike ukꞌiyal winaq. Echiriꞌ kebꞌel bꞌi, kesikꞌinik, jewaꞌ kakibꞌiꞌij: «¡Rilal lal Rukꞌajol ri Dios!» kechaꞌ. Noꞌj ri Jesús xebꞌuqꞌatej y na xuya ta luwar chike kechꞌawik, ma rike ketaꞌam chik Rire e Uchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Echiriꞌ xsaqirik, ri Jesús xel bꞌi chupa ri tinamit y xeꞌek chupa jun luwar katzꞌintzꞌotik. Y ri winaq xeꞌkitzukuj. Ekꞌuchiriꞌ xebꞌopon kꞌa pa la kꞌo wi, xkaj kakiqꞌatej chaꞌ na kebꞌuya ta kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Noꞌj Rire jewaꞌ xubꞌiꞌij chike: «Lik chirajawaxik kinꞌek pa taq tinamit re kantzijoj ri Utzilaj Tzij re rutaqanik ri Dios chike ri tikawex kꞌamajaꞌ kakita waꞌ, ma ruma waꞌ intaqom loq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Xeꞌek kꞌu che utzijoxik ri Utzilaj Tzij pa taq ri sinagogas re Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Kꞌo jun qꞌij ri Jesús kꞌo chuchiꞌ ri mar re Genesaret, yey ukꞌiyal winaq xebꞌoponik lik kakiminimaꞌ kibꞌ rukꞌ che utayik Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ri Jesús xril pan kaꞌibꞌ barco kꞌo chuchiꞌ ri yaꞌ; ekꞌu raj chapal kar ebꞌelinaq lo chupa che uchꞌajik taq ri ki atarraya. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Ekꞌuchiriꞌ, ri Jesús xok chupa jun chike ri kaꞌibꞌ barco. Y ri rajaw waꞌ e ri Simón. Xubꞌiꞌij kꞌu ri Jesús che ri Simón kumin bꞌi kꞌana ri barco chupa ri yaꞌ. Ekꞌu ri Jesús xtzꞌuyiꞌ chupa y xujeq kakꞌutun chike rukꞌiyal tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Echiriꞌ xukꞌis rukꞌutunik, jewaꞌ xubꞌiꞌij che ri Simón: —Woꞌora chakꞌama bꞌi ri barco chupa ri mar pa lik cho wi y chilikꞌij taq kꞌu ri atarraya chiriꞌ chaꞌ jelaꞌ kebꞌichap kar —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ri Simón xukꞌul uwach: —Lal tijonel, ronoje raqꞌabꞌ xojchakunik y na jinta kar xqachapo. Noꞌj we rilal kintaq la, kanꞌan riꞌ —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Echiriꞌ xkilikꞌij bꞌi ri atarraya, xekichap ukꞌiyal kar y ri atarraya xujeqo karaqarobꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Ekꞌuchiriꞌ, xkiꞌan pan kiqꞌabꞌ chike ri kachbꞌiꞌil e kꞌo chupa ri jun chik barco chaꞌ kepetik y kebꞌoꞌlkitoꞌoꞌ. Echiriꞌ xebꞌopon ri kachbꞌiꞌil, junam xkibꞌalij lo ri kebꞌ barco che kar y ruma laꞌ ya laj kemuqutajik. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ri Simón Pedro echiriꞌ xril waꞌ, xuxuk ribꞌ chwach ri Jesús y jewaꞌ xubꞌiꞌij che: —Chel ko la wukꞌ, Wajawal. Na taqal ta chwe kꞌo la wukꞌ ma in jun achi aj mak —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Xubꞌiꞌij waꞌ ri Pedro ma ruma rukꞌiyal kar xekichapo, lik xok xiꞌin ibꞌ rukꞌ junam kukꞌ konoje ri e kꞌo rukꞌ pa ri barco; ");
INSERT INTO acrNNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","jekꞌulaꞌ xok xiꞌin ibꞌ kukꞌ ri Jacobo y ri Juan; rike e ukꞌajol ri Zebedeo y e rachbꞌiꞌil ri Simón. Pero ri Jesús xubꞌiꞌij che ri Simón: —Maxiꞌij awibꞌ; chwi woꞌora katuꞌan at aj molol tikawex pachaꞌ aꞌanom lo chike ri kar —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ekꞌuchiriꞌ xkesaj lo ri barcos chupa ri mar, xkiya kan ronoje waꞌ y xeterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ri Jesús kꞌo chupa jun tinamit re Galilea echiriꞌ xopon jun achi rukꞌ, yey waꞌchi lik katajin uqꞌayik rucuerpo ruma ri yabꞌil lepra. Rire echiriꞌ xril uwach ri Jesús, xuxuk ribꞌ chwach, xuqasaj rupalaj chuꞌlew y xutzꞌonoj che: —Wajawal, we kaꞌaj ko la, josqꞌij la ri nucuerpo che wa yabꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Ekꞌuchiriꞌ, ri Jesús xuchap pana rukꞌ ruqꞌabꞌ y jekꞌuwaꞌ xubꞌiꞌij che: —Kuaj, chuꞌana bꞌa chom riꞌ racuerpo —xchaꞌ. Xew kꞌu xukꞌis ubꞌiꞌxikil waꞌ, na jampatana xsach ri yabꞌil kꞌo che rachi. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ekꞌu ri Jesús xutaq che na kutzijoj ta waꞌ che junoq. Xubꞌiꞌij kꞌu che: —Jat chwach raj chakunel pa Rocho Dios chaꞌ rire karilo na jinta chi lepra chawe. Y ruma rajosqꞌikil, chayaꞌa kꞌu chwach ri Dios ri qasaꞌn xtaqan kan ri Moisés che, chaꞌ kaqꞌalajin chikiwach ri tikawex at kunutajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Na rukꞌ ta kꞌu riꞌ, e ruma taq ri kuꞌan ri Jesús, rutzijoxik Rire katajin más retaꞌmaxik kuma ri winaq y lik kꞌu e kꞌi kakimol kibꞌ chaꞌ kakita ri kubꞌiꞌij y kekunutaj bꞌi che ri kiyabꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Noꞌj ri Jesús kel bꞌi, keꞌek pa taq luwar katzꞌintzꞌotik re kuꞌana orar. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","E xuꞌan waꞌ jun qꞌij echiriꞌ ri Jesús kakꞌutun chikiwach ri winaq. Etzꞌul kꞌu chiriꞌ ri fariseos y raj kꞌutunel re ri tzijpixabꞌ; rike e petinaq Jerusalem y pa taq ri tinamit y raldeas re Galilea y re Judea. Yey ruchuqꞌabꞌ ri Dios Qajawxel kꞌo rukꞌ ri Jesús chaꞌ kakunanik. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Y xekꞌun kꞌu lo jujun achijabꞌ kitelem lo jun achi sik chwa chꞌat. Xkaj kꞌu kakikoj bꞌi pa ja chaꞌ kakiya chwach ri Jesús, ");
INSERT INTO acrNNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","pero na xkiriq taj saꞌ rukojik bꞌi kuma rukꞌiyal winaq. E uwariꞌche xebꞌaqꞌan chwi ri ja, xkesaj julepaj che ruwiꞌ, xkiqasaj kꞌu lo ri sik e laꞌ kotzꞌol chwa ruchꞌat y xkiya chwach ri Jesús chikinikꞌajal ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Echiriꞌ ri Jesús xril ri kubꞌulibꞌal kikꞌuꞌx rukꞌ, jewaꞌ xubꞌiꞌij che ri sik: —Achi, ronoje ramak kuytajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Ekꞌuchiriꞌ, raj kꞌutunel re ri tzijpixabꞌ y ri fariseos xkijeq kakichꞌobꞌ raqan: «¿Saꞌ ruwach waꞌchi? Rire kamakun chirij ri Dios echiriꞌ kubꞌiꞌij kukuy mak. Ma ¿na xew ta nebꞌa ri Dios aj kuyul mak?» ");
INSERT INTO acrNNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ekꞌu ri Jesús xunaꞌbꞌej saꞌ ri kakichꞌobꞌo; ruma kꞌu riꞌ, xubꞌiꞌij chike: —¿Suꞌchak jelaꞌ katajin chikꞌuꞌx alaq? ");
INSERT INTO acrNNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","¿Saꞌ kꞌu ri na kꞌayew taj kambꞌiꞌij: “Ronoje ramak kuytajinaq chik” o “Chatyaktajoq y chatbꞌinoq”? ");
INSERT INTO acrNNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","E kuaj kꞌut ketaꞌmaj alaq waꞌ: Ralaxel Chikixoꞌl Tikawex yaꞌtal puqꞌabꞌ kukuy taq ri mak ke ri winaq che ruwachulew —xchaꞌ. Xubꞌiꞌij kꞌu riꞌ che ri sik: —Chatyaktajoq, chakꞌama bꞌi rachꞌat y jat chaꞌwocho —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Chupa kꞌu laꞌ la joqꞌotaj xyaktaj ri sik chikiwach. Xukꞌam kꞌu bꞌi ruchꞌat pa ri kotzꞌol wi y xeꞌek chirocho, e riꞌ lik kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Konoje kꞌu riꞌ lik xkam kanimaꞌ che y xkijeq kakiyak uqꞌij ri Dios. Y ruma ri xiꞌin ibꞌ kꞌo pa kanimaꞌ chwach ri Dios, xkibꞌiꞌij: «Waqꞌij qilom ruchuqꞌabꞌ ri Dios» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Chukꞌisbꞌal re waꞌ, xeꞌek ri Jesús y xril jun achi aj tzꞌonol puaq re tojonik, Leví rubꞌiꞌ, tzꞌul pa ri luwar pa kaꞌan wi ri tojonik che ri gobierno. Y ri Jesús xubꞌiꞌij che: —Chat-terej lo chwij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Ri Leví xyaktajik, xuya kan ronoje y xterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Ewi chirocho xuꞌan jun nimaqꞌij che ri Jesús. Y lik e kꞌi ri rach e aj tzꞌonol puaq re tojonik y ukꞌiyal winaq etzꞌul chwa ri mexa kukꞌ ri Jesús y rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ekꞌuchiriꞌ, raj kꞌutunel re ri tzijpixabꞌ kukꞌ ri fariseos xekichꞌaꞌtibꞌej rutijoꞌn ri Jesús, y jewaꞌ xkibꞌiꞌij chike: —¿Suꞌchak kixwaꞌ kukꞌ raj tzꞌonol puaq re tojonik y kukꞌ raj makibꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Ekꞌu ri Jesús xukꞌul uwach: —E janipa ri utz kiwach, na kajawax ta aj kunanel chike; ma waꞌ xew chike ri e yewaꞌibꞌ kajawax wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Jelaꞌ kꞌu riꞌ, riꞌin na in petinaq ta che kisikꞌixik ri jusukꞌ kibꞌinik kisilabꞌik, ma e in petinaq che kisikꞌixik raj makibꞌ chaꞌ kakijalkꞌatij ri kibꞌinik kisilabꞌik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Ekꞌuchiriꞌ, xkitzꞌonoj che ri Jesús: —¿Suꞌbꞌe rutijoꞌn ri Juan Aj Yaꞌl Bautismo kakiꞌan ayuno ukꞌiyal laj y lik kakiꞌan orar jelaꞌ pachaꞌ kaqaꞌan ri oj fariseos, noꞌj ri tijoꞌn rilal xew kewaꞌik y na kakiꞌan tane ayuno? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Y Rire xukꞌul uwach: —¿Utz nebꞌa kakiꞌan ayuno ri esikꞌim pa kꞌulanikil we kꞌa kꞌo rala kakꞌuliꞌik chikixoꞌl? Na utz taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Noꞌj kopon na ri qꞌij echiriꞌ kesax bꞌi rala chikixoꞌl; kꞌa ekꞌuchiriꞌ, kakiꞌan ayuno —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Tekꞌuchiriꞌ, xutzijoj jun kꞌambꞌal naꞌoj chike, jewaꞌ xubꞌiꞌij: «Na jinta junoq kuqꞌat chꞌaqap che ruqꞌuꞌ kꞌasaq chaꞌ kukꞌojoj ruqꞌuꞌ qꞌeꞌl rukꞌ. Ma we ta jelaꞌ kuꞌano, riꞌ na utz ta chi ruqꞌuꞌ kꞌasaq yey ne ri kꞌasaq na kukꞌulaj ta ribꞌ rukꞌ ruqꞌuꞌ qꞌeꞌl. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","»Jekꞌulaꞌ ri vino kꞌakꞌ ꞌanom na kaqꞌej ta chupa juna surun qꞌeꞌl. Ma we kaꞌaniꞌ waꞌ, ri vino kꞌakꞌ echiriꞌ kanajtir uqꞌij, kuraqij ri surun, katix kꞌu riꞌ ri vino y ri surun na jinta chi uchak. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ruma kꞌu laꞌ, ri vino kꞌakꞌ ꞌanom chirajawaxik wi kaqꞌej chupa juna surun kꞌasaq chaꞌ ukabꞌichal waꞌ kakowinik. ");
INSERT INTO acrNNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Yey junoq ukꞌamom ribꞌ che kutij ri vino naj chi uqꞌij, na karaj taj kutij ri kꞌakꞌ vino, ma kubꞌiꞌij: “Ri vino naj chi uqꞌij e más utz chwa ri kꞌakꞌ vino”» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","E xuꞌan waꞌ chupa jun qꞌij re uxlanibꞌal: Ri Jesús kukꞌ rutijoꞌn katajin kikꞌowik pa taq tikoꞌn re trigo, yey rutijoꞌn kakichꞌupilaꞌ bꞌi ri trigo, kakiqil rukꞌ ri kiqꞌabꞌ y kakitijo. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ekꞌuchiriꞌ, jujun chike ri fariseos xkitzꞌonoj chike: —¿Suꞌbꞌe kiꞌan riꞌix ri na taqal taj kaꞌaniꞌ chupa ri qꞌij re uxlanibꞌal? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ekꞌu ri Jesús xukꞌul uwach: —¿Na ajilam ta nebꞌa alaq ri xuꞌan ri David echiriꞌ rire kukꞌ ri rachbꞌiꞌil xenumik? ");
INSERT INTO acrNNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xok kꞌu chupa ri Rocho Dios y xukꞌam ri pam yaꞌtal chi puqꞌabꞌ ri Dios. Xutijo y xujach chike ri rachbꞌiꞌil; yey waꞌ na taqal ta chike kakitijo, ma xew taqal chike raj chakunel pa ri Rocho Dios kakitijo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Y xukꞌisbꞌej kukꞌ, jewaꞌ xubꞌiꞌij: —Ralaxel Chikixoꞌl Tikawex e ne rajaw ri qꞌij re uxlanibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","E xuꞌan waꞌ chupa jun chik qꞌij re uxlanibꞌal: Ri Jesús xok chupa jun sinagoga y xujeqo kakꞌutunik. Chiriꞌ kꞌu riꞌ kꞌo jun achi chaqijinaq ruqꞌabꞌ uwikiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Yey raj kꞌutunel re ri tzijpixabꞌ y ri fariseos lik kikꞌakꞌalem we ri Jesús kukunaj waꞌchi chupa wa qꞌij re uxlanibꞌal, chaꞌ jelaꞌ kakikoj umak. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Noꞌj ri Jesús retaꞌam saꞌ ri kakichꞌobꞌo y xubꞌiꞌij kꞌu che rachi chaqijinaq ruqꞌabꞌ: —Chatyaktajoq y chatkꞌola chiqawach qonoje —xchaꞌ. Ewi rachi xyaktajik y xtakꞌiꞌ chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike: —Kanꞌan jun tzꞌonobꞌal che alaq. ¿Saꞌ ri lik usukꞌ kaꞌaniꞌ chupa ri qꞌij re uxlanibꞌal: E kaꞌaniꞌ ri utz, o e ri na utz taj? ¿Utz kakolobꞌex rukꞌaslem junoq o kayaꞌ luwar che kakamik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ekꞌuchiriꞌ, ri Jesús xutzuꞌ kiwach konoje ri e kꞌo chiriꞌ, y xubꞌiꞌij che rachi: —Chasukꞌupij raqꞌabꞌ —xchaꞌ. Rachi e xuꞌano, y ruqꞌabꞌ xutzirik. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ekꞌu ri fariseos y ri aj kꞌutunel re ri tzijpixabꞌ lik xpe koyowal y xkijeq kakichꞌaꞌtibꞌej chikiwach saꞌ ri kakiꞌan che ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Kꞌo jun qꞌij ri Jesús xeꞌek chwa juyubꞌ chaꞌ kuꞌana orar. Xikꞌow kꞌu jun aqꞌabꞌ kachꞌaꞌt rukꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Echiriꞌ xsaqirik, xebꞌusikꞌij rutijoꞌn y chike waꞌ xebꞌuchaꞌ kabꞌlajuj, y xubꞌiꞌij rike e “taqoꞌn”. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","E kibꞌiꞌ waꞌ: Simón ri xkoj Pedro che y ruchaqꞌ Andrés, Jacobo y Juan, Felipe, Bartolomé, ");
INSERT INTO acrNNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Jacobo rukꞌajol ri Alfeo, Simón ri kabꞌiꞌx che “ri Zelote”, ");
INSERT INTO acrNNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas rukꞌajol ri Jacobo, y Judas aj Iscariot, ri xkꞌayin re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Tekꞌuchiriꞌ, ri Jesús kukꞌ rutijoꞌn xeqaj lo chwa ri juyubꞌ y xekꞌojiꞌ pa jun taqꞌaj kukꞌ ukꞌiyal winaq re ronoje taq ri luwar re Judea, re Jerusalem yey re Tiro y re Sidón, kebꞌ tinamit e kꞌo chuchiꞌ ri mar. Rike e petinaq chaꞌ kakita ri kꞌutunik re ri Jesús y chaꞌ kekunutaj bꞌi che ri kiyabꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yey janipa ri kitijom kꞌax kuma ri itzelilaj uxlabꞌixel, kekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Ruma kꞌu ri kiyabꞌil, konoje ri winaq kakaj kakichap ri Jesús, ma Rire rukꞌ ruchuqꞌabꞌ kebꞌukunaj konoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ekꞌuchiriꞌ, ri Jesús xutzuꞌ kiwach rutijoꞌn y xubꞌiꞌij chike: «Nim iqꞌij iwalaxik tobꞌ ix nibꞌaꞌ, ma ix kukꞌil ri e kꞌo puqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Nim iqꞌij iwalaxik tobꞌ woꞌora kitij numik, ma kopon na ri qꞌij echiriꞌ kixkubꞌiꞌ chi utz ma ri Dios kuya ronoje ri kajawax chiwe. Nim iqꞌij iwalaxik tobꞌ woꞌora kixoqꞌik, ma kopon na ri qꞌij echiriꞌ kanoj ri iwanimaꞌ che kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nim iqꞌij iwalaxik echiriꞌ lik tzel kixil kuma ri winaq, kixkesaj bꞌi chikixoꞌl, kakikꞌaq bꞌi uqꞌij ribꞌiꞌ, kakibꞌiꞌij chiwe lik itzel iwachlibꞌal ruma ix utijoꞌn Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","»Echiriꞌ kaꞌan waꞌ chiwe, lik chixkiꞌkotoq y chixbꞌixonoq, ma lik nim ri rajil ukꞌaxel kikꞌul chilaꞌ chikaj. Makam kꞌu iwanimaꞌ che echiriꞌ kixyaꞌ pa kꞌax; ma e taq ri keꞌanaw waꞌ chiwe, e kakiꞌano pachaꞌ ri kiꞌanom lo ri katiꞌ-kimam ojertan chike ri e qꞌalajisanelabꞌ re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Toqꞌoꞌ kꞌu wach ralaq alaq bꞌeyomabꞌ, ma kꞌulum chi alaq ri kuya kiꞌkotemal che alaq, noꞌj moyeꞌej chi kꞌu alaq we kꞌa kakꞌul alaq waꞌ chiqawach apanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toqꞌoꞌ wach alaq ri lik kꞌo katij alaq woꞌora, ma chiqawach apanoq katij alaq numik. Toqꞌoꞌ wach alaq ri lik kakiꞌkot alaq woꞌora, ma chiqawach apanoq kakꞌojiꞌ alaq pa bꞌis. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Toqꞌoꞌ wach alaq echiriꞌ lik kayak qꞌij alaq, ma ojertan jelaꞌ xkiꞌan ri chuꞌqaw alaq, e xkiyak kiqꞌij ri qꞌalajisanelabꞌ xa e sokosoꞌnel. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","»Woꞌora kambꞌiꞌij chiwe riꞌix ri kixtaw we: Kꞌax chebꞌinaꞌa ri e aj retzelal kꞌuꞌx chiwij. Chiꞌana ri utz chike ri tzel kebꞌilow iwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chitzꞌonoj ri rutzil ukꞌuꞌx ri Dios pakiwi ri kakitzꞌonoj ri na utz taj piwi riꞌix. Chiꞌana kꞌu orar pakiwi ri tzel kechꞌaꞌt chiwij. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Y we kꞌo junoq kupachꞌ qꞌabꞌ xeꞌ aweꞌ, chayaꞌa luwar che kupachꞌ ri jun chik xe aweꞌ. Y we kꞌo junoq kumaj raqꞌuꞌ re pisbꞌal awij, chayaꞌa ne luwar che kukꞌam bꞌi rakoton. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Chatsipan che ri nibꞌaꞌ we kutzꞌonoj toꞌbꞌal chawe. Y we kꞌo junoq kumaj rubꞌitaq awe, matzꞌonoj tanchi che. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Ekꞌu riꞌix chiꞌana chike ri tikawex jelaꞌ pachaꞌ ri kiwaj kakiꞌan rike chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","»Ma we xew kꞌax kebꞌinaꞌ ri kꞌax kenaꞌw iwe, michꞌobꞌ raqan taqal chiwe kayak iqꞌij ruma waꞌ; ma jenelaꞌ kakiꞌan taq ri winaq aj makibꞌ; rike xew kꞌax kekinaꞌ ri kꞌax kenaꞌw ke. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Y we xew kiꞌan ri utz chike ri kakiꞌan ri utz chiwe, michꞌobꞌ raqan we taqal chiwe kayak iqꞌij ruma waꞌ; ma jenelaꞌ kakiꞌan taq ri winaq aj makibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Yey we xew kiya chaqꞌiꞌm chike ri iwetaꞌam chik kikꞌul na ri chiqꞌimbꞌal re chike, michꞌobꞌ raqan we taqal chiwe kayak iqꞌij ruma waꞌ; ma jenelaꞌ kakiꞌan taq ri winaq aj makibꞌ; xew kechiqꞌiman chike ri kakiya chiqꞌimbꞌal re chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","»Noꞌj riꞌix, kꞌax chebꞌinaꞌa ri tzel kebꞌilow iwe y chiꞌana ri utz chike. Chiyaꞌa chaqꞌiꞌm na jinta kꞌo kiwoyꞌej chwach. We kiꞌan waꞌ, lik nim ri sipanik kikꞌul chilaꞌ chikaj; yey ekꞌuchiriꞌ, paqatzij wi kixuꞌan ix ralkꞌoꞌal ri Jun kataqan chwi ronoje, ma jelaꞌ kuꞌan Rire, kukꞌut ri rutzil ukꞌuꞌx chike ri itzel kikꞌuꞌx, ri na ketioxin ta chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Kꞌola kꞌu riꞌ ri kꞌaxnaꞌbꞌal kꞌuꞌxaj iwukꞌ jelaꞌ pachaꞌ ri Qaqaw Dios lik kꞌo kꞌaxnaꞌbꞌal ukꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","»Miꞌan ri xa piwe riꞌix kixuꞌan aj qꞌatal tzij pakiwi jujun chik, y jelaꞌ na kaqꞌat ta kꞌu tzij piwi riꞌix. Miꞌan ri kꞌax kixchꞌaw chikij jujun chik, y jelaꞌ na kaꞌan ta waꞌ chiwe riꞌix. We kꞌo junoq kamakun chiwij, chikuyu umak y jelaꞌ kakuytaj imak riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Chixsipanoq y jelaꞌ ri Dios kasipan chiwe rukꞌ jun pajbꞌal lik nim, lik tzanal upa y kapulputik; ma rukꞌ ri pajbꞌal kixpajan wi riꞌix, rukꞌ tanchi wa pajbꞌal kaꞌan pajanik chiwe» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Y xubꞌiꞌij jun kꞌambꞌal naꞌoj chike: «¿Utz nebꞌa juna potzꞌ kukꞌam uwach jun chik potzꞌ? ¿Na kebꞌeꞌtzaq ta nawi kikabꞌichal pa siwan? ");
INSERT INTO acrNNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Juna tijoꞌn na retaꞌam ta más chwa ri retaꞌam rutijonel. Yey we lik kꞌi ri kumajo, riꞌ e kuꞌana pachaꞌ rutijonel. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","»¿Suꞌchak e lik katzutzaꞌ rukꞌaj cheꞌ kꞌo chupa ruwach rawatz-achaqꞌ yey e na katok ta il che resaxik ri cheꞌ qꞌebꞌel chupa rawach riꞌat? ");
INSERT INTO acrNNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y we na katok ta kꞌu il che ri cheꞌ qꞌebꞌel chupa rawach riꞌat, ¿utz nawi kabꞌiꞌij che rawatz-achaqꞌ: “Watz-nuchaqꞌ, chayaꞌa luwar chwe kanwesaj la jun ukꞌaj cheꞌ kꞌo chupa rawach”? ¡Na utz taj! ¡Xa kebꞌ apalaj! Nabꞌe na chawesaj lo la cheꞌ qꞌebꞌel chupa rawach riꞌat, y jelaꞌ kat-tzuꞌn chi utz chaꞌ katoꞌ rawatz-achaqꞌ che resaxik lo rukꞌaj cheꞌ kꞌo chupa ruwach rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","»Jinta juna chomilaj cheꞌ kuya ujiqꞌobꞌalil na chom taj, yey juna cheꞌ na chom taj, na kuya ta ujiqꞌobꞌalil chom. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ma ronoje cheꞌ etaꞌmatal uwach ruma rujiqꞌobꞌalil. Na kamol ta higos che taq ri xulukej y na kamol ta uvas che taq ri xukuyeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","»Jekꞌulaꞌ e junoq utz ukꞌuꞌx, echiriꞌ kachꞌaꞌtik, e kel lo ri utz ukꞌolom chupa ri ranimaꞌ. Yey e junoq itzel ukꞌuꞌx, echiriꞌ kachꞌaꞌtik, e kel lo ri na utz taj ukꞌolom chupa ri ranimaꞌ. Ma rukꞌ ruchꞌaꞌtem ri tikawex, kaqꞌalajinik saꞌ ri kꞌo chupa ri ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","»¿Suꞌchak kibꞌiꞌij chwe “Qajawal, Qajawal”, yey na kiꞌan ta ri kambꞌiꞌij chiwe? ");
INSERT INTO acrNNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Kambꞌiꞌij kꞌu chiwe china rukꞌ kajunimax wi ri jun kape wukꞌ, kuta ri nutzij y kuꞌan janipa ri kambꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","»Waꞌ e kanjunimaj rukꞌ jun achi xuyak jun rocho. Xukꞌot ri jul y lik naj xuqasaj y xutzꞌaq kꞌu lo ruparaqan ri ja chwi abꞌaj. Y echiriꞌ xpe lo jabꞌ, lik xnimar ri nimayaꞌ y rutzaꞌm ri yaꞌ lik xuroj ribꞌ che ri ja; yey ri ja xuchꞌij uchuqꞌabꞌ, ma chwi abꞌaj tzꞌaqom lo wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Noꞌj ri jun xuta ri nutzij y na xuꞌan ta janipa ri kambꞌiꞌij, e kanjunimaj rukꞌ jun achi xuꞌan ri rocho pa sanyebꞌ y na xukoj ta lo ukowil ruparaqan ri ja. Y echiriꞌ lik xnimar ri nimayaꞌ, rutzaꞌm yaꞌ lik xuroj ribꞌ che ri ja. Ekꞌu riꞌ ri ja xwuluwubꞌ bꞌi y xsach uwach» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Ri Jesús echiriꞌ xukꞌis kakꞌutun chikiwach ri tikawex, xeꞌek Capernaúm. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chiriꞌ jeqel jun capitán aj Roma y kꞌo jun raj chak lik yewaꞌ yey kajekꞌowik. Ekꞌu ri capitán lik kꞌax kunaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ekꞌuchiriꞌ xuto saꞌ taq ri kabꞌiꞌx puwi ri Jesús, xebꞌutaq bꞌi jujun nimaq winaq e aj wach ke raj judiꞌabꞌ chaꞌ kebꞌeꞌelaj che kapetik y koluꞌkunaj ri raj chak. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ekꞌuchiriꞌ ri nimaq winaq xebꞌopon rukꞌ ri Jesús, lik xebꞌelaj che, jewaꞌ xkibꞌiꞌij: —Qajawal, wa jun capitán lik taqal che katoꞌ la, ");
INSERT INTO acrNNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ma lik kꞌax kunaꞌ ri qatinamit y xojutoꞌ ne che uyakik ri qasinagoga —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Ekꞌu ri Jesús xeꞌek kukꞌ. Ekꞌuchiriꞌ xebꞌopon chunaqaj ri ja, ri capitán xebꞌutaq lo jujun ramigos rukꞌ ri Jesús chaꞌ jewaꞌ kakibꞌiꞌij che: «Wajawal, makosisaj ibꞌ la che kape la, ma na taqal ta chwe kok la chiwocho; ");
INSERT INTO acrNNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ruma laꞌ xinchꞌobꞌo na taqal tane chwe kinopon chiwach la. Xew bꞌiꞌij la: “Chatkunutajoq”, y rukꞌ ri chꞌaꞌtem la, kakunutaj ri waj chak. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma e pachaꞌ riꞌin, in kꞌo puqꞌabꞌ jun taqanel y rire ebꞌuyaꞌom ukꞌiyal soldados panuqꞌabꞌ. We kambꞌiꞌij kꞌu che junoq: “Jat”, keꞌek; o kambꞌiꞌij che junoq chik: “Chatpetoq”, kapetik. Yey we kambꞌiꞌij che juna waj chak: “E chaꞌana waꞌ”, kuꞌano.» ");
INSERT INTO acrNNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Echiriꞌ ri Jesús xuta ri xubꞌiꞌij lo ri capitán, lik xkam ranimaꞌ che. Xutzuꞌ kꞌu pan kiwach ri winaq eteran chirij y jewaꞌ xubꞌiꞌij chike: —Kambꞌiꞌij chiwe, na nuriqom tane chikixoꞌl raj Israel junoq lik kꞌo unimal kubꞌulibꞌal ukꞌuꞌx pachaꞌ wa jun achi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ekꞌuchiriꞌ ri etaqom bꞌi xetzelej chirocho ri capitán, xeꞌkiriqa ri raj chak kunutajinaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ikꞌowinaq chi waꞌ, ri Jesús xeꞌek pa jun tinamit Naín rubꞌiꞌ. E kꞌi chike rutijoꞌn y ukꞌiyal winaq e rachbꞌiꞌil bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Echiriꞌ xebꞌopon chunaqaj ri tinamit, xril jun animaꞌ telem, e riꞌ keꞌmuqoq. Yey waꞌ e jun ala ralkꞌoꞌal jun ixoq malkaꞌn y xew ne ko ralabꞌ riꞌ. Ukꞌiyal kꞌu winaq re ri tinamit kachbꞌilam rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Echiriꞌ ri Qanimajawal xril rixoq, lik xjuchꞌ kaꞌn pa ranimaꞌ y xubꞌiꞌij che: —Moqꞌ chi la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Ekꞌuchiriꞌ, ri Jesús xqibꞌ kukꞌ y xuchap ri chꞌat pa telem wi ri animaꞌ. Ekꞌu ri e teleyom re xetakꞌiꞌik. Y ri Jesús xubꞌiꞌij che ri kaminaq: —Ala, kambꞌiꞌij chawe: ¡Chatyaktajoq! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Ekꞌuchiriꞌ, rala kaminaq chik xyaktajik y xujeqo kachꞌaꞌtik. Y ri Jesús xuya bꞌi puqꞌabꞌ ruchu. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Echiriꞌ xkil waꞌ ri winaq, konoje xkam kanimaꞌ che y xkijeqo kakiyak uqꞌij ri Dios, kakibꞌiꞌij: —Jun nimalaj qꞌalajisanel xwinaqir chiqaxoꞌl. Ri Dios kꞌuninaq chaꞌ kojutoꞌ ri oj utinamit —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Konoje kꞌu ri e kꞌo Judea y ri e kꞌo lo chunaqaj xketaꞌmaj ri xuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ekꞌu ri Juan xretaꞌmaj ronoje waꞌ, ma rutijoꞌn xkitzijoj che. Ekꞌuchiriꞌ, xebꞌusikꞌij kaꞌibꞌ chike ");
INSERT INTO acrNNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","y jewaꞌ xubꞌiꞌij: —Jix rukꞌ ri Jesús y chitzꞌonoj che we Rire e Ruchaꞌoꞌn lo ri Dios, ri Jun bꞌiꞌtalik kakꞌunik, o kaqoyꞌej chi junoq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Ekꞌuchiriꞌ, rutijoꞌn ri Juan xebꞌek rukꞌ ri Jesús y jewaꞌ xkibꞌiꞌij che: —Ri Juan Aj Yaꞌl Bautismo ojutaqom loq chaꞌ kaqatzꞌonoj cheꞌla we lal Ruchaꞌoꞌn lo ri Dios, ri Jun bꞌiꞌtalik kakꞌunik o kaqoyꞌej chi junoq chik —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Chupa kꞌu laꞌ la ora ri Jesús xujeq kebꞌukunaj ukꞌiyal winaq che taq yabꞌil y che taq kꞌaxkꞌolil, kebꞌukolobꞌej ri e kꞌo pakiqꞌabꞌ itzel uxlabꞌixel y kebꞌutzuꞌnisaj ukꞌiyal potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Tekꞌuchiriꞌ, ri Jesús xukꞌul uwach ri tzꞌonobꞌal ke rutijoꞌn ri Juan: —Jix y chitzijoj che ri Juan ronoje ri xiwilo y ri xito. Ma ri e potzꞌ ketzuꞌnik, ri e sik kebꞌinik, ri kꞌo yabꞌil lepra chike kekunutajik, ri e tꞌoꞌk ketanik, ri ekaminaq kekꞌastajik y chike ri nibꞌaꞌibꞌ katzijox ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Nim uqꞌij ralaxik kꞌu riꞌ ri na kasach ta ukꞌuꞌx wukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Echiriꞌ xebꞌek ri etaqom lo ruma ri Juan, ri Jesús xujeq kachꞌaꞌt puwi ri Juan chike ri winaq, jewaꞌ xubꞌiꞌij: «¿Saꞌ ri xeꞌila alaq pa ri luwar katzꞌintzꞌotik? ¿Xeꞌila nebꞌa alaq jun achi na jinta ukowil xa pachaꞌ tani kajabajoꞌx ruma ri tew? ");
INSERT INTO acrNNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Saꞌ ri xeꞌila alaq? ¿Xeꞌila nebꞌa alaq jun achi uwiqom ribꞌ rukꞌ chomilaj kꞌul? Na e ta riꞌ, ma etaꞌam alaq ri lik kewiqiqik y kꞌo kukꞌ janipa ri kakirayij, riꞌ pa kocho e aj wach ejeqel wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Kantzꞌonoj kꞌu riꞌ: ¿Saꞌ ri xeꞌila alaq? ¿Xeꞌila alaq jun qꞌalajisanel? Areꞌ, yey paqatzij wi kambꞌiꞌij che alaq: E jun más kꞌo uwach chikiwa ri jujun chik qꞌalajisanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Ma jewaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios puwi ri Juan: Riꞌin kannabꞌesaj bꞌi ri waj chak chawach Riꞌat chaꞌ kuyijbꞌaꞌ ri bꞌe chwach pan rawoponibꞌal kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Kambꞌiꞌij kꞌu che alaq: Chike ri tikawex ebꞌalaxinaq wara che ruwachulew, na jinta juna qꞌalajisanel más kꞌo uwach chwa ri Juan Aj Yaꞌl Bautismo. Pero chwi kꞌu riꞌ waꞌ wa keꞌek, china ri kok chupa rutaqanik ri Dios, tobꞌ na jinta uwach, más nim uqꞌij ralaxik chwa ri Juan» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Echiriꞌ ri winaq y ri aj tzꞌonol puaq re tojonik xkita waꞌ, xketaꞌmaj paqatzij wi ri Dios lik jusukꞌ. E uwariꞌche xkitzelej kitzij y xkikꞌul ri bautismo kuya ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Noꞌj ri fariseos y raj kꞌutunel re ri tzijpixabꞌ xkikꞌaq bꞌi uqꞌij ri rajawal ukꞌuꞌx ri Dios xkꞌut chike, ma na xkitzelej ta kitzij y na xkikꞌul ta ri bautismo kuya ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Je tanchi waꞌ xubꞌiꞌij ri Jesús: «¿China kꞌu rukꞌ kanjunimaj wi kiwach ri winaq re waqꞌij ora? ¿Saꞌ rukꞌ e junam wi? ");
INSERT INTO acrNNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","E kanjunimaj kiwach kukꞌ ri kꞌoꞌmabꞌ etzꞌul pa kꞌayibꞌal kesikꞌin chikiwach, kakibꞌiꞌij: “Echiriꞌ riꞌoj xqachꞌawisaj suꞌ chiwe, riꞌix na xiwaj taj kix-xajawik; yey echiriꞌ xqatunaj bꞌix bꞌisobꞌal uwach chiwe, na xiwaj taj kixjuyuyik” —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jekꞌulaꞌ ralaq, ma echiriꞌ xkꞌun ri Juan Aj Yaꞌl Bautismo, rire lik kuꞌan ayuno y na kutij tane vino. Yey ralaq kabꞌiꞌij alaq: “Waꞌ waꞌchi kꞌo puqꞌabꞌ jun itzel uxlabꞌixel” kacha alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Xkꞌun kꞌu lo Ralaxel Chikixoꞌl Tikawex. Rire kutij ronoje ri kayaꞌ chwach, yey ralaq kabꞌiꞌij alaq: “Waꞌ wa jun achi lik japjatel y qꞌabꞌaꞌrel, kachbꞌiꞌil raj tzꞌonol puaq re tojonik y raj makibꞌ” kacha alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Pero kaqꞌalajin na kꞌut china taq ri lik kꞌo runaꞌoj ri Dios kukꞌ ruma ri kiꞌanom» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tekꞌuchiriꞌ, xsikꞌix ri Jesús ruma jun fariseo Simón rubꞌiꞌ chaꞌ keꞌwoꞌq rukꞌ. Ekꞌu ri Jesús xeꞌek chirocho ri fariseo y xtzꞌuyiꞌ chwa ri mexa. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Kꞌo kꞌu jun ixoq aj pa la tinamit na utz ta rubꞌinik usilabꞌik. Echiriꞌ rire xretaꞌmaj kawaꞌ ri Jesús chirocho ri fariseo, xukꞌam bꞌi jun kꞌolibꞌal ꞌanatal rukꞌ alabastro nojinaq che kunabꞌal lik kiꞌ ruxlabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Koqꞌ kꞌu riꞌ xopon xeꞌraqan ri Jesús. Yey rukꞌ ruwaꞌal uwach xujeq kuchꞌaqabꞌaꞌ ri raqan ri Jesús, y rukꞌ kꞌu ruwiꞌ kuchaqisaj; kutzꞌubꞌ ri raqan y kusoqꞌ ri kunabꞌal lik kiꞌ ruxlabꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Echiriꞌ xril waꞌ ri fariseo, ri sikꞌiyom re ri Jesús, xuchꞌobꞌo: «We ta waꞌchi paqatzij wi qꞌalajisanel, kunaꞌbꞌej riꞌ saꞌ rubꞌinik usilabꞌik wiꞌxoq kachapaw re, ma waꞌ wiꞌxoq lik aj mak.» ");
INSERT INTO acrNNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ekꞌuchiriꞌ, ri Jesús jewaꞌ xubꞌiꞌij che: —Simón, kꞌo kuaj kambꞌiꞌij cheꞌla —xchaꞌ. Ri fariseo xubꞌiꞌij che: —Bꞌiꞌij la, Wajawal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Xubꞌiꞌij kꞌu ri Jesús: —Ekꞌo kaꞌibꞌ achijabꞌ kꞌo kikꞌas rukꞌ jun achi kuya puaq pa chaqꞌiꞌm. Jun chike, ukꞌas woꞌobꞌ ciento denarios y ri jun chik, ukꞌas cincuenta denarios. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Kikabꞌichal na kakiriq ta chik saꞌ rutojik. Ekꞌu rachi aj yaꞌl chaqꞌiꞌm xukuy kimak kikabꞌichal che ri kikꞌas. Woꞌora, Simón, bꞌiꞌij la chwe ¿china chike wa kaꞌibꞌ achijabꞌ más katioxin chwach rachi aj yaꞌl chaqꞌiꞌm? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Ri Simón xukꞌul uwach: —Chinuwach riꞌin, e ri jun achi ri xkuytaj umak che ri kꞌas más kꞌi —xchaꞌ. Y ri Jesús xubꞌiꞌij che: —Ri xbꞌiꞌij la, lik areꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ekꞌuchiriꞌ, ri Jesús xutzuꞌ uwach rixoq y xubꞌiꞌij che ri Simón: —¿Kil la wa jun ixoq? Echiriꞌ xinok lo riꞌin chi ocho la, rilal na xya ta la nuyaꞌ re chꞌajbꞌal ri waqan. Noꞌj wa jun ixoq xuchꞌaqabꞌaꞌ ri waqan rukꞌ ruwaꞌal uwach y xuchaqisaj rukꞌ ruwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yey rilal na xtzꞌubꞌ tane la nuchiꞌ; noꞌj rire chwi echiriꞌ xinok loq, na roqꞌotam ta kutzꞌubꞌ ri waqan. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Rilal na xsoqꞌ tane la aceite chwi nujolom; noꞌj rire xusoqꞌ kunabꞌal lik kiꞌ ruxlabꞌ che ri waqan. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kambꞌiꞌij kꞌu cheꞌla: Rire xuꞌan waꞌ ma nukuyum chi rukꞌiyal umak; e uwariꞌche lik kukꞌut ri rutzil ukꞌuꞌx chwe. Noꞌj e junoq na lik ta kꞌi rumak kuytajinaq, riꞌ xa jubꞌiqꞌ ri rutzil ukꞌuꞌx kukꞌutu —xcha che ri Simón. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Ekꞌuchiriꞌ, xubꞌiꞌij che rixoq: —Ixoq, ronoje ramak kuytajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ekꞌu ri etzꞌul rukꞌ ri Jesús chwa ri mexa xkijeqo kakichꞌaꞌtibꞌej chikiwach, jewaꞌ kakibꞌiꞌij: «¿Saꞌ nawi ruwach wa jun achi kukuy mak?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Pero ri Jesús xubꞌiꞌij che rixoq: —Ruma ri kubꞌulibꞌal akꞌuꞌx, xatkolobꞌetajik; jat kꞌu chi utzil chomal —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ikꞌowinaq chi kꞌu waꞌ, ri Jesús kabꞌin pa taq ronoje tinamit y aldeas kutzijoj ri Utzilaj Tzij re rutaqanik ri Dios. E rachbꞌiꞌil kꞌu ri kabꞌlajuj utijoꞌn, ");
INSERT INTO acrNNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","kukꞌ jujun ixoqibꞌ ri ebꞌeresam pakiqꞌabꞌ itzel uxlabꞌixel y ebꞌukunam che ukꞌiyal yabꞌil. Chikixoꞌl e kꞌo ri María ri ebꞌelinaq wuqubꞌ itzel uxlabꞌixel che, ");
INSERT INTO acrNNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ri Juana rixoqil rachi Chuza ri aj wach re rubꞌitaq re ri Rey Herodes, ri Susana kukꞌ jujun chik ixoqibꞌ kakinimaj ri Jesús rukꞌ taq rubꞌitaq ke. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Kꞌo jun qꞌij lik e kꞌi ri winaq xebꞌel lo pa taq tinamit y xkimol kibꞌ rukꞌ ri Jesús. Ekꞌuchiriꞌ, ri Jesús xujeq kakꞌutun chikiwach rukꞌ taq kꞌambꞌal naꞌoj, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","«Julaj jun awanel xel bꞌi che rawaxik ri rijaꞌ. Ekꞌuchiriꞌ katajin che ujopopexik rijaꞌ, kꞌo xtzaq kan chuchiꞌ ri bꞌe. Y waꞌ xyiqꞌ uwiꞌ kuma ri kebꞌikꞌowik y xtij bꞌi kuma taq ri tzꞌikin. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","»Kꞌo ijaꞌ xtzaq kan pa taq abꞌaj; yey echiriꞌ xel loq, xchaqijik ma na kamuꞌmut ta ruxeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","»Kꞌo ijaꞌ xtzaq kan pa taq kꞌiix. Ekꞌu riꞌ waꞌ xkꞌiy junam rukꞌ ri kꞌiix, pero xjiqꞌ kan chuxeꞌ ri kꞌiix. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","»Noꞌj kꞌo xtzaq kan pa chomilaj ulew. Ekꞌu riꞌ waꞌ, echiriꞌ xkꞌiyik, lik xuꞌan reqaꞌn; chujujunal raqan xel jun ciento che» xchaꞌ. Tekꞌuchiriꞌ, lik ko xchꞌaw ri Jesús, jewaꞌ xubꞌiꞌij: «China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Tekꞌuchiriꞌ, rutijoꞌn xkitzꞌonoj che: —¿Saꞌ keꞌelawi wa kꞌambꞌal naꞌoj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ri Jesús xubꞌiꞌij chike: «Chiwe riꞌix yaꞌtalik kaqꞌalajisax runaꞌoj ri Dios chwi rutaqanik. Noꞌj chike ri winaq, kankꞌut xew rukꞌ kꞌambꞌal naꞌoj. Ma tobꞌ rike ketzuꞌnik, e junam rukꞌ na ketzuꞌn taj; tobꞌ ketanik, e junam rukꞌ na ketan taj y e riꞌ na jinta kꞌo kakimaj usukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","»Woꞌora kanqꞌalajisaj chiwe saꞌ keꞌelawi wa kꞌambꞌal naꞌoj. Rijaꞌ e Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","»Ri xtzaq kan chuchiꞌ ri bꞌe, e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios, pero kakꞌun lo ritzel winaq y karesaj waꞌ pa kanimaꞌ chaꞌ na kakikoj taj y na kekolobꞌetaj ta kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","»Ri xtzaq kan pa taq abꞌaj, e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios y kakikꞌul rukꞌ kiꞌkotemal; noꞌj na e tikil ta chi utz. Kakikoj kꞌu Ruchꞌaꞌtem xa kebꞌ oxibꞌ qꞌij; yey echiriꞌ kakꞌun lo kꞌambꞌal kipa, kakesaj bꞌi kibꞌ chirij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","»Ri xtzaq kan pa taq kꞌiix, e pachaꞌ ri tikawex kakita Ruchꞌaꞌtem ri Dios, yey na kakiꞌan taj saꞌ ri kubꞌiꞌij. Kokꞌil kꞌu riꞌ kasach uwach Ruchꞌaꞌtem ri Dios kꞌo pa kanimaꞌ ruma rubꞌis kikꞌuꞌx, ri kibꞌeyomalil y ruqusil ruwachulew; y na chom ta kꞌu riꞌ ri kilitaj che ri kibꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","»Noꞌj ri xtzaq kan pa chomilaj ulew, e pachaꞌ ri tikawex kakikꞌul pa saqil wi Ruchꞌaꞌtem ri Dios y rukꞌ ronoje kikꞌuꞌx kakikꞌol pa kanimaꞌ. Lik chom kꞌu riꞌ ri kilitaj che ri kibꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","»Na jinta junoq kutzij juna aqꞌ y kuchꞌuq uwiꞌ rukꞌ juna mulul re pajbꞌal o kujuꞌ chuxeꞌ ruwarabꞌal. Ma ri kuꞌan che, e kuya lo chupa rukꞌolibꞌal chikaj chaꞌ jelaꞌ kutzij kiwiꞌ ri kebꞌok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ma kopon ri qꞌij echiriꞌ janipa ri na qꞌalajisam taj, kaqꞌalajisax na; yey janipa ri ewatalik, ketaꞌmaxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","E uwariꞌche chita chi utz janipa ri kambꞌiꞌij chiwe; ma china ri kukꞌul chi utz janipa ri kakꞌut chwach, riꞌ kakꞌut ne más chwach y jekꞌulaꞌ kumaj más. Yey china ri na kukꞌul ta ri kakꞌut chwach, riꞌ kamaj ne che janipa ri kuchꞌobꞌo umajom chi usukꞌ» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Julaj echiriꞌ lik e kꞌo ukꞌiyal winaq rukꞌ ri Jesús, ruchu y taq ruchaqꞌ xoꞌlkilaꞌ, yey na utz ta kꞌu xeqibꞌ rukꞌ kuma rukꞌiyal winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ekꞌuchiriꞌ, xbꞌiꞌx che ri Jesús: —Ri chu la y taq ri chaqꞌ la e kꞌo pa bꞌe y kakaj kakil wach la. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Rire xukꞌul uwach: —E ri ketaw re Rutzij Upixabꞌ ri Dios y kakiꞌan ronoje ri kubꞌiꞌij, waꞌ e nuchu y e taq nuchaqꞌ riꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Kꞌo jun qꞌij ri Jesús xok chupa jun barco junam kukꞌ rutijoꞌn y xubꞌiꞌij chike: —Joꞌ, chojqꞌax chꞌaqa yaꞌ —xcha chike. Y xebꞌek kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Echiriꞌ kebꞌin chwi ri mar, ri Jesús xwarik. Ewi xpe jun nimalaj kaqjiqꞌ chwi ri mar y xujeq kanoj ri barco che yaꞌ y e riꞌ ya laj kamuqutajik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Na jampatana kꞌut xeꞌkikꞌosoj ri Jesús, jewaꞌ xkibꞌiꞌij che: —¡Qajawal, Qajawal! ¡Kojkamik! —xecha che. Echiriꞌ xyaktaj ri Jesús, xuqꞌatej ri kaqjiqꞌ. Ekꞌu ri yaꞌ kel chikaj, xyeniꞌik y ri tew xtaniꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Tekꞌuchiriꞌ, xubꞌiꞌij chike rutijoꞌn: —¿Saꞌ xuꞌan ri kubꞌulibꞌal ikꞌuꞌx wukꞌ? —xcha chike. Pero rutijoꞌn lik kixiꞌim kibꞌ y kaminaq kanimaꞌ che. Xkibꞌiꞌij kꞌu chikiwach: «¿Saꞌ ruwach waꞌ waꞌchi? ¡Ma tobꞌ ne ri kaqjiqꞌ y ri yaꞌ kakikoj utzij!» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Ekꞌuchiriꞌ, xebꞌopon pa ri luwar re Gadara kꞌo chꞌaqa yaꞌ che Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Echiriꞌ xqaj ri Jesús chuꞌlew, xoꞌlkꞌul ruma jun achi aj pa la tinamit. Kꞌo tan qꞌij waꞌchi kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. Na kukoj ta uqꞌuꞌ y na jeqel ta chirocho, ma jeqel pa taq muqubꞌal ke animaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Waꞌchi, echiriꞌ xril uwach ri Jesús, lik xsikꞌinik y xuxuk ribꞌ chwach. Y lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: —¿Suꞌchak koꞌlmina ibꞌ la wukꞌ, Jesús, lal Ukꞌajol ri Dios kꞌo chilaꞌ chikaj? Kantzꞌonoj ko cheꞌla na kinya ta la pa kꞌax —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","(Xubꞌiꞌij waꞌ ma ri Jesús kutaq ri itzelilaj uxlabꞌixel chaꞌ kel bꞌi che rachi. Yey lik kꞌo tan qꞌij rachi kꞌo puqꞌabꞌ waꞌ. Y tobꞌ kayut pa karena y pa griyetas, ronoje kuraqij y kakꞌam bꞌi ruma ri itzel uxlabꞌixel pa taq luwar katzꞌintzꞌotik.) ");
INSERT INTO acrNNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ekꞌu ri Jesús xutzꞌonoj che rachi: —¿Saꞌ rabꞌiꞌ? —xchaꞌ. Rire xubꞌiꞌij: —Legión —xchaꞌ. Xubꞌiꞌij waꞌ ma lik e kꞌi ri itzel uxlabꞌixel ebꞌokinaq rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ekꞌu taq ri itzel uxlabꞌixel lik xkikoj kibꞌ chwach ri Jesús chaꞌ na kebꞌutaq tubꞌi pa ri siwan na jinta utaqexik uchoyil upa. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","E kꞌo kꞌu ukꞌiyal aq kewaꞌ chwa ri juyubꞌ y taq ri itzel uxlabꞌixel xkitzꞌonoj chaꞌ kebꞌok bꞌi kukꞌ ri aq. Ekꞌu ri Jesús xuya luwar chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ekꞌuchiriꞌ, xebꞌel bꞌi che rachi y xebꞌok bꞌi kukꞌ ri aq. Y konoje waꞌ xeꞌkikꞌaqa bꞌi kibꞌ chwi jun siwan, xebꞌeꞌtzaq chupa ri mar y xejiqꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Ekꞌu ri kechajin ke ri aq, echiriꞌ xkil taq waꞌ, xebꞌanimajik y janipa ri xkilo xebꞌek che utzijoxik chupa ri tinamit y pa taq juyubꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Xepe kꞌu ri winaq che rilik saꞌ ri xꞌaniꞌ chiriꞌ. Echiriꞌ xekꞌun pa kꞌo wi ri Jesús, xkiriq rachi ri ebꞌelinaq chubꞌi ri itzel uxlabꞌixel che, tzꞌul xeꞌraqan uqꞌabꞌ ri Jesús, ukojom chi uqꞌuꞌ y jusukꞌ chi runaꞌoj. Ruma waꞌ, lik xkixiꞌij kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Y ri xebꞌilow waꞌ xkitzijoj chike ri kꞌakꞌ xekꞌunik, suꞌanik xkolobꞌetaj rachi ri xebꞌel bꞌi ri itzel uxlabꞌixel che. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Ekꞌuchiriꞌ, konoje ri winaq pa taq ri luwar re Gadara xebꞌelaj che ri Jesús kel bꞌi chiriꞌ ma lik kixiꞌim kibꞌ che. Y ri Jesús xok chupa ri barco chaꞌ katzelejik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ekꞌuchiriꞌ, rachi ri ebꞌelinaq bꞌi ri itzel uxlabꞌixel che, xelaj che ri Jesús chaꞌ kuya luwar che katerej bꞌi chirij; pero ri Jesús xutaq che kakanaj kanoq, jewaꞌ xubꞌiꞌij che: ");
INSERT INTO acrNNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Chat-tzelej chaꞌwocho y chatzijoj chike ri tikawex ronoje ri utz uꞌanom ri Dios awukꞌ —xchaꞌ. Y rachi e xuꞌano; xeꞌek che utzijoxik chupa ronoje ri tinamit ri utz xꞌan che ruma ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Echiriꞌ xtzelej ri Jesús chꞌaqa yaꞌ, ri winaq xkikꞌul rukꞌ kiꞌkotemal ma konoje lik koyeꞌem. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ekꞌuchiriꞌ, xopon jun achi Jairo rubꞌiꞌ, rire aj wach re ri sinagoga. Waꞌ waꞌchi xuxuk ribꞌ xeꞌraqan uqꞌabꞌ ri Jesús y lik xelaj che keꞌek chirocho, ");
INSERT INTO acrNNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ma xa jun ko rumiꞌal y laj kabꞌlajuj rujunabꞌ, yey kajekꞌowik. Ekꞌuchiriꞌ xeꞌek ri Jesús rukꞌ, ukꞌiyal winaq xeterej bꞌi chirij y lik kakipitzꞌipaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chikixoꞌlibꞌal kꞌu ri winaq kꞌo jun ixoq lik yewaꞌ, e kabꞌlajuj lo junabꞌ riꞌ na kataniꞌ ta ri yabꞌil re upa ikꞌ che. Ronoje ri kꞌo rukꞌ ukꞌisom chi ne kukꞌ ri aj kun, yey na jinta junoq xriqow ukunaxik ri yabꞌil kꞌo che. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Rire xqibꞌ kꞌu pana chirij ri Jesús y xuchap ruchiꞌ ruqꞌuꞌ. Y chupa kꞌu laꞌ la joqꞌotaj xtaniꞌ ruyabꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ekꞌuchiriꞌ, ri Jesús xutzꞌonoj: —¿China ri xchapaw weꞌin? —xchaꞌ. Yey na jinta junoq kuya ribꞌ chupa. Ekꞌuchiriꞌ ri Pedro y ri rachbꞌiꞌil xkibꞌiꞌij: —Qajawal, ri winaq kakipitzꞌipaꞌ la y kakiminimaꞌ la. ¿Suꞌchak kꞌu riꞌ katzꞌonoj la: “¿China ri xchapaw weꞌin?” —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Noꞌj ri Jesús xubꞌiꞌij: —Kꞌo jun xinchapawik ma xinnaꞌo kꞌo jun xkunutaj rukꞌ ri nuchuqꞌabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Echiriꞌ rixoq xrilo xnaꞌbꞌetaj ruma ri Jesús, xpetik kabꞌirbꞌotik. Xuxukubꞌaꞌ kꞌu ribꞌ xeꞌraqan uqꞌabꞌ ri Jesús y xutzijoj chikiwach konoje ri winaq suꞌbꞌe xuchap ruqꞌuꞌ ri Jesús y chaꞌtaj xa pa joqꞌotaj xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ekꞌu ri Jesús xubꞌiꞌij che: —Ixoq, ruma ri kubꞌulibꞌal kꞌuꞌx la wukꞌ, xkunutaj la. Oj kꞌu la riꞌ chi utzil chomal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Kꞌa kachꞌaꞌt ne ri Jesús, echiriꞌ xkꞌun lo jun petinaq chirocho ri aj wach re ri sinagoga y xoluꞌbꞌiꞌij che ri Jairo: —Ri miꞌal la ya xkamik; na jinta chi kutiqoj kabꞌayabꞌaꞌ la ri tijonel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Echiriꞌ xuta waꞌ ri Jesús, xubꞌiꞌij che ri Jairo: —Muxiꞌij ribꞌ kꞌuꞌx la, xew lik kubꞌula kꞌuꞌx la wukꞌ y jelaꞌ kakolobꞌetaj ri miꞌal la che ri kamik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Ekꞌuchiriꞌ xopon chirocho ri Jairo, ri Jesús xew xebꞌukoj bꞌi ri Pedro, ri Jacobo, ri Juan y ruchu-uqaw ri ralko ali; y na xuya ta luwar che junoq chik kok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Konoje ri winaq kebꞌoqꞌik y lik ketunanik. Noꞌj ri Jesús xubꞌiꞌij chike: —Mixoqꞌik, ma ri ralko ali na kaminaq taj, xa kawarik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ekꞌu rike xa xkitzeꞌej ri xubꞌiꞌij, ma ketaꞌam kaminaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Noꞌj ri Jesús xuchap ruqꞌabꞌ ri ralko ali y lik ko xubꞌiꞌij: —Ali chuuy, ¡chatyaktajoq! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ekꞌuchiriꞌ xtzelej lo ri ranimaꞌ y chupa kꞌu laꞌ la joqꞌotaj xyaktajik. Y ri Jesús xebꞌutaq che uyaꞌik uwa. ");
INSERT INTO acrNNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ekꞌu ruchu-uqaw lik xkam kanimaꞌ che, pero ri Jesús xebꞌutaq che na kakibꞌiꞌij ta che junoq wa xuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Ri Jesús xumol kichiꞌ ri kabꞌlajuj utijoꞌn y xuya pakiqꞌabꞌ kebꞌekesaj bꞌi itzelilaj uxlabꞌixel y kekikunaj ri yewaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Xebꞌutaq kꞌu bꞌi riꞌ che utzijoxik rutaqanik ri Dios y che kikunaxik ri yewaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Jewaꞌ xubꞌiꞌij chike: «Makꞌo mikꞌam bꞌi re pa bꞌe; mikꞌam bꞌi ichꞌamiꞌy, itebꞌ, iwa, imeyo o jun chik ikoton. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","We xixkꞌul pa juna ja, chixkꞌola chiriꞌ kꞌate kixel bꞌi echiriꞌ kixꞌek pa jun chik tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We chupa juna tinamit na kixkꞌul taj, chixelubꞌi chiriꞌ y chipupaꞌ kan rulew kꞌo che ri iwaqan, waꞌ e kꞌutubꞌal re na utz ta kiꞌanom ri ejeqel chiriꞌ» xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Xebꞌel kꞌu bꞌi rutijoꞌn y xebꞌek pa taq aldeas re kakitzijoj ri Utzilaj Tzij y re kekikunaj yewaꞌibꞌ che ronoje luwar. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Ri Herodes, ri rey re Galilea, xuta puwi ronoje ri kuꞌan ri Jesús. Ruma kꞌu waꞌ, lik sachinaq runaꞌoj, ma e kꞌo jujun kebꞌiꞌn re: «Laꞌ e ri Juan xkꞌastaj lo chikixoꞌl ri ekaminaq» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yey e kꞌo jujun kakibꞌiꞌij: «Rire e Elías xwinaqir loq.» Y e kꞌo jujun chik kakibꞌiꞌij: «E junoq chike ri qꞌalajisanelabꞌ re ojertan xkꞌastaj loq» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Noꞌj ri rey Herodes xubꞌiꞌij: «Riꞌin xintaq ukꞌatzixik rujolom ri Juan. ¿China kꞌu riꞌ waꞌ waꞌchi lik saꞌchi ri kintajin che utayik puwiꞌ?» xchaꞌ. Y kutzukuj kꞌut suꞌanik karil uwach ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Echiriꞌ xetzelej lo ri kabꞌlajuj utaqoꞌn ri Jesús, xkitzijoj che Rire janipa taq ri xkiꞌano. Ekꞌuchiriꞌ, xekꞌam bꞌi ruma ri Jesús y xebꞌek kitukel pa jun luwar katzꞌintzꞌotik chunaqaj jun tinamit Betsaida rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Noꞌj ri winaq echiriꞌ xketaꞌmaj, xebꞌel lo pa taq ri tinamit y xebꞌek chaꞌ keꞌkiriqa ri Jesús. Yey Rire xebꞌukꞌul chi utz, xujeq katzijon chikiwach puwi rutaqanik ri Dios y xebꞌukunaj ri e yewaꞌibꞌ chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Echiriꞌ katajin ubꞌenam ri qꞌij, xeqibꞌ lo ri kabꞌlajuj utijoꞌn y xkibꞌiꞌij che: —Qajawal, utz we ketaq bꞌi la ri winaq pa taq raldeas y pa taq ri luwar kꞌo lo xa naqaj chaꞌ keꞌkitzukuj pa kewar wi y saꞌ ri kakitijo, ma ri wara pa oj kꞌo wi lik katzꞌintzꞌotik —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Noꞌj ri Jesús xubꞌiꞌij chike: —Chebꞌitzuqu riꞌix —xchaꞌ. Ekꞌu rutijoꞌn xkibꞌiꞌij che: —Xa woꞌobꞌ pam y kaꞌibꞌ kar kꞌo qukꞌ. Xew we e laꞌ kojꞌek y keꞌqaloqꞌo waꞌim ke konoje wa ukꞌiyal winaq, keqatzuq kꞌu riꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Laj e lo woꞌobꞌ mil chi achijabꞌ e kꞌo chiriꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike rutijoꞌn: —Chibꞌiꞌij chike ri winaq ketzꞌuyiꞌ chimutzaꞌj re nikꞌaj ciento chujujunal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Jelaꞌ xkiꞌano, xekitzꞌuyubꞌaꞌ konoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Ekꞌuchiriꞌ ri Jesús xukꞌam ri woꞌobꞌ pam y ri kaꞌibꞌ kar, xtzuꞌn chikaj y xtioxin chwach ri Dios. Xuya kꞌu bꞌi chike rutijoꞌn chaꞌ kakijach chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Konoje kꞌu ri winaq xewaꞌik y xenoj chi utz. Tekꞌuchiriꞌ, xkimol ri chꞌaqaꞌtaꞌq kiqax y rukꞌ waꞌ xnoj lo kabꞌlajuj chakach. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Kꞌo jun qꞌij ri Jesús utukel kachꞌaꞌt rukꞌ ri Dios, yey xew rutijoꞌn e kꞌo rukꞌ. Ewi xutzꞌonoj chike: —Chikiwach ri winaq, ¿in china nawi riꞌin? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Rutijoꞌn xkikꞌul uwach che: —Kꞌo kebꞌiꞌn re lal ri Juan Aj Yaꞌl Bautismo; jujun chik kakibꞌiꞌij lal ri Elías; y jujun chik, lal junoq chik chike ri qꞌalajisanelabꞌ re ojertan kꞌastajinaq loq —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ekꞌuchiriꞌ, xutzꞌonoj tanchi chike: —Yey chiwach riꞌix, ¿in china riꞌin? —xchaꞌ. Ekꞌu ri Pedro xukꞌul uwach: —Rilal lal ri Cristo, Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Pero ri Jesús lik xebꞌutaq che na kakitzijoj ta kꞌana che junoq china Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ekꞌuchiriꞌ, xubꞌiꞌij chike: —Lik chirajawaxik che Ralaxel Chikixoꞌl Tikawex kutij na ri kꞌax y kakꞌaq bꞌi uqꞌij kuma ri nimaq winaq re ri tinamit, ri nimaq e aj chakunel pa Rocho Dios y raj kꞌutunel re ri tzijpixabꞌ. Tekꞌuchiriꞌ, kakamisaxik; noꞌj churox qꞌij kakꞌastaj loq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Xubꞌiꞌij tanchi kꞌu chike konoje: —We kꞌo junoq karaj katerej lo chwij, lik chirajawaxik che muꞌan xew ri karaj rire, e ronoje qꞌij chukuyu ri kꞌax kape puwiꞌ ruma ukojom ri nubꞌiꞌ; yey utz kꞌu riꞌ katerej lo chwij. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Ma china ri na kuya ta ranimaꞌ rukꞌaslem, riꞌ e kujam ri chomilaj kꞌaslemal chwach ri Dios; noꞌj ri kuya ranimaꞌ rukꞌaslem wuma riꞌin, riꞌ e kuriq ri chomilaj ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","»¿Saꞌ kꞌu kutiqoj riꞌ che juna tikawex we kuꞌan rajaw ronoje ruwachulew, yey e kujam rukꞌaslemal y jelaꞌ kusach uwach chiribꞌil ribꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ma china ri kakꞌix chwe riꞌin y che ri nuchꞌaꞌtem, jelaꞌ kꞌu riꞌ ri in Alaxel Chikixoꞌl Tikawex kinkꞌix che rire echiriꞌ kinkꞌun tanchi rukꞌ runimal nuchomalil, junam rukꞌ runimal uchomalil ri Nuqaw y kukꞌ taq ri santowilaj ángeles. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Riꞌin paqatzij wi kambꞌiꞌij chiwe: E kꞌo jujun chike wa e kꞌo wara na kekam tana we na xkil tubꞌi rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Laj wajxaqibꞌ qꞌij riꞌ ubꞌiꞌim waꞌ ri Jesús echiriꞌ xebꞌuchaꞌ ri Pedro, ri Juan y ri Jacobo y xel bꞌi kukꞌ chwa jun juyubꞌ chaꞌ keꞌchꞌaꞌt rukꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Yey echiriꞌ kachꞌaꞌt rukꞌ ri Dios, xjalkꞌatitaj rupalaj y ruqꞌuꞌ xuꞌan lik saq y kawolqꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Y xewinaqir kꞌu kebꞌ achijabꞌ e riꞌ kechꞌaꞌt rukꞌ. Waꞌ e ri Moisés y ri Elías, qꞌalajisanelabꞌ re ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ekꞌu rike sututal kij rukꞌ jun chomilaj qꞌijsaq. Y kechꞌaꞌt puwi rukamik ri Jesús, ri kukꞌulumaj na chilaꞌ Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Ri Pedro kukꞌ ri rachbꞌiꞌil lik kꞌo waram chike, pero xtzor kaꞌn kiwach y xkil kꞌu runimal uwonibꞌal ri Jesús y ri kaꞌibꞌ achijabꞌ e kꞌo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Ekꞌuchiriꞌ katajin bꞌi kelik ri kaꞌibꞌ achijabꞌ rukꞌ ri Jesús, ri Pedro xubꞌiꞌij che ri Jesús: —Qajawal, lik utz xyaꞌtaj chiqe oj kꞌo wara. Qaꞌana kꞌu oxibꞌ rancho: jun e la, jun re ri Moisés y jun re ri Elías —xchaꞌ. Ri Pedro xubꞌiꞌij waꞌ ruma na kunaꞌ taj saꞌ ri kubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Kꞌa kachꞌaꞌt ne ri Pedro, echiriꞌ xpe jun sutzꞌ y xuchꞌuq kiwiꞌ. Lik kꞌu xkixiꞌij kibꞌ riꞌ echiriꞌ xechꞌuqutaj ruma ri sutzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ekꞌuchiriꞌ, xkita ruqul ri Dios chupa ri sutzꞌ, jewaꞌ kubꞌiꞌij: «E Nukꞌajol waꞌ ri lik kꞌax kannaꞌo; e chita utzij Rire» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Ekꞌuchiriꞌ xkꞌis ubꞌiꞌxikil waꞌ, na e jinta chi ri kaꞌibꞌ achijabꞌ rukꞌ ri Jesús. Chupa taq kꞌu riꞌ laꞌ la qꞌij, ri Pedro, ri Juan y ri Jacobo na xkitzijoj ta kꞌana che junoq waꞌ wa xkilo. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chukaꞌm qꞌij echiriꞌ xeqaj lo chwa ri juyubꞌ, ukꞌiyal winaq xebꞌel lo che ukꞌulik ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Kꞌo kꞌu jun achi chikixoꞌl ri winaq lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: —Lal tijonel, ꞌana ko la riꞌ, kunaj la wa nukꞌajol, ma xew ne ko walkꞌoꞌal waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Rire kachaptaj ruma jun itzel uxlabꞌixel. Yey echiriꞌ ritzel uxlabꞌixel kuchapo, rala xaqikꞌateꞌt kujeq kasikꞌinik, katzaq pulew, lik ko kujabꞌajaꞌ ribꞌ y kapuluwan rukꞌaxaj. Ekꞌu ri itzel uxlabꞌixel lik kuꞌan kan kꞌax che y lik na karaj taj kel bꞌi rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Ya xinelaj ko chike ri tijoꞌn la chaꞌ kakesaj bꞌi ri itzel uxlabꞌixel, pero rike na xkichꞌij ta resaxik bꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Ekꞌu ri Jesús xukꞌul uwach: —¡E ri ix tikawex re waqꞌij ora, na kubꞌul ta ikꞌuꞌx wukꞌ yey ix sachinaq! ¿Janipa chi lo qꞌij kajawaxik kinkꞌojiꞌ iwukꞌ chaꞌ kakubꞌiꞌ ikꞌuꞌx wukꞌ? ¿Janipa chi lo qꞌij kixinkuyu e laꞌ jelaꞌ iꞌanom? —xchaꞌ. Ekꞌuchiriꞌ, xubꞌiꞌij che rachi: —Kꞌama lo ri kꞌajol la wara —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Echiriꞌ rala xqibꞌ rukꞌ ri Jesús, xkꞌaq pulew y lik ko xjabajoꞌx ruma ri itzelilaj uxlabꞌixel. Pero ri Jesús xutaq ri itzelilaj uxlabꞌixel chaꞌ kel bꞌi che rala y jekꞌulaꞌ xukunaj kan rala. Tekꞌuchiriꞌ, xuya bꞌi puqꞌabꞌ ruqaw. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Y konoje xkam kanimaꞌ che runimal uchuqꞌabꞌ ri Dios. Ruma kꞌu konoje kaminaq kanimaꞌ che ri kuꞌan ri Jesús, Rire jewaꞌ xubꞌiꞌij chike rutijoꞌn: ");
INSERT INTO acrNNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Lik chita chi utz waꞌ y mikꞌow chikꞌuꞌx: Ralaxel Chikixoꞌl Tikawex kayaꞌiꞌ pakiqꞌabꞌ rachijabꞌ chaꞌ rike kakiqꞌat tzij puwiꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Noꞌj rutijoꞌn na xkimaj ta usukꞌ la kubꞌiꞌij, ma kꞌamajaꞌ kayaꞌtaj chike kakimaj usukꞌ waꞌ. Yey kakixiꞌij kibꞌ kakitzꞌonoj che ri Jesús saꞌ keꞌelawi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ekꞌuchiriꞌ, rutijoꞌn ri Jesús xkijeqo kakichapalaꞌ kibꞌ chikiwach puwiꞌ chinoq chike kayaꞌiꞌ más uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Ewi ri Jesús xunaꞌbꞌej ri kꞌo pa kanimaꞌ. Xukꞌam kꞌu jun ralko kꞌoꞌm y xuya putzal. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Xubꞌiꞌij kꞌu chike: —China ri kukꞌul chupa ri nubꞌiꞌ junoq na jinta uwach pachaꞌ wa ralko kꞌoꞌm, e junam rukꞌ e in ri kinukꞌulu. Yey china ri kakꞌuluw we riꞌin, e kukꞌul kꞌu ri Jun taqayom lo we. Ma e ri kuꞌan chꞌutiꞌn che ribꞌ, e lik kꞌo uwach riꞌ chwach ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ekꞌuchiriꞌ, ri Juan xubꞌiꞌij che ri Jesús: —Qajawal, xqil jun achi kebꞌeresaj bꞌi itzel uxlabꞌixel chupa ri bꞌiꞌ la; yey riꞌoj xqabꞌiꞌij che muꞌan chi waꞌ, ma rire na qukꞌil taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ekꞌu ri Jesús xubꞌiꞌij che ri Juan: —We kꞌo kaꞌanaw waꞌ, miqꞌatej; ma china ri na kachꞌoꞌjin ta chiqij, riꞌ e qukꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","E xuꞌan waꞌ echiriꞌ ya kopon ruqꞌijol kakꞌam pan ri Jesús chilaꞌ chikaj: Rire xa jumul xujikibꞌaꞌ uwach keꞌek chupa ri tinamit Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Xebꞌunabꞌesaj bꞌi rutijoꞌn chwach Rire. Rike xebꞌek y xebꞌok chupa jun aldea ke ri aj Samaria chaꞌ kakitzukuj pa kakanaj wi ri Jesús chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Pero ri aj Samaria na xkaj taj kakikꞌulu ma xkinaꞌbꞌej Jerusalem keꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Echiriꞌ ri Jacobo y ri Juan, ri kebꞌ utijoꞌn ri Jesús xkil waꞌ, xkibꞌiꞌij che: —Qajawal, ¿kaꞌaj la kojtaqan che chaꞌ kaqaj lo aqꞌ chilaꞌ chikaj y jekꞌulaꞌ kasach kiwach konoje, jelaꞌ pachaꞌ xuꞌan ri qꞌalajisanel Elías ojertan? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Pero ri Jesús xutzuꞌ kiwach y xebꞌuyajo, jewaꞌ xubꞌiꞌij chike: —Riꞌix na iwetaꞌam taj saꞌ chi uxlabꞌixel xkojow waꞌ pijolom. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma ri in Alaxel Chikixoꞌl Tikawex na in ta kꞌuninaq che usachik kiwach ri tikawex; ma in petinaq che kikolobꞌexik —xchaꞌ. Ekꞌuchiriꞌ, xebꞌek tanchi chupa jun chik aldea. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Xaloqꞌ kꞌu riꞌ e kꞌo chi bꞌe, kꞌo jun xubꞌiꞌij che ri Jesús: —Wajawal, riꞌin kinterej bꞌi chiꞌij la tobꞌ pachawi keꞌek wi la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Ekꞌu ri Jesús xubꞌiꞌij che: —Ri yak kꞌo kijul y ri tzꞌikin kexikꞌikꞌ che ruwa kaj kꞌo kisok; noꞌj Ralaxel Chikixoꞌl Tikawex na jinta ne uluwar tobꞌ xa pa kuxlan wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Tekꞌuchiriꞌ, xubꞌiꞌij che jun chik achi: —Chat-terej lo chwij —xchaꞌ. Ekꞌu rachi xubꞌiꞌij che ri Jesús: —Wajawal, yaꞌa la luwar chwe kanwoyꞌej kakam na ri nuqaw y kanmuq kanoq; tekꞌuchiriꞌ, kinterej chiꞌij la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Ri Jesús xubꞌiꞌij che: —Chayaꞌa kan chike ri ekaminaq chwach ri Dios chaꞌ e rike kemuquw ri katz-kichaqꞌ kekamik; noꞌj riꞌat jat y chat-tzijon puwi rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Tekꞌuchiriꞌ, kꞌo tanchi jun jewaꞌ xubꞌiꞌij che ri Jesús: —Wajawal, riꞌin kuaj kinterej bꞌi chiꞌij la. Pero nabꞌe na yaꞌa la luwar chwe kebꞌenuchꞌaꞌbꞌej kan ri watz-nuchaqꞌ e kꞌo pa wocho —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ri Jesús xubꞌiꞌij che: —Na jinta junoq echiriꞌ uchapom rabꞌixobꞌal katzuꞌn kan chirij, ma riꞌ na jusukꞌ ta ri chak kuꞌano. Jekꞌuriꞌlaꞌ, we junoq na uyaꞌom ta kan ronoje, na taqal ta che kꞌo chupa rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Tekꞌuchiriꞌ, ri Qanimajawal xebꞌuchaꞌ chi setenta utijoꞌn y xebꞌutaq bꞌi pa kakabꞌ chaꞌ kenabꞌej bꞌi chwach Rire pa ronoje taq tinamit y luwar pa keꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Echiriꞌ kꞌamajaꞌ kebꞌel bꞌi, ri Jesús xubꞌiꞌij chike: «Paqatzij wi kambꞌiꞌij chiwe: Ri molonik kajawaxik kaꞌanik, lik nim; noꞌj raj chak na e kꞌi taj. E uwariꞌche chitzꞌonoj che ri Dios, ri Rajaw ri molonik, chaꞌ kebꞌutaq lo aj chak re kakiꞌan ri molonik. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","¡Jix! Pero chitapeꞌ: Riꞌin kixintaq bꞌi pachaꞌ ix bꞌexex chikixoꞌl utiw. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","»Echiriꞌ kixꞌek, mikꞌam bꞌi ukꞌolibꞌal imeyo, mikꞌam bꞌi itebꞌ, mikꞌam bꞌi jun chik molaꞌj ixajabꞌ. Yey mixtakꞌiꞌ pa bꞌe re kiya kan rutzil uwach junoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","»We xixok chuchiꞌ juna ja, ri nabꞌe ichꞌaꞌtem kibꞌiꞌij e waꞌ: “Kꞌola ri utzil chomal re ri Dios pawiꞌ alaq.” ");
INSERT INTO acrNNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","We kꞌo junoq chiriꞌ lik karaj kukꞌul ri utzil chomal re ri Dios, kukꞌul kꞌu riꞌ. Noꞌj we na jinta kakꞌuluw re ri utzil chomal re ri Dios, waꞌ katzelej tanchi lo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Pa kixkꞌul wi, chixkanaj chiriꞌ chupa ri ja; mixqꞌax che jujun chik ja. Utz kitij ri kayaꞌ chiwe; ma e junoq kachakunik, lik taqal che katojik. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","We xixok chupa juna tinamit y xixkꞌul pa juna ja, chitijaꞌ saꞌ ri kayaꞌ lo chiwach y mitzꞌonoj ri kiwaj riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","»Chebꞌikunaj kꞌu ri e yewaꞌibꞌ e kꞌo chupa ri tinamit y chibꞌiꞌij chike konoje: “Rutaqanik ri Dios xa naqaj chi kꞌo wi lo che alaq.” ");
INSERT INTO acrNNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","»We xixok kꞌu chupa juna tinamit yey na kixkꞌul taj, chixelubꞌi pa taq bꞌe y chibꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Tobꞌ ne rulew re wa tinamit alaq kꞌo che ri qaqan, kaqapuꞌ kanoq chaꞌ ketaꞌmaj alaq na utz ta ri xꞌan alaq. Pero chetaꞌmaj alaq chi utz waꞌ: Rutaqanik ri Dios xa naqaj chi kꞌo wi lo che alaq” kixchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Kambꞌiꞌij kꞌu chiwe: Más lik kꞌax ri kape na pakiwi ri tinamit na kakikꞌul ta ri Utzilaj Tzij, chwa ri kape pakiwi ri e aj Sodoma y ri e aj Gomorra. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","»¡Lik toqꞌoꞌ iwach ri ix aj Corazín! ¡Lik toqꞌoꞌ iwach ri ix aj Betsaida! Ma we ta chupa ri tinamit Tiro y ri tinamit Sidón xilitaj wi wa kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xinꞌan chiwach riꞌix, kꞌo tan qꞌij ta lo riꞌ xkitzelej kitzij chwach ri Dios, kikojom kꞌu kiqꞌuꞌ kꞌax rij y kitzꞌuyubꞌam kibꞌ pa chaaj ruma ri kibꞌis. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","E uwariꞌche echiriꞌ kopon ri qꞌij re ri qꞌatbꞌal tzij, más nim ri kꞌaxkꞌobꞌik kape piwiꞌ chwa ri kꞌaxkꞌobꞌik kape pakiwi ri winaq re ri tinamit Tiro y ri tinamit Sidón. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ekꞌu ri ix aj Capernaúm, e chiwach riꞌix lik yakom chi iqꞌij kꞌa chikaj; yey na e ta riꞌ, ma lik kakꞌaq ne bꞌi iqꞌij y kixkꞌaq ne bꞌi kꞌa chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","»China ri kataw iweꞌix, in ri kinuto; china ri tzel kilow iwe, in ri tzel kinrilo; china ri tzel kilow we riꞌin, e tzel karil ri Jun taqayom lo we riꞌin» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xebꞌek kꞌu riꞌ ri setenta. Y ekꞌuchiriꞌ xetzelej loq, lik kekiꞌkotik. Xkitzijoj kꞌu che ri Jesús: —Qajawal, ¡taq ri itzel uxlabꞌixel xkikoj qatzij echiriꞌ chupa ri bꞌiꞌ la xojtaqan che kebꞌel bꞌi chike ri winaq! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Ri Jesús xubꞌiꞌij chike: —Riꞌin xinwil ri Satanás xkꞌaq lo chikaj pachaꞌ jun rayo. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","¡Chiwilapeꞌ! Riꞌin nuyaꞌom ichuqꞌabꞌ chaꞌ kichꞌij uchuqꞌabꞌ ritzel winaq y na jinta kꞌo kikꞌulumaj tobꞌ ne kiyiqꞌiyaꞌ kiwiꞌ kumatz y sinaꞌj. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Pero riꞌix mixkiꞌkot ruma kakikoj itzij ri itzel uxlabꞌixel; e chixkiꞌkota ruma tzꞌibꞌital ribꞌiꞌ chilaꞌ chikaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ekꞌu laꞌ la joqꞌotaj, ri Jesús lik xkiꞌkot ruma ri Santowilaj Ruxlabꞌixel ri Dios y xubꞌiꞌij: «Nuqaw, kanyak qꞌij la, Lal Rajaw ruwa kaj y ruwachulew, ma taq ri qꞌalajisam la chike ri lik kakiꞌan chꞌutiꞌn che kibꞌ, waꞌ ewam la chikiwach ri lik kꞌo kinaꞌoj y lik kꞌo kimajom. Jelaꞌ xꞌan la, Nuqaw, ma e xꞌaj la riꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Tekꞌuchiriꞌ, xubꞌiꞌij chike ri tikawex: «Ronoje taq ri kꞌolik yaꞌtal lo panuqꞌabꞌ ruma ri Nuqaw. Na jinta kꞌu junoq umajom usukꞌ chi utz saꞌ ruwach Rukꞌajol ri Dios; xew ri Qaqaw Dios etaꞌmayom re. Y na jinta ne junoq umajom usukꞌ chi utz saꞌ ruwach ri Qaqaw Dios, xew Rukꞌajol ri Dios etaꞌmayom re; yey puqꞌabꞌ kꞌu riꞌ Rukꞌajol kꞌo wi china chike karaj kuqꞌalajisaj wi waꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Tekꞌuchiriꞌ xqibꞌ kukꞌ rutijoꞌn y e laꞌ xa kitukel xubꞌiꞌij chike: «Nim kiqꞌij kalaxik ri kakilo janipa ri iwilom riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Ma kambꞌiꞌij kꞌu chiwe lik e kꞌi ri qꞌalajisanelabꞌ y ri taqanelabꞌ re ojertan lik xkaj kakil bꞌi janipa ri kiwil riꞌix woꞌora, pero na xkimaj ta chi rilik bꞌi. Lik xkaj kakita bꞌi janipa ri kita riꞌix woꞌora, pero na xkimaj ta chi utayik bꞌi» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Kꞌo jun aj kꞌutunel re ri tzijpixabꞌ xyaktajik y jewaꞌ xubꞌiꞌij chaꞌ kukꞌam upa ri Jesús: —Wajawal, ¿saꞌ ri kanꞌano chaꞌ kꞌo nukꞌaslemal na jinta utaqexik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ri Jesús xubꞌiꞌij che: —¿Saꞌ ri tzꞌibꞌital chupa Rutzij Upixabꞌ ri Dios? ¿Saꞌ ri kamaj la usukꞌ che? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Y raj wach xukꞌul uwach: —Jewaꞌ tzꞌibꞌitalik: Kꞌax chanaꞌa ra Dios Qajawxel rukꞌ ronoje awanimaꞌ, rukꞌ ronoje akꞌuꞌx, rukꞌ ronoje achuqꞌabꞌ y rukꞌ ronoje anaꞌoj; yey Kꞌax chanaꞌa rawatz-achaqꞌ jelaꞌ pachaꞌ ri kꞌax kanaꞌ awibꞌ riꞌat —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Y ri Jesús xubꞌiꞌij che: —Lik utz ri xkꞌulubꞌej wi la uwach. ꞌAna kꞌu la waꞌ y kakꞌojiꞌ kꞌaslemal la na jinta utaqexik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Pero raj wach na karaj taj kutzaq ribꞌ y xubꞌiꞌij kꞌu che ri Jesús: —¿Yey china ri watz-nuchaqꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Ri Jesús jewaꞌ xubꞌiꞌij che: «Kꞌo jun achi xel chupa ri tinamit Jerusalem y xeꞌek pa ri tinamit Jericó. Pa bꞌe kꞌut xtzaq pakiqꞌabꞌ jujun eleqꞌomabꞌ. Releqꞌomabꞌ xkimaj bꞌi ronoje rubꞌitaq re y lik xkiꞌan kan kꞌax che. Kajekꞌowik xkiya kanoq y xebꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","»Ekꞌuchiriꞌ, chupa ri bꞌe xkꞌun lo jun aj chakunel pa Rocho Dios. Y echiriꞌ xril rachi ꞌanom kan kꞌax che, xa xutzuꞌ kanoq y xikꞌowik. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","»Tekꞌuchiriꞌ xkꞌun lo jun chik achi aj levita, toꞌbꞌel ke raj chakunel pa Rocho Dios. Echiriꞌ xopon chunaqaj rachi ꞌanom kan kꞌax che, xa xutzuꞌ kanoq y xikꞌowik. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","»Xkꞌun kꞌu lo jun achi aj Samaria. Echiriꞌ xkꞌun chunaqaj rachi ꞌanom kan kꞌax che y xrilo saꞌ ruꞌanom, lik xjuchꞌ kaꞌn pa ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Xqibꞌ kꞌu rukꞌ, xukunaj uwach rukꞌax rukꞌ aceite y rukꞌ vino, y xuchꞌuq uwach rukꞌax rukꞌ kꞌul. Xuyak bꞌi chwi rukawayuꞌ, xukꞌam bꞌi chupa jun mesón y xuchajij chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Echiriꞌ xel chiriꞌ chukaꞌm qꞌij, xresaj lo kaꞌibꞌ denarios pubꞌolxa y xuya kan che ri rajaw ri mesón, y jewaꞌ xubꞌiꞌij che: “Chajij ko la waꞌchi chwe. We na xuꞌan ta kꞌu wa puaq kanya kan cheꞌla, echiriꞌ kintzelej loq, kanyijbꞌaꞌ cheꞌla” xchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Tekꞌuchiriꞌ ri Jesús xubꞌiꞌij che raj kꞌutunel: —Chiwach rilal, ¿china chike wa oxibꞌ achijabꞌ xuꞌan ratz-uchaqꞌ rachi xchapataj kuma releqꞌomabꞌ pa bꞌe? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Raj kꞌutunel xubꞌiꞌij: —Chinuwach riꞌin, e ri jun xukꞌut ri kꞌaxnaꞌbꞌal ukꞌuꞌx che —xchaꞌ. Ekꞌuchiriꞌ xubꞌiꞌij ri Jesús che: —Lik areꞌ. Jelaꞌ kꞌu riꞌ ꞌana la rilal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Echiriꞌ ri Jesús kꞌo chi bꞌe, xok chupa jun aldea. Chiriꞌ kꞌo jun ixoq Marta rubꞌiꞌ y rire xukꞌul ri Jesús chirocho. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Wiꞌxoq Marta kꞌo jun uchaqꞌ María rubꞌiꞌ. Ekꞌu ri María xtzꞌuyiꞌ chwach ri Jesús chaꞌ kuta ri kubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Noꞌj ri Marta lik e ubꞌis ukꞌuꞌx taq ri kaꞌan pa ja. Ekꞌuchiriꞌ, xqibꞌ rukꞌ ri Jesús y jewaꞌ xubꞌiꞌij che: —Wajawal, ¿lik kami e laꞌ na kok ta la il che ri kuꞌan ri nuchaqꞌ? Ma inuyaꞌom kan nutukel chwach ri nimanik. Bꞌiꞌij ko la che kinutoꞌo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Noꞌj ri Jesús xubꞌiꞌij che: —Marta, Marta, riꞌat lik e ubꞌis akꞌuꞌx y e sachinaq anaꞌoj puwi ri kaꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xa jun kꞌu ri lik chirajawaxik wi kaꞌanik, waꞌ e ri más utz, y ri María e uchaꞌom waꞌ; yey na jinta junoq kamajaw waꞌ che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Kꞌo jun qꞌij ri Jesús kachꞌaꞌt rukꞌ ri Dios. Y echiriꞌ xukꞌis uꞌanik orar, jun chike rutijoꞌn xubꞌiꞌij che: —Qajawal, kꞌutu la chiqe suꞌanik kaqaꞌan orar, jelaꞌ pachaꞌ xuꞌan ri Juan kukꞌ rutijoꞌn —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Y ri Jesús xubꞌiꞌij chike: —Echiriꞌ kixchꞌaꞌt rukꞌ ri Dios, utz jewaꞌ kibꞌiꞌij: Qaqaw Dios, Lal kꞌo la chilaꞌ chikaj, ¡lik chetaꞌmaxoq nim uqꞌij ri bꞌiꞌ la! Peta la, taqana la paqawiꞌ; chuꞌana kꞌu ri rajawal kꞌuꞌx la wara che ruwachulew, jelaꞌ pachaꞌ ri kaꞌan chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Yaꞌa ko la waqꞌij ri qawa, ri kajawax chiqe ronoje qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kuyu ko la qamak, jelaꞌ pachaꞌ riꞌoj kaqakuy kimak konoje ri emakuninaq chiqij. Y maya ko la luwar chiqe kojtzaq pa mak; e lik chojkolobꞌej la chwach ritzel winaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ekꞌu ri Jesús xubꞌiꞌij tanchi chike: «We ta e laꞌ kꞌo junoq chiwe, pa tikꞌil aqꞌabꞌ keꞌek chirocho juna ramigo y jewaꞌ kubꞌiꞌij che: “Wamigo, maꞌan ko riꞌ kanjal oxibꞌ nuwa chawe, ");
INSERT INTO acrNNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ma xkꞌun jun wamigo petinaq naj y na jinta chi nuwa re kantzuqu” kacha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","»Ekꞌu rire kukꞌul lo uwach kꞌa pa ja, jewaꞌ kubꞌiꞌij lo che: “Minachꞌichꞌaꞌ, ma ri puerta tzꞌapil chik y oj kotzꞌol chi kukꞌ ri walkꞌoꞌal. Na utz ta kꞌu riꞌ kinyaktajik chaꞌ kiꞌnyaꞌa bꞌi chawe” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","»Kambꞌiꞌij kꞌu riꞌin chiwe: Rachi tobꞌ na kayaktaj ta lo che utoꞌik ri ramigo ruma kamigos kibꞌ, pero kutoꞌo xa ruma ri ramigo lik na xroqꞌotaj ta utzꞌonoxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","E uwariꞌche kambꞌiꞌij riꞌin chiwe: Janipa ri kajawax chiwe, chitzꞌonoj che ri Dios y kayaꞌiꞌ chiwe; chitzukuj rukꞌ Rire janipa ri kajawax chiwe y kiriqo; chichꞌaꞌbꞌej Rire y kixukajmaj loq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Ma china ri kel uchiꞌ che utzꞌonoxik, kukꞌul na; china ri kꞌo kutzukuj, kuriq na; y china ri kachꞌaw pan che ruchiꞌ ja, kajaqiꞌ na lo che. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","»¿Kꞌo nebꞌa juna achi chixoꞌl, we rukꞌajol kutzꞌonoj pam, kuya juna abꞌaj che; o we kutzꞌonoj kar, kuya juna kumatz che? ");
INSERT INTO acrNNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O kꞌo nebꞌa juna achi we rukꞌajol kutzꞌonoj saqmolobꞌ che, kuya juna sinaꞌj che? ¡Na jinta junoq! ");
INSERT INTO acrNNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ekꞌu riꞌix tobꞌ xa ix tikawex na lik ta utz ikꞌuꞌx, na rukꞌ ta kꞌu riꞌ, kiriq uyaꞌik chomilaj taq sipanik chike riwalkꞌoꞌal. ¡Makꞌuwariꞌ ri Qaqaw Dios kꞌo chilaꞌ chikaj kuya ne lo ri Santowilaj Ruxlabꞌixel chike ri ketzꞌonow re!» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","E xuꞌan waꞌ echiriꞌ ri Jesús karesaj bꞌi jun itzel uxlabꞌixel che jun achi meꞌturisam ruma ri itzel uxlabꞌixel. Ekꞌuchiriꞌ elinaq chubꞌi ri itzel uxlabꞌixel, rachi xujeq kachꞌaꞌtik. Yey taq ri winaq lik xkam kanimaꞌ che waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Pero e kꞌo jujun chike xkibꞌiꞌij: «Rire kebꞌeresaj bꞌi ri itzel uxlabꞌixel ruma ruchuqꞌabꞌ ri Beelzebú, ri kajawal ri itzel uxlabꞌixel» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Y e kꞌo chi jujun xa re kakikꞌam upa ri Jesús, kakitzꞌonoj che kuꞌan juna kꞌutubꞌal re chilaꞌ chikaj chaꞌ kaqꞌalajinik we Rire taqom lo ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Pero ri Jesús retaꞌam saꞌ ri kakichꞌobꞌo; ruma kꞌu riꞌ, xubꞌiꞌij chike: «We ri taqanelabꞌ re juna tinamit kijachom kipa ruma kechꞌoꞌjin chikiwach, riꞌ na kanajtir ta ri kitaqanik. Yey we ri ejeqelel pa juna ja kijachom kipa ruma kechꞌoꞌjin chikiwach, riꞌ na ketikiꞌ ta chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Jekꞌuriꞌlaꞌ, we ta ri Satanás kukꞌ ri itzel uxlabꞌixel kakijeq kechꞌoꞌjin chikiwach, ¿suꞌanik kꞌu riꞌ katikiꞌ rutaqanik? Kambꞌiꞌij waꞌ ma ralaq kabꞌiꞌij alaq riꞌin kebꞌenuwesaj bꞌi ri itzel uxlabꞌixel ruma ruchuqꞌabꞌ ri Beelzebú. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","»We ta e riꞌ, ¿china kayaꞌw kichuqꞌabꞌ riꞌ ri e tijoꞌn ralaq chaꞌ kekesaj bꞌi itzelilaj uxlabꞌixel? ¿Rukꞌ nawi ruchuqꞌabꞌ ritzel kakiꞌano? Tzꞌonoj kꞌu alaq riꞌ chike ri e tijoꞌn alaq we e uꞌanom riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Pero we riꞌin kebꞌenuwesaj bꞌi ri itzel uxlabꞌixel rukꞌ ruchuqꞌabꞌ ri Dios, waꞌ e kꞌutubꞌal re kꞌuninaq chi rutaqanik ri Dios chixoꞌlibꞌal alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","»We kꞌo juna achi lik kꞌo uchuqꞌabꞌ y lik kꞌo uchapabꞌal puqꞌabꞌ re kuchajij ri rocho, na jinta kꞌu kukꞌulumaj riꞌ rubꞌitaq re. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Noꞌj we xkꞌun lo junoq chik más kꞌo uchuqꞌabꞌ chwa ri rajaw ja, riꞌ kuchꞌij uchuqꞌabꞌ, kumaj kꞌu che ri rajaw ja ri chapabꞌal ri lik ukubꞌam ukꞌuꞌx rukꞌ, kukꞌam bꞌi ronoje rubꞌitaq re y kujach chike jujun chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Kambꞌiꞌij kꞌu che alaq: China ri na uꞌanom ta re wukꞌ riꞌin, riꞌ aj chꞌaꞌoj chwij. Yey china ri na katoꞌbꞌ ta wukꞌ riꞌin che kikꞌamik lo jujun chik, riꞌ e kuwulij wa chak kanꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","»Echiriꞌ juna itzelilaj uxlabꞌixel kel bꞌi rukꞌ juna tikawex, ri kuꞌano e kasutin pa taq luwar katzꞌintzꞌotik re kutzukuj pa kajeqiꞌ wi. Yey we na kuriq taj, kubꞌiꞌij kꞌu chiribꞌil ribꞌ: “Kintzelej pe chupa ri wocho, pa xinel lo wi” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Ekꞌuchiriꞌ koponik, kuꞌriqa rachi pachaꞌ juna ja mesom upa y yijbꞌital chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Keꞌek kꞌut, kebꞌuꞌkꞌama chi lo wuqubꞌ rach itzel uxlabꞌixel más itzel kiwachlibꞌal chwa rire; y konoje kꞌu riꞌ kebꞌokik y kejeqiꞌ chiriꞌ. Jekꞌuriꞌlaꞌ, rubꞌinik rachi más kayojtaj chwa ri petinaq loq» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Echiriꞌ kꞌa katajin ri Jesús che ubꞌiꞌxikil waꞌ, kꞌo jun ixoq chikixoꞌl rukꞌiyal winaq lik ko xchꞌawik, jewaꞌ xubꞌiꞌij che: —Nim uqꞌij ralaxik rixoq xyaꞌw e la chwachulew y xtzꞌumtisan e la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Noꞌj ri Jesús xubꞌiꞌij che: —Más nim kiqꞌij kalaxik ri ketaw re y kekojow re Rutzij Upixabꞌ ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Echiriꞌ ukꞌiyal winaq katajin kimolotajik rukꞌ ri Jesús, rire xujeq ubꞌiꞌxikil chike: «Ri tikawex re waqꞌij ora lik itzel kikꞌuꞌx, ma e kakitzꞌonoj kanꞌan juna kꞌutubꞌal re ruchuqꞌabꞌ ri Dios chikiwach. Noꞌj na kayaꞌtaj ta kꞌu waꞌ chike, ma xew kayaꞌtaj ri kꞌutubꞌal xꞌaniꞌ ojertan rukꞌ ri Jonás. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ma jelaꞌ pachaꞌ ri Jonás xoluꞌana jun kꞌutubꞌal chikiwach ri aj Nínive, jekꞌuriꞌlaꞌ Ralaxel Chikixoꞌl Tikawex koluꞌana jun kꞌutubꞌal chikiwach ri tikawex re waqꞌij ora. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","»Echiriꞌ kopon ri qꞌij re qꞌatbꞌal tzij, kayaktaj lo ri reina re pa sur y kukoj kimak ri tikawex re waqꞌij ora. Ma rojertan lik naj petinaq wi rire chaꞌ koluꞌxikinaj runaꞌoj ri rey Salomón. Noꞌj ri tikawex re waqꞌij ora, kꞌo jun chikixoꞌl más kꞌo uwach chwa ri Salomón, yey na kebꞌok tane il che. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","»Jekꞌulaꞌ ri winaq aj Nínive re ojertan keyaktaj chupa ri qꞌij re qꞌatbꞌal tzij y kakikoj kimak ri tikawex re waqꞌij ora. Ma rike xkitzelej kitzij chwach ri Dios ruma ri tzijonik xuꞌan ri Jonás chikiwach. Noꞌj ri tikawex re waqꞌij ora, kꞌo jun chikixoꞌl más kꞌo uwach chwa ri Jonás, yey na kebꞌok tane il che. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","»Na jinta junoq echiriꞌ kutzij juna aqꞌ, keꞌrewaj lo chupa juna luwar pa na qꞌalaj ta wi. Na kuchꞌuq tane uwiꞌ rukꞌ juna mulul re pajbꞌal; ri kuꞌan che, e kuya lo chupa rukꞌolibꞌal chikaj chaꞌ jelaꞌ kutzij kiwiꞌ ri kebꞌok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","»Ri qawach e pachaꞌ candil re ri qacuerpo, ma ruma waꞌ kojtzuꞌnik chaꞌ utz kojbꞌinik. Jekꞌulaꞌ, we ri qawach lik utz uꞌanom, ronoje ri qacuerpo nojinaq che qꞌijsaq y kaqil kꞌu ronoje chi utz. Noꞌj we ri qawach na utz taj, ronoje ri qacuerpo kꞌo pa qꞌequꞌm. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","»Lik kꞌu chajij ibꞌ alaq; e mabꞌiꞌij alaq: “Oj kꞌo pa qꞌijsaq”, yey na kanaꞌbꞌej ta alaq pa qꞌequꞌm kꞌo wi alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Noꞌj we paqatzij wi kꞌo chi alaq pa qꞌijsaq y na jinta chi re ri qꞌequꞌm che alaq, riꞌ ronoje kaqꞌalajin chiwach alaq jelaꞌ pachaꞌ juna candil kutzij ri bꞌe alaq rukꞌ ruwonibꞌal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ekꞌuchiriꞌ ri Jesús xukꞌis kakꞌutunik, xsikꞌix ruma jun fariseo chaꞌ keꞌwoꞌqa chirocho. Ri Jesús xeꞌek, xok kꞌu chupa ri ja y xtzꞌuyiꞌ chwa ri mexa. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Echiriꞌ xril waꞌ ri fariseo, lik xkam ranimaꞌ che ma na xuchꞌaj ta nabꞌe ruqꞌabꞌ jelaꞌ pachaꞌ kakiꞌan che ri kijosqꞌikil ri fariseos. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ekꞌu ri Qanimajawal jewaꞌ xubꞌiꞌij che: —Ralaq alaq fariseos lik kok alaq il che ri kachꞌaj alaq chi utz ri rij ri vaso y ri laq pero na kok ta alaq il che uchꞌajik rupa. Jekꞌuriꞌlaꞌ ralaq lik kok alaq il che ri josqꞌinik re ri cuerpo, pero lik nojinaq ri animaꞌ alaq che rayinik y che ri na utz taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","»¡Lik na jinta kꞌana naꞌoj alaq! Ri Jun xꞌanaw re ri kilitaj che ri cuerpo alaq, ¿na e ta nebꞌa ri xꞌanaw re ri animaꞌ alaq? ");
INSERT INTO acrNNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","We paqatzij wi kaꞌaj alaq kuꞌan chom ri bꞌinik silabꞌik alaq chwach ri Qaqaw, sipan alaq chike ri nibꞌaꞌibꞌ rukꞌ ri kꞌo ukꞌ alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","»¡Lik toqꞌoꞌ wach ralaq alaq fariseos! Lik kok alaq il che jujun tzijpixabꞌ, ma kaya alaq che ri Dios ri diezmo re ri arweno, re ri ruda y re ronoje ichaj; noꞌj na kaꞌan ta alaq ri lik usukꞌ y na kꞌax ta kanaꞌ alaq ri Dios. Yey ri lik chirajawaxik wi e kaꞌan alaq ri usukꞌ y kꞌax kanaꞌ alaq ri Dios, junam rukꞌ ri kaya alaq ri diezmo alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","»¡Lik toqꞌoꞌ wach ralaq alaq fariseos, ri lik kaꞌan nim che ibꞌ alaq! Ma lik kukꞌul kꞌuꞌx alaq ri katzꞌuyiꞌ alaq pa taq sinagogas chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach y lik kukꞌul kꞌuꞌx alaq ri kayaꞌ rutzil wach alaq pa kilitaj wi alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","»¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ y alaq fariseos! Xa kebꞌ palaj alaq, ma e kechꞌulaj alaq ri winaq rukꞌ ri kakꞌut alaq. Pachaꞌ alaq muqubꞌal ke animaꞌ na kilitaj taj; ekꞌu ri winaq kebꞌikꞌow puwiꞌ y na kakinaꞌbꞌej taj rukꞌ waꞌ kakichꞌulaj kibꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Ekꞌuchiriꞌ, jun chike ri e aj kꞌutunel re ri tzijpixabꞌ jewaꞌ xubꞌiꞌij che ri Jesús: —Lal tijonel, echiriꞌ kabꞌiꞌij la waꞌ, oj jun riꞌoj kojyaj la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ri Jesús xubꞌiꞌij: «¡Lik toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ! Lik kaꞌan alaq kꞌax chike ri winaq rukꞌ ri taqanik alaq. Ma wa taqanik alaq e pachaꞌ nimaq taq eqaꞌn lik al y lik kꞌayew rukꞌaxik; ketaq kꞌu alaq ri winaq chaꞌ kakeqaj bꞌi yey ralaq na kaꞌaj tane alaq katoꞌbꞌ kꞌana alaq rukꞌ waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","»¡Lik toqꞌoꞌ wach alaq! Ma kayak alaq chomilaj muqubꞌal chike ri qꞌalajisanelabꞌ xekamisax kuma ri mam alaq ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Rukꞌ ri kaꞌan alaq kaqꞌalajisaj alaq junam tzij alaq kukꞌ ri mam alaq. Ma rike na xkikꞌul ta ri e qꞌalajisanelabꞌ y xekikamisaj; jenelaꞌ ralaq na kata ta alaq ri kitzij tzꞌibꞌital kanoq, tobꞌ kayijbꞌaꞌ alaq riꞌ ri kimuqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","»E uwariꞌche ri Dios, ri lik kꞌo saqil naꞌoj rukꞌ, jewaꞌ kubꞌiꞌij: “Kebꞌenutaq bꞌi e qꞌalajisanelabꞌ y e taqoꞌn chikiwach wa tikawex. Y chike kꞌu waꞌ wa aj chak weꞌin, kꞌo ri kekikamisaj y kꞌo ri kekiternabꞌej rukꞌ kꞌax” kacha ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ekꞌu uwariꞌche, ri alaq tikawex re waqꞌij ora, pawiꞌ alaq kꞌo wi ri kikikꞌel ri qꞌalajisanelabꞌ ekamisam chwi lo ri jeqebꞌal re ruwachulew, ");
INSERT INTO acrNNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","chwi lo rukamik ri Abel kꞌa chwa rukamik ri Zacarías, ri xkamisax chuxoꞌl raltar y ri Rocho Dios. Paqatzij wi kambꞌiꞌij che alaq, ri Dios kuqꞌat tzij pawiꞌ alaq ruma ri kikamik rike. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","»¡Toqꞌoꞌ wach ralaq alaq aj kꞌutunel re ri tzijpixabꞌ! Ma alaq latzꞌanel chike ri kakaj kaketaꞌmaj ri Qꞌijsaq. Ewam alaq rusukꞌ Rutzij Upixabꞌ ri Dios, jekꞌulaꞌ na kok ta alaq pa ri Qꞌijsaq yey na kaya tane alaq luwar chike ri winaq kebꞌokik» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Echiriꞌ ri Jesús katajin che ubꞌiꞌxikil waꞌ chike, raj kꞌutunel re ri tzijpixabꞌ y ri fariseos lik xpe koyowal chirij y xkijeqo kakichapalaꞌ rukꞌ ukꞌiyal tzꞌonobꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Lik xkitij riꞌ che chaꞌ rire kubꞌiꞌij ri na usukꞌ taj y rukꞌ waꞌ kakikoj umak. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Katajin kimolotajik ukꞌiyal winaq na jinta chi kitaqexik, y ruma waꞌ lik kakiminimaꞌ kibꞌ chikiwach. Ekꞌuchiriꞌ, ri Jesús xujeqo kakꞌutunik; nabꞌe xujeq kachꞌaꞌt kukꞌ rutijoꞌn, jewaꞌ xubꞌiꞌij chike: «Lik miꞌan iwe pachaꞌ ri kakiꞌan ri fariseos, ma rike xa kebꞌ kipalaj. Jelaꞌ pachaꞌ ri levadura kojotal chupa ri qꞌor re pam yey waꞌ na kilitaj taj, jekꞌulaꞌ ri fariseos kewam ri na utz taj pa kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Noꞌj kopon ri qꞌij echiriꞌ ronoje ri chꞌuqutal uwiꞌ woꞌora, kel lo chi saq; yey ronoje ri kaꞌan xa xeꞌlaqꞌay, ketaꞌmaxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","E uwariꞌche kopon ri qꞌij echiriꞌ janipa ri ibꞌiꞌim riꞌix pa qꞌequꞌm, kel lo chi qꞌij saq; yey e ri xa iwesewoꞌm pa juna ja, kesax utzijolal pa taq bꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","»Kambꞌiꞌij kꞌu chiwe riꞌix ix wamigos: Mixiꞌij iwibꞌ chikiwach ri kꞌo pakiqꞌabꞌ kixkikamisaj, ma waꞌ xew che ri cuerpo kakiꞌan wi; yey echiriꞌ ix kaminaq chik, na jinta chi kakiꞌan chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Kambꞌiꞌij kꞌu chiwe china chwach chirajawaxik wi kixiꞌij iwibꞌ: E chixiꞌij iwibꞌ chwach ri Jun kꞌo puqꞌabꞌ karesaj rikꞌaslemal riꞌix y tekꞌuchiriꞌ kixukꞌaq bꞌi chi xibꞌalbꞌaꞌ re tijbꞌal kꞌax. Paqatzij wi e chixiꞌij iwibꞌ riꞌ chwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","»Iwetaꞌam woꞌobꞌ raltaq ko tzꞌikin kekꞌayix xa chwa kebꞌ oxibꞌ raltaq ko meyo. Na rukꞌ ta kꞌu riꞌ, ri Dios na kumeskꞌutaj ta kꞌana junoq chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Makꞌuwariꞌ riꞌix na kixumeskꞌutaj ta kꞌenoq, ma chujujunal ne riwiꞌ ajilam ruma Rire. E uwariꞌche, mixiꞌij iwibꞌ; ma riꞌix más kꞌo iwach chikiwa ri raltaq ko tzꞌikin. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","»Paqatzij wi kambꞌiꞌij chiwe: E junoq kuqꞌalajisaj chikiwach ri winaq, kubꞌiꞌij: “In tijoꞌn re ri Jesús”, jekꞌuriꞌlaꞌ kanꞌan riꞌin che rire; ri in Alaxel Chikixoꞌl Tikawex kambꞌiꞌij chikiwach ri ángeles re ri Dios: “Qatzij, wa jun e nutijoꞌn” kinchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Noꞌj kꞌu ri kubꞌiꞌij chikiwach ri winaq: “Riꞌin na in ta tijoꞌn re ri Jesús”, jekꞌuriꞌlaꞌ kanꞌan riꞌin che rire; kambꞌiꞌij chikiwach ri ángeles re ri Dios: “Qatzij, wa jun na nutijoꞌn taj” kinchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","»We kꞌo junoq kachꞌaꞌt chwij riꞌin, ri in Alaxel Chikixoꞌl Tikawex, ri Dios kukuy umak we kutzelej utzij. Noꞌj china ri tzel kachꞌaꞌt chirij ri Santowilaj Ruxlabꞌixel ri Dios, riꞌ na kakuytaj ta umak. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","»Mixiꞌij iwibꞌ echiriꞌ wuma riꞌin kixkꞌam bꞌi chikiwach raj wach re ri sinagogas o chikiwach raj qꞌatal tzij y raj wach re ri tinamit; mubꞌisoj ne ikꞌuꞌx saꞌ ri kꞌulubꞌal uwach kiꞌan chike, ");
INSERT INTO acrNNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ma ri Santowilaj Ruxlabꞌixel ri Dios kuqꞌalajisaj chiwe saꞌ ri chirajawaxik kibꞌiꞌij» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ekꞌuchiriꞌ, jun chike rukꞌiyal winaq xubꞌiꞌij che ri Jesús: —Lal tijonel, bꞌiꞌij la che ri watz kuya ri taqal chwe riꞌin che taq ri kuxtabꞌal kiyaꞌom kan ri qachu-qaqaw —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Ekꞌu ri Jesús xukꞌul uwach: —Achi, ¿china inkojoyom re in aj qꞌatal tzij pawiꞌ alaq chaꞌ kanꞌan wa jachanik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Tekꞌuchiriꞌ, xubꞌiꞌij chike ri winaq: —Tape alaq, lik chajij ibꞌ alaq chi utz chwach ronoje rayinik, ma na e ta rubꞌeyomalil rachi ri kuya chomilaj kꞌaslemal che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ekꞌuchiriꞌ xutzijoj wa jun kꞌambꞌal naꞌoj chike: «Kꞌo jun achi lik bꞌeyom yey ri rulew lik ukꞌiyal molonik xuyaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ekꞌu ri bꞌeyom xuchꞌobꞌ raqan chiribꞌil ribꞌ: “¿Saꞌ kanꞌano? Ma na jinta chi pa kankꞌol wi wuꞌkꞌiyal molonik xinꞌano.” ");
INSERT INTO acrNNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","»Tekꞌuchiriꞌ xubꞌiꞌij chiribꞌil ribꞌ: “E kanꞌan waꞌ: Kanwulij taq wa kꞌolibꞌal nuꞌanom re molonik y kanyak jujun chik más nimaꞌq, chaꞌ chupa kankꞌol wi ri numolonik y taq ri nubꞌeyomalil. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Y kambꞌiꞌij kꞌu riꞌ chiwibꞌil wibꞌ: Riꞌin lik kꞌi chi ri nubꞌeyomalil kꞌoltalik, waꞌ kukuy re ukꞌiyal junabꞌ. Ekꞌu woꞌora utz kinuxlanik, kinwaꞌik, kantij nuyaꞌ y kanꞌan ronoje ri kuaj riꞌin.” ");
INSERT INTO acrNNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","»Noꞌj ri Dios xubꞌiꞌij che: “Achi, lik na jinta kꞌana anaꞌoj. ¡Toqꞌoꞌ awach! Ma e waqꞌabꞌ katkamik; yey ronoje kꞌu rabꞌeyomalil akꞌolom, ¿china re kanoq?” xuchixik. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","»Jekꞌuriꞌlaꞌ kukꞌulumaj juna achi we kukꞌol ukꞌiyal bꞌeyomalil xa riꞌre, pero chwach ri Dios lik nibꞌaꞌ» xcha ri Jesús chike ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Tekꞌuchiriꞌ xubꞌiꞌij ri Jesús chike rutijoꞌn: «E uwariꞌche kambꞌiꞌij waꞌ chiwe: Mubꞌisoj ikꞌuꞌx rikꞌaslem; mubꞌisoj ne ikꞌuꞌx saꞌ ri kitijo y saꞌ riqꞌuꞌ kikojo. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ma ri qakꞌaslemal e más kꞌo uwach chwa ri qawa, yey ri qacuerpo e más kꞌo uwach chwa ri qaqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","»Chebꞌiwilape ri joj. Rike na ketikoꞌnaj taj, na kakiꞌan tane kimolonik, na jinta ne pa kakikꞌol wi ri kimolonik; na rukꞌ ta kꞌu riꞌ ri Dios kebꞌutzuqu. ¡Makꞌuwariꞌ riꞌix, ri Dios kixuchajij! ¡Ma e más kꞌo iwach riꞌix chikiwa ri tzꞌikin! ");
INSERT INTO acrNNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","»¿Kꞌo nebꞌa junoq chiwe riꞌix kuriq kunajtirisaj jun chik qꞌij che rukꞌaslem wara che ruwachulew? Na jinta junoq tobꞌ ne lik kutij uqꞌij che. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ruma kꞌu riꞌ, na jinta kutiqoj we lik kubꞌisoj ikꞌuꞌx ri kajawax chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","»Chiwilapeꞌ suꞌanik kakꞌiy ri kotzꞌiꞌj pa taq juyubꞌ. Waꞌ na kachakun taj y na kakeman ta nenareꞌ chaꞌ kuꞌan ruqꞌuꞌ. Yey riꞌin kambꞌiꞌij chiwe: Ri rey Salomón, tobꞌ lik kꞌo uchomal ruqꞌuꞌ xukojo, waꞌ na xumaj ta kꞌana ruchomalil taq ri kotzꞌiꞌj. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Jekꞌulaꞌ we ri Dios uꞌanom chom che ri aqꞌes kꞌo waqꞌij pa juyubꞌ yey chweꞌq xa kaporox pa aqꞌ, ¿na kuya ta kami riꞌ ri Dios riqꞌuꞌ kajawax chiwe? ¡Riꞌix lik xa jubꞌiqꞌ ri kubꞌulibꞌal ikꞌuꞌx rukꞌ ri Dios! ");
INSERT INTO acrNNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","»Kambꞌiꞌij kꞌu chiwe riꞌix: Mubꞌisoj ikꞌuꞌx saꞌ riwa y saꞌ rimiqꞌinaꞌ kitijo. Mapax ne ikꞌuꞌx che, ");
INSERT INTO acrNNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ma jenelaꞌ kakiꞌan ri winaq na ketaꞌam ta uwach ri Dios, e kubꞌisoj kikꞌuꞌx taq waꞌ. Noꞌj riꞌix kꞌo jun Iqaw lik retaꞌam kajawax taq waꞌ chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Ri lik chirajawaxik chiwe e lik chixok il che rutaqanik ri Dios; yey ronoje taq kꞌu ri kajawaxik, xa uwiꞌ chik kayaꞌtaj chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","»Riꞌix ix nutijoꞌn, muxiꞌij ribꞌ ikꞌuꞌx che rikꞌaslem, ma riꞌix tobꞌ na ix ta kꞌi, ri Qaqaw lik kakiꞌkot che kuya chiwe riꞌix kixok chupa rutaqanik y kixtaqan rukꞌ Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chikꞌayij ri bꞌeyomalil kꞌo iwukꞌ chaꞌ utz kebꞌitoꞌ ri nibꞌaꞌibꞌ. Ma we kiꞌan waꞌ, e pachaꞌ kikꞌol ribꞌeyomalil pa na jinta kꞌo kukꞌulumaj wi y jelaꞌ kꞌo kutiqoj chiwe chilaꞌ chikaj. Ma e taq ri kꞌo chilaꞌ chikaj na kajar taj, na kapokꞌir taj, yey na jinta ne eleqꞌomabꞌ kebꞌok che. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Ma pa kꞌo wi ribꞌeyomalil riꞌix, puwi waꞌ keꞌek wi ikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","»Lik chiyijbꞌaꞌ iwibꞌ, pachaꞌ raj chakibꞌ kiyijbꞌam kibꞌ chi utz y tzijtal ri kicandil, ");
INSERT INTO acrNNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ma koyeꞌem ri kajaw katzelej lo pa ri nimaqꞌij re kꞌulanikil. Y jelaꞌ echiriꞌ rire kakꞌunik y kachꞌaw pan chwa ri puerta, kakijaqalaꞌ tan lo che. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Nim kiqꞌij kalaxik raj chakibꞌ we xkꞌun lo ri kajaw, kebꞌoluꞌriqaꞌ na kewar taj. Paqatzij wi kambꞌiꞌij chiwe, ri kajaw kebꞌukoj chwa mexa y kebꞌunimaj chikijujunal. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Lik nim kiqꞌij kalaxik raj chakibꞌ, tobꞌ ri kajaw xmayinik, we xkꞌun lo pa tikꞌil aqꞌabꞌ o pa saqribꞌal, kebꞌoluꞌriqaꞌ na kewar taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ekꞌu chiwetaꞌmaj waꞌ: Juna achi rajaw ja, we ta karetaꞌmaj ri ora echiriꞌ kopon releqꞌom, riꞌ na kawar ta kꞌenoq y na kuya ta luwar karaqix ri rocho re kaꞌan eleqꞌ chupa. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Jekꞌulaꞌ riꞌix chiyijbꞌaꞌ iwibꞌ che rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex, ma kꞌaxtaj kakꞌunik echiriꞌ na jinta inaꞌbꞌem» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Ekꞌuchiriꞌ, ri Pedro xutzꞌonoj che ri Jesús: —Qajawal, ¿xew chiqe riꞌoj kabꞌiꞌij la wa kꞌambꞌal naꞌoj o chike konoje ri winaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Ekꞌu ri Qanimajawal xukꞌul uwach: «¿Chinoq chiwe riꞌix e pachaꞌ juna aj chak lik jusukꞌ y kꞌo unaꞌoj, yaꞌtal puqꞌabꞌ kebꞌutzuq chupa ruꞌorayil konoje ri e kꞌo pa rocho rupatrón? ");
INSERT INTO acrNNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Lik kꞌu nim uqꞌij ralaxik riꞌ ri aj chak, we xkꞌun lo rupatrón, koluꞌriqaꞌ katajin che uꞌanik ruchak. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Paqatzij wi kambꞌiꞌij chiwe: Rupatrón kuꞌana taqanel che rire puwi ronoje rubꞌitaq re. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","»Noꞌj we waꞌ wa jun aj chak jewaꞌ kubꞌiꞌij pa ranimaꞌ: “Ri nupatrón kꞌamajaꞌ katzelej loq” y kujeq kꞌu lik kebꞌuchꞌay raj chakibꞌ chi achijabꞌ chi ixoqibꞌ; yey ekꞌu rire xew kawaꞌik y kaqꞌabꞌarik, ¿saꞌ nawi riꞌ ri kaꞌan che? ");
INSERT INTO acrNNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Kakꞌun lo riꞌ rupatrón chupa ri qꞌij y ri ora echiriꞌ waꞌ wa aj chak na royeꞌem taj. Kuqꞌat kꞌu tzij puwi ri raj chak y lik kuya pa kꞌax junam kukꞌ konoje ri na e ta jusukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","»Ekꞌu juna aj chak, we retaꞌam saꞌ ri karaj rupatrón pero na kukoj ta utzij y na kuꞌan ta ri bꞌiꞌim che, riꞌ lik kaꞌan kꞌax che. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Noꞌj juna aj chak kuꞌan ri na utz taj yey na retaꞌam ta kꞌut we na utz ta ri kuꞌano, riꞌ na lik ta kꞌax kaꞌan che. Ma china ri lik kꞌo yaꞌtal chuqul, chiqawach apanoq lik kꞌo royeꞌem ri Dios che; yey china ri lik kꞌi yaꞌtal puqꞌabꞌ, más ne royeꞌem ri Dios che chwa ri royeꞌem che ri jun na lik ta kꞌi ri yaꞌtal puqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","»Pachaꞌ aqꞌ ri koꞌlnukiqꞌa che ruwachulew. ¡Ekꞌu ri kanrayij riꞌin ta asu kumaj aqꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Lik kꞌu chirajawaxik kinikꞌow na chupa jun unimal kꞌaxkꞌobꞌik. ¡Na kikꞌow ta ri bꞌis chinukꞌuꞌx, kꞌa echiriꞌ kinikꞌow chupa waꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","E chiwach riꞌix, ¿ri nukꞌunik che ruwachulew kukꞌam lo utzil chomal? Na e ta riꞌ. Ma paqatzij wi kambꞌiꞌij e kukꞌam lo jachbꞌal kipa taq ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Chwi woꞌora y chiqawach apanoq we e kꞌo woꞌobꞌoq pa juna ja, wuma riꞌin kꞌo pa saq kakijach kipa; ma oxibꞌ kechꞌoꞌjin kukꞌ kaꞌibꞌ y kaꞌibꞌ kechꞌoꞌjin kukꞌ oxibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Kechꞌoꞌjin chikiwach rachi rukꞌ rukꞌajol, rixoq rukꞌ ri ralit y ruchu-ralibꞌ rukꞌ ralibꞌatz» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yey xubꞌiꞌij ri Jesús chike rukꞌiyal winaq: «Echiriꞌ kil alaq ri sutzꞌ kel lo puqajibꞌal ri qꞌij, xew kil alaq y kabꞌiꞌij alaq: “Kape jabꞌ” y e kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Y echiriꞌ kajum kaꞌn ri tew kape lo pa sur, kabꞌiꞌij alaq: “Lik kuꞌan bꞌuk” y e kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Xa kebꞌ palaj alaq! Kariq alaq uchꞌobꞌik chi utz saꞌ ruꞌanom ruwa kaj y ruwachulew; ¿suꞌchak kꞌu riꞌ na kamaj tane alaq usukꞌ ri katajin ri Dios che ukꞌutik chiwach alaq waqꞌij ora? ");
INSERT INTO acrNNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","»¿Suꞌchak na kachꞌobꞌ ta alaq chi utz saꞌ ri lik usukꞌ chirajawaxik kaꞌan alaq? ");
INSERT INTO acrNNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","We kakꞌam bꞌi la pa qꞌatbꞌal tzij ruma junoq ukojom mak chiꞌij la, e lik utz ri kaꞌan la utzil chomal rukꞌ pa bꞌe xaloqꞌ kꞌamajaꞌ kopon la chwa ri aj qꞌatal tzij. Ma we na xꞌan ta la waꞌ, kopon na la chwach ri aj qꞌatal tzij. Y we xopon kꞌu la chwach rire, kayaꞌ bꞌi la puqꞌabꞌ ri ausiliar y rire kuꞌyaꞌa la pa cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Kambꞌiꞌij kꞌut, na kel ta lo la chiriꞌ we na xtoj ta kan la ronoje ri tzꞌonom chiꞌij la» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Chupa waꞌ wa qꞌij e kꞌo jujun chiriꞌ xkitzijoj che ri Jesús saꞌ ri xkikꞌulumaj jujun aj Galilea, ri xekamisax ruma utzij ri taqanel Pilato echiriꞌ ketajin che uyaꞌik ri kiqasaꞌn re chikop chwa ri altar pa ri Rocho Dios. Yey ri kikikꞌel waꞌ wa aj Galilea xkich kaꞌn puwi ri kikikꞌel ri chikop. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Ekꞌu ri Jesús xukꞌul uwach: —¿E kachꞌobꞌ nawi alaq, waꞌ wa aj Galilea xekamisaxik ma e más e aj makibꞌ chikiwa ri kach aj Galilea? ");
INSERT INTO acrNNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Paqatzij wi kambꞌiꞌij che alaq, na e ta riꞌ. Yey ralaq, we na katzelej ta tzij alaq chwach ri Dios, e ne jun ralaq kasach wach alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","»¿O saꞌ nawi kachꞌobꞌ alaq puwi ri xkikꞌulumaj ri e dieciocho, ri xekamik echiriꞌ xtzaq lo ri Torre re Siloé pakiwiꞌ? ¿E kachꞌobꞌ nawi alaq, wa winaq xekamik ma kꞌo más kimak chikiwa ri kach aj Jerusalem? ");
INSERT INTO acrNNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Paqatzij wi kambꞌiꞌij che alaq, na e ta riꞌ. Yey ne ralaq, we na katzelej ta tzij alaq chwach ri Dios, e ne jun ralaq kasach wach alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Xutzijoj kꞌu wa jun kꞌambꞌal naꞌoj chike: «Kꞌo jun achi utikom jun cheꞌ re higo chupa rutikoꞌn. Xkꞌun kꞌu loq re koluꞌtzukuj ujiqꞌobꞌalil ri higo yey na jinta xuriq che. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Xubꞌiꞌij kꞌu che ri chajinel re rutikoꞌn: “Chawilapeꞌ, e urox junabꞌ waꞌ kinkꞌunik koꞌlnutzukuj ujiqꞌobꞌalil wa cheꞌ re higo, yey na jinta kꞌana ujiqꞌobꞌalil kanriqo. Woꞌora chacheta bꞌi ma ¿saꞌ kutiqoj kꞌo chupa waꞌ wuꞌlew?” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ekꞌu ri chajinel xubꞌiꞌij che: “Wajaw, yaꞌa chi la wa junabꞌ che, ma kantij chi na uqꞌij kankꞌot rij y kankoj abono chuxeꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Kꞌaxtaj kuya ujiqꞌobꞌalil; noꞌj we na xuya taj, kꞌa ekꞌuchiriꞌ utz kachet bꞌi” xchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Pa jun qꞌij re uxlanibꞌal ri Jesús kakꞌutun chupa jun sinagoga. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Kꞌo kꞌu jun ixoq chiriꞌ e dieciocho lo junabꞌ riꞌ lik kꞌuyukꞌik uꞌanom ri rij ruma jun itzel uxlabꞌixel, yey na utz ta ne kusukꞌupij ribꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Y ri Jesús echiriꞌ xril rixoq, xusikꞌij apanoq y jewaꞌ xubꞌiꞌij che: —Ixoq, lal kunutajinaq chi che ri yabꞌil kꞌo wi la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Y xuya ruqꞌabꞌ puwi rixoq; y chupa kꞌu laꞌ la joqꞌotaj rixoq xsukꞌupitajik y xujeqo kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ekꞌu ri taqanel re ri sinagoga lik xpe royowal chirij ri Jesús ma xkunan chupa ri qꞌij re uxlanibꞌal, y xubꞌiꞌij kꞌu chike ri winaq: —Kꞌo waqibꞌ qꞌij re chak; chupa waꞌ utz kape alaq re kakunax bꞌi alaq, pero lik na ubꞌe taj kakunax alaq chupa ri qꞌij re uxlanibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ekꞌu ri Jesús xubꞌiꞌij: —¡Xa kebꞌ palaj alaq! Onoje ralaq ¿na kakir ta nebꞌa alaq ri bꞌoyex y ri buru chupa ri qꞌij re uxlanibꞌal chaꞌ kakꞌam bꞌi alaq chi tijoj yaꞌ? Kaꞌan ne alaq waꞌ chike yey xa e awaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Makꞌuwariꞌ taqal che wiꞌxoq katoꞌik, ma rire ralkꞌoꞌal kan ri Abraham, yey e dieciocho lo junabꞌ waꞌ “yututal” ruma ri Satanás. ¿Na utz ta kami riꞌ kesax chupa ri yabꞌil pa ri qꞌij re uxlanibꞌal? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Echiriꞌ xubꞌiꞌij waꞌ ri Jesús, lik xekꞌix konoje ri tzel kebꞌilow re; noꞌj konoje ri winaq lik kekiꞌkot ruma ri kꞌutubꞌal re runimal uchuqꞌabꞌ ri Dios kuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Ekꞌuchiriꞌ, xubꞌiꞌij tanchi ri Jesús: «¿Saꞌ rukꞌ kajunimax wi rutaqanik ri Dios? ");
INSERT INTO acrNNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Riꞌin kanjunimaj rukꞌ juna ijaꞌ re moxtasa, ri xkꞌam bꞌi ruma jun achi y xtikiꞌ chupa ri werta. Ekꞌu riꞌ waꞌ xkꞌiyik y lik xuꞌan bꞌojobꞌik; yey ri tzꞌikin kexikꞌikꞌ che ruwa kaj xkiꞌan kisok puwi taq ruqꞌabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Y xubꞌiꞌij tanchi ri Jesús: «¿Saꞌ rukꞌ kanjunimaj wi rutaqanik ri Dios? ");
INSERT INTO acrNNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","E jelaꞌ pachaꞌ ri levadura, ma echiriꞌ juna ixoq kuꞌan pam, kutuk jubꞌiqꞌ levadura xoꞌlibꞌal oxibꞌ pajbꞌal harina y ri levadura kusipowirisaj upa ronoje ri qꞌor» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Echiriꞌ ri Jesús kꞌo chi bꞌe re keꞌek Jerusalem, xikꞌow pa taq tinamit y pa taq aldeas, e riꞌ kakꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Y kꞌo kꞌu jun xbꞌiꞌn che: —Wajawal, ¿xa nawi jujun ri kekolobꞌetajik? —xcha che. Y ri Jesús xukꞌul uwach: ");
INSERT INTO acrNNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","«Lik chichꞌikikej iwibꞌ chaꞌ kixok chupa ri nutaqanik che ri okibꞌal xa chꞌutiꞌn uwach, ma kambꞌiꞌij chiwe: Kopon na ri qꞌij echiriꞌ lik e kꞌi ri kakaj kebꞌok bꞌi, noꞌj na kayaꞌtaj ta chike kebꞌok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","»Ma e kuꞌana pachaꞌ ri rajaw juna ja echiriꞌ kuꞌan juna nimaqꞌij. Echiriꞌ ebꞌokinaq chi konoje ri ebꞌusikꞌim, kutzꞌapij lo ri puerta, y na jinta chi kꞌu junoq kokik. Jekꞌulaꞌ riꞌ ri kikꞌulumaj riꞌix, na kixok ta chubꞌi. Kijeq kꞌu riꞌ kixchꞌaw apanoq: “Qajaw, Qajaw, yaꞌa ko la chiqe kojok bꞌi” kixchaꞌ. »Yey Rire jekꞌuwaꞌ kukꞌul lo uwach chiwe: “Riꞌin na wetaꞌam taj pa ix petinaq wi riꞌix” kacha chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","»Ekꞌuchiriꞌ, kijeq ubꞌiꞌxik: “Oj waꞌ kꞌu woꞌqinaq ukꞌ la yey xkꞌutun ne la pa taq ri bꞌe re ri qatinamit” kixcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","»Noꞌj Rire kubꞌiꞌij lo chiwe: “Paqatzij wi, riꞌin na wetaꞌam taj pa ix petinaq wi riꞌix. Chixela chinuwach, iwonoje ri ix ꞌanal re ri lik itzel uwach” kacha chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","»Ekꞌuchiriꞌ, lik kixoqꞌik y kaqichꞌichꞌ ruwi iweꞌ echiriꞌ kebꞌiwil ri Abraham, ri Isaac y ri Jacob kukꞌ konoje ri qꞌalajisanelabꞌ e kꞌo rukꞌ ri Qaqaw pa rutaqanik chilaꞌ chikaj; yey ekꞌu riꞌ riꞌix na jinta piqꞌabꞌ kixok bꞌi kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Noꞌj e kꞌo ri na e ta aj judiꞌabꞌ e petinaq pa relebꞌal lo ri qꞌij, putzaqibꞌal ri qꞌij y pa ronoje luwar che ruwachulew, riꞌ kebꞌok chwa ri mexa pa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","»Chiwilape kꞌu riꞌ, ma e kꞌo jujun chike ri na jinta kiwach wara che ruwachulew, e lik kakꞌojiꞌ kiwach chwach ri Dios chilaꞌ chikaj; yey e kꞌo ri lik kꞌo kiwach wara che ruwachulew, e kuꞌana na jinta kiwach chwach ri Dios chilaꞌ chikaj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Chupa kꞌu waꞌ wa qꞌij xeqibꞌ jujun fariseos rukꞌ ri Jesús y jewaꞌ xkibꞌiꞌij che: —Chelubꞌi la y oj la ma ri rey Herodes karaj kukamisaj la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Y ri Jesús xubꞌiꞌij chike: —Oj alaq y jeꞌbꞌiꞌij alaq che laꞌ laꞌchi, ri e pachaꞌ juna yak: “Waqꞌij y chweꞌq kꞌa kebꞌenuwesaj bꞌi ri itzel uxlabꞌixel y kanꞌan kunanik yey kabꞌij kꞌut kankꞌis ri nuchak” kacha alaq che. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Pero che kꞌu woꞌxibꞌ qꞌij chirajawaxik wi kambꞌinibꞌej pan nubꞌe kinꞌek, ma na taqal ta che juna qꞌalajisanel kakam kꞌa naj che Jerusalem —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Tekꞌuchiriꞌ xubꞌiꞌij: «¡Jerusalem, Jerusalem, riꞌix kebꞌikamisaj ri qꞌalajisanelabꞌ y kebꞌiꞌan paꞌbꞌaj janipa ri ebꞌutaqom lo ri Dios iwukꞌ! E riꞌin ukꞌiyal laj lik xuaj xinmol kichiꞌ riwalkꞌoꞌal riꞌix jelaꞌ pachaꞌ kuꞌan juna atiꞌ akꞌ chike taq ruwiꞌch echiriꞌ kumol kichiꞌ chuxeꞌ taq ruxikꞌ, noꞌj riꞌix na xiwaj ta kꞌenoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","»Chitape kꞌut, kꞌo jun qꞌij echiriꞌ ri iwocho riꞌix kawulix kanoq. Kambꞌiꞌij kꞌu chiwe na kiwil ta chi nuwach kꞌa echiriꞌ kopon na ruqꞌijol kibꞌiꞌij: Lik nim uqꞌij ri jun petinaq chupa rubꞌiꞌ ri Dios Qajawxel kixchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","E xuꞌan waꞌ chupa jun qꞌij re uxlanibꞌal: Ri Jesús xsikꞌix ruma jun fariseo lik kꞌo uwach chaꞌ keꞌwoꞌq chirocho. Y chilaꞌ e kꞌo jujun chike ri fariseos lik kikꞌakꞌalem we ri Jesús kakunan pa ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma chiriꞌ chwach Rire kꞌo jun achi lik yewaꞌ, waꞌlijinaq rucuerpo. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Ekꞌuchiriꞌ, ri Jesús xutzꞌonoj chike ri fariseos y raj kꞌutunel re ri tzijpixabꞌ, jewaꞌ xubꞌiꞌij: —¿Ubꞌe nawi ri kaꞌan kunanik chupa ri qꞌij re uxlanibꞌal o na ubꞌe taj? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Pero rike na jinta xkikꞌulubꞌej uwach. Ekꞌu ri Jesús xuya ruqꞌabꞌ puwi ri yewaꞌ, xukunaj y xubꞌiꞌij che utz keꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Tekꞌuchiriꞌ xubꞌiꞌij chike: —¿Kꞌo nebꞌa junoq che alaq, we rukawayuꞌ o rubꞌoyex katzaq pa siwan, na keꞌresalaꞌ tuloq tobꞌ chupa jun qꞌij re uxlanibꞌal? ¿China na kaꞌanaw ta waꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ekꞌu rike na xkiriq ta ukꞌulik uwach che. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Ekꞌu ri Jesús xrilo saꞌ ri kakiꞌan ri esikꞌim pa ri waꞌim, konoje kakimajalaꞌ kibꞌ puwi taq ri tzꞌulibꞌal ke ri lik kꞌo kiwach. E uwariꞌche, xubꞌiꞌij wa kꞌambꞌal naꞌoj chike ri echokom: ");
INSERT INTO acrNNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","«Echiriꞌ kasikꞌix la ruma junoq pa juna nimaqꞌij re kꞌulanikil, na ubꞌe taj we keꞌtzꞌula la chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach; ma kꞌaxtaj kakꞌun lo junoq chokom más kꞌo uwach chiwach rilal. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Yey kaqibꞌ kꞌu riꞌ ri rajaw ri nimaqꞌij ukꞌ la y kubꞌiꞌij cheꞌla: “Yaꞌa kan la wa tzꞌulibꞌal che wa jun chik” kachaꞌ. Ruma kꞌu laꞌ, kape ri kꞌix la y keꞌtzꞌula lo la kꞌa chirij. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","»E uwariꞌche, ri chirajawaxik kaꞌan la echiriꞌ kasikꞌix la pa juna waꞌim e waꞌ: We xopon la, meꞌtzꞌula la chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach. Jelaꞌ echiriꞌ kakꞌun lo ri sikꞌiyom e la, jewaꞌ kubꞌiꞌij cheꞌla: “Wamigo, jeꞌtzꞌula la más chwach” kachaꞌ. Jekꞌulaꞌ katakꞌabꞌax qꞌij la chikiwach ri e kꞌo chwach ri mexa ukꞌ la. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Ma china ri kuꞌan lik nim che ribꞌ, ri Dios kuqasaj uwa uqꞌij; noꞌj china ri kuꞌan chꞌutiꞌn che ribꞌ, ri Dios kuyak uqꞌij» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Tekꞌuchiriꞌ, xubꞌiꞌij che ri fariseo, ri sikꞌiyom re pa ri waꞌim: —Echiriꞌ kaꞌan la juna waꞌim, na xew ta kesikꞌij la ri amigos la, ri e atz-chaqꞌ la, ri e kꞌo chux cheꞌla y ri bꞌeyomabꞌ e kꞌo lo chi naqaj la. Ma we kaꞌan la waꞌ, rike kakiꞌan ukꞌaxel cheꞌla, kakisikꞌij la pa juna waꞌim y jekꞌuriꞌlaꞌ asu kakꞌul la ri tzelebꞌal uwach che ri xꞌan la. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","»E uwariꞌche, ri chirajawaxik kaꞌan la echiriꞌ kaꞌan la juna nimaqꞌij, e chebꞌesikꞌij la ri nibꞌaꞌibꞌ, ri tꞌum kaqan kiqꞌabꞌ, ri e sik y ri e potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Jekꞌuriꞌlaꞌ nim qꞌij alaxik la, ma rike na kakichꞌij ta uyaꞌik ukꞌaxel cheꞌla; pero e kakꞌul la ri rajil ukꞌaxel echiriꞌ kekꞌastaj lo ri lik e jusukꞌ chwach ri Dios —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Echiriꞌ xuta waꞌ jun chike ri etzꞌul chwa ri mexa, jewaꞌ xubꞌiꞌij che: «¡Nim uqꞌij ralaxik china ri kawaꞌ pa ri nimalaj nimabꞌal kuya ri Dios pa rutaqanik!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Ekꞌu ri Jesús xubꞌiꞌij che: «Julaj kꞌo jun achi xuchꞌobꞌo kuya jun nimalaj nimabꞌal y lik e kꞌi ri xebꞌusikꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Ekꞌuchiriꞌ xopon ru orayil ri nimabꞌal, xutaq bꞌi jun raj chak chaꞌ kubꞌiꞌij chike ri echokom chik: “Peta kꞌu alaq ma yijbꞌital chi ronoje” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","»Noꞌj chikijujunal xkijeq kakitzꞌonoj kuybꞌal kimak ruma na kebꞌek taj. Ri nabꞌe xubꞌiꞌij: “Xinloqꞌ ko juchꞌaqap wulew y lik chirajawaxik kiꞌnwilaꞌ. Chabꞌiꞌij ko che rapatrón chukuyu numak ma na kinꞌek taj” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","»Ri jun chik xubꞌiꞌij: “Xinloqꞌ ko woꞌobꞌ yunta bꞌoyexabꞌ y ekꞌu waꞌ kiꞌntija kiqꞌij pa chak. Chabꞌiꞌij ko che rapatrón chukuyu numak ma na kinꞌek taj” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","»Yey jun chik xubꞌiꞌij: “Riꞌin lik kꞌakꞌ xinkꞌuliꞌik; y ruma laꞌ na kinꞌek taj” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","»Echiriꞌ xtzelej lo raj chak, xubꞌiꞌij ronoje waꞌ che rupatrón. Ekꞌu rupatrón lik xpe royowal y xubꞌiꞌij che ri raj chak: “Choqꞌotan riꞌ, jat pa taq kꞌaybꞌal y pa taq bꞌe re ri tinamit y chebꞌakꞌama lo ri e nibꞌaꞌibꞌ, ri tꞌum kaqan kiqꞌabꞌ, ri e potzꞌ y ri e sik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","»Xeꞌek kꞌu raj chak. Y echiriꞌ xtzelej loq, xubꞌiꞌij che rupatrón: “Wajaw, ya xinꞌan ronoje ri xintaq la che; na rukꞌ ta kꞌu riꞌ, lik kꞌa kꞌo luwar chwa taq ri mexa” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","»Xubꞌiꞌij tanchi kꞌu rachi che ri raj chak: “Chatelubꞌi tzaꞌm tinamit y jat pa taq nimabꞌe y pa taq kuxkul bꞌe. Chamina uwach chike ri winaq chaꞌ kepetik y jelaꞌ kanoj uwa taq ri mexa nuyijbꞌam chik re wa nimabꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Yey paqatzij wi kambꞌiꞌij chawe: Na jinta junoq chike ri xenusikꞌij nabꞌe, kutij re ri nimabꞌal nuyijbꞌam” xchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Echiriꞌ ri Jesús kꞌo chi bꞌe, ukꞌiyal winaq eteran chirij. Ekꞌu Rire xtzuꞌn chirij y jewaꞌ xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","«We kꞌo junoq karaj katerej lo chwij, lik chirajawaxik che más kꞌax kinunaꞌ riꞌin chikiwa konoje, ma we e más kꞌax kebꞌunaꞌ ruchu-uqaw, ri rixoqil, ri ralkꞌoꞌal, ri ratz-uchaqꞌ y más ne kꞌax kunaꞌ ribꞌ rire chinuwa riꞌin, riꞌ na taqal ta che kuꞌan nutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","E uwariꞌche, china ri na kuya ta ranimaꞌ kutij kꞌax ruma ri katerej lo chwij, riꞌ na taqal ta che kuꞌan nutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","»Ma we kꞌo junoq karaj kuꞌan nutijoꞌn, lik chuchꞌobꞌo na raqan we kukuy ri kꞌaxkꞌobꞌik kape puwiꞌ ruma ri katerej lo chwij. »E jelaꞌ pachaꞌ ri kaꞌanik echiriꞌ kayak juna nimalaj ja. Ma ¿kꞌo nebꞌa junoq che alaq na kuchꞌobꞌ ta raqan chi utz nabꞌe na puwi ri kajawax che chaꞌ kuyak ri ja y karajilaj na kꞌu riꞌ janipa ri kumaj bꞌi chaꞌ karetaꞌmaj we xaqareꞌ kuchꞌij uyakik ri ja? ");
INSERT INTO acrNNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ma we na kuꞌan ta waꞌ, echiriꞌ utikom chi kꞌu ruparaqan ri ja, kuchaqabꞌaꞌ uꞌanikil ruma na jinta chi puaq re kukꞌiso; yey konoje kꞌu riꞌ ri kebꞌilow re, kakijeq kakichꞌamij, ");
INSERT INTO acrNNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","kakibꞌiꞌij: “Waꞌchi xujeq uyakik wa ja, yey na xukꞌis ta chik” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","»Jekꞌulaꞌ ¿saꞌ nawi kuꞌan juna rey xa e lajuj mil rusoldados chwa juna chik rey petinaq pa chꞌaꞌoj chirij rukꞌ veinte mil soldados? Ri kuꞌano e nabꞌe na kuchꞌobꞌ na raqan chi utz we xaqareꞌ kuchꞌij uchuqꞌabꞌ ri jun chik rey e kꞌo más usoldados. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Y we kuchꞌobꞌo na kuchꞌij taj, ri kuꞌano e xaloqꞌ kꞌa naj kꞌo wi lo ri jun chik rey, kebꞌutaq kꞌu bꞌi achijabꞌ chaꞌ keꞌkiꞌana ri utzil chomal rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Jekꞌuriꞌlaꞌ, we kꞌo junoq che alaq karaj katerej lo chwij, lik chirajawaxik che kuya kan ronoje ri kꞌo rukꞌ; ma we na kuꞌan ta waꞌ, na taqal ta che kuꞌan nutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","»E ratzꞌam lik kajawaxik; noꞌj we xsach rutzayul, ¿suꞌanik tanchi kaꞌan tza che? ");
INSERT INTO acrNNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Ma na kuriq ta uchak che rulew y na utz ta ne kaꞌan abono rukꞌ. Ekꞌu ri kaꞌan che, e katix bꞌi. China kꞌu ri kꞌo utanibꞌal che utayik, ¡chuta kꞌu riꞌ!» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Konoje raj tzꞌonol puaq re tojonik y taq raj makibꞌ keqibꞌ rukꞌ ri Jesús chaꞌ kakita ruchꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Pero ri fariseos y raj kꞌutunel re ri tzijpixabꞌ lik kakichꞌaꞌtibꞌej, jewaꞌ kakibꞌiꞌij: «Waꞌchi kebꞌukꞌul raj makibꞌ y kawaꞌ kukꞌ» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","E uwariꞌche ri Jesús xutzijoj wa jun kꞌambꞌal naꞌoj chike, jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","«¿Saꞌ nawi kuꞌan junoq che alaq we e kꞌo jun ciento ubꞌexex yey kasach kꞌu junoq chike? ¿Na kebꞌukꞌol ta nebꞌa kan riꞌ ri noventa y nueve pa ri kiluwar y keꞌek kꞌu che utzukuxik ri jun xsach kanoq? Yey na kuxlan ta che utzukuxik kꞌa echiriꞌ kuꞌriqa loq. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Ekꞌuchiriꞌ kuriqo, lik kakiꞌkotik kuya lo chirij uqul. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Y echiriꞌ kopon chirocho, kumol kichiꞌ ri ramigos y ri ratz-uchaqꞌ, y jewaꞌ kubꞌiꞌij chike: “Chixkiꞌkota wukꞌ ma xinriq ri nubꞌexex sachinaq” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","»Kambꞌiꞌij kꞌu riꞌin che alaq: Más ne kꞌo kiꞌkotemal chilaꞌ chikaj ruma juna aj mak kutzelej utzij chwach ri Dios, chikiwa noventa y nueve jusukꞌ e kꞌolik y na kajawax taj kakuytaj kimak. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","»We e laꞌ juna ixoq kꞌo lajuj saqil puaq rukꞌ yey kutzaq kꞌu junoq, ¿saꞌ ri kuꞌano? Kutzij aqꞌ y naꞌl kumes rupa ja, kutzukuj kꞌu kokꞌil yey na kuxlan ta che utzukuxik kꞌa echiriꞌ kuꞌriqa loq. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Y ekꞌuchiriꞌ uriqom chik, kumol kichiꞌ ri ramigos y ri ratz-uchaqꞌ y kubꞌiꞌij kꞌu chike: “Chixkiꞌkota wukꞌ ma xinriq wa saqil puaq nutzaqom” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kambꞌiꞌij kꞌu riꞌin che alaq: Jelaꞌ ri kiꞌkotemal ke ri ángeles chwach ri Dios echiriꞌ juna aj mak kutzelej utzij» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Xutzijoj kꞌu wa jun kꞌambꞌal naꞌoj chike, jewaꞌ xubꞌiꞌij: «Kꞌo jun achi e kꞌo kaꞌibꞌ ukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Jun qꞌij ri chaqꞌixel xubꞌiꞌij che ruqaw: “Tat, jacha la upa ri bꞌeyomalil la y asu yaꞌa la janipa ri taqal chwe riꞌin” xcha che ruqaw. Y ruqaw e xuꞌano. Xujach kꞌu rubꞌeyomalil, xuya ri taqal che rukꞌajol atzixel y ri taqal che ri chaqꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","»Kꞌamajaꞌ kꞌu naj ujachik upa, rala chaqꞌixel xukꞌayij ronoje ri xyaꞌ che, xumol bꞌi uchiꞌ ri puaq y xeꞌek naj chupa jun chik tinamit. Chilaꞌ kꞌu riꞌ xutzꞌilaꞌ ronoje rubꞌeyomalil, ma xuꞌan rukꞌ ri puaq ronoje ri xraj rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ekꞌuchiriꞌ xukꞌis ronoje rurajil, xpe jun nimalaj numik chupa laꞌ la tinamit pa kꞌo wi. Y xujeq lik kutij kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","»Xeꞌek kꞌut che utzukuxik uchak rukꞌ jun achi aj chilaꞌ. Yey rachi xutaq bꞌi pa juyubꞌ che kichajixik ukꞌiyal aq. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ekꞌu rala xujeq lik kanumik, kurayij uwach tobꞌ ne e ri kechaꞌ ri aq, pero na jinta junoq kayaꞌw re che. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","»Tekꞌuchiriꞌ, xkꞌun runaꞌoj y chiribꞌil ribꞌ xuchꞌobꞌ raqan: “Chilaꞌ chirocho ri nuqaw lik kꞌo kakitij rukꞌiyal mokom; yey riꞌin wara kinkam che numik. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Ekꞌu woꞌora kintzelej chirocho ri nuqaw y jewaꞌ kambꞌiꞌij che: Tat, in makuninaq chwach ri Dios y chiwach rilal. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Na taqal ta chik kabꞌiꞌx chwe in kꞌajol la. ꞌAna la chwe pachaꞌ xa in chi jun mokom la” xcha chiribꞌil ribꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Y ekꞌu xuꞌano. Xumaj bꞌi ubꞌe chirocho ruqaw. »Ekꞌu ruqaw, echiriꞌ xril pana rukꞌajol chinimanaj, lik xjuchꞌ kaꞌn pa ranimaꞌ. Lik kꞌu riꞌ kanik xeꞌek y xuꞌkꞌulu apanoq. Xulaqꞌapuj y xutzꞌubꞌ uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","»Y rala xubꞌiꞌij che ruqaw: “Nuqaw, in makuninaq chwach ri Dios y chiwach rilal. Na taqal ta chik kabꞌiꞌx chwe in kꞌajol la” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","»Pero ruqaw xubꞌiꞌij chike ri raj chakibꞌ: “Jiꞌwesalaꞌ lo ri kꞌul más chom y chiwiqaꞌ. Chikojo juna mapaqꞌabꞌ che ruwi uqꞌabꞌ y uxajabꞌ che ri raqan. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Yey jiꞌkꞌama lo ri meqꞌ lik tiꞌoꞌjirisam y chikamisaj. Qatija kꞌu riꞌ, chojkiꞌkotoq y qaꞌana nimaqꞌij, ");
INSERT INTO acrNNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ma wa nukꞌajol e junam rukꞌ kaminaq chik yey woꞌora xkꞌastaj loq. Rire sachinaq chik pero xriqitajik” xcha chike. Y xkijeqo lik kekiꞌkotik. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","»Ekꞌu rukꞌajol atzixel bꞌenaq pa juyubꞌ; yey echiriꞌ xkꞌun lo chunaqaj ri ja, xuta ri música lik katꞌiqowik y ri kexajaw pa ri nimaqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Xusikꞌij kꞌu pan jun chike raj chakibꞌ y xutzꞌonoj che saꞌ ri katajinik. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","»Raj chak xubꞌiꞌij che: “Xkꞌun ri chaqꞌ la. Ruma kꞌu laꞌ, ri qaw la lik xkiꞌkot che ma utz uwach xkꞌunik, na jinta kꞌo xukꞌulumaj. E uwariꞌche, xutaq ukamisaxik ri meqꞌ tiꞌoꞌjirisam chaꞌ kaqaꞌan nimaqꞌij” xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","»Ekꞌu ri atzixel lik xpe royowal y na xraj taj kok bꞌi. Xel na kꞌu lo ruqaw y lik xelaj che chaꞌ kok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Noꞌj rire xukꞌul uwach, jewaꞌ xubꞌiꞌij che ruqaw: “Rilal etaꞌam la janipa lo junabꞌ waꞌ in chakuninaq ukꞌ la y na nupalajim ta tzij la julajoq. Na rukꞌ ta kꞌu riꞌ, na yaꞌom tane la chwe tobꞌ xa juna ralko nukaprux chaꞌ kanꞌan nimaqꞌij y kinkiꞌkot kukꞌ ri wamigos. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Yey ekꞌu woꞌora xkꞌun wa jun kꞌajol la, ri xa xuꞌtzꞌilaꞌ lo ri puaq la kukꞌ ixoqibꞌ na chom ta kibꞌinik; na rukꞌ ta kꞌu riꞌ, ruma rire, xtaq la ukamisaxik ri meqꞌ tiꞌoꞌjirisam” xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","»Ekꞌu ruqaw xubꞌiꞌij che: “Nukꞌajol, riꞌat ronoje qꞌij at kꞌo wukꞌ, yey rubꞌitaq we, ronoje aweꞌat chik. ");
INSERT INTO acrNNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Noꞌj woꞌora lik chirajawaxik wi kaqaꞌan nimaqꞌij y kojkiꞌkotik, ma waꞌchaqꞌ e junam rukꞌ kaminaq chik yey woꞌora xkꞌastaj loq. Rire sachinaq chik pero xriqitajik” xchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Ekꞌu ri Jesús xutzijoj waꞌ chike rutijoꞌn: «Kꞌo jun achi bꞌeyom y rire kꞌo jun raj chak chajinel re ronoje rubꞌitaq re. Xopon kꞌu ubꞌiꞌxikil che ri bꞌeyom, ri raj chak katajin bꞌi che ukꞌisik rubꞌeyomalil. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Ekꞌu ri bꞌeyom xusikꞌij ri raj chak y jewaꞌ xubꞌiꞌij che: “¿Saꞌ waꞌ wa kanta chawe? Ma xbꞌiꞌx chwe, riꞌat e katzꞌilaꞌ rubꞌitaq we. Ruma kꞌu riꞌ, woꞌora na at ta chi chajinel chwi rubꞌitaq we, pero chayaꞌa kan chwe chucholaꞌj tzꞌibꞌital chwa wuj saꞌ ri xaꞌan rukꞌ taq ri nuyaꞌom paqꞌabꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","»Ewi ri raj chak xuchꞌobꞌ raqan: “¿Saꞌ ri kanꞌan woꞌora? Ma ri wajaw karesaj ri nuchak chwe. Yey riꞌin na kankuy taj kinchakun pa juyubꞌ y kinkꞌix che kantzꞌonoj limoxna. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ah! Wetaꞌam chik saꞌ ri kanꞌano chaꞌ e kꞌo wamigos kekꞌuluw weꞌin chikocho echiriꞌ na jinta chi nuchak” xcha pa ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","»Xebꞌusikꞌij kꞌu chikijujunal ri kꞌo kikꞌas rukꞌ ri rajaw. Xutzꞌonoj che ri nabꞌe: “¿Janipa rakꞌas rukꞌ ri wajaw?” xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","»Y raj kꞌas xukꞌul uwach: “Nukꞌas jun ciento tenaꞌx aceite” xcha che. »Y raj chak xubꞌiꞌij che: “Riꞌ ruwujil rakꞌas. Choqꞌotan chat-tzꞌuloq, chayojo ri jun ciento y chakojo xa nikꞌaj ciento chik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","»Tekꞌuchiriꞌ, xutzꞌonoj che jun chik: “Y riꞌat, ¿janipa rakꞌas?” xchaꞌ. »Y raj kꞌas xubꞌiꞌij: “Nukꞌas jun ciento quintal trigo” xchaꞌ. »Y raj chak xubꞌiꞌij che: “Riꞌ ruwujil rakꞌas. Chayojo ri jun ciento y chakojo xa ochenta quintal chik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","»Ekꞌu ri rajaw, echiriꞌ xretaꞌmaj saꞌ ri xuꞌan ri raj chak, jewaꞌ xubꞌiꞌij: “¡Jaꞌ! ¡Lik kꞌo unaꞌoj wa jun achi, tobꞌ na jusukꞌ ta ri uꞌanom!” xchaꞌ.» Xubꞌiꞌij kꞌu ri Jesús chike rutijoꞌn: «Paqatzij wi ri winaq na e ta jusukꞌ, más kꞌo kinaꞌoj che uchapabꞌexik rubꞌitaq ke, chikiwa ri e kꞌo pa ri Qꞌijsaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","E uwariꞌche kambꞌiꞌij chiwe: Chichapabꞌej chi utz ri puaq y rubꞌitaq iwe y rukꞌ waꞌ chebꞌitoꞌo ri nibꞌaꞌibꞌ y jekꞌulaꞌ rike kebꞌuꞌana iwamigos. Ma echiriꞌ kopon ri qꞌij na jinta chi puaq iwukꞌ, kixkꞌul na chilaꞌ chikaj pa kayaꞌiꞌ wi chiwe ri kꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","»E junoq jusukꞌ uchapabꞌexik kuꞌan ri xa jubꞌiqꞌ yaꞌtal puqꞌabꞌ, jekꞌuriꞌlaꞌ kuꞌano we xyaꞌiꞌ kꞌi puqꞌabꞌ. Noꞌj we na jusukꞌ ta uchapabꞌexik kuꞌan ri xa jubꞌiqꞌ yaꞌtal puqꞌabꞌ, jekꞌuriꞌlaꞌ we xyaꞌiꞌ kꞌi puqꞌabꞌ, na jusukꞌ ta ri kuꞌan rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ekꞌu riꞌ riꞌix, we na jusukꞌ ta uchapabꞌexik iꞌanom ri bꞌeyomalil xa re ruwachulew, ¿china kꞌu kayaꞌw riꞌ piqꞌabꞌ ri saqil bꞌeyomalil re chilaꞌ chikaj? Na jinta junoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yey we e laꞌ na jusukꞌ ta uchapabꞌexik iꞌanom ri yaꞌom piqꞌabꞌ xa pa chaqꞌiꞌm, ¿china kꞌu riꞌ karaj kuya bꞌeyomalil chiwe? Na jinta junoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","»Lik kꞌayew we juna aj chak e kaꞌibꞌ ri rajaw. Ma laj tzel karil ri jun yey kꞌax kunaꞌ ri jun chik; o laj kuyak uqꞌij ri jun yey kukꞌaq bꞌi uqꞌij ri jun chik. Ruma kꞌu laꞌ, na utz taj we junoq kuya ribꞌ che kunimaj ri Dios yey kuya ribꞌ che utzukuxik ri bꞌeyomalil re ruwachulew» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Echiriꞌ xkita waꞌ ri fariseos, ri lik keꞌek kikꞌuꞌx rukꞌ ri puaq, xa xkitzeꞌej ri kubꞌiꞌij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ekꞌu Rire xubꞌiꞌij chike: «Ralaq fariseos, lik kaꞌan chi ibꞌil ibꞌ alaq pachaꞌ lik alaq jusukꞌ chikiwach ri winaq, pero ri Dios retaꞌam saꞌ ri kꞌo pa animaꞌ alaq. Ma ronoje taq ri lik yakom uqꞌij kuma ri winaq, waꞌ lik tzel kilitaj ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","»Ri qꞌalajisanelabꞌ y ri Moisés kitzꞌibꞌam chi lo chupa ri Tzij Pixabꞌ chwi rutaqanik ri Dios kakꞌun na; yey rukꞌ kꞌu ri Juan xjeqiꞌ wi utzijoxik rukꞌunibꞌal rutaqanik ri Dios, y konoje kꞌu ri winaq lik kakitij uqꞌij kebꞌok chupa waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Na rukꞌ ta kꞌu riꞌ, lik kꞌo uwach wa Tzij Pixabꞌ tzꞌibꞌital kanoq, ma e ne más kꞌayew kajalkꞌatix jubꞌiqꞌoq che waꞌ chwa ri kasach uwach ruwa kaj y ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","»China junoq kuya ruwujil re jachbꞌal ibꞌ che ri rixoqil yey kakꞌuliꞌ tanchi rukꞌ juna chik ixoq, riꞌ kamakun chirij ri kꞌulanikil. Yey china ri kakꞌuliꞌ rukꞌ rixoq jachom kanoq, riꞌ jenelaꞌ kamakun chirij ri kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","»Kꞌo jun achi lik bꞌeyom, e taq ruqꞌuꞌ kukojo ꞌanatal rukꞌ kꞌul morato y rukꞌ kꞌul lino rubꞌiꞌ, yey waꞌ lik kꞌi rajil. Rire ronoje qꞌij kuꞌan nimaq nimanik pa rocho. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Y chunaqaj kꞌu ri puerta katzꞌuyiꞌ jun nibꞌaꞌ Lázaro rubꞌiꞌ yey waꞌ lik kaqꞌolol rij che chꞌaꞌk. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Ekꞌu wa nibꞌaꞌ lik kurayij pan uwach ri qax katzaq chuxeꞌ rumexa ri bꞌeyom; yey kekꞌun taq ne lo ri tzꞌiꞌ y kakiriqꞌiraꞌ uwach rukꞌax kaqꞌololik. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","»Xopon kꞌu jun qꞌij xkam ri nibꞌaꞌ y xkꞌam bꞌi kuma ri ángeles y xyaꞌ kꞌu putzal ri Abraham. Tekꞌuchiriꞌ, xkam ri bꞌeyom y xmuqik. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","»Ekꞌuchiriꞌ kꞌo chi pa kꞌax ri bꞌeyom chupa ri luwar ke ri ekaminaq, chinimanaj xril pan ri Abraham rukꞌ ri Lázaro putzal. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Ekꞌu ri bꞌeyom xsikꞌin apanoq, jewaꞌ xubꞌiꞌij: “Nuqaw Abraham, chinjuchꞌ kaꞌn ko cheꞌla, taqa lo la ri Lázaro chaꞌ kumuꞌ ruwi uqꞌabꞌ pa yaꞌ re koluꞌjorij ri waqꞌ, ma lik kꞌax in kꞌo chupa wa aqꞌ” xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","»Noꞌj ri Abraham xubꞌiꞌij pan che: “At wal, kꞌuna chakꞌuꞌx echiriꞌ at kꞌas che ruwachulew, lik xakꞌul janipa ri xarayij; noꞌj ri Lázaro lik kꞌax ri xukꞌul rire che rukꞌaslem che ruwachulew. Ekꞌu woꞌora rire lik utz uꞌanom wara, noꞌj riꞌat at kꞌo pa ri kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Yey chiqaxoꞌl riꞌoj y riꞌat kꞌo jun nimalaj siwan. Ruma kꞌu waꞌ, ri e kꞌo wara na utz taj keqꞌax pan iwukꞌ; y ri e kꞌo iwukꞌ, na utz taj keqꞌax lo wara” xcha ri Abraham. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","»Xubꞌiꞌij kꞌu ri bꞌeyom che: “Kantzꞌonoj ko cheꞌla, nuqaw Abraham, taqa bꞌi la ri Lázaro chirocho ri nuqaw chwachulew, ");
INSERT INTO acrNNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ma chilaꞌ e kꞌo kan woꞌobꞌ nuchaqꞌ. Taqa kꞌu bꞌi la ri Lázaro chaꞌ kebꞌuꞌpixabꞌaj y jelaꞌ na kepe ta rike chupa wa luwar re kꞌax pa wa in kꞌo wi riꞌin” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","»Y ri Abraham xubꞌiꞌij che: “Kꞌo chi pakiqꞌabꞌ rike ri Tzij Pixabꞌ tzꞌibꞌital kan kuma ri Moisés y ri qꞌalajisanelabꞌ. ¡Ekꞌu kita ke riꞌ!” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","»Ekꞌu ri bꞌeyom xubꞌiꞌij che: “Nuqaw Abraham, rike na kebꞌok ta il che waꞌ. Pero we ta e laꞌ kꞌo junoq kꞌastajinaq bꞌi chikixoꞌl ri ekaminaq yey kawinaqir chikiwach, riꞌ kakitzelej na kitzij chwach ri Dios” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","»Ekꞌuchiriꞌ xubꞌiꞌij ri Abraham che: “We rike na kebꞌok ta il che ri kitzꞌibꞌam kan ri Moisés y ri qꞌalajisanelabꞌ, na kakijalkꞌatij ta ri kibꞌinik kisilabꞌik tobꞌ ne kawinaqir chikiwach junoq kꞌastajinaq bꞌi chikixoꞌl ri ekaminaq” xcha ri Abraham.» ");
INSERT INTO acrNNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Ri Jesús xubꞌiꞌij chike rutijoꞌn: «Che ruwachulew lik kꞌo tzaqibꞌal pa mak, pero ¡lik toqꞌoꞌ kꞌu uwach ri kumin junoq chik chupa ri na utz taj, ma e kape ri qꞌatbꞌal tzij re ri Dios puwiꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Ma e ne más utz kuya ri katzayabꞌax bꞌi puqul juna nimalaj kaꞌ re keꞌem y kakꞌaq kꞌu bꞌi chupa ri mar, chwa ri kumin junoq pachaꞌ wa chꞌutiꞌq chupa ri na utz taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","»Lik chiwila kꞌu iwibꞌ riꞌix. Ma we juna awatz-achaqꞌ kuꞌan ri na utz taj chawe, chachꞌaꞌbꞌej upa. Y we xutzelej utzij chawach, chakuyu umak. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Tobꞌ ne kuꞌan ri na utz taj chawe wuqubꞌ laj chupa ri jun qꞌij y wuqubꞌ laj koluꞌtzelej utzij chawach, chakuyu umak» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Ekꞌuchiriꞌ xkibꞌiꞌij ri kabꞌlajuj e utaqoꞌn che: —Nimarisaj la ri kubꞌulibꞌal qakꞌuꞌx —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Y ri Qanimajawal Jesucristo jewaꞌ xubꞌiꞌij chike: —We ta ri kubꞌulibꞌal ikꞌuꞌx kakꞌiyik jelaꞌ pachaꞌ kakꞌiy rijaꞌ re moxtasa, utz ne riꞌ kibꞌiꞌij che wa jun cheꞌ: “Chumichꞌa bꞌi ribꞌ wara y chutika ribꞌ chupa ri mar,” y e kuꞌanaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Ekꞌu ri Jesús xubꞌiꞌij: «We e laꞌ junoq chiwe kꞌo juna raj chak kachakun pa abꞌixbꞌal o kebꞌuchajij chikop, yey echiriꞌ katzelej lo pa juyubꞌ, ¿kibꞌiꞌij nawi che: “Chatokoq, chat-tzꞌula chwa ri mexa”? ");
INSERT INTO acrNNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","¡Na e ta kiꞌano! Ri kibꞌiꞌij che e waꞌ: “Chajeqa uyijbꞌaxik ri waꞌim y chayijbꞌaꞌ awibꞌ chaꞌ kaya lo ri nuwa chwa ri mexa. Ekꞌuchiriꞌ in woꞌqinaq chi riꞌin, kꞌa tekꞌuchiriꞌ katwaꞌ riꞌat” kixchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","¿Kutioxij nawi ri patrón che ri raj chak ruma xuꞌan ri xutaq che? Na kutioxij taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Jekꞌulaꞌ riꞌix, echiriꞌ iꞌanom chi ronoje ri ixtaqom che uꞌanik ruma ri Dios, jewaꞌ chibꞌiꞌij: “Riꞌoj xa oj mokom, na taqal ta ko chiqe kayak qaqꞌij ma xew qaꞌanom ri ubꞌiꞌim ri Dios chiqe” kixchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Echiriꞌ ri Jesús kꞌo chi bꞌe re keꞌek Jerusalem, katajin rikꞌowik pa ri bꞌe, ri kujach upa ri luwar re Samaria rukꞌ ri luwar re Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Echiriꞌ katajin rokik chupa jun aldea, lajuj achijabꞌ kꞌo ri yabꞌil lepra chike xebꞌel lo che ukꞌulik yey chinimanaj xetakꞌiꞌ wi lo che ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Xkijeq kꞌu kesikꞌin che, jewaꞌ kakibꞌiꞌij: —¡Jesús, lal tijonel, choj-juchꞌ kaꞌn ko cheꞌla! —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ekꞌuchiriꞌ xeril pan ri Jesús, jewaꞌ xubꞌiꞌij chike: —Oj alaq, jeꞌkꞌutu ibꞌ alaq chikiwach raj chakunel pa Rocho Dios —xcha chike. Xebꞌek kꞌut, y echiriꞌ ketajin chi bꞌe, xekunutaj che ri kiyabꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Kꞌo kꞌu jun chike, echiriꞌ xrilo kunutajinaq chik, xtzelej loq y xujeqo kasikꞌinik, lik kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Xuxukubꞌaꞌ kꞌu ribꞌ xeꞌraqan uqꞌabꞌ ri Jesús, xuqasaj rupalaj kꞌa chuꞌlew y lik katioxin chwach, yey waꞌ waꞌchi aj Samaria. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Ekꞌu ri Jesús jewaꞌ xubꞌiꞌij: —¿Na e ta nebꞌa lajuj ri xekunutajik? Yey ri bꞌelejebꞌ chik, ¿pa e kꞌo wi? ");
INSERT INTO acrNNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Suꞌchak na xetzelej ta lo rike chaꞌ kakiyak uqꞌij ri Dios? Ma xew xtzelej lo wa jun achi yey rire na aj tane Israel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Xubꞌiꞌij kꞌu che rachi: —Chatyaktajoq y chamaja bꞌi abꞌe. Ma ruma ri kubꞌulibꞌal akꞌuꞌx wukꞌ, xatkolobꞌetaj che ri yabꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Ri fariseos xkitzꞌonoj che ri Jesús: —¿Jampalaꞌ kakꞌun rutaqanik ri Dios che ruwachulew? —xechaꞌ. Y ri Jesús xukꞌul uwach: —Ri jeqebꞌal rutaqanik ri Dios na jinta kꞌutubꞌal re kilitajik. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Na jinta ne junoq kubꞌiꞌij: “¡Riꞌ kꞌo wara!” o “¡Leꞌ kꞌolik!” Ma tape alaq: Rutaqanik ri Dios kꞌo chi chixoꞌl alaq —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ekꞌuchiriꞌ ri Jesús xubꞌiꞌij tanchi chike rutijoꞌn: «Kopon kꞌu ri qꞌij echiriꞌ lik kiwaj kiwil tobꞌ ne xa juna qꞌij che ruqꞌijol Ralaxel Chikixoꞌl Tikawex echiriꞌ kataqan che ruwachulew; pero na kiwil taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Kuꞌana kꞌu riꞌ e kꞌo kakibꞌiꞌij chiwe: “¡Riꞌ kꞌo wara!” o “¡Leꞌ kꞌolik!” Pero riꞌix mixꞌek, na kebꞌiternabꞌej ta nenareꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Ma echiriꞌ kakꞌun Ralaxel Chikixoꞌl Tikawex, konoje kakil rukꞌunibꞌal jelaꞌ pachaꞌ kuꞌano echiriꞌ kayokꞌ kaꞌn ruxeꞌ kaj y ruwonibꞌal waꞌ kuwonisaj ronoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pero lik kꞌu chirajawaxik nabꞌe na kutij ri kꞌax y lik kakꞌaq bꞌi uqꞌij kuma ri winaq re waqꞌij ora. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","»Ma jelaꞌ pachaꞌ ri xuꞌan chupa taq ri qꞌij re ri Noé, jelaꞌ kuꞌana pa rukꞌunibꞌal Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ma konoje ri winaq kakitij kiwa, kakitij kiyaꞌ, kekꞌuliꞌik y kekiya ri kalkꞌoꞌal pa kꞌulanikil. Ekꞌu ketajin riꞌ che uꞌanikil, echiriꞌ xopon ruqꞌijol xok bꞌi ri Noé chupa ri nimalaj barco; kꞌa tekꞌuchiriꞌ xpe ri unimal jabꞌ y jelaꞌ xusach kiwach konoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Jekꞌuriꞌlaꞌ xuꞌan ojertan chupa taq ri qꞌij re ri Lot: taq ri winaq kakitij kiwa, kakitij kiyaꞌ, keloqꞌowik, kekꞌayinik, ketikoꞌnajik y kakiyak kocho. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Yey chupa kꞌu ri qꞌij echiriꞌ xel bꞌi ri Lot chupa ri tinamit Sodoma, xpe lo aqꞌ chikaj kajinow rukꞌ azufre y xekam konoje ri e kꞌo chupa ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Jekꞌuriꞌlaꞌ kuꞌana pa ruqꞌijol echiriꞌ kaqꞌalajin uwach Ralaxel Chikixoꞌl Tikawex, ma taq ri winaq na kakoyꞌej ta rukꞌunibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","»Chupa kꞌu riꞌ la qꞌij, china ri kꞌo lo chwi ri rocho, maqaj lo che ukꞌamik ubꞌitaq re pa ja; y china ri kꞌo pa juyubꞌ, matzelej lo pa ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Kꞌuna chikꞌuꞌx riꞌix saꞌ ri xukꞌulumaj ri rixoqil ri Lot. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","China ri lik kutij riꞌ che na kuya ta ranimaꞌ rukꞌaslem, riꞌ e kujam ri chomilaj ukꞌaslemal chwach ri Dios; noꞌj china ri kuya ranimaꞌ rukꞌaslem wuma riꞌin, riꞌ e kuriq ri chomilaj ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","»Paqatzij wi kambꞌiꞌij chiwe: Chupa laꞌ laꞌqꞌabꞌ kꞌo kuꞌana wi e kꞌo kaꞌibꞌoq kewar junam; jun kakꞌam bꞌi y ri jun chik kayaꞌiꞌ kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","O laj e kꞌo kaꞌibꞌ ixoqibꞌ junam kekeꞌnik; jun kakꞌam bꞌi y ri jun chik kayaꞌiꞌ kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Pa e kꞌo wi kaꞌibꞌoq chwa juyubꞌ; jun kakꞌam bꞌi y ri jun chik kayaꞌiꞌ kanoq» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Ekꞌuchiriꞌ rutijoꞌn xkikꞌul uwach, jewaꞌ xkibꞌiꞌij che: —Qajawal, ¿pachawi kuꞌana wi waꞌ? —xechaꞌ. Y ri Jesús xubꞌiꞌij chike: —Lik kaqꞌalajinik pa kuꞌana wi, jelaꞌ pachaꞌ kaqꞌalajinik pa kꞌo wi juna kaminaq, ma puwi waꞌ kakimol wi kibꞌ taq ri kꞌuch —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Ekꞌu ri Jesús xutzijoj wa jun kꞌambꞌal naꞌoj chaꞌ kukꞌut chike rutijoꞌn ri lik chirajawaxik wi na kakoqꞌotaj taj kakiꞌan orar chwach ri Dios y na kapax tane kikꞌuꞌx che royꞌexik ri kꞌulubꞌal uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Jewaꞌ xubꞌiꞌij chike: «Chupa jun tinamit kꞌo jun aj qꞌatal tzij na kuxiꞌij ta ribꞌ chwach ri Dios y na kuxiꞌij ta ribꞌ chwach juna achi. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Kꞌo kꞌu jun ixoq malkaꞌn chupa wa tinamit, ronoje qꞌij kakꞌun chwach raj qꞌatal tzij y kubꞌiꞌij che: “Qꞌata la tzij puwi jun tikawex kachꞌoꞌjin chwij” kacha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","»Ekꞌu raj qꞌatal tzij lik naj e riꞌ na xraj taj kuꞌan ri kutzꞌonoj wiꞌxoq. Tekꞌuchiriꞌ, xubꞌiꞌij pa ranimaꞌ: “Tobꞌ na kanxiꞌij ta wibꞌ chwach ri Dios y na kanxiꞌij ta wibꞌ chwach juna achi, ");
INSERT INTO acrNNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","kanꞌan na kꞌu wa qꞌatbꞌal tzij kutzꞌonoj wiꞌxoq malkaꞌn. Ma we na kantoꞌ taj, xaqi kinoꞌluchꞌichꞌaꞌ yey waꞌ na kankuy ta chik” xcha raj qꞌatal tzij.» ");
INSERT INTO acrNNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Ekꞌuchiriꞌ, ri Qanimajawal xubꞌiꞌij chike rutijoꞌn: «Xita kꞌu riꞌ saꞌ ri xubꞌiꞌij wa aj qꞌatal tzij na utz ta ukꞌuꞌx. Xuꞌan kꞌu ri xutzꞌonoj rixoq che ma rire na xroqꞌotaj ta utzꞌonoxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","»We juna achi na utz ta ukꞌuꞌx kuꞌan waꞌ, ¡makꞌuwariꞌ ri Dios kuꞌan ri usukꞌ y kebꞌutoꞌ kꞌu ri ebꞌuchaꞌom Rire we rike kakichꞌaꞌbꞌej chipaqꞌij chichaqꞌabꞌ! ¿Kamayin nebꞌa Rire che ukꞌulik uwach? ");
INSERT INTO acrNNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Kambꞌiꞌij chiwe: Na jampatana ri Dios kukꞌulubꞌej lo uwach y kuꞌan kꞌu ri usukꞌ chike. Pero echiriꞌ kakꞌun tanchi Ralaxel Chikixoꞌl Tikawex, ¿kꞌa keburiq nawi tikawex che ruwachulew kꞌa kꞌo kubꞌulibꞌal kikꞌuꞌx rukꞌ ri Dios?» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","E kꞌo jujun kakichꞌobꞌo lik e jusukꞌ; ruma kꞌu riꞌ, lik kꞌu kakikꞌaq bꞌi kiqꞌij ri jujun chik. Ekꞌu ri Jesús xutzijoj wa jun kꞌambꞌal naꞌoj chike: ");
INSERT INTO acrNNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","«E kꞌo kaꞌibꞌ achijabꞌ xebꞌek pa ri Rocho Dios chaꞌ keꞌkiꞌana orar; jun e kukꞌil ri fariseos y ri jun chik, aj tzꞌonol puaq re tojonik. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ekꞌu ri fariseo e riꞌ takꞌalik xujeq kuꞌan orar; lik kuyak uqꞌij chiribꞌil ribꞌ, jewaꞌ kubꞌiꞌij: “Lal Dios, kantioxij cheꞌla ma riꞌin na in ta jelaꞌ pachaꞌ ri juchꞌobꞌ achijabꞌ: ri eleqꞌomabꞌ, ri na e ta jusukꞌ, ri kemakun chirij ri kꞌulanikil. Riꞌin na in tane jelaꞌ pachaꞌ la jun aj tzꞌonol puaq re tojonik. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Riꞌin kalaj kanꞌan ayuno ronoje semana, y kanya ri nudiezmo che ronoje ri kanchꞌako” kacha ri fariseo. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","»Noꞌj raj tzꞌonol puaq re tojonik xa naj xkꞌojiꞌ wi apanoq. Na karaj tane katzuꞌn chikaj; kutꞌiqitꞌaꞌ ruwa ukꞌuꞌx, jewaꞌ kubꞌiꞌij: “Lal Dios Qajawxel, ¡kuyu ko la numak, ma riꞌin lik in aj mak!” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","»Kambꞌiꞌij kꞌu chiwe: Wa aj tzꞌonol puaq re tojonik xtzelej chirocho ꞌanom chi jusukꞌ che ruma ri Dios; noꞌj ri fariseo, na xkuy ta rumak. Ma china ri kuꞌan nim che ribꞌ, ri Dios kuqasaj uwa uqꞌij; noꞌj china ri kuꞌan chꞌutiꞌn che ribꞌ, ri Dios kuyak uqꞌij» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","E kꞌo jujun raltaq ko akꞌalabꞌ xekꞌam lo chwach ri Jesús chaꞌ Rire kuya ruqꞌabꞌ pakiwiꞌ. Yey rutijoꞌn echiriꞌ xkil waꞌ, xekiyaj ri ekꞌamayom lo ke. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Noꞌj ri Jesús xebꞌusikꞌij pan rakꞌalabꞌ y jewaꞌ xubꞌiꞌij chike rutijoꞌn: «Chiyaꞌa luwar chike ri raltaq ko akꞌalabꞌ chepeta na wukꞌ. Mebꞌiqꞌatej; ma ri kakiꞌan e jelaꞌ pachaꞌ rike, riꞌ kuꞌan ke rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Paqatzij wi kambꞌiꞌij chiwe: China ri na kukꞌul ta rutaqanik ri Dios jelaꞌ pachaꞌ kuꞌan juna ralko kꞌoꞌm, riꞌ na kok ta chupa rutaqanik ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Kꞌo jun aj wach xkꞌun rukꞌ ri Jesús y xutzꞌonoj che: —Lal utzilaj tijonel, ¿saꞌ ri kanꞌano chaꞌ kꞌo nukꞌaslemal na jinta utaqexik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Ri Jesús xukꞌul uwach: —¿Suꞌbꞌe kabꞌiꞌij la “utz” chwe? Ma xa Jun ri lik utz kꞌolik, waꞌ e ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Rilal etaꞌam chi la saꞌ taq Rutzij Upixabꞌ ri Dios: “Matmakun chirij ri kꞌulanikil. Matkamisanik. Mateleqꞌik. Maꞌan raqꞌubꞌal chirij junoq. Chaloqꞌoj kiqꞌij rachu-aqaw” —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Rachi xubꞌiꞌij: —Ronoje waꞌ nuꞌanom lo chwi nuchꞌutiꞌnal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Echiriꞌ ri Jesús xuta waꞌ, jewaꞌ xubꞌiꞌij che: —Kꞌa kꞌo ri lik chirajawaxik kaꞌan la: E kꞌayij la ronoje taq ri bꞌeyomalil la y jacha kꞌu la chike ri nibꞌaꞌibꞌ; jekꞌuriꞌlaꞌ kꞌo bꞌeyomalil la chilaꞌ chikaj. Tekꞌuchiriꞌ peta la y tereja lo la chwij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ekꞌuchiriꞌ xuta waꞌ rachi, lik xuchap bꞌis, ma rire lik bꞌeyom. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Echiriꞌ ri Jesús xrilo lik xuchap bꞌis rachi, jewaꞌ xubꞌiꞌij: —Ri e bꞌeyomabꞌ, lik kꞌayew chike kebꞌok chupa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Ma e ne más kꞌayew ri kok juna bꞌeyom chupa rutaqanik ri Dios chwa ri kikꞌow juna camello chupa rutel juna akuxaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ewi ri xetaw re waꞌ, xkibꞌiꞌij: —We e riꞌ, ¿china kꞌu riꞌ ri kakolobꞌetajik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Xubꞌiꞌij kꞌu ri Jesús chike: —Ri tikawex na kakikolobꞌej ta kibꞌ kitukel, ma waꞌ lik kꞌayew chikiwach; noꞌj ri Dios kuꞌano ma na jinta kꞌayew chwach Rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Ekꞌuchiriꞌ, xubꞌiꞌij ri Pedro: —Qajawal, e riꞌoj qayaꞌom kan ronoje y oj teran chiꞌij la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ekꞌu ri Jesús xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij chiwe: China ri uyaꞌom kan rocho, ebꞌuyaꞌom kan ruchu-uqaw, ri ratz-uchaqꞌ, ri rixoqil o ri ralkꞌoꞌal ruma rutaqanik ri Dios; ");
INSERT INTO acrNNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ruma taq kꞌu waꞌ wa uyaꞌom kanoq, lik kꞌi ri rajil ukꞌaxel kukꞌul wara che ruwachulew. Yey chiqawach apanoq kukꞌul na ri kꞌaslemal na jinta utaqexik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Ri Jesús xumol kichiꞌ ri kabꞌlajuj utijoꞌn y jewaꞌ xubꞌiꞌij chike: «Chitapeꞌ. E waꞌ kojpaqiꞌ Jerusalem y chilaꞌ kuꞌana ronoje ri tzꞌibꞌital kan kuma ri qꞌalajisanelabꞌ chwi Ralaxel Chikixoꞌl Tikawex: ");
INSERT INTO acrNNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","kayaꞌ kꞌu pakiqꞌabꞌ ri na e ta aj judiꞌabꞌ, kachꞌamixik, kayoqꞌik y kachubꞌaxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Echiriꞌ lik jichꞌom chi upa, kakamisaxik. Noꞌj churox qꞌij kakꞌastaj lo chikixoꞌl ri ekaminaq» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Pero rutijoꞌn na jinta xkimaj usukꞌ che waꞌ, ma kꞌamajaꞌ kayaꞌtaj chike kakimaj usukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","E xuꞌan waꞌ echiriꞌ ri Jesús xa naqaj chi kꞌo wi che ri tinamit Jericó. Kꞌo jun potzꞌ tzꞌul chuchiꞌ ri bꞌe, kutzꞌonoj limoxna. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Ekꞌuchiriꞌ xuto katajin kikꞌowik ukꞌiyal winaq, xutzꞌonobꞌej: —¿Saꞌ laꞌ la katajin rikꞌowik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Y kꞌo xebꞌiꞌn che: —E Jesús ri aj Nazaret katajin rikꞌowik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ekꞌuchiriꞌ, rire lik ko xsikꞌinik, jewaꞌ xubꞌiꞌij: —¡Jesús, lal ri Ralkꞌoꞌal kan ri rey David, chinjuchꞌ kaꞌn ko cheꞌla! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Yey ri winaq e nabꞌejinaq xkichꞌaꞌbꞌej upa chaꞌ na kasikꞌin ta chik. Noꞌj ri potzꞌ más ne ko kasikꞌinik, jewaꞌ kubꞌiꞌij: —¡Lal ri Ralkꞌoꞌal kan ri rey David, chinjuchꞌ kaꞌn ko cheꞌla! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Ekꞌuchiriꞌ ri Jesús xtakꞌiꞌik y xutaq ukꞌamik ri potzꞌ. Y echiriꞌ xkꞌam lo chwach, ri Jesús xutzꞌonoj che: ");
INSERT INTO acrNNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Saꞌ ri kawaj kanꞌan chawe? —xchaꞌ. Y ri potzꞌ xubꞌiꞌij che: —Wajawal, ꞌana la chwe kintzuꞌnik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Ekꞌu ri Jesús xubꞌiꞌij che: —¡Chat-tzuꞌn bꞌa riꞌ! Ma ruma ri kubꞌulibꞌal akꞌuꞌx wukꞌ, at kunutajinaq chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Xaqikꞌateꞌt kꞌu riꞌ xtzuꞌnik y xterej bꞌi chirij ri Jesús, e riꞌ kuyak uqꞌij ri Dios. Y konoje ri winaq xebꞌilow re xkijeqo kakibꞌixoj rubꞌiꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Ri Jesús xopon Jericó, e riꞌ katajin rikꞌowik chupa ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Kꞌo kꞌu jun achi chiriꞌ Zaqueo rubꞌiꞌ, aj wach ke raj tzꞌonol puaq re tojonik yey rire lik bꞌeyom. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Rire lik kutij riꞌ che suꞌanik karil uwach ri Jesús, pero na utz taj karilo kuma rukꞌiyal winaq, ma xa chꞌutiꞌn raqan. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Lik kꞌut kanik xeꞌek xnabꞌej bꞌi chikiwach ri winaq y xaqꞌan chwi jun cheꞌ chaꞌ karil uwach ri Jesús, ma chiriꞌ kikꞌow wi Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Echiriꞌ xopon ri Jesús chuxeꞌ ri cheꞌ, xtzuꞌn chikaj y xril pan ri Zaqueo; y jekꞌuwaꞌ xubꞌiꞌij pan che: —Zaqueo, choqꞌotan qaja lo la, ma waqꞌij lik chirajawaxik kineꞌkanaj kan chi ocho la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Y ri Zaqueo maji chik xqaj loq y xukꞌul ri Jesús chirocho rukꞌ kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Ekꞌuchiriꞌ xkil waꞌ ri winaq, konoje xkijeq kechꞌaꞌt chirij ri Jesús ma xkanaj kan chirocho jun achi lik aj mak. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ekꞌuchiriꞌ, ri Zaqueo xtakꞌiꞌik y jewaꞌ xubꞌiꞌij che ri Qanimajawal: —Tape la, wajawal: Pa nikꞌaj che ri nubꞌeyomalil kansipaj chike ri nibꞌaꞌibꞌ; yey we nuꞌanom eleqꞌ che junoq rukꞌ sokosoꞌnik, kajlaj rukꞌaxel kantzelej che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Ewi ri Jesús xubꞌiꞌij: —Waqꞌij xkꞌun ri kolobꞌetajik chupa wa rocho ri Zaqueo, ma rire e kukꞌil ri ralkꞌoꞌal kan ri Abraham. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yey ri in Alaxel Chikixoꞌl Tikawex, in kꞌuninaq che kitzukuxik y che kikolobꞌexik ri e sachinaq pa mak —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Echiriꞌ kakitataꞌ waꞌ ri winaq, ri Jesús xujeq utzijoxik jun kꞌambꞌal naꞌoj chike. Ma xa naqaj chi kꞌo wi che ri tinamit Jerusalem yey e chikiwach ri winaq, echiriꞌ ri Jesús kok chiriꞌ, kuqꞌalajisaj uwach y jelaꞌ kajeqer rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Xubꞌiꞌij kꞌu ri Jesús: «Kꞌo jun achi lik kꞌo uwach e riꞌ keꞌek chupa jun tinamit lik naj chaꞌ chilaꞌ kaꞌan rey che; y jelaꞌ echiriꞌ katzelej loq, kujeq rutaqanik puwi rutinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Yey echiriꞌ kꞌamajaꞌ keꞌek, xebꞌusikꞌij lajuj raj chakibꞌ y xuya kan chike chikijujunal jun saqil puaq “mina” kecha che y xubꞌiꞌij kan chike: “Chixchꞌakan chirij wa puaq xaloqꞌ riꞌin na in jintaj, y kiya tanchi chwe echiriꞌ kintzelej loq” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","»Pero ri winaq re ri tinamit lik tzel kakilo y xekitaq kꞌu bꞌi jujun achijabꞌ chaꞌ keꞌkibꞌiꞌij che ri jun kayaꞌw re ri taqanik che: “Na kaqaj ta kuꞌan rey waꞌchi paqawiꞌ” kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","»Na rukꞌ ta kꞌu riꞌ, xyaꞌtaj che rachi kuꞌan rey. Ekꞌuchiriꞌ xtzelej loq, xutaq kisikꞌixik ri raj chakibꞌ uyaꞌom kan puaq pakiqꞌabꞌ, ma karaj karetaꞌmaj janipa ri xkichꞌak chikijujunal. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","»Xkꞌun ri nabꞌe y jewaꞌ xubꞌiꞌij che: “Wajaw, rukꞌ ri jun mina yaꞌom kan la panuqꞌabꞌ, xinchꞌak chi lajuj chirij” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","»Ri rey xubꞌiꞌij che: “Utz riꞌ. At jun utzilaj aj chak. Ruma kꞌu xariq uchapabꞌexik chi utz ri na kꞌi taj, woꞌora kanya paqꞌabꞌ at taqanel pakiwi lajuj tinamit” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","»Xkꞌun kꞌu lo jun chik raj chak y jewaꞌ xubꞌiꞌij che: “Wajaw, rukꞌ ri jun mina yaꞌom kan la panuqꞌabꞌ, xinchꞌak chi woꞌobꞌ chirij” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","»Y ri rey jewaꞌ xubꞌiꞌij che: “Riꞌat kanya paqꞌabꞌ at taqanel pakiwi woꞌobꞌ tinamit” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","»Xkꞌun kꞌu jun chik y jewaꞌ xubꞌiꞌij che: “Wajaw, riꞌ ri jun mina la yaꞌom kan la panuqꞌabꞌ. Waꞌ lik nukꞌolom chi utz chupa jun suꞌt ");
INSERT INTO acrNNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ma lik xinxiꞌij wibꞌ cheꞌla ruma lik lal titzꞌitik. Rilal kaꞌan e la che ri na lal ta kꞌoloyom re, yey kamol ne la ri na xtik ta la” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","»Ekꞌuchiriꞌ, ri rey xubꞌiꞌij che: “Riꞌat at jun aj chak na jinta kꞌana achak. Rukꞌ ne la chꞌaꞌtem xabꞌiꞌij, kanqꞌat tzij pawiꞌ. We xachꞌobꞌ raqan lik in titzꞌitik ma kanꞌan weꞌin che ri na in ta inkꞌoloyom re, yey kanmol ne ri na xintik taj, ");
INSERT INTO acrNNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿suꞌbꞌe kꞌu riꞌ na xaya ta ri nupuaq pa banco chaꞌ we xintzelej loq koꞌlnukꞌamaꞌ rukꞌ ri uchꞌakom chik?” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","»Xubꞌiꞌij kꞌu chike ri e kꞌo chiriꞌ: “Chimaja ri mina che wa jun aj chak y chiyaꞌa che ri kꞌo lajuj mina rukꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","»Ekꞌu rike xkibꞌiꞌij che: “Qajaw, ¡pero rire kꞌo chi lajuj mina rukꞌ!” xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","»Y ri taqanel xukꞌul uwach: “Paqatzij wi kambꞌiꞌij chiwe: China ri lik kꞌi kꞌo rukꞌ, kayaꞌiꞌ ne más che; noꞌj ri na jinta kꞌo rukꞌ, kamajiꞌ ne che ri xa jubꞌiqꞌ kꞌo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ekꞌu woꞌora, chebꞌikꞌama lo wara ri winaq lik tzel kinkilo, ri na xkaj taj kinuꞌan rey pakiwiꞌ, y chebꞌikamisaj chinuwach” xchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Echiriꞌ xubꞌiꞌij waꞌ, ri Jesús xumaj tanchi ubꞌi ubꞌe y xpaqiꞌ Jerusalem junam kukꞌ rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Ekꞌuchiriꞌ xebꞌopon chwach ri juyubꞌ Olivos, chunaqaj raldeas Betfagé y Betania, ri Jesús xebꞌutaq bꞌi kaꞌibꞌ chike rutijoꞌn chaꞌ kenabꞌej apanoq, ");
INSERT INTO acrNNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","jewaꞌ xubꞌiꞌij chike: «Jix pa raldea kꞌo pan chiqawach. Y echiriꞌ kixok chupa, kiꞌriqa jun qꞌapoj buru yuqulik. Waꞌ na jinta junoq kojoyom re. Chikiraꞌ y chikꞌamaꞌ loq. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We kꞌo kꞌu junoq katzꞌonow chiwe: “¿Suꞌchak kikiro?”, jewaꞌ kikꞌul uwach: “Ma kajawax che ri Qajawal” kixchaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Xebꞌek kꞌu ri kaꞌibꞌ etaqom bꞌi y xkiriq ri buru jelaꞌ pachaꞌ ri bꞌiꞌtal bꞌi chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ekꞌuchiriꞌ ketajin che ukirik ri qꞌapoj buru, taq ri rajaw xkibꞌiꞌij chike: —¿Suꞌchak kikir la buru? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Y rike xkibꞌiꞌij: —Ma kajawax che ri Qajawal —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ewi xkikꞌam lo ri buru rukꞌ ri Jesús. Ekꞌuchiriꞌ kiripom chi ri kimanta chwi ri qꞌapoj buru, xkaqꞌanisaj ri Jesús puwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Echiriꞌ katajin rikꞌowik ri Jesús, ri winaq kakilikꞌ taq ri kimanta pa la bꞌe re yakbꞌal uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Y echiriꞌ katajin roponik chunaqaj ri xulanik re ri juyubꞌ Olivos, konoje rukꞌiyal utijoꞌn xkijeqo lik kakiyak uqꞌij ri Dios rukꞌ kiꞌkotemal ma kilom taq ri kꞌutubꞌal re ruchuqꞌabꞌ uꞌanom ri Jesús, ");
INSERT INTO acrNNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","jewaꞌ kakibꞌiꞌij: «¡Lik nim uqꞌij ri Rey petinaq chupa rubꞌiꞌ ri Dios Qajawxel! ¡Utzil chomalil kꞌo chilaꞌ chikaj y lik nim uwach uqꞌij ri Dios chilaꞌ chikaj!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","E kꞌo kꞌu jujun fariseos chikixoꞌl rukꞌiyal winaq xkibꞌiꞌij che ri Jesús: —Lal tijonel, chebꞌeqꞌatej la ri tijoꞌn la chaꞌ na kakibꞌiꞌij ta chi waꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Noꞌj ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij che alaq, we ta rike kakitanabꞌaꞌ ubꞌiꞌxikil waꞌ, e taq rabꞌaj kakijeq kakiyak nuqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Y echiriꞌ ri Jesús xopon chunaqaj Jerusalem y xril pan ri tinamit, xujeq lik koqꞌ puwiꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","jewaꞌ xubꞌiꞌij: «¡Toqꞌoꞌ iwach riꞌix aj Jerusalem! ¡We ta kꞌu kiwetaꞌmaj waqꞌij ora saꞌ ri kakꞌamaw lo utzil chomal chiwe! Noꞌj waꞌ pachaꞌ ewatal chiwach woꞌora. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Kakꞌun kꞌu ri qꞌij echiriꞌ ri tzel kebꞌilow iwe kakisut rij ri tinamit Jerusalem y kakiwok iwij chaꞌ na kixanimaj tubꞌi. Tekꞌuchiriꞌ, kepe chiwij. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Kixkikamisaj iwonoje y kakiwulij ri tinamit chaꞌ na jinta juna ja katakꞌiꞌ kanoq. Kikꞌulumaj kꞌu waꞌ ma na xiwetaꞌmaj taj jampa xkꞌun ri Kolobꞌenel iwukꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Echiriꞌ xok ri Jesús pa ri Rocho Dios, xujeq lo kesaxik konoje ri kekꞌayinik y ri keloqꞌow chupa. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Y jewaꞌ xubꞌiꞌij chike: «Ri Dios jewaꞌ kubꞌiꞌij chupa Ruchꞌaꞌtem: Ri Wocho e luwar re oración kachaꞌ. Noꞌj ralaq ꞌanom alaq che ri Wocho e jun luwar ke eleqꞌomabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Y ronoje qꞌij kakꞌutun ri Jesús pa ri Rocho Dios; noꞌj ri nimaq e aj chakunel, raj kꞌutunel re ri tzijpixabꞌ y raj wach re ri tinamit lik kakitzukuj suꞌanik kakikamisaj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Pero na kakiriq taj suꞌanik, ma konoje ri winaq lik kakaj kakita ri kubꞌiꞌij Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Kꞌo jun qꞌij ri Jesús kakꞌutun pa ri Rocho Dios, kutzijoj ri Utzilaj Tzij chike ri winaq. Xebꞌopon kꞌu ri nimaq e aj chakunel re ri Rocho Dios junam kukꞌ raj kꞌutunel re ri tzijpixabꞌ y ri nimaq winaq re ri tinamit, ");
INSERT INTO acrNNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","y xkitzꞌonoj che: —Bꞌiꞌij la chiqe: ¿China xyaꞌw paqꞌabꞌ la kaꞌan taq la waꞌ? ¿China xtaqaw la che kaꞌan taq la waꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Y ri Jesús xukꞌul uwach: —Riꞌin kanꞌan jun tzꞌonobꞌal che alaq; kꞌulu kꞌu alaq uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿China xtaqaw re ri Juan kuya ri bautismo? ¿E ri Dios o e rachijabꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ekꞌu rike xkijeq kechꞌaꞌt chikiwach puwi waꞌ: «We xqakꞌul uwach che: “E ri Dios”, riꞌ kubꞌiꞌij rire chiqe: “¿Suꞌchak kꞌu riꞌ na xkoj ta alaq ri xubꞌiꞌij?” kacha chiqe. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Yey we xqabꞌiꞌij “e rachijabꞌ”, konoje riꞌ ri tinamit kojkikamisaj paꞌbꞌaj; ma rike lik kijikibꞌam uwach ri Juan e jun qꞌalajisanel re ri Dios» xecha chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Xkibꞌiꞌij kꞌu che ri Jesús: —Na qetaꞌam taj —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ekꞌu ri Jesús xubꞌiꞌij chike: —Jekꞌuriꞌlaꞌ, riꞌin na kambꞌiꞌij ta che alaq china yaꞌyom panuqꞌabꞌ kanꞌan taq waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ekꞌuchiriꞌ, ri Jesús xujeq utzijoxik wa kꞌambꞌal naꞌoj chike ri winaq: «Kꞌo jun achi xuꞌan tikoꞌn re uva chwach ri rulew. Tekꞌuchiriꞌ, xuya kan pa tunulik chike jujun aj chakibꞌ. Xeꞌek kꞌu riꞌ y ukꞌiyal qꞌij xsachiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","»Echiriꞌ xopon ruqꞌijol ri molonik, xutaq lo jun raj chak chaꞌ kuꞌtzꞌonoj chike raj tunulel ri taqalik kukꞌul rire che ri molonik. Noꞌj raj tunulel xkichꞌayo y xkitaq bꞌi; e riꞌ na jinta xkiya bꞌi che. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","»Ekꞌu ri rajaw xutaq lo jun chik raj chak. Noꞌj raj tunulel xkiꞌan kꞌax che jelaꞌ pachaꞌ xkiꞌan che ri nabꞌe; xkichꞌayo, lik xkikꞌixbꞌesaj y xkitaq bꞌi. Yey na jinta xkiya bꞌi che. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","»Y ri rajaw xutaq lo rurox aj chak. Pero raj tunulel lik xkiꞌan kꞌax che y xkesaj bꞌi chupa waꞌ wuꞌlew. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","»Ekꞌuchiriꞌ, ri rajaw xubꞌiꞌij chiribꞌil ribꞌ: “¿Saꞌ ri kanꞌan woꞌora? Kantaq bꞌi ri nukꞌajol lik kꞌax kannaꞌo; ma kꞌaxtaj we xkil uwach rire, kakikꞌul na chi utz.” ");
INSERT INTO acrNNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","»Noꞌj raj tunulel echiriꞌ xkil uwach rukꞌajol rachi, xechꞌaꞌt chikiwach, jewaꞌ xkibꞌiꞌij: “Waꞌ e ukꞌajol ri rajaw rulew, ri kuꞌana na rajaw we xkam ruqaw. Joꞌ jeꞌqakamisaj chaꞌ rulew kuꞌan kan qeꞌoj” xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","»Xkesaj kꞌu bꞌi rukꞌajol rachi chupa waꞌ wuꞌlew y xkikamisaj» xcha ri Jesús. Tekꞌuchiriꞌ xutzꞌonoj chike ri winaq: —Chiwach ralaq, ¿saꞌ nawi kuꞌan ri rajaw ri tikoꞌn chike raj tunulel? ");
INSERT INTO acrNNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Riꞌin kambꞌiꞌij: Kakꞌunik, kusach kiwach wa aj tunulel y kuya ri rulew pa tunulik chike jujun chik —xchaꞌ. Ekꞌuchiriꞌ xkita waꞌ ri winaq, xkibꞌiꞌij: —¡Muꞌan ne ko riꞌ waꞌ ri Dios chiqe! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Pero ri Jesús lik xutzutzaꞌ kiwach y jewaꞌ xubꞌiꞌij chike: —¿Saꞌ kꞌu ri kabꞌiꞌij alaq che wa tzꞌibꞌital kan chupa Rutzij Upixabꞌ ri Dios? Ma jewaꞌ kubꞌiꞌij: E rabꞌaj kꞌaqital kan kuma raj yakal ja, e abꞌaj waꞌ lik xajawaxik chaꞌ katikiꞌ lo ri ja kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","China kꞌu ri katzaq puwi laꞌ laꞌbꞌaj, lik kꞌax ri kukꞌulumaj; yey we rabꞌaj katzaq puwi junoq, riꞌ xa jumul kusach uwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Ekꞌuchiriꞌ, ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ lik xkitzukuj suꞌanik asu kakichap bꞌi ri Jesús, ma xkimaj usukꞌ chikij rike xubꞌiꞌij wi wa kꞌambꞌal naꞌoj; noꞌj na xkiꞌan taj ruma ri kixiꞌin ibꞌ chikiwach ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Ekꞌu raj wach lik kikꞌakꞌalem ri Jesús y xekitaq bꞌi achijabꞌ kiꞌanom che kibꞌ pachaꞌ lik e jusukꞌ, chaꞌ kakikꞌam upa ri Jesús rukꞌ taq ri kubꞌiꞌij y jelaꞌ kakikoj umak y kakiya kꞌu puqꞌabꞌ ri taqanel re ri gobierno romano. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Xkitzꞌonoj kꞌu che ri Jesús: —Lal tijonel, riꞌoj qetaꞌam lik usukꞌ ronoje ri kabꞌiꞌij la y ri kakꞌut la, yey rilal lik lal jusukꞌ kukꞌ konoje ri tikawex. Paqatzij wi e kakꞌut la ri bꞌe re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Usukꞌ nawi ri kaqaꞌan tojonik che ri nimalaj taqanel re Roma o na usukꞌ taj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Noꞌj ri Jesús, ruma retaꞌam ri retzelal kikꞌuꞌx, jewaꞌ xubꞌiꞌij chike: —¿Suꞌchak kakꞌam alaq nupa? ");
INSERT INTO acrNNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Kꞌutu pe alaq chwe juna meyo re kaꞌan tojonik rukꞌ. ¿China re wa kꞌaxwach y china re wa bꞌiꞌaj kꞌo chwach wa meyo? —xchaꞌ. Rike xkikꞌul uwach: —Re ri nimalaj taqanel re Roma —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Xubꞌiꞌij kꞌu ri Jesús chike: —Yaꞌa alaq che ri nimalaj taqanel re Roma janipa ri taqal che rire; yey yaꞌa kꞌu alaq che ri Dios janipa ri taqal che ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ekꞌu ri kikꞌakꞌalem ri Jesús na xkiriq ta juna chꞌaꞌtem xubꞌiꞌij chike ri winaq chirij ri gobierno. E ne lik xkam kanimaꞌ che ri kꞌulubꞌal uwach xuyaꞌo y na jinta chi kꞌu xkibꞌiꞌij che. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Xekꞌun kꞌu rukꞌ ri Jesús jujun chike ri saduceos, ri kakibꞌiꞌij na jinta kꞌastajibꞌal chike ri ekaminaq. Xkitzꞌonoj kꞌu che: ");
INSERT INTO acrNNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Lal tijonel, ri Moisés xutzꞌibꞌaj kan chiqe: “We ri ratz junoq kakamik y na e jinta kan ralkꞌoꞌal rukꞌ ri rixoqil, ekꞌu riꞌ ruchaqꞌ kakꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq y jekꞌulaꞌ kekꞌojiꞌ ralkꞌoꞌal rukꞌ, pubꞌiꞌ ri ratz xkamik”. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","»Julaj e kꞌo wuqubꞌ achijabꞌ kichaqꞌ kibꞌ. Ri nabꞌe chike xkꞌuliꞌik, yey ekꞌu riꞌ waꞌ xkamik y na e jinta kan ralkꞌoꞌal rukꞌ ri rixoqil. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Jelaꞌ kꞌu riꞌ rukaꞌm xkꞌuliꞌ rukꞌ rixoq malkaꞌn kanoq. Ekꞌu riꞌ waꞌ xkamik y na e jinta kan ralkꞌoꞌal rukꞌ rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Yey je tanchi laꞌ xukꞌulumaj rurox. Jekꞌulaꞌ xkikꞌulumaj ri wuqubꞌ achijabꞌ; xekamik, e riꞌ na jinta kalkꞌoꞌal xkiya kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Kꞌisbꞌal kꞌu re, e xkam rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Chupa kꞌu ruqꞌijol ri kꞌastajibꞌal, ¿chinoq chike ri wuqubꞌ achijabꞌ kuꞌana rachijil rixoq? Ma konoje xekꞌuliꞌ rukꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Y ri Jesús xukꞌul uwach: —Wara che ruwachulew ri tikawex kꞌo kixoqilal y kꞌo kachijilal yey kakiya ri kalkꞌoꞌal pa kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Noꞌj ri kayaꞌtaj chike kekꞌastajik y kꞌo kikꞌaslemal na jinta utaqexik chilaꞌ chikaj, rike na jinta chi kixoqilal, na jinta chi kachijilal y na jinta chi ne kꞌo kuya ralkꞌoꞌal pa kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ma chilaꞌ chikaj na jinta chi kamik chike, kebꞌuꞌana kꞌu pachaꞌ ri ángeles. Yey e ralkꞌoꞌal ri Dios; e uwariꞌche yaꞌtal chike kekꞌastaj chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Yey puwi kꞌu ri kꞌastajibꞌal ke ri ekaminaq, kꞌuna pe chikꞌuꞌx alaq ri xutzꞌibꞌaj kan ri Moisés puwi ri xubꞌiꞌij ri Dios che echiriꞌ xchꞌaꞌt rukꞌ chupa ri jumokaj xulukej, jewaꞌ xubꞌiꞌij ri Dios che: “In ri Dios re ri Abraham, re ri Isaac y re ri Jacob” xchaꞌ. Chiriꞌ kꞌu riꞌ xuqꞌalajisaj ri Moisés kꞌo kꞌastajibꞌal, ");
INSERT INTO acrNNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ma ri Dios na e ta Dios ke ri ekaminaq ma e Dios ke ri e kꞌaslik. Ma konoje ri e ralkꞌoꞌal ri Dios, tobꞌ ekaminaq chik, e kꞌas chwach ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Ekꞌuchiriꞌ jujun chike raj kꞌutunel re ri tzijpixabꞌ, jewaꞌ xkibꞌiꞌij che ri Jesús: —Lal tijonel, lik utz ri xbꞌiꞌij la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Y ri Saduceos na jinta chi kꞌo xkitzꞌonoj che ruma xkinaꞌ kibꞌ chwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Ekꞌuchiriꞌ ri Jesús xubꞌiꞌij: «¿Suꞌbꞌe kabꞌiꞌx che ri Cristo e “Ralkꞌoꞌal kan ri rey David”? ");
INSERT INTO acrNNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ma ri David jewaꞌ xutzꞌibꞌaj kan chupa ri libro re Salmos: ");
INSERT INTO acrNNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ri Dios Qajawxel xubꞌiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwikiqꞌabꞌ, y chawoyeꞌej na ri qꞌij echiriꞌ kebꞌenuya ri tzel kebꞌilow awe chuxeꞌ rawaqan” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ekꞌu ri David kubꞌiꞌij “Wajawal” che Ruchaꞌoꞌn lo ri Dios. ¿Suꞌbꞌe kꞌu riꞌ kabꞌiꞌxik e Ralkꞌoꞌal kan ri rey David?» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Chikiwach kꞌu ri winaq ketaw re, ri Jesús xubꞌiꞌij chike rutijoꞌn: ");
INSERT INTO acrNNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","«Lik chichajij iwibꞌ; miꞌan kꞌu iweꞌix pachaꞌ ri kakiꞌan raj kꞌutunel re ri tzijpixabꞌ. Ma rike lik kukꞌul kikꞌuꞌx ri kejurur chupa ri kiqꞌuꞌ chaꞌ kilitajik lik kꞌo kiwach. Lik kukꞌul kikꞌuꞌx ri kayaꞌ rutzil kiwach pa kebꞌilitaj wi. Yey pa taq sinagogas y pa taq waꞌim e lik kukꞌul kikꞌuꞌx ri ketzꞌuyiꞌ chupa ri tzꞌulibꞌal ke ri lik kꞌo kiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Rike kakimaj ri kocho kikꞌolibꞌal rixoqibꞌ e malkaꞌnibꞌ; yey chaꞌ na kaqꞌalajin ta ri na utz taj kakiꞌano, kakiwererej unimal chꞌabꞌal echiriꞌ kakiꞌan orar. Ruma kꞌu wa kakiꞌano, lik unimal kꞌaxkꞌolil kakikꞌul na echiriꞌ kaqꞌat tzij pakiwiꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Ri Jesús xebꞌutzuꞌ pan ri bꞌeyomabꞌ echiriꞌ kakiya ri kiqasaꞌn chupa ri kaxa re qasaꞌn pa ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Y xril kꞌu jun ixoq malkaꞌn lik nibꞌaꞌ echiriꞌ xuya chupa ri kaxa kaꞌibꞌ raltaq ko meyo lik na kꞌi ta rajil. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Ekꞌu ri Jesús xubꞌiꞌij: —Paqatzij wi kambꞌiꞌij chiwe, chwach ri Dios wa jun ixoq nibꞌaꞌ y malkaꞌn e ne xuya más chwa ri xkiya konoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ma konoje xa e xkiya ruwiꞌ ri kipuaq; noꞌj wiꞌxoq tobꞌ lik nibꞌaꞌ e xuya ronoje ri puaq kꞌo rukꞌ, waꞌ e re kuloqꞌ ri lik kajawax che —xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Chiriꞌ kꞌu riꞌ e kꞌo jujun kechꞌaꞌt chwi ri Rocho Dios, kakibꞌiꞌij lik chom uꞌanom rukꞌ taq ri chomilaj abꞌaj y rukꞌ taq ri chomilaj wiqibꞌal yaꞌtal kuma ri tikawex. Ekꞌu ri Jesús xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Kakꞌun kꞌu ri qꞌij echiriꞌ ronoje wa kitzutzaꞌ, kawulixik; jekꞌulaꞌ, na kakanaj ta chi juna abꞌaj puwiꞌ jun chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Tekꞌuchiriꞌ xkitzꞌonoj che ri Jesús, jewaꞌ xkibꞌiꞌij: —Qajawal, ¿jampa nawi kuꞌana taq riꞌ waꞌ? ¿Yey saꞌ ri kꞌutubꞌal kilitajik echiriꞌ kuꞌanaꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ri Jesús xubꞌiꞌij kꞌu chike: —Lik chichajij iwibꞌ chaꞌ na kixsokotaj taj; ma e kꞌi ri kekꞌunik y xa kakichiqꞌimaj uwach ri nubꞌiꞌ, jewaꞌ kakibꞌiꞌij: “In ri Cristo, Ruchaꞌoꞌn lo ri Dios, yey lik xa naqaj chi kꞌo wi lo ruqꞌijol ri nutaqanik,” kechaꞌ. Noꞌj riꞌix mixterej bꞌi chikij. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Y echiriꞌ kito kꞌo chꞌaꞌoj y ketukuk ri winaq che ruwachulew, mixiꞌij iwibꞌ che. Ma lik chirajawaxik nabꞌe na kuꞌana na ronoje waꞌ, noꞌj kꞌamajaꞌ ne riꞌ ri kꞌisbꞌal re ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Xubꞌiꞌij kꞌu chike: «Ekꞌo tinamit keyaktaj chikij jujun chik tinamit y e kꞌo taqanelabꞌ keyaktaj chikij jujun chik taqanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kuꞌan nimaq taq kabꞌraqan. Che ukꞌiyal luwar che ruwachulew kape numik y yabꞌil pakiwi ri tikawex. Yey che ruwa kaj kilitaj nimaq taq kꞌutubꞌal xibꞌibꞌal uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","»Pero chwach taq kꞌu riꞌ waꞌ, riꞌix kitij na kꞌax ruma ikojom ri nubꞌiꞌ, kixchapik y kixternabꞌex rukꞌ kꞌax, kixyaꞌ pakiqꞌabꞌ raj wach re ri sinagogas chaꞌ rike kakiqꞌat tzij piwiꞌ y kixkꞌam bꞌi pa cárcel, kixkꞌam bꞌi chikiwach ri reyes y chikiwach ri taqanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Jekꞌuriꞌlaꞌ, utz kiqꞌalajisaj ri Utzilaj Tzij chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mixok il che saꞌ rukꞌulik uwach kiꞌano echiriꞌ kitoꞌ iwibꞌ chikiwach rike; ");
INSERT INTO acrNNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ma e riꞌin kinyaꞌw ichꞌaꞌtem yey inaꞌoj chaꞌ konoje ri tzel kebꞌilow iwe na kakiriq ta chi ukꞌulik uwach chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","»Yey kixyaꞌ ne pa qꞌatbꞌal tzij kuma richu-iqaw, kuma taq riwatz-ichaqꞌ, kuma taq ri kꞌo chux chiwe y kuma ri iwamigos. Y jujun chiwe keyaꞌ pa kamik. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Lik kꞌu tzel kixil kuma taq ri winaq ruma ikojom ri nubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Na rukꞌ ta kꞌu riꞌ, mubꞌisoj ikꞌuꞌx ma ix kꞌo puqꞌabꞌ ri Dios y na jinta ne tobꞌ xa juna iwiꞌ kasachik. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ma we kichꞌij uchuqꞌabꞌ ronoje, kikꞌul na ri kolobꞌetajik y ri kꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","»Echiriꞌ kiwil ri soldados kakijeq kakisut rij ri tinamit Jerusalem, chiwetaꞌmaj kꞌut e riꞌ kopon ri qꞌij kawulix ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ekꞌu ri winaq e kꞌo pa ri luwar re Judea, chebꞌanimaj ubꞌi chwa taq juyubꞌ; y ri e kꞌo chupa ri tinamit Jerusalem chebꞌelubꞌi; yey ri e kꞌo pa juyubꞌ, mebꞌok chi lo Jerusalem, ");
INSERT INTO acrNNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ma waꞌ e uqꞌijol qꞌatbꞌal tzij, echiriꞌ kuꞌanaꞌ janipa ri tzꞌibꞌital chupa Rutzij Upixabꞌ ri Dios puwi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chupa taq kꞌu laꞌ la qꞌij, lik toqꞌoꞌ kiwach ri e yewaꞌ ixoqibꞌ y ri ketzꞌumtisanik, ma lik saꞌch ri nimaq kꞌaxkꞌobꞌik kape che ruwachulew ruma ri royowal ri Dios chikij waꞌ wa tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","»Lik e kꞌi ri kekamisax rukꞌ espada y e kꞌi kekꞌam bꞌi chi presoyil pa jujun chik tinamit che ronoje ruwachulew. Yey ri tinamit Jerusalem kakꞌojiꞌ kꞌu pakiqꞌabꞌ ri na e ta aj Israel chaꞌ ketaqan puwiꞌ, kꞌa pa kopon wi ruqꞌijol ubꞌiꞌim chi ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","»Chwa kꞌu riꞌ ri kaj kilitaj kꞌutubꞌal che ri qꞌij, che ri ikꞌ y che taq ri chꞌumil; yey taq ri winaq che ruwachulew kasach kinaꞌoj y kakijeq kakixiꞌij kibꞌ che ri nimalaj uchꞌawibꞌal ri mar y che ri yaꞌ lik kel chikaj chwi ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Keqꞌocholaj taq ri winaq, keꞌek ri kinaꞌoj y ketzaq pulew ruma xiꞌin ibꞌ che ri kꞌaxkꞌobꞌik kape che ruwachulew; ma e taq ri kꞌo kichuqꞌabꞌ che ruwa kaj keyikiyoꞌxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Kꞌa tekꞌuchiriꞌ kilitaj Ralaxel Chikixoꞌl Tikawex kakꞌun lo pa sutzꞌ rukꞌ ruchuqꞌabꞌ y rukꞌ runimal uchomalil. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Ekꞌuchiriꞌ kujeq kilitaj wa kꞌutubꞌal, lik chichuqꞌubꞌej iwibꞌ che royꞌexik ri ikolobꞌetajik chwa ri kꞌaxkꞌobꞌik» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ri Jesús xutzijoj kꞌu wa jun kꞌambꞌal naꞌoj chike: «Chiwilape ri cheꞌ re higo y ronoje taq ri cheꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Echiriꞌ kiwilo ketuxik, iwetaꞌam xa naqaj chi kꞌo wi lo ruqꞌijol echiriꞌ kabꞌukbꞌutik y na jinta jabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Jekꞌulaꞌ echiriꞌ kiwilo kuꞌana ronoje taq waꞌ, chiwetaꞌmaj xa naqaj chi kꞌo wi lo ruqꞌijol echiriꞌ ri Dios kataqan puwi ronoje. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Paqatzij wi kambꞌiꞌij chiwe: E kꞌo tikawex re waꞌ wa qꞌij na kekam tana we na xkil tubꞌi ronoje waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ruwa kaj y ruwachulew xa kasach uwach, noꞌj ri nuchꞌaꞌtem na kasach ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","»Lik chichajij iwibꞌ chaꞌ na kiya ta iwibꞌ che taq ri rayinik re ri mak, che ri qꞌabꞌarik y che rubꞌis ikꞌuꞌx re ruwachulew, ma kꞌaxtaj kakꞌun lo ruqꞌijol Ralaxel Chikixoꞌl Tikawex echiriꞌ na iwoyeꞌem taj. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ma rukꞌunibꞌal Rire chikiwach ri e kꞌo che ruwachulew, xaqikꞌateꞌt kuꞌanaꞌ, jelaꞌ pachaꞌ echiriꞌ juna awaj xaqikꞌateꞌt katzaq pa laso re kachapik. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","»Mawar kꞌu iwach, xaqi e chixchꞌaꞌt rukꞌ ri Dios chaꞌ kꞌo ichuqꞌabꞌ chwa wa katajin loq y jelaꞌ taqal chiwe kixkolobꞌetaj chwach ronoje waꞌ, y na kixkꞌix ta kꞌu riꞌ kixtakꞌiꞌ chwach Ralaxel Chikixoꞌl Tikawex echiriꞌ kakꞌun loq» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Ekꞌu riꞌ ri Jesús e taq ri paqꞌij kakꞌutun pa ri Rocho Dios yey e taq ri chaqꞌabꞌ kel bꞌi keꞌkꞌola chwa ri juyubꞌ Olivos. ");
INSERT INTO acrNNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Y konoje ri winaq anim tan kebꞌopon chupa ri Rocho Dios chaꞌ keꞌkita ruchꞌaꞌtem ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Xa naqaj chi kꞌo wi lo ri nimaqꞌij echiriꞌ katij ri pam na jinta levadura che. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Y ri nimaq e aj chakunel pa Rocho Dios kukꞌ taq raj kꞌutunel re ri tzijpixabꞌ lik ketajin che utzukuxik suꞌanik kakiya ri Jesús pa kamik, pero kakixiꞌij kibꞌ kakiꞌan chiwachil kuma rukꞌiyal winaq eteran chirij. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ekꞌu ri Judas aj Iscariot, jun chike ri kabꞌlajuj utijoꞌn ri Jesús, xuya luwar che ri Satanás xok pa ranimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Xeꞌek kꞌu kukꞌ ri nimaq e aj chakunel pa Rocho Dios y kukꞌ ri e aj wach ke ri e chajinel re ri Rocho Dios chaꞌ kachꞌaꞌt kukꞌ puwiꞌ suꞌanik kuya ri Jesús pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Rike lik xekiꞌkot che y xkibꞌiꞌtisij meyo che ri Judas we kuꞌan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ekꞌu rire xuya uchiꞌ che y xujeq kꞌu utzukuxik suꞌanik kuya ri Jesús pakiqꞌabꞌ xa xeꞌlaqꞌay chaꞌ na kakinaꞌbꞌej ta ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xopon kꞌu ri nimaqꞌij echiriꞌ katij ri pam na jinta levadura che. Chupa kꞌu waꞌ wa qꞌij chirajawaxik kekamisax taq ri qꞌapoj bꞌexex re Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Ekꞌu ri Jesús xebꞌutaq bꞌi ri Pedro y ri Juan, jewaꞌ xubꞌiꞌij bꞌi chike: —Jix, jiꞌyijbꞌaꞌ ri cena re Pascua chaꞌ jelaꞌ kaqatijo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Y rike xkitzꞌonoj che: —¿Pa kaꞌaj wi la keꞌqayijbꞌaꞌ wi? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Y ri Jesús xubꞌiꞌij chike: —Chitapeꞌ: Echiriꞌ kixok chupa ri tinamit, kikꞌul jun achi rukꞌaꞌam jun kuraꞌ yaꞌ. Chixterej bꞌi chirij kꞌa chuchiꞌ ri ja pa kok wubꞌi ");
INSERT INTO acrNNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","y chibꞌiꞌij kꞌu che rachi rajaw ja: “Jewaꞌ kubꞌiꞌij ri tijonel qeꞌoj: ¿Pachawi kꞌo wi ri luwar pa kantij wi ri cena re Pascua kukꞌ ri nutijoꞌn?” kixcha che. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ekꞌu ri kuꞌan ri rajaw ja e kukꞌut chiwe jun nimalaj luwar chikaj pa ri kaleꞌ ja, waꞌ yijbꞌital chik. Chiriꞌ kꞌu riꞌ chiyijbꞌaꞌ ri cena re Pascua —xcha ri Jesús chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Xebꞌek kꞌu rutijoꞌn y xeꞌkiriqaꞌ jelaꞌ pachaꞌ ri xubꞌiꞌij bꞌi ri Jesús chike. Y xkiyijbꞌaꞌ kꞌu ri cena re Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Ekꞌuchiriꞌ xopon ruꞌorayil ri cena, ri Jesús junam kukꞌ rutaqoꞌn xebꞌok chwa ri mexa. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Y ri Jesús xubꞌiꞌij chike: —¡Lik nurayim lo utijik junam iwukꞌ wa cena re Pascua chwach pan ri kꞌaxkꞌobꞌik kanwikꞌowibꞌej! ");
INSERT INTO acrNNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ma kambꞌiꞌij kꞌu chiwe na kantij ta chi kꞌu juna chik cena re Pascua iwukꞌ, kꞌate na echiriꞌ kopon ri qꞌij kuꞌana na janipa ri bꞌiꞌtisim loq puwi rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Tekꞌuchiriꞌ, xukꞌam ri kꞌolibꞌal kꞌo vino chupa y xutioxij che ri Dios. Xubꞌiꞌij kꞌu chike rutijoꞌn: —Chikꞌama waꞌ y chitija iwe chuchiꞌ waꞌ wa kꞌolibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Ma kambꞌiꞌij chiwe: Na kantij ta chi ruwaꞌal uva kꞌate na echiriꞌ katikiꞌ rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Tekꞌuchiriꞌ, xukꞌam ri pam y xutioxij che ri Dios. Xuwechꞌo y xujach chike, jekꞌuwaꞌ xubꞌiꞌij: —E nucuerpo waꞌ, ri kayaꞌiꞌ pa kamik iwuma riꞌix. Ekꞌuchiriꞌ kiꞌan taq waꞌ chiqawach apanoq, chiꞌanaꞌ kuxtabꞌal we riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Kꞌisbꞌal kꞌu re ri cena, xukꞌam tanchi ri kꞌolibꞌal kꞌo vino chupa y jewaꞌ xubꞌiꞌij: —Waꞌ ri riꞌ e ri kꞌakꞌ tzij kajikibꞌax uwach rukꞌ ri nukikꞌel katuruw iwuma riꞌix re kuybꞌal imak. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Yey ekꞌu ri kakꞌayin weꞌin, kꞌo wukꞌ junam chwa wa mexa. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ekꞌu Ralaxel Chikixoꞌl Tikawex e karikꞌowibꞌej janipa ri ubꞌiꞌim lo ri Dios puwi Rire. Pero ¡lik kꞌu toqꞌoꞌ uwach rachi kakꞌayin re! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Ekꞌuchiriꞌ xkijeq rutijoꞌn kakitzꞌonobꞌej chikiwach china nawi chike kaꞌanaw waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Rutijoꞌn ri Jesús kakichapalaꞌ kibꞌ chikiwach puwiꞌ chinoq chike más kꞌo uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Noꞌj ri Jesús xubꞌiꞌij chike: «Ri reyes ke ri nimaq tinamit lik kikꞌow uwiꞌ ri kitaqanik kakiꞌan pakiwi ri winaq. Na rukꞌ ta kꞌu riꞌ, kakibꞌiꞌij che kibꞌ: “E toꞌbꞌel ke ri tinamit.” ");
INSERT INTO acrNNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","»Noꞌj riꞌix miꞌan iwe pachaꞌ ri kakiꞌan rike. China ri lik kꞌo uwach chixoꞌl, e chuꞌana pachaꞌ na jinta uwach; yey ri kꞌo puqꞌabꞌ kataqanik, e chuyaꞌa ribꞌ kuꞌan nimanel. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","»Chikiwach ri winaq, ¿china kꞌu ri más kꞌo uwach, e ri katzꞌuyiꞌ chwa ri mexa o e raj chak kaniman chwa ri mexa? ¿Na e ta nebꞌa ri katzꞌuyiꞌ chwa ri mexa? Noꞌj riꞌin in kꞌo chiwach riꞌix pachaꞌ raj chak kanimanik. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Yey riꞌix ix kꞌojiꞌnaq wukꞌ che ri kꞌaxkꞌobꞌik in ikꞌowinaq wi. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","»Kambꞌiꞌij kꞌu chiwe: Pachaꞌ ri Nuqaw uyaꞌom panuqꞌabꞌ riꞌin kintaqanik, jekꞌulaꞌ kanꞌan riꞌin chiwe riꞌix, kanya piqꞌabꞌ kixtaqanik ");
INSERT INTO acrNNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","chaꞌ jelaꞌ kixwaꞌ chwa ri numexa chupa ri nutaqanik y kixtzꞌuyiꞌ kꞌut re kixtaqan pakiwi ri kabꞌlajuj tinamit re Israel» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Ekꞌu ri Qanimajawal xubꞌiꞌij: —¡Simón, Simón, chatapeꞌ! E ri Satanás utzꞌonom che ri Dios chaꞌ kayaꞌtaj che kukꞌam ipa riꞌix. Kixuyikiyaꞌ kꞌu riꞌ jelaꞌ pachaꞌ kaꞌan che ri trigo echiriꞌ kapuꞌ uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Noꞌj riꞌin lik nutzꞌonom che ri Dios pawiꞌ riꞌat, chaꞌ na kasach ta ri kubꞌulibꞌal akꞌuꞌx wukꞌ. Ekꞌu riꞌ riꞌat, echiriꞌ kakubꞌiꞌ tanchi akꞌuꞌx wukꞌ, e chanimarisaj kikꞌuꞌx taq rawachbꞌiꞌil —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Y ri Simón xubꞌiꞌij che: —Wajawal, riꞌin nuyaꞌom wanimaꞌ kinterej chiꞌij la, tobꞌ keꞌek la pa cárcel; yey we xyaꞌ ne la pa kamik, riꞌin kinkam junam ukꞌ la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ekꞌu ri Jesús xukꞌul uwach: —Pedro, paqatzij wi kambꞌiꞌij chawe: Waqꞌabꞌ echiriꞌ kꞌamajaꞌ ne kabꞌixon ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Y chike rutijoꞌn xubꞌiꞌij: —Echiriꞌ xixintaq bꞌi che utzijoxik ri Utzilaj Tzij, ximbꞌiꞌij chiwe na kikꞌam tubꞌi ukꞌolibꞌal imeyo, na kikꞌam tubꞌi itebꞌ, na kikꞌam tubꞌi jun chik molaꞌj ixajabꞌ, ¿kꞌo nebꞌa xajawax chiwe? —xcha chike. Y rike xkikꞌul uwach: —Na jintaj —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ekꞌuchiriꞌ, xubꞌiꞌij chike: —Noꞌj woꞌora, china ri kꞌo ukꞌolibꞌal umeyo, chukꞌama bꞌi; china ri kꞌo utebꞌ, chukꞌama bꞌi; y china ri na jinta espada rukꞌ, chukꞌayij ruqꞌuꞌ re pisbꞌal rij y chuloqꞌo juna espada. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ma kambꞌiꞌij kꞌu chiwe lik chirajawaxik wi e kuꞌana na wa tzꞌibꞌital kan panuwi riꞌin chupa Ruchꞌaꞌtem ri Dios: Xꞌan che pachaꞌ juna aj palajiy tzij kachaꞌ. Ekꞌu janipa ri tzꞌibꞌital kan panuwi riꞌin, e lik kuꞌana na —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ekꞌuchiriꞌ, xkibꞌiꞌij rike che ri Jesús: —Qajawal, riꞌ kebꞌ espada kꞌo qukꞌ —xechaꞌ. Noꞌj rire xubꞌiꞌij chike: —¡Kuꞌan na laꞌ! Mixchꞌaꞌt chi puwi waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Tekꞌuchiriꞌ, xel bꞌi ri Jesús. Xeꞌek chwa ri juyubꞌ Olivos, y rutijoꞌn xeterej bꞌi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Echiriꞌ xebꞌopon chilaꞌ, jewaꞌ xubꞌiꞌij chike: —Lik chitzꞌonoj che ri Dios chaꞌ kichꞌij uchuqꞌabꞌ ri kꞌambꞌal ipa kapetik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ekꞌuchiriꞌ, rire xbꞌin chi pan jubꞌiqꞌ más chikiwach, xuxukubꞌaꞌ ribꞌ y xujeq kachꞌaꞌt rukꞌ ri Dios, ");
INSERT INTO acrNNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","jewaꞌ kubꞌiꞌij: «Lal Nuqaw, we utz chiwach la, chinkolobꞌej ko la chaꞌ na kinikꞌow ta chupa waꞌ wa kꞌaxkꞌobꞌik. Noꞌj na e ta kꞌu chuꞌana ri kuaj riꞌin, ma e chuꞌana janipa ri rajawal kꞌuꞌx Rilal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ekꞌuchiriꞌ, xwinaqir jun ángel re chikaj chwach re koluꞌyaꞌa unimal uchuqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Y chupa kꞌu riꞌ runimal ukꞌaxkꞌolil, ri Jesús xujeq kuꞌan orar rukꞌ unimal uchuqꞌabꞌ. Ruma kꞌu laꞌ xujeqo nimaq tꞌobꞌaꞌj kikꞌ rukꞌatan katzaq chwa rulew. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Echiriꞌ xukꞌis kuꞌan orar, xyaktajik, xtzelej lo pa e kꞌo wi kan rutijoꞌn y xebꞌoꞌluꞌriqaꞌ kewarik ruma ri bꞌis okinaq chikikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xubꞌiꞌij kꞌu chike: —¿Suꞌbꞌe kixwarik? Chixyaktajoq y chitzꞌonoj che ri Dios chaꞌ jelaꞌ kichꞌij uchuqꞌabꞌ ri kꞌambꞌal ipa kapetik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Kꞌa kachꞌaꞌt ne ri Jesús, echiriꞌ xebꞌopon ukꞌiyal winaq lik kewoqoqik. Yey ri Judas, jun chike ri kabꞌlajuj utijoꞌn ri Jesús, nabꞌe bꞌi chikiwach rukꞌiyal winaq. Rire xqibꞌ rukꞌ ri Jesús chaꞌ kutzꞌubꞌ uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Ekꞌu ri Jesús xubꞌiꞌij che: —Judas, ¿e laꞌ rukꞌ jun tzꞌubꞌuj chiꞌaj kakꞌayij Ralaxel Chikixoꞌl Tikawex? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Ri e kꞌo rukꞌ ri Jesús, echiriꞌ xkilo saꞌ ri katajinik, xkitzꞌonoj che: —Qajawal, ¿utz nawi kojchꞌoꞌjin rukꞌ espada? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ekꞌuchiriꞌ, jun chike rutijoꞌn xujochij bꞌi ruxikin uwikiqꞌabꞌ ri raj chak ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Pero ri Jesús xubꞌiꞌij chike: —¡Miꞌan chi waꞌ! —xchaꞌ. Xuchap kꞌu ruxikin raj chak y xukunaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Tekꞌuchiriꞌ, xubꞌiꞌij chike ri e petinaq che uchapik bꞌi, waꞌ e ri nimaq e aj chakunel pa Rocho Dios, ri e aj wach ke ri e chajinel re ri Rocho Dios y ri nimaq winaq re ri tinamit: —¿Suꞌchak petinaq alaq rukꞌ espada y cheꞌ? ¿Petinaq kami alaq che ukꞌamik bꞌi juna eleqꞌom? ");
INSERT INTO acrNNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Ronoje qꞌij waꞌ kꞌut in kꞌo ukꞌ alaq pa ri Rocho Dios. ¿Suꞌchak kꞌu riꞌ kꞌa e laꞌ kinoꞌlchapa alaq? Noꞌj ekꞌu waꞌ xopon ri ora yaꞌtal che alaq echiriꞌ ri rajaw ri qꞌequꞌm kukꞌut ruchuqꞌabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Xkichap kꞌu bꞌi ri Jesús y xkikꞌam bꞌi chirocho ri kajawal raj chakunel pa Rocho Dios. Y ri Pedro chinimanaj teran pan chirij. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","E kꞌo kꞌu jujun xkinukꞌ aqꞌ che ruwa ja, y xetzꞌuyiꞌ chuchiꞌ ri aqꞌ. Yey ri Pedro xtzꞌuyiꞌ chikixoꞌl. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Kꞌo kꞌu jun ali aj chak xril ri Pedro tzꞌul chuchiꞌ ri aqꞌ. Rali lik xutzutzaꞌ uwach y jewaꞌ xubꞌiꞌij: —Waꞌ waꞌchi e jun chike ri eteran chirij ri Jesús —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Noꞌj ri Pedro jewaꞌ xubꞌiꞌij che: —Ali, riꞌin na wetaꞌam ta uwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Joqꞌotaj kꞌu riꞌ kꞌo jun achi xrilo y jewaꞌ xubꞌiꞌij che: —Rilal lal jun chike rutijoꞌn ri Jesús —xchaꞌ. Noꞌj ri Pedro xubꞌiꞌij che rachi: —Riꞌin na in ta jun chike rutijoꞌn —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Laj pa jun ora kꞌu riꞌ kꞌo tanchi jun jewaꞌ xubꞌiꞌij: —Paqatzij wi waꞌ waꞌchi e jun chike rutijoꞌn ri Jesús, ma aj Galilea —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Noꞌj ri Pedro xubꞌiꞌij che: —Achi, riꞌin na wetaꞌam tane saꞌ puwiꞌ kachꞌaꞌt la —xchaꞌ. Kꞌa kachꞌaꞌt ne ri Pedro echiriꞌ xbꞌixon lo ri teren. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ekꞌuchiriꞌ, ri Qanimajawal xtzuꞌn lo chirij y e xutzuꞌ lo uwach ri Pedro. Ekꞌu ri Pedro xkꞌun chukꞌuꞌx saꞌ rubꞌiꞌim kan ri Qanimajawal che: «Kꞌamajaꞌ ne kabꞌixon ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach.» ");
INSERT INTO acrNNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Ewi ri Pedro xel bꞌi chiriꞌ y lik xoqꞌik ruma rukꞌaxkꞌolil ukꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Rachijabꞌ echajiyom re ri Jesús lik kakichꞌamij y lik kakichꞌayo. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Kakichꞌuq ruwach y kakitzꞌonoj che: —¡Chanaꞌij peꞌ china xchꞌayaw awe! —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lik qabꞌichi ri kakibꞌiꞌij che rukꞌ kꞌaxlaj chꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Echiriꞌ xsaqirik, xkimol kibꞌ ri nimaq winaq re ri tinamit, ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ; waꞌ e taq ri uchapom wi ribꞌ ri qꞌatbꞌal tzij. Rike xkitaq ukꞌamik ri Jesús chikiwach y jewaꞌ xkibꞌiꞌij che: ");
INSERT INTO acrNNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Chabꞌiꞌij chiqe we at ri Cristo, Ruchaꞌoꞌn lo ri Dios —xechaꞌ. Y ri Jesús xubꞌiꞌij chike: —Tobꞌ kambꞌiꞌij che alaq “In”, na kakoj ta alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Yey we kanꞌan tzꞌonobꞌal che alaq, na kakꞌul ta alaq uwach y na kintzoqopij tane ubꞌi alaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Pero Ralaxel Chikixoꞌl Tikawex katzꞌuyiꞌ na kꞌu puwikiqꞌabꞌ ri Dios, ri lik kꞌo unimal uchuqꞌabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Tekꞌuchiriꞌ, konoje xkitzꞌonoj che ri Jesús: —¿At peꞌ riꞌ Rukꞌajol ri Dios? —xecha che. Y ri Jesús xukꞌul uwach: —E ralaq xbꞌiꞌn alaq re, e riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Ekꞌuchiriꞌ, xkibꞌiꞌij rike: —Na jinta chi uchak más e aj kojol umak, ma lik oj xojtaw re ri xubꞌiꞌij rukꞌ ruwa reꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ekꞌuchiriꞌ, xeyaktaj konoje ri kimolom kibꞌ y xkikꞌam bꞌi ri Jesús chwach ri Pilato. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Y xkijeq kꞌu kakitzꞌaq uchiꞌ, jewaꞌ kakibꞌiꞌij: —Qariqom wa jun achi kusachisaj kinaꞌoj ri qatinamit, kebꞌuqꞌatej ri winaq chaꞌ na kakiꞌan ta ri tojonik kaꞌan che ri nimalaj taqanel re Roma y kubꞌiꞌij e rire ri Cristo, ri chaꞌtal lo ruma ri Dios re kataqan pakiwi raj judiꞌabꞌ —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Xutzꞌonoj kꞌu ri Pilato che ri Jesús: —¿Lal kami riꞌ ri rey ke raj judiꞌabꞌ? —xchaꞌ. Y ri Jesús xubꞌiꞌij che: —Lal kabꞌiꞌn la re —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Ri Pilato xubꞌiꞌij kꞌu chike ri nimaq e aj chakunel pa Rocho Dios y chike konoje ri winaq: —Chinuwach riꞌin, wa jun achi na jinta umak —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pero ri winaq más ko kesikꞌinik, jewaꞌ kakibꞌiꞌij: —Rukꞌ ri kukꞌutu lik katajin usachik kinaꞌoj ri tikawex chupa taq ri luwar re Judea; xujeq lo waꞌ Galilea y woꞌora jelaꞌ kuꞌan wara Jerusalem —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Echiriꞌ ri Pilato xuto petinaq ri Jesús Galilea, xutzꞌonobꞌej we rire aj chilaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Y echiriꞌ xretaꞌmaj aj Galilea ri Jesús, xutaq bꞌi chwach ri Herodes, ma rire e rey re chilaꞌ, yey laꞌ laꞌ qꞌij wi kꞌo ri Herodes chiriꞌ Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ekꞌuchiriꞌ ri Herodes xril uwach ri Jesús, lik xkiꞌkotik, ma lik kꞌo tan qꞌij riꞌ urayim karil uwach. Ma saꞌch taq ri utom che yey royeꞌem karil uwach chaꞌ ri Jesús kuꞌan juna kꞌutubꞌal re ruchuqꞌabꞌ chwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Y xujeq kꞌu uꞌanik ukꞌiyal tzꞌonobꞌal che, pero ri Jesús na kukꞌul ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ekꞌu ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj kꞌutunel re ri tzijpixabꞌ, lik kesikꞌin che ukojik umak ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Ewi ri Herodes kukꞌ rusoldados lik xkikꞌaq bꞌi uqꞌij ri Jesús; xkiꞌan che pachaꞌ juna rey, xkikoj bꞌi jun chomilaj kꞌul che re chꞌamibꞌal re. Tekꞌuchiriꞌ, xtaqan che kakꞌam tanchi ubꞌi chwach ri Pilato. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Chupa laꞌ la jun qꞌij ri Pilato y ri Herodes xkijeq kechꞌaw tanchi chikiwach, ma e ri petinaq loq lik tzel kakil kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Ekꞌu ri Pilato xumol kichiꞌ ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj wach re ri tinamit yey taq ri winaq, ");
INSERT INTO acrNNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","y jekꞌuwaꞌ xubꞌiꞌij chike: —Kꞌamom lo alaq wa jun achi chinuwach y kabꞌiꞌij alaq rire katajin che usachik kinaꞌoj ri winaq re ri tinamit. Noꞌj riꞌin xinꞌan tzꞌonobꞌal che y xinta uchiꞌ chiwach alaq, yey na jinta juna mak nuriqom chirij pachaꞌ ri mak kakoj alaq che. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Y jenelaꞌ ri rey Herodes, na jinta juna mak xuriq che; ma xintaq bꞌi chwach, yey rire xutaq tanchi lo wukꞌ. Qꞌalaj kꞌu riꞌ na jinta mak uꞌanom re taqal che kakamisaxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","E uwariꞌche xew kanya pa kꞌax; tekꞌuchiriꞌ kanyolopij bꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","(Xubꞌiꞌij waꞌ ma ronoje junabꞌ chupa ri nimaqꞌij Pascua, ri Pilato xex kuꞌan wi kuyolopij bꞌi jun preso chikiwach ri winaq.) ");
INSERT INTO acrNNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Noꞌj konoje rukꞌiyal winaq junam lik ko xesikꞌin che ubꞌiꞌxikil: —¡E taqa bꞌi la ri Jesús pa kamik yey yolopij bꞌi la ri Barrabás! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Waꞌchi Barrabás yaꞌom pa cárcel ruma utitzꞌitikil uꞌanom Jerusalem chirij ri gobierno romano y ruma jun kamik xuꞌano.) ");
INSERT INTO acrNNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Ri Pilato xchꞌaꞌt tanchi kukꞌ ri winaq, ma rire e karaj kuyolopij bꞌi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Noꞌj ri winaq xesikꞌin tanchi che ubꞌiꞌxikil: —¡Kamisax chwa cruz! ¡Kamisax chwa cruz! —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Churox laj kꞌu riꞌ ri Pilato jewaꞌ xubꞌiꞌij: —¿Saꞌ kꞌu rumak waꞌchi uꞌanom? Ma riꞌin na jinta juna mak nuriqom chirij re taqal che kakamisaxik. Kanya na pa kꞌax, tekꞌuchiriꞌ kanyolopij bꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Noꞌj ri winaq na kakitanabꞌaꞌ taj lik ko kesikꞌin che utzꞌonoxik kakamisax ri Jesús chwa cruz. Kꞌisbꞌal kꞌu re, xyaꞌtaj na chike ri kakaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Ewi ri Pilato xutaq uꞌanik ri kakitzꞌonoj: ");
INSERT INTO acrNNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","xuyolopij kꞌu bꞌi ri jun yaꞌom pa cárcel ruma utitzꞌitikil uꞌanom chirij ri gobierno romano y ruma jun kamik xuꞌano, ma e xkitzꞌonoj riꞌ ri winaq. Y xuya luwar kakamisax ri Jesús, jelaꞌ pachaꞌ ri kakaj rike. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ekꞌuchiriꞌ, ri soldados xkikꞌam bꞌi ri Jesús re keꞌkikamisaj chwa ri cruz. Echiriꞌ kꞌo chi bꞌe, xkichap bꞌi jun achi aj Cirene, Simón rubꞌiꞌ, petinaq pa juyubꞌ e riꞌ kikꞌow chiriꞌ. Y xkiya bꞌi ri cruz chwi utelebꞌ chaꞌ kutelej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Y lik ukꞌiyal winaq eteran bꞌi. Y e kꞌo ixoqibꞌ chikixoꞌl lik ketunanik y kakoqꞌej ri Jesús, ma lik kꞌax unaꞌom kikꞌuꞌx ruma ri kaꞌan che. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Noꞌj ri Jesús xebꞌutzuꞌ pan rixoqibꞌ kebꞌoqꞌik y jewaꞌ xubꞌiꞌij chike: —Ixoqibꞌ ix aj Jerusalem, miniwoqꞌej riꞌin; e chiwoqꞌej ri katajin lo piwi riꞌix y pakiwiꞌ ri iwalkꞌoꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","¡Chitapeꞌ! Kopon na ri qꞌij echiriꞌ kabꞌiꞌxik: “Nim kiqꞌij kalaxik rixoqibꞌ na kebꞌalan taj kukꞌ ri na jinta kalkꞌoꞌal y ri na ketzꞌumtisan taj” jelaꞌ kabꞌiꞌxik. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Ruma kꞌu riꞌ ri unimal kꞌaxkꞌobꞌik e kꞌo wi, ri winaq kakaj kekamik y jekꞌuwaꞌ kakibꞌiꞌij che taq ri juyubꞌ nimaꞌq y chꞌutiꞌq: Chix-tzaqa lo paqawiꞌ re kichꞌuq qawiꞌ kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ma we kayaꞌ pa kamik junoq na jinta umak, ¿saꞌ kꞌu riꞌ ri kakikꞌulumaj ri lik kꞌo kimak? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yey ekꞌamom bꞌi junam rukꞌ ri Jesús kaꞌibꞌ eleqꞌomabꞌ chaꞌ kekamisax chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Echiriꞌ xebꞌopon pa ri luwar kabꞌiꞌx che “Luwar re Ubꞌaqil Ujolom Animaꞌ”, chiriꞌ xyaꞌ wi ri Jesús chwa ri cruz; y ri kaꞌibꞌ eleqꞌomabꞌ, jun xyaꞌ puwikiqꞌabꞌ y jun pumox Rire. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ewi ri Jesús xubꞌiꞌij: —Nuqaw, kuyu la kimak, ma na kimajom ta usukꞌ saꞌ wa ketajin che uꞌanik —xchaꞌ. Ekꞌu ri soldados rukꞌ jun sorteo xkijach kibꞌ puwi ruqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Y rukꞌiyal winaq xa kakitzutzaꞌ ri katajin uꞌanik. Yey ne raj wach re ri tinamit kakichꞌamij ri Jesús, jewaꞌ kakibꞌiꞌij: —Lik waꞌ kꞌut e kꞌi ri xebꞌukolobꞌej che taq yabꞌil y che kamik. We ta rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios, chukolobꞌej ribꞌ riꞌ woꞌora, —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Jekꞌulaꞌ riꞌ xkiꞌan ri soldados, lik kakichꞌamij ri Jesús. Keqibꞌ rukꞌ y kakibꞌiꞌtisij vinagre che re kutijo, ");
INSERT INTO acrNNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","y jewaꞌ kakibꞌiꞌij che: —We ta paqatzij wi at ri rey ke raj judiꞌabꞌ, chakolobꞌej kꞌu awibꞌ riꞌ —kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Chwi kꞌu lo ri cruz re ri Jesús, pa ri chꞌaꞌtem griego, pa ri chꞌaꞌtem latín y pa ri chꞌaꞌtem hebreo tzꞌibꞌital waꞌ: «WAꞌ E REY KE RAJ JUDIꞌABꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Y jun chike ri kaꞌibꞌ eleqꞌomabꞌ eyaꞌom chwa cruz, lik kuchꞌamij ri Jesús, jewaꞌ kubꞌiꞌij: —¿Na at ta nebꞌa ri Cristo, Ruchaꞌoꞌn lo ri Dios? Chakolobꞌej kꞌu awibꞌ riꞌ junam qukꞌ riꞌoj —kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Noꞌj ri jun chik eleqꞌom xuyajo, jewaꞌ xubꞌiꞌij che ri rachbꞌiꞌil: —Riꞌat na kaxiꞌij ta kꞌana awibꞌ chwach ri Dios, yey junam oj kꞌo pa wa kꞌaxkꞌobꞌik qꞌatom paqawiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Riꞌat y riꞌin paqatzij wi, taqal chiqe kaqakꞌulumaj waꞌ, ma e tojbꞌal re ri na utz taj qaꞌanom. Noꞌj waꞌchi na jinta umak —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ekꞌuchiriꞌ, xubꞌiꞌij che ri Jesús: —Wajawal, chinkꞌuna ko chikꞌuꞌx la echiriꞌ koꞌltaqana la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Y ri Jesús xubꞌiꞌij che: —Paqatzij wi kambꞌiꞌij chawe: Waqꞌij ne riꞌ katopon wukꞌ chilaꞌ chupa ri chomilaj luwar pa e kꞌo wi ri e kolobꞌetajinaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Echiriꞌ xtikꞌoj ri qꞌij, xok qꞌequꞌm che ruwachulew y waꞌ xuꞌkꞌisa kꞌa che ri urox ora bꞌenaq qꞌij; ");
INSERT INTO acrNNT_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","oxibꞌ ora na xwon ta ri qꞌij. Yey chupa kꞌu ri Rocho Dios, ri telón xrichꞌrobꞌ lo chunikꞌajal. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ekꞌuchiriꞌ, ri Jesús lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: —Nuqaw, paqꞌabꞌ la kanqꞌatisaj wi ri wanimaꞌ —xchaꞌ. Xew xubꞌiꞌij waꞌ, asu xkamik. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Ri capitán ke ri soldados echiriꞌ xrilo saꞌ ri xuꞌano, xuyak uqꞌij ri Dios, jewaꞌ xubꞌiꞌij: —Paqatzij wi waꞌchi lik jusukꞌ y na jinta umak —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ekꞌu rukꞌiyal winaq echiriꞌ xkilo saꞌ ri xuꞌano, xebꞌel chiriꞌ, kakitꞌiqitꞌaꞌ ruwa kikꞌuꞌx ruma kixiꞌin ibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yey kꞌu ri lik xketaꞌmaj uwach ri Jesús kukꞌ taq rixoqibꞌ e petinaq rukꞌ chwi xel lo Galilea, rike xekꞌojiꞌ pana chinimanaj y xkil ronoje ri xuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Kꞌo kꞌu jun achi José rubꞌiꞌ, aj Arimatea, jun tinamit re Judea. Rire e jun chike ri uchapom wi ribꞌ ri qꞌatbꞌal tzij, jun achi lik utz ukꞌuꞌx y lik jusukꞌ rubꞌinik usilabꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Yey lik royeꞌem rukꞌunibꞌal rutaqanik ri Dios. Ekꞌu rire lik na xukꞌul ta ukꞌuꞌx ri xkiꞌan ri rachbꞌiꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Xopon kꞌu chwach ri Pilato y xuꞌtzꞌonoj che kayaꞌ luwar che kumuq rucuerpo ri Jesús. Y xyaꞌ luwar che. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Xeꞌek kꞌut y xuꞌqasaj lo rucuerpo chwa ri cruz. Xupis kꞌu chupa jun manta. Tekꞌuchiriꞌ, xuꞌyaꞌa pa jun muqubꞌal kꞌotom paꞌbꞌaj, yey waꞌ na jinta junoq muqum chupa. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ekꞌu bꞌenaq qꞌij riꞌ echiriꞌ raj judiꞌabꞌ kakiyijbꞌaꞌ pan janipa ri kajawax chike pa ri qꞌij re uxlanibꞌal, y waꞌ ya kopon ru orayil. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Yey rixoqibꞌ e petinaq lo Galilea rukꞌ ri Jesús, xeterej bꞌi chirij ri José y xkil ri muqubꞌal pa xkiya wi kan rucuerpo ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Echiriꞌ xetzelej loq, xkijeqelaꞌ uyijbꞌaxik kunabꞌal lik kiꞌ ruxlabꞌ chaꞌ keꞌkikojo che rucuerpo ri Jesús. Ekꞌuchiriꞌ xok ri qꞌij re uxlanibꞌal, xebꞌuxlan kꞌut pachaꞌ ri kubꞌiꞌij Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ri nabꞌe qꞌij re ri semana lik anim tan rixoqibꞌ e petinaq lo Galilea y jujun chik ixoqibꞌ, xebꞌek pa muqutal wi ri Jesús, yey kukꞌaꞌam bꞌi kunabꞌal lik kiꞌ ruxlabꞌ, ri kiyijbꞌam bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Yey xeꞌkiriqa rabꞌaj esam chi chuchiꞌ ri muqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Xebꞌok kꞌu bꞌi chupa ri muqubꞌal, pero na xkiriq ta chi rucuerpo ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lik kꞌut bꞌenaq ri kinaꞌoj puwi waꞌ, echiriꞌ xaqikꞌateꞌt xewinaqir kaꞌibꞌ achijabꞌ chikiwach, lik kawolqꞌin ri kiqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Rixoqibꞌ lik xkixiꞌij kibꞌ y xkiqasaj ri kipalaj pulew. Ekꞌu ri kaꞌibꞌ achijabꞌ xkibꞌiꞌij chike: —¿Suꞌchak kitzukuj chikixoꞌl ri ekaminaq ri Jun kꞌaslik? ");
INSERT INTO acrNNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Rire na jinta chi wara, ma kꞌastajinaq chi lo chikixoꞌl ri ekaminaq. Kꞌuna chikꞌuꞌx saꞌ rubꞌiꞌim lo chiwe echiriꞌ kꞌa kꞌo Galilea, ");
INSERT INTO acrNNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","echiriꞌ xubꞌiꞌij: “Lik chirajawaxik wi Ralaxel Chikixoꞌl Tikawex kayaꞌ pakiqꞌabꞌ achijabꞌ aj makibꞌ chaꞌ kakamisax chwa cruz, noꞌj Rire kakꞌastaj lo churox qꞌij” —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Kꞌa ekꞌuchiriꞌ xkꞌun chikikꞌuꞌx rixoqibꞌ ruchꞌaꞌtem ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Echiriꞌ xetzelej lo chilaꞌ pa ri muqubꞌal, xkitzijoj ronoje waꞌ chike ri junlajuj taqoꞌn y chike konoje ri e kꞌo kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ekꞌu ri xetzijon waꞌ e ri María ri aj Magdala, ri Juana, ri María uchu ri Santiago y jujun kachbꞌiꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yey ri taqoꞌn na xkikoj ta ri xkitzijoj rixoqibꞌ, ma e chikiwach rike, wa ixoqibꞌ echꞌuꞌjerinaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ekꞌu ri Pedro xyaktaj bꞌi y lik kanik xeꞌek pa kꞌo wi ri muqubꞌal re ri Jesús. Y echiriꞌ xochꞌin pan chupa, xrilo xew chi kꞌo kan ri jutaq rabꞌaꞌj kꞌul pa xbꞌolqꞌotix wi ri Jesús. Xeꞌek kꞌut lik kaminaq ranimaꞌ che ri xrilo y kutzꞌonoj chiribꞌil ribꞌ saꞌ nawi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Chupa laꞌ laꞌ qꞌij, kaꞌibꞌ chike rutijoꞌn kebꞌin chupa ri bꞌe re keꞌek pa raldea Emaús, waꞌ kꞌo lo pa once kilómetro che ri tinamit Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Xaloqꞌ kꞌu kebꞌin chupa ri bꞌe, rike kechꞌaꞌt chikiwach puwi ri kꞌakꞌ ikꞌowinaq. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Yey echiriꞌ kechꞌaꞌt chikiwach, ri Jesús xqibꞌ kukꞌ y xerachbꞌilaj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Pero rike pachaꞌ chꞌuqutal ri kiwach, ma tobꞌ xkilo na xketaꞌmaj ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Ekꞌu ri Jesús xubꞌiꞌij chike: —¿Saꞌ puwiꞌ kachꞌaꞌt wi alaq chupa wa bꞌe? ¿Y suꞌchak kabꞌison alaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun kꞌu chike, Cleofas rubꞌiꞌ, xukꞌul uwach, jewaꞌ xubꞌiꞌij: —Laj xew rilal chike konoje ri ebꞌinel e kꞌo Jerusalem na etaꞌam ta la saꞌ ri kꞌakꞌ ikꞌowinaq chupa taq waꞌ wa qꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Xubꞌiꞌij kꞌu ri Jesús chike: —¿Saꞌ ri xuꞌano? —xchaꞌ. Ewi xkibꞌiꞌij che: —E kojchꞌaꞌt puwi ri xukꞌulumaj ri Jesús ri aj Nazaret, ri nimalaj qꞌalajisanel lik kꞌo uchuqꞌabꞌ che taq ri kuꞌano y ri kubꞌiꞌij; rire lik yakom uqꞌij ruma ri Dios y kuma taq ri tikawex re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Yey ri nimaq e aj chakunel pa Rocho Dios kukꞌ raj wach re ri qatinamit xkiya puqꞌabꞌ ri taqanel romano chaꞌ kaqꞌat tzij puwiꞌ y kakamisax chwa cruz. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Chwi kꞌu rukamik e urox qꞌij waꞌ. Yey riꞌoj xkubꞌiꞌ qakꞌuꞌx e rire ri kukolobꞌej ri qatinamit Israel. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","»Yey kisachisam ne qanaꞌoj jujun ixoqibꞌ ebꞌare jun chiqaxoꞌl riꞌoj oj utijoꞌn kan ri Jesús. Ma rike lik anim tan xebꞌopon chupa rumuqubꞌal, ");
INSERT INTO acrNNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","pero na xkiriq ta chi rucuerpo ri Jesús. Xetzelej kꞌu lo qukꞌ, kakitzijoj chiqe xewinaqir jujun ángeles chikiwach, yey waꞌ xkibꞌiꞌij chike: “Rire kꞌastajinaq chi lo chikixoꞌl ri ekaminaq.” ");
INSERT INTO acrNNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Xebꞌek kꞌu jujun chiqe riꞌoj chupa rumuqubꞌal y e xkilo jelaꞌ pachaꞌ ri kibꞌiꞌim rixoqibꞌ chiqe. Noꞌj na xkil ta uwach ri Jesús —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ekꞌu ri Jesús xubꞌiꞌij chike: —¡Toqꞌoꞌ wach alaq ma lik na kamaj ta alaq usukꞌ y kamayin alaq che ukojik janipa ri kibꞌiꞌim kan ri qꞌalajisanelabꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Na chirajawaxik ta nebꞌa ri Cristo, Ruchaꞌoꞌn lo ri Dios, kutij na ronoje wa kꞌaxkꞌobꞌik y tekꞌuchiriꞌ keꞌek chilaꞌ chikaj pa kayak wi uqꞌij? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Xuqꞌalajisaj kꞌu chike ronoje ri kubꞌiꞌij chupa Ruchꞌaꞌtem ri Dios chwi Rire, xujeq lo rukꞌ ri tzꞌibꞌital kan ruma ri Moisés yey tekꞌuchiriꞌ xuqꞌalajisaj janipa ri tzꞌibꞌital chwi Rire kuma konoje ri qꞌalajisanelabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Ekꞌuchiriꞌ xebꞌopon chupa raldea pa kebꞌek wi ri kebꞌ achijabꞌ, ri Jesús xuꞌan pachaꞌ e riꞌ xumaj chubꞌi rubꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Pero rike lik xebꞌelaj che kakanaj kan kukꞌ, jewaꞌ xkibꞌiꞌij che: —Kanaj kan la qukꞌ, ma bꞌenaq chi ri qꞌij yey ya kok raqꞌabꞌ —xechaꞌ. Ri Jesús xok kꞌu bꞌi y xkanaj kan chiriꞌ kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Echiriꞌ e kꞌo chi chwa ri mexa, xukꞌam ri pam y xtioxin chwach ri Dios, xuwechꞌ kꞌu upa y xuya chike. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Kꞌa ekꞌuchiriꞌ xjaqataj ri kiwach y xketaꞌmaj uwach. Pero ri Jesús e laꞌ chikiwach xmalkaꞌnik. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Xkibꞌiꞌij kꞌu riꞌ chikiwach: —¿Na kamiqꞌmot ta nebꞌa qakꞌuꞌx che kiꞌkotemal echiriꞌ rire kachꞌaꞌt qukꞌ pa ri bꞌe y kuqꞌalajisaj chiqe Rutzij Upixabꞌ ri Dios? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Na jampatana xeyaktajik y xetzelej Jerusalem. Chiriꞌ xebꞌoꞌlkiriqa ri junlajuj taqoꞌn kimolom kibꞌ kukꞌ ri kachbꞌiꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Y rike xkibꞌiꞌij chike wa kaꞌibꞌ: «¡Paqatzij wi kꞌastajinaq lo ri Qanimajawal Jesucristo ma xilitaj uwach ruma ri Simón!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Yey la kaꞌibꞌ xkijeq utzijoxik saꞌ ri xkikꞌulumaj chupa ri bꞌe echiriꞌ xebꞌek Emaús y suꞌanik xketaꞌmaj uwach ri Jesús echiriꞌ xuwechꞌ upa ri pam. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Kꞌa ketajin ne che uchꞌaꞌtibꞌexik ri kilom y ri kitom, echiriꞌ ri Jesús xwinaqir chikiwach, xaqikꞌateꞌt xtakꞌiꞌ chikixoꞌl y jewaꞌ xubꞌiꞌij chike: —Kꞌola utzil chomal iwukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yey rike lik xkixiꞌij kibꞌ che, ma e chikiwach rike laj juna espíritu ri kakitzutzaꞌ uwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Noꞌj ri Jesús xubꞌiꞌij chike: —¿Suꞌchak kuxiꞌij ribꞌ ikꞌuꞌx y na kikoj taj we in kꞌaslik? ");
INSERT INTO acrNNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Chiwilape ri nuqꞌabꞌ y ri waqan; chichapape rukꞌ riqꞌabꞌ y jelaꞌ kiwil chi utz lik in ri in kꞌo iwukꞌ y na xa ta in juna espíritu, ma juna espíritu na jinta utiꞌjil y na jinta ubꞌaqil pachaꞌ ri kiwil chwe riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Y ekꞌuchiriꞌ kubꞌiꞌij waꞌ, xukꞌut ruqꞌabꞌ y ri raqan chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ekꞌu rike lik kekiꞌkotik y kaminaq kanimaꞌ che yey na kakiriq taj suꞌanik kakikoj ri kakilo. Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike: —¿Saꞌ ri kꞌo iwukꞌ re katijik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Xkiya kꞌu che, juchꞌaqap kar bꞌolom y uwaꞌal kabꞌ kꞌa kꞌo pa cera. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ewi Rire xukꞌamo y xutij chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ekꞌuchiriꞌ, xubꞌiꞌij chike: —E nubꞌiꞌim lo waꞌ chiwe echiriꞌ kꞌa in kꞌo iwukꞌ: Lik chirajawaxik wi kuꞌana na janipa ri tzꞌibꞌital kan panuwi riꞌin chupa ri Tzij Pixabꞌ re ri Moisés, chupa ri kitzꞌibꞌam kan ri qꞌalajisanelabꞌ y chupa taq ri Salmos —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Kꞌa tekꞌuchiriꞌ xujaq ri kinaꞌoj chaꞌ kakimaj usukꞌ chi utz Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xubꞌiꞌij kꞌu chike: —Jewaꞌ ri tzꞌibꞌital kan pa Ruchꞌaꞌtem ri Dios: Lik chirajawaxik wi ri Cristo, Ruchaꞌoꞌn lo ri Dios, kutij kꞌax, kakamik y kakꞌastaj lo churox qꞌij; ");
INSERT INTO acrNNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","y chupa kꞌu rubꞌiꞌ, katzijox ri Utzilaj Tzij re tzelebꞌal tzij y re kuybꞌal mak chike konoje rukꞌiyal kiwach taq ri tikawex e kꞌo che ruwachulew, yey kajeqer utzijoxik waꞌ Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Riꞌix kibꞌiꞌij kꞌu riꞌ chike ri winaq janipa taq wa xiwilo y xito. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chitapeꞌ: Riꞌin kantaq lo piwi riꞌix ri Jun ubꞌiꞌtisim lo ri Nuqaw; pero chixkꞌola wara chupa wa tinamit Jerusalem chaꞌ kiwoyꞌej na kikꞌul wa chuqꞌabꞌ kape chilaꞌ chikaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ekꞌuchiriꞌ, ri Jesús xebꞌukꞌam bꞌi rutijoꞌn y xebꞌek chunaqaj Betania. Xuyak kꞌu ruqꞌabꞌ pakiwiꞌ y xebꞌuꞌan bendecir. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Echiriꞌ katajin che uꞌanik waꞌ, xujeqo xel bꞌi chikixoꞌl y xkꞌam kꞌu bꞌi chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ewi rutijoꞌn lik xkiloqꞌnimaj uqꞌij ri Jesús. Tekꞌuchiriꞌ xetzelej chupa ri tinamit Jerusalem rukꞌ unimal kiꞌkotemal chupa ri kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Y xaqi e kꞌo chupa ri Rocho Dios, kebꞌixonik y kakiyak uqꞌij ri Dios. Amén. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Che ri jeqebꞌal lo re ruwachulew, xex chi kꞌo lo wi ri Tzij; ri Tzij xex chi kꞌo lo wi rukꞌ ri Dios yey ri Tzij e ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ekꞌu ri Jun kabꞌiꞌx “Ri Tzij” che, xex chi kꞌo lo wi rukꞌ ri Dios chwi echiriꞌ kꞌamajaꞌ ne kajeqer lo ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ruma ne Rire, ri Dios xuꞌan ronoje ri kꞌo che ruwachulew. We tamaji Rire, na kuꞌan ta riꞌ ri Dios janipa ri kꞌolik. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Rukꞌ kꞌu Rire kꞌo wi ri kꞌaslemal, yey wa kꞌaslemal e Qꞌijsaq chike ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ri Qꞌijsaq kawon chupa ri qꞌequꞌm, y ri qꞌequꞌm na kuchꞌij ta kꞌana uchupik. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Kꞌo jun achi Juan rubꞌiꞌ yey rire taqom lo ruma ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ri Juan xkꞌunik chaꞌ kuqꞌalajisaj ri Qꞌijsaq. Xoluꞌtzijoj kꞌu ri Qꞌijsaq chaꞌ jelaꞌ ri tikawex kakikoj ri Qꞌijsaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Ri Juan na e ta ri Qꞌijsaq, pero rire xkꞌunik re koꞌltzijon puwi ri Qꞌijsaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ri saqil Qꞌijsaq kꞌuninaq che ruwachulew, e kaqꞌalajisan runaꞌoj ri Dios chikiwach taq ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Tobꞌ Rire e ꞌanayom re ronoje ri kꞌo che ruwachulew; echiriꞌ xkꞌun che ruwachulew, taq ri winaq na xketaꞌmaj ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Rire xkꞌun kukꞌ rutinamit, pero rutinamit na xkikꞌul taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Konoje kꞌu riꞌ ri xkikꞌulu y xkikoj rubꞌiꞌ, xyaꞌtaj chike kebꞌuꞌan e ralkꞌoꞌal ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ekꞌu rike xebꞌuꞌan ralkꞌoꞌal ri Dios, na kuma ta ri kichu-kiqaw na ruma ta rayibꞌal ke tikawex, yey na ruma tane ri xraj juna achi; ma e ruma ri xraj ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ekꞌu wa Tzij xuꞌan achi, xjeqiꞌ kꞌu chiqaxoꞌl riꞌoj, y xqil runimal uchomalil. Y wa unimal uchomalil e ri xuya ri Dios che Rire ruma xew Ukꞌajol riꞌ, yey Rire lik kꞌo unimal rutzil kꞌuꞌxaj y saqil Qꞌijsaq rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ri Juan xtzijon chwi Rire, jewaꞌ xubꞌiꞌij: «Puwi Rire nubꞌiꞌim chi lo waꞌ: E ri Jun katajin lo chwij, más kꞌo uwach chinuwa riꞌin ma Rire xex chi kꞌo lo wi echiriꞌ kꞌamajaꞌ kinalax riꞌin» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Che ronoje taq ri kꞌo puqꞌabꞌ, qakꞌamom ko qeꞌoj, ma ri unimal rutzil ukꞌuꞌx qukꞌ xaqi uleꞌom ribꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ri Tzij Pixabꞌ xyaꞌ ruma ri Moisés; noꞌj ri unimal rutzil ukꞌuꞌx ri Dios y ri Qꞌijsaq e xqꞌalajin ruma ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Na jinta junoq iliyom uwach ri Dios; pero riꞌoj xqetaꞌmaj uwach ruma ri Jun lik xa jun ukꞌuꞌx rukꞌ ri Dios, waꞌ e Rukꞌajol ri Dios, ri lik xew Ukꞌajol riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","E kꞌo jujun e aj judiꞌabꞌ re ri tinamit Jerusalem xekitaq lo raj chakunel re ri Rocho Dios y raj levitas rukꞌ, chaꞌ kakitzꞌonoj che ri Juan china rire. Yey ri kꞌulubꞌal uwach xuyaꞌo, lik qꞌalaj; ");
INSERT INTO acrNNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","na jinta kꞌo xrewaj chike. Jekꞌuwaꞌ xuqꞌalajisaj chike: —Riꞌin na in ta Ruchaꞌoꞌn lo ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Ekꞌuchiriꞌ, xkitzꞌonoj tanchi che: —¿Lal china kꞌu riꞌ? ¿Lal ri qꞌalajisanel Elías? —xechaꞌ. Y rire xubꞌiꞌij: —Na in taj —xchaꞌ. Xkitzꞌonoj kꞌu che: —¿Laj lal riꞌ ri jun qꞌalajisanel re ri Dios qoyeꞌem kakꞌunik? —xechaꞌ. Rire xukꞌul kꞌu uwach: —Na in taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Ekꞌuchiriꞌ, xkibꞌiꞌij tanchi che: —¿Lal china kꞌu riꞌ? Ma riꞌoj oj petinaq re kaqakꞌam bꞌi juna kꞌulubꞌal uwach chike ri xetaqaw lo qeꞌoj. Bꞌiꞌij la chiqe saꞌ ri wach la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Y rire xukꞌul uwach: —Riꞌin in ri jun tzijonel kasikꞌin che ubꞌiꞌxikil chupa ri luwar katzꞌintzꞌotik: “Sukꞌupij alaq rubꞌe ri Qanimajawal” jelaꞌ pachaꞌ ri tzꞌibꞌital kan ruma ri qꞌalajisanel Isaías —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ri etaqom loq re kebꞌoꞌlchꞌaꞌt rukꞌ ri Juan, e kukꞌil ri fariseos. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Xkitzꞌonoj kꞌu riꞌ che ri Juan: —¿Saꞌ kꞌu uchak riꞌ kaya la ri bautismo we na lal ta Ruchaꞌoꞌn lo ri Dios, na lal tane ri Elías yey na lal tane ri jun qꞌalajisanel re ri Dios qoyeꞌem kakꞌunik? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ri Juan xukꞌul uwach: —Riꞌin kanya ri bautismo rukꞌ yaꞌ, noꞌj chixoꞌl ralaq kꞌo Jun na etaꞌam ta alaq uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ekꞌu waꞌ wa Jun katajin lo chwij riꞌin, e ri Jun xex chi kꞌo lo wi echiriꞌ kꞌamajaꞌ kinalax riꞌin y na taqal tane chwe riꞌin kankir ruwach ruxajabꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronoje waꞌ xuꞌan pa ri luwar Betábara, chꞌaqa yaꞌ che ri nimayaꞌ Jordán, pa kuya wi bautismo ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chukaꞌm qꞌij kꞌut ri Juan xril pan ri Jesús e riꞌ katajin roponik rukꞌ y jewaꞌ xubꞌiꞌij: «Chiwilapeꞌ, waꞌ e ri Qꞌapoj Bꞌexex re ri Dios, ri kesan re ri kimak ri tikawex che ronoje ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Puwi rire xintzijon wi echiriꞌ ximbꞌiꞌij: “Chwij riꞌin katajin lo jun achi; rire más kꞌo uwach chinuwach riꞌin. Waꞌ xex chi kꞌo lo wi echiriꞌ kꞌamajaꞌ kinalax riꞌin.” ");
INSERT INTO acrNNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ri petinaq loq na xinwetaꞌmaj taj china ri jun katajin loq; na rukꞌ ta kꞌu riꞌ, riꞌin xinkꞌunik re kanya ri bautismo rukꞌ yaꞌ, chaꞌ jelaꞌ ri tinamit Israel kaketaꞌmaj uwach rire» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xubꞌiꞌij kꞌu ri Juan: «Riꞌin xinwil ri Ruxlabꞌixel ri Dios xqaj lo chikaj pachaꞌ juna palomax y xkꞌojiꞌ puwi rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ekꞌu ri petinaq loq na xinwetaꞌmaj taj china ri jun katajin loq; pero ri xtaqaw lo we riꞌin chaꞌ kanya ri bautismo rukꞌ yaꞌ, jewaꞌ xubꞌiꞌij chwe: “Echiriꞌ kawil ri Santowilaj Ruxlabꞌixel ri Dios kaqaj loq y kakꞌojiꞌ puwi jun achi, e rire ri kuya ri bautismo rukꞌ ri Ruxlabꞌixel ri Dios.” ");
INSERT INTO acrNNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ekꞌu riꞌin xinwilo y kanqꞌalajisaj kꞌu waꞌ: Paqatzij wi, rire e Ukꞌajol ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chukaꞌm qꞌij kꞌut, ri Juan kꞌo tanchi chiriꞌ junam kukꞌ kaꞌibꞌ chike rutijoꞌn rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Echiriꞌ xrilo xikꞌow ri Jesús, jewaꞌ xubꞌiꞌij: —Chiwilapeꞌ, waꞌ e ri Qꞌapoj Bꞌexex re ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Echiriꞌ ri kaꞌibꞌ utijoꞌn ri Juan xkito xubꞌiꞌij waꞌ, xeterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Ekꞌuchiriꞌ ri Jesús xtzuꞌn chirij y xrilo eteran chirij, xubꞌiꞌij chike: —¿Saꞌ ri kitzukuj? —xchaꞌ. Rike xkibꞌiꞌij che: —Rabí (waꞌ keꞌelawi “lal tijonel”), ¿pachawi jeqel wi la? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Ri Jesús xukꞌul uwach: —Chixpetoq, choꞌliwilaꞌ —xchaꞌ. Xebꞌek kꞌut, xkilo pa jeqel wi Rire y xekanaj kꞌu kan la jun bꞌenebꞌal qꞌij chiriꞌ rukꞌ, ma laj ukaj ora chik. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ri Andrés ruchaqꞌ ri Simón Pedro, e jun chike ri kaꞌibꞌ xkita ri xubꞌiꞌij ri Juan y xeterej bꞌi chirij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Ekꞌu ri Andrés nabꞌe na xuꞌtzukuj ri ratz Simón; y echiriꞌ xuriqo, jewaꞌ xubꞌiꞌij che: —Ya xqariq ri Mesías —xchaꞌ. (“Mesías” e keꞌelawi ri Cristo, Ruchaꞌoꞌn lo ri Dios.) ");
INSERT INTO acrNNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Xukꞌam kꞌu bꞌi ri Simón pa kꞌo wi ri Jesús. Ekꞌu ri Jesús echiriꞌ xril uwach, jewaꞌ xubꞌiꞌij che: —Riꞌat at Simón, rukꞌajol ri Jonás; pero woꞌora rabꞌiꞌ kankojo e Cefas (waꞌ keꞌeloq Pedro) —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chukaꞌm qꞌij kꞌut, ri Jesús xraj xeꞌek pa ri luwar re Galilea. Xeꞌek kꞌut y xukꞌul jun achi Felipe rubꞌiꞌ y xubꞌiꞌij che: —Chat-tereja lo chwij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ri Felipe aj pa ri tinamit Betsaida, waꞌ e tinamit pa ejeqel wi ri Andrés y ri Pedro. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Ekꞌu ri Felipe xuꞌtzukuj ri Natanael y echiriꞌ xuriqo, jewaꞌ xubꞌiꞌij che: —Xqariq ri jun ri xtzꞌibꞌan ri Moisés puwiꞌ chupa ri Tzij Pixabꞌ, yey ri qꞌalajisanelabꞌ jenelaꞌ xetzꞌibꞌan puwiꞌ: Waꞌ e ri Jesús, rukꞌajol ri José ri aj Nazaret —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Xubꞌiꞌij kꞌu ri Natanael: —¿Kꞌo nebꞌa utz kel lo chupa ri tinamit Nazaret? —xchaꞌ. Ri Felipe xukꞌul uwach: —Saꞌa, chawilapeꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Ri Jesús, echiriꞌ xrilo katajin roponik ri Natanael rukꞌ, jewaꞌ xubꞌiꞌij: —Wa jun achi katajin lo ukꞌunik, e jun saqil aj Israel y na jinta sokosoꞌnik rukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Ekꞌu ri Natanael xutzꞌonoj che: —¿Chaꞌtaj etaꞌam la nuwach? —xchaꞌ. Ri Jesús xubꞌiꞌij che: —Riꞌin xinwil pan awach echiriꞌ kꞌamajaꞌ ne katusikꞌij ri Felipe, echiriꞌ at kꞌo chuxeꞌ ri jun cheꞌ re higo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Xubꞌiꞌij kꞌu ri Natanael che: —Lal tijonel, rilal lal Ukꞌajol ri Dios y ri Rey ke raj Israel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ri Jesús xukꞌul uwach: —¿Kakoj kami riꞌ waꞌ xa ruma ximbꞌiꞌij chawe xatinwil pan chuxeꞌ ri jun cheꞌ re higo? Chiqawach apanoq, kawil ne kꞌutubꞌal más nimaꞌq chwa taq waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Y xubꞌiꞌij ri Jesús: —Paqatzij wi kambꞌiꞌij chiwe: Wa chiqawach apanoq kiwil ne ruwa kaj jaqalik y kebꞌiwil ri ángeles re ri Dios kebꞌaqꞌanik y keqaj lo chwi Ralaxel Chikixoꞌl Tikawex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Oxibꞌ qꞌij rikꞌowik waꞌ, xꞌan jun kꞌulanikil pa ri tinamit Caná re Galilea. Ruchu ri Jesús e jun chike ri e kꞌo chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ekꞌu ri Jesús, junam kukꞌ rutijoꞌn, xesikꞌix pa ri kꞌulanikil. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Yey kꞌamajaꞌ ne kakꞌis ri nimaqꞌij echiriꞌ xkꞌis ri vino. Ekꞌu ruchu ri Jesús xubꞌiꞌij che: —Xkꞌis ri vino ketajin che ujachik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ri Jesús xukꞌul uwach: —Tape la, ¿suꞌchak kabꞌiꞌij la waꞌ chwe riꞌin? Ma kꞌamajaꞌ kopon ri ora kanqꞌalajisaj nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Ekꞌu ruchu ri Jesús xubꞌiꞌij chike ri keniman chiriꞌ: —E ꞌana alaq ronoje ri kubꞌiꞌij rire che alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Chiriꞌ kꞌu riꞌ kꞌo waqibꞌ tenaꞌx ꞌanatal rukꞌ abꞌaj, waꞌ kakꞌoliꞌ yaꞌ chupa re kijosqꞌikil raj judiꞌabꞌ chwach ri Dios. Chujujunal tenaꞌx, laj kok juna ochenta o juna cien litros yaꞌ chupa. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ri Jesús xubꞌiꞌij chike ri keniman chiriꞌ: —Nojisaj alaq che yaꞌ taq wa tenaꞌx —xchaꞌ. Ekꞌu rike xkinojisaj chi utz. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike: —Woꞌora chesaj lo alaq jubꞌiqꞌ y kꞌama bꞌi alaq che ri aj wach re wa nimaqꞌij —xchaꞌ. Y rike jelaꞌ xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ekꞌu ri aj wach re ri nimaqꞌij xunaꞌ ri yaꞌ ꞌanom vino che, tobꞌ na retaꞌam ta nenareꞌ pa xpe wi. Xew ri keniman chiriꞌ ketaꞌam, ma e rike xebꞌesan lo ri yaꞌ. Ekꞌu ri aj wach xusikꞌij rala xkꞌuliꞌik ");
INSERT INTO acrNNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","y jewaꞌ xubꞌiꞌij che: —Konoje ri tikawex nabꞌe na e kakijach ri chomilaj vino, yey echiriꞌ ri echokom lik kꞌi chi ri kitijom, kꞌa ekꞌuchiriꞌ kajachiꞌ ri xaqi tobꞌ vino. Noꞌj riꞌat kꞌa e laꞌ xawesaj lo ri saqil vino che wa kꞌisbꞌal re wa nimaqꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","E nabꞌe kꞌutubꞌal waꞌ re ruchuqꞌabꞌ ri Dios xuꞌan ri Jesús chilaꞌ Caná re Galilea. Rukꞌ waꞌ xuqꞌalajisaj ri unimal uwach uqꞌij y ruma laꞌ rutijoꞌn lik xkubꞌiꞌ kikꞌuꞌx rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Echiriꞌ ikꞌowinaq chi waꞌ, ri Jesús rukꞌ ruchu, kukꞌ taq ruchaqꞌ y rutijoꞌn xebꞌek pa ri tinamit Capernaúm. Yey na xekꞌojiꞌ ta chiriꞌ ukꞌiyal qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xa naqaj chi kꞌo wi lo ri Pascua, waꞌ e kinimaqꞌij raj judiꞌabꞌ. Ekꞌu ri Jesús xeꞌek pa ri tinamit Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chiriꞌ pa ri Rocho Dios, xebꞌuꞌriqa ri e aj kꞌay bꞌoyexabꞌ, bꞌexex y palomax, kukꞌ ri e aj jachal uwach puaq etzꞌul chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Ekꞌuchiriꞌ, ri Jesús xuꞌan jun asial y rukꞌ waꞌ xebꞌeresaj lo pa ri Rocho Dios konoje rike junam kukꞌ taq ri bꞌexex y ri bꞌoyexabꞌ e kꞌo pa kꞌayij. Xuxulkꞌatilaꞌ taq bꞌi ri kimexa ri e aj jachal uwach puaq, y jelaꞌ xkichikoꞌbꞌ bꞌi ri puaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xubꞌiꞌij kꞌu chike raj kꞌay ke palomax: —¡Chesaj bꞌi alaq taq waꞌ! ¡Maꞌan alaq kꞌaybꞌal che ri Rocho ri Nuqaw! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ekꞌuchiriꞌ, xkꞌun chikikꞌuꞌx rutijoꞌn ri tzꞌibꞌital pa Ruchꞌaꞌtem ri Dios pa kubꞌiꞌij wi: Ruchajixik ri Ocho la lik e ubꞌis nukꞌuꞌx riꞌ kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ekꞌu raj judiꞌabꞌ xkitzꞌonoj che: —¿Saꞌ ri kꞌutubꞌal kaꞌan la chiqawach chaꞌ kaqakojo yaꞌtal paqꞌabꞌ la kaꞌan la waꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Ri Jesús xukꞌul uwach: —We xwulij alaq wa rocho ri Dios, xa pa oxibꞌ qꞌij riꞌin kanyak tanchik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Xkibꞌiꞌij kꞌu raj judiꞌabꞌ che: —Waꞌ wa Rocho Dios pa cuarenta y seis junabꞌ xutzin wi. ¿Kayak kami la riꞌ rilal pa oxibꞌ qꞌij? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Pero ri “Rocho Dios” xchꞌaꞌt ri Jesús puwiꞌ, e rucuerpo Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","E uwariꞌche, echiriꞌ xkꞌastaj lo chikixoꞌl ri ekaminaq, rutijoꞌn xkꞌun chikikꞌuꞌx ri ubꞌiꞌim chi lo chike. Kꞌa ekꞌuchiriꞌ xkimaj usukꞌ y xkikoj ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios puwi ri Jesús y ri bꞌiꞌtal kan ruma Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Echiriꞌ kꞌo ri Jesús Jerusalem pa ri nimaqꞌij Pascua, lik e kꞌi ri tikawex xkikoj rubꞌiꞌ Rire ruma xkil taq ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Noꞌj ri Jesús na xkubꞌiꞌ ta ukꞌuꞌx kukꞌ ma lik retaꞌam kiwach konoje. ");
INSERT INTO acrNNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Na xajawax tane kabꞌiꞌx che saꞌ ri kakichꞌobꞌ raqan ri winaq, ma Rire retaꞌam saꞌ ri kꞌo chupa ri kanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Kꞌo jun achi Nicodemo rubꞌiꞌ; rire e kukꞌil ri fariseos yey e jun aj wach ke raj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Rire xeꞌbꞌina rukꞌ ri Jesús chaqꞌabꞌ y xubꞌiꞌij che: —Lal tijonel, lik qꞌalaj lal taqom lo la ruma ri Dios re koꞌlkꞌutun la chiqawach, ma na jinta junoq kaꞌanaw janipa wa kꞌutubꞌal kaꞌan la, we na jinta ri Dios rukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ekꞌu ri Jesús xubꞌiꞌij che: —Paqatzij wi kambꞌiꞌij cheꞌla: E junoq we na kalax ta tanchik, riꞌ na kayaꞌtaj ta che kok chupa rutaqanik ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Ri Nicodemo xutzꞌonoj che: —¿Suꞌanik kꞌu riꞌ kalax junoq e laꞌ nim chik? ¿Utz nebꞌa laꞌ kamatzex tanchi ruma ruchu chaꞌ kalax tanchik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij cheꞌla: China ri na kalax ta rukꞌ yaꞌ y rukꞌ ri Ruxlabꞌixel ri Dios, riꞌ na taqal ta che kok chupa rutaqanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","E junoq kalax kuma ruchu-uqaw, riꞌ lik rewi e jun tikawex; noꞌj ri kalax ruma ri Ruxlabꞌixel ri Dios, riꞌ kꞌo ukꞌaslemal chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Makam kꞌu animaꞌ la che wa ximbꞌiꞌij cheꞌla: “Lik chirajawaxik chike konoje ri tikawex kebꞌalax na tanchik.” ");
INSERT INTO acrNNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","E pachaꞌ ri tew xa tobꞌ pa kawelel wi, xew kata la kajuxuxik, pero na etaꞌam ta la pa kape wi y pa kumaj wubꞌi. Jekꞌulaꞌ ri kebꞌalax ruma ri Ruxlabꞌixel ri Dios na kilitaj taj suꞌanik ri Dios kuya ri kꞌakꞌ kikꞌaslemal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Ekꞌu ri Nicodemo xutzꞌonoj tanchik: —¿Suꞌanik kuꞌana waꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Ri Jesús xukꞌul uwach: —Lal tijonel chikiwach raj Israel, ¿yey na etaꞌam tane la waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Paqatzij wi kambꞌiꞌij waꞌ cheꞌla: Riꞌoj e kaqatzijoj janipa ri qetaꞌam y ri qilom; na rukꞌ ta kꞌu riꞌ, ralaq na kakoj ta alaq saꞌ ri kantzijoj che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We na kakoj ta alaq echiriꞌ kintzijon puwi taq ri xa re ruwachulew, ¿saꞌ kꞌu uꞌanik riꞌ kakoj alaq echiriꞌ kintzijon chiwach alaq puwi taq ri re ri Dios kꞌo chilaꞌ chikaj? ");
INSERT INTO acrNNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Na jinta junoq bꞌenaq chilaꞌ chikaj, xew ri jun petinaq chilaꞌ, waꞌ e Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Ma jelaꞌ pachaꞌ xuꞌan ri Moisés echiriꞌ xuyak jun kumatz chutzaꞌm jun cheꞌ pa ri luwar katzꞌintzꞌotik; jekꞌulaꞌ lik chirajawaxik wi Ralaxel Chikixoꞌl Tikawex kayakiꞌ chwa jun cheꞌ ");
INSERT INTO acrNNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","chaꞌ china ri kakubꞌiꞌ ukꞌuꞌx rukꞌ Rire, na kasach ta uwach, ma kꞌo ukꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","»Ri Dios lik kꞌax xebꞌunaꞌ ri e kꞌo che ruwachulew; y ruma kꞌu waꞌ, xutaq lo Rukꞌajol, ri lik xew Ukꞌajol riꞌ, chaꞌ china ri kakubꞌiꞌ ukꞌuꞌx rukꞌ Rire na kasach ta uwach, ma kꞌo ukꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Ma ri Dios na xutaq ta lo Rukꞌajol che ruwachulew re koluꞌqꞌata tzij pakiwi ri tikawex; ri xutaq wuloq e chaꞌ kebꞌoluꞌkolobꞌej. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","China kꞌu ri kakubꞌiꞌ ukꞌuꞌx rukꞌ Rukꞌajol ri Dios, riꞌ na jinta ri qꞌatbꞌal tzij re ri Dios puwiꞌ; noꞌj china ri na kakubꞌiꞌ ta ukꞌuꞌx rukꞌ, riꞌ kꞌo chi ri qꞌatbꞌal tzij re ri Dios puwiꞌ ruma na xukoj ta rubꞌiꞌ Rukꞌajol ri Dios, ri lik xew Ukꞌajol riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Yey ri qꞌatbꞌal tzij kuꞌan ri Dios e ruma waꞌ: Ri Qꞌijsaq re ri Dios xkꞌun che ruwachulew, pero taq ri tikawex e más xukꞌul kikꞌuꞌx ri qꞌequꞌmalil re ri mak chwa ri Qꞌijsaq; ma ri ketajin che uꞌanik, lik na chom taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Konoje ri kakiꞌan ri na utz taj, tzel kakil ri Qꞌijsaq y na keqibꞌ ta rukꞌ chaꞌ na kaqꞌalajin ta ri na utz taj ketajin che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Noꞌj konoje ri kakitijoj kibꞌ che jun saqil bꞌinik silabꞌik, riꞌ keqibꞌ chwach ri Qꞌijsaq chaꞌ kaqꞌalajinik, ri ketajin che uꞌanik e ri karaj ri Dios chike —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Tekꞌuchiriꞌ, ri Jesús junam kukꞌ rutijoꞌn xebꞌek Judea; ukꞌiyal qꞌij xkꞌojiꞌ chiriꞌ kukꞌ y kuya ri bautismo chike ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ekꞌu ri Juan katajin che uyaꞌik ri bautismo pa ri tinamit Enón chunaqaj Salim, ma chilaꞌ lik kꞌo yaꞌ. Kebꞌopon kꞌu ri tikawex rukꞌ chaꞌ kakikꞌul ri bautismo. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ri Juan xuꞌan waꞌ echiriꞌ kꞌamajaꞌ kayaꞌiꞌ pa cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ekꞌuchiriꞌ, jujun chike rutijoꞌn ri Juan kukꞌ jujun e aj judiꞌabꞌ xkijeq kechꞌaꞌt chwi taq ri taqanik chwi ri kijosqꞌikil chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Xebꞌek kꞌut xeꞌkibꞌiꞌij che ri Juan: —Lal tijonel, tape la, e ri jun xopon ukꞌ la chꞌaqa yaꞌ che ri nimayaꞌ Jordán, ri xqꞌalajisan la puwiꞌ, woꞌora katajin che uyaꞌik ri bautismo y konoje ri tikawex eteran chirij —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Ekꞌu ri Juan xubꞌiꞌij chike: «Na jinta kꞌo kukꞌul junoq we na e ta ri Dios chilaꞌ chikaj kayaꞌw re che. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Riꞌix xinito echiriꞌ ximbꞌiꞌij chiwe: Riꞌin na in ta Ruchaꞌoꞌn lo ri Dios, xa in jun qꞌalajisanel intaqom lo nabꞌe chwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","»E pachaꞌ pa juna kꞌulanikil. Ri lik kꞌo uwach na e ta ri ramigo rala, e rala kakꞌuliꞌik ma e ukꞌaꞌyom re rali. Yey ri ramigo kꞌo putzal rala, e lik kakiꞌkot che utayik ri kubꞌiꞌij rala. Jekꞌulaꞌ riꞌin woꞌora lik kinkiꞌkotik ma ya xkꞌun ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Lik kꞌu chirajawaxik más kanimarisax uqꞌij rire, chwa ri kanimarisax nuqꞌij riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","»Ri jun kape chilaꞌ chikaj, e más nim uwach uqꞌij chikiwa konoje. Ekꞌu junoq na re ta chilaꞌ chikaj, e re ruwachulew y e kachꞌaꞌt puwi taq ri re ruwachulew. Noꞌj ri jun kape chilaꞌ chikaj, e más lik nim uwach uqꞌij chikiwa konoje. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Yey rire e kuqꞌalajisaj saꞌ ri rilom y saꞌ rutom che ri Dios; na rukꞌ ta kꞌu riꞌ, taq ri winaq na kakikoj taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Yey we kꞌo junoq kakojow ri kuqꞌalajisaj rire, riꞌ kujikibꞌaꞌ uwach lik qatzij ri kubꞌiꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma ri jun taqom lo ruma ri Dios, e kutzijoj ri kubꞌiꞌij ri Dios. Ma ri Dios na xuxuꞌyaj ta ri Ruxlabꞌixel uyaꞌom che; e uwariꞌche, xaqi kꞌo ri Ruxlabꞌixel rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ri Dios lik kꞌax kunaꞌ Rukꞌajol yey uyaꞌom puqꞌabꞌ rire ronoje ri kꞌolik. ");
INSERT INTO acrNNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","China kꞌu ri kakubꞌiꞌ ukꞌuꞌx rukꞌ Rukꞌajol ri Dios, kꞌo ukꞌaslemal na jinta utaqexik; noꞌj china ri na karaj taj kakubꞌiꞌ ukꞌuꞌx rukꞌ Rukꞌajol ri Dios, riꞌ na jinta ukꞌaslemal rukꞌ ri Dios yey qꞌatom chi tzij puwiꞌ ruma ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ri Jesús xretaꞌmaj, ri fariseos xkito más e kꞌi rutijoꞌn Rire chikiwa rutijoꞌn ri Juan, yey más e kꞌi ri kakikꞌul ri bautismo ruma Rire chikiwa ri kakikꞌul ri bautismo ruma ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Tobꞌ na e ta kꞌu ri Jesús ri kuya ri bautismo, ma e taq rutijoꞌn ri keyaꞌw re.) ");
INSERT INTO acrNNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ruma kꞌu ri Jesús retaꞌam ri xkita rike, xel bꞌi pa ri luwar re Judea y xtzelej tanchi pa ri luwar re Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Yey chirajawaxik che ri Jesús kikꞌow pa ri luwar re Samaria. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Jekꞌulaꞌ xeꞌela pa jun tinamit Sicar rubꞌiꞌ, kꞌo che ri luwar re Samaria, chunaqaj rulew xuya kan ri Jacob che rukꞌajol José. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chiriꞌ kꞌo wi ri jun pozo ukꞌotom kan ri Jacob. Ruma kꞌu kosinaq ri Jesús che ri bꞌe uꞌanom loq, xtzꞌuyiꞌ chunaqaj ri pozo echiriꞌ ya kuꞌana pa tikꞌil qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Xkꞌun kꞌu lo jun ixoq aj Samaria, e riꞌ koꞌlresaj bꞌi uyaꞌ pa ri pozo, yey ri Jesús xubꞌiꞌij che: —Sipaj la jubꞌiqꞌ nuyaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Yey rutijoꞌn ri Jesús ebꞌenaq pa ri tinamit xeꞌkiloqꞌo kiwa. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Rixoq aj Samaria xubꞌiꞌij kꞌu che: —¿Saꞌ riꞌ laꞌ katzꞌonoj yaꞌ la chwe? Ma rilal lal kukꞌil raj judiꞌabꞌ yey riꞌin in aj Samaria —xchaꞌ. Xubꞌiꞌij waꞌ ma raj judiꞌabꞌ na kechꞌaw ta chikiwach kukꞌ raj Samaria. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ewi ri Jesús xukꞌul uwach: —We ta kꞌu ketaꞌmaj la saꞌ ri kusipaj ri Dios cheꞌla yey we ta ketaꞌmaj la in china riꞌin, ri kantzꞌonoj nuyaꞌ cheꞌla, riꞌ e ne rilal katzꞌonoj la yaꞌ chwe yey riꞌin kanya kꞌu cheꞌla ri yaꞌ kuya kꞌaslemal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Rixoq xubꞌiꞌij che ri Jesús: —Wajawal, na jinta ne saꞌ rukꞌ kesaj lo la ri yaꞌ yey ri pozo lik naj upa. ¿Pachawi kꞌu riꞌ kesaj wi lo la ri yaꞌ kuya kꞌaslemal? ");
INSERT INTO acrNNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","E ri qamam Jacob xuya kan wa jun pozo chiqe ojertan, ma wara xutij wi uyaꞌ rire kukꞌ taq ri ralkꞌoꞌal y taq ri rawaj. ¿Más nebꞌa kꞌo wach rilal chwach rire? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ri Jesús xukꞌul uwach: —Konoje ri ketijow re waꞌ wa yaꞌ, katzajin tanchi kichiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Noꞌj china ri katijow re ri yaꞌ kanya riꞌin, riꞌ na kachaqij ta chi kꞌana uchiꞌ. Ma ri yaꞌ kanya riꞌin, kuꞌan pachaꞌ jun akꞌal kalax lo pa ranimaꞌ re kuya ukꞌaslemal na jinta utaqexik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Xubꞌiꞌij kꞌu rixoq che: —Wajawal, yaꞌa ko la weꞌin riꞌ laꞌ la yaꞌ, chaꞌ na kachaqij ta chi nuchiꞌ y na kinkꞌun ta chi ne riꞌ kꞌa wara re koꞌlnuwesaj bꞌi nuyaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Pero ri Jesús xubꞌiꞌij che: —Oj la, jeꞌsikꞌij la ri achijil la y kꞌamaꞌ kꞌu lo la wara —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Ewi rixoq xubꞌiꞌij: —Riꞌin na jinta wachijil —xchaꞌ. Xubꞌiꞌij kꞌu ri Jesús che: —Qatzij ri xbꞌiꞌij la, na jinta achijil la. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Ma e woꞌobꞌ lo rachijabꞌ e kꞌojiꞌnaq ukꞌ la yey rachi kꞌo ukꞌ la woꞌora na achijil ta la. Ruma kꞌu riꞌ, lik qatzij ri xbꞌiꞌij la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Echiriꞌ xuta waꞌ rixoq, xubꞌiꞌij che ri Jesús: —Wajawal, e kunaꞌ nukꞌuꞌx riꞌin, rilal lal qꞌalajisanel re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ri qatiꞌ-qamam ri oj aj Samaria lik xkiloqꞌnimaj uqꞌij ri Dios chwach wa juyubꞌ, noꞌj ri alaq aj judiꞌabꞌ kabꞌiꞌij alaq e Jerusalem ri luwar pa chirajawaxik wi kaloqꞌnimax wi uqꞌij ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Ri Jesús xubꞌiꞌij che: —Ixoq, lik kojo la wa kambꞌiꞌij cheꞌla, ma kopon na ri qꞌij na xew ta chi kaloqꞌnimax uqꞌij ri Dios wara chwa wa juyubꞌ o kꞌa chilaꞌ Jerusalem, ma utz kaꞌaniꞌ waꞌ pa ronoje luwar. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ralaq alaq aj Samaria, na etaꞌam ta alaq china ri kaloqꞌnimaj alaq uqꞌij; noꞌj riꞌoj lik qetaꞌam chi utz china ri kaqaloqꞌnimaj uqꞌij, ma ri kolobꞌetajik kape kukꞌ raj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Noꞌj kopon na kꞌu ri qꞌij yey ekꞌu uqꞌijol waꞌ xoponik echiriꞌ e janipa ri kakiloqꞌnimaj uqꞌij ri Qaqaw Dios pa saqil wi, kakiꞌano ruma ri Ruxlabꞌixel kꞌo pa kanimaꞌ. Ma e karaj waꞌ ri Qaqaw Dios chike konoje ri keloqꞌniman re. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma ri Dios e Uxlabꞌixel; Rire na kilitaj ta uwach. E uwariꞌche konoje ri keloqꞌniman uqꞌij, lik chirajawaxik wi kiꞌana waꞌ pa saqil wi ruma ri Ruxlabꞌixel kꞌo pa kanimaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Xubꞌiꞌij kꞌu rixoq che ri Jesús: —Riꞌin wetaꞌam kakꞌun Ruchaꞌoꞌn lo ri Dios, ri kabꞌiꞌx “Cristo” che; y echiriꞌ kakꞌun Rire, kuqꞌalajisaj ronoje chiqe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ri Jesús xubꞌiꞌij che: —Waꞌ wa kabꞌiꞌij la e riꞌin, ri kinchꞌaꞌt ukꞌ la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ekꞌuchiriꞌ, xetzelej lo rutijoꞌn y lik xkam kanimaꞌ che ma ri Jesús kachꞌaꞌt rukꞌ jun ixoq. Na rukꞌ ta kꞌu riꞌ, na jinta junoq chike xutzꞌonoj saꞌ puwiꞌ kachꞌaꞌt wi rukꞌ rixoq. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ekꞌuchiriꞌ, rixoq xuya kan rukꞌambꞌaꞌ, xeꞌek pa ri tinamit y jewaꞌ kubꞌiꞌij chike ri winaq: ");
INSERT INTO acrNNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Peta alaq, jeꞌilaꞌ alaq jun achi ubꞌiꞌim chwe janipa ri nuꞌanom. ¿Na e ta nawi rire ri Cristo? —kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ekꞌuchiriꞌ, xebꞌel bꞌi ri winaq pa ri tinamit y xebꞌek chilaꞌ pa kꞌo wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Echiriꞌ kꞌamajaꞌ kebꞌopon ri winaq, rutijoꞌn xkitij riꞌ che, jewaꞌ xkibꞌiꞌij: —Lal tijonel, tija wa la —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ri Jesús xubꞌiꞌij chike: —Riꞌin kꞌo ri nuwa kantijo, tobꞌ riꞌix na iwetaꞌam taj saꞌ waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Ekꞌu rutijoꞌn xkijeq kakibꞌiꞌij chikiwach: «¿Kꞌo nawi junoq xkꞌamaw lo uwa?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ekꞌu ri Jesús xubꞌiꞌij chike: «Ri nuwa riꞌin e ri kanꞌan ri rajawal ukꞌuꞌx ri taqayom lo weꞌin y kankꞌis na kꞌu ruchak. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Riꞌix kibꞌiꞌij: “Kajibꞌ ikꞌ chik kopon wi chaꞌ kaꞌan ri molonik.” Noꞌj riꞌin kambꞌiꞌij chiwe: Chixtzuꞌn apanoq y chiwila chi utz ri tikoꞌn, ma ya riꞌj chik, utz chik kamolik. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ri kachakun che ri molonik, kukꞌul na ri tojbꞌal re yey janipa ri kumolo, kꞌo kutiqoj che rukꞌaslemal na jinta utaqexik. Jekꞌulaꞌ, ri katikow re junam kekiꞌkot rukꞌ ri kamolonik. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ma e kuꞌana pachaꞌ ri kabꞌiꞌxik: “Jun ri katikow re yey jun chik ri kaꞌanaw re ri molonik.” ");
INSERT INTO acrNNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Riꞌin xixintaq bꞌi re kimol ri na xitik ta riꞌix; ma e jujun chik ri xetikow re. Ekꞌu woꞌora kꞌo kikꞌul riꞌix che ri chak ke rike» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","E kꞌi chike ri e aj Samaria xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús ruma ri xutzijoj rixoq echiriꞌ xubꞌiꞌij chike: «Rire xubꞌiꞌij chwe janipa ri nuꞌanom.» ");
INSERT INTO acrNNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Ruma kꞌu laꞌ, rike xekꞌun rukꞌ ri Jesús y lik xebꞌelaj che chaꞌ kakanaj kukꞌ. Ewi Rire kebꞌ qꞌij xkanaj kan kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Yey más e kꞌi ri xkubꞌiꞌ kikꞌuꞌx rukꞌ ruma ri xutzijoj Rire chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Xkibꞌiꞌij kꞌu che rixoq: —Woꞌora lik kubꞌul qakꞌuꞌx rukꞌ rire na xew ta ruma ri xatzijoj riꞌat chiqe, ma e ruma ri xqata ruchꞌaꞌtem rire. Qetaꞌam kꞌu riꞌ rire paqatzij wi e ri Cristo, ri Kolobꞌenel re ruwachulew —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Echiriꞌ ikꞌowinaq chi kaꞌibꞌ qꞌij, ri Jesús xel bꞌi chiriꞌ Samaria, xumaj bꞌi ubꞌe y xeꞌek kꞌa Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Ubꞌiꞌim chi kꞌu ri Jesús: “Juna qꞌalajisanel na kayak ta uqꞌij pa rutinamit.” ");
INSERT INTO acrNNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Na rukꞌ ta kꞌu riꞌ, echiriꞌ xopon chilaꞌ Galilea, ri aj chiriꞌ lik xkikꞌul chi utz, ma rike xebꞌopon pa ri nimaqꞌij Pascua chilaꞌ Jerusalem y xkilo janipa taq ri xuꞌan ri Jesús pa ri nimaqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Ekꞌuchiriꞌ, ri Jesús xtzelej pa ri tinamit Caná re Galilea pa xuꞌan wi vino che ri yaꞌ. Kꞌo kꞌu jun aj wach raj chak ri rey chilaꞌ Capernaúm, y rire kꞌo jun ukꞌajol lik yewaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wa waꞌchi echiriꞌ xuto ri Jesús petinaq Judea y kꞌo chi chiriꞌ Galilea, xeꞌek kꞌu che rilik y lik xeꞌelaj che chaꞌ keꞌek chirocho re kuꞌkunaj rukꞌajol kajekꞌowik. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Xubꞌiꞌij kꞌu ri Jesús che: —Ralaq na kakubꞌiꞌ ta kꞌuꞌx alaq wukꞌ we na kil ta taq kꞌutubꞌal re ri nuchuqꞌabꞌ o taq milagros kanꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ri raj chak ri rey xubꞌiꞌij tanchi che ri Jesús: —Wajawal, peta ko la wukꞌ chiwocho, ma ri nukꞌajol kajekꞌowik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Xubꞌiꞌij kꞌu ri Jesús che: —Oj la chi ocho la, ma ri kꞌajol la na kakam taj —xchaꞌ. Rachi xukoj ri xbꞌiꞌx che ruma ri Jesús y xeꞌek. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Echiriꞌ katajin roponik chirocho, ri raj chakibꞌ xebꞌel lo che ukꞌulik y xkibꞌiꞌij che: —¡Ri kꞌajol la na xkam taj ma xkunutajik! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ekꞌu rire xutzꞌonoj chike jampalaꞌ xujeqo utz uwach rukꞌajol. Y rike xkibꞌiꞌij che: —Iwir che ri nabꞌe ora bꞌenaq qꞌij xikꞌow ri aqꞌ chirij —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Jekꞌulaꞌ ruqaw rala xretaꞌmaj e ora riꞌ xubꞌiꞌij ri Jesús che: «Ri kꞌajol la na kakam taj.» Ruma kꞌu riꞌ laꞌ, rire kukꞌ konoje ri e kꞌo pa rocho xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Wa jun kunanik e ukaꞌm kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xuꞌan ri Jesús chilaꞌ Galilea echiriꞌ tzelejinaq lo Judea. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Kꞌate tanchi kꞌu riꞌ, ri Jesús xtzelej Jerusalem echiriꞌ raj judiꞌabꞌ kꞌo jun kinimaqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Chupa kꞌu laꞌ la tinamit, chunaqaj ri Okibꞌal ke Bꞌexex, kꞌo jun nimalaj atinibꞌal, “Betesda” rubꞌiꞌ pa ri chꞌaꞌtem hebreo. Waꞌ woꞌobꞌ uchiꞌ ja kꞌo che. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Chiriꞌ e kꞌo ukꞌiyal yewaꞌibꞌ e kotzꞌerinaq; e kꞌo potzꞌ, jetzꞌ y sik. Konoje rike koyeꞌem echiriꞌ kasilabꞌ ri yaꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ma xa chirij ora kaqaj lo jun ángel y kurujuraꞌ upa ri yaꞌ. Ekꞌu riꞌ ri nabꞌe kukꞌaq bꞌi ribꞌ chupa, riꞌ kel loq kunutajinaq chik tobꞌ saꞌ ri yabꞌil kꞌo che. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Kꞌo kꞌu jun achi e treinta y ocho junabꞌ riꞌ yewaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Echiriꞌ ri Jesús xrilo kotzꞌol chiriꞌ y xretaꞌmaj ukꞌiyal junabꞌ jelaꞌ uꞌanom, xutzꞌonoj kꞌu riꞌ che: —¿Kawaj katkunutajik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Rachi jewaꞌ xukꞌul uwach: —Wajawal, na jinta junoq kakꞌamaw bꞌi we chupa ri atinibꞌal echiriꞌ karujurut upa ri yaꞌ. Lik nutijom chi nuqꞌij che kankꞌaq bꞌi wibꞌ chupa; pero echiriꞌ kuaj kanꞌano, kꞌate kanwilo jun chik kanabꞌej chinuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Ri Jesús xubꞌiꞌij che: —Chatyaktajoq, chakꞌama bꞌi rachꞌat y chatbꞌinoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Chupa kꞌu laꞌ la joqꞌotaj rachi xkunutajik, xukꞌam bꞌi ruchꞌat y xujeqo kabꞌinik. Yey waꞌ xuꞌan pa jun qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Ruma kꞌu riꞌ, ri e aj judiꞌabꞌ xkibꞌiꞌij che rachi xkunutajik: —Waqꞌij e qꞌij re uxlanibꞌal, y na ubꞌe ta chawe kawukꞌaꞌaj rachꞌat —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Rachi xukꞌul kꞌu uwach chike: —Ri jun xinukunaj e xbꞌiꞌn re chwe: “Chakꞌama bꞌi rachꞌat y chatbꞌinoq” —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Xkitzꞌonoj kꞌu che: —¿China ri xbꞌiꞌn chawe: “Chakꞌama bꞌi rachꞌat y chatbꞌinoq”? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ekꞌu rachi na retaꞌam taj china ri xkunaw re, ma ri Jesús xel bꞌi chikixoꞌl ri tikawex e kꞌo chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Tekꞌuchiriꞌ, ri Jesús xuꞌriqa rachi pa ri Rocho Dios y xubꞌiꞌij che: —Chawilapeꞌ: Woꞌora at kunutajinaq chik; matmakun chi kꞌu riꞌ, ma kꞌaxtaj kape juna kꞌaxkꞌobꞌik más nim pawiꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Xeꞌek rachi y xuꞌtzijoj chike raj judiꞌabꞌ e ri Jesús xkunaw re. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Ruma waꞌ, raj judiꞌabꞌ xkijeq uternabꞌexik ri Jesús y kakitzukuj suꞌanik kakikamisaj, ma rire kuꞌan kunanik pa ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ekꞌu ri Jesús xubꞌiꞌij chike: —Ri Nuqaw na roqꞌotam taj kachakunik y jekꞌulaꞌ riꞌ kanꞌan riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ruma waꞌ raj judiꞌabꞌ más xkiya kibꞌ che ukamisaxik ri Jesús, ma e chikiwach rike kupalajij ri taqanik puwi ri qꞌij re uxlanibꞌal. Y na xew ta waꞌ, ma kujunimaj ne ribꞌ rukꞌ ri Dios echiriꞌ kubꞌiꞌij ri Dios e Uqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ekꞌu ri Jesús xubꞌiꞌij chike: «Paqatzij wi kambꞌiꞌij che alaq: Rukꞌajol ri Dios na jinta kꞌo kuꞌan xa pa re Rire; ma xew kuꞌan pachaꞌ ri karilo kuꞌan Ruqaw. Janipa taq ri kuꞌan Ruqaw, jekꞌulaꞌ kuꞌan Rukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","»Ma ri Dios lik kꞌax kunaꞌ Rukꞌajol y kukꞌut kꞌu che ronoje ri kuꞌano. Yey kꞌo ne ri más nimaq taq chak kukꞌut chwach. Y we xuꞌan kꞌu waꞌ, lik kakam ne animaꞌ ralaq che. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Ma jelaꞌ pachaꞌ ri Dios kebꞌukꞌastajisaj ri ekaminaq y kuya kikꞌaslemal, jekꞌulaꞌ Rukꞌajol kuya kꞌaslemal china che ri karaj kuya wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Yey ri Dios na kuqꞌat tane tzij puwi junoq, ma puqꞌabꞌ Rukꞌajol uyaꞌom wi kuqꞌat tzij pakiwi ri tikawex, ");
INSERT INTO acrNNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","chaꞌ jelaꞌ konoje ri tikawex kakiyak uqꞌij Rukꞌajol, jelaꞌ pachaꞌ kakiꞌan che uyakik uqꞌij ri Dios. Yey china ri na kuyak ta uqꞌij Rukꞌajol ri Dios, na kuyak ta kꞌu uqꞌij riꞌ ri Jun xtaqaw lo re, waꞌ e ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","»Paqatzij wi kambꞌiꞌij che alaq: China ri lik kuta chi utz ri kambꞌiꞌij riꞌin y kakubꞌiꞌ ukꞌuꞌx rukꞌ ri xtaqaw lo we, riꞌ kꞌo ukꞌaslemal na jinta utaqexik y na kukꞌul ta ri kꞌaxkꞌolil re ri qꞌatbꞌal tzij. Jekꞌulaꞌ, na jinta chi puqꞌabꞌ ri kamik, ma asu xqꞌax chupa ri kꞌaslemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Paqatzij wi kambꞌiꞌij che alaq: Kopon kꞌu ri ora y e chi uqꞌijol waꞌ echiriꞌ ri na jinta kikꞌaslem chwach ri Dios, kakita ruqul Rukꞌajol ri Dios. Yey china taq kꞌu riꞌ ri kakikoj utzij, kꞌo kikꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Ma puqꞌabꞌ ri Qaqaw Dios kꞌo wi kuya kꞌaslemal; jekꞌulaꞌ uyaꞌom puqꞌabꞌ Rukꞌajol kuya kꞌaslemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Yey ri Dios uyaꞌom ne puqꞌabꞌ Rukꞌajol kuqꞌat tzij pakiwi ri tikawex, ma Rukꞌajol e Alaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","»Makam animaꞌ alaq che waꞌ, ma kopon ri ora echiriꞌ konoje ri ekaminaq kakita ruqul Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Janipa ri xkiꞌan ri utz, riꞌ keyaktaj lo che jun kꞌastajibꞌal re kꞌaslemal. Noꞌj janipa kꞌu ri xkiꞌan ri na utz taj, riꞌ keyaktaj lo che ri qꞌatbꞌal tzij kaꞌan pakiwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","»Na jinta kꞌo kanꞌan xa pa we riꞌin. Ri qꞌatbꞌal tzij kanꞌano e ri kinutaq ri Nuqaw che uꞌanik. Yey lik jusukꞌ ri qꞌatbꞌal tzij kanꞌano. Na e ta kanꞌan riꞌ ri kuaj riꞌin; ma e kanꞌan janipa ri karaj ri Nuqaw, ri xtaqaw lo we. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We ta e laꞌ xa chiwibꞌil wibꞌ riꞌin kanqꞌalajisaj saꞌ ri nuwach, riꞌ na jinta uchak ri kambꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Kꞌo kꞌu Jun kaqꞌalajisan nuwach, waꞌ e ri Nuqaw, y wetaꞌam kꞌut ronoje ri kuqꞌalajisaj Rire panuwi riꞌin, lik qatzij. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","»Ralaq xtaq ne bꞌi alaq utzꞌonoxik che ri Juan panuwi riꞌin; y ri kꞌulubꞌal uwach xuꞌan lo rire, lik qatzij. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Pero riꞌin na kajawax ta chwe kꞌo junoq kuqꞌalajisaj saꞌ ri nuwach. Xew kꞌu kankuxtaj che alaq ri xubꞌiꞌij ri Juan panuwi riꞌin chaꞌ kakoj alaq y jelaꞌ kakolobꞌetaj alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma ri Juan e pachaꞌ juna aqꞌ karepowik y kawon chi utz. Pero ralaq xa joqꞌotaj xkiꞌkot alaq che ri Qꞌijsaq xutzijoj. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","»Kꞌo kꞌu jun kꞌutubꞌal más kꞌo uwach chwa ri xuqꞌalajisaj ri Juan panuwi riꞌin. Ma ronoje rubꞌiꞌim lo ri Nuqaw chwe re koꞌlnuꞌanaꞌ, e ri kintajin che uꞌanik. Yey ruma taq ri kanꞌano, kaqꞌalajinik, e ri Nuqaw ri xtaqaw lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Yey ri kaqꞌalajisan re saꞌ ri nuwach riꞌin e ri Nuqaw, ri taqayom lo weꞌin. Pero lik qꞌalaj na tom ta kꞌana alaq ruqul ri Dios y na ilom ta alaq uwach, yey ");
INSERT INTO acrNNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ruchꞌaꞌtem Rire na okinaq ta pa animaꞌ alaq; ma na kubꞌul ta kꞌuꞌx alaq rukꞌ ri jun utaqom lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","»Lik kꞌu katijoj ibꞌ alaq che Ruchꞌaꞌtem ri Dios tzꞌibꞌital kanoq; ma ralaq kachꞌobꞌ alaq e chupa waꞌ kariqitaj wi ri kꞌaslemal na jinta utaqexik. ¡Yey ekꞌu riꞌ Ruchꞌaꞌtem ri Dios ri kaqꞌalajisan nuwach riꞌin! ");
INSERT INTO acrNNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Na rukꞌ ta kꞌu riꞌ, na kaꞌaj ta alaq kape alaq wukꞌ chaꞌ jelaꞌ kakꞌul alaq waꞌ wa kꞌaslemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","»Riꞌin na e ta kantzukuj ri yakbꞌal nuqꞌij kakiꞌan ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Yey lik ne wetaꞌam ri kꞌuꞌx alaq, ma ralaq na kꞌax ta kanaꞌ alaq ri Dios pa saqil wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Riꞌin in petinaq pa rubꞌiꞌ ri Nuqaw yey ralaq na kakoj ta alaq nutzij. Noꞌj we ta e laꞌ kakꞌun chi lo jun chik y xa pa re katzijonik, riꞌ e kakoj alaq re. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","»¿Suꞌanik kakubꞌiꞌ kꞌuꞌx alaq wukꞌ riꞌin, we xew katzukuj yakbꞌal qꞌij alaq chiwach ralaq yey na katzukuj ta alaq ri saqil yakbꞌal qꞌij, ri xew kape rukꞌ ri Dios? ");
INSERT INTO acrNNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","E chiwach ralaq kankoj mak alaq chwach ri Nuqaw; na e ta riꞌ. Ma ri kakojow mak chiꞌij alaq, e ri jun lik kubꞌam kꞌuꞌx alaq rukꞌ; waꞌ e ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ma we ta e laꞌ lik kakoj alaq ri ubꞌiꞌim lo ri Moisés, riꞌ kakoj alaq ri kantzijoj riꞌin. Ma rire panuwi riꞌin xtzꞌibꞌan wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Noꞌj we na kakoj ta alaq rutzꞌibꞌam kan ri Moisés, ¿saꞌ kꞌu uꞌanik riꞌ kakoj alaq ri kambꞌiꞌij riꞌin che alaq?» xcha ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Kꞌate tanchi kꞌu riꞌ, ri Jesús xuqꞌaxuj ri mar re Galilea, ri kabꞌiꞌx mar re Tiberias che. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Yey ukꞌiyal winaq eteran chirij ma kilom taq ri kꞌutubꞌal re ruchuqꞌabꞌ kuꞌan kukꞌ ri yewaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Ekꞌuchiriꞌ, ri Jesús xel bꞌi chwa jun juyubꞌ y xtzꞌuyiꞌ chilaꞌ junam kukꞌ rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Xa naqaj chi kꞌo wi lo ruqꞌijol ri Pascua, ri kinimaqꞌij raj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Echiriꞌ ri Jesús xeril rukꞌiyal winaq e petinaq rukꞌ, xubꞌiꞌij kꞌu che ri Felipe: —¿Pa keꞌqaloqꞌo wi kiwa konoje wuꞌkꞌiyal winaq chaꞌ kewaꞌik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Xubꞌiꞌij waꞌ che ri Felipe xa re kꞌambꞌal upa, ma Rire retaꞌam chik saꞌ ri kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ri Felipe xukꞌul uwach: —E laꞌ kaloqꞌiꞌ pam rukꞌ rajil kebꞌ ciento qꞌij re chak, na kuꞌan taj tobꞌ ne xa jutaq bꞌiqꞌ kayaꞌiꞌ chikijujunal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Ewi jun chike rutijoꞌn (waꞌ e ri Andrés, ri kichaqꞌ kibꞌ rukꞌ ri Pedro) xubꞌiꞌij che ri Jesús: ");
INSERT INTO acrNNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—Kꞌo jun ralko ala wara rukꞌaꞌam woꞌobꞌ pam re cebada y kaꞌibꞌ kar; pero ¿saꞌ ko uchak waꞌ che wa ukꞌiyal winaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Xubꞌiꞌij kꞌu ri Jesús: —Chibꞌiꞌij chike konoje ri winaq ketzꞌuyiꞌik —xchaꞌ. Lik kꞌut kꞌo rax kꞌim pa ri e kꞌo wi y xetzꞌuyiꞌ laj e lo woꞌobꞌ mil chi achijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ekꞌuchiriꞌ, ri Jesús xukꞌam ri pam, xutioxij che ri Dios y xujach chike rutijoꞌn. Y rike xkijach chike ri winaq etzꞌulik. Jekꞌulaꞌ xuꞌan che ri kar. Xuya chikijujunal janipa ri kakaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Echiriꞌ ri winaq lik xenoj chi utz, ri Jesús xubꞌiꞌij chike rutijoꞌn: —Chimolo ri chꞌaqaꞌtaꞌq kiqax chaꞌ na jinta kꞌo kakꞌaq bꞌi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Xkimol kꞌu ri chꞌaqaꞌtaꞌq kiqax na xkitij ta che ri woꞌobꞌ pam re cebada y rukꞌ waꞌ xkinojisaj kabꞌlajuj chakach. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Ekꞌu ri winaq, echiriꞌ xkil wa kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xuꞌan ri Jesús, jewaꞌ xkibꞌiꞌij: «Paqatzij wi, waꞌ e ri jun Qꞌalajisanel qoyeꞌem kakꞌun che ruwachulew» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Pero ri Jesús ruma retaꞌam chik kakaj kakikꞌam bꞌi re kakiꞌan rey che, xresaj bꞌi ribꞌ chikixoꞌl y xel bꞌi chwa ri juyubꞌ chaꞌ kakꞌojiꞌ utukel. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Echiriꞌ xok raqꞌabꞌ, rutijoꞌn ri Jesús xeqaj chuchiꞌ ri mar. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Xebꞌok bꞌi chupa jun barco y ekꞌu riꞌ keqꞌax chꞌaqa yaꞌ chaꞌ kebꞌopon Capernaúm; ma lik qꞌequꞌm chik y ri Jesús na kꞌuninaq taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Xpe kꞌu jun kaqjiqꞌ chwi ri mar y ri tew xujeq kuxulkꞌatilaꞌ ri yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Echiriꞌ ebꞌininaq chi laj woꞌobꞌ o waqibꞌ kilómetro chwi ri mar, kꞌate xkilo kabꞌin ri Jesús chwi ri yaꞌ, e riꞌ katajin roponik chunaqaj ri barco; y rike lik xkixiꞌij kibꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Noꞌj ri Jesús xubꞌiꞌij chike: —¡Mixiꞌij iwibꞌ, ma riꞌin in Jesús! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Ewi rike lik kekiꞌkotik xkikꞌul ri Jesús chupa ri barco. Tekꞌuchiriꞌ, xebꞌopon pa ri luwar pa kebꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chukaꞌm qꞌij kꞌut, ri winaq ekanajinaq kan chꞌaqa mar xkinaꞌbꞌej rutijoꞌn ri Jesús ebꞌenaq chi chupa ri barco ri xew riꞌ kꞌo chiriꞌ iwir lo riꞌ, yey ri Jesús na xeꞌek ta kukꞌ rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Xekꞌun kꞌu lo jujun barcos e petinaq Tiberias, chunaqaj ri luwar pa xtijiꞌ wi ri pam, echiriꞌ ri Qanimajawal utioxim chi waꞌ che ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Echiriꞌ ri winaq xkilo na jinta ri Jesús chiriꞌ y na e jinta ne rutijoꞌn, xebꞌok bꞌi chupa wa barcos y xebꞌek Capernaúm chaꞌ kakitzukuj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Echiriꞌ xebꞌopon ri winaq chꞌaqa mar, xeꞌkiriqa ri Jesús y xkitzꞌonoj che: —Lal tijonel, ¿jampa xkꞌun la wara? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ekꞌu ri Jesús xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij che alaq: Kintzukuj alaq xa ruma lik xwaꞌ alaq chi utz y xnoj alaq chi utz, na e ta ruma xmaj alaq usukꞌ taq ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios nuꞌanom loq. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Maya kꞌu ibꞌ alaq che utzukuxik ri wa xa kakꞌisik; e lik yaꞌa ibꞌ alaq che utzukuxik ri wa na kikꞌow ta kꞌana uqꞌij, ri kuya kꞌaslemal na jinta utaqexik. Yey ri kayaꞌw waꞌ che alaq, e Ralaxel Chikixoꞌl Tikawex, ri chaꞌtal lo ruma ri Qaqaw Dios re kuꞌan waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Xkitzꞌonoj kꞌu che: —¿Saꞌ taq ri kaqaꞌano chaꞌ e kaqaꞌan janipa ri karaj ri Dios chiqe? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ri Jesús xukꞌul uwach: —Ri karaj ri Dios kaꞌan alaq, e ri kakubꞌiꞌ kꞌuꞌx alaq rukꞌ ri jun utaqom lo Rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Ekꞌuchiriꞌ xkitzꞌonoj che: —¿Saꞌ ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios kaꞌan la chiqawach chaꞌ kaqilo y jelaꞌ kakubꞌiꞌ qakꞌuꞌx ukꞌ la? ¿Saꞌ ri kariq la uꞌanik? ");
INSERT INTO acrNNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ma ri qatiꞌ-qamam ojertan xkitij ri maná pa ri luwar katzꞌintzꞌotik, jelaꞌ pachaꞌ ri kubꞌiꞌij Ruchꞌaꞌtem ri Dios: Xuya pam chike, y waꞌ petinaq chilaꞌ chikaj —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij che alaq: Na e ta ri Moisés xyaꞌw re ri pam petinaq chilaꞌ chikaj; e ri Nuqaw ri kayaꞌw ri saqil pam kape chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Ma ri Pam kuya ri Dios e ri jun petinaq chilaꞌ chikaj, ri kayaꞌw kꞌaslemal chike ri tikawex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Xkitzꞌonoj kꞌu che: —Qajawal, yaꞌa ko la qeꞌoj riꞌ laꞌ la pam ronoje qꞌij —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ri Jesús xubꞌiꞌij chike: —In ri in pam kuya kꞌaslemal. China ri kape wukꞌ riꞌin, na kutij ta chi numik; y china ri kakubꞌiꞌ ukꞌuꞌx wukꞌ, riꞌ na kachaqij ta chi kꞌana uchiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","»Pero e pachaꞌ ri nubꞌiꞌim chi lo che alaq: Ralaq na kakubꞌiꞌ ta kꞌuꞌx alaq wukꞌ, tobꞌ ne ilom alaq nuwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ma konoje ri keyaꞌiꞌ chwe ruma ri Nuqaw, kekꞌun wukꞌ riꞌin; yey china kꞌu riꞌ ri kape wukꞌ riꞌin, na kanmachꞌaj tubꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","»Riꞌin na ximpe ta chilaꞌ chikaj xa re koꞌlnuꞌana ri kuaj riꞌin, ma e in petinaq re koꞌlnuꞌana ri karaj ri Jun xtaqaw lo we. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Yey ri karaj ri Nuqaw, ri xintaqaw loq, e na kanjam ta kan junoq chike ri ebꞌuyaꞌom Rire chwe; ma e kenukꞌastajisaj lo konoje waꞌ chupa ri kꞌisbꞌal qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ekꞌu ri lik karaj ri Nuqaw, ri xtaqaw lo weꞌin, e waꞌ: Konoje ri tikawex, ri kakiya ri kiwach wukꞌ ri in Ukꞌajol ri Dios y kakubꞌiꞌ kꞌu kikꞌuꞌx wukꞌ, kakꞌojiꞌ kikꞌaslemal na jinta utaqexik. Ekꞌu riꞌin kenukꞌastajisaj lo chikixoꞌl ri ekaminaq chupa ri kꞌisbꞌal qꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Rukꞌ kꞌu riꞌ waꞌ, raj judiꞌabꞌ xkijeq kechꞌaꞌt chirij ri Jesús ruma ri xubꞌiꞌij: «In ri in pam petinaq chilaꞌ chikaj.» ");
INSERT INTO acrNNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Xkibꞌiꞌij kꞌu riꞌ: «¿Na e ta nebꞌa Jesús waꞌ, rukꞌajol ri José? Riꞌoj qetaꞌam uwach ruqaw y qetaꞌam uwach ruchu. ¿Suꞌchak kꞌu riꞌ kubꞌiꞌij petinaq chilaꞌ chikaj?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Xubꞌiꞌij kꞌu ri Jesús chike: —Mixchꞌaꞌtibꞌen chiwach chirij wa ximbꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma na jinta junoq kape wukꞌ riꞌin, we na e ta kꞌamayom lo ri Nuqaw, ri taqayom lo weꞌin. Yey ri kape wukꞌ, kankꞌastajisaj lo chupa ri kꞌisbꞌal qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","»Jewaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios chupa ri tzꞌibꞌital kan kuma ri qꞌalajisanelabꞌ: Kopon na ri qꞌij echiriꞌ e ri Dios ri kakꞌutun chikiwach konoje kachaꞌ. Y konoje ri kakita ri kubꞌiꞌij ri Nuqaw y kakimaj kꞌu ke janipa ri kubꞌiꞌij, riꞌ kekꞌun wukꞌ riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma na jinta jun chik iliyom uwach ri Qaqaw Dios; xew ri jun petinaq rukꞌ ri Dios, e iliyom uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","»Paqatzij wi kambꞌiꞌij che alaq: China ri kakubꞌiꞌ ukꞌuꞌx wukꞌ riꞌin, kꞌo ukꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Ma in ri in pam kuya kꞌaslemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","»Ojertan ri chuꞌqaw alaq xkitij ri maná pa ri luwar katzꞌintzꞌotik; na rukꞌ ta kꞌu riꞌ, rike xekamik. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Noꞌj riꞌin e kinchꞌaꞌt chwi ri pam kape chilaꞌ chikaj; yey we kꞌo junoq katijow re waꞌ, riꞌ na kakam taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","»Ri pam re kꞌaslemal petinaq chilaꞌ chikaj e riꞌin. China kꞌu katijow re wa pam, kꞌo ukꞌaslemal na jinta utaqexik. Yey ri pam kanya riꞌin, e ri nutiꞌjil kanya pa kꞌax chaꞌ taq ri tikawex kꞌo kikꞌaslemal chwach ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ekꞌuchiriꞌ, raj judiꞌabꞌ xkijeq kakichapalaꞌ kibꞌ chikiwach, jewaꞌ kakibꞌiꞌij: «¿Suꞌanik waꞌchi karaj kuya chitijik rutiꞌjil chiqe?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ri Jesús xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij che alaq: We e laꞌ na katij ta alaq ri nutiꞌjil ri in Alaxel Chikixoꞌl Tikawex y we na katij ta alaq ri nukikꞌel, riꞌ na jinta kꞌaslemal alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","China kꞌu ri kutij ri nutiꞌjil y ri nukikꞌel, riꞌ kꞌo ukꞌaslemal na jinta utaqexik, yey riꞌin kankꞌastajisaj lo chupa ri kꞌisbꞌal qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Ma ri nutiꞌjil e saqil waꞌim y ri nukikꞌel e saqil yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","China kꞌu ri kutij ri nutiꞌjil y kutij ri nukikꞌel, riꞌ kakꞌojiꞌ wukꞌ y riꞌin kinkꞌojiꞌ rukꞌ rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","»Ri Qaqaw Dios, ri aj yaꞌl kꞌaslemal, e ri xtaqaw lo weꞌin; yey kꞌo nukꞌaslemal ruma Rire. Jekꞌulaꞌ china ri kutij ri nutiꞌjil riꞌin, riꞌ kꞌo ukꞌaslemal wuma riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Kinchꞌaꞌt chwi ri pam petinaq chilaꞌ chikaj. Waꞌ na e ta pachaꞌ ri maná xkitij ri chuꞌqaw alaq ojertan. Ma tobꞌ xkitij ri maná, rike xekamik. Noꞌj china ri kutij re wa pam kambꞌiꞌij riꞌin, riꞌ kꞌo ukꞌaslemal na jinta utaqexik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","E kꞌutunik waꞌ xuꞌan ri Jesús pa kimolom wi kibꞌ chupa ri sinagoga re Capernaúm. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Echiriꞌ xkita ri kꞌutunik xuꞌan ri Jesús, lik e kꞌi chike rutijoꞌn xkibꞌiꞌij: «Waꞌ wa kubꞌiꞌij, lik kꞌax utayik. ¿Kꞌo nebꞌa junoq kachꞌijow ukꞌulik?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ekꞌu ri Jesús xunaꞌbꞌej ri chꞌaꞌtibꞌenik kakiꞌan chwi rukꞌutunik. Xutzꞌonoj kꞌu chike: —¿Kuꞌan kꞌax waꞌ che alaq? ");
INSERT INTO acrNNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Saꞌ kꞌu riꞌ ri kaꞌan alaq we ta e laꞌ kil alaq Ralaxel Chikixoꞌl Tikawex kaqꞌan chilaꞌ chikaj pa petinaq wi? ");
INSERT INTO acrNNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ri saqil kꞌaslemal na jinta utaqexik petinaq rukꞌ ri Ruxlabꞌixel ri Dios; na e ta ri petinaq xa rukꞌ ri tikawex, ma riꞌ na jinta uchak re kuya ri saqil kꞌaslemal. Ekꞌu ri chꞌaꞌtem nubꞌiꞌim riꞌin che alaq, waꞌ petinaq rukꞌ ri Ruxlabꞌixel ri Dios, ri aj yaꞌl kꞌaslemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Pero e kꞌo kꞌu jujun chixoꞌl alaq na kubꞌul ta kikꞌuꞌx wukꞌ —xchaꞌ. Ri Jesús xubꞌiꞌij waꞌ ma xex chi retaꞌam wi china taq ri na kubꞌul ta kikꞌuꞌx rukꞌ y china ri kakꞌayin re. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Xubꞌiꞌij tanchi ri Jesús: —Ekꞌu uwariꞌche nubꞌiꞌim che alaq: Na jinta junoq kape wukꞌ, we na e ta ri Nuqaw kꞌamayom lo re —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Chwi kꞌu riꞌ, e kꞌi chike rutijoꞌn ri Jesús xkiya kanoq y na xeterej ta chi chirij. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Ekꞌuchiriꞌ, xutzꞌonoj ri Jesús chike ri kabꞌlajuj utijoꞌn: —¿Kiwaj nebꞌa riꞌix kiꞌan iwe kiniya kanoq, pachaꞌ ri xkiꞌan rike? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ri Simón Pedro xukꞌul uwach: —Qajawal, ¿china chi chirij kojꞌek wi? Ma xew ukꞌ rilal kꞌo ri chꞌaꞌtem kuya kꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Riꞌoj lik kubꞌul chi qakꞌuꞌx ukꞌ la y lik qetaꞌam waꞌ: Lal Ruchaꞌoꞌn lo ri Dios, Rukꞌajol ri Dios kꞌaslik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Ri Jesús xukꞌul uwach: —¿Na in ta nebꞌa inchaꞌyom iwe riꞌix ix kabꞌlajuj? Na rukꞌ ta kꞌu riꞌ, jun chiwe kꞌo ritzel winaq pa ranimaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Echiriꞌ xubꞌiꞌij waꞌ, ri Jesús e xchꞌaꞌt puwi ri Judas aj Iscariot rukꞌajol ri Simón; ma e ri Judas kakꞌayin re, tobꞌ e jun chike ri kabꞌlajuj utijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Kꞌate tanchi kꞌu riꞌ, ri Jesús xbꞌin pa taq ri luwar re Galilea; na xraj taj kakꞌojiꞌ Judea ma chilaꞌ raj judiꞌabꞌ kakaj kakikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Xa kꞌu naqaj chi kꞌo wi lo ruqꞌijol ri kinimaqꞌij raj judiꞌabꞌ echiriꞌ kakiꞌan kirancho. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","E taq kꞌu ruchaqꞌ xkibꞌiꞌij che: —Matkanaj kan wara; jat Judea chaꞌ ri jujun chik atijoꞌn e kꞌo chilaꞌ kakilo saꞌ taq ri kaꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ma we junoq karaj ketaꞌmax uwach, ronoje ri kuꞌano kuꞌan chiwachil. E uwariꞌche, chaꞌana waꞌ chikiwach konoje ri tikawex —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Xkibꞌiꞌij waꞌ che ma na kakikoj taj we Rire e Ruchaꞌoꞌn lo ri Dios, tobꞌ ne rike e uchaqꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Xubꞌiꞌij kꞌu Rire chike: —Ri nuqꞌijol riꞌin kꞌamajaꞌ koponik; noꞌj riꞌix, xa tobꞌ pachike qꞌij utz chiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ri tikawex re ruwachulew na tzel ta kixkil riꞌix; noꞌj riꞌin lik tzel kinkilo, ma kanqꞌalajisaj chi utz ri kimak. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jix riꞌix che ri nimaqꞌij; noꞌj riꞌin na kinꞌek ta woꞌora, ma kꞌamajaꞌ kopon ri nuqꞌijol —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Xubꞌiꞌij kꞌu waꞌ y xkanaj kan Galilea. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Ekꞌuchiriꞌ ebꞌenaq chi ruchaqꞌ, ri Jesús xeꞌek pa ri nimaqꞌij, pero na xeꞌek ta chiwachil chaꞌ taq ri winaq na kakinaꞌbꞌej taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Pa ri nimaqꞌij raj judiꞌabꞌ lik kakitzukuj ri Jesús, y jewaꞌ kakibꞌiꞌij: «¿Pa nawi kꞌo wi laꞌ la jun achi?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Chikixoꞌl ri winaq lik e kꞌi ri kakichꞌaꞌtibꞌej ri Jesús. Jujun kakibꞌiꞌij: «Laꞌ la Jesús lik utz ukꞌuꞌx» kechaꞌ. Yey e kꞌo jujun chik kakibꞌiꞌij: «Laꞌ la Jesús lik na utz ta ri kuꞌano ma xa kebꞌusok ri winaq» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Pero na jinta kꞌu junoq kachꞌaꞌt puwi ri Jesús chiwachil; xa xeꞌlaqꞌay kechꞌaꞌt puwiꞌ, ma kakixiꞌij kibꞌ chikiwach raj judiꞌabꞌ e aj wach. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ekꞌu riꞌ nikꞌajarinaq chi ri nimaqꞌij xopon ri Jesús pa ri Rocho Dios y xujeqo kakꞌutun chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Raj judiꞌabꞌ lik xkam kanimaꞌ che y jewaꞌ xkibꞌiꞌij: «¿Chaꞌtaj lik kꞌo retaꞌam yey na jinta kꞌo kꞌutuyum chwach?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ri Jesús xukꞌul uwach: —Ri kintajin che ukꞌutik na xa ta pa we riꞌin kanꞌano; ma waꞌ petinaq rukꞌ ri taqayom lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","We kꞌo kꞌu junoq lik kuya ribꞌ che uꞌanik ri karaj ri Dios, riꞌ karetaꞌmaj we ri kankꞌutu rukꞌ ri Dios kape wi, o we xa pa we riꞌin kinchꞌaꞌtik. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma china ri xa pa re kachꞌaꞌtik, riꞌ xew karaj kayak uqꞌij kuma ri winaq. Noꞌj china ri karaj e kayak uqꞌij ri taqayom lo re, riꞌ lik qatzij ri kutzijoj y na jinta kꞌana raqꞌubꞌal kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","»¿Na qatzij ta nebꞌa laꞌ e ri Moisés xyaꞌw che alaq ri Tzij Pixabꞌ? Na rukꞌ ta kꞌu riꞌ, na jinta junoq che alaq kaꞌanaw re ronoje ri kꞌo chupa wa Tzij Pixabꞌ. ¿Suꞌchak kaꞌaj alaq kinkamisaj alaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Ekꞌu taq ri winaq xkikꞌul uwach: —Lal kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. ¿China ri karaj kakamisan e la? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Ri Jesús xubꞌiꞌij chike: —Riꞌin kꞌo jun kꞌutubꞌal re ruchuqꞌabꞌ ri Dios xinꞌano, yey onoje ralaq lik kakam animaꞌ alaq che ma xinꞌan waꞌ chupa ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","»Paqatzij wi, ri Moisés xuya che alaq ri jun taqanik re ri retalil re circuncisión tobꞌ na e ta rire xjeqow loq, ma e xejeqow lo re ri qatiꞌ-qamam ojertan. Yey ralaq kakoj alaq ri retalil re circuncisión che junoq tobꞌ pa ri qꞌij re uxlanibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Kaꞌan alaq waꞌ ma ri taqanik re ri Moisés kutaq che kaꞌaniꞌ ri circuncisión pa ri uwajxaq qꞌij ralaxibꞌem juna ralko ala. Kaꞌan kꞌu alaq riꞌ, tobꞌ waꞌ katzaq pa ri qꞌij re uxlanibꞌal, chaꞌ na kapalajij ta alaq wa taqanik re ri Moisés. ¿Suꞌbꞌe kꞌu riꞌ kꞌo oyowal alaq chwij riꞌin ruma xinkunaj jun achi pa ri qꞌij re uxlanibꞌal? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","»Makoj alaq umak junoq xa ruma kachꞌobꞌ alaq etaꞌam alaq ri uꞌanom; ri ꞌana alaq e chꞌobꞌo alaq rukꞌ saqil naꞌoj puwi ri paqatzij wi uꞌanom, we kꞌo umak o na jintaj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","E kꞌo jujun chike ri e aj Jerusalem kakitzꞌonobꞌej: «¿Na e ta achi waꞌ ketajin che utzukuxik re kakikamisaj? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","¿Suꞌchak kꞌu riꞌ kayaꞌ luwar che kachꞌaꞌt chiwachil yey na jinta ne junoq kaqꞌaten re? ¿Kikojom chi nawi raj wach re ri tinamit rire e ri Cristo, Ruchaꞌoꞌn lo ri Dios? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ma riꞌoj qetaꞌam chi utz pa kape wi waꞌchi; noꞌj we xkꞌun ri Cristo, riꞌ na jinta junoq etaꞌmayom re pa kape wi» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ri Jesús kakꞌutun pa ri Rocho Dios echiriꞌ xuta waꞌ. Lik ko kꞌu xsikꞌin che ubꞌiꞌxikil: —Kabꞌiꞌij ralaq lik etaꞌam alaq nuwach y lik etaꞌam alaq pa kimpe wi. Pero lik chetaꞌmaj kꞌu alaq waꞌ: Riꞌin na in petinaq ta xa pa we riꞌin, ma intaqom lo ruma ri Jun lik ubꞌe ronoje taq ri kuꞌano. Yey ralaq na etaꞌam ta alaq uwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Noꞌj riꞌin wetaꞌam uwach, ma rukꞌ Rire in petinaq wi y e Rire taqayom lo weꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Ekꞌuchiriꞌ, raj wach xkaj e riꞌ kakichap bꞌi ri Jesús; pero na jinta junoq xꞌanaw re, ma kꞌamajaꞌ kopon ruqꞌijol. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Na rukꞌ ta kꞌu riꞌ, chikixoꞌl rukꞌiyal winaq, lik e kꞌi xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús y kakibꞌiꞌij: «Chiwach ralaq, echiriꞌ kakꞌun Ruchaꞌoꞌn lo ri Dios, ¿kuꞌan kami más kꞌutubꞌal riꞌ re ruchuqꞌabꞌ ri Dios chwa wa kuꞌan waꞌchi?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Ri fariseos xkita ri kakibꞌiꞌij ri winaq puwi ri Jesús. E uwariꞌche, rike kukꞌ ri nimaq e aj chakunel pa Rocho Dios xekitaq bꞌi ri e chajinel re ri Rocho Dios chaꞌ kakichap lo ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Xubꞌiꞌij kꞌu ri Jesús: —Riꞌin na naj ta chi kinkꞌojiꞌ ukꞌ alaq, ma kintzelej rukꞌ ri taqayom lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Kopon na kꞌu riꞌ ri qꞌij echiriꞌ kintzukuj alaq; pero na kinriq ta alaq, ma na kopon ta alaq pa kineꞌkꞌola wi riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Ekꞌu ri e aj judiꞌabꞌ xkijeq kakitzꞌonobꞌej chikiwach: «¿Pa nawi keꞌek wi waꞌchi yey na keꞌqariqa ta riꞌoj? ¿Keꞌek nawi kukꞌ ri e aj judiꞌabꞌ ejeqel chikixoꞌl ri e aj griegos y keꞌkꞌutuna chikiwach? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Saꞌ keꞌelawi wa xubꞌiꞌij chiqe: “Kintzukuj alaq; pero na kinriq ta alaq, ma na kopon ta alaq pa kineꞌkꞌola wi riꞌin”?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Che ri kꞌisbꞌal re ri nimalaj nimaqꞌij, ri Jesús xtakꞌiꞌ chikiwach ri winaq y ko xsikꞌin che ubꞌiꞌxikil: «We kꞌo junoq katzajin uchiꞌ, petoq y chutija re ri yaꞌ kꞌo wukꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ma e pachaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios: Ri kakubꞌiꞌ ukꞌuꞌx wukꞌ riꞌin, kuꞌana pachaꞌ kajuljut taq lo akꞌal re yaꞌ kꞌaslik pa ranimaꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Rukꞌ waꞌ ri Jesús e kachꞌaꞌt puwi ri Ruxlabꞌixel ri Dios ri kakikꞌul na janipa ri kakubꞌiꞌ kikꞌuꞌx rukꞌ. Yey kꞌamajaꞌ kꞌu kakꞌun riꞌ ri Ruxlabꞌixel ri Dios ma kꞌamajaꞌ ne keꞌek ri Jesús chilaꞌ chikaj pa kaqꞌalajisax wi runimal uchomalil. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","E kꞌo kꞌu jujun chike ri winaq, echiriꞌ xkita waꞌ, jewaꞌ kakibꞌiꞌij: «Paqatzij wi waꞌchi e ri jun qꞌalajisanel re ri Dios qoyeꞌem kakꞌunik» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Jujun chik jewaꞌ kakibꞌiꞌij: «Waꞌ waꞌchi e ri Cristo, Ruchaꞌoꞌn lo ri Dios» kechaꞌ. Yey jujun chik jewaꞌ kakibꞌiꞌij: «¿Galilea nebꞌa kape wi lo ri Cristo? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Na Galilea taj, ma tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios, ri Cristo kalax lo chikixoꞌl ri ratz-uchaqꞌ kan ri rey David pa ri tinamit Belén, rutinamit ri David» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Jekꞌulaꞌ riꞌ ri winaq jachatal kipa ruma junwi taq ri kakichꞌobꞌ raqan puwi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","E kꞌo ne jujun chike ri winaq xkaj kakichap bꞌi ri Jesús, pero na jinta junoq xꞌanaw re. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Ri e chajinel re ri Rocho Dios xetzelej pa e kꞌo wi ri xetaqaw lo ke, waꞌ e ri fariseos y ri nimaq e aj chakunel pa Rocho Dios, yey rike xkitzꞌonoj chike raj chajinel: —¿Suꞌchak na xikꞌam ta lo ri Jesús? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ri e chajinel jekꞌuwaꞌ xkikꞌul uwach: —¡Na jinta junoq jelaꞌ chꞌaꞌtinaq pachaꞌ kachꞌaꞌt waꞌ waꞌchi! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Ekꞌu ri fariseos xkibꞌiꞌij chike: —¿Xixsokotaj kami riꞌ riꞌix ruma rire? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Kꞌo nebꞌa junoq chike raj wach re ri tinamit o chike ri fariseos xkubꞌiꞌ ukꞌuꞌx rukꞌ waꞌ waꞌchi? ");
INSERT INTO acrNNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Noꞌj wa winaq eteran chirij ri Jesús, lik itzel kiwachlibꞌal ma na kakimaj ta kꞌana usukꞌ ri Tzij Pixabꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ekꞌu ri Nicodemo, ri jun fariseo xopon julaj chaqꞌabꞌ rukꞌ ri Jesús, jewaꞌ xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—Kubꞌiꞌij ri Tzij qeꞌoj, na utz taj kaqꞌat tzij puwi junoq, we na kataꞌ ta uchiꞌ nabꞌe y we na ketaꞌmax ta nabꞌe we kꞌo juna mak uꞌanom —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Xkikꞌul kꞌu uwach ri Nicodemo: —¿Lal kami aj Galilea rilal? Chajilaj la chi utz Ruchꞌaꞌtem ri Dios y jelaꞌ ketaꞌmaj la we kꞌo juna qꞌalajisanel elinaq lo chikixoꞌl raj Galilea —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Ekꞌuchiriꞌ, chikijujunal xebꞌek chikocho. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Ri Jesús xeꞌek chwa ri juyubꞌ Olivos. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Echiriꞌ xsaqirik, xtzelej tanchi pa ri Rocho Dios. Konoje ri winaq xeqibꞌ rukꞌ y Rire xtzꞌuyiꞌ chikiwach y xujeqo kuꞌan kꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ekꞌuchiriꞌ, raj kꞌutunel re ri tzijpixabꞌ y ri fariseos xkikꞌam lo jun ixoq chwach. Waꞌ wiꞌxoq xkimajo e riꞌ kamakun chirij ri kꞌulanikil rukꞌ jun achi na rachijil taj. Xkiya kꞌu chikinikꞌajal konoje ri e kꞌo chiriꞌ ");
INSERT INTO acrNNT_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","y jewaꞌ xkibꞌiꞌij che ri Jesús: —Lal tijonel, wa jun ixoq xqamajo lik e riꞌ kamakun chirij ri kꞌulanikil rukꞌ jun achi na rachijil taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Yey ri Moisés, chupa ri Tzij Pixabꞌ kataqan che kaꞌan paꞌbꞌaj juna ixoq we kuꞌan waꞌ. ¿Saꞌ kꞌu ri kabꞌiꞌij rilal che? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Xkibꞌiꞌij waꞌ che ri Jesús xa re kꞌambꞌal upa chaꞌ kakikoj umak. Ekꞌu ri Jesús xchꞌukiꞌik y rukꞌ ruwi uqꞌabꞌ xujeq katzꞌibꞌan chwa rulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Yey rike lik kakikꞌot upa chaꞌ kukꞌul uwach ri tzꞌonobꞌal. Ekꞌu ri Jesús xtakꞌiꞌik y xubꞌiꞌij chike: —We kꞌo junoq che alaq kunaꞌo na jinta kꞌana umak, e nabꞌe riꞌ chukꞌaqa rabꞌaj che wiꞌxoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Tekꞌuchiriꞌ, xchꞌukiꞌ tanchik y rukꞌ ruwi uqꞌabꞌ xtzꞌibꞌan tanchi chwa rulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Konoje rike echiriꞌ xkita waꞌ wa xubꞌiꞌij, xkinaꞌ kibꞌ kꞌo kimak. E uwariꞌche, pa jujun xebꞌel bꞌi. Nabꞌe xebꞌel bꞌi ri e nimaq winaq; tekꞌuchiriꞌ, ri e kꞌakꞌal. Echiriꞌ konoje ebꞌelinaq chubꞌi, xew ri Jesús y rixoq xekanaj kan chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ekꞌuchiriꞌ xtakꞌiꞌ ri Jesús y xrilo na jinta chi junoq chiriꞌ, xew chi rixoq, xubꞌiꞌij kꞌu che: —Ixoq ¿pa e kꞌo wi ri kakikoj amak? ¿Na jinta junoq xuqꞌat tzij re kamik pawiꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Rixoq xubꞌiꞌij che: —Na jinta junoq, Wajawal —xchaꞌ. Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij che: —Jenelaꞌ riꞌin na kanqꞌat ta tzij re kamik pawiꞌ. Jat kꞌu riꞌ y matmakun chik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Ri Jesús xchꞌaꞌt tanchi kukꞌ ri winaq, jewaꞌ xubꞌiꞌij chike: —In ri Qꞌijsaq che ruwachulew. China kꞌu ri katerej lo chwij, na kabꞌin ta chi kꞌenoq pa qꞌequꞌm ma kꞌo ri Qꞌijsaq rukꞌ yey waꞌ e ri kuya kꞌaslemal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Ekꞌuchiriꞌ, ri fariseos xkibꞌiꞌij che ri Jesús: —Na jinta uchak ri kabꞌiꞌij la, ma xa chiꞌibꞌil ibꞌ la kabꞌiꞌij la saꞌ ri wach la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ri Jesús xukꞌul uwach: —Tobꞌ in ri kinqꞌalajisan re saꞌ ri nuwach, ri kambꞌiꞌij lik qatzij; ma wetaꞌam pa in petinaq wi y wetaꞌam pa kinꞌek wi. Noꞌj ralaq na etaꞌam ta alaq pa in petinaq wi y na etaꞌam tane alaq pa kinꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","»Ralaq, echiriꞌ kabꞌiꞌij alaq saꞌ ri kachꞌobꞌ alaq puwi junoq, kaꞌan alaq waꞌ xa rukꞌ ri naꞌoj re ruwachulew. Noꞌj riꞌin na je ta laꞌ kanꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Echiriꞌ kꞌo kanqꞌalajisaj chirij junoq, qatzij ri kambꞌiꞌij. Ma na xa ta pa we riꞌin ri kambꞌiꞌij; ma ri nunaꞌoj riꞌin lik junam rukꞌ runaꞌoj ri Nuqaw, ri xtaqaw lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","»Yey chupa ri Tzij Pixabꞌ e alaq, tzꞌibꞌital kanoq: “We e kꞌo kaꞌibꞌ tikawex junam kakijikibꞌaꞌ uwach ri kakibꞌiꞌij, e kakoj ke riꞌ.” ");
INSERT INTO acrNNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ri kanqꞌalajisaj riꞌin chiwibꞌil wibꞌ, kajikibꞌax uwach ruma ri Nuqaw, ri taqayom lo weꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Xkitzꞌonoj kꞌu che: —¿Pa kꞌu kꞌo wi ri qaw la? —xechaꞌ. Ri Jesús xukꞌul uwach: —Ralaq na etaꞌam ta alaq nuwach riꞌin y na etaꞌam ta alaq uwach ri Nuqaw; ma we ta etaꞌam alaq nuwach riꞌin, jekꞌulaꞌ riꞌ etaꞌam alaq uwach ri Nuqaw —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ri Jesús xubꞌiꞌij waꞌ echiriꞌ kakꞌutun pa ri Rocho Dios, chiriꞌ pa kꞌo wi ri kaxa re qasaꞌn. Noꞌj na jinta junoq xchapaw bꞌi re, ma kꞌamajaꞌ kopon ruqꞌijol. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Xubꞌiꞌij tanchi ri Jesús chike: —Riꞌin kinꞌek y ralaq kintzukuj kꞌu alaq, pero kakam na kꞌu alaq riꞌ pa ri mak alaq. Ma pa kinꞌek wi riꞌin, na kopon ta ralaq chilaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Xkibꞌiꞌij kꞌu raj judiꞌabꞌ chikiwach: «Laj kukamisaj ribꞌ; e uwariꞌche kubꞌiꞌij na utz taj kojopon riꞌoj chilaꞌ pa keꞌek wi rire» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ekꞌu ri Jesús xubꞌiꞌij chike: —Ralaq na alaq ta re chilaꞌ chikaj, noꞌj riꞌin in petinaq chilaꞌ chikaj. Ralaq alaq re ruwachulew, noꞌj riꞌin na in ta re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","E uwariꞌche ximbꞌiꞌij kakam na kꞌu alaq riꞌ pa ri mak alaq. Ma we na kakoj ta alaq “In Riꞌin”, riꞌ kakam alaq pa ri mak alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Ekꞌuchiriꞌ xkitzꞌonoj che: —¿Lal china kꞌu riꞌ rilal? —xechaꞌ. Ri Jesús xukꞌul uwach: —E ri nubꞌiꞌim chi lo che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Riꞌin lik kꞌo wetaꞌam chiꞌij alaq re kojobꞌal mak alaq y re qꞌatbꞌal tzij pawiꞌ alaq; pero xew kambꞌiꞌij chikiwach konoje ri tikawex saꞌ ri nutom che ri taqayom lo weꞌin, yey Rire lik qatzij janipa ri kubꞌiꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Ri Jesús e kachꞌaꞌt puwi Ruqaw, pero rike na xkimaj ta usukꞌ waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","E uwariꞌche ri Jesús xubꞌiꞌij chike: —Echiriꞌ kayak alaq Ralaxel Chikixoꞌl Tikawex y kaya alaq chwa ri cruz, kꞌa ekꞌuchiriꞌ ketaꞌmaj alaq riꞌ: “In Riꞌin”. Yey na jinta kꞌo kanꞌan xa pa we riꞌin, ma xew kambꞌiꞌij janipa rukꞌutum ri Nuqaw chwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ma ri taqayom lo weꞌin kꞌo wukꞌ; ri Nuqaw na inuyaꞌom ta kan nutukel, ma riꞌin xew kanꞌano janipa ri karaj Rire —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Echiriꞌ xubꞌiꞌij taq waꞌ ri Jesús, lik e kꞌi ri xkikojo Rire e ri jun qꞌalajisanel koyeꞌem kakꞌunik. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike ri e aj judiꞌabꞌ xkikojo Rire e ri jun qꞌalajisanel koyeꞌem kakꞌunik. —We kataqej kꞌu alaq janipa wa kambꞌiꞌij che alaq, riꞌ paqatzij wi kuꞌan alaq nutijoꞌn; ");
INSERT INTO acrNNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","y jekꞌulaꞌ ketaꞌmaj alaq ri Qꞌijsaq, y ri Qꞌijsaq karesaj lo alaq puqꞌabꞌ ri ajaw alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Rike xkikꞌul uwach: —Riꞌoj oj ralkꞌoꞌal kan ri Abraham y na oj kꞌojiꞌnaq ta puqꞌabꞌ junoq. ¿Suꞌbꞌe kꞌu riꞌ kabꞌiꞌij la chiqe kojesax lo puqꞌabꞌ ri qajaw? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ri Jesús xubꞌiꞌij chike: —Paqatzij wi kambꞌiꞌij che alaq: Konoje ri kemakunik, puqꞌabꞌ ri mak e kꞌo wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Juna aj chak pa ja na junam ta uwach rukꞌ rukꞌajol ri rajaw ja, ma ri aj chak xa ajilam qꞌij kꞌo pa ja; noꞌj rukꞌajol na jinta utaqexik e ralkꞌoꞌal ruqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","E uwariꞌche, we Rukꞌajol ri Dios karesaj lo alaq che ri mak kꞌo wi alaq, paqatzij wi kꞌu riꞌ kakiritaj lo alaq che ri mak. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","»Riꞌin wetaꞌam alaq ralkꞌoꞌal kan ri Abraham; na rukꞌ ta kꞌu riꞌ, kaꞌaj alaq kinkamisaj alaq ma na kakꞌul ta alaq ri kankꞌut che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Riꞌin e kambꞌiꞌij ri ukꞌutum ri Nuqaw chwe, yey ralaq e kaꞌan alaq janipa rubꞌiꞌim ri qaw alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Rike xkikꞌul uwach: —Ri qaqaw riꞌoj e ri Abraham —xechaꞌ. Ekꞌu ri Jesús xubꞌiꞌij chike: —We ta paqatzij wi alaq ralkꞌoꞌal ri Abraham, e kaꞌan alaq riꞌ ri xuꞌan rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Noꞌj ralaq na je ta laꞌ katajin alaq che uꞌanik. Ma tobꞌ nubꞌiꞌim che alaq ri Qꞌijsaq ukꞌutum ri Dios chwe, na rukꞌ ta kꞌu riꞌ, kaꞌaj alaq kinkamisaj alaq. ¡Ri Abraham na je ta laꞌ xuꞌano! ");
INSERT INTO acrNNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ralaq e kaꞌan alaq pachaꞌ ri kuꞌan ri qaw alaq —xchaꞌ. Ekꞌuchiriꞌ, xkibꞌiꞌij rike che: —Riꞌoj na oj ta pachaꞌ ri winaq na ketaꞌam taj china ri kiqaw; ma xa jun ri Qaqaw, e ri Dios —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Xubꞌiꞌij kꞌu ri Jesús chike: —We ta paqatzij wi e qaw alaq ri Dios, ralaq lik kꞌax kinnaꞌ alaq riꞌ, ma riꞌin rukꞌ ri Dios in petinaq wi yey riꞌ in kꞌo chiwach alaq. Na in petinaq ta kꞌu xa pa we riꞌin, ma e ri Dios taqayom lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","»¿Suꞌbꞌe na kamaj ta alaq usukꞌ janipa ri kambꞌiꞌij che alaq? E ruma ri na kaꞌaj ta alaq kata alaq ri kambꞌiꞌij riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ri qaw alaq e ritzel winaq, ma e kaꞌan alaq saꞌ ri karaj rire. Ritzel winaq aj kamisanel chwi lo ri jeqebꞌal ruwachulew. Yey rire na xtikiꞌ ta kan pa ri Qꞌijsaq, y na jinta ne kꞌana Qꞌijsaq rukꞌ. Echiriꞌ kuꞌan raqꞌubꞌal, e kuqꞌalajisaj saꞌ ri kꞌo pa ranimaꞌ; ma xex wi aj raqꞌul yey ronoje raqꞌubꞌal rukꞌ rire kape wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Noꞌj riꞌin e kanqꞌalajisaj ri lik qatzij, yey ralaq na kakoj ta alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","»¿Kꞌo nawi junoq che alaq kuriq juna mak chwij? Yey we qatzij ri kambꞌiꞌij, ¿suꞌbꞌe kꞌu riꞌ na kakoj ta alaq? ");
INSERT INTO acrNNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","E junoq ralkꞌoꞌal ri Dios, e kuta Ruchꞌaꞌtem ri Dios; noꞌj ralaq na alaq ta ralkꞌoꞌal ri Dios, ma na kata ta alaq Ruchꞌaꞌtem —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Ekꞌuchiriꞌ, raj judiꞌabꞌ xkibꞌiꞌij che ri Jesús: —Lik qatzij ri xqabꞌiꞌij pawiꞌ la: Rilal lal kukꞌil ri aj Samaria y lal kꞌo puqꞌabꞌ jun itzel uxlabꞌixel —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Ekꞌu ri Jesús xukꞌul uwach chike: —Riꞌin na in jinta puqꞌabꞌ juna itzel uxlabꞌixel; ri kanꞌano e kanyak uqꞌij ri Nuqaw y ralaq kakꞌaq bꞌi alaq nuqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Riꞌin na kantzukuj ta yakbꞌal nuqꞌij, tobꞌ kꞌo Jun karaj kayakiꞌ nuqꞌij yey puqꞌabꞌ Rire kꞌo wi kuqꞌalajisaj china ri kꞌo Qꞌijsaq rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Paqatzij wi kambꞌiꞌij che alaq: China ri kakojow re ri kanqꞌalajisaj riꞌin, na kakam taj ma kꞌo ukꞌaslemal na jinta utaqexik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Ekꞌuchiriꞌ, raj judiꞌabꞌ xkikꞌul uwach: —Woꞌora kaqajikibꞌaꞌ uwach, lal kꞌo puqꞌabꞌ jun itzel uxlabꞌixel. Ma ri Abraham y ri qꞌalajisanelabꞌ xekamik, yey rilal kabꞌiꞌij la: “China kakojow re ri kanqꞌalajisaj, na kakam taj ma kꞌo ukꞌaslemal na jinta utaqexik.” ");
INSERT INTO acrNNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Lik nebꞌa más kꞌo wach rilal chwa ri qaqaw Abraham? Rire xkamik yey taq ri qꞌalajisanelabꞌ xekamik. Chiwach rilal, ¿saꞌ ri wach la? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Ri Jesús xukꞌul uwach: —We kanyak nuqꞌij riꞌin chiwibꞌil wibꞌ, riꞌ na jinta uchak ri yakbꞌal nuqꞌij kanꞌano; noꞌj kꞌu ri kayakaw nuqꞌij e ri Nuqaw, ri kabꞌiꞌij alaq e Dios alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ekꞌu ralaq na etaꞌam ta alaq uwach Rire; noꞌj riꞌin lik wetaꞌam uwach. We ta e laꞌ kambꞌiꞌij na wetaꞌam ta uwach, riꞌ kinelik in aj raqꞌul jelaꞌ pachaꞌ ralaq. Noꞌj riꞌin paqatzij wi wetaꞌam uwach Rire yey lik kanꞌan ronoje ri kubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ri Abraham, ri mam alaq ojertan, lik xkiꞌkotik echiriꞌ xretaꞌmaj kinkꞌun che ruwachulew; xril pan ri nuqꞌijol y lik xkiꞌkot che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Ekꞌuchiriꞌ, raj judiꞌabꞌ xkibꞌiꞌij che ri Jesús: —Kꞌamajaꞌ ne cincuenta ri junabꞌ la, ¿yey kabꞌiꞌij la xil la uwach ri Abraham? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij che alaq: Riꞌin xex chi in kꞌo lo wi echiriꞌ kꞌamajaꞌ ne kalax ri Abraham —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ekꞌuchiriꞌ, ri winaq xkijeq kakisikꞌ abꞌaj re kakiꞌan ri Jesús paꞌbꞌaj; noꞌj Rire xewax chikiwach, e laꞌ xikꞌow chikixoꞌl y xel bꞌi che ri Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ri Jesús echiriꞌ katajin chi bꞌe, xril jun achi ralaxibꞌem potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Ekꞌu rutijoꞌn xkitzꞌonoj che: —Lal tijonel, ¿wa jun achi xalaxik potzꞌ ruma nawi kimak ruchu-uqaw o ruma umak rire? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ri Jesús xukꞌul uwach chike: —Na ruma ta umak rire y na ruma tane kimak ruchu-uqaw; waꞌ e uꞌanom chaꞌ ruchuqꞌabꞌ ri Dios kaqꞌalajin rukꞌ rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Lik chirajawaxik chwe kanꞌan ruchak ri taqayom lo weꞌin xaloqꞌ kꞌa paqꞌij, ma kakꞌun lo raqꞌabꞌ echiriꞌ na jinta chi junoq utz kachakunik. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Xaloqꞌ kꞌu in kꞌo riꞌin wara che wuꞌwachulew, in ri in Qꞌijsaq che ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Echiriꞌ ubꞌiꞌim chi waꞌ, ri Jesús xchubꞌan chwa rulew, xuꞌan jubꞌiqꞌ xoqꞌoꞌl rukꞌ rukꞌaxaj. Tekꞌuchiriꞌ, xusoqꞌ che ruwach ri potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Ekꞌuchiriꞌ, xubꞌiꞌij che: —Jat, jaꞌchꞌaja rawach pa ri yaꞌ re Siloé —xchaꞌ. (Siloé keꞌelawi “ri Taqom loq”.) Ri potzꞌ e xuꞌano; xeꞌek y xuꞌchꞌaja ruwach. Ekꞌuchiriꞌ xtzelej loq, katzuꞌn chik. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ekꞌu ri ejeqel lo chunaqaj ri potzꞌ y ri kilom xaqi kuꞌan ulimoxna, jewaꞌ kakibꞌiꞌij: «¿Na e ta nebꞌa achi waꞌ katzꞌuyiꞌ chiꞌ bꞌe y kuꞌan ulimoxna?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Jujun chik kakibꞌiꞌij: «Qatzij, areꞌ» kechaꞌ. Jujun chik kakibꞌiꞌij: «Na e ta rire, tobꞌ lik e katzuꞌnik» kechaꞌ. Noꞌj rachi kunutajinaq chik, lik kujikibꞌaꞌ uwach, jewaꞌ kubꞌiꞌij: «Qatzij, in waꞌ kꞌut» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Xkitzꞌonoj kꞌu che: —¿Chaꞌta laꞌ xat-tzuꞌnik? —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Rire xukꞌul uwach: —E ri jun achi Jesús ubꞌiꞌ, xuꞌan jubꞌiqꞌ xoqꞌoꞌl, xusoqꞌ che ri nuwach y xubꞌiꞌij chwe: “Jat pa kꞌo wi ri yaꞌ re Siloé y jaꞌchꞌaja rawach chupa.” Xinꞌek kꞌu riꞌ, y echiriꞌ xinchꞌaj ri nuwach, xinjeq kintzuꞌnik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Xkitzꞌonoj kꞌu che: —¿Pa kꞌo wi riꞌ laꞌ laꞌchi? —xecha che. Rire xukꞌul uwach: —Na wetaꞌam taj pa kꞌo wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Ekꞌuchiriꞌ xkikꞌam bꞌi ri potzꞌ kunutajinaq chik chikiwach ri fariseos; ");
INSERT INTO acrNNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ma e pa jun qꞌij re uxlanibꞌal echiriꞌ ri Jesús xuꞌan xoqꞌoꞌl y xukunaj ri potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Jenelaꞌ ri fariseos xkitzꞌonoj che chaꞌtaj xtzuꞌnik. Rire xukꞌul uwach chike: —Rachi xusoqꞌ xoqꞌoꞌl che ri nuwach, xinchꞌaj kꞌu ri nuwach y woꞌora kintzuꞌnik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ekꞌuchiriꞌ, jujun chike ri fariseos kakibꞌiꞌij chikiwach: «Laꞌ laꞌchi xꞌanaw re waꞌ, na rukꞌ ta ri Dios petinaq wi; ma e kuꞌan ri na ubꞌe taj kaꞌaniꞌ chupa ri qꞌij re uxlanibꞌal» kechaꞌ. Jujun chik kakibꞌiꞌij: «We rire aj mak, ¿suꞌanik kꞌu riꞌ kuꞌan wa kꞌutubꞌal re ruchuqꞌabꞌ ri Dios?» kechaꞌ. Ruma kꞌu laꞌ, xkijach kipa ri fariseos chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ekꞌuchiriꞌ, xkitzꞌonoj che rachi kunutajinaq chik: —¿Saꞌ ri kabꞌiꞌij riꞌat chwi rachi xutzuꞌnisaj rawach? —xechaꞌ. Rire xukꞌul uwach: —Riꞌin kambꞌiꞌij e jun qꞌalajisanel —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Pero raj judiꞌabꞌ na xkaj taj kakikojo we rachi xex potzꞌ wi y woꞌora katzuꞌnik. Ruma waꞌ xekisikꞌij ruchu-uqaw, ");
INSERT INTO acrNNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","y xkitzꞌonoj kꞌu chike: —¿E alkꞌoꞌal alaq waꞌ, ri kabꞌiꞌij alaq ralaxibꞌem potzꞌ? ¿Chaꞌtaj katzuꞌn woꞌora? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ruchu-uqaw rachi xkikꞌul uwach: —Riꞌoj lik qetaꞌam e qalkꞌoꞌal waꞌ y xalaxik potzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Noꞌj na qetaꞌam taj chaꞌtaj katzuꞌn woꞌora, y na qetaꞌam ta nenareꞌ china xkunan re. Tzꞌonoj alaq che, ma rire nim chik —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ruchu-uqaw rachi xkibꞌiꞌij waꞌ ruma kakixiꞌij kibꞌ, ma wa aj wach ke raj judiꞌabꞌ kiꞌanom chi tzij chikiwach chaꞌ na kekꞌul ta chi pa ri sinagoga janipa ri kakijikibꞌaꞌ uwach ri Jesús e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","E uwariꞌche ruchu-uqaw rachi xkibꞌiꞌij: «Tzꞌonoj alaq che, ma rire nim chik.» ");
INSERT INTO acrNNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Ekꞌuchiriꞌ, raj judiꞌabꞌ xkitaq tanchi usikꞌixik rachi kunutajinaq chik y xkibꞌiꞌij che: —Woꞌora chajikibꞌaꞌ uwach chwach ri Dios ri kabꞌiꞌij. Ma riꞌoj qetaꞌam waꞌ waꞌchi lik aj mak —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ekꞌu rire xubꞌiꞌij: —We rire aj mak na wetaꞌam ta kꞌu riꞌ riꞌin, xew wetaꞌam e ri petinaq loq in potzꞌ yey woꞌora kintzuꞌnik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xkitzꞌonoj tanchi che: —¿Saꞌ ri xuꞌan chawe? ¿Suꞌanik xutzuꞌnisaj rawach? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Rachi xukꞌul uwach: —Riꞌin ya ximbꞌiꞌij che alaq y na xꞌaj ta kata alaq. ¿Suꞌchak kꞌu riꞌ kaꞌaj alaq kambꞌiꞌij tanchik? ¿Kaꞌaj kami ralaq kuꞌan alaq utijoꞌn? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ekꞌu rike xkiyajo, jewaꞌ xkibꞌiꞌij che: —Riꞌat e kataqej laꞌ la jun achi, noꞌj riꞌoj e kaqataqej rutzꞌibꞌam kan ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma riꞌoj qetaꞌam ri Dios xchꞌaꞌt rukꞌ ri Moisés; noꞌj laꞌ la jun achi, na qetaꞌam taj pa petinaq wi —xecha che. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ekꞌu rire xubꞌiꞌij chike: —¡E laꞌ la lik kakam wanimaꞌ riꞌin che! Ma ralaq na etaꞌam ta alaq pa petinaq wi waꞌchi, yey rire xutzuꞌnisaj ri nuwach riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Qetaꞌam kꞌu chi utz, ri Dios na kebꞌuta ta raj makibꞌ, xew kebꞌuta ri kakiloqꞌoj uqꞌij y kakiꞌan ri rajawal ukꞌuꞌx Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Chwi lo ri jeqebꞌal ruwachulew, na jinta tatajinaq wi we kꞌo junoq utzuꞌnisam juna tikawex potzꞌ chwi ralaxik. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","We tamaji wa jun achi petinaq rukꞌ ri Dios, riꞌ na jinta puqꞌabꞌ kuꞌan waꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Xkibꞌiꞌij kꞌu che: —Riꞌat lik pa mak xatalax wi. ¿Kawaj kami riꞌ katkꞌutun chiqawach? —xecha che. Chwi kꞌu riꞌ laꞌ, na xkikꞌul ta chi pa ri sinagoga. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Ekꞌu ri Jesús xretaꞌmaj na kakikꞌul ta chi pa ri sinagoga rachi kunutajinaq. Uwariꞌche echiriꞌ xukꞌulu, jewaꞌ xubꞌiꞌij che: —¿Kubꞌul akꞌuꞌx riꞌat rukꞌ Ralaxel Chikixoꞌl Tikawex? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Rachi xukꞌul uwach: —Wajawal, bꞌiꞌij la chwe china rire chaꞌ kakubꞌiꞌ nukꞌuꞌx rukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Ri Jesús xubꞌiꞌij che: —Awilom chi uwach; ma in riꞌ ri kinchꞌaꞌt awukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Ekꞌuchiriꞌ, rachi xuxukubꞌaꞌ ribꞌ chwach y xuloqꞌnimaj uqꞌij, jewaꞌ xubꞌiꞌij che: —Wajawal, riꞌin kakubꞌiꞌ nukꞌuꞌx ukꞌ la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ekꞌu ri Jesús xubꞌiꞌij: —Riꞌin in kꞌuninaq che ruwachulew chaꞌ wuma riꞌin kaqꞌalajinik china ri kakikꞌul ri Qꞌijsaq y china ri na kakikꞌul taj. In kꞌuninaq kꞌu riꞌ chaꞌ e ri na ketzuꞌn taj, kajaqataj ri kiwach y jelaꞌ kakil ri Qꞌijsaq; yey ekꞌu ri “ketzuꞌnik”, kachꞌuqutaj ri kiwach y na kakil ta ri Qꞌijsaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Jujun kꞌu chike ri fariseos, ri e kꞌo pan chunaqaj ri Jesús, echiriꞌ xkita waꞌ, xkitzꞌonoj che: —¿E kami keꞌelawi riꞌ oj potzꞌ riꞌoj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ri Jesús xukꞌul uwach: —We ta kaya ibꞌ alaq chupa na kil ta alaq ri Qꞌijsaq, na jinta mak alaq riꞌ. Noꞌj ruma ri kabꞌiꞌij alaq kil alaq chi utz ri Qꞌijsaq, e kakanaj kꞌu alaq riꞌ chupa ri mak alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Ri Jesús xubꞌiꞌij: «Paqatzij wi kambꞌiꞌij che alaq: China ri na kok tubꞌi che ruchiꞌ ri coral ke ri bꞌexex yey xa tobꞌ kꞌu pa kok wubꞌi, riꞌ eleqꞌom y e kereleqꞌaj bꞌi ri bꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Noꞌj kꞌu ri kok bꞌi che ruchiꞌ ri coral, riꞌ e chajinel ke ri bꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ekꞌu rire echiriꞌ kopon chwach ruchiꞌ ri coral, ri chajinel kꞌo che ruchiꞌ coral, kujaqalaꞌ lo che. Yey taq ri bꞌexex ketaꞌam ruchꞌawibꞌal ri chajinel ke, ma rire kebꞌusikꞌij rukꞌ ri kibꞌiꞌ chikijujunal y kebꞌeresaj bꞌi pa ri coral. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Echiriꞌ eresam chubꞌi konoje rubꞌexex pa ri coral, kanabꞌej bꞌi chikiwach y konoje rubꞌexex keterej bꞌi chirij ma ketaꞌam ruchꞌawibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Noꞌj taq ri bꞌexex na keterej tubꞌi chirij junoq we na ketaꞌam ta uwach; ri kakiꞌano e kebꞌanimaj chwach ma na ketaꞌam ta ruchꞌawibꞌal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Ri Jesús xubꞌiꞌij wa jun kꞌambꞌal naꞌoj chike, pero rike na xkimaj ta usukꞌ saꞌ ri karaj kubꞌiꞌij chike. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús: «Paqatzij wi kambꞌiꞌij che alaq: In ri in uchiꞌ ri coral pa kebꞌok wi ri bꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Konoje ri xekꞌun nabꞌe chinuwach riꞌin e eleqꞌomabꞌ y xa e kekeleqꞌaj bꞌi ri bꞌexex; pero ri bꞌexex na xekikajmaj ta rike. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","»In ri in uchiꞌ ri coral ke ri bꞌexex. China ri kok bꞌi wuma riꞌin, riꞌ kakolobꞌetajik y kachajix chi utz pachaꞌ ri bꞌexex kebꞌokisax chaqꞌabꞌ pa ri coral y kebꞌesax bꞌi paqꞌij re kebꞌeꞌwoꞌq pa chomilaj kꞌim. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Juna eleqꞌom xew kakꞌunik re kuꞌan eleqꞌ, kuꞌan kamik y kusach uwach ronoje. Noꞌj riꞌin in kꞌuninaq re kanya kꞌaslemal che alaq yey waꞌ e jun chomilaj kꞌaslemal na jinta chi ukꞌisik. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","»In ri in utzilaj chajinel ke bꞌexex. Juna utzilaj chajinel ke bꞌexex kuya ranimaꞌ kakam kuma rubꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Noꞌj juna mokom kachakun xa ruma katojik. Echiriꞌ karilo kakꞌun lo rutiw, kanimajik y kebꞌuya kan ri bꞌexex; ma na e ta chajinel ke y na e tane kajaw. E uwariꞌche kuya luwar che rutiw kebꞌuchap ri bꞌexex y kebꞌukicherisaj bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Wa mokom kanimajik ma na kok ta il chike ri bꞌexex, xew e kok il che ri kuchꞌako. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","»In ri in utzilaj chajinel ke bꞌexex, ma riꞌin wetaꞌam kiwach ri nubꞌexex y rike ketaꞌam nuwach riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Jelaꞌ pachaꞌ ri Nuqaw retaꞌam nuwach riꞌin, jekꞌulaꞌ riꞌin wetaꞌam uwach Rire; yey kanya wanimaꞌ kinkam kuma ri nubꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","»E kꞌo jujun chik nubꞌexex na e ta kukꞌil wa e kꞌo pa wa coral. Lik chirajawaxik wi kebꞌeꞌnukꞌamaꞌ loq. We xebꞌenusikꞌij, kakikoj nutzij y jelaꞌ kebꞌuꞌana xa jun pa ri coral y xa jun ri chajinel ke. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","»Ruma kꞌu laꞌ, ri Nuqaw kꞌax kinunaꞌo, ma riꞌin kanya ri nukꞌaslem pa kamik yey kankꞌam tanchi waꞌ echiriꞌ kinkꞌastaj lo chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Na yaꞌtal ta puqꞌabꞌ junoq karesaj ri nukꞌaslem we na in ta kinyaꞌw re che. Panuqꞌabꞌ riꞌin kꞌo wi kanya wibꞌ pa kamik y panuqꞌabꞌ kꞌo wi kinkꞌastaj lo chikixoꞌl ri ekaminaq. Yey waꞌ e ri Nuqaw yaꞌyom panuqꞌabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Echiriꞌ raj judiꞌabꞌ xkita wa chꞌaꞌtem, xkijach tanchi kipa chikiwach, ma e kꞌo ri xekojow re y e kꞌo ri na xekojow taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","E kꞌi chike jewaꞌ kakibꞌiꞌij: «Laꞌ kꞌo puqꞌabꞌ juna itzel uxlabꞌixel y chꞌuꞌjerinaq. ¿Suꞌchak kata alaq re?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Noꞌj kꞌo jujun chik jewaꞌ kakibꞌiꞌij: «Na jinta junoq jelaꞌ kachꞌaꞌtik we kꞌo puqꞌabꞌ juna itzel uxlabꞌixel. ¿Kꞌo nebꞌa juna itzel uxlabꞌixel kebꞌutzuꞌnisaj ri e potzꞌ?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chupa kꞌu ruqꞌijol echiriꞌ kꞌax tew y kꞌo jabꞌ, e riꞌ katajin ri nimaqꞌij re ri Rocho Dios chilaꞌ Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Y ri Jesús kabꞌin che ri Rocho Dios pa ri luwar kabꞌiꞌx che “Ruchiꞌ Ja re Salomón” ");
INSERT INTO acrNNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Ekꞌu raj judiꞌabꞌ xkisut rij ri Jesús y jewaꞌ xkibꞌiꞌij che: —¿Jampa xaqi e waꞌ na kaqꞌalajisaj ta la chiqawach saꞌ ri wach la? We lal kꞌu Ruchaꞌoꞌn lo ri Dios, asu bꞌiꞌij la chiqe —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ri Jesús xukꞌul uwach: —Nubꞌiꞌim chi che alaq, yey na kakoj ta alaq. Ronoje taq ri chak kanꞌano, e ri Nuqaw intaqayom che kanꞌano. Rukꞌ taq kꞌu wa kanꞌano, kaqꞌalajinik in china riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Noꞌj ralaq na kakoj ta alaq, ma na alaq ta kukꞌil ri nubꞌexex, jelaꞌ pachaꞌ ri nubꞌiꞌim chi lo che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Taq ri nubꞌexex ketaꞌam chi ri nuchꞌawibꞌal; yey riꞌin wetaꞌam kiwach y rike eteran chwij. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Riꞌin kanya kikꞌaslemal na jinta utaqexik chaꞌ jelaꞌ na kasach ta kꞌana kiwach y na jinta ne junoq kebꞌeresaj panuqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Yey e ri Nuqaw ri xeyaꞌw ke panuqꞌabꞌ, y Rire más kꞌo uwach chikiwa konoje. Ruma kꞌu riꞌ, na jinta junoq kebꞌeresaj puqꞌabꞌ Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma ri Nuqaw y riꞌin xa oj jun —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Julaj chik raj judiꞌabꞌ xkikꞌam abꞌaj pakiqꞌabꞌ re kakiꞌan ri Jesús paꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Pero Rire xubꞌiꞌij chike: —Lik kꞌi ri utzilaj chak nuꞌanom chiwach alaq rukꞌ ruchuqꞌabꞌ ri Nuqaw. ¿Ruma pachike che taq wa nuꞌanom kinꞌan alaq paꞌbꞌaj? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Raj judiꞌabꞌ xkikꞌul uwach: —Na kaqaꞌan ta la paꞌbꞌaj ruma ri utz ꞌanom la; e ruma makuninaq la chirij ri Dios rukꞌ ri chꞌaꞌtem la. Ma rilal xa lal jun achi y kaꞌan Dios che ibꞌ la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Ekꞌuchiriꞌ, ri Jesús xubꞌiꞌij chike: —Jewaꞌ tzꞌibꞌital kan chupa ri Tzij Pixabꞌ kꞌo ukꞌ alaq: “Ximbꞌiꞌij: Riꞌix ix dios.” ");
INSERT INTO acrNNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ri Dios xubꞌiꞌij kꞌu “dios” chike ri xkikꞌul Ruchꞌaꞌtem, yey Ruchꞌaꞌtem na kajalkꞌatitaj taj. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","¿Suꞌanik kꞌu riꞌ kabꞌiꞌij alaq chwe in makuninaq xa ruma ri ximbꞌiꞌij in Ukꞌajol ri Dios? ma ri Dios xinuchaꞌ lo riꞌin yey xinutaq lo che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","»We na e ta kanꞌan ruchak ri Nuqaw, utz kꞌu riꞌ we na kakoj ta alaq ri kambꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Noꞌj we e kanꞌan ruchak ri Nuqaw, kojo kꞌu alaq riꞌ in china riꞌin ruma taq ri kanꞌano, na xa ta ruma ri kambꞌiꞌij. Y jelaꞌ ketaꞌmaj alaq y kakoj alaq riꞌ: Ri Nuqaw wukꞌ riꞌin y riꞌin rukꞌ Rire, xa oj jun —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Ekꞌu raj judiꞌabꞌ xkaj tanchik kakichapo, pero na xkichap taj ma ri Jesús xel bꞌi chikixoꞌl. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Y xuqꞌaxuj kꞌu ri nimayaꞌ Jordán pa xuya wi bautismo ri Juan y xkanaj kan chilaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ukꞌiyal winaq xebꞌopon rukꞌ; xeꞌkilaꞌ y jewaꞌ kakibꞌiꞌij: «Ri Juan na xuꞌan ta juna kꞌutubꞌal re ruchuqꞌabꞌ ri Dios chiqawach; na rukꞌ ta kꞌu riꞌ, ronoje ri xubꞌiꞌij kan chwi waꞌ waꞌchi, lik qatzij» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Y lik e kꞌi ri xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús chilaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Kꞌo kꞌu jun achi yewaꞌ, Lázaro rubꞌiꞌ. Rire aj Betania, y chilaꞌ ejeqel wi ri ranabꞌ María y Marta. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Waꞌ wa María e ri xuqꞌej kunabꞌal lik kiꞌ ruxlabꞌ che ri raqan ri Jesús y xuchaqisaj rukꞌ ruwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ekꞌu ri kebꞌ ixoqibꞌ kichaqꞌ kibꞌ jewaꞌ xkitaq ubꞌiꞌxikil che ri Jesús: «Qajawal, ri jun lik kꞌax kanaꞌ la, lik yewaꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Echiriꞌ ri Jesús xuta waꞌ, jewaꞌ xubꞌiꞌij: «Waꞌ wa yabꞌil na re ta kamik, ma re yakbꞌal uqꞌij ri Dios y re yakbꞌal uqꞌij Rukꞌajol ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Ekꞌu ri Jesús lik kꞌax kebꞌunaꞌ ri oxibꞌ kichaqꞌ kibꞌ: Ri Marta, ri María y ri Lázaro. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Na rukꞌ ta kꞌu riꞌ, echiriꞌ xuto yewaꞌ ri Lázaro, kꞌa xkanaj chi kan kebꞌ qꞌij pa ri luwar pa kꞌo wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Tekꞌuchiriꞌ, xubꞌiꞌij chike rutijoꞌn: —Joꞌ tanchi Judea —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ekꞌu rutijoꞌn xkibꞌiꞌij che: —Lal tijonel, ¿na kꞌakꞌ ta nebꞌa laꞌ raj judiꞌabꞌ ya laj xkikamisaj la paꞌbꞌaj? Na rukꞌ ta kꞌu riꞌ, ¿woꞌora keꞌek tanchi la chilaꞌ? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Ri Jesús xubꞌiꞌij chike: —¿Na qatzij ta nebꞌa laꞌ kabꞌlajuj ora kꞌo che ri jun qꞌij? Yey e junoq kabꞌin paqꞌij na kuchiq ta ri raqan, ma karil rubꞌe ruma ri qꞌijsaq re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Noꞌj we junoq kabꞌin chaqꞌabꞌ, riꞌ kuchiq ri raqan ma pa qꞌequꞌm kꞌo wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Tekꞌuchiriꞌ, xubꞌiꞌij chike: —E ri qamigo Lázaro, kawarik. Kinꞌek kꞌu che ukꞌosoxik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Xkibꞌiꞌij kꞌu rutijoꞌn che: —Qajawal, utz we kawarik, ma riꞌ e kꞌutubꞌal re kutzir uwach —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ri xkichꞌobꞌ rike e xa kuxlan ri Lázaro; noꞌj ri Jesús e kachꞌaꞌt puwi rukamik ri Lázaro. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","E uwariꞌche ri Jesús xuqꞌalajisaj chike: —Ri Lázaro kaminaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Yey iwuma kꞌu riꞌix, lik kinkiꞌkotik ri na in jinta chilaꞌ rukꞌ echiriꞌ xkamik, ma jelaꞌ kanimar ri kubꞌulibꞌal ikꞌuꞌx wukꞌ. Woꞌora joꞌ, jeꞌqilaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Ekꞌuchiriꞌ, ri Tomás ri kabꞌiꞌx “Yoꞌx” che, xubꞌiꞌij chike ri jujun chik rachbꞌiꞌil: —Kojꞌek riꞌ chaꞌ jelaꞌ kojkam junam rukꞌ ri Jesús —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Kajibꞌ qꞌij chi lo riꞌ muqutal ri Lázaro echiriꞌ ri Jesús xopon Betania. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Waꞌ xa chunaqaj Jerusalem kꞌo wi, laj oxibꞌ kilómetro kꞌo wi lo che. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","E kꞌi chike raj judiꞌabꞌ e petinaq kukꞌ ri María y ri Marta re koꞌlkibꞌochiꞌij kikꞌuꞌx ruma rukamik ri kixibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ekꞌuchiriꞌ ri Marta xuto katajin roponik ri Jesús, xel bꞌi che ukꞌulik; noꞌj ri María xkanaj kan chwa ja. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ekꞌu ri Marta xubꞌiꞌij che ri Jesús: —Wajawal, we ta e laꞌ kꞌo la wara, na kakam ta riꞌ ri nuxibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Na rukꞌ ta kꞌu riꞌ, lik wetaꞌam, tobꞌ ne kꞌa e waꞌ, ri Dios kuya cheꞌla ronoje ri katzꞌonoj la che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ri Jesús xubꞌiꞌij che: —Raxibꞌal kakꞌastaj lo chikixoꞌl ri ekaminaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ri Marta xubꞌiꞌij che: —Qatzij, riꞌin wetaꞌam kakꞌastaj lo che ri kꞌisbꞌal qꞌij re ruwachulew echiriꞌ kekꞌastaj lo konoje ri ekaminaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ri Jesús xubꞌiꞌij che: —E riꞌin ri kinkꞌastajisan lo ke ri ekaminaq yey e riꞌin ri kinyaꞌw kꞌaslemal. China kꞌu ri kakubꞌiꞌ ukꞌuꞌx wukꞌ, tobꞌ kakamik, kakꞌastajik. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Yey konoje ri e kꞌaslik y kakubꞌiꞌ kikꞌuꞌx wukꞌ, na kekam taj ma kꞌo kikꞌaslemal na jinta utaqexik rukꞌ ri Dios. ¿Kakoj riꞌat waꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Ri Marta xukꞌul uwach: —Kankojo, Wajawal, ma riꞌin nukojom rilal lal ri Cristo, Rukꞌajol ri Dios, ri bꞌiꞌtisim loq kakꞌun che ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Echiriꞌ ri Marta xukꞌis ubꞌiꞌxik waꞌ, xeꞌek che usikꞌixik ruchaqꞌ María y xew che rire xubꞌiꞌij: —Ri Qajawal kꞌo wara y katusikꞌij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Xew xuta waꞌ ri María, na jampatana xyaktaj bꞌi y xeꞌrila ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ri Jesús kꞌamajaꞌ ne kok pa ri tinamit, ma kꞌa kꞌo pa ri luwar pa xkꞌul wi ruma ri Marta. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ekꞌu raj judiꞌabꞌ e kꞌo rukꞌ ri María re kakibꞌochiꞌij ukꞌuꞌx, xkilo echiriꞌ na jampatana xyaktajik y kanik xel bꞌi. Rike xeterej kꞌu bꞌi chirij, ma e chikiwach rike e riꞌ keꞌek chwa ri muqubꞌal chaꞌ keꞌroqꞌej ruxibꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Echiriꞌ ri María xopon pa kꞌo wi ri Jesús, xew xril uwach, xuxuk ribꞌ chwach, y jewaꞌ xubꞌiꞌij che: —Wajawal, we ta e laꞌ lal kꞌo la wara, na kakam ta riꞌ ri nuxibꞌal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ri Jesús echiriꞌ xrilo lik kebꞌoqꞌ ri María y raj judiꞌabꞌ eteran lo chirij, lik xok chukꞌuꞌx y xuchap bꞌis. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xubꞌiꞌij kꞌu chike: —¿Pa ximuq wi? —xchaꞌ. Rike xkibꞌiꞌij: —Qajawal, peta la y chilape la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Ekꞌu ri Jesús xoqꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Xkibꞌiꞌij kꞌu raj judiꞌabꞌ: —¡Chilape alaq, lik kꞌax kunaꞌo! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","E kꞌo jujun chike raj judiꞌabꞌ xkibꞌiꞌij: —Wa waꞌchi e xtzuꞌnisan re ri jun potzꞌ. ¿Suꞌbꞌe kꞌu riꞌ na jinta xuꞌano chaꞌ na kakam ta ri Lázaro? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Ri Jesús lik xok tanchi bꞌis chukꞌuꞌx, xqibꞌ chwa ri muqubꞌal. Waꞌ jun jul worotal paꞌbꞌaj y tzꞌapal uchiꞌ rukꞌ jun abꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Ekꞌu ri Jesús xubꞌiꞌij: —Chiwesaj laꞌbꞌaj —xchaꞌ. Yey ri Marta, ri ranabꞌ kan ri kaminaq, xubꞌiꞌij che: —Wajawal, laꞌ lik chu chik, ma e ukaj qꞌij waꞌ muqutalik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ri Jesús xubꞌiꞌij che: —¿Na nubꞌiꞌim ta nebꞌa chawe, we kakubꞌiꞌ akꞌuꞌx wukꞌ, kawil runimal uwach uqꞌij ri Dios? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Ewi xkesaj rabꞌaj kꞌo chuchiꞌ ri muqubꞌal. Ekꞌuchiriꞌ, ri Jesús xtzuꞌn chikaj y xubꞌiꞌij: —Lal Nuqaw, maltiox ko cheꞌla ma intom chi la. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Riꞌin wetaꞌam lik xaqi kinta la, pero kambꞌiꞌij kꞌu waꞌ kuma wuꞌkꞌiyal tikawex e kꞌo wara, chaꞌ rike kakikojo lal taqayom lo we —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Echiriꞌ xukꞌis ubꞌiꞌxikil waꞌ, lik ko xsikꞌin che ubꞌiꞌxikil: —¡Lázaro, chateluloq! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Ewi ri Lázaro xel loq, bꞌolqꞌotim ri raqan y ruqꞌabꞌ pa kꞌul yey rupalaj chꞌuqutal rukꞌ jun kꞌul. Ruma kꞌu laꞌ, ri Jesús xubꞌiꞌij chike: —Chikira ri kꞌul kꞌo che chaꞌ utz keꞌek —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","E kꞌi kꞌu chike raj judiꞌabꞌ, ri e petinaq che ubꞌochiꞌixik ukꞌuꞌx ri María, echiriꞌ xkil ri xuꞌan ri Jesús, xkikubꞌaꞌ kikꞌuꞌx rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Noꞌj e kꞌo jujun chike xebꞌek kukꞌ ri fariseos, y xeꞌkitzijoj chike ri xuꞌan ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Ekꞌu ri nimaq e aj chakunel pa Rocho Dios y ri fariseos xkimol kibꞌ kukꞌ jujun chik chike ri e aj qꞌatal tzij y jewaꞌ xkibꞌiꞌij: —¿Saꞌ ri kaqaꞌano? Ma waꞌchi lik ukꞌiyal kꞌutubꞌal re ruchuqꞌabꞌ kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We na kaqaqꞌatej taj, konoje kakubꞌiꞌ kikꞌuꞌx rukꞌ y kekꞌun kꞌu lo riꞌ raj wach re Roma chaꞌ koꞌlkiwulij wa Luwar pa kaqaloqꞌnimaj wi ri Dios y wa qatinamit —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Ekꞌuchiriꞌ ri Caifás, ri kajawal raj chakunel pa Rocho Dios che laꞌ la junabꞌ, jewaꞌ xubꞌiꞌij chike: —Ralaq na jinta etaꞌam alaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Na kachꞌobꞌ ta alaq raqan chi utz, ma e más utz we xa jun chi achi kakam pukꞌaxel ri tinamit chwa ri kasach kiwach konoje ri qatinamit —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Ri Caifás na xa ta pa re rire xubꞌiꞌij waꞌ. Ma ruma e kajawal raj chakunel pa Rocho Dios che laꞌ la junabꞌ, ri Dios xuya che kuqꞌalajisaj e kakam ri Jesús pakikꞌaxel konoje ri tinamit e aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y na xew ta kuma ri tinamit Israel xkam ri Jesús, ma xkamik chaꞌ kuꞌan xa jun chike konoje ri e ralkꞌoꞌal ri Dios ekicherinaq bꞌi che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Ekꞌu raj judiꞌabꞌ chwi laꞌ la qꞌij wi xkiꞌan tzij chikiwach chaꞌ kakikamisaj ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Ruma kꞌu waꞌ, ri Jesús na xbꞌin ta chi chikixoꞌl chiwachil. Ewi xel bꞌi pa ri luwar re Judea y xeꞌek chunaqaj ri luwar katzꞌintzꞌotik, pa jun tinamit Efraín rubꞌiꞌ. Chiriꞌ xkanaj kan wi junam kukꞌ rutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Xa naqaj chi kꞌo wi lo ri Pascua, waꞌ e kinimaqꞌij raj judiꞌabꞌ. Ukꞌiyal winaq re taq ri tinamit xepaqiꞌ Jerusalem re kakiꞌan ri kijosqꞌikil chwach ri Dios, chaꞌ jelaꞌ taqal chike kakiꞌan ri nimaqꞌij Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","E taq kꞌu ri winaq ketajin che utzukuxik ri Jesús, yey echiriꞌ e kꞌo pa ri Rocho Dios, kakitzꞌonobꞌej chikiwach: «¿Saꞌ nawi kichꞌobꞌ riꞌix? ¿Kakꞌun nawi pa wa nimaqꞌij?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Yey ri fariseos kukꞌ ri nimaq e aj chakunel pa Rocho Dios etaqaninaq che we kꞌo junoq karetaꞌmaj pa kꞌo wi ri Jesús, chubꞌiꞌij chaꞌ keꞌkichapa uloq. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Waqibꞌ qꞌij chi kꞌu riꞌ che ri nimaqꞌij Pascua, ri Jesús xeꞌek Betania pa jeqel wi ri Lázaro, ri jun xukꞌastajisaj lo che ri kamik. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Chiriꞌ xkiꞌan wi jun waꞌim re yakbꞌal uqꞌij ri Jesús. Ekꞌu ri Marta e kaniman ri waꞌim y ri Lázaro e jun chike ri etzꞌul chwa ri mexa rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ekꞌu ri María xukꞌam lo jun libra re saqil nardo, waꞌ e jun kunabꞌal lik kiꞌ ruxlabꞌ y lik kꞌi rajil. Xuqꞌej kꞌu riꞌ che ri raqan ri Jesús; tekꞌuchiriꞌ, xuchaqisaj rukꞌ ruwiꞌ. Ronoje kꞌu rupa ja lik xmuyuy che ri ruxlabꞌ wa kunabꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Kꞌo kꞌu chiriꞌ ri Judas aj Iscariot, jun chike rutijoꞌn ri Jesús. (E ri kakꞌayin re ri Jesús). Rire xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","—¿Suꞌbꞌe na xkꞌayix ta waꞌ wa kunabꞌal chi oxibꞌ ciento denarios chaꞌ rukꞌ ri rajil ketoꞌ ri nibꞌaꞌibꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ri Judas xubꞌiꞌij waꞌ na e ta ruma karaj kebꞌutoꞌ ri nibꞌaꞌibꞌ, ma e ruma rire eleqꞌom. Yey puqꞌabꞌ kꞌo wi ri bꞌolxa pa kꞌolotal wi ri puaq ke rutaqoꞌn ri Jesús y kꞌo ne karesaj che. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ekꞌu ri Jesús xubꞌiꞌij che ri Judas: —Matchꞌaꞌt chirij wiꞌxoq, ma wa kunabꞌal xex chi ukꞌolom re pan ruqꞌijol ri muqubꞌal we. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma taq ri nibꞌaꞌibꞌ ronoje qꞌij e kꞌo iwukꞌ, noꞌj riꞌin na xaqi ta in kꞌo iwukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","E kꞌi chike raj judiꞌabꞌ xketaꞌmaj kꞌo ri Jesús chilaꞌ Betania. Xebꞌek kꞌu che rilik, na xew ta ruma kakaj keꞌkila ri Jesús, ma kakaj keꞌkila ri Lázaro, ri jun xukꞌastajisaj lo chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Ruma kꞌu riꞌ, ri nimaq e aj chakunel pa Rocho Dios xkiꞌan tzij chikiwach chaꞌ kakikamisaj ri Lázaro; ");
INSERT INTO acrNNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ma ruma rire, e kꞌi chike raj judiꞌabꞌ xkesaj bꞌi kibꞌ kukꞌ y e xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","E kꞌi ri winaq ebꞌoponinaq Jerusalem ruma ri nimaqꞌij Pascua. Chukaꞌm qꞌij kꞌu riꞌ xketaꞌmaj kopon ri Jesús pa ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Xkiqꞌat kꞌu uxaq palma y xebꞌel bꞌi che ukꞌulik. Ekꞌuchiriꞌ, xkijeqo lik kesikꞌinik, jewaꞌ kakibꞌiꞌij: «¡Qayaka uqꞌij! ¡Nim uqꞌij ri jun petinaq chupa rubꞌiꞌ ri Dios Qajawxel! ¡Rire e ri Rey re Israel!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ri Jesús uriqom lo jun qꞌapoj buru y ukojom loq, pachaꞌ tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios: ");
INSERT INTO acrNNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mixiꞌij iwibꞌ ri ix aj Sion. Chiwilapeꞌ, ri Rey iweꞌix kakꞌunik, ukojom lo jun qꞌapoj buru kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Echiriꞌ xuꞌan taq waꞌ, rutijoꞌn na xkimaj ta usukꞌ; kꞌa e xkimaj usukꞌ echiriꞌ lik xyak uqꞌij ri Jesús chikiwach ruma rukꞌastajibꞌal. Kꞌa ekꞌuchiriꞌ xkꞌun chikikꞌuꞌx, e janipa ri xꞌaniꞌ che, ronoje waꞌ tzꞌibꞌital kan pa Ruchꞌaꞌtem ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","E taq ri e kꞌo rukꞌ ri Jesús echiriꞌ Rire xusikꞌij pan ri Lázaro chupa ri muqubꞌal y xukꞌastajisaj lo chikixoꞌl ri ekaminaq, ketajin che utzijoxik ri xkilo. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ruma waꞌ, ukꞌiyal winaq xebꞌel lo che ukꞌulik ri Jesús, ma xkita ri katzijox puwi wa kꞌutubꞌal re ruchuqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ekꞌuchiriꞌ, ri fariseos xkibꞌiꞌij chikiwach: «Kiwil kꞌu laꞌ, lik na jinta kutiqoj saꞌ ri qaꞌanom chirij ri Jesús, ma ¡chiwilapeꞌ! konoje ri winaq eteran chirij» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","E kꞌo jujun na e ta aj Israel chikixoꞌl ri winaq ebꞌoponinaq Jerusalem re keꞌkiloqꞌnimaj uqꞌij ri Dios pa ri nimaqꞌij Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Waꞌ xeqibꞌ rukꞌ ri Felipe, ri aj Betsaida, jun luwar re Galilea. Lik kꞌut xebꞌelaj che, jewaꞌ xkibꞌiꞌij: —Maꞌan ko la riꞌ, chojtoꞌo la, ma riꞌoj kaqaj kaqil uwach ri Jesús —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Ri Felipe xeꞌek y xutzijoj waꞌ che ri Andrés. Tekꞌuchiriꞌ xebꞌek junam, xeꞌkitzijoj che ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ekꞌu ri Jesús xubꞌiꞌij chike: —Xopon kꞌu ruqꞌijol ri yakbꞌal uqꞌij Ralaxel Chikixoꞌl Tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Paqatzij wi kambꞌiꞌij chiwe: E juna ijaꞌ re trigo echiriꞌ katzaq pulew, kamuqik y kakamik. Yey we na jelaꞌ ta kuꞌano, kakanaj kan utukel xew ijaꞌ. Noꞌj we rijaꞌ katzaq pulew, riꞌ lik kawachinik y jekꞌuriꞌlaꞌ kakꞌiyar uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Jekꞌuriꞌlaꞌ, china ri lik kok il che rukꞌaslem che ruwachulew, riꞌ e kujam ri kꞌaslemal chilaꞌ chikaj; noꞌj china ri na kok ta il che rukꞌaslem wara che ruwachulew, riꞌ na kujam ta kꞌu ri chomilaj ukꞌaslemal na jinta utaqexik chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","»China ri karaj kachakun pa ri nuchak, chirajawaxik riꞌ katerej lo chwij. Jekꞌulaꞌ tobꞌ pa kinkꞌojiꞌ wi riꞌin, chiriꞌ kakꞌojiꞌ wi ri waj chak. China kꞌu ri kaꞌanaw ri nuchak, riꞌ kayak uqꞌij ruma ri Nuqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","»Woꞌora lik paxinaq nukꞌuꞌx. ¿Saꞌ nawi ri kambꞌiꞌij? ¿Utz nawi jewaꞌ kambꞌiꞌij: “Nuqaw, chinkolobꞌej la che wa kankꞌulumaj woꞌora”? ¡Na utz taj! Ma ruma ne waꞌ in petinaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Xew kambꞌiꞌij: “Nuqaw, nimarisaj uqꞌij ri bꞌiꞌ la” —xchaꞌ. Ekꞌuchiriꞌ, xchꞌaw lo Jun chilaꞌ chikaj, jewaꞌ xubꞌiꞌij: —Nunimarisam chik, y e waꞌ kannimarisaj tanchik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ri winaq e kꞌo chiriꞌ xkita waꞌ y xkibꞌiꞌij: «Laꞌ uchꞌawibꞌal jabꞌ.» Yey jujun chik xkibꞌiꞌij: «Jun ángel xchꞌaw lo che» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ekꞌu ri Jesús xubꞌiꞌij chike: —Na wuma ta riꞌin xtataj wa jun qulaj, ma e uma ralaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Yey woꞌora kaqꞌat tzij pakiwi ri winaq re ruwachulew y kesax na kꞌu bꞌi ritzel winaq, ri jun kataqan che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Echiriꞌ kinyakiꞌ na lo chikaj, kanꞌan chike ri tikawex che ronoje ruwachulew chaꞌ lik kacha kikꞌuꞌx che kepe wukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Rukꞌ waꞌ e xuqꞌalajisaj saꞌ rukamik. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ri winaq xkikꞌul uwach: —Ruma Rutzij Upixabꞌ ri Dios riꞌoj qetaꞌam: Ruchaꞌoꞌn lo ri Dios na jinta utaqexik rukꞌaslemal. ¿Chaꞌta kꞌu riꞌ kabꞌiꞌij la Ralaxel Chikixoꞌl Tikawex kayakiꞌ che ruwachulew? ¿China kꞌu riꞌ “Ralaxel Chikixoꞌl Tikawex” kabꞌiꞌij la? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Xubꞌiꞌij kꞌu ri Jesús chike: —Na naj ta chi kꞌo ri Qꞌijsaq chixoꞌl alaq. Bꞌina kꞌu alaq pa ri Qꞌijsaq xaloqꞌ kꞌa kꞌo ukꞌ alaq, chaꞌ ri qꞌequꞌm na kumaj ta alaq xaqikꞌateꞌt. Ma china ri kabꞌin pa qꞌequꞌm, na retaꞌam taj pa keꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Kojo alaq ri Qꞌijsaq xaloqꞌ kꞌa kꞌo ukꞌ alaq, chaꞌ jelaꞌ kuꞌan alaq re ri Qꞌijsaq —xchaꞌ. Echiriꞌ xukꞌis ubꞌiꞌxik waꞌ ri Jesús, xel bꞌi chikixoꞌl y xeꞌek pa jun luwar pa na kariqitaj ta wi kuma rike. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E kꞌo ri na xkubꞌiꞌ ta kikꞌuꞌx rukꞌ ri Jesús, tobꞌ Rire xuꞌan ukꞌiyal kꞌutubꞌal re ruchuqꞌabꞌ ri Dios chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Jekꞌulaꞌ e xuꞌana pachaꞌ rutzꞌibꞌam kan ri qꞌalajisanel Isaías echiriꞌ xubꞌiꞌij: Qajawal, ¿china ekojoyom re ri qatzijom chik? yey ¿China taq chikiwach kꞌutum wi ri chuqꞌabꞌ la, Lal Dios Qajawxel? xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","E uwariꞌche na xkubꞌiꞌ ta kikꞌuꞌx rukꞌ ri Jesús ma e xuꞌana pachaꞌ rutzꞌibꞌam kan ri Isaías puwi ri xuqꞌalajisaj ri Dios che, echiriꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","Wa tinamit uꞌanom pachaꞌ potzꞌ ri kiwach y uꞌanom ko ri kanimaꞌ; jekꞌulaꞌ na jinta kꞌo kakilo, na jinta kꞌo kakimaj usukꞌ y na kakitzelej tane kitzij chinuwach chaꞌ jelaꞌ kebꞌenukunaj ");
INSERT INTO acrNNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ri qꞌalajisanel Isaías xutzꞌibꞌaj waꞌ ma xril pan runimal uchomal ri Jesús y lik kꞌo xuqꞌalajisaj chwi Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Na rukꞌ ta kꞌu riꞌ, e kꞌi xekojow re ri Jesús, jujun ne chike e aj wach re ri tinamit. Pero na xkiqꞌalajisaj ta waꞌ chikiwach ri kachbꞌiꞌil ruma kakixiꞌij kibꞌ chikiwach ri fariseos. Ma we xetaꞌmaxik, na kekꞌul ta chi pa ri sinagoga. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","E xkiꞌan waꞌ ma e más kukꞌul kikꞌuꞌx ri yakbꞌal kiqꞌij kakiꞌan ri winaq, chwa ri yakbꞌal kiqꞌij kuꞌan ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ri Jesús ko xsikꞌin che ubꞌiꞌxikil: «China ri kakubꞌiꞌ ukꞌuꞌx wukꞌ, na xew ta kakubꞌiꞌ ukꞌuꞌx wukꞌ riꞌin, ma e kakubꞌiꞌ ukꞌuꞌx rukꞌ ri Jun taqayom lo we. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","China ri kilow we riꞌin, e junam rukꞌ karil ri Jun taqayom lo we. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","»In ri in Qꞌijsaq in kꞌuninaq che ruwachulew chaꞌ china ri kakubꞌiꞌ ukꞌuꞌx wukꞌ riꞌin, na kakꞌojiꞌ ta pa qꞌequꞌm. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Noꞌj we kꞌo junoq xuta ri nuchꞌaꞌtem yey na kuꞌan ta ri kambꞌiꞌij, na in ta ri kinqꞌataw tzij puwiꞌ. Ma in kꞌuninaq che ruwachulew na re ta kanqꞌat tzij pakiwi ri tikawex; e in kꞌuninaq re kebꞌenukolobꞌej konoje ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","»Yey china ri kukꞌaq bꞌi nuqꞌij y na kukoj ta ri nuchꞌaꞌtem, kꞌo ri kaqꞌataw tzij puwiꞌ. Waꞌ e ri chꞌaꞌtem nubꞌiꞌim, ri kaqꞌataw tzij puwiꞌ che rukꞌisbꞌal qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ma na xa ta pa we riꞌin kinchꞌaꞌtik; ri Nuqaw ri taqayom lo we, e intaqayom lo che ronoje saꞌ ri kambꞌiꞌij y ri kankꞌutu. ");
INSERT INTO acrNNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Riꞌin wetaꞌam e rutaqanik ri Nuqaw kukꞌam lo kꞌaslemal na jinta utaqexik. Jekꞌulaꞌ, ronoje ri kambꞌiꞌij riꞌin, e inutaqom lo riꞌ ri Nuqaw che ubꞌiꞌxikil» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Xa naqaj chi kꞌo wi lo ruqꞌijol ri nimaqꞌij Pascua yey ri Jesús retaꞌam ya kopon ruqꞌijol echiriꞌ kuya kan ruwachulew y keꞌek rukꞌ Ruqaw chilaꞌ chikaj. Ekꞌu Rire lik kꞌax ebꞌunaꞌom rutijoꞌn e kꞌo rukꞌ wara che ruwachulew; yey janipa qꞌij xkꞌojiꞌ kukꞌ, e laꞌ lik kꞌax xebꞌunaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Xopon kꞌu rubꞌenebꞌal qꞌij echiriꞌ ri Jesús kukꞌ rutijoꞌn e riꞌ kewaꞌik. Jun kꞌu chike e ri Judas aj Iscariot rukꞌajol ri Simón. Yey kojom chi pa ranimaꞌ ruma ritzel winaq kukꞌayij ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Ekꞌu ri Jesús retaꞌam yaꞌtal ronoje puqꞌabꞌ ruma Ruqaw, yey Rire petinaq rukꞌ ri Dios y rukꞌ ri Dios katzelej wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Na rukꞌ ta kꞌu riꞌ, ri Jesús xyaktajik, xresaj ruqꞌuꞌ uripom chirij, xukꞌam jun twayo puqꞌabꞌ y xuxim chupa. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Tekꞌuchiriꞌ xuqꞌej yaꞌ pa jun kꞌolibꞌal, xujeq uchꞌajik ri kaqan rutijoꞌn y kuchaqisaj rukꞌ ri twayo uximom chupa. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Echiriꞌ kujeq uchꞌajik ri raqan ri Pedro, rire jewaꞌ xubꞌiꞌij che ri Jesús: —Wajawal, ¿kachꞌaj kami la riꞌ ri waqan? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ri Jesús xukꞌul uwach: —Woꞌora na kamaj ta usukꞌ saꞌ wa kintajin che uꞌanik; kꞌate na kꞌu riꞌ kamaj usukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ekꞌu ri Pedro xubꞌiꞌij che: —Riꞌin na kanya ta kꞌana luwar cheꞌla kachꞌaj la ri waqan —xchaꞌ. Ri Jesús xubꞌiꞌij che: —We na kanchꞌaj ta laꞌ waqan, riꞌ na jinta chi awe wukꞌ riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Xubꞌiꞌij kꞌu ri Pedro che: —We e riꞌ, Wajawal, na xew tane ri waqan kachꞌaj la; chꞌaja ne la riꞌ ri nuqꞌabꞌ y ri nujolom —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ri Jesús jewaꞌ xubꞌiꞌij che: —E junoq kꞌakꞌ atininaq, xew kajawaxik kachꞌajiꞌ ri raqan, ma ronoje rucuerpo chꞌajtal chik. Jekꞌulaꞌ riꞌix chwach ri Dios ix chi chꞌajtalik, tobꞌ na iwonoje taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ri Jesús retaꞌam chik china ri kakꞌayin re; e uwariꞌche xubꞌiꞌij: “Na iwonoje taj ix chꞌajtalik.” ");
INSERT INTO acrNNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Echiriꞌ xukꞌis uchꞌajik ri kaqan rutijoꞌn, xurip tanchi ruqꞌuꞌ chirij, xtzꞌuyiꞌ tanchi chwa ri mexa y xutzꞌonoj chike: —¿Kimaj usukꞌ saꞌ keꞌelawi wa xinꞌan chiwe? ");
INSERT INTO acrNNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Riꞌix kibꞌiꞌij chwe: “Tijonel” y “Qajawal” y qatzij ri kibꞌiꞌij, ma lik e uꞌanom riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We in kꞌu Itijonel riꞌ yey in Iwajawal y xinchꞌaj kꞌu liꞌwaqan, jekꞌulaꞌ riꞌ chiꞌana riꞌix; chichꞌaja kꞌu liꞌwaqan chiwach riꞌix chiwibꞌil iwibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Riꞌin xinꞌan waꞌ re kꞌutubꞌal chiwach, chaꞌ riꞌix jelaꞌ kiꞌano pachaꞌ ri xinꞌan riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Paqatzij wi kambꞌiꞌij chiwe: Na jinta juna aj chak más kꞌo uwach chwa ri rajaw, yey na jinta ne juna taqoꞌn más kꞌo uwach chwa ri taqayom lo re. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","We kimaj usukꞌ taq waꞌ y kitijoj iwibꞌ che uꞌanik, nim iqꞌij iwalaxik riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","»Pero na kinchꞌaꞌt ta piwiꞌ iwonoje, ma riꞌin wetaꞌam china ri ebꞌenuchaꞌom. Yey e kuꞌana na ri tzꞌibꞌital kan pa Ruchꞌaꞌtem ri Dios, pa kubꞌiꞌij wi: E ri jun kawaꞌ junam wukꞌ, e riꞌ ri yaktajinaq chwij. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Kintajin kꞌu pan che ubꞌiꞌxikil chiwe woꞌora chaꞌ echiriꞌ kuꞌana waꞌ, riꞌix kikojo: “In Riꞌin.” ");
INSERT INTO acrNNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Paqatzij wi kambꞌiꞌij chiwe: China ri kakꞌuluw re ri kantaq bꞌi riꞌin, e junam rukꞌ in ri kinukꞌulu; yey china kꞌu ri kakꞌuluw we riꞌin, e kukꞌul ri Jun taqayom lo we —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Echiriꞌ xukꞌis ubꞌiꞌxikil waꞌ, ri Jesús xok bꞌis chukꞌuꞌx y jewaꞌ xubꞌiꞌij: —Paqatzij wi kambꞌiꞌij chiwe: Jun chiwe riꞌix kinukꞌayij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Ekꞌuchiriꞌ, rutijoꞌn xkijeq kakitzulaꞌ kiwach chikibꞌil kibꞌ ma na ketaꞌam taj china ri xubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Kꞌo kꞌu jun chike rutijoꞌn, waꞌ e ri lik kꞌax kanaꞌ ruma ri Jesús, kawaꞌik jaꞌl putzal Rire chwa ri mexa. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Ekꞌu ri Simón Pedro xuꞌan pan uqꞌabꞌ che chaꞌ kutzꞌonoj che ri Jesús china ri kubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Y ri jun tijoꞌn jaꞌl putzal ri Jesús xutzꞌonoj kꞌu che: —Wajawal, ¿china laꞌ la kabꞌiꞌij la? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ri Jesús xukꞌul uwach: —Kanmuꞌ juchꞌaqap pam y china kꞌu che kanya wi, e rire —xchaꞌ. Xumuꞌ kꞌu juchꞌaqap pam y xuya che ri Judas aj Iscariot, rukꞌajol ri Simón. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Echiriꞌ ri Judas xukꞌam ri pam, xok ri Satanás pa ranimaꞌ. Ekꞌu ri Jesús xubꞌiꞌij che: —Ri kawaj kaꞌano, chaꞌana laꞌ riꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Yey na jinta junoq chike ri kewaꞌ chwa ri mexa xumaj usukꞌ suꞌbꞌe xubꞌiꞌij laꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Ruma kꞌu puqꞌabꞌ ri Judas kꞌo wi ri bꞌolxa pa kꞌolotal wi ri kipuaq, jujun chike xkichꞌobꞌo laj ri Jesús xubꞌiꞌij che kuꞌloqꞌo tan ri kajawax chike re ri nimaqꞌij, o laj kꞌo kujach chike ri nibꞌaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ekꞌuchiriꞌ ri Judas ukꞌamom chi ri pam, na jampatana xel bꞌi yey lik chaqꞌabꞌ chik. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Echiriꞌ elinaq chubꞌi ri Judas, ri Jesús xubꞌiꞌij: —Ekꞌu woꞌora kaqꞌalajin runimal uchomalil Ralaxel Chikixoꞌl Tikawex y rukꞌ Rire kaqꞌalajin wi runimal uchomalil ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Yey we Ralaxel Chikixoꞌl Tikawex kuqꞌalajisaj runimal uchomalil ri Dios, jekꞌuriꞌlaꞌ e ri Dios ri kaqꞌalajisan runimal uchomalil Ralaxel Chikixoꞌl Tikawex, yey waꞌ na kamayin ta che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","»Ix walkꞌoꞌal, xa joqꞌotaj chi in kꞌo iwukꞌ. Riꞌix kinitzukuj na kꞌu riꞌ; pero e pachaꞌ ri ximbꞌiꞌij chike raj judiꞌabꞌ, na jinta piqꞌabꞌ kixꞌek chilaꞌ pa kinꞌek wi riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","»Kanya wa jun kꞌakꞌ taqanik chiwe: E lik kꞌax chinaꞌa iwibꞌ chiwach. Jelaꞌ pachaꞌ riꞌin lik kꞌax kixinnaꞌo, jekꞌulaꞌ lik kꞌax chinaꞌa iwibꞌ riꞌix chiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We lik kꞌu kꞌax kinaꞌ iwibꞌ chiwach, ruma waꞌ konoje ri winaq kaketaꞌmaj ix nutijoꞌn —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Ri Simón Pedro xutzꞌonoj che ri Jesús: —Wajawal, ¿pa kꞌu keꞌek wi la? —xchaꞌ. Ri Jesús xukꞌul uwach: —E pa wa kinꞌek wi riꞌin, na yaꞌtal ta chawe kat-terej bꞌi chwij woꞌora; noꞌj kopon na kꞌu ruqꞌijol echiriꞌ katopon chilaꞌ pa kinꞌek wi riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ekꞌu ri Pedro xubꞌiꞌij che: —Wajawal, ¿suꞌchak na yaꞌtal ta chwe kinterej bꞌi chiꞌij la woꞌora? Ma riꞌin xa jumul kanya ne ri nukꞌaslem pa kamik uma rilal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Y ri Jesús xukꞌul uwach: —¿Lik qatzij kawaj kaya awibꞌ pa kamik wuma riꞌin? Paqatzij wi kambꞌiꞌij chawe: Echiriꞌ kꞌamajaꞌ ne kabꞌixon ri teren, riꞌat oxlaj chik abꞌiꞌim na awetaꞌam ta nuwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","»Lik mapax ikꞌuꞌx. E chikubꞌaꞌ ikꞌuꞌx rukꞌ ri Dios y chikubꞌaꞌ ikꞌuꞌx wukꞌ riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Chilaꞌ pa kꞌo wi ri Nuqaw lik ukꞌiyal jeqlebꞌal kꞌolik. We ta na e ta uꞌanom, riꞌin nubꞌiꞌim chi riꞌ chiwe. Ekꞌu waꞌ kinꞌek chaꞌ kiꞌnyijbꞌaꞌ jun luwar iwe riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Yey we xinꞌek kꞌut y xyijbꞌitaj ri luwar iweꞌix, kinkꞌun tanchik y kixoꞌlnukꞌamaꞌ chaꞌ jelaꞌ pa kineꞌkꞌola wi riꞌin, riꞌix kixeꞌkꞌola chilaꞌ wukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Riꞌix iwetaꞌam pa kinꞌek wi yey iwetaꞌam ri bꞌe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Xubꞌiꞌij kꞌu ri Tomás che: —Qajawal, riꞌoj na qetaꞌam taj pa keꞌek wi la. ¿Saꞌ kꞌu uꞌanik riꞌ kaqetaꞌmaj ri bꞌe? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ri Jesús xukꞌul uwach: —In ri in Bꞌe, in ri in Qꞌijsaq yey in ri in Kꞌaslemal. Na jinta junoq kopon rukꞌ ri Nuqaw we na wuma ta riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We iwetaꞌam nuwach riꞌin, iwetaꞌam uwach riꞌ ri Nuqaw. Chwi kꞌu riꞌ woꞌora kiwetaꞌmaj uwach, ma iwilom chi uwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Ekꞌu ri Felipe xubꞌiꞌij che: —Qajawal, kꞌutu la chiqawach ri Qaw la y kojkubꞌiꞌ kꞌu riꞌ che —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ri Jesús xukꞌul uwach: —Felipe, ukꞌiyal qꞌij chi waꞌ kꞌut e laꞌ in kꞌo iwukꞌ, ¿yey kꞌamajaꞌ kawetaꞌmaj nuwach? Ma china ri etaꞌmayom nuwach riꞌin, riꞌ e rilom uwach ri Nuqaw. ¿Suꞌchak kꞌu riꞌ katzꞌonoj chwe kankꞌut ri Nuqaw chiwach? ");
INSERT INTO acrNNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Riꞌin rukꞌ ri Nuqaw y Rire wukꞌ riꞌin, xa oj jun. ¿Na kakoj ta kami riꞌ waꞌ? E janipa wa kambꞌiꞌij chiwe, na xa ta pa we riꞌin kambꞌiꞌij ma ri nuchꞌaꞌtem e re ri Nuqaw ri jeqel wukꞌ, yey Rire kuꞌan ruchak wuma riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chikojo kꞌu wa kambꞌiꞌij chiwe: Riꞌin rukꞌ ri Nuqaw y Rire wukꞌ riꞌin, xa oj jun. We na kikoj ta kꞌu waꞌ ruma ri nuchꞌaꞌtem, e chikojo ruma ri chak nuꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","»Paqatzij wi kambꞌiꞌij chiwe: China ri kakubꞌiꞌ ukꞌuꞌx wukꞌ riꞌin, riꞌ kuꞌan ne ri chak jelaꞌ pachaꞌ ri kanꞌan riꞌin; y más ne nimaq taq chak ri kuꞌano, ma e riꞌin kinꞌek pa kꞌo wi ri Nuqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronoje kꞌu ri kitzꞌonoj riꞌix che ri Nuqaw pa ri nubꞌiꞌ, riꞌin kanꞌano chaꞌ jelaꞌ runimal uchomalil ri Dios kaqꞌalajin ruma Rukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ronoje kꞌu riꞌ ri kitzꞌonoj riꞌix pa ri nubꞌiꞌ, riꞌin kanꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","»We riꞌix kꞌax kininaꞌo, e lik chiꞌana janipa ri kixintaq che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Yey riꞌin e kantzꞌonoj che ri Nuqaw chaꞌ kutaq chi lo jun chik Toꞌbꞌel iwe re kunimarisaj ikꞌuꞌx; y asu kakꞌojiꞌ iwukꞌ na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Waꞌ e ri Uxlabꞌixel re ri Qꞌijsaq. Taq ri winaq na utz taj kakikꞌulu, ma na kakil ta uwach y na ketaꞌam tane uwach. Noꞌj riꞌix iwetaꞌam uwach, ma Rire kꞌo chixoꞌlibꞌal y koꞌlkꞌola piwanimaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","»Riꞌin na kixinwoqꞌotaj ta kanoq, ma kintzelej lo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Na naj ta chi kꞌu riꞌ, ri winaq na kakil ta chi nuwach; noꞌj riꞌix kiwil tanchi nuwach. Ruma kꞌu riꞌin kinkꞌastaj lo chikixoꞌl ri ekaminaq, jenelaꞌ riꞌix kixkꞌastajik. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Chupa kꞌu riꞌ laꞌ la qꞌij riꞌix kiwetaꞌmaj: Riꞌin rukꞌ ri Nuqaw xa oj jun, yey riꞌix xa jun iꞌanom wukꞌ riꞌin y riꞌin xa jun nuꞌanom iwukꞌ riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","China kꞌu ri ukꞌulum ri nutaqanik y kuꞌan kꞌu janipa ri kambꞌiꞌij che, riꞌ lik kꞌax kinunaꞌo. Y china ri kꞌax kanaꞌw we riꞌin, kꞌax kanaꞌ ruma ri Nuqaw. Yey riꞌin lik kꞌax kannaꞌo y kanqꞌalajisaj che, in china riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Ri Judas (na e ta ri aj Iscariot) xubꞌiꞌij: —Qajawal, ¿suꞌbꞌe kaqꞌalajisaj la chiqawach riꞌoj china rilal yey chikiwach ri winaq na kaꞌan ta la waꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Ri Jesús xukꞌul uwach: —China ri kꞌax kinunaꞌ riꞌin, e kuꞌan janipa ri kambꞌiꞌij che. Ekꞌu ri Nuqaw kꞌax kunaꞌ rire, yey ri Nuqaw y riꞌin kojoꞌljeqela rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","China kꞌu ri na kꞌax ta kinunaꞌo, riꞌ na kutaqej ta janipa ri kambꞌiꞌij che. Wa tzij kixtajin che utayik, na xa ta weꞌin, e re ri Nuqaw, ri xtaqaw lo weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","»Ronoje waꞌ kintajin che ubꞌiꞌxik chiwe xaloqꞌ kꞌa in kꞌo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Yey echiriꞌ kinꞌek, ri Nuqaw kutaq lo ri jun Toꞌbꞌel pa ri nubꞌiꞌ re kubꞌochiꞌij ikꞌuꞌx, waꞌ e ri Santowilaj Ruxlabꞌixel ri Dios. Echiriꞌ kakꞌun Rire, kukꞌut ronoje chiwach y kukuxtaj kꞌu chiwe janipa ri nubꞌiꞌim riꞌin chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","»Ri utzil chomal kꞌo wukꞌ riꞌin, kanya kan chiwe. Yey waꞌ wa utzil chomal kanya riꞌin chiwe na xa ta jelaꞌ pachaꞌ ri kakiya taq ri winaq. Mapax kꞌu ikꞌuꞌx y mixiꞌij iwibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","»Itom chi kꞌu ri nubꞌiꞌim chiwe: “Kinꞌek yey kintzelej tanchi lo iwukꞌ.” We e laꞌ qatzij lik kꞌax kininaꞌo, xixkiꞌkot tane kꞌu riꞌ che echiriꞌ xito kinꞌek rukꞌ ri Nuqaw, ma Rire más kꞌo uwach chinuwa riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","»Kannabꞌesaj pan ubꞌiꞌxik waꞌ chiwe chaꞌ echiriꞌ kuꞌanaꞌ, kikoj kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Na naj ta chi kꞌut kinchꞌaꞌt iwukꞌ; ma ya kakꞌun lo ritzel winaq, ri jun kataqan che ruwachulew, tobꞌ na jinta ne puqꞌabꞌ rire kataqan panuwi riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Na rukꞌ ta kꞌu riꞌ, kanꞌano janipa ri kinutaq ri Nuqaw che uꞌanik, chaꞌ jelaꞌ ri winaq che ruwachulew kaketaꞌmaj riꞌin lik kꞌax kannaꞌ ri Nuqaw. »Chixyaktajoq; joꞌ, chojel bꞌi wara. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","»In ri in saqil raqan uva y ri Nuqaw e ri aj chakunel chupa taq ri uva. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","We kꞌo kꞌu juna uqꞌabꞌ ri uva na kuya ta uwach, Rire kuqꞌat bꞌi. Noꞌj kꞌu ri kuya uwach, xa e kujal uwiꞌ re kuꞌan chom che chaꞌ jelaꞌ kuya más uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Jekꞌulaꞌ riꞌix ꞌanom chi chom chiwe ruma ri kꞌutunik nuꞌanom chiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","»Miwesaj iwibꞌ chwij, jekꞌulaꞌ xa jun qaꞌanom, riꞌix wukꞌ riꞌin y riꞌin iwukꞌ riꞌix. Ma e pachaꞌ juna uqꞌabꞌ cheꞌ na kawachin ta xa utukel we kesax che ri raqan; jekꞌulaꞌ riꞌ riꞌix, na utz taj kixwachinik we kiwesaj iwibꞌ chwij. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","»In ri in raqan ri tikoꞌn yey riꞌix ix ruqꞌabꞌ. China kꞌu ri uꞌanom xa jun wukꞌ riꞌin yey riꞌin in xa jun rukꞌ rire, riꞌ lik kawachinik. Ma we iwesam iwibꞌ chwij, na jinta kichꞌij uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","China kꞌu ri karesaj ribꞌ chwij, jelaꞌ kaꞌan che pachaꞌ ruqꞌabꞌ cheꞌ na jinta uchak, kachetik y kakꞌaq bꞌi. Kachaqij kꞌut, tekꞌuchiriꞌ kamolik y kaporox pa aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","»Yey we e laꞌ xa jun iꞌanom riꞌix wukꞌ y na kikꞌow ta chikꞌuꞌx taq ri nukꞌutum chiwach, chitzꞌonoj kꞌu riꞌ saꞌ taq ri kiwaj y kayaꞌtaj na chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ri Nuqaw lik kayakiꞌ uqꞌij echiriꞌ riꞌix kiya ukꞌiyal ijiqꞌobꞌalil y rukꞌ waꞌ kaqꞌalajinik pa saqil wi ix nutijoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","»Jekꞌulaꞌ pachaꞌ ri Nuqaw lik kꞌax kinunaꞌ riꞌin, jekꞌuriꞌlaꞌ riꞌin kꞌax kixinnaꞌ riꞌix. Lik kꞌut miwesaj iwibꞌ chupa ri rutzil nukꞌuꞌx chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We e kiꞌan janipa ri kixintaq che, kixkꞌojiꞌ kꞌu riꞌ chupa wa rutzil nukꞌuꞌx, jelaꞌ pachaꞌ riꞌin nuꞌanom janipa ri inutaqom ri Nuqaw che uꞌanik yey in kꞌo chupa ri rutzil ukꞌuꞌx Rire. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","»Ximbꞌiꞌij waꞌ chiwe chaꞌ ri nukiꞌkotemal kakꞌojiꞌ iwukꞌ y kanoj kꞌu riꞌ ri iwanimaꞌ che kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","»Ekꞌu nutaqanik waꞌ kanya chiwe: Lik kꞌax chinaꞌa iwibꞌ chiwach jelaꞌ pachaꞌ riꞌin lik kꞌax kixinnaꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Na jinta juna kꞌutubꞌal re ri rutzil kꞌuꞌxaj más nim chwa waꞌ: E junoq kuya rukꞌaslem che utoꞌik jun chik tobꞌ ne kakam ruma. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","»Riꞌix ix wamigos we e laꞌ e kiꞌan janipa ri kixintaq che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Na kambꞌiꞌij ta chi ne “waj chak” chiwe, ma e juna aj chak na retaꞌam taj saꞌ ri kuꞌan ri rajaw. Kambꞌiꞌij kꞌu chiwe “ix wamigos”, ma nuyaꞌom chi retaꞌmaxik chiwe ronoje ri ubꞌiꞌim lo ri Nuqaw chwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Na ix ta xixchaꞌw we riꞌin, in ri xinchaꞌw iwe. Yey nuyaꞌom piqꞌabꞌ kiꞌana ri nuchak y jelaꞌ kiya ukꞌiyal ijiqꞌobꞌalil y waꞌ na jinta ukꞌisik. Yey janipa kꞌu ri kitzꞌonoj che ri Nuqaw pa ri nubꞌiꞌ, Rire kuya na chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ekꞌu kixintaq che uꞌanik waꞌ: Kꞌax chinaꞌa iwibꞌ chiwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","»We tzel kixkil ri winaq che ruwachulew, chiwetaꞌmaj e riꞌin ri nabꞌe tzel kinkilo. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We ta e laꞌ junam ribꞌinik riꞌix kukꞌ ri tikawex re ruwachulew, riꞌ lik kꞌax kixnaꞌik. Noꞌj in xinchaꞌw iwe riꞌix chikixoꞌl ri winaq; e uwariꞌche tzel kixilik. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Kꞌuna chikꞌuꞌx ri nubꞌiꞌim chiwe: Na jinta juna aj chak más kꞌo uwach chwa ri rajaw. We riꞌin internabꞌem rukꞌ kꞌaxkꞌobꞌik, jelaꞌ riꞌ kaꞌan chiwe riꞌix, kixternabꞌex rukꞌ kꞌaxkꞌobꞌik. Yey we e kꞌo ri kitaqem ri nutzij riꞌin, jekꞌulaꞌ riꞌ, e kꞌo ri kakitaqej ri kikꞌut riꞌix. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Pero ri kixkiternabꞌej rukꞌ kꞌax ruma ikojom ri nubꞌiꞌ, e kakiꞌan waꞌ ruma na ketaꞌam ta uwach ri xintaqaw loq. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","»We tamaji xinkꞌun riꞌin y tamaji xinkꞌut rutzij ri Nuqaw chikiwach, na jinta kꞌu kimak riꞌ ruma na xkikꞌul ta wa tzij. Noꞌj riꞌin xinkꞌunik y xinkꞌut rutzij ri Nuqaw chikiwach; ruma kꞌu waꞌ, na jinta junoq chike utz kubꞌiꞌij na jinta umak. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ma e ri tzel kebꞌilow we riꞌin, riꞌ e tzel kakil ri Nuqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Na jinta kꞌu kimak we tamaji nuꞌanom ukꞌiyal milagros chikiwach yey waꞌ na jinta chi ne junoq ꞌanayom re. Noꞌj rike kilom ronoje taq waꞌ; y na rukꞌ ta kꞌu riꞌ, tzel kinkil riꞌin y tzel kakil ri Nuqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","»Ekꞌu xuꞌan taq waꞌ chaꞌ lik e kuꞌana janipa ri tzꞌibꞌital kan pa ri Tzij Pixabꞌ kꞌo pakiqꞌabꞌ rike: Tzel xinkilo tobꞌ na jinta numak kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","»Yey echiriꞌ kinopon rukꞌ ri Nuqaw, kantaq lo Jun Toꞌbꞌel iwe re kunimarisaj ikꞌuꞌx. Rire kape rukꞌ ri Nuqaw y e Qꞌalajisanel re ri Qꞌijsaq. Ekꞌuchiriꞌ kakꞌunik, kaqꞌalajisan chiwach riꞌix panuwi riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Yey riꞌix kixqꞌalajisan na panuwi riꞌin, ma ix kꞌojiꞌnaq wukꞌ chwi ri jeqebꞌal lo ri nuchak. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","»Ximbꞌiꞌij kꞌu ronoje waꞌ chiwe chaꞌ na kasach ta ri kubꞌulibꞌal ikꞌuꞌx wukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Ma kopon ruqꞌijol echiriꞌ kixesax ne bꞌi riꞌix chupa taq ri sinagogas. Y china ri kakamisan iweꞌix, e chwa rire uchak ri Dios ri kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","E kakiꞌan waꞌ ma na ketaꞌam ta kꞌana uwach ri Nuqaw y na ketaꞌam tane nuwach riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Kambꞌiꞌij waꞌ chiwe, ma we xopon ruqꞌijol waꞌ, kꞌuna chikꞌuꞌx nubꞌiꞌim chi lo waꞌ chiwe. »Na ximbꞌiꞌij ta lo waꞌ chiwe chwi ri jeqebꞌal loq, ma kꞌa in kꞌo iwukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Noꞌj woꞌora kinꞌek chaꞌ kineꞌkꞌola rukꞌ ri taqayom lo we riꞌin, yey na jinta chi ne junoq chiwe kutzꞌonoj chwe pa kinꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Yey ruma ne nubꞌiꞌim waꞌ chiwe, lik xok bꞌis chikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Pero qatzij wa kambꞌiꞌij chiwe: Lik utz chiwe riꞌix we kinꞌek. Ma we na kinꞌek taj, na kakꞌun ta iwukꞌ ri Toꞌbꞌel re kubꞌochiꞌij ikꞌuꞌx. Noꞌj we xinꞌek, kantaq lo chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","»Echiriꞌ kakꞌun ri Ruxlabꞌixel ri Dios, kuya na chi retaꞌmaxik chike ri winaq re ruwachulew china ri kꞌo umak, china ri lik jusukꞌ chwach ri Dios y china puwiꞌ kꞌo wi ri qꞌatbꞌal tzij re ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kuqꞌalajisaj kꞌut china ri kꞌo umak: Waꞌ e ri na kakubꞌiꞌ ta ukꞌuꞌx wukꞌ riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kuqꞌalajisaj china ri lik jusukꞌ, ma riꞌin kinꞌek rukꞌ ri Nuqaw yey riꞌix na kiwil ta chi nuwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Yey kuqꞌalajisaj, ri Dios uqꞌatom chi tzij puwi ritzel winaq kataqan che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","»Lik kꞌo kuaj kambꞌiꞌij chiwe, pero na kambꞌiꞌij tana, ma woꞌora na kimaj ta usukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Noꞌj echiriꞌ kakꞌun ri Uxlabꞌixel re ri Qꞌijsaq, riꞌ kukꞌut chiwach riꞌix ronoje ri lik qatzij. Rire na xa ta pa re kachꞌaꞌtik, ma janipa ri kubꞌiꞌij e ubꞌiꞌim ri Dios che y jelaꞌ kuya chi retaꞌmaxik chiwe taq ri katajin loq. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ma e kuqꞌalajisaj janipa ri kuaj kambꞌiꞌij riꞌin chiwe, y jelaꞌ kunimarisaj nuqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronoje ri kꞌo rukꞌ ri Nuqaw, kꞌo wukꞌ riꞌin; e uwariꞌche ximbꞌiꞌij ri Ruxlabꞌixel e kuqꞌalajisaj janipa ri kuaj kambꞌiꞌij riꞌin chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","»Na naj ta chi kꞌu riꞌ kiwil nuwach, ma riꞌin kinꞌek chilaꞌ pa kꞌo wi ri Nuqaw; pero chiqawach apanoq kiꞌwila tanchi nuwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ekꞌuchiriꞌ, jujun chike rutijoꞌn jewaꞌ xkitzꞌonoj chikiwach: «¿Saꞌ keꞌelawi waꞌ? Ma kubꞌiꞌij: “Na naj ta chi kꞌu riꞌ kiwil nuwach, ma riꞌin kinꞌek chilaꞌ pa kꞌo wi ri Nuqaw; pero chiqawach apanoq kiꞌwila tanchi nuwach.” ");
INSERT INTO acrNNT_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Saꞌ keꞌelawi: “Na naj ta chi kꞌu riꞌ”? Na kaqamaj ta usukꞌ saꞌ puwi kachꞌaꞌt wi» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ri Jesús xunaꞌbꞌej kakaj kakiꞌan tzꞌonobꞌal che. Ruma kꞌu riꞌ xubꞌiꞌij chike: —Riꞌin ximbꞌiꞌij chiwe: “Na naj ta chi kꞌu riꞌ kiwil nuwach, pero chiqawach apanoq kiꞌwila tanchi nuwach.” ¿E kitzꞌonoj saꞌ keꞌelawi waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Paqatzij wi kambꞌiꞌij chiwe: Riꞌix kixoqꞌ na y kixbꞌison na, tobꞌ ri winaq re ruwachulew kekiꞌkotik. Tobꞌ riꞌix kixbꞌison woꞌora, wa bꞌis kuꞌana kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","»Echiriꞌ kutzir uwach juna ixoq, lik kakꞌojiꞌ pa kꞌaxkꞌolil ma xopon ruqꞌij. Noꞌj echiriꞌ alaxinaq chi rakꞌa, na kakꞌun ta chi ne chukꞌuꞌx ri kꞌaxkꞌolil ruma rukiꞌkotemal, ma xalax jun akꞌa che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Jekꞌuriꞌlaꞌ riꞌix kapax ikꞌuꞌx woꞌora; noꞌj echiriꞌ kiwil tanchi nuwach, kanoj kꞌu ri iwanimaꞌ che kiꞌkotemal yey waꞌ wa kiꞌkotemal na jinta junoq kesan re chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Chupa kꞌu riꞌ laꞌ la qꞌij na kajawax ta chik kiꞌan tzꞌonobꞌal chwi ri nubꞌiꞌim. »Paqatzij wi kambꞌiꞌij chiwe: Ronoje ri kitzꞌonoj che ri Nuqaw pa ri nubꞌiꞌ, Rire kuya chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Kꞌa chwi woꞌora riꞌix na jinta kꞌo itzꞌonom pa ri nubꞌiꞌ riꞌin. Chitzꞌonoj y kikꞌulu, chaꞌ jelaꞌ kanoj ri iwanimaꞌ che kiꞌkotemal. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","»Nubꞌiꞌim waꞌ chiwe rukꞌ kꞌambꞌal naꞌoj; noꞌj kopon kꞌu ri qꞌij echiriꞌ na kajawax ta chik kinchꞌaꞌt iwukꞌ rukꞌ kꞌambꞌal naꞌoj, ma riꞌ lik qꞌalaj chiwach riꞌix janipa ri kambꞌiꞌij chiwe chwi ri Nuqaw. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Chupa kꞌu laꞌ la qꞌij, utz kitzꞌonoj che ri Nuqaw chupa ri nubꞌiꞌ janipa ri kajawax chiwe. Yey na kajawax ta kꞌu riꞌ kinelaj chwach ri Nuqaw piwiꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ma ri Nuqaw lik kꞌax kixunaꞌo ruma kꞌax ininaꞌom riꞌin yey lik ikojom, riꞌin rukꞌ ri Dios in petinaq wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Riꞌin in petinaq rukꞌ ri Nuqaw y xinkꞌun che ruwachulew; yey woꞌora e waꞌ kanya kan ruwachulew y kintzelej rukꞌ ri Nuqaw —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Ekꞌu rutijoꞌn xkibꞌiꞌij che: —Woꞌora lik qꞌalaj ri kabꞌiꞌij la chiqe, ma na kachꞌaꞌt ta chi la rukꞌ kꞌambꞌal naꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Yey woꞌora kaqamaj usukꞌ rilal lik etaꞌam la ronoje. Uwariꞌche na kajawax taj kꞌo junoq kuꞌan tzꞌonobꞌal cheꞌla, ma etaꞌam chi la saꞌ ri kaqaj kaqatzꞌonoj echiriꞌ kꞌamajaꞌ ne kaqaꞌan ri tzꞌonobꞌal. Ruma kꞌu laꞌ, qakojom rilal rukꞌ ri Dios petinaq wi la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Ri Jesús xukꞌul uwach: —¿Kꞌa e woꞌora kikoj waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Kakꞌun kꞌu ruqꞌijol y waꞌ ya xujeqo echiriꞌ riꞌix kixkicher bꞌi. Chijujunal kꞌut kimaj bꞌi ibꞌe y kiniya kan nutukel. Pero riꞌin na kinkanaj ta kan nutukel, ma ri Nuqaw kꞌo wukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","»Ximbꞌiꞌij ronoje waꞌ chiwe chaꞌ wuma riꞌin kiriq utzil chomal. Che ruwachulew riꞌix lik kitij kꞌax. Pero chinimarisaj kꞌu ikꞌuꞌx, ma riꞌin nuchꞌijom uchuqꞌabꞌ taq ri na utz taj re ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Echiriꞌ ubꞌiꞌim chi waꞌ, ri Jesús xtzuꞌn chikaj y xubꞌiꞌij: «Nuqaw, xopon ru orayil; yaka kꞌu la uqꞌij ri Kꞌajol la chaꞌ jelaꞌ ri Kꞌajol la kuyak qꞌij Rilal. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Ma Rilal yaꞌom la che ri Kꞌajol la kataqan pakiwi konoje ri tikawex, chaꞌ puqꞌabꞌ Rire kꞌo wi kuya kꞌaslemal na jinta utaqexik chike konoje ri eyaꞌom la che. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ekꞌu wa kꞌaslemal na jinta utaqexik e ruma ri ketaꞌmax wach la, xew Rilal Lal Dios y na jinta jun chik, yey ketaꞌmax kꞌu uwach ri Jesucristo, ri xtaq lo la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","»Riꞌin nuyakom qꞌij la wara che ruwachulew y xinkꞌis uꞌanik ri xintaq lo la che uꞌanik. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Ekꞌu woꞌora Nuqaw, yaka la nuqꞌij chilaꞌ ukꞌ la, jelaꞌ pachaꞌ ri ꞌanom la chwe echiriꞌ kꞌamajaꞌ ne kajeqer ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","»Chike taq ri tikawex xeya la chwe che ruwachulew, nuqꞌalajisam china Rilal. Rike e e la, y xeya la panuqꞌabꞌ yey kitaqem ri tzij la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Y woꞌora ketaꞌam waꞌ: Ronoje ri yaꞌom la chwe, ukꞌ la petinaq wi. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ma janipa ri xbꞌiꞌij la chwe, nutzijom chike ri xeya la chwe, y rike xkikojo. Yey xketaꞌmaj kꞌut paqatzij wi riꞌin ukꞌ la in petinaq wi y Lal taqayom lo la weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","»Riꞌin kinelaj ko chiwach la pakiwi rike; na e ta pakiwi konoje ri tikawex, xew pakiwi ri eyaꞌom la panuqꞌabꞌ, ma rike e e la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Konoje ri e kꞌo panuqꞌabꞌ, e e la. Jekꞌulaꞌ riꞌ, konoje ri e kꞌo paqꞌabꞌ Rilal, e weꞌin. Y ri yakbꞌal nuqꞌij kaqꞌalajin kuma rike. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","»Yey riꞌin kintzelej ukꞌ la, na kinkanaj ta kan che ruwachulew; noꞌj rike kekanajik. Lal Santowilaj Nuqaw, chechajij ko la chupa ri bꞌiꞌ la, ri eyaꞌom la chwe, chaꞌ chuꞌana xa jun kikꞌuꞌx jelaꞌ pachaꞌ nuꞌanom riꞌin ukꞌ la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Echiriꞌ riꞌin in kꞌo kukꞌ wara che wuꞌwachulew, xebꞌenuchajij chupa ri bꞌiꞌ la ri eyaꞌom la chwe. Na jinta junoq chike xsachik, xew kꞌu ri jun xex wi sachinaq chik chaꞌ e kuꞌana janipa ri tzꞌibꞌital kan chupa ri Chꞌaꞌtem la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","»Ekꞌu woꞌora kintzelej tanchi ukꞌ la. Pero xaloqꞌ kꞌa in kꞌo che ruwachulew, kambꞌiꞌij taq waꞌ chike chaꞌ lik kanoj ri kanimaꞌ che kiꞌkotemal, jelaꞌ pachaꞌ ri kiꞌkotemal kꞌo wukꞌ riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","»Riꞌin nuyaꞌom ri Chꞌaꞌtem la chike. Yey taq ri winaq re ruwachulew tzel kekilo ma na junam ta kikꞌuꞌx kukꞌ, jelaꞌ pachaꞌ riꞌin na junam ta nukꞌuꞌx kukꞌ ri e re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Na e ta kꞌu kinelaj chiwach la chaꞌ kebꞌesaj la che ruwachulew, xew lik chechajij la chwach ritzel winaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Rike na junam ta kikꞌuꞌx kukꞌ ri e re ruwachulew, jelaꞌ pachaꞌ riꞌin na junam ta nukꞌuꞌx kukꞌ ri e re ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","»Yaꞌa kꞌu la chike kebꞌin jusukꞌ chupa ri Qꞌijsaq e la, waꞌ e ri Chꞌaꞌtem la. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Jelaꞌ pachaꞌ Rilal xintaq lo la chikixoꞌl ri tikawex che ruwachulew, jekꞌuriꞌlaꞌ riꞌin kebꞌenutaq bꞌi rike chikixoꞌl ri tikawex che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Y kuma kꞌu rike, lik nuyaꞌom wibꞌ riꞌin che uꞌanik ri rajawal kꞌuꞌx la, chaꞌ jelaꞌ rike kebꞌin jusukꞌ chupa ri Qꞌijsaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","»Yey na xew tane kinelaj chiwach la pakiwi rike, ma e kantzꞌonoj cheꞌla pakiwi ri kꞌamajaꞌ kakikoj ri nubꞌiꞌ ruma kakita ri tzijonik kakiꞌan rike. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Lal Nuqaw, kantzꞌonoj ko cheꞌla chuꞌana xa jun kikꞌuꞌx chikiwach junam qukꞌ riꞌoj, jelaꞌ pachaꞌ riꞌin ukꞌ la y Rilal wukꞌ riꞌin, chaꞌ ri e kꞌo che ruwachulew kakikojo e rilal taqayom lo la we riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","»Ri yakbꞌal nuqꞌij yaꞌom la chwe riꞌin, xinya chike rike chaꞌ chuꞌana xa jun kikꞌuꞌx jelaꞌ pachaꞌ Rilal y riꞌin xa jun qakꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Riꞌin in kꞌo kukꞌ rike y Rilal kꞌo la wukꞌ riꞌin chaꞌ rike kuꞌan xa jun kikꞌuꞌx pa saqil wi. Jekꞌulaꞌ riꞌ konoje ri tikawex che ruwachulew kaketaꞌmaj e Rilal taqayom lo la we riꞌin y lik kꞌax kenaꞌ la ri nutijoꞌn, jelaꞌ pachaꞌ lik kꞌax kinnaꞌ la riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","»Lal Nuqaw, e janipa ri eyaꞌom la panuqꞌabꞌ, e kuaj riꞌin kebꞌeꞌkꞌola wukꞌ pa kineꞌkꞌola wi, chaꞌ kakil ri yakbꞌal nuqꞌij yaꞌom la. Ma xex wi kꞌax innaꞌom lo la, chwi echiriꞌ kꞌamajaꞌ ne kajeqer ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Nuqaw, Rilal lik Lal jusukꞌ, yey ri tikawex che ruwachulew na ketaꞌam ta wach la. Noꞌj riꞌin wetaꞌam wach la yey ri nutijoꞌn ketaꞌam e Rilal taqayom lo la we riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Lik kꞌut nuqꞌalajisam chikiwach china Rilal y kꞌa kintajin ne che uqꞌalajisaxik waꞌ, chaꞌ ri rutzil kꞌuꞌx la chwe riꞌin, kakꞌojiꞌ kukꞌ rike y jelaꞌ kinkꞌojiꞌ riꞌin pa kanimaꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Echiriꞌ ri Jesús xukꞌis ubꞌiꞌxikil taq waꞌ, xel bꞌi junam kukꞌ rutijoꞌn, xkiqꞌaxuj kꞌu ri raqanaꞌ Cedrón y xebꞌok chupa jun werta kꞌo chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ri Judas, ri kakꞌayin re ri Jesús, retaꞌam chi ri luwar, ma ukꞌiyal laj ri Jesús kukꞌ rutijoꞌn kimolom kibꞌ chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Ekꞌu ri Judas xoponik, ebꞌukꞌamom bꞌi ukꞌiyal soldados y taq ri chajinel re ri Rocho Dios. Rike kukꞌaꞌam taq chapabꞌal, yey e kꞌo ri kawolol ri ki aqꞌ y e kꞌo ri xa kitzukꞌem ki aqꞌ. Waꞌ etaqom bꞌi kuma ri nimaq e aj chakunel pa Rocho Dios y ri fariseos. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ekꞌu ri Jesús ruma retaꞌam chi ronoje ri katajin lo puwiꞌ, xebꞌuꞌkꞌulu apanoq y xutzꞌonoj chike: —¿China ri kitzukuj? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Rike xkikꞌul uwach: —E Jesús ri aj Nazaret —xechaꞌ. Ri Jesús xubꞌiꞌij kꞌu chike: —In riꞌin —xchaꞌ. Yey ri Judas, ri kakꞌayin re, kꞌo chikixoꞌl ri kakaj kakichap bꞌi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Echiriꞌ xubꞌiꞌij ri Jesús chike: “In riꞌin”, xetzelej chikij y xetzaq pulew. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ekꞌu ri Jesús xutzꞌonoj tanchi chike: —¿China ri kitzukuj? —xchaꞌ. Y rike xkibꞌiꞌij: —E Jesús ri aj Nazaret —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Xubꞌiꞌij kꞌu ri Jesús chike: —Riꞌin nubꞌiꞌim chi che alaq; “In riꞌin.” We in kꞌu ri kintzukuj alaq, yaꞌa bꞌi alaq luwar chike wa nutijoꞌn chebꞌeꞌojana —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","E xubꞌiꞌij waꞌ ri Jesús chaꞌ e kuꞌana ri ubꞌiꞌim chik: «Na jinta junoq xsach chike ri ebꞌuyaꞌom ri Nuqaw chwe.» ");
INSERT INTO acrNNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ekꞌu ri Simón Pedro rukꞌaꞌam jun espada. Xresaj kꞌu uloq y xujochij bꞌi ruxikin uwikiqꞌabꞌ ri raj chak ri kajawal raj chakunel pa Rocho Dios. Wa aj chak Malco rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Ri Jesús xubꞌiꞌij kꞌu che ri Pedro: —Chakꞌolo ra espada chupa rukꞌolibꞌal. ¿Na kinikꞌow ta kami riꞌ pa ri kꞌaxkꞌobꞌik we e ri Nuqaw intaqayom lo che? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Ekꞌuchiriꞌ, ri soldados y ri taqanel ke, junam kukꞌ raj judiꞌabꞌ e chajinel re ri Rocho Dios, xkichap ri Jesús y xkiyutu. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Xkikꞌam kꞌu bꞌi ri Jesús chwa ri Anás, ruqaw-ujiꞌ ri Caifás ri kajawal raj chakunel pa Rocho Dios chupa laꞌ la junabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Yey e Caifás ri ubꞌiꞌim chike raj judiꞌabꞌ: «E más utz we ta e laꞌ xa jun chi achi kakam kuma konoje ri tinamit.» ");
INSERT INTO acrNNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Ri Simón Pedro y jun chik tijoꞌn eteran bꞌi chirij ri Jesús. Waꞌ wa jun chik tijoꞌn etaꞌmatal uwach ruma ri kajawal raj chakunel pa Rocho Dios; ekꞌu rire xok bꞌi rukꞌ ri Jesús che ruwa ja re ri rocho ri aj wach. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Noꞌj ri Pedro xkanaj kan chwa ri puerta pa bꞌe. Ruma kꞌu riꞌ, xel lo ri jun tijoꞌn etaꞌmatal uwach ruma ri kajawal raj chakunel pa Rocho Dios, xchꞌaꞌt rukꞌ rali aj chajal re ri puerta chaꞌ kuya luwar che ri Pedro kok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ekꞌuchiriꞌ rali xutzꞌonoj che ri Pedro: —¿Na lal ta nawi jun chike rutijoꞌn laꞌ la jun achi? —xchaꞌ. Ri Pedro xukꞌul uwach: —Na in taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ruma kꞌu lik kꞌax tew, raj chakibꞌ y ri e chajinel e takꞌal chuchiꞌ jun aqꞌ kinukꞌum re kakimiqꞌisaj kibꞌ. Yey ri Pedro kꞌo kukꞌ chuchiꞌ ri aqꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ri kajawal raj chakunel pa Rocho Dios xujeq utzꞌonoxik che ri Jesús pakiwi taq rutijoꞌn y puwi rukꞌutunik. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ri Jesús xubꞌiꞌij che: —Riꞌin in tzijoninaq chiwachil chikiwach konoje ri winaq, xaqi in kꞌutuninaq pa taq sinagogas y pa ri Rocho Dios pa kakimol wi kibꞌ raj judiꞌabꞌ. Na jinta kꞌo nubꞌiꞌim xa xeꞌlaqꞌay. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Suꞌchak kꞌu riꞌ katzꞌonoj alaq chwe puwi ri nukꞌutunik? E tzꞌonoj alaq chike ri e tayom we riꞌin, ma rike ketaꞌam saꞌ ri nukꞌutum chikiwach —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Echiriꞌ xubꞌiꞌij waꞌ ri Jesús, jun chike ri e chajinel xupachꞌ jun qꞌabꞌ chupalaj ri Jesús y xubꞌiꞌij che: —¿Utz nebꞌa jelaꞌ kakꞌulubꞌej uwach ri kajawal raj chakunel pa Rocho Dios? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Ri Jesús xukꞌul uwach: —We ximbꞌiꞌij juna chꞌaꞌtem na utz taj, bꞌiꞌij la riꞌ saꞌ ri na utz taj ximbꞌiꞌij. Noꞌj we utz ri ximbꞌiꞌij, ¿suꞌchak kꞌu riꞌ xinchꞌay la? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Yutum chi ri Jesús, ri Anás xutaq bꞌi chwa ri Caifás, ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ekꞌu ri Pedro takꞌal chuchiꞌ ri aqꞌ, kumiqꞌisaj ribꞌ. Yey e kꞌo jujun jewaꞌ xkibꞌiꞌij che: —¿Na lal ta nawi jun chike rutijoꞌn laꞌ la jun achi? —xechaꞌ. Ri Pedro xrewaj, jewaꞌ xubꞌiꞌij: —¡Jaꞌi! Na in taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Chiriꞌ kꞌo jun raj chak ri kajawal raj chakunel pa Rocho Dios. Rire kꞌo chux che ri jun xjochix ruxikin ruma ri Pedro. Xutzꞌonoj kꞌu che ri Pedro: —¿Na xinwil ta nebꞌa wach la chilaꞌ pa ri werta rukꞌ ri Jesús? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Yey ri Pedro xrewaj tanchik, y ekꞌuchiriꞌ xbꞌixon lo ri teren. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","E riꞌ katajin usaqirik echiriꞌ xesax bꞌi ri Jesús chwa rocho ri Caifás y xkꞌam bꞌi pa ri palacio re ri Pilato, ri taqanel aj Roma. Ekꞌu ri aj judiꞌabꞌ na xebꞌok ta chupa ri palacio chaꞌ na kakichꞌulaj ta kibꞌ chwach ri Dios y jekꞌulaꞌ utz kakitij ri cena re Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","E uwariꞌche, ri taqanel Pilato xel loq chaꞌ kachꞌaꞌt kukꞌ y xubꞌiꞌij chike: —¿Saꞌ rumak waꞌchi kakoj alaq? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Raj judiꞌabꞌ xkikꞌul uwach: —We tamaji aj mak, na kaqaya ta riꞌ paqꞌabꞌ la —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Ekꞌu ri Pilato xubꞌiꞌij chike: —Kꞌama bꞌi alaq y qꞌata alaq tzij puwiꞌ jelaꞌ pachaꞌ ri kubꞌiꞌij ri tzijpixabꞌ e alaq —xchaꞌ. Pero raj judiꞌabꞌ xkikꞌul uwach: —Riꞌoj oj aj judiꞌabꞌ na jinta paqaqꞌabꞌ kaqaqꞌat tzij re kamik puwi junoq —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Jelaꞌ e xuꞌana pachaꞌ rubꞌiꞌim lo ri Jesús puwi rukamik. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ri Pilato xok tanchi ubꞌi chupa ri palacio, xusikꞌij ri Jesús y xutzꞌonoj che: —¿Lal kami riꞌ ri rey ke raj judiꞌabꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Ri Jesús xubꞌiꞌij che: —¿Xa pa e la kaꞌan la wa tzꞌonobꞌal chwe o kꞌo ebꞌiꞌyom re cheꞌla? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ri Pilato xukꞌul uwach: —Na jinta we riꞌin che waꞌ, ma ¿in nebꞌa kukꞌil raj judiꞌabꞌ? Yey ri xeyaꞌw e la panuqꞌabꞌ e ri winaq re ri tinamit la kukꞌ ri nimaq e aj chakunel pa Rocho Dios. ¿Saꞌ kꞌu ri mak ꞌanom la? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Ekꞌu ri Jesús xukꞌul uwach: —Ri nutaqanik riꞌin na re ta wara che ruwachulew. Ma we ta re wara, xechꞌoꞌjin ta kꞌu riꞌ ri nutijoꞌn chaꞌ na kinyaꞌ ta pakiqꞌabꞌ raj judiꞌabꞌ. Noꞌj ri nutaqanik na re ta wara che ruwachulew —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Xubꞌiꞌij kꞌu ri Pilato che: —¿Qatzij kami riꞌ lal rey? —xchaꞌ. Ri Jesús xukꞌul uwach: —Lal kabꞌiꞌn la re, riꞌin in rey. Riꞌin xinalax che ruwachulew yey xinkꞌunik re kanqꞌalajisaj ri Qꞌijsaq. Janipa kꞌu ri kitaqem ri Qꞌijsaq, e kakita ri kambꞌiꞌij riꞌin —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Ri Pilato xubꞌiꞌij che: —¿Saꞌ riꞌ laꞌ la Qꞌijsaq? —xchaꞌ. Echiriꞌ uꞌanom chi wa tzꞌonobꞌal, xel tanchi ubꞌi ri Pilato, xchꞌaꞌt tanchi kukꞌ raj judiꞌabꞌ y xubꞌiꞌij chike: —Riꞌin na kanriq ta juna umak waꞌchi. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Ralaq lik xex kaꞌan wi alaq ri koyꞌej alaq pa ri nimaqꞌij Pascua kanyolopij bꞌi chiwach alaq juna achi kꞌo pa cárcel. ¿Kaꞌaj kami alaq riꞌ e kanyolopij bꞌi ri rey ke raj judiꞌabꞌ? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ekꞌuchiriꞌ, konoje xkijeq kesikꞌin tanchik: —¡Mayolopij bꞌi la ri Jesús! ¡E yolopij bꞌi la ri Barrabás! —xechaꞌ. Yey ri Barrabás e jun achi eleqꞌom. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Ekꞌu ri Pilato xtaqan che kakꞌam bꞌi ri Jesús y kajichꞌ upa. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Yey ri soldados xkikoj che rujolom ri Jesús jun corona kipachꞌum rukꞌ kꞌiix. Y xkirip jun manta morato chirij. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Tekꞌuchiriꞌ xeqibꞌ rukꞌ y kakibꞌiꞌij: —¡Nim uqꞌij ri rey ke raj judiꞌabꞌ! —kechaꞌ. Yey kakipachꞌ qꞌabꞌ chupalaj. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ri Pilato xel tanchi uloq y xubꞌiꞌij chike raj judiꞌabꞌ: —Chilape alaq, kanwesaj lo waꞌchi chiwach alaq. Chetaꞌmaj kꞌu alaq, riꞌin na jinta juna umak kanriqo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Ekꞌuchiriꞌ xel lo ri Jesús, kꞌo ri corona re kꞌiix che rujolom y ripom ri manta morato chirij. Xubꞌiꞌij kꞌu ri Pilato chike: —¡Riꞌ rachi kꞌo chiwach alaq! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Echiriꞌ ri nimaq e aj chakunel pa Rocho Dios kukꞌ ri e chajinel re ri Rocho Dios xkil ri Jesús, xkijeq kesikꞌinik, jewaꞌ kakibꞌiꞌij: —¡Kamisax chwa cruz! ¡Kamisax chwa cruz! —kechaꞌ. Ekꞌu ri Pilato xubꞌiꞌij chike: —We e riꞌ, kꞌama bꞌi ralaq y kamisaj alaq chwa cruz, pero riꞌin na jinta juna umak kanriqo —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Raj judiꞌabꞌ xkikꞌul uwach: —Riꞌoj kꞌo jun taqanik paqawiꞌ y kubꞌiꞌij kꞌu riꞌ taqal che rire kakamisaxik ma uꞌanom Ukꞌajol Dios che ribꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Echiriꞌ ri Pilato xuta waꞌ, xok más xiꞌin ibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Xok kꞌu tanchi ubꞌi pa ri palacio y xutzꞌonoj che ri Jesús: —¿Pa lal petinaq wi rilal? —xchaꞌ. Pero ri Jesús na xukꞌul ta uwach. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ri Pilato xubꞌiꞌij kꞌu che: —¿E laꞌ na kakꞌul ta la uwach wa kantzꞌonoj cheꞌla? ¿Na etaꞌam ta kami la panuqꞌabꞌ riꞌin kꞌo wi kankamisaj la chwa cruz y panuqꞌabꞌ kꞌo wi kanyolopij bꞌi la? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Ri Jesús xukꞌul uwach: —Paqatzij wi kambꞌiꞌij cheꞌla, na jinta kꞌana paqꞌabꞌ la kataqan la panuwiꞌ we tamaji e ri Dios chilaꞌ chikaj xyaꞌw cheꞌla. E uwariꞌche, china ri xinqꞌatisan paqꞌabꞌ la, e más kꞌo umak riꞌ, chiwach rilal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Chwi kꞌu riꞌ, ri Pilato lik xutzukuj suꞌanik kuyolopij bꞌi ri Jesús. Pero raj judiꞌabꞌ ko kesikꞌin che ubꞌiꞌxik: —¡We xyolopij bꞌi la, na lal ta chi ramigo riꞌ ri nimalaj taqanel re Roma; ma china ri kuꞌan rey che ribꞌ, riꞌ e tzel karil wa nimalaj taqanel! —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Echiriꞌ xuta waꞌ ri Pilato, xutaq bꞌi resaxik ri Jesús y xtzꞌuyiꞌ pa ri luwar re qꞌatbꞌal tzij “Tzꞌaqom Abꞌaj” kecha che, yey pa ri chꞌaꞌtem hebreo “Gabatá” rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","E qꞌij riꞌ kayijbꞌax pan janipa ri kajawax pa ri nimaqꞌij Pascua. Ekꞌuchiriꞌ xuꞌan tikꞌil qꞌij, ri Pilato xubꞌiꞌij chike raj judiꞌabꞌ: —Riꞌ ri rey e alaq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Noꞌj raj judiꞌabꞌ ko kesikꞌin che ubꞌiꞌxik: —¡Kamisax chwa cruz! ¡Kamisax chwa cruz! —kechaꞌ. Ri Pilato xubꞌiꞌij chike: —¿Kankamisaj kami riꞌ chwa cruz ri rey e alaq? —xchaꞌ. Pero ri nimaq e aj chakunel re ri Rocho Dios xkikꞌul uwach: —Riꞌoj na jinta juna chik qarey, xew e qarey ri nimalaj taqanel re Roma —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Ekꞌu ri Pilato xuya bꞌi ri Jesús pakiqꞌabꞌ re kakamisax chwa cruz. Ewi xkꞌam bꞌi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Ri Jesús utelem bꞌi rucruz echiriꞌ xkꞌam bꞌi pa ri luwar kabꞌiꞌx che “Luwar re Ubꞌaqil Ujolom Animaꞌ”, yey pa ri chꞌaꞌtem hebreo, “Gólgota”. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Chiriꞌ kꞌu riꞌ xyaꞌ wi ri Jesús chwa ri cruz junam kukꞌ kebꞌ chik achijabꞌ, jun pa taq utzal; y xkꞌojiꞌ kꞌu Rire chikinikꞌajal. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Ri Pilato utaqom chik katzꞌibꞌax waꞌ y kayaꞌ kꞌu lo chwi ri cruz: «JESÚS RI AJ NAZARET, RI REY KE RAJ JUDIꞌABꞌ.» ");
INSERT INTO acrNNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Yey waꞌ tzꞌibꞌital pa ri chꞌaꞌtem hebreo, pa ri chꞌaꞌtem griego y pa ri chꞌaꞌtem latín. E kꞌi kꞌu chike raj judiꞌabꞌ xkajilaj waꞌ, ma ri luwar pa xyaꞌ wi ri Jesús chwa ri cruz xa naqaj kꞌo wi che ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Yey ri nimaq e aj chakunel re ri Rocho Dios xkibꞌiꞌij che ri Pilato: —Na ubꞌe taj xtzꞌibꞌaj la “Ri rey ke raj judiꞌabꞌ”. Jalkꞌatij la chaꞌ jewaꞌ kubꞌiꞌij: “Rire xubꞌiꞌij: Riꞌin in rey ke raj judiꞌabꞌ” —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pero ri Pilato xubꞌiꞌij chike: —Ri xintaq utzꞌibꞌaxik riꞌin, jelaꞌ kakanaj kanoq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Ri soldados echiriꞌ kiyaꞌom chi ri Jesús chwa ri cruz, xkimol uchiꞌ ruqꞌuꞌ, xkijach upa chaꞌ kuꞌan kajibꞌ rajaw. Jelaꞌ xkaj kakiꞌan rukꞌ rukoton; pero waꞌ xa jun upa uꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Ruma kꞌu waꞌ, ri soldados jewaꞌ xkibꞌiꞌij chikiwach: —Maqarichꞌij upa rukoton; qaꞌana jun sorteo chaꞌ jelaꞌ kaqilo chinoq chiqe kakꞌamaw bꞌi re —xechaꞌ. Ekꞌu xuꞌana pachaꞌ ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios: Xkijach kibꞌ puwi ri nuqꞌuꞌ, ma xkiꞌan sorteo rukꞌ kachaꞌ. Yey jekꞌuriꞌlaꞌ xkiꞌan ri soldados. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Chunaqaj kꞌu ri cruz e kꞌo ruchu ri Jesús, ruchaqꞌ ruchu, ri María rixoqil ri Cleofas y ri María ri aj Magdala. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Echiriꞌ ri Jesús xril pan ruchu kꞌo putzal ri jun utijoꞌn lik kꞌax kunaꞌ Rire, xubꞌiꞌij kꞌu pan che ruchu: —Nuchu, chwi kꞌu woꞌora e alabꞌ la laꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Tekꞌuchiriꞌ xubꞌiꞌij che ri jun utijoꞌn kꞌo putzal ri María: —Ekꞌu riꞌat, chwi woꞌora e achu laꞌ —xchaꞌ. Chwi kꞌu riꞌ, wa jun utijoꞌn ri Jesús xukꞌam bꞌi ri María chaꞌ keꞌjeqela chirocho. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Ekꞌu ri Jesús retaꞌam ya xukꞌis uꞌanik ronoje ruchak; yey chaꞌ e kuꞌana janipa ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios, jewaꞌ xubꞌiꞌij: —Katzajin nuchiꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Chiriꞌ kꞌo jun xaro nojinaq che vinagre. Yey e kꞌo jujun xkichuqꞌ jun esponja chupa, xkixim kꞌu chutzaꞌm jun vara re hisopo y xkiya pan chwa reꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Rire xutij ri vinagre, tekꞌuchiriꞌ xubꞌiꞌij: —Xinkꞌis kꞌu utzaꞌm ri nuchak —xchaꞌ. Ekꞌuchiriꞌ, xuyuxubꞌaꞌ rujolom y xuqꞌatisaj ri ranimaꞌ puqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ekꞌu qꞌij riꞌ kayijbꞌax pan janipa ri kajawax pa ri nimaqꞌij Pascua. Ruma kꞌu laꞌ, raj judiꞌabꞌ na kakaj taj kakꞌojiꞌ juna kaminaq chwa cruz pa ri qꞌij re uxlanibꞌal, ma laꞌ la jun qꞌij lik nimalaj nimaqꞌij. E uwariꞌche xkitzꞌonoj che ri Pilato kutaq uqꞌepik ri kaqan ri e kꞌo chwa cruz chaꞌ jelaꞌ kekam tan y keqasax kꞌu uloq. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Xebꞌek kꞌu ri soldados y xeꞌkiqꞌepa ri kaqan ri e kꞌo chwa cruz pa taq utzal ri Jesús. Xkiꞌan kꞌu riꞌ che ri nabꞌe, tekꞌuchiriꞌ jelaꞌ xkiꞌan che ri jun chik. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Pero echiriꞌ xeqibꞌ rukꞌ ri Jesús, xkilo kaminaq chik; ruma riꞌ, na xkiqꞌep ta ri raqan. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Na rukꞌ ta kꞌu riꞌ, jun chike ri soldados xutoqꞌ rukꞌalkꞌaꞌx ri Jesús rukꞌ rulanza y kꞌatetana chupa waꞌ xel lo kikꞌ y yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ri katzijon re ronoje waꞌ e xilow re; lik qatzij kꞌu ri kubꞌiꞌij ma lik retaꞌam saꞌ ri xrilo. Yey kutzijoj kꞌu riꞌ chaꞌ kakubꞌiꞌ kꞌuꞌx alaq rukꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma ronoje taq waꞌ xuꞌano chaꞌ e kuꞌana janipa ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios, ma jewaꞌ kubꞌiꞌij: Na kaqꞌep tane junoq che rubꞌaqil. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Yey jewaꞌ kubꞌiꞌij Ruchꞌaꞌtem ri Dios: Kakil na kꞌu uwach ri jun xkitoqꞌ rukꞌalkꞌaꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Kꞌisbꞌal re taq waꞌ, ri José aj Arimatea xuꞌtzꞌonoj che ri Pilato chaꞌ kayaꞌ che kukꞌam bꞌi rucuerpo ri Jesús. Yey ri José e jun chike rutijoꞌn ri Jesús tobꞌ xa xeꞌlaqꞌay, ma kuxiꞌij ribꞌ chikiwach ri rach e aj judiꞌabꞌ. Ekꞌu ri Pilato xuya bꞌi che, y ri José xukꞌam bꞌi rucuerpo ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Ekꞌu ri Nicodemo, ri jun achi xeꞌchꞌaꞌta rukꞌ ri Jesús chaqꞌabꞌ, xopon che utoꞌik ri José. Rukꞌaꞌam laj jun quintal kunabꞌal lik kiꞌ ruxlabꞌ, waꞌ mirra uyijbꞌam rukꞌ áloes. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Xkikꞌam kꞌu bꞌi rucuerpo ri Jesús y xkibꞌolqꞌotij pa jutaq rabꞌaꞌj kꞌul kojotal ri kunabꞌal che, ma waꞌ lik xex kakiꞌan wi raj judiꞌabꞌ che kimuqik ri kekamik. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Xa naqaj che ri luwar pa xkikamisaj wi ri Jesús chwa ri cruz, kꞌo jun luwar kꞌo chomilaj cheꞌ chwach. Y chiriꞌ kꞌo jun muqubꞌal kꞌakꞌ ꞌanom, y na jinta junoq muqum chupa. ");
INSERT INTO acrNNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chiriꞌ kꞌu riꞌ xkimuq wi rucuerpo ri Jesús, ma ri muqubꞌal xa naqaj kꞌo wi; yey xkaj kamuqiꞌ ri cuerpo pa ri qꞌij echiriꞌ raj judiꞌabꞌ kakiyijbꞌaꞌ pan janipa ri kajawax chike pa ri nimaqꞌij Pascua, ma na utz taj kaꞌan muqunik pa ri nimaqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ri nabꞌe qꞌij che ri semana, ri María ri aj Magdala lik anim tan, kꞌa qꞌequꞌm nenareꞌ, xeꞌek pa muqutal wi ri Jesús. Y kꞌate xrilo esam chi rabꞌaj chuchiꞌ ri muqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Ekꞌuchiriꞌ, kakꞌalalik xeꞌek pa e kꞌo wi ri Simón Pedro y ri jun chik tijoꞌn lik kꞌax kanaꞌ ruma ri Jesús, y xubꞌiꞌij kꞌu chike: —Ri Qajawal xesax bꞌi pa muqutal wi y na qetaꞌam taj pa xyaꞌiꞌ wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Xebꞌel kꞌu bꞌi ri Pedro y ri jun chik tijoꞌn, y xebꞌek pa xmuqiꞌ wi ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Kikabꞌichal kekꞌalalik xebꞌek; pero ri jun chik tijoꞌn más xkꞌalal chwa ri Pedro y nabꞌe xoponik. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Xyuxiꞌ pan chupa ri muqubꞌal y xew xril ri jutaq rabꞌaꞌj kꞌul pa xbꞌolqꞌotix wi ri Jesús, pero na xok tubꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Tekꞌuchiriꞌ xopon ri Simón Pedro, ri teran lo chirij. Ekꞌu rire asu xok chupa ri muqubꞌal y xril ri jutaq rabꞌaꞌj kꞌul kꞌo kan chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Yey ri kꞌul pa xpis wi rujolom ri Jesús, na junam ta kꞌo rukꞌ ri jutaq rabꞌaꞌj kꞌul; ma utukel kꞌolik, bꞌusum kanoq. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Ekꞌuchiriꞌ, xok bꞌi ri jun chik tijoꞌn ri xopon nabꞌe chwach ri muqubꞌal. Xew xril kꞌu riꞌ waꞌ, xukojo kꞌastajinaq chubꞌi ri Jesús chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma ri petinaq loq rike kꞌamajaꞌ ne kimajom usukꞌ Ruchꞌaꞌtem ri Dios pa kubꞌiꞌij wi: Ri Jesús lik chirajawaxik kakꞌastaj bꞌi chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Y xetzelej kꞌu ri kebꞌ tijoꞌn pa e kꞌo wi ri kachbꞌiꞌil. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Pero ri María koqꞌik takꞌal kan chunaqaj ri muqubꞌal. Ekꞌu laꞌ koqꞌik, xyuxiꞌ apanoq y xtzuꞌn pan chupa ri muqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Xeril kꞌu pan kebꞌ ángeles saq kiqꞌuꞌ etzꞌul jun chujolom y jun chi raqan che ri luwar pa xyaꞌiꞌ wi rucuerpo ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Ekꞌu ri ángeles xkitzꞌonoj che ri María: —Ixoq, ¿suꞌchak katoqꞌik? —xechaꞌ. Ri María xukꞌul uwach: —Ma xkꞌam bꞌi ri Wajawal y na wetaꞌam taj pa xyaꞌiꞌ wi —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Tekꞌuchiriꞌ, xtzuꞌn chirij. Kꞌate xrilo takꞌal ri Jesús chiriꞌ, pero rire na xretaꞌmaj taj we e ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ekꞌu ri Jesús xutzꞌonoj che ri María: —Ixoq, ¿suꞌchak katoqꞌik? ¿China ri katzukuj? —xchaꞌ. Ri María xuchꞌobꞌo wa jun achi laj e chajinel re ri werta, y jewaꞌ kꞌu xubꞌiꞌij che: —Achi, we lal xkꞌamaw bꞌi la re, bꞌiꞌij la chwe pa xeꞌyaꞌa wi la chaꞌ kiꞌnkꞌamaꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ekꞌu ri Jesús xubꞌiꞌij che: —¡María! —xchaꞌ. Ri María xutzuꞌ uwach y jewaꞌ xubꞌiꞌij che: —¡Raboni! (Wa chꞌaꞌtem pa hebreo keꞌelawi: “Lal tijonel”.) ");
INSERT INTO acrNNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Ri Jesús xubꞌiꞌij che: —Chinatzoqopij, ma kꞌamajaꞌ kinaqꞌan rukꞌ ri Nuqaw. Jat y chabꞌiꞌij chike konoje ri nu hermanos: Riꞌin kinaqꞌan pa kꞌo wi ri Nuqaw yey Iqaw riꞌix; ri nu Dios riꞌin yey i Dios riꞌix —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Xeꞌek kꞌu ri María ri aj Magdala kukꞌ rutijoꞌn ri Jesús y xuꞌtzijoj chike xril uwach ri Qanimajawal. Yey xutzijoj chike janipa ri xbꞌiꞌx bꞌi che ruma ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Che kꞌu ri rokbꞌal raqꞌabꞌ che ri nabꞌe qꞌij re ri semana, rutijoꞌn ri Jesús kimolom kibꞌ, kitzꞌapim kichiꞌ ruma kixiꞌim kibꞌ chikiwach ri e aj wach ke raj judiꞌabꞌ. Ekꞌuchiriꞌ, ri Jesús xaqikꞌateꞌt xwinaqirik y xtakꞌiꞌ chikixoꞌl rutijoꞌn. Xuya kꞌu rutzil kiwach, jewaꞌ xubꞌiꞌij chike: —Kꞌola utzil chomal iwukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Tekꞌuchiriꞌ, xukꞌut ruqꞌabꞌ y rukꞌalkꞌaꞌx chikiwach. Ekꞌu rike lik xekiꞌkotik echiriꞌ xkil uwach ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ekꞌu ri Jesús xubꞌiꞌij tanchi chike: —Kꞌola utzil chomal iwukꞌ. Jelaꞌ pachaꞌ ri Nuqaw xinutaq lo riꞌin, jekꞌuriꞌlaꞌ riꞌin kixintaq bꞌi riꞌix —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Ekꞌuchiriꞌ, xuxutꞌuj kiwiꞌ y xubꞌiꞌij chike: —Chikꞌulu ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","We kꞌo junoq kutzelej utzij chwach ri Dios, yaꞌtal piqꞌabꞌ kiqꞌalajisaj che: “Ri Dios ukuyum chi amak.” Yey we kꞌo junoq na kutzelej ta utzij chwach ri Dios, yaꞌtal piqꞌabꞌ kiqꞌalajisaj che: “At tanal rukꞌ ramak chwach ri Dios” —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ri Tomás ri kabꞌiꞌx “yoꞌx” che, e jun chike ri kabꞌlajuj utijoꞌn ri Jesús. Rire na jintaj echiriꞌ xopon ri Jesús kukꞌ rike. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Ekꞌu ri jujun chik tijoꞌn echiriꞌ xkil uwach ri Tomás, jewaꞌ xkibꞌiꞌij che: —¡Riꞌoj xqil uwach ri Qanimajawal! —xechaꞌ. Pero ri Tomás jewaꞌ xubꞌiꞌij chike: —Riꞌin xew kankojo we nabꞌe na kanwil rutel ri klawux puqꞌabꞌ y kanjuꞌ ruwi nuqꞌabꞌ chupa yey kanjuꞌ ri nuqꞌabꞌ pukꞌalkꞌaꞌx. Noꞌj we na kanꞌan ta waꞌ, riꞌ na kankoj taj —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ikꞌowinaq chi kꞌu wajxaqibꞌ qꞌij, ri tijoꞌn kimolom tanchi kibꞌ chupa ri ja y kꞌo ri Tomás kukꞌ. Tobꞌ kitzꞌapim kꞌu kichiꞌ, ri Jesús xaqikꞌateꞌt xwinaqirik y xtakꞌiꞌ chikixoꞌl. Ewi xuya rutzil kiwach, jewaꞌ xubꞌiꞌij: —Kꞌola utzil chomal iwukꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Tekꞌuchiriꞌ, xubꞌiꞌij che ri Tomás: —Chawila ri nuqꞌabꞌ y chajuꞌu ruwi aqꞌabꞌ wara, yey chajuꞌu pe lo laꞌqꞌabꞌ pa wa nukꞌalkꞌaꞌx. Muꞌan kꞌu ri xa kebꞌ akꞌuꞌx wukꞌ; e chakojoꞌ riꞌin in kꞌaslik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Ekꞌuchiriꞌ, ri Tomás xubꞌiꞌij che ri Jesús: —¡Lal Wajawal y Lal nu Dios! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Yey ri Jesús xubꞌiꞌij che: —Tomás, kꞌa e laꞌ xakojo ruma xawil na nuwach. Nim kꞌu kiqꞌij kalaxik ri na kilom ta nuwach yey na rukꞌ ta kꞌu riꞌ, kakikojo riꞌin in kꞌaslik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Ri Jesús xuꞌan ukꞌiyal kꞌutubꞌal re ruchuqꞌabꞌ ri Dios chikiwach rutijoꞌn, y waꞌ na ronoje taj tzꞌibꞌital chupa wa libro. ");
INSERT INTO acrNNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Pero janipa kꞌu wa xtzꞌibꞌaxik, e chaꞌ kakoj alaq ri Jesús e ri Cristo, Rukꞌajol ri Dios, y kꞌo kꞌu kꞌaslemal alaq riꞌ ruma kakoj alaq rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Tekꞌuchiriꞌ ri Jesús xukꞌut tanchi ribꞌ chikiwach rutijoꞌn chuchiꞌ ri mar re Tiberias. Jewaꞌ xuꞌano: ");
INSERT INTO acrNNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Junam e kꞌo ri Simón Pedro, ri Tomás ri kakibꞌiꞌij “Yoꞌx” che, ri Natanael ri aj Caná re Galilea, ri kebꞌ ukꞌajol ri Zebedeo y kaꞌibꞌ chik chike rutijoꞌn ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Ekꞌu ri Simón Pedro xubꞌiꞌij chike: —Kinꞌek pa chapoj kar —xchaꞌ. Rike xkibꞌiꞌij che: —Kojꞌek riꞌ awukꞌ —xechaꞌ. Xebꞌek kꞌut y xebꞌok bꞌi chupa jun barco, pero laꞌ laꞌqꞌabꞌ wi na jinta kꞌana kar xkichapo. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Echiriꞌ katajin usaqirik, rutijoꞌn xkil jun achi takꞌal chuchiꞌ ri mar, pero na xketaꞌmaj taj we e ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Xubꞌiꞌij kꞌu ri Jesús chike: —Ix walkꞌoꞌal, ¿na jinta kar ichapom? —xchaꞌ. Rike xkikꞌul pan uwach: —Na jintaj —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Xubꞌiꞌij kꞌu ri Jesús chike: —Chilikꞌij liꞌatarraya puwikiqꞌabꞌ ri barco y chiwilapeꞌ ma kebꞌiwesaj lo kar —xchaꞌ. Rike e xkiꞌano yey na kakichꞌij ta chi kꞌu lo resaxik riꞌ ri ki atarraya pa ri yaꞌ ruma rukꞌiyal kar e kꞌo chupa. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Ekꞌu ri jun tijoꞌn lik kꞌax kanaꞌ ruma ri Jesús, xubꞌiꞌij che ri Pedro: —¡E Qanimajawal! —xchaꞌ. Ri Simón Pedro xew xuto e ri Jesús, xukojolaꞌ ruqꞌuꞌ resam y xukꞌaq bꞌi ribꞌ pa ri yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Yey ri jujun chik tijoꞌn xekꞌun rukꞌ ri barco chuchiꞌ ri mar, kicharem ri ki atarraya nojinaq che kar, ma laj xa cien metros e kꞌo wi che ruchiꞌ ri yaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Echiriꞌ xeqaj lo chuꞌlew, kꞌate xkilo nukꞌutal jun aqꞌ, y puwi ri rachaqꞌaꞌl kꞌo jun kar y kꞌo pam chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Xubꞌiꞌij kꞌu ri Jesús chike: —Chikꞌama lo jujun chike ri kar, ri kꞌa e laꞌ xebꞌichap loq —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Ri Simón Pedro xok pa ri barco y xucharej bꞌi kꞌa chuchiꞌ ri mar ri atarraya nojinaq che nimaq taq kar, ma e ciento cincuenta y tres ri kar e kꞌo chupa. Tobꞌ lik e kꞌi ri kar, na xraqaroꞌbꞌ ta ri atarraya. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Ekꞌuchiriꞌ, xubꞌiꞌij ri Jesús: —Chixpetoq, chixwoꞌqoq —xcha chike. Na jinta kꞌu junoq chike rutijoꞌn xraj kutzꞌonoj che china Rire, ma ketaꞌam e ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ekꞌuchiriꞌ, ri Jesús xukꞌam ri pam y xuya chike, y jelaꞌ xuꞌan rukꞌ ri kar. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","E urox laj waꞌ xukꞌut uwach ri Jesús chikiwach rutijoꞌn chwi lo rukꞌastajibꞌal chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Echiriꞌ xkikꞌis utijik ri kiwa, ri Jesús xutzꞌonoj che ri Simón Pedro: —Simón, at ukꞌajol ri Jonás, ¿más nawi kꞌax kinanaꞌ riꞌat chwa ri kꞌaxnaꞌbꞌal we kakiꞌan wa jujun chik? —xchaꞌ. Ri Pedro xukꞌul uwach: —Wajawal, rilal etaꞌam la kꞌo rutzil nukꞌuꞌx cheꞌla —xchaꞌ. Ri Jesús xubꞌiꞌij che: —Chebꞌatzuqu kꞌu riꞌ ri raltaq ko nubꞌexex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Xutzꞌonoj chukalaj: —Simón, at ukꞌajol ri Jonás, ¿lik kꞌax kinanaꞌ rukꞌ ronoje akꞌuꞌx? —xchaꞌ. Ri Pedro xukꞌul uwach: —Wajawal, rilal etaꞌam la kꞌo rutzil nukꞌuꞌx cheꞌla —xchaꞌ. Xubꞌiꞌij tanchi kꞌu ri Jesús che: —Chebꞌachajij kꞌu riꞌ ri nubꞌexex —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Xutzꞌonoj churox laj: —Simón, at ukꞌajol ri Jonás, ¿qatzij kꞌo rutzil akꞌuꞌx chwe? —xchaꞌ. Ri Pedro lik xuchap bꞌis ruma e urox laj riꞌ xtzꞌonox che. Xubꞌiꞌij kꞌu riꞌ: —Wajawal, rilal etaꞌam la ronoje, etaꞌam kꞌu la riꞌin kꞌo rutzil nukꞌuꞌx cheꞌla —xcha che. Xubꞌiꞌij kꞌu ri Jesús che: —Chebꞌatzuqu kꞌu riꞌ ri nubꞌexex. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Paqatzij wi kambꞌiꞌij chawe: Echiriꞌ at ala, riꞌat atukel kaxim rapas y kateꞌek pa kawaj wi kateꞌek. Noꞌj echiriꞌ katuꞌana nimalaj winaq, kayak laꞌqꞌabꞌ y jun chik kaximow rapas y katukꞌam bꞌi pa na kawaj ta wi kateꞌek —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ri Jesús xubꞌiꞌij waꞌ chaꞌ kuqꞌalajisaj saꞌ rukamik ri Pedro kaꞌanik re yakbꞌal uqꞌij ri Dios. Tekꞌuchiriꞌ, xubꞌiꞌij che: —¡Chat-tereja lo chwij! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Echiriꞌ xtzuꞌn ri Pedro chirij, xrilo chikij teran lo ri jun tijoꞌn lik kꞌax kanaꞌ ruma ri Jesús, waꞌ e ri xjaꞌiꞌ putzal ri Jesús pa ri jun waꞌim echiriꞌ xutzꞌonoj che: «Wajawal, ¿China ri kakꞌayin e la?» ");
INSERT INTO acrNNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Ekꞌu ri Pedro echiriꞌ xril ri jun chik tijoꞌn, xutzꞌonoj che ri Jesús: —Wajawal, yey rire, ¿saꞌ ri kukꞌulumaj? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Ri Jesús xukꞌul uwach: —¿Suꞌchak katzꞌonoj? We kuaj riꞌin kꞌa kꞌas rire echiriꞌ kinkꞌun tanchik, na jinta awe che. Riꞌat chat-tereja lo chwij —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Ruma kꞌu wa xubꞌiꞌij ri Jesús, xeꞌek utzijoxik chikixoꞌl ri kikojom rubꞌiꞌ ri Cristo: «Laꞌ la jun utijoꞌn na kakam taj.» Pero ri Jesús na xubꞌiꞌij ta che we na kakam taj, ma xew xubꞌiꞌij waꞌ: «¿Suꞌchak katzꞌonoj? We kuaj riꞌin kꞌa kꞌas rire echiriꞌ kinkꞌun tanchik, na jinta awe che.» ");
INSERT INTO acrNNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ekꞌu waꞌ wa jun tijoꞌn e ri kajikibꞌan uwach taq waꞌ y e xtzꞌibꞌan waꞌ. Yey riꞌoj qetaꞌam kꞌut lik qatzij ronoje wa tzꞌibꞌitalik. ");
INSERT INTO acrNNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Lik kꞌo ukꞌiyal chak xuꞌan ri Jesús tobꞌ na ronoje ta waꞌ tzꞌibꞌital kan chupa wa libro. Yey we ta e laꞌ katzꞌibꞌax ronoje taq ri xuꞌano, riꞌin kanchꞌobꞌ raqan na kok tane che ruwachulew taq ri wuj pa katzꞌibꞌax wi. Amén. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Chupa ri nabꞌe nulibro, xintzꞌibꞌaj pan che rilal Teófilo, puwi taq ri xuꞌan ri Jesús y taq ri xukꞌutu chwi lo ri jeqebꞌal re ruchak ");
INSERT INTO acrNNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kꞌa chupa ri qꞌij echiriꞌ xkꞌul chilaꞌ chikaj ruma ri Dios. Chwach kꞌu pan riꞌ rubꞌenam chilaꞌ chikaj, Rire ruma ri Santowilaj Ruxlabꞌixel ri Dios xuya kan taqanik chike rutaqoꞌn ebꞌuchaꞌom puwi taq ri chirajawaxik kakiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Chwi kꞌu rukamik, xkꞌastaj lo chikixoꞌl ri ekaminaq y kꞌa xkꞌojiꞌ cuarenta qꞌij che ruwachulew. Chupa taq kꞌu laꞌ la qꞌij, ukꞌiyal laj e laꞌ xukꞌut uwach chikiwach rutaqoꞌn y xchꞌaꞌt kukꞌ puwi ri taqanik re ri Dios. Jekꞌulaꞌ riꞌ, lik xukꞌutu paqatzij wi Rire kꞌaslik. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Echiriꞌ ri Jesús e laꞌ kꞌa kꞌo kukꞌ rutaqoꞌn, xubꞌiꞌij chike: —Chixkꞌola Jerusalem chaꞌ kiwoyꞌej rubꞌiꞌtisinik ri Nuqaw, ri nutzijom chi lo riꞌin chiwe; waꞌ e ri bautismo re ri Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Paqatzij wi ri Juan xuya ri bautismo rukꞌ yaꞌ; noꞌj ri bautismo kikꞌul riꞌix e rukꞌ ri Santowilaj Ruxlabꞌixel ri Dios; yey waꞌ kuꞌana xa chupa taq waꞌ wa qꞌij katajin loq —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Jun qꞌij kꞌut ri kimolom kibꞌ rukꞌ ri Jesús jewaꞌ xkitzꞌonoj che: —Qajawal, ¿chupa taq waꞌ wa qꞌij oj kꞌo wi, kayak tanchi nawi la ri taqanik re ri qatinamit Israel jelaꞌ pachaꞌ ri uꞌanom lo ojertan? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Y ri Jesús xukꞌul uwach: —Riꞌix na yaꞌtal ta chiwe kiwetaꞌmaj ruqꞌijol y ruꞌorayil echiriꞌ kuꞌana taq waꞌ ri Nuqaw, ma ronoje waꞌ xew puqꞌabꞌ Rire kꞌo wi. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Pero kikꞌul kꞌu ichuqꞌabꞌ riꞌix echiriꞌ kaqaj lo ri Santowilaj Ruxlabꞌixel ri Dios piwiꞌ y kixuꞌana kꞌu ix tzijol weꞌin chupa wa tinamit Jerusalem, chupa ronoje ri luwar re Judea y re Samaria y kꞌa che ronoje luwar re ruwachulew —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Ekꞌuchiriꞌ xukꞌis ubꞌiꞌxikil taq waꞌ, xkꞌam bꞌi chilaꞌ chikaj; y ekꞌu laꞌ kakitzutzaꞌ rutijoꞌn xsach bꞌi chikiwach chupa jun sutzꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Kꞌa kakitzutzaꞌ kꞌu pan chilaꞌ chikaj pa xkꞌam wubꞌi ri Jesús, echiriꞌ xewinaqir kebꞌ achijabꞌ kukꞌ yey waꞌ lik saq ri kiqꞌuꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Waꞌchijabꞌ xechꞌaw kꞌu chike, jewaꞌ xkibꞌiꞌij: —Achijabꞌ ix aj Galilea, ¿suꞌbꞌe kꞌa kixtzutzuꞌn chikaj? Ma wa Jesús, ri xel bꞌi chixoꞌl riꞌix y xkꞌul chilaꞌ chikaj, Rire kakꞌun tanchik. Jekꞌulaꞌ pachaꞌ xiwilo xeꞌek, jelaꞌ kakꞌun tanchik —xecha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ekꞌuchiriꞌ, ri e taqoꞌn xebꞌel bꞌi chwach ri juyubꞌ Olivos y xetzelej Jerusalem. (Wa juyubꞌ xa naqaj kꞌo wi lo che Jerusalem, laj jun kilómetro unajtijil; jekꞌulaꞌ rike na xikꞌow ta uwiꞌ ri kakibꞌinibꞌej che ri yaꞌtalik e chirij ri kojobꞌal ke raj judiꞌabꞌ puwi ri qꞌij re uxlanibꞌal.) ");
INSERT INTO acrNNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Echiriꞌ xebꞌopon Jerusalem, xebꞌaqꞌan chikaj pa ri kaleꞌ ja pa ejeqel wi ri Pedro, ri Jacobo, ri Juan, ri Andrés, ri Felipe, ri Tomás, ri Bartolomé, ri Mateo, ri Jacobo rukꞌajol ri Alfeo; ri Simón ri kabꞌiꞌx “ri Zelote” che y ri Judas ruchaqꞌ ri Jacobo. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","E konoje rike lik xa jun kikꞌuꞌx kiyaꞌom kibꞌ pa oración, junam kukꞌ jujun ixoqibꞌ, rukꞌ ri María ruchu ri Jesús yey kukꞌ taq ruchaqꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Chupa kꞌu taq laꞌ la qꞌij, ri Pedro xtakꞌiꞌ chikiwach ri hermanos kimolom kibꞌ, laj e ciento veinte chi konoje, y jekꞌuwaꞌ xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","«Hermanos, lik chirajawaxik wi e kuꞌana na ri tzꞌibꞌital kan chupa Ruchꞌaꞌtem ri Dios puwi ri xubꞌiꞌij ri Santowilaj Ruxlabꞌixel ruma ri David echiriꞌ xchꞌaꞌt puwi ri Judas aj Iscariot. Waꞌ e ri xnabꞌej chikiwach ri xechapaw bꞌi ri Jesús, ");
INSERT INTO acrNNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","tobꞌ rire e jun qachbꞌiꞌil y xyaꞌ che xchakun junam qukꞌ chupa wa chak re ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Xloqꞌ kꞌu juchꞌaqap ulew rukꞌ ri puaq xyaꞌ che ri Judas ruma ri na jusukꞌ taj xuꞌano echiriꞌ xukꞌayij ri Jesús. Ekꞌu ri Judas xuꞌxulubꞌaꞌ lo ribꞌ chwi jun cheꞌ y echiriꞌ xtzaq loq, xraqaroꞌbꞌ rupa y ronoje ri rixkolobꞌ xkich kaꞌnik. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Waꞌ xketaꞌmaj konoje ri ejeqel Jerusalem. E uwariꞌche, xkikoj “Acéldama” che wa jun luwar; waꞌ keꞌelawi “Luwar re Kikꞌ” pa ri kichꞌaꞌtem rike.) ");
INSERT INTO acrNNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Xubꞌiꞌij kꞌu ri Pedro: «Jekꞌuwaꞌ tzꞌibꞌital kan puwi ri Judas chupa ri libro re ri Salmos: Ri luwar pa jeqel wi chuꞌana jun luwar katzꞌintzꞌotik, y na jinta junoq kajeqiꞌ chiriꞌ. Y jewaꞌ kubꞌiꞌij tanchik: Lik chirajawaxik katzukux jun chik aj chak chaꞌ kakꞌojiꞌ pukꞌaxel kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","»E kꞌo kꞌu jujun achijabꞌ chiqaxoꞌl xex ojkachbꞌilam echiriꞌ kꞌa kꞌo ri Jesús qukꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","chwi lo echiriꞌ xukꞌul ri bautismo ruma ri Juan y kꞌa echiriꞌ xel bꞌi qukꞌ y xkꞌul chilaꞌ chikaj ruma ri Dios. Lik chirajawaxik kꞌut kaqakoj junoq chike waꞌ waꞌchijabꞌ chaꞌ junam kojtzijon puwi rukꞌastajibꞌal ri Jesús» xcha ri Pedro chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Xekichaꞌ kꞌu kaꞌibꞌ achijabꞌ. Jun e ri José, ri kabꞌiꞌx Barsabás che y kojom jun retzelal ubꞌiꞌ “Justo” kecha che. Ri jun chik, Matías rubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Y xkiꞌan orar, jewaꞌ xkibꞌiꞌij: «Qajawal, Rilal etaꞌam la ri kikꞌuꞌx konoje ri tikawex. Kꞌutu kꞌu la chiqawach chinoq chike wa kaꞌibꞌ achijabꞌ chaꞌom la ");
INSERT INTO acrNNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","chaꞌ kukꞌam bꞌi wa chak y kaꞌan taqoꞌn la che; jekꞌulaꞌ kakꞌojiꞌ pukꞌaxel ri Judas aj Iscariot, ri xroqꞌotaj kan ri chak xyaꞌ che y xeꞌek kꞌu pa ri luwar taqal che» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ekꞌuchiriꞌ, xkiꞌan jun sorteo chaꞌ kaqꞌalajinik china chike wa kaꞌibꞌ kakanaj kan pukꞌaxel ri Judas; y waꞌ xtzaq puwi ri Matías. Chwi kꞌu riꞌ, rire xuꞌana e jun kukꞌ ri junlajuj chik e taqoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Echiriꞌ xopon ri nimaqꞌij re Pentecostés e taq rutijoꞌn ri Jesús kimolom kibꞌ, konoje uꞌanom xa jun kikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xaqikꞌateꞌt kꞌut chilaꞌ chikaj xpe pachaꞌ uchꞌawibꞌal juna unimal tew lik kajuxuxik, yey waꞌ xunojisaj ronoje upa ri ja pa kimolom wi kibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ekꞌuchiriꞌ, xewinaqir pachaꞌ urepebꞌal aqꞌ y waꞌ xkꞌojiꞌ pakiwiꞌ chikijujunal rike. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Yey konoje ri e kꞌo chiriꞌ xkikꞌul ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel, y xkijeq kꞌu riꞌ kechꞌaꞌt pa jujun chik chꞌaꞌtem junwi. Chikijujunal kechꞌaꞌt pa ri chꞌaꞌtem xyaꞌtaj chike ruma ri Ruxlabꞌixel. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Chiriꞌ kꞌut Jerusalem e kꞌo e aj judiꞌabꞌ lik kakiloqꞌnimaj uqꞌij ri Dios. Rike e petinaq pa taq ukꞌiyal tinamit che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Echiriꞌ xkita waꞌ wa chꞌawibꞌal, xepe che rilik. Yey lik xsach kinaꞌoj ma chikijujunal xekito kechꞌaꞌt pa taq ri kichꞌaꞌtem ke rike. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ekꞌu laꞌ lik kaminaq kanimaꞌ che, xkijeq kakibꞌiꞌij chikiwach: «¡Chilape alaq! ¿Na e ta nebꞌa aj Galilea konoje wa kechꞌaꞌtik? ");
INSERT INTO acrNNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Chaꞌta kꞌu riꞌ chiqajujunal keqato kechꞌaꞌt pa taq ri qachꞌaꞌtem oj alaxinaq wi riꞌoj? ");
INSERT INTO acrNNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Yey lik pa ukꞌiyal tinamit oj petinaq wi. Chiqaxoꞌl e kꞌo e aj Partia, e aj Media y e aj Elam. Yey e kꞌo ri ejeqel Mesopotamia, Judea, Capadocia, Ponto y Asia, ");
INSERT INTO acrNNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigia y Panfilia, Egipto y pa taq ri luwar re Libia chwach pana ri tinamit Cirene. Yey e kꞌo ri e petinaq Roma; chikixoꞌl waꞌ e kꞌo e aj judiꞌabꞌ y e kꞌo ne ri na e ta aj judiꞌabꞌ kitaqem lo ri kꞌutunik ke raj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","E kꞌo e aj Creta y ri e aj Arabia. Yey chiqajujunal riꞌoj kaqato kechꞌaꞌt pa qachꞌaꞌtem puwi taq ri kꞌutubꞌal re runimal uchuqꞌabꞌ ri Dios» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Konoje kꞌut lik kaminaq kanimaꞌ che y na kakiriq ta chik saꞌ ri kakichꞌobꞌ puwiꞌ, jekꞌuwaꞌ kakibꞌiꞌij chikiwach: «¿Saꞌ keꞌelawi waꞌ?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Yey e kꞌo kꞌu jujun chik kechꞌamin ke y jewaꞌ kakibꞌiꞌij: «Laꞌ keqꞌabꞌarik» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ekꞌuchiriꞌ, ri Pedro xtakꞌiꞌik junam kukꞌ ri junlaluj chik taqoꞌn y lik ko xchꞌawik, jewaꞌ xubꞌiꞌij: «Achijabꞌ alaq aj judiꞌabꞌ y onoje ri alaq jeqel wara Jerusalem, tape alaq chi utz ri kanqꞌalajisaj che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ma e chiwach ralaq, waꞌ waꞌchijabꞌ keqꞌabꞌarik, noꞌj ¡na e ta uꞌanom riꞌ! Ma kꞌa e ne bꞌelejebꞌ ora laꞌ che wa anim. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Janipa wa kata alaq y kil alaq woꞌora, waꞌ e ri ubꞌiꞌim chi kan ri qꞌalajisanel Joel ojertan, echiriꞌ jewaꞌ xubꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","“Che taq rukꞌisbꞌal qꞌij” kubꞌiꞌij ri Dios, “kantaq bꞌi ri Wuxlabꞌixel pakiwi konoje ri tikawex che ruwachulew. E taq kꞌu ri miꞌal alkꞌoꞌal alaq kakiqꞌalajisaj ri Nutzij. Ralabꞌo kakilo janipa ri kankꞌut chikiwach; yey e ri nimaq winaq, pa wachikꞌ kakil wi janipa ri kanqꞌalajisaj chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Chupa taq kꞌu riꞌ laꞌ la qꞌij, pakiwi ri e waj chak ixoqibꞌ y achijabꞌ kantaq bꞌi ri Wuxlabꞌixel chaꞌ jelaꞌ kakiqꞌalajisaj ri Nutzij chikiwach ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Chwa ri kaj kankꞌut taq kꞌutubꞌal re nuchuqꞌabꞌ yey waꞌ na jinta ilitajinaq wi y che ruwachulew kanꞌan kꞌutubꞌal rukꞌ kikꞌ, rukꞌ aqꞌ y rukꞌ mayul re sibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ekꞌu ri qꞌij kuꞌan qꞌequꞌm uwach yey ri ikꞌ kuꞌan kaq uwach pachaꞌ kikꞌ; waꞌ e kuꞌana echiriꞌ ya kopon ruqꞌijol ri Qanimajawal. Waꞌ wa jun qꞌij lik nim y na jinta kꞌo kajunimax wi ruchomalil. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Y konoje kꞌu ri kakikoj kibꞌ chwach ri Qanimajawal re kebꞌukolobꞌej, riꞌ kekolobꞌetajik” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","»Achijabꞌ alaq aj Israel, tape alaq janipa wa kambꞌiꞌij che alaq woꞌora: Ri Jesús ri aj Nazaret, Rire e ri Jun taqom lo chixoꞌl alaq ruma ri Dios. Lik etaꞌam kꞌu alaq ri xuꞌan ri Dios ruma ri Jesús chixoꞌl alaq, waꞌ e ukꞌiyal milagros y taq kꞌutubꞌal re ri unimal uchuqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Yey ri Dios lik uchꞌobꞌom chi uloq y retaꞌam suꞌchak xuya ri Jesús paqꞌabꞌ alaq. Ekꞌu ralaq xchap bꞌi alaq y xtaq alaq ukamisaxik chwa cruz kuma winaq na jinta Rutzij Upixabꞌ ri Dios kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Pero ri Dios xukꞌastajisaj loq y xresaj chupa rukꞌaxkꞌolil ri kamik, ma ri kamik na jinta uchuqꞌabꞌ puwi Rire y ruma riꞌ, Rire na xkꞌojiꞌ ta puqꞌabꞌ ri kamik. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","»Rojertan xubꞌiꞌij kan ri rey David puwi ri Cristo: Riꞌin kanwil ri Wajawal xaqi e laꞌ kꞌo chinuwach. Ruma kꞌu kꞌo Rire pa nuwikiqꞌabꞌ, na jinta kꞌana kayuchꞌuyuꞌn weꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","E uwariꞌche ri wanimaꞌ lik xkiꞌkotik y ruchiꞌ nuqul xbꞌixon rukꞌ kiꞌkotemal. Ekꞌu riꞌin, tobꞌ ne wetaꞌam kinkamik, e laꞌ kꞌo chi ri nukubꞌam pan nukꞌuꞌx che; ");
INSERT INTO acrNNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ma Rilal na kinya ta kan la chikixoꞌl ri ekaminaq, yey na kaya tane la luwar kaqꞌay rucuerpo ri aj chak la, ri jun lik uyaꞌom ribꞌ paqꞌabꞌ la. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Rilal xkꞌut la chinuwach ri bꞌe re kꞌaslemal. Ruma kꞌu xaqi Lal kꞌo la wukꞌ riꞌin, kanojisaj la ri wanimaꞌ che kiꞌkotemal xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","»Hermanos, paqatzij wi lik usukꞌ kankuxtaj waꞌ che alaq: Ri rey David ojertan, xkamik y xmuqik, y kꞌa qꞌalaj ne chiqawach riꞌoj waqꞌij ora pa kꞌo wi rumuqubꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Yey ri rey David e jun qꞌalajisanel; xretaꞌmaj kꞌu riꞌ ri Dios rukꞌ jun tzij xujikibꞌaꞌ uwach che rire: “Chikixoꞌl taq ri awalkꞌoꞌal, kayaktaj lo ri Cristo chaꞌ kuꞌan Rey y katzꞌuyiꞌ pakꞌaxel riꞌat.” ");
INSERT INTO acrNNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","»Yey ri rey David xchꞌaꞌtik e pachaꞌ rilom chi rukꞌastajibꞌal ri Cristo echiriꞌ xubꞌiꞌij: “Na kakanaj ta kan Rire chikixoꞌl ri ekaminaq y na kaqꞌay tane rucuerpo.” ");
INSERT INTO acrNNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ekꞌu waꞌ wa Jesús ri xukꞌastajisaj ri Dios che ri kamik; yey waꞌ lik qatzij, ma qonoje riꞌoj xqilo. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Lik kꞌu xyak uqꞌij echiriꞌ xtzꞌuyiꞌ puwikiqꞌabꞌ ri Dios. Yey xyaꞌtaj che Rire kutaq lo paqawi riꞌoj ri Santowilaj Ruxlabꞌixel, ri ubꞌiꞌtisim lo ri Qaqaw Dios chiqe riꞌoj. Y ekꞌu riꞌ waꞌ ri kil alaq y kata alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","»Ma na e ta ri David ri xaqꞌan chilaꞌ chikaj, pero e rire ri xubꞌiꞌij: Ri Dios Qajawxel xubꞌiꞌij che ri Wajawal: “Chat-tzꞌula pa nuwikiqꞌabꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","y chawoyeꞌej na ri qꞌij echiriꞌ kebꞌenuya ri tzel kebꞌilow awe chuxeꞌ rawaqan” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","»Tape alaq onoje ri alaq aj Israel, ma lik chirajawaxik ketaꞌmaj kꞌu alaq: Wa Jesús ri xkamisaj alaq chwa cruz, e chaꞌtal lo ruma ri Dios re kuꞌan Qajawal y Kolobꞌenel» xcha ri Pedro chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ekꞌuchiriꞌ xkita waꞌ, lik xok bꞌis chikikꞌuꞌx y jewaꞌ xkibꞌiꞌij che ri Pedro y chike ri jujun chik e taqoꞌn: —Hermanos, ¿saꞌ kꞌu riꞌ kaqaꞌan riꞌoj? —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Y ri Pedro xubꞌiꞌij chike: —Tzelej tzij alaq chwach ri Dios y chijujunal alaq kꞌulu alaq pa rubꞌiꞌ ri Qanimajawal Jesucristo ri bautismo re kuybꞌal mak alaq y jelaꞌ kakꞌul na kꞌu alaq ri Santowilaj Uxlabꞌixel, waꞌ e sipanik re ri Dios che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ma ri Dios ubꞌiꞌtisim waꞌ chike konoje janipa ri kebꞌusikꞌij: che ralaq, chike taq ri alkꞌoꞌal alaq y chike ne konoje ri ejeqel lik naj che ri tinamit re Israel —xcha ri Pedro chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Jekꞌulaꞌ, xebꞌupixabꞌaj rukꞌ ukꞌiyal chꞌaꞌtem y jewaꞌ xujikibꞌaꞌ uwach chike: —Chesaj lo ibꞌ alaq chikixoꞌl waꞌ wa winaq lik na jusukꞌ ta ri kiꞌanom, chaꞌ jelaꞌ kakolobꞌetaj alaq chwach ri qꞌatbꞌal tzij kape pakiwiꞌ —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Janipa kꞌu riꞌ ri xekojow Rutzij ri Dios ruma ri xubꞌiꞌij ri Pedro, xkikꞌul ri bautismo. Yey chupa kꞌu laꞌ la jun qꞌij, laj e oxibꞌ mil ri xkikoj rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Y konoje lik junam kebꞌin chupa ri saqil kꞌutunik ke ri e taqoꞌn re ri Jesús, junam kikꞌuꞌx, junam kewaꞌ chikiwach y junam kakiꞌan orar. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Konoje kꞌu ri tikawex xok xiꞌin ibꞌ pa kanimaꞌ ruma taq ri milagros y kꞌutubꞌal kuꞌan ri Dios kuma ri e utaqoꞌn ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Konoje kꞌu ri xekojow rubꞌiꞌ ri Cristo, lik xuꞌan xa jun kikꞌuꞌx chikiwach y rubꞌitaq ke chikijujunal xuꞌan re chinima ronoje. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","E kꞌo ri xkikꞌayij kulew y ubꞌitaq ke, yey ekꞌu ri rajil waꞌ, kakijach chikiwach e chirij taq ri kajawax wi chike chikijujunal. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ronoje qꞌij kakimol kibꞌ chupa ri Rocho Dios. Yey pa taq ri kocho kakijach chikiwach ri kakitijo, junam kewaꞌ rukꞌ kiꞌkotemal y rukꞌ uchꞌutiꞌnal kikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Kakiyak kꞌu uqꞌij ri Dios y lik chom ri kichꞌaꞌtibꞌexik kaꞌan kuma konoje ri tikawex re ri tinamit. Yey ronoje qꞌij e kꞌo más tikawex katajin kikolobꞌetajik ruma ri Qanimajawal, y jelaꞌ xkꞌiyar riglesia. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Xuꞌana kꞌu chupa jun qꞌij, ri Pedro y ri Juan junam xebꞌek pa ri Rocho Dios che ri urox ora bꞌenaq qꞌij, ma e ora riꞌ re oración. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Ronoje qꞌij kꞌut kakꞌam lo jun achi ralaxibꞌem sik y kayaꞌ chwach ri Rocho Dios pa ri okibꞌal kabꞌiꞌx che “Lik Chom” chaꞌ kutzꞌonoj ulimoxna chike ri winaq kebꞌok bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ekꞌu rachi sik, echiriꞌ xeril ri Pedro y ri Juan e riꞌ kebꞌok bꞌi chupa ri Rocho Dios, xujeq kelaj chike chaꞌ kakiya kan ulimoxna. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ekꞌu ri Pedro junam rukꞌ ri Juan lik xkichꞌikibꞌaꞌ ri kiwach puwi rachi, yey ri Pedro xubꞌiꞌij che: —Chojtzuꞌu pe la —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ewi ri sik xebꞌutzuꞌu ma royeꞌem we kꞌo kakiya che. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Pero ri Pedro xubꞌiꞌij che: —Na jinta saqil puaq wukꞌ y na jinta ne qꞌana puaq wukꞌ; noꞌj kꞌu ri kꞌo wukꞌ kanya cheꞌla. Chupa rubꞌiꞌ ri Qanimajawal Jesucristo ri aj Nazaret, yaktaj la y bꞌina la —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Ekꞌu ri Pedro xuchap che ruqꞌabꞌ uwikiqꞌabꞌ, xuyako y chupa laꞌ la joqꞌotaj xkowir ri raqan y ruqul raqan. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Y rachi xchꞌoplin chikaj, xtakꞌiꞌik y xujeqo kabꞌinik. Junam kꞌut kukꞌ ri Pedro y ri Juan, xok bꞌi pa ri Rocho Dios, kabꞌinik, kachꞌoplanik y kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Konoje kꞌu ri winaq re ri tinamit xkilo rachi kabꞌinik y lik kuyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Y xketaꞌmaj e achi katzꞌuyiꞌik y kutzꞌonoj ulimoxna chwach ri Rocho Dios pa ri okibꞌal kabꞌiꞌx che “Lik Chom”. Lik kꞌu xkam kanimaꞌ che ri xꞌaniꞌ che rachi y na xkimaj ta kꞌana usukꞌ chaꞌtaj xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Rachi xkunutajik na karesaj ta chi ribꞌ chikij ri Pedro y ri Juan. Yey konoje ri winaq kaminaq kanimaꞌ che, xemok kaꞌn pa ri luwar kabꞌiꞌx che “Ruchiꞌ Ja re Salomón”. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ekꞌuchiriꞌ xril waꞌ ri Pedro, xubꞌiꞌij chike ri tinamit: «Achijabꞌ alaq aj Israel, ¿suꞌchak lik kaminaq animaꞌ alaq che wa xil alaq? ¿Yey suꞌchak e kojtzutzaꞌ alaq riꞌoj pachaꞌ oj ri xojbꞌinisan re waꞌchi rukꞌ ri qachuqꞌabꞌ o ruma lik oj jusukꞌ riꞌoj chwach ri Dios? Na e ta riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Ma e ri Dios ke ri qamam ojertan, waꞌ e ri Abraham, ri Isaac y ri Jacob, ekꞌu Rire ri lik xuyak uqꞌij ri Jesús ri Raj Chak Rire. Noꞌj ralaq xya alaq ri Jesús puqꞌabꞌ ri Pilato. Y na xew ta laꞌ, ma xkꞌaq bꞌi alaq uqꞌij chwach ri Pilato y na xya ta alaq luwar che rire kuyolopij bꞌi ri Jesús echiriꞌ xraj kuyolopij bꞌi ruma na jinta mak xuriq che. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ekꞌu riꞌ ralaq na xꞌaj ta alaq kayolopix bꞌi waꞌ wa Jun lik nim uqꞌij Santo y Jusukꞌ; ma e xtzꞌonoj alaq kayolopix bꞌi ri jun kamisanel. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Xkamisaj kꞌu alaq riꞌ ri aj yaꞌl kꞌaslemal, ri Jun xkꞌastajisax lo chikixoꞌl ri ekaminaq ruma ri Dios. Puwi kꞌu riꞌ wa kꞌastajibꞌal kojtzijon wi riꞌoj ma lik oj xojilow re. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","»E ruma ri kubꞌulibꞌal kꞌuꞌxaj rukꞌ ri Jesús, xkowir ri raqan waꞌ waꞌchi kil alaq y etaꞌam ne alaq uwach. Yey ruma wa kubꞌulibꞌal kꞌuꞌxaj rukꞌ ri Jesús xkunutaj waꞌchi pa saqil wi jelaꞌ pachaꞌ katajin onoje alaq che rilik. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","»Wetaꞌam kꞌut, alaq qatz-qachaqꞌ, ri xꞌan alaq e ruma na xmaj ta alaq usukꞌ, y jenelaꞌ riꞌ xkiꞌan raj wach re ri tinamit alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Pero ruma ri xꞌan alaq che ri Jesús, ri Dios xuꞌana janipa rubꞌiꞌim lo ojertan kuma ri qꞌalajisanelabꞌ echiriꞌ xubꞌiꞌij Ruchaꞌoꞌn lo Rire kutij kꞌax. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","»E uwariꞌche tzelej tzij alaq chwach ri Dios y yaꞌa kꞌu ibꞌ alaq puqꞌabꞌ chaꞌ kakuytaj ri mak alaq y chaꞌ ri Qajawal Dios kuya uxlanem y utzil chomal chupa ri animaꞌ alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Jekꞌulaꞌ ri Dios kutaq na lo ukꞌ alaq ri Jesús, Ruchaꞌoꞌn lo Rire, ri bꞌiꞌtisim chi lo che alaq ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Tobꞌ kꞌu woꞌora lik chirajawaxik wi ri Jesús kꞌo chilaꞌ chikaj, kopon na ri qꞌij echiriꞌ ri Dios kuꞌan tanchi kꞌakꞌ che ronoje jelaꞌ pachaꞌ ri xubꞌiꞌij lo ojertan kuma ri qꞌalajisanelabꞌ ri xetaq lo ruma Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","»Ma ri Moisés xubꞌiꞌij chike ri qatiꞌ-qamam ojertan: E ri Dios Qajawxel kuyak na lo chikixoꞌlibꞌal ri qatinamit Israel jun Qꞌalajisanel jelaꞌ pachaꞌ riꞌin. Ekꞌu chita janipa ri kubꞌiꞌij Rire chiwe. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Ekꞌu ri tikawex na kukoj ta utzij wa jun Qꞌalajisanel, riꞌ kesax bꞌi y na jinta chi re kukꞌ rutinamit ri Dios xcha ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","»Konoje kꞌu ri qꞌalajisanelabꞌ kipetebꞌem lo chwi ri Samuel, lik etzijoninaq lo chwi taq waꞌ wa qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Alaq kꞌu ri kakꞌuluw re ri xubꞌiꞌtisij ri Dios kuma ri qꞌalajisanelabꞌ y ruma ri tzij xuꞌan kukꞌ ri qatiꞌ-qamam ojertan, echiriꞌ xubꞌiꞌij che ri Abraham: Ruma kꞌu Jun chike rawalkꞌoꞌal, kebꞌenuꞌan bendecir konoje rukꞌiyal kiwach taq ri tikawex che ruwachulew xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","»Ekꞌu ri Dios, echiriꞌ xukꞌastajisaj lo ri Raj Chak chikixoꞌl ri ekaminaq, xutaq lo nabꞌe ukꞌ ralaq re toꞌbꞌel e alaq chaꞌ jelaꞌ chijujunal alaq kajalkꞌatitaj ri bꞌinik silabꞌik alaq che ri na utz taj» xcha ri Pedro chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Kꞌa kechꞌaꞌt ne ri Pedro y ri Juan kukꞌ ri winaq, echiriꞌ xekꞌun lo raj chakunel re ri Rocho Dios, ri aj wach ke ri e chajinel re ri Rocho Dios y jujun saduceos. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Rike lik kꞌo koyowal chikij ri Pedro y ri Juan ma kekꞌutun chikiwach ri tikawex puwi rukꞌastajibꞌal lo ri Jesús chikixoꞌl ri ekaminaq, jekꞌuwaꞌ kakibꞌiꞌij: «Rukꞌastajibꞌal ri Jesús e kꞌutubꞌal re, chiqawach apanoq ri tikawex kekꞌastaj lo chikixoꞌl ri ekaminaq» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Ekꞌu ri e aj wach re ri Rocho Dios xetaqan che kechap bꞌi ri Pedro y ri Juan. Yey ruma kꞌu lik bꞌenaq qꞌij chik, xebꞌeꞌkiyaꞌa pa cárcel chaꞌ kataꞌ kichiꞌ kꞌa chukaꞌm qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Pero chike ri xetaw re ri xubꞌiꞌij ri Pedro, lik e kꞌi ri xkubꞌiꞌ kikꞌuꞌx rukꞌ ri Jesús; yey we kebꞌajilax xew ri achijabꞌ, laj e woꞌobꞌ mil xekojow re Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chukaꞌm qꞌij kꞌut xkimol kibꞌ pa ri tinamit Jerusalem raj wach ke raj judiꞌabꞌ kukꞌ ri nimaq winaq re ri tinamit y raj kꞌutunel re ri tzijpixabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Kꞌo chiriꞌ ri Anás ri kajawal raj chakunel pa Rocho Dios; yey e kꞌo ri Caifás, ri Juan, ri Alejandro y jujun chik kꞌo chux chike ri kajawal raj chakunel pa Rocho Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xekiya kꞌu ri Pedro y ri Juan chikinikꞌajal y xkitzꞌonoj chike: —¿China xyaꞌw piqꞌabꞌ o china pubꞌiꞌ xiꞌan riꞌix waꞌ? —xecha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Ekꞌu ri Pedro, rukꞌ ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios, xubꞌiꞌij chike: —Tape alaq, alaq aj wach re ri tinamit y alaq nimaq winaq re Israel, ");
INSERT INTO acrNNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ma e waqꞌij kataꞌ qachiꞌ puwi ri utz xꞌan che wa jun achi yewaꞌ chaꞌ ketaꞌmaxik suꞌanik xkunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ekꞌu riꞌ woꞌora kaqaqꞌalajisaj chiwach onoje alaq y chikiwach konoje ri tinamit Israel: Waꞌ waꞌchi kꞌo chiwach alaq xkunutaj chupa rubꞌiꞌ ri Qanimajawal Jesucristo re Nazaret, ri xkamisaj alaq chwa cruz yey ri Dios xukꞌastajisaj lo chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","»E pachaꞌ ri kubꞌiꞌij Ruchꞌaꞌtem ri Dios: E rabꞌaj kꞌaqital kan kuma raj yakal ja, e abꞌaj waꞌ lik xajawaxik chaꞌ katikiꞌ lo ri ja kachaꞌ. Ralaq e alaq pachaꞌ wa e aj yakal ja yey ri Jesús e ri Abꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xew kꞌu rukꞌ ri Jesús kariqitaj kolobꞌetajik, ma na jinta chi juna bꞌiꞌaj che ruwachulew yaꞌtal lo chike ri tikawex chaꞌ ruma riꞌ kojkolobꞌetajik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ekꞌu raj wach re ri tinamit xkilo ri Pedro y ri Juan na kakixiꞌij ta kꞌana kibꞌ ketzijon puwi ri Utzilaj Tzij, tobꞌ waꞌ waꞌchijabꞌ na e ta tijotal pachaꞌ rike yey xa ne e kukꞌil rachijabꞌ e aj chak re ri tinamit. Lik xkam kꞌu kanimaꞌ riꞌ chike y xkimaj usukꞌ e janipa taq ri kakiꞌano y ri kimajom ri Pedro y ri Juan, e ruma ri xekꞌojiꞌ rukꞌ ri Jesús, ri kitijonel. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Yey na utz tane kꞌu riꞌ kakibꞌiꞌij na kunutajinaq ta ri sik, ma waꞌ waꞌchi takꞌal chiriꞌ chikiwach kukꞌ ri Pedro y ri Juan. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ekꞌu ri xkiꞌano e xetaqan che chaꞌ ri Pedro y ri Juan kebꞌel bꞌi joqꞌotaj pa ri luwar re ri qꞌatbꞌal tzij, y xew kꞌu xekanaj raj qꞌatal tzij chaꞌ kechꞌaꞌt chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Jekꞌuwaꞌ xkibꞌiꞌij chikiwach: «¿Saꞌ ri kaqaꞌan chike waꞌchijabꞌ? Ma ri kꞌutubꞌal re kunanik ꞌanatal kuma rike, lik qꞌalajininaq chikiwach konoje ri ejeqel Jerusalem yey lik na utz taj kaqewaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ri qaꞌanaꞌ e qaxibꞌij kipa chaꞌ na ketzijon ta chi kꞌana chwach junoq chupa rubꞌiꞌ wa jun achi, y jelaꞌ na keꞌek ta chi utzijoxik waꞌ» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Xekisikꞌij kꞌu ri Pedro y ri Juan y lik xekitaq che na ketzijon taj y na kekꞌutun ta chi ne kꞌana pa rubꞌiꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pero ri Pedro y ri Juan xkikꞌul uwach: —Chꞌobꞌo pe ralaq: ¿Usukꞌ nawi chwach ri Dios e kaqakoj tzij ralaq chwa ri kaqakoj utzij Rire? ");
INSERT INTO acrNNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Ma riꞌoj, na utz taj kaqoqꞌotaj ubꞌiꞌxikil janipa ri qilom y ri qatom —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Ekꞌu ri e aj wach lik xkixibꞌij kipa. Tekꞌuchiriꞌ, xekiyolopij bꞌi ma na xkiriq taj suꞌanik kekiya pa kꞌaxkꞌobꞌik ruma kakixiꞌij kibꞌ chikiwach ri winaq re ri tinamit. Ma konoje lik kakiyak uqꞌij ri Dios ruma ri xkilo. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Yey lik qꞌalaj e rukꞌ ruchuqꞌabꞌ ri Dios xꞌaniꞌ wi ri kꞌutubꞌal re kunanik, ma waꞌchi xkunutajik, ralaxibꞌem sik yey ikꞌowinaq chi pa cuarenta rujunabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Echiriꞌ xeyolopix bꞌi, ri Pedro y ri Juan xebꞌek kukꞌ ri kachbꞌiꞌil y xkitzijoj chike janipa ri bꞌiꞌtal bꞌi chike kuma ri nimaq e aj chakunel pa Rocho Dios y ri nimaq winaq re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Echiriꞌ rike xkita waꞌ, konoje xa jun kikꞌuꞌx xkijeq kakiꞌan orar chwach ri Dios, jewaꞌ kakibꞌiꞌij: «¡Lal Dios Qajawxel, Lal ꞌanayom la ruwa kaj, ruwachulew, ri mar y ronoje ri kꞌo che taq waꞌ! ");
INSERT INTO acrNNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yey ruma ri David ri aj chak la, jewaꞌ xbꞌiꞌij la ojertan: ¿Suꞌchak lik ketukuk taq ri winaq yey taq ri tinamit xew kakinoꞌjij ri na jinta uchak? ");
INSERT INTO acrNNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ma xkimol kibꞌ ri taqanelabꞌ y ri e aj wach che ruwachulew, xkiꞌan kꞌu xa jun che kibꞌ y xebꞌek chirij ri Dios Qajawxel y chirij ri Cristo, Ruchaꞌoꞌn lo Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Waꞌ lik qatzij, ma chupa wa tinamit oj kꞌo wi, ri Herodes rukꞌ ri Poncio Pilato xkimol kibꞌ kukꞌ ri winaq e aj Israel y kukꞌ ri na e ta aj Israel; yey junam kꞌu xeyaktaj chirij ri Jesús, ri Santowilaj Aj Chak la, ri Jun xchaꞌ lo la. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Jekꞌulaꞌ, e xkiꞌano janipa ri chꞌobꞌom lo la ojertan chaꞌ e kuꞌana na riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","»Ekꞌu woꞌora, Qaqaw, kil la ri xibꞌibꞌal kipa raj chakibꞌ la kiꞌanom; yaꞌa kꞌu la ri chuqꞌabꞌ la chike rike chaꞌ na kakixiꞌij ta kꞌana kibꞌ kakitzijoj ri Chꞌaꞌtem la. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Yaꞌa ri qꞌabꞌ la pakiwiꞌ chaꞌ chupa rubꞌiꞌ ri Jesús, ri Santowilaj Aj Chak la, kekunutaj ri yewaꞌibꞌ y kaꞌaniꞌ taq kꞌutubꞌal re ri chuqꞌabꞌ la» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Echiriꞌ xkikꞌis uꞌanik orar, ri luwar pa kimolom wi kibꞌ xbꞌarbꞌatik y konoje xkikꞌul ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios y jekꞌulaꞌ na kakixiꞌij ta kꞌana kibꞌ kakitzijoj Ruchꞌaꞌtem ri Dios chikiwach konoje ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Konoje kꞌu rukꞌiyal hermanos, ri xkikoj rubꞌiꞌ ri Cristo, lik uꞌanom xa jun kanimaꞌ y xa jun kinaꞌoj; y na jinta junoq chike kuꞌan re che ri kꞌo rukꞌ, ma rubꞌitaq ke xuꞌan re chinima ronoje. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Jekꞌulaꞌ riꞌ, ri e taqoꞌn re ri Cristo rukꞌ unimal kichuqꞌabꞌ ketzijon chwi rukꞌastajibꞌal ri Qanimajawal Jesús, yey ri toꞌbꞌal re ri Dios kꞌo pakiwi konoje rike. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Na jinta kꞌu junoq kutij nibꞌaꞌil chikixoꞌl, ma janipa ri kꞌo taq kulew o kꞌo taq ja kukꞌ, we kꞌo xkikꞌayij, kakikꞌam lo ri rajil ");
INSERT INTO acrNNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","y kakiya kꞌu pakiqꞌabꞌ ri e taqoꞌn re ri Jesús chaꞌ rike kakijach chikiwach ri hermanos e chirij taq ri kajawax wi chike chikijujunal. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kꞌo kꞌu jun achi José rubꞌiꞌ, yey ri e taqoꞌn kakibꞌiꞌij Bernabé che. (Waꞌ wa bꞌiꞌaj keꞌelawi “bꞌochiꞌinel”.) Rire aj Chipre y e kukꞌil ri ralkꞌoꞌal kan ri Leví. ");
INSERT INTO acrNNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Waꞌ waꞌchi xukꞌayij chꞌaqap rulew; tekꞌuchiriꞌ, xukꞌam lo ri rajil y xuya pakiqꞌabꞌ ri e taqoꞌn. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Kꞌo kꞌu jun achi Ananías rubꞌiꞌ, junam rukꞌ ri rixoqil Safira xkikꞌayij chꞌaqap ulew. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ekꞌu rachi kꞌo xresaj kan che ri rajil rulew, yey junam rukꞌ ri rixoqil xkiꞌan tzij chikiwach chaꞌ kakiꞌan raqꞌubꞌal puwi ri rajil rulew. Ekꞌu ri nikꞌaj chik che ri rajil xukꞌam bꞌi, xuꞌyaꞌa pakiqꞌabꞌ ri e taqoꞌn y xubꞌiꞌij waꞌ e rajil rulew. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Ekꞌu ri Pedro xubꞌiꞌij che: —Ananías, ¿suꞌchak xaya luwar che ri Satanás kok pa awanimaꞌ chaꞌ jelaꞌ kaꞌan raqꞌubꞌal chwach ri Santowilaj Ruxlabꞌixel ri Dios? Ma xabꞌiꞌij xaya ronoje ri rajil rulew, pero kꞌo xawesaj kan che. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Echiriꞌ kꞌamajaꞌ kakꞌayij rawulew, ¿na aweꞌat ta nebꞌa laꞌ? Y echiriꞌ akꞌayim chik, ¿na paqꞌabꞌ ta nebꞌa kꞌo wi kaꞌan rukꞌ ri rajil saꞌ ri kawaj? ¿Suꞌchak kꞌu riꞌ xaꞌan waꞌ? ¡Na chikiwach ta kꞌu achijabꞌ aꞌanom wi raqꞌubꞌal ma e chwach ri Dios! —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Xew kꞌu xuta waꞌ wa chꞌaꞌtem, ri Ananías xtzaq pulew y asu xkamik. Ruma kꞌu waꞌ, xpe jun xiꞌin ibꞌ pakiwi konoje ri xebꞌetaꞌman re. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Xekꞌun kꞌu lo jujun alabꞌo, xkipis rucuerpo, xkikꞌam bꞌi y xeꞌkimuquꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Laj oxibꞌ ora rikꞌowik waꞌ echiriꞌ xok lo ri Safira ri rixoqil ri Ananías; yey rire na retaꞌam ta kꞌu riꞌ saꞌ ri xukꞌulumaj ri rachijil. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Ekꞌuchiriꞌ, xutzꞌonoj ri Pedro che: —Chabꞌiꞌij chwe: ¿E rajil waꞌ rulew xikꞌayij? —xcha che. Rixoq xukꞌul uwach che: —Areꞌ, e rajil laꞌ —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Xubꞌiꞌij kꞌu ri Pedro che: —¿Suꞌchak xiꞌan tzij chiwach chaꞌ kikꞌam upa ri Ruxlabꞌixel ri Dios Qajawxel? ¡Chawilaꞌ! Ralabꞌo katajin lo kokik che ruchiꞌ ja, e laꞌ xetzelej lo che umuqik rawachijil, yey ekꞌu woꞌora e katkikꞌam bꞌi riꞌat —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Na jampatana xtzaq ri Safira chwach ri Pedro y asu xkamik. Ekꞌuchiriꞌ xebꞌok lo ralabꞌo, xoꞌlkiriqaꞌ kaminaq chik. Xkikꞌam kꞌu bꞌi y xeꞌkimuqu putzal ri rachijil. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Y xok kꞌu jun unimal xiꞌin ibꞌ kukꞌ konoje ri tinamit re ri Cristo y kukꞌ konoje ri xebꞌetaꞌman re taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Kuma kꞌu ri e taqoꞌn re ri Cristo, ukꞌiyal kꞌutubꞌal re ruchuqꞌabꞌ ri Dios y nimaq taq chak katajin rilik chikiwach taq ri tikawex. Yey taq ri kikojom rubꞌiꞌ ri Cristo, lik xa jun kikꞌuꞌx kakimol kibꞌ pa ri luwar kabꞌiꞌx che “Ruchiꞌ Ja re Salomón”. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","E taq kꞌu ri kꞌamajaꞌ kakikoj rubꞌiꞌ ri Cristo, kakixiꞌij kibꞌ kakijunimaj kibꞌ kukꞌ, tobꞌ konoje ri tikawex lik kakiyak kiqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Y katajin kꞌu kikꞌiyarik ri kikojom rubꞌiꞌ ri Qanimajawal, waꞌ e ukꞌiyal achijabꞌ y ukꞌiyal ixoqibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Ruma taq kꞌu ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios kakiꞌan rutaqoꞌn ri Jesús, taq ri winaq kekesaj taq ne lo ri e yewaꞌibꞌ pa taq ri bꞌe. Ekiyaꞌom chwa chꞌat y chwa pop, chaꞌ we xikꞌow ri Pedro, tobꞌ xew luꞌmuꞌj katzaq pakiwiꞌ, kekunutaj kꞌu riꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","E kꞌi ne ri e petinaq pa taq ri tinamit kꞌo lo chunaqaj Jerusalem. Ekikꞌamom lo ri yewaꞌibꞌ y ri echꞌuꞌjerinaq kuma itzelilaj uxlabꞌixel; y konoje kꞌut kekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ri kajawal raj chakunel pa Rocho Dios y konoje ri e kꞌo rukꞌ, waꞌ e ri saduceos, xujeq katiꞌtot kikꞌuꞌx chikij rutaqoꞌn ri Jesús ruma lik e kꞌi ri winaq eteran chikij. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Xekichap kꞌu bꞌi rutaqoꞌn ri Jesús y xebꞌeꞌkiyaꞌa pa ri cárcel re ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Xopon kꞌu jun ángel re ri Qanimajawal chaqꞌabꞌ, xuꞌjaqa taq ri okibꞌal re ri cárcel y xebꞌeresaj loq. Ekꞌuchiriꞌ, xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","«Jix, jixeꞌtakꞌala pa ri Rocho Dios y chitzijoj chike ri winaq re ri tinamit ronoje puwi ri kꞌakꞌ bꞌe re kꞌaslemal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Ruma kꞌu ri xkita che ri ángel, anim tan xebꞌok pa ri Rocho Dios y xkijeq kekꞌutunik. Ekꞌu ri kajawal raj chakunel pa Rocho Dios yey ri e kꞌo rukꞌ, kꞌamajaꞌ kakinaꞌbꞌej riꞌ we rutaqoꞌn ri Jesús ebꞌesam chi lo pa ri cárcel. Xkimol kꞌu kichiꞌ taq ri uchapom wi ribꞌ ri qꞌatbꞌal tzij, kukꞌ konoje ri nimaq winaq ke raj Israel. Xekitaq kꞌu ri e chajinel re ri Rocho Dios che kikꞌamik rutaqoꞌn ri Jesús pa ri cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ekꞌuchiriꞌ xebꞌopon ri e chajinel pa ri cárcel, na xekiriq ta chi rutaqoꞌn ri Jesús. Xetzelej kꞌu loq ");
INSERT INTO acrNNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","y jewaꞌ xoꞌlkibꞌiꞌij: «Ri cárcel xqariqo lik tzꞌapil chi utz, yey raj chajinel e kꞌo ne chwach taq ri okibꞌal re ri cárcel. Pero echiriꞌ xqajaqo, na jinta chi junoq chike rutaqoꞌn ri Jesús chupa» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Echiriꞌ xkita waꞌ, xsach kinaꞌoj ri kajawal raj chakunel y raj wach ke ri e chajinel kukꞌ ri nimaq e aj chakunel re ri Rocho Dios. Konoje xkijeq kechꞌaꞌt puwiꞌ, ma na ketaꞌam taj saꞌ kukꞌisbꞌej wi ronoje waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Ekꞌuchiriꞌ, xkꞌun lo jun y jewaꞌ xubꞌiꞌij: «E rachijabꞌ xeyaꞌ alaq pa cárcel, e kꞌo pa ri Rocho Dios y na koqꞌotam ta kekꞌutun chikiwach ri tinamit» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Ekꞌu raj wach ke ri e chajinel re ri Rocho Dios xeꞌek junam kukꞌ jujun e aj chajinel y xeꞌkikꞌama lo rutaqoꞌn ri Jesús. Yey na jinta kꞌo xkiꞌan chike ma kakixiꞌij kibꞌ we kakiꞌan kꞌax chike, laj keꞌan paꞌbꞌaj kuma ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ekꞌuchiriꞌ xekikꞌam loq, xekiya chikiwach ri uchapom wi ribꞌ ri qꞌatbꞌal tzij. Ekꞌu ri kajawal raj chakunel pa Rocho Dios xutzꞌonoj chike rutaqoꞌn ri Jesús: ");
INSERT INTO acrNNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—¿Na xixqataq ta nebꞌa che chaꞌ na kixkꞌutun ta chi chupa rubꞌiꞌ wa jun achi? Yey woꞌora iwuma ne riꞌix xeꞌek utzijoxik wa kꞌutunik che ronoje Jerusalem; y na xew ta laꞌ, ma kiwaj ne kiya qeqlabꞌal che rukikꞌel laꞌ la jun achi —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ri Pedro kukꞌ ri jujun chik e taqoꞌn re ri Jesús xkikꞌul uwach: —Lik chirajawaxik wi nabꞌe na e kaqakoj utzij ri Dios chwach ri kaqakoj kitzij rachijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma ri Dios ke ri qatiꞌ-qamam e xkꞌastajisan lo ri Jesús chikixoꞌl ri ekaminaq. Yey e ralaq ri xkamisan alaq ma uma ralaq xyaꞌiꞌ ri Jesús chwa ri cruz. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Pero ri Dios lik xuyak uqꞌij ri Jesús, xuya puwikiqꞌabꞌ y xuꞌan Qajawal y Kolobꞌenel che; chaꞌ ruma ri Jesús, raj Israel kakitzelej kitzij chwach y kakiriq na ri kuybꞌal kimak. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","»Ekꞌu riꞌoj, e janipa ri xqilo, e kaqatzijoj. Yey ri Santowilaj Ruxlabꞌixel ri Dios, ri Jun yaꞌtal chike ri kakikoj utzij ri Dios, e kajikibꞌan uwach waꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Echiriꞌ xkita waꞌ ri e aj wach, lik xpe koyowal chikij rutaqoꞌn ri Jesús y xkaj kekikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ekꞌuchiriꞌ, chikixoꞌl ri e aj qꞌatal tzij xyaktaj jun fariseo Gamaliel rubꞌiꞌ, aj kꞌutunel re ri tzijpixabꞌ yey lik yakom uqꞌij ruma ri tinamit. Rire xtaqan che kebꞌesax bꞌi joqꞌotaj ri e taqoꞌn re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Tekꞌuchiriꞌ, xubꞌiꞌij: «Achijabꞌ, alaq aj Israel, chꞌobꞌo na alaq raqan chi utz saꞌ ri kaꞌan alaq chike waꞌchijabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ma kꞌo tan qꞌij xyaktaj jun achi Teudas rubꞌiꞌ, yey chiribꞌil ribꞌ xubꞌiꞌij e jun achi lik kꞌo uwach. Laj e kajibꞌ ciento rachijabꞌ xeterej chirij. Pero xopon jun qꞌij rire xkamisaxik. Y konoje ri xesokotaj ruma rire, xekicher bꞌi; jekꞌulaꞌ, xsach uwach janipa ri xunoꞌjij. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","»Chwi kꞌu riꞌ waꞌ, xyaktaj jun chik chupa taq ri qꞌij echiriꞌ xꞌan jun ajilanik. Waꞌ e ri Judas aj Galilea. Yey ukꞌiyal tikawex xeterej chirij. Pero xopon ruqꞌijol echiriꞌ xkamisaxik; y konoje kꞌu ri xesokotaj ruma rire, xekicher bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","»Kambꞌiꞌij kꞌu woꞌora che alaq: Mechꞌichꞌaꞌ chi alaq waꞌchijabꞌ; ri ꞌana alaq e cheyolopij bꞌi alaq. Ma we xa kinoꞌjibꞌal achijabꞌ wa kakikꞌutu, riꞌ kasach na uwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Noꞌj we waꞌ re ri Dios, na kachꞌij ta alaq usachik kiwach; y kꞌate kꞌu kanaꞌ alaq riꞌ kachꞌoꞌjin alaq rukꞌ ri Dios» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Konoje xukꞌul kikꞌuꞌx ri xubꞌiꞌij ri Gamaliel. Xekisikꞌij kꞌu ri e taqoꞌn re ri Jesús; tekꞌuchiriꞌ, xjichꞌ kipa rukꞌ kolobꞌ y xekitaq che na ketzijon ta chi chupa rubꞌiꞌ ri Jesús y xekiyolopij kꞌu bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Xebꞌel kꞌu bꞌi ri e taqoꞌn chikiwach raj qꞌatal tzij. Lik kekiꞌkotik ma xyaꞌtaj chike kakitij kꞌax ruma kikojom rubꞌiꞌ ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Jekꞌulaꞌ, ronoje qꞌij na kakoqꞌotaj taj kekꞌutunik y kakitzijoj ri Utzilaj Tzij chwi ri Jesucristo chupa ri Rocho Dios y chiꞌ taq ja. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Chupa taq laꞌ la qꞌij lik xekꞌiyar ri kajlibꞌal ri kikojom rubꞌiꞌ ri Cristo. Ekꞌu ri hermanos e aj judiꞌabꞌ ri kechꞌaꞌt pa ri chꞌaꞌtem griego, xkijeq kechꞌaꞌtibꞌen chikij ri hermanos e aj judiꞌabꞌ ri kechꞌaꞌt pa ri chꞌaꞌtem hebreo. Ma echiriꞌ kaꞌan ri jachanik chike ri e nibꞌaꞌibꞌ, ri malkaꞌnibꞌ ri kechꞌaꞌt pa ri chꞌaꞌtem griego na kekajmax ta chi utz rukꞌ ri toꞌbꞌal ke kakikꞌul ri jujun qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Ekꞌu ri kabꞌlajuj taqoꞌn xkimol kichiꞌ konoje ri kikojom rubꞌiꞌ ri Cristo y xkibꞌiꞌij chike: «Na usukꞌ taj we riꞌoj kaqatanabꞌaꞌ utzijoxik Rutzij Upixabꞌ ri Dios chaꞌ kaqaya qibꞌ che ujachik ri kajawax chike ri e nibꞌaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ruma kꞌu laꞌ hermanos, tzukuj alaq wuqubꞌ achijabꞌ chixoꞌl alaq, chom ri kibꞌinik kisilabꞌik, lik kiyaꞌom kibꞌ puqꞌabꞌ ri Ruxlabꞌixel ri Dios y lik kꞌo kinaꞌoj, chaꞌ kaqaya wa chak pakiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Jekꞌulaꞌ riꞌoj xew kaqaya qibꞌ che kaqaꞌan orar chwach ri Dios y che rutzijoxik Ruchꞌaꞌtem» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Konoje kꞌu ri hermanos kimolom kibꞌ, xukꞌul kikꞌuꞌx wa xbꞌiꞌx chike. Xkichaꞌ kꞌu ri Esteban, jun achi lik kubꞌul ukꞌuꞌx rukꞌ ri Dios yey lik kꞌo ri Santowilaj Ruxlabꞌixel ri Dios rukꞌ. Y xekichaꞌ ri Felipe, ri Prócoro, ri Nicanor, ri Timón, ri Parmenas y ri Nicolás, jun achi aj Antioquía xex utaqem lo ri kꞌutunik ke raj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ewi xekikꞌam lo chikiwach rutaqoꞌn ri Jesús. Ekꞌu wa taqoꞌn xkiya ri kiqꞌabꞌ pakiwiꞌ y xkiꞌan orar kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Jekꞌuriꞌlaꞌ ri Utzilaj Tzij re ri Qanimajawal lik xeꞌek utzijoxik y lik katajin kikꞌiyarik ri kajlibꞌal ri kikojom rubꞌiꞌ ri Cristo chiriꞌ Jerusalem. E kꞌo ne ukꞌiyal e aj chakunel pa Rocho Dios xkijeq kakitaqej ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ri Esteban lik kꞌo ri unimal rutzil ukꞌuꞌx y ruchuqꞌabꞌ ri Dios rukꞌ. Ruma kꞌu riꞌ, kuꞌan nimaq taq kꞌutubꞌal re ruchuqꞌabꞌ ri Dios chikiwach ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Ekꞌuchiriꞌ, xeyaktaj jujun re ri sinagoga, ri kabꞌiꞌx che “Ri sinagoga ke ri ebꞌelinaq lo pa ri kꞌax”, yey kukꞌ rike xeyaktaj jujun e aj Cirene, e aj Alejandría, e aj Chipre y e aj Asia. E taq kꞌu riꞌ waꞌ xkijeqo xa pa chꞌaꞌtem kechꞌoꞌjin rukꞌ ri Esteban. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Yey na kakiriq ta ukꞌulik uwach ri kubꞌiꞌij ri Esteban ma rire kachꞌaꞌt rukꞌ ri naꞌoj uyaꞌom ri Ruxlabꞌixel ri Dios che. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ekꞌu ri xkiꞌano e xekipuaqij jujun achijabꞌ chaꞌ kakibꞌiꞌij kitom tzel kachꞌaꞌt ri Esteban chirij ri Moisés y chirij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Xa jekꞌulaꞌ xekichꞌiꞌ wi taq ri winaq re ri tinamit, ri nimaq winaq e aj wach y raj kꞌutunel re ri tzijpixabꞌ. Konoje kꞌu riꞌ waꞌ xebꞌek chirij ri Esteban; rukꞌ oyowal xkichapo, xkikꞌam bꞌi y xeꞌkiyaꞌa chikiwach taq ri uchapom wi ribꞌ ri qꞌatbꞌal tzij. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xekikoj kꞌu achijabꞌ e aj kojol raqꞌubꞌal chirij, jewaꞌ kakibꞌiꞌij: «Waꞌ waꞌchi lik xaqi tzel kachꞌaꞌt chirij wa Santowilaj Luwar re ri Rocho Dios y chirij Rutzij Upixabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ma qatom kubꞌiꞌij, laꞌ la Jesús ri aj Nazaret kuwulij wa luwar y kujalkꞌatij janipa ri kꞌutunik y kojobꞌal yaꞌtal kan chiqe ruma ri Moisés» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Konoje kꞌu ri etzꞌul pa ri qꞌatbꞌal tzij, echiriꞌ xkitzuꞌ uwach ri Esteban, xkil rupalaj e pachaꞌ upalaj juna ángel. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Ri kajawal raj chakunel pa Rocho Dios xutzꞌonoj che ri Esteban we qatzij xubꞌiꞌij waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ekꞌu rire xubꞌiꞌij: «Alaq achijabꞌ y alaq nimaq winaq, chinta na pe alaq. Ri Dios, ri Jun lik kꞌo unimal chomalil rukꞌ, xuqꞌalajisaj ribꞌ chwach ri qaqaw Abraham echiriꞌ rire kꞌo pa ri luwar re Mesopotamia, waꞌ e echiriꞌ kꞌamajaꞌ keꞌjeqela pa ri tinamit Harán. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Xubꞌiꞌij ri Dios che: “Chatelubꞌi chupa ratinamit y chikixoꞌl rawatz-achaqꞌ; y jat kꞌu chwach rulew pa kankꞌut wi riꞌin chawe” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Ekꞌuchiriꞌ, xel bꞌi ri Abraham chwach rulew ke raj Caldea y xjeqiꞌ pa ri tinamit Harán. Chwi kꞌu rukamik ruqaw, xtaq lo ruma ri Dios chupa wa luwar pa jeqel wi alaq woꞌora. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","»Pero ri Dios na xuya tane che ri Abraham kuꞌan rajaw waꞌ wuꞌlew, tobꞌ tane xa pa kuya wi juna raqan. Noꞌj xubꞌiꞌtisij kꞌu che tobꞌ ne rire kaminaq chik, waꞌ wuꞌlew kuꞌana na re y ke ri ralkꞌoꞌal kanoq; yey echiriꞌ xbꞌiꞌx waꞌ che ri Abraham, kꞌamajaꞌ ne kꞌo juna ralkꞌoꞌal. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Ekꞌu ri Dios xubꞌiꞌij che ri Abraham: Taq rawalkꞌoꞌal kanoq kebꞌeꞌjeqela na pa jun ulew na kulew taj. Y chiriꞌ kꞌu riꞌ kaꞌaniꞌ nibꞌaꞌibꞌ chike y keyaꞌiꞌ pa kꞌaxlaj chak kajibꞌ ciento junabꞌ kuma ri tikawex re ri tinamit pa kekꞌojiꞌ wi. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Pero In kinqꞌataw tzij pakiwi wa tinamit, ri kakiya pa kꞌaxlaj chak ri nutinamit. Tekꞌuchiriꞌ, ri nutinamit kebꞌel loq y ketzelej loq y kinkiloqꞌnimaj chupa wa luwar at kꞌo wi xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","»Ri Dios xuꞌan jun tzij rukꞌ ri Abraham, yey ri kꞌutubꞌal re waꞌ wa tzij e ri retalil re circuncisión. E uwariꞌche ri Abraham xukoj ri retalil re circuncisión che rukꞌajol Isaac echiriꞌ xukꞌis wajxaqibꞌ qꞌij ralaxik. Jekꞌulaꞌ xuꞌan ri Isaac che rukꞌajol Jacob. Y ri Jacob jelaꞌ xuꞌan chike ri kabꞌlajuj ukꞌajol, ri e qamam re ri qatinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","»Ekꞌu rike xok retzelal kꞌuꞌx pa kanimaꞌ chirij ri kichaqꞌ José. Ruma kꞌu riꞌ, xkikꞌayij bꞌi chaꞌ kakꞌam bꞌi Egipto. Pero ri Dios kꞌo rukꞌ ri José ");
INSERT INTO acrNNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","y xresaj kꞌu chupa ronoje taq ri kꞌaxkꞌobꞌik xikꞌow wi. Xuya unaꞌoj y xuꞌan che lik xukꞌul upuwach ri faraón, ri taqanel re Egipto. Ma ri faraón xuya che ri José kataqan puwi ri tinamit re Egipto y xuya puqꞌabꞌ rire ronoje rubꞌitaq re. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","»Xpe kꞌu jun unimal numik chupa taq ronoje ri luwar re Egipto y re Canaán. Ruma kꞌu waꞌ xpe unimal kꞌaxkꞌobꞌik pakiwi ri qatiꞌ-qamam ma na jinta kakitijo. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","»Echiriꞌ ri Jacob xunaꞌbꞌej chilaꞌ Egipto kꞌo katijik, xebꞌutaq bꞌi rukꞌajol chaꞌ keꞌkiloqꞌo trigo chilaꞌ. Waꞌ e ri nabꞌe bꞌenam xkiꞌan ri qamam chilaꞌ Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ekꞌu che rukalaj kibꞌenam, ri José xuqꞌalajisaj ribꞌ chikiwach ri ratzixelabꞌ. Jekꞌulaꞌ ri faraón xretaꞌmaj china taq ri e ratz-uchaqꞌ ri José. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","»Yey ri José xutaq ukꞌamik ruqaw Jacob y konoje ri e ratz-uchaqꞌ. Ri kajlibꞌal rike chi konoje e setenta y cinco. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jekꞌulaꞌ xeꞌjeqela ri Jacob pa ri tinamit Egipto. Chilaꞌ kꞌu riꞌ xkam wi rire y chilaꞌ xekam wi ri qamam. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xkꞌam kꞌu bꞌi ri kibꞌaqil pa ri tinamit Siquem y xeyaꞌ pa ri muqubꞌal uloqꞌom kan ri Abraham rukꞌ ukꞌiyal puaq chike ri ralkꞌoꞌal kan ri Hamor, chilaꞌ Siquem. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","»Yey ekꞌuchiriꞌ katajin roponik ri qꞌij echiriꞌ ri Dios kuꞌana na rubꞌiꞌtisim che ri Abraham, taq ri ralkꞌoꞌal rire lik xekꞌiyar chilaꞌ Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Tekꞌuchiriꞌ, xyaktaj jun chik rey chiriꞌ Egipto; ekꞌu rire na xretaꞌmaj ta uwach ri José. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Waꞌ wa rey xebꞌusok ri qatinamit ojertan. Lik xebꞌuya ri qatiꞌ-qamam pa kꞌaxkꞌobꞌik, ma xtaqan che kekamisax ri kichꞌutiꞌq e alabꞌo chaꞌ jelaꞌ na kakꞌiyar ta kiwach ri qatinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","»Chupa taq kꞌu riꞌ laꞌ la qꞌij xalax ri Moisés y e jun chomilaj akꞌa chwach ri Dios. Ekꞌu rire oxibꞌ ikꞌ xchajix xa xeꞌlaqꞌay pa rocho ruqaw. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Pero echiriꞌ na utz ta chi kewax pa ja, xesax bꞌi y xeꞌriqitaj lo ruma rumiꞌal ri faraón; y waꞌli xukꞌiyisaj y xuꞌan pachaꞌ ralabꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Jekꞌulaꞌ, ri Moisés xtijox puwi ronoje ri naꞌoj ke ri aj Egipto, y xuꞌana jun achi lik kꞌo uchuqꞌabꞌ che janipa taq ri kubꞌiꞌij y kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","»Echiriꞌ xukꞌis cuarenta junabꞌ, xalax pa ranimaꞌ keꞌbꞌina kukꞌ ri ratz-uchaqꞌ, ri e aj Israel. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Y xril kꞌu riꞌ lik kaꞌan kꞌax che jun chike ruma jun aj Egipto. Xutoꞌ kꞌu uwiꞌ ri ratz-uchaqꞌ yey xukamisaj ri aj Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","E xuchꞌobꞌ rire, taq ri ratz-uchaqꞌ kakimaj usukꞌ e ruma rire kebꞌeresaj bꞌi ri Dios pakiqꞌabꞌ raj Egipto; noꞌj rike na je ta laꞌ ri xkimaj usukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","»Chukaꞌm qꞌij kꞌut xebꞌuꞌriqa kaꞌibꞌ aj Israel kechꞌoꞌjin chikiwach y xraj kebꞌuya putzil chomal. Xubꞌiꞌij kꞌu chike: “Achijabꞌ, ralaq chaqꞌ ibꞌ alaq. ¿Suꞌchak kꞌu riꞌ kaꞌan kꞌax che ibꞌ alaq chiwach alaq?” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","»Ekꞌuchiriꞌ, ri jun ri kuꞌan kꞌax che ri ratz-uchaqꞌ, xupaqchiꞌij bꞌi ri Moisés y xubꞌiꞌij che: “¿China kojoyom e la re taqanel y re aj qꞌatal tzij paqawi riꞌoj? ");
INSERT INTO acrNNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Kaꞌaj kami la riꞌ kinkamisaj la riꞌin jelaꞌ pachaꞌ xꞌan la iwir echiriꞌ xkamisaj la ri aj Egipto?” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","»Echiriꞌ xuta waꞌ wa chꞌaꞌtem, ri Moisés asu xanimaj bꞌi, xeꞌjeqela pa ri luwar re Madián, tobꞌ rire na aj ta chilaꞌ. Yey chilaꞌ xebꞌalax kaꞌibꞌ ukꞌajol. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","»Ikꞌowinaq chi kꞌu cuarenta junabꞌ kꞌo chilaꞌ echiriꞌ xwinaqir jun ángel chwach chupa rurepebꞌal aqꞌ kꞌo che jumokaj xulukej pa ri luwar katzꞌintzꞌotik, chunaqaj ri juyubꞌ Sinaí. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Echiriꞌ xril waꞌ ri Moisés, lik xkam ranimaꞌ che ri katajin ukꞌutik chwach. Yey echiriꞌ xqibꞌ che rilik chi utz, xuta ruqul ri Dios, jewaꞌ xubꞌiꞌij che: ");
INSERT INTO acrNNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“In ri Dios ke ramam ojertan, waꞌ e ri Abraham, ri Isaac y ri Jacob” xchaꞌ. »Ekꞌu ri Moisés xujeq kabꞌirbꞌotik y ruma xiꞌin ibꞌ na xutzuꞌ ta chi ri jumokaj xulukej. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","»Ekꞌu ri Dios xubꞌiꞌij che: “Chajolo raxajabꞌ che rawaqan ma wa luwar pa at kꞌo wi lik santo. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Paqatzij wi riꞌin wilom lik eyaꞌtal pa kꞌaxkꞌobꞌik ri nutinamit e kꞌo Egipto, yey nutom lik ketunanik. E uwariꞌche in petinaq re kebꞌeꞌnuwesaj loq. Ekꞌu woꞌora chatpetoq; ma katintaq bꞌi Egipto” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","»Ekꞌu Moisés riꞌ waꞌ, ri xkꞌaq bꞌi uqꞌij echiriꞌ xbꞌiꞌx che: “¿China kojoyom e la re taqanel y re aj qꞌatal tzij paqawi riꞌoj?” Na rukꞌ ta kꞌu riꞌ, e ri Moisés ri xtaq bꞌi ruma ri Dios re kuꞌana kitaqanel rutinamit y re kebꞌeresaj ri tinamit pakiqꞌabꞌ raj Egipto. Xtaq kꞌu che kuꞌan waꞌ ruma ri ángel, ri xwinaqir chwach pa ri jumokaj xulukej. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","E Moisés riꞌ waꞌ, ri xebꞌeresaj lo rutinamit ri Dios Egipto y lik xuꞌan milagros y taq kꞌutubꞌal re ruchuqꞌabꞌ ri Dios pa ri tinamit Egipto, chupa ri Mar Rojo y chupa ri cuarenta junabꞌ xebꞌin pa ri luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","»Ekꞌu Moisés riꞌ waꞌ, ri xbꞌiꞌn chike raj Israel: E ri Dios Qajawxel kuyak na lo chikixoꞌl ri qatinamit Israel jun Qꞌalajisanel jelaꞌ pachaꞌ riꞌin. Ekꞌu chita janipa ri kubꞌiꞌij Rire chiwe xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","»E Moisés riꞌ waꞌ, ri xkꞌojiꞌ chikiwach ri tinamit echiriꞌ kimolom kibꞌ pa ri luwar katzꞌintzꞌotik, y e xesan uchiꞌ ri ángel chikiwa ri qatiꞌ-qamam echiriꞌ xchꞌaꞌt rukꞌ chwi ri juyubꞌ Sinaí. Yey e rire ri xkꞌuluw taq ri chꞌaꞌtem re kꞌaslemal chaꞌ kuqꞌatisaj lo chiqawach riꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","»Pero ri qatiꞌ-qamam na xkaj taj kakikoj utzij; ri xkiꞌano e xkikꞌaq bꞌi uqꞌij y e xchꞌaw kikꞌuꞌx che ri ketzelej tanchi Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Yey xkibꞌiꞌij ne che ri Aarón: “Cheꞌana la qatiox chaꞌ kenabꞌej bꞌi chiqawach; ma wa Moisés, ri xesan lo qeꞌoj chwach rulew re Egipto, na qetaꞌam taj saꞌ ri xukꞌulumaj.” ");
INSERT INTO acrNNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Ekꞌuchiriꞌ, xkiꞌan jun tiox ukꞌaxwach toro. Xekikamisaj kꞌu awaj re kiqasaꞌn chwach wa tiox y xkiꞌan nimaqꞌij chupa rubꞌiꞌ ri tiox, ri xa xkiꞌan rukꞌ ri kiqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","»Ekꞌu ri Dios xebꞌuya kan che uloqꞌnimaxik kiqꞌij ronoje ri kꞌo che ruwa kaj. Xkiꞌan kꞌut jelaꞌ pachaꞌ ri ubꞌiꞌim ri Dios chupa ri tzꞌibꞌital kan kuma ri qꞌalajisanelabꞌ: Riꞌix ix aj Israel, echiriꞌ xebꞌikamisaj chikop re qasaꞌn chupa ri cuarenta junabꞌ xixbꞌin pa ri luwar katzꞌintzꞌotik, ¿xiloqꞌnimaj nebꞌa nuqꞌij riꞌin rukꞌ waꞌ? ");
INSERT INTO acrNNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Na xiꞌan taj, ma e ne xitelej ri rocho ri tiox Moloc ubꞌiꞌ y ri chꞌumil re ri tiox iweꞌix, Renfán ubꞌiꞌ. Waꞌ e kikꞌaxwach taq ri tiox xebꞌiꞌano re kiloqꞌnimaj kiqꞌij. Ruma kꞌu laꞌ kixintaq bꞌi kꞌa chwach pana ri tinamit Babilonia kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","»Echiriꞌ ri qatiꞌ-qamam xebꞌin pa ri luwar katzꞌintzꞌotik, kꞌo kukꞌ rike ri jun Rocho Dios xa kakirik, waꞌ e kꞌutubꞌal re kꞌo ri Dios kukꞌ. Yey rike xkiꞌan wa jun Rocho Dios jelaꞌ pachaꞌ ri xtaqan ri Dios che ri Moisés, e lik pachaꞌ ruꞌanikil rilom chi rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ekꞌu ri qatiꞌ-qamam xkiya kan wa Rocho Dios (ri xa kakirik) pakiqꞌabꞌ ri kalkꞌoꞌal rike. Y wa kalkꞌoꞌal xkikꞌam bꞌi waꞌ echiriꞌ xebꞌok rukꞌ ri Josué chupa ri ulew ke ri na e ta aj Israel, ri xebꞌesax bꞌi ruma ri Dios chaꞌ waꞌ wuꞌlew kakanaj kan pakiqꞌabꞌ rutinamit Rire. Ekꞌu waꞌ wa Rocho Dios xkꞌojiꞌ kukꞌ rutinamit ri Dios kꞌa chupa taq ri qꞌij re ri rey David. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","»Ekꞌu ri David lik kꞌo rutoꞌbꞌal ri Dios rukꞌ. Rire xutzꞌonoj kꞌut kayaꞌtaj che kuyak jun kꞌakꞌ Rocho ri Dios chaꞌ taq ri ralkꞌoꞌal kan ri Jacob kakiloqꞌnimaj uqꞌij ri Dios chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Noꞌj e ri Salomón ri xyakaw waꞌ wa Rocho Dios; ");
INSERT INTO acrNNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","tobꞌ ri Dios Qajawxel na xew ta kajeqiꞌ pa taq ja ꞌanatal xa kuma tikawex, pachaꞌ ri kubꞌiꞌij ri jun qꞌalajisanel: ");
INSERT INTO acrNNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","“Ruwa kaj e nutzꞌulibꞌal re taqanik, yey ruwachulew e utakꞌalibꞌal ri waqan. ¿Saꞌ kꞌu riꞌ ri ja kiyak chwe?” kacha ri Qajawal. “¿O pachawi kꞌowi ri luwar pa kinuxlan wi? ");
INSERT INTO acrNNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","¿Na e ta nebꞌa ri nuqꞌabꞌ ꞌanayom ronoje waꞌ wa kꞌolik?” kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","»Ekꞌu ralaq lik na jinta kꞌo kata alaq. Ri kꞌuꞌx alaq y ri tanibꞌal alaq e pachaꞌ ke ri winaq na jinta ri Dios kukꞌ, ma na kaꞌaj ta alaq kakoj alaq utzij. Ralaq alaq pachaꞌ ri chuꞌqaw alaq ojertan, ma lik na kaꞌaj ta alaq kata alaq ri kubꞌiꞌij ri Santowilaj Ruxlabꞌixel ri Dios che alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿China junoq chike ri qꞌalajisanelabꞌ na xternabꞌex ta rukꞌ kꞌax kuma ri chuꞌqaw alaq ojertan? Ma rike e xekamisan ke ri xetzijon lo puwi rukꞌutunik ri Jun lik jusukꞌ. Yey echiriꞌ xkꞌun Rire, ralaq xkꞌayij alaq y xkamisaj alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Ralaq xkꞌul alaq Rutzij Upixabꞌ ri Dios kuma taq ri ángeles, noꞌj na xtaqej ta alaq janipa ri kubꞌiꞌij wa Tzij Pixabꞌ» xcha ri Esteban. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Echiriꞌ xkita ri xubꞌiꞌij ri Esteban, lik xpe koyowal y xkijeq kaqichꞌichꞌ ruwi keꞌ chirij rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Pero ri Esteban lik kꞌo ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios rukꞌ; xtzuꞌn kꞌu pana chikaj y xril runimal uchomalil ri Dios yey xrilo ri Jesús kꞌo puwikiqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xubꞌiꞌij kꞌu rire: «¡Riꞌin kanwilo jaqal ruwa kaj y kanwil pana Ralaxel Chikixoꞌl Tikawex kꞌo puwikiqꞌabꞌ ri Dios!» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ekꞌuchiriꞌ, ri winaq xkijeqo lik kesikꞌinik, xkitzꞌapij ri kixikin y xa jumul xebꞌek konoje chirij ri Esteban. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xkesaj kꞌu bꞌi chupa ri tinamit y xkijeqo kakiꞌan paꞌbꞌaj. Y ri xkimol kibꞌ chirij, xkiya kan ri kiqꞌuꞌ che jun ala Saulo rubꞌiꞌ chaꞌ kuchajij waꞌ chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ekꞌuchiriꞌ ketajin che uꞌanik paꞌbꞌaj ri Esteban, rire xuchꞌaꞌbꞌej ri Qanimajawal, jewaꞌ xubꞌiꞌij: «Wajawal Jesús, kꞌama la ri wanimaꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Tekꞌuchiriꞌ, xuxukubꞌaꞌ ribꞌ y ko xsikꞌinik: «Qajawal, kuyu la kimak che wa ketajin che uꞌanik» xchaꞌ. Y rukꞌ waꞌ, xkamik. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ri Saulo e jun chike ri xuya uchꞌaꞌtem chaꞌ kakamisax ri Esteban. Chupa kꞌu riꞌ laꞌ la jun qꞌij, lik xjeqer kiternabꞌexik rukꞌ kꞌax janipa ri kikojom rubꞌiꞌ ri Cristo chilaꞌ Jerusalem. Ruma kꞌu riꞌ, konoje xekich bꞌi chupa taq ri luwar re Judea y re Samaria. Xew chi rutaqoꞌn ri Jesús xekanaj kan Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","E kꞌo kꞌu jujun achijabꞌ lik kiyaꞌom kibꞌ puqꞌabꞌ ri Dios; rike xkimuq ri Esteban y lik xkoqꞌej rukamik. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Noꞌj ri Saulo ebꞌuternabꞌem rukꞌ kꞌax ri kikojom rubꞌiꞌ ri Cristo. Xok kꞌu chiꞌ taq ja re kebꞌuꞌcharej lo rachijabꞌ y rixoqibꞌ yey kebꞌuꞌyaꞌa pa cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","E taq kꞌu ri ekichom bꞌi kakitzijoj ri Utzilaj Tzij chupa ronoje luwar pa kebꞌopon wi. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Ri Felipe e jun chike. Rire xopon chupa jun tinamit re Samaria y xujeq katzijon puwi ri Cristo chikiwach ri winaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Waꞌ wa winaq xa jun kiꞌanom che utayik janipa ri kukꞌut ri Felipe, yey kakitzutzaꞌ taq ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios kuꞌan chikiwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ma lik e kꞌi ri e kꞌo pakiqꞌabꞌ itzelilaj uxlabꞌixel, yey waꞌ wa itzelilaj uxlabꞌixel kesikꞌinik kebꞌel bꞌi chike ri winaq. Y e kꞌo ukꞌiyal jetzꞌ y sik xekunutajik. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Ruma kꞌu riꞌ waꞌ, taq ri winaq re ri tinamit lik kekiꞌkotik. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Kꞌo kꞌu jun achi aj chiriꞌ Simón rubꞌiꞌ. E ri petinaq loq rire aj qꞌij chupa la tinamit; lik kebꞌusok ri winaq e aj Samaria ma kuꞌan che ribꞌ pachaꞌ lik kꞌo uwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Konoje kꞌu ri winaq chinimaꞌq chichꞌutiꞌq, lik kakita ri kubꞌiꞌij ri Simón y jewaꞌ kakibꞌiꞌij: «E unimal uchuqꞌabꞌ ri Dios ri kꞌo rukꞌ waꞌchi» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lik kakikoj ri kubꞌiꞌij, ma lik xex wi ebꞌusokom rukꞌ ri qꞌijonik kuꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Pero echiriꞌ xkita ri Utzilaj Tzij kutzijoj ri Felipe chwi rutaqanik ri Dios y chwi ri Qanimajawal Jesucristo, xkikojo y jekꞌuriꞌlaꞌ achijabꞌ yey ixoqibꞌ xkikꞌul ri bautismo. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ekꞌu riꞌ waꞌchi Simón xukoj rubꞌiꞌ ri Cristo y xukꞌul ne ri bautismo. Xujeq kꞌu riꞌ karachbꞌilaj ri Felipe y lik kakam ranimaꞌ che taq ri kꞌutubꞌal re ruchuqꞌabꞌ ri Dios karilo kuꞌan ri Felipe. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Yey ri e taqoꞌn re ri Cristo e kꞌo Jerusalem, echiriꞌ xkito ri e aj Samaria xkikoj ri ubꞌiꞌim lo ri Dios puwi ri Cristo, xekitaq bꞌi ri Pedro y ri Juan chilaꞌ Samaria. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Ekꞌuchiriꞌ rike xebꞌoponik, xkijeq kakiꞌan orar pakiwi ri aj Samaria ri kikojom chi rubꞌiꞌ ri Cristo chaꞌ rike kakikꞌul ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Ma ri Ruxlabꞌixel ri Dios kꞌamajaꞌ kaqaj puwi junoq chike, xew kikꞌulum ri bautismo pa rubꞌiꞌ ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Yey echiriꞌ ri Pedro y ri Juan xkiya ri kiqꞌabꞌ pakiwiꞌ, xkikꞌul ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Ekꞌu ri Simón xrilo suꞌanik ri tikawex kakikꞌul ri Ruxlabꞌixel ri Dios echiriꞌ ri taqoꞌn kakiya ri kiqꞌabꞌ pakiwiꞌ. Xubꞌiꞌtisij kꞌu puaq chike, ");
INSERT INTO acrNNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","jewaꞌ xubꞌiꞌij: —Yaꞌa alaq chwe riꞌin laꞌ la jun chuqꞌabꞌ, chaꞌ jelaꞌ xa tobꞌ china puwiꞌ kanya wi ri nuqꞌabꞌ, kukꞌul ri Santowilaj Ruxlabꞌixel ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Ekꞌuchiriꞌ, ri Pedro jewaꞌ xubꞌiꞌij che: —Sach na uwach rapuaq junam awukꞌ riꞌat, ma e chawach riꞌat, xa rukꞌ puaq kaloqꞌ rusipanik ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yey riꞌat na jinta kꞌana awe che wa chak kaqaꞌano ma rawanimaꞌ na jusukꞌ ta chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","E uwariꞌche, chatzelej atzij chwach ri Dios che waꞌ wa amak y chatzꞌonoj che Rire kukuy amak. Laj kukuy amak che la na utz taj xachꞌobꞌo. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Ma e kanwil riꞌin, lik uꞌanom kꞌax akꞌuꞌx chiqij y lik at yutum ruma ri mak —xcha ri Pedro che. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Ri Simón xukꞌul uwach: —Lik chꞌaw ko alaq panuwiꞌ chwach ri Qanimajawal chaꞌ na kankꞌulumaj ta kꞌana wa xbꞌiꞌij alaq chwe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Ekꞌuchiriꞌ ri Pedro y ri Juan kitzijom chi taq ri xkilo y xkita che ri Jesús y kiqꞌalajisam chi ri Utzilaj Tzij re ri Qanimajawal, xetzelej Jerusalem. Yey xaloqꞌ kꞌu xebꞌikꞌow chupa taq ukꞌiyal aldeas ke raj Samaria, xkitzijoj ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Kꞌo jun ángel re ri Qanimajawal xchꞌaꞌt rukꞌ ri Felipe, jewaꞌ xubꞌiꞌij che: «Chayijbꞌaꞌ awibꞌ y jat jewaꞌ pa sur. Chamaja bꞌi ri bꞌe kel Jerusalem, ri kaqaj pa ri tinamit Gaza» xchaꞌ. (Wa bꞌe kikꞌow pa taq luwar katzꞌintzꞌotik.) ");
INSERT INTO acrNNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Xyaktaj kꞌu ri Felipe y xumaj bꞌi ubꞌe yey pa ri bꞌe xuꞌriqa bꞌi jun achi “eunuco”. Waꞌ waꞌchi lik kꞌo uwach ma puqꞌabꞌ rire kꞌo wi ronoje rubꞌeyomal ri Candace. Ekꞌu waꞌchi xopon Jerusalem chaꞌ kuloqꞌnimaj uqꞌij ri Dios, ");
INSERT INTO acrNNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","yey e riꞌ katzelej pa rutinamit. Tzꞌul kꞌu chupa jun kareta y karajilaj Ruchꞌaꞌtem ri Dios tzꞌibꞌital kan ruma ri qꞌalajisanel Isaías. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Ekꞌu ri Ruxlabꞌixel ri Dios xubꞌiꞌij che ri Felipe: «Chatqibꞌ pana che la jun kareta y chatbꞌin putzal» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Echiriꞌ ri Felipe xqibꞌ apanoq, xuto rachi e karajilaj ri tzꞌibꞌam kan ruma ri qꞌalajisanel Isaías y jekꞌuwaꞌ xutzꞌonoj che: —¿Kamaj la usukꞌ la katajin la che rajilaxik? —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Rachi xukꞌul uwach: —¿Suꞌanik kanmaj usukꞌ we na jinta junoq kaqꞌalajisan chwe? —xcha che. Y xelaj kꞌu che ri Felipe chaꞌ kaqꞌan pa ri kareta y katzꞌuyiꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ekꞌu ri karajilaj che Ruchꞌaꞌtem ri Dios e waꞌ: Xkꞌam bꞌi e pachaꞌ juna bꞌexex re kakamisaxik; e pachaꞌ juna qꞌapoj bꞌexex na kachꞌaw ta kꞌenoq echiriꞌ kasokax ri rismal; jekꞌuriꞌlaꞌ rire na jinta kꞌana xubꞌiꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xꞌaniꞌ che pachaꞌ lik na jinta uwach; y echiriꞌ xqꞌat tzij puwiꞌ, xꞌan ri lik na e ta usukꞌ che. ¿China taq kꞌu ri tikawex kakipetebꞌej lo che rire? Na e jintaj, ma xqꞌat uqꞌij che ruwachulew. E waꞌ ri katajin che rajilaxik. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Ekꞌu waꞌchi aj Etiopía xutzꞌonoj che ri Felipe: —Maꞌan ko la riꞌ bꞌiꞌij la chwe, ¿china puwi kachꞌaꞌt wi ri qꞌalajisanel echiriꞌ kubꞌiꞌij waꞌ? ¿Chiribꞌil ribꞌ nawi kubꞌiꞌij wi o kachꞌaꞌt puwi junoq chik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ekꞌu ri Felipe xchꞌaꞌt rukꞌ rachi puwi waꞌ. Xujeq lo rukꞌ ri katajin che rajilaxik che Ruchꞌaꞌtem ri Dios y xutzijoj kꞌu che puwi ri Utzilaj Tzij re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","E kꞌo chi bꞌe echiriꞌ xebꞌopon pa jun luwar pa kꞌo wi yaꞌ. Ekꞌu riꞌ rachi aj Etiopía xubꞌiꞌij che ri Felipe: —Wara kꞌo yaꞌ. ¿Utz nawi riꞌin kankꞌul ri bautismo? —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Ri Felipe xubꞌiꞌij che: —We kakoj la rubꞌiꞌ ri Qanimajawal Jesucristo rukꞌ ronoje animaꞌ la, lik utz riꞌ —xcha che. Rachi xukꞌul uwach: —Riꞌin kankojo ri Qanimajawal Jesucristo e Rukꞌajol ri Dios —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Y xutaq kꞌu utakꞌabꞌaxik riꞌ ri kareta. Ekꞌu ri Felipe junam rukꞌ rachi xeqaj chupa ri yaꞌ. Tekꞌuchiriꞌ, ri Felipe xuya ri bautismo che. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Echiriꞌ xebꞌel lo chupa ri yaꞌ, xaqikꞌateꞌt ri Ruxlabꞌixel ri Dios Qajawxel xukꞌam bꞌi ri Felipe. Rachi aj Etiopía na xril ta chi uwach, pero lik kakiꞌkotik xumaj tanchi ubꞌi rubꞌe. ");
INSERT INTO acrNNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ekꞌu ri Felipe xeꞌyoꞌq chupa jun tinamit Azoto rubꞌiꞌ. Echiriꞌ xel bꞌi chiriꞌ, xikꞌow pa taq tinamit yey chujujunal tinamit pa xikꞌow wi, xutzijoj ri Utzilaj Tzij. Ekꞌu riꞌ xopon kꞌa chupa ri tinamit Cesarea. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ekꞌu ri Saulo na karoqꞌotaj taj kuxibꞌij kipa rukꞌ kamik janipa ri kikojom rubꞌiꞌ ri Qanimajawal. Xeꞌek kꞌu rukꞌ ri kajawal raj chakunel pa Rocho Dios ");
INSERT INTO acrNNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","y xutzꞌonoj bꞌi uwujil chaꞌ kayaꞌiꞌ puqꞌabꞌ kok pa taq ri sinagogas re ri tinamit Damasco. Jekꞌulaꞌ, we keburiq achijabꞌ o ixoqibꞌ e kukꞌil ri kitaqem wa kꞌakꞌ Bꞌe, kꞌo kꞌu puqꞌabꞌ riꞌ kebꞌuyut loq y kebꞌukꞌam lo Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ekꞌu ri Saulo e riꞌ kꞌo pan chi bꞌe che uꞌanik waꞌ, katajin kꞌu roponik chunaqaj ri tinamit Damasco, echiriꞌ xaqikꞌateꞌt ruwonibꞌal jun aqꞌ xpe chilaꞌ chikaj, xwol kaꞌn puwiꞌ y xusut rij. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ri Saulo xtzaq pulew y xuta kꞌu jun qulaj, jewaꞌ kubꞌiꞌij che: —Saulo, Saulo, ¿suꞌchak katchꞌoꞌjin chwij? —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ri Saulo xutzꞌonoj che: —¿Lal china rilal, Wajawal? —xchaꞌ. Jekꞌuwaꞌ xkꞌul uwach che: —Riꞌin in Jesús, ri Jun katchꞌoꞌjin chirij. Yey riꞌat, atukel nenareꞌ lik kaꞌan kꞌax che awibꞌ, jelaꞌ pachaꞌ juna bꞌoyex echiriꞌ kuya aqan che ri puya kachꞌik lo che —xuchixik. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Kabꞌirbꞌot kꞌu ri Saulo y uxiꞌim ribꞌ, jewaꞌ xubꞌiꞌij che: —Wajawal, ¿saꞌ ri kaꞌaj la kanꞌano? —xchaꞌ. Ri Qanimajawal xukꞌul uwach: —Chatyaktajoq y jat chupa ri tinamit, ma chiriꞌ kabꞌiꞌx wi chawe saꞌ ri chirajawaxik kaꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ekꞌu rachijabꞌ e rachbꞌiꞌil ri Saulo lik kixiꞌim kibꞌ xetakꞌiꞌik; ma xkita ri qulaj, noꞌj na jinta junoq xkil uwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Ri Saulo xyaktaj chwa rulew y xujaq kꞌu ruwach, pero na jinta chi kꞌo karilo ma xkanaj kan potzꞌ. Ewi xa xchꞌelex bꞌi che ruqꞌabꞌ kuma ri erachbꞌilam y xkꞌam bꞌi chupa ri tinamit Damasco. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Xkꞌojiꞌ kꞌu chilaꞌ oxibꞌ qꞌij; e laꞌ na katzuꞌn taj, na xwaꞌ taj y na jinta ne umiqꞌinaꞌ xutijo. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Chilaꞌ kꞌu riꞌ Damasco kꞌo jun achi Ananías rubꞌiꞌ; rire ukojom rubꞌiꞌ ri Cristo. Kꞌo kꞌu jun kꞌutubꞌal re ri Dios xqꞌalajisax chwach. Ri xrilo e ri Qanimajawal xukꞌut uwach chwach y jewaꞌ xubꞌiꞌij che: —¡Ananías! —xcha che. Rire xukꞌul uwach: —Riꞌ in kꞌolik, Wajawal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Xubꞌiꞌij kꞌu ri Qanimajawal che: —Chatyaktajoq y jat chupa ri bꞌe kabꞌiꞌx “Jusukꞌ” che. Yey chirocho kꞌu ri Judas, chatzꞌonobꞌej puwi jun achi aj Tarso, Saulo rubꞌiꞌ. Rire katajin pa oración ");
INSERT INTO acrNNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","y qꞌalajisam chi kꞌu jun kꞌutubꞌal re ri Dios chwach. Chupa waꞌ xril jun achi Ananías rubꞌiꞌ, e riꞌ kok bꞌi y kuya ruqꞌabꞌ puwiꞌ chaꞌ jelaꞌ katzuꞌn tanchik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Xubꞌiꞌij kꞌu ri Ananías che ri Qanimajawal: —Wajawal, lik nutom ronoje ri na utz taj uꞌanom waꞌ waꞌchi chike ri kikojom ri bꞌiꞌ la chilaꞌ Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Yey yaꞌtal ne lo puqꞌabꞌ kuma ri nimaq e aj chakunel pa Rocho Dios kebꞌukꞌam bꞌi pa cárcel konoje ri kikojom ri bꞌiꞌ la —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ekꞌu ri Qanimajawal xubꞌiꞌij che: —Jat chilaꞌ rukꞌ, ma Riꞌin nuchaꞌom rire chaꞌ kuꞌana jun waj chak re keꞌek che uqꞌalajisaxik ri nubꞌiꞌ chikiwach ri winaq na e ta aj judiꞌabꞌ, chikiwach ri e taqanelabꞌ y chikiwach ri e aj Israel. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Yey kankꞌut kꞌu che, janipa ri kꞌaxkꞌolil chirajawaxik kikꞌow wi rire ruma kutzijoj ri nubꞌiꞌ —xuchix ri Ananías. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ri Ananías xeꞌek kꞌut y xok pa ri ja pa kꞌo wi ri Saulo. Xuya kꞌu ruqꞌabꞌ puwiꞌ y xubꞌiꞌij che: «Hermano Saulo, ri Qanimajawal Jesucristo, ri xuqꞌalajisaj ribꞌ chawach chupa ri bꞌe pa at petinaq wi, inutaqom lo awukꞌ chaꞌ kat-tzuꞌn tanchik y kakꞌul kꞌu ri Santowilaj Ruxlabꞌixel ri Dios» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Chupa kꞌu laꞌ la joqꞌotaj, kꞌo ri pachaꞌ soloꞌt xtzaq che ruwach ri Saulo y xtzuꞌn tanchik. Tekꞌuchiriꞌ, xyaktajik y xukꞌul ri bautismo. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ekꞌuchiriꞌ xwaꞌ ri Saulo, xkꞌojiꞌ tanchi uchuqꞌabꞌ y xkꞌojiꞌ jujun qꞌij kukꞌ ri kikojom rubꞌiꞌ ri Cristo chilaꞌ pa ri tinamit Damasco. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Tekꞌuchiriꞌ, ri Saulo xujeq katzijon puwi ri Cristo chupa taq ri sinagogas, jewaꞌ ri kubꞌiꞌij: «Ri Jesús e Ukꞌajol ri Dios» kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Konoje ri ketaw re lik kakam kanimaꞌ che y kakibꞌiꞌij: «¿Na e ta nebꞌa achi waꞌ ebꞌuternabꞌem rukꞌ kꞌax ri kikojom rubꞌiꞌ ri Cristo chilaꞌ Jerusalem; yey kꞌuninaq ne wara re kebꞌuyut bꞌi y kebꞌuꞌyaꞌa pakiqꞌabꞌ ri nimaq e aj chakunel pa Rocho Dios?» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Pero ri Saulo jalan katajin unimarik ruchuqꞌabꞌ puwi ri kutzijoj. Ekꞌu raj judiꞌabꞌ ejeqel chiriꞌ Damasco xsach kinaꞌoj che ma ri Saulo kuqꞌalajisaj chikiwach: Ri Jesús e ri Cristo, Ruchaꞌoꞌn lo ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ikꞌowinaq chi kꞌu ukꞌiyal qꞌij, raj judiꞌabꞌ xkiꞌan tzij junam chikiwach re kakikamisaj ri Saulo. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Pero waꞌ xretaꞌmaj ri Saulo. Ekꞌo kꞌu ri kichajim chipaqꞌij chichaqꞌabꞌ taq ri okibꞌal re ri tinamit chaꞌ kakichap ri Saulo y kakikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ruma kꞌu riꞌ, ri kikojom rubꞌiꞌ ri Cristo e laꞌ chaqꞌabꞌ xkiqasaj bꞌi ri Saulo chwi ri tapia chupa jun nimalaj chakach. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Echiriꞌ xopon ri Saulo Jerusalem, lik xraj kaqibꞌ kukꞌ ri kikojom rubꞌiꞌ ri Cristo. Pero konoje rike lik kakixiꞌij kibꞌ che, ma na kakikoj taj we paqatzij wi ri Saulo ukojom chi rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ekꞌu ri Bernabé xukꞌam bꞌi y xuꞌyaꞌa chikiwach ri e taqoꞌn re ri Cristo. Xutzijoj kꞌu chike suꞌanik ri Saulo xril uwach ri Qanimajawal pa bꞌe y xchꞌaꞌt rukꞌ. Yey xutzijoj chike puwi ri tzijonik xuꞌan ri Saulo chupa rubꞌiꞌ ri Jesús chilaꞌ Damasco yey rukꞌ unimal uchuqꞌabꞌ xuꞌan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ekꞌu ri Saulo xkanaj kukꞌ chiriꞌ Jerusalem y xerachbꞌilaj pa taq kebꞌek wi. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Lik na kuxiꞌij ta ribꞌ katzijon chupa rubꞌiꞌ ri Qanimajawal. Kachꞌaꞌt kꞌu puwi ri Jesús kukꞌ raj judiꞌabꞌ ri kechꞌaꞌt pa ri chꞌaꞌtem griego; ruma kꞌu laꞌ, rike kakitzukuj suꞌanik kakikamisaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Echiriꞌ ri hermanos xketaꞌmaj waꞌ, xkikꞌam bꞌi ri Saulo kꞌa Cesarea y chiriꞌ kꞌut xkitaq bꞌi chupa ri tinamit Tarso. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","E taq kꞌu ri kikojom rubꞌiꞌ ri Cristo pa ronoje ri luwar re Judea, re Galilea y re Samaria, xekubꞌiꞌ chi utz ma na jinta chi ri keternabꞌex rukꞌ kꞌax. Rike kꞌo xiꞌin ibꞌ kukꞌ chwach ri Qanimajawal. Katajin kꞌu kikꞌiyarik yey yaꞌom kichuqꞌabꞌ y nimarisam kikꞌuꞌx ruma ri Santowilaj Ruxlabꞌixel ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Xaloqꞌ kꞌu ri Pedro katajin rikꞌowik pa taq riglesias, xopon kukꞌ ri kikojom rubꞌiꞌ ri Cristo pa ri tinamit Lida. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chilaꞌ kꞌu riꞌ xuꞌriqa jun achi Eneas rubꞌiꞌ, yey e wajxaqibꞌ lo junabꞌ riꞌ kꞌo chwa uwarabꞌal ma xuꞌan sik. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Ekꞌu ri Pedro jewaꞌ xubꞌiꞌij che: «Eneas, ri Qanimajawal Jesucristo katukunaj. Chatyaktajoq y chayijbꞌaꞌ rawarabꞌal» xcha che. Chupa kꞌu laꞌ la joqꞌotaj ri Eneas xtakꞌiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Konoje kꞌu ri ejeqel chupa ri tinamit Lida y pa taq ri luwar re Sarón xkilo ri Eneas kunutajinaq chik; y ruma kꞌu waꞌ, xkiya kibꞌ puqꞌabꞌ ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Chupa ri tinamit Jope kꞌo jun ixoq ukojom rubꞌiꞌ ri Cristo, Tabita rubꞌiꞌ. (Pa ri chꞌaꞌtem griego “Dorcas” kecha che.) Waꞌ wiꞌxoq lik uyaꞌom ribꞌ che uꞌanik ri utz y lik kebꞌutoꞌ ri nibꞌaꞌibꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Chupa taq laꞌ la qꞌij ri Dorcas xuchap yabꞌil y xkamik. Ekꞌuchiriꞌ xchꞌaj rucuerpo, xqꞌatisax chikaj pa ri kaleꞌ ja. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Ekꞌu ri hermanos e kꞌo Lida xkito kꞌo ri Pedro pa ri tinamit Jope, yey waꞌ xa naqaj kꞌo wuloq. Xekitaq kꞌu bꞌi kaꞌibꞌ achijabꞌ chaꞌ kebꞌeꞌelaj che ri Pedro, jewaꞌ kakibꞌiꞌij: «ꞌAna ko la riꞌ, peta la wara qukꞌ yey mamayin la.» ");
INSERT INTO acrNNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Xyaktaj kꞌu bꞌi ri Pedro y xeꞌek kukꞌ. Echiriꞌ xoponik, xkꞌam bꞌi chikaj pa ri kaleꞌ ja. E taq ri e malkaꞌnibꞌ xkisut rij ri Pedro. Konoje waꞌ kebꞌoqꞌik y kakikꞌut taq ri kꞌul y ri kiqꞌuꞌ xuꞌan ri Dorcas echiriꞌ kꞌa kꞌo kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ekꞌuchiriꞌ, ri Pedro xtaqan che konoje kebꞌel bꞌi. Xuxukubꞌaꞌ kꞌu ribꞌ y xuꞌan orar. Tekꞌuchiriꞌ, xutzuꞌ ri kaminaq, y jewaꞌ xubꞌiꞌij che: «¡Tabita, chatyaktajoq!» xchaꞌ. Ekꞌu riꞌ ri Dorcas xujaq ruwach; y echiriꞌ xrilo kꞌo ri Pedro chiriꞌ, asu xtzꞌuyiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Ekꞌu ri Pedro xuchap ruqꞌabꞌ y xuyako. Tekꞌuchiriꞌ, xebꞌusikꞌij ri kikojom rubꞌiꞌ ri Cristo kukꞌ taq ri hermanas e malkaꞌnibꞌ, y xuya kꞌu chikiwach e laꞌ kꞌaslik. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Waꞌ xetaꞌmax chupa ronoje ri luwar re Jope. Ruma kꞌu riꞌ, lik e kꞌi ri xkikoj rubꞌiꞌ ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Y ri Pedro xkanaj kan ukꞌiyal qꞌij chupa ri tinamit Jope, chirocho jun achi Simón rubꞌiꞌ, ri kutꞌis tzꞌuꞌum. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Pa ri tinamit Cesarea kꞌo jun achi Cornelio rubꞌiꞌ. Rire e capitán ke ri soldados e kukꞌil ri kabꞌiꞌx chike “E aj Italia”. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ri Cornelio lik jusukꞌ rubꞌinik usilabꞌik y lik kꞌo xiꞌin ibꞌ pa ranimaꞌ chwach ri Dios junam kukꞌ konoje ri ralkꞌoꞌal. Rire lik kuya puaq re toꞌbꞌal ke ri nibꞌaꞌibꞌ e aj judiꞌabꞌ y lik kuꞌan orar chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Kꞌo kꞌu jun qꞌij riꞌ, laj che ri urox ora bꞌenaq qꞌij xqꞌalajisax jun kꞌutubꞌal re ri Dios chwach. Ri xkꞌut che, e jun ángel re ri Dios e riꞌ xok chiriꞌ pa kꞌo wi rire y jewaꞌ xubꞌiꞌij che: —¡Cornelio! —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ri Cornelio lik xutzuꞌ ri ángel y rukꞌ xiꞌin ibꞌ xubꞌiꞌij che: —¿Saꞌ ri kaꞌaj la, wajawal? —xchaꞌ. Ri ángel xukꞌul uwach: —E taq ra oración y ri toꞌbꞌal ke ri nibꞌaꞌibꞌ aꞌanom riꞌat, waꞌ ukꞌulum ri Dios pachaꞌ jun qasaꞌn chwach Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ekꞌu ri kaꞌan woꞌora e chebꞌataqa bꞌi achijabꞌ pa ri tinamit Jope re keꞌkisikꞌij jun achi Simón rubꞌiꞌ, ri kabꞌiꞌx Pedro che. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Waꞌ waꞌchi jeqel chuchiꞌ ri mar pa rocho ri Simón, jun aj tꞌisol tzꞌuꞌum. Waꞌ wa Pedro kubꞌiꞌij chawe saꞌ ri lik chirajawaxik wi kaꞌano —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Echiriꞌ xel bꞌi ri ángel xchꞌaꞌt rukꞌ, ri Cornelio xebꞌusikꞌij kaꞌibꞌ raj chak y jun soldado lik kꞌo xiꞌin ibꞌ pa ranimaꞌ chwach ri Dios, waꞌ e jun chike ri e kꞌo puqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Xutzijoj na kꞌu chike ronoje ri xrilo; tekꞌuchiriꞌ, xebꞌutaq bꞌi pa ri tinamit Jope. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chukaꞌm qꞌij kꞌut echiriꞌ e kꞌo pan pa bꞌe e riꞌ katajin koponik chunaqaj ri tinamit, ri Pedro xaqꞌan chwi ri ja chaꞌ kuꞌana orar echiriꞌ ya katikꞌoj ri qꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Xpe kꞌu jun unimal numik che y lik xraj kawaꞌik. Katajin kꞌu uyijbꞌaxik ruwa echiriꞌ xaqikꞌateꞌt kꞌo xukꞌut ri Dios chwach. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ruwa kaj jaqalik. Kꞌo kꞌu pachaꞌ jun nimalaj kꞌul karipipik y ximital lo che ri kajibꞌ utzaꞌm, e riꞌ kaqasax lo che ruwachulew. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chupa waꞌ wa kꞌul e kꞌo ronoje kiwachlibꞌal awaj: waꞌ e ri kꞌo kajibꞌ kaqan, ri kecharar pulew yey ri kexikꞌikꞌ che ruwa kaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Yey xuta jun qulaj jewaꞌ xubꞌiꞌij: —Chatyaktajoq Pedro; chakamisaj y chatijaꞌ —xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pero ri Pedro xubꞌiꞌij che: —Na kanꞌan ta kꞌana riꞌ, Wajawal, ma riꞌin na jinta kꞌana kꞌo nutijom e laꞌ chꞌul o na taqal taj katijik —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xchꞌaw tanchi kꞌu ri jun qulaj, jewaꞌ xubꞌiꞌij che: —Ri ujosqꞌim chi ri Dios, riꞌat mabꞌiꞌij chꞌul che —xcha che ri Pedro. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Waꞌ oxlaj xuꞌano; tekꞌuchiriꞌ, ri nimalaj kꞌul xtzelej tanchi chilaꞌ chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ekꞌu ri Pedro katajin che utzꞌonoxik chiribꞌil ribꞌ saꞌ keꞌelawi ri xkꞌut chwach, echiriꞌ xekꞌun rachijabꞌ etaqom lo ruma ri Cornelio. Rike kitzꞌonobꞌem lo ri rocho ri Simón ri kutꞌis tzꞌuꞌum, yey woꞌora e kꞌo chwa ri puerta. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Xechꞌaw kꞌu apanoq y xkitzꞌonoj we chiriꞌ jeqel wi ri Simón, ri kabꞌiꞌx Pedro che. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ekꞌu ri Pedro kꞌa katajin ne che uchꞌobꞌik raqan puwi ri xkꞌut chwach, echiriꞌ ri Ruxlabꞌixel ri Dios xubꞌiꞌij che: «Chawilaꞌ, ma leꞌ oxibꞌ achijabꞌ katkitzukuj. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chatyaktajoq, chatqajoq y jat kukꞌ. Muxiꞌij ribꞌ akꞌuꞌx kateꞌek kukꞌ, ma in ri intaqayom lo ke» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Xqaj kꞌu lo ri Pedro pa e kꞌo wi rachijabꞌ etaqom lo ruma ri Cornelio, y xubꞌiꞌij chike: —Riꞌ in kꞌolik, in ri kintzukuj alaq. ¿Saꞌ ri petinaq wi alaq wukꞌ? —xcha chike. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Rike xkibꞌiꞌij che: —Kꞌo jun capitán aj Roma, Cornelio rubꞌiꞌ. Rire e jun achi lik jusukꞌ, kꞌo xiꞌin ibꞌ rukꞌ chwach ri Dios, yey chom ruchꞌaꞌtibꞌexik kaꞌan kuma konoje raj judiꞌabꞌ. Xbꞌiꞌx kꞌu che rire ruma jun santowilaj ángel re ri Dios, kutaq lo kꞌamik la re keꞌek la chirocho y jekꞌulaꞌ kuta ri kabꞌiꞌij la che —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ekꞌu ri Pedro xebꞌukoj bꞌi pa ja y xuya luwar chike kekanaj kan la jun aqꞌabꞌ chiriꞌ. Chukaꞌm qꞌij kꞌut xeꞌek kukꞌ, yey xekachbꞌilaj bꞌi jujun hermanos e aj pa ri tinamit Jope. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Chukaꞌm qꞌij kꞌut xebꞌopon pa ri tinamit Cesarea pa eroyeꞌem wi ri Cornelio. Rire umolom chi kichiꞌ ri ratz-uchaqꞌ y ri ramigos ri kꞌax kakinaꞌ kibꞌ rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Echiriꞌ xopon ri Pedro, xel lo ri Cornelio che ukꞌulik y xuxukubꞌaꞌ ribꞌ chwach re kuloqꞌoj uqꞌij. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pero ri Pedro xuyako y xubꞌiꞌij che: —Yaktaja la, ma riꞌin xa in jun achi pachaꞌ rilal —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Kachꞌaꞌt kꞌu rukꞌ ri Cornelio, xok bꞌi y xebꞌuꞌriqa ukꞌiyal tikawex kimolom kibꞌ chiriꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Xubꞌiꞌij kꞌu ri Pedro chike: —Lik etaꞌam ralaq, chiqaxoꞌl ri oj aj judiꞌabꞌ lik na ubꞌe taj we junoq chiqe kujunimaj ribꞌ o kaqibꞌ rukꞌ junoq na e ta kukꞌil raj judiꞌabꞌ. Noꞌj ri Dios xukꞌut chinuwach riꞌin na ubꞌe taj kanchꞌobꞌ raqan waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","E uwariꞌche, echiriꞌ xineꞌsikꞌixoq, na jampatana ximpetik y na jinta ne xintzꞌonoj we utz kanꞌan waꞌ. Ekꞌu woꞌora kantzꞌonoj che alaq, ¿suꞌchak xtaq alaq nukꞌamik? —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Ri Cornelio xukꞌul uwach: —E ukaj qꞌij waꞌ ikꞌowinaq je uꞌorayil waꞌ, riꞌin in kꞌo pa ayuno laj che ri urox ora bꞌenaq qꞌij, yey in kꞌo pa oración chiwocho echiriꞌ xwinaqir kꞌu chinuwach jun achi ukojom uqꞌuꞌ lik kawolqꞌinik ");
INSERT INTO acrNNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","y jewaꞌ xubꞌiꞌij chwe: “Cornelio, ri Dios utom ra oración y kꞌo chukꞌuꞌx janipa ri toꞌbꞌal ke ri nibꞌaꞌibꞌ aꞌanom. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Chataqa junoq chupa ri tinamit Jope re kuꞌsikꞌij ri Simón ri kabꞌiꞌx Pedro che. Rire kꞌo pa rocho ri Simón, jun achi aj tꞌisol tzꞌuꞌum kꞌo rocho chuchiꞌ ri mar. Yey echiriꞌ kakꞌunik, e rire ri kachꞌaꞌt awukꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","»Jekꞌuriꞌlaꞌ, xintaqalaꞌ kꞌamik la; y lik utz ri xꞌan la, ma xpe la. Ekꞌu woꞌora, qonoje oj kꞌo wara chwach ri Dios chaꞌ kaqata ronoje ri utaqom wi lo la chaꞌ kabꞌiꞌij la chiqe —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Ekꞌuchiriꞌ, xujeq kachꞌaꞌt ri Pedro, jewaꞌ xubꞌiꞌij: «Paqatzij wi woꞌora kanmaj usukꞌ ri Dios na kachaꞌw ta chikixoꞌl ri tikawex. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ma ri kuꞌano e lik kukꞌul ukꞌuꞌx echiriꞌ ri tikawex pa taq ronoje tinamit kꞌo xiꞌin ibꞌ kukꞌ chwach Rire y kakiꞌan ri lik jusukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kꞌo kꞌu ri xuqꞌalajisaj ri Dios chike ri e aj Israel; waꞌ e ri Utzilaj Tzij, ri kukꞌam lo utzil chomal ruma ri Jesucristo ri Qajawal qonoje. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","»Etaꞌam kꞌu ralaq saꞌ taq ri xuꞌan ri Jesús echiriꞌ ikꞌowinaq chi ri tzijonik re ri Juan chwi ri bautismo rukꞌ yaꞌ. Ri tzijonik puwi ri Jesús xujeq lo kꞌa Galilea y xeꞌek utzijoxik che ronoje ri luwar re Judea. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Xetaꞌmaj kꞌu ralaq saꞌ ri xuꞌan ri Dios; xuya che ri Jesús ri aj Nazaret lik kakꞌojiꞌ ri Santowilaj Ruxlabꞌixel y ruchuqꞌabꞌ Rire rukꞌ. Ekꞌu ri Jesús xeꞌek pa taq luwar re kuꞌan ri utz y kebꞌukunaj konoje ri eyaꞌom pa kꞌax ruma ritzel winaq. Xuꞌan taq kꞌu waꞌ ma ri Dios lik kꞌo rukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","»Ekꞌu riꞌoj lik qetaꞌam waꞌ ma xqil ronoje ri xuꞌan ri Jesús pa taq ri luwar re Judea y chilaꞌ Jerusalem. E waꞌ Rire ri xyaꞌiꞌ chwa cruz y xkamisaxik. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Pero churox qꞌij ri Dios xukꞌastajisaj lo ri Jesús chikixoꞌl ri ekaminaq y xuya che xukꞌut uwach chiqawach. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Na xukꞌut ta uwach chikiwach konoje ri tinamit, ma xew chikiwach ri ebꞌuchaꞌom chi lo ri Dios ojertan; waꞌ e riꞌoj, ri xojwaꞌ junam rukꞌ y xqatij qamiqꞌinaꞌ junam rukꞌ echiriꞌ kꞌastajinaq chi lo Rire chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","»Yey xojutaq kꞌu che utzijoxik che ri tinamit chaꞌ kaqaqꞌalajisaj e Rire ri Aj Qꞌatal Tzij ukojom ri Dios pakiwi ri e kꞌaslik y ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Puwi ri Jesús xetzijon lo konoje ri qꞌalajisanelabꞌ ojertan. Rike xkibꞌiꞌij e janipa ri kekojow re Rire, kakikꞌul ri kuybꞌal kimak ruma kikojom rubꞌiꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Kꞌa kachꞌaꞌt ne ri Pedro kukꞌ chwi taq waꞌ echiriꞌ xqaj ri Santowilaj Ruxlabꞌixel ri Dios pakiwi konoje ri ketaw re. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Yey e petinaq rukꞌ ri Pedro jujun e aj judiꞌabꞌ kikojom rubꞌiꞌ ri Cristo. Waꞌ lik xkam kanimaꞌ che, ma ri Santowilaj Ruxlabꞌixel ri Dios xqaj pakiwi ri na e ta aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Kekitataꞌ kꞌu riꞌ kechꞌaꞌt pa jujun chik chꞌaꞌtem yaꞌtal chike ruma ri Ruxlabꞌixel ri Dios y lik kakiyak uqꞌij ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ekꞌu ri Pedro xubꞌiꞌij: «¿Kꞌo nebꞌa junoq kaqꞌaten ke kakikꞌul ri bautismo rukꞌ yaꞌ? Ma rike xkikꞌul ri Santowilaj Ruxlabꞌixel ri Dios jelaꞌ pachaꞌ riꞌoj» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Xtaqan kꞌu che kayaꞌ ri bautismo chike pa rubꞌiꞌ ri Qanimajawal Jesucristo. Ekꞌuchiriꞌ, xebꞌelaj che ri Pedro chaꞌ kakanaj chi kebꞌ oxibꞌ qꞌij kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Ri e taqoꞌn re ri Jesús kukꞌ ri hermanos e kꞌo Judea xkito e kꞌo na e ta aj judiꞌabꞌ xekojow re Rutzij ri Dios puwi ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ruma kꞌu riꞌ, echiriꞌ xtzelej ri Pedro Jerusalem, ri hermanos e aj judiꞌabꞌ lik xkichap pa chꞌaꞌoj, ");
INSERT INTO acrNNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","jewaꞌ xkibꞌiꞌij che: «¿Suꞌchak xatok pa kocho ri na e ta aj judiꞌabꞌ y xatwaꞌ ne kukꞌ?» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ekꞌu ri Pedro xujeq utzijoxik chike chucholaꞌj suꞌanik xuꞌana waꞌ. Jekꞌuwaꞌ xubꞌiꞌij chike: ");
INSERT INTO acrNNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","«E riꞌin in kꞌo pa ri tinamit Jope e riꞌ kanꞌan orar echiriꞌ xaqikꞌateꞌt xqꞌalajisax jun kꞌutubꞌal re ri Dios chinuwach. Waꞌ pachaꞌ jun nimalaj kꞌul ximital lo che ri kajibꞌ utzaꞌm, xqasax lo chilaꞌ chikaj kꞌa pa la in kꞌo wi riꞌin. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Echiriꞌ xintzuꞌ chi utz saꞌ ri kꞌo chupa waꞌ, xebꞌenuwil kꞌu awaj kꞌo kajibꞌ kaqan, itzel taq chikop re upa juyubꞌ, awaj kecharar pulew, yey ri kexikꞌikꞌ che ruwa kaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","»Yey xinta kꞌu jun qulaj, jewaꞌ xubꞌiꞌij chwe: “Chatyaktajoq Pedro; chakamisaj y chatijaꞌ” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","»Ximbꞌiꞌij kꞌu riꞌin: “Na kanꞌan ta kꞌana riꞌ, Wajawal, ma riꞌin na jinta kꞌana chꞌul o na taqal taj katijik okinaq pa nuchiꞌ” xinchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","»Ekꞌuchiriꞌ, xchꞌaw tanchi lo ri jun qulaj chilaꞌ chikaj, jewaꞌ xubꞌiꞌij chwe: “Ri ujosqꞌim chi ri Dios, riꞌat mabꞌiꞌij chꞌul che” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","»Waꞌ oxlaj xuꞌano. Tekꞌuchiriꞌ, ronoje xkꞌam tanchi ubꞌi chikaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","»Chupa kꞌu laꞌ la joqꞌotaj xekꞌun oxibꞌ achijabꞌ chwa ri ja pa in kꞌo wi; rike e petinaq Cesarea, etaqom loq chaꞌ kinkitzukuj. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ekꞌu ri Ruxlabꞌixel ri Dios xubꞌiꞌij chwe kinꞌek kukꞌ y muxiꞌij ne ribꞌ nukꞌuꞌx kinꞌek. Xinꞌek kꞌu riꞌ kukꞌ; yey waꞌ wa waqibꞌ hermanos e aj Jope e kꞌo wara wukꞌ, xojkachbꞌilaj bꞌi. »Echiriꞌ xojopon Cesarea, xojok chirocho jun achi. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Yey waꞌchi xutzijoj chiqe suꞌanik xril uwach jun ángel chirocho. Waꞌ xoꞌltakꞌal chwach rire y jewaꞌ xubꞌiꞌij che: “Chebꞌataqa bꞌi achijabꞌ pa ri tinamit Jope re keꞌkisikꞌij jun achi Simón rubꞌiꞌ, ri kabꞌiꞌx Pedro che. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ekꞌu rire koluꞌbꞌiꞌij chawe suꞌanik katkolobꞌetaj riꞌat kukꞌ konoje ri ejeqel pa wocho” xcha ri ángel che. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","»Yey, echiriꞌ riꞌin xinjeqo kinchꞌaꞌt kukꞌ waꞌ wa tikawex na e ta aj judiꞌabꞌ, xqaj ri Santowilaj Ruxlabꞌixel ri Dios pakiwiꞌ jelaꞌ pachaꞌ xujeqebꞌej loq echiriꞌ xqaj paqawi ri oj aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","»Ekꞌuchiriꞌ, xkꞌun chinukꞌuꞌx rubꞌiꞌim kan ri Qanimajawal echiriꞌ xubꞌiꞌij: “Paqatzij wi, ri Juan xuya ri bautismo rukꞌ yaꞌ, noꞌj ri bautismo kikꞌul riꞌix e rukꞌ ri Santowilaj Ruxlabꞌixel ri Dios.” ");
INSERT INTO acrNNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","»Ekꞌu uwariꞌche, we ri Dios xuya chike rike wa sipanik jelaꞌ pachaꞌ ri xuya chiqe riꞌoj ri kubꞌul chi qakꞌuꞌx rukꞌ ri Qanimajawal Jesucristo, ¿in china riꞌin chaꞌ kanqꞌatej ri Dios che uꞌanikil waꞌ?» xcha ri Pedro. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Ekꞌuchiriꞌ xkita taq waꞌ, na jinta chi xkibꞌiꞌij chirij ri Pedro, e xkijeq kakiyak uqꞌij ri Dios, jewaꞌ xkibꞌiꞌij: «¡Uyaꞌom ne riꞌ ri Dios chike ri na e ta aj judiꞌabꞌ kakitzelej kitzij chwach chaꞌ jelaꞌ kꞌo kikꞌaslemal!» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Rukꞌ rukamik ri Esteban, xjeqer kiternabꞌexik rukꞌ kꞌax janipa ri kikojom rubꞌiꞌ ri Cristo. E taq kꞌu riꞌ waꞌ xekich bꞌi y xebꞌopon kꞌa chupa taq ri tinamit re Fenicia, re Chipre y ri tinamit Antioquía. Yey xew xkitzijoj kan ri Utzilaj Tzij re ri Jesucristo chike ri e aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Chikixoꞌl kꞌu wa hermanos e kꞌo e aj Chipre y e aj Cirene. Ekꞌu rike echiriꞌ xebꞌok Antioquía, xkijeq kakitzijoj ri Utzilaj Tzij re ri Qanimajawal Jesucristo chike ri na e ta aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Yey ruchuqꞌabꞌ ri Qanimajawal lik kꞌo pakiwi rike. Lik kꞌu e kꞌi ri tikawex xkikoj rubꞌiꞌ ri Cristo y xkijalkꞌatij ri kibꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ri kikojom rubꞌiꞌ ri Cristo e kꞌo Jerusalem, echiriꞌ xkita waꞌ, xkitaq bꞌi ri Bernabé chaꞌ keꞌek kꞌa chilaꞌ Antioquía. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Echiriꞌ xopon ri Bernabé y xril ri unimal rutzil ukꞌuꞌx ri Dios kukꞌ ri kikojom rubꞌiꞌ ri Cristo, lik xkiꞌkot che. Y xebꞌupixabꞌaj konoje chaꞌ rukꞌ ronoje kikꞌuꞌx kakichuqꞌubꞌej kibꞌ chwach ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Ri Bernabé e jun achi lik utz ukꞌuꞌx, ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios lik kꞌo rukꞌ y lik kꞌo kubꞌulibꞌal ukꞌuꞌx. Ruma kꞌu ruchak rire, lik e kꞌi ri tikawex xkikoj rubꞌiꞌ ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Tekꞌuchiriꞌ, ri Bernabé xeꞌek pa ri tinamit Tarso re kuꞌtzukuj ri Saulo. Echiriꞌ xuriqo, xukꞌam lo Antioquía. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Xekꞌojiꞌ kꞌu kukꞌ ri tinamit re ri Cristo ronoje ri jun junabꞌ, e riꞌ kekꞌutun chikiwach ukꞌiyal winaq. Chiriꞌ kꞌu riꞌ, nabꞌe laj xbꞌiꞌx “cristianos” chike ri kikojom rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Chupa taq riꞌ laꞌ la qꞌij e kꞌo jujun eqꞌalajisay runaꞌoj ri Dios xebꞌel bꞌi Jerusalem y xebꞌopon Antioquía. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Kꞌo jun chike waꞌ, Ágabo rubꞌiꞌ. Rire xyaktajik y ruma ri Ruxlabꞌixel ri Dios, xuqꞌalajisaj kape jun unimal numik chwi ronoje ruwachulew pa ejeqel wi ri winaq. (Waꞌ xuꞌana chupa rutaqanik ri Claudio.) ");
INSERT INTO acrNNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Ruma kꞌu waꞌ, ri kikojom rubꞌiꞌ ri Cristo e kꞌo Antioquía xkiyijbꞌaꞌ chikiwach chaꞌ kakitaq pan toꞌbꞌal chike ri hermanos ejeqel Judea; chikijujunal kꞌu riꞌ xkichꞌobꞌ raqan janipa ri kakiyaꞌo, waꞌ e chirij taq ri kꞌo kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Y jelaꞌ xkiꞌano; xkitaq bꞌi ri kiqasaꞌn pakiqꞌabꞌ ri Bernabé y ri Saulo chaꞌ kakikꞌam bꞌi Judea y kakiya chike ri e aj wach re riglesia. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Chupa taq kꞌu riꞌ laꞌ la qꞌij ri rey Herodes xebꞌutaq jujun soldados chaꞌ kekichap jujun chike ri kikojom rubꞌiꞌ ri Cristo re keyaꞌ pa kꞌaxkꞌobꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Yey xebꞌutaq che kakikamisaj rukꞌ espada ri Jacobo ri ratzixel ri Juan. Y ri soldados jelaꞌ xkiꞌano. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Ekꞌuchiriꞌ xrilo lik xukꞌul kikꞌuꞌx raj judiꞌabꞌ ri xꞌan che ri Jacobo, xutaq uchapik ri Pedro. Waꞌ xuꞌan chupa ri nimaqꞌij Pascua echiriꞌ katij ri pam na jinta levadura che. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Ekꞌuchiriꞌ chapom chi ri Pedro, ri Herodes xutzꞌapij pa cárcel y xuya pakiqꞌabꞌ kajibꞌ mutzaꞌj soldados re kakichajij, yey wa soldados e kajkaj chujujunal mutzaꞌj. Ri xuchꞌobꞌ ri Herodes e kꞌate karesaj lo ri Pedro chikiwach ri winaq re ri tinamit echiriꞌ ikꞌowinaq chi ri nimaqꞌij Pascua. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kꞌo kꞌu riꞌ ri Pedro pa cárcel lik chajital chi utz. Yey ri kikojom rubꞌiꞌ ri Cristo na kebꞌuxlan ta che uꞌanik orar chwach ri Dios puwiꞌ rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Chupa kꞌu raqꞌabꞌ chwach pan ri qꞌij echiriꞌ ri rey Herodes uchꞌobꞌom karesaj lo ri Pedro chikiwach ri tinamit, ri Pedro e riꞌ kawar chikixoꞌl kaꞌibꞌ soldados, ximital rukꞌ kaꞌibꞌ karena yuqul lo chike ri soldados. Yey pa rewi raj chajal e kꞌo chwach ri okibꞌal re ri cárcel. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Xaqikꞌateꞌt kꞌut xwinaqir jun ángel re ri Qanimajawal rukꞌ, yey jun aqꞌ lik xutzij upa ri cárcel. Ri ángel xuyuchꞌuyaꞌ ri Pedro pukꞌalkꞌaꞌx, xukꞌosoj y jekꞌuwaꞌ xubꞌiꞌij che: «Chatwaꞌlijoq, chawilij» xcha che. E taq kꞌu ri karena kꞌo che ruqꞌabꞌ ri Pedro xtzaqik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Xubꞌiꞌij kꞌu ri ángel che: «Chaximilaꞌ bꞌi rakoton y raxajabꞌ» xcha che. Y rire jelaꞌ xuꞌano. Xubꞌiꞌij tanchi ri ángel che: «Chakojo bꞌi raqꞌuꞌ re pisbꞌal awij y chat-tereja lo chwij» xcha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Ri Pedro xel bꞌi teran chirij ri ángel, tobꞌ na retaꞌam taj we qatzij ri kuꞌan ri ángel rukꞌ; ma chwach rire, laj xa wachikꞌ la katajin che rilik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xebꞌikꞌow kꞌu chikiwach ri nabꞌe mutzaꞌj e chajinel. Tekꞌuchiriꞌ, xebꞌikꞌow che rukaꞌm mutzaꞌj e chajinel y xebꞌopon kꞌu chwach ri okibꞌal ꞌanom rukꞌ chꞌichꞌ, waꞌ e ri kel bꞌi pa bꞌe chupa ri tinamit. Waꞌ wa okibꞌal utukel xjaqataj chikiwach y jelaꞌ xebꞌel bꞌi. Xebꞌin kꞌu jubꞌiqꞌ che ri bꞌe y xaqikꞌateꞌt ri ángel xuya kan ri Pedro utukel. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Kꞌa ekꞌuchiriꞌ ri Pedro xumaj usukꞌ na wachikꞌ ta ri kuꞌano. Xubꞌiꞌij kꞌu chiribꞌil ribꞌ: «Woꞌora paqatzij wi, kanmaj usukꞌ e ri Qanimajawal utaqom lo ru ángel wukꞌ. Jelaꞌ xinresaj puqꞌabꞌ ri rey Herodes y che ronoje ri kakaj kakiꞌan rukꞌiyal e aj judiꞌabꞌ chwe» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ekꞌu laꞌ katajin waꞌ pujolom ri Pedro, xeꞌek chirocho ri María ruchu ri Juan, ri kabꞌiꞌx Marcos che. Chiriꞌ kimolom wi kibꞌ ukꞌiyal hermanos ketajin pa oración chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Echiriꞌ ri Pedro xuchꞌawisaj pan ri puerta re ruwa ja, jun ali aj chak Rode rubꞌiꞌ, xel lo che. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Ekꞌuchiriꞌ xuto e uqul ri Pedro, ruma rukiꞌkotemal na xujaq ta ri puerta. Ri xuꞌano e kanik xok tanchi ubꞌi pa ja y xuꞌtzijoj chike kꞌo ri Pedro chwach ri puerta. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ekꞌu ri e kꞌo pa ja xkibꞌiꞌij che: —Riꞌat xatchꞌuꞌjerik —xecha che. Pero rali xujikibꞌaꞌ uwach chike lik qatzij la kubꞌiꞌij. Yey xkibꞌiꞌij rike: —Laj e u ángel ri kꞌo chiriꞌ —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Ekꞌu ri Pedro lik chak kꞌo che uchꞌawisaxik pan ri puerta. Ekꞌuchiriꞌ xkijaqo yey xkil ri Pedro, lik xkam kanimaꞌ che; ma lik kꞌayew chike kakikojo we qatzij ri ketajin che rilik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pero ri Pedro xuꞌan jun kꞌutubꞌal rukꞌ ruqꞌabꞌ chaꞌ ketzꞌinkaꞌnik. Xutzijoj kꞌu chike suꞌanik xesax lo ruma ri Qanimajawal chupa ri cárcel. Yey xubꞌiꞌij kꞌu chike: —Tzijoj alaq waꞌ che ri Jacobo y chike taq ri hermanos —xchaꞌ. Tekꞌuchiriꞌ, xel bꞌi y xeꞌek pa jun chik luwar. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Echiriꞌ xsaqirik, xok jun sachibꞌal naꞌoj chikixoꞌl ri soldados. Xkijeq ketukukik ruma na ketaꞌam taj saꞌ ri xuꞌan ri Pedro, ma na jinta chik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Ekꞌu ri Herodes xutaq utzukuxik ri Pedro. Yey ruma na xriqitaj taj, e xuta kichiꞌ ri soldados; tekꞌuchiriꞌ, xutaq kikamisaxik. Echiriꞌ xuꞌan waꞌ, ri Herodes xel bꞌi Judea y xeꞌek pa ri tinamit Cesarea y chiriꞌ xkanaj wi. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ri rey Herodes lik kꞌo royowal chikij ri winaq e aj Tiro y e aj Sidón. Ekꞌu riꞌ wa kebꞌ tinamit xkichꞌaꞌbꞌej kibꞌ chikiwach re kebꞌeꞌchꞌaꞌta rukꞌ ri rey Herodes chaꞌ kakiꞌan utzil chomal chikiwach rukꞌ. Kꞌo kꞌu jun achi Blasto rubꞌiꞌ, waꞌ raj chak ri rey yey lik kꞌo uwach pa ri rocho ri rey. Xkikoj kꞌu kibꞌ chwach ri Blasto y xkipuaqij che chaꞌ rire kachꞌaw pakiwiꞌ chwach ri rey chaꞌ na jinta chi chꞌaꞌoj chikiwach. Y jelaꞌ raj kꞌay re rutinamit ri Herodes utz kakikꞌayij ri kajawax chike ri e aj Tiro y aj Sidón. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ri rey Herodes xukoj kꞌu jun qꞌij chike re kakimol kibꞌ. Laꞌ la jun qꞌij xuwiq ribꞌ rukꞌ chomilaj kꞌul kꞌi rajil, xtzꞌuyiꞌ pa ri qꞌatbꞌal tzij y xuya kꞌu jujun uchꞌaꞌtem chikiwach ri tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ekꞌu ri winaq xkijeqo lik ko kesikꞌinik kakibꞌiꞌij: «¡Waꞌ wa kaqato, na uqul ta juna achi; e uqul jun tiox!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Xa pa joqꞌotaj kꞌu riꞌ jun ángel re ri Qajawal xukoj lo jun yabꞌil che ri Herodes; ma rire xukꞌul wa yakbꞌal uqꞌij xꞌanik, yey waꞌ xew taqal che ri Dios. Jekꞌuriꞌlaꞌ xtijiꞌ kuma amolo y ruma waꞌ xkamik. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Noꞌj kꞌu ri Utzilaj Tzij re ri Qanimajawal lik xeꞌek utzijoxik y lik katajin kikꞌiyarik ri kekojow re. ");
INSERT INTO acrNNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Echiriꞌ ri Bernabé y ri Saulo xkikꞌis ri chak yaꞌom chike, xebꞌel chiriꞌ Jerusalem y xkikꞌam bꞌi ri Juan kukꞌ, ri kabꞌiꞌx Marcos che. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Chilaꞌ Antioquía chikixoꞌlibꞌal ri kikojom rubꞌiꞌ ri Cristo, e kꞌo eqꞌalajisay runaꞌoj ri Dios y e kꞌutunel re Rutzij. Waꞌ e: ri Bernabé, ri Simón ri kabꞌiꞌx qꞌeq che, ri Lucio aj Cirene, ri Manaén ri xkꞌiyisax pa rocho ri Herodes ri rey re Galilea y ri Saulo. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Kꞌo kꞌu jun qꞌij echiriꞌ rike kimolom kibꞌ re kakiloqꞌnimaj uqꞌij ri Qanimajawal yey e kꞌo pa ayuno, ri Santowilaj Ruxlabꞌixel ri Dios xubꞌiꞌij chike: «Chebꞌichaꞌa ri Bernabé y ri Saulo chwe chaꞌ kakiꞌan ri chak nuyaꞌom chi lo pakiqꞌabꞌ» xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Echiriꞌ xkikꞌis ri oración y ayuno, xkiya ri kiqꞌabꞌ pakiwi rike y xekitaq kꞌu bꞌi. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Ekꞌu ri Bernabé y ri Saulo e laꞌ etaqom bꞌi ruma ri Santowilaj Ruxlabꞌixel ri Dios, xebꞌopon kꞌu Seleucia. Chiriꞌ xebꞌel bꞌi pa barco y xebꞌek pa ri isla Chipre. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Echiriꞌ xebꞌopon Salamina, jun tinamit re Chipre, xkijeq utzijoxik Rutzij ri Dios puwi ri Qanimajawal Jesucristo pa taq sinagogas ke raj judiꞌabꞌ. Yey kꞌo ri Juan kukꞌ re kitoꞌbꞌel. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xebꞌikꞌow kꞌu chupa ronoje ri isla Chipre y xebꞌopon kꞌa chupa ri tinamit Pafos. Chiriꞌ xkiriq jun achi e kukꞌil raj judiꞌabꞌ; rire aj qꞌij yey e jun qꞌalajisanel xa kasokosoꞌnik. Waꞌ waꞌchi Barjesús rubꞌiꞌ, yey pa ri chꞌaꞌtem griego “Elimas” kecha che. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Waꞌ wa aj qꞌij kꞌo rukꞌ ri taqanel Sergio Paulo, jun achi lik kꞌo unaꞌoj. Ri taqanel xebꞌusikꞌij ri Bernabé y ri Saulo, ma lik kurayij kuta Rutzij ri Dios puwi ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Pero rachi aj qꞌij xutij riꞌ che kebꞌuqꞌatej ri Bernabé y ri Saulo chaꞌ ri taqanel na kukubꞌaꞌ ta ukꞌuꞌx che ri Utzilaj Tzij re ri Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Ekꞌu ri Saulo (ri kabꞌiꞌx Pablo che) rukꞌ ruchuqꞌabꞌ ri Santowilaj Ruxlabꞌixel ri Dios xuchꞌikibꞌaꞌ ruwach puwi ri Elimas, ");
INSERT INTO acrNNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","y jewaꞌ xubꞌiꞌij che: «¡Rilal lal nojinaq che ronoje sokosoꞌnik y che ronoje itz! ¡Lal ralkꞌoꞌal ritzel winaq, ri jun aj retzelal kꞌuꞌx chirij ronoje ri jusukꞌ! ¿Suꞌchak na koqꞌotaj ta la ri kajechꞌij la ri jusukꞌ bꞌe re ri Qanimajawal? ");
INSERT INTO acrNNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Ekꞌu woꞌora ruqꞌabꞌ ri Qanimajawal kayaktaj chiꞌij la y kuꞌan potzꞌ cheꞌla; xew kꞌu ri Dios etaꞌmayom janipa qꞌij na kil ta la ri qꞌijsaq» xchaꞌ. Na jampatana kꞌut ronoje xuꞌan qꞌequꞌm chwach y xujeq kamalal pa taq utzal y chirij, kutzukuj china kakꞌamaw bꞌi che ruqꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Ekꞌuchiriꞌ ri taqanel xril wa xukꞌulumaj ri Elimas, xukoj rubꞌiꞌ ri Qanimajawal Jesucristo, y lik kaminaq ranimaꞌ che ri kꞌutunik chwi ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ri Pablo junam kukꞌ ri rachbꞌiꞌil xebꞌel bꞌi Pafos pa barco y xebꞌopon Perge pa ri luwar re Panfilia. Pero ri Juan xresaj kan ribꞌ chikij y xtzelej Jerusalem. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Ekꞌu rike xebꞌikꞌow Perge y xebꞌopon Antioquía pa ri luwar re Pisidia. Chupa kꞌu jun qꞌij re uxlanibꞌal xebꞌok pa ri sinagoga y xetzꞌuyiꞌik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Ekꞌuchiriꞌ ajilam chi jujun che Rutzij Upixabꞌ ri Dios tzꞌibꞌital kan ruma ri Moisés y kuma ri qꞌalajisanelabꞌ, raj wach re ri sinagoga xkitaq lo ubꞌiꞌxikil chike: «Alaq qatz-qachaqꞌ, we kꞌo juna chꞌaꞌtem alaq re pixabꞌanik che ri tinamit, chꞌaw alaq» xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Xtakꞌiꞌ kꞌu ri Pablo y xuꞌan jun kꞌutubꞌal rukꞌ ruqꞌabꞌ chaꞌ na jinta kꞌo kachꞌawik y xubꞌiꞌij: «Alaq achijabꞌ aj Israel y onoje alaq ri kꞌo xiꞌin ibꞌ pa animaꞌ alaq chwach ri Dios, tape alaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ri Dios re wa tinamit Israel xebꞌuchaꞌ ri qatiꞌ-qamam ojertan y xuꞌan jun nimalaj tinamit chike echiriꞌ kꞌa e kꞌo Egipto, tobꞌ rike na e ta aj chiriꞌ. Rukꞌ kꞌu unimal uchuqꞌabꞌ riꞌ xebꞌeresaj lo Egipto. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","»Laj juna cuarenta junabꞌ kꞌu riꞌ xebꞌukuy ri Dios rutinamit rukꞌ ri kimakunik pa ri luwar katzꞌintzꞌotik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Tekꞌuchiriꞌ, xusach kiwach wuqubꞌ nimaq tinamit pa ri luwar re Canaán y xuya kꞌu chike ri qatiꞌ-qamam kekanaj kan rukꞌ wa ulew. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Laj ikꞌowinaq chi kajibꞌ ciento junabꞌ rukꞌ nikꞌaj chwi lo echiriꞌ rutinamit ri Dios xebꞌopon Egipto, kꞌa ekꞌuchiriꞌ xekanaj kan pa rulew ubꞌiꞌtisim lo ri Dios chike. »Ekꞌuchiriꞌ, ri Dios xebꞌuya e aj qꞌatal tzij re ketaqan pakiwi rutinamit. Jelaꞌ uꞌanom kꞌa chwa ri qꞌalajisanel Samuel. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Chupa kꞌu rutaqanik ri Samuel, ri tinamit xkitzꞌonoj che ri Dios kuya juna kirey. Ekꞌu ri Dios xukoj ri Saúl pakiwiꞌ. Ri Saúl e ukꞌajol ri Cis, jun achi upetebꞌem chike ri ralkꞌoꞌal kan ri Benjamín. Cuarenta junabꞌ kꞌu xtaqan pakiwiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Ekꞌuchiriꞌ ri Dios xresaj ri rey Saúl pakiwiꞌ, e xukoj ri David re kataqan pukꞌaxel. Chwi kꞌu ri David lik chom xchꞌaꞌt ri Dios, ma jewaꞌ xubꞌiꞌij: E wilom che ri David rukꞌajol ri Isaí, rire jun achi lik kakiꞌkot nukꞌuꞌx rukꞌ ma kuya ranimaꞌ kuꞌano janipa ri kantaq che xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","»Ekꞌu chirij rubꞌiꞌtisim lo chike ri e ralkꞌoꞌal kan ri David, ri Dios e xuyak ri Jesús re Kolobꞌenel ke raj Israel. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Echiriꞌ ri Jesús kꞌamajaꞌ kujeq ri chak taqom lo che uꞌanik chikiwach ri winaq, xtzijon ri Juan puwi ri bautismo re tzelebꞌal tzij chike konoje ri tinamit Israel. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ekꞌuchiriꞌ ri Juan katajin che ukꞌisik ruchak, xubꞌiꞌij: “Chiwach riꞌix ¿in china riꞌin? Riꞌin na in ta ri Kolobꞌenel oyeꞌem alaq. Noꞌj katajin kꞌu lo ukꞌunik Jun chwij, yey riꞌ na taqal tane chwe riꞌin kankir ruxajabꞌ che ri raqan” xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","»Alaq qatz-qachaqꞌ, alaq ralkꞌoꞌal kan ri Abraham y onoje alaq ri kꞌo xiꞌin ibꞌ ukꞌ alaq chwach ri Dios, che kꞌu ralaq taqom wi lo ri Utzilaj Tzij re kolobꞌetajik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Yey ri ejeqel Jerusalem kukꞌ ri e aj wach ke, na xketaꞌmaj taj ri Jesús e Uchaꞌoꞌn lo ri Dios y na xkimaj tane usukꞌ ri tzꞌibꞌital kan kuma ri qꞌalajisanelabꞌ puwi ri Jesús, tobꞌ waꞌ kakajilaj ronoje qꞌij re uxlanibꞌal. Yey echiriꞌ rike xkitzꞌonoj rukamik ri Jesús, e xkiꞌan kꞌu ri tzꞌibꞌital kan puwi Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Y tobꞌ na jinta kꞌo xkiriq chirij ri Jesús re kakamisaxik, xkitzꞌonoj che ri Pilato kutaq ukamisaxik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Echiriꞌ xkikꞌis uꞌanik rukꞌ ri Jesús janipa ri tzꞌibꞌital kan puwi Rire, xkiqasaj lo chwa ri cruz y xeꞌkimuquꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","»Pero ri Dios xukꞌastajisaj lo ri Jesús chikixoꞌl ri ekaminaq. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Tekꞌuchiriꞌ, ri Jesús ukꞌiyal qꞌij xukꞌut uwach chikiwach ri xerachbꞌilaj chwi echiriꞌ xebꞌel lo Galilea y xebꞌek rukꞌ kꞌa Jerusalem. E taq kꞌu riꞌ waꞌ ri ketzijow re ri Jesús chikiwach ri tinamit woꞌora. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","»Jekꞌulaꞌ riꞌoj kaqatzijoj che alaq ri Utzilaj Tzij, ri bꞌiꞌtisim lo chike ri qatiꞌ-qamam ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Yey wa bꞌiꞌtisinik yaꞌom chi chiqe riꞌoj ri oj kalkꞌoꞌal kan rike. Ma ri Dios xuꞌan waꞌ echiriꞌ xukꞌastajisaj lo ri Jesús chikixoꞌl ri ekaminaq, jelaꞌ pachaꞌ ri tzꞌibꞌital chupa rukaꞌm Salmo: Riꞌat at Nukꞌajol yey Riꞌin in Aqaw; waqꞌij kꞌu riꞌ kanqꞌalajisaj waꞌ kachaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","»Yey ri Dios ubꞌiꞌim kukꞌastajisaj lo ri Jesús chikixoꞌl ri ekaminaq chaꞌ jelaꞌ rucuerpo na kaqꞌay taj, ma jewaꞌ xubꞌiꞌij pa Ruchꞌaꞌtem puwi waꞌ: Kankꞌut na ri kꞌaxnaꞌbꞌal nukꞌuꞌx chiwach, jelaꞌ pachaꞌ ri nubꞌiꞌtisim lo che ri David. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E uwariꞌche jewaꞌ kubꞌiꞌij pa jun chik Salmo: Rilal na kaya ta la luwar che kaqꞌay rucuerpo ri Jun lik uyaꞌom ribꞌ paqꞌabꞌ la xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","»Ma paqatzij wi ri David xuꞌan ri xraj ri Dios rukꞌ echiriꞌ kꞌo che ruwachulew, pero xopon ri qꞌij xkamik y xmuq pa emuqum wi ruchu-uqaw, y rucuerpo xqꞌayik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Noꞌj rucuerpo ri Jun ri xukꞌastajisaj bꞌi ri Dios, na xqꞌay taj. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","»Chetaꞌmaj kꞌu alaq waꞌ, alaq watz-nuchaqꞌ: Ruma ri xuꞌan ri Cristo, katzijox che alaq suꞌanik kariq alaq ri kuybꞌal mak chwach ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ruma kꞌu ri Cristo, konoje ri kakubꞌiꞌ kikꞌuꞌx rukꞌ Rire, kaꞌaniꞌ jusukꞌ chike. Yey waꞌ na kariqitaj ta kꞌana ruma ri kataqex ri Tzij Pixabꞌ tzꞌibꞌital kan ruma ri Moisés. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","»Chajij kꞌu ibꞌ alaq chaꞌ na kape ta pawiꞌ alaq ri ubꞌiꞌim lo ri Dios chupa ri tzꞌibꞌital kan kuma ri qꞌalajisanelabꞌ: ");
INSERT INTO acrNNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","Chiwilapeꞌ, ix aj chꞌaminel re ri Nutzij, lik kakam na kꞌu iwanimaꞌ che y kasach ne iwach ruma waꞌ: Riꞌin kanꞌan jun chak chupa taq wa qꞌij ix kꞌo wi, jun chak na kikoj taj, tobꞌ ne kꞌo junoq katzijow re chiwe xcha ri Dios.» Rukꞌ waꞌ xukꞌisbꞌej ri Pablo. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ekꞌuchiriꞌ ri Pablo y ri Bernabé xebꞌel bꞌi pa ri sinagoga, ri e kꞌo chiriꞌ xebꞌelaj chike chaꞌ ri jun chik qꞌij re uxlanibꞌal kechꞌaꞌt kukꞌ rike chwi taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Echiriꞌ xebꞌel bꞌi konoje ri kimolom kibꞌ pa ri sinagoga, e kꞌi xeterej bꞌi chikij ri Pablo y ri Bernabé. Chikixoꞌl waꞌ e kꞌo raj judiꞌabꞌ y jujun chik kitaqem lo ri kꞌutunik ke raj judiꞌabꞌ (tobꞌ na e ta aj judiꞌabꞌ, pero lik kakiloqꞌoj uqꞌij ri Dios). Ekꞌu ri Pablo y ri Bernabé lik xekipixabꞌaj chaꞌ ketikiꞌ chupa ri unimal rutzil ukꞌuꞌx ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Chupa kꞌu ri jun chik qꞌij re uxlanibꞌal, ya laj konoje ri winaq re ri tinamit xkimol kibꞌ chaꞌ kakita Rutzij ri Dios puwi ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Pero echiriꞌ raj judiꞌabꞌ xekil rukꞌiyal winaq, xujeq katiꞌtot kikꞌuꞌx chirij ri Pablo. Y xkijeq kꞌu kakikꞌulaliꞌaj uwach ronoje ri kubꞌiꞌij rukꞌ kꞌaxlaj chꞌaꞌtem. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ekꞌuchiriꞌ, ri Pablo y ri Bernabé, rukꞌ unimal kichuqꞌabꞌ, xkibꞌiꞌij chike: —Paqatzij wi lik chirajawaxik nabꞌe na katzijox che ralaq ri alaq aj judiꞌabꞌ Rutzij ri Dios puwi ri Qanimajawal. Pero ruma kꞌu ri na kakꞌul ta alaq, jelaꞌ kaqꞌalajinik na taqal ta ri kꞌaslemal na jinta utaqexik che alaq. Ruma kꞌu laꞌ keꞌqatzijoj chike ri na e ta aj judiꞌabꞌ, ");
INSERT INTO acrNNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ma jelaꞌ ri ojutaqom lo ri Dios Qajawxel che uꞌanik. E pachaꞌ ri ubꞌiꞌim lo Rire echiriꞌ xubꞌiꞌij: Riꞌin atnukojom re Qꞌijsaq chikiwach taq ri tinamit chaꞌ jelaꞌ kuꞌana at kꞌamal bꞌi re ri kolobꞌetajik kꞌa pa taq ri luwar lik naj che ruwachulew —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Echiriꞌ xkita waꞌ ri na e ta aj judiꞌabꞌ, lik xekiꞌkot che y xkijeqo kakiyak uqꞌij ri Utzilaj Tzij puwi ri Qanimajawal. Jekꞌulaꞌ xkikoj rubꞌiꞌ ri Cristo konoje ri echaꞌom chi uloq re kakꞌojiꞌ kikꞌaslemal na jinta utaqexik. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Y xeꞌek utzijoxik ri Utzilaj Tzij puwi ri Qanimajawal chupa taq ronoje wa luwar. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Noꞌj raj judiꞌabꞌ xkikoj pa kijolom raj wach re ri tinamit y jujun ixoqibꞌ lik kꞌo kiwach yey kitaqem ri tzijpixabꞌ ke raj judiꞌabꞌ, chaꞌ kekiternabꞌej rukꞌ kꞌaxkꞌobꞌik ri Pablo y ri Bernabé. Jekꞌulaꞌ riꞌ xebꞌekesaj bꞌi pa wa tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ekꞌu ri Pablo y ri Bernabé xkipupaꞌ kan rulew che ri kaqan, kꞌutubꞌal re ri na utz taj xkiꞌan ri e aj chilaꞌ y xebꞌek kꞌu pa ri tinamit Iconio. ");
INSERT INTO acrNNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Pero ri kikojom rubꞌiꞌ ri Cristo chilaꞌ Antioquía lik kꞌo kiꞌkotemal kukꞌ yey ri Santowilaj Ruxlabꞌixel ri Dios lik kꞌo kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Chilaꞌ kꞌut chupa ri tinamit Iconio, ri Pablo y ri Bernabé junam xebꞌok chupa ri sinagoga ke raj judiꞌabꞌ. Ruma kꞌu ri Utzilaj Tzij xkitzijoj, lik e kꞌi ri e aj judiꞌabꞌ y ri na e ta aj judiꞌabꞌ xkikoj rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Noꞌj ri e aj judiꞌabꞌ ri na kakikoj ta ri Utzilaj Tzij, xkitik oyowal pa kanimaꞌ ri na e ta aj judiꞌabꞌ yey xekituk waꞌ wa winaq chaꞌ keyaktaj chikij ri kikojom rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Na rukꞌ ta kꞌu riꞌ, lik naj xekꞌojiꞌ ri Pablo y ri Bernabé chiriꞌ y na kakixiꞌij ta kꞌana kibꞌ kechꞌaꞌt chikiwach konoje. Ekꞌu ri Qanimajawal xujikibꞌaꞌ uwach ri kichꞌaꞌtem chwi ri unimal rutzil ukꞌuꞌx, ma xuya chike kakiꞌan nimaq taq kꞌutubꞌal re ruchuqꞌabꞌ ri Dios. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ekꞌu ri winaq re ri tinamit kijachom kipa; jujun chike ekiternabꞌem raj judiꞌabꞌ y jujun chik ekiternabꞌem ri e taqoꞌn re ri Jesús. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Ekꞌu ri e aj judiꞌabꞌ junam kukꞌ ri na e ta aj judiꞌabꞌ xkiꞌan tzij chikiwach kukꞌ ri e aj wach chaꞌ keyaktaj chikij ri Pablo y ri Bernabé re kakiꞌan kꞌax chike y kekiꞌan paꞌbꞌaj. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Echiriꞌ ri Pablo y ri Bernabé xketaꞌmaj waꞌ, xebꞌel bꞌi chiriꞌ y xebꞌek pa ri luwar re Licaonia pa taq ri tinamit Listra y ri tinamit Derbe y pa taq ri luwar chunaqaj wa kebꞌ tinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Y chiriꞌ kꞌu riꞌ kakitzijoj ri Utzilaj Tzij. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Chupa wa tinamit Listra kꞌo jun achi sikirinaq ukabꞌichal ri raqan y na bꞌininaq ta kꞌenoq ma ralaxibꞌem sik. Waꞌ waꞌchi tzꞌulik, ");
INSERT INTO acrNNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","e riꞌ kutataꞌ ri kubꞌiꞌij ri Pablo. Ekꞌuchiriꞌ ri Pablo xuchꞌikibꞌaꞌ ruwach puwiꞌ y xrilo kꞌo kubꞌulibꞌal ukꞌuꞌx chaꞌ kakunutajik, ");
INSERT INTO acrNNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","lik ko xubꞌiꞌij che: —¡Chatyaktajoq y chat-takꞌala jusukꞌ chwi rawaqan! —xchaꞌ. Ekꞌu rachi xchꞌoplin chikaj y xbꞌinik. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Ekꞌu ri winaq echiriꞌ xkilo saꞌ ri xuꞌan ri Pablo, xkijeq kesikꞌin pa kichꞌaꞌtem rike, waꞌ e ri chꞌaꞌtem re Licaonia. Jewaꞌ kakibꞌiꞌij: «¡Waꞌ e tiox kiꞌanom lo achijabꞌ che kibꞌ y xeqaj lo wara qukꞌ!» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Che ri Bernabé xkibꞌiꞌij e tiox Júpiter, yey che ri Pablo xkibꞌiꞌij e tiox Mercurio ma e rire ri más kachꞌawik. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ekꞌu raj chakunel re ri tiox Júpiter, ri kꞌo rocho pa okibꞌal lo re ri tinamit, xebꞌukꞌam lo toroꞌibꞌ y kotzꞌiꞌj yijbꞌam re wiqonik chwach taq ri okibꞌal re ri templo. Yey junam kukꞌ rukꞌiyal winaq xkaj kekikamisaj rawaj re kiqasaꞌn chikiwach ri Bernabé y ri Pablo. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Echiriꞌ xkita waꞌ ri kebꞌ taqoꞌn Bernabé y Pablo, xkirichꞌij ri kiqꞌuꞌ y xkimin kibꞌ chikixoꞌl rukꞌiyal winaq; kesikꞌinik jewaꞌ kakibꞌiꞌij: ");
INSERT INTO acrNNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","«¡Achijabꞌ!, ¿suꞌchak kaꞌan alaq waꞌ? Ma riꞌoj xa oj achijabꞌ junam qawach ukꞌ alaq. Wa Utzilaj Tzij kaqatzijoj che alaq e chaꞌ kaya kan alaq ri na il ta uwach y katzukuj alaq ri Dios kꞌaslik, ri xꞌanaw re ruwa kaj, ruwachulew, ri mar y ronoje ri kꞌo che taq waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Tobꞌ rojertan ri Dios xuya luwar chike taq ri tinamit kebꞌin chupa taq ri bꞌe kakaj rike, ");
INSERT INTO acrNNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","na rukꞌ ta kꞌu riꞌ, ri Dios na roqꞌotam ta kꞌana uqꞌalajisaxik china Rire ruma taq ri utz kuꞌano. Ma kuya lo ri jabꞌ y kuya lo ruqꞌijol echiriꞌ lik kꞌo molonik. E Rire ri kaꞌanaw re lik kꞌo kaqatijo y kꞌo kiꞌkotemal chupa ri qanimaꞌ» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ri Bernabé y ri Pablo, tobꞌ ketajin che ubꞌiꞌxikil waꞌ, lik kꞌayew xekiqꞌatej rukꞌiyal winaq chaꞌ na kekikamisaj ta rawaj re qasaꞌn chikiwach rike. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Chupa kꞌu laꞌ laꞌ joqꞌotaj xekꞌun lo jujun aj judiꞌabꞌ e aj pa ri tinamit Antioquía y ri tinamit Iconio. Rike xkikoj pa kijolom rukꞌiyal winaq kakiꞌan ri Pablo paꞌbꞌaj. Y ekꞌu xkiꞌano. Tekꞌuchiriꞌ, xkichararej bꞌi ri Pablo tzaꞌm tinamit. E chikiwach rike, kaminaq chik. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Pero echiriꞌ ri kikojom rubꞌiꞌ ri Cristo xkisut rij ri Pablo, rire xyaktajik y xok tanchi chupa ri tinamit. Chukaꞌm qꞌij xel bꞌi rukꞌ ri Bernabé y junam xebꞌek pa ri tinamit Derbe. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Xkitzijoj kꞌu ri Utzilaj Tzij chupa wa tinamit y ukꞌiyal tikawex xkikoj rubꞌiꞌ ri Cristo. Tekꞌuchiriꞌ, xetzelej tanchi lo chupa ri tinamit Listra, ri tinamit Iconio y ri tinamit Antioquía. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Xkinimarisaj kꞌu kan kikꞌuꞌx ri hermanos y lik xekipixabꞌaj chaꞌ katikiꞌ chi utz ri kubꞌulibꞌal kikꞌuꞌx rukꞌ ri Jesús, jewaꞌ kakibꞌiꞌij chike: «Lik chirajawaxik rukꞌ ukꞌiyal kꞌaxkꞌobꞌik kojok chupa rutaqanik ri Dios» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Yey xekikoj kan e aj wach chujujunal taq iglesia. Xkiꞌan kꞌu orar y ayunar kukꞌ. Tekꞌuchiriꞌ, xkitzꞌonoj che ri Qanimajawal kebꞌuchajij janipa ri lik kubꞌul kikꞌuꞌx rukꞌ Rire. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Xebꞌikꞌow kꞌu pa taq ri luwar re Pisidia y xebꞌopon pa ri luwar re Panfilia. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Xkitzijoj kꞌu ri Utzilaj Tzij chupa ri tinamit Perge. Tekꞌuchiriꞌ, xkimaj bꞌi pa ri tinamit Atalia. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Chiriꞌ kꞌu riꞌ xkimaj bꞌi pa barco y xetzelej Antioquía. Waꞌ e ri tinamit pa xtzꞌonox wubꞌi rutoꞌbꞌal ri Dios pakiwi ri Pablo y ri Bernabé chaꞌ kakiꞌan ri chak yaꞌom pakiqꞌabꞌ, yey waꞌ wa chak kikꞌisom chi rike. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Echiriꞌ xebꞌoponik, xekimol kichiꞌ konoje ri kikojom rubꞌiꞌ ri Cristo y xkitzijoj kꞌu chike ronoje ri xuꞌan ri Dios kukꞌ y suꞌanik xuya chike ri na e ta aj judiꞌabꞌ kebꞌuꞌan xa jun kukꞌ ri kikubꞌam kikꞌuꞌx rukꞌ ri Qanimajawal Jesucristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Xekanaj kꞌu kan chiriꞌ ukꞌiyal qꞌij kukꞌ ri kikojom rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Chupa taq riꞌ laꞌ la qꞌij xebꞌopon Antioquía jujun achijabꞌ e petinaq Judea y xkijeq kekꞌutun chikiwach ri kikojom rubꞌiꞌ ri Cristo, jewaꞌ kakibꞌiꞌij: «We na kakoj ta ri retalil re circuncisión che alaq jelaꞌ pachaꞌ rutaqanik kan ri Moisés, riꞌ na kakolobꞌetaj ta alaq» kechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ekꞌu ri Pablo y ri Bernabé lik xebꞌek chunimal puwi wa kꞌutunik kukꞌ waꞌchijabꞌ. Kꞌisbꞌal re, konoje xkichꞌobꞌ raqan saꞌ ri kakiꞌano; e ketaq bꞌi ri Pablo y ri Bernabé kukꞌ jujun chik chaꞌ kebꞌek Jerusalem re kebꞌeꞌchꞌaꞌt chwi waꞌ kukꞌ ri e taqoꞌn re ri Jesús y jujun chik e aj wach re riglesia. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","E taq kꞌu ri etaqom bꞌi kuma riglesia re Antioquía, xebꞌikꞌow pa taq ri tinamit re Fenicia y re Samaria, y chujujunal luwar xkitzijoj suꞌanik ri na e ta aj judiꞌabꞌ kiyaꞌom kan ri kibꞌinik re ojertan chaꞌ e kakitaqej ri Dios. Ruma kꞌu riꞌ waꞌ, konoje ri hermanos xetaw re, lik xekiꞌkot che. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Echiriꞌ xebꞌopon Jerusalem, xekꞌul kuma taq ri hermanos, ri e taqoꞌn y jujun chik e aj wach re riglesia. Xkitzijoj kꞌu chike ronoje ri uꞌanom ri Dios kukꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Pero e kꞌo jujun chike ri kikojom rubꞌiꞌ ri Cristo e kukꞌil ri aj fariseos, rike xeyaktajik y jewaꞌ xkibꞌiꞌij: —Lik chirajawaxik kakoj ri retalil re circuncisión chike taq ri na e ta aj judiꞌabꞌ kakikoj rubꞌiꞌ ri Dios yey ketaq che kakiꞌan janipa ri kubꞌiꞌij ri Tzij Pixabꞌ re ri Moisés —xechaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Xkimol kꞌu kibꞌ ri e taqoꞌn y jujun chik e aj wach re riglesia chaꞌ kechꞌaꞌt chwi waꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Lik naj kꞌut xkichapalaꞌ kibꞌ chikiwach puwi waꞌ. Tekꞌuchiriꞌ, ri Pedro xyaktajik y xubꞌiꞌij chike: —Hermanos achijabꞌ, ralaq etaꞌam alaq jampa chi lo qꞌij waꞌ ikꞌowinaq chwi xinuchaꞌ lo ri Dios chaꞌ chi nuchiꞌ riꞌin, ri na e ta aj judiꞌabꞌ kakita ri Utzilaj Tzij y kakikoj kꞌu rubꞌiꞌ ri Cristo. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Ri Dios, ri retaꞌam saꞌ ri kꞌo chupa ri kanimaꞌ ri tikawex, e xkꞌuluw ke ri na e ta aj judiꞌabꞌ kikojom rubꞌiꞌ ri Cristo. Yey xukꞌut waꞌ echiriꞌ xuya lo ri Santowilaj Ruxlabꞌixel chike rike jelaꞌ pachaꞌ xuꞌan qukꞌ riꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Y junam xeril rike qukꞌ riꞌoj, ma xujosqꞌij ri kanimaꞌ che ri mak ruma ri kubꞌulibꞌal kikꞌuꞌx. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","»Ekꞌu woꞌora, ¿suꞌchak kapetisaj alaq royowal ri Dios ruma ri keya alaq chuxeꞌ ukꞌiyal taqanik ri na e ta aj judiꞌabꞌ kikojom rubꞌiꞌ ri Cristo? Waꞌ e pachaꞌ eqaꞌn kakoj alaq chikiqul. Yey wa eqaꞌn, na xkichꞌij tane rukꞌaxik ri qatiꞌ-qamam ojertan y na qachꞌijom tane rukꞌaxik riꞌoj. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Noꞌj kꞌu riꞌoj e kaqajikibꞌaꞌ uwach waꞌ: Xa ne ruma ri unimal rutzil ukꞌuꞌx ri Qanimajawal Jesús kojkolobꞌetaj riꞌoj jelaꞌ pachaꞌ rike —xchaꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Konoje kꞌu riꞌ rukꞌiyal tikawex xetzꞌinkaꞌnik y xkiya kixikin chike ri Bernabé y ri Pablo, ma kakitzijoj ri nimaq taq kꞌutubꞌal re chuqꞌabꞌ uꞌanom ri Dios kuma rike chikixoꞌl ri na e ta aj judiꞌabꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Echiriꞌ xkikꞌis kechꞌaꞌt rike, ri Jacobo jewaꞌ xubꞌiꞌij: —Hermanos, chinta na pe alaq: ");
INSERT INTO acrNNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Ri Simón xutzijoj puwi ri nabꞌe laj echiriꞌ ri Dios xuqꞌalajisaj ribꞌ chikiwach ri na e ta aj judiꞌabꞌ chaꞌ chikixoꞌl rike kebꞌuchaꞌ janipa ri kebꞌuꞌana utinamit. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Y waꞌ kuꞌana xaqi jun rukꞌ ri kitzꞌibꞌam kan ri qꞌalajisanelabꞌ puwi ri ubꞌiꞌim lo ri Dios: ");
INSERT INTO acrNNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","Ikꞌowinaq kꞌu waꞌ, kintzelej loq y kanyak tanchi ri rocho ri rey David wuluwubꞌinaq bꞌi, kankꞌojoj kꞌu ri tzaqinaq bꞌi che y kanꞌan kꞌakꞌ che. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kanꞌan waꞌ chaꞌ ri nikꞌaj chik tikawex kakitzukuj ri Dios, waꞌ e taq ri tinamit na e ta aj judiꞌabꞌ, konoje ri e nuꞌanom nutinamit chike ma kikojom ri nubꞌiꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","E waꞌ ri xubꞌiꞌij ri Dios Qajawxel, yey e ri uqꞌalajisam chi lo ojertan. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Ruma kꞌu laꞌ, chinuwach riꞌin na utz taj we kaqasachisaj kinaꞌoj ri na e ta aj judiꞌabꞌ kikojom rubꞌiꞌ ri Qanimajawal. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Ri qaꞌanaꞌ e chojtzꞌibꞌan pan chike y qayaꞌa pan kinaꞌoj chaꞌ kakesaj kibꞌ che taq ri kachꞌulan re junoq pachaꞌ taq ri ikꞌowisam chwa juna tiox, chaꞌ na kaketzꞌabꞌej ta uwa kiqꞌij kukꞌ jujun chik na kikꞌulel taj, chaꞌ na kakitij ta tiꞌij ke awaj xa ejitzꞌam y chaꞌ na kakitij ta kikꞌ. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ma xex wi chwi lo ojertan, ronoje qꞌij re uxlanibꞌal pa taq sinagogas e kꞌo ri kebꞌajilan re y ketzijon puwi ri Tzij Pixabꞌ tzꞌibꞌital kan ruma ri Moisés —xcha ri Jacobo. ");
INSERT INTO acrNNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","E taq ri e taqoꞌn y ri jujun chik e aj wach re riglesia kukꞌ konoje ri hermanos, xukꞌul kikꞌuꞌx ri kechaꞌ jujun achijabꞌ chikixoꞌlibꞌal re