﻿USE sofia;
DROP TABLE IF EXISTS sofia.acr_acc_vpl;
CREATE TABLE acr_acc_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acr_acc_vpl WRITE;
INSERT INTO acr_acc_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Iri are i qui bi i je ratit u mam i Jesucrísto chi umuk uxiquin i ujer mam David xak i ujer mam Abraham. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I mam Abraham-le are u kajaw i mam Isaac; xoʼon panok, i mam Isaac-le are u kajaw i mam Jacob; teʼuri i mam Jacob-le are i qui kajaw i mam Juda cuʼ i ratz u chaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Teʼuri i mam Juda are qui kajaw i mam Fáres xak i mam Zar, i qui chuch are i ati Támar. Xoʼon panok, i mam Fáres are u kajaw i mam Esrom, teʼuri i mam Esrom are u kajaw i mam Aram. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Xoʼon panok, i mam Aram are u kajaw i mam Aminadab; y teʼuri i mam Aminadab are u kajaw i mam Naason; i mam Naason-le are u kajaw i mam Salmon. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Xoʼon panok, i mam Salmon are u kajaw i mam Booz, y u chuch are i ati Rahab. Teʼuri i mam Booz are u kajaw i mam Obed, y u chuch are i ati Rut. Teʼuri i mam Obed-le are u kajaw i mam Isai. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Y xoʼon panok, i mam Isai are u kajaw i mam Rey David. I mam David-le are u kajaw i mam Salomon, i u chuch i mam Salomon are i rixokil can i ʼetz mam Urías. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Xoʼon panok, i mam Salomon-le are u kajaw i mam Roboam; teʼuri i mam Roboam are u kajaw i mam Abías; i mam Abías-le are u kajaw i mam Asa. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Xoʼon panok, i mam Asa are u kajaw i mam Josafat, teʼuri i mam Josafat are u kajaw i mam Joram; i mam Joram are u kajaw i mam Uzías. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Teʼuri i mam Uzías are u kajaw i mam Jotam; i mam Jotam are u kajaw i mam Acaz; i mam Acaz-le are u kajaw i mam Ezequías. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","I mam Ezequías are u kajaw i mam Manases, i mam Manases are u kajaw i mam Amon; i mam Amon are u kajaw i mam Josías. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","I mam Josías are qui kajaw i mam Jeconías cuʼ i ratz u chaʼ. Are je cʼas ique, are ʼuri xe chap i aj Israel winak y xe cʼam bi pa tinimit Babilónia. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Teʼuri, xoʼon panok i mam Jeconías are u kajaw i mam Salatiel; teʼuri i mam Salatiel are u kajaw i mam Zorobabel. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","I mam Zorobabel are u kajaw i mam Abiud; i mam Abiud are u kajaw i mam Eliaquim; i mam Eliaquim are u kajaw i mam Azor; ");
INSERT INTO acr_acc_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","i mam Azor are u kajaw i mam Sadoc; i mam Sadoc are u kajaw i mam Aquim; i mam Aquim are u kajaw i mam Eliud. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","I mam Eliud are u kajaw i mam Eleázar; i mam Eleázar are u kajaw i mam Matan; i mam Matan are u kajaw i mam Jacob. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I mam Jacob are u kajaw i mam Jose; i mam Jose-le are i rachijil i al-Mariy. I al-Mariy are u chuch i Jesus chi Tolke. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Chi cakil wi je cajlajuj lemaj chi qui kajawim re can i mam Abraham cʼa ruʼ i mam David; teʼuri xak je cajlajuj tan chic lemaj chi qui kajawim tan chic chi rijil i mam David cʼa xe cʼam bi i aj Israel winak pa tinimit Babilónia. Xak je cajlajuj lemaj tan chic chi rijil i qui ʼenam i aj Israel winak pa Babilónia cʼa xu rik i ʼij chi xalax i Crísto chi Tolke. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","I ralaxbal i Jesucrísto, queje iri xoʼono: i al-Mariy, chi u chuch, ya u bim chic che i ma Jose chi que cʼuliʼic. Xui-ri, are maja cacucʼaj quib, ire iwab winak chic rumal u choʼab u Tewal i Dios chi petnak puwi. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I ma Jose xu bij pu cʼux chi xa quiqui jach quib ruʼ i al-Mariy aliʼal. ʼUtz laj winak ire, n-craj ta cu ya u qʼuix che chiquiwach conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Are ca tijin chu chʼobic ile, jun ángel re i Kajwal xupon ruʼ. I ma Jose xrachicʼaj pu waram chi xu bij i ángel che: —A-Jose, chi at umuk uxiquin can i mam David, ma xij awib che i al-Mariy; cha cʼulaj na awuʼ, lic are awixokil, man i acʼal chi calax na ruʼ, i rajaw are i u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","I acʼal-le chi calax na, are jun ala. Cha ya pu bi A-JESUS. Queje ni u bi ile, man que resaj u winak chupam i qui mac. (Queje ile xu bij i ángel che.) ");
INSERT INTO acr_acc_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Queje xe icʼaw wi ique ile; y xeʼelok pacha u bim can i Kajwal ujer. Ire u bim che jun ajbil u tzij: ");
INSERT INTO acr_acc_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","I apoj ali ca qʼuiji ni yobil chirij y calax ni jun ala ruʼ; i ala-le, Emanuel ca bix che. Queje i tzij ile xu tzʼibaj i ajbil u tzij i Dios ujer. I “Emanuel” queʼelok: Dios ʼo kuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","I ma Jose, are xcʼun sak chuwach, ʼis xoʼon pacha xbix che rumal i ángel chi taktal li ruʼ rumal i Kajwal Dios; xrucʼaj i al-Mariy chi lic rixokil. ");
INSERT INTO acr_acc_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Xui-ri, ire toʼ xu chajij i al-Mariy, n-xqʼuiji ta tan ruʼ, cʼa xqʼuiji ni ral acʼal; y xu ya pu bi A-JESUS. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Are xalax i Jesus pa tinimit Belen re i jyub Judéa, i ʼatol tzij are i mam Heródes. I mam-le ʼo pu patan pa tinimit Jerusalen; je ʼo juban winak je aj ʼij, je petnak cʼa naj pa oriénte. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Are xe upon pa Jerusalen, xqui tzʼonoj chique i winak: —¿Paʼowi i nim laj ʼatol tzij que i aj Israel winak chi xalaxic? Ya xkil i u chʼumil are oj ʼo chila pa oriénte, rumal-i xoj cʼun chu cojic u ʼij —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","I nim laj ʼatol tzij, mam Heródes, are xu ta rason ile, lic xcʼachir rumal; xak conojel i winak pa tinimit Jerusalen xe cʼachir rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Teʼuri i ʼatol tzij xe u siqʼuij i nimak tak sacerdóte que i aj Israel, tak i tijonel re i tzij tzʼibtal can rumal i mam Moises ujer. Are xe moltajic, xu tzʼonoj chique pa calax na wi i Crísto chi tolque coyʼem. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ique xqui bij ʼuri che: —Calax pa tinimit Belen, u cwenta i jyub Judéa. Queje ile queʼelok, man queje ile tzʼibtal can rumal i ajbil u tzij i Dios ujer. Queje iri xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Yet chi at tinimit Belen, at u cwenta i jyub Juda, ma chʼobo mok n-ti a ʼij yet; ʼo ni a ʼij man chiquixol awacʼal yet queʼelok ʼo ni jun qui cʼambeal; cucʼaw ni u tzam chique in winak, aj Israel. Queje ile tzʼibtal canok —xqui bij i mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Teʼuri i mam Heródes aliʼal xe u siqʼuij i nimak tak aj ʼij chi je petnak pa oriénte y xu tzʼonoj chique wach xoʼon i icʼ, wach xoʼon i ʼij are xwinakir i chʼumil. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Teʼuri, xe u takbi pa Belen. Xu bij chique: —Jix chu tzucuxic i ral acʼal-le; naʼal chi tzucuj. We xi riko, col i bij chwe, man xak yin quin ʼe chu cojic u ʼij —xu bij i mam Heródes. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","I nimak tak aj ʼij, are xutzin u bixquil ile chique, xqui maj chubi qui be. I chʼumil chi xnabeaj chiquiwach cʼa pa oriénte, xbin chic chiquiwach cʼa xupon pa yatal wi i ral acʼal. Chila xtaqʼui na puwi i ja paʼowi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Are xquil i nimak tak aj ʼij chi xtaqʼui i chʼumil, lic xe quicotic. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Y xe ʼoc ruʼ ja, xqui rik i acʼal ruʼ u chuch, ixok Mariy, xe xuquiʼic, xqui coj u ʼij i acʼal. Teʼuri, xqui tor i quekan, xquesaj li qui sipon chi cucʼam y xqui ya che. Ile are óro, xak inciénso, xak i mírra. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Are xe tzalij chic pa qui tinimit, junwi chic be xqui majo man xbix chique rumal i Dios piqui waram chi me tzalij chic ruʼ i mam Heródes. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Je ʼenak chic i nimak tak aj ʼij, teʼuri jun ángel re i Kajwal xwinakir pu waram i ma Jose. Xu bij che: —Chat walijok, cha cʼama bi awacʼal, xak i u chuch, y chat ʼanmajok, jat cʼa Egípto. Chat ʼol chila cʼa quin bij na chawe umpa cat petic, man i mam Heródes cu tzucuj ni acʼal, craj cu camsaj —xu bij i ángel che. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","I ma Jose xwalijic, xu cʼambi i acʼal, xak i u chuch, y xqui majbi qui be chaʼab, xe ʼe cʼa pa Egípto. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Chila xe qʼuiji wi cʼa are xcam i mam Heródes. Queje ile xeʼelok xak jun ruʼ pacha u bim can i Kajwal; man i ajbil u tzij i Dios u tzʼibam can i tzij-i chi u bim i Kajwal: “Pa Egípto quin siqʼuij wi in Cʼojol.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","I mam Heródes, are xu nabej chi xtʼor can cumal i nimak tak aj ʼij, lic xpe roywal che. Rumal ʼuri, xu tak qui camsaxic conojel i ral tak alabom we maja quiqui chap oxib junab, man qui bim che chi colo ʼo chic queb junab che u winakiric i chʼumil. Queje xu tak u ʼanic ile pa tinimit Belen, xak ronojel i jyub chirij chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Queje ile xeʼelok pacha xu bij i tzij tzʼibtal can rumal i mam Jeremías, i ajbil u tzij i Dios ujer. Xu bij ire: ");
INSERT INTO acr_acc_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Ca tataj jun nim laj oʼej pa tinimit Rama, Are i ixokib aj Israel que siqʼuinic, que oʼic, Man i cacʼal, ya xe camic, ya n-ta chic; Lic n-ca pactaj ti qui bis rumal. (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Xoʼon panok xcam i mam Heródes. Teʼuri, chila pa Egípto, jun ángel re i Kajwal xwinakir ruʼ i ma Jose pu waram. Xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","—Chat walijok, cha cʼama bi acʼal y u chuch, chix tzalij che i jyub Israel; man ya xe cam ique chi cacaj u camsaxic i acʼal. (Queje ile xu bij i ángel che.) ");
INSERT INTO acr_acc_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Teʼuri i ma Jose xwalijic, xu cʼam bi racʼal, i rixokil y xe tzalij che i jyub Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Are que tijin chi be, i ma Jose xu ta rason chi u qʼuexel i mam Heródes are i u cʼojol, ma Arqueláo u bi. Ire xu xij rib che, n-xraj ta xa ʼe jeki pa jyub Judéa rumal. Teʼuri xbix chic che rumal i Dios pu waram wach i cu ʼano; rumal-i, xa ʼe pa jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Are xe upon chila, xa ʼe jeki pa tinimit Nazaret. Queje ile xeʼelok, pacha qui bim i ajbil u tzij i Dios ujer, chi Jesus “aj Nazaret” ca bix na che. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Xoʼon panok, i ma Wan, aj kajsanel ya, xupon che i chakij jyub tzʼinilic, chila pa jyub Judéa. Are xuponic, xoc chu bixquil u tzij i Dios chique i winak chi xe moltaj ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","—Chi jalwachij i nojbal chuwach i Dios —xu bij chique—. Man i ʼatbal tzij chi ca pe chicaj ya ca jekanic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I ma Wan-le are i jun chi ʼax bital wi chi ca cʼunic. Are i bin-nak can ile are i ujer ajbil u tzij i Dios mam Isaías. Ire u tzʼibam canok: Ca tataj u chʼawbal jun ca siqʼuin che i jyub tzʼinilic; cu bij: “¡Ya ca pe i Kajwal! Chi yijba u be chuwach. Chi sucʼba niʼpa i jul, niʼpa i tanalak pu be i Kajwal.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","I ma Wan, i u ʼuʼ ire xa are i rismal camey ʼantal u ʼuʼ che; i ximbal u pam xa are chʼakap tzʼum. Wach i xu tijo xa are wach i xu rik pa tak ʼes: xa xu tij u waʼal cab, xak xe u tij i ral tak sacʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","I winak chi xe upon ruʼ chu tayic u tzij, ʼo i je petnak cʼa pa tinimit Jerusalen, xak ʼo i je petnak pa ronojel tak lugar re i jyub Judéa, xak ʼo i je petnak chu nakaj i ya Jordan. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Ique, are xqui tzʼonoj ni cuybal mac che i Dios, teʼuri i ma Wan xu kajsaj ya piquiwi pa ya Jordan. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Xui-ri, xril ire je qʼui i aj Fariséo winak, xak i aj Saducéo, chi cacaj ique toʼ ca kajsax ya piquiwi. Are ʼuri xu bij chique: —¡Yix xa ix racʼal cumatz! ¿Pachin xbin chiwe yix chi quix totaj chuwach i tojpen chi ca tijin nali piwi? ");
INSERT INTO acr_acc_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Chi ʼalijinsaj ʼut ruʼ wach tak i qui ʼano we i jalwachim chic i nojbal chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Mi chʼob yix mok xa n-ca pe tu tojbalil piwi yix xa rumal ix aj Israel winak, xa rumal ix umuk uxiquin can i mam Abraham. Mi chʼob yix chi lic quix totaj na rumal. Quin bij chiwe chi Dios, che i abaj-i, ca tiqui chu ʼonquil uqʼuial aj Israel winak che, we ta craj —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Xak xu bij: —I tojpen ya ca pe piwi, pacha jun icaj yij chic che jun cheʼ, cʼatzbal re i raʼ. Ronojel tak i cheʼ chi n-cu ya tu wach chom, ca cʼatzixic; teʼuri ca porox pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Yin, katzij, quin kajsaj ya piwi yix, cʼutbal-re we i jalwachim chic i nojbal chuwach i Dios. Xui-ri, i Jun chi ca cʼun chwijil yin cu kajsaj i u Tewal i Dios piquiwi niʼpa i qui jalwachim qui cʼaslemal; xak cu kajsaj li ʼaʼ piquiwi i je mal. Ire lic nim ni u ʼij chinwach yin; n-ca majaw ta chwe we quin ʼan mocom che wib chirij, mi tene cwucʼaj u xajab, rumal ni u ʼij nim. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Col u ʼata tzij piquiwi i winak, pachin i je ʼutz, xak pachin i ne te ʼutz. Ire yij chic pacha coʼon jun ruʼ u pala are cu pu u wach u trígo. Are i ʼutz quel che u trígo, cu molo y cu ya pu cʼolbal. I rij, chi n-ʼus taj, ca porox pa ʼaʼ chi n-tu chupic —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Che tak i ʼij-le, i Jesus xel pa Galiléa, xupon chiya Jordan pa ʼo wi i ma Wan; xupon chu kajsaxic ya puwi rumal ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","I ma Wan xu chʼobo chi n-cu maj taj we are ire ca kajsaw ya puwi i Jesus. Xu bij: —Yet, mas ca majaw chawe chi ca kajsaj ya pinwi yin. N-ca majaw taj we yin quin kajsaw ya pawi yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","I Jesus xu bij: —N-ta coʼono. Queje cha ʼana ni ile woʼor, man ca majawic caka ʼan ni ronojel pacha craj i Dios —xu bij. Teʼuri i ma Wan xu ya u wach che, wach i xbix che. ");
INSERT INTO acr_acc_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","I Jesus, are xutzin u kajsaxic ya puwi, xel pa ya. Xak teʼet, xjaktaj i caj, xa ʼiltaj i u Tewal i Dios chi xkaj lok pacha jun palomax sucʼulic puwi Jesus, ");
INSERT INTO acr_acc_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","y xtataj jun chʼawbal chicaj chi xu bij: —Iri lic are i wacʼal chi cʼax quin naʼo; lic quin quicot che, wach u ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Are xoʼon ile, i Jesus xcʼam bi rumal i u Tewal i Dios che jun jyub tzʼinilic. Xcʼam bi chila, ʼilbal-re we ca tzaksax chupam u mac rumal itzel. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Chila xu chʼij cuarénta ʼij, cuarénta aʼab, lic n-ta xu tijo; teʼuri xpe i numic che. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Are ʼuri, xupon itzel ruʼ, tzaksabal-re chupam u mac. Xu bij che: —We katzij at u Cʼojol i Dios, cha bij che i abaj-le chi coʼon wa che rib —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","I Jesus xu laʼ u wach che itzel y xu bij: —N-quin ʼan taj, man tzʼibtalic chupam u wuj i Dios: “N-xui ta rumal i wa je cʼas i winak; are rumal ronojel u tzij i Dios je cʼaslic.” ");
INSERT INTO acr_acc_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Teʼuri itzel xu cʼam bi i Jesus che i loʼlaj tinimit, Jerusalen. Xe u ya chila cʼa chu tzam i rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Teʼuri xu bij che: —We at u Cʼojol i Dios, cha cʼaka bi awib cʼa pulew. N-cat cam taj, man chupam u wuj i Dios, queje iri tzʼibtalic: I Dios cu bij na chique i ángel chi cat qui chajij. Ique lic cat cucʼaj che qui ʼab, mi tene quiqui ya chawe que ʼana cʼax che awakan che abaj. (Queje ile xu bij itzel che.) ");
INSERT INTO acr_acc_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","I Jesus xu laʼ chic u wach che: —Xak tzʼibtal chupam u wuj i Dios chi maka cʼam u pam i Kajwal Dios —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Teʼuri itzel xu cʼam chubi i Jesus che jun jyub, naj u wi. Chila xe u cʼutu wi ronojel i tinimit ʼo chuwach i jyub taʼaj, ruʼ tak i qui chomal. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Teʼuri xu bij che: —Ronojel iri ʼis quin sipaj chawe, xui-ri we yet cat xuqui chinwach chu cojic in ʼij. (Queje ile xu bij itzel che.) ");
INSERT INTO acr_acc_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","I Jesus xu laʼ chic u wach che itzel: —¡Jat, at Satanas! Man chupam u wuj i Dios, queje iri tzʼibtalic: “Xui che i Kajwal Dios cha cojo u ʼij; xui che ire ca ʼan wi a patan,” —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Teʼuri itzel xel chuwach i Jesus; are ʼuri xe upon juban ángel ruʼ, xol qui to wach i rajwaxic che. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Xoʼon panok, xu ta rason i Jesus chi ma wan tzʼapil pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Are xu ta ile, xa ʼe tan chic pa jyub Galiléa, xel pa Nazaret, xa ʼe jekel pa tinimit Capernaum. I Capernaum ʼo chu chiʼ i alagun; ʼo che i jyub Zabulon, tak i Neftali. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Are xupon i Jesus pa jyub-le, xeʼelok pacha u tzʼibam can i mam Isaías chi ajbil u tzij i Dios ujer. U tzʼibam can ire i tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Quin bij chiwe wach quiquil na chila pa jyub Zabulon tak pa Neftali, chila pa jyub pa ca ʼe wi i be ruʼ i mar, chila pa jyub chʼaka ya re i Jordan, chila ʼut pa Galiléa, pa je ʼo wi i ne te aj Israel, chi n-quetaʼam ti Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","I winak chila chi je ʼo pa ʼekumal, quiquil na jun nim laj sak. Ca pe u sakirbal piquiwi niʼpa i toʼ je ʼo chupam qui mac, toʼ je ʼo chuwach i camic. (Queje ile xu tzʼibaj i mam Isaías ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Are xupon i Jesus chila, are ʼuri xu jek u bixquil chique i winak: —Chi jalwachij i noʼoj chuwach i Dios, man i u ʼatbal tzij ya ca jekanic. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Che tak i ʼij-le, are ca tijin i Jesus chi be chu chiʼ i alagun Galiléa, xe ril queb achiab, catz qui chaʼ quib. I jun are i ma Simon chi xak ma Pédro quiqui bij che; i jun chic are i ma Andres. Ique-le je aj chapol car, y que tijin chu cʼakic i cataraya pa ya. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","I Jesus xu bij chique: —Chix terej chwij y quin ʼan na chiwe ix aj molol que i winak pacha qui ʼan chique i car —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Are ʼuri, ique xcoʼtaj can i cataraya, y xe ʼe ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Xoʼon chupan jubiʼ, i Jesus xe ril chic queb achiab catz qui chaʼ quib. Are i ma Jacóbo, xak i ma Wan, je u cʼojol i mam Zebedéo. Ique je ʼo pa bárco ruʼ i qui kajaw, que tijin chu yijbaxic i cataraya are xe u siqʼuij i Jesus ruʼ; ");
INSERT INTO acr_acc_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","juntir xqui canaj can i qui bárco, xqui canaj can i qui kajaw, y xe terej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Teʼuri i Jesus xu jek qui solixic ronojel tak i tinimit pa jyub re i Galiléa. Xoc ruʼ tak ja re qui molbalʼib, y xe u nawsaj i winak chi que moltaj chila. Xu paxsaj i ʼutz laj tzij re u ʼatbal tzij i Dios, xak xe rutzirsaj iwabib, bi chi cʼaxil ʼo chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Xak ronojel i jyub Síria xak xqui ta rason wach ca tijin i Jesus chu ʼonquil pa Galiléa. Xqui jek li qui cʼamic iwabib ruʼ: niʼpa ʼo tak i yobil chique, niʼpa ʼo tak cʼax chique. Xe qui cʼam li ʼo itzel tew chique, xak niʼpa i quiqui tij i camic rumal i atac, xak niʼpa i je sic. I Jesus, niʼpa ile xe rutzirsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Je uqʼuial winak xe terej chirij: xe cʼun i aj Galiléa, xe cʼun i aj Decápolis, xe cʼun i aj pa Jerusalen, xak ronojel i Judéa, xak xe cʼun aj chʼakap re i ya Jordan. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","I Jesus, are xe ril je uqʼuial winak je teren chirij, xel bi chuwi jun jyub, y xcubi chila. Niʼpa i que tijin qui nawic che u tzij xqui mol quib ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Teʼuri xu jek qui nawsaxic ruʼ i tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","—ʼUtz que ique chi quetaʼam ʼo rajwaxic piqui cʼux chuwach i Dios, man que oc na ʼuri pa cu ʼat wi tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ʼUtz que ique chi que bisonic, man i Dios cu cubsaj ni qui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ʼUtz que ique chi ʼo u nimal qui cʼux, man ca yaʼ ni jyub taʼaj chique chi u sujum i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ʼUtz que ique chi lic quiqui rayij u ʼanic wach tak craj i Dios, man ire lic que u to chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ʼUtz que ique chi quewi ʼo i cʼaxnabal qui cʼux, man i Dios xak cʼax que u na ni ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ʼUtz que ique chi chʼam i piqui cʼux, man ique quiquil nu wach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ʼUtz que ique chi que qui chomarsaj i que chʼoʼojinic, man “je wacʼal” cu bij na ʼuri i Dios chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ʼUtz que ique chi caʼani cʼax chique xa rumal u ʼanic wach craj i Dios chique, man que oc na ʼuri pa cu ʼat wi tzij ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ʼUtz iwe yix we cʼax que chʼaw ni winak chiwe xa wumal yin. ʼUtz iwe yix we quix qui yoʼya, xak we quiqui bij i mentir chiwij xa rumal quix terej chwij. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Mix bisonic, xa chix quicotok, man qui rikbej ʼuri jun nim laj sipon chila chicaj. Cha cʼun chi cʼux, xak queje xqui ʼan li winak ile chique i ajbil u tzij i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yix ʼut lic qui rik i chac chique i winak waral chuwach i jyub taʼaj; ix pacha i atzʼam chi lic cu rik u chac chique. Xui-ri, i atzʼam, we xsach u jelal, ¿wach ʼuri u yijbaxic chic u jelal ca ʼanic? N-taj. Ile n-cu rik ta chic u chac; xa ca cʼak bic; toʼ ca wachʼalbex chic cumal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Yix ix pacha u tzunbal ʼaʼ waral chuwach i jyub taʼaj. Iwilom ʼut wach oʼonom jun tinimit we ʼo tzam jyub; lic ʼalaj, n-ruwam ta rib. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Xak iwetaʼam, we jun cu tzij jun cantil, n-que u mina ta chuxeʼ jun cajon; n-ʼus taj we cruwaj. Are i cu ʼano, cu ya ʼan chicaj paja, man conojel que tzun na rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Xak queje chi ʼana yix, chi ix pacha u tzunbal ʼaʼ waral chuwach i jyub taʼaj, chi ya che i tzunbal ca ʼe chiquiwach i winak. Queje ile quiquil na wach tak i ʼutz qui ʼano. Rumal ʼuri, quiqui coj u ʼij i Kajaw yix chila chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Mi chʼob yix mok col in sacha u wach i ʼatbal tzij tzʼibtal can rumal i mam Moises ujer; mi tene ile, xak mi tene i qui cʼutunic can i ujer ajbil u tzij i Dios. Yin n-in ta aj sachol re ile. Xa in aj ʼanol re i usucʼ i tzij-le chiwach yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Katzij iri: tzʼakat cʼo i caj, i jyub taʼaj, n-ca sachsax ti u wach i ujer ʼatbal tzij, mi ta jubiʼ, mi ta jun tzʼib, mi ta pichʼ che jun ral tzʼib. Ile cu chʼij na cʼa ca qʼuis ni ronojel u ʼanic pacha u chʼobom i Dios chi ca ʼani na. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","N-ca sachsax taj; rumal-i, ʼo u chac qui ʼan na pacha i cu bij ronojel i ʼatbal tzij. We ʼo jun n-xcojon ta che i ral cu jupaj tzij pichʼ re i ʼatbal tzij, xak we xu cʼut ʼuri chique i winak queje quiqui ʼan ile, ire ʼut xa pichʼ queʼelok chiquiwach conojel i juban pa cu ʼat wi tzij i Dios. Xui-ri, we jun xcojon che i mer usucʼ i ʼatbal tzij, xak xu cʼut ʼuri chique i juban chic, ire ʼuri lic nim queʼel na, pa cu ʼat wi tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Lic quin bij chiwe, ʼo u chac chix cojon na che ronojel pacha u bim can i Dios; ʼo u chac mas ʼutz u ʼanic chi ʼana ni yix chiquiwach i je tijonel re i ʼatbal tzij; xak mas ʼutz u ʼanic chi ʼana na chiquiwach i aj Fariséo. We n-qui ʼan taj, n-quix oc ta puʼab i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","I tom yix i ʼatbal tzij bital chique iwatit imam ujer. “Mix camsanic,” bital chique, “man pachin jun ca camsanic, caʼat ni tzij ʼuri puwi,” xbix chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Xui-ri, yin quin bij ni usucʼ chiwe: pachin jun xa ca pe roywal che jun rachalal, xak ire caʼat ni tzij puwi. Xak pachin jun cu yoʼya i rachalal, ca yaʼ ni ire chiquiwach i nim laj nucʼbal tʼisbal. Xak we ʼo jun cu bij mal laj tzij che i rachalal, chu ʼana cwent ʼuri che rib, mok xa ca ʼe pa ʼaʼ rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Rumal-i, we yet a cʼamom li jun a sipon col a ya chuwach i Dios, teʼuri we ca cʼun pa cʼux chi ʼo jun awachalal cu chʼobo ʼo a mac che, ");
INSERT INTO acr_acc_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","cha canaj can ʼuri a sipon chila chuwach i altar, y jat ruʼ awachalal. Chi chomaj iwib chiwach. Teʼuri chat tzalij chic y cha jacha a sipon chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","We ʼo jun u cojom a mac, y craj cat u cʼam bi chuwach i ʼatbal tzij, chi chomaj iwib chiwach pa be. Queje chi ʼana ile, man ire n-cat u ya ta chuwach i ʼatbal tzij. Man i ʼatbal tzij cat u jach na piquiʼab i policía; teʼuri i policía cat u tzʼapij pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Katzij iri: n-cat el ta lok, cʼa ca toj ni ronojel a mult. (Rumal-i, weʼ chi chomaj iwib chiwach.) ");
INSERT INTO acr_acc_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","I tom yix wach cu bij i ʼatbal tzij re i mam Moises: “Ma kajsaj a ʼij ruʼ jun ixok, we n-awixokil taj,” cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Xui-ri, yin quin bij ni usucʼ chiwe: we ʼo jun lic cu takej jun ixok, man cu rayij u wach, xeʼel ʼuri pu cʼux xak jun ruʼ pacha i xmacun ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Rumal-i, quin bij i tzij-i chiwe: we yet toʼ ca takej jun ixok y toʼ ca rayij u wach, mejor chawesaj a baʼwach y cha cʼaka bic Mas ʼutz queʼelok we xa are a baʼwach ca sacho, chuwach i ronojel a chʼacul ca ʼe pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","We xak are a ʼab wikabim ca ʼanaw chawe cat macunic, cha cʼatzij y cha cʼaka bic. ʼUtz queʼelok we xa are a ʼab ca sacho, chuwach i ronojel a chʼacul ca ʼe pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Xak i tom yix iri chi ca bixic: “Jun we cu jach can i rixokil, ʼo u chac cu tzʼibaj jun wuj, cu ya che i rixokil, re i jachbal quib.” ca bixic. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Xui-ri, yin quin bij ni usucʼ chiwe: jun, we cu jach can i rixokil, i ixok, we n-tu mac u ʼanom ruʼ jun chic achi, n-ʼus ta xu ʼan ʼuri i rachijil che. Queʼel ʼuri xa are u mac i rachijil che, we i ixok xcʼuli ruʼ jun chic achi; i u mac i ixok ʼo ʼuri chukul i achi chi jachawnak bic. Xak we ʼo jun achi ca cʼuli ruʼ jun ixok chi jachtal bi rumal i rachijil, i achi-le xak ca macun ʼuri chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Xak i tom yix iri chi bital chique iwatit imam ujer: “ʼO u chac ca ʼan na pacha a sujum che jun winak, we a cuxtam u bi i Kajwal puwi a tzij-le.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Xui-ri, yin quin bij ni usucʼ chiwe: n-ʼus taj qui cuxtaj u bi i Dios puwi i tzij che jun winak. Xak mi cuxtaj u bi i caj, man are u qʼuijibal i Dios, pa cu ʼat wi tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Xak mi cuxtaj u bi i ulew, man are pa cu ya wi i rakan. Xak mi cuxtaj u bi i tinimit Jerusalen, man are u tinimit i Dios chi ka nim laj ʼAtol Tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Xak mi cuxtaj u bi i jolom, man n-quix tiqui ta chu yijbaxic wach ca tzun jun ral ʼis re i wi, we ʼek ʼo we sak quiwaj che. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Xui chi bij “are”; o we n-are taj, chi bij “n-are taj”. We ʼo mas tzij qui bij puwi ile, xa ruʼ itzel petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Xak i tom yix chi i ujer ʼatbal tzij cu bij: “We ʼo jun u puchʼum a baʼwach yet, xak ca puchʼ ni jun u baʼwach ire ʼuri; xak we u bokom jun a wawe, xak ire ca bok ni jun u ware ʼuri.” Queje ile cu bij i u ʼatbal tzij i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Xui-ri, yin quin bij ni usucʼ chiwe: mi tzalij u wach che, wach cu ʼan chiwe. Are i chi ʼana, we ʼo jun cat u chʼay che juperaj a palaj, cha ya i juperaj chic che. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","We ʼo jun ca ʼe pa ʼatbal tzij, man craj cu maj a camix, cha ya na ʼuri che, xak cha ya bi a chaquet che. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","We ʼo jun coʼon pen chawe ca cʼam bi jun rekan pa jun kilómetro, yet ja ya che cʼa pa queb kilómetro. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","We ʼo tak ca tzʼonox chawe, cha ya wach i ca tzʼonoxic. Y we ʼo i ca chiʼmax chawe, cha ya wach i rajwaxic. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","I tom yix i tzij-i chi ca bixic: “Cʼax cha na i cʼax cat nawic,” quiqui bij, “xak tzel chawila i tzel cat ilawic,” quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Xui-ri, yin quin bij ni usucʼ chiwe: cʼax che i na i je aj chʼoʼoj chiwij; chi tzʼonoj i ʼutz piquiwi i que tzʼonow mal piwi yix; chi ʼana ʼutz chique i tzel quix ilawic; chi tzʼonoj che i Dios piquiwi niʼpa i quix qui yoʼya, xak piquiwi niʼpa i cʼax que chʼaw chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Queje ile, quix ʼel na lic ix racʼal i Kajaw yix chila chicaj. Ire ʼut cu ʼan che i ʼij cu tzunsaj piquiwi i je mal, xak jun ruʼ pacha cu ʼan chique i je ʼutz. Xak cu tak li jab piquiwi i je ʼutz, xak piquiwi i je mal. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Yix ʼut, we xui cʼax que i na ique chi xak cʼax quix qui na yix, n-ta qui chʼac na ʼuri ruʼ i Dios. Xak i je mal laj tak aj alcawal queje quiqui ʼan ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Yix, we xui chique iwamig qui ya rutzil qui wach, ¿pa ʼutz wi ʼuri ile? Xak queje quiqui ʼan i winak chi n-quetaʼam tu wach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Yix, chom ix ʼolok, ronojel niʼpa i qui ʼano, xak jun ruʼ pacha cu ʼan i Kajaw chi ʼo chicaj, chi lic n-ta cʼax che ronojel niʼpa i cu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","We ʼo tak i ʼutz qui ʼano, cojbal-re u ʼij i Dios, mi ʼan ile chiquiwach i winak we xa quiwaj quix quilo. We queje qui ʼan ile, n-ta qui chʼac na ʼuri ruʼ i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Rumal-i, are que i to i nibaʼib, aliʼal chi ʼana, man n-sicʼbal ta que i winak qui ʼano. Xa are sicʼbal que i winak quiqui ʼan jujun, chi lic je re i Dios quiwil yix, xui-ri, n-katzij taj. Queje quiqui ʼan ique ile pa tak molbalʼib, xak pa tak be. Are quiqui ʼan tak i ʼutz, xa are cacaj ca bix ni ʼutz chiquij. Chitapeʼ, xa are ile quiqui chʼaco, chi que ʼiltaj cumal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Yix, are que i to i nibaʼib, chi ʼana che chi mi jun retaʼam wach i ʼanom, xak mi ne iwachalal. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Aliʼal chi ʼana; teʼuri i Kajaw yix chi xrilo wach xi ʼano aliʼal, cu ya ni ʼutz piwi. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Yix, are qui tzʼonoj che i Dios, mi ʼano pacha quiqui ʼan i jujun chi lic je re i Dios quiwil yix, xui-ri n-katzij taj. Ique, kus quiquilo we je tacʼal chiquiwach i winak are quiqui tzʼonoj che i Dios. Queje quiqui ʼan ile pa tak ja re i molbalʼib, xak i xol tak be, man cacaj ique que ʼiltaj na cumal i winak. Chitapeʼ, xa are ile quiqui chʼaco, chi que ʼiltaj cumal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Yet, are ca tzʼonoj che i Dios, chat oc bi pa ja y cha tzʼapij uchija. Teʼuri cha tzʼonoj che a Kajaw chi ʼo chila awuʼ, xui-ri, n-ca ʼiltaj tu wach. Y a Kajaw chi xrilo wach xa ʼano atuquel, cu ya ni ʼutz pawi. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Yix, are qui tzʼonoj che i Dios, mi bij uqʼuial tzij chi toʼ tzij, n-tu chac. Queje quiqui ʼan ique ile chi n-quetaʼam tu wach i Dios. Quiqui bij ique chi cu ta i Dios man qʼui i tzij quiqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Mi ʼan yix pacha quiqui ʼan ique; i Ta chicaj retaʼam wach i rajwaxic chiwe are maja qui tzʼonoj che. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Rumal-i, queje iri chi tzʼonoj che: Ka Kajaw chicaj, chocsax u ʼij a bi. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Chapetsax a ʼatbal tzij, cha ʼana na waral chuwach i jyub taʼaj, xak jun ruʼ pacha i ca ʼani chila chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Cha ya na chake wach i caka tijo, wach i rajwaxic chake. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Cha cuyu ni ka mac, xak jun ruʼ pacha ka ʼanom yoj, chi ka cuyum ni qui mac niʼpa i je macun-nak chikij. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ma ya chake coj tzak chupam i mac atzalal, xui-ri choj awesaj puʼab itzel. Man yet ʼo i ʼatbal tzij paʼab; nim a choʼab, xak nim a ʼij a chomal. At queje ile queʼe ʼij sak chawij. Amen. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","(Queje ile chi tzʼonoj che i Dios.) Man yix, we i cuyum chic qui mac i juban chi qui ʼanom qui mac chiwe, xak i Kajaw yix chila chicaj xak cu cuy na i mac yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Xui-ri, we yix n-qui cuy ti qui mac i juban, xak ire n-cu cuy ta i mac yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Yix, ʼolic quiwoʼtaj i waʼim qui yabej-re iwib chu tzʼonoxíc che i Dios. Are qui ʼan ile, mi ʼan che i palaj lic ca bisonic pacha quiqui ʼan i winak chi queb qui palaj. Queje quiqui ʼan ique ile, man quiquil i winak chi quiqui tij uyej rumal qui tzʼonoxic che i Dios. Chitapeʼ, xa are ile quiqui chʼaco chi que ʼiltaj cumal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Xui-ri, yix, are quiwoʼtaj i waʼim chu tzʼonoxic che i Dios, chi chʼaja i palaj, chi xiya i wi, ");
INSERT INTO acr_acc_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","man n-quiquil ti winak wach quix tijin chu ʼanic chuwach i Dios. I Kajaw chi n-caʼiltaj tu wach, ire crilo wach quix tijin chu ʼanic; cu ya na ʼuri i ʼutz piwi. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Mi rayij i beyomal waral chuwach i jyub taʼaj, man xa ca pocʼaric, ca pusiric, xak caquelʼaj iliʼomab chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Are i chi ʼana, chi molo u chiʼ i beyomal chila chicaj, man i chila, n-ca pocʼar taj, xak n-ca pusir taj, xak n-que oc ti iliʼom ruʼ quiqui maj chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Chi cʼolo i beyomal chila chicaj, man pa i cʼolom wi i beyomal, chila ʼuri ʼo wi u cubibal i cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","(Chi ta u be i tzij-i:) Rumal i baʼwach, coc i sak che i chʼacul. We ʼutz i baʼwach, ʼo ʼuri i chʼacul pa sak. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Xui-ri, we ix potzʼ, ʼo ʼuri i chʼacul pa ekum. We qui bij yix chi ʼo i sak pi cʼux, xui-ri, we i sak chi ʼo pi cʼux xa ʼekum, lic ʼek ʼuri i ʼekumal-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Mi jun ca tiqui che, we je ʼo queb u patron ca chacun cuʼ. Queʼelok xa jun cʼax cu naʼo, y jun tzel crilo. Xa jun, ʼutz u ʼanic u chac coʼon che; y che i jun, n-kas ta coʼon cas che. N-quix tiqui ta che, we qui ya iwib chu ʼonquil u chac i Dios, xak qui ya iwib chu molic i mer. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Rumal-i, mix cʼachir che i cʼaslemal, wach i qui tijo, wach i qui tuʼu; xak mix cʼachir che i ʼuʼ, wach i qui cojo, chʼukbal re iwij. I cʼaslemal, ¿xataba xui i wa cajwax che? Xak i chʼacul, ¿xataba xui i ʼuʼ cajwax che? N-xui taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Chi chʼobo ʼut wach quiqui ʼan i tzʼiquin chi que bin pa tew. Ique, n-ti quiqui tico, xak n-ti quiqui molo, xak n-ti quiqui cʼol pu cʼolbal-re. Tupu n-quiqui ʼan taj, i Kajaw yix chi ʼo chicaj que u tzuku. Y yix lic nim ni i ʼij chiquiwach ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","We toʼ qui cʼachirsaj iwib, n-ta cu chacuj. Mi jun chiwe ca tiqui chu nimarsaxic u najtil rij, tupu lic ca cʼachir che. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","¿Wuchac quix cʼachir chu tzucuxic i ʼuʼ? Chi chʼobo ʼut wach quiqui ʼan i cotzʼij pa tak ʼes. Ique n-que cʼachir ta chu chʼaquic qui ʼuʼ, xak mi ne u yijbaxic. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Tupu n-quiqui ʼan taj, lic chom qui ʼuʼ. Quin bij chiwe, chom ni qui ʼuʼ ique chuwach i u ʼuʼ i nim laj ʼatol tzij mam Salomon ujer chi lic beyom. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Queje coʼon i Dios ile che i cotzʼij pa tak ʼes, chi xa queb oxib ʼij ʼolic: woʼor cʼaslic, y chwek cʼatnak chic pa ʼaʼ. We ire cu ya i chom laj u ʼuʼ i ral cu cotzʼij-le, ¿xataba n-cu ya ta ʼuri iwe yix? Cu yaʼo pues. ¡Yix cʼo i rajwaxic che u cubibal i cʼux che i Dios! ");
INSERT INTO acr_acc_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","We queje coʼon i Dios ile, mix cʼachir ʼuri; mi bij ʼut, “¿Wach tak caka tijo? o ¿wach tak caka tuʼu? o ¿wach tak u cojic ka ʼuʼ?” ");
INSERT INTO acr_acc_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Niʼpa tak ile, are i quiqui tzucuj i toʼ winak. Péro yix, ʼo jun i Kajaw chicaj lic retaʼam wach i rajwaxic chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Rumal-i, chi ya iwib che i ʼutz laj ʼatbal tzij re i Dios; chi ya iwib chu ʼonquil wach craj ire; teʼuri ire cu ya na chiwe wach tak i rajwaxic chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Mix cʼachir tan rumal wach i qui rik na chwek. Katzij, chwek mok ʼo ni pen caka riko, xui-ri, mix cʼachir tan chu chʼobic woʼor; xui chi chʼobo i re woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Mi ʼat tzij piquiwi iwachiʼil, queje ile, i Dios n-cu ʼat ti tzij ʼuri piwi yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Mi ʼano, man we cʼax u ʼatic tzij qui ʼano, xak cʼax ʼuri u ʼatic tzij coʼon i Dios piwi yix; ire xak jun u ʼonquil coʼono, pacha u ʼonquil xi ʼan yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Wuchac cat cʼachiric rumal i ral tzʼil ca takej chupam u baʼwach awachiʼil, y n-ca na taj ʼo jun nim laj ʼet chupam a baʼwach yet? ");
INSERT INTO acr_acc_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","¿Wuchac ʼuri ca bij che awachiʼil: “Cha ya a baʼwach chwe, cwesaj i tzʼil ʼo chupam,” cat cha, we ʼo jun ʼet chupam a baʼwach yet? ");
INSERT INTO acr_acc_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Yet, ¡n-katzij ti ca ʼano! Nabe chawesaj ni ʼet pa baʼwach yet, teʼuri cat tzun bien cawesaj ni tzʼil ʼo chupam u baʼwach awachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Mi ya chique i tzʼi wach tak i ʼo u ʼij, man mokxa i tzʼi quiqui cʼak quib chiwij y quix qui raxij. Xak mi ya jun chom laj uwaj chiquiwach i ak, mokxa que oc chu yaʼyaxic. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","We ʼo rajwaxic chiwe, chi tzʼonoj che i Dios y Ire cu ya na chiwe; chi tzucuj, y qui rik na; chi cʼojcʼa i porta, y ca jaki na chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Queje ile chi ʼana, man we jun lic cu tzʼonoj, ca yaʼ che; we lic cu tzucuj, cu rik na; we lic cu cʼojcʼa i porta, ca jaki na che. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Yix chi ix kajawxel, we ʼo jun iwacʼal cu tzʼonoj u wa chiwe, ¿xataba qui ya jun abaj che, pu qʼuexel u wa? N-qui ya taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","We xak cu tzʼonoj car chiwe, ¿xataba qui ya jun cumatz che, pu qʼuexel? Xak n-qui ya taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Yix, chi toʼ ix winak, tupu n-qui ʼan ti ʼutz, xui-ri, lic qui ya ni ʼutz chique iwacʼal. I Kajaw chicaj, mas ʼutz coʼon na chuwach ile; lic cu ya ni ʼutz chique pachin i que tzʼonow che. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Chi ʼana chique i winak pacha i quiwaj yix quiqui ʼan na ique chiwe. Are ile are usucʼ i ʼatbal tzij u tzʼibam can i mam Moises, xak are i usucʼ i tzij qui bim can i ajbil u tzij i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Je queb i be re i cʼaslemal: jun, xa pichʼ u wach y jun chic, nim u wach. Chix oc yix che i uchibe chi pichʼ u wach, man i uchibe chi nim u wach, xa pa ʼaʼ ca ʼe wi. Lic je qʼui que bin na che i be-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","I uchibe, xak i be, chi coj u cʼam bi che i cʼaslemal sakil, xa pichʼ qui wach; ne te qʼui quiqui riko. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Chi ʼana cwent chique i que upon iwuʼ chi quiqui bij je ajbil u tzij i Dios; pent ne te are. ʼOlic xa je pacha mal laj tak utiw chi qui ʼanom che quib pacha je chij; lic je ʼutz quiwil yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Que iwetamaj na, je bi chi winakil rumal wach tak i quiqui ʼano. Que iwetamaj na pacha retamaxic u wach i qʼuix. Iwetaʼam chi jun qʼuix n-ta úva cu wachij; xak i jun tzum-tzerek n-ti hígo cu wachij. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Quiwil na bi chi winakil, man jun ʼutz laj cheʼ, niʼpa i u wach cu yaʼo ʼis ʼutz; xak jun cheʼ n-ʼus taj, n-ti u wach ʼutz cu yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I jun cheʼ ʼutz, n-cu ya ti u wach chi n-ʼus taj; xak jun cheʼ n-ʼus taj n-ca tiqui ta chu yaʼic u wach ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Niʼpa i cheʼ chi n-ti u wach ʼutz cu yaʼo, ca cʼatzix na, y ca porox na pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Yix ʼut que iwetamaj na pachin i xa je aj tʼoronel; que iwetamaj na rumal wach quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Mok ʼo jun cu bij na, “Wajwal, Wajwal,” cu bij chwe, ire n-coc ta chicaj pa cu ʼat wi tzij i Dios we xa rumal ni ile chi cu bij ruʼ u chiʼ. Xui niʼpa i qui ʼanom pacha craj i Ta chicaj, xui ique que oc ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Are cu rik i qʼuisbal ʼij, je qʼui na quiqui bij chwe: “Kajwal, Kajwal, choj a to, man are yoj xoj cuxtaw a bi are xka bij u tzij i Dios chique i winak; are yoj xoj cuxtaw a bi are xe kesaj bi itzel tak tew chique i winak; are yoj xoj cuxtaw a bi are xka ʼan uqʼuial milágro.” (Queje ni ile quiqui bij chwe.) ");
INSERT INTO acr_acc_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Yin quin bij na ʼuri chique: “Lic n-wetaʼam ti wach; ¡chix el chin wach, yix chi ix aj ʼanol mal!” (Queje ile quin bij na chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Je niʼpa i que taw in tzij-i, we que cojon che, ʼo qui noʼoj ʼuri. Queje pacha jun achi, ʼo u noʼoj, xu cuba i rachoch pujaʼ abaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Xoʼon panok, xpe i jab nim, lic xnimar i ya, xak xpe i tew, craj cu tzaksaj i ja pulew péro n-xtzak taj man cul pujaʼ abaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Xui-ri, je niʼpa i que taw in tzij, we n-que cojon ta che, n-ta qui noʼoj ʼuri. Queje pacha jun achi, n-tu noʼoj, xu cuba i rachoch xa puwi i seneb. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Xoʼon panok, xpe i jab; xnimar i ya; xak xpe i tew chirij i rachoch, y xtzak pulew. ¡Lic xoʼon mal! ");
INSERT INTO acr_acc_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Are xutzin i Jesus chu bixquil chique, i winak lic xqui bisoj wach i cʼutunic xoʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Are ca chʼaʼat cuʼ, ʼalaj ʼuri chi lic retaʼam usucʼ wach i xu bij; n-are ta pacha quiqui ʼan i toʼ je tijonel re i ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Are xkaj li Jesus tzam jyub, je qʼui i winak je teren chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Are ʼuri xcʼun li jun achi, ʼo i tzel laj yobil lépra che. Ire xupon chuwach i Jesus y xuquiʼic. Xu bij che: —Kajwal, we ta cawaj, cawesaj ni itzel cʼax chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","I Jesus xu chap ruʼ u ʼab, y xu bij che: —Cwaj. Chat utzirok. Are xu bij ile che, i achi xutziric. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","I Jesus xu bij che: —Chatapeʼ, mi jun ma lap wi. Xui-ri, jat, ja cʼutu awib che i sacerdóte chi at ʼutz chic; cha sujuj a sipon chuwach i Dios pacha u bim can i mam Moises. Queje cha ʼana ile man caquetamaj conojel chi at utzirnak chic, chi ya n-ta chic i chʼac chawij —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Xoʼon chupanok, are xoc i Jesus pa tinimit Capernaum, jun capitan aj Róma xa ʼe chu cʼulaxic y xu tzʼonoj u tobal che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","—Nim laj winak —xu bij che—, ʼo jun in mocom ruʼ ja, lic iwab. ʼO chuwi chʼat, lic siquirnak chic; lic cu tij uyej rumal u cʼaxcʼol —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","I Jesus xu bij che i achi: —Quin ʼe wutzirsaj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","—Nim laj winak —xu bij i capitan che—, yet n-ca majaw ta chawe cat oc pa wachoch; n-in ti aj Israel winak. Xui cha bij panok: ¡Chutzirok! Teʼuri in mocom cutzir na. Wetaʼam ʼo paʼab yet u ʼanic ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wetaʼam ile man xak yin in ʼo piquiʼab i je wajʼatzil; xak je ʼo jujun soldádo pinʼab yin. We “¡Jat!” quin bij che jun chique, ca ʼec; y we “¡Saʼaj!” quin bij che jun chic, ca petic. We xak quin tak bi wajchac, ire cu ʼan na wach i quin bij che. Wetaʼam chi xak ʼo paʼab yet cawesaj na bi itzel cʼax-le —xu bij i capitan. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Are xu ta i Jesus ile, lic xu bisoj. —Chitapeʼ —xu bij chique i je teren chirij—, mi tene jun chique i aj Israel winak cul u cʼux chwe pacha oʼonom i achi-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Lic quin bij chiwe, je qʼui i ne te aj Israel winak chi lic qui cubam qui cʼux chwe, que pe pa quel wi i ʼij, que pe pa ca kaj wi i ʼij, que oc na ʼuri pa cu ʼat wi tzij i Dios; quiqui tij ni ʼutz chila junam cuʼ i mam Abraham, i mam Isaac, i mam Jacob, i catit qui mam i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Xui-ri, je qʼui i aj Israel winak n-que oc ta chila cuʼ, tupu que ique i qʼuijibal-le. Ique-le, xa que yaʼ na pa ʼekumal; chila que oʼ wi, lic quiqui kachʼachʼej ni qui waque rumal qui bis —xu bij i Jesus chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Are ʼuri xu bij che i capitan: —ʼUtz cat ʼe che awachoch, y ca ʼani na che a mocom pacha a tzʼonom; queje ile queʼel na rumal u cubibal a cʼux chwe —xu bij i Jesus che. Lic are ʼor ʼuri xutzir i u mocom i capitan. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Xoʼon panok, xa ʼe i Jesus che i rachoch i ma Pédro. Are xoc paja, xrilo chi iwab u chuch u jiʼ i ma Pédro; ire cotzʼol chuwi chʼat, ʼo ʼaʼ chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","I Jesus xa ʼe u yina u ʼab; are ʼuri, xchup i ʼaʼ chirij, xwalijic y xoc chu yijbaxic wach i quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Are xoc aʼab, je qʼui i winak xe qui cʼam li iwabib chuwach i Jesus. ʼO jujun ʼo itzel tew chique; i Jesus, xa ruʼ jun tzij xu bij, xe resaj bic; xak xe rutzirsaj niʼpa i iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Are xoʼon ire ile, xeʼelok pacha u bim can i mam Isaías, chi ajbil u tzij i Dios ujer. Ire u bim canok chi i Jesus “Lic are ire aj ʼelsanel bi yobil chake; are ire aj ʼelsanel re i cʼax chake.” (Queje ile u tzʼibam canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","I Jesus, are xrilo je qʼui i winak je ʼo chirij chuwach, xu bij chique u tijoxelab: —Joʼ, choj ʼax chʼakap re i alagun —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Are ʼuri, ʼo jun tijonel re i ʼatbal tzij xtejeb ruʼ i Jesus. —Mayes —xu bij che—, cwaj quin ʼe awuʼ xa ipa cat ʼe wi —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","I Jesus xu bij che: —Cʼax i terejic chwij. I yac ʼo qui jul, xak i tzʼiquin ʼo qui soc, xui-ri yin chi in Achi aj Chicaj, n-ta pa quin cotzʼba wi in jolom are quin waric —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Teʼuri ʼo jun chique i je teren chirij xu bij: —Nim laj winak, cʼa te quin terej chawij we xcam ni in kajaw —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","I Jesus xu bij che: —Suʼ woʼor chat terej chwij. Niʼpa i je camnak, cha ya can piquiʼab ique quiqui chajij i que camic —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Teʼuri i Jesus xoc pa bárco, je rachiʼil u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Xak teʼet xpe jun nim laj tew puwi i alagun; i u wi ya, lic quel chicaj, cʼa puwi i bárco. I Jesus, lic cwaric. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Are ʼuri i u tijoxelab xe ʼe qui cʼastaj. —Kajwal —xqui bij che—, ¡Choj a to! ¡Ya coj muktaj pa ya! ");
INSERT INTO acr_acc_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","I Jesus xu bij chique: —¿Wuchac lic qui xij iwib? ¿N-ta u cubibal i cʼux chwe? —xu bij. Are ʼuri, xtaqʼui ʼanok y xu jek u ʼatixic i tew, tak i ya chi quel chicaj; y xe uxlanic, n-que silab ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","I rachiʼil lic xqui bisoj wach i xoʼono. —¿Bi chi achial i achi-le chi ʼo i milágro puʼab? —xqui bij chiquiwach—. Ire, i tew, xak i ya, que cojon che, wach i cu bij —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Are ya xe ʼax chʼaka alagun, xe upon pa jyub Gadára. Are ʼuri xe ʼel li queb achiab pa tak mukbal que i camnak y xe upon ruʼ i Jesus. I queb-le, ʼo itzel tew chique, lic je chʼuj rumal; i winak lic quiqui xij quib chique, rumal-i, mi jun quicʼaw che i be-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Ique-le xqui jek i sicʼ y xqui bij: —¿Wach col a tzucuj chi kuʼ yoj, Jesus, chi at u Cʼojol i Dios? ¿Xat cʼun na col oj a ya pa cʼax? ¡Maja na cu rik i ʼij! —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Nakaj che i lugar-le, je ʼo juban uqʼuial ak que tijin chi waʼim. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Are ʼuri i itzel tew queje iri xqui tzʼonoj che i Jesus: —We coj awesaj na chique i achiab, cha ya chake coj oc chique i ak-le —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","I Jesus xu bij: —Jix ba chique. Teʼuri i itzel tew xe ʼel chique achiab y xe oc chiquipam i ak. Xak teʼet conojel i ak xe kaj bi paʼanem, xe ʼe tzak pa ya y xe jiʼic. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Are xqui ʼan ile, i que chajiw i ak lic xqui bisoj. Xe ʼe paʼanem cʼa pa tinimit. Are xe upon chila, xe oc chu bixquil ronojel wach i xquilo; xqui bij wach i xa ʼani chique i queb achiab chi ʼo itzel tew chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Teʼuri conojel i winak re i tinimit xe ʼe chila paʼowi i Jesus. Are xquil u wach, lic xqui tzʼonoj che chi ca ʼec; n-cacaj ta ca canaj ire pa qui jyub ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Teʼuri i Jesus xoc chupam jun bárco y xa ʼax chic chʼaka alagun y xupon chic pu tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Are ʼuri cʼamtal bi jun achi ruʼ, siquirnak u chʼacul, ʼo chuwa chʼat. Niʼpa i je cʼamawnak lok, lic cul qui cʼux che i Jesus. Ire, are xril ile, xu bij che i iwab: —Wacʼal, cha cowij a cʼux; niʼpa i a mac ya cuytajnak chic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Je ʼo jujun aj tijonel re i ʼatbal tzij je ʼo chila. Ique xqui bij chiquiwach: “I achi-ri cu kajsaj u ʼij i Dios ruʼ u tzij,” xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","I Jesus retaʼam chic wach que tijin chu chʼobic, rumal-i xu bij chique: —¿Wuchac n-ʼus ta qui chʼobo? —xu bij chique—. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ile, n-cʼax tu bixquil chi “Ya xcuytaj a mac.” Are i cʼax u bixquil are iri: “Chat walijok, y chat binok,” are ile cʼax u ʼonquil che jun winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Xui-ri, yin chi in Achi aj Chicaj, quin ʼalijinsaj ʼut chi ʼo pinʼab quin cuy ni qui mac i winak waral chuwach i jyub taʼaj —xu bij i Jesus chique. Teʼuri xu bij che i achi chi siquirnak: —Chat walijok, cha yaca bi a soc, y jat che awachoch. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","I achi sic xwalijic y xa ʼe che rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","I winak, are xquilo, xe oc ʼil che y xqui coj u ʼij i Dios man u yom jun chique chi ʼo puʼab que rutzirsaj i winak, xak cresaj i qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","I Jesus xel chila; are ca tijin chi be, xril jun aj tzʼonol alcawal, ma Matéo u bi, chi cul pu qʼuijibal. —Chat terej chwij —xu bij i Jesus che. Ire xwalijic y xterej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","I Jesus xe ʼe junam cuʼ u tijoxelab pa rachoch i ma Matéo. Are que tijin chi waʼim, xak xe upon juban chic aj tzʼonol alcawal, xak juban chic ajmaquib, que ʼe qui tija qui wa cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ʼO jujun aj Fariséo winak xe quilo, y xqui bij chique u tijoxelab i Jesus: —¿Wuchac i tijonel yix cu tij u wa cuʼ i mal laj tak aj tzʼonol alcawal, xak cuʼ ajmaquib? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","I Jesus xu ta ile chi xqui bij, y xu bij chique: —Quin ʼan iri man je pacha iwabib. Are i je iwab cajwax jun ajcun chique; i ʼutz qui wach n-tu chac ajcun chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Je i ta u be bien wach usucʼ i tzij-i chi i tzʼibtal can chupam u wuj i Dios chi cu bij: “Are i cwaj yin are quiwil toʼbal qui wach i loʼcʼanij; n-are ti u sujuxic i chicop chinwach.” Queje ile u bim can i Dios —xu bij i Jesus chique—. Yin in cʼun-nak in aj siqʼuil que i ajmaquib, man quiqui jalwachij qui cʼaslemal. N-in ta cʼun-nak cumal i je ʼutz chuwach i Dios —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Teʼuri i u tijoxelab i ma Wan aj kajsanel ya, xe upon ruʼ i Jesus y xqui bij che: —Yoj, nic are wi caka ʼano, caka chʼij jun ʼij queb ʼij chuwach i Dios, n-ta wa caka tijo; xak queje quiqui ʼan i aj Fariséo. ¿Wuchac ʼuri n-queje ta quiqui ʼan i a tijoxelab yet? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","I Jesus xu bij ʼuri i tijojbal tzij-i chique: —I winak, we que ʼe pa nimaʼij re jun achi ya ca cʼuliʼic, ¿xataba que bisonic? ¿xataba n-quiqui tij ti wa ruʼ? Quiqui tijo pues, tzʼakat ire ʼo cuʼ. Xui-ri, are cu rik i ʼij chi ʼelsam chic i achi chiquixol, teʼuri quiqui mayij qui nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","—Mi jun cu cʼojoj jun u ʼuʼ ʼel ruʼ jun chʼakap cʼojbal cʼacʼ, man i cʼojbal cʼacʼ xa ca tzajic y cu rakchʼij i cʼul ʼel; ruʼ ile coʼon mas nim i rakchʼijnak. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Xak queje ile, mi jun cu cʼol i víno cʼacʼ chupam i ʼel tak surum, man we queje quiqui ʼan ile, xa ca rakchʼij i surum. Queʼelok, coʼon mal i surum, y ca sach i víno. Rumal-i, ʼo u chac cocsax i víno cʼacʼ chupam i surum cʼacʼ; queje ile ʼutz queʼelic che queb —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","I Jesus, are ca tijin chu bixquil ile chique, xak teʼet xupon jun achi ruʼ, chi nim u patan chiquixol i aj Israel. Xuqui chuwach i Jesus cʼa chuwach ulew y xu bij che: —Cuymac, Ta, jun in miʼal cʼa te xcamic —coʼono—. Xui-ri, we ta cat ʼe yet wuʼ, xui ca ya a ʼab puwi y ca cʼun chic sak chuwach —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","I Jesus xwalijic y xe ʼe ruʼ, junam cuʼ u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Are que tijin chi be, ʼo jun ixok chiquixol i winak chi je teren chirij. I ixok-le, ʼax iwab wi; cablajuj junab ʼo chic che chi cril i riqʼuil congan; n-ca tani taj. Ire xtejeb pan chirij i Jesus y xu yin pan u chiʼ u ʼuʼ, ");
INSERT INTO acr_acc_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","man xu chʼob pu cʼux: “Quin utzir na we tene quin yin pichʼ u ʼuʼ,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Are xu chap u ʼuʼ, i Jesus xu naʼo; xu pisquilij rib, xu takej pan i ixok y xu bij che: —Wacʼal, cha cowirsaj a cʼux; ya xat utziric rumal u cubibal a cʼux chwe —coʼono. Are ʼor ʼuri xutzir tan. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Xqui maj chubi qui be, y xe upon ruʼ rachoch i achi chi nim u patan. Xril i Jesus chi je yij chic i aj bixanel re i mukunic, xak niʼpa i winak ʼis que siqʼuin che oʼej, ");
INSERT INTO acr_acc_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","xu bij ʼuri chique: —Chix el chi, man i ali n-camnak taj, xa cwaric —xu bij chique. I winak xa xpe qui tzej che. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","N-ta coʼono, ire xe resaj bic; teʼuri xoc bi pa ja, y xu chap che u ʼab i ali; are ʼuri ire xwalijic. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Rumal i u ʼanom-le, weʼ xqui ta rason i winak ronojel i jyub-le, chi Jesus u walijsam i ali. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Are xel i Jesus chila, je ʼo queb mawach xe terej chirij; xe oc chi sicʼ che. —¡Nim laj winak, yet at umuk uxiquin i mam David, chawila toʼbal ka wach! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Are xoc i Jesus ruʼ ja, xak i mawach xe tejeb pan ruʼ. Are ʼuri xu bij chique: —¿Cul i cʼux chwe chi quin tiqui na che ile? —coʼono. —Katzij cat tiquiʼic, nim laj winak —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Teʼuri i Jesus xu yin i qui baʼwach, y xu bij chique, —We qui na pi cʼux chi quix wutzirsaj, queje ca ʼan ni ile chiwe —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Teʼuri i qui baʼwach xutzir na. I Jesus lic xu bij chique: —Chi ʼana cwent, mi lap iri chique i winak, mi xa ta jubiʼ —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Xui-ri, are xe ʼel bic, xqui jek u bixquil chique conojel i winak re i jyub-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Are xe ʼe ique, xe cʼun chal juban winak, cucʼam li jun achi mem. Memernak na rumal itzel tew ʼo che. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","I Jesus xresaj bi itzel tew che, i achi juntir xu jek chʼawic. I winak lic xqui bisoj rumal. Xqui bij: —Lic n-kilom ta pacha ile, mi tene ronojel i jyub Israel —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Xui-ri, i aj Fariséo xqui bij: —I achi-le cresaj i itzel tew chique i winak xa rumal u choʼab itzel ʼo ruʼ; i choʼab ʼo ruʼ-le, are i cajʼatzil itzel tew yawnak che —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","I Jesus xe u solij ronojel tak i tinimit, ronojel tak i aldéa. ʼIs xoc pa tak molbalʼib que i aj Israel winak, xa ʼe u tijojbej que i winak chila; xa ʼe u paxsaj i ʼutz laj tzij chique i winak, xu bij chi petnak chic i u ʼatbal tzij i Dios chique. Xak xe rutzirsaj bi chi cʼaxil, bi chi yobil, ʼo chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Are xe ril i winak, lic cʼax xu na pu cʼux, man que cʼachiric, lic n-ta jun que towic; xe rilo pacha juban chij, n-ta que ucʼaw u tzam chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Are ʼuri xu bij chique u tijoxelab: —Lic ʼo i jachʼic craj; xui-ri, i ajchac ne te qʼui. ");
INSERT INTO acr_acc_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Rumal-i, chi tzʼonoj che i Rajaw i chac chi que u tak bi mas mocom pa jachʼ —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Teʼuri i Jesus xe u siqʼuij i cablajuj tijoxelab ruʼ y xu ya piquiʼab que tiqui chi relsaxic itzel laj tak tew, xak que tiqui chi rutzirsaxic bi chi cʼaxil, bi chi yobil. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Are i qui bi i cablajuj tijoxelab are iri: nabe, are i ma Simon chi xak quiqui bij “ma Pédro” che; teʼuri i u chaʼ, u bi ma Andres; teʼuri, je queb u cʼojol i mam Zebedéo: i ma Jacóbo, chilam i u chaʼ chi ma Wan; ");
INSERT INTO acr_acc_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","teʼuri i ma Felípe, xak i ma Bartolome; teʼuri i ma Tomas, xak i ma Matéo chi aj tzʼonol alcawal; teʼuri i ma Jacóbo chi u cʼojol i mam Alféo; i ma Lebéo chi xak ma Tadéo quiqui bij che; ");
INSERT INTO acr_acc_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","teʼuri i jun chic ma Simon, are i jun chi re i partído cananísta; teʼuri i ma Júdas Iscarióte chi xoʼon panok xcʼayiw i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","I cablajuj-le, Jesus xe u tak bic, y xu bij bi chique: —Are que i solij i tinimit, mix ʼe pa i je jekel wi i ne te aj Israel winak; xak mix oc pa tak tinimit re i Samária. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Xui cuʼ i aj Israel winak quix ʼe wi; je pacha juban chij, xa je sachnak. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Are quix ʼec, chi paxsaj u tzijol i ʼatbal tzij aj chicaj; chi bij chique chi ya ca jekanic. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Che iwutzirsaj iwabib; che i walijsaj i je camnak; chiwesaj i cʼax chique niʼpa ʼo i yobil lépra chique; xak che iwesaj bi itzel tew chique i winak. Queje ile chi ʼana na. Lic sipam chiwe niʼpa quix tiqui yix chu ʼonquil, ni loʼom taj. Xak mi tzʼonoj i rajil, we xi ʼan i pawor chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Are quix ʼec, n-ti mer nimak rajil qui cʼam bic, xak mi ne chʼutik rajil. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Xak mi cʼam bi i teb, xak mi ne jun chic i camix, xak mi ne jumolaj chic i xajab, xak mi ne i chʼamiy. Mi cʼam bi tak ile, man jun ajchac ʼo re che, wach i cajwax che; i winak quiqui ya na chiwe wach rajwaxic chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Yix, are quix upon che jun tinimit, are quix upon che jun aldéa, chi tzucuj jun winak chi quix u cʼulaj che rachoch; chix jekel chila, cʼa te qui canaj canok are quix el chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Are quix oc ruʼ ja, chi tzʼonoj che i Dios cu ya i uxlambal qui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","I winak chi rajaw ja, we ʼutz i cʼulaxic xqui ʼan chiwe, ca qʼuiji i ʼutz-le piquiwi. We n-ʼus ta i cʼulaxic xqui ʼano, mi tzʼonoj i ʼutz re i Dios piquiwi are quix el ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ique-le, we n-xix qui cʼulaj taj, xak n-cacaj ti u tayic i tzij chi qui bij chique, chix el ʼuri chila. Are quix el che i ja-le, o we xak che i tinimit-le, chi pu can i ulew che iwakan (cʼutbal-re chique chi cʼo qui mac chiquij). ");
INSERT INTO acr_acc_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Katzij i quin bij chiwe: pa qʼuisbal ʼij, are ca ʼat tzij piquiwi tak i tinimit, mas nim na i tojpen ca pe piquiwi i tinimit-le chuwach ile chi xpe piquiwi i queb tinimit Sodóma y Gomórra ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Chitapeʼ, yin quix in tak bi chiquixol i je aj chʼoʼoj chiwij; ix pacha chij ʼuri chiquixol i utiw. Chi ʼana cwent che iwib, pacha coʼon jun cumatz, n-cu ya ta rib che i jun. Xui-ri, chi ʼana che iwib pacha quiqui ʼan i palomax, lic n-ta jun mal quiqui ʼan che jun chic. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Chi ʼana cwent, man ʼo ni winak quix qui jach na piquiʼab i ʼatbal tzij, xak quiqui jic i loʼxic pa tak molbalʼib. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Xak quix qui cʼam bi chiquiwach i gobernador, xak chiquiwach i nimak tak ʼatol tzij xa wumal yin. Xui-ri, queje ile quin i lap na chiquiwach ique, xak chiquiwach i ne te aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Are quix jach na piquiʼab i ʼatbal tzij, mix cʼachir chu chʼobic wach i qui bij chique, xak mix cʼachir chu chʼobic wach u bixquil qui bij na. Are cu rik i ʼor-le, Dios cu bij na chiwe wach i qui bij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Man yix, are quix chʼawic, n-are ti yix quix chʼawic, are u Tewal i Ta chicaj ca chʼaw chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Quiwil na, ʼo i winak que qui jach ni catz qui chaʼ piquiʼab i je aj chʼoʼoj chiquij, camsabal na que; xak je ʼo ni kajawxel queje quiqui ʼan cuʼ i cacʼal. Xak queje i acʼalab, quiqui ʼan che quib je aj chʼoʼoj chiquij i qui kajaw i qui chuch, que qui jach na chique i que camsawic. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Conojel i winak tzel quix quil na xa wumal yin: xui-ri pachin i cu chʼijo cʼa pa qʼuisbal ie, que ʼelsax na ʼuri pa cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","We ix ʼo che jun tinimit y quiqui ʼan chʼoʼoj chiwij, chix ʼanmajok; jix chic che jun tinimit. Katzij i quin bij chiwe, i Achi aj Chicaj ca cʼun na, are maja quix tzalij li che i qui solixic ronojel tak i tinimit pa Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","(Qui tij ni cʼax cumal, pacha quiqui ʼan chwe yin.) Jun tijoxel, na nim ti u ʼij chuwach u ʼij u mayes; xak queje jun ajchac, na nim ti u ʼij chuwach u ʼij u patron. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Jun tijoxel, ca majaw che chi ca quicot ruʼ, we queʼel na che pacha oʼonom u tijonel; xak queje jun ajchac, ca majaw che chi ca quicot ruʼ we queʼel na che pacha oʼonom u patron. Jun rajaw ja, we quiqui bij ni winak chi ire itzel, xak jun ʼuri quiqui bij na ique chiquij i ralcʼwal. (We queje xqui bij ile chwe yin, xak queje quiqui bij na ʼuri chiwe yix.) ");
INSERT INTO acr_acc_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Rumal-i, mi xij iwib chique i winak, wach quiqui ʼan chiwe. (Chi ʼana co che i cʼux chu bixquil in tzij chique.) Niʼpa i n-ʼalijinsam taj, ca ʼalijinsax na; niʼpa i uwam u wach, ca ʼiltaj ni u wach. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Niʼpa i quin bij chiwe chaʼab, chi paxsaj yix pa ʼij; niʼpa i quin bij chiwe aliʼal, chix siqʼuin chu bixquil chique i winak puwi tak ja. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Mi xij iwib chique i que tiqui chu camsaxic i chʼacul, xui-ri i iwanima n-que tiqui ta che. Are, chi xija iwib che i Jun, chi ʼo puʼab cu sachsaj u wach i chʼacul xak i iwanima pa ʼaʼ. (Xui i Dios ʼo puʼab cu ʼan ile.) ");
INSERT INTO acr_acc_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Yix, i Dios lic quix rilo. Iwetaʼam chi are qui loʼ queb tzʼiquin xa jun centávo i cajil. N-ta kas cajil chiwach yix. Xui-ri, i Dios lic que u rilo; mi jun chique ca tzak li pulew we i Kajaw yix chicaj n-cu ya ta che. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Xak queje yix, i Dios lic quix rilo. Ire xak retaʼam neri niʼpa i wi ʼo che i jolom chi jujunal. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Mi xij iwib ʼuri; yix ʼut, mas ʼo ni ʼij chiquiwach uqʼuial tzʼiquin. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Conojel niʼpa i quiqui bij chiquiwach i winak chi ique qui yom qui wach wuʼ, xak queje yin ʼuri, quin bij na che in Kajaw chicaj chi je we yin. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Xak niʼpa i quiqui bij chiquiwach i winak chi n-qui yom ti qui wach wuʼ, xak queje yin ʼuri, quin bij na che in Kajaw chicaj chi ne te we yin. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Mi chʼob yix chi in cʼun-nak xa que in chomarsaj ni winak chuwach i jyub taʼaj. N-rumal ta ile in cʼun-nak; in cʼun-nak chu petsaxic chʼoʼoj chiquixol i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Rumal in cʼunbal, quiqui ʼan ni chʼoʼoj jun achi ruʼ u kajaw, jun ali ruʼ u chuch, jun alibaxel ruʼ u chuch ralib. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Queʼelok ʼo ni jujun chique i winak je are quixokil calcʼwal je aj chʼoʼoj chic chiquij. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Xui-ri, jun chi we-yin, ʼo u chac cʼax chin u na ni yin chiquiwach u chuch u kajaw. Xak ʼo u chac cʼax chin u na ni yin chiquiwach u miʼal u cʼojol. We n-queje ta coʼon ire ile, lic n-ca majaw ta che ʼuri we we-yin. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Jun we-yin ʼo u chac ca terej chwij, tupu ca cam na rumal. Pachin n-craj ti u ʼanic ile, n-ca majaw ta ʼuri che chi we-yin. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Pachin jun xa cʼax cu na u cʼaslemal re waral, xa cu sach ʼuri u cʼaslemal chi sakil. Xui-ri, we ʼo jun ca sachsax nu wach u cʼaslemal xa wumal yin, ca yaʼ ʼuri u cʼaslemal sakil. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Pachin jun quix u cʼulaj ruʼ, queʼel na ʼuri pacha yin quin u cʼulaj na ruʼ. Xak pachin i quin u cʼulaj na yin ruʼ, queʼel na ʼuri chi cu cʼulaj ni Jun chi in takawnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iwetaʼam chi jun ajbil u tzij i Dios, coʼon panok ca yaʼ ni sipon che rumal i Dios. Xak pachin i cu cʼulaj jun ajbil u tzij i Dios ruʼ, we xa rumal u takon i Dios, ire ca yaʼ ni sipon ʼuri che xak jun ruʼ pacha i ca yaʼ che i ajbil u tzij i Dios. Xak pachin jun cu cʼulaj jun ʼutz laj winak ruʼ, xa rumal ʼutz i jun chuwach i Dios, xak ire ʼuri i Dios cu ya ni ʼutz che pacha i cu ya che i winak jun chi lic ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Pachin jun cu ya jubiʼ u yaʼ che jun ral in tijoxel yin, we xu ya na che xa rumal teren na chwij, katzij ʼuri xak ca yaʼ ni ʼutz puwi rumal i Dios —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","I Jesus queje ile xutzin chu bixquil chique i cablajuj u tijoxelab wach quiqui ʼano. Teʼuri xa ʼe pa tak tinimit re i jyub-le, xa ʼe chi qui tijoxic i winak chu bixquil u tzij i Dios chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Are ca tijin i Jesus che u chac-le, are ʼuri i ma Wan, aj kajsanel ya, tzʼapim chic pa cárcel. Ire, are xu ta rason wach ca tijin i Crísto chu ʼanic, xe u tak li jujun chique u tijoxelab ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Are xe upon ruʼ i Jesus, xqui tzʼonoj che: —¿Mok yet i Tolke chi u bim i ma Wan chi cat cʼunic? ¿O xa cakoyʼej chic jun chic? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","I Jesus xu bij chique: —Chix tzalij chic ruʼ i ma Wan; chi bij che wach i xi ta, wach i xiwilo chi quin tijin yin chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Chi bij che chi i mawach que tzun chic; xak i je sic, que binic; xak i iwabib chi ʼo itzel yobil lépra chique, que utziric; xak i je tac, que tanic; xak i camnak que walijsaxic; xak i nibaʼib qui tom i ʼutz laj tzij re i quelbal pa cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Xak chi bij che chi ʼutz re ire pachin n-cu sach tu cubibal u cʼux chwe —xu bij i Jesus chique u tijoxelab i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Are xe ʼe ique, i Jesus xu jek u bixquil chique i winak wach oʼonom i ma Wan. —Yix, are xix ʼe che i jyub tzʼinilic chu tayquil i ma Wan, ¿wach xiwoyʼej rilic? ¿Xataba xa xix ʼe chi rilic jun ʼes ca silab rumal i tew? N-are taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","¿Wach ʼu i xix ʼe chi rilic? ¿Xataba xix ʼe chi rilic jun achi, chom u wikic u ʼanom che rib? Xak n-are taj. Niʼpa i ʼo qui ʼuʼ chom pakalic, ne te ʼo pa taʼaj tzʼinilic, xa je jekel pa rachoch i ʼatol tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","¿Wach ʼu xix ʼe chi rilic? ¿Jun ajbil u tzij i Dios? Katzij, are. I jun chi xiwilo-le, lic nim ni u ʼij chiquiwach i je ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Man i ma Wan are i jun chi u bim can i Dios chi cu tak na lok. I Dios u bim can chupam u wuj: Yin nabe quin tak nubi jun ajbil in tzij chawach yet, man cu yijba ni a be chawach. (Queje ile u bim can i Dios chupam u wuj.) ");
INSERT INTO acr_acc_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Katzij i quin bij chiwe: i ma Wan aj kajsanel ya, nim ni u ʼij ire chiquiwach conojel i winak, cʼa chu xebal ʼij sak. Xui-ri, woʼor conojel niʼpa i que oc na pa ʼatbal tzij re i Dios, mas nim ni qui ʼij ique chuwach ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","I ʼatbal tzij re i Dios, je qʼui quiqui ʼan chʼoʼoj chirij. Queje qui ʼanom li ile cʼa are xu jek u chac i ma Wan, cʼa are ʼo wi woʼor. Lic quiqui ʼat qui pen chu ʼatixic. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Queje ile quiqui ʼano, man conojel i ajbil u tzij i Dios ujer, xak i ʼatbal tzij re i mam Moises ʼis xqui bij chi ca cʼun ni u ʼatbal tzij i Dios. Queje qui bim ile conojel, xak queje xu bij i ma Wan are xcʼun ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Y we quiwaj quiwetamaj i sak laj tzij, i ma Wan are i mam Elías chi xqui bij ique ca cʼun na. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","We yix ʼo i xiquin chu tayic, chi ta u be iri. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","I winak woʼor, ¿wach nawi que in junamsaj ruʼ? Xa je pacha acʼalab je cul xol tak be; jutzobaj que siqʼuin chique cachiʼil: “Yix lic n-ta ʼo quiwaj,” quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“Yoj xka xutʼij i suʼ chiwe, péro n-xiwaj ta xix xajawic. Xak xka bixaj jun bix re i bisonbal, péro n-xix oʼ taj,” quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Queje que tijin i winak chu ʼanic woʼor; n-ta ʼo cacaj, man xcʼun i ma Wan chi n-ta kas xu tijo, xak n-ta víno xu tijo, y qui bij yix xa ʼo itzel tew ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Are xin cʼun yin chi in Achi aj Chicaj, ʼis ronojel quin tijo y quin tuʼu, xui-ri qui bij yix chi lic in aj numel, xak in aj ʼabarel, qui bij yix. Xak qui coj in mac chi yin in cachiʼil i ajmaquib, xak i mal laj tak aj tzʼonol alcawal. Xui-ri, we te xi ta u be wach xoʼon i ma Wan, xak wach i quin ʼan yin, quiwetamaj ʼuri chi Dios lic ʼo u noʼoj. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Niʼpa i tinimit pa oʼonom wi uqʼuial milágro i Jesus, i winak chila lic n-xqui jalwachij ti qui cʼaslemal. Rumal-i, xoc ire che i qui yajic. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","—¡Toʼ i wach yix, ix aj tinimit Corazin! Toʼ i wach yix, ix aj tinimit Betsáida. Nic are wi qui coj qui mac i queb tinimit Tíro y Sidon man n-ta Dios cuʼ qui bij yix. Xui-ri, we te in ʼanom uqʼuial milágro chila pacha in ʼanom iwuʼ yix, ique ʼuri ya qui jalwachim tene chic-i qui cʼaslemal. Xak que bison tene-ri rumal i qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Xui-ri yix, are ca cʼun i qʼuisbal ʼij, nim ni tojpen ca pe piwi yix chuwach i tojpen chi ca pe piquiwi ique chi je aj Tíro, je aj Sidon. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Xak yix, chi ix aj tinimit Capernaum, qui chʼob yix lic ix ʼutz, ya mer quix oc chila chicaj, qui bij yix. Xui-ri, ya mer quix kaj pa ʼaʼ. Man i uqʼuial milágro ʼantal chiwach yix, we tene ʼantal ile chiquiwach i aj Sodóma ujer, ique xqui jalwachij tene qui cʼaslemal-i; i qui tinimit-le cʼa ʼo tene-ri woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Xui-ri yix, are ca cʼun i qʼuisbal ʼij, nim ni tojpen ca pe piwi, chuwach i tojpen chi ca pe piquiwi ique chi je aj Sodóma —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Are ʼuri i Jesus xu coj u ʼij i Dios; xu bij che: —Quin tioxij chawe Ta, chi at rajaw i caj ulew. Quin tioxij chawe, man a yom chique i n-ti qui ʼij chi quiqui ta u be wach a chʼobom yet. Xui-ri, awuwam u wach chique i ʼo qui noʼoj, chique i nimak qui nojbal. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Katzij, Ta, queje a ʼanom ile man queje ile cawaj yet —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Teʼuri xu bij chique i winak: —Ronojel niʼpa i ʼolic, in Kajaw u yom pinʼab yin. Mi jun retaʼam wach in patan yin chi in u Cʼojol i Dios, xui i Ta chicaj retaʼam. Xak mi jun retaʼam u wach i Dios, xui yin, chi in u Cʼojol wetaʼam u wach; xak niʼpa i winak chi in ʼalijinsam chique, ique ʼut xak quetaʼam u wach. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Chix pet na wuʼ yin, iwonojel yix chi ix cosnak na, iwonojel yix chi ʼo iwekan; yin quin ya i uxlanem chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Chi ya iwib che in yucu chi quin coj chiwe; chix naw na chwe yin, man yin nim in cʼux, xak ʼutz in cʼux chiwe. Qui rik ni uxlambal i cʼux ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","I yucu chi quin coj yin, n-cʼax taj quix bin ruʼ, xak iwekan quin yaʼo, n-ʼal taj. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Xoʼon chupan jubiʼ, pa uxlambal ʼij, i Jesus ca bin cuʼ u tijoxelab pa ticon re i trígo. I u tijoxelab, xpe numic chique; xe oc chu chʼupic u wach i trígo; xe oc chu pochʼic, y xqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","I aj Fariséo winak, are xquil ile, xqui bij che i Jesus: —Chawilapeʼ, i a tijoxelab, n-ʼus taj que chacun woʼor pa uxlambal ʼij. I ʼatbal tzij tzʼibtal can rumal i mam Moises n-cu ya ta chique quiqui mol cosech woʼor —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","—¿Katzij nawi? —xu bij i Jesus—. ¿Xataba n-iwilom ti yix chupam u wuj i Dios wach xu ʼan i mam David ujer? ");
INSERT INTO acr_acc_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ire, cuʼ i rachiʼil are xpe numic chique, xoc pa rachoch i Dios y xu tij i loʼlaj caxlanwa, chi yatal chuwach i Dios. I caxlanwa-le, xui yatal chique i sacerdóte quiqui tijo; n-yatal ta chique i toʼ winak quiqui tijo —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Xataba xak ni tom ti yix wach i tzʼibtal can chupam i ʼatbal tzij re i mam Moises? Cu bij chi ʼo u chac que chacun i sacerdóte pa rachoch i Dios pa uxlambal ʼij. N-mac ta ile, tupu n-que uxlan taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Bay, chi ʼo wi Jun chiwach yix chi nim ni u ʼij chuwach i rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Yix n-qui ta tu be wach u bim i Dios chupam u wuj. Xu bij iri: “Cwaj yin ʼo ni cʼaxnabal i cʼux; n-are ti toʼ u sujuxic chicop chinwach.” (Queje ile tzʼibtal canok.) We tene qui ta u be ile, n-qui coj ta ʼuri qui mac i winak chi n-ta jun qui mac. (In tijoxelab-le n-ti qui mac que tijin chu ʼanic.) ");
INSERT INTO acr_acc_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Yin, chi in Achi aj Chicaj xak in ʼo puwi i uxlambal ʼij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Teʼuri i Jesus xel pa ticon, xa ʼe pa molbal quib i aj Israel. Are ʼo chila, xril jun achi lic chakijnak u ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Chila xak je ʼo juban achiab, quiqui tzucuj u mac i Jesus; xe oc ʼuri chu cʼamic u pam. —¿ʼUtz nawi cutzirsax jun iwab pa uxlambal ʼij? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","I Jesus xu bij chique: —Yix, we ʼo jun i chij, we ca tzak chupam jun siwan che i uxlambal ʼij, ¿xataba n-quiwesaj ta lok, we pa uxlambal ʼij? Quiwesaj pues. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¿Xataba jun achi n-tu ʼij chuwach jun chij? Jun achi mas ʼo u ʼij pues. Rumal-i, yatal ʼuri chake caka ʼan i ʼutz che jun winak pa uxlambal ʼij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Teʼuri xu bij che i achi: —Cha sucʼba i a ʼab —coʼon che. Are ʼuri i achi xu ji pan u ʼab, y xutziric; xcanajic pacha u ʼanom i jun chi ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Teʼuri i aj Fariséo winak xe ʼec; xe oc ʼuri chu chʼobic chiquiwach wach u camsaxic i Jesus quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","16","I Jesus, are xu ta wach cacaj quiqui ʼan che, xel chila; y je qʼui i winak xe terej bi chirij. I Jesus ʼis xe u cunaj iwabib, xui-ri, xu bij chique chi n-quiqui bij taj pachin ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Queje ile xeʼelok xak jun ruʼ pacha u bim can i Dios chupam i wuj tzʼibtal can rumal i mam Isaías. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Are iri are i wajchac chi in chom na; ire lic cʼax quin naʼo, lic quin quicot rumal. Quin tak bi in Tewal puwi ire, y que u bij chique conojel i tinimit chi ʼo ni tobal-que chuwach i tojpen chi ca pe na. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ire n-craj ta quiqui chap quib chi tzij, xak n-ca siqʼuin taj; xak n-ca taqʼui ta pa tak be, cu ʼanbej re nimak tak u bixquil chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ire n-coʼon ta cʼax che jun chi n-tu choʼab: we ʼo jun winak pacha jun ajij cotquic, ire n-cu qʼuis ti u patzʼic; xak we ʼo jun winak pacha jun cantil cu rayij ca chupic, ire n-cu qʼuis ti u chupic. Queje coʼon ire ile, cʼa ca pe ni ʼutz sucʼulic chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","I ronojel tak i tinimit, quiqui cuba ni qui cʼux che ire, chi rumal ire que ʼel ni ique pa cʼax. (Queje ile u tzij i Dios chi u tzʼibam can i mam Isaías.) ");
INSERT INTO acr_acc_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Teʼuri ʼo jun achi mawach, cʼamtal bi chuwach i Jesus. Ire xak mem, man ʼo jun itzel tew che. I Jesus xu rutzirsaj, teʼuri i achi chi mawach xtzunic, xak xchʼawic. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Conojel i winak lic xqui bisoj che, y xqui bij: —¿Mokxa are i Tolke chi koyʼem? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Xui-ri, i je aj Fariséo are xqui ta, xqui bij: —N-are taj. I achi-le, i choʼab chi ʼo ruʼ xa ruʼ itzel ca pe wi. Are i rumal ʼuri ca tiqui chi relsaxic bi itzel tew. I choʼab chi ʼo ruʼ, xa ruʼ i Beelzebu ca pe wi, chi ʼo piquiwi itzel tak tew —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","I Jesus retaʼam wach quiqui chʼobo, y xu bij jun tijojbal tzij chique, cʼutbal-re chi n-katzij taj wach que tijin chu bixquil. Xu bij: —I ʼatbal tzij re jun tinimit, we quiqui ʼan tak tzobajil che quib man quiqui ʼanbej chʼoʼoj chiquiwach, xa quiqui sach qui wach ʼuri. Xak queje jun tinimit, xak queje i je alal; we n-junam ti qui wach, we quiqui jach quib chiquiwach, n-que najtin ta ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Xak queje queʼel ile che i Satanas, man we ʼo jujun itzel quiqui ʼan chʼoʼoj chiquiwach je itzel, n-que najtin ta ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Qui bij yix chi ruʼ u choʼab i Beelzebu xwesaj bi itzel tew. Bay, xak i tijoxelab yix xak caquesaj bi itzel tew chique i winak; ¿pachin yawnak i qui choʼab ique ʼut? Ile quiqui ʼan i tijoxelab yix; ca ʼalijin ʼuri chiwe chi n-usucʼ taj wach i xi bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Xui-ri, yin que wesaj bi itzel tak tew rumal u Tewal i Dios chi ʼo wuʼ. Ile ʼut cʼutbal-re chiwe chi i ʼatbal tzij re i Dios ya ʼo chic chi. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Qui bij yix chi ruʼ ni u choʼab itzel, xwesaj bi itzel tew-le. Xui-ri, mi jun ca tiqui che oquic pa cu ʼat wi tzij jun (pacha itzel), chi relsaxic wach i ʼo puʼab, we maja u ximom i jun-le. We u ximom chic, teʼuri ca tiqui chi relsaxic wach i ʼo puʼab —xu bij chique. Xak xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","—Pachin n-cu ya tu wach wuʼ, ire aj chʼoʼoj ʼuri chwij. Xak pachin jun n-quin u to ta che i molonic, ire xa cu quichersaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Rumal-i quin bij chiwe, chi ʼana cwent xak manal mi bij chirij u Tewal i Dios. I winak, ca cuytaj ni qui mac chique, xak niʼpa i n-ʼus taj chi quiqui bij; xui-ri, we quiqui bij mal laj tak tzij chirij u Tewal i Dios, ile n-ca cuytaj ta chic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","I winak, we cʼax que chʼaw chwij yin, ile ca cuytaj na chique; xui-ri we cʼax que chʼaw na chirij u Tewal i Dios, i mac-le lic n-ta u cuytajic. N-ca cuytaj ta woʼor, xak mi ne coʼon panok, are cu jek u ʼatbal tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Jun cheʼ, we ʼutz laj cheʼ, cu ya u wach ʼutz; xak we n-ʼus ta laj cheʼ, i u wach xak n-ʼus taj. Jun cheʼ ca ʼiltaj na che u wach we ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Yix ix racʼal cumatz! ¿Wach nawi u bixquil i ʼutz qui ʼan na? man lic ix mal. Jun, are ca chʼawic, wach i quel pu chiʼ, pu cʼux petnak wi, niʼpa u molom rib chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Jun ʼutz laj winak, ʼutz i cu bij, man ʼutz i ʼo pa ranima; xak jun mal laj winak, n-ʼus ti cu bij, man n-ʼus ti ʼo pa ranima. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Y yin quin bij chiwe, are ca cʼun i qʼuisbal ʼij, conojel ʼis quiqui bij na chuwach i Dios wach tak i tzij qui bim chi n-ʼus taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Rumal wach i a bim, ca ʼat ni tzij pawi, ca ʼiltaj ʼuri we ʼo i a mac, o we n-taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Je ʼo jujun aj Fariséo winak, tak jujun aj tijonel re i ʼatbal tzij, xqui bij che i Jesus: —Tijonel —xe cha—, cakaj cakil jun milágro, cʼutbal-re chake chi Dios ʼo awuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","I Jesus xu laʼ u wach chique: —I winak woʼor, lic je mal na, lic n-quiqui coj ta chic i Dios. Yix qui rayij ca ʼan ni jun milágro chiwach, cʼutbal re u choʼab i Dios wuʼ; xui-ri, n-ta jun milágro ca ʼan ni chiwach. I tom chic wach i milágro xa ʼani che i ma Jonas, chi ajbil u tzij i Dios ujer. Xui i milágro-le quiwil na. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ire xu chʼij oxib ʼij, oxib aʼab, chupam i nim laj car; bay, xak queje quin ʼan ni yin, chi in Achi aj Chicaj; quin chʼij ni oxib ʼij, oxib aʼab, quin muktaj na. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Are ca pe i ʼij chi ca ʼat ni tzij piquiwi i winak, i aj Nínive chi xe u pixbaj i ma Jonas, quiqui coj na i mac yix ix winak re woʼor. Queje quiqui ʼan ni ile, man i winak aj Nínive xqui jalwachij qui cʼaslemal are xupon i ma Jonas chu bixquil u tzij i Dios chique. Xui-ri, yix lic n-qui jalwachij ti cʼaslemal tupu ʼo Jun chi, mas nim ni u ʼij chuwach i ma Jonas; rumal-i quiqui coj na i mac. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Xak i ixok, chi ujer ʼatol tzij re i pa Sur, xak ire cu coj ni i mac yix ix winak re woʼor, are ca pe i ʼij chi ca ʼat ni tzij piquiwi i winak. Queje cu ʼan na ire-le, man yix n-quiwaj ta qui ta i Jun chi ʼo u noʼoj. I ixok-le, lic mas naj xpe wi chu tayic u nojbal i ma Salomon, chi mas ʼo u noʼoj. Y woʼor ʼo Jun chi, nim ni u ʼij chuwach i ma Salomon, péro yix n-quiwaj tu tayic wach i cu bij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","I Jesus xak xu bij i tzij-i chique: —Jun itzel tew, we xel che jun winak, xa ca bin pa chakij jyub chu tzucuxic pa cuxlan wi, y n-cu rik taj. Teʼuri cu chʼob pu jolom: ");
INSERT INTO acr_acc_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","“Quin tzalij chic che i wachoch pa i xin el wi” cu bij; y ca tzalij chic ʼuri. Are cupon tan chic ruʼ achi, cu riko pacha jun ja n-tu pam, lic josʼim, lic yijbam na che jun rajaw cʼacʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Teʼuri i itzel tew que u tzucuj bi rachiʼil, y que u rik je wukub chic, mas je mal chuwach ire. Que u cʼam bi ruʼ, y conojel que oc che achi. Chila que jeki wi. Teʼuri i achi-le, queʼelok mas mal na chuwach li ujer. Xak queje ile queʼel chique i winak re woʼor (man yix n-ta jun cʼutunic ʼutz qui ya chique, quiqui cʼolbej piqui cʼux —xu bij i Jesus chique i aj Fariséo). ");
INSERT INTO acr_acc_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","I Jesus cʼa ca chʼaʼat cuʼ i winak are xe upon u chaʼ, xak i u chuch. Ique je ʼo chi sak, cacaj que lapan ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Are ʼuri ʼo jun achi xu bij che i Jesus: —I a chuch cuʼ i a chaʼ je ʼo chi sak, cacaj que lapan awuʼ —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Xui-ri, i Jesus xu bij che i achi: —¿Je pachin in chuch, je pachin in chaʼ? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Are ʼuri, xu cʼut che u ʼab niʼpa i u tijoxelab je ʼo ruʼ, y xu bij: —Ique-le je are in chuch, je in chaʼ —xu bij—. ");
INSERT INTO acr_acc_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Pachin i que tijin chu ʼanic pacha craj in Kajaw chicaj, je are in chuch ʼuri, je are in chaʼ, je are i wanab —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Che i ʼij-le, i Jesus xel ruʼ ja, xa ʼe chu chiʼ i alagun, y xcubi chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Are ʼuri xe moltaj tan chic uqʼuial winak ruʼ. Rumal-i, i Jesus xa ʼan chupam jun bárco, y xcubi chupam. Je niʼpa i winak ʼis xe canaj chi tak seneb. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Teʼuri xu jek u cʼutic juban tak tijojbal tzij chique. Xu bij: —ʼO jun achi ca ʼe chu tiquic u ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Are xe u quirij i rijaʼ, ʼo jubiʼ xa ʼe tzak pa be. Teʼuri xe cʼun i tzʼiquin y xqui tij bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Xak ʼo jubiʼ chic xa ʼe tzak pa tak abaj, chi n-ta kas ulew che. I ija-le, juntir xalax lok, man n-muktajnak ta mas. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Xui-ri, are xel li ʼij, xchakij na, man n-ta raʼ ʼenak pulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Xak juban chic xa ʼe tzak pa qʼuix; i qʼuix xqʼuiyic, y xu camsaj i ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Xak ʼo ni ija xa ʼe tzak pa ʼutz laj ulew; lic qʼui ni u wach xu yaʼo. ʼO ni rakan xu ya jun ciénto u wach; xak ʼo i xu ya sesénta; xak ʼo i xu ya tréinta —xu bij. Teʼuri xu bij chic: ");
INSERT INTO acr_acc_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","—We yix ʼo i xiquin chu tayic, chi ta u be ʼuri —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","I u tijoxelab i Jesus, are xu bij ire ile, xe tejeb ruʼ. Xqui tzʼonoj che: —¿Wuchac xa tijojbal tzij ca bij are cat tijin chu cʼutic chique i winak? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","I Jesus xu bij ʼuri chique: —Yix ʼut, i Dios u yom chiwe qui ta u be wach usucʼ i ʼatbal tzij aj chicaj. I juban winak (chi n-que terej ta chwij) n-quiqui ta tu be. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Queje oʼonom i Dios ile, man niʼpa i quiqui cʼam na wach cu sujuj ire chique, mas cu ya ʼuri chique; queje ile nim ni ʼo cuʼ. Niʼpa i n-cacaj ti u cʼamic wach cu sujuj i Dios chique, quelsax na ʼuri i jubiʼ chi ʼo cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Rumal ʼuri, xa ruʼ tijojbal tzij quin cʼut chique i winak, man ique, tupu que tzunic, n-ta quiquilo; tupu que tanic, n-quiqui ta taj, xak n-quiqui ta tu be. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Queʼel chique pacha u bim i Dios chupam u wuj u tzʼibam can i mam Isaías chi ajbil u tzij i Dios ujer; ire xu bij: Yix, katzij neri, qui ta na, péro n-qui ta tu be; katzij neri, quix taken na, péro n-ta quiwil na. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Man i winak-i, n-cacaj ta quiqui ta u be, xa qui tzʼapim i qui xiquin, xak qui mutzʼum i qui baʼwach, man n-que tzun ta ruʼ qui baʼwach, xak n-que tan ta ruʼ qui xiquin. N-ta quiqui ta u be piqui cʼux, xak n-que cʼun ta wuʼ, col qui cunbej quib. (Queje ile u bim i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Xui-ri yix, n-ix ta queje ile. Lic ʼutz iwe, man i baʼwach yix que tzunic, xak i xiquin que tanic. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Katzij i quin bij chiwe, je qʼui i ajbil u tzij i Dios ujer, xak je qʼui i je terejnak chirij, xcaj te rilic wach quix tijin yix chi rilic woʼor, péro n-xquil taj; xak xcaj u tayic teʼek pacha i quix tijin yix chu tayic woʼor, péro n-xqui ta taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Teʼuri Jesus xu bij chique: —Chi ta ʼuri u be wach usucʼ i tijojbal tzij chi xin bij mier re i aj ticol ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Niʼpa i winak chi quiqui ta i tzij re i ʼatbal tzij aj chicaj, we n-quiqui ta tu be, queʼelok pacha xoʼon ija chi xtzak pa be. Queje i winak-le, man ca cʼun itzel, y cresaj i ʼutz laj tzij chi tictal piqui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Xak i ija chi xtzak pa abaj, ile pacha i winak chi quiqui ta i ʼutz laj tzij, y que quicotic xqui cojo. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Xui-ri, je pacha jun ticon chi n-naj taj ʼenak i raʼ; n-que najtin taj. Are ca pe i cʼax piquiwi rumal i ʼutz laj tzij qui cojom, xak ca pe i qui yoʼyaxic cumal i winak, xa cacoʼtaj canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Xak i ija chi xtzak pa qʼuix, ile pacha i winak chi quiqui ta i ʼutz laj tzij, xui-ri, xa que cʼachir rumal i qui cʼaslemal waral chuwach i jyub taʼaj, xak i qui rayijbal re mas ubitak que; ile xa cu chup i ʼutz laj tzij. Rumal-i n-ta ca wachin chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Are ija chi xe ʼe tzak pa ʼutz laj ulew, ile pacha i winak chi quiqui ta i ʼutz laj tzij, xak quiqui ta u be. Ique lic que wachinic; ʼo jujun chique je pacha i rakan chi xu ya cien u wach; xak ʼo jujun quiqui ya sesénta u wach; xak ʼo jujun quiqui ya tréinta. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","I Jesus xu bij chic jun tijojbal tzij chique, are iri: —I ʼatbal tzij re aj chicaj, queʼelok pacha i tzij-i: ʼO jun achi xu tic i trígo pa rulew; chom laj ija xu tico. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Xui-ri, are ʼis que war conojel, xcʼun jun aj chʼoʼoj chirij i rajaw, y xu tic can mal laj ticon ruʼ i trígo (pacha trígo ca tzunic, péro n-are taj). ");
INSERT INTO acr_acc_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Are xe poʼic, junam xe qʼuiyic; xui-ri, are xpe u wach i trígo, are ʼuri xaʼalijin i juban chi n-trígo taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Teʼuri i ajchaquib xe ʼe chu bixquil ruʼ i rajaw: “Nim laj winak, i ija chi a ticom na, lic chom, ¿pa xpe wi i mal laj ʼes chi ʼo ruʼ?” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","I rajaw xu bij chique: “Xa are jun aj chʼoʼoj chwij xa ʼanaw ile.” Teʼuri i ajchaquib xqui bij che: “¿Cawaj ca ʼe ka michʼa i mal laj ʼes?” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Mi michʼo,” xu bij i rajaw, “man we qui michʼ i mal laj ʼes, mokxa ca michʼtaj i trígo ruʼ,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","“ʼUtz chi ya che ca qʼuiy na, junam ruʼ i trígo. Are cakaj caka jek nu chʼupic u wach i trígo, are ʼuri que in tak bi i aj molonel chi relsaxic i mal laj ʼes. Teʼuri ique quiqui ʼan manoj che, man ca porox na. We xutzin ile, caka mol i trígo y caka ya pu cʼolbal,” xu bij i rajaw. (Are ile are i tijojbal tzij xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","I Jesus xak xu bij jun chic tijojbal tzij chique. Xu bij: —I ʼatbal tzij re aj chicaj queʼelok pacha coʼon jun ija re i mostas, are jun achi cu tic pa rulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","I ija-le, lic chʼutin na chiquiwach i ronojel ija. Xui-ri, we xpoʼic, mas nim na queʼel chiquiwach i ronojel i ticon. Lic nim queʼelok, pacha jun cheʼ; teʼuri i tzʼiquin que cʼunic y quiqui ʼan qui soc che tak u ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","I Jesus xak xu bij jun chic tijojbal tzij chique. Xu bij: —I ʼatbal tzij re aj chicaj coʼon pacha coʼon i cunbal re i caxlanwa. Ile, we jun ixok cu chapo, y cu coj oxib almul arin ruʼ, tupu xa jubiʼ i cunbal ʼo ruʼ, cwalij u wach i ʼor ronojel. (Xak queje ile coʼon i ʼatbal tzij re aj chicaj.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","I Jesus, ronojel i cʼutunic-le, xu bij chique i winak ruʼ tijojbal tzij; n-ta tzij xu bij chique, we n-are ti tijojbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Xeʼelok pacha u bim can jun ajbil u tzij i Dios ujer. Xu bij: Ruʼ i tijojbal tzij quin ʼan wi i cʼutunic chique; quin sakirsaj niʼpa tak i uwam u wach, cʼa chu xebal ʼij sak. (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Teʼuri i Jesus xe u ʼijla bi i winak y xoc pa ja. Are ʼuri i u tijoxelab xe tejeb pan ruʼ y xqui tzʼonoj che: —Cha sakij chake wach usucʼ i tijojbal tzij xa bij, che i mal laj ʼes tictal can pa ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Teʼuri i Jesus xu bij: —Are i ca ticaw i ʼutz laj ija, are yin chi in Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Are i pa quin tic wi, are i jyub taʼaj. Are i ʼutz laj ija, are i winak chi qui jachom quib pa ʼatbal tzij re i Dios; are i mal laj tak ʼes, are i winak ʼuri chi je re itzel. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Are i aj chʼoʼoj chirij i rajaw i ticon, are itzel chi ca ticaw i mal laj ija. Are i molonic re i ticon, are i qui molic i winak pa qʼuisbal ʼij. I ajchaquib chi quiqui mol i ticon, je are i ángel. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","I mal laj tak ʼes, ca mol u chiʼ, y ca cʼak pa ʼaʼ porobal-re. Xak queje ca ʼan ni ile pa qʼuisbal re u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Yin, chi in Achi aj Chicaj, que in tak li in ángel ruʼ in ticon, col qui molbej-que niʼpa i je qui tacpum i cachiʼil pa mal, xak conojel niʼpa i que ʼanaw i mal. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Teʼuri que cʼak na pa ʼaʼ pa orno. Chila que oʼ na; xak quiqui kachʼachʼej uwaque rumal ni uyej quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Teʼuri, niʼpa i je ʼutz chuwach i Dios, que qʼuiji pa cu ʼat wi tzij ire. I qui ʼij qui chomal ique, pacha ca tzun i ʼij. We yix ʼo i xiquin chu tayic, chi ta u be ʼuri. (Queje ile xu bij i Jesus chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","(Teʼuri xu bij jun chic tijojbal tzij. Xu bij:) —I ʼatbal tzij re aj chicaj queje pacha uqʼuial mer muktal chupam juban ulew. Ca cʼun jun achi y cu riko. N-xresaj ta lok, xa cu muk chic can u wi, y lic ca quicotic ca ʼec; ʼis que u cʼayij na niʼpa i ʼo ruʼ. Teʼuri ca petic y cu loʼ i ulew man ʼo i beyomal chupam. (Queje ile i ʼatbal tzij re aj chicaj.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","(ʼO jun chic tijojbal tzij xu bij chique, are iri:) —I ʼatbal tzij re aj chicaj are pacha jun chom laj ral abaj, lic pakal rajil, pérla ca bix che. Jun aj cʼay pérla, ca ʼe chu tzucuxic i tak i pérla, y cu loʼo. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Ire, we xu rik jun chi lic chom, lic pakal rajil, ca ʼe chu cʼayixic ronojel i ubitak-re, loʼbal-re. (Queje coʼon ire ile man lic chom; xak queje ile i ʼatbal tzij re aj chicaj.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","(Teʼuri xu bij i Jesus chique:) —I ʼatbal tzij re aj chicaj queje pacha jun ataraya. I je aj chapol car, are quiqui cʼak bi i ataraya pa ya, ʼis bi chi caril cu chap lok. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Are nojnak chic i ataraya, caquesaj li ʼuri chu chiʼ i ya. Teʼuri que cubi chi qui tzucuxic i ʼutz chique i car. Niʼpa i ʼutz, que qui cʼol na chupam jun chicach; i ne te ʼutz, que qui cʼak bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Queje coʼon ni ile pa qʼuisbal ʼij; que ʼel ni ángel chi qui chayic i ne te ʼutz chiquixol i je ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Teʼuri que cʼak na pa ʼaʼ pa orno. Chila que oʼ na; xak quiqui kachʼachʼej uwaque rumal qui bis. (Queje ile i tijojbal tzij xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Teʼuri i Jesus xu tzʼonoj chique: —¿Xi ta u be ronojel iri? —coʼono. Katzij —xqui bij—, xka ta. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Teʼuri xu bij chique: —Jun tijonel re i ʼatbal tzij tzʼibtal can rumal i mam Moises, we ire nawnak che i tzij chi quin bij yin re i ʼatbal tzij aj chicaj, ʼutz re ire ʼuri. Queʼel ire pacha jun rajaw ja chi ʼo ubitak-re cʼacʼ, xak ʼo i re ujer. Che i queb-le ʼis cu chapo. (Queje ile xu bij chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","I Jesus, are xutzin chu bixquil i tak tijojbal tzij-le, xel chila pa Capernaum y xa ʼe pa Nazaret. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Chila xoc chu cʼutic chique i aj Israel winak pa qui molbalʼib. Ique, are xqui ta, lic xqui bisoj che. Xqui bij ʼuri: —¿Ipa xa ʼe u nawsaj wi rib i achi-le, chi lic ʼo u nojbal? ¿Wach u tiquilem che i milágro-le? ");
INSERT INTO acr_acc_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Ire xa are racʼal i mam chi aj ʼanol mexa, xak i u chuch xa are ati Mariy. I je u chaʼ xa are i a-Jacóbo, i a-Jose, xak i a-Simon, i a-Júdas. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Xak i ranab je jekel chi kuʼ yoj. ¿Ipa xretamaj wi ʼut ronojel ile? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Rumal-i, lic n-xcaj taj wach i xu bij, wach i xu ʼano. Are ʼuri i Jesus xu bij chique: —Jun ajbil u tzij i Dios, conojel i winak quiqui coj u ʼij, xui i je rach aj tinimit n-quiqui coj tu ʼij, xak queje i je aj ruʼ rachoch —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Ire n-ta kas milágro ʼuri xu ʼan chila, man ique n-ta u cubibal qui cʼux che. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Che tak i ʼij-le, i ma Heródes, chi ʼatol tzij re i jyub Galiléa, xu ta rason wach coʼon i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Xu bij ire chique i rachiʼil: —Ire-le, are i ʼetz ma Wan, aj kajsanel ya, ya walijnak chic che i camic —xu bij—. Are i rumal ʼuri chi ʼo i choʼab ruʼ chu ʼonquil i milágro —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","I u camic i ma Wan, queje iri xicʼaw wi: i ma Heródes xu tak u chapic i ma Wan y xqui ximo, y xqui cʼam bi pa cárcel. Queje xoʼon ire ile rumal i rixokil. I ixok-le, ati Erodiys u bi, are i rixokil i ma Felípe chi catz qui chaʼ quib ruʼ i ma Heródes. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","I ma Wan u bim ujer che i ma Heródes: —N-ʼus taj chi ca ʼan awixokil che i ixok-le —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Rumal-i, i ma Heródes craj cu camsaj i ma Wan, xui-ri xu xij rib chique i winak. Conojel i winak qui cojom chi i ma Wan lic ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Are xcʼun i nimaʼij re u ʼij i ma Heródes, xcʼun i ralit i ati Erodiys, xa xajaw chiquiwach conojel i je ʼo ruʼ. I ma Heródes lic kus xrilo. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Rumal-i xu bij che i ali chi cu ya na che pachique tak ca tzʼonox che, y xu cuxtaj u bi i Dios puwi wach i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","I ali, ya bital chic che rumal u chuch wach i cu tzʼonoj; are ʼuri xu bij che i ma Heródes: —Cha ya li u jolom i ma Wan aj kajsanel ya; waral chupam jun plato cha ya chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","I ma ʼatol tzij lic xbisonic are xu ta ile. Xui-ri, xu tak u ʼanic pacha xbix che, man ire xu cuxtaj u bi i Dios puwi wach i xu sujuj che i ali. Xak niʼpa i je ʼo chila ruʼ ʼis xqui ta wach i xu bij; rumal-i, xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Are ʼuri xu tak i relsaxic u jolom i ma Wan pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Teʼuri xqui cʼam li u jolom chupam jun plato, y xqui ya che i ali; ire xa ʼe u jacha che u chuch. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Teʼuri xe upon i u tijoxelab i ma Wan chu cʼamic i u chʼacul; xqui cʼam bic y xqui muku. Teʼuri xe ʼe qui bij che i Jesus chi xcamsax i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","I Jesus, are xu ta ile, xel chila utuquel. Xoc bi chupam jun bárco, xa ʼe che jun jyub tzʼinilic. Xui-ri, i winak lic xqui ta pa xa ʼe wi. Ique xe ʼel pa tak qui tinimit, xe sutin chu chiʼ i ya, xe ʼe chu cʼulaxic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ire, are xel pa bárco, xe ril tan chic uqʼuial winak je ʼo chila. Lic xril toʼbal qui wach, y xe rutzirsaj i iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Are ya coc aʼab, i u tijoxelab xe tejeb pan ruʼ y xqui bij che: —Ya xkaj i ʼij; i waral-i n-ta winak jekel chi. Che a ʼijla bi i winak; cha ya chique que ʼe pa tak aldéa chu loʼic wach i quiqui tijo —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","I Jesus xu bij chique: —N-tu chac que ʼec; chi ya yix chique wach quiqui tij na —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","—N-ta kuʼ yoj wach caka ya chique; xui joʼob caxlanwa ruʼ queb car —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","—Chi cʼama li waral —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Teʼuri xu bij chique i winak chi que cubi chuwach tak qʼuim. Ire xu chap i joʼob caxlanwa xak i queb car, xtzun chicaj y xu tioxij che i Dios. Teʼuri xu pir i caxlanwa y xu ya chique u tijoxelab; ique xqui jach chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Conojel ʼis xqui tijo, y xe nojic. Xak xsobrin can cablajuj coban. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","I uqʼuial winak chi xe tzukic, xui achiab ʼo joʼob mil chique, y mas puwi ile je ʼo juban ixokib, tak i acʼalab. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Teʼuri Jesus xu bij chique u tijoxelab chi que oc pa bárco, que ʼax chic chʼakap. Xu bij chique que nabeaj nubi chuwach ire, tzʼakat que u ʼijla bi i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Xutzin ile, xel bi Jesus chuwi jun jyub utuquel chu tzʼonoxic che i Dios. Are xoc aʼab, utuquel ʼo chila chuwi jyub. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Are ʼuri i u tijoxelab je ʼo pa bárco pa nicʼaj ya. I uwi ya lic quel chicaj, quel ʼan chirij i bárco rumal i tew chi lic xpe chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Are ya ca pe u sakiric, i Jesus ca tijin chi be chuwi ya, ca tijin u tejebic cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","I u tijoxelab, are xquilo chi ire ca bin chuwi ya, lic xqui xij quib che. Rumal ʼuri, xe siqʼuin chu bixquil: —¡Ile, jun xibinel! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Are ʼuri i Jesus xu bij chique: —¡Mi xij iwib! Xa yin. ¡Chi cowirsaj i cʼux! ");
INSERT INTO acr_acc_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Teʼuri i ma Pédro xu ʼijla y xu bij che: —Kajwal, we lic katzij yet, cha ya na chwe quin bin awuʼ puwi i ya —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Saʼaj wuʼ —xu bij i Jesus che. I ma Pédro teʼuri xel chupam i bárco y xu jek bi binic chuwi ya, ca ʼe ruʼ i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Xak teʼet xrilo chi lic nim i tew, y xu xij rib rumal. Are ʼuri xu ticba sachic pa ya; rumal-i, xsiqʼuin chu bixquil: —¡Kajwal, chin a to! ");
INSERT INTO acr_acc_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","I Jesus juntir xu chap pan che u ʼab. Xu bij che: —A-Pédro, ¿n-tu cubibal a cʼux chwe? ¿Wuchac xa xij awib? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Are xe oc bi ique pa bárco, i tew xuxlanic. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Are ʼuri niʼpa i je ʼo pa bárco, xe xuqui chuwach i Jesus. —Katzij yet at u Cʼojol i Dios —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Teʼuri xqui maj chubi qui be puwi ya, y xe upon chu chiʼ i taʼaj Genesaret. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","I winak chila, are xquetamaj are i Jesus xuponic, xqui paxsaj rason ronojel i taʼaj-le. Teʼuri xe qui cʼam li niʼpa i iwabib ruʼ i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Lic xqui tzʼonoj che, chi cu ya na chique i iwabib quiqui yin na jubiʼ u chiʼ u ʼuʼ; y niʼpa i xqui chap ni u ʼuʼ, ʼis xe utzir na. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Teʼuri ʼo jujun chique i aj Fariséo winak xe upon ruʼ i Jesus, xak juban tijonel re i ʼatbal tzij re i mam Moises. Ique je petnak cʼa pa tinimit Jerusalen. Are ʼuri xqui tzʼonoj che i Jesus: ");
INSERT INTO acr_acc_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—I a tijoxelab yet, ¿wuchac n-quiqui ʼan ti ka costúmbre chi qui cʼutum can i katit kamam? N-quiqui coj ta retalil che i ujer ʼatbal tzij re u chʼajic qui ʼab are quiqui tij i qui wa —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","I Jesus xu laʼ u wach chique: —Yix ʼut, ¿wuchac xa quix terej chirij i costúmbre? ¿Wuchac ni cojom ti retalil che i méro tzij u bim can i Dios? Xa i canam can u ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","I Dios u bim na: “Cha cojo qui ʼij a kajaw a chuch,” xak u bim na: “Pachin cʼax ca chʼaw chiquij u kajaw u chuch, cha camsaxok.” Queje ile u bim i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Xui-ri, yix qui ya na che jun achi cu bij che u kajaw, cu bij che u chuch: “N-cat in to taj,” cu bij che, “man niʼpa i ʼo wuʼ in sujum chic che i Dios,” cu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Yix, we queje cu bij i jun ile, qui bij na ʼuri, n-ta chic chukul que u to u kajaw u chuch. Queʼel ʼut chi i kajsam u ʼij u tzij u pixab i Dios; xa quix terej chirij i costúmbre yix. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Yix ¡xa queb i palaj! Lic katzij wach u tzʼibam can i ujer ajbil u tzij i Dios, mam Isaías. Lic u tzʼibam canok wach quix tijin yix chu ʼanic woʼor. Xu bij canok chi Dios u bim na: ");
INSERT INTO acr_acc_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","I winak-i lic quiqui coj in ʼij ruʼ qui chiʼ, xui-ri, ruʼ qui cʼux n-quiqui ʼan taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I u cojic in ʼij quiqui ʼano, lic n-ta cu chacuj, man i tzij que tijin chu cʼutic, xa cuʼ winak petnak wi. (Queje ile u bim i Dios —xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Teʼuri xe u siqʼuij i winak ruʼ y xu bij chique: —Chi ta na wach quin bij; chi bisoj u tayic u be wach ca ʼanaw che jun winak chi n-chʼam taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","N-are ti wach coc pu chiʼ ca ʼanaw che chi n-chʼam taj, xa are i tzij chi quel li pu chiʼ; are ca ʼanaw ʼuri che chi n-chʼam taj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Teʼuri i u tijoxelab i Jesus xe tejeb pan ruʼ, y xqui bij che: —¿Xawil yet chi xpe coywal i aj Fariséo che i tzij-le? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","(—N-ta quin chʼob yin che ile. I qui patan ique, n-ruʼ ti in Kajaw petnak wi.) Xu bij i Jesus: —Niʼpa i ticon chi nu ticom ti in Kajaw chicaj, xa que michʼ na ruʼ i raʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Mi coj retalil chique ique; xa je mawach laj tak cʼambeal chique i juban chic mawach. Jun mawach, we cu cʼam bi jun rach mawach, junam ʼuri que ʼe tzak pa siwan —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Teʼuri i ma Pédro xu bij che: —Cha sakij ni tijojbal tzij chake chi xa bij-le —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Are ʼuri i Jesus xu bij: —¿Yix, maja bari qui ta u be wach i quin bij? ");
INSERT INTO acr_acc_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","¿N-qui ta ta bari u be ile, chi wach tak coc chupam jun winak n-are ti ca ʼanaw che chi n-chʼam taj? Xa coc chupam u chiʼ, y ca ʼe che u pam; xa quicʼawic y quel tan chic. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Xui-ri, wach i quel pu chiʼ, pu cʼux ʼuri petnak wi. Are ile are ca ʼanaw chique i winak chi ne te chʼam. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Man xa piqui cʼux ca pe wi ronojel tak n-ʼus taj. Are rumal ʼuri ca pe i qui nojbal chi n-ʼus taj; are rumal ʼuri ʼo i camsanic, xak ʼo i je cʼulanic quiqui kajsaj qui ʼij cuʼ i n-cachijil ta quib; xak ʼo i ne te cʼulanic xak quiqui kajsaj qui ʼij chiquiwach; are ile chi ca ʼanaw chique chi ne te chʼam, y piqui cʼux petnak wi. Xak queje iliʼomab, xak queje i je aj ʼanol mentir, xak queje i je aj nucʼul tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Are i niʼpa ile are ca ʼanaw chique i winak chi ne te chʼam. We jun n-cu chʼaj tu ʼab are cu tij u wa, ile ʼut n-are ti ca ʼanaw che chi n-chʼam tu pu cʼux. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Xoʼon chupanok, i Jesus xel chila, xa ʼe cʼa pa jyub pa ʼo wi i queb tinimit, Tíro y Sidon. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Chila jekel wi jun ixok n-aj Israel taj; ire xcʼun ruʼ i Jesus y co xu bij: —¡Nim laj winak! ¡Yet chi at umuk uxiquin can i mam David! ¡Chawila toʼbal in wach! Jun walit lic ʼo itzel tew che, mas cu tij uyej rumal —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","I Jesus n-ta xu bij che. I u tijoxelab xe tejeb ruʼ y lic xqui tzʼonoj che: —Cha taka bi ixok-le, man toʼ ca siqʼuinic teren li chikij —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","I Jesus n-xu laʼ tu wach chique, xa xu bij jun moxbal tzij che ixok: —I Dios in u takom na lok xui chique i je aj Israel winak, chi pacha je chij je sachnak —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","I ixok xtejeb ruʼ y xuqui chuwach. —Nim laj winak, ¡chin a to! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","I Jesus xu bij jun chic moxbal tzij che ixok: —N-ʼus taj ca maji ni qui wa i acʼalab, we xa ca yaʼ chique i tzʼi —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","—Katzij ile, nim laj winak —xu bij i ixok—, xui-ri, xak i tzʼi xak quiqui mol ni ucʼaj i wa chi ca puk chuxeʼ i mexa re i cajaw —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","I Jesus xu bij ʼuri: —Ixok, ¡lic nim u cubibal a cʼux chwe! Quin ʼan na che awacʼal pacha i cawaj —xu bij. Are xu bij i Jesus ile, juntir xutzir i ralit i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Xoʼon chupanok, i Jesus xel chila y xu tzalej u chiʼ i alagun Galiléa. Teʼuri xel bi puwi jun jyub y xcubi chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Lic je qʼui i winak xe upon ruʼ. Xqui cʼam bi i je sic, xak i je mawach, xak i je mem, xak i je clis, xak juban chic iwabib, je qʼui. Niʼpa i xe qui ya chuwach i Jesus, conojel xe rutzirsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Rumal-i, i winak lic xqui bisoj, man i mem xe chʼaw na; xak i je clis, xe utzir na; xak i je sic, xe binic; xak i mawach, xe tzun na. ʼIs xe oc chu cojic u ʼij i Dios, chi qui Dios i aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Xoʼon chupanok, i Jesus xe u siqʼuij i u tijoxelab ruʼ, y xu bij chique: —Toʼ qui wach i winak-i, man are oxib ʼij iri chi je ʼo chi wuʼ; n-ta chic wach quiqui tijo. N-cwaj ta que in tak bi che cachoch we n-ti wa qui tijom bic, mokxa que tzak pa be —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","I u tijoxelab xqui bij: —¿Pa coj ʼe wi chu cʼamic i wa waral, tzukbal-que uqʼuial winak-i? N-ta jun jekel waral —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","I Jesus xu tzʼonoj chique: ¿Niʼpa i caxlanwa ʼo iwuʼ? —Wukub —xe cha—, ruʼ jubiʼ ral tak car. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Teʼuri i Jesus xu bij chique i winak chi che cubi chuwach ulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ire xu chap i wukub caxlanwa, tak i car. Xu tioxij che i Dios, xu piro y xu ya chique u tijoxelab. Ique xqui jach bi chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Conojel ʼis xqui tijo y xe nojic. Are xquelej ile, i u tijoxelab xqui mol niʼpa i chʼakatak chi xsobrinic; xnoj wukub chicach che. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","I uqʼuial winak chi xe tzukic, xui achiab ʼo cajib mil chique, y mas puwi ile je ʼo ni ixokib, xak i acʼalab. ");
INSERT INTO acr_acc_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Are ʼuri i Jesus xe u ʼijla bi i winak, xoc pa bárco, y xa ʼe che i jyub Magdála. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Xoʼon panok, ʼo jujun aj Fariséo winak cucʼam quib cuʼ juban aj Saducéo xe upon ruʼ i Jesus. Cacaj ique quiqui cʼam u pam i Jesus, rumal-i xqui bij che chi cu cʼut jun milágro chique, cʼutbal-re chi Dios ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ire xu laʼ u wach chique: —Yix lic iwetaʼam usucʼ u wach i caj, wach i coʼono. Are ca kaj i ʼij, we cak, qui bij yix chi “Chwek, chom laj ʼij, man cak i uwacaj,” qui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Xak we ʼo jun u sakirbal, i uwacaj lic cak, xak ʼekmuj, qui bij yix ʼuri chi “N-chom ti ʼij woʼor, man i uwacaj xa cak y ʼekmuj,” qui bij. Yix lic quiwil nu be i uwacaj, wach i coʼono; xui-ri, n-quiwil tu be wach ca tijin i Dios chu ʼonquil che tak i ʼij-i. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","I winak woʼor, lic je mal na, lic n-quiqui coj ta chic i Dios. Yix quiwaj ca ʼan ni jun milágro chiwach, cʼutbal re u choʼab i Dios wuʼ. Xui-ri, n-ta jun milágro ca ʼan ni chiwach, xui pacha i xa ʼan che i ma Jonas ujer. (Queje ile xu bij i Jesus chique.) Teʼuri xe u canaj canok y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Teʼuri i Jesus cuʼ u tijoxelab, xe ʼax chic chʼaka alagun. Ique, xsach chiqui cʼux n-ta qui wa xqui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Are ʼuri i Jesus xu bij chique: —Chitapeʼ, chi ʼana cwent chique i aj Fariséo xak i aj Saducéo; xa je pacha cunbal re i caxlanwa —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","I u tijoxelab n-xqui ta tu be; xe oc chu bixquil chiquiwach: —Xu bij ire ile man yoj n-ta ka caxlanwa ka cʼamom lok —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","I Jesus xu naʼo wach quiqui bij. —¿Wuchac qui bij ile chi n-ta ka caxlanwa? —xu bij chique. ¡Yix n-ta kas u cubibal i cʼux chwe! ");
INSERT INTO acr_acc_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","¿Maja qui ta u be ʼuri? ¿N-ca cʼun ta bawa chi cʼux chi yin, che i joʼob caxlanwa, xe in tzuk ni joʼob mil achiab? ¿I niʼpa i coban xsobrinic? ");
INSERT INTO acr_acc_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Xak n-ca cʼun ta chic chi cʼux chi yin, che i wukub caxlanwa, xe in tzuk ni cajib mil achiab? ¿I niʼpa chicach xsobrin ʼuri? ");
INSERT INTO acr_acc_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Wuchac ʼuri n-qui ta tu be chi n-are ta rumal i caxlanwa xin bij yin ile? ¡Chi ʼana cwent che i cunbal re i caxlanwa que i aj Fariséo xak i aj Saducéo! —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Teʼuri i u tijoxelab xqui ta u be chi ire n-are ti cu bij i cunbal re i caxlanwa. Are i usucʼ i xu bij, are chi qui ʼana cwent che i qui cʼutunic i aj Fariséo xak i aj Saducéo. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","I Jesus, are xe upon pa jyub Cesaréa re i Filípo, xu bij chique u tijoxelab: —¿Wach quiqui bij i winak chi in pachin yin chi in Achi aj Chiaj? ¿Wach quiqui bij ique? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","I u tijoxelab xqui bij: —ʼO jujun quiqui bij chi yet at i ʼetz ma Wan aj kajsanel ya, quiqui bij. Xak ʼo jujun quiqui bij chi yet at i ujer mam Elías; xak ʼo jujun quiqui bij chi at i ujer mam Jeremías, o mok at jun chic ujer ajbil u tzij i Dios. (Queje ile xqui bij i tijoxelab che i Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Are ʼuri xu bij chique: —Y yix, ¿wach qui bij chi in pachin yin? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","I ma Simon Pédro xu bij: —Yet at Crísto (i Tolke chi at koyʼem); at u Cʼojol i Dios cʼaslic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","—¡ʼUtz awe yet! —xu bij i Jesus che—. ʼUtz i xa bij, a-Simon Bar-Jonas. N-ruʼ ta winak petnak wi i tzij-le; lic ruʼ in Kajaw chicaj petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Rumal-i, quin bij chawe: yet at a-Pédro, i usucʼ i a bi queʼelok “abaj”; puwi i abaj-le quin yac i wachoch. Niʼpa i je jutzobaj re i Dios, lic n-ca sachsax tu wach i tzobajil-le; mi tene i u choʼab i camic ca tique che. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Yin quin ya i lawe chawe, chi jakbal-re i ocbal pa cu ʼat wi tzij i Dios. Wach tak i ca ʼatij yet waral chuwach i jyub taʼaj, i Dios cu ya u wach awuʼ. Xak wach tak ca ya na yet chique i je re i Dios chi quiqui ʼan waral chuwach i jyub taʼaj, xak ca yaʼ na chique rumal i Dios —xu bij che i ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Teʼuri xu bij chique u tijoxelab mi jun quiqui lap wi, we are ire i Tolque chi coyʼem. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Teʼuri i Jesus xoc chu sakixic chique u tijoxelab chi ʼo u chac ca ʼe ire pa Jerusalen, xui-ri i nimak tak mamʼib chila, junam cuʼ i cajʼatzil i sacerdóte, tak i je tijonel re i ujer ʼatbal tzij, ire lic cu tij uyej cumal. Xu bij chique chi ca camsax na, y ca walij churox ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Are ʼuri i ma Pédro xu siqʼuij i Jesus ruʼ, y xu bij che: —¡Ay, Kajwal! ¡Ma bij ile! I Dios chu ʼatij ile chi xa bij —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","I Jesus xu pisquilij rib; xu bij che i ma Pédro: —¡Chat el na chin wach, a-Satanas! Ma ʼan latzʼ che in be. A nojbal yet n-queje ta pacha u chʼobom i Dios. Ca chʼob yet pacha quiqui chʼob i toʼ winak —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Teʼuri i Jesus xu bij chique u tijoxelab: —Pachin jun craj ca terej chwij, ʼo u chac mu chʼob chic rib, xui-ri cha terej na chwij, tupu ca cam na rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Pachin jun xa cʼax cu na u cʼaslemal re waral, xa cu sach ʼuri u cʼaslemal chi sakil. Xui-ri, we ʼo jun ca sachsax nu wach u cʼaslemal waral xa wumal yin, ca yaʼ ʼuri u cʼaslemal sakil. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Jun, we cu chʼac ronojel i beyomal re u wach i jyub taʼaj, xui-ri we cu sach u cʼaslemal sakil, n-ta queʼel wi ʼuri, n-ta u chʼacom ʼuri. ¿Wach u tojic ʼuri coʼon na, chʼacbal re u cʼaslemal sakil, we u sachom? N-taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Man yin, chi in Achi aj Chicaj, quin cʼun na ruʼ u ʼij u chomal in Kajaw, xak cuʼ in ángel. Are ʼuri, quin ya na chique i winak chiqui jujunal wach i tojbal-re niʼpa qui ʼanom na. ");
INSERT INTO acr_acc_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Sak laj tzij i quin bij chiwe, je ʼo jujun waral chi n-que cam ta tan, cʼa quin quil na are col in ʼana ni in ʼatbal tzij waral —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wakib ʼij ricʼawic ile, i Jesus xe u cʼam bi i ma Pédro, i ma Jacóbo, xak i ma Wan chi u chaʼ i ma Jacóbo, y xe ʼe quituquel che jun nim laj jyub naj u wi. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Are je ʼo chila, i u tzunbal i Jesus lic xyojtajic; i u palaj lic pacha u tzunbal ʼij ca walchʼinic; xak i u ʼuʼ lic xoʼon sak, pacha i sak re i ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Xak teʼet, xquil i ʼetz mam Moises, xak i ʼetz mam Elías, que chʼaʼat ruʼ i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Are ʼuri i ma Pédro xu bij che i Jesus: —¡Mayes, ʼutz xeʼelok chi oj ʼo chi! We cawaj, caka ʼan oxib mujbal waral, jun awe yet, jun re i mam Moises, xak jun re i mam Elías —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Are ca tijin i ma Pédro chu bixquil ile, xkaj li jutzobaj sutzʼ piquiwi, lic ca walchʼinic, y xe sach chupam. Chupam i sutzʼ-le xqui ta jun chʼawbal: —Iri are in Cʼojol chi lic cʼax quin naʼo —xu bij—, lic quin quicot rumal ire. Chi ta ʼut wach i cu bij —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","I u tijoxelab i Jesus, are xqui ta ile, lic xqui xij quib; xqui jupij bi quib chuwach ulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Are ʼuri i Jesus xtejeb pan cuʼ; xe u yino y xu bij chique: —Chix walijok; mi xij iwib —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Ique, are xe tzun ʼanok, n-ta chic xquilo; xui chic i Jesus ʼo cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Are que tijin li qui kajic tzam jyub, i Jesus xu bij chique: —Niʼpa i xiwil yix, mi lap tan chique i winak, cʼa cu rik niʼ ij are in walijnak chic yin, chi in Achi aj Chicaj —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Teʼuri i u tijoxelab xqui tzʼonoj che i Jesus: ¿Wuchac quiqui bij i tijonel re i ʼatbal tzij chi nabe ca cʼun i mam Elías? Nabe na cakil u cʼunic i mam Elías chuwach i u cʼunic i ʼatbal tzij aj chicaj, quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","I Jesus xu bij: —Katzij i quiqui bij chi mam Elías nabe ca cʼun na, col u yijba ni ronojel. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Xui-ri, yin quin bij chiwe chi mam Elías ya cʼun-nak chic, péro ique n-xquetamaj tu wach. Xa xqui ʼan che niʼpa i xcaj u ʼanic ique. Xak queje yin, chi in Achi aj Chicaj, quin tij ni uyej piquiʼab ique —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Teʼuri i u tijoxelab xqui ta u be chi are i ma Wan aj Kajsanel ya chi ca tijin i Jesus chu lapic chique. U sakirsam chique chi ma Wan pacha i mam Elías ya xcʼunic. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Teʼuri xe kaj li che i jyub y xe upon chic cuʼ uqʼuial winak chi je moltajnak. Are ʼuri ʼo jun achi xtejeb ruʼ i Jesus y xuqui chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nim laj winak —xu bij che—, chawila toʼbal u wach i wacʼal. Ca pe i atac che, y lic cu tij i camic rumal. Qʼuial mul ca tzak pa ʼaʼ, ca tzak pa ya rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","In cʼamom na li waral cuʼ a tijoxelab, xui-ri n-que tiqui ta chi rutzirsaxic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Teʼuri i Jesus xu bij: —¡Ay, yix, n-tu cubibal i cʼux che i Dios; lic ix sachnak na! ¡ʼO tan chi ʼij in ʼo iwuʼ, y yix n-ta i nawic! ¿Niʼpa nawi chic ʼij cʼa craj? —xu bij—. Chi cʼama li acʼal waral —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Teʼuri i Jesus xu yaj i itzel tew chi ʼo che ala, y xa ʼec. I acʼal juntir xutziric. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Teʼuri i u tijoxelab i Jesus, are quituquel chic, xqui tzʼonoj che: —¿Wuchac n-xoj tiqui ti yoj chi relsaxic bi itzel tew-le? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","—N-xix tiqui ta che man n-ta kas u cubibal i cʼux che i Dios —xu bij i Jesus chique—. Katzij i quin bij chiwe: i cubibal i cʼux che i Dios, we lic katzij, quix tiqui chu ʼanic milágro ruʼ. N-ta coʼono we xa pichʼ pacha u nimal jun ija re mostas, we lic katzij, quix tiqui ʼuri chi relsaxic jun nim laj jyub rumal. We tene qui bij che i jyub-i: “Chat el chi; jat chila,” qui bij ne che, pues quel ʼuri. ʼIs quix tiqui chu ʼonquil ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Xui-ri, we quiwaj quiwesaj itzel tew pacha i jun-le, ʼo u chac quix tijin chu tzʼonoxic che i Dios, xak chi mayij ni waʼim rumal —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Xoʼon panok, are que tijin chi be pa jyub Galiléa, i Jesus xu bij chique u tijoxelab chi ire, chi Achi aj Chicaj, ya ca jachtaj na piquiʼab i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Ique quiqui camsaj na; xui-ri churox ʼij ca walij na, xu bij. I u tijoxelab, are xqui ta i tzij-le, lic xe oc chi bis. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","I Jesus cuʼ u tijoxelab, are xe upon pa tinimit Capernaum, ʼo jujun aj tzʼonol alcawal xe upon ruʼ i ma Pédro. Que tijin chu tzʼonoxic i alcawal re i rachoch i Dios. Xqui bij che i ma Pédro: —I tijonel yix, ¿xataba n-cu toj ti impuésto re i rachoch i Dios? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","—Cu tojo pues —xu bij i ma Pédro. Are xoc i ma Pédro paja, i Jesus juntir xu bij che: —¿Wach ca chʼob yet, a-Simon? I ʼatol tzij re u wach i jyub taʼaj, are quiqui tzʼonoj alcawal chique i winak, ¿pachin cuʼ quiqui tzʼonoj wi? ¿Xataba quiqui tzʼonoj chique i je que ique? N-taj. Xui quiqui tzʼonoj chique i ne te cach aj tinimit chi je ʼo chiquixol. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","—Katzij —xu bij i ma Pédro—. Xui chique i ne te cach aj tinimit quiqui tzʼonoj wi. Are ʼuri i Jesus xu bij: —Entons i je re i ʼatol tzij n-quiqui toj taj. Bay, yoj oj re i ʼatol tzij chi lic katzij —xu bij—. ");
INSERT INTO acr_acc_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Xui-ri, n-cakaj ta caka petsaj i coywal; ʼutz jat chiya, ja cʼaka awansuélo pa ya. Chawesaj i nabe car we xchaptaj rumal awansuélo. Pu chiʼ, ca rik wi jun sak pwak. Coʼon ile ca tojbej re i impuésto we yin, xak i awe yet. Cha cʼama bic y cha tojo canok —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Are ʼuri xe tejeb pan i u tijoxelab i Jesus ruʼ, y xqui bij che: —I ʼatbal tzij aj chicaj, are ca pe pakawi, ¿pachin ʼuri naj u ʼij queʼelok? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Are ʼuri i Jesus xu siqʼuij jun acʼal ruʼ, y xu ya chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Xu bij chique: —Katzij i quin bij chiwe: yix we n-qui jalwachij ta i nojbal, we n-qui ʼan ta che iwib pacha u noʼoj jun acʼal, n-quix oc ta ʼuri pa ca ʼat wi i tzij chi ca pe chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Queʼel ʼuri chi pachin coʼon che rib pacha u noʼoj i acʼal-i, pachin coʼon chʼutin che rib, ire ʼut are i mas naj u ʼij pa cu ʼat wi tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","We ʼo jun cu cʼulaj jun acʼal ruʼ pacha iri, rumal i cʼaxnabal u cʼux chwe yin, quel ʼuri pacha yin quin u cʼulaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Jun chʼutin chi u cubam u cʼux chwe, we ʼo jun coʼon che chi ca tzak chupam u mac, nim laj mac ʼuri u ʼanom ire. Mas ʼutz queʼel che, we tene ca xim jun caʼ rij u kul y ca cʼak bi pa ya, jiʼbal-re. I camic-le, mas ʼutz chuwach i mac chi u ʼanom che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Toʼ qui wach i winak waral chuwach i jyub taʼaj, man lic ʼo ni tzaksabal-que! Lic ʼo na; xui-ri toʼ u wach i jun chi cu tzaksaj jun chic chupam u mac. ¡Mi ʼan yix ile! ");
INSERT INTO acr_acc_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","We are a ʼab, we are awakan ca ʼanaw chawe cat macunic, suʼ cha cʼupij y cha cʼaka bic. Mas ʼutz ile, ca rikbej re a cʼaslemal, tupu xa jun a ʼab, xa jun awakan. Mas ʼutz ile chuwach i queb a ʼab, queb awakan we xa cat ʼe pa ʼaʼ rumal, i ʼaʼ chi n-tu qʼuisic. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Xak we are a baʼwach ca ʼanaw chawe cat macunic, ile suʼ chawesaj y cha cʼaka bic. Mas ʼutz ile, ca rikbej re a cʼaslemal, tupu xa jun a baʼwach. Mas ʼutz ile chuwach i queb a baʼwach we xa cat ʼe pa ʼaʼ re i tojpen rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jun chʼutin, mi chʼob yix chi n-ta kas u ʼij. Quin bij ʼu chiwe, i ángel chi je chajal-que nic are wi je ʼo chuwach in Kajaw chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Yin chi in Achi aj Chicaj in cʼun-nak chi qui toʼic niʼpa i je sachnak. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","¿Wach i qui bij yix chi cu ʼan jun achi, we je ʼo cien u chij, we xsach jun chique? ¿Wach coʼon na ire ʼuri? ¿Xataba n-que u canaj ta can i novénta y nuéve che i jyub pa i que wa wi, que u tzucbej re i jun chi sachnak? Que u tzucuj na pues. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Y we xu riko, mas ca quicot ruʼ i jun-le chiquiwach i novénta y nuéve chi n-xe sach taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Xak queje coʼon i Kajaw yix chi ʼo chicaj. Craj ire chi mi jun chʼutin pacha iri ca sachic. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","We ʼo jun awachalal u ʼanom mal chawe, cha ʼijla ʼuri are utuquel; queje ile cha sakirsaj che wach u mac chawe. Ire, we xu ta u be wach i xa bij che, quix canaj chic can ʼuri iwatz i chaʼ iwib. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ire, we n-coʼon ta cas wach i ca bij che, teʼuri che i siqʼuij ni jun chic, queb chic, iwuʼ. Queje ile i je queb oxib quiqui ta wach u cojic u mac ca ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","We xak n-coʼon ta cas ire chique ique, cha bij ʼuri pa molbalʼib. We xak n-coʼon ta cas chique pa molbalʼib, chi ʼana ʼuri che pacha lic n-ta Dios ruʼ, o pacha jun mal laj aj tzʼonol alcawal. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Katzij i quin bij chiwe: wach tak i qui ʼatij yix waral chuwach i jyub taʼaj, i Dios cu ya u wach iwuʼ, xak cu ʼatij chila chicaj. Xak wach tak qui ya chique i je re i Dios chi quiqui ʼan waral, xak ca yaʼ na li chique rumal i Dios chila chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Xak quin bij chiwe: we je ʼo queb chixol yix waral chuwach i jyub taʼaj lic xak jun i qui nojbal are quiqui tzʼonoj che i Dios, in Kajaw chila chicaj cu ya na chique wach i quiqui tzʼonoj. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Queje ile coʼono, man pa je ʼo wi je queb je oxib qui molom na quib wumal yin, xak yin in ʼo na cuʼ ique —xu bij chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Teʼuri i ma Pédro xtejeb ruʼ i Jesus y xu bij che: —Wajwal, ¿niʼpa mul quin cuy ni u mac i wachalal we macun-nak chwij? ¿Cʼa wukub mul quin cuy na? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","I Jesus xu bij: —N-xui ti wukub mul ca cuyu. We a cuyum wukub mul, cha cuyu chic seténta mul i wukub-le —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","(Teʼuri xu bij jun chic tijojbal tzij chique): —I ʼatbal tzij aj chicaj are pacha xu ʼan jun ʼatol tzij; xe u siqʼuij u mocom ruʼ y xu bij chique chi quiqui toj ni qui cʼas ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Are xu jek u ʼonquil ile, xqui cʼam li jun ruʼ chi ʼo uqʼuial mil u cʼas u ʼanom ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","I jun-le lic n-ta ca ʼe u cʼama wi, tojbal na re u cʼas u ʼanom. Rumal-i, i ʼatol tzij xu bij chi ca cʼayix na, junam ruʼ i rixokil, tak i racʼal, xak ronojel i ubitak-re, tojbal na re u cʼas. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Teʼuri i u mocom-le xa xuqui chuwach u patron y xu bij che: “Nim laj winak, cha ya u nimal a cʼux chwe; coqʼuil quin toj ni ronojel in cʼas chawe,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Are ʼuri u patron xril toʼbal u wach, y xu chup u cʼas; teʼuri xroʼtaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Ire xa ʼec; are ʼuri xu cʼulaj jun rach ajchac. I rach ajchac-le, ʼo jubiʼ u cʼas ruʼ; are ʼuri xu chapo y xoc chu chapic pu kul, y xu bij che: “Cha tojo chwe niʼpa a cʼas wuʼ,” coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","I rach ajchac xa xuqui chuwach y xu bij che: “Cha ya u nimal a cʼux chwe; coqʼuil quin toj ni ronojel in cʼas chawe,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","I jun n-xraj taj; suʼ xu chapo y xu tzʼapij pa cárcel. Chila xu ya wi cʼa cu toj ni u cʼas che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Xak je ʼo juban cach ajchaquib xquilo wach xoʼon i jun che i cachiʼil. Ique lic cʼax xqui naʼo wach i xa ʼani che. Rumal-i, xe ʼe qui bij che i qui patron wach u mac i jun xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","I qui patron xu tak u siqʼuixic, y xu bij che: “¡Lic at mal laj winak! Yin xin bij na chawe chi niʼpa i a cʼas wuʼ, ʼis xin cuy na chawe, man lic xa tzʼonoj cuybal mac chwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Rumal-i, ʼo chakul yet queje cha ʼana ni ile, cha cuyu ni u mac i jun we ʼo u cʼas awuʼ. ʼO u chac chawila toʼbal u wach, pacha xin ʼan yin chawe yet, xwil toʼbal a wach.” Queje ile xu bij i ʼatol tzij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Y lic xpe roywal che. Rumal-i, xu tak u tzʼapixic pa cárcel, cʼa cu toj ni ronojel u cʼas che. (Queje ile i tijojbal tzij xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Pa qʼuisbal-re xu bij chique: —Xak queje ca ʼani chiwe yix rumal in Kajaw aj chicaj, we yix chi jujunal n-qui cuy ti qui mac iwachalal ronojel i cʼux —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Are xutzin chu bixquil ronojel ile, i Jesus xel pa Galiléa y xa ʼe pa Judéa. Chila xu ʼaxuj i ya re i Jordan. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Je qʼui i winak je teren chirij; chila xe rutzirsaj iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Are ʼuri xe upon juban aj Fariséo ruʼ; cacaj quiqui cʼam u pam, tzaksabal-re quiqui ʼano. Y xqui tzʼonoj che: —Jun achi, we craj cu jach can i rixokil, ¿wach cu bij i ʼatbal tzij tzʼibtal can rumal i mam Moises? ¿Xa bi chi maquil ʼutz nawi cu jacho? Queje ile xqui bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ire xu laʼ u wach chique: —¿Xataba n-iwetaʼam taj wach i tzʼibtal can chupam u wuj i Dios? Cu bij chi i Dios chu xebal ʼij sak, are xe u ʼan i winak, “jun achi, jun ixok xe u yijba.” ");
INSERT INTO acr_acc_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Xak xu bij i Dios chi “are i rumal ʼuri chi jun achi ʼo u chac quel cuʼ u kajaw u chuch man cacucʼaj quib ruʼ i rixokil. I je queb-le queʼelok xa je jun chi winak.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Rumal-i queʼelok ne te queb chic, ique xa je jun xeʼelok. Rumal-i i winak, n-ta piquiʼab quiqui yoj ile chi u yijbam i Dios xa jun u ʼanom chique. (Queje ile xu bij i Jesus chique i aj Fariséo.) ");
INSERT INTO acr_acc_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Teʼuri xqui tzʼonoj chic che i Jesus: —¿Wuchac ʼuri xu bij i mam Moises chique i achiab chi ʼo u chac quiqui ya jun wuj chique i quixokil, jachbal-que quiqui ʼano? Teʼuri quiqui jach ʼu bic. ¿Wuchac ʼut queje xu bij ire ile, we n-queje ta craj i Dios ile? —xqui bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ire xu laʼ u wach chique: —Queje xu ya i mam Moises ile chiwe man yix lic ix buy. Are rumal ʼuri chi xu ya chiwe qui jach ni iwixokil. Xui-ri, chu xebal ʼij sak, n-queje ti ile u chʼobom li Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Quin bij iri chiwe: we ʼo jun cu jach nubi i rixokil, y we i rixokil n-tu mac u ʼanom ruʼ jun chic achi, i rachijil teʼek ʼo u mac ʼuri chuwach i Dios we xcucʼaj chic quib ruʼ jun chic ixok. Xak we jun achi ca qʼuiji ruʼ jun ixok we xa jachtal can rumal i rachijil, lic ʼo ni u mac ʼuri i ucab achi chuwach i Dios. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Teʼuri i u tijoxelab xqui bij che: —We queje queʼel ile, jun achi ruʼ jun ixok, mas ʼutz ʼuri we n-cu tzucuj ta rixokil —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","I Jesus xu bij chique: —Colo katzij ile, xui-ri n-conojel taj quiqui chʼijo chi n-ta quixokil; xui ique quiqui chʼijo chi yatal u choʼab i Dios cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Je ʼo i achiab chi n-quiqui tzucuj ta quixokil: ʼo jujun chique chi n-tzʼakat ti qui chʼacul chi calaxic; xak ʼo jujun chique chi n-tzʼakat ti qui chʼacul man xa ril ʼantal chique; xak ʼo jujun chi n-quiqui tzucuj ta quixokil rumal u chac i Dios, u chac i ʼatbal tzij aj chicaj. We ʼo jun ca tiqui chu chʼijic ile, chu ʼana na —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Je ʼo jujun winak xe qui cʼam li acʼalab ruʼ i Jesus, cu yabej na re u ʼab piquiwi, xak cu tzʼonbej i ʼutz re i Dios piquiwi. Xui-ri, i u tijoxelab xqui jek qui ʼatixic i je ucʼawnak i acʼalab. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","I Jesus, are xrilo, xu bij chique: —Chi ya chique i acʼalab que cʼun wuʼ; me i ʼatij, man niʼpa i je pacha acʼalab piqui cʼux, ʼo-que che i ʼatbal tzij aj chicaj —xu bij chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Are ʼuri xu coj u ʼab piquiwi i acʼalab; teʼuri xel chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ʼO jun achi, cʼa ala, xupon ruʼ i Jesus y xu bij che: —Nim laj winak, at ʼutz laj tijonel, ¿wach tak i ʼutz quin ʼan na, quin rikbej re in cʼaslemal chi n-tu qʼuisic? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","I Jesus xu bij che: —¿Wuchac ca bij “ʼutz” chwe yin? N-ta jun chi ʼutz, xui Dios —xu bij—. Xui-ri we cawaj cat oc che i cʼaslemal katzij, cha ʼana pacha cu bij u tzij u pixab i Dios —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Pachique che? —xu bij i achi. I Jesus xu bij che: —Mat camsanic; ma kajsaj a ʼij ruʼ jun ixok chi n-awixokil taj; ma ʼan elaʼ; mat tʼoronic; ");
INSERT INTO acr_acc_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cha cojo qui ʼij a kajaw a chuch; y cʼax cha na a loʼcʼanij pacha cʼax u naʼic awib yet —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Ronojel ile ʼis quin tijin chu ʼanic; in ʼanom na lok cʼa are in chʼutin —xu bij i achi che—. ¿Wach cʼa craj quin ʼano? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","I Jesus xu bij che: —We cawaj lic n-ta chic rajwaxic chawe chuwach i Dios, jat, ja cʼayij niʼpa i ʼo awuʼ, y cha jacha chique i nibaʼib. Ca rik ʼuri a beyomal chicaj. Teʼuri chat petok y chat terej chwij —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","I achi, are xu ta ile, lic ca bisonic, man lic beyom; xu maj bi u be, y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Are ʼuri i Jesus xu bij chique i u tijoxelab: —Katzij i quin bij chiwe: i beyomab, cʼax coquic puʼab i ʼatbal tzij aj chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Quin camulij chic u bixquil: cʼax roquic jun beyom, coc puʼab i Dios; cʼax ni ile chuwach i ricʼawic jun camey che i tel re jun acuxa —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","I u tijoxelab, are xqui ta ile, lic xqui bisoj. Teʼuri xe oc chu bixquil chiquiwach: —¿Pachin quelsax na ʼuri chupam u mac? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","I Jesus xe u takej y xu bij chique: —I winak n-que tiqui ta chu ʼanic ile; xui-ri i Dios ronojel ʼis ca tiqui che —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Are ʼuri i ma Pédro xu bij che: —Kajwal, yoj, ronojel niʼpa i ʼo kuʼ, xka canaj canok y oj terejnak chawij. ¿Wach i ca yaʼ chake ʼut? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","I Jesus xu bij chique: —Katzij i quin bij chiwe, are cu rik i ʼij chi ca jaltaj ronojel niʼpa ʼo chuwach i jyub taʼaj, are ʼuri ca yaʼ i ʼij yix. Are ʼo chic i Achi aj Chicaj pa nim laj u ʼatbal tzij, xak yix chi ix terejnak chwij xak ca yaʼ i patan nim u ʼij. Yix ʼuri qui ʼat ni tzij piquiwi i je cablajuj tzobaj aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Conojel niʼpa i coʼtam can ubitak-que wumal yin, nim na quiqui chʼac puwi ile. We ʼo jun u canam can i rachoch, o we i ratz u chaʼ, o we i ranab, o we u chuch u kajaw, o we u canam can rixokil, o we i racʼal, o we i rulew xa wumal yin, nim i cu chʼac na. Ca yaʼ na ʼuri jun ciénto che, puwi niʼpa ile chi xa jun ʼo teʼek ruʼ, xak ca yaʼ jun u cʼaslemal chi n-tu qʼuisic. ");
INSERT INTO acr_acc_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Xui-ri, niʼpa i je nabe woʼor, je qʼui na que canaj can pa qʼuisbal-re; xak je qʼui chi je ʼo can pa qʼuisbal-re woʼor, are ique are i que nabeaj na —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","(Are ʼuri i Jesus xu bij jun chic tijojbal tzij chique, xu bij:) —I ʼatbal tzij aj chicaj coʼon pacha jun rajaw ticon chi que u tzucuj rajchaquib quiqui mol ni u wach i úva. Ire weʼ xa ʼec, que u tzucuj u mocom. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Xu rik u mocom y xu bij chique chi are jun sak pwak i cajil re jun ʼij. Teʼuri xe u tak bi pa chac pa rulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Xoʼon panok, colo a las nuéve re i raʼanbal ʼij, xa ʼe pa qʼuebal. Xe u rika juban achiab n-ta quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Xu bij chique: “We quiwaj i chac, jix pa wulew, je i molo in cosech; y yin quin toj na pacha ca majaw chiwe,” xu bij chique. Ique xe ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Xak queje xoʼon paʼij, xak queje xoʼon a las tres re u kajbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Xak queje tan chic xoʼono are xkaj i ʼij, colo a las cínco: xa ʼe pa qʼuebal, xe u rika juban achiab n-ta quiqui ʼano. Y xu bij chique: “¿Wach qui ʼolba yix chi, jun ʼij? ¿N-ta ba i chac-i?” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Y xqui bij ique che: “Mi jun u sujum chac chake,” xe cha che. “Jix pa wulew,” xu bij i achi, “je i molo in cosech; yin quin toj na pacha ca majaw chiwe,” xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Are ya xoc aʼab, i rajaw i chac xu bij che i ucʼawnak i mocom: “Che a siqʼuij i ajchaquib y che a tojo. Nabe che a tojo bi niʼpa i xe cʼun qʼuisbal-re. Are i je ocnak nabe, qʼuisbal-re che a tojo bic,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Xeʼelok chi are i xe oc a las cínco re i kajbal ʼij, xyaʼ bi jun sak pwak chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Are i je ocnak nabe, quiqui bij ique mas nim ni quiqui chʼac ique chiquiwach i je ocnak qʼuisbal-re, quiqui bij ique. Xui-ri, xak xa jun sak pwak xyaʼ chique chiqui jujunal. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Are xqui chapo, xe oc chu bixquil che i rajaw i chac chi n-ʼus ta xoʼon che i cajil. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Xqui bij: “Are i je cʼun-nak qʼuisbal-re, xak jun i qui tojic xa ʼan kuʼ yoj. Ique, xa jun ʼor xe chacunic, y yoj jun ʼij entera xka chʼij i chac, xka chʼij i ʼij,” xqui bij che i rajaw. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ire xu bij che i jun, “Chatapeʼ, yin n-xix in tʼor taj. ¿Xataba n-xka bij ta wa, chi quix chacun jun ʼij chuwach jun sak pwak? Xka bij pues. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Cha chapa i awajil y jat. Are i cwaj yin, quin ya na che i jun pacha i xin ya chawe yet; n-ta coʼono we xa pa qʼuisbal-re xoquic. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","¿Xataba n-ta we yin che in mer, wach cwaj quin ʼan che? ʼOlic pues. ¿O xa ca titat a pam che, chi ʼutz xin ʼan yin chique i juban?” Queje ile xu bij i rajaw. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Are queʼel ʼuri, niʼpa i je pa qʼuisbal-re, queʼelok je nabe; y xak i je nabe, que ʼelok que canaj cʼa pa qʼuisbal-re. Queje queʼel ni ile, man tupu je qʼui i je sicʼtal na, ne te qʼui je chatalic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Xoʼon panok, i Jesus ca tijin chi be cuʼ u tijoxelab, ʼenam-que pa Jerusalen. Are ʼuri xe u siqʼuij i cablajuj ruʼ, y xe u ʼijla quituquel: ");
INSERT INTO acr_acc_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Yix iwetaʼam ya xka maj bi ka be pa Jerusalen. Are coj upon chila, yin chi in Achi aj Chicaj, quin jachtaj na piquiʼab i cajʼatzil i sacerdóte, piquiʼab i tijonel re i ʼatbal tzij. Ique quiqui ʼat na tzij pinwi y quiqui bij na chi ʼo u chac quin camsaxic. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Teʼuri quin qui jach na piquiʼab i ne te aj Israel winak: ique ʼut quin qui yoʼya, quin qui chʼay na, quin qui camsaj chuwach cruz. Xui-ri, churox ʼij, quin walijsax tan chic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Teʼuri i qui chuch i ma Jacóbo i ma Wan, chi je u cʼojol i mam Zebedéo, xtejeb pan ruʼ i Jesus je rachiʼil i ralab. Xuqui chuwach i Jesus, tzʼonbal-re jun pawor che. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","I Jesus xu tzʼonoj che: —¿Wach cawaj yet? —coʼono. I ixok xu bij: —Are at ʼo chic che a ʼatbal tzij, cwaj yin cha ya chique i queb wacʼal-i que cubi jujun pa tak a tzal, jun pa wikabim, y jun pa moxim —xu bij i ixok che. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","—Yix n-iwetaʼam taj wach i qui tzʼonoj —xu bij i Jesus chique—. Niʼpa i cʼax quin icʼaw na wi yin, ¿quix tiqui yix ʼuri chu chʼijic ile? Niʼpa i uyej chi quin icʼaw na wi yin, ¿quix tiqui yix che ile? —xu bij chique. —Coj tiquiʼic —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Are ʼuri i Jesus xu bij: —Katzij, yix ʼis quix icʼaw na chupam i cʼax-i, xak qui tij ni uyej pacha quin icʼaw wi yin. Xui-ri, n-ta pinʼab yin quin bij pachin ca cubi pin wikabim xak pin moxim. Xui in Kajaw ʼo puʼab; ire u yijbam chic i cʼolbal-le, ire retaʼam pachin que qʼuiji che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","I lajuj chic u tijoxelab, are xqui ta wach i xqui bij i je queb-le chi je catz qui chaʼ quib, ique xpe coywal chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Are ʼuri i Jesus xe u siqʼuij y xu bij chique: —Yix iwetaʼam chi i nimak tak ʼatol tzij quiqui ʼan che quib pacha je cajaw i winak chi je ʼo piquiʼab; i winak chi nimak qui patan que rajawin piquiwi i cach winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Xui-ri; n-ix ta queje yix ile. Are i qui ʼan ni yix, pachin craj queʼelok nim u ʼij, cha chacun ʼuri chiquij i rachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Are pachin craj cu ya rib chu nabeal, chu ʼana ʼuri che rib pacha mocom chiquij i rachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Chu ʼana ʼuri che rib pacha quin ʼan yin chi in Achi aj Chicaj; in cʼun-nak na, pacha mocom chiquij i winak; n-are ti ique je in mocom yin. In cʼun-nak man quin ya na wib chi camic, tojbal-re i quelbal pa cʼax chique uqʼuial winak —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Xoʼon chupanok, ique que tijin quelic pa tinimit Jerico, je qʼui i winak je teren chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chila je ʼo wi queb mawach je chʼuquernak pa be. Are xqui ta chi ya quicʼaw i Jesus, ique xe siqʼuin chu bixquil: —¡Nim laj winak! ¡Yet chi at umuk uxiquin can i mam David, chawila toʼbal ka wach! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","I winak chi je teren bi chirij i Jesus xe qui yajo y xe qui ʼatij. Xui-ri, ique xa xqui cowij mas u bixquil che i Jesus: —¡Nim laj winak! ¡Yet chi at umuk uxiquin can i mam David, chawila toʼbal ka wach! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Teʼuri i Jesus xtacʼ canic y xe u siqʼuij ruʼ. Xu bij chique: —¿Wach quiwaj quin ʼan chiwe? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ique xqui bij che: —Nim laj winak, cakaj coj tzunic —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Are ʼuri i Jesus cʼax xe u naʼo. Xu chap qui baʼwach y juntir xe tzunic. Teʼuri xak ique xe terej bi chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Are nakaj chic je ʼo wi pa Jerusalen, xe upon pa tinimit Betfage, pa ʼo wi i ral jyub Olívos. Are ʼuri i Jesus xe u tak bi queb u tijoxelab, ");
INSERT INTO acr_acc_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","xu bij chique: —Jix che i aldéa-le chi ʼo pan chakawach. Chila qui rik wi jun ati asna yukulic, ʼo jun racʼal ruʼ. Chi toro lok, y che i cʼama lok. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Y we ʼo ca tzʼonow chiwe wach u chac quix tijin chu toric, chi bij che chi cu rik u chac che i Kajwal, y ire juntir cu tzalij chal chawe, chix chok che —xu bij Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Queje xqui ʼan ile, y xeʼel ʼuri pacha u tzʼibam can jun ajbil u tzij i Dios ujer. Ire u tzʼibam canok: ");
INSERT INTO acr_acc_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Cha bij iri chique i aj tinimit Sion: “I ʼatol tzij yix ya ca cʼun iwuʼ. Ire nu ʼanom ta nim che rib, xa cul chirij jun buru ca cʼunic; ca cʼunic cul chirij jun ral buru, racʼal jun ati asna aj ekan.” (Queje ile u tzʼibam can i ajbil u tzij i Dios ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","I u tijoxelab i Jesus xe ʼec y xqui ʼan na pacha i bital chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Xqui cʼam li ati asna ruʼ i racʼal. Teʼuri xqui coj qui ʼuʼ chiquij; i Jesus xa ʼan chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Je qʼui i winak je rachiʼil pa be; ique xqui rip i qui ʼuʼ chuwach, wikbal re i pu be. Xak je ʼo jujun xqui chʼup u xak cheʼ y xqui coj pa be. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","I winak chi je nabe chuwach, xak i je teren lok, conojel xe oc chi sicʼ: —¡Nim u ʼij ire chi umuk uxiquin i ka rey mam David! ¡Dios chu ya ni ʼutz puwi i jun-i chi u takom na lok! ¡Chocsax ni u ʼij i Dios! (Queje ile xe siqʼuin chu bixquil.) ");
INSERT INTO acr_acc_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Are xoc bi i Jesus pa Jerusalen, i winak conojel xe chʼujer na rumal i quicotemal. Je qʼui xe tzʼonowic: —¿Pachin i achi-le? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","—Are i Jesus, chi ajbil u tzij i Dios; ile chi aj Nazaret, u cwenta i Galiléa —xqui bij i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Teʼuri i Jesus xoc pa rachoch i Dios; are ʼuri ʼis xe resaj niʼpa i aj cʼayinel xak i aj loʼonel je ʼo xe ja. Xe u balʼatij qui mexa i je aj jalwachil u wach qui mer i winak, xak queje i qui tem i je aj cʼay palomax. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Xu bij chique: —I Dios, chupam u wuj, u bim can i tzij-i: “I wachoch, lic jun ja re qui tzʼonbal i winak chwe”; xui-ri yix i ʼanom qui jul iliʼomab che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Chila pa rachoch i Dios je ʼo jujun mawach, xak je ʼo jujun je clis je ʼo chila. Ique xe tejeb pan ruʼ i Jesus, y ire xe rutzirsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Xak je ʼo jujun acʼalab je ʼo chila que tijin chi sicʼ: “¡Nim u ʼij ire chi umuk uxiquin i ka rey mam David!” xqui bij. I ajwab sacerdóte, xak i je tijonel re i tzij pixab, are xquilo wach xoʼon i Jesus, are xqui ta qui tzij i acʼalab, ique lic xpe coywal. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Are ʼuri xqui bij che i Jesus: —¿N-ca ta ti yet wach que tijin chu bixquil? ¿ʼUtz nawi ile, ca bij yet? —xe cha. —Katzij xin ta —xu bij i Jesus chique—. Ique que tijin chu ʼonquil pacha u tzʼibam can jun ajbil u tzij i Dios ujer. Ire xu bij che i Dios: Yet a ʼanom chique i acʼalab, xak chique i cʼa que tzʼumanic lic quiqui bixaj a ʼij (—xu bij). ");
INSERT INTO acr_acc_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Are ʼuri i Jesus xe roʼtaj canok y xa ʼe cʼa Betánia, que u ʼana jun aʼab chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Are xsakiric, xu maj chubi u be, xa ʼe pa Jerusalen. Are ca tijin chi be, i Jesus xpe u numic. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Xak teʼet xril jun cheʼ, u cheʼlal hígo, ʼo xucut be. Ire xa ʼe pan ruʼ i cheʼ; lic n-ti u wach xu rik che, xui u xak. Are ʼuri i Jesus xu bij jun cʼokbal tzij che i cheʼ: —¡Yet n-cat wachin ta chic! —xu bij che. Are ʼuri i cheʼ juntir xchakijic. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","I u tijoxelab, are xquil ile, lic xqui bisoj. Xqui bij che i Jesus: —¿Wach xa ʼani che i cheʼ-le, chi juntir xchakijic? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","I Jesus xu bij chique: —Katzij i quin bij chiwe, we lic ʼo u cubibal i cʼux, we lic n-ta cu bij i cʼux, xak yix quix tiqui chu ʼanic pacha i xin ʼan yin che i che-i. Y n-xui ta la ile, xak quix tiqui che, we qui bij che i jyub-i, “Chat el chi, ja cʼaka awib pa mar,” qui bij che, ile lic coʼon na. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Yix, wach i qui tzʼonoj che i Dios, we lic qui cojo chi quiwil na, ca yaʼ na ʼuri chiwe —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Teʼuri i Jesus xoc chic pa rachoch i Dios y xoc chi qui tijoxic chila. Are ʼuri xe tejeb pan i cajʼatzil i sacerdóte ruʼ, xak i nimak tak mamʼib que i aj Israel, y xqui tzʼonoj che: —¿Pachin xyaw ile paʼab chi cat tijin chu ʼonquil? —xqui bij che—. ¿Bi chi ʼatbal tzijal ʼo paʼab, chi queje ca ʼan ile? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","I Jesus xu bij chique: —Xak yin quin tzʼonoj jun tzij chiwe. We qui bij usucʼ chwe, teʼuri xak quin bij yin chiwe bi chi ʼatbal tzijal ʼo pinʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Chi bij chwe pachin xyaw puʼab i ma Wan cu kajsaj ya piquiwi i winak. ¿Are i Dios yawnak che, o xa winak yawnak che? —xu bij i Jesus chique. Ique xe oc chu bixquil chiquiwach: —¿Wach caka bij na che? —que cha—. We caka bij chi are i Dios yawnak ni ile puʼab i ma Wan, ire cu bij na ʼuri chake: “¿Wuchac ʼuri n-xi coj taj wach i xu bij?” ");
INSERT INTO acr_acc_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","We xak caka bij chi xa ruʼ winak petnak wi wach i xu bij i ma Wan, lic caka xij kib chique i winak; man conojel i winak quiqui bij chi ma Wan lic ruʼ i Dios petnak wi wach i u bim —xqui bij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Rumal-i xqui bij che i Jesus: —N-ketaʼam taj —xe cha che. —Xak yin n-quin bij ta ʼuri chiwe wach i ʼatbal tzij ʼo pinʼab, chi quin ʼan tak iri —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Teʼuri i Jesus xu bij chique: —¿Wach qui chʼob yix che i tzij-i? ʼO jun achi, je ʼo queb u cʼojol. I achi xu bij che i jun: “Wacʼal, jat woʼor pa chac chupam in ticon,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","I racʼal xu laʼ u wach che: “N-cwaj taj,” xu bij. Xui-ri, xu jalwachij u noʼoj y xa ʼe pa chac. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Teʼuri i qui kajaw xak xu ʼijla i jun chic, pacha xoʼon che i nabe. Ire xu bij chi ca ʼec; “Ey,” coʼono, xui-ri, n-xa ʼe taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Pachique chique i je queb u cʼojol xoʼono pacha craj i qui kajaw? —xu bij i Jesus chique i nimak tak mamʼib. —Are i nabe —xe cha. —Katzij i xi bij —xu bij i Jesus chique—. Xak quin bij na yin chiwe chi ʼo i je mal laj tak aj tzʼonol alcawal, xak ʼo ixokib ajmaquib que tijin coquic puʼab i Dios, y yix n-taj. Ique je pacha i racʼal i achi chi xoʼono pacha craj u kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Xui-ri yix ix pacha i ucab u cʼojol man n-xix cojon ta che u tzij i ma Wan aj kajsanel ya. Xcʼun ire chu cʼutic chiwe wach craj te i cʼaslemal, xui-ri n-xix cojon taj. I je aj tzʼonol alcawal, xak i ixokib ajmaquib, ique xqui cojo. Tupu xiwil yix ile, n-xi jalwachij ti nojbal, cojbal-re u tzij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Teʼuri xu bij chique: —Chi ta chic jun tijojbal tzij quin bij na chiwe. ʼO jun achi nim i rulew, u ticom úva chuwach. Teʼuri xu coj coral chirij; xu yijba pa quiqui yitzʼ wi u waʼal i úva, xak xu yijba jun ral ja tacʼtic chupam i ticon, chajbal-re ronojel. Teʼuri xe u coj jujun ajchaquib, je aj a média ruʼ; y xa ʼe ire naj che jun tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Are xu rik i ʼij re i cosech, xe u tak li u mocom chu tzʼonoxic i re ire chique i raj mediant. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Are xe upon i mocom, xe qui chapo. I jun, xqui chʼayo; i jun chic, xqui camsaj; i jun chic, xqui coj abaj che. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Teʼuri i rajaw ticon xe u tak chali juban chic u mocom, mas je qʼui na chiquiwach i je nabe. Are xe uponic, i je raj mediant xqui ʼan chic chique pacha xqui ʼan chique i juban chi je nabe. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Pa qʼuisbal-re, xu tak li i mer u cʼojol. Xu chʼob ire: “Ique lic que cojon na che i wacʼal-i,” xu chʼob ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Xui-ri, are xquil i u cʼojol i rajaw ulew, xqui bij chiquiwach: “Are ire-le are i rajaw ulew coʼon panok; chaka camsaj,” xe cha, “man yoj coj canajic oj rajaw,” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Rumal-i xqui chapo, y xquesaj li chuwach ulew, y xqui camsaj. (Queje ile i tijojbal tzij xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Teʼuri xu tzʼonoj chique: —Bay, are ca cʼun ni rajaw i ulew, ¿wach coʼon ni ire chique i ajchaquib-le? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ique xqui bij: —Ire lic que u camsaj ni je aj ʼanol mal-le; lic n-cril ta toʼbal qui wach. Teʼuri cu ya i rulew chique juban chic aj mediant, chi quiqui jach i re ire che, are cu rik i ʼij —xe cha i mamʼib che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Teʼuri i Jesus xak xu bij chique: —¿Xataba n-iwilom taj wach tzʼibtal can chupam u wuj i Dios? Queje iri cu bij: I abaj chi n-xcaj ti xqui coj i je aj ʼanol ja, are i abaj-le chi xeʼelok lic nim ni u chac che i cubibal ja. Are i xeʼelok-le, are i Kajwal Dios xa ʼanawic, y cakil yoj, lic ʼutz ile chi u ʼanom ire. (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Rumal-i, quin bij chiwe chi Dios cresaj ni u chac piʼab yix y cu ya na piquiʼab juban chic ajchaquib je ʼutz, chi quiqui ya ni cosech che i Dios pacha ca majawic. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","I abaj-le chi xin bij chiwe, we ʼo jun ca ʼe tzak puwi, xa ca paxic; xak i abaj-le, we ca tzak chirij jun winak, lic coʼon na cʼajcʼaj che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","I je ajwab sacerdóte, xak i je aj Fariséo, are xqui ta wach i tijojbal tzij xbix chique, ya xquetamaj chi xa are ique que u lap na. ");
INSERT INTO acr_acc_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Rumal-i cacaj ique quiqui chapo, xui-ri xqui xij quib chique i uqʼuial winak, man i winak quiqui bij chi Jesus ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","I Jesus xu jek chic u bixquil i tijojbal tzij chique. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","—I ʼatbal tzij re aj chicaj, pacha iri: ʼO jun nim laj ʼatol tzij xu yijba i nimaʼij re u cʼulanquil i u cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Are xu rik i ʼij, xe u tak bi u mocom cuʼ i je siqʼuim chic, queʼe qui bij chique chi ya yij chic i waʼim. Xui-ri, ique n-xcaj ta xe cʼunic. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Teʼuri xe u tak chubi juban chic u mocom chi qui siqʼuixic. Xu bij chique: “Ji bij chique niʼpa i je in siqʼuim na, chi ya yij chic i waʼim. Chi bij chique chi je in camsam chic i chicop chi je in tiʼojersam. Ronojel ʼis yij chic; ique che petok, chix chok chique.” ");
INSERT INTO acr_acc_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Xui-ri, i je siqʼuim na, n-xqui ʼan ta cas chique i takon. ʼO jun chique xa ʼe pa rulew, xak jun chic xa ʼe chi cʼayinic. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Xak je ʼo jujun xe qui chap i takon y xqui ʼan cʼax chique y xe qui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Rumal-i, i ʼatol tzij lic xpe roywal che; xe u tak bi u soldádo chi qui camsaxic niʼpa i xe ʼanaw i camic-le, xak chu poroxic i qui tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Teʼuri xu bij chique u mocom: “Ronojel ʼis yij chic re i nimaʼij, xui-ri ique chi je in siqʼuim na, n-xmajaw ta chique chi que petic. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Rumal-i, jix yix pa nimak tak be, y che i siqʼuij che i nimaʼij niʼpa i que i rik chila,” xu bij chique u mocom. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Ique ʼis xe ʼel pa tak be, y xe qui mol niʼpa i xe qui cʼulaj. Xe qui mol i je ʼutz laj tak winak, xak i ne te ʼutz. Queje ile xqui nojsaj i u paja. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Teʼuri xoc i ʼatol tzij pa je moltajnak wi i je u siqʼuim ruʼ. Are ʼuri xril jun achi cuʼ chi nu cojom ti u ʼuʼ re i nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Y xu bij che: “Yet, ¿wach awoquic chi, chi na cojom ti a ʼuʼ re i nimaʼij?” xu bij. I jun n-xu rik taj wach cu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Teʼuri i ʼatol tzij xe u siqʼuij i u mocom, xu bij chique: “Chi xima i u ʼab, i rakan, y chiwesaj bi rija pa ʼekum. Chila coʼ na, xak cu kachʼachʼej ni uware rumal u bis,” xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Queje ile queʼelok man tupu je qʼui i je sicʼtal na, ne te qʼui je chatalic. (Queje i tijojbal tzij ile xu bij i Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Are ʼuri i aj Fariséo xe ʼec y xe oc chu chʼobic chiquiwach wach jun tzij quiqui tzʼonoj che i Jesus, tzaksabal-re quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Teʼuri xe qui cha jujun je ʼo cuʼ, xak juban chic chi je teren chirij i ma Heródes, y xe qui tak bi ruʼ i Jesus. —Nim laj winak —xqui bij che, are xe upon ruʼ—, ketaʼam chi yet xui i sak laj tzij ca bij. Ketaʼam chi yet katzij ca cʼut i ʼutz laj be re i Dios, lic n-ca ʼan ta cas che wach quiqui bij i winak chawij. Yet n-ca coj ta retalil che, tupu je nimak tak winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Cha bij ʼu chake, wach i ca bij yet, ¿ʼUtz nawi, caka toj impuésto che i ʼatol tzij, o n-ʼus taj? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","I Jesus xretamaj chi n-ʼus ta quiqui chʼobo are xqui bij ile. Xu bij chique: —Yix, ¡xa queb i palaj! ¿Wuchac xa tzaksabal-we qui ʼano? ");
INSERT INTO acr_acc_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Chi cʼutu jun sak pwak chwe, chi tojbal re impuésto —coʼono. Y xe qui cʼama jun sak pwak. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Are ʼuri i Jesus xu tzʼonoj chique: —¿Pachin u qʼuexwach iri ʼo chuwach? ¿Pachin u bi iri tzʼibtal chuwach? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","—Re i ʼatol tzij —xe cha ique. —Bay, chi ya ʼuri che i ʼatol tzij wach ʼo re ire che, xak chi ya che i Dios wach ʼo re ire che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ique, are xqui ta ile, lic xqui bisoj che. Are ʼuri xqui canaj canok y xe ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Xak are i ʼij-le, je ʼo jujun aj Saducéo xe upon ruʼ. (I aj Saducéo quiqui bij chi i je camnak n-que walij ta chic.) Xqui bij che: ");
INSERT INTO acr_acc_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Nim laj winak, i mam Moises u bim canok chi jun achi, we xcamic, we n-ta racʼal ruʼ can i rixokil, ʼo u chac ʼuri ca cʼuli i ratz u chaʼ i achi ruʼ ixok malcan, pu qʼuexel i camnak. Queje ile ca qʼuiji na can racʼal i camnak ruʼ ixok. Je ile u bim canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bay, oʼonom lok, je ʼo wukub kuʼ yoj, je catz qui chaʼ quib. I nabe chique xcʼuliʼic, y xoʼon panok xcamic, n-ta racʼal. I ixok malcan xcanaj can ruʼ ucab chaʼaxel. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Teʼuri i achi-le xcam chic, i ixok xcʼuli chic ruʼ urox chaʼaxel. I achi-le xak xcamic. Queje xqui ʼan i wukub achiab-le. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Xak xoʼon panok, xcam i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bay, we ta que walij chic i camnak, ¿pachique chique i je wukub-le, chi mer rachijil queʼelok? Man ʼis xcʼuli cuʼ i je wukub achiab-le —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","I Jesus xu laʼ u wach chique: —Yix xa ix sachnak na; n-qui ta tu be wach cu bij u tzij i Dios chi tzʼibtal canok; xak n-iwetaʼam taj wach i nim laj u choʼab i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Are que walij ni camnak, que ʼelok pacha i u ángel i Dios aj chicaj; n-que cʼuli taj. I achiab, i ixokib n-que cʼuli ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","I qui walijbal i camnak, katzij ʼolic. ¿Xataba n-iwilom ti yix wach u bim can i Dios chiwe? U bim can ire: ");
INSERT INTO acr_acc_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","“Cʼa in u Dios i mam Abraham, xak i mam Isaac, xak i mam Jacob,” xu bij. I oxib-le je camnak chic are xu bij i Dios ile. Bay, chuwach i Dios, c a je cʼas na; i Dios n-are ti qui Dios i je camnak, are i qui Dios i je cʼaslic —xu bij i Jesus chique. (Queje ile xu sakirsaj chique chi ʼo ni qui walijbal i camnak). ");
INSERT INTO acr_acc_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","I winak, are xqui ta ile, lic xqui bisoj che i cʼutunic xoʼon i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","I aj Fariséo, are xqui ta rason chi Jesus xtiqui chu laʼic u wach i qui chiʼ i je aj Saducéo, xqui mol la quib. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ʼO jun chique chi tijonel re i ʼatbal tzij u tzʼibam can i mam Moises. Xraj ire xu tzʼonoj jun tzij che i Jesus, tzaksabal-re coʼono. Xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Nim laj winak, ¿pachique tzij re i ʼatbal tzij mas ʼo u chac chi caka cojo? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","I Jesus xu bij che: —“Chawaj Awajwal Dios ronojel a cʼux, ronojel awanima, ronojel a nojbal.” ");
INSERT INTO acr_acc_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Are i jun-le chi mas ʼo u chac coj cojon che; are mas ʼo u ʼij ile chiquiwach i juban. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Teʼuri i ucab tzij (chi ʼo u chac coj cojon che) laj cu maj i jun-le. Cu bij: “Cʼax che a na a loʼcʼanij pacha cʼax u naʼic awib yet ca ʼano,” cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","I queb tzij-le are mer u xebal ronojel tak i ʼatbal tzij u tzʼibam can i mam Moises, xak are u xebal ronojel tak i cʼutunic qui canam can i ajbil u tzij i Dios. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Tzʼakat cʼa qui molom quib i je aj Fariséo, ");
INSERT INTO acr_acc_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","i Jesus xu tzʼonoj chique: —¿Wach qui chʼob yix chirij i Crísto, chi Toliwe iwoyʼem? ¿Pachin i ratit u mam? —xu bij chique. Ique xqui bij: —Ire are ni umuk uxiquin can i mam David —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Are ʼuri i Jesus xu bij chique: —¿Wuchac ʼuri i mam David xu bij “Wajwal” chirij i Crísto are xu lapo? Lic rumal ni u Tewal i Dios xu bij ile. I mam David xu bij i tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Xu bij i Kajwal Dios che i Wajwal Crísto: “Chat cul na pin wikabim, cʼa cu rik ni ʼij que in ya na pawakan niʼpa i je aj chʼoʼoj chawij,” xu bij. Queje ile u tzʼibam can i mam David ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Wach u ʼonquil ʼuri chi Crísto xa umuk uxiquin i mam David? ¿Wach u ʼonquil ile man lic are i mam David xu bij “Wajwal” che i Crísto? (Queje xu bij i Jesus ile chique i aj Fariséo, cu sakijbej-re chique chi Crísto n-toʼ ta winak, lic Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Mi jun chique xu rik chic u laʼic u wach che, mi jupaj. Are xoʼon ile, teʼuri mi jun xu cowij chic u cʼux chu tzʼonoxic mas tzij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Teʼuri i Jesus xoc chu bixquil i tzij-i chique i winak, xak chique u tijoxelab: ");
INSERT INTO acr_acc_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","—I je tijonel re i ʼatbal tzij, xak i aj Fariséo, ʼo chiquikul quiqui sakij chiwe wach usucʼ i ʼatbal tzij chi u tzʼibam can i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Rumal-i chix cojon na che, lic chi ʼana cas che wach i quiqui bij; xui-ri, mi ʼan yix pacha quiqui ʼan ique. Mi ʼan na, man ique n-quiqui ʼan taj pacha tak i quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ique, nim i ekan quiqui ya chiquij i winak, cʼax u chʼijawic; xak n-que ton ta ruʼ, mi xa ta jubiʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ronojel wach i quiqui ʼano, quiqui ʼan na man xa cacaj que ʼiltaj cumal i winak. Kus quiquil u cʼamic bi jupaj u tzij u pixab i Dios pasim chupam jun ral tzʼum chuwach qui palaj. Xak kus quiquil u batzʼcatixic tzʼum rij tak qui ʼab. I tzʼum-le xak tzʼibtal jutakpaj u tzij i Dios chuwach; kus quiquil ique we nim u wach. Xak i u chiʼ i qui ʼuʼ, lic nimak i rismachiʼ ʼo che, mas nimak chuwach i que i toʼ winak. Queje quiqui ʼan ique ile, quiquilbej na re i winak chi lic je re i Dios, quiqui bij ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Are que ʼe pa tak nimaʼij, xa quiqui tzucuj i chomik laj tak qʼuijibal. Are que ʼe pa molbalʼib, xak quiqui tzucuj i qui cubibal chi ʼo u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Are que ʼe pa qʼuebal, lic kus quiqui ta are que tioxix cumal i winak, ocsabal re qui ij. Xak kus quiqui ta are ca bix “nim laj tijonel” chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mi ʼan yix pacha ique-le; mi ya chique i winak chi quiqui bij “nim laj tijonel” chiwe. Man iwonojel yix, iwatz i chaʼ iwib; xa jun i Tijonel yix, are i Crísto. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Xak mi bij i kajaw che jun winak waral chuwach i jyub taʼaj, cojbal re u ʼij, man xa jun i Kajaw ʼolic, are i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Xak mi ya chique i winak quiqui bij “kajʼatzil” chiwe, man xui i Crísto are Iwajʼatzil. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Pachin coʼon mocom che rib chiquij i juban, are i mer nim ʼuri chixol. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Man pachin coʼon nim che rib, ire ʼut xa ca kajsax u ʼij; xak pachin coʼon chʼutin che rib, ire ca nimarsax na ʼuri u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! N-qui cʼut ti sak laj tzij chique i winak; xa qui tzʼapij i uchija re i ʼatbal tzij aj chicaj are ʼo i cacaj que oc bic. Yix n-quiwaj ta quix oc bic, xak n-qui ya ta chique ique que oc bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! Xa qui maj i cachoch ixokib malcanib, teʼuri qui ʼan nimak tak i tzʼonbal che i Dios, xa sachsabal-re chiquiwach i winak, wach i ʼanom. Queje ile i nimarsam ni tojpen chi ca pe na piwi. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! Lic quix ʼe jela, quix ʼe jewa, che i cʼutunic qui ʼano, chʼacbal na re jun i tijoxel. Xui-ri, we xix tiqui che, queʼel ire ʼuri lic mas mal chiwach yix; ca ʼe pa ʼaʼ nabe chiwach yix, xa rumal i cʼutum che. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Toʼ i wach yix chi ix aj cʼambeal chi xa ix mawach. Qui bij yix chi “We jun winak cu cuxtaj u bi i rachoch i Dios puwi i u tzij, n-chukul ta ʼo wi ʼuri u ʼonquil pacha u bim,” qui bij yix. “Péro we cu cuxtaj u bi i óro re i rachoch i Dios, ʼo chukul ʼuri coʼon na pacha i u bim.” Queje qui bij yix ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Lic ix sachnak na; lic ix mawach! ¿Pachique mas ʼo i u ʼij? ¿Xataba are i óro? N-are taj. Are i rachoch i Dios chi mas ʼo u ʼij, y coʼon che i óro chi xak ʼo u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Xak qui bij yix chi “We jun winak cu cuxtaj u bi i altar puwi i u tzij, n-chukul ta ʼo wi ʼuri i u ʼonquil pacha u bim,” qui bij yix. “Péro we cu cuxtaj u bi i sipon chi ʼo puwi i altar, ʼo chukul ʼuri coʼon na pacha i u bim.” Queje qui bij yix ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Lic ix sachnak na; lic ix mawach! ¿Pachique mas ʼo i u ʼij? ¿Xataba are i sipon? N-are taj. Are i altar chi mas ʼo u ʼij, y coʼon che i sipon chi xak ʼo u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","We ʼo jun cu cuxtaj u bi i altar, xeʼel ʼuri xak xu cuxtaj u bi wach tak i ʼo puwi i altar. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Xak we jun cu cuxtaj u bi i rachoch i Dios, xeʼel ʼuri xak xu cuxtaj u bi i Dios chi ʼo chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Xak we jun cu cuxtaj u bi i caj, xeʼel ʼuri xu cuxtaj i u cubibal i Dios, pa cu ʼat wi tzij, xak xu cuxtaj i Dios chi cul chila. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! (Qui ʼan pen i cojonic che i ral tzij re i ʼatbal tzij chi n-ta kas ropis.) Niʼpa i ʼo iwuʼ chi n-ta kas u chac, pacha i ral tak arawen, i anix, tak i comin, ile ʼut qui ʼan pen i relsaxic jun tant che i lajuj, y qui ya na che i Dios. Xui-ri, n-qui ʼan ti pen i cojonic che i tzij re i ʼatbal tzij chi lic ʼo u chac qui ʼan na. N-qui ʼan ta pen u ʼanic i sucʼulic cuʼ i winak; n-qui ʼan ta pen rilic tobal qui wach; n-kas ta quix terej chirij i Dios. Are i niʼpa iri, are ʼo u chac qui ʼan na; xak ʼo u chac qui jach i nabe tant che i Dios che i qui chʼaco. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Yix xa ix aj cʼambeal lic ix mawach! ¡We ʼo jun ral ʼus chupam i yaʼ re i qui tijo, quiwesaj la ʼut; xui-ri we ʼo jun camey chupam, xa qui tuʼ la bic! ");
INSERT INTO acr_acc_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! Lic qui ʼan pen u chʼajic i bas, tak i lak, xui-ri n-qui chʼaj ti i pi cʼux yix. I ubitak iwe, toʼ iwelʼam na, xa quix tijin chu molic u chiʼ, xui ile qui chʼobo. Queʼelok pacha xui i rij i bas, xui i rij i lak i chʼajom na, péro i u pam lic tzʼil. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ix mawach laj tak Fariséo, nabe chi chʼaja i u pam i bas, i u pam i lak, man queʼel ʼuri chom na ronojel. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! Ix queje pacha jun pantion, lic chom, sak i rij, péro i u pam n-chʼam taj, xa ʼo can u bakil camnak chupam, xa ʼo ca ʼay chupam. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Yix ix queje ile; lic ʼutz quix ʼanaw chiquiwach i winak xui-ri i pi cʼux lic n-chʼam taj, xa ix nojnak che i mal; xa queb i palaj i ʼanom che iwib. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo. ¡Xa queb i palaj! Qui ʼan pen u yijbaxic qui pantion i ujer ajbil u tzij i Dios, cojbal re qui ʼij. Qui ʼan pen u wikic qui mukbal i je re i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Teʼuri qui bij ni yix, “We tene yoj oj ʼo che i ʼij-le que i katit kamam, yoj ʼut n-queje tene que ka camsaj-i i ajbil u tzij i Dios,” quix cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Xui-ri, ruʼ i n-ʼus taj qui ʼano, i ʼalijinsam chi lic ix xak jun cuʼ ique. Lic ix qui muk qui xiquin can ique chi xe qui camsaj i je ajbil u tzij i Dios ujer; xa ix qui cwenta ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Chi qʼuisa u ʼanic ʼuri wach i xqui jek u ʼanic iwatit i mam. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","¡Yix xa ix cumatz! ¡Xa ix racʼal cumatz! N-quix tiqui ta chu jeqʼuic iwib chuwach i tojpen pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Que in tak nubi je ajbil u tzij i Dios chiwe, que in tak bi ʼo qui noʼoj, xak i je tijonel que in tak bi iwuʼ. Yix qui camsaj ni jujun chique, xak ʼo jujun que i camsaj chuwach cruz, xak ʼo jujun chic qui ʼan ni cʼax chique pa tak molbalʼib, xak ʼo jujun chic que iwoktaj, n-quix uxlan ta chi coktaxic pa tak tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","I mal laj tak ʼanic chi xqui ʼan iwatit i mam ujer, xak are quix tijin yix chu ʼanic woʼor, xak ca pe ni tojpen piwi yix rumal. Lic ix xak jun cuʼ ique chi xe qui camsaj i winak je ʼutz. Are u jekanic, are u camsaxic i a-Abel chi n-tu mac, y queje ile petnak cʼa are ʼo wi chi xi camsaj i mam Zacarías pa rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Katzij i quin bij chiwe, niʼpa i tojpen re iri ca pe na piquiwi i winak aj woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","¡Ay, yix, ix aj Jerusalen! ¡Yix chi que i camsaj i ajbil u tzij i Dios; yix chi toʼ qui coj abaj chique i je u takon i Dios! ¡Qʼuialmul lic in rayim quix in mol wuʼ, pacha coʼon jun ati acʼ cuʼ i racʼal, que u ya chuxeʼ u xicʼ! ¡Queje ile xwaj te yin, y yix n-xiwaj taj! ");
INSERT INTO acr_acc_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Chitapeʼ, i tinimit yix coʼtax na can rumal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Quin bij chiwe, queje ile quix eʼel na; n-quiwil ta chic in wach cʼa cu rik ni ʼij chi quin i cʼulaj na iwuʼ. Qui bij na: “¡Chu ya ni ʼutz i Kajwal Dios puwi i Jun chi u takom lok!” quix cha. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","I Jesus xel pa rachoch i Dios; ya cu maj u be. Are ʼuri xe tejeb i u tijoxelab ruʼ, y xe oc chu cʼutic niʼpa i ja re i rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","I Jesus xu bij chique: —¿Y yix cʼa qui takej niʼpa ile? Katzij i quin bij chiwe: ronojel iri ca wulijsax na. Mi jun abaj ca canaj chic puwi i rachiʼil —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Teʼuri xe ʼe chuwi jyub Olívos i Jesus xcubi chila. Are ʼuri i u tijoxelab xe tejeb pan ruʼ. Xe oc chu tzʼonoxic che, aliʼal: —Cakaj caketamaj umpa ca ʼani ile chi xa bij. ¿Wach cakilo are ya cat cʼunic? ¿Wach cakilo are ya ca cʼun i qʼuisbal re tak i ʼij-i? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","I Jesus xu bij: —Chi ʼana cwent iwib, mokxa ʼo quix qui tʼoro. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Man je qʼui que cʼun na, y quiqui ʼan che quib pacha yin. “Yin in i Toliwe,” que cha; cumal ique-le, je qʼui que tʼortaj na. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Yix xak qui ta ni rason chi ʼo nimak tak chʼoʼoj jela, xak nimak tak chʼoʼoj jewa. Mix cʼachir rumal, man ʼo ni u chac queje ile coʼono; xui-ri, are qui ta i tzij-le, cʼa maja ca cʼun ni qʼuisbal re tak i ʼij-i. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ʼO ni tinimit quiqui ʼan chʼoʼoj che jun chic. I winak re jun ʼatol tzij xak quiqui ʼan chʼoʼoj che jun chic nim laj ʼatol tzij. Ca pe waʼjal, ca pe yobil, ca pe i ucabrakan pa tak tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Lic ca cʼun na ile, xui-ri xa are i jekbal re i cʼax chi ca petic. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Yix quix chaptaj na, quix yaʼ na pa tojpen, y quix camsax na. Conojel i winak tzel na quix quilo xa wumal yin. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Che i ʼij-le, je qʼui na quiqui sach u cubibal qui cʼux che i Dios; xak je qʼui na, tzel na quiquil quib; xak ʼo ni quiqui jach i cachiʼil piquiʼab i tzel que ʼilawic. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Xak je qʼui ni aj tʼoronel que cʼun na, quiqui bij chi je ajbil u tzij i Dios; je qʼui ni winak que qui tʼor na. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Niʼpa i ca pe ruʼ itzel lic ca qʼuiar na, je qʼui na ʼuri i winak quiqui sach i cʼaxnabal qui cʼux chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Xui-ri, pachin i quiqui chʼijo cʼa pa qʼuisbal-re, que ʼel na ʼuri pa cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Xak i ʼutz laj tzij re i ʼatbal tzij re i Dios ca paxsax na, ronojel u wach i jyub taʼaj, man caquetamaj na conojel i tinimit; teʼuri ca pe i qʼuisbal re u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","16","I ajbil u tzij i Dios, mam Daniel, u tzʼibam canok wach ca cʼunic; xu bij ire chi cocsax na jun tzel laj kajsabal re u ʼij i rachoch i Dios. Are quiwil yix ile tacʼal chila che i lugar ʼo u ʼij pa rachoch i Dios, niʼpa i je ʼo pa jyub Judéa, che ʼanmaj ʼuri chuwa tak jyub. Pachin crajlaj i tzij-i, chu ta usucʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Niʼpa je ʼo ʼan puwija re i cachoch, suʼ che kaj la lok; me oc chic chupam, quiqui cʼambej re ubitak-que. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Xak niʼpa i je ʼo pa tak ticon, me tzalij lok que qui cʼambej re qui ʼuʼ. ¡Paʼanem che ʼanmajok! ");
INSERT INTO acr_acc_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Chupam i ʼij-le, toʼ qui wach ixokib chi ʼo i yobil chiquij, xak ique chi ʼo cacʼal que tzʼumanic, cʼax i qui ʼanmajic ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Chi tzʼonoj che i Dios chi n-joron ti tew are quix ʼanmaj chuwach ile, xak n-are ta chupam i uxlambal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Man i uyej che tak i ʼij-le, lic cʼax. Cʼa chu xebal ʼij sak, n-ta jun cʼax petnak lic cʼax chuwach ile; xak n-ta chic jun chic ca petic, lic cʼax chuwach ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Y we i Dios n-coʼon ta che, chi xa ʼatal ʼij ʼo ni cʼax-le, ʼis que cam na conojel. Xui-ri, ire cu ʼatij na; queje coʼon ire ile rumal i cʼaxnabal u cʼux chique i je re ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Rumal-i, che tak i ʼij-le, we ʼo i que bin chiwe: “Chiwilapeʼ, chi ʼo wi i Tolke,” que cha, o we quiqui bij: “Le i ʼolic-le,” que cha, mi cojo. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Man que cʼun ni aj tʼoronel chi quiqui ʼan che quib pacha je toliwe, xak que cʼun jujun quiqui ʼan che quib pacha je ajbil u tzij i Dios. Quiqui ʼan ni milágro, xak nimak tak ʼanic, ʼilbal-re we que tiqui chi qui tʼoric niʼpa i je re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ya in bim chic iri chiwe wach i qui cʼulmaj coʼon panok. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Rumal-i, we ca bix chiwe: “Chiwilapeʼ chila ʼo wi i Tolke pa taʼaj tzʼinilic,” que cha, mix ʼe chila; xak we ca bix chiwe: “Chiwilapeʼ chi ʼo wi paja,” quiqui bij chiwe, mi cojo. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Mi cojo, man i Achi aj Chicaj n-aliʼal taj ca cʼunic. I u cʼunic ire coʼono pacha coʼon jun nim laj u rep ʼaʼ ca repcanic, chi coʼon sak ronojel u wach i caj. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","(I tojpen lic ca cʼun-na.) Pa ʼo wi jun chʼaculaj camnak, chila que moltaj wi i cʼuch. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Are quicʼaw niʼpa i cʼax re i ʼij-le, are ʼuri i ʼij ca ʼekumaric; i icʼ n-ca tzun ta chic; i chʼumil que tzak na li chicaj; xak wach tak ʼo chicaj que sicsax na. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Are ʼuri ca ʼiltaj jun séña chicaj, re in cʼunbal yin chi in Achi aj Chicaj. Y conojel i tinimit chuwach i jyub taʼaj que oʼ na. Y quin quil na chi quin cʼun pa sutzʼ, nim na in choʼab, in chomal. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ca tataj jun nim laj trompet, y que in tak bi in ángel cʼa pa que ʼel wi li i cajib tew cʼulala; que in tak li jewa, xak que in tak bi jela, quiqui molbej-que niʼpa i je in chom, ronojel u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Yix iwetaʼam wach i séña quiwil che u cheʼlal hígo are ya ca cʼun i ʼalaj; chix naw che i cheʼ-le. Ile, are quiwilo chi ca pe tan chic u tux, y coʼon rax, iwetaʼam ʼuri ya ca miʼ tan chic i ulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Xak queje quiwetamaj are ya ca cʼun i qʼuisbal re tak i ʼij-i. Are quiwil yix pacha tak in bim chiwe, chi ta u be ʼuri ya ca pe i ʼij in bim chiwe; ya jekanic cu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Katzij i quin bij chiwe, ya ca cʼun ronojel niʼpa in bim-le; i winak je re woʼor quiquil na. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","I caj, i ulew ca sachic, xui-ri in tzij yin n-ca sach taj, ca ʼantaj na ronojel niʼpa in bim chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Mi jun retaʼam pachique ʼij, pachique ʼor, coʼon ile. Xak mi ne i ángel aj chicaj, xak mi ne u Cʼojol i Dios n-retaʼam taj; xui i Ta chicaj retaʼam. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","I winak n-quiqui yijba ta quib che i ʼij-le are ca cʼun i Achi aj Chicaj. Xa quiqui ʼan na pacha xqui ʼan i winak re tak i ʼij re i mam Noe ujer. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ique ujer, are maja ca pe i nim laj jab chi xu nojsaj u wach i jyub taʼaj che i ya, n-xqui yijba ta quib. Toʼ xqui tzuk quib, toʼ xe tuʼunic, toʼ xqui bisoj i qui cʼulanic; queje xqui ʼan ile tzʼakat xcʼun i ʼij chi xoc i mam Noe pa nim laj bárco. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Toʼ queje ile xqui ʼano, y n-xqui na taj, cʼa are xpe i nim laj ya chi ʼis xe u cʼam bic. Xak queje quiqui ʼan na ile are quin cʼun yin chi in Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Chupam i ʼij-le, je ʼo ni queb achiab, que chacun junam pa qui ticon; jun chique ca cʼam nubic; i jun, ca canax canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Xak je ʼo ni queb ixokib que tijin chi queʼem. Jun chique ca cʼam nubic; i jun ca canax canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Rumal-i, chix cʼascʼat na, man n-iwetaʼam taj wach oʼonom ʼor ca cʼun i Iwajwal. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Cha cʼun chi cʼux wach coʼon jun rajaw ja. Ire we te retaʼam chi chaʼab ca cʼun jun iliʼom ruʼ, we te retaʼam wach oʼonom ʼor ca cʼunic, ire ʼut ca cʼascʼat na. N-cu ya ta che coc paja, crelʼajbej re ubitak-re. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Xak queje chi ʼana yix, lic chi yijba iwib chin iwoyʼej na; are n-ti qui chʼob che, are ʼuri quin cʼun yin chi in Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","(I Jesus xu bij chic jun tijojbal tzij chique. Xu bij): —Iwetaʼam wach ca ʼani che jun mocom lic ʼutz, lic ʼo u noʼoj. Ire ca yaʼ na can piquiwi i juban mocom rumal u patron. Chukul ire ʼo wi u yaʼic i qui wa are cu rik i ʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ʼUtz re i achi-le, we ca tijin chu ʼonquil wach i rajwaxic chique i mocom are ca cʼun chali i u patron. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Katzij i quin bij chiwe, ire ca canax na ʼuri puwi ronojel niʼpa i ubitak-re u patron. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Xui-ri, we xa mal laj mocom, xa cu chʼob na: “In patron, n-weʼ taj ca tzalij chalok,” mok cu bij ire. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Are ʼuri cu jek qui chʼayic i rach ajchac, xak ca ʼe cuʼ i je ʼabarel laj tak winak: toʼ cuʼ ique ca wa wi, xak ca tuʼun wi. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ire n-retaʼam taj bi chi ʼoril ca cʼun u patron. Are n-ta cu chʼob che, xak teʼet ca cʼun chalok. ");
INSERT INTO acr_acc_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","I u patron cu ya na ʼuri pa nim laj tojpen. Xak jun i tojpen ca yaʼ che pacha ca yaʼ chique i je queb qui palaj. Chila coʼ wi, y cu kachʼachʼej ni uware. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","(I Jesus xu bij chic jun tijojbal tzij chique.) Xu bij: I ʼatbal tzij aj chicaj queje pacha iri: Je ʼo lajuj altom xe ʼe che jun cʼulanquil. Xqui cʼam bi qui cantil man que ʼe chu cʼulaxic i achi are ca cʼunic. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Je joʼob chique n-ta kas qui noʼoj; i je joʼob chic ʼo qui noʼoj. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","I joʼob chi n-ta kas qui noʼoj, n-xqui cʼam tubi acéite re i qui cantil we xqʼuis u pam. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","I joʼob chi ʼo qui noʼoj xqui cʼam bi jujun qui botey acéite, n-xui ti ʼo chupam i qui cantil xqui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","I achi chi ca cʼuliʼic xbaytajic. Ique xe u chap waram, y xe waric. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Are tiqʼuil aʼab, ʼo i xe siqʼuin chu bixquil: “¡Ya xcʼun i achi; jix chu cʼulaxic!” xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","I lajuj altom xe walijic, xe oc chu yijbaxic qui cantil. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Are ʼuri i joʼob chi n-ta qui noʼoj xqui bij chique i je joʼob cachiʼil: “Chi sipaj pichʼ ka acéite re i ka cantil, man ya ca chupic,” xe cha chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","I altom chi ʼo qui noʼoj xqui bij: “N-caka ya taj,” xe cha. “Man we caka yaʼo, n-coʼon ti ke yoj, xak mi ne iwe yix,” xe cha. “Jix chila pa ca cʼayix wi; chi loʼo na iwe yix,” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Teʼuri ique xe ʼe chu loʼic; are je ʼenak chu loʼic, xcʼun i achi. Niʼpa i altom chi je yijilic, xe oc ruʼ ire pa cʼulanquil, are ʼuri xtzʼapix i uchija. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Teʼuri xe upon i joʼob chic, y xqui bij: “¡Nim laj winak! ¡Nim laj winak! ¡Cha jaka i uchija chake!” xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ire xu laʼ u wach chique: “N-quin ʼan taj; n-wetaʼam ta i wach,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Teʼuri i Jesus xu bij chique u tijoxelab: —Yix, chix cʼascʼat na, man n-iwetaʼam taj pachique ʼij, pachique ʼor, quin cʼun yin chi in Achi aj Chicaj —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","(Teʼuri i Jesus xu bij jun chic tijojbal tzij chique. Xu bij): —I ʼatbal tzij re aj chicaj, queje pacha iri: ʼO jun achi ca ʼe che jun tinimit cʼa naj; xe u siqʼuij u mocom y xrokxanij can u mer cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Jun chique xrokxanij joʼob mil sak pwak ruʼ. Y jun chic, xu ya chic can queb mil sak pwak ruʼ; y jun chic, xu ya can jun mil ruʼ. Queje u yaʼic ile xoʼon chique, pacha i ca majaw chique chi qui jujunal. Teʼuri xu maj u be. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","I mocom chi xyaʼ can joʼob mil sak pwak che, ire xoc chi chac ruʼ i mer. Queje ile xu chʼac joʼob mil chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Xak queje xoʼon i jun chi xyaʼ queb mil che: xak xu chʼac queb mil chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","I jun chi yatal jun mil che, xa xu ruwaj u mer i u patron; xoʼon jun jul y xu muk pulew. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","I patron xnajtinic; teʼuri xcʼun chic, y xoc chi rajlaxic u mer cuʼ u mocom. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Nabe xupon i jun chi u yom can joʼob mil che. Ire xu jach i joʼob mil chi yatal che, xak xu jach i joʼob mil chi u chʼacom. Xu bij: “Nim laj winak, joʼob mil xa ya chwe, xak joʼob mil chic xin chʼac chirij,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","I u patron xu bij: “Lic ʼutz i a ʼanom. Yet at ʼutz laj mocom; lic a yom a cʼux chu ʼonquil pacha i cwaj yin. Lic ʼutz a chac xa ʼan ruʼ i jubiʼ-le, rumal-i, quin ya na mas paʼab puwi ile. Chat oc lok, y chat quicot wuʼ,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Teʼuri xupon i jun chi yatal queb mil che, Xu bij: “Nim laj winak, queb mil a yom chwe, xak ri i queb mil-i xin chʼac chirij,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","I u patron xu bij: “Lic ʼutz i a ʼanom. Yet at ʼutz laj mocom; lic a yom a cʼux chu ʼonquil pacha i cwaj yin. Lic ʼutz a chac xa ʼan ruʼ i jubiʼ-le, rumal-i, quin ya na mas paʼab puwi ile. Chat oc lok, y chat quicot wuʼ,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Xak xupon chic i jun chi yatal jun mil che. Xu bij che u patron: “Nim laj winak, wetaʼam chi yet at cʼan che a chac; ca jachʼ i ticon chi na ticom taj, xak ca mol u wach i ticon chi n-yet ti a mulim. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Rumal-i xin xij wib; xeʼe wuwaj a mer pulew. Chawila, ri a mer-i chi a yom chwe,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Yet n-at ta ʼutz laj mocom; lic ca cʼayo,” xu bij u patron che. “We yet awetaʼam chi in cʼan che in chac, ");
INSERT INTO acr_acc_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","¿wuchac ʼuri n-xa ya ti in mer pa bánco, cu chʼacbej na mas? We ta queje ile xa ʼano, quin chʼac ni yin-i niʼpa i xu chʼaco junam ruʼ ile chi in yom chawe,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Teʼuri xu bij chique i juban je ʼo chila, “Chi cʼama i jun mil-le che; chi ya na che i jun chi ʼo lajuj mil ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Man jun, we ʼo jubiʼ ruʼ, ca yaʼ na mas che; we jun n-ca chacun ta ruʼ wach ʼo puʼab, niʼpa i ʼo ruʼ quelsax na che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","I n-ʼus ta laj mocom-le, chiwesaj bi rija; ʼoj pa ʼekum. Chila coʼ wi, y cu kachʼachʼej ni uware,” xu bij i qui patron chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","(I Jesus xu bij:) I Achi aj Chicaj, are ca cʼun tan chic, coc pu patan che ʼatol tzij; junam cuʼ u ángel ca cʼunic. Ca qʼuiji na ʼuri pu cubibal chi nim u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","I winak re ronojel tak tinimit chuwach i jyub taʼaj que moltaj na chuwach. Teʼuri coc chi qui jachic qui pam, pacha jun aj chajil chij que u resaj u chij chiquixol i chabat. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Que u ya i u chij pu wikabim; i tak i chabat que u ya pu moxim. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Teʼuri i ʼAtol Tzij cu bij na chique i je ʼo pu wikabim: “ʼUtz iwe yix; u yom ni utzil chomal in Kajaw piwi. Chix petok, chix oc che i qʼuijibal chi u yijbam ire chiwe cʼa chu xebal ʼij sak. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Queje cu ya ire ile chiwe man yix, are xin tij numic, xi ya na chwe wach i quin tijo; are xin cʼatic, xi ya ni in yaʼ; are xin tzucuj in posar, xin i cʼulaj iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Are n-ta chic in ʼuʼ, xi ya i chʼukbal wij; are in iwab, xin i chajij; are in tzʼapil pa cárcel, xin i solij na.” Queje ile cu bij ni ʼAtol Tzij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Teʼuri, i je ʼutz-le quiqui bij na: “Nim laj winak, ¿umpa xa ʼan ile? ¿Umpa xka ʼano chi cat numic, y xka ya chawe wach ca tijo? ¿Umpa xka ʼano chi cat cʼatic, y xka ya a yaʼ? ");
INSERT INTO acr_acc_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Umpa xka ʼano chi ca tzucuj a posar y xka ya chawe? ¿Umpa xka ʼano chi n-ta chic a ʼuʼ, y xka ya chʼukbal awij? ");
INSERT INTO acr_acc_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Umpa xka ʼano chi at iwab, xak at ʼo pa cárcel, y xat ka solij?” Queje ile quiqui bij na che i ʼAtol Tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Teʼuri i ʼAtol Tzij cu bij: “Katzij i quin bij chiwe, niʼpa i utzil chomal i ʼanom che jun wachalal, tupu n-ta kas u ʼij, xeʼel ʼuri lic chwe yin i ʼanom wi,” cu bij na chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Teʼuri i ʼAtol Tzij cu bij na chique i je ʼo pu moxim: “Chix el chi chinwach, yix chi ix cʼoktal rumal i Dios. Jix pa ʼaʼ chi n-tu qʼuisic, chi yijtalic re itzel junam cuʼ i u ángel. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Yin, are xin tij numic, yix n-xi ya ta chwe wach i quin tijo; are xin tij cʼatic, n-xi ya ta in yaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Are xin tzucuj in posar, n-xi ya ta chwe. Are n-ta chic in ʼuʼ, xak n-ta in ʼuʼ xi yaʼo. Are in iwab, xak are in ʼo pa cárcel, yix n-xin i solij taj.” Queje cu bij ni ʼAtol Tzij ile chique i je ʼo pu moxim. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Teʼuri ique quiqui bij na: “Nim laj winak, ¿umpa xat kilo cat numic, o cat cʼatic, o are ca tzucuj a posar, o xak are n-ta a ʼuʼ, o are at iwab, o xak are at ʼo pa cárcel? ¿Umpa xa ʼan ile chi n-xat ka to taj?” quiqui bij na che. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","I ʼAtol Tzij cu bij na ʼuri chique: “Katzij i quin bij chiwe: yix are xiwil jun we yin chi ʼo rajwaxic che, y n-xi to taj, tupu n-ta kas u ʼij, xeʼel ʼuri chiwe lic are ni yin chi n-xin i to taj,” cu bij na chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Teʼuri ique que ʼe pa tojpen chi n-tu qʼuisic; xak i je ʼutz que oc na che i qui cʼaslemal chi n-tu qʼuisic. (Queje ile xu bij i Jesus chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","I Jesus, are xutzin u bixquil ile chique, teʼuri xu bij chique u tijoxelab: ");
INSERT INTO acr_acc_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Iwetaʼam yix, xa queb ʼij chic craj, ca cʼun i nimaʼij páscua. Are ʼuri yin, chi in Achi aj Chicaj quin jachtaj na piquiʼab i je aj chʼoʼoj chwij man quin qui camsaj chuwach cruz —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Xak che i ʼij-le, xqui mol quib i ajwab sacerdóte, xak i je tijonel re i ʼatbal tzij, xak i nimak tak mamʼib que i aj Israel. Xqui mol quib chuwaja re i nim laj ja pa ʼo wi i mam Caifas chi ʼatz laj sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Chila xqui yijba wi wach u chapic i Jesus quiqui ʼano aliʼal, xak wach i camsabal-re. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Xui-ri, xqui bij chiquiwach: —N-ʼus taj we caka ʼano tzʼakat je qʼui i winak waral re i nimaʼij, mokxa que oc i winak chi chʼokowic —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","I Jesus ʼo pa aldéa Betánia ruʼ i rachoch i achi Simon, chi “Lepróso” ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Are ʼuri xtejeb jun ixok ruʼ, rucʼam jun chom laj baxo nojnak che acéite lic muy, lic pakal rajil. I Jesus ca tijin chi waʼim, are ʼuri i ixok xu jam bi i cunbal puwi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","I u tijoxelab, are xquil ile, xpe coywal. —¿Wuchac i ixok-le toʼ xoʼon cʼax che i cunbal muy? —xe cha chiquiwach—. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","We ta xu cʼayij, nim ni mer cu chap na che, cu tobej que i nibaʼib —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Xu ta i Jesus wach quiqui bij y xu bij chique: —¿Wuchac queje qui bij ile chirij i ixok-le? I xoʼon ire-le chwe, lic ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","I nibaʼib, queʼe ʼij sak je ʼo na iwuʼ; yin n-naj ta chic in ʼo iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","I ixok-i, are xu jam i cunbal muy che in chʼacul, ʼutz i xu ʼano, man xu cunaj bi in chʼacul re i mukbal-we. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Katzij i quin bij chiwe, xa ipa ca paxsax wi i tzij re i ʼelsabal re i qui mac i winak xak ca tataj ni rason wach u ʼanom i ixok-i chwe. Queje coʼon ile ronojel u wach i jyub taʼaj, cʼunsabal re i ixok-i chi qui cʼux i winak —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Teʼuri, jun chique i cablajuj u tijoxelab, i jun chi ma Júdas Iscarióte u bi, ire xa ʼe lapan cuʼ i ajwab sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Xu bij chique: —¿Niʼpa i qui ya chwe we quin jach i ma Jesus piʼab? —xu bij chique. Ique xqui ya tréinta sak pwak che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Are ʼuri i ma Júdas xu jek u tzucuxic wach i jachbal re i Jesus coʼon piquiʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Xcʼun i nabe ʼij re i nimaʼij chi ca tijaw i caxlanwa chi n-ti cunbal che. I u tijoxelab i Jesus xe tejeb ruʼ y xqui bij che: —¿Pa cawaj wi yet queʼe ka yijba wi i a waʼim re i nimaʼij páscua? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","—Jix pa tinimit —xu bij chique—. Jix ruʼ jun achi ʼo chila y queje iri chi bij che: “Xu bij li ka tijonel: Ya cu rik i ʼor chwij re in camic, cu bij. Chawachoch yet caka ʼan wi ka waʼim re i nimaʼij páscua, yin cuʼ in tijoxelab, cu bij.” Queje ile chix chok che —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","I u tijoxelab xqui ʼano pacha i xbix chique. Xe ʼe chu yijbaxic i waʼim re i nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Are xoc aʼab, i Jesus ʼo cuʼ i cablajuj u tijoxelab chi mexa. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Are que tijin chi waʼim, xu bij chique: —Katzij i quin bij chiwe, ʼo jun chiwe yix quin u jach na piquiʼab i je aj chʼoʼoj chwij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ique, are xqui ta, lic xe oc chi bis. Chiqui jujunal xe oc chu tzʼonoxic che: —Kajwal, ¿mokxa yin? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ire xu bij: —Pachin cu mu u wa pa lak wuʼ yin, are ni ire ʼuri quin jachaw na. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Katzij, yin chi in Achi aj chicaj, quin camsax na, pacha tzʼibtal can chupam u wuj i Dios, xui-ri toʼwach i achi chi quin jachaw na piquiʼab i aj chʼoʼoj chwij. Mas ʼutz queʼel che i achi-le ma ta xalaxic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Teʼuri xchʼaw i ma Júdas, chi ca jachaw ni Jesus: —Tijonel, ¿xataba yin quin ʼanaw ile? —xu bij. I Jesus xu bij che: —Ruʼ a chiʼ xa bij —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Are que tijin chi waʼim, i Jesus xu chap jun caxlanwa, xu tioxij che i Dios, teʼuri xu piro. Xu ya chique u tijoxelab, y xu bij chique: —Chi tija, are iri are in chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Teʼuri xu chap jun tuʼbal víno, xu tioxij che i Dios, y xu ya chique. —Chi tuʼu yix iri, iwonojel —xu bij chique—. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Are iri are in quiqʼuel chi ca yijbaw ni trat cʼacʼ ruʼ i Dios. Ca turuw na, sachsabal re i qui mac uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Katzij quin bij chiwe, n-quin tuʼ ta chic u waʼal úva, cʼa cu rik ni ʼij quin tuʼ julaj chic junam iwuʼ yix, pa cu ʼat wi tzij in Kajaw —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Teʼuri xqui bixaj jun bix, cojbal re u ʼij i Dios; are xe utzinic, xe ʼe chuwi jyub Olívos. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","I Jesus xu bij chique: —Woʼor chaʼab, iwonojel yix quin iwoʼtaj na canok. Wetaʼam queje ile queʼelok, man queje iri u bim can i Dios chupam u wuj: “Quin ya na, chi ca camsax ni aj yuʼul chij,” xu bij, “teʼuri i chij que jacher bic.” Queje ile tzʼibtal canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Xui-ri, are in walijnak chic che i camic, quin nabeaj na chiwach pa Galiléa —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Are ʼuri xu bij i ma Pédro: —We conojel ʼis cat coʼtaj canok, yin lic n-cat woʼtaj taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","I Jesus xu bij che: —Katzij i quin bij chawe, che i aʼab-i, are maja ca chʼaw i acʼ re u sakirbal, oxmul ca bij na, chi n-awetaʼam ta in wach —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","—Yin lic n-cat wuwaj taj —xu bij i ma Pédro— n-ta coʼono we junam awuʼ coj camsaxic. Xak queje ile xqui bij conojel i u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Teʼuri xe ʼe chic che jun lugar, Getsemani u bi. I Jesus xu bij chique u tijoxelab: —Chix cul na can chi, tzʼakat quin ʼe na yin jela chu tzʼonoxic che i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Teʼuri xe u cʼam bi i ma Pédro, xak i queb u cʼojol i mam Zebedéo ruʼ, y xpe jun nim laj bis, jun nim laj cʼax pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Xu bij chique: —I bis ʼo pa wanima, quin cam rumal, quin na yin. Chix canaj yix waral y chix cʼascʼatok —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","I Jesus xa ʼe chupan jubiʼ, xu jupij rib pulew, y xoc chu tzʼonoxic che i Dios: —Ta, cwaj yin, we ta ʼo módo, cawesaj i cʼax ʼo chinwach. Xui-ri, ma ya chwe pacha i toʼ cwaj yin; are, cha ʼana pacha i cawaj yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Teʼuri xtzalij chic cuʼ i u tijoxelab; xe u rika que waric. Xu ʼijla i ma Pédro: —¿N-xi chʼij ta bari xix cʼascʼat jun ʼor wuʼ? —xu bij—. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Chix cʼascʼat na, y chi tzʼonoj che i Dios man n-quix tzak ta chupam i mac. Katzij, yix piwanima quiwaj quix cʼascʼatic, xui-ri i chʼacul n-tu choʼab —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Are ʼuri xtzalij chic ucamul chu tzʼonoxic che i Dios. Xu bij: —Ta, we n-ʼus taj chi quelsax ni cʼax chi ʼo chinwach, we lic ʼo ni u chac quin chʼijo, ʼutz ʼuri ca ʼani chwe pacha i cawaj yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Are xtzalij chalok, xe ʼe u rika tan chic u tijoxelab que war tan chic; i qui baʼwach ique lic waram craj. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ire xe u canaj canok, y xa ʼe chic; are uroxmul xa ʼe chu tzʼonoxic che i Dios, xak jun chi tzij xu bij chic che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Teʼuri xa ʼe chic chila cuʼ u tijoxelab. —Bay, chix warok; chix uxlanok —xu bij chique—. Ya xu rik i ʼor chi yin, chi in Achi aj Chicaj, quin jachtaj na piquiʼab i ajmaquib. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Chix walijok. Joʼ. Ya xcʼun ire chi quin jachaw na piquiʼab i aj chʼoʼoj chwij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","I Jesus cʼa ca tijin chi tzij are xupon i ma Júdas, chi jun chique i cablajuj u tijoxelab. Ire je rucʼam li uqʼuial winak; ʼo i cucʼam chʼichʼ, ʼo i cucʼam cheʼ. Ique je taktal li cumal i ajwab sacerdóte xak i nimak tak mamʼib que i aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","I ma Júdas, chi aj jachanel re i Jesus, u bim can chique wach i séña coʼon chique, cʼutbal re i Jesus: “Are i jun chi quin tzʼubaj, are ile,” u bim chique. “Chi chapa ʼuri,” u bim can chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","I ma Júdas, are xuponic, xtejeb pan ruʼ i Jesus. —Naʼab, in Tijonel —xu bij che. Y xa ʼe u tzʼubaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","I Jesus xu bij che: —Achi, ¿Wach cawaj chwe? —xu bij. Are ʼuri i juban xe tejeb ruʼ i Jesus y xqui chapo; lic co i u chapic xqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Are ʼuri, jun chique i rachiʼil i Jesus xresaj li u chʼichʼ y xu cʼatzij u xiquin i aj takon re i ʼatz laj sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","I Jesus xu bij che: —Cha cʼolo a chʼichʼ pa rachoch, man niʼpa i que ʼanaw chʼoʼoj ruʼ chʼichʼ, xak ruʼ chʼichʼ que camsax wi —xu bij che—. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿N-awetaʼam ta bari, chi we ta cwaj yin, quin tzʼonoj che in Kajaw y cu tak li uqʼuial ángel chin toʼic? ¡Mas ne chuwach i seténta mil que u tak neli-ri wuʼ! ");
INSERT INTO acr_acc_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Xui-ri, we ta quin ʼan yin ile, n-queʼel ta ʼuri pacha tzʼibtal can chupam u wuj i Dios. Lic ʼo ni u chac queʼel na pacha i tzʼibtal canok —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Teʼuri xu bij chique i winak: —¿Wuchac xix cʼun yix ruʼ i chʼichʼ xak ruʼ i cheʼ, qui cʼambej bi we, pacha qui ʼan che jun iliʼom? Yin ʼij ʼij in cul chixol yix pa rachoch i Dios, quin tijin chu cʼutic chique i winak, y n-xin i chap taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Xui-ri, ʼo ni u chac ca ʼani iri chwe, pacha qui tzʼibam can i ajbil u tzij i Dios ujer —xu bij chique. Teʼuri, niʼpa i u tijoxelab i Jesus xqui canaj canok y xe ʼanmajic. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Niʼpa i qui chapom i Jesus, xqui cʼam bi che i rachoch i mam Caifas, chi ʼatz laj sacerdóte. Chila qui molom wi quib i je tijonel re i ʼatbal tzij xak i nimak tak mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","I ma Pédro, toʼ chi naj xterej bi chiquij, cʼa xupon chuwaja re i rachoch i mam Caifas. Xoc bi chuwaja, chila xcubi wi cuʼ i policía, cu takejbej-re wach ca ʼani che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","I cajʼatzil i sacerdóte, xak i nimak tak mamʼib, xak ronojel i nucʼbal tʼisbal, ʼis xqui tzucuj u mac i Jesus. Cacaj ique quiqui coj u mac chuwach i ʼatbal tzij, tupu n-katzij taj, xa camsabel-re cacaj ique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Lic n-ta jun u mac xqui rik chirij, tupu je qʼui xe cʼunic y xqui bij mentir chirij. Pa qʼuisbal-re, xe upon chic queb testígo chi xa mentir quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Xqui bij ique: —I achi-ri xu bij: “Yin quin tiqui chu wulijsaxic i rachoch i Dios, teʼuri che oxib ʼij quin walijsaj wi chic,” xu bij —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Are ʼuri i ʼatz laj sacerdóte xwalijic, y xu bij che i Jesus: —Yet, ¿lic n-ca laʼ tu wach chique? ¿Wach usucʼ ile quiqui bij chawij? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","I Jesus lic n-xchʼaw taj. Are ʼuri i ʼatz laj sacerdóte xu bij: —Yin, chuwach i Dios cʼaslic, quin ya chakul: cha bij i sak laj tzij chake; cha bij ʼuri we yet at Crísto, chi u Cʼojol i Dios —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","I Jesus xu bij: —Katzij i xa bij. Xak quin iwil ni yin chi in Achi aj Chicaj, in cul na pu wikabim i Dios chi ʼatz u choʼab; xak quin iwil na quin cʼun chali pa sutzʼ chicaj —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Are ʼuri i ʼatz laj sacerdóte xu rakchʼij u ʼuʼ, cʼutbal-re i roywal. Xu bij: —¡Tzel cu ta i Dios ile! ¡Ya n-ta chic u chac we ʼo juban chic col qui bij u mac! Ya xi ta yix waral wach i itzel tzij xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿Wach qui chʼob yix che ile? —xu bij chique i rachiʼil. I juban je ʼo ruʼ xqui bij: —Ire lic ʼo u mac; cu maj che chi ca camsaxic —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Are ʼuri xqui chubaj qui cʼaxaj chu palaj y xqui chʼayo. ʼO juban chic xqui chʼay chu palaj ");
INSERT INTO acr_acc_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","y xqui bij che: —Yet chi at Crísto, cha bij ʼu chake pachin xat chʼayawic —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Tzʼakat are xqui ʼan ile, i ma Pédro cul chuwaja. Are ʼuri, xupon jun ali, aj chac pa rachoch i cajʼatzil i sacerdóte; xu bij che: —Xak yet at rachiʼil i ma Jesus aj Galiléa —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Xui-ri, i ma Pédro xruwaj u wach chiquiwach conojel: —N-wetaʼam ti yin wach i ca bij —xu bij che i ali. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","I ma Pédro ya ca ʼec, ʼo chic che uchibe. Are ʼuri xa ʼiltaj chic rumal jun chic. Xu bij ʼuri chique i je ʼo chila: —I achi-le, rachiʼil i ma Jesus chi aj Nazaret —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","I ma Pédro xu bij chic chi n-retaʼam tu wach. Xu cuxtaj u bi i Dios puwi u tzij y xu bij: —Lic n-wetaʼam tu wach i achi-le —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Xoʼon chupan jubiʼ, niʼpa i je ʼo chila xe tejeb ruʼ y xqui bij: —Katzij, xak yet at cachiʼil ique. Ca ʼalijin che a chʼawbal —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Teʼuri i ma Pédro xu bij chique: —Chu ya ni tojpen i Dios pinwi, we n-katzij ti quin bij. Lic n-wetaʼam tu wach i achi-le —xu bij. Are ʼuri xchʼaw jun teren. ");
INSERT INTO acr_acc_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Juntir xcʼun chu cʼux wach i bital che rumal i Jesus, man u bim che: “Are maja ca chʼaw i acʼ re u sakirbal, quin awuwaj na oxmul,” u bim i Jesus che. Teʼuri i ma Pédro xel chila, lic cʼax xu na u cʼux, lic xoʼ rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Are xsakiric, i cajʼatzil i sacerdóte xak i nimak tak mamʼib que i aj Israel, ique xjunamtaj qui noʼoj wach u camsaxic i Jesus quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Xqui xim i Jesus y xqui cʼam bi ruʼ i ma Piláto chi gobernador, y xqui jach puʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I ma Júdas, chi cʼayiwnak i Jesus, are xrilo chi ca camsax na, lic xbison che wach u ʼanom. Are ʼuri xa ʼe u tzalij chic i tréinta sak pwak chique i cajʼatzil i sacerdóte, tak i nimak tak mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Xu bij chique: —Lic in macun-nak; in jachom jun achi che i camic chi n-tu mac —xu bij. Ique xqui laʼ u wach che: —¿Bi ke-yoj che? —xe cha—. ¡Lic awe yet pa wach wi ile! —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Teʼuri i ma Júdas xu jopij i sak pwak pa rachoch i Dios y xel bic. Are ʼuri xa ʼe u jitzʼaj rib. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","I cajʼatzil i sacerdóte xqui mol i mer y xqui bij: —I mer-i, n-ʼus taj caka ya ruʼ i re i Dios; i ʼatbal tzij re i mam Moises n-cu ya taj, man i mer-i are i rajil u quiqʼuel jun winak —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Teʼuri xjunamtaj qui noʼoj quiqui loʼ jun ulew re i qui camposant niʼpa i je aj naj que cam pa Jerusalen. I ulew chi xqui loʼo, xa are pa ca ʼan wi boj ujer; “Ulew re ʼAnbal Boj” u bi. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Xui-ri, xqui jalwachij u bi i ulew; “Ulew Quicʼ” xqui bij che, y cʼa are ʼo wi woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Queje ile xeʼelok pacha u bim can i mam Jeremías, chi ajbil u tzij i Dios ujer. Ire u bim canok: “Xqui cʼam bi i tréinta sak pwak chi are i rajil bital che cumal i aj Israel; ");
INSERT INTO acr_acc_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","y ruʼ i mer-le xqui loʼ i ulew pa ca ʼan wi boj ujer. Xeʼelok pacha u bim can i Kajwal chwe.” Queje ile tzʼibtal canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","I Jesus xcʼam bi chuwach i gobernador. Ire xu tzʼonoj che i Jesus: —¿Yet at ʼatol tzij que i aj Israel winak? —coʼono. I Jesus xu bij: —Are ile, pacha i xa bij yet —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Xui-ri, are xocsax u mac cumal i ajwab sacerdóte, xak i nimak tak mamʼib, i Jesus n-ta xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Are ʼuri i ma Piláto xu bij che i Jesus: —¿N-ca ta ta-bari wach tak quiqui bij chawij? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Xui-ri, i Jesus xak n-ta xu bij. Are ʼuri, i gobernador lic xu bisoj. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Junab chi junab, are ʼo i nimaʼij páscua, i gobernador ʼo puʼab croʼtaj jun prex, pachique quiqui cha i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ʼO jun prex, ma Barabas u bi, ire lic ʼetamam u mac cumal conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Are je moltajnak chic i winak, i ma Piláto xu tzʼonoj chique: —¿Pachique quiwaj yix cwoʼtaj bi chiwe? ¿Quiwaj i ma Barabas? ¿O quiwaj i ma Jesus chi “Crísto” ca bix che? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Ire retaʼam chic chi xa tzel quiquil i Jesus; xa rumal ne ile qui cʼamom lo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","I ma Piláto, are cul pu qʼuijibal, i rixokil xu tak li u bixquil ruʼ; xu bij che: “Ma min awib che u camsaxic i achi-le, man ire n-tu mac. Yin chaʼab xin ʼan jun achicʼ lic xibinʼib rumal ni ire-le y quin cʼachir rumal.” (Queje ile xbix che.) ");
INSERT INTO acr_acc_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Xui-ri i cajʼatzil i sacerdóte, xak i nimak tak mamʼib, xe qui tun i winak chi quiqui tzʼonoj i roʼtaxic i ma Barabas, xak quiqui tzʼonoj u camsaxic i Jesus. Queje i qui tunic ile xqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","I gobernador xu tzʼonoj chic chique i winak: —¿Pachique chique i je queb quiwaj yix quin tak nubi roʼtaxic? —xu bij. —A-Barabas —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","I ma Piláto xu tzʼonoj chique: —¿Wach quin ʼan ʼuri che i Jesus-i chi “Cristo” ca bix che? —coʼono. Conojel xqui bij: —¡Cha camsaj chuwach cruz! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","—¿Wach u mac ʼuri u ʼanom? —coʼono. Ique xa xe siqʼuin tan chic; xqui bij: —¡Cha camsaj chuwach cruz! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Xril i ma Piláto ʼuri chi n-tu chac cu tzʼonoj mas tzij chique. Ique toʼ chʼokowic quiqui ʼano. Rumal-i ire xresaj rib chupam; xu tak u cʼamic jun palangan ya, y xu chʼaj u ʼab chiquiwach. Xu bij chique: —N-in mac ti yin we qui camsaj i achi-ri chi n-tu mac. Chiwach yix ʼo wi wach qui ʼan che —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Conojel i winak xqui laʼ u wach che: —¡Pakawi yoj ca pe wi i tojpen che u camic i achi-ri! ¡Xak piquiwi i kacʼal! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Are ʼuri i ma Piláto xroʼtaj bi a-Barabas; teʼuri xu tak u yaʼic u loʼxic i Jesus y xu jach bi piquiʼab i que camsaw chuwach cruz. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Teʼuri i u soldádo i gobernador xqui cʼam bi i Jesus pa palácio. Chila conojel i cachiʼil xqui mol quib chirij chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Xquesaj u ʼuʼ y xqui coj jun chom laj u ʼuʼ cak. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Teʼuri xqui coj jun sotosic qʼuix che u jolom, y xqui ya jun cheʼ puʼab wikabim. Teʼuri xe xuqui chuwach, y xe oc chu yoʼyaxic; xqui bij: —¡Naj u ʼij i ʼatol tzij que i aj Israel! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Xqui chubaj qui cʼaxaj chirij, xak xqui maj i cheʼ che, chi qui yom puʼab, y xqui chʼay u jolom ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Are xe utzin chu yoʼyaxic, xquesaj i cʼul cak chi qui cojom che, y xqui coj chic i u ʼuʼ ire. Teʼuri xqui cʼam bic, xe ʼe chu camsaxic chuwach cruz. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Are que tijin chi be, xqui cʼulaj jun achi aj Ciréne, chi ma Simon u bi. Xqui ʼan pen che, xu cʼam bi u cruz i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Queje ile xe upon che jun jyub, Gólgota u bi; i usucʼ i tzij-le queʼelok: “jyub pacha u jolom anma.” ");
INSERT INTO acr_acc_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Are xe upon chila, xqui sujuj jubiʼ víno che i Jesus, chi ʼo cunbal cʼa che, tobal na re u cʼaxcʼol. I Jesus, are xu naʼo, n-xraj taj. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Are qui ripom chic chuwach i cruz, i soldádo xe oc chi saquinic chirij u ʼuʼ i Jesus, ʼilbal-re pachin ca chʼacaw bi chique. Xeʼel ʼuri pacha u bim can i ajbil u tzij i Dios ujer. Xu bij ire: “Xqui jach na in ʼuʼ chiquiwach; xe saquin chirij in ʼuʼ, pachin ca chʼacaw nubic.” Queje ile u tzʼibam canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Teʼuri xe cubi chila chu chajixic, tzʼakat ca camic. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Puwi ʼan i cruz xqui tzʼibaj juban tzij, ʼalijinsabal-re wach u mac. Cu bij i tzʼib: “Are iri, are i Jesus, chi ʼatol tzij que i aj Israel winak,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Xak je ʼo queb iliʼomab xe qui rip chuwach qui cruz, junam ruʼ i Jesus. Jun xqʼuiji pu wikabim, y jun pu moxim. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Niʼpa i que icʼaw chila, xqui yoʼya. Quiqui sutsa qui jolom ");
INSERT INTO acr_acc_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","y quiqui bij: —Yet a bim na chi ca wulijsaj ni rachoch i Dios, y ca yac chic churox ʼij. ¡Bay, cha to ʼuri awib! We yet at u Cʼojol i Dios, cha kajsaj li awib chuwach i cruz —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Xak queje xqui ʼan i ajwab sacerdóte, xak i tijonel re i ʼatbal tzij, xak queje i aj Fariséo, xak i nimak tak mamʼib, lic xqui yoʼya na. Ique xqui bij chiquiwach: ");
INSERT INTO acr_acc_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Ire-le je qʼui xe u to na, xui-ri n-ca tiqui ta chu toʼic rib. Ire, we lic are i ka ʼatol tzij yoj chi oj aj Israel, cha kaj lo ʼuri chuwach i cruz, teʼuri caka coj na. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Ire u cubam u cʼux che i Dios, xak u bim chi ire u Cʼojol i Dios; bay, i Dios ʼut chu to na we cʼax cu naʼo —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Xak i iliʼomab chi je riptal ruʼ ire, xak ique quiqui yoʼya panok. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Are tiqʼuil ʼij, xoʼon ʼekum ronojel u wach i jyub taʼaj; queje xoʼon ile cʼa a las tres re u kajbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Are ʼuri, co xchʼaw i Jesus, xu bij: —Eli, Eli, ¿láma sabactáni? —xu bij. I usucʼ i tzij-i queʼelok: Wajwal Dios, Wajwal Dios, ¿wuchac in awoʼtam canok? Queje usucʼ u tzij ile. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Je ʼo jujun chila xqui ta; ique xqui bij: —I achi-le cu siqʼuij i ujer ajbil u tzij i Dios, mam Elías —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Juntir, ʼo jun chique xa ʼe paʼanem, xu mu jun espónja chupam juban víno chʼam. Teʼuri xu chʼap tzam cheʼ y xu ya ʼan che, man cu tzʼub-bej re. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","I juban xqui bij: —Chawoyʼej na, we kas ca cʼun i mam Elías chu toʼic —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Teʼuri i Jesus xsiqʼuin julaj chic y xel u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Are ʼuri i nim laj cortin pim, pa rachoch i Dios, xel pa nicʼaj, xmajan li pujaʼ, cʼa pulew. I ulew lic xa sicsatic; i tak i abaj xpax u pam. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Niʼpa i qui mukbal i camnak xe jaktaj na; je qʼui i creyent je camnak xe walij na. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Xe ʼel ʼuri chi sak; y chirijil nu walijic i Jesus, xe oc pa tinimit Jerusalen. Chila xe ʼiltaj wi cumal uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ʼO jun capitan que tijin chu chajixic i Jesus cuʼ u soldádo. Are xqui na i ucabrakan, xak xquil niʼpa i ʼanic-le, lic xqui xij quib. Xqui bij: —Katzij i achi-ri, lic are u Cʼojol i Dios —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Je ʼo uqʼuial ixokib que taken li cʼa naj chi je terejnak chirij i Jesus. Je terejnak li chirij, quiqui tobej na re; cʼa pa Galiléa je terejnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Chiquixol ique je ʼo i ati Mariy Magdaléna, xak i ati Mariy chi qui chuch i ma Jacóbo y ma Jose, xak i qui chuch i u cʼojol i mam Zebedéo. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Are xoc aʼab, xcʼun jun achi beyom aj Arimatéa, ma Jose u bi. I achi-le xak terejnak chirij u cʼutunic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Xoc ire ruʼ i ma Piláto y xu tzʼonoj i u chʼacul i Jesus. I ma Piláto xu tak u jachic che. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Teʼuri i ma Jose xu cʼam bic y xu pasij bi chupam jun sawan lic chʼam. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Teʼuri xe u mina chupam jun pantion re ire; are jun jul chi cʼa te u takom u woric chupam jun péña. Xu tzʼapij can u chiʼ i jul ruʼ jun nim laj abaj, y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","I ati Mariy Magdaléna, xak i ati Mariy jun, xe cubi can chila chuwach i jul. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Are xa ʼani ile, are i ʼij chi yijbal na re i uxlambal ʼij. Chucab ʼij ʼuri, i ajwab sacerdóte, xak i aj Fariséo, xe ʼe ruʼ i ma Piláto ");
INSERT INTO acr_acc_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","y xqui bij che: —Nim laj winak, xcʼun chaka cʼux chi i achi aj tʼoronel-le u bim na chi ca cʼun sak chuwach churox ʼij. Queje ile u bim na are cʼa cʼaslic. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Rumal-i cha taka u chajixic i jul pa muktal wi, cʼa churox ʼij. Mokxa que cʼun i u tijoxelab chaʼab, caquelʼaj bi u chʼacul, teʼuri quiqui bij chique i winak chi walijnak chic. We queje quiqui ʼan ni ique ile, i mentir-le mas nim na chuwach i-jun chi u bim can i achi. (Queje ile xqui bij che i ma Piláto.) ");
INSERT INTO acr_acc_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Teʼuri ire xu bij chique: —Che i cʼama bi i soldádo; che i ya chila chu chajixic i jul. ʼUtz u chajixic chi ʼana che —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ique xe ʼec, que ʼe qui yijba u chiʼ i jul man n-ta jun ca ʼe yinawok. I abaj chi ʼo che u chiʼ i jul, xqui coj cʼam chuwach, xqui nacʼ ixcab che tak u tzam. Queje xqui ʼan ile, ʼilbal-re we n-ta jun ca ʼe yinawok. Xak xe qui canaj can i soldádo chi je chajinel re u chiʼ i jul. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Are xicʼaw i ʼij re i uxlambal ʼij, are ya ca pe i u sakiric re i domíngo, are ʼuri i ati Mariy Magdaléna, xak i ati Mariy jun, xe ʼe chu rilic i jul. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Are maja que uponic, xpe jun ucabrakan, man ʼo jun ángel re i Kajwal xkaj li chicaj, xresaj i abaj chu chiʼ i jul, y xcubi puwi. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","I u tzunbal ire ca walchʼinic pacha u rep ʼaʼ; i u ʼuʼ lic sak, sak. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","I soldádo, are xquil u wach, lic que sicsat rumal qui xibriquil, pacha laj xe cam rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Are xe upon i ixokib, i ángel xu bij chique: —Mi xij iwib. Yin wetaʼam chi xix cʼun chu tzucuxic i Jesus chi xcamsax chuwach cruz. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ire n-ta waral; walijnak chubic pacha i u bim. Chix petok, chol iwila u qʼuijibal pa yatal wi canok. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Chi bisoj u yaʼic rason chique i u tijoxelab. Chi bij chique: “Ire walijnak chic chiquixol i camnak; ya ʼenak chic pa Galiléa, nabe na chiwach yix; chila quiwil ni u wach,” chix chok chique. Are iri col in bij chiwe —xu bij i ángel chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Teʼuri i ixokib juntir xe ʼel ruʼ i jul. Lic xqui xij quib xe ʼec, xui-ri xak que quicotic. Paʼanem xe ʼe chu yaʼic rason chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Xak teʼet i Jesus xu cʼut rib chique, y xu ya rutzil qui wach. Ique xe tejeb ruʼ y xe xuqui chuwach, cojbal re u ʼij, y xqui chap i rakan. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","—Mi xij iwib —xu bij i Jesus chique—. Ji bij chique i wachalal che ʼoj ique pa Galiléa; chila quiquil ni in wach —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","I ixokib xqui maj bi qui be. Are que tijin chi be, xak ʼo jujun chique i soldádo xe ʼe pa tinimit chu bixquil chique i ajwab sacerdóte wach i xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Teʼuri i ajwab sacerdóte xe ʼe chu bixquil chique i nimak tak mamʼib. Xqui junamsaj i qui noʼoj chiquiwach, wach i quiqui ʼano. Teʼuri xqui ya uqʼuial mer chique i soldádo, ");
INSERT INTO acr_acc_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","y xqui bij chique: —Chi bij yix chi xix war chaʼab, y are ʼuri xe cʼun i u tijoxelab i Jesus y xquelʼaj bi u chʼacul ire. Queje ile chi bij na. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","We xu ta rason i gobernador, mi xij iwib; yoj caka kajsaj ni u cʼux ire; ire n-ta cu ʼan chiwe. (Queje xqui bij i ajwab sacerdóte ile chique i soldádo.) ");
INSERT INTO acr_acc_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Are ʼuri i soldádo xqui chap i mer, y xqui bij na pacha bital chique. Y queje quiqui bij ni aj Israel winak ile, cʼa are ʼo wi woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","I julajuj u tijoxelab xe ʼe pa Galiléa; xe ʼe che jun jyub pacha bital chique rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Chila xqui rik wi i Jesus, y are xquilo, xe oc chu cojic u ʼij, tupu ʼo jujun chique n-kas ta quiqui cojo we are i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","I Jesus xtejeb pan cuʼ y xu bij: —Yatal chic pinʼab u ʼatic tzij puwi ronojel niʼpa i ʼolic. ʼO chic pinʼab ronojel i aj chicaj, xak ronojel i aj chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Jix yix cuʼ i winak ronojel u wach i jyub taʼaj. Chi bij in tzij chique man xak ique que u ʼon ni in tijoxelab yin. Chi kajsaj ni ya piquiwi, cʼutbal-re chi je re chic i Ta chicaj, xak je re i u Cʼojol, xak je re i u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Chi cʼutu chique chi ʼo u chac que cojon na che ronojel niʼpa in cʼutum yin chiwe yix. Mi sach pi cʼux chi yin in ʼo na iwuʼ ronojel ʼij sak, cʼa pa qʼuisbal re u wach i jyub taʼaj. Amen (katzij).");
INSERT INTO acr_acc_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Are iri are i jekbal re i ʼutz laj tzij chirij i Jesucrísto, chi u Cʼojol i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","I jekbal re u chac i Jesus, xak jun ruʼ pacha u tzʼibam can i ujer ajbil u tzij i Dios, mam Isaías. Ire xu tzʼibaj i tzij-i chi Dios xu bij che u Cʼojol: Chatapeʼ —xu bij che— quin tak bi jun in takon ca nabeaj bi chawach, cu yijba a be chawach. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ca tataj u chʼawbal jun ca siqʼuin che i jyub tzʼinilic; cu bij: “¡Ya ca pe i Kajwal! Chi yijba u be chuwach. Chi sucʼba niʼpa i jul, niʼpa i tanalak pu be i Kajwal.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Xoʼon panok, queje ile xeʼelok. ʼO jun achi, ma Wan u bi, xoc che jun chakij jyub tzʼinilic. Chila xe u pixbaj wi i winak, xak xu kajsaj ya piquiwi. Xu bij chique: “Chi jalwachij i nojbal y chi tzʼonoj u kajsaxic ya piwi, man i Dios cu cuy na i mac.” (Queje ile xu bij.) ");
INSERT INTO acr_acc_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Che tak i ʼij-le, je qʼui i winak xe upon ruʼ chila, chu tayiquil u tzij; xe upon i je aj Jerusalen, xak ronojel i juban tinimit re i jyub Judéa. Chila quiqui bij ni qui mac chiquiwach i winak, teʼuri i ma Wan xu kajsaj ya piquiwi chiya Jordan. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","I ma Wan, i u ʼuʼ ire xa are i rismal camey ʼantal u ʼuʼ che; i ximbal u pam xa are chʼakap tzʼum. Xak i u wa cu tijo xa wach tak i sacʼ, wach tak i u waʼal cab cu rik pa tak ʼes. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Are xe u pixbaj i winak, xu bij chique: —ʼO jun ca pe chwijil yin chi nim ni u ʼij chinwach yin. N-ca majaw ta chwe we quin ʼan mocom che wib chirij, rumal u ʼij nim; mi te ne quin chaqui kaj chuwach chu toric u wach u xajab che. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Yin, xa ya quin kajsaj piwi, xui-ri ire cu kajsaj ni u Tewal i Dios piwi. (Queje ile xu bij i ma Wan chique i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Che tak i ʼij-le i Jesus xel pu tinimit Nazaret, u cwenta i Galiléa, y xa ʼe chiya Jordan. Chila, i ma Wan xu kajsaj ya puwi chiya. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Xak teʼet, are xel i Jesus pa ya, xril i caj xjaktajic, xak xril i u Tewal i Dios xkaj lok pacha jun palomax. Xcʼunic, y xkaj puwi ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Are xa ʼantaj ile, ʼo jun chʼawbal xchʼaw chicaj chi xu bij: —Yet at Wacʼal chi lic cʼax cat in naʼo. Lic quin quicot awumal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Teʼuri i u Tewal i Dios xu cʼam bi i Jesus che jun chakij jyub tzʼinilic. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Chila xqʼuiji cuarénta ʼij chiquixol itzel chicop. I itzel, chi Satanas, xupon ruʼ, xraj te ire cu tzaksaj i Jesus chupam jun u mac. Xui-ri, i Jesus n-xtzak taj. Are xicʼaw ile, xe upon juban ángel ruʼ, y xqui to wach i rajwaxic che. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Xoʼon panok, i ma Wan aj kajsanel ya, xtzʼapix pa cárcel. Are ʼuri xa ʼe i Jesus pa Galiléa chu bixquil i ʼutz laj tzij re i Dios chila, wach u ʼatbal tzij i Dios piquiwi i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Xu bij chique: —Ya xu rik i ʼij chi u chʼicom i Dios; ya ca jekan ʼuri i ʼutz laj ʼatbal tzij re ire. ¡Chi jalwachij i nojbal chi n-ʼus taj! ¡Chi cuba i cʼux che i tzij re iwelbal chi sak! —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Xoʼon chupan jubiʼ, i Jesus ca malcat chu chiʼ i alagun, Galiléa u bi. Chila xe ril i ma Simon ruʼ i ma Andres, chi je catz qui chaʼ quib. Que tijin chu cʼakic cataraya pa ya, man je aj chapol car. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","I Jesus xu bij chique: —Chix pet wuʼ, y quin cʼut chiwe wach qui molic i winak qui ʼano, pacha qui ʼan chique uqʼuial car are qui chapo —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Are xqui ta wach xbix chique, juntir xqui canaj can i cataraya, y xe terej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Xbin chupan jubiʼ, xak xe ril i ma Jacóbo ruʼ i ma Wan chi catz qui chaʼ quib; ique je racʼal i mam Zebedéo. Je ʼo chupam jun bárco, que tijin chu yijbaxic tak i cataraya. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","I Jesus, are xe rilo, juntir xe u siqʼuij ruʼ. Ique-le, xqui canaj can i qui kajaw ruʼ i qui bárco, xak i qui mocom, y xe terej chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Xoʼon chupan jubiʼ, xe upon pa tinimit Capernaum. Are xcʼun i uxlambal ʼij, i Jesus xoc pa molbalʼib que i aj Israel winak, y xoc chu cʼutic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Lic xqui bisoj i winak wach i cʼutunic xu ʼan chique, man ire, are ca chʼaʼat cuʼ, ʼalaj ʼuri chi lic retaʼam wach i cu bij; n-are ta pacha xqui ʼan i toʼ je tijonel re i ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chupam i molbalʼib-le, ʼo jun achi ʼo jun itzel tew che. Ire ca siqʼuin chu bixquil: ");
INSERT INTO acr_acc_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—Yet, Jesus aj Nazaret ¿wuchac col a mina awib kuʼ yoj? ¿Mok xat cʼun na, col a sachbej ka wach? Yin wetaʼam a wach: at are i Jun petnak ruʼ i Dios; ¡lic ʼo re i Dios chawe! (Queje ile ca siqʼuin chu bixquil.) ");
INSERT INTO acr_acc_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","I Jesus xu ʼatij wach i xu bij: —¡Mat chʼawic! —xu bij che—. ¡Chawoʼtaj can i achi-le! —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Are ʼuri i achi co xsicsax rumal itzel tew, teʼuri i itzel tew ca siqʼuinic xel che i achi. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Conojel i winak lic xqui bisoj, y xe oc chu chʼobic chiquiwach: —¿Wach u ʼonquil ile? ¿Wach usucʼ i cʼacʼ laj cʼutunic coʼon ire-le? I achi-le lic ʼo u choʼab; ʼo puʼab que u tak bi itzel tew, y que cojon che —xqui bij i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Y juntir xpax u tzijol i Jesus ronojel i jyub re i Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Are xel pa molbalʼib, xe ʼe che i cachoch i ma Simon y ma Andres, xak xe ʼe i ma Jacóbo y ma Wan cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Are xe upon chila, i u chuch u jiʼ i ma Simon iwab, cotzʼol chuwi u chʼat, ʼo ʼaʼ chirij. I je ʼo chila xqui bij che i Jesus chi iwab i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Are ʼuri, ire xtejeb ruʼ ixok; xu chap che u ʼab, y xu walijsaj. Juntir xchup i ʼaʼ chirij. Teʼuri xoc chi qui tzukic. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Are xkaj i ʼij, ya xoc aʼab, teʼuri i winak xqui ticba li u cʼamic iwabib ruʼ i Jesus. Xak xqui cʼam li niʼpa i ʼo itzel tew chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Conojel i winak re i tinimit xqui rik quib pa ocbal bic ruʼ ja, pa ʼo wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Je qʼui xe rutzirsaj, xa bi chi cʼaxil ʼo chique, xak xe resaj niʼpa itzel tew ʼo chique. Xui-ri, n-xu ya ta chique itzel tew que chʼawic, man ique-le quetaʼam u wach. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Sakir chucab ʼij, cʼa ʼekum na, i Jesus xwalijic, xel ruʼ ja, xa ʼe che jun lugar tzʼinilic. Chila xu tzʼonoj wi che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Teʼuri i ma Simon cuʼ i rachiʼil, xe ʼe chu tzucuxic. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Are xqui riko, xqui bij che: —Conojel i winak que tijin cha tzucuxic —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Xui-ri, i Jesus xu bij chique: —Coj ʼe chic che juban tak aldéa; ʼo u chac xak quin bij u tzij i Dios chique i winak chila. Are i rumal ile xin petic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Teʼuri, xe ʼe che ronojel i jyub re i Galiléa, chu bixquil u tzij i Dios chique i winak pa tak molbalʼib que i aj Israel. N-xui ta la ile xu ʼano, xak xe resaj itzel tak tew chique i je niʼpa je chaptajnak cumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Xoʼon panok, ʼo jun achi xupon ruʼ i Jesus, ʼo yobil che, lépra ca bixic. Lic xu tzʼonoj utzil chomal che. Xuqui chuwach y xu bij che: —We ta cawaj, cat tiqui chi rutzirsaxic i yobil ʼo chwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","I Jesus lic xril toʼbal u wach. Xu yin pan ruʼ u ʼab; xu bij che: —Cwaj —xu bij—. ¡Chel ni yobil ʼo chawe! —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Are xu bij ire ile, juntir xel i yobil che; xcanaj canok chom chic u chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Teʼuri i Jesus xu ʼijla bic; lic xu pixbaj y xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Chatapeʼ, mi jun ma lapla che wach in ʼanom chawe; xui-ri, ja cʼutu awib che i sacerdóte, cʼutbal-re che chi n-ta chic i yobil lépra chawe. Cha jacha can a sipon che, chi cu sujuj chuwach i Dios pacha u bim can i mam Moises ujer. Queje ile caquetamaj i winak chi utzirnak chic i cʼax chawe —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Xui-ri, i achi, are xa ʼec xoc chu bixquil chique conojel i winak wach i ʼantal che; lic xu paxsaj u tzijol. Rumal ile, lic xe qʼuiar i winak ruʼ i Jesus, xa ipa xa ʼe wi. Rumal-i, ire n-xoc ta chic mer pa tak tinimit, xui xcanaj can pa tak jyub tzʼinilic. Xui-ri, cʼa je qʼui ni winak xe upon ruʼ xa bi chi tinimital. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Xoʼon chupan jubiʼ chic, i Jesus xtzalij chic pa tinimit Capernaum. Xpax rason chi ire ʼo chic chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Juntir xqui mol quib i winak ruʼ, ya n-que oc ta chic paja; que bajbatic cʼa chuxol uchija. I Jesus xoc chu bixquil u tzij i Dios chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Are ca tijin chu bixquil, xe upon cajib achiab, cucʼam bi jun achi chuwa chʼat, lic siquirnak u chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Cacaj ique que oc ruʼ i Jesus; xui-ri, cumal i winak je qʼui, n-xe tiqui ta che. Rumal-i, xe ʼel bi chuwi ja y xe oc chu toric i xot mer puwi i Jesus. Teʼuri i je cajib-le xqui kajsaj bi achi chuwa chʼat chuwach i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Ire, are xrilo chi lic qui cubam qui cʼux che, xu bij che i iwab: —Wacʼal, niʼpa i a mac, ya cuytajnak chic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Xak je ʼo jujun aj tijonel re i u ʼatbal tzij i mam Moises je cul chila. Ique xe oc chu chʼobic pa qui cʼux: ");
INSERT INTO acr_acc_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“¿Wuchac queje ile cu bij i achi-le? I tzij xu bij ire-le, tzel cu ta i Dios, man mi jun ʼo puʼab cu cuy ni qui mac i winak; xui i Dios ʼo puʼab cu cuy na,” que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Juntir xu na i Jesus pu cʼux wach que tijin chu chʼobic; rumal-i xu bij chique: —¿Wuchac qui chʼob ile pi cʼux? ");
INSERT INTO acr_acc_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ile, n-cʼax tu bixquil chi “Ya xcuytaj a mac.” Are i cʼax u ʼonquil are iri: “Chat walijok, cha yaca bi a soc, y chat binok.” Are cʼax u ʼonquil ile che jun winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Xui-ri, yin chi in Achi aj Chicaj, quin ʼalijinsaj na chiwe chi yin ʼo pinʼab quin cuy ni qui mac i winak waral chuwach i jyub taʼaj —xu bij i Jesus chique. Teʼuri xu bij che i achi chi siquirnak: ");
INSERT INTO acr_acc_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Yet, chatapeʼ: chat walijok, cha yaca bi a soc, y jat chi awachoch. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Juntir xwalij i iwab, xu yac bi u soc, y xa ʼec. Xwalij chiquiwach niʼpa i je ʼo chila y xa ʼec. Ique lic xqui bisoj che y xe oc chu cojic u ʼij i Dios: —Lic n-kilom ta iri —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Xoʼon panok, i Jesus xa ʼe chic chu chiʼ i nim laj alagun. Are ʼo chila, je mas i winak xe moltaj ruʼ; ire xoc chic chu cʼutic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Teʼuri xbin chic jubiʼ y xu rik jun achi, ma Lewi u bi, chi u cʼojol i ma Alféo. Ire cul pa qʼuijibal chila pa cu tzʼonoj wi i alcawal re i ʼatbal tzij. I Jesus xu bij che: —Chat terej chwij —coʼon che. I ma Lewi juntir xwalijic y xterej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Xoʼon panok, i Jesus cuʼ u tijoxelab que tijin chi waʼim pa rachoch i ma Lewi-le, junam cuʼ juban chic aj tzʼonol alcawal, je qʼui. Xak je ʼo juban winak que tijin chi waʼim cuʼ, chi n-kas ta que cojon che i ʼatbal tzij re i mam Moises; je qʼui je terejnak chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Chila je ʼo jujun aj Fariséo junam cuʼ i qui tijonel re i ujer ʼatbal tzij; ique, are xquilo chi i Jesus ca tijin chi waʼim cuʼ i winak-le, xe oc chu bixquil chique i u tijoxelab i Jesus: ¿Wuchac i mayes yix cu tij u wa cuʼ i mal laj tak aj tzʼonol alcawal, xak cuʼ juban ajmaquib? —xqui bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","I Jesus, are xu ta wach i quiqui bij, xu bij chique: —Quin ʼan iri, man are i je iwab craj jun ajcun chique; i ʼutz qui wach n-tu chac ajcun chique. Yin in cʼun-nak chi qui siqʼuixic i je ajmaquib; n-in cʼun-nak ta chi qui siqʼuixic i je ʼutz laj tak winak. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Xoʼon panok, i u tijoxelab i ma Wan aj kajsanel ya, xak i je aj Fariséo, que tijin che qui costúmbre, ayun u bi. (Are i usucʼ i ayun-le: quiqui chʼij jun ʼij, queb ʼij chuwach i Dios, n-ta wa quiqui tijo.) Che i ʼij-le, je ʼo juban winak xe upon ruʼ i Jesus; xqui tzʼonoj che: —¿Wuchac i a tijoxelab yet n-cacoʼtaj ta jun ʼij, queb ʼij i qui waʼim pacha quiqui ʼan i u tijoxelab i ma Wan, xak i que terej chiquij i aj Fariséo? —xqui bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","I Jesus xu bij chique: —I winak, we que ʼe pa nimaʼij re jun achi ya ca cʼuliʼic, ¿xataba n-quiqui tij ta wa ruʼ? Quiqui tijo pues. N-ʼus taj quiqui xutuj i waʼim, tzʼakat ire ʼo cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Xui-ri, we xu rik i ʼij chi ʼelsam chic i achi chiquixol, teʼuri quiqui mayij i waʼim. (Queje i tijojbal tzij ile xu bij i Jesus chique. Xak ʼo jun chic tijojbal tzij xu bij chique. Are iri:) ");
INSERT INTO acr_acc_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","—Mi jun cu cʼojoj jun u ʼuʼ ʼel ruʼ jun chʼakap cʼojbal cʼacʼ, man i cʼojbal cʼacʼ xa ca tzajic, y cu rakchʼij i cʼul ʼel y ruʼ ile cu nimarsaj i rakchʼijnak. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Xak queje ile, mi jun cu coj i víno cʼacʼ chupam i ʼel tak surum. N-quiqui ʼan taj, man i víno cʼacʼ xa cu rakchʼij ni surum. Queʼelok, coʼon mal i surum, xak ca sach i víno. Rumal-i, ʼo u chac qui cʼol i víno cʼacʼ chupam i surum cʼacʼ —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Xoʼon panok, chupam jun uxlambal ʼij, i Jesus ca bin cuʼ u tijoxelab chupam juban ticon. I u tijoxelab xe oc chu chʼupic u wach i trígo are xe icʼawic. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","I aj Fariséo xqui bij che i Jesus: —¡Chawilapeʼ! ¿Wuchac i a tijoxelab quiqui ʼan i chac-le che i uxlambal ʼij-i? Ile nim laj mac u bim i mam Moises —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Teʼuri, ire xu bij chique: —¿Xataba n-iwetaʼam ti yix wach i xoʼon i mam David ujer are xu tij numic? Ire cuʼ i rachiʼil lic que numic, lic ʼo rajwaxic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Rumal-i, xoc ire pa rachoch i Dios y xu tij i caxlanwa chi sujtal chuwach i Dios. Are xu ʼan ile, are i mam Abiatar ʼatz laj sacerdóte. I caxlanwa-le, n-ta re i mam David che. Man cu bij i ʼatbal tzij tzʼibtal can rumal i mam Moises, xui i sacerdóte que tijaw i caxlanwa-le. Péro i mam David xu tijo, xak xu ya chique i je rachiʼil —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Xak xu bij chique: —I uxlambal ʼij, Dios u yijbam cumal i winak, ʼanbal ʼutz chique. Mi ʼan jechʼ che; i uxlambal ʼij n-que u rajawij ta piquiwi i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Rumal-i, yin chi in Achi aj Chicaj, quin rajawij puwi i uxlambal ʼij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Teʼuri i Jesus xoc chic pa molbalʼib. Chila ʼo wi jun achi, xchakij u ʼab rumal siquirnak. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Xak je ʼo jujun chila que tijin chu takexic i Jesus, we crutzirsaj i achi-le pa uxlambal ʼij; cacaj ique quiqui tzucuj u mac. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","I Jesus xu ʼijla i achi chi chakijnak u ʼab. Xu bij che: —Chat walijok, y chat tacʼal chakaxol —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Teʼuri xu bij chique i winak: —I ʼatbal tzij tzʼibtal can rumal i mam Moises, ¿wach cu bij chake, qui bij yix? Chupam i uxlambal ʼij, ¿ʼutz we caka ʼan jun utzil chomal, o xa caka ʼan i n-ʼus taj? ¿ʼUtz caka to jun chuwach i camic? ¿O xa caka camsaj? Queje ile xu bij i Jesus chique, xui-ri, mi jun xchʼawic. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ire toʼ xe u takej, lic coywaric. Xak lic xbison chique man n-xcaj tu tayic usucʼ. Teʼuri xu bij che achi: —Cha sucʼba i a ʼab —coʼono. I achi xu sucʼba, y juntir xutziric. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Are ʼuri i aj Fariséo xe ʼel bic y xe ʼe cuʼ i jutzobaj je u cwenta i ma Heródes. Junam xe oc chu chʼobic wach u camsaxic i Jesus quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","I Jesus xa ʼe chic cuʼ u tijoxelab chu chiʼ i alagun; xak je qʼui i winak re i jyub Galiléa xe terej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Are xqui ta u tzijol wach i nimak tak ʼanic ca tijin i Jesus chu ʼonquil, je qʼui i winak xe cʼun aj pa jyub Judéa, xak aj pa Jerusalen, xak aj pa jyub Iduméa, xak aj chʼakap re i ya Jordan, xak xe cʼun i je re i jyub u cwenta i queb tinimit Tíro y Sidon. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","I winak je qʼui, lic quiqui pitzʼ i Jesus, rumal-i, xe u tak bi u tijoxelab chu yijbaxic jun bárco che. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Je qʼui i winak je rutzirsam, rumal-i, conojel i iwabib ʼis quiqui min quib ruʼ, cacaj quiqui chap na jubiʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Niʼpa i ʼo itzel tak tew chique are xquil u wach i Jesus, juntir xe xuqui chuwach y xe siqʼuin chu bixquil: —¡Yet at u Cʼojol i Dios! —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Xui-ri, i Jesus xe u yaj i itzel tew; n-xu ya ta chique quiqui bij pachin ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Xoʼon panok, i Jesus xel bi chuwi jun jyub, y xe u siqʼuij ruʼ pachin craj ire chi que terej chirij; y xe ʼe ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Chila xe u cha cablajuj chique, chi que terej na chirij, lic rachiʼil na ire. Xu ya qui patan que ʼel chu bixquil u tzij i Dios; (ique “apostelab” ca bix chique). ");
INSERT INTO acr_acc_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Xak xu ya piquiʼab ique que tiqui chi cutzirsaxic iwabib, xak que quesaj bi itzel tew chiquij i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","I qui bi i cablajuj-le: jun, ma Simon, chi xak ma Pédro xbix che rumal i Jesus; ");
INSERT INTO acr_acc_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","y queb chic: ma Jacóbo, chilam u chaʼ chi ma Wan, chi je racʼal i mam Zebedéo; i Jesus xu ya pi qui bi “Boanérges” chi queʼelok je achiab pacha u chʼawbal jab. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Xak i ma Andres, i ma Felípe, xak i ma Bartolome, i ma Matéo, i ma Tomas, y jun chic ma Jacóbo chi u cʼojol i mam Alféo; xak i ma Tadéo, xak i jun chic ma Simon chi re i partído cananísta, ");
INSERT INTO acr_acc_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","xak ʼo i ma Júdas Iscarióte chi xoʼon panok xu jach i Jesus piquiʼab i tzel que ʼilawic. (Ile je are i cablajuj apostelab je chatal rumal i Jesus.) I Jesus xtzalij chali cuʼ u tijoxelab ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Are xe uponic, xqui mol tan chic quib i winak ruʼ; ique n-xtijtaj ta chic qui wa cumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","I rachalal i Jesus, are xqui ta rason wach ca tijin chu ʼanic, ique xe ʼe chu cʼamic, man quiqui bij i winak xa chʼujernak, quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Xak xe upon i je aj tijonel re i ujer ʼatbal tzij; cʼa pa Jerusalen je petnak wi. Ique xqui bij: —I achi-ri ʼo puʼab i cajʼatzil itzel, chi Beelzebu u bi. Ruʼ u choʼab i itzel-le, ca tiqui chi relsaxic itzel tak tew —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Rumal ʼuri, i Jesus xe u siqʼuij ruʼ y xu ya jun tijojbal tzij chique. —I cajʼatzil itzel ¿xataba que resaj i je u takon ire? N-que resaj taj —xu bij i Jesus chique—. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Iwetaʼam yix, jun tinimit we quiqui jach quib pa tak tzobajil, y quiqui ʼan chʼoʼoj chiquiwach, n-que najtin taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Xak queje juban alal, we n-junam ta qui wach, we quiqui jach quib chiquiwach, xak n-que najtin ta ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Xak queje i itzel cuʼ u takon; we quiqui jach quib chiquiwach, y quiqui ʼan chʼoʼoj chiquiwach, n-que najtin taj, xa que sachic. (Rumal-i, i Satanas, n-que resaj ti u takon ire che jun winak.) ");
INSERT INTO acr_acc_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Jun, we craj coc pa rachoch jun achi chi lic ʼo u choʼab, cresajbej re ubitak-re, ire n-ca tiqui ta che we nu yutʼum ti rajaw ja nabe. We u yutʼum chic, teʼuri ca tiqui chi relsaxic ubitak-re. (Queje xu bij i Jesus ile, cʼutbal-re chique chi ire tiquinak chic che itzel.) ");
INSERT INTO acr_acc_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","—Chitapeʼ —xu bij i Jesus chique i nimak qui patan—, ʼo u cuytajic i qui mac i winak, wach tak quiqui ʼano, wach tak quiqui bij, ");
INSERT INTO acr_acc_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","xui-ri, we cʼax quiqui bij chirij i u Tewal i Dios, ile lic n-tu cuytajic. Pachin i que ʼanaw ile, lic ʼo ni qui mac chiquij ronojel ʼij sak. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Queje xu bij i Jesus ile chique; man qui bim ique chi xa are u tewal itzel ʼo ruʼ, xui-ri, are i u Tewal i Dios ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Teʼuri xe upon i u chuch xak i u chaʼ i Jesus. Xe taqʼui chuwaja y xqui tak u siqʼuixic cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Chila pa ja, je ʼo uqʼuial winak je chʼuquernak chu tayic u tzij i Jesus. Ique xqui bij: —I a chuch cuʼ i a chaʼ je ʼo chi sak; cat qui tzucuj —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I Jesus xu bij chique: —¿Pachin in chuch, tak i je in chaʼ? —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Teʼuri cʼula xe u takej niʼpa i je chʼuquernak ruʼ y xu bij: —Niʼpa i je ʼo chi ʼis je are in chuch, xak je in chaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pachin i que tijin chu ʼanic pacha craj i Dios, ique-le je are in chaʼ, xak je are i wanab, xak in chuch —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Xoʼon panok, i Jesus ʼo chu chiʼ i alagun, ca tijin tan chic chi qui tijoxic i winak. Xe moltaj uqʼuial winak ruʼ, rumal-i, xoc ire chupam jun bárco y xcubi chila. I bárco, ʼo pan jubiʼ pa ya, i uqʼuial winak je ʼo chu chiʼ i ya. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Ire, mas tak i cʼutunic xoʼon chila. Are i cʼutunic xu ʼano, xui tak ejémplo xu bij chique, tijojbal que. Jun tijojbal tzij xu bij chique are iri: ");
INSERT INTO acr_acc_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","—Chitape in tzij-i —xu bij chique—. ʼO jun achi xa ʼe chu tiquic u ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Are xe u quirij i rijaʼ, ʼo jubiʼ xeʼe tzak pa be; teʼuri xe cʼun i tzʼiquin y xqui tij bic. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Xak jubiʼ chic i ija xeʼe tzak pa tak abaj chi n-ta kas ulew che. Juntir xalax lok, man n-naj taj ʼenak wi pulew. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Xui-ri, are xel li ʼij, xchakij na, man n-naj taj ʼenak i raʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Xak juban chic xeʼe tzak pa qʼuix. Are xpoʼic, xqʼuiy i qʼuix chirij, y xcamic; n-xwachin taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Xak ʼo ni ija xeʼe tzak che ulew chom. Chila xpoʼ wi, y xqʼuiyic, y xu ya u wach chom. ʼO jujun xu ya tréinta u wach; xak ʼo i xu ya sesénta u wach; xak ʼo i xu ya cien u wach —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Are xutzin u bixquil ile chique, xu bij: —We yix ʼo i xiquin chu tayic, chi ta u be ʼuri —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Are utuquel chic i Jesus, xe upon i cablajuj u tijoxelab ruʼ, tak juban chic chique i je terejnak chirij, xol qui tzʼonoj che chi ca sakirsax chique wach usucʼ i tijojbal tzij xu bij-le. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Xu bij ʼuri chique: —Yix ʼut, i Dios u yom chiwe qui ta u be wach usucʼ i ʼatbal tzij aj chicaj, chi n-xa ʼetamax ta ujer. Xui-ri, i juban winak (chi n-que terej ta chwij), xa ruʼ tijojbal tzij ca ʼani i cʼutunic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","(Queʼel chique pacha i tzʼibtal canok rumal i mam Isaías ujer): Quiqui ta neri, péro n-quiqui ta tu be; que tzun neri, péro n-ta quiquilo. Man we ta quiqui ta u be, quiqui jalwachij ʼuri qui cʼaslemal, y ca cuytaj qui mac ʼuri rumal i Dios —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Teʼuri i Jesus xu bij chique: —¿Xak yix n-qui ta tu be i tijojbal tzij-le? We n-xi ta tu be i ral tak tzij-le, ¿wach u tayic ʼuri u be i juban tijojbal tzij quin bij na? ");
INSERT INTO acr_acc_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","I aj ticanel re ija-le are aj paxsal u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","I ija-le chi ca tzak pa be, queʼelok pacha quiqui ʼan i winak chi quiqui ta u tzij i Dios, xui-ri, weʼ ca cʼun i Satanas cuʼ, col resaj i tzij chi tictal piqui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Xak je ʼo jujun pacha xoʼon i ija chi xtzak pa abaj: are quiqui ta u tzij i Dios, que quicotic quiqui cʼam pa canima. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Xui-ri, n-naj taj ʼenak i raʼ pa canima, rumal-i, n-quiqui chʼij ta naj. Are ca pe i cʼax piquiwi, xak we ca pe chʼoʼoj chiquij rumal u tzij i Dios, xa cacoʼtaj canok. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Xak je ʼo jujun pacha ija xtzak pa qʼuix: quiqui ta u tzij i Dios; ");
INSERT INTO acr_acc_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","xui-ri, xa que cʼachir rumal i cʼaslemal waral chuwach i jyub taʼaj; xak i qui rayijbal re mas i mer, mas i ubitak que, xak u rayijbal re i qui chʼacul, niʼpa tak ile xa cu chup i ʼutz laj tzij. Rumal-i, n-ta ca wachin chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Xui-ri, je ʼo jujun quiqui ta u tzij i Dios, y quiqui cʼam piqui cʼux. Teʼuri, ca wachin chique pacha xoʼon i ija tictal pa ʼutz laj ulew. ʼO jujun chique je pacha i rakan chi xu ya tréinta u wach, xak ʼo jujun quiqui ya sesénta, xak ʼo jujun quiqui ya cien u wach —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","I Jesus xak xu bij chic jun tzij chique. —Jun cantil, are qui cʼam lok, ¿xataba qui ya chuxeʼ jun cajon, o chuxeʼ jun chʼat? N-queje ta ile. I ʼaʼ-le ca yaʼ ʼan chicaj, man ca ʼe u tzunbal. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Xui-ri, niʼpa i n-ca ʼiltaj taj, ca ʼalijinsax na; xak ronojel niʼpa i uwam u wach ʼis quelsax na chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","We yix ʼo i xiquin chu tayic, chi ta u be ʼuri —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","I Jesus xak xu bij i tzij-i chique: —Chi cojo retalil che wach quix tijin chu tayic. Ruʼ i pajbal pa quix pajan wi yix, xak ruʼ ile ca paj wi chiwe yix. (We lic qui coj retalil che i sak laj tzij re i Dios, ire cu ya ʼuri mas u nojbal chiwe. Y coʼon panok, mas cu ya na chic chiwe puwi ile.) ");
INSERT INTO acr_acc_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Jun, we ʼo na chic ʼo ruʼ, ca yaʼ na mas ʼuri che; xak queje i jun, we n-ta ʼo ruʼ, quelsax na i jubiʼ ʼo ruʼ —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","I Jesus xu bij chic jun tijojbal tzij chique. Xu bij: —I ʼatbal tzij re i Dios quin junamsaj ruʼ juban ija tictal na. Queʼelok pacha coʼon jun achi chi cu tic ija pulew. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Ire n-cretamaj taj wach i qʼuiyic coʼon u ticon; ire xa cwaric ʼab ʼab, xak cwalij ronojel u sakirbal. Queje coʼon ire ile, tzʼakat quicʼaw i tiémpo. I u ticon ca poʼic y ca qʼuiyic. Ire n-retaʼam taj wach mer rumal xpoʼ u ticon. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Utuquel i ulew xoʼon che i ticon chi xqʼuiyic y xwachinic. Nabe, calaxic, teʼuri ca qʼuiy i rakan, ca pe i ochʼ che, y pa qʼuisbal-re, coʼon ʼan. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Are ya ʼan chic, ca jachʼic, man ya xu rik i ʼij molbal-re. (Queje i tijojbal tzij ile xu bij i Jesus, wach coʼon i Dios chique i qui jachom chic quib puʼab i u ʼatbal tzij ire.) ");
INSERT INTO acr_acc_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Teʼuri i Jesus xu bij chique: —I ʼatbal tzij re i Dios, ¿wach nawi quin junamsaj ruʼ, sakirsabal-re chiwe wach usucʼ? ¿Wach i tijojbal tzij quin bij na chiwe? ");
INSERT INTO acr_acc_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Quin junamsaj ruʼ jun ija re i mostas. I ija-le ca tiquic, are mer chʼutik chuwach ronojel niʼpa ija. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Xui-ri, are tictal chic, ca qʼuiyic, y mas nim queʼel chiquiwach i rachiʼil. Ca pe i u ʼab lic nimak, teʼuri que cʼun i tzʼiquin y quiqui ʼan ni qui soc che u mujbal u ʼab. (Queje i tijojbal tzij ile xu bij i Jesus chique, sakirsabal-re wach u qʼuiyaric i u ʼatbal tzij i Dios chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Queje u cʼutic ile xoʼon i Jesus. Ruʼ uqʼuial ejémplo xe u tijoj che u tzij i Dios, niʼpa tak i tzij chi xe tiqui chu tayic u be. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Are i cʼutunic xoʼon ire chique i winak, ʼis ruʼ tijojbal tzij xu bij chique, xui-ri xu sakij ni usucʼ chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Che i ʼij-le, are xoc aʼab, teʼuri i Jesus xu bij chique u tijoxelab: —Coj ʼax chʼaka alagun —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Teʼuri xe qui canaj can i winak y xqui cʼam bi i Jesus chupam i bárco pa cul wi ire; queje ile xqui ticba ʼenam puwi i ya. Xak je ʼo juban chic winak xe ʼe cuʼ chupam juban chic bárco. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Are que tijin chi be, xpe jun nim laj tew puwi i ya. I tew lic cu yac u wi i ya chicaj, y xoc chupam qui bárco, laj xnoj rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","I Jesus xa cwar pan che u je i bárco, u yom u jolom pujaʼ u chʼaquet. Ique xe ʼe qui cʼastaj, y xqui bij che: —Mayes, ¿yet n-ta ca chʼob che we coj muktaj pa ya? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","I Jesus xwalijic y xu ʼatij i tew. Xak xu bij che i ya: —¡Cha mayij! ¡Chat uxlanok! —xu bij che. Teʼuri i tew juntir xuxlanic; xak i ya n-ca silab ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Teʼuri xu bij chique u tijoxelab: —¿Wuchac xi xij iwib? ¿Wuchac n-tu cubibal i cʼux chwe? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ique lic je ocnak ʼil che. Xqui bij chiquiwach: —¿Bi chi achial ile chi que cojon i ya che, xak i loʼlaj tew? —xqui bij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Teʼuri xe upon chʼaka ya, pa qui jyub i aj Gadára. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","I Jesus, are xel pa bárco, juntir xcʼun jun achi ruʼ, chi ʼo itzel tew che. I achi-ri petnak pa tak pantion chuwi camnak. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Chila jekel wi pa tak pec que i camnak. Ire tijtal u ximic cumal i winak, xui-ri ne te tiquinak che, xak mi ne ruʼ carena. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Qʼuialmul qui yutʼum i rakan i u ʼab che carena, xui-ri ire ʼis xu tʼukij, xa xoʼon chʼakatak che. Niʼpa i chʼichʼ qui cojom che i rakan, ʼis ca tiqui chu ʼajic; mi jun winak ca tiqui che ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Chi paʼij chi chaʼab, ire xmalcat tzam tak jyub xak chuwi camnak, toʼ ca siqʼuinic. Xak cu joy i rij che abaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Are xril u wach i Jesus cʼa naj panok, xa ʼe paʼanem, y xuqui chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Teʼuri xsiqʼuin chu bixquil i tzij-i: —Jesus, yet chi at u Cʼojol i Dios chi ʼatz u ʼij, ¿wuchac xat cʼun wuʼ? Chuwach i Dios lic quin tzʼonoj chawe, min a ya pa cʼax —xu bij. (Ile are itzel tew xchʼawic.) ");
INSERT INTO acr_acc_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Queje ile xu bij, man i Jesus ca tijin chu bixquil: —Yet, at itzel tew, ¡chat el che i achi-ri! ");
INSERT INTO acr_acc_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","I Jesus xu tzʼonoj che: —¿Wach a bi? —xu bij che. Ire xu bij: —Are in bi, are “Legion”, man oj qʼui —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ire lic xu tzʼonoj che i Jesus: —Moj a tak bi naj che i jyub-i —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Chu nakaj i jyub-le ʼo juban ak que tijin chi waʼim chuwach jun ral jyub. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Are ʼuri i itzel tak tew lic xqui tzʼonoj che i Jesus: —Choj a taka bi cuʼ i ak-le; cha ya chake coj oc chique —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Teʼuri i Jesus xu ya chique pacha i xqui tzʼonoj; xe ʼel ʼuri che achi y xe oc chique i ak. I uqʼuial ak-le, juntir xe ʼe paʼanem chu chiʼ jun siwan; xe tzak bi cʼa pa ya y xe jiʼic. Colo je queb mil i qui qʼuial i ak-le. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","I aj yuʼul ak lic xqui xij quib. Xe ʼe paʼanem chija, xak pa tak jyub, chu lapic wach i xquilo. Y xe cʼun i winak chi rilic wach i xa ʼani chila. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Are xe upon ruʼ i Jesus, xquil i achi chi ʼo te itzel tew che. Xquilo chi toʼ chʼucul chubic, jic chic u nojbal; u cojom chic u ʼuʼ. Rumal-i, i winak-i lic xqui xij quib che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Je niʼpa i quilom wach u ʼanom i Jesus che i achi-le, ique xqui lap chique i juban chi cʼa te xe cʼunic. Xqui bij chique wach i quelsaxic itzel tew che i achi, xak wach tak xqui ʼan i ak. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Teʼuri i winak xe oc chu tzʼonoxic pawor che i Jesus chi quel chila che i qui jyub. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Are ca tijin roquic i Jesus pa bárco, i achi, chi ʼo te itzel tew che, lic craj te ʼenam ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","I Jesus n-xu ya ta che, xui-ri, xu bij che: —Jat che awachoch cuʼ awachalal. Ja lapa chique wach u ʼanom i Awajwal chawe; ja bij chique chi lic xril toʼbal a wach —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","I achi-le xa ʼe chu bixquil wach i utzil chomal u ʼanom i Jesus che. Naj xa ʼec; xbin chupam i lajuj tinimit re i Decápolis chu bixquil. Conojel i winak chila lic xqui bisoj wach i cu bij i achi-ri. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","I Jesus, are xa ʼax chali ruʼ u bárco jewa, lic xe moltaj mas i winak ruʼ. Ire xcanaj can chu chiʼ i alagun. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Are ʼo chila, xupon jun achi ruʼ, ma Jáiro u bi. Ire jun cajwal re i molbalʼib que i aj Israel. Are xril i Jesus, xuqui chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Lic xu tzʼonoj jun pawor che. Xu bij: —I ral in miʼal ya ca camic —coʼono—. Cha ʼana utzil chomal chwe, jo wuʼ, que a ya a ʼab puwi, cawutzirsabej-re, ca yabej re u cʼaslemal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Are ʼuri i Jesus xa ʼe ruʼ i achi. Mas je qʼui i winak je teren chirij; lic ca bajbat i Jesus chiquixol i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Xak chiquixol i winak-le, ʼo jun ixok lic iwab. ʼO chic cablajuj junab u jekanic i yobil ʼo che; n-ca tani ta chic u yobil. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Ire ʼenak chic cuʼ uqʼuial aj cun, lic u chʼijom i cʼax rumal wach ʼantal che cumal, xak ʼis u sachom chic u mer rumal; xui-ri n-ta xoʼon re che; xa mas cu tzʼabij u yobil. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ire u tom rason wach coʼon i Jesus, rumal-i xe u mina rib chiquixol i uqʼuial winak chirij i Jesus, y xu yin pan u ʼuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Queje xoʼon ire ile, man xu chʼob ire, “We xui quin chap jubiʼ u ʼuʼ i Jesus, quin utzir na.” ");
INSERT INTO acr_acc_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Are xu chap u ʼuʼ, juntir xtan can u quiqʼuel. Xu na pu chʼacul chi ya xutzir i cʼax che. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Xak i Jesus xu naʼo chi xak teʼet, ruʼ u choʼab, rutzirsam jun iwab. Rumal-i, xtzun chirij. —¿Pachin xu yin in ʼuʼ? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","I u tijoxelab xqui bij che: —Lic je qʼui i winak cat qui pitzʼo, y yet ca bij ¿pachin xu yin in ʼuʼ? ¿Wach retamaxic caka ʼan yoj ile? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","I Jesus n-xu mayij ti u tzucuxic chiquixol i winak pachin xyinawic. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Rumal-i, i ixok lic xu xij rib, man retaʼam wach u ʼanom che. Ca barbatic xa ʼec, y xuqui chuwach i Jesus. Xu bij i sak laj tzij che, ronojel niʼpa i u ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","I Jesus xu bij che: —Wacʼal, at utzirnak chic rumal u cubibal a cʼux chwe. ʼUtz cat ʼec, mat cʼachir chic; ya xutzir i yobil chawij —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Cʼa ca tijin i Jesus chi tzij, ʼo i xe cʼun pa rachoch i cajwal i molbalʼib. Xqui bij che i qui patron: —I a miʼal ya xcamic. N-ta chic u chac we ca ʼe i Mayes awuʼ —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Xui-ri i Jesus n-xoʼon ta cas chique, wach i xqui bij; xa xu bij che i cajwal i molbalʼib: —Mat oc ʼil che, xui-ri, cha cuba a cʼux chwe —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","I Jesus n-xu ya taj chi que rachiʼilaj bi i winak ruʼ. Xui i ma Pédro, i ma Jacóbo, xak i ma Wan chi u chaʼ i ma Jacóbo, xui ique xe u cʼam bi ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Are xe upon ruʼ rachoch i cajwal i molbalʼib, xril i Jesus chi toʼ que chʼokowic; i winak toʼ que oʼic, toʼ que siqʼuinic. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Are xoc pa ja, xu bij chique: —¿Wuchac xa quix chʼokowic, xa quix oʼic? I ali n-camnak taj; xa cwaric —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Xui-ri, i winak xa xqui tzeʼej che. Are ʼuri i Jesus ʼis xe resaj li chi sak conojel, teʼuri xe u cʼam bi i u kajaw i u chuch i ali, chilam i je rachiʼil bi ire, y xe oc pa ʼo wi ali. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Teʼuri xu chap u ʼab i ali, y xu bij pa qui chʼawbal ique: —Talíta cúmi —xu bij. Are i usucʼ i tzij-le: Ali, quin bij chawe, chat walijok, coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Are xu bij ile, i ali juntir xwalijic, y xoc chi binic; i je ʼo chila lic xqui bisoj che. I ali ʼo cablajuj junab che. ");
INSERT INTO acr_acc_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","I Jesus lic xu bij chique chi mi ta jubiʼ quiqui chʼachʼa wach i xquilo. Xak xu bij chique chi quiqui ya u wa i ali. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Teʼuri, i Jesus xel che i tinimit-le cuʼ u tijoxelab, y xe ʼe pu tinimit ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Are xu rik i uxlambal ʼij, xoc pa ja re i molbalʼib y xoc chu cʼutic chique i winak chila. Je qʼui i winak je ʼo chila; niʼpa i xqui ta u tzij lic xqui bisoj che. —¿Pa xu tijoj wi rib i achi-le ronojel wach ca tijin chu ʼonquil? —xqui bij—. ¿Wach usucʼ i nojbal chi yatal che? ¿Pa xu nawsaj wi rib ire-le chu ʼonquil i milágro? ");
INSERT INTO acr_acc_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","¿Xataba n-are ti ire-le i aj ʼanol mexa? Ile xa are i ralab i ati Mariy; xa are i catz a-Jacóbo, i aJose, i a-Júdas, i a-Simon. ¿Xataba i ranab ne te je jekel chi kuʼ yoj? Je jekelic pues. Queje ile xqui bij i winak. Xa xqui xutuj wach i xu bij, wach i xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","I Jesus xu bij chique: —Conojel quiqui coj u ʼij jun ajbil u tzij i Dios, xui i je rach aj tinimit n-quiqui coj tu ʼij. Xak queje i rachalal, tak i je aj pa rachoch, xak n-quiqui coj tu ʼij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","I winak chila n-xqui cuba ti qui cʼux che, rumal-i, ire n-xtiqui ta chu ʼanic i milágro. Xui je queb oxib winak xu ya u ʼab piquiwi y xe rutzirsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Lic xu bisoj man i winak n-xqui cuba ti qui cʼux che. Teʼuri xa ʼe pa tak aldéa nakaj chu cʼutic chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Xoʼon panok xe u siqʼuij i cablajuj u tijoxelab ruʼ, y pa cacabil xu jek bi qui takic pa tak aldéa. Xu ya piquiʼab caquesaj itzel tak tew chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Xak xu bij chique n-ta quiqui cʼam bic are quiqui maj qui be, mi tene qui teb, mi tene qui wa, mi tene qui mer; xui qui chʼamiy quiqui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Xak xu bij chique chi toʼ xajab chiqui cojo, xak miqui cʼam chubi jumolaj qui ʼuʼ, xui i jumolaj chi qui cojom bic. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Xak xu bij chique: —We ʼo jun winak cu ya i posar, chix ʼol na ruʼ; cʼa te qui canaj we quix el che i aldéale. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","We ʼo i winak n-quix qui cʼulaj taj, xak n-cacaj ti u tayic i tzij, chix el chila. Che i pu can i ulew che iwakan, cʼutbal-re chique chi cʼo can i qui mac chiquij. I tinimit-le, are ca cʼun i tojpen re qʼuisbal ʼij, sak laj tzij i quin bij chiwe, mas nim ni tojbal mac que ique chuwach i queb tinimit Sodóma y Gomórra —xu bij chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Teʼuri ique xe ʼe chu bixquil chique i winak chi ʼo u chac quiqui jalwachij qui nojbal chi n-ʼus taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Xak xquesaj je qʼui itzel tak tew chique i winak; xak je qʼui iwabib xqui coj acéite piquiwi y xe cutzirsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Xoʼon panok, xak i ma Heródes, chi ʼatol tzij piquiwi i aj Israel winak, xak xu ta u tzijol wach i nim laj ʼanic ca tijin i Jesus chu ʼonquil, man conojel i winak quiqui lapo. Ire xu bij: —Are i ʼetz ma Wan aj kajsanel ya, walijnak chic chiquixol i camnak. Are i rumal ʼuri chi ʼo i choʼab ruʼ chu ʼonquil i milágro —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Xak je ʼo juban chic xqui bij: —Are i ujer ajbil u tzij i Dios mam Elías —xe cha. Xak ʼo i que binic: —Are jun cʼacʼ laj ajbil u tzij i Dios pacha i je re ujer —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","I ma Heródes, are xu ta, xu bij: Ire-le are i ma Wan, chi xin tak u cʼatzixic u jolom; ya walijnak chic chiquixol i camnak —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","I ma Heródes u camsam i ma Wan rumal i rixokil, chi ati Erodiys u bi. Are maja ca camsax i ma Wan, i ma Heródes xu maj i ati Erodiys che u chaʼ, chi ma Felípe. I ma Wan xu bij che: —N-ʼus taj cat qʼuiji ruʼ i rixokil a chaʼ —xu bij. Rumal-i, i ma Heródes xu tak u chapic i ma Wan, xu xim ruʼ carena, y xu tzʼapij pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","I ati Erodiys tzel cril i ma Wan. Craj cu camsaj, xui-ri n-cu rik taj wach u ʼanic cu ʼan che, ");
INSERT INTO acr_acc_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","man i ma Heródes n-xu ya ta che. Retaʼam chi ma Wan, lic sucʼul i cu ʼano; lic chʼam u cʼaslemal. Rumal-i, xu xij rib che. Are i rumal ʼuri n-xu ya ta che ixok coʼon cʼax che. I ma Heródes, are xu ta i u tzij i ma Wan, lic ʼutz xu ta, xui-ri, ʼo ca tiʼan pu cʼux rumal; n-xu rik taj wach i cu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","I ati Erodiys lic xraj u camsaxic i ma Wan, y xoʼon panok xu rik i ʼij che. I ma Heródes xoʼon jun nimaʼij re u ʼij ire. Je qʼui i nimak tak winak xe cʼun chu tijawic cenar ruʼ. Xe cʼun i je rakan u ʼab, xak xe cʼun i je cajʼatzil i u soldádo, xak xe cʼun i nimak qui patan re ronojel i jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Are que tijin chi waʼim, xoc bi i ralit i ati Erodiys, y xoc chi xajawic chiquiwach. I ma Heródes, cuʼ i je ʼo ruʼ, kus xquilo wach i xajawic xoʼon i ali. Rumal-i xu bij che: —Cha tzʼonoj chwe wach i cawaj quin ya chawe, y yin quin ya na ʼuri chawe —xu bij che ali. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lic xu cuxtaj u bi i Dios chu bixquil. —Yin lic quin ya na chawe pachique tak ca tzʼonoj chwe. N-ta coʼono we ca tzʼonoj i nicʼaj i uqʼuial tinimit chi ʼo pin ʼab —xu bij—, lic quin ya na chawe. Queje ile xu bij i ma Heródes. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","I ali xe u tzʼonoj che u chuch: —¿Wach quin tzʼonoj che, ca bij yet? —xu bij che. —Cha tzʼonoj u jolom i ma Wan che, chi aj kajsanel ya —xu bij u chuch che. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","I ali juntir xtzalijic; xa ʼe ruʼ i ma Heródes y xu bij che: —Woʼor tan cwaj i u jolom i ma Wan, aj kajsanel ya; cwaj ca ya li chwe chupam jun plato —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","I ʼatol tzij, are xu ta ile, lic xbison rumal. Xui-ri, ire u bim chic chiquiwach conojel, chi cu ya na che wach i ca tzʼonox che, xak u cuxtam u bi i Dios puwi u tzij. Rumal-i, n-xraj ta ire cu tzalij u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Are ʼuri xu tak-la bi jun soldádo chu cʼamic u jolom i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","I soldádo xa ʼe ruʼ i cárcel, y xresaj u jolom i ma Wan; xu ya ʼuri pa plato y xu cʼam bi che ali. Ire-le xe u jacha che u chuch. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","I u tijoxelab i ma Wan, are xqui ta wach xa ʼan che, xe qui cʼama u nimal y xe qui muku. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Xoʼon panok, i u tijoxelab i Jesus xe tzalij chic y xqui mol quib ruʼ i Jesus. Xe oc chu lapic che niʼpa i qui ʼanom y niʼpa i qui cʼutum chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Teʼuri i Jesus xu bij chique: —Joʼ. Jo che jun lugar pa n-ta wi winak; coj uxlan jubiʼ —coʼono. Queje xraj ire ile, man i winak n-ta qui qʼuisic ruʼ. N-ca tijtaj ta chic u wa cumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Rumal-i, i Jesus cuʼ u tijoxelab, quituquel xe ʼe chupam jun bárco che jun lugar pa n-ta wi winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Xui-ri, are xe ʼec, je qʼui i winak xe ʼilawic y xquetamaj chi are i Jesus. Are ʼuri xe ʼe paʼanem chi tak u chiʼ i alagun; nabe xe upon ique chuwach i Jesus. ʼIs pa ronojel tak tinimit je petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","I Jesus, are xel pa bárco, xe ril je uqʼuial winak je ʼo tan chic chila. Cʼax xu na u cʼux chique, man je pacha juban chij n-ta que chajiwic. Rumal-i, xoc chu bixquil uqʼuial cʼutunic chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Are mer xkaj i ʼij, i u tijoxelab xe tejeb ruʼ y xqui bij che: —Ya xkaj i ʼij, y waral xa tzʼinilic jyub, n-ta winak chi. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Cha bij chique i winak ʼutz que ʼe chu tzucuxic qui wa chi tak ja, xak pa tak aldéa nakaj —xqui bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Xui-ri, ire xu bij chique: —Yix chi ya chique wach quiqui tij na —coʼono. —¿Cawaj bari que ʼe ka loʼo queb ciénto quetzal caxlanwa, tzukbal que i winak-i? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ire xu tzʼonoj chique: —¿Niʼpa i caxlanwa ʼo iwuʼ? Je iwilapeʼ. Ique, are xquetamaj niʼpa ʼo cuʼ, xqui bij che: —ʼO joʼob caxlanwa ruʼ queb car —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Teʼuri i Jesus xe u tak i winak chi que cubi chuwa tak qʼuim pa tak tzobajil. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Che tak i tzobajil-le, ʼo jujun chi ʼo i cincuénta chique, xak je ʼo jujun je ʼo jun ciénto chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Teʼuri i Jesus xu chap i joʼob caxlanwa, xak i queb car; are ʼuri xtzun chicaj xu cʼamwaj xu tioxij che i Dios. Teʼuri xu pir i caxlanwa, y xu ya chique u tijoxelab, quiqui jachbej-re chique i winak. Xak i queb car xu ya chique, man xak quiqui ya chique conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Conojel ʼis xe waʼic y xe nojic. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Are xquelej, i u tijoxelab xqui mol u chiʼ niʼpa i chʼakatak caxlanwa, xak i car chi n-xqʼuis taj. Xnoj cablajuj coban che i chʼakatak chi xsobrinic. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Niʼpa i achiab xe tzukic, je joʼob mil. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Are xutzin ile, i Jesus xu bij chique u tijoxelab chi que oc chic pa bárco, que ʼax chʼaka alagun cʼa pa tinimit Betsáida. Queje xu bij ile chi quiqui ʼan ique tzʼakat ire que u ʼijla bi i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Are xutzin qui ʼijlaxic i winak, xa ʼe che jun jyub chu tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Are xoc aʼab, i u tijoxelab ya que upon pa nicʼaj alagun; i Jesus utuquel ʼo che i jyub-le. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Are ʼo chila, xe ril lok chi u tijoxelab uyej quiqui ʼan chu minic bi qui bárco chuwi ya, rumal i tew chi lic xpe chirij. Are ya ca pe u sakiric, i Jesus ya ca nakajab cuʼ, lic ca bin chuwi ya; ca tijin ricʼawic chiquiwach ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","I u tijoxelab, are xquilo chi ca bin chuwi ya, xqui chʼob ique, mok jun xibinel, y xe siqʼuin rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Queje xqui ʼan ile, man conojel xquilo, xak ʼis xe oc ʼil rumal. Xui-ri, ire xe u ʼijla; xu bij chique: —¡Mi xij iwib! Xa yin. ¡Chi cowirsaj i cʼux! —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Teʼuri xoc cuʼ pa bárco; are ʼuri i tew xuxlanic. I u tijoxelab lic xqui bisoj rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ique n-qui tom tu be wach usucʼ i milágro xoʼon ire che i caxlanwa (chi are ire ʼo puwi ronojel niʼpa i ʼolic). Ique toʼ tzʼapil i qui nojbal. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Are xe ʼax chʼakap, xe upon chu chiʼ i jyub Genesaret. Chila xqui yukba wi can i qui bárco. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Juntir, are xe ʼel pa bárco, i winak je ʼo chila xquilo chi are i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Rumal-i, ʼis xe ʼe paʼanem chu cʼamic li qui iwabib chuwa chʼat pa ʼo wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Pa tak ca ʼe wi ire, pa tak tinimit, pa tak aldéa, pa tak jyub, ʼis que qui cʼam li iwabib ruʼ. Xe qui ya chi tak be, y lic xqui tzʼonoj che chi ca yaʼ chique quiqui chap jubiʼ u ʼuʼ. Conojel niʼpa i xqui chap u ʼuʼ, xe utziric. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ʼO jujun aj Fariséo winak xe tejeb pan ruʼ i Jesus, cucʼam quib cuʼ jujun aj tijonel re i ujer ʼatbal tzij. Ique je petnak pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Are xe upon ruʼ, xquilo chi ʼo jujun chique u tijoxelab i Jesus chi que wa ruʼ qui ʼab tzʼil, quiqui bij ique, man n-quiqui coj ta retalil chu chʼajic qui ʼab pacha quiqui ʼan i aj Fariséo winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","(I aj Fariséo, xak conojel i juban aj Israel winak quiqui ʼan pacha i qui costúmbre i catit qui mam; n-ca tijaw ti wa we n-quiqui chʼaj ti qui ʼab qʼuialmul. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Are que cʼun pa qʼuebal, n-quiqui tij ta tan i wa we n-qui chʼajom ti qui ʼab pacha cu bij i qui costúmbre ique. Xak ʼo chic juban uqʼuial costúmbre je teren chirij: ʼo rawasil che i qui bas, xak che i qui xar, xak queje che i qui pichel chʼichʼ, xak queje che i qui chʼat; ʼis ʼo rawasil che chi quiqui chʼajo.) ");
INSERT INTO acr_acc_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Rumal-i, i aj Fariséo-le, xak i aj tijonel re i ujer ʼatbal tzij xqui bij che i Jesus: —I a tijoxelab, ¿wuchac n-quiqui ʼan ta ique pacha qui bim can i katit kamam ujer? ¿Wuchac quiqui tij qui wa, we n-chʼam ti qui ʼab chuwach i Dios? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","I Jesus xu laʼ u wach chique: —Lic katzij xu bij i mam Isaías ujer. Yix xa queb i palaj. Lic quix ʼanawic pacha chom i qui ʼano, xui-ri ire u bim canok wach quix tijin yix chu ʼanic woʼor. U bim canok chi Dios u bim na: I winak-i lic quiqui coj in ʼij ruʼ qui chiʼ, xui-ri, ruʼ qui cʼux n-quiqui ʼan taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","I u cojic in ʼij quiqui ʼano, lic n-ta cu chacuj, man i tzij que tijin chu cʼutic, xa qui tzij i winak, xui-ri, quiqui ʼan che pacha tak u tzij i Dios. (Queje ile u bim i Dios, xu bij i mam Isaías ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yix n-qui coj ta chic retalil che wach u bim can i Dios chiwe —xu bij i Jesus chique—. Xui quix tijin chu cojic i cʼutunic chi xa ruʼ winak petnak wi. Xui qui coj retalil che wach tak u chʼajic i xar, i bas, xak juban chic ʼanic pacha ile —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Xak xu bij: —I ʼatbal tzij chi u bim can i Dios chiwe, yix quix tijin chu ʼanic pacha n-ta chic u chac chiwe; are i cojom pu qʼuexel xa ruʼ winak petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","I mam Moises u bim can u tzij u pixab i Dios chiwe: “Cha cojo qui ʼij a kajaw a chuch” xu bij; xak xu bij: “Pachin cʼax ca chʼaw chiquij u kajaw u chuch, cha camsaxok”; queje ile u bim can i mam Moises chi ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Xui-ri, yix quix tijin chu cʼutic, chi jun achi, ʼo puʼab cu bij che u kajaw xak che u chuch: “N-cat in to taj, man niʼpa i ʼo wuʼ in sujum chic che i Dios” mok cu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Y we queje cu bij ire ile, n-ta chic chukul ʼuri que u to u kajaw u chuch, qui bij yix. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Queje ile, yix i kajsam u ʼij i ʼatbal tzij chi u bim can i Dios. Y pu qʼuexel ile, i cojom wi i cʼutunic chi xa winak bin-nak che jun chic. N-xui ta la ile, xak qʼui na qui ʼan yix pacha ile —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Teʼuri i Jesus xe u siqʼuij chic i winak ruʼ y xu bij chique: —Chi ta na iwonojel wach i quin bij; chi bisoj u tayic u be. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Wach ca ʼe chupam jun winak, n-are ta ca ʼanaw che chi n-chʼam ta ire. Xa are wach ca pe pu cʼux ire, are ca ʼanaw che chi n-chʼam taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","We yix ʼo i xiquin chu tayic, chi ta u be ʼuri —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Are xel i Jesus chiquixol i winak y xoc pa ja, i u tijoxelab xqui tzʼonoj che wach usucʼ i tzij-le chi xu bij chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ire xu bij chique: —¿Xak yix n-qui ta tu be? ¿N-qui ta tu be chi wach coc chupam jun winak n-are ta ca ʼanaw che chi n-chʼam taj? ");
INSERT INTO acr_acc_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Man ile n-coc ta pa ranima. Xa che u pam ca ʼe wi, xa quicʼawic y quel tan chic —xu bij i Jesus chique. Queje ile xu sakij chique chi ronojel niʼpa i u yijbam i Dios chi tzukbal-ke ʼis ʼutz, n-ta rawasil che. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Xak xu bij chique: —Xa are wach ca pe pu cʼux jun winak, are ca ʼanaw-i che chi n-chʼam taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Man ile, pa ranima ca pe wi. Piqui cʼux i winak ca pe wi i qui nojbal chi n-ʼus taj; are i rumal ʼuri ʼo i je cʼulanic quiqui kajsaj qui ʼij cuʼ i ne te cachiʼil. Are i rumal ʼuri xak ʼo i ne te cʼulanic quiqui kajsaj qui ʼij chiquiwach; are i rumal ʼuri, ʼo i winak je camsanel, ");
INSERT INTO acr_acc_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","xak ʼo i je iliʼomab, xak ʼo i je rayinel; xak ʼo i je aj ʼanol mal, xak ʼo i je aj tʼoronel; xak ʼo i je aj ʼanol n-ʼus taj; xak ʼo i ca titat qui pam chique i cachiʼil wach i ʼo cuʼ; xak ʼo i je aj nucʼul tzij; xak ʼo i quiqui ʼan nimak che quib; xak ʼo i n-quiqui chʼob ta bien wach quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Je niʼpa i que ʼanaw queje ile, are i ne te chʼam-i chuwach i Dios, y ronojel i n-ʼus taj-le, xa piqui cʼux petnak wi; n-are ti wach quiqui tijo ca ʼanaw chique. (Queje ile, i Jesus xu sakij i tzij chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Xoʼon panok, i Jesus xel che i jyub-le y xa ʼe che i jyub re i queb tinimit, Tíro y Sidon; chila xoc che jun ja. N-xraj ta ire we ca tatajic pa i ʼo wi, xui-ri, n-xtiqui ta chi ruwaxic rib chiquiwach i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ʼO jun ixok, weʼ xu ta rason pa ʼo wi i Jesus. Ire ʼo jun ralit chi ʼo itzel tew che. I ixok-i xupon ruʼ i Jesus y xuqui che rakan. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ire n-aj Israel taj, xa are aj Sirofenis winak. Xtejeb pan ruʼ i Jesus y xu tzʼonoj pawor che chi quelsax ni itzel tew che i ralit. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","I Jesus xu bij jun moxbal tzij che: —Nabe ʼo u chac que tzuk ni acʼalab, man n-ʼus taj ca maj i wa chique i acʼalab y ca yaʼ chique i tzʼi. (Queje ile xu bij i Jesus che, chi queʼelok: “Nabe que in to ni wach aj Israel.”) I ixok xu bij ʼuri: ");
INSERT INTO acr_acc_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","—Katzij i ca bij, Nim laj Winak; xui-ri, xak i ral tak tzʼi chi je ʼo chuxeʼ i mexa quiqui mol ni ucʼaj qui wa i acʼalab chi tzaknak bic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Teʼuri i Jesus xu bij: —ʼUtz i xa bij —coʼon che ixok—. Y woʼor, ʼutz cat ʼe che awachoch; i itzel tew ya ʼelnak chic che awalit —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","I ixok juntir xa ʼec. Are xupon ruʼ ja, xe u rika i acʼal cotzʼol chuwi chʼat. I mal laj tew ya ʼelnak chic che. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Teʼuri i Jesus xel che i jyub re i tinimit Tíro, xicʼaw pa tinimit Sidon; teʼuri xicʼaw pa jyub Decápolis, y xupon cʼa chu chiʼ i alagun Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Chila xqui cʼam li jun achi ruʼ, lic tac u xiquin, xak n-kas ta quel u chʼawbal. Xqui tzʼonoj che chi cu ya ni u ʼab puwi. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","I Jesus xu cʼam bi i achi, y xe tejeb pan jubiʼ. Xu min u wi u ʼab pa tak u xiquin i achi; teʼuri xu chubaj pichʼ u cʼaxaj, y xu coj u wi u ʼab che u tzamraʼ i achi. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Are ʼuri xtzun chicaj, y xu qʼuis u cʼux. Xu bij pa qui chʼawbal ique: —¡Efáta! chi queʼelok: ¡cha jaktajok! ");
INSERT INTO acr_acc_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Juntir, i u xiquin i achi xe jaktajic; xak xel u chʼawbal, n-ta chic cʼax che u tzamraʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","I Jesus xu bij chique i winak chi mi jun quiqui lap wi ile; xui-ri, are cu bij queje ile chique, xa mas quiqui paxsaj rason. ");
INSERT INTO acr_acc_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Conojel lic xqui bisoj che. Xqui bij: —Ronojel niʼpa i cu ʼano, ʼis ʼutz; cu ʼan chique i je tac, chi que tanic; y xak i je mem, que chʼaw rumal —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Xoʼon panok xe moltaj chic uqʼuial winak ruʼ; ique, xqʼuisic wach quiqui tijo. I Jesus xe u siqʼuij i u tijoxelab ruʼ y xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Toʼ qui wach i winak-i, man are oxib ʼij iri chi je ʼo chi wuʼ; n-ta chic wach quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Woʼor, we que in tak bi che cachoch, lic n-quiqui chʼij ti uponic we n-ta wa qui tijom bic. Man je ʼo jujun chique, naj je petnak wi. (Queje ile xu bij i Jesus chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ique xqui bij che: —¿Wach qui tzukic i winak caka ʼan ʼuri waral? N-ta ca tijaw chi, che i lugar-i chi lic tzʼinilic —xqui bij u tijoxelab che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","I Jesus xu tzʼonoj chique: —¿Niʼpa i caxlanwa ʼo iwuʼ? —xu bij. Ique xqui bij: —Xa wukub —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Are ʼuri i Jesus xu bij chique i winak chi que cubi chuwach tak ulew. Teʼuri xu chap i wukub caxlanwa y xu tioxij che i Dios. Teʼuri xu piro, y xu ya chique u tijoxelab. Ique xqui jach chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Xak ʼo jubiʼ ral tak car cuʼ. I Jesus xu tioxij che i Dios rumal, y xu bij chique u tijoxelab chi que qui jacha chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Conojel i winak xqui tijo y xe nojic. Are xquelej ile, i u tijoxelab xqui mol niʼpa i chʼakatak chi xsobrinic, xnoj wukub chicach che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","I winak chi xe nojic, colo je ʼo cajib mil chique. Teʼuri i Jesus xe u ʼijla canok, ");
INSERT INTO acr_acc_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","y xoc bi pa bárco cuʼ u tijoxelab; xe ʼax ʼuri chʼakap che i jyub Dalmanúta. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Je ʼo jujun aj Fariséo winak xe upon ruʼ i Jesus y xe oc chu chapic quib chi tzij ruʼ. Xqui tzʼonoj che chi cu cʼut jun milágro chique, cʼutbal-re we ʼo u choʼab i Dios ruʼ; ique xa cʼambal u pam quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","I Jesus, lic xu qʼuis u cʼux rumal; xu bij: —¿Wuchac ix winak woʼor xa quiwaj quiwil ni jun milágro, cʼutbal re u choʼab i Dios? Lic quin bij chiwe, lic mi jun cʼutbal re u choʼab ca ʼan na chiwach —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Teʼuri xe u canaj canok y xoc pa bárco, y xe ʼax chic chʼaka alagun. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","I u tijoxelab i Jesus xsach i qui wa chi qui cʼux; n-xqui cʼam tu bic wach i rajwaxic quiqui tij pa be. Xa jun caxlanwa qui cʼamom bi cuʼ pa bárco. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","I Jesus xu bij jun moxbal tzij chique: —Chitapeʼ, chi ʼana cwent che i cunbal re i caxlanwa que i aj Fariséo, xak i re i ma Heródes —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","I u tijoxelab xe oc chu bixquil chiquiwach: —Xu bij ire ile man n-ta ka caxlanwa ka cʼamom lok —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","I Jesus xu naʼo wach quiqui bij; xu bij chique: —¿Wuchac quix cʼachir rumal i caxlanwa? ¿Wuchac quix lapan chirij? ¿Maja ba qui ta u be ʼuri? ¿Xix naw ta bawa che, wach xin ʼano? ¿Lic co ba i jolom-i? ");
INSERT INTO acr_acc_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ʼO i baʼwach, ¿n-quix tzun ta bawa? ʼO i xiquin, ¿n-quix tan ta bawa? ¿N-ca cʼun ta bawa pi cʼux ");
INSERT INTO acr_acc_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","wach xiwilo are xin ya i joʼob pan chique i joʼob mil winak? ¿Niʼpa chicach i chʼakatak xsobrinic? —xu bij chique. —Cablajuj —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Xak are xin ya i wukub pan chique i cajib mil winak, ¿niʼpa chicach i chʼakatak xsobrinic? —xu bij chique. —Wukub —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Teʼuri xu bij: —¿Maja qui ta ʼuri u be ile? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Are xe upon pa tinimit Betsáida, xcʼam li jun mawach ruʼ i Jesus, y xqui tzʼonoj che chi cu chap na ruʼ u ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","I Jesus xu chap bi che u ʼab, y xel pa tinimit ruʼ. Teʼuri i Jesus xu coj pichʼ u cʼaxaj che u baʼwach i mawach, y xu ya u ʼab puwi. Teʼuri xu tzʼonoj che we ca tzun jubiʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","I mawach xu bij: —Que wil i winak —xu bij—. Pacha cheʼ, cwil yin, xui-ri que binic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","I Jesus xu coj chic u ʼab che u baʼwach; teʼuri i achi xu coj retalil che u takenic, y xutziric. Are ʼuri lic xtzun bien. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Teʼuri i Jesus xu tak bi ruʼ rachoch, y xu bij che: —Mat oc pa tinimit, xak ma bij iri chila —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Teʼuri i Jesus xa ʼe cuʼ u tijoxelab che tak i aldéa re i tinimit Cesaréa Filípo. Are que tijin chi be, xu tzʼonoj chique u tijoxelab: —I winak, are quin qui lapo, ¿wach quiqui bij ique chi in pachin yin? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ique xqui bij che: —ʼO jujun quiqui bij chi yet at ʼetz ma Wan chi aj kajsanel ya, quiqui bij. Xak ʼo i que binic chi yet at ujer mam Elías. Xak je ʼo juban chic quiqui bij chi yet at jun chic ajbil u tzij i Dios, quiqui bij i winak chawij. Queje ile xqui bij u tijoxelab che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Teʼuri i Jesus xu tzʼonoj chique u tijoxelab: —Y yix, ¿wach i qui bij yix chi in pachin yin? I ma Pédro xu bij: —Yet at Crísto (chi Tolke koyʼem) —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Xui-ri i Jesus xu bij chique chi mi jun quiqui lap wi pachin ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Teʼuri i Jesus xoc chu bixquil chique chi ire, chi Achi aj Chicaj, lic cu tij ni uyej, xak ca xutux na cumal i nimak tak mamʼib, xak cumal i cajʼatzil i sacerdóte, xak cumal i aj tijonel re i ujer ʼatbal tzij. Xu bij chique chi ca camsax na, teʼuri churox ʼij ca walijic. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ile lic sakil xu bij chique. Are ʼuri i ma Pédro xu siqʼuij pan jubiʼ ruʼ, y xoc chu ʼatixic wach i ca tijin chu bixquil. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","I Jesus xu pisquilij rib, y xe u tzu u tijoxelab. Are ʼuri xu yaj i ma Pédro: —¡Chat el chinwach, a-Satanas! A nojbal yet n-queje taj pacha u chʼobom i Dios. Ca chʼob yet pacha quiqui chʼob i toʼ winak —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Teʼuri i Jesus xe u siqʼuij u tijoxelab ruʼ, xak i uqʼuial winak, y xu bij chique: —Pachin jun craj ca terej chwij, ʼo u chac mu chʼob chic rib, xui-ri charekaj bi u cruz, y cha terej na chwij, tupu ca cam na rumal. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Queje ile chu ʼana man pachin jun xa cʼax cu na u cʼaslemal re waral, xa cu sach ʼuri u cʼaslemal chi sakil. Xui-ri, pachin jun ca sachsax nu wach u cʼaslemal waral xa wumal yin, xak rumal i ʼutz laj tzij re i Dios, cu rik ʼuri u cʼaslemal sakil. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","We ʼo jun u chʼacom ronojel i beyomal re u wach i jyub taʼaj, xui-ri we cu sach u cʼaslemal sakil, ile n-ta queʼel wi, n-ta u chʼacom ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","¿Wach u tojic ʼuri coʼon na, chʼacbal re i u cʼaslemal sakil we u sachom? N-taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","We ʼo jun ca qʼuix na chwe yin, xak che in tzij, chiquiwach i winak re woʼor chi lic je ajmaquib, xak yin quin qʼuix na che ire are quin cʼun tan chic. Yin, chi in Achi aj Chicaj, quin cʼun chic ruʼ u ʼij u chomal in Kajaw, xak cuʼ i loʼlaj ángel —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Xak xu bij chique: —Katzij quin bij chiwe, je ʼo jujun waral chi n-que cam ta tan cʼa quiquil ni u jekanic i ʼatbal tzij re i Dios waral, chi nim u choʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wakib ʼij u ʼonquil ile, i Jesus xe u cʼam bi i ma Pédro, i ma Jacóbo, xak i ma Wan; y xe ʼe quituquel che jun nim laj jyub naj u wi. Are je ʼo chila, i u tzunbal i Jesus lic xyojtajic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","I u ʼuʼ lic ca walchʼin rumal u sakil; lic sak ʼotoʼoj ca tzunic. N-ta jun cʼul, tupu lic chʼajtalic, chi ca majaw u sakil ile. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Xak xquilo chi xe winakir i mam Moises xak i mam Elías ruʼ i Jesus, que tijin chi lapanic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Are ʼuri i ma Pédro xu bij che i Jesus: —Mayes, lic ʼutz na oj ʼo waral. ʼUtz caka ʼan oxib i mujbal: jun awe yet, jun re i mam Moises, xak jun re i mam Elías —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","I u tijoxelab, lic je ocnak ʼil che wach xquilo, rumal-i n-xu na ti ma Pédro wach i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Teʼuri xkaj jutzobaj sutzʼ piquiwi y xqui ta jun nim laj chʼawbal xchʼaw chupam i sutzʼ: —Iri, are in Cʼojol, chi lic cʼax quin naʼo; chi cojo retalil che, wach i cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Are xqui ta ile, juntir cʼula xe tzunic, péro n-ta xquilo, xui chic i Jesus utuquel. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Are xe kaj li che i jyub-le, i Jesus xu bij chique u tijoxelab: —Niʼpa i xiwil yix, mi lapo cʼa cu rik ni ʼij chi yin, chi in i Achi aj Chicaj, in walijnak chic che i camic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Rumal-i, n-xqui bij taj wach i xquilo; xui-ri, xqui tzʼonoj chiquiwach wach usucʼ i tzij-le xu bij, chi ca walij che i camic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Teʼuri xqui tzʼonoj che i Jesus: —I aj tijonel re i ujer ʼatbal tzij, ¿wuchac quiqui bij ique chi nabe ca cʼun i ujer mam Elías? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","I Jesus xu bij: —Katzij i xqui bij-le, nabe ca cʼun i mam Elías, col u yijba ronojel; queje ile tzʼibtal canok. Xak tzʼibtal chic jun tzij chirij i Achi aj Chicaj: cu bij chi cu tij ni uyej xak ca xutux na. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Xui-ri, yin quin bij chiwe chi mam Elías ya cʼun-nak chic; i winak xqui ʼan che pacha cacaj ique; xeʼelok pacha i tzʼibtal can chupam u wuj i Dios —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Teʼuri xe tzalij chic chila pa je ʼo wi i juban u tijoxelab, y xquilo je qʼui i winak je ʼo chic chiquij chiquiwach. Xak je ʼo jujun tijonel chila re i ʼatbal tzij re i mam Moises; ique qui chapom quib chi tzij cuʼ u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","I winak, are xquil i Jesus, xqui bisoj, are ʼuri, xe ʼe paʼanem chu yaʼic rutzil u wach. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Are ʼuri, ire xu tzʼonoj chique: —¿Wach quix tijin chu lapic cuʼ ique? ");
INSERT INTO acr_acc_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ʼO jun achi chiquixól xu bij: —Mayes, yin xin cʼam li jun wacʼal awuʼ, ʼo itzel tew che chi u ʼanom mem che. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Xa ipa ʼo wi, ca chaptaj rumal itzel tew, y ca tzaksax pulew. Are ʼuri xa ca wokow u cʼaxaj pu chiʼ, xak cu kachʼachʼej uware rumal. Rumal-i, lic n-ta chic u choʼab. Xin tzʼonoj chique a tijoxelab chi caquesaj i mal laj tew che. Xui-ri, n-xe tiqui ta che —xu bij i achi che. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Are ʼuri i Jesus xu bij: —¡Ay, yix chi n-tu cubibal i cʼux che i Dios! ¡ʼO tan chi ʼij in ʼo iwuʼ, y yix n-ta i nawic! ¿Niʼpa nawi chic ʼij cʼa craj? —xu bij—. Chi cʼama li acʼal waral —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Xqui cʼamlok. I itzel tew, are xril i Jesus, xu ya chic atac che i ala. Ire-le xtzak pulew, lic cu balʼatij chic rib chuwach ulew, xak ca wokow u cʼaxaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Are ʼuri i Jesus xu tzʼonoj che i achi: —¿Niʼpa junab u jekanic i cʼax che? —xu bij. I u kajaw xu bij: —Ire cʼa chʼutin are xu jeko. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","I itzel tew-le, qʼuialmul u cʼakom pa ʼaʼ, xak pa ya; craj cu camsaj. ¡Chawila toʼbal ka wach! ¡Choj a to na, we cat tiqui che! —xu bij i achi. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","—Yin quin tiqui che —xu bij i Jesus—, xui-ri we yet cat tiqui chu cubaxic a cʼux chwe. Ronojel ʼis coj tiqui che we ʼo u cubibal ka cʼux —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Juntir i u kajaw i ala xsiqʼuin chu bixquil: —Cul in cʼux chawe —xu bij—. ¡Chin a to na che, chi quin cuba na mas in cʼux chawe! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","I Jesus, are xrilo chi que tijin qui moltajic i winak ruʼ, xu yaj i itzel tew y xu bij che: —Yet, at tac y at mem laj itzel tew, quin bij chawe, chat el che i ala-le. Chawoʼtaj, y mat oc chic ruʼ —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","I itzel tew siqʼuinic xoʼon chic jun atac che i ala, teʼuri xelic. Xcanaj can i ala lic pacha xcamic; rumal-i, conojel xqui bij chi lic xcamic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Xui-ri, i Jesus xu chap che u ʼab y xu yaco; i ala xtaqʼuiʼic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Teʼuri i Jesus xoc pa ja. Are ʼuri i u tojoxelab xqui tzʼonoj che: —¿Wuchac n-xoj tiqui ti yoj chi relsaxic i itzel tew-le? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ire xu bij chique: —I mal laj itzel tew pacha i jun-le n-quel taj, xui-ri we lic qui tzʼonoj che i Dios, xak we qui mayij ni waʼim rumal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Are xe ʼel chila, xe ʼax pa Galiléa. I Jesus n-xraj taj we caquetamaj i winak pa ʼo wi ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","N-xraj taj, man ire ca tijin chu cʼutic chique u tijoxelab; ca tijin chu bixquil chique chi i Achi aj Chicaj ca jachtaj na piquiʼab i winak, y ca camsax na cumal, xui-ri che oxib ʼij panok ca walij na. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Tupu xu bij ire ile chique, n-xqui ta tu be, xak xqui xij quib chu tzʼonoxic che wach usucʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Xoʼon chupanok, xe upon pa Capernaum. Are xe oc pa ja chila, i Jesus xu tzʼonoj chique utijoxelab: —Are coj tijin te chi be, ¿wach i tzij i chapom wi iwib yix puwi? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ique lic n-xe chʼaw ta chic. Are i tzij chi qui chapom wi quib ique puwi pa be, are i pachin mas nim u ʼij chique ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","I Jesus xcubiʼic, y xe u siqʼuij i cablajuj u tijoxelab ruʼ. Are ʼuri xu bij chique: —Pachin jun craj cu ya rib chu nabeal, chu ya na rib ʼuri pa qʼuisbal-re chique i conojel, xak chu ʼana che rib pacha mocom chiquij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Are ʼuri xu cʼam jun acʼal ruʼ y xu ya chiquiwach. Xu ʼaluj ʼanok y xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Pachin jun cu cʼulaj jun acʼal ruʼ pacha iri rumal i cʼaxnabal u cʼux chwe yin, are yin ʼuri quin u cʼulaj ruʼ. Pachin jun quin u cʼulaj yin ruʼ, n-xui ti yin quin u cʼulaj ruʼ, xak xu cʼulaj ʼuri i Jun chi in takawnak lok —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Teʼuri i ma Wan xu bij che: —Mayes, xkil jun achi chi ca tijin chi relsaxic itzel tew ruʼ u cuxtaxic a bi yet. Yoj ʼut xka bij che chu mayij, man n-kachiʼil taj —xu bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","—Ile mi ʼatij —xu bij i Jesus che—, man we ʼo jun coʼon milágro rumal u cuxtaxic in bi yin, n-cu bij ta ʼuri mal laj tak tzij chwij. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Pachin jun n-coʼon ta chʼoʼoj chikij, ire-le ka cwenta yoj. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Pachin jun coʼon jun utzil chomal chiwe xa rumal ix terejnak chwij, ʼo ni sipon ʼuri cu chʼaco. Queje ile queʼel che, tupu xa jun bas i yaʼ cu ya chiwe wumal yin —xu abij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Xak xu bij chique: —Jun chʼutin chi u cubam u cʼux chwe, we ʼo jun cu ʼan che chi ca tzak chupam u mac, mas ʼutz queʼel che i jun-le we tene ca xim jun caʼ rij u kul y ca cʼak bi pa ya, jiʼbalre. I camic-le mas ʼutz chuwach i camic chi ca pe puwi we cu tzaksaj jun chʼutin chupam u mac. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","We are a ʼab ca ʼanaw chawe chi cat tzak chupam a mac, suʼ cha cʼupij. Mas ʼutz ca sach a ʼab, tobal re a cʼaslemal, chuwach xa cat ʼe pa ʼaʼ chi n-ca chup taj, ruʼ i queb a ʼab tzʼakat. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","I amol chi cat qui tij chila lic n-que cam taj, xak i ʼaʼ mi jun ca chupuwic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","We are awakan ca ʼanaw chawe cat tzak chupam a mac, suʼ cha cʼupij bic. Mas ʼutz ca sach awakan, tobal re a cʼaslemal, chuwach i xa cat ʼe pa ʼaʼ chi n-ca chup taj, ruʼ i queb awakan tzʼakat. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","I amol chi cat qui tij chila n-que cam taj, xak i ʼaʼ mi jun ca chupuwic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Xak i a baʼwach, we are ca ʼanaw chawe cat tzak chupam a mac, suʼ chawesaj. Mas ʼutz cat oc pa cu ʼat wi tzij i Dios, tupu xa jun a baʼwach, chuwach i xa cat ʼe pa ʼaʼ ruʼ i queb a baʼwach tzʼakat. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","I amol chi cat qui tij chila n-que cam taj, xak i ʼaʼ chila mi jun ca chupuwic. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Ronojel niʼpa i ca sujux chuwach i Dios, cocsax ʼaʼ che, xak cocsax atzʼam che; xak yix, ʼo u chac pacha cocsax ʼaʼ, pacha cocsax atzʼam chiwe, we ʼutz i yijbaxic chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","I atzʼam, lic cu rik u chac chake. Xui-ri, we xsach i u tzayil, ¿wach u ʼonquil ʼuri caka ʼan tan chic tza che? N-taj. Xak ʼo u chac chi yix ʼo i tzayil (pacha jun sipon sujtal chuwach i Dios; queje ile, ix chom na chiwach); chom chix ʼol chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Xoʼon panok, i Jesus xel pa tinimit Capernaum, xa ʼe cʼa pa jyub Judéa; xu ʼaxuj i ya Jordan, y xupon che i jyub pa oriénte re i ya. Chila xe moltaj chic uqʼuial winak ruʼ, y ire xoc chic chu cʼutic chique pacha ʼax coʼon wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Are ʼuri, je ʼo jujun aj Fariséo xe upon ruʼ, xa quiqui tzucuj tzaksabal re. Xqui tzʼonoj che we i ʼatbal tzij cu ya che jun, we craj cu jach i rixokil. Queje ile quiqui cʼambej u pam, xqui bij ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Are ʼuri i Jesus xu bij chique: —¿Wach xu bij i mam Moises ujer chi qui ʼano? ");
INSERT INTO acr_acc_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ique xqui bij: —I mam Moises u yom can chake chi jun achi xa cu tzʼibaj jun wuj y cu ya che i ixok, jachbal-re —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Teʼuri i Jesus xu bij: —I mam Moises xu ya ile chiwe xa rumal n-quiwaj ta qui ʼan pacha craj i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Xui-ri chu xebal ʼij sak, i Dios, are xu yijba ronojel u wach i jyub taʼaj, xak xe u ʼan i winak, “jun achi, jun ixok xe u yijba”. (Queje ile cu bij u wuj i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","“Rumal ʼuri, jun achi ʼo u chac quel cuʼ u kajaw u chuch, man cacucʼaj quib ruʼ i rixokil. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ique che queb, xa jun chʼaculaj queʼelok.” (Queje ile cu bij u wuj i Dios.) Queʼel ʼuri are i je queb, queʼelok xa je jun. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Rumal-i, i winak n-ta piquiʼab quiqui yoj ile chi u yijbam i Dios, chi xa jun u ʼanom chique —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Are xe oc pa ja, i u tijoxelab xqui tzʼonoj jubiʼ chic che, puwi i tzij-le. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Rumal-i, i Jesus xu bij chique: —Pachin jun cu jach i rixokil, we xqʼuiji ruʼ jun chic, queʼel ʼuri chi ʼo u mac i achi chuwach i Dios, xak chuwach i nabe rixokil. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Xak queje jun ixok, we cu jach i rachijil y ca qʼuiji chic ruʼ jun achi, ʼo ni u mac ʼuri chuwach i Dios, xak chuwach i nabe rachijil —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Xoʼon panok, je ʼo jujun winak xe qui cʼam li cacʼal ruʼ i Jesus, cu yabej na re u ʼab piquiwi. Xui-ri, i u tijoxelab xqui jek qui ʼatixic i je ucʼawnak i acʼalab. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","I Jesus, are xrilo, xpe roywal y xu bij chique: —Chi ya chique i acʼalab que cʼun wuʼ; me i ʼatij, man ʼo que ique che i ʼatbal tzij re i Dios, xak chique i je pacha acʼalab. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Katzij i quin bij chiwe: pachin jun, we n-cu ya ta che i Dios cu ʼat ni tzij puwi, pacha coʼon jun acʼal, lic n-coc ta ʼuri pa cu ʼat wi tzij i Dios —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Teʼuri xe u tzʼulej i acʼalab; xu ya u ʼab piquiwi conojel, y xu tzʼonoj ʼutz piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","I Jesus xu maj chubi u be; are ʼuri xcʼun jun achi paʼanem y xuqui chuwach. Xu bij che: —ʼUtz laj Mayes, ¿wach quin ʼan yin, quin rikbej na re in cʼaslemal chi n-tu qʼuisic? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","—¿Wuchac ca bij “ʼutz” chwe yin? —xu bij i Jesus—. N-ta jun chi ʼutz, xui Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Yet awetaʼam wach cu bij i lajuj u tzij u pixab i Dios: cu bij “Ma min awib ruʼ jun ixok chi n-awixokil taj; mat camsanic; ma ʼan elaʼ; ma bij mentir chirij jun winak; mat tʼoronic; cha cojo qui ʼij a kajaw a chuch.” Ile awetaʼam chic —xu bij i Jesus che i achi. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","—Mayes, ronojel ile ʼis quin tijin chu ʼanic; in jekom na lok cʼa are in chʼutin —xu bij i achi che. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","I Jesus xu maj u takexic i achi; lic cʼax xu naʼo. —Cʼo ni rajwaxic chawe —xu bij—: niʼpa i ʼo awuʼ, ja cʼayij, ca tobej que i nibaʼib. Ca rik na ʼuri a beyomal chicaj. Teʼuri chat petok y chat terej chwij, tupu cat cam na rumal —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Are xu ta i achi ile, lic xoc ʼil, y ca bisonic xa ʼec, man ire lic beyom. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Teʼuri i Jesus cʼula xe u tzu u tijoxelab, y xu bij chique: —I beyomab, cʼax coquic puʼab i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","I u tijoxelab, are xqui ta ile, lic xqui bisoj. Are ʼuri i Jesus xu bij chic chique: —Ix wacʼal, niʼpa i qui cubam qui cʼux che i qui beyomal, cʼax coquic ʼuri pu ʼatbal tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Cʼax u ʼanic chi jun beyom cu jach rib puʼab i Dios; cʼax ile chuwach i ricʼawic jun camey che i tel re acuxa —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","I u tijoxelab, are xqui ta ile, lic xqui bisoj. Teʼuri xe oc chu chʼobic chiquiwach: —¿Pachin quelsax na ʼuri chupam u mac? ");
INSERT INTO acr_acc_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","I Jesus xu maj qui takexic y xu bij chique: —I winak n-que tiqui ta chu ʼanic ile, xui-ri, i Dios ca tiqui che; ire, ronojel ʼis ca tiqui che —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Are ʼuri i ma Pédro xu bij che: —Kajwal, yoj, ronojel niʼpa i ʼo kuʼ xka canaj canok y oj terejnak chawij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","I Jesus xu bij chique: —Katzij i quin bij chiwe, pachin croʼtaj can u bitak-re wumal yin, nim na cu chʼac puwi ile. We ʼo jun cu canaj can i rachoch, xak i rulew, xak i ratz u chaʼ, xak u chuch u kajaw, xak i rixokil ralcʼwal, xa wumal yin, xak rumal u paxsaxic u tzij i Dios, ");
INSERT INTO acr_acc_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ʼo ni cu chʼac ʼuri woʼor chuwach i jyub taʼaj, xak ʼo ni cu chʼaco coʼon panok. Ca yaʼ na ʼuri jun ciénto che, puwi ile chi xa jun ʼo ruʼ; we are i rachoch xu canaj canok, we are i ratz u chaʼ, we are u chuch, we are i racʼal, we are i rulew xu canaj canok, ca yaʼ na chic jun ciénto puwi; xui-ri, xak cu tij uyej cumal i winak. Péro n-ta coʼono, man coʼon panok, ʼo ni u cʼaslemal chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Xui-ri, niʼpa i je ʼo pa nabeal, je qʼui na que canaj can pa qʼuisbal-re; xak je qʼui chi woʼor je ʼo pa qʼuisbal-re, are ique que nabeaj na —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Je ʼo pa be, ʼelic bi que pa Jerusalen, i Jesus nabe chiquiwach u tijoxelab. Ique lic xqui bisoj che, wach ca tijin chu ʼonquil, chi ca ʼe pa Jerusalen; lic qui xim quib xe terej bic. I Jesus xe u siqʼuij juyac chic i cablajuj u tijoxelab ruʼ. Xoc ʼuri chu bixquil chique wach i cʼax quicʼaw wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","—Yix iwetaʼam ya xka maj bi ka be pa Jerusalen. Are coj upon chila, yin chi in Achi aj Chicaj, quin jachtaj na piquiʼab i cajʼatzil i sacerdóte, tak piquiʼab i tijonel re i ʼatbal tzij re i mam Moises. Quiqui ʼat na tzij pinwi, y quiqui bij na chi ʼo u chac quin camsaxic, xak quin qui jach na piquiʼab i ne te aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Quin yoʼyax na, quin qui chʼay na, xak quiqui chubaj qui cʼaxaj chwe, xak quin camsax na. Xui-ri, churox ʼij quin walij che i camic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Teʼuri i ma Jacóbo, i ma Wan chi je u cʼojol i mam Zebedéo, xe tejeb ruʼ i Jesus. —Mayes —xqui bij che—, caka tzʼonoj jun pawor chawe —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","—¿Wach quiwaj quin ʼan chiwe? —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ique xqui bij che: —Are at ʼo chic che a ʼatbal tzij, chi nim u ʼij u chomal, cakaj yoj ca ya chake coj qʼuiji ni jujun pa tak a tzal: jun pa wikabim, jun pa moxim —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","—Yix n-iwetaʼam taj wach qui tzʼonoj —xu bij i Jesus chique—. ¿Quix tiqui yix chu chʼijic i cʼax, pacha i cʼax quin icʼaw wi yin che? ¿Quix tiqui yix chu chʼijic uyej pacha uyej quin icʼaw wi yin? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","—Coj tiquiʼic —xe cha ique. I Jesus xu bij: —Katzij, yix quix icʼaw na chupam i cʼax-le; xak qui tij ni uyej-le, pacha quin icʼaw na wi yin. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Xui-ri, n-pinʼab ti yin ʼo wi u bixquil pachin que cubi pin wikabim, xak pin moxim. Ca yaʼ ni-le chique pachin u chʼobom i Dios cu ya chique —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","I je lajuj chic u tijoxelab, are xqui ta qui tzij i ma Jacóbo i ma Wan, xpe coywal chiquij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Are ʼuri i Jesus xe u siqʼuij ruʼ y xu bij chique: —Iwetaʼam yix, niʼpa i je ʼatol tzij piquiwi i tinimit, quiqui ʼan che quib pacha je rajaw piquiwi; xak i winak chi nimak qui patan que rajawin piquiwi i cach winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Xui-ri, yix n-ix ta queje ile. Are i qui ʼan ni yix, pachin craj queʼelok nim u ʼij, cha chacun ʼuri chiquij i rachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Pachin craj cu ya rib chu nabeal, chu ʼana ʼuri che rib pacha mocom chiquij conojel. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Queje chi ʼana ile, man i Achi aj Chicaj mi te ne ire xcʼun chu tzucuxic pachin ca chacun chirij; xcʼun ire pacha mocom chiquij conojel; xcʼun chu yaʼic rib che i camic, tojbal re i quelbal pa cʼax i je qʼui —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Cʼa que tijin qui ʼenam pa Jerusalen, xe icʼaw pa Jerico. Are ca tijin quelic i Jesus cuʼ u tijoxelab, je qʼui i winak je teren chiquij. ʼO jun mawach, ma Bartiméo u bi, chi u cʼojol i ma Timéo; ire cul pa be, ca tijin chu tzʼonoxic u mer chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Are xu ta chi are i Jesus aj Nazaret chi ca tijin ricʼawic, ire xsiqʼuin chu bixquil: —¡Kajwal Jesus! ¡Yet chi at umuk uxiquin can i mam David, chawila toʼbal in wach! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Je qʼui i winak xe yajawic man cacaj cu mayij siqʼuinic, xui-ri, ire xa xu cowij u bixquil che i Jesus: —¡Yet chi at umuk uxiquin can i mam David, chawila toʼbal in wach! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","I Jesus, are xu ta, xtacʼ canic y xu bij: —Chi siqʼuij. Teʼuri xqui siqʼuij i mawach y xqui bij che: —Cha cowij a cʼux. Chat walijok man ire cat u siqʼuij —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Juntir xu cʼak bi i cʼul u licʼom chirij, y xsacʼlin chicaj. Teʼuri xtejeb pan ruʼ i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","I Jesus xu tzʼonoj che: —¿Wach cawaj quin ʼan chawe? I mawach xu bij che: —Mayes, cwaj yin quin a tzunsaj —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","I Jesus xu bij che: —ʼUtz cat ʼec; ya xat utziric, man xa cuba a cʼux chwe —xu bij. I mawach juntir xtzunic, y xterej bi chirij i Jesus pa be. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ique, ya nakaj chic je ʼo wi pa Jerusalen; ya xe upon che i queb aldéa Betfage y Betánia, chi je ʼo chuwach i ral jyub Olívos. Are ʼuri i Jesus xe u siqʼuij queb u tijoxelab ruʼ y xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","—Jix che i aldéa-le chi ʼo chakawach; are quix uponic, qui rik ni jun buru yukul chila, chi cʼa maja cretamaj ca ʼan winak chirij. Chi toro y chi cʼama lok. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","We ʼo jun ca tzʼonow chiwe wuchac quix tijin chu toric, chi bij che chi cu rik u chac che i Kajwal y weʼ col u ya chic, chix chok che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ique xe ʼec, xe qui rika i buru yukul pa be chuwach jun ja, y xe oc chu quiric. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Je ʼo jujun xe ʼilawic, y xqui bij chique: —¿Wach quix tijin chu ʼanic? ¿Wuchac qui tor i buru? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Are ʼuri xqui bij chique pacha u bim bi Jesus chique ique; teʼuri xyaʼ li chique chi xqui cʼam li buru che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Are xe uponic, xqui coj qui ʼuʼ chirij, teʼuri xa ʼan i Jesus chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Je qʼui i winak xqui rip qui ʼuʼ pa be, xak je qʼui chic xqui cʼatzij u xak cheʼ y xqui coj pa be, wikbal-re. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Je qʼui i winak je nabe chuwach i Jesus, xak je qʼui je teren li chirij; conojel xe siqʼuin chu bixquil: —¡Hosánna! (¡Nim u ʼij i Dios!) —xe cha—. ¡Chu ya ni ʼutz i Dios puwi i Jun-i chi u takom li kuʼ! ");
INSERT INTO acr_acc_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Cʼamori che i Dios! Ya ca jekan u ʼatbal tzij chi coʼon ni Jun-i, chi u muk u xiquin can i ka mam, mam David. ¡Chocsax u ʼij i Dios! (Queje ile xe siqʼuin chu bixquil.) ");
INSERT INTO acr_acc_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Queje ile i roquic i Jesus pa Jerusalen. Are ʼuri xoc ire pa rachoch i Dios chila. Are xoc paja, cʼula xtzunic, y xtzalij chalok man ya xkaj i ʼij. Teʼuri xa ʼe chic pa Betánia cuʼ i cablajuj u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Chucab ʼij, are xe tzalij chali pa Betánia, i Jesus xpe numic che. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Are ʼuri xril jun u cheʼlal hígo. Tupu cʼa maja cu rik i tiémpo ca wachinic, chi naj panok xrilo chi chom chic u xak; rumal-i, xa ʼe i Jesus chi rilic we ʼo chic echaʼ che. Xui-ri, ile n-ta echaʼ che, toʼ u xak ʼolic. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Rumal-i xu bij i Jesus che: —Queʼe ʼij chawij, mi jun col u tija chic jun rechaʼ chawe —xu bij che i cheʼ. I u tijoxelab xak xqui ta wach xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Teʼuri xe upon pa Jerusalen. I Jesus, are xoc pa rachoch i Dios, xoc li chi quelsaxic niʼpa i aj cʼayinel xak i aj loʼonel je ʼo xe ja. Xe u balʼatij qui mexa i je aj jalwachil u wach qui mer i winak. Xak queje xoʼon che i qui tem i je aj cʼay palomax. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Xak xe u ʼatij i winak chi n-cacaj ta quiqui sutij i qui be chirij i rachoch i Dios; xa que icʼaw chu nicʼajal uwaja ruʼ wach tak cucʼam. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Teʼuri xoc chu cʼutic chique i winak; xu bij: —I Dios, chupam u wuj u bim can i tzij-i: “I wachoch, lic jun ja re qui tzʼonbal i winak chwe, i winak aj pa tak tinimit re ronojel u wach i jyub taʼaj.” Queje ile u bim i Dios, xui-ri, yix i ʼanom qui jul iliʼomab che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","I cajʼatzil i sacerdóte xqui ta wach u ʼanom, xak xqui ta rason i je tijonel re i ʼatbal tzij re i mam Moises. Xe oc ʼuri chu tzucuxic wach u camsaxic quiqui ʼano. Queje ile xqui ʼano man xqui xij quib che, man conojel i winak xqui bisoj che, wach i cʼutunic ca tijin chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","I Jesus, are xoc aʼab, xel pa tinimit junam cuʼ u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Sakir chucab ʼij xe ʼe chic pa Jerusalen. Are que tijin chi be, xe icʼaw pa ʼo wi i u cheʼlal hígo. Xquilo chi lic chakijnak chic i cheʼ, camnak chic i raʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Are ʼuri i ma Pédro xcʼun chu cʼux wach u bim can i Jesus che i cheʼ-le, y xu bij che i Jesus: —Mayes, wilapeʼ. I cheʼ chi xa cʼokoj, ya chakij chic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","I Jesus xu bij: —Pachin jun ʼo u cubibal u cʼux che i Dios, ʼis ca tiqui chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Katzij i quin bij chiwe, we ʼo jun lic cul u cʼux che i Dios, we cu bij na che i nim laj jyub-i, “Chat el na chi, ja cʼaka awib pa mar”, cu bij che, i Dios coʼon na ʼuri ile che. Xui-ri, i jun, ʼo u chac lic n-ta cu bij u cʼux; ʼo u chac lic cul u cʼux che chi cril na pacha i u bim che. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Rumal-i, ʼo jun tzij quin bij na chiwe: ronojel niʼpa i qui tzʼonoj che i Dios, we lic cul i cʼux che chi yatal chic chiwe, ile lic quiwil na. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Are quix tijin chu tzʼonoxic che i Dios, we ʼo jun u ʼanom mal chiwe, chi cuyu ni u mac che, man i Ta chicaj xak cu cuy ni i mac yix. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Man yix, we n-qui cuy ti qui mac i juban, xak i Ta chicaj xak n-cu cuy ta i mac yix —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Teʼuri xe oc chic pa Jerusalen y xe oc pa rachoch i Dios. Are je ʼo chila, xe tejeb pan i cajʼatzil i sacerdóte ruʼ i Jesus, xak i je tijonel re i ujer ʼatbal tzij, xak i nimak tak mamʼib je ʼo cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ique xqui tzʼonoj che: —¿Bi chi ʼatbal tzijal ʼo paʼab chu ʼanic niʼpa ile? ¿Pachin xyaw ile chawe chi cat tijin chu ʼanic-le? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","I Jesus xu laʼ u wach chique: —Xak yin quin tzʼonoj jun tzij chiwe yix; we qui bij usucʼ chwe, teʼuri xak quin bij yin chiwe bi chi ʼatbal tzijal ʼo pinʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Chi bij chwe pachin xtakaw li ma Wan chu kajsaxic ya piquiwi i winak. ¿Are i Dios xtakaw lok? ¿O xa winak? chi bij ʼu chwe —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Teʼuri ique xe oc chu chapic quib chiquiwach puwi i tzij. Xqui bij chiquiwach: —Woʼor we caka bij chi Dios takawnak lok, ire cu bij ʼuri chake: “¿Wuchac ʼuri n-xi coj taj?” cu bij na chake. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","¿O xataba caka bij che chi winak takawnak lok? —xqui bij chiquiwach. Queje ile xqui bij, man ique quiqui xij quib chique i winak; conojel i winak cul qui cʼux che chi ma Wan lic ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Rumal-i, xqui bij che i Jesus: —N-ketaʼam taj —xe cha che. Rumal-i, i Jesus xu laʼ u wach chique: —Xak queje yin, n-quin bij ta chiwe wach i ʼatbal tzij ʼo pinʼab, chi quin ʼan tak iri —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Teʼuri i Jesus xu jek u bixquil i tijojbal tak tzij chique. Xu bij: —ʼO jun achi xu tic juban u ticon, úva ca bixic, y xu coj coral chirij. Xu yijba pa quiqui yitzʼ wi u waʼal i úva, xak xu yijba jun ral ja tacʼtic chupam i ticon, chajbal re ronojel. Teʼuri xe u coj jujun ajchaquib, je aj a média ruʼ, y xa ʼe ire naj che jun tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Are xu rik i ʼij re i cosech, xu tak li jun u mocom chu tzʼonoxic i re ire chique i raj mediant. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Are xuponic, ique xqui chapo, xqui chʼayo, y xqui tzalijsaj chubic, n-ta xqui ya bi che. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Teʼuri i rajaw xu tak chal jun chic u mocom. Are xupon ire, xqui coj abaj che, xqui soc u jolom, y xqui yoʼya. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","I rajaw xu tak chal jun chic u mocom; ire lic xqui camsaj. Teʼuri xe u tak chal juban chic, je qʼui. ʼO jujun chique xqui ʼan cʼax chique; xak ʼo i xe qui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Xeʼelok, n-ta chic que u tako, xui-ri cʼo jun, ile are u cʼojol chi lic cʼax cu naʼo. Xu bij ire, “Woʼor quin tak bi wacʼal cuʼ; que cojon na ʼuri che in cʼojol”, xu bij; y pa qʼuisbal-re, xu tak bi cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Xui-ri, are xquil u cʼojol i rajaw ulew, xqui bij chiquiwach: “Ire-le are i rajaw ulew coʼon panok”, xe cha. “Chaka camsaj, y yoj coj canajic oj rajaw”, xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Are ʼuri xqui chapo, y xqui camsaj, y xqui cʼak bi u chʼacul rij coral —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Teʼuri xu tzʼonoj chique: —¿Wach coʼon i rajaw ulew ʼuri? Ire ca cʼunic, y que u camsaj i ajchaquib chi je ʼo chuwach ulew; teʼuri cu ya i ulew piquiʼab juban chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","¿Xataba n-iwilom taj wach i tzʼibtal can chupam u wuj i Dios? Queje iri tzʼibtalic: I abaj chi n-xcaj ti je aj ʼanol cimiénto re ja, are i abaj-le chi xeʼelok lic nim ni u chac. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Are i xeʼelok-le, are i Kajwal Dios xa ʼanawic, y cakil yoj, lic ʼutz ile chi u ʼanom ire. Queje ile tzʼibtal canok —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","I nimak tak mamʼib, are xqui ta ile, laj xqui cʼam bi pa cárcel, man xqui ta ique chi u tzij i Jesus-le lic cojbal qui mac ique. Xui-ri, xqui xij quib chique i winak, rumal-i, xqui canaj canok, y xe ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Xoʼon panok, ʼo jujun aj Fariséo, xak jujun aj u partído i ma Heródes, je taktal bi ruʼ i Jesus, que qui cʼambej u pam, tzaksabal re cacaj ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Are xe upon ruʼ i Jesus, xqui bij i tzij-i che: —Mayes, ketaʼam chi yet, wach i ca bij, lic sak laj tzij, man yet lic n-ca ʼan ta cas che, wach quiqui bij i winak chawij. Lic n-ta awe che, wach u patan jun winak, we nim, o we n-nim taj, lic ca bij i sak laj tzij che wach craj i Dios. Cha bij ʼu chake, ¿ʼutz nawi caka toj impuésto che i ʼatol tzij pa Róma, o n-ʼus taj? I ujer ʼatbal tzij, ¿cu ya nawi chake caka tojo, o n-taj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Péro i Jesus retaʼam chi xa cʼambal u pam quiqui ʼano. Xu bij chique: —¿Wuchas qui tzucuj tzaksabal we? —xu bij—. Chi cʼama li jun sak pwak, y chi cʼutu chwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Xqui cʼam lok y xqui cʼut che. Are xrilo, i Jesus xu tzʼonoj chique: —¿Pachin u qʼuexwach iri ʼo chuwach? ¿Pachin u bi iri tzʼibtal chuwach? —xu bij. —Re i ʼatol tzij —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Are ʼuri xu bij i Jesus: —Chi ya che i ʼatol tzij wach ʼo re ire che; xak chi ya che i Dios wach ʼo re ire che —xu bij chique. Ique lic xqui bisoj che, wach i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Xoʼon panok, xe upon juban aj Saducéo ruʼ i Jesus. I aj Saducéo, ique quiqui bij chi i camnak n-que walij ta chic. Rumal-i xqui bij i tzij-i che i Jesus: ");
INSERT INTO acr_acc_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Tijonel, u tzʼibam can i mam Moises, we ʼo jun achi xcamic, we ʼo can rixokil chi n-ta racʼal ruʼ, we je ʼo can ratz u chaʼ i achi, ʼo junok chique, ʼutz ca cʼuli ruʼ i ixok malcan man ca qʼuiji racʼal ruʼ, pu qʼuexel i achi xcamic. Queje ile u tzʼibam can i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bay, oʼonom-lok, je ʼo wukub achiab catz qui chaʼ quib. Are i ʼatz xcʼuli nabe, y xcamic, n-ta racʼal xqʼuiji canok. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","I ucab chaʼaxel xcʼuli chic ruʼ ixok malcan, y xak xcamic, xak n-ta racʼal xu canaj can ruʼ ixok. Xak queje xoʼon ruʼ urox chaʼaxel. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Queje xqui ʼan ile conojel je wukub, ʼis xe cʼuli ruʼ i ixok-le; n-ta jun cacʼal xqʼuiji ruʼ i ixok malcan. Pa qʼuisbal-re xcam i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Bay, are cu rik i ʼij piqui walijbal i camnak, are que walij niʼpa i camnak, ¿pachinok chique i wukub-le chi mer rachijil i ixok? Man conojel i je wukub-le xe cʼuli ruʼ —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Teʼuri i Jesus xu laʼ u wach chique: —Yix xa ix sachnak na. Ix sachnak, man n-iwetaʼam taj wach i tzʼibtal can chupam u wuj i Dios, xak n-iwetaʼam taj wach i nim laj u choʼab i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","I camnak, are que walij na, queʼelok je pacha i ángel chi je ʼo chicaj; n-que cʼuli taj. I achiab, i ixokib n-que cʼuli ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","I qui walijbal i camnak, katzij ʼolic. ¿Xataba n-iwilom ti yix chupam i wuj chi u tzʼibam can i mam Moises wach xu bij i Dios che? I Dios, are xu ʼijla i mam Moises chupam i ʼaʼ chi ca juluw che i ral cheʼ, xu bij che: “Yin cʼa in u Dios i mam Abraham, xak i mam Isaac, xak i mam Jacob”, xu bij che. I oxib-le je camnak chic are xu bij i Dios ile. Bay, chuwach i Dios, cʼa je cʼas na; ");
INSERT INTO acr_acc_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","I Dios n-are ti qui Dios i je camnak, are i qui Dios i je cʼaslic —xu bij i Jesus chique—. Yix, ʼut, xa ix sachnak na. (Queje ile xu sakij chique chi ʼo ni qui walijbal i camnak.) ");
INSERT INTO acr_acc_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Chila xak ʼo jun mayes re i ujer ʼatbal tzij. Ire ʼis xu ta ile chi xu bij i Jesus chique i aj Saducéo. Xu ta chi Jesus ʼis ʼutz u laʼic u wach xu ʼano. Rumal-i, xtejeb pan ruʼ, y xu tzʼonoj jun tzij che. Xu bij: —I lajuj u tzij u pixab i Dios, ¿pachique chique mas ʼo u chac coj cojon che? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","I Jesus xu bij che: —I jun chique chi mas ʼo u chac are i jun chi queje iri cu bij: “Chitapeʼ, ix aj Israel, i Kajwal Dios, xui ire i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Cʼax cha na i Awajwal Dios ronojel a cʼux, ronojel awanima, ronojel a nojbal, ronojel a choʼab”, cu bij. Are i jun-le chi mas ʼo u chac quix cojon che —xu bij i Jesus che—. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Teʼuri i ucab tzij (chi ʼo u chac coj cojon che) laj cumaj i jun-le: “Cʼax che a na a loʼcʼanij pacha cʼax u naʼic awib yet ca ʼano”, cu bij. N-ta chic jun chic chiquixol i lajuj tzij pixab nim ni u ʼij chuwach i queb-le —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Teʼuri i tijonel re i ujer ʼatbal tzij xu bij: —Lic ʼutz i xa bij, Mayes. Lic katzij i xa bij chi xa jun i Dios, n-ta chic jun chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","We cʼax caka na i Dios ronojel ka cʼux, ronojel i ka nojbal, ronojel i kanima, ronojel i ka choʼab, xak we que kaj i kach loʼcʼanij pacha cakaj kib yoj, niʼpa tak ile mas ʼutz chuwach u poroxic tak chicop chuwach i Dios, xak u sujuxic tak sipon chuwach ire —xu bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","I Jesus xu ta chi lic ʼo u noʼoj niʼpa i xu bij, rumal-i xu bij che: —Yet, xa jubiʼ chic craj ca jach awib che u ʼatbal tzij i Dios —xu bij che. Teʼuri, mi jun xu cowij chic u cʼux chu tzʼonoxic mas tzij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Xoʼon chupan jubiʼ, i Jesus ca tijin chu cʼutic chique i winak pa rachoch i Dios. Xu bij chique: —I je tijonel, re i ujer ʼatbal tzij, ¿wuchac quiqui bij chi i Tolque coyʼem, are na jun umuk uxiquin i mam David? ");
INSERT INTO acr_acc_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","¿Wuchac quiqui bij ile? man lic are i mam David u bim can i tzij-i: Xu bij i Kajwal Dios che i Wajwal Crísto: “Chat cul na pin wikabim cʼa cu rik ni ʼij que in ya na pawakan niʼpa i aj chʼoʼoj chawij”, xu bij. Queje ile u tzʼibam can i mam David ujer, y are u Tewal i Dios yawnak pu jolom chi xu bij i tzij-le. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Wach u ʼonquil ʼuri chi i Crísto xa umuk uxiquin i mam David? ¿Wach u ʼonquil ile, man lic are i mam David xu bij “Wajwal” che i Crísto? —xcha. I uqʼuial winak je ʼo chila lic que quicot chu tayic. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","I Jesus, are ca tijin chu cʼutic chique, xe u pixbaj ruʼ tak i tzij-i: —Chi ʼana cwent chique i tijonel re i ujer ʼatbal tzij chi xa kus quiquilo que malcat pa tak be ruʼ qui ʼuʼ naj rakan; xak kus quiqui ta are ca yaʼ rutzil qui wach cumal i winak, ocsabal re qui ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Are que oc pa ja re i molbalʼib, xa quiqui tzucuj qui cubibal chi ʼo u ʼij; are que ʼe pa waʼim re tak nimaʼij, xa quiqui tzucuj qui qʼuijibal ʼo u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Xak quiqui maj i cachoch ixokib malcanib; teʼuri nim i oracion quiqui ʼan chiquiwach i winak, sachsabal-re chique wach qui ʼanom. Ique ʼut, ca yaʼ jun tojpen chique lic nim na u tojic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","I Jesus cul pa rachoch i Dios chuwach li caxa, yabal re qui mer i winak. Are ʼo chila, que u takej i winak are que tijin chu yaʼic qui mer pa caxa. Je qʼui i beyomab, mas i mer xqui yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Are ʼuri xupon jun ixok malcan lic nibaʼ, xu ya queb u mer chi n-ta kas rajil. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Teʼuri i Jesus xe u siqʼuij u tijoxelab ruʼ, y xu bij chique: —Katzij i quin bij chiwe, i ixok nibaʼ-i, i u mer xu yaʼo, mas nim chuwach ile chi qui yom conojel i juban pa caxa. ");
INSERT INTO acr_acc_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Ique, wach i qui yom, xa are quesam che wach i sobrinak cuʼ; xui-ri, i ixok-le, chi lic nibaʼ, ronojel xu yaʼo, niʼpa i ʼo ruʼ; n-ta chic xu canaj re u cʼaslemal —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Are xel i Jesus pa rachoch i Dios, ʼo jun chique u tijoxelab xu bij che: —Mayes, chawila tak i ja-ri re i rachoch i Dios, ¡lic chom! ¡Chawila i abaj ʼo che, lic chomik! ");
INSERT INTO acr_acc_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","I Jesus xu laʼu wach che: —¿Cawil yet niʼpa tak iri lic chom? Ronojel iri ca wulijsax na. Mi jun abaj ca canaj chic puwi i rachiʼil —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Teʼuri ique xe ʼel bi chuwi jyub Olívos chi ʼo chuwach i rachoch i Dios; chila xcubi wi i Jesus. Are ʼuri je cajib i u tijoxelab xe tejeb pan ruʼ. Je are i ma Pédro, i ma Jacóbo, i ma Wan, i ma Andres. Quituquel xe ʼe chu tzʼonoxic che, aliʼal: ");
INSERT INTO acr_acc_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","—¿Umpa cakil ile chi xa bij? ¿Wach i retalil ca yaʼ chake we ya mer cakil ronojel ile? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","I Jesus xu bij chique: —Chi ʼana cwent iwib, mokxa ʼo quix qui tʼoro. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Man je qʼui que cʼun na, quiqui bij na chi “Yin in i Toliwe”, que cha. Cumal ique-le je qʼui que tʼortaj na. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Yix, are qui ta rason we ʼo nimak tak chʼoʼoj jela, we ʼo nimak tak chʼoʼoj jewa, mix cʼachir rumal; ʼo ni u chac queje ile ca ʼantajic; xui-ri, are qui ta i tzij-le, maja na ca cʼun i qʼuisbal re tak i ʼij-i. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ʼO ni tinimit quiqui ʼan chʼoʼoj che chic jun tinimit; ʼo ni winak re jun ʼatol tzij quiqui ʼan chʼoʼoj chiquij i winak re chic jun ʼatol tzij. Xak i nimak tak ucabrakan xa ipa quicʼaw wi, xak queje i waʼjal; xak queje i chʼokowic, xa ipa ca ʼan na wi. Niʼpa ile xa are jekbal re i cʼax chi ca petic. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Chi na iwib yix, man ʼo ni winak quix qui cʼam bi chiquiwach i ʼatbal tzij; quiqui jic i loʼxic pa tak qui molbalʼib. Quix siqʼuix na chiquiwach i gobernador, xak chiquiwach i nimak tak ʼatol tzij xa wumal yin. Xui-ri, queje ile quix tiqui na chu bixquil chique wach iwilom, wach i tom, wach iwetaʼam chwij yin. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ʼO u chac ca paxsax ni ʼutz laj tzij re i Dios chique conojel i tinimit chuwach i jyub taʼaj, are cʼa maja ca cʼun i qʼuisbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Are quix qui chapo, yabal na iwe chiquiwach i ʼatbal tzij, mix cʼachir che, wach qui bij na chiquiwach, xak mix oc chu chʼobic. Xui chi bij na wach cu ya i Dios pi chiʼ are ix ʼo chiquiwach, man n-are ti yix quix nojiw u bixquil, xa are u Tewal i Dios ca binic. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ʼO ni jujun que qui jach ni catz qui chaʼ piquiʼab i je aj chʼoʼoj chiquij, camsabal na que; xak je ʼo ni kajawxel queje quiqui ʼan cuʼ i cacʼal. Xak queje i acʼalab, quiqui ʼan che quib je aj chʼoʼoj chiquij i qui kajaw i qui chuch, que qui jach na chique i que camsawic. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Conojel i winak tzel quix quil na xa wumal yin; xui-ri, pachin i cu chʼijo cʼa pa qʼuisbal re u chac, quelsax na ʼuri pa cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","I ajbil u tzij i Dios, mam Daniel, u tzʼibam canok wach ca cʼunic: xu bij ire chi cocsax na jun tzel laj kajsabal re u ʼij i rachoch i Dios che i lugar chi n-ca majaw ta che. Are quiwil yix ile tacʼal chila, niʼpa i je ʼo pa jyub. Niʼpa i cacajlaj i tzij-i, chiqui ta usucʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Chupam i ʼij-le, suʼ chix ʼanmajok. Niʼpa je ʼo ʼan puwija re i cachoch, suʼ che kaj la lok; me oc chic chupam, quiqui cʼambej re ubitak-que. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Xak niʼpa i que tijin chi chac pa tak ticon, me tzalij lok col qui cʼambej re qui ʼuʼ; ¡paʼanem che ʼanmajok! ");
INSERT INTO acr_acc_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Chupam i ʼij-le, toʼ qui wach ixokib chi ʼo i yobil chiquij, xak ique chi ʼo cacʼal chi cʼa que tzʼumanic; cʼax i qui ʼanmajic ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Chi tzʼonoj che i Dios chi n-joron ti tew are quix ʼanmaj chuwach ile, ");
INSERT INTO acr_acc_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","man i uyej che tak i ʼij-le, lic cʼax. Cʼa chu xebal ʼij sak, are xu yijba i Dios i jyub taʼaj, n-ta jun cʼax petnak lic cʼax chuwach ile; xak n-ta chic jun chic ca petic, lic cʼax chuwach ile. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Y we i Kajwal n-coʼon ta che, chi xa ʼatal ʼij ʼo ni cʼax-le, ʼis que cam na conojel. Xui-ri, ire u chʼobom chi cu ʼatij na; queje coʼon ire ile, xa rumal i cʼaxnabal u cʼux chique i je re ire, chique i je u chom ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Rumal-i, che tak i ʼij-le, we ʼo i que bin chiwe: “Chiwilapeʼ, chi ʼo wi i Tolke”, que cha, mi cojo; o we xak quiqui bij: “Le i ʼolic-le”, que cha, mi cojo. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Man que cʼun ni aj tʼoronel chi quiqui ʼan che quib pacha je toliwe, xak que cʼun jujun quiqui ʼan che quib pacha je ajbil u tzij i Dios. Quiqui ʼan ni milágro, xak i nimak tak ʼanic, ʼilbal-re we que tiqui chi qui tʼoric niʼpa i je re i Dios, chi je u chom ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Chi na iwib! Ya in bim chic ronojel chiwe, wach i qui cʼulmaj coʼon panok. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Are quicʼaw i ʼij re niʼpa i cʼax-le, teʼuri i ʼij ca ʼekumaric, xak i icʼ n-ca tzun ta chic, ");
INSERT INTO acr_acc_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","xak i chʼumil que tzak na li chicaj, xak wach tak ʼo chicaj ca sicsax na. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Are ʼuri quiwil ni Achi aj Chicaj; ca cʼun pa sutzʼ ruʼ i nim laj u choʼab, nim laj u chomal. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Que u tak bi u ángel cʼa pa que ʼel wi li i cajib tew cʼulala, quiqui molbej-que niʼpa i je u chom i Dios, lic ronojel u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Yix iwetaʼam wach i séña cu cʼut u cheʼlal hígo are ya ca cʼun i ʼalaj. Chix naw che i cheʼ-le. Ile, are quiwilo ca pe tan chic u tux, y coʼon rax, iwetaʼam ʼuri ya ca miʼ tan chic i ulew. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Queje queʼel tak ile, chi cʼa te xin bij chiwe. Are quiwil yix niʼpa tak ile, chi ta u be ʼuri ya ca pe i qʼuisbal re tak i ʼij-i, ya jekanic coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Katzij i quin bij chiwe, ya ca cʼun ronojel niʼpa in bim-le; ca ʼantaj na, are maja que cam i winak re i woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","I caj, i ulew, ca sach na; xui-ri, in tzij yin n-ca sach taj; coʼon na ronojel niʼpa in bim chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Xui-ri, mi jun retaʼam pachique ʼij, pachique ʼor, coʼon ile. Xak mi ne i ángel aj chicaj, xak mi ne yin chi in u Cʼojol i Dios n-wetaʼam taj; xui i Ta chicaj retaʼam. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Xui-ri, yix chix cʼascʼatok, chi cʼacʼalij, y mi mayij i tzʼonoxic che i Dios, man n-iwetaʼam taj wach oʼonom ʼor que u rika. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Queʼelok pacha jun achi chi ya ca ʼec, naj ca ʼe wi. Que u pixbaj i rajchaquib chi que chajiw can i rachoch. Chi qui jujunal ʼis cu ya can qui chac, xak i aj chajal ja, cu bij can che chi ca cʼascʼat na chu chajixic. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Xak queje chi ʼana yix ile, chix cʼascʼatok, man n-iwetaʼam taj wach oʼonom ʼor ca cʼun i rajaw ja. N-iwetaʼam taj we coc aʼab ca cʼunic, o we tiqʼuil aʼab, o are ca chʼaw i acʼ, o we are quel li ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Mok xak teʼet ca cʼunic, y quix u riko xa quix waric. ");
INSERT INTO acr_acc_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Wach i quin tijin chu bixquil chiwe, xak quin bij chique conojel: “¡Chix cʼascʼatok!” (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Xa queb ʼij chic craj cu rik i nimaʼij páscua, iʼij chi ca tijaw wi i caxlanwa chi n-ta cunbal ocnak che. I je cajʼatzil i sacerdóte, xak i je tijonel re i ujer ʼatbal tzij, quiqui tzucuj wach i tzaksabal re i Jesus quiqui ʼano, chapbal na re aliʼal, xa camsabal-re. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Xui-ri, xqui bij chiquiwach: —Maka ʼan ile pa nimaʼij, mokxa que chʼokow i uqʼuial winak rumal —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","I Jesus ʼo pa aldéa Betánia ruʼ rachoch i achi Simon, chi “Lepróso” ca bix che. Are que tijin chi waʼim, xoc bi jun ixok cuʼ. Ire rucʼam jun chom laj baxo, nojnak che acéite lic muy, lic pakal rajil. I acéitele, ʼantal che i cotzʼij, “nárdo” u bi. Xu ʼaj u tzam i baxo, y xu jam i acéite che u jolom i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ʼO jujun je ʼo chila xpe coywal; xqui bij chiquiwach: —¿Wuchac queje xoʼon ile che i cunbal muy, chi toʼ xsachic? —xqui bij—. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Are i rajil ile, mas che oxib ciénto quetzal; mas ʼutz we ta xcʼayixic, cu tobej que i nibaʼib —xqui bij. Y xa que chʼachʼat chirij ixok. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Péro i Jesus xu bij: —Coʼon ile. ¿Wuchac quix chʼachʼat chirij? Ile chi xoʼon ire chwe, lic ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","I nibaʼib, queʼe ʼij sak je ʼo na iwuʼ; we quiwaj que i to, pachique ʼij ʼis ʼutz. Xui-ri, yin, n-ronojel ta ʼij in ʼo iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","I ixok-i xoʼon chwe niʼpa i xtiqui che. Are cʼa maja cu rik i ʼij, xu coj i cunbal muy re i mukbal re in chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Katzij i quin bij chiwe, xa ipa ca paxsax wi i tzij re i ʼelsabal re qui mac i winak, xak ca tataj ni rason wach u ʼanom i ixok-i chwe. Queje coʼon ile ronojel u wach i jyub taʼaj, cʼunsabal re i ixok-i chi qui cʼux i winak —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Teʼuri i ma Júdas Iscarióte, jun chique i cablajuj u tijoxelab, xa ʼe cuʼ i je cajʼatzil i sacerdóte, chu sujuxic i Jesus piquiʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Ique, are xqui ta, lic xe quicotic, y xqui bij che chi quiqui ya mer che. Teʼuri i ma Júdas xoc chu tzucuxic wach u jachic i Jesus coʼon piquiʼab ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Xcʼun i nabe ʼij re i nimaʼij chi ca tijaw wi i caxlanwa chi n-ta cunbal che. Are i ʼij-le chi que camsax ni ral tak chij re i ni-maʼij páscua. Chupam i ʼij-le, i u tijoxelab i Jesus xqui bij che: —¿Pa cawaj wi yet caka yijba wi i a waʼim re i nimaʼij páscua? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ire xe u tak bi queb chique chu yijbaxic. Xu bij chique: —Jix pa tinimit. Chila qui cʼulaj wi jun achi rekam jun ʼekbala ʼo ya chupam. Chix terej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Pa coc wi ire ruʼ ja, chi bij iri che i rajaw ja chila: “Cu bij li ka Mayes, ¿Pa ʼo wi i cuárto pa quin tij wi i waʼim re i páscua cuʼ in tijoxelab? xu bij lok”, chix chok che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Teʼuri ire cu cʼut jun nim laj cuárto chiwe, cʼa pu caleja, yij chic; chila chi yijba wi ka waʼim yoj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","I u tijoxelab xe ʼec; are xe upon pa tinimit ʼis xqui riko pacha u bim i Jesus chique. Teʼuri xqui yijba i waʼim re i nimaʼij páscua. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Are xoc aʼab xupon i Jesus cuʼ i cablajuj u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Are je ʼo chi mexa, que tijin chi waʼim, i Jesus xu bij chique: —Katzij i quin bij chiwe, ʼo jun chiwe yix, ca tijin chi waʼim wuʼ, chi quin u jach na piquiʼab i je aj chʼoʼoj chwij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ique, are xqui ta ile, lic xe oc chi bis. Chi qui jujunal xe oc chu tzʼonoxic che: —¿Mokxa yin? Y xak xu bij jun chic: —¿Mokxa yin? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","I Jesus xu bij chique: —Are jun chiwe yix ix cablajuj, jun chi cu mu u wa pa lak wuʼ yin. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Katzij, yin chi in Achi aj Chicaj, quin camsax na, pacha tzʼibtal can chupam u wuj i Dios. Xui-ri, toʼwach i achi chi quin jachaw na piquiʼab i aj chʼoʼoj chwij. Mas ʼutz queʼel che i achi-le ma ta xalaxic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Are que tijin chi waʼim, i Jesus xu chap i caxlanwa y xu tioxij che i Dios, teʼuri xu piro. Xu ya chique u tijoxelab y xu bij chique: —Chi chapa; are iri are in chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Teʼuri xu chap i tuʼbal víno, y xak xu tioxij che i Dios. Teʼuri xu ya chique, y conojel xqui tuʼ che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Xu bij chique: Are iri are in quiqʼuel chi ca yijbaw ni trat cʼacʼ ruʼ i Dios. Ca turuw na, ʼanbal ni ʼutz chique uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Katzij i quin bij chiwe, n-quin tuʼ ta chic u waʼal úva, cʼa te tan chic quin tuʼ cʼacʼ pa cu ʼat wi tzij i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Teʼuri xqui bixaj jun bix, cojbal re u ʼij i Dios. Are xe utzinic, xe ʼe chuwi jyub Olívos. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","I Jesus xu bij chique: —Woʼor chaʼab, iwonojel yix quin iwoʼtaj na canok. Wetaʼam queje ile queʼelok, man queje iri u bim can i Dios chupam u wuj: “Quin ya na, chi ca camsax ni aj yuʼul chij”, xu bij, “teʼuri i chij que jacher bic.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Xui-ri, are in walijnak chic che i camic, quin nabeaj na chiwach pa Galiléa —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Are ʼuri xu bij i ma Pédro: —We conojel ʼis cat coʼtaj canok, yin ʼut n-cat woʼtaj taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","I Jesus xu bij chic che: —Katzij i quin bij chawe, che i aʼab-i, are maja ca chʼaw ucamul acʼ, quin awuwaj ni oxmul. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","I ma Pédro xu camulij u bixquil; xu bij chic: —Yin lic n-cat wuwaj taj, n-ta coʼono we junam awuʼ coj camic —xu bij. Xak queje ile xqui bij conojel. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Teʼuri xe ʼe chic che jun lugar, Getsemani u bi. I Jesus xu bij chique u tijoxelab: —Chix cul na can chi, tzʼakat quin ʼe yin chu tzʼonoxic che i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Teʼuri xe u cʼam bi i ma Pédro, i ma Jacóbo, i ma Wan ruʼ, y xpe jun nim laj bis, jun nim laj cʼax pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Xu bij chique: —I bis ʼo pa wanima, laj quin cam rumal, quin na yin. Chix canaj ni yix waral y chix cʼascʼatok —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I Jesus xa ʼe chupan jubiʼ, xu jupij rib pulew, y xoc chu tzʼonoxic che i Dios. Xu bij che we ta ʼo módo, craj quelsax na chuwach i cʼax chi ya cu cʼulmaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","—Ta —xu bij che—, yet ronojel ʼis cat tiqui che. Chawesaj i cʼax ʼo chinwach. Xui-ri, ma ya chwe pacha i toʼ cwaj yin; are, cha ʼana pacha i cawaj yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Teʼuri xtzalij chic cuʼ u tijoxelab, xe u riko que waric. Xu ʼijla i ma Pédro y xu bij che: —A-Simon, ¿cat waric? ¿N-xa chʼij ta bari cat cʼascʼat jun ʼor? ");
INSERT INTO acr_acc_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Chix cʼascʼat na y chi tzʼonoj che i Dios, man n-quix tzak ta chupam i mac. Katzij, yix piwanima quiwaj quix cʼascʼatic, xui-ri i chʼacul n-cu chʼij taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Teʼuri xtzalij chic ucamul chu tzʼonoxic che i Dios; xak jun chi tzij xu bij chic che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Are xtzalij chalok, xe u rik tan chic u tijoxelab que war tan chic; i qui baʼwach lic waram craj. Ique n-xqui rik taj wach quiqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Are xtzalij chal che uroxmul, xu bij chique: —Bay, chix warok; chix uxlanok. Ya coʼon ile. Ya xu rik i ʼor chi yin, chi in Achi aj Chicaj, quin jachtaj na piquiʼab i ajmaquib. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Chix walijok. Joʼ. Ya xcʼun ire chi quin jachaw na piquiʼab i aj chʼoʼoj chwij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","I Jesus cʼa ca tijin chi tzij are xupon i ma Júdas, chi jun chique i cablajuj u tijoxelab. Ire je rucʼam li uqʼuial winak; ʼo jujun cucʼam chʼichʼ, xak ʼo i cucʼam cheʼ. Ique je taktal li cumal i cajʼatzil i sacerdóte, xak i tijonel re i ujer ʼatbal tzij, xak i nimak tak mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","I ma Júdas chi aj jachanel re i Jesus u bim can chique wach i séña coʼon na chique, cʼutbal re i Jesus: —Are i jun chi quin tzʼubaj, are ile —u bim can chique—. Chi chapa, ʼutz u cʼamic bic chi ʼana —u bim chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Are xuponic, xtejeb pan ruʼ i Jesus y xu bij che: —¡Mayes, Mayes! —xu bij che. Y xu tzʼubaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Are ʼuri xqui chapo, y xqui cʼam bi chuwach i ʼatz laj sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Xui-ri, ʼo jun ʼo chila xresaj li u chʼichʼ y xresaj jun u xiquin i aj takon re i ʼatz laj sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Are ʼuri i Jesus xchʼawic; xu tzʼonoj chique i winak: —¿Wuchac xix cʼun yix ruʼ i chʼichʼ, ruʼ i cheʼ, qui cʼambej bi we, pacha qui ʼan che jun iliʼom? ");
INSERT INTO acr_acc_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ʼIj ʼij in ʼo chixol, pa rachoch i Dios, are quin tijin chu cʼutic chique i winak, y n-xin i chap taj. Xui-ri, ʼo ni u chac ca ʼan na iri chwe pacha i tzʼibtal can chupam u wuj i Dios —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Are ʼuri conojel u tijoxelab i Jesus xqui canaj canok y xe ʼanmajic. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Xui-ri, xak ʼo jun ala teren bi chirij, xui jun sawan u licʼom chirij. Ire xchaptajic. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Are xqui chapo, xu cʼak can i sawan chique y chʼanalic xa ʼanmajic. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Teʼuri xqui cʼam bi i Jesus chuwach i ʼatz laj sacerdóte. Chila xqui mol wi quib i je ajwab sacerdóte, xak i nimak tak mamʼib, xak i je tijonel re i ujer ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","I ma Pédro toʼ chi naj xterej bic, cʼa xupon chuwaja re i rachoch i ʼatz laj sacerdóte. Chila xchʼuqui wi chi ʼaʼ cuʼ i policía, cu miʼsaj rib. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","I je cajʼatzil i sacerdóte junam cuʼ i je nimak tak aj nucʼbal tʼisbal xqui tzucuj wach u cojic u mac i Jesus quiqui ʼano, camsabal-re, xui-ri, n-xqui rik taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Je qʼui xqui ʼan mentir chirij, xui-ri niʼpa i xqui bij, n-xak jun tu wach i qui tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Je ʼo jujun xe walijic y xqui bij i mentir-i chirij i Jesus: ");
INSERT INTO acr_acc_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Lic ka tom yoj chi xu bij ire chi “Yin quin wulijsaj i rachoch i Dios-i, chi qui ʼanom i winak; teʼuri churox ʼij quin yac jun chic rachoch i Dios chi n-winak ta que yacawic”, xu bij —xqui bij ique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Queje xqui ʼan ile pacha i qui chʼobom, xui-ri, n-xak ta jun u wach i qui tzij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Teʼuri i ʼatz laj sacerdóte xwalij chiquixol y xu bij che i Jesus: —¿Yet, wuchac n-ca laʼ tu wach chique? ¿Wach usucʼ ile quiqui bij chawij? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","I Jesus lic n-xchʼaw taj; n-xu laʼ tu wach. Are ʼuri i ʼatz laj sacerdóte xu jek chic u tzʼonoxic che. Xu bij che: —¿Yet nawi at Crísto, chi u Cʼojol i loʼlaj Dios? —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","I Jesus xu bij: —Katzij, yin. Xak quin iwil ni yin chi in Achi aj Chicaj, in cul na pu wikabim i Dios chi ʼatz u choʼab; xak quin iwil na are quin cʼun pa sutzʼ chicaj —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Are ʼuri, i ʼatz laj sacerdóte xu rakchʼij u ʼuʼ, cʼutbal re i roywal. Xu bij ʼuri chique i je moltajnak: —Ya coʼon ile. N-ta chic u chac we ʼo juban chic col qui bij u mac. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Ya xi ta yix u tzij, chi tzel cu ta i Dios. ¿Wach qui chʼob yix che? —xu bij chique. Ique conojel xqui bij chi ca camsax na. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Are ʼuri ʼo jujun chique xqui jek u chubaxic qui cʼaxaj che, xak ʼo i xqui tzʼapij u palaj ruʼ cʼul, y xqui chʼayo. Xqui bij che: —Cha bij pachin xat chʼayawic —xe cha che. Xak i policía xqui chʼay che u palaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Tzʼakat queje quiqui ʼan ile, i ma Pédro ʼo kaj chuwaja. Are ʼuri xcʼun jun ali chi aj chac pa rachoch i ʼatz laj sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Are xrilo chi ma Pédro ca tijin chu miʼsaxic rib chi ʼaʼ, xu cʼam u takexic y xu bij che: —Xak yet at rachiʼil i ma Jesus aj Nazaret —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","I ma Pédro xruwaj u wach: —Yin n-wetaʼam tu wach; n-quin ta tu be wach i ca bij —xu bij che. Teʼuri xu jach rib; xa ʼe pan chibe pa ʼelbal bic; are ʼuri xchʼaw jun teren. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","I ali xu takej chic ucamul, y xu bij chic chique i je ʼo chila: —I achi-ri, lic cachiʼil i juban —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","I ma Pédro xruwaj chic u wach ire. Xoʼon chupan jubiʼ, i je ʼo chila xqui bij chic che i ma Pédro: —Katzij, yet lic at cachiʼil ique-le, man at aj Galiléa, xak i a chʼawbal lic pacha ique-le —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","I ma Pédro xoc chu cuxtaxic u bi i Dios: —I Dios chin u ya na pa tojpen we n-katzij ti quin bij. Lic n-wetaʼam tu wach i achi-le, chi qui chʼachʼa chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Are ʼuri, xchʼaw ucamul acʼ. Teʼuri i ma Pédro xcʼun chu cʼux wach i bital che rumal i Jesus, man u bim che: “Are maja ca chʼaw ucamul acʼ, quin awuwaj oxmul”, u bim che. Are xcʼun chu cʼux ile, xoc che oʼej. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Are xsakiric, are ʼuri i cajʼatzil i sacerdóte xqui mol quib cuʼ i nimak tak mamʼib, xak cuʼ i tijonel re i ujer ʼatbal tzij, xak cuʼ conojel i nimak tak aj nucʼbal tʼisbal. Xqui xim i Jesus y xqui cʼam bi ruʼ i ma Piláto, y xqui jach puʼab. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","I ma Piláto xu tzʼonoj che: —¿Yet at ʼAtol Tzij que i aj Israel winak? —xu bij. I Jesus xu bij: —Are ile, pacha i xa bij yet —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","I je cajʼatzil i sacerdóte, qʼui u mac que tijin chu cojic. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","I ma Piláto xoc chic chu tzʼonoxic che. Xu bij: —¿Yet, wuchac n-ca laʼ tu wach chique? Chatapeʼ, qʼui a mac que tijin chu cojic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","I Jesus n-xu laʼ tu wach; rumal-i, i ma Piláto lic xu bisoj. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Junab chi junab, are ʼo i nimaʼij páscua, i ma Piláto ʼo puʼab croʼtaj bi jun prex, pachique cacaj i winak. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ʼO jun achi, ma Barabas u bi, ʼo pa cárcel cuʼ i rachiʼil man xqui mol qui chiʼ i winak chu ʼonquil chʼoʼoj chirij i ʼatol tzij, xak xqui ʼan i camic rumal ile. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Are xe cʼun i winak ruʼ i ma Piláto, xe oc chu tzʼonoxic che chi croʼtaj bi jun prex, pacha ʼax coʼon wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ire xu tzʼonoj chique: —¿Pachique quiwaj cwoʼtaj bic? ¿Quiwaj cwoʼtaj bi i ʼAtol Tzij yix, ix aj Israel winak? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Queje ile xu bij chique man retaʼam chi i je cajʼatzil i sacerdóte xa ca titat qui pam che i Jesus; are ne rumal-i qui jachom puʼab ire. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Xui-ri, i cajʼatzil i sacerdóte je qui tunum i uqʼuial winak, chi are i ma Barabas coʼtax bic. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","I ma Piláto xu tzʼonoj chic chique: —¿Wach i quiwaj yix ʼut quin ʼan che i jun-le chi “qui ʼAtol Tzij i aj Israel” ca bix che? ");
INSERT INTO acr_acc_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ique xe siqʼuin chu laʼic u wach y xqui bij: —¡Cha camsaj chuwach cruz! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","I ma Piláto xu bij tan chic chique: —¿Wach u mac u ʼanom? —coʼono. Ique xa xe siqʼuin tan chic: —¡Cha camsax chuwach cruz! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Teʼuri i ma Piláto xroʼtaj bi ma Barabas, man n-craj ti ire chi ca pe i coywal i winak chirij. Teʼuri xu tak u yaʼic u loʼxic i Jesus, y xu jach bi piquiʼab i que camsaw chuwach cruz. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Teʼuri i soldádo xqui cʼam bi chuwaja re i rachoch i gobernador. Chila xqui mol wi quib conojel i soldádo cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Xqui coj jun u ʼuʼ i Jesus, cakcoj ca tzunic, xak xqui coj jun sotosic qʼuix che u jolom. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Teʼuri xe oc chi sicʼ: —¡Naj u ʼij i ʼAtol Tzij que i aj Israel! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Xe oc chu chʼayic che u jolom ruʼ jun cheʼ; xak xqui chubaj qui cʼaxaj che, y xe xuqui chuwach, ʼanbal-re pacha quiqui coj u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Are xe utzin chu yoʼyaxic, xquesaj i cʼul cakcoj chi qui cojom che, y xqui coj i u ʼuʼ ire. Teʼuri xqui cʼam bic, y xe ʼe chu camsaxic chuwach cruz. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Are que tijin chi be, xqui cʼulaj jun achi aj Ciréne, ma Simon u bi, chi qui kajaw i ma Alejándro, i ma Rúfo. I achi-le cʼunic-re pa tak jyub. Are xqui cʼulaj, xqui ʼan pen che cu cʼam bi u crusil i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Xqui cʼam bi Jesus che jun ral jyub, Gólgota u bi (i usucʼ i tzij-le queʼel pa ka chʼawbal: “jyub pacha u jolom anma”). ");
INSERT INTO acr_acc_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Are ʼuri xe oc chu sujuxic víno che, chi ʼo cunbal mírra che (icʼawsabal re u cʼaxcʼol); xui-ri i Jesus n-xu tuʼ taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Teʼuri xqui rip chuwach cruz. Are ʼuri i soldádo xe oc chi saquinic chirij u ʼuʼ i Jesus, ʼilbal-re pachin ca chʼacaw bi chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Are i ʼor xqui rip i Jesus chuwach i cruz, are a las nuéve re i raʼanbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Pujaʼ ʼan i cruz xqui tzʼibaj juban tzij, ʼalijinsabal-re wach rumal xcamsaxic; queje iri cu bij i tzʼib: “ʼAtol Tzij que i aj Israel winak.” ");
INSERT INTO acr_acc_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Xak je ʼo queb iliʼomab xe rip chuwach qui cruz junam ruʼ i Jesus: jun pu wikabim, jun pu moxim. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Pacha i tzʼibtal can ujer, queje ile xeʼelok, man u bim can i ajbil u tzij i Dios ujer chi “Xqui ʼan che chi xak jun cuʼ i je aj ʼanol mal”. (Queje ile tzʼibtalic.) ");
INSERT INTO acr_acc_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Niʼpa i winak que icʼaw chila quiqui sutsa qui jolom che, y quiqui yoʼya. Xqui bij che: —Yet a bim na ca wulijsaj ni rachoch i Dios, y ca walijsaj chic churox ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Bay, ¡cha to ʼuri awib! ¡Cha kajsaj li awib chuwach i cruz! —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Xak queje xqui ʼan i cajʼatzil i sacerdóte tak i je tijonel re i ujer ʼatbal tzij; xa xqui yoʼya. Xqui bij chiquiwach: —Ire-le xe u to i juban, xui-ri n-ca tiqui ta chu toʼic rib —xe cha—. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Chu cʼutu na chake we ire are i Crísto, i ka ʼAtol Tzij yoj oj aj Israel. Chu kajsaj li rib woʼor chuwach i cruz, cu cʼutbej-re chake, teʼuri caka cojo —xqui bij. Xak i iliʼomab chi je riptal ruʼ ire, xak ique xqui yoʼya panok. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Are tiqʼuil ʼij, xa ʼekumar ronojel u wach i jyub taʼaj; xu chʼij oxib ʼor re u kajbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Teʼuri, co xchʼaw i Jesus: —Elói, Elói, ¿láma sabactáni? —xu bij. I usucʼ i tzij-i queʼelok: Wajwal Dios, Wajwal Dios, ¿wuchac in awoʼtam canok? (Queje usucʼ ile i u tzij pa ka chʼawbal.) ");
INSERT INTO acr_acc_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Je ʼo jujun chila xqui ta; ique xqui bij: —Chitapeʼ, ire cu siqʼuij i ujer ajbil u tzij i Dios, mam Elías —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Are ʼuri ʼo jun chique xa ʼe paʼanem y xu mu jun espónja chupam juban víno chʼam. Teʼuri xu chʼap tzam cheʼ, y xu ya ʼan che, man cu tzʼub-bej re. Xu bij: —Chiwoyʼej we kas ca cʼun i mam Elías chu kajsaxic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Teʼuri i Jesus co xsiqʼuinic, y xcamic. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Are ʼuri i nim laj cortin pim chi ʼo pa rachoch i Dios xel pa nicʼaj, majan li pujaʼ, cʼa pulew. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","ʼO jun qui capitan i soldádo ʼo chi, chuwach i Jesus. Ire, are xu ta wach i sicʼ xoʼon i Jesus, xak xrilo wach u camic, xu bij: —Katzij, i achi-ri, lic are u Cʼojol i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Xak je ʼo jujun ixokib que taken li cʼa naj; chiquixol ique je ʼo i ati Mariy Magdaléna, xak i ati Mariy chi qui chuch i ma Jose, xak i ma Jacóbo chi chaʼxel; xak ʼo i ati Salome cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","I ixokib-i, je terej nak li chirij i Jesus cʼa pa Galiléa, quiqui tobej na re. Xak je qʼui ixokib je ʼo cuʼ chi je upon-nak ruʼ pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","ʼO jun achi, ma Jose u bi, aj tinimit Arimatéa. Ire, nim u ʼij chiquixol i je aj nucʼanel aj tʼisanel que i aj Israel winak; ire lic craj cril u jekic i ʼatbal tzij re i Dios. Lic xu cowij u cʼux, xoc bi ruʼ i ma Piláto, y xu tzʼonoj u chʼacul i Jesus, man ya xoc aʼab re i qʼuisbal ʼij chuxeʼ i uxlambal ʼij. Are i ʼij wi chi quiqui yijba qui uxlambal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","I ma Piláto, are xu ta chi ya camnak chic i Jesus, lic xu bisoj che man lic weʼ xcamic; rumal-i xu siqʼuij i capitan y xu tzʼonoj che we katzij camnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Are xu ta wach xu bij i capitan, chi katzij, teʼuri xu ya che i ma Jose que u kajsaj li u chʼacul i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","I ma Jose xu loʼ jun chom laj sawan, xu kajsaj li u chʼacul i Jesus, y xu pasij chupam. Xe u ya chupam jun jul worom pa abaj; teʼuri xu tzʼapij u chiʼ i jul ruʼ jun abaj. ");
INSERT INTO acr_acc_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","I ati Mariy Magdaléna ruʼ i ati Mariy chi u chuch i ma Jose, xquilo pa xqui muk wi. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Are xicʼaw i uxlambal ʼij, i ati Mariy Magdaléna, cuʼ i ati Mariy chi u chuch i ma Jacóbo, xak i ati Salome, xqui loʼ i cunbal muy, quiqui cojbej che i u chʼacul i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Re u sakirbal domíngo, are xel li ʼij, xe upon pa muktal wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","I ixokib que tijin chu bixquil chiquiwach: —¿Pachin nawi coj u to chi relsaxic i abaj chu chiʼ i jul-le? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Xui-ri, are xqui takej, xquil i nim laj abaj chi cojtal can chu chiʼ i jul, n-ta chic chila pu qʼuijibal. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Teʼuri xe oc pa jul y xquil jun achi, cʼa ala, cul pa qui wikabim; i u ʼuʼ naj rakan, lic sak. Ique lic xqui xij quib. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","—Mi xij iwib —xu bij chique—. Yix quix tijin chu tzucuxic i Jesus aj Nazaret chi xrip chuwach cruz. Ire n-ta chic chi, walijnak chubic; chiwilape pa yatal wi canok. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ji bij chique u tijoxelab, y xak che i ma Pédro, chi i Jesus ya ca ʼe pa Galiléa. “Ire ca ʼe pa Galiléa nabe chiwach yix”, chix chok chique. “Chila quiwil wi pacha u bim can chiwe”, chi bij chique —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Are ʼuri i ixokib paʼanem xe ʼel ruʼ i jul; lic que barbatic rumal i qui xibriquil. Lic n-ta jun tzij xqui bij chirij, man lic qui xim quib. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","I Jesus, are xwalij chiquixol i camnak, are u sakirbal re i domíngo. Nabe xu cʼut rib che i ati Mariy Magdaléna, chi Jesus resam wukub mal laj tak tew che, oʼonom lok. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Teʼuri i ixok xa ʼe chu bixquil chique i je terejnak chirij i Jesus. Are xupon cuʼ, xe u riko lic que bisonic, xak que oʼic. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Are xqui ta chi cʼaslic, xak ʼiltal u wach rumal i ixok-le, n-xqui coj taj. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Teʼuri i Jesus, jun wi tan chic u cʼutic rib xoʼon chique i queb chi je cachiʼil ique. Xu cʼut rib chique i queb-le are que tijin chi be ʼenam-que pa jyub. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ique xe tzalij chic; xe ʼe chu bixquil chique i cachiʼil, xui-ri xak chique i queb-le, i juban n-xqui coj taj, wach i xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Teʼuri i Jesus xu cʼut rib chique i je julajuj u tijoxelab are que tijin chi waʼim. Xe u yaj jubiʼ man n-tu cubibal qui cʼux che we ca walij na; xak co qui jolom, man n-xqui coj taj wach i xbix chique cumal i xe ʼilaw u wach, are walijnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Xak xu bij chique: —Jix, ji paxsaj u tzijol ronojel u wach i jyub taʼaj wach i ʼelbal chi sak; ji bij chique conojel. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Pachin ca cojow i tzij, xak xkajsax ni ya puwi, quel na ʼuri chupam u mac. Xui-ri, pachin i n-cu coj ta i tzij, ca ʼe na ʼuri pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ique chi quiqui coj na, ʼo ni ʼalijinsabal re u choʼab i Dios cuʼ: ique que quesaj ni itzel tew ruʼ u cuxtaxic in bi yin, xak quiqui rik juban chʼawbal cʼacʼ; ");
INSERT INTO acr_acc_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","xak we quiqui chap jun cumatz, o we quiqui tuʼ jun venen, n-ta coʼon chique; xak quiqui ya na qui ʼab piquiwi iwabib, y que utziric —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","I Kajwal Jesus, are xutzin che u tzij cuʼ, xcʼam bi chicaj, y xcubi pu wikabim i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","I u tijoxelab xe ʼe chu bixquil u tzij i Dios pa ronojel tak tinimit. I Kajwal xe u to chu bixquil, xak xu ʼan tak i milágro chiquiwach i que tawic, ʼalijinsabal-re chique chi katzij i qui tzij. Amen (katzij).");
INSERT INTO acr_acc_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","4","Quin tzʼibaj i tzij-i chawe yet, at nim laj winak mam Teófilo. ʼUtz xin chʼob yin, quin tzʼibaj pusucʼ niʼpa iri; cwaj cawetamaj chi lic katzij wach a tom yet chirij i Jesucrísto. Je qʼui qui ʼanom pen u tzʼibaxic pusucʼ wach xa ʼani che tak can i ʼij-i. Qui tzʼibam wach i cʼut-tal chake cumal i xe ʼilaw li cʼa chu xebal, xak cumal i je aj paxsanel re u tzijol. Yin xin taqʼui na pa rakan, cʼa chu xebal lok, wach coj tijin chu tayic; ʼutz u ʼonquil xin ʼan che, rumal-i quin bij yin, ʼutz quin tzʼibaj ni usucʼ chawe yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Are i ma Heródes are i ʼatol tzij che i jyub Judéa, are ʼuri ʼo jun achi, mam Zacarías u bi. Ire sacerdóte, aj cojol qui tzij i winak chuwach i Dios. Ire-le, qui cwenta i jutzobaj sacerdóte re i mam Abías. I rixokil i mam Zacarías, chi ati Wet, lic u muk u xiquin can i nim laj sacerdóte mam Aaron. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","I mam Zacarías, i ati Wet, je ʼutz chuwach i Dios. Lic xe cojon che ronojel u tzij u pixab i Kajwal Dios, lic n-ti qui mac che ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ique n-ta cacʼal, man i ati Wet n-calan taj; y n-xui ta la ile, xak che queb, je nimak winak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Xoʼon panok, i mam Zacarías ca tijin chu ʼonquil u patan chuwach i Dios man ya xu rik i ʼij que i jutzobaj re ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Niʼpa tak i jutzobaj sacerdóte, are i qui módo quiqui saquij na, quiquilbej-re pachin chirij ca tzak wi, chi cu poroj inciénso chuwach i Dios. Che i ʼij-le, i patan xtzak chirij i mam Zacarías, chi are ire coc pa cuárto naj u ʼij pa rachoch i Kajwal Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Xoc i mam chila y are ca tijin chu poroxic i inciénso, i uqʼuial winak chi xcoyʼej can chi sak ʼis que tijin chu tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Xak teʼet, ʼo jun ángel re i Kajwal xwinakir chuwach i mam Zacarías chila paja. I ángel-le tacʼal pa wikabim re i altar, pa ca porox wi i inciénso. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","I mam Zacarías, are xrilo, lic xoc ʼil che; lic xu xij rib che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","I ángel xu bij che: —A-Zacarías, ma xij awib. I Dios u tom wach a tzʼonom che. Yet ruʼ awixokil ati Wet ca qʼuiji jun iwacʼal. Are qui coj u bi, chi ya pu bi, a-Wan. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Yet cat quicot na; lic ʼo ni quicotemal awuʼ. Xak je qʼui i winak que quicot na are calaxic, ");
INSERT INTO acr_acc_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","man i a cʼojol-le, nim u patan che i Dios. Ire-le n-cu tij ti víno, n-cu tij ti awarient. Ire, lic pa ralaxbal lok ucʼam na rumal u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Rumal u cʼutunic ire, je qʼui aj Israel winak quiqui jek tan chic qui cojonic che i Dios; quiqui ʼan tan chic Cajwal che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Ire ca nabeaj na chuwach i Tolque chi ca cʼunic. Pacha u nojbal i mam Elías ujer, queje ni u nojbal ire; xak pacha i ʼo puʼab i mam Elías, xak queje i ʼo na puʼab ire. Ire cu chomarsaj ni qui nojbal i achiab cuʼ i cacʼal. Rumal ire, niʼpa i n-quiqui coj ti Dios, quiqui jek ni u tayic qui tzij i ʼo qui noʼoj rumal i Dios. Queje cu ʼan ire ile, yijbal que i winak, are ya ca cʼun i Cajwal. (Queje ile xu bij i ángel.) ");
INSERT INTO acr_acc_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","I mam Zacarías xu bij che: —¿Wach i retamaxic quin ʼan yin? Man yin in rij chic; xak i wixokil rij chic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","I ángel xu laʼ u wach che: —Yin in ángel Gabriel, chi in u takon i Dios. Lic ruʼ ire in petnak wi. Xin u tak lok, col in bij i ʼutz laj tzij-i chawe. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Xui-ri, yet n-ca coj taj wach i quin bij chawe, rumal-i cat memer na. N-cat chʼaw ta chic cʼa calax ni awacʼal. Wach in bim chawe, yet cawil na are cu rik i ʼij chi u chʼobom i Dios —xu bij i ángel che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","I winak coyʼem i relic i mam Zacarías pa rachoch i Dios; lic xqui bisoj man naj xbaytajic. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Are xel lok, n-quel ta chic u chʼawbal. Are ʼuri ique xquetamaj chi rilom jun nim laj ʼil chila pa cuárto naj u ʼij, pa rachoch i Dios. Ire toʼ u ʼab chic cu cʼut chique, man n-quel tu chʼawbal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Are xqʼuis i ʼij re u patan, xa ʼe chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Xoʼon panok, xqʼuiji i yobil chirij i ati Wet chi rixokil; i ixok, joʼob icʼ n-xel ta chi rachoch; lic ca quicotic xu bij pu cʼux: ");
INSERT INTO acr_acc_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“I Kajwal Dios cu ya na jun wacʼal chwe. Queje xu ʼan ni ile chwe tobal we. Xresaj in qʼuix chiquiwach i winak,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Che i wakib icʼ, i Dios xu tak li ángel Gabriel che i tinimit Nazaret chi u cwenta i jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Xu tak bi ruʼ jun ʼapoj ali, al-Mariy u bi, que u bij che wach cu ʼan ni Dios che. I ali-le, ya u yom chic u tzij che jun achi, ma Jose u bi, chi ca cʼuli ruʼ. I ma Jose-le, u muk u xiquin can i ujer ʼatol tzij mam David. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Xoc i ángel pa ʼo wi i al-Mariy, y xu ya rutzil u wach. Xu bij che: —¡Chat quicotok! ¡ʼUtz awe yet! I kajwal Dios lic ʼo awuʼ. Nim ni ʼutz cu ya i Dios pawi yet chiquiwach i juban ixokib —xu bij i ángel che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","I al-Mariy, are xril i ángel, lic xu bisoj i tzij chi xbix che; xu chʼob pu cʼux wuchac queje xu bij i ángel ile che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Rumal-i, i ángel xu bij: —Ma xij awib al-Mariy; i Dios, nim ni rutzil u cʼux chawe. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Chatapeʼ, ca pe i yobil chawij; ca qʼuiji jun awacʼal; y ca ya pu bi: A-JESUS. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Coʼon panok, nim ni u ʼij; ca bix na che chi u Cʼojol i Dios chi ʼAtz u ʼIj. I Kajwal Dios cu ya puʼab pacha u ʼatbal tzij i u mam, mam David ujer. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Ire cu ʼat na tzij piquiwi i aj Israel winak queʼe ʼij sak chirij; i u ʼatbal tzij n-tu qʼuisic. (Queje ile xu bij i ángel.) ");
INSERT INTO acr_acc_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","I al-Mariy xu bij che: —¿Wach u ʼonquil ʼuri? Yin n-ta achi qʼuijinak wuʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","I ángel xu bij che: —I u Tewal i Dios ca cʼun na pawi yet; i u choʼab i Dios chi ʼAtz u ʼIj ca kaj nali pawi. Rumal ʼuri i ral acʼal chi calaxic, lic ʼo na re i Dios che. Lic u Cʼojol i Dios ca bix na che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Xak i awachalal, ati Wet, i Dios u ʼanom jun milágro che; ya xqʼuiji yobil chirij tupu rij chic. Quiqui bij i winak chi n-calan taj, xui-ri, wakib icʼ ʼo chic chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Queje ile u ʼanom i Dios che, man i Dios ʼis ronojel ca tiqui che —xu bij i ángel. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","I al-Mariy xu bij: —Lic in ʼo puʼab i Kajwal Dios; chu ʼana na chwe pacha a bim chwe —xu bij. Are ʼuri xa ʼe i ángel. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Xoʼon chupan jubiʼ, che tak i ʼij-le, i al-Mariy xa ʼec; xu bisoj bi u be, xa ʼe che jun tinimit chujyub, u cwenta i Judéa. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Are xupon chila, xoc pa rachoch i mam Zacarías y xu tioxij i tit Wet. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ire, are xu ta chi xtioxix rumal i al-Mariy, i acʼal xu yin rib pu chʼacul, xak xcʼun i u Tewal i Dios puwi i tit Wet. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Are ʼuri, co xchʼawic y xu bij che i al-Mariy: —I Dios, nim ni ʼutz u yom pawi chiquiwach niʼpa ixokib, xak nim i ʼutz cu ya na puwi awacʼal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Nim ni a ʼij yet chin wach yin, n-ca majaw ta chwe chi yet xat cʼun chin solixic, man at u chuch i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Wetaʼam, ʼo ni u ʼij awacʼal, man are xin a tioxij, i wacʼal chi ʼo pin chʼacul, xu yin rib rumal i quicotemal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ʼUtz awe yet man xa cojo chi i Kajwal Dios cu ʼan na pacha u bim chawe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Teʼuri, xu bij i al-Mariy: —Yin, ronojel in cʼux, lic quin coj u ʼij i Kajwal Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","I wanima yin lic ca quicot rumal i Dios Tolwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Yin n-nim ti in ʼij, xui-ri i Dios xu ya i ʼutz pinwi, tupu xa in rajchac ire. Are ʼo wi woʼor, ronojel ʼij sak, conojel i winak quiqui bij na chi Dios nim i ʼutz u yom chwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Queje quiqui bij ni ique ile, man i Dios chi ʼAtz u Choʼab, nim ni ʼutz u ʼanom chwe. Lic nim u ʼij u bi. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Ire nic are wi cril toʼbal qui wach niʼpa i winak quiqui xij quib chuwach; queje u ʼanom ile chique i katit ka mam; xak queje cu ʼan ile chique i ka muk ka xiquin, we quiqui xij quib chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ruʼ i nim laj u choʼab, nim i u ʼanom; u kajsam qui ʼij niʼpa i quiqui ʼan nim che quib, man quiqui na ique ʼo qui nojbal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ire resam i nimak tak ʼatol tzij che qui patan; i niʼpa i n-ti qui ʼij, ire xu ya qui ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Niʼpa i que numic, nim i ʼutz u yom chique; xui-ri i beyomab, lic n-ta xu ya chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Xoj u to yoj oj aj Israel, chi oj rajchac ire; xcʼun chu cʼux chi cril toʼbal ka wach. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Xu ʼan na pacha u bim can chique i katit ka mam, che mam Abraham, xak chique i u muk u xiquin queʼe ʼij sak chiquij. (Queje ile xu bij i al-Mariy.) ");
INSERT INTO acr_acc_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Ire xcanaj ruʼ i tit Wet colo oxib icʼ, teʼuri xtzalij chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","I tit Wet, are xu rik u ʼij, xiwajic; xqʼuiji jun racʼal, ral ala. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Niʼpa i je ʼo chirij chuwach, xak niʼpa i rachalal, ique xqui ta chi nim ni rutzil u cʼux i Kajwal Dios oʼonom che; ʼis xe ʼe quicot ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Are xtzʼakat i wajxakib ʼij, xe ʼe chu cojic i retal que i aj Israel winak che u chʼacul i acʼal. Cacaj ique quiqui ya pu bi, a-Zacarías, pacha i u bi u kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","I u chuch xu bij: —N-are taj. I u bi: a-Wan —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","—¿Wuchac ʼuri? —xqui bij che—. Mi jun chique awachalal ʼo i u bi queje ile —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Ique teʼuri xqui tzʼonoj che u kajaw ruʼ qui ʼab wach u bi craj cu ya che. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Are ʼuri i u kajaw xu tzʼonoj chʼakap wuj chique, man cu tzʼibaj chuwach. “A-Wan u bi,” xu tzʼibaj. Conojel xqui bisoj che, wach i quilom. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Are ʼuri i mam Zacarías juntir xel chic u chʼawbal; xu jek chʼaʼatic y xu bij u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Niʼpa i je aj chirij chuwach lic xqui bisoj. Xel u tzijol chuwi tak jyub re i Judéa: i winak ʼis xqui lapo wach i xa ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Niʼpa i winak chi xe taw ile, xe oc chi chʼobonic che, y xqui tzʼonoj chiquiwach: —¿Bi chi acʼalil ile? ¿Wach nawi u patan? —xqui bij. Queje ile xqui bij, man ʼalaj chi i Kajwal Dios lic ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","I mam Zacarías, chi u kajaw i a-Wan, xcʼun i u Tewal i Dios puwi, y xu jek ʼuri u bixquil i tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","Chaka bij u ʼij i Kajwal Dios, chi ka Dios oj aj Israel winak; ire xoj ol u to ni yoj, chi oj u winak ire; u tojom i kelsaxic chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","U yom jun Tolke chi nim u choʼab; ire-le, u muk u xiquin can i mam David, chi lic rajchac i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Queje ile u bim canok chi cu ʼan na; lic ujer queje ile xu bij chique i je u loʼlaj ajbil u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ire xu bij chi coj u to na chiquiwach i je aj chʼoʼoj chikij, coj u to na chiquiwach niʼpa i tzel coj quilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Queje ile u ʼanom chake, man queje ile u bim can chique i katit ka mam rumal i rutzil u cʼux. Queje ile u ʼanom chake man n-cu sach ta chu cʼux wach i trat u ʼanom can cuʼ ique ujer. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I trat-le, i Dios lic xu bij che i ka mam, mam Abraham, chi cu ʼan na. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Xu bij chi coj resaj piquiʼab i je aj chʼoʼoj chikij man ʼutz n-caka xij ta kib chu ʼanic ka patan che ire; ");
INSERT INTO acr_acc_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","xak caka ʼan ka patan chirij, lic oj chʼam, lic oj ʼutz chuwach, niʼpa i ʼij re i ka cʼaslemal. (Queje ile xu bij i mam Zacarías; teʼuri xu bij che i acʼal:) ");
INSERT INTO acr_acc_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Xak yet, ral wacʼal, quiqui bij ni winak chi yet at ajbil u tzij i Dios chi ʼAtz u ʼIj. Queje quiqui bij na chawe, man cat nabeaj chuwach i Kajwal, que a yijba i winak chu tayic u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Yet ca cʼut na chique i je re ire chi ʼo ni sachbal qui mac, ʼelsabal-que chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","I ka Dios cʼax coj u naʼo, lic cril toʼbal ka wach; rumal ile, cu tak na li jun aj chicaj; i u cʼunic, pacha coʼon i sak re u sakirbal. ");
INSERT INTO acr_acc_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ire cu cʼam na li sak chique i je ʼo pa ʼekum; cu cʼam li sak chique i quiqui xij quib che i camic. Coj u cʼam bi pa ʼo wi i quicotemal. (Queje ile xu bij i mam Zacarías.) ");
INSERT INTO acr_acc_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","I acʼal, chi a-Wan, ca tijin u qʼuiyic, xak ca tijin u qʼuiyic u cubibal u cʼux che i Dios. Are achi chic, xa ʼe jekel che i jyub tzʼinilic. Chila xqʼuiji wi cʼa xu rik ni ʼij re u cʼutic rib chique i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Che tak i ʼij-le, are i ʼatz laj ʼatol tzij are i ma Augústo César. Ire xresaj li jun ʼatbal tzij chi ʼis ca tzʼibax qui bi i winak pa qui tinimit, ronojel tak i tinimit chi ʼo puʼab ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ile are i nabe rakan chi xu ʼan i ʼatbal tzij-i. Are xu ʼan ile, are i ma Cirénio are i gobernador pa jyub Síria. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Conojel i winak ʼis que ʼe ʼuri chu tzʼibaxic qui bi pa tak tinimit pa je petnak wi i catit qui mam. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","I ma Jose, jekel pa tinimit Nazaret, chi u cwenta i Galiléa. Ire, u muk u xiquin can i rey mam David. Rumal i ʼatbal tzij chi xel lok, ʼo ni u chac ca ʼe pu tinimit pa alaxnak wi i mam David ujer. I tinimit-le are i Belen, u cwenta i jyub Judéa. Xe ʼe ʼuri i ma Jose pa Belen junam ruʼ i al-Mariy chi yatal chic che chi rixokil. Are xe ʼec, i al-Mariy iwab winak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Are je ʼo pa tinimit Belen, xu rik u ʼij chirij i ali-le; ");
INSERT INTO acr_acc_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","chila xqʼuiji wi i nabe racʼal, ral ala. Ique n-xqui rik ti qui qʼuijibal pa meson, rumal-i i al-Mariy xa xu pasij i racʼal pa tak cʼul, y xu cotzʼba pu waybal chicop. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Nakaj che i tinimit Belen, je ʼo juban aj chajil chij pa tak ʼes, que tijin chu chajixic qui chij chaʼab. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Xak teʼet, jun ángel re i Kajwal Dios xwinakir chiquiwach. Xak i u chomal i Kajwal Dios lic ca walchʼin chiquij chiquiwach. Ique lic xqui xij quib. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I ángel xu bij chique: —Mi xij iwib. Yin xa col in bij jun ʼutz laj tzij chiwe chi ʼis que quicot ni winak rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Woʼor xalax jun Toliwe pa Belen, chi u tinimit can i mam David ujer. Are i chatal rumal i Dios: i CRISTO, chi Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Are i cʼutbal-re chiwe chi katzij i quin bij, we qui tzucuj, qui rik ni acʼal cotzʼbam pa jun u waybal chicop, pasim pa tak cʼul. (Queje ile xu bij i ángel chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Are xoʼon ile, xak teʼet xe winakir uqʼuial ángel aj chicaj ruʼ i jun. Ique, que tijin chu cojic u ʼij i Dios; xqui bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Chocsax u ʼij i Dios chila chicaj! Chuxlan qui cʼux i winak chuwach i jyub taʼaj, chi je u chom ire,” xqui bij i ángel. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Are xqui bij ile, xe tzalij chic chicaj; teʼuri i aj chajil chij xqui bij chiquiwach: —Jo pa Belen, cakilbej re wach i xa ʼanic chi u ʼalijinsam i Kajwal Dios chake —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Teʼuri i je aj chajil chij xe ʼe paʼanem cʼa Belen. Are xe uponic, xqui rik i al-Mariy ruʼ i ma Jose, xak i acʼal cotzʼbam pu waybal chicop. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Are xquilo xqui bij chique i je ʼo chila wach i u bim i ángel chirij i acʼal-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Conojel i xe tawic lic xqui bisoj wach i xbix chique cumal i je aj chajil chij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","I al-Mariy toʼ xu ta wach i xqui bij. Xu cʼol i qui tzij pu cʼux; toʼ xu chʼobo. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","I je aj chajil chij xe tzalij chic pa i je petnak wi. Are xe ʼec, que tijin chu cojic u ʼij i Dios; xqui bij chi lic nim u ʼij, rumal ronojel i qui tom, xak i quilom. Xeʼelok lic katzij pacha i u bim i ángel chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Xel wajxakib ʼij, xqui coj i retal que i aj Israel winak che u chʼacul i acʼal; are ʼuri xqui ya pu bi A-JESUS. Are u bi ile chi bital che i al-Mariy rumal i ángel, are cʼa maja ca qʼuiji i yobil chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Are xtzʼakat u ʼij i ixok Mariy, xe ʼe pa Jerusalen, quiqui ʼanbej rawasil re u walijic, pacha cu bij i ujer ʼatbal tzij re i mam Moises. Xe ʼe chu jachic i acʼal che i Kajwal Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Queje xqui ʼan ique ile rumal i tzij-i chi tzʼibtal can chupam u ʼatbal tzij i Kajwal Dios; queje iri cu bij: “Are calax i nabe acʼal, we ala, ʼo u chac ca jach na puʼab i Dios.” Queje ile tzʼibtal canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Rumal ʼuri, xe ʼe chu sujuxic queb palomax o xi n-taj, queb ixcucu, pacha i cu bij u ʼatbal tzij i Kajwal Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ʼO jun mam jekel chila pa Jerusalen, mam Simeon u bi. Ire ʼutz laj mam, lic u yom rib puʼab i Dios. Ire royʼem chic i tobal que i aj Israel winak. I mam-le, lic ʼo u Tewal i Dios ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Rumal u Tewal i Dios, retaʼam chi n-ca cam ta tan, cʼa cril ni u wach i Tolque, i jun chi u bim i Kajwal Dios cu tak na lok. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","I mam-le xoc pa rachoch i Dios, ucʼam rumal u Tewal i Dios. Are ʼuri i ma Jose i ati Mariy xak qui cʼamom bi i a-Jesus pa rachoch i Dios, chu ʼonquil che pacha i tzʼibtal can chupam u ʼatbal tzij i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Are ʼuri i mam Simeon xu ʼaluj i acʼal pu ʼab, xu cʼamwaj che i Dios, y xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","Woʼor, Wajwal Dios, xuxlan in cʼux; a ʼanom na, pacha a bim chwe; we cawaj, chin camok. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Xuxlan in cʼux man wilom chic wach i tobal-ke a yijbam. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Conojel i winak chuwach i jyub taʼaj, a yijbam wach i tobal-que. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I tobal-que chi a yijbam, queʼel chique i ne te aj Israel winak pacha sak petnak piquiwi. Y yoj, chi oj aj Israel, oj a winak yet, cocsax ni ka ʼij rumal wach a ʼanom. (Queje ile xu bij i mam Simeon.) ");
INSERT INTO acr_acc_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","I ma Jose, xak i u chuch i a-Jesus, xqui bisoj wach i xqui ta, chi xbix chirij i acʼal. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","I mam Simeon xu tzʼonoj i ʼutz re i Dios piquiwi. Are ʼuri xu bij jun tzij che ixok Mariy, chi u chuch i acʼal. Xu bij: —I acʼal-i, yatal chakaxol man cu ʼalijinsaj na pachin je re i Dios, xak pachin ne te re. Rumal ire, je qʼui ni aj Israel que totaj na, xak je qʼui xa que tzak pa tojpen rumal. I acʼal-i col u cʼutu u choʼab i Dios, tobal na que i winak, xui-ri, je qʼui quiqui xutuj ni tobal-que le. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Queje ile, quiqui ʼalijinsaj na wach i mer qui nojbal. Xui-ri yet, coc i bis pa cʼux pacha chʼichʼ coc ruʼ awanima. (Queje ile xu bij i mam Simeon che.) ");
INSERT INTO acr_acc_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Xak ʼo jun tit ʼo chila, tit An u bi, chi ajbil u tzij i Dios. Ire u miʼal i ma Fanuel, chi u muk u xiquin can i mam Aser. I tit An-le, nim laj winak chic. Are cʼa ali, xcʼuliʼic, y xcucʼaj quib wukub junab ruʼ i rachijil. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Teʼuri, xmalcanij canok, y ʼo chic ochénta y cuátro junab che. Ire n-kas ta xel pa rachoch i Dios, ca tijin chu cojic u ʼij i Dios chi paʼij, chi chaʼab; ʼolic n-cu tij ti u wa xa rumal u tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Are ʼuri ire-le xtejeb pan cuʼ i u kajaw i u chuch i a-Jesus, y xu tioxij che i Dios rumal i acʼal-le. Teʼuri xu paxsaj u tzijol i acʼal chique conojel niʼpa i aj Israel winak chi coyʼem i quelsaxic piquiʼab i aj Róma. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","I ixok Mariy, i ma Jose, are xe utzin chu ʼonquil pacha usucʼ u ʼatbal tzij i Kajwal Dios, xe tzalij ʼuri pa qui tinimit Nazaret, chi pa jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Chila xqʼuiy wi i acʼal; xqʼuiji u choʼab, xqʼuiji u nojbal, xak i rutzil i Dios lic ʼo puwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","I u kajaw i u chuch i a-Jesus, ronojel junab que ʼe pa Jerusalen chi rilic i nimaʼij páscua. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Are ʼo cablajuj junab che i a-Jesus, xe ʼe pa Jerusalen, pacha ʼax quiqui ʼan wi pa nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Xqʼuis i nimaʼij, xe tzalij lok, xui-ri, xcanaj i a-Jesus pa Jerusalen. I u kajaw u chuch n-xqui na taj we xcanaj canok; ");
INSERT INTO acr_acc_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","xqui bij ique, xa teren li cuʼ i rachiʼil. Xqui chʼij jun ʼij, toʼ queje ile xqui chʼob ique. Teʼuri xqui jek u tzucuxic chiquixol i rachalal, tak i je rachiʼil, ");
INSERT INTO acr_acc_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","y n-xqui rik taj. Rumal-i xe tzalij chic chu tzucuxic pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Xicʼaw urox ʼij, teʼuri xqui rik pa rachoch i Dios. Are xqui riko, ire cul cuʼ i je tijonel re i ujer tzij pixab, ca tijin chu tayic qui tzij, xak ʼo i tzij cu tzʼonoj ire chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Conojel i xqui ta wach i xu bij, lic xqui bisoj u nojbal, wach u tzalixic u wach xoʼon che i qui tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","I u kajaw i u chuch, are xquil u wach, lic xqui bisoj. I u chuch xu bij che: —Wacʼal, ¿wuchac queje xa ʼan ile chake? Yin, ruʼ a kajaw, lic xoj cʼachir cha tzucuxic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","—¿Wuchac xa ipa xin i tzucuj wi? —xu bij i a-Jesus chique. ¿N-iwetaʼam ta ba ri, chi yin ʼo i quin ʼan pa rachoch in Kajaw? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ique n-xqui ta ti usucʼ wach i xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Teʼuri i a-Jesus xa ʼe cuʼ pa tinimit Nazaret; chila xcojon chique pacha ʼax coʼon wi. I u chuch xu cʼol pu cʼux ronojel wach i ʼantalic. ");
INSERT INTO acr_acc_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","I a-Jesus ca tijin u qʼuiyic, xak ca tijin u qʼuiyic u nojbal; wach i xu ʼano, i Dios ʼutz xrilo; xak i winak, ʼutz xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Xoʼon panok, i Dios xu ʼijla i ma Wan, chi u cʼojol i mam Zacarías. Are xu ʼan i Dios ile, are i ma Tibério ʼatz laj ʼatol tzij, ʼo chic jolajuj junab che u ʼatbal tzij. Xak i ma Póncio Piláto are i gobernador re i jyub Judéa. Xak che i junab-le, are i ma Heródes are i cajʼatzil i aj Galiléa; xak i u chaʼ chi ma Felípe, are i cajʼatzil i aj Ituréa xak i aj Traconíte; xak i ma Lisánias are i cajʼatzil i aj Abilínia. Xak che i junab-le, i mam Anas, i mam Caifas, che queb, je ʼatz laj sacerdóte. Chupam i junab-le, i Dios xu ʼijla i ma Wan, chi ʼo pa jyub tzʼinilic. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Xu tak bi che i jyub chu chiʼ i ya Jordan. I ma Wan, are xupon chila, xoc chu bixquil chique i winak chi ʼo u chac quiqui jalwachij qui noʼoj chi n-ʼus taj chuwach i Dios. Teʼuri, ca kajsax ni ya piquiwi, cʼutbal-re chi qui jalwachim qui noʼoj chuwach i Dios. Queje u rikic ile i cuybal qui mac, xu bij i ma Wan chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Xeʼelok pacha u bim can i ajbil u tzij i Dios, mam Isaías, chupam u wuj ujer. Ire u tzʼibam can i tzij-i: Ca tataj u chʼawbal jun ca siqʼuin che i jyub tzʼinilic; cu bij: “¡Ya ca pe i Kajwal! Chi yijba u be chuwach. Chi sucʼba niʼpa i jul, niʼpa i tanalak pu be i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Niʼpa u xol tak jyub, ca nojsaxic; niʼpa i u tzam tak jyub, ca kajsaxic; xak i ral tak jyub ca kajsax na. Niʼpa i be cotcak, ca sucʼbax na; niʼpa i be tanalak, ca jos na. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Teʼuri conojel i winak ʼis quiquil na wach i tobal-que u yijbam i Dios.” (Are i tzij ile u tzʼibam can i mam Isaías ujer, y queje ile xeʼelok.) ");
INSERT INTO acr_acc_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Je qʼui i winak xe cʼun ruʼ i ma Wan, quiqui tzʼonoj u kajsaxic ya piquiwi. Ire xu bij chique: —¡Yix xa ix racʼal cumatz! ¿Pachin xbin chiwe chi quix totaj chuwach i tojpen chi ca tijin nali piwi? ");
INSERT INTO acr_acc_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","N-ʼus taj we toʼ ca kajsax ya piwi. Chi ʼana i ʼutz, i chom, ʼalijinsabal-re we i jalwachim chic i nojbal chi n-ʼus taj. Mi chʼob yix pi jolom, “Lic oj ʼutz man oj u muk u xiquin can i mam Abraham,” quix cha. Ile n-ta coʼono. Chiwila i abaj-i; i Dios, we ta craj, ca tiqui chu yijbaxic je qʼui u muk u xiquin i mam Abraham che. N-are ti rumal i mam, mam Abraham, quix totajic. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Chitapeʼ, i Dios yij chic chu cojic pa tojpen niʼpa i u muk u xiquin i mam Abraham chi n-ʼus ti quiqui ʼano. Lic yij chic chu petsaxic i tojpen-le pacha cu ʼan jun achi yij chic ruʼ i ricaj cʼatzbal-re jun cheʼ. Niʼpa i cheʼ chi n-cu ya ti ʼutz laj echaʼ, ca cʼatzix na; teʼuri cocsax pa ʼaʼ. (Queje ile xu bij i ma Wan chique i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Are ʼuri i winak xqui tzʼonoj che: —¿Wach caka ʼan ʼut? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Xu bij chique: —We ʼo queb a camix, cha sipaj jun re i n-tu camix. We ʼo ca tijo, cha ya re i n-ti cu tijo —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Xak ʼo i aj tzʼonol alcawal xe cʼun ruʼ i ma Wan, quiqui tzʼonoj u kajsaxic ya piquiwi. Xqui bij che: —At tijonel, cha bij chake wach nawi caka ʼan yoj —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ire xu bij chique: —Mi tzʼonoj mas mer chique i winak, xui chi tzʼonoj chique pacha cu bij i ʼatbal tzij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Xak ʼo i soldádo xe cʼun ruʼ, quiqui tzʼonoj che. —¿Wach caka ʼan yoj, oj soldádo? —xqui bij. —Me i xibij i winak —xu bij chique— xak mi maj qui mer; mi coj qui mac we n-ti qui mac; chix quicot ruʼ iwajil chi qui chʼaco; mi rayij mas. (Queje xu bij i ma Wan ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","I aj Israel winak, ʼis coyʼem chic u cʼunic i Tolque; xqui jek u chʼobic piqui cʼux chi i ma Wan mok are i Tolque-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ire xu bij ʼuri chique conojel: —Yin n-in ti Toliwe chi iwoyʼem. Yin, katzij quin kajsaj ya piwi, xui-ri, i jun chi ca cʼun chwijil yin cu kajsaj li u Tewal i Dios piwi; xak cu kajsaj li ʼaʼ piquiwi i je mal. Ire mas nim ni u ʼij chinwach yin; n-ca majaw ta chwe quin ʼan mocom che wib chirij, mi tene quin tor u wach u xajab, rumal ni u ʼij nim. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Col u ʼata tzij piquiwi i winak, pachin i je ʼutz, xak pachin i ne te ʼutz. Ire yij chic pacha coʼon jun ruʼ u pubal u wach trígo. Are i ʼutz quel che u trígo, cu molo y cu ya pu cʼolbal. I rij, chi n-ʼus taj, cu poroj pa ʼaʼ chi n-tu chupic —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Ruʼ tak i tzij-le, xe u pixbaj i winak, xak ruʼ juban chic pixbanic. Queje xoʼon ire ile, are ca tijin chu bixquil i ʼutz laj tzij re i Dios chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Xui-ri, i ma Heródes, chi cajʼatzil i aj Galiléa, xu tzʼapij i ma Wan pa cárcel. Xu tzʼapij, man i ma Wan xu bij che chi n-ʼus ti ca tijin chu ʼanic. Ire u majom i ati Erodiys, chi rixokil u chaʼ, chi ma Felípe; xak ʼo juban chic u mac u ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Are xyaj rumal i ma Wan, xpe roywal; rumal-i xu min pa cárcel. Are jun chic u mac-i xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","I Jesus, are xkajsax ya piquiwi conojel i winak, xak xkajsax ya puwi ire. Are ʼuri, are ca tijin chu tzʼonoxic che i Dios, xjaktaj i caj, ");
INSERT INTO acr_acc_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","y xkaj li u Tewal i Dios puwi, pacha u qʼuexwach palomax. Xtataj jun chʼawbal chicaj chi xu bij: —Yet lic at in Cʼojol; cʼax cat in naʼo. Lic quin quicot awumal —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","I Jesus, are xu jek u chac, colo ʼo chic tréinta junab che. Ire, are u cʼojol i ma Jose, quiqui bij i winak. I ma Jose-le, are u cʼojol i ma Eli. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","I ma Eli are u cʼojol i ma Matat. I ma Matat are u cʼojol i ma Levi. I ma Levi are u cʼojol i ma Mélqui. I ma Mélqui are u cʼojol i ma Jána. I ma Jána are u cʼojol i ma Jose. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","I ma Jose are u cʼojol i ma Matatías. I ma Matatías are u cʼojol i ma Amos. I ma Amos are u cʼojol i ma Nahum. I ma Nahum are u cʼojol i ma Esli. I ma Esli are u cʼojol i ma Nagái. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","I ma Nagái are u cʼojol i ma Maat. I ma Maat are u cʼojol i ma Matatías. I ma Matatías are u cʼojol i ma Seméi. I ma Seméi are u cʼojol i ma Jose. I ma Jose are u cʼojol i ma Juda. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","I ma Juda are u cʼojol i ma Joána. I ma Joána are u cʼojol i ma Résa. I ma Résa are u cʼojol i ma Zorobabel. I ma Zorobabel are u cʼojol i ma Salatiel. I ma Salatiel are u cʼojol i ma Néri. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","I ma Néri are u cʼojol i ma Mélqui. I ma Mélqui are u cʼojol i ma Adi. I ma Adi are u cʼojol i ma Cosam. I ma Cosam are u cʼojol i ma Elmodam. I ma Elmodam are u cʼojol i ma Er. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","I ma Er are u cʼojol i ma Josue. I ma Josue are u cʼojol i ma Eliézer. I ma Eliézer are u cʼojol i ma Jorim. I ma Jorim are u cʼojol i ma Matat. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","I ma Matat are u cʼojol i ma Levi. I ma Levi are u cʼojol i ma Simeon. I ma Simeon are u cʼojol i ma Juda. I ma Juda are u cʼojol i ma Jose. I ma Jose are u cʼojol i ma Jonan. I ma Jonan are u cʼojol i ma Eliaquim. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","I ma Eliaquim are u cʼojol i ma Meléa. I ma Meléa are u cʼojol i ma Mainan. I ma Mainan are u cʼojol i ma Matáta. I ma Matáta are u cʼojol i ma Natan. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","I ma Natan are u cʼojol i ma David. I ma David are u cʼojol i ma Isai. I ma Isai are u cʼojol i ma Obed. I ma Obed are u cʼojol i ma Booz. I ma Booz are u cʼojol i ma Salmon. I ma Salmon are u cʼojol i ma Naason. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","I ma Naason are u cʼojol i ma Aminadab. I ma Aminadab are u cʼojol i ma Aram. I ma Aram are u cʼojol i ma Esrom. I ma Esrom are u cʼojol i ma Fáres. I ma Fáres are u cʼojol i ma Juda. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","I ma Juda are u cʼojol i ma Jacob. I ma Jacob are u cʼojol i ma Isaac. I ma Isaac are u cʼojol i ma Abraham. I ma Abraham are u cʼojol i ma Tare. I ma Tare are u cʼojol i ma Nacor. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","I ma Nacor are u cʼojol i ma Serug. I ma Serug are u cʼojol i ma Ragáu. I ma Ragáu are u cʼojol i ma Peleg. I ma Peleg are u cʼojol i ma Héber. I ma Héber are u cʼojol i ma Sála. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","I ma Sála are u cʼojol i ma Cainan. I ma Cainan are u cʼojol i ma Arfaxad. I ma Arfaxad are u cʼojol i ma Sem. I ma Sem are u cʼojol i ma Noe. I ma Noe are u cʼojol i ma Lamec. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","I ma Lamec are u cʼojol i ma Matusalen. I ma Matusalen are u cʼojol i ma Enoc. I ma Enoc are u cʼojol i ma Jared. I ma Jared are u cʼojol i ma Mahalaleel. I ma Mahalaleel are u cʼojol i ma Cainan. ");
INSERT INTO acr_acc_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","I ma Cainan are u cʼojol i ma Enos. I ma Enos are u cʼojol i ma Set. I ma Set are u cʼojol i ma Adan. I ma Adan are u cʼojol i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","I Jesus xel chila che i ya Jordan, lic ʼo u Tewal i Dios ruʼ. Teʼuri xcʼam bi che jun jyub tzʼinilic rumal u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Chila xu chʼij cuarénta ʼij, lic n-ta xu tijo. Are ʼo chila, xupon itzel ruʼ; xraj ire cu ʼan che i Jesus chi cu ʼan jun u mac. Are xicʼaw i cuarénta ʼij, xpe i numic che. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Are ʼuri, i itzel xu bij che: —We yet at u Cʼojol i Dios, cha bij che i abaj-i coʼon wa che rib —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","I Jesus xu laʼ u wach che: —N-quin ʼan taj —xu bij—. Man chupam u wuj i Dios, queje iri tzʼibtalic: “N-xui ta rumal i wa je cʼas i winak. Xui-ri are ronojel u tzij i Dios je cʼasbawnak” —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Teʼuri i itzel xu cʼam bi che jun nim laj jyub. Juntir xu cʼut che i Jesus ronojel i nimak tak tinimit ʼo chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Teʼuri xu bij chic che: —Ronojel iri ʼis ʼo pinʼab yin. Xak ʼo pinʼab quin sipaj che, pachin che cwaj yin. Ronojel iri, ruʼ u chomal, quin sipaj chawe, ");
INSERT INTO acr_acc_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","xui-ri we yet cat xuqui chinwach, y ca coj in ʼij —xu bij itzel che. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","I Jesus xu laʼ chic u wach che: —Chat el chinwach, a-Satanas, man chupam u wuj i Dios, queje iri tzʼibtalic: “Xui che Awajwal Dios cha cojo u ʼij; xui che ire ca ʼan wi a patan,” queje ile cu bij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Teʼuri i itzel xu cʼam bi i Jesus pa Jerusalen. Xe u ya chila cʼa chu tzam i rachoch i Dios. Teʼuri xu bij che: —We yet at u Cʼojol i Dios, cha cʼaka bi awib cʼa pulew. N-cat cam taj, ");
INSERT INTO acr_acc_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","man chupam u wuj i Dios, queje iri tzʼibtalic: I Dios cu bij na chique u ángel cat qui chajij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ique lic cat cucʼaj che qui ʼab; mi tene quiqui ya chawe que ʼana cʼax che awakan che abaj, cu bij. (Queje ile xu bij itzel che.) ");
INSERT INTO acr_acc_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","I Jesus xu laʼ chic u wach che: —Xak tzʼibtal i tzij-i chupam u wuj i Dios: “Ma cʼam u pam Awajwal Dios,” cu bij. Rumal-i, n-quin ʼan taj —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","I itzel, ya n-cu rik ta chic wach cu tʼorbej re i Jesus, are ʼuri, xel jun tiémpo chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Teʼuri i Jesus xtzalij pa Galiléa, lic ʼo u Tewal i Dios ruʼ. Ronojel wach i xu ʼano, xel u tzijol ronojel pa tak jyub chirij chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ire xu cʼut u tzij i Dios chique i winak pa tak molbalʼib, y conojel xqui bij chi nim u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Teʼuri i Jesus xa ʼe pa tinimit Nazaret, pa xqʼuiy wi. Pacha ʼax coʼon wi pa tak uxlambal ʼij, xoc pa molbalʼib. Xqui tzʼonoj che chi crajlaj u tzij i Dios chique i je ʼo chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Are xtaqʼui chu ʼonquil, xqui ya i wuj che chi u tzʼibam can i mam Isaías, chi ajbil u tzij i Dios ujer. Xu jak i wuj, xu tzucuj y xu riko pa ʼo wi i tzij chi queje iri cu bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","I u Tewal i Kajwal lic ʼo wuʼ, man in u chom yin chu paxsaxic i ʼutz laj tzij chique i nibaʼib; in u takom li chi relsaxic i cʼax piqui cʼux, niʼpa i que bisonic. In u takom li chu bixquil wach i quelbal chi sak, niʼpa i je chaptajnak, xak chu bixquil wach u rikic i qui tzunbal i je mawach. In u takom li chi qui toʼic niʼpa i quiqui tij i cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","In u takom li chu bixquil chiwe chi ya xu rik i ʼij chatal rumal i Dios chi cu cʼut chiwe ʼo chic toʼbal i wach. (Are i tzij-le xrajlaj i Jesus chique, chi u tzʼibam can i mam Isaías.) ");
INSERT INTO acr_acc_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Teʼuri xu bor chic i wuj, y xu ya che i chajinel, y xcubiʼic. Conojel i je ʼo pa ja toʼ xqui maj u takexic. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Teʼuri xu jek i chʼaʼatic cuʼ. Xu bij: —Woʼor, chupam i ʼij-i, i Dios ca tijin chu ʼonquil pacha i tzij-le chi tzʼibtal can ujer. Woʼor, quiwil ʼut ʼo chic chi chiwach —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Conojel lic ʼutz xe chʼaw chirij i Jesus. Lic chom i u tzij xu bij; lic xqui bisoj rumal. Xqui bij chiquiwach: —Ire-le ¿xataba n-are ti u cʼojol i ma Jose? Are pues —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","I Jesus xu bij chique: —Katzij, yix qui bij na i tzij-i chwe, chi ʼax bital wi: “Ajcun, cha cunaj awib yet,” qui bij na chwe. Xak qui bij na iri chwe: “Niʼpa i ka tom chi a ʼanom chila pa tinimit Capernaum, cha ʼana ni waral chupam a tinimit yet,” qui bij na chwe. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Xak xu bij: —N-quin ʼan taj, man mi jun ajbil u tzij i Dios cocsax u ʼij pu tinimit ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Quin cʼunsaj na pi cʼux wach xu ʼan i mam Elías, chi ajbil u tzij i Dios ujer. Che tak i ʼij-le, n-xpe ti jab oxib junab ruʼ nicʼaj; rumal-i xpe waʼjal chuwach i jyub taʼaj. Je qʼui ixokib malcanib pa jyub Israel, ");
INSERT INTO acr_acc_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","xui-ri i Dios n-xu tak ti mam chi qui toʼic ique; xa xu tak bi ruʼ jun ixok malcan chi n-aj Israel taj; i ixok-le aj Sarépta, chi re i jyub Sidon. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Xak quin cʼunsaj pi cʼux wach xu ʼan i mam Eliséo ujer. Je qʼui je rach aj Israel chi ʼo itzel laj yobil lépra chique. Xui-ri, mi jun xe u cunaj chique, xui i ma Naaman chi aj Síria, xcunaxic; ire n-aj Israel taj. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Are xqui ta wach i xu bij, ʼis xpe coywal niʼpa je ʼo pa molbalʼib. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Are ʼuri xe walijic y xquesaj pa tinimit. Xqui cʼam bi tzam jyub re i tinimit, xcaj ique quiqui cʼak li chuwi jyub, ");
INSERT INTO acr_acc_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","xui-ri i Jesus xa xicʼaw chiquixol y xu maj u be. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Teʼuri xkaj bi i Jesus pa Capernaum, chi u cwenta i jyub Galiléa. Che i uxlambal ʼij, xe u tijoj i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ique toʼ quiqui bisoj wach i cʼutunic cu ʼano, man i u tzij pacha u tzij jun ʼatol tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ʼO jun achi pa molbalʼib, ʼo itzel tew che. Ire xsiqʼuin chu bixquil: ");
INSERT INTO acr_acc_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","—Jesus aj Nazaret, ¿wuchac col a mina awib kuʼ yoj? ¿Mok xat cʼun na col a sachbej ka wach? Yin wetaʼam a wach: yet are i jun at petnak ruʼ i Dios; ¡lic ʼo re i Dios chawe! (Queje ile ca siqʼuin chu bixquil.) ");
INSERT INTO acr_acc_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","I Jesus xu ʼatij i itzel tew che, wach i xu bij. —¡Mat chʼawic! —xu bij—. ¡Chawoʼtaj can i achi-le! —xu bij che. Are ʼuri i itzel tew xu tzaksaj i achi pulew chiquiwach i winak. Teʼuri xel che, n-ta chic jun cʼax xu ʼan che i achi. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Conojel i winak xe oc ʼil che y xe oc chu chʼobic chiquiwach: —¿Bi chi tzijol ile xu bij? —xe cha chiquiwach—. I achi-le, u tzij lic ʼo u choʼab; ʼo puʼab que u tak bi itzel tew, ¡y que ʼelic! —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Teʼuri xpax u tzijol i Jesus ronojel i jyub re i Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","I Jesus xel pa molbalʼib y xa ʼe chi rachoch i ma Simon. I u chuch u jiʼ i ma Simon lic iwab, nim i ʼaʼ ʼo chirij. Are xoc i Jesus pa ja, xqui tzʼonoj cuybal mac che chi crilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Are ʼuri xa ʼe tacʼal ruʼ u chʼat y xu ʼatij i ʼaʼ. Juntir xpactaj i ʼaʼ chirij ixok. Are ʼuri ire xwalijic, y xoc chi qui tzukic. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Are kajnak chic i ʼij, i winak xqui ticba li u cʼamic iwabib ruʼ i Jesus. Xa bi chi yobil ʼo chique, ire ʼis xu ya u ʼab piquiwi chi qui jujunal, y xe utziric. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Xak je qʼui i winak xelsax itzel tew chique. Are xe ʼelic, xe siqʼuinic: “¡Yet at u Cʼojol i Dios!” xe cha. Ire xe u ʼatij, y xu bij chique, “Mix chʼawic,” xu bij, man ique quetaʼam are ire i Tolque i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Sakir chucab ʼij, i Jesus xel pa tinimit, xa ʼe che jun jyub tzʼinilic. I winak lic xqui tzucuj, y xqui riko pa ʼo wi. Cacaj ique ca canaj cuʼ, ");
INSERT INTO acr_acc_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","péro i Jesus xu bij chique: —Quin ʼe chic che juban tak tinimit; ʼo u chac xak quin bij chique ique wach i coquic pa cu ʼat wi tzij i Dios. Are i rumal-i xin u tak li Dios —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Teʼuri, xa ʼe chu bixquil u tzij i Dios chique i winak pa tak molbalʼib, ronojel i jyub que i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","I Jesus tacʼal chiya, Genesaret u bi. Lic je qʼui i winak xe uponic, lic quiqui tacpuj chic quib, man cacaj quiqui ta u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","I Jesus xril queb bárco, ʼo chu chiʼ i ya, pa xqui canaj wi can i aj chapol car. Ique que tijin chu chʼajic i cataraya. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","I Jesus xoc chupam jun bárco chi re i ma Simon. Teʼuri xu tzʼonoj pawor che i rajaw chi cocsax pan jubiʼ pa ya. Are ʼuri i Jesus xcubi chupam i bárco y xoc chu cʼutic chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Are xutzin u chʼaʼatic cuʼ i winak, xu bij che i ma Simon: —Cha binsaj bi a bárco pa cho, teʼuri cha cʼaka bi awataraya chila y ʼo ca riko —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","I ma Simon xu bij che: —Nim laj winak, lic coj tijinic jun aʼab, péro n-ti xka riko. Xui-ri, we queje ca bij yet ile, quin ʼan na —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Teʼuri xqui cʼak bi i cataraya. Lic qʼui i car xu jecʼ li ataraya; xu ticba u rakcrijic rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Xqui ʼan pan séña chique i cachiʼil ruʼ chic jun bárco, chi que ol qui to na ruʼ i cataraya. I juban xe cʼunic y xe qui to i cachiʼil; xnoj i queb bárco che i car, laj xe muktaj pa ya rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","I ma Simon Pédro, are xril ile, xuqui chuwach i Jesus y xu bij che: —¡Chat el chinwach, Kajwal, man yin xa in ajmac laj achi! —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Queje xu bij i ma Simon ile, man lic xu xij rib. Xak niʼpa i je ʼo ruʼ ʼis xe oc ʼil rumal ni uqʼuial car xqui chapo. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Xak i juban cachiʼil xqui xij quib, chi je are i ma Jacóbo i ma Wan, chi je u cʼojol i mam Zebedéo. I Jesus xu bij che i ma Simon: —Ma xij awib; woʼor quin ʼan chawe at aj tzucul-que i winak pacha ca ʼan chique i car —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Teʼuri xquesaj li qui bárco chu chiʼ i ya; ronojel ʼis xqui canaj canok y xe terej bi chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Xoʼon panok, i Jesus, are ʼo che jun tinimit, xupon jun achi ruʼ, ʼo itzel laj yobil che, lépra ca bixic. Ire, are xril i Jesus, xuqui chuwach y xu kajsaj u jolom cʼa chuwach ulew; lic xu tzʼonoj utzil chomal che. Xu bij: —Nim laj winak, we ta cawaj, cat tiqui chi relsaxic itzel laj yobil ʼo chwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Teʼuri i Jesus xu chap ruʼ u ʼab; —Cwaj —xu bij—. ¡Chat utzirok! Are xu bij ile che, juntir xchomar chic u chʼacul i achi. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","I Jesus xu bij che: —Mi jun ma lap che wach in ʼanom. Xui-ri, jat, ja cʼutu awib che i sacerdóte chi at utzirnak, cha sujuj a sipon chuwach i Dios, pacha u bim can i mam Moises. Queje cha ʼana ile, man caquetamaj conojel i winak chi at utzirnak chic, chʼam chic a chʼacul —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Teʼuri i Jesus, mas xpax u tzijol wach ca tijin chu ʼonquil. I winak lic quiqui tzucuj; je qʼui xe moltaj chu tayic u tzij; xak chu tzʼonoxic che, chi que utzirsaxic. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Xui-ri, ire ʼolic ca ʼe pa tak jyub tzʼinilic chu tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Xoʼon panok, i Jesus ca tijin chu cʼutic chique i winak. Xak chila je cul juban aj Fariséo, xak jujun chique i tijonel re i ujer ʼatbal tzij. Ique je petnak pa ronojel tak i aldéa re i jyub Galiléa, xak i re i jyub Judéa, xak ʼo jujun je petnak cʼa pa tinimit Jerusalen. I Jesus, lic ʼo u choʼab i Dios ruʼ, che i cutzirsaxic iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Are ʼuri, xe upon juban achiab, cucʼam bi jun achi chuwa chʼat, lic siquirnak u chʼacul. Cacaj que oc bi pa ja, quiqui yabej-re chuwach i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","N-xqui rik taj pa que oc wi, cumal i winak lic je qʼui. Rumal ʼuri, xe ʼel chuwi ja y xquesaj i xot. Teʼuri xqui kajsaj bi iwab chuwa chʼat cʼa paja. Lic chiquixol i winak xqui kajsaj wi, mer chuwach i Jesus xqui ya wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","I Jesus xrilo, chi i achiab-le lic qui cubam qui cʼux che. Rumal ʼuri, xu bij che i iwab: —Wacʼal, niʼpa i a mac ya cuytajnak chic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Are ʼuri, i tijonel re i ujer ʼatbal tzij, xak i aj Fariséo xe oc chu chʼobic piqui cʼux: “¿Bi ruxic i achi-le? I tzij xu bij-le, cu kajsaj u ʼij i Dios ruʼ. Mi jun ʼo puʼab cu cuy i qui mac i winak; ¡xui i Dios!” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Xui-ri, i Jesus retaʼam wach quiqui chʼobo. Rumal-i xu bij chique: —¿Wuchac qui chʼob ile pi cʼux? ");
INSERT INTO acr_acc_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ile n-cʼax tu bixquil chi “Ya xcuytaj a mac.” Are i cʼax u bixquil are iri: “Chat walijok, y chat binok,” are ile cʼax u ʼonquil che jun winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Xui-ri yin chi in Achi aj Chicaj quin ʼalijinsaj na chiwe chi ʼo pinʼab quin cuy ni qui mac i winak waral chuwach i jyub taʼaj —xu bij chique. Teʼuri xu bij che i achi chi siquirnak: —Chatapeʼ, chat walijok, cha yaca bi a soc, y jat chi awachoch —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Juntir xwalij i iwab chiquiwach i winak. Xu yac bi u soc chi cotzʼol te chuwach, y xa ʼe chi rachoch, ca tijin chu cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Conojel lic xqui bisoj, y xe oc chu bixquil u ʼij i Dios. Lic je ocnak ʼil, xqui bij: “I kilom woʼor, lic jun milágro,” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Are xu ʼan ile, i Jesus xa ʼec. Are ca tijin chi be, xril jun aj tzʼonol alcawal cul pu qʼuijibal. I achi-le, ma Lewi u bi. I Jesus xu bij che: —Chat terej chwij —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","I ma Lewi juntir xwalijic, ʼis xu canaj can ubitak-re, y xterej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Xoʼon panok i ma Lewi xu ʼan jun nim laj cenar che rachoch, cojbal u ʼij i Jesus. Je qʼui i aj tzʼonol alcawal je ʼo cuʼ chi mexa, xak je ʼo chic juban winak cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","I aj Fariséo chila, je cachiʼilam i qui tijonel, chi je ajʼatzil re i ujer ʼatbal tzij. Ique xe oc chi qui chʼachʼaxic u tijoxelab i Jesus. Y xqui bij: —¿Wuchac queje qui ʼan yix ile? Xa qui tij i wa y qui tuʼ i yaʼ cuʼ i aj tzʼonol alcawal, xak i juban ne te ʼutz laj tak winak —xe cha chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","I Jesus xu laʼ u wach chique: —Quin ʼan iri, man are i je iwab craj jun ajcun chique; i ʼutz qui wach, n-tu chac jun ajcun chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Yin in cʼun-nak chi qui siqʼuixic i je ajmaquib, man quiqui rik ni u jalwachixic i qui cʼaslemal. Niʼpa i je ʼutz, n-tu chac quin ʼat in pen cuʼ —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Teʼuri ique xe oc chu tzʼonoxic che i Jesus: —¿Wuchac i a tijoxelab yet n-cacoʼtaj ta jun ʼij queb ʼij i qui waʼim chuwach i Dios, pacha caka ʼan yoj? —xqui bij—. I u tijoxelab i ma Wan quiqui ʼano; xak queje caka ʼan yoj oj aj Fariséo. Xui-ri, i awe yet n-quiqui ʼan taj; ʼij ʼij que waʼic y que tuʼunic —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","I Jesus xu bij chique: —I winak, we que ʼe pa nimaʼij re jun achi ya ca cʼuliʼic, ¿xataba yix qui ʼan chique we n-quiqui tij ti wa ruʼ? Quiqui tijo pues. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Xui-ri, we xu rik i ʼij chi ʼelsam chic i achi chiquixol, teʼuri quiqui mayij i waʼim. Queje i tijojbal tzij ile xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Xak ʼo jun chic tijojbal tzij xu bij chique; are iri: —Jun, we craj cu cʼojoj jun u ʼuʼ ʼel chic, n-cu cʼatzij ti chʼakap che u ʼuʼ cʼacʼ, cu cʼoj-bej re u ʼuʼ ʼel. Mi jun ca ʼanaw ile. We ta queje cu ʼan ile, cu ʼan mal che u ʼuʼ cʼacʼ; xak queje i chʼakap cʼacʼ, n-ʼus ta cu ʼan che u ʼuʼ ʼel. (Queje xu bij i Jesus ile chique, cʼutbal-re chique chi i costúmbre re ujer, n-cu chʼij taj coc ruʼ i cʼutunic cʼacʼ.) ");
INSERT INTO acr_acc_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","—Xak queje ile, mi jun cu coj víno cʼacʼ chupam i ʼel tak surum. N-quiqui ʼan taj man i víno cʼacʼ xa cu rakchʼij i surum. Queʼelok, coʼon mal i surum, xak ca sach i víno. ");
INSERT INTO acr_acc_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Rumal-i ʼo u chac qui cʼol i víno cʼacʼ chupam i surum cʼacʼ. Queje ile, ca totaj ni víno, xak i surum. Queje ile xu bij i Jesus chique. Xak xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jun, we ʼax cu tuʼ wi i ujer víno, n-craj ta tan cu tuʼ i cʼacʼ. Cu chʼob ire, “Mas ʼutz i ujer víno,” cu bij ire. (Queje i tijojbal tzij ile xu bij i Jesus chique, cʼutbal-re chique chi cʼax u jalwachixic qui costúmbre re ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Xoʼon panok, chupam jun uxlambal ʼij, i Jesus ca bin cuʼ u tijoxelab chupam juban ticon. I u tijoxelab xe oc chu chʼupic u wach i trígo, y xqui bar piqui ʼab ca quesbej re u solot; teʼuri xqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Are ʼuri ʼo jujun chique aj Fariséo xqui bij che i Jesus: —¿Wuchac qui ʼan yix i chac-le? N-ʼus taj quix chacun pa uxlambal ʼij, cu bij i ʼatbal tzij tzʼibtal can rumal i mam Moises —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","I Jesus xu laʼ u wach chique: —¿Xataba n-iwetaʼam ti yix wach xu ʼan i mam David ujer are xqui tij numic cuʼ i rachiʼil? ");
INSERT INTO acr_acc_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Xoc ire pa rachoch i Dios, y xu chap i caxlanwa chi sujtal can chuwach i Dios. Teʼuri, xu tijo, xak xu ya chique i rachiʼil. Queje xu ʼan ire ile, tupu n-ta re che. Man cu bij i ujer ʼatbal tzij chi xui i sacerdóte que tijaw i caxlanwa-le. (Queje ile xu bij i Jesus chique). ");
INSERT INTO acr_acc_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Xak xu bij: —Yin chi in Achi aj Chicaj xak quin rajawij puwi i uxlambal ʼij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Xu rik chic jun uxlambal ʼij, i Jesus xoc pa molbalʼib y xoc chic chu cʼutic chique i winak. Chila ʼo wi jun achi siquirnak u ʼab wikabim, chakijnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Xak chila je ʼo wi jujun tijonel re i ʼatbal tzij, xak jujun aj Fariséo winak. Ique que tijin chu takexic i Jesus, we crutzirsaj i achi-le pa uxlambal ʼij. Cacaj ique quiqui tzucuj u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ire retaʼam wach quiqui chʼob piqui cʼux; xu bij che i achi chi chakijnak u ʼab: —Chat walijok, y chat tacʼal chakawach —xu bij che. Are ʼuri i achi xwalijic y xtaqʼuiʼic. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Teʼuri i Jesus xu bij chic chique i que tzucuw u mac: —ʼO jun tzij cwaj quin tzʼonoj chiwe. I ujer ʼatbal tzij, ¿wach cu bij chake, qui bij yix? Chupam i uxlambal ʼij, ¿ʼutz nawi we caka ʼan jun utzil chomal, o xa caka ʼan i n-ʼus taj? ¿ʼUtz caka to jun chi ya ca camic? ¿O xa caka ya che chi ca camic? (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Cʼula xe u takej, teʼuri xu bij che i achi: —Cha sucʼba i a ʼab —coʼono. I achi xu sucʼba u ʼab, y xutziric. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Xui-ri, i juban lic xpe coywal; xe oc chu chʼobic chiquiwach, “¿Wach caka ʼan che i achi-le?” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Che tak i ʼij-le, i Jesus xel bi che jun jyub chu tzʼonoxic che i Dios. Xu chʼij jun aʼab ca tijin chu tzʼonoxic che. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Are xpe u sakiric, xe u siqʼuij u tijoxelab ruʼ. Teʼuri xe u cha cablajuj chiquixol, chi xu ya can piqui bi, je apostelab. (Queʼel pa ka chʼawbal, je u takon.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Are i qui bi i cablajuj-le are iri: jun, ma Simon, chi xak ma Pédro ca bix che rumal i Jesus. Xak ʼo i ma Andres, chi ratz u chaʼ i ma Pédro. Xak je ʼo i ma Jacóbo, i ma Wan, i ma Felípe, i ma Bartolome. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Xak je ʼo i ma Matéo, i ma Tomas; xak i ma Jacóbo chi u cʼojol i ma Alféo; xak ʼo chic jun ma Simon, chi re i partído cananísta. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Xak ʼo i ma Júdas chi catz qui chaʼ quib ruʼ i ma Jacóbo. Xak ʼo i ma Júdas Iscarióte chi xoʼon panok xu cʼayij i Jesus. (Ile je are i cablajuj apostelab je chatal rumal i Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Teʼuri i Jesus xe kaj li tzam jyub cuʼ u tijoxelab, y xe qʼuiji che jun uwataʼaj. Je qʼui chic i u tijoxelab xe moltaj cuʼ, xak je qʼui i winak xe cʼun cuʼ, chi je aj ronojel i jyub Judéa, xak xe cʼun i je aj pa tinimit Jerusalen, xak xe cʼun i je aj pa queb tinimit, Tíro y Sidon chi ʼo pa cósta. Naj je petnak wi. Ique je upon-nak chu tayic u tzij i Jesus, xak chu cunaxic i cʼax ʼo chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Xak niʼpa i ʼo itzel tew chique, xak xe utzirsax na. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Conojel i winak cacaj quiqui yin pan i Jesus, man i choʼab ʼo ruʼ ire que u cunaj iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Are ʼuri i Jesus xe u takej i u tijoxelab. Xu bij chique: —ʼUtz iwe yix, ix nibaʼ, man ix ʼo chic puʼab i Dios; ire cu ʼat tzij piwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ʼUtz iwe yix, chi woʼor quix numic, man quix nojsax na. ʼUtz iwe yix chi woʼor quix oʼic, man quix tzen na. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ʼUtz iwe yix we i winak tzel quix quilo xa wumal yin chi in Achi aj Chicaj, xak we quix quesaj chiquixol, xak we quix qui yoʼya, xak we tzel quiqui ta i bi yix, xa wumal yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Chix quicot ʼuri, ¡chix sacʼlin chicaj! man yix qui chʼac ni nim laj i sipon chila chicaj. Mi bisoj we queje quiqui ʼan ique ile chiwe, man xak queje xqui ʼan i catit qui mam chique i je ajbil u tzij i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Xui-ri, ¡toʼ i wach yix ix beyomab! quix tijin ruʼ i ʼutz chuwach i jyub taʼaj, xui-ri, ya ca qʼuisic. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Toʼ i wach yix chi woʼor ix nojnak, man coʼon panok qui tij numic. Toʼ i wach yix chi quix tzen woʼor man coʼon panok quix oʼ na rumal i bis. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Toʼ i wach yix we conojel i winak quiqui bij ix ʼutz laj winak. Xak queje xqui bij i catit qui mam chique i je aj tʼoronel ujer (ique chi toʼ xqui ʼan che quib pacha je ajbil u tzij i Dios). (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","I Jesus xak xu bij chique: —Yix chi quix tijin chu tayic in tzij, cwaj quin bij iri chiwe: Cʼax che i na i aj chʼoʼoj chiwij; chi ʼana i ʼutz chique i tzel quix quilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Chi tzʼonoj i ʼutz re i Dios piquiwi i que tzʼonow i cʼax piwi yix. Chi tzʼonoj che i Dios piquiwi i quix qui yoʼya. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","We ʼo jun cat u chʼay che juperaj a palaj, cha sujuj i juperaj chic che. We ʼo jun cu maj a chaquet, xak cha ya che we cresaj bi a camix. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","We ʼo jun cu tzʼonoj chawe wach i rajwaxic che, cha ya che; xak we ʼo jun cu maj ubitak awe, ma tzʼonoj chic che. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Pacha i cawaj yet chi quiqui ʼan i winak chawe, xak queje cha ʼana yet chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Yix, we xui cʼax que i na ique chi xak cʼax quix qui naʼo, mi chʼob ʼuri we ix ʼutz chuwach i Dios rumal. Xak i ajmaquib queje quiqui ʼan ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Xak, we xui qui ʼan i ʼutz chique i que ʼanaw i ʼutz chiwe yix, mi chʼob ʼuri we ix ʼutz chuwach i Dios rumal. Xak i ajmaquib queje quiqui ʼan ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Xak we ʼo i qui ya pa chaʼim xa rumal ca jach na chic chiwe, mi chʼob yix ʼuri quix ʼel ʼutz chuwach i Dios rumal. Xak queje i ajmaquib que chiʼman chiquiwach je ajmaquib, man quetaʼam ca jach na chic chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Xui-ri yix, cʼax che i na i je aj chʼoʼoj chiwij; chi ʼana i ʼutz chique; xak we ʼo qui ya pa chaʼim, miwoyʼej u qʼuexel. We qui ʼan niʼpa tak ile, nim i sipon qui rik na ʼuri, xak quix ʼelok ix racʼal i Dios chi ʼAtz u ʼIj. Lic ix racʼal ni ire, man xak queje cu ʼan ire, aj ʼanol ʼutz chique i je mal, xak chique i n-quiqui tioxij ta che. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Chi ʼana che iwib ʼo i cʼaxnabal i cʼux, xak jun ruʼ i Ta chicaj chi xak ʼo i cʼaxnabal u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Mi ʼat tzij piquiwi iwachiʼil, wach qui ʼanom, man xak n-cu ʼat ti tzij i Dios piwi yix; xak mi coj qui mac iwachiʼil, man n-cocsax ta i mac yix rumal i Dios. We ʼo i qui ʼanom qui mac chiwe, chi cuyu, man xak ca cuytaj na i mac yix. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Che i to niʼpa i ʼo rajwaxic chique, man i Dios xak cu ya na chiwe yix wach i rajwaxic chiwe. Ire qʼui cu ya na chiwe we qʼui i yom yix; lic cu nojsaj i coxtal yix, lic cu chʼaychʼa, xak cu laʼpuj, y mas cu ya puwi, tzubub cu ʼan che. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Teʼuri xu bij chic jun tijojbal tzij chique. Xu bij: —¿ʼO tak wa jun mawach cu binsaj rach mawach? N-taj; we queje ile quiqui ʼano, che queb que tzak bi pa jul. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jun, we are u tijoxel jun chic, n-nim ti u ʼij ire chuwach u tijonel. Xui-ri, i tijoxel, we xutzin u nawsaxic rib che, queʼel na ʼuri pacha u tijonel. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Ma takej jun ral tzʼil ʼo chupam u baʼwach awachiʼil, y awe yet n-ca na taj ʼo jun nim laj ʼet chupam. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Y yet, we n-ca coj ti retalil che i ʼet ʼo pa baʼwach, ¿wuchac ʼuri ca bij che awachiʼil: “Cuyu in mac, wachalal, cha ya a baʼwach chwe, cwesaj i tzʼil ʼo chupam” cat cha? Yet ¡n-katzij ti ca ʼano! Nabe chawesaj ni ʼet ʼo pa baʼwach yet, teʼuri cat tzun na chi relsaxic i tzʼil ʼo chupam u baʼwach awachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Jun ʼutz laj cheʼ n-tu wach cu yaʼo chi n-ʼus taj; xak i n-ʼus ta laj cheʼ, n-tu wach ʼutz cu yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ʼIs ca ʼalijin che u wach, we ʼutz laj cheʼ o we n-ʼus taj. Xak queje jun qʼuix: are cu ya u wach, n-cu wachij ti inum; xak queje jun qʼuix rixcʼak sacʼ, n-cu wachij ti tapal. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Jun achi we ʼutz, ʼutz i cu bij, man xui i ʼutz ʼo pu cʼux. Xak queje jun achi we n-ʼus taj, xui i n-ʼus taj cu bij, man n-ʼus ti ʼo pu cʼux. Queje ile queʼelok man ruʼ i ka chiʼ caka bij wach i ʼo pa ka cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yix ¿wuchac qui bij chwe, “Lic at Kajwal,” quix cha, xui-ri n-qui coj taj wach quin bij chiwe? ");
INSERT INTO acr_acc_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Jun, we ca cʼun wuʼ y cu coj retalil che in tzij, xak cu ʼan pacha i quin bij, yin quin bij na chiwe wach ca majaw ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Ire queje pacha jun aj ʼanol ja chi ʼutz laj cubibal xu coj che i rachoch. Nabe, naj xu wor u pam ulew cʼa xe u rika ni abaj; teʼuri xu coj i cubibal ja puwi abaj. Xoʼon panok, xnimar i ya, y xu ya li u choʼab che i ja. Xui-ri, i ya n-xtiqui ta chu bokic i ja man cul puwi abaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Xui-ri, jun, we u tom in tzij, péro n-xcojon ta che, ire pacha jun aj ʼanol ja chi n-xu coj ti u cubibal i rachoch. Ire toʼ xu cuba i rachoch chuwach ulew, n-tu cubibal xu yijba. Xoʼon panok, are xnimar i ya, xu ya li u choʼab che i ja; are ʼuri xtzak i ja pulew, y xsach u wach. (Queje i tijojbal tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","I Jesus, are xutzin u chʼaʼatic cuʼ i winak, xoc pa tinimit Capernaum. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Chila ʼo wi jun capitan aj Róma winak, chi ʼo jun u mocom ruʼ ja lic cʼax cu naʼo. I u mocom-le, lic iwab, ya ca camic. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","I capitan, are xu ta u tzijol i Jesus, xe u tak bi jujun nimak tak mamʼib ruʼ, chi je aj Israel winak. (I capitan, n-aj Israel taj.) Xe u tak bi chu tzʼonoxic chi ca ʼe ruʼ ja, ca ʼe cunax i u mocom. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ique, are xe upon ruʼ i Jesus, xe tejeb ruʼ, y ronojel qui cʼux xqui bij che: —I capitan-i lic ca majawic que a to na. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ire lic coj raj yoj chi oj aj Israel, xak xu yijba jun ja re i molbal kib —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Teʼuri i Jesus xa ʼe cuʼ. Are ya que upon ruʼ ja, xqui cʼulaj juban chic achiab chi quetaʼam u wach i capitan; ique je taktal li rumal ire. Xol qui bij u tzij i capitan che i Jesus. Queje iri u bim lok: —Nim laj winak, cha cuyu in mac; n-tu chac cat cʼun cʼa ruʼ ja. N-ca majaw ta chwe we cat oc chi wachoch, man n-nim ti in ʼij chawach yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Rumal-i, n-tu cowil in cʼux quin upon chawach. Xui-ri, we ca bij li yet, cutzir ni in mocom. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Wetaʼam ile, man xak yin in ʼo piquiʼab i je wajʼatzil, xak je ʼo juban soldádo pinʼab yin, y we quin bij che jun “¡Jat!”, ca ʼec; y we quin bij che i jun chic, “¡Saʼaj!”, ca petic. We xak quin tak bi jun wajchac, ire cu ʼan na wach i quin bij che. (Queje xqui bij ique ile che i Jesus, chi u bim li capitan.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","I Jesus, are xu ta wach u bim li capitan, lic xu bisoj. Xe u tzu i winak chi je teren chirij, y xu bij chique: —Mi tene jun chique i aj Israel winak cul u cʼux chwe pacha u ʼanom i achi-le —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","I ramig i capitan chi je u takom lok, xe tzalij chic ruʼ ja. Are xe uponic, xquil i achi utzirnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Xoʼon chupanok, i Jesus xa ʼe che jun tinimit, Nain u bi, cucʼam quib cuʼ u tijoxelab, xak cuʼ uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Are ya cuponic xe u cʼulaj juban winak cucʼam jun camnak, ʼenam-que chu mukic. I camnak-i, jun ala, xa jun chirij u chuch, chi ixok malcan. Je qʼui i winak aj tinimit que tijin qui ʼenam ruʼ u chuch chu mukic. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","I Kajwal Jesus, are xril i ixok, cʼax xu na u cʼux che. —Mat oʼic —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Are ʼuri xtejeb pan cuʼ, y xu yin i tzʼalam pa cotzʼol wi i camnak. I je ucʼawnak xe taqʼuiʼic. I Jesus xu bij che i camnak: —Ala, ¡Chat walijok! —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","I camnak juntir xcubi ʼanok, y xoc chi lapanic cuʼ. Teʼuri i Jesus xu jach bi che u chuch. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","I winak, are xquil ile, ʼis xe oc ʼil che. Xqui jek u cojic u ʼij i Dios: —Jun nim laj ajbil u tzij Dios cʼun-nak kuʼ yoj —xqui bij—. I Dios xoj ol u tobej yoj oj u winak ire —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Lic xel u tzijol i Jesus, wach ca tijin chu ʼonquil pa ronojel i jyub que i aj Israel winak, xak i chirij chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","I ma Wan aj kajsanel ya, i u tijoxelab ire qui bim che wach tak cu ʼan i Jesus. Rumal-i, xe u siqʼuij queb chique, ");
INSERT INTO acr_acc_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","xe u tak bi ruʼ i Jesus. Xu bij chique: “Jix ruʼ i Jesus y chi tzʼonoj che we are ire i Tolke chi koyʼem. Mokxa n-are taj, mok cʼa ca koyʼej jun chic,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","I u takon i ma Wan, are xe uponic, xe tejeb ruʼ i Jesus y xqui bij che: —I ma Wan aj kajsanel ya, xoj u tak lok col ka tzʼonoj jun tzij chawe. ¿Mok yet i Tolke chi u bim i Dios ca cʼunic? ¿O xa cakoyʼej chic jun chic? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Che i ʼij-le chi xe upon i u takon i ma Wan, i Jesus xe u cunaj uqʼuial iwabib. Niʼpa i cʼax ʼo chique, niʼpa i yobil ʼo chique, niʼpa itzel tew, ʼis xresaj chique. Xak je qʼui i mawach xe u tzunsaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Rumal-i, i Jesus xu bij chique u takon i ma Wan: —Jix ruʼ i ma Wan y chi bij che wach iwilom, xak wach i tom, chi quin tijin yin chu ʼanic. Chi bij che chi wumal yin, i mawach ya xe tzunic; xak i je sic, xe binic; xak i iwabib chi ʼo itzel cʼax “lepra” chique, xe utziric; xak i je tac, xe tanic; xak i camnak xe walijic; xak i nibaʼib qui tom i ʼutz laj tzij re i quelbal pa cʼax. (Are ile quin tijin chu ʼonquil.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Xak chi bij che, chi ʼutz que ique niʼpa n-quiqui sach ti u cubibal qui cʼux chwe —xu bij i Jesus chique u tijoxelab i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Are xe ʼe ique chi je u takom li ma Wan, i Jesus xu jek u bixquil chique i winak wach u ʼanom i ma Wan. —Yix, are xix ʼe che i jyub tzʼinilic que i tabej re i ma Wan, ¿wach xi bij yix que iwila? ¿Xix ʼe bawa chi rilic jun ʼes ca silab rumal i tew? N-are taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","¿Wach i xix ʼe chi rilic? ¿Xataba xix ʼe chi rilic jun achi, chom u wikic rib u ʼanom che u ʼuʼ? N-are taj. Niʼpa i ʼo qui ʼuʼ chom, pakalic, niʼpa i ʼis ʼo cuʼ wach tak quiqui rayij, ique ne te ʼo pa tak jyub, ique je jekel pa rachoch i ʼatol tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","¿Wach i xe iwila ʼut? ¿Jun ajbil u tzij i Dios? Katzij, are. I jun chi xiwilo-le, mas nim ni u ʼij chiquiwach i xa je ajbil u tzij i Dios chi je icʼawnak. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","I ma Wan-le are i jun chi u bim can i Dios chi cu tak na lok, ca nabeaj chuwach i Toliwe. I Dios u bim can chupam u wuj: Yin nabe quin tak na bi jun ajbil in tzij chawach yet, cu yijba ni a be chawach. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Chitapeʼ: i ma Wan aj kajsanel ya, nim ni u ʼij ire chiquiwach conojel i winak. Xui-ri, woʼor conojel niʼpa i que oc na pa ʼutz laj ʼatbal tzij re i Dios, mas ʼutz na que ique chuwach ire (man i ma Wan-le n-xril ti ʼatbal tzij re i Dios petnak waral chuwach i jyub taʼaj). (Queje ile xu bij i Jesus chique i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","I winak, are xqui ta ile, ʼis xqui bij chi Dios ʼutz i cu ʼano, xak queje xqui bij i aj tzʼonol alcawal ile, man ique ʼis xqui cojo wach i xu bij i ma Wan, xak xqui tzʼonoj u kajsaxic ya piquiwi rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Xui-ri, i je tijonel re i ujer ʼatbal tzij, xak i aj Fariséo n-xqui tzʼonoj ti u kajsaxic ya piquiwi. Rumal ʼuri ʼalaj chi xqui xutuj wach u yijbam i Dios chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","I Jesus xak xu bij chique i je ʼo chila: —I winak woʼor ¿wach tak que in junamsaj ruʼ? ¿Wach i que majawic? ");
INSERT INTO acr_acc_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ique xa je pacha acʼalab je cul xol tak be; jutzobaj que siqʼuin chique i cachiʼil: “Yix lic n-ta ʼo quiwaj,” quiqui bij. “Yoj xka xutʼij i suʼ chiwe, péro n-xiwaj ti xix xajawic. Teʼuri xka bixaj jun bix re i bisonbal, péro n-xix oʼ taj,” quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Queje que tijin i winak chu ʼanic woʼor; n-ta ʼo cacaj, man xcʼun i ma Wan aj kajsanel ya, chi n-ta wa cu tijo, xak n-ta víno cu tuʼu. Y qui bij yix, xa ʼo itzel tew ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Are xin cʼun yin in Achi aj Chicaj, ʼis ronojel quin tijo y quin tuʼu, y qui bij yix lic in aj numel, xak in aj ʼabarel, qui bij yix. Xak qui coj in mac chi yin in cachiʼil ajmaquib, xak i mal laj tak aj tzʼonol alcawal. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Xui-ri, we te xi ta u be wach cu ʼan i ma Wan, xak wach quin ʼan yin, quiwetamaj ʼuri chi Dios lic ʼo u noʼoj. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ʼO jun aj Fariséo ma Simon u bi, u bim che i Jesus que u tija i wa ruʼ. I Jesus xa ʼe ruʼ chi rachoch y xcubi chi waʼim. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Che i tinimit-le, ʼo jun ixok chi lic ajmac laj ixok. Are xu ta rason chi i Jesus ca tijin chi waʼim pa rachoch i aj Fariséo, ire xa ʼe cuʼ. Rucʼam bi jun chom laj baxo ʼantal che abaj pacha sakchoʼ, nojnak che cunbal muy. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Are xuponic, xqʼuiji che i rakan i Jesus. Xoʼic xqʼuiji chila. Are ʼuri xoc chu chʼajic i rakan i Jesus ruʼ uwal uwach, y xu su ruʼ u wi. Teʼuri xu tzʼubaj u wach rakan i Jesus, xak xu coj i cunbal muy che. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","I aj Fariséo chi ʼo i Jesus chi rachoch, are xril ire ile, xu bij pu cʼux: “I achi-le, n-ajbil tu tzij i Dios,” xu bij. “We tene are, cretamaj ʼuri bi chi ixokil ile chi cu yin i rakan-le; xak cretamaj ʼuri chi lic ajmac laj ixok.” Queje ile xu chʼob i aj Fariséo pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Teʼuri i Jesus xu bij che: —Ma Simon, ʼo jun tzij cwaj quin bij chawe —coʼono. —ʼUtz, Nim laj Winak, cha bij chwe —xu bij i aj Fariséo. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Teʼuri i Jesus xu bij jun tijojbal tzij che. Queje iri xu bij: —Je ʼo queb achiab ʼo qui cʼas ruʼ jun achi. I jun ʼo joʼob ciénto u cʼas ruʼ, i jun chic, xa cincuénta u cʼas ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ique n-que tiqui ta chic chu tojic; i achi xu cuy ʼuri i qui mac, y xu chup i qui cʼas. Cha bij pe chwe, ¿pachin chique i je queb-le ʼo ni mas cʼaxnabal u cʼux che i xcuyuw qui mac? (Queje xu bij i Jesus ile.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Teʼuri i ma Simon xu bij che: —Quin bij yin are i jun chi mas nim u cʼas chuptalic —xcha. I Jesus xu bij: —ʼUtz i xa bij —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","I Jesus xu takej i ixok, teʼuri xu bij che i ma Simon: —¿Cawil i ixok-i? ʼUtz i ca tijin chu ʼanic. Yet, are xin oc chi, che awachoch, n-ta ya xa ya chwe, chʼajbal re wakan. Xui-ri, i ixok-i, xu chʼaj i wakan ruʼ uwal uwach, y xu su ruʼ u wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Yet n-xin a tzʼubaj taj, tioxbal-we, are xin a cʼulaj. I ixok-i nu mayim ti u tzʼubaxic i wakan niʼpa i woquic lok. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Yet mi tene acéite xa coj che in jolom; xui-ri, ire u jamom ni cunbal muy rij wakan. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Queje ile, u ʼalijinsam chi lic cʼax quin u naʼo. I u ʼanom-i, cʼutbal-re che, chi qʼui u mac ya cuytajnak chic. Xui-ri, jun chi n-ta kas u mac cuytajnak che, ire n-ta kas cʼaxnabal u cʼux ʼuri. (Queje xu bij i Jesus ile che i ma Simon.) ");
INSERT INTO acr_acc_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Teʼuri xu bij che ixok: —I a mac ya cuytajnak chic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Teʼuri i juban chi que tijin che i waʼim xe oc chu bixquil chiquiwach: —¿Bi chi achial ire-le, chi xak cu cuy i qui mac i winak? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","I Jesus n-xu coj ta retalil wach xqui bij ique. Xu bij che i ixok: —At ʼelnak chupam a mac man xa cuba a cʼux chwe. Jat chi awachoch; mat cʼachir chic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Xoʼon chupan jubiʼ, i Jesus ca tijin chi qui solixic i tinimit, tak i aldéa, chu bixquil u tzij i Dios chique. Xu paxsaj i ʼutz laj tzij re u ʼatbal tzij i Dios chique i aj pa tak tinimit-le. I cablajuj rapostelab xak xe ʼe ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","3","Xak je ʼo jujun ixokib je terejnak bi chiquij chi je utzirsam rumal i Jesus. ʼO jujun chique, ʼelsam ni itzel tew chique, xak ʼo jujun chique chi je utzirsam na che tak yobil. Jun chique are i ati Mariy chi xak Magdaléna ca bix che. Are ire-le chi je wukub itzel tew ʼelsam na che rumal i Jesus. Jun chic chi xa ʼe cuʼ are i ati Wan, chi rixokil i ma Chus, jun achi nim u patan chirij i rey ma Heródes. Jun chic chi xa ʼe cuʼ are i ati Susan. Xak je qʼui chic i ixokib xe ʼe cuʼ, tobal-que ruʼ i qui mer ique wach i rajwaxic chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Je qʼui i winak xe ʼel pa qui tinimit chu tayic u tzij i Jesus. Ire, are xrilo xe moltaj mas i winak, xu bij i tijojbal tzij-i chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","—ʼO jun achi xa ʼe chu tiquic u ticon. Are xu quirij bi i rijaʼ, ʼo jubiʼ xtzak pa be. Rumal-i, xa xyaʼyax u wi che akan, xak xe cʼun i tzʼiquin y xqui tij bic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Xak ʼo jubiʼ chic xtzak pa abaj, y are xalax lok, xa xchakijic, man n-chʼenen ti ulew pa i ʼo wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Xak juban chic xe tzak pa qʼuix; i qʼuix xqʼuiyic y xu camsaj i ticon. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Xak ʼo ni ija xe tzak pa ʼutz laj ulew, y are xqʼuiyic xu ya ni u wach chom; ʼo ni rakan xu ya jun ciénto u wach. I Jesus, are xutzin u bixquil ile chique, co xsiqʼuin chu bixquil i tzij-i: —We yix ʼo i xiquin chu tayic, chi ta ʼuri u be —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Are ʼuri i u tijoxelab xqui tzʼonoj che wach usucʼ i tijojbal tzij-le chi xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ire xu bij chique: —Yix ʼut, Dios u yom chiwe chi qui ta u be i u ʼatbal tzij ire, chi n-xa ʼetamax ta ujer; xui-ri, i toʼ winak, xa ruʼ tijojbal tzij ca ʼani i cʼutunic chique, man queʼel chique chi que tan neri, péro n-quiqui ta tu be, que tzun neri, péro n-quiquil taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Teʼuri i Jesus xu bij chique: —Quin bij ʼuri chiwe wach usucʼ i tijojbal tzij xin bij-le. I ija-le chi xin bij, queʼelok are u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Niʼpa i ija chi xtzak pa be, queʼelok are i winak chi quiqui ta, xui-ri, ca cʼun ni itzel, y cresaj i tzij piqui cʼux. N-craj ti ire we quiqui coj i tzij chi qui tom, xak que ʼel chupam i qui mac rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Niʼpa i ija xtzak pa abaj, queʼelok are i winak chi quiqui ta i tzij, y que quicotic xqui cojo, péro je pacha ticon n-ta kas raʼ ʼenak pa jyub. Ique xa ʼatal ʼij que cojon che, y are ca pe jun cʼax piquiwi, cacoʼtaj canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Niʼpa i ija xtzak pa qʼuix je are pacha i winak chi quiqui ta i tzij, xui-ri are que ʼe chic, ʼo i ca chupsaw i ʼutz piqui cʼux: xa que cʼachir rumal i qui cʼaslemal waral chuwach i jyub taʼaj, xa quiqui tzucuj ubitak-que, xak xa quiqui chʼob i qui rayijbal; ile xa cu chup i ʼutz laj tzij piqui cʼux. Queʼelok je pacha ticon chi n-ca wachin taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Are ija chi xtzak pa ʼutz laj ulew, ile queje pacha i winak chi lic cacaj quiqui ta i ʼutz laj tzij, lic je sicʼaj chu cojic; n-quiqui mayij ti u ʼonquil wach i qui tom, cʼa ca wachin ni ʼutz pi qui cʼaslemal. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yix, are qui tzij jun cantil, n-qui chʼuk ta ʼuri u wi, xak n-qui min ta chuxeʼ i chʼat. Are i qui ʼano, qui ya ʼan chicaj, man niʼpa i que oc bi pa ja que tzun na. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Niʼpa i maja ca ʼalijinic, ca ʼalijinsax na; xak ronojel niʼpa uwam u wach ʼis quelsax na chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Rumal-i, chi cojo retalil wach quin bij. Jun, we ʼo na chic ʼo ruʼ, ca yaʼ na mas ʼuri che; xak queje i jun, we n-ta ʼo ruʼ, ca ʼelsax na i jubiʼ che, chi cu bij ire ʼo ruʼ, —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Teʼuri i je u chaʼ i Jesus, chilam i u chuch xe upon ruʼ ja, pa ʼo wi ire. N-xe oc ta ruʼ, cumal i uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Teʼuri xbix che i Jesus: —I a chuch je ʼo chi sak, cuʼ a chaʼ —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","I Jesus xu bij ʼuri: —Je niʼpa i quiqui coj retalil che u tzij i Dios, xak que cojon che, je are ique je in chuch in chaʼ —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Che tak i ʼij-le, i Jesus xa ʼan pa bárco cuʼ u tijoxelab. Xu bij chique: —Joʼ, coj ʼax chʼakap che i alagun —xu bij. Xqui jek ʼuri ʼaxic chuwi ya. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Are que tijin chi be, i Jesus xwaric. Xak teʼet, xcʼun jun nim laj tew puwi i ya; i bárco xu ticba nojic che i ya. Laj xmuktaj rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Are ʼuri ique xe ʼe ruʼ i Jesus y xqui cʼastaj. Xqui bij che: —¡Tijonel! ¡Ka Tijonel! ¡Coj muktaj pa ya! —xqui bij che. I Jesus xwalijic y xu ʼatij i tew, i ya. Are ʼuri i ya n-xsilab ta chic, xak i tew; ʼis xe uxlanic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Teʼuri i Jesus xu bij chique u tijoxelab: —¿Wuchac xi sach u cubibal i cʼux? —coʼono. Ique, are xquilo, lic xqui xij quib, lic xqui bisoj. Xqui bij chiquiwach: —¿Bi chi achial ire-le, chi cu ʼatij i tew, i ya, y que cojon che? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Que tijin qui ʼenam chuwi ya, cʼa xe upon che i jyub, Gadára u bi. I jyub-le ca canaj chʼakap re i jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","I Jesus, are xkaj li pa bárco, xcʼun jun achi ruʼ, aj Gadára. I achi-le, ya ujer tan, ʼo juban itzel tew che. Rumal-i, lic n-tu ʼuʼ cu cojo, xak n-ruʼ ja ta jekel wi, xa chuwi tak camnak jekel wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Are xril u wach i Jesus, xu jek siqʼuinic, xuqui la chuwach, y co xu bij: —¿Wach col a tzucuj wuʼ yin, Jesus, chi at u Cʼojol i Dios ʼAtz u ʼIj? Lic quin tzʼonoj chawe, ¡min a ya pa tojpen! ");
INSERT INTO acr_acc_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Queje xu bij ile che, man i Jesus ca tijin chic chu bixquil che i itzel tew chi quel che achi. I itzel tew-le, nic are wi cu ya i u choʼab che i achi. I winak qʼuialmul qui chapom i achi y qui ximom i rakan y u ʼab ruʼ carena. Ire xa cu rakij, y ca ʼanmaj na pa tak jyub tzʼinilic, cʼamtal bi rumal itzel tew-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","I Jesus xu tzʼonoj che: —¿Wach a bi? —coʼono. —Legion in bi —xu bij. Queje xu bij i itzel tew ile, man je qʼui je ʼo che i achi. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","I tak itzel tew-le lic xqui tzʼonoj che i Jesus: —Moj a tak bi pa ka cʼujibal pu jyub —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Chu nakaj pa que chʼaʼat wi, je ʼo uqʼuial ak, que tijin chi waʼim chuwa tak jyub. I itzel tew lic xqui tzʼonoj che i Jesus chi cu ya chique que oc na chique i ak. Ire xu ya chique pacha xqui tzʼonoj; ");
INSERT INTO acr_acc_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","xe ʼel ʼuri che achi y xe oc chique i ak. Are ʼuri i ak xe ʼe paʼanem, xqui cʼak bi quib pa siwan, y xe tzak pa ya. Xe jiʼic, xe camic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","I je aj chajil ak, are xquil ile, xe ʼe paʼanem pa tinimit. Xqui jek u bixquil tzam tak ja, teʼuri xqui paxsaj rason ronojel i tinimit, wach xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","I winak, are xqui ta ile, ʼis xe ʼe chi rilic wach i xa ʼantajic. Are xe upon chila pa ʼo wi i Jesus, xquil i achi chi ʼelsam chic itzel tew che. Ire cul chuwach i Jesus; u cojom chic u ʼuʼ, ʼutz chic u noʼoj. I winak lic xqui xij quib rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Niʼpa i xquilo wach i xu ʼan i Jesus, xe oc chu bixquil chique i juban wach i rutzirsaxic i achi xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Are ʼuri, conojel i aj Gadára lic xqui tzʼonoj pawor che i Jesus chi quel chila pa Gadára, man lic xqui xij quib che. Rumal-i, i Jesus xoc chic pa bárco y xtzalijic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","I achi chi xel bi itzel tew che, lic craj ʼenam ruʼ, xui-ri, i Jesus n-xu ya ta che. Xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Chat tzalij chi awachoch y cha lapa niʼpa i u ʼanom i Dios chawe —coʼono. Teʼuri i achi xa ʼec; ʼis xu paxsaj pa tinimit wach i nim laj ʼutz xa ʼani che rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","I Jesus, are xa ʼax chic chʼaka ya, i winak lic que quicotic xqui cʼulaj. Conojel lic coyʼem ni u cʼunic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Are ʼuri, xupon jun achi, ma Jáiro u bi; nim u patan pa molbalʼib que i aj Israel winak. Ire xuqui chuwach i Jesus, lic xu tzʼonoj che chi ca ʼe ruʼ pa rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Queje xoʼon ire ile, man ʼo jun u miʼal ya ca camic. I racʼal-le, xa jun chirij, ʼo cablajuj junab che. I Jesus, are ca tijin chi be, je qʼui i winak je teren chirij; ire lic ca pitzʼpat chiquixol. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Chiquixol i winak-le, ʼo jun ixok iwab. ʼAx iwab wi; cablajuj junab ʼo chic i yobil che; n-ca tani ta chic. Ire u sachom chic ronojel u mer cuʼ i doctor; mi jun xtiqui chi rutzirsaxic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ire xtejeb pan chirij i Jesus xu yin pan u chiʼ u ʼuʼ. Are ʼuri xtani i u quiqʼuel. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","I Jesus xu bij: —¿Pachin xin u yino? Y conojel xqui bij: —N-yoj taj —xe cha. I ma Pédro, cuʼ i rachiʼil xqui bij che i Jesus: —Ka Tijonel, lic je qʼui i winak cat qui pitzʼo, cat qui tacpuj, ¿y yet ca tzʼonoj chake pachin xat u yino? ¿Wach retamaxic caka ʼan yoj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","I Jesus xu bij: —Katzij ʼo ni xin yinawic, man xin naʼo ʼo ni xwutzirsaj ruʼ in choʼab —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","I ixok, are xu ta ile, xrilo chi Jesus retaʼam chic wach u ʼanom che. Ire, ca sicsatic, xuqui chuwach i Jesus, y xu bij che chiquiwach conojel i winak wach rumal xu yin u ʼuʼ. Xak xu bij chi juntir xutziric. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Teʼuri i Jesus xu bij che: —Wacʼal, xat utziric rumal u cubibal a cʼux chwe. Jat, mat cʼachir chic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Cʼa ca chʼaʼat i Jesus are xupon jun aj ruʼ ja re i ma Jáiro chi achi nim u patan pa molbalʼib. Xu bij che u patron: —I a miʼal ya xcamic; n-ta chic u chac we ca ʼe i tijonel awuʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Are xu ta i Jesus ile, xu bij che i ma Jáiro: —Mat oc ʼil che, xui cha cuba a cʼux chwe, y awacʼal cutzir na —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Are xupon ruʼ ja, n-xu ya ta chique i winak que oc bi ruʼ pa ja. Xui xoc bi i ma Pédro cuʼ i ma Jacóbo, y ma Wan, xak i u kajaw i u chuch i ali. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","I winak ʼis que oʼic, que siqʼuinic rumal i camnak. I Jesus xu bij chique: —Mix oʼic; i ali n-camnak taj. Ire xa ca waric —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","I winak xa xqui tzeʼej che, man quetaʼam ique chi camnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","I Jesus are ʼo ruʼ i ali, xu chap u ʼab y co xu bij che: —Ali, ¡Chat walijok! —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Are ʼuri xcʼun sak chuwach, y juntir xwalijic. Teʼuri i Jesus xu bij chique chi quiqui ya u wa i ali. ");
INSERT INTO acr_acc_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I u chuch u kajaw lic xqui bisoj. I Jesus xu bij chique chi mi xa ta jubiʼ quiqui lapo wach xoʼon che i ali-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","I Jesus xe u mol i cablajuj u tijoxelab ruʼ y xu ya qui choʼab, xu ya piquiʼab, caquesaj itzel tak tew, que cutzirsaj iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Teʼuri xe u tak bi chu paxsaxic i ʼutz laj tzij re u ʼatbal tzij i Dios, xak chi cutzirsaxic iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Xu bij chique: —Are quix ʼec, n-ta qui cʼam bic re i be, mi tene i chʼamiy, xak mi ne i teb, mi ne i wa, mi ne i mer, xak mi ne ucab i camix qui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","We xi riko pa i quix cʼulax wi, chila chix canaj wi cʼa quix el na chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","We ʼo ni tinimit chi n-quix qui cʼulaj taj, chix el chila. Are quix el che i tinimit-le, chi pu can i ulew che iwakan chila, cʼutbal-re chique i winak chi cʼo qui mac chiquij. (Queje u pixbanic i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Ique xqui maj qui be; xe ʼe chu solixic ronojel tak i aldéa re i jyub-le. Xqui paxsaj u tzijol i ʼutz laj tzij re i Dios, xak xe qui cunaj iwabib ronojel i jyub-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","I ma Heródes, chi ʼatol tzij, xu ta u tzijol wach ca tijin i Jesus chu ʼonquil. Ire lic xcʼachir chu chʼobic pachin ire-le, man je ʼo jujun quiqui bij chi are i ʼetz ma Wan aj kajsanel ya, xcʼun chic sak chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Xak ʼo juban chic quiqui bij are i ujer ajbil u tzij i Dios, mam Elías, xcʼunic; xak ʼo juban chic quiqui bij are jun chic ajbil u tzij i Dios ujer chi xcʼun chic sak chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","I ma Heródes xu bij: —Yin mísmo xin tak i relsaxic u jolom i ma Wan. ¿Pachin ʼuri i achi-le chi qʼui i nimak tak ʼanic u ʼanom, in tom yin? Queje ile xu bij i ma Heródes, y xu tzucuj wach rilic i Jesus cu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","I u tijoxelab i Jesus are xe tzalij li che i qui solinic pa tak tinimit, xqui bij che i Jesus ronojel wach tak i xqui ʼano. Teʼuri ire xa ʼe cuʼ, xe u cʼam bi quituquel cʼa chu nakaj i tinimit Betsáida. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Queje ile xqui ʼano, xui-ri, i je uqʼuial winak xqui ta rason, y xe terej bi chiquij. Ire xe u cʼulaj ruʼ, y xoc chu bixquil chique wach u ʼatbal tzij i Dios, xak xe rutzirsaj niʼpa i iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Are ya ca kaj i ʼij, i cablajuj u tijoxelab i Jesus xe tejeb pan ruʼ, y xqui bij che: —Che a ʼijla bi i winak-i. ʼUtz que ʼe chi tak ja pa tak aldéa nakaj, chu tzucuxic wach quiqui tijo, xak pa i que war wi. Waral pa oj ʼo wi lic tzʼinilic jyub —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","I Jesus xu bij: —Chi ya yix chique wach i quiqui tijo —coʼono. Ique xqui bij: —N-ta kuʼ yoj wach caka ya chique; xui joʼob caxlanwa ruʼ queb car ʼolic. ¿Cawaj nawa yet que ka loʼo wach i quiqui tij niʼpa i winak-i? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Colo je joʼob mil qui qʼuial achiab je moltajnak. I Jesus xu bij chique u tijoxelab: —Che i cuba pa tak tzobajil; cincuénta achiab pa tak tzobajil chi ʼana chique —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Queje xqui ʼan ile, xe cubi conojel. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","I Jesus xu chap i joʼob caxlanwa ruʼ i queb car; are ʼuri xtzun chicaj y xu tioxij che i Dios puwi. Teʼuri xu piro y xu ya chique u tijoxelab, quiqui jachbej-re chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Conojel xqui tijo, ʼis xe nojic. Are xquelej, xqui mol i chʼakatak, y xnoj cablajuj coban che i xsobrinic. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","I Jesus ca tijin chu tzʼonoxic che i Dios; xui i u tijoxelab je ʼo ruʼ. Teʼuri xu tzʼonoj ire chique: —¿Wach quiqui bij i winak chi in pachin yin? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ique xqui bij che: —ʼO jujun quiqui bij chi yet at ʼetz ma Wan aj kajsanel ya, quiqui bij. Xak ʼo jujun quiqui bij chi yet at ujer mam Elías; xak ʼo juban quiqui bij mok at jun chic ujer ajbil u tzij i Dios, y xcʼun chic sak chawach —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Are ʼuri ire xu bij chique: —Y yix, ¿wach i qui bij, in pachin yin? —coʼono. I ma Pédro xu bij: —Yet at Crísto, i Tolke petnak ruʼ i Dios —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Teʼuri i Jesus lic xu bij chique chi mi jun quiqui lap wi we are ire i Tolque chi coyʼem. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Xak xu bij chique: —Yin chi in Achi aj Chicaj, ʼo u chac quin tij ni cʼax. Quin qui xutuj ni nimak tak mamʼib, junam cuʼ i cajʼatzil i sacerdóte, xak i je tijonel re i ujer ʼatbal tzij. ʼO u chac quin qui camsaj na, xui-ri, churox ʼij, quin walij tan chic —xu bij chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Teʼuri i Jesus xu bij chique conojel i winak: —Jun, we craj ca terej chwij, ʼo u chac mu chʼob chic rib, xui-ri ʼij ʼij ca terej na chwij tupu ca cam na rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Queje ile chu ʼana, man jun we xa cʼax cu na u cʼaslemal re i waral, xa cu sach ʼuri u cʼaslemal chi katzij. Xui-ri, we ʼo jun ca sachsax nu wach u cʼaslemal xa wumal yin, ca yaʼ ʼuri u cʼaslemal sakil che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Cha terej chwij, man jun, we cu chʼac ronojel i beyomal re u wach i jyub taʼaj, xui-ri we ca sachsax nu wach ire, o we xa ca sach ire, ¿wach cu chʼac ʼuri? N-taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","(Chi ʼana pen n-ca sachsax ta i wach pa qʼuisbal ʼij.) We ʼo jun ca qʼuix na chwe, we ca qʼuix na che in tzij, xak yin quin qʼuix na che ire are quin cʼun tan chic. Yin ʼut, chi in Achi aj Chicaj, lic quin cʼun chic ruʼ u ʼij u chomal in Kajaw, xak ruʼ qui ʼij qui chomal i loʼlaj ángel. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Katzij i quin bij chiwe, je ʼo jujun waral, chi n-que cam ta tan cʼa quiquil ni u jekanic i ʼatbal tzij re i Dios waral —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Colo wakib ʼij ricʼawic u bixquil ile, i Jesus xel puwi jun jyub chu tzʼonoxic che i Dios. Xe u cʼam bi i ma Pédro, i ma Jacóbo, i ma Wan ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tzʼakat ca tijin chu tzʼonoxic che i Dios, i u palaj lic junwi xtzunic, lic chom; i u ʼuʼ xoʼon sak, lic ca walchʼinic. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Xak teʼet, xe winakir queb achiab, que chʼaʼat ruʼ; je are i ujer mam Moises, xak i ujer mam Elías. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ique, ʼo jun chom laj sak chiquij chiquiwach y que tijin chu lapic wach i camic quicʼaw wi i Jesus pa tinimit Jerusalen. (Ruʼ u camic-le, coʼon na pacha u chʼobom i Dios, tobal que i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","I ma Pédro cuʼ i rachiʼil, ya coc qui waram, xui-ri, lic xpactaj i qui wach y xquil i u chomal i Jesus xak i queb achiab chi je ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","I queb-le are xqui ticba ʼenam, are ʼuri i ma Pédro xu bij che i Jesus: —Ka Tijonel, ¡ʼutz xoʼono oj ʼo chi! caka ʼan oxib i mujbal: jun awe yet, jun re i mam Moises, xak jun chic re i mam Elías —xu bij. I ma Pédro n-xu na taj wach i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Are ca tijin chi chʼaʼatic, xkaj li jutzobaj sutzʼ y xqʼuiji piquiwi. Lic xqui xij quib are xe sach chupam. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Chupam i sutzʼ-le xqui ta jun chʼawbal: “Iri are in Cʼojol chi lic cʼax quin naʼo; chi ta wach i cu bij,” xbix chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Are xu mayij chʼawic i tzij-i, xquil ique chi Jesus utuquel chic. Wach i xquil chila, ique n-xqui lap taj; che tak i ʼij-le, mi ta che jun xqui lap wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Chucab ʼij, are xe kaj li tzam jyub, xe qui cʼulaj uqʼuial winak, ʼenam-que chu cʼulaxic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ʼO jun achi chiquixol i winak xsiqʼuin che i Jesus: —Tijonel —xu bij— cha ʼana utzil chomal chwe, chawila ni wacʼal chwe. Xui jun wacʼal ile ʼo chwij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","ʼO jun itzel tew cu chapo, y xak teʼet ca siqʼuinic; coc chi sicsatic, y ca wokow u cʼaxaj rumal. Cu ʼan cʼax che, y xak pachalo croʼtaj canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Lic xin tzʼonoj chique i a tijoxelab caquesaj i itzel tew che, y n-xe tiqui ta che. Queje xu bij i achi ile che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","I Jesus xu bij: —¡Ay, yix chi n-tu cubibal i cʼux che i Dios; lic ix sachnak na! ʼO tan chi ʼij in ʼo iwuʼ, y yix n-ta i nawic. ¿Niʼpa nawi chic ʼij cʼa craj? —xu bij chique. Teʼuri xu bij che i achi: —Cha cʼama li awacʼal waral —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","I acʼal xu ticba tejeb bic ruʼ i Jesus; are ʼuri, i itzel tew xu tzaksaj chic pulew y xu sicsa tan chic; lic xcʼachir puʼab. I Jesus xu yaj i itzel tew, xrutzirsaj i ala, y xu jach bi che u kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Conojel i winak xqui bisoj i nim laj u choʼab i Dios. Tzʼakat xqui bisoj i winak wach i nim laj ʼanic xu ʼan i Jesus, ire xu bij chique u tijoxelab: ");
INSERT INTO acr_acc_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Chi ta u be bien wach i quin bij na, ma sach chi cʼux: Yin chi in Achi aj Chicaj, quin qui jach na piquiʼab i winak —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","I u tijoxelab n-xqui ta tu be wach usucʼ i tzij-le. Maja ca yaʼ chique quiqui ta u be. Xak xqui xij quib chu tzʼonoxic che wach usucʼ i tzij-le chi xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Xoʼon panok, i u tijoxelab i Jesus xe oc chu chapic quib chi tzij pachinok chique mas nim u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","I Jesus xu naʼo wach que tijin chu chʼobic, rumal-i xu cʼam pan jun acʼal y xu ya pu tzal. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Teʼuri xu bij chique: —Pachin jun cu cʼulaj i acʼal-i ruʼ, rumal i cʼaxnabal u cʼux chwe yin, are yin ʼuri quin u cʼulaj ruʼ. Pachin quin u cʼulaj yin ruʼ, xak cu cʼulaj ʼuri i Dios ruʼ chi in takawnak lok. Pachin n-tu ʼij chixol yix, are ire ʼatz u ʼij chiquiwach i rachiʼil. (Queje ile xu bij i Jesus chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Teʼuri i ma Wan xu bij che: —Ka Tijonel, xkil jun achi ca tijin chi relsaxic itzel tew ruʼ u cuxtaxic a bi yet. Yoj ʼut xka bij che chi chu mayij, man n-kachiʼil taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Xui-ri, i Jesus xu bij che: —Ile mi ʼatij; man jun, we n-coʼon ta chʼoʼoj chikij, ka cwenta yoj ʼuri —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Are ya cu rik i ʼij re u ʼenbal i Jesus chicaj, xu cowirsaj u cʼux y xu maj u be pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Xe u nabsaj juban aj takon quiqui tzucuj pan qui posar. Xe ʼe ique che jun aldéa u cwenta i jyub Samária. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Xui-ri, i aj Samária n-xqui cʼulaj ta cuʼ man xquilo chi ique je aj Israel winak ʼenam-que cʼa pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","I u tijoxelab, chi ma Jacóbo i ma Wan, are xquilo wach i xqui ʼano, xqui bij che i Jesus: —¿Kajwal, cawaj nawi yet caka kajsaj li ʼaʼ aj chicaj, porobal-que? ¿Caka ʼan na pacha xu ʼan i mam Elías ujer? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","I Jesus xu pisquilij rib y xe u yajo. Xu bij: —Yix n-iwetaʼam taj wach u noʼoj i u Tewal i Dios. Yix ix re ire, n-craj ti ire ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Yin chi in Achi aj Chicaj in cʼun-nak n-in ta aj sachol qui wach i winak; xin cʼunic man que wesaj na chupam i cʼax —xu bij. Teʼuri xe ʼax chic che jun aldéa. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Are que tijin chi be, ʼo jun achi xu bij che i Jesus: —Nim laj winak, quin ʼe na awuʼ xa ipa cat ʼe wi —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","I Jesus xu bij che: —(Cʼax i terejic chwij.) I yac ʼo qui jul; xak i tzʼiquin ʼo qui soc, xui-ri yin chi in Achi aj Chicaj, n-ta pa quin cotzʼba wi in jolom are quin uxlanic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","I Jesus xu bij che jun chic: —Chat terej chwij —coʼono. Xui-ri i achi xu bij: —Nim laj winak, cʼa te quin terej chawij we xcam in kajaw —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","I Jesus xu bij che: —Suʼ woʼor chat terej chwij. Niʼpa i je camnak (piqui cʼux), cha ya can piquiʼab ique quiqui muk ni qui camnak. Xui-ri yet ja paxsaj u tzijol i ʼutz laj ʼatbal tzij re i Dios —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Teʼuri ʼo jun chic xu bij che: —Nim laj winak, yin quin terej na chawij. Xui-ri, nabe cha ya na chwe que in ʼijla can i je ʼo chi wachoch —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","I Jesus xu bij che: —Suʼ woʼor chat terej chwij. Yet awetaʼam we ʼo jun ʼo rij abixbal, y xa ca taken chirij, n-sucʼul ti u chac quelic. Xak queje ile jun, we coc pu ʼatbal tzij i Dios, n-ʼus taj we cʼa cu takej wach u canam canok —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Teʼuri i Kajwal xe u cha chic je seténta, y xe u tak bi pa cacabil chuwach ire, que ʼe pa tak tinimit, que ʼe pa tak jyub, pa ca ʼe na wi ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Xu bij chique: —Katzij, lic nim i jachʼ ʼo chakawach, nim i cosech molic craj; i ajchaquib xa je queb oxib. Chi tzʼonoj ʼuri che i Rajaw i chac che u taka li rajchaquib chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Jix yix pa chac. Quix in tak bic pacha ix ral tak chij chiquixol i utiw. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Are qui maj i be, mi cʼam bi wach i qui tijo, xak mi ne i mer, loʼbal-re; xak mi cʼam chubi jumolaj i xajab; xak mi bay iwib pa tak be chi chʼaʼatic. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Niʼpa i ja pa quix oc wi, chi tioxij i rajaw ja, chi tzʼonoj i ʼutz re i Dios piquiwi niʼpa i je ʼo ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","I rajaw ja, we ʼutz u cʼux, ca qʼuiji i ʼutz-le puwi chi xi tzʼonoj che i Dios. Xak we n-ʼus ta i cʼulaxic quiqui ʼano, mi tzʼonoj ʼuri i ʼutz re i Dios piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","We xi riko pa i quix cʼulax wi, chix ʼol chila cʼa te qui canaj we xix el chila, toʼ mix bin chi tak ja. Wach quiqui sujuj chiwe tzuk-bal-iwe, chi tija y chi tuʼu. ʼUtz we quix qui tzuk na, man jun aj chac ca majaw che chi ca toj na man u chʼacom. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Are quix oc che jun tinimit, we quix qui cʼulaj, chi tija wach quiqui sujuj chiwe, xak ");
INSERT INTO acr_acc_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","che iwutzirsaj i iwabib je ʼo chila; chi bij chique i winak: “I ʼatbal tzij re i Dios ya ca jekanic, nakaj chic ʼo wi chiwe,” chix chok chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Yix, we xix upon che jun tinimit y n-quix qui cʼulaj taj, chix el ʼuri pa be y chi bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“I ulew re i tinimit yix chi xnaqʼui che i kakan, caka pu can chiwach; iri, cʼutbal-re chiwe, chikul yix ʼo wi i mac. Xui-ri, cha cʼun chi cʼux, i ʼutz laj ʼatbal tzij re i Dios ka sujum chiwe, y n-xiwaj taj,” chix chok chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Quin bij iri chiwe: pa qʼuisbal ʼij, nim i tojpen ca tzak na puwi i tinimit-le. Nim ni tojpen ca pe na puwi, chuwach i mal laj tinimit Sodóma —xu bij i Jesus chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Xu bij i Jesus chique i winak: —¡Toʼ i wach yix, ix aj tinimit Corazin! ¡Toʼ i wach yix, ix aj tinimit Betsáida! Nic are wi qui coj qui mac i queb tinimit Tíro y Sidon, man n-ta Dios cuʼ qui bij yix. Xui-ri, we tene in ʼanom uqʼuial milágro cuʼ ique pacha in ʼanom iwuʼ yix, ique ʼuri ya qui jalwachim tene chic-i i qui cʼaslemal; xak que bison tene-ri rumal i qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Xui-ri yix ni jalwachim ta i cʼaslemal; are ca cʼun i qʼuisbal ʼij, nim ni tojpen ca pe piwi, chuwach i tojpen chi ca pe piquiwi i je aj Tíro, i je aj Sidon. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Xak yix, chi ix aj tinimit Capernaum, qui chʼob yix lic ix ʼutz, ya mer quix oc chila chicaj, qui bij yix. Xui-ri, ya mer quix kaj pa ʼaʼ. (Queje ile xu bij i Jesus chique.) Teʼuri xu bij chique u tijoxelab: ");
INSERT INTO acr_acc_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","—Pachin jun lic cu coj retalil wach i qui bij yix, queʼel ʼuri che chi ca tijin chu cojic wach i quin bij yin; xak pachin jun quix u xutuj yix, queʼel ʼuri chi are yin quin u xutuj. Pachin jun quin u xutuj, queʼelok chi cu xutuj i Dios, chi in takawnak lok. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Xoʼon panok, xe tzalij li seténta, lic que quicotic. Xqui bij: —Kajwal, nim i choʼab xa ya pakaʼab. Xak ʼo ne li itzel tew xe ʼel chique i winak are xka cuxtaj a bi chique —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","I Jesus xu bij chique: —Xak i itzel, chi Satanas, xkaj u choʼab, xwil yin wach u tzakic pacha jun ray aj chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Katzij, nim i choʼab in yom chiwe: quix bin na piquiwi i cumatz, tak i sinaj, y n-ta cʼax quiqui ʼan chiwe. Quix tiqui che itzel, ronojel i u choʼab y n-ta cu ʼan chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Xui-ri, mix quicot che ile. Mix quicot rumal itzel tew chi que cojon chiwe, chi que ʼanmaj chiwach. Are, chix quicot che, chi tzʼibtal chic i bi chila chicaj. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Are ʼuri, i Jesus lic ca quicot rumal u Tewal i Dios; xu jek chʼaʼatic ruʼ i Dios. Xu bij: —Quin cʼamwaj, quin tioxij chawe, Ta, chi at rajaw i caj, at rajaw i ulew. Quin tioxij chawe man a yom chique i n-ti qui ʼij chi quiqui ta u be wach a chʼobom yet. Xui-ri awuwam u wach chique i ʼo qui noʼoj, chique i nimak qui nojbal. Queje xa ʼan ile, Ta, man queje ile cawaj yet —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Teʼuri xu bij chique i winak: —Ronojel niʼpa i ʼolic, in Kajaw u yom pinʼab yin. Mi jun retaʼam pachin i u Cʼojol i Dios, xui i Ta chicaj. Xak mi jun retaʼam pachin i Ta; xui yin chi in u Cʼojol wetaʼam, xak niʼpa i winak chi quin ʼalijinsaj i Dios chique, quetaʼam. Queje xu bij i Jesus ile chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Are ʼuri, i Jesus xe u takej i u tijoxelab. Xu bij chique ique quituquel: —ʼUtz iwe yix, rumal wach tak quix tijin chi rilic. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Quin bij iri chiwe: Je qʼui ajbil u tzij i Dios ujer, xak i nimak tak ʼatol tzij, xcaj rilic u wach, niʼpa tak i quix tijin yix chi rilic woʼor, péro n-xquil taj; xcaj te u tayic i tzij chi quix tijin yix chu tayic, péro n-xqui ta taj. (Queje ile xu bij i Jesus chique i u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ʼO jun tijonel re i ujer ʼatbal tzij, craj ire cu cʼam u pam i Jesus; xwalijic y xa ʼe ruʼ; xu tzʼonoj che: —Tijonel, ¿Wach i quin ʼan na, quin rikbej re in cʼaslemal chi n-tu qʼuisic? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","I Jesus xu laʼ u wach che: —¿Wach cu bij i ujer ʼatbal tzij? ¿Wach cawil yet che i wuj-le? —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ire xu bij: —Cu bij i u wuj i Dios, “Chawaj Awajwal Dios ronojel a cʼux, ronojel awanima, ronojel a nojbal, ronojel a choʼab,” cu bij. Xak cu bij: “Chawaj a loʼcʼanij pacha cawaj awib yet,” queje ile tzʼibtal canok —xu bij i achi. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Teʼuri i Jesus xi bij che: —ʼUtz i xa bij; we queje ca ʼan yet ile, ca rik ʼuri a cʼaslemal —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","I tijonel re i tzij pixab, craj ire lic ʼo u noʼoj quiquil ni winak; rumal-i xu tzʼonoj chic: —¿Je pachin in loʼcʼanij? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Are ʼuri i Jesus xu jek u bixquil jun tijojbal tzij che. Xu bij: —ʼO jun aj Israel xel pa Jerusalen, ʼenam-re pa Jerico. Are ca tijin chi be, xe u cʼulaj juban iliʼomab y xqui chapo. Xquelʼaj ubitak-re, xak i u ʼuʼ. Xqui ʼan cʼax che, laj xqui camsaj canok; y xe ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Jun rat u ʼonquil ile, ʼo jun sacerdóte xicʼaw che i be-le. Are xril i achi chi ʼantal cʼax che, xu sol u be chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Xoʼon chupanok, ʼo jun aj patan pa rachoch i Dios xak xicʼaw che i be-le. Are xupon chila pa ʼo wi i achi, xui xrilo, xak xu sol u be chuwach, y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Xoʼon chupan jubiʼ, ʼo jun achi aj Samária ca tijin chi be, xicʼaw ruʼ. Ire, are xrilo, lic cʼax xu na u cʼux, ");
INSERT INTO acr_acc_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","y xtejeb ruʼ. Xu cunaj i soctajnak che; xu coj acéite che, tak i víno. Y xu xim ruʼ cʼul. Teʼuri xu ya bi chirij u caway y xu cʼam bic; xu tzucuj u posar y xu chajij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Chucab ʼij, are ya cu maj u be, xu ya can mer che i rajaw i posar. Xu bij che: “Ca chajij i achi-ri chwe, y we n-coʼon ti mer-le, are quin tzalij chalok, quin yijba chawe,” xu bij. (Queje i tijojbal tzij ile xu bij i Jesus che i tijonel re i ʼatbal tzij.) ");
INSERT INTO acr_acc_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Teʼuri xu bij che: —Woʼor cha bij chwe wach ca chʼob yet che ile. ¿Pachin chique i je oxib-le xu ʼan u loʼcʼanij che i achi chi soctajnak cumal iliʼomab? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","I tijonel re i ʼatbal tzij xu bij: —Are i jun chi cʼax xu na i achi soctajnak —coʼono. Teʼuri i Jesus xu bij che: —Xak yet queje cha ʼana ile —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","I Jesus xu maj chubi u be, y xupon che jun aldéa pa ʼo wi i rachoch jun ixok, ati Márta u bi. Ire xu cʼulaj i Jesus ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","I ixok-le, ʼo jun u chaʼ, ati Mariy u bi. Ire xcubi chi rakan i Jesus, cu tabej-re wach i cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","I ati Márta, lic ʼo i cu ʼano, lic ca cʼachir rumal. Are ʼuri ire xtejeb pan ruʼ i Jesus. Xu bij che: —Kajwal, yin lic ʼo ni quin ʼano; in chaʼ n-quin u to taj. ¿N-ta coʼon ile chawe? Cha bij che chi quin u to —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","I Jesus xu bij che: —Ati Márta, lic latzʼabnak a wach ruʼ wach i ca ʼano, lic cat cʼachir rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Xa junacos ʼo u chac ca ʼano, pacha ca tijin i ati Mariy chu ʼanic. Ire u chom ni ʼutz chawach yet, chi cajwax che, y mi jun ca majaw che. (Queje xu bij i Jesus ile che.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","I Jesus ʼo che jun lugar, ca tijin chu tzʼonoxic che i Dios. Are xutzinic, ʼo jun chique u tijoxelab xu bij che: —Kajwal, cha cʼutu chake wach u tzʼonoxic caka ʼan che i Dios. Cha ʼana pacha i ma Wan, aj kajsanel ya; ire xu cʼut chique u tijoxelab wach u tzʼonoxic che i Dios quiqui ʼano. (Queje ile xu bij che i Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","I Jesus xu bij: Yix, are qui tzʼonoj che i Dios, queje iri chi bij: Ka Kajaw chicaj, chocsax u ʼij a bi. Cha petsax a ʼatbal tzij pakawi; cha ʼana na waral chuwach i jyub taʼaj xak jun ruʼ pacha i ca ʼani chila chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Cha ya na chake i ka wa re woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Cha cuyu ni ka mac man xak yoj caka cuy ni qui mac niʼpa i je macun-nak chikij. Ma ya chake coj tzak chupam i mac atzalal, xui-ri, choj awesaj puʼab itzel. (Queje ile chi tzʼonoj che i Dios —xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Teʼuri xak xu bij chique: —We ʼo jun chiwe yix, tiqʼuil aʼab cupon jun rulaʼ, pent n-tu wa tzukbal-re. Rumal ʼuri ca ʼe ruʼ jun u loʼcʼanij y cu bij che: “Cuyu in mac, quin jal oxib a wa,” cu bij che, ");
INSERT INTO acr_acc_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","“man xcʼun jun wulaʼ y n-ti quin ya che, wach i cu tijo.” (Pent queje ile cu bij che.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","I u loʼcʼanij chi ʼo paja pent cu bij che, “Min a cʼascʼa. I uchija ʼo chic lawe che; i wacʼal je ʼo wuʼ chuwi chʼat, cʼax quin walij cumal. Rumal-i, n-ti quin ya chawe,” pent cu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Pent ire n-ca walij ta chu ʼanic jun pawor che u loʼcʼanij; xui-ri, we i jun n-cu mayij tu tzʼonoxic, i rajaw ja cawalij na ʼuri. Cu ya na che, wach i rajwaxic, man n-xu mayij tu tzʼonoxic che. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","ʼO jun tzij quin bij na chiwe: we ʼo rajwaxic chiwe, chi tzʼonoj, y Dios cu ya na chiwe; chi tzucuj, y qui rik na; chi cʼojcʼa i porta, y ca jak na chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Queje ile chi ʼana, man we jun lic cu tzʼonoj, ca yaʼ na che; we lic cu tzucuj, cu rik na; we lic cu cʼojcʼa i porta, ca jak na che. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Yix chi ix kajawxel, we ʼo jun iwacʼal cu tzʼonoj u wa chiwe, ¿xataba qui ya jun abaj che, pu qʼuexel u wa? N-queje ti ile. Xak we cu tzʼonoj car chiwe, ¿xataba qui ya jun cumatz che, pu qʼuexel? Xak n-queje taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Xak we cu tzʼonoj sakmol chiwe, ¿xataba qui ya jun sinaj che? N-queje taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Yix, chi n-kas ta ix ʼutz, lic ix sicʼaj chu yaʼic i ʼutz chique iwacʼal. Bay, we queje yix ile, chi xa ix winak, mas ʼutz coʼon i Ta chicaj chuwach ile. Lic cu tak li u Tewal chique pachin i que tzʼonow che. (Queje ile xu bij i Jesus chique i je teren chirij.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","I Jesus ca tijin chi relsaxic jun itzel tew che jun mem; are xelic, i achi xchʼawic. I winak lic xqui bisoj ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Xui-ri, ʼo jujun xqui bij: —I achi-le cresaj i itzel tew chique i winak xa rumal u choʼab itzel ʼo ruʼ. I choʼab ʼo ruʼ, xa re i Beelzebu chi cajʼatzil itzel tak tew —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ʼO juban chic cacaj quiqui cʼam u pam. Xqui tzʼonoj jun milágro che, cʼutbal-re chique we Dios ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ire retaʼam chic wach que tijin chu chʼobic, rumal-i xu bij chique: —Jun tinimit, we quiqui ʼan tak tzobajil che quib, quiqui ʼanbej chʼoʼoj chiquiwach, xa quiqui sach qui wach ʼuri. Xak queje juban alcʼwalaxel, we n-junam ti qui wach, we quiqui jach quib chiquiwach, ca sach qui wach. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Xak queje queʼel ile che i Satanas; we ʼo jujun itzel quiqui ʼan chʼoʼoj chiquiwach je itzel, n-que najtin ta ʼuri. Qui bij yix chi ruʼ u choʼab itzel xwesaj bi itzel tew. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Bay, i tijoxelab yix xak caquesaj bi itzel tew chique i winak; ¿pachin ʼuri yawnak ile piquiʼab ique? Ruʼ ile, chi quiqui ʼan i tijoxelab yix, ca ʼalijin ʼuri chiwe chi n-usucʼ taj wach i xi bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Are i u choʼab i Dios ʼo wuʼ, are i quelsaw bi itzel tak tew. Queje ile ca ʼalijinsax chiwe chi i ʼatbal tzij re i Dios ya ʼo chic chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","(Qui bij yix chi ruʼ u choʼab itzel, xwesaj bi itzel tew, péro n-ruʼ taj.) Iwetaʼam yix iri: we ʼo jun achi ʼo u choʼab, we lic cu chajij i rachoch, we xak ʼo ni rucʼam tobal-rib, n-ca sach ta ʼuri ubitak-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Xui-ri we ca cʼun jun chic mas nim ni u choʼab, ca tiqui na ʼuri che i rajaw ja. ʼIs cu maj na che wach i rucʼam, chajbal re i rachoch; cu maj na che wach i cul u cʼux che, tobal rib. Teʼuri cresaj niʼpa ubitak-re, y cu ʼan na che pacha craj ire. (Are i tijojbal tzij ile xu bij i Jesus chique, cʼutbal-re chique chi nim ni u choʼab ire chuwach itzel.) Teʼuri xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","—Pachin n-cu ya tu wach wuʼ, ire aj chʼoʼoj ʼuri chwij. Xak pachin jun n-quin u to ta chi qui molic in chij, xa que u quichersaj bi ʼuri qui wach chwe —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","I Jesus xak xu bij i tzij-i chique: —Jun itzel tew, we xel che jun winak, xa ca bin pa chakij jyub chu tzucuxic pa cuxlan wi, y n-cu rik taj. Teʼuri cu bij pu jolom: “Quin tzalij chic che i wachoch pa i xin pe wi,” cu bij, y ca tzalij chic ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Are cupon tan chic ruʼ achi, cu rik i pu cʼux i achi-le pacha jun ja lic josʼim, lic yijbam na che jun rajaw cʼacʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Teʼuri i itzel tew que u tzucuj bi i rachiʼil; que u rik je wukub, mas je mal chuwach ire. Que u cʼam bi ruʼ, y conojel que oc che achi. Chila que jeki wi. Teʼuri i achi-le, lic mas mal queʼel chuwach li ujer. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Are xutzin u bixquil ile chique, ʼo jun ixok ʼo chiquixol i uqʼuial winak, co xu bij: —¡ʼUtz re ixok chi xat alax ruʼ! ¡ʼUtz re ixok chi xat u tzʼumansaj! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","I Jesus xu laʼ u wach che: —Mas ʼutz que ique chi quiqui ta u tzij i Dios y quiqui cojo —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","I winak lic ca tijin qui moltajic chirij i Jesus. Ire xu jek u bixquil chique: —I winak je re woʼor lic je mal na: xa quiqui tzʼonoj jun milágro chiquiwach, cʼutbal re u choʼab i Dios, péro n-ta jun milágro ca ʼan na chiquiwach, xui ile pacha ʼantal che i ma Jonas, chi ajbil u tzij i Dios ujer; are i milágro-le quiquil na. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wach xa ʼani che i ma Jonas ujer are ʼilbal re i Dios chique i winak aj Nínive. Xak queje ile, wach quin ʼan ni yin, chi in Achi aj Chicaj, are i cʼutbal na re chique i winak re woʼor chi Dios ʼo wuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Cu rik ni ʼij, i winak je re woʼor, ca ʼat ni tzij piquiwi, wach i qui ʼanom. Are ʼuri, i ixok chi ʼatol tzij re i pa Sur ujer, ire cu coj ni qui mac rumal wach que tijin chu ʼonquil woʼor. Ire, ujer lic naj xpe wi chu tayic u nojbal i mam Salomon, chi mas ʼo u noʼoj. Péro i winak re woʼor n-cacaj ta quiqui ta i Jun cʼun-nak chi, chiquixol; nim ni u noʼoj chuwach i mam Salomon. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Are ca pe i ʼij chi ca ʼat ni tzij piquiwi i winak je re woʼor, i ujer aj Nínive winak quiqui coj ni qui mac i je re woʼor. Man i aj Nínive xqui jalwachij qui cʼaslemal are xqui ta u tzij i Dios rumal i ma Jonas; xui-ri, i winak re woʼor n-quiqui coj ta i Jun cʼun-nak cuʼ, chi nim ni u ʼij chuwach i ma Jonas. Rumal-i, cocsax ni qui mac —xu bij chique i uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","—Jun, we cu tzij jun cantil, n-cruwaj taj, xak n-cu min ta chuxeʼ jun cajon. Are i cu ʼano, cu ya ʼan chicaj, man niʼpa i que oc bic que tzun na. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","I baʼwach pacha jun cantil chiwe; rumal i baʼwach coc i sak che i chʼacul. We lic ʼutz i baʼwach, lic coc i sak ʼuri pi cʼux. Xui-ri, we i baʼwach n-coʼon ti u chac, ix ʼo ʼuri pa ʼekumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Chi ʼana cwent che i sak ʼo iwuʼ, mokxa toʼ coʼon ʼekumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","We lic ocnak i sak iwuʼ, ronojel i cʼux, ronojel i nojbal, we n-ta pichʼ ʼekumal chiwe, ronojel ʼuri ʼis sak chiwe, pacha coʼon jun cantil lic chom u tzunbal —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","I Jesus, are xu qʼuis u bixquil chique, are ʼuri ʼo jun aj Fariséo xu siqʼuij ruʼ chi rachoch man cu tij u wa ruʼ. I Jesus xa ʼec, xoc pa ja, y xcubi chi mexa. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","I aj Fariséo xu bisoj wach xu ʼan i Jesus, man n-xu chʼaj ti u kul u ʼab cʼa pu chʼuc are xoc chi waʼim, pacha quiqui ʼan ique. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Are ʼuri i Kajwal xu bij che: —Yix chi ix aj Fariséo winak, lic qui chʼaj i rij i tuʼbal ya, i rij i lak; xak lic qui ʼan pen u chʼajic i ʼab. Xui-ri i pi cʼux, lic tzʼil, niʼpa i ʼo i wuʼ ʼis iwelʼam, lic ix mal. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Yix n-ta i noʼoj! ¿N-iwetaʼam ta ba-ri chi n-xui ta i chʼacul u yijbam i Dios? ¡Xak u yijbam i pi cʼux! ");
INSERT INTO acr_acc_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Che i to i nibaʼib ruʼ u bitak iwe, chi ʼana i ʼutz ruʼ i cʼux; teʼuri xak i pi cʼux, chʼam na queʼelok; n-xui ta i ʼab, chʼam. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","¡Toʼ i wach yix, ix aj Fariséo! Niʼpa i ʼo iwuʼ chi n-ta kas u chac, ile ʼut qui ʼan pen i relsaxic jun tant che i lajuj, qui ya na che i Dios. Queje qui ʼan ile ruʼ i arawen, ruʼ i aruta, xak ruʼ i ral tak ʼes chi cu ya ni u jelal i comída. Xui-ri, n-qui ʼan ta pen u ʼanic i sucʼulic chuwach i Dios, xak mi ne i cʼaxnabal i cʼux che. Are ile ʼo u chac qui ʼan na, xak ʼo u chac chi qui jach i nabe tant che i Dios che i qui chʼaco. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","¡Toʼ i wach yix, ix aj Fariséo! Cʼax qui na i cubibal ʼo u ʼij pa tak i molbalʼib. Cʼax qui na i tioxixic cumal i winak pa qʼuebal, cojbal re i ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","¡Toʼ i wach yix, ix tijonel re i ʼatbal tzij, xak yix chi ix aj Fariséo! ¡Xa queb i palaj! Ix pacha jul re camnak, n-ca ʼalijin taj we ʼo camnak chupam. Toʼ que bin i winak puwi, y n-quetaʼam taj chi que quitzix na rumal. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ʼO jun tijonel re i ujer ʼatbal tzij xak xu ta wach xu bij i Jesus. Xu bij ʼuri che: —Tijonel, yet are xa bij i tzij-le, xak xoj a chʼachʼa ni yoj. Cʼax caka ta yoj ile —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","I Jesus xu laʼ u wach che: —Xak yix, ¡toʼ ni wach, ix aj tijonel! Yix, qʼui ni ʼatbal tzij qui ya chiquikul i winak, chi quiqui ʼan na; pacha jun ekan lic nim, chi mi jun ca chʼijawic, y yix mi xa ta jubiʼ que i to ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","¡Toʼ i wach yix! Yix qui yijba i chom laj qui pantion i ujer ajbil u tzij i Dios, xui-ri, lic are iwatit i mam yix xe qui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Queje ile qui ʼalijinsaj chi yix iwetaʼam wach qui ʼanom, xak i yom ni wach cuʼ. Ique xe qui camsaj; y yix qui yijba qui pantion. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","I Dios, mas ʼo u noʼoj; retaʼam li ujer wach i qui ʼan ni yix woʼor. Rumal-i xu bij: “Que in tak bi i je ajbil in tzij cuʼ, xak i je wapostelab. Xui-ri, ʼo jujun chique que camsax na; xak je ʼo jujun ca ʼan ni cʼax chique,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","I winak re woʼor, quiqui toj na i qui camsaxic i je ajbil u tzij i Dios ujer. Je niʼpa i je camsam na cʼa chu xebal ʼij sak, i winak re woʼor quiqui tojo. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ʼIs quiqui toj na: quiqui toj ni nabe, chi u camsaxic i a-Abel; queje ile xpetic cʼa are xcamsax i mam Zacarías chi xqui camsaj pa rachoch i Dios, chuwach i lugar ʼo u ʼij. I winak re woʼor, ʼis quiqui toj ni ronojel, niʼpa i petnak lok cʼa chu xebal ʼij sak. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","¡Toʼ i wach yix, ix tijonel re i ujer ʼatbal tzij! Yix lic chikul ʼo wi u cʼutic i sak laj tzij chique i winak, xui-ri, n-qui ʼan taj. Queʼel chiwe pacha ʼo jun lawe piʼab, xui-ri n-qui jak ti uchija. Mi tene quix oc bi yix, xak mi ne qui ya chique i juban que oc bic. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Teʼuri lic xpe coywal i je tijonel re i ʼatbal tzij, xak i je aj Fariséo rumal wach i xu bij. Xe oc chu toʼtaxic, y xe oc chu tzʼonoxic uqʼuial tzij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Quiqui tzucuj tzaksabal-re che u tzij, cojbal re u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Che tak i ʼij-le, je qʼui i winak xe moltaj ruʼ i Jesus, lic je mil, je mil. Que bajbatic rumal qui qʼuial. Are ʼuri i Jesus xu jek chʼaʼatic cuʼ u tijoxelab. —Chi ʼana cwent che iwib, mokxa quix ʼelic pacha i je aj Fariséo, xa queb qui palaj. Ile pacha coʼon i cunbal re i caxlanwa. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Niʼpa i n-ʼalijinsam taj, ca ʼalijinsax na; niʼpa i uwam u wach, ca ʼetamax na. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Rumal-i, ronojel niʼpa i bim yix pa ʼekumal, ca tataj ni rason chi sak; niʼpa i bim na paja aliʼal, lic tzʼapim i uchija, ʼo i ca siqʼuin na chu bixquil chuwi tak ja —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Yix chi ix wachiʼil, quin bij ni iri chiwe: mi xij iwib chique i quiqui camsaj i chʼacul. Xui ile que tiqui chu ʼonquil; n-que tiqui ta chu camsaxic iwanima. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Yin quin bij na chiwe pachin che, chi xija iwib: chi xija iwib che i Dios; ire, we xix camsaxic, ʼo puʼab quix u ya pa ʼaʼ. Are, chi xija iwib che ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","(I Dios quix u chajij.) Iwetaʼam chi jun tzʼiquin n-pakal taj, xa queb centávo i cajil je joʼob. Péro i Dios que u chajij, n-que u sach ta pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","(Xak queje yix, i Dios lic quix u chajij.) Ire ʼis rajlam niʼpa i wi ʼo che i jolom. Mi xij iwib ʼuri; yix ʼut, mas ʼo ni ʼij chiquiwach uqʼuial tzʼiquin —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Teʼuri xu bij chique: —Quin bij iri chiwe: niʼpa i qui yom qui wach wuʼ, we quiqui bij chiquiwach i winak chi je we yin, xak yin quin bij na chiquiwach i ángel re i Dios chi ique je in winak yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Xui-ri, je niʼpa i quiqui bij chiquiwach i winak chi ne te we yin, xak yin quin bij na chiquiwach i ángel re i Dios chi ique ne te we yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","I winak, niʼpa i cʼax que chʼaw chwij yin, in Achi aj Chicaj, ile ca cuytaj na chique; xui-ri je niʼpa i cʼax que chʼaw chirij u Tewal i Dios, i mac-le, lic n-ta u cuytajic. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Coʼon panok, i je aj chʼoʼoj chiwij, quix qui cʼam nubi chuwach i nimak tak mamʼib pa molbalʼib, chuwach i ʼatbal tzij, o xak chiquiwach i ʼatol tzij. Are quiqui ʼan ile, mix cʼachir tan chu chʼobic wach i tobal iwib qui ʼano, mix cʼachir tan wach i qui bij chiquiwach, ");
INSERT INTO acr_acc_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","man i u Tewal i Dios cu cʼut na chiwe wach i qui bij, are cu rik i ʼor-le. (Queje xu bij i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ʼO jun achi chiquixol i winak xu bij che i Jesus: —Tijonel, cha bij che i watz chi cu jach ni nicʼaj-we re i ubitak-re in kajaw, chi xcanaj can puʼab ire, are xcamic. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Teʼuri i Jesus xu bij che: —Achi, n-are ta in patan yin quin ʼan juez che wib piwi chu yijbaxic ile chiwe —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Teʼuri xu bij chique conojel: —Chi ʼana cwent, mokxa qui ʼan che iwib xa ix rayinel, xa ix molonel re ubitak iwe; man n-rumal ti uqʼuial ubitak iwe ʼo i cʼaslemal sakil —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Are ʼuri xu bij jun tijojbal tzij chique: —ʼO jun achi beyom; i rulew, qʼui i cosech xu yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ire xu jek u chʼobic ʼuri: “¿Wach i quin ʼano? ʼUtz we tene mas nim i cʼolbal-re,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Teʼuri xu chʼob pu cʼux: “Wetaʼam chic wach i quin ʼano; quin wulijsaj i cʼolbal re in cosech, teʼuri quin ʼan juban chic mas nimak chuwach ile. Quin cʼol niʼpa in cosech chupam, tak i juban ubitak-we. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Teʼuri quin bij che wib: lic ʼutz we yin, man ʼo ni ronojel wuʼ, wach i rajwaxic chwe qʼuial junab u wach. N-quin chacun ta chic, toʼ quin uxlanic, xui chic quin tij in wa, quin tij in yaʼ, y quin quicot na. Queje ile quin bij na,” xu bij i achi pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Are ʼuri i Dios xu bij che: “Achi, ¡laj at buy! Woʼor chaʼab, cat camic. I niʼpa i ubitak awe chi a cʼolom-na ¿pachin nawi re?” xu bij i Dios che. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Queje ile queʼel chique niʼpa i toʼ quiqui chʼob u molic i qui beyomal. Xa je nibaʼ ʼuri chuwach i Dios —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Teʼuri xu bij chique u tijoxelab: —Rumal-i, mix cʼachir che i cʼaslemal, wach i qui tijo, tzukbal iwib, xak mix cʼachir che i ʼuʼ, wach i qui cojo, chʼukbal i iwij. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","I cʼaslemal, ¿xataba xui i wa cajwax che? Xak i chʼacul, ¿xataba xui i ʼuʼ cajwax che? N-xui taj. ʼO i mas cajwax na chiwe chuwach i wa, xak i ʼuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Chi chʼobo ʼut wach quiqui ʼan i chʼoc: ique, n-ti quiqui tico, xak n-ti quiqui molo, xak n-ti quiqui cʼol pu cʼolbal-re. Tupu n-quiqui ʼan taj, i Dios que u tzuku. Y mas lic nim i ʼij yix chiquiwach ique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","We toʼ qui cʼachirsaj iwib, n-ta cu chacuj. Mi jun chiwe ca tiqui chu nimarsaxic u najtil rij, tupu lic ca cʼachir che. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","We n-quix tiqui ta chu ʼonquil ile chi n-ta kas u chac ¿wuchac ʼuri lic quix cʼachir che wach i qui tijo, xak i chʼukbal iwij? ");
INSERT INTO acr_acc_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Chi chʼobo ʼut wach quiqui ʼan i cotzʼij. Ique n-que cʼachir ta chu chʼaquic qui ʼuʼ, xak mi ne u yijbaxic. Tupu n-quiqui ʼan taj, lic chom qui ʼuʼ. Quin bij chiwe: chom ni qui ʼuʼ ique chuwach i u ʼuʼ i nim laj ʼatol tzij, mam Salomon ujer, chi lic beyom. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Queje cu ʼan i Dios ile chique i cotzʼij pa tak ʼes, chi xa queb oxib ʼij ʼolic: woʼor cʼaslic, y chwek cʼatnak chic pa ʼaʼ. Ire we cu ya i chom laj u ʼuʼ i ral cu cotzʼij-le, ¿xataba n-cu ya ta ʼuri iwe yix? Cu yaʼo, pues. ¡Yix cʼo i rajwaxic che u cubibal i cʼux che i Dios! ");
INSERT INTO acr_acc_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","We queje coʼon i Dios ile, mix cʼachir ʼuri chu tzucuxic wach i qui tijo, wach i qui tuʼu. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Niʼpa tak ile, are i quiqui tzucuj i toʼ winak. Péro yix, ʼo jun i Kajaw chicaj lic retaʼam wach i rajwaxic chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Rumal-i, chi ya iwib che i ʼutz laj ʼatbal tzij re i Dios, teʼuri ire cu ya na chiwe wach tak rajwaxic chiwe. (Queje xu bij i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Teʼuri xu bij chique: —Mi xij iwib, ix ral in tzobajil, yix n-ix ta qʼui. Xui-ri, i Ta chicaj craj cu ya chiwe quix oc che u ʼatbal tzij ire. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Chi cʼayij ubitak iwe, y chi jacha i mer chique i ʼo rajwaxic chique. Queje ile qui cʼol i mer pa yabal-re chi n-ca jar taj; queje ile, qui cʼol i beyomal chila chicaj, pa n-ca qʼuis ta wi; chila n-coc ta wi iliʼom, xak n-que oc ti pocʼ ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Queje chi ʼana ile, man pa ʼo wi i beyomal, chila ʼuri ʼo wi i cubibal i cʼux. (Queje xu bij i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Teʼuri xu bij chique: —Chix ʼolok ix yij chic, are ca cʼun i Iwajwal; ix ʼolok i tzijom i cantil chu cʼulaxic. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Chi ʼana yix pacha ix aj chajal ja chi coyʼem u cʼunic i qui patron che jun cʼulanquil. Ique je yij chic chu tayic u be; are cuponic, juntir quiqui jak uchija che, are que u ʼijla. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ʼUtz que i mocom chi que cʼascʼatic y que chajinic are cupon i qui patron. Quin bij iri chiwe: ire cu bij na chique chi que cubi chi mexa, teʼuri que u tzuk na. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Ire mokxa cupon tiqʼuil aʼab, o xa ca pe u sakiric; ʼutz que i rajchaquib we que cʼascʼatic are cuponic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Xak xu bij i tzij-i chique: —Chi ta iri: jun rajaw ja, we retaʼam wach u ʼonom ʼor cupon jun iliʼom ruʼ, ire ca cʼascʼat na ʼuri; n-cu ya ta che coc pa rachoch crelʼaj bi ubitak-re che, man ire yij na chu cʼacʼalixic. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Xak yix, chi cʼacʼalij na, man i Achi aj Chicaj ca cʼun na are n-ti qui chʼob che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Are ʼuri i ma Pédro xu tzʼonoj che: —Kajwal, i tzij xa bij-le ¿xui chake yoj xa bij, o xak chique i winak conojel? ");
INSERT INTO acr_acc_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","I Kajwal xu bij che: —(Chique niʼpa i je wajchac i xin bij-le.) Iwetaʼam wach ca ʼani che jun ajchac lic ʼutz, lic ʼo u noʼoj. Ire ca yaʼ na can piquiwi i juban ajchac rumal u patron. Chukul ire ʼo wi u yaʼic i qui wa are cu rik i ʼor. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ʼUtz re i achi-le we ca tijin chu ʼonquil wach i rajwaxic chique i ajchac are ca cʼun chali i u patron. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Katzij i quin bij chiwe, ire ca canax na ʼuri puwi ronojel i ubitak re u patron. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Xui-ri, we xa cu chʼob na chi u patron n-weʼ taj ca tzalij chalok, mokxa cu jek qui chʼayic i rach ajchaquib, chi achiab, chi ixokib. Mokxa toʼ u waʼim cu bisoj: wach cu tijo, wach cu tuʼu, wach tak ca ʼabar ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ire n-retaʼam taj bi chi ʼoril ca cʼun u patron; are n-ta cu chʼob che, xak teʼet ca cʼun chalok. I u patron; cu ya na ʼuri pa nim laj tojpen. Xak jun i tojpen ca yaʼ che pacha ca yaʼ chique i n-quiqui coj ti u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Jun ajchac chi retaʼam wach craj u patron, ire we n-cu yijba ta rib chu ʼonquil, we xak n-coʼon ta cas che, lic qʼui ni u loʼxic ʼuri cu tij na, tojbal re u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Xui-ri, jun ajchac, we n-retaʼam taj wach craj u patron, y we ʼo i u mac, lic ca majaw te che chi cu tij ni tojpen, ire n-mas ti u loʼxic cu tijo. Pachin jun, nim i yatal puʼab, ʼo chukul ʼuri nim cu jach tan chic che i rajaw; pachin jun, nim ni okxanim puʼab, ʼo chukul ʼuri cu jach tan chic che i rajaw, xak cu jach che niʼpa i u chʼacom puwi. (Queje i tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","—Yin in cʼun-nak chuwach i jyub taʼaj, in aj nucʼul ʼaʼ chi; ¡cwaj te yin we ta ca juluw chic! ");
INSERT INTO acr_acc_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Péro ʼo jun nim laj pen nabe chinwach; ¡lic quin cʼachir rumal, cʼa ca qʼuis ni ile! ");
INSERT INTO acr_acc_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Mi chʼob yix chi in cʼun-nak xa que in chomarsaj ni winak chuwach i jyub taʼaj. N-rumal ti ile in cʼun-nak; in cʼun-nak xa que in jachersaj qui wach (man rumal u cʼutic i sak laj tzij, are ca paxsaxic, ca pe ni chʼoʼoj chiquixol i winak). ");
INSERT INTO acr_acc_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Coʼon panok, we je ʼo joʼob cachalal quib, quiqui jachersaj ni quib; i je oxib quiqui junamsaj qui noʼoj chiquiwach i queb; xak i queb quiqui junamsaj qui noʼoj chiquiwach i oxib. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Je ʼo ni kajawxel, n-junam ta chic qui noʼoj cuʼ i qui cʼojol; xak queje ni cʼojolxel cuʼ i qui kajaw. Xak je ʼo ni chuchuxel n-junam ta chic qui noʼoj cuʼ i calit; xak queje quiqui ʼan ni calit cuʼ i qui chuch. Je ʼo ni alibaxel n-junam ta chic qui noʼoj cuʼ i qui chuch calib; xak queje quiqui ʼan na ique chique i cali-baxel. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","I Jesus xak xu bij chique i winak: —Yix, are quiwil i sutzʼ quel li pa ca tzak wi i ʼij, juntir qui bij chi ya ca pe i jab, y katzij, queje queʼelok. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Xak i tew, we ca cʼun pa sur, qui bij chi ca pe jun ʼij tij, quix cha; y katzij, queje ile queʼelok. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Yix, ¡xa queb i palaj! Lic quiwil nu be wach coʼon u wach caj, xak u wach i jyub taʼaj. ¿Wuchac ʼuri n-iwetaʼam taj wach usucʼ iri, chi quix tijin chi rilic che tak i ʼij-i? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Teʼuri xu bij chique i winak: —¿Wuchac n-qui chʼob tu be yix mísmo wach ca majaw chiwe qui ʼano? ");
INSERT INTO acr_acc_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","We ʼo jun u cojom a mac, y qui maj bi i be pa ʼatbal tzij, cha ʼana pen u yijbaxic ruʼ, tzʼakat cʼa ix ʼo pa be, man n-cat u cʼam tubi chuwach i juez. Man i juez cat u jach na che i policía, i policía cat u tzʼapij na pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sak laj tzij i quin bij, n-cat el tal chila, cʼa ca toj ni qʼuisbal centávo re a múlta. (Queje ile i tijojbal tzij xu bij i Jesus, cʼutbal re chique chi ʼo u chac weʼ quiqui sucʼba qui cʼaslemal chuwach i Dios man n-que yaʼ ta pa tojpen.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Are ʼuri je ʼo jujun chila xqui jek u bixquil che i Jesus wach u ʼanom i ma Piláto. Xqui bij chi ire je u camsam juban aj Galiléa winak are que tijin chu sujuxic qui sipon chuwach i Dios. Xe u camsaj, y qui quiqʼuel ique, junam xbin wi ruʼ i qui quiqʼuel i chicop chi qui sujum. Queje ile xqui bij i winak che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","I Jesus xu laʼ u wach chique: —Qui bij yix i je aj Galiléa winak-le lic ʼo qui mac chuwach i Dios; are i rumal ʼuri xqui tij i tojpen-le, qui chʼob yix. Ique mas je ajmac chiquiwach i cach aj Galiléa, qui bij yix. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Xui-ri, quin bij chiwe chi n-queje taj. Xak yix, we n-qui jalwachij ti i noʼoj chi n-ʼus taj, xak quix cam ni yix. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿Xak queje bawa qui bij yix chique i je dieciócho chi xe cam chuxeʼ i ja tacʼtic chi xtzakic? ¿Qui bij bawa yix, mas ʼo ni qui mac ique chiquiwach i juban aj Jerusalen? ");
INSERT INTO acr_acc_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Yin quin bij chiwe chi n-are taj. Xak yix, we n-qui jalwachij ti i noʼoj chi n-ʼus taj, xak quix cam ni yix. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","I Jesus xu bij chic jun tijojbal tzij chique. Xu bij: —ʼO jun achi ʼo u cheʼlal hígo pa rulew. Xa ʼe chi rilic we ʼo u wach; n-ta xu riko. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Are ʼuri xu bij che u mocom: “Wilapeʼ, oxib junab iri quin tzucuj u wach, y n-ta quin rik che. Cha cʼatzij; toʼ coʼon latzʼ waral,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","I u mocom xu bij: “Nim laj winak, cha ya chic jun junab che. Quin cʼot na jubiʼ chuxeʼ, y quin coj awon che. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Queje na ile, mokxa cu ya ni u wach; we n-taj, teʼuri ca cʼatzixic,” xu bij i mocom che. (Queje i tijojbal tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","I Jesus ca tijin chu cʼutic chique i winak pa molbalʼib pa uxlambal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Chila ʼo wi jun ixok iwab, dieciócho junab ʼo chic che chi toʼ iwab rumal jun itzel tew. Ire toʼ luclic chic rij rumal, n-ca tiqui ta chu sucʼbaxic rij. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","I Jesus, are xrilo, xu siqʼuij ruʼ y xu bij che: —Nan, ya at utzirnak chic che a yobil —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Teʼuri, xu coj u ʼab puwi; are ʼuri i ixok juntir xsuqʼui rij, y xu jek u cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Are ʼuri i rajʼatzil i molbalʼib xpe roywal che i Jesus man xrutzirsaj i ixok pa uxlambal ʼij. Xu bij chique i winak: —ʼO wakib ʼij che i seman re i chacbal ʼij. Che i wakib ʼij-le, we quiwaj quix cʼunic qui-wutzirsaj iwabib, chix cʼunok. Xui-ri, mi ʼan ile pa uxlambal ʼij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Are ʼuri i Kajwal xu laʼ u wach che: —Yix ¡xa queb i palaj! Iwonojel yix, pa uxlambal ʼij qui tor ni jun i chicop, o jun i buru, qui yabej u yaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","We queje qui ʼan ile che jun chicop, mas ca majaw che i ixok-le, chi u muk u xiquin i mam Abraham xak jun iwuʼ yix. Mas ca majaw che ire, ca tortaj na pa cʼax. ʼO chic dieciócho junab che, chi yutʼtal u chʼacul rumal itzel. ¿Xataba n-ʼus taj cakesaj i yobil che we pa uxlambal ʼij? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Are xu bij i Jesus ile, i je aj chʼoʼoj chirij lic xe qʼuix che. Conojel i winak lic que quicotic rumal i nimak tak ʼanic xu ʼan i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Teʼuri i Jesus xu bij chique: —I ʼatbal tzij re i Dios ¿wach nawi quin junamsaj ruʼ, sakirsabal-re chiwe wach usucʼ? ");
INSERT INTO acr_acc_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Quin junamsaj ruʼ jun ija re mostas chi jun achi cu tic pa rulew. Ca poʼic, ca qʼuiyic, cu rik u nimal pacha jun cheʼ, teʼuri i tzʼiquin quiqui ʼan qui soc che tak u ʼab. (Queje i tijojbal tzij ile xu bij i Jesus chique, sakirsabal-re wach u qʼuiyaric i u ʼatbal tzij i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","I Jesus xak xu bij chique: —I ʼatbal tzij re i Dios ¿wach nawi quin junamsaj ruʼ? ");
INSERT INTO acr_acc_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Are ca cʼun chiquixol i winak, queje pacha coʼon i cunbal re i caxlanwa. Ile, we jun ixok cu chapo, y cu coj oxib almul arin ruʼ, teʼuri ca walij u wach i ʼor ronojel, tupu xa jubiʼ i cunbal ʼo ruʼ. (Xak queje ile coʼon i ʼatbal tzij re i Dios —xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","I Jesus ʼenam-re pa Jerusalen. Ca tijin chi be, are cupon che jun aldéa, o xak che jun tinimit, ire cu jek u cʼutic chique i winak je ʼo chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ʼO jun xtzʼonow che: —Nim laj winak, ¿ne te qʼui que ʼel chupam i qui mac? —coʼono. I Jesus xu bij chique i winak: ");
INSERT INTO acr_acc_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Chi ʼana pen i oquic che u xol uchija lotʼlic; coʼon panok je qʼui neri cacaj oquic, péro n-que oc taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","I rajaw ja we u tzʼapim chic i uchija, n-cu jak ta chic chiwe. Yix chi ix ʼo can chi sak qui cʼojcʼa na, y qui bij pan che: “¡Nim laj winak, cha jaka i uchija chake!” qui bij na. Ire xa cu bij chiwe: “¿Pa ix petnak wi yix? Yin n-wetaʼam ta i wach,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Teʼuri yix qui bij na: “Yoj ka tijom i ka wa awuʼ, xak i ka yaʼ awuʼ; xak at cʼutun-nak pa ka tinimit,” quix cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ire cu bij tan chic chiwe: “N-wetaʼam taj pa tak ix petnak wi. Chix el na chinwach; xa ix aj ʼanol mal,” cu bij na chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lic quix oʼ na, lic qui kachʼachʼej ni iware are quiwilo chi yix xa chi sak ix ʼo wi, xak quiwilo chi paja je ʼo wi i mam Abraham, i mam Isaac, i mam Jacob; xak conojel i ujer ajbil u tzij i Dios ʼis je ʼo chila pa cu ʼat wi tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Je ʼo ni winak que uponic re ronojel u wach i jyub taʼaj; que uponic niʼpa i je aj pa relbal re i ʼij, i je aj pa kajbal re i ʼij; niʼpa i je aj pa wikabim, i je aj pa moxim; quiqui tij ni wa pa cu ʼat wi tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Chitapeʼ, je ʼo jujun chi woʼor je ʼo pa qʼuisbal-re; coʼon panok que nabeaj na; xak je ʼo jujun chi woʼor je nabe, xui-ri coʼon panok que canaj na pa qʼuisbal-re. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Che i ʼij-le, xe upon jujun aj Fariséo ruʼ, y xqui bij che: —Chat el chi, man i ma Heródes craj cat u camsaj —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Ire xu laʼ u wach chique: —Jix yix ruʼ i ma saklej u nojbal-le y chi bij che chi ʼo i quin ʼano. Woʼor y chwek que wutzirsaj i winak, xak cwesaj i mal laj tak itzel tew. Queje ile quin ʼan na, cʼa cabij, teʼuri ca qʼuis in chac. (Queje chi bij ile che.) ");
INSERT INTO acr_acc_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Xui-ri, yin, ʼenam we pa Jerusalen, woʼor, chwek, y cabij. N-quin mayij taj, man jun ajbil u tzij i Dios n-ca majaw ta che, we n-pa Jerusalen taj ca camsax wi —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","(Teʼuri xu bij chic:) —¡Ay, yix, ix aj Jerusalen! ¡Yix chi que i camsaj i ajbil u tzij i Dios; yix chi toʼ qui coj abaj chique i je u takon i Dios chiwe! ¡Qʼuialmul lic in rayim quix in mol wuʼ pacha cu ʼan jun ati acʼ cuʼ i racʼal, que u ya chuxeʼ u xicʼ! Queje ile xwaj te yin, y yix n-xiwaj taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Chitapeʼ, i tinimit yix coʼtax na can rumal i Dios. Quin bij chiwe, queje ile quix eʼel na; n-quiwil ta chic in wach cʼa cu rik ni ʼij chi quin i cʼulaj na iwuʼ. Qui bij na: “¡Chu ya ni ʼutz i Kajwal Dios puwi i Jun chi u takom-lok!” quix cha na. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Che jun uxlambal ʼij, i Jesus xa ʼe pa waʼim ruʼ jun cajʼatzil i aj Fariséo. Chila pa rachoch i jun-le, xak je ʼo juban chic aj Fariséo, que tijin chu cʼacʼalixic i Jesus, quiqui tzucbej u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Xak ʼo jun achi chuwach i Jesus, sipojnak u chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Are ʼuri i Jesus ʼo jun tzij xu tzʼonoj chique i je tijonel re i ujer ʼatbal tzij, xak chique i aj Fariséo. Xu bij chique. —I ʼatbal tzij tzʼibtal can rumal i mam Moises, ¿cu ya nawi chake caka cunaj jun iwab pa uxlambal ʼij, o n-cu ya taj? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ique n-xe chʼaw taj. Are ʼuri i Jesus xu chap i achi, y xrutzirsaj, y xu tak bi chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Teʼuri xu bij chique i aj Fariséo: —Yix, we ʼo jun i buru, o we ʼo jun i boyex, we tzaknak chupam jun siwan che jun uxlambal ʼij, ¿xataba n-quiwes-la ta-lok? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ique n-xqui rik ta chic u laʼic u wach che. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Teʼuri i Jesus xrilo chi ʼo jujun chique je siqʼuim che i waʼim, xa quiqui tzucuj i cubibal ʼo u ʼij are que cubi chi mexa. Are ʼuri xu bij jun tijojbal tzij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Yix, we ʼo jun winak quix u siqʼuij che jun nimaʼij re cʼulanquil, mix cubi che i cubibal mas ʼo u ʼij. Mok ʼo jun ca cʼun na mas ʼo u ʼij chawach yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Teʼuri ca cʼun i rajaw ja, chi ix u siqʼuim chix queb; mok cu bij chawe: “Cha ya a cubibal che i jun-le,” cu bij. Teʼuri yet toʼ cat qʼuix che, y cat ʼe chu tzucuxic jun a qʼuijibal n-tu ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Are i ca ʼano, we ʼo jun cat u siqʼuij che jun nimaʼij, jat ʼe cul che i qʼuijibal chi n-tu ʼij. We queje ca ʼan yet ile, i rajaw ja ca cʼun ʼuri awuʼ y cu bij chawe: “Ta, saʼaj ni jewa-ri, che jun qʼuijibal mas ʼo u ʼij, cu bij chawe.” Queje ile, cocsax ni a ʼij chiquiwach conojel i je cul awuʼ chi mexa. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Man pachin coʼon nim che rib, ire ʼut xa ca kajsax ni u ʼij; xak pachin coʼon chʼutin che rib, are ca nimarsax na ʼuri u ʼij. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Teʼuri xu bij che i jun chi je siqʼuiw-nak: —Yet, are ca ʼan jun waʼim, o jun cenar, me a siqʼuij ique chi at qui siqʼuim ni yet. Me a siqʼuij i xui awetaʼam qui wach, xak awatz a chaʼ; o xak xui i je awachalal, o xak i a loʼcʼanij chi je beyom, man ique xa cat qui siqʼuij tan chic cuʼ chi waʼim, y queʼelok chi qui tojom na chawe wach i xqui tij awuʼ yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Are i ca ʼano, are ca ʼan jun nim laj waʼim, che a siqʼuij i nibaʼib, che a siqʼuij i je sic, xak i je clis, xak i je mawach. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Queje ile, ca pe ni ʼutz pawi. Ique n-que tiqui ta chu tojic chawe, xui-ri i Dios cu toj na chawe are cu rik i ʼij chi que walij niʼpa i je ʼutz chuwach ire. (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Jun chique i je ʼo chila, are xu ta i tzij-le, xu bij che i Jesus: —¡ʼUtz que ique chi que oc che i nim laj waʼim pa cu ʼat wi tzij i Dios! —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","I Jesus xu bij che: —ʼO jun achi xu yijba jun nim laj waʼim, y xe u siqʼuij uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Are xu rik i ʼor, xu tak u mocom chu bixquil chique chi ʼis yij chic wach i quiqui tijo. “Chix petok, man ronojel ʼis yij chic,” xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Are ʼuri, conojel ʼis xe oc chu tzʼonoxic cuybal mac che. Jun xu bij: “Yin cʼa te in loʼom juban wulew, y ʼo u chac quin ʼe chi rilic; quin tzʼonoj chawe ca cuy na in mac,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","I jun chic xu bij: “Yin cʼa te in loʼom joʼob yunt in boyexab, y que ʼe wila we je ʼutz che i chac. Quin tzʼonoj chawe, cha cuyu in mac,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Jun chic xu bij: “Yin cʼa te in cʼulinak, rumal-i n-quin ʼe taj,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","I mocom, are xtzalij ruʼ u patron, ʼis xu bij che ronojel ile. Are ʼuri i patron xpe roywal, y xu bij che u mocom: “Cha bisoj, jat pa tak be re i tinimit, xak pa tak chʼut be; che a cʼama li ʼo i rajwaxic chique, xak niʼpa i je sic, xak i je clis, xak i je mawach,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","I mocom xa ʼe chu ʼonquil, teʼuri xcʼun chic ruʼ u patron y xu bij che: “Nim laj winak, ya ʼis xin ʼano pacha i xa bij chwe, y cʼo i qʼuijibal n-ta rajaw,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Are ʼuri i u patron xu bij chic che: “Jat tzam tak ja, cha tzucuj pa tak be chila, xak pa tak chʼut be, y cha ʼana li pen chique i je ʼo chila, man quin nojsaj ni wachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Tapeʼ, ique chi xe in tak qui siqʼuixic nabe, mi jun chique cu tij i waʼim chi in yijbam.” (Queje i tijojbal tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Je qʼui i winak je teren chirij i Jesus. Ire xu pisquilij rib y xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","—Jun, we ca cʼun wuʼ, we craj coʼon che rib jun in tijoxel, ʼo u chac mas cʼax chin u na ni yin chiquiwach i u kajaw, i u chuch, xak i rixokil ralcʼwal, xak i ratz u chaʼ, xak i je ranab. Jun n-ca tiqui ta chi terejic chwij, we n-cʼax ta quin u na yin chiquiwach ique. Xak n-ca tiqui ta chi terejic chwij we mas cʼax cu na rib ire chinwach yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","N-xui ta la ile, jun, we we-yin, ʼo u chac ca terej chwij, tupu ca cam na rumal. Pachin n-craj ti u ʼanic ile, n-ca tiqui ta ʼuri chu ʼanic in tijoxel che rib. (Queje xu bij i Jesus ile chique, cʼutbal-re we quiqui chʼij i terejic chirij.) Xak xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","—We ʼo jun chiwe craj cu yac jun nim laj rachoch, ire ca cubi na chu chʼobic niʼpa i mer rajwaxic che, mokxa n-coʼon taj cu qʼuisbej-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Queje ile coʼon-na, man mokxa xui i u cubibal cu yijba, y coʼon panok n-cu qʼuis taj. Niʼpa i que ʼilawic que oc chu yoʼyaxic, ");
INSERT INTO acr_acc_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","y que tzen chu bixquil: “I achi-le xu jek u ʼanic i rachoch y n-xtiqui ta chu qʼuisic,” que cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Xak we jun ʼatol tzij retaʼam chi petnak jun chic ʼatol tzij chi chʼoʼoj ruʼ, nabe ca cubi na chu chʼobic we ca tiqui che i chʼoʼoj, man ire xa je lajuj mil u soldádo; i jun chi col u ʼana chʼoʼoj, je véinte mil i u soldádo je rucʼam. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","We cu na u be chi n-ca tiqui ta che, que u tak bi juban u takon ruʼ i ʼatol tzij chi ya ca cʼunic. Tzʼakat i jun cʼa naj ʼo wi cu tzʼonoj che chi quiqui chomarsaj quib chiquiwach. (Queje i tijojbal tzij ile xu bij i Jesus chique i winak, man ʼo u chac quiqui chʼob na we quiqui chʼij i terejic chirij.) ");
INSERT INTO acr_acc_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Teʼuri xu bij chique: —Queje chi ʼana yix ile; man we n-qui canaj ta ronojel niʼpa ʼo iwuʼ, n-quix tiqui ta chi terejic chwij. ");
INSERT INTO acr_acc_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","I atzʼam, lic cu rik u chac chake, xui-ri we xsach i u tzayil, ¿wach u ʼonquil ʼuri coʼon tan chic tza? ");
INSERT INTO acr_acc_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Lic n-ta chic u chac. We ca coj chuwach ulew, n-cu to tu choʼab i ulew; xak we ca tix puwi juban u mul chʼe-quen re awon, xak n-cu to ta pichʼ u choʼab. Lic n-ta chic u chac; xui cʼakic chubi-re. Pachin ʼo u xiquin chu tayic, chu ta u be —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Je qʼui aj tzʼonol alcawal, xak juban chic ajmaquib xe tejeb ruʼ i Jesus quiqui tabej re u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Rumal-i, i aj Fariséo, xak i je tijonel re i ʼatbal tzij xe oc chu chʼachʼaxic i Jesus. —I achi-le que u cʼulaj ajmaquib ruʼ, y n-xui ta la ile, xak cu tij wa cuʼ —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Are ʼuri i Jesus xu bij jun tijojbal tzij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","—Chixol yix, we ʼo jun achi je ʼo cien u chij, y we xsach jun chique, ¿wach cu ʼan ʼuri ire? Que u canaj can i novénta y nuéve pa i je ʼo wi, y ca ʼe chu tzucuxic i jun. Cu tzucuj cʼa cu rik na. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Are cu riko, ca quicotic cu ya bi xol u teleb, y cu cʼam bi ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Are cupon ruʼ ja, que u siqʼuij i retaʼam qui wach, xak i je u loʼcʼanij, quiqui molbej quib ruʼ ire. Cu bij chique: “Lic quin quicotic, man xin rik in chij chi sachnak teʼek; ¡chix quicot yix wuʼ!” cu bij na chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Quin bij chiwe, xak queje quiqui ʼan i je aj chicaj ile; lic que quicotic we ʼo jun ajmac cu jalwachij u noʼoj chi n-ʼus taj. Mas que quicot rumal i jun-le, chiquiwach i je novénta y nuéve chi je ʼutz laj tak winak chi n-presis taj quiqui jalwachij i qui noʼoj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","(Teʼuri i Jesus xu bij chic jun tijojbal tzij chique.) Xu bij: —We ʼo jun ixok ʼo lajuj sak pwak ruʼ, we xu tzak jun chique i lajuj, ¿wach cu ʼan ʼuri ire? Cu tzij jun cantil, y cu jek u mesic u paja. Naʼal cu tzucuj cʼa cu rik na. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Are cu riko, que u siqʼuij i retaʼam qui wach, xak i je u loʼcʼanij, man quiqui molbej quib ruʼ. Cu bij chique: “Lic quin quicotic, man xin rik in mer chi in tzakom teʼek. ¡Chix quicot yix wuʼ!” cu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","I quicotemal-le, xak queje quiqui na i ángel re i Dios; que quicotic we ʼo jun ajmac cu jalwachij u noʼoj chi n-ʼus taj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Teʼuri, i Jesus xu bij chic chique: —ʼO jun achi, je ʼo queb u cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","I chaʼaxel xu bij che u kajaw: “Ta, cha ʼana jun utzil chomal chwe; cha ya ni ubitak-we woʼor pacha a chʼobom ca ya na chwe coʼon panok.” Queje ile xu bij che. Teʼuri i u kajaw xu jach bi ubitak-que chique i queb u cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Xoʼon chupan jubiʼ i chaʼaxel ʼis xu cʼayij ronojel ubitak-re chi xjach che. Teʼuri xu mol u chiʼ u mer y xa ʼe che jun tinimit cʼa naj. Chila xoc chu qʼuisic u mer, toʼ xak manal xu ʼano, y xu sach ronojel u mer. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Are xu qʼuis ronojel, xpe jun nim laj waʼjal che i tinimit-le pa ʼo wi ire; lic xu tij numic rumal. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Are ʼuri xa ʼe chu tzucuxic u chac ruʼ jun achi aj chila. I u chac xyaʼ che, xtak bi chi qui chajixic juban ak. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Ire lic xu tij numic; lic cu rayij u wach, wach que tijin i ak ruʼ; mi ta jun xtzukuwic. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Teʼuri xcʼun chic u noʼoj; xu bij pu cʼux: “Chila ruʼ in kajaw, i u mocom lic cu rik rib wach quiqui tijo. Y yin waral, lic quin cam na rumal numic. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Quin tzalij chic ruʼ in kajaw, y quin bij che: Ta, in ʼanom in mac chuwach i Dios, xak chawach yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","N-ca majaw ta chic ca bij awacʼal chwe, xui-ri, cha ʼana na chwe pacha jun a mocom, quin bij che.” Queje ile xu bij pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Juntir xu maj u be, y xa ʼe chic chi rachoch u kajaw. Are ya cuponic, xui-ri, cʼa naj panok ʼo wi che i ja, xak teʼet xa ʼiltajic y xa etamax u wach rumal u kajaw. Ire lic cʼax xu na u cʼojol, y xa ʼe paʼanem chu cʼulaxic. Are xu cʼulaj, xu tzʼulej, y xu tzʼubaj u palaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Teʼuri i u cʼojol xu bij che: “Ta, in ʼanom in mac chuwach i Dios, y xak chawach yet. N-ca majaw ta chic ca bij awacʼal chwe.” Queje ile xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","I u kajaw xa xu bij chique u mocom: “¡Chi bisoj! Chi cʼama li jumolaj ʼuʼ ʼutz, chom, y chi cojo chirij. Chi cʼama li bak re u wi u ʼab, xak i sapatux re i rakan. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Je i cʼama i meʼ chi ka tiʼojersam, y chi ʼana-re. ¡Caka ʼan jun nimaʼij! ");
INSERT INTO acr_acc_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","I wacʼal-i, chi camnak teʼek, woʼor cʼas tan chic. I sachnak teʼek, woʼor ya xcʼunic,” Queje ile xu bij u kajaw chique u mocom. Teʼuri xqui jek jun nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","I racʼal ʼatz n-ta ruʼ ja are xqui jek i nimaʼij, man ʼenak pa tak ticon. Are ca tijin u petic chi rachoch, xu ta i son, xak xu ta ʼo i que xajawic. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Rumal-i, xu siqʼuij jun mocom ruʼ, y xu tzʼonoj che wach i que tijin chu ʼanic ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","I mocom xu bij che: “I a chaʼ ya xcʼun chic ruʼ ja, rumal-i i a kajaw xu ʼan jun nimaʼij. Xu tak u camsaxic i meʼ tiʼoj, man ʼo tan chic a chaʼ ruʼ, n-ta cʼax che, lic ʼutz u wach,” xu bij i mocom che i ʼatz. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ire lic xpe roywal, y n-xoc ta chubi ruʼ ja. Rumal-i, xel bi i u kajaw, y xu yuʼuj i u cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ire-le xu laʼ u wach che u kajaw: “Tapeʼ, lic qʼuial junab in chacun-nak awuʼ pacha jun mocom, mi julaj in kelom a tzij. Y yet, mi ta julaj a yom jun ral chabat chwe, quin ʼanbej jun nimaʼij cuʼ i wachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Xui-ri, are xcʼun i awacʼal-i chi toʼ xu sach u wach ubitak awe cuʼ i mal laj tak ixokib, yet xa tak u ʼanic-re i meʼ tiʼoj, xa rumal ire.” Queje ile xu bij u cʼojol ʼatz. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Teʼuri xu bij i u kajaw: “Wacʼal, yet ʼax at ʼo wi wuʼ. Ronojel niʼpa i ʼo wuʼ, ʼis awe yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Xui-ri, ʼo u chac caka ʼan jun ka nimaʼij, y choj quicotok rumal a chaʼ. Ire camnak teʼek, y woʼor cʼas tan chic, ire sachnak teʼek, y woʼor ka rikom tan chic.” (Queje ile xu bij i mam che u cʼojol. Are i tijojbal tzij ile xu bij i Jesus chique i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","I Jesus, ʼo jun tzij xu bij chique i u tijoxelab. Xu bij: —ʼO jun achi beyom, ire ʼo jun u mocom u yom puwi ubitak-re. Xoʼon panok, i patron xu ta rason chi xak manal ca tijin chu ʼanic che ubitak-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Rumal ʼuri, xu siqʼuij i u mocom ruʼ; xu bij che: “¿Wach cat tijin yet chu ʼanic, chi quiqui bij i winak chwe? Ya cat wesaj na che a chac; cha yijba ʼuri jun wuj chwe, ʼalijinsabal-re wach u ʼonom can in chac.” Queje ile xbix che rumal u patron. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Are ʼuri i mocom xoc chi chʼobonic: “¿Wach i quin ʼano? man in patron ya quin resaj che in chac,” xu bij pu cʼux. “Yin n-ta in choʼab quin chacun chuwach ulew, xak quin qʼuix che we toʼ quin tzʼonoj mer chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","¡Ya xcʼun pin jolom wach i quin ʼano! Teʼuri ʼo ni winak quin qui cʼulaj na cuʼ ruʼ ja, are n-ta chic in patron.” Queje ile xu chʼob pu jolom. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Teʼuri xe u siqʼuij ruʼ, niʼpa i ʼo qui cʼas ruʼ u patron. I nabe chi xupon ruʼ xu tzʼonoj che: “¿Niʼpa a cʼas ruʼ in patron?” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“In cʼasom cien lat acéite ruʼ,” xu bij i jun che. Are ʼuri i mocom xu jach jun wuj che y xu bij: “Ri i a wuj-i; chat culok y cha jalwachij i tzʼib chuwach; xa cincuénta cha tzʼibaj chuwach,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Teʼuri xu tzʼonoj che jun chic: “Y yet, ¿niʼpa a cʼas ruʼ in patron?” “Cien tonel trígo in cʼasom ruʼ,” xu bij i jun chic. Ire xu bij ʼuri che: “Ri i a wuj-i; chat culok y cha jalwachij i tzʼib chuwach; xa ochénta cha tzʼibaj chuwach,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","I u patron, are xu ta wach u ʼanom i mal laj u mocom, xu bij chi lic ʼo u noʼoj, man u tzucum pa i coc wi, we ʼelsam chic che u chac. (Xu ʼan ire chi ʼo i quiqui cʼulaj cuʼ pa cachoch.) I winak chi toʼ je re u wach i jyub taʼaj, lic je sicʼaj chu tzucuxic wach i rajwaxic che i qui cʼaslemal. Mas je sicʼaj chiquiwach i je re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Yin quin bij chiwe, niʼpa i ubitak iwe, chi ʼana cwent wach qui ʼan ruʼ. Chi ʼana i ʼutz ruʼ, teʼuri are quix camic, ʼo ni quix cʼulaw ʼuri ruʼ, che i rachoch chila chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Jun, we cu ʼan i ʼutz ruʼ i jubiʼ yatal puʼab, xak cu ʼan ni ʼutz ʼuri ruʼ, we nim i yatal che. Xak queje ile, we ʼo jun, we n-ʼus ti cu ʼan che i jubiʼ ʼo puʼab, xak n-cu ʼan ta ʼutz ʼuri che, we ʼo ni uqʼuial ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yix ʼuri, we ni ʼanom ti ʼutz ruʼ ubitak iwe chi xa re u wach i jyub taʼaj, ¿pachin ʼuri cu ya ni beyomal sakil piʼab? Mi jun. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","We n-qui ʼan ti ʼutz ruʼ ile chi xa okxanim piʼab, ¿xataba ca yaʼ ʼuri piʼab i mer iwe yix? ");
INSERT INTO acr_acc_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Mi jun ca tiqui che, we je ʼo queb u patron ca chacun cuʼ. Queʼelok, xa jun cʼax cu naʼo, y jun tzel crilo. Xa jun chique, ʼutz u ʼanic u chac cu ʼan che; y che i jun, n-kas ta cu ʼan cas che. N-quix tiqui ta che, we qui ya iwib chu ʼonquil u chac i Dios, xak qui ya iwib chu molic i mer. (Queje ile xu bij i Jesus chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Je ʼo jujun aj Fariséo que tijin chu tayic u tzij-le. Ique xe oc chu yoʼyaxic wach i xu bij, man i aj Fariséo kus quiquil i mer. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Are ʼuri i Jesus xu bij chique: —Yix qui ʼan che iwib pacha ix ʼutz chiquiwach i winak, xui-ri, i Dios retaʼam wach ʼo pi cʼux. ʼO tak i qui ʼano chi kus quiquil i winak, xui-ri, tzel cril i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","I ujer ʼatbal tzij tzʼibtal can rumal i mam Moises, xak i qui cʼutunic i ujer ajbil u tzij i Dios, niʼpa ile ʼo piquiwi i winak cʼa xcʼun ni ma Wan, aj kajsanel ya. Teʼuri xpe i ʼutz laj tzij re u jekbal u ʼatbal tzij i Dios; are iri are i ca tijin u paxsaxic woʼor. Y conojel i winak ʼis quiqui ʼan pen que oc che u ʼatbal tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","I usucʼ i ujer ʼatbal tzij n-ca jalwachix taj; mi xa ta jubiʼ ca sachsax u wach che. Iwetaʼam yix iri: cʼax u sachsaxic u wach i caj i jyub taʼaj, xui-ri mas cʼax u jalwachixic u wach jun ral tzʼib re i ujer ʼatbal tzij. Lic n-ca jalwachix taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Jun achi, we cu jach nubi i rixokil y we xcucʼaj chic quib ruʼ jun chic ixok, ʼo u mac ʼuri chuwach i Dios. Xak we jun achi xcʼuli ruʼ jun ixok chi jachtal can rumal i rachijil, ʼo ni u mac i ucab achi chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ʼO jun achi beyom, lic chom u ʼuʼ, lic pakalic. Ire, ʼij ʼij, pacha tak ʼo nimaʼij chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Xak ʼo jun achi nibaʼ, ma Lázaro u bi, ʼij ʼij cul chila pa ocbal bic che i rachoch i beyom. Ire, lic ʼo chʼac che, ronojel i u chʼacul, ");
INSERT INTO acr_acc_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","y je ʼo tak i tzʼi que tejeb ruʼ y xqui riʼ u wach i chʼac che. I nibaʼ-le lic cu tij numic; cu rayij u wach i u cʼajnil i wa chi ca tzak chuxeʼ u mexa i beyom. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Xoʼon panok xcam i nibaʼ, teʼuri i ángel xqui cʼam bi pa glória, pa ʼo wi i mam Abraham. Xoʼon chupanok, xak xcam i beyom, y xmukic. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Ire are xupon pa qui qʼuijibal i camnak, lic xu tij uyej. Are ʼo chupam i cʼax-le, xtzun chicaj, y xril i mam Abraham, cʼo li cʼa naj, xak xril u wach i ma Lázaro, ʼo pu tzal. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Are ʼuri, xsiqʼuin pan che: “Ta Abraham, chawila toʼbal in wach. Cha taka li a-Lázaro cu mu li u wi u ʼab pa ya, col u jorobsaj i utzamwaʼ. Lic quin tij uyej waral chupam u rep i ʼaʼ.” (Queje ile xu bij.) ");
INSERT INTO acr_acc_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Teʼuri i mam Abraham xu bij che: “Wacʼal, cha cʼun cha cʼux chi yet, are at cʼas chuwach i jyub taʼaj, xui i ʼutz xa tijo, n-ti xoʼon palt chawe; i ma Lázaro, lic uyej xu tijo. Woʼor, ire ca quicot waral, y yet uyej ca ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Y n-xui ta la ile, ʼo jun nim laj siwan chakaxol iwuʼ yix; we ʼo jun craj ca ʼax jela, n-ta quicʼaw wi; xak i je ʼo jela we cacaj que ʼax li waral, n-ta quicʼaw wi,” xu bij i mam Abraham che. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Teʼuri i beyom xu bij chic che: “Cuyu in mac, Ta, lic quin tzʼonoj chic jun pawor chawe: cha taka bi i a-Lázaro pa rachoch in kajaw, ");
INSERT INTO acr_acc_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","man je ʼo joʼob in chaʼ, y che u bij chique ma ta que pe chi, col qui tija i cʼax waral,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Are ʼuri i mam Abraham xu bij che: “Ique qui tom wach u tzʼibam can i mam Moises, xak wach i qui tzʼibam can i je ajbil u tzij i Dios ujer. Chiqui ʼana cas che i tzij-le,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","I beyom xu bij ʼuri: “Katzij, Ta Abraham, péro n-coʼon ta ile chique. Xui-ri, we ta ca walij nubi jun camnak y ca ʼe cuʼ, ique quiqui jalwachij ni qui cʼaslemal ʼuri,” xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","I mam Abraham xu bij che: “Ique, we n-quiqui ʼan ta cas che i tzij tzʼibtal can rumal i mam Moises, xak cumal i ajbil u tzij i Dios, xak n-quiqui ʼan ta cas ʼuri che u tzij jun camnak walijnak,” xu bij i mam Abraham che. (Queje u tzij i Jesus ile chique i je aj Fariséo winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","I Jesus xu bij chique u tijoxelab: —I winak waral chuwach i jyub taʼaj, ʼo ni tzaksabal-que. Lic ʼo na, xui-ri, toʼ u wach i jun chi cu tzaksaj jun chic chupam u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Mas ʼutz queʼel che, we tene ca xim jun caʼ rij u kul i ca cʼak bi pa mar. I tojpen-le n-cʼax taj chuwach i tojpen chi ca pe na puwi coʼon panok, we xu tzaksaj jun wacʼal chupam u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Mi ʼan yix ile! Jun awachalal, we ʼo u mac chawe, cha bij che. Teʼuri we ire cu tzʼonoj cuybal mac, cha cuyu ʼuri che. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ire, we xmacun chawe wukub mul jun ʼij, xak we wukub mul cu bij chawe chi lic n-coʼon ta chic, ʼo chakul ʼuri ca cuy na —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","I apostelab xqui bij che i Kajwal: —Cha ya mas u cubibal ka cʼux che i Dios —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Are ʼuri i Kajwal xu bij chique: —Yix, we tene ʼo pichʼ u cubibal i cʼux che i Dios, we xa pacha u nimal jun ija re mostas, quix tiqui ʼuri chu ʼonquil nimak tak ʼanic. Quix tiqui ʼuri chu michʼic i nim laj cheʼ-i. We qui bij che: “Chat el chi, jat ʼe jekel pa mar,” quix cha che, i nim laj cheʼ-le ca cojon ʼuri chiwe —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","(Teʼuri i Jesus xu bij jun tijojbal tzij chique, cʼutbal re chique wach ʼo chiquikul i je rajchac i Dios.) Xu bij: —¿Wach ca ʼan yet che jun a mocom are ca cʼun che u chac? We xchacun pawabix, o xak we xu chajij juban a chicop, are ca cʼun che u chac ¿xataba ca bij che: “Chat oc la-lok, chat culok, y cha tija a wa,” cat cha? N-queje taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Are i ca bij che, xa are iri: “Cha yijba chwe wach i quin tijo,” cat cha che. “Teʼuri chin awila na wach i palt chwe, tzʼakat quin tij in wa. We xwelej in waʼim, teʼuri ca tij ni a wa yet,” ca bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","(ʼO chukul i mocom ca cojon che u patron.) ¿Xataba ca tioxij che, man xu ʼan ire pacha i a bim che? N-ca tioxij taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Xak queje yix chi ix rajchac i Dios. Are quix utzin che ronojel niʼpa ix u takom bi chu ʼonquil, miwoyʼej i tioxbal che. Are i qui ʼano, chi bij: “Yoj xa oj mocom; n-tu chac cu tioxij chake. Xui xka ʼano wach i bital chake.” Queje ile chi bij. (Are i tijojbal tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","I Jesus, are ca tijin u ʼenam pa Jerusalen, xicʼaw pa mojon chuxol i Samária, i Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Are xe upon che jun aldéa, xe ʼel li lajuj achiab chu cʼulaxic. Ique, ʼo i yobil lépra chique, rumal-i xe canaj can cʼa naj, ");
INSERT INTO acr_acc_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","y xe siqʼuin che: —¡Nim laj winak Jesus, chawila ni toʼbal ka wach! —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","I Jesus, are xe rilo, xu bij chique: —Jix, ji cʼutu iwib che i sacerdóte —xu bij. Ique xqui maj qui be; are que tijin chi be, juntir xutzir i cʼax chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ʼO jun chique ique, are xrilo chi chom chic u chʼacul, xtzalijic, ca siqʼuin chu cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Are xupon ruʼ i Jesus, xuqui chuwach, xu ʼaj rib chuwach cʼa xkaj u palaj pulew. Lic xu tioxij che. I achi-le, aj Samária winak, n-aj Israel taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Teʼuri i Jesus xu bij: —Je lajuj xe utzir na, ¿pa je ʼo wi i bele-jeb? ");
INSERT INTO acr_acc_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Xui nawi i jun-i xtzalij lok cu cojbej u ʼij i Dios? ¿Xui ire-le xcʼunic, chi n-kach taj tinimit? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Teʼuri xu bij che i achi: —Chat walijok, y jat; xat utziric rumal u cubibal a cʼux chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ʼO jujun aj Fariséo xqui tzʼonoj che i Jesus umpa ca jekan u ʼatbal tzij i Dios chuwach i jyub taʼaj. Ire xu bij chique: —I u cʼunic u ʼatbal tzij i Dios, n-ca ʼiltaj taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Mi jun crilo, mi jun cu bij: “¡Ri ʼolic-i!” o xak “¡Le ʼo jela-le!” n-que cha taj; man i ʼatbal tzij re i Dios ya ʼo chic chiquixol i winak, ya ʼo chic piqui cʼux. (Queje xu bij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Teʼuri xu bij chique i u tijoxelab: —Ca pe tak i ʼij chi yix qui rayij na quiwil jun che tak u ʼij re i Achi aj Chicaj, péro n-quiwil taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","ʼO ni jujun quiqui bij chiwe: “¡Ri ʼolic-i!” que cha; o xak quiqui bij: “¡Le ʼo jela-le!” que cha. Xui-ri, mix ʼec, mix terej chiquij. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Are cu rik i ʼij re i Achi aj Chicaj, coʼon na pacha coʼon u wach i caj, are ca pe jun nim laj u rep ray, ca repcan u tzunbal cʼulala. Queje ile u ʼij i Achi aj Chicaj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Xak xu bij: —Xui-ri, nabe ʼo u chac cu tij ni cʼax, xak ca xutux na cumal i winak je re i woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Are cu rik i ʼij re i Achi aj Chicaj, quiqui ʼan i winak pacha xqui ʼan che tak i ʼij re i mam Noe ujer. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ique toʼ xqui tij qui wa, xqui tuʼ qui yaʼ, xak toʼ xe cʼuliʼic, chi achiab, chi ixokib. Queje que tijin ile chu ʼanic cʼa xu rik i ʼij are xoc i mam Noe chupam u bárco, are ʼuri xpe i nim laj jab y conojel xe camic. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Xak queje ile xqui ʼan i winak ujer, pa tinimit Sodóma are cʼas i mam Lot. Toʼ xqui tij qui wa, xqui tuʼ qui yaʼ; toʼ xe cʼayinic, xe loʼonic; toʼ xe ticanic, xe jachʼanic; xak toʼ xqui yac i cachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Xui-ri, are xel i mam Lot pa tinimit Sodóma, juntir xtzak li ʼaʼ chicaj, xak i asufra pacha abaj aʼal; ʼis xe cam conojel. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Queje coʼon ile coʼon panok, are ca ʼiltaj u wach i Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Are cu rik i ʼij-le, jun we ʼo puwija re i rachoch (suʼ cha kaj la lok y cha ʼanmajok), ma oc chic pa ja chi relsaxic i ubitak-re ʼo chupam; y xak queje i jun we ʼo pa chac pa tak ʼes, ma tzalij chal ruʼ rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Cha cʼun chi cʼux wach xoʼon i rixokil i mam Lot (are xe ʼanmajic, ire xtaqʼuiʼic, xtzun chirij, y xcam rumal). ");
INSERT INTO acr_acc_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Pachin jun xa coʼon pen cu tobej u cʼaslemal, xa cu sach ʼuri u cʼaslemal sakil. Xui-ri, we ʼo jun ca sachsax nu wach u cʼaslemal xa wumal yin, ca yaʼ ʼuri u cʼaslemal sakil. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Quin bij chiwe: are cu rik i ʼij-le, je ʼo ni queb que war junam chuwi chʼat; jun ca cʼam nubic, y jun ca canax canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Xak je queb ixokib que tijin chi queʼem junam; jun ca cʼam nubic, y jun ca canax canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Xak je queb achiab je ʼo pa tak ticon, jun ca cʼam nubic, y jun ca canax canok. (Queje xu bij i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Are ʼuri xqui bij che: —Kajwal ¿ipa ca ʼani wi i xa bij-le? —xe cha. Ire xu bij chique: —Pa ʼo wi jun chʼaculaj camnak, chila que moltaj wi i cʼuch —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","I Jesus xu bij chic jun tijojbal tzij chique, cʼutbal-re chique chi ʼo u chac n-quiqui mayij tu tzʼonoxic che i Dios, xak ma baʼcrij qui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Xu bij chique: —Che jun tinimit ʼo jun juez n-cu xij ta rib che i Dios, xak n-cu coj ti qui ʼij i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Che i tinimit-le, xak ʼo jun ixok malcan. Ire cupon ruʼ i juez, cu tzʼonoj ʼatbal tzij puwi jun aj chʼoʼoj chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ʼO tan chi ʼij, i juez n-craj ta cu ʼan i ʼatbal tzij che; xui-ri, xu rik i ʼij chi xu bij pu cʼux: “Katzij yin n-quin xij ta wib che i Dios, xak n-quin coj ta qui ʼij i winak, ");
INSERT INTO acr_acc_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","xui-ri i ixok malcan-le n-cu mayij ti cʼunic wuʼ. Rumal-i, quin ʼan ni ʼatbal tzij che, mokxa n-cu mayij ti cʼunic, y crix ni in cʼux che, y n-quin chʼij ta chic ʼuri,” xu bij. (Are i tijojbal tzij ile xu bij i Kajwal chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Teʼuri xu bij chique: —Chi ta ʼut wach xu ʼan i mal laj juez: xu to ni ixok malcan. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Bay, we queje xu ʼan ni mal laj juez ile, ¿xataba i Dios n-que u to ti je re ire? Ire que u to na niʼpa i quiqui tzʼonoj qui tobal che chi paʼij chi chaʼab. ¿Xataba ca baytaj chu ʼonquil wach quiqui tzʼonoj che? N-ca baytaj taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Quin bij chiwe: i Dios que u to na; cu ʼan la i ʼatbal tzij chique. Xui-ri, are ca cʼun i Achi aj Chicaj, ¿ʼo nawi ʼuri jujun chi cul qui cʼux che? (Queje ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Je ʼo jujun winak quiqui bij ique lic je ʼutz, y xa quiqui kajsaj qui ʼij i juban. Cumal i winak-le, i Jesus xu bij i tijojbal tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","—Je ʼo queb achiab xe ʼe chu tzʼonoxic pa rachoch i Dios. I jun are aj Fariséo, i jun chic, aj tzʼonol alcawal. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","I aj Fariséo, tacʼalic queje iri ca tijin chu bixquil: “Dios, quin tioxij chawe, man yin n-in ta queje pacha i juban winak. Ique xa je iliʼom, je mal laj tak winak, xak quiqui kajsaj qui ʼij cuʼ ixokib ne te quixokil. Lic quin tioxij chawe n-in ta pacha i aj alcawal-i. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Camul quin mayij in waʼim pa seman y quin ya wib chu tzʼonoxic chawe. Niʼpa i quin chʼaco, quin ya jun tant re i lajuj chawe.” (Queje xu bij i aj Fariséo ile che i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","I aj tzʼonol alcawal n-queje ta xu ʼan ire ile. Ire, naj xcanaj wi, n-xtzun ta chicaj man xqʼuix che. Cʼax xu na u cʼux, xu chʼay u wach u cʼux y xu bij: “¡Dios, chawila toʼbal in wach, xa in ajmac laj winak!” (Queje u tzij ile xu bij che i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yin quin bij chiwe, i aj tzʼonol alcawal xtzalij chi rachoch ʼutz chic chuwach i Dios; n-cumaj taj pacha i aj Fariséo. Queje ile xeʼelok, man pachin coʼon nim che rib, ire ʼut xa ca kajsax ni u ʼij; y pachin coʼon chʼutin che rib, are ca nimarsax na ʼuri u ʼij. (Queje i tijojbal tzij ile xu bij i Jesus chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ʼO i winak xe qui cʼam li ral tak cacʼal ruʼ i Jesus man cu ya ni u ʼab piquiwi. I u tijoxelab, are xquilo, xe oc chi qui ʼatixic. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Xui-ri, i Jesus xe u siqʼuij i acʼalab ruʼ y xu bij: —Chi ya chique i acʼalab que cʼun wuʼ; me i ʼatij, man niʼpa i je pacha acʼalab piqui cʼux, ʼo que ique che i ʼatbal tzij re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Sak laj tzij quin bij chiwe, jun we n-cu coj ti u tzij i Dios, we n-cu ʼan ta che u cʼux pacha u cʼux jun acʼal, n-coc ta ʼuri che u ʼatbal tzij i Dios —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Jun achi nim u patan piquiwi i aj Israel winak xupon ruʼ i Jesus y xu tzʼonoj che: —Nim laj winak, at ʼutz laj tijonel, ¿wach i quin ʼan na, quin rikbej re in cʼaslemal chi n-tu qʼuisic? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","I Jesus xu bij che: —¿Wuchac ca bij chwe chi in ʼutz? N-ta jun chi ʼutz, xui Dios —xu bij—. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Yet awetaʼam i lajuj tzij pixab: “Ma min awib ruʼ jun ixok we n-awixokil taj; mat camsanic; ma ʼan elaʼ; ma ʼan mentir chirij jun winak, cha cojo qui ʼij a kajaw a chuch” —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","—Ronojel ile ʼis in ʼanom lok cʼa are in chʼutin —xu bij i achi che. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","I Jesus, are xu ta ile, xu bij: —Cʼo ni rajwaxic chawe. Cha cʼayij ronojel ubitak awe y cha ya i mer chique i nibaʼib; ca rik ʼuri a beyomal chicaj. Teʼuri chat petok y chat terej chwij —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","I achi, are xu ta ile, xoc chi bis man lic beyom. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","I Jesus, are xrilo chi ca bisonic, xu bij: —I beyomab, cʼax u jachic quib puʼab i Dios; cʼax coquic pu ʼatbal tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Cʼax u ʼanic chi jun beyom cu jach rib puʼab i Dios; cʼax ile chuwach i ricʼawic jun camey che i tel re jun acuxa —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Are ʼuri, niʼpa i xqui ta ile xqui bij: —¿Pachin quelsax na ʼuri chupam u mac? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","I Jesus xu bij chique: —I Dios ca tiqui che, wach i n-que tiqui ti winak chu ʼonquil —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Teʼuri i ma Pédro xu bij che: —Kajwal, yoj ka canam canok niʼpa i ʼo kuʼ, y oj terejnak chawij —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","I Jesus xi bij chique: —Katzij i quin bij chiwe, pachin jun croʼtaj can u bitak-re man cʼax cu na i u ʼatbal tzij i Dios, nim ni cu chʼac na. We cu canaj can i rachoch, o we u chuch u kajaw, o we i ratz u chaʼ, o we i rixokil, o we i racʼal, rumal ni u ʼatbal tzij i Dios, ");
INSERT INTO acr_acc_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nim i cu chʼac na puwi ile waral chuwach i jyub taʼaj; xak coʼon panok ʼo ni u cʼaslemal chi n-ca qʼuis ta chic —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","I Jesus xe u siqʼuij i cablajuj u tijoxelab ruʼ y xu bij chique: —Chitapeʼ, ya xka maj bi ka be pa Jerusalen. Chila ca ʼan na che i Achi aj Chicaj ronojel niʼpa i qui tzʼibam i ujer ajbil u tzij i Dios che. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ire ca jach na piquiʼab i ne te aj Israel winak. Ique quiqui yoʼya na, quiqui bij cʼax che, y quiqui chubaj ni u palaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Quiqui jic u loʼxic, teʼuri quiqui camsaj, xui-ri churox ʼij ca walij chiquixol i camnak —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","I u tijoxelab n-xqui ta tu be i xu bij-le. N-xquetamaj taj wach usucʼ i xu lapo; n-xqui ta tu be wach i queʼelok. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","I Jesus ca tijin chi be, nakaj chic ʼo wi che i tinimit Jerico. ʼO jun mawach cul pa be, ca tijin chu tzʼonoxic mer chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Are xu ta chi je qʼui i winak ca tijin quicʼawic, “¿Wach copis ile?” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Xqui bij che chi are i Jesus aj Nazaret ca tijin ricʼawic. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Are ʼuri xsiqʼuin che: —¡Kajwal Jesus! ¡Yet chi at u muk u xiquin can i mam David! ¡Chawila toʼbal in wach! —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","I winak chi je nabe bi chuwach i Jesus, xqui yajo man cacaj cu mayij siqʼuinic. Ire xa xu cowij u bixquil che i Jesus: —¡Yet chi at u muk u xiquin can i mam David, chawila toʼbal in wach! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Are ʼuri i Jesus xtacʼ canic y xu tak u cʼamic. Are xnakajab ruʼ, xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","—¿Wach cawaj quin ʼan chawe? —coʼono. I mawach xu bij che: —Nim laj winak, cwaj yin quin a tzunsaj —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","I Jesus xu bij che: —¡Chat tzunok! Xat utziric man xa cuba a cʼux chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Juntir xtzun i mawach y xterej bi chirij i Jesus, ca tijin chu camwaxic, ca tijin chu tioxixic che i Dios. Je niʼpa i winak xe ʼilaw ile xak xqui coj u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","I Jesus xoc pa tinimit Jerico, y ca tijin ricʼawic chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Che i tinimit-le ʼo jun achi, ma Zaquéo u bi; i u patan ire, are cajʼatzil i je aj tzʼonol alcawal; ire beyom. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Craj ire cretamaj u wach i Jesus, xui u ʼanom-i, n-naj ta rij; rumal-i, n-ta módo crilo cumal i uqʼuial winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Xa ʼe paʼanem, xnabeajic, y xel bi puwi jun cheʼ, u bi sicó-moro ʼo xucut be pa quicʼaw wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Are xicʼaw i Jesus chila, tzun ʼan chicaj y xu bij che i achi: —Ma Zaquéo, chat kaj la lok; ʼo u chac quin qʼuiji can chi awachoch woʼor —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","I ma Zaquéo juntir xkaj lok, y ca quicotic xu cʼam bi i Jesus ruʼ chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","I winak, are xquil ile, xe oc chu chʼachʼaxic i Jesus, man xa ʼe ruʼ rachoch jun mal laj winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Chila paja, i ma Zaquéo xtaqʼui ʼanok y xu bij che i Kajwal: —Nim laj winak, niʼpa i ʼo wuʼ, quin ya ni nicʼaj chique i nibaʼib. We ʼo tak in majom chique i winak, quin tzalijsaj chic cajib mul chique —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","I Jesus xu bij ʼuri che: —Woʼor yet junam cuʼ awixokil awalcʼwal i rikom iwelbal chi sak —xu bij. Teʼuri xu bij i tzij-i (cumal i juban chi quiqui chʼachʼa): —Ire xak u muk u xiquin can i mam Abraham pacha yix. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Yin chi in Achi aj Chicaj, in cʼun-nak chi qui tzucuxic i je sachnak, ʼelsabal na que chupam i qui mac —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","I Jesus, tzʼakat que tijin i winak chu tayic u tzij, xu bij jun tijojbal tzij chique. Queje xoʼon ire ile chique, man ya coc pa tinimit Jerusalen. Quiqui chʼob i winak chi we xoc ire chila, ya cu jek i nim laj ʼatbal tzij re i Dios piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Rumal-i, ire xu bij i tzij-i chique: —ʼO jun achi, nim u ʼij u patan u kajaw. I achi-le, ca ʼe che jun tinimit cʼa naj, chu cʼamic u patan re ʼatol tzij puwi u tinimit; we ʼo chic puʼab, ca tzalij li ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Are maja ca ʼec, xe u siqʼuij lajuj rajchaquib ruʼ, y xu ya can jujun sak pwak chique, nimak u wach. Xu bij chique: “Chix chʼacan ruʼ i mer-i, tzʼakat quin cʼun li yin,” coʼono; y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","I rach aj tinimit tzel quiquilo, y xe qui tak bi juban aj takon chu bixquil: “N-cakaj ti yoj i achi-le we are ca canaj can re ʼatol tzij pakawi.” (Queje ile xqui bij bic, xui-ri, n-ta xoʼon re chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","I achi, xyaʼ puʼab chi are i ʼatol tzij piquiwi, teʼuri xtzalij pu tinimit. Are xuponic, xe u siqʼuij i rajchac ruʼ, chi u yom can i mer chique. Xu tzʼonoj chique chi qui jujunal niʼpa i qui chʼacom che i qui mer. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","I nabe xupon ruʼ, y xu bij che: “Nim laj winak, i a mer, in chʼacom chic lajuj tant puwi,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","I ʼatol tzij xu bij che: “Lic ʼutz ni a ʼanom; at ʼutz laj ajchac. A ʼanom ni ʼutz ruʼ i jubiʼ in yom chawe, rumal-i cat in ya piquiwi lajuj tinimit,” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Teʼuri i ucab rajchac xtejeb ruʼ, y xu bij che: “Nim laj winak, i a mer, in chʼacom chic joʼob tant puwi,” xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","I u patron xu bij che: “Xak yet, cat in ya na piquiwi joʼob tinimit,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Teʼuri xtejeb jun chic ruʼ chique i lajuj, y xu bij che: “Nim laj winak, ri a mer-i; in cʼolom can chupam jun sut. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Xin cʼolo man quin xij wib chawe; wetaʼam chi at cʼan laj achi. At pacha jun chi cu chapo wach i nu cʼolom taj, o xak cu mol u wach i ticon chi n-xu tic taj,” xu bij che. (Queje ile xu bij i mal laj ajchac; craj cu coj u mac u patron.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Are ʼuri i ʼatol tzij xu yajo. “At mal laj ajchac,” xu bij che, “¡Quin cʼut ni a mac chawe ruʼ i mísmo a tzij yet! Xa bij yet chi in cʼan laj winak, chi quin chapo wach n-in cʼolom taj, o xak quin mol u wach i ticon chi n-in ticom taj, ca bij yet. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","We queje quin ʼan yin ile, ca bij, ¿Wuchac ʼuri n-xa ya ti in mer cuʼ i quiqui toj i alaj-re? We tene queje ile xa ʼano, are xin cʼunic, ʼo tene-ri in mer, rachiʼil i alaj. ¡Péro n-taj!” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Teʼuri xu bij chique i je ʼo pu tzal: “Chi maja i mer che; chi ya na che i jun chi xu chʼac lajuj tant,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Nim laj winak, ya ʼo chic lajuj ruʼ,” xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","I ʼatol tzij xu laʼ u wach chique: “Quin bij chiwe, jun we ʼo na chic ʼo ruʼ, ca yaʼ na mas ʼuri che; i jun chi n-ta kas ʼo ruʼ, ca ʼelsax ni jubiʼ chi ʼo ruʼ,” coʼono. Teʼuri xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","“Niʼpa i winak chi tzel que in ilawic, chi n-cacaj ta in ʼo piquiwi, che i cʼama lok, y che i camsaj chinwach.” xu bij i ʼatol tzij. (Queje i tijojbal tzij ile xu bij i Jesus chique i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Are xbitaj ile rumal i Jesus, xu maj chubi u be pa Jerusalen, nabe chiquiwach i u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Teʼuri xe upon chu nakaj i queb aldéa, Betfage y Betánia, pa ʼo wi i ral jyub Olívos. Are ʼuri xe u nabsaj bi queb u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Xu bij chique: —Jix che i aldéa ʼo pan chakawach-le. Are quix uponic, qui rik ni jun buru yukulic, chi cʼa maja cretamaj ca ʼan winak chirij. Chi quira y chi cʼama lok. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","We ʼo i ca tzʼonow chiwe wach u chac quix tijin chu toric, chi bij che chi cu rik u chac che i Kajwal, chix chok che. (Queje ile xu bij i Jesus chique i queb-le.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Ique xe ʼec, y xqui rik i ral buru yukulic, pacha u bim bi Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Are que tijin chu toric, xe upon i rajaw, y xqui bij chique: —¿Wuchac qui tor bi i buru? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","I tijoxelab xqui bij: —Cu rik u chac che i Kajwal —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Teʼuri xqui cʼam bi ruʼ i Jesus. Xqui coj qui ʼuʼ chirij i buru, cubibal re i Jesus, y xqui ʼansaj ʼan i Jesus chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Are que tijin chi be, i winak xqui licʼ qui ʼuʼ pu be, wikbal-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Are xe upon chu nakaj i Jerusalen, pa ʼo wi i kajbal lok re i jyub Olívos, conojel niʼpa i je teren chirij xe oc chi sicʼ rumal i quicotemal. Lic xqui coj u ʼij i Dios rumal uqʼuial tak milágro u ʼanom i Jesus chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Xqui bij: —¡Nim u ʼij i ka ʼAtol Tzij chi u takom li Kajwal Dios! ¡Cʼamori che i Dios chicaj! ¡Chocsax u ʼij i Dios! (Queje ile xe siqʼuin chu bixquil.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Xak je ʼo juban aj Fariséo chiquixol i winak; are xquilo wach quiqui ʼan i uqʼuial winak, xqui bij che i Jesus: —Mayes, che a ʼatij a tijoxelab —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","I Jesus xu laʼ u wach chique: —Chitapeʼ, we que in ʼatij, i abaj-i que siqʼuin na ʼuri piqui qʼuexel ique —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","I Jesus cuʼ i je teren chirij xe upon chu nakaj i tinimit Jerusalen. Are xril i tinimit, cʼax xu na u cʼux, y xoʼic. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Xu bij: —¡Toʼ i wach yix ix aj Jerusalen! We tene woʼor quiwetamaj usucʼ wach u rikic i sakil laj uxlambal i cʼux, ʼutz te iwe-ri; xui-ri, n-quiwil taj, xa pacha chʼuktal u wach chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ya cu rik i ʼij qui tij ni uyej. I aj chʼoʼoj chiwij quiqui coj ni tapia chirij i tinimit man n-ta chic pa i quix el wi. Teʼuri quiqui sutij ni iwij, y ca pe ni chʼoʼoj cʼulala. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Quiqui sach na ʼuri u wach i tinimit, y que qui camsaj niʼpa i je jekel che. Are cutzi-nic, mi tene jun abaj pa xan ca canaj puwi i rachiʼil. Queje ni ile queʼelok, man n-xi ta ti usucʼ are xupon i Dios iwuʼ tobal iwe. (Queje xu bij i Jesus ile are xril i tinimit.) ");
INSERT INTO acr_acc_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","I Jesus xoc pa rachoch i Dios; are ʼuri xu jek li quelsaxic i aj cʼayinel, i aj loʼonel chi je ʼo chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Xu bij chique: —I Dios, chupam u wuj, u bim can i tzij-i: “I wachoch, lic jun ja re qui tzʼonbal i winak chwe” (queje ile tzʼibtal canok); xui-ri yix i ʼanom qui jul iliʼomab che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ʼIj ʼij, i Jesus ca tijin chu cʼutic chique i winak pa rachoch i Dios. I cajʼatzil i sacerdóte junam cuʼ i tijonel re i ujer ʼatbal tzij, xak qui wi qui jolom i aj Israel, quiqui tzucuj wach u camsaxic i Jesus quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Xui-ri, n-quiqui rik taj wach u ʼanic quiqui ʼano, man conojel i winak lic qui yom qui cʼux chu tayic u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Xoʼon panok, i Jesus ʼo pa rachoch i Dios, ca tijin chu cʼutic chique i winak, xak ca tijin chu bixquil chique wach i quelbal chupam i qui mac. Are ʼuri xe upon i cajʼatzil i sacerdóte, junam cuʼ i je tijonel re i ujer ʼatbal tzij, xak i nimak tak mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Xqui bij che: —¿Bi chi ʼatbal tzijal ʼo paʼab, chi queje ca ʼan ile? —xqui bij—. ¿Pachin xyaw ile paʼab, chi cat tijin chu ʼonquil? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Are ʼuri i Jesus xu bij chique: —Yin xak quin tzʼonoj jun tzij chiwe. Chi bij chwe: ");
INSERT INTO acr_acc_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Pachin xyaw puʼab i ma Wan cu kajsaj ya piquiwi i winak? ¿Are i Dios xyaw che, o xa winak xyaw che? —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Ique xe oc chu bixquil chiquiwach: —¿Wach nawi caka bij che? —que cha—. We caka bij chi are i Dios xyaw ile puʼab i ma Wan, ire cu bij na chake: “¿Wuchac ʼuri n-xi coj taj wach i xu bij?” ");
INSERT INTO acr_acc_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","We xak caka bij chi xa ruʼ winak petnak wi wach i xu bij i ma Wan, i winak coj qui camsaj ʼuri che abaj, man conojel quiqui bij chi ma Wan lic ruʼ i Dios petnak wi wach i u bim. (Queje ile xqui bij chiquiwach.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Rumal-i xqui bij che i Jesus: —N-ketaʼam taj pachin xyaw che —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","—Xak yin n-quin bij ta ʼuri chiwe wach i ʼatbal tzij ʼo pinʼab, chi quin ʼan tak iri —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Teʼuri i Jesus xoc chu bixquil jun tijojbal tzij chique i winak. Xu bij chique: —ʼO jun achi, ʼo u qʼuial úva u ticom. Ire ʼo u chac ca ʼe che jun viáje, rumal-i xu ya can piquiʼab i raj mediant. Ire xa ʼec, y naj xsachic. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Are xu rik i ʼij re i cosech, xu tak bi jun u mocom chu tzʼonoxic i re ire, chique i raj mediant. Are xupon u mocom, xqui chʼayo, lic xqui ʼan cʼax che, y xqui tak bic, n-ta xqui ya bi che. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Teʼuri i rajaw i ticon xu tak chal jun mocom; xak queje xqui ʼan chic che: xqui bij cʼax che, xqui chʼayo, xak xqui tak chubic, n-ta xqui ya bi che. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","I rajaw i ticon xu tak chal jun chic; i aj mediant xak xqui ʼan chic cʼax che, y xquesaj chalok. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Are ʼuri i rajaw ulew xu bij: “¿Wach i quin ʼano? Quin tak nubi in cʼojol chi lic cʼax quin naʼo; are quiquil u wach, pent que cojon na che,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","I aj mediant, are xquilo, xqui bij chiquiwach: “Ire-le, are i rajaw i ulew coʼon panok. Chaka camsaj, man ca canaj can i ulew pakaʼab yoj,” xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Are ʼuri xquesaj li pa ticon y xqui camsaj. (Are i tijojbal tzij ile xu bij i Jesus chique.) Teʼuri xu tzʼonoj chique: —I rajaw i chac, ¿wach nawi coʼon chique i mal laj tak ajchaquib-le? ");
INSERT INTO acr_acc_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ire ca cʼun na, y que u camsaj i ajchaquib; teʼuri cu ya ni ulew piquiʼab juban chic ajchaquib. (Queje ile i moxbal tzij xu bij i Jesus chique.) I winak, are xqui ta ile, xqui bij: —¡Ay, chu ʼatij i Dios ile! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Teʼuri i Jesus xe u takej y xu cʼunsaj u tzij i Dios chique wach coʼon na. —Katzij, queje ile ca ʼantaj na. We n-ca ʼantaj taj, ¿wach usucʼ ʼuri i tzij-i chi tzʼibtal can chupam u wuj i Dios? Man cu bij: I abaj chi n-xcaj ti xqui coj i je aj ʼanol ja, are i abaj-le chi xeʼelok lic nim ni u chac che i cubibal ja. (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","I abaj-le, we ʼo jun ca ʼe tzak puwi, ca pax che. Xak i abaj-le, we ca tzak chirij jun, lic coʼon cʼajcʼaj che —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","I cajʼatzil i sacerdóte, xak i tijonel re i ujer ʼatbal tzij xqui ta u be chi xa are ique que u lap na. Rumal-i, cacaj tan u chapic, xui-ri xqui xij quib chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Teʼuri xe qui tak bi juban achiab ruʼ i Jesus, quiqui cʼambej u pam. Xe qui tak bi ruʼ pacha je ʼutz lak tak winak, quiqui tzʼonbej juban tzij che, xa tzaksabal-re quiqui ʼano. Cacaj ique ca chap na cumal i rakan u ʼab i ʼatbal tzij, y ca jach na puʼab i gobernador. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Are xe upon ruʼ i Jesus, xqui bij che: —Tijonel, ketaʼam chi yet, wach i ca bij, wach i ca cʼutu, lic pusucʼ i ca ʼan wi. Yet lic n-ca ʼan ta cas che, wach u patan jun winak, we nim, o we n-nim taj; lic ca bij i sak laj tzij che, wach craj i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Cha bij ʼu chake: ¿ʼUtz nawi caka toj impuésto che i ʼatol tzij, o n-ʼus taj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","I Jesus retaʼam chi xa tzaksabal-re cacaj; xa cʼambal u pam quiqui ʼano. Xu bij chique: —¿Wuchac qui tzucuj tzaksabal-we? —xu bij—. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","Chi cʼutu jun sak pwak chwe. ¿Pachin u qʼuexwach iri ʼo chuwach? ¿Pachin u bi iri tzʼibtal chuwach? —xu bij. —Re i ʼatol tzij —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","—Bay —xu bij i Jesus chique—, chi ya ʼuri che i ʼatol tzij wach ʼo re ire che; xak chi ya che i Dios wach ʼo re ire che —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ique n-xqui rik taj wach tzaksabal-re quiqui ʼan chiquiwach i winak. Are xqui ta u tzij, ique lic xqui bisoj; n-xe chʼaw ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Teʼuri ʼo jujun chique aj Saducéo xe ʼe ruʼ i Jesus. I aj Saducéo quiqui bij chi i je camnak n-que walij ta chic. Rumal-i, are xe uponic, xqui bij che i Jesus: ");
INSERT INTO acr_acc_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","—Tijonel, i mam Moises u tzʼibam canok chi we xcam jun achi, we n-ta racʼal ruʼ can i rixokil, ʼo u chac ʼuri ca cʼuli i ratz u chaʼ i achi ruʼ i ixok malcan. Queje ile ca qʼuiji na racʼal ire ruʼ i ixok, pu qʼuexel i camnak. Queje ile u bim canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bay, oʼonom lok, je ʼo wukub achiab catz qui chaʼ quib. I nabe chique xcʼuliʼic, y xoʼon panok, xcamic, n-ta racʼal canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Teʼuri i ucab chaʼaxel xcʼuli ruʼ ixok malcan. Xoʼon panok, xcam chic ire, n-ta racʼal. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Teʼuri i urox xcʼuli chic ruʼ i ixok, xak queje xqui ʼan ile conojel. I je wukub-le ʼis xe cam chuwach i ixok, n-ta cacʼal canok ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Pa qʼuisbal-re, xcam i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bay, are cu rik i ʼij re qui walijbal i camnak, ¿pachinok chique i wukub-le queʼelok mer rachijil? Man conojel i je wukub xe cʼuli ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","I Jesus, queje iri xu laʼ u wach chique: —Waral chuwach i jyub taʼaj, katzij que cʼuli i achiab i ixokib; ");
INSERT INTO acr_acc_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","xui-ri, coʼon panok, n-quiqui ʼan ta chic. Niʼpa i ca majaw chique chi que walij chiquixol i camnak y que oc chila chicaj, ique n-que cʼuli ta chic. (N-ta chic u chac ile.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Man n-que cam ta chic. Ique queʼelok je pacha i ángel, y je racʼal chic i Dios, man je walijnak chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","I tzij chi u tzʼibam can i mam Moises cu cʼut chiwe chi que walij ni camnak. Xu tzʼibaj ire wach u tzij i Dios che, are xu ʼijla chupam i ʼaʼ chi ca juluw che i ral cheʼ. Xu bij i Dios chi ire are qui Dios i mam Abraham, i mam Isaac, xak i mam Jacob. (I oxib-le je camnak chic are xu bij i Dios ile, xui-ri, chuwach ire, je cʼaslic.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","I Dios n-are ti qui Dios i je camnak, are i qui Dios i je cʼaslic. Chuwach ire, ʼis je cʼaslic conojel —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Are ʼari ʼo jujun chique i tijonel re i ujer ʼatbal tzij xqui bij: —Tijonel, ʼutz i xa bij —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Queje ile xqui bij, man i aj Saducéo winak n-ta chic u cowil qui cʼux chu tzʼonoxic mas che. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","I Jesus xu bij chique: —¿Wuchac quiqui bij i winak chi i Crísto we xcʼunic, are ni u muk u xiquin i mam David? ");
INSERT INTO acr_acc_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","¿Wuchac quiqui bij ile? Man lic are i mam David u bim can i tzij-i chupam i wuj u bi Sálmos: I Kajwal Dios xu bij che i Wajwal Crísto: “Chat cul na pin wikabim ");
INSERT INTO acr_acc_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","cʼa cu rik ni ʼij que in ya na pa awakan niʼpa i je aj chʼoʼoj chawij,” xu bij. (Queje ile u tzʼibam can i mam David ujer chirij i Crísto.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Wach u ʼonquil ʼuri chi Crísto xa u muk u xiquin i mam David? ¿Wach u ʼonquil ile? man lic are i mam David xu bij “Wajwal” che i Crísto. (Queje ile xu bij i Jesus chique, cu sakijbej-re chique chi Crísto n-toʼ ta winak, lic Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Conojel i winak que tijin chu tayic i Jesus are xu bij chic jun tzij chique u tijoxelab. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","—Chi ʼana cwent chique i tijonel re i ujer ʼatbal tzij, chi xa kus quiquilo que malcat pa tak be ruʼ qui ʼuʼ naj rakan; kus quiqui ta are ca yaʼ rutzil qui wach cumal i winak pa tak qʼuebal, ocsabal re qui ʼij. Are que oc pa molbalʼib, xa quiqui tzucuj qui cubibal ʼo u ʼij; xak queje quiqui ʼano are que ʼe pa waʼim re tak nimaʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ique quiqui maj i cachoch ixokib malcanib; teʼuri quiqui ʼan nimak tak tzʼonbal che i Dios, chiquiwach i winak, sachsabal-re wach i qui ʼanom. Ique ʼut ca yaʼ ni tojpen chique lic nim na chiquiwach i juban —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","I Jesus, are ʼo pa rachoch i Dios xe ril i beyomab que tijin chu yaʼic qui mer pa caxa chila. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Are ʼuri xril jun ixok malcan lic nibaʼ, ire xa queb centávo u mer xu yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Teʼuri i Jesus xu bij chique i je ʼo chuwach: —Katzij i quin bij chiwe, i ixok nibaʼ-i, i u mer xu yaʼo, mas nim chuwach ile chi qui yom conojel i juban. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Ique, wach i qui yom, xa are quesam che wach i sobrin-nak cuʼ; xui-ri i ixok-le chi lic nibaʼ, ronojel xu yaʼo, niʼpa i ʼo ruʼ; n-ta chic xu canaj re u cʼaslemal —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ʼO juban winak que tijin chu lapic i rachoch i Dios, chi lic chom, xqui bij; lic chom laj tak abaj ʼo che, xak lic chom i wikbal-re chi qui sipam i winak chuwach i Dios, xqui bij. Are ʼuri i Jesus xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","—Niʼpa iri chi quix tijin chu takexic, cu rik ni ʼij ca wulijsax na. Mi jun abaj ca canaj chic puwi i rachiʼil —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Teʼuri xqui bij che: —Ka Tijonel, ¿umpa ca ʼani ile chi xa bij? ¿Wach i retalil cakil na are ya ca petic? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","I Jesus xu bij chique: —Chi ʼana cwent iwib, mokxa ʼo quix tʼorowic. Man je qʼui que cʼun na y queje iri quiqui bij: “Yin in i Toliwe,” que cha, xak “Ya ca pe i qʼuisbal ʼij,” que cha na. Xui-ri, mix cojon chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Yix are qui ta rason chi ca ʼani chʼoʼoj pa tak tinimit, xak we ʼo i quiqui ʼan chʼoʼoj chirij i ʼatol tzij, mi xij iwib rumal. Queje ni ile queʼelok nabe, xui-ri, ile n-are ti mer qʼuisbal ʼij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Xak xu bij chique: —ʼO ni tinimit quiqui ʼan chʼoʼoj che chic jun tinimit; ʼo ni winak re jun ʼatol tzij quiqui ʼan chʼoʼoj chiquij i winak re chic jun ʼatol tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Xa ipa ʼo na wi i nimak tak ucabrakan, xak queje i waʼjal, xak queje i yobil. Xak chuwacaj, quiwil nimak tak ʼil, xak nimak tak séña. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Xui-ri, nabe na chuwach tak ile, yix quix chaptaj na y quix oktax na. Quix ʼe qui ya pa tak molbalʼib, man quiqui ʼanbej i ʼatbal tzij piwi. Quix qui tzʼapij, quix qui cʼam bi chiquiwach qui ʼatol tzij, xak chiquiwach i qui gobernador xa wumal yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Xui-ri queje ile quix tiqui na chu bixquil chique wach in patan yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Chi jicba i noʼoj chi n-quix cʼachir ta tan che, wach i qui bij na, tobal iwib. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Mix cʼachir che, man yin quin ya ni i nojbal chiwe wach qui bij chique; i aj chʼoʼoj chiwij n-quiqui rik ta ʼuri wach u laʼic u wach chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Yix quix jach na piquiʼab i aj chʼoʼoj chiwij cumal i kajaw i chuch, cumal iwatz i chaʼ, cumal iwachalal, cumal tak i quetaʼam i wach; ʼo jujun chiwe que camsax na. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Conojel i winak, tzel quix quil na xa wumal yin, ");
INSERT INTO acr_acc_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","xui-ri, i Dios lic quix u chajij na; mi tene cu yaʼo we ca sachsax u wach jun i wi re i jolom. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Chix ʼolok jiquil i cʼux; we qui chʼijo, qui chʼac na i cʼaslemal sakil. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Quiwil ni tinimit Jerusalen je sutin-nak uqʼuial soldádo chirij chuwach. Are quiwil ile, iwetaʼam ʼuri ya ca sachsax u wach i tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Are ʼuri, niʼpa i je ʼo pa jyub Judéa, che ʼanmajok, che ʼoj chuwi tak jyub; niʼpa i je ʼo pa tinimit Jerusalen, che ʼelok; niʼpa i je ʼo pa tak ʼes, me tzalij chal pa tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","I tak i ʼij-le, are i ʼij re nim laj tojpen chi ʼo u chac ca petic man ca ʼantaj na pacha i tzʼibtal can chupam u wuj i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Chupam i ʼij-le, toʼ qui wach ixokib chi ʼo i yobil chiquij, xak ique chi ʼo cacʼal chi cʼa que tzʼumanic; cʼax i qui ʼanmajic ique. Nim i cʼax ca pe na chuwach i jyub-i; nim i cʼokbal ca pe piquiwi i winak-i. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ʼO ni jujun que camsax pa chʼoʼoj; ʼo ni jujun que chapi bic y naj que cʼami bi pa ronojel tak tinimit. I tinimit Jerusalen, ca kajsax ni u ʼij cumal i ne te aj Israel winak. Queje quiqui ʼan ique ile, cʼa ca qʼuis ni ʼij yatal piquiʼab rumal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Are ya ca cʼun i qʼuisbal ʼij, ʼo ni séña ʼuri che i ʼij, i icʼ, i chʼumil. Waral chuwach i jyub taʼaj, conojel i winak pa tak tinimit ʼis que cʼachiric; ʼis que xibix na, rumal i nim laj u chʼawbal i mar, xak i uwi i ya chi lic quel na chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","I winak quiqui tij na camic rumal qui xibriquil, are quiqui chʼob i cʼax chi ca pe na chuwach i jyub taʼaj. Lic quiqui xij quib, man i ʼij, i icʼ, i chʼumil que sicsax na. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Teʼuri quiquil ni Achi aj Chicaj ca cʼunic; ca cʼun pa sutzʼ, nim u choʼab, nim i u ʼij u chomal. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Niʼpa tak ile, are ca jekan u ʼonquil, yix chi sucʼba iwij; chi yaca i jolom; man iwelbal chi sak nakaj chic ʼo wi. (Queje xu bij i Jesus ile chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Teʼuri xu bij jun tijojbal tzij chique. —Chi chʼobo wach coʼon i u cheʼlal hígo, xak i juban tak cheʼ: ");
INSERT INTO acr_acc_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","are quiwil yix chi ya quel li u tux, iwetaʼam ʼuri ya ca pe i ʼalaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Xak queje ile, are quiwil yix niʼpa tak i xin bij chiwe, qui ta u be ʼuri ya ca jekan i ʼutz laj ʼatbal tzij re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Sak laj tzij quin bij chiwe, ca ʼantaj na ronojel niʼpa in bim-le, are cʼa maja que cam i winak je re woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","I caj, i ulew que sachsax na, xui-ri in tzij yin n-ca sach taj; ca ʼantaj na ronojel niʼpa in bim chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Chi chajij iwib; mi ʼan che iwib chi n-ti qui chʼob che i ʼij-le, xa rumal tij quix waʼic, o xa quix ʼabaric, o xak mas quix cʼachir che i cʼaslemal waral chuwach i jyub taʼaj. Mok xak teʼet ca pe i ʼij-le piwi are n-ti qui chʼob che. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Ca cʼunic pacha coʼon jun laso piquiwi conojel i winak chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Chix cʼacʼali-nok; mi mayij u tzʼonoxic che i Dios. Chi tzʼonoj che chi qui chʼijo, man n-quix tzak ta chupam i mac are ca pe tak i cʼax-le; queje ile, n-ta qʼuixbal chiwe are quix taqʼui chuwach i Achi aj Chicaj. (Queje u tzij i Jesus ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ʼIj ʼij i Jesus ca tijin chu cʼutic chique i winak pa rachoch i Dios; xui-ri ca kaj tak ʼij, quel pa Jerusalen, ca ʼe war pa jyub Olívos. ");
INSERT INTO acr_acc_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Are ca sakiric, ca ʼe tan chic pa rachoch i Dios y conojel i winak que upon ruʼ, chu tayic u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Ya xnakajab i nimaʼij páscua, are ʼij chi ca tijaw wi i caxlanwa chi n-ta cunbal ocnak che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","I je cajʼatzil i sacerdóte, junam cuʼ i je tijonel re i ujer ʼatbal tzij, quiqui tzucuj wach u camsaxic i Jesus quiqui ʼano, man quiqui xij quib chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Are ʼuri xoc i itzel pu cʼux i ma Júdas, chi ucab u bi, Iscarióte, are jun chique i cablajuj u tijoxelab i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ire xa ʼe cuʼ i cajʼatzil i sacerdóte, xak i nimak qui patan pa rachoch i Dios; xe u ʼijla wach u jachic i Jesus cu ʼan chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Ique xe quicotic, y xqui bij che chi quiqui ya mer che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Rumal ʼuri i ma Júdas xu junamsaj u wach cuʼ; xoc chu tzucuxic wach i jachbal re i Jesus cu ʼano, xui-ri xa aliʼal chiquiwach i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Xu rik i ʼij re i nimaʼij páscua, chi are i ʼij re u tijawic i caxlanwa pacha xec (chi n-ta levadúra che), xak are i ʼij wi chi ʼo u chac que camsax i ral tak chij chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Chupam i ʼij-le, i Jesus xu bij chique i ma Pédro y ma Wan: —Je i yijba i ka cenar re i nimaʼij páscua, —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ique xqui bij che: —¿Pa i cawaj wi caka yijba? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Xu bij chique: —Chitapeʼ: are quix oc pa tinimit, qui cʼulaj ni jun achi rucʼam jun ʼekbala ʼo ya chupam. Chix terej chirij pa coc wi che jun ja. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Chi bij che i rajaw ja: —I Tijonel xoj u tak li chu tzʼonoxic chawe, “¿Pa ʼo wi i cuárto pa quin tij wi i waʼim re i páscua cuʼ in tijoxelab? xu bij lok,” chix chok che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Teʼuri ire cu cʼut chiwe jun nim laj cuárto pu caleja, yij chic; chila chi yijba wi i ka waʼim —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","I u tijoxelab xe ʼec; are xe upon pa tinimit, ʼis xqui riko pacha u bim i Jesus chique. Teʼuri xqui yijba qui waʼim re i nimaʼij páscua. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Are xu rik i ʼor, i Jesus xcubi chi mexa, junam cuʼ i rapostelab. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Xu bij chique: —Lic in rayim na quin tij i waʼim-i re i páscua iwuʼ, tzʼakat cʼa maja quin camic. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Katzij i tzij-i quin bij chiwe: yin n-quin tij ta chic i waʼim-i cʼa ca tzʼakatsax ni u wach in patan pa ʼutz laj ʼatbal tzij re i Dios —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Teʼuri xu chap i tuʼbal ya y xu tioxij che i Dios. Teʼuri xu bij chique: —Chi chapa iri, chi jacha chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Quin bij chiwe: n-quin tij ta chic u waʼal úva, cʼa ca cʼun ni ʼutz laj ʼatbal tzij re i Dios —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Teʼuri xu chap i caxlanwa, y xu tioxij che i Dios; xu piro, y xu jach chique. Are ʼuri xu bij chique: —Are iri are in chʼacul chi quin jach na puʼab i camic, tobal iwe yix. Are qui ʼan tak iri, chi ʼana cuxtabal we yin —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Are xquelej i waʼim, queje tan chic xu ʼan che i tuʼbal ya; xu bij: —I vin-i chi caka tij na, are in quiqʼuel ca turuw na, tobal iwe yix; rumal in quiqʼuel-le ca tzʼakat u wach i trat cʼacʼ ruʼ i Dios (queje ile, i trat cʼacʼ ʼo ni u choʼab) —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","I Jesus xak xu bij: —Chitapeʼ: i jun chi quin jachaw na, ʼo chi wuʼ chi mexa. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Katzij, yin chi in Achi aj Chicaj, quin cam na pacha ʼax u chʼobom wi i Dios, xui-ri, toʼ u wach i achi chi quin jachaw na piquiʼab i je aj chʼoʼoj chwij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Teʼuri xqui jek u tzʼonoxic chiquiwach pachin chique ique ca ʼanaw nawi ile. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","I u tijoxelab i Jesus, xe oc chu chapic quib chi tzij chi pachin nawi chique ique nim ni u ʼij chiquiwach i rachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Are ʼuri i Jesus xu bij chique: —I je ʼatol tzij re u wach i jyub taʼaj, ique lic que rajawin piquiwi i winak, xak ca bix chique chi je aj ʼanol ʼutz chique. Queje ile quiqui ʼan i ʼatol tzij re u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Xui-ri, yix n-ix ta queje ile. Pachin i nim u ʼij chixol yix, chu ʼana ʼuri chʼutin che rib; pachin iwajʼatzil yix, chu ʼana pacha mocom che rib chiwij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Cwaj quin tzʼonoj jun tzij chiwe: ¿Pachin i nim u ʼij? ¿Are nawi i jun chi ca cubi chi waʼim? ¿O are i ca yaw i wa chuwi mexa? Katzij, are i ca cubi chi mexa, are i nim u ʼij. Xui-ri, yin in ʼo iwuʼ pacha in aj yol i wa chuwi mexa. (Queje u tijojbal tzij ile, cʼutbal-re chique chi niʼpa je nimak chuwach i Dios, je are i je ajchac chiquij i cachiʼil.) ");
INSERT INTO acr_acc_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","—Yix ʼut, n-in ta iwoʼtam can chuwach tak i cʼax in tijom; ");
INSERT INTO acr_acc_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","rumal-i, yin quin ya jun i ʼatbal tzij piʼab yix pacha u yom in Kajaw pinʼab yin. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Qui tij i wa, qui tuʼ i yaʼ chuwi in mexa pa in ʼatbal tzij yin. Quix cubi na pi qʼuijibal ʼo u ʼij, y qui ʼan ʼatbal tzij chique i cablajuj tzobajil je qui muk qui xiquin i cablajuj u cʼojol i mam Israel —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","I Kajwal xak xu bij che i ma Simon Pédro: —¡Ay, a-Simon! ¡Chatapeʼ! I itzel u tzʼonom chi ca yaʼ puʼab cu ʼan cʼax chiwe, ʼilbal-re we quix u tzaksaj na. Craj ire coʼon chiwe, pacha ca ʼani che i aros are ca chʼayic. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Xui-ri, yin in tzʼonom che i Dios pawi, chi n-ca sach tu cubibal a cʼux chwe. Y yet, we xicʼaw ile, are ca cʼun chic u cowil a cʼux, che a cowij awachalal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Teʼuri i ma Simon xu bij che: —Wajwal, yin in yij chic quin ʼe awuʼ cʼa pa cárcel; o xak we pa camic, quin ʼe awuʼ —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","I Jesus xu bij che: —A-Pédro, chatapeʼ, woʼor mísmo, are maja ca chʼaw i teren re u sakirbal, ca bij na oxmul chi n-awetaʼam ti in wach —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Teʼuri i Jesus xu bij chique u tijoxelab: —Are xix in tak bi chu bixquil u tzij i Dios pa tak aldéa, n-xin ya ta chiwe we qui cʼam bi i teb, mi tene yabal i mer, mi tene i xajab. Are xi ʼan yix ile, ¿ʼo nawi xoʼon palt chiwe? —xu bij. —N-taj —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Are ʼuri xu bij chique: —Woʼor, n-queje ta chic ile qui ʼano. Are i chi ʼana, pachin i ʼo u teb, chu cʼama bic; xak queje i yabal u mer, chu cʼama bic. Pachin jun n-tu chʼichʼ, chu cʼayij u chaquet, loʼbal re u chʼichʼ. (Man ca pe ni chʼoʼoj chiwij wumal yin.) ");
INSERT INTO acr_acc_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Katzij i quin bij chiwe, ʼo u chac ca ʼani chwe pacha i tzʼibtal can ujer chupam u wuj i Dios. Cu bij i ujer tzij: “Quiqui bij ni winak chi ire xa aj ʼanol n-ʼus taj, xa cu kel i ʼatbal tzij, quiqui bij na.” Queje ile i tzij tzʼibtal can ujer. Chwij yin tzʼibtal wi ile; y ronojel i tzʼibtal chwij yin, ca ʼani na —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Teʼuri xqui bij: —Kajwal, chawilapeʼ, chi ʼo queb espáda —xe cha. —Coʼon ile —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Teʼuri i Jesus xel pa tinimit, xa ʼe chuwi jyub Olívos pacha ʼax coʼon wi. I u tijoxelab xe ʼe ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Are xupon chila, xu bij chique: —Chi tzʼonoj che i Dios man n-quix tzak ta chupam i mac —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Xu jach pan jubiʼ rib chique, teʼuri xuquiʼic, y xu tzʼonoj che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Xu bij: —Ta, we cawaj, chawesaj i cʼax ʼo chinwach. Xui-ri, ma ya chwe pacha i toʼ cwaj yin; are, cha ʼana pacha i cawaj yet chwe —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Teʼuri, xwinakir jun ángel chicaj, xol u ya mas u cowil u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","I Jesus lic nim i bis ʼo chu cʼux, rumal-i xu cowij u tzʼonoxic che i Dios, y xel u cʼatanal pacha quicʼ ca tzʼujuw pulew. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Are xwalij chu tzʼonoxic che i Dios, xa ʼe chic cuʼ u tijoxelab. Xe u riko xa que waric; lic je cosnak rumal qui bis. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Xu bij chique: —¿Wuchac quix waric? Chix walijok, chi tzʼonoj che i Dios chi n-quix tzak ta chupam i mac —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","I Jesus cʼa ca tijin chi tzij are xe upon uqʼuial winak ruʼ. ʼO jun achi nabe chiquiwach: are i ma Júdas, chi jun chique i cablajuj u tijoxelab. Ire xtejeb pan ruʼ i Jesus, tzʼubal-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","I Jesus xu bij che: —A-Júdas, ¿Ruʼ bari jun tzʼubanic ca ʼan-na, ca jach ni Achi aj Chicaj piquiʼab i aj chʼoʼoj chirij? —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","I u tijoxelab, are xquilo wach quiqui ʼan i je rachiʼilam i ma Júdas, ique xqui tzʼonoj che i Jesus: —Kajwal, ¿ʼutz nawi caka coj chʼichʼ chique? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Y ʼo jun chique xresaj li u chʼichʼ y xu soc i takon re i ʼatz laj sacerdóte; xresaj u xiquin wikabim. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Xui-ri, i Jesus xe u ʼatij: —Coʼon ile —xu bij chique. Teʼuri xu chap u xiquin i takon y xrutzirsaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ique chi je cʼun-nak chu chapic i Jesus je are i ajwab sacerdóte, xak i je cajʼatzil i policía re i rachoch i Dios, xak i nimak tak mamʼib. I Jesus xu bij chique: —¿Wuchac quix cʼun yix ruʼ chʼichʼ, xak ruʼ cheʼ, pacha qui ʼan che jun iliʼom? ");
INSERT INTO acr_acc_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Yin ʼij ʼij, xin upon iwuʼ pa rachoch i Dios, y yix mi tene xi cowij i cʼux che in chapic. Xui-ri, ya xu rik i ʼor yatal chiwe yix; are i ʼor iri chi qui ʼano pacha i nojim na. Are ʼor iri, yatal che i rajaw i ʼekumal —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Teʼuri xqui chap i Jesus y xqui cʼam bi pa rachoch i ʼatz laj sacerdóte; i ma Pédro toʼ chi naj xterej bi chiquij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Are xe oc chila, ʼo jujun xqui nucʼ qui ʼaʼ chu nicʼajal uwaja y xe cubi chu chiʼ; xak i ma Pédro xa ʼe cubi cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Jun ixok ajchac pa rachoch i cajʼatzil i sacerdóte xril i ma Pédro cul chi ʼaʼ; xu maj u takexic y xu bij: —Xak i achi-ri are rachiʼil i jun chi xchaptajic —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","I ma Pédro xruwaj u wach i Jesus; xu bij: —Ixok, yin n-wetaʼam tene u wach —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Xoʼon pan jubiʼ, jun achi xril i ma Pédro y xu bij che: —Xak yet at cachiʼil ique —xu bij. I ma Pédro xu laʼ u wach che: —¡N-in ta cachiʼil! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Colo jun ʼor u bixquil, ʼo jun chic lic xu bij: —¡Katzij i achi-ri, lic rachiʼil ire, man xak aj Galiléa! —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","I ma Pédro xu bij: —Achi, n-wetaʼam taj wach i ca bij —coʼono. Cʼa ca tijin chi tzij, juntir xchʼaw jun teren. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Are ʼuri i Kajwal xu pisquilij u jolom y xu cʼam u takexic i ma Pédro. Are ʼuri i ma Pédro xcʼun u tzij i Kajwal pu jolom, wach u bim che: “Woʼor mísmo, are maja ca chʼaw i teren, quin awuwaj oxmul,” u bim che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","I ma Pédro xel chila. Lic cʼax xu na u cʼux; lic xoʼ rumal wach i xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","I achiab chi je aj chajal re i Jesus, xqui yoʼya y xqui chʼayo. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Xqui tzʼapij u wach che cʼul y xqui chʼay chu palaj. Teʼuri xqui bij: —Cha bij chake pachin xat chʼayawic —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Lic qʼui i tzij xqui bij che, toʼtabal-re. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Are xel li ʼij, xqui mol quib i nimak tak mamʼib re i tinimit, xak i je cajʼatzil i sacerdóte, xak i tijonel re i ujer ʼatbal tzij. Teʼuri xqui cʼam bi i Jesus pa qui nucʼbal. Are ʼo chiquiwach, xqui tzʼonoj che: ");
INSERT INTO acr_acc_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","—Cha bij chake ¿at are nawi yet i Crísto, i Tolke chi koyʼem? —xe cha. Ire xu bij chique: —We quin bij chiwe, n-qui coj taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Xak we ʼo jun tzij quin tzʼonoj chiwe, yix n-quix chʼaw taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Xui-ri, woʼor mísmo i Achi aj Chicaj coc pu qʼuijibal pu wikabim i Dios chi ʼatz u choʼab —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Are ʼuri conojel xqui tzʼonoj che: —¿Yet nawi ʼut, at u Cʼojol i Dios? —xe cha che. I Jesus xu bij: —Sak laj tzij i xi bij —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Are ʼuri xqui bij: —¿Wach chic tzij cakaj? N-ta chic u chac we ʼo juban chic winak col qui bij u mac, ¡Yoj mísmo xka ta! Ire ruʼ u chiʼ xu bij —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Teʼuri, ʼis xe walij conojel, y xqui cʼam bi i Jesus chuwach i ma Piláto. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Chila xqui jek u cojic u mac; xqui bij: —Ka rikom i achi-ri, ca tijin chi qui tunic i kach aj tinimit. U bim chi n-ʼus taj caka toj alcawal che i ʼatol tzij. Xak cu bij chi are ire i Crísto chi queʼelok ʼatol tzij cʼun-nak kuʼ —xe cha. (Queje qui tzij ile, i je aj cojol u mac i Jesus chuwach i ma Piláto.) ");
INSERT INTO acr_acc_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ire xu tzʼonoj che i Jesus: —¿Yet at ʼAtol Tzij que i aj Israel winak? —xu bij che. I Jesus xu bij: —Are ile, pacha i xa bij yet —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Teʼuri ma Piláto xu bij chique i cajʼatzil i sacerdóte xak chique i winak: —N-tu mac i achi-ri quin rik yin —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ique xa quiqui cowij u cojic u mac. Xqui bij: —Rumal u cʼutunic ire-le, i winak toʼ que chʼokowic ronojel i jyub Judéa. Xu jek u ʼonquil chila pa Galiléa, y woʼor cʼun-nak chi —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","I ma Piláto, are xu ta chi xqui cuxtaj i Galiléa, xu tzʼonoj chique we i Jesus aj Galiléa winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Are xqui bij chi katzij, aj Galiléa, xu tak bi ʼuri ruʼ i ma Heródes, chi ʼatol tzij puwi i jyub Galiléa. N-cʼax tu ʼonquil ile, man i ma Heródes che tak i ʼij-le ʼo pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Ire, are xupon i Jesus chuwach, lic ca quicotic; ya ujer tan u rayim rilic u wach, man u tom rason wach ca tijin chu ʼonquil. Craj ire cril jun milágro cu ʼan i Jesus chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Mas i tzij xu tzʼonoj che, xui-ri i Jesus n-xu laʼ tu wach che, mi ta jun tzij xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Teʼuri i cajʼatzil i sacerdóte, xak i je tijonel re ujer ʼatbal tzij lic xqui jek tan chic u cojic u mac. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","I ma Heródes, junam cuʼ u soldádo, toʼ quiqui tzeʼej i Jesus, toʼ xquetzʼbej u ʼij. Xqui coj li jun u ʼuʼ lic chom, pacha re jun ʼatol tzij, yoʼyabal-re; teʼuri i ma Heródes xu tzalijsaj chubi ruʼ i ma Piláto. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Teʼuri i ma Piláto ruʼ i ma Heródes xqui jek u ʼijlaxic quib chiquiwach; man oʼonom-lok n-cacaj ta te quib. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","I ma Piláto xe u mol qui chiʼ i cajʼatzil i sacerdóte, xak i u wi qui jolom i tinimit, xak i toʼ winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Xu bij chique: —Yix xi cʼam li achi-ri chinwach y xi bij chwe chi xa que u tun i winak, xi bij. Lic chiwach yix, xin taqʼui na pa rakan, y n-in rikom tu mac pacha u mac i cojom yix. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Xak i ma Heródes, n-xu rik tu mac; xa u takom tan chic li wuʼ yin. I achi-ri, n-tu mac u ʼanom we ca camsaxic. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Rumal-i, xui quin tak u yaʼic u loʼxic, y cwoʼtaj bic —xu bij i ma Piláto chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pa tak nimaʼij páscua, i ma Piláto ʼo chukul croʼtaj bi jun aj prexil chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Conojel i winak xe siqʼuin chu bixquil: —¡N-cakaj ti achi-le! ¡Cha camsaj! —xe cha—. ¡Chawoʼtaj i ma Barabas chake! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","I ma Barabas-le, tzʼapilic man xu jek jun chʼoʼoj chirij i ʼatbal tzij pa tinimit, xak u ʼanom i camic. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","I ma Piláto, craj ire croʼtaj i Jesus, rumal-i xe u ʼijla chic i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Xui-ri, ique xa xe siqʼuin che: —¡Cha camsaj chuwach cruz! ¡Cha camsaj chuwach cruz! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","I ma Piláto xu tzʼonoj uroxmul chique: —¿Wach rumal? N-ta jun u mac xin riko we ca camsax na. Quin tak ʼuri u yaʼic u loʼxic, teʼuri cwoʼtaj bic —coʼon i ma Piláto chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ique xa xe siqʼuin mas chu bixquil chi ʼo u chac ca camsax chuwach cruz. Rumal i qui siqʼuinic ique, junam cuʼ i cajʼatzil i sacerdóte, xqui loʼoj pacha i quiqui tzʼonoj. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Rumal-i, i ma Piláto xu ʼan ʼatbal tzij che i Jesus pacha i xqui tzʼonoj chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Xroʼtaj i ma Barabas pacha xcaj ique, ire-le chi tzʼapil te rumal i chʼoʼoj u yacom, xak rumal i camic u ʼanom. Teʼuri xu jach i Jesus piquiʼab, quiqui ʼanbej che pacha cacaj ique. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Xqui cʼam bi i Jesus pa i quiqui camsaj wi. Are que tijin chi be, xqui cʼulaj jun achi aj pa tinimit Ciréne, ma Simon u bi; ire te xcʼun pa tak jyub. Xqui tacʼba y xqui ya bi cruz rij u kul; teʼuri xqui ʼan pen che chi ca terej bi chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Je qʼui i winak je teren chirij; chiquixol i winak-le, je qʼui ixokib que oʼ che i Jesus, que siqʼuinic rumal i qui bis. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","I Jesus xu pisquilij rib y xu bij chique: —Yix, ix ixokib ix aj Jerusalen, mix oʼ chwe yin. Are, chix oʼ rumal i cʼax chi ca pe na piwi yix, xak piquiwi iwacʼal. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ca cʼun ni ʼij chi qui bij na: “ʼUtz que ique chi n-xqʼuiji ta cacʼal; ʼutz que ique chi n-xe alan taj; ʼutz que ique chi n-qui tzʼumansam ta cacʼal,” qui bij na, rumal i cʼax chi ca pe na piwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Coʼon panok, i winak quiqui bij na che i nimak tak jyub, “¡Chix tzak li chikij!” Xak quiqui bij na che i ral tak jyub, “¡Choj i chʼuku!” que cha na (man lic quiqui xij quib chuwach i cʼax ca petic). ");
INSERT INTO acr_acc_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Cʼax iri chi que tijin chu ʼanic chwe yin woʼor; xui-ri, mas cʼax ca ʼan na chique i aj Israel coʼon panok —xu bij i Jesus chique i ixokib. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Xak je ʼo queb chic achiab xe qui cʼam bic quiqui camsaj junam ruʼ i Jesus; ique, che queb, ʼo qui mac chuwach i ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Are xe upon che jun ral jyub chi “U jolom anma” u bi, i soldádo xqui rip i Jesus chuwach cruz. Xak xe qui rip i queb chi ʼo qui mac, jun pu wikabim i Jesus, i jun chic pu moxim. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Are xqui rip i Jesus chuwach cruz, ire xu bij che i Dios: —Ta, cha cuyu qui mac; n-quetaʼam taj wach que tijin chu ʼonquil —xu bij. I soldádo xqui ʼan saquinic chirij u ʼuʼ i Jesus, ʼilbal-re pachin ca chʼacaw bi chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","I winak je tacʼal bic, toʼ que takenic; xak i qui wi qui jolom toʼ que tzen che i Jesus. Xqui bij: —Ire-le ʼo i xe u to na, woʼor ʼuri chu to rib ire, we kas katzij are i Crísto, chi chatal rumal i Dios —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Xak i soldádo xqui yoʼya u ʼij. Xe tejeb pan ruʼ y xqui sujuj víno chʼam che. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Xqui bij che: —We at qui ʼAtol Tzij i aj Israel winak, cha to awib yet —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ʼO juban tzij tzʼibtal puwi ʼan i cruz, tzʼibtal piqui chʼawbal i aj Griégo, xak piqui chʼawbal i aj Latin, xak piqui chʼawbal i aj Hebréo winak. I tzʼib, queje iri cu bij: “Are iri, are i ʼAtol Tzij que i aj Israel winak,” coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Teʼuri, ʼo jun chique i queb chi je riptal ruʼ, xu yoʼya pan i Jesus: —Yet, we katzij at Tolke, cha to awib y choj a to yoj —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Are ʼuri, i rachiʼil xu laʼ u wach che; xu bij: —¿Yet, n-ca xij ta ba awib che i Dios? Xak junam i camic caka ʼan yoj ruʼ i jun-le. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Xui-ri, yoj, ca majaw chake caka tij i cʼax-i, xa coj tijin chu tojic i ka mac pacha usucʼ, péro i achi-le n-tu mac u ʼanom —xu bij che i rachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Teʼuri xu bij che i Jesus: —Ma Jesus, min a sach pa cʼux are cat oc che a ʼatbal tzij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","I Jesus xu bij che: —Sak laj tzij i quin bij chawe: woʼor cat oc na wuʼ pa glória —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Are xticʼoj i ʼij, xoʼon ʼekum ronojel u wach i jyub taʼaj; queje xoʼon ile cʼa a las tres re u kajbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Lic xtzʼaptaj u wach i ʼij. Xak i nim laj cortin pim chi ʼo pa rachoch i Dios xrakchʼix pa nicʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Teʼuri, i Jesus co xchʼawic: —Ta —xu bij—, ¡Woʼor cwokxanij i wanima paʼab! Are xu bij ile, xel u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","I cajʼatzil i soldádo, are xrilo wach i xa ʼanic, lic xu coj u ʼij i Dios. Xak xu bij: —Katzij i achi-le lic n-tu mac u ʼanom —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Niʼpa i winak chi xe moltaj chi rilic u camsaxic i Jesus, are xquilo wach i xa ʼanic, lic xe oc chi bis; rumal-i, que tijin chu chʼayic u wach qui cʼux, xe ʼe chi cachoch. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Conojel i quetaʼam u wach i Jesus xa xe taqʼui cʼa naj. Xak queje xqui ʼan i ixokib chi je teren li chirij cʼa pa Galiléa; cʼa naj xe taqʼuiʼic xe taken lok. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ʼO jun achi, ma Jose u bi, lic ʼutz laj achi, sucʼul u cʼux chuwach i Dios. Ire aj Arimatéa, jun tinimit u cwenta i jyub Judéa. Are ire jun chique i aj nucʼanel tʼisanel que i aj Israel winak, xui-ri, ");
INSERT INTO acr_acc_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ire nu yom tu wach cuʼ i je rachiʼil; n-xraj taj wach xqui ʼan ique che i Jesus. Ire xu rayij chi ca jekan i ʼatbal tzij re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Ire-le xa ʼe ruʼ i ma Piláto y xu tzʼonoj u chʼacul i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Teʼuri xa ʼe chu kajsaxic che i cruz, y xu pasij pa sawan. Teʼuri xu ya chupam jun pantion cʼacʼ worom pa abaj chi n-ta winak muktal chupam. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I ʼij-le are i ʼij re u yijbaxic i uxlambal ʼij, man ya ca jekan i uxlambal ʼij que i aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","I ixokib chi je cʼun-nak ruʼ i Jesus cʼa Galiléa, xe terej bi chi rilic pa i ca muki wi, xak wach u cotzʼbaxic u chʼacul ca ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Teʼuri xe tzalij che i cachoch y xqui yijba i cunbal muy, xak i acéite que i camnak. Are xjekan i uxlambal ʼij, xe uxlanic, pacha cu bij i ujer ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Re u sakirbal domíngo, i ixokib xe ʼe chic pa muktal wi i Jesus; xqui cʼam bi i cunbal muy chi qui yijbam. ʼO juban chic ixokib xe cachiʼilaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Are xe uponic, xquilo chi i abaj tzʼapbal re u chiʼ i jul ya ʼelsam chic pu qʼuijibal. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Are ʼuri, xe oc bi chupam, péro n-xqui rik ti u chʼacul i Kajwal Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Lic xqui bisoj rumal, n-quiqui rik taj wach quiqui ʼano. Xak teʼet xe quil queb achiab je tacʼal chila, lic ca walchʼin qui ʼuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Mas xe oc ʼil che, y xqui lucba qui palaj pulew. Are ʼuri i queb achiab xqui bij chique: —¿Wuchac qui tzucuj jun cʼaslic cuʼ i camnak? ");
INSERT INTO acr_acc_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ire n-chi ta chic ʼo wi; xcʼun sak chuwach. Cha cʼun chi cʼux wach xu bij chiwe cʼa are ix ʼo pa jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Xu bij chiwe chi i Achi aj Chicaj ʼo u chac ca jachtaj na piquiʼab i ajmac laj tak winak, xak ca rip na chuwach cruz, xak ca cʼunsax sak chuwach churox ʼij. Queje u tzij ile chiwe —xe cha i ángel chique i ixokib. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Are ʼuri xcʼun u tzij i Jesus chi qui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Teʼuri xe tzalij li chila pa i muktal wi, y xqui ya u tzijol chique i julajuj apostelab, xak i juban chi je terejnak chirij. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Are i ixokib chi xe bin chique ique-le, je are ati Mariy Magdaléna, xak ati Wan, xak i ati Mariy chi u chuch i ma Jacóbo. Ique-le cuʼ i juban ixokib xqui bij chique i apostelab wach i xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","I qui tzij i ixokib, xa chʼuj laj tzij xqui ta i apostelab; n-xqui coj taj. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Xui-ri, i ma Pédro xwalijic, xa ʼe paʼanem pa ʼo wi i pantion. Are xtzun pan chupam, xrilo xui chic i sawan ʼo canok. Teʼuri xa ʼe chi rachoch; lic cu bisoj wach i xa ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Che i ʼij-i, je queb chique u tijoxelab i Jesus que ʼe che jun aldéa, Emaus u bi; colo oxib légua u najtil che i Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Are que tijin chi be, que tijin chu chʼachʼaxic niʼpa i xcʼulmax pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Are quiqui lap ile, cʼa que tijin chi tzij, are ʼuri i Jesus mísmo xtejeb cuʼ, y xe ʼe junam. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Xui-ri ique n-xquetamaj tu wach; xa pacha chʼuktal jubiʼ qui baʼwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","I Jesus xu tzʼonoj chique: —¿Wach i qui lapo are quix tijin chi be? ¿Wuchac quix bisonic? —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Jun chique, ma Cleófas u bi; ire xu laʼ u wach che y xu bij: —Conojel i winak ʼis quetaʼam wach i xa ʼani pa Jerusalen che tak i ʼij-i. Conojel i aj solinel chila quetaʼam chic, ¿xui bari yet n-awetaʼam taj? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","—¿Wach ʼuri? —xu bij i Jesus chique. —Chi xqui ʼan che i ma Jesus aj Nazaret —xqui bij—. Ire jun nim laj ajbil u tzij i Dios. Wach i xu ʼano, wach i xu bij, nim xril i Dios, nim xquil conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Xui-ri, i cajʼatzil i sacerdóte junam cuʼ i ka wi ka jolom, xqui jach na puʼab i ʼatbal tzij. Xqui ʼat tzij puwi chi ca camsaxic; y chuwach cruz xqui camsaj wi. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Chakawach yoj, mok are ire coj ʼelsaw pa pen oj aj Israel winak, xui-ri, xqui camsaj; are urox ʼij iri u ʼonquil canok. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ʼO jujun ixokib je kachiʼilam, xoj qui coj ʼil, man sakiric xe upon pa i muktal wi, ");
INSERT INTO acr_acc_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","y n-xqui rik ti camnak. Xe cʼun kuʼ y xqui bij chake chi xquil queb ángel chila; xbix chique chi ire cʼaslic, que cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Xe ʼe jujun chake pa i muktal wi; xqui riko xak jun ruʼ pacha xqui bij ixokib, xui-ri, n-xquil tu wach i ma Jesus. (Queje xqui bij i queb achiab ile che i Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Ire xu bij ʼuri chique: —¡Ay, yix n-qui chʼob taj! ¿Umpa nawi qui coj piwanima niʼpa i xqui bij i ajbil u tzij i Dios ujer? ");
INSERT INTO acr_acc_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿N-iwetaʼam ta bari, chi i Crísto ʼo u chac cu tij ni uyej-le, teʼuri cocsax ni u ʼij? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Teʼuri xu jek u sakixic chique niʼpa i tzʼibtal ujer chirij ire; nabe, wach u tzʼibam can i mam Moises, teʼuri, wach qui tzʼibam can conojel i ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Xe upon che i aldéa pa i que ʼe wi. I Jesus xu ʼano pacha ca ʼe pan jubiʼ chic. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ique n-xqui ya ta che ca ʼec. —Chat canaj kuʼ yoj —xe cha—; ya xkaj i ʼij, ya coc ʼekum —xe cha. Are ʼuri, xoc cuʼ man ca canaj cuʼ chaʼab. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Are je cul chi mexa, i Jesus xu chap i caxlanwa, y xu tioxij che i Dios. Teʼuri xu piro y xu jach chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Are xu ʼan ire ile, pacha tak xjaktaj qui baʼwach y xquetamaj u wach; are ʼuri ire xsach ʼan chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Teʼuri xqui bij chiquiwach: —¿Wach xa na yet pa cʼux are xlapan ire kuʼ pa be? ¿Xa na jun nim laj ʼil? ¡Yin xin naʼo! are ca tijin chu sakixic i ujer tzij chake —xe cha chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Juntir xe walijic y xe tzalij chic pa Jerusalen. Chila xe qui rik i julajuj apostelab qui molom quib cuʼ juban chic cachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Ique xqui bij chique i queb: —¡Katzij, i Kajwal xwalijic; xu cʼut rib che i ma Simon! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Teʼuri i queb xqui lap chique wach xqui cʼulmaj pa be, xak wach i retamaxic u wach i Jesus xqui ʼano, are xu pir i caxlanwa. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Are que tijin chu chʼachʼaxic tak ile, xak teʼet i Jesus xwinakir ʼan cuʼ, y xu ya rutzil qui wach: —¡Chuxlan i cʼux! —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Ique lic xe oc ʼil; lic xqui xij quib. Quiqui bij ique xa jun anma xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","I Jesus xu tzʼonoj chique: —¿Wuchac qui xij iwib? ¿Wuchac ʼo i cu bij i cʼux? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","—Chiwila in ʼab, i wakan, ¡chi lic yin! Chin i chapa, chiwilapeʼ, man jun anma n-tu bakil, n-tu tiʼijlal pacha quiwil chwe yin-i —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Are xu bij ire ile, xu cʼut u ʼab i rakan chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ique maja quiqui cojo we are i Jesus ʼo chiquiwach. N-xe tiqui ta chu cojic rumal qui quicotemal lic nim; cʼa je bisor-nak che. Rumal-i, i Jesus xu tzʼonoj chique: —¿ʼO i ca tijaw chi? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Teʼuri xqui ya chʼakap bolom car che, ruʼ chʼakap ʼakaj ʼo cab che. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ire xu chapo y xu tij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Teʼuri xu bij chique: —Niʼpa iri chi xa ʼani chwe, xak jun ruʼ tak i xin bij chiwe are in ʼo iwuʼ. Niʼpa i tzʼibtal chwij yin, ʼis ʼo u chac ca ʼani na chwe; ronojel tak i u tzʼibam can i mam Moises, xak ronojel tak i qui tzʼibam can i ujer ajbil u tzij i Dios, xak wach i tzʼibtal can chupam i wuj Sálmos —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Teʼuri xu ya qui nojbal, man quiqui ta u be niʼpa i tzʼibtal can ujer chupam u wuj i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Xu bij chique: —Are i tzʼibtal canok are iri: “I Crísto ʼo u chac ca camsaxic, teʼuri ca cʼunsax na sak chuwach churox ʼij.” ");
INSERT INTO acr_acc_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Xak ca paxsax ni u tzijol i cuybal mac; rumal i Crísto ʼo i cuybal mac chique niʼpa quiqui jalwachij qui cʼaslemal. I u paxsaxic i tzij-le, ca ʼani na cumal i je u takon i Crísto. Pa Jerusalen, ca jekan nu bixquil, teʼuri ca paxsax rason ronojel tak i tinimit chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Yix iwilom wach in ʼanom, ix ajbil-re ʼuri chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Chitapeʼ, yin ya quin tak li Jun piwi chi u bim chic in Kajaw quix rucʼaj na. Xui-ri, mix ʼe tan, chiwoyʼej na waral pa Jerusalen cʼa ca kaj na li u choʼab i Dios piwi. (Queje xu bij i Jesus ile chique i u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Teʼuri xe ʼel bic, xe u cʼam bi cʼa che i aldéa Betánia; are je ʼo chila xu yac u ʼab y xu tzʼonoj che i Dios piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Are ca tijin chu tzʼonoxic che i Dios piquiwi, xel chiquixol, y xcʼam bi chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Are ʼuri ique xqui coj u ʼij, teʼuri xe tzalij pa Jerusalen, lic que quicotic. ");
INSERT INTO acr_acc_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ʼIj ʼij je ʼo pa rachoch i Dios, que tijin chu cojic u ʼij i Dios. Amen (katzij).");
INSERT INTO acr_acc_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Are cʼa maja ca jekan u xebal ʼij sak, i Crísto ʼax ʼo wi. Ire ʼo ruʼ i Dios; ire lic Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Cʼa chu xebal, ire ʼax ʼo wi ruʼ i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ronojel niʼpa i ʼolic, are ire xa ʼanawic junam ruʼ i Dios; n-ta xak ʼolic we n-are ti ire xa ʼanawic. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Are ire, are u xebal ronojel i cʼaslemal; i cʼaslemal chi ca pe ruʼ ire, lic are i sak, ca sakirsaw qui nojbal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Are i sak-i, ca tzun chupam i ʼekumal; i ʼekumal n-ca tiqui ta chu chupic i sak-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Xu rik i ʼij, i Dios xu tak li jun u takon, jun achi, ma Wan u bi. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Are u chac i achi-le, are cu bij chique i winak wach usucʼ i sak-le. Xol u bij i tzij chique, ʼutz conojel quiqui coj che pachin ca yaw i sak chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","N-are ti ma Wan ca yaw i sak-le, ire xa col u lapa i Jun chi ca yaw i sak-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Queje ile xu ʼano man i Jun chi ca yaw i sak-le ya ca nakajab u cʼunic chuwach i jyub taʼaj. (Are ire are i Crísto, chi ca tzunsaw qui nojbal conojel i winak.) ");
INSERT INTO acr_acc_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ire xcʼun chuwach i jyub taʼaj; tupu are ire ʼanawnak i jyub taʼaj, xui-ri, i winak n-xquetamaj tu wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ire xol ʼol cuʼ i ratz u chaʼ chi je rach aj tinimit, xui-ri, ique n-xqui cʼulaj ta cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Xui-ri, ʼo jujun xqui cʼulaj cuʼ, y xqui cuba qui cʼux che; ique ʼut, xyaʼ chique xe u ʼon racʼal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","N-queje ta pacha cacʼal toʼ winak, n-queje ta pacha i je alaxnak xa rumal qui rayijbal i winak, n-queje taj; lic are i Dios xoʼon racʼal chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","I Crísto (chi “U Tzij i Dios” bital che) xoʼon achi che rib, y xqʼuiji chakaxol. Lic nim i cʼaxnabal u cʼux; lic xu cʼut i sak laj tzij re i Dios chake ruʼ wach tak i xu ʼano. Yoj kilom u ʼij u chomal chi xui ruʼ ire ʼo wi, chi are i mer Racʼal i Dios; xa jun ʼolic. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","I ma Wan aj kajsanel ya xu bij pachin ire. Xu bij: —I achi-ri are i Jun chi xin lap chiwe, are xin bij chi ca cʼun Jun chic chwijil yin, ʼatz u ʼij chinwach yin, man ire ʼax ʼo wi are xin alax yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Lic nim i rutzil u cʼux, rumal-i, qʼui i ʼutz cu ʼan chake; lic u terbalam rib i utzil chomal re ire chake. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Man i ʼatbal tzij re i Dios, are i mam Moises xcʼutuw chake; xui-ri, are i Jesucrísto xcʼutuw chake chi Dios cʼax coj u naʼo, xak xu sakij chake wach i sak laj tzij re i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","I Jesucrísto, lic xak jun qui cʼux, xak jun qui noʼoj ruʼ i Dios. Mi jun ʼilawnak u wach i Dios; xui-ri, ketaʼam u wach rumal i Racʼal chi lic xa jun chirij, lic ruʼ ire petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","(ʼO jun achi, ma Wan u bi, xnabeaj chuwach i Jesus. Ire ca tijin chu kajsaxic ya piquiwi i winak chu chiʼ i ya Jordan.) Are ʼo chila, xe upon juban sacerdóte, xak juban aj patanib re i rachoch i Dios pa Jerusalen. Ique je taktal bi cumal i qui nimakil i aj Israel winak chu tzʼonoxic che i ma Wan pachin ire (mokxa are i Crísto). ");
INSERT INTO acr_acc_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ire n-xruwaj tu wach, xu bij chique chi n-are taj. Ile pusucʼ i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Teʼuri xqui tzʼonoj chic che: —¿At pachin ʼut; mok yet at ajbil u tzij i Dios mam Elías, mok xat walij chic? —xe cha. I ma Wan xu bij: —N-yin taj —coʼono. Y xqui bij chic che: —¿Mok yet at are i nim laj ajbil u tzij i Dios chi koyʼem? Ire xu bij: —N-yin taj. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","—¿At pachin ʼut? Man yoj que ʼe ka bij chique i xoj qui tak lok. ¿Wach usucʼ a patan ʼut? —que cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","I ma Wan xu bij chique: —Yin in are i jun chi xu bij i mam Isaías ujer chi ca cʼun na. In are i jun chi ca siqʼuin chu bixquil i tzij-i pa tak jyub tzʼinilic: “¡Ya ca pe i Kajwal! Chi sucʼba i u be chu wach” —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","I achiab, chi xqui tzʼonoj che ma Wan pachin ire, je takom bi cumal i aj Fariséo winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Teʼuri xqui tzʼonoj chic che: —We n-yet ti at Crísto, mi mam Elías, mi i nim laj ajbil u tzij i Dios chi koyʼem, ¿wuchac ʼut ca kajsaj ya piquiwi i winak? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","I ma Wan xu bij chique: —Yin, katzij quin kajsaj ya piquiwi i winak, péro chixol yix ʼo jun nim laj winak n-iwetaʼam tu wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ire ca cʼun chwijil yin, xui-ri, ʼax ʼo wi chinwach yin. Nim ni u ʼij ire chinwach yin; n-ca majaw ta chwe quin ʼan mocom che wib chirij ire, mi tene ca majaw chwe quin quir u wach u xajab che —xu bij i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ronojel iri xa ʼani che jun taʼaj u bi Betábara, chʼaka ya re i Jordan, chila pa cu kajsaj wi ya i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Chucab ʼij, i Jesus xupon ruʼ i ma Wan. Ire, are xril u wach i Jesus, xu bij chique i winak: —Chiwilapeʼ, are i Jun-i are pacha jun ral chij chi ca camsax chuwach i Dios tojbal re qui mac i winak ronojel u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Are ire-le xin lapo are xin bij chi ca cʼun jun chwijil yin chi lic ʼatz u ʼij chinwach yin, man ʼax ʼo wi chinwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Yin n-wetaʼam ta teʼek pachin ire, xui-ri, xin paxsaj rason chique i aj Israel. Are rumal-i xin cʼunic, xin kajsaj ya piquiwi i winak —xu bij ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Xak xu bij: —I u Tewal i Dios xkaj li chicaj pacha palomax ca ʼanawic. Xkajic y xcanaj puwi i achi-le. Yin mísmo xwilo. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Yin n-wetaʼam ta teʼek pachinok, péro i Dios chi xin u tak chu kajsaxic ya piquiwi i winak xu bij chwe: “Coʼon panok, in Tewal ca kaj lok y ca canaj puwi jun achi; are cawil ile, cawetamaj ʼuri chi i achi-le are i ca kajsaw in Tewal piquiwi i winak.” Queje ile xu bij i Dios chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Yin wilom chic pacha i xu bij i Dios; rumal-i, quin bij chiwe chi i achi-le lic are i Racʼal i Dios —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Chucab ʼij, ʼo tan chic i ma Wan aj kajsanel ya chu chiʼ i ya-le, xak je ʼo queb u tijoxelab ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","I ma Wan xril u wach i Jesus chi xicʼaw pan chu nakaj; xu cʼut chique i winak y xu bij chique: —Chiwilapeʼ, are ire-le, are i pacha i chij chi u yom ni Dios pa ka qʼuexel, tojbal-re ka mac —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","I queb u tijoxelab i ma Wan, are xqui ta ile, xe terej bi chirij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","I Jesus xtzun chirij, xe ril i queb chi je teren bi chirij, y xu bij chique: —¿Wach quiwaj wuʼ? —xu bij. Ique xqui bij: —Tijonel ¿Pa at jekel wi? ");
INSERT INTO acr_acc_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","I Jesus xu bij chique: —Chol iwila —coʼono. Teʼuri ique xe ʼe ruʼ y xquilo pa jekel wi. I ʼor-le, colo a las cuátro re u kajbal ʼij, y xe kajsan ʼij ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Queje ile xqui ʼan i queb chi xqui ta u tzij i ma Wan y xe terej bi chirij i Jesus. Jun chique are i ma Andres, chi ratz u chaʼ i ma Simon Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","I ma Andres-le, juntir xa ʼe la chu tzucuxic i ma Simon, y xu bij che: —Ka rikom i Mesías, i Jun chi chatal rumal i Dios chaka toʼic —xu bij. I usucʼ i tzij-le queʼelok “i Crísto”. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Teʼuri i ma Andres xu cʼam bi i ma Simon ruʼ i Jesus. I Jesus, are xril u wach, xu bij che: —Yet at a-Simon, racʼal i ma Jonas, péro yin quin ya pa bi woʼor: chi at a-Céfas —xu bij. I tzij a-Céfas xak queʼelok a-Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Chucab ʼij, i Jesus xu chʼob ʼenam pa Galiléa; xu rik chuwach i ma Felípe y xu bij che: —Jo wuʼ —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","I u tinimit i ma Felípe, are i Betsáida, xak jun qui tinimit cuʼ i ma Andres y ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Teʼuri i ma Felípe xa ʼe chu tzucuxic i ma Natanael, y xu bij che: —Ya xkil u wach i achi, chi u tzʼibam can i mam Moises ujer chi cakil na. Are i jun chi xak qui tzʼibam i ujer ajbil u tzij i Dios. I achi-le are i Jesus aj Nazaret, chi racʼal i ma Jose —xu bij i ma Felípe. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","I ma Natanael xu bij che: —¿ʼO nawi jun nim laj winak cwalij che i tinimit Nazaret? —xu bij. I ma Felípe xu bij che: —Chat petok, chol awila —coʼon che; y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","I Jesus, are xril u wach i ma Natanael chi ca tijin u tejebic ruʼ, xu bij: —I achi-ri lic ʼutz laj aj Israel; ire n-ca tʼoron taj, mi xa ta jubiʼ —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","I ma Natanael xu tzʼonoj che: —¿Wach retamaxic in wach xa ʼano? I Jesus xu bij che: —Yin xwil a wach are at ʼo chuxeʼ i cheʼ higuéra; xwil a wach are maja cat u siqʼuij i a-Felípe. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","I ma Natanael xu bij che: —At Tijonel, katzij at Racʼal i Dios; yet at ka ʼAtol Tzij chi koyʼem yoj oj aj Israel —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Teʼuri i Jesus xu bij che: —¿Quin a cojo xa rumal xin bij chawe chi xat wil chuxeʼ i cheʼ-le? Mas nim i milágro cawil na chuwach ile, cʼutbal-re in pachin yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Teʼuri xu bij: —Katzij quin bij chiwe, yix quiwil ni caj jakalic, tak i ángel re i Dios ʼo que ʼel bic, y que kaj li pinwi yin, chi in Achi aj Chicaj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Churox ʼij, ʼo jun cʼulanquil pa tinimit Cana, u cwenta i jyub Galiléa. I u chuch i Jesus ʼo chila che i cʼulanquil. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","I Jesus, tak u tijoxelab, xak je siqʼuim rumal i rajaw i cʼulanquil y xe uponic. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Are xqʼuis i víno, i u chuch i Jesus xu bij che: —Ya xqʼuis i víno —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Are ʼuri i Jesus xu bij che: —¿Wuchac ca bij ile chwe yin? Cʼa maja cu rik i ʼij quin ʼalijinsaj wach in patan —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Xui-ri, i u chuch xu bij chique i que silab chila: —Chi ʼana wach i cu bij ire chiwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ʼO wakib nimak tak cucub chila, yabal ya; ile ʼantal che abaj. I ya-le, cajwax chique i winak chʼajbal re qui ʼab, chʼajbal re qui lak pacha ʼax quiqui ʼan wi i aj Israel winak chuwach i Dios. Jujun cucub-le cu chʼij colo veinticínco galon ya. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","I Jesus xu bij chique i takon chi que silab chila: —Chi nojsaj che i ya niʼpa i cucub-i —coʼono. Ique xqui nojsaj i cucub, lic cʼa chu chiʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Teʼuri xu bij i Jesus chique: —Woʼor chiwesaj bi jubiʼ, y chi ya che i rajaw i nimaʼij —xu bij. Ique xqui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","I rajaw i nimaʼij-le xu tij jubiʼ che i ya chi yijinak chic che i víno. Ire n-retaʼam taj pa xqui cʼam wi; xui i que silab chila quetaʼam, man ique quesam li pa cucub. Are ʼuri i ca ucʼaw u tzam i nimaʼij xu siqʼuij i achi chi ca cʼuliʼic. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Are xupon ruʼ, xu bij che: —Conojel i winak, nabe quiqui ya chi tuʼic i jel laj víno. Are ʼut, we qʼui chic qui tuʼum i winak, teʼuri quiqui ya chi tuʼic i víno chi n-kas ta jel. Péro yet, n-are ti xa ʼano; cʼa pa qʼuisbal-re xawesaj li víno chi mas jel —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iri chi xu ʼan i Jesus pa tinimit Cana re i Galiléa, are i nabe milágro chi xu ʼano, cʼutbal-re i nim laj u choʼab; chila xu ʼalijinsaj i nim laj u ʼij u chomal. Teʼuri i u tijoxelab mas xqui jicba qui cʼux che. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Are xutzin ile, xa ʼe pa tinimit Capernaum, junam ruʼ u chuch, i niʼpa i u chaʼ, xak i u tijoxelab. Chila xcanaj wi queb oxib ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Xoʼon panok, ya ca nakajab i nimaʼij que i aj Israel winak, páscua u bi. Rumal i nimaʼij-le, i Jesus xa ʼe pa tinimit Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Chila pa rachoch i Dios, i Jesus xe u rik achiab chuwaja que tijin chu cʼayixic boyex, xak i chij, tak i palomax. Xak xe ril qui wach achiab chi tak mexa, quiqui cʼayij mer re i rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","I Jesus, are xrilo wach i quiqui ʼano, xu yijba jun asial, oktabal bi que conojel, niʼpa i chij, niʼpa i boyex xe roktaj bic. Y xupon cuʼ i achiab chi quiqui jalwachij mer, xu pisquilij bi qui mexa chique y xquicher bi qui mer. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Xak xe u yaj i aj cʼay palomax, xu bij chique: —¡Chiwesaj bi iri chi! Man i ja-ri, rachoch in Kajaw, ¡mi ʼan qʼuebal che! —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Are ʼuri, xcʼun piqui cʼux i u tijoxelab wach i tzʼibtal chupam u wuj i Dios: “Rumal i cʼaxnabal in cʼux che awachoch, ca sachsax in wach.” Queje ile tzʼibtal canok. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ʼO jujun nimak tak aj Israel winak chila; xqui tzʼonoj che: —¿Wach i milágro ca ʼano, cʼutbal-re chake we ʼo paʼab que awoktaj bi i aj cʼay? —xe cha che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","I Jesus xu laʼ u wach chique: —We tene qui wulijsaj i rachoch i Dios-i, che oxib ʼij quin yac tan chic cʼacʼ —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","I aj Israel winak xqui bij: —Cuarentiséis junab xe chacun chu ʼonquil i rachoch i Dios-i; ¿cat tiqui nawi yet chu yaquic che oxib ʼij? ");
INSERT INTO acr_acc_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","(Queje ile xqui bij che, man n-xqui ta tu be u tzij i Jesus.) Are i rachoch i Dios chi xu bij i Jesus, are i mísmo u chʼacul ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Y xoʼon panok, are xcamsax i Jesus, ire xwalij chiquixol i camnak churox ʼij. Teʼuri i u tijoxelab xcʼun chi qui cʼux wach u bim chila pa rachoch i Dios. Teʼuri xqui jicba qui cʼux che i tzij tzʼibtalic, tak che i tzij chi bital rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","I Jesus, are ʼo pa Jerusalen rumal i nimaʼij páscua, je qʼui i winak xqui cuba qui cʼux che ire are xquil i nimak tak milágro xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Xui-ri, ire n-xcubi tu cʼux chique, man retaʼam wach i qui nojbal conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Lic retaʼam wach i ʼo pa canima i winak, rumal-i n-tu chac we ʼo jun cu bij che wach i qui cʼux i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ʼO jun achi, ma Nicodémo u bi, nim u patan chiquixol i aj Israel winak. Ire cachiʼil i aj Fariséo. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","I ma Nicodémo-le, xa ʼe lapan ruʼ i Jesus chaʼab, y xu bij che: —Nim laj Tijonel, ketaʼam chi Dios at u takom lok, col a cʼutu chake. Ketaʼam ile man niʼpa i ca ʼano, mi jun ca tiqui chu ʼonquil we n-ti u choʼab i Dios ruʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Are ʼuri i Jesus xu bij che: —Sak laj tzij quin bij chawe: are i n-calax ta chic julaj chic, n-coc ta ʼuri che u ʼatbal tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","I ma Nicodémo xu bij che: —¿Wach u ʼonquil ʼuri chi jun achi, nim chic, calax tan chic u camul? ¿Xataba ca tiqui tan chic che i oquic pu chʼacul u chuch, y calax tan chic? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","I Jesus xu bij che: —Katzij quin bij chawe: mi jun coc che u ʼatbal tzij i Dios we n-alaxnak ta jun u cʼaslemal ruʼ ya, xak rumal i u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Jun, we xui alaxnak che u chuch u kajaw, toʼ winak ʼuri alaxnak; jun ʼut, we alaxnak u cʼaslemal rumal u Tewal i Dios, ʼo u cʼaslemal ʼuri ruʼ i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Mat oc ʼil che iri chi xin bij chawe: ʼo u chac ʼis que alax tan chic julaj chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","I tew xa ipa quicʼaw wi; yet ca ta are quicʼawic, péro n-awetaʼam taj pa ca pe wi, xak n-awetaʼam taj pa ca ʼe wi. Xak queje coʼon ile chique niʼpa i que alax tan chic rumal i u Tewal i Dios (ʼalaj chi cʼacʼ chic qui cʼaslemal, péro n-awetaʼam taj wach mer u ʼonquil) —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","I ma Nicodémo xu bij chic: —N-quin ta tu be wach u ʼonquil ile. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","I Jesus xu bij che: —Yet, chi at nim laj tijonel que i aj Israel winak, ¿n-ca ta tu be i quin bij chawe-ri? ");
INSERT INTO acr_acc_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Sak laj tzij quin bij chawe: yoj caka bij niʼpa i ketaʼam; caka bij wach i kilom, y yix n-qui coj taj wach i caka bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","We n-qui coj taj wach i quin bij chiwe re i cʼaslemal waral chuwach i jyub taʼaj, ¿wach u cojic ʼuri qui ʼano we quin lap chiwe wach usucʼ i cʼaslemal re aj chicaj? ");
INSERT INTO acr_acc_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Mi jun aj waral chuwach ulew ʼelnak bi chicaj; xui i jun chi kajnak lok rilom i chila chicaj. Ire-le are i Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","I mam Moises ujer, are je ʼo che i jyub tzʼinilic, xu ʼan jun u qʼuexwach cumatz xu yac ʼan chicaj chiquiwach i winak. Xak queje ile ʼo ni u chac chi i Achi aj Chicaj ca yactaj ni chicaj chiquiwach i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ʼO ni u chac, man queje ile, pachin jun cu cuba u cʼux che, n-ca sachsax tu wach, are, ca yaʼ u cʼaslemal chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","I Dios lic cʼax xe u na i winak chuwach i jyub taʼaj, rumal-i xu tak li u Cʼojol, chi xa jun ruʼ; queje ile xu ʼano man pachin jun cu cuba u cʼux che, n-ca sachsax tu wach, cu rik u cʼaslemal chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","I Dios xu tak li u Cʼojol chuwach i jyub taʼaj, ʼelsabal-que i winak chupam i qui mac. Are rumal-i xu tak li u Cʼojol, n-are ti yabal tojbal mac piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Pachin jun cu cuba u cʼux che Ire, n-cril ti tojbal mac, péro pachin jun n-cu cuba tu cʼux che, ʼo chic i tojbal mac ca pe puwi. Ca pe puwi man nu cubam tu cʼux che u Cʼojol i Dios, chi xa jun ʼolic. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","I qui mac i winak are iri: are xcʼun i sak chuwach i jyub taʼaj, i winak n-xcaj ta xe qʼuiji pa sak, mas kus xquil i ʼekum chuwach i sak, man niʼpa i quiqui ʼano, xui i mac atzalal. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Niʼpa i quiqui ʼan i n-ʼus taj, tzel quiquil i sak, xak n-cacaj ta que oc pa sak, man n-cacaj taj ca ʼiltajic chi n-ʼus ti quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Niʼpa i quiqui ʼan i ʼutz sucʼulic chuwach i Dios, que tejeb che i sak; ca ʼalijin ʼuri chi niʼpa i que tijin chu ʼanic are i Dios que tow chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Xoʼon panok i Jesus xa ʼe cuʼ u tijoxelab pa tak jyub re i Judéa. Chila xe najtin jubiʼ, quiqui kajsabej ya piquiwi i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Xak queje i ma Wan ca tijin chu kajsaxic ya piquiwi i winak, chila che i jyub Enon, chu nakaj i jyub Salim. Chila xoʼon wi, man qʼui ʼo wi i ya pa jyub-le. I winak, chila que upon wi ruʼ, man ca kajsax ya piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Queje ile xqui ʼano are cʼa maja ca tzʼapix i ma Wan pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","I aj Israel winak, ʼo usucʼ chiquiwach quiqui ʼan i rawasil, chʼajbal quib chuwach i Dios. I u tijoxelab i ma Wan, xak juban aj Israel, xe oc chu chapic quib chi tzij puwi i costúmbre-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Teʼuri xe ʼe ruʼ i ma Wan, y xqui bij che: —Tijonel, ¿ca cʼun cha cʼux i achi chi xupon awuʼ are at ʼo chʼaka ya Jordan? Are i jun chi xa lap chake wach u patan. Chatapeʼ, ire xak cu kajsaj ya piquiwi i winak, y conojel i winak lic que upon ruʼ —xqui bij che. (Ile are i Jesus chi xqui lapo.) ");
INSERT INTO acr_acc_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","I ma Wan xu bij chique: —Mi jun ca tiqui che i patan-le we n-yatal ta che rumal i Dios ");
INSERT INTO acr_acc_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Lic i tom chic yix are xin bij chi n-yin ti in Crísto; yin xa in taktal li nabe chuwach ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Xa in aj cojol u tzij chiquiwach i winak. In queje pacha i ramig i achi chi ca cʼuliʼic. Jun achi, we ca cʼuliʼic, re ire i ixok chi ca cʼuli ruʼ. I ramig chi aj cojol u tzij, ca taqʼui chucʼulel chu tayic; are cu ta u chʼawbal, ca quicot rumal. Queje ile quin ʼan yin woʼor, mas quin quicot rumal (man mas que upon i winak ruʼ i Jesus chuwach i wuʼ yin.) ");
INSERT INTO acr_acc_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","I Jesus, ʼo u chac chi ire mas cocsax u ʼij, xak ʼo u chac chi yin coqʼuil ca sach in ʼij —xu bij i ma Wan chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","I Jun chi petnak chicaj, mas nim u ʼij chiquiwach conojel i winak. I jun chi toʼ winak aj chuwach jyub taʼaj, xa re u wach i jyub taʼaj, xak xui i ʼo chuwach i jyub taʼaj cu lapo. Are i petnak ruʼ i Dios, nim u ʼij chiquiwach conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ire cu bij niʼpa i rilom, niʼpa i u tom chila ruʼ i Dios, xui-ri, n-conojel taj quiqui coj u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","We jun cu coj u tzij ire, ʼalaj ʼuri chi cu coj u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Are i u takom li Dios, cu bij u tzij i Dios, man ʼo i u Tewal i Dios ruʼ. I Dios, are cu ya u Tewal che, n-cu paj taj; lic nim cu yaʼo. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","I Ta chicaj lic cʼax cu na u Cʼojol, xak u yom puʼab ronojel niʼpa i ʼolic. ");
INSERT INTO acr_acc_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Pachin i cu cuba u cʼux che u Cʼojol i Dios, ʼo ʼuri u cʼaslemal chi n-ca qʼuis ta chic; pachin i n-cu cuba tu cʼux che u Cʼojol i Dios, n-ta ʼuri u cʼaslemal-le; lic cu rik ni tojbal re u mac rumal i Dios. (Queje ile xu bij i ma Wan chique u tijoxelab.) ");
INSERT INTO acr_acc_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","I aj Fariséo winak, xqui ta rason chi je qʼui i winak que terej chirij i Jesus, je qʼui quiqui tzʼonoj u kajsaxic ya piquiwi, mas xe qʼuiar i winak ruʼ i Jesus chuwach quiqui ʼan ruʼ i ma Wan, aj kajsanel ya. Katzij n-are ti Jesus ca kajsaw ya piquiwi i winak, xa are i u tijoxelab. I Jesus, are xretamaj chi xpe coywal i aj Fariséo winak, ire xel pa Judéa, xtzalij chic pa Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Pu tzalijbal, xicʼaw na pa jyub Samária. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Chila pa Samária, xupon che jun tinimit, Sicar u bi. I tinimit-le, ʼo chu nakaj i rulew i mam Jacob ujer; i ulew-le xu ya can che i u cʼojol, chi ma Jose. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Chila ʼo wi i cʼotom re can i mam Jacob; (i Jesus, cuʼ u tijoxelab, xe upon chila). I Jesus, cosnak chic che i be, rumal-i, xcubi chu chiʼ i cʼotom. Are oʼonom ʼor-le, colo tiqʼuil ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Cul i Jesus chila, xupon jun ixok aj Samária chu cʼamic u yaʼ pa cʼotom. I Jesus xu bij che: —Cha ya jubiʼ in yaʼ —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","I u tijoxelab i Jesus je ʼenak tan pa tinimit, chu loʼic wach quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","I ixok aj Samária xu laʼ u wach che i Jesus: —Yet at aj Israel winak, ¿wuchac ca tzʼonoj a yaʼ chwe yin chi in aj Samária winak? Queje ile xu bij che man i aj Israel winak n-cacaj ta quib cuʼ aj Samária. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","I Jesus xu bij che: —N-awetaʼam taj wach cu sujuj i Dios chawe, xak n-awetaʼam taj in pachin yin chi quin tzʼonoj jubiʼ in yaʼ chawe. We tene awetaʼam ile, yet tene-ri ca tzʼonoj a yaʼ chwe yin, y yin quin ya ne ʼuri i cʼaslic ya chawe —xu bij che i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","I ixok xu bij che: —Nim laj winak, i cʼotom naj u pam, y cʼa naj ʼo kaj i ya; yet n-ta ne cawesbej li re. ¿Pa ca cʼam wi i cʼaslic ya chi ca ya chwe? ");
INSERT INTO acr_acc_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","I nim laj ka mam, mam Jacob, u yom can i cʼotom-i chake. Che i cʼotom-i xresaj wi u yaʼ ire, tak que i racʼal, tak que u chicop. ¿Xataba mas nim a ʼij yet chuwach i ka mam, mam Jacob? —xu bij i ixok che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","I Jesus xu bij che: —Pachin i quiqui tij i ya chi quel pa cʼotom-i, xa ca pe chic i cʼatic chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","We jun cu tuʼ i ya chi quin ya yin che, n-ca pe ta chic i cʼatic che. Man i ya chi quin ya yin che, coʼon pu cʼux pacha jun ralaxbal ya chi lic ca silabic, cu yabej re i cʼaslemal chi n-ca qʼuis ta chic —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Teʼuri i ixok xu bij che: —Nim laj winak, cha ya i ya-le chwe chi ca sujuj, man n-ca pe ta chic i cʼatic chwe, xak quin mayij cʼunic ʼij ʼij waral chu cʼamic in yaʼ —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","I Jesus xu bij che: —Jat, ja siqʼuij awachijil, teʼuri chix petok —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","I ixok xu bij che: —Yin n-ta wachijil. Are ʼuri i Jesus xu bij che: —Katzij i ca bij “N-ta wachijil,” cat cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Man joʼob awachijil je icʼawnak, y are i ʼo awuʼ woʼor, n-awachijil taj. Rumal-i a bim i sak laj tzij —coʼon i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","I ixok, are xu ta ile, xu bij: —Nim laj winak, woʼor quin ta u be chi yet at ajbil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","I katit ka mam yoj chi oj aj Samária, chi xqui coj wi u ʼij i Dios puwi i jyub-le; péro yix chi ix aj Israel qui bij chi xui pa Jerusalen coc wi u ʼij i Dios —xu bij i ixok che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","I Jesus xu bij che: —Chatape, ixok, cha cojo i quin bij chawe-ri: cu rik ni ʼij n-tu chac quix ʼe chic puwi i jyub-i, xak n-tu chac quix ʼe cʼa pa Jerusalen chu cojic u ʼij i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Yix chi ix aj Samária, qui coj u ʼij jun Dios chi n-iwetaʼam tu wach. Péro yoj chi oj aj Israel ketaʼam u wach i Dios chi caka coj u ʼij, man i tobal que i winak chi Dios u yijbam, cuʼ i aj Israel winak ca pe wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Péro cu rik i ʼij, y are chic i ʼij iri, chi conojel niʼpa i lic katzij quiqui coj u ʼij i Ta chicaj, ruʼ qui cʼux quiqui ʼano, lic sakil quiqui ʼano. I Ta chicaj, queje ile craj chique niʼpa i quiqui coj u ʼij ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","I Dios, lic tewal, n-cakil tu wach. Xak queje u cojic u ʼij: niʼpa i quiqui coj u ʼij, ʼo u chac quiqui ʼano lic pa qui cʼux; lic sakil quiqui ʼan na —xu bij i Jesus che ixok. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Teʼuri xu bij i ixok che: —Wetaʼam chi ca cʼun i Tolke chatal rumal i Dios, “Crísto” ca bix che. Are ca cʼunic, ire ʼis ronojel cu sakij chake —xu bij ixok che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","—Yin ile chi ca bij, chi quin lapan awuʼ —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Teʼuri xe upon u tijoxelab. Are xquilo chi Jesus ca lapan ruʼ jun ixok, lic xqui bisoj. Mi jun chique xu tzʼonoj che wach craj i ixok; xak n-xqui tzʼonoj ta che wach tak quiqui lap ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Teʼuri i ixok xu canaj can u cucub, y xa ʼe pa tinimit. Xu bij chique i winak: ");
INSERT INTO acr_acc_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","—Chix petok, chol iwila jun achi chi xu bij chwe ronojel wach in ʼanom. ¿Mok are i Crísto ile? —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Teʼuri i winak xe ʼel pa tinimit, y xe ʼe pa ʼo wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Are cʼa maja que upon i winak, i u tijoxelab i Jesus lic xqui sujuj u wa. Xqui bij che: —Tijonel, cha tija jun a wa —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ire xu bij chique: —Yin, ʼo i quin tijo chi yix n-qui maj ti usucʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","I u tijoxelab xe oc chu bixquil chiquiwach: —¿ʼO nawi jun xcʼamaw li u wa? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","I Jesus xu bij chique: —Are in wa yin, are iri; chi quin ʼan na pacha i craj i Ta chi in takawnak lok, xak quin qʼuis ni u chac chi u yom pin ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Yix qui bij: “Cʼa pa cajib icʼ, teʼuri ca ʼan i chac re i jachʼanic” quix cha. Xui-ri yin quin bij chiwe: are chic ʼij iri chi ca ʼan i jachʼ. Chiwilapeʼ, i abix ya ʼutz chic ca jachʼic. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Pachin jun ca chacun che i jachʼanic-le, ca yaʼ ni rajil. Niʼpa i xe moltajic, que yaʼ pa cʼaslemal chi n-ca qʼuis ta chic. Teʼuri i chacun-nak che i jachʼ-le, que quicot na junam ruʼ i ticawnak. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Man pacha i cu bij jun tzij: “Jun ca ticanic, y jun chic ca jachʼanic.” Sak laj tzij ile. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Yix ix in takom chu molic u wach i ticon chi ni ticom taj. Junwi je ticawnak i ticon-le, y yix xui qui mol u wach i qui chac —xu bij i Jesus chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Je qʼui i aj Samária winak xqui cuba qui cʼux che i Jesus rumal i tzij chi xu bij ixok chique: “Ire xu bij chwe ronojel niʼpa in ʼanom,” xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Bay, are xe upon i aj Samária ruʼ i Jesus, xqui bij che chi ca canaj na cuʼ pa tinimit. Rumal-i, i Jesus xcanaj cuʼ queb ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Je qʼui chic xqui cuba qui cʼux che, are xqui ta u tzij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","I winak-i xqui bij che i ixok: —Woʼor lic caka cojo; n-xui ta rumal wach i xa lap yet chake caka cojo, xak yoj mísmo xka ta u tzij ire. Rumal-i, ketaʼam chi lic katzij, ire are i Crísto, are i Tolque i winak chuwach i jyub taʼaj —xqui bij i aj Samária winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Churox ʼij xel i Jesus pa Samária; xu maj chubi u be, xa ʼe pa jyub Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Man ire mísmo u bim chi jun ajbil u tzij i Dios, n-cocsax tu ʼij pa tinimit pa xqʼuiy wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Are xupon pa Galiléa, i winak chila lic xqui cʼulaj cuʼ, man ique quilom i milágro u ʼanom pa Jerusalen. Ique je upon-nak chila pa Jerusalen chi rilic i nimaʼij páscua; chupam i ʼij-le, xquilo ronojel wach u ʼanom i Jesus chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Entónces i Jesus xupon chic che i tinimit Cana, u cwenta i jyub Galiléa; are i tinimit-le pa xu yijba wi i víno che i toʼ ya. ʼO jun achi aj Capernaum, nim u patan chirij i ʼatol tzij; y ʼo jun racʼal iwab. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ire xu ta chi ya xtzalij li Jesus pa Judéa, ya ʼo chic pa Galiléa; rumal-i, xa ʼe ruʼ i Jesus. Xu tzʼonoj pawor che, chi ca ʼe ruʼ chi rachoch, crutzirsaj i racʼal chi ya ca camic. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","I Jesus xu bij che: —Yix n-quiwaj ta qui cuba i cʼux chwe we n-quiwil ta jun milágro, we n-quiwil ta nimak tak ʼanic chi quin ʼano —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","I achi xu bij: —Cuyu in mac, Nim laj Winak, cha bisoj chwe chi cat ʼe wuʼ, man ya ca cam i wacʼal. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","I Jesus xu bij che: —Jat che awachoch; i awacʼal ca cʼasi na —coʼono. I achi xu cojo wach xu bij i Jesus che, y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Are ca tijin chi be, xa ʼe cʼulax cumal i rajchaquib je aj pa rachoch, y xqui bij che: —I awacʼal ca cʼasi na —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I achi xu tzʼonoj chique: —¿Wach u ʼonom ʼor xu ticba utziric? Ique xqui bij che: —Iwir a la úna re u kajbal ʼij xchup i ʼaʼ chirij —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","I u kajaw i iwab, are xu ta i ʼor-le, xu nabej chi are ʼor ʼuri are xu bij i Jesus che: “Awacʼal ca cʼasi na.” Teʼuri i achi xu cuba u cʼux che i Jesus junam cuʼ conojel u miʼal ralcʼwal. ");
INSERT INTO acr_acc_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Are ucab milágro iri, xu ʼan i Jesus, are xel pa Judéa y xa ʼe cʼa pa Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Xoʼon pan jubiʼ, ʼo tan chic jun nimaʼij que i aj Israel winak, rumal-i, i Jesus xa ʼe chic pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Pa tinimit-le, ʼo jun u chibe, “Ocbal bic que i chij” ca bix che. Chu nakaj ile ʼo jun atinbal, “Betésda” u bi piqui chʼawbal i aj Israel winak; ile ʼo joʼob uwachja che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","I chi tak ja-le, chila je cotzʼbam wi u qʼuial iwabib. ʼO i je mawach chique, ʼo i je sic, xak ʼo i lic n-que silab taj. Conojel coyʼem u silabic i ya, ");
INSERT INTO acr_acc_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","man xa coʼon tan ca cʼun jun ángel col u silabsaj i ya. Are ca silab i ya, i nabe iwab chi coc chupam, cutziric, xa bi chi cʼaxil ʼo che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Chiquixol i iwabib chila ʼo jun achi chi ʼo chic tréinta y ócho junab che u jekanic i yobil che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","I Jesus xril u wach i achi-le chi cotzʼo-lic, xak xu nabej chi qʼuial chic junab ʼo i yobil che. Are ʼuri xu bij che: —¿Cawaj cat utziric? ");
INSERT INTO acr_acc_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","I iwab xu bij: —Nim laj winak, n-ta jun quin towic quin oc pa ya, are ca silabic. Are quin ʼan pen i oquic pa atinbal, jun chic cu min la rib nabe chinwach yin —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","I Jesus xu bij che: —Chat walijok, cha molo bi a soc, y chat binok. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","I achi juntir xutziric, xu yac bi u soc, y xoc chi binic. Are i ʼij xa ʼan wi ile, are i uxlambal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Rumal-i, i nimak tak aj Israel xqui bij che i achi chi utzirnak: —Woʼor uxlambal ʼij, n-ca majaw ta chawe awekam a soc —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ire xu bij chique: —Are i xin utzirsawic, are ire xu bij chwe: “Cha molo a soc y chat binok,” xu bij chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Ique xqui tzʼonoj che: —¿Pachin i achi-le chi xu bij chawe, cha molo i a soc y chat binok? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","I achi n-xretamaj tu wach pachin i xutzirsawic, man i Jesus weʼ xel chiquixol i u qʼuial winak chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Xoʼon pan jubiʼ, i Jesus xu rik chic i achi pa rachoch i Dios y xu bij che: —Chatapeʼ, woʼor at utzirnak chic. Mat macun chic, man pent ca pe chic jun cʼax chawij, mas nim chuwach ile —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","I achi xtzalijic, y xu bij chique i nimak tak aj Israel chi are i Jesus are i xutzirsawic. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Teʼuri i nimak tak aj Israel xqui jek u tzucuxic chʼoʼoj chirij i Jesus; cacaj quiqui camsaj, man que rutzirsaj i winak pa uxlambal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","I Jesus xu bij chique: —In Kajaw ʼij ʼij ca chacunic (tupu uxlambal ʼij); rumal-i xak queje quin ʼan yin —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Rumal i tzij-le chi xqui ta, i aj Israel winak xqui cowij u tzucuxic u mac i Jesus, camsabal-re. Xpe coywal che, n-xui ta rumal cu kajsaj u ʼij i uxlambal ʼij, xak rumal cu bij chi i u Kajaw are i Dios; queje ile xu junamsaj rib ruʼ i Dios, xqui bij ique. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","I Jesus xu bij chique: —Katzij i quin bij chiwe, yin chi in Racʼal i Dios, n-ta junacos quin ʼano toʼ pin wach wi; quin ʼano pacha cwilo chi coʼon in Kajaw. Man ronojel wach coʼon in Kajaw, xak are quin ʼan yin, chi in u Cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Man in Kajaw cʼax quin u naʼo, rumal-i u cʼutum chwe ronojel wach coʼon ire. Ire xak cu cʼut na chwe juban chic nimak tak chac chuwach in ʼanom-le; y yix, are quiwil ile, quix oc na ʼil che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","In Kajaw que u yac chic i je camnak y cu ya qui cʼaslemal, xak queje yin quin ya qui cʼaslemal pachin cwaj quin ya chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","N-xui ta la ile. In Kajaw u yom pinʼab quin ʼan ʼatbal tzij piquiwi i winak; n-are ti ire ca ʼataw tzij piquiwi ique. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Queje ile u ʼanom man craj in Kajaw conojel i winak quiqui coj in ʼij pacha quiqui ʼan che ire, quiqui coj u ʼij. Pachin jun n-cu coj ti in ʼij yin, chi in u Cʼojol i Dios, xak n-cu coj ta ʼuri u ʼij in Kajaw chi in takawnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Katzij i quin bij chiwe: we jun cu coj retalil che wach i quin bij, xak cu cuba u cʼux che i Jun chi xin u tak lok, ʼo ʼuri u cʼaslemal chi n-ca qʼuis ta chic. Ire n-coc ta pa tojbal mac, man ire n-ta chic puʼab i camic, ya xa ʼax che u cʼaslemal cʼacʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Sak laj tzij i quin bij chiwe, ca cʼun i ʼij, y are chic i ʼij iri, chi niʼpa i je camnak chuwach i Dios quiqui ta na in tzij yin, chi in u Cʼojol i Dios. Niʼpa i quiqui coj in tzij, ca yaʼ qui cʼaslemal. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Are in Kajaw ʼo i cʼaslemal ruʼ y xak xu ya chwe yin chi ʼo i cʼaslemal wuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ire xak u yom pinʼab quin ʼat tzij piquiwi i winak, man in Achi aj Chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Mix oc ʼil che iri chi xin bij, man cu rik ni ʼij chi niʼpa i je camnak quiqui ta na in chʼawbal ");
INSERT INTO acr_acc_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","y que ʼel na lok pa i je muktal wi. Are i xqui ʼan i ʼutz, ca cʼunsax sak chiquiwach, y que cʼasi chic. Are i xqui ʼan i n-ʼus taj, ca cʼunsax sak chiquiwach, xa ya-bal-que pa tojbal qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Lic n-ta quin ʼano toʼ pin wach wi; yin quin ʼan ʼatbal tzij pacha cu bij i Ta chwe. Are i ʼatbal tzij chi quin ʼan yin, pusucʼ quin ʼan wi, man n-quin ʼan taj pacha i cwaj yin, xa are quin ʼano pacha i craj in Kajaw chi xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","We xa yin quin bij chiwe chi nim in patan, n-tu chac ʼuri chiwe wach i quin bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Xui-ri ʼo jun chic cu bij wach in patan yin; y yin wetaʼam chi niʼpa i cu bij ire, sak laj tzij, ʼalijinsabal-re chiwe, in pachin yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Yix xi tak u tzʼonoxic che i ma Wan chi aj kajsanel ya; ire, sak laj tzij i xu bij chiwe wach in patan yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Chwe yin, n-ta coʼono we jun winak cu bij wach in patan yin, xui quin cʼunsaj chi cʼux wach xu bij ire man cwaj yin qui rik iwelbal chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","I ma Wan, aj Kajsanel ya, queje teʼek pacha jun ʼaʼ ca juluwic y ca tzunic; y yix kus xiwilo, xui-ri, xa queb oxib ʼij xix quicot che. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Péro ʼo jun cʼutbal-re chiwe mas nim chuwach u tzij i ma Wan, chi cu cʼut chiwe in pachin yin. I cʼutbal-re chiwe are i nimak tak ʼanic chi quin ʼano. Are i ʼanic-le, are xin u tak in Kajaw chu ʼonquil. Niʼpa tak i ʼanicle, are ca cʼutuw chiwe chi are i Ta xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Xak i Ta, chi xin takaw lok, u yom retalil in pachin yin. Yix ni tom tu chʼawbal, xak n-iwilom tu wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","U tzij i Dios n-ta piwanima; ʼalaj ʼuri che, man ni cubam ti cʼux chwe yin, chi in u takom li Ta. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Yix lic qui nawsaj iwib che u tzij i Dios tzʼibtalic. Queje ile qui ʼano man qui bij yix, rumal i wuj-le qui rik i cʼaslemal chi n-ca qʼuis ta chic. Bay, i tzij chi tzʼibtal chuwach wuj-le, are ca binic wach in patan yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Xui-ri, yix n-quiwaj ta quix pe wuʼ, qui rikbej re i cʼaslemal-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Yin n-quin tzucuj tu cojic in ʼij cumal i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N-xui ta la ile, xak wetaʼam wach u ʼanom i cʼux yix; wetaʼam chi n-cʼax ta qui na i Dios pi cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Yin in cʼun-nak man xin u tak li in Kajaw, péro yix n-quiwaj ta qui coj in tzij. We tene ʼo jun, toʼ pu wach wi ca cʼunic, bay ile qui coj ʼuri wach i cu bij chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Yix lic ʼutz qui ta, are cocsax i ʼij cumal iwachiʼil, péro n-qui ʼan ta pen u tzucuxic cojbal i ʼij chi ca pe ruʼ i Dios, ire chi xa jun ʼolic. Rumal-i, n-quiwaj ta qui coj in tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Mi chʼobo chi mok are yin quin coj i mac yix chuwach in Kajaw; n-yin taj. Are i mam Moises are i ca cojow i mac; are ire chi i cubam i cʼux yix che u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Yix, we ta katzij qui cojo wach xu bij i mam Moises, xak quin i coj ne ʼuri yin wach i quin bij. Man i tzij chi u tzʼibam can i mam Moises, are yin chi xin u lapo. ");
INSERT INTO acr_acc_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","We n-qui coj taj wach i xu tzʼibaj can i mam Moises, ¿wach u cojic ʼuri qui ʼano niʼpa i quin bij yin chiwe? (Queje ile xu bij i Jesus chique i nimak tak aj Israel winak.) ");
INSERT INTO acr_acc_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Teʼuri i Jesus xu ʼaxuj i alagun, Galiléa u bi, chi xak Tibérias ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Je qʼui i winak xe terej bi chirij, man quilom chic i milágro u ʼanom are xe rutzirsaj i iwabib. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Teʼuri i Jesus xel bi che jun jyub cuʼ u tijoxelab y xe cubi chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ya ca nakajab i niraaʼij chi are i páscua que i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","I Jesus cul chila, xe ril u qʼuial winak ca tijin cuponic ruʼ. Xu bij che i ma Felípe: —¿Pa caka loʼ wi i wa quiqui tijbej re conojel i winak-i? ");
INSERT INTO acr_acc_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Queje ile xu bij, xa ilbal-re wach cu bij i ma Felípe, man i Jesus u chʼobom chic wach coc chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","I ma Felípe xu bij che: —Mi tene queb ciénto quetzal n-coʼon taj, loʼbal-re i caxlanwa ca yaʼ chique; mi tene we xa jutak biʼ caka ya chique, n-que u ʼon taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Teʼuri xchʼaw i ma Andres chi jun chic chique u tijoxelab i Jesus, chi xak ratz u chaʼ i ma Simon Pédro. Xu bij che i Jesus: ");
INSERT INTO acr_acc_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","—ʼO jun acʼal chi, rucʼam queb car xak joʼob caxlanwa ʼantal che cebáda. Péro we xui ile, n-coʼon taj man je qʼui i winak —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","I Jesus xu bij chique: —Chi bij chique i winak chi que cubiʼic —xu bij. Pa i je ʼo wi-le, chom i qʼuim ʼo che, y conojel xe cubiʼic; colo je joʼob mil achiab. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Teʼuri i Jesus xu cʼam i caxlanwa; are ʼuri xu cʼamwaj xu tioxij che i Dios, y xu ya chique u tijoxelab. Ique xqui jach chique conojel i winak chi je culic. Xak queje xoʼon che i car, xu ya chique niʼpa u nimal cacaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Are xe noj i winak conojel, i Jesus xu bij chique u tijoxelab: —Chi molo ronojel i chʼakatak chi n-xqʼuis taj, n-ʼus taj toʼ ca ʼani cʼax che —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Are xqui molo, xnoj cablajuj coban che. Ile are i chʼakatak chi n-xqʼuis ta che i joʼob caxlanwa re cebáda. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Teʼuri i winak, are xquil i milágro-le chi xoʼon i Jesus chiquiwach, xqui bij: —Katzij, iri are i ajbil u tzij i Dios chi koyʼem u cʼunic chuwach i jyub taʼaj —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","I Jesus xu nabej chi i winak-le cacaj quiqui ʼan pen che, chi quiqui cʼam bic, y quiqui ʼan qui ʼatol tzij che. Rumal-i, xel chiquixol, y xel chubi mas che i jyub utuquel. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Are ya coc aʼab, i u tijoxelab i Jesus xe kaj li chu chiʼ i alagun. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Teʼuri xe oc chupam jun bárco, y xqui maj bi qui be chuwi ya, ʼenam-que cʼa pa tinimit Capernaum. Ya ocnak chic aʼab, i Jesus cʼa maja ca kaj li che i jyub. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Are je ʼo chic chuwi ya, xpe jun tew, nim u choʼab; i uwi ya lic xu ticba silabic rumal i tew. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Ique je bin-nak chic chuwi ya, colo jun légua ruʼ nicʼaj. Xak teʼet xquilo chi Jesus ca tijin u tejebic ruʼ i bárco; lic ca bin chuwi ya. Are xquilo, xqui xij quib che. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Are ʼuri i Jesus xu bij chique: —¡Mi xij iwib! Xa yin —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Rumal-i xcubi qui cʼux, y xqui cʼulaj i Jesus cuʼ pa bárco. Juntir, xe upon che i lugar pa ʼenam-wi que. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Chucab ʼij, i winak chi xe canaj can chila pa xqui tij wi i caxlanwa, quetaʼam chi xa jun bárco ʼo teʼek chu chiʼ i ya. Xqui nabej chi i u tijoxelab i Jesus xe ʼe chupam i bárco-le, xak xquetamaj chi Jesus n-xa ʼe ta cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Tzʼakat je ʼo chila, xe upon juban bárco je aj pa tinimit Tibérias. Xe qʼuiji chu nakaj i lugar pa qui tijom wi i caxlanwa, are xutzin i Kajwal chu tioxixic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","I winak, are xquilo chi Jesus, tak i u tijoxelab, je n-ta chic chila pa xqui tij wi i wa, xe oc chupam tak i bárco-le; teʼuri xe ʼax chʼakap cʼa Capernaum chu tzucuxic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","I winak-le, are xe upon chʼaka alagun, xqui rik i Jesus. —Tijonel, ¿umpa xat ʼax li chi? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","I Jesus xu bij chique: —Katzij i quin bij chiwe, yix quin i tzucuj xa rumal xix in tzuku. Xa rumal xix nojic quin i tzucuj; n-are ta rumal xi ta u be i nimak tak milágro chi in ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Mi ya i cʼux chu chʼaquic i wa chi xa ca qʼuisic; are chi ya i cʼux chu chʼaquic i wa chi n-ca qʼuis taj; chi chʼaca i wa chi cu ya i cʼaslemal chi n-ca qʼuis ta chic. I wa-le chi quin bij chiwe, ca yaʼ chiwe wumal yin chi in Achi aj Chicaj. Quin tiqui chu yaʼic chiwe man i Dios, chi i Ta Chicaj, u cʼutum chi u yom pinʼab quin ʼan ile —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Teʼuri xqui tzʼonoj che: —¿Wach nawi caka ʼano ʼanbal re i chac chi craj i Dios? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","I Jesus xu bij chique: —I chac yix chuwach i Dios are iri: chi cuba i cʼux chwe yin, man i Dios in u takom lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Xqui tzʼonoj chic che: —¿Wach i cʼutbal re a choʼab ca ʼan na chakawach, caka cojbej-re a tzij? ¿Wach i nim laj séña ca ʼan na? ");
INSERT INTO acr_acc_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","I katit ka mam ujer, are je ʼo pa jyub tzʼinilic, xe tzuk che i wa aj chicaj, mana u bi. Ketaʼam ile man chuwach i wuj re i Dios, queje iri cu bij: “Xu ya i wa chique chi xpe chicaj, tzukbal que.” Queje ile tzʼibtalic —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","I Jesus xu bij chique: —(Qui bij yix chi are i mam Moises xyaw i wa-le chique.) Katzij i quin bij chiwe, n-are ti mam Moises xyaw i wa aj chicaj chique; are i Dios. Xui-ri, i wa-le n-xu ya ti qui cʼaslemal chi n-ca qʼuis taj. Péro woʼor in Kajaw cu ya i sakil wa aj chicaj chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Are i sakil wa chi cu ya i Dios, are i Jun chi kajnak li chicaj. Ire cu ya i sakil cʼaslemal chique i winak chuwach i jyub taʼaj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Teʼuri xqui bij che: —Kajwal, cha ya na chake i wa-le ronojel tak ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","I Jesus xu bij chique: —Yin i wa-le chi cu ya i sakil cʼaslemal; pachin jun ca cʼun wuʼ, n-ca pe ta chic u numic; pachin cu cuba u cʼux chwe n-ca pe ta chic i cʼatic pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Xui-ri yix, pacha xin bij ʼut, n-quix cojon taj, tupu iwilom chic in wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Conojel niʼpa i que yaʼ chwe rumal in Kajaw, que cʼun wuʼ. Niʼpa i cacaj que terej chwij, n-que in tzalijsaj tubic. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Man yin xin pe chicaj, n-are ta col in ʼana pacha i cwaj yin; xa are col in ʼana pacha i craj i Jun chi in takawnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Are i craj in Kajaw chi xin u tak lok are iri: chi mi jun quin sach chique i je u yom chwe; queje ile, que in walijsaj na chiquixol i camnak pa qʼuisbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Man are i craj i xin takaw lok are iri: conojel niʼpa i quiquil u be in pachin yin, chi in u Cʼojol i Dios, xak quiqui cuba qui cʼux chwe, ca yaʼ ni cʼaslemal chique chi n-tu qʼuisic. Xak quin cʼunsaj sak chiquiwach chiquixol i camnak pa qʼuisbal ʼij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Are ʼuri i qui nimakil i aj Israel winak xpe coywal che y xe oc chu chʼachʼaxic chiquiwach, man xu bij chique, “Yin i wa chi xpe chicaj,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ique xqui bij: —I achi-ri xa are i ma Jesus, u cʼojol i ma Jose; lic ketaʼam qui wach u kajaw u chuch. ¿Wuchac ʼut cu bij woʼor chi kajnak li chicaj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","I Jesus xu bij chique: —Chi mayij in chʼachʼaxic chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","N-ta jun ca cʼun wuʼ yin, we n-are ti in Kajaw ca cʼamaw lok, chi in u takom li yin. Xak quin cʼunsaj sak chuwach chiquixol i camnak pa qʼuisbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","I ajbil u tzij i Dios ujer xqui tzʼibaj i tzij-i: “I Dios que u tijoj na conojel.” Queje ile tzʼibtalic. I tzij-le queʼelok chi conojel niʼpa i quiqui ta u be wach cu bij i Ta, y xak que naw che ire, que cʼun ʼuri wuʼ yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Katzij mi jun winak rilom u wach i Ta, xa jun ilawnak u wach, xui yin, man in petnak chila ruʼ ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Sak laj tzij i quin bij chiwe: pachin jun cu cuba u cʼux chwe yin, ʼo u cʼaslemal chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Are yin i wa chi cu ya i sakil cʼaslemal. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Iwatit i mam ujer, are xe bin pa jyub tzʼinilic, xqui tij i mana chi xpe chicaj; xui-ri i wa-le n-xu ya ti sakil cʼaslemal chique, man are xu rik i ʼij, xe camic. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Xui-ri ʼo jun wa petnak chicaj, chi pachin jun cu tijo, lic n-ca cam taj. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Yin i wa-le chi petnak chicaj, are yin i wa chi lic cʼaslic. Pachin jun cu tij i wa-ri, i u cʼaslemal n-tu qʼuisic ʼuri. I wa chi quin ya yin are in chʼacul, quin ya wib piqui qʼuexel i winak, yabal-re qui cʼaslemal chuwach i jyub taʼaj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Rumal i tzij-le, i aj Israel winak xe oc chu chapic quib chi tzij chiquiwach: —¿Wach u ʼonquil ile, chi cu ya u chʼacul caka tijo? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","I Jesus xu bij chique: —Sak laj tzij i quin bij chiwe: we yix n-qui tij ti u chʼacul i Achi aj Chicaj, xak we n-qui tuʼ ti u quiqʼuel, n-ti i cʼaslemal ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Pachin jun cu tij in chʼacul y cu tuʼ in quiqʼuel, ʼo u cʼaslemal ʼuri chi n-ca qʼuis ta chic. Xak quin cʼunsaj sak chuwach chiquixol i camnak pa qʼuisbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Queje ile quin bij, man in chʼacul are i sakil wa; xak in quiqʼuel are i sakil ya. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Pachin jun cu tij in chʼacul, xak cu tuʼ in quiqʼuel, ca qʼuiji ʼuri wuʼ yin, xak yin quin qʼuiji ruʼ ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","I Ta chi xin u tak lok, ire cʼaslic; rumal ire, xak yin in cʼaslic. Xak queje ile, we jun cu tzuk rib chwe yin, ca cʼasi na wumal yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Queje i wa ile chi kajnak li chicaj; i wa-le n-are ta pacha i mana chi xqui tij iwatit i mam, man ique xak xe camic are xu rik qui ʼij. Are i cu tij i wa-ri chi quin ya yin, cu rik u cʼaslemal chi n-ca qʼuis ta chic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Are i tzij-le xu bij i Jesus, are xe u tijoj wi i winak pa molbalʼib que i aj Israel pa tinimit Capernaum. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","I je teren chirij, are xqui ta i tzij-le, je qʼui chique xqui bij: —Cʼax u tayiquil i tzij-le; ¿pachin ca chʼijaw u tayic ile? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","I Jesus xu nabej wach quiqui bij chiquiwach. Rumal-i xu tzʼonoj chique: —¿Tzel qui ta i xin bij-le? ");
INSERT INTO acr_acc_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","¿Wach nawi qui bij we quin iwilo quin ʼel chubi chicaj pa in ʼo wi teʼek, yin chi in Achi aj Chicaj? ");
INSERT INTO acr_acc_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Are i ranima jun winak, are i ca yaw u cʼaslemal i u chʼacul; i toʼ chʼaculaj n-ta cu chacuj. Xak queje i tzij ile chi xin bij chiwe, are i ca yaw i sakil cʼaslemal, are i ca yaw i u Tewal i Dios pi cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Xui-ri, cʼo jujun chiwe yix chi n-qui coj taj —xu bij chique. I Jesus retaʼam chu xebal pachin n-cacaj ta que cojonic, xak retaʼam pachin i jun chi ca jachaw na che i camic. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Xu bij chic: —Rumal-i, in bim chiwe n-ta jun toʼ ca cʼun wuʼ yin, we n-are ta in Kajaw ca cʼamaw lok —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","I je teren chirij, are xqui ta ile, je qʼui xcoʼtaj canok; n-xe terej ta chic chirij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Teʼuri xu bij chique i cablajuj u tijoxelab: —Y yix, ¿mok xak quiwaj ʼenam? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Are ʼuri i ma Simon Pédro xu bij che: —Kajwal, ¿Pachin ruʼ coj ʼe wi? Mi jun; xui yet ca bij i tzij chake chi cu ya i cʼaslemal n-tu qʼuisic. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Yoj ka cubam chic ka cʼux chawe; ketaʼam chi yet at Crísto, u Cʼojol i Dios chi lic cʼaslic —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","I Jesus xu bij chique: Xix in cha yix, ix cablajuj; tupu yin xix in cha, xui-ri ʼo jun chiwe chi xa itzel —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I tzij xu bij-le, re i ma Júdas chi u cʼojol i ma Simon Iscarióte. Man i ma Júdas-le, are i ca jachaw na che i camic, tupu are jun chique i cablajuj tijoxelab je chatal rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Teʼuri i Jesus xui chic ca bin pa tak jyub re i Galiléa; n-craj ta ca qʼuiji pa Judéa man i nimak tak aj Israel chila cacaj quiqui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Teʼuri, ya xnakajab jun chic nimaʼij que i aj Israel winak; are i nimaʼij re i mujbal. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Are ʼuri i u chaʼ i Jesus xqui bij che: —Mat canaj waral; jat pa Judéa, cha cʼutu chique i quetaʼam a wach chila wach tak i milágro ca ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Man we jun craj ca ʼetamax u wach u patan, n-coʼon tu chac toʼ aliʼal. Yet chi cat tijin chu ʼonquil nimak tak ʼanic, cha ʼana ʼuri chiquiwach conojel i winak —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ʼAlaj ʼuri chi xak mi ne u chaʼ n-xqui coj taj we Tolque. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","I Jesus xu bij chique: —Maja cu rik i ʼij chinwach chi quin ʼalijinsaj in pachin yin; chiwe yix, pachique ʼij ʼis ʼutz. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","I winak aj u wach i jyub taʼaj n-tzel ta quix quil yix, péro yin, tzel quin quilo, man quin ʼalijinsaj chique chi n-ʼus taj wach i que tijin chu ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Jix yix pa nimaʼij-le; yin cʼa maja na quin ʼec, man maja cu rik i ʼij chinwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Queje ile xu bij chique y xcanaj pa Galiléa. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Are je ʼenak chic u chaʼ, teʼuri i Jesus xak xa ʼe paʼ nimaʼij. N-xa ʼe ta chiquixol i winak, n-kas ta xu cʼut rib are xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","I nimak tak aj Israel winak quiqui tzucuj i Jesus pa nimaʼij-le. Quiqui bij: —¿Pa nawi ʼo wi i achi-le? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","I winak pa nimaʼij-le, xa quiqui lap i Jesus chiquiwach. ʼO i que binic: “Ile lic ʼutz laj achi,” que cha. Xak ʼo i que binic: “Ile n-ʼus taj; xa que u tʼor i winak,” que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Péro xa aliʼal quiqui lap i Jesus chiquiwach, man quiqui xij quib chique i nimak tak aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Are nicʼajarnak chic i nimaʼij, i Jesus xoc bi pa rachoch i Dios; teʼuri xoc chi qui tijoxic i winak chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","I nimak tak aj Israel winak xqui bisoj wach tak i xu cʼutu; xqui bij: ¿Wach retamaxic tak ile u ʼanom? Ire n-ta u nawsam wi rib —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","I Jesus xu bij chique: —Are i quin tijin chu cʼutic n-are ti yin xin nojij, lic are petnak ruʼ i xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Pachin jun lic craj cu ʼan pacha craj i Dios, cu nabej ʼuri pa xpe wi i cʼutunic quin ʼano; cretamaj we petnak ruʼ i Dios, o xa petnak pin nojbal yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Jun, we xui cu cʼut u nojbal ire, xa craj ʼuri cocsax u ʼij. Péro jun, we cu tzucuj u cojic u ʼij i Jun chi takawnak lok, cu bij ʼuri i sak laj tzij, xak n-que u tʼor ta i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Katzij, i mam Moises xu cʼut i ʼatbal tzij re i Dios chiwe, xui-ri, mi jun chiwe cu ʼano pacha cu bij i ʼatbal tzij-le. Yix quiwaj quin i camsaj (rumal quin cunan pa uxlambal ʼij) —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","I winak xqui laʼ u wach che: —Xa at chʼuj; ¿pachin craj a camsaxic? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","I Jesus xu bij chique: —Chupam jun uxlambal ʼij xin ʼan jun milágro. Yix xi bisoj man pa jun uxlambal ʼij xin ʼan wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Chiwila ba i qui ʼan yix. ʼOlic qui ʼan retal circuncision che i qui chʼacul acʼalab pa tak uxlambal ʼij. We xel wajxakib ʼij jun ral ala, queje ile qui ʼano, man queje ile xu cʼut i mam Moises chiwe. Katzij, n-are ti mam Moises xjekaw u cʼutic ile, xa are iwatit i mam que ʼanaw chic ile are xu bij i mam Moises i tzij-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yix qui ʼan pen u ʼanic pacha xu bij i mam Moises; qui ʼan retal circuncision che i qui chʼacul iwacʼal, tupu xa pa uxlambal ʼij. We queje ile qui ʼan yix, ¿wuchac ʼuri ca pe iwoywal chwe, xa rumal xwesaj ronojel i cʼax che u chʼacul jun achi che i uxlambal ʼij? ");
INSERT INTO acr_acc_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Mi coj u mac jun winak we n-iwetaʼam taj we kas ʼo u mac. Chiwila u be bien we kas ʼo u mac, teʼuri chi bij u mac —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Teʼuri i winak chi je jekel pa Jerusalen xe oc chu bixquil: —¿N-are ta bari i achi-le ca tzucuxic man cacaj quiqui camsaj? ");
INSERT INTO acr_acc_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Chiwilapeʼ, chi ʼo wi; lic ca chʼaʼat chiquiwach conojel i winak. ¿Wuchac n-ta ca bix che? ¿Xataba i ka wi ka jolom qui cojom chic u tzij? ¿Xataba qui bim ique we are i Crísto, chi Tolke? ");
INSERT INTO acr_acc_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","N-are ti Crísto ile. Yoj, ʼut, ketaʼam pa petnak wi i achi-le; xui-ri, i Crísto, mi jun quetama-nic pa ca pe wi —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","I Jesus xu ta wach i quiqui bij are ca tijin chu cʼutic chique i winak pa rachoch i Dios. Teʼuri co xchʼawic y xu bij: —Qui bij yix iwetaʼam in wach; qui bij yix iwetaʼam pa xin pe wi. Xui-ri, yin n-toʼ ta in cʼun-nak pin wach wi. In cʼun-nak man in taktal li rumal i Jun chi yix n-iwetaʼam tu wach, péro ire sakil. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Yin ʼut, wetaʼam u wach, man ruʼ ire in petnak wi, are ire xin takaw lok —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Are ʼuri laj xcaj xqui tzʼapij, péro n-ta jun xa ʼanawic, man cʼa maja cu rik i ʼij u chʼicom i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Xui-ri je qʼui i winak xqui cuba qui cʼux che y xqui bij: —Are ca cʼun i Crísto, ¿xataba ʼo mas tan chic i milágro cu ʼano, chuwach i cu ʼan i achi-ri? N-ta chic mas —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","I aj Fariséo xqui ta chi quiqui bij i winak chi Jesus are i Crísto. Rumal-i, ique junam cuʼ i ajwab sacerdóte xe qui tak bi policía chi aj patanib re i rachoch i Dios, que ʼe qui chapr i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","I Jesus xu bij chique i winak: —Xa ʼatal ʼij in ʼo iwuʼ, teʼuri quin tzalij chic ruʼ i xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Yix quin i tzucuj na, péro n-quin i rik taj, man pa i quin ʼe wi yin, n-ca yaʼ ta chiwe quix ʼe chila —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","I qui nimakil i aj Israel winak xqui bij chiquiwach: —¿Pa nawi ca ʼe wi i achi-ri chi yoj n-coj tiqui ta chu rikic? ¿Mok ca ʼe cuʼ i kach aj tinimit chi je ʼenak chiquixol i aj Griégo winak? ¿Mokxa que u cʼutu chique i aj Griégo chila? ");
INSERT INTO acr_acc_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","¿Wach queʼel i tzij-i chi xu bij chake? Man xu bij: “Quin i tzucuj na, péro n-quin i rik taj, man n-quix oc taj pa i quin ʼe wi yin,” xcha. ¿Wach usucʼ ile? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","I qʼuisbal ʼij re i nimaʼij chila, mas ʼo u ʼij. Chupam i ʼij-le, i Jesus xtaqʼui ʼan chiquiwach i winak y co xu bij: —Pachin jun ca cʼatic, cha pet wuʼ yin, chol u tuʼu i ya chi quin sujuj. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","We jun coʼon ile, queʼel ʼuri pacha i tzʼibtal can chupam i wuj re i Dios, chi cu bij: “Pachin i cu cuba u cʼux chwe yin, u cʼux ire coʼon pacha ralaxbal ya; pacha ya cʼaslic quel che,” —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","I tzij chi xu bij i Jesus-le queʼelok: niʼpa i quiqui cuba qui cʼux che ire, coc ni u Tewal i Dios piqui cʼux coʼon panok. Are xu bij ile, cʼa maja ca kaj li u Tewal i Dios chuwach i jyub taʼaj, man cʼa maja coc i Jesus che u ʼij u chomal. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ʼO jujun chiquixol i winak, are xqui ta ile, xqui bij chiquiwach: —Katzij, i achi-ri are i ajbil u tzij i Dios chi koyʼem —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ʼO juban chic xqui bij: —Iri are i Crísto chi koyʼem —xe cha. Xak ʼo juban chic xqui bij: —¿Wach u ʼonquil ile? ¿Xataba ʼo Tolke ca pe pa Galiléa? ¡N-taj! ");
INSERT INTO acr_acc_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Chupam i wuj re i Dios cu bij: i Crísto chi ca petic, u muk u xiquin i ujer mam David: xak cu bij chi calax na pu tinimit i mam David; ile are i tinimit Belen. Rumal-i, n-are ti achi-le —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Teʼuri i winak xqui chap quib chi tzij rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ʼO jujun xcaj teʼek u tzʼapixic, péro n-ta jun xu ya rib chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Teʼuri i policía re i rachoch i Dios xe tzalij chal cuʼ i je takawnak bic. I aj Fariséo winak xak i ajwab sacerdóte xqui tzʼonoj chique i policía-le: —¿Wuchac n-xi cʼam ta lok? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","I policía xqui bij: —N-ta jun chic achi ka tom wi ruʼ, pacha i tzij chi cu bij i achi-le; rumal-i n-xka cʼam ta lok —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Teʼuri i aj Fariséo xqui bij chique i policía: —¿Xak queje yix xix tʼortaj rumal i achi-le? ");
INSERT INTO acr_acc_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","¿Xataba ʼo jun chake yoj oj aj Fariséo, u cojom u tzij? Mi jun. Xak mi jun kajʼatzil yoj u cubam u cʼux che i achi-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","I toʼ winak-le, qui cojom; péro ique n-quiqui ta tu be i ʼatbal tzij tzʼibtal canok; ique-le ʼo i cʼokbal-re i Dios piquiwi —xqui bij i aj Fariséo winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Are ʼuri ʼo jun chiquixol ique xchʼawic. Are i ma Nicodémo chi upon-nak ruʼ i Jesus aliʼal chaʼab. Xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","—I ka ʼatbal tzij tzʼibtal can rumal i mam Moises n-cu ya ta chake caka ya jun achi pa tojpen we n-caka ya ta che cu to rib chakawach. ʼO u chac coj taqʼui pa rakan we kas ʼo u mac. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","I rachiʼil xa xqui yoʼya, y xqui bij che: —¿Xataba yet xak at aj chila pa Galiléa? Cha tzucuj chupam i wuj re i Dios; cawil ʼut chi mi jun ajbil u tzij i Dios ca pe pa Galiléa —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Teʼuri, chi qui jujunal wi, xe ʼe chi cachoch. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Xui-ri, i Jesus xa ʼe che i jyub, Olívos u bi. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Chucab ʼij, are xsakiric, xtzalij chic pa rachoch i Dios. Je qʼui i winak xqui mol quib ruʼ; are ʼuri ire xcubiʼic, y xoc chu cʼutic u tzij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Are ʼuri ʼo juban aj tijonel re i ujer ʼatbal tzij, xak juban aj Fariséo, xqui cʼam li jun ixok chuwach, quiqui cojbej u mac. I ixok-le xqui riko ca tijin chu ʼonquil u mac ruʼ jun achi chi n-rachijil taj. Xqui ya chiquixol i winak chuwach i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Queje iri xqui bij che i Jesus: —Tijonel, i ixok-i xka riko are ca tijin chu ʼonquil u mac ruʼ jun achi chi n-rachijil taj. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","I ʼatbal tzij chi u yom can i mam Moises pakawi cu bij chi caka camsaj che abaj jun ixok pacha ile. Bay, ¿wach ca bij yet che ile? ");
INSERT INTO acr_acc_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Queje ile xqui bij che, xa cʼambal u pam i Jesus quiqui ʼano, tzucbal re u mac. Are ʼuri i Jesus xchaqui kaj chuwach ulew, y xoc chi tzʼib ruʼ u wi u ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Ique n-quiqui mayij tu tzʼonoxic che, rumal-i xu sucʼba rib y xu bij chique: —We ʼo jun chiwe yix n-tu mac, chu cʼaka i nabe abaj chirij i ixok-le —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Xchaqui chakajok, y xoc chic chi tzʼib pulew. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Ique, are xqui ta ile, xqui na piqui cʼux chi xak ʼo qui mac. Xqui ticba ʼenam chi qui jujunal; are i je rijab chiquixol, are i nabe xe ʼec. Are je ʼenak chic conojel, xui chic i Jesus ʼo can ruʼ i ixok chi cʼamtal bi chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I Jesus xu sucʼba chic rib y mi jun chic chique xe rilo, xui chic i ixok. Xu bij che: —Ixok ¿pa je ʼo wi i que cojow te a mac? ¿N-ta jun craj cu coj abaj chawe rumal a mac? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","—N-taj, nim laj winak; mi jun —xu bij ixok. Are ʼuri i Jesus xu bij che: —Xak mi yin quin bij chi ʼo u chac ca toj a mac. Woʼor, jat; xui-ri cha mayij i macunic —xu bij che i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Xoʼon panok i Jesus xu bij chic jun tzij chique i winak: —Yin in queje pacha i sak re i paʼij chuwach i jyub taʼaj. Pachin craj ca terej chwij, n-ca bin ta pa ʼekum, xa ca bin pa sak re i cʼaslemal chi quin ya yin —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Are ʼuri aj Fariséo winak xqui bij che: —N-tu chac i ca bij man xui yet ca bij awib —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","I Jesus xu bij chique: —Tupu quin bij wib yin, n-toʼ ta ca sach in tzij. In tzij, lic usucʼ i quin bij, man yin wetaʼam pa i xin pe wi, xak pa i quin ʼe wi. Yix n-iwetaʼam taj pa i xin pe wi, xak pa i quin ʼe wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Yix qui coj u mac jun pacha i qui nojij yix ix winak re u wach i jyub taʼaj; yin mi jun quin coj u mac. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Xui-ri, we ta quin coj u mac jun, pusucʼ quin ʼan wi, man n-intuquel taj quin ʼano. Junam ruʼ i Ta quin ʼano, chi xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Chupam i ʼatbal tzij yix, tzʼibtal i tzij-i: we ʼo queb winak xak jun quiqui bij wach i quilom, ʼo u chac ʼuri ca cojic wach i quiqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Bay, katzij yin quin bij wib wach in patan; xui-ri, oj queb, man xak i Ta chi xin u tak lok, xak cu cʼut chiwe wach in patan, xak jun i ka tzij ruʼ —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Rumal-i xqui bij che: —¿Pa ʼo wi a Kajaw? I Jesus xu laʼ u wach chique: —Yix n-iwetaʼam taj in pachin yin, xak n-iwetaʼam tu wach in Kajaw. We ta iwetaʼam in pachin yin, xak quiwetamaj ʼuri u wach in Kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Queje ile xu bij i Jesus are ca tijin chu cʼutic pa rachoch i Dios. I cʼutunic-le xu ʼan chila pa ʼo wi tak i yabal mer re i rachoch i Dios. Mi jun xchapawic, man cʼa maja cu rik i ʼij chi u chʼicom i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","I Jesus xu bij chic chique: —Yin quin ʼec, y yix quin i tzucuj na, péro n-quin i rik taj; quix camic cʼo i mac chiwij. Pa quin ʼe wi yin, n-quix ʼe ti yix chila —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Teʼuri i nimak tak aj Israel winak xqui bij chiquiwach: —¿Xataba cu camsaj rib, y rumal-i xu bij chi yoj n-coj ʼe taj pa ca ʼe wi ire? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","I Jesus xu bij chique: —Yix xa ix aj chi; yin in aj chila chicaj. Yix xa ix aj chuwach i jyub taʼaj, yin n-in ta aj chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Rumal-i xin bij chiwe chi quix camic cʼo i mac chiwij. Man we n-qui coj taj in pachin yin, quix camic cʼo i mac chiwij —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Teʼuri xqui tzʼonoj che: —¿Wach a patan yet? —que cha. I Jesus xu laʼ u wach chique: —ʼAx in bim wi chiwe chu xebal lok wach in patan. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Yin mas ʼo i wetaʼam chiwij yix, cojbal-re i mac, y mas i tzij ʼo u chac quin bij chiwe. Xui-ri, xui quin bij wach in tom che i Jun chi in takawnak lok; Ire xui i sak laj tzij cu bij, y yin, xui u tzij Ire quin bij chique i winak aj chuwach i jyub taʼaj —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Péro i nimak tak aj Israel winak n-xqui ta tu be u tzij chi are i Ta chicaj i xu lapo. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Rumal-i xu bij chique: —Are quin i yac na ʼan chicaj (yin chi in Achi aj chicaj), cʼa teʼuri quiwetamaj in pachin yin. Xak quiwetamaj ʼuri chi niʼpa i quin ʼan yin, n-toʼ ta in nojim, xak niʼpa i quin bij, are u cʼutum i Ta chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","I Ta chi in takawnak lok, ʼo wuʼ yin; n-quin roʼtaj taj, man ʼax quin ʼan wi pacha i craj ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","I Jesus, are xu bij i tzij-le, je qʼui i winak xqui cuba qui cʼux che ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","I aj Israel winak chi xe cojow u tzij i Jesus, ire xu bij chique: —We yix n-qui mayij tu cojic in tzij, katzij ix in tijoxelab ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Quiwetamaj ni sak laj tzij, y quix quirtaj na rumal; quix el ʼuri puʼab wach ix chapawnak —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ʼO i xqui laʼ u wach che: —Yoj oj u muk u xiquin can i mam Abraham; n-ta jun u yom rib pakawi. ¿Wuchac ʼuri ca bij chi ʼo kelsaxic puʼab i oj chapawnak? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","I Jesus xu bij chique: —Katzij i quin bij: conojel i que macunic, je chaptal rumal i cajaw chi are i mac atzalal. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","(Quin bij jun chic tzij chiwe): jun, we xa aj takon ruʼ ja, lic re wi n-alcʼwa-laxel taj man ʼo rajaw, péro jun, we u cʼojol i rajaw ja, alcʼwalaxel ʼuri ronojel ʼij sak. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Yin, chi in u Cʼojol i Ta, we quix wesaj puʼab i iwajaw chi ix chapawnak, katzij quix el ʼuri chi sak, ix líbre chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Yin wetaʼam chi ix u muk u xiquin i mam Abraham. Xui-ri, quiwaj quin i camsaj man in tzij n-coc ta piwanima. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Niʼpa i quin bij chiwe, are in Kajaw cʼutuw nak chwe. Xak yix, are i quix tijin chu ʼanic, are u bim i kajaw yix chiwe —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","—Are i ka kajaw yoj are i ujer mam Abraham; oj u muk u xiquin ire —xe cha che. Teʼuri xu bij i Jesus chique: —We tene lic ix u muk u xiquin i mam Abraham piwanima, quix tijin te neri chu ʼanic pacha i xu ʼan ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Péro n-queje ti ile quix tijin chu ʼanic. Yin, wach in bim chiwe are i sak laj tzij chi Dios u cʼutum chwe. Tupu queje ile quin tijin chu bixquil chiwe, yix quiwaj quin i camsaj. I mam Abraham, lic n-queje ti ile. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Yix, are i quix tijin chu ʼanic, are pacha i coʼon i kajaw —xu bij chique. Ique xqui bij: —Yoj n-ta jun chic ka kajaw. Xa jun i ka kajaw, are i Dios —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","I Jesus xu bij chique: —We tene are i Dios i kajaw, cʼax ne quin i na yin-i, man yin in petnak ruʼ i Dios; rumal ire in cʼun-nak, n-toʼ ta in nojbal xin cʼunic; Dios in takawnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","¿Wuchac n-qui ta tu be wach i quin bij chiwe? Xa are man n-qui chʼij tu tayic. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","I kajaw yix are itzel. Yix ix re ire, y quiwaj qui ʼano pacha craj ire. I itzel lic are aj camsanel chu xebal ʼij sak. Ire lic nu yom tu wach ruʼ i sak laj tzij, lic n-craj ta cu bij i sak laj tzij. Ire, are coʼon jun tʼoronic, coʼono man lic re wi. Ire aj tʼoronel, xak are rajaw niʼpa i tʼoronic. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Xui-ri, yin quin bij i sak laj tzij, rumal-i, yix n-qui coj taj wach i quin bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","¿Xataba ʼo jun chiwe yix rilom chi ʼo jun in mac yin? Mi jun. Yin, lic katzij i quin bij, ¿wuchac ʼuri n-quin i coj taj? ");
INSERT INTO acr_acc_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Jun, we re i Dios, lic cu coj retalil che u tzij i Dios. Yix n-ix ta re i Dios, rumal-i n-quiwaj tu tayic u tzij ire —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Teʼuri i nimak tak aj Israel winak xqui bij che: —¿N-katzij ta bawa caka bij chi yet at aj Samária winak? ¿Chi xak ʼo jun itzel tew pawanima? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","I Jesus xu laʼ u wach chique: —Yin, n-ta itzel tew chwe. Are i quin tijin chu ʼanic, quin tijin chu cojic u ʼij in Kajaw. Y yix xa qui kajsaj in ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Yin, n-quin tzucuj ti u cojic in ʼij; xui-ri, i Ta chicaj craj chi cocsax in ʼij cumal i winak. Ire cu ʼat tzij piquiwi i n-quin qui coj taj. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Yin, sak laj tzij i quin bij chiwe; niʼpa i quiqui ʼan i quin bij, ique n-que cam taj ronojel ʼij sak —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Teʼuri i nimak tak aj Israel winak xqui laʼ u wach; xqui bij che: —Woʼor ya xketamaj chi ʼo itzel tew chawe. I nim laj ka mam, mam Abraham, ire xcamic, xak i nimak tak ajbil u tzij i Dios ujer, xe camic. ¿Wuchac ʼuri ca bij yet chi n-ca cam ta jun we cu ʼan pacha cu bij a tzij yet? ");
INSERT INTO acr_acc_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","¿Xataba yet mas ʼatz a patan chuwach i ka mam, mam Abraham? Ire xcamic, xak i ujer je ajbil u tzij i Dios xe camic. ¿At pachin yet ca ʼan che awib? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","I Jesus xu bij chique: —We yin quin coj in ʼij intuquel, n-ta queʼel wi. Are i ca cojow in ʼij are in Kajaw, chi qui bij yix are i Dios yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Péro yix n-iwetaʼam tu wach. Yin, lic wetaʼam u wach, y we ta quin bij chi n-wetaʼam tu wach, quin el ʼuri in aj tʼoronel, in xak jun ʼuri iwuʼ yix. Yin, lic katzij wetaʼam u wach, lic quin cojo wach cu bij ire chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","I mam Abraham, chi iwatit i mam yix, ire retaʼam ujer chi yin quin cʼun na chuwach i jyub taʼaj; lic xquicot ire rumal. Xril ire chi quin cʼunic, y lic xquicot rumal —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Teʼuri i nimak tak aj Israel winak xqui bij che i Jesus: —Yet cʼa maja cincuénta junab chawe. ¿Wuchac ca bij chi awilom u wach i ka mam, mam Abraham? ¿Wach u ʼonquil ʼuri? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","I Jesus xu bij: —Sak laj tzij i quin bij chiwe: are maja calax i mam Abraham, yin ʼax in ʼo wi chic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","(Teʼuri lic xpe coywal) xqui jek u yaquic abaj, cacaj quiqui coj che, péro i Jesus xu sach rib; xicʼaw chiquixol y xel pa rachoch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Xoʼon panok, i Jesus ca tijin chi be, xril jun mawach; lic mawach chi ralaxic. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","I u tijoxelab xqui tzʼonoj che: —Tijonel ¿wuchac xalax i achi-le mawach chi ralaxic? ¿Pachin xmacun chique ile? ¿Mokxa qui mac u chuch u kajaw, o xa u mac ire pu wach wi? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","I Jesus xu bij chique: —N-are ti u mac ire, xak n-are ti qui mac u chuch u kawaw ʼanawnak che. Xa che ire-le i Dios craj cu cʼut i nim laj u choʼab chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Presis quin ʼan i chac chi Dios in u takom li chu ʼonquil. (We xu rik i ʼij quin camic, ya n-quin chacun ta chic.) Tzʼakat cʼa paʼij, presis coj chacunic; we ya xoc ʼekum, ya n-coj chacun ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Tzʼakat in ʼo chi chuwach i jyub taʼaj, in queje pacha i sak re i paʼij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Are xrelej u bixquil ile, xu chubaj pichʼ u cʼaxaj pulew, xu yijba pichʼ xoʼol ruʼ, y xu coj che u baʼwach i mawach. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Teʼuri xu bij che: —Jat, ja chʼaja a palaj pa ya Siloe —xcha. (I tzij Siloe queʼelok: “Takom”.) I mawach xa ʼec, xe u chʼaja u baʼwach, y are xtzalij lok, ya ca tzun chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Are ʼuri, niʼpa i je u besin, niʼpa i quilom i mawach oʼonom lok, ique xqui bij: —Cakil yoj, are i achi-le are i mawach chi ca cubi chu tzʼonoxic u mer —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ʼO jujun xe binic: —Lic are ire —xe cha. Xak ʼo i xqui bij: —N-are taj, xui-ri, laj ca majawic —xe cha. Teʼuri i achi xu bij: —Katzij, yin i qui bij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Y xqui tzʼonoj che: —¿Wach u ʼonquil xa ʼano chi xat tzunic? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ire xu bij chique: —Are achi chi “ma Jesus” quiqui bij che, ire xu yijba pichʼ xoʼol y xu coj che in baʼwach. Teʼuri xu bij chwe: “Jat, ja chʼaja a baʼwach pa ya Siloe,” xu bij chwe. Xin ʼe ʼut y xin chʼajo; teʼuri xin tzunic —xu bij i achi chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","—¿Pa ʼo wi i achi-le? —xe cha che. —N-wetaʼam taj pa ʼo wi —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Teʼuri ique xqui cʼam bi i achi chi mawach teʼek, y xa ʼe qui ya chiquiwach i je aj Fariséo. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","I Jesus, are xu yijba i xoʼol, xak xrutzirsaj i mawach, che i uxlambal ʼij xoʼon wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","I aj Fariséo, are xupon i achi chiquiwach, xqui tzʼonoj che wach u ʼonquil xu ʼano are xtzunic. I achi xu bij chique: —Xu coj xoʼol che in baʼwach, teʼuri xin chʼajo, y woʼor quin tzunic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ʼO jujun chique i aj Fariséo xqui bij: —I achi chi queje ca ʼanaw ile n-re ti Dios, man ca chacun chupam i uxlambal ʼij —xe cha. Xak ʼo juban chic chique xqui bij: —¿Xataba ire ajmac laj winak, we ca tiqui chu ʼonquil tak i milágro pacha ile? —xe cha. Rumal-i xpe coywal chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Xqui tzʼonoj chic che i achi: —Yet, ¿wach ca chʼob che i achi-le chi xrutzirsaj a baʼwach? ¿Pachin i achi-le ca bij yet? —xqui bij che. —I achi-le, are jun ajbil u tzij i Dios —xu bij i achi chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","I aj Israel winak n-cacaj ta quiqui cojo chi i achi mawach teʼek, y woʼor ca tzun chic. Rumal-i xqui siqʼuij u kajaw u chuch. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","(Are xe upon u kajaw u chuch chiquiwach) xqui tzʼonoj chique: —¿Are iwacʼal iri chi qui bij yix lic mawach chi ralaxic? We katzij ile, ¿wach u ʼonquil chi woʼor ca tzunic? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","I u kajaw u chuch xqui bij chique: —Ketaʼam chi lic are i kacʼal ile; xak ketaʼam chi mawach chi ralaxic. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Xui-ri n-ketaʼam taj wach u ʼonquil xu ʼano chi ca tzun chic, xak n-ketaʼam taj pachin xcunaw u baʼwach. Chi tzʼonoj che ire; ire ya nim chic, ʼo chic u junab. Are ire mísmo cu bij chiwe wach u ʼonquil xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Queje ile xqui bij u kajaw u chuch chique man xqui xij quib chique i nimak tak aj Israel winak. I je nimak-le qui bim chic chi n-ʼus taj we jun u cojom chi Jesus are i Tolque chatal rumal i Dios. We queje ile u ʼonom jun, n-ca yaʼ ta chic che coc bi cuʼ pa qui molbal quib. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Rumal-i, xqui bij u kajaw u chuch: “Chi tzʼonoj che ire, man ire ya tzʼakatnak chic u junab,” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Teʼuri i aj Fariséo xqui tak chic u siqʼuixic i achi chi mawach teʼek. Xqui bij che: —Cha bij i sak laj tzij chuwach i Dios; man yoj ketaʼam chi i achi-le lic ajmac laj winak —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","—Yin n-wetaʼam taj we ajmac, xui wetaʼam chi yin in mawach teʼek, y woʼor quin tzun chic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Xak xqui tzʼonoj chic che: —¿Wach xoʼon chawe? ¿Wach u ʼonquil xu ʼano are xat u tzunsaj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Y xu bij chic chique: —Ya xin bij, y n-quiwaj ta qui cojo. ¿Wuchac quiwaj quin bij chic ucamul? ¿Mok quiwaj yix qui ya i wach ruʼ? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Rumal-i, xqui yoʼya i achi; xqui bij che: —Yet at jun chique u tijoxelab i ajmac-le, péro yoj oj u tijoxelab i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ketaʼam chi Dios xchʼaʼat ruʼ i mam Moises ujer, péro i achi-le, mi pichʼ ketaʼam pa petnak wi —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","I achi chi mawach teʼek xu laʼ chic u wach chique: —¿Wach u ʼonquil ile chi yix n-iwetaʼam taj pa petnak wi? ʼAlaj pa petnak wi, man xin u tzunsaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ketaʼam chi Dios n-que u ta ti ajmaquib wach i quiqui tzʼonoj che. Xui que u ta pachin i quiqui coj u ʼij, pachin i quiqui ʼan wach craj ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Cʼa chu xebal ʼij sak n-ka tom taj we ʼo jun cu tzunsaj jun mawach chi ralaxic. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","I achi-le, we n-ruʼ ti Dios petnak wi, n-ta puʼab-i cu ʼan ile —xu bij i mawach teʼek. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Teʼuri i aj Fariséo xqui bij che: —Yet, lic che awalaxic at sachnak chupam a mac. ¿Cawaj yet ca cʼut u tzij i Dios chake yoj? —xe cha che. Teʼuri xquesaj li achi pa molbalʼib, y xqui bij che chi mupon chic chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","I Jesus xu ta chi xquesaj li achi mawach teʼek. Are xu cʼulaj chic, xu bij che: —Yet, ¿cul a cʼux che u Cʼojol i Dios? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","I achi xu bij: —Nim laj winak, cha bij chwe pachinok, man cwaj quin cuba in cʼux che ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","I Jesus xu bij che: —Ya awilom chic; are yin, chi cat lapan wuʼ —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","—Kajwal, quin cuba in cʼux chawe —xu bij che, y xuqui chuwach i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Teʼuri i Jesus xu bij che: —Yin xin cʼun chuwach i jyub taʼaj, quin ʼalijinsaj pachin i je re i Dios y pachin i ne re taj. Niʼpa i je mawach pa canima, quin tzunsaj na chique; xak niʼpa i toʼ quiqui bij chi que tzun pa canima, que ʼelok je mawach. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","I aj Fariséo winak chi je ʼo chila, are xqui ta ile, je ʼo jujun chique xqui tzʼonoj che i Jesus: —¿Xataba yoj xak oj mawach? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","I Jesus xu bij chique: —Ma tene iwetaʼam chi ix mawach piwanima, n-ti mac ʼuri chiwij. Xui-ri, qui bij chi quix tzunic; rumal-i ʼo i mac chiwij —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","(I Jesus xu bij jun tzij chique tijojbal-que): —Sak laj tzij i quin bij chiwe: jun winak, we craj coc pa coral cuʼ i chij, cu tzucuj i ocbal; we n-coc ta che i ocbal, we xa cu cʼak rib puwi i coral, katzij xa iliʼom ʼuri, xa craj que relʼaj i chij. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Jun we che i ocbal coc wi, are aj yuʼul chij ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","I aj chajal re i ocbal retaʼam u wach, y cu ya ʼuri che coquic. Xak i chij quetaʼam u chʼawbal i aj yuʼul-que. Ire cu bij qui bi u chij are que u siqʼuij, y que resaj li pa coral. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Are que ʼel li u chij, ire ca nabeaj chiquiwach; y u chij que terej bi chirij, man quetaʼam u chʼawbal. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ique xak n-que terej ta chirij jun we n-quetaʼam tu wach, xa que ʼanmaj chuwach, man n-quetaʼam tu wach u chʼawbal —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","I tzij-le, are jun tijojbal tzij xu bij i Jesus chique, péro ique n-xqui ta tu be wach usucʼ i xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Rumal-i, i Jesus xu bij chic jun tzij chique: —Sak laj tzij i quin bij chiwe: yin in ocbal que i chij. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Niʼpa i je cʼun-nak nabe chinwach yin, ique xa je iliʼomab, xa elaʼ quiqui ʼano. Xui-ri, i chij n-xquetamaj tu wach i qui chʼawbal. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Chwe yin qui rik wi uchibe. Pachin i ca cʼun wuʼ, ca totaj ʼuri. Lic quin chajij; y queʼelok pacha jun chij quelsax bic, ca ʼe waʼok, y cocsax chalok. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","I iliʼom, we xcʼunic, xui col u ʼana elaʼ, tak i camsanic, col u ʼana cʼax chique i chij. Yin n-queje ta quin ʼan ile. Yin in cʼun-nak quin yabej qui cʼaslemal i winak, jun cʼaslemal tzʼakatnak, lic ʼo u qʼuial u chomalil. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Yin in ʼutz laj chajinel que i we yin, queje pacha jun ʼutz laj aj chajil chij. Jun ʼutz laj aj chajil chij cu ya rib chuwach i cʼax, tupu ca camsaxic, cu tobej que u chij. Queje quin ʼan yin ile, que in tobej i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Jun toʼ aj chʼacanel, n-cʼax ta que u na i chij. Are crilo ca cʼun li jun itzel chicop, que roʼtaj can i chij, y ca ʼanmajic. Queje ile cu ʼano, man n-are ti mer cajaw i chij, ire xa mocom. Are ʼuri itzel chicop que u chap i chij, y que u quichersaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","I achi-le, xa ca ʼanmajic man n-cʼax ta que u na i chij; ire ʼo chila xa rumal i chʼacoj craj. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","(Yin n-in ta pacha i aj chʼacoj-le), in queje pacha i ʼutz laj aj chajil chij man in ʼutz laj chajinel que i winak we yin. Yin lic wetaʼam u wach in Kajaw, xak in Kajaw retaʼam in wach yin. Queje yin ile chique i winak je we yin, wetaʼam qui wach; ique xak quetaʼam in wach yin. Yin xak quin ya wib chi camsaxic, tobal-que i je we yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Xak je ʼo juban chic winak, ne te aj Israel; ique xak que in siqʼuij wuʼ. Ique quiqui coj ni in tzij; coʼon panok xak jun iwach que u ʼon iwuʼ yix, y xui yin in aj chajal piwi iwonojel. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","I Ta cʼax quin u naʼo man yin quin ya na wib che i camic, y ca cʼun chic sak chinwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Mi jun quin u camsaj we n-quin ya ta che cu ʼano, xui-ri, quin ya na wib chi quin camsaxic. Lic ʼo pinʼab chi quin ya wib chi camic, xak ʼo pinʼab quin walij chic. Man queje ile u yom in Kajaw pin ʼab —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","I nimak tak aj Israel winak, are xqui ta ile, xe oc chu chapic quib puwi u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Je qʼui chique ique xqui bij: —Yix, ¿wuchac qui coj retalil che? I achi-le xa chʼuj; ʼo itzel tew che —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Je ʼo juban chic chi xqui bij: —We jun achi ʼo itzel tew che, n-cu bij taj pacha i cu bij ire-le. ¿Xataba jun itzel tew ca tiqui chu tzunsaxic jun mawach? —xqui bij chique i cachiʼil. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Chupam i ʼalaj, ʼo jun nimaʼij pa tinimit Jerusalen; are i nimaʼij re i rachoch i Dios chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Che i rachoch i Dios, ʼo jun u wach ja chi u bi “U wach ja re i mam Salomon”; chila ca malcat wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Xe upon juban nimak tak aj Israel, xqui mol quib ruʼ i Jesus y xqui bij che: —Cʼa koyʼem na umpa ca bij chake chi at pachin yet. Cha bij i sak laj tzij we yet at Tolke chi koyʼem —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","I Jesus xu bij chique: —Ya xin bij, y n-qui coj taj. Dios u yom chwe quin ʼan nimak tak ʼanic, cʼutbal-re in pachin yin, péro yix n-qui coj taj chi Dios u yom pinʼab. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Yix ix queje pacha i chij chi n-quin i coj taj, man n-ix ta we yin; pacha xin bij chiwe oʼonom lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Niʼpa i je we yin quetaʼam in chʼawbal. Yin wetaʼam qui wach, xak ique que terej chwij pacha quiqui ʼan i chij: quetaʼam u chʼawbal i cajaw, y que terej chirij. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Y yin quin ya i qui cʼaslemal chi n-tu qʼuisic. Lic n-que sach taj; xak mi ta jun cu maj chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Are in Kajaw je u yom ique chwe. In Kajaw, nim ni u choʼab chiquiwach conojel; mi jun ca tiqui chi qui majic che. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Yin, ruʼ in Kajaw, xa oj jun —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Rumal-i, i nimak tak aj Israel winak xe oc chic chu yaquic abaj, quiqui coj che, quiqui bij ique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Are ʼuri i Jesus xu bij chique: —Rumal in Kajaw, in ʼanom u qʼuial tak ʼutz chiwach. ¿Pachique che tak i in ʼanomle u petsam iwoywal yix? ¿Wach rumal quiwaj qui coj abaj chwe? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Teʼuri i nimak tak aj Israel xqui bij che: —N-rumal ta jun ʼutz a ʼanom chi caka coj abaj chawe. Caka ʼan na chawe man n-ʼus ti a bim chuwach i Dios; yet ca bij chi at xak jun ruʼ i Dios. Queje ile ca bij, y yet xa at jun chi winak —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","I Jesus xu bij chique: —I ʼatbal tzij tzʼibtal can rumal i mam Moises, cu bij chi Dios u bim i tzij-i: “Iwonojel yix ix tiox,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ketaʼam chi niʼpa i tzʼibtal chupam i wuj re i Dios, lic katzij. Bay, cu bij chi niʼpa i quiqui cʼam u tzij i Dios pa qui cʼux, ire cu bij chi je tiox. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Y yin, Dios in u chom, xak in u takom chuwach i jyub taʼaj. ¿wuchac ʼut qui bij yix chi in kajsam u ʼij i Dios man xin bij chi in u Cʼojol i Dios? ");
INSERT INTO acr_acc_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Yin we n-quin tijin ta chu ʼanic u chac in Kajaw, min i coj ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","We n-qui cuba ta i cʼux chwe yin, tupu quin ʼan u chac in Kajaw, chi cuba i cʼux che wach tak quin ʼano. We queje ile qui ʼano, lic quiwetamaj ʼuri chi i Ta chicaj ʼo chwe yin, y yin xak in ʼo che ire —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Rumal-i, xcaj tan chic i nimak tak aj Israel quiqui tzʼapij i Jesus, péro ire xtiqui chi relsaxic rib chiquixol. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Teʼuri, i Jesus xa ʼax chic chʼakap che i ya Jordan. Chila xcanaj wi, pa xu kajsaj wi ya i ma Wan piquiwi i winak oʼonom lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Je qʼui i winak xe upon ruʼ i Jesus, y xqui bij chiquiwach: —I ma Wan, katzij n-ta jun milágro xu cʼutu, xui-ri niʼpa i xu bij chirij i achi-le, lic sak laj tzij —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Je qʼui i winak xqui cuba qui cʼux che i Jesus chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ʼO jun achi, ma Lázaro u bi, lic iwab. Ire are qui xibal i ati Mariy i ati Márta, je jekel pa ral tinimit Betánia. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","I ati Mariy-le, are ati Mariy chi xoʼon panok, xcojow cunbal muy che rakan i Kajwal, y xu chakijsaj ruʼ u wi. Ire, ranab i ma Lázaro chi iwab. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","I je queb ranab-le, xqui tak rason ruʼ i Jesus, xqui bij bic: —Kajwal, lic iwab i achi chi cʼax ca naʼo —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","I Jesus, are xu ta ile, xu bij: —I yobil-le, n-are ta ca qʼuisaw u camic. Are i rumal re, are ca ʼalijinsaw u ʼij u choʼab i Dios, ca ʼalijinsaw u ʼij u choʼab i u Cʼojol i Dios chique i winak —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","I Jesus lic cʼax que u na i oxib alcʼwa-laxel-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","(Tupu cʼax que u naʼo), are xu ta chi iwab i ma Lázaro, xcanaj chic queb ʼij chila pa ʼo wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Teʼuri xu bij chique u tijoxelab: —Coj ʼe chic pa Judéa (pa jekel wi i ma Lázaro). ");
INSERT INTO acr_acc_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","I u tijoxelab xqui bij che: —Tijonel, ¿cawaj bari cat ʼe tan chic chila? Man cacaj teʼek i nimak tak aj Israel chila cat qui camsaj che abaj —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","(I Jesus xu bij jun tzij chique, ʼilbal-re chi maja cu rik i ʼij ca camic.) Xu bij: —¿Xataba n-ta cablajuj ʼor che jun ʼij? ʼOlic pues. We jun ca bin paʼij, n-ta cu taquij wi rib, man ʼo i sak chuwach i jyub taʼaj crilo. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Péro we jun ca bin chaʼab, cu taquij rakan, man n-ti sak ruʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Teʼuri xu bij i Jesus chique: —I kamig ma Lázaro ya xwaric, xui-ri ca ʼe in cʼastaj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","I u tijoxelab xqui bij che: —Kajwal, we xa cwaric, lic cutzir-i —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Xui-ri, i usucʼ u tzij i Jesus queʼelok chi ma Lázaro camnak chic. I u tijoxelab xqui chʼob ique chi xa cwaric, man queje ile xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Teʼuri i Jesus xu ʼalijinsaj u tzij chique; xu bij: —I ma Lázaro ya xcamic. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Quin quicotic chi n-in ta chila are xcamic. ʼUtz queʼel chiwe yix, man ca cowir u cubibal i cʼux chwe, rumal wach i quin ʼan na. Bay. Joʼ, jo kila —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ʼO jun chique i tijoxelab, ma Tomas u bi, xak “a-Yox” quiqui bij che. Ire xu bij chique i juban chic tijoxelab: —Xak choj ʼoj yoj ruʼ, chakachiʼilaj bi i ka Mayes; we quiqui camsaj, xak coj qui camsaj yoj ruʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Are xupon i Jesus chila pa Betánia, ʼo chic cajib ʼij che u mukic i ma Lázaro. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","I ral tinimit Betánia, n-naj ta ʼo wi che i Jerusalen, colo queb kilómetro ruʼ nicʼaj ʼo che u najtil. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Rumal-i je qʼui chique i aj Israel winak xe ʼe quila i ati Márta i ati Mariy, que qui pacbej qui bis rumal u camic i qui xibal. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","I ati Márta, are xu ta chi xupon i Jesus, xa ʼe u cʼulaj; xui-ri, i ati Mariy xcanaj can ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","I ati Márta xu bij che i Jesus: —Kajwal, we tene at ʼo chi, n-queje tene ca cam-i in xibal. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Péro wetaʼam chi Dios cu ya na chawe wach ca tzʼonoj che —xu bij che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","I Jesus xu bij che: —I a xibal ca cʼasi chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","I ati Márta xu bij che: —Wetaʼam chi ire cwalij chic are que walij i camnak pa qʼuisbal ʼij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Are ʼuri i Jesus xu bij che: —Are yin que in walijsaj i je camnak; are yin in qui cʼaslemal. Pachin cu cuba u cʼux chwe yin, we xcamic, ca cʼun chic sak chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Xak pachin i cʼaslic, we xu cuba u cʼux chwe yin, lic n-ca cam taj. ¿Cat cojon yet che ile? —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","I ati Márta xu bij: —In cojom ile, Kajwal. Cul in cʼux che chi yet at i Crísto, at Racʼal i Dios; are yet chi ʼax koyʼem wi a cʼunic chuwach i jyub taʼaj —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Are xbitaj ile, teʼuri i ati Márta xa ʼe chu siqʼuixic u chaʼ, chi ati Mariy. Xu bij che aliʼal: —I ka Tijonel ya xcʼunic y cat u siqʼuij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","I ati Mariy, are xu ta ile, juntir xwalijic, xa ʼe chu cʼulaxic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","I Jesus cʼa maja coc che i tinimit; chila ʼo wi pa xcʼulax wi rumal i ati Márta. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","I aj Israel winak chi je ʼo chi rachoch i ati Mariy, quiqui pacbej u bis, are xquilo chi juntir xa ʼe i ati Mariy, xqui chʼobo chi mok chila ca ʼe oʼ wi pa muktal wi u xibal. Rumal-i ique xe terej bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","I ati Mariy xupon chila ruʼ i Jesus. Are xril u wach, xuqui chuwach y xu bij che: —Kajwal, we tene at ʼo chi, n-queje tene ca cam-i in xibal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","I Jesus xril ati Mariy coʼic, xak xe ril i juban je ʼo ruʼ que oʼic. Ile n-xu maj tu wach y xa ʼutut u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Xu tzʼonoj chique: —¿Pa xi muk wi i a-Lázaro? —coʼono. —Kajwal, chol awila —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","I Jesus xoʼic. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Rumal-i, i aj Israel winak xqui bij: —Chiwilapeʼ, lic cʼax cu na i ma Lázaro —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Xak je ʼo jujun chique xqui bij: —Are ire-le chi xu tzunsaj i mawach. We tene ʼo ire chi ¿ca cam nawi i ʼetz ma Lázaro? —xqui bij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","I Jesus lic xa ʼutut tan chic pu cʼux, y xtejeb pan pa muktal wi i ma Lázaro. I jul pa qui mukum wi qui worom che jun abaj, tzʼapim can u chiʼ ruʼ jun abaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","I Jesus xu bij: —Chiwesaj i abaj-le. I ati Márta, chi ranab i camnak xu bij che i Jesus: —Kajwal, ya n-ʼus ta chic; ya ʼo chic ruxlab man ya ʼo chic cajib ʼij che —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Are ʼuri i Jesus xu bij: —¿Xataba n-in bim ta chawe, we cul a cʼux chwe, cawil i nim laj u ʼij u choʼab i Dios? —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Are ʼuri xquesaj abaj chu chiʼ i jul. I Jesus xtaken chicaj, xu bij: —Ta, quin tioxij chawe man a tom in tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Yin wetaʼam chi yet ʼax quin a ta wi, péro xin bij i tzij-le cumal que i winak-i, man ʼutz quiqui coj ique chi yet in a takom lok —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Are xbitaj ile rumal, teʼuri co xchʼawic; xu bij: —A-Lázaro, ¡chat el lok! —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Juntir xel li camnak, balʼatim i rakan u ʼab pa cʼul; i u palaj xak pasim pa cʼul. I Jesus xu bij: —Chi toro, man ca binic —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","I aj Israel winak chi je petnak ruʼ i ati Mariy, je qʼui xqui cuba qui cʼux che i Jesus rumal wach i xquilo. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Xui-ri je ʼo jujun chique xe ʼe chu bixquil chique i aj Fariséo wach i xu ʼan i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Rumal-i, i aj Fariséo, xak cuʼ i ajwab sacerdóte, xe ʼe chu molic quib cuʼ i aj nucʼbal tʼisbal. Are qui molom quib, xqui bij chiquiwach: —¿Wach caka ʼano? I achi-le, mas i milágro ca tijin chu ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","We toʼ queje ile caka canaj, conojel i winak quiqui coj ni u tzij i achi-le. Teʼuri i ʼatbal tzij pa Róma que u tak li rakan u ʼab, quiqui maj i rachoch i Dios waral, xak quiqui ya quib puwi i ka tinimit —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Teʼuri, i mer cajʼatzil i sacerdóte che i junab-le, ma Caifas u bi, ire xu bij chique i qui molom quib: —¡Yix n-ta ʼo iwetaʼam! ");
INSERT INTO acr_acc_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","¿N-qui chʼob ta bari chi ʼutz queʼel chake we ta ca cam jun achi, xa jun, pa qui qʼuexel conojel i winak? Queje ile, n-ca sach tu wach ronojel i ka tinimit —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","I mam Caifas, are xu bij i tzij-le, n-toʼ ta pu jolom ire xpe wi; ruʼ i Dios petnak wi u bixquil ile. Dios xa ʼanaw che are xu bij i tzij-le, man i mam-le ʼatz laj sacerdóte che i junab-le. Queje ile, xu ʼalijinsaj chique chi Jesus ca cam na pa qui qʼuexel i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Y n-xui ta chique i aj Israel; xak ca cam na, junamsabal-que conojel i je racʼal i Dios chi je ʼo chuwach tak i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Che i ʼij-le, i nimak tak aj Israel xqui jek u yijbaxic wach u camsaxic i Jesus quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Rumal-i, i Jesus n-xmalcat ta chic chiquiwach u qʼuial aj Israel winak chila pa Judéa, xui-ri xa ʼe che jun aldéa chi ʼo chu chiʼ i chakij jyub pa n-ta wi winak. I aldéa-le, Efrain u bi. Chila xcanaj wi cuʼ u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Are ya mer cu rik i ʼij re i páscua que i aj Israel winak, je qʼui i winak xe ʼel pa qui tinimit, xe ʼe cʼa Jerusalen. Xe ʼe chu ʼanic rawasil, ʼanbal chʼam che quib chuwach i Dios man ya ca cʼun i nimaʼij páscua. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Are xe malcat pa tinimit Jerusalen, xqui tij u takexic chiquixol i winak, ʼilbal-re we ca cʼun i Jesus. Are xe oc pa rachoch i Dios, xqui tzʼonoj chiquiwach: —¿Wach qui chʼob yix? ¿Ca cʼun nawi che i nimaʼij-i? ¿O n-ca cʼun taj? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","I aj Fariséo, xak cuʼ i ajwab sacerdóte xquesaj u bixquil chique i winak: “We xiwil u wach i Jesus, chi bij chake,” xqui bij. Queje ile xqui bij man cacaj ique quiqui chapo. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wakib ʼij chuxeʼ li nimaʼij páscua, xa ʼe chic i Jesus pa Betánia, pa jekel wi i ma Lázaro chi walijsam chic rumal i Jesus are xcam teʼek. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Are xupon chila, xqui ʼan jun nim laj waʼim cojbal u ʼij i Jesus. I ati Márta ca tijin chi qui tzukic; i ma Lázaro, xak juban chic achiab, je cul chi mexa ruʼ i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","I ati Mariy rucʼam jun lamet cunbal lic muy, ʼantal che jun ʼes, nárdo u bi, pakal rajil. Xu coj i cunbal muy che i rakan i Jesus, y xu chakijsaj ruʼ u wi. I u muyal i cunbal, lic xa ʼe ruxlab paja. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","I ma Júdas Iscarióte, chi u cʼojol i mam Simon, n-xu ya tu wach che, wach i xu ʼan i ixok. Ire are jun chique i u tijoxelab i Jesus, chi xak xu cʼayij i Jesus xoʼon panok. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","Ire xu bij: —I cunbal muy-le, ʼutz we tene xu cʼayij y cu cʼam li mer que u tobej que i nibaʼib, man ile, rajil tres ciéntos quetzales —xu bij i ma Júdas. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Péro n-are ti tobal-que i nibaʼib xu chʼobo; ire xa iliʼom, craj crelʼaj i mer. Man ire, aj cʼolol mer chiquij i rachiʼil; ʼolic queje coʼon che i mer chi qui molom, xa crelʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Teʼuri i Jesus xu bij che i ma Júdas: —Ma yaj i ixok-i. Ire ʼax u cʼolom wi i cunbal muy-le, cu bacbej re in chʼacul, yij-bal-we che in mukic. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","I nibaʼib, nic are wi je ʼo iwuʼ, pachique ʼij quiwaj qui ya chique, ʼis ʼutz. Péro yin n-quin najtin ta chic iwuʼ —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Je qʼui chique i aj Israel winak xqui ta rason chi Jesus ʼo pa Betánia. Xe ʼe chila, n-xui ta rumal cacaj rilic i Jesus, xak cacaj rilic i ma Lázaro chi walijsam chiquixol i camnak rumal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Rumal-i, i ajwab sacerdóte xqui bij chiquiwach chi ma Lázaro xak quiqui camsaj na. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Queje xqui chʼob ile, man rumal re i ma Lázaro je qʼui i aj Israel winak xqui cuba qui cʼux che i Jesus; xqui mayij can u cojic qui tzij i ajwab sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Chucab ʼij i Jesus xel pa Betánia y xu maj u be pa Jerusalen. Je qʼui i winak je upon-nak pa Jerusalen chi rilic i nimaʼij páscua. Ique xqui ta rason chi Jesus cupon na chila pa tinimit Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Rumal-i, xqui tzucuj u xak pálma, y xe ʼe chu cʼulaxic i Jesus. Are que tijin chi be, xe siqʼuin chu bixquil i tzij-i: —¡Hosánna! ¡Nim u ʼij i Dios! ¡Dios chu ya ni ʼutz puwi i jun-i chi u takom na lok! ¡Chu ya ni ʼutz puwi i jun-i chi ka ʼAtol Tzij yoj oj aj Israel winak! —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","I Jesus xu rik jun buru, y xa ʼan chirij. Xeʼelok pacha i tzʼibtal chupam i wuj ujer, man i Dios u bim canok: ");
INSERT INTO acr_acc_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Mi xij iwib yix chi ix aj Sion; chiwilapeʼ, ya xcʼun i ʼAtol Tzij yix ʼan-nak chirij jun ral buru. (Queje ile tzʼibtal ujer chupam i wuj re i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","I u tijoxelab i Jesus, are xquil ile, n-xqui ta tu be wach usucʼ. Xoʼon panok, are xocsax u ʼij u chomal, teʼuri xcʼun chi qui cʼux chi are i xeʼelok pacha i tzʼibtal can ujer. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","I winak chi quilom wach i u ʼanom i Jesus che i ma Lázaro, xqui paxsaj rason wach i quilom: chi Jesus xu siqʼuij i ma Lázaro pa i muktal wi, y xu cʼunsaj sak chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Rumal-i, je qʼui i winak xe walij chu cʼulaxic i Jesus; ique qui tom rason wach i milágro xoʼon che i ma Lázaro. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Are ʼuri i Fariséo xqui bij chiquiwach: —Ya xiwilo, lic n-ta queʼel wi wach i caka ʼano. Chiwilapeʼ, conojel i winak que terej chirij —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Je qʼui i je upon-nak pa Jerusalen ca ʼe qui cojbej u ʼij i Dios chupam i nimaʼij-le. Chiquixol ique je ʼo juban aj Griégo winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Ique-le xe tejeb ruʼ i ma Felípe chi aj pa tinimit Betsáida re i Galiléa, y xqui bij che: —Nim laj winak, cakaj cakil u wach i Jesus —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","I ma Felípe xa ʼe chu bixquil che i ma Andres. Teʼuri che queb, xe ʼe chu bixquil che i Jesus chi je ʼo i aj Griégo winak quiqui chʼob rakan. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Teʼuri i Jesus xu bij chique: —Ya xu rik i ʼij ca ʼalijinsax in ʼij yin chi in Achi aj Chicaj —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","(Teʼuri i Jesus xu bij jun tijojbal tzij cumal i aj Griégo:) —Pacha coʼon ija re i trígo are ca tiquic: jun ija, we cu ya u wach, nabe ʼo u chac ca mukic. We n-ca muk taj, n-tu wach cu yaʼo. We xmukic, calax tan chic y cu ya u qʼuial u wach. (Queje coʼon ile chwe yin are quin muktajic.) ");
INSERT INTO acr_acc_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","(Queje ile coʼon i ka cʼaslemal.) Pachin jun toʼ cʼax cu na u cʼaslemal waral chuwach i jyub taʼaj, cu sach u wach u cʼaslemal chila chicaj. Péro we ʼo jun, n-cʼax ta cu na u cʼaslemal waral chuwach i jyub taʼaj, are cu chʼac u cʼaslemal ʼuri chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","We ʼo jun craj cu ʼan in chac, cha terej chwij, man pa in ʼo wi yin, xak chila ca qʼuiji wi i wajchac. We ʼo jun cu ʼan in chac yin, in Kajaw cu coj na ʼuri u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Woʼor lic ca cʼachir in cʼux. ¿Wach quin ʼan ʼut? ¿Xataba quin bij che in Kajaw: “Chin awesaj chuwach i camic chi ca pe chwij,” quin cha? N-quin bij taj, man xa rumal ile xin cʼun chuwach i jyub taʼaj —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Teʼuri xu bij: —Ta, cha cʼutu li a choʼab, quiqui cojbej ni a ʼij i winak —xu bij. Are ʼuri xtataj jun tzij chi xchʼaw li chicaj: —Ya in ʼanom chic, y quin ʼan tan chic —xu bij i tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","I winak chi je ʼo chila, are xqui ta i tzij chi xchʼaw li chicaj, xqui bij chi are ray xchʼawic. Xak ʼo xqui bij: —Jun ángel xchʼaw li che —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","I Jesus xu bij chique: —Are i chʼawbal xi ta, n-rumal taj we quin ta yin, xa iwumal yix (man quiwetambej-re in pachin yin). ");
INSERT INTO acr_acc_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Ya xu rik i ʼij chi Dios cu ʼan ʼatbal tzij puwi i jyub taʼaj; ya xu rik i ʼij chi quelsax itzel chi ʼatol tzij re i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Yin, are quin yactaj ʼanok, are ʼuri conojel i winak quin ʼan chique chi que cʼun wuʼ —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Are i tzij xu bij-le, are tabal-re chique wach u ʼonquil i camic quicʼaw wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Are ʼuri i winak xqui bij che: —Yoj ka tom chic wach cu bij i tzij chupam u wuj i Dios; cu bij chi Crísto, n-tu qʼuisic u cʼaslemal. ¿Wach u chac ʼuri ca bij yet chi cat yactaj ʼanok (cat camsax chuwach cruz), we yet at i Achi aj Chicaj? ¿Pachin ʼuri i Achi aj Chicaj-le? —xqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Teʼuri i Jesus xu bij chique: —Xa queb oxib ʼij chic ʼo i sak iwuʼ (chi are yin). Chix binok, tzʼakat cʼo i sak iwuʼ, mokxa ca pe i ʼekumal piwi. Are i ca bin pa ʼekumal n-retaʼam taj pa ca ʼe wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Chi cuba i cʼux chwe tzʼakat in ʼo iwuʼ; quix eʼel ʼuri ix wacʼal. I Jesus, are xbitaj ile rumal, xel chiquixol; n-xquetamaj taj pa i xa ʼe wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","I winak, tupu qʼui i milágro u ʼanom i Jesus chiquiwach, mi ne ruʼ ile n-quiqui cuba ta qui cʼux che. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Queje ile queʼelok pacha xu bij i mam Isaías ujer. Xu bij: Kajwal, ¿pachin nawi coj cojowic, wach i ka bim? ¿Pachin nawi quiqui ta u be i nimak tak ʼanic chi u ʼanom i Dios? (Queje ile tzʼibtalic.) ");
INSERT INTO acr_acc_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Rumal-i, n-xqui coj taj, man i qui nojbal queje pacha u tzʼibam i mam Isaías ujer. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","I Dios xoʼon mawach che i qui nojbal; xak xoʼon chique n-xcaj tu cʼamic u tzij piqui cʼux; queje ile xoʼon chique man n-quiquil tu be usucʼ, xak n-quiqui ta tu be piqui cʼux, xak n-que cʼun ta wuʼ, col qui cunbej quib. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","I mam Isaías xu bij i tzij-i are xril u wach u chomal i Crísto pu wach. Man i tzij chi xu bij-i, xu lapbej re i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Katzij pacha i xu bij i mam Isaías ujer; ʼo i n-xe cojon taj, xui-ri, je qʼui i aj Israel winak xqui cojo, xak ʼo i je qui wi qui jolom xe cojowic. Péro n-quiqui ʼalijinsaj taj, man quiqui xij quib chique i aj Fariséo; ique we xquetamaj, n-que qui cʼulaj ta chic cuʼ pa qui molbalʼib. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","N-xqui ʼalijinsaj taj, man mas quiqui tzucuj u cojbal qui ʼij cumal i winak chuwach u tzucuxic u cojbal qui ʼij rumal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","I Jesus co xchʼawic, y xu bij: —Are i cu cuba u cʼux chwe yin, queʼelok n-xui ta chwe yin cu cuba wi u cʼux, xak cu cuba u cʼux che i Ta chi in takawnak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Are i quin u takej, xak cu takej i xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","In cʼun-nak chuwach i jyub taʼaj pacha i sak re i paʼij. Rumal-i, pachin jun cu cuba u cʼux chwe yin, n-ca qʼuiji ta pa ʼekum. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","We ʼo jun cu ta in tzij quin bij, y n-cu cuba tu cʼux chwe, ʼo ni tojbal-re che, péro n-yin ta quin ʼanaw ʼuri che. Man yin xin cʼun chuwach i jyub taʼaj, n-in ti aj yol tojpen chiquij i winak, man are in chac yin, are ʼelsabal-que chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Pachin n-cu cuba tu cʼux chwe, y xak n-cu coj ta in tzij, ʼo chic ʼuri ca ʼataw tzij puwi. Are in tzij chi in bim che, are ca ʼataw tzij puwi are cu rik i qʼuisbal ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Man niʼpa i tzij chi quin bij, n-in nojbal ti yin. I Ta chicaj chi in takawnak lok are bin-nak chwe wach i quin bij y wach i quin cʼutu. ");
INSERT INTO acr_acc_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Yin wetaʼam chi i tzij xin u tak li chu bixquil, pachin i xu cojo, cu rik ʼuri u cʼaslemal chi n-ca qʼuis ta chic. Niʼpa i quin bij, ʼis are quin bij pacha xin u tak li Ta chu bixquil —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ya cu rik i ʼor re i cenar re i nimaʼij páscua. I Jesus retaʼam chic chi ya cu rik i ʼor chi quel chi chuwach i jyub taʼaj, y ca ʼe chic ruʼ i Ta chicaj. Ire lic ʼax oʼonom wi lok, cʼax que u na i je re ire waral chuwach i jyub taʼaj; xak cʼax xe u naʼo cʼa pa qʼuisbal-re. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","4","Xui-ri, i ma Júdas Iscarióte chi u cʼojol i ma Simon, yatal chic u noʼoj rumal itzel chi cu jach ni Jesus piquiʼab i que tzucuw chʼoʼoj chirij. I Jesus retaʼam chi i Ta ʼis u yom puʼab ronojel i ʼolic; xak retaʼam chi ruʼ i Dios petnak wi, y ruʼ i Dios ca ʼe wi chic. Rumal-i, are ca tijin che i waʼim cuʼ u tijoxelab, xwalij chiquixol y xu jal jule u ʼuʼ chirij. Teʼuri xu cʼam jun toʼay, y xu xim xe u pam. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Teʼuri xu cʼam i ya, xu ya pa jun palangan, y xu jek u chʼajic cakan u tijoxelab; teʼuri xu jek u chakijsaxic i cakan che i toʼay chi u ximom xe u pam. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Are xupon ruʼ i ma Simon Pédro, ire xu bij che: —Kajwal, n-ca majaw taj we yet ca chʼaj i wakan —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","I Jesus xu laʼ u wach che: —Are i quin tijin chu ʼanic, n-ca maj ti usucʼ woʼor. Coʼon panok, teʼuri ca maj usucʼ —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","I ma Pédro xu bij chic: —¡Lic n-quin ya taj ca chʼaj i wakan yin! I Jesus xu bij che: —We yin n-quin chʼaj ti awakan chawe, n-at ta we yin chic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Teʼuri xu bij i ma Simon Pédro che: —Kajwal, we queje usucʼ ile, n-xui ta-ri i wakan; xak cha chʼaja in ʼab, in jolom —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","I Jesus xu bij che: —Jun, we atin-nak chic, chʼam chic ʼuri, xui chic i rakan ʼuri craj chʼajic. Yix ix chʼam chic; xui-ri, n-iwonojel taj —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","I Jesus xu bij iri, “n-iwonojel taj ix chʼam”, xcha, man retaʼam pachinok chique ca jachaw ire piquiʼab i je aj chʼoʼoj chirij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","I Jesus, are xrelej u chʼajic i cakan u tijoxelab, teʼuri xu coj chic i jule u ʼuʼ chirij. Xcubi chic chi mexa, teʼuri xu tzʼonoj chique: —¿Iwetaʼam usucʼ wach i xin ʼano? ");
INSERT INTO acr_acc_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Yix qui bij chi in Tijonel chiwe, xak in Iwajwal. Katzij i qui bij-le, man are in patan ile chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","We queje ile quin ʼan yin chi in i Tijonel, xak in Iwajwal, xin chʼaj iwakan chiwe, queje ile ʼuri chi ʼana yix; chi chʼaja iwakan chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Yin, xa cʼutbal-re xin ʼan chiwach, man pacha i quin ʼan yin, ʼutz queje qui ʼan ni yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Sak laj tzij i quin bij chiwe; jun ajchac, n-ʼatz tu ʼij chuwach u patron; xak jun takon, n-ʼatz tu ʼij chuwach i xtakaw bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Yix, we qui ta u be niʼpa iri, xak we qui ʼano pacha in bim-i, ʼutz ʼuri iwe yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Péro n-iwonojel taj ix queje ile: yin wetaʼam pachin je in chom. Queʼel na pacha i tzʼibtal chupam i wuj re i Dios; queje iri cu bij: “Jun chi cu tij wa wuʼ yin, xu yac chʼoʼoj chwij yin,” cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Quin tijin iri chu bixquil chiwe woʼor, chi maja ca ʼantajic, man we xiwilo xa ʼantajic, teʼuri qui coj na in pachin yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Sak laj tzij i quin bij chiwe: pachin jun cu cʼulaj in takon yin, queʼelok chi yin quin u cʼulaj ruʼ. Pachin jun quin u cʼulaj yin, xak cu cʼulaj i Ta chicaj chi xin takaw lok —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","I Jesus, are xrelej u bixquil ile, xa ʼutut pu cʼux. Are ʼuri xu sakij chique: —Katzij i quin bij chiwe, ʼo jun chiwe yix quin u jach na piquiʼab i je aj chʼoʼoj chwij —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Are ʼuri i u tijoxelab toʼ xqui tzu quib chiquiwach, man n-quetaʼam taj pachinok chique i xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ʼO jun chiquixol i u tijoxelab, mas cʼax ca naʼ rumal i Jesus, ire cul pu tzal i Jesus chi mexa. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Che i jun-le, i ma Simon Pédro xoʼon pan séña che, chi cu tzʼonoj che i Jesus pachin i xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Are ʼuri, i jun-le xtejeb pan mas ruʼ i Jesus, y xu tzʼonoj che: —Kajwal, ¿pachinok chake chi cat jachaw na? ");
INSERT INTO acr_acc_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","I Jesus xu bij che: —Quin mu ni caxlanwa, y quin jach puʼab junok chiwe. Pachin che quin ya wi ile, are i quin jachaw ʼuri —coʼono. Teʼuri xu mu i caxlanwa, xu jach pan puʼab i ma Júdas Iscarióte, chi u cʼojol i mam Simon. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","I ma Júdas, are xu chap i caxlanwa, are ʼuri i itzel xoc pu cʼux. Teʼuri i Jesus xu bij che: —Are i a chʼobom chi ca ʼano, jat la chu ʼonquil —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Mi jun chique i que tijin chi waʼim xu ta u be wach usucʼ ile chi xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Chiquixol ique, are i ma Júdas are ca cʼolow i qui mer. Rumal ʼuri ʼo jujun chique xqui chʼobo chi Jesus xu bij che, “Cha loʼo wach i cajwax chake pa nimaʼij,” o “Cha jacha jubiʼ chique i nibaʼib.” Queje ile xqui chʼob ique. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","I ma Júdas xu cʼam i caxlanwa; are ʼuri xel bi chiquixol y xa ʼec. Ya chaʼab chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Are xel bi i ma Júdas, i Jesus xu bij chique i xe canaj canok: —Woʼor ca ʼalijin ʼut wach in ʼij in chomal yin chi in Achi aj Chicaj. Xak ca ʼalijin chwe yin wach u ʼij u chomal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Y we ca ʼalijin u ʼij u chomal i Dios chwe yin, xak queje ile cu ʼalijinsaj ni Dios in ʼij in chomal yin. Weʼ tan ile ca ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ix ral tak wacʼal, n-naj ta chic in ʼo chixol yix. Quin i tzucuj na, xui-ri, pacha i xin bij chique i qui nimakil aj Israel winak, xak queje quin bij chiwe yix woʼor: pa i quin ʼe wi yin, yix n-quix ʼe taj, n-quix tiqui ta che. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ʼO jun tzij pixab cʼacʼ quin bij chiwe, ʼo u chac chi ʼana iri: cʼax chi na iwib chiwach. Pacha i quin ʼan yin, cʼax quix in naʼo, xak queje ile chi ʼana yix, cʼax chi na iwib chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","We cʼax qui na iwib chiwach, chi ʼuri caquetamaj conojel i winak chi ix tijoxelab we yin, we queje qui ʼan ile —xu bij chique u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Teʼuri i ma Simon Pédro xu bij che i Jesus: —Kajwal, ¿pa cat ʼe wi? I Jesus xu bij che: —Ipa i quin ʼe wi yin woʼor, n-quix terej ta bi chwij; cʼa coʼon na panok, teʼuri quix terej chwij —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","I ma Pédro xu bij chic che i Jesus: —Kajwal, ¿wuchac n-quin terej ta bi chawij woʼor? Yin lic quin ya wib chi camic, tobal awe yet —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","I Jesus xu bij che: —¿Katzij nawi cat camic tobal we? Sak laj tzij quin bij chawe, woʼor mísmo, are cʼa maja ca chʼaw i ucamul acʼ, cawuwaj na in wach oxmul —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yix, mix cʼachir pi cʼux; cul i cʼux che i Dios, xak chi cuba i cʼux chwe yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ruʼ in Kajaw ʼo u qʼuial qʼuijibal. Ma te queje oʼonom ile, xak quin bij-i chiwe. Xui-ri quin ʼe ʼut que in yijba i qʼuijibal yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","We xin ʼe ʼut, xak we xyiji i qʼuijibal yix, teʼuri quin cʼun chic, y quix in cʼam bi wuʼ, man pa i quin qʼuiji wi yin, xak chila quix qʼuiji wi yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Yix iwetaʼam chic i pa quin ʼe wi, xak iwetaʼam chic i be —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Teʼuri i ma Tomas xu bij che i Jesus: —Kajwal, n-ketaʼam taj pa i cat ʼe wi, ¿wach retamaxic i be caka ʼano? ");
INSERT INTO acr_acc_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","I Jesus xu bij che: —Xui wumal yin qui rik i be; wumal yin qui rik i sak laj tzij, wumal yin qui rik i cʼaslemal. Xui wumal yin ca ʼan oquic ruʼ i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","We iwetaʼam in wach yin, xak iwetaʼam ʼuri u wach in Kajaw chila chicaj. Ya xiwetamaj ʼut woʼor, xak iwilom u wach —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Teʼuri xu bij i ma Felípe che: —Kajwal, cha cʼutu u wach i Ta chake; xui cakaj-i —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","I Jesus xu bij che: —A-Felípe, ʼo tan chi ʼij in ʼo iwuʼ, ¿cʼa maja ʼuri cawetamaj in wach? We ʼo jun xril in wach yin, queʼelok xril u wach i Ta chicaj. ¿Wuchac ʼuri ca bij yet chwe, “Cha cʼutu u wach i Ta chake,” cat cha? ");
INSERT INTO acr_acc_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","¿N-ca coj ta ba-ri chi yin in ʼo che i Ta chicaj, xak i Ta chicaj ʼo chwe yin? I tzij chi quin bij yin chiwe, n-yin ta quin nojiwic; are i Ta chicaj ca nojiwic, chi ʼo chwe yin; are u chac ire quin tijin chu ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Chi cojo in tzij chi yin in ʼo che i Ta chicaj, xak i Ta chicaj ʼo chwe yin. We n-qui coj ta in tzij chi xin bij chiwe, chin i cojo ʼut rumal wach tak i quin ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Katzij i quin bij chiwe, pachin jun cul u cʼux chwe yin, xak coʼon na ʼuri wach tak i quin ʼan yin. N-xui ta la ile coʼon na; mas nim i coʼon na chinwach yin, man yin quin ʼe ruʼ i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ronojel niʼpa i qui tzʼonoj pin bi yin, quin ya na chiwe. Quin ʼano, man ca ʼalijin ni nim laj utzil chomal re i Ta chicaj wumal yin, chi in u Cʼojol. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","We ʼo i qui tzʼonoj pin bi yin, quin ʼan na. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Yix, we cʼax quin i naʼo, chix cojon ʼuri che in tzij yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Teʼuri quin tzʼonoj che i Ta chicaj cu tak li jun Ucʼanel iwe chi in qʼuexel yin. Ire ca qʼuiji iwuʼ queʼe ʼij sak, tobal iwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Are ire are u Tewal i Dios chi ca cʼutuw i sak laj tzij chiwe. Are i toʼ je re u wach i jyub taʼaj, n-quiqui cʼulaj ta cuʼ man n-caquil tu wach, xak n-caquetamaj tu wach. Péro yix quiwetamaj u wach, man Ire jekel iwuʼ yix, xak ca qʼuiji pi cʼux queʼe ʼij sak. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Yin, n-quix woʼtaj ta canok; quin cʼun chic iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Xa jubiʼ chic in ʼo chi; i toʼ winak je re u wach i jyub taʼaj n-caquil ta chic in wach, péro yix quin iwil tan chic; yin in cʼaslic ronojel ʼij sak, rumal-i yix xak quix cʼasi ʼut. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","We xu rik i ʼij chi quin bij chiwe-ri, teʼuri quiwetamaj chi yin in ʼo che i Ta chicaj, xak yix ix ʼo chwe yin, xak queje yin in ʼo chiwe yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Pachin retaʼam in tzij yin, xak cu ʼan cas che, ca ʼalijin ʼuri che, chi lic cʼax quin u naʼo. Pachin cʼax quin u naʼo, xak cʼax ca naʼ rumal i Ta chicaj. Xak queje yin cʼax quin naʼo; quin ya na che cretamaj chi in ʼo ruʼ —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ʼO jun chique u tijoxelab, ma Júdas u bi (n-are ti ma Júdas Iscarióte), ire xu tzʼonoj che i Jesus: —Kajwal, ¿wach u chac ile xui ca cʼut awib chake yoj, y n-ca cʼut ta awib chique i conojel i winak chuwach i jyub taʼaj? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","I Jesus xu bij che: —(Man cʼax quin i naʼo.) Pachin cʼax quin u naʼo, cu coj in tzij; cʼax ʼuri ca naʼ rumal in Kajaw. Yin, junam ruʼ in Kajaw, coj cʼun ruʼ, col ka ʼana ka qʼuijibal pu cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pachin jun n-cʼax ta quin u naʼo, n-cu coj ta ʼuri in tzij. I tzij chi i tom chwe, n-we ti yin, are u tzij in Kajaw chi xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Quin bij iri chiwe tzʼakat in ʼo chi iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Coʼon panok, i Ta cu tak li Ucʼanel iwuʼ, chi u Tewal; ire ca cʼun pin qʼuexel yin. Are chic ire ca cʼutuw ronojel iri chiwe, y ca cʼunsaw pi cʼux niʼpa in bim yin chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Quin ya can i uxlambal i cʼux chiwe, woʼor quin ʼec. Are i uxlambal cʼuxij quin ya chiwe, n-are ti uxlambal cʼuxij pacha i quiqui ya i toʼ winak; i uxlambal cʼuxij quin ya yin, lic sakil. Rumal-i, mix cʼachir pi cʼux, xak mi xij iwib. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Ya i tom chic wach in bim chiwe, chi quin ʼe ʼut, teʼuri quin cʼun chic iwuʼ. We katzij cʼax quin i naʼo, quix quicot ʼuri che i xin bij, chi quin ʼe ruʼ i Ta chicaj; man ire nim u ʼij u choʼab chinwach yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Suʼ xin bij iri chiwe, man we xoʼon ile pacha i xin bij; teʼuri qui cojo. ");
INSERT INTO acr_acc_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ya n-quin chʼaʼat ta chic mas iwuʼ, man ya ca cʼun itzel chi ʼatol tzij piquiwi i winak re u wach i jyub taʼaj. Tupu ire n-ta re chwe, ");
INSERT INTO acr_acc_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","xui-ri, quin ya wib che, wach coʼon chwe, cʼutbal-re chique i winak chi yin cʼax quin na i Ta chicaj, xak quin ʼano pacha i cu bij ire chwe. Chix walijok; jo ʼut, coj el chi. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","(Quin bij ni jun tzij, tijojbal iwe. Yix iwetaʼam u wach i jun ticon, raxcʼam rakan, úva u bi.) Yin in queje pacha u raxcʼamil i ticon-le, xui-ri, yin in sakil ticon; y are in Kajaw, are ca ʼanaw i chac che i ticon. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ire cresaj bi u ʼab i ticon chi n-ca wachin taj. Xui-ri, i u ʼab i ticon chi ca wachinic, ire cu cʼatzij u tzam, xak cu josʼij, man cu ya mas u wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Yix ix pacha i u ʼab i ticon-le; ya ix josʼim chic rumal in tzij chi ix cojon-nak che. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Chix jekel ʼu chwe; queje pacha in ʼanom yin, in jekel chiwe yix. Man i u ʼab i ticon, n-coʼon tu wach utuquel we n-nacʼal ta che u raxcʼamil; xak queje yix ile, n-quix wachin taj we n-quix jeki ta chwe yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Are yin, pacha in u raxcʼamil i ticon; are yix, pacha ix u ʼab i ticon. Pachin jun ca jeki chwe yin, xak yin quin jeki che ire, lic ca wachin ʼuri che u cʼaslemal. Yix, we xi jecʼ iwib chwe yin, n-ta ʼutz ʼuri qui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Pachin jun n-cu jekba ta rib chwe yin, quelsax ʼuri y ca cʼak bic. Pacha u ʼab i ticon are quelsax che i raxcʼamil, ca cʼak bic y ca chakijic; teʼuri ca mol u chiʼ, y ca porox ʼu pa ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Yix, we quix jeki chwe yin, xak we ca jeki in tzij pi cʼux, chi tzʼonoj ʼuri wach i quiwaj, y ca yaʼ chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","We lic ca wachin i cʼaslemal yix, mas cocsax ʼuri u ʼij in Kajaw; queje ile quix u ʼon na ʼuri ix in tijoxelab sakil. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Yin, cʼax quix in na yix, pacha i cʼaxnabal we yin coʼon in Kajaw. Chix ʼol che i cʼaxnabal in cʼux in yom chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","We quix cojon che in tzij in pixab yin, quix qʼuiji ʼuri che i cʼaxnabal in cʼux; pacha i quin ʼan yin, quin coj u tzij u pixab in Kajaw, y quin qʼuiji che i cʼaxnabal u cʼux ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Ronojel iri xin bij chiwe, man cwaj ca qʼuiji i quicotemal iwuʼ chi quin ya yin, queje ile, ca tzʼakat na i quicotemal. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","(We quiwaj ca tzʼakatsax i quicotemal), chix cojon che in tzij-i: cʼax chi na iwib chiwach, pacha i cʼax i naʼic yix quin ʼan yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","N-ti cʼaxnabal cʼuxij mas nim chuwach iri: we jun cu ya rib chi camic tobal-que pachin i cʼax que u naʼo. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Y yix, we quix cojon che niʼpa i quin bij chiwe, cʼax ʼuri quin i naʼo. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Yin n-quin bij ta chic we toʼ ix wajchac, man jun ajchac n-retaʼam taj wach coʼon u patron. Xui-ri, in bim chic chiwe chi are yix chi cʼax quix in naʼo, man in ʼalijinsam chiwe ronojel niʼpa xu bij in Kajaw chwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","N-yix taj xin i cha yin, are yin xix in cha yix man quix ʼe chu ʼonquil i chac pa ticon re i Dios chi ca wachinic. Niʼpa i chac qui ʼano, n-ca yojtaj ta chic. Xak niʼpa wach i qui tzʼonoj che i Ta chicaj wumal yin, ire cu ya chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Are iri quin bij chiwe chi ʼo u chac qui ʼano: cʼax chi na iwib chiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","We i winak tzel quix quil yix, cha cʼun chi cʼux chi nabe tzel xin quil yin chiwach yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","We tene yix ix queje pacha i winak chi n-quin qui coj ti yin, ique cʼax quix qui na ʼuri man ix que ique; péro yix n-ix ta queje ile. Man, yin xix in cha chiquixol i winak, y ix terejnak chwij, rumal-i i winak tzel quix quilo, man n-ix ta chic que ique. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Cha cʼun chi cʼux wach i tzij in bim chiwe: chi jun ajchac, n-ʼatz tu ʼij chuwach u patron. We quiqui ʼan chʼoʼoj chwe yin, xak queje ile quiqui ʼan chʼoʼoj chiwe yix. We i winak qui cojom in tzij yin, xak quiqui coj ʼuri wach i qui bij yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Ronojel ile quiqui ʼan chiwe xa wumal yin; quiqui ʼan ʼuri man n-quetaʼam tu wach i Jun chi xin takaw lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Ma ta xin cʼun chu bixquil chique i winak-le, n-ti qui mac ʼuri. Péro ʼo qui mac man ya xqui ta wach i xin bij. Rumal ʼuri n-ta caquesaj wi quib chuwach i qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Pachin jun tzel quin ril yin, queʼelok xak tzel cril in Kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Ma ta xin chacuj tak i milágro chiquiwach chi n-ta jun chic winak ca ʼanawic, n-ti qui mac ʼuri. Péro woʼor, ya quilom chic wach i xin ʼano. Tupu quilom chic, tzel quin quilo, xak tzel quiquil in Kajaw. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Xui-ri, queje na ile quiqui ʼano, man ca ʼantaj na pacha i tzʼibtal chupam qui wuj re u tzij i Dios. Man queje iri cu bij: “Xak n-ta usucʼ tzel xin quilo.” (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Xui-ri, are, quin tak li Ucʼanel iwuʼ, chi u Tewal i Dios, ire-le cu bij ni usucʼ chiwe in pachin yin. Man ire chi petnak ruʼ i Ta xui i sak laj tzij cu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Teʼuri, xak queje yix, quiwesaj ni u bixquil in pachin yin, man ix qʼuijinak wuʼ chu xebal in chac. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Xin bij i tzij-i chiwe man n-qui sach tu cubibal i cʼux chwe are quiwil tak iri. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yix qui tij na chi n-quix cʼulax ta chic pa molbalʼib que aj Israel winak. Xak cu rik ni ʼij chi quiqui bij ni winak chi jun utzil chomal quiqui ʼan che i Dios we quix qui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Queje ile quiqui ʼan na, man mi xa ta jubiʼ quetaʼam u wach in Kajaw, xak n-quetaʼam ti in wach yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Xin bij iri chiwe, man we xu rik i ʼor quiwil ile, are ʼuri ca cʼun chi cʼux chi ya in bim chic chiwe. N-xin bij ti iri chiwe are xoj jekan wi lok, man in ʼo chi iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Xui-ri, woʼor quin tzalij chic ruʼ i Ta chi xin takaw lok; quin bisoj man mi jun chiwe cu tzʼonoj chwe pa i quin ʼe wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Rumal i tzij in bim chiwe, xa xoc i bis pi cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Péro yin, sak laj tzij i quin bij chiwe, ʼutz queʼel chiwe yix we xin ʼec. Man yin, we n-quin ʼe taj, n-ca cʼun ta ʼuri i u Tewal i Dios chi quix rucʼaj; xui-ri, we xin ʼec, quin tak li iwuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Ire, we xcʼun chi chuwach i jyub taʼaj, mas i cu sakij na chique i winak (chuwach tak i quin ʼan yin chique, man ire coc cʼa piqui cʼux, xak piqui nojbal). Queje ile, cu ʼalijinsaj na chique i winak chi lic je sachnak chupam i qui mac. Xak cu ʼalijinsaj na chique wach i ʼutz, sucʼulic chuwach i Dios; xak cu ʼalijinsaj na chique chi Dios cu ʼan i ʼatbal tzij piquiwi, wach tak quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","I u Tewal i Dios cu ʼalijinsaj chique chi je sachnak chupam i qui mac man n-que cojon ta chwe yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ire (pin qʼuexel yin), cu ʼalijinsaj wach i ʼutz, sucʼulic chuwach i Dios, man yin quin ʼe ruʼ i Ta chicaj y n-ca ʼiltaj ta chic in wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Cu ʼalijinsaj wach u ʼatic tzij cu ʼan i Dios, man i Dios ya u ʼatom chic tzij puwi itzel, chi ʼo piquiwi i winak waral chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Cʼo u qʼuial tzij cwaj quin bij chiwe, péro n-quin bij taj, man n-quix tiqui ta chu tayic u be. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Xui-ri, i u Tewal i Dios are aj cʼutunel re i sak laj tzij. Are ca cʼun ire iwuʼ, cu ʼalijinsaj chiwe ronojel i sak laj tzij. Man ire, niʼpa i cu bij, nu nojbal ti ire, man ʼis are cu bij niʼpa i ca bix che. Xak cu bij chiwe wach i ca ʼani na coʼon panok. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Ire cu coj ni in ʼij yin, man cu ʼalijinsaj na chiwe wach cwaj u bixquil yin chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ronojel i ʼo ruʼ i Ta chicaj, xak we yin; rumal-i xin bij chiwe chi u Tewal i Dios cu ʼalijinsaj na chiwe wach i cwaj yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Xa ruʼ jubiʼ chic n-quiwil ta chic in wach, péro jubiʼ panok, quiwil tan chic in wach, man ruʼ i Ta chicaj quin ʼe wi —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Are ʼuri ʼo jujun chique u tijoxelab xqui tzʼonoj chiquiwach, xqui bij: —¿Wach usucʼ ile xu bij? “Xa ruʼ jubiʼ chic n-quiwil ta chic in wach, péro jubiʼ panok, quiwil tan chic in wach, man ruʼ i Ta chicaj quin ʼe wi,” xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","¿Wach craj u bixquil ile chake chi “jubiʼ panok” xu bij? N-caka ta tu be wach craj cu bij chake —xqui bij chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","I Jesus xril u be chi ʼo cacaj quiqui tzʼonoj che; are ʼuri xu bij chique: —Are i tzij xin bij chiwe, “Xa ruʼ jubiʼ chic n-quiwil ta chic in wach, péro jubiʼ panok, quiwil tan chic in wach,” ¿are i tzij-le chi qui tzucuj usucʼ chiwach? ");
INSERT INTO acr_acc_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Sak laj tzij i quin bij chiwe: yix qui tij na quix bisonic, xak qui tij ni oʼej; xui-ri i winak re u wach i jyub taʼaj xa que quicotic. Péro yix, we qui tij na quix bisonic, coʼon panok ca pactaj i bis-le, teʼuri quix quicot tan chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Queje qui ʼano, pacha jun ixok ca bisonic are cu rik i ʼor ca qʼuiji jun racʼal, man retaʼam cu tij ni cʼax. Xui-ri we ya xqʼuiji i acʼal, teʼuri ca quicot tan chic, xak n-ca cʼun ta chic chu cʼux wach i cʼax xu tijo; ca quicot ʼut rumal i ral acʼal chi xalaxic. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Queje ile yix woʼor, quix bisonic, xui-ri cakil tan chic kib, teʼuri lic quix quicot tan chic. I quicotemal-le, n-ta jun ca majaw chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","We xu rik i ʼij-le, ya n-ta chic u chac qui tzʼonoj chwe wach usucʼ in tzij in bim chiwe. Sak laj tzij i quin bij chiwe: i Ta chicaj, wach i qui tzʼonoj che pin bi yin, cu ya na chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Cʼa are ʼo wi woʼor, n-ta i tzʼonom che pin bi yin; woʼor chi tzʼonoj ʼut, y ca yataj na chiwe, man mas quix quicot na rumal. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Niʼpa in cʼutum chiwe, in junamsam ruʼ wach tak iwetaʼam u wach waral chuwach i jyub taʼaj. Xui-ri, cu rik ni ʼij n-ta chic u chac quin junamsaj in cʼutunic chiwe ruʼ wach tak iwetaʼam u wach; lic sakil chic quin lap i Ta chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","We xu rik i ʼij-le, are chic yix qui tzʼonoj che i Dios, man queje ile quin ya piʼab qui ʼano. N-ta chic u chac chi yin quin tzʼonoj che i Ta pi qʼuexel yix, ");
INSERT INTO acr_acc_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","man xak i Ta cʼax quix u naʼo. Cʼax quix u naʼo man yix cʼax quin i na yin, xak xi cojo chi yin in petnak ruʼ i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Xwoʼtaj can i Ta man xin cʼun waral chuwach i jyub taʼaj; xui-ri, woʼor cwoʼtaj can u wach i jyub taʼaj, y quin tzalij chic ruʼ i Ta chicaj —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Teʼuri xqui bij u tijoxelab che: —Bay, woʼor lic sakil cat tijin chu bixquil; ya n-ca junamsaj ta chic a tzij ruʼ wach tak i ʼo waral chi ketaʼam u wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Woʼor, xketamaj chi yet, ronojel ʼis awetaʼam. Yet awetaʼam chic wach cakaj caka tzʼonoj chawe are cʼa maja caka bij, rumal-i, n-tu chac we ʼo jun cu tzʼonoj chawe. Rumal ile, ketaʼam chi at petnak ruʼ i Dios —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","I Jesus xu bij chique: —¿Lic i cojom woʼor? ");
INSERT INTO acr_acc_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Ya cu rik i ʼij, y are chic i ʼij iri, iwonojel yix ca quichtaj nubi i wach, chi jujunal. Quin i canaj can intuquel. Xui-ri, n-intuquel taj quin canajic, man i Ta chicaj ʼo wuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ronojel iri quin bij chiwe, man cwaj cuxlan i cʼux wumal yin. Yix, waral chuwach i jyub taʼaj, qui tij ni cʼax; xui-ri chi cowij i cʼux, man yix ix ʼo pin ʼab yin, y yin in tiquinak che u choʼab niʼpa i n-ʼus taj chi ʼo chuwach i jyub taʼaj —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","I Jesus, are xu qʼuis u bixquil ile chique, are ʼuri xtaken ʼan chicaj; queje iri xu bij: —Ta, ya xu rik i ʼor. Cha ʼalijinsaj chique i winak wach i nim laj u ʼij Awacʼal. Xak queje ile, yin chi in Awacʼal, quin ʼalijinsaj wach i nim laj a ʼij yet. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","A yom i ʼatbal tzij pinʼab piquiwi conojel i winak. Queje ile a ʼanom man quin yabej-re i cʼaslemal chique niʼpa i je a yom chwe; are i cʼaslemal chi n-ca qʼuis ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Are usucʼ i cʼaslemal-le are iri: are i retamaxic a wach yet, chi xui yet at sakil Dios, xak i retamaxic u wach i Jesucrísto chi a takom li yet. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Yin in cojom a ʼij waral chuwach i jyub taʼaj, xak ya xin qʼuis i chac chi xin a tak chu ʼonquil. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Woʼor, Ta, cha ʼana nim in ʼij chwe, chila awuʼ, pacha u nimal in ʼij are in ʼo awuʼ chu xebal ʼij sak, are maja ʼo u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Are i xe a cha yet chiquixol i winak, y xe a ya pinʼab, in cʼutum chique at pachin yet. Lic chu xebal lok je awe yet, y yet xat ʼanaw chique chi quiqui cuba qui cʼux chwe yin, y je we yin; xak je cojon-nak che a tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Woʼor quetaʼam chic chi niʼpa i xa ya chwe, awuʼ yet petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Man, i tzij chi xa bij yet chwe, yin in bim chique, xak ique xqui cʼam i tzij-le pa qui cʼux. Xquetamaj ʼut chi lic katzij, awuʼ yet in petnak wi; xak xqui cojo chi yet xin a tak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Woʼor quin tzʼonoj chawe, che a to ique; n-are ta quin tzʼonoj piquiwi i winak chi toʼ je re u wach i jyub taʼaj. Are, quin tzʼonoj piquiwi ique chi xe a ya pinʼab, man je awe yet. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Niʼpa tak i we yin, xak awe yet; niʼpa tak i awe yet, xak we yin. Ique quiqui ʼalijinsaj in ʼij yin (xak quiqui ʼalijinsaj a ʼij yet). ");
INSERT INTO acr_acc_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Woʼor quin upon awuʼ, n-quin canaj ta waral chuwach i jyub taʼaj; xui ique que canaj chuwach i jyub taʼaj. Loʼlaj in Kajaw, quin tzʼonoj chawe chi che a chajij ruʼ a choʼab conojel niʼpa i xe a ya chwe. Yin awuʼ, xak jun ka wach; cwaj yin xak queje ique, xak jun qui wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Tzʼakat xin qʼuiji cuʼ ique chuwach i jyub taʼaj, xe wucʼaj rumal a choʼab yet. Niʼpa i xe a ya pinʼab, xe in chajij. Rumal-i n-ta jun chique xtzak puʼab itzel, xui xtzak i jun chique, chi bital ujer chi ca tzakic, man queʼelok pacha i tzʼibtal can cumal i ajbil a tzij ujer. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Yin ya quin upon awuʼ chila pa at ʼo wi, péro quin bij i tzij-i, quiqui tabej-re ique tzʼakat in ʼo chuwach i jyub taʼaj. Man cwaj yin ʼo na qui quicotemal pacha i quicotemal quin na yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Yin in bim a tzij chique, y xqui cojo. I winak chi toʼ je re u wach i jyub taʼaj, tzel que quilo man ne te cachiʼil chic ique, pacha yin, chi n-in ta cachiʼil i winak chi toʼ je re u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Yin, n-are ta quin tzʼonoj chawe chi que awesaj chuwach i jyub taʼaj; xa are quin tzʼonoj chawe chi que a to chuwach itzel. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Queje pacha in ʼanom yin, n-in ta re u wach i jyub taʼaj, xak queje qui ʼanom ique ne te re u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Cha ʼana chique chi lic je awe yet rumal i sak laj tzij chi quiqui ta. Are i a tzij yet are i sak laj tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Pacha i xa ʼan yet chwe yin, xin a tak li chi, chiquixol i winak chuwach i jyub taʼaj, xak queje quin ʼan yin chique ique, que in tak bi chiquixol i winak chuwach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Yin, cumal ique, quin jach in cʼaslemal pa ʼab, man xak ique queʼelok lic je awe yet, rumal i sak laj tzij chi ca pe awuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","N-xui ta piquiwi ique quin tzʼonoj iri chawe; xak quin tzʼonoj chawe piquiwi niʼpa i quiqui cuba ni qui cʼux chwe coʼon panok, are quiqui ta ni qui tzij ique-ri. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Quin tzʼonoj chawe, Ta, chi conojel ique xak junam ni qui wach. Xak quin tzʼonoj chawe chi ique, junam ni qui wach kuʼ yoj, pacha yet wuʼ yin, xak jun ka wach awuʼ yet. Queje ile, i winak chuwach i jyub taʼaj quiqui coj na chi yet xin a tak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","I a ʼij a chomal chi a yom yet chwe, xak in yom yin chique ique. Queje ile xin ʼan chique man cwaj yin xak jun qui wach, pacha ka ʼanom yoj awuʼ, xak jun ka wach. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Yin in ʼo na chique ique, pacha yet at ʼo chwe yin; queje ile queʼel ni ique lic xak jun qui wach, man ʼutz quiquil i winak chuwach i jyub taʼaj chi yet xin a tak lok, xak quiquilo chi cʼax que a naʼo pacha ca ʼan chwe yin, cʼax quin a naʼo. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Ta, yet xe a ya chwe; cwaj yin que qʼuiji na wuʼ chila pa i quin qʼuiji wi yin; man ʼutz quiquil in chomal a yom chwe. I chomal-le a yom chwe man cʼax xin a naʼo chu xebal ʼij sak, are maja ʼo i u wach i jyub taʼaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Yet Ta, chi lic sucʼul i ca ʼano, i winak chuwach i jyub taʼaj n-quetaʼam ti a wach, péro yin lic wetaʼam a wach; i achiab-i (chi je a yom chwe) quetaʼam chic chi yet xin a tak lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Xin cʼut chique at pachin yet; xak n-quin mayij tu bixquil at pachin yet, man cwaj yin, pacha i cʼaxnabal we xa ʼano, xak ʼo chique ique, xak yin in ʼo na chique ique —xu bij i Jesus che i Ta chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","I Jesus, are xrelej u tzʼonoxic che i Dios, are ʼuri xe ʼax cuʼ u tijoxelab chʼakap che jun u be ya, Cedron u bi. Chila chʼakap, ʼo jun lugar chom, ticom cheʼ che. Chila xoc wi cuʼ u tijoxelab. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","I lugar-le, xak retaʼam i ma Júdas, man i Jesus ʼax que upon wi chila cuʼ u tijoxelab. (Are i ma Júdas-le, are ca jachaw i Jesus piquiʼab i je aj chʼoʼoj chirij.) ");
INSERT INTO acr_acc_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Are je ʼo chila, i ma Júdas xupon cuʼ, je rucʼam bi u qʼuial soldádo, xak juban policía chi aj patanib re i rachoch i Dios. Je takom bi cumal i ajwab sacerdóte, xak cumal i aj Fariséo. Ique qui yijbam bi quib, cucʼam bi qui chʼichʼ, xak i qui ʼaʼ tzam cheʼ, y tak i lámpara, ʼilbal-re qui be pa ʼekum. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","I Jesus retaʼam chic ronojel wach i quiqui ʼan na che. Xe u cʼulaj panok y xu tzʼonoj chique: —¿Pachin i qui tzucuj? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","—Caka tzucuj i ma Jesus aj Nazaret —xe cha che. —Are yin i qui bij —xu bij i Jesus chique. I ma Júdas, chi ca jachaw i Jesus piqui ʼab i aj chʼoʼoj chirij, tacʼal cuʼ i soldádo. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","I Jesus are xu bij: “Are yin”, ique xe tzalij chiquij, y xe tzak pulew. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","I Jesus xu tzʼonoj chic chique: —¿Pachin i qui tzucuj? Ique xqui bij chic: —Caka tzucuj i ma Jesus, aj Nazaret —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","I Jesus xu bij chic chique: —Ya xin bij chiwe chi are yin. We yin i quin i tzucuj, chi ya bi chique i wachiʼil que ʼec —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Queje xqui ʼan ile, man ca ʼantaj na pacha u bim i Jesus. Ire u bim: “Ta, n-ta jun xin sach chique niʼpa i xa ya chwe,” u bim na. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","I ma Simon Pédro ʼo jun chʼichʼ rucʼam; xresaj li pa rachoch y xu coj che jun takon re i ʼatz laj sacerdóte, y xresaj u xiquin wikabim. I achi-le, ma Málco u bi. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Are ʼuri i Jesus xu bij che i ma Pédro: —Cha cʼolo i a chʼichʼ pa rachoch. ¿Xataba n-quin icʼaw ta chupam i cʼax-i pacha craj in Kajaw? Quin ʼan na —xu bij i Jesus che. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Teʼuri, niʼpa u qʼuial soldádo ruʼ i cajʼatzil, xak i policía que i nimak tak aj Israel winak, xqui chap i Jesus y xqui ximo. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Teʼuri xqui cʼam bi chi rachoch i ma Anas. I ma Anas-le, are u kajaw u jiʼ i ma Caifas chi ʼatz laj sacerdóte che i junab-le. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I ma Caifas-le are i yawnak i nojbal chique i rachiʼil, chi mas ʼutz chique ique we xa jun achi ca camsax pa qui qʼuexel conojel i winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","I ma Simon Pédro, tak i jun chic tijoxel, xe terej bi chirij i Jesus. I tijoxel jun-le chi rachiʼil i ma Pédro, ʼetamam u wach rumal i ʼatz laj sacerdóte. Ire xoc bi ruʼ i Jesus cʼa chuwaja. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Péro i ma Pédro xcanaj can che u chibe, pa ocbal bic. Rumal-i, xel li jun, chi ʼetamam u wach rumal i ʼatz laj sacerdóte, y xu tzʼonoj pawor che i ali, chi chajal re i ocbal bic, chi coc bi i ma Pédro. Teʼuri xu cʼam bi i ma Pédro chuwaja. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Are ʼuri i ali xu bij che i ma Pédro: —¿Xak at jun yet chique i u tijoxelab i achi-le? —coʼono. —No, n-in ta cachiʼil —xu bij i ma Pédro che. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","I ajchaquib je ʼo chila, tak i policía, xqui nucʼ ʼaʼ chuwaja man joron tew y xe taqʼui chu chiʼ, quiqui miʼsaj quib. Xak i ma Pédro xtaqʼui pan cuʼ, cu miʼsaj rib chi ʼaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Teʼuri, i ʼatz laj sacerdóte xoc chu tzʼonoxic che i Jesus chiquij u tijoxelab, xak xu tzʼonoj che wach usucʼ u cʼutunic ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","I Jesus xu bij che: —Yin sakil in chʼaʼatnak chiquiwach conojel i winak; sakil in cʼutum pa tak molbalʼib, xak pa rachoch i Dios, pa quiqui mol wi quib i aj Israel winak. Queje ile in ʼanom, n-ta in chʼukum u wach chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","¿Wuchac ca tzʼonoj chwe yin? Cha tzʼonoj chique i je tawnak in tzij; chiqui bij ique wach in cʼutum chique. Ique quetaʼam wach in bim yin —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Are xu bij i Jesus ile, ʼo jun chique i policía ʼo chi, xu chʼay che u palaj y xu bij che: —¿Queje u laʼic u wach ile ca ʼan che i ʼatz laj sacerdóte? ");
INSERT INTO acr_acc_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","I Jesus xu bij che i policía: —We n-ʼus ti xin bij, cha bij wach i n-ʼus taj xin bij. We xi ʼutz i xin bij, ¿wuchac xin a chʼayo? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Teʼuri i mam Anas xu tak bi i Jesus ruʼ i ma Caifas, chi ʼatz laj sacerdóte; ximtalic xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Are que tijin ile chu ʼonquil, i ma Pédro cʼa tacʼal chu miʼsaxic rib chi ʼaʼ. Are ʼuri xqui bij che: —¿Xak at jun yet chique i u tijoxelab i achi-le? I ma Pédro xruwaj u wach; xu bij: —No, n-in ta cachiʼil —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Péro ʼo jun chique ajchaquib re i ʼatz laj sacerdóte, ire rachalal i jun chi xelsax u xiquin rumal i ma Pédro. Ire xu bij che: —¿N-xwil ta bawa a wach yet, xe tak cheʼ ruʼ ire? Xwilo pues. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","I ma Pédro xruwaj julaj chic, y juntir xchʼaw i acʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Are ya ca pe u sakiric, are ʼuri xquesaj i Jesus chi rachoch i ma Caifas, y xqui cʼam bi pa nim laj rachoch i gobernador. Are xe upon chila, i aj Israel n-xe oc tubi pa ja, man i gobernador n-aj Israel taj. We xe oc bic, queʼelok xa que rawasix rumal i ja; n-ta que ʼuri che i waʼim re qui nimaʼij páscua. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Rumal-i, i ma Piláto, chi gobernador-le, xel li chiquiwach, chu tayic wach cacaj. Xu tzʼonoj chique: —¿Wach xu macuj i achi-ri chiwe? —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ique xqui bij: —We tene n-ti u mac i achi-ri, n-queje tene caka cʼam li ri chawe —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","I ma Piláto xu laʼ u wach chique: —Chi cʼama bi yix; chi ʼana che wach i ʼatbal tzij yix —xu bij. I nimak tak aj Israel winak xqui bij che: —Péro yoj chi oj aj Israel winak, n-ta ʼatbal tzij pakaʼab we caka camsaj jun winak —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Queje ile xa ʼani che, pacha u bim i Jesus chique oʼonom lok, wach i camic ca ʼani che. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","I ma Piláto xoc chu bi pa ja, teʼuri xu siqʼuij i Jesus ruʼ; are ʼuri xu tzʼonoj che: —¿Yet at ʼAtol Tzij que i aj Israel winak? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","I Jesus xu bij che i ma Piláto: —¿A nojbal yet, wach i ca tzʼonoj chwe-le? ¿O xa bital chawe rumal jun chic? —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","I ma Piláto xu bij che i Jesus: —¿Xataba in aj Israel winak yin? ¿Wach retamaxic ile quin ʼano? Are i xat qui jach pinʼab, are awach aj tinimit junam cuʼ i ajwab sacerdóte. ¿Wach a ʼanom? (¿At ʼAtol Tzij que, a bim yet?) —xu tzʼonoj che. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","I Jesus xu bij che: —I ʼatbal tzij we yin n-aj chi taj chuwach i jyub taʼaj. We tene aj chi chuwach i jyub taʼaj, niʼpa i que terej chwij xin qui to tene-ri chu ʼonquil i chʼoʼoj, chi n-quin jachtaj ta piquiʼab i cajʼatzil i aj Israel. Péro n-queje ti ile, man in ʼatbal tzij n-aj chi taj —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","I ma Piláto xu bij tan chic: —¿Katzij ba-ri chi at ʼatol tzij? —coʼono. I Jesus xu bij che: —Katzij, in ʼatol tzij pacha i xa bij; rumal-i xin alaxic, rumal-i xin cʼun chuwach i jyub taʼaj. Xol in bij wach i sak laj tzij; niʼpa i je re i sak laj tzij quiqui ta usucʼ ʼuri wach i quin bij —xu bij i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","I ma Piláto xu bij: —¿Wach i sak laj tzij? —xcha. Are xu bij ile, i ma Piláto xel chal ucamul cuʼ i aj Israel winak. Xu bij chique: —N-tu mac i achi-ri quin rik yin. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Yix iwetaʼam chi ʼax quin ʼan wi, are ca cʼun i nimaʼij re i páscua, ʼo junok chique i aj prexil cwoʼtaj bi chiwe. ¿Quiwaj ʼut cwoʼtaj bi i ʼAtol Tzij iwe yix, ix aj Israel winak? —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Teʼuri, xe siqʼuin chu bixquil conojel: —¡Mawoʼtaj bi ire-le! ¡Are, chawoʼtaj bi ma Barabas! —xqui bij. I ma Barabas quiqui bij-le are jun iliʼom. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Are ʼuri i ma Piláto xu tak u chʼayic i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","I soldádo xqui yijba jun sotosic qʼuix y xqui coj che u jolom i Jesus. Xqui coj jun u ʼuʼ cakcoj pacha i qui ʼuʼ i nimak tak ʼatol tzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Teʼuri xe oc chu yoʼyaxic; xqui bij: —¡Naj u ʼij i ʼAtol Tzij que i aj Israel! —xe cha. Are ʼuri quiqui chʼay che u palaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Teʼuri i ma Piláto xel chal julaj chic. Xu bij chique i winak: —Chiwila, cwesaj chal chiwach, quiwil-bej-re chi yin n-tu mac quin riko. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Are ʼuri xel li Jesus pa ʼatbal tzij re i ma Piláto. Cʼo i sotosic qʼuix che u jolom; xak cʼo i u ʼuʼ cakcoj chirij. I ma Piláto xu bij chique: —¡Ri i achi-ri! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","I ajwab sacerdóte, tak i policía re i rachoch i Dios, are xquil u wach i Jesus, xe siqʼuin chu bixquil: —¡Cha camsaj chuwach cruz! ¡Cha camsaj chuwach cruz! —xe cha. I ma Piláto xu bij chique: —Chi cʼama bi yix; chi ripa yix chuwach cruz, man yin n-quin rik ta jun u mac —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","I winak xqui bij che: —Yoj chi oj aj Israel winak, ʼo ka ʼatbal tzij tzʼibtalic. I ka ʼatbal tzij-le cu bij chi ʼo u chac caka camsaj, man xu bij chi u Cʼojol i Dios —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","I ma Piláto, are xu ta wach i xqui bij-le, xu xij mas rib rumal. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Are ʼuri xe oc chubi junam pa ʼatbal tzij; teʼuri xu tzʼonoj tan chic che i Jesus: —¿Ipa mer xat pe wi yet? Péro i Jesus n-xu laʼ tu wach che. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Teʼuri i ma Piláto xu bij che: —¿Wuchac n-ca laʼ tu wach chwe yin? ¿N-awetaʼam ta ba-ri, chi yin ʼo pinʼab we cat in rip chuwach cruz, xak ʼo pinʼab we cat woʼtaj bic? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Teʼuri i Jesus xu laʼ u wach che: —N-ta yatal paʼab wach cawaj ca ʼan chwe, ma teji u yom li Dios chawe. Rumal ʼuri, pachin i xin jachaw paʼab, nim u mac ire chawach yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Are ʼuri i ma Piláto xu jek u tzucuxic wach i roʼtaxic bi i Jesus cu ʼano. Péro n-xtiqui ta che man i aj Israel winak xe siqʼuin chu bixquil: —We cawoʼtaj bi i achi-le, xa ca kel ʼuri wach cu bij i ʼatz laj ʼatol tzij pawi yet. I achi-le craj coʼon ʼatol tzij che rib; pachin jun coʼon ʼatol tzij che rib, queʼel ʼuri aj chʼoʼoj chirij i ʼatz laj ʼatol tzij pakawi —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Are xu ta i ma Piláto wach i xqui bij, are ʼuri xresaj li Jesus chi sak, teʼuri xcubi pu cubibal chija pa cu ʼan wi i ʼatbal tzij. (Are i lugar-le, “Gabáta” u bi pa qui chʼawbal i aj Israel winak; queʼelok “lugar ʼo natril che”.) ");
INSERT INTO acr_acc_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Are xu ʼan ile, are i ʼij chuxeʼ i nimaʼij páscua, colo tiqʼuil ʼij xqui ʼano. Are ʼuri i ma Piláto xu bij: —¡Ri i ʼAtol Tzij yix-i; chiwila! —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","I winak xe siqʼuinic: —¡Cha camsaj! ¡Cha camsaj! ¡Cha ripa chuwach cruz! —xe cha. I ma Piláto xu bij chique: —¿ʼUtz bawa quin camsaj chuwach cruz i ʼatol tzij iwe yix? I ajwab sacerdóte xqui laʼ u wach che: —N-ta chic jun ʼo pakawi yoj; xui i ʼatz laj ʼatol tzij pa Róma cu ʼat tzij pakawi —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Are ʼuri, i ma Piláto xu jach i Jesus piquiʼab ique, quiqui camsabej-re chuwach cruz. Teʼuri ique xqui cʼam bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Are xqui cʼam bi i Jesus, ire xrekaj bi u cruz xol u teleb. I jyub pa xe ʼe wi, u bi “u jolom anma” chi queʼel pa qui chʼawbal i aj Hebréo, “Gólgota”. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Are xe uponic, chila xqui rip wi chuwach cruz. Xak je ʼo queb chic xe rip chuwach i qui cruz, jujun pa tak u tzal xe qʼuiji wi che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","I ma Piláto xu tak u tzʼibaxic juban tzʼib puwi u cruz i Jesus; queje iri cu bij i tzʼib: “I Jesus aj Nazaret, ʼAtol Tzij que i aj Israel winak.” Queje ile tzʼibtalic. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Je qʼui i aj Israel winak xcajlaj u wach i tzʼib-le, man xa nakaj che i tinimit Jerusalen pa xqui rip wi i Jesus chuwach cruz. I tzʼib-le tzʼibtalic pa oxib chʼawbal: piqui chʼawbal aj Hebréo, piqui chʼawbal aj Griégo, xak piqui chʼawbal aj Latin. (Queje ile xqui ta conojel wach i tzʼibtalic.) ");
INSERT INTO acr_acc_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Rumal-i i ajwab sacerdóte que i aj Israel winak xqui bij che i ma Piláto: —Ma ta queje ile xa tak u tzʼibaxic chi cu bij: “ʼAtol tzij que i aj Israel winak.” N-queje ti ile craj; ca majawic ca tak u tzʼibaxic queje iri: “Ire xu bij chi ʼAtol Tzij que i i aj Israel winak” —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Teʼuri ma Piláto xu bij chique: —Are i xin tak u tzʼibaxic, n-quin yoj ta chic. (Queje ile xu bij.) ");
INSERT INTO acr_acc_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","I soldádo, are xqui rip i Jesus chuwach i cruz, teʼuri xqui jach u ʼuʼ chiquiwach; xqui ʼan cajib tant che, y xqui jach jujun tant chiquiwach. Xui-ri, ʼo jun che u ʼuʼ, jun chom laj cʼul, naj rakan, n-ta tʼis che. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","I soldádo-le xqui bij chiquiwach: —Maka rakchʼij, ʼutz we caka saquij chakawach, ʼilbal-re pachinok chake ca cʼamaw bic —xe cha. Queje xqui ʼan ile, man ca ʼantaj na pacha i tzʼibtal ujer chupam u wuj i Dios; queje iri cu bij: “Xqui jach in ʼuʼ chiquiwach; xe saquin chirij.” Y queje xqui ʼan i soldádo ile. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ʼO jujun ixokib je ʼo chu nakaj i cruz; je are i u chuch i Jesus, rachiʼil u chaʼ, xak i ixok Mariy chi rixokil i ma Cleófas, xak i ixok Mariy Magdaléna. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","I Jesus are xril u wach u chuch, xak xril u wach u tijoxel chi cʼax cu na ire, tacʼal ruʼ. Are ʼuri xu bij che u chuch: —Nan, cha ʼana che i achi-le pacha awacʼal yet —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Xak xu bij che u tijoxel: —Cha ʼana che in chuch pacha a chuch yet —xu bij che. Are ʼij ʼuri, i tijoxel-le xu cʼam bi u chuch i Jesus ruʼ chi rachoch. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","I Jesus retaʼam chi ya xqʼuisic niʼpa i ʼanic craj. Are ʼuri xu bij: —Quin cʼatic. Queje ile xu ʼano pacha i tzʼibtal ujer chupam u wuj i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ʼO jun xar chila, nojnak che víno, cʼacʼoj ca nawic. Xqui cʼam jun espónja, y xqui mu chupam; teʼuri xqui ya tzam cheʼ, y xqui ya ʼan pu chiʼ. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","I Jesus xu tzʼub bi i víno; teʼuri xu bij: —Ya xa ʼantajic —xcha. Teʼuri xu lucba u jolom, y xel u cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Are xcamsax i Jesus, are jun ʼij chuxeʼ i nimaʼij páscua. I qui nimakil i aj Israel xqui chʼobo chi n-ʼus taj we que canaj i oxib achiab chuwach i qui cruz chucab ʼij, man are i uxlambal ʼij. I uxlambal ʼij-le are qui nimaʼij, lic nim laj ʼij chiquiwach ique. Rumal-i xe ʼe chu tzʼonoxic che i ma Piláto chi cu tak u ʼajsaxic u bakil cakan man weʼ que camic. We queje ile xa ʼani chique, weʼ ʼuri que kajsax lok. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Are ʼuri i soldádo xe uponic; nabe xqui ʼajsaj u bakil rakan jun chique i je ʼo pu tzal i Jesus; teʼuri xak queje xqui ʼan chic che jun chic chi xak ʼo pu tzal i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Are xe upon ruʼ i Jesus, xquilo chi ire ya camnak chic, rumal-i n-xqui ʼajsaj ti u bakil i rakan ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Xui-ri, ʼo jun chique i soldádo, xu toʼij pu cʼalcʼax i Jesus che jun u tzam chʼichʼ. Juntir xjaktajic, xel u quiqʼuel, ruʼ ya. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Y yin chi quin bij iri chiwe, in jun chique i xe ʼilawic; sak laj tzij i quin bij. Quin bij chiwe wach i xwilo man cwaj qui cuba i cʼux che i Jesus. Wetaʼam chi sak laj tzij i quin bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Queje ile xa ʼani che i Jesus (pacha ca ʼani che i chij are ca cʼamsaxic re i páscua), man ca ʼantaj na pacha i tzʼibtal chupam u wuj i Dios ujer. Cu bij: “N-ca ʼajsax ta jun u bakil ire.” ");
INSERT INTO acr_acc_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Xak cu bij u wuj i Dios: “I winak quiquil nu wach i jun chi xqui toʼij.” (Queje ile tzʼibtalic.) ");
INSERT INTO acr_acc_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Are xutzin u ʼonquil ile, are ʼuri i ma Jose aj Arimatéa xu tzʼonoj utzil chomal che i ma Piláto chi ca yaʼ che chi cu cʼam bi u chʼacul i Jesus. I ma Jose-le are jun terejnak chirij u cʼutunic i Jesus, xui-ri aliʼal man cu xij rib chiquiwach i nimak tak aj Israel. I ma Piláto xu ya che; teʼuri i ma Jose xu cʼam bi u chʼacul i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Xak xupon i ma Nicodémo chu toʼic i ma Jose. I ma Nicodémo-le are i jun chi ʼe chʼaʼatnak ruʼ i Jesus chaʼab. Ire xuponic, u cʼamom bi colo jun quintal i cunbal lic muy, queb u wach, mírra ruʼ áloes. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Teʼuri i ma Jose ruʼ ma Nicodémo xqui cʼam u chʼacul i Jesus, xqui pasij pa sawan, y xqui coj i cunbal muy che, man queje xqui ʼan ile i aj Israel winak che i qui camnak are quiqui muku. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Chu nakaj pa xcamsax wi i Jesus chuwach i cruz, ʼo jun ulew, chom i cotzʼij, chom i cheʼ ʼo chuwach. Chila ʼo wi jun abaj worom u pam, mukbal que i camnak. I jul-le cʼacʼ u ʼonquil, cʼa maja ca yaʼ camnak chupam. ");
INSERT INTO acr_acc_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Chila xqui muk wi i Jesus, man xa nakaj ʼo wi, y ya xcʼun i uxlambal ʼij que i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Are xu rik i ʼij domíngo, nabe ʼij re i seman, are ʼuri i ixok Mariy Magdaléna xupon chila pa muktal wi i Jesus, cʼa ʼekum re u sakiric. Are ʼuri xrilo chi ʼelsam chic i abaj chi tzʼapbal re u chiʼ i jul pa xmuk wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Are xril ile, xa ʼe paʼanem chu bixquil che i ma Simon Pédro, xak che i jun chic tijoxel chi cʼax xnaʼ rumal i Jesus. Xu bij chique: —Xelsax bi u chʼacul i Kajwal pa i xmuk wi; n-ketaʼam taj pa xcʼam wi bic —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Teʼuri i ma Pédro, tak i jun chic tijoxel, xe walij la, y xe ʼe pa muktal wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Che queb xe ʼe paʼanem, péro i ma Pédro n-cu chʼij ta ʼanem chuwach i jun; i jun-le nabe xupon chila pa i xmuk wi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Are i nabe xuponic, xwuʼi chu takexic i jul; xui xril i cʼul ʼo chila, xui-ri n-xoc tubic. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Are xupon i ma Simon Pédro chi teren bi chirij i jun, ire xoc bi chupam i jul, xak xrilo chi xui chic i cʼul ʼo chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","Xak xrilo, i cʼul chi ʼo te che u jolom i Jesus, n-xak jun ta chic ʼo wi ruʼ i juban cʼul. U borom chic rib pu wach wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Teʼuri xoc bi i jun chi xupon nabe; xak xrilo wach oʼonom; are ʼuri xu cojo chi Jesus xwalijic. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Cʼa maja quiqui ta u be bien wach i tzʼibtal can chupam u wuj i Dios, chi Jesus ca walij na chiquixol i camnak. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Teʼuri, i queb tijoxelab-le xe tzalij chic chi cachoch. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","I ixok Mariy coʼic, ʼo chi sak pa xmuk wi i Jesus. Ca tijin che oʼej, xwuʼi chu takexic upam i jul. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Are ʼuri xril qui wach queb ángel, sak qui ʼuʼ. Ique je cul chila pa ʼo wi te u chʼacul i Jesus. Jun ʼo chu jolom; i jun chic ʼo chi rakan. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","I ángel-le xqui tzʼonoj che: —Ixok, ¿wuchac cat oʼic? Ixok Mariy xu bij chique: —Man xcʼami bi i Wajwal, y n-wetaʼam taj pa xyaʼ wi. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Are xu bij ile, xtzun pan chirij; are ʼuri xril u wach i Jesus, ʼo chi ruʼ. Xui-ri n-retaʼam taj we are i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Are ʼuri i Jesus xu tzʼonoj che: —¿Ixok, wuchac cat oʼic? ¿Pachin ca tzucuj? —xu bij che. I ixok Mariy xu chʼobo mok are i aj chajinel re i ulew-le. Xu bij che: —Ta, we yet xa cʼam bi u chʼacul i Jesus, cha bij chwe pa i xa ya wi, man yin quin cʼam bic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","I Jesus xu bij che: —¡Al-Mariy! —xcha. Are ʼuri ixok Mariy xu pisquilij rib. —¡Rabóni! —xu bij. (Ile qui chʼawbal i aj Hebréo, chi queʼelok “¡Tijonel!”) ");
INSERT INTO acr_acc_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","I Jesus xu bij che: —Min a chapo, man cʼa maja quin ʼel bi chila pa ʼo wi in Kajaw. Xui-ri, jat cuʼ i watz in chaʼ (chi je in tijoxelab teʼek). Cha bij chique chi quin ʼel bi chicaj ruʼ in Kajaw yin, chi woʼor xak i Kajaw yix; quin ʼe ruʼ in Dios yin, chi xak i Dios yix. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Are ʼuri, ixok Mariy Magdaléna xa ʼe cuʼ u tijoxelab i Jesus. Xu bij chique chi ya xril u wach i Kajwal, xak xu bij chique wach i bital bi che rumal. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Are xoc aʼab re i ʼij domíngo-le, i u tijoxelab i Jesus qui molom quib paja, qui tzʼapim li uchija man quiqui xij quib chique i nimak tak aj Israel winak. Are ʼuri xwinakir i Jesus, y xtaqʼui chiquixol u tijoxelab. Xu bij: —Chuxlan i cʼux —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Xbitaj ile chique, xu cʼut i puʼab chique, tak u cʼalcʼax. Ique xe quicotic are xquil u wach i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Teʼuri, i Jesus xu bij chic chique: —Chuxlan i cʼux. Pacha xu ʼan i Ta chwe yin, xin u tak lok, xak queje quin ʼan yin chiwe yix, quix in tak bic. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Are xu bij ile, xu xutʼij piquiwi u tijoxelab, y xu bij chique: —Quin ya u Tewal i Dios chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Pachinok chique i winak qui cuy qui mac yix, ca cuytaj qui mac ʼuri; xak pachinok chique n-qui cuy ti qui mac yix, xak n-ca cuytaj ti qui mac ʼuri —xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ʼO jun chique i cablajuj tijoxelab, n-ta cuʼ ique are xcʼun i Jesus. Ire are i ma Tomas, chi “a-Yox” que cha che. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Teʼuri i juban tijoxelab xqui bij che: —Ya xkil u wach i Kajwal —xe cha che. Péro i ma Tomas xu bij chique: —N-quin coj taj, cʼa cwil na pa i xoc wi i clawux che u ʼab, xak quin chap na che uwi in ʼab. N-quin coj taj cʼa quin chap na che in ʼab pa ʼo wi i soctajnak che u cʼalcʼax —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Wajxakib ʼij ricʼawic, i tijoxelab qui molom tan chic quib, are ʼuri ʼo i ma Tomas cuʼ. Tupu tzʼapil uchija pa je ʼo wi, xoc i Jesus cuʼ, y xtaqʼui chiquixol. Xu bij tan chic chique: —Chuxlan i cʼux yix —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Juntir, xu bij che i ma Tomas: —Chawilape in ʼab-i, cha cojo ni uwi a ʼab che. Xak cha cojo ni a ʼab che in cʼalcʼax. Ma chʼob yet we n-katzij taj chi xin walijic, xui-ri cha cojo chi in walijnak chic —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Teʼuri i ma Tomas xu bij che i Jesus: —¡At Wajwal! ¡At in Dios! —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","I Jesus xu bij tan chic che: —A-Tomas, xa coj ʼut man xin awilo; xui-ri, mas ʼutz que ique chi quiqui cojo, tupu n-quilom ti in wach —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","I Jesus, qʼui i nimak tak milágro xu ʼan chiquiwach i u tijoxelab chi n-xin tzʼibaj ta chupam i wuj-i. ");
INSERT INTO acr_acc_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Péro niʼpa i xin tzʼibaj, are quiwetambej-re chi i Jesus are i Tolke, chi u Cʼojol i Dios. We qui coj ile, we qui cuba i cʼux che ire, qui chʼac ʼuri i cʼaslemal ruʼ i Dios. Rumal-i, xin tzʼibaj. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Xoʼon panok, i Jesus xu cʼut chic rib chique u tijoxelab chu chiʼ i alagun, Tibérias u bi. Queje iri xu ʼano: ");
INSERT INTO acr_acc_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Chila je ʼo wi jutzobaj u tijoxelab i Jesus, ʼo i ma Simon Pédro, xak i ma Tomas chi “a-Yox” que cha che, xak i ma Natanael aj Cana re Galiléa, xak i queb u cʼojol i mam Zebedéo, tak i queb chic u tijoxelab i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Are ʼuri i ma Simon Pédro xu bij chique i rachiʼil: —Yin quin ʼe pa chapoj car —coʼono. —Xak queje yoj coj ʼe awuʼ —xe cha che. Xe ʼe ʼut, xe ʼan bi chupam jun bárco. Jun aʼab xe chacunic, n-ti xqui riko. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Are ʼut xpe u sakiric, xquil u wach jun achi tacʼal chi ya. Are i Jesus, péro n-quetaʼam taj we are ire. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Are ʼuri xu bij pan chique: —Achiab, ¿n-ta car i rikom? —xcha. Ique xqui bij li che: —Mi xa ta jun. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","—Chi cʼaka i ataraya pu wikabim i bárco; chila qui rik wi —xu bij i Jesus chique. Queje ile xqui ʼano, pacha i xbix chique. Are ʼuri, je qʼui i car xqui chapo, n-quiqui chʼij ta chic relsaxic i ataraya pa ya rumal i ralil. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Are ʼuri i tijoxel chi cʼax ca naʼ rumal i Jesus xu bij che i ma Pédro: —¡Are i Kajwal! I ma Pédro, are xu ta chi are i Kajwal, xu coj-la u ʼuʼ (man resam u ʼuʼ chirij), teʼuri xu cʼak la bi rib chuwi ya. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Colo seténta y cínco xicʼab je ʼo wi che u chiʼ i ya. I juban tijoxelab xqui cʼam bi bárco chu chiʼ i ya, qui jucuquem bi ataraya nojnak u pam. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Are xe kaj pulew, xquil jun ʼaʼ nucʼum chila, ca tijin u bolic jun car puwi, xak ʼo juban caxlanwa chila. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","—Chi cʼama li queb oxib car chi cʼa te xi chapo —xu bij i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","I ma Simon Pédro xa ʼan chupam i bárco y xu juquej bi i ataraya cʼa chuwach ulew. I ataraya, nojnak che nimak tak car; je ʼo jun ciénto ruʼ cincuénta y tres chupam. Laj je qʼui, péro n-xrakchʼij ti ataraya. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","I Jesus xu bij pan chique: —Chix petok, chol i tija i wa —xcha. Mi jun chique u tijoxelab xu cowij u tzʼonoxic che pachin ire, man quetaʼam chi ire are i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Are ʼuri i Jesus xa ʼe pan cuʼ, xu cʼam bi caxlanwa pu ʼab, y xu jach chique; xak queje xu ʼan che i car. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Are uroxmul iri xu cʼut rib i Jesus chique u tijoxelab, che u walijic chiquixol i camnak. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Are xquelej i waʼim, i Jesus xu tzʼonoj che ma Simon Pédro: —A-Simon, chi at u cʼojol i ma Jonas, ¿cʼax quin a naʼo? ¿Mas chuwach i cʼaxnabal qui cʼux ique? —xu bij che. —Katzij, Kajwal; yet awetaʼam chi cat waj —xu bij ma Pédro. I Jesus xu bij che: —Che a tzuku i ral tak in chij —xu bij. (I usucʼ i xu bij-le are iri: “Che a tijoj y che a chajij i je we yin.”) ");
INSERT INTO acr_acc_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","I Jesus xu tzʼonoj chic ucamul che: —A-Simon, chi at u cʼojol i ma Jonas, ¿cʼax quin a naʼo? I ma Pédro xu bij tan chic che: —Katzij, Kajwal; awetaʼam chi cat waj. I Jesus xu bij chic che: —Che a chajij in chij. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","I Jesus xu tzʼonoj chic uroxmul che ma Pédro: —A-Simon, chi at u cʼojol i ma Jonas, ¿quin awaj? I ma Pédro xbisonic are xu ta chi uroxmul ile chi xtzʼonox che: “¿Quin awaj?” Teʼuri xu bij che: —Kajwal, ʼis ronojel awetaʼam. Yet awetaʼam chi lic cat waj —coʼono. I Jesus xu bij che: —Che a tzuku in chij —xcha. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Teʼuri xu bij che; —Katzij iri quin bij chawe: are cʼa at acʼal winak, xa yutʼ a pam che a bant y xat ʼe ʼut pa i xawaj wi ʼenam. We xat rijabic, n-queje ta chic ca ʼan ile, man ca sucʼba ni a ʼab, y jun chic cat ximawic; xak cat u cʼam bic pa n-cawaj ta wi ʼenam. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Queje ile xu bij i Jesus, ʼalijinsabal-re wach i camic quicʼaw wi i ma Pédro. Ruʼ u camic-le, ca ʼalijinsax ni u ʼij i Dios. Teʼuri i Jesus xu bij che: —Chat terej chwij (min awoʼtaj) —xbix che. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","I ma Pédro, are xtzun chirij, xrilo chi teren bi jun chic tijoxel, i jun chi lic cʼax ca naʼ rumal i Jesus. I tijoxel-le are i jun chi xcubi pu tzal i Jesus are xqui ʼan i waʼim re i páscua; are ire chi u bim che i Jesus: “Kajwal, ¿pachinok chake cat u jacho?” ");
INSERT INTO acr_acc_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","I ma Pédro, are xril u wach i tijoxel-le, xu bij che i Jesus: —Kajwal, i jun-i, ¿wach ca ʼani che? ");
INSERT INTO acr_acc_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","I Jesus xu bij che: —We xwaj yin chi ca cʼasi na, cʼa are quin cʼun tan chic, n-ta awe yet che. Xui-ri, yet chat terej chwij —xu bij che i ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Rumal i tzij-le, xoʼon panok, i winak chi qui cubam qui cʼux che i Jesus xqui bij chi i tijoxel-le n-ca cam taj. Péro i Jesus n-xu bij taj we n-ca cam taj. Xui xu bij: “We xwaj yin chi ca cʼasi na cʼa are quin cʼun tan chic, n-ta awe yet che.” (Queje ile u bim.) ");
INSERT INTO acr_acc_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Are yin i tijoxel-le chi quin bij chiwe wach xwilo chi xoʼon i Jesus, xak in tzʼibam chupam i wuj-i. Yoj (chi oj u tijoxelab) ketaʼam chi wach i in tzʼibam, lic katzij. ");
INSERT INTO acr_acc_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Cʼo i xu ʼan i Jesus chi n-tzʼibam ta chupam i wuj-i. We tene xtzʼibax che u jujunal, quin bij yin n-coc ta-ri niʼpa i wuj-le chuwach ronojel i jyub taʼaj. Amen (katzij).");
INSERT INTO acr_acc_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Che i nabe wuj xin tzʼibaj chawe, at nim laj winak mam Teófilo, xin bij ronojel wach tak i xu ʼan i Jesus, xak wach tak i xu cʼut canok. Che i wuj-le xin tzʼibaj niʼpa u ʼanom, are xu jek li u chac, ");
INSERT INTO acr_acc_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","cʼa are xel bi chicaj. Are maja ca ʼe chicaj, xe u pixbaj can i rapostelab chi je u chom lok. Rumal u Tewal i Dios ʼo ruʼ, xu bij can chique wach b chiquikul quiqui ʼan na. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Qʼuialmul u cʼutum rib chique chi ire lic cʼaslic. Cuarénta ʼij u wach, puwi i ʼij chi xcamsax wi, queje ile xu ʼano, quiquilbej-re chi katzij ire cʼaslic; xak xu lap chique wach usucʼ i ʼatbal tzij re i Dios piqui cʼux i winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","I Jesus, are cʼo cuʼ i rapostelab, xu bij can chique chi me ʼel tan chupam i tinimit Jerusalen. Queje iri xu bij chique: —Chiwoyʼej na, cʼa ca cʼun ni Jun chi u bim in Kajaw cu ya na chiwe, pacha xak in bim yin chiwe chi ca cʼunic. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Che tak i ʼij-i, ca kaj na li u Tewal i Dios piwi yix. I ʼetz ma Wan xu kajsaj ya piquiwi i winak, xui-ri i Dios, are i u Tewal ire chi cu kajsaj na li piwi. (Queje xu bij can i Jesus ile chique are maja ca ʼe chicaj.) ");
INSERT INTO acr_acc_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","I apostelab, are cʼa qui molom quib ruʼ i Jesus, xqui tzʼonoj che: —Kajwal, ¿woʼor nawi ca ya na chic chake yoj oj aj Israel, we caka ʼat tan chic tzij puwi i ka jyub pacha i ujer? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","I Jesus xu bij chique: —In Kajaw, ʼis ʼo puʼab ire umpa coʼon tak i ʼanic u chʼobom. N-ti iwe yix che i retamaxic pachique ʼij pachique tiémpo coʼon na ire ile. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Xui-ri, mas ca yaʼ na i choʼab chiwe are ca cʼun ni u Tewal i Dios piwi. Teʼuri qui paxsaj ni rason wach i tom, xak wach iwilom chi in ʼanom yin. Ca paxsax in tzijol pa Jerusalen, xak ronojel i jyub Judéa, xak pa jyub Samária, xak ronojel u wach i jyub taʼaj —xu bij can i Jesus chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Are xbitaj ile chique, tzʼakat que takenic, i Jesus xel bi chicaj. Are ʼuri xsach pa sutzʼ; n-xquil ta chic u wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Are ca tijin u ʼenam, ique que tijin chu takexic chicaj; xak teʼet xe winakir queb achiab cuʼ, sak qui ʼuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","—Achiab aj Galiléa —xqui bij—, ¿wach i qui takej chicaj? I Jesus-i chi xcʼam bi chixol yix ca cʼun tan chic; pacha i xiwilo are xa ʼe chicaj, queje tan chic u cʼunic ile —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Teʼuri i apostelab xe kaj li tzam jyub pa i je ʼo wi, chi Olívos ca bix che, y xe tzalij chic pa Jerusalen. Ile, n-naj taj ʼo wi, colo jun kilómetro u najtil. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Are xe upon pa tinimit, xe oc pa qui posar, xe ʼel bi cʼa pa caleja pa ʼo wi qui qʼuijibal. Are i apostelable je are i ma Pédro, i ma Jacóbo, i ma Wan, i ma Andres, xak i ma Felípe, i ma Tomas, i ma Bartolome, i ma Matéo, xak i ma Jacóbo chi u cʼojol i ma Alféo, xak ʼo i ma Simon (chi jun chique i partído cananísta), xak i ma Júdas chi catz qui chaʼ quib ruʼ i ma Jacóbo. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Ique-le ʼis qui yom quib chu molic quib, quiqui tzʼonoj che i Dios. Pacha ʼax quiqui ʼan wi, quiqui mol quib cuʼ i u chaʼ i Jesus, xak ruʼ ixok Mariy chi u chuch i Jesus, xak cuʼ juban chic ixokib. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Xu rik jun ʼij, xe moltaj colo ciénto véinte creyent. I ma Pédro xtaqʼui ʼan chiquixol y xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","—Ix wachalal, ʼo u chac ca ʼantaj na pacha i tzʼibtal can chupam u wuj i Dios ujer. Rumal u Tewal i Dios, i mam David xu tzʼibaj canok wach tak cu ʼan i ma Júdas coʼon panok, chi aj cʼutul re i be chique i que chapaw bi i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","I ma Júdas kachiʼil teʼek; ʼo te u chac kuʼ yoj. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Are xu cʼayij i Jesus, xu loʼ rulew che i mer chi xu chʼaco rumal u mac chi xu ʼano-le. Xui-ri, chila ire xulcʼatij lok, xu kajbej u jolom, xrakchʼij u pam, y xel li rixcol. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Conojel i aj pa Jerusalen xqui ta rason ile, rumal ʼuri xqui ya pu bi i jyub-le, Acéldama, chi queʼel pa ka chʼawbal: jyub pa xturuw wi i quicʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ʼO u chac ca ʼantaj na pacha i tzʼibtal ujer chupam i wuj, Sálmos u bi; queje iri cu bij: Ca roʼtaj can i rachoch, mi jun ca qʼuiji chic chupam. (Queje ile tzʼibtal canok.) Xak queje iri cu bij: I u patan, chu cʼama chic jun chic. (Queje ile tzʼibtal can ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Rumal-i, ʼo u chac caka tzucuj chic jun chic, xui-ri we kachiʼilam lok che tak i ʼij are ʼo wi i Kajwal Jesus kuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Chi, je ʼo jujun je ʼo kuʼ are xkajsax ya puwi i Jesus rumal i ma Wan, cʼa are xel bi Jesus chicaj. Caka cha jun chique, ca ʼe kuʼ chu bixquil chi Jesus cʼun-nak chic sak chuwach —xu bij i ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Teʼuri, xe qui cha queb; jun ma Matías u bi; jun chic, ma Jose Barsabas chi xak ma Jústo ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Teʼuri xe oc chu tzʼonoxic che i Dios; xqui bij: —Kajwal, yet awetaʼam i kanima konojel. Cha cʼutu chake pachique a chom yet chique i queb-i. ");
INSERT INTO acr_acc_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Cha cʼutu chake pachique cawaj yet ca ʼanaw i patan re apóstol chi roʼtam can i ma Júdas, are xoc ire pu qʼuijibal pacha ca majaw che rumal u mac. (Queje xqui bij ile che i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Are ʼuri xqui ʼan sac piquiwi i queb, y xtzak chirij i ma Matías; teʼuri ire xoc cuʼ ique che i qui patan i julajuj apostelab. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Are xu rik i nimaʼij Pentecostes, conojel i creyent qui molom quib chupam jun ja. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Xak teʼet xqui ta pacha jun nim laj tew coʼ upam, xpe chicaj. Lic xchʼaw chupam i ja pa i je cul wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Are ʼuri xwinakir pacha tak u rep ʼaʼ xjacher bi piquiwi chi qui jujunal. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Teʼuri i u Tewal i Dios xrajawin piquiwi conojel, y xqui jek chʼawic pa qui chʼawbal juban chic winak ne te cach aj tinimit. Are u Tewal i Dios xa ʼanaw chique chi xe tiqui chi chʼawic re i jalajuj tak chʼawbal. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Che i tinimit Jerusalen-le, xak je ʼo aj Israel winak je petnak naj nakaj re u wach i jyub taʼaj. Ique qui yom qui cʼux chu cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Are xqui ta i que chʼokowic, xqui mol la quib. Xsach qui nojbal che, man ʼis xqui ta chi xe tiqui chi chʼawic piqui chʼawbal ique chi qui jujunal. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Xe oc ʼil che; lic xqui bisoj. Xqui bij chiquiwach: —¿Wach u ʼonquil ile? I que chʼaʼatic-i, ʼis je aj Galiléa, ne te kach aj tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Wach u ʼonquil ʼuri chi caka ta chi quiqui rik i ka chʼawbal chaka jujunal yoj? ");
INSERT INTO acr_acc_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ʼIs jalajuj ka chʼawbal chaka jujunal; ʼo jujun chake oj aj Pártia, xak ʼo i je aj Média, ʼo i je aj Elam, ʼo i je aj Mesopotámia, aj Judéa, aj Capadócia, aj Pónto, aj Asia; ");
INSERT INTO acr_acc_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","xak ʼo i je aj Frígia, aj Panfília, aj Egípto, xak ʼo i je aj Africa cʼa naj chuwach pan i Ciréne. Xak ʼo i je cʼun-nak naj cʼa pa Róma; jujun chique je aj Israel chi calaxic pacha yoj, i juban xak je aj Israel, man qui yom qui wach kuʼ, wach u cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Xak je ʼo jujun chi je aj Créta, xak ʼo i je aj Arábia. Lic n-xa ta jun tinimit oj petnak wi, ¿wuchac ʼuri woʼor ʼis caka ta pa ka chʼawbal chaka jujunal, wach i nim laj ʼanic cu ʼan i Dios? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Conojel lic quiqui bisoj, xsach qui nojbal che. —¿Wach usucʼ ile? —xqui bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Xak ʼo jujun que yoʼyanic: —Ile xa je ʼabarelab —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Teʼuri i cablajuj apostelab xe taqʼui ʼanok; i ma Pédro co xchʼaw chiquixol: —Yix chi ix aj Judéa winak, yix chi ix jekel waral Jerusalen, ¡chitape wach usucʼ iri! ¡Chi ta na wach i quin bij chiwe! ");
INSERT INTO acr_acc_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Qui bij yix, i achiab-i je ʼabarelab, péro ne te ʼabarel. Woʼor cʼa weʼ na, maja a las nuéve, ne te ʼabarel ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Are i quix tijin yix chi rilíc woʼor, are i u bim can i mam Joel, chi ajbil u tzij i Dios ujer. Queje iri u bim canok: ");
INSERT INTO acr_acc_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","I Dios cu bij: Are ca cʼun tak i qʼuisbal ʼij, quin tak bi in Tewal piquiwi i winak conojel; teʼuri i miʼal iwalcʼwal quiqui bij na chique i winak wach in tzij yin chique. I alabom chixol yix, quin cʼut na chique piqui wach, wach in chʼobom chi quin ʼan na; xak i rijab chixol, quiquil na pa cachicʼ wach i quin ʼan na. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Che tak i ʼij-le, xak quin tak bi in Tewal piquiwi i je ajchaquib we yin, chi ixokib chi achiab, teʼuri quiqui lap na, niʼpa i quin ʼalijinsaj chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ajsic, chuwach i caj, quin cʼut ni nimak tak ʼil chiwe; Iquem, chuwach i jyub taʼaj, quin ʼalijinsaj ni nimak tak séña chiwe. Quiwil quicʼ, quiwil ʼaʼ, quiwil sib pacha sutzʼ ca bukukic. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","I ʼij ca ʼekumaric; i icʼ coʼon cak pacha quicʼ. Queje ile coʼono chu xeʼel i ʼij re i Kajwal; I ʼij are ca cʼun ire, are jun nim laj ʼij chiquiwach i winak; ");
INSERT INTO acr_acc_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Chupam i ʼij-le pachin cu tzʼonoj che i Kajwal, ca totaj ʼuri. (Queje ile u tzʼibam can i mam Joel ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Achiab ix aj Israel, chi cojo retalil wach quin bij na chiwe: i Jesus aj Nazaret, lic ruʼ i Dios petnak wi; i Dios lic u cʼutum na ile chiwe. Ire, ruʼ u ʼab i Jesus, qʼui i milágro xu ʼano, cʼutbal re u ʼij i Jesus chiwe. Iwetaʼam chic yix ile; lic chiwach yix xu ʼan wi niʼpa tak ile. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Nim i xu ʼano, péro are xjach piʼab, xa xi camsaj. Xjach chiwe pacha u chʼobom i Dios ujer; retaʼam ire wach ca ʼani che. Yix xi chap i Jesus, xi jach piquiʼab itzel tak winak; y xa iwumal yix xqui rip chuwach cruz y xqui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Péro i Dios xu cʼunsaj sak chuwach; xresaj puʼab i camic. I camic, n-ta módo ca canaj i Jesus puʼab. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","I mam David ujer u bim chi Dios cu cʼunsaj sak chuwach i Jesus. Xu tzʼibaj i tzij-i chi pacha are i Jesus ca chʼaʼatic; xu bij: Xwil yin, i Kajwal ʼo wuʼ, pacha ʼax ʼo wi; ʼo pin wikabim man mi jun quin u tzaksaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Rumal ʼuri, in cʼux lic ca quicotic; ruʼ in chiʼ xin bij in quicotemal. N-quin cʼachir taj man we xin camic, yet quin a cʼastaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Yet n-ca canaj ti wanima pa ʼo wi i canima i je camnak; n-ca ya ta che in chʼacul ca jaric, man lic in awe yet, lic in loʼlaj Awacʼal. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","A cʼutum i be chwe re i cʼaslemal sakil; lic nim in quicotemal man at ʼo wuʼ. (Queje ile tzʼibtal can rumal i mam David ujer.) ");
INSERT INTO acr_acc_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ix wachalal, quin sakij na iri chiwe: i tzij chi xu bij i ka mam, mam David, n-re ti ire wach i xu bij. I mam David xcamic, xmukic, n-xwalij taj; cʼa ʼalaj pa muktal wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Xui-ri, ire ajbil u tzij i Dios; xu na pu cʼux wach cu ʼan i Dios coʼon panok. Retaʼam ire chi Dios u bim chi katzij cu ʼan na chi jun chique u muk u xiquin i mam David coc pu qʼuijibal ire; coʼon panok, i Crísto, chi are i Chatal rumal i Dios, coc pu patan chi ʼAtol Tzij pacha ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","I mam David pacha rilom chic wach cu ʼan ni Dios, rumal-i xu bij wach u cʼastajbal i Crísto coʼon panok. Xu bij chi i ranima i Crísto n-ca canaj ta cuʼ i que i camnak, xak i u chʼacul n-ca jar taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Are i Jesus-le chi Dios xu cʼunsaj sak chuwach, y konojel yoj kilom u wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Teʼuri xcʼam bi chicaj pu wikabim i Dios. Are ʼo chic chila, xyaʼ i u Tewal i Dios che rumal u Kajaw, pacha u bim oʼonom lok. Woʼor, niʼpa i quiwil yix waral, niʼpa i qui ta chi, xa rumal i Jesus, chi u takom li u Tewal i Dios kuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","N-are ti ka mam, mam David, xel bi chicaj; are i Jesus xel bi chicaj, man i mam David xu bij: I Kajwal Dios xu bij che i Wajwal: “Chat cul na pin wikabim, ");
INSERT INTO acr_acc_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","cʼa cu rik ni ʼij que in ya na pawakan niʼpa i je aj chʼoʼoj chawij.” (Queje ile xu bij i Dios che i Kajwal Jesus.) ");
INSERT INTO acr_acc_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Rumal ʼuri iwonojel yix chi ix aj Israel winak, chiwetamaj chi lic katzij iri: i Jesus-i chi xi camsaj yix chuwach cruz, i Dios u yom pa Kajwal, xak u yom pa Tolke. (Queje u tzij i ma Pédro ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Are xqui ta ile, lic ca ʼutut pa canima. Xqui tzʼonoj che i ma Pédro xak chique i juban apostelab: —Kachalal, ¿wach caka ʼan ʼut? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","I ma Pédro xu bij chique: —Chi jalwachij u wach i nojbal chuwach i Dios, xak chi ya iwib chu kajsaxic ya piwi, cʼutbal-re chi i yom chic iwib che i Jesucrísto. Te ʼuri i Dios cu cuy na i mac, xak cu tak li u Tewal piwi, chi are u sipon chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Ile, cu ya na chiwe pacha u bim ujer, y n-xui ta chiwe yix cu yaʼo, xak chique i muk i xiquin yix, xak chique i naj je ʼo wi. Conojel niʼpa i que u siqʼuij i Kajwal Dios ruʼ ire, ʼis ʼo que che wach i u sujum —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Queje xu bij i ma Pédro ile chique; xak ʼo juban chic u tzij chique, yabal-re i qui nojbal. Xu bij chique: —Chi jalwachij i cʼaslemal; chix el chiquixol i winak-i chi je sachnak chupam i qui mac —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Xeʼelok, niʼpa i xqui coj u tzij i ma Pédro xqui ya quib chu kajsaxic ya piquiwi. Che i ʼij-le, colo oxib mil winak xqui ya qui wach cuʼ i jutzobaj creyent. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Conojel lic xqui ya quib chu ʼanic pacha i qui cʼutunic i apostelab. Xai ʼan che quib lic je cachiʼil quib; junam qui ʼan qui tzʼonoxic che i Dios; junam xui ʼan qui waʼim ʼij ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Qʼui i nilágro, qʼui i nimak tak ʼanic xqui ʼan i apstelab ruʼ u choʼab i Dios; i winak lic xqubisoj rumal. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Conojel niʼpa xqui cuba qucʼux che i Jesus lic je jutzobaj qui ʼanom che quib; xak junam qui wach puwi ubitak-ue. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ʼOlic quiqui cʼayij i culew xak i pitak-que, tobal-que pachin ʼo rajwaxic chiqe. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ʼIj ʼij quiqui mol quib pa rachoch i Dios, xak xqui tij qui wa junam chi tak cachch. Que quicotic xqui tij qui wa, n-ta jun xoʼon nim che rib. ");
INSERT INTO acr_acc_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Xqui coj u ʼij i Dios yconojel i winak xqui bij chi i creyent je ʼu; laj tak winak. ʼIj ʼij ca tijin qui qʼuiaric iutzobaj creyent man i Kajwal ca tijin chi ui toʼic i winak, ʼelsabal que chupam i quinac. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Xoʼon anok, i ma Pédro i ma Wan xe ʼe pa rahoch i Dios a las tres re u kajbal ʼij, are i ʼr re qui tzʼonbal i aj Israel che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ʼOjun achi chila, clis i rakan chi ralaxic. Ire ʼi ʼij ʼo i que yaw chuwach jun ocbal bic pa achoch i Dios; i ocbal bic-le, “Chom” ca ix che. Chila yatal wi i achi, man cu tzʼonj mer chique i winak are que oc bi pa rachch i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","I ma Pédro, i ma Wan que tijirbi coquic pa rachoch i Dios; i achi clis, are ril qui wach, xu jek u tzʼonoxic mer chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Ique che queb xqui cʼam u takexic i achi. I ma Pédro xu bij che: —Choj a tzupeʼ —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","I clis lic xe u tzu, xroyʼej wach ca yaʼ che. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Are ʼuri i ma Pédro xu bij che: —N-ta mer wuʼ, xui-ri wach i ʼo wuʼ quin ya chawe. Rumal u choʼab i Jesucrísto aj Nazaret, ʼo pinʼab quin bij chawe: ¡chat walijok y chat binok! —xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Teʼuri xu chap pan che u ʼab wikabim y xu walijsaj. Juntir xqʼuiji u choʼab u kul tak rakan i clis. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Xsacʼcanic xel chicaj y xtaqʼui ʼanok, y xu jek binic. Teʼuri xoc bi cuʼ pa rachoch i Dios; ca binic, ca sacʼlin chicaj, ca tijin chu cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Conojel i winak xquilo chi ca binic, y ca tijin chu cʼamwaxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Rumal-i toʼ quiqui bisoj; xe oc ʼil che, wach i ʼantal che i clis. Conojel quetaʼam u wach, chi are ire-le cu tzʼonoj u mer pa ocbal bic che i rachoch i Dios, chi “Chom” ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","I achi chi xutziric, lic n-que roʼtaj ta chic i ma Pédro i ma Wan. Conojel i winak ʼis xe oc ʼil, xak que cʼun paʼanem cuʼ, pa i je ʼo wi. Xe moltaj che uwach ja, chi “Re i mam Salomon” ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","I ma Pédro, are xrilo chi que moltaj i winak, xu bij chique: —Ix achiab aj Israel, ¿wuchac quix oc ʼil? ¿Wuchac xa coj i takej yoj? Mi chʼob yix chi mas ʼo ka choʼab yoj, rumal-i ca bin i clis-le. Mi chʼob yix mas oj ʼutz chiwach yix y xa rumal-i xutzir i achi. N-are taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Are i Dios xcunawic; are i Dios chi xak are qui Dios i katit ka mam, mam Abraham, i mam Isaac, i mam Jacob. Queje xoʼon ire ile, cu nimarsabej re u ʼij i Jesus, chi u Cʼojol. Are i Jesus-le chi xi jach yix puʼab i ʼatbal tzij. Teʼuri, are xraj i ma Piláto croʼtaj te bic, yix n-xiwaj taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","N-xiwaj ti roʼtaxic i achi chi ʼo u ʼij rumal i Dios, i achi chi n-tu mac. Are i xiwaj yix, are coʼtax bi achi chi camsanel. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Queje xi ʼan yix ile; xeʼel na chi xi camsaj i Jun chi ca yaw i ka cʼaslemal. Xui-ri, i Dios xu cʼunsaj sak chuwach; yoj mísmo kilom ile. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Are i Jesus-le xcunaw i achi-ri man lic cul ka cʼux che ire; rumal-i xu cowirsaj i rakan i jun-i. Ya xiwil yix wach u ʼanom che i achi-ri, chi lic iwetaʼam u wach. Are i cubibal ka cʼux che i Jesus are xa ʼanaw che i achi chi xutziric, lic n-ta chic cʼax che, chi xak quix tijin yix chi rilic. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Ix wachalal, wetaʼam chi are xi camsaj i Jesus, n-iwetaʼam ti usucʼ wach i xi ʼano, mi yix, xak mi iwajʼatzil. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Xui-ri, are xi ʼan ile, xeʼelok pacha u bim i Dios ujer. Conojel i ajbil u tzij i Dios qui tzʼibam canok chi i Tolke chatal rumal i Dios cu tij ni cʼax. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Chi jalwachij ʼuri i cʼaslemal; chi jacha iwib puʼab i Dios man cresaj i mac chiwij. Teʼuri i Kajwal Dios cu ya ni uxlanem pi cʼux, ");
INSERT INTO acr_acc_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","man ʼo ni i Jesucrísto iwuʼ; are ire, are i Chatal rumal i Dios oʼonom lok, chi quix resaj chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Woʼor, ʼo u chac chi Jesus ca qʼuiji na chicaj cʼa cu rik ni ʼij chi Dios cu ʼan tan chic cʼacʼ che ronojel i ʼolic. Cu ʼan ire ile pacha u bim chake cumal i je loʼlaj ajbil u tzij ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Por ejémplo, i mam Moises xu bij chique i katit ka mam: “I Kajwal Dios cu tak li jun ajbil u tzij chiwe, chi jun chique i je kach aj tinimit; cu tak na lok pacha xin u tak li yin. Chi cojo retalil che wach cu bij ire chiwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Conojel niʼpa i n-que cojon ta che i ajbil u tzij i Dios-le que ʼelsax bi chiquixol i aj Israel winak y ca sachsax ni qui wach,” u bim i mam Moises. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Conojel i ujer ajbil u tzij i Dios ʼis xak jun i xqui bij wach ca tijin u ʼonquil woʼor. Ca jekan li ruʼ i mam Samuel, conojel ʼis queje qui bim can ile. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ʼO iwe che i ʼutz chi xu bij i Dios ujer cumal i je ajbil u tzij; ʼo iwe che i trat chi xu ʼan i Dios cuʼ i katit ka mam. I Dios xu bij che i ka mam, mam Abraham: “Cumal ni a muk a xiquin yet, quin ya ni ʼutz piquiwi conojel i winak chuwach i jyub taʼaj,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Rumal-i, i Dios are xu cha i u Cʼojol y xu tak li chuwach i jyub taʼaj, nabe xu tak li chiwe yix; xraj ire cu ya ni ʼutz piwi yix xak quix u to man qui mayij i macunic —xu bij i ma Pédro chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","I ma Pédro, i ma Wan, cʼa que tijin chi tzij are xe cʼun li juban winak lic que oywaric. I winak-i je are jujun sacerdóte, xak i cajʼatzil i policía re i rachoch i Dios, xak jujun chique i aj Saducéo. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Ique que oywaric man i ma Pédro i ma Wan que tijin chu cʼutic chique i winak chi i camnak ca cʼun chic sak chiquiwach. Quiqui bij chi ʼetamam ni ile man i Jesus walijnak chic che i camic. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","I policía xe qui chap i ma Pédro i ma Wan y xe qui tzʼapij pa cárcel. Ya xkaj i ʼij, rumal-i cʼa chucab ʼij que ʼelsax-lok, (que yaʼ chuwach i ʼatbal tzij). ");
INSERT INTO acr_acc_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Xui-ri, je qʼui chique i xqui ta i qui tzij i ma Pédro i ma Wan, xqui cuba qui cʼux che i Jesucrísto. Rumal ʼuri xe qʼuiar i creyent, colo je joʼob mil achiab chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Chucab ʼij i cajʼatzil i aj Israel winak xqui mol quib pa tinimit Jerusalen junam cuʼ i nimak tak mamʼib, xak cuʼ i tijonel re i ujer ʼatbal tzij. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Xak xupon i mam Anas chi ʼatz laj sacerdóte, xak i ma Caifas, i ma Wan, i ma Alejándro, xak conojel i cachalal i cajʼatzil i sacerdóte. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Xqui tak qui cʼamic i ma Pédro, i ma Wan. Xe qui tacʼba chiquiwach, y xe oc chu tzʼonoxic chique: —¿Pachin xyaw ile piʼab? ¿Pachin xix takaw chu ʼonquil iri? —xe cha chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","I ma Pédro, lic rumal i u Tewal i Dios ʼo ruʼ, queje iri xu bij chique: —Ix nimak tak kajʼatzil, ix nimak tak mamʼib quin ya rutzil i wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Yix quix tijin chi tacʼalem pa rakan wach u ʼonquil jun utzil chomal ʼantal che jun achi iwab. Qui tzʼonoj chake wach i utziric xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Woʼor caka ʼalijinsaj chiwe. Cakaj caquetamaj conojel i aj Israel winak chi xa rumal u ʼab i Jesucrísto aj Nazaret xutzir i achi-ri chi ʼo chiwach iwonojel; xa rumal i Jesucrísto, yijinak chic u chʼacul. Are i mísmo Jesucrísto chi xi camsaj yix chuwach cruz, chi xak xcʼastax u wach rumal i Dios, are ire ʼanawnak iri. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Chupam u wuj i Dios cu bij: I abaj chi xi xutuj yix ix aj ʼanol ja, are i abaj-le chi xeʼelok mas nim ni u chac. (Queje ile tzʼibtal canok. Are i Jesus are i abaj-le chi xutux canok, xui-ri i Dios u ʼanom che chi nim u patan.) ");
INSERT INTO acr_acc_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Xui i Jesus coj ʼelsaw chupam i ka mac; n-ta chic jun chic chuwach i jyub taʼaj. Xui ire-le yatal puʼab rumal i Dios chi coj u to —xu bij i ma Pédro chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","I nimak tak mamʼib lic xqui bisoj are xquilo chi ma Pédro i ma Wan lic co qui cʼux. Xquil u be chi ne te tijojtalic, n-ti qui patan, toʼ je winak. Teʼuri xquil u be chi je rachiʼil can i Jesus (rumal-i n-quiqui xij ti quib; ʼis quilom niʼpa i xqui bij). ");
INSERT INTO acr_acc_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","N-xui ta la ile, xak i achi chi utzirnak chic, tacʼal chila chiquiwach, rumal-i n-quiqui rik taj wach u laʼic u wach quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Xe qui tak bi i ma Pédro i ma Wan chi sak, teʼuri xe oc chu bixquil chiquiwach wach quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Xqui bij: —¿Wach caka ʼan chique i achiab-le? Conojel i winak waral pa Jerusalen quetaʼam wach i nim laj ʼanic xqui ʼano; n-ta queʼel wi we cakuwaj u wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","¿Wach caka ʼano chi n-ca pax ta rason chiquixol i winak? ʼUtz we que ka xibij; caka bij chique chi miqui lapla chic i Jesus chique i winak. (Queje xqui bij ile chiquiwach.) ");
INSERT INTO acr_acc_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Teʼuri xe qui siqʼuij chic i ma Pédro i ma Wan chiquiwach, y xqui bij chique chi quiqui mayij i u cʼutic u tzij i Jesus, xak miqui lapla chic wach u ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","I ma Pédro i ma Wan xqui bij chique: —Chi bij pe yix pachique i ʼutz chuwach i Dios, ¿we caka ʼan pacha cu bij i Dios, o caka ʼan pacha i qui bij yix? ");
INSERT INTO acr_acc_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Yoj n-caka mayij tu bixquil wach i kilom, wach i ka tom, n-coj tiqui ta che —xqui bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Are ʼuri i aj nucʼbal tʼisbal xe qui coj bi ʼil, xui-ri xe coʼtaj bic. N-xqui ʼan ti ʼatbal tzij chique, man xqui xij quib chique i winak. Conojel i winak que tijin chu cojic u ʼij i Dios rumal i milágro u ʼanom, ");
INSERT INTO acr_acc_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","man i achi, are xutzirsaxic, ya nim chic, mas che i cuarénta junab ʼo che. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","I ma Pédro i ma Wan, are xe oʼtax bic, xe ʼe cuʼ i cachiʼil y xqui bij chique ronojel wach i xqui bij i cajʼatzil i sacerdóte, xak i nimak tak mamʼib. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","I creyent, are xqui ta ique ile, ʼis xe oc chu tzʼonoxic che i Dios. Xqui bij: —Kajwal Dios, are yet xat ʼanaw i jyub taʼaj, xat ʼanaw i caj, xak i mar; xak ronojel niʼpa i ʼo chupam, ʼis yet xat ʼanawic. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Yet xa tak li a Tewal ruʼ i ka mam, mam David ujer, xol u bij a tzij che. Teʼuri i awajchac mam David xu tzʼibaj can i tzij-i: I ne te aj Israel winak, ¿wuchac que chʼujer rumal i coywal? I winak, ¿wuchac quiqui tzucuj tzaksabal re i Kajwal? ");
INSERT INTO acr_acc_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","I je ʼatol tzij re u wach i jyub taʼaj xqui yijba quib; i cajʼatzil i tinimit xqui mol quib quiqui ʼanbej chʼoʼoj chirij i Kajwal Dios, xak chirij i Tolke chatal rumal i Dios. (Queje ile u tzʼibam can i mam David ujer, y queje coj tijin yoj chi rilic woʼor.) ");
INSERT INTO acr_acc_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Katzij i ma Heródes, junam ruʼ i ma Póncio Piláto, xqui mol quib waral pa Jerusalen cuʼ i ne te aj Israel winak, xak cuʼ i je aj Israel. Xqui tzucuj tzaksabal re i loʼlaj Awacʼal Jesus, i Jun chi a yom yet che i loʼlaj u patan. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Are xqui ʼan ique ile, xeʼelok pacha i a nucʼum yet ujer chi ca ʼani na. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Woʼor, Kajwal Dios, chawila chi ique coj qui ʼatij, coj qui coj ʼil. Yoj oj a takon, cha ya ʼuri u cowil ka cʼux chu bixquil a tzij chique i winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Caka tzʼonoj chawe coj a to chi cutzirsaxic iwabib, xak chu ʼonquil i milágro, xak chu ʼonquil i nimak tak ʼanic chiquiwach i winak. Choj a to are caka ʼan tak ile chi yatal chake rumal i loʼlaj Awacʼal Jesucrísto. (Queje ile xqui tzʼonoj che i Dios.) ");
INSERT INTO acr_acc_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Are xe utzin chu tzʼonoxic che i Dios, xsilab i ja pa qui molom wi quib. Are ʼuri, xcʼun i u Tewal i Dios piquiwi conojel; lic xoc pa qui cʼux. Teʼuri co qui cʼux xqui jek u bixquil u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","I u qʼuial creyent, xak jun qui wach xak jun qui nojbal. Mi jun xoʼon xuy che rib puwi ubitak-re. Niʼpa i ubitak-que, ʼis junam ni qui wach puwi. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","I apostelab n-xqui mayij tu paxsaxic i tzij chique i winak chi katzij i Kajwal Jesus walijnak chic che i camic. I qui tzij mas ʼo u choʼab; i Dios, nim i ʼutz xu ya piquiwi conojel. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Mi jun chique xu tij uyej, man niʼpa ʼo qui jyub, niʼpa ʼo cachoch, quiqui cʼayij tobal que i creyent je nibaʼib. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","We xcʼaytajic, quiqui cʼam li mer, y quiqui ya na piquiʼab i apostelab. Teʼuri i apostelab quiqui jacho, chirij wach i rajwaxic chique chi qui jujunal. ");
INSERT INTO acr_acc_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Por ejémplo, ʼo jun chique, ma Jose u bi, queje xu ʼan ire ile. Ire aj Chípre, jun jyub setel chuwi mar; ire jun u muk u xiquin can i mam Lewi. I apostelab xqui ya pu bi: ma Bernabe, chi queʼel pa ka chʼawbal: “aj cubsanel re qui cʼux i winak.” ");
INSERT INTO acr_acc_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I achi-le xu cʼayij jun rulew, xu cʼam li mer, y xu ya chique i apostelab. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Xak ʼo jun chic achi, ma Ananías u bi; i rixokil, ati Safíra u bi. Ique xqui cʼayij jun culew; ");
INSERT INTO acr_acc_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","xui-ri, che i rajil i ulew, i achi ʼo i xu cʼol canok, xak ʼo i xu cʼam li cuʼ i apostelab. Xu ʼano pacha are ronojel xu cʼam lok, xui-ri n-ronojel taj. Xak i rixokil retaʼam wach i xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","I ma Pédro xu bij che: —Ma Ananías, ¿wuchac xa ya che itzel xu yoj a nojbal? ¿Wuchac cawaj ca tʼor i u Tewal i Dios? Yet ʼo i mer a cʼolom canok re i jyub xa cʼayij. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","I ulew, awe yet teʼek. Are xa cʼayij, xak awe yet i mer. ¿Wuchac xa chʼob i tʼoronic-le? Che i Dios xa ʼan wi i mentir, n-are ta chique i winak —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","I ma Ananías, are xu ta ile, xtzak pulew y juntir xcamic. Niʼpa i xqui ta rason ile, lic xqui xij quib. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Teʼuri, xe cʼun juban creyent alabom, xqui yac bi i ma Ananías, xqui pasij y xe ʼe chu mukic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Colo oxib ʼor u ʼonquil iri, xoc chali i rixokil i ma Ananías. N-retaʼam taj wach i xa ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Are ʼuri i ma Pédro xu bij che: —Cha bij chwe, ¿xi cʼayij iwulew pacha i rajil xi bij chake? —coʼono. Are, —xu bij i ixok—. Are pacha i rajil ka bim chiwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","—¿Wuchac xi chʼob yix u ʼanic ile, chi qui cʼam u pam i u Tewal i Kajwal? Ya que tzalij li i xe ʼe chu mukic awachijil; woʼor xak cat qui cʼam chubi yet —xu bij i ma Pédro che i ixok. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Are xbitaj che, juntir xtzak pulew chuwach i ma Pédro, y xcamic. Are xe oc chali i alabom, xqui rik tan chic ixok camnak. Xqui cʼam chubic, xe ʼe chu mukic chu cʼulel i rachijil. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Conojel i creyent, xak niʼpa i xe tawic, lic xqui xij quib che, wach i xa ʼanic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","I apostelab, mas i milágro, mas i nimak tak ʼanic xqui ʼan chiquiwach i winak. Conojel i creyent nic are wi quiqui mol quib pa rachoch i Dios; quiqui mol quib chila che uwach ja chi “re i mam Salomon” ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Xqui bij i winak chi i creyent je ʼutz laj tak winak, xui-ri quiqui xij quib quicachʼilaj quib cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mas ca tijin qui qʼuiaric i creyent; je qʼui achiab, xak je qʼui ixokib xqui cuba qui cʼux che i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","I winak xe qui cʼam bi iwabib chi tak be, xe qui ya can chila chuwi tak qui chʼat, chuwach tak qui pop. Queje ile xqui ʼano man we xicʼaw i ma Pédro, tzʼakat ne u mujbal quicʼaw piquiwi, ruʼ ile que utzir na. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","I tinimit chi nakaj je ʼo wi, je qʼui i winak que qui cʼam li qui iwabib pa Jerusalen; xak que qui cʼam li je chʼujernak cumal itzel tew; conojel xe utzirsax na. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Entónces i ʼatz laj sacerdóte, cuʼ i rachiʼil, chi jutzobaj Saducéo, xpe coywal man mas i winak xe terej chiquij i apostelab. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Rumal-i xe qui chap i apostelab y xe qui min pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Are chaʼab, i Kajwal xu tak li jun ángel, xol u jaka u chiʼ i cárcel, y xe resaj li apostelab. I ángel xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","—Jix pa rachoch i Dios. Chix tacʼal chiquiwach i winak chila, chi ʼalijinsaj chique wach i mer usucʼ i cʼacʼ laj cʼaslemal —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","I apostelab xqui ʼan pacha i xu bij i ángel. Are xsakiric xe ʼe pa rachoch i Dios y xqui jek u cʼutic chique i winak chila. Tzʼakat que tijin ique chu ʼanic ile, i ʼatz laj sacerdóte, junam cuʼ i je rachiʼil, xe qui mol i nimak tak aj Israel pa nucʼbal tʼisbal. (Ique n-quetaʼam taj wach xu ʼan i ángel chaʼab.) Are xe moltajic, teʼuri xqui tak qui cʼamic i apostelab pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","I policía, are xe upon pa cárcel, n-xe qui rik ta chic i apostelab. Rumal-i xe tzalij pa nucʼbal tʼisbal y xqui bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","—Are xoj upon chu chiʼ i cárcel, lic tzʼapilic xka riko; i je chajal re, ʼis je ʼo chu chiʼ. Xui-ri, i chupam, are xka jak bic, n-ta xka riko. (Queje ile xqui bij i policía chique i qui nimakil.) ");
INSERT INTO acr_acc_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","I cajʼatzil i sacerdóte xak i cajʼatzil i policía pa rachoch i Dios, junam cuʼ i ajwab sacerdóte, are xqui ta ile, lic xqui bisoj. Xqui tzʼonoj chiquiwach: —¿Wach nawi ca ʼe qʼuis wi niʼpa iri? —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Are ʼuri xupon jun achi cuʼ; xu bij chique: —I achiab chi xe i tzʼapij, je ʼo pa rachoch i Dios; que tijin chu cʼutic chique i winak chila —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","I cajʼatzil i policía xe u cʼam bi i rakan u ʼab, xe ʼe qui cʼama i apostelab. Xui-ri, n-xe qui yaj taj, n-xe qui chʼay taj, man quiqui xij quib chique i winak, mokxa cocsax abaj chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","I apostelab, are xe cʼam lok, xe tacʼbax chiquiwach i nimak tak aj nucʼbal tʼisbal. Are ʼuri i ʼatz laj sacerdóte xoc chi qui yajic, xu bij chique: ");
INSERT INTO acr_acc_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Yoj lic ka bim chic chiwe chi mi lapla i Jesus-le. Y yix xi kelo. Je i tijojsam chic conojel i winak aj Jerusalen. Xak quiwaj qui ʼabaj u camic i Jesus chikij yoj —que cha chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Teʼuri i ma Pédro cuʼ i juban apostelab xqui bij chique: —Lic ʼo chakakul caka cojo wach cu bij i Dios chake, n-are ta wach quiqui bij i winak chake. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","I Kajwal Dios, chi xqui coj u ʼij i katit ka mam, are ire xcʼunsaw sak chuwach i Jesus. Are i Jesus-le chi xi rip yix chuwach cruz, camsabal-re. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Are i Jesus-le chi Dios xu ya chicaj pu wikabim, cojbal re u ʼij. Xu ʼan che chi Kajʼatzil yoj, xak Tolke, man queje ile ʼo módo chi yoj oj aj Israel caka jalwachij ni ka nojbal chi n-ʼus taj, xak caka rik u cuytajic ka mac. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Yoj waral kilom wach i xa ʼanic; oj ʼo chu bixquil wach i kilom. Xak i u Tewal i Dios cu ʼalijinsaj chi katzij wach coj tijin chu bixquil. I Dios u yom i u Tewal-le chique niʼpa i que cojow u tzij. (Queje i qui tzij i apostelab ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","I achiab chi je ʼo pa nucʼbal tʼisbal, are xqui ta, xpe coywal; cacaj ique que qui camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Xui-ri, ʼo jun achi, mam Gamaliel u bi, xtaqʼui ʼan chiquixol. Ire jun chique i jutzobaj aj Fariséo, jun nim laj cʼutunel re i ujer ʼatbal tzij re i Dios. Ire lic ocsam u ʼij cumal i winak. I mam-le xu bij chi que quesaj bi jubiʼ i apostelab chi sak. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Teʼuri xu jek u bixquil chique i nimak tak mamʼib. Xu bij: —Ix wach aj tinimit, chi ʼana cwent wach qui ʼan chique i achiab-le. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Cha cʼun chi cʼux, maja naj u ʼanic, ʼo jun achi, ma Téudas u bi, ire xoʼon nim che rib. Xe moltaj u qʼuial achiab ruʼ, colo cajib ciénto, xui-ri, ire xcamsax na, y niʼpa i je teren chirij xe quicher bic. Wach tak u nojim, toʼ xsachic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Xoʼon chupan jubiʼ, are ʼij wi chi xe ʼajlax wi i winak, xak ʼo jun achi aj Galiléa chi xe moltaj u qʼuial achiab ruʼ; ire ma Júdas u bi. Xui-ri, xak xcamsax ire, teʼuri i je teren chirij xak xe quicher bic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","I in tzij yin chiwe yix: me i yinya. Chiqui ʼana ni quib. Niʼpa i que tijin chu cʼutic, we xa piqui nojbal winak petnak wi, ca sach ni u wach ʼuri. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","We ruʼ i Dios petnak wi, n-quix tiqui ta ʼuri chu chupic. Chi ʼana cwent, mokxa chirij i Dios quix tijin wi chi chʼoʼoj —coʼon i mam Gamaliel chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Conojel i nimak tak mamʼib ʼutz xqui ta ile. Xe qui siqʼuij ʼuri i apostelab, xqui jic qui loʼxic, y xqui bij chique chi miqul lapla chic i Jesus. Teʼuri xe coʼtaj bic. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","I apostelab, are xe ʼel pa nucʼbal tʼisbal, lic que quicotic, man i Dios u yom utzil chomal chique chi xqui tij ni qʼuix rumal re i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ique n-xqui mayij ti u cʼutic chi Jesus are i Tolke. ʼIj ʼij que tijin chu bixquil pa rachoch i Dios, xak pa cachoch i winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Pa tak ʼij-le, i creyent ca tijin qui qʼuiaric. Je ʼo juban ixokib malcanib chiquixol; ʼij ʼij, i creyent quiqui ya qui wa. Jujun chique i creyent que chʼaw pa qui chʼawbal i aj Griégo, xak ʼo jujun que chʼaw pa qui chʼawbal i aj Israel. I aj Griégo xe oc chu cojic qui mac i aj Israel; xqui bij chi i malcanib aj Israel mas que tzukic, xui-ri, i malcanib aj Griégo xa jubiʼ i qui wa ca yaʼic, que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","I cablajuj apostelab xe qui siqʼuij ʼuri conojel i creyent. Xqui bij chique: —N-ca majaw taj we cakoʼtaj ni u bixquil u tzij i Dios rumal u jachic qui wa i winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Ix kachalal, che i cha ʼuri wukub achiab chixol, chi iwilom yix je ʼutz laj tak achiab. ʼO u chac lic ʼo u Tewal i Dios cuʼ, xak lic ʼo i qui noʼoj. Chi ya ʼuri chique que qui chajij i malcanib-le. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Teʼuri yoj caka ya na kib chu tzʼonoxic che i Dios, xak chu cʼutic u tzij. (Queje ile xqui bij i apostelab.) ");
INSERT INTO acr_acc_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Conojel i creyent ʼutz xqui ta ile. Are ʼuri xqui cha i ma Estéban; ire lic cul u cʼux che i Dios, xak mas ʼo i u Tewal i Dios ruʼ. Xak xqui cha i ma Felípe, i ma Prócoro, i ma Nicanor, xak i ma Timon, i ma Parménas, xak i ma Nicolas chi aj pa tinimit Antioquía. Ire u yom u wach cuʼ i aj Israel wach u cojic u ʼij i Dios quiqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Are xe utzin chi qui chayic i je wukub, xe qui cʼam bi cuʼ i apostelab. Ique xqui tzʼonoj che i Dios piquiwi, xak xqui ya qui ʼab piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","I u tzij i Dios ca tijin u paxic u wach. Pa Jerusalen mas je qʼui i winak xe oc cuʼ i creyent; xak je qʼui i sacerdóte xqui cuba qui cʼux che i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","I ma Estéban lic ʼo u choʼab i Dios ruʼ, lic ʼo utzil chomal i Dios puwi. Rumal-i, mas i milágro, mas i nim laj ʼanic xu ʼan chiquiwach i winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Xui-ri, ʼo juban achiab xe oc chu toʼtaxic chi tzij. Ique je re i molbalʼib que i aj Israel chi “Achiab n-ta chic cajaw” ca bix chique. Ique junam cuʼ i je aj pa tinimit Ciréne, xak i je aj pa tinimit Alejandría, xak i je aj pa Cilícia, xak i je aj pa Asia, ʼis xe oc chu chapic quib chi tzij ruʼ i ma Estéban. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Xui-ri, n-que tiqui ta che i ma Estéban man ire, are ca chʼawic, are i u Tewal i Dios ca yaw u nojbal che. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ique xe qui tzucuj ʼuri juban aj nucʼul tzij chirij i ma Estéban. Xe qui toj na chi quiqui bij: “Yoj xka ta i achi-le cu bij itzel tzij chirij i ka mam, mam Moises, xak chirij i Dios,” que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ruʼ i tzij-le, xe qui chʼujersaj i winak, xe qui petsaj coywal i nimak tak mamʼib, xak i tijonel re i ujer ʼatbal tzij. Xe ʼe chirij i ma Estéban, xqui chapo, y xqui cʼam bi chuwach i nucʼbal tʼisbal. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Xak xe qui coj juban aj tzucul u mac i ma Estéban chi xqui bij: —I achi-ri nic are wi cu bij itzel tzij chirij i loʼlaj rachoch i Dios, xak chirij i ʼatbal tzij tzʼibtal can rumal i mam Moises —que cha—. ");
INSERT INTO acr_acc_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ka tom ni ire cu bij chi Jesus aj Nazaret cu wulijsaj ni rachoch i Dios, xak cu jalwachij ni ka costúmbre chi u yom can i ka mam, mam Moises. (Queje ile xqui bij i aj tzucul tzij.) ");
INSERT INTO acr_acc_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Are ʼuri i nimak tak mamʼib, xak niʼpa i je cul chila, xqui tzu pan i ma Estéban y xquil u palaj pacha u chomal u palaj jun ángel. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","I ʼatz laj sacerdóte xu bij che i ma Estéban: —¿Sak laj tzij ile, niʼpa i xqui bij? —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Ire xu bij: —Nimak tak wachalal, nimak tak mamʼib, chin i ta na peʼ. I ka nim laj Dios, ujer xu cʼut rib che i ka mam, mam Abraham are ʼo pa jyub Mesopotámia. Are xu ʼan i Dios ile, i mam Abraham maja ca ʼe jeki pa jyub Haran. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","I Dios xu bij che: “Cha canaj can a jyub, cha canaj can awachalal, y jat che jun jyub quin cʼut na chawe,” xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Are ʼuri i mam Abraham xel che i jyub Caldéa y xa ʼe jekel chila pa Haran. Xoʼon panok, xcam u kajaw, teʼuri i Dios xu cʼam li mam Abraham y xol jekel chi, pa oj ʼo wi woʼor. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","I Dios n-xu ya ta che i mam Abraham we cu chap ni jyub waral, mi xa ta jubiʼ. Xu bij che chi coʼon panok i jyub-i re ni ire, xak que ni u muk u xiquin. Xui-ri, are xu ta i tzij-le, i mam Abraham n-ta racʼal. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","I Dios, xak xu bij che chi u muk u xiquin que ʼe jekel na che jun tinimit naj, chi n-que taj. Xu bij chi quiqui tij ni uyej piquiʼab i winak chila; i winak-le quiqui ʼan che quib pacha je cajaw piquiwi. Queje ile quiqui tij ni cʼax cajib ciénto junab u wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","“Xui-ri, i tinimit chi que u rajawij, quin ya na pa tojpen,” xu bij i Dios che. “Are que oʼtax a muk a xiquin, que ʼel chila y que pe chi, pa at ʼo wi, y quiqui coj in ʼij waral,” xu bij i Dios che i mam Abraham ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Xak xu bij che chi chu ʼana retal che u chʼacul, ʼilbal-re chi lic re i Dios, xak ʼilbal-re chi Dios cu ʼan na pacha i u bim che. I retal-le, circuncision ca bix che. I mam Abraham, are xalax i racʼal, are ʼo chic wajxakib ʼij che, xak xu ʼan i retal che, pacha u bim i Dios. I racʼal, a-Isaac u bi. Are achi chic i ma Isaac, xak queje xu ʼan ire ile che i racʼal, chi a-Jacob u bi. Are achi chic i ma Jacob-le, xak queje xu ʼan ire ile chique i cablajuj racʼal chi xeʼelok je katit ka mam yoj. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Xoʼon panok, i racʼal i mam Jacob xpe coywal chirij i qui chaʼ, a-Jose, man ire mas cʼax ca naʼ rumal u kajaw. Rumal-i, xqui cʼayij bi i a-Jose che jun aj naj, chi xu cʼam bi ruʼ cʼa pa Egípto. Xui-ri, i Dios ʼo ruʼ i a-Jose, ");
INSERT INTO acr_acc_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","y xresaj chi sak che niʼpa i cʼax xu tijo. Xu ya mas u nojbal i a-Jose, xak xu ʼan che i ʼatol tzij pa Egípto lic cʼax cu na ni a-Jose. I ʼatol tzij, ma Faraon ca bix che, ire xu ya i a-Jose puwi i tinimit, xak piquiwi i je ʼo pa rachoch ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Xoʼon panok, xcʼun jun nim laj waʼjal; xqui tij uyej i winak pa Egípto, xak pa Canaan pa i je ʼo wi u kajaw i ma Jose, xak i ratz u chaʼ. I katit ka mam-le n-xqui rik taj wach quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","I ma Jacob, are xu ta rason chi ʼo ixim chila pa Egípto, xe u tak bi u cʼojol chu tzucuxic. (Ique je are i katit ka mam yoj oj aj Israel winak.) Are i nabe cakan ʼuri pa Egípto. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Xoʼon panok, che ucamul cakan, i ma Jose xu bij chique chi ire are i qui chaʼ. Cʼa teʼuri i ma Faraon xu ta u be chi ma Jose aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Teʼuri i ma Jose xu tak u cʼamic u kajaw, xak niʼpa i rachalal; i rachalal je seténta y cínco chic. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Are u ʼonquil ʼuri xqui ʼan i katit ka mam chi xe ʼe jekel cʼa naj pa tinimit Egípto. Xoʼon panok, xcam i mam Jacob chila, xak queje i ralcʼwal chi je katit ka mam, y xe muk na pa Egípto. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Xoʼon panok xquesaj li qui bakil y xqui cʼam li che i camposant re i ʼetz mam Abraham pa jyub Siquem. Oʼonom lok i mam Abraham u loʼom i jubiʼ jyub-le re u camposant; u loʼom chique i racʼal i ma Hamor chi je aj Siquem. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Xoʼon panok i aj Israel lic xqʼuiar qui wach chila pa Egípto. Lic je qʼui chic are ya cu rik i ʼij chi Dios craj que resaj piquiʼab i aj Egípto, pacha i u bim che i mam Abraham ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Teʼuri xoc chic jun ʼatol tzij piquiwi i aj Egípto chi n-xretamaj tu wach i ʼetz ma Jose. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Ire n-ʼus ti xu ʼan chique i kach aj Israel; lic xu ʼan cʼax chique i katit ka mam. I xu ʼan i ʼatol tzij-le are iri: xu bij chi cacoʼtaj can i cacʼal cʼa je nochʼ, camsabal-que. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Che tak i ʼij-le, xalax i ka mam, mam Moises. Ire, chom xa ʼiltaj rumal i Dios. I u kajaw u chuch xcuwaj oxib icʼ ruʼ ja. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","(Are n-quiqui rik ta chic pa cacuwaj wi, xqui yijba jun ral chicach, xqui ya chupam, y xe ʼe qui ya chuwi ya) teʼuri i u miʼal i ʼatol tzij xu riko. Xu cʼam bic y xu qʼuitsaj; xu ʼan pacha racʼal che. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Rumal ʼuri, i aMoises, pa rachoch i ʼatol tzij xqʼuiy wi; xnawsax che, ronojel niʼpa i quetaʼam i nimak tak aj Egípto winak. Ire, xnimar u choʼab; niʼpa i cu bij, niʼpa i cu ʼano, ʼis ca tiqui che. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Xoʼon panok, are ʼo chic cuarénta junab che, xu chʼob pu cʼux que ʼe rila i rach aj Israel; y xa ʼec. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Chila xril wi jun aj Egípto ca tijin chu ʼanic cʼax che jun aj Israel. Xu to i rach aj Israel y xu camsaj i aj Egípto. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Xu chʼob ire chi niʼpa i rach aj Israel quiqui ta ni u be chi ire are i tolque, chi rumal ire, i Dios que resaj ique pa cʼax piquiʼab i aj Egípto winak. Péro n-xqui ta tu be. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Chucab ʼij, i ma Moises xe u rik chic queb aj Israel winak quiqui ʼan chʼoʼoj chiquiwach. Craj ire quiqui chomaj quib chiquiwach. Rumal-i xu bij chique: “Yix iwachalal iwib. ¿Wuchac ʼuri qui ʼan chʼoʼoj?” xu bij chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","I jun chi u jekom i chʼoʼoj xu tacpuj bi i ma Moises. Xu bij che: “¿Pachin xyaw chawe ca ʼan i ʼatbal tzij pakawi? ¡Mi jun! ");
INSERT INTO acr_acc_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Cawaj quin a camsaj yin pacha xa ʼan che i aj Egípto iwir?” xu bij che. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","I ma Moises, are xu ta ile, xa ʼanmajic; xa ʼe cʼa naj che i jyub Madian; chila xjeki wi, n-mer tu tinimit. Are ʼo chila, xe alax queb racʼal. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","I ma Moises, are ʼo chic cuarénta junab che u jekelem chila pa Madian, ire ca bin che jun taʼaj tzʼinilic chu cʼulel i ral jyub Sinai; xak teʼet xril jun ral cheʼ ca tijin u juluwic, y xwinakir jun ángel chupam i ʼaʼ-le. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Ire lic xoc ʼil che, wach i xrilo. Xtejeb pan jubiʼ ruʼ, crilbej-re wach ropis. Are ʼuri xu ta u chʼawbal i Kajwal chi xu bij che: ");
INSERT INTO acr_acc_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“Yin in Dios que awatit a mam. In qui Dios i mam Abraham, i mam Isaac, i mam Jacob,” coʼono. I ma Moises ca sicsat chic rumal u xibriquil, n-tu cowil u cʼux cu takej. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","I Kajwal xu bij che: “Waral pa at tacʼal wi, ʼo u ʼij; chawesaj ni a xajab. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Yin wilom wach uyej quiqui tij i wacʼal chila pa Egípto; in tom wach oʼej quiqui ʼano. In kajnak lok que ol in to na; que wesaj na chupam i cʼax pa je ʼo wi. Saʼaj wuʼ, cat in tak bi pa Egípto,” xu bij i Dios che i ma Moises. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","I mam Moises-le, chi chatal rumal i Dios, are i jun chi qui xutum i aj Israel winak. Qui bim che: “¿Pachin xyaw chawe at ʼatol tzij ke yoj? ¿Pachin xyaw chawe ca ʼan i ʼatbal tzij pakawi?” qui bim na che. Are ire-le chi chatal rumal i Dios cu ʼat na tzij piquiwi i aj Israel, xak que resaj pa cʼax. I Dios u takom li ángel ruʼ, che i ral cheʼ chi ca juluwic, xol u bij che wach u patan ca yaʼ che rumal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Are i mam Moises-le xe resaj li katit ka mam pa Egípto. Are ire-le xa ʼanaw nimak tak milágro nimak tak ʼanic chila pa Egípto, xak che i mar “Cak”, xak chila pa tak jyub tzʼinilic pa xbin wi cuʼ i katit ka mam cuarénta junab. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Are i mam Moises-le xu bij chique i aj Israel winak: “Dios cu tak na li jun ajbil u tzij chiwe pacha yin, chi are na jun chique i kach aj tinimit. Chi cojo retalil che wach cu bij na ire chiwe.” Queje ile xu bij i mísmo mam Moises ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Are i mam Moises-le ʼo cuʼ i aj Israel winak are qui molom quib che i jyub tzʼinilic. Are ire-le chi xa ʼijlax rumal i ángel che i ral jyub Sinai; are ire-le chi ʼo chila cuʼ i katit ka mam. Che i mam Moises-le, xyaʼ wi i tzij re i ka cʼaslemal, cu yabej-re chake yoj. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","I mam Moises chatal rumal i Dios, xui-ri i katit ka mam n-xcaj ta quiqui cojo. Xcaj ique caquesaj bi che u patan; xcaj ique que tzalij chic pa Egípto. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Are mayal i mam Moises tzam jyub Sinai, ique xqui bij che i mam Aaron; “N-ketaʼam taj wach xa ʼani che i ma Moises-le, chi xoj resaj li Egípto. Mok n-ca cʼun ta chic. Cha ʼana ʼuri juban ka tiox, caka nabsaj bi chakawach,” xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Are ʼuri xqui ʼan jun tiox pacha ral meʼ ca tzunic. Teʼuri xe qui camsaj i chicop quiqui sujuj chuwach. Lic xe quicot ruʼ, wach qui ʼanom ruʼ qui ʼab. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Rumal-i, i Dios xu jecʼ rib cuʼ ique. Xe roʼtaj canok; xu ya chique quiqui coj ni u ʼij i chʼumil aj chuwacaj, pacha cacaj ique. Xu ʼan ire chique pacha tzʼibtal can cumal i ajbil u tzij i Dios ujer. Xu bij i Dios: Ix aj Israel winak, che i cuarénta junab chi xix bin pa tak jyub tzʼinilic, ¿xataba chwe yin xi camsaj wi i chicop? ¿Xataba chinwach yin xi poroj wi, cojbal in ʼij yin? N-chwe taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","N-chwe ti yin xi coj wi in ʼij; xa xiwekaj bi i cárpa re i tiox Moloc. Xak xiwekaj bi u qʼuexwach chʼumil, cojbal na re u ʼij i tiox Renfan. I tiox-le, xa yix ix ʼanawnak man qui coj na qui ʼij. Rumal ʼuri, quix wesaj chuwach i jyub yix; quix in tak bi che jun jyub naj, mas cʼa chuwach pan i Babilónia —xu bij i Dios. (Queje ile tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","I katit ka mam, are xe bin pa jyub tzʼinilic, ʼo qui cárpa pa quiqui cʼol wi i tzʼalam abaj chi ʼo u tzij u pixab i Dios tzʼibtal chuwach. I cárpa-le are i rachoch i Dios cuʼ ique; i mam Moises xu tak u ʼonquil xak jun ruʼ pacha u bim i Dios che. Xu yijba, lic pacha i u qʼuexwach cʼut-tal che rumal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","I cárpa-le, i katit ka mam xqui ya can piquiʼab i qui muk qui xiquin pa tak lemajil. Queje ile xqui ʼan che cʼa xu rik i ʼij xe oc che i jyub yatal chique rumal i Dios. Xqui cʼam li cuʼ are xe oc li chi, junam ruʼ i ma Josue, chi qui capitan. I aj chʼoʼoj cuʼ, i Dios xe roktaj bi chiquiwach, teʼuri xe jeki i katit ka mam chuwach ulew-i. I cárpa-le are i rachoch i Dios cuʼ, cʼa are xoc i ʼatol tzij mam David. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ire-le, xu rik utzil chomal chuwach i Dios chi xak are i Dios re i ka mam, mam Jacob. I mam David-le xu tzʼonoj che i Dios chi cu ya che cu yijba jun mer rachoch i Dios pu qʼuexel i cárpa. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Xui-ri, i Dios n-xu ya ta che we cu yijba; are che u cʼojol xu ya wi, chi ma Salomon. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Queje xoʼon ire ile, xui-ri i Dios, chi ʼAtz u ʼIj, n-jekel ta chupam jun ja ʼantalic. Queje pacha u tzʼibam jun ajbil u tzij i Dios ujer, i Dios u bim i tzij-i: ");
INSERT INTO acr_acc_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","I chicaj are in cubibal pa quin ʼat wi tzij; i u wach ulew are u qʼuijibal i wakan. ¿Wach u ʼonquil ni jun wachoch qui ʼan yix? cu bij i Kajwal. ¿Xataba qui yijba jun in muj in soc pa quin uxlan wi? ");
INSERT INTO acr_acc_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","I abaj, i cheʼ, ronojel niʼpa i ʼolic, ¿xataba n-yin ta in yijbawnak? Yin pues. (Queje u tzij i Dios ile chi tzʼibtal canok.) ");
INSERT INTO acr_acc_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Yix xa ix buy —xu bij i ma Estéban che i ʼatz laj sacerdóte, xak chique i juban aj nucʼbal tʼisbal—, n-quiwaj ta qui ta u be i Dios. Iwanima yix queje pacha i canima i winak chi n-ta Dios cuʼ; xak queje i xiquin. N-quiwaj ti u tayic are ca chʼaw u Tewal i Dios iwuʼ, xak jun ruʼ pacha xqui ʼan iwatit i mam ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Conojel i ujer ajbil u tzij i Dios xqui tij cʼax piquiʼab iwatit i mam. Are xqui bij u cʼunic i Jun chi n-tu mac, ʼis xe qui camsaj. Teʼuri are xcʼun i Jun chi qui bim na ique chi ca cʼun na, ¿wach xi ʼan yix che? Xi jach piquiʼab i tzel que ʼilawic, y xi camsaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Queje xi ʼan yix ile, tupu i Dios xe u tak li u ángel, cu yabej re i loʼlaj u ʼatbal tzij chiwe. Chiwe yix xu ya wi, péro n-quix cojon ta che. (Queje u tzij i ma Estéban ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Ique, are xqui ta ile, lic xpe coywal. Quiqui kachʼachʼej uwaque chirij i ma Estéban, cʼutbal re i coywal che. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ire lic ʼo i u Tewal i Dios ruʼ, xtzun chicaj y xril i nim laj u chomal i Dios ca walchʼinic. Xak xril i Jesus ʼo pu wikabim i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Xu bij: —¡Chiwilapeʼ, cwil upam i caj! Cwil i Achi aj Chicaj ʼo pu wikabim i Dios —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","I nimak tak mamʼib, are xqui ta ile, xe siqʼuinic xqui tzʼapij i qui xiquin y xe ʼe la chirij i ma Estéban. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Xquesaj pa tinimit, y xe oc chu cojic abaj che, camsabal-re quiqui ʼano. Xquesaj i qui chaquet y xqui ya can ruʼ jun achi cʼa ala, a-Sáulo u bi. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Are que tijin chu cojic abaj che, i ma Estéban xu tzʼonoj che i Kajwal: —Kajwal Jesus, cha cʼama i wanima —xu bij. ");
INSERT INTO acr_acc_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Are xu bij ile, xuquiʼic; co xchʼawic: —Kajwal, cha cuyu i qui mac-i —xu bij. Are xbitaj ile rumal, xcamic. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","I a-Sáulo le, junam u wach cuʼ ique chi xe camsaw i ma Estéban. Are xcamsax i ma Estéban, are ʼij wi xjekan i chʼoʼoj chiquij i creyent pa Jerusalen. Conojel i creyent xe quicher bi pa tak tinimit re i jyub Judéa, xak pa tak tinimit re i jyub Samária. Xui i apostelab n-xe ʼanmaj taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Je ʼo jujun achiab qui yom quib chi terejic chirij i Dios. Ique xe ʼe qui muku i ma Estéban. Lic xe oʼ che. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Xui-ri, i a-Sáulo craj cu sach qui wach i jutzobaj creyent pa Jerusalen. Are i xu ʼano, xoc chi tak ja, que u jucuquej li creyent, chi achiab, chi ixokib, y que u tzʼapij pa cárcel. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","I juban creyent chi xe ʼanmaj Jerusalen, xa ipa xe ʼe wi, que tijin chu bixquil chique i winak wach i ʼutz laj tzij re i quelbal chupam i qui mac. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ʼO jun chique, ma Felípe u bi, are xa ʼec, xoc che jun tinimit re i jyub Samária; xu jek u bixquil chique i winak chi Jesucrísto are i Tolque. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","I winak lic xqui mol quib ruʼ, lic xqui ya quib chu tayic u tzij i ma Felípe. Lic xqui coj retalil che wach i xbix chique, xak xquilo niʼpa tak i milágro xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Je qʼui winak xelsax itzel tew chique rumal i ma Felípe. I itzel tew que siqʼuinic xe ʼelic. Xak je qʼui i clis, xak je qʼui i siquirnak xe utzirsaxic. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Rumal ʼuri ʼis que quicot i winak pa tinimit Samária. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Xak pa tinimit-le, ʼo jun achi, ma Simon u bi, chi aj ʼitz. Ire ʼax coʼon wi chi que u tʼor i aj Samária winak ruʼ nimak tak ʼil chi xu ʼano. Lic xu ʼan nim che rib chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Conojel i winak, we ʼo i qui ʼij, o we n-ta qui ʼij, ʼis xqui coj retalil che u tzij i ma Simon. Xqui bij chiquiwach: —I achi-le, mas ʼo u choʼab i Dios ruʼ —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Lic xqui coj retalil che, man ʼo tan chi ʼij je u tʼorom ruʼ i u qʼuial tak ʼanic chi u ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Xui-ri, are xupon i ma Felípe, xqui coj ʼuri wach cu bij ire. Xu sakij chique wach i ʼutz laj tzij chirij i ʼatbal tzij re i Dios, xak chirij i Jesucrísto. Are xqui ta u tzij, je qʼui xqui cojo, xak xqui tzʼonoj u kajsaxic ya piquiwi, chi achiab, chi ixokib. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Xak i ma Simon-le xu cojo y xu tzʼonoj u kajsaxic ya puwi. Teʼuri lic xterej chirij i ma Felípe. Lic xu bisoj are xril i nimak tak ʼanic, i nimak tak milágro xu ʼan i ma Felípe rumal u choʼab i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","I apostelab chi xe canaj can pa Jerusalen xqui ta rason chi ʼo chic i aj Samária que tijin chu cojic u tzij i Dios. Rumal-i xe qui tak bi i ma Pédro i ma Wan chila cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Are xe uponic, xqui tzʼonoj che i Dios chi coc u Tewal piqui cʼux i creyent aj Samária. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Xqui ʼan ile man maja ca cʼun i u Tewal i Dios piquiwi; xui kajsam i ya piquiwi, cʼutbal-re chi je re chic i Kajwal Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Are ʼuri i ma Pédro i ma Wan xqui ya qui ʼab piquiwi i creyent, teʼuri xoc li u Tewal i Dios piqui cʼux. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","I ma Simon, are xrilo chi xoc i u Tewal i Dios pa canima are xqui ya qui ʼab piquiwi, xu sujuj mer chique i apostelab. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Xu bij chique: —Chi ya na chwe yin wach u ʼonquil ile, man pachin jun quin ya in ʼab puwi, xak ca cʼun ni u Tewal i Dios ruʼ —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","I ma Pédro xu laʼ u wach che: —¡Cha porox ni a mer pa ʼaʼ junam awuʼ yet! Xa chʼob yet toʼ ruʼ mer ca loʼ ni u sipon i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Yet n-ta awe che u chac i Dios, mi xa ta jubiʼ; n-awe ti yet u ʼonquil, man awanima n-sucʼul taj chuwach i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Chawoʼtaj i n-ʼus taj-le chi a nojim pa cʼux. Cha tzʼonoj ʼuri che i Dios we cu cuy a mac, wach cat tijin chu chʼobic. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Cwil yin mas at rayinel re u wach i n-awe taj, lic cʼa i a cʼux rumal; lic at ʼo puʼab i mac atzalal —xu bij i ma Pédro che. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Are ʼuri i ma Simon xu bij: —Chi tzʼonoj che i Kajwal pinwi, man n-quin cʼulmaj ti pacha i xi bij yix-le —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Teʼuri i ma Pédro i ma Wan xqui bij chique i aj Samária wach tak quilom ique chi u ʼanom i Kajwal Jesus, xak wach tak u bim canok. Teʼuri xqui maj chali qui be pa Jerusalen. Are que tijin chi be, xqui paxsaj i ʼutz laj tzij re i Jesucrísto chique i winak chupam u qʼuial aldéa re i jyub Samária. Teʼuri xe upon pa Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Xoʼon panok i ma Felípe, ʼo jun ángel re i Kajwal xupon ruʼ y xu bij che: —Cha yijba awib y jat pa sur. Cha maja i be chi queʼel pa Jerusalen, chi ca ʼe kaj cʼa pa tinimit Gáza —coʼono. Are i be ile chi quicʼaw chakij jyub pa n-ta wi winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","I ma Felípe xu yijba rib y xu maj bi u be. Are ca tijin chi be xril pan jun achi aj naj re i jyub Etiopía. Ire-le, nim i u patan, aj chajinel re u mer i ixok chi qui ʼatol tzij i aj Etiopía. I achi-le, xupon chu cojic u ʼij i Dios pa Jerusalen; xutzin u ʼonquil ile, ");
INSERT INTO acr_acc_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ya tzalijic chic re. Ire ca tijin chi be, cul chupam u careta, ca tijin u jeqʼuic cumal caway. Tzʼakat ca binic, crajlaj u wach i wuj u tzʼibam can i mam Isaías, ajbil u tzij i Dios ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Are ʼuri i u Tewal i Dios xu bij che i ma Felípe: —Chat tejeb ruʼ i careta-le y chat bin pu tzal —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","I ma Felípe xa ʼe paʼanem; are xu riko, xu ta i achi crajlaj u wach i wuj chi u tzʼibam can i mam Isaías. Xu tzʼonoj che i achi: —¿Ca ta u be wach i cawil chuwach i wuj? —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","—¿Wach u tayic u be quin ʼano we n-ta jun cu bij usucʼ chwe? —xu bij i achi che. Are ʼuri xu bij che i ma Felípe chi ca ʼan chupam u careta, que cubi junam. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Are u xak wuj chi cu takej, are i pa tzʼibtal wi i tzij-i: Ire xcʼam bi che u camsaxic pacha jun chij. Jun chij, are ca cʼatzix rismal, n-ca chʼaw taj. Xak queje xu ʼan ire ile: n-ti xu bij; n-xu jak ti u chiʼ (are xqui ʼan cʼax che). ");
INSERT INTO acr_acc_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Xkajsax u ʼij; mi jun xu ʼan ʼatbal tzij puwi pacha usucʼ. Ire, mi jun u muk u xiquin xu canaj canok, man i u cʼaslemal xelsax che, waral chuwach i jyub taʼaj. Queje i tzij ile u tzʼibam can i mam Isaías. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","I achi, are xutzin chi rajlaxic u xak i wuj, xu tzʼonoj che i ma Felípe: —Cha ʼana utzil chomal chwe: cha bij chwe, ¿are i tzʼibawnak iri, are ire xu bij rib? ¿O are jun chic xu lapo? —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Are ʼuri i ma Felípe xu jek u bixquil che wach i ʼutz laj tzij re i Jesus; xu jek u cʼutic che ruʼ i mer jupaj tzij-le pa i xrajlaj wi chuwach wuj. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Teʼuri, are que tijin chi be, xe icʼaw pa ʼo wi i ya; are ʼuri i achi xu bij: —Chi ʼo i ya. ¿ʼUtz nawi ca kajsax ni ya pinwi woʼor? ¿ʼO nawi ca ʼatiw u ʼonquil? —coʼon che. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","I ma Felípe xu bij che: —N-taj; we lic cul a cʼux che i Jesucrísto —coʼono. —Cul in cʼux che chi are i Jesucrísto are u Cʼojol i Dios —xu bij che i ma Felípe. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Teʼuri xu tak u tacʼbaxic u careta. Xe kaj bi che queb, xe ʼe chi ya. Are ʼuri i ma Felípe xu kajsaj ya puwi i achi. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Are xe ʼel chu chiʼ i ya, i u Tewal i Dios xu cʼam bi i ma Felípe. I achi n-xril ta chic u wach, xui-ri ca quicotic xu maj tan chic u be. ");
INSERT INTO acr_acc_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","I ma Felípe, xril ire chi ʼo pa tinimit Azóto. Are ʼuri xu maj u be che i tinimit Cesaréa. Are ca tijin chi be, xu paxsaj i ʼutz laj tzij re i Jesucrísto pa tak tinimit pa xicʼaw wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","I ma Sáulo n-xu mayij tu bixquil i qui camsaxic niʼpa i qui jachom quib puʼab i Kajwal Jesus. Rumal ʼuri xa ʼe ruʼ i ʼatz laj sacerdóte, ");
INSERT INTO acr_acc_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","xe u tzʼonoj u wuj re i rocbal pa tak molbalʼib pa tinimit Damásco, que u tzucbej que i creyent. Craj ire que u cʼam lok, que u tzʼapij pa Jerusalen, chi achiab, chi ixokib. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Xui-ri, are ca tijin chi be, ya cupon chu nakaj i tinimit Damásco, xak teʼet xpe jun ʼaʼ chicaj, xrepcan chirij chuwach. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","I ma Sáulo xtzak pulew; are ʼuri xu ta jun chʼawbal chicaj chi xu bij: —A-Sáulo, a-Sáulo, ¿wuchac ca ʼan chʼoʼoj chwij yin? —xbix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","I ma Sáulo xu tzʼonoj che: —¿At pachin yet, Nim laj Winak? —coʼono. Teʼuri xbix che: —Yin in Jesus; chwij yin cat tijin wi chu ʼanic chʼoʼoj. Xui-ri, xa atuquel yet ca ʼan cʼax che awib, pacha coʼon jun boyex are cu coj akan che jun puyu; utuquel coʼon cʼax che rib, queje ca ʼan yet ile —xbix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","I ma Sáulo ca sicsat rumal u xibriquil. —Kajwal, ¿wach cawaj yet quin ʼano? —xu bij. I Kajwal xu bij che: —Chat walijok, jat pa tinimit. Chila ca bix wi chawe wach i ca ʼano —xbix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","I achiab chi je rachiʼil i ma Sáulo je ocnak ʼil man xqui ta i chʼawbal, xui-ri n-xquil tu wach i xchʼawic. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","I ma Sáulo xwalij chuwach ulew, péro are xu jak u baʼwach, n-ca tzun ta chic. Rumal ʼuri, xqui chʼelej bi che u ʼab, y xqui cʼam bi pa tinimit Damásco. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Chila xu chʼij oxib ʼij n-ca tzun taj; n-cu tij ta chic u wa, n-cu tuʼ ta chic u yaʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ʼO jun creyent, ma Ananías u bi, jekel chila pa Damásco. Ire xril pu wach chi i Kajwal xu cʼut rib chuwach. —¡Ananías! —coʼon che. —¿Wach cawaj, Kajwal? —xu bij ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Are ʼuri i Kajwal xu bij che: —Chat walijok, jat pa be chi “Sucʼulic” ca bix che. Chila, che i rachoch i ma Júdas, cha tzucuj wi jun achi, ma Sáulo u bi, aj pa tinimit Társo. Woʼor ca tijin chu tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","I achi-le, at royʼem, man rilom chic pu wach chi cupon jun achi ruʼ, ma Ananías u bi. Xak xin bij che chi yet ca coj ni a ʼab puwi man ca tzun tan chic —coʼon che i ma Ananías. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","I ma Ananías, are xu ta, xu bij: —Kajwal, je qʼui je bin-nak chwe chi i achi-le, are ʼo pa Jerusalen, mas i cʼax xu ʼan chique i je awe yet. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Y ya xcʼun chi, col u chapbej-que niʼpa i quiqui tzʼonoj i tobal-que chawe. I cajʼatzil i sacerdóte xqui ya che chi cu ʼan ile —coʼon i ma Ananías. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Are ʼuri i Kajwal xu bij che: —Jat; ya xin cha i achi-le ca ʼe u bij in tzij chique i ne te aj Israel winak, xak chique i qui ʼatol tzij, xak chique i aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Quin cʼut na che niʼpa u qʼuial i cʼax cu chʼij na xa wumal yin, are cu bij in tzij chique i winak —xu bij i Kajwal che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Teʼuri i ma Ananías xa ʼe ruʼ ja pa ʼo wi i ma Sáulo. Xoc bic, xu ya u ʼab puwi y xu bij che: —Wachalal ma Sáulo, i Kajwal Jesus chi xu cʼut rib chawe pa be, are i xin takaw li awuʼ. Xin u tak lok man cat tzun tan chic, xak coc li u Tewal i Dios pawanima —xu bij i ma Ananías che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Are ʼuri i ma Sáulo pacha xcʼojwan u baʼwach, y xtzun chic. Teʼuri xwalijic, y xkajsax ya puwi. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Teʼuri xu tij u wa; xqʼuiji chic u choʼab. Xnajtin jubiʼ chila pa tinimit Damásco cuʼ i creyent. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","I ma Sáulo, are ʼutz chic, juntir xu jek qui solixic i tak molbalʼib que i aj Israel, y xoc chu bixquil chique chi Jesus are u Cʼojol i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Conojel i xe tawic lic xqui bisoj: —I achi-le, ¿xataba n-are ti ire-le chi xu ʼan chʼoʼoj chiquij i creyent? Ire-le, are ʼo pa Jerusalen, xe u chap niʼpa i quiqui tzʼonoj i tobal-que che i Jesus. Teʼuri xcʼun waral que u chapbej bi que i creyent; xraj ire que u cʼam bi pa Jerusalen, que u jacha chique i cajʼatzil i sacerdóte. (Queje xqui bij i winak ile pa molbalʼib.) ");
INSERT INTO acr_acc_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Xui-ri, i ma Sáulo xa xu cowij mas u cʼutunic chique. Lic xu ʼalijinsaj chique chi are i Jesus are i Tolque chi coyʼem. Xeʼelok chi niʼpa i aj Israel je jekel pa tinimit Damásco n-quiqui rik ta chic wach quiqui bij che. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Xoʼon chupan jubiʼ, i nimak tak aj Israel xqui junamsaj qui noʼoj chi quiqui camsaj i ma Sáulo, ");
INSERT INTO acr_acc_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","xui-ri, ire xu ta rason wach i qui chʼobom. Ique, chi paʼij chi chaʼab cacoyʼej pa tak ʼelbal bic re i tinimit, quiqui camsabej-re. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","I creyent xqui to i ma Sáulo; xqui ya chupam jun nim laj chicach chaʼab, y xqui kajsaj chirij i tapia chi u sutim rij i tinimit. Queje u totajic ile xqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","I ma Sáulo xa ʼe chic pa Jerusalen; are xuponic, craj ire coc cuʼ i creyent. Xui-ri ique xqui xij quib che, n-xqui coj taj we katzij u yom chic rib puʼab i Jesus. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ʼO jun creyent, ma Bernabe u bi, xu cʼam bi i ma Sáulo cuʼ i apostelab, man caquetamaj u wach. I ma Bernabe xoc chu bixquil chique wach u cʼulaxic i Kajwal xu ʼan i ma Sáulo pa be, xak wach u ʼijlaxic xu ʼan i Kajwal. Xak xu bij chique chi i ma Sáulo co i u cʼux xu lap i Jesus chique i aj Damásco. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Teʼuri i ma Sáulo xnajtin cuʼ i creyent pa Jerusalen; pa i que ʼe wi ique, xak ca ʼe ire cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ire lic co u cʼux xu lap i Kajwal chique i winak. Xlapan cuʼ i aj Israel winak chi que chʼaw piqui chʼawbal i aj Griégo; ʼolic xqui chap quib chi tzij cuʼ. Xui-ri, ique xqui tzucuj wach camsabal-re. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","I creyent, are xqui ta ile, xqui cʼam bi che i tinimit Cesaréa, teʼuri xqui tak bi che i tinimit Társo. (Queje u totajic ile xqui ʼano.) ");
INSERT INTO acr_acc_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Are ʼuri, xuxlan jubiʼ i chʼoʼoj chiquij i tak tzobajil creyent chi je ʼo pa tak tinimit re i jyub Judéa, xak re i Galiléa, xak re i Samária. Ique lic xcowir u cubibal qui cʼux che i Kajwal, lic quiqui coj u ʼij, lic quiqui coj u tzij, xak xe qʼuiar rumal u Tewal i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","I ma Pédro are ca tijin chi qui solixic i creyent pa tak tinimit, xak xa ʼe bin cuʼ i je ʼo pa tinimit Lída. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Chila xu rik wi jun achi, ma Enéas u bi; ʼo chic wajxakib junab che chi cotzʼol puwi u chʼat, siquirnak u chʼacul. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","I ma Pédro xu bij che: —Ma Enéas, i Jesucrísto cat rutzirsaj. Chat walijok y cha yijba a chʼat —coʼon che. I ma Enéas juntir xwalijic. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Conojel i aj pa tinimit Lída xquilo wach i xa ʼanic, xak queje i aj pa taʼaj Saron; rumal ʼuri xqui jalwachij qui nojbal chi n-ʼus taj, y xqui ya quib puʼab i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Che i Lída, nakaj ʼo wi i tinimit Jópe pa jekel wi jun ixok creyent, ati Tabíta u bi. (Piqui chʼawbal i aj Griégo winak, ati Dórcas quiqui bij che.) I ixok-le, ʼutz laj winak, mas que u to i nibaʼib. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Che tak i ʼij-le (are ʼo i ma Pédro pa Lída), i ati Dórcas xiwajic y xcamic. ʼO i xchʼajaw u chʼacul y xqui ya pu caleja. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","I tinimit Jópe n-naj ta ʼo wi che i tinimit Lída, pa ʼo wi i ma Pédro. I creyent pa Jópe quetaʼam chi chila ʼo wi, rumal-i xqui tak u siqʼuixic. Xe qui tak bi queb achiab chu bixquil che chi weʼ u wach cha petok. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","I ma Pédro xa ʼe cuʼ; are xuponic, xcʼam bi chila pa ʼo wi i camnak. Je qʼui ixokib malcanib que oʼic; xqui mol quib chirij chuwach i ma Pédro. Xqui cʼut che niʼpa i camix, niʼpa i qui ʼuʼ u yijbam, u si pam can i ati Dórcas chique are cʼaslic. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","I ma Pédro xu bij chique chi que ʼel bi jubiʼ. Teʼuri xuqui ruʼ i camnak y xu tzʼonoj che i Dios. Xu maj u takexic i camnak: —Tabíta, chat walijok —xu bij che. Xak teʼet, i ixok xu jak u baʼwach; are xu takej i ma Pédro, xcubi ʼanok. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Teʼuri i ma Pédro xu chap che u ʼab y xu yaco. Xe u siqʼuij i creyent, xak i ixokib malcanib, y xu jach i ati Dórcas chique, cʼas tan chic. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Ile, xpax rason ronojel i tinimit Jópe; teʼuri je qʼui i winak xqui cuba qui cʼux che i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","I ma Pédro xnajtin jubiʼ che i tinimit-le. Xqʼuiji pa rachoch jun aj tucul tzʼum, ma Simon u bi. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","ʼO jun achi jekel pa tinimit Cesaréa, ma Cornélio u bi. I u patan ire, capitan piquiwi cien soldádo. I u bi i jutzobaj soldádo-le: Italiáno ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","I ma Cornélio-le lic u yom rib che i Dios, lic quiqui coj u ʼij i Dios junam cuʼ i rixokil ralcʼwal. Nic are wi xu tzʼonoj che i Dios, xak xu ya mer, tobal-que i aj Israel winak. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Chupam jun ʼij, colo a las tres re u kajbal ʼij, sakil xril ire puwach ʼo jun ángel petnak ruʼ i Dios; xoc ruʼ y xu bij che: —¡Ma Cornélio! —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Ire, are xrilo, xcanajic toʼ ca takenic rumal u xibriquil. —¿Wach cu bij a cʼux, Nim laj Winak? —xu bij che. I ángel xu bij che: —I Dios, niʼpa i a tzʼonom che, niʼpa i a yom chique i nibaʼib, ʼutz crilo; ya ʼo chic chuwach ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Che a taka bi ʼuri juban achiab pa tinimit Jópe chu siqʼuixic i ma Simon, chi xak ma Pédro ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ire ʼo i u posar chila ruʼ jun chic ma Simon, aj tucul tzʼum; i rachoch ʼo chu cʼulel i mar. Ire col u bij na chawe wach i ca ʼano. (Queje xu bij i ángel ile che i ma Cornélio.) ");
INSERT INTO acr_acc_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Are xa ʼe i ángel, i ma Cornélio xe u siqʼuij queb u mocom, xak i jun u soldádo chi lic teren chirij, chi lic cu coj u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","I ma Cornélio xu bij chique ronojel wach i xrilo, wach i xu ta; teʼuri xe u tak bi pa tinimit Jópe. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Chucab ʼij, i achiab que tijin chi be, ya que nakajab che i tinimit Jópe. Are tiqʼuil ʼij, i ma Pédro craj cu tzʼonoj che i Dios. Xel bi ʼuri puwi i ja, chi taʼaj u wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ire ca num chic, lic craj u wa. Are que tijin chu yijbaxic u wa, ire ʼo i xril puwach. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Xril ire pacha xjaktaj i caj y xkaj li pacha jun nim laj cʼul pulew, ximtal pa tak u tzam. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Chupam i cʼul xrilo je ʼo u qʼuial chicop qʼui qui wach. ʼO i cajib cakan, xak je ʼo i cumatz, xak je ʼo i tzʼiquin; ʼis qʼuial qui wach. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Xu ta ire chi xbix che: —Chat walijok, a-Pédro, cha camsaj y cha tija —cutixic. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Ire xu bij: —Cuyu in mac, Kajwal. Yin lic n-quin tij ti n-chʼam ta laj tak chicop. Lic n-quin tij ti awas chicop —coʼon i ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Xbix chal che chicaj: —Niʼpa u ʼanom chic chʼam i Dios che, ma bij yet ʼuri che chi n-chʼam taj —cutixic. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Queje xbix ile che, oxmul; teʼuri xtzalij chic i cʼul chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","I ma Pédro toʼ chʼobonic xcanajic, wach usucʼ ile chi xril puwach. Tzʼakat xu ʼan ire ile, are ʼuri i u takon i ma Cornélio je ʼo chuwach uchija. Que tijin chu chʼobic rakan pa ʼo wi i rachoch i ma Simon. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Are je ʼo chuwach uchija, co xe chʼaw pan pa ja: —¿N-chi ta ʼo wi u posar i ma Simon, chi xak ma Pédro ca bix che? —xe cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","I ma Pédro cʼa ca tijin chu chʼobic wach i xril puwach. Are ʼuri i u Tewal i Dios xu bij che: —Tapeʼ, cat qui tzucuj oxib achiab. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Chat walijok, chat kaj bic, y jat cuʼ. Ma xij awib, man yin je in takom li awuʼ —coʼon u Tewal i Dios che. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","I ma Pédro xkaj li ʼuri pa je ʼo wi u takon i ma Cornélio. Xu bij chique: —Yin-i, chi quin i tzucuj. ¿Wach i quiwaj yix wuʼ? —coʼon chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","—Yoj oj u takom li capitan ma Cornélio. Ire ʼutz laj winak; cu coj u ʼij i Dios; lic cajwax cumal i aj Israel winak. Jun ángel re i Dios xbin che chi xoj u tak li cha siqʼuixic yet, man cat ʼe ruʼ chila che i rachoch. ʼO u chac cu ta chawe wach i ca bij na che —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","I ma Pédro xu bij chique chi que oc ruʼ pa ja; xe canaj ʼuri jun aʼab ruʼ. Chucab ʼij, xa ʼe i ma Pédro cuʼ, xak je ʼo jujun creyent aj Jópe xe ʼe cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Churox ʼij xe upon pa tinimit Cesaréa. I ma Cornélio je coyʼem chic cuʼ i rachalal, xak cuʼ i quetaʼam qui wach chi je u siqʼuim ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Are xupon i ma Pédro, xel li ma Cornélio chu cʼulaxic, y xuqui chuwach, cu cojbej re u ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","I ma Pédro xu yaco. —Chat walijok —xu bij che—, yin xa in winak pacha yet —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Que tijin chi tzij, xe oc bi pa ja; are ʼuri xe ril u qʼuial winak qui molom quib, coyʼem ruponic. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Teʼuri i ma Pédro xu bij chique: —Yix lic iwetaʼam chi i ka costúmbre yoj oj aj Israel, n-cu ya ta chake coj oc iwuʼ che iwachoch yix chi n-ix ta aj Israel. N-cu ya ta chake cakucʼaj kib iwuʼ yix; xui-ri i Dios u cʼutum chwe chi n-ʼus taj we quin bij itzel winak che chic jun chic. N-ʼus taj we quin bij chi i ne te aj Israel ne te ʼutz chuwach i Dios. Queje ile u cʼutum chwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Rumal-i, are xin i siqʼuij, juntir xin petic. N-ta coʼono we n-ix ti aj Israel; n-ta xin bij che ile. Cwaj cwetamaj wuchac xin i siqʼuij iwuʼ —coʼon i ma Pédro chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Teʼuri i ma Cornélio xu bij che: —Che can i cajib ʼij, pacha i ʼor-i, ya coʼon a las tres re u kajbal ʼij, ʼo i xwil pinwach. Yin in ʼo waral ruʼ wachoch; in canam can in waʼim man quin tijin chu tzʼonoxic che i Dios. Xak teʼet, xwinakir jun achi chinwach, i u ʼuʼ lic ca walchʼinic. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Xu bij chwe: “Ma Cornélio, Dios u tom wach i ca tzʼonoj che; xcʼun pu cʼux chi lic que a to i nibaʼib,” xu bij chwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","“Cha taka u cʼamic i ma Simon, chi xak ma Pédro ca bix che,” coʼono. “Ire ʼo pa tinimit Jópe; ʼo u posar ruʼ jun chic ma Simon chi aj tucul tzʼum. I rachoch ʼo chu cʼulel i mar. Ire col u bij chawe wach i ca ʼano.” Queje ile xu bij i ángel chwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Rumal-i, juntir xin tak a siqʼuixic; ʼutz xa ʼano xat cʼunic. Woʼor ka molom kib chi, chuwach i Dios; cakaj caka ta wach ca bij chake, pacha u bim i Dios chawe chi ca bij chake —coʼon i ma Cornélio. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Are ʼuri i ma Pédro xoc chu bixquil chique: —Woʼor quin ta u be chi katzij i Dios xak jun kilic cu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Ire ʼis ʼutz que rilo niʼpa i quiqui coj u ʼij, xak quiqui ʼan i ʼutz; n-ta coʼono bi chi jyubal je petnak wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Are ile, are i ʼutz laj tzij xu tak bi chique i aj Israel winak; xu bij chi rumal i Jesucrísto, i winak ʼis quiqui rik i chombal quib ruʼ i Dios. Are i Jesucrísto are i Cajwal i winak conojel. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iwetaʼam yix wach i xa ʼani pa ronojel i jyub Israel, chi xjekan li cʼa Galiléa, are xqʼuis u chac i ʼetz ma Wan, chi xu cʼut chique i winak chi ʼo u chac quiqui jalwachij qui cʼaslemal, xak ca kajsax ya piquiwi. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Iwetaʼam yix chi Jesus aj Nazaret, i Dios lic xu ya i u Tewal che, xak i u choʼab; ire xbin pa tak tinimit chu ʼonquil i ʼutz, xak chi cutzirsaxic niʼpa i je ʼo puʼab itzel. Xtiqui chu ʼonquil, man i Dios lic ʼo ruʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Yoj oj apostelab, ʼis xkilo ronojel wach xu ʼan i Jesus pa tak jyub re i Judéa xak pa tinimit Jerusalen, cʼa are xqui rip chuwach cruz, camsabal re. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Are i mísmo Jesucrísto chi Dios xu cʼastaj churox ʼij, y xu winakirsaj chic chakaxol yoj. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","N-xu cʼut ta chique i winak conojel, xui chake yoj, man yoj oj chatal ujer rumal i Dios, caka yabej rason. Kuʼ yoj xu tij wi u wa, i u yaʼ, are walijnak chic chiquixol i camnak. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Xoj u tak yoj chu yaʼic rason chique i winak; xoj u tak bi chu bixquil chi Dios yawnak i Jesus-le aj ʼanol ʼatbal tzij piquiwi i je cʼaslic, xak i je camnak, wach tak i qui ʼanom. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Conojel i ajbil u tzij i Dios, ʼax qui bim wi wach u patan i Jesus. Qui bim chi niʼpa i quiqui cuba qui cʼux che ire, ʼis ca cuytaj qui mac; rumal ire que cuytaj na. (Queje i u tzij i ma Pédro ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Are ca tijin i ma Pédro chi tzij, are ʼuri xcʼun i u Tewal i Dios piquiwi conojel i xe taw u tzij. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","I aj Israel creyent chi je petnak ruʼ i ma Pédro, ique toʼ xqui bisoj are xkaj u Tewal i Dios piquiwi i ne te aj Israel. (Quiqui bij ique, xui chique i aj Israel winak ca yaʼic, péro n-xui taj.) ");
INSERT INTO acr_acc_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ʼAlaj chi petnak piquiwi, man xqui ta ique chi junwi chic que chʼawic, xak que tijin chu cojic u ʼij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Teʼuri i ma Pédro xu bij: —Xak ique xkaj li u Tewal i Dios cuʼ pacha u ʼanom chake yoj. Rumal-i, ʼutz we ca kajsax ya piquiwi —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Xu tak ʼuri u kajsaxic ya piquiwi, cʼutbal-re chi je re chic i Jesucrísto. Teʼuri, ique xqui tzʼonoj che i ma Pédro chi ca najtin cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","I apostelab chi je ʼo pa Judéa, xak i juban creyent chila, xqui ta rason ʼuri chi ʼo i ne te aj Israel chi xak xqui coj u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","I ma Pédro, are xtzalij pa Jerusalen, xyaj cumal jujun creyent chi je aj Israel winak; cacaj ique chi conojel i creyent ca ʼan i retal circuncision chique. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Xqui tzʼonoj che: —¿Wuchac xat ʼe bin cuʼ i ne te aj Israel winak? ¿Wuchac xa tij wa cuʼ? —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Are ʼuri i ma Pédro ʼis xu bij chique ronojel wach i xu cʼulmaj. Xu jek u bixquil chique wach u jekanic lok. Xu bij: ");
INSERT INTO acr_acc_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Yin, are in ʼo pa tinimit Jópe, quin tijin chu tzʼonoxic che i Dios. Are ʼuri ʼo i xwil pin wach. Xwilo chi xkaj li pacha jun nim laj cʼul chicaj, ximtal pa tak u tzam; xkaj li wuʼ, pa in ʼo wi yin. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Are xin takej coqʼuil, xwilo je ʼo tak chicop chupam, cajib cakan, jujun chique lic je itzel chicop; xak je ʼo cumatz, xak je ʼo tzʼiquin chupam. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Are ʼuri xin ta jun chʼawbal chi xu bij: “Chat walijok, a-Pédro,” xu bij chwe, “cha camsaj y cha tija,” xin utixic. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Cuyu in mac, Kajwal,” xin bij, “yin n-ta xak ocnak pin chiʼ chi n-chʼam taj; lic n-ta xak ocnak pin chiʼ chi awasim chicop,” xin bij che. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Are ʼuri i chʼawbal chicaj xin u ʼijla chic; xu bij: “Niʼpa u ʼanom chic chʼam i Dios che, ma bij yet ʼuri che chi n-chʼam taj,” coʼon chwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Oxmul xu ʼano, teʼuri xel chubi chicaj. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Are ʼuri xe upon oxib achiab ruʼ ja. Je taktal bi chin tzucuxic, je petnak cʼa pa tinimit Cesaréa. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","I u Tewal i Dios xin u tak bi cuʼ, n-ta chic quin na wib che. Xak i wakib aj Israel creyent chi je aj Jópe xe ʼe wuʼ, y konojel yoj xoj oc chi rachoch i achi chi xin u siqʼuij. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Ire xu bij chake chi xwinakir jun ángel chi rachoch, chi xu bij che: “Che a taka bi achiab pa Jópe chu tzucuxic i ma Simon chi xak ma Pédro ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ire cu bij na chawe wach u rikic a cʼaslemal chi n-tu qʼuisic, yet cuʼ awixokil awalcʼwal.” Queje ile xbix che, xu bij chwe. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Are xin uponic y xin jek u cʼutic chique, xcʼun u Tewal i Dios piquiwi, xak jun ruʼ pacha xu ʼano are xcʼun kuʼ yoj are xka jek i ka chac. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Teʼuri xcʼun chin cʼux wach u bim can i Kajwal. Xu bij ire chi i ma Wan xu kajsaj ya piquiwi i winak, péro coʼon panok i Dios cu kajsaj li u Tewal piquiwi i winak. (Queje xu bij ire ile chake.) ");
INSERT INTO acr_acc_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Xwil yin chi xu ʼan i Dios chique ique xak jun ruʼ pacha u ʼanom chake yoj chi ka jachom kib puʼab i Kajwal Jesucrísto. We queje xu ʼan i Dios ile, ¿xataba quin ʼatij yin wach craj i Dios? N-taj. (Queje xu bij i ma Pédro ile chique.) ");
INSERT INTO acr_acc_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","I creyent pa Jerusalen, are xqui ta ile, n-xe chʼaw ta chic, xa xqui cʼamwaj xqui tioxij che i Dios. Xqui bij: —ʼAlaj ʼuri chi Dios xak u yom chique i ne te aj Israel chi quiqui jalwachij qui noʼoj chi n-ʼus taj, chʼacbal re qui cʼaslemal sakil. (Queje ile xqui bij chiquiwach.) ");
INSERT INTO acr_acc_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","I creyent pa Jerusalen, are xcamsax i ma Estéban, xak xpe chʼoʼoj chiquij ique. Rumal-i, xe ʼel chila; ʼo i xe ʼe pa jyub Fenícia, ʼo i xe ʼe pa Chípre, xak ʼo i xe ʼe cʼa pa Antioquía. Are xe upon pa tak jyub-le, xe oc chu bixquil i ʼutz laj tzij re i Jesucrísto; xui chique i aj Israel winak xqui bij wi; n-xqui bij ta chique i ne te aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Xui-ri, je ʼo jujun creyent aj pa Chípre, xak juban aj pa Ciréne, xe upon che i tinimit Antioquía y xe oc chu cʼutic i ʼutz laj tzij re i Kajwal chique i ne te aj Israel. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Are xqui ʼan ique ile, lic ʼo u choʼab i Dios cuʼ. Je mas i winak xqui jach quib puʼab i Kajwal, xak xcoʼtaj can i qui nojbal re ujer. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","I jutzobaj creyent pa Jerusalen xqui ta rason chi je qʼui aj Antioquía qui jachom quib puʼab i Kajwal; rumal-i xqui tak bi i ma Bernabe cuʼ. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Ire, are xupon chila, xrilo chi lic ʼo utzil chomal re i Dios cuʼ, lic xquicot rumal. Teʼuri xe u pixbaj conojel, chi jiquil qui cʼux che ʼolok, lic ma coʼtaj i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Queje ile xu bij ire chique, man ire ʼutz laj winak, lic ʼo i u Tewal i Dios ruʼ, xak lic cul u cʼux che i Dios. Rumal-i, mas tan chic i winak xqui jach quib puʼab i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Teʼuri i ma Bernabe xa ʼe pa tinimit Társo chu siqʼuixic i ma Sáulo. Are xu riko, xu cʼam li pa tinimit Antioquía. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Are xe uponic, xe qʼuiji jun junab cuʼ i jutzobaj creyent chila. Je qʼui i winak xe qui tijoj che i junab-le. I creyent pa Antioquía, “Cristian” ca bix chique cumal i winak. Are i nabe u bixquil ile chique i je re i Jesucrísto. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Pa tak ʼij-le, je ʼo juban creyent aj pa Jerusalen xe cʼun pa Antioquía. Je ajbil-re chique i winak wach i ca ʼani na. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Jun chique, ma Agábo u bi, xtaqʼui ʼan chiquixol i creyent pa qui molom wi quib; rumal u Tewal i Dios chi ʼo ruʼ, xu bij chique chi ca pe jun waʼjal ronojel u wach i jyub taʼaj. Xoʼon panok, niʼpa i xu bij, queje xeʼelok. Xpe jun waʼjal pa tak ʼij re i ma Cláudio, are ʼatol tzij wi ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Entónces i creyent pa Antioquía xqui chʼobo chi que qui to pan i creyent aj Judéa. Chi qui jujunal xqui ya qui mer, niʼpa i que tiqui chu yaʼic. ");
INSERT INTO acr_acc_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","I niʼpa i mer chi xqui molo, xqui tak bi chique i qui wi qui jolom i creyent aj Judéa. Piquiʼab i ma Bernabe i ma Sáulo xqui tak wi bic. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Che tak i ʼij-le, i ʼatol tzij ma Heródes, xu jek chʼoʼoj chiquij jujun creyent. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Xu tak u camsaxic i ma Jacóbo ruʼ chʼichʼ; are i ma Jacóbo chi catz qui chaʼ quib ruʼ i ma Wan. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","I ma Heródes, are xrilo chi que quicot i nimak tak aj Israel rumal ile, xu tak ʼuri u chapic i ma Pédro. Are ʼij chi xu ʼan ire ile, are i nimaʼij que i aj Israel chi ca tijaw wi i caxlanwa n-ta cunbal che. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Are xchaptaj i ma Pédro, are ʼuri i ma Heródes xu tzʼapij pa cárcel. Xe u coj cajib tzobaj soldádo chu chajixic; je cajcaj chu chajixic jutak chʼay, chi paʼij chi chaʼab. Xu chʼob i ma Heródes, are ca qʼuis i nimaʼij, cresaj li ma Pédro chiquiwach i winak, man xu chʼob ire quiqui ʼan qui ʼatbal tzij i winak che. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Rumal-i, i ma Pédro ʼo pa cárcel, lic chajtalic. Xui-ri, i jutzobaj creyent n-xqui mayij tu tzʼonoxic che i Dios puwi; lic ronojel qui cʼux xqui ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","I ma Pédro ʼo pa cárcel, kus u waram chiquixol i queb soldádo. Ire ximom u ʼab ruʼ queb carena chi xak yukul chique i soldádo. Xak je queb chic soldádo je tacʼal xol uchija, quiqui chajij i cárcel. U chʼobom i ma Heródes cu ya i ma Pédro chiquiwach i winak chucab ʼij. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","(Maja ca pe u sakiric) xak teʼet xwinakir jun ángel re i Kajwal ruʼ i ma Pédro. I pa cárcel lic xoʼon sak rumal. I ángel xu yin pan u cʼalcʼax i ma Pédro y xu cʼastaj. —¡Chat walij la! —coʼono. Are ʼuri, xtzak i carena pulew chi ʼo che u ʼab i ma Pédro. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","I ángel xu bij che: —Cha bajij a pam, y cha cojo a xajab —coʼon che. Are xu ʼan i ma Pédro ile, teʼuri xu bij i ángel che: —Cha cojo a chaquet, y chat terej chwij —xutixic. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","I ma Pédro xterej li chirij i ángel, y xel lok. Xu chʼob ire mok n-katzij taj wach ca tijin chi rilic, mokxa xa cachiqʼuic cu bij ire. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Xe icʼaw pa je ʼo wi i nabe jutzobaj soldádo, teʼuri xe icʼaw chic che i ucab tzobaj soldádo. Xe upon che uchibe, lic chʼichʼ, xui-ri utuquel xu jak rib. Xe ʼel lok, y xe bin jubiʼ che jun be. Teʼuri i ángel xu canaj can i ma Pédro utuquel pa be. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Are ʼuri i ma Pédro xrilo chi katzij wach i ca tijin chi rilic. Xu bij: —Woʼor xwilo chi katzij ile. I Kajwal u takom li u ángel, tobal we chuwach i ma Heródes xak chiquiwach i nimak takaj Israel, wach qui chʼobom quiqui ʼan chwe —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Ca tijin chu chʼobic queje ile, xa ʼe chi rachoch i ati Mariy, chi u chuch i a-Wan, chi xak a-Márcos ca bix che. Chila qui molom wi quib u qʼuial winak, que tijin chu tzʼonoxic che i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","I ma Pédro xu cʼojcʼa i sawan. Are ʼuri xel li jun ali, al-Róde u bi, xol u ta pachinok. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Are xu ta u chʼawbal i ma Pédro, xsach u noʼoj rumal u quicotic. Xtzalij la, n-xu jak ti sawan. Xa ʼe paʼanem chu bixquil chique i je ʼo pa ja, chi ma Pédro tacʼal chic pa ocbal bic. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Ique xa xqui bij che: —¡At chʼuj! —xe cha che. I ali xu bij chi lic katzij are ire. Ique xqui bij chic chi n-are taj: —Ile xa u ninox —xe cha che. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","I ma Pédro n-xu mayij tu cʼojcʼaxic i sawan. I creyent, are xqui jak uchibe, xquilo chi katzij are ire; lic xe oc ʼil che. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","I ma Pédro xu cʼut ruʼ u ʼab chi me chʼawic. Teʼuri xu bij chique wach i relsaxic xu ʼan i Kajwal che, pa cárcel. Xak xu bij chique: —Chi ya rason che i ma Jacóbo, xak chique i juban creyent —coʼono. Teʼuri xel bic, xa ʼe chic che jun tinimit. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Are xpe u sakiric, i soldádo lic que cʼachiric; que bisonic man n-ta chic i ma Pédro, n-quetaʼam taj wach relic xu ʼano. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","I ma Heródes xu tak u tzucuxic coqʼuil, péro n-xqui rik taj. Xu ya quekan ʼuri i soldádo, y xu tak qui camsaxic. Teʼuri xel i ma Heródes pa Judéa; xa ʼe jekel pa tinimit Cesaréa. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Xoʼon panok i ma Heródes xpe roywal chique i winak aj pa tak tinimit Tíro y Sidon. Rumal-i, ique xqui yijba chiquiwach chi conojel ʼis que ʼe chuwach i ma Heródes. Ire ʼo jun achi ruʼ, nim u patan, ma Blásto u bi. I winak aj Tíro, i aj Sidon xqui bij che i ma Blásto chi cu coj qui tzij chuwach i ma Heródes, chomarsabal quib ruʼ. ʼO u chac chique quiqui chomaj chic quib ruʼ, man chila pu tinimit i ma Heródes xpe wi wach i quiqui tijo. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","I ma Heródes xu chʼic ʼuri jun ʼij chique, are quiqui mol quib y quiqui yijba chiquiwach. Are xu rik i ʼij, xu coj u ʼuʼ lic chom y xcubi pu cubibal re u ʼatbal tzij. Xu bij ʼuri jun nim laj bixquil chiquiwach. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","I winak, are xqui ta, xe siqʼuinic: —¡Ire-le n-toʼ ta winak! ¡Ile lic jun dios! —que cha. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Xak teʼet jun ángel re i Kajwal xu petsaj yobil chirij i ma Heródes, man n-xu bij taj chi xa jun i Dios chi ca majawic quiqui coj u ʼij. Rumal-i, xu ʼan che chi xtijaw cumal amol, y xcam rumal. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","I u tzij i Kajwal ca tijin u paxic u wach; xa ipa ca tataj wi. ");
INSERT INTO acr_acc_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","I ma Bernabe i ma Sáulo, are xqʼuis i qui chac pa Jerusalen, xe ʼel chila, xqui cʼam bi i a-Wan cuʼ, chi xak a-Márcos ca bix che. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Che i jutzobaj creyent re i tinimit Antioquía, je ʼo jujun ajbil u tzij i Dios, xak je ʼo jujun aj tijonel que i creyent: je are i ma Bernabe, i ma Simon chi xak ma ʼEk ca bix che; xak ʼo i ma Lúcio chi aj tinimit Ciréne; ʼo i ma Manaen (chi xe qʼuitsax junam ruʼ i ma Heródes, chi gobernador pa Galiléa); xak ʼo i ma Sáulo. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Xu rik jun ʼij, ique que tijin chu cojic u ʼij i Kajwal, coʼtam qui waʼim rumal u tzʼonoxic che i Dios. Are ʼuri i u Tewal i Dios xe u ʼijla: —Che i jacha i ma Bernabe i ma Sáulo chwe, man ʼo jun qui chac quin yaʼo —coʼono. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Are xquelej u tzʼonoxic che i Dios, xak xqʼuis i tiémpo chi coʼtam can i qui waʼim, are ʼuri xqui ya i qui ʼab piquiwi i ma Bernabe, i ma Sáulo, y xe qui ʼijla bi che qui chac. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Teʼuri i ma Bernabe i ma Sáulo xe ʼe che qui viáje, je taktal bi rumal u Tewal i Dios. Nabe xe ʼe pa tinimit Seléucia. Chila xe oc wi pa bárco, ʼenam que cʼa pa Chípre, jun ral jyub setel chuwi mar. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Are xe upon pa Chípre, xe kaj che i tinimit Salamína, pa que cʼun wi i bárco pa mar. Are ʼuri xqui jek u bixquil i u tzij i Dios pa tak molbalʼib que i aj Israel winak. Xak i a-Wan xa ʼe cuʼ, aj tolque. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Xe bin pa tak tinimit cʼa xe upon che i tinimit Páfos, chi ʼo chi ya. Chila xqui rik wi jun aj Israel, ma Barjesus u bi, (chi xak ma Elímas ca bix che). I achi-le, ajʼitz; ire xa aj tʼoronel, cu bij chi ajbil u tzij i Dios péro n-are taj. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Ire ʼo ruʼ i gobernador, ma Sérgio Páulo, chi lic ʼo u noʼoj. I gobernador xu tak qui siqʼuixic i ma Bernabe i ma Sáulo, man craj cu ta u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","I ajʼitz xu jek u laʼic u wach i qui tzij i ma Bernabe i ma Sáulo; craj ire chi n-cu coj ti gobernador u tzij i Dios. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","I ma Sáulo (chi xak ma Páblo ca bix che) lic ʼo u Tewal i Dios ruʼ. Xu maj u takexic i ajʼitz; ");
INSERT INTO acr_acc_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","xu bij che: —¡At tʼoronel; lic at mal; at racʼal itzel; at aj chʼoʼoj chirij i ʼutz! ¿Wuchac xa ca jechʼabsaj i sak laj tzij re i Kajwal? ");
INSERT INTO acr_acc_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Woʼor i Kajwal cat u ya na pa cʼax. Cat potzʼir na; n-cawil ti sak, queb oxib ʼij —coʼono. Juntir xoc i ʼekum che u baʼwach; pacha pa ʼekum ʼo wi. Teʼuri xu tzucuj pachin ca chʼelew bic, man n-ca tzun ta chic. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","I gobernador, are xril ile, xu coj u tzij i Dios; lic xu bisoj che i cʼutunic re i Kajwal. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","I ma Páblo cuʼ i rachiʼil xe ʼel pa Páfos; xe oc bi pa bárco, xe ʼe cʼa pa tinimit Pérge, u cwenta i jyub Panfília. Xui-ri, i a-Wan (chi xak a-Márcos u bi) n-xa ʼe ta cuʼ; ire xtzalij chic Jerusalen. ");
INSERT INTO acr_acc_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","I juban xe ʼel pa Pérge, xe ʼe che jun chic Antioquía, chi u cwenta i jyub Pisídia. Are xu rik i ʼij chi uxlambal ʼij, xe oc pa ja re i molbalʼib, y xe cubi chila. ");
INSERT INTO acr_acc_vpl VALUES