﻿USE sofia;
DROP TABLE IF EXISTS sofia.acfNT_vpl;
CREATE TABLE acfNT_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acfNT_vpl WRITE;
INSERT INTO acfNT_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Jézi Kwi sé désandan Wa David épi désandan Abrahanm. Mi non jennenwasyonʼy: ");
INSERT INTO acfNT_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahanm sété papa Ayzak, èk Ayzak sété papa Jakòb. Jakòb sété papa Jouda èk sé fwèʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Jouda sété papa Pérèz épi Zéra — non manman yo sété Tama. Pérèz sété papa Hèzròn. Hèzròn sété papa Ranm. ");
INSERT INTO acfNT_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ranm sété papa Aminadab. Aminadab sété papa Nachòn. Nachòn sété papa Salmòn. ");
INSERT INTO acfNT_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmòn sété papa Bowaz — non manmanʼy sété Rahab. Bowaz sété papa Obèd — non manmanʼy sété Rouf. Obèd sété papa Jèsi. ");
INSERT INTO acfNT_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jèsi sété papa Wa David. Wa David sété papa Sòlomonn — manman Sòlomonn sété madanm Ouraya avan i sété madanm David. ");
INSERT INTO acfNT_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sòlomonn sété papa Réyobowanm. Réyobowanm sété papa Abija. Abija sété papa Asa. ");
INSERT INTO acfNT_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa sété papa Jéhòchafat. Jéhòchafat sété papa Joranm. Joranm sété papa Ouzaya. ");
INSERT INTO acfNT_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Ouzaya sété papa Jofanm. Jofanm sété papa Ahaz. Ahaz sété papa Hèzèkaya. ");
INSERT INTO acfNT_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hèzèkaya sété papa Mannasa. Mannasa sété papa Amonn. Amonn sété papa Josaya. ");
INSERT INTO acfNT_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaya sété papa Jèkonnaya épi sé fwèʼy-la. I fè yo menm tan lèlmi-an té mennen sé jan Izwayèl-la vil Babilonn kon pwizonnyé. ");
INSERT INTO acfNT_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Apwé yo mennen yo Babilonn: Jèkonnaya fè Chyèltyèl. Chyèltyèl sété papa Zèròbabèl. ");
INSERT INTO acfNT_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zèròbabèl sété papa Abyoud. Abyoud sété papa Èlyakim. Èlyakim sété papa Azò. ");
INSERT INTO acfNT_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azò sété papa Zadòk. Zadòk sété papa Akim. Akim sété papa Èlyoud. ");
INSERT INTO acfNT_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Èlyoud sété papa Éliyéza. Éliyéza sété papa Matan. Matan sété papa Jakòb. ");
INSERT INTO acfNT_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakòb sété papa Jozèf. Jozèf sété mawi Mari, ki sété manman Jézi Kwi, wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","La té ni katòz jennenwasyon sòti dépi Abrahanm pou wivé David, katòz sòti dépi David pou jis tan lèlmi-an té mennen yo alé Babilonn, épi dépi an tan Babilonn pou wivé an tan Jézi Kwi té ni katòz jennenwasyon. ");
INSERT INTO acfNT_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Annou wè mannyè Jézi Kwi fèt. Manmanʼy, Mari, té fiyansé épi an nonm yo té ka kwiyé Jozèf, mé i té fi toujou lè i twouvé kòʼy ansent pa pouvwa Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Lè Jozèf vin konnèt Mari té gwo bouden, i té ka chaché an mannyè pouʼy pa té mayé fi-a. I té vlé fèʼy pou moun pa té konnèt, pou Mari pa té twapé kòʼy hont, paski i sété an nonm ki té dwèt an tout sa i ka fè. ");
INSERT INTO acfNT_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","An jou òswè paditan Jozèf té ka konsidiwé sa, an nanj Bondyé vin palé ba li adan an wèv. I diʼy, “Jozèf, désandan Wa David, ou pa bizwen pè mayé Mari paski ti manmay-la i ni an boudenʼy-lan, i la pa pouvwa Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Mari kay fè an ti gason, ou kay bay nonʼy Jézi, paski sa vlé di Bondyé kay sové sé moun li-an hòd péché yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Épi tout sa Bondyé té fè pwòfèt-la di-a vin fèt vwé. I té di, ");
INSERT INTO acfNT_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“An fi kay vini gwo bouden épi i kay fè an ti gason épi yo kay kwiyéʼy Imannyouwèl” — sa vlé di, “Bondyé épi nou.” ");
INSERT INTO acfNT_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Lè Jozèf lévé, i fè sa nanj-lan diʼy fè-a. I pwan Mari épi i mayéʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","mé i pa té kouché épiʼy avan ti gason-an té fèt, épi Jozèf bay non gason-an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Apwé Jézi té fèt an Bèfléyenm, yonn an sé vilaj-la ki an Joudiya-a tan Hèròd té wa, an konpanni nonm ki té ka li étwal sòti adan plas sòlèy lévan-an. Yo wivé an vil Jérouzalèm ");
INSERT INTO acfNT_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","épi yo mandé, “Koté ti manmay-la ki fèt-la ki ni pou vini wa sé Jwif-la? Nou wè étwal li an syèl-la épi nou ja vini pou adowéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Lè Wa Hèròd tann sa, i té kontwayé épi i té twakasé an chay, épi jan Jérouzalèm té twakasé tou. ");
INSERT INTO acfNT_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","I voyé kwiyé sé chèf pwèt-la épi sé titja lwa sé Jwif-la, épi i mandé yo, “Ki koté ti manmay sala sipozé fèt, Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Yo diʼy, “Sé an Bèfléyenm, an vilaj ki an Joudiya, paski mi sa Bondyé té fè pwòfèt-la ékwi, i di, ");
INSERT INTO acfNT_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Bèfléyenm sé yonn an sé pli enpòtan vil-la anpami sé vil Jouda-a, paski sé an vil sala wa-a kay sòti ki kay kondwi sé moun mwen-an, Izwayèl.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Kon sa Hèròd voyé kwiyé sé nonm-lan an sigwé, épi i mandé yo ègzaktiman ki lè yo wè étwal-la pawèt. ");
INSERT INTO acfNT_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Lè sala Hèròd voyé sé nonm-lan alé Bèfléyenm épi i di yo, “Alé chaché pou ti manmay-la byen, épi lè zòt jwenn li, vin di mwen pou mwen menm alé adowéʼy tou.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Lè Hèròd fin palé ba yo, sé nonm-lan pati. Menm étwal-la yo té wè an plas yo-a, sé menm étwal sala yo wè douvan yo, épi yo té kontan an chay. Yo swiv étwal-la, épi étwal-la kondwi yo dwèt asou kay-la koté ti manmay-la té yé-a, èk i doubout anlè kay-la. ");
INSERT INTO acfNT_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Lè yo antwé andidan-an, yo wè ti manmay-la épi manmanʼy, Mari. Yo ajounou épi yo adowéʼy. Yo ouvè sak yo épi yo ba li kado ki chè — yo ba li lò, frankinsens épi lanmi. ");
INSERT INTO acfNT_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Bondyé palé bay sé nonm-lan adan on wèv épi i di yo pou pa viwé ay di Hèròd yo jwenn ti manmay-la. Kon sa sé nonm-lan pasé adan an lòt chimen épi yo alé lakay yo. ");
INSERT INTO acfNT_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Apwé sé nonm-lan alé, on nanj Bondyé pawèt douvan Jozèf adan on wèv. I diʼy, “Pwan ti manmay-la épi manmanʼy èk ay wèsté Éjip tout tan mwen pa diʼw pou kité, paski Hèròd ka gadé pou ti manmay-la pouʼy sa tjwéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Jozèf lévé menm swè-a, i pwan ti manmay-la épi manman-an épi i alé Éjip, ");
INSERT INTO acfNT_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","èk i wèsté la pou jis tan Hèròd mò. Sa Bondyé té di pa pwòfèt-la vini fèt vwé. I di, “Mwen kwiyé gason mwen sòti Éjip.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Lè Hèròd wè sé nonm sòlèy lévan-an té kwennenʼy, i té faché an chay. I di sòldaʼy alé an vil Bèfléyenm épi an tout plas ki oliwonʼy épi tjwé tout ti gason ki dé lanné an désandan. I katjilé sé apipwé menm kantité tan sala i ni dépi sé nonm-lan té pwèmyé wè étwal-la pou vin apwézan. ");
INSERT INTO acfNT_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Épi tout sa pwòfèt Jérémaya té di-a vin fèt vwé. I di, ");
INSERT INTO acfNT_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Yo tann an gwo kwi ka fèt an Ranma, i té ni an pil pléwé la. Sété Rétjèl ki té ka pléwé bay ich li paski yo tjwé tout, épi i pa té vlé pyèsonn konsoléʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Apwé Hèròd mò, on nanj Bondyé palé bay Jozèf adan an wèv paditan i té Éjip. ");
INSERT INTO acfNT_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","I diʼy, “Lévé, pwan ti manmay-la èk manmanʼy épi déviwé an péyi Izwayèl, paski sé moun-an ki té ka gadé pou tjwé ti manmay-la ja mò.” ");
INSERT INTO acfNT_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","La menm Jozèf lévé, i pwan ti manmay-la èk manmanʼy épi i déviwé an péyi Izwayèl. ");
INSERT INTO acfNT_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mé lè i tann sé Akélòs ki wiplasé papaʼy Hèròd kon wa Joudiya, Jozèf té pè alé la. Bondyé palé ba li adan an wèv épi i diʼy ki sa pou fè. ");
INSERT INTO acfNT_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Jozèf vin alé adan an vil yo ka kwiyé Nazawèt an Galili épi i fè kay li la. Sé pwòfèt-la té di, “Yo kay kwiyéʼy an Nazawiyen.” Sé kon sa sa yo té di-a vin fèt vwé. ");
INSERT INTO acfNT_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Tibwen tan apwé sa, Jan Batis, nonm-lan ki té ka batizé sé moun-an, alé an hòtè an Joudiya épi i koumansé pwéché. ");
INSERT INTO acfNT_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","I di, “Tounen hòd péché zòt, paski Bondyé ka vini touswit pou kondwi sé moun li-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Sé konsèné Jan Batis pwòfèt Izaya té ka palé lè i té di, “Vwa on nonm ka kwiyé byen lwen an hòtè, i ka di, ‘Pwépawé chimen-an bay Senyè-a, fè twas ki dwèt pouʼy sa pasé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Had Jan Batis té fèt épi pwèl kanmèl, épi i té ni an sanng tjwi an wenʼy, épi i té ka manjé kwitjèt épi siwo myèl. ");
INSERT INTO acfNT_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Moun sòti an vil Jérouzalèm épi an tout ti kòt ki an Joudiya épi tout plas ki oliwon Lawivyè Jouden-an pou yo ay kouté Jan Batis. ");
INSERT INTO acfNT_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Yo konfésé péché yo épi Jan Batis batizé yo an Lawivyè Jouden-an. ");
INSERT INTO acfNT_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Mé lè Jan Batis wè an pil Fawizyen épi Sadisyen ka vini kotéʼy pouʼy batizé yo, i di yo, “Débann sèpan kon zòt yé! Ès ou kwè lè ou vini pou mwen batizéʼw, ou kay chapé anba pinisyon-an Bondyé kay bay sé moun-an ki mové-a? ");
INSERT INTO acfNT_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Viv adan an mannyè pou moun wè ou ja tounen hòd movèztéʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Épi pa kwè paski ou ka di ou sé désandan Abrahanm, sa kay chapéʼw anba pinisyon-an. Mwen ka diʼw, Bondyé sa pwan sé wòch sala épi fè yo vini ich Abrahanm pou wiplaséʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Bondyé ja tou pawé pou jijé moun, menm kon an hach ki tou pawé pou koupé sé pyé bwa-a an chous yo. Tout pyé bwa ki pa ka pòté bon fwi kay koupé épi jété an difé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Mwen batizéʼw épi dlo pou moutwé ou ja tounen hòd péchéʼw, mé moun-an ki kay vini apwé mwen-an ni pli pouvwa pasé mwen. Mwen pa menm vo pou pòté soulyéʼy. I kay batizéʼw épi Lèspwi Bondyé épi difé. ");
INSERT INTO acfNT_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","I ni bésin li an lanmenʼy épi i pawé pou vanné gwenn-an. Épi i kay mété sé gwenn-an i vanné-a an kay li, mé i kay bwilé sé pay-la adan an difé ki pa kay janmen tenn.” ");
INSERT INTO acfNT_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","An tan sala Jézi sòti an Galili épi i alé bò Lawivyè Jouden-an pou Jan Batis té batizéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Lè i wivé la, Jan Batis diʼy, “Pouki pouʼw mandé mwen pou batizéʼw? Sé ou ki sipozé batizé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Mé Jézi diʼy, “Kitéʼy fèt kon sa kou sala, paski i bon pou nou fè tout sa Bondyé mandé.” Lè i di sa, Jan Batis dakò pou batizéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Kon Jan Batis fin batizé Jézi, Jézi sòti an dlo-a, i wè syèl-la ouvè épi Lèspwi Bondyé désann kon yon toutwèl épi pozé asouʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Épi an vwa an syèl-la di, “Sa sé Gason mwen. Pa dé enmen mwen enmenʼy, épi mwen byen plè épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Apwé sa, Lèspwi Bondyé mennen Jézi an hòtè pou Denmou té tantéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Apwé i té wèsté la pou kawant (40) jou épi kawant swè san manjé, i té fen. ");
INSERT INTO acfNT_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Épi Denmou vini, i diʼy, “Ou sé Gason Bondyé, kouman. Ében, fè sé wòch sala tounen pen.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Mé Jézi wéponn èk i diʼy, “Lévanjil-la di, ‘Sé pa manjé tousèl nonm bizwen pou yo viv, mé yo bizwen obéyi tout pawòl ki sòti an bouch Bondyé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Apwé sa, Denmou mennen Jézi an Jérouzalèm, vil-la ki pou Bondyé yonn-an, épi i mennenʼy koté-a ki té pli ho asou tèt Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Épi i di Jézi, “Ou sé Gason Bondyé, kouman. Ében, jété kòʼw atè paski lévanjil-la di, ‘Bondyé kay konmandé sé nanj li-a pou yo véyéʼw. Yo kay pòtéʼw an lanmen yo, épi pa menm pyéʼw yo kay kité konyen asou an wòch.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Mé Jézi diʼy, “Lévanjil-la di osi, ‘Ou pa ni pou éséyé pou gadé sa Bondyé di i kay fè-a, si i kay fèʼy vwé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Lè sala Denmou mennen Jézi asou an tèt mòn ki ho an chay épi i moutwéʼy tout wéyòm ki an latè-a épi wichès yo. ");
INSERT INTO acfNT_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","I diʼy, “Mwen kay baʼw tout sa si ou ajounou épi adowé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Jézi diʼy, “Alé, sòt isi-a, Satan! Lévanjil-la di, ‘Sé Bondyé Senyè-a an moun ni pou adowé épi sé li yonn ou ni pou sèvi.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Lè Jézi diʼy sa, Denmou kitéʼy, épi nanj vini otjipé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Lè Jézi tann yo té mété Jan Batis an pwizon, i witounen Galili, ");
INSERT INTO acfNT_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","mé lè i wivé la, i pa wèsté Nazawèt. I alé wèsté Kapènéyòm, an vil ki bò Lanmè Galili-a, an bòn Zèbyoulonn épi Naftali. ");
INSERT INTO acfNT_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Sa fèt pou fè sa pwòfèt Izaya té di-a vini vwé. I di, ");
INSERT INTO acfNT_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Sé moun-an ki ka wèsté an tè Zèbyoulonn épi tè Naftali-a, asou chimen-an ki ka alé bò lanmè-a, bò Lawivyè Jouden-an, an plas Galili koté ki ni an chay moun ki pa Jwif ka wèsté-a — ");
INSERT INTO acfNT_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","sé moun sala té ka viv an nwèsè, mé atjwèlman yo ka wè an gwan klèté. Yo té ka viv an lavi péché ki kay fè yo péwi pou tout tan, mé atjwèlman yo kon moun ki ka wè an bèl klèté.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Dépi menm tan sala, Jézi té koumansé pwéché, i di, “Tounen hòd péché zòt, paski Bondyé ka vini touswit pou kondwi sé moun li-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Lè Jézi té ka pasé bò Lanmè Galili-a, i wè dé nonm, Simon, yo té ka kwiyé Pita, épi fwèʼy Androu. Yo té ka voyé lèpèvyé yo an lanmè-a, paski yo sété péchè. ");
INSERT INTO acfNT_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jézi di yo, “Swiv mwen épi mwen kay fè zòt péché lézòm pito.” ");
INSERT INTO acfNT_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Menm lè-a yo kité lèpèvyé yo épi yo pati épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Lè Jézi wivé pli douvan, i wè dé lézòt fwè, Jémz épi Jan, épi papa yo Zèbèdi. Yo té adan kannòt yo ka koud senn. I kwiyé sé fwè-a épi i di yo vin swiv li, ");
INSERT INTO acfNT_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","épi la menm yo kité kannòt-la èk papa yo épi yo pati alé épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jézi pasé an tout Galili, ka enstwi an légliz sé Jwif-la, épi i té ka di Bon Nouvèl-la ki Bondyé ka vini touswit pou kondwi sé moun li-an. Épi i djéwi tout sòt kalité maladi sé moun-an té ni. ");
INSERT INTO acfNT_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Moun pòté nouvèl-la jis an Siriya, épi yo mennen moun ki té ni tout sòt kalité maladi, moun ki té ni vyé lèspwi, sa ki té ni malkadi ka pwan yo, sa ki té enfim, épi Jézi djéwi yo tout. ");
INSERT INTO acfNT_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","An gwan popilas moun swiv li sòti Galili épi an Dis Vil-la épi vil Jérouzalèm épi Joudiya épi plas-la ki lòt bò Lawivyè Jouden-an. ");
INSERT INTO acfNT_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Lè Jézi wè tout sé moun sala, i mouté asou an mòn épi i asid èk disip li oliwonʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","épi i koumansé enstwi yo. I di yo, ");
INSERT INTO acfNT_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Pa dé bon i bon pou moun ki sav yo bizwen Bondyé, paski Bondyé ka kondwi yo èk tout pwonmèt li sé sa yo. ");
INSERT INTO acfNT_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Pa dé bon i bon pou moun ki an lapenn, paski Bondyé kay konfòté yo. ");
INSERT INTO acfNT_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Pa dé bon i bon pou moun ki abésé kò yo douvan Bondyé, paski yo kay éwityé tout sa Bondyé ja pwonmèt. ");
INSERT INTO acfNT_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Pa dé bon i bon pou moun ki anvi fè sa ki dwèt, paski Bondyé kay plen tjè yo èk bontéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Pa dé bon i bon pou moun ki ni konpasyon asou lézòt moun, paski Bondyé kay ni konpasyon asou yo tou. ");
INSERT INTO acfNT_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Pa dé bon i bon pou moun ki ni tjè nèt, paski yo kay wè Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Pa dé bon i bon pou moun ki ka twavay pou fè moun viv an lapé èk yonn èk lòt, paski Bondyé kay di, ‘Ou sé ich mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Pa dé bon i bon pou moun ki ka jwenn pèsikasyon paski yo ka viv dwèt. Bondyé ka kondwi yo épi tout pwonmèt li sé sa yo. ");
INSERT INTO acfNT_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Pa dé bon i bon pou ou lè moun ka ensiltéʼw épi ka pèsikitéʼw épi ka manti anlèʼw pou lapéti mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Sé kon sa yo té pèsikité sé pwòfèt-la ki té avanʼw-lan. Sé pouʼw kontan épi wéjwi, paski Bondyé ni péyimanʼw an syèl ka tjenbé baʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Jézi di sé disip-la, “Ou sé menm kon sèl pou lézòm. Mé si sèl-la ja pèd sistans li, la pa ni pyès mannyè i sa ni gou ankò. Ou pa sa sèviʼy pou anyen pasé jété dèwò, épi moun kay maché anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ou sé menm kon an klèté pou lézòm. An vil ki bati anlè tèt an mòn pa sa séwé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ni pyèsonn pa ka limen an lanp épi séwéʼy anba an bonm, mé ou kay météʼy asou tab-la, épi tout andidan kay-la kay jwenn klèté. ");
INSERT INTO acfNT_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Sé menm mannyè épi laviʼw. Sé pouʼw viv an mannyè pou tout moun wè sé bon twavay-la ou ka fè-a, épi yo kay onnowé Papaʼw Bondyé ki an syèl.” ");
INSERT INTO acfNT_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Jézi di, “Pa kwè mwen vini pou détwi sé lwa-a Bondyé té bay Moziz-la ében sa sé pwòfèt-la té ékwi an lévanjil-la. Mwen pa vini pou détwi yo, mé mwen vini pou moutwé sa yo vlé di pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sa mwen ka diʼw-la sé lavéwité: Anyen pa kay sòti an lwa-a tout tan la ni syèl épi latè. Pa pli piti ti pwen-an ni dènyé ti détay-la kay sòti an lwa-a pou jis tan tout sa i di ki kay fèt-la fèt vwé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ében, népòt moun ki pa obéyi pli piti-a an konmandman-an épi ka moutwé lézòt moun pou pa obéyiʼy tou, sé li ki kay mwens enpòtan anpami sé moun-an Bondyé ka kondwi-a. Mé okontwè, moun-an ki obéyi konmandman-an épi i moutwé lézòt moun pou yo obéyiʼy tou, sé li ki kay pli enpòtan anpami sé moun-an Bondyé ka kondwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ében mwen ka vètiʼw, si tjèʼw pa pli dwèt pasé tjè sé titja lwa-a épi sé Fawizyen-an, si ou pa fè tout sa Bondyé konmandé, ou pa kay sé yonn anpami sé moun-an Bondyé ka kondwi-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Jézi di, “Ou konnèt yo té ka di sé moun nou-an an tan lontan, ‘Pa tjwé, épi népòt moun ki tjwé, yo kay mennenʼy lodyans.’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ében atjwèlman mwen menm ka diʼw, si an fwè faché épi an lòt fwè, yo kay piniʼy pou sa. Si yon fwè kwiyé an lòt ‘Kochonni!’ yo kay jijéʼy douvan gwan konsèy sé Jwif-la, épi si yon fwè kwiyé an lòt ‘Kouyon!’ i an chimen pou bwilé an difé lanfè. ");
INSERT INTO acfNT_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Ében, si lè ou alé ofè kadoʼw bay Bondyé asou lotèl-la ou chonjé fwèʼw ni an chiz kont ou, ");
INSERT INTO acfNT_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","kité kado-a bò lotèl-la épi alé wanjé zafèʼw épi fwèʼw. Épi apwé, viwé ay ofè kadoʼw bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Si an moun pòté plent kont ou, sé pouʼw pwan wanjman épiʼy avan jou lodyans-lan, paski si ou kité jou sala wivé, lè i mennenʼw lodyans, sé douvan jij-la ou kay yé, épi jij-la kay ladjéʼw an lanmen polis, épi yo kay météʼw lajòl. ");
INSERT INTO acfNT_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Ében mwen ka diʼw, ou kay ni pou wèsté la pou jis tan ou péyé dènyé ti dé sou ou ka dwé. ");
INSERT INTO acfNT_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Ou konnèt yo té ka di sé moun nou-an an tan lontan, ‘Pa fè adiltè,’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","mé atjwèlman mwen menm ka diʼw, si ou gadé an madanm épi ou anvi kouché épiʼy, ou ja fè adiltè dépi tan an tjèʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Kon sa si zyé dwèt ou ka annékòz ou fè péché, tiwéʼy épi jétéʼy! I pli mèyè pouʼw pèdi zyéʼw pasé tout kòʼw alé lanfè. ");
INSERT INTO acfNT_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Si lanmen dwèt ou ka annékòz ou fè péché, koupéʼy épi jétéʼy! I pli mèyè pouʼw pèdi on lanmen pasé tout kòʼw alé lanfè. ");
INSERT INTO acfNT_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Yo té ka di ankò, népòt nonm ki dévosé madanm li té ni pou bay madanm li an lèt pou moutwé yo ja dévosé, ");
INSERT INTO acfNT_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","mé atjwèlman mwen menm ka diʼw, si an nonm dévosé madanm li pou pyès lòt wézon apa di si madanm-lan fè adiltè, nonm sala ka annékòz madanm-lan fè adiltè, épi nonm-lan ki mayé épiʼy-la ka fè adiltè tou. ");
INSERT INTO acfNT_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Ou konnèt ankò yo té ka di sé moun nou-an an tan lontan, ‘Si ou sèwmanté douvan Bondyé pouʼw fè on bagay, sé pouʼw fèʼy vwé.’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mé atjwèlman mwen menm ka diʼw, pa fè pyès sèman. Pa sèwmanté asou syèl-la, paski syèl-la sé koté Bondyé ka asid. ");
INSERT INTO acfNT_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Pa sèwmanté pa latè-a, paski latè-a sé koté Bondyé ka pozé pyéʼy. Épi pa sèwmanté pa Jérouzalèm, paski Jérouzalèm sé vil Bondyé, gwan wa-a. ");
INSERT INTO acfNT_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Pa menm fè sèman asou tèt ou nonplis, paski chivé-a ou ni an tèt ou-a, ou pa sa fè pyès vini blan ni viwé nwè. ");
INSERT INTO acfNT_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Lè ou kay fè on bagay, annèk di ‘Wi’ ében ‘Non.’ Pyès lòt bagay ou di ka sòti pa Satan.” ");
INSERT INTO acfNT_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Jézi di ankò, “Ou konnèt yo té ka di sé moun nou-an, ‘An zyé pou an zyé, an dan pou an dan.’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Mé atjwèlman mwen menm ka diʼw, pa pwan wivanj asou moun ki fèʼw mal. Si an moun baʼw an souflé asou fasad fidji dwèt-la, tounen lòt fasad-la ba li tou. ");
INSERT INTO acfNT_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Épi si an moun mennenʼw lodyans pou chimiz-la ou ni anlèʼw-la, ba li kanmizòl ou tou. ");
INSERT INTO acfNT_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Si an moun fòséʼw pòté chay li yon lyé, pòtéʼy dé lyé ba li. ");
INSERT INTO acfNT_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Si an moun mandéʼw an bagay, pa wifizé ba liʼy, épi si i mandéʼw pwétéʼy an bagay, pwétéʼy li. ");
INSERT INTO acfNT_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Ou konnèt yo té ka di, ‘Enmen janʼw épi hayi lèlmiʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Mé atjwèlman mwen menm ka diʼw, enmen lèlmiʼw épi pwédyé bay sé moun-an ki ka maltwétéʼw-la ");
INSERT INTO acfNT_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","pouʼw sa vini gason Papaʼw Bondyé ki an syèl, paski i ka fè sòlèy li kléwé asou ni bon ni mové, épi i ka voyé lapli asou ni bon ni mové. ");
INSERT INTO acfNT_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Ou pa sipozé èspéyé pouʼw jwenn péyiman an lanmen Bondyé si ou enmen janʼw tousèl. Jis sé bòbòlis-la ki ka anmasé taks-la ki ka fè sa. ");
INSERT INTO acfNT_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Épi si ou palé bay janʼw tousèl, ou ka fè menm kon lézòt moun ka fè. Ki péyiman ou méwité pou sa? Jis moun ki pa ka kwè an Bondyé ki ka fè sa. ");
INSERT INTO acfNT_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Sé pouʼw pawfé menm kon Papaʼw Bondyé ki an syèl pawfé. ");
INSERT INTO acfNT_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Pwan pokosyon pou pa fè bon twavay ou an piblik, pou moun wè ki sa ou ka fè. Si ou fè sa, ou pa kay jwenn pyès péyiman an lanmen Papaʼw Bondyé ki an syèl. ");
INSERT INTO acfNT_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Pou wézon sala, lè ou ka fè chawité, pa fèʼy pou tout moun wè, kon sé ipokwit-la ka fè an légliz sé Jwif-la épi asou lawi-a. Mwen ka asiwéʼw yo ja jwenn tout péyiman yo paski yo ka fè sa pou moun sa di ki kantité bon yo bon. ");
INSERT INTO acfNT_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Mé lè ou ka édé an moun ki maléwé, fèʼy adan an mannyè pou pa menm pli bon kanmawad ou konnèt. ");
INSERT INTO acfNT_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Kon sa kado-a ou bay-la kay wèsté an sigwé, épi Papaʼw Bondyé kay péyéʼw paski i ka wè tout sa ou fè an sigwé. ");
INSERT INTO acfNT_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Lè ou ka pwédyé, pa fè kon sé ipokwit-la. Yo enmen doubout èk pwédyé an légliz sé Jwif-la épi an lawi-a pou tout moun sa wè yo. Mwen ka asiwéʼw, yo ja jwenn péyiman yo. ");
INSERT INTO acfNT_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Mé lè ou ka pwédyé, antwé an chanm ou, fèmé lapòt-la, épi pwédyé bay Papaʼw Bondyé pyèsonn pa ka wè-a. Épi Bondyé ki ka wè tout sa ou fè an sigwé kay baʼw péyiman pou sa. ");
INSERT INTO acfNT_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Lè ou ka pwédyé, pa bat bouch ou ennitil kon sé moun-an ki pa konnèt Bondyé-a. Yo kwè yo kay wisivwè sa yo mandé paski yo ka pwédyé lonng. ");
INSERT INTO acfNT_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Pa pwédyé kon yo paski Papaʼw Bondyé ja konnèt tout sa ou bizwen avan ou mandéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Mi kalité lapwiyè-a pouʼw pwédyé: ‘Papa nou ki an syèl, nou ka pwédyé pou tout moun onnowéʼw kon Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nou ka pwédyé pou tout moun vini anba kondwit ou, épi pou tout moun obéyiʼw asou latè-a menm kon tout sa ki an syèl ka obéyiʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ban nou jòdi-a manjé-a nou bizwen-an. ");
INSERT INTO acfNT_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pawdonnen nou péché nou menm kon nou ka pawdonnen moun ki fè nou mové. ");
INSERT INTO acfNT_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Pa kité nou tonbé anba tantasyon, mé délivwé nou anba lanmen Denmou-an.’ ");
INSERT INTO acfNT_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Si ou pawdonnen moun ki fèʼw mové, Papaʼw Bondyé ki an syèl kay pawdonnen péchéʼw tou. ");
INSERT INTO acfNT_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Mé si ou wifizé pawdonnen moun-an ki fèʼw mové-a, Papaʼw Bondyé kay wifizé pawdonnen péchéʼw tou. ");
INSERT INTO acfNT_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Lè ou ka wèsté san manjé pouʼw adowé Bondyé, pa fè fidjiʼw lonng kon sé ipokwit-la ka fè. Yo ka fè kò yo gadé sonm pou moun sa wè yo ka wèsté san manjé. Mwen ka asiwéʼw, yo ja jwenn péyiman yo. ");
INSERT INTO acfNT_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Mé lè ou ka wèsté san manjé, lavé fidjiʼw épi byen penyen chivéʼw ");
INSERT INTO acfNT_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","pou moun pa sav ou ka wèsté san manjé. Mé Papaʼw Bondyé pyèsonn pa ka wè-a, sé li yonn ki kay sav. Épi sé li ki ka wè tout sa ki ka fèt an sigwé, épi i kay baʼw péyimanʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Pa sové tout wichès ou asou latè-a koté wavèt pé manjéʼy épi lawouj pé pwanʼy, koté vòlè sa kasé kay ou pou vòlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mé mété wichès ou an syèl koté wavèt épi lawouj pa sa jwenn li, épi koté vòlè pa sa kasé pou vòlèʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","paski koté wichès ou yé, sé la tjèʼw kay yé tou. ");
INSERT INTO acfNT_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Zyéʼw sé menm kon klèté pou kòʼw. Si zyéʼw bon, tout kòʼw kay an klèté, ");
INSERT INTO acfNT_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","mé si zyéʼw pa bon, tout kòʼw kay an nwèsè. Si klèté-a ki andidanʼw-lan sé nwèsè, sé pa ti nwèsè ki andidanʼw! ");
INSERT INTO acfNT_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Pyès moun pa sa an sèvant pou dé diféwan mèt. Swé i hayi yonn épi kontan lòt-la, ében i kay ni pou ladjé yonn épi tjenbé lòt-la. Ou pa sa an sèvant pou Bondyé épi an sèvant pou lajan an menm di tan-an. ");
INSERT INTO acfNT_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Sé pou sa mwen ka diʼw, pa twakasé lidéʼw pou manjé ében bwè pouʼw viv, ében had pouʼw mété. Mwen ka asiwéʼw, laviʼw pli enpòtan pasé manjé, épi kòʼw pli enpòtan pasé had-la ou ka mété-a. Si Bondyé ja baʼw sé bagay-la ki pli enpòtan-an, ès i pa kay baʼw sé pli piti-a ou bizwen-an tou? ");
INSERT INTO acfNT_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Gadé sé jibyé-a ki an lézè-a. Yo pa ka planté ni yo pa ka wékòlté épi mété sé gwenn-an la pou apwé, mé Papaʼw Bondyé ka ba yo manjé. Mwen ka diʼw, ou ni twòp pli valè pasé sé jibyé sala. ");
INSERT INTO acfNT_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ou pa ka viv pli lontan lè ou twakasé lidéʼw asou sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Pouki ou ka twakasé lidéʼw pou had pouʼw mété? Gadé sé flè-a ki an savann-an. Yo pa ka twavay ni yo pa ka fè had pou mété anlè yo. ");
INSERT INTO acfNT_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Mé mwen ka diʼw, pa menm Wa Sòlomonn épi tout wichès li ki té ni bèl had kon yonn an sé flè sala. ");
INSERT INTO acfNT_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Sé Bondyé ki ka abiyé sé zèb-la ki an savann-an, sé zèb-la ki la jòdi-a épi denmen yo pa la. Yo ka koupéʼy pou chofé fou. Ès Bondyé pa kay pwan kaʼw pli mèyè pasé sé zèb-la ki an savann-an? Pa dé fèb lafwaʼw fèb! ");
INSERT INTO acfNT_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Pa twakasé lidéʼw asou ki sa ou kay manjé ében bwè, ében ki sa ou kay mété anlèʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Sé moun-an ki pa konnèt Bondyé-a yonn ki ka twakasé lidé yo pou sé bagay sala. Papaʼw Bondyé sav ou bizwen tout sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Mé kité Bondyé kondwi laviʼw avan, épi fè tout sa i vléʼw fè, épi i kay baʼw tout sé lézòt bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Pa twakasé lidéʼw pou denmen. Ou kay ni asé twakasman lè denmen wivé. Pa pwan twaka denmen épi météʼy asou sa jòdi-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Jézi di, “Pa jijé lòt moun, épi Bondyé pa kay jijéʼw, ");
INSERT INTO acfNT_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","paski Bondyé kay baʼw menm jijman-an ou ka bay lézòt moun-an. Épi menm mizi-a ou ka miziwé lézòt-la, sé menm mizi sala Bondyé kay sèvi pou miziwéʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","“Pouki ou ka wè ti bwanch pay-la ki an zyé fwèʼw-la épi ou pa ka wè gwo bi bwa-a ki an zyéʼw-la? ");
INSERT INTO acfNT_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ében, pouki pouʼw di fwèʼw, ‘Kité mwen tiwé ti bwanch pay-la baʼw,’ lè ou menm ni an gwo tjò bwa andidan sa ou? ");
INSERT INTO acfNT_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ou ipokwit! Pwèmyéman tiwé gwo tjò bwa-a ki an zyéʼw-la. Apwé sa, ou kay sa wè pli klè pouʼw sa tiwé ti pay-la ki an zyé fwèʼw-la. ");
INSERT INTO acfNT_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Pa pwan bagay ki pou Bondyé yonn épi bay moun ki pa ka apwésyéʼy. I menm kon si ou jété bagay ki vo valè douvan kochon épi chyen. Yo kay annèk piléʼy anba pat yo èk yo kay tounen viwé èk mòdéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Jézi di, “Mandé Bondyé pou sa ou bizwen épi ou kay twapéʼy. Chaché épi ou kay jwenn. Konyen lapòt-la épi Bondyé kay ouvèʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","paski tout sa ki mandé kay wisivwè, tout sa ki chaché kay jwenn, épi Bondyé kay ouvè lapòt-la bay tout sa ki konyen. ");
INSERT INTO acfNT_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Pyès papa pa kay bay ich li an wòch lè i mandéʼy an pen. ");
INSERT INTO acfNT_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ében si ich-la mandéʼy an pwéson, ou kwè i kay ba li an sèpan? ");
INSERT INTO acfNT_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Si ou ki otan méchan konnèt bay ich ou bon bagay, ou sa asiwé Papaʼw Bondyé ki an syèl kay bay pli bon bagay pou moun-an ki mandéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Fè bay lézòt moun menm sa ou kay vlé yo fè baʼw. Si ou ka fè sa, ou ka fè tout sa lwa Moziz-la épi sé pwòfèt-la ka di pou fè. ");
INSERT INTO acfNT_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Antwé an bayè-a ki étwèt-la, paski bayè-a ki ka mennenʼw lanfè-a gwan épi chimen-an ézé, épi an chay moun ka maché asou chimen sala. ");
INSERT INTO acfNT_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Mé bayè-a ki ka mennenʼw an lavi étonnèl-la étwèt épi chimen-an pa ézé, épi byen pé moun ki ka jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Sé pouʼw véyé kòʼw épi sé fo pwòfèt-la ki ka vin palé ba ou-a paski yo ka vini dous kon mouton, mé ofon tjè yo, yo menm kon chyen mawon ki ka vini pou manjéʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ou kay konnèt yo pa kalité fwi-a yo ka pòté-a. Ou pa sa jwenn wézen asou an pyé pikan ni ou pa sa jwenn fig asou an pyé kanpèch. ");
INSERT INTO acfNT_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","An bon pyé fwi kay pòté bon fwi, mé an vyé pyé fwi kay pòté vyé fwi. ");
INSERT INTO acfNT_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","An bon kalité pyé bwa pa sa pòté vyé kalité fwi épi an vyé kalité pyé bwa pa sa pòté bon kalité fwi. ");
INSERT INTO acfNT_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Népòt pyé fwi ki pa ka pòté bon fwi, ou ka koupéʼy èk jétéʼy an difé. ");
INSERT INTO acfNT_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Sé menm mannyè-a ou kay konnèt sé fo pwòfèt-la pa sa yo ka fè.” ");
INSERT INTO acfNT_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Jézi di, “Sé pa tout moun ki kwiyé mwen ‘Mèt, Mèt’ ki kay vini anba kondwit mwen, mé sé sèlman sa ki fè sa Papa mwen ki an syèl-la vléʼy fè. ");
INSERT INTO acfNT_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Lè jou jijman-an kay vini, an chay moun kay di mwen, ‘Mèt, Mèt, pa pouvwaʼw nou té di moun konmisyonʼw, pa pouvwaʼw nou té tiwé vyé lèspwi épi pa pouvwaʼw nou té fè an chay miwak,’ ");
INSERT INTO acfNT_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","mé mwen kay di yo, ‘Mwen pa té janmen konnèt ou! Sòti douvan mwen, débann méchan!’ ");
INSERT INTO acfNT_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ében mwen ka diʼw, népòt moun ki tann sé pawòl sala mwen ka di la-a épi i obéyiʼy, i menm kon an nonm lèspwi ki fè kay li asou kayè. ");
INSERT INTO acfNT_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Épi lapli tonbé, lawivyè gwo, épi van-an vanté asou kay-la, mé kay-la pa tonbé paski i té fèt asou kayè. ");
INSERT INTO acfNT_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Épi népòt moun ki tann sé pawòl-la mwen ka di-a épi i pa obéyiʼy, i menm kon an nonm kouyon ki fè kay li asou sab. ");
INSERT INTO acfNT_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Épi lapli tonbé, lawivyè gwo, épi van-an vanté asou kay-la, épi kay-la tonbé épi an gwo dézòd!” ");
INSERT INTO acfNT_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Lè Jézi fin di sé moun-an tout sé bagay sala, yo tout té sipwi pou yo té wè mannyè i té ka enstwi. ");
INSERT INTO acfNT_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","I té ka enstwi kon moun ki ni dwa pou di moun ki sa pou yo fè, mé pa kon sé titja lwa sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Lè Jézi désann mòn-an, an gwan latilyé moun té ka swiv li. ");
INSERT INTO acfNT_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","La té ni an nonm ki té malad an lapoʼy ki vini douvanʼy, épi i ajounou an pyéʼy épi i di, “Mèt, si ou vlé ou sa djéwi mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jézi lonjé lanmenʼy épi i touché nonm-lan èk i di, “Wi, mwen vlé djéwiʼw,” épi menm lè-a i té djéwi. ");
INSERT INTO acfNT_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jézi diʼy, “Gadé! Pa ay simen sa, mé alé épi kité pwèt-la ègzanminéʼw épi ofè sakwifis-la Moziz té di pou ofè-a pou tout moun sa wè ou djéwi vwé.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Lè Jézi wivé an vil Kapènéyòm, an ofisyé militè Ronm vini mandéʼy soukou. ");
INSERT INTO acfNT_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","I diʼy, “Mèt, sèvant mwen kouché lakay épi i pa sa lévé, i ka soufè an chay.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Jézi diʼy, “Ében, annou! Mwen kay alé djéwiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Mé i di, “Non, Mèt. Mwen pa vo pouʼw antwé andidan kay mwen. Annèk di pawòl-la, épi sèvant mwen kay djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","I di Jézi, “Mwen menm tou ni nonm anho mwen épi mwen ni nonm ki anba mwen, épi mwen ka di sala, ‘Alé,’ épi i ka alé, épi mwen ka di lòt-la, ‘Vini,’ épi i ni pou vini, épi mwen ka di sèvant ki lakay mwen, ‘Fè sa,’ épi i ni pou fèʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Lè Jézi tann sa, i té sipwi an chay épi i di sé moun-an ki té ka swiv li-a, “Mwen ka di zòt pou vwé, anpami tout sé Jwif-la ki Izwayèl-la, mwen pa janmen jwenn pyèsonn ki ni lafwa kon nonm sala ki pa Jwif-la! ");
INSERT INTO acfNT_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Mwen ka asiwéʼw, lè lè-a kay vini pou Bondyé kondwi sé moun li-an, an chay moun ki pa Jwif kay sòti toupatou an latè-a épi yo kay asid épi Abrahanm, Ayzak épi Jakòb pou yo manjé an gwan fèsten Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Mé lè sé Jwif-la ki pa anba kondwit Bondyé kay vini, Bondyé kay jété yo dèwò an nwèsè, épi sa kay fè yo lapenn an chay, épi yo kay pléwé épi yo kay kwatjé dan yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Jézi di ofisyé-a, “Paski ou kwè mwen sa djéwi sèvant ou-a si mwen annèk di pawòl-la, alé épi mwen kay fèʼy baʼw.” Épi sèvant-lan té djéwi menm lè Jézi di sa-a. ");
INSERT INTO acfNT_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Lè Jézi antwé lakay Pita, i jwenn bèlmè Pita kouché malad épi an lafyèv. ");
INSERT INTO acfNT_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jézi touché lanmenʼy, épi menm lè-a lafyèv-la kitéʼy, épi madanm-lan lévé épi i koumansé pwépawé manjé ba li. ");
INSERT INTO acfNT_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Lè sòlèy kouché, yo mennen an chay moun ki té ni vyé lèspwi bay Jézi, épi i konmandé sé vyé lèspwi-a pou sòti andidan yo. Épi i djéwi tout moun ki té malad. ");
INSERT INTO acfNT_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","I fè sa pou sa pwòfèt Izaya té di-a té vin fèt vwé, i té di, “I menm tiwé nou anba tout maladi nou épi i pòté yo alé.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Lè Jézi wè tout sé moun sala oliwonʼy, i di sé disip li-a, “Annou alé lòt bò Lanmè Galili-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","A menm lè-a an titja lwa sé Jwif-la vini douvan Jézi épi i di, “Mèt, mwen kay alé épiʼw népòt koté ou kay alé.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jézi diʼy, “Zannimo mawon ni koté pou yo wèsté, épi jibyé ki ka volé an lézè-a ni nich, mé Gason Lézòm-lan pa menm ni on koté pouʼy kouché épi pozé tèt li.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","An lòt disip Jézi di, “Mèt, mwen kay swiv ou, mé kité mwen alé ay téwé papa mwen avan.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Mé Jézi diʼy, “Swiv mwen épi kité sé mò-a téwé mò yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jézi épi sé disip li-a pati abò an kannòt, ");
INSERT INTO acfNT_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","épi san yo té ka èspéyé, an mové tan lévé paditan yo té asou lanmè-a, épi lanm koumansé kouvè kannòt-la. Paditan tout sa té ka fèt, Jézi menm té ka dòmi. ");
INSERT INTO acfNT_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Lè sé disip-la wè sa, yo lévé Jézi épi yo diʼy, “Mèt, sové nou! Nou ka néyé!” ");
INSERT INTO acfNT_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Jézi di yo, “Pouki pou lafwa zòt fèb otan pou zòt pè kon sa?” Jézi lévé épi i konmandé van-an épi lanmè-a, épi menm lè-a mové tan-an doubout. ");
INSERT INTO acfNT_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Lè sé disip-la wè sa, yo té sipwi an chay! Yo di, “Ki kalité nonm misyé yé? Jis lanmè-a épi van-an obéyiʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Lè Jézi wivé lòt bò Lanmè Galili-a, bò vil Gadara-a, i jwenn dé nonm ki té ka wèsté adan sé twou kayè-a koté sé jan vil-la té ka téwé sé moun mò-a. Sé nonm-lan té ni vyé lèspwi andidan yo épi yo té tèlman danjéwé, tout moun té pè pasé asou chimen sala. ");
INSERT INTO acfNT_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Kon yo wè Jézi, yo kwiyé byen fò, “Ou, Gason Bondyé, ki sa ou vin chaché dèyè nou? Ès ou vini pou ban nou pinisyon avan jou jijman-an wivé?” ");
INSERT INTO acfNT_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Adan on distans té ni tibwen kochon ka manjé. ");
INSERT INTO acfNT_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kon sa sé vyé lèspwi-a plédé épi Jézi, “Si ou kay tiwé nou andidan dé nonm sala, kité nou antwé andidan sé kochon-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jézi di yo, “Alé!” Épi sé vyé lèspwi-a antwé andidan sé kochon-an, épi tout sé kochon-an kouwi désann adan an kaskou épi yo tonbé an lanmè-a épi yo tout néyé. ");
INSERT INTO acfNT_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Lè sé nonm-lan ki té ka otjipé kochon-an wè sa, yo mété kouwi an vil-la épi yo di tout moun sa ki wivé dé nonm-lan ki té ni vyé lèspwi andidan yo-a. ");
INSERT INTO acfNT_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Kon sa tout sé jan vil-la alé dèyè Jézi épi yo plédé épiʼy pou kité plas-la. ");
INSERT INTO acfNT_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Jézi antwé andidan kannòt-la épi i viwé Kapènéyòm, vil-la koté i té ka wèsté-a. ");
INSERT INTO acfNT_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Déotwa nonm mennen an nonm ki enfim anlè an hanmak bay Jézi pouʼy djéwiʼy. Lè Jézi wè otan lafwa yo té ni, i di nonm-lan, “Pwan tjè, gason mwen! Mwen pawdonnen péchéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Lè adan sé titja lwa sé Jwif-la tann sa, yo koumansé di bay yonn a lòt, “Nonm sala ka ensilté Bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mé Jézi té konnèt lidé yo épi i di, “Pouki zòt ka katjilé mové bagay kon sa? ");
INSERT INTO acfNT_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Kilès ki pli ézé pou di, ‘Mwen pawdonnen péchéʼw,’ ében ‘Lévé maché?’ ");
INSERT INTO acfNT_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ében, mwen kay moutwé zòt mwen Gason Lézòm-lan ni pouvwa asou latè-a pou pawdonnen péché.” Èvèk i di nonm-lan, “Lévé, pwan hanmak ou épi alé lakay ou!” ");
INSERT INTO acfNT_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Épi nonm-lan lévé épi i alé lakay li. ");
INSERT INTO acfNT_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Lè sé moun-an ki té la-a wè sa, yo té sipwi an chay épi yo glowifyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Lè Jézi kité koté i té yé-a, i wè an nonm yo té ka kwiyé Mafyou ki té asid adan an ti òfis ka anmasé taks. Jézi diʼy, “Vin swiv mwen,” épi menm lè-a Mafyou lévé épi i swiv li. ");
INSERT INTO acfNT_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Paditan Jézi té ka manjé lakay Mafyou, an chay moun ki té ka fè menm twavay èk Mafyou épi lézòt moun ki té ni vyé wépitasyon té vin manjé épi Jézi èk sé disip-la. ");
INSERT INTO acfNT_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Déotwa Fawizyen wè sa épi yo mandé sé disip Jézi-a, “Pouki mèt zòt ka manjé èk kalité sé moun sala?” ");
INSERT INTO acfNT_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Lè Jézi tann sa, i di, “Moun ki an santé pa bizwen dòktè, mé moun ki malad bizwen an dòktè. ");
INSERT INTO acfNT_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Alé gadé sa ki ékwi an lévanjil-la lè Bondyé di, ‘Sé bonté mwen vlé zòt fè, pa sakwifis zannimo.’ Mwen pa vini an latè-a pou moun ki dwèt, mé pou sé péchè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Sé disip Jan Batis-la vini dèyè Jézi épi yo mandéʼy, “Ki mannyè nou épi sé Fawizyen-an ka wèsté san manjé sèten jou pou moutwé nou ka adowé Bondyé, mé sé disip ou-a pa janmen fèʼy?” ");
INSERT INTO acfNT_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jézi wéponn yo épi i di, “Ès ou kwè sé kanmawad misyé-a ki ka mayé-a ka an lapenn tout tan i la épi yo? Mé non! Jou-a kay vini lè moun kay pwan misyé-a ki ka mayé-a anpami yo, sé lè sala yo kay wèsté san manjé paski yo kay an lapenn.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jézi di yo an pawabòl ankò, i di, “Pyèsonn pa ka pyèsté an vyé had épi an pyès nèf. Paski lè ou mété an pyès nèf anlè an vyé had épi ou lavé had sala, pyès nèf-la kay étwési épi i kay déchiwé had-la, épi la kay ni an pli gwo twou pasé i té ni. ");
INSERT INTO acfNT_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Ni ou pa ka pwan diven ou fin fè épi météʼy adan an vyé boutèy. Si ou fè sa, diven-an kay pété vyé boutèy-la, épi tout diven-an kay koulé atè, épi ou kay pèd ni boutèy-la ni diven-an. Mé si ou météʼy adan an boutèy ki nèf menm kon diven-an, ni boutèy-la ni diven-an kay pwézèvé.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Paditan Jézi té ka di yo sa, an ofisyé Jwif vini épi i ajounou douvanʼy. I di, “Mèt, ti fi mwen-an mò atjwèlman-an la. Vini pouʼw sa mété lanmenʼw anlèʼy, épi i kay viwé viv ankò.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Kon sa Jézi épi sé disip li-a lévé épi yo pati épi nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Menm lè-a an madanm ki té ka pèd san pou douz lanné vini pa dèyè Jézi épi i touché bout had li. ");
INSERT INTO acfNT_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Madanm-lan té di bay kòʼy, “Si mwen té kay sa touché bout had li sèlman, mwen té kay djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Jézi tounen épi i wè madanm-lan. I diʼy, “Pwan tjè, ich mwen! Lafwaʼw ja djéwiʼw!” Épi madanm-lan djéwi menm lè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Lè Jézi mouté lakay ofisyé Jwif-la, i wè sé mizisyen-an ki vini pou lètèman-an épi tout sé moun-an la ka fè dézòd. ");
INSERT INTO acfNT_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","I di, “Tout moun, alé dèwò paski ti manmay-la pa mò, dòmi i ka dòmi!” Lè i di yo sa, yo koumansé pwanʼy sèvi widitjil. ");
INSERT INTO acfNT_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Apwé yo mété tout sé moun-an dèwò, Jézi antwé an chanm-lan koté ti fi-a té yé-a épi i tjenbé lanmenʼy, épi ti fi-a lévé. ");
INSERT INTO acfNT_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Épi nouvèl-la simen toupatou an plas-la. ");
INSERT INTO acfNT_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Kon Jézi té ka kité plas-la koté i té yé-a, dé nonm avèg swiv li épi yo koumansé hélé. Yo di, “Jézi, désandan Wa David, ni konpasyon asou nou!” ");
INSERT INTO acfNT_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Lè Jézi antwé an kay-la, yo vini dèyèʼy. Jézi di yo, “Ès zòt kwè mwen sa djéwi zòt?” Yo di, “Wi, Mèt.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Lè sala Jézi touché zyé yo épi i di, “Sa zòt kwè-a mwen kay fèʼy bay zòt vwé,” ");
INSERT INTO acfNT_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","épi menm lè-a yo vin wè klè. Jézi vèti yo byen sèwyé, i di, “Pa alé di pyèsonn sa.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Mé yo alé épi yo simen sa toupatou an plas-la. ");
INSERT INTO acfNT_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Paditan dé nonm-lan ki té avèg-la té ka alé, déotwa moun mennen an nonm ki té moumou pa an vyé lèspwi bay Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Menm kon Jézi tiwé vyé lèspwi-a, nonm-lan koumansé palé. Tout moun té sipwi épi yo di, “Nou pʼòkò janmen wè anyen fèt kon sa an Izwayèl!” ");
INSERT INTO acfNT_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Mé sé Fawizyen-an di, “Chèf sé vyé lèspwi-a ki ka ba li pouvwa pou tiwé vyé lèspwi.” ");
INSERT INTO acfNT_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jézi pasé an tout sé vil-la épi an sé ti vilaj-la ki an Galili-a. I té ka enstwi an sé légliz sé Jwif-la épi i té ka pwéché Bon Nouvèl-la bay sé moun-an konsèné mannyè Bondyé ka kondwi, épi i djéwi moun ki té ni tout sòt kalité maladi. ");
INSERT INTO acfNT_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Lè Jézi wè tout sé moun sala, tjèʼy fèʼy mal pou yo paski yo té an twaka épi yo pa té ni pyèsonn pou édé yo. Yo té menm kon mouton ki pa ni gadyenn. ");
INSERT INTO acfNT_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","I di sé disip li-a, “Sé moun sala menm kon gwenn ki ja pawé pou anmasé, mé la ni byen pé twavayè pou sa anmasé sé gwenn sala. ");
INSERT INTO acfNT_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Pwédyé bay Bondyé, mèt jaden-an, pouʼy sa voyé twavayè pou anmasé sé gwenn sala.” ");
INSERT INTO acfNT_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jézi kwiyé douz disip li-a ansanm épi i ba yo pouvwa pou tiwé vyé lèspwi épi pou djéwi tout kalité maladi. ");
INSERT INTO acfNT_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Mi sé non sé douz zapòt-la: Pwèmyé-a sé Simon yo té ka kwiyé Pita, épi fwèʼy Androu. La té ni Jémz épi fwèʼy Jan, dé gason Zèbèdi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","La té ni Filip épi Batolonmi, Tonmas épi Mafyou, nonm-lan ki té ka anmasé taks-la. La té ni Jémz, gason Alfiyòs-la, épi Tadiyòs. ");
INSERT INTO acfNT_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","La té ni Simon, an manm an patizan Zèlòt-la, épi la té ni Jida Iskariyòt ki té kay twayi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jézi voyé sé douz nonm sala alé, mé avan yo alé i konmandé yo, “Pa alé adan pyès sé vil sé moun-an ki pa Jwif-la ni an sé vil Sanmariya-a, ");
INSERT INTO acfNT_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","mé alé pito anpami sé jan Izwayèl-la ki ja kité Bondyé-a, ki menm kon mouton ki pèd mèt yo. ");
INSERT INTO acfNT_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ay pwéché ba yo épi di yo, ‘Bondyé ka vini touswit pou kondwi.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Jézi di yo, “Djéwi moun ki malad, wésisité moun mò, djéwi moun ki ni maladi lapo, épi tiwé vyé lèspwi andidan moun. Ou ja wisivwè pouvwa sala pou anyen, kon sa alé fè sé bagay sala bay moun san péyiman. ");
INSERT INTO acfNT_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Lè ou ka alé, pa alé épi pyès lajan an pòch ou. ");
INSERT INTO acfNT_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Pa mennen on sak ki ni manjé pouʼw manjé, ni lòt chimiz ében soulyé, ében on baton, paski sé moun-an ou kay alé édé-a sipozé baʼw tout sa ou bizwen. ");
INSERT INTO acfNT_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Lè ou wivé adan on vil ében on vilaj, gadé pou an bon moun ki kay kontan pouʼw sa wèsté lakay li, épi wèsté épiʼy pou jis lè ou pawé pou alé. ");
INSERT INTO acfNT_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Lè ou antwé adan an kay, di, ‘Bennédiksyon Bondyé anlè jan kay sala.’ ");
INSERT INTO acfNT_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Si sé moun-an ki an kay-la kontan pouʼw sa wèsté andidan kay sala, bennédiksyon-an kay wèsté an kay-la. Mé si yo pa vléʼw wèsté an kay-la, bennédiksyon-an kay witounen épiʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Si moun adan on kay ében adan on vil pa vlé wisivwèʼw, ni kouté sa ou ni pou di yo, soukwé lapousyè pyéʼw épi alé, pou moutwé yo ja péché paski yo wifizé koutéʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Épi mwen ka asiwéʼw, jou jijman-an Bondyé kay pini sé moun sala pli mové pasé sé moun Sòdonm épi Gomòra-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Jézi di sé disip li-a, “Kouté, mwen ka voyéʼw menm kon mouton anpami chyen mawon. Ou sipozé malis menm kon an sèpan, épi dous kon an toutwèl. ");
INSERT INTO acfNT_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mé pwan pokosyon! La kay ni nonm ki kay awétéʼw épi yo kay mennenʼw lodyans épi yo kay bat ou èk fwèt an sé légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Pou lapéti mwen moun kay tjenbéʼw épi kay mennenʼw lodyans douvan gouvènè épi wa, épi sa kay baʼw an chans pou di yo épi nasyon yo Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Lè yo mennenʼw lodyans, pa katjilé ki sa pouʼw di, ni ki mannyè pouʼw diʼy, mé lè lè-a wivé, Bondyé kay diʼw ki sa pou di, ");
INSERT INTO acfNT_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","paski sé pawòl-la ou kay palé-a sé pa sa ou, mé sé Lèspwi Bondyé ki kay baʼw pawòl-la pou palé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Fwè kay twayi fwè yo épi fè yo kondanné yo pou lanmò. Papa kay fè ich yo menm bagay-la, épi ich kay tounen kont manman épi papa, épi fè yo kondanné yo pou lanmò. ");
INSERT INTO acfNT_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Tout moun kay hayiʼw pou lapéti mwen, mé Bondyé kay sové tout moun ki tjenbé fò pou jis an bout-la. ");
INSERT INTO acfNT_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Lè yo pèsikitéʼw adan an vil, kouwi adan an lòt. Mwen ka asiwéʼw, ou pa kay ni tan pasé adan tout vil ki an péyi Izwayèl avan Gason Lézòm-lan vini. ");
INSERT INTO acfNT_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“An titja pli enpòtan pasé moun-an i ka enstwi-a, épi mèt-la pli enpòtan pasé sèvant li. ");
INSERT INTO acfNT_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Moun-an titja-a ka enstwi-a sipozé vini menm kon titjaʼy, épi sèvant-lan sipozé vini menm kon mèt li. Si yo ka kwiyé mwen ki mèt kay-la vyé non kon Bèlzibòb, yo kay kwiyé zòt, sé jan kay-la, pli mové non pasé sa. ");
INSERT INTO acfNT_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ou pa ni pou pè lèlmiʼw, paski tan-an ka vini lè tout bagay moun té fè an sigwé kay pawèt aklè pou tout moun wèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Sa mwen ka diʼw an sigwé, sé pouʼw wépétéʼy an piblik, épi sa mwen ja diʼw an séwan, sé pouʼw mouté asou tèt kay-la épi héléʼy fò. ");
INSERT INTO acfNT_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Pa pè sé moun-an ki sa tjwé kò-a mé ki pa sa tjwé lam-lan. Pè Bondyé pito ki sa détwi ni lam-lan épi kò-a an lanfè. ");
INSERT INTO acfNT_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ès dé ti jibyé pa ka vann pou dé sou? Épi pa menm yonn an sé ti jibyé sala ki ka tonbé atè si Papaʼw Bondyé pa vlé sa fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mé Bondyé jis konnèt konmen bwanch chivé ki an tèt ou. ");
INSERT INTO acfNT_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Kon sa pa pè! Ou ni pli valè pasé an chay jibyé! ");
INSERT INTO acfNT_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Si an moun di an piblik i sé disip mwen, mwen kay di menm bagay-la ba li douvan Papa mwen ki an syèl. ");
INSERT INTO acfNT_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Mé si an moun widjèkté mwen an piblik, mwen kay widjèktéʼy menm mannyè-a douvan Papa mwen ki an syèl. ");
INSERT INTO acfNT_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Pa kwè mwen vini pou mennen lapé an latè-a. Non, mwen pa vini pou mennen lapé, mé mwen vini pou mennen divizyon. ");
INSERT INTO acfNT_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Mwen vini pou fè gason tounen kont papa yo, fi tounen kont manman yo, épi bèlfi tounen kont bèlmè yo. ");
INSERT INTO acfNT_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Sé jan kay an nonm ki kay pli mové lèlmiʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Népòt moun ki enmen papaʼy ében manmanʼy plis pasé mwen pa vo pou sé disip mwen, épi népòt moun ki enmen fiʼy ében gasonʼy plis pasé mwen pa vo pou sé disip mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Moun-an ki pa pwan kwaʼy èk swiv mwen-an pa vo pou disip mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Népòt moun ki vlé sové laviʼy kay pèdi lavi étonnèl, mé népòt moun ki pèdi laviʼy pou lapéti mwen kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Népòt moun ki wisivwèʼw wisivwè mwen, épi népòt moun ki wisivwè mwen wisivwè Bondyé ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Népòt moun ki wisivwè an pwòfèt paski i sé an pwòfèt kay jwenn menm péyiman épi pwòfèt-la. Épi népòt moun ki wisivwè an nonm ki dwèt paski nonm sala dwèt kay jwenn menm péyiman épi nonm dwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Mwen ka asiwéʼw, menm sé an pòt dlo fwèt an moun bay yonn an sé pli piti disip mwen-an paski i sé disip mwen, moun sala kay jwenn péyimanʼy pou sa.” ");
INSERT INTO acfNT_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Lè Jézi fin bay douz disip li-a sé lison sala, i kité koté i té yé-a épi i alé enstwi épi pwéché adan sé vil-la ki té an Galili-a. ");
INSERT INTO acfNT_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Paditan Jan Batis té an pwizon, i tann tout sé bagay-la Jézi Kwi té ka fè-a épi i voyé dé disip li alé ");
INSERT INTO acfNT_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","mandé Jézi, “Ès ou sé Mèsaya-a Bondyé té pwonmèt pou voyé-a ében ès nou ni pou kontiné gadé pou an lòt moun?” ");
INSERT INTO acfNT_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jézi di yo, “Alé di Jan Batis ki sa ou ka wè épi tann. ");
INSERT INTO acfNT_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Moun ki té avèg ka wè, sa ki té enfim ka maché, sa ki té ni maladi lapo ka djéwi, sa ki té soud ka tann, sa ki té mò ka wésisité, épi moun ki maléwé ka tann Bon Nouvèl Bondyé-a ka pwéché ba yo. ");
INSERT INTO acfNT_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Pa dé bon i bon pou moun-an ki pa pèdi lafwaʼy an mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Paditan sé disip Jan Batis-la té ka pati, Jézi koumansé palé épi sé moun-an konsèné Jan Batis, i di yo, “Ki sa ou té ay wè byen lwen an hòtè? An nonm ki pa sav sa i vlé, menm kon an bwanch zèb van-an ka vanté toupatou? ");
INSERT INTO acfNT_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Si sé pa sa, ki sa ou té ay wè? An nonm ki té byen abiyé? Non. Si ou alé pou wè an nonm ki byen abiyé, sé adan kay an wa ou té kay wè nonm sala. ");
INSERT INTO acfNT_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Di mwen ki sa ou té alé wè. An pwòfèt? Wi, mwen ka diʼw, ou wè plis pasé an pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Sété konsèné Jan Batis lévanjil-la té ka palé lè Bondyé té di, ‘Mwen kay voyé konmisyonnè mwen avanʼw pou pwépawé an chimen baʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Mwen ka asiwéʼw, la pa ni pyèsonn ki ja janmen viv ki pli enpòtan pasé Jan Batis. Mé anpami sé moun-an Bondyé ka kondwi-a, moun-an ki mwens enpòtan ni plis pwivilaj pasé Jan Batis. ");
INSERT INTO acfNT_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Dépi tan Jan Batis té ka pwéché pou jis apwézan, Bon Nouvèl-la ka pwéché épi an pil kouway, paski Bondyé vlé ich li vini viv anba kondwit li, épi an chay moun ka kouwi vini aksèpté Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Avan Jan Batis té vini, sé pwòfèt-la épi lwa Moziz-la té palé konsènéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Si ou ka kwè sa yo ka di-a, ou kay sav sé Jan Batis yo té ka palé lè yo té di pwòfèt Ilaydja té kay viwé asou latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tout sa ki ni zòwèy pou yo tann sipozé kouté! ");
INSERT INTO acfNT_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Ki mannyè mwen kay di moun jòdi-a yé? Yo pa sav ki sa yo vlé, menm kon manmay ki asid bò chimen-an épi yon konpanni ka andjélé bay lòt konpanni-an, ");
INSERT INTO acfNT_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Nou jwé mizik cho pouʼw té dansé, mé ou pa dansé. Nou chanté chanté lapenn pouʼw té pléwé, mé ou pa pléwé.’ ");
INSERT INTO acfNT_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Lè Jan Batis vini, i té ka wèsté san manjé souvan épi i pa té ka bwè, épi yo di, ‘Nonm sala ni an vyé lèspwi.’ ");
INSERT INTO acfNT_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Lè mwen Gason Lézòm-lan vini, mwen té ka manjé èk bwè épi moun, épi yo di, ‘Nonm sala sé an vowas épi an gògè. I sé kanmawad sé péchè-a épi sé moun-an ki ka anmasé taks-la.’ Mé lè ou wè mannyè lasajès Bondyé ka twavay andidan an moun, ou kay konnèt sé Bondyé ki dwèt an tout sa i ka fè.” ");
INSERT INTO acfNT_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Jézi kondanné sé moun-an adan sé vil-la koté i té fè pwèskè tout sé miwak li-a, paski yo pa tounen hòd péché yo. I di yo, ");
INSERT INTO acfNT_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Ki mizi téwib i kay téwib pou zòt jan Korazin! Ki mizi téwib i kay téwib pou zòt jan Bèfsayda! Si tout sé miwak sala mwen fè anpami zòt-la té fèt anpami jan Taya épi Sidon, yo té kay abiyé épi had sak anlè yo épi yo té kay mété sann asou tèt yo dépi lontan pou moutwé yo té ja tounen hòd péché yo. ");
INSERT INTO acfNT_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Mwen ka asiwé zòt, jou jijman-an Bondyé kay ni pli konpasyon asou jan Taya épi Sidon pasé asou zòt! ");
INSERT INTO acfNT_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Épi zòt menm, jan Kapènéyòm, zòt vlé lévé kò zòt mouté jis an syèl, mé Bondyé kay mennenʼw désann an lanfè! Si tout sé miwak-la ki fèt anpami zòt-la té fèt adan vil Sòdonm, i pa té kay détwi! I té kay la pou jis atjwèlman! ");
INSERT INTO acfNT_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Mwen ka asiwé zòt, jou jijman-an Bondyé kay ni pli konpasyon asou Sòdonm pasé asou zòt!” ");
INSERT INTO acfNT_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","An tan sala Jézi pwédyé, i di, “Papa, mèt latè épi syèl, mwen ka wimèsyéʼw paski ou ja séwé lavéwité-a hòd moun ki entélijan épi ki ni lasajès, mé ou ja wévéléʼy bay ti manmay ki pa konnèt anyen. ");
INSERT INTO acfNT_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Wi Papa, sé kon sa ou té vlé sé bagay sala fèt.” ");
INSERT INTO acfNT_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jézi di sé moun-an, “Papa mwen ja ban mwen tout bagay. Pyèsonn pa konnèt Gason-an antiwan Papa-a, épi pyèsonn pa konnèt Papa-a antiwan Gason-an èk moun Gason-an vlé fè konnèt Papa-a. ");
INSERT INTO acfNT_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Vin jwenn mwen, zòt tout ki las épi ka pòté chay lou, épi mwen kay soulajéʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Obéyi sa mwen ka enstwiʼw-la, paski mwen ni pasyans épi mwen dous, épi ou kay jwenn lapé an tjèʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Sé bagay-la mwen ka enstwiʼw-la ézé pou swiv, épi sa mwen ka diʼw pou fè-a ézé pou fè.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","I pa té ni lontan apwé sa, Jézi épi sé disip li-a té ka pasé adan an jaden asou jou sabaf-la. Sé disip-la té fen, kon sa yo koumansé tjouwi gwenn épi yo té ka manjéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Lè sé Fawizyen-an wè sa, yo di Jézi, “Ès ou pa sav i kont lwa nou pou sé disip ou-a tjouwi gwenn asou jou sabaf-la?” ");
INSERT INTO acfNT_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jézi di yo, “Ès ou pʼòkò li an lévanjil-la ki sa Wa David fè lè li épi sé nonm li-an té fen? ");
INSERT INTO acfNT_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","I té antwé an Kay Bondyé-a épi yo manjé pen-an sé pwèt-la té ofè bay Bondyé-a. Sa té kont lwa-a paski sété sé pwèt-la yonn ki té ni dwa manjé pen sala. ");
INSERT INTO acfNT_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ében, ès ou pa janmen li an lwa Moziz-la ki mannyè sé pwèt-la ki ka fè sakwifis an Kay Bondyé-a sa twavay asou jou sabaf-la épi yo pa koupab? ");
INSERT INTO acfNT_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ében mwen ka diʼw, apwézan la ni an lwa isi-a ki pli enpòtan pasé lwa Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Lévanjil-la di sé pa sakwifis Bondyé vlé, mé i vléʼw ni konpasyon asou lézòt moun. Si ou té sav ki sa sa vlé di, ou pa té kay kondanné sé moun-an ki pa koupab-la, ");
INSERT INTO acfNT_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","paski mwen Gason Lézòm-lan ki mèt jou sabaf-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Jézi kité koté i té yé-a épi i antwé adan yonn an sé légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","La té ni an nonm ki té ni an lanmen enfim, épi moun ki té la té vlé akizé Jézi, kon sa yo mandéʼy, “Ès i kont lwa nou pou djéwi moun asou jou sabaf-la?” ");
INSERT INTO acfNT_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jézi di yo, “Si ou ni an mouton ki tonbé adan an twou ki fon asou jou sabaf-la, ès ou pa kay tiwéʼy an twou sala? ");
INSERT INTO acfNT_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","An nonm ni twòp pli valè pasé an mouton! Kon sa i pa kont lwa nou pou fè bon asou jou sabaf-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","I di nonm-lan ki té ni lanmen enfim-lan, “Lonjé lanmenʼw.” Nonm-lan lonjéʼy épi lanmen-an vini byen menm kon lòt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Mé sé Fawizyen-an pati épi yo fè konplo pou yo tjwé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Lè Jézi sav sa, i kité plas-la koté i té yé-a, èk an gwan latilyé moun swiv li. I djéwi tout moun ki té malad anpami yo, ");
INSERT INTO acfNT_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","épi i konmandé yo pou pa di ki moun i yé. ");
INSERT INTO acfNT_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","I di sa pou fè sa Bondyé té di pa pwòfèt Izaya-a vin fèt vwé, i té di, ");
INSERT INTO acfNT_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Mi sèvant-lan mwen ja chwazi-a. Mwen enmenʼy an pil, épi i ka fè tout sa mwen vléʼy fè. Mwen kay voyé pouvwa Lèspwi mwen asouʼy, épi i kay di tout moun ki sa mwen vlé yo fè. ");
INSERT INTO acfNT_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","I pa kay chikannen ni fè dézòd, ni ou pa kay tann bouch li bò lawi. ");
INSERT INTO acfNT_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","I pa kay maltwété moun ki fèb, épi i kay édé sa ki dékouwajé. I kay fè sa jis tan tout nasyon obéyi lwa Bondyé ");
INSERT INTO acfNT_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","épi yo mété lafwa yo an li.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Déotwa moun mennen an nonm bay Jézi ki té avèg èk i pa té sa palé paski i té ni an vyé lèspwi andidanʼy, épi Jézi djéwi nonm-lan, épi i vin wè klè épi i té sa palé. ");
INSERT INTO acfNT_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Lè tout sé moun-an wè sa, yo té si tèlman sipwi yo di, “Ès ou kwè Jézi sé wa-a Bondyé té pwonmèt pou voyé-a, désandan Wa David-la?” ");
INSERT INTO acfNT_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Lè sé Fawizyen-an tann sa, yo di, “Sé Bèlzibòb, chèf sé vyé lèspwi-a, ki ka ba li pouvwa pou tiwé vyé lèspwi.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mé Jézi sav sa yo té ka katjilé-a épi i di yo, “Népòt péyi ki divizé kont kòʼy èk sé moun-an ka goumen èvèk yonn a lòt, péyi sala kay kwazé. Népòt vil ében fanmi ki divizé kont kòʼy pa kay wèsté pou lontan. ");
INSERT INTO acfNT_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Menm mannyè-a, si sa ou ka di-a vwé èk sé Satan ki ka ban mwen pouvwa pou tiwé vyé lèspwi, sa vlé di Satan divizé kont kòʼy. Ki mannyè wéyòm-lan i ka kondwi-a kay sa doubout? ");
INSERT INTO acfNT_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Si sé Bèlzibòb ki ka ban mwen pouvwa-a pou tiwé vyé lèspwi, ében sa vlé di sé Bèlzibòb ki ka bay sé disip ou-a pouvwa-a pou fèʼy tou. Kon sa sé disip ou-a menm ka moutwé sa ou di-a pa vwé. ");
INSERT INTO acfNT_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Mé si sé Lèspwi Bondyé ki ka ban mwen pouvwa-a pou tiwé vyé lèspwi, sa ka moutwé Bondyé ja ka kondwi anpami zòt. ");
INSERT INTO acfNT_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Pyèsonn pa sa antwé andidan kay an nonm ki fò épi vòlè bagay li si i pa mawé nonm sala avan. Lè i fin mawéʼy, i kay sa vòlè tout sa nonm-lan ni andidan kay li. ");
INSERT INTO acfNT_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Moun-an ki pa pou mwen-an kont mwen, épi moun-an ki pa ka édé mwen sanblé-a ka simen. ");
INSERT INTO acfNT_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Sé pou sa mwen ka diʼw, Bondyé kay pawdonnen népòt péché an moun fè ében népòt vyé pawòl i di, mé si an moun ensilté Lèspwi Bondyé, Bondyé pa kay pawdonnen péché sala. ");
INSERT INTO acfNT_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Népòt moun ki di an bagay kont Gason Lézòm-lan, Bondyé kay pawdonnenʼy, mé népòt moun ki di pyès mové bagay kont Lèspwi Bondyé pa kay jwenn pawdonnasyon, ni apwézan ni an tan ki pou vini. ");
INSERT INTO acfNT_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“An bon pyé bwa kay pòté bon fwitaj, mé an vyé pyé bwa kay pòté vyé fwitaj. Kon sa ou kay konnèt an pyé bwa pa fwitaj li. ");
INSERT INTO acfNT_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Débann sèpan kon zòt yé! Ki mannyè ou ka fè palé bon bagay lè tjèʼw mové? Bouch-la ka palé bagay ki ka sòti an tjè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","An bon nonm kay palé sé bon bagay-la i ni andidanʼy-lan, mé an mové nonm kay palé sé mové bagay-la i ni andidanʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","“Mwen ka asiwéʼw, asou jou jijman-an ou kay ni pou bay kont pou tout pawòl ou pa té sipozé di. ");
INSERT INTO acfNT_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Bondyé kay sèvi sé pawòl-la ou di-a pou jijé si ou inosan ében si ou koupab.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Adan sé titja lwa sé Jwif-la épi sé Fawizyen-an di Jézi, “Titja, fè an miwak pou nou wè.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Jézi wéponn yo, “Mé zòt jan jòdi méchan, wi! Apwé zòt tounen kont Bondyé, zòt ka mandé pou an miwak ankò! Zòt pa kay wè pyès lòt miwak pasé sa ki té fèt an tan Jonna-a. ");
INSERT INTO acfNT_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Menm mannyè Jonna té wèsté andidan bouden gwo pwéson-an pou twa jou épi twa swè, sé menm mannyè-a Gason Lézòm-lan kay wèsté anba tè-a pou twa jou épi twa swè. ");
INSERT INTO acfNT_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Asou jou jijman-an moun péyi Ninivè kay doubout èk akizé zòt, paski lè yo té tann Jonna pwéché, yo koutéʼy èk yo tout té tounen hòd péché yo. Mwen ka diʼw, isi-a ni yonn ki pli enpòtan pasé Jonna. ");
INSERT INTO acfNT_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Asou jou jijman-an wenn péyi Chiba kay doubout èk akizé zòt, paski i kité péyiʼy épi i alé jis an péyi Wa Sòlomonn pouʼy té tann lasajès li. Mwen ka diʼw, isi-a ni yonn ki pli enpòtan pasé Sòlomonn! ");
INSERT INTO acfNT_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Lè an vyé lèspwi sòti andidan an moun, i ka pasé koté ki pa ni dlo, i ka gadé pou an plas pouʼy sa wèsté. Mé lè i pa jwenn pyès, ");
INSERT INTO acfNT_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i ka di bay kòʼy, ‘Mwen kay viwé menm koté mwen sòti-a.’ Lè i wivé, i jwenn plas-la byen balyé épi byen wanjé, mé i té vid toujou. ");
INSERT INTO acfNT_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Vyé lèspwi-a ka mennen sèt lézòt lèspwi ki pli mové paséʼy épi yo ka vin wèsté la. Lè sa fèt, dènyé bout moun sala pli mové pasé an koumansman-an. Sé sa ki kay wivé sé mové moun-an ki ka viv atjwèlman-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Paditan Jézi té ka palé bay sé moun-an, manmanʼy épi fwèʼy wivé. Yo doubout dèwò-a épi yo mandé pou palé bay Jézi.  ");
INSERT INTO acfNT_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Kon sa an moun di Jézi, “Manmanʼw épi fwèʼw doubout dèwò-a. Yo vlé palé baʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Jézi wéponn, i di, “Kilès ki manman mwen? Kilès ki fwè mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Èvèk Jézi lonjé lanmenʼy asou sé disip li-a épi i di, “Mi fwè mwen épi manman mwen! ");
INSERT INTO acfNT_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Népòt moun ki obéyi Papa mwen ki an syèl, sé li ki fwè mwen, sésé mwen épi manman mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Menm jou sala Jézi kité kay-la koté i té yé-a épi i ay asid bò Lanmè Galili-a. ");
INSERT INTO acfNT_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Mé la té ni tèlman moun ki té fè wonʼy i antwé adan an kannòt épi i asid, épi sé moun-an doubout asou tè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","I di yo an chay bagay an pawabòl. I di yo kon sa, “La té ni an nonm ki té ay planté gwenn an jadenʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Kon i ka simen sé gwenn-an, adan tonbé an chimen-an, épi jibyé vini épi yo manjé sé gwenn-an. ");
INSERT INTO acfNT_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Adan gwenn tonbé asou kayè koté ki pa té ni djè tè épi yo lévé vit paski tè-a pa té fon. ");
INSERT INTO acfNT_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Lè sòlèy-la chofé asou sé plan sala, i fennen yo épi yo mò paski wasin yo pa té fon an tè. ");
INSERT INTO acfNT_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Adan gwenn tonbé anpami pikan épi sé pikan-an kouvè sé plan-an épi toufé yo. ");
INSERT INTO acfNT_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","An lòt konpanni gwenn ankò tonbé adan bon tè épi yo pwodwi an chay gwenn. I té ni sa ki pòté yon san (100) gwenn, adan té ni swasant (60), adan té ni twant (30) gwenn.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Lè Jézi fini, i di yo, “Tout sa ki ni zòwèy pou yo tann sipozé kouté!” ");
INSERT INTO acfNT_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Sé disip Jézi-a vini kotéʼy épi yo mandéʼy, “Pouki ou ka palé bay sé moun-an an pawabòl?” ");
INSERT INTO acfNT_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","I wéponn yo, “Bondyé ja fèʼw konnèt sé sigwé-a i yonn té konnèt-la konsèné mannyè i ka kondwi, mé i pa bay sé lézòt moun-an lakonpwann sala. ");
INSERT INTO acfNT_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Kon sa moun-an ki ni lakonpwann-an, Bondyé kay ba li ankò, épi i kay niʼy alabondans. Mé moun-an ki pa ni-an, Bondyé kay pwan jis tizing-lan i ni-an. ");
INSERT INTO acfNT_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Sé pou wézon sala mwen ka sèvi pawabòl lè mwen ka palé ba yo, paski yo ka gadé sa mwen ka fè-a, mé yo pa ka wè. Yo ka tann sa mwen ka di-a, mé yo pa ka konpwann paski yo ka fèmé lidé yo. ");
INSERT INTO acfNT_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Sé pou sa, pawòl pwòfèt Izaya té di konsèné yo-a vin fèt vwé, i té di, ‘Sé moun sala kay tann èk zòwèy yo, mé yo pa kay janmen konpwann, épi yo kay gadé èk zyé yo, mé yo pa kay janmen wè, ");
INSERT INTO acfNT_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","paski yo ja fèmé lidé yo, épi yo ja bouché zòwèy yo, épi yo ja fèmé zyé yo. Si yo pa té fè sa, zyé yo té kay wè, zòwèy yo té kay tann, lidé yo té kay konpwann, épi yo té kay vini jwenn mwen, épi mwen té kay pawdonnen yo.’ ");
INSERT INTO acfNT_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Mé pou ou menm, i bon paski zyéʼw ka wè épi zòwèy ou ka tann. ");
INSERT INTO acfNT_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Mwen ka asiwéʼw, an chay pwòfèt épi moun ki dwèt té avoudwé wè sa ou ka wè-a, mé yo pa wèʼy. Yo té avoudwé tann sa ou ka tann-an mé yo pa tann li. ");
INSERT INTO acfNT_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Kouté pou konpwann sa pawabòl nonm-lan ki té ka simen sé gwenn-an vlé di, ");
INSERT INTO acfNT_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Chimen-an koté adan sé gwenn-an tonbé-a sé menm kon tjè an moun ki tann konmisyon-an konsèné mannyè Bondyé kay kondwi sé moun li-an, épi i pa konpwann li. Satan vini tiwé konmisyon Bon Nouvèl-la ki té simen an tjèʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Sé gwenn-an ki té tonbé asou kayè-a ki pa té ni djè tè-a sé menm kon moun ki jwenn konmisyon-an épi yo té kontan lè yo jwenn li, ");
INSERT INTO acfNT_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","mé konmisyon-an pa té désann fon andidan tjè yo, épi yo pa tjenbéʼy pou lontan. Kon sa lè pèsikasyon ében twaka lévé pou lapéti konmisyon-an, la menm yo viwé an péché yo. ");
INSERT INTO acfNT_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Sé gwenn-an ki tonbé anpami pikan-an sé menm kon moun ki tann konmisyon-an, mé yo té twakasé lidé yo pou sa yo té bizwen, épi yo té kontan wichès twòp. Sa toufé konmisyon-an, épi i pa fè anyen ba yo. ");
INSERT INTO acfNT_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Sé gwenn-an ki tonbé an bon tè-a sé menm kon moun ki tann konmisyon-an épi yo konpwann li. Yo vini menm kon plan ki pwodwi byen. Adan pwodwi yon san (100) gwenn, adan pwodwi swasant (60), épi an lòt konpanni pwodwi twant (30).” ");
INSERT INTO acfNT_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jézi di sé moun-an an lòt pawabòl ankò. I di yo kon sa, “Mannyè Bondyé ka kondwi sé moun li-an sé menm kon sa ki fèt lè an nonm planté bon gwenn an jadenʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","mé paditan tout moun té ka dòmi, an lèlmi pasé épi i planté vyé gwenn anpami bon gwenn-an épi i alé. ");
INSERT INTO acfNT_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Lè bon plan-an koumansé lévé épi yo pwodwi, vyé zèb-la lévé tou. ");
INSERT INTO acfNT_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Sé sèvant nonm-lan alé diʼy, ‘Mèt, ès sé pa té bon gwenn ou té planté an jadenʼw? Ki mannyè la ni an vyé zèb ka lévé?’ ");
INSERT INTO acfNT_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“I di yo, ‘Sé an lèlmi ki fè sa.’ “Yo mandéʼy, ‘Ès ou vlé nou alé waché vyé zèb-la?’ ");
INSERT INTO acfNT_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“I di yo, ‘Non, pa fè sa, paski si ou fè sa, ou pé waché bon plan-an anpami vyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Kité yo lévé ansanm jis tan mwen wékòlté. Mwen kay fè twavayè mwen waché sé vyé zèb-la épi mawéʼy an patjé épi bwiléʼy avan. Apwé sa, yo kay anmasé bon gwenn-an épi yo kay météʼy adan an ti kay.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jézi di yo an lòt pawabòl, i di, “Mannyè Bondyé ka kondwi sé moun li-an sé menm kon an gwenn moutad an nonm pwan épi i plantéʼy an jadenʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Magwé sé gwenn sala ki pli piti an tout gwenn, mé sé li ki ka fè pli gwo pyé bwa adan an jaden, èk jibyé ka vini fè nich an bwanch li.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jézi di sé moun-an an lòt pawabòl ankò. I di, “Mannyè Bondyé ka kondwi sé moun li-an sé menm kon lèlven an madanm pwan épi i méléʼy épi on dimi sak fawin fwans pou fè tout lapat-la lévé.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jézi sèvi pawabòl lè i té ka palé bay sé moun-an, épi i pa di yo yon bagay si i pa té sèvi an pawabòl. ");
INSERT INTO acfNT_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","I palé an pawabòl pou fè sa Bondyé té di pa pwòfèt-la vin fèt vwé. Pwòfèt-la té di, “Mwen kay sèvi pawabòl lè mwen ka palé bay sé moun sala. Mwen kay di yo bagay pyèsonn pa janmen konnèt dépi tan Bondyé fè latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Lè Jézi kité tout sé moun-an épi i antwé andidan kay-la, sé disip-la vin kotéʼy épi yo diʼy, “Di nou ki sa pawabòl vyé zèb-la ki té an jaden-an vlé di.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jézi di yo, “Nonm-lan ki simen bon gwenn-an sé Gason Lézòm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Jaden-an sé latè-a. Sé bon gwenn-an sé moun Bondyé ka kondwi, épi sé vyé zèb-la sé moun ki ka sèvi Denmou. ");
INSERT INTO acfNT_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Épi lèlmi-an ki planté vyé gwenn-an an jaden-an sé Denmou. Wékòt-la sé bout latè-a, épi sé moun-an ki kay wékòlté sé gwenn sala sé nanj. ");
INSERT INTO acfNT_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","“Menm mannyè yo ka anmasé vyé zèb-la épi jétéʼy an difé pou bwiléʼy, sé sa ki kay fèt an bout latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Gason Lézòm-lan kay voyé nanj li pou tiwé tout moun ki ka annékòz moun fè péché, épi tout lézòt moun ki ka fè mové bagay anpami sé moun-an Bondyé ka kondwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Épi sé nanj-lan kay jété yo an lanfè ki menm kon an fou difé, koté yo kay pléwé épi kwatjé dan yo. ");
INSERT INTO acfNT_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Épi sé moun Bondyé-a kay kléwé menm kon sòlèy-la anba kondwit Papa yo. Tout sa ki ni zòwèy pou yo tann sipozé kouté! ");
INSERT INTO acfNT_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Mannyè Bondyé ka kondwi sé menm kon lè an nonm jwenn an jè lajan adan on tjò tè. Lè i jwenn jè lajan sala, i viwé kouvèʼy, épi i té kontan tèlman, i alé vann tout sa i ni épi i achté tè sala. ");
INSERT INTO acfNT_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ankò, mannyè Bondyé ka kondwi sé menm kon lè an machann ka chaché bèl bijou, ");
INSERT INTO acfNT_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","épi lè i jwenn yonn ki bèl an chay, i alé vann tout sa i ni pouʼy sa achté bèl bijou sala. ");
INSERT INTO acfNT_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ankò, mannyè Bondyé ka kondwi sé menm kon lè déotwa péchè voyé an senn an lanmè-a épi yo tjenbé tout sòt kalité pwéson, ");
INSERT INTO acfNT_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","épi lè senn-an té plen, yo hédiʼy atè épi yo asid pou sépawé sé pwéson-an. Sa ki té bon pou manjé, yo mété andidan panyen, épi sa ki pa té bon pou manjé, yo jétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Sé kon sa i kay yé lè tan-an kay fini. Sé nanj Bondyé-a kay vini tiwé sé mové moun-an anpami sé sa ki bon-an, ");
INSERT INTO acfNT_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","épi yo kay jété yo an lanfè ki menm kon an fou difé, koté yo kay pléwé épi kwatjé dan yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jézi mandé sé disip li-a, “Ès zòt konpwann sé pawabòl-la mwen di la-a?” Yo wéponn, “Wi.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Kon sa i di yo, “Ében, népòt titja lwa sé Jwif-la ki ja apwann mannyè Bondyé ka kondwi atjwèlman ka ni dé bennédiksyon. I konnèt sa Bondyé té ka enstwi sé moun li-an an tan lontan, èk i konnèt sa mwen ka enstwi atjwèlman. I sé menm kon mèt an kay ki ni anpami pozèsyonʼy bon bagay ki nèf épi bon bagay ki la dépi lontan.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Lè Jézi fini di yo sé pawabòl sala, i kité plas-la koté i té yé-a ");
INSERT INTO acfNT_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","épi i alé an vil-la koté i té lévé-a. I enstwi an légliz sé Jwif-la, épi tout sé moun-an ki té tann li-a té sipwi an chay. Yo di, “Koté i jwenn tout lasajès sala épi pouvwa-a pou fè sé miwak sala? ");
INSERT INTO acfNT_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Épi nou konnèt byen sé gason chapantyé-a i yé, épi Mari sé manmanʼy. Épi Jémz, Jozèf, Simon épi Jida sé fwèʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","épi tout séséʼy ka wèsté isi-a. Koté i jwenn tout sa?” ");
INSERT INTO acfNT_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Kon sa yo pa té vlé ni anyen pou fè épiʼy. Jézi di yo, “Tout lézòt moun kay wèspèkté an pwòfèt antiwan moun ki an fanmiʼy èk an menm vil épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","I pa fè djè miwak an plas sala paski sé moun-an pa té kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","An tan sala sété Hèròd ki té ka kondwi Galili. Lè i tann tout sé miwak-la Jézi ka fè-a, ");
INSERT INTO acfNT_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","i di sé sèvant li-a, “Sa sé Jan Batis ki wésisité, épi sé pou sa i ni pouvwa pou fè miwak.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Hèròd di sa paski i té ja fè yo awété Jan Batis épi mawéʼy épi météʼy lajòl pou lapéti Hèrodiyas, madanm fwèʼy Filip, ");
INSERT INTO acfNT_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","paski Jan Batis té di i pa dwèt pou Hèròd té ni madanm fwèʼy kon madanm li. ");
INSERT INTO acfNT_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Hèròd té vlé tjwé Jan Batis, mé i té pè sé jan Galili-a paski yo té konsidiwé Jan Batis kon an pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Mé asou jou annivèwsè Hèròd, tifi Hèrodiyas-la dansé douvan tout sé moun-an ki té an fèt-la, épi sa fè Hèròd plézi an chay. ");
INSERT INTO acfNT_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Kon sa i sèwmanté douvan tout moun i kay bay tifi-a népòt sa i mandé. ");
INSERT INTO acfNT_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tifi-a swiv konsèy manmanʼy épi i mandé pou tèt Jan Batis asou on pla! ");
INSERT INTO acfNT_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Sa té fè wa-a lapenn an chay, mé paski i té ja fè pwonmèt-la douvan tout sé moun-an ki té an fèt-la, i té ni pou fè sa ti fi-a mandéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Kon sa i konmandé sòldaʼy pou ay koupé tèt Jan Batis an lajòl-la. ");
INSERT INTO acfNT_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Yo mennen tèt Jan Batis bay tifi-a asou on pla, épi tifi-a pwanʼy épi i mennenʼy bay manmanʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Épi sé disip Jan Batis-la vini pwan kò-a épi yo mennenʼy ay téwé, épi yo alé di Jézi tout sa ki té fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Lè Jézi tann yo tjwé Jan Batis, i pwan an kannòt épi i pati alé adan an plas pouʼy té wèsté pa kòʼy. Mé sé moun-an vin konnèt sa épi yo kité sé vilaj-la koté yo té ka wèsté-a. Yo pasé bòdaj dlo-a épi yo swiv li. ");
INSERT INTO acfNT_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Lè i désann kannòt-la, i wè an chay moun la. Yo fèʼy lapenn an chay épi i djéwi tout sa ki té malad. ");
INSERT INTO acfNT_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Lè sé disip-la wè sòlèy kouché, yo di Jézi, “La pa ni moun ki ka wèsté isi-a, épi i ja ta. Voyé sé moun-an alé an sé vilaj-la pou yo ay achté manjé pou yo manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jézi di yo, “Yo pa oblijé alé. Sé ou menm ki ni pou ba yo manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Yo di Jézi, “Nou pa ni pli pasé dé pwéson épi senk pen.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jézi di, “Mennen yo ban mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","I di tout moun, “Asid asou zèb-la.” I pwan pwéson-an épi pen-an èk i lévé zyéʼy an syèl épi i wimèsyé Bondyé. I kasé pen-an épi i bay sé disip li-a, épi yo sépawéʼy bay tout moun. ");
INSERT INTO acfNT_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Sé moun-an manjé bouden yo wèd. Lè yo fin manjé, sé disip-la anmasé sé mòso-a ki wèsté-a épi yo météʼy adan panyen, épi yo jwenn douz panyen plen. ");
INSERT INTO acfNT_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","An tout sé moun-an ki té la-a ki manjé pen sala, la té ni senk mil (5,000) nonm, apa di madanm épi ti manmay. ");
INSERT INTO acfNT_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Lè sala Jézi fè sé disip li-a antwé adan an kannòt pou yo alé lòt bò Lanmè Galili-a paditan i menm wèsté dèyè pouʼy voyé sé moun-an alé lakay yo. ");
INSERT INTO acfNT_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Apwé i fin voyé sé moun-an alé, i mouté asou an ti mòn pa kòʼy ay pwédyé, épi lè sòlèy kouché i té la toujou. ");
INSERT INTO acfNT_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","A lè sala kannòt-la té ja lwen an lanmè-a. Lanmè-a té ka malmennenʼy paski van-an té ka vanté kont kannòt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Avan sòlèy lévé, Jézi maché asou dlo-a pouʼy ay jwenn sé disip-la. ");
INSERT INTO acfNT_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Lè sé disip-la wè Jézi ka maché asou dlo-a, yo té pè an chay. Yo di, “Sa sé an lèspwi!” épi yo fè an kwi afòs yo té pè. ");
INSERT INTO acfNT_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Menm lè-a Jézi di yo, “Pwan tjè! Sé mwen menm ki la, pa pè!” ");
INSERT INTO acfNT_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Pita di, “Mèt, si sé ou pou vwé, di mwen vini jwenn ou asou dlo-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Épi Jézi diʼy, “Vini!” Kon sa Pita désann kannòt-la épi i koumansé maché asou dlo-a ay jwenn Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Mé lè i wè mizi fò van-an té ka vanté, i té pè épi i koumansé désann anba dlo. I hélé, “Mèt, sové mwen!” ");
INSERT INTO acfNT_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Menm lè-a Jézi lonjé lanmenʼy épi i tjenbé Pita épi i diʼy, “Lafwaʼw fèb toubonnman! Pouki ou pa kwè mwen sa fèʼw vin jwenn mwen asou dlo-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yo toulé dé antwé andidan kannòt-la, épi van-an bésé, ");
INSERT INTO acfNT_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","épi sé disip-la adowé Jézi épi yo di, “Ou sé Gason Bondyé pou vwé!” ");
INSERT INTO acfNT_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Yo janbé lanmè-a épi yo wivé asou tè Jennèsawèt, ");
INSERT INTO acfNT_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","épi lè sé moun-an ki té la-a wè sété Jézi, yo voyé pwan tout moun ki té malad an sé plas-la ki oliwon-an, épi yo mennen yo bay Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Yo mandé Jézi pou kité sé moun-an touché ti bout had li sèlman, épi tout sa ki té touché bout had Jézi té djéwi. ");
INSERT INTO acfNT_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Déotwa Fawizyen épi titja lwa sé Jwif-la sòti Jérouzalèm épi yo vini dèyè Jézi. Yo mandéʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Pouki sé disip ou-a ka dézobéyi sé twadisyon-an sé jan lontan-an kité ban nou-an? Yo pa ka lavé lanmen yo adan an mannyè ki dwèt avan yo manjé!” ");
INSERT INTO acfNT_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jézi wéponn yo, “Pouki ou menm ka dézobéyi lwa Bondyé pouʼw sa swiv twadisyon ou menm? ");
INSERT INTO acfNT_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Bondyé di, ‘Wèspèkté papaʼw épi manmanʼw,’ épi ‘moun-an ki palé manmanʼy ében papaʼy mal-la sipozé mò.’ ");
INSERT INTO acfNT_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mé twadisyon zòt ka di si an moun ni an bagay pouʼy bay manmanʼy ében papaʼy, épi i di i ja pwonmèt pou bay Bondyé bagay sala, ");
INSERT INTO acfNT_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","i pa oblijé bay manmanʼy ében papaʼy anyen. Kon sa lè ou ka di sa, ou ka dézobéyi lwa Bondyé pouʼw obéyi twadisyonʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Débann ipokwit! Izaya palé lavéwité-a lè i té di pawòl sala asou zòt, i di, ");
INSERT INTO acfNT_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Bondyé di, sé moun sala ka onnowé mwen épi bouch yo, mé yo pa vlé fè sa mwen ka di yo. ");
INSERT INTO acfNT_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","I pa ka fè pyès syans pou yo adowé mwen, paski yo ka enstwi lwa yo menm akwèdi sé lwa mwen yo yé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jézi kwiyé sé moun-an épi i di yo, “Kouté épi konpwann ki sa mwen ka diʼw-la! ");
INSERT INTO acfNT_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Sé pa manjé-a ki ka antwé andidan bouch an moun ki ka fèʼy mové an zyé Bondyé, mé sé sa ki ka sòti andidan bouch li.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Apwé sa, sé disip-la vini koté Jézi épi yo diʼy, “Ès ou sav ou té ofwansé sé Fawizyen-an lè ou té di sa?” ");
INSERT INTO acfNT_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jézi wéponn épi i di yo, “Papa mwen ki an syèl kay haché tout plan i pa planté. ");
INSERT INTO acfNT_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Kité yo bat mizè yo. Yo sé menm kon an nonm avèg ki ka mennen an lòt avèg, épi lè yon avèg ka mennen an lòt, yo toulé dé kay tonbé an kannal.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Pita vini koté Jézi épi i diʼy, “Di nou sa pawabòl manjé-a vlé di.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jézi di yo, “Ou san lakonpwann menm kon yo. ");
INSERT INTO acfNT_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ou vlé di mwen ou pa sav anyen an moun manjé ki désann andidan boudenʼy kay sòti dèwò? ");
INSERT INTO acfNT_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Mé sé mové bagay-la ki andidan tjè an moun ki ka sòti an bouch li, épi sé sa ki ka fèʼy mové an zyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Paski vyé lidé ki ka sòti andidan tjèʼy ka fèʼy tjwé moun, ka fèʼy fè adiltè, ka fèʼy kouwi vyé lavi, ka fèʼy vòlè, ka fèʼy manti an lodyans kont an lòt moun, épi i ka fèʼy palé moun mal. ");
INSERT INTO acfNT_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Sé bagay kon sa ki ka fè tjè an moun sal, épi sé pa lè an moun manjé san i lavé lanmenʼy kon sé Fawizyen-an ka di. Si an moun manjé san i lavé lanmenʼy, sa pa ka fèʼy mové an zyé Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Lè Jézi kité koté i té yé-a, i alé an lòt koté ki té tou pwé Taya épi Sidon. ");
INSERT INTO acfNT_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Épi paditan i la, an madanm ki sé pa té an Jwif vini kotéʼy épi i diʼy, “Mèt, désandan Wa David, ni konpasyon anlè mwen. Mwen ni an tifi ki ni an vyé lèspwi andidanʼy épi i ka soufè an pil.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Mé Jézi pa wéponn li. Sé disip-la di Jézi, “Souplé, voyé madanm-lan alé paski i ka pléwé dèyè nou.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jézi di, “Bondyé té voyé mwen pou sé jan Izwayèl-la tousèl, sé Jwif-la ki ja kité Bondyé-a. Yo menm kon mouton ki pèd gadyenn yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Mé madanm-lan ajounou an pyé Jézi. I diʼy, “Mèt, édé mwen!” ");
INSERT INTO acfNT_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Mé Jézi wéponn li adan an pawabòl. I di, “I pa bon pou pwan manjé sé manmay-la èk jétéʼy bay chyen.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Lè i diʼy sa, madanm-lan wéponn an menm pawabòl-la. I di, “Wi Mèt, mé jis sé chyen-an ki ka manjé sé miyèt manjé-a ki ka sòti asou tab mèt yo tonbé atè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Lè i di sa, Jézi di madanm-lan, “Ou ni an chay lafwa! Mwen kay fè sa ou vlé mwen fè-a.” Épi tifi-a té djéwi menm lè sala. ");
INSERT INTO acfNT_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jézi kité koté i té yé-a épi i alé bò Lanmè Galili-a épi i mouté asou tèt an ti mòn épi i asid. ");
INSERT INTO acfNT_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","An gwan latilyé moun vini kotéʼy épi yo mennen an chay moun ki té ni diféwan maladi. La té ni sa ki pa té sa maché, sa ki avèg, sa ki enfim, sa ki moumou, épi an chay lézòt moun malad, épi yo mennen sé moun sala bay Jézi, épi i djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Lè sé moun-an wè sé moumou-an ka palé, sa ki enfim djéwi, sé moun-an ki pa té sa maché-a ka maché, épi moun ki té avèg ka wè klè, yo té sipwi an chay épi yo glowifyé Bondyé sé jan Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jézi kwiyé sé disip li-a épi i di yo, “Sé moun sala ka fè mwen lapenn. I ja ni twa jou dépi yo isi-a épi mwen, épi atjwèlman yo pa ni anyen pou yo manjé, mé mwen pa vlé voyé yo alé lakay yo kon sa, paski fèblès pé pwan yo asou chimen.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Sé disip-la wéponn li, yo di, “La pa ni pyèsonn ka wèsté isi-a. Ki koté nou kay jwenn asé pen pou bay tout sé moun sala manjé?” ");
INSERT INTO acfNT_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jézi di yo, “Konmen pen ou ni la?” Yo di Jézi, “Nou ni sèt pen épi déotwa ti pwéson.” ");
INSERT INTO acfNT_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","I fè sé moun-an asid atè-a, ");
INSERT INTO acfNT_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","i pwan sèt pen-an épi sé pwéson-an, épi i wimèsyé Bondyé èk i kasé yo, épi i bay sé disip-laʼy. Sé disip-la menm pwanʼy épi yo sépawéʼy bay tout sé moun-an ki té la-a. ");
INSERT INTO acfNT_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Lè tout moun fin manjé bouden yo plen, sé disip-la anmasé sèt panyen an sé mòso-a ki té wèsté-a. ");
INSERT INTO acfNT_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","La té ni kat mil (4,000) nonm ki manjé, apa di madanm épi ti manmay. ");
INSERT INTO acfNT_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Lè yo fin manjé, Jézi voyé yo alé, épi i antwé adan an kannòt épi i alé adan an plas yo té ka kwiyé Magadan. ");
INSERT INTO acfNT_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Déotwa Fawizyen épi Sadisyen vini koté Jézi pou yo wè si yo té sa kwennenʼy. Kon sa yo mandéʼy pou fè an miwak pou yo wè si i ni pouvwa Bondyé pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Mé Jézi di yo, “Lè sòlèy ka kouché, ou ka di, ‘Denmen bonmaten nou kay ni an bèl botan paski syèl-la wouj.’ ");
INSERT INTO acfNT_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Épi an li bonmaten, ou ka di, ‘Lapli kay tonbé, paski tan-an mawé.’ Lè ou gadé syèl-la, ou sa di ki kalité tan i kay ni. Ou ka wè tout sé bagay sala èk ou ka konpwann yo, mé lè ou gadé sa mwen ka fè, ou pa ka konpwann li, ni ou pa ka sav ki moun mwen yé. ");
INSERT INTO acfNT_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ében, pa dé méchan ou méchan! Ou ka tounen kont Bondyé! Ou pa kay wè mwen fè pyès miwak pasé sa ki té fèt an tan Jonna-a.” Jézi kité yo épi i alé. ");
INSERT INTO acfNT_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Sé disip-la janbé lòt bò Lanmè Galili-a, mé yo té obliyé mennen pen épi yo. ");
INSERT INTO acfNT_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Jézi di yo, “Véyé kò zòt épi lèlven sé Fawizyen-an épi sé Sadisyen-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Sé disip-la koumansé palé anpami kò yo. Yo di, “Sé paski nou pa mennen pen i di nou sa.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mé Jézi sav ki sa yo té ka di-a épi i di yo, “Pouki ou katjilé sé paski ou pa mennen pen mwen di sa? Lafwaʼw fèb toubonnman! ");
INSERT INTO acfNT_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ou vlé di mwen ou pa konpwann toujou? Ou pa chonjé lè mwen té kasé senk pen pou té bay senk mil (5,000) moun manjé? Épi konmen panyen pen ou té anmasé lè yo fin manjé? ");
INSERT INTO acfNT_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Épi lè mwen té kasé sèt pen bay kat mil (4,000) nonm, konmen panyen ou anmasé? ");
INSERT INTO acfNT_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ki mannyè ou pa konpwann sé pa pen mwen ka palé lè mwen diʼw véyé kòʼw épi lèlven sé Fawizyen-an épi sé Sadisyen-an?” ");
INSERT INTO acfNT_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Lè sala sé disip-la vin konpwann sé pa té lèlven yo ka mété an pen i té ka palé, mé sé sa sé Fawizyen-an épi sé Sadisyen-an té ka enstwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Jézi alé adan sé ti plas-la ki bò vil Sizariya Filipay épi lè i wivé la, i mandé sé disip li-a, “Ki moun sé moun-an di mwen Gason Lézòm-lan yé?” ");
INSERT INTO acfNT_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Sé disip-la di, “Adan di ou sé Jan Batis, an lòt konpanni di ou sé Ilaydja, épi an lòt konpanni di ankò ou sé Jérémaya ében yonn an sé lézòt pwòfèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Jézi mandé yo, “Mé ou menm, ki moun ou ka di mwen yé?” ");
INSERT INTO acfNT_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Lè i di sa Pita wéponn li, “Ou sé Mèsaya-a, Gason Bondyé ki ka viv pou tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","“Sa bon an chay pou ou Simon, gason Jonna! Pyès moun asou latè-a pa moutwéʼw sa, mé sé Papa mwen ki an syèl ki wévélé sa diwèktiman baʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Mwen ka diʼw, Pita, ou sé an wòch, épi asou fondasyon kayè sala mwen kay bati légliz mwen, épi pouvwa lanmò pa kay sa genyen a bout li. ");
INSERT INTO acfNT_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mwen kay baʼw dwa pou di moun ki mannyè pou yo vini anba kondwit Bondyé, épi sa ou anpéché fèt asou latè-a pa kay fèt an syèl, épi sa ou kité fèt asou latè-a kay fèt an syèl.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Épi Jézi di sé disip li-a pa di pyèsonn sé li ki Mèsaya-a. ");
INSERT INTO acfNT_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Dépi tan sala, Jézi koumansé palé aklè bay sé disip li-a. I di yo, “Mwen ni pou alé Jérouzalèm, épi sé chèf pwèt-la épi sé titja lwa-a épi sé ofisyé Jwif-la kay fè mwen soufè an chay. Yo kay fè moun tjwé mwen, mé lè i ni twa jou, mwen kay wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Pita mennen Jézi asou koté épi i diʼy, “Kité Bondyé pwézèvéʼw sa, Mèt! Sa pa sipozé wivéʼw pyès!” ");
INSERT INTO acfNT_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jézi tounen épi i di Pita, “Sòti bò mwen! Ou vlé fè twavay Satan! Ou sé on bawad an chimen mwen. Lidé sala pa sòti an Bondyé. Sé lézòm ki ka katjilé kon sa.” ");
INSERT INTO acfNT_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jézi di sé disip li-a, “Si an nonm vlé vini disip mwen, i ni pou pòté kwaʼy épi swiv mwen. Sa vlé di inyowé kòʼy pou lapéti mwen, ");
INSERT INTO acfNT_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","paski moun-an ki tjenn laviʼy pou kòʼy kay pèdiʼy, mé moun-an ki pèd laviʼy pou lapéti mwen kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Ki pwofi an moun kay ni si i genyen tout latè-a épi i pèdi lavi étonnèl? La pa ni anyen i sa bay pou jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Paski Gason Lézòm-lan kay vini épi sé nanj li-a an gwan pouvwa Papaʼy épi i kay bay tout moun sa yo méwité pou mannyè yo viv asou latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Mwen ka asiwéʼw, la ni moun isi-a ki pa kay ni tan mò avan yo wè Gason Lézòm-lan vin kondwi.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Sis jou apwé, Jézi pwan Pita épi dé fwè-a, Jémz épi Jan, épi i mennen yo mouté anlè an mòn ki ho, épi yo té la pa kò yo. ");
INSERT INTO acfNT_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Paditan sé disip-la ka gadé, yo wè an chanjman vini asou Jézi. Fidjiʼy té ka kléwé kon sòlèy-la, épi had li té blan tèlman, i té ka vèglé yo. ");
INSERT INTO acfNT_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Lè sala twa disip-la wè Moziz épi Ilaydja ka palé épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Lè yo wè sa, Pita di Jézi, “Mèt, i bon nou isi-a! Si ou vlé, mwen kay fè twa ti kay, yonn baʼw, yonn bay Moziz épi yonn bay Ilaydja.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Paditan i té ka palé, on nwaj ki té ka kléwé an chay kouvè yo épi yo tann an vwa palé an nwaj-la, i di, “Sa sé Gason mwen. Pa dé enmen mwen enmenʼy, épi mwen byen plè épiʼy. Sé pou zòt koutéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Lè sé disip-la tann vwa-a, yo té pè tèlman yo tonbé atè fas anba. ");
INSERT INTO acfNT_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jézi vini épi i touché yo. I di yo, “Lévé! Ou pa bizwen pè!” ");
INSERT INTO acfNT_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Lè yo lévé, yo wè sé Jézi yonn ki té la. ");
INSERT INTO acfNT_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Lè yo té ka désann mòn-an, Jézi palé byen sèwyé ba yo. I di yo, “Pa di pyèsonn sa zòt wè-a pou jis tan mwen Gason Lézòm-lan wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Sé disip-la mandé Jézi, “Ou sé Mèsaya-a, kon sa pouki sé titja lwa-a di Ilaydja ni pou vini avan?” ");
INSERT INTO acfNT_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jézi di yo, “Wi, sa vwé. Ilaydja ni pou vini avan, paski sé li ki kay pwépawé tout bagay. ");
INSERT INTO acfNT_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Mé atjwèlman mwen ka diʼw, Ilaydja ja vini déja, épi yo fèʼy sa yo té vlé paski yo pa té sav sété li, épi sé menm mannyè-a yo kay maltwété Gason Lézòm-lan.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Lè sala sé disip-la té vin konpwann sété Jan Batis i té ka palé lè i té di yo Ilaydja té ja vini déja. ");
INSERT INTO acfNT_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Lè Jézi épi sé disip li-a viwé koté sé lézòt sé moun-an té yé-a, an nonm vini koté Jézi épi i ajounou douvanʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","I di, “Mèt, ni konpasyon asou gason mwen! I ni an mové malkadi ka pwanʼy épi i ka pwanʼy tèlman téwib, délè i ka jétéʼy an difé-a ében an dlo-a. ");
INSERT INTO acfNT_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Mwen mennenʼy bay sé disip ou-a, mé yo pa té sa djéwiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jézi di yo, “Zòt sé moun sala pa ni lafwa an Bondyé, épi lavi zòt kochi! Ki otan tan mwen ni pou wèsté la épi zòt avan zòt kwè an mwen? Mwen ja las épi zòt! Mennen tibway-la ban mwen!” ");
INSERT INTO acfNT_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Jézi konmandé vyé lèspwi-a, épi i sòti andidan tibway-la, épi menm lè-a i té djéwi. ");
INSERT INTO acfNT_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Apwé sa, sé disip-la alé koté Jézi pou yo palé ba li yonn, yo mandéʼy, “Ki mannyè nou pa té sa tiwé lèspwi-a andidan tibway-la?” ");
INSERT INTO acfNT_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Jézi di yo, “Sé paski ou pa té ni asé lafwa an Bondyé. Mwen ka asiwéʼw, si ou té ni an ti tak lafwa gwòsè an ti gwenn moutad, ou té kay sa di mòn sala, ‘Sòti la épi alé pa la,’ épi i té kay alé. Ou té kay sa fè népòt bagay!”  ");
INSERT INTO acfNT_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Mé ou pa sa tiwé kalité lèspwi sala si ou pa pwédyé épi wèsté san manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Lè tout sé disip-la té asanblé an Galili, Jézi di yo, “Talè moun kay ladjé mwen Gason Lézòm-lan anba lanmen nonm ");
INSERT INTO acfNT_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ki kay tjwé mwen, mé asou twazyenm jou-a, mwen kay wésisité.” Sa té fè sé disip-la lapenn an chay. ");
INSERT INTO acfNT_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Lè Jézi épi sé disip-la wivé Kapènéyòm, sé moun-an ki té ka anmasé taks bay Kay Bondyé-a vini koté Pita épi yo diʼy, “Mèt ou ka péyé taks Kay Bondyé toulé lanné, kouman.” ");
INSERT INTO acfNT_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pita di, “Mé wi!” Lè Pita antwé an kay-la, Jézi palé ba li avan. I di, “Simon, ban mwen wipinyonʼw, ki moun ki sipozé péyé taks épi lajan ladwenn bay wa plas-la? Ès sé jan plas-la ében sé étwanjé-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pita diʼy, “Sé étwanjé-a, kouman.” Jézi diʼy, “Ében, sa vlé di jan plas-la pa ni pou péyé. ");
INSERT INTO acfNT_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Mé nou pa vlé ofwansé yo. Pwan zenʼw épi voyéʼy an lanmè-a épi pwèmyé pwéson-an ou tjenbé-a, ou kay gadé an djòl li, ou kay wè an pyès lajan ki ni asé pou péyé taks Kay Bondyé-a bay ni mwen ni ou. Kon sa ou kay pwanʼy épi ou kay péyé taks pou nou dé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Apwé sa, sé disip-la vini koté Jézi épi yo mandéʼy, “Mèt, kilès ki pli enpòtan anpami sé moun-an Bondyé ka kondwi-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Jézi kwiyé an ti manmay épi i météʼy doubout douvan yo. ");
INSERT INTO acfNT_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","I di yo, “Mwen ka asiwéʼw, si an moun pa chanjé mannyèʼy épi pwan mannyè an ti manmay, i pa kay sa vini anba kondwit Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Moun-an ki pli enpòtan anpami sé moun-an Bondyé ka kondwi-a sé moun-an ki abésé kòʼy épi vini kon ti manmay sala, ");
INSERT INTO acfNT_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","épi moun-an ki wisivwè an ti manmay kon sa pou lapéti mwen wisivwè mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Si pyèsonn fè yonn an sé ti manmay sala ki kwè an mwen-an tiwé lafwaʼy an mwen, i té kay pli mèyè pou moun sala si yo té mawé an woul moulen an kouʼy épi néyéʼy an lanmè-a ki pli fon-an. ");
INSERT INTO acfNT_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","I mové an chay, paski an latè-a ni bagay ki ka fè moun pèdi lafwa yo. Bagay kon sa kay toujou fèt, mé i kay téwib pou moun-an ki annékòz li fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Si lanmenʼw ében pyéʼw ka annékòz ou pèdi lafwaʼw an mwen, koupéʼy épi jétéʼy. I pli mèyè pouʼw mantjé yon lanmen ében yon pyé épi pouʼw ni lavi étonnèl pito pouʼw ni toulé dé lanmenʼw èk toulé dé pyéʼw, épi pou Bondyé jétéʼw lanfè, koté difé-a pa ka janmen étenn. ");
INSERT INTO acfNT_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Épi si zyéʼw ka fèʼw pèdi lafwaʼw an mwen, tiwéʼy épi jétéʼy. I pli mèyè pouʼw mantjé on zyé épi ou ni lavi étonnèl pasé pouʼw ni toulé dé zyéʼw épi Bondyé jétéʼw lanfè, koté difé-a kay toujou bwilé. ");
INSERT INTO acfNT_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Sé pa pouʼw di sé ti manmay sala ki kwè an mwen-an pa enpòtan. Mwen ka diʼw, nanj gadyenn sé ti manmay sala toujou douvan Papa mwen ki an syèl.  ");
INSERT INTO acfNT_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Paski mwen, Gason Lézòm-lan, vini chaché sové sa ki pèd. ");
INSERT INTO acfNT_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Mi sa an nonm ki ni yon san mouton kay fè lè yonn pèd. I kay kité katwiven diznèf-la (99) asou mòn-an ka manjé, épi i kay chaché pou sa ki pèd-la pou jis tan i jwenn li, ");
INSERT INTO acfNT_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","épi lè i jwenn li, mwen ka asiwéʼw i kay kontan plis pou sa i jwenn-an pasé lòt katwiven diznèf-la (99) ki pa té pèd-la. ");
INSERT INTO acfNT_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Épi sé menm kon Papaʼw ki an syèl, i pa vlé yonn an sé ti manmay sala ki ja kwè an li-a pèd. ");
INSERT INTO acfNT_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Si fwèʼw fè an péché kont ou, alé épi moutwé fwè-a lèwèʼy. Mé fèʼy an sigwé ant zòt dé-a. Si i dakò épiʼw, ou ja genyenʼy viwé kon an fwè. ");
INSERT INTO acfNT_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Mé si i pa dakò, alé pwan yonn ében dé moun épi mennen épiʼw, paski lévanjil-la di ou pa sa fè an akizasyon kont an moun si ou pa ni dé ében plis témwen. ");
INSERT INTO acfNT_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Si i pa vlé kouté sé moun sala, ou kay mennen sa douvan légliz-la, épi si i wifizé dakò épi légliz-la, twétéʼy kon an moun ki pa an fwè ében yonn an sé bòbòlis-la ki ka anmasé taks-la. ");
INSERT INTO acfNT_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Kon sa mwen ka diʼw, népòt bagay zòt anpéché fèt asou latè-a pa kay fèt an syèl, épi népòt sa ou kité fèt asou latè-a kay fèt an syèl. ");
INSERT INTO acfNT_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Épi mwen ka diʼw ankò, si dé an zòt ki asou latè-a dakò pou mandé Bondyé népòt bagay, Papa mwen ki an syèl kay bay zòt sa zòt mandé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Paski koté dé ében plis moun asanblé pou pwédyé an non mwen, mwen la anpami yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Pita vini koté Jézi épi i mandéʼy, “Mèt, konmen fwa mwen ni pou pawdonnen fwè mwen ki ka kontiné péché kont mwen? Ès sé sèt fwa?” ");
INSERT INTO acfNT_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Jézi diʼy, “Non, sé pa sèt fwa. Ou ni pou pawdonnenʼy swasant dis (70) fwa sèt fwa. ");
INSERT INTO acfNT_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Mwen ka diʼw sa paski mannyè Bondyé ka kondwi sé menm kon an wa ki di i kay konté konmen lajan sé chèf ofisyéʼy-la dwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Lè i koumansé fè sa, sé ofisyé-a mennen an lòt ofisyé ki té dwéʼy konmen milyon dòla. ");
INSERT INTO acfNT_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ofisyé-a pa té ni asé lajan pouʼy té péyé wa-a, kon sa wa-a di i kay ni pou vann li, madanm li épi ich li an èslavay, épi ofisyé-a kay ni pou pwan tout sa i ni pou péyé dèt-la i ka dwé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ofisyé-a tonbé ajounou douvan wa-a. I diʼy, ‘Souplé Mèt, pwan pasyans épi mwen, èk mwen kay péyéʼw tout sa mwen ka dwéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","I fè wa-a lapenn, kon sa wa-a diʼy, ‘Alé, ou pa ka dwé mwen ankò. Kité tout lajan-an ou té dwé mwen-an.’ ");
INSERT INTO acfNT_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Lè chèf ofisyé-a alé, i jwenn an lòt ofisyé menm kon li ki té dwéʼy an ti tak lajan. I tjenbéʼy an gòj li épi i koumansé twangléʼy. I diʼy, ‘Péyé mwen tout lajan-an ou ka dwé mwen-an!’ ");
INSERT INTO acfNT_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Lòt ofisyé kanmawad li-a ajounou épi i diʼy, ‘Souplé, ni pasyans épi mwen èk mwen kay péyéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Mé i wifizé fè sa. I fè yo météʼy lajòl pito, pou jis tan i péyé tout lajan-an i té dwéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Lè sé lézòt ofisyé-a wè sa i fè-a, sa fè yo lapenn an chay épi yo alé di wa-a tout sa ki té fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Kon sa wa-a kwiyé ofisyé-a épi i diʼy, ‘Ou sé an mové sèvant! Mwen kité tout lajan-an ou té dwé mwen-an, paski ou té mandé mwen pou ni pasyans épiʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ou té sipozé ni konpasyon asou lòt ofisyé-a menm kon mwen té ni asouʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Wa-a té faché an chay épi i fè yo mété ofisyé-a lajòl pou yo fèʼy méchansté pou jis tan i péyé dènyé lajan-an i té dwé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Épi lè Jézi fin di yo sa, i di yo, “Sé menm mannyè-a Papa mwen ki an syèl-la kay fè zòt chak si ou pa pawdonnen fwèʼw ofon tjèʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Lè Jézi fini di yo sa, i kité Galili épi i alé an Joudiya, lòt bò Lawivyè Jouden-an. ");
INSERT INTO acfNT_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","An chay moun swiv li, épi i djéwi tout sa ki té malad anpami yo. ");
INSERT INTO acfNT_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Adan sé Fawizyen-an vini koté Jézi pou gadé si yo té sa kwennenʼy épi kwèsyon. Yo mandé Jézi, “Ès lwa-a ka bay an nonm pèwmisyon pou dévosé madanm li pou népòt wézon?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jézi di yo, “Ès ou pʼòkò li sa lévanjil-la di? I di, an koumansman-an Bondyé té fè moun, nonm épi fanm, ");
INSERT INTO acfNT_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","épi Bondyé di, ‘Sé pou wézon sala an nonm kay kité manmanʼy épi papaʼy épi i kay viv épi madanm li kon madanm èk misyé, épi yo kay kon on sèl moun.’ ");
INSERT INTO acfNT_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Kon sa yo pa dé moun ankò, mé an sèl. Pyès nonm pa sipozé sépawé sa Bondyé ja mété ansanm.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Sé Fawizyen-an mandéʼy, “Bon, pouki pou Moziz ban nou lwa-a ki di an nonm sa bay madanm li on satifika dévosé épi voyéʼy alé?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jézi wéponn yo, “Moziz kitéʼw fè sa paski tjè zòt té twò wèd, mé an koumansman-an lè Bondyé té fè moun, sé pa kon sa i té yé. ");
INSERT INTO acfNT_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ében mwen ka diʼw, si an nonm dévosé madanm li pou pyès wézon apa di si madanm-lan fè adiltè, épi i mayé an lòt fanm, nonm sala ka fè adiltè.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Sé disip-la di Jézi, “Ében, si sé kon sa mawiyaj yé, i pli mèyè pou an moun wèsté san mayé.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jézi di yo, “Sé pawòl sala pa pou tout moun, mé pou sé moun-an Bondyé bay pouvwa-a pou sa aksèptéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","La ni diféwan wézon an nonm pa ka mayé. Adan pa ka mayé paski yo fèt pou yo pa mayé. Adan pa ka mayé paski nonm chatwé yo, épi lézòt pa ka mayé pou yo sa twavay anba kondwit Bondyé pli mèyè. Moun-an ki sa konpwann sa-a, kitéʼy konpwann.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Déotwa moun mennen ti manmay bay Jézi pouʼy té sa mété lanmenʼy anlè yo épi pwédyé ba yo, mé sé disip-la pwi dèyè yo. ");
INSERT INTO acfNT_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Jézi di yo, “Kité sé ti manmay-la vini jwenn mwen épi pa anpéché yo, paski sé moun kon sé ti manmay sala ki ka vini anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jézi mété lanmenʼy anlè sé ti manmay-la épi i benni yo épi i alé. ");
INSERT INTO acfNT_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","An jou an nonm alé koté Jézi épi i mandéʼy, “Titja, kilès bon bagay mwen ni pou fè pou Bondyé ban mwen lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jézi diʼy, “Pouki ou ka mandé mwen konsèné bagay ki bon? Sé Bondyé yonn ki bon. Si ou vlé ni lavi étonnèl, obéyi sé konmandman-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","I mandé Jézi, “Kilès konmandman?” Jézi diʼy, “Pa tjwé, pa fè adiltè, pa vòlè, pa sèvi fo témwen kont lòt moun, ");
INSERT INTO acfNT_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","wèspèkté manmanʼw épi papaʼw, épi enmen pwochenʼw menm kon kòʼw menm.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Jenn nonm-lan di, “Mwen ja obéyi tout sé konmandman sala. Ki sa mwen ni pou fè ankò?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jézi diʼy, “Si ou vlé vini pawfé, alé vann tout sa ou ni épi bay lé pòv lajan-an, épi ou kay ni wichès an syèl, épi apwé sa vini swiv mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Lè nonm-lan tann Jézi di sa, i pati tou an lapenn paski i té wich an chay. ");
INSERT INTO acfNT_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jézi di sé disip-la, “Mwen ka asiwéʼw, i kay wèd an chay pou moun ki wich vini anba kondwit Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Mwen ka diʼw ankò, i pli ézé pou an kanmèl antwé adan zyé an zédjwi pasé an nonm ki wich vini anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Lè sé disip-la tann sa, yo té sipwi an chay! Yo di, “Ében, si sé sa, ki moun ki kay ni lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jézi gadé sé disip-la an mitan zyé épi i di yo, “I enposib pou moun, mé pou Bondyé tout bagay posib.” ");
INSERT INTO acfNT_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Lè sala Pita palé, i diʼy, “Mi, nou kité tout bagay dèyè épi nou vini swiv ou. Ki sa nou kay jwenn pou sa?” ");
INSERT INTO acfNT_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jézi di yo, “Mwen ka asiwéʼw, lè Gason Lézòm-lan kay kondwi latè nèf-la èk tout moun ka glowifyéʼy, zòt douz-la ki ka swiv mwen-an kay kondwi tou. Zòt kay asid pou kondwi douz nasyon Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Épi tout moun ki ja kité kay, fwè, sésé, papa, manman, ich, ében tè pou lapéti mwen, kay jwenn yon san fwa plis pasé sa yo té ni-an, épi yo kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Lè Bondyé kay kondwi kon wa, an chay moun ki douvan atjwèlman kay wèsté dèyè, épi an chay moun ki dèyè atjwèlman kay pwan douvan. ");
INSERT INTO acfNT_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Mannyè Bondyé ka kondwi sé menm kon an nonm ki alé bonnè bonmaten ay anplowé moun pou twavay an jadenʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","épi i dakò pou péyé yo lajan-an yo ka jwenn pou jouné-a, épi i voyé yo alé twavay. ");
INSERT INTO acfNT_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“I alé ankò bò chimen-an a névè épi i jwenn déotwa nonm doubout la, anyen a fè. ");
INSERT INTO acfNT_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","I di yo, ‘Ou tou, alé ay twavay an jaden-an ban mwen épi mwen kay péyéʼw pou sa ou fè.’ ");
INSERT INTO acfNT_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Kon sa yo alé. “Lè i té midi épi twazè ankò, i fè menm bagay-la. ");
INSERT INTO acfNT_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Lè i té pwèskè senkè, i alé bò chimen-an épi i wè déotwa nonm doubout la toujou. I di, ‘Pouki ou la anyen, a fè? Tout jouné-a ou la, anyen a fè?’ ");
INSERT INTO acfNT_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“Yo di, ‘Pyèsonn pa anplowé nou.’ “I di yo, ‘Ében, alé ay twavay an jaden-an ban mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Lè yo ladjé twavay a sizè, mèt jaden-an di kolonm li, ‘Kwiyé sé nonm-lan épi péyé yo ban mwen. Koumansé épi sa mwen té anplowé dènyé-a pou wivé asou pwèmyé-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Sé nonm-lan ki té koumansé twavay a senkè apwémidi-a jwenn lajan pou an jouné twavay. ");
INSERT INTO acfNT_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Lè sé nonm-lan i té anplowé dépi bonmaten-an vini pou wisivwè lajan yo, yo kwè yo té kay jwenn plis, mé i péyé yo menm kantité èk tout moun. ");
INSERT INTO acfNT_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Yo pwan lajan yo épi yo koumansé bougonnen kont mèt jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Yo di, ‘Sé nonm sala ou anplowé dènyé-a twavay pou yon nèditan tousèl, épi nou menm twavay wèd an tout sòlèy cho-a! Ki mannyè ou ka péyé yo menm otan lajan épi nou?’ ");
INSERT INTO acfNT_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Mèt jaden-an di, ‘Kouté kanmawad, mwen pʼòkò vòlèʼw. Ès ou pa té dakò pouʼw twavay ban mwen pou lajan on jouné? ");
INSERT INTO acfNT_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ében, pwan lajanʼw épi alé lakay ou. Mwen ja désidé pou bay nonm sala mwen anplowé dènyé-a menm kantité lajan épiʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Ès mwen pa ni dwa fè sa mwen vlé épi lajan mwen? Ès ou jalou paski mwen ni an bon tjè?’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jézi di yo, “Sé kon sa i kay yé lè Bondyé kay kondwi kon wa. An chay moun ki dèyè kay pwan douvan, épi an chay moun ki douvan kay wèsté dèyè.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Lè Jézi té ka mouté Jérouzalèm épi douz disip li-a, i kwiyé yo asou koté épi i palé ba yo an sigwé paditan yo té ka alé. ");
INSERT INTO acfNT_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","I di yo, “Kouté, nou ka mouté Jérouzalèm. Moun kay ladjé mwen Gason Lézòm-lan an lanmen sé chèf pwèt-la épi sé titja lwa-a, épi yo kay kondanné mwen pou mò. ");
INSERT INTO acfNT_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Yo kay ladjé mwen an lanmen moun ki pa Jwif épi yo kay motjé mwen, yo kay bat mwen épi yo kay kwisifyé mwen, mé lè i ni twa jou, Bondyé kay fè mwen wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Lè sala madanm Zèbèdi épi dé gasonʼy vini oti Jézi èk i ajounou douvan Jézi pou mandéʼy an favè. ");
INSERT INTO acfNT_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jézi mandéʼy, “Ki sa ou vlé?” I di Jézi, “Mwen vléʼw pwonmèt mwen ou kay onnowé sé gason mwen-an épi mété yonn asou lanmen dwèt ou épi yonn asou lanmen gòch lè ou kay wa.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jézi di sé gason-an, “Zòt pa sav ki sa zòt ka mandé-a. Ès zòt kay sa bwè an menm pòt soufwans-lan mwen kay bwè-a?” Yo di, “Wi, nou sa fèʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jézi di yo, “Wi, zòt kay soufè menm mannyè mwen kay soufè-a, mé sé pa mwen ki ka chwazi ki moun pou asid asou lanmen dwèt mwen épi asou lanmen gòch. Sé Papa mwen ki an syèl ki ka désidé ki moun i ja pwépawé plas sala bay.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Lè dis lézòt disip-la vin konnèt sa, yo té faché kont dé fwè-a an chay. ");
INSERT INTO acfNT_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Kon sa Jézi kwiyé tout sé disip-la ansanm épi i di yo, “Ou konnèt mannyè sé gouvènè sé moun-an ki pa kwè an Bondyé-a ka kondwi. Yo ka konmandé an moun, ‘Fè sa,’ épi i ni pou fèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Mé sé pa kon sa i kay yé anpami zòt. Moun-an ki vlé vini enpòtan anpami zòt-la kay ni pou sèvant-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Si yonn an zòt vlé vini pli enpòtan, sé li ki ni pou sèvant-lan — ");
INSERT INTO acfNT_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","menm kon mwen Gason Lézòm-lan. Mwen pa vini pou moun té sèvi mwen sèvant, mé mwen vini pou sèvi moun sèvant épi pou mwen bay lavi mwen pou mwen sové an chay moun.” ");
INSERT INTO acfNT_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Lè Jézi épi sé disip li-a té ka kité vil Jèriko, an gwan latilyé moun té ka swiv li. ");
INSERT INTO acfNT_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","La té ni dé nonm avèg ki té asid bò chimen-an. Lè yo tann Jézi ka pasé, yo andjéléʼy, “Mèt, désandan Wa David, édé nou souplé!” ");
INSERT INTO acfNT_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mé sé moun-an hélé dèyè yo, “Pé la!” Mé yo hélé pli fò, yo di, “Mèt, désandan Wa David, édé nou souplé!” ");
INSERT INTO acfNT_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Jézi doubout épi i kwiyé yo, “Ki sa ou vlé mwen fè baʼw?” ");
INSERT INTO acfNT_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Yo di, “Mèt, fè nou wè!” ");
INSERT INTO acfNT_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Yo fè Jézi lapenn épi i touché zyé yo, épi menm lè-a yo vin wè klè épi yo pati ay swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Lè Jézi épi sé disip li-a wivé tou pwé Jérouzalèm adan on vilaj yo ka kwiyé Bèfaj, bò Mòn Òliv-la, i voyé dé an sé disip li-a alé douvan ");
INSERT INTO acfNT_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","épi i di yo, “Alé an vilaj-la ki douvanʼw-lan épi kon sa ou wivé la, ou kay jwenn on bouwik mawé épi pitiʼy bòʼy. Démawéʼy épi mennenʼy ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Épi si pyèsonn diʼw anyen, di moun-an, ‘Mèt-la bizwen yo,’ épi menm lè-a i kay kitéʼw alé épi yo.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Sa fèt pou fè sa pwòfèt-la té di-a vini vwé, i di, ");
INSERT INTO acfNT_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Di jan Jérouzalèm, ‘Mi, wa zòt ka vini jwenn zòt! I dous, i ka vini asou an bouwik, an jenn ti bouwik, ich on manman bouwik!’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Sé disip-la alé épi yo fè menm sa Jézi té di yo fè. ");
INSERT INTO acfNT_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Yo mennen manman bouwik-la èk piti-a épi yo ouvè had yo anlèʼy, épi Jézi moutéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","An chay an sé moun-an ki té la-a ouvè had yo an chimen-an, épi lézòt koupé bwanch bwa mété an chimen-an. ");
INSERT INTO acfNT_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Moun ki té ka maché douvan Jézi épi moun ki té ka maché dèyèʼy koumansé hélé fò, “Tout lonnè pou désandan Wa David-la! “Pa dé bon i bon pou moun-an Bondyé voyé-a! “Tout lonnè pou Bondyé ki an syèl-la!” ");
INSERT INTO acfNT_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Lè Jézi antwé Jérouzalèm, sa té lévé an gwo roro an vil-la, épi sé jan vil-la mandé, “Ki moun sa yé?” ");
INSERT INTO acfNT_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sé moun-an ki té ka swiv Jézi-a wéponn, yo di, “Sa sé Jézi, pwòfèt vil Nazawèt-la ki an Galili.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jézi antwé an Kay Bondyé-a épi i kouwi dèyè tout sé moun-an ki té ka vann èk achté-a, épi i maté tab sé moun-an ki té ka chanjé lajan èk ban sé moun-an ki té ka vann pijon-an. ");
INSERT INTO acfNT_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","I di yo, “Lévanjil-la di, ‘Yo kay kwiyé kay mwen an kay lapwiyè,’ mé ou ka fèʼy an plas koté pou vòlè séwé.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Moun ki té avèg épi sa ki té enfim vini kotéʼy an Kay Bondyé-a, épi i djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Sé chèf pwèt-la épi sé titja lwa sé Jwif-la té faché an chay lè yo wè tout sé miwak-la i té ka fè-a, épi sé manmay-la té ka hélé fò an Kay Bondyé-a, yo di, “Tout lonnè pou désandan Wa David-la!” ");
INSERT INTO acfNT_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Kon sa sé chèf pwèt-la épi sé titja lwa-a mandé Jézi, “Ou pa ka tann ki sa sé manmay-la ka di-a?” Jézi di yo, “Mé wi! Ou pa janmen li sa ki ékwi an lévanjil-la? I di, ‘Bondyé ja moutwé manmay épi ti manmay ki ka tété mannyè pou glowifyéʼy byen.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Jézi kité yo épi i sòti an vil-la, i alé Bèfanni épi i pasé swè-a la. ");
INSERT INTO acfNT_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Lè Jézi té ka viwé Jérouzalèm li denmen bonnè bonmaten, i té fen. ");
INSERT INTO acfNT_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","I wè an pyé fwi bò chimen-an épi i alé bò pyé fwi-a, mé i pa jwenn anyen pasé fèy tousèl. Kon sa i di pyé fwi-a, “Ou pa kay janmen pòté fwi ankò,” épi menm lè-a i di sa-a, pyé fwi-a fennen. ");
INSERT INTO acfNT_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Lè sé disip-la wè sa, yo té sipwi an chay. Yo di, “Ki mannyè pyé fwi sala fennen otan vit?” ");
INSERT INTO acfNT_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jézi wéponn yo, “Mwen ka asiwéʼw, si ou kwè sa ou ka di-a kay fèt èk ou pa ni dé lidé, ou kay sa fè menm sa mwen fè pyé fwi sala. Épi ou kay sa fè plis bagay toujou! Ou kay sa di mòn sala, ‘Sòti koté ou yé-a épi ay jété kòʼw an lanmè-a!’ épi i kay fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Si ou ni lafwa, népòt bagay ou mandé Bondyé an lapwiyè, i kay fèʼy baʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Jézi viwé an Kay Bondyé-a épi paditan i té ka enstwi sé moun-an, sé chèf pwèt-la épi sé ofisyé Jwif-la vini koté Jézi épi yo mandéʼy, “Koté ou jwenn dwa pou fè tout sé bagay sala ou ka fè-a? Ki moun ki baʼw dwa sala?” ");
INSERT INTO acfNT_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jézi di yo, “Mwen kay mandéʼw an sèl kwèsyon tou, épi si ou wéponn mwen, mwen kay diʼw koté mwen jwenn dwa pou fè sé bagay sala mwen ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Lè Jan Batis té ka batizé sé moun-an, ki moun ki té ba li dwa pou batizé, Bondyé ében an nonm?” Yo palé ant yo menm, yo di, “Si nou di sé Bondyé, i kay di nou pouki nou pa té kwè sé bagay-la Jan Batis té di nou-an. ");
INSERT INTO acfNT_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Mé si nou di sé an moun ki té ba li dwa pou batizé moun, nou pè sa sé moun-an kay fè, paski tout sé moun-an asiwé ki Jan Batis sété an pwòfèt.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kon sa yo di, “Nou pa sav.” Épi Jézi di, “Ében, mwen pa kay diʼw nonplis ki moun ki ban mwen dwa pou fè sé bagay-la mwen ka fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jézi di yo, “Ki sa ou kay di pou sa? La té ni an nonm ki té ni dé gason. I alé dèyè pli gwan gason-an, i diʼy, ‘Gason mwen, alé twavay an jaden-an jòdi-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“Gason-an di, ‘Non, mwen pa ka alé,’ mé i chanjé lidéʼy apwé, épi i alé. ");
INSERT INTO acfNT_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Kon sa papa-a alé dèyè dézyenm gason-an. I di, ‘Gason mwen, alé twavay an jaden-an jòdi-a.’ “Dézyenm gason-an di, ‘Wi Papa, mwen kay alé,’ mé i pa alé.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Jézi mandé yo, “Kilès an dé gason sala ki fè sa papaʼy té vlé-a?” Yo di, “Pli gwan gason-an.” Kon sa Jézi di, “Ében mwen ka asiwéʼw, sé bòbòlis-la ki ka anmasé taks-la èk sé fanm vyé lavi-a kay vini anba kondwit Bondyé avanʼw. ");
INSERT INTO acfNT_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Paski Jan Batis vini épi i té ka moutwéʼw mannyè Bondyé vléʼw viv, épi ou pa kwè sa i té ka di-a, mé sé moun-an ki té ka anmasé taks-la épi sé fanm vyé lavi-a kwè, épi magwé ou wè sa, ou pa chanjé lidéʼw pouʼw kwèʼy tou.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jézi di yo, “Kouté an lòt pawabòl ankò. La té ni on mèt tè ki té planté on jaden fwi pou yo fè diven, épi i mété on pak oliwonʼy. I fouyé an twou épi i mété an pwès pou pijé fwi-a pou fè diven-an épi i fè on plas ki ho an jaden-an pouʼy sa véyé vòlè. Épi i lwé jaden sala bay moun épi i alé adan an lòt plas. ");
INSERT INTO acfNT_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Lè fwi-a té bon, i voyé sèvant li alé pwan loʼy ba li an lanmen sé moun-an ki té ka lwé jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Sé nonm-lan i lwé jaden-an bay-la tjenbé sé sèvant-lan, yo bat yonn épi yo tjwé an lòt épi yo tjwé lòt-la épi wòch. ");
INSERT INTO acfNT_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Mèt tè-a voyé lézòt sèvant alé ankò, pli pasé i té voyé pwèmyé kou-a, mé yo fè yo menm sa yo té fè pwèmyé konpanni-an. ");
INSERT INTO acfNT_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Apwé tout sa fèt, i voyé gasonʼy. I di, ‘Yo kay ni wèspé pou gason mwen-an.’ ");
INSERT INTO acfNT_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Mé lè sé nonm-lan ki té ka lwé jaden-an wè gason-an ka vini, yo di bay yonn a lòt, ‘Mi, gason mèt tè-a! Vini! Annou tjwéʼy épi tè-a kay wèsté pou nou!’ ");
INSERT INTO acfNT_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Kon sa yo tjenbé gason-an, yo mennenʼy dèwò jaden-an épi yo tjwéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jézi mandé, “Lè mèt jaden-an vini, ki sa i kay fè sé nonm sala ki té lwé jaden-an?” ");
INSERT INTO acfNT_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Yo di, “I pa kay pa tjwé sé nonm mové sala! Épi i kay lwé jaden-an bay lòt moun ki kay ba li loʼy lè lè-a vini.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Jézi di yo, “Ès ou pʼòkò li sa lévanjil-la di? I di, ‘Menm wòch-la sé nonm-lan ki té ka bati kay-la widjèkté-a, sé li ki tounen wòch-la ki pli enpòtan an kay-la. Sé Bondyé menm ki fè sa, épi sa sé an bèl bagay pou nou wè!’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jézi di yo, “Ében mwen ka diʼw, Bondyé kay pwan pwivilaj-la ou té ni pou vini anba kondwit li épi i kay bay an lòt konpanni moun li, moun ki kay fè sa Bondyé vlé.  ");
INSERT INTO acfNT_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Moun-an ki tonbé asou wòch sala kay kwazé an miyèt épi moun-an wòch-la tonbé anlèʼy-la kay fè lapousyè.” ");
INSERT INTO acfNT_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Sé chèf pwèt-la épi sé Fawizyen-an tann sé pawabòl-la épi yo sav sété yo menm i té ka palé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Kon sa yo éséyé pou té tjenbé Jézi, mé yo té pè sé moun-an paski sé moun-an di Jézi sé an pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jézi palé bay sé moun-an an pawabòl ankò. ");
INSERT INTO acfNT_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","I di yo, “Mannyè Bondyé ka kondwi sé menm kon an wa ki fè an gwan nòs bay gasonʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","I voyé sèvant li ay kwiyé sé moun-an i té envité-a, mé yo wifizé vini. ");
INSERT INTO acfNT_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Kon sa wa-a voyé lòt sèvant alé ankò. I di yo, ‘Di sé moun-an mwen ja tjwé jenn towo mwen-an épi lézòt bèl bèf. Tout bagay ja pawé, kon sa vini pou manjé an fèt-la.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Mé sé moun-an i té envité-a pa menm bay sé sèvant-lan ganm. Yonn pati asou bitasyonʼy, lòt-la pati an magazenʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","sé lézòt-la tjenbé sé sèvant-lan, yo bat yo épi tjwé yo. ");
INSERT INTO acfNT_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wa-a té faché tèlman i voyé sòldaʼy tjwé tout sé méchan nonm sala épi bwilé vil yo. ");
INSERT INTO acfNT_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Wa-a kwiyé sé sèvant li-a, i di yo, ‘Fèt-la ja pawé, mé sé moun-an mwen envité-a pa té méwité sa.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Épi wa-a di sé sèvant li-a, ‘Alé asou lawi-a épi envité tout moun ou jwenn.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Kon sa sé sèvant-lan alé asou lawi-a. Yo envité tout moun yo jwenn, bon kon mové, épi kay-la té plen moun. ");
INSERT INTO acfNT_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wa-a antwé an kay-la ay gadé sé moun-an ki té envité an nòs-la épi lè i wivé la, i wè an nonm ki pa té abiyé èk had yo ka mété pou vini an nòs. ");
INSERT INTO acfNT_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","I di nonm-lan, ‘Kanmawad mwen, ki mannyè ou fè antwé isi-a abiyé kon sa?’ Mé nonm-lan pa di on mo pawòl. ");
INSERT INTO acfNT_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Wa-a di sé gad li-a, ‘Pwan nonm sala, mawé ni pyéʼy ni lanmenʼy épi jétéʼy dèwò an nwèsè-a koté i kay pléwé épi i kay kwatjé danʼy.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Épi lè Jézi fini palé bay sé moun-an, i di yo, “Bondyé ka envité an pil moun, mé sé pa tout moun i kay chwazi pou manjé an fèsten-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Sé Fawizyen-an ki té la-a pati, épi yo ay fè an plan pou wè ki kwèsyon pou mandé Jézi pou kwennenʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Épi yo voyé déotwa an sé disip yo-a épi déotwa nonm ki té ka sipòté Wa Hèròd. Épi yo di Jézi, “Titja, nou sav ou ka di lavéwité-a. Ou ka enstwi moun mannyè Bondyé vlé yo viv. Ou pa mélé sa moun kwè, ni ou pa mélé ki pozisyon nonm ni. ");
INSERT INTO acfNT_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ban nou wipinyonʼw. Ès i kont lwa nou pou nou péyé taks bay Siza, wa Ronm-lan?” ");
INSERT INTO acfNT_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Mé Jézi té konnèt vyé plan-an yo té ka katjilé-a épi i di yo, “Débann ipokwit! Pouki ou vlé kwennen mwen épi vyé kwèsyonʼw-lan? ");
INSERT INTO acfNT_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Moutwé mwen lajan-an ou ka péyé taks-la.” Yo mennenʼy ba li épi ");
INSERT INTO acfNT_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","i di, “Fidji ki moun épi non ki moun ki anlèʼy?” ");
INSERT INTO acfNT_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Yo wéponn épi yo diʼy, “Sé sa Wa Siza.” I di yo, “Ében, bay Siza sa ki pou Siza épi bay Bondyé sa ki pou Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Lè yo tann sa, yo té sipwi an chay épi yo kitéʼy èk yo pati. ");
INSERT INTO acfNT_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Menm jou sala déotwa Sadisyen vini koté Jézi. Sé Sadisyen-an kwè sé moun-an ki ja mò-a pa ka wésisité. ");
INSERT INTO acfNT_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Yo di Jézi, “Titja, lwa Moziz-la di si an nonm mò san i ni pyès ich èk madanm li, on fwèʼy ni pou mayé èk madanm-lan i kité-a épi i ni pou fè ich bay fwè-a ki mò-a. ");
INSERT INTO acfNT_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Bon, la té ni sèt fwè ki té ka wèsté isi-a. Pli gwan fwè-a mayé an madanm épi nonm-lan mò, mé yo pa té ni pyès ich, épi dézyenm fwè-a mayé madanm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Menm bagay-la wivé dézyenm-lan, twazyenm-lan jis pou dènyé fwè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Dènyéman madanm-lan menm vin mò. ");
INSERT INTO acfNT_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Bon, asou jou-a lè tout moun ki ja mò ni pou wésisité-a, madanm kilès an yo madanm sala kay yé? Paski yo tout té mayé épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jézi wéponn yo épi i di, “Ou an lèwè lè ou di moun mò pa ka wésisité. Sé paski ou pa konnèt sa lévanjil-la di épi ou pa konnèt pouvwa Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Paski lè sé mò-a kay wésisité, yo kay menm kon nanj ki an syèl, yo pa kay mayé. ");
INSERT INTO acfNT_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Bon, konsèné lè moun kay wésisité, ès ou pʼòkò li sa Bondyé di an lévanjil-la? I di, ");
INSERT INTO acfNT_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Sé mwen ki Bondyé-a Abrahanm, Ayzak épi Jakòb ka adowé-a.’ ” Kon sa Jézi di, “Bondyé sé pa Bondyé moun ki mò, mé i sé Bondyé moun ki vivan osi apwé yo ja mò asou latè.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Lè sé moun-an tann sa, yo té sipwi pou yo tann sé bagay-la i té ka enstwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Lè sé Fawizyen-an tann Jézi té fè sé Sadisyen-an fèmé bouch yo, yo asanblé ansanm épi yo alé koté Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","épi yonn adan yo ki sété on titja lwa Moziz-la, mandéʼy on kwèsyon pouʼy té wè si i té sa kwennenʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","I diʼy, “Titja, kilès ki pli enpòtan konmandman an lwa Moziz-la?” ");
INSERT INTO acfNT_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jézi wéponn li, “ ‘Enmen Bondyé Senyèʼw épi tout tjèʼw, tout lam ou èk tout lidéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Sé sa ki pwèmyé épi pli enpòtan konmandman-an, ");
INSERT INTO acfNT_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","épi dézyenm konmandman-an ki enpòtan menm kon pwèmyé-a sé, ‘Enmen pwochenʼw menm kon ou enmen kòʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Si ou obéyi dé konmandman sala, ou obéyi tout lwa Moziz-la épi tout sa sé pwòfèt-la té ka enstwi-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Lè adan sé Fawizyen-an té asanblé ansanm, Jézi mandé yo, ");
INSERT INTO acfNT_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“An wipinyonʼw, désandan ki moun Mèsaya-a yé?” Yo di, “I sé désandan Wa David, kouman.” ");
INSERT INTO acfNT_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","I di, “Bon, si sé désandan David tousèl i yé, pouki Lèspwi Bondyé fè David kwiyéʼy, ‘Senyè’? David di, ");
INSERT INTO acfNT_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Bondyé di bay Senyè mwen: Asid asou lanmen dwèt mwen jis tan mwen fè lèlmiʼw tounen an ti ban pou mété pyéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Bon, si Wa David kwiyéʼy ‘Senyè,’ ki mannyè Mèsaya-a ka fè sé désandan David sèlman, èk anyen ankò?” ");
INSERT INTO acfNT_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Épi pyèsonn pa té sa wéponn Jézi kwèsyon sala, épi dépi jou sala tout moun té pè mandéʼy kwèsyon. ");
INSERT INTO acfNT_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Jézi palé bay moun ki té la épi sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","I di yo, “Sé titja lwa sé Jwif-la épi sé Fawizyen-an ki ni dwa pou èspliké lwa Moziz-la. ");
INSERT INTO acfNT_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Ou ni pou obéyi tout sa yo diʼw fè, mé pa fè menm sa yo ka fè-a, paski yo pa ka fè sa yo ka enstwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Yo ka bay konmandman ki menm kon an chay lou asou tèt moun, mé yo menm pa ka fè anyen pou édé pòté chay sala. ");
INSERT INTO acfNT_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Tout sa yo ka fè sé pou lézòt moun wè. Yo ka fè an bwèt ki ni pawòl lévanjil-la andidanʼy épi yo ka météʼy asou fon yo épi bwa yo épi yo ka fè woulé had yo lonng pou lézòt moun wè ki kantité wilizyèz yo wilizyèz. ");
INSERT INTO acfNT_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Yo enmen plas-la ki pli enpòtan-an lè yo alé adan an fèsten épi adan sé légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Épi lè ou ka pasé yo asou chimen, yo vléʼw kwiyé yo ‘Titja’. ");
INSERT INTO acfNT_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Pa kwiyé yonn a lòt ‘Titja,’ paski zòt tout sé fwè, épi sé an sèl Titja ki ni. ");
INSERT INTO acfNT_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Épi pa kwiyé yonn a lòt ‘Papa’ an latè-a, paski sé an sèl Papa ki ni an syèl. ");
INSERT INTO acfNT_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Pa kwiyé yonn a lòt ‘Mèt,’ paski sé an sèl Mèt ki ni, sa sé Mèsaya-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Épi sa ki vlé vini pli enpòtan anpami-an, sé li ki ni pou sèvant-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Moun-an ki kwè i pli enpòtan-an, Bondyé kay mennenʼy désann, épi moun-an ki abésé kòʼy-la, sé li Bondyé kay fè vini enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Zòt ipokwit! Ou ka anpéché moun vini anba kondwit Bondyé. Ou menm pa vlé Bondyé kondwi laviʼw, épi ou sé an bawad pou sé moun-an ki té kay avoudwé vini anba kondwit li-a.  ");
INSERT INTO acfNT_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Zòt ipokwit! Ou ka vòlè tout sa sé madanm-lan mawi yo ja mò-a ni. Ou ka vòlè kay yo, mé pou moutwé ou bon tèlman, ou ka fè lonng lapwiyè. Pou sa ou ka fè-a, pinisyonʼw kay pli gwo pasé sa i té sipozé yé. ");
INSERT INTO acfNT_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Zòt ipokwit! Ou ka janbé lanmè-a èk ou ka pasé an tout latè-a ka chaché pou moun pou fè yo vini an wilizyonʼw, épi lè ou jwenn yo, ou ka fè yo vini ich Satan, dé fwa pli méchan pasé ou menm. ");
INSERT INTO acfNT_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ki mizi téwib i kay téwib pou zòt! Ou menm kon an nonm avèg ki ka moutwé an lòt nonm avèg chimen-an. Ou ka di si an moun sèwmanté pa Kay Bondyé-a pouʼy fè an bagay, i pa oblijé fè sa i di-a. Mé si i sèwmanté pa sé vésèl lò-a ki andidan Kay Bondyé-a, i oblijé fè bagay-la i pwonmèt pouʼy fè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Débann inyowan ki avèg! Kilès ki pli enpòtan, bagay-la ki andidan Kay Bondyé-a ében Kay Bondyé-a ki ka fè sé bagay sala nèt-la? ");
INSERT INTO acfNT_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ou ka di tou, ‘Si an moun fè an sèman pa lotèl Bondyé-a, i pa oblijé fè sa i pwonmèt pou fè-a. Mé si i fè an sèman pa kado-a ki anlè lotèl-la, i ni pou fè sa i di i kay fè-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Débann avèg kon zòt yé! Kilès ki pli enpòtan, kado-a ében lotèl-la ki ka fè sé kado-a nèt-la? ");
INSERT INTO acfNT_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Kon sa lè an moun sèwmanté pa lotèl-la, i ka sèwmanté pa lotèl-la épi tout sa ki anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Épi lè an moun sèwmanté pa Kay Bondyé-a, i ka sèwmanté pa Bondyé ki ka wèsté andidan Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Si an nonm fè an sèman pa syèl, i ka sèwmanté pa gwan chèz Bondyé-a épi pa Bondyé ki asid asou chèz-la ka kondwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Débann ipokwit! Ou ka bay Bondyé yon an chak dis an sa ou ni, jis an lanmant, lanni épi pèsi ki ka lévé an jadenʼw, mé ou ka néglijé pou obéyi sé bagay-la ki pli enpòtan an lwaʼy-la. Ou pa ka fè sa ki dwèt, ou pa ka fè bon bay moun, épi ou pa ka tjenn pawòl ou. Wi, ou sipozé bay yon an chak dis an tout sa ou ni, mé pa néglijé sé lézòt bagay sala ki pli enpòtan-an. ");
INSERT INTO acfNT_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Titja ki avèg! Ou ka pasé an ti yenyen ki tonbé an bwèʼw pou pa bwèʼy, mé ou ka valé an kanmèl ki pli gwo. ");
INSERT INTO acfNT_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Débann ipokwit! Ou vlé swiv tout sé lwa-a asou mannyè pouʼw lavé pòt èk plaʼw, mé ou pa mélé ki sa ou ka mété andidan pòt-la. Ou ka plenʼy épi manjé ou jwenn pa bòbòl épi vòlè. ");
INSERT INTO acfNT_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Fawizyen avèg! Tiwé sé mové bagay-la ki andidan pla-a èk pòt-la avan, épi dèwò-a kay vini nèt tou. ");
INSERT INTO acfNT_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Ipokwit! Ou menm kon an tonm yo pentiwé an blan, mé andidan tonm sala plen zo moun mò épi moun ki pouwi. ");
INSERT INTO acfNT_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Sa sé menm kon ou — ou ka pawèt kon moun ki dwèt an dèwò, mé andidan tjèʼw plen péché épi ipokwizi. ");
INSERT INTO acfNT_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ki mizi téwib i kay téwib pou zòt sé titja lwa-a épi sé Fawizyen-an! Zòt ipokwit! Ou ka fè tonm bay sé pwòfèt-la épi ou ka fè fòs sé moun-an ki té dwèt-la bèl. ");
INSERT INTO acfNT_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Épi ou di si ou té la an tan gwan gwanpapa lontanʼw, ou pa té kay fè menm sa yo fè-a. Ou pa té kay tjwé sé pwòfèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Lè ou ka di sa, ou menm ka moutwé ou sé désandan sé moun-an ki té tjwé sé pwòfèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ében, alé épi tjwé lèstan sé pwòfèt-la ki wèsté-a. Alé fini twavay-la gwan gwanpapa lontanʼw té koumansé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Débann sèpan èk ich sèpan kon zòt yé! Ou ja kondanné pou lanfè déja épi ou pa sa chapé anba kondannasyon sala. ");
INSERT INTO acfNT_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Kon sa mwen kay diʼw ki sa ou kay fè. Mwen kay voyé pwòfèt épi titja épi nonm ki konnèt konmandman Bondyé. Ou kay tjwé adan épi ou kay kwisifyé adan, épi adan ou kay bat épi fwèt an sé légliz sé Jwif-la, épi ou kay kouwi dèyè yo épi fè yo sòti adan sé vil-la. ");
INSERT INTO acfNT_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Pou sa ou fè-a, pinisyon pou tout sé moun inosan-an yo té ja tjwé-a kay tonbé asouʼw, koumansé dépi asou Ébèl, nonm dwèt-la, pou wivé jis Zèkaraya, ich Bèrakaya-a. Gwan gwanpapa lontan zòt té tjwéʼy an lakou Kay Bondyé-a, ant lotèl-la épi Kay-la menm. ");
INSERT INTO acfNT_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ében mwen ka asiwéʼw, ou kay ni pou péyé pou lanmò tout sé moun sala ki té mò dépi an tan lontan-an. ");
INSERT INTO acfNT_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Aaaa Jérouzalèm, Jérouzalèm! Zòt tjwé sé pwòfèt-la épi ou tjwé sé konmisyonnè Bondyé-a épi wòch. Plizyè fwa mwen té anvi anbwaséʼw, menm kon yon manman poul ka sanblé tout pitiʼy anba zèl li, mé ou pa té vlé mwen fèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Pou sa ou fè-a, vil-la kay abandonnen, ");
INSERT INTO acfNT_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","épi mwen ka diʼw, ou pa kay wè mwen ankò pou jis tan ou kay di, ‘Pa dé bon i bon pou moun-an Bondyé voyé-a!’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Lè Jézi sòti an Kay Bondyé-a ka maché alé, sé disip-la kwiyéʼy épi yo moutwéʼy mannyè Kay Bondyé-a fèt, ");
INSERT INTO acfNT_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","mé Jézi di yo, “Wi, ou sa gadé tout sé bagay sala, mé mwen ka asiwéʼw, tout kay-la kay kwazé nèt èk pa yon wòch ki kay wèsté asou lòt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jézi té asid asou Mòn Òliv lè sé disip-la vini kotéʼy an sigwé épi yo diʼy, “Di nou ki tan Kay Bondyé-a kay kwazé. Ki sa ki kay fèt pou moutwé i tan pouʼw vini? Épi ki lè tan-an kay bout?” ");
INSERT INTO acfNT_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jézi di yo, “Véyé kòʼw pou pyèsonn pa kwennenʼw, ");
INSERT INTO acfNT_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","paski an chay moun kay vini sèvi non mwen épi yo kay di, ‘Sé mwen ki Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a’ épi yo kay kwennen an chay moun. ");
INSERT INTO acfNT_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ou kay tann ladjè tou pwéʼw épi ou kay tann nouvèl ladjè ka goumen lwen, mé pa kité sa twakaséʼw. Sé bagay sala ni pou fèt, mé sa pa vlé di tan-an ja bout. ");
INSERT INTO acfNT_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Nasyon kay goumen kont nasyon épi wéyòm kay ataké yonn a lòt. La kay ni lafen èk twanblanntè adan an chay koté. ");
INSERT INTO acfNT_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Sé bagay sala sé menm kon pwèmyé mal an madanm ki pawé pou akouché. ");
INSERT INTO acfNT_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Lè sala lèlmiʼw kay fè moun awétéʼw épi yo kay ladjéʼw an lanmen moun ki kay piniʼw épi tjwéʼw, épi tout nasyon kay hayiʼw pou lapéti mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","An tan sala an pil ki ka swiv mwen kay viwé tonbé an péché ankò, épi yo kay hayi épi twayi yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Épi an pil fo pwòfèt kay vini épi yo kay kwennen an chay moun, ");
INSERT INTO acfNT_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Épi la kay ni tèlman movèzté an tan sala, sa kay fè lanmityé an chay moun vini fèb. ");
INSERT INTO acfNT_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Mé moun-an ki tjenbé fò pou jis an bout-la kay sové, ");
INSERT INTO acfNT_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","épi moun kay pwéché Bon Nouvèl-la ki Bondyé kay kondwi adan an mannyè ki nèf. Yo kay pwéché toupatou an latè-a pou tout nasyon jwenn an chans pou aksèpté Bon Nouvèl-la. Épi sé lè sala tan-an kay bout. ");
INSERT INTO acfNT_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pwòfèt Dannyèl té palé asou méchan-an ki kay doubout adan Kay-la ki pou Bondyé yonn-an pou fè abobinasyon. (Kité moun-an ki ka li-a konpwann sa sa vlé di.) Lè ou wè sa fèt, ");
INSERT INTO acfNT_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","sé moun-an ki an péyi Joudiya ni pou kouwi alé an sé mòn-an. ");
INSERT INTO acfNT_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","An nonm ki an balkon kay li pa menm ni pou antwé an kay-la ay pwan sa i ni. ");
INSERT INTO acfNT_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Nonm-lan ki an jaden-an pa ni pou viwé ay pwan bon had pou mété. ");
INSERT INTO acfNT_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sé jou sala kay si tèlman téwib pou manman ki gwo bouden épi sa ki ni ti manmay ka tété! ");
INSERT INTO acfNT_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Pwédyé pou tan-an ou kay ni pou kouwi-a pa an tan fwédi-a ében asou jou sabaf-la, ");
INSERT INTO acfNT_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","paski tan sala kay pli mové pasé pyès lézòt tan ki ja janmen ni, dépi an koumansman latè-a pou jis atjwèlman, ni la pa kay janmen ni on tan ki mové kon sa ankò. ");
INSERT INTO acfNT_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mé Bondyé ja fè tan-an vini pli kout. Si i pa té fè sa, pyèsonn pa té kay sové. Mé pou lapéti sé moun-an i ja chwazi-a, i kay tiwé adan sé jou-a. ");
INSERT INTO acfNT_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Lè sala si pyèsonn diʼw, ‘Mi Mèsaya-a isi-a!’ ében ‘Mi li pa la,’ pa kwèʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","paski la kay ni fo Mèsaya épi fo pwòfèt ki kay vini. Yo kay fè miwak épi gwan twavay épi yo kay éséyé kwennen jis sé moun-an Bondyé ja chwazi-a — si i té posib. ");
INSERT INTO acfNT_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kouté, mwen ja diʼw sa an davans. ");
INSERT INTO acfNT_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Ében si an moun diʼw, ‘Mi li an hòtè,’ pa alé la. Ében yo kay diʼw, ‘Mi li ka séwé isi-a,’ pa kwè yo, ");
INSERT INTO acfNT_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","paski Gason Lézòm-lan kay vini menm kon ou ka wè an kout zéklè ka fèt an sòlèy lévan épi kléwé jis an sòlèy kouchan. ");
INSERT INTO acfNT_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Koté ou wè sé kòbo-a ka asanblé, ou sav sé la kò mò-a yé. Sé menm mannyè-a lè ou wè sé bagay sala ka fèt, ou sav mwen ka vini talè. ");
INSERT INTO acfNT_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Mi sa ki kay fèt imidyètman apwé twaka sé jou sala: ‘Sòlèy-la kay vini nwè épi lalin-an pa kay kléwé ankò. Sé étwal-la kay tonbé sòti an plas yo, épi sé pouvwa-a ki an lézè-a kay soukwé.’ ");
INSERT INTO acfNT_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Lè sala an bagay kay fèt an syèl-la pou moutwé ki Gason Lézòm-lan ka vini, épi tout moun ki asou latè-a kay pléwé. Yo kay wè Gason Lézòm-lan ka vini asou nwaj an syèl-la épi pouvwa épi gwan klèté. ");
INSERT INTO acfNT_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Gwo twonpèt-la kay kòné, épi Gason Lézòm-lan kay voyé nanj li an tout kat kwen latè-a, épi yo kay asanblé tout sé moun-an Bondyé ja chwazi-a an tout latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Kité pyé fwi-a moutwéʼw an lison. Lè ou wèʼy koumansé boujonnen épi i koumansé voyé fèy, ou sav kawenm-lan ka pwan. ");
INSERT INTO acfNT_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Sé menm mannyè-a lè ou wè tout sé bagay sala ka fèt, ou kay sav ki Gason Lézòm-lan ja pawé pou vini. ");
INSERT INTO acfNT_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Chonjé, avan jennenwasyon sala mò, tout sé bagay sala ni pou fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Syèl-la épi latè-a kay fini, mé pawòl mwen kay toujou la pou tout tan. ");
INSERT INTO acfNT_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Mé pyèsonn pa konnèt ki jou ében ki nèditan tan-an kay bout, pa menm nanj ni Gason Bondyé menm. Sé Bondyé Papa-a yonn ki konnèt lè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Menm mannyè i té yé an tan Nowa, sé menm kon sa i kay yé lè Gason Lézòm-lan kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","An tan avan déliz-la moun té ka bwè èk manjé, moun té ka mayé pou jis jou-a Nowa antwé andidan batiman-an, ");
INSERT INTO acfNT_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","épi yo pa té konpwann ki sa ki té ka fèt-la jis tan déliz-la vini, épi yo tout néyé. Sé menm mannyè-a i kay yé lè Gason Lézòm-lan kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","An tan sala dé nonm kay an jaden-an ka twavay ansanm, sé nanj-lan kay pwan yonn, épi lòt-la kay wèsté. ");
INSERT INTO acfNT_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Dé madanm kay la ka pilé gwenn, sé nanj-lan kay pwan yonn, épi lòt-la kay wèsté. ");
INSERT INTO acfNT_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Sé pouʼw véyé, paski ou pa sav ki jou mèt ou kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Si mèt an kay té konnèt ki lè vòlè-a té kay vini, mwen asiwéʼw i té kay véyé pou vòlè-a pa kasé kay li. ");
INSERT INTO acfNT_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Sé kon sa ou ni pou toujou pawé paski Gason Lézòm-lan kay vini an nèditan-an ou pa ka èspéyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Sèvant-lan ki ni lèspwi épi ki obéyisan-an, sé li mèt-la kay mété wèskonsab tout sé lézòt sèvant-lan lè i pa la, pouʼy ba yo manjé lè i lè manjé. ");
INSERT INTO acfNT_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Épi pa dé kontan sèvant sala kay kontan lè mèt li kay déviwé épi i kay jwenn li ka fè twavay-la i té ba li fè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Mwen ka asiwéʼw, mèt-la kay mété tout sa i ni asou kont sèvant sala. ");
INSERT INTO acfNT_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Mé si sèvant-lan sé an mové sèvant, i kay di bay kòʼy, ‘Mèt mwen pʼòkò kay viwé,’ ");
INSERT INTO acfNT_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","épi i kay koumansé bat sé lézòt sèvant-lan épi i kay bwè èk manjé épi sé nèg wonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Mèt sèvant sala kay vini adan an jou sèvant-lan pa ka èspéyé, épi adan an tan i pa sav i kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Mèt-la kay bat sèvant sala mové an chay épi i kay voyéʼy menm koté yo ka voyé sé ipokwit-la, épi la sèvant-lan kay pléwé épi kwatjé danʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Lè mwen Gason Lézòm-lan vini kondwi, mi kon sa i kay yé: La té ni dis jenn fi ki té pwan lanp yo épi pati ay jwenn misyé-a ki kay mayé-a. ");
INSERT INTO acfNT_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Senk adan yo té kouyon épi senk té ni lèspwi. ");
INSERT INTO acfNT_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Sé sa ki té kouyon-an pwan lanp yo mé yo pa té pwan asé lwil, ");
INSERT INTO acfNT_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","mé sé sa ki té ni lèspwi-a mennen lanp yo épi an lòt boutèy lwil pou lanp-lan. ");
INSERT INTO acfNT_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Misyé-a ki kay mayé-a té an wita, épi zyé sé jenn fi-a koumansé fèmé épi sonmèy pwan yo. ");
INSERT INTO acfNT_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“A mennwit an moun hélé, ‘Misyé-a ki kay mayé-a ka vini! Vini jwenn li apwézan!’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Tout sé jenn fi-a lévé épi yo pwépawé lanp yo. ");
INSERT INTO acfNT_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Épi sé sa ki té kouyon-an di sé tifi-a ki té ni lèspwi-a, ‘Ban nou adan lwil ou-a, paski lanp nou ka tenn.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Mé sé sa ki té ni lèspwi-a wéponn, ‘Nou pa sa fè sa pyès! La pa ni asé pou nou épi ou. Alé koté sé moun-an ki ka vann lwil-la épi achté pou kòʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Épi paditan sé jenn fi kouyon-an alé achté lwil, misyé-a ki kay mayé-a wivé, épi senk-lan ki té pawé-a alé an nòs-la èk misyé-a ki kay mayé-a, épi yo fèmé lapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Pli ta, sé lézòt jenn fi-a wivé épi yo koumansé kwiyé, ‘Mèt, mèt, ouvè la ban nou!’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Mé i wéponn yo, ‘Non, mwen ka diʼw mwen pa konnèt ou pyès!’ ” ");
INSERT INTO acfNT_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Lè Jézi fini di yo pawabòl-la, i di yo, “Véyé, paski ou pa konnèt ki jou ében ki nèditan Gason Lézòm-lan kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Lè mwen Gason Lézòm-lan vini kondwi kon wa, mi kon sa i kay yé: La té ni an nonm ki té pawé pou alé asou an voyaj. Kon sa i kwiyé sé sèvant li-a épi i kité tout pozèsyonʼy asou kont yo. ");
INSERT INTO acfNT_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","I bay chak sèvant an pòsyon lajan i kay sa twavay. I bay yonn senk mil (5,000) goud, i bay an lòt dé mil (2,000), épi i bay lòt-la yon mil (1,000), épi nonm-lan pati alé asou voyaj li. ");
INSERT INTO acfNT_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Sèvant-lan i té bay senk mil goud-la alé menm lè-a épi i twavay lajan-an épi i fè an lòt senk mil. ");
INSERT INTO acfNT_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Menm mannyè-a, lòt sèvant-lan i té bay dé mil-la fè an lòt dé mil. ");
INSERT INTO acfNT_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Mé sèvant-lan i té bay yon mil goud-la pwan lajan-an épi i fouyé an twou épi i téwé lajan mèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Apwé an lonng tan, mèt-la witounen lakay li épi i di sé sèvant-lan vini pou yo diʼy ki sa yo fè épi lajan-an i té ba yo-a. ");
INSERT INTO acfNT_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Sèvant-lan i té bay senk mil-la vini épi i diʼy, ‘Ou té ban mwen senk mil goud. Mi an lòt senk mil goud pwofi lajan-an fè ban mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Mèt-la diʼy, ‘Ou ja fè byen! Ou sé an bon sèvant, épi ou byen twavay ti tak lajan-an mwen té ba ou-a. Kon sa mwen kay météʼw wèskonsab an chay lajan. Antwé épi vin wéjwi épi mwen!’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Lè sala sèvant-lan i té bay dé mil goud-la vini épi i diʼy, ‘Mèt, ou té ban mwen dé mil goud. Mi an lòt dé mil pwofi mwen fè.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Mèt-la diʼy, ‘Ou ja fè byen! Ou sé an bon sèvant, épi ou byen twavay ti tak lajan-an mwen té ba ou-a. Kon sa mwen kay météʼw wèskonsab an chay lajan. Antwé épi vin wéjwi épi mwen!’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Lè sala sèvant-lan ki té wisivwè yon mil goud-la vini épi i di, ‘Mèt, mwen sav ou sé an nonm ki wèd. Ou ka wékòlté koté ou pa planté épi ou ka anmasé koté ou pa té simen gwenn. ");
INSERT INTO acfNT_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Mwen té pè, kon sa mwen séwé lajan-an an tè-a. Mi lajanʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Mèt-la di, ‘Ou sé an sèvant ki mové épi fenyan! Ou sav mwen sé an nonm ki wèd, mwen ka wékòlté sa mwen pa planté épi mwen ka anmasé koté mwen pa té simen gwenn. ");
INSERT INTO acfNT_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ében, pouki ou pa té mété lajan mwen-an labank? Lè mwen viwé, mwen té kay jwenn li épi lantéwé. ");
INSERT INTO acfNT_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Pwan lajan-an an lanmenʼy épi bay sèvant-lan ki ni dis mil-laʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","paski moun-an ki byen sèvi bagay-la i ni-an kay ni plis épi i kay ni plis pasé i bizwen. Mé moun-an ki pa byen sèvi ti tak bagay-la i ni-an, jis ti tak-la i ni-an, Bondyé kay pwan an lanmenʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Épi mèt-la di, ‘Pwan vyé sèvant sala épi jétéʼy dèwò an nwèsè-a. Sé la nonm kay pléwé épi kwatjé dan yo.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Lè Gason Lézòm-lan kay vini kon wa épi tout nanj li épiʼy, i kay asid asou gwan chèz li pou kondwi épi tout pouvwaʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Tout moun an tout nasyon kay asanblé douvanʼy, épi i kay sépawé yo an dé konpanni, menm kon an gadyenn ka sépawé mouton hòd kabwit. ");
INSERT INTO acfNT_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","I kay mété sé moun-an ki dwèt-la asou lanmen dwèt épi sé lézòt-la asou lanmen gòch. ");
INSERT INTO acfNT_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Lè sala wa-a kay di sé sa ki asou lanmen dwèt li-a, ‘Vini, ou menm ki té wisivwè bennédiksyon Papa mwen. Vini viv anba kondwit Bondyé èk wisivwè sé bennédiksyon-an i ja pwépawé baʼw dépi an koumansman latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Mwen té fen épi ou ban mwen manjé. Mwen té swèf épi ou ban mwen bwè. Mwen sété on étwanjé épi ou antwé mwen lakay ou. ");
INSERT INTO acfNT_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Mwen té touni épi ou ban mwen had. Mwen té malad épi ou otjipé mwen. Mwen té an pwizon épi ou vin soulajé mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Lè sala sé moun-an ki dwèt-la kay mandéʼy, ‘Mèt, ki lè nou té wèʼw fen épi nou baʼw manjé, ében swèf épi nou baʼw bwè? ");
INSERT INTO acfNT_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Épi ki lè nou té wèʼw sété an étwanjé épi nou antwéʼw lakay nou, ében touni épi nou baʼw had pouʼw mété anlèʼw? ");
INSERT INTO acfNT_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Ki lè nou janmen wèʼw malad ében an pwizon épi nou otjipéʼw?’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Wa-a kay wéponn yo, épi i kay di yo, ‘Mwen ka asiwéʼw, népòt lè ou fè sé bagay sala bay yonn an sé mwens enpòtan anpami sé fwè mwen-an, ou fèʼy ban mwen!’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Lè sala wa-a kay di pou sé moun-an ki asou lanmen gòch li-a, ‘Sòti douvan mwen, modi! Alé an difé-a ki ka bwilé pou tout tan-an, difé-a Bondyé té ja pwépawé bay Denmou épi sé nanj li-a! ");
INSERT INTO acfNT_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Mwen té fen, mé ou pa ban mwen manjé. Mwen té swèf, mé ou pa ban mwen bwè. ");
INSERT INTO acfNT_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Mwen sété an étwanjé, mé ou pa antwé mwen lakay ou. Mwen té touni, mé ou pa ban mwen had. Mwen té malad épi an pwizon, mé ou pa otjipé mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Lè sala yo kay wéponn li, ‘Mèt, ki lè nou té wèʼw fen ében ou swèf ében ou sété an étwanjé ében ou té touni ében ou té malad ében an pwizon, épi nou pa édéʼw?’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Wa-a kay wéponn yo, épi i kay di yo, ‘Mwen ka asiwéʼw, népòt lè ou wifizé fè sé bagay sala bay yonn an sé mwens enpòtan anpami sé moun sala, ou wifizé fèʼy ban mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Épi Bondyé kay voyé yo anba pinisyon pou tout tan, mé sé moun-an ki dwèt-la kay wisivwè lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Lè Jézi té fin enstwi sé moun-an tout sé bagay sala, i di sé disip li-a, ");
INSERT INTO acfNT_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kon ou sav, an dé jou ankò kay Fèt Délivwans-lan épi yo kay pwan Gason Lézòm-lan épi yo kay ladjéʼy an lanmen lézòm pou yo kwisifyéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Lè sala sé chèf pwèt-la épi sé ofisyé Jwif-la té asanblé lakay Kayafas, pli ho chèf pwèt-la, ");
INSERT INTO acfNT_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","épi yo fè plan pou awété Jézi an sigwé pou fè moun tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Yo di, “Sé pa pou nou fèʼy paditan yo ka fété fèt-la, paski sé moun-an pé lévé wévòt.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jézi té an vil Bèfanni adan kay Simon, an nonm ki té ni maladi lapo. ");
INSERT INTO acfNT_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Lè Jézi té ka manjé, an madanm vini épi yon boutèy ki té fèt èk an wòch yo ka kwiyé “alabasta”. Boutèy sala té ni an losyon ki té chè an chay, épi madanm-lan vidé losyon-an asou tèt Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Lè sé disip-la wè sa, yo té faché an chay. Yo di, “Pouki i ka gaspiyé losyon sala? ");
INSERT INTO acfNT_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nou té sa vann losyon-an pou konmen lajan, épi nou té sa bay maléwé lajan-an!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jézi sav sa yo té ka di-a, kon sa i di yo, “Las anbété madanm-lan! Sa sé an bon bagay i fè ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ou kay toujou ni sé maléwé-a anpamiʼw, mé ou pa kay ni mwen tout tan. ");
INSERT INTO acfNT_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Losyon-an i vidé anlè kò mwen-an pwépawé mwen pou lè yo kay téwé mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Épi mwen ka asiwéʼw, népòt koté an latè-a moun pwéché Bon Nouvèl-la konsèné mwen, yo kay di sa madanm-lan fè-a pou moun sa chonjéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Menm jou sala yonn an sé douz disip-la yo ka kwiyé Jida Iskariyòt alé koté sé chèf pwèt-la ");
INSERT INTO acfNT_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","épi i di yo, “Ki sa ou kay ban mwen si mwen ladjé Jézi an lanmen zòt?” Sé chèf pwèt-la konté twant pyès dajan épi yo ba liʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Épi dépi jou sala Jida té ka gadé pou an bon lokazyon pouʼy fè yo awété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Asou pwèmyé jou-a sé Jwif-la té ka manjé pen san lèlven-an, sé disip-la vini koté Jézi épi yo mandéʼy, “Koté ou vlé nou pwépawé Fèt Délivwans-lan pouʼw manjé?” ");
INSERT INTO acfNT_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jézi di yo, “Alé lakay tèl nonm ki ka wèsté an vil-la épi diʼy lè-a ja vini pou mwen mò, épi mwen èk sé disip mwen-an kay manjé Fèt Délivwans-lan lakay li.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Sé disip-la alé épi yo fè menm kon Jézi té di yo épi yo pwépawé manjé-a pou fèsten-an. ");
INSERT INTO acfNT_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Lè òswè pwan, Jézi épi douz disip-la asid pou yo manjé. ");
INSERT INTO acfNT_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Paditan yo té ka manjé, Jézi di yo, “Mwen ka asiwéʼw, yonn an zòt kay twayi mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Sa fè sé disip-la lapenn tèlman, yonn apwé lòt koumansé mandéʼy, “Mèt, ou kwè sé mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jézi wéponn yo, i di, “Menm sa ki fouyé penʼy an bòl sòs-la ansanm épi mwen-an, sé li ki kay twayi mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Gason Lézòm-lan kay mò menm kon lévanjil-la di, mé ki mizi téwib i kay téwib pou moun-an ki twayi Gason Lézòm-lan! I té kay pli mèyè si moun sala pa té janmen fèt!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jida, ki té kay twayiʼy-la, mandéʼy, “Mèt, ou kwè sé mwen?” Jézi wéponn li, i di, “Sé ou menm ki diʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Paditan yo té ka manjé, Jézi pwan pen épi i wimèsyé Bondyé épi i kasé pen-an èk i bay sé disip li-a. I di yo, “Pwanʼy épi manjé. Sa sé kò mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Épi i pwan an pòt diven, i wimèsyé Bondyé épi i ba yo. I di, “Bwè, zòt tout. ");
INSERT INTO acfNT_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Sa sé san mwen ki siyé agwéman-an Bondyé fè épi lézòm-lan. San mwen kay koulé pou an chay moun pou yo jwenn péché yo pawdonnen. ");
INSERT INTO acfNT_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Mwen ka diʼw, mwen pa kay janmen bwè diven épiʼw ankò pou jis tan mwen bwè diven nèf-la épiʼw an wéyòm-lan Papa mwen ka kondwi-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yo chanté an chanté épi yo alé asou Mòn Òliv. ");
INSERT INTO acfNT_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Jézi di yo, “Òswè-a menm zòt tout kay kouwi kité mwen, paski lévanjil-la di, ‘Bondyé kay tjwé gadyenn mouton-an, épi twipo mouton-an kay simen.’ ");
INSERT INTO acfNT_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Mé lè mwen wésisité, mwen kay alé an Galili avanʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pita wéponn Jézi épi i di, “Menm si tout lézòt abandonnenʼw, mwen pa kay janmen kouwi kitéʼw!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Mé Jézi wéponn Pita, i di, “Mwen ka asiwéʼw, òswè-a avan kòk-la chanté, ou kay di twa fwa ou pa konnèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pita wéponn Jézi, i di, “Menm si mwen ni pou mò épiʼw, mwen pa kay janmen di mwen pa konnèt ou.” Épi sé lézòt sé disip-la di menm bagay-la. ");
INSERT INTO acfNT_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Lè sala Jézi épi sé disip li-a alé an koté yo ka kwiyé Gèfsèmanni, épi i di yo, “Asid la paditan mwen ka alé pli douvan ay pwédyé.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","I pwan Pita èk dé gason Zèbèdi-a épiʼy. I té twakasé épi i té ni an gwo lapenn an tjèʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","épi i di yo, “Lapenn-an ki an tjè mwen-an tèlman gwo mwen ka santi i kay tjwé mwen. Wèsté isi-a èk pa dòmi.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Épi i menm alé an ti tak pli douvan épi i jété kòʼy fas atè épi i pwédyé, i di, “Papa mwen, si i posib, tiwé pòt soufwans sala douvan mwen. Mé kanmenm pa fè sa mwen vlé, mé fè sa ou vlé fè pito.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Lè i viwé koté twa disip-la té yé-a, i jwenn yo ka dòmi. I di Pita, “Ou pa sa tjenn mwen konpany pou yon ti mouman? ");
INSERT INTO acfNT_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Pa kité sonmèy pwanʼw, épi pwédyé pouʼw pa tonbé anba tantasyon. Lèspwiʼw vlé fè bagay-la ki bon-an, mé kòʼw pa fò asé pou sa.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jézi viwé alé ay pwédyé yon kou ankò. I di, “Papa mwen, si sé pou mwen bwè pòt soufwans sala avan ou tiwéʼy douvan mwen, mwen kay fè sa ou vlé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","I viwé ankò épi i jwenn sé disip-la ka dòmi. Yo pa té sa tjenn zyé yo ouvè. ");
INSERT INTO acfNT_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Jézi kité yo épi i alé ankò pou twazyenm fwa-a épi i pwédyé menm lapwiyè-a i té pwédyé avan-an. ");
INSERT INTO acfNT_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Lè i viwé koté sé disip-la té yé-a, i di, “Ou ka dòmi toujou? Ou ka pozé kòʼw? Mi, lè-a wivé pou yo ladjé mwen Gason Lézòm-lan an lanmen sé méchan-an.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","I di yo, “Lévé! Annou alé! Mi, nonm-lan ki kay twayi mwen-an ka vini. Annou jwenn li.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jézi pʼòkò té menm fin palé lè Jida, yonn an sé douz disip-la, wivé. I té ni an gwan konpanni moun épiʼy èk yo té ni sab épi boutou. Sété sé chèf pwèt-la épi sé ofisyé Jwif-la ki té voyé yo. ");
INSERT INTO acfNT_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Jida té ja di yo, “Nonm-lan mwen kay bo-a, sé li zòt vlé. Tjenbéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Lè Jida wivé, i alé dwèt koté Jézi épi i diʼy, “Bonswè, Mèt,” épi i boʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jézi di, “Kanmawad, sa ou vin fè-a, fèʼy vitman.” Épi sé moun-an ki té la-a mété lanmen anlè Jézi épi yo awétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Yonn an sé disip-la ki té épi Jézi-a hédi sab li épi i fwapé yonn an sé sèvant pli ho chèf pwèt-la, épi i fè zòwèy li pwan lavòl. ");
INSERT INTO acfNT_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jézi diʼy, “Mété sab-la viwé an plas li, paski tout moun ki sèvi sab-la pou tjwé moun kay mò pa sab-la. ");
INSERT INTO acfNT_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ès ou pa sav mwen sa kwiyé Papa mwen pou édé mwen, épi menm lè-a i kay voyé konmen mil nanj? ");
INSERT INTO acfNT_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Mé si mwen fè sa, sa ki ékwi an lévanjil-la pa kay fèt vwé.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Menm lè-a Jézi palé bay sé moun-an, i di, “Ou ja vini dèyè mwen byen amé akwèdi mwen sé an kwiminèl. Toulé jou mwen té ka enstwi an Kay Bondyé-a épi zòt pyès pa tjenbé mwen. ");
INSERT INTO acfNT_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Mé tout sa fèt pou sa sé pwòfèt-la té ékwi an lévanjil-la vin fèt vwé.” Lè sala tout sé disip-la kitéʼy épi yo kouwi. ");
INSERT INTO acfNT_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Sé moun-an ki té awété Jézi-a mennenʼy lakay Kayafas, pli ho chèf pwèt-la, koté sé titja lwa sé Jwif-la épi sé ofisyé Jwif-la té asanblé ansanm. ");
INSERT INTO acfNT_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mé Pita menm swiv Jézi adan an distans. I antwé jis an lakou pli ho chèf pwèt-la èk i asid épi sé gad-la pouʼy té wè ki sa ki té kay fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Sé chèf pwèt-la épi tout sé manm konsèy-la chaché pou an moun pou sèvi fo témwen kont Jézi pou té fè yo kondannéʼy pou lanmò, ");
INSERT INTO acfNT_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","mé yo pa jwenn pyès, magwé an chay moun alé douvan épi yo manti asouʼy. Alafen, dé nonm doubout ");
INSERT INTO acfNT_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","épi yo di, “Nonm sala di i sa kwazé Kay Bondyé-a épi viwé batiʼy an twa jou.” ");
INSERT INTO acfNT_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Pli ho chèf pwèt-la doubout épi i mandé Jézi, “Ès ou pa ni anyen pouʼw di kont sé akizasyon-an dé nonm-lan fè kont ou-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Mé Jézi pa wéponn li. Pli ho chèf pwèt-la diʼy ankò, “An non Bondyé ki vivan-an, mwen ka konmandéʼw pou di nou lavéwité-a. Ès sé ou ki Mèsaya-a, Gason Bondyé?” ");
INSERT INTO acfNT_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jézi wéponn li, i di, “Sé ou ki diʼy. Dépi jòdi-a ou kay wè mwen Gason Lézòm-lan asid asou lanmen dwèt Bondyé épi mwen kay vini asou nwaj-la!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Lè Jézi diʼy sa, pli ho chèf pwèt-la té faché tèlman, i déchiwé had li. I di, “Nou pa bizwen pyès témwen ankò. Mi, i ja ensilté Bondyé! ");
INSERT INTO acfNT_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ki jijman pou nou ba li?” Yo diʼy, “I koupab épi i ni pou mò!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Yo kwaché an fidjiʼy épi yo bat li épi adan yo ba li souflé ");
INSERT INTO acfNT_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","épi yo diʼy, “Si ou sé Mèsaya-a, di nou kilès ki baʼw souflé sala!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pita té asid dèwò an lakou-a, épi yon sèvant vini èk i di, “Ou té épi Jézi tou, nonm Galili-a!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Mé Pita di douvan yo tout, “Mwen pa konnèt anyen an sa ou ka di-a,” ");
INSERT INTO acfNT_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","épi i kité koté i té yé-a èk i alé an bayè lakou-a. An lòt sèvant wèʼy épi i di, “Nonm sala té épi Jézi nonm Nazawèt-la!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pita wéponn li ankò, i di, “Non, mwen ka sèwmanté mwen pa konnèt nonm sala pyès!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","An ti mouman apwé sa, sé nonm-lan ki té la-a di Pita, “Mé wi ou sé yon disip Jézi! Mannyè ou ka palé-a fè nou sav ou sé yonn adan yo!” ");
INSERT INTO acfNT_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita di, “Mwen ka sèwmanté sa mwen ka di-a sé lavéwité-a! Kité Bondyé pini mwen si sa mwen di-a pa vwé! Mwen pa konnèt nonm sala!” Menm lè-a kòk-la chanté, ");
INSERT INTO acfNT_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","épi Pita chonjé sa Jézi té diʼy-la, “Avan kòk-la chanté, ou kay di twa fwa ou pa konnèt mwen.” Pita pati épi i koumansé pléwé akwèdi tjèʼy té kay waché. ");
INSERT INTO acfNT_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Bonnè bonmaten tout sé chèf pwèt-la épi sé ofisyé Jwif-la mété tèt yo ansanm pou fè moun tjwé Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","épi yo mawé lanmenʼy épi yo mennenʼy bay Pilat, gouvènè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Lè Jida, nonm-lan ki té twayi Jézi-a, wè yo té kondanné Jézi, sa fèʼy lapenn an chay épi i pwan twant pyès dajan-an, i mennenʼy viwé an Kay Bondyé-a bay sé chèf pwèt-la épi sé ofisyé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","I di yo, “Mwen ja péché paski mwen ladjé on nonm inosan an lanmenʼw pouʼw tjwé!” Yo diʼy, “Nou pa mélé épi sa! Sa sé zafèʼw!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Jida jété lajan-an atè an Kay Bondyé-a épi i pati alé pann kòʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Sé chèf pwèt-la anmasé lajan-an épi yo di, “Sa sé lajan ki péyé pou lavi an nonm, kon sa i kont lwa nou pou nou météʼy anpami lajan Kay Bondyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Kon sa yo tout té dakò pou yo achté an tjò tè lanmen an nonm ki té ka fè jè. Yo sèvi tè sala kon an senmityè pou yo téwé moun ki pa Jwif, ");
INSERT INTO acfNT_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","épi sé pou sa yo ka kwiyé senmityè sala, “Savann San-an,” pou jis jòdi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Sa pwòfèt Jérémaya té di-a vin fèt vwé. I té di, “Yo pwan twant pyès dajan-an, paski sété pwi sala sé jan Izwayèl-la té dakò pou péyé pou li, ");
INSERT INTO acfNT_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","épi yo pwan lajan-an, yo achté on tjò tè lanmen nonm-lan ki té ka fè jè-a, menm kon Bondyé té konmandé.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Jézi doubout douvan Gouvènè Pilat, épi Pilat mandéʼy, “Ès ou sé wa sé Jwif-la?” Jézi diʼy, “Sé ou ki diʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Lè sé chèf pwèt-la épi sé ofisyé Jwif-la akizé Jézi, i pa wéponn yo. ");
INSERT INTO acfNT_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilat diʼy, “Ou pa tann tout sé bagay sala yo ka di ou fè-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Mé Jézi pa wéponn li ting, épi sa sipwi gouvènè-a an chay. ");
INSERT INTO acfNT_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Sa sété labitid gouvènè-a toulé Fèt Délivwans pouʼy ladjé népòt an sé pwizonnyé-a sé moun-an té vléʼy ladjé-a, ");
INSERT INTO acfNT_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","épi an tan sala la té ni on pwizonnyé tout moun té konnèt, nonʼy sété Barabas. ");
INSERT INTO acfNT_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Lè tout sé moun-an asanblé douvan Pilat, i mandé yo, “Kilès ou vlé mwen ladjé baʼw jòdi-a, Barabas ében Jézi yo ka kwiyé Mèsaya-a?” ");
INSERT INTO acfNT_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilat mandé yo sa paski i té konnèt byen sé jalouzi ki té fè sé chèf Jwif-la mennen Jézi ba li. ");
INSERT INTO acfNT_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Paditan Pilat té asid an chanm jijman-an, madanm li voyé an konmisyon ba li, i diʼy, “Pa fè nonm inosan sala anyen, paski yè òswè mwen soufè an chay adan an wèv pou lapétiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Sé chèf pwèt-la épi sé ofisyé Jwif-la fè sé moun-an di pou ladjé Barabas épi tjwé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilat mandé sé moun-an ankò, i di, “Kilès ou vlé mwen ladjé baʼw?” Yo tout hélé, “Barabas!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","I mandé yo, “Bon, ki sa mwen kay fè épi Jézi yo ka kwiyé Mèsaya-a?” Yo tout hélé, “Kwisifyéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mé Pilat mandé yo, “Ki mové bagay i ja fè?” Yo hélé èk tout kouway yo, “Kwisifyéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Lè Pilat wè i pa té sa fè anyen ankò paski yo té kay lévé an gwo wévòt, i pwan dlo épi i lavé lanmenʼy douvan tout sé moun-an. I di, “Mwen pa wèskonsab pou lanmò nonm sala! Sa sé zafè zòt!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Tout sé moun-an wéponn, yo di, “Kité modisyon lanmò nonm sala tonbé asou nou épi désandan nou!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Lè yo di sa, Pilat ladjé Barabas kon yo té mandé, épi i bay sé sòlda-a Jézi pou yo bat li épi kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Lè sala sé sòlda-a pwan Jézi épi yo mennenʼy andidan kay gouvènè-a, épi tout sé sòlda-a fè wonʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Yo tiwé had li épi yo mété an lonng gòl wouj anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Yo pwan bwanch pikan, yo fè an kouwonn épi yo météʼy asou tèt li. Yo mété on baton an lanmen dwèt li menm kon on wa, épi yo ajounou douvanʼy épi yo koumansé motjéʼy. Yo diʼy, “Viv wa sé Jwif-la!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yo kwaché anlèʼy épi yo pwan baton-an, yo bat li an tèt. ");
INSERT INTO acfNT_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Lè yo fini motjéʼy, yo tiwé gwo gòl wouj-la épi yo mété had li menm anlèʼy épi yo pwanʼy, yo mennenʼy alé pou yo kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Lè yo té ka alé, yo jwenn an nonm ki sòti Sayrini, nonʼy sété Simon. Sé sòlda-a fòséʼy pou pòté kwa Jézi-a, ");
INSERT INTO acfNT_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","épi yo mouté asou an mòn yo ka kwiyé Gòlgòfa, sa vlé di, “Mòn Kalòt Tèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Lè sala yo ofè Jézi diven ki té ni an wimèd ki anmè pou tjwé mal-la. Lè Jézi goutéʼy, i pa bwèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Apwé yo kwisifyéʼy, sé sòlda-a jwé gwenndé anpami kò yo menm pou yo té sépawé sé had-la i té ni-an. ");
INSERT INTO acfNT_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Épi yo asid la ka véyéʼy ");
INSERT INTO acfNT_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","épi yo ékwi plent-lan yo fè kont li-a anho tèt li asou kwa-a, “Sa Sé Jézi, Wa Sé Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Yo kwisifyé dé kwiminèl menm lè-a épi Jézi, yonn asou koté dwèt li épi lòt-la asou koté gòch li. ");
INSERT INTO acfNT_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Moun ki té ka pasé té ka motjé Jézi épi yo té ka fè sin anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Yo di, “Ou di ou sa kwazé Kay Bondyé-a épi viwé batiʼy an twa jou! Ében, sové kòʼw atjwèlman si ou sé Gason Bondyé, épi désann sòti asou kwa-a!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Sé chèf pwèt-la èk sé titja lwa sé Jwif-la épi sé ofisyé Jwif-la motjéʼy menm mannyè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","Yo di, “I ka sové lézòt moun, mé i pa sa sové kòʼy. I di i sé wa sé jan Izwayèl-la, épi si i désann sòti asou kwa-a, nou kay kwè sé li ki wa-a pou vwé! ");
INSERT INTO acfNT_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","I kwè an Bondyé épi i di i sé Gason Bondyé. Ében, annou gadé si Bondyé kay vini sovéʼy-la apwézan!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Jis dé kwiminèl-la ki té kwisifyé épiʼy-la motjéʼy menm mannyè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Lè i té midi, an gwo nwèsè kouvè tout péyi-a épi i diwé pou twa nèditan. ");
INSERT INTO acfNT_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Lè i té bò twazè apwémidi, Jézi hélé épi an gwo vwa. I di an langaj sé Jwif-la, “Eloi, Eloi, lama sabachthani?” Sa vlé di, “Bondyé mwen, Bondyé mwen, pouki ou ja tounen doʼw anlè mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Adan sé moun-an ki té doubout la-a tann li. Yo di, “Mi, i ka kwiyé Ilaydja!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Yonn adan yo kouwi, i pwan on léponj, i météʼy adan diven wak épi i fouyéʼy an bout an baton épi i lonjéʼy ba li pouʼy gadé si i té kay bwèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Mé sé lézòt-la di, “Èspéyé èk annou gadé si Ilaydja kay vini sovéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jézi hélé épi an gwo vwa ankò épi i mò. ");
INSERT INTO acfNT_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Lè sala gwo wido épé-a ki té an Kay Bondyé-a déchiwé an dé mòso dépi an tèt pou wivé an bout li, tè-a soukwé, épi kayè fann. ");
INSERT INTO acfNT_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Sé twou moun mò-a ouvè, épi an pil moun Bondyé ki té ja mò wésisité. ");
INSERT INTO acfNT_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Yo sòti an twou-a épi apwé Jézi wésisité, yo alé Jérouzalèm, vil-la ki pou Bondyé yonn-an, koté an chay moun wè yo. ");
INSERT INTO acfNT_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Lè chèf sòlda-a épi sé lézòt sòlda-a ki té ka véyé Jézi-a wè twanblanntè-a épi tout sé bagay-la ki té fèt-la, yo té pè an chay. Yo di, “Nonm sala sété Gason Bondyé pou vwé!” ");
INSERT INTO acfNT_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","La té ni an chay madanm ki té ka véyé adan an distans. Yo té swiv Jézi sòti Galili épi yo té édéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","La té ni Mari Madlenn, Mari, manman Jémz épi Jozèf, épi madanm Zèbèdi. ");
INSERT INTO acfNT_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Lè òswè pwan, an nonm wich wivé sòti Arimatéya. Nonʼy sété Jozèf èk i sété an disip Jézi tou. ");
INSERT INTO acfNT_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","I alé koté Pilat, i mandéʼy kò Jézi pouʼy alé téwéʼy. Pilat fè sé moun-an ba liʼy, ");
INSERT INTO acfNT_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","épi Jozèf pwan kò-a èk i vopléʼy adan on dwa blan nèf. ");
INSERT INTO acfNT_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","I téwéʼy an twou-a i té ja fouyé an kayè-a pou kòʼy menm-lan épi i woulé an gwo wòch pou bouché djòl twou-a épi i pati. ");
INSERT INTO acfNT_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Mari Madlenn épi lòt Mari-a té asid la ka gadé twou-a. ");
INSERT INTO acfNT_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","An li denmen, jou sabaf-la, sé chèf pwèt-la épi sé Fawizyen-an alé koté Pilat ");
INSERT INTO acfNT_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","épi yo diʼy, “Mèt, nou chonjé lè mantè sala té vivan toujou, i té di, ‘Mwen kay wésisité anlè twazyenm jou-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Kon sa konmandé sé sòldaʼw-la pou véyé twou-a byen pou sé disip li-a pa vini vòlè kò-a èk pou yo di sé moun-an i wésisité. Mansonj yo-a kay pli mové pasé sa li-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilat di yo, “Pwan déotwa sòlda épi mété yo véyé pou pyès moun pa sa vini bò wòch sala.” ");
INSERT INTO acfNT_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Kon sa, sé nonm-lan alé, yo sélé wòch-la épi yo mété sé sòlda-a véyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Apwé jou sabaf-la, byen bonnè pwèmyé jou an simenn-an, Mari Madlenn épi lòt Mari-a alé ay gadé twou-a. ");
INSERT INTO acfNT_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Menm lè-a té ni an gwo twanblanntè, épi an nanj Bondyé sòti an syèl épi i woulé wòch-la sòti anlè twou-a épi i asid anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","I té ka kléwé menm kon zéklè épi had li té blan kon koton. ");
INSERT INTO acfNT_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Sé sòlda-a té pè tèlman, twanblad pwan yo épi yo tonbé atè-a menm kon moun ki mò. ");
INSERT INTO acfNT_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Nanj-lan palé bay sé madanm-lan. I di yo, “Pa pè! Mwen sav ou ka gadé pou Jézi yo té kwisifyé-a, ");
INSERT INTO acfNT_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","mé i pa isi-a. I wésisité kon i té di. Vini wè koté kò-a té yé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Épi i di yo, “Alé vitman ay di sé disip li-a i wésisité épi i ka alé Galili avan yo. Sé la yo kay wèʼy. Pa obliyé sa mwen diʼw-la.” ");
INSERT INTO acfNT_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Yo kouwi kité twou-a vitman pou alé di sé disip-la. Yo té byen pè mé yo té plen lajwa. ");
INSERT INTO acfNT_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","La menm asou chimen-an, Jézi jwenn yo épi i di yo, “Bonjou.” Yo vini épi yo tjenbé dé pyéʼy épi yo adowéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jézi di yo, “Pa pè, mé alé di sé fwè-a alé Galili, épi yo kay wè mwen la.” ");
INSERT INTO acfNT_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Lè sé madanm-lan pati alé, adan sé sòlda-a ki té ka véyé twou-a viwé an vil-la épi yo ay di sé chèf pwèt-la tout sa ki té fèt. ");
INSERT INTO acfNT_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Sé chèf pwèt-la épi sé ofisyé Jwif-la asanblé ansanm pou fè plan yo. Yo péyé sé sòlda-a an gwo lajan ");
INSERT INTO acfNT_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","épi yo di, “Ou kay ni pou di, an li òswè paditan ou té ka dòmi, sé disip li-a vini vòlè kò-a. ");
INSERT INTO acfNT_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Épi si gouvènè-a vin konnèt sa, nou kay sav ki mannyè pou palé ba li pou nou sa tiwéʼw an twaka sala.” ");
INSERT INTO acfNT_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Kon sa sé sòlda-a pwan lajan-an épi yo fè sa sé chèf pwèt-la té di-a, épi sé Jwif-la simen sa sé sòlda-a té di-a toupatou pou jis jòdi-a. ");
INSERT INTO acfNT_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Sé wonz disip-la pati épi yo mouté asou an ti mòn an Galili koté Jézi té di yo pou alé. ");
INSERT INTO acfNT_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Lè yo wè Jézi, yo adowéʼy, mé adan pa té kwè sété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jézi vini épi i di, “Bondyé ja ban mwen tout pouvwa asou tout sa ki an syèl épi sa ki asou latè-a. ");
INSERT INTO acfNT_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Kon sa alé toupatou épi pwéché bay sé moun-an pou yo sa vini disip mwen, épi batizé yo an non Papa-a, an non Gason-an épi an non Lèspwi Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","épi enstwi yo pou obéyi tout sé bagay-la mwen ja konmandéʼw-la. Épi mwen kay toujou la épiʼw pou jis an bout latè-a.”");
INSERT INTO acfNT_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Sa sé koumansman Bon Nouvèl-la konsèné Jézi Kwi, Gason Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","I koumansé menm mannyè Bondyé té di i kay fèt an liv pwòfèt Izaya. I di: “Gadé, mwen Bondyé kay voyé on konmisyonnè avanʼw, Gason mwen, épi i kay pwépawé chimen-an baʼw. ");
INSERT INTO acfNT_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Sé moun-an kay tann vwa an moun byen lwen ka andjélé, ‘Pwépawé chimen-an bay Senyè-a, fè twas ki dwèt pou i sa pasé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kon ki di, kon ki fèt. Jan Batis pawèt adan savann-an ka batizé moun épi i ka pwéché konmisyon Bondyé ki di sé moun-an pou tounen hòd péché yo épi batizé, épi Bondyé kay pawdonnen péché yo. ");
INSERT INTO acfNT_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Épi la moun sòti toupatou an hòtè Joudiya èk an vil Jérouzalèm épi yo alé koté Jan té ka batizé-a. Èk apwé yo konfésé péché yo, Jan batizé yo an Lawivyè Jouden. ");
INSERT INTO acfNT_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Jan té ka mété had ki fèt épi pwèl kanmèl épi i té ni an sanng tjwi oliwon wenʼy, épi pou manjéʼy i té ka manjé an ti bèt kon an kwitjèt èk siwo myèl. ");
INSERT INTO acfNT_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Épi kon i pwéché bay sé moun-an i di yo kon sa, “I ni yonn ki ka vini apwé mwen ki ni pli pouvwa pasé mwen, lasé soulyéʼy menm, mwen pa menm bon asé pou sa bésé épi démawéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Mwen sèvi dlo pou batizé zòt, mé i menm kay batizé zòt épi Lèspwi Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Pa lontan apwé sa Jézi sòti an vil Nazawèt an Galili épi Jan batizéʼy an Lawivyè Jouden. ");
INSERT INTO acfNT_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Épi kon Jézi té ka sòti an dlo-a, la menm i wè syèl-la déchiwé ouvè épi Lèspwi Bondyé désann asouʼy kon an toutwèl. ");
INSERT INTO acfNT_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Épi yo tann an vwa sòti an syèl èk i di, “Ou sé Gason mwen, mwen kontanʼw an chay. Mwen byen plè épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","La menm Lèspwi Bondyé kondwiʼy alé adan an plas koté pyès moun pa ka wèsté. ");
INSERT INTO acfNT_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Épi Jézi wèsté la pou kawant jou, épi Satan tantéʼy. Jézi té la épi sé zannimo mawon-an, épi nanj Bondyé wann li sèvis. ");
INSERT INTO acfNT_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Yo té mété Jan Batis an pwizon, épi apwé sa Jézi alé toupatou an Galili ka pwéché Bon Nouvèl-la Bondyé té ba li pou pwéché-a. ");
INSERT INTO acfNT_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","I té ka di, “Tan-an ja wivé, kondwit Bondyé ka vini touswit. Tounen hòd péché zòt épi kwè Bon Nouvèl-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Kon Jézi té ka maché bò Lanmè Galili-a, i wè Simon épi fwèʼy Androu ka voyé lèpèvyé yo an lanmè-a, paski yo té péchè. ");
INSERT INTO acfNT_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jézi di yo kon sa, “Vini, swiv mwen, épi mwen kay fèʼw péché lézòm.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Épi la menm yo kité sé lèpèvyé-a èk yo swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Lè Jézi té alé an ti distans, i wè Jémz gason Zèbèdi épi fwèʼy Jan adan an kannòt, épi yo té ka pwépawé senn yo. ");
INSERT INTO acfNT_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Kon sa Jézi kwiyé yo pou swiv li, yo kité papa yo Zèbèdi épi sé twavayè-a adan kannòt-la épi yo swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Jézi épi pwèmyé sé disip-la wivé an vil Kapènéyòm, épi asou jou sabaf sé Jwif-la i antwé an légliz yo épi i koumansé enstwi sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Sé moun-an té tèlman sipwi lè yo tann mannyè i enstwi-a, yo wèsté épi bouch gwan ouvè paski i té ka enstwi épi lotowité èk pa kon sé titja lwa sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","La menm an nonm ki té ni an vyé lèspwi andidanʼy pawèt an légliz-la épi i fè yon kwi. ");
INSERT INTO acfNT_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","I di, “Awa! Ki sa ou ka fè épi nou, Jézi ki sòti an vil Nazawèt? Ès si ou la pou détwi nou? Mwen sav byen ki moun ou yé: Ou sé konmisyonnè-a Bondyé voyé-a pou vwé.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jézi konmandé vyé lèspwi-a pou pé la fap! épi sòti an nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Vyé lèspwi-a soukwé nonm-lan menm kon an moun ki ni an malkadi, épi i fè yon kwi èk i sòti an nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Sé moun-an ki té la-a té tèlman sipwi, kon sa yo koumansé ka di bay yonn a lòt, “É é, é é, mésyé, ki sa sa yé? Sa sé an bagay nèf oki? Nonm sala ni pouvwa tèlman, i konmandé vyé lèspwi épi yo koutéʼy?” ");
INSERT INTO acfNT_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Épi sé kon sa nouvèl konsèné Jézi simen vitman toupatou an tout plas-la ki an Galili. ");
INSERT INTO acfNT_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jézi, Jémz èk Jan èk sé lézòt disip-la, kon yo té kité légliz sé Jwif-la, yo alé lakay Simon èk Androu. ");
INSERT INTO acfNT_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bèlmè Simon té kouché épi on lafyèv, épi yo di Jézi kondisyonʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Jézi alé bòʼy épi i tjenbéʼy pa lanmenʼy épi i édéʼy doubout. La menm lafyèv-la kité madanm-lan épi i ba yo on bagay pou yo manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Menm swè sala, apwé sòlèy kouché, yo mennen bay Jézi tout sa ki té malad épi sa ki té ni vyé lèspwi. ");
INSERT INTO acfNT_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Pwèskè tout moun an vil-la té asanblé douvan lapòt kay-la. ");
INSERT INTO acfNT_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Épi Jézi djéwi an chay ki té ni diféwan maladi. I tiwé vyé lèspwi osi mé i pa kité sé vyé lèspwi-a palé paski yo té sav ki moun Jézi yé. ");
INSERT INTO acfNT_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Byen bonnè bonmaten, avan laba kasé, Jézi lévé épi i kité kay-la épi alé an koté pa kòʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Mé lè Simon épi sé lézòt-la lévé èk yo pa wèʼy, yo alé ay chachéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Lè yo jwenn épiʼy, yo di, “Tout moun ka chachéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Jézi wéponn yo, “Annou alé an sé lézòt vil-la ki pwé isi-a pou mwen sa pwéché la osi, paski sa sé wézon-an mwen vini asou latè.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Épi i alé toupatou an Galili èk pwéché an sé légliz sé Jwif-la épi i tiwé vyé lèspwi an sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","An nonm ki té ni an vyé maladi an lapoʼy vini douvan Jézi épi i tonbé asou jounouʼy épi i di, “Jézi, souplé, mwen sav ou sa djéwi mwen, mé sé si ou dakò.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Mé nonm-lan fè Jézi tèlman lapenn, Jézi lonjé lanmenʼy épi touchéʼy épi i di, “Mwen dakò. Ou djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Épi kon Jézi di sa, maladi-a kitéʼy épi i djéwi menm lè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","La menm Jézi voyé nonm-lan alé, épi i vètiʼy épi i diʼy kon sa, ");
INSERT INTO acfNT_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Mwen pa vlé ou di pyès moun bagay sala. Mé alé épi moutwé pwèt-la mannyè ou ja jwenn djéwizon, épi apwé ou fè sa ofè sé sakwifis-la menm kon Moziz té konmandé zòt pou fè-a lè on moun jwenn djéwizon, kon an témwen ba yo.” ");
INSERT INTO acfNT_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Mé pito i fè sa Jézi diʼy pou fè-a, nonm-lan alé toupatou ka di tout moun sa Jézi fè ba li-a. Épi pou lapéti sa i fè-a, Jézi pa té sa antwé adan pyès sé vil oliwon-an kon i té vlé, mé pito sa i wèsté an koté pa kòʼy adan hòtè, koté ki pa té ni pyès moun ka wèsté. Mé magwé Jézi fè tout sa, sé moun-an sòti toupatou an sé vil-la épi yo jwenn épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Déotwa jou apwé sa Jézi viwé Kapènéyòm, épi sé moun-an vini tann i té lakay li. ");
INSERT INTO acfNT_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","La té ni tèlman moun ki té asanblé, la pa té sa pwan moun ankò, pa menm douvan lapòt-la, épi Jézi koumansé pwéché Bon Nouvèl Bondyé-a ba yo. ");
INSERT INTO acfNT_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Déotwa moun vini épi yo mennen an nonm bay Jézi ki té enfim an tout kòʼy. Kat nonm té ni pou pòtéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Yo pa té sa vini pwé Jézi paski pil sé moun-an ki té la-a té tèlman gwan, kon sa yo tiwé an tjò an tèt kay-la dwèt anho koté Jézi té yé-a, épi lè twou-a té asé gwan yo filé désann adan an hanmak nonm-lan ki té enfim-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Lè Jézi wè mizi kwè yo kwè an li, i di nonm-lan ki té enfim-lan, “Gason mwen, péchéʼw pawdonnen.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Bon, la té ni déotwa titja lwa sé Jwif-la ki té asid la épi yo katjilé an tjè yo, ");
INSERT INTO acfNT_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Boug sala ka ensilté Bondyé, paski sé Bondyé sèlman ki sa pawdonnen péché.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","La menm Jézi vini sav ki sa yo té ka katjilé an tjè yo-a épi i di yo, “Pouki pou zòt katjilé sé bagay sala? ");
INSERT INTO acfNT_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Kilès ki pli ézé? Pou di nonm enfim-lan, ‘Péchéʼw ja pawdonnen’ ében pou diʼy, ‘Lévé, pwan hanmak ou épi maché’? ");
INSERT INTO acfNT_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Mé pou moutwé zòt mwen Gason Lézòm ni pouvwa asou latè pou pawdonnen péché...” Kon sa i di nonm enfim-lan, ");
INSERT INTO acfNT_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Mwen diʼw, lévé, pwan hanmak ou èk alé lakay ou.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Patan tout moun ka gadé, nonm-lan lévé èk anmasé hanmak li, épi i alé vitman douvan tout sé moun-an. Tout sé moun-an wèsté épi bouch gwan ouvè épi yo glowifyé Bondyé épi yo tout di, “Pwèmyé fwa nou janmen wè an bagay kon sa fèt.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Jézi viwé ankò bò Lanmè Galili. Tout sé moun-an vini koté i té yé-a épi i enstwi yo an pawòl Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Padan i té ka maché-a, i wè an nonm ki té ka anmasé lajan ladwenn bay gouvèdman-an, nonʼy té Livay, gason Alfiyòs, épi i té asid douvan biwoʼy. Jézi diʼy kon sa, “Swiv mwen.” Livay lévé, épi i kité twavay li épi i swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Pli ta Jézi té lakay menm Livay sala adan an gwan dinen. An gwo limowo an sé nonm-lan ki ka anmasé taks-la épi lézòt ki té ni mové wépitasyon té ka swiv Jézi épi an chay an yo té ka manjé a tab épiʼy èk sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Adan sé titja lwa sé Jwif-la, sé sa ki anpami sé Fawizyen-an, wè Jézi ka manjé épi sé nonm-lan ki ka anmasé taks-la épi sé moun-an ki té ni mové wépitasyon-an, kon sa yo di sé disip li-a, “Ki mannyè Jézi ka manjé épi kalité sé moun sala?” ");
INSERT INTO acfNT_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jézi tann yo épi i wéponn, “Moun ki an bon santé pa ni pyès wézon pou alé oti dòktè, mé sé sa ki malad sèlman. Mwen pa vini toubonnman pou kwiyé sé sa ki kwè yo ka viv dwèt-la, mé sé sa ki sav yo sé péchè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","I té ni an lokazyon lè sé disip Jan Batis-la épi sé Fawizyen-an té ka pwédyé épi wèsté san manjé lè yo té ka adowé Bondyé. An konpanni moun vini épi yo mandé Jézi, “Ki mannyè sé disip ou-a pa ka wèsté san manjé lè yo ka adowé Bondyé menm kon sé disip Jan Batis-la épi sé disip sé Fawizyen-an ka fè?” ");
INSERT INTO acfNT_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jézi wéponn, “Ès si ou kwè moun ki envité adan an fèt mawiyaj pa kay manjé? Mé non! Tout tan nonm-lan ki ka mayé-a la èk yo toujou, yo pa kay wèsté san manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Mé an lè yo kay pwan nonm-lan ki ka mayé-a anpami yo, èk lè jou sala wivé, wè, yo pa kay manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Pyès moun pa ka sèvi an tjò twèl nèf pou pyèsté an vyé had. Si i fè sa, tjò nèf-la i mété-a kay déchiwé vyé had-la épi i kay fè an pli gwan twou. ");
INSERT INTO acfNT_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ében ès si ou kwè an moun kay mété diven nèf adan vyé boutèy? Mé non! Paski si i fè sa, diven nèf-la kay pété sé vyé boutèy-la épi i kay pèd ni diven ni boutèy. Diven nèf ka alé an boutèy nèf.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Jézi épi sé disip li-a té ka maché adan yon jaden asou an jou sabaf, épi kon sé disip-la té ka pasé, yo koumansé tjouwi an konmès gwenn an jaden-an pou yo manjéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Sé Fawizyen-an di Jézi, “Gadé, i kont lwa nou pou sé disip ou-a fè sa asou jou sabaf-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Jézi wéponn, “Ou vlé di mwen zòt pa janmen li sa David fè tan-an lè i té bizwen an bagay pou i té sa manjé-a? Li épi sé moun-an ki té épiʼy-la té fen, ");
INSERT INTO acfNT_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","kon sa i antwé adan Kay Bondyé épi i manjé pen-an yo té ofè bay Bondyé-a. Sa té fèt lè Abiyafa té pli ho chèf an sé pwèt-la. Lwa-a di kon sa, sé pwèt-la sèlman ki sa manjé pen sala mé David manjéʼy épi i jis bay sé moun-an ki té épiʼy-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Épi Jézi di yo, “Jou sabaf-la té fèt pou nonm — pa nonm ki té fèt pou jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Okontwè mwen Gason Lézòm sé mèt asou jou sabaf-la osi.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Apwé an tan, Jézi viwé an légliz sé Jwif-la épi la té ni an nonm ki té ni an lanmen enfim. ");
INSERT INTO acfNT_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Adan sé moun-an ki té la-a té vlé akizé Jézi konmkwé i té ka fè bagay ki pa dwèt. Kon sa yo véyéʼy byen pou wè si i té kay djéwi nonm-lan asou jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jézi di nonm-lan ki té ni lanmen enfim-lan, “Doubout épi vini douvan-an.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","La Jézi mandé sé moun-an, “Ki sa ki bon pou fè asou jou sabaf-la? Pou fè byen ében pou fè mal, pou sové lavi ében pou tjwé?” Mé sé moun-an pa di an mo pawòl. ");
INSERT INTO acfNT_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Jézi té ka bouwi andidanʼy kon i tounen oliwon ka gadé yo, mé a menm di tan-an, yo té ka fèʼy lapenn, paski tjè yo té tèlman wèd. Jézi di nonm-lan, “Lonjé lanmenʼw.” Nonm enfim-lan lonjé lanmenʼy, épi la menm lanmen-an djéwi nèt. ");
INSERT INTO acfNT_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Kon sa kon sé Fawizyen-an kité légliz-la, yo alé konsilté épi adan sé patizan Wa Hèròd-la, épi yo fè plan pou pwan lavi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jézi épi sé disip li-a halé kò yo hòd sé moun-an épi yo alé bò Lanmè Galili, épi an chay moun swiv yo. Sé moun-an sòti an Galili, la té ni jan Joudiya, ");
INSERT INTO acfNT_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","jan Jérouzalèm, moun ki sòti an pawès Idouméya, lòt fasad Jouden épi an tout sé vil-la ki oliwon Taya èk Sidon. Tout sé moun sala vini oti Jézi paski yo té tann tout sé bagay-la i té ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Latilyé sé moun-an ki té ka swiv li-a té tèlman gwan, kon sa avan yo vini twò pwé èk yo pijéʼy, Jézi di sé disip li-a pou pwépawé an kannòt ba li. ");
INSERT INTO acfNT_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","I té ja djéwi an chay moun, épi tout sa ki malad té ka fè fòs kò yo pou yo wivé ko i té yé-a pou yo té sa touchéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Épi pyès lè sé moun-an ki té ni vyé lèspwi andidan yo-a wè Jézi, yo ka tonbé douvanʼy épi sé vyé lèspwi-a ka fè kwi èk yo ka di, “Ou sé Gason Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Jézi konmandé sé vyé lèspwi-a pou pa di ki moun i té yé. ");
INSERT INTO acfNT_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Apwé sa Jézi mouté an sé mòn-an épi i kwiyé sé nonm-lan i té vlé-a pou swiv li. Yo vini, ");
INSERT INTO acfNT_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","épi i chwazi douz anpami yo, épi i kwiyé yo ‘zapòt’. I di yo kon sa, “Mwen ja chwazi zòt pou zòt sa épi mwen épi pou mwen sa voyé zòt pwéché osi, ");
INSERT INTO acfNT_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","épi zòt kay ni pouvwa pou tiwé vyé lèspwi.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Sa sé non sé zapòt-la i chwazi-a: Simon (Jézi té kwiyéʼy ‘Pita’ kon an ti soudnon,) ");
INSERT INTO acfNT_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Jémz èk fwèʼy Jan, sé gason Zèbèdi-a (soudnon Jézi té ba yo té Bowanèdjès, sa sé ‘nonm loway’), ");
INSERT INTO acfNT_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Androu, Filip, Batolonmi, Mafyou, Tonmas, Jémz gason Alfiyòs, Tadiyòs, Simon (an manm an patizan Zèlòt-la), ");
INSERT INTO acfNT_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","épi Jida Iskariyòt, nonm-lan ki twayi Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Apwé, Jézi viwé koté i té ka wèsté-a. Ankò la té ni yon latilyé moun ki té asanblé la, kon sa Jézi épi sé disip-la pa té ni tan pou yo sa manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Lè fanmiʼy vini tann sa, yo vini pwanʼy paski moun té ka di, “Sé pèd i ja pèd tèt li.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Adan sé titja lwa sé Jwif-la ki té sòti Jérouzalèm-lan té ka di, “I ni Bèlzibòb an li.” Lézòt di, “Sé chèf denmou-an ki ba li pouvwa sala pou i sa tiwé vyé lèspwi an moun.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Épi Jézi di sé moun-an vini, épi i palé ba yo an pawabòl. I di kon sa, “Ki mannyè Satan sa kouwi dèyè Satan? ");
INSERT INTO acfNT_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Si sé moun-an ki adan an péyi ka toujou goumen anpami yo menm, péyi sala pa sa fò. ");
INSERT INTO acfNT_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Si an fanmi ka toujou goumen épi yonn a lòt, yo pa kay kontiné kon an fanmi. ");
INSERT INTO acfNT_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Épi si Satan ka goumen kont li menm épi pouvwaʼy sépawé, wéyòm li pa sa diwé èk finismanʼy ja wivé. ");
INSERT INTO acfNT_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Okontwè, pyèsonn pa sa antwé adan kay an nonm ki ni kouway épi vòlè bagay li tout tan i pa mawé nonm-lan ki ni kouway-la, épi lè sala i sa vòlè bagay li. ");
INSERT INTO acfNT_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Mwen ka diʼw lavéwité, Bondyé sa pawdonnen nonm pou tout péché yo ja fè épi tout mové bagay yo pé di. ");
INSERT INTO acfNT_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Mé Bondyé pa kay janmen pawdonnen moun-an ki ensilté Lèspwi Bondyé paski i ja fè an péché ki kay wèsté épiʼy tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","(Jézi di sa paski adan yo té ka di i ni an vyé lèspwi andidanʼy.) ");
INSERT INTO acfNT_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Manman Jézi épi sé fwèʼy-la wivé. Yo doubout dèwò-a épi yo voyé an moun pou kwiyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","An latilyé moun té asid oliwon Jézi épi yo di, “Mi manmanʼw épi fwèʼw dèwò-a la ka gadé pouʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","I wéponn yo, “Ki moun ki manman mwen épi fwè mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Kon sa i gadé sé sa ki té asid an sèk-la oliwonʼy-lan épi i di, “Mi manman mwen épi fwè mwen! ");
INSERT INTO acfNT_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Pyès moun ki fè sa Bondyé di yo pou fè-a sé fwè mwen épi sésé mwen épi manman mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Asou an lòt lokazyon Jézi té ka enstwi bò lanmè-a. Konpanni moun-an ki té asanblé oliwonʼy-lan té tèlman gwan, kon sa i antwé adan an kannòt asou lanmè-a épi i asid patan tout sé moun-an té asou lans-lan byen pwé lanmè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","I enstwi sé moun-an an chay bagay an pawabòl, épi patan i ka enstwi yo-a, i di, ");
INSERT INTO acfNT_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Kouté, la té ni an nonm ki alé an jaden pou i planté. ");
INSERT INTO acfNT_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Kon i té ka simen sé gwenn plan-an, adan tonbé asou twas-la koté moun ka pasé, épi sé jibyé-a vini épi yo manjé yo. ");
INSERT INTO acfNT_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Adan tonbé asou an plas ki té ni tizing tè mé anbaʼy té benyen kayè. Sé gwenn-an lévé vit paski tè-a pa té djè fwèt, ");
INSERT INTO acfNT_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","mé lè sòlèy-la vini cho, i bwilé sé ti plan-an épi yo mò paski wasin yo pa té asé fon. ");
INSERT INTO acfNT_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Lézòt gwenn tonbé koté ki té ni wasin pyé pikan, épi kon sé pyé pikan-an lévé yo anpéché sé plan-an pwofité, épi pou lapéti sa yo pa té sa pòté. ");
INSERT INTO acfNT_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Mé adan tonbé asou bon tè, épi yo lévé épi yo pòté byen. Adan pyé pòté twant gwenn, lézòt pòté swasant gwenn, épi i ni pyé ki jis pòté yon san.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Épi Jézi di, “Tout sa ki ni zòwèy pou yo tann sipozé kouté.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Apwé sé moun-an alé, sé douz zapòt-la épi sé lézòt sé moun-an ki té oliwonʼy-lan mandéʼy konsèné pawabòl-la. ");
INSERT INTO acfNT_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","I di yo, “Zòt ja wisivwè sigwé-a konsèné mannyè-a Bondyé ka kondwi-a. Mé sé moun-an ki pa entéwésé pou konnèt Bondyé-a kay tann tout bagay an pawabòl, ");
INSERT INTO acfNT_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kon sa yo pé ka toujou wè mé sa yo wè-a pa janmen afèkté tjè yo, épi yo pé ka toujou tann mé yo pa janmen konpwann, avan yo tounen jwenn Bondyé épi Bondyé pawdonnen péché yo.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Épi Jézi di yo, “Ou vlé di zòt pa konpwann pawabòl sala? Ki mannyè zòt kay konpwann pyès pawabòl? ");
INSERT INTO acfNT_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Menm mannyè nonm-lan té ka simen sé gwenn-an, sé kon sa Bon Nouvèl-la ka simen. ");
INSERT INTO acfNT_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Adan moun, yo menm kon sé gwenn-an ki tonbé asou twas-la lè Bon Nouvèl-la té simen an tjè yo. Kon yo tann Bon Nouvèl-la, Satan vini épi i tiwé Bon Nouvèl-la ki té planté an tjè yo-a. ");
INSERT INTO acfNT_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","I ni adan moun, yo menm kon sé gwenn-an ki té tonbé asou plas-la ki ni tizing tè-a mé anbaʼy benyen kayè-a. Yo tann Bon Nouvèl-la, épi la menm yo wisivwèʼy épi djèwté. ");
INSERT INTO acfNT_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Mé kon yo pa té ni wasin an tjè yo, yo pa diwé lontan. Lè twakasman ében pèsikasyon koumansé pou lapéti Bon Nouvèl-la, yo pa té sa kontiné. ");
INSERT INTO acfNT_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","I ni moun, yo menm kon sé gwenn-an ki té tonbé anpami wasin pyé pikan-an, yo tann Bon Nouvèl-la ");
INSERT INTO acfNT_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","mé yo katjilé an chay asou tan-an yo ka viv-la, mannyè yo té vlé ni wichès, épi tout lòt kalité bagay antwé épi toufé Bon Nouvèl-la, épi pou lapéti sa, yo pa té sa pwodwi fwi. ");
INSERT INTO acfNT_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Mé i ni lòt moun ki menm kon sé gwenn-an ki tonbé asou bon tè-a. Yo tann Bon Nouvèl-la, yo aksèptéʼy épi yo pwodwi fwi, adan twant, adan swasant épi adan yon san.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Jézi di yo, “Ou pa kay limen an lanp pou météʼy anba an bonm ében anba an kouch, kouman. Pa asou an tab ou ka météʼy, an? ");
INSERT INTO acfNT_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kon sa népòt bagay ki ja séwé kay vini an klèté, épi anyen ki kouvè kay dékouvè. ");
INSERT INTO acfNT_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Si an moun ni zòwèy pou i kouté, i sipozé kouté.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Épi i di ankò, “Pwan bon pokosyon sa ou tann! Paski pli ou ka mété lésisyon Bondyé andidan tjèʼw épi an laviʼw-la, pli Bondyé kay baʼw konpwann, épi i kay baʼw jik pli pasé sa. ");
INSERT INTO acfNT_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Bondyé kay bay nonm-lan ki ja ni-an pli, mé nonm-lan ki pa ni anyen-an, jik tizing-lan i ni-an Bondyé kay pwanʼy lanmenʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jézi kontiné épi i di, “Mi sé kon sa kondwit Bondyé kay yé. I sé menm kon an nonm ki té ka simen an konmès gwenn asou tjò té i té ja pwépawé. ");
INSERT INTO acfNT_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Épi menm si nonm-lan ka dòmi lannwit épi asou pyéʼy lajouné, sé gwenn-an ka lévé èk pwofité épi nonm-lan pa sa èspliké ki mannyè sa ka fèt. ");
INSERT INTO acfNT_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Tè-a pa kòʼy sèlman ki fè plan-an lévé épi pwodwi: Pwèmyéman pyé-a lévé, apwé sa i fléwi épi apwé sa tout gwenn-an ka sòti. ");
INSERT INTO acfNT_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Lè sé gwenn-an vini mi, nonm-lan ka koumansé tjouwiʼy paski tan wékòt-la ja wivé.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jézi mandé, “Ki sa nou kay di gouvèdman-an Bondyé kay kondwi-a ka sanm? Ében ki pawabòl nou kay sèvi pou èsplikéʼy? ");
INSERT INTO acfNT_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","I menm kon an gwenn moutad, ki sé pli piti gwenn an moun sa planté an tè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Mé lè ou plantéʼy i ka lévé épi pwofité plis pasé tout lézòt pyé lédjim, épi bwanch li ka vini tèlman gwo kon sa jibyé sa vini épi jis fè nich yo adanʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Épi kon Jézi pwéché konmisyonʼy-lan bay sé moun-an, i sèvi an chay lézòt pawabòl kon sé sala. Épi i di yo menm kantité yo té sa konpwann. ");
INSERT INTO acfNT_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","I pa di sé moun-an anyen anba i sèvi an pawabòl, mé lè Jézi épi sé disip-la té pa kò yo, i èspliké tout bagay ba yo. ");
INSERT INTO acfNT_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Menm jou sala lè sòlèy kouché, Jézi di sé disip li-a, “Annou alé asou tè-a ki lòt fasad lanmè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Kon sa yo kité latilyé sé moun-an dèyè yo épi sé disip-la pwan Jézi, ki té ja adan kannòt-la, épi yo mennenʼy alé èk yo. La té ni lòt kannòt ki swiv yo osi. ");
INSERT INTO acfNT_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","An mové van lévé épi sé lanm-lan koumansé pété andidan kannòt-la, épi kannòt-la té ka koumansé plen dlo. ");
INSERT INTO acfNT_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Jézi té andidan kannòt-la ka dòmi, tèt li asou an tòch. Sé disip-la lévéʼy épi yo di, “Mèt, nou ja pwèskè péwi épi ou pa menm mélé?” ");
INSERT INTO acfNT_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jézi lévé épi i di van-an, “Mwen ka konmandéʼw, tonbé nèt!” épi i di sé lanm-lan, “Doubout lévé!” La menm van-an tonbé nèt épi la pa té ni pa yon lanm ankò. ");
INSERT INTO acfNT_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Jézi di sé disip li-a, “Pouki zòt pè otan? Ou vlé di mwen zòt pʼòkò ni lafwa toujou?” ");
INSERT INTO acfNT_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yo té ka twanblé kon an fèy épi yo di bay yonn a lòt, “Mésyé, sa ki nonm sala? Jik van-an épi sé lanm-lan ka koutéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yo wivé asou lòt fasad Lanmè Galili, adan péyi Gèrazin. ");
INSERT INTO acfNT_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Kon Jézi débatjé kannòt-la, i jwenn épi an nonm ki sòti an senmityè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nonm sala té ni vyé lèspwi andidanʼy épi i té ka wèsté an senmityè-a. Pyèsonn pa té sa tjenn li mawé épi chenn ankò. ");
INSERT INTO acfNT_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","An chay lè pyéʼy épi lanmenʼy té ka mawé, mé tout lè i té ka kasé sé chenn-an épi i té ka kwazé sé fè-a ki té mawé asou dé pyéʼy-la. I té ni twòp kouway pou pyèsonn té sa doubout li. ");
INSERT INTO acfNT_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Tout lè, lannwit kon lajouné, an senmityè-a épi an sé mòn-an, i té ka fè yon kalité kwi épi i té ka koupé tout kòʼy épi wòch. ");
INSERT INTO acfNT_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Épi i té an ti distans lè i wè Jézi. Kon sa i kouwi épi i tonbé asou jounouʼy douvan Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","épi i fè an gwo kwi épi i di, “Jézi Gason Bondyé ki an syèl, ki sa ou ka fè épi mwen? Mwen ka mandéʼw an pwézans Bondyé, souplé, pa fè mwen soufè.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","(Ou wè i di sa paski Jézi té ka konmandé sé vyé lèspwi-a pou sòti an nonm-lan.) ");
INSERT INTO acfNT_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Kon sa Jézi mandéʼy, “Koumonnonʼw?” Nonm-lan wéponn, “Non mwen sé ‘Konpanni’, paski la ni nou tèlman.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Épi vyé lèspwi-a kontiné ka di Jézi, “Souplé, pa voyé nou dèwò plas sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","La té ni an gwo limowo kochon byen pwé asou an mòn épi yo té ka manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Sé vyé lèspwi-a di Jézi, “Souplé voyé nou anpami sé kochon-an épi kité nou antwé andidan yo.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kon sa Jézi kité yo fè sa yo té mandé-a. Sé vyé lèspwi-a sòti an nonm-lan épi yo antwé an sé kochon-an. Limowo-a té bò dé mil kochon an tout. Épi kon yo galopé désann kaskou-a, yo tonbé an lanmè-a épi yo néyé. ");
INSERT INTO acfNT_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Sé moun-an ki té ka gadé apwé sé kochon-an mété kouwi épi yo bay nouvèl sala an tout sé vil-la épi an hòtè, èk sé moun-an ki ka wèsté an sé plas sala alé wè ki sa ki té fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Lè yo wivé ko Jézi té yé-a, yo wè nonm-lan ki té ni konpanni vyé lèspwi-a andidanʼy-lan. Nonm-lan té asid, i té abiyé épi i té ja konpwann kòʼy. Épi tout sé moun-an ki wèʼy-la té byen pè. ");
INSERT INTO acfNT_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Sé moun-an ki té wè sa ki fèt-la di sé lézòt-la sa ki wivé nonm-lan ki té ni sé vyé lèspwi-a, épi sé kochon-an. ");
INSERT INTO acfNT_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Apwé sé moun-an tann sa ki té fèt-la, yo mandé Jézi pou kité péyi yo èk alé. ");
INSERT INTO acfNT_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Kon Jézi té ka batjé adan kannòt-la, nonm-lan ki té ni vyé lèspwi-a di Jézi, “Souplé kité mwen alé épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Mé Jézi wifizéʼy, épi pito sa Jézi di, “Alé lakay ou, ay wè fanmiʼw épi di yo kantité bagay Bondyé Senyè-a ja fè baʼw, épi ki mannyè i pa kitéʼw kontiné soufè mé i té ni konpasyon asouʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Kon sa nonm-lan kité épi i alé an tout sé plas-la yo ka kwiyé ‘Dis Vil-la’, épi i té ka di sé moun-an ki sa Jézi té ja fè ba li. Épi tout sa ki tann li té ni tèlman kontantman an tjè yo pou sav sé bagay sala té sa fèt. ");
INSERT INTO acfNT_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Jézi viwé ankò lòt fasad lanmè-a. Épi bò lanmè-a la té ni an chay moun ki té asanblé oliwonʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","La té ni on nonm nonʼy sété Jayròs ki sété an ofisyé adan légliz sé Jwif-la ki té an plas sala. Jayròs vini, épi lè i wè Jézi i tonbé douvanʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","I plédé bay Jézi épi i di, “Ti fi mwen-an byen malad. Souplé vini épi pasé lanmenʼw asouʼy pou i sa vini byen épi viv.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Kon sa Jézi pati épiʼy. I té ni tèlman moun ki té ka alé épiʼy kon sa yo té pwèskè kouvèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","La té ni an madanm ki té ja soufè an chay. Pou douz an i té ka pèd an chay san, ");
INSERT INTO acfNT_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","magwé i té ja alé oti an chay dòktè. I té ja dépansé an chay lajan mé pito i vini pli mèyè, kondisyonʼy té ka vini pli mové. ");
INSERT INTO acfNT_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","I té ja tann nouvèl konsèné Jézi, kon sa i vini anpami sé moun-an pa dèyè do Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","I di bay kòʼy, “Si mwen touché had li sèlman, mwen kay djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Kon sa i touché had Jézi épi la menm san-an doubout koulé, épi i santi an kòʼy menm kon sa i té délivwé anba tout soufwans li. ");
INSERT INTO acfNT_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","La menm Jézi té sav pouvwa té sòti an li. Épi i tounen oliwon anpami sé moun-an épi i di, “Ki moun ki touché had mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Sé disip-la wéponn, “É é, mannyè sé moun-an ka konbléʼw-la, ki mannyè ou ka mandé ki moun ti touchéʼw-la?” ");
INSERT INTO acfNT_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mé Jézi kontiné ka gadé oliwon pou i wè kilès moun ki té fè sa-a. ");
INSERT INTO acfNT_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Madanm-lan wéyalizé sa ki té wivéʼy-la, kon sa i vini, mé i té pè tèlman i té ka twanblé, épi i tonbé douvan Jézi épi i di tout sa ki té wivéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jézi diʼy, “Ich mwen, lafwa-a ou ni an Bondyé-a ja fè ou vini byen. Ou sa alé apwézan paski mwen ja byen djéwiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Patan Jézi té ka di madanm-lan sa-a, déotwa nonm sòti lakay Jayròs épi yo diʼy, “I pa ka fè sans pou Mèt-la vini ankò. Fiʼw-la ja mò.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Jézi pa té anbété kòʼy épi sa yo di-a, mé i di Jayròs, “Pa pè. Kwè sèlman.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","La, i pa kité pyèsonn vini épiʼy antiwan Pita, Jémz épi Jan ki fwè Jémz. ");
INSERT INTO acfNT_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Lè yo wivé lakay Jayròs, Jézi wè tout halé kasé-a épi i tann tout sa ki té ka hélé épi fè kwi. ");
INSERT INTO acfNT_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","I antwé an kay-la épi i di yo, “Pouki tout halé kasé sala? Pouki ou ka hélé? Ti manmay-la pa mò. I ka dòmi sèlman.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Sé moun-an koumansé pwan Jézi sèvi widitjil, kon sa i mété yo tout dèwò épi i pwan Jayròs épi manman ti manmay-la épi sé twa disip-la ki té épiʼy-la, èk i antwé an chanm-lan koté ti manmay-la té kouché-a. ");
INSERT INTO acfNT_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","I tjenbéʼy pa lanmen épi i diʼy, “Talitha koum.” Sa vlé di, “Ti fi, mwen diʼw lévé.” ");
INSERT INTO acfNT_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","La menm ti fi-a lévé épi i koumansé maché oliwon-an. (I té douz an.) Lè sa fèt, sé moun-an té sipwi tèlman. ");
INSERT INTO acfNT_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Mé Jézi konmandé yo pou pa di pyèsonn, épi i di yo pou bay ti fi-a an bagay pou i manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jézi kité koté i té yé-a èk i viwé adan vil-la koté i té lévé-a. Sé disip li-a té la épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Asou jou sabaf-la i antwé an légliz-la, èk la i koumansé enstwi sé moun-an ki té la-a. An chay sé moun-an ki té tann li-a té sipwi. Sé moun-an di, “Koté nonm sala jwenn bagay sala? Koté i jwenn kalité lasajès sala? I sa jis fè miwak! ");
INSERT INTO acfNT_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","I pa chapantyé-a, on? Gason Mari-a? Fwè Jémz, Jozèf, Jida, épi Simon? Pa sé séséʼy-la ki la épi nou-an?” Épi sé moun-an pa té kontanʼy pou sa i di-a. ");
INSERT INTO acfNT_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Jézi di yo kon sa, “Moun ka wèspèkté on pwòfèt toupatou, mé an vil li menm anpami fanmiʼy épi an kay li yo pa ka wèspèktéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","La i pa té sa fè djè miwak anpami yo, mé i pasé lanmenʼy asou déotwa ki té malad épi i djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Èk Jézi té sipwi pou wè mannyè sé moun sala pa ni lafwa. La Jézi alé oliwon-an, vilaj pa vilaj, èk i té ka enstwi sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Épi i vini èk i kwiyé sé douz disip-la sèlman èk i voyé yo alé pa dé épi i ba yo pouvwa anlè vyé lèspwi. ");
INSERT INTO acfNT_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Épi i konmandé yo kon sa, “Pa pwan anyen pou lawout-la mé an baton pou maché sèlman — pyès pen, pyès sak, pyès lajan an pòch ou. ");
INSERT INTO acfNT_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Mété sapat mé pa mété yon lòt chimiz. ");
INSERT INTO acfNT_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Lè ou antwé adan an kay, wèsté andidan kay sala jis tan ou kité vil sala. ");
INSERT INTO acfNT_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Épi lè ou antwé andidan pyès plas èk sé moun-an an plas-la pa wisivwèʼw ében yo pa koutéʼw, lè ou kité plas sala soukwé lapousyè-a ki anba pyéʼw kon an sin pou moutwé yo ja widjèkté Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Épi yo alé èk pwéché ka di moun yo sipozé wépanti. ");
INSERT INTO acfNT_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Yo tiwé an chay vyé lèspwi an sé moun-an, épi an chay ki té malad yo vidé lwil doliv asou tèt yo èk djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wa Hèròd tann tout sé twavay-la Jézi té ka fè-a, paski non Jézi té ja simen toupatou. Adan moun té ka di sé Jan Batis ki té wésisité hòd lanmò épi sa sé wézon-an i sa fè tout sé miwak sala. ");
INSERT INTO acfNT_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Lézòt moun di i sé Ilaydja. I ni moun ki di i sé an pwòfèt menm kon sé pwòfèt lontan-an. ");
INSERT INTO acfNT_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Mé lè Hèròd tann sa, i di, “Sa sé menm Jan Batis-la mwen té konmandé yo pou koupé kouʼy-la. I sanm i ka viv ankò.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Paski Hèròd menm té ja konmandé pou yo awété Jan épi météʼy an pwizon. Hèròd fè sa pou lapéti madanm li, Hèrodiyas. Hèrodiyas sété madanm Filip, fwè Hèròd, mé magwé sa Hèròd té mayé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Jan Batis té toujou ka di Hèròd, i kont lwa Bondyé pou i mayé épi madanm fwèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Pou lapéti sa, Hèrodiyas té byen faché kont Jan épi i té vlé wè yo tjwé Jan, mé i pa té ni pouvwa-a pou fè Hèròd fè sa. ");
INSERT INTO acfNT_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Paski Hèròd menm té ka wèspèkté Jan an chay, épi i té ka pwotèkté Jan hòd Hèrodiyas, paski i sav i té ka maché dwèt épi laviʼy té nèt. Tout fwa Hèròd té ka tann Jan Batis, sa Jan té ka di-a té ka twoubléʼy an chay, mé magwé sa, i té ka kontan tann li. ");
INSERT INTO acfNT_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Mé lè-a Hèrodiyas té ka èspéyé-a wivé. I té asou jou-a Wa Hèròd sélébwé jou nésans li, lè i bay an fèsten bay tout sé gwo ofisyé gouvèdman-an, sé chèf sòlda-a, épi tout jan ki té wich ki té ka wèsté an Galili. ");
INSERT INTO acfNT_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Fi Hèrodiyas antwé koté Wa Hèròd té tjenn fèsten-an épi i dansé. Mannyè i dansé-a plè Wa Hèròd épi sé jan-an ki té an fèsten-an an chay. Kon sa Wa Hèròd di fi-a, “Mandé mwen népòt bagay ou vlé épi mwen kay ba ouʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Lè i fè pwonmèt sala i fè sèman épi i di, “Anyen ou mandé mwen, mwen kay ba ouʼy, i pé an dimi an tè-a ki anba kondwit mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Kon sa fi-a sòti an lasal-la koté fèsten-an té yé-a épi i alé mandé manmanʼy Hèrodiyas, “Ki sa ou vlé mwen mandé pou?” Épi Hèrodiyas di, “Mandé pou tèt Jan Batis.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","La menm fi-a vini vitman épi i di Wa Hèròd, “Mwen vlé ou ban mwen apwézan sala asou an twé, tèt Jan Batis.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Bagay sala fi-a mandé-a fè Wa Hèròd byen lapenn, mé pou lapéti pwonmèt-la i té fè-a épi sé moun-an i té envité-a, i pa té sa wifizé fi-a. ");
INSERT INTO acfNT_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Kon sa Wa Hèròd voyé yon sòlda ki té ka gad-la épi i konmandéʼy pou mennen tèt Jan Batis. Gad-la alé an pwizon-an épi i koupé kou Jan, ");
INSERT INTO acfNT_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","épi i mennenʼy asou an twé épi i pwézantéʼy bay fi-a épi fi-a bay manmanʼy Hèrodiyas li. ");
INSERT INTO acfNT_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Épi lè sé disip Jan Batis-la tann sa, yo alé épi yo pwan kò-a épi yo téwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Lè sé disip-la witounen yo wakonté Jézi tout sa yo té fè épi sa yo té enstwi sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mé i té ni tèlman moun ka antwé sòti ka vin wè sé disip-la èk Jézi, yo pa té ni yon ti chans pou yo sa manjé. Jézi di yo kon sa, “Annou pwan an ti tan pa kò nou koté nou sa pozé épi manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Kon sa yo kité la adan an kannòt épi yo alé on plas koté yo té kay yé pa kò yo. ");
INSERT INTO acfNT_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Patan yo pati-a an chay sé moun-an apèsivwè yo épi yo mété kouwi an tout sé vil-la épi yo alé asanblé asou lans-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Lè Jézi wivé asou lans-lan i wè pil moun sala ki ja sanblé la-a. Yo fèʼy lapenn paski i gadé yo kon mouton ki pa té ni bèwjé. Épi la i koumansé enstwi yo an chay bagay. ");
INSERT INTO acfNT_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Mé lè i fin pwéché i té ja ka vini ta épi koté yo té yé-a té lwen vil. Kon sa sé disip-la vini èk di Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","“I ja ka vini ta. Voyé sé moun-an alé an sé vil èk vilaj oliwon-an pou yo chaché manjé pou yo manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Jézi di sé disip-la, “Zòt menm ba yo manjé pou yo manjé.” Mé sé disip-la wéponn épi di, “Pou mizi moun ki la, an moun kay ni pou twavay ywit mwa pou nou sa ni asé lajan pou sa bay tout sé moun sala manjé.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jézi di yo kon sa, “Alé gadé konmen pen èk pwéson zòt ni.” Lè yo té sav, yo viwé èk yo di Jézi, “La ni senk pen épi dé pwéson.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jézi konmandé yo pou fè sé moun-an asid adan pil asou zèb vè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Adan sé pil-la té ni senkant moun, èk adan té ni on san. ");
INSERT INTO acfNT_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Kon sa lè tout moun asid, Jézi fè yo mennen pen-an èk pwéson-an ba li. I tjenbé pen-an épi dé pwéson-an, i lévé zyéʼy an syèl épi i pwédyé. Lè i fin pwédyé, i kasé sé pen-an épi i météʼy douvan sé disip-la pou sé disip-la bay sé moun-an. I té sépawé sé pwéson-an osi. ");
INSERT INTO acfNT_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Tout moun ki té la manjé bouden plen épi yo té satisfè. ");
INSERT INTO acfNT_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Lè yo fin manjé, sé disip-la anmasé tout lèstan sé pen-an épi pwéson-an ki té wèsté-a. Épi lèstan-an plen douz panyen. ");
INSERT INTO acfNT_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Èk jou sala limowo nonm ki té manjé sété senk mil. ");
INSERT INTO acfNT_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","La menm Jézi di sé disip-la, “Patan mwen ka fè sé moun-an alé-a, pwan kannòt-la èk désann Bèfsayda avan mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Apwé i fè yo alé, i mouté an sé mòn-an pou i pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Lè sòlèy kouché, kannòt-la sé disip-la té adan-an té an mitan Lanmè Galili, épi Jézi yonn té asou tè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Jézi wè sé disip-la ka fòsé patan yo ka najé zaviyon-an, paski van-an té ka vanté kont yo. Avan jou ouvè, patan i té ti nwè toujou, Jézi maché asou lanmè-a pou alé jwenn yo. Épi i té ka alé pou pasé yo, ");
INSERT INTO acfNT_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","mé lè sé disip-la wè Jézi ka maché asou lanmè-a, yo té kwè i té an lèspwi épi yo fè yon kwi ");
INSERT INTO acfNT_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","paski yo tout wèʼy épi yo té pè an chay. La menm Jézi palé ba yo èk di kon sa, “Pwan tjè. Sa sé mwen Jézi ki la. Pa pou ou pè.” ");
INSERT INTO acfNT_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Épi i ay jwenn yo adan kannòt-la, épi van-an tonbé nèt. Sé disip-la té tèlman sipwi ");
INSERT INTO acfNT_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","paski yo pʼòkò té konpwann miwak-la Jézi té fè èk sé pen-an. Tèt yo té wèd toujou. ");
INSERT INTO acfNT_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Lè yo fè tè, yo té plas Jennèsawèt épi yo échwé la. ");
INSERT INTO acfNT_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Kon yo wivé a tè-a épi yo sòti an kannòt-la, sé moun-an apèsivwè sété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Yo kouwi sòti toupatou an plas-la épi yo chayé sé sa ki té malad asou hanmak yo koté yo tann Jézi té yé. ");
INSERT INTO acfNT_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Épi toupatou Jézi alé, an sé vilaj-la, an sé vil-la èk an hòtè, sé moun-an mennen sé sa ki té malad-la adan sé laplas-la épi yo di Jézi, “Souplé kité sé jan malad-la touché bout had ou sèlman.” Épi tout sa ki touchéʼy jwenn djéwizon. ");
INSERT INTO acfNT_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Sé Fawizyen-an épi adan sé titja lwa sé Jwif-la ki té sòti Jérouzalèm-lan asanblé oliwon Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Yo apèsivwè adan sé disip Jézi-a té ka manjé épi yo pa té nétwayé lanmen yo mannyè sé Fawizyen-an té di an moun sipozé nétwayé lanmen yo avan yo té sa manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Sé Fawizyen-an épi tout sé lézòt sé Jwif-la té ni an sèten twadisyon ki té byen enpòtan pou yo: Yo pa ka manjé anba yo lavé lanmen yo mannyè-a ayèl yo épi lwa wilizyon yo té moutwé yo pou fèʼy-la, ");
INSERT INTO acfNT_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ni yo pa ka manjé anyen ki sòti an laplas-la anba yo lavéʼy kon yo té moutwé yo pou fè. Épi yo té ka swiv an chay lézòt twadisyon, kon mannyè pou lavé vè épi pòt èk tout vésèl ki té fèt an tjwiv. ");
INSERT INTO acfNT_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Kon sa sé Fawizyen-an épi sé titja lwa sé Jwif-la mandé Jézi, “Pouki sé disip ou-a pa ka swiv sé bagay-la ayèl nou moutwé-a, mé pito sa yo ka manjé épi lanmen ki pa nèt?” ");
INSERT INTO acfNT_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jézi wéponn yo, “Pwòfèt Izaya pa té manti lè i té déklawé pawòl Bondyé konsèné zòt! Zòt ipokwit menm mannyè i té ékwi an liv li lontan, i di, ‘Sé moun sala ka ban mwen lonnè épi bouch yo, mé an tjè yo, yo pa ka ban mwen pyès lonnè. ");
INSERT INTO acfNT_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Yo ka adowé mwen an ven, paski yo ka enstwi konmandman nonm fè akwèdi yo té lwa Bondyé.’ ");
INSERT INTO acfNT_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“Zòt mété lwa Bondyé-a asou koté épi zòt ka obéyi lwa nonm. ");
INSERT INTO acfNT_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Zòt ja dékouvè an bon mannyè pou widjèkté lwa Bondyé pou zòt sa établi lwa zòt menm. ");
INSERT INTO acfNT_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Moziz té ékwi, ‘Wèspèkté papaʼw épi manmanʼw,’ épi ‘Pyèsonn ki malpalé papaʼy ében manmanʼy sipozé pou mò.’ ");
INSERT INTO acfNT_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Mé zòt ka moutwé sé moun-an an lwa ki di si an moun sipozé bay manmanʼy épi papaʼy an bagay i sa kwiyéʼy ‘kòbann’ — sa vlé di sa sé an kado i ja bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Èk dépi i fè sa i pa ni pou bay manmanʼy épi papaʼy ankò. ");
INSERT INTO acfNT_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Épi mannyè zòt ka enstwi lézòt-la ka moutwé ou pa ni pyès wèspé pou pawòl Bondyé. Épi la ni an chay lézòt bagay kon sa zòt ka fè.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jézi kwiyé sé moun-an ankò épi i di yo, “Kouté mwen, zòt tout, épi konpwann. ");
INSERT INTO acfNT_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","I pa ni anyen dèwò an moun ki antwé an bouch li ki sa anpéché Bondyé aksèptéʼy. Mé sé bagay-la ki ka sòti an tjè an moun-an, sé sa ki ka anpéché Bondyé aksèptéʼy.  ");
INSERT INTO acfNT_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Si ou ni zòwèy, ou sipozé kouté.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Épi lè Jézi kité sé moun-an épi i alé an kay-la koté i té ka wèsté-a, sé disip li-a mandéʼy konsèné pawabòl sala. ");
INSERT INTO acfNT_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Jézi di yo, “Zòt menm pa ni lakonpwann nonplis? Zòt pa wè sé pa bagay-la ki antwé an bouch an moun ki ka anpéché Bondyé aksèptéʼy? ");
INSERT INTO acfNT_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Paski bagay-la i manjé-a pa ka antwé andidan tjèʼy mé pito andidan boudenʼy, épi apwé i sòti an boudenʼy i ka alé adan an pwévit.” (Kon sa Jézi déklawé tout manjé aksèptab pou manjé.) ");
INSERT INTO acfNT_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Jézi kontiné, “Sa ki sòti an tjè an moun, sé sa ki ka anpéché Bondyé aksèptéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Sé sa ki an tjè moun ki ka fè yo katjilé sa ki pa bon, yo ka viv an lavi malpwòp, yo ka vòlè, yo ka tjwé, yo ka fè adiltè, ");
INSERT INTO acfNT_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","yo vowas, yo ka fè movèzté, yo ka kwennen, yo ka viv an vyé lavi, yo ka jalou, yo ka nwèsi non lézòt, yo ka kwè yo enpòtan, yo kouyon. ");
INSERT INTO acfNT_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Sé tout sé bagay sala ki ka sòti andidan an nonm ki ka anpéché Bondyé aksèptéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Jézi kité plas-la ko i té yé-a épi i alé adan an lòt plas ki té pwé vil Taya. I antwé an kay-la koté i té kay wèsté-a épi i pa té vlé pyèsonn sav. Mé sa pa té sa wèsté kon an sigwé. ");
INSERT INTO acfNT_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","An sèten madanm té ni an ti fi ki té ni an vyé lèspwi andidanʼy. Lè madanm-lan tann konsèné Jézi, i alé la menm épi i tonbé an pyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Madanm-lan pa té an Jwif. I té fèt an pawès Fènisiya, ki an péyi Siriya. I di Jézi, “Mwen ka mandéʼw, souplé, tiwé vyé lèspwi sala an ti fi mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Mé Jézi wéponn li, “Annou swen sé manmay-la avan. I pa dwèt pou ou sa pwan manjé sé manmay-la épi bay chyenʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Madanm-lan wéponn, “Mèt, sa vwé, mé jik sé chyen-an ki anba tab-la ka manjé lèstan sé manmay-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Kon sa Jézi diʼy, “Pou kalité wépons sala, ou sa alé lakay ou. Vyé lèspwi-a ja sòti an ti fiʼw-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Madanm-lan viwé lakay li épi i jwenn ti manmay-la kouché asou kouch-la. Épi vyé lèspwi-a té ja sòti an li. ");
INSERT INTO acfNT_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Lè Jézi kité Taya i alé Sidon épi i viwé bò Lanmè Galili pa plas-la yo ka kwiyé Dis Vil-la. ");
INSERT INTO acfNT_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Déotwa moun mennen an nonm ba li ki té soud, épi nonm-lan pa té sa byen palé nonplis. Yo di Jézi, “Souplé, pasé lanmen djéwizon asouʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Kon sa Jézi mennen nonm-lan asou koté hòd sé moun-an, i mété dwèt li an zòwèy nonm-lan, i kwaché, épi i touché lanng nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Épi Jézi gadé an syèl épi i pwan an gwo lèspiwasyon akwèdi i té sòti an fon tjèʼy épi i di an langaj li menm, “Èfata,” sa vlé di, “Ouvè!” ");
INSERT INTO acfNT_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","La menm nonm-lan koumansé tann byen épi i koumansé palé san pyès twaka. ");
INSERT INTO acfNT_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","La Jézi konmandé yo pou pa di sa ki fèt la bay pyèsonn. Mé pli Jézi konmandé yo pou pa di sa, sé pli yo diʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Épi tout sa ki tann wèsté épi bouch gwan ouvè épi yo di, “É é, gadé mannyè i ka fè tout bagay byen! I ka jis fè sa ki soud tann épi sa ki moumou, i ka fè yo palé!” ");
INSERT INTO acfNT_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Pa lontan apwé sa, an lòt gwan konpanni moun té asanblé. Lè yo pa té wèsté anyen pou yo té sa manjé, Jézi kwiyé sé disip li-a épi i di yo, ");
INSERT INTO acfNT_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Sé moun sala ka fè mwen lapenn, paski yo ja wèsté épi mwen pou twa jou épi apwézan yo pa ni anyen pou yo sa manjé. ");
INSERT INTO acfNT_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Épi si mwen voyé yo alé tou fen, fèblès kay pwan yo asou chimen, paski adan di yo sòti byen lwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Sé disip li-a wéponn, “Mé kon plas sala pa ni pyèsonn ka wèsté-a, ki koté nou kay jwenn asé pen pou nou sa bay tout sé moun sala manjé?” ");
INSERT INTO acfNT_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jézi wéponn yo, “Konmen pen zòt ni?” Yo wéponn, “Nou ni sèt pen.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Jézi di sé moun-an pou asid a tè-a. Apwé sa i pwan sèt pen-an, i wimèsyé Bondyé épi i kasé yo èk i bay sé disip li-a pou yo sa sépawéʼy bay sé moun-an, épi sé disip li-a pwan sé pen-an épi yo sépawéʼy anpami sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","La té ni déotwa ti pwéson osi. Jézi wimèsyé Bondyé pou yo épi i di sé disip li-a pou sépawé yo osi. ");
INSERT INTO acfNT_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Sé moun-an manjé épi bouden yo tout té plen. La té ni apipwé kat mil moun. ");
INSERT INTO acfNT_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Épi sé disip-la anmasé sèt panyen plen an sé mòso-a ki té wèsté-a. Épi Jézi voyé sé moun-an alé, ");
INSERT INTO acfNT_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","èk la menm i batjé adan an kannòt épi sé disip li-a èk yo alé adan an plas yo ka kwiyé Dalmannoufa. ");
INSERT INTO acfNT_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Sé Fawizyen-an vini wè Jézi épi yo koumansé ka palé kont sé bagay-la Jézi té ka di-a. Yo té vlé wè si Jézi té moun-an i di i yé-a. Kon sa yo mandéʼy pou fè an miwak ki kay moutwé yo sé Bondyé ki voyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jézi pwan yon gwo van akwèdi van-an sòti an fon tjèʼy épi i di, “Pouki sé moun tan jòdi-a ka mandé pou an miwak? Mwen ka diʼw lavéwité, sé moun sala pa kay wè pyès miwak fèt.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Épi i kité yo èk i antwé adan kannòt-la épi i viwé lòt fasad Lanmè Galili-a. ");
INSERT INTO acfNT_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Sé disip-la té obliyé mennen pen. Si pa té pou an sèl ti pen, yo pa té kay ni pyès pen épi yo abò kannòt-la. ");
INSERT INTO acfNT_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jézi vèti yo, “Pwan pokosyon épi véyé pou lèlven sé Fawizyen-an épi sa Hèròd.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Sé disip-la koumansé palé anpami yo menm épi yo di, “I di sa paski nou pa ni pen.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mé Jézi té sav sa yo té ka di-a, kon sa i mandé yo, “Pouki zòt ka di sé paski zòt pa ni pen? Ou vlé di zòt pʼòkò sa wè ében zòt pʼòkò sa konpwann toujou? Ki mannyè tjè zòt otan wèd? ");
INSERT INTO acfNT_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Zòt ni zyé mé i sanm zòt pa sa wè. Magwé zòt ni zòwèy mwen pa ni lidé zòt sa tann. Ében i pa sanm zòt sa menm chonjé. ");
INSERT INTO acfNT_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Lè mwen té kasé senk pen-an pou mwen sa bay senk mil moun manjé-a, konmen panyen zòt té plen épi lèstan?” Yo wéponn, “Douz.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Jézi kontiné, “Lè mwen té kasé sèt pen pou mwen té sa swen kat mil moun-an, konmen panyen zòt té plen épi lèstan?” “Sèt,” yo wéponn. ");
INSERT INTO acfNT_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Jézi di yo, “Épi zòt pʼòkò konpwann toujou?” ");
INSERT INTO acfNT_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Jézi épi sé disip li-a wivé plas Bèfsayda. La déotwa moun mennen an nonm ki avèg bay Jézi épi yo diʼy, “Souplé, touché nonm avèg-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Épi Jézi pwan nonm-lan pa lanmenʼy èk i mennenʼy sòti an vilaj-la. Épi apwé Jézi kwaché asou zyé nonm-lan, i plasé lanmenʼy asou zyéʼy épi i mandéʼy, “Ès si ou sa wè anyen?” ");
INSERT INTO acfNT_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nonm-lan lévé tèt li épi i di, “Wi, mwen ka wè moun ka maché oliwon-an, mé yo ka sanm pyé bwa.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Jézi plasé lanmenʼy ankò asou zyé nonm-lan. Kou sala zyé nonm-lan ouvè, yo té djéwi épi i té ka wè tout bagay byen. ");
INSERT INTO acfNT_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Jézi voyé nonm-lan lakay li épi i konmandéʼy pou pa viwé an vilaj-la. ");
INSERT INTO acfNT_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","La Jézi épi sé disip li-a pati alé an plas-la yo kwiyé Sizariya Filipay. Asou lawout-la, Jézi mandé yo, “Di mwen, lè moun palé konsèné mwen, ki moun yo ka di mwen yé?” ");
INSERT INTO acfNT_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Sé disip-la wéponn, “Adan di ou sé Jan Batis, lézòt di ou sé pwòfèt Ilaydja, épi i ni sa ki di ou sé yonn adan sé lézòt pwòfèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Jézi mandé yo, “Mé zòt menm, ki moun zòt kay di mwen yé?” Pita wéponn, “Ou sé Mèsaya-a Bondyé té pwonmèt pou voyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","La Jézi konmandé yo épi i di, “Bagay sala ou di-a, mwen pa vlé zòt mansyonnenʼy bay pyèsonn.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Apwé sa, Jézi koumansé enstwi sé disip li-a épi i di, “Mwen, Gason Lézòm, kay soufè an chay, épi sé ofisyé légliz-la, sé chèf pwèt-la épi sé titja lwa sé Jwif-la, yo tout kay widjèkté mwen. Yo kay tjwé mwen épi apwé twa jou, mwen kay wésisité hòd lanmò.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Jézi palé byen senp pou yo té sa konpwann. Kon sa Pita kwiyé Jézi asou koté épi i di, “Pa palé mannyè sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Mé Jézi tounen oliwon, épi i gadé sé disip-la épi i palé byen wèd bay Pita épi i di, “Sòti douvan mwen, Satan! Katjil ou sé katjil nonm épi i pa sa Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Apwé sa, Jézi kwiyé sé moun-an épi sé disip li-a épi i di, “Si an moun vlé swiv mwen i kay ni pou mété kòʼy épi plézi latè-a dèyè, pòté kwaʼy menm épi swiv mwen. ");
INSERT INTO acfNT_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Paski moun-an ki ka katjilé sèlman ki mannyè pou i sové laviʼy-la kay pèd li. Mé pyès moun ki pèd laviʼy pou lapéti mwen ében pou lapéti Bon Nouvèl-la, i kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mé ki sa an nonm kay bennéfis menm si i vini ni tout latè-a épi i pèd lam li? ");
INSERT INTO acfNT_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Ében ki sa an moun sa boukanté pou lam li? ");
INSERT INTO acfNT_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Épi si an nonm ka hont pou lapéti mwen épi pawòl mwen anpami jennenwasyon péché sala, mwen, Gason Lézòm, kay hont pou li osi lè mwen vini épi sé nanj Bondyé-a an pouvwa épi klèté Papa mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Épi i di yo, “Mwen ka di zòt lavéwité-a, adan zòt ki la-a pa kay mò tout tan yo pʼòkò wè kondwit Bondyé vini épi pouvwa.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Apwé sis jou Jézi pwan Pita, Jémz èk Jan èk i mennen yo mouté asou an mòn, èk yo kat-la té la pa kò yo. La lapawans Jézi chanjé douvan yo. ");
INSERT INTO acfNT_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Had li vini si tèlman blan pyès moun asou latè sala pa sa fè an had vini otan blan. ");
INSERT INTO acfNT_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Épi la pwòfèt Moziz èk pwòfèt Ilaydja pawèt douvan yo èk yo dé-a té ka palé épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pita di Jézi, “Mèt, i bon pou nou té isi-a. Annou fè twa ti chapèl, yonn pou ou, yonn pou Moziz èk yonn pou Ilaydja.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","(Pita pa té sav sa pou di paski yo té tèlman pè.) ");
INSERT INTO acfNT_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","La menm an nwaj pawèt épi i kouvè yo nèt, èk yo tann an vwa an nwaj-la di, “Sa sé Gason mwen, mwen kontanʼy an chay. Koutéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","La menm yo gadé oliwon-an èk yo pa wè pyèsonn épi yo ankò, mé Jézi sèlman. ");
INSERT INTO acfNT_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Kon yo té ka désann mòn-an Jézi konmandé yo pou pa di pyèsonn sa yo té wè-a anba lè Gason Lézòm wésisité. ");
INSERT INTO acfNT_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Yo tjenn zafè sala anpami yo sèlman, épi yo té ka wézonnen anpami yo ki sa ‘wésisité’ yé. ");
INSERT INTO acfNT_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Èk yo mandéʼy pouki sé titja lwa sé Jwif-la di Ilaydja ni pou vini avan Bondyé voyé Mèsaya-a i té pwonmèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Jézi wéponn, “Vwéman Ilaydja té ni pou vini avan èk mété tout bagay annòd. Mé ki sa lévanjil di konsèné Gason Lézòm? I di kon sa, Gason Lézòm oblijé soufè an chay èk yo kay maltwétéʼy èk dézobéyiʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Mé mwen ka diʼw, Ilaydja ja vini èk yo fèʼy tout sa yo té vlé, menm kon i ékwi an lévanjil konsènéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Lè yo viwé jwenn sé lézòt disip-la, yo wè an gwan pil moun oliwon yo épi sé titja lwa sé Jwif-la té ka chikannen épi yo. ");
INSERT INTO acfNT_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Épi kon tout sé moun-an wè Jézi, yo soté paski yo pa té kwè yo té kay wèʼy, épi yo kouwi alé jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Jézi mandé yo, “Pouki sa zòt ka chikannen épi yo kon sa?” ");
INSERT INTO acfNT_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","An nonm ki té anpami pil sé moun-an wéponn, “Mèt, mwen mennen gason mwen-an baʼw, i ni an vyé lèspwi andidanʼy épi lèspwi-a ka wann li moumou. ");
INSERT INTO acfNT_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Népòt lè bagay-la pwanʼy, i ka jétéʼy a tè. Bouch li ka tjimé, danʼy ka kwatjé épi kòʼy ka vini wèd kon wòch. Mwen mandé sé disip ou-a pou tiwé vyé lèspwi-a mé yo pa té sa.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jézi wéponn, “Aaa, jennenwasyon sala ki pa ni konfyans an Bondyé-a! Konmen tan mwen kay ni pou wèsté épi zòt pou zòt sa kwè? Konmen tan zòt kwè mwen kay sa ni pasyans kon sa épi zòt? Mennen gason-an ban mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Épi yo mennen gason-an ba li. Lè vyé lèspwi-a wè Jézi, i soukwé gason-an menm kon an moun ki ni an malkadi, gason-an tonbé a tè-a épi i woulé oliwon-an, èk bouch li té ka tjimé. ");
INSERT INTO acfNT_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jézi mandé papa gason-an, “Konmen tan dépi i kon sa?” Papa-a wéponn, “Dépi i tou piti. ");
INSERT INTO acfNT_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Plizyè fwa vyé lèspwi-a ja éséyé pou tjwé gason-an. I ja jétéʼy an difé épi an dlo. Mé si ou sa fè anyen, ni pityé asou nou épi édé nou.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jézi diʼy, “Sa ou vlé di pa ‘Si ou sa fè anyen?’ Tout bagay posib épi moun-an ki ka kwè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","La menm papa gason-an wéponn épi tout fòs li, “Mwen ka kwè! Édé mwen pou mwen sa kwè pli!” ");
INSERT INTO acfNT_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Lè Jézi wè lòt pil sé moun-an ki té ka vini koté yo té yé-a, i palé byen wèd bay vyé lèspwi-a épi i di, “Ou vyé lèspwi ki ka fè gason-an soud épi moumou, mwen ka konmandéʼw, sòti andidan gason-an épi pa janmen viwé ankò.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Vyé lèspwi-a fè an gwo kwi épi i soukwé gason-an menm kon an moun ki ni malkadi épi i sòti an li. Gason-an té gadé menm kon an kò mò, kon sa adan moun jis di, “I mò!” ");
INSERT INTO acfNT_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Mé Jézi tjenbéʼy pa lanmenʼy épi fèʼy doubout asou pyéʼy épi gason-an doubout. ");
INSERT INTO acfNT_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Apwé Jézi antwé an kay-la épi yo té pa kò yo, sé disip li-a mandéʼy, “Pouki nou pa té sa tiwé vyé lèspwi-a?” ");
INSERT INTO acfNT_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Jézi wéponn yo, “Sèl mannyè ou sa tiwé kalité vyé lèspwi sala sé épi lapwiyè.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Yo kité plas sala épi yo pasé an Galili. Jézi pa té vlé pyèsonn sav koté yo té yé, ");
INSERT INTO acfNT_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","paski i té ka enstwi sé disip li-a. I di yo kon sa, “Yo kay délivwé mwen, Gason Lézòm, anba pouvwa lanmen nonm ki kay tjwé mwen. Mé twa jou apwé, mwen kay wésisité hòd lanmò.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Sé disip-la pa té konpwann sa i di-a, mé yo té pè pou mandéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Yo wivé Kapènéyòm. Lè Jézi té an kay-la, i mandé sé disip-la, “Pouki sa zòt té ka chikannen kon sa asou chimen-an?” ");
INSERT INTO acfNT_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Mé yo pa di anyen paski asou chimen-an yo té ka dispité konsèné kilès anpami yo ki pli enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Jézi asid épi i kwiyé sé douz disip li-a épi i di, “Si pyèsonn vlé kondwi, i kay ni pou dènyé anpami zòt épi i kay ni pou sèvant zòt tout.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","I tjenbé an ti manmay pa lanmenʼy épi i fèʼy vini doubout anpami sé disip li-a. Apwé sa i pwan ti manmay-la an bwaʼy épi i di yo, ");
INSERT INTO acfNT_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Népòt moun ki wisivwè yonn an sé ti manmay sala pou lapéti mwen, i ja wisivwè mwen. Épi moun-an ki wisivwè mwen-an pa wisivwè mwen sèlman, mé i ja wisivwè Bondyé ki voyé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jan di Jézi, “Mèt, nou wè an nonm ki ka sèvi nonʼw pou i sa tiwé vyé lèspwi épi nou diʼy i pa pou fè sa, paski i pa menm konpanni épi nou.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jézi wéponn li, “Sé pa pou ou doubout li, paski pyèsonn ki fè an miwak an non mwen pa sa adan an lòt mouman di anyen ki mal kont mwen, ");
INSERT INTO acfNT_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","paski moun-an ki pa kont nou-an, i pou nou. ");
INSERT INTO acfNT_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Èk si pyèsonn baʼw an pòt dlo pou ou sa bwè paski ou ka swiv mwen, mwen ka diʼw lavéwité, Bondyé kay péyé moun sala viwé.” ");
INSERT INTO acfNT_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Si pyèsonn fè yonn adan sé piti sala ki ka kwè an mwen-an abandonnen lafwa yo, i té kay pli mèyè pou moun sala si yo té jétéʼy an lanmè-a épi an gwo wòch mawé oliwon kouʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Si lanmenʼw ka annékòz ou péché, koupéʼy. I pli mèyè pou ou sa antwé an syèl enfim pito ou ni toulé dé lanmenʼw èk ou alé lanfè, koté difé-a pa ka janmen tenn.  ");
INSERT INTO acfNT_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","La sé vè-a pa ka mò pyès épi difé-a pa ka janmen tenn. ");
INSERT INTO acfNT_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Si pyéʼw ka annékòz ou péché, koupéʼy. I pli mèyè pou ou sa antwé an syèl san dé pyéʼw pito ou ni toulé dé épi yo voyéʼw lanfè.  ");
INSERT INTO acfNT_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","La sé vè-a pa ka mò pyès épi difé-a pa ka janmen tenn. ");
INSERT INTO acfNT_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Épi si zyéʼw ka annékòz ou péché, tiwéʼy. I pli mèyè pou ou sa antwé an syèl épi yon zyé pito ou ni toulé dé épi yo voyéʼw lanfè ");
INSERT INTO acfNT_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","koté sé vè-a pa ka janmen mò épi difé-a pa ka janmen tenn. ");
INSERT INTO acfNT_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Zòt tout kay sizonnen épi difé. ");
INSERT INTO acfNT_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Sèl sé an bon bagay, mé si i ja pèd sistans li, ki mannyè ou sa fèʼy salé ankò? Sizonnen kòʼw épi pawòl Bondyé épi viv an lapé épi yonn a lòt.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Kon sa Jézi kité plas sala épi i janbé Lawivyè Jouden épi i alé an pawès Joudiya. Ankò la té ni an chay moun ki vini otiʼy, épi kon i ni labitid, i enstwi yo. ");
INSERT INTO acfNT_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Déotwa Fawizyen vini koté i té yé-a épi yo té ka gadé pou wè si i té kay palé kont lwa Moziz-la. Épi yo mandéʼy, “Ès si lwa-a ka bay an nonm pèwmi pou i sa dévosé madanm li?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jézi wéponn, “Ki sa Moziz té konmandé zòt?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Yo di, “Moziz té ban nou pèwmi pou nou sa bay madanm-lan an papyé ka moutwé i ja dévosé, épi apwé sa ou sa voyéʼy alé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Jézi wéponn yo, “Moziz ékwi lwa sala paski tjè zòt té wèd. ");
INSERT INTO acfNT_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Mé an koumansman-an, tan-an Bondyé té fè latè épi syèl, lévanjil-la di, ‘I té fè yo nonm épi madanm. ");
INSERT INTO acfNT_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Épi pou wézon sala an nonm kay kité kay papaʼy épi manmanʼy épi i kay wèsté épi madanm li, ");
INSERT INTO acfNT_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","épi yo dé-a kay viv kon yonn.’ Kon sa yo pa dé moun ankò, mé yo sé yonn. ");
INSERT INTO acfNT_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kon sa si Bondyé ja mété dé moun ansanm, nonm pa sipozé sépawé yo.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Lè yo viwé an kay-la, sé disip-la mandé Jézi pou èspliké sa i té di-a konsèné dévosé. ");
INSERT INTO acfNT_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jézi di yo, “Nonm-lan ki kité madanm li-a épi i mayé épi an lòt sé yon adiltè. ");
INSERT INTO acfNT_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Épi si madanm-lan dévosé mawiʼy épi i mayé an lòt nonm i sé an adiltè osi.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Déotwa moun mennen manmay bay Jézi pou i pasé lanmen bennédiksyon asou yo, mé sé disip-la di sé moun-an, “Pouki zòt ka mennen sé manmay sala pou anbété mèt-la kon sa?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Lè Jézi wè sa yo té ka fè-a, i pa té sòti kontan. I di sé disip li-a, “Kité sé manmay-la vini jwenn mwen épi pa anpéché sé moun-an mennen yo ban mwen, paski sé moun ki kon sé manmay sala ki kay vini anba kondwit Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Mwen ka diʼw lavéwité, pyèsonn ki pa kité Bondyé kondwi yo kon sé ti manmay sala ka fè-a pa kay janmen vini anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Épi i pwan sé manmay-la an bwaʼy, i mété lanmenʼy asou yo épi i benni yo. ");
INSERT INTO acfNT_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Kon Jézi pati asou chimenʼy, an nonm kouwi vini jwenn li épi i ajounou douvanʼy. Nonm-lan mandé Jézi, “Bon mèt, ki sa mwen ni pou fè pou mwen sa ni lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Jézi wéponn li, “Pouki ou ka di mwen bon? Apa di Bondyé, pyèsonn pa bon. ");
INSERT INTO acfNT_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ou konnèt sé konmandman-an: Pa pou tjwé, pa pou fè adiltè, pa pou vòlè, pa pou mennen fo témwen, pa kwennen moun pou ou sa pwan bagay yo, wèspèkté manmanʼw épi papaʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Épi nonm-lan di, “Mèt, dépi lè mwen ti gason mwen ka obéyi tout sé konmandman sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Jézi gadéʼy épi lanmityé an tjèʼy épi i di, “Ou ka mantjé an sèl bagay. Alé vann tout sa ou ni épi bay sé maléwé-a lajan-an épi ou kay ni wichès an syèl. Apwé ou fè sa, ou kay swiv mwen pou bon.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Lè Jézi di sa, fidji nonm-lan tonbé menm kon moun ki an lapenn. Épi i alé asou chimenʼy tou an lapenn, paski i té benyen wichès. ");
INSERT INTO acfNT_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Jézi tounen oliwon épi i gadé sé disip li-a épi i di yo, “I difisil pou moun ki ni wichès vini anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Sé disip-la té sipwi pou tann sa Jézi té di-a. Mé Jézi wépétéʼy ankò, “Manmay, i difisil pou vini anba kondwit Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","I pli ézé pou an kanmèl pasé adan an zyé an zédjwi pasé an nonm ki wich vini anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Sé disip-la té pli sipwi toujou épi yo di anpami yo menm, “Ében, ki moun ki sa ni lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Jézi gadé yo épi i di, “Épi nonm i enposib, mé pa épi Bondyé. Tout bagay posib épi Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Pita di Jézi, “Nou ja kité tout bagay pou nou sa swiv ou!” ");
INSERT INTO acfNT_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jézi wéponn, “Mwen ka diʼw lavéwité, pyès moun ki ja kité kay li ében fwèʼy ében séséʼy ében manmanʼy ében papaʼy ében ich li ében tèʼy pou lapéti mwen épi Bon Nouvèl-la ");
INSERT INTO acfNT_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","kay wisivwè yon san fwa pli an tan sala. I kay wisivwè pli kay, fwè, sésé, manman, manmay épi tè — èk épi yo i kay jwenn an chay pèsikasyon, épi an tan pou vini-an, lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Mé an chay moun ki pwèmyé kay vini dènyé épi an chay ki dènyé kay vini pwèmyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yo té asou chimen-an ka mouté Jérouzalèm épi Jézi té ka maché douvan. Sé disip-la té twoublé an tjè yo, épi sé lézòt-la ki té ka swiv yo-a té pè. Ankò Jézi kwiyé douz disip li-a asou koté épi i di yo ki sa ki té kay wivéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","I di yo, “Nou ka mouté Jérouzalèm, épi mwen Gason Lézòm kay tonbé anba pouvwa sé chèf pwèt-la épi sé titja lwa sé Jwif-la. Yo kay pasé jijman asou mwen ki kay di mwen sipozé mò, épi yo kay délivwé mwen bay moun ki pa Jwif, ");
INSERT INTO acfNT_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ki kay motjé mwen épi yo kay kwaché asou mwen, yo kay bat mwen épi kay tjwé mwen. Épi apwé twa jou, mwen kay wésisité hòd lanmò.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Jan épi Jémz, sé gason Zèbèdi-a, vini épi yo di Jézi, “Mèt, nou vlé ou fè bagay-la nou kay mandéʼw-la ban nou.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Jézi wéponn yo, “Ki sa zòt vlé mwen fè bay zòt?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Yo diʼy, “Lè ou kay asid kon wa an pouvwa Papaʼw, nou vlé ou kité nou asid épiʼw yonn asou lanmen dwèt ou épi lòt-la asou lanmen gòch ou pou nou sa kondwi épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jézi di yo kon sa, “Zòt pa menm sav ki sa zòt ka mandé pou-a. Ès si zòt kay sa bwè an pòt soufwans-lan mwen oblijé bwè-a? Ében ès si zòt kay sa batizé menm kon batenm lanmò-a mwen oblijé batizé-a?” ");
INSERT INTO acfNT_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Yo wéponn, “Wi, nou sa fèʼy.” Jézi di yo kon sa, “Zòt kay bwè an pòt soufwans-lan mwen oblijé bwè-a épi batizé an batenm lanmò-a mwen oblijé batizé-a. ");
INSERT INTO acfNT_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Mé sé pa mwen ki kay di ki moun ki kay asid asou lanmen dwèt épi lanmen gòch mwen. Sé Bondyé ki kay di ki moun ki kay asid la épi kondwi épi mwen. Okontwè i ja désidé ki moun sa kay yé.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Lè sé lézòt dis disip-la tann sa, yo lévé faché kont Jémz èk Jan. ");
INSERT INTO acfNT_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Jézi kwiyé sé disip li-a ansanm épi i di, “Zòt sav ki mannyè moun ki sipozé kondwi sé lézòt nasyon-an ka fè kouman? Dépi yo wivé adan an pozisyon pou yo sa kondwi, yo ka fè tout moun ki anba yo sav sé yo ki mèt. ");
INSERT INTO acfNT_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Sé pa kon sa i kay yé anpami zòt. Si zòt pyès vlé ni lotowité anlè sé lézòt-la, ou kay ni pou sèvi yonn a lòt sèvant. ");
INSERT INTO acfNT_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Épi si yonn vlé sé li ki pwèmyé, kitéʼy abésé kòʼy épi vini sèvant zòt tout. ");
INSERT INTO acfNT_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Menm kon mwen Gason Lézòm pa té vini pou sèvi moun kon sèvant mwen. Mwen vini pou sèvi moun sèvant épi pou mwen bay lavi mwen pou mwen sa fè an chay moun viv.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Jézi èk sé disip li-a épi an gwan konpanni moun wivé an vil Jèriko. La té ni on nonm avèg nonʼy sété Batiméyòs gason Timéyòs, épi kon yo té ka kité vil-la i té asid bò chimen-an ka mandé lachawité. ");
INSERT INTO acfNT_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Lè i tann Jézi ki sòti Nazawèt té la, i koumansé andjélé, “Jézi! Gason Wa David, ni konpasyon asou mwen!” ");
INSERT INTO acfNT_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","An chay moun ki té la diʼy kon sa, “Pouki ou ka andjéléʼy kon sa? Doubout bétiz ou-a.” Mé sé pli fò i ka andjélé, “Gason Wa David, ni konpasyon asou mwen!” ");
INSERT INTO acfNT_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Jézi doubout épi i di, “Kwiyéʼy ban mwen.” Kon sa yo kwiyé nonm avèg-la. Sé moun-an diʼy, “Pwan tjè. Doubout. I ka kwiyéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Batiméyòs tiwé gòl li vitman épi i voyéʼy asou koté, i soté asou dé pyéʼy épi i vini douvan Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Jézi mandéʼy, “Ki sa ou vlé mwen fè baʼw?” Batiméyòs wéponn, “Mèt, mwen vlé wè klè ankò.” ");
INSERT INTO acfNT_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Jézi diʼy kon sa, “Pou mannyè ou kwè an mwen, mwen ja djéwiʼw. Ou sa alé apwézan.” Épi la menm i vini wè klè épi i pati an lawout-la èk Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Jézi épi sé disip li-a, kon yo apwoché Jérouzalèm, yo wivé vilaj Bèfaj épi vilaj Bèfanni, bòdaj mòn-an yo ka kwiyé Mòn Òliv. Jézi voyé dé an sé disip-la douvan yo, ");
INSERT INTO acfNT_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","épi i di yo, “Alé an vilaj-la ki douvanʼw-lan, épi kon ou ka antwé an vilaj-la ou kay wè an jenn bouwik mawé la, yonn pyèsonn pa janmen mouté. Démawéʼy épi mennenʼy isi-a. ");
INSERT INTO acfNT_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Si pyèsonn diʼw, ‘Pouki ou ka fè sa?’ diʼy, ‘Senyè-a bizwenʼy épi i kay voyéʼy viwé baʼw talè.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Kon sa yo alé épi yo jwenn an jenn bouwik ki té mawé bò lapòt-la épi i té doubout an chimen-an. Kon yo démawéʼy, ");
INSERT INTO acfNT_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","déotwa moun ki té ka doubout la mandé yo, “Pouki zòt ka démawé bouwik sala?” ");
INSERT INTO acfNT_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Yo wéponn menm kon Jézi té di yo pou wéponn, épi sé moun-an kité yo alé. ");
INSERT INTO acfNT_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Lè yo mennen jenn bouwik-la bay Jézi épi yo té ouvè kanmizòl yo asouʼy, Jézi asid asouʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","An chay sé moun-an té ouvè kanmizòl yo asou chimen-an, épi lòt moun té simen bwanch yo té koupé an sé pyé bwa-a adan savann-an. ");
INSERT INTO acfNT_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Sé moun-an ki té alé douvan-an épi sé sa ki té ka swiv Jézi-a andjélé, “Annou glowifyé Bondyé!” “Ou vini an non Senyè-a, ou benni.” ");
INSERT INTO acfNT_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“Bondyé benni gouvèdman-an i établi anba kondwit gwanpapa nou Wa David, paski gouvèdman sala ka vini ankò.” “Nou ka glowifyé Bondyé ki an syèl pou sa!” ");
INSERT INTO acfNT_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jézi antwé Jérouzalèm épi i alé an Kay Bondyé-a. I gadé tout bagay ki té oliwonʼy, mé paski i té ja ta i viwé an vilaj Bèfanni épi sé douz disip-la. ");
INSERT INTO acfNT_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","An li denmen, kon yo té ka kité Bèfanni, Jézi té fen. ");
INSERT INTO acfNT_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","I wè adan an ti distans an pyé fwi ki té kouvè épi fèy, kon sa i alé gadé si i té sa jwenn pyès fwi asouʼy. Mé lè i wivé la, pyé-a té ni fèy sèlman paski i pa té tan kalité fwi sala. ");
INSERT INTO acfNT_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Jézi di pyé-a, “Pyèsonn pa kay janmen manjé fwi adanʼw ankò!” Épi sé disip-la tann lè i di sa-a. ");
INSERT INTO acfNT_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Lè yo wivé Jérouzalèm, Jézi alé an Kay Bondyé-a épi i koumansé voyé dèwò sé moun-an ki té ka vann épi achté bagay andidan-an. I maté sé tab-la sé moun-an té ka chanjé lajan-an épi sé chèz-la sé moun-an té ka sèvi pou vann toutwèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","I anpéché pyèsonn pasé épi machandiz an lakou Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Épi i di yo kon sa, “I ékwi an lévanjil, ‘Moun kay kwiyé kay mwen an plas tout nasyon kay sèvi pou pwédyé.’ Mé zòt ja fèʼy an kay koté vòlè ka séwé.” ");
INSERT INTO acfNT_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Lè sé chèf pwèt-la épi sé titja lwa sé Jwif-la tann sa, yo koumansé gadé an mannyè pou yo té sa tjwéʼy. Yo té pè Jézi paski tout sé moun-an té kontan tann mannyè i té ka enstwi-a. ");
INSERT INTO acfNT_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Lè sòlèy té ka kouché, Jézi épi sé disip li-a kité vil Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","An li bonmaten, kon yo té ka pasé asou chimen-an, yo wè menm pyé fwi-a té mò nèt. ");
INSERT INTO acfNT_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Pita té chonjé ki sa ki té fèt-la épi i di Jézi, “Mèt! Gadé! Pyé fwi-a ou modi-a mò nèt!” ");
INSERT INTO acfNT_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jézi wéponn yo, “I nésésè pou ou sa kwè an Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Mwen ka diʼw lavéwité, si pyèsonn di mòn sala, ‘Alé, jété kòʼw an lanmè-a,’ épi ou diʼy èk tout tjèʼw, épi ou kwè sa ou di-a kay fèt, mwen ka diʼw i kay fèt baʼw. ");
INSERT INTO acfNT_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Sé pou wézon sala mwen diʼw, lè ou pwédyé épi ou mandé Bondyé an bagay, ou ni pou kwè ou ja jwenn li, épi Bondyé kay baʼw népòt bagay ou mandéʼy pou. ");
INSERT INTO acfNT_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Épi lè ou doubout pou ou pwédyé, ou ni pou pawdonnen népòt moun ki ja fèʼw ditò. Lè ou fè sa, Papaʼw an syèl kay pawdonnen péchéʼw osi.  ");
INSERT INTO acfNT_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Si ou pa ka pawdonnen lézòt, Papaʼw an syèl pa kay pawdonnenʼw nonplis.” ");
INSERT INTO acfNT_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yo viwé Jérouzalèm ankò épi patan Jézi té ka maché an lakou Kay Bondyé-a, sé chèf pwèt-la, sé titja lwa sé Jwif-la épi sé ofisyé légliz-la vini wè Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Yo mandéʼy, “Ki dwa ou ni pou ou fè sé bagay sala? Ében ki moun ki baʼw pouvwa pou ou sa fè sa?” ");
INSERT INTO acfNT_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Jézi wéponn yo, i di, “Mwen kay mandé zòt an sèl kwèsyon épi si zòt wéponn mwen, mwen kay di zòt ki dwa mwen ni pou fè sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Di mwen, ki moun ki té voyé Jan Batis batizé? Ès si sé Bondyé ében ès si sé nonm?” ");
INSERT INTO acfNT_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yo koumansé ka wézonnen anpami yo menm épi yo di, “Si nou wéponn sé Bondyé, i kay mandé nou pou ki wézon nou pa té kwè. ");
INSERT INTO acfNT_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Mé ès si nou sa di sé nonm?” (Yo té pè sé moun-an paski tout moun té ka di Jan Batis sété vwéman an pwòfèt.) ");
INSERT INTO acfNT_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kon sa yo wéponn Jézi, “Nou pa sav.” Jézi wéponn yo, i di, “Mwen pa kay di zòt nonplis ki pouvwa mwen ni pou fè sé bagay sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jézi koumansé ka palé bay sé moun-an an pawabòl. I di, “An nonm planté an jaden wézen. I mété pak tout oliwonʼy, i bati on kay pou fè diven-an épi i fè an ti kay ki té byen ho pou i sa véyé pou jibyé épi lòt zannimo ki ka vini manjé an jaden-an. Lè i fini, i lwé jaden-an bay moun ki té vlé épi i kité lakay li épi i alé an lòt péyi. ");
INSERT INTO acfNT_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Lè tan wékòt-la wivé, i voyé an sèvant alé anmasé lo wézenʼy ba li an lanmen sé moun-an ki té ka lwé jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mé yo tjenbé sèvant-lan, yo bat li épi yo voyéʼy alé lanmen vid. ");
INSERT INTO acfNT_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Kon sa mèt jaden-an voyé an lòt sèvant. Sé moun-an bat dézyenm sèvant-lan asou tèt li, yo ensiltéʼy épi yo maltwétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Mèt jaden-an voyé an lòt sèvant ankò. Kou sala yo tjwé sèvant-lan, épi yo twété an chay lézòt sèvant kon sa. Adan yo bat, épi yo tjwé sé lézòt-la. ");
INSERT INTO acfNT_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Sèl moun mèt jaden-an té wèsté pou i voyé sé gasonʼy-lan i kontan an chay-la. Kon sa i voyéʼy dènyé épi i di, ‘Yo kay pòté gason mwen-an wèspé.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Mé sé moun-an ki ka lwé jaden-an di bay yonn a lòt, ‘Mi sala ki kay jwenn tout popyétè papaʼy-la. Annou tjwéʼy épi tout bagay kay vini pou nou.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Kon sa yo pwanʼy, yo tjwéʼy épi yo jété kòʼy dèwò jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Ki sa mèt jaden-an kay fè? I kay vini épi tjwé tout sé moun sala ki té ka lwé jadenʼy-lan, épi i kay pwan jaden-an épi lwéʼy bay lézòt.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","11","Épi i di sé moun-an ankò, “Ou oblijé ja li koté an lévanjil-la ki di, ‘Menm wòch-la sé jan-an ki ka fè kay-la widjèkté-a, Bondyé fè wòch sala pli enpòtan an kay-la, épi sa fè nou byen kontan.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Kon sa sé chèf sé Jwif-la éséyé pou awété Jézi paski yo sav pawabòl sala té kont yo. Mé paski yo té pè sé moun-an, yo kitéʼy épi yo alé fè chimen yo. ");
INSERT INTO acfNT_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Pli ta, sé ofisyé sé Jwif-la voyé déotwa Fawizyen épi adan manm an patizan Wa Hèròd-la dèyè Jézi pou kwèsyonnenʼy pou pwan lanng li. ");
INSERT INTO acfNT_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Yo vini wèʼy épi yo di, “Mèt nou sav ou sé an nonm ki ka palé lavéwité. Ou pa ka anbété kòʼw épi sa moun kwè ében ki pozisyon yo ni an latè sala, mé ou ka enstwi nonm lavéwité, sa sé mannyè-a Bondyé ja mété pou nonm viv-la. Di nou, ès si ou kwè i dwèt pou nou péyé Wa Siza lajan, o pa? ");
INSERT INTO acfNT_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ès si nou sipozé péyéʼy ében nou pa oblijé péyé?” Mé Jézi sav sé ipokwit yo té ka fè, épi i wéponn yo, “Mwen sav zòt ka gadé si zòt sa fè mwen fè lèwè. Mennen an pyès dajan ban mwen pou mwen sa gadéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Yo mennen an pyès dajan ba li épi i mandé yo, “Fidji ki moun épi non ki moun ki matjé asouʼy?” Yo wéponn li, “Sa Wa Siza.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Kon sa Jézi di yo, “Zòt sipozé bay Wa Siza sa ki ka vini pou li, épi zòt sipozé bay Bondyé sa ki ka vini pou li osi.” Épi sé moun-an wèsté épi bouch yo gwan ouvè. ");
INSERT INTO acfNT_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Déotwa an sé Jwif-la yo ka kwiyé sé Sadisyen-an vini dèyè Jézi pou wè si yo té sa kwennenʼy. (Yo sé an konpanni Jwif ki di moun pa ka wésisité hòd lanmò.) ");
INSERT INTO acfNT_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Yo di, “Mèt, Moziz té ékwi lwa sala ban nou. I di kon sa, ‘Si an nonm mò épi i kité madanm li san pyès ich, fwè nonm-lan oblijé mayé èk madanm-lan pou i sa lévé ich bay fwè-a ki ja mò-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Bon, i té ni an tan, la té ni sèt fwè. Pli gwan-an mayé, épi lè i mò, i pa té kité pyès ich. ");
INSERT INTO acfNT_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Lòt fwè-a ki té apwéʼy-la mayé épi menm madanm-lan, épi i menm vini mò mé i pa té kité pyès ich osi. Menm bagay-la wivé lòt fwè-a osi, ");
INSERT INTO acfNT_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","épi tout lèstan sé fwè-a. Tout sèt sé fwè-a mayé madanm-lan, épi tout mò épi yo pa kité pyès ich. Épi apwé sa, madanm-lan vini mò. ");
INSERT INTO acfNT_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kon sa, lè tout mò kay wésisité asou jou wézèwèksyon-an, madanm kilès an sé fwè-a i kay yé? Tout sèt sé fwè-a té mayé épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jézi wéponn yo, “Zòt adan an chay lèwè, paski zòt pa konnèt ni lévanjil ni pouvwa Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Lè moun kay wésisité asou jou wézèwèksyon-an, yo pa kay mayé mé yo kay menm kon sé nanj-lan ki an syèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Bon, konsèné ès si moun kay wésisité hòd lanmò-a, mwen sav zòt ja li adan sé liv-la Moziz té ékwi-a koté i palé konsèné wazyé-a ki té ka bwilé-a. Bondyé di kon sa, ‘Sé mwen ki Bondyé-a Abrahanm, Ayzak épi Jakòb ka adowé-a.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Bondyé sé pa Bondyé jan ki ja mò, mé moun ki ka viv toujou. Ou wè! Zòt adan an chay lèwè.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Yonn adan sé titja lwa sé Jwif-la té la épi i tann Jézi épi sé Sadisyen-an té ka chikannen. I wè Jézi té ja bay sé Sadisyen-an an bon wépons, kon sa i menm vini épi an kwèsyon pou i sa mandé Jézi. I di Jézi, “An tout sé konmandman-an, kilès ki pli enpòtan?” ");
INSERT INTO acfNT_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Jézi wéponn li, “Konmandman-an ki pli enpòtan-an sé sa, ‘Kouté, jan Izwayèl! Bondyé Senyè nou, sé li yonn ki Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ou oblijé enmen Bondyé Senyèʼw épi tout tjèʼw, épi tout lam ou, épi tout lidéʼw épi èk tout kouway ou.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Apwé sa lòt konmandman-an ki pli enpòtan-an sé sa, ‘Ou oblijé enmen pwochenʼw menm kon ou enmen kòʼw.’ Pyès lòt konmandman pa enpòtan pasé dé sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Titja lwa sé Jwif-la di Jézi, “Byen, mèt. Sa ou di-a vwé, kon sa sé Senyè-a sèlman ki Bondyé, épi la pa ni pyès lòt Bondyé mé sé li yonn. ");
INSERT INTO acfNT_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","An nonm oblijé enmen Bondyé épi tout tjèʼy, èk épi tout lidéʼy, èk épi tout kouway li, èk i oblijé enmen pwochenʼy kon li menm. I pli mèyè pou ou sa obéyi dé konmandman sala pasé pou ou ofè zannimo ében fè lòt sakwifis bay Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jézi apèsivwè mannyè titja lwa sé Jwif-la wéponn li épi lasajès, épi i diʼy kon sa, “Ou ja pwèskè an chimen-an ki kay mennenʼw anba kondwit Bondyé-a.” Apwé sa tout moun té pè mandéʼy kwèsyon ankò. ");
INSERT INTO acfNT_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Kon Jézi té ka enstwi adan Kay Bondyé-a, i mandé yo kwèsyon sala, “Ki mannyè sé titja lwa sé Jwif-la sa di Mèsaya-a kay an désandan Wa David? ");
INSERT INTO acfNT_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Lèspwi Bondyé té annékòz Wa David pou di, ‘Bondyé di bay Senyè mwen: Asid la pou kondwi épi mwen èk mwen kay mété tout lèlmiʼw anba dé pyéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Mi, David menm kwiyé moun sala ‘Senyè mwen’. Di mwen, ki mannyè yo sa di ki i sé désandan David tousèl?” Gwan konpanni moun-an ki té la-a té byen kontan pou yo té sa tann li. ");
INSERT INTO acfNT_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Kon Jézi enstwi sé moun-an i di, “Véyé pou sé titja lwa sé Jwif-la, paski yo vlé moun wè yo kon jan ki enpòtan. Épi pou yo jwenn antansyon, yo ka maché oliwon épi lonng gòl yo, épi yo enmen moun adwésé yo épi wèspé lè yo alé laplas. ");
INSERT INTO acfNT_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Yo enmen asid jik douvan adan sé légliz-la koté moun kay wè yo, épi lè yo alé an fèsten, yo enmen asid anpami sé gwan jan-an. ");
INSERT INTO acfNT_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Yo ka pwan lavantay asou sé vèv-la. Yo ka sèvi pozisyon yo an légliz-la pou fè sé madanm sala pasé kay yo ében tout byen yo asou non yo. Épi kon an gwo wach yo ka fè an chay lonng lapwiyè. Pinisyon sé kalité nonm sala kay byen wèd.” ");
INSERT INTO acfNT_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jézi té asid pwé koté sé moun-an té ka mété lajan latjèt-la adan Kay Bondyé-a. Épi i té ka gadé kon sé moun wich-la té ka ladjé lajan-an an bwèt-la. An chay sé jan-an ki té wich-la mété an bon lavi. ");
INSERT INTO acfNT_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Mé an ti madanm maléwèz, mawiʼy té ja mò, vini épi i ladjé dé pyès lajan tjwiv lavalè kat sou adan bwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Jézi kwiyé sé disip li-a ansanm épi i di yo, “Mwen ka di zòt lavéwité, vèv sala mété pli adan latjèt-la pasé tout lézòt. ");
INSERT INTO acfNT_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Paski sé lézòt-la mété an tizing an tout sé wichès-la yo ni-an, mé madanm sala, magwé i otan pòv, i mété tout sa i té ni. I pa té wèsté pyès lajan i té sa dépan asou ankò.” ");
INSERT INTO acfNT_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Kon Jézi té ka kité Kay Bondyé-a, yonn an sé disip li-a diʼy kon sa, “Mèt, gadé sé manman wòch-la Kay Bondyé-a fèt épiʼy-la! Mésyé! Kay sala sé an gwo bèl kay!” ");
INSERT INTO acfNT_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jézi wéponn li, “Ou wè sé gwo bèl kay sala? La pa kay ni yon wòch ki kay wèsté doubout, paski kay sala kay kwazé nèt.” ");
INSERT INTO acfNT_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Kon Jézi asid asou Mòn Òliv-la, fasad-la ki ka gadé Kay Bondyé-a, Pita, Jémz, Jan épi Androu, lè yo té pa kò yo, yo mandé Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Di nou ki tan sé bagay sala kay fèt? Épi ki kalité bagay nou kay wè ki kay di nou i ja tou pwé fèt?” ");
INSERT INTO acfNT_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jézi di yo, “Pwan pokosyon pou pyèsonn pa kwennenʼw, ");
INSERT INTO acfNT_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","paski an chay moun kay vini sèvi non mwen épi yo kay di sé yo ki Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a, épi yo kay kwennen an chay moun. ");
INSERT INTO acfNT_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Ou kay tann ladjè ka alé tou pwéʼw épi ou kay tann osi konsèné ladjè ki ka pwan kou byen lwenʼw. Pa kité sa twoubléʼw. Sé kalité bagay sala ni pou fèt. Mé latè-a pʼòkò kay bout. ");
INSERT INTO acfNT_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Nasyon kay lévé goumen épi yonn a lòt épi péyi kay lévé ladjè kont lòt péyi. La kay ni twanblanntè adan diféwan plas épi la kay ni lafen. Mé sa pʼòkò anyen. Sa sé koumansman soufwans tousèl. ");
INSERT INTO acfNT_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mé zòt menm pwan bon pokosyon, paski sé lèlmi zòt-la kay awété zòt épi yo kay mennen zòt lodyans. Yo kay bat zòt adan sé légliz sé Jwif-la. Zòt kay doubout douvan gouvènè épi wa pou lapéti mwen, pou zòt sa di yo Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Avan bout-la vini Bon Nouvèl-la kay ni pou pwéché bay tout moun. ");
INSERT INTO acfNT_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Lè yo awété zòt épi yo mennen zòt lodyans, pa katjilé avan jou-a wivé ki sa zòt kay di. Lè jou-a wivé, di népòt bagay Bondyé bay zòt pou zòt sa di, paski sé pawòl-la ou kay palé-a sé pa pawòl ou menm. Sé Lèspwi Bondyé ki kay di zòt ki pawòl pou zòt sa palé. ");
INSERT INTO acfNT_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“An fwè kay twayi an lòt fwè jis tan fwè-a jwenn lanmòʼy pou lapéti mwen. Papa-a kay fè ich-la menm bagay-la. Manmay kay lévé kont manman yo épi papa yo, épi yo kay annékòz lanmò yo osi. ");
INSERT INTO acfNT_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Tout nonm kay hayi zòt pou lapéti mwen Jézi, mé moun-an ki swiv mwen-an jis tan i mò-a, Bondyé kay sovéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Ou kay wè bagay-la Bondyé hayi pasé tout lòt bagay-la doubout an Kay Bondyé-a Jérouzalèm, épi sa kay annékòz Bondyé pou abandonnen kay-la yo fè ba li-a.” (Ou kay ni pou ni lasajès pou ou sa konpwann sa ki ékwi-a.) “Épi kité sé moun-an ki ka wèsté Joudiya-a kouwi mouté an sé mòn-an pou sové lavi yo. ");
INSERT INTO acfNT_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Lè moun-an ki asou tèt kay-la désann li, i pa sipozé antwé andidan kay-la ében pou i sa pwan anyen andidanʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kité nonm-lan ki ka twavay an jaden-an pa menm viwé an kay-la pou pwan had li. ");
INSERT INTO acfNT_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","I kay twis an chay an tan sala pou sé madanm-lan ki ansent-lan ében sa ki ni ti manmay. ");
INSERT INTO acfNT_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Pwédyé pou sa pa fèt an sézon mové tan-an, ");
INSERT INTO acfNT_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","paski an sé jou sala la kay ni an chay twibilasyon, plis pasé pyès tan dépi Bondyé fè latè sala jik an tan kon jòdi. Épi i pa kay janmen ni an tan kon sa ankò. ");
INSERT INTO acfNT_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Épi si Bondyé pa té koupé asou sé jou twibilasyon sala, pyèsonn pa té kay sové. Mé pou lapéti sé moun-an Jézi ja chwazi pou sové-a, i kay koupé asou sé jou sala. ");
INSERT INTO acfNT_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","An tan sala si pyèsonn diʼw kon sa, ‘Mi Mèsaya-a, wa-a Bondyé té fè pwonmèt pou voyé-a,’ ében si yo diʼw, ‘Gadé! Mi li isi-a!’ sé pa pou ou kwè sa. ");
INSERT INTO acfNT_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Paski i kay ni an chay moun ki di yo sé Mèsaya-a épi an chay fo pwòfèt ki kay pawèt, épi yo kay fè tèlman miwak épi lòt bagay kon sa, si i té posib yo té kay kwennen jik sé moun-an Bondyé ja chwazi pou sové-a. ");
INSERT INTO acfNT_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kon sa pwan bon pokosyon. Mwen ja di zòt tout bagay ki kay fèt avan i fèt. ");
INSERT INTO acfNT_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Mé an tan sala, apwé twibilasyon sala, sòlèy-la pa kay chofé ankò épi lalin-an pa kay kléwé kon avan, ");
INSERT INTO acfNT_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","sé étwal-la kay tonbé sòti an syèl-la, anfen Bondyé kay fè tout bagay ki an syèl anho-a pou chanjé plas. ");
INSERT INTO acfNT_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","An tan sala, sé moun-an kay wè mwen, Gason Lézòm, ka vini adan sé nwaj-la épi an chay pouvwa épi an tout klèté Papa mwen. ");
INSERT INTO acfNT_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Épi Bondyé kay voyé sé nanj li-a an kat kwen latè-a pou yo sa asanblé tout sé moun-an ki ja chwazi pou sové-a, dépi an bout latè-a pou wivé an bout syèl. ");
INSERT INTO acfNT_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Mwen vlé ou gadé an pyé fwi épi apwann lison sala. Dépi pyé fwi-a koumansé fléwi, pyèsonn pa ni pou di zòt ki sézon ki ka vini. ");
INSERT INTO acfNT_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ében menm mannyè-a, lè ou wè sé bagay sala ka fèt, sav bout latè-a pwé épi i kay koumansé touswit. ");
INSERT INTO acfNT_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Mwen ka diʼw lavéwité, tout sé moun sala ki ka viv apwézan-an pa kay mò tout tan sé bagay sala pʼòkò fèt. ");
INSERT INTO acfNT_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Latè sala épi syèl-la ou ka wè-a kay fini anyen, mé pawòl mwen pa kay janmen fini.” ");
INSERT INTO acfNT_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Mé pyèsonn pa sav ni jou-a ében lè-a sé bagay sala kay fèt-la. Sé nanj an syèl-la pa sav, ni mwen Gason-an, mé sé Papa mwen tousèl ki sav. ");
INSERT INTO acfNT_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Pwan bon pokosyon épi kontiné èspéyé, paski zòt pa sav lè jou-a kay vini. ");
INSERT INTO acfNT_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","I sé menm kon an nonm ki kay alé lòt péyi. I kité kay li asou kont sé sèvant-lan. I bay chak sèvant twavay yo pou yo fè, épi gad lapòt-la, i diʼy pou véyé. ");
INSERT INTO acfNT_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kon sa zòt tout ni pou véyé paski zòt pa sav ki jou mèt kay-la ka viwé, si i kay viwé li swè, ében lannwit, ében lè kòk chanté, ében lè jou ouvè. ");
INSERT INTO acfNT_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Si i vini sibit, pa kitéʼy jwenn zòt ka dòmi. ");
INSERT INTO acfNT_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Sa mwen ka di bay zòt sé sa mwen kay di bay tout moun: Kontiné véyé!” ");
INSERT INTO acfNT_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Bon, Fèt Délivwans-lan épi fèt-la lè sé Jwif-la té ka manjé pen san lèlven té an dé jou ankò épi sé chèf pwèt-la épi sé titja lwa sé Jwif-la té ka aché an mannyè pou awété Jézi san pyèsonn sav. Yo té vlé wèʼy mò. ");
INSERT INTO acfNT_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Mé yo di, “Nou pa pou fè sa an tan fèt-la, avan sa lévé dézagwéman anpami sé moun-an.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jézi té an vil Bèfanni épi i té asid ka manjé lakay an nonm yo ka kwiyé Simon, nonm-lan moun té konnèt kon ‘Simon maladi lapo-a’. Patan Jézi té ka manjé-a, an madanm vini épi an bèl ti boutèy ki té fèt épi an kalité wòch kwiyé ‘alabasta’. Adan boutèy sala té ni an ti losyon ki té ni an fò lòdè, épi losyon sala té byen chè. Madanm-lan kasé boutèy-la épi i vidé losyon-an asou tèt Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Adan sé moun-an ki té la-a té byen faché épi yo di bay yonn a lòt, “Pouki pou i gaspiyé losyon sala? ");
INSERT INTO acfNT_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nou té sa vann losyon sala byen chè épi lajan-an nou té sa bay sé maléwé-a.” Kon sa yo bay madanm-lan sa ki ka vini pou li. ");
INSERT INTO acfNT_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Jézi di yo kon sa, “Kité madanm-lan bat mizèʼy. Pouki pou zòt anbétéʼy kon sa? Sa i ja fè ban mwen-an bon an chay. ");
INSERT INTO acfNT_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Zòt kay toujou ni maléwé anpami zòt, épi népòt lè zòt vlé, zòt sa édé yo. Mé mwen pa kay la épi zòt tout lè. ");
INSERT INTO acfNT_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Madanm-lan fè sa i té sa fè ban mwen. I vidé losyon asou kò mwen pou pwépawé mwen byen avan lè-a yo kay téwé mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Mwen ka di zòt lavéwité, pyès koté Bon Nouvèl-la kay pwéché oliwon latè sala, moun kay toujou chonjé madanm sala pou sa i fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Apwé sa Jida Iskariyòt, yonn adan sé douz zapòt-la, alé oti sé chèf pwèt-la pou i té sa twayi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Lè sé chèf pwèt-la tann sa, yo té kontan an chay pou tann sa Jida té ni pou di-a, épi yo pwonmèt pou ba li lajan. Kon sa Jida té ka gadé ki lè ki té kay pli bon pou i té sa fè sa. ");
INSERT INTO acfNT_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Asou pwèmyé jou-a sé Jwif-la té ka manjé pen ki fèt san lèlven, jou-a yo ka tjwé ti mouton pou yo sa manjé an fèt-la, sé disip-la mandé Jézi, “Ki koté ou vlé nou alé pou nou sa pwépawé wipa Fèt Délivwans-lan baʼw?” ");
INSERT INTO acfNT_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Kon sa Jézi voyé dé an sé disip li-a épi i di yo, “Désann an vil Jérouzalèm épi zòt kay jwenn an nonm ki ka pòté an jè dlo. Swiv li, ");
INSERT INTO acfNT_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","épi an kay-la i antwé-a di mèt kay-la, ‘Mèt-la voyé mandéʼw pou chanm-lan koté li épi sé disip li-a kay manjé wipa Fèt Délivwans-lan.’ ");
INSERT INTO acfNT_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Épi i kay moutwé zòt an gwan chanm anhogwiyen-an ki ja ni tout bagay adanʼy. La ou kay fè pwépawasyon ban nou.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Sé disip-la alé épi yo désann an vil Jérouzalèm épi tout bagay fèt menm kon Jézi té di yo. Épi yo fè pwépawasyon pou Fèt Délivwans-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Lè sòlèy kouché, Jézi wivé épi sé douz disip-la. ");
INSERT INTO acfNT_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Patan yo asid la ka manjé-a, Jézi di, “Mwen ka di lavéwité, yonn adan zòt kay twayi mwen. Sa sé yonn adan zòt ki la ka manjé épi mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Fidji sé disip-la tonbé lè yo tann sa, épi yonn vini épi i di, “Sé pa mwen, kouman!” An lòt di, “Mwen pa kay fè sa, kouman!” jis tan yo tout mandéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jézi wéponn, “I kay yonn adan zòt douz-la ki la-a ki ka sosé pen adan bòl sòs-la épi mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Mwen, Gason Lézòm, kay mò menm kon i ékwi an lévanjil konsèné mwen. Mé ki mizi téwib i kay téwib pou nonm sala ki twayi mwen, Gason Lézòm-lan! I té kay pli mèyè pou li si i pa té janmen vini an latè sala.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Patan yo té ka manjé-a Jézi pwan an pen. Lè i wimèsyé Bondyé i kasé pen-an épi i bay sé disip li-a adanʼy épi i di, “Pwanʼy. Sa sé kò mwen.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Apwé sa i pwan pòt-la, i wimèsyé Bondyé épi i bay sé disip li-a épi yo tout bwè adanʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","I di yo kon sa, “Sa sé san mwen ki kay koulé bay an chay moun. San sala kay kachté agwéman-an Bondyé fè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Mwen ka diʼw lavéwité, mwen pa kay bwè diven ankò anba lè kondwit Bondyé koumansé. La mwen kay bwè an diféwan kalité diven.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Apwé yo chanté an chanté pou wimèsyé Bondyé yo kité plas-la yo té yé-a épi yo alé asou Mòn Òliv. ");
INSERT INTO acfNT_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Jézi di sé disip li-a, “Zòt tout kay pèd konfyans an mwen épi zòt kay abandonnen mwen menm kon i ékwi an lévanjil: ‘Bondyé kay tjwé bèwjé-a épi tout sé mouton-an kay simen.’ ");
INSERT INTO acfNT_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Mé apwé mwen wésisité hòd lanmò mwen kay alé Galili avan zòt.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Pita wéponn épi i di, “Menm si tout lèstan pèd konfyans adanʼw épi abandonnenʼw, mwen pa kay fè sa.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Jézi wéponn, “Mwen ka diʼw lavéwité, ou Pita, jòdi-a anfen òswè-a menm, avan sé kòk-la chanté dé fwa, ou menm kay di ou pa konnèt mwen twa fwa.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Mé Pita wéponn Jézi épi an asiwans épi i di, “Menm si mwen ni pou mò épiʼw, mwen pa kay janmen pèd konfyans an ou pou mwen sa abandonnenʼw.” Épi tout lèstan di menm bagay-la. ");
INSERT INTO acfNT_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jézi épi sé disip li-a wivé jaden-an yo ka kwiyé Gèfsèmanni-an épi i di sé disip li-a, “Asid la patan mwen ka pwédyé.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Apwé, i pwan Pita, Jémz épi Jan épi i mennen yo alé épiʼy épi i koumansé santi an penn an tjèʼy ki té ka fèʼy soufè an chay. ");
INSERT INTO acfNT_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Épi i di yo, “An véwité penn sala ki an tjè mwen-an téwib tèlman, i pawé pou tjwé mwen. Wèsté isi-a épi pa alé dòmi.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","I alé douvan an ti distans épi i jété kòʼy a tè-a fas anba épi i pwédyé épi i mandé Papaʼy si i té posib pou pa kitéʼy pasé tan soufwans sala. ");
INSERT INTO acfNT_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","I di, “Papa mwen, tout bagay posib épiʼw. Tiwé pòt soufwans sala douvan mwen. Kanmenm sé pa sa mwen vlé fè, mé pito sé sa ou vlé pou ou fè.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Lè i viwé i jwenn twa-a ki té alé épiʼy-la ka dòmi épi i di Pita, “Simon! Ès si ou ka dòmi? Ou pa té sa menm véyé pou yon nèditan?” ");
INSERT INTO acfNT_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Épi i di yo, “Pa kité sonmèy pwan zòt. Pwédyé pou zòt pa tonbé anba tantasyon. Lèspwi zòt vlé fè sa ki dwèt mé lachè zòt fèb.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Épi Jézi viwé yon fwa ankò pou i pwédyé épi i di menm lapwiyè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Lè i viwé koté sé disip-la té yé-a, i jwenn yo ka dòmi ankò. Yo pa té sa tjenn zyé yo ouvè. Yo pa té sav ki sa pou yo té sa di Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Lè i sòti pwédyé twazyenm fwa-a, i di yo, “Zòt ka dòmi épi pozé toujou? Sa asé! Tan-an ja wivé pou yo ladjé mwen, Gason Lézòm, anba pouvwa sé mové nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Lévé, annou alé. Ou wè! Nonm-lan ki twayi mwen-an ja wivé.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jézi pʼòkò té menm fini palé lè Jida, yonn an sé douz disip-la, wivé. Jida té ni an bon déotwa moun épiʼy, épi yo té ni sab épi boutou lanmen yo. Sé chèf pwèt-la, sé titja lwa sé Jwif-la épi sé ofisyé-a an légliz sé Jwif-la ki té voyé konpanni moun sala. ");
INSERT INTO acfNT_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Bon, avan yo té pati Jida té ja di yo, “Nonm-lan mwen kay bo-a, sé li zòt vlé. Awétéʼy, épi pwan pokosyon patan zòt ka mennenʼy alé.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Kon Jida wivé, i vini douvan Jézi épi i di, “Mèt!” épi i bo Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Sé moun-an vini épi yo tjenbé Jézi épi yo awétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Mé yonn an sé nonm-lan ki té doubout la épi Jézi-a hédi sab li épi i fwapé sèvant pli ho chèf an sé pwèt-la épi i volé zòwèy li. ");
INSERT INTO acfNT_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Jézi di yo, “Ès si zòt té ni pou vini épi sab épi boutou pou zòt sa awété mwen akwèdi mwen sé an vòlè? ");
INSERT INTO acfNT_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Pou otan jou mwen té épi zòt ka enstwi an Kay Bondyé-a, épi zòt pa awété mwen. Mé sa lévanjil-la di kay fèt oblijé fèt pou vwé.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Apwé sa tout sé disip Jézi-a abandonnenʼy épi chapé kò yo. ");
INSERT INTO acfNT_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","La té ni an jenn nonm ki té abiyé épi an had kon an dwa voplé oliwonʼy, épi i té alé épi Jézi lè yo té awétéʼy-la. Sé moun-an té éséyé pou yo té awétéʼy osi, ");
INSERT INTO acfNT_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","mé i pitjé kouwi épi i kité had li dèyè. ");
INSERT INTO acfNT_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Yo mennen Jézi douvan pli ho chèf an sé pwèt-la, épi tout lézòt sé chèf pwèt-la, sé ofisyé an légliz sé Jwif-la épi sé titja lwa sé Jwif-la vini ansanm. ");
INSERT INTO acfNT_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pita té ka maché adan an distans dèyè Jézi épi i antwé jis andidan lakou kay pli ho chèf an sé pwèt-la. La Pita asid épi sé sòlda-a épi i té ka chofé kòʼy bo difé-a. ");
INSERT INTO acfNT_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Sé chèf pwèt-la épi tout sé manm konsèy sé Jwif-la té ka gadé pou témwen pou yo té sa sèvi kont Jézi, paski yo té vlé kondannéʼy pou i mò. Mé yo pa té sa jwenn pyès. ");
INSERT INTO acfNT_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","An chay sé témwen-an té ka manti asou Jézi épi tout sé listwa-a yo bay-la té diféwan. ");
INSERT INTO acfNT_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","An lè déotwa nonm doubout épi yo di mansonj sala asou Jézi, ");
INSERT INTO acfNT_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","yo di, “Nou tann i di, ‘Mwen kay kwazé Kay Bondyé sala, sa nonm fè-a, épi apwé twa jou mwen kay fè an lòt. Mé sé pa nonm ki kay fè kay sala.’ ” ");
INSERT INTO acfNT_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Mé pa menm listwa sé sala ki té ka dakò épi sa yonn a lòt té di. ");
INSERT INTO acfNT_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Pli ho chèf an sé pwèt-la doubout douvan tout sé manm konsèy-la épi i kwèsyonnen Jézi, i di, “Yo ja akizéʼw épi an chay bagay. Ès si ou ni pyès wépons pou bay?” ");
INSERT INTO acfNT_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Mé Jézi wèsté tou dous épi i pa di yon mo pawòl. Pli ho chèf an sé pwèt-la mandéʼy ankò, “Ès si ou sé Mèsaya-a, Gason Bondyé-a?” ");
INSERT INTO acfNT_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jézi wéponn, “Wi, mwen sé li, épi ou kay wè mwen Gason Lézòm asid asou lanmen dwèt Bondyé ki ni tout pouvwa, épi mwen kay vini adan nwaj syèl.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Pli ho chèf an sé pwèt-la té tèlman faché, i déchiwé had li menm épi i di, “Nou pa bizwen pyès témwen ankò! ");
INSERT INTO acfNT_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Zòt tann mannyè i ensilté Bondyé! Ki disizyon zòt?” Yo tout di i koupab épi i bizwen mò. ");
INSERT INTO acfNT_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Lè sala déotwa nonm koumansé kwaché asou Jézi, épi yo mawé an mòso had oliwon zyéʼy, yo fwapéʼy épi koulpwen yo épi yo di, “Di nou kilès ki baʼw sé koulpwen sala?” Épi sé sòlda-a pwanʼy épi yo bat li. ");
INSERT INTO acfNT_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Patan Pita té anba-a, an lakou kay pli ho chèf an sé pwèt-la, yonn adan sé sèvant li-a, an jenn ti fi, vini la. ");
INSERT INTO acfNT_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Lè i wè Pita ka chofé kòʼy la, i véyéʼy byen épi i diʼy, “Ou menm té épi Jézi sala, jan Nazawèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Mé Pita di sa pa vwé épi i di, “Mwen pa ni sav ni konpwann ki sa ou ka palé konsèné-a,” épi i pati an pasay-la ki ka alé bò bayè-a. ");
INSERT INTO acfNT_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Lè menm sèvant-lan wè Pita la toujou i koumansé ka di bay sé moun-an ki té la-a, “I sé yonn adan yo!” ");
INSERT INTO acfNT_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ankò Pita di sa pa vwé. An ti mouman apwé sa, menm sé moun-an ki té la-a koumansé di Pita, “Vwéman ou sé yonn adan yo paski ou sé jan Galili.” ");
INSERT INTO acfNT_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Pita fè sèman, épi i di, “Vonmyé Bondyé pini mwen apwézan, mwen ka palé lavéwité! Mwen pa konnèt nonm-lan ou ka palé konsèné-a!” ");
INSERT INTO acfNT_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","La menm kòk-la chanté dézyenm fwa-a épi Pita chonjé pawòl-la Jézi té diʼy-la: “Avan kòk-la chanté dé fwa, ou kay di ou pa konnèt mwen pou twa fwa.” Épi sa kwazé tjèʼy, épi i hélé épi i an penn. ");
INSERT INTO acfNT_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Byen bonnè li bonmaten, sé chèf pwèt-la épi sé ofisyé an légliz sé Jwif-la, sé titja lwa sé Jwif-la épi tout lèstan sé manm konsèy sé Jwif-la wivé an disizyon asou ki sa pou fè épi Jézi. Yo mawé Jézi épi yo mennenʼy alé épi yo délivwéʼy an lanmen Pons Pilat, gouvènè-a ki ka wépwézanté péyi Ronm-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilat mandéʼy, “Ès si ou sé wa sé Jwif-la?” Jézi wéponn, “Kon ou di.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Sé chèf pwèt-la akizéʼy épi an chay bagay. ");
INSERT INTO acfNT_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Kon sa Pilat mandéʼy ankò, “Yo ja akizéʼw épi an chay bagay. Ès si ou pa ka bay pyès wépons?” ");
INSERT INTO acfNT_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ankò Jézi pa wéponn anyen, épi Pilat té byen sipwi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Bon, toulé lanné asou jou sé Jwif-la té ka sélébwé Fèt Délivwans-lan, kon lakoutim Pilat té ka ladjé yonn adan sé Jwif-la ki té an pwizon-an, népòt-la sé moun-an té mandé pou. ");
INSERT INTO acfNT_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Menm tan sala, la té ni an nonm yo ka kwiyé Barabas ki té an pwizon épi lèstan sé moun-an ki té lévé wévòt kont gouvèdman-an épi yo té tjwé moun patan yo té ka goumen-an. ");
INSERT INTO acfNT_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sé moun-an vini ansanm épi yo di Pilat pou fè sa i ka toujou fè ba yo toulé lanné an tan sala. ");
INSERT INTO acfNT_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilat mandé yo, “Ès si zòt vlé mwen ladjé wa sé Jwif-la?” ");
INSERT INTO acfNT_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilat té sav byen sé jalouzi ki té fè sé chèf-la mennen Jézi ba li. ");
INSERT INTO acfNT_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Mé sé chèf pwèt-la pitjé sé moun-an pou yo mandé Pilat pou ladjé Barabas pito. ");
INSERT INTO acfNT_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Pilat mandé sé moun-an, “Ében, ki sa zòt vlé mwen fè épi moun sala zòt ka kwiyé wa sé Jwif-la?” ");
INSERT INTO acfNT_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Yo tout andjélé, “Kwisifyéʼy pou mò asou kwa-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Pilat mandé, “Mé ki movèzté i ja fè?” Sé moun-an andjélé pli fò ankò, “Klouwéʼy pou i mò asou kwa-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilat té vlé plè sé moun-an, kon sa i ladjé Barabas kon yo té mandé. Épi i fè sé sòlda-a bay Jézi an mové chalè, épi apwé sa yo mennenʼy alé pou yo té sa kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Sé sòlda-a pwan Jézi épi yo mennenʼy alé adan kay gouvènè-a (sa yo ka kwiyé Pratoriyòm-lan) épi yo kwiyé tout lèstan sé sòlda-a ki té an menm konpanni épi yo-a. ");
INSERT INTO acfNT_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Yo mété an lonng gòl lila asou Jézi épi yo naté an konmès bwanch pikan kon an kouwonn épi yo plaséʼy asou tèt li. ");
INSERT INTO acfNT_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Yo koumansé ka motjéʼy épi yo té ka andjélé, “Viv, wa sé Jwif-la!” ");
INSERT INTO acfNT_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Épi kon an plézi yo té ka ba li koul baton asou tèt li épi yo té ka kwaché asouʼy, épi yo tonbé asou jounou yo pou fè akwèdi yo ka adowéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Épi lè yo fini motjéʼy, yo tiwé lonng gòl lila-a asouʼy épi yo viwé mété menm had-la i té ni-an asouʼy ankò. Apwé sa yo mennenʼy alé pou yo té sa kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Patan yo té ka alé-a, yo jwenn épi an nonm yo ka kwiyé Simon, ki té sòti an hòtè épi i té ka vini an vil, épi sé sòlda-a oblijéʼy pòté kwa Jézi-a. (Simon sala té jan Sayrini, papa Alèkzanda épi Roufòs.) ");
INSERT INTO acfNT_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Yo mennen Jézi an plas-la yo ka kwiyé Gòlgòfa, sa vlé di, ‘Mòn Kalòt Tèt’. ");
INSERT INTO acfNT_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","La yo ofèʼy diven ki té ni an wazyé yo ka kwiyé lanmi andidanʼy, mé Jézi pa té bwèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Apwé sa yo kwisifyéʼy. Épi pou yo té sa sépawé had li, yo jwé gwenndé pou yo wè kilès mòso yonn a lòt té kay jwenn. ");
INSERT INTO acfNT_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","I té névè li bonmaten lè yo té kwisifyé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Épi yo matjé asou an papyé wézon-an yo kwisifyéʼy-la pou tout moun wè, i di, “Wa Sé Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Yo té kwisifyé dé vòlè épiʼy, yonn asou koté dwèt li, épi lòt-la asou koté gòch li.  ");
INSERT INTO acfNT_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Mannyè sala sa lévanjil-la té di kay fèt-la fèt pou vwé, lè i di, “I té anpami mové nonm.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Sé moun-an ki té ka pasé-a té ka fè sin épi tèt yo kon yo té ka ensilté Jézi, yo di, “Mé wi, ou té kay kwazé Kay Bondyé-a épi adan twa jou ou té kay viwé fèʼy, kouman? ");
INSERT INTO acfNT_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Ében désann asou kwa-a épi sové kòʼw.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","An menm mannyè-a, sé chèf pwèt-la épi sé titja lwa sé Jwif-la té ka motjéʼy, épi yo té ka di bay yonn a lòt, “I sové lézòt mé i pa sa sové kòʼy menm. ");
INSERT INTO acfNT_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Kité Mèsaya-a, wa Izwayèl-la, désann asou kwa-a apwézan pou nou sa wè épi nou kay kwè.” Dé vòlè-a yo té kwisifyé épiʼy-la té ka ensiltéʼy osi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","A midi tout péyi-a té kouvè épi an nwèsè épi i diwé pou jis twazè apwémidi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Épi lè i té twazè, Jézi hélé épi an gwo vwa, “Eloi, Eloi, lama sabachthani?” Sa vlé di, “Bondyé mwen! Bondyé mwen! Pou ki wézon ou ka abandonnen mwen?” ");
INSERT INTO acfNT_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Lè adan an sé moun-an ki té doubout la-a tann sa, yo di, “Tann sa, i ka kwiyé Ilaydja.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","An nonm kouwi épi i twanpé an léponj adan diven wak, épi i mété léponj-lan asou an bout an baton. Apwé sa i lonjéʼy bay Jézi pou i té sa bwè. Épi nonm-lan di, “Bon, doubout la, annou gadé si Ilaydja kay vini tiwéʼy asou kwa-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Épi Jézi hélé épi an gwo vwa, épi i pwan dènyé lisouf li. ");
INSERT INTO acfNT_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Wido-a ki té an Kay Bondyé-a déchiwé an dé, dépi an tèt li pou wivé an bout li. ");
INSERT INTO acfNT_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Épi lè chèf sòlda-a ki té doubout douvan Jézi-a tann mannyè i hélé, épi lè i wè mannyè i mò, i di, “Pou vwé, nonm sala sé Gason Bondyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","La té ni déotwa madanm ki té adan an distans ka gadé. Anpami yo té Mari Madlenn, Mari manman Jémz (sa yo ka kwiyé ti Jémz) épi Joziz, épi Salonmé té la osi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Sé madanm sala té ka swiv Jézi patan i té an Galili épi yo té ka potjiwé tout sa i té bizwen. La té ni an chay lézòt madanm ki té vini Jérouzalèm épi Jézi ki té la osi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Bon, i té jou-a avan jou sabaf-la, sa sé jou-a sé Jwif-la té ka fè pwépawasyon pou jou sabaf-la. I té ja apwémidi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","La té ni an nonm yo ka kwiyé Jozèf, an Jwif ki té sòti an vil Arimatéya. I té an manm an konsit sé Jwif-la tout moun té ka wèspèkté an chay. Épi i té ka èspéyé pou tan-an Bondyé menm kay kondwi-a vini. I pwan tjè épi i alé mandé Pilat pou kò Jézi. ");
INSERT INTO acfNT_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Pilat té sipwi lè i tann Jézi té ja mò, kon sa i kwiyé chèf sòlda-a pou i té sa mandéʼy si sa té vwé. ");
INSERT INTO acfNT_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Lè chèf sòlda-a diʼy Jézi té ja mò pou vwé, Pilat bay Jozèf pèwmi pou i té sa pwan kò mò-a. ");
INSERT INTO acfNT_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Kon sa Jozèf achté an dwa blan, i dépann kò Jézi asou kwa-a, épi i voplé kò-a adan dwa-a, épi i téwéʼy adan an twou yo té fouyé adan kayè an mòn-an. Apwé, i woulé an gwo manman wòch asou djòl twou-a pou i té sa kouvèʼy. ");
INSERT INTO acfNT_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mari Madlenn épi Mari manman Joziz wè an kilès twou yo té plasé kò Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Kon jou sabaf-la té pasé, Mari Madlenn, Salonmé épi Mari manman Jémz té achté fiksyon pou yo té sa fwoté kò mò Jézi-a kon yo té ni labitid fè moun ki mò. ");
INSERT INTO acfNT_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Bon, byen bonnè Dimanch bonmaten kon sòlèy-la lévé, yo alé koté-a Jézi té téwé-a. ");
INSERT INTO acfNT_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Yo té ka di anpami yo menm, “Ki moun ki kay woulé wòch-la sòti asou djòl twou-a ban nou?” ");
INSERT INTO acfNT_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mé lè yo lévé zyé yo, yo wè gwo wòch-la té ja woulé sòti asou djòl twou-a. ");
INSERT INTO acfNT_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Kon yo antwé an twou-a yo wè an jenn nonm ki abiyé épi an gòl blan asid asou lanmen dwèt yo, épi yo soté tèlman. ");
INSERT INTO acfNT_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Jenn nonm-lan di yo, “Pa pou zòt soté. Zòt ka gadé pou Jézi jan Nazawèt-la, sa yo té kwisifyé-a. I ja wésisité. I pa isi-a. Gadé koté-a yo té plaséʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Mé alé di Pita épi sé lézòt disip-la i ka alé Galili avan yo. La zòt kay wèʼy menm kon i té di zòt-la.” ");
INSERT INTO acfNT_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Kon sa yo kité plas-la Jézi té téwé-a épi yo kouwi. Yo té soté an chay, épi an pèwèz vini andidan yo. Yo pa di yon mò pawòl bay pyèsonn paski yo té tèlman pè.  ");
INSERT INTO acfNT_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Apwé Jézi wésisité hòd lanmò bonnè Dimanch bonmaten, i pawèt douvan Mari Madlenn, sa sé menm sa Jézi té tiwé sèt vyé lèspwi-a andidanʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Mari Madlenn alé épi i pòté nouvèl-la bay sé sa ki té ka swiv Jézi-a. Yo té an penn kon Jézi té mò, ");
INSERT INTO acfNT_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","mé lè yo tann Jézi té ka viv ankò épi Mari Madlenn té ja wèʼy, yo pa té kwè sa. ");
INSERT INTO acfNT_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Apwé sa, kon yo dé té ka maché an hòtè-a, Jézi pawèt douvan yo mé lapawans li té chanjé. ");
INSERT INTO acfNT_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Yo viwé épi yo mennen nouvèl-la bay sé lézòt-la, mé sé lézòt-la pa té kwè yo nonplis. ");
INSERT INTO acfNT_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Pli ta Jézi pawèt douvan sé wonz zapòt-la patan yo té ka manjé-a. I wipwoché yo paski yo pa té ni asé lafwa an li épi pou lapéti tjè wèd yo-a ki anpéché yo kwè sé moun-an ki té ja wèʼy apwé i té wésisité-a. ");
INSERT INTO acfNT_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","I di yo kon sa, “Alé an tout latè-a épi pwéché Bon Nouvèl-la bay tout lézòm. ");
INSERT INTO acfNT_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Népòt-la ki kwè Bon Nouvèl-la épi i batizé kay jwenn lavi étonnèl, mé sé sa ki pa kwè Bon Nouvèl-la kay jwenn kondannasyon. ");
INSERT INTO acfNT_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Épi sé sa ki kwè an mwen-an kay fè sé miwak sala: Yo kay sèvi non mwen pou tiwé mové lèspwi an moun, yo kay palé langaj nèf. ");
INSERT INTO acfNT_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Si yo anmasé sèpan épi lanmen yo ében yo bwè pyès vyé pwézon i pa kay fè yo anyen. Si yo pasé lanmen yo asou jan ki malad yo kay jwenn djéwizon.” ");
INSERT INTO acfNT_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Apwé Jézi fini palé ba yo, Bondyé fèʼy vini an syèl épi la i asid asou lanmen dwèt Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Apwé sa sé disip-la alé pwéché Bon Nouvèl-la toupatou épi Jézi édé yo épi miwak pou moutwé moun sé bagay-la yo ka pwéché-a té vwé.");
INSERT INTO acfNT_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Tjofilòs, an chay moun ja éséyé ékwi listwa-a konsèné sé bagay-la ki fèt anpami nou-an konsèné Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Yo wakonté sa nou té tann an bouch sé moun-an ki té wè èk zyé yo menm dépi an koumansman-an èk ki déklawé konmisyon-an. ");
INSERT INTO acfNT_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Kon sa, chèf mwen, mwen ja étidyé byen lavi Jézi dépi an koumansman-an, èk mwen katjilé i kay bon pou mwen ékwi tout bagay baʼw menm kon i fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Mwen ékwiʼy pou ou sav tout sé bagay sala ou ja tann-an sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","La té ni yon pwèt nonʼy sété Zèkaraya. Sé menm tan-an lè Hèròd sété wa Jouda. Zèkaraya sété yonn an lakonpanni pwèt Abija. Non madanm li sété Élizabèt, épi li, menm kon mawiʼy, sété désandan pwèt. ");
INSERT INTO acfNT_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Yo toulé dé té ka viv dwèt épi yo té ka obéyi tout sa Bondyé di pou fè. ");
INSERT INTO acfNT_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Mé yo pa té ni pyès ti manmay paski Élizabèt té bwanhany èk yo té ja gwan moun. ");
INSERT INTO acfNT_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Lè lè-a té vini pou sé pwèt-la an lakonpanni Abija té fè sèvis an Kay Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","yo chwazi Zèkaraya an twadisyon sé pwèt-la pou i sa antwé an Kay Bondyé pou i té sa bwilé lansan ");
INSERT INTO acfNT_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","padantan sé moun-an té asanblé dèwò-a ka pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Lè sala yon nanj pawèt douvan Zèkaraya, épi i doubout asou fasad dwèt lotèl-la koté Zèkaraya té ka bwilé lansan pou adowé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Lè Zèkaraya wèʼy, i té sipwi épi i té pè. ");
INSERT INTO acfNT_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Mé nanj-lan diʼy, “Sé pa pou ou pè, Zèkaraya. Bondyé kay wéponn lapwiyèʼw. Èk madanm ou, Élizabèt, kay fè yon gason, épi zòt kay kwiyéʼy Jan. ");
INSERT INTO acfNT_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","I kay pòté lajwa épi kontantman baʼw, épi an chay lézòt moun kay an djèwté paski ti manmay sala fèt, ");
INSERT INTO acfNT_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","épi Bondyé kay konsidiwéʼy enpòtan. I pa ni pou bwè pyès wonm ében diven fò, épi i kay anba kondwit Lèspwi Bondyé dépi i an bouden manmanʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","I kay fè an pil moun Izwayèl pou tounen pou Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","épi i kay alé avan Senyè-a an pouvwa Lèspwi Bondyé menm kon pwòfèt Ilaydja, pou mété lapé ant papa èk ich. Épi yo ki ka viv an dézobéyisans, pou yo katjilé kon moun ki ka obéyi Bondyé. Épi kon sa i kay pwépawé sé moun-an pou lè Bondyé Senyè kay vini.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zèkaraya mandéʼy, “Ki mannyè mwen kay konnèt sé bagay sala? Mwen sé yon vyé kò, épi madanm mwen ja an gwan moun osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nanj-lan wéponn li, “Mwen sé Gabwiyèl, ki ka doubout an pwézans Bondyé. Épi i voyé mwen pou mwen sa diʼw bon nouvèl sala. ");
INSERT INTO acfNT_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Mé ou pa kwè konmisyon-an mwen vini pòté ba ou-a sé lavéwité. Kon sa paski ou pa kwè, ou kay vini moumou épi ou pa kay sa palé tout tan pwonmèt-la mwen fè ba ou-a pa akonpli.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Mé a menm lè-a sé moun-an té dèwò-a ka èspéyé pou Zèkaraya, épi yo té ka katjilé ki mannyè ki fè i ka wèsté tèlman lontan andidan Kay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Mé lè i sòti dèwò i pa té sa palé, épi yo di kon sa, “I sanm wè yon vizyon andidan Kay Bondyé,” paski i pa té sa di yon mo pawòl, èvèk i senpliman té ka fè sin ba yo épi lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Lè sé jou-a pou Zèkaraya té fè sèvis li an Kay Bondyé té fini, i viwé an kay li, ");
INSERT INTO acfNT_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","èvèk pa lontan apwé sa madanm li, Élizabèt, vini gwo bouden, épi i wèsté an kay-la senk mwa avan i sòti dèwò. ");
INSERT INTO acfNT_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Épi Élizabèt di kon sa, “Apwézan Bondyé édé mwen, épi i tiwé tout wipwòch-la mwen té ni an zyé sé moun-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","27","Élizabèt té ja gwo bouden pou senk mwa lè Bondyé voyé nanj Gabwiyèl oti Mari, yon fi, adan yon vilaj an Galili yo kwiyé Nazawèt. I sété fiyansé yon nonm yo kwiyé Jozèf ki sété désandan Wa David. ");
INSERT INTO acfNT_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabwiyèl pawèt douvan fi-a, i diʼy, “Bonjou! Ou ja twouvé favè èk Bondyé, èvèk Bondyé épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Mari té distwé, épi sa chagwinen lèspwiʼy. I katjilé, “Ki sa nanj-lan té vlé di pa sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nanj-lan di fi-a, “Mari, sé pa pou ou pè, paski Bondyé ja fèʼw an favè. ");
INSERT INTO acfNT_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Touswit ou kay vini gwo bouden, épi gason-an ou kay fè-a, ou kay bay nonʼy Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","I kay ni pouvwa, épi yo kay kwiyéʼy Gason Bondyé. Épi Bondyé Senyè kay ba li kondwit gwanpapaʼy, Wa David. ");
INSERT INTO acfNT_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","I kay kondwi jan Izwayèl pou tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Mari wéponn, “Ki mannyè sa kay fèt lè mwen pʼòkò kouché épi pyès nonm?” ");
INSERT INTO acfNT_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Nanj-lan wéponn li, “Lèspwi Bondyé kay vini anlèʼw, èk pouvwa Bondyé kay kouvèʼw kon yon lonbwaj. Ou kay twapé kòʼw gwo bouden, épi ti manmay-la ou kay fè-a kay Gason Bondyé. I kay pawfé san pyès péché. ");
INSERT INTO acfNT_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Épi jis fanmiʼw Élizabèt yo di ki té bwanhany, jòdi-a sé sis mwa dépi i gwo bouden an vyéyès li, ");
INSERT INTO acfNT_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","paski la pa ni anyen Bondyé pa sa fè.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Mari di, “Mwen sé sèvant Bondyé. Kité tout sa ou di-a fèt.” Èk apwé sa nanj-lan kitéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Èk apwé nanj-lan fini palé bay Mari, Mari pwépawé kòʼy èk i pati vitman alé adan yon vil an sé mòn péyi Jouda-a. ");
INSERT INTO acfNT_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Lè i wivé i antwé an kay Zèkaraya, i di Élizabèt bonjou. ");
INSERT INTO acfNT_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Lè Élizabèt tann vwa Mari, ti manmay-la ki té an boudenʼy-lan soté. An mouman sala Élizabèt té anba kondwit Lèspwi Bondyé ");
INSERT INTO acfNT_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","épi i hélé, “Ou sé an madanm ki benni an chay pasé tout lézòt madanm, èk ti manmay-la ou kay fè-a benni osi. ");
INSERT INTO acfNT_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ki moun mwen yé pou ou ki manman mèt mwen vini vizité mwen? ");
INSERT INTO acfNT_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Èk kon sa mwen tann vwaʼw, ti manmay-la soté an bouden mwen paski i té tèlman kontan. ");
INSERT INTO acfNT_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Mari, ou benni paski ou kwè konmisyon-an Bondyé diʼw-la kay fèt pou vwé.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Épi Mari di kon sa, “Mwen ka palé konsèné mannyè Bondyé gwan épi tout tjè mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Mwen byen kontan épi Bondyé, paski i sé sovè mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Magwé mwen pa anyen douvan Bondyé, mé i fè bagay sala ban mwen. Moun kay di ki Bondyé fè on gwan bagay ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Paski Bondyé ki pli ho pasé nou tout èk ki ni tout pouvwa ka fè gwan twavay ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","I ni on tjè fèb pou sé moun-an ki ni wèspé pou li, i ka édé yo jennenwasyon apwé jennenwasyon. ");
INSERT INTO acfNT_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","I ka fè gwan twavay épi lanmenʼy. I ka fè sé moun-an ki ni lògèy pou kouwi tout diwèksyon. ");
INSERT INTO acfNT_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","I ka tiwé otowizasyon pou kondwi an lanmen wa, mé i ka fè lé pòv enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","I ka bay lé pòv bon bagay mé i ka voyé sa ki wich alé lanmen vid. ");
INSERT INTO acfNT_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","I ka édé sèvant li, sé jan Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","I pa obliyé pou i édé Abrahanm épi tout désandanʼy pou tout tan, menm kon i té pwonmèt ayèl nou.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mari wèsté épi Élizabèt pou apipwé twa mwa, èk apwé sa i witounen lakay li. ");
INSERT INTO acfNT_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Tan-an té wivé pou Élizabèt té akouché, èk i fè on ti gason. ");
INSERT INTO acfNT_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Vwézinaj èk fanmiʼy tann ki mannyè Bondyé té bon pou li èk yo tout vini pou sélébwé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Lè ti manmay-la té ni on simenn, tout fanmi èk vwézinaj vini pou wè ti manmay-la sikonsayz. Yo té vlé kwiyé ti manmay-la Zèkaraya kon papaʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Mé manmanʼy di, “Non, nonʼy sé kay Jan.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Yo diʼy kon sa, “Mé ou pa ni pyès fanmi ki ni non sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Kon sa yo fè sin bay Zèkaraya pou sav ki non i té vlé bay ti manmay-la. ");
INSERT INTO acfNT_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zèkaraya mandé on bagay pou i sa ékwi asou èk i ékwi “Nonʼy sé Jan.” Épi tout moun té sipwi. ");
INSERT INTO acfNT_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","An menm mouman sala Zèkaraya té sa palé ankò, èk i koumansé ka glowifyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Sé vwézinaj-la té étonnen, èk nouvèl sala simen toupatou an sé mòn péyi Jouda-a. ");
INSERT INTO acfNT_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Tout moun ki tann katjilé asou sa, èk yo mandé ki kalité ti manmay sa kay yé, paski yo wè Bondyé té épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Lèspwi Bondyé té ka kondwi Zèkaraya, papa Jan, èk i koumansé palé sé pawòl-la Bondyé mété an bouch li. I di, ");
INSERT INTO acfNT_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Annou glowifyé Senyè-a, Bondyé Jan Izwayèl. I kay vini pou i édé sé moun li-an èk pou ba yo libèté. ");
INSERT INTO acfNT_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","I ka ban nou yon sovè ki ni an chay pouvwa, yonn ki sé désandan Wa David, sèvant Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","menm kon i pwonmèt pa bouch sé pwòfèt li-a ki té ka viv an tan lontan. ");
INSERT INTO acfNT_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","I pwonmèt pou i sové nou hòd sé lèlmi nou-an èk anba lanmen tout sa ki hayi nou. ");
INSERT INTO acfNT_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","I di i kay édé ayèl nou èk i kay tjenn pwonmèt-la i té fè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","I té pwonmèt gwanpapa nou Abrahanm ");
INSERT INTO acfNT_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ki i té kay délivwé nou sòti anba lanmen sé lèlmi nou-an, kon sa nou kay sa adowéʼy san pyès pèwèz ");
INSERT INTO acfNT_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","èk kon sa nou kay sa adowéʼy adan yon mannyè ki bon èk dwèt tout lèstan lavi nou. ");
INSERT INTO acfNT_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Èk ou, ich mwen, Bondyé kay kwiyéʼw yon pwòfèt li, paski ou kay alé avan Senyè-a pou ou sa pwépawé chimen-an ba li. ");
INSERT INTO acfNT_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ou kay di sé moun li-an ki Bondyé kay sové yo, i kay pawdonnen péché yo. ");
INSERT INTO acfNT_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","79","Bondyé ni an chay konpasyon asou nou, èk i kay voyé Gasonʼy sòti an syèl pou édé nou. Lè i kay moutwé nou chimen-an nou kay sa maché épi Bondyé, i kay menm kon lè jou ouvè èk sòlèy ka lévé. Nou pa kay ni lapenn pou wèsté an nwèsè ankò, nou pa kay ni bizwen wèsté an lonbwaj lanmò ankò, mé pito nou kay maché adan chimen lapé.” ");
INSERT INTO acfNT_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ti manmay-la pwofité èk i swiv kondwit Bondyé, èk i té ka wèsté adan yon plas pa kòʼy pou an chay tan, jis tan lè jou-a i té kay pawèt an piblik pou i té pwéché bay sé Jan Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","An tan sala Siza Ogis sété wa tout Ronm èk tout plas ki té anba kondwit Ronm, épi i pasé an lwa pou tout jan wéyòm-lan alé wéjistwé. ");
INSERT INTO acfNT_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Sété pwèmyé wéjistwasyon yo té ni padan Kwéwinòs sété gouvènè Siriya, ");
INSERT INTO acfNT_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","èk tout moun té ni pou alé wéjistwé an vil-la koté fanmi yo sòti-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Jozèf té ka wèsté an vil Nazawèt an péyi Galili, épi i mouté Bèfléyenm an péyi Jouda pou i sa wéjistwé, paski i sété désandan David épi David sété jan Bèfléyenm. ");
INSERT INTO acfNT_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","I alé wéjistwé épi Mari, fiyanséʼy, ki té ansent. ");
INSERT INTO acfNT_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Épi padan yo té la, tan-an pou Mari akouché-a wivé. ");
INSERT INTO acfNT_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","Épi i akouché, i fè an tibway, sété pwèmyé ich li. Épi i voplé ti manmay-la adan twèl épi i météʼy kouché andidan yon bwèt yo ka mété zèb bay zannimo, andidan yon létjiwi, paski yo pa té jwenn an lòt plas pou yo té dòmi. ");
INSERT INTO acfNT_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Jou òswè sala la té ni bèwjé an savann-an tou pwé-a ka gadé mouton yo. ");
INSERT INTO acfNT_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Toubonnman an nanj pawèt anpami yo, èvèk klèté Bondyé té ka kléwé toupatou anlè yo èk tout ko yo té yé-a, èvèk yo té pè an chay. ");
INSERT INTO acfNT_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Nanj-lan di yo, “Pa pè, paski mwen mennen zòt bon nouvèl ki kay fè tout moun kontan. ");
INSERT INTO acfNT_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Jòdi-a an vil-la koté Wa David té fèt-la an sovè fèt. I sé Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Mannyè zòt kay konnèt li, zòt kay jwenn ti manmay-la voplé adan twèl èk kouché andidan an bwèt koté yo ka bay zannimo manjé.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","A menm lè-a an gwan konpanni nanj vini jwenn nanj-lan ki té ka palé bay sé bèwjé-a, èk yo té ka glowifyé Bondyé, ka chanté, ");
INSERT INTO acfNT_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“An syèl yo ka glowifyé Bondyé, yo ka di i gwan. I ja pòté lapé pou tout moun ki ka plèʼy asou latè.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Apwé sa sé nanj-lan viwé mouté an syèl, èk sé bèwjé-a di bay yonn a lòt, “Annou mouté Bèfléyenm pou nou wè sé bagay-la Bondyé di nou-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Épi yo mouté Bèfléyenm vitman, yo jwenn Jozèf, Mari, épi ti manmay-la andidan yon létjiwi èk ti manmay-la kouché andidan yon bwèt koté yo ka bay zannimo manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Lè yo wèʼy yo viwé épi yo di tout moun sa nanj-lan té di yo-a konsèné ti manmay-la, ");
INSERT INTO acfNT_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","èk tout moun ki tann sa sé bèwjé-a di-a té étonnen. ");
INSERT INTO acfNT_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mé Mari pa té obliyé tout sé bagay sala èk i katjilé an chay asouʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Apwé sa sé bèwjé-a viwé an savann yo ka glowifyé Bondyé pou tout sa yo té tann èk wè. I té menm kon nanj-lan té di yo. ");
INSERT INTO acfNT_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Yon simenn apwé ti manmay-la fèt, yo sikonsayz li èk yo bay nonʼy Jézi, non-an nanj-lan té ba li-a avan manmanʼy té ansent li. ");
INSERT INTO acfNT_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Apwé sa, lè-a vini pou Jozèf épi Mari fè sa Moziz té konmandé sé Jwif-la pou yo fè. Yo té ni pou mennen ti manmay-la pou yo pwézantéʼy bay Bondyé, paski Moziz té konmandé si an madanm fè an tibway pou pwèmyé ich li, yo ni pou ofèʼy bay Bondyé. Kon sa yo alé an Kay Bondyé-a an Jérouzalèm, épi an menm di tan yo fè sa, Mari té ni pou tjwé dé toutwèl ében dé pijon èk bwilé yo pou fè sakwifis bay Bondyé pou Mari té sa pawèt nèt douvan Bondyé apwé akouchman ti manmay li. ");
INSERT INTO acfNT_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tan sala la té ni yon nonm nonʼy sété Siméyon. I té ka wèsté Jérouzalèm. Siméyon sété yon bon nonm ki té ka fè sa Bondyé té vlé i fè. I té ka èspéyé pou i wè wa-a Bondyé té pwonmèt pou voyé-a pou délivwé sé Jan Izwayèl-la an lapenn yo avan i mò. Lèspwi Bondyé té épiʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","èk Lèspwi-a té asiwéʼy ki i pa té kay mò avan i wè Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Yon jou Lèspwi Bondyé kondwi Siméyon antwé andidan Kay Bondyé. I sété menm jou-a manman èk papa Jézi mennenʼy pou pwézantéʼy bay Bondyé kon lwa sé Jwif-la té mandé yo pou fè. ");
INSERT INTO acfNT_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Siméyon té la, èk i pwan Jézi an bwaʼy èk i wimèsyé Bondyé, i di, ");
INSERT INTO acfNT_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Senyè, apwézan ou sa pwan mwen an lapé, paski ou ja tjenn pwonmèt ou. ");
INSERT INTO acfNT_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","31","Èk zyé mwen menm mwen ja wè sovè-a ou voyé pou ou sa sové tout latè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","I sé kon yon klèté ki kay kléwé chimenʼw bay tout nasyon, èk i kay fè Izwayèl on plas pou moun konnèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Manman èk papa Jézi té étonnen pou tann sa Siméyon té di konsènéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Siméyon benni yo èk i di Mari, manman Jézi, “Ti manmay sala — sé Bondyé ki chwaziʼy pou i fè an chay jan Izwayèl tonbé pou yo pa sa viwé lévé, épi pou i fè on chay lévé pou i sa benni yo. I kay moutwé lézòm ki moun Bondyé yé, èk an chay moun kay palé kont li, ");
INSERT INTO acfNT_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","èk sa kay fè tout sa ki an tjè moun pawèt aklè. Èk ou menm madanm, ou osi kay ni an chay lapenn ki kay pèsé tjèʼw menm kon yon sab.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","La té ni on madanm ki sété on pwòfèt nonʼy sété Anna. I sété ich Fannwèl, an désandan Achè. Sété on madanm ki té ja gwan moun. I té mayé pou sèt lanné, ");
INSERT INTO acfNT_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","mé mawiʼy mò èk apwézan i ni katwiven kat lanné. I té ka an Kay Bondyé toulé swè, toulé bonmaten, ka pwédyé èk ka wèsté san manjé byen souvan pou adowé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","An menm mouman Siméyon té ka palé bay Mari èk Jozèf, madanm sala wivé. I koumansé wimèsyé Bondyé èk i palé konsèné ti manmay-la bay tout sa ki té ka èspéyé sovè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Lè Mari épi Jozèf fini fè tout sa Moziz té konmandé pou yo fè, yo witounen lakay yo an Nazawèt adan on vilaj Galili. ");
INSERT INTO acfNT_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Sé la ti manmay-la vini gwan, èk i pwofité an santé épi lakonpwann, èk Bondyé benniʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Toulézanné Mari épi Jozèf té ka alé Jérouzalèm pou Fèt Délivwans. ");
INSERT INTO acfNT_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Lè Jézi té ni douz an, yo alé Jérouzalèm kon lakoutim, mé kou sala yo mennen Jézi épi yo pou pwèmyé fwa-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Lè fèt-la fini, manmanʼy èk papaʼy pati viwé lakay yo an Nazawèt, mé Jézi wèsté dèyè an Jérouzalèm. Mé Mari èk Jozèf pa té sav, ");
INSERT INTO acfNT_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","paski yo té ni lidé i té anpami sé moun-an. Lè i té ni on jou yo òbzòvé yo pa wè Jézi, yo koumansé chachéʼy anpami fanmi épi kanmawad yo. ");
INSERT INTO acfNT_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Yo pa twapéʼy, kon sa yo viwé Jérouzalèm pou gadé pou li. ");
INSERT INTO acfNT_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Apwé dé jou yo jwenn Jézi an Kay Bondyé asid anpami sé titja lwa sé Jwif-la, ka kouté yo èk ka mandé yo kwèsyon. ");
INSERT INTO acfNT_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Tout sa ki tann li té sipwi pou wè lakonpwann li épi wépons li. ");
INSERT INTO acfNT_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Lè Mari èk Jozèf wèʼy yo té étonnen. Manmanʼy diʼy, “Ich mwen, pou ki sa ou fè nou sa? Mwen èk papaʼw té ka katjilé an chay paski nou té ka chachéʼw toupatou èk nou pa té sa jwenn ou pyès koté.” ");
INSERT INTO acfNT_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jézi di yo, “Pouki pou zòt ka gadé pou mwen? Ès si zòt pa sav mwen ni pou an kay Papa mwen?” ");
INSERT INTO acfNT_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Mé yo pa té konpwann ki sa i té ka di yo-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Jézi witounen an Nazawèt épi manmanʼy èk papaʼy épi i té ka obéyi yo. Mé manmanʼy katjilé asou tout sa i di-a. ");
INSERT INTO acfNT_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Jézi vini gwan gason. I pwofité an lakonpwann, èk ni Bondyé ni lézòm té enmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","La té ni yon nonm nonʼy sété Jan Batis, i sété gason Zèkaraya. I té ka wèsté adan yon plas pyès lézòt moun pa té ka wèsté, èk yon jou Bondyé ba li yon konmisyon pou i pwéché bay sé moun-an. Sa sété an kenzyenm lanné padan Tibè Siza sété wa, Pons Pilat sété gouvènè Jouda, Hèròd sété gouvènè Galili, fwèʼy Filip sété gouvènè péyi Litouwé èk Twakonnit, èk Lisanniyas sété gouvènè Labilenn. Osi, Annas èk Kayafas sété pli gwan pwèt tan sala. Padan tan sala Bondyé bay Jan Batis, gason Zèkaraya, yon konmisyon pou pwéché bay sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Kon sa Jan Batis alé an tout fon-an bò Lawivyè Jouden èk i di sé moun-an, “Tounen hòd péché zòt èk batizé, èk Bondyé kay pawdonnen zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Sé menm kon pwòfèt Izaya té ékwi an liv li. I té ékwi kon sa, “Sé moun-an kay tann vwa an moun byen lwen ka andjélé, i ka di, ‘Pwépawé chimen-an bay Senyè-a èk fè twas ki dwèt pou i sa pasé. ");
INSERT INTO acfNT_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Tout fon kay plen, èk tout montany èk mòn kay vini ba. Tout chimen kochi kay vini dwèt, vyé chimen kay wanjé. ");
INSERT INTO acfNT_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Èk tout lézòm kay wè ki mannyè Bondyé kay sové yo.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Yon latilyé moun vini pou Jan batizé yo. I di yo, “Débann sèpan kon zòt yé! Zòt vlé mwen batizé zòt paski zòt kwè mannyè sala zòt kay sa chapé lanfè san zòt vwéman wépanti! ");
INSERT INTO acfNT_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Menm kon pyé fwitaj ni pou pwodwi bon fwi, zòt osi ni pou fè sé bon bagay-la ki kay moutwé ki zòt ja tounen hòd péché zòt. Èk pa di zòt kay sové paski zòt sé désandan Abrahanm. Kité mwen di zòt sa, si Bondyé vlé fè ich bay Abrahanm pou i sa tjenn pwonmèt li, i sa fè yo èk sé wòch sala. ");
INSERT INTO acfNT_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Jijman Bondyé pawé pou tonbé anlè zòt menm kon yon hach ki pawé pou koupé chous yon pyé bwa. Tout pyé bwa ki pa ka pòté bon fwi kay koupé èk jété an difé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Sé moun-an mandéʼy, “Ki sa nou ni pou fè?” ");
INSERT INTO acfNT_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","I di yo, “Sa ki ni dé chimiz ni pou bay yon moun ki pa ni pyès, èk sa ki ni manjé ni pou sépawéʼy èk sa ki pa ni.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Yon konpanni nonm ki té ka anmasé taks bay gouvèdman Ronm vini pou Jan batizé yo, èk yo mandéʼy, “Mèt, ki sa nou ni pou fè?” ");
INSERT INTO acfNT_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","I di yo, “Pa pwan lajan an lanmen sé moun-an pasé sa gouvèdman-an di zòt pou pwan.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Èk yon konpanni sòlda mandéʼy, “Ki sa nou ni pou fè?” I di yo, “Pa fòsé moun ében manti anlè yo pou éséyé fè yo baʼw lajan. Sa yo ka péyé zòt-la, sé pou zòt kontanté épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Sé moun-an té ka èspéyé akwèdi yo kwè on bagay té kay fèt, èk yo koumansé ka katjilé si Jan Batis sé Mèsaya-a pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Jan Batis di sé moun-an, “Mwen ka batizé zòt èk dlo, mé la ni yonn ki ka vini ki ni pli lotowité pasé mwen. Mwen pa asé bon pou mwen menm démawé soulyéʼy. Moun sala kay baʼw Lèspwi Bondyé èk osi i kay voyé difé désann sòti an syèl. ");
INSERT INTO acfNT_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","I kay tiwé gwenn anpami pay. I kay pwézèvé sé gwenn-an, èk i kay bwilé pay-la andidan difé ki pa kay janmen étenn.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Èk Jan Batis di sé moun-an an chay lòt bagay padan i té ka pwéché Bon Nouvèl-la ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Jan Batis palé kont Gouvènè Hèròd paski i mayé épi Hèrodiyas, madanm fwèʼy, épi pou an pil lézòt movèzté. ");
INSERT INTO acfNT_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Pou mété pli péché asou sa i ja ni, Hèròd mété Jan Batis an pwizon. ");
INSERT INTO acfNT_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Lè tout sé moun-an té ka batizé, Jézi osi batizé. Padan i té ka pwédyé, syèl ouvè ");
INSERT INTO acfNT_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","èk Lèspwi Bondyé désann asouʼy an yon fòm kon yon toutwèl. Épi an vwa sòti an syèl, yo tann vwa Bondyé di, “Ou sé Gason mwen mwen enmenʼw an chay. Mwen byen plè épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Lè Jézi koumansé twavay li, i té apipwé twant lanné. Moun té kwè i sété gason Jozèf. Jozèf sété gason Héli, ");
INSERT INTO acfNT_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Héli sété gason Matat, Matat sété gason Livay, Livay sété gason Mèlki, Mèlki sété gason Jannay, Jannay sété gason Jozèf, ");
INSERT INTO acfNT_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Jozèf sété gason Matatiyas, Matatiyas sété gason Amòs, Amòs sété gason Nahoum, Nahoum sété gason Èsli, Èsli sété gason Nagay, ");
INSERT INTO acfNT_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagay sété gason Mat, Mat sété gason Matatiyas, Matatiyas sété gason Séméyi, Séméyi sété gason Jozèk, Jozèk sété gason Joda, ");
INSERT INTO acfNT_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda sété gason Jowannan, Jowannan sété gason Résa, Résa sété gason Zèròbabèl, Zèròbabèl sété gason Chyèltyèl, Chyèltyèl sété gason Néri, ");
INSERT INTO acfNT_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Néri sété gason Mèlki, Mèlki sété gason Adi, Adi sété gason Kosanm, Kosanm sété gason Èlmadanm, Èlmadanm sété gason Èr, ");
INSERT INTO acfNT_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Èr sété gason Jòchwa, Jòchwa sété gason Éliyéza, Éliyéza sété gason Jorim, Jorim sété gason Matat, Matat sété gason Livay, ");
INSERT INTO acfNT_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Livay sété gason Siméyon, Siméyon sété gason Jouda, Jouda sété gason Jozèf, Jozèf sété gason Jonnanm, Jonnanm sété gason Éliyakim, ");
INSERT INTO acfNT_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Éliyakim sété gason Méléya, Méléya sété gason Menna, Menna sété gason Matata, Matata sété gason Natan, Natan sété gason David, ");
INSERT INTO acfNT_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","David sété gason Jèsi, Jèsi sété gason Obèd, Obèd sété gason Bowaz, Bowaz sété gason Salmòn, Salmòn sété gason Nachòn, ");
INSERT INTO acfNT_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nachòn sété gason Aminadab, Aminadab sété gason Admin, Admin sété gason Anni, Anni sété gason Hèzròn, Hèzròn sété gason Pérèz, Pérèz sété gason Jouda, ");
INSERT INTO acfNT_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Jouda sété gason Jakòb, Jakòb sété gason Ayzak, Ayzak sété gason Abrahanm, Abrahanm sété gason Tèra, Tèra sété gason Nahò, ");
INSERT INTO acfNT_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nahò sété gason Sérouk, Sérouk sété gason Rago, Rago sété gason Pélèg, Pélèg sété gason Ébè, Ébè sété gason Chèla, ");
INSERT INTO acfNT_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Chèla sété gason Kaynann, Kaynann sété gason Afaksad, Afaksad sété gason Chenm, Chenm sété gason Nowa, Nowa sété gason Lanmèk, ");
INSERT INTO acfNT_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lanmèk sété gason Matousala, Matousala sété gason Inòk, Inòk sété gason Jarèd, Jarèd sété gason Mahalalèl, Mahalalèl sété gason Kaynann, ");
INSERT INTO acfNT_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kaynann sété gason Énòch, Énòch sété gason Sèt, Sèt sété gason Adanm, èk Adanm sété gason Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Lèspwi Bondyé té ka kondwi Jézi, èk i sòti Lawivyè Jouden èk Lèspwi Bondyé mennenʼy adan yon plas koté pyès moun pa ka wèsté. ");
INSERT INTO acfNT_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Denmou tantéʼy la pou kawant jou. Èk pou tout sé jou sala Jézi pa manjé anyen, épi i té fen apwé sa. ");
INSERT INTO acfNT_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Denmou diʼy, “Ou sé Gason Bondyé èk ou fen. Kon sa konmandé wòch sala pou tounen pen.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Mé Jézi wéponn li, “Non. Mi sé sa ki ékwi an lévanjil, ‘Lézòm pa pou viv asou pen tousèl.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Denmou mennen Jézi yon lòt koté ki ho, èk adan yon ti mouman i moutwé Jézi tout wéyòm latè-a, ");
INSERT INTO acfNT_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","èk i diʼy, “Mwen kay baʼw tout pouvwa èk wichès sé wéyòm sala, paski i sé san mwen èk mwen sa bay népòt moun mwen vlé li. ");
INSERT INTO acfNT_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Kon sa si ou kay ajounou èk adowé mwen, tout sa kay sa ou.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jézi wéponn li, “Mi sé sa ki ékwi an lévanjil, ‘Adowé Bondyé Senyè, èk sé li sèlman pou sèvi!’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Denmou mennen Jézi vil Jérouzalèm èk i fè i doubout anlè tèt Kay Bondyé-a. I di Jézi, “Ou sé Gason Bondyé. Soté a tè. ");
INSERT INTO acfNT_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Anyen pa kay wivéʼw, paski i ékwi an lévanjil ki Bondyé kay bay sé nanj li-a konmandman pou yo pwotèktéʼw, ");
INSERT INTO acfNT_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","èk yo kay lévéʼw anlè an lanmen yo, èk pa menm pyéʼw ki kay konyen anlè an wòch.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jézi wéponn li, “Mi sé sa ki osi ékwi an lévanjil, ‘Ou pa sipozé mandé Bondyé fè sa i pa vlé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Lè Denmou fini tanté Jézi an tout diféwan mannyè, i kité Jézi èk i pati pou i viwé an lòt lè, lè i kay jwenn an lòt chans. ");
INSERT INTO acfNT_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Kon sa Jézi witounen an péyi Galili, èk Lèspwi Bondyé té ka kondwiʼy. Tout jan plas-la tann nouvèl-la konsèné Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","I enstwi sé moun-an an sé légliz sé Jwif-la èk tout moun té ka palé byen konsènéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jézi alé Nazawèt, an vil-la koté i lévé lè i té piti tibway, èk asou jou sabaf-la i alé an légliz sé Jwif-la kon i té ni labitid ka fè. I doubout èk i alé douvan-an pou i té sa li ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Yonn an sé moun-an ki té la-a ba li liv pwòfèt Izaya. Lè i ouvèʼy i jwenn koté-a i té ka chaché-a èk i liʼy ba yo koté i ékwi, ");
INSERT INTO acfNT_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Lèspwi Bondyé anlè mwen. I ja chwazi mwen pou mwen sa pòté Bon Nouvèl bay lé maléwé. I voyé mwen pou di sé pwizonnyé-a yo kay jwenn libèté. Èk pou fè tout avèg sav yo kay sa wè. Pou bay sé moun-an yo ka maltwété-a libèté. ");
INSERT INTO acfNT_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Pou mwen fè moun sav tan-an ja wivé lè Bondyé kay délivwé sé moun li-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Lè i fini li liv-la, i fèméʼy èk bay moun-an liv-la viwé, èk i asid la menm. Zyé tout moun ki té an légliz-la té fiksé anlè Jézi, ");
INSERT INTO acfNT_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","èk i di yo, “Jòdi-a sé pawòl sala ki ékwi an liv sala vini vwé.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Tout moun ki té la palé byen konsènéʼy èk yo té étonnen pou tann tout sé bon pawòl sala i di-a. Mé yo di, “Mé ki moun i kwè i yé? Ès si sa pa gason Jozèf-la?” ");
INSERT INTO acfNT_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jézi di yo, “Mwen sipozé jòdi-a zòt kay di mwen pawabòl sala, ‘Dòktè djéwi kòʼw. Nou ja tann tout sé bagay-la ou fè an vil Kapènéyòm-lan, kon sa fè sa ou fè la-a isi-a an vil ou menm pou nou sa wèʼy osi.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","I kontiné ka di yo, “Mwen ka di zòt lavéwité, pyès pwòfèt pa jwenn pyès wèspé an vil li menm. ");
INSERT INTO acfNT_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Mwen sa asiwé zòt ki an tan Ilaydja lapli pa tonbé pou twa lanné é dimi èk la té ni mové lafen èk tout tè-a té sèk. La té ni an chay vèv an péyi Izwayèl, ");
INSERT INTO acfNT_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","mé yo pa té kwè an li. Sé pou sa Bondyé pa voyé Ilaydja lakay yo pyès pou édé yo, pito i voyéʼy lakay yon étwanjé, yon vèv jan vil Zarapat an péyi Sidon. ");
INSERT INTO acfNT_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Èk an menm mannyè-a la té ni an chay moun ki té ni maladi an lapo yo an péyi Izwayèl an tan pwòfèt Ilaycha mé yo pa kwè an li, kon sa pa yonn ki jwenn djéwizon apa di Némann sèlman, yon jan péyi Siriya.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Tout sé moun-an ki té an légliz-la, lè yo vini sav sa Jézi té ka di-a sété kont yo, yo vini faché. ");
INSERT INTO acfNT_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Yo lévé èk yo tjenbé Jézi, yo twennenʼy sòti an vil-la, èk yo mennenʼy an tèt mòn-an koté vil yo té yé-a pou yo té sa jétéʼy an kaskou-a. ");
INSERT INTO acfNT_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mé Jézi annèk pasé anpami gany moun-an èk i alé fè zafèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Kon sa Jézi alé Kapènéyòm, yon vil ki té an péyi Galili, èk asou jou sabaf-la i enstwi sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Èk yo tout té étonnen pou tann mannyè i té ka enstwi yo-a paski i té ka palé èk lotowité. ");
INSERT INTO acfNT_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","La té ni yon nonm an légliz sé Jwif-la ki té ni vyé lèspwi andidanʼy. I andjélé, ");
INSERT INTO acfNT_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Awa! Ki sa ou vlé èvèk nou, Jézi jan Nazawèt? Ès ou vini pou ou détwi nou? Mwen sav ki moun ou yé, ou sé konmisyonnè-a Bondyé chwazi pou voyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jézi diʼy, “Pé la èk sòti andidan nonm-lan!” Vyé lèspwi-a jété nonm-lan a tè douvan tout sé moun-an èk i sòti andidan nonm-lan san fèʼy ditò. ");
INSERT INTO acfNT_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Tout sé moun-an té étonnen, èk yo di bay yonn a lòt, “Ki kalté pawòl sa yé? I konmandé vyé lèspwi-a èk pouvwa èk lotowité, èk vyé lèspwi-a sòti andidan nonm-lan.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Èk nouvèl-la konsèné Jézi simen an tout péyi-a. ");
INSERT INTO acfNT_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jézi kité légliz sé Jwif-la èk i alé lakay Simon. Bon, bèlmè Simon té ka soufè èk an chay lafyèv, èk yo mandé Jézi pou édéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Kon sa Jézi doubout a koté madanm-lan èk i panché kòʼy anlèʼy èk i konmandé lafyèv-la pou kité madanm-lan, èk lafyèv-la kitéʼy menm lè-a. Èk la menm i lévé èk i koumansé pwépawé manjé ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kon sòlèy té ka kouché, tout sé moun-an ki té ni jan ki malad mennen yo bay Jézi pou i té sa djéwi yo. I touché yo chak épi i djéwi yo tout. ");
INSERT INTO acfNT_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","La té ni déotwa ki té ni vyé lèspwi andidan yo. Lè sé vyé lèspwi-a té ka sòti andidan yo, yo andjélé, “Nou sav ou sé Gason Bondyé,” Mé i fè yo tjenn silans, paski yo té sav i sété wa-a Bondyé voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Li denmen bonmaten Jézi alé adan an plas ki pa té ni kay ében moun ka wèsté. Mé sé moun-an chachéʼy toupatou, épi lè yo jwenn li yo mandéʼy pou wèsté épi yo, ");
INSERT INTO acfNT_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","mé i wéponn yo, “Mwen ni pou alé an lòt plas osi pou mwen sa pwéché Bon Nouvèl konsèné ki mannyè Bondyé kay établi kondwit li adan on mannyè nèf, paski sé pou wézon sala mwen vini.” ");
INSERT INTO acfNT_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Épi i kontiné ka pwéché an sé légliz sé Jwif-la oliwon péyi sala. ");
INSERT INTO acfNT_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Yon jou Jézi té doubout bò Lanmè Jennèsawèt-la, lè yon gwan kantité moun té ka konblé pou yo vini tann Jézi ka pwéché pawòl Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jézi wè dé kannòt asou pwent lanmè-a. Sé péchè-a té kité yo la épi yo alé lavé senn yo. ");
INSERT INTO acfNT_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jézi antwé andidan yonn an sé kannòt-la ki té sa Simon-an pou sé moun-an pa té konbléʼy épi i mandéʼy pou pousé kannòt-la ti miyèt pli lwen an dlo, èvèk i asid andidan kannòt-la ka enstwi sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Lè i té ja fini palé, i di Simon, “Alé ti miyèt pli lwen an gwan dlo, èk ou èk sé kanmawad ou-a ladjé senn zòt an dlo pou zòt tjenbé pwéson.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon wéponn, “Mèt, nou twavay tout lannwit èvèk nou pa tjenbé anyen, mé paski ou di sa nou kay ladjé senn-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Lè yo ladjé senn-an yo tjenbé yon gwan kantité pwéson, i té ni tèlman senn-an koumansé déchiwé. ");
INSERT INTO acfNT_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Kon sa yo kwiyé sé kanmawad yo-a ki té andidan lòt kannòt-la pou vini édé yo, èk yo vini, yo plen toulé dé kannòt-la jis tan sé kannòt-la pwèskè koulé. ");
INSERT INTO acfNT_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Lè Simon Pita wè kantité pwéson yo tjenbé, i tonbé an pyé Jézi épi i di, “Alé, Senyè, paski mwen sé an nonm ki mové.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Lè li èk sé lézòt nonm-lan ki té épiʼy-la wè kantité pwéson yo tjenbé, yo té étonnen. ");
INSERT INTO acfNT_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Jémz èk Jan, dé gason Zèbèdi ki té kanmawad Simon, yo té étonnen osi. Kon sa Jézi di Simon, “Pa pè. Apwézan ou kay koumansé péché lam lézòm.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Kon sa yo wédi kannòt yo a tè èk yo kité tout bagay, èk dépi jou sala yo koumansé swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Padan Jézi té adan yon sèten vil, la té ni yon nonm ki té kouvè èk yon maladi an lapoʼy. Lè i wè Jézi, i tonbé fas anba douvan Jézi. I plédé èk Jézi, “Mèt, mwen sav ou ni pouvwa pou ou sa djéwi mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jézi lonjé lanmenʼy èk i touché nonm-lan. I wéponn, “Mwen vlé fèʼy. Ou djéwi.” Èk menm lè-a nonm-lan djéwi. ");
INSERT INTO acfNT_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jézi diʼy, “Pa di pyès moun, mé alé, moutwé pwèt-la kòʼw. Èk ofè sakwifis-la Moziz té konmandé pou ofè lè yon moun twapé djéwizon, kon pwèv pou tout moun wè ki ou djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Mé nouvèl-la simen pli vit èk pli lwen pasé avan, èk kon sa an chay moun vini pou tann Jézi èk pou yo sa jwenn djéwizon pou maladi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Mé Jézi té ka alé adan lòt plas pa kòʼy tanzantan pou pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Yon jou lè Jézi té ka enstwi sé moun-an, la té ni déotwa Fawizyen èk titja lwa sé Jwif-la ki té asid la, yo sòti an tout vil an Galili èk Jouda èk Jérouzalèm. Bondyé té bay Jézi pouvwa pou i té sa djéwi jan ki malad. ");
INSERT INTO acfNT_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Yon konpanni nonm vini ka pòté yon nonm ki enfim adan yon hanmak, i pa té sa bwennen kòʼy pyès. Yo éséyé antwé andidan kay-la pou yo té mété nonm-lan douvan Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Mé yo pa té sa jwenn chimen pou yo antwé paski la té ni an chay moun. Kon sa yo mouté anlè kay-la èk nonm-lan. Yo fè yon twou anlè tèt kay-la èk yo ladjé nonm-lan adan hanmak-la an mitan sé moun-an dwèt douvan Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Lè Jézi wè mizi lafwa yo ni, i di nonm enfim-lan, “Gason, péchéʼw ja pawdonnen.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Sé titja lwa sé Jwif-la èk sé Fawizyen-an koumansé di bay yonn a lòt, “Ki moun nonm sala kwè i yé pou i ka ensilté Bondyé mannyè sala? Pyès moun pa sa pawdonnen péché apa di Bondyé tousèl!” ");
INSERT INTO acfNT_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Jézi té sav ki sa yo té ka katjilé, èk i di yo, “Pouki zòt ka katjilé sé bagay sala? ");
INSERT INTO acfNT_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Kilès ki pli ézé pou di, ‘Péchéʼw pawdonnen,’ ében pou di, ‘Lévé èk maché’? ");
INSERT INTO acfNT_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Mwen kay moutwéʼw ki mwen, Gason Lézòm, ni pouvwa asou latè pou pawdonnen péché.” Kon sa Jézi di nonm enfim-lan, “Mwen ka diʼw lévé, pwan kouch ou èk alé lakay ou.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","La menm nonm-lan lévé doubout douvan tout sé moun-an, i pwan kouch li èk i alé lakay li ka di an chay bon bagay konsèné Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Tout sé moun-an té étonnen. Yo glowifyé Bondyé èk yo té pè an chay. Yo di, “Jòdi-a nou wè gwan bagay nou pa janmen wè fèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Apwé sa Jézi sòti dèwò èk i wè yon nonm ki té ka wisivwè lajan ladwenn bay gouvèdman Ronm, nonʼy sété Livay. I té asid douvan biwoʼy. Jézi diʼy, “Vini swiv mwen èk ou kay yon disip mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Èk Livay lévé, i kité tout bagay èk i swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Èk Livay tjenn yon gwo fèt lakay li bay Jézi. La té ni an chay nonm ki té ka anmasé taks èk an chay lézòt moun ki ni mové wépitasyon ka manjé a tab èk yo. ");
INSERT INTO acfNT_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Yon konpanni Fawizyen èk titja lwa sé Jwif-la koumansé ka babyé èk sé disip Jézi-a, yo di, “Pouki pou zòt ka manjé èk moun ki ka anmasé taks èk lézòt péchè kon sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jézi di yo, “Sé moun ki malad ki bizwen dòktè, sé pa moun ki an santé. ");
INSERT INTO acfNT_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Mwen pa vini kwiyé moun ki kwè yo dwèt douvan Bondyé pou yo wépanti yo, mé pito moun ki sav yo sé péchè, sé yo mwen vini kwiyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Yon gany moun di Jézi, “Sé disip Jan Batis-la ka pwédyé èk wèsté san manjé pou adowé Bondyé souvan, èk sé disip sé Fawizyen-an osi ka fè menm bagay-la, mé sé disip ou-a pa ka janmen fè sa — Yo toujou ka bwè èk manjé.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jézi wéponn, “Ès ou kwè ou sa fè jan ki envité adan yon fèt mawiyaj wèsté san manjé tout tan nonm-lan ki ka mayé-a la épi yo? Mé non! ");
INSERT INTO acfNT_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Mé lè-a kay vini lè moun kay tiwé nonm mayé-a. Lè sala sé janʼy-lan kay wèsté san manjé.” ");
INSERT INTO acfNT_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Èk Jézi di yo an lòt pawabòl ankò. I di, “Pyès moun pa kay déchiwé tjò had nèf èk pyèsté an vyé had épiʼy. Si i fè sa i kay déchiwé an had nèf, èk pyès-la i déchiwé an had nèf-la pa kay alé èk vyé had-la. ");
INSERT INTO acfNT_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Èk pyès moun pa kay vidé diven ki fini fèt adan vyé boutèy. Si i fè sa, diven-an ki fini fèt-la kay pété vyé boutèy-la èk diven-an kay koulé a tè. ");
INSERT INTO acfNT_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Non, diven ki fini fèt ni pou vidé adan boutèy nèf. ");
INSERT INTO acfNT_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Èk pyès moun apwé yo bwè diven ki la lontan pa vlé bwè diven ki fini fèt, paski yo di vyé-a pli mèyè.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Asou yon jou sabaf sé Jwif-la, Jézi èk sé disip li-a té ka maché adan yon jaden. La té ni on sèten pyé bwa ki ka voyé on gwenn moun sa manjé an jaden sala, èk sé disip Jézi-a koumansé tjouwi adanʼy. Yo fwoté yo an lanmen yo pou tiwé pay-la èk yo manjé gwenn-an. ");
INSERT INTO acfNT_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","La té ni yon gany Fawizyen ki mandé yo, “Pou ki sa zòt ka fè sa? Zòt ka twavay, èk lwa-a di nou pa ni pou fè sa asou jou sabaf-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jézi wéponn yo, “Zòt pa janmen li ki sa David fè lè li èk sé nonm li-a té fen? ");
INSERT INTO acfNT_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","I antwé andidan Kay Bondyé èk i pwan pen-an ki té ofè bay Bondyé-a. I manjéʼy èk i bay sé nonm li-a. Èk sa kont lwa nou pou pyès moun manjé pen sala apa di sé pwèt-la tousèl.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Jézi di yo, “Èk apa di sa, mwen Gason Lézòm sé mèt jou sabaf-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Asou yon lòt jou sabaf Jézi alé adan yon légliz sé Jwif-la pou i enstwi sé moun-an, èk la té ni yon nonm ki té ni lanmen dwèt li enfim. ");
INSERT INTO acfNT_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Sé Fawizyen-an èk sé titja lwa sé Jwif-la té vlé jwenn an mannyè pou yo té akizé Jézi. Kon sa yo té ka véyé pou yo wè si i té kay djéwi moun asou jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mé Jézi té sav ki sa yo té ka katjilé èk i di nonm-lan ki ni lanmen enfim-lan, “Doubout èk vini isi-a douvan sé moun-an.” Nonm-lan lévé èk i doubout la. ");
INSERT INTO acfNT_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Kon sa Jézi di yo, “Mwen ka mandé zòt ki sa lwa-a di nou sa fè asou jou sabaf-la? Pou fè bon ében pou fè mové, pou sové lavi ében pou détwiʼy?” ");
INSERT INTO acfNT_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Jézi gadé tout oliwon, èk i di nonm-lan, “Lonjé lanmenʼw.” Nonm-lan fèʼy, èk lanmenʼy vini byen. ");
INSERT INTO acfNT_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Mé sa fè sé lèlmi Jézi-a faché, èk yo koumansé ka dispité èk yonn a lòt ki sa yo kay fè Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Apwé sa Jézi mouté anlè yon mòn pou i pwédyé. I pasé tout lannwit-la la ka pwédyé bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Lè jou ouvè i kwiyé sé disip li-a èk i chwazi douz anpami yo, èk i kwiyé yo “zapòt”. ");
INSERT INTO acfNT_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Non yo sété Simon — Jézi kwiyéʼy Pita — èk fwèʼy Androu, osi Jémz, Jan, Filip èk Batolonmi, ");
INSERT INTO acfNT_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mafyou èk Tonmas, Jémz gason Alfiyòs, èk Simon ki sété yon jan an lakonpanni nonm yo ka kwiyé Zèlòt, ");
INSERT INTO acfNT_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","osi Jida gason Jémz èk Jida Iskariyòt, nonm-lan ki té kay twayi Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jézi désann épi yo èk i doubout anlè yon plato èk an chay sé disip li-a té ka swiv li. Osi on chay moun té la ki sòti Jouda èk Jérouzalèm èk an tout vil bòdaj lanmè an péyi Taya èk Sidon. ");
INSERT INTO acfNT_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Yo vini pou yo sa tann li èk pou yo twapé djéwizon an maladi yo. Sa ki té ni vyé lèspwi andidan yo vini èk yo djéwi. ");
INSERT INTO acfNT_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Tout sé moun-an té ka éséyé touché Jézi, paski lè yo touchéʼy la té ni an pouvwa ki ka sòti andidan Jézi ki ka djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jézi gadé sé disip li-a èk i di yo, “Pa dé bon i bon pou zòt ki maléwé èk ka dépan asou Bondyé, paski zòt ja anba kondwit li. ");
INSERT INTO acfNT_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Pa dé bon i bon pou zòt ki fen pou bagay Bondyé apwézan, paski zòt kay satisfè. Pa dé bon i bon pou zòt ki ka pléwé apwézan, paski zòt kay wi. ");
INSERT INTO acfNT_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Pa dé bon i bon pou zòt lè moun kay hayi zòt èk widjèkté èk ensilté zòt épi yo kay di non zòt mové pou lapéti mwen, Gason Lézòm. ");
INSERT INTO acfNT_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Lè sa fèt, wéjwiʼw, paski zòt ni an gwan péyiman an syèl. Paski sé menm kon sa yo té fè sé pwòfèt-la. Ayèl sé moun sala maltwété sé pwòfèt-la menm mannyè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Mé ki mizi téwib i kay téwib pou zòt ki wich apwézan, paski zòt ja wisivwè asou latè tout wichès zòt kay jwenn! ");
INSERT INTO acfNT_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Ki mizi téwib i kay téwib pou zòt ki ka byen manjé apwézan, paski zòt kay fen! Ki mizi téwib i kay téwib pou zòt ki ka wi apwézan, paski zòt kay pléwé èk zòt kay an twistès! ");
INSERT INTO acfNT_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Ki mizi téwib i kay téwib pou zòt lè tout moun kay palé byen konsèné zòt, paski zòt menm kon sé fo pwòfèt-la! Ayèl sé moun sala té palé byen konsèné sé fo pwòfèt-la menm mannyè-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Mé mwen ka di zòt ki ka tann mwen, enmen lèlmiʼw èk fè byen bay sa ki hayiʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Benni sa ki modiʼw èk pwédyé bay sa ki ka maltwétéʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Si yon moun baʼw yon souflé anlè yon koté fidji ou, tounen èk kitéʼy baʼw yon souflé anlè lòt koté-a osi. Si yon moun pwan kanmizòl ou, ba li chimiz ou osi. ");
INSERT INTO acfNT_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Bay sa ou ni pou népòt moun ki mandéʼw, èk si pyès moun pwan sa ki sa ou, pa mandé yo li déviwé. ");
INSERT INTO acfNT_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Twété lézòt moun menm kon ou kay vlé yo twétéʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Si ou kontan sé moun-an ki kontanʼw-lan tousèl, pouki pou ou wisivwè bennédiksyon pou sa? Jik sé moun-an ki pa ka wèspèkté Bondyé-a ki ka fè sa. ");
INSERT INTO acfNT_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Èk si ou ka fè byen bay sa ki ka fè byen baʼw tousèl, pouki pou ou wisivwè bennédiksyon? Jik sé moun-an ki pa ka wèspèkté Bondyé-a ka fè sa. ");
INSERT INTO acfNT_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Èk si ou ka pwété sèlman sé moun-an ou sav ki kay sa péyéʼw viwé-a, pouki pou ou jwenn bennédiksyon pou sa? Jik sé moun-an ki pa ka wèspèkté Bondyé-a ka pwété kanmawad yo pou yo jwenn menm kantité-a viwé. ");
INSERT INTO acfNT_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Non! Enmen lèlmiʼw èk fè byen ba yo èk pwété yo san èspéyé anyen viwé. Lè sala ou kay ni an gwan péyiman sòti an syèl, èk ou kay vwéman vini gason Bondyé, paski Bondyé bon pou sé moun-an ki malonnèt èk méchan-an. ");
INSERT INTO acfNT_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ou sipozé ka fè menm kon Papaʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Pa jijé lézòt èk Bondyé pa kay jijéʼw. Pa kondanné lézòt èk Bondyé pa kay kondannéʼw. Pawdonnen lézòt èk Bondyé kay pawdonnenʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Bay lézòt èk Bondyé kay baʼw. Sa ou bay-la kay witounen pouʼw ankò pou an gwan kantité ka dépasé sa ou bay-la, pézé désann èk foulé pou fè lè pou pwan plis èk ka koulé a tè. Menm mizi-a ou sèvi pou bay-la, sé épiʼy menm Bondyé kay miziwé baʼw, ki i té piti ében gwo.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Èk Jézi di yo pawabòl sala osi, “Ki mannyè yon nonm ki avèg ka fè mennen yon lòt ki avèg? Ès yo toulé dé pa kay tonbé adan yon twou? ");
INSERT INTO acfNT_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Yon ti manmay lékòl pa anho titjaʼy. Mé si i apwann byen i kay vini menm kon titjaʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Pouki pou ou ka gadé ti lapousyè-a ki an zyé fwèʼw èk ou pa ka wè bi bwa-a ki an zyéʼw-la? ");
INSERT INTO acfNT_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ki mannyè ou sa di, ‘Fwè, kité mwen tiwé lapousyè-a ki an zyéʼw-la,’ lè ou menm pa ka wè bi bwa-a ki an zyéʼw-la pou ou sa tiwéʼy. Sakwé ipokwit! Tiwé bi bwa-a ki an zyéʼw-la avan, èk lè sala ou kay sa wè aklè lapousyè-a ki an zyé fwèʼw-la pou ou sa tiwéʼy ba li.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pyès bon pyé bwa pa ka pòté vyé fwi, ni yon vyé pyé bwa pa ka pòté bon fwi. ");
INSERT INTO acfNT_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ou kay konnèt yon pyé bwa pa kalité fwi-a i ka pòté-a. Moun pa ka tjouwi fig anlè yon pyé pikan ében tjouwi wézen anlè yon pyé kanpèch. ");
INSERT INTO acfNT_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Yon bon nonm kay pwodwi bon bagay an abondans tjèʼy, èk yon nonm ki mové kay pwodwi movèzté an abondans tjèʼy, paski sa ki an tjè on nonm, sé sa ki ka sòti an bouch li.” ");
INSERT INTO acfNT_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Pouki ou ka kwiyé mwen, ‘Senyè, Senyè,’ èk ou pa ka fè sa mwen diʼw-la? Moun-an ki vini oti mwen èk ki kouté pawòl mwen èk obéyiʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","mwen kay moutwéʼw kon ki sa i yé. ");
INSERT INTO acfNT_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","I kon yon nonm ki fè yon kay, i fouyé èk fè fondasyon-an fon anlè yon kayè. Gwo dlo vini èk i bat asou kay-la mé i pa soukwé kay-la paski kay-la té fèt byen fò. ");
INSERT INTO acfNT_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Mé moun-an ki tann pawòl mwen èk i pa obéyiʼy kay kon yon nonm ki fè kay li san pyès fondasyon. Lè gwo dlo vini èk i bat asou kay-la, i tonbé yon sèl kou. I kwazé nèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Lè Jézi fini di tout sé bagay sala bay sé moun-an, i alé Kapènéyòm. ");
INSERT INTO acfNT_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","La té ni yon chèf anpami sé sòlda-a an péyi Ronm ki té ni yon sèvant i té ka chéwi an chay ki té malad èk pawé pou mò. ");
INSERT INTO acfNT_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Lè i tann sa sé moun-an té ka di konsèné Jézi, i voyé adan ofisyé sé Jwif-la pou mandé Jézi pou vini djéwi sèvant li-a. ");
INSERT INTO acfNT_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Lè yo wivé oti Jézi yo plédé épiʼy. Yo di Jézi, “Nonm sala vo pou ou fè sa ba li, ");
INSERT INTO acfNT_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","paski i enmen sé Jwif-la épi i péyé pou bati yon légliz ban nou.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Kon sa Jézi alé épi yo. I pa té tèlman lwen kay-la lè ofisyé militè-a voyé yon konpanni janʼy pou di Jézi, “Mèt, pa anbété kòʼw, paski mwen pa vo pou niʼw andidan kay mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ni mwen pa konsidiwé ki mwen vo pou jwenn ou mwen menm. Mé annèk di pawòl-la èk sèvant mwen-an kay djéwi. ");
INSERT INTO acfNT_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Mwen sav sa paski mwen menm sé yon nonm ki anba kondwit ofisyé ki anho mwen, èk mwen ni sòlda ki anba kondwit mwen, èk mwen annèk ni pou di yo, ‘Alé,’ èk yo ka alé la menm, èk si mwen di nonm sala, ‘Vini,’ i ka vini la menm, èk si mwen konmandé sèvant mwen, ‘Fè sa,’ i ka fèʼy la menm.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Lè Jézi tann sa, i té étonnen. I tounen oliwon èk i di bay sé moun-an ki té ka swiv li-a, “Mwen ka di zòt, nonm sala ki pa on Jwif, mwen twouvé i kwè an mwen plis pasé sé Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Lè sala sé nonm-lan ki té vini oti Jézi-a viwé alé lakay chèf sòlda-a èk yo wè sèvant-lan djéwi. ");
INSERT INTO acfNT_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Touswit apwé sa, Jézi alé adan yon vil yo ka kwiyé Nayin. Sé disip li-a èk an chay lézòt moun alé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Kon i té ka antwé an vil-la i wè yo ka pòté yon moun ki mò alé téwé. Nonm mò-a sété sèl gason an madanm, mawiʼy té ja mò. Èk an chay jan vil-la té la épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Lè Jézi wè madanm-lan, tjèʼy fèʼy lapenn èk i diʼy, “Pa pléwé.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Jézi alé èk i touché senkèy-la, èk sé nonm-lan ki té ka pòtéʼy-la doubout. Jézi di, “Gason, mwen diʼw lévé.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nonm mò-a lévé asid èk i koumansé palé, èk Jézi bay manmanʼy li viwé. ");
INSERT INTO acfNT_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Tout sé moun-an wèsté épi bouch gwan ouvè èk yo koumansé ka glowifyé Bondyé. Yo di, “An gwan pwòfèt ja pawèt anpami nou! Bondyé ja vini pou i édé sé moun li-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Nouvèl sala konsèné Jézi simen an tout vil Joudiya èk oliwon-an. ");
INSERT INTO acfNT_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Sé disip Jan Batis-la tann tout sa Jézi té ka fè-a. Lè yo di Jan Batis sa, ");
INSERT INTO acfNT_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","i voyé dé anpami sé disip li-a oti Jézi pou mandéʼy, “Ès ou sé Mèsaya-a Bondyé té pwonmèt pou voyé-a, ében ès nou ni pou kontiné gadé pou yon lòt moun?” ");
INSERT INTO acfNT_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Lè yo wivé yo di Jézi, “Jan Batis voyé nou mandéʼw ès ou sé Mèsaya-a ki té ni pou vini-an ében ès nou ni pou èspéyé pou yon lòt moun?” ");
INSERT INTO acfNT_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","A menm mouman sala Jézi té ka djéwi an chay moun ki té malad èk diféwan kalité maladi, èk i fè jan ki té avèg wè klè, èk i té ka tiwé vyé lèspwi bay moun ki té ni vyé lèspwi andidan yo. ");
INSERT INTO acfNT_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Jézi wéponn sé disip Jan Batis-la, “Alé diʼy tout sa ou wè èk tann. Moun ki té avèg ka wè, moun ki té enfim ka maché, moun ki té ni maladi an lapo yo twapé djéwizon, moun ki té soud ka tann, moun ki té mò wésisité, èk moun ki pòv ka tann Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Bennédiksyon pou moun-an ki pa pèd lafwa an mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Apwé sé konmisyonnè Jan Batis-la pati, Jézi palé bay sé moun-an konsèné Jan Batis. I di yo, “Ki sa zòt té alé wè an hòtè byen lwen-an? An moun ki pa sav sa i vlé, menm kon on latjé kòk ki ka panché népòt koté van-an vanté? ");
INSERT INTO acfNT_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ki sa zòt té alé wè? Zòt pa alé wè on nonm ki té byen abiyé èk bèl had. Non, nonm ki ka abiyé èk bèl had ki chè an chay èk ki ni an chay bon bagay, sé lakay wa yo ka wèsté. ");
INSERT INTO acfNT_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Di mwen ki sa zòt té alé pou wè. Yon pwòfèt? Wi, mwen ka diʼw, zòt wè plis pasé yon pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Paski sé konsèné Jan Batis lévanjil té ékwi lè Bondyé di, ‘Mwen kay voyé konmisyonnè mwen douvanʼw pou i sa pwépawé chimen-an baʼw.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jézi kontiné ka di yo, “La pa ni pyès moun ki enpòtan pasé Jan Batis. Mé moun-an ki mwens enpòtan anpami sé sa Bondyé ka kondwi-a, i ni pli pwivilaj pasé Jan Batis.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Jézi di, “Lè tout sé moun-an èk jis sé mové nonm-lan ki té ka anmasé taks bay gouvèdman-an tann sa Jan Batis di-a, yo kwèʼy èk yo di Bondyé dwèt, èk kon sa yo kité Jan Batis batizé yo. ");
INSERT INTO acfNT_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Mé sé Fawizyen-an èk sé titja lwa sé Jwif-la widjèkté divwa Bondyé èk yo wifizé kité Jan Batis batizé yo. ");
INSERT INTO acfNT_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“Ében, kon ki sa mwen kay di moun jòdi yé? ");
INSERT INTO acfNT_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yo kon manmay ki ka jwé bò laplas. Yon gany ka andjélé sé lézòt-la, ‘Nou jwé mizik ki cho baʼw, mé ou pa dansé.’ ‘Nou chanté chanté ki twis baʼw, mé ou pa pléwé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Jan Batis vini èk i pa té ka ni manjé pen ében bwè diven, èk zòt di i ni yon denmou andidanʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Mwen, Gason Lézòm, vini èk mwen ka manjé èk bwè, èk zòt di, ‘Gadé nonm sala, i ka manjé an chay èk i sé yon gògè! I sé kanmawad sé moun-an ki ka anmasé taks èk lézòt péchè.’ ");
INSERT INTO acfNT_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Mé kanmenm lavi tout sa ki chwazi pou swiv Bondyé ka moutwé ki Bondyé savan.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Yon Fawizyen envité Jézi pou vini manjé dinen épiʼy. Jézi alé lakay nonm-lan épi i asid a tab pou i manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","La té ni yon fanm an vil-la ki té ka viv an vyé lavi péché. I tann ki Jézi té kay manjé lakay Fawizyen-an, kon sa i mennen yon boutèy losyon ki té byen chè, ");
INSERT INTO acfNT_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","èk i akoupi dèyè Jézi bò pyéʼy ka pléwé. I koumansé ka mouyé pyé Jézi èk dlo zyéʼy. Lè i fini i swiyé pyé Jézi èk chivéʼy, i bo pyé Jézi èk i fwoté yo èk losyon-an i té ni-an. ");
INSERT INTO acfNT_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Lè Fawizyen-an ki té envité Jézi lakay li-a wè sa, i di bay kòʼy, “Si nonm sala sété yon pwòfèt i té kay sav ki moun ki ka touchéʼy-la, èk i té kay sav ki kalité lavi péché fanm sala ka viv.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Jézi palé èk i di Fawizyen-an, “Simon, mwen ni yon bagay pou diʼw.” Simon wéponn, “Wi titja, di mwenʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Jézi koumansé diʼy pawabòl sala, “La té ni dé moun ki té ka dwé yon nonm ki té pwété yo lajan, yonn té ka dwé senk san dòla èk lòt-la té ka dwéʼy senkant dòla. ");
INSERT INTO acfNT_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Yo pyès pa té sa péyé nonm-lan viwé. Kon sa nonm-lan di yo yo pa bizwen péyéʼy viwé — kité sa. Kilès anpami yo dé-a ki kay kontan nonm sala plis?” ");
INSERT INTO acfNT_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon wéponn li, “Mwen sipozé moun-an ki té ka dwé plis lajan.” Jézi diʼy, “Ou ja jijé byen.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Kon sa i tounen ka gadé fanm-lan èk i di Simon. “Ès ou wè madanm sala? Mwen vini lakay ou, ou pa ban mwen pyès dlo pou mwen sa lavé pyé mwen. Mé i mouyé pyé mwen èk dlo zyéʼy èvèk i swiyé yo èk chivéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ou pa bo mwen kon nou ni labitid ka fè lè nou ka di bonjou, mé madanm sala dépi lè i antwé-a, i pʼòkò doubout bo pyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ou pa ban mwen lwil pou mwen fwoté tèt mwen kon nou ni labitid ka fè, mé madanm sala ja fwoté pyé mwen èk losyon. ");
INSERT INTO acfNT_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Kon sa mwen ka diʼw mwen ja pawdonnen gwo chay péchéʼy-la — sé pou sa i kontan mwen an chay. Èk moun-an ki wisivwè tizing pawdonnab pou tizing péché kay kontan mwen mwens.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Èk Jézi di madanm-lan, “Péchéʼw ja pawdonnen.” ");
INSERT INTO acfNT_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Lè sala sé moun-an ki té asid bò tab-la épiʼy-la di bay yonn a lòt, “Ki moun nonm sala kwè i yé, i ka jis pawdonnen péché?” ");
INSERT INTO acfNT_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mé Jézi di madanm-lan, “Lafwaʼw ja sovéʼw hòd péchéʼw — alé an lapé.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Apwé sa fèt, Jézi koumansé ka pasé an sé vil-la épi sé vilaj-la èk i té ka pwéché Bon Nouvèl-la konsèné mannyè Bondyé ka kondwi sé moun li-an. Sé douz disip-la té épiʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","èvèk osi déotwa madanm Jézi té ja tiwé vyé lèspwi an yo èk i té djéwi vyé maladi yo. Anpami yo té ni Mari Madlenn, sé an li Jézi té tiwé sèt denmou. ");
INSERT INTO acfNT_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Té ni Jowanna, mawiʼy sété on kolonm an kay Hèròd, nonʼy sété Chouza, épi Souzanna, èk an pil lézòt madanm, èvèk sé yo ki té ka dépansé lajan yo pou bay Jézi épi sé disip li-a sa yo té bizwen. ");
INSERT INTO acfNT_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Yon jou Jézi té doubout on koté pou i té palé bay yon konpanni moun ki té asanblé ansanm. Èvèk té ni lézòt ka sòti an lézòt vil ki vini otiʼy. Épi i palé an pawabòl ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","Jézi di yo, “La té ni on moun ki alé an jadenʼy pou i planté. Èvèk lè i voyé sé gwenn-an, yo tonbé an diféwan diwèksyon. La té ni on konpanni ki tonbé koté moun ka pasé, èk moun maché anlè yo, èvèk jibyé manjé yo. ");
INSERT INTO acfNT_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","La té ni on lòt konpanni ki tonbé asou tizing tè, mé la té ni pli wòch pasé tè. Yo lévé byen, mé paski yo pa té ni asé dlo, yo mò. ");
INSERT INTO acfNT_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","La té ni on lòt konpanni ki tonbé anpami lyenn pikan, èvèk lyenn pikan-an pwofité ansanm épi plan-an, èk pikan-an toufé yo. ");
INSERT INTO acfNT_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Mé la té ni on lòt konpanni ki tonbé asou bon tè, èvèk lè i lévé i pòté byen. La té ni on gwan kantité wékòt, plis pasé moun-an té planté.” Èk lè Jézi fini palé pawabòl sala ba yo, i di yo, “Tout sa ki ni zòwèy pou yo tann sipozé kouté.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Sé disip-la mandé Jézi, “Ki sa ou vlé di pa sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","I wéponn yo, “Bondyé baʼw abilité-a pou ou sa konnèt sa sé pawabòl sala vlé di. Yo ka èspliké ki mannyè Bondyé ka kondwi ich li. Mé sé lézòt sé moun-an kay gadé mé yo pa kay konpwann sa yo ka wè-a, yo kay kouté sé pawòl sala èk yo pa kay konpwann, menm kon sé pwòfèt-la té di. ");
INSERT INTO acfNT_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Mi, sé sa pawabòl sala vlé di. Sé gwenn-an sé pawòl Bondyé pou nonm. ");
INSERT INTO acfNT_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Tè wèd-la sé menm kon sé moun-an ki ni tjè wèd. Yo ka tann pawòl Bondyé mé yo pa ka kontiné an li, paski Satan ka fè yo obliyéʼy. I ka anpéché yo kwè pawòl-la èk sové. ");
INSERT INTO acfNT_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","“Tè-a ki ni wòch-la, sa sé konpanni moun-an ki kontan tann pawòl-la mé pawòl-la pa antwé andidan yo pou i sa wasiné èvèk pou i sa pwofité. Yo byen kontan pou wisivwèʼy, mé yo ka kwè pou an ti mouman tousèl, èk lè pèsikasyon vini yo pa té entéwésé ankò. ");
INSERT INTO acfNT_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","“Gwenn-an anpami pikan-an, i menm kon sé moun-an ki tann. Yo kwè pawòl Bondyé, mé katjil, wichès, wèskonsabilité, èk plézi lavi sala ka chaviyé lafwa yo. Kon sa yo pa pwodwi anyen ki bon. ");
INSERT INTO acfNT_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","“Mé bon tè-a sé menm kon sé moun-an ki ni yon bon tjè ki onnèt, ka kouté pawòl Bondyé, épi pawòl-la ka wèsté andidan yo. Yo koumansé ka fè sa Bondyé vlé yo fè, èk yo kontiné ka fèʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pyès moun pa kay limen yon lanp èk kouvèʼy épi yon bonm ében météʼy anba yon kouch. Pito sa, i kay météʼy koté moun sa wèʼy, kon sa lè moun vini yo kay sa wè klè. ");
INSERT INTO acfNT_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Anyen ki séwé kay pawèt an klèté-a, èk anyen ki kouvè kay dékouvè anba klèté-a. ");
INSERT INTO acfNT_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Kon sa fè antansyon ki mannyè ou ka kouté pawòl Bondyé, paski tout sa ki ja ka konpwann sa yo tann-an, yo kay tann épi konpwann ankò plis. Mé sé sa ki pa konpwann pyès-la, jis tizing-lan yo kwè yo konpwann-an, yo kay pèdiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Manman Jézi épi sé fwèʼy-la vini otiʼy mé yo pa té sa alé pwéʼy paski la té ni an chay moun. ");
INSERT INTO acfNT_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Yon moun di Jézi, “Manmanʼw épi sé fwèʼw-la doubout dèwò-a èk yo vlé palé épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jézi di ba yo tout, “Manman mwen épi fwè mwen sé sé moun-an ki tann pawòl Bondyé épi obéyiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Yon jou Jézi di sé disip-la, “Annou alé asou lòt fasad lanmè-a.” Kon sa yo antwé andidan yon gwo kannòt èk yo pati pou alé asou lòt fasad lanmè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mé on mové tan koumansé épi gwo lanm koumansé bat kannòt-la. I koumansé plen dlo épi yo té an danjé pou koulé. Mé Jézi té ka pwan on ti pòz. ");
INSERT INTO acfNT_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Sé disip-la lévé Jézi épi yo diʼy, “Mèt! Mèt! Nou kay néyé!” Kon sa Jézi palé bay mové tan-an, i konmandé mové tan-an pou doubout. Van-an vini dous. ");
INSERT INTO acfNT_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Épi i di yo, “Zòt pa ni lafwa an mwen?” Sé disip-la té pè èk byen sipwi èk yo di, “Ki kalité nonm sa yé? Jik van-an épi dlo-a ki ka obéyiʼy lè i konmandé yo!” ");
INSERT INTO acfNT_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yo twavèsé alé an péyi Gègésa, ki té lòt fasad lanmè-a an péyi Galili. ");
INSERT INTO acfNT_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Kon Jézi désann a tè-a i jwenn épi yon nonm an vil-la ki té ni vyé lèspwi andidanʼy. Pou yon chay tan nonm sala pa té janmen mété had anlèʼy ni wèsté andidan yon kay. I té ka wèsté andidan senmityè-a anpami sé fòs sé moun mò-a. ");
INSERT INTO acfNT_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Lè i wè Jézi i hélé èk tout vwaʼy épi i tonbé an dé pyé Jézi. I andjélé èk tout fòs li, “Ki sa ou vlé fè mwen, Jézi, Gason Bondyé ki an syèl? Mwen ka mandéʼw tanpwi souplé, pa fè mwen soufè!” ");
INSERT INTO acfNT_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","I di sa paski Jézi té ja konmandé vyé lèspwi-a pou sòti andidan nonm-lan. Plizyè fwa vyé lèspwi-a té ka kondwi nonm-lan, èk menm si yo té ka tjenn li an pwizon épi mawé pyéʼy épi lanmenʼy èvèk chenn i té ka kasé chenn-an, èk vyé lèspwi-a té ka kondwiʼy alé andidan yon plas koté pyès moun pa té ka wèsté. ");
INSERT INTO acfNT_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jézi mandéʼy, “Koumonnonʼw?” I wéponn Jézi, “Non mwen sé Gany,” paski an chay vyé lèspwi té andidan nonm-lan. ");
INSERT INTO acfNT_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Gany vyé lèspwi-a koumansé ka plédé épi Jézi pou i pa voyé yo an twou-a ki pa ni pyès fon. ");
INSERT INTO acfNT_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","La té ni an chay kochon anlè yon mòn ka manjé. Sé vyé lèspwi-a plédé épi Jézi pou i kité yo antwé andidan sé kochon-an, èk Jézi ba yo pèwmisyon-an. ");
INSERT INTO acfNT_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Lè sé vyé lèspwi-a sòti andidan nonm-lan yo antwé andidan sé kochon-an èk tout sé kochon-an ladjé kò yo désann kaskou-a, yo tonbé andidan lanmè-a èk yo tout néyé. ");
INSERT INTO acfNT_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Lè sé moun-an ki té ka gadé sé kochon-an wè sa ki fèt-la, yo kouwi alé wakonté sa an vil-la èk an hòtè. ");
INSERT INTO acfNT_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Épi sé moun-an alé wè ki sa ki fèt. Lè yo wivé bò Jézi, yo jwenn nonm-lan Jézi tiwé vyé lèspwi-a andidanʼy-lan asid an pyé Jézi. I abiyé èk i an bon lidéʼy. Èk yo tout té pè. ");
INSERT INTO acfNT_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Sé moun-an ki té wè sa ki fèt-la di lézòt moun mannyè nonm-lan ki té ni vyé lèspwi-a djéwi. ");
INSERT INTO acfNT_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Kon sa tout sé jan péyi Gègésa-a mandé Jézi pou kité yo bat mizè yo, paski yo té pè an chay. Kon sa Jézi antwé an kannòt-la pou i té sa fè ganm pou i alé. ");
INSERT INTO acfNT_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Nonm-lan ki té ni vyé lèspwi-a andidanʼy-lan plédé èk Jézi pou i alé épiʼy, mé Jézi voyéʼy alé. I diʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Alé lakay ou èk di janʼw ki sa Bondyé ja fè baʼw.” Kon sa nonm-lan alé an tout vil-la ka di tout sa Jézi fè ba li. ");
INSERT INTO acfNT_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Lè Jézi witounen asou lòt fasad lanmè-a, yon gany moun té la pou wisivwèʼy paski yo té ka èspéyéʼy vini. ");
INSERT INTO acfNT_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Lè sala yon nonm yo ka kwiyé Jayròs, i sété chèf légliz sé Jwif-la, i vini épi i tonbé an pyé Jézi. I plédé épiʼy pou i vini lakay li, ");
INSERT INTO acfNT_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","paski i té ni yon sèl ti fi ki té ni douzan ki té ka mò. Jézi dakò. Kon Jézi té ka alé, an chay moun té ka konblé tout oliwonʼy ka pouséʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Épi anpami yo la té ni yon madanm ki té ka pèdi san pou douz lanné. I té ja dépansé tout sa i té ni lakay dòktè, mé pyès moun pa té sa djéwiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","I fouyé kòʼy anpami sé moun-an, i wivé dèyè Jézi épi i touché woulé had Jézi, èk la menm i doubout senyen. ");
INSERT INTO acfNT_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Jézi mandé, “Ki moun ki touché mwen?” Tout moun di sé pa yo. Pita diʼy, “Mèt, sé moun-an ka konbléʼw èk yo ka pousé kò yo anlèʼw. Ki mannyè ou ka mandé sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Mé Jézi di, “Non, yon moun touché mwen èspwé. Mwen sav sa lè mwen santi pouvwa djéwizon sòti andidan mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Lè madanm-lan wè yo dékouvè ki sé li ki touché Jézi, i koumansé ka twanblé èk i tonbé an pyé Jézi an pwézans tout sé moun-an, èk i koumansé di Jézi pou ki wézon i touchéʼy épi i di i djéwi la menm. ");
INSERT INTO acfNT_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Lè sala Jézi di, “Ich mwen, Bondyé ja djéwiʼw paski ou kwè an mwen. Alé, lapé épiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Padan Jézi té ka palé toujou, yon moun vini di Jayròs, chèf légliz sé Jwif-la, “Ti fiʼw-la mò. Pa anbété titja-a ankò.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Lè Jézi tann sa, i di Jayròs, “Pa pè. Annèk mété konfyans ou an mwen, èk ti fi-a kay djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Lè Jézi wivé lakay Jayròs i pa kité pyès moun antwé épiʼy apa di Pita, Jan, Jémz, épi papa èk manman ti manmay-la. ");
INSERT INTO acfNT_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Tout moun ki té la té ka pléwé lanmò ti manmay-la. Jézi di yo, “Pa pléwé. Ti manmay-la pa mò, sé dòmi i ka dòmi!” ");
INSERT INTO acfNT_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Tout sé moun-an koumansé ka wi Jézi paski yo sav ki ti manmay-la mò pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Mé Jézi tjenbé ti fi-a pa lanmenʼy épi i diʼy, “Ich mwen, mwen diʼw lévé!” ");
INSERT INTO acfNT_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Lam ti fi-a witounen an kòʼy épi i lévé doubout. Lè sala Jézi di yo pou bay ti fi-a yon bagay pou i manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Manmanʼy èk papaʼy té étonnen. Mé Jézi di yo sé pa pou yo di pyès moun ki sa ki fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jézi kwiyé sé douz disip-la ansanm épi i ba yo pouvwa èk lotowité pou tiwé tout vyé lèspwi èk pou djéwi maladi. ");
INSERT INTO acfNT_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Èk i voyé yo alé pou di tout moun mannyè Bondyé ka kondwi sé moun li-an, èk pou djéwi sa ki malad. ");
INSERT INTO acfNT_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","I di yo, “Pa pwan anyen pou mennen anlè lawout zòt, ni baton, ni yon sak, ni manjé, ni lajan, pa menm yon lòt had pou zòt chanjé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","An népòt kay yo byen wisivwè zòt, wèsté la jis tan ou kité vil sala. ");
INSERT INTO acfNT_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Népòt koté sé moun-an pa wisivwè zòt, kité vil-la èk soukwé lapousyè pyé zòt, pou yo sav ki Bondyé faché kont yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Sé disip-la kité épi yo alé an tout sé vil-la ka pwéché Bon Nouvèl-la èk ka djéwi moun tout koté yo alé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Lè Hèròd, gouvènè péyi Galili, tann sé miwak-la Jézi té ka fè-a, i té byen twoublé konsèné sa paski yon konpanni moun té ka di sa sé Jan Batis ki té wésisité. ");
INSERT INTO acfNT_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Yon lòt konpanni di sé Ilaydja ki pawèt, padan yon lòt konpanni ka di sé yon lòt pwòfèt ki mò lontan ki wésisité. ");
INSERT INTO acfNT_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Hèròd di, “Mwen fè yo koupé tèt Jan Batis, mé ki moun nonm sala yé mwen ka tann sé bagay sala konsènéʼy-la?” Épi i kontiné ka éséyé pou wè Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Lè sé zapòt-la witounen jwenn Jézi, yo wakontéʼy tout sa yo té fè. I pati épi yo alé an vil-la yo kwiyé Bèfsayda. ");
INSERT INTO acfNT_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mé lè sé moun-an tann koté i té ka alé-a, yo swiv li. Jézi wisivwè yo èk i enstwi yo konsèné kondwit Bondyé, épi i djéwi sa ki té malad. ");
INSERT INTO acfNT_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Lè sòlèy té ka kouché sé douz disip-la apwoché Jézi épi yo diʼy, “Voyé sé moun-an alé an sé vil-la èk bitasyon ki oliwon-an pou yo ay chaché on plas pou yo dòmi épi chaché manjé pou yo manjé, paski koté-a nou yé-a nou lwen vil.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Jézi di yo, “Non, zòt menm bay sé moun-an an bagay pou yo manjé.” Mé yo di Jézi, “Nou pa ni anyen. Nou ni senk pen épi dé pwéson sèlman. Sèl mannyè sé si nou alé genyen bagay ba yo pou manjé.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Paski la té ni apipwé senk mil nonm. Jézi di yo, “Fè sé moun-an asid an ti pil pa senkant,” ");
INSERT INTO acfNT_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","épi yo fè sé moun-an asid. ");
INSERT INTO acfNT_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Jézi pwan pen-an èvèk pwéson-an èk i lévé zyéʼy an lézè, i wimèsyé Bondyé pou yo. I kasé pen-an, i bay sé disip-la li pou yo bay sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Tout moun manjé bouden yo plen. Lè sé moun-an fini manjé, sé disip-la anmasé douz panyen plen pen èk pwéson yo pa té sa fini manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Yon jou Jézi té pa kòʼy ka pwédyé èk sé disip-la vini otiʼy. I mandé yo, “Ki moun sé moun-an di mwen yé?” ");
INSERT INTO acfNT_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Yo wéponn, “Yon konpanni di ou sé Jan Batis wésisité hòd lanmò. Yon lòt konpanni di ou sé Ilaydja, épi yon lòt konpanni di ou sé yon lòt pwòfèt ki mò dépi lontan èk i wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mé Jézi mandé yo, “Ki moun zòt menm di mwen yé?” Pita wéponn, “Ou sé Mèsaya-a, wa-a Bondyé pwonmèt pou voyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Jézi vèti sé disip-la, “Pa di pyès moun anyen konsèné sa pyès toubonnman.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Épi i di, “Mwen, Gason Lézòm, oblijé soufè an chay. Sé chèf anpami sé Jwif-la, sé chèf pwèt-la épi sé titja lwa sé Jwif-la kay widjèkté mwen èk yo kay tjwé mwen, mé asou twazyenm jou-a mwen kay wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Épi i di ba yo tout, “Si pyès moun vlé swiv mwen i ni pou mété kòʼy épi plézi latè-a dèyè épi pòté kwaʼy toulé jou épi swiv mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Paski moun-an ki vlé tjenn laviʼy pou kòʼy-la kay pèd tout, mé moun-an ki kité tout bagay li dèyè pou lapéti mwen kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Ès yon nonm kay ni pyès pwofi si i ni tout latè-a épi lam li péwi? Mé non! ");
INSERT INTO acfNT_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Si pyès moun hont mwen èk pawòl mwen, mwen, Gason Lézòm, kay hont li lè mwen kay vini an pouvwa mwen ka kléwé kon zéklè, épi an pouvwa Papa mwen èvèk sé nanj-lan. ");
INSERT INTO acfNT_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Mwen ka di zòt lavéwité, yon konpanni anpami zòt ki ka doubout isi-a pa kay mò avan zòt wè mannyè Bondyé ka kondwi sé moun li-an adan on mannyè nèf.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Apipwé yon simenn apwé i di sé bagay sala, Jézi pwan Pita, Jan, èk Jémz épiʼy èk i mouté anlè yon mòn pou yo pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Padan Jézi té ka pwédyé, fidji li chanjé, had li vini blan èk i té ka kléwé kon zéklè. ");
INSERT INTO acfNT_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Èvèk dé nonm té ka palé épiʼy. Yo sété Moziz èk Ilaydja. ");
INSERT INTO acfNT_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yo pawèt èk tout klèté syèl èk yo té ka palé épi Jézi konsèné lanmòʼy an Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Pita épi sé kanmawad li-a té ofon sonmèy, mé yo lévé èk yo wè Jézi an tout gwan klètéʼy épi dé nonm-lan doubout la épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Kon sé nonm-lan té ka kité Jézi, Pita diʼy, “Mèt, sé yon bon bagay nou té isi-a. Nou kay bati twa chapèl isi-a, yonn pou ou, yonn pou Moziz, èk yonn pou Ilaydja.” Pita té twoublé èk i pa té menm sav sé papicho i té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Padan i té ka palé yon nwaj pawèt èk i voplé yo, èk sé disip-la té pè kon yo antwé an nwaj-la. ");
INSERT INTO acfNT_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Yon vwa an nwaj-la di yo, “Sa sé Gason mwen. Sé li mwen ja chwazi — koutéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Lè vwa-a fini palé ba yo, yo wè sé Jézi yonn ki doubout la. Sé disip-la tjenn bouch yo fèmé konsèné sa, èk yo pa di pyès moun ki sa yo té wè-a jis lontan apwé sa. ");
INSERT INTO acfNT_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Li denmen Jézi èk sé twa disip-la désann mòn-an, èk on chay moun jwenn épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Yon nonm anpami sé moun-an andjélé, “Titja, souplé mwen ka mandéʼw, gadé ti gason mwen-an, sé sèl ich-la mwen ni. ");
INSERT INTO acfNT_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Yon vyé lèspwi ka tjenbéʼy èk i ka fè kwiz pwanʼy. I ka fè i sézi èk i ka fè bouch li tjimé. I pa ka kitéʼy tout tan i pa dimi tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Mwen plédé èk sé disip ou-a pou yo tiwé vyé lèspwi-a mé yo pa té sa.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jézi di sé disip-la, “Zòt sé yon jennenwasyon ki mal a konpwann èk san lafwa. Ki mizi tan mwen oblijé wèsté épi zòt? Ki mizi tan mwen kay sipòté zòt?” Èk i di nonm-lan, “Mennen ti gason-an isi-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Kon ti gason-an té ka vini, vyé lèspwi-a annèk jétéʼy a tè èk fè kwiz pwanʼy. Jézi konmandé vyé lèspwi-a pou kité ti gason-an. I djéwiʼy èk i bay papaʼy li viwé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Èk tout sé moun-an té étonnen pou wè gwan pouvwa Bondyé. Sé moun-an té la ka palé toujou konsèné tout sé bagay-la Jézi té ka fè-a, lè i di sé disip li-a, ");
INSERT INTO acfNT_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kouté byen pou tann ki sa mwen kay di zòt-la! Mwen, Gason Lézòm, kay tonbé anba pouvwa lanmen lézòm.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Mé sé disip-la pa té sav ki sa i té ka di yo-a. Sa sété yon sigwé pou yo, kon sa yo pa té sa konpwann li èk yo té pè mandé ki sa sa vlé di. ");
INSERT INTO acfNT_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Sé disip-la té ka dispité konsèné kilès anpami yo ki kay pli enpòtan lè Bondyé kay kondwi. ");
INSERT INTO acfNT_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jézi sav ki sa yo té ka katjilé, kon sa i pwan yon ti manmay èk i météʼy doubout bòʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Épi Jézi di yo, “Pyès moun ki wisivwè ti manmay sala pou lapéti mwen wisivwè mwen. Èk pyès moun ki wisivwè mwen, i wisivwè moun-an ki voyé mwen-an, paski moun-an ki ka bésé kòʼy kon yon sèvant, sé li ki vwéman pli enpòtan anpami zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jan diʼy, “Mèt, nou wè yon nonm ka sèvi nonʼw pou tiwé vyé lèspwi, èk nou éséyé anpéchéʼy, paski i pa yonn anpami nou.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jézi diʼy, “Pa doubout li, paski pyès moun ki pa kont ou, i pouʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Kon tan pou Jézi kité latè-a té ka apwoché, i fè lidéʼy pou i alé Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","I voyé konmisyonnè alé avanʼy. Yo kité épi yo alé andidan yon vilaj an Sanmariya pou pwépawé bagay bay Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Mé jan vil sala pa té ni anyen pou fè épiʼy, paski yo wè ki sé Jérouzalèm i té ka alé. ");
INSERT INTO acfNT_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Lè sé disip-la, Jémz èk Jan, wè sa, yo di, “Senyè, ès ou vlé nou fè difé sòti an syèl èk détwi yo?” ");
INSERT INTO acfNT_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Jézi tounen dèyè èk i pwi dèyè yo, ");
INSERT INTO acfNT_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","épi yo tout alé andidan yon lòt vil. ");
INSERT INTO acfNT_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Kon yo té ka maché anlè lawout yo, yon sèten nonm di Jézi, “Mwen kay swiv ou tout koté ou alé.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jézi diʼy, “Bèt mawon ni yon plas pou yo wèsté, épi sé jibyé-a ni nich yo, mé mwen, Gason Lézòm, pa ni yon plas koté mwen sa pozé tèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jézi di yon lòt nonm, “Swiv mwen.” Mé nonm-lan diʼy, “Senyè, avan mwen swiv ou, kité mwen alé téwé papa mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jézi diʼy, “Kité sé moun-an ki akwèdi yo ja mò-a téwé moun mò yo. Mé ou menm, alé annonsé nouvèl-la ki Bondyé ka kondwi sé moun li-an adan yon mannyè nèf.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Yon lòt nonm diʼy, “Senyè, mwen kay swiv ou, mé kité mwen alé di jan kay mwen oplèz avan.” ");
INSERT INTO acfNT_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jézi diʼy, “Pyès moun ki koumansé fak yon mòso tè èk i toujou ka gadé dèyè, i pa kay sa sèvi anba kondwit Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Apwé sa Jézi apwenté swasant douz nonm épi i voyé yo alé avanʼy pa dé an tout sé vil-la èk vilaj-la i menm té ni pou alé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","I di yo, “Wékòt-la pawé, mé la pa ni asé twavayè. Mandé mèt wékòt-la pou i voyé twavayè pou anmasé wékòt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Alé! Mwen ka voyé zòt kon ti mouton anpami chyen mawon. ");
INSERT INTO acfNT_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Pa pwan lajan ni sak ni plis pasé yon pè soulyé. Pa doubout anlè lawout pou zòt di pyès moun bonjou. ");
INSERT INTO acfNT_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Lè zòt antwé andidan yon kay, pwèmyé bagay pou zòt di sé ‘Bennédiksyon pou tout moun ki an kay sala.’ ");
INSERT INTO acfNT_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Si yon nonm ki kontan lapé ka wèsté la, bennédiksyon-an kay wèsté anlèʼy. Si pa sa bennédiksyon-an kay viwé jwenn zòt. ");
INSERT INTO acfNT_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wèsté an menm kay sala, bwè èk manjé népòt sa yo ofè zòt, paski yon twavayè méwité péyé pou twavay li. Pa kité yon kay pou zòt alé wèsté andidan yon lòt. ");
INSERT INTO acfNT_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Lè zòt alé andidan yon vil èk yo byen wisivwè zòt, manjé sa sé jan plas-la ofè zòt. ");
INSERT INTO acfNT_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Djéwi tout sa ki malad èk di yo jou-a ja wivé pou Bondyé kondwi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Mé lè zòt antwé andidan yon vil èk yo pa wisivwè zòt, alé an chimen yo èk di yo, ");
INSERT INTO acfNT_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Jik lapousyè vil zòt-la ki pwi an pyé nou, nou ka soukwé kont zòt pou moutwé kon sa Bondyé pa plè èk sa zòt ka fè-a. Nou ja di zòt kon sa jou-a ja wivé pou zòt aksèpté kondwit Bondyé, mé zòt wifizé fè sa.’ ");
INSERT INTO acfNT_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Mwen ka di zòt, Bondyé kay pini sé jan vil Sòdonm-lan èk tout movèzté yo mwens pasé sé jan vil sala. ");
INSERT INTO acfNT_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Ki mizi téwib i kay téwib pou zòt, jan vil Korazin! Ki mizi téwib i kay téwib pou zòt osi, jan vil Bèfsayda! Si sé miwak sala ki fèt anpami zòt-la té fèt anpami sé jan vil Taya èk Sidon-an, ni lontan sé jan mové sala té kay ja asid èk yo té kay mété had ki fèt èk sak ki ka gwaté lapo anlè yo, èk mété sann difé anlè yo pou moutwé ki yo ja tounen hòd péché yo. ");
INSERT INTO acfNT_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Bondyé kay pini sé jan Taya èk Sidon-an mwens pasé i kay pini zòt asou jou jijman-an. ");
INSERT INTO acfNT_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Èk zòt, jan vil Kapènéyòm, zòt té vlé lévé mouté an syèl? Mé, non! Zòt kay tonbé an lanfè.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jézi di sé disip li-a, “Sa ki obéyiʼw obéyi mwen, sa ki widjèktéʼw widjèkté mwen, èk sa ki widjèkté mwen widjèkté moun-an ki voyé mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Sé swasant douz disip-la witounen ka widjèwté. Yo di, “Senyè, jik sé vyé lèspwi-a ka obéyi nou lè nou sèvi nonʼw!” ");
INSERT INTO acfNT_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jézi wéponn yo, “Mwen wè Satan ka tonbé sòti an syèl kon zéklè. ");
INSERT INTO acfNT_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Kouté! Mwen ja bay zòt pouvwa pou zòt pasé anlè sèpan èk èskoupyon, èk pou zòt sa kwazé tout pouvwa lèlmi-an. Anyen pa kay fè zòt mal. ");
INSERT INTO acfNT_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Mé, pa kontan paski sé vyé lèspwi-a obéyi zòt, mé pito paski non zòt wéjistwé an syèl.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Jézi tè ka widjèwté paski Lèspwi Bondyé té épiʼy, èk i koumansé pwédyé, “Papa mwen, mèt syèl èk latè, mwen ka wimèsyéʼw paski ou pwan bagay ou té ni kachté hòd jan ki ni endikasyon èk jan ki ni lasajès, èk ou moutwé jan ki pa ni endikasyon li. Mèsi Papa, paski sé sa ou té vlé fèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jézi di sé disip li-a, “Papa mwen ja mété tout bagay an lanmen mwen. Pyès moun pa vwéman konnèt ki moun Gason-an yé apa di Papa mwen, èk pyès moun pa vwéman konnèt ki moun Papa-a yé apa di mwen, Gason-an, èk sa mwen ja chwazi pou moutwé li.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lè Jézi èk sé disip li-a té pa kò yo, Jézi di yo, “I bon pou moun-an ki wè sé bagay sala zòt wè-a! ");
INSERT INTO acfNT_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Mwen ka di zòt, an chay pwòfèt èk wa té anvi wè sé bagay sala zòt wè-a mé yo pa té sa, èk yo té anvi tann sa zòt tann-an mé yo pa té sa.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Yon sèten titja lwa sé Jwif-la té ka éséyé kwennen Jézi. I mandéʼy, “Titja, ki sa mwen ni pou fè pou mwen ni lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jézi wéponn li, “Ki sa ki ékwi an lévanjil? Ki sa ou li andidanʼy?” ");
INSERT INTO acfNT_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nonm-lan wéponn, “ ‘Ou ni pou kontan Bondyé Senyèʼw èk tout tjèʼw, èk tout lam ou, èk tout kouway ou, èk tout lidéʼw,’ èk, ‘Ou ni pou kontan pwochenʼw menm kon ou kontan kòʼw.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jézi diʼy, “Sa ou di-a vwé. Alé èk fè sa épi ou kay ni lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Mé nonm-lan té vlé moutwé koté wépons Jézi pa té bon asé, kon sa i mandé Jézi, “Ki moun ki pwochen mwen?” ");
INSERT INTO acfNT_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Pou i té èspliké sa Jézi diʼy pawabòl sala, “La té ni yon Jwif ki té ka désann sòti Jérouzalèm pou i alé Jèriko. Yon konpanni vòlè tjenbéʼy, yo tiwé had li anlèʼy, yo bat li èk yo kitéʼy pwèskè mò épi yo alé. ");
INSERT INTO acfNT_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Kon sa yon pwèt sé Jwif-la té ka désann menm chimen-an, èk lè i wè nonm-lan a tè-a i pasé anlè lòt koté chimen-an. ");
INSERT INTO acfNT_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Èk osi yon nonm ki ka édé an Kay Bondyé té ka pasé, èk lè i wivé menm koté-a èk i wè nonm-lan a tè-a i pasé anlè lòt koté chimen-an. ");
INSERT INTO acfNT_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Mé yon nonm jan péyi Sanmariya té ka pasé épi i wè nonm-lan, èk lè i wè nonm-lan i di bay kòʼy, ‘Menm si nonm sala sé lèlmi mwen, mwen kay édéʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","I alé bòʼy épi i pansé sé koupé-a i té ni-an, i vidé lwil èk diven andidan yo épi i bandé yo ba li. Lè i fini i batjé nonm-lan anlè bouwik li épi i twouvé on plas moun té sa otjipéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Li denmen i pwan dé pyès dajan èk i bay sé moun-an sa. I di yo, ‘Mi, otjipé nonm sala, èk lè mwen ka pasé viwé mwen kay bay zòt sa zòt dépansé an plis.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Kon sa lè Jézi fini i di nonm-lan, “Kilès anpami twa sé nonm sala ou kwè ki sété pwochen nonm-lan sé vòlè-a bat-la?” ");
INSERT INTO acfNT_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Titja lwa sé Jwif-la wéponn li, “Nonm-lan i fè lapenn-an.” Jézi diʼy, “Alé èk fè menm bagay-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Kon Jézi èk sé disip li-a té anlè lawout yo, i antwé andidan yon sèten vilaj, èk yon madanm nonʼy sété Mafa wisivwèʼy an kay li. ");
INSERT INTO acfNT_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Èk Mafa té ni yon sésé nonʼy sété Mari, i asid an pyé Jézi ka kouté sa i té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Mafa té kontwayé kont tout sé twavay-la i té ni pou i fè-a. I vini di Jézi, “Mèt, ès ou pa mélé? Sésé mwen kité tout twavay-la anlè kont mwen pou mwen yonn fè! Diʼy vini édé mwen!” ");
INSERT INTO acfNT_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Jézi wéponn li, “Mafa, Mafa, ou ka twakasé èk kontwayéʼw pou twòp bagay, ");
INSERT INTO acfNT_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","mé sé yon sèl bagay ki nésésè, èk sé Mari ki ja chwazi sa ki pli bon-an, èk pyès moun pa kay pwanʼy lanmenʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Yon jou, Jézi té on koté ka pwédyé. Yonn an sé disip li-a di, “Mèt, moutwé nou ki mannyè pou nou pwédyé, menm kon Jan Batis té moutwé sé disip li-a pou pwédyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jézi di yo, “Lè ou ka pwédyé, di, ‘Bondyé Papa, nou ka pwédyé pou lézòm pòté nonʼw wèspé. Kité kondwit ou établi asou latè plis an plis. ");
INSERT INTO acfNT_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ban nou pen-an nou bizwen-an chak jou. ");
INSERT INTO acfNT_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pawdonnen nou pou péché nou, paski nou ka pawdonnen chak moun ki fè nou ditò. Pa kité nou twapé nou an tantasyon.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jézi di pou sé disip li-a, “Sipozé yon jou yonn anpami zòt alé lakay an kanmawad a mennwit èvèk ou di, ‘Jan mwen, ban mwen twa pen, ");
INSERT INTO acfNT_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","paski mwen ni on lòt kanmawad ki asou lawout épi i vini lakay mwen èk mwen pa ni anyen pou i manjé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Èvèk kanmawad-la ki andidan-an kay wéponn, ‘Pa anbété mwen, paski lapòt mwen ja laklé épi mwen épi ich mwen ja kouché ka dòmi. Mwen pa sa lévé pou mwen baʼw anyen.’ ");
INSERT INTO acfNT_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Bon, ki sa? Mwen ka diʼw, menm si i pa kay lévé épi baʼw pen-an paski i sé kanmawad ou, mé kanmenm i kay lévé èvèk i kay baʼw tout sa ou bizwen-an paski ou pa hont pou kontiné ka plédé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Èk mwen ka diʼw, mandé èk ou kay wisivwè, gadé èk ou kay jwenn, konyen èk lapòt-la kay ouvè baʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Tout moun ki mandé Bondyé kay wisivwè, tout sa ki gadé asou Bondyé pou sa i vlé kay jwenn li, èk Bondyé kay ouvè lapòt-la bay sa ki konyen. ");
INSERT INTO acfNT_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","La pa ni pyès papa anpami zòt ki kay bay gasonʼy an sèpan si i mandéʼy on pwéson. ");
INSERT INTO acfNT_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ében ès ou kay ba li yon èskoupyon si i mandéʼw on zé? Mé non! ");
INSERT INTO acfNT_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Èk si zòt ki mové konnèt mannyè pou bay ich ou bon kado, Papaʼw ki an syèl konnèt on chay plis pasé sa ki mannyè pou i bay Lèspwi Bondyé pou sa ki mandéʼy li.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jézi té ka tiwé yon vyé lèspwi andidan yon nonm. Vyé lèspwi-a té fè nonm-lan moumou, èk lè vyé lèspwi-a sòti, nonm-lan koumansé palé. Tout sé moun-an té étonnen, ");
INSERT INTO acfNT_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","mé yon konpanni moun té ka di, “Sé Bèlzibòb, chèf sé vyé lèspwi-a, ki ba li pouvwa pou i tiwé yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Yon lòt konpanni té vlé kwennen Jézi, kon sa yo mandéʼy pou i fè yon miwak. ");
INSERT INTO acfNT_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mé Jézi sav ki sa yo té ka katjilé èk i di yo pawabòl sala. I di, “Pyès péyi ki ni divizyon èk sé patizan-an ka goumen kont yonn a lòt, yo pa kay diwé pou lontan. Yon fanmi dépi i ni divizyon i kay tonbé. ");
INSERT INTO acfNT_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ès ou kwè ich Satan sa goumen épi yonn a lòt èk pou wéyòm li sa kontiné èkzisté? Mwen di sa paski zòt ka di mwen ka tiwé vyé lèspwi pa pouvwa Bèlzibòb. ");
INSERT INTO acfNT_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Mé si mwen ka tiwé vyé lèspwi pa pouvwa Bèlzibòb, pa ki pouvwa sé moun ou-a ka tiwé yo? Sé yo menm ki kay kondannéʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Mé mwen ka tiwé vyé lèspwi pa pouvwa Bondyé, èk sa ka diʼw ki Bondyé ja ka kondwi anpami zòt. ");
INSERT INTO acfNT_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Lè yon nonm ki fò èk byen amé ka gadé kay li, pozèsyonʼy ka an wipo. ");
INSERT INTO acfNT_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Mé lè yon nonm ki pli fò paséʼy atakéʼy èk i bat li, i ka pwan tout sé fèman-an nonm-lan kwè té kay pwotèktéʼy-la. Èk i ka sépawé tout sa i té pwan-an. ");
INSERT INTO acfNT_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Moun-an ki pa pou mwen-an kont mwen, épi moun-an ki pa ka édé mwen sanblé sé mouton-an ka simen yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Lè yon vyé lèspwi sòti andidan yon nonm i ka alé vini anlè tè sèk, i ka gadé pou yon plas pou i pozé. Si i pa jwenn yon plas, i ka di bay kòʼy, ‘Mwen kay viwé an kay-la mwen sòti-a.’ ");
INSERT INTO acfNT_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Lè i kay viwé i kay jwenn kay-la balyé èk tout bagay an plas mé kay-la vid toujou. ");
INSERT INTO acfNT_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Kon sa i kay sòti épi i kay mennen sèt vyé lèspwi ki pli mové paséʼy èk yo kay vini wèsté andidan nonm-lan, èk kon sa dènyé kondisyon-an nonm-lan andidanʼy-lan pli mové pasé pwèmyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Kon Jézi té ka di sé bagay sala, yon madanm ki té anpami sé moun-an andjélé, “Manman sala ki fèʼw-la èk ki baʼw tété-a benni!” ");
INSERT INTO acfNT_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jézi wéponn li, “Wi, mé moun-an ki ka tann pawòl Bondyé èk ki ka obéyiʼy-la benni plis.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","An chay moun té ka konblé Jézi. Jézi di, “Jan jòdi mové! Yo ka mandé pou yon miwak, mé sé sèl miwak yo kay jwenn sé miwak-la Jonna moutwé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Menm mannyè-a lavi pwòfèt Jonna sété yon miwak pou sé jan vil Ninivè-a wè, sé kon sa lavi mwen, Gason Lézòm, kay yon miwak pou sé jan jòdi-a. ");
INSERT INTO acfNT_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Asou jou jijman-an wenn péyi Chiba kay lévé doubout èk i kay akizé sé jan jòdi-a, paski i voyajé byen lwen pou i kouté pawòl savan Sòlomonn. Èk apwézan, la ni yon moun ki pli enpòtan pasé Sòlomonn isi-a, èk zòt pa ka moutwéʼy pyès wèspé. ");
INSERT INTO acfNT_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Asou jou jijman-an sé jan Ninivè-a kay lévé doubout èk akizé zòt paski yo té wépanti yo lè Jonna té pwéché ba yo. Èk apwézan la ni yon moun ki pli enpòtan pasé Jonna isi-a, èk pyès moun pa ka koutéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Pyès moun pa kay limen yon lanp èk météʼy yon plas koté i kay séwé, ében météʼy anba yon bonm. Pito i kay météʼy anlè yon létajè pou tout moun sa wè klè kon yo antwé. ");
INSERT INTO acfNT_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Zyéʼw sé kon yon lanp pou kòʼw. Lè zyéʼw ka wè byen, tout kòʼw ni klèté, mé lè zyéʼw pa ka byen wè, tout kòʼw kay an nwèsè. ");
INSERT INTO acfNT_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Kon sa fè asiwé ki ou ni klèté an kòʼw èk sé pa nwèsè. ");
INSERT INTO acfNT_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Kon sa si tout kòʼw plen èk klèté Bondyé, ou kay konplètman an klèté, akwèdi sé yon gwo lanp ki ka kléwé anlèʼw èk tout klètéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Lè Jézi fini palé, yon Fawizyen envitéʼy pou i manjé épiʼy. Kon sa i alé andidan kay li èk i asid pou i manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Fawizyen-an té sipwi lè i wè ki Jézi pa lavé lanmenʼy avan i manjé kon lwa sé Jwif-la di yo pou yo fè. ");
INSERT INTO acfNT_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Kon sa Jézi diʼy, “Zòt Fawizyen, zòt ka nétwayé pòt-la èk pla-a an dèwò yo, mé andidan zòt plen èk vowasité épi movèzté. ");
INSERT INTO acfNT_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Zòt kouyon! Ès zòt pa sav Bondyé entéwésé an sa ki an tjè zòt menm kon i entéwésé an sa zòt ka fè-a an lavi zòt? ");
INSERT INTO acfNT_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Mé bay lé pòv sa ki an pòt zòt èk an pla zòt, èk tout bagay kay nèt. ");
INSERT INTO acfNT_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Ki mizi téwib i kay téwib pou zòt Fawizyen! Zòt ka bay Bondyé dis pou san jik an sé piti ti bagay-la zòt ni-an kon ti diten ében lanmant fanm, mé zòt ka néglijé jistis èk lanmou pou Bondyé. Tout sé bagay sala zòt ni pou mété an pwatik, san néglijé lézòt. ");
INSERT INTO acfNT_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Ki mizi téwib i kay téwib pou zòt Fawizyen! Zòt kontan asid an plas-la ki pli enpòtan-an an légliz zòt, èk zòt kontan pou tout moun di zòt ‘Bonjou’ èk gwan wèspé lè zòt ka maché an piblik. ");
INSERT INTO acfNT_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Ki mizi téwib i kay yé pou zòt! Zòt kon yon fòs moun mò ki séwé èk moun ka maché anlèʼy san yo sav ki bagay santi ki andidanʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yonn an sé titja lwa sé Jwif-la di Jézi, “Titja, ou ka ensilté nou osi lè ou di sé bagay sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Jézi wéponn li, “Ki mizi téwib i kay téwib pou zòt osi, titja lwa sé Jwif-la! Lè zòt ka enstwi sé moun-an an pawòl Bondyé, zòt ka mété chay ki byen lou anlè yo pou yo débat pòté, èk zòt pa pawé pou zòt touché sé chay sala zòt menm. ");
INSERT INTO acfNT_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","Ki mizi téwib i kay téwib pou zòt. Zòt fè bèl plas pou téwé sé pwòfèt-la, menm sé pwòfèt-la sé gwan gwanpapa zòt-la tjwé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Kon sa zòt menm ka moutwé ki zòt dakò épi sa sé gwan gwanpapa zòt-la fè-a, paski yo tjwé sé pwòfèt-la èk zòt fè tonbo ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Bondyé té sav sa té kay fèt, èk sé pou sa i di, ‘Mwen kay voyé pwòfèt èk konmisyonnè ba yo, èk yo kay tjwé yon konpanni èk pèsikité lézòt.’ ");
INSERT INTO acfNT_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Kon sa jan jòdi kay wèskonsab pou san tout sé pwòfèt-la ki koulé-a dépi an koumansman latè-a, ");
INSERT INTO acfNT_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","dépi lanmò Ébèl pou lanmò Zèkaraya ki mò an Kay Bondyé ant lotèl-la èk plas-la koté pwézans Bondyé té ka wèsté-a. Wi, mwen di zòt, jan jòdi kay wèskonsab pou tout sa. ");
INSERT INTO acfNT_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Ki mizi téwib i kay téwib pou zòt titja lwa sé Jwif-la! Zòt ki sipozé konnèt mèyè pou enstwi sé moun-an ki mannyè pou yo vini koté yo kay sa apwann pawòl Bondyé, sé zòt menm ki fèmé lapòt-la asou yo. Zòt pa vlé konpwann li épi zòt ka anpéché lòt moun konpwann li osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lè Jézi kité plas-la, sé titja lwa sé Jwif-la èk sé Fawizyen-an koumansé kwititjéʼy an chay èk yo koumansé ka mandéʼy kwèsyon konsèné an chay bagay. ");
INSERT INTO acfNT_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Yo té ka éséyé tjenbéʼy ka di yon bagay ki pa bon. ");
INSERT INTO acfNT_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Lè sala, la té ni an chay moun pyès moun pa té sa konté. La té ni tèlman moun yo té ka pilé yonn a lòt. Jézi di sé disip li-a, “Pwan gad pou sé Fawizyen-an. Mannyè ipokwit yo ka lévé kon lèlven ki an lapat. ");
INSERT INTO acfNT_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Mé sa ki kouvè kay dékouvè, èk tout sigwé kay sòti. ");
INSERT INTO acfNT_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Kon sa tout sa ou ja di an fè nwè, moun kay tann li an gwan klèté, èk anyen ou ja souflé an zòwèy nonm an sigwé, moun kay andjéléʼy anlè tèt kay-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Mwen ka diʼw, jan mwen, pa pè sé sa ki kay tjwé kò-a tousèl, mé lè yo fini yo pa sa fè anyen ankò. ");
INSERT INTO acfNT_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Mwen kay moutwéʼw ki moun pou ou pè. Sé Bondyé pou ou pè — apwé Bondyé fini tjwéʼw i ni pouvwa pou jétéʼw an lanfè. Wi mwen diʼw, sé Bondyé pou ou pè. ");
INSERT INTO acfNT_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Mé tout moun sav senk ti jibyé vo dé kat sou. Èk pa yonn anpami yo Bondyé kay obliyé. ");
INSERT INTO acfNT_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Bondyé jis sav konmen bwanch chivé ki anlè tèt ou. Kon sa ou pa ni pou pè lézòt moun, paski ou vo plis pasé an chay jibyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Mwen ka diʼw, moun-an ki di i konnèt mwen douvan lézòm, sé li mwen, Gason Lézòm, kay osi di mwen konnèt douvan sé nanj Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Mé moun-an ki widjèkté mwen an piblik, Gason Lézòm kay widjèktéʼy douvan sé nanj Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Pyès moun ki di yon mo pawòl kont mwen, Gason Lézòm, Bondyé sa pawdonnenʼy. Mé moun-an ki ensilté Lèspwi Bondyé-a, Bondyé pa kay pawdonnenʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Lè yo mennenʼw lalwa an légliz sé Jwif-la ében douvan sé ofisyé gouvèdman-an, pa katjilé ki sa ou kay di ében ki mannyè ou kay diʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","paski Lèspwi Bondyé kay enstwiʼw a lè sala ki sa pou ou di.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Yon nonm anpami sé gany moun-an ki té la-a di Jézi, “Titja, di fwè mwen pou sépawé épi mwen popyétè-a papa nou kité ban nou lè i mò.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jézi wéponn, “Gadé mwen, nonm! Sa sé pa twavay mwen pou jijé ében pou mwen sépawé popyétè bay zòt dé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Èk i di yo, “Fè antansyon èk pwan gad pou tout kalité vowasité. Londjè épi valè lavi yon nonm pa ka dépan anlè ki mizi wichès i ni, menm si i ni an chay.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Èk i di yo pawabòl sala, “La té ni yon nonm ki té wich, èk tèʼy té ka ba li yon bon wékòt. ");
INSERT INTO acfNT_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","I di bay kòʼy, ‘Ki sa mwen kay fè? Mwen pa ni koté pou mwen mété wékòt mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Kon sa i di, ‘Mi, sé sa mwen kay fè. Mwen kay kwazé sé kay-la mwen ja ni ka mété wékòt mwen-an èk mwen kay fè sa ki pli gwan, èk la mwen kay mété gwenn èk lèstan sé bagay mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Èk mwen kay di kò mwen, “Gason, ou chansé! Ou ni an chay bon bagay séwé pou an chay tan. Viv laviʼw ézé, manjé, bwè èk ni yon bon tan.” ’ ");
INSERT INTO acfNT_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Mé Bondyé diʼy, ‘Kouyon, òswè-a menm lam ou kay kitéʼw. Kon sa ki moun ki kay jwenn sé bagay-la ou ja pwépawé bay kòʼw-la?’ ");
INSERT INTO acfNT_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Sé kon sa i kay yé èk moun-an ki ka sanblé wichès pou kòʼy, mé i pa ni pyès konfyans an Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Kon sa Jézi di sé disip-la, “Pa katjilé asou manjé-a ou bizwen pou viv-la ében asou had-la ou bizwen pou kouvè kòʼw. ");
INSERT INTO acfNT_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Ès ou pa kwè lavi-a Bondyé ja ba ou-a vo plis pasé sa ou ni pou manjé, épi kò-a Bondyé ja ba ou-a vo plis pasé sé had-la ou ni pou pòté-a? ");
INSERT INTO acfNT_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Gadé sé mèl-la. Yo pa ka planté ni yo pa ni koté pou yo séwé manjé yo, é Bondyé ka ba yo manjé. Èk ki mizi valè ou ni pasé sé jibyé-a? ");
INSERT INTO acfNT_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Èk apa di sa, ki syans pou ou katjilé? Ki sa sa kay fè baʼw? Ès katjilé kay sa ajouté yon nèditan asou laviʼw? Mé non! ");
INSERT INTO acfNT_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Si zòt pa sa fè an ti bagay kon sa, pouki pou zòt ka katjilé asou sé lézòt bagay sala? ");
INSERT INTO acfNT_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Gadé sé flè-a, mannyè yo ka pwofité. Yo pa ka twavay ni yo pa ka fè had pou kò yo, mé mwen ka diʼw pa menm Wa Sòlomonn an tout wichès li ki té sa abiyé otan bèl kon yonn anpami yo. ");
INSERT INTO acfNT_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Si Bondyé ka abiyé sé zèb-la ou ka wè jòdi-a, èk tan pou denmen yo ja mò èk jété andidan an fou pou bwilé, ès ou pa kwè Bondyé kay véwitabman abiyéʼw? Ében, lafwaʼw tèlman pé! ");
INSERT INTO acfNT_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Pa twakasé tjèʼw asou ki sa ou kay manjé ében bwè, pa katjilé asouʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Sé moun ki pa ka kwè an Bondyé ki ka twakasé kò yo konsèné sé bagay sala, mé Papaʼw ki an syèl sav ou bizwen tout sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Obéyi kondwit Bondyé, èk Bondyé kay baʼw tout lòt bagay. ");
INSERT INTO acfNT_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Pa pè, menm si la pa ni an chay di zòt, paski Papa-a ki an syèl-la ja chwazi pou fè zòt wa menm kon li menm. ");
INSERT INTO acfNT_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Vann tout byen zòt èk sépawé lajan-an bay lé pòv. Èk mannyè sala ou kay potjiwé kòʼw lajan ki pa kay janmen fini, kon yon twézò ki an syèl ki kay diwé pou tout tan, koté pyès vòlè pa kay jwenn li ni poul bwa pa kay détwiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Paski koté wichès ou yé, sé la lidéʼw kay yé osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Èk Jézi di yo pawabòl sala, “Ou toujou ni pou pwépawé kòʼw pou lè mwen kay witounen, ");
INSERT INTO acfNT_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","kon sèvant ki ka èspéyé mèt yo witounen sòti adan yon fèt mawiyaj. Kon sa lè i vini èk i konyen, yo kay sa ouvè lapòt-la ba li la menm. ");
INSERT INTO acfNT_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","I té kay bon pou sé sèvant sala si mèt yo té kay jwenn yo pa ka dòmi èk yo pawé pou lè i witounen. Mwen ka di zòt lavéwité, mèt sala té kay abiyé pou i bay sé sèvant li-a manjé. I té kay fè yo asid bò tab-la èk i té kay vini ba yo manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","I té kay bon pou sé sèvant sala pou mèt yo jwenn yo ka èspéyéʼy, menm si i vini ta kon mennwit ében pli ta. ");
INSERT INTO acfNT_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Èk chonjé sa! Si mèt kay-la té sav ki lè vòlè-a té kay kasé kay li, i pa té kay kité vòlè-a antwé an kay-la. ");
INSERT INTO acfNT_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Èk zòt osi, pwépawé zòt pou wisivwè mwen, paski mwen, Gason Lézòm, kay vini lè ou pa kay èspéyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pita mandéʼy, “Senyè, ès ou ka di pawabòl sala ban nou ében bay tout moun?” ");
INSERT INTO acfNT_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Jézi wéponn li, “Kilès anpami zòt ki sé yon kolonm ki ni lèspwi èk yo sa dépan anlèʼy? Sé li mèt li té kay mété an chaj sé lézòt sèvant li-a pou i ba yo manjé a lè. ");
INSERT INTO acfNT_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","I té kay bon pou kolonm sala si mèt li jwenn li ka fè twavay sala lè i witounen. ");
INSERT INTO acfNT_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Mwen ka diʼw lavéwité, i té kay météʼy an chaj tout popyétèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Mé si kolonm-lan di bay kòʼy, ‘Mèt mwen ka pwan an chay tan pou i viwé,’ èk i koumansé ka bat sé sèvant-lan, ni sé nonm-lan ni sé madanm-lan, èk i manjé épi i bwè èk i sou, ");
INSERT INTO acfNT_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","lè sala mèt-la kay witounen yon jou lè kolonm-lan pa ka èspéyé èk yon lè i pa kay sav. Mèt li kay bat li mové èk voyéʼy an plas-la yo ka voyé sé moun-an ki pa ka kwè an Bondyé-a pou jwenn pinisyonʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Sèvant-lan ki sav ki sa mèt li vlé i fè-a mé i pa ka pwépawéʼy pou i fèʼy kay pwan an chay kou pou pinisyonʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Mé sèvant-lan ki pa sav ki sa mèt li vlé-a, èk i fè yon bagay ki méwité pou i pwan yon volé, i kay jwenn yon ti volé. Nonm-lan yo bay an chay-la yo kay mandéʼy an chay viwé. Nonm-lan ki wisivwè pli-a, yo kay èspéyé an chay plis viwé.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Mwen vini mennen difé asou latè-a èk mwen anvi i té ja ka bwilé. ");
INSERT INTO acfNT_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Paski mwen ni yon soufwans ki téwib pou mwen wisivwè èk i ka chagwinen mwen tout tan i pa fini. ");
INSERT INTO acfNT_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ès ou kwè mwen vini établi lapé asou latè? Non, mwen pa vini établi lapé, mé pito mwen vini pou mwen sa fè sé moun-an divizé kont yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Dépi apwézan sala si la kay ni senk moun adan yon fanmi, yo kay divizé kont yonn a lòt, èk twa kay hayi dé èk dé kay hayi twa. ");
INSERT INTO acfNT_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Papa kay tounen kont gason yo èk gason kay tounen kont papa yo. Manman kay tounen kont fi yo èk fi kay tounen kont manman yo. Bèlmè kay tounen kont bèlfi yo, èk bèlfi kay tounen kont bèlmè yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jézi di sé moun-an, “Lè zòt wè tan-an mawé, la menm zòt ka di lapli kay tonbé, èk i ka fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Èk lè zòt pa wè pyès nwaj an syèl-la, èk van-an pa ka vanté, zòt ka di i kay fè cho, èk i ka fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Zòt ipokwit! Zòt sa gadé latè-a èk syèl-la èk sav ki sa yo vlé di, mé zòt di zòt pa sa wè ki mannyè Bondyé ka twavay an sé jou sala. ");
INSERT INTO acfNT_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Pouki zòt pa ka katjilé asou sé bagay sala zòt ka wè-a èk désidé pou kò zòt sa ki mèyè pou zòt fè?” ");
INSERT INTO acfNT_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","I di, “Sé kon sa i yé — si yon nonm pòté plent kont ou èk i mennenʼw lodyans, fè sa ou pé pou ou pwan wanjman épiʼy padan zòt anlè chimen toujou, kon sa i pa kay mennenʼw douvan jij-la pou jij-la fè polis-la awétéʼw èk météʼw lajòl. ");
INSERT INTO acfNT_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Mwen ka diʼw, ou pa kay sòti la tout tan ou pa péyé dènyé dé sou ou ka dwé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Tan sala la té ni déotwa moun ki di Jézi kon sa Pons Pilat, Gouvènè Joudiya, té tjwé yon konpanni jan Galili padan yo té ka fè sakwifis bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jézi mandé yo, “Ès si zòt kwè lè sé moun sala mò kon sa, sa ka moutwé ki sé pli mové yo té pli mové péchè pasé sé lézòt jan péyi Galili-a? ");
INSERT INTO acfNT_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Awa! Mé mwen ka di zòt, si zòt pa wépanti zòt, zòt tout kay péwi menm kon yo. ");
INSERT INTO acfNT_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Èk ki sa zòt kay di konsèné sé dizywit moun-an ki mò lè gwo kay Silowanm-lan tonbé anlè yo? Ès zòt kwè sa ka moutwé ki yo pli koupab pasé sé jan Jérouzalèm-lan? ");
INSERT INTO acfNT_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Awa! Mwen ka di zòt, si zòt pa wépanti zòt, zòt tout kay péwi osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Èk Jézi di yo pawabòl sala, “Yon nonm té ni yon pyé fwitaj an jadenʼy. I toujou té ka gadé pou fwi anlèʼy mé i pa ka jwenn pa menm yonn. ");
INSERT INTO acfNT_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Kon sa i di jèwè jaden-an, ‘I ni twa lanné mwen ka gadé pou fwi anlè pyé sala èk mwen pʼòkò jwenn pa menm yonn. Koupéʼy! Pouki pou nou kitéʼy la ka pwan sistans tè-a.’ ");
INSERT INTO acfNT_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Mé jèwè jaden-an diʼy, ‘Mèt, kitéʼy pou yon lòt lanné ankò èk mwen kay fouyé yon kannal oliwonʼy èk mété fimyé oliwonʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Si i pòté fwi lòt lanné, sa bon, mé si i pa pòté, mwen kay koupéʼy.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Yon jou sabaf Jézi té ka enstwi an légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","La té ni yon madanm ki té ni yon vyé lèspwi andidanʼy ki fèʼy malad pou dizywit lanné. I fèʼy koubé èk i pa té sa doubout dwèt pyès. ");
INSERT INTO acfNT_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Lè Jézi wèʼy i kwiyéʼy vini èk i diʼy, “Madanm, maladiʼw ja djéwi.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","I mété lanmenʼy anlè madanm-lan, èk la menm i doubout dwèt èk i glowifyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Chèf légliz sé Jwif-la té faché paski Jézi djéwi yon moun anlè jou sabaf-la. Kon sa i lévé vwaʼy èk i di sé moun-an, “La ni sis jou pou twavay, kon sa vini padan sé jou sala pou zòt djéwi, mé pa vini anlè jou sabaf-la!” ");
INSERT INTO acfNT_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jézi wéponn li, i di, “Zòt ipokwit! Zòt népòt té kay démawé bèf zòt ében bouwik zòt èk mennenʼy bwè dlo anlè jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Mi madanm sala sé désandan Abrahanm. Satan tjenbéʼy an pwizon pou dizywit lanné èk yon maladi. Ès i pa bizwen délivwé hòd maladiʼy anlè jou sabaf-la?” ");
INSERT INTO acfNT_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Wépons li-a fè tout sé lèlmiʼy-lan hont, padan tout sé lézòt moun-an té ka widjèwté pou tout sé bèl bagay-la i té ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jézi mandé yo, “Lè Bondyé ka kondwi, kon ki sa ou kay di i yé? ");
INSERT INTO acfNT_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","I menm kon yon piti ti gwenn moutad on nonm planté an jadenʼy. Gwenn-an pwofité èk fè on gwo pyé bwa, èk jibyé vini fè nich an bwanch li.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Èk i mandé yo ankò, “Lè Bondyé ka kondwi, kon ki sa ou kay di i yé? ");
INSERT INTO acfNT_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","I sé menm kon lèlven yon madanm pwan èk météʼy èvèk an gwan kantité fawin fwans jis tan tout lapat-la mouté.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Èk Jézi pasé an sé vil-la èk vilaj-la ka enstwi sé moun-an padan i té asou chimen ka alé Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Yon moun mandé Jézi, “Senyè, ès sé déotwa moun tousèl ki Bondyé kay sové?” Jézi di sé moun-an, ");
INSERT INTO acfNT_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Lapòt-la pou antwé an syèl-la étwèt. Débat pou antwé adanʼy, paski mwen ka diʼw an chay moun kay éséyé antwé èk yo pa kay sa. ");
INSERT INTO acfNT_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Dépi mèt kay-la lévé èk laklé lapòt-la, zòt kay doubout dèwò-a ka konyen èk plédé, ‘Mèt, ouvè lapòt-la ban nou.’ Mé i kay wéponn, ‘Mwen pa ni konnèt zòt ében koté zòt sòti.’ ");
INSERT INTO acfNT_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Zòt kay di, ‘Nou manjé èk bwè épiʼw èk ou enstwi an vil nou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Mé i kay wéponn, ‘Mwen pa konnèt zòt ében koté zòt sòti. Alé, sòti bò mwen, paski zòt tout sé moun ki méchan.’ ");
INSERT INTO acfNT_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Lè zòt kay wè Abrahanm, Ayzak, épi Jakòb èk tout sé pwòfèt-la épi Bondyé koté i kay kondwi-a èk zòt menm wèsté dèwò, zòt kay tèlman kontwayé zòt kay pléwé èk kwatjé dan zòt. ");
INSERT INTO acfNT_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Moun kay sòti an tout pawès latè-a pou vini an fèt-la lè Bondyé kay kondwi-a. ");
INSERT INTO acfNT_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Sé pou sa mwen ka di zòt ki tan sala la kay ni yon konpanni moun ki dènyé apwézan, yo kay vini pwèmyé, èk la kay ni yon konpanni ki pwèmyé apwézan, yo kay vini dènyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","La menm yon konpanni Fawizyen vini oti Jézi èk yo diʼy, “Simyé ou sòti isi-a èk alé yon lòt koté, paski Hèròd vlé tjwéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jézi di yo, “Alé di sèpan sala, ‘Mi, mwen ka tiwé vyé lèspwi èk mwen ka djéwi moun pou yon ti mouman, èk apwé sa twavay mwen kay fini.’ ");
INSERT INTO acfNT_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Sé fo mwen kontiné lawout mwen jòdi, denmen èk apwé denmen. Mwen ni pou alé Jérouzalèm pou mwen mò. Ès sé pa la zòt ka tjwé pwòfèt? ");
INSERT INTO acfNT_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“Aa, zòt jan Jérouzalèm! Zòt tjwé sé pwòfèt-la èk zòt bouwé sé konmisyonnè-a Bondyé té voyé bay zòt-la èk wòch. Plizyè fwa mwen té vlé mété lanmen mwen oliwon zòt, menm kon yon manman poul ka kouvè pitiʼy anba zèl li, mé zòt pa ka kité mwen fèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Apwézan plas-la koté zòt ka wèsté-a, Bondyé pa ni anyen pou fè épiʼy ankò. Mwen ka di zòt, zòt pa kay wè mwen tout tan lè-a pa vini lè zòt kay di, ‘Bennédiksyon pou nonm-lan Bondyé ja voyé-a.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Yon jou sabaf Jézi alé manjé lakay yonn an sé chèf Fawizyen-an, èk sé moun-an té ka véyé Jézi byen. ");
INSERT INTO acfNT_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","La té ni yon nonm ki té vini oti Jézi, i té ni dé janm li èk bwaʼy anflé. ");
INSERT INTO acfNT_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jézi mandé sé titja lwa sé Jwif-la èk sé Fawizyen-an, “Ès lwa nou ka di nou sa djéwi anlè jou sabaf-la, ében ès i di non, pa fè sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Mé yo pa té sa di anyen. Jézi pwan nonm-lan, i djéwiʼy épi i diʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Jézi mandé yo, “Si zòt pyès té ni yon gason ében yon bèf ki tonbé andidan yon pi, ès zòt pa té kay hédiʼy sòti la menm, menm anlè jou sabaf-la?” ");
INSERT INTO acfNT_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mé yo pa té sa wéponn sa. ");
INSERT INTO acfNT_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Lè Jézi wè mannyè sé moun-an ki té envité pou manjé-a té ka chwazi sé plas-la ki pli enpòtan-an pou yo asid, i di pawabòl sala ba yo tout. ");
INSERT INTO acfNT_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Lè yon moun envitéʼw adan yon fèt mawiyaj, pa asid an plas-la ki pli enpòtan-an. Pitèt yon moun ki pli enpòtan paséʼw té envité, ");
INSERT INTO acfNT_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","èk mèt fèt-la ki envité zòt toulé dé-a kay vini èk diʼw, ‘Ba li plas sala.’ Lè sala ou kay hont èk ou kay ni pou asid adan yon lòt plas ki mwens enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Pito, lè on moun envitéʼw adan yon fèt, alé èk asid koté-a ki mwens enpòtan-an. Kon sa mèt fèt-la kay diʼw, ‘Vini, jan mwen, adan yon plas ki pli mèyè!’ Sa kay baʼw lonnè wèspé an zyé lézòt sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Paski tout moun ki ka lévé kò yo anlè kay abésé, èk tout moun ki abésé kò yo, Bondyé kay lévé yo mouté.” ");
INSERT INTO acfNT_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Kon sa Jézi di mèt fèt-la, “Lè ou bay yon déjinen ében yon dinen, pa envité janʼw ében fwèʼw ében lafanmiʼw ében sé vwézinaj ou-a ki wich-la, paski yo kay envitéʼw déviwé èk an mannyè sala yo kay péyéʼw pou sa ou fè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Lè ou bay yon fèt, envité lé maléwé, sé enfimité-a, sé sa ki ka bwété-a èk sé avèg-la ");
INSERT INTO acfNT_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","èk ou kay ni bennédiksyon, paski yo pa sa péyéʼw déviwé. Bondyé kay péyéʼw lè sé bon moun-an kay wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Lè yonn anpami sé nonm-lan ki té ka asid a tab épiʼy-la tann sa, i di Jézi, “Lè Bondyé kay kondwi toupatou èk i kay tjenn fèt li, nonm sala i kay envité-a kay viv éwé!” ");
INSERT INTO acfNT_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Mé Jézi di yo, “La té ni on nonm ki bay an gwan fèt èk i envité an chay moun. ");
INSERT INTO acfNT_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Lè i té lè pou fèt-la koumansé i voyé sèvant li di sé moun-an i té envité-a, ‘Vini. Tout bagay ja pawé apwézan.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","“Mé lè i alé yo tout koumansé ka fè èskiz. Pwèmyé-a di, ‘Mwen genyen an mòso tè èk mwen ni pou alé wèʼy. Souplé èskizé mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","“An lòt di, ‘Fini mwen fini achté dis towo bèf. Mwen ni pou ay ègzanminé yo. Souplé èskizé mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","“Èk lòt-la di, ‘Fini mwen fini mayé, èk sé pou wézon sala mwen pa sa vini.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Kon sa sèvant-lan viwé épi i alé di mèt li sa. Mèt-la té faché èk i diʼy, ‘Alé an tout gwan chimen èk an tout ti chimen an vil-la èk mennen isi-a tout pòv, tout sa ki enfim, tout avèg.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","“Apwé i fini, sèvant-lan di mèt li, ‘Mwen ja fè tout sa ou di mwen fè èk la ni lè toujou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","“Kon sa mèt-la di sèvant-lan, ‘Alé an bitasyon-an an tout gwan chimen èk tout ti twas èk fè sé moun-an vini, pou kay mwen sa plen. ");
INSERT INTO acfNT_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Èk mwen ka di zòt sa, pa yonn adan sé moun-an mwen té envité avan-an ki kay gouté manjé-a mwen pwépawé pou fèt sala.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","An chay moun té ka alé ansanm épi Jézi. I tounen épi i di yo, ");
INSERT INTO acfNT_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Pyès moun ki vini oti mwen pa sa disip mwen tout tan i pa kontan mwen plis pasé papaʼy, manmanʼy, madanm li, ich li, fwèʼy ében séséʼy, èk pasé kò i menm. ");
INSERT INTO acfNT_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Moun-an ki pa pwan kwaʼy épi swiv mwen-an pa sa on disip mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Sé kon sa i yé, si yonn anpami zòt vlé bati yon gwo kay, ou kay asid èk katjilé konmen lajan i kay koutéʼw pou wè si ou kay ni asé lajan pou fini twavay sala. ");
INSERT INTO acfNT_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Si ou pa fè sa èk ou pa sa fini gwo kay sala apwé ou fini fondasyon-an, tout moun ki wè sa ki fèt-la kay pwanʼw sèvi widitjil. ");
INSERT INTO acfNT_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","Yo kay di, ‘Nonm sala koumansé bati yon gwo kay mé i pa sa fini twavay-la.’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ében si yon wa alé èk dis mil sòlda pou goumen èk yon lòt wa ki ni ven mil sòlda, wa-a ki ni mwens sòlda kay asid avan èk gadé si sé sòldaʼy-la kay sa goumen kont sé sòlda lòt wa-a. ");
INSERT INTO acfNT_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Si yo pa fò asé pou yo fè sa, i kay voyé konmisyonnè alé oti lòt wa-a padan i yon bon distans ka vini, pou mandéʼy, ‘Ki sa pou nou fè pou mété lapé?’ ");
INSERT INTO acfNT_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Èk an menm mannyè-a ou ni pou katjilé asou sa ki ka wivéʼw, paski pyès moun pa sa disip mwen tout tan i pa kité tout sa i ni pou swiv mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Paski sé moun mwen-an, yo menm kon sèl, èk zòt tout sav ki sèl sé on bagay ki bon, mé si sèl-la pèd sistans li la pa ni pyès mannyè pou fèʼy salé ankò. ");
INSERT INTO acfNT_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","I pa menm bon pou mété an tè ében pou mété adan fimyé, sé jété pou jétéʼy. Zòt tout sa ki la-a, si zòt ni zòwèy pou tann, kouté byen sa mwen ka di zòt-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yon fwa an chay nonm ki ka anmasé taks bay gouvèdman èk lézòt péchè vini kouté Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Sa ensilté sé Fawizyen-an èk sé titja lwa sé Jwif-la, èk yo koumansé ka bougonnen, yo di, “Jézi ka wisivwè péchè èk i ka manjé épi yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mé Jézi di yo pawabòl sala, ");
INSERT INTO acfNT_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Sipozé yonn anpami zòt ni yon san mouton èk i wè yonn ka mantjé, ki sa i kay fè? Ès i pa kay kité lèstan mouton-an an savann-an èk alé gadé pou yon sèl mouton-an ki ka mantjé-a jis tan i jwenn li? ");
INSERT INTO acfNT_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Lè i jwenn li i kay kontan tèlman i kay météʼy anlè zépòl li ");
INSERT INTO acfNT_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","èk pòtéʼy alé lakay li. Lè sala i kay kwiyé janʼy èk vwézinaj li ansanm, èk i kay di yo, ‘Mwen kontan mwen jwenn mouton mwen-an ki té ka mantjé-a. Annou sélébwé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Mwen ka di zòt, sa ki an syèl kay wéjwi paski yon péchè wépantiʼy plis pasé yo kay wéjwi pou tout sé moun-an ki ka kwè yo pa bizwen wépanti yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Ében sipozé yon madanm ni dis pyès dajan, èk yonn adan yo pèd, ki sa i kay fè? I kay limen yon lanp èk i kay balyé tout ti kwen kay-la ka chaché pou li jis tan i jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Èk lè i jwenn li i kay kwiyé janʼy èk vwézinaj li ansanm èk di yo, ‘Mwen tèlman kontan mwen jwenn pyès dajan mwen-an ki té pèd-la! Annou sélébwé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Mwen ka di zòt, sé kon sa sé nanj Bondyé-a ka widjèwté paski yon péchè wépanti.” ");
INSERT INTO acfNT_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jézi kontiné ka palé ba yo épi i di yo an lòt pawabòl. I di, “La té ni on papa ki té ni dé gason. ");
INSERT INTO acfNT_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","On jou pli jenn-an alé épi i di papaʼy i vlé tout sa ki ka vini pou li an popyétè-a. Papaʼy sépawé popyétè-a épi i ba li paʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Apwé sa gason-an lévé èk i pwan tout sa i té ni èk i pati adan an lòt koté ki té byen lwen. “Lè i wivé an plas-la, i gaspiyé tout sa i té ni an vyé lavi vakabon. ");
INSERT INTO acfNT_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Apwé i fini gaspiyé tout bagay, an gwan lafen koumansé an plas-la. I vini fen èk i té maléwé. ");
INSERT INTO acfNT_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","I alé mandé twavay lakay on nonm an plas-la. Nonm-lan voyéʼy ay bay kochon manjé. ");
INSERT INTO acfNT_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Padan i ka otjipé sé kochon-an, i santi i té fen tèlman i té sa manjé manjé kochon-an, mé pyèsonn pa ba li anyen. ");
INSERT INTO acfNT_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Lè i katjilé, i di, ‘Gadé sèvant ki lakay papa mwen. Yo ni plis pou yo manjé pasé yo sa fini manjé, èk mwen menm isi-a ka mò fen. ");
INSERT INTO acfNT_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Mwen kay lévé èk mwen kay viwé lakay papa mwen èk mwen kay diʼy, “Papa, mwen péché kont ou épi kont Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","èvèk mwen pa vo pou ou gadé mwen kon gasonʼw ankò. Fè mwen kon sèvant ou.” ’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“I lévé èk i viwé lakay papaʼy. Mé lè i té on distans hòd kay papaʼy, papa-a wèʼy èk i té ni konpasyon asouʼy, i kouwi jwenn li èk i anbwaséʼy èk i boʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Gason-an di papaʼy, ‘Mwen péché kont Bondyé èk kont ou. Mwen pa vo pou ou gadé mwen kon gasonʼw ankò.’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mé papa-a kwiyé sé sèvant li-a èk i di yo, ‘Pòté pli mèyè had-la èk météʼy asouʼy. Mété on bag asou dwèt li épi soulyé an pyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Èk alé pwan jenn ti bèf-la ki pli gwa-a. Tjwéʼy èk pwépawé pou nou fè lafèt, ");
INSERT INTO acfNT_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","paski gason mwen-an akwèdi i té ja mò èk i viwé vivan. I té pèdi èk mwen twapéʼy ankò.’ Yo tjenn on gwo fèt, èk yo tout koumansé sélébwé. ");
INSERT INTO acfNT_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Gwan gason-an pa té la an mouman-an. I té ka twavay. Lè i ka witounen lakay papaʼy, i tann an chay mizik épi dansé an kay-la. ");
INSERT INTO acfNT_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","I kwiyé yonn an sé sèvant-lan épi i mandéʼy ki sa ki ka alé la-a. ");
INSERT INTO acfNT_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Sèvant-lan diʼy, ‘Fwèʼw witounen, èk papaʼw tjwé jenn ti bèf-la ki té pli gwa-a, paski i jwenn li an bon santé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Afòs gwan fwè-a té faché, i pa té menm vlé antwé an kay-la. Papa-a vini èk i plédé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Mé gason-an diʼy, ‘Kantité tan mwen épiʼw. Mwen ja twavay tèlman wèd pou mwen fè tout sa ou mandé mwen fè san wifizé. Ou pa janmen ban mwen on ti kabwit pou mwen tjwé èk tjenn fèt épi kanmawad mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Mé menm kon gasonʼw wivé ki ja gaspiyé tout sa ou té ba li-a an vyé lavi, ou tjwé jenn ti bèf-la ki pli gwa-a.’ ");
INSERT INTO acfNT_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Papaʼy diʼy, ‘Gason mwen, ou toujou la épi mwen, èk tout sa mwen ni sé sa ou. ");
INSERT INTO acfNT_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Mé apwézan i méwité pou nou sa sélébwé, paski fwèʼw té kon on nonm ki té mò èk i viwé vivan. I té pèdi èk nou twapéʼy ankò.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jézi di sé disip li-a, “La té ni yon nonm ki té wich èk i té ni yon jèwè pou mennajé zafèʼy ba li, èk i tann ki jèwè-a ka gaspiyé lajan mèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Mèt-la kwiyé jèwè-a èk i diʼy, ‘Ki sa mwen ka tann konsènéʼw-la? Mwen vlé ou ban mwen yon wapò asou tout sa ou ka fè an zafè mwen, paski ou pa kay jèwè mwen ankò!’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Jèwè-a di bay kòʼy, ‘Mèt mwen kay ladjé mwen. Ki sa mwen kay fè? Mwen pa ni kouway pou mwen sa fouyé tè, èk mwen hont pou mwen mandé chawité. ");
INSERT INTO acfNT_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Apwézan mwen sav ki sa mwen kay fè. Èk kon sa lè mwen pèd twavay mwen, mwen kay ni jan ki kay wisivwè mwen an kay yo!’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Kon sa i kwiyé tout sé moun-an ki té ka dwé mèt li-a. I di pwèmyé-a, ‘Konmen ou dwé mèt mwen?’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","“I wéponn, ‘Ywit san galon lwil.’ “Jèwè-a diʼy, ‘Fè vit! Pwan on papyé nèf, asid vitman èk ékwi kat san galon èk kité lòt kat san-an.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Èk i mandé dézyenm-lan, ‘Konmen ou ka dwéʼy?’ “I wéponn, ‘Yon mil sak gwenn.’ “Jèwè-a diʼy, ‘Pwan on papyé nèf èk ékwi ywit san sak.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Mèt-la di jèwè bòbòlis-la moutwé i ni an chay lèspwi. Paski jan latè-a ni pli lèspwi an mannyè-a yo ka mennajé zafè yo pou i sa édé yo pli ta pasé sé moun-an ki konnèt Bondyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Èk Jézi di yo, “Édé moun épi lajan-an ou ni asou latè-a, èk an tan-an ki kay vini-an lè i fini Bondyé kay wisivwèʼw an plas-la koté ou kay wèsté pou tout tan. ");
INSERT INTO acfNT_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Moun-an ou sa konfyé èk tizing bagay-la ou sa konfyé èk an chay, èk moun-an ki pa onnèt èk tizing bagay-la pa kay onnèt èk an chay. ");
INSERT INTO acfNT_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Si ou pa té onnèt an mannyè-a ou ka mennajé wichès latè-a, ki mannyè moun kay sa konfyéʼw èk wichès ki vwéman valowab? ");
INSERT INTO acfNT_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Èk si ou pa té onnèt èk bagay lòt moun, ki moun ki kay baʼw wichès pou kòʼw? ");
INSERT INTO acfNT_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pyès sèvant pa sa ni dé mèt. I kay hayi yonn èk i kay kontan lòt-la. I kay tjenbé yonn èk i kay widjèkté lòt-la. Ou pa sa sèvi Bondyé èk lajan ansanm.” ");
INSERT INTO acfNT_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Sé Fawizyen-an tann tout sa, mé yo pwan Jézi sèvi widitjil paski yo kontan lajan. ");
INSERT INTO acfNT_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jézi di yo, “Zòt ka fè lézòt moun kwè zòt tèlman bon, mé Bondyé sav tjè zòt mové. Sa lézòm kwè ki ni an chay valè, an zyé Bondyé i pa vo anyen. ");
INSERT INTO acfNT_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Lwa Moziz-la èk sa sé pwòfèt-la ékwi-a moutwé nou mannyè pou obéyi Bondyé jis tan Jan Batis vini. Mé apwézan mwen ka diʼw Bon Nouvèl-la konsèné tan-an Bondyé kay kondwi sé moun li-an adan on mannyè nèf, èk tout moun ka débat pou swiv chimen nèf-la. ");
INSERT INTO acfNT_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Mé i pli ézé pou syèl èk latè dispawèt pasé pou yon sèl ti détay an lwa-a pèd valèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Pa ègzanp, pyès nonm ki dévosé madanm li èk mayé èk yon lòt madanm, i ka viv an adiltè, èk nonm-lan ki mayé èk yon madanm ki dévosé-a ka viv an adiltè osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“La té ni yon nonm ki té wich ki té ka abiyé an had wicha. I té ka viv éwé épi i té ka byen manjé toulé jou. ");
INSERT INTO acfNT_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","21","La té ni yon nonm pòv osi, nonʼy sété Lazaròs. I té plen bobo asou kòʼy. Yo té ka pòté Lazaròs an bayè wicha-a pou i té sa èspéyé lèwèstan manjé-a ki té ka tonbé sòti asou tab wicha-a. Sé chyen-an té ka vini liché boboʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Lazaròs mò épi nanj pòtéʼy alé jwenn Abrahanm an plas-la Bondyé pwépawé pou sé moun-an ki obéyi pawòl li. Wicha-a mò osi, èvèk yo téwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","I alé lanfè, plas-la ki pwépawé bay sé moun méchan-an, i té ka soufè an chay. I lévé zyéʼy èvèk i wè Lazaròs lwen èvèk Abrahanm an plas-la Bondyé pwépawé bay sé moun-an ki obéyi pawòl li. ");
INSERT INTO acfNT_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“I andjélé, ‘Abrahanm, papa sé Jwif-la, voyé Lazaròs pou i sa fouyé dwèt li an dlo èvèk pou tak dlo-a sa tonbé asou lanng mwen, paski mwen ka soufè an difé sala.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Abrahanm diʼy, ‘Ich mwen, chonjé lè ou té asou latè, ou té ka jwenn tout sé bon bagay-la épi Lazaròs té ka jwenn tout sé vyé bagay-la? Ében, apwézan i an lakontantman èk ou an soufwans. ");
INSERT INTO acfNT_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Èk osi sé moun-an ki koté nou yé-a pa sa vini koté ou yé-a, ni nonplis sé moun-an ki koté ou yé-a pa sa vini koté nou yé-a, paski la ni an gwan fon ki ka sépawé ou hòd nou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Nonm wich-la di, ‘Ében, Papa Abrahanm, mwen ka mandéʼw, voyé Lazaròs an kay papa mwen ");
INSERT INTO acfNT_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","koté mwen ni senk fwè pou i sa alé vèti yo pou yo pa vini an plas soufwans sala.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Abrahanm diʼy kon sa, ‘Yo ni Liv Moziz épi sé pwòfèt-la pou vèti yo. Kité yo koutéʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“I di, ‘Sa pa asé, Papa Abrahanm, mé si yo wè ki yon moun wésisité hòd lanmò sé fwè mwen-an kay tounen hòd péché yo. Yo kay tann sa i ni pou di.’ ");
INSERT INTO acfNT_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Abrahanm diʼy, ‘Si yo pa ka kouté sa Moziz épi sé pwòfèt-la ékwi, ni nonplis yo pa kay wépanti yo, menm si yon moun wésisité hòd lanmò épi i vini palé ba yo.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jézi di sé disip li-a, “La kay toujou ni tantasyon pou fè péché, mé ki mizi téwib i kay téwib pou moun-an ki tanté lézòt moun. ");
INSERT INTO acfNT_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","I té kay pli mèyè pou nonm sala si yo té kay mawé on gwo wòch an kouʼy èk jétéʼy lanmè avan i fè sa pasé pou i jwenn pinisyon-an i kay wisivwè si i tanté lézòt moun pou fè péché. ");
INSERT INTO acfNT_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","“Kon sa pwan gad kòʼw! Si fwèʼw tonbé an péché, kowijéʼy, èk si i wépantiʼy, pawdonnenʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Si i fèʼw ditò sèt kou pou yon jouné èk chak fwa i ka vini diʼw, ‘Mwen wépanti’, ou ni pou pawdonnenʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yon jou sé zapòt-la di Jézi, “Nou bizwen pli lafwa.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","I wéponn, “Si ou ni lafwa ki piti kon yon piti ti gwenn moutad, ou sa di pyé bwa sala, ‘Déwasiné èvèk planté kòʼw an lanmè-a,’ èk i kay obéyiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Èk i di yo osi, “Si yonn an zòt ni yon sèvant ka fak tèʼw ében ka otjipé zannimoʼw, ou pa kay janmen di sèvant-lan, ‘Sòti an jaden-an, vini asid èk manjé’. ");
INSERT INTO acfNT_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Mé ou kay simyé diʼy pito, ‘Ay pwépawé dinen ban mwen èvèk abiyéʼw èk vini sèvi mwen jis lè mwen fini, èk apwé sa ou kay pwan dinenʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ou pa kay wimèsyé sèvant-lan nonplis paski i fè sa ou diʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Èk an menm mannyè-a zòt sé sèvant Bondyé. Kon sa lè zòt fini fè tout sa mwen mandé zòt pou fè, zòt sa di, ‘Nou sé senpliman sèvant, nou annèk fè sa nou té ni pou fè.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Kon Jézi té ka alé Jérouzalèm i alé ant Sanmariya èk Galili. ");
INSERT INTO acfNT_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","I té ka alé adan yon vilaj lè i jwenn èk dis moun ki té ni maladi an lapo yo. Yo doubout yon bon distans ");
INSERT INTO acfNT_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","èk yo andjélé, “Jézi! Mèt, ni pityé anlè nou!” ");
INSERT INTO acfNT_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Jézi wè yo èk i di yo, “Alé èk moutwé pwèt-la kò zòt.” Kon yo té ka alé, Jézi djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Yonn an yo viwé lè i wè i djéwi èk i koumansé ka glowifyé Bondyé èk tout vwaʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","I tonbé a tè-a an pyé Jézi ka wimèsyéʼy. Nonm-lan sété yon jan Sanmariya. ");
INSERT INTO acfNT_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Jézi di, “La té ni yo dis ki djéwi. Koté sé lézòt nèf-la? ");
INSERT INTO acfNT_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Pouki sété nonm sala tousèl ki sé on jan lòt péyi ki viwé di Bondyé mèsi?” ");
INSERT INTO acfNT_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Èk Jézi diʼy, “Lévé èk alé. Lafwa-a ou ni an Bondyé-a ja djéwiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Yon jou sé Fawizyen-an mandé Jézi, “Ki tan Bondyé kay koumansé kondwi?” Jézi wéponn yo, “La pa ni pyès bagay ki kay moutwéʼw ki tan Bondyé kay koumansé kondwi. ");
INSERT INTO acfNT_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","La pa kay ni yon moun pou diʼw, ‘Mi, i isi-a,’ ében ‘Mi, i la,’ mé Bondyé ja ka kondwi ich li anpami zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","I di sé disip-la, “Lè-a kay vini lè zòt kay anvi zòt té sa wè jou-a lè mwen, Gason Lézòm, kay pwézan ankò, menm si sé pou yon ti mouman tousèl. Mé zòt pa kay wèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","La kay ni moun ki kay diʼw, ‘Mi, i isi-a!’ ében ‘Mi, i la!’ mé sé pa pou zòt alé épi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Menm kon zéklè ka kléwé tout syèl-la dépi yon bout ay lòt lè i limen, sé kon sa mwen, Gason Lézòm, kay pawèt aklè pou tout moun wè an jou mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Mé avan sa mwen kay ni pou soufè an chay, èk tout jan jòdi kay widjèkté mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Menm kon i té yé an tan-an Nowa té ka viv-la, sé menm kon sa tan-an kay yé avan mwen, Gason Lézòm, witounen. ");
INSERT INTO acfNT_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Tout moun té ka manjé, bwè èk mayé jis tan Nowa antwé an batiman-an. Èk lè sala gwo dlo vini èk i détwi yo tout. ");
INSERT INTO acfNT_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Sé menm bagay-la ki té fèt an tan Lòt. Moun té ka manjé èk bwè, achté èk vann, planté èk bati. ");
INSERT INTO acfNT_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mé jou-a Lòt kité Sòdonm-lan, difé épi souf vidé désann sòti an syèl èk détwi yo tout. ");
INSERT INTO acfNT_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","“Sé menm kon sa i kay yé jou-a mwen, Gason Lézòm, kay pawèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Jou sala, si yon nonm anlè tèt kay li, sé pa pou i désann an kay-la pou i pwan sa i ni an kay-la. Èk menm mannyè-a si yon nonm an savann-an, sé pa pou i viwé an kay-la. ");
INSERT INTO acfNT_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Chonjé sa ki wivé madanm Lòt! ");
INSERT INTO acfNT_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Paski moun-an ki vlé tout bon bagay pou kòʼy-la pa kay janmen satisfè, èk an bout-la i kay pèd tout. Mé moun-an ki kité tout bagay li dèyè pou lapéti mwen-an kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Mwen ka diʼw jou òswè sala la kay ni dé nonm ka dòmi anlè yon kouch, Bondyé kay pwan yonn èk lòt-la kay wèsté dèyè. ");
INSERT INTO acfNT_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Dé madanm kay pilé gwenn ansanm, Bondyé kay pwan yonn èk lòt-la kay wèsté dèyè.  ");
INSERT INTO acfNT_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Dé nonm kay an savann-an, Bondyé kay pwan yonn èk lòt-la kay wèsté dèyè.” ");
INSERT INTO acfNT_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Sé disip-la mandéʼy, “Ki koté sa kay fèt, Senyè?” Jézi di yo pawabòl sala, “Kòbo pa bizwen pyès moun di yo koté ki ni on kò mò.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jézi di sé disip li-a on pawabòl pou moutwé yo ki yo ni pou kontiné pwédyé san dékonpòté. ");
INSERT INTO acfNT_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","I di, “La té ni yon jij adan yon sèten vil ki pa té ka wèspèkté ni Bondyé ni lézòm. ");
INSERT INTO acfNT_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Èk la té ni yon madanm mawiʼy té ja mò, i té ka wèsté an menm vil-la. I té ka toujou vini oti jij-la. I diʼy, ‘Lèlmi mwen ka pwan lavantay anlè mwen. Mwen vlé ou ban mwen jistis.’ ");
INSERT INTO acfNT_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","“Pou an chay tan jij-la wifizé édéʼy. Mé yon jou jij-la di bay kòʼy, ‘Menm si mwen pa ka wèspèkté ni Bondyé ni lézòm, ");
INSERT INTO acfNT_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","mé pou anbété madanm sala ja anbété mwen, mwen kay wè ki i jwenn jistis. Si pa sa i kay kontiné ka ban mwen twaka jis tan i kay fè mwen las.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Èk Jézi kontiné ka di yo, “Kouté sa mové jij-la di. ");
INSERT INTO acfNT_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ès ou pa kwè Bondyé ki bon kay édé sé moun-an i ja chwazi-a ki ka pléwé ba li lannwit èk jou? Ès i kay pwan tan pou i édé yo? ");
INSERT INTO acfNT_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Mwen ka diʼw i kay édé yo èk i kay fèʼy byen vit. Mé ès si mwen, Gason Lézòm, kay jwenn moun asou latè ki ka kwè an mwen lè mwen witounen?” ");
INSERT INTO acfNT_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jézi di pawabòl sala bay sé moun-an ki asiwé yo dwèt douvan Bondyé èk yo kwè yo bon pasé tout lézòt moun. ");
INSERT INTO acfNT_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","I di, “Dé nonm alé an Kay Bondyé pou yo pwédyé. Yonn sété yon Fawizyen èk lòt-la sété yon nonm ki té ka anmasé taks bay gouvèdman-an. ");
INSERT INTO acfNT_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Fawizyen-an doubout pa kòʼy èk i pwédyé, ‘Bondyé, mwen ka wimèsyéʼw paski mwen pa vowas, bòbòlis ében yon adiltè kon tout lézòt moun. Mwen ka wimèsyéʼw paski mwen pa yon péchè kon nonm sala ki ka anmasé taks-la. ");
INSERT INTO acfNT_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mwen ka wèsté san manjé dé fwa pa simenn èk mwen ka bay Bondyé dis pou san an tout sa mwen ni.’ ");
INSERT INTO acfNT_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Mé nonm-lan ki ka anmasé taks-la doubout yon bon distans èk i pa menm lévé zyéʼy anlè, mé pito i bat lèstonmak li paski i té an twistès èk i di, ‘Bondyé, ni pityé anlè mwen, mwen sé yon péchè.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Jézi di, “Mwen ka diʼw, Bondyé pawdonnen dézyenm nonm-lan avan nonm sala alé lakay li, mé i pa pawdonnen Fawizyen-an. Paski moun-an ki lévé kòʼy mouté-a kay abésé, èk moun-an ki abésé kòʼy-la kay lévé mouté.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yon konpanni moun mennen ti manmay yo bay Jézi pou i té mété lanmenʼy anlè yo èk benni yo. Mé sé disip-la wè yo èk yo di sé moun-an pa kité sé ti manmay sala anbété mèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Mé Jézi kwiyé sé ti manmay-la pou yo vini jwenn li èk i di, “Kité sé ti manmay-la vini jwenn mwen, épi pa anpéché yo, paski sé moun ki kon sé ti manmay sala Bondyé kay kondwi. ");
INSERT INTO acfNT_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Chonjé sa, moun-an ki pa swiv kondwit Bondyé kon yon ti manmay pa kay janmen swiv kondwit Bondyé pyès.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","La té ni yon nonm ki té ni pouvwa anpami sé Jwif-la. I vini oti Jézi. I di, “Bon mèt, ki sa mwen ni pou fè pou mwen pé éwityé lavi étonnèl?” ");
INSERT INTO acfNT_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jézi mandéʼy, “Ès ou sav sa ou ka di-a lè ou kwiyé mwen ‘bon’? Yon sèl moun ki bon sé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ès ou konnèt konmandman-an? Pa fè adiltè, pa tjwé, pa vòlè, pa pòté fo témwen, pòté manmanʼw épi papaʼw wèspé.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","I wéponn, “Dépi mwen piti, mwen ka fè tout sé bagay sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Jézi diʼy, “Ou ka mantjé yon sèl bagay. Vann sa ou ni, pwan lajan-an èk sépawéʼy bay lé pòv èk ou kay ni twézò an syèl. Èk vini swiv mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Lè i tann sa, sa fèʼy lapenn paski i té byen wich. ");
INSERT INTO acfNT_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jézi wè i té an twistès èk i diʼy, “I byen difisil pou yon nonm ki wich fè lidéʼy pou kité Bondyé kondwi laviʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","I pli ézé pou yon kanmèl antwé an zyé yon zédjwi pasé pou yon nonm wich aksèpté Bondyé kon yon wa pou li.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Lè sé moun-an tann sa yo di, “Sa vlé di pyès moun pa sa jwenn salvasyon!” ");
INSERT INTO acfNT_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jézi wéponn, “Bondyé sa fè sa moun pa sa fè.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pita di, “Gadé, nou kité kay nou èk tout sa nou ni pou nou swiv ou.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jézi di yo, “Wi èk mwen ka di zòt sa, népòt moun ki kité kay li ében madanm li ében fwèʼy ében manmanʼy èk papaʼy ében ich li pou i sèvi anba kondwit Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","i kay wisivwè an chay plis viwé an latè sala, èk i kay wisivwè lavi étonnèl an latè-a ki kay vini-an.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jézi pwan sé douz disip-la apa épi i di yo, “Kouté, nou ka alé Jérouzalèm koté tout sé bagay-la sé pwòfèt-la ékwi konsèné mwen, Gason Lézòm-lan, kay vini vwé. ");
INSERT INTO acfNT_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Mwen kay tonbé anba pouvwa lanmen moun lòt nasyon, yo kay pwan mwen sèvi papicho, yo kay ensilté mwen èk kwaché anlè mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Yo kay bat mwen èk tjwé mwen, mé anlè twazyenm jou-a mwen kay wésisité.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Mé sé disip-la pa té sa konpwann anyen an sé bagay sala paski syans sé pawòl-la té séwé hòd yo, èk yo pa té sav konsèné ki sa Jézi té ka palé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Jézi té ka apwoché Jèriko èk yon nonm avèg té ka asid bò chimen-an ka mandé chawité. ");
INSERT INTO acfNT_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Lè i tann sé moun-an ka pasé i mandé yo, “Ki sa ki fèt?” ");
INSERT INTO acfNT_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Yo diʼy, “Sé Jézi jan Nazawèt ki ka pasé.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","I andjélé, “Jézi, désandan Wa David, ni pityé anlè mwen!” ");
INSERT INTO acfNT_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Sé moun-an ki té douvan-an koumansé ka hélé dèyèʼy. Yo diʼy, “Pé la.” Mé i andjélé pli fò, “Gason David, ni pityé anlè mwen!” ");
INSERT INTO acfNT_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Kon sa Jézi doubout èk i konmandé yo pou mennen nonm avèg-la ba li. Lè i wivé pwéʼy Jézi mandéʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Ki sa ou vlé mwen fè baʼw?” I wéponn, “Mèt, mwen vlé wè ankò.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jézi diʼy, “Ou sa wè. Lafwa-a ou ni an mwen-an ja fè ou byen.” ");
INSERT INTO acfNT_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Èk la menm nonm-lan té sa wè, èk i swiv Jézi èk i ka wimèsyé Bondyé. Lè sé moun-an wè sa yo tout glowifyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Jézi antwé Jèriko lè i té ka alé Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","La té ni yon chèf anpami sé moun-an ki té ka anmasé taks bay gouvèdman nonʼy sété Zakiyòs, èk i té wich. ");
INSERT INTO acfNT_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","I té ka éséyé pou i wè ki moun Jézi yé. Mé i té tèlman kout i pa té sa wè Jézi paski la té ni an chay moun. ");
INSERT INTO acfNT_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Kon sa i kouwi douvan èk i mouté yon pyé bwa pou i sa wè Jézi lè i ka pasé la. ");
INSERT INTO acfNT_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Lè Jézi wivé bò pyé bwa-a i gadé anlè èk i di Zakiyòs, “Fè vit désann, Zakiyòs, paski mwen ni pou alé lakay ou jòdi-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Zakiyòs désann vitman èk i wisivwè Jézi èk lakontantman. ");
INSERT INTO acfNT_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Tout sé moun-an ki wè sa-a koumansé ka bougonnen. Yo di, “Nonm sala ka alé lakay péchè!” ");
INSERT INTO acfNT_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Zakiyòs doubout douvan tout sé moun-an èk i di Jézi, “Kouté misyé, mwen kay bay sé pòv-la lanmwatyé wichès mwen, èk sé moun-an mwen ja vòlè-a mwen kay ba yo viwé kat fwa mizi-a mwen té vòlè yo-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Jézi di, “Bondyé ja sové nonm sala èk fanmiʼy jòdi-a. Sé kon sa pou i yé, paski nonm sala sé désandan Abrahanm osi. ");
INSERT INTO acfNT_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Paski mwen, Gason Lézòm, vini gadé pou moun ki pèd èk pou sové yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Padan sé moun-an té ka kouté sa, Jézi kontiné ka palé èk i di yo on pawabòl. I té tou pwé Jérouzalèm, èk tout moun kwè ki tou talè yo té kay wè tan-an lè Bondyé kay kondwi sé moun li-an. ");
INSERT INTO acfNT_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Kon sa i di yo, “La té ni yon nonm ki sété désandan wa, èk i kité, i alé adan yon lòt péyi ki byen lwen pou i té vini wa èk apwé sa pou i viwé lakay li. ");
INSERT INTO acfNT_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Avan i alé i kwiyé sé dis sèvant li-a èk i ba yo chak yon pyès lajan an lò. I di yo, ‘Twavay lajan sala padan mwen pa la.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Bon, sé jan plas li-a pa té kontanʼy pyès. Kon sa apwé i kité, yo voyé konmisyonnè pou di, ‘Nou pa vlé nonm sala pou vini wa nou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mé kanmenm yo fè i wa èk i witounen lakay li. La menm i kwiyé sé sèvant li-a i té bay lajan-an pou yo vini douvanʼy pou i sav ki lantéwé yo fè anlè lajan-an. ");
INSERT INTO acfNT_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","“Pwèmyé-a vini èk i di, ‘Mèt, mwen sèvi pyès lajan an lò-a ou ban mwen-an èk mwen fè dis pyès an pwofi baʼw épiʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","“Mèt-la wéponn li, ‘Sa bon! Ou sé yon bon sèvant. Paski mwen sa dépan anlèʼw an ti bagay kon sa, mwen kay météʼw an chaj dis vil.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Dézyenm-lan vini èk i di, ‘Mèt, mwen sèvi pyès lajan an lò-a ou ban mwen-an èk mwen fè senk pyès an pwofi baʼw épiʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","“Mèt-la di sèvant sala, ‘Ou kay an chaj senk vil.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Yon lòt sèvant vini èk i di, ‘Mèt, mi pyès lajan an lòʼw-la. Mwen tjenn li séwé adan yon mouchwè pòch. ");
INSERT INTO acfNT_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Mwen té pèʼw paski ou sé yon nonm ki wèd. Ou ka pwan sa ki pa sa ou èk ou ka wékòlté sa ou pa té planté.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","“Mèt-la di, ‘Ou sé yon mové sèvant! Mwen kay pwan pawòl ou menm pou jijéʼw. Ou di ou sav mwen sé yon nonm ki wèd èk mwen ka pwan bagay ki pa sa mwen èk ka wékòlté sa mwen pa planté. ");
INSERT INTO acfNT_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Pou ki sa ou pa mété lajan mwen labank ban mwen? Kon sa mwen té kay jwenn plis lajan asouʼy lè mwen viwé.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Kon sa mèt-la di sé moun-an ki té ka doubout la-a, ‘Pwan pyès lajan an lò-a lanmenʼy èk bay sèvant-lan ki ni dis pyès-la li.’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“Yo diʼy, ‘Mèt, mé i ja ni dis pyès!’ ");
INSERT INTO acfNT_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“I di yo, ‘Mwen ka di zòt, moun-an ki sa fè yon pwofi èk sa i ni-an, i kay jwenn plis, mé moun-an ki pa sa fè yon pwofi, jis tizing-lan i ja ni-an yo kay pwan lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Mé sé lèlmi mwen-an ki pa vlé mwen sé wa-a, mennen yo isi-a èk tjwé yo douvan mwen.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Apwé Jézi di sa i kontiné asou lawout li ka alé Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Kon i té ka apwoché pwé vil Bèfaj èk Bèfanni an mòn-an yo ka kwiyé Mòn Òliv, i voyé dé disip alé douvan ");
INSERT INTO acfNT_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","èk i di yo kon sa, “Alé an vil sala ki douvanʼw-lan. Kon ou ka antwé an vil-la ou kay jwenn an jenn bouwik mawé la, pyès moun pʼòkò janmen batjé. Démawéʼy èk mennenʼy isi-a. ");
INSERT INTO acfNT_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Si pyès moun mandéʼw pou ki sa ou ka démawéʼy, diʼy kon sa, ‘Mèt-la bizwenʼy.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Yo alé èk yo jwenn tout bagay menm kon Jézi té di yo. ");
INSERT INTO acfNT_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Kon yo té ka démawé bouwik-la, mèt li di yo, “Pou ki sa zòt ka démawéʼy?” ");
INSERT INTO acfNT_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Yo diʼy, “Mèt-la bizwenʼy,” ");
INSERT INTO acfNT_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","èk yo mennen bouwik-la bay Jézi. Yo mété kanmizòl yo anlè do bouwik-la èk yo édé Jézi pou i mouté anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Kon i té ka pasé, sé moun-an mété had a tè-a anlè chimen-an pou bouwik-la sa pasé anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Lè Jézi wivé pwé Jérouzalèm yon plas koté chimen-an désann Mòn Òliv, tout sé moun-an ki té ka swiv li-a koumansé ka andjélé fò ka wimèsyé Bondyé èk adowéʼy pou tout sé miwak-la yo wèʼy fè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Yo di, “Bondyé benni wa-a i voyé-a!” “I voyé lapé désann sòti an syèl.” “Annou glowifyé Bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Yon konpanni Fawizyen ki té anpami sé moun-an di Jézi, “Titja, ès ou pa kwè ou ni pou di sé disip ou-a pé bouch yo la, èk pa di sé bagay sala yo ka di-a!” ");
INSERT INTO acfNT_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mé Jézi di yo, “Si yo pé bouch yo, jik sé wòch-la a tè-a ki kay andjélé pou wimèsyé Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Kon Jézi té ka apwoché pli pwé vil-la èk i wèʼy, i pléwé bay sé jan Jérouzalèm-lan. ");
INSERT INTO acfNT_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","I di, “Aa, jan Jérouzalèm, si sèlman zòt té sav jòdi-a ki sa ki té kay bay zòt lapé. Mé apwézan zòt pa sa wèʼy! ");
INSERT INTO acfNT_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Jou-a kay vini anlè zòt lè sé lèlmi zòt-la kay bawé zòt toupatou, yo kay bouché zòt tout oliwon pou zòt pa sa chapé èk yo kay vini anlè zòt sòti an tout diwèksyon pou bat zòt. ");
INSERT INTO acfNT_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Yo kay kwazé zòt nèt, zòt èk ti manmay zòt èk tout kay ki an vil zòt. Pa menm yon wòch yo kay kité an plas li, paski zòt pa té konpwann ki Bondyé té vini sové zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Jézi alé an Kay Bondyé èk i koumansé chaché sé wivandèz-la ki té ka vann machandiz yo sòti alé. ");
INSERT INTO acfNT_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","I di yo, “Mi, sé sa ki ékwi an lévanjil, koté Bondyé di, ‘Kay mwen sé yon kay lapwiyè’, mé zòt ja tounenʼy èk fèʼy kon yon plas koté vòlè ka asanblé.” ");
INSERT INTO acfNT_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Apwé sa Jézi té ka enstwi an Kay Bondyé toulé jou. Sé chèf pwèt-la èk sé titja lwa sé Jwif-la èk osi sé chèf sé moun-an té vlé tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mé yo pa té sa jwenn an mannyè pou fèʼy paski tout sé moun-an té ka koutéʼy, paski yo pa té vlé mantjé yon mo pawòl i di. ");
INSERT INTO acfNT_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Yon jou lè Jézi té an Kay Bondyé ka enstwi sé moun-an èk ka pwéché Bon Nouvèl-la, sé chèf pwèt-la èk sé titja lwa sé Jwif-la ansanm èk sé lézòt chèf anpami sé Jwif-la vini ");
INSERT INTO acfNT_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","èk yo diʼy, “Di nou, ki dwa ou ni pou fè èk di tout sé bagay sala? Ki moun ki baʼw pouvwa pou fè sa?” ");
INSERT INTO acfNT_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jézi wéponn yo, “Bon, kité mwen mandé zòt yon kwèsyon osi. Di mwen, ");
INSERT INTO acfNT_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ès sé Bondyé ében lézòm ki voyé Jan Batis pou batizé moun?” ");
INSERT INTO acfNT_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yo koumansé ka dispité anpami yo. Yo di, “Ki sa nou kay di? Si nou di sé Bondyé ki voyéʼy, i kay mandé nou pouki nou pa té kwè Jan Batis. ");
INSERT INTO acfNT_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Mé si nou di sé lézòm ki voyéʼy, tout sé moun-an kay voyé wòch dèyè nou, paski yo asiwé ki Jan Batis sété yon pwòfèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kon sa yo di, “Nou pa sav ki moun ki voyéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Kon sa Jézi di yo, “Ében mwen pa kay di zòt ki kalité pouvwa mwen ni pou fè sé bagay-la mwen ka fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jézi di sé moun-an pawabòl sala, “La té ni yon nonm ki planté an jaden wézen. Lè i fini plantéʼy, i vini lwéʼy bay on konpanni moun èk i alé lòt péyi pou an chay tan. ");
INSERT INTO acfNT_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Lè i té tan wékòt, mèt jaden-an voyé yon sèvant oti sé moun-an ki té ka otjipé jaden wézen-an pou yo sa bay yon pòsyon wézen ba li. Mé sé moun-an bat sèvant-lan èk yo voyéʼy alé san anyen. ");
INSERT INTO acfNT_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Kon sa mèt jaden-an voyé yon lòt sèvant, mé sé moun-an bat li osi èk yo maltwétéʼy èk yo voyéʼy alé lanmenʼy vid. ");
INSERT INTO acfNT_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Èk mèt jaden-an voyé yon twazyenm sèvant oti sé moun-an. Yo bléséʼy èk yo jétéʼy sòti an jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Lè sala mèt jaden-an di, ‘Ki sa mwen kay fè? Mwen kay voyé gason mwen-an mwen ka chéwi-a. Pitèt yo kay wèspèktéʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Mé lè sé moun-an ki té ka lwé tè-a wè gason-an, yo di bay yonn a lòt, ‘Sé li ki kay éwityé jaden-an pli ta. Annou tjwéʼy, èk tout jadenʼy-lan kay wèsté pou nou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Kon sa yo jétéʼy sòti an jaden wézen-an èk yo tjwéʼy. “Bon, ki sa ou kwè mèt jaden-an kay fè sé moun-an ki ka lwé jaden-an? ");
INSERT INTO acfNT_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","I kay vini èk tjwé sé nonm-lan èk i kay lwé jaden wézen-an bay yon lòt konpanni moun.” Lè sé moun-an tann sa yo di, “Awa! Tanpwi souplé, pa kitéʼy fèt kon sa!” ");
INSERT INTO acfNT_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Jézi gadé yo an mitan zyé èk i mandé yo, “Sé kon sa i sipozé fèt, paski sé sa ki ékwi an lévanjil, ‘Wòch-la ki pli enpòtan-an lè ou ka fè yon kay, sé li menm sé moun-an ki ka fè kay-la widjèkté.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","I di, “Pyès moun ki tonbé anlè wòch sala kay kwazé an plizyè mòso, èk si wòch-la tonbé anlè pyès moun osi i kay kwazé yo nèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Sé titja lwa sé Jwif-la èk sé chèf pwèt-la éséyé jwenn on mannyè pou yo té awété Jézi la menm paski yo sav i di pawabòl sala kont yo. Mé yo té pè sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Yo té ka véyé Jézi pou yo té jwenn yon bon chans anlèʼy, kon sa yo éséyé kwennenʼy èk kwèsyon. Yo péyé déotwa moun pou fè akwèdi yo té vlé sav ki sa ki dwèt pou fè. Kon sa yo voyé yo alé palé èk Jézi, èk yo té ka éséyé tjenbé Jézi ka di yon bagay ki té kay ofwansé gouvèdman-an, èk kon sa sé chèf-la té kay awétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Sé nonm-lan di Jézi, “Titja, nou sav ki tout sa ou di èk enstwi-a, i vwé. Ou pa ka moutwé pwéféwans pou pyès moun. Pito ou ka di nou lavéwité konsèné ki mannyè Bondyé vlé lézòm viv. ");
INSERT INTO acfNT_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Di nou, ès si i kont lwa sé Jwif-la pou nou péyé wa péyi Ronm taks lè i konmandé nou pou péyéʼy?” ");
INSERT INTO acfNT_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Mé Jézi sav ki yo té ka éséyé kwennenʼy, èk i di yo, ");
INSERT INTO acfNT_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Moutwé mwen yon pyès dajan.” I mandé yo, “Fidji ki moun èk non ki moun ki anlèʼy?” Yo wéponn li, “Sa wa Ronm-lan.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Kon sa Jézi wéponn yo, “Ében bay Wa Siza sa ki sa li èk bay Bondyé sa ki sa Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Yo pa té sa tjenbéʼy ka di anyen ki té kay ofwansé gouvèdman Ronm-lan douvan sé moun-an. Yo té étonnen pou tann wépons-lan i ba yo-a, kon sa yo tjenn silans yo. ");
INSERT INTO acfNT_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","La té ni yon konpanni Jwif yo kwiyé ‘sé Sadisyen-an’ ki di lè moun mò yo pa ka wésisité pou yo alé an syèl ében lanfè. Yon konpanni Sadisyen té vlé kwennen Jézi, kon sa yo vini otiʼy èk yo mandéʼy, ");
INSERT INTO acfNT_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Titja, an lwa Moziz-la i ékwi ban nou kon sa, ‘Si yon nonm té mayé èk i mò èk i pa té fè pyès ich èk madanm li, fwè nonm sala ni pou mayé madanm nonm-lan pou yo fè ich bay nonm-lan ki mò-a.’ ");
INSERT INTO acfNT_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Bon, la té ni sèt fwè èk pli gwan-an té mayé, i mò èk i pa fè pyès ich. ");
INSERT INTO acfNT_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Kon sa dézyenm-lan mayé madanm-lan èk i mò osi san i fè pyès ich èk madanm-lan. ");
INSERT INTO acfNT_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Èk twazyenm-lan mayé madanm-lan, èk menm bagay-la wivé toulé sèt fwè-a. Yo mò san fè ich. ");
INSERT INTO acfNT_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Èk dènyéman madanm-lan mò. ");
INSERT INTO acfNT_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Bon, jou-a tout mò kay wésisité-a, madanm kilès an sé nonm sala i kay yé? Paski yo tout té mayé épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jézi wéponn yo, “Mawiyaj sé pou moun ki isi-a asou latè. ");
INSERT INTO acfNT_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Mé madanm èk misyé Bondyé pèwmité pou wésisité hòd lanmò èk alé an syèl, yo pa ka mayé. ");
INSERT INTO acfNT_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Èk yo pa kay janmen mò ankò. Yo kay viv kon nanj. Yo sé ich Bondyé paski yo ja wésisité hòd lanmò.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Èk Jézi kontiné ka di yo, “Èk konsèné kwèsyon-an si moun kay wésisité hòd lanmò, jik sa Moziz ékwi-a ka moutwéʼw aklè ki sa ka fèt pou vwé. Lè i ékwi listwa-a konsèné wazyé bwilé-a, i di kon sa Bondyé sé Bondyé-a Abrahanm, Ayzak èk Jakòb ka adowé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Zòt ka kwè ki sé moun sala té ja mò, mé Bondyé sav ki yo ka viv toujou an syèl. Paski Bondyé sav sé pou tout tan moun ka viv.” ");
INSERT INTO acfNT_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yon konpanni titja lwa sé Jwif-la di Jézi, “Sa sé yon bon wépons, titja,” ");
INSERT INTO acfNT_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","paski yo té pè mandéʼy yon lòt kwèsyon ankò. ");
INSERT INTO acfNT_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jézi tounen èk i mandé yo yon kwèsyon, i di, “Ki mannyè yo ka di ki Mèsaya-a kay yon désandan Wa David? ");
INSERT INTO acfNT_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Paski David menm ékwi sé bagay sala an liv Samz-la konsèné Mèsaya, “ ‘Bondyé Senyè di mèt mwen, “Asid la asou koté lanmen dwèt mwen koté ou kay jwenn wèspé, ");
INSERT INTO acfNT_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","jis tan mwen mété sé lèlmiʼw-lan anba pyéʼw.” ’ ");
INSERT INTO acfNT_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","David kwiyéʼy ‘Mèt mwen’. Ki mannyè yon moun pé gason David èk David sa kwiyéʼy ‘Mèt li’ a menm lè?” ");
INSERT INTO acfNT_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Kon tout sé moun-an té ka kouté Jézi, Jézi di sé disip li-a, ");
INSERT INTO acfNT_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Pwan gad pou sé titja lwa sé Jwif-la ki kontan maché toupatou ka pòté lonng wòb pou moutwé ki yo enpòtan, èk yo kontan pou tout moun di yo bonjou èk gwan wèspé lè yo ka maché an piblik. Yo ka chwazi plas-la ki pli enpòtan-an an légliz sé Jwif-la, èk lè yon moun envité yo adan yon fèt, yo ka asid an plas-la ki pli mèyè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","An menm di tan yo ka pwan lavantay anlè sé madanm-lan ki maléwèz-la èk yo ka vòlè sa yo ni. Mé yo ka fè lonng lapwiyè pou yo moutwé ki yo bon. Èk pinisyon yo kay byen mové.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jézi gadé owon-an èvèk i wè tout sé nonm wich-la ka ladjé kado yo an bwèt twézò légliz-la. ");
INSERT INTO acfNT_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","I osi wè yon madanm maléwèz mawiʼy té ja mò, i ladjé lavalè kat sou. ");
INSERT INTO acfNT_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Jézi di, “Mwen ka di zòt, madanm maléwèz sala mété plis pasé yo pyès, ");
INSERT INTO acfNT_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","paski lézòt-la mété kado yo an sa yo tiwé an wichès yo, mé i menm madanm-lan, maléwèz kon i yé, i bay tout sa i té ni pou viv asou.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Sé disip Jézi-a koumansé palé konsèné Kay Bondyé, mannyè i gadé bèl èvèk tout sé mòd-la yo twavay sé wòch-la ki fè Kay Bondyé, èvèk tout sé bèl bagay-la moun té bay pou sèvi an Kay Bondyé. Mé Jézi di, ");
INSERT INTO acfNT_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Tout sé bagay sala zòt ka wè-a, tan-an ka vini lè pa kay wèsté yon wòch isi-a ki kay doubout an plas. Yo tout kay tonbé a tè.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Sé disip-la di, “Mèt, ki tan sé bagay sala kay fèt? Èvèk ki sa ki kay wivé pou moutwé nou tan-an ja vini pou sa fèt?” ");
INSERT INTO acfNT_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jézi di, “Pwan gad. Pa kité moun kwennen zòt. Paski an chay moun kay vini èk di yo sé Mèsaya-a, yo kay di, ‘Tan-an ja wivé,’ mé pa swiv yo. ");
INSERT INTO acfNT_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Pa pè lè zòt tann moun ka palé konsèné ladjè èk wévolisyon. Tout sé bagay sala ni pou fèt avan, mé sa pa vlé di finisman-an ja pwé.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","I kontiné ka di yo, “Nasyon kay lévé goumen épi lòt nasyon épi péyi kay lévé ladjè kont lòt péyi. ");
INSERT INTO acfNT_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","La kay ni mové twanblanntè, kay ni lafen, épi tout sòt diféwan maladi an sèten plas. La kay ni mové sin moun kay wè an syèl, i kay fè yo pè. ");
INSERT INTO acfNT_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Mé avan tout sé bagay sala fèt, yo kay awété zòt épi pèsikité zòt. Yo kay mennen zòt lodyans an sé légliz yo-a épi yo kay mété zòt an pwizon. Yo kay mennen zòt douvan wa épi gouvènè pou lapéti mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Sa kay chans zòt pou di yo Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fè lidé zòt davans zòt pa kay anbété kò zòt pou zòt katjilé pou fè défans pou kò zòt, ");
INSERT INTO acfNT_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","paski lè lè-a wivé mwen kay di zòt sa pou zòt di èk fè, épi pyès lèlmi zòt pa kay ni di ében fè zòt anyen pou sa zòt di-a. ");
INSERT INTO acfNT_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Jik manman zòt èk papa zòt, fwè épi tout fanmi épi kanmawad zòt kay livwé zòt bay lwa-a. Lwa-a kay kondanné adan zòt pou lanmò. ");
INSERT INTO acfNT_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Tout moun kay hayi zòt pou lapéti mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mé zòt kay pwézèvé, èk pa menm yon bwanch chivé tèt zòt ki kay pèdi. ");
INSERT INTO acfNT_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Tjenbé fò, paski sa sé mannyè zòt kay twapé wéyèlman lavi.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Lè zòt kay wè sòlda tout oliwon Jérouzalèm, sé lè sala zòt kay sav ki touswit yo kay détwi plas-la. ");
INSERT INTO acfNT_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Sa ki an Joudiya ni pou kouwi mouté an sé montany-lan. Sa ki an vil-la kay ni pou kité, épi sa ki an bitasyon pa ni pou alé an vil. ");
INSERT INTO acfNT_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Paski sa sé tan-an lè Bondyé ka pini sé moun li-an pou moutwé tout lavéwité lévanjil-la té ja di. ");
INSERT INTO acfNT_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","I kay byen téwib an tan sala pou madanm ki ansent èvèk pou manman ki ni ti manmay ka tété. Plas-la kay soufè on mové lapenn ki kay téwib, épi Bondyé kay moutwé sé moun-an i faché kont yo. ");
INSERT INTO acfNT_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Lèlmi-an kay tjwé on konpanni épi sab yo, èk yo kay pwan lézòt pwizonnyé pou mennen yo an tout péyi. Èvèk moun an lézòt péyi kay vini antwé Jérouzalèm èk yo kay kwazé plas-la jik tan pouvwa yo menm fini.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Sin kay pawèt an sòlèy-la, lalin-an, épi an sé étwal-la. Asou latè tout moun kay twakasé. Mannyè-a lanmè-a kay woulé èvèk fè dézòd kay fè moun pè. ");
INSERT INTO acfNT_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Lè moun kay wè sa ki ka fèt an latè-a, yo kay tèlman pè yo kay kon yon fèy ki fennen, paski jis sé étwal-la ki an lézè-a kay soukwé. ");
INSERT INTO acfNT_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","A lè sala yo kay wè Gason Lézòm pawèt ka vini an nwaj-la épi pouvwa èk gwan klèté. ");
INSERT INTO acfNT_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Lè tout sé bagay sala koumansé fèt, doubout épi gadé anlè, paski touswit Bondyé kay délivwé zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Épi i di yo on lòt pawabòl. I di, “Katjilé asou yon pyé fwitaj ében népòt lòt pyé bwa. ");
INSERT INTO acfNT_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Lè yo koumansé fléwi, pyès moun pa ni pou di zòt an ki sézon zòt yé. ");
INSERT INTO acfNT_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","An menm mannyè-a, lè zòt kay wè tout sé twaka sala, zòt kay sav ki tan-an lè Bondyé kay koumansé kondwi kay wivé. ");
INSERT INTO acfNT_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Chonjé byen. Tout sé moun-an ki ka viv atjwèlman, yo pa kay mò tout tan sé bagay sala pʼòkò fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Syèl épi latè kay bout, mé tout sa mwen ka di zòt-la kay wèsté pou tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Pwan pokosyon. Pa kité twaka lavi sala plen tèt ou épi twòp fèt épi twòp bwason èvèk katjil lavi-a, paski jou-a mwen kay witounen-an pé wivé asouʼw san ou ka èspéyé. ");
INSERT INTO acfNT_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Menm kon yon zatwap ka tjenbé souwi, sé kon sa jou sala kay vini sibit asou tout moun an tout latè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Pwan gad épi pwédyé konstan pou ou sa ni fòs pou ou sa sipòté tout sa ki kay fèt-la épi pou ou sa doubout an pwézans Gason Lézòm.” ");
INSERT INTO acfNT_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Jézi pasé tout tan-an ka enstwi an Kay Bondyé, èvèk lè sòlèy kouché i té ka alé pasé nwit-la an Mòn Òliv. ");
INSERT INTO acfNT_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Tout sé moun-an té ka alé an Kay Bondyé byen bonnè lé bonmaten pou tann Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Lè-a té ka apwoché pou sé Jwif-la té tjenn Fèt Délivwans yo. Sa sé jou-a yo té ka fè pen yo san lèlven. ");
INSERT INTO acfNT_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Épi sé chèf pwèt-la èk sé titja lwa sé Jwif-la té ka tjenn on konsit an sigwé pou yo té fè on défini épi Jézi, paski yo té pè fèʼy pou sé moun-an té sav. ");
INSERT INTO acfNT_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Lè sala Satan antwé an Jida Iskariyòt, i sété yonn an sé douz disip-la. ");
INSERT INTO acfNT_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Kon sa Jida alé palé épi sé chèf pwèt-la épi sé ofisyé sé moun-an ki té ka gad Kay Bondyé-a pou yo sav ki mannyè i kay livwé Jézi ba yo. ");
INSERT INTO acfNT_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Yo té byen plè, èvèk yo ofè pou péyéʼy lajan. ");
INSERT INTO acfNT_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Jida dakò pou sa èvèk i koumansé gadé pou on bon chans pou i twayi Jézi ba yo san sé moun-an sav sa. ");
INSERT INTO acfNT_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Jou-a wivé pou yo té sélébwé Fèt Délivwans-lan épi pou yo té tjwé on ti mouton pou manjé épi pen san lèlven-an. ");
INSERT INTO acfNT_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jézi di Pita épi Jan pou alé fè pwépawasyon pou Fèt Délivwans-lan. ");
INSERT INTO acfNT_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Yo mandé Jézi, “Ki koté ou vlé nou alé pwépawé?” ");
INSERT INTO acfNT_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jézi di yo, “Kon zòt kay wivé, zòt kay jwenn épi yon nonm ki ka pòté on jè dlo. Swiv li an kay-la i antwé-a ");
INSERT INTO acfNT_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","èvèk di mèt kay sala kon sa, ‘Titja-a voyé nou mandéʼw ki koté chanm-lan yé koté i sa manjé wipa Fèt Délivwans-lan épi sé disip li-a.’ ");
INSERT INTO acfNT_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","I kay moutwéʼw on gwan chanm anhogwiyen-an ki ja ni tout bagay adanʼy. Alé la èk pwépawé tout bagay.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yo alé èk yo twapé tout bagay menm kon Jézi di yo, èvèk yo pwépawé pou wipa Fèt Délivwans. ");
INSERT INTO acfNT_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Lè lè-a wivé, Jézi pwan plas li a tab épi sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","I di yo, “Mwen té vlé tèlman pou mwen manjé wipa Fèt Délivwans sala épi zòt avan mwen soufè. ");
INSERT INTO acfNT_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Paski mwen ka di zòt, mwen pa kay janmen manjéʼy ankò tout tan bagay-la nou ka chonjé isi-a pa akonpli. Lè sala Bondyé kay kondwi.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Lè yo bay Jézi yon pòt, i pwan pòt-la, i wimèsyé Bondyé èk i di, “Pwan sa èvèk sépawéʼy anpami zòt, ");
INSERT INTO acfNT_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","paski mwen ka di zòt, mwen pa kay janmen bwè diven ankò tout tan kondwit Bondyé pʼòkò vini.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","I pwan on pen, i wimèsyé Bondyé, èk i kaséʼy an konmen mòso, èvèk i ba yoʼy, i di yo, “Sa sé kò mwen mwen ka bay kon yon sakwifis bay Bondyé pou lapéti zòt. Manjé sa pou zòt sa chonjé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","An menm mannyè-a i ba yo pòt-la apwé dinen, i di yo, “Pòt sala sé agwéman nèf-la — lè san mwen kay koulé pou lapéti zòt, i kay konfimé agwéman sala. ");
INSERT INTO acfNT_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Mi, gadé sa! Moun-an ki pou twayi mwen-an, i la ansanm épi mwen asou tab-la. ");
INSERT INTO acfNT_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Paski mwen, Gason Lézòm, kay mò menm kon Bondyé té ja désidé. Mé sa kay byen téwib pou moun-an ki kay twayi mwen-an!” ");
INSERT INTO acfNT_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Èk yo koumansé mandé yonn a lòt kilès anpami yo ki kay fè bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Sé disip-la koumansé chikannen anpami yo pou sav kilès ki kay pli enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Jézi di yo, “Sé wa latè-a ni donminasyon asou sé moun-an èk yo ka maltwété yo, mé an menm di tan yo ka chaché on gwo non pou kò yo pou fè moun di yo bon. ");
INSERT INTO acfNT_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Mé i pa sipozé kon sa épi zòt. Nonm-lan ki pli enpòtan anpami zòt-la kay menm kon pli piti-a, épi sa ki ka kondwi-a kay kon yon sèvant. ");
INSERT INTO acfNT_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Kilès ki pli enpòtan, sa ki asid pou manjé-a ében sa ki mennen manjé-a? Sé sa ki asid-la ki vwéman enpòtan. Mé mwen anpami zòt kon sèvant-lan ki ka mennen manjé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Zòt ja wèsté épi mwen an tout twaka mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Menm kon Papa mwen ja ban mwen pouvwa pou mwen kondwi asou latè-a, sé menm mannyè-a mwen ka baʼw pouvwa pou zòt kondwi épi mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Zòt kay manjé épi bwè asou tab mwen lè mwen kay kondwi an latè-a, èvèk zòt kay asid pou kondwi épi jijé douz bwanch lafanmi ki désandan Izwayèl.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jézi di, “Simon, Simon! Satan ja mandé pèwmisyon pou tounen lidé zòt pou pa swiv mwen paski i vlé tiwé zòt menm kon yo ka tiwé pay an gwenn. ");
INSERT INTO acfNT_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Mé mwen ja pwédyé baʼw, pou lafwaʼw pa tounen pou pa swiv mwen. Épi lè ou kay witounen a mwen, sé fo ou bay sé lézòt disip-la fòs épi kouway an lafwa yo.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pita wéponn li, i di, “Senyè, mwen kay kontiné swiv ou, menm si mwen ni pou alé an pwizon épiʼw ében pou mwen pwan lanmò mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Mé Jézi di Pita, “Òswè-a kòk-la pa kay chanté tout tan ou pa di pou twa fwa ou pa konnèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jézi mandé yo, “Tan-an lè mwen té voyé zòt alé pwéché Bon Nouvèl-la èk mwen té di zòt pa ni pou pwan lajan ni sak ében soulyé épi zòt, ès zòt té mantjé anyen zòt té bizwen?” Yo wéponn li, “Non, nou pa té mantjé anyen.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Jézi di yo, “Mé apwézan sa ki ni lajan ni pou pwanʼy, ében sa ki ni sak ni pou pwanʼy, èk sa ki pa ni yon sab ni pou vann kanmizòl li èk genyen yonn. ");
INSERT INTO acfNT_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Paski lévanjil-la di, ‘I kay kondanné èk sé kwiminèl-la,’ èk mwen ka di zòt ki sé pawòl sala konsèné mwen-an ni pou vini vwé, paski lavi mwen ja pwèskè bout.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Yo diʼy, “Mèt, mi la ni dé sab.” Jézi di yo, “Nou ja palé asé konsèné sé bagay sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jézi kité vil-la èk i mouté an Mòn Òliv kon lakoutim, èk sé disip li-a alé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Lè yo wivé la i di yo, “Pwédyé pou zòt pa tonbé anba tantasyon.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","I kité yo la èk i alé distans yon moun sa voyé yon wòch, i ajounou èk i pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","I di, “Papa, si ou vlé, pwan pòt soufwans sala an lanmen mwen. Mé kanmenm pa fè sa mwen vlé, mé pito sé sa ou vlé pou ou fè.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Èk yon nanj sòti an syèl èk i pawèt douvanʼy èk i ba li kouway. ");
INSERT INTO acfNT_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Èk Jézi té an lapenn èk i pwédyé pli sèwyé èk i té ka swé, laswèʼy té menm kon san ka dégouté anlèʼy ka tonbé a tè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Lè i fini pwédyé i lévé doubout èk i alé jwenn sé disip-la, i jwenn yo ka dòmi paski yo té an tèlman lapenn yo vini las. ");
INSERT INTO acfNT_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","I di yo, “Pouki zòt ka dòmi? Lévé èk pwédyé pou zòt pa péché lè Satan tanté zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Padan Jézi té la ka palé toujou, yon gany moun vini, èk Jida, ki sété yonn anpami sé disip li-a, i té douvan ka mennen sé moun-an. Èk Jida vini douvan pou i bo Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Mé Jézi diʼy, “Jida, ès ou ka twayi mwen, Gason Lézòm, èk yon bo?” ");
INSERT INTO acfNT_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Lè sé disip-la ki té la èk Jézi wè ki sa ki té kay fèt-la, yo di Jézi, “Mèt, ès si pou nou ba yo an koul sab?” ");
INSERT INTO acfNT_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Èk yonn anpami sé disip-la koupé zòwèy dwèt yonn anpami sé sèvant pli ho chèf pwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Mé Jézi di yo, “Sa ni asé!” Èk i touché tèt nonm-lan èk djéwi zòwèy li. ");
INSERT INTO acfNT_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Kon sa Jézi di sé chèf pwèt-la èk sé ofisyé sé moun-an ki ka véyé Kay Bondyé-a èk sé chèf anpami sé Jwif-la ki vini awétéʼy-la, “Zòt vini èk sab épi baton akwèdi mwen sé yon vòlè. ");
INSERT INTO acfNT_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mwen té an Kay Bondyé épi zòt toulé jou èk zòt pa éséyé awété mwen. Mé apwézan sé lè pou zòt fè sa zòt ka fè-a. Sa sé lè pouvwa Satan, mèt nwèsè, kay kondwi.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Yo awété Jézi èk yo mennenʼy lakay pli ho chèf an sé pwèt-la, èk Pita té ka swiv li adan yon distans. ");
INSERT INTO acfNT_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Yo limen yon difé an mitan lakou-a èk Pita asid anpami sé moun-an ki té asid oliwon difé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Yon jenn fi ki sété yon sèvant wè Pita asid bò difé-a, i gadé Pita èk i di, “Nonm sala té épiʼy osi!” ");
INSERT INTO acfNT_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Mé Pita di sa pa vwé. I di, “Madanm, mwen pa menm konnèt li.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Apwé yon ti mouman yon lòt nonm wèʼy èk i di, “Ou té épi yo osi!” Mé Pita di, “Misyé, mwen pa té la!” ");
INSERT INTO acfNT_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Èk apipwé yon nèditan pli ta yon lòt nonm wèʼy èk i di, “Mwen asiwé nonm sala té épi Jézi, paski i sé jan Galili osi.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Mé Pita wéponn li, “Gason, mwen pa sav ki sa ou ka di la-a.” Menm kon Pita té ka di sa yon kòk chanté. ");
INSERT INTO acfNT_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Jézi tounen èk i gadé Pita, èk Pita chonjé sé pawòl-la Jézi té diʼy-la. Jézi té di, “Avan kòk-la chanté ou kay ja di pou twa fwa ou pa konnèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pita sòti an lakou-a èk i koumansé pléwé an chay. ");
INSERT INTO acfNT_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Sé nonm-lan ki té ka véyé Jézi-a, yo té ka pwanʼy sèvi widitjil èk yo bat li. ");
INSERT INTO acfNT_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Yo bawé zyéʼy èk yo ka mandéʼy, “Ki moun ki bat ou? Si ou sé yon pwòfèt, di nou ki moun!” ");
INSERT INTO acfNT_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Yo kontiné ka ensiltéʼy èk an chay lézòt pawòl. ");
INSERT INTO acfNT_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Lè jou ouvè, sé chèf sé Jwif-la, sé chèf pwèt-la èk sé titja lwa sé Jwif-la jwenn ansanm èk yo mennen Jézi douvan konsèy sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Yo di Jézi, “Di nou, ès ou sé Mèsaya-a Bondyé pwonmèt pou voyé-a?” Jézi di yo, “Si mwen di zòt, zòt pa kay kwè mwen, ");
INSERT INTO acfNT_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","èk si mwen mandé zòt yon kwèsyon zòt pa kay wéponn mwen. ");
INSERT INTO acfNT_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Mé tou talè mwen, Gason Lézòm, kay asid asou koté dwèt Bondyé ki ni tout pouvwa, koté mwen kay jwenn wèspé.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Yo tout mandéʼy, “Kon sa ès ou sé Gason Bondyé?” I wéponn yo, “Zòt menm ka di ki moun mwen yé.” ");
INSERT INTO acfNT_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Èk yo di, “Nou pa bizwen pyès lòt témwen, paski pawòl li menm ja kondannéʼy pou mò.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Tout sé moun-an mennen Jézi douvan Pons Pilat, gouvènè Ronm, ");
INSERT INTO acfNT_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","èk yo koumansé ka akizéʼy. Yo di, “Nou jwenn nonm sala ka éséyé fè sé moun-an wivòlté. I di sé moun-an pa péyé gouvèdman-an taks, èk i ka éklamé ki i sé Mèsaya-a, an wa.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pons Pilat mandéʼy, “Ès ou sé wa sé Jwif-la?” Jézi wéponn li, “Sé ou menm ki diʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Kon sa Pons Pilat di sé chèf pwèt-la èk sé gany moun-an, “Mwen pa jwenn pyès wézon pou mwen kondanné nonm sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Mé yo té ka dispité plis toujou. Yo di, “Nonm sala ka tounen sé Jwif-la an péyi nou kont gouvèdman-an èk sa i ka enstwi-a. I koumansé dépi an Galili èk apwézan i ka vini isi-a.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Lè Pons Pilat tann sa, i mandé yo, “Ès nonm sala sé jan Galili?” ");
INSERT INTO acfNT_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Lè i vini konnèt ki Jézi sé jan Galili koté Wa Hèròd té ka kondwi, i voyéʼy bay Hèròd pou i sa jijéʼy, paski Hèròd té Jérouzalèm lè sala. ");
INSERT INTO acfNT_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hèròd té byen plè lè i wè Jézi, paski i té ja tann an chay bagay konsèné Jézi èk i té ka èspéyé lontan pou i té wèʼy. I té vlé wè Jézi fè miwak. ");
INSERT INTO acfNT_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Kon sa Hèròd mandé Jézi an chay kwèsyon, mé Jézi pa wéponn li pa yon mo pawòl. ");
INSERT INTO acfNT_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Sé chèf pwèt-la èk sé titja lwa sé Jwif-la doubout la ka fè vyé akizasyon kont Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kon sa Hèròd èk sé sòldaʼy-la koumansé ka motjé Jézi èk ka pwanʼy sèvi widitjil. Yo mété yon bèl abiman wa anlèʼy èk yo voyéʼy viwé bay Pons Pilat. ");
INSERT INTO acfNT_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Dépi jou sala Hèròd èk Pons Pilat vini jan. Avan sa yo sété lèlmi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pons Pilat kwiyé sé chèf pwèt-la, sé lézòt chèf-la èk sé moun-an ansanm, ");
INSERT INTO acfNT_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","èk i di yo, “Zòt mennen nonm sala ban mwen èk zòt di mwen i ka fè sé moun-an wivòlté kont gouvèdman-an. Bon, mwen ja kwèsyonnenʼy isi-a douvan zòt tout èk mwen pa jwenn li koupab pou pyès sé kwim-lan zòt ka akizéʼy pou-a. ");
INSERT INTO acfNT_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ni Hèròd pa jwenn li koupab, paski i voyéʼy viwé ban nou. Nonm sala pʼòkò fè anyen pou i méwité lanmò. ");
INSERT INTO acfNT_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Kon sa mwen kay fè yo bat li èk yon fwèt èk kitéʼy alé.”  ");
INSERT INTO acfNT_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Pou chak Fèt Délivwans sé Jwif-la, Pons Pilat té ni pou i ladjé yon pwizonnyé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Tout sé moun-an koumansé ka hélé fò, yo diʼy, “Tjwéʼy èk ladjé Barabas ban nou!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas té lajòl paski i té ka wivòlté kont gouvèdman-an èk i té tjwé yon moun. ");
INSERT INTO acfNT_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pons Pilat té vlé ladjé Jézi pito, kon sa i di sé moun-an sa ankò. ");
INSERT INTO acfNT_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Mé yo hélé pli fò, “Tjwéʼy anlè kwa-a! Anlè kwa-a pou li.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Kon sa pou twazyenm kou-a Pons Pilat di yo, “Mé ki kwim nonm sala ja fè? Mwen pa sa jwenn anyen i ja fè pou i sa mò. Mwen kay fè yo bat li èk ladjéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Mé yo kontiné ka andjélé pli fò èk tout vwa yo, ka di, “Klouwéʼy anlè kwa-a.” Èk yo jwenn sa yo té vlé-a paski yo andjélé otan fò. ");
INSERT INTO acfNT_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Kon sa Pons Pilat kondanné Jézi paski sé sa yo té ka mandé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","I ladjé nonm-lan yo té ka mandéʼy pou i ladjé-a, nonm-lan ki té lajòl paski i ka wivòlté kont gouvèdman-an èk paski i té tjwé on moun, èvèk i ba yo Jézi pou yo té sa tjwéʼy, paski sé sa yo té vlé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Sé sòlda-a pwan Jézi, yo alé épiʼy. Kon yo té ka alé, yo jwenn yon nonm yo ka kwiyé Simon, i sété jan Sayrini, i té sòti an hòtè ka alé an vil Jérouzalèm. Yo mété kwa-a anlèʼy èk yo fòséʼy pòté kwa-a èk swiv Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","An chay moun té ka swiv Jézi. Anpami yo té ni yon konpanni madanm ki té ka pléwé an chay ba li. ");
INSERT INTO acfNT_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Jézi tounen èk i di yo, “Fi vil Jérouzalèm! Pa pléwé ban mwen, mé pito pléwé pou kò zòt èk pou manmay zòt, ");
INSERT INTO acfNT_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","paski sé jou-a kay vini lè moun kay di ki madanm ki bwanhany ében madanm ki pa janmen fè ti manmay èk ba yo tété, yo chansé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Sa kay tan-an moun kay di sé montany-lan, ‘Tonbé anlè nou!’ èk yo kay di sé mòn-an, ‘Téwé nou.’ ");
INSERT INTO acfNT_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Paski si yo ka twété mwen ki inosan kon sa, ki mannyè yo kay twété sé moun-an ki koupab-la!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Yo pwan dé lézòt nonm osi, yo toulé dé sété kwiminèl, pou yo té tjwé yo ansanm èk Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Lè yo wivé an plas-la yo ka kwiyé ‘Kalòt Tèt-la,’ yo klouwé Jézi anlè kwa-a la épi sé dé kwiminèl-la, yonn anlè koté dwèt li èk lòt-la anlè koté gòch li. ");
INSERT INTO acfNT_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jézi di, “Papa, pawdonnen yo, paski yo pa sav ki sa yo ka fè-a.” Sé sòlda-a jwé gwenndé pou had li, yo sépawéʼy anpami yo. ");
INSERT INTO acfNT_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Sé moun-an doubout la ka gadé padan sé chèf sé Jwif-la té ka pwan Jézi sèvi widitjil. Yo di, “I té sa sové lézòt moun. Kité i sové kòʼy, si i sé Mèsaya-a Bondyé voyé èk chwazi-a!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Sé sòlda-a osi té ka pwanʼy sèvi widitjil. Yo vini èk yo ofèʼy diven wak ");
INSERT INTO acfNT_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","èk yo diʼy, “Sové kòʼw si ou sé wa sé Jwif-la!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Sé mo pawòl sala té ékwi anho tèt li, “Sa Sé Wa Sé Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Yonn anpami sé kwiminèl-la ki té anlè kwa-a bò Jézi-a koumansé ka ensiltéʼy. I diʼy, “Ès sé pa ou ki Mèsaya-a? Sové kòʼw èk sové nou osi!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Mé lòt nonm-lan doubout li, i diʼy, “Ès ou pa pè Bondyé? Nou tout anba menm pinisyon. ");
INSERT INTO acfNT_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nou méwité san nou jwenn-an, kon sa nou ka jwenn pinisyon pou sa nou fè-a, mé nonm sala pʼòkò fè anyen ki pa bon.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Èk i di Jézi, “Jézi, chonjé mwen lè ou kay vini kon wa!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jézi diʼy, “Mwen ka diʼw sa, jòdi-a ou kay an pawadi èk mwen.” ");
INSERT INTO acfNT_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","I té bò midi lè sòlèy-la doubout chofé èk fè nwè kouvè tout péyi-a jis lè i té bò twazè. Lè sala wido-a ki té an Kay Bondyé, i déchiwé an dé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jézi hélé èk tout fòs li, i di, “Papa, mwen ka délivwé lam mwen an lanmenʼw!” I di sa èk i mò. ");
INSERT INTO acfNT_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Yon ofisyé militè wè ki sa ki fèt-la èk i adowé Bondyé. I di, “Pou vwé nonm sala sété yon bon nonm!” ");
INSERT INTO acfNT_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Lè sé moun-an ki té vini pou wè kwisifiksyon-an wè sa ki fèt-la, yo tout viwé lakay yo ka bat lèstonmak yo paski sa yo wè-a fè yo lapenn. ");
INSERT INTO acfNT_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Mé tout sa ki té konnèt Jézi, yo doubout yon bon distans pou yo gadé sé bagay sala, anpami yo sété sé madanm-lan ki té ka swiv li dépi Galili. ");
INSERT INTO acfNT_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","La té ni yon nonm nonʼy sété Jozèf, i sété yon chèf ki ho an konsit sé Jwif-la èk i té ka wèsté adan yon vil sé Jwif-la yo ka kwiyé Arimatéya. I sété yon bon nonm, i té onnéwab èk i té ka èspéyé tan-an Bondyé kay kondwi-a vini. Magwé i sété yon chèf an kay konsèy sé Jwif-la, mé i pa té dakò èk disizyon sé lézòt-la konsèné Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","I alé oti Pons Pilat èk i mandéʼy pou i ba li kò Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Kon sa i dépann kò-a asou kwa-a, i vopléʼy adan yon dwa lenn blan èk i météʼy adan yon twou ki té adan yon kayè yo pʼòkò té téwé pyès moun adanʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","I sété yon jou Vandwédi, èk jou sabaf-la té kay koumansé. ");
INSERT INTO acfNT_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Sé madanm-lan ki té swiv Jézi dépi an Galili-a, yo alé épi Jozèf èk yo wè twou-a èk ki mannyè kò Jézi té mété kouché adanʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Kon sa yo viwé lakay yo èk yo pwépawé losyon èk fiksyon pou yo fwoté kò Jézi. Mé yo pozé asou jou sabaf-la kon lwa sé Jwif-la konmandé yo pou fè. ");
INSERT INTO acfNT_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Byen bonnè Dimanch bonmaten sé madanm-lan pwan fiksyon-an yo té fè-a èk yo alé an twou-a koté kò Jézi té yé-a. ");
INSERT INTO acfNT_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Lè yo wivé la yo jwenn wòch-la ki té ka bouché twou-a té ja woulé sòti. ");
INSERT INTO acfNT_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Kon sa yo antwé an twou-a, mé yo pa jwenn kò Jézi Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Yo té la ka katjilé ki sa ki wivé kò Jézi. Lè sala dé nonm annèk pawèt douvan yo, had yo té ka kléwé kon zéklè, èk yo doubout bò yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Sé madanm-lan té tèlman pè yo bésé tèt yo plat a tè, kon sa sé nonm-lan mandé yo, “Pouki zòt ka gadé pou sa ki vivan anpami sa ki mò? ");
INSERT INTO acfNT_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","I pa isi-a — i ja wésisité! Ès zòt pa chonjé sa i té di zòt lè i té an Galili èk zòt? ");
INSERT INTO acfNT_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","I té di, ‘Gason Lézòm ni pou tonbé anba lanmen nonm ki mové èk yo kay kwisifyéʼy, èk asou twazyenm jou-a i kay wésisité hòd lanmò.’ ” ");
INSERT INTO acfNT_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Lè sala yo chonjé sé pawòl-la Jézi té di yo-a. ");
INSERT INTO acfNT_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Kon sa yo witounen alé Jérouzalèm èk yo di sé wonz disip-la èk sé lézòt-la tout sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Sé madanm-lan ki di sé disip-la sa-a sété Mari Madlenn, Jowanna, Mari manman Jémz, èk sé lézòt madanm-lan ki té épi yo-a. ");
INSERT INTO acfNT_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Mé sé disip-la kwè ki sé madanm-lan té ka palé papicho èk yo pa té kwè yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Mé kanmenm, Pita lévé èk i kouwi alé an twou-a, i bésé èk i wè sé lenn-an ki té voplé kò Jézi-a tousèl èk i viwé ka katjilé ki sa ki té fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Menm jou sala dé anpami sé nonm-lan ki té ka swiv Jézi-a té ka alé adan yon vil yo ka kwiyé Imayòs, ki té apipwé sèt lyé hòd Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Yo té ka palé èk yonn a lòt konsèné tout sé bagay-la ki fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Kon yo té ka palé èk ka mandé yonn a lòt kwèsyon konsèné sé bagay sala ki fèt-la, Jézi menm vini ka maché ansanm épi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mé yo pa té sa wè sé Jézi ki té la, paski Bondyé anpéché yo wè moun-an ki té la épi yo-a sété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jézi mandé yo, “Ki sa zòt ka dispité kon zòt ka maché ansanm la?” Kon sa yo doubout la byen twis. ");
INSERT INTO acfNT_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Yonn anpami yo nonʼy sété Kliyopas diʼy, “I sanm ou sé sèl moun an Jérouzalèm ki pʼòkò tann ki sa ki fèt-la sé jou sala.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jézi mandéʼy, “Ki sa ki fèt-la?” I wéponn, “Konsèné sa ki wivé Jézi jan Nazawèt. I sété yon pwòfèt. Bondyé té épiʼy, épi i té ka palé èk fè bagay èk an chay pouvwa douvan tout moun. ");
INSERT INTO acfNT_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Sé chèf pwèt-la èk sé chèf sé moun-an livwéʼy an lanmen sé chèf péyi Ronm-lan pou yo kondannéʼy pou i mò, èk yo kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Mé nou té ka kwè i sété moun-an ki té kay délivwé sé jan Izwayèl-la hòd tout twaka yo. Èk apa di tout sa, jòdi-a sé twa jou dépi sé bagay sala fèt. ");
INSERT INTO acfNT_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Èk yon konpanni sé madanm-lan ki té anpami nou-an sipwi nou. Bonnè bonmaten yo alé an twou-a koté yo té mété kò Jézi-a ");
INSERT INTO acfNT_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mé yo pa jwenn kò-a pyès. Yo vini di nou yo wè yon vizyon. An vizyon-an yo wè nanj ki di yo Jézi vivan. ");
INSERT INTO acfNT_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Kon sa yon konpanni an sé kanmawad nou-an alé an twou-a èk yo wè menm sa sé madanm-lan di nou-an. Yo gadé pou kò Jézi mé yo pa wèʼy nonplis.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Kon sa Jézi di yo, “Zòt sa kouyon èk mal a konpwann! Ès zòt pa kwè tout sé bagay-la sé pwòfèt-la di-a? ");
INSERT INTO acfNT_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Ès i pa té nésésè pou Mèsaya-a té soufè sé bagay sala, èk apwé sa i kay jwenn wèspé?” ");
INSERT INTO acfNT_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Kon sa Jézi èspliké ba yo tout sé bagay-la ki té ékwi an lévanjil konsènéʼy-la, i koumansé dépi an liv Moziz èk i kontiné èvèk sé ékwiti sé pwòfèt-la. ");
INSERT INTO acfNT_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Lè yo wivé tou pwé vil-la yo té ka alé-a, Jézi fè akwèdi i té ka alé pli lwen, ");
INSERT INTO acfNT_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","mé yo tjenn li dèyè, yo di, “Wèsté épi nou. Jouné-a ja pwèskè fini èk i ja ka fè nwè.” Kon sa i alé épi yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","I asid pou manjé épi yo, i pwan pen-an èk i mandé Bondyé pou benniʼy. Lè i fini i sépawé pen-an èk i ba yo li. ");
INSERT INTO acfNT_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Lè sala, sé menm konmsidi zyé yo ouvè èk yo wè sé Jézi ki té la épi yo. Mé i annèk dispawèt douvan yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Èk yo di bay yonn a lòt, “Ès nou pa santi akwèdi tjè nou té ka bat èk lakontantman lè i té ka palé ban nou anlè chimen-an èk èspliké lévanjil-la ban nou-an?” ");
INSERT INTO acfNT_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Kon sa yo lévé vitman èk yo viwé alé Jérouzalèm èk yo jwenn sé wonz disip-la asanblé ansanm èvèk sé lézòt-la, ");
INSERT INTO acfNT_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","èk yo té ka di, “Mèt-la ja wésisité pou vwé! I pawèt douvan Simon.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Lè sala sé dé nonm-lan wakonté yo sa ki fèt anlè chimen-an èk mannyè yo wè sé Jézi ki té la épi yo lè i sépawé pen-an. ");
INSERT INTO acfNT_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Padan yo té ka di sé disip-la sa, Jézi menm annèk pawèt èk i doubout anpami yo èk i di yo, “Lapé èk zòt.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Yo tout té pè an chay, yo kwè sé yon lèspwi yo wè. ");
INSERT INTO acfNT_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Mé i di yo, “Pouki pou zòt pè kon sa? Pouki pou zòt ka mandé kò zòt ki moun mwen yé? ");
INSERT INTO acfNT_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Gadé lanmen mwen èk pyé mwen èk wè ki sé mwen menm. Touché mwen èk gadé mwen, paski lèspwi pa ni lachè èk zo kon zòt ka wè mwen ni.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","I di yo sa èk i moutwé yo lanmenʼy èk pyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Yo té tèlman kontan èk étonnen yo pa té sa kwè sé li. Kon sa i mandé yo, “Ès zòt ni anyen pou manjé isi-a?” ");
INSERT INTO acfNT_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Yo ba li yon mòso pwéson ki tjwit, ");
INSERT INTO acfNT_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","i pwanʼy èk i manjéʼy douvan yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Lè sala i di yo, “Sa sé menm sé bagay-la mwen té di zòt-la padan mwen té la èk zòt toujou. Mwen té di zòt, tout sa Moziz èk sé pwòfèt-la té ékwi konsèné mwen, èk tout sa ki ékwi konsèné mwen an liv Samz-la, té ni pou fèt.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Lè sala i fè yo konpwann lévanjil-la ");
INSERT INTO acfNT_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","èk i di yo, “Mi sé sa ki ékwi. Mèsaya-a ni pou soufè èk wésisité asou twazyenm jou-a, ");
INSERT INTO acfNT_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","èk an non mwen ou ni pou pwan konmisyon sala sòti Jérouzalèm bay sé moun-an an tout nasyon, ki Bondyé kay pawdonnen péché yo si yo té kay wépanti. ");
INSERT INTO acfNT_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ou ja wè sé bagay sala èk ou ni pou di lézòt konsèné yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Èk mwen menm kay voyé anlè zòt sa Papa mwen ja pwonmèt. Mé zòt ni pou wèsté an vil-la jis tan zòt wisivwè pouvwa sala sòti an syèl.” ");
INSERT INTO acfNT_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Kon sa Jézi mennen yo sòti an vil-la èk i mennen yo tou pwé Bèfanni. Lè yo wivé la i lévé lanmenʼy anlè èk i benni yo. ");
INSERT INTO acfNT_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Kon i té ka benni yo i kité yo èk i mouté an syèl. ");
INSERT INTO acfNT_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Yo adowéʼy èk yo viwé alé Jérouzalèm ka widjèwté, ");
INSERT INTO acfNT_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","èk yo pasé tout tan yo an Kay Bondyé ka wimèsyé Bondyé.");
INSERT INTO acfNT_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Avan anyen té fèt, Pawòl-la té ja la. Pawòl-la té la épi Bondyé, èk Pawòl-la sété Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Pawòl-la té la dépi an koumansman-an èk Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Sété Pawòl-la Bondyé sèvi pou fè tout bagay, épi la pa té ni anyen ki té fèt si sé pa li ki té fèʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Sé an li lavi sòti. Lavi sala i ni-an té bay tout moun klèté. ");
INSERT INTO acfNT_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Klèté-a ka kléwé an nwèsè èk nwèsè-a pa janmen étenn klèté-a. ");
INSERT INTO acfNT_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Bondyé voyé an konmisyonnè, an nonm yo té ka kwiyé Jan Batis. ");
INSERT INTO acfNT_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Jan Batis vini pou di moun lavéwité-a konsèné klèté-a pou tout moun ki tann lavéwité-a sa kwè. ");
INSERT INTO acfNT_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Sé pa li ki té klèté-a, mé i vini pou di moun lavéwité-a konsèné klèté-a. ");
INSERT INTO acfNT_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Klèté sala sé bon klèté-a ki vini asou latè-a èk sé li ki ka kléwé tout moun. ");
INSERT INTO acfNT_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Pawòl-la té an latè-a, èk magwé sé li Bondyé sèvi pou fè latè-a, sé jan latè-a pa té menm konnèt li. ");
INSERT INTO acfNT_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","I vini an péyiʼy menm, mé sé jan péyiʼy-la pa wisivwèʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Mé adan té wisivwèʼy èk kwè an li, kon sa i ba yo dwa pou yo sa vini ich Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Yo pa vini ich Bondyé mannyè ti manmay ka fèt an latè-a, mannyè manman èk papa ka fè plan pou ni ti manmay, mé sé Bondyé menm ki fè yo vini ich li. ");
INSERT INTO acfNT_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Pawòl-la tounen an moun èk i viv anpami nou. I té plen lagwas èk i moutwé nou ki moun Bondyé yé pou vwé. Nou wè pouvwaʼy, sété pouvwa-a Papa-a té bay sèl Gasonʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Sété li Jan Batis té ka palé lè i té di byen fò, “Mi moun sala mwen té ka palé-a lè mwen té di, ‘I ka vini apwé mwen, mé i pli enpòtan pasé mwen, paski i té la avan mwen té fèt.’ ” ");
INSERT INTO acfNT_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Paski i té ni tèlman lagwas, i benni nou tout. I ban nou bennédiksyon yonn asou lòt. ");
INSERT INTO acfNT_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Sé Moziz Bondyé té sèvi pou bay sé jan Izwayèl-la lwa-a, mé sé Jézi Kwi Bondyé sèvi pou voyé lagwas èk pou moutwé nou ki moun Bondyé yé pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Pyèsonn pa janmen wè Bondyé. Sèl Gason-an, ki sé menm èk Bondyé èk ki a koté Papaʼy, sé li ki fè moun konnèt Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Sé chèf Jwif-la an vil Jérouzalèm voyé déotwa pwèt èk nonm bwanch lafanmi Livay koté Jan Batis, yo mandéʼy, “Ki moun ou yé?” ");
INSERT INTO acfNT_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Jan Batis pa té wifizé wéponn yo, mé i di yo aklè, san i séwé yo anyen. I di yo, “Sé pa mwen ki Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Yo diʼy, “Bon, kilès ou yé? Ès ou sé Ilaydja?” Jan Batis di, “Non, mwen sé pa Ilaydja.” Yo diʼy, “Ès ou sé Pwòfèt-la ki té pou vini-an?” I wéponn yo, “Non.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Yo di, “Si sé sa, di nou ki moun ou yé. Nou ni pou mennen wépons-lan viwé bay sé moun-an ki voyé nou-an. Ki sa ou ni pouʼw di asou kòʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Jan Batis wéponn, i di yo: “Mwen sé ‘vwa an moun ki ka kwiyé byen lwen an hòtè: Fè an chimen ki dwèt bay Senyè-a pouʼy sa pasé!’ ” Sé sa pwòfèt Izaya té di. ");
INSERT INTO acfNT_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Sé konmisyonnè-a sé Fawizyen-an té voyé-a mandé Jan Batis, ");
INSERT INTO acfNT_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Si ou sé pa Mèsaya-a, ou sé pa Ilaydja, ou sé pa Pwòfèt-la, pouki ou ka batizé moun?” ");
INSERT INTO acfNT_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Jan Batis wéponn yo, i di, “Mwen ka batizé èk dlo, mé la ni yon moun ki doubout anpami zòt menm èk zòt pa konnèt li. ");
INSERT INTO acfNT_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Moun sala ka vini apwé mwen, mé mwen pa menm vo pou délasé soulyéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Tout sé bagay sala pwan kou an Bèfanni bò Lawivyè Jouden-an koté Jan Batis té ka batizé-a, asou fasad sòlèy lévan. ");
INSERT INTO acfNT_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","An li denmen, Jan Batis wè Jézi ka vini koté i té yé-a. I di, “Mi Ti Mouton Bondyé-a. Sé li Bondyé voyé pou tiwé péché an latè-a! ");
INSERT INTO acfNT_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Sé li mwen té ka palé lè mwen té di, ‘An nonm ka vini apwé mwen, mé i pli enpòtan pasé mwen, paski i té la avan mwen té fèt.’ ");
INSERT INTO acfNT_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Mwen pa té konnèt ki moun i té kay yé, mé wézon-an mwen té ka batizé zòt an dlo-a sété pou fè zòt sé jan Izwayèl-la konnèt li.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Mi sa Jan Batis di konsèné Jézi Kwi: “Mwen wè Lèspwi Bondyé sòti an syèl désann menm kon an toutwèl, èk Lèspwi-a wèsté épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Mwen pʼòkò té sav sé li ki té moun-an Bondyé té pwonmèt pou voyé-a. Mé Bondyé ki té voyé mwen batizé moun èk dlo, té ja di mwen, ‘Ou kay wè Lèspwi mwen désann èk wèsté épi an nonm. Sé li ki kay batizé moun èk Lèspwi Bondyé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Jan Batis di, “Mwen wè sa fèt èk mwen ka diʼw sé li ki Gason Bondyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","An li denmen ankò, Jan Batis té doubout la èk dé an sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Lè i wè Jézi ka pasé, i di, “Mi Ti Mouton Bondyé-a!” ");
INSERT INTO acfNT_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Dé disip li-a tann lè i di sa èk yo pati èk Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jézi tounen èk i wè yo ka swiv li, i mandé yo, “Ki sa zòt ka chaché?” Yo di, “Rabay, koté ou ka wèsté?” (Sa vlé di Titja.) ");
INSERT INTO acfNT_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Jézi di yo, “Vini wè.” I té bò katwè apwémidi. Kon sa yo pati épiʼy èk yo wè koté i té ka wèsté, èk yo pasé lèstan jouné-a épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Yonn adan yo sété Androu, fwè Simon Pita. ");
INSERT INTO acfNT_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Menm lè-a i jwenn fwèʼy, i diʼy, “Nou ja jwenn wa-a Bondyé té pwonmèt pou voyé-a, moun-an nou ka kwiyé Mèsaya-a” (an langaj Grik-la non sala sé Kwis). ");
INSERT INTO acfNT_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Èk Androu pwan Simon èk i mennenʼy bay Jézi. Jézi gadé Simon èk i diʼy, “Nonʼw sé Simon gason Jan, mé yo kay kwiyéʼw Sifas” (non sala sé an non menm kon Pita ki vlé di “an kayè”). ");
INSERT INTO acfNT_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","An li denmen, Jézi té fè lidé pou alé Galili. Jézi jwenn Filip èk i diʼy, “Swiv mwen!” ");
INSERT INTO acfNT_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filip té sòti Bèfsayda, vil-la koté Androu èk Pita té ka wèsté-a. ");
INSERT INTO acfNT_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filip jwenn Natannyèl èk i diʼy, “Nou ja jwenn moun-an Moziz èk sé pwòfèt-la té ékwi asou an liv lwa-a. Nonʼy sé Jézi, gason Jozèf, i sòti Nazawèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Natannyèl diʼy, “Ki bon bagay ki sa sòti an Nazawèt?” Filip diʼy, “Vini wè.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Lè Jézi wè Natannyèl ka vini koté i yé-a, i di, “Mi an jan Izwayèl pi, la pa ni pyès wiz an li!” ");
INSERT INTO acfNT_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Natannyèl mandéʼy, “Ki mannyè ou fè konnèt mwen?” Jézi diʼy, “Mwen wèʼw lè ou té anba pyé fwi-a dépi avan Filip té kwiyéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Natannyèl diʼy, “Titja, ou sé Gason Bondyé! Sé ou ki wa Izwayèl!” ");
INSERT INTO acfNT_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Jézi diʼy, “Ès sé paski mwen di mwen wèʼw anba pyé fwi-a ou kwè sa? Ou kay wè pli gwo bagay pasé sa!” ");
INSERT INTO acfNT_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","I di yo, “Mwen ka di zòt lavéwité-a, ou kay wè syèl-la ouvè èk nanj Bondyé ka mouté désann asou mwen Gason Lézòm-lan.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Dé jou apwé sa, la té ni an mawiyaj an vil Kéna an Galili. Manman Jézi té la. ");
INSERT INTO acfNT_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Yo té envité Jézi épi sé disip li-a an nòs-la tou. ");
INSERT INTO acfNT_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Paditan yo té an nòs-la, diven-an vin fini. Lè diven-an fini, manman Jézi diʼy, “Sé moun-an pa ni diven ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Jézi wéponn li, i diʼy, “Madanm, sa pa zafè ni mwen ni ou. Tan mwen pʼòkò wivé.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Manman Jézi di sé sèvant-lan, “Sé pou zòt fè tout sa Jézi di zòt fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Plas-la koté yo té yé-a té ni sis jè ki té fèt èk wòch. Sé Jwif-la té ka sèvi yo pou mété dlo pou pwépawé kò yo kon lwa wilizyon yo di. Chak sé jè-a té ka tjenbé ven (20) pou twant (30) galon dlo. ");
INSERT INTO acfNT_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Jézi di sé sèvant-lan, “Plen sé jè sala épi dlo.” Kon sa sé sèvant-lan plen sé jè-a owa djòl. ");
INSERT INTO acfNT_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Lè yo fini, Jézi di sé sèvant-lan, “Bon, apwézan pwan tibwen dlo èk mennenʼy bay mèt-la ki wèskonsab mawiyaj-la.” Kon sa sé sèvant-lan mennen dlo-a bay mèt mawiyaj-la. ");
INSERT INTO acfNT_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Lè mèt mawiyaj-la gouté dlo-a Jézi té fè tounen diven-an, i pa té sav koté diven sala sòti, mé sèvant-lan ki té mennen dlo-a té sav ki sa ki té fèt-la. Kon sa mèt mawiyaj-la kwiyé nonm-lan ki té ka mayé-a, ");
INSERT INTO acfNT_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","i diʼy, “Lè moun ka mayé, yo ka mennen pli bon diven-an avan, èk sé lè sé moun-an ja ka vini sou, yo ka mennen vyé diven-an. Mé ou ja kité pli bon diven-an pou atjwèlman!” ");
INSERT INTO acfNT_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Jézi fè pwèmyé miwak sala an vil Kéna an Galili. Jézi moutwé pouvwaʼy la, èk sé disip-la ki té épiʼy-la vin kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Apwé sa, Jézi désann an vil Kapènéyòm. Manmanʼy, sé fwèʼy-la èk sé disip li-a té alé épiʼy tou. Yo wèsté Kapènéyòm pou déotwa jou. ");
INSERT INTO acfNT_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","I té pwèskè tan pou Fèt Délivwans sé Jwif-la, kon sa Jézi mouté Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Lè i wivé la, i antwé an Kay Bondyé-a. I jwenn nonm ka vann bèf, mouton épi pijon an lakou-a, èk i wè nonm asid bò tab ka chanjé lajan. ");
INSERT INTO acfNT_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Kon sa i fè on fwèt épi déotwa mòso kòd épi i mété yo tout dèwò Kay Bondyé-a, ansanm èk sé mouton-an èk sé bèf-la. Jézi maté sé tab-la koté yo té ka chanjé lajan-an èk i simen lajan atè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Jézi di sé moun-an ki té ka vann pijon-an, “Tiwé sé bagay sala isi-a nèt. Las fè kay Papa mwen an kay koté pou zòt vann èk achté pou zòt fè lajan!” ");
INSERT INTO acfNT_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Lè sa fèt, sé disip Jézi-a chonjé sa ki té ékwi an lévanjil-la koté i di: “Lanmityé-a mwen ni pou Kay ou-a ka bwilé andidan mwen menm kon an difé.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Sé chèf Jwif-la di Jézi, “Fè an miwak pou nou wè ou ni dwa pou fè sé bagay sala ou fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Jézi wéponn, i di yo, “Kwazé Kay sala, èk mwen kay viwé batiʼy ankò an twa jou.” ");
INSERT INTO acfNT_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Sé Jwif-la diʼy, “Sé moun-an ki fè Kay Bondyé-a pwan kawant sis (46) lanné pou fèʼy. Ou vlé di ou kay sa viwé batiʼy an twa jou?” ");
INSERT INTO acfNT_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Mé lè Jézi té di Kay Bondyé-a, i té ka palé konsèné kòʼy menm. ");
INSERT INTO acfNT_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Apwé Jézi té wésisité, sé disip li-a chonjé i té ja di yo sa. Kon sa yo vini kwè sa lévanjil-la té di konsèné Jézi-a èk yo vini kwè pawòl Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Paditan Jézi té an Jérouzalèm pou Fèt Délivwans-lan, an chay moun mété lafwa yo an li lè yo wè sé miwak-la i fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mé Jézi pa té ka konfyé yo, paski i konnèt mannyè moun ka katjilé. ");
INSERT INTO acfNT_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Jézi pa té bizwen pyèsonn pou diʼy anyen asou pyèsonn, paski i sav sa ki té an lidé chak moun. ");
INSERT INTO acfNT_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","La té ni an nonm enpòtan anpami sé Jwif-la yo té ka kwiyé Nikodimòs. I té an gany sé moun-an yo ka kwiyé Fawizyen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Yon jou òswè i alé koté Jézi, i diʼy, “Rabay, nou sav ou sé on titja Bondyé voyé. Pyèsonn pa sa fè sé miwak sala ou ka fè-a si Bondyé pa épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Jézi wéponn li, i diʼy, “Mwen ka diʼw lavéwité-a, pyèsonn pa sa konnèt mannyè Bondyé ka kondwi sé moun li-an si i pa viwé fèt ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nikodimòs di, “Ki mannyè an gwan nonm ka fè viwé fèt ankò? Ki mannyè i ka fè viwé antwé an bouden manmanʼy pouʼy fèt an dézyenm fwa?” ");
INSERT INTO acfNT_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Jézi diʼy, “Mwen ka diʼw lavéwité-a, pyèsonn pa sa antwé anpami sé moun-an Bondyé ka kondwi-a si i pa fèt èk dlo èk Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Sé an manman èk an papa ki ka fè an moun, mé sé Lèspwi Bondyé ki ka fè lèspwi-a moun-an ni andidanʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Pouki ou sipwi kon sa paski mwen diʼw, ‘Zòt tout oblijé fèt ankò?’ ");
INSERT INTO acfNT_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Van-an ka vanté koté i vlé. Ou ka tann son-an mé ou pa sav koté van-an sòti, ni koté i ka alé. Sé menm mannyè-a èk moun-an ki fèt èk Lèspwi Bondyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Nikodimòs di, “Ki mannyè sa ka fè fèt?” ");
INSERT INTO acfNT_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Jézi diʼy, “Ou sé an titja ki enpòtan anpami sé jan Izwayèl-la, èk ou pa konnèt sé bagay sala? ");
INSERT INTO acfNT_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Mwen ka diʼw lavéwité-a, nou ka diʼw bagay nou konnèt épi sa nou ja wè, mé zòt pyès pa vlé kwè sa nou ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ou pa ka kwè mwen lè mwen ka sèvi ègzanp asou bagay ki an latè-a. Bon, ki mannyè ou kay fè kwè si mwen sèvi ègzanp asou bagay ki an syèl? ");
INSERT INTO acfNT_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Pyès moun pa janmen mouté an syèl antiwan mwen Gason Lézòm-lan yonn, ki désann sòti an syèl-la. ");
INSERT INTO acfNT_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Menm kon Moziz té lévé sèpan-an i té fè an tjwiv-la anlè poto-a an gwan savann sèk-la, sé menm mannyè-a yo kay lévé Gason Lézòm-lan anlè, ");
INSERT INTO acfNT_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","pou tout moun ki kwè an li sa ni lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Bondyé té tèlman enmen sé jan latè-a, i bay sèl Gasonʼy-lan pou yo. Tout moun ki kwè an li pa kay pèd lavi yo, mé yo kay ni lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Bondyé pa té voyé Gasonʼy an latè-a pouʼy té kondanné sé jan latè-a mé pouʼy té sa sové yo. ");
INSERT INTO acfNT_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Moun-an ki ka kwè an Gason-an pa ka jwenn kondannasyon, mé moun-an ki pa ka kwè-a ja kondanné dépi atjwèlman, paski i pa mété lafwaʼy an sèl Gason Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Mi pou sa Bondyé ka kondanné latè-a: Klèté-a ja vini an latè-a, mé moun simyé nwèsè pito klèté-a, paski sé movèzté yo ka fè. ");
INSERT INTO acfNT_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Moun-an ki ka fè mové-a hayi klèté-a èk i pa kay vini an klèté-a, paski i pa vlé moun wè sé mové bagay-la i ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Mé moun-an ki ka swiv chimen lavéwité-a ka kité klèté-a kléwé anlèʼy pou moun wè i ka obéyi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Apwé sa, Jézi èk sé disip li-a alé an lòt koté an Joudiya. I wèsté pou tibwen tan épi yo èk i té ka batizé moun. ");
INSERT INTO acfNT_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Jan Batis té ka batizé tou an Énonn, an plas ki pa té lwen Salim, paski an plas sala té ni an chay dlo. Moun té ka alé koté i té yé-a, èk i té ka batizé yo. ");
INSERT INTO acfNT_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Sa té fèt avan yo té mété Jan Batis an pwizon). ");
INSERT INTO acfNT_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Déotwa an sé disip Jan Batis-la té ni an chikann épi on Jwif asou mannyè pou moun pwépawé kò yo kon lwa wilizyon yo di. ");
INSERT INTO acfNT_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Kon sa yo alé koté Jan Batis èk yo diʼy, “Titja, ou chonjé nonm-lan ki té épiʼw-la lè ou té lòt bò Lawivyè Jouden-an, menm sa ou té ka palé-a? Ében, i ka batizé moun atjwèlman, èk tout moun ka alé kotéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Jan Batis wéponn, i di, “Sé Bondyé ki ka bay chak moun twavay yo. ");
INSERT INTO acfNT_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Zòt tout té la lè mwen té di sé pa mwen ki Mèsaya-a, mé Bondyé té ja voyé mwen avanʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Madanm-lan ki ka mayé-a sé sa misyé-a ki ka mayé épiʼy-la. Mé kanmawad-la ki ka édé misyé-a ki ka mayé-a ka èspéyé èk i ka kouté, èk pa dé kontan i ka kontan lè i tann vwa misyé-a ki ka mayé-a. Sé kon sa tjè mwen kontan atjwèlman. ");
INSERT INTO acfNT_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Sé pou Jézi ni plis moun ki ka swiv li èk sé pou mwen ni mwens moun. ");
INSERT INTO acfNT_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“I sòti an syèl-la èk i anho tout lézòt. Mwen ki sòti an latè-a sé jan latè-a, èk sé bagay ki ka fèt an latè-a tousèl mwen konnèt. Mé li ki sòti an syèl pli ho pasé tout lézòt. ");
INSERT INTO acfNT_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","I ka di sa i ja wè èk sa i ja tann, mé pyèsonn pa ka kwè pawòl li. ");
INSERT INTO acfNT_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Mé moun-an ki kwè pawòl li-a ka moutwé tout sa Bondyé di sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Moun-an Bondyé voyé-a ka palé pawòl Bondyé, paski Bondyé ka ba li Lèspwiʼy san miziwé. ");
INSERT INTO acfNT_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Papa-a enmen Gason-an èk i ja ladjé tout bagay anba kondwit li. ");
INSERT INTO acfNT_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Moun-an ki kwè an Gason-an ni lavi étonnèl. Moun-an ki dézobéyi Gason-an pa kay janmen ni lavi sala. Bondyé kay kontiné piniʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Sé Fawizyen-an tann pli moun té ka alé koté Jézi pouʼy té batizé yo èk pou yo té vini disip li pasé sa ki té ka alé koté Jan Batis. ");
INSERT INTO acfNT_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Magwé pou di lavéwité-a, Jézi menm pa batizé pyèsonn. Sé disip li-a yonn ki batizé moun ba li.) ");
INSERT INTO acfNT_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Jézi té sav sa sé Fawizyen-an té tann konsènéʼy-la, kon sa i kité Joudiya èk i déviwé Galili. ");
INSERT INTO acfNT_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Asou chimenʼy pouʼy alé Galili, i té ni pou pasé an péyi Sanmariya. ");
INSERT INTO acfNT_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Lè i wivé Sanmariya, i pasé adan an vil yo ka kwiyé Sayka, ki pa té lwen tjò tè-a Jakòb té bay gasonʼy Jozèf an tan lontan-an. ");
INSERT INTO acfNT_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Pi Jakòb-la té la, èk maché-a té fè Jézi tèlman las, kon sa i asid bò djòl pi-a ka pozé. I té bò midi. ");
INSERT INTO acfNT_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","On madanm Sanmariya vini pwan dlo an pi-a, kon sa Jézi diʼy, “Ban mwen tak dlo pou bwè.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Sé disip li-a té ja alé an vil ay achté manjé pou yo manjé.) ");
INSERT INTO acfNT_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Madanm-lan wéponn, i di, “Ou sé an Jwif, èk mwen sé an jan Sanmariya. Ki mannyè ou ka fè mandé mwen dlo pou bwè?” (Jwif pa ka sèvi menm vésèl èk jan Sanmariya.) ");
INSERT INTO acfNT_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Jézi wéponn, i diʼy, “Si ou té konnèt kado-a Bondyé ka bay-la épi ki moun ki ka mandéʼw dlo pou bwè-a, ou menm té kay mandéʼy dlo, èk i té kay baʼw dlo-a ki ka bay lavi-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Madanm-lan di, “Misyé, ou pa ni an bonm, épi pi-a fon. Koté ou kay jwenn dlo sala ki ka bay lavi-a? ");
INSERT INTO acfNT_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Sété Jakòb gwan gwanpapa lontan nou ki té ban nou pi sala. Li épi sé gasonʼy-lan épi tout zannimoʼy té bwè dlo adanʼy. Ki sa ou vlé di mwen la-a, ou pli enpòtan pasé Jakòb?” ");
INSERT INTO acfNT_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Jézi wéponn, i di, “Népòt moun ki bwè dlo sala kay swèf ankò, ");
INSERT INTO acfNT_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","mé népòt moun ki bwè dlo-a mwen kay ba li-a pa kay janmen swèf ankò. Dlo-a mwen ka bay-la kay menm kon an sous andidanʼy ki ka kontiné voyé dlo mouté, èk dlo sala kay ba li lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Madanm-lan di, “Misyé, ban mwen dlo sala! Mwen pa kay janmen swèf ankò, èk mwen pa kay ni pou viwé isi-a vin pwan dlo.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Jézi diʼy, “Alé kwiyé mawiʼw, èk mennenʼy vini.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Madanm-lan di, “Mwen pa ni mawi.” Jézi wéponn, i diʼy, “Sa vwé lè ou di ou pa ni mawi, ");
INSERT INTO acfNT_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","paski ou ja mayé senk nonm, èk sa ou ni ka dòmi lévé épiʼw atjwèlman-an sé pa mawiʼw pyès, kon sa ou ja di mwen lavéwité-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Madanm-lan di, “Misyé, i sanm ou sé an pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Lafanmi mwen an tan lontan té ka adowé Bondyé asou mòn sala, mé zòt sé Jwif-la ka di sé an Jérouzalèm moun sipozé adowé Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Jézi diʼy, “Madanm, ou pé kwè mwen, lè-a ka vini lè moun pa kay adowé Papa-a ni asou mòn sala ni an Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Zòt jan Sanmariya pa menm sav ki moun zòt ka adowé, mé nou sé Jwif-la sav ki moun nou ka adowé, paski Bondyé ka sèvi sé Jwif-la pou mennen salvasyon bay moun. ");
INSERT INTO acfNT_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Tan-an ka vini èk i ja wivé, lè Lèspwi Bondyé kay édé moun adowé Bondyé kon Bondyé yé pou vwé. Yo kay adowé Bondyé kon moun sipozé adowéʼy, kalité mannyè-a i vlé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Bondyé sé lèspwi i yé, èk sé Lèspwi Bondyé ki ka édé moun adowé Bondyé kon Bondyé yé pou vwé.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Madanm-lan diʼy, “Mwen sav Mèsaya-a, moun-an yo ka kwiyé Kwis-la, kay vini, èk lè i vini, i kay di nou tout bagay.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Jézi diʼy, “Mwen ki ka palé épiʼw la-a, sé mwen ki li.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Menm lè sala sé disip Jézi-a déviwé, èk yo té sipwi an chay pou yo té jwenn li ka palé bay an madanm, mé yo pyès pa di, “Ki sa ou vlé?” ében, “Pouki ou ka palé épiʼy?” ");
INSERT INTO acfNT_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Madanm-lan menm kité sé jèʼy-la, èk i déviwé an vil-la, èk i di sé moun-an, ");
INSERT INTO acfNT_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Vini wè moun-an ki di mwen tout sa mwen ja janmen fè. Ou pa kwè sé li ki Mèsaya-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Kon sa yo kité vil-la èk yo alé koté Jézi té yé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Menm lè sala sé disip-la koumansé flaté Jézi pouʼy sa manjé, yo diʼy, “Titja, manjé kéchòy, on!” ");
INSERT INTO acfNT_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Mé i di yo, “Mwen ja manjé on manjé zòt pa konnèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Kon sa sé disip-la koumansé ka palé anpami kò yo menm, yo di, “Ou kwè an moun ja ba li manjé?” ");
INSERT INTO acfNT_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Jézi di yo, “Lè mwen obéyi moun-an ki voyé mwen-an èk mwen fin fè twavay-la i voyé mwen fè-a, sa sé menm kon manjé pou mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Lè zòt planté an jaden, zòt ka di, ‘Nou kay wékòltéʼy an kat mwa,’ mé mwen ka diʼw, lévé zyéʼw èk gadé jaden-an byen. Sé fwi-a ja mi èk yo ja bon pou moun wékòlté yo. ");
INSERT INTO acfNT_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Yo ka péyé moun-an ki wékòlté jaden-an épi ki antwé sé fwi-a pou lavi étonnèl-la. Kon sa moun-an ki planté-a èk moun-an ki wékòlté-a kay ni tjè kontan ansanm. ");
INSERT INTO acfNT_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Sa moun ka di-a vwé: ‘Yon moun ka planté, èk sé an lòt ki ka wékòlté.’ ");
INSERT INTO acfNT_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Mwen ja voyéʼw wékòlté an jaden ou pa planté. Sé an lòt moun ki planté jaden sala, mé sé ou ki ka jwenn pwofi twavay-la yo fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","An pil sé jan Sanmariya-a té kwè an Jézi paski madanm-lan té di yo, “I di mwen tout bagay mwen ja janmen wivé fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Kon sa lè sé jan Sanmariya-a vin kotéʼy, yo diʼy, “Souplé, vini wèsté épi nou.” Jézi wèsté épi yo pou dé jou. ");
INSERT INTO acfNT_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","An pil lézòt ankò té kwè an li pou lapéti sa i té ka di yo-a, ");
INSERT INTO acfNT_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","èk sé moun-an di madanm-lan, “Nou kwè atjwèlman, sé pa paski ou di nou sa ou di nou-an tousèl, mé paski nou tann li pou kò nou èk nou sav sé li ki ka sové sé jan latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Apwé Jézi wèsté dé jou la, i kité èk i alé Galili, ");
INSERT INTO acfNT_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","paski i menm té ja di, “An pwòfèt pa ka ni wèspé an péyiʼy menm.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Sé jan Galili-a ki té alé Jérouzalèm an Fèt Délivwans-lan té wè tout sé miwak-la i té fè an fèt-la. Kon sa lè Jézi wivé Galili, sé moun-an té kontan pou wèʼy, épi yo wisivwèʼy byen. ");
INSERT INTO acfNT_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Jézi viwé an vil Kéna an Galili, koté i té ja fè dlo-a tounen diven-an. La té ni yon ofisyé wa-a ki té ni an ti gason ki té malad an Kapènéyòm. ");
INSERT INTO acfNT_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Lè i tann Jézi té wivé Galili sòti Joudiya, i alé kotéʼy épi i mandéʼy pouʼy sa désann Kapènéyòm pouʼy sa djéwi gasonʼy, paski gason-an té ja pwès mò. ");
INSERT INTO acfNT_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Jézi diʼy, “Zòt pyès pa vlé kwè an mwen tout tan zòt pa wè mwen fè miwak èk gwan twavay.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ofisyé-a di, “Misyé, annou èk mwen avan gason mwen-an mò.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Jézi diʼy, “Alé, gasonʼw-lan kay vini byen!” Nonm-lan kwè sa Jézi diʼy-la èk i pati. ");
INSERT INTO acfNT_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Lè i wivé asou chimen, sé sèvant li-a vini jwenn li épi bon nouvèl. Yo diʼy, “Gasonʼw-lan ka vini byen.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","I mandé yo, “Ki lè ti gason-an vini byen?” Yo diʼy, “I té bò yonnè yè apwémidi lè lafyèv-la tonbé.” ");
INSERT INTO acfNT_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Lè sala papa-a chonjé sété bò menm lè sala Jézi té diʼy, “Gasonʼw-lan kay vini byen.” Kon sa li èk tout fanmiʼy vini kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Sa sété dézyenm miwak-la Jézi fè an Galili apwé i té sòti Joudiya. ");
INSERT INTO acfNT_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Apwé sa, Jézi mouté Jérouzalèm pou sélébwé an fèt wilizyon sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Bò bayè-a yo ka kwiyé Bayè Mouton-an té ni an twou dlo yo ka kwiyé Bèfsafa an langaj sé Jwif-la. La té ni senk plas ki kouvè. ");
INSERT INTO acfNT_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","La té ni an pil moun malad ki té kouché la — moun ki té avèg, moun ki tè enfim, èk moun ki pa té sa maché. Yo tout té la té ka èspéyé pou lè dlo-a soukwé, ");
INSERT INTO acfNT_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","paski tanzantan an nanj Bondyé té ka désann andidan twou dlo-a èk i té ka fè dlo-a soukwé. Pwèmyé moun-an ki antwé andidan twou dlo sala apwé nanj-lan té fè dlo-a soukwé-a té kay djéwi. Népòt malad-la i ni-an ka djéwi. ");
INSERT INTO acfNT_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","La té ni an nonm ki té malad dépi twant ywit (38) lanné. ");
INSERT INTO acfNT_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jézi wè nonm-lan kouché la, èk i té sav nonm-lan té ja la pou an chay tan. Kon sa i mandé nonm-lan, “Ou vlé jwenn djéwizonʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Nonm malad-la di, “Misyé, mwen pa ni pyèsonn isi-a pou mété mwen an dlo-a lè nanj-lan fèʼy soukwé. Kon mwen ka alé pou antwé an dlo-a, an lòt moun ka antwé avan mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Jézi diʼy, “Doubout, pwan matlaʼw èk maché.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Menm lè-a nonm-lan djéwi. I anmasé matlaʼy èk i koumansé maché. Jou sala sété jou sabaf-la, ");
INSERT INTO acfNT_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","kon sa sé ofisyé Jwif-la di nonm-lan ki té djéwi-a, “Jòdi-a sé jou sabaf-la èk i kont lwa nou pou pòté matlaʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Nonm-lan wéponn, i di yo, “Nonm-lan ki djéwi mwen-an ki di mwen pwan matla mwen èk maché.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Yo diʼy, “Sa ki nonm-lan ki diʼw fè bagay sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mé nonm-lan ki té djéwi-a pa té konnèt ki moun i té yé, paski la té ni an pil moun an plas sala, èk Jézi annèk pasé anpami sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Apwé sa, Jézi jwenn menm nonm-lan an Kay Bondyé-a. Jézi diʼy, “Gadé, atjwèlman ou byen. Mé pa fè péché ankò pou an lòt pli mové bagay pa wivéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Nonm-lan pati èk i di sé ofisyé Jwif-la sété Jézi ki té djéwiʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Kon sa yo koumansé pèsikité Jézi, paski i té djéwi nonm-lan asou jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Jézi wéponn yo, i di, “Papa mwen toujou ka twavay, èk mwen menm ni pou twavay tou.” ");
INSERT INTO acfNT_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Lè Jézi di sé ofisyé Jwif-la sa, yo té pli détèwminé pou té tjwéʼy. Sé pa paski i té kasé lwa sabaf-la tousèl, mé paski i té di sé Bondyé ki Papaʼy. Èk an mannyè sala i té ka fè kòʼy pasé menm kon Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Kon sa Jézi wéponn yo, i di, “Mwen ka di zòt lavéwité-a, Gason-an pa sa fè anyen pa kòʼy menm. Sa i wè Papa-a fè, sé sa i ka fè tou. Sa Papa-a fè sé sa Gason-an ka fè. ");
INSERT INTO acfNT_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Bondyé Papa-a enmen Gason-an èk i ka moutwéʼy tout sa i menm ka fè. I kay moutwéʼy pli gwo bagay pouʼy fè pasé sa, èk zòt kay wèsté bouch gwan ouvè. ");
INSERT INTO acfNT_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Menm kon Papa-a ka lévé moun ki mò èk i ka ba yo lavi ankò, sé menm mannyè-a Gason-an ka bay népòt moun i vlé lavi. ");
INSERT INTO acfNT_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Papa-a pa ka jijé pyès moun. I ja ladjé tout jijman an lanmen Gason-an. ");
INSERT INTO acfNT_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Kon sa tout moun sa onnowé Gason-an menm kon yo ka onnowé Papa-a. Népòt moun ki pa ka onnowé Gason-an pa ka onnowé Papa-a ki voyéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Mwen ka di zòt lavéwité-a, népòt moun ki tann pawòl mwen èk kwè an moun-an ki voyé mwen-an ka ni lavi étonnèl. I pa kay jwenn jijman. I ja chapé anba lanmò déja èk i ja koumansé viv. ");
INSERT INTO acfNT_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“Mwen ka diʼw lavéwité-a, lè-a ka vini èk i ja wivé déja, lè sé moun-an ki mò-a kay tann vwa Gason Bondyé, èk sé moun-an ki tann-an èk obéyi sa i di-a kay viv. ");
INSERT INTO acfNT_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Papa-a ni pouvwa pou bay moun lavi. Menm mannyè-a, i ja bay Gasonʼy pouvwa pou bay moun lavi tou. ");
INSERT INTO acfNT_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Èk i ja bay Gason-an dwa pou jijé, paski sé li ki Gason Lézòm-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Zòt pa bizwen sipwi paski lè-a ka vini lè tout moun ki mò kay tann vwaʼy ");
INSERT INTO acfNT_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","èk yo kay sòti an twou yo. Sa ki ja fè bon kay wésisité èk yo kay ni lavi étonnèl, èk sa ki ja fè mové kay wésisité èk yo kay jwenn kondannasyon. ");
INSERT INTO acfNT_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Mwen pa sa fè anyen pa kò mwen menm. Mwen ka jijé moun menm kon Bondyé di mwen. Kon sa jijman-an mwen ka bay-la dwèt paski mwen pa ka fè sa mwen vlé, mé mwen ka fè sa moun-an ki voyé mwen-an vlé mwen fè. ");
INSERT INTO acfNT_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Si sé mwen menm ki ka di ki moun mwen yé èk si mwen ka palé konsèné kò mwen menm, zòt pa kay kwè sa mwen ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Mé la ni an lòt moun ki ka palé konsèné mwen, èk mwen sav sa i ka di konsèné mwen-an sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Sété koté Jan Batis zòt té voyé sé konmisyonnè zòt-la, èk Jan Batis té ka palé lavéwité-a konsèné mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Sé pa bizwen mwen bizwen moun di ki moun mwen yé, mé mwen ka fè zòt chonjé sé bagay sala Jan Batis té di-a pou zòt sa sové. ");
INSERT INTO acfNT_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Jan Batis sété menm kon an lanp ki ka limen. Zòt té kontan tann li pou an ti tak tan, paski pawòl li té menm kon an klèté. ");
INSERT INTO acfNT_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“Mé sé bagay-la mwen ka fè-a ka moutwé ki moun mwen yé adan an mannyè ki pli enpòtan toujou pasé sa Jan Batis té ka di konsèné mwen-an. Twavay mwen sé pou fè sa Papa mwen ban mwen fè-a. Sa mwen ka fè-a ka palé konsèné mwen épi i ka moutwé sé Bondyé ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Èk Papa-a ki voyé mwen-an ka palé lavéwité-a konsèné mwen. Ou pa janmen wè fidjiʼy ni tann vwaʼy, ");
INSERT INTO acfNT_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","èk zòt pa tjenbé pawòl li an tjè zòt, paski zòt pa kwè moun-an i voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Zòt ka étidyé lévanjil-la, paski zòt kwè zòt kay jwenn lavi étonnèl andidanʼy. Èk menm lévanjil sala ka palé konsèné mwen! ");
INSERT INTO acfNT_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Mé zòt pa menm vlé vini jwenn mwen pou zòt sa viv pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Mwen pa ka chaché pou moun lévé non mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Mé mwen konnèt ki kalité moun zòt yé, èk mwen sav zòt pa ni pyès lanmityé pou Bondyé an tjè zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Sé Papa mwen ki voyé mwen pou wépwézantéʼy, mé zòt pa wisivwè mwen. Mé si an lòt té kay vini pa kòʼy menm, san pyèsonn voyéʼy, zòt té kay wisivwèʼy! ");
INSERT INTO acfNT_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Tjè zòt ka kontan lè zòt ka lévé non yonn a lòt, mé zòt pa ka fè anyen pou Bondyé lévé non zòt. Sé li yonn ki Bondyé. Kon sa ki mannyè zòt ka fè kwè mwen? ");
INSERT INTO acfNT_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Zòt pa bizwen kwè sé mwen ki kay akizé zòt douvan Papa mwen. Menm Moziz-la zòt ja apiyé anlèʼy-la, sé li menm ki kay akizé zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Si zòt té kwè sa Moziz té di-a pou vwé, zòt té kay kwè mwen tou, paski Moziz ékwi konsèné mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Mé si zòt pa kwè sé bagay-la Moziz ékwi konsèné mwen-an, ki mannyè zòt kay fè kwè sé bagay-la mwen ka di-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Apwé sa, Jézi twavèsé lanmè Galili-a, lanmè-a yo ka kwiyé Taybiriyòs-la. ");
INSERT INTO acfNT_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","An gwan latilyé moun té ka swiv li, paski yo té ja wè tout sé miwak-la i té ka fè-a lè i té ka djéwi sé moun malad-la. ");
INSERT INTO acfNT_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Jézi mouté an ti mòn èk i asid la épi sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Tan-an sé Jwif-la ka sélébwé Fèt Délivwans-lan té tou pwé. ");
INSERT INTO acfNT_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Jézi gadé oliwonʼy èk i wè an gwan latilyé moun té ka vini koté i té yé-a. Kon sa i mandé Filip, “Koté nou kay achté asé pen pou nou bay tout sé moun sala manjé?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","I di sa pouʼy té wè sa Filip té kay di, paski i menm té ja sav ki sa i té kay fè. ");
INSERT INTO acfNT_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filip wéponn, i diʼy, “Pou tout moun ki isi-a jwenn an ti tjò pen pou yo manjé, i kay pwan lajan ywit mwa twavay an nonm pou sa achté asé pen.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","An lòt disip yo té ka kwiyé Androu, ki té fwè Simon Pita, di Jézi, ");
INSERT INTO acfNT_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“La ni an tibway ki ni senk ti pen épi dé pwéson. Mé sa pa kay ni asé pou plen bouden tout sé moun sala.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Jézi di yo, “Fè sé moun-an asid.” La té ni an pil zèb an plas sala, kon sa tout sé moun-an asid anlè zèb-la. La té ni bò senk mil (5,000) nonm. ");
INSERT INTO acfNT_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Jézi pwan pen-an, èk i wimèsyé Bondyé, èk i sépawé pen-an bay tout moun ki té la, èk i sépawé pwéson-an menm mannyè-a. Yo tout té jwenn asé pou bouden yo té plen. ");
INSERT INTO acfNT_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Lè bouden tout moun té plen, i di sé disip li-a, “Anmasé sé mòso pen-an ki wèsté-a, pa kitéʼy gaspiyé.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Kon sa yo anmasé tout sé mòso pen-an ki té wèsté-a apwé sé moun-an té fin manjé, èk yo plen douz panyen èk sé mòso-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Lè sé moun-an wè miwak sala Jézi fè-a alò, yo di, “Wi, sa sé Pwòfèt-la Moziz té di ki kay vini an latè-a!” ");
INSERT INTO acfNT_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Jézi sav yo té kay vini èk yo té kay tjenbéʼy pou té sa fòséʼy vini wa yo, kon sa i pati ankò an sé mòn-an pa kòʼy yonn. ");
INSERT INTO acfNT_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Avan sòlèy kouché, sé disip li-a désann bò lanmè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Yo antwé adan an kannòt èk yo twavèsé lanmè-a ka alé an diwèksyon vil Kapènéyòm. Òswè vini pwan, èk Jézi pʼòkò té vini jwenn yo. ");
INSERT INTO acfNT_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Paditan yo anlè lanmè-a, an gwo van koumansé vanté èk i fè lanmè-a vini mové. ");
INSERT INTO acfNT_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Sé disip-la té ja najé saviyon pou bò twa ében kat lyé, kon sa, lè yo wè Jézi ka maché asou dlo-a ka vini bò kannòt-la, pa dé pè yo té pè! ");
INSERT INTO acfNT_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Jézi di yo, “Pa pè, sé mwen ki la!” ");
INSERT INTO acfNT_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yo té vléʼy antwé andidan kannòt-la, mé menm lè-a kannòt-la wivé atè an plas-la koté yo té ka alé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","An li denmen, tout sé moun-an ki té ja wèsté lòt bò lanmè-a lè kannòt-la té pati-a té vin chonjé la té ni an sèl kannòt la. Yo sav Jézi pa té antwé an kannòt-la èk sé disip li-a, mé sé disip-la té alé pa kò yo. ");
INSERT INTO acfNT_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Lézòt kannòt, ki té sòti an vil Taybiriyòs, vin kòsté an menm plas-la koté sé moun-an té manjé pen-an apwé Senyè-a té wimèsyé Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Lè sé moun-an wè ni Jézi ni sé disip li-a pa té la, yo antwé an sé kannòt-la èk yo pati alé Kapènéyòm ay gadé pou li. ");
INSERT INTO acfNT_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Lè sé moun-an vin jwenn Jézi lòt bò lanmè-a, yo diʼy, “Titja, ki lè ou fè wivé isi-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Jézi di yo, “Mwen ka di zòt lavéwité-a, zòt ka chaché mwen paski zòt manjé pen-an èk bouden zòt té plen, mé sé pa paski zòt konpwann sé miwak-la mwen ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Sé pa pou zòt twavay pou manjé-a ki ka gaté-a, mé twavay pito pou manjé-a ki ka fè moun viv pou tout tan-an. Sé menm manjé sala mwen Gason Lézòm-lan kay bay zòt, paski sé pou wézon sala Bondyé Papa-a té voyé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Kon sa yo mandéʼy, “Ki sa pou nou fè si nou vlé fè sé bagay-la Bondyé vlé-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Jézi di yo, “Sa Bondyé vlé zòt fè sé kwè an moun-an i voyé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Yo diʼy, “Ki miwak ou kay fè pou nou wè èk pou nou sa kwèʼw? Ki sa ou kay fè? ");
INSERT INTO acfNT_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Gwan gwanpapa lontan nou manjé manna an gwan savann sèk-la, menm kon lévanjil-la di. I di, ‘I ba yo pen-an ki té sòti an syèl-la pou yo manjé.’ ” ");
INSERT INTO acfNT_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Jézi di, “Mwen ka di zòt lavéwité-a, sa Moziz té bay zòt-la sé pa té pen-an ki sòti an syèl-la. Sé atjwèlman Papa mwen bay zòt bon pen-an ki sòti an syèl-la. ");
INSERT INTO acfNT_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Paski pen-an Bondyé ka bay-la, sé li ki moun-an ki désann sòti an syèl-la, èk sé li ki ka bay lézòm lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Yo diʼy, “Misyé, ban nou pen sala toulé jou.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Jézi di, “Sé mwen ki pen lavi. Moun-an ki vini jwenn mwen-an pa kay janmen fen, èk moun-an ki kwè an mwen-an pa kay janmen swèf. ");
INSERT INTO acfNT_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Mé mwen ja di zòt, zòt ja wè mwen mé zòt pa ka kwè toujou. ");
INSERT INTO acfNT_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Tout moun Papa-a ja ban mwen kay vin jwenn mwen, èk mwen pa kay janmen kouwi dèyè pyèsonn ki vin jwenn mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Paski mwen désann sòti an syèl, pa pou mwen fè sa mwen vlé, mé pou mwen fè sa Bondyé ki voyé mwen-an vlé mwen fè. ");
INSERT INTO acfNT_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Moun-an ki voyé mwen-an pa kay vlé mwen pèd pyès an sé moun-an i ja ban mwen-an, mé pou mwen sa wésisité yo asou dènyé jou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Papa mwen vlé tout moun ki wè Gason-an èk kwè an li pou ni lavi étonnèl. Èk mwen kay wésisité yo asou dènyé jou-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Sé Jwif-la koumansé bougonnen kont Jézi bay yonn a lòt, paski i té di sé li ki pen-an ki désann sòti an syèl-la. ");
INSERT INTO acfNT_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Yo di, “Nonm sala sé pa gason Jozèf, on? Nou konnèt ni manmanʼy ni papaʼy. Kon sa ki mannyè i ka fè di i désann sòti an syèl?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Jézi wéponn, i di, “Las bougonnen anpami kò zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Pyèsonn pa sa vini jwenn mwen si Papa-a ki voyé mwen-an pa mennenʼy ban mwen, èk mwen kay wésisitéʼy asou dènyé jou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mi sa yonn an sé pwòfèt-la ékwi, i di, ‘Sé Bondyé ki kay enstwi tout moun.’ Népòt moun ki tann Papa-a èk ki aksèpté sa i di-a kay vini jwenn mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Sa pa vlé di pyèsonn ja wè Papa-a. Sèl moun ki ja wè Papa-a sé moun-an ki désann sòti koté Bondyé yé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Mwen ka di zòt lavéwité-a, moun-an ki kwè an mwen-an ni lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Sé mwen ki pen lavi-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Gwan gwanpapa lontan zòt té ka manjé manna an gwan savann sèk-la, mé magwé sa, yo vini vyé èk yo mò. ");
INSERT INTO acfNT_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Mé népòt moun ki manjé kalité pen-an ki désann sòti an syèl-la pa kay janmen mò. ");
INSERT INTO acfNT_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Sé mwen ki pen lavi-a, ki désann sòti an syèl-la. Si pyèsonn manjé pen sala, i kay viv pou tout tan. Pen sala mwen kay ba li manjé-a sé lachè mwen. Mwen ka bay lachè mwen pou sé jan latè-a sa jwenn lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Sa Jézi di-a lévé an gwan chikann anpami sé Jwif-la. Yo di, “Ki mannyè nonm sala sa fè ban nou lachèʼy pou nou manjé?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Jézi di yo, “Mwen ka di zòt lavéwité-a, si zòt pa manjé lachè Gason Lézòm-lan èk bwè sanʼy, zòt pa kay ni lavi andidan kò zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Népòt moun ki manjé lachè mwen èk bwè san mwen ni lavi étonnèl, èk mwen kay wésisitéʼy asou dènyé jou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Paski lachè mwen sé bon manjé-a, èk san mwen sé bon bwè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Népòt moun ki manjé lachè mwen èk bwè san mwen ka manché èk mwen, èk mwen ka manché épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Papa-a ki ni lavi-a voyé mwen, èk paski i ni lavi, mwen menm ni lavi tou. Menm mannyè-a, népòt moun ki manjé mwen, mwen kay ba li lavi. ");
INSERT INTO acfNT_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Mi pen-an ki désann sòti an syèl-la. I pa menm kon pen-an gwan gwanpapa lontan zòt té manjé-a mé ki pa té anpéché yo mò-a. Moun-an ki manjé pen sala kay viv pou tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jézi di sé bagay sala lè i té ka enstwi an légliz sé Jwif-la an Kapènéyòm. ");
INSERT INTO acfNT_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Lè an pil an sé moun-an ki té ka swiv li-a tann sa, yo di, “Sé pawòl sala twò wèd. Kilès ki kay sa aksèpté sa?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Pyèsonn pa té di Jézi anyen, mé i té sav yo té ka bougonnen kont sa i di-a. Kon sa i di yo, “Ès sa mwen di-a ka ofwansé zòt? ");
INSERT INTO acfNT_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Bon, ki sa zòt kay di si zòt wè Gason Lézòm-lan déviwé an plas-la koté i sòti-a? ");
INSERT INTO acfNT_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Sé Lèspwi Bondyé ki ka bay moun lavi. Nonm pa sa fè sa. Sé pawòl-la mwen ja palé bay zòt-la ki ka fè zòt wisivwè Lèspwi Bondyé, Lèspwi-a ki ka bay zòt lavi-a. ");
INSERT INTO acfNT_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Mé adan zòt pa menm vlé kwè.” Jézi té sav dépi an koumansman-an ki konpanni ki pa té ka kwè épi ki moun ki té kay twayiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Èk i di, “Sé pou wézon sala mwen di zòt pyèsonn pa sa vini jwenn mwen si sé pa Bondyé Papa-a ki ba li kouway-la pouʼy fè sa.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Pou lapéti sa i di-a, an pil an sé moun-an ki té ka swiv li-a tounen do yo asouʼy èk yo pa swiv li ankò. ");
INSERT INTO acfNT_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Kon sa i di douz disip li-a, “Zòt menm pa vlé kité mwen tou?” ");
INSERT INTO acfNT_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simon Pita wéponn, i di, “Senyè, kilès nou kay alé jwenn? Sé ou ki ni pawòl-la ki ka bay moun lavi étonnèl-la. ");
INSERT INTO acfNT_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Apwézan nou kwè, èk nou sav sé ou ki moun-an Bondyé voyé-a, moun-an ki ka viv ba li yonn-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Jézi wéponn, i di, “Sé pa mwen ki chwazi zòt toulé douz, on? Mé yonn an zòt sé an djab.” ");
INSERT INTO acfNT_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","I té ka palé konsèné Jida, gason Simon Iskariyòt-la. Paski magwé Jida sété yonn anpami sé douz disip-la, sé li ki té kay twayiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Apwé sa, Jézi té ka alé toupatou an Galili, mé i pa té vlé alé an Joudiya, paski sé chèf Jwif-la té ka chaché mannyè pou té tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Sé pa té djè lontan Fèt Ti Kay-la. ");
INSERT INTO acfNT_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Sé fwè Jézi-a di Jézi, “Ki sa ou ka fè isi-a? Alé Joudiya pou sé moun-an ki ka swiv ou-a wè sé miwak-la ou ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Pyèsonn pa ka séwé sa i ka fè si i vlé moun konnèt li. Ou ka fè sé bagay sala, kon sa fè yo pou tout moun wè èk pou yo konnèt ou!” ");
INSERT INTO acfNT_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Pa menm sé fwèʼy-la ki té kwè an li.) ");
INSERT INTO acfNT_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jézi di yo, “Tan mwen pʼòkò wivé. Népòt lè bon pou zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Sé jan latè-a pa hayi zòt, mé yo hayi mwen, paski mwen ka di yo sé bagay-la yo ka fè-a sé movèzté. ");
INSERT INTO acfNT_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Zòt sa alé an fèt-la. Mwen menm pa ka alé an fèt sala, paski lè mwen pʼòkò wivé.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","I di yo sa, èk i wèsté Galili. ");
INSERT INTO acfNT_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Apwé sé fwèʼy-la vin alé an fèt-la, Jézi vin alé tou, mé i pa té kité pyèsonn konnèt li, i alé an sigwé. ");
INSERT INTO acfNT_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Sé chèf Jwif-la té ka gadé pou li an fèt-la. Yo di, “Koté nonm sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Tout moun té ka palé an zòwèy konsèné Jézi. Adan moun di, “I sé an bon nonm.” Lézòt di, “An, an!” An lòt konpanni di, “Kwennen i ka kwennen sé moun-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Mé pyèsonn pa té ka palé pou moun tann, paski yo té pè sé chèf Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Lè i té wèsté bò kat jou pou fèt-la fini, Jézi antwé an Kay Bondyé-a èk i koumansé enstwi. ");
INSERT INTO acfNT_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Sé chèf Jwif-la té sipwi an chay, yo di, “Ki mannyè nonm sala fè konnèt otan alè i pa janmen alé an lékòl nou?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Jézi wéponn, i di, “Sé bagay-la mwen ka enstwi-a sé pa pawòl mwen menm, mé sé Bondyé ki ban mwen sé pawòl sala pou mwen di paski sé li ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Népòt moun ki dakò pou obéyi Bondyé kay sav si sé mwen menm ki ka palé konsèné kò mwen ében si sé Bondyé ki ban mwen sé pawòl sala pou mwen di. ");
INSERT INTO acfNT_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","An moun ki ka palé konsèné kòʼy ka chaché mannyè pouʼy lévé nonʼy menm. Mé moun-an ki vlé lévé non Bondyé ki voyéʼy-la, moun sala ka palé lavéwité-a, èk la pa ni pyès wiz an li. ");
INSERT INTO acfNT_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Kilès ki té bay zòt lwa-a? Sé pa té Moziz, on? Mé la pa ni pyès an zòt ki ka obéyi lwa sala. Pouki zòt ka chaché pou tjwé mwen?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sé moun-an di, “I sanm ou ni an vyé lèspwi andidanʼw! Ki moun ki vlé tjwéʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Jézi wéponn, i di, “Mwen fè yon sèl miwak èk zòt té sipwi. ");
INSERT INTO acfNT_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Zòt ni labitid sikonsayz gason zòt asou jou sabaf-la menm kon Moziz té di zòt (magwé sé pa té menm Moziz ki té di zòt fè sa, sété gwan gwanpapa lontan zòt ki té koumansé fèʼy). ");
INSERT INTO acfNT_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Si zòt ka sikonsayz an ti gason asou jou sabaf-la pou zòt pa kasé lwa Moziz-la, pouki zòt faché èk mwen paski mwen djéwi an nonm konplètman asou jou sabaf-la? ");
INSERT INTO acfNT_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Las jijé asou mannyè zòt ka wè bagay, mé jijé adan an mannyè ki dwèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Sé jan Jérouzalèm-lan di, “Sé pa nonm sala sé chèf Jwif-la ka chaché pou tjwé-a? ");
INSERT INTO acfNT_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mi, i la ka palé douvan tout moun, èk yo pa ka menm di anyen kont li! I sanm yo sav pou vwé sé li ki Mèsaya-a. ");
INSERT INTO acfNT_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mé lè Mèsaya-a kay vini, pyèsonn pa kay sav koté i sòti, èk nou tout sav koté nonm sala sòti.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Paditan Jézi té ka enstwi an Kay Bondyé-a, i palé fò, i di “Ou kwè zòt konnèt mwen èk zòt sav koté mwen sòti pou vwé? Sé pa mwen ki vini pa kò mwen menm, mé zòt sa apiyé asou moun-an ki voyé mwen-an pou vwé. Zòt pa konnèt li ");
INSERT INTO acfNT_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","mé mwen konnèt li, paski sé li ki voyé mwen èk mwen sòti koté i yé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Sé lè sala yo té pli anvi awétéʼy, mé pyèsonn pa mété lanmen anlèʼy, paski tanʼy pʼòkò té wivé. ");
INSERT INTO acfNT_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Mé an pil sé moun-an kwè an li èk yo di, “Ou kwè lè Mèsaya-a vini i kay fè pli miwak pasé nonm sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Sé Fawizyen-an vin konnèt sa sé moun-an té ka di an zòwèy konsèné Jézi-a, kon sa yo èk sé chèf pwèt-la voyé déotwa gad pou awété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Jézi di, “Mwen kay wèsté épi zòt pou ti tak pli lontan ankò, èk apwé sa mwen kay alé jwenn moun-an ki voyé mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Zòt kay chaché mwen, mé zòt pa kay jwenn mwen, paski zòt pa sa alé koté mwen kay yé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Sé chèf Jwif-la palé anpami kò yo menm, yo di, “Koté nonm sala kay alé pou nou pa jwenn li? Ou kwè i kay alé wèsté anpami sé moun nou-an ki simen an sé lézòt péyi-a, èk enstwi sé moun-an ki pa Jwif-la? ");
INSERT INTO acfNT_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ki mannyè i ka di nou kay chachéʼy èk nou pa kay jwenn li paski nou pa sa alé koté i kay yé-a? Ki sa i ka di la-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Asou dènyé jou fèt-la, jou-a ki té pli enpòtan-an, Jézi doubout èk i palé fò, i di, “Kité népòt moun ki swèf vini jwenn mwen èk bwè. ");
INSERT INTO acfNT_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Kon lévanjil-la di, ‘Népòt moun ki kwè an mwen, an sous dlo ki ka bay lavi kay sòti andidanʼy.’ ” ");
INSERT INTO acfNT_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Lè Jézi di sa, i té ka palé konsèné Lèspwi Bondyé sé moun-an ki kwè an li-a té kay wisivwè. An tan sala Lèspwi Bondyé pʼòkò té vini asou pyèsonn, paski Jézi pʼòkò té mouté an syèl. ");
INSERT INTO acfNT_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Adan sé moun-an ki té la-a tann sa èk yo di, “Nonm sala sé Pwòfèt-la pou vwé!” ");
INSERT INTO acfNT_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","I ni lòt ki di, “Sé li ki Mèsaya-a!” Mé an lòt konpanni di, “Mèsaya-a pa kay sòti Galili! ");
INSERT INTO acfNT_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Lévanjil-la di Mèsaya-a kay désandan Wa David èk sé an Bèfléyenm i kay fèt, an vil-la koté David té sòti-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Kon sa la té ni divizyon anpami yo pou lapéti Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Déotwa té vlé awétéʼy, mé yo pyès pa mété lanmen anlèʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Lè sé gad-la déviwé, sé chèf pwèt-la èk sé Fawizyen-an mandé yo, “Ki mannyè zòt pa mennenʼy ban nou?” ");
INSERT INTO acfNT_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Sé gad-la di, “Pyès nonm pa janmen palé kon nonm sala!” ");
INSERT INTO acfNT_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Sé Fawizyen-an di, “Ou vlé di mwen zòt kitéʼy kwennen zòt tou? ");
INSERT INTO acfNT_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ès zòt ja janmen wè pyès an sé chèf Jwif-la ében pyès an nou sé Fawizyen-an kwè an nonm sala? ");
INSERT INTO acfNT_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Sé moun kouyon sala pa konnèt lwa Moziz-la, kon sa yo anba pinisyon Bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yonn an sé Fawizyen-an ki té la-a sété Nikodimòs, nonm-lan ki té ja alé koté Jézi an tan ki pasé-a. I di sé lézòt-la, ");
INSERT INTO acfNT_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Lwa nou pa ka kité nou kondanné an moun si nou pa tann li èk gadé ki mové bagay i ja fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","53","Yo diʼy, “É, é, i sanm ou sòti Galili tou. Étidyé lévanjil-la épi ou kay wè pou kòʼw pyès pwòfèt pa ka janmen sòti Galili.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Tout moun alé lakay yo, mé Jézi menm mouté Mòn Òliv. ");
INSERT INTO acfNT_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","An li denmen byen bonnè, i déviwé an Kay Bondyé-a. Tout sé moun-an asanblé oliwonʼy, èk i asid èk i koumansé enstwi yo. ");
INSERT INTO acfNT_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","4","Sé titja lwa sé Jwif-la èk sé Fawizyen-an mennen an madanm ba li, yo té tjenbéʼy ka fè adiltè. Yo météʼy doubout douvan tout moun èk yo di Jézi, “Titja, nou byen bouché madanm sala ka fè adiltè. ");
INSERT INTO acfNT_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","An lwa nou, Moziz té konmandé nou pou bay kalité madanm kon sa wòch jis tan nou tjwéʼy, mé ki sa ou menm ka di?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Yo diʼy sa pou yo té wè si yo té kay fè Jézi di an vyé pawòl kont lwa-a pou yo té sa akizéʼy. Mé i bésé èk i ékwi atè-a èk dwèt li. ");
INSERT INTO acfNT_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Kon yo doubout la ka mandéʼy kwèsyon, i lévé èk i di yo, “Népòt an zòt ki pa janmen fè péché sa voyé pwèmyé wòch-la.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Èk i viwé bésé épi i kontiné ka ékwi atè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Lè yo tann Jézi di sa, yo tout kité èk yo alé yonn pa yonn, sé pli gwan-an ki alé avan. Jézi té wèsté la pa kòʼy, èk madanm-lan té doubout douvanʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I lévé doubout èk i di madanm-lan, “Koté sé moun-an ki té ka akizéʼw-la? Yo pyès pa wèsté la pou kondannéʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Madanm-lan di, “Yo pyès pa wèsté, misyé.” Kon sa Jézi diʼy, “Mwen menm pa ka kondannéʼw nonplis. Alé, mé pa fè péché ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Jézi palé bay sé Fawizyen-an ankò, i di, “Sé mwen ki klèté-a ki ka kléwé tout moun an latè-a. Népòt moun ki swiv mwen kay ni klèté-a ki ka bay lavi-a èk i pa kay janmen maché an nwèsè.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Sé Fawizyen-an diʼy, “Bon, mi atjwèlman ou ka palé konsèné kòʼw menm. Sa ou ka di-a pa vo anyen.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Jézi di, “Menm si mwen ka palé konsèné kò mwen menm, sa mwen ka di-a sé lavéwité, paski mwen sav koté mwen sòti èk koté mwen ka alé. Zòt pa sav koté mwen sòti ni koté mwen ka alé. ");
INSERT INTO acfNT_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Zòt ka jijé mannyè jan latè-a ka jijé, mé mwen menm pa ka jijé pyèsonn. ");
INSERT INTO acfNT_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Mé si mwen ni pou jijé, jijman mwen kay dwèt paski sé pa mwen yonn ki ka bay jijman. Papa-a ki voyé mwen-an la épi mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Lwa zòt-la di si dé témwen palé èk pawòl yo ka tèl, sa yo di-a sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Mwen menm ka palé konsèné kò mwen, èk Papa mwen ki voyé mwen ka palé konsèné mwen tou.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Yo diʼy, “Koté papaʼw?” Jézi di, “Zòt pa konnèt ni mwen ni Papa mwen. Si zòt té konnèt mwen, zòt té kay konnèt Papa mwen tou.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Jézi di yo tout sé bagay sala paditan i té ka enstwi yo an Kay Bondyé-a, koté ki té ni sé bwèt-la yo ka anmasé latjèt-la. Pyèsonn pa awétéʼy paski lèʼy pʼòkò té wivé. ");
INSERT INTO acfNT_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Jézi di yo ankò, “Mwen kay alé èk zòt kay chaché mwen, mé zòt kay mò an péché zòt. Zòt pa sa alé koté mwen ka alé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Kon sa sé chèf Jwif-la di, “I di kon sa nou pa sa alé koté i ka alé-a. Ou kwè sé tjwé i kay tjwé kòʼy?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Jézi wéponn, i di, “Zòt sé jan latè-a, mé mwen menm sòti an syèl. Zòt sòti an latè sala, mé mwen menm pa sòti an latè sala. ");
INSERT INTO acfNT_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Sé pou sa mwen di zòt, zòt kay mò an péché zòt. Wi, zòt kay mò an péché zòt si zòt pa kwè sé mwen ki moun-an mwen yé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yo diʼy, “Ki moun ou yé?” Jézi di yo, “Mwen di zòt dépi an koumansman-an. ");
INSERT INTO acfNT_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Mwen ni an pil pou mwen di konsèné zòt, an pil bagay pou mwen kondanné zòt pou. Mé moun-an ki voyé mwen-an, sé lavéwité tousèl i ka palé, èk mwen ka di sé jan latè-a tout sa mwen tann i di.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Sé moun-an pa té konpwann sété konsèné Papaʼy i té ka palé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Kon sa i di yo, “Lè zòt kay lévé Gason Lézòm-lan asou an kwa, sé lè sala zòt kay sav sé mwen ki moun-an mwen yé-a, èk zòt kay sav mwen pa ka fè anyen pa kò mwen menm. Mwen ka di sa Papa mwen vlé mwen di tousèl. ");
INSERT INTO acfNT_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Moun-an ki voyé mwen-an la épi mwen, èk i pa janmen kité mwen paski mwen toujou ka fè sa ki ka plèʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","An pil an sé moun-an ki té tann Jézi di sé bagay sala té kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Kon sa Jézi di sé Jwif-la ki kwè an li-a, “Si ou kontiné fè sa mwen di-a, sé lè sala ou sé disip mwen pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ou kay konnèt lavéwité-a, èk lavéwité sala kay fèʼw lib.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Yo di, “Nou sé désandan Abrahanm, èk nou pa janmen èslav anba pyèsonn. Ki sa ou vlé di lè ou di nou kay vini lib?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Jézi di yo, “Mwen ka di zòt lavéwité-a, tout moun ki ka péché èslav anba péché. ");
INSERT INTO acfNT_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Pyèsonn ki sé an èslav pa ka wèsté èk an mèt pou tout tan, mé gason mèt kay-la ka wèsté la pou tout tan. ");
INSERT INTO acfNT_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Si Gason-an fèʼw lib, sé lè sala ou kay lib pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Mwen sav zòt sé désandan Abrahanm, mé zòt ka chaché pou tjwé mwen toujou, paski zòt pa vlé obéyi sa mwen ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Mwen ka palé asou sa Papa mwen ja moutwé mwen, mé zòt menm ka fè sa papa zòt di zòt fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Yo diʼy, “Abrahanm ki papa nou.” Jézi di yo, “Si zòt sété ich Abrahanm vwé, zòt té kay fè menm sé bagay-la i fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Sèl sa mwen ja fè sété di zòt lavéwité-a ki sòti an bouch Bondyé-a, mé zòt ka chaché mannyè pou tjwé mwen pou sa. Abrahanm pa té fè anyen kon sa. ");
INSERT INTO acfNT_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Zòt ka fè sa papa zòt fè.” Yo di, “Nou sé pa bata. Sèl Papa nou ni sé Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Jézi di yo, “Si Bondyé sété Papa zòt pou vwé, zòt té kay enmen mwen paski sé koté Bondyé mwen sòti pou vini isi-a. Mé mwen pa vini pa kò mwen, sé li ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Pouki zòt pa ka konpwann sé bagay-la mwen ka di-a? Sé paski zòt wifizé pou kouté pawòl mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Zòt sé ich papa zòt Denmou, épi zòt vlé fè sa i vlé zòt fè. Dépi an koumansman latè-a i té ka tjwé moun épi i pa té janmen enmen lavéwité-a, paski la pa ni pyès lavéwité an li. Lè i ka manti, sé sa ki an tjèʼy i ka fè, paski i sé on mantè èk sé li ki papa tout mantè. ");
INSERT INTO acfNT_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Mé mwen menm ka di lavéwité-a, èk sé pou wézon sala zòt pa ka kwè mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Kilès an zòt ki sa di mwen ni péché? Si mwen ka di lavéwité-a, pouki zòt pa ka kwè mwen? ");
INSERT INTO acfNT_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Moun-an ki sòti koté Bondyé-a ka kouté pawòl Bondyé, mé zòt menm pa sòti koté Bondyé, èk sé pou sa zòt pa ka kouté.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Sé Jwif-la mandé Jézi, “Ès nou pa té byen fèt di ou sé jan Sanmariya èk ou ni an vyé lèspwi andidanʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Jézi di, “Mwen pa ni pyès vyé lèspwi. Mwen ka lévé non Papa mwen, mé zòt menm pa ka lévé non mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Mwen pa ka chaché pou moun lévé non mwen, mé la ni yon moun ki ka chaché pou moun lévé non mwen èk sé li ki kay jijé. ");
INSERT INTO acfNT_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Mwen ka di zòt lavéwité-a, népòt moun ki obéyi sa mwen ka di-a pa kay janmen mò.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","“Bon, apwézan nou asiwé ou ni an vyé lèspwi! Abrahanm mò, sé pwòfèt-la mò, mé mi ou ka di, si an moun obéyi sa ou ka di-a, i pa kay janmen mò. ");
INSERT INTO acfNT_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Si Abrahanm ki gwan gwanpapa lontan nou mò, ki sa ou vlé di, ou pli enpòtan pasé Abrahanm? Sé pwòfèt-la mò tou. Ki moun ou kwè ou yé?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Jézi wéponn, i di, “Si mwen té ni pou lévé non mwen menm, sa pa té kay vo mwen anyen. Mé moun-an ki ka lévé non mwen-an sé Papa mwen menm, menm moun-an zòt di ki Bondyé zòt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Zòt pa janmen konnèt li, mé mwen menm konnèt li. Si mwen té di mwen pa konnèt li, mwen té kay on mantè menm kon zòt. Mé mwen konnèt li, èk mwen ka obéyi pawòl li. ");
INSERT INTO acfNT_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Abrahanm gwan gwanpapa lontan zòt té kontan an pil pouʼy té wè tan-an mwen té kay vini-an. I wèʼy èk sa té fè tjèʼy kontan an pil.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sé Jwif-la di, “Ou pa menm senkant (50) lanné, èk ou ja wè Abrahanm?” ");
INSERT INTO acfNT_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Jézi di yo, “Mwen ka di zòt lavéwité-a, avan Abrahanm té fèt, mwen té ja la.” ");
INSERT INTO acfNT_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Lè sala yo anmasé wòch pou té tjwéʼy, mé Jézi séwé kòʼy èk i kité Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Paditan Jézi té ka pasé an koté, i wè an nonm ki té fèt avèg. ");
INSERT INTO acfNT_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Sé disip li-a mandéʼy, “Titja, ki sa ki fè nonm sala fèt avèg, péché i menm ében péché manmanʼy èk papaʼy?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Jézi wéponn, i di yo, “Sé pa péché ni manmanʼy ni papaʼy ni péché i menm ki fèʼy fèt avèg. I fèt avèg pou moun sa wè pouvwa Bondyé twavay an li. ");
INSERT INTO acfNT_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Paditan i lajouné, sé pou nou fè twavay moun-an ki voyé mwen-an, paski òswè ka pwan lè pyès moun pa sa twavay. ");
INSERT INTO acfNT_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Paditan mwen an latè-a, mwen sé klèté pou sé jan latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Apwé Jézi di sa, i kwaché atè-a èk i fè labou èk kwacha-a. I fwoté zyé nonm-lan èk labou-a èk i diʼy, ");
INSERT INTO acfNT_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“Alé èk lavé fidjiʼw an twou dlo Silowanm-lan.” (Non sala vlé di Voyé). Kon sa nonm-lan pati èk i lavé fidjiʼy, èk i déviwé ka wè klè. ");
INSERT INTO acfNT_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Sé pwochenʼy-lan èk sé moun-an ki té ja wèʼy ka mandé lachawité-a di, “Sa pa nonm-lan ki té ka asid ka mandé lachawité-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Adan di, “Wi, sé li menm.” Mé lézòt di, “Non, sa pa li, mé pa dé sanm i ka sanm li.” Lè nonm-lan ki té avèg-la tann sa, i di yo, “Sé mwen menm ki la-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Yo diʼy, “Ki mannyè ou fè ka wè atjwèlman?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","I di yo, “Nonm-lan yo ka kwiyé Jézi-a fè tak labou èk i fwotéʼy anlè zyé mwen, épi i di mwen ay lavé fidji mwen an twou dlo Silowanm-lan. Kon sa mwen alé, èk menm kon mwen lavé fidji mwen, mwen vin ka wè klè.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Yo mandéʼy, “Kotéʼy?” I di, “Mwen pa sav.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Yo mennen nonm-lan ki té avèg-la bay sé Fawizyen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Jou-a Jézi té fè labou-a èk i té djéwi nonm avèg-la sété jou sabaf-la. ");
INSERT INTO acfNT_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Sé Fawizyen-an kwèsyonnen nonm-lan tou, yo diʼy, “Ki mannyè ou fè vin ka wè klè?” I di yo, “I mété tak labou anlè zyé mwen, mwen lavé fidji mwen, épi apwézan mwen ka wè.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Adan sé Fawizyen-an di, “Nonm sala ki fè bagay sala pa sòti an Bondyé, paski i pa ka obéyi lwa sabaf-la.” Mé lézòt di, “Ki mannyè an nonm ki sé an péchè sa fè kalité miwak kon sa?” Èk la té ni an gwan chikann anpami yo. ");
INSERT INTO acfNT_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Kon sa sé Fawizyen-an mandé nonm-lan ankò, “Ou di i fèʼw wè klè. Bon, ki sa ou ni pou di konsèné nonm sala?” Nonm-lan di, “I sé an pwòfèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Sé chèf Jwif-la menm pa té vlé kwè i té avèg avan, kon sa yo kwiyé manmanʼy èk papaʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Yo di yo, “Sa sé gason zòt? Zòt di i té fèt avèg. Bon, ki mannyè i vin ka wè atjwèlman?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Manmanʼy èk papaʼy wéponn, yo di, “Nou sav i sé gason nou, èk nou sav i té fèt avèg, ");
INSERT INTO acfNT_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","mé nou pa sav ki mannyè i fè ka wè klè apwézan, ni nou pa sav ki moun ki fèʼy wè klè. Ou sa mandéʼy, i asé gwan, i sa wéponn pou kòʼy!” ");
INSERT INTO acfNT_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Manmanʼy èk papaʼy di sa paski yo té pè sé chèf Jwif-la. Sé chèf Jwif-la té ja dakò ki népòt moun ki di i kwè Jézi sé Mèsaya-a, yo ka météʼy dèwò an légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Sé pou sa manmanʼy èk papaʼy di, “I gwan asé, mandéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Kon sa yo kwiyé nonm-lan ki té fèt avèg-la pou an dézyenm fwa èk yo diʼy, “Ou ni pouʼw pwonmèt douvan Bondyé ou kay di lavéwité-a! Nou sav nonm sala ki djéwiʼw-la sé an péchè.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Nonm-lan di, “Mwen pa sav si i sé an péchè ében si i pa an péchè. Yon sèl bagay mwen konnèt. Mwen té avèg èk atjwèlman mwen ka wè klè.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Yo diʼy, “Ki sa i fèʼw pouʼw wè klè? Ki mannyè i fè djéwi zyéʼw?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Nonm-lan di, “Mwen ja di zòt mé zòt pa té ka kouté. Pouki ou vlé mwen diʼw ankò? Ou vlé vini disip li tou?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Yo ensilté nonm-lan, yo diʼy, “Sé ou ki disip nonm sala, mé nou menm sé disip Moziz. ");
INSERT INTO acfNT_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nou sav Bondyé palé bay Moziz mé nonm sala, nou pa menm sav koté i sòti!” ");
INSERT INTO acfNT_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Nonm-lan di, “Mwen pa konpwann sa pyès! Ou pa konnèt koté i sòti, mé i djéwi mwen, i fè mwen wè klè! ");
INSERT INTO acfNT_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nou sav Bondyé pa ka wéponn lapwiyè moun ki ka fè péché, mé i ka wéponn lapwiyè moun ki ka adowéʼy èk ki ka obéyiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Dépi an koumansman latè-a pyèsonn pa janmen tann an moun djéwi an moun ki fèt avèg. ");
INSERT INTO acfNT_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Si nonm sala pa sòti koté Bondyé, i pa sa janmen fè an bagay kon sa.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Yo wéponn li, yo diʼy, “Ou fèt èk ou lévé an péché, èk ou vlé enstwi nou?” Yo kouwi dèyèʼy an légliz-la. ");
INSERT INTO acfNT_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jézi vin tann sa ki té fèt-la. Kon sa lè i jwenn nonm-lan, i diʼy, “Ès ou kwè an Gason Lézòm-lan?” ");
INSERT INTO acfNT_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Nonm-lan diʼy, “Misyé, di mwen ki moun i yé pou mwen sa kwè an li!” ");
INSERT INTO acfNT_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Jézi diʼy, “Ou ja wèʼy, èk sé li ki la ka palé épiʼw-la.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nonm-lan di, “Senyè, mwen kwè!” Èk i ajounou an pyé Jézi èk i adowéʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Jézi di, “Mwen vini an latè sala pou mennen jijman. Mwen vini pou moun ki avèg wè klè èk mwen vini pou fè moun ki ka wè klè vini avèg.” ");
INSERT INTO acfNT_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Adan sé Fawizyen-an ki té la-a tann lè i di sa. Yo diʼy, “Pa di nou ou kwè nou menm avèg tou!” ");
INSERT INTO acfNT_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Jézi di yo, “Si zòt té avèg, zòt pa té kay koupab, mé paski zòt di zòt ka wè, zòt koupab toujou.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jézi di, “Mwen ka di zòt lavéwité-a, nonm-lan ki pa pasé an lapòt-la pou antwé an pak mouton-an, mé i janbé èk i antwé an lòt mannyè, i sé an vòlè èk i ka chaché mannyè pou vòlè sé mouton-an. ");
INSERT INTO acfNT_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Nonm-lan ki antwé an lapòt-la, sé li ki bèwjé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Nonm-lan ki ka véyé lapòt pak mouton-an ka ouvè ba li. Sé mouton-an ka tann vwa gadyenn-an lè i ka kwiyé non sé moutonʼy-lan, èk i ka mennen yo sòti dèwò. ");
INSERT INTO acfNT_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Lè i fini mennen yo dèwò, i ka pwan douvan, èk sé mouton-an ka swiv li, paski yo konnèt vwaʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Yo pa kay swiv an lòt moun. Okontwè, yo kay kouwi lè yo tann moun sala, paski yo pa konnèt vwaʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jézi di yo pawabòl sala, mé yo pa té konpwann sa i té vlé di yo-a. ");
INSERT INTO acfNT_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Kon sa Jézi di yo ankò, “Mwen ka di zòt lavéwité-a, sé mwen ki lapòt pak mouton-an. ");
INSERT INTO acfNT_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Tout sé lézòt-la ki vini avan mwen-an sé vòlè. Yo sé moun ki ka chaché mannyè pou vòlè sé mouton-an. Mé sé mouton-an pa té ka kouté yo. ");
INSERT INTO acfNT_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Sé mwen ki lapòt-la. Moun-an ki pasé an mwen pou antwé an pak-la kay sové. I kay antwé, i kay sòti, i kay jwenn manjé pouʼy manjé. ");
INSERT INTO acfNT_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Pou sèl wézon vòlè-a ka vini sé pou tjwé, pou vòlè, èk pou détwi. Mé mwen menm vini pou bay moun lavi — an lavi alabondans. ");
INSERT INTO acfNT_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Sé mwen ki bon bèwjé-a, ki pawé pou mò pou lapéti sé mouton-an. ");
INSERT INTO acfNT_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Nonm-lan yo anplowé pou véyé sé mouton-an sé pa an bèwjé èk sé pa li ki mèt sé mouton-an. Lè i wè an bèt sovay ka vini, i ka kité twipo mouton-an èk i ka kouwi pou chapé kòʼy. Kon sa bèt sovay-la ka pwan adan sé mouton-an èk sé lézòt-la ka simen toupatou. ");
INSERT INTO acfNT_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Nonm-lan yo anplowé pou gadé sé mouton-an kay kouwi alé paski sé anplowé yo anplowéʼy, kon sa i pa mélé èk sé mouton-an. ");
INSERT INTO acfNT_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Sé mwen ki bon bèwjé-a. Papa-a konnèt mwen èk mwen konnèt Papa-a. Sé menm mannyè-a mwen konnèt mouton mwen èk yo konnèt mwen, èk mwen pawé pou mò pou lapéti yo. ");
INSERT INTO acfNT_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Mwen ni lòt mouton ki pa an pak sala. Mwen ni pou mennen yo vini tou. Yo tout kay kouté vwa mwen, èk la kay ni yon sèl twipo èk yon sèl bèwjé. ");
INSERT INTO acfNT_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Papa-a enmen mwen paski mwen pawé pou mò pou mwen sa wésisité ankò. ");
INSERT INTO acfNT_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pyèsonn pa kay tjwé mwen si mwen pa vlé. Sé mwen menm ki ka kité yo tjwé mwen. Mwen ni pouvwa pou kité yo tjwé mwen, èk mwen ni pouvwa pou viwé wésisité ankò. Sé sa Papa mwen konmandé mwen pou fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","La té ni divizyon ankò anpami sé Jwif-la pou lapéti sa Jézi té di-a. ");
INSERT INTO acfNT_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","An pil adan yo té ka di, “I ni an vyé lèspwi andidanʼy, i ka fou! Pouki pouʼw kouté nonm sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mé lézòt té ka di, “An nonm ki ni an vyé lèspwi andidanʼy pa sa palé kon sa! Ki mannyè an vyé lèspwi kay sa fè moun ki avèg wè klè?” ");
INSERT INTO acfNT_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","I té an sézon fwédi-a, menm tan-an sé Jwif-la té ka sélébwé Fèt Dèdikasyon Kay Bondyé-a an Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jézi té la ka maché an balkon-an yo ka kwiyé Balkon Sòlomonn-an ki an Kay Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Sé Jwif-la asanblé tout oliwonʼy èk yo diʼy, “Ki otan tan ou kay kité nou la san nou sav ki sa pou nou kwè? Di nou aklè si sé ou ki Mèsaya-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Jézi di, “Mwen ja di zòt mé zòt pa vlé kwè mwen. Sé miwak-la Papa mwen ban mwen pouvwa pou fè-a ka palé konsèné mwen, ");
INSERT INTO acfNT_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","mé zòt pa vlé kwè paski zòt sé pa mouton mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Mouton mwen ka kouté mwen, mwen konnèt yo, èk yo ka swiv mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Mwen ka bay sé moun-an ki ka swiv mwen-an lavi étonnèl, èk yo pa kay janmen pèd. Pyèsonn pa sa tiwé yo an lanmen mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Sé moun-an Papa mwen ja ban mwen-an pli enpòtan pasé tout lézòt, èk pyèsonn pa sa tiwé yo an lanmen Papa mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Mwen èk Papa mwen sé yonn.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Sé Jwif-la anmasé wòch ankò pou yo té tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Jézi di yo, “Zòt ja wè mwen fè an pil gwan twavay anpami zòt, gwan twavay Papa-a ban mwen pouvwa pou fè. Pou kilès adan yo zòt vlé tjwé mwen?” ");
INSERT INTO acfNT_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Yo diʼy, “Nou pa vlé tjwéʼw pou pyès an sé bon twavay-la ou fè-a, mé paski ou ka ensilté Bondyé. Ou sé sèlman an nonm, mé ou vlé fè kòʼw pasé pou Bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Jézi di, “Mi sa ki ékwi an lwa zòt-la koté Bondyé di, ‘Sé bondyé zòt yé.’ ");
INSERT INTO acfNT_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Nou sav sa lévanjil-la di vwé pou tout tan. Bondyé menm kwiyé sé moun-an bondyé, sé moun-an ki té wisivwè konmisyonʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Sé mwen menm Papa-a chwazi èk i voyé mwen an latè-a. Ki mannyè zòt ka fè di mwen ensilté Bondyé paski mwen di mwen sé Gason Bondyé? ");
INSERT INTO acfNT_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Si mwen pa ka fè sé bagay-la Papa mwen vlé mwen fè-a, ou pa oblijé kwè mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Mé si mwen ka fè sé bagay-la Papa mwen vlé mwen fè-a, zòt sipozé kwè an twavay-la mwen ka fè-a, menm si zòt pa kwè mwen. Lè sala zòt kay sav mwen èk Papa mwen sé yonn.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yon lòt kou ankò yo fè fòs kò yo pou té tjenbé Jézi, mé i chapé kòʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Jézi viwé twavèsé Lawivyè Jouden-an ankò. I alé an menm plas-la koté Jan Batis té batizé moun-an, èk i wèsté la. ");
INSERT INTO acfNT_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","An pil moun vini koté i té yé-a. Sé moun-an di bay yonn a lòt, “Jan Batis pa té fè pyès miwak, mé tout sa i té di konsèné nonm sala té vwé.” ");
INSERT INTO acfNT_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Èk an pil sé moun-an kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","La té ni an nonm yo té ka kwiyé Lazaròs, ki té ka wèsté Bèfanni, ki tonbé malad. Bèfanni sété on ti vil koté Mari èk séséʼy Mafa té ka wèsté. ");
INSERT INTO acfNT_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Sété menm Mari-a ki té vidé losyon-an anlè pyé Jézi èk i té swiyéʼy èk chivéʼy-la. Sété fwèʼy Lazaròs ki té tonbé malad. ");
INSERT INTO acfNT_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Sé sésé-a voyé an konmisyon bay Jézi, yo diʼy, “Senyè, bon janʼw-lan malad.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Lè Jézi tann sa, i di, “Maladi sala pa kay tjwéʼy. Sa fèt pou moun sa wè pouvwa Bondyé, èk pou yo sa wè pouvwa Gason Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jézi té enmen Mafa, èk séséʼy èk Lazaròs. ");
INSERT INTO acfNT_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Mé lè i tann nouvèl-la ki Lazaròs té malad, i wèsté koté i té yé-a pou dé jou ankò. ");
INSERT INTO acfNT_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Apwé sa, i di sé disip li-a, “Annou déviwé Joudiya.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Sé disip-la di, “Titja, i pa ni djè lontan dépi sé Jwif-la té vlé tjwéʼw èk wòch èk ou vlé viwé an menm plas sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Jézi di, “On jou pa ni douz nèditan-an, on? Népòt moun ki maché gwan lajouné pa kay tonbé, paski i ka wè klèté-a ki ka kléwé latè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Mé si i maché òswè, i kay konyen pyéʼy, paski i pa ka wè pyès klèté.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Lè Jézi fini di sa, i di yo ankò, “Kanmawad nou Lazaròs ka dòmi, mé mwen kay alé èk mwen kay lévéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Sé disip la di, “Mèt, si i ka dòmi, sa bon. I kay vini byen.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jézi té vlé di yo sé mò Lazaròs té mò, mé yo té konpwann sé dòmi i té ka dòmi. ");
INSERT INTO acfNT_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Kon sa Jézi di yo aklè, “Sé mò Lazaròs mò, ");
INSERT INTO acfNT_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","mé pou lapéti zòt, mwen kontan mwen pa té la épiʼy, pou zòt sa kwè an mwen. Annou koté i yé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tonmas (yo té ka kwiyé Jimo-a) di sé lézòt disip-la, “Annou alé èk Mèt-la, pou nou sa mò ansanm épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Lè Jézi wivé la, i jwenn yo té ja téwé Lazaròs dépi kat jou ki pasé. ");
INSERT INTO acfNT_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bèfanni té bò dé lyé hòd Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","An pil sé jan Joudiya-a té ja vini pou konsolé Mafa èk Mari pou lanmò fwè yo. ");
INSERT INTO acfNT_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Lè Mafa tann di Jézi té ka vini, i pati alé jwenn li, mé Mari wèsté asid an kay-la. ");
INSERT INTO acfNT_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mafa di Jézi, “Senyè, si ou té la, fwè mwen pa té kay mò. ");
INSERT INTO acfNT_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Mé mwen sav jis atjwèlman Bondyé ka baʼw népòt bagay ou mandéʼy pou.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Jézi diʼy, “Fwèʼw kay viwé vivan ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","I di, “Mwen sav i kay viwé vivan ankò asou dènyé jou-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Jézi diʼy, “Sé mwen ki ka fè moun wésisité èk sé mwen ki ka ba yo lavi. Népòt moun ki kwè an mwen kay viv, menm si i ja mò. ");
INSERT INTO acfNT_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Moun-an ki ka viv èk ki ka kwè an mwen-an pa kay janmen mò. Ou kwè sa mwen di-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Mafa di, “Wi Senyè, mwen kwè sé ou ki Mèsaya-a, Gason Bondyé ki té ni pou vini an latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Lè Mafa fin di sa, i déviwé èk i ay kwiyé séséʼy Mari. I diʼy an zòwèy, “Titja-a la, ʼi. I ka mandé pou ou.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Lè Mari tann sa, i lévé vitman ay jwenn Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jézi pʼòkò té wivé an vil-la, mé i té an menm plas-la koté Mafa té jwenn li-an. ");
INSERT INTO acfNT_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Lè sé Jwif-la ki té an kay-la ka konsolé Mari-a wè i lévé vitman èk i pati, yo swiv li. Yo kwè sété bò twou-a i té ka alé ay pléwé. ");
INSERT INTO acfNT_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Lè Mari wivé koté Jézi té yé-a, kon i wèʼy, i tonbé an pyéʼy èk i di, “Senyè, si ou té la, fwè mwen pa té kay mò!” ");
INSERT INTO acfNT_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Lè Jézi wèʼy ka pléwé èk mannyè sé Jwif-la ki té épiʼy-la té ka pléwé, sa touché tjèʼy, èk sa distwéʼy an chay. ");
INSERT INTO acfNT_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","I di, “Koté zòt téwéʼy?” Yo di, “Mèt, vini wè.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Jézi pléwé. ");
INSERT INTO acfNT_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Sé Jwif-la di, “Gadé mannyè i enmenʼy, on!” ");
INSERT INTO acfNT_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Mé adan yo di, “Si i fè nonm-lan ki té avèg-la wè klè, ou pa kwè i té kay sa anpéché Lazaròs mò?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Jézi té distwé an tjèʼy ankò. I alé bò twou-a, ki sété on kav yo té fouyé an kayè-a èk yo té mété an wòch bouché djòl li. ");
INSERT INTO acfNT_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Jézi di yo, “Débouché twou-a!” Mafa, ki té sésé nonm-lan ki mò-a, di, “Senyè, i ni kat jou dépi yo téwéʼy. Pou atjwèlman i ja ka santi!” ");
INSERT INTO acfNT_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Jézi diʼy, “Ès mwen pa té ja diʼw ou kay wè pouvwa Bondyé si ou kwè?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Sé moun-an tiwé wòch-la. Jézi lévé zyéʼy an syèl èk i di, “Papa, mwen ka wimèsyéʼw paski ou ka tann mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Mwen sav ou toujou ka tann mwen, mé mwen ka di sa pou lapéti sé moun sala ki isi-a, pou yo sa kwè sé ou ki voyé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Lè i fini di sa, i kwiyé fò, èk i di, “Lazaròs, sòti dèwò!” ");
INSERT INTO acfNT_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Lazaròs sòti. Lanmenʼy épi pyéʼy té voplé toujou èk had-la yo té vopléʼy-la, èk fidjiʼy té voplé èk an sèvyèt. Jézi di yo, “Démawéʼy èk kitéʼy alé.” ");
INSERT INTO acfNT_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","An pil an sé Jwif-la ki té vin vizité Mari-a wè sa Jézi fè-a èk yo kwè an li, ");
INSERT INTO acfNT_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","mé adan yo viwé èk yo di sé Fawizyen-an ki sa Jézi té fè. ");
INSERT INTO acfNT_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Kon sa sé Fawizyen-an èk sé chèf pwèt-la asanblé ansanm an konsèy. Yo di, “Ki sa nou kay fè? Gadé tout sé miwak-la nonm sala ka fè-a! ");
INSERT INTO acfNT_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Si nou kitéʼy kontiné kon sa, tout moun kay kwè an li, èk sé ofisyé Ronm-lan kay vini èk yo kay détwi Kay Bondyé-a èk yo kay détwi nasyon nou sé Jwif-la!” ");
INSERT INTO acfNT_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Yonn an sé nonm-lan yo té ka kwiyé Kayafas, ki sété pli ho chèf pwèt-la pou lanné-a, di, “Ki mannyè zòt kouyon kon sa? ");
INSERT INTO acfNT_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Zòt pa wè i pli bon si yon sèl moun mò pou sé moun-an, pito pou tout nasyon nou-an détwi?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Mé i pa di sa pa kòʼy menm. Kon sé li ki té pli ho chèf pwèt-la pou lanné-a, Bondyé fèʼy di an davans ki Jézi té kay mò pou sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Mé pa pou yo tousèl, mé pou mennen tout sé ich Bondyé-a ki simen toupatou-a vini ansanm kon yonn. ");
INSERT INTO acfNT_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Dépi jou sala sé manm konsèy-la fè plan pou tjwé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Sé pou wézon sala Jézi pa té ka alé toupatou an Joudiya pou tout sé Jwif-la wèʼy, mé i alé adan an plas bò gwan savann-an adan an vil yo ka kwiyé Ifréyim, èk i wèsté la èk sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Tan-an sé Jwif-la té ka sélébwé Fèt Délivwans-lan té tou pwé. An pil moun té ka sòti toupatou an péyi-a ka alé an vil Jérouzalèm pou yo té fè sèvis pou pwépawé kò yo, kon lwa wilizyon yo di, avan fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Yo té ka gadé pou Jézi, èk paditan yo té asanblé an Kay Bondyé-a, yo té ka mandé yonn a lòt, “Ki sa ou kwè? Ou kwè i kay vini an Fèt Délivwans-lan?” ");
INSERT INTO acfNT_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Sé chèf pwèt-la èk sé Fawizyen-an té ja konmandé pou si pyès moun konnèt koté Jézi yé, sé pou yo vini di, pou yo sa awétéʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Sis jou avan Fèt Délivwans-lan, Jézi mouté Bèfanni koté Lazaròs té ka wèsté-a, menm nonm-lan i té wésisité-a. ");
INSERT INTO acfNT_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Yo fè an dinen ba li la pou té onnowéʼy. Sété Mafa ki té ka mennen manjé bay moun. Lazaròs sété yonn an sé sa ki té asid ka manjé èk Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Lè sala Mari pwan an boutèy losyon ki té chè an pil. Losyon sala té ni lavalè yon panyt èk i té fèt épi nad pi. I vidéʼy anlè pyé Jézi, épi i swiyéʼy èk chivéʼy. Lòdè losyon-an plen tout kay-la. ");
INSERT INTO acfNT_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Yonn an sé disip Jézi-a yo ka kwiyé Jida Iskariyòt, menm nonm-lan ki té kay twayiʼy-la, di, ");
INSERT INTO acfNT_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Pouki yo pa té vann losyon sala pou twa san (300) dòla èk bay maléwé lajan-an?” ");
INSERT INTO acfNT_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Sé pa té paski i té mélé èk sé maléwé-a ki fèʼy di sa, mé paski i sété an vòlè. Sé li ki té ka tjenbé sak lajan-an èk i té ni labitid ka pwan adanʼy tanzantan. ");
INSERT INTO acfNT_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Mé Jézi di, “Kité madanm-lan bat mizèʼy! I fè sa pouʼy pwépawé mwen pou jou-a yo kay téwé mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Zòt kay toujou ni sé maléwé-a anpami zòt, mé zòt pa kay ni mwen la pou tout tan.” ");
INSERT INTO acfNT_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","An gwan kantité Jwif té tann di Jézi té an Bèfanni, kon sa yo alé la. Yo alé Bèfanni pa paski yo té vlé wè Jézi tousèl, mé paski yo té vlé wè Lazaròs, nonm-lan Jézi té wésisité-a. ");
INSERT INTO acfNT_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kon sa sé chèf pwèt-la fè plan pou tjwé ni Lazaròs ni Jézi, ");
INSERT INTO acfNT_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","paski lè moun di mannyè Jézi fèʼy wésisité, an pil sé Jwif-la tounen do yo anlè sé chèf pwèt-la èk yo vin kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","An li denmen, tout sé moun-an ki té vini an Fèt Délivwans-lan tann di Jézi té ka vini Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Kon sa yo koupé wanmo èk yo alé jwenn li. Yo hélé: “Tout lonnè pou Bondyé! “Pa dé bon i bon pou moun-an Bondyé voyé-a! “Benni Wa Izwayèl-la!” ");
INSERT INTO acfNT_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jézi jwenn an jenn ti bouwik èk i mouté anlèʼy, menm kon lévanjil-la di. I di: ");
INSERT INTO acfNT_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Jan vil Zayonn, zòt pa bizwen pè! Mi waʼw ka vini, i asou an jenn ti bouwik.” ");
INSERT INTO acfNT_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Sé disip li-a pʼòkò té konpwann sa an tan sala. Mé lè Jézi vin mouté an syèl, yo vin konpwann sa lévanjil-la té di konsènéʼy èk yo chonjé sa yo té fè ba li. ");
INSERT INTO acfNT_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","La té ni an chay moun ki té la èk Jézi lè i té wésisité Lazaròs èk i té fèʼy sòti an twou-a. Sé moun-an té simen sa Jézi fè-a toupatou. ");
INSERT INTO acfNT_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Sé pou sa tout sé moun sala té vini jwenn li, paski yo té tann miwak sala i té fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Lè sé Fawizyen-an wè sa, yo di bay yonn a lòt, “Zòt wè, mi atjwèlman tout moun ka swiv li, èk nou pa sa fè anyen pou anpéché sa!” ");
INSERT INTO acfNT_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","La té ni déotwa jan péyi Gris anpami sé moun-an ki té mouté Jérouzalèm pou adowé Bondyé an fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Yo alé koté Filip, ki té sòti Bèfsayda an péyi Galili, èk yo diʼy, “Misyé, nou vlé palé èk Jézi.” ");
INSERT INTO acfNT_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filip alé di Androu, èk yo dé-a alé di Jézi sa. ");
INSERT INTO acfNT_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Jézi wéponn, i di, “Atjwèlman lè-a wivé pou Bondyé moutwé ki kantité pouvwa mwen Gason Lézòm-lan ni pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Mwen ka di zòt lavéwité-a, an gwenn mi kay wèsté yon gwenn mi tousèl tout tan yo pa ladjéʼy an tè-a pouʼy sa mò. Si i mò, i kay viwé lévé èk i kay pòté an pil gwenn. ");
INSERT INTO acfNT_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Moun-an ki enmen laviʼy twòp-la ka pèd li, mé moun-an ki hayi kalité lavi-a i ka viv an latè sala ka boukantéʼy pou lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Népòt moun ki vlé vini sèvant mwen ni pou swiv mwen, èk sèvant mwen kay la épi mwen koté mwen kay yé-a. Épi Papa mwen kay onnowé népòt moun ki sé sèvant mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Atjwèlman tjè mwen distwé èk mwen pa sav ki sa pou mwen di. Mwen pa sa di, ‘Papa, pa kité soufwans sala vini asou mwen,’ paski sé pou wézon sala mwen vini, pou mwen sa pasé tan soufwans sala. ");
INSERT INTO acfNT_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Papa, fè moun wè pouvwaʼw!” Lè sala an vwa sòti an syèl-la, i di, “Mwen ja fè moun wè pouvwa mwen, èk mwen kay fèʼy ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sé moun-an ki té doubout la-a tann vwa-a. Adan yo di sé an kout loway, lézòt di sé on nanj ki palé ba li. ");
INSERT INTO acfNT_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Mé Jézi di yo, “Sé pa pou lapéti mwen vwa-a palé, mé pou lapéti zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Apwézan lè-a wivé pou Bondyé jijé latè-a. Apwézan i kay mété Satan, wa-a ki ka kondwi latè-a, dèwò. ");
INSERT INTO acfNT_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Lè yo lévé mwen an lézè an latè sala, mwen kay mennen tout moun vini jwenn mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Lè i di sa, i té ka di mannyè i té kay mò. ");
INSERT INTO acfNT_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Sé moun-an wéponn, yo di, “Lwa nou di Mèsaya-a kay viv pou tout tan. Ki mannyè ou ka fè di yo kay lévé Gason Lézòm-lan an lézè? Kilès Gason Lézòm sa ou ka palé-a?” ");
INSERT INTO acfNT_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Jézi wéponn, i di yo, “La kay ni klèté anpami zòt pou an ti tak tan ankò. Kontiné maché an chimenʼw paditan ou ni klèté-a, pou nwèsè-a pa vini anlèʼw. Sé moun-an ki ka maché an nwèsè-a pa menm sav koté yo ka alé. ");
INSERT INTO acfNT_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Mété lafwa zòt an klèté-a paditan zòt niʼy, pou zòt sa vini moun ki ka viv an klèté-a.” Apwé Jézi fini di sa, i pati alé koté yo pa té sa jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Magwé i fè tout sé miwak sala anpami yo, yo pa té kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Kon sa sa pwòfèt Izaya té ja di an tan ki pasé-a té vini fèt vwé. I té di: “Senyè, kilès ki kwè sa nou té di-a? Kilès ki té wè pouvwa Bondyé lè i té moutwéʼy?” ");
INSERT INTO acfNT_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Kon sa sé moun-an pa té sa kwè. Paski Izaya té ja di ankò: ");
INSERT INTO acfNT_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Bondyé té ja avèg yo épi i té ja fèmé lidé yo, pou zyé yo pa té sa wè, èk pou lidé yo pa té sa konpwann, pou yo pa té sa vini jwenn Bondyé, pouʼy té sa djéwi yo.” Sé sa Bondyé menm té di. ");
INSERT INTO acfNT_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Izaya té di sa konsèné Jézi paski i té wè pouvwaʼy an davans. ");
INSERT INTO acfNT_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Magwé sa, an pil an sé chèf Jwif-la té kwè an Jézi. Mé yo pa té ka di sa pou moun té konnèt, paski yo té pè sé Fawizyen-an. Yo pa té vlé sé Fawizyen-an mété yo dèwò an légliz-la. ");
INSERT INTO acfNT_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Yo té simyé moun lévé non yo pito Bondyé lévé non yo. ");
INSERT INTO acfNT_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Jézi palé fò, i di, “Népòt moun ki kwè an mwen pa kwè an mwen tousèl, mé i kwè an moun-an ki voyé mwen-an tou. ");
INSERT INTO acfNT_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Népòt moun ki wè mwen wè moun-an ki voyé mwen-an tou. ");
INSERT INTO acfNT_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Mwen ja vini an latè-a kon klèté latè-a. Népòt moun ki kwè an mwen pa kay wèsté an nwèsè. ");
INSERT INTO acfNT_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Népòt moun ki tann pawòl mwen èk i pa obéyiʼy, mwen pa kay jijéʼy. Mwen pa vini pou jijé sé jan latè-a, mé pou sové yo. ");
INSERT INTO acfNT_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Sé pawòl mwen ki kay jijé moun asou dènyé jou-a! I kay jijé népòt moun ki pa kwè an mwen èk ki pa obéyi sa mwen di-a. ");
INSERT INTO acfNT_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Sa sé lavéwité, paski mwen pa palé pa kò mwen menm, mé Papa-a ki voyé mwen-an ja konmandé mwen ègzaktiman ki sa pou mwen di. ");
INSERT INTO acfNT_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Mwen sav sé pawòl-la i konmandé mwen-an ka bay moun lavi étonnèl. Sé Papa mwen ki konmandé mwen pou di sé pawòl-la mwen ka di-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Sété jou avan Fèt Délivwans-lan. Jézi sav lè-a té ja vini pouʼy kité latè sala pouʼy alé jwenn Papaʼy. I té toujou enmen sé moun li-an ki an latè-a, mé atjwèlman i moutwé yo ki otan enmen i enmen yo. ");
INSERT INTO acfNT_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Jézi èk sé disip li-a té ka dinen. Denmou té ja mété an lidé Jida gason Simon Iskariyòt-la pouʼy té sa twayi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jézi sav Papa-a té ja ba li pouvwa anho tout bagay. I sav i té sòti an Bondyé èk i té ka viwé alé jwenn Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Kon sa i lévé koté i té ka manjé-a, i tiwé gòl-la i té ni anlèʼy-la, èk i mawé an sèvyèt an wenʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Apwé sa, i vidé dlo adan an bésin èk i koumansé lavé pyé sé disip li-a èk i swiyéʼy èk sèvyèt-la i té ni an wenʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Lè i wivé bò Simon Pita, Pita diʼy, “Sé ou ki kay lavé pyé mwen, Senyè?” ");
INSERT INTO acfNT_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Jézi di Pita, “Ou pa konpwann sa mwen ka fè-a atjwèlman, mé ou kay konpwann pli ta.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Pita diʼy, “Mwen pa kay janmen kitéʼw lavé pyé mwen pyès toubonnman!” Jézi di, “Si mwen pa lavé pyéʼw, ou sé pa disip mwen ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Lè i diʼy sa, Pita diʼy, “Senyè, si sé sa, sé pa pyé mwen tousèl mwen vléʼw lavé, mé lavé lanmen mwen èk tèt mwen tou!” ");
INSERT INTO acfNT_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Jézi diʼy, “Lè yon moun fini benyen, tout kòʼy nèt. Sé pyéʼy yonn ki bizwen lavé. Zòt tout nèt, mé la ni yonn anpami-an ki pa nèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jézi té ja sav kilès anpami-an ki té kay twayiʼy. Sé pou sa i di, “Zòt tout nèt, mé la ni yonn anpami-an ki pa nèt.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Apwé Jézi fini lavé pyé yo, i viwé mété gòl li anlèʼy èk i viwé asid koté i té ka manjé-a. I di sé disip-la, “Ès zòt konpwann sa mwen fini fè bay zòt-la? ");
INSERT INTO acfNT_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Zòt ka kwiyé mwen Titja èk Senyè. Zòt byen palé, paski sé sa mwen yé pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Mé si mwen ki Senyèʼw èk Titjaʼw ja abésé kò mwen pou lavé pyéʼw, zòt sipozé lavé pyé yonn a lòt tou. ");
INSERT INTO acfNT_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Mwen ja kité yon ègzanp bay zòt, pou zòt sa fè menm bagay-la mwen fè bay zòt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Mwen ka di zòt lavéwité-a, pyèsonn ki sé yon sèvant pa pli enpòtan pasé mèt li, èk pyès konmisyonnè pa pli enpòtan pasé moun-an ki voyéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Atjwèlman zòt konnèt lavéwité sala, èk pa dé kontan zòt kay kontan lè zòt fèʼy! ");
INSERT INTO acfNT_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Mwen pa ka palé konsèné zòt tout. Mwen konnèt sé nonm-lan mwen ja chwazi-a. Mé sa lévanjil-la di-a ni pou vini fèt vwé. I di, ‘Menm moun-an ki ka manjé èk mwen-an ja vini lèlmi mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Mwen ka di zòt sa apwézan avan i fèt. Kon sa lè i kay fèt, zòt kay kwè sé mwen ki moun-an mwen yé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Mwen ka di zòt lavéwité-a, népòt moun ki wisivwè pyèsonn mwen voyé wisivwè mwen tou. Èk népòt moun ki wisivwè mwen wisivwè moun-an ki voyé mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Apwé Jézi fini di sa, tjèʼy té distwé an chay. I di yo aklè, “Mwen ka di zòt lavéwité-a, yonn an zòt kay twayi mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Sé disip-la gadé yonn a lòt. Yo pyès pa té sav kilès i té ka palé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Yonn an sé disip-la, sa Jézi enmen-an, té asid tou pwé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Simon Pita fè yon sin ba li pouʼy mandé Jézi kilès i ka palé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Kon sa disip-la panché tèt li bò zòwèy Jézi èk i mandéʼy, “Kilès ou ka palé-a, Senyè?” ");
INSERT INTO acfNT_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Jézi di, “Mwen kay fouyé tjò pen an sòs-la, èk moun-an mwen kay bay li-a, sé li ki kay twayi mwen.” Kon sa Jézi pwan tjò pen, i soséʼy an bòl sòs-la, èk i lonjéʼy bay Jida, gason Simon Iskariyòt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Menm kon Jida pwan pen-an, Satan antwé an tjèʼy. Jézi di Jida, “Fè vit, fè sa ou ni pouʼw fè-a!” ");
INSERT INTO acfNT_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Pyès an sé lézòt-la ki té ka manjé épiʼy-la pa konpwann pouki Jézi té diʼy sa. ");
INSERT INTO acfNT_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Sété Jida ki té ka tjenbé sak lajan-an, kon sa adan sé disip-la té kwè Jézi té diʼy alé achté sa yo té bizwen pou fèt-la, ében pou bay sé maléwé-a an lajan. ");
INSERT INTO acfNT_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Jida pwan pen-an épi la menm i sòti dèwò. I té òswè. ");
INSERT INTO acfNT_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Apwé Jida pati, Jézi di sé lézòt disip-la, “Atjwèlman moun ka wè pouvwa Gason Lézòm-lan. Atjwèlman moun ka wè pouvwa Bondyé an mwen Gason Lézòm-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Èk si Gason-an fè moun wè pouvwa Bondyé an li, Bondyé menm kay fè moun wè ki otan pouvwa Gason-an menm ni, èk i kay fèʼy atjwèlman. ");
INSERT INTO acfNT_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Ich mwen, mwen pa kay wèsté épi zòt pou djè lontan ankò. Zòt kay gadé pou mwen, mé mwen ka di zòt menm bagay-la mwen di sé chèf Jwif-la, ‘Zòt pa sa alé koté mwen ka alé-a.’ ");
INSERT INTO acfNT_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Atjwèlman mwen ka bay zòt an konmandman nèf: Sé pou zòt enmen yonn a lòt. Enmen yonn a lòt menm kon mwen ja enmenʼw. ");
INSERT INTO acfNT_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Si zòt enmen yonn a lòt, sé lè sala tout moun kay sav zòt sé disip mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Simon Pita di, “Senyè, koté ou ka alé?” Jézi diʼy, “Ou pa sa swiv mwen apwézan koté mwen ka alé-a, mé ou kay swiv mwen apwé.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Pita di, “Senyè, pouki mwen pa sa swiv ou apwézan? Mwen pawé pou jis mò baʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Jézi diʼy, “Pita, ou kwè ou pawé pou mò ban mwen? Mwen ka diʼw lavéwité-a, avan kòk-la chanté, ou kay ni tan di twa fwa ou pa konnèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Jézi di yo, “Pa kité tjè zòt twakasé. Sé pou zòt kwè an Bondyé, èk sé pou zòt kwè an mwen tou. ");
INSERT INTO acfNT_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","La ni an chay chanm an kay Papa mwen. Mwen ka alé pwépawé an plas bay zòt. Mwen pa té kay di zòt sa si sa pa té vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Apwé mwen alé pwépawé an plas bay zòt, mwen kay déviwé èk mwen kay mennen zòt alé épi mwen. Kon sa koté mwen kay yé-a sé la zòt kay yé tou. ");
INSERT INTO acfNT_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Zòt konnèt chimen-an pou alé an plas-la koté mwen ka alé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Tonmas di, “Senyè, nou pa menm sav koté ou ka alé! Ki mannyè nou kay fè konnèt chimen-an pou alé la?” ");
INSERT INTO acfNT_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Jézi wéponn, i diʼy, “Sé mwen ki chimen-an, sé mwen ki lavéwité-a èk sé mwen ki lavi-a. Sé mwen ki sèl chimen pou alé jwenn Papa-a. ");
INSERT INTO acfNT_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Si zòt té konnèt mwen pou vwé, zòt té kay konnèt Papa mwen tou. Dépi atjwèlman ou konnèt li èk ou ja wèʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Filip diʼy, “Senyè, moutwé nou Papa-a èk nou pa bizwen anyen ankò.” ");
INSERT INTO acfNT_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Jézi diʼy, “Filip, dépi tan sala mwen épi zòt-la, ou ka di ou pa konnèt mwen toujou? Népòt moun ki ja wè mwen ja wè Papa-a. Kon sa pouki ou ka di, ‘Moutwé nou Papa-a’? ");
INSERT INTO acfNT_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ou pa kwè mwen lè mwen di, mwen an Papa-a èk Papa-a an mwen? Sé pa mwen menm ki di sé pawòl-la mwen ja di zòt-la. Sé Papa-a ki manché épi mwen-an ki ja fè twavay li. ");
INSERT INTO acfNT_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sé pouʼw kwè mwen lè mwen di, mwen an Papa-a èk Papa-a an mwen. Mé si ou pa kwè sa mwen ka di-a toujou, sé pouʼw kwè mwen pou lapéti sé miwak-la mwen ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Mwen ka di zòt lavéwité-a, népòt moun ki kwè an mwen kay fè menm sé bagay-la mwen ka fè-a, èk i kay jis fè pli gwo bagay pasé mwen, paski mwen ka alé jwenn Papa-a. ");
INSERT INTO acfNT_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Népòt bagay zòt mandé an non mwen, mwen kay fèʼy pou zòt sa wè pouvwa Papa-a an Gason-an. ");
INSERT INTO acfNT_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Si zòt mandé anyen an non mwen, mwen kay fèʼy bay zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Si zòt enmen mwen, zòt kay obéyi konmandman mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Mwen kay mandé Papa mwen, èk i kay bay zòt an lòt moun pou édé zòt. Moun sala kay la épi zòt pou tout tan. ");
INSERT INTO acfNT_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Moun sala sé Lèspwi Bondyé, èk sé li ki ka moutwé moun lavéwité-a. Sé jan latè-a pa sa wisivwèʼy paski yo pa ka wèʼy, ni yo pa ka konnèt li. Mé zòt menm konnèt li, paski i ka wèsté épi zòt épi i kay viv andidan zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Lè mwen alé, mwen pa kay kité zòt kon manmay ki pa ni manman èk papa. Mwen kay viwé jwenn zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Sé jan latè-a pa kay wè mwen pou djè lontan ankò, mé zòt menm kay wè mwen. Paski mwen ka viv, zòt menm kay viv tou. ");
INSERT INTO acfNT_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Lè jou sala kay vini, zòt kay sav ki mwen an Papa mwen èk zòt an mwen èk mwen an zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“Népòt moun ki aksèpté konmandman mwen èk i obéyi yo, sé moun sala ki enmen mwen. Papa mwen kay enmen moun-an ki enmen mwen-an, épi mwen menm kay enmenʼy tou èk mwen kay moutwéʼy ki moun mwen yé.” ");
INSERT INTO acfNT_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jida mandéʼy an kwèsyon (mé sé pa té Jida Iskariyòt), i di, “Senyè, ki mannyè ou kay fè moutwé nou ki moun ou yé èk sé jan latè-a pa kay wè ki moun ou yé?” ");
INSERT INTO acfNT_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Jézi wéponn, i di, “Népòt moun ki enmen mwen kay obéyi sa mwen ka di-a. Papa mwen kay enmen moun sala, épi mwen èk Papa mwen kay vini jwenn li èk nou kay viv épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Pyèsonn ki pa enmen mwen pa ka obéyi sa mwen ka di-a. Épi sé bagay-la zòt tann mwen di-a, yo pa sòti an mwen, mé an Papa mwen ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Mwen ja di zòt sé bagay sala paditan mwen épi zòt toujou. ");
INSERT INTO acfNT_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Mé Papa mwen kay voyé an moun an non mwen pou édé zòt. Moun sala sé Lèspwi Bondyé. I kay moutwé zòt tout bagay èk i kay fè zòt chonjé tout sa mwen té di zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Mwen ka bay zòt lapé an tjè zòt. Sé menm lapé-a mwen ni-an mwen ka kité bay zòt. Mwen pa ka bay li menm kon latè-a ka bay li. Pa kité tjè zòt twakasé ni pa pè pou sa ki kay fèt. ");
INSERT INTO acfNT_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Zòt ja tann mwen di, ‘Mwen ka alé mé mwen kay viwé jwenn zòt.’ Si zòt té enmen mwen pou vwé, zòt té kay kontan pou sav mwen ka alé jwenn Papa-a, paski Papa-a pli enpòtan pasé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Mwen ka di zòt sa atjwèlman, avan i fèt. Kon sa lè i kay fèt, zòt kay kwè mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Mwen pa sa wèsté palé épi zòt pou djè lontan ankò, paski Satan ka vini. Sé li ki ka kondwi latè sala. I pa sa kondwi mwen, ");
INSERT INTO acfNT_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","mé mwen vlé sé jan latè-a sav mwen enmen Papa-a. Sé pou sa mwen ka fè tout sa i konmandé mwen. “Vini, annou alé sòti an kay sala.” ");
INSERT INTO acfNT_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Mwen sé menm kon bon pyé lyenn-an, èk sé Papa mwen ki ka otjipéʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","I ka tiwé tout bwanch an mwen ki pa ka pòté fwi, èk i ka nétwayé tout bwanch ki ka pòté, pou yo sa pòté pli fwi. ");
INSERT INTO acfNT_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Sé pawòl-la mwen ja diʼw-la ja nétwayéʼw. ");
INSERT INTO acfNT_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Sé pou zòt manché èk mwen, épi mwen menm kay manché épi zòt. An bwanch pa sa pòté fwi pa kòʼy menm. Sèl mannyè i kay pòté fwi sé si i wèsté an pyé-a. Menm mannyè-a, zòt pa sa pòté fwi si zòt pa manché épi mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Mwen sé menm kon pyé lyenn-an, épi zòt sé menm kon sé bwanch-lan. Si an moun manché èk mwen èk mwen manché épiʼy, i kay pòté an pil fwi paski zòt pa sa fè anyen san mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Népòt moun ki pa manché èk mwen, yo ka koupéʼy jété èk i kay sèk menm kon an bwanch bwa ki pa ka pòté fwi. Yo ka anmasé sé bwanch sala èk yo ka jété yo an difé-a, èk yo ka bwilé yo. ");
INSERT INTO acfNT_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Si zòt manché èk mwen èk pawòl mwen kontiné wèsté andidan zòt, zòt kay mandé népòt bagay zòt vlé, èk zòt kay jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Lè zòt pòté an pil fwi èk zòt fè moun wè zòt sé disip mwen, sé lè sala moun kay lévé non Papa mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mwen enmenʼw menm kon Papa-a enmen mwen. Sé pou zòt kontiné enmen mwen menm kon mwen enmen zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Si ou obéyi konmandman mwen, menm kon mwen ja obéyi Papa mwen, mwen kay kontiné enmen zòt menm kon Papa mwen kontiné enmen mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Mwen ja diʼw sé bagay sala pouʼw ni menm tjè kontan-an mwen ni-an, èk pou tjè kontan-an ou ni-an pa mantjé anyen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Mi konmandman sala mwen ka kité bay zòt: Sé pou zòt enmen yonn a lòt menm kon mwen enmen zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","La pa ni lanmityé ki pli fò pasé lè an moun mò pou kanmawad li. ");
INSERT INTO acfNT_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Zòt sé kanmawad mwen si zòt fè sa mwen konmandé zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Mwen pa ka kwiyé zòt sèvant ankò, paski on sèvant pa konnèt zafè mèt li. Mé mwen ka kwiyé zòt kanmawad, paski mwen ja di zòt tout bagay Papa mwen di mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Sé pa zòt ki chwazi mwen. Sé mwen ki chwazi zòt èk mwen voyé zòt alé pòté an pil fwi, kalité fwi-a ki kay diwé-a. Èk Papa mwen kay bay zòt népòt bagay zòt mandéʼy an non mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Mi sa mwen ka konmandéʼw: Sé pou zòt enmen yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Si jan latè-a hayi zòt, pa obliyé yo té hayi mwen avan. ");
INSERT INTO acfNT_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Si zòt sété menm èk sé jan latè-a, yo té kay enmen zòt kon moun yo. Mé mwen chwazi zòt èk mwen tiwé zòt anpami sé jan latè-a, kon sa zòt sé pa menm èk sé jan latè-a ankò. Sé pou sa sé jan latè-a hayi zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Chonjé sa mwen té di zòt: ‘Pyès sèvant pa pli enpòtan pasé mèt li.’ Si yo pèsikité mwen, jijéwè pou zòt menm. Èk si yo obéyi sa mwen té ka moutwé yo-a, yo kay obéyi sa zòt ka moutwé yo-a tou. ");
INSERT INTO acfNT_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Mé yo kay pèsikité zòt paski zòt sé moun mwen. Yo kay fè sa paski yo pa konnèt moun-an ki voyé mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Yo pa té kay koupab pou péché yo si mwen pa té vini palé ba yo. Mé yo koupab atjwèlman paski yo pa sa janmen di yo pa té sav sa yo té ka fè-a sé péché. ");
INSERT INTO acfNT_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Népòt moun ki hayi mwen hayi Papa mwen tou. ");
INSERT INTO acfNT_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Yo pa té kay koupab si mwen pa té fè sé bagay sala anpami yo, sé bagay-la pyès moun pa janmen fè-a. Mé atjwèlman yo ja wè sé miwak-la mwen fè-a, yo hayi ni mwen ni Papa mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Mé sé bagay sala té ni pou fèt pou sa ki ékwi an lwa yo-a vini fèt vwé. Lwa yo di, ‘Yo hayi mwen san pyès wézon.’ ");
INSERT INTO acfNT_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Lèspwi-a, sa sé moun-an ki kay édéʼw-la, kay vini sòti koté Papa-a èk i kay moutwé zòt lavéwité-a. Mwen kay voyéʼy vini bay zòt sòti koté Papa-a, èk i kay palé konsèné mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Èk zòt menm tou kay palé konsèné mwen, paski zòt té ja èk mwen dépi an koumansman-an. ");
INSERT INTO acfNT_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Mwen ja di zòt tout sé bagay sala pou zòt pa sipwi lè sé bagay sala kay fèt, pou zòt pa tiwé lafwa zòt an mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Yo kay kouwi dèyè zòt an sé légliz sé Jwif-la, épi lè-a ka vini lè népòt moun ki tjwé zòt kay kwè sé twavay Bondyé i ka fè. ");
INSERT INTO acfNT_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Yo kay fè zòt sa paski yo pa konnèt ni mwen ni Papa-a. ");
INSERT INTO acfNT_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Mé mwen ja di zòt sa, pou lè lè-a kay vini pou yo fè sé bagay sala, zòt kay chonjé sa mwen té ja di-a. Mwen pa té di zòt sa lè zòt té vini disip mwen tou fwé, paski mwen té la épi zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","“Mé atjwèlman kon mwen ka alé jwenn moun-an ki té voyé mwen-an, zòt pyès pa mandé mwen koté mwen ka alé. ");
INSERT INTO acfNT_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Épi atjwèlman kon mwen di zòt sa-a, tjè zòt an lapenn. ");
INSERT INTO acfNT_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Mé mwen ka di zòt lavéwité-a, i pli mèyè pou zòt si mwen alé, paski si mwen pa alé, Lèspwi Bondyé ki kay édé zòt-la, pa kay vini. Mé lè mwen alé, mwen kay voyéʼy bay zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Èk lè i vini, i kay moutwé sé jan latè-a yo an lèwè lè yo di, ‘Nou sav ki sa ki péché, èk nou sav sa ki dwèt èk nou konnèt jijman Bondyé.’ ");
INSERT INTO acfNT_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Yo an lèwè konsèné péché, paski yo wifizé kwè an mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Yo an lèwè konsèné sa ki dwèt, paski mwen ka alé jwenn Papa mwen, èk zòt pa kay wè mwen ankò. ");
INSERT INTO acfNT_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Èk yo an lèwè konsèné jijman Bondyé, paski Bondyé ja kondanné Satan, paski sé li ki ka kondwi latè sala. ");
INSERT INTO acfNT_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Mwen ni an pil lòt bagay pou mwen di zòt toujou, mé lidé zòt pa kay sa pwan tout atjwèlman. ");
INSERT INTO acfNT_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Mé lè Lèspwi-a ki kay moutwé zòt lavéwité-a kay vini, i kay fè zòt konnèt tout lavéwité ki sòti an Bondyé. I pa kay palé pa kòʼy menm, mé i kay palé sa i tann épi i kay diʼw bagay ki kay fèt apwé. ");
INSERT INTO acfNT_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","I kay lévé non mwen, paski i kay di zòt pawòl i tann mwen di. ");
INSERT INTO acfNT_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Tout sa Papa mwen ni sé sa mwen. Sé pou sa mwen di, Lèspwi-a kay kouté sa mwen di èk i kay moutwé zòt li. ");
INSERT INTO acfNT_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Adan an ti mouman, zòt pa kay wè mwen ankò èk adan an ti mouman ankò, zòt kay wè mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","18","Adan sé disip li-a di anpami kò yo, “Ki sa sa vlé di? I di nou adan an ti mouman ankò, nou pa kay wèʼy. Èk adan an ti mouman ankò, nou kay wèʼy. Èk i di ankò sé paski i ka alé koté Papaʼy. Ki sa i vlé di lè i di ‘adan an ti mouman ankò?’ Nou pa sav konsèné ki sa i ka palé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Jézi sav yo té vlé mandéʼy an kwèsyon, kon sa i di yo, “Ès zòt ka palé anpami kò zòt paski mwen di, ‘Adan an ti mouman ankò zòt pa kay wè mwen, èk adan an ti mouman ankò, zòt kay wè mwen?’ Ès sé kwèsyon sala yonn ka mandé lòt-la? ");
INSERT INTO acfNT_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Mwen ka di zòt lavéwité-a, zòt kay fè kwi èk zòt kay pléwé, mé sé jan latè-a kay kontan. Zòt kay an lapenn, mé lapenn zòt kay tounen pou tjè kontan. ");
INSERT INTO acfNT_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Lè an madanm malad akouché, i ka an lapenn paski lè-a pouʼy soufè-a ja vini. Mé lè ti manmay-la fèt, i ka obliyé tout soufwans-lan, paski i ka kontan an ti manmay fèt an latè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Sé kon sa i kay yé épi zòt. Apwézan zòt an lapenn, mé mwen kay wè zòt ankò, épi zòt kay ni lajwa, lajwa-a pyèsonn pa sa tiwé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Lè jou sala vini, zòt pa kay bizwen mandé mwen anyen ankò. Mwen ka di zòt lavéwité-a, Papa-a menm ki kay bay zòt népòt bagay zòt mandéʼy an non mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Pou jis atjwèlman, zòt pʼòkò mandé anyen an non mwen. Sé pou zòt mandé, èk lajwa-a zòt ni-an pa kay mantjé anyen, paski zòt kay wisivwè sa zòt mandé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Mwen palé bay zòt an pawabòl pou di zòt sé bagay sala, mé lè-a ka vini lè mwen pa kay sèvi pawabòl ankò. Mwen kay di zòt tout bagay aklè konsèné Papa-a. ");
INSERT INTO acfNT_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Lè jou sala vini, zòt kay mandé Bondyé népòt bagay an non mwen, èk sé pa mwen ki kay mandéʼy bay zòt. ");
INSERT INTO acfNT_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Papa-a menm enmen zòt, paski zòt enmen mwen èk zòt kwè sé Bondyé ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Mwen sòti koté Papa-a èk mwen vini an latè-a. Atjwèlman mwen ka kité latè-a èk mwen ka alé jwenn Papa-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Lè sala sé disip-la diʼy, “Sé atjwèlman ou ka palé aklè, èk ou pa ka palé an pawabòl. ");
INSERT INTO acfNT_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Nou sav ou konnèt tout bagay. Ou konnèt wépons kwèsyon-an ki an lidé an moun dépi avan i mandéʼy. Sé sa ki fè nou kwè ou sòti koté Bondyé pou vwé.” ");
INSERT INTO acfNT_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Jézi wéponn, i di yo, “Atjwèlman zòt kwè? ");
INSERT INTO acfNT_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Lè-a ka vini èk i ja wivé lè zòt tout kay simen. Zòt chak kay kouwi lakay zòt, èk zòt kay kité mwen la pa kò mwen yonn. Mé pa kwè mwen la pa kò mwen paski Papa-a la épi mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Mwen ja di zòt sé bagay sala pou zòt sa toujou ni lapé an tjè zòt, paski zòt ja manché èk mwen. Sé jan latè-a kay pèsikité zòt, mé pa pè paski mwen ja détwi pouvwa-a ki ka kondwi latè-a!” ");
INSERT INTO acfNT_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Lè Jézi fini palé bay sé disip li-a, i lévé zyéʼy an syèl èk i di, “Papa, lè-a ja vini. Fè moun wè pouvwa Gasonʼw, pou mwen fè moun wè pouvwaʼw. ");
INSERT INTO acfNT_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Paski ou ban mwen pouvwa anho tout lézòm, pou mwen sa bay tout sé moun-an ou ban mwen-an lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Lè moun konnèt ou, sèl Bondyé ki ni pou vwé, èk yo konnèt Jézi Kwi, moun-an ou voyé-a, sé lè sala ou ka ba yo lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Mwen ja fè tout moun ki an latè-a wè pouvwaʼw, paski mwen ja fini twavay-la ou ban mwen fè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Atjwèlman, Papa, onnowé mwen kon mwen doubout douvanʼw-lan, menm mannyè ou té onnowé mwen lè mwen té épiʼw avan latè-a té fèt. ");
INSERT INTO acfNT_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Mwen ja fè sé nonm sala ou ban mwen an latè-a konnèt ou. Yo sété sa ou, épi ou ban mwen yo. Yo ja obéyi pawòl ou. ");
INSERT INTO acfNT_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Atjwèlman yo sav sé ou ki ban mwen tout bagay mwen ni. ");
INSERT INTO acfNT_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Mwen ba yo konmisyon-an ou té ban mwen-an èk yo wisivwèʼy. Yo sav sé koté ou yé-a mwen sòti èk yo kwè sé ou ki voyé mwen pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mwen ka pwédyé ba yo. Mwen pa ka pwédyé bay sé jan latè-a, mé bay sé nonm sala ou ja ban mwen-an, paski yo sé sa ou. ");
INSERT INTO acfNT_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Tout sa mwen ni sé sa ou, èk tout sa ou ni sé sa mwen, èk moun kay wè pouvwa mwen an sé nonm sala. ");
INSERT INTO acfNT_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Mwen ka vini jwenn ou atjwèlman. Mwen pa kay la an latè-a ankò, mé yo an latè-a. Papa, ou pa ni pyès fòt! Mwen ka mandéʼw pou pwotèkté yo èk pouvwa-a ki an nonʼw-lan, menm non-an ou ban mwen-an, pou yo sa vini yonn, menm kon mwen èk ou sé yonn. ");
INSERT INTO acfNT_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Paditan mwen té épi yo, mwen té pwotèkté yo èk pouvwa-a ki an nonʼw-lan, menm non-an ou ban mwen-an. Mwen pwotèkté yo, èk pa menm yonn an yo ki pèd, antiwan nonm-lan ki té ni pou pèd-la, pou sa lévanjil-la té di-a vini fèt vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Atjwèlman mwen ka vini jwenn ou, mé mwen ka di sé bagay sala paditan mwen an latè-a, pou sé nonm sala ni menm lajwa-a mwen ni an tjè mwen-an, lajwa-a ki pa mantjé anyen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Mwen ba yo konmisyonʼw, èk sé jan latè-a hayi mwen, paski sé nonm sala sé pa menm èk sé jan latè-a, menm kon mwen pa menm èk sé jan latè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Mwen pa ka mandéʼw pou tiwé yo an latè-a, mé pou pwotèkté yo kont pouvwa Satan, nonm méchan-an. ");
INSERT INTO acfNT_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Menm kon mwen pa menm èk sé jan latè-a, sé nonm sala sé pa menm èk sé jan latè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Sèvi pawòl lavéwité-a pou fè yo viv ba ou yonn, paski pawòl ou sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Mwen ka voyé yo an latè-a, menm kon ou voyé mwen an latè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Èk pou lapéti yo mwen ka viv mannyè-a ou vlé mwen viv-la pou yo menm sa viv mannyè-a ou vlé yo viv-la pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Sé pa bay sé nonm sala yonn mwen ka pwédyé, mé bay tout lézòt ki kay kwè an mwen lè sé nonm sala kay palé konmisyon yo konsèné mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Mwen ka pwédyé pou yo tout vini yonn. Papa, mwen ka mandéʼw pou fè yo vini yonn èk nou, menm kon ou an mwen èk mwen an ou. Fè yo vini yonn, pou sé jan latè-a sa kwè sé ou ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Mwen ba yo menm pouvwa-a ou ban mwen-an, pou yo sa vini yonn, menm kon mwen épi ou sé yonn. ");
INSERT INTO acfNT_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Mwen ka viv an yo menm kon ou ka viv an mwen, pou yo sa vini yonn, pou sé jan latè-a sav sé ou ki voyé mwen èk ou enmen yo menm kon ou enmen mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Papa, sé ou ki ban mwen yo, èk mwen vlé yo la épi mwen koté mwen yé-a, pou yo sa wè pouvwa mwen. Ou ban mwen menm pouvwa sala, paski ou enmen mwen dépi avan latè-a té fèt. ");
INSERT INTO acfNT_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Papa, ou dwèt! Sé jan latè-a pa konnèt ou, mé mwen konnèt ou, èk sé moun sala ou ban mwen-an sav sé ou ki voyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Mwen fè yo konnèt ou, èk mwen kay kontiné fè yo konnèt ou, pou yo enmen lézòt menm kon ou enmen mwen, èk pou mwen menm sa viv an yo.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Apwé Jézi fini pwédyé kon sa, li èk sé disip li-a kité koté yo té yé-a èk yo twavèsé fon Kidronn-an. La té ni an jaden la, kon sa Jézi èk sé disip li-a alé an jaden-an. ");
INSERT INTO acfNT_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Mé Jida menm, nonm-lan ki té kay twayiʼy-la, té konnèt plas-la, paski Jézi té ja alé la plizyè fwa èk sé disip li-a. ");
INSERT INTO acfNT_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Kon sa Jida alé an jaden-an, èk i mennen tibwen sòlda Ronm épiʼy. Sé chèf pwèt-la èk sé Fawizyen-an té voyé déotwa gad Kay Bondyé-a alé épi Jida tou. Sé sòlda-a èk sé gad-la té byen amé, èk yo té ni lanp èk flanbo. ");
INSERT INTO acfNT_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jézi té konnèt tout bagay yo té kay fèʼy, kon sa i maché douvan èk i mandé yo, “Ki moun zòt ka gadé pou?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yo di, “Nou ka gadé pou Jézi nonm Nazawèt-la.” I di yo, “Sé mwen ki li.” Jida menm, nonm-lan ki té kay twayiʼy-la, té doubout la épi yo. ");
INSERT INTO acfNT_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Lè Jézi di yo, “Sé mwen ki li,” yo bak dèyè èk yo tonbé atè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Jézi mandé yo ankò, “Ki moun zòt ka gadé pou?” Yo di, “Nou ka gadé pou Jézi nonm Nazawèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Jézi di, “Mé mwen ja di zòt sé mwen ki li. Si sé pou mwen zòt ka chaché, kité sé lézòt nonm sala alé.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","I di yo sa pou sa i té di an tan ki pasé té vini fèt vwé. I té di, “Papa, pa menm yonn an sé moun-an ou ban mwen-an ki pèd.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Simon Pita hédi on sab i té ni èk i fwapé sèvant pli ho chèf pwèt-la. I fè zòwèy dwèt li pwan lavòl. Non sèvant sala sété Malkas. ");
INSERT INTO acfNT_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Jézi di Pita, “Mété sab sala viwé an plas li! Mwen ni pou bwè an pòt soufwans-lan Papa mwen ja ban mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Lè sala sé sòlda Ronm-lan èk konmandè yo, ansanm èk sé gad Jwif-la, awété Jézi èk yo mawé lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Pwèmyé koté yo mennenʼy sé bay Annas. I sété bopè Kayafas, ki té pli ho chèf pwèt-la pou lanné-a. ");
INSERT INTO acfNT_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Sété menm Kayafas sala ki té di sé chèf Jwif-la i té kay pli mèyè si yon sèl nonm mò pou tout sé lézòt moun-an. ");
INSERT INTO acfNT_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Simon Pita èk an lòt disip té ka swiv Jézi olwen. Pli ho chèf pwèt-la té konnèt disip sala byen, kon sa disip-la alé èk Jézi an lakou pwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Pita té wèsté dèwò bò bayè-a. Kon sa lòt disip-la pli ho chèf pwèt-la té konnèt-la viwé sòti, i palé bay tifi-a ki an bayè-a, èk i fè Pita antwé. ");
INSERT INTO acfNT_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Tifi-a ki té bò bayè-a di Pita, “Ès ou sé yonn an sé disip nonm sala tou?” Pita di, “Non, mwen sé pa yonn.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Tan-an té fwèt, kon sa sé sèvant-lan épi sé gad-la té ni chèbon ka limen, èk yo té oliwonʼy ka chofé kò yo. Kon sa Pita alé la èk i doubout la épi yo ka chofé kòʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Pli ho chèf pwèt-la kwèsyonnen Jézi konsèné sé disip li-a èk sa i té ka enstwi moun. ");
INSERT INTO acfNT_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Jézi wéponn, i di, “Mwen té toujou ka palé douvan tout moun. Mwen enstwi sé moun-an an sé légliz sé Jwif-la èk an Kay Bondyé-a, koté tout moun ka asanblé. Mwen pa janmen di anyen an sigwé. ");
INSERT INTO acfNT_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Kon sa, pouki ou ka kwèsyonnen mwen? Mandé sé moun-an ki tann mwen-an ki sa mwen di yo. Yo sav ki sa mwen di.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Lè Jézi di sa, yonn an sé gad-la bay Jézi yon souflé. I diʼy, “Pouki ou ka palé kon sa bay pli ho chèf pwèt-la?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Jézi wéponn, i di, “Si mwen ja di anyen ki pa bon, diʼy douvan tout moun. Mé si mwen ni wézon, pouki ou ban mwen souflé sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Lè i fini di sa, Annas fè yo mennenʼy alé bay Kayafas, pli ho chèf pwèt-la. Lanmenʼy té mawé toujou. ");
INSERT INTO acfNT_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Pita té doubout menm koté-a toujou, ka chofé kòʼy. Kon sa sé lézòt sé moun-an diʼy, “Ès ou sé yonn an sé disip nonm sala tou?” Pita di, “Non, mwen sé pa yonn.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Yonn an sé sèvant pli ho chèf pwèt-la, ki sété fanmi nonm-lan Pita té koupé zòwèy-la, di, “Ès sé pa té ou mwen wè an jaden-an épiʼy-la?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Pita wéponn ankò, i di, “Non, sé pa té mwen,” èk menm lè-a kòk-la chanté. ");
INSERT INTO acfNT_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Jou bonmaten sala byen bonnè, yo pwan Jézi lakay Kayafas èk yo mennenʼy an gwan kay gouvènè-a. Sé gad-la sé chèf Jwif-la té voyé-a pa antwé an kay gouvènè-a, paski yo té vlé tjenn kò yo nèt kon lwa wilizyon yo di, pou yo té sa manjé an Fèt Délivwans-lan. ");
INSERT INTO acfNT_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Kon sa Pilat sòti dèwò èk i di yo, “Ki sa zòt ni kont nonm sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Yo wéponn Pilat, yo diʼy, “Nou pa té kay mennenʼy baʼw si i pa té fè pyès kwim.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Pilat di yo, “Ében, pwanʼy zòt menm èk sèvi lwa zòt menm pou jijéʼy.” Sé Jwif-la wéponn, yo diʼy, “Gouvèdman Ronm-lan pa ka ban nou dwa pou kondanné pyèsonn pou lanmò.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Sa fèt pou sa Jézi té di-a vini fèt vwé lè i té di ki mannyè i té kay mò. ");
INSERT INTO acfNT_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilat viwé antwé an gwan kay gouvènè-a ankò èk i kwiyé Jézi. I diʼy “Ès sé ou ki wa sé Jwif-la?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Jézi wéponn, i di, “Ou menm ki ka mandé mwen kwèsyon sala ében ès sé an moun ki diʼw mandé mwenʼy?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Pilat diʼy, “É, é, ou wè mwen sé on Jwif, on? Sé moun ou-an menm èk sé chèf pwèt-la ki voyéʼw ban mwen. Di mwen ki sa ou ja fè.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Jézi di, “Wéyòm-lan mwen ka kondwi-a pa sòti an latè sala. Si mwen sété an wa ki ka kondwi an latè sala, sé disip mwen-an té kay goumen pou mwen. Yo pa té kay kité mwen tonbé an lanmen sé chèf Jwif-la. Non! Wéyòm-lan mwen ka kondwi-a pa sòti isi-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Kon sa Pilat mandéʼy, “Ében si sé sa, ou sé an wa?” Jézi wéponn, i di, “Ou ja byen palé. Mwen té vini an latè-a èk mwen fèt pou wézon sala, pou mwen sa palé konsèné lavéwité-a. Népòt moun ki enmen lavéwité-a ka kouté pawòl mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Pilat diʼy, “Ki sa ki lavéwité?” Lè sala Pilat viwé dèwò-a èk i di sé Jwif-la, “Mwen pa jwenn pyès wézon pou mwen kondanné nonm sala. ");
INSERT INTO acfNT_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Mé sa sé twadisyon zòt pou mwen ladjé an pwizonnyé bay zòt chak lanné pou Fèt Délivwans-lan. Ès zòt kay kontan si mwen ladjé wa sé Jwif-la?” ");
INSERT INTO acfNT_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Lè sala yo tout koumansé hélé fò, yo di, “Nou pa vléʼy! Barabas nou vlé!” Barabas sala sété an mové vòlè. ");
INSERT INTO acfNT_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Lè sala Pilat fè sé sòlda-a mennen Jézi alé èk bat li. ");
INSERT INTO acfNT_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Sé sòlda-a pwan bwanch pikan èk yo fè on kouwonn ba li èk yo météʼy asou tèt li. Yo mété on gòl lila anlèʼy ");
INSERT INTO acfNT_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","èk yo té ka vini bòʼy èk yo diʼy, “Kité wa sé Jwif-la kondwi pou tout tan!” Yo alé bòʼy èk yo ba li souflé. ");
INSERT INTO acfNT_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilat viwé sòti ankò épi i di sé Jwif-la, “Kouté, mwen kay fè yo mennenʼy viwé dèwò bay zòt pou zòt wè mwen pa jwenn pyès wézon pou mwen kondannéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Lè Jézi viwé sòti dèwò, i té ni kouwonn pikan-an asou tèt li èk gòl lila-a asouʼy. Pilat di sé Jwif-la, “Mi nonm-lan!” ");
INSERT INTO acfNT_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Lè sé chèf pwèt-la èk sé gad Kay Bondyé-a wèʼy, yo hélé fò èk yo di, “Kwisifyéʼy! Kwisifyéʼy!” Pilat di yo, “Zòt menm pwanʼy, èk kwisifyéʼy. Mwen pa jwenn pyès wézon pou mwen kondannéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Sé Jwif-la wéponn viwé, yo di, “Nou ni an lwa ki di sé pouʼy mò, paski i di sé li ki Gason Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Lè Pilat tann sa, i té vini pli pè ankò. ");
INSERT INTO acfNT_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","I viwé antwé an gwan kay gouvènè-a èk i mandé Jézi, “Koté ou sòti?” Mé Jézi pa wéponn. ");
INSERT INTO acfNT_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Pilat diʼy, “Ou pa vlé wéponn mwen? Pa obliyé, mwen ni pouvwa pou mwen sa ladjéʼw ében pou mwen fè yo kwisifyéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Jézi wéponn, i diʼy, “Ou pa ni pyès pouvwa anlè mwen si sé pa Bondyé ki ba ou pouvwa sala. Kon sa moun-an ki ladjé mwen an lanmenʼw-lan pli koupab paséʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Lè Pilat tann sa, i chaché an mannyè pouʼy té sa ladjé Jézi. Mé sé Jwif-la hélé, “Si ou ladjé nonm sala, ou pa kanmawad Wa Siza! Pyèsonn ki di i sé on wa sé lèlmi Wa Siza ki ka kondwi tout sé péyi-a!” ");
INSERT INTO acfNT_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Lè Pilat tann sa, i mennen Jézi dèwò èk i asid anlè gwan chèz-la i ka asid pou jijé-a. Yo ka kwiyé plas sala Lakou Wòch-la (sa sé Gabafa an langaj sé Jwif-la). ");
INSERT INTO acfNT_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","I té pwèskè midi, jou avan Fèt Délivwans-lan. Pilat di sé Jwif-la, “Mi wa zòt-la!” ");
INSERT INTO acfNT_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Yo hélé, “Tjwéʼy! Tjwéʼy! Kwisifyéʼy!” Pilat di, “Zòt vlé mwen kwisifyé wa zòt-la?” Sé chèf pwèt-la wéponn, yo di, “Sé Siza yonn nou konnèt pou wa nou!” ");
INSERT INTO acfNT_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Kon sa Pilat ladjé Jézi an lanmen yo pou yo alé kwisifyéʼy. Yo pwanʼy èk yo mennenʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Jézi pòté kwaʼy sòti an vil-la pou wivé an plas-la yo ka kwiyé Mòn Kalòt Tèt-la. Yo ka kwiyé plas sala Gòlgòfa an langaj sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Yo kwisifyéʼy la ansanm èk dé lézòt nonm, yon nonm asou chak kotéʼy èk Jézi menm an mitan-an. ");
INSERT INTO acfNT_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilat fè yo ékwi on ékwiti mété asou kwa-a. Ékwiti-a di, “Sa Sé Jézi Nonm Nazawèt-la. Sé Li Ki Wa Sé Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","An pil moun té li ékwiti-a, paski plas-la koté yo té kwisifyé Jézi-a té tou pwé vil-la. Ékwiti-a té ékwi an twa diféwan langaj, i té ékwi an langaj sé Jwif-la, an Laten èk an Grik. ");
INSERT INTO acfNT_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Sé chèf pwèt-la di Pilat, “Pa ékwi ‘Sé li ki Wa sé Jwif-la,’ mé ékwi pito, ‘Nonm sala di sé li ki Wa sé Jwif-la.’ ” ");
INSERT INTO acfNT_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Pilat wéponn, i di, “Sa mwen ékwi mwen ékwi.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Lè sé sòlda-a fini kwisifyé Jézi, yo pwan had li èk yo sépawéʼy an kat, yonn bay chak sòlda. Yo pwan gòl li-a ki té fèt èk yon sèl mòso twèl-la. I té sòti dépi an kou-a wivé an pyé-a èk i pa té ni pyès koté i koud. ");
INSERT INTO acfNT_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Sé sòlda-a di bay yonn a lòt, “Nou pa kay déchiwéʼy. Annou jwé gwenndé pou li pou nou wè kilès ki kay genyenʼy.” Sa fèt pou sa lévanjil-la té di-a vini fèt vwé. Lévanjil-la di: “Yo sépawé had mwen anpami kò yo èk yo jwé gwenndé pou gòl mwen-an.” Sé sa sé sòlda-a té fè. ");
INSERT INTO acfNT_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Bò kwa-a koté yo té kwisifyé Jézi-a té ni manman Jézi, sésé manman Jézi, Mari ki té madanm Klopas, èk lòt Mari-a ki té sòti Magdala-a. ");
INSERT INTO acfNT_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Disip-la Jézi té enmen-an té doubout la épi manman Jézi. Kon sa lè Jézi wè yo, i di manmanʼy, “Madanm, gason sala ki bòʼw-la vini gasonʼw dépi atjwèlman,” ");
INSERT INTO acfNT_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Èk i di disip-la i té enmen-an, “Sa sé manmanʼw.” Dépi menm tan sala disip-la mennen manman Jézi wèsté lakay li. ");
INSERT INTO acfNT_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Lè sala Jézi menm té sav i té ja fini twavay-la Bondyé té voyéʼy fè-a. Èk pou té fè sa lévanjil-la di-a vin fèt vwé, i di, “Mwen swèf.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","La té ni on bòl ki té plen diven wak, kon sa yo fouyé an tjò léponj an diven-an, yo météʼy an bout baton on pyé zèb yo ka kwiyé hisòp, èk yo lonjéʼy bò lèv li. ");
INSERT INTO acfNT_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Jézi bwè diven-an èk i di, “Twavay-la mwen té vini fè-a fini!” Lè sala i bésé tèt li èk i mò. ");
INSERT INTO acfNT_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Lè sala sé chèf Jwif-la mandé Pilat pèwmisyon pou kasé janm sé nonm-lan yo té kwisifyé-a pou yo té mò pli vit, èk pou yo té sa tiwé kò-a asou kwa-a. Yo mandé pèwmisyon sala paski i sété Vandwédi èk yo pa té vlé kò sé nonm sala wèsté asou kwa-a pou jou sabaf-la, paski sabaf sala sété on sabaf ki enpòtan. ");
INSERT INTO acfNT_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Kon sa sé sòlda-a alé èk yo kasé janm pwèmyé nonm-lan èk apwé sa yo kasé janm dézyenm-lan ki té kwisifyé bò Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mé lè yo wivé bò Jézi, yo wè i té ja mò, kon sa yo pa kasé janm li. ");
INSERT INTO acfNT_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Mé yonn an sé sòlda-a pitjé bò kòt Jézi èk on pitjèt fè. Menm lè-a san èk dlo vidé sòti. ");
INSERT INTO acfNT_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Moun-an ki té wè sa fèt-la ja di sa pou zòt sa kwè. Sa i di-a vwé, èk i sav sa i di-a sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Sa té fèt pou sa lévanjil-la di-a vin fèt vwé. Lévanjil-la di, “Yo pa kay kasé pyès zoʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","La ni an lòt koté an lévanjil-la ki di, “Moun kay gadé moun-an yo té pèsé-a.” ");
INSERT INTO acfNT_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Lè tout sa fini fèt, Jozèf ki té sòti an vil Arimatéya mandé Pilat pèwmisyon pouʼy sa pwan kò Jézi. Jozèf sété an disip Jézi, mé i pa té fè moun konnèt sa, paski i té pè sé chèf Jwif-la. Pilat ba li pèwmisyon pou pwan kò Jézi, kon sa Jozèf alé pwan kò-a. ");
INSERT INTO acfNT_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodimòs menm, ki té vini koté Jézi yon jou òswè, té alé épi Jozèf èk i mennen yon san (100) liv lanmi èk lalwé mélé ansanm pou pwépawé kò-a. ");
INSERT INTO acfNT_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Dé nonm sala pwan kò Jézi èk yo mété sé bagay sala anlèʼy èk yo vopléʼy èk had blan yo ka sèvi pou téwé mò. Sé kon sa sé Jwif-la ka pwépawé an kò pou yo téwé. ");
INSERT INTO acfNT_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","La té ni an jaden an plas-la koté yo kwisifyé Jézi-a, èk la té ni an tonm nèf an jaden-an. Pyèsonn pʼòkò té téwé andidanʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Yo mété kò Jézi andidan tonm-lan, paski i sété jou avan sabaf sé Jwif-la, épi tonm-lan té tou pwé. ");
INSERT INTO acfNT_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Pwèmyé jou an simenn-an, byen bonnè, i té ka fè ti nwè toujou, Mari Madlenn alé bò tonm-lan èk i wè yo té ja tiwé wòch-la anlè djòl twou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","I pati kouwi alé jwenn Simon Pita èk lòt disip-la, sa Jézi enmen-an, èk i di yo, “Yo ja tiwé kò Senyè-a an twou-a èk nou pa sav koté yo météʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Pita èk lòt disip-la alé bò twou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Yo toulé dé mété kouwi, mé lòt disip-la kouwi pli vit pasé Pita èk i wivé bò twou-a avan. ");
INSERT INTO acfNT_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","I bésé pou gadé an twou-a èk i wè sé twèl blan-an yo té voplé kò-a, mé i pa antwé an twou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Pita ki vini apwé, antwé dwèt andidan twou-a. I wè sé had-la yo té voplé kò Jézi-a té la ");
INSERT INTO acfNT_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","èk lòt had-la yo té mawé tèt li-a. Had-la yo té mawé tèt li-a pa té menm koté èk sé lézòt had-la, mé i té byen voplé pa kòʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Lè sala lòt disip-la ki té wivé bò twou-a avan-an, antwé an twou-a èk i wè sa té vwé. ");
INSERT INTO acfNT_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Yo pʼòkò té konpwann lè lévanjil-la té di Jézi té ni pou wésisité. ");
INSERT INTO acfNT_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lè sala dé disip-la viwé lakay yo. ");
INSERT INTO acfNT_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mari té wèsté dèwò bò djòl twou-a, ka pléwé. Paditan i té la ka pléwé, i bésé èk i gadé an twou-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","I wè dé nanj ki té abiyé an blan asid koté kò Jézi té yé-a. Yonn té asid koté pyé-a té yé-a èk yonn té asid koté tèt-la té yé-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Yo diʼy, “Madanm, pouki ou ka pléwé kon sa?” I di, “Yo ja mennen kò Senyè mwen alé èk mwen pa sav koté yo météʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Lè sala i tounen èk i wè an nonm doubout la, mé i pa té sav sété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Jézi diʼy, “Madanm, pouki ou ka pléwé kon sa? Ki moun ou ka chaché?” I té kwè sété nonm-lan ki té ka twavay an jaden-an. Kon sa i di, “Misyé, si ou tiwé kò-a èk ou mennenʼy alé, di mwen koté ou météʼy, pou mwen alé pwanʼy.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Jézi di, “Mari!” I tounen èk i di an langaj sé Jwif-la, “Rabonni!” (sa vlé di Titja). ");
INSERT INTO acfNT_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Jézi diʼy, “Pa tjenbé mwen, paski mwen pʼòkò mouté jwenn Papa-a. Mé alé koté sé fwè mwen-an épi di yo mwen ka alé jwenn Papa mwen ki sé Papa yo tou, èk Bondyé mwen ki sé Bondyé yo tou.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Kon sa Mari Madlenn pati èk i di sé disip-la i té wè Senyè-a épi i di yo tout sa i té diʼy. ");
INSERT INTO acfNT_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Byen ta jou Dimanch òswè sala, sé disip-la té ansanm, èk sé lapòt-la té laklé paski yo té pè sé chèf Jwif-la. La menm Jézi vini èk i doubout anpami yo, i di yo, “Mwen ka bay zòt lapé an tjè zòt.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Lè i fini di sa, i moutwé yo lanmenʼy èk bò kòt li. Sé disip-la té kontan an pil lè yo wè Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Jézi di yo ankò, “Mwen ka bay zòt lapé an tjè zòt. Menm kon Papa-a voyé mwen, sé menm mannyè-a mwen ka voyé zòt.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Lè i fini di sa, i souflé anlè yo èk i di yo, “Wisivwè Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Si ou pawdonnen péché moun, péché yo kay pawdonnen, mé si ou pa pawdonnen péché yo, péché yo pa pawdonnen.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Tonmas menm, yonn an sé douz disip-la yo ka kwiyé Jimo-a, pa té la lè Jézi té vini. ");
INSERT INTO acfNT_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Kon sa sé lézòt disip-la diʼy, “Nou ja wè Senyè-a!” Tonmas di yo, “Tout tan mwen pa wè mak klou-a an lanmenʼy èk fouyé dwèt mwen an twou-a bò kòt li, mwen pa kay kwè sé li.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ywit jou apwé, sé disip-la té ansanm ankò andidan kay-la, èk kou sala Tonmas té la épi yo. Sé lapòt-la té laklé, mé Jézi vini doubout anpami yo èk i di, “Mwen ka bay zòt lapé an tjè zòt.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Lè sala i di Tonmas, “Fouyé dwèt ou bò kòt mwen, èk gadé lanmen mwen. Mwen pa vléʼw ni doutans an tjèʼw ankò, mé mwen vléʼw kwè.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tonmas di, “Ou sé Senyè mwen èk Bondyé mwen!” ");
INSERT INTO acfNT_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Jézi diʼy, “Ès ou kwè paski ou wè mwen? Pa dé bon i bon pou moun-an ki pa wè-a èk i kwè.” ");
INSERT INTO acfNT_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Paditan Jézi té èk sé disip li-a, i fè an pil miwak ki pa ékwi an liv sala. ");
INSERT INTO acfNT_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Mé mwen ékwi sé bagay sala pouʼw kwè sé Jézi ki Mèsaya-a, Gason Bondyé. Lè ou mété lafwaʼw an li, ou kay ni lavi. ");
INSERT INTO acfNT_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Apwé sa, Jézi fè sé disip li-a wèʼy ankò bò lanmè Taybiriyòs-la. Mi sé kon sa i fèt. ");
INSERT INTO acfNT_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Simon Pita, Tonmas (yo ka kwiyé Jimo-a), Natannyèl ki té sòti Kéna an péyi Galili, èk sé gason Zèbèdi-a té la ansanm èk dé lézòt disip. ");
INSERT INTO acfNT_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Simon Pita di sé lézòt-la, “Mwen ka alé péché.” Sé lézòt-la di, “Nou ka alé épiʼw.” Kon sa yo pati alé an kannòt-la. Mé yo péché tout swè-a èk yo pa tjenbé anyen. ");
INSERT INTO acfNT_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Menm kon sòlèy té ka lévé, Jézi té doubout asou lans-lan, mé sé disip-la pa té sav sété Jézi. ");
INSERT INTO acfNT_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Lè sala i di yo, “Jan mwen, zòt pa tjenbé anyen?” Yo di, “Pa menm an sadin.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","I di yo, “Voyé lèpèvyé zòt asou lanmen dwèt kannòt-la èk zòt kay tjenbé tibwen pwéson.” Kon sa yo voyé lèpèvyé yo an dlo èk yo tjenbé tèlman pwéson yo pa té sa menm hédiʼy antwé andidan kannòt-la. ");
INSERT INTO acfNT_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Disip-la Jézi enmen-an di Pita, “Senyè-a ki la, wi!” Lè Pita tann sété Senyè-a, i voplé had li anlèʼy, paski i té ja tiwé had li, èk i soté djouboum an dlo. ");
INSERT INTO acfNT_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Sé lézòt disip-la vini atè an kannòt-la, èk yo té ka hédi lèpèvyé pwéson-an. Yo pa té lwen, yo té bò twa san (300) pyé hòd tè. ");
INSERT INTO acfNT_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Lè yo désann atè, yo wè la té ja ni chèbon difé ka limen èk i té ni pwéson anlèʼy èk la té ni pen tou. ");
INSERT INTO acfNT_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Jézi di yo, “Mennen déotwa pwéson an sa ou tjenbé-a vini.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simon Pita menm antwé an kannòt-la pouʼy hédi lèpèvyé pwéson-an atè. La té ni yon san senkant twa (153) pwéson an tout. Magwé la té ni otan pwéson an lèpèvyé-a, lèpèvyé-a pa déchiwé. ");
INSERT INTO acfNT_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Jézi di yo, “Vini manjé!” Yo pyès an sé disip-la pa té bwav asé pou mandéʼy, “Ki moun ou yé?” paski yo sav sété Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Kon sa Jézi alé, i pwan pen-an, i ba yoʼy, èk i pwan pwéson-an ba yo tou. ");
INSERT INTO acfNT_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Sa sété twazyenm fwa Jézi fè sé disip li-a wèʼy apwé i té wésisité. ");
INSERT INTO acfNT_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Lè yo fini manjé, Jézi di Simon Pita, “Simon gason Jan, ès ou enmen mwen pasé sé moun sala?” Pita di, “Wi Senyè, ou sav mwen enmenʼw.” Jézi diʼy, “Swen sé ti mouton mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jézi mandéʼy pou dézyenm kou-a, “Simon gason Jan, ès ou enmen mwen?” I di, “Wi Senyè, ou sav mwen enmenʼw.” Jézi diʼy, “Swen sé mouton mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jézi mandéʼy pou twazyenm kou-a, “Simon gason Jan, ès ou enmen mwen?” Sa té fè Pita lapenn paski i té mandéʼy sa pou twa kou. Kon sa i di Jézi, “Senyè, ou konnèt tout bagay, ou sav mwen enmenʼw.” Jézi diʼy, “Ében swen sé mouton mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Mwen ka diʼw lavéwité-a, lè ou té jenn, sé ou menm ki té ka mawé sanng ou pou alé népòt koté ou vlé. Mé lè ou vini gwan, ou kay lonjé lanmenʼw èk sé an lòt moun ki kay mawéʼw èk i kay mennenʼw koté ou pa vlé alé.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Lè Jézi di sa, i té ka di mannyè Pita té kay mò, èk lanmòʼy té kay lévé non Bondyé. Lè sala Jézi di Pita, “Swiv mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Lè Pita tounen dèyè, i wè disip-la Jézi té enmen-an, menm sa ki té apiyé anlè Jézi lè yo té ka manjé-a èk i té mandé Jézi kilès ki té kay twayiʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Lè Pita wèʼy, i di Jézi, “Senyè, ki sa ki kay wivé nonm sala?” ");
INSERT INTO acfNT_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Jézi diʼy, “Si mwen vléʼy viv jis tan mwen vini, sa pa ka gadéʼw. Ou menm, swiv mwen.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Kon sa pou lapéti sa i di-a, pawòl sala té ka simen anpami sé moun-an ki té ka swiv Jézi-a. Yo té ka di, “Jézi di disip sala pa kay mò,” mé Jézi pa té janmen di disip sala pa té kay mò. I té di, “Si mwen vléʼy viv pou jis tan mwen vini, sa pa ka gadéʼw.” ");
INSERT INTO acfNT_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Sé li ki disip-la ki ka di sé bagay sala. Sé li ki ékwi yo, èk nou sav sa i di-a sé lavéwité. ");
INSERT INTO acfNT_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Bon, la ni an pil lòt bagay Jézi fè. Si moun té ni pou ékwi yo tout, mwen pa kwè latè sala té kay ni lè pou tout sé liv-la yo té kay ni pou ékwi-a.");
INSERT INTO acfNT_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tjofilòs, fwè mwen, mwen té ékwi an pwèmyé liv mwen épi mwen diʼw tout sé bagay-la Jézi Kwi fè-a épi bagay i té di dépi tan i koumansé twavay li ");
INSERT INTO acfNT_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","pou jis tan Bondyé mennenʼy mouté an syèl. Avan i mouté an syèl, i enstwi sé zapòt-la, sé nonm-lan i té chwazi-a. Jézi konmandé yo èvèk pouvwa Lèspwi Bondyé ki sa pou yo fè. ");
INSERT INTO acfNT_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Pou kawant (40) jou apwé lanmòʼy i pawèt douvan yo an chay fwa épi adan mannyè pouʼy té sa moutwé yo aklè i té vivan ankò. I palé ba yo épi i di yo mannyè Bondyé ka kondwi sé moun li-an. ");
INSERT INTO acfNT_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Épi lè yo tout té asanblé ansanm, i konmandé yo, “Pa kité vil Jérouzalèm. Èspéyé kado-a mwen té ja diʼw-la, kado-a Bondyé Papa mwen té pwonmèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Jan Batis té ka batizé moun épi dlo, mé pa djè lontan ankò Bondyé kay batizéʼw épi Lèspwiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Lè sé zapòt-la té asanblé épi Jézi, yo di, “Mèt, ès atjwèlman ou kay fè nasyon Izwayèl doubout fò ankò?” ");
INSERT INTO acfNT_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Jézi di yo, “Papa mwen ki ni tout pouvwa-a ja mété dat-la épi tan-an pou sa fèt, mé sé pa pou zòt sav ki tan sa kay fèt. ");
INSERT INTO acfNT_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Mé lè Lèspwiʼy désann anlèʼw, ou kay wisivwè pouvwa épi ou kay sèvi mwen témwen douvan moun an Jérouzalèm, an tout Joudiya épi Sanmariya épi toupatou an latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Apwé i fin di yo sa, Bondyé mennenʼy mouté an syèl paditan yo té ka gadéʼy, épi on nwaj bawéʼy, épi yo pa té sa wèʼy ankò. ");
INSERT INTO acfNT_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Zyé yo té fiksé an syèl toujou koté Jézi té alé-a, lè dé nonm abiyé an blan annèk pawèt a koté yo ");
INSERT INTO acfNT_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","épi yo di yo, “Jan Galili, pouki zòt ka gadé an syèl kon sa? Menm Jézi sala Bondyé tiwé anpami zòt épi mennen mouté an syèl, menm mannyè i mouté-a, sé menm kon sa i kay viwé.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Apwé sa, sé zapòt-la désann Mòn Òliv épi yo déviwé an vil Jérouzalèm. Mòn sala té an dimi lyé hòd vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Lè yo wivé an vil-la, yo mouté an chanm-lan koté yo ka wèsté-a. La té ni Pita, Jan, Jémz épi Androu, Filip épi Tonmas, Batolonmi épi Mafyou, Jémz gason Alfiyòs, Simon, nonm-lan ki té adan gany politik-la yo té ka kwiyé Zèlòt-la, épi Jida gason Jémz. ");
INSERT INTO acfNT_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Sé zapòt-la ansanm épi sé madanm-lan, épi Mari, manman Jézi, épi sé fwè Jézi-a té ka asanblé souvan pou pwédyé ansanm. ");
INSERT INTO acfNT_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Déotwa jou apwé sa, sé moun-an ki té kwè an Jézi-a té asanblé ansanm. La té ni apipwé yon san ven (120) moun an tout. Pita doubout épi i palé, ");
INSERT INTO acfNT_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","i di yo, “Fwè mwen, sa Lèspwi Bondyé té fè David ékwi an lévanjil-la té ni pou vin fèt vwé. Lèspwi Bondyé té fèʼy ékwi konsèné sa Jida té kay fè-a. Sé li ki té mennen sé moun-an ay awété Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Jida sété yonn anpami nou paski Jézi té chwaziʼy pouʼy té ni yon pa an twavay-la nou ka fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Lajan-an Jida té wisivwè pou mové bagay sala i té fè-a, i té achté on tjò tè, épi asou menm tè sala i mò. I tonbé atè épi bann boudenʼy pété sòti dèwò. ");
INSERT INTO acfNT_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Tout jan Jérouzalèm vin konnèt sa épi yo té kwiyé tè-a i achté-a an langaj yo, Akèldanma, sa vlé di Savann San-an. ");
INSERT INTO acfNT_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Pita di, “Mi sa ki ékwi an Samz-la: ‘Kité kay li wèsté vid. Pyèsonn pa pou wèsté andidanʼy.’ I ékwi ankò: ‘An lòt moun ni pou pwan plas li pou fè twavay-la.’ ");
INSERT INTO acfNT_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“Sé pou sa nou bizwen an lòt moun anpami nou pou pwan plas Jida pou di moun i wè Jézi apwé i té wésisité. Nonm sala sipozé sé yonn ki té anpami nou pou tout sé tan-an Senyè Jézi té ka alé toupatou épi nou ");
INSERT INTO acfNT_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","dépi tan-an Jan Batis té ka pwéché pou moun wisivwè batenm-lan pou jis tan Jézi kité nou pou mouté an syèl.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Kon sa yo chwazi non dé nonm, Jozèf yo té ka kwiyé Basabas, ki té ni an ti soudnon Jòstòs, épi Matayas. ");
INSERT INTO acfNT_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Lè sala yo pwédyé, yo di, “Senyè, ou konnèt tjè tout nonm. Kon sa moutwé nou kilès ou ja chwazi an dé-a ");
INSERT INTO acfNT_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","pou fè twavay on zapòt an plas Jida ki té alé an plas-la koté i té méwité alé-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Lè yo fouyé lanmen yo an sak-la, yo pwan non Matayas épi yo météʼy ansanm èk sé wonz zapòt Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Lè jou Fèt Pentikòs-la té wivé, tout sé moun-an ki té kwè an Jézi-a té asanblé adan on sèl koté. ");
INSERT INTO acfNT_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Yo annèk tann on gwo son sòti an syèl ki té menm kon son an gwo van, épi son-an plen tout kay-la koté yo té asid-la. ");
INSERT INTO acfNT_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Lè sala yo wè ti flanm difé ki té ka sanm lanng, yo sépawé épi yonn pozé asou chak moun. ");
INSERT INTO acfNT_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Épi yo tout té anba kondwit Lèspwi Bondyé épi yo koumansé palé adan diféwan langaj menm kon Lèspwi Bondyé té fè yo palé. ");
INSERT INTO acfNT_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","La té ni Jwif ka wèsté an vil Jérouzalèm ki té nonm wilizyèz ki sòti an tout nasyon an latè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Épi lè yo tann dézòd sala, an latilyé moun asanblé. Yo té sipwi an chay paski yo té tann sé moun-an ki kwè an Jézi-a ka palé an langaj péyi yo chak. ");
INSERT INTO acfNT_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Yo té tèlman sipwi yo di, “É, é! Tout sé nonm sala ki ka palé la-a sé pa jan Galili? ");
INSERT INTO acfNT_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ki mannyè nou ka tann yo ka palé an langaj manman nou? ");
INSERT INTO acfNT_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Nou sé jan Pafya, Médiya épi Ilanm. Nou sòti Mèsopotémiya, Joudiya épi Kapadosiya. Nou sòti Pontòs épi Écha, ");
INSERT INTO acfNT_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Frigiya épi Panfiliya. Nou sòti Éjip épi an sé pawès Libya-a ki tou pwé vil Sayrini-an. Adan nou sòti Ronm. ");
INSERT INTO acfNT_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Anpami nou ni Jwif épi sa ki pa Jwif mé ki ja aksèpté wilizyon Jwif-la, épi adan nou sòti Krit épi Arébiya. Ki mannyè nou ka tann yo ka di an langaj nou menm tout sé bon bagay-la Bondyé ja fè-a?” ");
INSERT INTO acfNT_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Yo té sipwi tèlman yo pa té sav ki sa pou yo té kwè. Yonn mandé lòt, “Ki sa sa vlé di?” ");
INSERT INTO acfNT_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Mé lézòt ki té la pwan yo sèvi widitjil, yo di, “Sé nonm sala ja bwè twòp diven, yo sou!” ");
INSERT INTO acfNT_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Lè sala Pita doubout épi lézòt wonz zapòt-la épi i palé byen fò pou tout sé moun-an tann. I di yo, “Zòt ki Jwif épi tout lézòt moun ki ka wèsté an Jérouzalèm, kouté byen épi mwen kay diʼw sa sé bagay sala vlé di. ");
INSERT INTO acfNT_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Sé moun sala pa sou kon ou ka kwè, paski sé névè bonmaten i yé. ");
INSERT INTO acfNT_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Bondyé té ja palé bay pwòfèt Jowèl konsèné sa. I di: ");
INSERT INTO acfNT_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Mi sa mwen kay fè an dènyé tan-an: Mwen kay voyé Lèspwi mwen asou tout lézòm. Fiʼw épi gasonʼw kay palé pawòl mwen, épi sé jenn nonm ou-an kay wè vizyon, épi sé gwan nonm ou-an kay wévé wèv. ");
INSERT INTO acfNT_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","An sé jou sala mwen kay voyé Lèspwi mwen asou sèvant mwen, nonm kon fanm, épi yo kay palé pawòl mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Mwen kay fè tout kalité miwak, ni an syèl-la ni asou latè-a. La kay ni san, difé épi gwo lafimen épé. ");
INSERT INTO acfNT_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Sòlèy-la kay vini menm kon nwèsè, épi lalin-an kay vini wouj menm kon san, avan gwan épi bèl jou-a lè Senyè-a kay witounen. ");
INSERT INTO acfNT_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Lè sala Bondyé kay sové népòt moun ki kay kwiyé asouʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Jan Izwayèl, kouté byen sa mwen ka di zòt la-a! Zòt konnèt byen sé Bondyé menm ki té voyé Jézi nonm Nazawèt-la paski zòt ja wè sé miwak-la épi sé gwan twavay-la Bondyé té ba li pouvwa pouʼy fè-a. Zòt konnèt sa byen paski sé isi-a menm anpami zòt i fèʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","I té ja an plan Bondyé épi i té ja konnèt an davans yo té kay ladjé Jézi anba lanmen zòt, épi zòt té tjwéʼy lè zòt ladjéʼy bay mové nonm pou kwisifyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Mé Bondyé fèʼy wésisité épi i délivwéʼy hòd lanmò-a, paski i té enposib pou pouvwa lanmò té tjenbéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Lè Wa David té ka palé asou Jézi, i di: ‘Mwen té ka wè Bondyé Senyè-a douvan mwen tout lè. I toujou pwé mwen, kon sa anyen pa kay sa twakasé mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Sé pou sa tjè mwen kontan, épi lè mwen ka palé, mwen ka palé épi lajwa, épi mwen menm, menm si mwen sé san èk lachè, mwen ka èspéyé èk konfyans an sa Bondyé kay fè ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Ou pa kay kité lam mwen koté sé mò-a yé-a, épi ou pa kay kité kò sèvant-lan ki ka viv baʼw tousèl-la pouwi an twou-a. ");
INSERT INTO acfNT_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Ou ja moutwé mwen chimen-an ki ka ban mwen lavi-a, épi mwen kay ni tjè kontan, paski ou toujou la épi mwen.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Pita kontiné ka palé, i di, “Fwè mwen, kité mwen fèʼw konpwann sa byen asou Wa David, gwan gwanpapa lontan nou. I mò épi fòs-la koté yo téwéʼy-la isi-a jis jòdi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","I sété an pwòfèt épi i té sav sa Bondyé té ja pwonmèt li. Bondyé fè sèman épi i di, ‘Menm kon ou sé an wa, mwen kay fè yonn an sé désandanʼw-lan vini an wa tou.’ ");
INSERT INTO acfNT_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","David té wè sa Bondyé té kay fè an tan ki kay vini épi i té palé asou wézèwèksyon Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a, lè i té di: ‘Bondyé pa té kitéʼy koté sé mò-a yé-a, épi i pa té kité kòʼy pouwi an twou-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Bondyé ja wésisité menm Jézi sala épi nou tout sé témwen sa. ");
INSERT INTO acfNT_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Bondyé, Papaʼy, onnowéʼy lè i météʼy asid asou lanmen dwèt li épi i ba li Lèspwi Bondyé, menm kon i té ja pwonmèt. Kon sa sa ou ka wè-a épi ka tann apwézan-an sé kadoʼy i voyé anlè nou. ");
INSERT INTO acfNT_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Épi sé pa David ki té mouté an syèl. David menm ki di: ‘Bondyé Senyè-a té di Senyè mwen-an: Asid asou lanmen dwèt mwen ");
INSERT INTO acfNT_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","jis tan mwen fè tout lèlmiʼw vini anba dé pyéʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Kon sa zòt tout jan Izwayèl ni pou konnèt pou vwé, menm Jézi sala zòt kwisifyé-a, sé li menm Bondyé fè vini Senyè-a épi sé li menm ki wa-a Bondyé té pwonmèt pou voyé-a!” ");
INSERT INTO acfNT_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Lè sé moun-an tann sa, sa té fè yo lapenn an chay. Yo di Pita épi sé lézòt zapòt-la, “Fwè, ki sa pou nou fè?” ");
INSERT INTO acfNT_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pita di yo, “Zòt chak ni pou tounen hòd péché zòt èk vin jwenn Bondyé, épi nou kay batizéʼw pou moutwé ou kwè an Jézi Kwi, pou Bondyé sa pawdonnen péchéʼw, épi ou kay wisivwè Lèspwi Bondyé, kado Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Paski pwonmèt sala Bondyé té fè-a sé pou ou épi pou ich ou épi pou lòt moun ki lwen, pou tout sa Bondyé Senyè-a kay kwiyé pou vin jwenn li.” ");
INSERT INTO acfNT_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Èk Pita plédé épi yo èk an chay lòt pawòl. I di yo, “Chapé kòʼw anba pinisyon-an ki ni pou vini asou sé mové moun sala.” ");
INSERT INTO acfNT_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","An chay moun kwè sa i té di yo-a épi yo té batizé. Menm jou sala apipwé twa mil (3,000) moun vini an gany sé moun-an ki kwè an Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yo té kontan an pil pou sé zapòt-la té enstwi yo. Yo té toujou ka asanblé ansanm, manjé ansanm, épi pwédyé ansanm. ");
INSERT INTO acfNT_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Bondyé kontiné ka bay sé zapòt-la pouvwa pou fè an chay miwak épi gwan twavay épi tout moun wèsté bouch gwan ouvè. ");
INSERT INTO acfNT_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Sé moun-an ki té kwè an Jézi Kwi-a té ka viv byen yonn épi lòt épi yo sépawé sa yo té ni anpami yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Yo vann tè yo épi pozèsyon yo épi yo sépawé lajan-an ant yonn a lòt kon chak té bizwen. ");
INSERT INTO acfNT_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Toulé jou yo asanblé ansanm an Kay Bondyé-a an Jérouzalèm épi yo manjé lakay yonn a lòt. Yo manjé ansanm èk kontantman épi bon tjè, épi yo wimèsyé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Yo di, “Bondyé bon an chay!” Épi tout moun té kontan yo. Toulé jou Senyè-a té ka sové moun anba péché yo, épi gany sé moun-an ki kwè an Jézi-a gwandi. ");
INSERT INTO acfNT_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Yon jou Pita èk Jan té ka mouté ay an Kay Bondyé-a an Jérouzalèm bò twazè apwémidi, sa sé lè-a sé moun-an té ka alé pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","La té ni an nonm ki té enfim an dé pyéʼy dépi lè i té fèt. Déotwa moun té ka pòtéʼy bò bayè Kay Bondyé-a yo té ka kwiyé Bèl Bayè-a. Toulé jou yo té ka météʼy la pouʼy té sa mandé sé moun-an ki té ka antwé an Kay Bondyé-a lachawité. ");
INSERT INTO acfNT_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Lè i wè Pita épi Jan ka antwé an Kay Bondyé-a, i mandé yo kéchòy. ");
INSERT INTO acfNT_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pita épi Jan fiksé zyé yo anlèʼy, èk Pita diʼy, “Gadé nou!” ");
INSERT INTO acfNT_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Nonm-lan gadé yo, i kwè yo té kay ba li kéchòy, ");
INSERT INTO acfNT_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","mé Pita diʼy, “Mwen pa ni pyès lajan, mé mwen kay baʼw sa mwen ni. An non Jézi Kwi nonm Nazawèt-la, lévé maché!” ");
INSERT INTO acfNT_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Pita tjenbé lanmen dwèt li épi i fèʼy doubout, épi menm lè-a kouway vini an janm li épi an pyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","I soté doubout asou dé pyéʼy épi i koumansé maché. Èk i antwé an Kay Bondyé-a ansanm èk Pita èk Jan, épi i té ka maché épi soté anlè épi i té ka di, “Pa dé bon Bondyé bon!” ");
INSERT INTO acfNT_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Tout sé moun-an wè i té ka maché èk i té ka onnowé Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Lè yo wè sété menm nonm enfim-lan ki té dèwò bayè-a ka mandé pou lajan-an, yo té tèlman sipwi yo sézi pou sa ki té wivéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Nonm-lan pa kité Pita èk Jan fè yon pa san li. Sé moun-an wèsté bouch gwan ouvè épi yo tout kouwi alé ay jwenn yo an plas-la yo té ka kwiyé Balkon Sòlomonn-an. ");
INSERT INTO acfNT_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Lè Pita wè sé moun-an, i di yo, “Jan Izwayèl, pouki zòt tèlman sipwi épi zòt ka gadé nou kon sa? Sé pa èk pouvwa nou menm ében paski nou tèlman bon ki fè nonm sala maché! ");
INSERT INTO acfNT_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Mé sé pouvwa Bondyé ki fèʼy maché. Bondyé Abrahanm, Ayzak épi Jakòb-la, Bondyé-a gwan gwanpapa lontan nou té ka adowé-a ja onnowé Jézi, sèvant li. Mé zòt ladjéʼy an lanmen sé chèf Jwif-la. Zòt widjèktéʼy douvan Pilat lè Pilat té vlé ladjéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","I té dwèt épi i sèvi Bondyé tousèl, mé zòt widjèktéʼy épi zòt mandé Pilat pou ladjé on kwiminèl pito Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Kon sa zòt tjwé moun-an ki té pou bay zòt lavi étonnèl-la, mé Bondyé wésisitéʼy, épi nou sé témwen sa. ");
INSERT INTO acfNT_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Sé pouvwa-a ki an non Jézi Kwi-a ki bay nonm enfim sala kouway. Sa fèt paski nou ni lafwa an Jézi. Zòt ka wè nonm sala èk zòt konnèt li. I té djéwi nèt paski nou té ni lafwa an Jézi kon zòt tout ka wè. ");
INSERT INTO acfNT_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Mwen ka di zòt, fwè mwen, mwen sav zòt épi chèf zòt pa té konpwann ki sa zòt té ka fè-a lè zòt té fè yo kwisifyé Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Dépi lontan Bondyé té ja fè sé pwòfèt li-a palé konsèné Mèsaya-a, wa-a i té pwonmèt pou voyé-a. Yo té di i ni pou soufè. Épi sa i té di-a vin fèt vwé. ");
INSERT INTO acfNT_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Kon sa tounen hòd péchéʼw épi vin jwenn Bondyé, épi i kay éfasi péchéʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Si ou fè sa, Bondyé kay wéfwéchi lèspwiʼw épi i kay voyé Jézi Mèsaya-a i ja chwazi-a baʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Jézi ni pou wèsté an syèl-la pou jis tan Bondyé fè tout bagay viwé nèf kon i té ja di an bouch sé pwòfèt li-a an tan lontan. ");
INSERT INTO acfNT_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Sé Moziz ki té di, ‘Bondyé kay voyé an pwòfèt menm kon i voyé mwen, épi i kay sòti an nasyon zòt menm, épi ou kay ni pou fè sa i di. ");
INSERT INTO acfNT_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Népòt moun ki pa obéyi pwòfèt sala, yo kay ni pou tiwéʼy anpami sé moun Bondyé-a épi tjwéʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Tout lézòt pwòfèt Bondyé ki té palé dépi tan Sanmyèl épi tout sa ki té vini apwéʼy, yo tout té di sa ki té kay wivé Jézi an tan sala. ");
INSERT INTO acfNT_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Sé pwonmèt-la Bondyé té fè pa sé pwòfèt li-a sété baʼw, épi ou ni on pa adan agwéman-an Bondyé té fè épi sé gwan gwanpapa lontanʼw-lan. Kon i té di Abrahanm, ‘Mwen kay fè désandanʼw benni tout moun ki an latè-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Kon sa Bondyé chwazi Jézi kon sèvant li, épi i voyéʼy bay zòt sé Jwif-la pwèmyé pouʼy té sa benni zòt épi pouʼy té sa fè zòt tout kité vyé chimen-an zòt té pwan-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Pita épi Jan té ka palé bay sé moun-an toujou lè déotwa pwèt épi Sadisyen épi ofisyé-a ki té wèskonsab sé gad Kay Bondyé-a wivé. ");
INSERT INTO acfNT_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Yo té faché an chay paski dé zapòt-la té ka di sé moun-an Jézi té wésisité. Sa té ka moutwé ki sé mò-a kay wésisité. ");
INSERT INTO acfNT_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Kon sa yo awété yo épi yo mété yo an pwizon pou jis denmen, paski sòlèy té ja kouché. ");
INSERT INTO acfNT_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Mé an pil sé moun-an ki té tann konmisyon-an té kwè, épi apwézan la té vin ni apipwé senk mil (5,000) moun ki té kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","An li denmen sé chèf pwèt-la, sé titja lwa sé Jwif-la épi sé ofisyé Jwif-la, yo tout asanblé ansanm an vil Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Yo konsilté épi Annas, pli ho chèf pwèt-la. Épi yo konsilté épi Kayafas, Jan épi Alèkzanda épi lézòt an fanmi pli ho chèf pwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Yo konmandé pou mennen sé zapòt-la douvan yo épi yo koumansé kwèsyonnen yo. Yo mandé yo, “Ki mannyè zòt fè nonm sala maché? Ki moun ki bay zòt pouvwa-a pou zòt fè sa?” ");
INSERT INTO acfNT_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Lè sala Pita, ki té anba kondwit Lèspwi Bondyé, wéponn épi i di, “Ofisyé épi chèf sé Jwif-la, ");
INSERT INTO acfNT_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","jòdi-a ou ka kwèsyonnen nou asou ki mannyè nou fè bon bagay sala bay nonm enfim-lan, épi ki mannyè i fè ka maché. ");
INSERT INTO acfNT_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Ében ou ni pou sav, épi tout jan Izwayèl ni pou sav, nonm sala doubout douvanʼw jòdi-a paski i té jwenn djéwizonʼy pa pouvwa-a ki an non Jézi Kwi nonm Nazawèt-la, nonm-lan ou kwisifyé-a, mé Bondyé wésisitéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Sété konsèné Jézi lévanjil-la té ka palé lè i té di: ‘Menm wòch-la zòt widjèkté-a lè zòt té ka bati kay-la, sé li menm ki tounen wòch-la ki tjenbé kay-la.’ ");
INSERT INTO acfNT_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Sé li yonn ki sa sové moun. Bondyé pa bay non pyès lòt moun an latè-a ki sa sové nou.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Sé manm konsèy sé Jwif-la té sipwi lè yo wè mizi fouben Pita épi Jan té fouben, épi pou sav yo sété nonm òdinè ki pa té ni pyès endikasyon. Yo wéyalizé sé nonm sala té ka maché épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mé yo pa té sa ouvè bouch yo, paski nonm-lan Pita épi Jan té djéwi-a té doubout la épi yo. ");
INSERT INTO acfNT_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Kon sa yo fè yo kité chanm konsèy sé Jwif-la épi yo konsilté anpami kò yo. ");
INSERT INTO acfNT_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Yo di, “Ki sa nou kay fè épi sé nonm sala? Tout moun ki an Jérouzalèm konnèt gwan miwak sala yo fè-a épi nou pa sa inyowé sa. ");
INSERT INTO acfNT_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Mé pou anpéché sa simen pli anpami sé moun-an, nou kay vèti yo épi nou kay di yo pa kité nou tann yo sèvi non Jézi ankò pyès.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Kon sa yo viwé kwiyé Pita épi Jan épi yo di yo, “Nou pa vlé zòt palé bay pyèsonn ében enstwi pyèsonn an non Jézi.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Pita wéponn yo épi i di yo, “Jijé dwèt douvan Bondyé anpami zòt menm kilès pou nou obéyi, zòt ében Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","paski nou pa sa doubout palé sé bagay sala nou wè èk tann-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Kon sa sé manm konsèy sé Jwif-la vèti yo pli wèd ankò épi yo fè yo alé. Yo wè i té enposib pou pini yo, paski tout moun ki té an Jérouzalèm té ka glowifyé Bondyé pou sa ki té fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Nonm-lan ki té djéwi pa miwak sala té ja anho kawant (40) lanné. ");
INSERT INTO acfNT_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Lè yo ladjé Pita èk Jan, yo viwé anpami gany yo épi yo di yo ki sa sé chèf pwèt-la épi sé ofisyé Jwif-la té di yo. ");
INSERT INTO acfNT_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Lè sé moun-an tann sa, yo tout mété tjè yo ansanm épi yo koumansé pwédyé. Yo di, “Bondyé, ou sé Mèt, sé ou ki fè syèl-la, latè-a, lanmè-a épi tout sa ki andidan yo. ");
INSERT INTO acfNT_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","David, gwan gwanpapa lontan nou, sété sèvant ou. Mi sé pawòl-la Lèspwi Bondyé té fèʼy ékwi, i di: ‘Pouki sé nasyon latè-a ka fè plan pou yo lévé kont Bondyé? Pouki sé moun-an ka fè konplo ki pa kay vo anyen? ");
INSERT INTO acfNT_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Sé wa latè-a té pwépawé pou batay épi yo té fè plan kont Bondyé épi Mèsaya-a i té ja chwazi-a.’ Sé sa David té ékwi.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Sé moun-an kontiné ka pwédyé, yo di, “Sé kon sa Wa Hèròd épi Pons Pilat asanblé an vil sala épi sé jan Izwayèl-la épi sé moun-an ki pa Jwif-la pou yo fè plan kont Jézi, sèvant ou ki té viv baʼw yonn. Sé li ou chwazi pou Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a! ");
INSERT INTO acfNT_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Yo asanblé ansanm pou fè tout sé bagay-la ou té ja di an davans té kay fèt-la, paski sé kon sa ou té vléʼy fèt pa pouvwaʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Apwézan Senyè, gadé mannyè yo ja di yo kay fè nou soufè. Kon sa kité nou ki sèvant ou palé konmisyonʼw san lapè. ");
INSERT INTO acfNT_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Lonjé lanmenʼw pouʼw sa djéwi moun épi pou nou sa fè an chay gwan twavay èk miwak an non Jézi, sèvant ou ki té viv ba ou-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Lè yo fini pwédyé, plas-la koté yo té yé-a soukwé, épi yo tout té anba kondwit Lèspwi Bondyé, épi yo koumansé palé konmisyon Bondyé san lapè. ");
INSERT INTO acfNT_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Tout sé moun-an ki té kwè an Jézi-a té ni on sèl tjè épi yon sèl lidé. Yo pyès pa di, “Sa mwen ni sé sa mwen yonn,” mé yo sépawé tout sa yo té ni anpami yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Sété épi an chay pouvwa sé zapòt-la fè sé moun-an konpwann aklè sété Bondyé ki fè Jézi wésisité, épi Bondyé voyé lagwas li asou yo tout. ");
INSERT INTO acfNT_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","La pa té ni pyèsonn anpami yo ki té bizwen anyen. Sa ki té ni tè ében kay té ka vann li épi yo té ka mennen lajan-an vini, ");
INSERT INTO acfNT_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","yo té ka bay sé zapòt-laʼy, épi sé zapòt-la té ka sépawéʼy bay moun ki bizwen. ");
INSERT INTO acfNT_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","La té ni yonn yo té ka kwiyé Jozèf, on nonm an bwanch lafanmi Livay ki té fèt Saypròs. Sé zapòt-la té ka kwiyéʼy Bannabas (sa vlé di Yonn ki ka Ankouwajé). ");
INSERT INTO acfNT_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","I vann an tjò tè i té ni épi i mennen lajan-an bay sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Menm mannyè-a la té ni on nonm yo té ka kwiyé Annannayas, épi madanm li sété Safayra. Annannayas vann an tjò tè ki té sa yo, ");
INSERT INTO acfNT_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","mé li épi madanm li té dakò an sigwé pou yo té tjenbé adan lajan-an pou kò yo. Annannayas mennen lèstan lajan-an bay sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Lè sala Pita diʼy, “Annannayas, pouki ou kité Satan antwé andidan tjèʼw? Ou manti bay Lèspwi Bondyé. Ou vann tè-a èk ou pwan adan lajan-an pou kòʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Avan ou té vann tè-a, i té sa ou, épi apwé ou vann li, lajan-an sété sa ou pouʼw té fè sa ou té vlé. Kon sa pouki ou désidé pou fè mové bagay sala? Sé pa bay nonm ou manti, mé sé bay Bondyé menm.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Kon Annannayas tann sa, i tonbé épi i mò fwèt. Épi tout moun ki tann sa ki fèt-la té pè an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sé jenn nonm-lan antwé, yo voplé kò-a épi yo pòtéʼy ay téwé. ");
INSERT INTO acfNT_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Lè i té ni apipwé twa nèditan apwé sa, madanm Annannayas vini, mé i pa té sav ki sa ki té fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pita mandéʼy, “Ès sé pou tan lajan ou épi mawiʼw vann tè-a?” I di, “Wi, sé pou sa nou vann li.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Lè sala Pita diʼy, “Pouki zòt toulé dé désidé pou zòt manti bay Lèspwi Bondyé kon sa? Sé moun-an ki mennen mawiʼw ay téwé-a an lapòt-la ka viwé, épi yo kay mennenʼw alé ay téwé menm kon mawiʼw.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Menm lè-a, i tonbé an pyé Pita épi i mò. Lè sé jenn nonm-lan antwé, yo wèʼy mò atè-a, yo pòtéʼy ay téwé bò mawiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Gany sé moun-an ki kwè an Jézi Kwi-a épi tout lézòt moun ki té tann sa ki fèt-la té pè an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Sé zapòt-la té ka fè an chay gwan twavay épi miwak anpami sé moun-an. Épi tout sé moun-an ki té kwè an Jézi-a té asanblé ansanm an balkon-an yo té ka kwiyé Balkon Sòlomonn-an. ");
INSERT INTO acfNT_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Sé moun-an ki pa té kwè an Jézi-a té pè mélé anpami yo, magwé moun té ka di ki mizi bon sé moun-an ki kwè an Jézi-a té bon. ");
INSERT INTO acfNT_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Mé pli an plis moun té ka vini an gany sé moun-an ki kwè an Jézi-a jis tan la té ni an chay nonm épi madanm ki té vin kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Pou lapéti tout sé miwak-la sé zapòt-la té ka fè-a moun té ka pòté moun malad yo an lawi-a, yo té ka mété yo asou kabann épi matla pou lè Pita té kay pasé, pou menm lonbwaj li té kay pasé anlè adan yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Épi moun sòti an sé vilaj-la ki té oliwon Jérouzalèm-lan. Yo pòté moun ki té malad épi sa ki té ni vyé lèspwi andidan yo, épi yo tout té jwenn djéwizon yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Lè sala pli ho chèf pwèt-la épi sé moun-an ki té ka swiv li-a ki sété manm patizan sé Sadisyen-an vini jalou sé zapòt-la an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Yo fè awété sé zapòt-la épi fèmé yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mé jou òswè sala on nanj Bondyé ouvè lapòt lajòl-la épi i fè yo sòti épi i di yo, ");
INSERT INTO acfNT_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Alé, doubout an Kay Bondyé-a épi di sé moun-an mannyè nèf-la Bondyé vlé yo viv-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Sé zapòt-la obéyi nanj-lan épi kon sa jou ouvè yo antwé an Kay Bondyé-a épi yo koumansé enstwi sé moun-an. Pli ho chèf pwèt-la épi gany li kwiyé tout sé gwan Jwif-la an konsèy épi yo tout asanblé ansanm. Yo voyé ofisyé ay pwan sé zapòt-la an pwizon-an, ");
INSERT INTO acfNT_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","mé lè yo wivé an pwizon-an, yo pa wè pyès sé zapòt-la la. Kon sa yo viwé an konsèy-la épi yo di, ");
INSERT INTO acfNT_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“Lè nou wivé an pwizon-an, nou jwenn lapòt-la byen laklé, tout sé gad-la bò lapòt-la, mé lè nou ouvè la, nou pa wè pyèsonn andidan lajòl-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Lè sé chèf pwèt-la épi ofisyé-a ki wèskonsab sé gad Kay Bondyé-a tann sa, yo té distwé épi yo mandé ki sa ki dwé wivé sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Épi paditan yo la an nonm vini épi i di yo, “Mi menm sé nonm-lan zòt mété lajòl-la an Kay Bondyé-a ka enstwi sé moun-an!” ");
INSERT INTO acfNT_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Kon sa ofisyé-a pati épi sé gad li-a épi i mennen sé zapòt-la viwé, mé yo pa té fè yo anyen paski yo té pè sé moun-an voyé wòch dèyè yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Yo mennen sé zapòt-la viwé, yo fè yo doubout douvan konsèy sé Jwif-la pou pli ho chèf pwèt-la kwèsyonnen yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","I di yo, “Nou byen konmandé zòt pou pa enstwi pyèsonn sa nonm sala té ka enstwi-a. Mé gadé sa zòt fè! Zòt simen pawòl zòt an tout Jérouzalèm. Zòt fè moun kwè sé nou ki wèskonsab pou lanmò nonm sala!” ");
INSERT INTO acfNT_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pita épi sé lézòt zapòt-la wéponn, yo di, “Sé Bondyé nou ni pou obéyi, sé pa nonm. ");
INSERT INTO acfNT_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Gwan gwanpapa lontan nou té ka adowé Bondyé, épi sé menm Bondyé sala ki wésisité Jézi apwé ou té ja tjwéʼy lè ou té klouwéʼy asou kwa-a. ");
INSERT INTO acfNT_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Sé li Bondyé onnowé lè i météʼy asid asou lanmen dwèt li kon chèf épi kon sovè. I fè sa pou tout jan Izwayèl sa tounen vin jwenn Bondyé épi pou Bondyé pawdonnen péché yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Nou menm wè sé bagay sala fèt épi nou ka di moun sa. Lèspwi Bondyé ka moutwé sé bagay sala vwé èk sé li Bondyé bay tout moun ki ka obéyiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Lè sé manm konsèy-la tann sa, yo té faché tèlman yo té vlé tjwé sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Mé yonn an sé Fawizyen-an ki té la-a sété an nonm yo té ka kwiyé Ganmalyèl. I sété an titja lwa sé Jwif-la, épi tout sé moun-an té ka wèspèktéʼy. I doubout anpami sé nonm konsèy-la, épi apwé i fè yo mété sé zapòt-la dèwò, ");
INSERT INTO acfNT_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","i di yo, “Jan Izwayèl, fè antansyon sa zòt fè sé nonm sala. ");
INSERT INTO acfNT_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Déotwa tan ki pasé an nonm yo té ka kwiyé Téyoudas té vini épi i té ka di ki kantité enpòtan i té enpòtan, épi apipwé kat san (400) nonm té alé jwenn li. Mé moun tjwéʼy, épi tout sé nonm li-an té simen, épi yo pa té sa fè anyen. ");
INSERT INTO acfNT_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Apwé sa ankò, Jida an nonm Galili vini lè yo té ka wéjistwé sé moun-an, épi i té ni on latilyé moun ka swiv li, mé yo tjwéʼy menm kon pwèmyé-a, épi tout sé moun-an ki té épiʼy-la simen. ");
INSERT INTO acfNT_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kon sa mwen ka diʼw menm mannyè-a, pa fè sé nonm sala anyen! Kité yo! Si sé yo menm ki ka fè plan-an pou twavay-la yo ka fè-a, sa kay fini, ");
INSERT INTO acfNT_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","mé si sé Bondyé ki ba yo twavay sala, ou pa sa genyen a bout yo. Ou pé twouvé kòʼw ka goumen kont Bondyé menm.” Sé manm konsèy-la kouté Ganmalyèl. ");
INSERT INTO acfNT_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Yo fè sé zapòt-la antwé épi yo bat yo, épi yo di yo pa janmen enstwi sé moun-an an non Jézi ankò, épi yo ladjé yo. ");
INSERT INTO acfNT_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Lè sé zapòt-la kité konsèy-la, yo té kontan an chay paski Bondyé té konsidiwé yo vo asé pou yo té sa pwan pinisyon pou lapéti Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Épi toulé jou andidan Kay Bondyé-a épi lakay moun, yo kontiné enstwi sé moun-an épi pwéché Bon Nouvèl-la ki Jézi sé Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","An tan sala gany sé moun-an ki kwè an Jézi-a té ka vini pli gwo, épi la té ni malkonpwann ant sé Jwif-la ki ka palé langaj Grik-la épi sé Jwif péyi-a. Sé Jwif-la ki ka palé Grik-la té di ki sé moun-an ki té ka sépawé lajan manjé-a chak jou té ka néglijé sé madanm yo-a mawi yo ja mò-a. ");
INSERT INTO acfNT_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Kon sa sé douz zapòt-la kwiyé tout sé moun-an ki kwè an Jézi-a ansanm épi yo di yo, “Sa pa bon pou nou kité pwéché pawòl Bondyé épi pou nou ay sépawé lajan. ");
INSERT INTO acfNT_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Sé pou sa fwè mwen, chwazi anpami zòt menm sèt nonm ki ni bon wépitasyon épi ki anba kondwit Lèspwi Bondyé épi ki konnèt fè sa ki dwèt, épi nou kay kité wèskonsabilité sala asou kont yo. ");
INSERT INTO acfNT_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Nou menm kay bay tout antansyon nou pou lapwiyè épi pou pwéché pawòl Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Tout sé moun-an té dakò épi disizyon-an sé zapòt-la té fè-a. Kon sa yo chwazi Stivann, an nonm ki té anba kondwit Lèspwi Bondyé épi ki té ni an chay lafwa, épi Filip, Prokoròs, Nikanò, Timon, Panmennas épi Nikolas, on nonm ki sòti Antiyòk ki pa té Jwif, mé i aksèpté wilizyon Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Sé moun-an ki kwè an Jézi-a mennen sé nonm sala bay sé zapòt-la, sé zapòt-la pwédyé ba yo épi yo mété lanmen anlè yo. ");
INSERT INTO acfNT_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Épi pawòl Bondyé kontiné simen, épi gany sé moun-an ki kwè an Jézi-a an vil Jérouzalèm vini pli gwo épi pli gwo, épi an chay sé pwèt-la mété lafwa yo an Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Stivann sété yon nonm Bondyé té ja benni an pil épi i ba li pouvwa pou fè an chay miwak épi gwan twavay. ");
INSERT INTO acfNT_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Mé déotwa nonm ki té manm légliz sé Jwif-la té doubout kont Stivann. Yo té ka kwiyé yo Sé Nonm Lib-la. La té ni Jwif ki té sòti an vil Sayrini épi an vil Alèkzandriya, épi lézòt ki té sòti Silisiya épi Écha. Yo té lévé chikann épi Stivann. ");
INSERT INTO acfNT_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Mé Lèspwi Bondyé bay Stivann tèlman lasajès, lè i palé yo pa té sa wéponn. ");
INSERT INTO acfNT_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Kon sa yo péyé tibwen nonm pou yo sa di yo tann Stivann ka malpalé Moziz épi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Sé kon sa yo té fè sé moun-an, sé ofisyé Jwif-la, épi sé titja lwa sé Jwif-la faché kont Stivann. Yo alé, yo tjenbé Stivann épi yo mennenʼy douvan konsèy sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Épi yo mennen fo témwen ki di, “Nonm sala toujou ka palé kont lwa sé Jwif-la épi Kay-la ki pou Bondyé yonn-an. ");
INSERT INTO acfNT_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Nou tann i di Jézi sala ki sòti Nazawèt-la kay kwazé Kay Bondyé-a épi i kay chanjé tout sé mannyè-a Moziz té ban nou pou nou viv-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Épi tout sé moun-an ki té asid an konsèy-la fiksé zyé yo asou Stivann épi yo wè fidjiʼy vini menm kon fidji an nanj. ");
INSERT INTO acfNT_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Pli ho chèf pwèt-la mandé Stivann, “Ès sé akizasyon sala vwé?” ");
INSERT INTO acfNT_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Stivann wéponn épi i koumansé wakonté yo sa ki té fèt dépi an tan lontan. I di, “Fwè mwen èk papa mwen, kouté byen sa mwen ka di zòt-la. Avan gwan gwanpapa lontan nou Abrahanm té alé wèsté an vil Harann, Bondyé pawèt douvanʼy an tout klètéʼy an Mèsopotémiya. ");
INSERT INTO acfNT_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Épi Bondyé diʼy, ‘Kité fanmiʼw épi péyi-a koté ou ka wèsté-a épi alé wèsté an plas-la mwen kay diʼw pou alé-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","“Épi sé kon sa i kité plas-la i té ka wèsté-a épi i ay wèsté Harann. Apwé papaʼy mò, Bondyé fè Abrahanm vini an plas-la zòt ka viv apwézan-an. ");
INSERT INTO acfNT_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Épi an tan sala Bondyé pa té ba li pyès tè, pa menm an ti tjò tè, mé i té pwonmèt pou bay Abrahanm tè sala pou li épi désandanʼy. Tan-an Bondyé té pwonmèt Abrahanm sa-a, Abrahanm pʼòkò té ni pyès ich. ");
INSERT INTO acfNT_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Mi sa Bondyé té ja di Abrahanm: ‘Désandanʼw kay étwanjé adan an lòt plas ki pa sa yo, épi sé moun plas-la kay maltwété yo anba èslavay pou kat san (400) lanné. ");
INSERT INTO acfNT_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Mé mwen kay pini nasyon-an ki té fè yo twavay wèd-la, épi apwé sa mwen kay mennen sé moun mwen-an viwé an péyi sala, épi yo kay sèvi mwen isi-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Pou té siyé agwéman-an, Bondyé di Abrahanm i té kay ni pouʼy sa sikonsayz, épi sé pou sa Abrahanm sikonsayz gasonʼy Ayzak ywit jou apwé i fèt, épi Ayzak sikonsayz gasonʼy Jakòb, épi Jakòb sikonsayz toulé douz gasonʼy-lan ki té gwan gwanpapa lontan nou. ");
INSERT INTO acfNT_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Sé gason Jakòb-la vini jalou fwè yo Jozèf épi yo vann li anba èslavay an Éjip. Mé Bondyé té épi Jozèf épi i té ka édéʼy an tout twakaʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Lè Jozèf pawèt douvan Féro, wa Éjip-la, Bondyé fèʼy ni bon mannyè épi an chay lèspwi pou fè sa ki dwèt. Kon sa wa-a fèʼy gouvènè plas Éjip-la épi i météʼy wèskonsab tout kay li. ");
INSERT INTO acfNT_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Lè sala i té ni gwan lafen an plas Kénann-an épi an Éjip épi moun té ka soufè an chay. Fanmi Jakòb pa té sa jwenn pyès manjé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Mé lè Jakòb tann la té ni manjé an Éjip, i voyé sé ich li-a ki sé gwan gwanpapa lontan nou, désann Éjip pou pwèmyé fwa-a ay chaché manjé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Lè sé fwè-a vizité Éjip pou dézyenm fwa-a, Jozèf fè yo konnèt li, épi Féro vin konnèt lafanmi Jozèf. ");
INSERT INTO acfNT_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Épi Jozèf voyé konmisyon bay papaʼy Jakòb pou tout fanmi-an vini Éjip. La té ni swasant kenz (75) moun an tout. ");
INSERT INTO acfNT_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Jakòb alé Éjip, épi sé an plas sala li épi sé ich li-a mò. ");
INSERT INTO acfNT_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Yo mennen sé kò-a viwé Chèkenm épi yo téwé yo adan twou-a Abrahanm té ja achté lanmen lafanmi Hanmò-a pou an pòsyon lajan. ");
INSERT INTO acfNT_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Apwé konmen lanné té pasé, sé moun nou-an ki té Éjip-la vini an gwo popilas moun. Lè tan-an vini pou Bondyé té tjenn pwonmèt li pou Abrahanm, ");
INSERT INTO acfNT_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","an lòt wa ki pa té janmen tann anyen konsèné Jozèf koumansé kondwi Éjip ");
INSERT INTO acfNT_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","épi i té mové an chay pou sé jan Izwayèl-la. I té ka kwennen yo épi i fòsé yo mété ti manmay yo dèwò pou yo té sa mò. ");
INSERT INTO acfNT_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Sé an tan sala Moziz té fèt, yon bèl ti manmay! Épi manmanʼy otjipéʼy pou twa mwa ");
INSERT INTO acfNT_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","épi lè yo té météʼy dèwò, tifi wa-a menm pwanʼy épi i lévéʼy kon ich li menm. ");
INSERT INTO acfNT_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Sé Éjipsyen-an moutwé Moziz tout sa yo té konnèt épi i sété an majò nonm an tout sa i ka fè épi an sa i ka di. ");
INSERT INTO acfNT_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Lè Moziz té ni kawant (40) lanné, i di an lidéʼy i kay gadé ki mannyè sé moun li-an, sé jan Izwayèl-la, ka fè. ");
INSERT INTO acfNT_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","I wè yon Éjipsyen té ka bat on jan Izwayèl. Moziz ay mété bay jan Izwayèl-la épi i pwan wivanj ba li épi i tjwé Éjipsyen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Moziz kwè sé jan Izwayèl-la té kay konpwann sété li Bondyé té voyé pou délivwé yo, mé yo pa té konpwann sa pyès. ");
INSERT INTO acfNT_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","An li denmen, i wè dé jan Izwayèl ka goumen. I alé mété lapé épi i di yo, ‘Kouté, zòt sé fwè ansanm, ki mannyè zòt ka goumen kon sa?’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Sa ki té ka bat lòt-la pousé Moziz asou koté, i di, ‘Kilès ki météʼw pouʼw sa kondwi nou èk pouʼw jijé nou? ");
INSERT INTO acfNT_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ou vlé tjwé mwen menm kon ou tjwé Éjipsyen-an yè?’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Lè Moziz tann sa, i té ni pou kouwi kité Éjip. I alé wèsté Midiyann épi i fè dé gason la. ");
INSERT INTO acfNT_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Apwé kawant (40) lanné pasé, on nanj pawèt douvanʼy adan on pyé wazyé ki té ka bwilé an gwan savann sèk-la bò Mòn Saynay. ");
INSERT INTO acfNT_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moziz té sipwi an pil lè i wè sa, kon sa i alé pli pwé pouʼy gadé ki sa ki ka fèt la-a. Lè sala Senyè-a kwiyéʼy ");
INSERT INTO acfNT_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","épi i diʼy, ‘Sé mwen menm ki Bondyé sé gwan gwanpapa lontanʼw-lan, Bondyé Abrahanm, Bondyé Ayzak épi Bondyé Jakòb.’ Moziz té ka twanblé afòs i té pè, épi i pa té sa menm lévé zyéʼy pouʼy gadé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","“Senyè-a diʼy, ‘Tiwé soulyéʼw an pyéʼw, paski plas-la ou doubout-la sé an tè ki pou mwen yonn. ");
INSERT INTO acfNT_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Mwen ja wè mannyè sé moun mwen-an ka soufè an Éjip épi mwen ja tann mizi plenn yo ka plenn, kon sa mwen ja désann pou mwen ba yo libèté. Vini pou mwen voyéʼw déviwé Éjip.’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Sété Moziz menm sé jan Izwayèl-la té widjèkté. Yo mandé Moziz, ‘Kilès ki météʼw pouʼw sa kondwi nou èk pouʼw jijé nou?’ Mé sété li menm Bondyé té voyé pou té kondwi yo épi délivwé yo anba èslavay, épi nanj-lan ki té pawèt douvanʼy-lan an pyé wazyé-a té kay édéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Sété Moziz ki mennen sé jan Izwayèl-la sòti Éjip, épi i fè an chay miwak épi gwan twavay Éjip épi bò Lanmè Wouj-la épi pou kawant (40) lanné an gwan savann-an. ");
INSERT INTO acfNT_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Sété Moziz menm ki té di sé jan Izwayèl-la, ‘Bondyé kay voyé an pwòfèt menm kon mwen, épi i kay sòti anpami zòt menm.’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sété Moziz menm ki té épi sé jan Izwayèl-la lè yo té asanblé an gwan savann-an. I té la épi gwan gwanpapa lontan nou ansanm épi nanj Bondyé-a ki té palé ba li asou Mòn Saynay-la. Épi sé li Bondyé bay sé pawòl-la ki ka bay lavi-a pou té pasé désann ban nou. ");
INSERT INTO acfNT_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Mé gwan gwanpapa lontan nou wifizé obéyi Moziz. Yo pouséʼy asou koté épi yo di, ‘I té kay pli mèyè si nou té sa viwé Éjip!’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Épi yo di Éronn, ‘Fè déotwa bondyé ban nou pou sa kondwi nou, paski nou pa sav ki sa ki wivé nonm sala yo ka kwiyé Moziz-la ki té fè nou kité Éjip-la.’ ");
INSERT INTO acfNT_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Kon sa lè sala yo fè on imaj adan fòm an ti bèf épi yo fè sakwifis ba li épi yo fè fèt pou onnowé on bagay yo menm té fè. ");
INSERT INTO acfNT_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Kon sa Bondyé tounen doʼy anlè yo épi i kité yo adowé étwal ki an syèl-la. Sa dakò èk sa ki ékwi an liv sé pwòfèt-la ki di: ‘Jan Izwayèl, sé pa té ban mwen ou tjwé sé zannimo-a épi fè sakwifis pou kawant (40) lanné an gwan savann-an! Non, sé pa té ban mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Pito ou pwédyé bay Bondyé an tant li, ou pòté tant fo bondyé-a yo ka kwiyé Mòlòk-la épi ou adowé étwal fo bondyé yo ka kwiyé Réfann-an. Sété sé imaj sala zòt fè pou zòt té adowé. Kon sa pou lapéti sa, mwen kay annékòz lèlmi-an mennen zòt jis lòt bò Babilonn.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Stivann di yo kon sa, “Gwan gwanpapa lontan nou té ni tant pwézans Bondyé anpami yo an gwan savann-an, épi Moziz fè tant-lan menm kon Bondyé té diʼy, menm kon mòdèl-la Bondyé té moutwéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Apwé sa, Jòchwa mennen sé papa lontan nou-an ay goumen pou tè-a Bondyé té pwonmèt yo-a. Lè sé moun nou-an antwé an tè sala, yo mennen menm tant sala épi yo. Sé moun nou-an té wisivwè tant sala an lanmen papa yo. Tant-lan wèsté la pou jis an tan Wa David. ");
INSERT INTO acfNT_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","David té jwenn favè douvan Bondyé épi i mandé Bondyé pou kitéʼy fè on kay ba li, Bondyé-a Jakòb té ka adowé-a, ");
INSERT INTO acfNT_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","mé sété Sòlomonn, gason Wa David, ki té fè kay sala bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Mé gwan Bondyé-a ki an syèl-la pa ka wèsté adan kay nonm fè. Kon Bondyé fè pwòfèt-la ékwi, i di: ");
INSERT INTO acfNT_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Syèl sé koté mwen ka asid pou mwen kondwi, épi latè-a sé an ti ban koté mwen ka lonjé pyé mwen. Ki kalité kay ou kay fè ban mwen? Koté plas-la ou ni pou mwen wèsté-a? ");
INSERT INTO acfNT_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Ès sé pa mwen ki fè tout sé bagay sala?’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Stivann di yo kon sa, “Tèt zòt wèd tèlman! Zòt ka fè menm kon sé moun-an ki pa konnèt Bondyé-a. Zòt wifizé kouté konmisyon Bondyé. Zòt menm kon gwan gwanpapa lontan zòt, zòt wifizé obéyi Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Gwan gwanpapa lontanʼw fè tout sé pwòfèt-la soufè. Yo jis tjwé sé pwòfèt-la ki té annonsé an davans ki Sèvant Bondyé-a ki Dwèt-la kay vini. Épi atjwèlman ou twayiʼy épi ou tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Sé zòt menm ki té wisivwè lwa Bondyé an lanmen sé nanj-lan, mé zòt pa ka menm obéyi lwa sala.” ");
INSERT INTO acfNT_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Lè sé manm konsèy sé Jwif-la tann sé pawòl Stivann-an, yo kwatjé dan yo afòs faché yo té faché. ");
INSERT INTO acfNT_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Mé Stivann menm ki té anba kondwit Lèspwi Bondyé lévé zyéʼy an syèl épi i wè klèté Bondyé ki té ka kléwé kon sòlèy-la, épi i wè Jézi doubout an lonnè asou lanmen dwèt Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Stivann di, “Mi, mwen wè syèl ouvè épi Jézi Gason Lézòm-lan doubout asou lanmen dwèt Bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Lè sé manm konsèy-la tann sa, yo hélé fò pou yo pa tann pawòl li, épi yo bouché zòwèy yo épi lanmen yo. Yo tout bouwé anlèʼy ansanm épi ");
INSERT INTO acfNT_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","yo twennenʼy dèwò vil-la épi yo ba li wòch. Sé moun-an ki té ka akizéʼy-la tiwé gwo had yo èk yo kité yo an pyé an jenn nonm yo té ka kwiyé Sòl pou véyé ba yo. ");
INSERT INTO acfNT_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Paditan yo té ka ba li wòch, Stivann té ka pwédyé épi i di, “Senyè Jézi, wisivwè lèspwi mwen!” ");
INSERT INTO acfNT_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","I ajounou épi i kwiyé Bondyé épi an gwo vwa, “Pa tjenbé péché sala kont yo!” Lè i fin di sa, i mò. ");
INSERT INTO acfNT_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Épi Sòl té kontan an chay paski yo té tjwé Stivann. Dépi menm jou sala, yo koumansé pèsikité konpanni sé moun-an ki kwè an Jézi-a an vil Jérouzalèm-lan, épi yo fè yo soufè an chay. Épi tout sé moun sala simen an sé plas-la ki an Joudiya épi an Sanmariya-a. Sé douz zapòt-la tousèl ki wèsté an Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Épi déotwa nonm ki té ka adowé Bondyé téwé Stivann, épi yo té pléwé an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Mé Sòl éséyé pou fini èk sé moun-an ki kwè an Jézi-a. I té ka pasé kay an kay, i té ka twennen sé moun-an sòti dèwò, nonm kon fanm, épi i té ka mété yo lajòl. ");
INSERT INTO acfNT_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Mé sé lézòt sé moun-an ki té simen-an pasé toupatou té ka pwéché Bon Nouvèl-la konsèné Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Yonn adan yo yo té ka kwiyé Filip alé adan an vil an Sanmariya épi i ay pwéché konsèné Jézi Kwi, wa-a Bondyé té voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Lè sé moun-an tann Filip épi yo wè sé miwak-la i té ka fè-a, yo tout kouté byen sa i té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Filip tiwé vyé lèspwi andidan an chay moun, épi sé vyé lèspwi-a té ka hélé fò lè yo té ka sòti andidan yo. An chay moun ki té enfim èk moun ki té ka bwété té jwenn djéwizon yo, ");
INSERT INTO acfNT_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","épi sé pou sa jan vil sala té kontan an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","La té ni an nonm yo té ka kwiyé Simon ki té ka wèsté an vil sala. I té ka fè gadè pou an chay tan, épi sé moun-an té sipwi pou wè tout sé bagay-la i té ka fè-a. I té ka fè kòʼy pasé pou an majò nonm. ");
INSERT INTO acfNT_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Tout sé moun-an ki té an vil-la, gwo kon piti, té ka kouté Simon byen épi yo di nonm sala ni pouvwa-a yo ka kwiyé gwan pouvwa Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Yo swiv li paski pou an chay tan i té ka sipwi yo épi twavay gadèʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Mé lè sé moun-an tann Filip, yo vini kwè Bon Nouvèl-la konsèné Jézi Kwi épi mannyè Bondyé ka kondwi sé moun li-an. Épi Filip batizé yo, nonm kon fanm. ");
INSERT INTO acfNT_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon menm vin kwè an Jézi Kwi, épi apwé yo batizéʼy, i wèsté pwé Filip épi i té sipwi an chay lè i té ka wè tout sé gwan twavay-la èk miwak-la Filip té ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Lè sé zapòt-la ki Jérouzalèm-lan tann sé jan Sanmariya-a té wisivwè pawòl Bondyé, yo voyé Pita épi Jan ba yo. ");
INSERT INTO acfNT_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Lè yo wivé, yo pwédyé bay sé moun-an ki kwè an Jézi-a pou yo wisivwè Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Yo té ja batizé kon moun ki kwè an Jézi, mé Lèspwi Bondyé pʼòkò té désann anlè yo pyès. ");
INSERT INTO acfNT_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kon sa Pita épi Jan mété lanmen anlè yo, épi yo wisivwè Lèspwi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Lè Simon wè sé moun-an wisivwè Lèspwi Bondyé lè sé zapòt-la mété lanmen anlè yo, i ofè sé zapòt-la lajan ");
INSERT INTO acfNT_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","épi i di yo, “Ban mwen pouvwa sala tou, pou lè mwen mété lanmen mwen asou népòt moun pouʼy wisivwè Lèspwi Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Pita wéponn li, i di, “Ay péwi ansanm épi lajanʼw! Ou kwè ou sa achté kado Bondyé épi lajan? ");
INSERT INTO acfNT_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ou pa ni pyès lo an twavay sala nou ka fè-a, paski tjèʼw pa dwèt pyès douvan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Tounen kont movèzté sala ou ka fè-a épi pwédyé pou Bondyé sa pawdonnenʼw pou mové bagay sala ou katjilé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Mwen wè ou anvyèj an chay épi péché ja fèʼw pwizonnyéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simon di, “Souplé, pwédyé bay Bondyé ban mwen, pou pyès sé bagay-la zòt di-a pa tonbé asou mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Apwé sé zapòt-la té fin di sé moun-an tout sa yo té konnèt konsèné Jézi épi yo fini bay sé moun-an konmisyon Senyè-a, yo déviwé Jérouzalèm. An déviwan, yo pwéché Bon Nouvèl-la adan an chay vil ki té an Sanmariya. ");
INSERT INTO acfNT_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","An nanj Bondyé pawèt douvan Filip épi i diʼy, “Pwépawéʼw épi désann chimen-an ki ka sòti Jérouzalèm pou alé Gaza-a, an chimen pyèsonn pa ka sèvi ankò.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Kon sa Filip pawéʼy épi i pati. Asou chimen i jwenn on nonm ki té ni an gwo pozisyon an péyi Ifiyopiya. Sé li ki té wèskonsab tout wichès Kandas, wenn Ifiyopiya. Misyé-a té sòti adowé Bondyé an Jérouzalèm ");
INSERT INTO acfNT_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","épi i té an kawòs li ka viwé Ifiyopiya. Paditan i té ka alé, i té ka li liv pwòfèt Izaya-a. ");
INSERT INTO acfNT_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Lèspwi Bondyé palé bay Filip, i diʼy, “Alé épi maché ansanm épi kawòs-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Filip kouwi alé épi lè i wivé, i tann nonm-lan ka li an liv pwòfèt Izaya-a. I di nonm-lan, “Ès ou konpwann sa ou ka li-a?” ");
INSERT INTO acfNT_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Nonm-lan di, “Ki mannyè mwen kay fè konpwann si on moun pa di mwen ki sa i vlé di?” Épi i envité Filip antwé an kawòs-la pou asid épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Koté i té ka li an lévanjil-la sété koté-a ki di: “Menm kon on mouton yo mennen labatwa pou tjwé, épi menm kon lè yo ka koupé pwèl on ti mouton, i pa di on ti mo. ");
INSERT INTO acfNT_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Yo té paséʼy anba pyé yo épi i pa té ni pyèsonn pou wéponn tèt li. Pyèsonn pa ka lonmen non désandanʼy paski laviʼy ja bout asou latè-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Chèf-la mandé Filip, “Ki moun pwòfèt-la ka palé-a lè i di sa, i menm ében an lòt moun?” ");
INSERT INTO acfNT_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Lè sala Filip koumansé épi menm sé pawòl-la i té ka li an lévanjil-la épi i diʼy Bon Nouvèl-la konsèné Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Kon yo ka désann chimen-an, yo wè on koté ki té ni dlo. Chèf-la diʼy, “Mi dlo isi-a, ki sa ki pou anpéché mwen wisivwè batenm?”  ");
INSERT INTO acfNT_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Kon sa Filip diʼy, “Si ou kwè épi tout tjèʼw konmisyon-an mwen diʼw-la, ou sa wisivwè batenm.” Kon sa chèf-la diʼy, “Wi, mwen kwè Jézi Kwi sé Gason Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Épi i konmandé pou doubout kawòs-la, épi li épi Filip désann atè épi yo antwé an dlo-a, épi Filip batizéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Lè yo mouté sòti an dlo-a, Lèspwi Bondyé annèk pòté Filip alé, épi chèf-la pa wèʼy ankò, mé i pati asou chimenʼy épi i té kontan an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Filip twapé kòʼy an vil Azotis épi i pwéché Bon Nouvèl-la konsèné Jézi an tout sé vil-la pou jis tan i wivé an Sizariya. ");
INSERT INTO acfNT_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","An menm di tan sa té ka fèt-la, Sòl menm té ka kontiné di sé moun-an ki kwè an Jézi-a i kay tjwé yo. Épi i alé koté pli ho chèf pwèt-la ");
INSERT INTO acfNT_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","an vil Jérouzalèm. Sòl mandé pwèt-la pou sa ékwi lèt pouʼy mennen bay sé chèf-la an sé légliz sé Jwif-la an vil Danmaskòs. I té vlé yo ba li dwa pouʼy awété népòt moun i jwenn ki ka swiv Chimen Senyè-a, nonm kon fanm, pou mennenʼy viwé Jérouzalèm kon pwizonnyé. ");
INSERT INTO acfNT_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Kon Sòl alé épi i wivé tou pwé vil Danmaskòs, an gwo klèté sòti an syèl-la épi i annèk kléwé tout oliwonʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Sòl tonbé atè-a épi i tann on vwa sòti an syèl ki di, “Sòl, Sòl, pouki ou ka pèsikité mwen?” ");
INSERT INTO acfNT_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sòl wéponn, i di, “Ki moun ou yé, Mèt?” Vwa-a di, “Mwen sé Jézi, moun-an ou ka pèsikité-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Lévé apwézan épi alé an vil-la, épi an moun kay diʼw ki sa pouʼw fè.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Sé nonm-lan ki té épi Sòl-la tann vwa-a, mé yo pa té wè pyèsonn. Yo doubout la san yo di an ti mo. ");
INSERT INTO acfNT_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sòl menm lévé épi i ouvè zyéʼy mé i pa té sa wè anyen, kon sa yo tjenbé lanmenʼy épi yo mennenʼy Danmaskòs. ");
INSERT INTO acfNT_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","I wèsté twa jou pa té ka wè anyen épi i pa té ka ni bwè ni manjé. ");
INSERT INTO acfNT_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","An menm vil-la té ni on nonm ki kwè an Jézi yo té ka kwiyé Annannayas. I wè an vizyon, épi Senyè-a diʼy, “Annannayas!” I di, “Mi mwen, Senyè.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Bondyé diʼy, “Pawé kòʼw épi désann lawi-a yo ka kwiyé lawi Dwèt-la. Lè ou wivé lakay Jida, ou kay mandé pou an nonm ki sòti Tasòs yo ka kwiyé Sòl. I la ka pwédyé, ");
INSERT INTO acfNT_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","épi i ja wè an vizyon koté ou Annannayas vini épi ou mété lanmenʼw asou tèt li pouʼy sa wè klè ankò.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Mé Annannayas di, “Senyè, an chay moun ja di mwen mannyè nonm sala ja fè sé moun-an ki kwè an ou-a soufè an Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Épi i vini isi-a épi pouvwa pou awété tout moun ki ka swiv ou. Sé chèf pwèt-la menm ki ba li pouvwa sala.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Senyè-a di, “Alé, paski mwen ja chwazi Sòl pou sèvi mwen, épi i ni pou fè moun konnèt mwen, moun lòt nasyon épi wa yo, ansanm épi sé jan Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Épi mwen menm kay moutwéʼy mizi bagay i kay ni pou soufè pou lapéti mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Kon sa Annannayas alé, i antwé an kay-la épi i mété lanmen asou Sòl épi i di, “Fwè Sòl, Senyè Jézi voyé mwen. Sé li menm ki pawèt douvanʼw asou chimen-an lè ou té ka vini isi-a. I voyé mwen pouʼw sa wè klè ankò épi pouʼw vini anba kondwit Lèspwi Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Menm lè-a, bagay menm kon kway pwéson annèk tonbé sòti an zyé Sòl épi i vin wè klè ankò. I lévé ");
INSERT INTO acfNT_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","épi yo batizéʼy épi apwé i manjé, i vini fò ankò. Sòl wèsté déotwa jou an vil Danmaskòs épi sé moun-an ki kwè an Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","I alé dwèt an sé légliz sé Jwif-la épi i koumansé pwéché, ka di Jézi sé Gason Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Tout moun ki tann Sòl pwéché té sipwi an chay épi yo té ka di yonn a lòt, “Pa nonm sala menm ki té ka maltwété sé moun Jérouzalèm-lan ki kwè an Jézi-a? Pa li ki vini isi-a tout èspwé pouʼy awété yo épi mennen yo viwé bay sé chèf pwèt-la?” ");
INSERT INTO acfNT_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Mé Sòl té vin ni pli pouvwa an pwèchmanʼy, épi i fèmé bouch sé Jwif-la ki té ka wèsté an Danmaskòs-la lè i té ka moutwé yo aklè Jézi sé wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Apwé an chay jou té pasé, sé Jwif-la mété tèt yo ansanm pou fè plan ki mannyè pou yo tjwé Sòl. ");
INSERT INTO acfNT_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","La té ni on bawad ho oliwon vil-la, èk yo té ka véyé pou li an sé bayè-a ki an bawad-la. Lannwit kon lajouné yo té ka véyé pou Sòl pou yo té tjwéʼy, mé i vin konnèt sa. ");
INSERT INTO acfNT_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Yon jou òswè sé moun-an ki kwè an Jézi-a filé Sòl désann dèyè bawad-la adan on panyen. ");
INSERT INTO acfNT_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sòl alé an vil Jérouzalèm pouʼy té mété kòʼy anpami sé moun-an ki kwè an Jézi-a, mé yo pa té kwè i sété yonn an yo. Yo tout té pèʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Mé Bannabas pwanʼy épi i mennenʼy bay sé zapòt-la. I di yo ki mannyè Senyè-a té pawèt douvan Sòl asou chimen-an épi i té palé ba li, épi Bannabas di yo Sòl pa té pè pouʼy té pwéché an non Jézi bay sé moun-an ki an vil Danmaskòs-la. ");
INSERT INTO acfNT_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Épi sé kon sa Sòl wèsté épi yo, épi i pasé toupatou an Jérouzalèm ka pwéché an non Senyè-a san i té pè anyen. ");
INSERT INTO acfNT_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Épi i palé épi sé Jwif-la ki té ka palé langaj Grik-la épi i dispité épi yo, mé yo té toujou ka chaché mannyè pou tjwéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Lè sé moun-an ki kwè an Jézi-a vin konnèt sa, yo mennen Sòl alé Sizariya pou yo voyéʼy alé Tasòs. ");
INSERT INTO acfNT_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Épi sé kon sa an tout Joudiya, Galili épi Sanmariya sé gany sé moun-an ki kwè an Jézi-a té ni an bon tan lapé. Épi Lèspwi Bondyé édé yo vini pli fò épi i fè plis moun vini kwè an Jézi, épi yo té ka viv an wèspé pou Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pita té ka pasé toupatou an péyi-a. On jou i alé vizité sé moun-an ki kwè an Jézi ki té an vil Lida. ");
INSERT INTO acfNT_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Lè i wivé la, i jwenn an nonm yo té ka kwiyé Enniyas. Nonm sala té enfim épi i pa té sa lévé asou matlaʼy pou ywit lanné. ");
INSERT INTO acfNT_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pita diʼy, “Enniyas, Jézi Kwi ka djéwiʼw apwézan. Lévé épi anmasé matlaʼw,” épi menm lè-a nonm-lan lévé. ");
INSERT INTO acfNT_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Épi tout sé moun-an ki té ka wèsté an vil Lida épi an plas Charonn-an wèʼy épi yo tounen vin jwenn Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","An vil Jopa té ni an madanm yo té ka kwiyé Tabifa, ki sété an moun ki kwè an Jézi. (Nonʼy an langaj Grik-la sété Dòkas, sa vlé di an sèf.) Épi madanm sala toujou té ka fè bon bay moun épi i té ka édé maléwé. ");
INSERT INTO acfNT_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Paditan Pita té an vil Lida, Dòkas vini malad épi i mò. Yo benyen kò-a épi yo pòtéʼy mouté adan an chanm épi yo èspozéʼy la. ");
INSERT INTO acfNT_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Vil Jopa pa té lwen vil Lida, épi lè sé moun Jopa-a ki té kwè an Jézi-a apwann Pita té an vil Lida, yo voyé dé nonm pou diʼy, “Souplé, fè vit épi vini jwenn nou.” ");
INSERT INTO acfNT_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Pita pati la menm épi dé nonm-lan, épi lè i wivé, yo mennenʼy mouté an chanm-lan koté mò-a té yé-a. La té ni an chay madanm mawi yo té ja mò ki té fè won Pita. Yo té ka pléwé épi yo té ka moutwéʼy tout sé kò had-la épi sé lézòt had-la Dòkas té ja fè ba yo lè i té ka viv-la. ");
INSERT INTO acfNT_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pita fè tout sé moun-an alé dèwò épi i ajounou épi i pwédyé. I gadé mò-a épi i di, “Tabifa, lévé.” Tabifa ouvè zyéʼy épi lè i wè Pita, i asid. ");
INSERT INTO acfNT_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Pita lonjé lanmenʼy épi i édé Tabifa doubout. Pita kwiyé tout sé moun-an ki kwè an Jézi-a, ansanm épi sé madanm-lan, épi i moutwé yo Tabifa vivan. ");
INSERT INTO acfNT_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Bagay sala ki té fèt la simen toupatou Jopa, épi an chay moun vini kwè an Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pita wèsté Jopa tibwen tan lakay an nonm yo té ka kwiyé Simon ki té ka twavay tjwi. ");
INSERT INTO acfNT_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","La té ni an nonm yo té ka kwiyé Kòniliyòs an vil Sizariya. I sété an chèf sòlda an militè Ronm-lan ki té ka konmandé yon san (100) sòlda an gany Italyen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Kòniliyòs sé pa té an Jwif mé i sété an bon nonm, épi li épi tout fanmiʼy té ka swiv wilizyon sé Jwif-la. I té ka fè an chay pou édé sé Jwif-la ki té pòv-la, épi i té ka toujou pwédyé bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","On jou bò twazè apwémidi i wè an vizyon. I wè an nanj Bondyé aklè douvanʼy épi nanj-lan di, “Kòniliyòs!” ");
INSERT INTO acfNT_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Kòniliyòs fiksé zyéʼy anlè nanj-lan an lapè épi i di, “Ki sa ou vlé, misyé?” Nanj-lan wéponn épi i diʼy, “Bondyé ja tann lapwiyèʼw épi i ka chonjé sé chawité-a ou ja fè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Kon sa voyé tibwen nonm alé an vil Jopa apwézan épi yo kay mandé pou an nonm nonʼy sé Simon Pita. ");
INSERT INTO acfNT_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","I ka wèsté lakay Simon, an nonm ki ka twavay tjwi ki ka wèsté bò lanmè-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Lè i fin di sa, nanj-lan dispawèt, épi Kòniliyòs kwiyé dé sèvant li épi on gad li ki té ka swiv wilizyon sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","I di yo sa ki fèt-la épi i voyé yo alé Jopa. ");
INSERT INTO acfNT_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","An li denmen, lè yo té ka alé, épi lè i té bò midi yo té ja wivé tou pwé Jopa. A menm lè-a, Pita mouté asou tèt kay-la ay pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","I té fen épi i té vlé manjé. Paditan i té ka èspéyé pou manjé-a yo té ka pwépawé-a, i wè an vizyon. ");
INSERT INTO acfNT_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","I wè syèl-la ouvè épi i wè on bagay ki sanm on dwa ki mawé an kat bout li èk ki ka filé désann asou latè-a, ");
INSERT INTO acfNT_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","épi andidanʼy té ni tout sòt kalité zannimo kat pat, bèt ki ka twennen atè, épi tout sòt kalité jibyé. ");
INSERT INTO acfNT_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Épi on vwa di Pita, “Lévé, tjwé épi manjé.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Mé Pita di, “Non, Senyè, mwen pa kay fè sa pyès! Kon yon Jwif mwen pa janmen manjé pyès manjé Bondyé pa ban nou pèwmisyon pou manjé.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Vwa-a palé ba li ankò, i di, “Sé pa pouʼw di ou pa ka manjé kalité manjé sala, paski atjwèlman mwen Bondyé ka baʼw pèwmisyon pou manjéʼy.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Sa fèt pou twa fwa, épi dwa-a viwé mouté an syèl. ");
INSERT INTO acfNT_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Paditan Pita té ka katjilé sa vizyon-an vlé di, sé moun-an Kòniliyòs té voyé-a té ja jwenn kay Simon épi yo té doubout dèwò bayè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Yo andjélé épi yo mandé, “Ès la ni an nonm ka wèsté isi-a yo ka kwiyé Simon Pita?” ");
INSERT INTO acfNT_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Pita té ka katjilé toujou ki sa vizyon sala vlé di lè Lèspwi Bondyé palé ba li épi i diʼy, “Kouté, twa nonm la ka gadé pou ou. ");
INSERT INTO acfNT_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Lévé épi désann épi pa fè dé lidé pou alé épi yo paski sé mwen menm ki voyé yo.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Kon sa Pita désann épi i di sé nonm-lan, “Sé mwen zòt ka gadé pou. Ki sa zòt vlé?” ");
INSERT INTO acfNT_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Sé nonm-lan wéponn, “Sé Chèf Kòniliyòs ki voyé nou. I sé an bon nonm épi i ka swiv wilizyon sé Jwif-la, épi tout sé Jwif-la ka wèspèktéʼy an chay. On nanj Bondyé di Kòniliyòs pou envitéʼw lakay li pouʼy tann sa ou ni pou di.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Kon sa Pita fè yo antwé andidan kay-la épi i fè yo pasé swè-a épiʼy. An li denmen i pati épi yo, épi déotwa fwè ki sòti an vil Jopa alé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Yo wivé an vil Sizariya yon jou apwé. Kòniliyòs té la ka èspéyé yo épi lafanmiʼy épi bon janʼy i té envité. ");
INSERT INTO acfNT_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Kon Pita té ka antwé an kay-la, Kòniliyòs vin jwenn li épi i ajounou an dé pyéʼy pouʼy té adowéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Mé Pita fèʼy lévé épi i diʼy, “Doubout! Mwen sé on nonm menm kon ou!” ");
INSERT INTO acfNT_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Pita kontiné ka palé bay Kòniliyòs kon yo té ka antwé andidan-an épi i jwenn an chay moun asanblé la. ");
INSERT INTO acfNT_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pita di sé moun-an, “Ou konnèt byen wilizyon Jwif-la di nou pa sipozé mélé épi an moun ki pa Jwif ében ni mété pyé lakay li. Mé Bondyé ja moutwé mwen atjwèlman i ka ban nou pèwmisyon pou mélé ansanm èk tout kalité moun, ki i sé on Jwif, ki i sé pa on Jwif. ");
INSERT INTO acfNT_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Kon sa lè ou voyé chaché mwen, mwen vini san mwen mandé pyès kwèsyon. Kon sa mwen vlé sav pouki ou voyé gadé pou mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Kòniliyòs wéponn, i di, “Sété apipwé menm lè sala twa jou ki pasé bò twazè apwémidi, mwen té andidan kay mwen ka pwédyé. Menm lè-a, an nonm annèk pawèt douvan mwen épi had li té ka kléwé an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","I di mwen, ‘Kòniliyòs, Bondyé ja tann lapwiyèʼw épi i ka chonjé sé chawité-a ou ja fè-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Épi nanj-lan di mwen pou voyé déotwa nonm Jopa pou mandé pou Simon Pita. I ka wèsté lakay an nonm yo ka kwiyé Simon ki ka twavay tjwi épi i ka wèsté bò lanmè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Kon sa menm lè-a mwen voyé chachéʼw, épi ou té bon asé pou vini. Kon sa mi nou tout la an pwézans Bondyé ka èspéyé pou tann tout sa Bondyé ja konmandéʼw pou di nou.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Pita koumansé palé, i di, “Mwen wè pou vwé ki Bondyé pa ni pwéféwans pou pyèsonn. ");
INSERT INTO acfNT_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","I ka aksèpté népòt moun ki ka adowéʼy épi ka fè sa ki dwèt. I pa mélé ki nasyon i sòti. ");
INSERT INTO acfNT_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ou konnèt Bondyé voyé an konmisyon bay sé jan Izwayèl-la. I voyé Bon Nouvèl-la ki di sé Jézi Kwi ki mèt tout moun épi sé li ki ka ban nou lapé an tjè nou. ");
INSERT INTO acfNT_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Mi sa ki té fèt toupatou an Joudiya, koumansé an Galili apwé Jan Batis té ka pwéché pou moun vin jwenn Bondyé épi pou yo wisivwè batenm. ");
INSERT INTO acfNT_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Ou chonjé ki mannyè Bondyé té chwazi Jézi nonm Nazawèt-la, épi i fè Lèspwi Bondyé désann asouʼy épi i té ba li pouvwa. Jézi té ka pasé toupatou, i té ka fè bonté épi i té ka djéwi tout moun ki té anba kondwit Denmou, paski Bondyé té épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Nou sé témwen tout sé bagay-la Jézi fè an vil Jérouzalèm épi an lèstan péyi sé Jwif-la. Yo tjwéʼy lè yo té klouwéʼy asou kwa-a. ");
INSERT INTO acfNT_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Mé asou twazyenm jou-a Bondyé fèʼy wésisité épi i fè moun wè i vivan. ");
INSERT INTO acfNT_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Mé sé pa té tout moun ki wèʼy, sé témwen-an Bondyé té chwazi-a yonn ki wèʼy. Sé nou menm ki té manjé épi bwè épiʼy apwé i té wésisité. ");
INSERT INTO acfNT_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Épi i konmandé nou pou pwéché Bon Nouvèl-la bay sé moun-an épi pou di sé Jézi menm Bondyé ja chwazi pou jijé tout moun ki vivan épi tout moun ki mò. ");
INSERT INTO acfNT_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tout sé pwòfèt-la palé konsèné Jézi. Yo di népòt moun ki kwè an Jézi, Bondyé kay pawdonnen péchéʼy pa pouvwa-a ki an non Jézi-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Paditan Pita té ka palé toujou, Lèspwi Bondyé désann anlè sé moun-an ki té ka kouté konmisyon-an. ");
INSERT INTO acfNT_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Épi sé Jwif-la ki kwè an Jézi-a ki té sòti Jopa épi Pita-a té sipwi an chay. Yo té sipwi lè yo wè Bondyé bay sé moun-an ki pa Jwif-la kadoʼy, Lèspwi Bondyé, tou. ");
INSERT INTO acfNT_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Sé Jwif-la ki kwè an Jézi-a tann yo ka palé adan langaj ki étwanj épi yo ka glowifyé Bondyé. Lè sala Pita di, ");
INSERT INTO acfNT_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Mi, sé nonm sala ja wisivwè Lèspwi Bondyé menm kon nou menm. Ès pyèsonn sa anpéché nou batizé yo épi dlo?” ");
INSERT INTO acfNT_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Kon sa i konmandé pou batizé yo an non Jézi Kwi, épi Kòniliyòs épi sé janʼy-lan mandé Pita pou wèsté épi yo pou déotwa jou. ");
INSERT INTO acfNT_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Sé zapòt-la épi sé fwè-a ki toupatou an Joudiya té tann adan sé moun-an ki pa Jwif-la té kwè an pawòl Bondyé tou. ");
INSERT INTO acfNT_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Lè Pita mouté an vil Jérouzalèm, adan sé fwè Jwif-la koumansé kwititjéʼy. Sé fwè sala té kwè yo sipozé sikonsayz tout moun ki kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Yo di Pita, “Ou té ka wèsté lakay moun ki pa sikonsayz épi ou jis manjé épi yo!” ");
INSERT INTO acfNT_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Kon sa Pita di yo tout sa ki té fèt, i koumansé dépi an koumansman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","I di yo, “Lè mwen té an vil Jopa, paditan mwen té ka pwédyé, mwen wè an vizyon. Mwen wè an bagay ki ka sanm an gwan dwa mawé an kat bout li ka désann sòti an syèl, épi lè i wivé bò mwen, i doubout. ");
INSERT INTO acfNT_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Épi lè mwen gadé byen andidanʼy, mwen wè tout zannimo kat pat ki an latè-a, bèt ki sovay, bèt ki ka twennen asou bouden yo, épi tout sòt kalité jibyé. ");
INSERT INTO acfNT_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Épi mwen tann on vwa di mwen, ‘Pita, lévé, tjwé épi manjé!’ ");
INSERT INTO acfNT_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","“Mé mwen di, ‘Non, Senyè, mwen pa kay fè sa pyès! Kon yon Jwif mwen pa janmen manjé pyès manjé Bondyé pa ban nou pèwmisyon pou manjé.’ ");
INSERT INTO acfNT_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","“Vwa-a sòti an syèl ankò épi i di, ‘Sé pa pouʼw di ou pa ka manjé kalité manjé sala, paski atjwèlman mwen Bondyé ka baʼw pèwmisyon pou manjéʼy.’ ");
INSERT INTO acfNT_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Sa fèt pou twa fwa, épi bagay-la viwé mouté an syèl. ");
INSERT INTO acfNT_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Menm lè-a, twa nonm sòti Sizariya vini gadé pou mwen. Yo wivé bò kay-la koté mwen té ka wèsté-a. ");
INSERT INTO acfNT_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Lèspwi Bondyé di mwen alé épi yo san mwen fè dé lidé. Sis fwè sala pati épi mwen tou épi nou alé Sizariya épi nou tout antwé an kay Kòniliyòs. ");
INSERT INTO acfNT_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Épi Kòniliyòs di nou mannyè i wè on nanj doubout andidan kay li épi nanj-lan diʼy, ‘Voyé moun Jopa épi mandé pou Simon Pita. ");
INSERT INTO acfNT_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Épi i kay diʼw pawòl ki pou sovéʼw épi tout fanmiʼw.’ ");
INSERT INTO acfNT_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","“Épi lè mwen koumansé palé, Lèspwi Bondyé désann anlè yo menm kon i té désann anlè nou an koumansman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Lè sala mwen chonjé sa Senyè-a té di, i di, ‘Jan Batis té batizéʼw épi dlo, mé mwen kay batizéʼw épi Lèspwi Bondyé.’ ");
INSERT INTO acfNT_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nou wè aklè Bondyé bay sé moun sala ki pa Jwif-la menm kado-a i té ban nou lè nou té kwè an Senyè Jézi Kwi-a. Ès mwen té sa di Bondyé, ‘Non, ou pa sa fè sa?’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Lè sé moun-an ki kwè an Jézi-a tann sa Pita di-a, yo doubout kwititjéʼy épi yo tout koumansé glowifyé Bondyé. Yo di, “I bay sé moun-an ki pa Jwif-la an chans pou yo tounen hòd péché yo pou yo sa jwenn lavi étonnèl.” ");
INSERT INTO acfNT_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Sé moun-an ki kwè an Jézi-a té simen an tan pèsikasyon-an apwé lanmò Stivann. Adan yo alé an péyi Fènisiya épi Saypròs épi an vil Antiyòk. Yo té ka di Bon Nouvèl-la konsèné Jézi Kwi bay Jwif tousèl. ");
INSERT INTO acfNT_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Mé lézòt nonm ki té kwè an Jézi té sòti Saypròs épi Sayrini. Yo té alé an vil Antiyòk épi yo té ka pwéché bay sé moun-an ki pa Jwif-la tou. Yo té ka di yo Bon Nouvèl-la konsèné Senyè Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Senyè-a ba yo an pil pouvwa, épi an chay moun kwè épi yo tounen vin jwenn Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Épi lè sé moun-an ki té an légliz Jérouzalèm-lan vin konnèt sa, yo voyé Bannabas alé an vil Antiyòk. ");
INSERT INTO acfNT_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Lè i wivé la épi i wè mannyè Bondyé té ni lagwas pou sé moun-an, i té kontan an chay épi i ankouwajé sé moun-an, i di yo pou swiv Senyè-a byen épi toujou obéyiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Bannabas sété an bon nonm, i té anba kondwit Lèspwi Bondyé épi i té ni an chay lafwa. An chay moun vin kwè an Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Lè sala Bannabas kité épi i alé an vil Tasòs ay chaché pou Sòl. ");
INSERT INTO acfNT_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Lè i jwenn li, i mennenʼy viwé an vil Antiyòk, épi pou yon lanné yo asanblé épi gany sé moun-an ki kwè an Jézi-a épi yo té ka enstwi an chay moun. Épi Antiyòk sété pwèmyé koté yo kwiyé sé moun-an ki kwè an Jézi-a “Kwityen.” ");
INSERT INTO acfNT_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Épi bò menm tan sala déotwa pwòfèt sòti an vil Jérouzalèm épi yo vini an vil Antiyòk. ");
INSERT INTO acfNT_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Yonn adan yo yo té ka kwiyé Agabòs. I doubout épi Lèspwi Bondyé fèʼy di, “Touswit la kay ni an gwo lafen an tout latè-a.” (Épi sa té vin fèt vwé lè Klòdiyòs sété wa Ronm.) ");
INSERT INTO acfNT_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Sé moun Antiyòk-la ki kwè an Jézi-a di, “Nou tout kay voyé sa nou sa bay sé fwè-a ki an péyi Joudiya-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kon sa yo anmasé lajan-an épi yo bay Sòl épi Bannabas mennenʼy bay sé ofisyé-a ki ka kondwi légliz-la ki an Joudiya-a. ");
INSERT INTO acfNT_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","An tan sala Wa Hèròd koumansé pèsikité adan sé moun-an ki kwè an Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","I té fè sòldaʼy tjwé Jémz, ki sété fwè Jan, épi yon sab. ");
INSERT INTO acfNT_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Épi lè i wè sa té fè sé Jwif-la kontan, i alé épi i fè awété Pita tou. Sa té fèt an menm tan-an yo té ka fété Fèt Pen San Lèlven-an. ");
INSERT INTO acfNT_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Apwé Wa Hèròd awété Pita, i météʼy lajòl, épi i ladjéʼy lanmen sé sòlda-a. La té ni kat gany sòlda pou véyéʼy, chak gany-lan té ni kat sòlda. Épi Wa Hèròd di i kay mennenʼy douvan sé moun-an pou fè lodyans-lan apwé Fèt Délivwans-lan. ");
INSERT INTO acfNT_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kon sa yo kité Pita lajòl, mé gany sé moun-an ki kwè an Jézi-a té ka pwédyé èk tout fòs yo bay Bondyé pou li. ");
INSERT INTO acfNT_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Jou òswè-a avan Hèròd té ni pou mennenʼy lodyans, Pita té ka dòmi an mitan dé gad épi i té anchenné épi dé chenn, épi la té ni gad an bayè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","On nanj Bondyé annèk pawèt épi an klèté kléwé an lajòl-la. Épi nanj-lan touché Pita bò kòt li pouʼy fèʼy lévé épi i diʼy, “Lévé vitman!” Épi sé chenn-an annèk sòti an lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Nanj-lan di Pita, “Bouklé sanng ou épi mété soulyéʼw.” Pita fèʼy. Nanj-lan diʼy ankò, “Mété gwo had ou anlèʼw épi annou èk mwen!” ");
INSERT INTO acfNT_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pita swiv li sòti an lajòl-la, mé i pa té sav si sa nanj-lan té ka fè-a té ka fèt vwé, i kwè sété wévé i té ka wévé. ");
INSERT INTO acfNT_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Lè yo pati, yo pasé pwèmyé gad-la, yo pasé dézyenm gad-la épi lè yo wivé an bayè fè-a ki ka alé an vil-la, bayè-a ouvè pa kòʼy, épi yo pasé. Yo désann adan on lawi, épi la menm nanj-lan kité Pita. ");
INSERT INTO acfNT_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Sé lè sala Pita vin konpwann kòʼy. I di, “Sé apwézan mwen sav pou vwé Senyè-a voyé nanj li tiwé mwen anba lanmen Hèròd épi anba tout sa sé Jwif-la té pawé pou fè mwen-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Lè Pita vin konpwann sa ki té wivéʼy-la, i alé lakay Mari, manman Jan. (Jan té ni an ti non Mak.) La té an chay moun asanblé an kay-la ka pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Pita konyen lapòt douvan-an, épi an sèvant yo té ka kwiyé Roda vini gadé ki moun ki té la. ");
INSERT INTO acfNT_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Lè i pwan vwa Pita, i té kontan tèlman i pa menm ouvè lapòt-la, i kouwi viwé ay di sé moun-an Pita doubout dèwò-a. ");
INSERT INTO acfNT_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Yo di Roda, “Ou fòl!” Mé i kontiné ka di yo, “Wi, i la!” Yo diʼy, “Pitèt sé nanj li.” ");
INSERT INTO acfNT_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Paditan tout sa té ka fèt-la, Pita té kontiné ka konyen. Lè yo ouvè lapòt-la épi yo wè sé Pita, yo té sipwi toubonnman. ");
INSERT INTO acfNT_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Pita fè yo sin épi lanmenʼy pou yo pé la, épi i koumansé wakonté ki mannyè Bondyé tiwéʼy an pwizon-an. Épi i di yo, “Di Jémz épi sé lézòt sé fwè-a sa.” Épi i menm pati ay an lòt koté. ");
INSERT INTO acfNT_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Lè jou ouvè, la té ni an chay twaka anpami sé gad-la. Yonn ka mandé lòt, “Ki sa ki wivé Pita?” ");
INSERT INTO acfNT_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Hèròd konmandé yo chaché toupatou pou Pita, mé yo pa jwenn li. I kwèsyonnen sé gad-la ki té ka véyé Pita-a, épi lè i fini, i konmandé pou tjwé yo. Épi Hèròd menm kité Joudiya épi i ay pasé tibwen tan an vil Sizariya. ");
INSERT INTO acfNT_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wa Hèròd té faché an chay kont sé jan Taya épi Sidon-an, kon sa sé moun sala fè on gany pou yo alé wèʼy. Yo chaché sipò Blastòs, an chèf ofisyé an kay Hèròd, pou sa édé yo. Épi yo mandé Hèròd pouʼy fè lapé épi yo, paski sé an péyi wa-a tout manjé yo té ka sòti. ");
INSERT INTO acfNT_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Anlè jou-a Hèròd té chwazi-a, i mété tout had waʼy épi i asid anlè gwan chèz li épi i palé bay sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Sé moun-an té ka andjélé fò, “Sé pa on nonm ki ka palé la-a, sé on bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Menm lè-a, on nanj Bondyé voyé an maladi anlè Hèròd, paski i té kité sé moun-an onnowéʼy pito i té fè yo onnowé Bondyé, kon sa vè manjé Hèròd épi i mò. ");
INSERT INTO acfNT_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Pli an pli moun té ka tann pawòl Bondyé épi yo té ka kwè. ");
INSERT INTO acfNT_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Lè Bannabas épi Sòl fini fè twavay-la yo té vini fè-a, yo kité Jérouzalèm épi yo pwan Mak épi yo. ");
INSERT INTO acfNT_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Anpami gany sé moun-an ki kwè an Jézi Kwi-a an vil Antiyòk la té ni déotwa pwòfèt ki té ka pwéché Bon Nouvèl-la bay sé moun-an, épi déotwa titja. La té ni Bannabas, Siméyon (yo té ka kwiyé Ti Nwè), Louchòs (ki té sòti Sayrini), Mannayèn (ki té lévé ansanm épi Gouvènè Hèròd), épi Sòl té anpami yo tou. ");
INSERT INTO acfNT_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Paditan yo té ka fè sèvis bay Senyè-a épi yo wèsté san manjé pou yo adowé Bondyé, Lèspwi Bondyé palé ba yo épi i di yo, “Mété Sòl épi Bannabas asou koté ban mwen, pou yo fè twavay-la mwen chwazi yo pou fè-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Kon sa apwé yo pwédyé épi wèsté san manjé, yo mété lanmen anlè tèt Sòl épi Bannabas épi yo voyé yo alé. ");
INSERT INTO acfNT_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Sé kon sa Lèspwi Bondyé té ja voyé Bannabas épi Sòl alé. Yo alé an vil Sélousya épi yo pwan batiman la pou yo alé jis péyi Saypròs. ");
INSERT INTO acfNT_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Lè yo wivé an vil Salanmis, yo pwéché pawòl Bondyé an sé légliz sé Jwif-la. Yo té ni Mak épi yo pou édé yo. ");
INSERT INTO acfNT_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Yo twavèsé yon bout péyi-a pou wivé jis an lòt bout-la jis tan yo wivé an vil Pafòs. Lè yo wivé la yo jwenn épi on gadè yo té ka kwiyé Bajézi. I sété on Jwif épi on fo pwòfèt. ");
INSERT INTO acfNT_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Gadè sala sété kanmawad gouvènè Saypròs-la yo té ka kwiyé Sèjòs Palòs, an nonm ki té ni an chay lèspwi. Gouvènè-a voyé kwiyé Bannabas épi Sòl pou yo té vini paski i té vlé tann pawòl Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Mé gadè-a (nonʼy an langaj Grik-la sété Élimas) té kont yo épi i té ka éséyé anpéché gouvènè-a kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Mé Sòl, (yo té ka kwiyé Pòl), té anba kondwit Lèspwi Bondyé épi i gadé gadè-a an mitan zyé ");
INSERT INTO acfNT_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","épi i diʼy, “Ou sé ich Denmou! Ou kont tout bagay ki bon. Tjèʼw plen épi tout vyé kalité wiz épi méchansté! Ès ou pa las pwan lavéwité Senyè-a épi fè moun kwè sé on mansonj? ");
INSERT INTO acfNT_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Senyè-a kay piniʼw apwézan, épi ou kay avèg épi ou pa kay menm wè klèté sòlèy ankò pou tibwen tan!” Menm lè-a, zyé Élimas vini toub épi an nwèsè kouvè zyéʼy épi i koumansé maché toupatou ka chaché pou an moun pou tjenbé lanmenʼy pou mennenʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Lè gouvènè-a wè sa ki té fèt-la, i kwè an Senyè-a. I té sipwi toubonnman lè i té tann sé bagay-la Bannabas épi Pòl té ka diʼy konsèné Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pòl épi sé kanmawad li-a pwan batiman an vil Pafòs épi yo alé an Pèga, an vil ki té an Panfiliya, épi lè yo wivé la, Mak kité yo épi i viwé an vil Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Yo kité Pèga épi yo wivé an vil Antiyòk an péyi Pisidya. Yo antwé andidan légliz sé Jwif-la jou sabaf-la épi yo asid. ");
INSERT INTO acfNT_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Apwé moun fini li an sé liv-la Moziz épi sé pwòfèt-la té ékwi-a, sé chèf légliz-la voyé an konmisyon bay Pòl épi Bannabas. Yo di, “Fwè, nou vlé zòt palé bay sé moun-an si zòt ni on konmisyon pou ankouwajé yo.” ");
INSERT INTO acfNT_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Kon sa Pòl doubout épi i fè yo sin épi lanmenʼy èk i koumansé palé, i di, “Nonm Izwayèl, épi moun lòt nasyon ki vin adowé Bondyé, kouté mwen! ");
INSERT INTO acfNT_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Bondyé chwazi sé jan Izwayèl-la ki gwan gwanpapa lontan nou, épi i fè yo vini an gwan nasyon paditan yo té étwanjé an péyi Éjip. I tiwé yo an Éjip épi an chay pouvwa, ");
INSERT INTO acfNT_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","épi pou kawant (40) lanné i pwan pasyans épi yo an gwan savann sèk-la. ");
INSERT INTO acfNT_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","I détwi sèt nasyon an péyi Kénann épi i bay sé moun li-an péyi-a pou sa yo. ");
INSERT INTO acfNT_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Tout sa pwan apipwé kat san senkant (450) lanné. “Apwé sa, Bondyé bay sé jan Izwayèl-la jij pou kondwi yo pou jis tan pwòfèt Sanmyèl té vini. ");
INSERT INTO acfNT_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Lè sala sé moun-an mandé pou on wa, épi Bondyé ba yo Sòl, ich Kich-la ki sòti an fanmi Bennjamin. Sòl kondwi yo kon wa pou kawant (40) lanné. ");
INSERT INTO acfNT_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Épi lè Bondyé tiwéʼy, i mété David wa anlè yo. Mi sa Bondyé di konsèné David, i di, ‘David, gason Jèsi, sé yon nonm ki fè tjè mwen kontan an chay, épi i kay fè tout sa mwen kay vléʼy fè.’ ");
INSERT INTO acfNT_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Jézi sété an désandan Wa David. Bondyé fè Jézi vini sovè sé jan Izwayèl-la kon i té ja pwonmèt. ");
INSERT INTO acfNT_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Avan Jézi té koumansé twavay li, Jan Batis té ka pwéché bay tout sé jan Izwayèl-la. I té ka di yo tounen hòd péché yo épi wisivwè batenm. ");
INSERT INTO acfNT_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Lè Jan Batis té pawé pou fini twavay li, i di yo, ‘Ki moun zòt kwè mwen yé? Mwen sé pa moun-an zòt ka èspéyé-a. Mé kouté, moun sala ka vini apwé mwen. Mwen pa menm vo pou délasé soulyéʼy.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","Pòl kontiné ka palé, i di, “Fwè mwen ki désandan Abrahanm, épi ou moun lòt nasyon ki vini isi-a pou adowé Bondyé, kouté! Sé ban nou Bondyé voyé konmisyon-an konsèné mannyè i vini pou sové nou. ");
INSERT INTO acfNT_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Sé Jwif-la ki Jérouzalèm-lan épi chèf yo pa konnèt sé Jézi ki sé sovè-a. Yo pa té konpwann pawòl sé pwòfèt-la, menm pawòl-la yo ka li toulé jou sabaf-la. Mé sé yo menm ki fè pawòl sé pwòfèt-la vini vwé lè yo té kondanné Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Magwé yo pa té jwenn pyès wézon pou té kondanné Jézi, yo mandé Gouvènè Pilat pou kondannéʼy pou lanmò. ");
INSERT INTO acfNT_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Épi apwé sé Jwif-la fè tout sa lévanjil-la té ja di yo té ni pou fè Jézi, yo tiwéʼy asou kwa-a épi yo météʼy adan an twou yo té fouyé an kayè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Mé Bondyé wésisitéʼy, ");
INSERT INTO acfNT_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","épi pou plizyè jou i pawèt douvan sé moun-an ki té ja maché sòti Galili pou Jérouzalèm épiʼy. Épi apwézan yo sé témwenʼy pou sé jan Izwayèl-la. ");
INSERT INTO acfNT_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Épi nou vini isi-a pou mennen Bon Nouvèl-la baʼw. Sé sa Bondyé té pwonmèt gwan gwanpapa lontan nou. ");
INSERT INTO acfNT_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","I fè pwonmèt sala ban nou ki sé désandan yo lè i wésisité Jézi. Kon i di an dézyenm sam-lan: ‘Mwen sé Papaʼw. Jòdi-a mwen ka onnowéʼw kon Gason mwen.’ ");
INSERT INTO acfNT_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Bondyé té ja pwonmèt pouʼy wésisité Jézi pouʼy pa janmen mò ankò. Mi sa Bondyé té di asou sa: ‘Mwen kay bay zòt tout sé bon bennédiksyon-an mwen té pwonmèt pou bay David-la. Zòt sa konté asou sa.’ ");
INSERT INTO acfNT_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Kon i té di an lòt sam-lan: ‘Ou pa kay kité sèvant-lan ou chwazi-a pouwi an twou-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Lè David té ka viv, i fè tout sa Bondyé té ja météʼy la pou fè épi i mò, épi yo téwéʼy an tonm fanmiʼy, épi kòʼy pouwi. ");
INSERT INTO acfNT_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Mé moun-an Bondyé ja wésisité-a pa janmen pouwi. ");
INSERT INTO acfNT_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Fwè mwen, nou vléʼw konnèt byen Bondyé voyé Jézi pou sa pawdonnen péchéʼw, épi sé konmisyon sala nou ka pwéché baʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Jézi kay fè tout moun ki kwè an li vini dwèt douvan Bondyé. Sé lwa-a Moziz té vléʼw obéyi-a pa té sa fè sa baʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Pwan gad pou tout sé bagay-la sé pwòfèt-la té di-a pa wivéʼw. Yo té di kon sa: ");
INSERT INTO acfNT_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Gadé on, ou ki ka malpalé mwen, sézisman kay tjwéʼw! Paski bon twavay-la mwen ka fè an tan zòt-la sé an bagay ou pa kay janmen kwè, pa menm si an moun té diʼw ki sa i yé!’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Kon Pòl épi Bannabas kité légliz-la, sé moun-an envité yo viwé lòt jou sabaf-la pou di yo plis asou sé bagay sala yo té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Épi lè sé moun-an alé, an chay Jwif épi moun lòt nasyon ki té konvèti pou wilizyon Jwif-la té ka swiv Pòl épi Bannabas. Dé zapòt-la palé ba yo épi ankouwajé yo épi yo di yo kontiné viv an lagwas Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Lè lòt jou sabaf-la wivé, pwèskè tout moun ki té an vil-la vini tann pawòl Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Épi lè sé Jwif-la ki pa kwè an Jézi-a wè latilyé moun sala, yo té jalou toubonnman épi yo koumansé jiwé épi di vyé bagay kont sa Pòl té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Mé Pòl épi Bannabas palé ba yo san mété dlo an bouch yo. Yo di, “I té nésésè pou ou ki Jwif sa tann pawòl Bondyé avan lézòt, mé ou widjèkté pawòl-la épi ou pa konsidiwé kòʼw bon asé pou jwenn lavi étonnèl. Ében, atjwèlman nou kay mennen pawòl Bondyé bay sé moun-an ki pa Jwif-la ");
INSERT INTO acfNT_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","paski Bondyé konmandé nou sé Jwif-la épi sé pawòl sala, i di kon sa: ‘Mwen té fèʼw kon an klèté pou sé moun-an ki pa Jwif-la pouʼw sa moutwé tout moun mannyè Bondyé vlé chapé yo anba péché yo.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Lè sé moun-an ki pa Jwif-la tann sa, yo té kontan épi yo di, “Pa dé bon konmisyon Senyè-a bon!” Épi sé moun-an Bondyé té ja chwazi an davans-lan pou wisivwè lavi étonnèl-la vini kwè. ");
INSERT INTO acfNT_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Épi pawòl Bondyé simen toupatou an péyi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Mé sé Jwif-la fè sé gwo nonm vil-la épi sé madanm wich-la ki té an wilizyon Jwif-la lévé kont Pòl épi Bannabas, épi yo kouwi dèyè yo sòti an vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Kon sa Pòl èk Bannabas soukwé lapousyè pyé yo kont sé moun sala épi yo pati alé an vil Ikonnyòm. ");
INSERT INTO acfNT_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Sé moun-an ki té kwè an Jézi-a té anba kondwit Lèspwi Bondyé épi yo té kontan an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Lè Pòl épi Bannabas wivé Ikonnyòm, yo antwé an légliz sé Jwif-la kon lakoutim. Yo palé tèlman byen an chay Jwif épi moun ki pa Jwif vini kwè an Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Sé Jwif-la ki wifizé kwè an Jézi-a malpalé sé fwè-a épi fè sé moun-an ki pa Jwif-la lévé kont yo. ");
INSERT INTO acfNT_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kon sa Pòl épi Bannabas wèsté la pou an chay tan épi yo té ka palé san lapè konsèné Senyè-a. Senyè-a menm ba yo pouvwa pou fè an chay gwan twavay épi miwak pou moutwé sa yo té ka di-a té vwé konsèné lagwas li. ");
INSERT INTO acfNT_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","La té ni halé kasé anpami sé moun vil-la. Adan moun té pwan pou sé zapòt-la, adan té pwan pou sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Adan moun ki pa té Jwif épi adan sé Jwif-la ansanm épi chèf yo té ka fè konplo pou yo té maltwété sé zapòt-la épi pou yo té voyé wòch dèyè yo. ");
INSERT INTO acfNT_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Lè sé zapòt-la vin konnèt sa, yo chapé kò yo. Yo alé Listra épi Dèbé, vil an Likònya. Yo alé an sé plas-la ki oliwon-an tou, ");
INSERT INTO acfNT_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","épi la yo kontiné pwéché Bon Nouvèl-la konsèné Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","La té ni an nonm Listra ki té enfim an dé pyéʼy dépi lè i té fèt épi i pa té janmen maché. ");
INSERT INTO acfNT_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","I té asid la ka kouté sa Pòl ka di-a. Lè Pòl gadéʼy an mitan zyé, i wè nonm-lan ni lafwa pouʼy té sa jwenn djéwizonʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","I diʼy adan an gwo vwa, “Doubout asou dé pyéʼw!” Menm lè-a, nonm-lan soté doubout épi i koumansé maché. ");
INSERT INTO acfNT_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Lè sé moun-an wè sa Pòl fè-a, yo koumansé lévé vwa yo an langaj Likònya épi yo di, “Sé bondyé-a ja vini kon nonm épi yo ja désann vini jwenn nou!” ");
INSERT INTO acfNT_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Épi yo di Bannabas sé bondyé-a yo ka kwiyé Zous-la, épi Pòl sé Hèmiz, paski sé li ki té toujou ka palé. ");
INSERT INTO acfNT_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Pwèt-la ki té ka fè sèvis an kay-la dèwò vil-la koté yo té ka adowé Zous-la mennen towo bèf épi kouwonn flè an bayè-a. Li épi sé moun-an té vlé tjwé épi bwilé sé bèf-la kon yon sakwifis bay sé zapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Mé lè Bannabas épi Pòl tann sa yo té kay fè-a, yo déchiwé had yo pou yo moutwé fòs kontan yo pa té kontan sa yo té ka fè-a. Yo mété kouwi anpami sé moun-an ");
INSERT INTO acfNT_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","épi yo hélé, “Mésyé, pouki zòt ka fè sa? Nou sé nonm menm kon zòt! Nou vini pou di zòt Bon Nouvèl-la pou zòt sa tounen kont sé bondyé-a ki pa vo anyen-an épi pouʼw sa vini jwenn Bondyé-a ki ka viv-la. Sé li ki fè syèl-la, latè-a, lanmè-a épi tout sa ki andidan yo. ");
INSERT INTO acfNT_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","An tan ki pasé i kité tout moun fè sa yo vlé, ");
INSERT INTO acfNT_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","mé i ja moutwé aklè ki kalité Bondyé i yé lè ou wè sé bon bagay-la i ka fè-a. I ka fè lapli tonbé épi i ka fè sé pyé fwi-a pòté an sézon yo. I ka baʼw manjé alabondans épi i ka fè tjèʼw kontan.” ");
INSERT INTO acfNT_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Magwé sé zapòt-la té di yo tout sé pawòl sala, i pa té ézé pou té sa anpéché yo fè sakwifis-la ba yo. ");
INSERT INTO acfNT_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Adan Jwif sòti Antiyòk Pisidya épi Ikonnyòm. Yo fè sé moun-an tounen kont Pòl. Yo bay Pòl wòch épi yo twennenʼy alé dèwò vil-la paski yo kwè i té mò. ");
INSERT INTO acfNT_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Mé lè sé moun-an ki kwè an Jézi-a vini asanblé owon Pòl, i lévé épi i viwé antwé an vil-la. An li denmen, li épi Bannabas pati alé Dèbé. ");
INSERT INTO acfNT_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Pòl épi Bannabas pwéché Bon Nouvèl-la an Dèbé, épi an chay moun vini kwè an Jézi. Apwé sa, yo déviwé Listra, Ikonnyòm épi Antiyòk Pisidya. ");
INSERT INTO acfNT_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Yo édé sé moun-an ki kwè an Jézi-a vini pli fò an sa yo té ka kwè-a épi yo ankouwajé yo pou yo sa kontiné kwè épi obéyi Senyè-a. Épi yo di yo, “Sé pou nou pasé an chay twaka an lavi sala pou nou jwenn tout sé bon bagay-la Bondyé ja pwonmèt sé moun-an i ka kondwi-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","An chak légliz, Pòl épi Bannabas chwazi nonm pou té sa kondwi an légliz-la. Épi yo wèsté san manjé pou yo té sa pwédyé ba yo, épi yo mété yo an lanmen Senyè-a, paski sé nonm-lan té ja mété tout lafwa yo an Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Apwé yo pasé Pisidya, yo alé an péyi Panfiliya ");
INSERT INTO acfNT_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","épi apwé yo pwéché Bon Nouvèl-la an vil Pèga, yo désann an vil Atalya, ");
INSERT INTO acfNT_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","épi lè yo kité Atalya, yo pwan batiman pou yo déviwé Antiyòk an Siriya. Sété an vil Antiyòk sé moun-an té ladjé yo an lanmen Bondyé pouʼy té sa moutwé yo lagwas li épi édé yo fini twavay-la i té ba yo fè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Lè yo wivé an vil Antiyòk, yo asanblé gany sé moun-an ki kwè an Jézi-a ansanm, épi yo di yo tout sé twavay-la Bondyé té ja ba yo pouvwa pou fè-a épi ki mannyè i bay sé moun-an ki pa Jwif-la an chans pou yo sa vin kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Épi yo dé-a wèsté épi sé moun Antiyòk-la ki kwè an Jézi-a pou tibwen tan. ");
INSERT INTO acfNT_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Déotwa nonm sòti Joudiya vini Antiyòk épi yo koumansé enstwi sé fwè-a ki pa Jwif-la, yo di, “Bondyé pa kay sovéʼw hòd péchéʼw si ou pa fè yo sikonsayz ou kon lwa Moziz-la di.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pòl épi Bannabas pa té dakò épi yo, èk yo té ni an gwo chikann asou sa. Kon sa yo désidé pou voyé Pòl épi Bannabas ansanm épi déotwa lézòt moun ki kwè an Jézi pou ay oti sé zapòt-la épi sé ofisyé-a ki té ka kondwi légliz Jérouzalèm-lan asou sa. ");
INSERT INTO acfNT_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Kon sa légliz Antiyòk-la voyé yo alé, épi lè yo ka pasé an Fènisiya épi Sanmariya, yo di sé fwè-a mannyè sé moun-an ki pa Jwif-la ja tounen hòd péché yo èk vin jwenn Bondyé tou. Nouvèl sala fè sé fwè-a kontan an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Lè Pòl épi Bannabas wivé Jérouzalèm, sé zapòt-la, sé ofisyé légliz-la épi gany sé moun-an ki kwè an Jézi-a wisivwè yo byen. Épi Pòl épi Bannabas wakonté tout sa Bondyé té ba yo pouvwa pou fè. ");
INSERT INTO acfNT_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Mé adan sé fwè-a ki té an gany sé Fawizyen-an doubout épi yo di, “Ou ni pou sa sikonsayz sé moun sala épi di yo pou obéyi lwa-a Bondyé bay Moziz-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Kon sa sé zapòt-la épi sé ofisyé légliz-la asid ansanm pou konsidiwé kwèsyon sala. ");
INSERT INTO acfNT_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Apwé yo palé asou sa pou an chay tan, Pita doubout épi i di, “Fwè mwen, zòt konnèt dépi lontan Bondyé chwazi mwen pou té ay pwéché Bon Nouvèl-la bay sé moun-an ki pa Jwif-la pou yo sa tann épi pou yo sa kwè an Senyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Bondyé ki konnèt tjè tout moun moutwé i té aksèpté sé moun-an ki pa Jwif-la tou, lè i ba yo Lèspwi Bondyé menm kon i té ban nouʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Bondyé moutwé nou la pa ni pyès diféwans ant nou épi sé moun-an ki pa Jwif-la. I pawdonnen péché yo paski yo kwè an li. ");
INSERT INTO acfNT_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Kon sa pouki ou vlé fè Bondyé faché? Ou vlé mété on chay lou anlè do sé fwè-a ki pa Jwif-la. Ni nou ni gwan gwanpapa lontan nou pa té sa pòté chay sala. ");
INSERT INTO acfNT_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Mé mi sa nou ka kwè: Bondyé ka sové yo menm kon i ka sové nou paski Jézi ni lagwas pou tout moun.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Tout moun wèsté an silans lè Pòl épi Bannabas di yo tout sé miwak-la épi sé gwan twavay-la Bondyé té ba yo pouvwa pou fè anpami sé moun-an ki pa Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Lè yo fini palé, Jémz doubout épi i di, “Fwè mwen, kouté mwen! ");
INSERT INTO acfNT_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon Pita ja di nou ki mannyè Bondyé moutwé lanmityéʼy pou sé moun-an ki pa Jwif-la lè i chwazi anpami yo an konpanni moun pou sa li. ");
INSERT INTO acfNT_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Sa sé pwòfèt-la té ékwi dakò épi sa byen. Mi sa lévanjil-la di: ");
INSERT INTO acfNT_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Senyè-a di, apwé sa mwen kay déviwé, épi mwen kay bay Wa David kondwit li ankò. Mwen kay fè yonn an sé désandanʼy-lan vini an wa. ");
INSERT INTO acfNT_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Kon sa tout lézòt moun kay vin chaché mwen, tout sé moun-an ki pa Jwif-la mwen ja chwazi pou kò mwen-an.’ ");
INSERT INTO acfNT_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Sé sa Senyè-a di, épi sé li ki fè nou konnèt tout sé bagay sala ki té an lidéʼy dépi an koumansman-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Jémz kontiné ka palé, i di, “An wipinyon mwen, mwen pa wè nou ni pou anbété sé moun-an ki pa Jwif-la ki ka tounen vin jwenn Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Sa nou kay fè, nou kay ékwi yo on lèt, nou kay di yo pou pa manjé manjé yo ja ofè bay imaj, pa kouwi vyé lavi, épi pa manjé ni san ni vyann zannimo ki twanglé. ");
INSERT INTO acfNT_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Sé bagay sala enpòtan pou sé Jwif-la, paski i ni lontan yo ka pwéché lwa-a Bondyé bay Moziz-la an tout vil. Épi toulé jou sabaf yo ka liʼy an sé légliz yo-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Lè sala sé zapòt-la épi sé ofisyé légliz-la asanblé ansanm épi gany sé moun-an ki kwè an Jézi-a, épi yo désidé pou chwazi déotwa nonm anpami yo menm épi voyé yo alé Antiyòk épi Pòl épi Bannabas. Yo chwazi Jida yo té ka kwiyé Basabas, épi Saylas, dé nonm yo té ka wèspèkté an chay, ");
INSERT INTO acfNT_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","épi yo voyé lèt sala alé épi yo. Lèt la di: Nou sé zapòt-la épi sé ofisyé légliz-la sé fwè zòt. Nou ka voyé bonjou bay tout sé fwè-a ki pa Jwif-la ki ka wèsté Antiyòk, Silisiya épi Siriya. ");
INSERT INTO acfNT_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nou ja tann ki déotwa nonm ki té sòti an gany nou té diʼw an chay bagay pou té anbétéʼw épi pou té sa twoublé lidéʼw. Mé sé pa nou ki té voyé yo fè sa. ");
INSERT INTO acfNT_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Kon sa pou lapéti sa, nou ja jwenn ansanm épi nou ja dakò pou chwazi déotwa moun kon konmisyonnè nou épi nou kay voyé yo kotéʼw épi dé bon jan nou-an, Pòl épi Bannabas. ");
INSERT INTO acfNT_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Moun té pawé pou tjwé yo pou lapéti Senyè Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Kon sa nou ka voyé Jida épi Saylas épi yo, épi yo kay diʼw menm sé bagay-la nou ékwiʼw-la. ");
INSERT INTO acfNT_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Nou épi Lèspwi Bondyé ja dakò pou pa mété pyès lòt chay anlè doʼw. Mi sé lwa sala tousèl nou vléʼw obéyi: ");
INSERT INTO acfNT_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ou pa sipozé manjé pyès manjé yo té ja ofè kon kado bay imaj, ni pa manjé san, ni pa manjé pyès vyann zannimo ki twanglé, épi pa kouwi vyé lavi. Si ou pa fè sé bagay sala, ou kay fè byen. Bondyé benniʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Gany sé moun Jérouzalèm-lan ki kwè an Jézi-a voyé sé konmisyonnè-a alé épi lèt-la, épi lè yo wivé Antiyòk, yo asanblé tout sé moun-an ki kwè an Jézi-a ansanm épi yo ba yo lèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Lè sé jan Antiyòk-la li lèt-la, yo té kontan an chay pou mannyè sé zapòt-la té ankouwajé yo. ");
INSERT INTO acfNT_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Jida épi Saylas menm, ki sété pwòfèt, palé an chay tan épi yo ankouwajé sé fwè-a pou vini pli fò an lafwa yo. ");
INSERT INTO acfNT_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Apwé yo té wèsté la pou tibwen tan, sé fwè Antiyòk-la voyé yo alé épi bennédiksyon Bondyé ay jwenn sé fwè-a an Jérouzalèm ki té voyé yo-a.  ");
INSERT INTO acfNT_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Mé Saylas désidé pou wèsté la. ");
INSERT INTO acfNT_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Pòl épi Bannabas wèsté Antiyòk. Yo ansanm épi an pil lézòt fwè enstwi sé moun-an an pawòl Senyè-a épi yo pwéché Bon Nouvèl-la ba yo. ");
INSERT INTO acfNT_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Tibwen tan apwé sa Pòl di Bannabas, “Annou déviwé ay vizité sé fwè-a an chak sé vil-la koté nou té pwéché pawòl Senyè-a épi annou gadé mannyè yo ka fè.” ");
INSERT INTO acfNT_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bannabas té vlé mennen Jan (yo té ka kwiyéʼy Mak osi), ");
INSERT INTO acfNT_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","mé Pòl di sa pa dwèt pou mennenʼy paski i pa té kontiné épi yo pou yo té fini twavay-la. I té tounen do anlè yo épi i kité yo Panfiliya. ");
INSERT INTO acfNT_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","La té ni gwo chikann ant yo dé-a épi yo sépawé. Bannabas pwan Mak épi yo pwan batiman pou yo alé Saypròs. ");
INSERT INTO acfNT_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Pòl menm chwazi Saylas épi i pati, mé avan yo pati, sé fwè-a ladjé yo lanmen Bondyé pouʼy té sa moutwé yo lagwas li. ");
INSERT INTO acfNT_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Pòl pasé an Siriya épi Silisiya épi i té ka ankouwajé gany sé moun-an ki kwè an Jézi-a pou tjenbé pli fò an lafwa yo. ");
INSERT INTO acfNT_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pòl alé an vil Dèbé épi an vil Listra. La té ni an nonm ki kwè an Jézi ki té ka wèsté la, yo té ka kwiyéʼy Timòfi. Manmanʼy té kwè an Jézi épi i sété on Jwif, mé papaʼy pa té Jwif, sété jan péyi Gris. ");
INSERT INTO acfNT_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Tout sé fwè-a ki té ka wèsté Listra épi Ikonnyòm-lan té ka palé byen di Timòfi. ");
INSERT INTO acfNT_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pòl té vlé mennenʼy alé épiʼy, kon sa i té ni pou sikonsayz li pou sé Jwif-la té aksèptéʼy, paski tout sé Jwif-la ki té ka wèsté an sé plas-la oliwon-an té sav papaʼy sété jan péyi Gris. ");
INSERT INTO acfNT_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Kon yo té ka pasé an sé vil-la, yo té ka di sé fwè-a sé disizyon-an sé zapòt-la épi sé ofisyé légliz-la té ja pwan an Jérouzalèm-lan, épi yo di yo pou obéyi sé disizyon-an. ");
INSERT INTO acfNT_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Sé kon sa sé gany sé moun-an ki kwè an Jézi-a té ka vini pli fò an lafwa-a, épi pli an plis moun té ka kwè toulé jou. ");
INSERT INTO acfNT_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Lèspwi Bondyé pa kité Pòl épi sé janʼy-lan pwéché konmisyon-an konsèné Jézi Kwi an Écha, kon sa yo pasé an Frigiya épi Galécha. ");
INSERT INTO acfNT_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Lè yo wivé tou pwé péyi Misya, yo té vlé alé an péyi Bifiniya, mé Lèspwi Jézi pa kité yo alé. ");
INSERT INTO acfNT_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Kon sa yo twavèsé Misya épi yo désann an vil Trowas. ");
INSERT INTO acfNT_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Jou òswè sala Pòl té wè an vizyon, i wè an nonm Masédonnya doubout épi i ka diʼy, “Tanpwi souplé, vini édé nou isi-a!” ");
INSERT INTO acfNT_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Kon Pòl wè vizyon sala, nou pawé kò nou menm lè-a pou nou alé Masédonnya, paski nou té asiwé Bondyé té vlé nou pwéché Bon Nouvèl-la bay sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Nou pwan batiman épi nou kité vil Trowas épi nou alé dwèt pou Sanmotras, épi an li denmen nou alé Néyapolis. ");
INSERT INTO acfNT_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Lè nou kité Néyapolis, nou alé Filipay, an vil koté sé jan Ronm-lan ka wèsté, an vil ki an pli enpòtan pawès-la an Masédonnya. Nou pasé déotwa jou la. ");
INSERT INTO acfNT_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Jou sabaf-la nou kité bayè vil-la épi nou alé bò lawivyè-a koté nou kwè kay ni on plas koté Jwif ka asanblé pou pwédyé. Lè nou wivé la, nou asid épi nou palé bay sé madanm-lan ki té la-a. ");
INSERT INTO acfNT_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Yonn adan yo ki té ka kouté nou sété Lidya, ki té sòti vil Tayatayra. I sété an machann ki ka vann twèl lila ki byen chè. Sété an madanm ki té ka adowé Bondyé, épi Senyè-a ouvè tjèʼy pouʼy té konpwann sa Pòl té ka di-a. ");
INSERT INTO acfNT_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Lidya épi tout moun ki té ka wèsté lakay li wisivwè batenm. Apwé sa, i envité nou vini lakay li, i di, “Vini wèsté lakay mwen si ou kwè mwen mété lafwa mwen an Jézi pou vwé.” Sé kon sa i fè nou wèsté lakay li. ");
INSERT INTO acfNT_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Yon jou lè nou té ka alé an plas lapwiyè-a an tifi ki sété yon sèvant jwenn nou. I té ni on vyé lèspwi andidanʼy, épi vyé lèspwi sala té ka fèʼy di sa ki té kay fèt an tan ki ka vini. An mannyè sala tifi-a té ka fè an chay lajan bay mèt li. ");
INSERT INTO acfNT_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Tifi-a té ka swiv Pòl épi nou, épi i té ka andjélé, “Sé nonm sala sé sèvant Bondyé-a ki pa ni pyès anhoʼy-la. Yo ka di zòt mannyè Bondyé sa sové zòt!” ");
INSERT INTO acfNT_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Tifi-a fè sa pou konmen jou, épi on jou Pòl vini annòvé. I tounen épi i di vyé lèspwi-a, “Mwen ka konmandéʼw an non Jézi Kwi pou sòti andidan tifi-a apwézan!” Épi menm lè-a vyé lèspwi-a sòti andidanʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Lè mèt tifi-a wè yo pa kay fè pyès lajan asou tifi-a ankò, yo tjenbé Pòl épi Saylas épi yo twennen yo douvan sé majèstwa-a an plas-la yo ka fè lodyans-lan. ");
INSERT INTO acfNT_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Yo mennen yo douvan sé majèstwa Ronm-lan épi yo di, “Sé nonm sala sé Jwif épi yo ka fè twaka an vil nou-an. ");
INSERT INTO acfNT_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Yo ka enstwi nou bagay ki kont lwa nou. Nou pa sa fè sé bagay sala yo ka di nou fè-a, paski nou sé jan Ronm.” ");
INSERT INTO acfNT_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Épi tout sé moun-an lévé kont Pòl épi Saylas, épi sé majèstwa-a déchiwé tout had ki té anlè Pòl épi Saylas, épi yo konmandé sòlda yo pou bat yo épi baton. ");
INSERT INTO acfNT_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Lè yo fin ba yo an chay kou, yo mété yo lajòl épi yo konmandé chèf pwizon-an pou laklé yo byen. ");
INSERT INTO acfNT_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Lè chèf pwizon-an jwenn konmandman sala, i mété yo an chanm-lan ki té pli fon an lajòl-la, épi i anchenné pyé yo an mitan dé gwo tjò bwa. ");
INSERT INTO acfNT_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Lè i té bò mennwit kon sa, Pòl épi Saylas té ka pwédyé épi yo té ka chanté pou glowifyé Bondyé, épi sé lézòt pwizonnyé-a té ka kouté. ");
INSERT INTO acfNT_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Yo wèsté la, èk yo annèk santi an gwo twanblanntè ki soukwé lajòl-la jis an fondasyon, épi menm lè-a tout lapòt ouvè, épi tout sé chenn-an ki té anchenné sé pwizonnyé-a sòti. ");
INSERT INTO acfNT_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Lè chèf pwizon-an lévé épi i wè tout lapòt ouvè, i kwè sé pwizonnyé-a té ja chapé. I hédi sab li pouʼy té tjwé kòʼy, ");
INSERT INTO acfNT_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","mé Pòl héléʼy fò, i di, “Pa tjwé kòʼw! Nou tout isi-a!” ");
INSERT INTO acfNT_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Chèf pwizon-an mandé pou an klèté épi i kouwi antwé. I té ka twanblé kon yon fèy épi i jété kòʼy an pyé Pòl épi Saylas. ");
INSERT INTO acfNT_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","I mennen yo sòti an pwizon-an épi i di, “Mésyé, ki sa pou mwen fè pou mwen jwenn salvasyon?” ");
INSERT INTO acfNT_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Yo diʼy, “Mété lafwaʼw an Senyè Jézi, épi Bondyé kay sovéʼw épi tout moun ki lakay ou.” ");
INSERT INTO acfNT_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Épi yo pwéché pawòl Senyè-a ba li épi tout lézòt moun ki té an kay li. ");
INSERT INTO acfNT_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Épi menm lè-a jou òswè sala, chèf pwizon-an pwan yo épi i pansé yo, épi li épi tout moun ki té lakay li té wisivwè batenm. ");
INSERT INTO acfNT_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","I mennen yo mouté lakay li épi i ba yo manjé, épi li épi fanmiʼy té kontan an chay paski apwézan yo té kwè an Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","An li denmen bonmaten, sé majèstwa-a voyé sé polis-la di chèf pwizon-an, “Ladjé sé nonm sala.” ");
INSERT INTO acfNT_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Kon sa chèf pwizon-an di Pòl, “Sé majèstwa-a ja konmandé nou pou ladjé ou épi Saylas. Kon sa apwézan alé èk lapé an tjèʼw.” ");
INSERT INTO acfNT_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Mé Pòl di sé polis-la, “Yo bat nou an piblik san yo jwenn nou fè anyen ki mové. Yo mété nou an pwizon, épi apwézan yo vlé voyé nou alé pou pyèsonn pa konnèt sa ki té fèt-la. Sé pa kon sa! Nou sé jan Ronm tou! Sé majèstwa Ronm-lan menm ki kay ni pou vini isi-a pou mété nou dèwò!” ");
INSERT INTO acfNT_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Sé polis-la alé épi yo di sé majèstwa-a sa Pòl té di-a. Lè sé majèstwa-a tann Pòl épi Saylas sété jan Ronm, yo té pè an chay, ");
INSERT INTO acfNT_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","épi yo menm alé ay mandé yo padon. Yo tiwé yo an lajòl-la épi yo mandé yo pou kité vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Lè Pòl épi Saylas kité pwizon-an, yo alé lakay Lidya. Lè yo wivé la, yo jwenn épi sé fwè-a, yo ankouwajé sé fwè-a, épi yo kité vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pòl épi Saylas twavèsé Anmfipolis épi Apolonnya jis tan yo wivé an vil Tèsalonnika, koté ki té ni yon légliz Jwif. ");
INSERT INTO acfNT_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pòl alé an légliz-la kon i té ni labitid fè, épi pou twa jou sabaf i palé épi sé moun-an konsèné lévanjil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","I di yo sa lévanjil-la di épi i té ka moutwé yo aklè ki Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a, ni pou soufè épi i ni pou wésisité. Pòl di, “Jézi sala mwen ka di zòt-la, sé li ki Mèsaya-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Adan sé Jwif-la kwè, épi yo vini an gany Pòl épi Saylas, épi an chay jan péyi Gris ki té konvèti pou wilizyon Jwif-la épi an chay sé madanm enpòtan-an vini an gany yo-a tou. ");
INSERT INTO acfNT_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Mé sé Jwif-la ki pa kwè an Jézi-a té vin jalou, kon sa yo pasé anmasé tibwen vyé nèg asou lawi-a épi yo fè an gany, épi yo lévé an gwo roro an tout vil-la. Yo antwé lakay Jason, ka chaché pou Pòl épi Saylas pou mennen dèwò bay sé jan vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Mé lè yo pa jwenn yo, yo twennen Jason épi déotwa lézòt fwè douvan sé majèstwa vil-la épi yo tout hélé fò, yo di, “Sé nonm sala ja bay twaka toupatou, épi apwézan yo vini an vil nou-an ka bay twaka tou, ");
INSERT INTO acfNT_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","épi Jason ja wisivwè yo lakay li. Yo tout ka kasé lwa Siza wa Ronm-lan, paski yo ka di la ni an lòt wa yo ka kwiyé Jézi.” ");
INSERT INTO acfNT_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Lè yo di sa, sé moun-an épi sé majèstwa vil-la té kontwayé an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Sé majèstwa-a fè Jason épi sé lézòt-la péyé épi yo ladjé yo. ");
INSERT INTO acfNT_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Kon sa sòlèy kouché, sé fwè-a voyé Pòl épi Saylas alé an vil Bèriya. Lè yo wivé la, yo alé an légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Sé Jwif Bèriya-a té ni pli bon mannyè pasé sé moun Tèsalonnika-a. Yo wisivwè konmisyon-an konsèné Jézi Kwi byen vit, épi toulé jou yo té ka li lévanjil-la pou yo wè si sa Pòl té ka di-a té vwé. ");
INSERT INTO acfNT_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","An chay sé Jwif-la kwè, épi an chay madanm péyi Gris ki té enpòtan épi an chay nonm péyi Gris vin kwè tou. ");
INSERT INTO acfNT_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Mé lè sé Jwif Tèsalonnika-a vin konnèt Pòl té pwéché pawòl Bondyé an vil Bèriya tou, yo alé la épi yo koumansé fè dézòd pou fè sé moun-an lévé kont Pòl ankò. ");
INSERT INTO acfNT_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Menm lè-a, sé fwè-a pwan Pòl épi yo mennenʼy bò lanmè-a, mé Saylas épi Timòfi wèsté Bèriya. ");
INSERT INTO acfNT_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Sé fwè-a ki té alé épi Pòl-la mennenʼy jis an vil Afenz épi yo viwé Bèriya, mé Pòl té di yo pou di Timòfi épi Saylas pou vini jwenn li vit kon yo pé. ");
INSERT INTO acfNT_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Paditan Pòl té ka èspéyé Saylas épi Timòfi an vil Afenz, tjèʼy fèʼy mal pouʼy té wè mizi imaj ki té an vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Kon sa i wézonnen an légliz-la épi sé Jwif-la épi sé lézòt sé moun-an ki té konvèti pou wilizyon Jwif-la, épi toulé jou i té bò laplas-la ka palé épi moun ki ka pasé. ");
INSERT INTO acfNT_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Déotwa titja Èpikouyen épi titja Stowisyen dispité épiʼy, épi adan yo di, “Ki sa vyé palapata sala vlé di? Misyé la ka bat bouch li ennitil.” Lézòt di, “I ka palé ban nou asou bondyé ki étwanj.” Yo di sa paski Pòl té ka di yo Bon Nouvèl-la konsèné Jézi, épi mannyè sé mò-a kay wésisité. ");
INSERT INTO acfNT_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Kon sa yo mandéʼy pou alé épi yo èk yo mennenʼy douvan gwan konsèy Ariyopagòs-la, épi yo di, “Nou té kay avoudwé konnèt bagay nèf sala ou ka enstwi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Adan sé bagay-la ou ka di nou la-a ka gadé dwòl pou nou, épi nou té kay vlé sav ki sa yo vlé di.” ");
INSERT INTO acfNT_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Sé jan Afenz-lan épi moun lòt nasyon ki té ka wèsté la té ka pasé tout tan yo ka palé épi kouté sé bagay-la ki pli nèf-la.) ");
INSERT INTO acfNT_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Lè sala Pòl doubout an mitan Ariyopagòs-la épi i di yo, “Jan vil Afenz, mwen wè zòt sé moun ki ka adowé tout diféwan kalité imaj. ");
INSERT INTO acfNT_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Mwen di sa paski kon mwen té ka pasé an vil zòt, mwen té ka gadé tout sé plas-la koté zòt ka adowé sé imaj-la, épi mwen wè yon lotèl ki té ni an ékwiti asouʼy. Ékwiti-a di, ‘Pou Bondyé-a Nou Pa Konnèt-la.’ Ében, menm Bondyé sala zòt ka adowé-a épi zòt pa konnèt-la, sé li menm mwen ka paléʼw-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Bondyé ki fè latè-a épi tout sa ki andidanʼy, sé li ki mèt syèl-la épi latè-a épi i pa ka wèsté an kay moun fè ba li. ");
INSERT INTO acfNT_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","I pa bizwen anyen moun sa fè ba li paski sé li menm ki ka bay tout moun lavi épi lèspiwasyon épi tout bagay yo bizwen. ");
INSERT INTO acfNT_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Bondyé fè tout was moun sòti adan yon sèl nonm épi i fè yo viv asou tout latè-a. Sé li menm ki mété dépi an davans ègzaktiman ki londjè lavi yo kay yé épi i mété plas-la pou yo chak wèsté. ");
INSERT INTO acfNT_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Bondyé fè sa pou yo sa chaché pou li, pou yo sa jwenn li paditan yo ka chaché pou li, magwé i pa lwen nou pyès. ");
INSERT INTO acfNT_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Paski, ‘Sé li ki ban nou lavi épi sé li ki ka fè nou maché épi sé li ki fè nou sa nou yé-a.’ Menm kon sé powèt zòt-la té di, ‘Nou sé ich li tou.’ ");
INSERT INTO acfNT_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“Nou sé ich Bondyé, kon sa ou pa sipozé kwè Bondyé menm kon on mòso lò, dajan ében wòch nonm twavay èk abilité yo pou fè imaj lidé yo di yo fè. ");
INSERT INTO acfNT_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","An tan ki pasé lè moun pa té konnèt Bondyé, i pa té ba yo pinisyon-an yo té méwité-a, mé apwézan i ja konmandé tout moun toupatou pou sa tounen kont sé movèzté-a yo ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","I ja mété yon jou pouʼy sa jijé tout moun ki an latè-a èk jistis. I kay sèvi Jézi, nonm-lan i chwazi-a, pou fè sa. I fè tout moun konnèt sa aklè lè i wésisité nonm sala.” ");
INSERT INTO acfNT_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Lè yo tann i di moun ka wésisité, adan yo koumansé pwanʼy sèvi widitjil, mé lézòt ki té la di, “Nou kay tann ou an lòt jou.” ");
INSERT INTO acfNT_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Épi sé kon sa Pòl kité konsèy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Déotwa nonm kwè, épi yo alé an gany Pòl-la. Anpami yo té ni Dayonnisyòs ki sété an manm an konsèy Ariyopagòs-la, épi yon madanm yo té ka kwiyé Danmaris, épi déotwa lézòt moun. ");
INSERT INTO acfNT_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Apwé sa, Pòl kité vil Afenz épi i alé an vil Kòrint. ");
INSERT INTO acfNT_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Lè i wivé la, i jwenn on nonm Jwif yo ka kwiyé Akwila ki té fèt Pontòs. Li épi madanm li Prisilya té sòti péyi Itali tou fwé, paski Wa Klòdiyòs té ja konmandé tout Jwif pou kité vil Ronm. Pòl alé vizité yo èk ");
INSERT INTO acfNT_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","i wèsté épi yo épi i twavay épi yo, paski létaʼy sété fè tant menm kon yo. ");
INSERT INTO acfNT_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Toulé jou sabaf Pòl té ka alé an légliz sé Jwif-la épi i té ka palé épi ni Jwif ni jan péyi Gris pou fè yo kwè an Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Épi lè Saylas épi Timòfi wivé sòti Masédonnya, Pòl sèvi tout tanʼy ka pwéché. I té ka fè sé Jwif-la wè aklè sé Jézi ki Mèsaya-a, wa-a Bondyé té pwonmèt pou voyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Mé lè yo tounen kont li épi yo koumansé di vyé bagay asouʼy, i soukwé lapousyè ki asou had li ba yo épi i di yo, “Sé zòt menm ki kay péyé pou péché zòt. Mwen pa wèskonsab pou zòt ankò. Dépi atjwèlman mwen kay alé koté sé moun-an ki pa Jwif-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Kon sa i kité yo épi i alé wèsté lakay on nonm ki pa Jwif yo ka kwiyé Tityòs Jòstòs ki té ka adowé Bondyé, épi i té ka wèsté tou pwé légliz sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Krispòs, ki té chèf légliz-la, kwè an Senyè-a, li épi tout moun ki té lakay li. An chay lézòt moun an Kòrint tann konmisyon Pòl épi yo kwè épi yo té wisivwè batenm. ");
INSERT INTO acfNT_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Yon jou òswè Pòl wè an vizyon koté Senyè-a diʼy, “Pa pè. Kontiné palé épi pa wèsté silans, ");
INSERT INTO acfNT_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","paski mwen la épiʼw. Pyèsonn pa kay sa fèʼw anyen, paski mwen ni an chay moun an vil sala ki sé sa mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Kon sa Pòl wèsté la pou yon lanné é dimi épi i té ka enstwi sé moun-an konmisyon Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Lè Galyo vini gouvènè péyi Akéya, sé Jwif-la vini ansanm épi yo tjenbé Pòl épi yo mennenʼy lodyans. ");
INSERT INTO acfNT_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","Sé Jwif-la di Galyo, “Nonm sala vlé fè moun adowé Bondyé adan an mannyè ki kont lwa nou.” ");
INSERT INTO acfNT_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Kon Pòl té kay wéponn yo, Galyo di sé Jwif-la, “Si sété on bagay mové ében on kwim i té fè, mwen té kay oblijé ni pou kouté zòt. ");
INSERT INTO acfNT_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Mé paski sé an chikann zòt ni konsèné pawòl, épi asou non moun, épi lwa zòt menm, sé zòt menm ki pou wanjé sa. Mwen pa kay jijé bagay kon sa.” ");
INSERT INTO acfNT_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Épi i kouwi dèyè yo sòti an lodyans-lan. ");
INSERT INTO acfNT_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Yo tout tjenbé Sòstennèz ki sété chèf légliz sé Jwif-la, épi yo ba li an bèl volé douvan kay lodyans-lan, mé Galyo pa anbété kòʼy épi sa. ");
INSERT INTO acfNT_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pòl wèsté èk sé fwè-a an vil Kòrint pou déotwa jou ankò. Apwé sa, i kité yo épi i pwan batiman pou alé Siriya ansanm épi Prisilya épi Akwila. Avan i pwan batiman-an, i fè koupé chivéʼy kwi an vil Senkré pou moutwé i té ja tjenn on pwonmèt i té ja fè bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Lè yo wivé an vil Èfésòs, Pòl kité Prisilya épi Akwila la. I antwé an légliz-la pou palé épi sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Yo mandéʼy pou wèsté tibwen tan épi yo, mé i pa wèsté. ");
INSERT INTO acfNT_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Mé avan i kité, i di yo, “Mwen kay déviwé si Bondyé vlé.” Épi sé kon sa i pwan batiman épi i kité Èfésòs. ");
INSERT INTO acfNT_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Lè i wivé Sizariya, i mouté an vil Jérouzalèm ay di gany sé moun-an ki kwè an Jézi-a bonjou. Apwé sa, i désann an vil Antiyòk. ");
INSERT INTO acfNT_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Apwé i pasé tibwen tan an Antiyòk, i kité épi i twavèsé sé plas-la ki an Galécha épi Frigiya, épi i ankouwajé tout sé moun-an ki kwè an Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","La té ni on Jwif yo té ka kwiyé Apòlòs ki té sòti Alèkzandriya vini Èfésòs. I té konnèt mannyè pou palé byen épi i té konnèt lévanjil-la byen. ");
INSERT INTO acfNT_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yo té ja enstwiʼy ki mannyè an moun ki kwè an Senyè-a sipozé viv, épi i té fò an chay lè i té ka palé. I té ka di sé moun-an lavéwité-a konsèné Jézi, mé sété batenm Jan Batis-la tousèl i té konnèt. ");
INSERT INTO acfNT_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","I koumansé palé an légliz sé Jwif-la san pè pyèsonn ki té ka kouté. Lè Prisilya épi Akwila tann li, yo envitéʼy lakay yo épi yo enstwiʼy mannyè Bondyé vlé moun viv pli byen toujou. ");
INSERT INTO acfNT_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apòlòs vin désidé pouʼy alé péyi Akéya. Sé fwè-a ki té an vil Èfésòs-la ankouwajéʼy, épi yo ékwi on lèt bay sé moun-an ki kwè an Jézi-a an péyi Gris pou yo sa wisivwèʼy byen. Lè i wivé la, i sété an gwo soukou pou sé moun-an ki té vin kwè an Jézi-a, paski Bondyé té ni lagwas pou yo. ");
INSERT INTO acfNT_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","I moutwé sé Jwif-la sa yo té ka di-a pa té vwé lè yo té ka di sé pa Jézi ki Mèsaya-a, moun-an Bondyé té pwonmèt pou voyé-a. I moutwé yo aklè an lévanjil-la sé Jézi ki Mèsaya-a. I fè sa douvan tout sé moun-an, épi sé Jwif-la pa té sa ouvè bouch yo. ");
INSERT INTO acfNT_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Paditan Apòlòs té an vil Kòrint, Pòl pasé andidan péyi-a épi i wivé an vil Èfésòs. Lè i wivé la, i jwenn déotwa moun ki kwè an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","I mandé yo, “Ès zòt wisivwè Lèspwi Bondyé apwé zòt té kwè an Jézi?” Yo di, “Non, nou pʼòkò menm tann si la ni an Lèspwi Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pòl di yo, “Ében, épi kilès batenm yo té batizé zòt?” Yo di, “Sé épi menm batenm-lan Jan Batis té ka palé-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","I di, “Jan té ka batizé moun ki té tounen hòd péché yo. Jan té ka di sé moun Izwayèl-la sé pou yo kwè an moun-an ki ka vini apwéʼy-la, sa vlé di an Jézi.” ");
INSERT INTO acfNT_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Lè sé moun Èfésòs-la ki kwè an Jézi-a tann Pòl di sa, yo wisivwè batenm an non Senyè Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Pòl mété lanmenʼy anlè yo, épi Lèspwi Bondyé désann anlè yo, épi yo koumansé palé an lòt kalité langaj épi yo palé konmisyon ki sòti an Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","La té ni apipwé douz nonm an tout. ");
INSERT INTO acfNT_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Pou twa mwa Pòl alé an légliz sé Jwif-la épi i pa té pè palé bay sé moun-an. I té ka palé kon sa épi yo pou fè yo kwè Bon Nouvèl-la konsèné mannyè Bondyé ka kondwi sé moun li-an. ");
INSERT INTO acfNT_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Mé adan sé Jwif-la té ka fè tèt wèd épi yo wifizé kwè sa i té ka di-a. Yo té ka malpalé konmisyon Senyè-a douvan tout moun. Sé pou sa Pòl kité yo épi i pwan sé moun-an ki té kwè an Jézi-a épiʼy, épi toulé jou i té ka palé épi sé moun sala an gwan chanm-lan koté Tirannis té ka fè lékòl-la. ");
INSERT INTO acfNT_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Sa kontiné pou dé lanné, pou tout jan Écha té sa tann pawòl Senyè-a, Jwif kon moun ki pa Jwif. ");
INSERT INTO acfNT_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Bondyé té ka sèvi Pòl pou fè gwan miwak. ");
INSERT INTO acfNT_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Yo té ka mennen jis mouchwè pòch épi tabliyé ki té touché kòʼy bay sé moun-an ki malad-la, épi maladi-a té ka kité yo épi vyé lèspwi-a té ka sòti andidan yo. ");
INSERT INTO acfNT_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","14","Déotwa gadè Jwif té ka pasé toupatou té ka tiwé vyé lèspwi. Anpami yo té ni sèt gason Siva, on chèf pwèt sé Jwif-la. Yo té ka éséyé sèvi non Senyè Jézi pou tiwé vyé lèspwi. Yo té ka di vyé lèspwi-a kon sa, “An non Jézi-a Pòl ka pwéché-a mwen ka konmandéʼw pou sòti an moun sala!” ");
INSERT INTO acfNT_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Mé vyé lèspwi-a wéponn yo, i di, “Mwen konnèt Jézi épi mwen konnèt Pòl, mé ou menm, ki moun ou yé?” ");
INSERT INTO acfNT_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Nonm-lan ki té ni vyé lèspwi-a soté anlè yo, épi i té fò pasé yo tout. I blésé yo si tèlman mové, yo mété kouwi kité kay-la touni èk yo té benyen an san. ");
INSERT INTO acfNT_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Lè jan Èfésòs vin konnèt sa, ni Jwif épi moun ki pa Jwif, yo tout té pè an chay épi yo glowifyé non Jézi. ");
INSERT INTO acfNT_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","An pil sé moun-an ki té kwè an Jézi-a vini, épi yo di tout vyé bagay yo té ja fè. Yo konfésé sa douvan tout moun. ");
INSERT INTO acfNT_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","An pil sé moun-an ki té ka fè tjenbwa-a mennen tout sé vyé liv yo-a épi yo bwiléʼy an piblik. Valè sé liv sala té vo apipwé senkant mil (50,000) pyès dajan. ");
INSERT INTO acfNT_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Sé kon sa pli an plis moun té ka tann pawòl Senyè-a épi an chay moun vini kwè an Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Apwé tout sé bagay sala té fèt, Pòl désidé pouʼy twavèsé péyi Masédonnya épi Akéya pouʼy alé Jérouzalèm. I di, “Apwé mwen alé la, mwen ni pou alé vizité vil Ronm tou.” ");
INSERT INTO acfNT_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","I voyé Timòfi épi Èrastòs, dé moun ki té ka édéʼy, alé Masédonnya épi i menm wèsté pli tan an Écha. ");
INSERT INTO acfNT_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sété an tan sala an chay twaka té lévé Èfésòs pou lapéti Chimen Jézi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","La té ni on nonm yo té ka kwiyé Démétriyòs ki té ka twavay dajan, épi i té ka fè ti mòdèl kay Atémis-la an dajan. Atémis sé an ti bondyé fanm yo té ka adowé. Twavay sala té ka mennen an chay pwofi bay sé moun-an ki té ka fèʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Kon sa Démétriyòs kwiyé tout sé twavayèʼy-la ansanm épi lézòt moun ki té ka fè twavay kon sa yo-a épi i di yo, “Kanmawad mwen, zòt sav sé twavay sala ki ban nou wichès-la nou ni-an. ");
INSERT INTO acfNT_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Zòt ka wè épi tann pou kò zòt tout sé bagay-la Pòl sala ka fè. I ka di bondyé nonm fè sé pa bondyé pyès, épi i té fè an pil moun kwè sa, ni isi-a an vil Èfésòs épi pwèskè toupatou an péyi Écha-a. ");
INSERT INTO acfNT_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Talè moun kay koumansé palé kont twavay-la nou ka fè-a. Épi sé pa sa tousèl, moun pa kay konsidiwé kay gwan bondyé Atémis-la pou anyen. Épi Atémis menm tout jan Écha épi tout moun oliwon latè-a ka adowé-a, yo pa kay onnowéʼy ankò!” ");
INSERT INTO acfNT_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Lè sé moun-an tann sa, yo té faché an chay épi yo tout koumansé hélé, “Atémis, bondyé Èfésòs-la, gwan an pil!” ");
INSERT INTO acfNT_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Dézòd-la simen an tout vil-la épi sé moun-an tjenbé Gayòs épi Aristakòs, dé jan Masédonnya ki té ka maché épi Pòl, épi yo kouwi mennen yo an gwo kay-la sé jan vil-la ka asanblé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pòl menm té vlé alé ay palé bay sé moun-an, mé sé moun-an ki kwè an Jézi-a pa té kitéʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Épi déotwa chèf péyi Écha ki té kanmawad li voyé konmisyon ba li, ka plédé pouʼy pa alé an kay-la. ");
INSERT INTO acfNT_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","An menm di tan-an tout sé moun-an té asanblé la ka fè an chay dézòd. Yon konpanni té ka hélé on bagay, lòt konpanni-an té ka hélé an lòt bagay, paski majòwité yo pa té sav pouki yo té asanblé la. ");
INSERT INTO acfNT_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Yo mennen Alèkzanda sòti anpami sé moun-an, épi sé Jwif-la té fèʼy mouté douvan ay palé. I fè sin épi lanmenʼy pou tout moun pé la, paski i té vlé palé pouʼy fè défans douvan sé moun-an. ");
INSERT INTO acfNT_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Mé lè sé moun-an wè sété yon Jwif i yé, yo tout koumansé hélé, “Atémis bondyé Èfésòs-la gwan an pil!” Épi yo hélé sa pou dé nèditan. ");
INSERT INTO acfNT_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Alafen, ofisyé-a ki ka kondwi vil-la vin fè yo bésé vwa yo épi i di yo, “Jan Èfésòs, ès tout moun pa konnèt sé jan vil Èfésòs-la ki wèskonsab kay Atémis-la, gwan bondyé fanm-lan, ansanm épi imaj wòch li ki tonbé sòti an syèl-la? ");
INSERT INTO acfNT_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Pyèsonn pa sa di tout sé bagay sala pa vwé, kon sa sé pouʼw bésé kòlèʼw épi pa fè anyen san ou katjilé. ");
INSERT INTO acfNT_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Sé nonm sala pa vòlè anyen ki an kay Atémis-la ni di anyen ki mal asou bondyé nou-an. Pouki zòt mennen yo isi-a? ");
INSERT INTO acfNT_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Si Démétriyòs épi sé twavayè-a ki épiʼy-la ni anyen kont pyèsonn, nou ni sé majèstwa-a la épi sé jou-a pou lodyans-lan, kon sa yo sa pòté plent kont yo si yo vlé. ");
INSERT INTO acfNT_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Mé si la ni lòt bagay toujou ou vlé fè, ou kay ni pou asanblé tout sé jan vil-la ansanm, épi yo kay wanjé sa akòdans lwa-a. ");
INSERT INTO acfNT_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Apwé tout sa ki fèt jòdi-a, yo pé di nou té lévé wévòt kont gouvèdman-an. La pa ni pyès èskiz pou tout dézòd sala, épi nou pa kay sa bay on bon wézon pou sa.” ");
INSERT INTO acfNT_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Lè i fini di yo sa, i voyé tout sé moun-an alé. ");
INSERT INTO acfNT_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Lè dézòd-la bésé, Pòl kwiyé tout sé fwè-a ansanm. Apwé i ankouwajé yo, i di yo oplèz épi i pati pou Masédonnya. ");
INSERT INTO acfNT_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","I pasé an tout ti plas ki an Masédonnya épi i bay sé moun-an an chay pawòl ankouwajman. Apwé sa, i alé Gris ");
INSERT INTO acfNT_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","koté i wèsté pou twa mwa. Épi lè i té ka fè ganm pou pwan batiman pou alé Siriya, i vin konnèt sé Jwif-la té ka fè plan pou yo té tjwéʼy. Kon sa i désidé pou tounen viwé Masédonnya ankò. ");
INSERT INTO acfNT_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Mi non sé moun sala ki té alé épiʼy: Sopatè ich Piris, ki té sòti Bèriya, Aristakòs, Sékoundòs ki té sòti Tèsalonnika, Gayòs ki té sòti Dèbé, Timòfi tou, Titjikòs épi Trofimòs ki té sòti Écha. ");
INSERT INTO acfNT_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Yo pati avan nou épi yo èspéyé nou an Trowas. ");
INSERT INTO acfNT_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Nou menm, apwé Fèt Pen San Lèlven-an, nou pwan batiman épi nou kité Filipay. Apwé senk jou, nou jwenn yo Trowas épi nou pasé on simenn la. ");
INSERT INTO acfNT_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Pwèmyé jou an simenn-an, nou asanblé ansanm pou nou té manjé épi pwan lakonminyon. Pòl palé bay sé moun-an épi i kontiné ka palé pou wivé jis mennwit, paski i té ni pou pati an li denmen. ");
INSERT INTO acfNT_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","La té ni an chay lanp ka limen an chanm anlè-a koté nou té asanblé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","La té ni on jenn gason yo kwiyé Youtikòs ki té asid bò an finèt, épi kon Pòl kontiné ka palé, an mizi an mizi sonmèy koumansé pwanʼy jis tan sonmèy pwanʼy nèt épi i sòti jis an twazyenm étay-la épi i tonbé atè-a. Lè yo anmaséʼy, i té mò fwèt. ");
INSERT INTO acfNT_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Mé Pòl désann épi i bésé kòʼy anlèʼy épi i anbwaséʼy. I di yo, “Zòt pa bizwen pè, i pa mò!” ");
INSERT INTO acfNT_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Lè Pòl viwé mouté an chanm-lan, i kasé pen épi yo konminyé. I kontiné palé épi yo pou an chay tan pou jis tan jou ouvè, épi i pati. ");
INSERT INTO acfNT_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Yo pwan jenn gason-an épi yo mennenʼy lakay li vivan épi sa té konfòté yo an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Nou alé avan Pòl épi nou pwan batiman pou voyajé alé Asòs, koté nou té ni pou anmasé Pòl. I té di nou anmaséʼy la, paski i té alé la pa tè. ");
INSERT INTO acfNT_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Lè nou jwenn li Asòs, nou anmaséʼy abò batiman-an épi nou alé an vil Mitilin. ");
INSERT INTO acfNT_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Nou pati ankò, épi an li denmen nou wivé tou pwé Kiyòs. Yon jou apwé sa nou wivé Sanmòs, épi an li denmen, nou wivé an vil Militis. ");
INSERT INTO acfNT_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Pòl té ja désidé pouʼy pa té doubout an vil Èfésòs paski i pa té vlé pèdi pyès tan an sé plas Écha-a. I té ka fè vit pouʼy té wivé an vil Jérouzalèm pou Fèt Pentikòs-la, si i té posib. ");
INSERT INTO acfNT_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Lè Pòl wivé Militis, i voyé an konmisyon bay sé ofisyé-a ki té ka kondwi légliz Èfésòs-la pou vini jwenn li. ");
INSERT INTO acfNT_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Lè yo wivé, i di yo, “Zòt menm konnèt mannyè mwen pasé tout tan mwen épi zòt dépi pwèmyé tan-an mwen té vini an péyi Écha-a. ");
INSERT INTO acfNT_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Sé Jwif-la fè mwen soufè an chay lè yo té ka fè plan pou tjwé mwen, mé mwen té abésé kò mwen épi mwen té twavay bay Senyè-a épi dlo an zyé mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ou konnèt byen mwen pa séwé anyen ki té kay édéʼw lè mwen té ka pwéché épi enstwiʼw, ni an piblik ni lakay zòt. ");
INSERT INTO acfNT_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Mwen vèti ni moun ki Jwif ni moun ki pa Jwif byen sèwyé pou yo té sa tounen hòd péché yo vin jwenn Bondyé épi kwè an Senyè Jézi nou-an. ");
INSERT INTO acfNT_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Épi apwézan mwen ni pou alé an vil Jérouzalèm. Lèspwi Bondyé ka pousé mwen alé, épi mwen pa menm sav ki sa ki kay wivé mwen la. ");
INSERT INTO acfNT_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Mé yon sèl bagay mwen sav, Lèspwi Bondyé ja vèti mwen èk i fè mwen sav la ni twaka épi lajòl ka èspéyé mwen an chak vil. ");
INSERT INTO acfNT_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Lavi mwen pa vo anyen pou mwen, mé sa ki enpòtan-an sé fini mwen vlé fini twavay-la Senyè Jézi ban mwen fè-a pou mwen di moun Bon Nouvèl-la konsèné lagwas Bondyé lè i té voyé Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Mwen ja pasé anpami zòt tout épi di zòt Bondyé ja koumansé kondwi adan an mannyè ki nèf. Épi apwézan, mwen sav zòt pyès pa kay janmen wè mwen ankò. ");
INSERT INTO acfNT_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Sé pou sa mwen ka asiwéʼw jòdi-a, si zòt pyès péwi, sé pa fòt mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Mwen ja diʼw tout sa Bondyé té ni plan pou fè, épi mwen pa tjenbé anyen dèyè. ");
INSERT INTO acfNT_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Véyé kòʼw épi véyé sé moun-an Lèspwi Bondyé ja mété an lanmenʼw-lan, sé moun-an Bondyé té achté épi san Gasonʼy-lan. Mwen ka météʼw gadyenn sé moun légliz Bondyé-a, menm kon an gadyenn ka gadé moutonʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Mwen sav apwé mwen alé moun kay vini anpami zòt pou détwi sé moun légliz-la, menm kon chyen mawon adan an twipo mouton. ");
INSERT INTO acfNT_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Tan-an kay vini lè moun ki sòti anpami zòt menm kay manti pou yo sa pwan sé moun-an ki kwè an Jézi-a mennen alé épi yo. ");
INSERT INTO acfNT_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kon sa véyé kòʼw! Toujou chonjé mwen pa janmen doubout vèti zòt épi dlo an zyé mwen pou twa lanné, lajouné kon lannwit. ");
INSERT INTO acfNT_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Apwézan mwen ka ladjéʼw an lanmen Bondyé. Mwen ka dépan asou konmisyon Bondyé pou sa fèʼw fò an lagwas-la Bondyé té ni pou ou lè i té voyé Jézi Kwi-a. Konmisyon sala, sé li ki sa baʼw sé bennédiksyon-an Bondyé ja pwonmèt pou tout sé moun li-an. ");
INSERT INTO acfNT_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Mwen pa té vlé ni dajan ni lò ében had pyèsonn. ");
INSERT INTO acfNT_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Zòt tout konnèt mwen ja twavay wèd épi lanmen mwen pou tout sé bagay-la mwen épi sé jan mwen-an té bizwen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Mwen ja moutwéʼw sé pouʼw twavay wèd an tout sa ou ka fè. An mannyè sala, ou kay sa édé sé moun-an ki fèb-la. Toujou chonjé pawòl Senyè Jézi menm lè i té di, ‘Tjèʼw ka pli kontan lè ou bay pasé lè ou wisivwè.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Lè Pòl fini palé, i ajounou épi yo tout épi i pwédyé, ");
INSERT INTO acfNT_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","épi yo té ka pléwé lè yo té ka anbwaséʼy épi boʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Sa ki té fè yo plis lapenn-an sé lè i di yo pa kay janmen wèʼy ankò. Apwé sa, yo maché alé épiʼy bò batiman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Épi dlo an zyé nou, nou di yo nou ka alé, épi nou pati. Apwé nou pwan batiman, nou alé dwèt jis tan nou wivé Kòs, épi an li denmen nou wivé Ròdz. Lè nou kité la, nou alé Patara. ");
INSERT INTO acfNT_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Lè nou wivé Patara, nou jwenn an batiman ka alé Fènisiya, kon sa nou batjéʼy épi nou pati. ");
INSERT INTO acfNT_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Nou alé jis tan nou dékouvè Saypròs épi nou pasé pa anbaʼy pou nou alé Siriya. Nou kòsté an vil Taya, koté yo té ni pou débatjé chay abò batiman-an, épi nou alé atè. ");
INSERT INTO acfNT_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Nou jwenn déotwa moun ki kwè an Jézi la épi nou wèsté yon simenn épi yo. Yo vèti Pòl pou pa mouté Jérouzalèm paski Lèspwi Bondyé té di yo sa ki kay wivéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Mé lè tan nou té bout épi yo, nou pati épi nou kontiné fè wout nou. Tout sé nonm Taya-a ki kwè an Jézi-a épi madanm yo épi ich yo kité vil-la, épi yo désann jis bò lanmè-a épi nou, épi nou tout ajounou asou sab lanmè-a épi nou pwédyé. ");
INSERT INTO acfNT_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Apwé nou di yonn a lòt oplèz, nou batjé batiman-an, épi yo viwé lakay yo. ");
INSERT INTO acfNT_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Nou kontiné voyaj nou sòti Taya pou wivé Tolimé, koté nou di sé fwè-a bonjou épi nou wèsté épi yo pou yon jou. ");
INSERT INTO acfNT_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Épi an li denmen, nou kité épi nou wivé Sizariya. La nou wèsté lakay Filip, an nonm ki té ka pwéché Bon Nouvèl-la konsèné Jézi Kwi. I sété yonn an sé sèt nonm-lan yo té chwazi pou té édé sé moun légliz Jérouzalèm-lan. ");
INSERT INTO acfNT_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Nonm sala té ni kat fi ki pa té mayé ki té ni kado-a Lèspwi Bondyé té ba yo-a pou palé konmisyon Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Lè nou wèsté la pou déotwa jou, an pwòfèt yo ka kwiyé Agabòs vini sòti Joudiya. ");
INSERT INTO acfNT_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Lè i wivé, i pwan sanng Pòl épi i mawé dé lanmenʼy menm épi dé pyéʼy menm, épi i di, “Mi sa Lèspwi Bondyé di mwen, ‘Sé kon sa sé Jwif-la kay mawé mèt sanng sala lè i wivé Jérouzalèm, épi yo kay ladjéʼy an lanmen sé moun-an ki pa Jwif-la.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Lè nou tann sa, nou épi sé lézòt-la ki té la-a plédé épi Pòl pouʼy pa alé Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Mé i di, “Ki sa zòt ka fè-a? Pouki zòt ka pléwé kon sa? Zòt ka kasé tjè mwen! Sé pa pawé tousèl mwen pawé pou yo mawé mwen, mé mwen jis pawé pou mwen mò an Jérouzalèm pou lapéti Senyè Jézi.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Nou pa té sa fèʼy chanjé lidéʼy, kon sa nou kitéʼy bat mizèʼy épi nou di, “Ében, kité Bondyé fè sa i vlé fèt-la.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Lè nou pasé tibwen tan la, nou pawé kò nou épi nou kité pou Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Adan sé moun-an ki kwè an Jézi-a ki té sòti Sizariya-a alé épi nou tou. Yo mennen nou lakay Nason, on nonm ki sòti Saypròs ki té kwè an Jézi dépi lontan. Sé la nou wèsté. ");
INSERT INTO acfNT_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Lè nou wivé an vil Jérouzalèm, sé fwè-a té kontan an chay pou wè nou. ");
INSERT INTO acfNT_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","An li denmen, nou épi Pòl pati alé wè Jémz, épi tout sé ofisyé-a ki té ka kondwi légliz-la té la tou. ");
INSERT INTO acfNT_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pòl di yo bonjou épi i wakonté yo an détay tout sa Bondyé té ja ba li pouvwa pou fè anpami sé moun-an ki pa Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Lè yo tann sa, yo tout glowifyé Bondyé épi yo di, “Fwè Pòl, ou ka wè ki otan Jwif ki ja kwè an Jézi Kwi, épi magwé sa, yo tout cho dèyè lwa sé Jwif-la toujou. ");
INSERT INTO acfNT_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Moun ja di yo ou ka enstwi tout sé Jwif-la ki ka viv an péyi sé moun lòt nasyon-an yo pa bizwen swiv lwa sé Jwif-la. Ou ka di yo pou pa sikonsayz ti gason yo épi pa swiv twadisyon sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Bon, ki sa nou kay fè apwézan? Nou asiwé sé Jwif sala kay sav ou ja wivé isi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Mi sa nou kay vléʼw fè: La ni kat nonm isi-a ki ja fè an pwonmèt douvan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Alé ansanm épi yo épi fè sé bagay-la lwa sé Jwif-la di ou ni pou fè pou Bondyé aksèpté pwonmèt-la ou fè douvanʼy-lan, épi péyé dépans-lan yo fè-a. Lè ou fè sa, yo kay sa wazé tèt yo pou moutwé yo ja tjenn pwonmèt-la. An mannyè sala tout moun kay sav la pa ni pyès lavéwité an sé bagay-la sé moun-an té ka di-a, épi yo kay wè ou menm ka swiv lwa sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Mé pou sé moun-an ki pa Jwif-la ki ja kwè an Senyè Jézi-a, nou té ja voyé on lèt ba yo pou di yo nou ja désidé pou yo pa manjé pyès vyann moun ja ofè bay imaj, ni san ében vyann zannimo ki twanglé, épi sé pa pou yo kouwi vyé lavi.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Kon sa Pòl pwan menm kat sé nonm-lan, épi an li denmen, yo fè sa lwa sé Jwif-la di yo ni pou fè pou Bondyé aksèpté pwonmèt yo. Lè sala i antwé an Kay Bondyé-a épi i alé fè yo sav ki jou yo kay fini fè tout sa lwa sé Jwif-la di yo ni pou fè pou Bondyé aksèpté pwonmèt yo. Asou sètyenm jou-a yo kay ofè an sakwifis ba yo chak. ");
INSERT INTO acfNT_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Menm kon sèt jou-a té ka vini adan an bout, déotwa Jwif ki sòti Écha wè Pòl an Kay Bondyé-a. Yo fè sé moun-an lévé kont Pòl épi yo tjenbéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Yo hélé, “Jan Izwayèl, édé nou! Mi nonm-lan ki ka pasé toupatou ka enstwi tout moun kont lwa nou-an, kont sé jan Izwayèl-la épi kont Kay Bondyé-a. Épi mi apwézan, i ensilté Bondyé lè i mennen sé moun-an ki pa Jwif-la andidan Kay-la ki pou Bondyé yonn-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Yo di sa paski yo té wè Pòl an vil-la épi Trofimòs, an nonm ki té sòti an vil Èfésòs. Kon sa yo kwè i té ja mennenʼy andidan Kay Bondyé-a.) ");
INSERT INTO acfNT_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","La té ni twaka an tout vil-la. Sé moun-an kouwi ansanm, yo tjenbé Pòl épi yo hédiʼy dèwò Kay Bondyé-a. Menm lè-a, yo fèmé lapòt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Paditan yo té ka éséyé tjwé Pòl, konmandè sé sòlda Ronm-lan ki an Jérouzalèm-lan tann nouvèl-la mannyè la té ni twaka an tout Jérouzalèm. ");
INSERT INTO acfNT_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Menm lè-a, konmandè-a pwan déotwa ofisyé épi sòlda épi yo kouwi désann anpami sé moun-an. Lè sé moun-an wè konmandè-a épi sé sòlda-a, yo doubout bat Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Konmandè-a alé bò Pòl épi i awétéʼy épi i fè yo anchennéʼy épi dé chenn. I di, “Sa ki nonm sala? Ki sa i fè?” ");
INSERT INTO acfNT_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Yon konpanni moun té ka hélé yon bagay, an lòt konpanni té ka hélé an lòt bagay. La té ni tèlman dézòd, konmandè-a pa té sav ègzaktiman ki sa ki té fèt, kon sa i fè yo pwan Pòl épi mennenʼy mouté an kay sé sòlda-a. ");
INSERT INTO acfNT_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Lè sé sòlda-a wivé an bout mach-la, yo té ni pou lévéʼy an lézè épi pòtéʼy paski sé moun-an té vini tèlman mové. ");
INSERT INTO acfNT_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Yo tout té vini dèyèʼy épi yo té ka hélé, “Tjwéʼy! Tjwéʼy!” ");
INSERT INTO acfNT_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Kon yo té ka alé pou mennen Pòl antwé an kay sé sòlda-a, i di konmandè-a, “Mwen vlé diʼw an bagay.” Konmandè-a di, “É, é, ou ka palé Grik, alò! ");
INSERT INTO acfNT_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Mwen kwè ou sété nonm Éjipsyen sala ki té lévé kont gouvèdman-an an tan ki pasé épi i té pwan kat mil (4,000) kwiminèl yo té ka kwiyé Sé Asasen-an, épi i mennen yo an gwan savann-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pòl di, “Mwen sé on Jwif. Mwen fèt an vil Tasòs an Silisiya, ki an vil ki enpòtan an chay. Kité mwen palé bay sé moun-an.” ");
INSERT INTO acfNT_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Kon sa i di Pòl, “Ében, palé.” Pòl doubout asou mach-la épi i fè sin èk lanmenʼy, épi lè sé moun-an doubout fè dézòd, i koumansé palé ba yo an langaj sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","Pòl di yo, “Fwè mwen, papa mwen, kouté sa mwen kay di zòt pou wéponn tèt mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Lè sé Jwif-la tann i palé ba yo an langaj yo, yo vin pli dous toujou. Épi i di yo, ");
INSERT INTO acfNT_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Mwen menm sé on Jwif ki fèt an vil Tasòs an Silisiya, mé mwen lévé isi-a, an vil Jérouzalèm. Mwen apwann byen anba Ganmalyèl ki té moutwé mwen tout bagay asou mannyè-a gwan gwanpapa lontan nou-an té di nou pou viv-la, épi mwen menm té sèwyé an chay pou sèvi Bondyé, menm kon zòt yé jòdi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Mwen té pèsikité sé moun-an ki té ka swiv Chimen Jézi-a jis olanmò. Mwen awété nonm kon fanm épi mété yo an pwizon. ");
INSERT INTO acfNT_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Pli ho chèf pwèt-la épi tout manm konsèy sé Jwif-la sa di sa mwen ka di-a sé lavéwité. Sé yo menm ki té ka ban mwen lèt pou mwen té mennen bay sé fwè yo-a ki an vil Danmaskòs-la. Mwen té alé la pou mwen té sa awété sé moun-an ki kwè an Jézi-a épi pou mwen té sa mennen yo viwé Jérouzalèm kon pwizonnyé pou pini yo. ");
INSERT INTO acfNT_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Menm kon mwen té asou chimen pou wivé tou pwé Danmaskòs bò midi kon sa, an gwo klèté annèk sòti an syèl-la épi i kléwé tout oliwon mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Mwen tonbé atè épi mwen tann on vwa ka di mwen, ‘Sòl, Sòl, pouki ou ka pèsikité mwen?’ ");
INSERT INTO acfNT_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","“Mwen di, ‘Ki moun ou yé, Mèt?’ “Épi i di mwen, ‘Mwen sé Jézi, moun Nazawèt-la ou ka pèsikité-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Sé nonm-lan ki té épi mwen-an wè klèté-a, mé yo pa té konpwann vwa moun-an ki té ka palé ban mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","“Mwen di, ‘Ki sa pou mwen fè, Senyè?’ “Senyè-a di mwen, ‘Lévé épi antwé Danmaskòs, épi lè ou wivé la, yo kay diʼw tout sa Bondyé ja konmandé pouʼw sa fè.’ ");
INSERT INTO acfNT_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Klèté sala té tèlman fò i avèg mwen, épi sé nonm-lan ki té épi mwen-an tjenbé lanmen mwen épi yo mennen mwen Danmaskòs. ");
INSERT INTO acfNT_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“La té ni an nonm Bondyé yo té ka kwiyé Annannayas ki té ka obéyi lwa sé Jwif-la byen, épi tout sé Jwif-la ki té la-a té ka wèspèktéʼy toubonnman. ");
INSERT INTO acfNT_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","I vini épi i doubout a koté mwen épi i di, ‘Fwè Sòl, wè ankò!’ Épi menm lè-a mwen wè ankò épi mwen gadéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","“Annannayas di mwen, ‘Bondyé-a gwan gwanpapa lontan nou-an té ka adowé-a ja chwaziʼw pou sa konnèt volontéʼy épi pouʼw sa wè Sèvant Bondyé-a ki Dwèt-la épi pouʼw sa tann vwaʼy ka palé. ");
INSERT INTO acfNT_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Ou kay témwenʼy pouʼw sa di tout moun sé bagay-la ou ja wè-a épi tann-an. ");
INSERT INTO acfNT_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Apwézan ki sa ou ka èspéyé ankò? Lévé épi batizé, épi kwiyé asou Bondyé pouʼy lavé tout péchéʼw.’ Sé sa Annannayas di mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Mwen déviwé Jérouzalèm épi paditan mwen té ka pwédyé an Kay Bondyé-a, mwen wè an vizyon ");
INSERT INTO acfNT_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","koté mwen wè Senyè-a, épi i di mwen, ‘Fè vit épi kité Jérouzalèm vitman, paski sé moun isi-a pa kay kwè sé bagay-la ou kay di konsèné mwen-an.’ ");
INSERT INTO acfNT_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","“Mwen di, ‘Senyè, yo konnèt byen mwen té ka antwé an sé légliz sé Jwif-la épi mwen té ka awété épi bat sé moun-an ki té kwè an ou-a. ");
INSERT INTO acfNT_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Épi jis lè yo té ka tjwé témwenʼw Stivann, mwen té la tou. Mwen té dakò épi sé moun-an ki té ka tjwéʼy-la, épi sé mwen menm ki té ka tjenbé sé gwo had yo-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","“Senyè-a di mwen, ‘Alé, mwen ka voyéʼw byen lwen koté sé moun-an ki pa Jwif-la.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Sé moun-an té ka kouté Pòl pou jis tan i di i ka alé koté sé moun-an ki pa Jwif-la, mé lè yo tann sa, yo tout lévé vwa yo épi yo koumansé hélé fò, yo di, “Tiwé nonm sala asou latè-a! Tjwéʼy! I pa vo pou viv!” ");
INSERT INTO acfNT_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Yo té ka fè an chay dibwi épi yo té ka déchiwé had yo épi yo té ka voyé lapousyè an lézè-a afòs yo té faché. ");
INSERT INTO acfNT_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Konmandè-a konmandé sé sòlda-a pou mennen Pòl antwé an kay sé sòlda-a épi bat li pou fèʼy palé. I té vlé konnèt pouki sé moun-an té ka hélé kont Pòl kon sa. ");
INSERT INTO acfNT_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Mé lè sé sòlda-a mawéʼy pou yo té bat li, Pòl di ofisyé-a ki doubout la-a, “Ès lwa-a di ou sa bat on jan Ronm si ou pʼòkò menm fè lodyans pou sa?” ");
INSERT INTO acfNT_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Lè ofisyé-a tann sa, i alé koté konmandè-a épi i diʼy, “Ki sa ou ka fè-a? Nonm sala sé jan Ronm!” ");
INSERT INTO acfNT_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Konmandè-a menm alé épi i di Pòl, “Di mwen, ès ou sé jan Ronm pou vwé?” Pòl diʼy, “Wi.” ");
INSERT INTO acfNT_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Konmandè-a di, “Mwen té ni pou péyé an chay lajan pou mwen té sa vini jan Ronm.” Pòl diʼy, “Ében, mwen sé jan Ronm paski papa mwen épi manman mwen sé jan Ronm.” ");
INSERT INTO acfNT_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Lè sé nonm-lan ki té ka kwèsyonnenʼy-lan tann sa, yo hédi kò yo dèyè vitman, épi konmandè-a té pè an chay lè i wéyalizé Pòl sété jan Ronm épi i té ja anchennéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Konmandè-a té vlé sav ègzaktiman pou ki sa sé Jwif-la té ka akizé Pòl, kon sa an li denmen i fè yo déchenné Pòl épi i konmandé sé chèf pwèt-la épi tout sé manm konsèy sé Jwif-la pou asanblé, épi i mennen Pòl douvan yo. ");
INSERT INTO acfNT_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pòl gadé sé manm konsèy sé Jwif-la an mitan zyé épi i di yo, “Fwè mwen, mwen toujou té ka fè sa mwen té kwè ki bon douvan Bondyé épi pou jis jòdi-a konsyans mwen pa janmen bat mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Lè i di sa, Annannayas, pli ho chèf pwèt-la, konmandé sé nonm-lan ki té doubout bò Pòl-la pou fwapéʼy anlè bouch li. ");
INSERT INTO acfNT_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Mé Pòl diʼy, “Bondyé kay fwapéʼw tou! Ou menm kon an vyé masonn lèd yo pentiwé an blan! Ou asid la pou jijé mwen akòdans lwa-a Bondyé té bay Moziz-la, mé ou menm ka kasé lwa-a lè ou konmandé yo pou konyen mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sé nonm-lan ki té doubout tou pwé Pòl-la diʼy, “Ou ka ensilté pwèt Bondyé-a?” ");
INSERT INTO acfNT_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pòl di, “Fwè mwen, mwen pa sav sa sété pli ho chèf pwèt-la, paski lévanjil-la di, ‘Ou pa ni pou ensilté an nonm ki ka kondwi sé moun ou-an.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Lè Pòl gadé épi i wè adan sé moun-an ki té adan konsèy-la sété Sadisyen épi adan sété Fawizyen, i palé byen fò douvan yo, i di, “Fwè mwen, sé on Fawizyen mwen yé, ich an Fawizyen, épi wézon-an yo mennen mwen lodyans apwézan-an sé paski mwen ka èspéyé èk konfyans ki sé moun-an ki mò-a kay wésisité!” ");
INSERT INTO acfNT_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Menm lè-a i di sa-a, sé Fawizyen-an épi Sadisyen-an koumansé babyé épi la té ni halé kasé anpami yo tout. ");
INSERT INTO acfNT_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Sa fèt paski sé Sadisyen-an di moun pa ka wésisité, épi la pa ni ni nanj ni lèspwi, mé sé Fawizyen-an kwè an toulé twa.) ");
INSERT INTO acfNT_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","An gwo roro lévé anpami sé Jwif-la, épi déotwa Fawizyen ki sété titja lwa sé Jwif-la doubout épi yo koumansé on chikann ki té byen cho. Yo di, “Nou pa jwenn pyès fòt èk nonm sala! Pitèt on nanj ében on lèspwi dwé palé ba li vwé!” ");
INSERT INTO acfNT_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Chikann-an té ka vini tèlman cho, konmandè-a té pè yo té kay déchiwé Pòl an miyèt. Kon sa i konmandé sé sòldaʼy-la pou désann ay tiwé Pòl anpami yo épi mennenʼy mouté an kay sé sòlda-a. ");
INSERT INTO acfNT_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","An li òswè Senyè-a doubout bò Pòl épi i diʼy, “Ou pa bizwen pè! Ou ja sèvi mwen témwen an Jérouzalèm épi ou kay ni pou sèvi mwen témwen an vil Ronm tou.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","An li denmen bonmaten, déotwa Jwif jwenn ansanm pou yo fè on konplo, épi yo fè an pwonmèt douvan Bondyé èk yo di yo pa kay manjé ni bwè anyen jis tan yo tjwé Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","La té ni plis pasé kawant (40) Jwif ki té an konplo sala. ");
INSERT INTO acfNT_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Yo alé koté sé chèf pwèt-la épi sé ofisyé Jwif-la épi yo di yo, “Nou ja fè an sèman ki sèwyé an chay ki nou pa kay manjé anyen tout tan nou pa tjwé Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kon sa apwézan nou vlé ou épi sé manm konsèy-la voyé an konmisyon bay konmandè sé sòlda-a épi mandéʼy pou voyé Pòl douvan konsèy-la konmkwéki zòt vlé jwenn pli bon enfòmasyon asouʼy. Mé nou kay pawé pou nou sa tjwéʼy avan i wivé isi-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Mé on gason sésé Pòl vin konnèt sa épi i mouté an kay sé sòlda-a ay di Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Pòl kwiyé an ofisyé épi i diʼy, “Mennen tibway sala bay konmandè-a. I ni an bagay pou diʼy.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Épi ofisyé-a pwan tibway-la, i mennenʼy bay konmandè-a épi i diʼy, “Pwizonnyé-a yo ka kwiyé Pòl-la kwiyé mwen épi i di mwen mennen tibway sala baʼw paski i ni on bagay pou diʼw.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Konmandè-a tjenbé lanmen gason-an épi i mennenʼy asou koté épi i diʼy, “Ki sa ou ni pou di mwen-an?” ");
INSERT INTO acfNT_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Tibway-la di konmandè-a, “Sé Jwif-la ja dakò pou mandéʼw pou mennen Pòl douvan konsèy sé Jwif-la denmen, konmkwéki yo vlé jwenn pli bon enfòmasyon asouʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Mé pa kouté yo, paski la ni plis pasé kawant (40) nonm ki séwé asou chimen-an ka èspéyé pou yo tjwéʼy. Yo ja sèwmanté yo pa kay ni manjé ni bwè tout tan yo pa tjwé Pòl. Yo pawé pou fèʼy épi apwézan yo ka èspéyé disizyonʼw.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Konmandè-a diʼy, “Pa di pyèsonn sa ou ja di mwen-an,” épi i voyé tibway-la alé. ");
INSERT INTO acfNT_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Lè sala konmandè-a kwiyé dé an sé ofisyéʼy-la épi i di yo, “Pawé dé san (200) sòlda, ansanm épi swasant dis (70) nonm asou chouval épi dé san nonm ki amé épi pitjèt fè. Épi di yo pou pwépawé kò yo pou alé Sizariya a névè òswè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Épi bay Pòl déotwa chouval tou épi mennenʼy pouʼy sa wivé byen douvan Gouvènè Filiks.” ");
INSERT INTO acfNT_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Konmandè-a ékwi an lèt bay gouvènè-a èk i di: ");
INSERT INTO acfNT_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","Mwen Klòdiyòs Lisiyas ka voyé bonjou pou Èksélans Gouvènè Filiks: ");
INSERT INTO acfNT_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Sé Jwif-la mété lanmen anlè nonm sala épi yo té ka tjwéʼy, mé lè mwen vin konnèt sété jan Ronm i yé, mwen épi sé sòlda mwen-an alé chapéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Mwen té vlé sav pouki yo ka akizéʼy, kon sa mwen mennenʼy douvan konsèy yo-a. ");
INSERT INTO acfNT_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Mwen vin konnèt i pa fè anyen pouʼy té méwité lajòl ni pou yo tjwéʼy. Sa yo té ni kont li-a sété an bagay ki té ni pou fè épi lwa yo menm. ");
INSERT INTO acfNT_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Épi lè mwen vin sav déotwa Jwif té fè konplo pou tjwéʼy, mwen voyéʼy baʼw menm lè-a, épi mwen ja di sé moun-an ki ka akizéʼy-la pou vini douvanʼw pou fè plent yo. ");
INSERT INTO acfNT_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Sé sòlda-a fè sa yo té konmandé yo pou fè. Jou òswè sala yo pwan Pòl épi yo mennenʼy jis an vil Antipatròs. ");
INSERT INTO acfNT_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","An li denmen, sé sòlda-a ki té a pyé-a viwé an kay sé sòlda-a épi yo kité sé sòlda-a ki té asou chouval-la mennenʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Lè yo wivé an vil Sizariya, yo bay gouvènè-a lèt-la épi yo ladjé Pòl an lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Gouvènè-a li lèt-la épi i mandé Pòl ki péyi i sòti. Pòl di i sòti Silisiya. Lè Pòl diʼy sa, ");
INSERT INTO acfNT_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","i di Pòl, “Mwen kay tann ou lè sé moun-an ki akizéʼw-la wivé.” Épi i konmandé sé sòldaʼy-la pou yo mennen Pòl an gwo kay-la Hèròd té fè-a, épi i konmandé yo pou véyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Apwé senk jou, Annannayas, pli ho chèf pwèt-la, désann Sizariya ansanm épi déotwa ofisyé sé Jwif-la, épi on avoka yo kwiyé Tètilòs, épi yo alé douvan Gouvènè Filiks pou pòté plent kont Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Lè yo kwiyé Pòl antwé, Tètilòs koumansé akizéʼy. I di Filiks kon sa, “Èksélans Filiks, nou ja ni lapé pou an chay tan anba kondwit ou. Ou ja fè an chay bon chanjman an péyi-a paski ou sé an nonm ki ni lèspwi. ");
INSERT INTO acfNT_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Nou ka wimèsyéʼw ofon tjè nou pou tout sé bon bagay-la ou toujou ka fè-a toupatou. ");
INSERT INTO acfNT_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Mwen pa vlé pwan twòp tanʼw, kon sa mwen ka diʼw tanpwi souplé, pwan an ti pasyans épi kouté nou. Nou pa kay palé tèlman. ");
INSERT INTO acfNT_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Nou sav nonm sala anbétan an chay. I ka fè tout sé Jwif-la bay twaka toupatou an latè-a, épi sé li ki chèf patizan-an yo ka kwiyé Nazawiyen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","I té jis ensilté Bondyé lè i mennen sé moun-an ki pa Jwif-la andidan Kay-la yo té mété apa bay Bondyé-a. Kon sa nou mété lanmen anlèʼy épi nou awétéʼy. Nou té vlé sèvi lwa nou menm pou jijéʼy, ");
INSERT INTO acfNT_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","mé Konmandè Lisiyas vini épi i té bwital épi nou. I halé Pòl lanmen nou ");
INSERT INTO acfNT_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","épi i di sé moun-an ki ka akizéʼy-la sipozé vini douvanʼw. Si ou kwèsyonnen nonm sala, ou kay wè pou kòʼw tout sé bagay-la nou ka akizéʼy-la sé bagay ki vwé.” ");
INSERT INTO acfNT_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Sé Jwif-la té dakò épi Tètilòs épi yo di, “Wi, sé bagay sala vwé!” ");
INSERT INTO acfNT_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Gouvènè-a fè sin épi lanmenʼy bay Pòl pouʼy palé. Pòl di, “Mwen sav ou sé an jij pou nasyon sala pou an pil tan, épi mwen kontan pou mwen sa doubout douvanʼw pou mwen sa fè défans kò mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Si ou fouyé dèyè sa, ou kay wè pou kòʼw sé pa manti mwen ka manti. I pa té ni plis pasé douz jou ki pasé dépi mwen mouté Jérouzalèm pou ay adowé Bondyé, ");
INSERT INTO acfNT_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","épi sé Jwif-la pa jwenn mwen ka chikannen épi pyèsonn andidan Kay Bondyé-a, ni mwen pa té ka fè pyèsonn bay twaka ni an sé légliz sé Jwif-la ni pyès lòt koté an vil-la. ");
INSERT INTO acfNT_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Ni yo pyès pa sa moutwé sé bagay-la yo ka di asou mwen la-a vwé. ");
INSERT INTO acfNT_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Mé kité mwen diʼw sa: Kon yon moun ki ka swiv chimen-an Jézi moutwé-a, mwen ka sèvi menm Bondyé-a gwan gwanpapa lontan nou-an té ka adowé-a. Sé Jwif-la di Chimen Jézi sé pa bon chimen-an, mé mwen ka kwè tout sé bagay-la Moziz épi sé pwòfèt-la ékwi an sé liv yo-a. ");
INSERT INTO acfNT_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Menm kon sé nonm sala, mwen ni èspwa an Bondyé. Mwen ni èspwa-a ki tout moun, ni bon ni mové, kay wésisité. ");
INSERT INTO acfNT_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Sé pou sa mwen toujou ka fè sa ki bon pou konsyans mwen pa wipwoché mwen douvan Bondyé épi douvan lézòm. ");
INSERT INTO acfNT_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Apwé mwen kité Jérouzalèm pou an chay lanné, mwen witounen la pou mwen té mennen lajan pou édé sé moun mwen-an épi pou mwen bwilé sakwifis bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Sé paditan mwen té ka fè sa, yo jwenn mwen an Kay Bondyé-a. Mwen té ja fin fè sèvis pou pwépawé kò mwen pou adowé Bondyé. La pa té ni an chay moun épi mwen, épi la pa té ni pyèsonn ka bay twaka. ");
INSERT INTO acfNT_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Mé déotwa Jwif ki té sòti Écha té la, épi yo menm té sipozé vini douvanʼw pou yo té akizé mwen si yo té ni on bagay kont mwen, ");
INSERT INTO acfNT_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","ében kité sé nonm sala ki isi-a diʼw ki mové bagay yo jwenn mwen fè lè mwen té doubout douvan konsèy yo-a. ");
INSERT INTO acfNT_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Mé an sèl bagay mwen té fè, mwen palé fò lè mwen té doubout douvan yo. Mwen di, ‘Zòt ka jijé mwen jòdi-a paski mwen kwè sé moun-an ki mò-a kay wésisité.’ ” ");
INSERT INTO acfNT_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Filiks, ki té konnèt an chay asou Chimen Jézi-a, anvoyé lodyans-lan épi i di, “Lè Konmandè Lisiyas wivé, mwen kay bay jijman mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","I konmandé ofisyé-a pou véyé Pòl byen mé ba li ti tak libèté, épi kité sé janʼy-lan ba li sa i bizwen. ");
INSERT INTO acfNT_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Apwé déotwa jou, Filiks vini épi madanm li Drousila, ki sété an Jwif. I voyé chaché Pòl épi i koutéʼy lè i té ka palé asou mannyè i vini kwè an Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Mé kon Pòl kontiné ka palé asou mannyè pou vini dwèt douvan Bondyé, épi mannyè pou kondwi kòʼw, épi asou jou jijman-an ki pou vini-an, Filiks vini pè épi i di Pòl, “Ou sa alé apwézan. Mwen kay voyé kwiyéʼw ankò lè mwen jwenn on chans.” ");
INSERT INTO acfNT_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","A menm lè-a, i té ka èspéyé Pòl té kay ba li lajan an séwan, kon sa chak ti lè i té kay voyé kwiyéʼy pou palé épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Apwé dé lanné pasé, Pòchyòs Fèstòs vini gouvènè laplas Filiks. Filiks menm té vlé sé Jwif-la kontanʼy, kon sa i kité Pòl an pwizon. ");
INSERT INTO acfNT_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Twa jou apwé Gouvènè Fèstòs wivé an péyi-a, i kité vil Sizariya épi i alé an vil Jérouzalèm, ");
INSERT INTO acfNT_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","épi sé chèf pwèt-la épi sé Jwif-la ki té enpòtan-an pawèt douvanʼy pou fè plent kont Pòl. Yo mandé Fèstòs yon favè ");
INSERT INTO acfNT_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","pou mennen Pòl désann Jérouzalèm, paski yo té ja fè konplo anpami yo pou yo té sa tjwé Pòl asou chimen. ");
INSERT INTO acfNT_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Fèstòs di, “Pòl sé on pwizonnyé an Sizariya, épi mwen menm kay déviwé la touswit. ");
INSERT INTO acfNT_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Sé chèf zòt-la ni pou annou Sizariya épi mwen épi zòt kay akizéʼy la si i ja fè anyen ki pa bon.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Fèstòs pasé an lòt ywit ében dis jou épi yo an Jérouzalèm épi i viwé Sizariya. An li denmen, i asid an plas li kon jij épi i konmandé pou mennen Pòl antwé. ");
INSERT INTO acfNT_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Lè Pòl wivé, sé Jwif-la ki té sòti Jérouzalèm-lan fè wonʼy épi yo koumansé mennen an chay mové akizasyon kont Pòl, mé yo pa té sa moutwé sa yo té ka di-a té vwé. ");
INSERT INTO acfNT_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Mé Pòl fè défans kòʼy épi i di, “Mwen pa janmen fè anyen kont lwa sé Jwif-la ni kont Kay Bondyé-a ni kont Wa Siza.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Mé Fèstòs té vlé sé Jwif-la kontanʼy, kon sa i mandé Pòl, “Ès ou kay vlé alé Jérouzalèm pou mwen sa jijéʼw asou sé plent sala?” ");
INSERT INTO acfNT_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pòl di, “Mwen doubout an kay lodyans Wa Siza-a koté ou sipozé jijé mwen-an. Kon ou menm sav, mwen pa fè sé Jwif-la anyen ki mové. ");
INSERT INTO acfNT_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Si mwen dézobéyi lwa-a èk fè anyen ki méwité lanmò, mwen pa ka wifizé lanmò. Mé si la pa ni pyès lavéwité an sé akizasyon-an yo fè kont mwen-an, pyèsonn pa ni dwa ladjé mwen an lanmen sé Jwif sala. Mwen vlé Wa Siza jijé mwen.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Apwé Fèstòs konsilté épi sé nonm-lan ki té ka ba li konsèy-la, i di Pòl, “Sé douvan Wa Siza ou vlé alé? Ében, sé douvan Wa Siza ou kay alé.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Déotwa tan apwé sa, Wa Agripa épi Bènis vini Sizariya pou sa vizité Gouvènè Fèstòs. ");
INSERT INTO acfNT_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Apwé yo té la pou konmen jou, Fèstòs wakonté sitiwasyon Pòl bay wa-a. I di, “Mwen ni an nonm isi-a Gouvènè Filiks té kité an pwizon, ");
INSERT INTO acfNT_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","épi lè mwen té alé Jérouzalèm, sé chèf pwèt-la épi sé ofisyé Jwif-la pòté plent kont li épi yo té vlé mwen kondannéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","“Mé mwen di yo yon jan Ronm pa ni dwa ladjé on pwizonnyé an lanmen sé moun-an ki ka akizéʼy-la avan nonm sala ni on chans pouʼy sa wéponn tèt li douvan fidji sé moun-an ki ka akizéʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Lè sé Jwif-la vini isi-a, mwen pa pèdi pyès tan. An li denmen menm mwen asid an plas mwen kon jij épi mwen konmandé pou mennen nonm-lan antwé. ");
INSERT INTO acfNT_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Sé moun-an ki té ka akizéʼy-la doubout, mé yo pa akizéʼy asou pyès mové bagay kon mwen té kwè yo té kay fè. ");
INSERT INTO acfNT_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Sété on chikann yo té ni épi nonm-lan asou wilizyon yo menm épi asou an nonm yo té ka kwiyé Jézi ki ja mò, mé Pòl di nonm sala wésisité. ");
INSERT INTO acfNT_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Mwen pa té sav ki mannyè pou mwen té jwenn enfòmasyon asou sé bagay sala, kon sa mwen mandé Pòl ès i kay vlé alé Jérouzalèm pou mwen sa jijéʼy asou sé bagay sala. ");
INSERT INTO acfNT_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Mé lè Pòl mandé pou Wa Siza jijéʼy, mwen konmandé pou yo kitéʼy an pwizon pou jis tan mwen kay sa voyéʼy alé bay Siza.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Wa Agripa di Fèstòs, “Mwen vlé tann nonm sala pou kò mwen.” Fèstòs diʼy, “Ében, denmen ou kay tann li.” ");
INSERT INTO acfNT_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","An li denmen, Wa Agripa épi Bènis vini an gwo chanm-lan moun ka asanblé-a épi yo antwé épi yo fè an gwan séwémonni ansanm épi tout sé chèf militè-a épi sé gwo zòm vil-la. Fèstòs konmandé pou yo mennen Pòl antwé. ");
INSERT INTO acfNT_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Fèstòs di, “Wa Agripa, ou épi tout sé moun-an ki isi-a, mi nonm sala. Tout sé Jwif-la, ni isi-a épi ni an Jérouzalèm ja akizéʼy douvan mwen, épi yo ka hélé fò i sipozé mò. ");
INSERT INTO acfNT_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Mwen menm pʼòkò jwenn anyen i fè pou mwen sa kondannéʼy pou mò, mé paski i menm di i vlé alé douvan Wa Siza pou Siza jijéʼy, mwen ja désidé pou sa voyéʼy an vil Ronm. ");
INSERT INTO acfNT_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Mé mwen pa ni anyen pou mwen sa ékwi bay Siza asou nonm sala. Mwen ja mennenʼy douvan zòt tout, épi èspwèsman douvan ou, Wa Agripa. Apwé ou fin kwèsyonnen nonm sala, mwen dwé kay ni on bagay pou mwen sa ékwi asouʼy bay Siza. ");
INSERT INTO acfNT_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Sa sé kouyontwi pou mwen voyé on nonm bay Siza san mwen di sa i fè.” ");
INSERT INTO acfNT_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Agripa di Pòl, “Mwen baʼw dwa pou palé pou kòʼw.” Pòl lévé lanmenʼy épi i koumansé palé, ");
INSERT INTO acfNT_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","i di, “Wa Agripa, pa ti kontan mwen kontan pou mwen sa wéponn tèt mwen douvanʼw jòdi-a kont tout sé bagay-la sé Jwif-la ka akizé mwen-an, ");
INSERT INTO acfNT_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","sitou, paski mwen sav ou konnèt byen tout twadisyon sé Jwif-la épi tout sé kwèsyon-an ki ka mennen chikann anpami yo, kon sa mwen ka mandéʼw pou pwan an ti pasyans épi kouté mwen byen. ");
INSERT INTO acfNT_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Tout sé Jwif-la konnèt mannyè mwen ja viv dépi mwen té jenn, dépi an koumansman lavi mwen an péyi mwen menm épi an Jérouzalèm tou. ");
INSERT INTO acfNT_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Yo konnèt mwen dépi lontan. Épi si yo vlé, yo sa diʼw mwen té viv kon an Fawizyen, konpanni-an ki ka obéyi lwa wilizyon Jwif-la pli byen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Èk atjwèlman mwen doubout isi-a pou yo jijé mwen paski mwen ka èspéyé èk konfyans ki Bondyé kay tjenn pwonmèt-la i té fè pou gwan gwanpapa lontan nou-an. ");
INSERT INTO acfNT_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Sé menm pwonmèt sala douz nasyon-an ki an fanmi nou-an ka èspéyé èk konfyans pou wisivwè-a. Yo ka adowé Bondyé lajouné kon lannwit pou yo wisivwè menm pwonmèt-la mwen ka èspéyé-a. Wa mwen, sé Jwif-la ka akizé mwen paski mwen ka èspéyé pou menm pwonmèt-la yo ka èspéyé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Pouki zòt menm Jwif pa kwè Bondyé ka wésisité moun ki mò? ");
INSERT INTO acfNT_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Mwen menm té kwè sété an bon bagay mwen té ka fè lè mwen té ka pèsikité sé moun-an ki kwè an Jézi-a, nonm Nazawèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Épi sé sa mwen té fè an Jérouzalèm. Sé chèf pwèt-la ban mwen dwa pou mwen té mété an pil an sé moun-an ki kwè an Jézi-a an pwizon, épi lè yo té kondanné yo pou lanmò, mwen té dakò épi sa. ");
INSERT INTO acfNT_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","An chay fwa an tout sé légliz sé Jwif-la mwen té ka pini sé moun-an ki kwè an Jézi Kwi-a pou mwen té fè yo di yo pa kwè an Jézi ankò. Mwen té faché kont yo tèlman mwen té ka alé jis an sé lézòt péyi-a pou mwen té sa pèsikité yo. ");
INSERT INTO acfNT_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Sété pou wézon sala sé chèf pwèt-la té ban mwen pèwmisyon épi pouvwa pou mwen té sa alé Danmaskòs. ");
INSERT INTO acfNT_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Wa mwen, lè mwen té asou chimen-an, i té bò midi kon sa, mwen wè on klèté ki sòti an syèl-la ki té ka kléwé plis pasé sòlèy-la épi i kléwé oliwon mwen épi oliwon sé moun-an ki té ka voyajé épi mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Nou tout tonbé atè, épi mwen tann on vwa palé ban mwen an langaj sé Jwif-la épi i di mwen, ‘Sòl, Sòl, pouki ou ka pèsikité mwen? Ou ka fè mal bay kòʼw menm kon on bouwik ki ka voyé pat dèyè baton mèt li.’ ");
INSERT INTO acfNT_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","“Mwen di, ‘Ki moun ou yé, Mèt?’ “Épi Senyè-a wéponn, i di, ‘Mwen sé Jézi, moun-an ou ka pèsikité-a. ");
INSERT INTO acfNT_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Lévé doubout asou pyéʼw paski mwen ja pawèt douvanʼw pou chwaziʼw kon sèvant mwen épi pouʼw sa di lézòt moun sa ou ja wè mwen fè jòdi-a épi sa ou kay wè an tan ki kay vini. ");
INSERT INTO acfNT_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Épi mwen kay chapéʼw anba lanmen sé moun ou-an épi anba lanmen sé moun lòt nasyon-an. Mwen kay voyéʼw ");
INSERT INTO acfNT_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","pouʼw sa ouvè zyé yo pou fè yo tounen kont nwèsè pou klèté, pou tiwé yo anba pouvwa Satan pou vin jwenn Bondyé. Kon sa lè yo mété lafwa yo an mwen, Bondyé kay pawdonnen péché yo épi yo kay jwenn an plas anpami sé moun-an Bondyé ja chwazi-a.’ ");
INSERT INTO acfNT_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Épi sé kon sa, Wa Agripa, mwen pa dézobéyi vizyon-an mwen té wè sòti an syèl-la. ");
INSERT INTO acfNT_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Pwèmyéman mwen pwéché an Danmaskòs, épi mwen pwéché Jérouzalèm épi apwé sa an tout péyi Joudiya, épi mwen pwéché bay sé moun lòt nasyon-an tou. Mwen di yo tounen hòd péché yo épi vin jwenn Bondyé, épi fè bagay pou moutwé lavi yo ja chanjé. ");
INSERT INTO acfNT_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Pou wézon sala, sé Jwif-la mété lanmen anlè mwen an Kay Bondyé-a épi yo té éséyé tjwé mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Mé pou jis jòdi-a Bondyé ka édé mwen, épi sé pou sa mwen douvanʼw ka bay témwenyaj sala, ni pou gwan ni pou piti. Sa mwen ka di-a sé menm sé bagay-la sé pwòfèt-la épi Moziz té di ki kay fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","Yo té di Jézi Kwi ni pou soufè épi i kay pwèmyé moun pou wésisité, pou sa moutwé sé Jwif-la épi sé moun-an ki pa Jwif-la klèté-a.” ");
INSERT INTO acfNT_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Paditan Pòl té ka palé kon sa pou fè défans kòʼy, Fèstòs hélé dèyèʼy, i di, “Pòl, ou fou! Ou ja étidyé twòp épi sa fèʼw fou!” ");
INSERT INTO acfNT_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Pòl wéponn, i di, “Mwen pa fou, Èksélans Fèstòs! Sa mwen ka di-a vwé! Sa sé pa pawòl kouyon! ");
INSERT INTO acfNT_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Wa Agripa konnèt tout sé bagay sala mwen ka di-a, épi sé pou sa mwen pa pè palé ba li. Mwen asiwé i konnèt tout sé bagay sala, paski yo pa té fèt an séwan. ");
INSERT INTO acfNT_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","Wa Agripa, ou kwè sa sé pwòfèt-la ékwi-a? Mwen sav ou kwè!” ");
INSERT INTO acfNT_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Wa Agripa wéponn, i di, “Pòl, ou kwè an ti mouman sala ou sa fè mwen vini an Kwityen otan ézé?” ");
INSERT INTO acfNT_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pòl di, “Menm si sé atjwèlman ében pli ta, mwen ka pwédyé bay Bondyé, ni pouʼw ni pou zòt tout ki ka kouté mwen jòdi-a, pou yon lè zòt kay vini menm kon mwen menm — antiwan pou sé chenn sala mwen ni an lanmen mwen-an!” ");
INSERT INTO acfNT_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Lè sala wa-a, gouvènè-a épi Bènis épi sé lézòt-la lévé ");
INSERT INTO acfNT_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","épi lè yo té ka alé, yo di bay yonn a lòt, “Nonm sala pa fè anyen ki méwité lanmò ni météʼy an pwizon.” ");
INSERT INTO acfNT_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Épi Agripa di Fèstòs, “Ou té sa ladjé nonm sala si i pa té di i vlé ay plédé plent li douvan Wa Siza.” ");
INSERT INTO acfNT_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Lè yo désidé pou fè nou pwan batiman pou alé péyi Itali, yo pwan Pòl épi déotwa lézòt pwizonnyé épi ladjé yo an lanmen Jouliyòs, an chèf an gany sé sòlda-a yo ki té ka kwiyé Batalyon Siza-a. ");
INSERT INTO acfNT_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Nou batjé an batiman ki té sòti Adranmitiyòm épi i té pawé pou alé an diféwan plas an Écha, kon sa nou pati alé. Aristakòs té épi nou. I té sòti an vil Tèsalonnika ki an Masédonnya. ");
INSERT INTO acfNT_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","An li denmen nou wivé Sidon, épi Jouliyòs té bon pou Pòl. I kitéʼy alé atè pouʼy ay wè janʼy, pou yo té sa ba li sa i té bizwen. ");
INSERT INTO acfNT_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Nou pati ankò épi van-an té tèlman kont nou, nou té ni pou pasé bò péyi Saypròs koté van-an pa té ka vanté tèlman fò-a. ");
INSERT INTO acfNT_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Nou twavèsé lanmè-a douvan Silisiya épi Panfiliya, épi nou kòsté an vil Mira ki an Lisya. ");
INSERT INTO acfNT_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Lè nou wivé la, chèf sòlda-a jwenn on batiman ki té sòti Alèkzandriya ki té ka alé Itali, kon sa i batjé nou abò-a. ");
INSERT INTO acfNT_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Batiman-an alé dousman pou tibwen jou, épi nou té ni an chay twaka, mé alafen nou wivé bò vil Nidous. Van-an pa té ka kité nou alé pli lwen an diwèksyon sala, kon sa nou pasé anba bouden Krit, koté van-an pa té ka vanté-a jis tan nou pasé bò Kap Salmonn. ");
INSERT INTO acfNT_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","Nou pasé tou pwé tè, mé nou té ni an chay twaka jis tan nou wivé adan on plas yo ka kwiyé Bon Lawad, tou pwé vil Lasi-a. ");
INSERT INTO acfNT_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Nou té ja pèdi tibwen tan, épi jou-a sé Jwif-la té ka wèsté san manjé pou sélébwé pawdonnasyon péché-a té ja pasé. Lè sala i té ja vini danjéwé an chay pou té kontiné asou voyaj-la. Kon sa Pòl ba yo an bon konsèy, ");
INSERT INTO acfNT_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","i di yo, “Mésyé, mwen wè voyaj nou kay danjéwé an pil pou nou. Nou kay pèd batiman-an épi chay-la ki andidanʼy-lan, épi jis moun ki kay mò tou.” ");
INSERT INTO acfNT_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Mé chèf sòlda Ronm-lan té ni pli konfyans an pawòl kaptenn-an épi mèt batiman-an pasé an pawòl Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Lawad-la sé pa té an bon lawad pou pasé tan fwédi-a, kon sa pwèskè tout sé nonm-lan té vlé pwan chans-lan pou pati alé pou nou wivé Finiks si i té posib, pou nou té sa pasé tan fwédi-a la. Finiks sé on vil ki an Krit. La té ni an lawad ki té ni dé diféwan diwèksyon, yonn asou gòch sòlèy kouchan épi yonn asou dwèt sòlèy kouchan. ");
INSERT INTO acfNT_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","An ti van koumansé vanté pa anba, épi sé nonm-lan té kwè yo té kay sa wivé Finiks, kon sa yo lévé tjò fè-a ki ka tjenbé batiman-an épi yo voyajé tou pwé péyi Krit. ");
INSERT INTO acfNT_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Mé adan an ti mouman an gwo van mové tan sòti pa anlè tè-a ka désann, van sala té sòti asou gòch sòlèy lévan. ");
INSERT INTO acfNT_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","Van-an pwan batiman-an, épi lè yo wè i té enposib pou yo té kondwi batiman-an an van-an, yo kité van-an mennen yo alé koté i té vlé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Lè nou wivé an bout ti lilèt-la yo ka kwiyé Kòda-a, nou jwenn an ti soulajman, épi apwé an chay twaka nou chapé ti kannòt-la ki té bò batiman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Yo hédi kannòt-la mouté abò-a, épi yo mawé kòd byen séwé tout oliwon batiman-an pouʼy pa té sa kwazé. Yo kwè batiman-an té kay touché sab bò Libya, kon sa yo bésé vwèl-la épi yo kité van-an mennen yo alé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Van mové tan-an kontiné ka bat nou pli wèd toujou, kon sa an li denmen yo koumansé jété chay ki té abò batiman-an an dlo. ");
INSERT INTO acfNT_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Jou apwé sa, yo jété adan sé ikwipman-an ki té an batiman-an an dlo èk lanmen yo. ");
INSERT INTO acfNT_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Nou pa té ka wè ni sòlèy ni étwal pou konmen jou, épi van mové tan-an kontiné ka vanté fò toujou, épi nou pa té wè pyès mannyè nou té kay chapé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Apwé sé nonm-lan té wèsté an chay tan san manjé, Pòl doubout douvan yo épi i di yo, “Mésyé, zòt té sipozé kouté mwen lè mwen té di zòt pa kité Krit. Nou pa té kay jwenn otan donmaj épi nou pa té kay pèd otan bagay. ");
INSERT INTO acfNT_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Mé atjwèlman mwen ka di zòt pwan tjè! Pa yonn an zòt ki kay pèd laviʼy. Sé batiman-an yonn nou kay pèd. ");
INSERT INTO acfNT_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Mwen konnèt sa, paski yè òswè Bondyé ki mèt-la mwen ka sèvi-a, voyé on nanj pawèt douvan mwen. ");
INSERT INTO acfNT_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","I di mwen, ‘Pòl, pa pè! Ou ni pou wivé douvan Siza, épi pou lapétiʼw Bondyé kay sové lavi tout sé moun-an ki ka voyajé épiʼw-la.’ ");
INSERT INTO acfNT_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Kon sa mésyé, pwan tjè, paski mwen asiwé Bondyé kay fè tout sa i di mwen-an, ");
INSERT INTO acfNT_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","mé van-an kay voyé batiman-an alé asou tè.” ");
INSERT INTO acfNT_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","I té ni katòz nwit dépi van-an té ka malmennen nou an Lanmè Mèditaréniyann-an. Lè i wivé bò mennwit kon sa, sé nonm-lan ki té ka navidjé batiman-an, yo apèsivwè yo té ka wivé tou pwé tè. ");
INSERT INTO acfNT_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Kon sa yo ladjé an kòd ki té ni an plon mawé adanʼy épi yo jwenn la té ni ven (20) bwas dlo. Lè yo alé pli douvan, yo ladjé kòd-la désann ankò épi yo jwenn i té bò kenz (15) bwas dlo. ");
INSERT INTO acfNT_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Yo té pè batiman-an té kay kwazé asou kayè-a, kon sa yo ladjé kat tjò fè pa an bout batiman-an épi yo té ka mandé pou jou ouvè. ");
INSERT INTO acfNT_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Sé nonm-lan ki té ka navidjé batiman-an té vlé tiwé kò yo abò batiman-an, kon sa yo ladjé ti kannòt-la an dlo pou yo fè akwèdi sé tjò fè yo té kay mawé an lavan batiman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Kon sa Pòl di chèf sòlda Ronm-lan épi sé sòlda-a, “Si sé nonm sala pa wèsté abò batiman-an, zòt pyès pa kay chapé!” ");
INSERT INTO acfNT_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Lè Pòl di yo sa, sé sòlda-a koupé kòd-la ki té tjenbé ti kannòt-la épi yo kité van-an chayéʼy alé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Lè jou té ka alé pou ouvè, Pòl ankouwajé yo tout pou manjé. I di, “Jòdi-a ka bay katòz jou dépi zòt ka èspéyé, épi zòt pʼòkò manjé anyen. ");
INSERT INTO acfNT_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Souplé, manjé tak manjé atjwèlman. Zòt kay bizwenʼy pou viv. Pa menm on bwanch an chivé zòt ki kay pèd.” ");
INSERT INTO acfNT_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Apwé Pòl fin di yo sa, i pwan pen épi i wimèsyé Bondyé douvan yo tout épi i kaséʼy épi i koumansé manjé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Lè yo wè sa, yo tout pwan tjè épi yo menm koumansé manjé. ");
INSERT INTO acfNT_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","La té ni dé san swasant sèz (276) an nou ki té abò batiman-an. ");
INSERT INTO acfNT_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Lè tout moun fin manjé bouden yo wèd, yo jété lèstan sé gwenn-an an lanmè-a pou té sa fè batiman-an pli léjè. ");
INSERT INTO acfNT_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Lè jou ouvè, yo pa té sav ki tè yo té wè-a, mé yo wè on lans ki té ni bèl sab, kon sa yo désidé yo kay éséyé fè batiman-an antwé asou sab-la. ");
INSERT INTO acfNT_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Kon sa yo koupé kòd-la ki té ka tjenbé sé tjò fè-a épi yo kitéʼy an dlo-a. Menm lè-a, yo démawé kòd-la ki té ka mawé sé gouvènay-la, épi yo hosé vwèl-la ki té douvan batiman-an, pou van-an té sa pousé batiman-an alé atè, épi yo alé douvan. ");
INSERT INTO acfNT_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Mé batiman-an mouté asou an koté ki plat. Bout douvan-an pwi épi i pa té sa alé pyès koté, épi a menm lè-a sé gwo lanm-lan té ka kwazé bout dèyè-a. ");
INSERT INTO acfNT_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Sé sòlda-a fè on plan pou yo tjwé tout sé pwizonnyé-a pou yo pa té sa najé atè épi chapé kò yo, ");
INSERT INTO acfNT_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","mé chèf sòlda Ronm-lan anpéché yo fè sa paski i té vlé sové Pòl. Kon sa i konmandé tout sa ki sa najé pou soté an dlo pwèmyé épi najé atè, ");
INSERT INTO acfNT_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","épi sé lézòt-la kay swiv yo. Yo kay tjenbé planch ében lézòt mòso bwa ki sòti an batiman-an. Épi sé kon sa nou tout wivé atè byen. ");
INSERT INTO acfNT_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Lè nou fin chapé, nou vin apwann yo té ka kwiyé plas sala Malta, ");
INSERT INTO acfNT_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","épi sé moun-an ki té ka wèsté la-a té bon pou nou. Lapli koumansé kwévé épi i té ka fè fwèt, kon sa yo limen an gwo boukan difé ban nou épi yo wisivwè nou tout. ");
INSERT INTO acfNT_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pòl anmasé on patjé bwa pouʼy té mété anlè difé-a. Menm kon i ka fè sa, on sèpan sòti an patjé bwa-a lè i santi chalè-a épi i mòdé Pòl an lanmenʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Lè sé moun péyi-a wè sèpan-an ka pann an lanmen Pòl, yo di bay yonn a lòt, “Nonm sala oblijé sé on nonm ki ja tjwé moun. Menm si i pa mò an lanmè-a, Jistis pa kay kitéʼy chapé.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Mé i soukwé sèpan-an an difé-a, épi anyen pa wivé Pòl. ");
INSERT INTO acfNT_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Sé moun-an té ka èspéyé pouʼy té anflé ében pouʼy té tonbé atè-a épi mò, mé lè yo wèsté an chay tan épi yo pa wè sa fèt, yo chanjé lidé yo épi yo di, “Nonm sala sé an bondyé!” ");
INSERT INTO acfNT_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Tou pwé koté nou té yé-a, té ni on bitasyon ki sété sa Poublyòs, pli gwo chèf an plas-la. I wisivwè nou byen, épi pou twa jou nou wèsté lakay li kon janʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Papa Poublyòs menm té malad, i té kouché épi yon lafyèv épi i té ni wilachman. Kon sa Pòl antwé an chanm-lan koté i té yé-a, épi apwé i pwédyé, i mété lanmenʼy anlè nonm-lan épi i djéwiʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Lè Pòl fè sa, tout sé lézòt moun-an ki té malad an péyi-a té ka vini, épi i djéwi yo. ");
INSERT INTO acfNT_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","11","Yo ban nou an chay kado. Nou wèsté la pou twa mwa, épi avan nou pati, yo batjé tout sa nou té kay bizwen pou voyaj-la. Nou batjé an batiman yo té ka kwiyé Jimo-a, ki té sòti Alèkzandriya. I té pasé sézon fwédi-a an plas-la koté nou té yé-a. ");
INSERT INTO acfNT_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Nou wivé an vil Sirakyouz épi nou wèsté la pou twa jou. ");
INSERT INTO acfNT_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Lè nou kité la, nou kontiné voyaj-la épi nou wivé an vil Règiyim. An li denmen nou pati, épi on van koumansé vanté asou gòch sòlèy kouché, épi jou apwé sa nou wivé Poutiyoli. ");
INSERT INTO acfNT_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","La nou jwenn épi déotwa fwè, épi yo mandé nou pou wèsté épi yo pou yon simenn, épi sé kon sa nou wivé an vil Ronm. ");
INSERT INTO acfNT_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Sé fwè-a ki té an vil Ronm-lan té tann nou té ka vini, épi yo vini jwenn nou jis laplas Apiyòs épi an vil Twa Kabawé-a. Épi lè Pòl wè yo, i wimèsyé Bondyé, épi sa té ankouwajéʼy an chay. ");
INSERT INTO acfNT_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Lè nou wivé an vil Ronm, yo bay Pòl pèwmisyon pouʼy wèsté pa kòʼy, mé yo mété an sòlda pou té sa véyéʼy. ");
INSERT INTO acfNT_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Apwé twa jou, Pòl kwiyé tout chèf sé Jwif-la ki té an vil Ronm-lan ansanm. Lè yo té asanblé, Pòl di yo, “Fwè mwen, magwé mwen pa fè anyen kont sé moun nou-an ében anyen kont twadisyon gwan gwanpapa lontan nou, sé Jwif-la an Jérouzalèm awété mwen épi yo ladjé mwen an lanmen sé jan Ronm-lan. ");
INSERT INTO acfNT_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Lè yo fin kwèsyonnen mwen, yo té vlé ladjé mwen paski yo di yo pa wè mwen fè anyen pou mwen méwité lanmò. ");
INSERT INTO acfNT_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Mé sé Jwif-la té kont sa épi yo fòsé mwen pou mwen té mennen plent mwen bay Wa Siza, magwé mwen pa ni pyès akizasyon kont sé moun mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Sé pou sé wézon sala mwen mandé pou wè zòt épi palé bay zòt. Yo mété mwen an chenn sala pou lapéti sovè-a sé jan Izwayèl-la ka èspéyé èk konfyans-lan.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Sé Jwif vil Ronm-lan di Pòl, “Nou pa wisivwè pyès lèt ki sòti Joudiya konsènéʼw, ni pyès sé moun nou-an pa sòti la épi pyès nouvèl, ni yo pa di anyen ki mové asouʼw. ");
INSERT INTO acfNT_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Mé nou kay vlé konnèt ki sa ki an lidéʼw, paski nou konnèt toupatou moun ka palé kont gany-lan ou andidanʼy-lan.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Kon sa yo mété on dat pou yo asanblé ansanm, épi jou sala pli moun vini koté Pòl té ka wèsté-a. Pòl pwan dépi bonmaten pou jis òswè épi i wakonté yo mannyè nèf-la Bondyé ka kondwi sé moun li-an. I éséyé fè yo kwè an Jézi lè i té ka enstwi yo tout sé bagay-la Moziz épi sé pwòfèt-la ékwi an sé liv yo-a. ");
INSERT INTO acfNT_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Adan sa ki té la-a té kwè sa Pòl di-a, mé adan pa té kwè. ");
INSERT INTO acfNT_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Lè yo pati, yo té ka chikannen anpami yo paski Pòl té di yo dènyé ti bagay sala, i di, “Lèspwi Bondyé byen palé lè i té bay pwòfèt Izaya konmisyon-an bay gwan gwanpapa lontan zòt. Mi sa i té di: ");
INSERT INTO acfNT_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Alé koté sé moun sala épi di yo, “Ou kay kouté èk kouté, mé ou pa kay konpwann. Ou kay gadé èk gadé, mé ou pa kay wè.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Paski sé moun sala ja fèmé lidé yo, yo ja fèmé zòwèy yo, épi yo ja fèmé zyé yo. Si pa té sa, zyé yo té kay wè, zòwèy yo té kay tann, lidé yo té kay konpwann, épi yo té kay vin jwenn mwen, épi mwen té kay djéwi yo.’ Sé Bondyé menm ki di sa.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Épi Pòl di yo, “Mwen vléʼw sav Bondyé ja voyé konmisyon salvasyonʼy bay sé moun-an ki pa Jwif-la. Yo kay kouté.” ");
INSERT INTO acfNT_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Lè Pòl fin di yo sa, sé Jwif-la kité épi yo té ni an mové chikann anpami yo. ");
INSERT INTO acfNT_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pou dé lanné Pòl wèsté adan an kay i té ka lwé, épi i wisivwè tout moun ki té ka vini wèʼy ");
INSERT INTO acfNT_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","épi i enstwi yo konsèné Senyè Jézi Kwi. Épi i pwéché asou mannyè nèf-la Bondyé ka kondwi sé moun li-an. I pa té ni pyès lapè lè i té ka pwéché, épi pyèsonn pa chachéʼy kont.");
INSERT INTO acfNT_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","Sé mwen Pòl, ki an sèvant Jézi Kwi Bondyé kwiyé pou vini an zapòt épi i chwazi mwen pou pwéché Bon Nouvèl-la. ");
INSERT INTO acfNT_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","Bondyé té ja pwonmèt Bon Nouvèl-la an chay tan ki pasé, lè i té fè sé pwòfèt-la matjéʼy adan lévanjil-la. ");
INSERT INTO acfNT_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","4","Bon Nouvèl sala sé konsèné Gasonʼy Jézi Kwi Senyè nou ki té désandan Wa David an lachè-a, mé sé Lèspwi Bondyé ki ba li pouvwa lè i wésisité hòd lanmò pou i té sa kondwi kon Gason Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","Bondyé sèvi Jézi Kwi pou fè mwen wisivwè lagwas épi pwivilaj-la pou vini an zapòt, kon sa pou lapéti Jézi, mwen té kay sa kwiyé moun adan tout nasyon pou vini kwè épi mété lafwa yo an Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","Épi zòt osi anpami sé nasyon sala, zòt Bondyé ja kwiyé-a pou vini sa Jézi menm-lan. ");
INSERT INTO acfNT_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","Épi sé kon sa mwen ka ékwi zòt tout an vil Ronm, zòt Bondyé kontan an chay-la épi i ja kwiyé pou vini moun li menm-lan. Mwen ka mandé Bondyé Papa nou épi Jézi Kwi Senyè pou bay zòt lagwas épi lapé. ");
INSERT INTO acfNT_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","Pwèmyéman mwen ka wimèsyé Bondyé an non Jézi Kwi pou zòt tout, paski nouvèl-la konsèné lafwa zòt ka simen an tout latè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","Bondyé sé témwen mwen. Sé li mwen ka sèvi épi tout tjè mwen kon mwen ka pwéché Bon Nouvèl-la konsèné Gasonʼy-lan, épi i sav mwen ka toujou pwédyé bay zòt. ");
INSERT INTO acfNT_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","Mwen toujou ka mandéʼy si i sa kité mwen vini wè zòt. ");
INSERT INTO acfNT_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","Mwen vlé wè zòt an chay kon sa zòt sa jwenn an bennédiksyon ki kay fè lafwa zòt vini fò. ");
INSERT INTO acfNT_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","Sa mwen vlé di-a sé sa, nou kay édé lafwa yonn a lòt vini fò, ni lafwa mwen épi lafwa zòt osi. ");
INSERT INTO acfNT_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","Mwen vlé zòt sav, fwè èk sè, sété toujou antansyon mwen pou vini wè zòt mé mwen pʼòkò té sa vini. Mwen vlé fè moun anpami zòt swiv Jézi menm kon mwen ja fè anpami sé lézòt nasyon-an. ");
INSERT INTO acfNT_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","Mwen ni an obligasyon pou tout moun, ni sa ki savan kon sa ki sovay, sa ki endiké kon sa ki pa endiké. ");
INSERT INTO acfNT_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","Sé sa ki fè mwen anvi pwéché Bon Nouvèl-la bay zòt ki ka wèsté an vil Ronm osi. ");
INSERT INTO acfNT_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","Mwen pa hont pyès pou Bon Nouvèl sala, paski sa sé pouvwa-a Bondyé ja sèvi pou sové tout moun ki ka kwè, pou sé Jwif-la pwèmyéman épi sé sa ki pa Jwif-la osi. ");
INSERT INTO acfNT_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","Paski an Bon Nouvèl-la Bondyé ja wévélé mannyè i ka mété nonm dwèt épiʼy. Épi mannyè-a i ka mété nonm dwèt épiʼy-la dépan asou lafwa nonm, épi sé asou lafwa tousèl. Kon lévanjil-la di, “Nonm-lan Bondyé ja mété dwèt épiʼy-la kay viv laviʼy épi lafwa.” ");
INSERT INTO acfNT_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","Paski waj Bondyé ja wévélé sòti an syèl kont tout moun ki pa ni Bondyé an lavi yo, kont tout mové bagay nonm ka fè épi sé sa ki sèvi movèzté yo-a pou anpéché moun konnèt lavéwité-a. ");
INSERT INTO acfNT_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","Sa an moun pé konnèt konsèné Bondyé byen senp pou yo, paski Bondyé ja moutwé yo aklè. ");
INSERT INTO acfNT_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","Dépi tan Bondyé fè latè-a, moun sa konpwann aklè mannyè pouvwaʼy pa sa janmen fini épi i sé vwéman Bondyé. Sé kalité mannyè sala ou sa konpwann li byen. Moun sa konnèt sé bagay sala konsèné Bondyé asou sé bagay-la Bondyé ja fè-a. Pou wézon sala moun pa sa ni pyès èskiz pou sé bagay-la yo ka fè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","Menm si yo sav ki moun Bondyé yé, yo pa ka ni ba li lonnè kon Bondyé-a yo sav i yé-a, ében wimèsyéʼy. Mé sa yo ka katjilé sé bétiz tousèl, épi lidé yo ki té vid-la ja plen épi nwèsè. ");
INSERT INTO acfNT_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","Yo di yo ni lasajès, mé yo kouyon pasé ki. ");
INSERT INTO acfNT_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","Yo doubout adowé Bondyé-a ki pa ka janmen mò-a pou adowé imaj nonm fè ki ka sanm moun, jibyé, zannimo épi sèpan. ");
INSERT INTO acfNT_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","Épi pou wézon sala Bondyé ja abandonnen yo adan menm vyé konmès-la ki an tjè yo-a, pou yo fè malpwòpté épi yonn a lòt. ");
INSERT INTO acfNT_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","Épi menm mannyè-a yo wifizé kwè lavéwité-a konsèné Bondyé-a, sé menm mannyè yo vini kwè mansonj. Épi yo alé adowé épi obéyi bagay Bondyé fè pito yo adowé Bondyé menm, ki fè tout bagay-la épi ki méwité pou moun adowéʼy pou lavi diwant-lan. Ensiswatil. ");
INSERT INTO acfNT_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","Pou menm wézon sala Bondyé abandonnen yo adan vyé dézi honté yo-a. Sé madanm-lan menm, yo gaté mannyè Bondyé té mété pou yo fè zafè yo-a, épi yo ka kouché épi yonn a lòt adan an mannyè ki pa natiwèl. ");
INSERT INTO acfNT_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","Épi sé nonm-lan osi, yo doubout dòmi épi madanm èk yo vlé nonm kon yo pou madanm yo. Nonm ka fè tout sòt kalité malpwòpté épi yonn a lòt. Épi pou lapéti sa, Bondyé pini yo menm kon yo té méwité pou mové mannyè-a yo konpòté kò yo-a. ");
INSERT INTO acfNT_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","Sé pa sa tousèl: Kon yo pa té kwè i nésésè pou konnèt Bondyé, Bondyé abandonnen yo épi vyé lidé sal yo-a, èk sé pou wézon sala yo ka fè tout vyé bagay ki pa bon pou fè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","Lavi yo plen épi tout sòt kalité movèzté: Yo méchan, yo vowas, yo benyen vis, yo jalou an chay, yo ka tjwé, yo ka goumen, yo ka kwennen, yo pa sa dakò épi moun, yo ka malpalé, ");
INSERT INTO acfNT_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","yo ka sali non lézòt, yo hayi Bondyé, yo ka ensilté moun, yo benyen lògèy, yo bava, yo ka katjilé pli mannyè pou fè movèzté, yo ka dézobéyi manman yo épi papa yo, ");
INSERT INTO acfNT_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","yo kouyon, yo pa ka tjenn pwonmèt yo épi yo ka twété moun kon zannimo kon yo menm yé. ");
INSERT INTO acfNT_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","Magwé yo sav Bondyé ja di sé moun-an ki ka fè sé bagay sala méwité mò, sé pa kontiné yo ka kontiné fè sé bagay sala tousèl, mé yo ka jik ankouwajé lòt moun pou fè yo osi. ");
INSERT INTO acfNT_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","Kon sa zòt pa ni pyès èskiz, zòt tout ki ka jijé-a, mwen pa mélé ki moun ou yé. Lè ou jijé an lòt moun, kon ou ka pasé jijman asouʼy-la, ou ka kondanné kòʼw, paski ou ki jij-la ka fè sé menm bagay-la. ");
INSERT INTO acfNT_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","Nou sav lè Bondyé ka jijé sé moun-an ki ka fè sé bagay sala, i ka jijé dwèt. ");
INSERT INTO acfNT_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","Ès si ou kwè, ou majò sala ki ka jijé-a, lè ou pasé jijman asou sé moun-an ki ka fè sé bagay sala épi ou ka fè sé menm bagay-la, ou kay chapé jijman Bondyé? ");
INSERT INTO acfNT_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","Magwé nou sav Bondyé ni an tjè fèb pou nou, épi i pa pwésé pou jijé èk i ni pasyans, mé wannman zòt pa ka pwan sa pou anyen. Ès si zòt pʼòkò wéyalizé wézon-an Bondyé otan bon pou nou-an sé paski i vlé nou wépanti? ");
INSERT INTO acfNT_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","Mé kon tjèʼw épi tèt ou wèd otan-an, ou ka asanblé waj Bondyé kont kòʼw asou jou sala lè tout moun kay konpwann mizi faché Bondyé faché épi mannyè jijmanʼy toujou dwèt-la. ");
INSERT INTO acfNT_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","Bondyé kay bay tout moun sa yo méwité asou twavay-la yo ja fè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","Sé sa ki ni pasyans kon yo ka chaché pou sé bèl bagay-la Bondyé kay di konsèné yo an dènyé tan-an épi lonnè-a i kay ba yo-a, yo kay jwenn lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","Mé sé sa ki ka gadé pou lantéwé yo tousèl-la, épi pito yo obéyi lavéwité yo ka obéyi movèzté-a, Bondyé kay vidé tout waj li asou yo. ");
INSERT INTO acfNT_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","La kay ni asé twibilasyon épi soufwans pou tout moun ki ka fè movèzté, pou sé Jwif-la avan, épi pou sé sa ki pa Jwif-la osi. ");
INSERT INTO acfNT_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","Mé pou sé sa ki ka fè bon-an, Bondyé kay di tout bèl bagay konsèné yo, épi i kay ba yo lonnè èk lapé, sé Jwif-la avan épi sé sa ki pa Jwif-la osi, ");
INSERT INTO acfNT_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","paski Bondyé ka twété tout moun menm mannyè. ");
INSERT INTO acfNT_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","Sé sa ki péché paski yo pa té sav sa lwa-a di-a kay péwi menm si yo pa té konnèt lwa-a, épi tout sa ki péché lè yo té konnèt lwa-a, Bondyé kay sèvi menm sé bagay-la ki ékwi an lwa-a pou jijé yo. ");
INSERT INTO acfNT_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","Bondyé pa ka mété moun dwèt épiʼy paski yo ka kouté lè lwa-a ka li, mé i ka mété moun dwèt épiʼy lè yo fè sa lwa-a di yo pou fè. ");
INSERT INTO acfNT_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","Sé nasyon-an ki pa Jwif-la, ki pa menm ni lwa-a, lè lidé yo ka di yo fè sé bagay-la lwa-a ka di moun pou fè-a, yo ka moutwé kon sa yo sav ki sa an moun ni pou fè épi sa i pa pou fè, menm si yo pa té ni lwa-a ékwi. ");
INSERT INTO acfNT_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","Yo ka moutwé ankò, sa lwa-a ka di pou fè-a ékwi an tjè yo. Konsyans yo menm ka tèstifyé sa vwé, épi délè lidé yo ka di yo yo fè an bagay ki pa bon, épi an lòt lè i ka di yo sa yo fè-a bon. ");
INSERT INTO acfNT_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","Épi sa kay vini aklè asou jou-a Bondyé kay sèvi Jézi Kwi pou jijé tout sigwé nonm, menm kon Bon Nouvèl-la mwen ka pwéché-a di. ");
INSERT INTO acfNT_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","Bon, ou menm ki kwiyé kòʼw an Jwif, épi ki ka dépan asou lwa-a, épi ki ka bavadé tèlman konsèné wilasyon-an ou ni épi Bondyé-a, ");
INSERT INTO acfNT_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","épi ou sav ki sa Bondyé vléʼw fè, épi ou ja aksèpté sé bagay-la ki pli bon-an paski lwa-a ja moutwéʼw sé bagay sala, ");
INSERT INTO acfNT_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","épi si ou asiwé ou sa moutwé moun ki avèg chimen-an, épi ou sé klèté pou sé sa ki an nwèsè-a, ");
INSERT INTO acfNT_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","ou sé yonn ki ka enstwi sa ki kouyon épi sa ki manmay toujou, anfen ou asiwé, paski ou ni lwa-a, ou konnèt tout bagay byen épi sa ou di sé lavéwité fyèplé — ");
INSERT INTO acfNT_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","ou apwézan ki ka enstwi lézòt-la, ès si ou pa sa enstwi kòʼw? Kon ou ka di an moun pa ni pou vòlè-a, ès si ou menm ka vòlè? ");
INSERT INTO acfNT_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","Ou di an moun pa sipozé fè adiltè kouman. Ès si ou menm ka fè adiltè? Ou ki pa sa sipòté fo bondyé-a, ès si ou ka kasé kay sé fo bondyé sala épi vòlè bagay adan yo? ");
INSERT INTO acfNT_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","Ou ki ka bavadé konsèné lwa-a, ès si ou ka annékòz moun pou déwèspèkté Bondyé paski ou menm ka kasé lwa-a? ");
INSERT INTO acfNT_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","Kon lévanjil-la di, “Sé pou lapéti zòt, sé nasyon-an ki pa Jwif-la ka ensilté non Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","Sèl mannyè sikonsizyon sa bennéfis an moun sé si i ka tjenn lwa-a, mé si i kasé lwa-a sikonsizyonʼy-lan pa kay sinifyéʼy anyen. ");
INSERT INTO acfNT_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","Kon sa si an moun ki pa sikonsayz ka tjenn lwa Bondyé, Bondyé ka gadé moun sala menm kon an moun ki sikonsayz. ");
INSERT INTO acfNT_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","Sa ki pa sikonsayz-la mé yo ka obéyi lwa-a kay kondanné zòt, paski menm si zòt ni lwa-a matjé épi zòt sikonsayz, zòt ka kasé lwa-a toujou. ");
INSERT INTO acfNT_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","Sé pa paski ou ka gadé kon an Jwif ou sé an Jwif pou vwé. Ni kon ou sikonsayz-la ou sé vwéman an Jwif. ");
INSERT INTO acfNT_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","Okontwè ou sé an Jwif pou vwé épi ou sikonsayz pou vwé lè ou bay Bondyé tjèʼw. Lwa-a ki matjé-a pa sa fè sa. Sé Lèspwi Bondyé tousèl ki ka fè sa. Épi sé Bondyé épi pa lòt nonm ki ka bay an nonm kon sa lonnè. ");
INSERT INTO acfNT_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","Ki lavantay ou ni si ou sé an Jwif, ében ki valè ki an sikonsizyon? ");
INSERT INTO acfNT_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","I ni an chay lavantay an sa. Pwèmyéman, Bondyé bay sé Jwif-la lévanjil-la pou yo té sa pwézèvéʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","Mé ki mannyè i té kay yé si adan sé Jwif-la pa té fè sa yo té sipozé fè-a? Ès si sa kay anpéché Bondyé fè sa i di i kay fè-a? ");
INSERT INTO acfNT_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","Awa! Sa Bondyé di toujou vwé menm si tout moun sé an mantè. Kon lévanjil-la di, “Dépi ou menm Bondyé palé, tout moun kay wè nètaman sa ou di-a sé lavéwité, épi népòt lè ou fè défans kòʼw, ou kay moutwé moun sa ou fè-a dwèt.” ");
INSERT INTO acfNT_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","Mé lè nou fè mové, si sa ka moutwé aklè mizi dwèt Bondyé dwèt, ki sa nou kay di? Ès si nou kay di Bondyé pa dwèt kon i ka pini nou pou movèzté sala? (Mwen ka palé kon an nonm té kay palé.) ");
INSERT INTO acfNT_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","Awa! Paski si Bondyé pa dwèt, ki mannyè i ka fè jijé latè-a? ");
INSERT INTO acfNT_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","Mé si kon mwen ka fè mové-a, sa kay édé moun wè mizi dwèt Bondyé dwèt épi i kay jwenn pli lonnè pou sa, pouki mwen kondanné toujou kon an péchè? ");
INSERT INTO acfNT_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","Ében pouki ou pa ka annèk di toubonnman, “Annou fè movèzté, paski sé bonté nou kay jwenn?” Pou byen diʼw, an chay moun ka ensilté mwen épi yo ka sali non mwen pou sa, paski yo di sé sa mwen ka pwéché. Kanmenm Bondyé kay kondanné sé moun sala menm kon yo méwité. ");
INSERT INTO acfNT_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","Ki sa nou sa di pou vwé? Nou sé Jwif-la pli mèyè pasé sé sa ki pa Jwif-la? Awa! Paski fini nou fini moutwé mannyè nou tout, Jwif kon sa ki pa Jwif, anba pouvwa péché. ");
INSERT INTO acfNT_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","Kon i ékwi an lévanjil, “La pa ni pyèsonn ki ka viv dwèt, pa menm yonn. ");
INSERT INTO acfNT_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","La pa ni pyèsonn ki ka konpwann. La pa ni pyèsonn ki ka gadé pou Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","Yo tout ja tounen do yo asou Bondyé, yo pyès pa vo anyen. Pyèsonn pa ka fè sa ki bon, pa menm yonn. ");
INSERT INTO acfNT_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","Lè yo ouvè bouch yo pou palé, i menm kon an twou ki ouvè an tè-a pou valé moun. Épi yo ka sèvi lanng yo pou toujou kwennen moun. Dèyè lèv yo ni vlen menm kon an danjéwé sèpan. ");
INSERT INTO acfNT_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","Tout lè yo ouvè bouch yo pou palé, yo toujou ka jiwé, épi pawòl yo toujou anmè. ");
INSERT INTO acfNT_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","Yo ka gadé pou tout ti chans yo jwenn pou yo sa tjwé moun, ");
INSERT INTO acfNT_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","Toupatou yo pasé yo ka kité an ling mizè épi soufwans. ");
INSERT INTO acfNT_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","Yo pa konnèt ki mannyè pou viv an lapé. ");
INSERT INTO acfNT_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","Konsyans yo pa ka janmen ba yo pou yo sa abésé kò yo douvan Bondyé.” ");
INSERT INTO acfNT_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","Bon, nou sav tout bagay ki matjé an lwa-a matjé bay sé moun-an ki anba lwa-a. Kon sa pyèsonn pa sa ni an èskiz, épi nou kay wè mannyè tout latè-a koupab douvan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","Menm si an moun fè sa lwa-a diʼy pou fè, sa pa vlé di moun sala dwèt épi Bondyé. Okontwè sa lwa-a ka fè sé sa: I ka fè moun sav yo sé péchè. ");
INSERT INTO acfNT_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","Mé apwézan Bondyé té ja wévélé mannyè-a i ka mété moun dwèt épiʼy-la épi i pa té sèvi lwa-a pou fè sa, magwé sa ki ékwi an lwa Bondyé-a épi osi sa sé pwòfèt-la ékwi-a té palé konsèné sa. ");
INSERT INTO acfNT_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","Épi mannyè-a Bondyé ka mété an moun dwèt épiʼy-la sé lè moun sala mété lafwaʼy an Jézi Kwi, épi sé kon sa i ka fè bay tout moun ki ka kwè an li. La pa ni pyès diféwans, ");
INSERT INTO acfNT_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","paski tout moun ja péché, épi pyèsonn pa bon asé pou fè Bondyé aksèptéʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","Bondyé ja moutwé nou mizi lib lagwas li lib, lè i sèvi Jézi Kwi pou mété nonm dwèt épiʼy. Épi sé Jézi Kwi menm ki ban nou libèté nou. ");
INSERT INTO acfNT_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","Bondyé ofè Jézi kon sa Jézi té kay moun-an ki té kay pawdonnen péché nonm. Jézi fè sa lè i té mò, épi péché nonm pawdonnen lè yo mété lafwa yo an li. Bondyé fè sa pou moutwé nou i té vlé mété nonm dwèt épiʼy. An tan avan, lè moun péché Bondyé pwan pasyans épi yo épi i pa di anyen. ");
INSERT INTO acfNT_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","Bondyé fè sa pou moutwé nou an tan-an nou ka viv apwézan-an i menm Bondyé ka fè sa ki dwèt, épi moun-an ki ni lafwa an Jézi-a, i kay mété moun sala dwèt épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","Ki wézon an nonm ni pou bavadé? Mwen kay di i pa ni pyès wézon. Mé, i ka swiv lwa-a, kouman. Ès si i pa sa bavadé? Awa! Lè ou swiv lwa-a sa pa kay fè ou vini dwèt douvan Bondyé. Sèl mannyè an moun sa vini dwèt épi Bondyé sé lè i mété lafwaʼy an Jézi. ");
INSERT INTO acfNT_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","Kon sa nou ka wè nètaman sé lafwa tousèl ki ka fè an nonm vini dwèt épi Bondyé, épi sé pa lè i swiv lwa-a. ");
INSERT INTO acfNT_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","Ében ès si Bondyé sé Bondyé sé Jwif-la tousèl épi i pa Bondyé sé sa ki pa Jwif-la? Mé non! I sé Bondyé yo osi. ");
INSERT INTO acfNT_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","Bondyé sé sèl Bondyé ki ni, épi i kay mété moun dwèt épiʼy ki ou sikonsayz opa, dépi ou mété lafwaʼw an Jézi Kwi. ");
INSERT INTO acfNT_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","Ès si sa vlé di kon nou mété lafwa nou an Jézi-a nou sa jété lwa-a? Awa! Okontwè nou ka bay lwa-a valè-a i sipozé ni-an. ");
INSERT INTO acfNT_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","Bon, nou kay gadé ki sa ki té wivé Abrahanm gwan gwanpapa sé Jwif-la. ");
INSERT INTO acfNT_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","Si Bondyé mété Abrahanm dwèt épiʼy pou lapéti sa Abrahanm fè, i té sa bavadé, mé pa douvan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","Paski lévanjil-la di, “Bondyé gadé Abrahanm kon an moun ki dwèt douvanʼy paski Abrahanm té ni lafwa an li.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","Bon, lè an nonm twavay, lajan-an i jwenn-an sé pa an kado, mé sa sé lajan-an i twavay pou-a. ");
INSERT INTO acfNT_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","Mé si nou gadé moun-an ki pa ka dépan asou twavay li-a mé ka dépan asou Bondyé ki ka mété moun ki mové dwèt épiʼy-la, nou kay wè sé lafwa moun sala Bondyé ka konsidiwé lè i ka météʼy dwèt épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","Nou sa wè an lévanjil-la koté Wa David té di menm bagay-la koté i palé konsèné mannyè nonm-lan Bondyé ja aksèpté kon an moun ki dwèt épiʼy-la kontan an chay, magwé nonm sala pa té fè anyen pou Bondyé té antwé an favèʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","I di, “Sé moun-an Bondyé ja pawdonnen pou tout sé mové bagay-la yo ka fè-a épi i ja tiwé péché yo-a kontan an chay. ");
INSERT INTO acfNT_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","Wi, nonm-lan Bondyé pa ka matjé péchéʼy-la kontan an chay.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","Bon, kontantman sala i ka palé konsèné-a, ès si sé asou sé sa ki sikonsayz-la tousèl, ében asou sé sa ki pa sikonsayz-la osi? Nou ja moutwé koté lévanjil-la di, “Abrahanm té kwè an Bondyé, épi kon i té ni lafwa an Bondyé-a Bondyé aksèptéʼy kon an nonm ki dwèt épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","Ki lè bagay sala pwan kou? Ès si sé lè Abrahanm té sikonsayz, ében apwé i té sikonsayz? Sé pa apwé i sikonsayz i pwan kou, mé sé avan i té sikonsayz. ");
INSERT INTO acfNT_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","Épi lè Abrahanm vini sikonsayz, sikonsizyon sala té kon an mak pou moutwé i sé lafwaʼy ki météʼy dwèt épi Bondyé, épi lafwa sala, i té niʼy avan i té sikonsayz. Sé kon sa Abrahanm sé papa tout sa ki ka kwè an Bondyé, épi Bondyé ja aksèpté yo kon moun ki dwèt épiʼy menm si yo pa sikonsayz. ");
INSERT INTO acfNT_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","Abrahanm sé papa sé moun-an ki sikonsayz-la osi, sé pa sé sa ki sikonsayz toubonnman, mé sé sa ki ka swiv menm chimen lafwa-a Abrahanm té swiv-la avan i té sikonsayz-la. ");
INSERT INTO acfNT_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","Bondyé té fè an pwonmèt bay Abrahanm épi désandanʼy ki di kon sa yo kay éwityé latè-a. Pwonmèt sala pa té vini kon yo té ka swiv lwa-a, mé sé kon Abrahanm kwè an Bondyé-a, Bondyé aksèptéʼy kon an moun ki ka viv dwèt épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","Paski si sé sa ki swiv lwa-a ki ka éwityé latè-a, ében, lafwa pa kay ni valè-a i sipozé ni-an, épi pwonmèt-la menm pa kay vo pa menm dé sou tjwiv. ");
INSERT INTO acfNT_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","Lwa-a menm ka mennen waj Bondyé, mé si la pa ni pyès lwa, an moun pa sa dézobéyi lwa-a. ");
INSERT INTO acfNT_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","Sé sa ki fè tout bagay dépan asou lafwa-a Abrahanm ni an Bondyé-a. Mannyè sala pwonmèt-la Bondyé té fè-a té kay vini kon an kado pou tout désandan Abrahanm. Sé pa sé sa ki ka swiv lwa-a tousèl, mé osi byen pou sé sa ki ni menm lafwa épi Abrahanm-lan paski sé li ki papa nou tout. ");
INSERT INTO acfNT_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","Kon i ékwi an lévanjil-la, “Mwen ja fèʼw papa an chay nasyon.” Pwonmèt sala bon paski sé Bondyé ki fèʼy, épi sa sé Bondyé-a Abrahanm té ka kwè adan-an. Sé Bondyé sala ki ka fè moun ki ja mò viv ankò, épi tout sé bagay-la ou ka wè apwézan-an pa té la avan, mé Bondyé konmandé yo pou fèt épi tout vini fèt. ");
INSERT INTO acfNT_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","Koté lézòm té kay pèd tout èspwa yo, Abrahanm kontiné ni èspwa an Bondyé, épi sé kon sa i vini papa plizyè nasyon. Kon Bondyé té diʼy, “Sé kon sa désandanʼw kay yé.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","Lè Abrahanm gadé kòʼy menm, i wè i té ja tou mò, paski i té ja pwèskè yon san lanné, épi Sara té ja bwanhany, mé magwé tout sa i pa té pèd lafwaʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","An tout sa lafwaʼy pa janmen soukwé, épi i pa janmen di Bondyé pa kay tjenn pwonmèt li. Okontwè lafwaʼy fèʼy vini pli fò épi i di, “Bondyé gwan an chay.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","Abrahanm té asiwé Bondyé té kay sa tjenn pwonmèt li. ");
INSERT INTO acfNT_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","Sé sa ki fè, “Bondyé gadé Abrahanm kon an moun ki dwèt épiʼy.” ");
INSERT INTO acfNT_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","Bon, tjò lévanjil-la ki di Bondyé gadéʼy kon an moun ki dwèt épiʼy-la pa té matjé pou lapéti Abrahanm tousèl, ");
INSERT INTO acfNT_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","mé sé pawòl sala ka palé ban nou osi, nou Bondyé kay aksèpté kon moun ki dwèt épiʼy-la paski nou kwè an Bondyé-a ki wésisité Jézi Senyè nou hòd lanmò-a. ");
INSERT INTO acfNT_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","Jézi jwenn lanmòʼy pou lapéti péché nou, épi i wésisité pou i té sa mété nou dwèt épi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","Bon, dépi lafwa nou ja mété nou dwèt épi Bondyé-a, Senyè nou Jézi Kwi ka fè nou viv an lapé épi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","Sé Jézi ki fèʼy posib pou Bondyé antwé an favè nou. Épi sé kon Bondyé antwé an favè nou-an nou ka viv jòdi-a, épi nou ka widjèwté an chay paski nou ni èspwa nou kay jwenn adan lonnè-a Bondyé ni-an. ");
INSERT INTO acfNT_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","Mé sé pa sa tousèl. Nou ka widjèwté osi lè nou ka soufè paski nou sav soufwans ka moutwé nou mannyè pou tjenbé wèd, ");
INSERT INTO acfNT_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","épi lè nou tjenbé wèd nou ka vini fò an lèspwi nou, épi lè nou vini fò an lèspwi nou sa ka ban nou èspwa. ");
INSERT INTO acfNT_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","Épi èspwa pa kay fè nou hont, paski nou sav mizi lanmityé Bondyé ni pou nou, épi i ja moutwé sa lè i ban nou Lèspwiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","Lè nou pa té sa fè anyen bay kò nou, Jézi mò bay sé mové-a menm lè-a Bondyé té chwazi pou sa té fèt-la. ");
INSERT INTO acfNT_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","Byen wa ou kay wè an moun pwan lanmòʼy bay an moun ki ka viv dwèt, magwé pou lapéti an bon nonm an moun pé dakò pou mò. ");
INSERT INTO acfNT_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","Mé Bondyé té moutwé nou mannyè i ni lanmityé pou nou, paski nou té an péché nou toujou lè Jézi Kwi mò ban nou. ");
INSERT INTO acfNT_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","Si apwézan nou ja vini dwèt épi Bondyé, èk sé san Jézi ki koulé pou nou té sa vini kon sa, ès si ou pa kwè Jézi kay sové nou plis toujou anba waj Bondyé-a ki ka vini-an? ");
INSERT INTO acfNT_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","Si patan nou té hayi Bondyé, Gasonʼy mò pou i té sa fè nou vini jan Bondyé ankò, ében, kon nou sé janʼy apwézan-an i kay vwéman sové nou paski i ka viv ankò. ");
INSERT INTO acfNT_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","Mé sé pa sa tousèl, nou ni an chay djèwté an tjè nou paski apwézan Senyè nou Jézi Kwi ja fè nou vini jan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","I sé yon nonm ki mennen péché an latè sala, épi péchéʼy mennen lanmò. Bon, kon tout moun ja péché-a, kon sa tout moun oblijé mò. ");
INSERT INTO acfNT_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","Dépi avan Bondyé té bay Moziz lwa-a jan latè-a té ja péché, mé Bondyé pa té matjé péché yo paski la pa té ni lwa. ");
INSERT INTO acfNT_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","Kanmenm, lanmò té mèt lézòm dépi tan Adanm pou jik tan Moziz. Lanmò té ka kondwi jik anho sé moun-an ki pa té péché menm mannyè Adanm té fè-a lè i té dézobéyi konmandman Bondyé-a. Adan an mannyè Adanm té kon Jézi ki té vini pli ta-a. Adan an mannyè Adanm té kon Jézi ki té vini pli ta-a. ");
INSERT INTO acfNT_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","Mé kado-a Bondyé bay-la sé pa menm épi péché Adanm-lan. Sa vwé an chay moun mò paski yon nonm péché, mé Bondyé ni tèlman tjè fèb, kon sa i sèvi tjè fèb yon nonm, sa sé Jézi Kwi, pou bay an chay nonm kadoʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","Épi mannyè-a Bondyé ka bay kadoʼy lib-la diféwan an chay épi mannyè-a yon nonm péché-a. Apwé Adanm péché Bondyé jwenn li koupab, mé apwé otan moun ja péché, Bondyé moutwé yo mizi tjè fèb i ni lè i di, “Yo pa koupab.” ");
INSERT INTO acfNT_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","Lè yon nonm péché, lanmò koumansé kondwi tout moun kon an wa pou lapéti péché nonm sala. Mé nonm-lan Jézi Kwi fè twòp pli pasé sa. I fèʼy posib pou nou sa wisivwè lagwas adan an gwan mannyè épi pou nou sa vini dwèt épi Bondyé magwé nou pa té ni pou fè anyen. Kon sa nou ni lavi étonnèl épi sa kondwi épiʼy kon wa. ");
INSERT INTO acfNT_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","Menm kon tout nonm té kondanné pou lapéti péché yon sèl nonm, sé menm mannyè-a tout nonm ja jwenn libèté yo épi yo ni lavi paski yon nonm fè sa ki dwèt douvan Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","Menm kon an chay moun vini péchè paski yon nonm dézobéyi Bondyé, sé menm mannyè-a Bondyé kay mété an chay moun dwèt épiʼy paski yon nonm obéyiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","Bondyé mennen lwa-a pou moun sa wè péché yo pli byen. Mé pli moun péché, sé pli nou ka wè mizi tjè fèb Bondyé ni. ");
INSERT INTO acfNT_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","Kon sa menm kon péché mennen lanmò pou moutwé mizi pouvwa i ni, sé menm mannyè-a Bondyé ni tjè fèb pou nou, épi i mété nou dwèt épiʼy, épi i ban nou lavi étonnèl pou moutwé sé li yonn ki ni pouvwa. Épi sé Jézi Kwi Senyè nou ki fè sa posib. ");
INSERT INTO acfNT_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","Bon, sa vlé di tout sa? Ès si sa vlé di nou sa kontiné an péché pou lagwas Bondyé vini pli ho? ");
INSERT INTO acfNT_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","Awa! Péché pa ni pyès pouvwa anlè nou ankò, paski sé akwèdi nou ja mò. Kon sa ki mannyè nou sa kontiné ka viv an péché? ");
INSERT INTO acfNT_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","Ès si zòt pa sav nou tout ki ja batizé an non Jézi Kwi-a té batizé an lanmòʼy osi? ");
INSERT INTO acfNT_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","Lè nou té batizé, akwèdi nou té mò épiʼy, kon sa kon Bondyé Papa sèvi tout gwan pouvwaʼy pou Jézi té sa wésisité hòd lanmò-a, nou osi pé viv an lavi ki nèf. ");
INSERT INTO acfNT_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","Paski si nou ja manché épiʼy an lanmòʼy, nètaman nou kay manché épiʼy kon i wésisité hòd lanmò-a osi. ");
INSERT INTO acfNT_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","Nou sav moun-an nou té yé avan-an té kwisifyé épi Jézi. Jézi détwi labitid péché-a nou té ni-an, kon sa nou pa kay èslav péché ankò, ");
INSERT INTO acfNT_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","paski péché pa sa kondwi an moun ki ja mò ankò. ");
INSERT INTO acfNT_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","Bon, si nou ja mò épi Jézi, nou ni èspwa nou kay viv épiʼy osi. ");
INSERT INTO acfNT_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","Paski nou sav kon Jézi Kwi ja wésisité hòd lanmò-a i pa sa janmen mò ankò. Lanmò pa ni pyès kalité pouvwa anlèʼy ankò. ");
INSERT INTO acfNT_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","Lè Jézi mò, i mò pou i té sa kasé pouvwa péché pou bon, mé apwézan kon i ka viv-la, i ka viv bay Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","Épi menm mannyè-a péché pa sa kondwi an moun ki ja mò, sé kon sa zòt sipozé wè kò zòt kon moun ki té ja mò-a mé ka viv bay Bondyé kon zòt manché an Jézi Kwi-a. ");
INSERT INTO acfNT_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","Pa kité péché kondwi kòʼw ki kay mò-a pou fè ou kouté sé vyé déziʼy-la. ");
INSERT INTO acfNT_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","Ou pa sipozé kité pyès ti kwen an kòʼw anba pouvwa péché. Pito sa, bay Bondyé tout kòʼw kon moun ki ja wésisité hòd lanmò épi ka viv ankò. Sé pou ou bay Bondyé tout ti kwen an laviʼw. Mannyè sala i kay sèviʼw pou ou fè sa ki dwèt. ");
INSERT INTO acfNT_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","Ou pa sipozé kité péché kondwiʼw, paski ou pa ka viv anba pyès lwa mé anba lagwas Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","Bon, ki sa? Ès si nou sipozé péché paski nou pa anba lwa mé anba lagwas? Awa! ");
INSERT INTO acfNT_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","Ès si ou pa sav, si ou mété kòʼw anba an moun pou ou sa obéyiʼy kon èslav li, ou sé èslav mèt sala ou ka obéyi-a? I sa sé èslav péché ki ka fèʼw jwenn lanmòʼw, ében èslav obéyisans ki ka fèʼw viv dwèt épi Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","Mé mèsi Bondyé, paski i ni an tan zòt té èslav péché mé apwézan zòt ja obéyi épi wisivwè èk tout tjè zòt sé bagay-la yo enstwi zòt-la. ");
INSERT INTO acfNT_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","Bondyé ja libéwé zòt anba péché, épi zòt ja vini èslav li pou fè sa ki dwèt. ");
INSERT INTO acfNT_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","Mwen ka palé menm kon lézòm ka palé paski zòt fèb toujou an lakonpwann zòt. Menm kon zòt fè kò zòt èslav malpwòpté épi movèzté-a jik tan zòt wivé viv an lavi ki benyen an movèzté-a, ében sé kon sa zòt té sipozé fè kò zòt èslav pou fè sa ki dwèt jik tan zòt kay wivé viv bay Bondyé tousèl. ");
INSERT INTO acfNT_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","Lè ou té èslav péché ou pa té anba pyès obligasyon pou éséyé fè sa Bondyé té vléʼw fè. ");
INSERT INTO acfNT_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","Mé ki sa ou té jwenn an sé bagay-la ki ka fèʼw hont apwézan-an? Tout sé bagay sala ka mennen lanmò. ");
INSERT INTO acfNT_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","Mé apwézan Bondyé ja libéwéʼw anba péché épi i ja fèʼw vini èslav li, èk bennéfis-la ou ka jwenn-an sé an lavi ki nèt, épi tout sé bagay sala kay mennen lavi étonnèl. ");
INSERT INTO acfNT_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","Paski péyiman péché sé lanmò, mé kado-a Bondyé ka bay-la sé lavi étonnèl. Épi Bondyé sèvi Jézi Kwi Senyè nou pou fè sa posib. ");
INSERT INTO acfNT_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","Fwè èk sè ki konnèt lwa Moziz-la, ès si zòt pa sav kon sa lwa-a ni lotowité anho an nonm tout tan i pʼòkò mò? ");
INSERT INTO acfNT_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","Ban mwen moutwéʼw an ègzanp. Lwa-a di kon sa lè an madanm mayé, i sipozé wèsté épi mawiʼy tousèl. Mé annou di mawi-a vini mò, ében, lè sala lwa mawiyaj-la pa ni pyès lotowité anlè madanm-lan ankò. ");
INSERT INTO acfNT_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","Bon, si madanm sala vini byen épi an lòt nonm patan mawiʼy ka viv-la, ében, madanm sala ka fè adiltè. Mé si mawiʼy mò, lwa mawiyaj sala pa ni lotowité anlèʼy ankò, épi i pa ka fè adiltè menm si i mayé épi an lòt nonm. ");
INSERT INTO acfNT_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","An menm mannyè-a fwè èk sè, lwa-a pa ni pyès pouvwa anlè zòt ankò, paski sé akwèdi zòt ja mò. I sé Jézi Kwi ki fè sa posib kon sa zòt té kay ni an lòt mèt. Épi sé mèt sala ki wésisité hòd lanmò pou nou té sa fè twavay ki té kay plè Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","Paski mannyè nou té yé avan-an, lwa-a té lévé tout sé dézi péché-a nou té ni-an, épi sé dézi sala té ka twavay an kò nou, épi tout sa nou fè té ka mennen lanmò. ");
INSERT INTO acfNT_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","Mé apwézan Bondyé ja tiwé nou anba lwa-a, épi lwa sala ki té mété nou an pwizon-an pa ni pyès pouvwa anlè nou ankò. Kon sa nou sa fè sèvis Bondyé, pa adan vyé mannyè-a lwa-a té fè posib ban nou-an mé adan lavi nèf-la Lèspwi Bondyé ja ban nou-an. ");
INSERT INTO acfNT_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","Bon, sa vlé di tout sa? Kon sa lwa-a sé péché? Awa! Pou byen diʼw, mwen pa té kay sav sa vlé di péché si pa té pou lwa-a. Paski mwen pa té sav mannyè i yé pou vwé pou ou anvi an bagay an lòt moun ni, si lwa-a pa té di, “Ou pa sipozé anvi sa ki pa sa ou.” ");
INSERT INTO acfNT_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","Mé péché sèvi konmandman-an pou i té sa jwenn an mannyè pou lévé tout kalité vyé dézi an mwen. Si la pa té ni pyès lwa, péché pa té kay ni pyès pouvwa. ");
INSERT INTO acfNT_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","I ni an tan mwen té ka viv mé mwen pʼòkò té konnèt lwa-a. Mé lè mwen vini apwann konmandman-an, gadé! Péché lévé andidan mwen alò, ");
INSERT INTO acfNT_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","épi mwen vini mò. Menm konmandman-an ki té sipozé fè mwen viv-la tjwé mwen. ");
INSERT INTO acfNT_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","Péché sèvi konmandman-an pou i té sa jwenn an mannyè pou kwennen mwen, épi i tjwé mwen. ");
INSERT INTO acfNT_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","Kon sa sé Bondyé ki bay ni sé lwa-a épi sé konmandman-an, épi yo dwèt épi bon. ");
INSERT INTO acfNT_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","Bon, ès si sa ki bon fè mwen jwenn lanmò mwen? Awa! Sé péché ki fè sa. Péché sèvi sa ki bon pou i té sa fè mwen jwenn lanmò mwen. Mannyè sala moun té kay wè péché vwéman pou sa i yé-a. Épi sé konmandman-an menm ja moutwé nou plis toujou mizi mové péché mové. ");
INSERT INTO acfNT_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","Nou sav lwa-a ka palé bay lèspwi nou, mé mwen menm sé lachè toubonnman ki èslav anba péché. ");
INSERT INTO acfNT_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","Mwen pa sa menm byen konpwann sé bagay-la mwen ka fè-a, paski mwen pa ka fè sa mwen vlé, mé bagay mwen hayi, sé sa mwen ka fè. ");
INSERT INTO acfNT_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","Bon, si mwen ka fè bagay mwen pa vlé fè, ében, mwen dakò lwa-a bon. ");
INSERT INTO acfNT_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","Kon sa sé pa mwen menm ki ka fè sé bagay sala, mé péché-a ki ka viv an tjè mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","Paski mwen sav kon sa la pa ni anyen ki bon andidan mwen, sa sé an lachè mwen. Mwen ni dézi-a mé pa abilité-a pou fè sa ki bon. ");
INSERT INTO acfNT_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","Sé bon bagay-la mwen vlé fè-a, mwen pa ka fèʼy, pito mwen ka fè sé mové bagay-la mwen pa vlé fè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","Bon, si mwen ka fè sa mwen pa vlé fè, ében, sé pa mwen menm ki ka fèʼy, mé sé péché ki ka viv an tjè mwen. ");
INSERT INTO acfNT_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","Épi mi pwensip sala ki ka twavay andidan mwen: Mwen ka vlé fè sa ki bon, mé sé bagay ki mové mwen ka wivé fè. ");
INSERT INTO acfNT_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","Paski tjè mwen menm ka widjèwté an lwa Bondyé-a. ");
INSERT INTO acfNT_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","Mé mwen ka wè an kò mwen menm an lòt pwensip ki ka lévé ladjè épi pwensip-la ki an lidé mwen-an, épi i ja fè mwen pwizonnyé lwa péché-a ki ka twavay an lachè mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","Mésyé! Mwen mizéwab, i! Ki moun ki kay chapé mwen anba lachè sala ki ka tjwé mwen-an? ");
INSERT INTO acfNT_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","Mwen ka wimèsyé Bondyé ki sèvi Jézi Kwi Senyè nou pou délivwé mwen. Kon sa an lidé mwen menm, mwen sé an sèvant lwa Bondyé, mé an lachè mwen mwen ni an dézi pou swiv lwa-a ki ka fè mwen péché-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","Bondyé pa kay kondanné pyèsonn ki manché an Jézi Kwi-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","Paski pouvwa Lèspwi-a ki ka vwéman fè nou viv kon nou manché an Jézi Kwi-a ja ban mwen libèté mwen hòd lwa-a ki mennen péché épi lanmò-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","Sa lwa-a pa té sa fè paski i té fèb an lachè-a, sé menm sa Bondyé ja fè. Bondyé voyé Gasonʼy menm, ki té ni lachè menm kon lachè nou ki sé péchè, pou i té sa doubout pouvwa péché pou bon. Bondyé détwi pouvwa péché ");
INSERT INTO acfNT_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","kon sa nou ki ka viv menm kon Lèspwi-a vlé nou viv-la — épi sé pa kon lachè-a vlé nou viv-la — pé fè dwètiman sé bagay-la lwa-a di ki dwèt pou fè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","Paski sé sa ki ka viv menm kon lachè-a vlé-a ja mété lidé yo asou sé bagay-la lachè-a enmen-an, mé sé sa ki ka viv menm kon Lèspwi Bondyé vlé-a ja mété lidé yo asou sé bagay-la Lèspwi Bondyé enmen-an. ");
INSERT INTO acfNT_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","Si ou mété lidéʼw asou bagay lachè-a enmen, ou kay mò, mé si ou mété lidéʼw asou Lèspwi Bondyé, ou kay viv épi ou kay ni lapé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","Sé pou sa moun-an ki ja mété lidéʼy asou lachè-a ka lévé wévòt kont Bondyé, paski i pa ka abésé kòʼy anba lwa Bondyé, anfen i pa sa obéyiʼy menm si i vlé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","Épi sé sa ki fè sé moun-an dézi lachè-a ka kondwi-a pa sa plè Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","Kanmenm, kon sé Lèspwi Bondyé ki ka viv an zòt pou vwé-a, zòt pa ka viv an lachè-a, mé sé an Lèspwi-a zòt ka viv. Si ou pa ni Lèspwi Jézi ka viv andidanʼw, ou sé pa sa Jézi. ");
INSERT INTO acfNT_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","Magwé lachèʼw ja mò paski ou sé an péchè, mé si Jézi ka viv andidanʼw lèspwiʼw ka viv paski Bondyé ja météʼw dwèt épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","Épi si Lèspwi Bondyé ki wésisité Jézi hòd lanmò-a ka viv andidanʼw, ében, Bondyé kay sèvi menm Lèspwi sala ki ka viv andidanʼw-lan pou i sa wésisitéʼw hòd lanmò osi. ");
INSERT INTO acfNT_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","Kon sa, fwè èk sè, nou pa anba pyès obligasyon pou swiv dézi lachè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","Paski si ou swiv dézi lachè-a ou kay mò, mé si ou sèvi Lèspwi Bondyé pou tjwé sé bagay-la lachèʼw ka vlé fè-a, ou kay viv. ");
INSERT INTO acfNT_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","Tout moun Lèspwi Bondyé ka kondwi sé ich Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","Paski ou pa té wisivwè lèspwi èslavay ki ka fèʼw pè ankò, mé ou ja wisivwè Lèspwi-a ki ka fèʼw ich Bondyé-a, épi sé Lèspwi sala ki ka fè nou hélé, “Papa, Papa mwen!” ");
INSERT INTO acfNT_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","Lèspwi Bondyé ki manché épi lèspwi nou ka di nou sé ich Bondyé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","Épi kon nou sé ich Bondyé-a, nou kay éwityé tout sé bennédiksyon-an i ka tjenn bay sé ich li-a, épi nou kay éwityé épi Jézi osi tout sa Bondyé ka tjenn ba li, paski kon nou soufè épiʼy, menm mannyè nou kay kondwi kon wa épiʼy osi. ");
INSERT INTO acfNT_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","Mwen asiwé, sa nou ka soufè apwézan-an pa anyen lè nou ni pou météʼy vizavi sé bèl bagay-la Bondyé ka tjenn ban nou-an. ");
INSERT INTO acfNT_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","Anfen tout kwiyasyon pa sa menm èspéyé pou jou-a Bondyé kay wévélé ki moun sé ich li-a yé-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","Paski Bondyé té kondanné kwiyasyon pou i pa té vo anyen. Sé pa sa kwiyasyon menm té vlé, mé sé sa Bondyé té vlé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","Bondyé sav yon jou i té kay tiwé modisyon-an i té mété asou kwiyasyon-an épi ba li libètéʼy déviwé, pou i té sa pwan an pa an sé bèl bagay-la Bondyé ja pwépawé bay sé ich li-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","Nou sav kon sa jik apwézan tout kwiyasyon ka plenn afòs i ni mal, menm kon lè an madanm malad akouché. ");
INSERT INTO acfNT_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","Mé sé pa kwiyasyon tousèl ki ka plenn: Jik nou, ki ja wisivwè Lèspwi Bondyé kon pwèmyé fwi an wékòt-la, ka plenn andidan nou osi, kon nou ka èspéyé pou Bondyé fè nou ich li épi pou i sa libéwé nou nètaman. ");
INSERT INTO acfNT_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","Paski sé èspwa sala ki fèʼy posib pou nou té sa sové. Mé èspwa nou ka wè pa èspwa pyès, paski ki moun ki kay mété èspwaʼy adan bagay i ka wè? ");
INSERT INTO acfNT_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","Mé si nou mété èspwa nou asou bagay nou pa ka wè, ében, nou kay èspéyé pou li épi pasyans. ");
INSERT INTO acfNT_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","An menm mannyè-a, Lèspwi Bondyé ka édé nou an tout fèblès nou, paski nou pa menm sav ki mannyè nou sipozé pwédyé, mé Lèspwi-a ka sèvi pawòl nonm pa sa palé pou i sa plédé bay Bondyé ban nou. ");
INSERT INTO acfNT_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","Épi Bondyé ki ka gadé adan tjè nou konnèt ki sa ki an lidé Lèspwi-a, paski Lèspwi-a ka plédé bay sé ich Bondyé-a adan an mannyè ki ka dakò épi sa Bondyé vlé. ");
INSERT INTO acfNT_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","Paski nou sav tout bagay ka twavay ansanm an favè sé sa ki ni lanmityé pou Bondyé-a, sa sé, sé moun-an i ja kwiyé menm kon i té ja fè planʼy-lan. ");
INSERT INTO acfNT_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","Paski sé sa Bondyé té ja chwazi-a, i té ja désidé pou fè yo vini menm kon Gasonʼy, kon sa Gasonʼy-lan té kay pwèmyé anpami an chay sé fwè èk sè-a. ");
INSERT INTO acfNT_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","Épi sé sa i té ja désidé pou chwazi-a, i kwiyé yo osi, épi sé sa i kwiyé-a, i mété yo dwèt épiʼy, épi sé sa i mété dwèt épiʼy-la, i fè yo jwenn lonnè ansanm épi Jézi. ");
INSERT INTO acfNT_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","Bon, sa vlé di tout sa? Si Bondyé pou nou, kilès moun ki kay kont nou? ");
INSERT INTO acfNT_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","Si Bondyé pa té tjenn Gasonʼy menm dèyè, mé ofèʼy kon an sakwifis ban nou tout, ès si ou pa kwè osi i kay ban nou tout lòt bagay nou bizwen? ");
INSERT INTO acfNT_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","Ki moun ki sa di anyen kont sé moun-an Bondyé ja chwazi-a? I sé Bondyé ki ka mété moun dwèt épiʼy. ");
INSERT INTO acfNT_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","Ès si pyèsonn sa kondanné nou? I sé Jézi ki ja mò, épi plis pasé sa, i menm ja wésisité hòd lanmò, épi i asid asou lanmen dwèt Bondyé ka kondwi épiʼy. Épi i osi ka plédé épi Bondyé ban nou. ");
INSERT INTO acfNT_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","Kilès bagay ki kay sa tiwé nou an lanmityé-a Jézi ni pou nou-an? Pa menm si nou jwenn twibilasyon, ében si nou ka pwanʼy wèd, ében si moun ka pèsikité nou, ében si nou fen, ében si nou pòv, ében si nou an danjé, ében si moun vlé tjwé nou. ");
INSERT INTO acfNT_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","Kon lévanjil-la di, “Bondyé, pou lapétiʼw nou ka wè lanmò toulé jou. Moun ka twété nou menm kon mouton yo ka mennen adan an hal pou tjwé.” ");
INSERT INTO acfNT_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","Mé wannman, an tout sé pas-la nou pasé-a, Jézi ki ni lanmityé pou nou-an fèʼy posib pou nou sa ni laviktwa nèt anho tout bagay. ");
INSERT INTO acfNT_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","Épi mwen asiwé, ni lanmò ében lavi, nanj ében lòt pouvwa an syèl anho-a, ni bagay ki ka fèt apwézan ében sa ki kay fèt pli ta, ni pouvwa, ");
INSERT INTO acfNT_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","ni syèl-la ki anho-a ében sa ki anba-a, ni pyès bagay ki janmen fèt, pa kay sa janmen tiwé nou an lanmityé-a Bondyé sèvi Jézi Kwi Senyè nou pou ban nou-an. ");
INSERT INTO acfNT_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","Mwen ka palé lavéwité kon mwen manché an Jézi Kwi-a. Mwen pa ka manti. Konsyans mwen Lèspwi Bondyé ka kondwi-a kay démanti mwen ");
INSERT INTO acfNT_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","si mwen di zòt mizi soufè mwen ja soufè épi mizi lapenn mwen ni an tjè mwen. ");
INSERT INTO acfNT_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","Paski mwen menm té kay avoudwé Jézi modi mwen nèt épi di i pa konnèt mwen si sa té kay édé sé moun-an ki menm nasyon épi mwen-an. ");
INSERT INTO acfNT_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","Yo sé jan péyi Izwayèl, épi Bondyé fè yo vini manmay li. Osi byen i moutwé yo mizi gwan i gwan. I fè agwéman épi yo, épi i ba yo lwa-a. Yo konnèt mannyè-a ki dwèt pou adowé Bondyé-a, épi yo wisivwè sé pwonmèt-la i té fè ba yo-a. ");
INSERT INTO acfNT_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","Sé gwan gwanpapa yo-a té moun ki wèspèkté Bondyé an chay, épi Jézi té menm désandan épi yo lè i té vini an latè-a. Sé Bondyé ki ka kondwi tout bagay. Annou toujou bay Bondyé lonnè. Ensiswatil. ");
INSERT INTO acfNT_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","Bon, sa pa vlé di kon sa Bondyé pa té tjenn pwonmèt li kouman? Paski sé pa tout manmay Izwayèl ki manmay Izwayèl pou vwé. ");
INSERT INTO acfNT_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","Pa tout désandan Abrahanm ki sé ich li pou vwé. Lévanjil-la di, “Mwen kay sèvi gasonʼw Ayzak pou fè an gwan nasyon ban mwen.” ");
INSERT INTO acfNT_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","Anfen sé pa manmay an lachè-a ki sé ich Bondyé pou vwé, mé sé manmay-la Bondyé té fè pwonmèt-la, sé yo ki