﻿USE sofia;
DROP TABLE IF EXISTS sofia.acd_vpl;
CREATE TABLE acd_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES acd_vpl WRITE;
INSERT INTO acd_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yesu Kirisito gi lii daa aye Isirale awura Oloobu Deefidi ɔpaa dɔ, ne Deefidi mɔ gi lii aye Isirale awura aye-naana gyangbarasɛ Aberaham ɔpaa dɔ. Ɔwolɛ baarɛ dɔ gɛrɛ ne a ŋmarasɛ Yesu mɔ-naanaana gɛkorogɛ gigyan so gigyan so yela. A ŋmarasɛ mɔmɔ-anyen lii aye Isirale awura ɔnaana gyangbarasɛ aberɛ kpaa fo Yesu-lɛɛ aberɛ dɔ de fɛꞌ nyɛ bii gɛsu gɛbono dɔ Yesu Kirisito gi lii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Oloobu Aberaham mɔ-bi ne n gyɛ Ayisiki, Ayisiki mɔ-bi ne n gyɛ Gyeekɔpo. Gyeekɔpo mɔ-biana ne n gyɛ Gyuda mɔ‑rɛ mɔ-daana de mɔ-tedɛana. ");
INSERT INTO acd_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Gyuda mɔ-biana ne n gyɛ Pɛrɛsɛ de Saara. (Mɔmɔ-nyi ne n gyɛ Tamarɛ.) Pɛrɛsɛ mɔ-bi ne n gyɛ Hɛsuron, Hɛsuron mɔ-bi ne n gyɛ Ram. ");
INSERT INTO acd_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram mɔ-bi ne n gyɛ Aminadabɛ, Aminadabɛ mɔ-bi ne n gyɛ Naason. Naason mɔ-bi ne n gyɛ Salimon, ");
INSERT INTO acd_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salimon mɔ-bi ne n gyɛ Bowasɛ. (Bowasɛ mɔ-nyi ne n gyɛ Rahabɛ.) Bowasɛ mɔ-bi ne n gyɛ Obɛdɛ. (Mɔ-nyi ne n gyɛ Ruuti.) Obɛdɛ mɔ-bi ne n gyɛ Gyɛsi, ");
INSERT INTO acd_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Gyɛsi mɔ-bi ne n gyɛ Wura Deefidi. Wura Deefidi mɔ-bi ne n gyɛ Solomon. (Nkana Solomon mɔ-nyi mɔ-kuli ne n gyɛ Yuraya.) ");
INSERT INTO acd_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon mɔ-bi ne n gyɛ Rɛhobowan, Rɛhobowan mɔ-bi ne n gyɛ Abigya. Abigya mɔ-bi ne n gyɛ Asa, ");
INSERT INTO acd_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa mɔ-bi ne n gyɛ Gyehosafatɛ. Gyehosafatɛ mɔ-bi ne n gyɛ Gyoram, Gyoram mɔ-bi ne n gyɛ Usiya. ");
INSERT INTO acd_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya mɔ-bi ne n gyɛ Gyotam, Gyotam mɔ-bi ne n gyɛ Ahasɛ. Ahasɛ mɔ-bi ne n gyɛ Hɛsekaya, ");
INSERT INTO acd_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hɛsekaya mɔ-bi ne n gyɛ Menasɛ. Menasɛ mɔ-bi ne n gyɛ Amon, Amon mɔ-bi ne n gyɛ Gyosaya. ");
INSERT INTO acd_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Gyosaya mɔ-bi ne n gyɛ Gyɛkoniya mɔ‑rɛ mɔ-daa de mɔ-tedɛana. Gyɛkoniya baarɛ aberɛ dɔ ne Babilon awura mɛ nyise aye Isirale awura adedaabo kpaa kyena Babilon. ");
INSERT INTO acd_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Mɛ bo Babilon mɔ, Gyɛkoniya gi korogɛ Sɛɛletɛɛ. Sɛɛletɛɛ mɔ-bi ne n gyɛ Serubabelɛ. ");
INSERT INTO acd_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serubabelɛ mɔ-bi ne n gyɛ Abiwudi, Abiwudi mɔ-bi ne n gyɛ Eliyakim. Eliyakim mɔ-bi ne n gyɛ Asoro. ");
INSERT INTO acd_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro mɔ-bi ne n gyɛ Sadokɛ. Sadokɛ mɔ-bi ne n gyɛ Akim, Akim mɔ-bi ne n gyɛ Eliwudi. ");
INSERT INTO acd_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliwudi mɔ-bi ne n gyɛ Eliyeesa, Eliyeesa mɔ-bi ne n gyɛ Matan. Matan mɔ-bi ne n gyɛ Gyeekɔpo, ");
INSERT INTO acd_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Gyeekɔpo mɔ-bi ne n gyɛ Gyosɛfo, Mariya mɔ-kuli. Mariya baarɛ ne n korogɛ Yesu ɔbono ɔ gyɛ Kirisito mɔ. Mɔ ne Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. ");
INSERT INTO acd_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Imɔso aye-naana gyangbarasɛ Aberaham gi korogɛ, ne mɔ-bi gi baa korogɛ. Ne mɔ-naana ɔbono gi korogɛ. Mɛ korogɛ-korogɛ gɛnen gyanꞌgyan abara so gikpadɔ gudu ginan pɛi ne i baa korogɛ Wura Deefidi. Gɛnen kee ne Deefidi gi korogɛ, ne mɔ-bi gi baa korogɛ, ne mɔ-naana ɔbono gi baa korogɛ. Mɛ korogɛ-korogɛ gɛnen gyanꞌgyan abara so gikpadɔ gudu ginan pɛi ne Babilon awura mɛ nyise aye Gyuda awura adedaabo kpaa kyena Babilon ɔsowolɛ so mɔ. Gɛnen kee ne lii ibono mɛ kpe Babilon gɛnen mɔ, ɔnaana ɔbono ɔ tɛ gɛnen owi ɔbono dɔ mɔ gi korogɛ, ne mɔ-bi gi baa korogɛ. Ne mɔ-naana ɔbono gi korogɛ. Mɛ korogɛ-korogɛ gɛnen gyanꞌgyan abara so gikpadɔ gudu ginan pɛi ne i kyu korogɛ ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. ");
INSERT INTO acd_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Fɛꞌ nu gɛnɔɔbono i ba ne mɛ kyu korogɛ Yesu Kirisito mɔ. Imɔ ne nan baa tɔgɛ faa. Owi ɔbono Gyosɛfo kya yɛ Yesu mɔ-nyi Mariya ne mɛŋ ti dɛ de abara mɔ, mɛ san wu daa yɛɛ Mariya laa korogɛ gɛbii naa de Wurubuaarɛ Oduduu mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Gyosɛfo, Mariya mɔ-kuli mɔ, gyɛ isa ɔbono ɔ kya gyi gɛsintin sa Wurubuaarɛ, ne ɔŋ kya laarɛ fɛɛ ɔkyii mɔ oꞌ gyi ipeeli sansana. Imɔso o kyu gɛwɔnsa yɛɛ ɔ laa kine mɔ ŋara dɔ. ");
INSERT INTO acd_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ɔ kya sa gɛnen gɛwɔnsa gɛdɛ mɔ, ɔ naa dɛ ginsi gidɛ, ne Wurubuaarɛ dɔ ɔsɔɔ ɔko gi ba mɔ asɛ oderi dɔ, ne ɔ tɔgɛ sa mɔ yɛɛ, “Gyosɛfo, Wura Deefidi mɔ-naana, gɛŋ sa foꞌ selɛ yɛɛ foŋ baa dena fo-ka Mariya. Ɔtɔ ɔbono ɔ dɛ faa, Wurubuaarɛ Oduduu mɔ ne n yɛgɛ ne ɔ dɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ɔnyen ne ɔ laa korogɛ, ne fo laa yela mɔ-ginyen yɛɛ Yesu, i kya nyiile yɛɛ ɔ laa mɔlɛgɛ mɔ-adɛ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Mariya ilaa idɛ pɛwu i ba daa de iꞌ nyɛ kyena de Wurubuaarɛ agyɛbi abono ɔ wolaa tɔgɛ yela dedaa mɔ. Ɔ wolaa tɔgɛ imɔ yela naa de mɔ-ikalan ɔtɔgɛbo mɔ so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Ɔbono ɔ mɛŋ nyi ɔnyen mɔ laa da ɔtɔ de ɔꞌ korogɛ gɛbii nyensɛɛ, ne mɛ laa terɛ gɛmɔ yɛɛ Imanuɛlɛ.” (Imanuɛlɛ gɛsɛ ne n gyɛ yɛɛ “Wurubuaarɛ bo aye asɛ.”) ");
INSERT INTO acd_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Gyosɛfo gi kyingi mɔ, o kyule ilaa ibono Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ mɔ mɔ, ne o kyu Mariya dena. ");
INSERT INTO acd_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Mɔ‑rɛ mɔ berɛ, mɛ mɛŋ dɛ ginyen de gikyii kaaborɛ ɔ korogɛ gɛbii mɔ. Ne Gyosɛfo gi yela mɔ-ginyen yɛɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Mɛ korogɛ Yesu daa Bɛtelɛhɛm, Gyudiya gɛsinkpan so owi ɔbono Hɛrodɛ gyɛ Gyudiya wura mɔ. Mɛ korogɛ mɔ mɔ, abelɛnsɛ abono mɛ nyi agyɛkpebi ilaa mɔ ako mɛ lii de owi ɔbaaliiten so ba Gyɛrusalem ɔsowolɛ so. ");
INSERT INTO acd_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mɛ baa taasɛ yɛɛ, “Aꞌ kerɛ gɛbii gɛbono mɛ korogɛ ne gɛ laa baa gyi gɛwura sa Gyuda awura mɔ. A wu gɛmɔ-gigyɛkpebi gi baa lii de owi ɔbaaliiten so. Imɔ ne a ba de aꞌ baa ŋmii gɛmɔ de aꞌ kyu buubuu ɔbono ɔ gyɛ gɛmɔ-lɛɛ mɔ kyu sa gɛmɔ faa.” ");
INSERT INTO acd_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wura Hɛrodɛ gi nu ilaa ibono so mɛ naa mɔ, i kyogedɛ mɔ-gisen dɔ. Gɛnen kee ne i kyogedɛ Gyɛrusalem awura mɔ pɛwu asen dɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wura Hɛrodɛ gi terɛ Wurubuaarɛ asunbi alɛɛbo abelɛnsɛ de mɔmɔ Gyuda awura nbara aŋmarasɛbo mɔ pɛwu baa gyan. Ne ɔ taasɛ ɔmɔ yɛɛ, “Nyamesɛ ɔbono mɛ ŋmarasɛ mɔ-ilaa yela yɛɛ Wurubuaarɛ laa sun de ɔꞌ baa gyi gɛwura aye pɛwu so mɔ, fonɛ ne mɛ laa korogɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ne mɛ lɛɛ gɛnɔ yɛɛ, “Mɛ laa korogɛ mɔ daa Bɛtelɛhɛm, Gyudiya gɛsinkpan so. I kya nyiile yɛɛ Wurubuaarɛ gi wolaa yɛgɛ mɔ-ikalan ɔtɔgɛbo ɔko gi ŋmarasɛ Bɛtelɛhɛm ɔsowolɛ mɔ so ilaa yela. ");
INSERT INTO acd_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ɔ ŋmarasɛ yɛɛ, ‘Fo, Bɛtelɛhɛm, Gyudiya gɛsinkpan so ɔsowolɛ, Gyudiya isowolɛ dɔ mɔ, mɛ kya kyu fo yɛɛ foŋ gyɛ ɔsowolɛ gbaa ɔko. Iŋ gyɛ gɛnen. Fo mɔ dɔ ne mɛ laa korogɛ wura belɛ. Mɔ ne nan kerɛ Wurubuaarɛ adɛ Isirale awura mɔ so.’ ” ");
INSERT INTO acd_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Hɛrodɛ adɛ mɔ mɛ tɔgɛ mɔ gɛnen mɔ, ɔ terɛ asafo mɔ lii nkan, ne ɔ taasɛ ɔmɔ de ɔꞌ bii aberɛ abono mɛ wu gigyɛkpebi mɔ gi lii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mɛ tɔgɛ mɔ mɔ, o nyiile ɔmɔ yɛɛ mɛꞌ kpe Bɛtelɛhɛm, ne ɔ tɔgɛ dengɛ ɔmɔ-ansi yɛɛ, “Fɛꞌ kpaa laarɛ gɛbii mɔ dandan. Fɛ wu gɛmɔ mɔ, fɛꞌ yɛgɛ me-aso aꞌ nu de me kee nꞌ kpaa ŋmii gɛmɔ de nꞌ kyu buubuu ɔbono ɔ gyɛ gɛmɔ-lɛɛ mɔ sa gɛmɔ.” ");
INSERT INTO acd_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Asafo mɔ mɛ nu Wura Hɛrodɛ ilaa tɔgɛsɛ mɔ, ne mɛ kyon. Mɛ kya kpe mɔ, mɛ kii wu gigyɛkpebi gibono mɛ wolaa wu owi ɔbaaliiten so mɔ gi gyangbara gi sa ɔmɔ. Aberɛ abono gi fo nfono gɛbii mɔ gɛ bo mɔ, gi yelɛ. ");
INSERT INTO acd_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mɛ wu gigyɛkpebi mɔ gi yelɛ gɛnen mɔ, i wɔra ɔmɔ ɔkon gikyɔ kyɔde. ");
INSERT INTO acd_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Mɛ loo gɛten mɔ dɔ, ne mɛ wu gɛbii mɔ gɛmɔ‑rɛ gɛmɔ-nyi Mariya. Mɛ wu gɛmɔ mɔ, mɛ ŋmii gɛmɔ ne mɛ kyu buubuu sa gɛmɔ. Mɛ bugi mɔmɔ-atɔ ne mɛ lɛɛ ilaa boɔgyalonsɛ sa gɛmɔ. Ilaa mɔ ne n gyɛ sika kɔkɔɔ de onufuii de gitikee. ");
INSERT INTO acd_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Imɔ idɛ gɛmara mɔ, Wurubuaarɛ gi ka sa asafo mɔ oderi dɔ yɛɛ mɛŋꞌ baa kii naa de Hɛrodɛ asɛ. Imɔso mɛ kyu de ɔkpa banban ɔko kpe gɛwi. ");
INSERT INTO acd_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Asafo mɔ mɛ kyon mɔ, imɔ gɛnyɛ mɔ Wurubuaarɛ dɔ ɔsɔɔ ɔko gi ba Gyosɛfo asɛ oderi dɔ baa tɔgɛ mɔ yɛɛ, “Koso puru gɛbii mɔ gɛmɔ‑rɛ gɛmɔ-nyi de fɛꞌ selɛ kpe Igyipiti gɛsinkpan so. Fɛꞌ kyena nno kaaborɛ aberɛ abono nan tɔgɛ fo yɛɛ fɛꞌ kii ba. Wura Hɛrodɛ kya laarɛ gɛbii mɔ imɔɔten.” ");
INSERT INTO acd_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Imɔso Gyosɛfo gi koso ne o puru gɛbii mɔ gɛmɔ‑rɛ gɛmɔ-nyi gɛnyɛ gɛbono selɛ kpe Igyipiti. ");
INSERT INTO acd_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mɛ kyena nno kaaborɛ Wura Hɛrodɛ gi wuꞌ. Mɛ kyu gɛbii mɔ kpe Igyipiti gɛnen mɔ, ilaa ibono Wurubuaarɛ gi wolaa tɔgɛ yela naa de mɔ-ikalan ɔtɔgɛbo mɔ so mɔ i yɛgɛ i ba gɛsintin. I kya nyiile yɛɛ Wurubuaarɛ gi wolaa tɔgɛ yela yɛɛ, “Nɛ terɛ me-bi lii Igyipiti gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wura Hɛrodɛ gi wu yɛɛ asafo mɔ mɛ penɛ mɔ mɛŋ baa naa de mɔ asɛ mɔ, i wɔra mɔ ginyadon gikyɔ kyɔde. Imɔso o sun asa, ne mɛ kpe Bɛtelɛhɛm ɔsowolɛ mɔ‑rɛ mɔ-nsowolɛbi pɛwu ibono i kyaabɔɔ mɔ mɔ, ne mɛ mɔɔ nbii nyensɛ nbono pɛwu gi fo nsi nnyɔ kyu kpelegɛ mɔ. I kya nyiile yɛɛ Hɛrodɛ gi nu lii asafo mɔ asɛ yɛɛ gigyɛkpebi mɔ gi lii mɔ, imɔ-nsi nnyɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Kyu naa de nbii ndɛ lɛwu so ne ilaa ibono Wurubuaarɛ ikalan ɔtɔgɛbo Gyɛrɛmaya mɔ gi tɔgɛ yela mɔ i ba gɛsintin. I kya nyiile yɛɛ Gyɛrɛmaya baarɛ gi wolaa wu asa gikpen giko lɛwu ilaa tɔgɛ yela yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Mɛ nu osulon Rama ɔsowolɛ so. Ako mɛ kya su ne mɛ kya saawo ken-ken. Oloobu Reekyɛlɛ mɔ-naanaana ne n kya su ma‑a sa mɔmɔ-biana. Mɛ tɔgɛ wɔra mɔmɔ kpon. Mɛ mɛŋ nu. I kya nyiile yɛɛ mɔmɔ-biana mɛŋ baa mɛ bo no.” ");
INSERT INTO acd_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wura Hɛrodɛ lɛwu gɛmara mɔ, Wurubuaarɛ dɔ ɔsɔɔ ɔko gi baa lɛɛ mɔ-nyoro nyiile Gyosɛfo oderi dɔ Igyipiti. ");
INSERT INTO acd_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Ne ɔ tɔgɛ mɔ yɛɛ, “Koso, puru gɛbii mɔ gɛmɔ‑rɛ gɛmɔ-nyi de foꞌ kii kpe Isirale gɛsinkpan so. Abono nkana mɛ kya laarɛ gɛbii mɔ-imɔɔten mɔ mɛ wuꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Gɛnen so Gyosɛfo gi koso puru gɛbii mɔ gɛmɔ‑rɛ gɛmɔ-nyi kii kpe Isirale gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ɔ fo nno mɔ, o nu yɛɛ Hɛrodɛ lɛwu gɛmara mɔ, mɔ-bi Arekilosɛ ne n yii mɔ-sɛ giyaa Gyudiya gibaafon so. O nu gɛnen mɔ, i wɔra mɔ gifuu yɛɛ mɛꞌ kii kpe nno kpaa kyena. Ne Wurubuaarɛ gi gya mɔ oderi dɔ yɛɛ ɔŋ sa oꞌ kpe nno. Imɔso mɛ bagɛ kpe Galeli gibaafon so. ");
INSERT INTO acd_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mɛ fo nno mɔ, mɛ kpaa kyena ɔsowolɛ ɔko so mɛ kya terɛ mɔ yɛɛ Nasarɛtɛ. Mɛ kyu gɛbii mɔ kpaa kyena nno gɛnen mɔ, i yɛgɛ ilaa ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wolaa tɔgɛ kyu lii gɛmɔ so mɔ i ba gɛsintin. I kya nyiile yɛɛ mɛ wolaa tɔgɛ yela yɛɛ, “Mɛ laa terɛ mɔ yɛɛ Nasarɛtɛnyen.” ");
INSERT INTO acd_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Gɛnen owi ɔbono mɔ, Gyɔn ɔbono ɔ baa gyere asa Wurubuaarɛ sagyere mɔ gi kpe ɔ tɛ Gyudiya gipen dɔ ɔ kya tɔgɛ ɔ sa abono mɛ kya kpe mɔ asɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Fɛꞌ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ lii ilaa nyɛnyɛn giwɔra dɔ. Idɛ kon ne Wurubuaarɛ laa yɛgɛ mɔ-gɛwuragyi dɔ akyenabi aꞌ ba asa dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Wurubuaarɛ ikalan ɔtɔgɛbo, Isaya, gi wolaa wu Gyɔn baarɛ ilaa ŋmarasɛ yela yɛɛ, “Asa mɛ laa nu ɔko gigyɛbiꞌ gipen dɔ ɔ laa kpen ɔ kya tɔgɛ yɛɛ, ‘Fɛꞌ lɔrɔ fɛye-gɛkyena dɔ gyoo Wurubuaarɛ de ɔꞌ nyɛ naa de ɔkpa ntintin ba fɛye asɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Gyɔn gɛgbɛ suusɛ mɔ, mɛ kyu daa gɛkpatitii ifuu kyu luo gɛmɔ, ne o kyu gɛbuɛ ɔwolɛ wɔra liide. Mɔ-ilaa gyisɛ ne n gyɛ nkpenfuree nko oyuduu de ŋmasan. ");
INSERT INTO acd_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Ɔ bo gipen mɔ dɔ nno mɔ, asa sakyɔ mɛ kya lii Gyɛrusalem ɔsowolɛ so, Gyudiya gɛsinkpan pɛwu so, de gɛsinkpan gɛbono gɛ kyaabɔɔ Gyɔɔdan ɔbon mɔ pɛwu so mɛ kya kpe mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Mɛ kya kpaa lɛɛ ilaa nyɛnyɛn ibonoana mɛ wɔra mɔ tɔgɛ, ne ɔ kya gyere ɔmɔ Wurubuaarɛ sagyere Gyɔɔdan ɔbon dɔ. ");
INSERT INTO acd_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Farasii de Saadusii akpen dɔ awura sakyɔ kee mɛ kpe mɔ asɛ yɛɛ oꞌ gyere mɔmɔ Wurubuaarɛ sagyere. Gyɔn gi wu mɔmɔ gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛ dɛ fɛɛ awɔɔ abono a bo gibɔrɔ mɔ gikpen! Wurubuaarɛ ginyadon gɛkɛ mɔ gɛ kya ba. Ɔ laa biidɛ asa nyɛnyɛn pɛwu giso. Imɔso fɛye kee fɛ wu yɛɛ i kaaborɛ fɛꞌ selɛ lii Wurubuaarɛ ginyadon mɔ dɔ? ");
INSERT INTO acd_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Fɛꞌ wɔra ilaa wɔrasɛ ibono i laa lɛɛ nyiile yɛɛ fɛ nu fɛye-nyoro gɛsɛ gɛsintin mɔ daa. ");
INSERT INTO acd_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Fɛŋ sa fɛꞌ penɛ fɛye-nyoro yɛɛ ibono fɛ kpɛ nyɛ fɛ gyɛ Aberaham ɔpaa dɔ asa faa so mɔ, Wurubuaarɛ laa yɛgɛ kyɛɛ fɛye. Nꞌ tɔgɛ fɛye yɛɛ Wurubuaarɛ laa taalɛ yɛgɛ abui adɛ aꞌ bingiri Aberaham ɔpaa dɔ asa. ");
INSERT INTO acd_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Anyamesɛ mɛ dɛ fɛɛ iyii. Oyii kamaasɛ ɔbono ɔŋ kya sɔrɔ abi mɔ, Wurubuaarɛ gi ti puru mɔ-gɛkyɔɔ ɔ laa ŋɛ mɔ too kyu kpaa wɔra ɔgya dɔ. ");
INSERT INTO acd_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Me, n dɛ daa nkyu n kya gyere fɛye Wurubuaarɛ sagyere de iꞌ lɛɛ nyiile yɛɛ fɛ nu fɛye-nyoro gɛsɛ, fɛ laa kyɛɛgɛ lii fɛye-ilaa nyɛnyɛn giwɔra dɔ. Ɔbono ɔ laa ba me-gɛmara mɔ berɛ, ɔ don me ilaa kamaasɛ dɔ. Fɛɛ nꞌ ba gɛsɛ de nꞌ puru mɔ-ayaawolɛ keda sa mɔ gbaa mɔ, meŋ fo. Gɛnen kaasɛ ɔbono mɔ, Wurubuaarɛ Oduduu de ɔgya ne ɔ laa kyu gyere asa Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","“Kaasɛ ɔbono gi ti baala de ɔꞌ baragɛ ilaa dɛnsɛ awɔrabo lii ilaa nyɛnyɛn awɔrabo dɔ. Ɔ laa kyu ilaa dɛnsɛ awɔrabo mɔ kyu kpaa yela mɔ asɛ de ɔꞌ biidɛ ilaa nyɛnyɛn awɔrabo mɔ giso gɛkpaa-gɛkpaa. I laa wɔra fɛɛ gɛnɔɔbono mɛ kya fon ɔmɔlɔgɔ mɔ. Mɛ kya kyu ɔmɔlɔgɔ abi mɔ yela gɛten dɛnsɛ de mɛꞌ kyu afonfontɛɛ mɔ kpaa fuɛ de mɛꞌ yii amɔ ɔgya. Gɛnen ɔgya ɔbono mɛŋ kya nu giwuꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Nkɛ nbono dɔ mɔ ne Yesu gi lii Galeli gɛsinkpan so kpaa tu Gyɔn Gyɔɔdan ɔbon mɔ asɛ yɛɛ oꞌ gyere mɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Yesu gi tɔgɛ mɔ gɛnen mɔ, Gyɔn mɛŋ laarɛ de oꞌ kyule. Ɔ taasɛ Yesu yɛɛ, “Fo ne n kaaborɛ foꞌ gyere me Wurubuaarɛ sagyere. Ne fo ne n kii ba me asɛ yɛɛ nꞌ gyere fo Wurubuaarɛ sagyere?” ");
INSERT INTO acd_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Yɛgɛ de iꞌ ba gɛnen aberɛ adɛ dɔ. Imɔ-ɔkpa so ne de aꞌ nyɛ wɔra ilaa ibono i gyɛ Wurubuaarɛ gɛlaarɛ mɔ pɛwu.” Yesu gi tɔgɛ gɛnen mɔ, Gyɔn gi nu gɛsɛ, ne o gyere mɔ Wurubuaarɛ sagyere mɔ. ");
INSERT INTO acd_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ɔ kpɛ gyere Yesu Wurubuaarɛ sagyere mɔ ta mɔ, Yesu gi lii nkyu mɔ dɔ. Ɔ baa diirɛ mɔ-ansi kerɛ mɔ, Wurubuaarɛ dɔ i bugi, ne o wu Wurubuaarɛ Oduduu gi kpelegɛ lii nno fɛɛ bonbuɛ baa gyanꞌ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wurubuaarɛ gi tɔngɛ lii soso yɛɛ, “Me-bi ne. Mɔ-ilaa i bo me-gisen dɔ. Ɔ kya gyi me-ginsi.” ");
INSERT INTO acd_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Imɔ gɛmara mɔ Wurubuaarɛ Oduduu mɔ gi kyu Yesu kpe gipen dɔ de ilaa nyɛnyɛn pɛwu gɛmu mɔ ɔꞌ nyɛ soo mɔ idoo kerɛ yɛɛ ɔ laa nyɛ mɔ de oꞌ nu mɔ asɛ? ");
INSERT INTO acd_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Yesu bo gipen mɔ dɔ mɔ, ɔ ŋminde gɛnɔ toloowi kalaadɛ gɛnen‑n nkɛ ikue-inyɔ. Nkɛ ikue-inyɔ mɔ gɛmara mɔ, akon a kya mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Nfono mɔ, ilaa nyɛnyɛn gɛmu mɔ, mɔ ɔbono ɔ kya soo anyamesɛ idoo mɔ, gi ba mɔ asɛ baa tɔgɛ mɔ yɛɛ, “Nengyene gɛsintin fo gyɛ Wurubuaarɛ mɔ-bi mɔ, tɔgɛ abui adɛ yɛɛ aꞌ bingiri agyudɔ.” ");
INSERT INTO acd_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Yesu gi kine, ne ɔ tɔgɛ sa mɔ yɛɛ, “Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ yɛɛ, ‘I mɛŋ gyɛ agyudɔ wolɛ so ne nyamesɛ laa nyɛ gɛkyena; i gyɛ daa Wurubuaarɛ gɛnɔ dɔ gigyɛbi kamaasɛ so.’ ” ");
INSERT INTO acd_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Lii nfono mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kyu Yesu kpe Gyɛrusalem ɔsowolɛ ɔbono Wurubuaarɛ gi lɔrɔ yela sa mɔ-ɔson mɔ. Mɛ fo nno mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kyu Yesu gyanꞌ Wurubuaarɛ ɔson obu mɔ nfono i bo lege-lege mɔ, ");
INSERT INTO acd_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","ne o kii soo mɔ ɔdoo kerɛ yɛɛ, “Nengyene fo gyɛ Wurubuaarɛ mɔ-bi gɛsintin mɔ, lɛɛ fo-nyoro kpaa too gɛsɛ; Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ mɔ, i tɔgɛ yɛɛ, ‘Wurubuaarɛ laa tɔgɛ sa mɔ Wurubuaarɛ dɔ isɔɔ mɔ yɛɛ mɛꞌ kerɛ fo so.’ Ne ‘mɛ laa kɔɔlɛ fo. Gisidi gbaa fo maŋ sidi.’ ” ");
INSERT INTO acd_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yesu gi kine, ne ɔ lɛɛ gɛnɔ yɛɛ, “Wurubuaarɛ agyɛbi mɔ kee a tɔgɛ yɛɛ, ‘Gɛŋ sa foꞌ daasɛ fo-Wura Wurubuaarɛ kerɛ yɛɛ ɔ laa wɔra fo-gɛlaarɛ sa fo.’ ” ");
INSERT INTO acd_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Yesu gi kii kine gɛnen mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kyu Yesu kpe gibii belɛ giko gimu so, ne ɔ yɛgɛ Yesu gi wu gɛsinkpan so isowolɛ kpɛi-kpɛi pɛwu imɔ‑rɛ imɔ-nyisigyi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","O nyiile Yesu gɛnen mɔ, ne o kii soo Yesu ɔdoo kerɛ yɛɛ, “Nengyene fo laa ŋmii de foꞌ kyu buubuu son me mɔ, nan kyu ilaa ibono nɛ nyiile fo faa pɛwu sa fo.” ");
INSERT INTO acd_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Nfono mɔ Yesu gi lɛɛ gɛnɔ kine yɛɛ, “Lii me asɛ, ilaa nyɛnyɛn pɛwu gɛmu! Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ yɛɛ, ‘Ŋmii de foꞌ kyu buubuu sa fo-Wura Wurubuaarɛ. Mɔ-wolɛ guan ne i kaaborɛ fo nyamesɛ foꞌ son.’ ” ");
INSERT INTO acd_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Yesu gi lɛɛ gɛnɔ gɛnen mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi taa mɔ yɛgɛ, ne Wurubuaarɛ dɔ isɔɔ mɛ kpe mɔ asɛ kpaa kerɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Yesu gi nu yɛɛ mɛ keda Gyɔn tii de obu mɔ, ɔ lii nfono kyon kpe Galeli gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ɔŋ baa kyena Nasarɛtɛ ɔsowolɛ so. Ɔ kyon kpaa kyena Kapɛɛniyon ɔsowolɛ ɔbono ɔ bo Galeli ɔbon belɛ mɔ gigengen giko so. Gɛnen gigengen gibono gi bo de Sɛbulun de Nafitali nsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ɔ kpaa kyena nno daa de asa abono mɛ bo nno mɔ mɛꞌ nyɛ Wurubuaarɛ fatela ɔbono Isaya darɛ mɔ-ɔwolɛ dɔ mɔ. Isaya gi wɔra Wurubuaarɛ ikalan ɔtɔgɛbo. Mɔ-ɔwolɛ mɔ dɔ mɔ, ɔ tɔgɛ ");
INSERT INTO acd_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","yɛɛ “Fɛꞌ nu Sɛbulun de Nafitali nsinkpan so asa ilaa. Gɛnen gɛsinkpan gɛbono gɛ bo de Gyɔɔdan ɔbon gibenbɛ giko so kyu kpe de Galeli ɔbon belɛ mɔ asɛ. Asa sakyɔ abono mɛ mɛŋ kya son Wurubuaarɛ mɔ mɛ tɛ saarɛ Gyuda awura dɔ Galeli nno. ");
INSERT INTO acd_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Asa abono mɛ tɛ ilaa nyɛnyɛn gibiri dɔ mɔ mɛ laa nyɛ Wurubuaarɛ fatela oꞌ wu ɔmɔ hayin. Gɛsinkpan so nfono mɛ mɛŋ nyi Wurubuaarɛ asɛ gɛkyena ɔkpa mɔ, idɛ kon gɛdɛ gɛ laa kɛ mɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Lii owi ɔbono Yesu gi kpe Galeli mɔ, o yii gɛsɛ ɔ kya tɔgɛ ɔ kya sa asa yɛɛ, “Fɛꞌ nu fɛye-nyoro gɛsɛ de fɛꞌ taa fɛye-ilaa nyɛnyɛn giwɔra yɛgɛ. Idɛ kon ne Wurubuaarɛ laa yɛgɛ mɔ-gɛwuragyi dɔ akyenabi aꞌ ba asa dɔ ne.” ");
INSERT INTO acd_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Gɛkɛ gɛdɛ mɔ, Yesu naa Galeli ɔbon belɛ mɔ gigengen so mɔ, o wu iken alɛɛbo anyɔ ako, Simon Piita mɔ‑rɛ mɔ-tedɛ Andiru, mɛ kya too asɛwu. ");
INSERT INTO acd_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yesu gi wu mɔmɔ mɔ, ɔ tɔgɛ sa ɔmɔ yɛɛ, “Fɛꞌ baa buu me de fɛꞌ wɔra me-akasɛbo. Nɛ wu yɛɛ nkana fɛ gyɛ iken alɛɛbo. Nperɛ berɛ nan yɛgɛ fɛꞌ san laarɛ daa asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Ɔ tɔgɛ sa mɔmɔ gɛnen mɔ, ayaa abono so mɔ, mɛ taa mɔmɔ-asɛwu mɔ yɛgɛ, ne mɛ naa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mɛ naa kpe ansi dɔ ŋmaraa mɔ, o kii wu ɔnyen ɔko mɔ‑rɛ mɔ-tedɛ, Gyeemesi de Gyɔn, Sɛbedi mɔ-biana. O wu mɔmɔ mɔ, mɔmɔ‑rɛ mɔmɔ-sɛ mɛ bo gikolii dɔ mɛ kya lɔrɔ mɔmɔ-asɛwu, ne ɔ tɔgɛ mɔmɔ yɛɛ mɛꞌ baa wɔra mɔ-akasɛbo. ");
INSERT INTO acd_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Ayaa abono so mɔ, mɛ taa mɔmɔ-gikolii mɔ de mɔmɔ-sɛ yɛgɛ, ne mɛ naa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Yesu gi kingi de Galeli gɛsinkpan so pɛwu ɔ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ɔ kya sa asa. Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ ilaa ne ɔ dɛ ɔ kya nyiile ɔmɔ gɛnen. Ɔ naa mɔmɔ Gyuda awura akyangbon dɔ ɔ kya nyiile asa, ne ɔ naa asa mɔ dɔ ɔ kya kyɛ mɔmɔ-alɔbi kpɛi-kpɛi kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Mɔ-ilaa wɔrasɛ i kpaa nu gyanꞌ de Siiriya gɛsinkpan so, imɔso asa mɛ sola mɔmɔ-alɔbo pɛwu ba mɔ asɛ. Alɔbo mɔ mɛ kya lɔ alɔbi nyɛnyɛn de alɔbi kpɛi-kpɛi. Ako mɛ kya lɔ gilɔ tɔrɔsɛ ne ako mɛ gyɛ ɔtɛgɛsɛana, ne ɔ kyɛ mɔmɔ pɛwu. Ɔ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi lii ako so kee. ");
INSERT INTO acd_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Sakpii belɛ naa o buu mɔ. Ako mɛ lii Galeli, ne ako mɛ lii Isowolɛ Gudu gɛsinkpan so. Ako mɛ lii Gyɛrusalem de isowolɛ sɛnsɛ ibono i bo Gyudiya gɛsinkpan mɔ so. Ako kee mɛ lii gɛsinkpan gɛbono gɛ bo Gyɔɔdan ɔbon gibenbɛ giko mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Yesu gi wu sakpii belɛ mɔ mɔ, ɔ dii kpe gibii giko so, ne ɔ kpelegɛ kyena. Mɔ-akasɛbo mɔ mɛ baa kyena kyaabɔɔ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ne o yii gɛsɛ ɔ kya nyiile ɔmɔ ilaa yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Amudɛnsɛbo ne n gyɛ abono ilaa i tiri mɔmɔ ne mɛ kerɛ daa Wurubuaarɛ mɔ. Wurubuaarɛ gɛwuragyi dɔ akyenabi a gyɛ mɔmɔ-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Amudɛnsɛbo ne n gyɛ asa abono mɔmɔ-asen dɔ i kya dɛɛ mɔmɔ mɔ. Wurubuaarɛ laa yɛgɛ mɔmɔ-asen aꞌ tɔrɔ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Amudɛnsɛbo ne n gyɛ asa abono mɛ kya bara mɔmɔ-nyoro gɛsɛ mɔ. Mɔmɔ ne nan baa nyɛ gɛsinkpan mɔ so gɛkyena gɛbono Wurubuaarɛ gi ka yela sa mɔ-adɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Amudɛnsɛbo ne n gyɛ asa abono mɛ kya laarɛ mɛꞌ gyi gɛsintin sa Wurubuaarɛ ne i kya tiri mɔmɔ fɛɛ akon abɛɛ bolefɔ ne n dɛ ɔmɔ mɔ. Wurubuaarɛ laa kpaa mɔmɔ de mɛꞌ taalɛ gyi gɛsintin sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Amudɛnsɛbo ne n gyɛ asa abono mɛ kya su asa gitolon mɔ. Wurubuaarɛ laa su mɔmɔ gitolon kee. ");
INSERT INTO acd_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Amudɛnsɛbo ne n gyɛ asa abono mɔmɔ-asen dɔ i fuuli mɔ. Mɛ laa nyɛ wu Wurubuaarɛ de mɔmɔ-ansi. ");
INSERT INTO acd_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Amudɛnsɛbo ne n gyɛ asa abono mɛ kya bara gisen yuuli asa dɔ mɔ. Wurubuaarɛ laa terɛ mɔmɔ yɛɛ mɔ-biana gɛsintin. ");
INSERT INTO acd_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Amudɛnsɛbo ne n gyɛ asa abono mɛ kya gyi gɛsintin sa Wurubuaarɛ, ne ako mɛ kya ka mɔmɔ-ansi kyu lii imɔ so mɔ. Wurubuaarɛ gɛwuragyi dɔ akyenabi a gyɛ mɔmɔ-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Amudɛnsɛbo ne n gyɛ fɛye abono fɛ gyɛ me-akasɛbo ne me so ne asa mɛ kya saalɛ fɛye, ne mɛ kya ka fɛye-ansi, ne mɛ kya kɛɛ abon kpɛi-kpɛi ma‑a gyan fɛye so. ");
INSERT INTO acd_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Fɛꞌ yɛgɛ iꞌ wɔra fɛye ɔkon de fɛꞌ kyaa. I lii fɛɛ Wurubuaarɛ ntɛɛla belɛ gi dɛ sa fɛye Wurubuaarɛ dɔ. Fafaanan ne mɛ ka Wurubuaarɛ ikalan atɔgɛbo abono mɛ kyena kyena kyon mɔ ansi kee ne.” ");
INSERT INTO acd_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Yesu gi da gikpalɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛ dɛ fɛɛ nfɔlɛ sa gɛsinkpan so asa. Ne fɛɛ nfɔlɛ gi ta nmɔ-ɔkon mɔ, nnɛ ne fɛ laa wɔra de giꞌ kii wɔra ɔkon? Nmɔ-agyan a ta. Mɛ laa too nmɔ fuɛ daa de asa mɛꞌ kyise nmɔ de ayaa. ");
INSERT INTO acd_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Fɛ dɛ fɛɛ fatela sa gɛsinkpan so asa. Fɛye so mɔ, asa mɛ laa bii Wurubuaarɛ gɛsintin ɔkpa mɔ kusaa fɛɛ gɛnɔɔbono ɔsowolɛ gyan gibii so ne ɔŋ kya ŋara mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ɔko mɛŋ bo no ɔ laa nyɔga fatela de oꞌ kyu fɛɛ gɛlɔbi bun mɔ so. Ɔ laa kyu kyɔlɔga daa de iꞌ nyɛ wu ɔkamaasɛ ɔbono ɔ bo gɛten mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Gɛnen kee ne i kaaborɛ fɛꞌ yɛgɛ fɛye-idɛnsɛ ibono fɛ kya wɔra mɔ iꞌ wɔra fɛɛ fatela de asa mɛꞌ nyɛ wu de mɛꞌ yen fɛye-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Fɛ nyi yɛɛ nɛ ba de nꞌ baa kyɛɛgɛ Mosisi nbara mɔ abɛɛ ilaa ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ tɔgɛ yela mɔ daa? Kuaa, nɛ ba daa de nꞌ baa yɛgɛ iꞌ ba fɛɛ gɛnɔɔbono mɛ ŋmarasɛ yela mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fɛɛ gɛnɔɔbono Wurubuaarɛ dɔ iŋ tii yela ɔkara faa mɔ, Wurubuaarɛ nbara nbono ɔ yela mɔ, ba‑a nmɔ-gigyɛbi kolon gi maŋ kyɛɛgɛ kaaborɛ ilaa kamaasɛ ibono mɛ ŋmarasɛ yela mɔ i ba gɛsintin. ");
INSERT INTO acd_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Lii gɛnen so mɔ fo ɔbono fo laa tɔgɛ yɛɛ nbara nko giŋ tiri ne fo maŋ gyi nmɔ so mɔ, fo kee fo maŋ wɔra nyamesɛ tirisɛ Wurubuaarɛ gɛwuragyi gɛkyena mɔ dɔ. Ne fo ɔbono fo nyiile asa kee yɛɛ iŋ tiri yɛɛ mɛꞌ gyi Wurubuaarɛ nbara mɔ nko so mɔ, fo kee fo maŋ wɔra nyamesɛ tirisɛ Wurubuaarɛ gɛwuragyi gɛkyena mɔ dɔ. Fo ɔbono, mɔ, fo laa gyi nmɔ so ne fo laa nyiile asa yɛɛ mɛꞌ gyi nmɔ so mɔ, fo ne nan wɔra nyamesɛ tirisɛ Wurubuaarɛ gɛwuragyi gɛkyena mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nꞌ tɔgɛ fɛye yɛɛ nengyene fɛ maŋ gyi gɛsintin don ibono nbara aŋmarasɛbo mɔ de Farasii awura mɔ mɛ kya wɔra mɔ, fɛ maŋ nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ kpa‑a. ");
INSERT INTO acd_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Fɛ nu yɛɛ dedaa mɔ, Wurubuaarɛ nbara aŋmarasɛbo mɔ mɛ tɔgɛ yɛɛ, ‘Fɛŋ sa fɛꞌ mɔɔ isa. Ɔbono ɔ mɔɔ isa mɔ, mɛꞌ kperɛ mɔ nbɛlɛ agyibo asɛ.’ ");
INSERT INTO acd_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Mi‑i me mɔ, n kya tɔgɛ mi‑i tigi fɛye yɛɛ fo ɔkamaasɛ ɔbono fo kpɛ nyɛ sɔɔ ginyadon wɔra fo-nanbo gbaa mɔ, mɛꞌ kperɛ fo nbɛlɛ agyibo asɛ. Fo ɔbono fo saalɛ fo-nanbo yɛɛ ɔŋ bo giko dɔ mɔ, mɛꞌ kperɛ fo nbɛlɛ agyibo abelɛnsɛ asɛ. Ɔbono, mɔ, ɔ laa tɔgɛ sa mɔ-nanbo yɛɛ ɔŋ bo asa dɔ mɔ, mɔ berɛ, ɔ kya sa mɔ-nyoro ɔkpa de oꞌ kpe ɔgya ɔbono Wurubuaarɛ kya biidɛ ilaa nyɛnyɛn awɔrabo giso mɔ dɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","24","“Lii imɔ idɛ so mɔ, nengyene fo ɔko fo kpe Wurubuaarɛ asunbi ɔlɛɛten foꞌ kpaa lɛɛ asunbi ne fo nyingi yɛɛ fo tɔrɔ fo-nanbo so mɔ, taa fo-asunbi atɔ mɔ yɛgɛ nno de foꞌ kpe de fo‑rɛ fo-nanbo mɔ fɛꞌ kpaa tɔgɛ lɔrɔ pɛi de foꞌ lɔɔ kii baa lɛɛ gɛnen asunbi abono sa Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Nengyene ɔko gi terɛ fo ɔko nbɛlɛ ne fɛ kya kpe nbɛlɛ mɔ ogyiten mɔ, fɛꞌ wolaa tɔgɛ lɔrɔ ɔkpa dɔ nno pɛi de fɛꞌ lɔɔ loo. I mɛŋ gyɛ gɛnen mɔ, foŋbii ɔ laa kyu fo kpe nbɛlɛ ogyibo mɔ asɛ de ɔbono, mɔ, oꞌ kyu fo kpaa wɔra ngbɛ awura ɔbelɛnsɛ abaa dɔ de ɔꞌ keda fo tii de obu. ");
INSERT INTO acd_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, mɛ keda fo tii de obu gɛnen mɔ, fo laa sii nno gɛnen‑n kpaa fo owi ɔbono ɔkara mɛꞌ wu yɛɛ fo ka fo-ilaa nyɛnyɛn gikɔ mɔ ta, pɛi de mɛꞌ lɔɔ tigi fo. ");
INSERT INTO acd_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Fɛ nu mɛ naa kyena tɔgɛ yɛɛ, ‘Gɛŋ sa foꞌ lii fo-ka abɛɛ fo-kuli gɛmara.’ ");
INSERT INTO acd_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Mi‑i me mɔ, n kya tɔgɛ mi‑i sa fɛye yɛɛ fo ɔbono fo wu ɔkyii ne fo sa gɛwɔnsa yɛɛ fo nyɛ mɔ, fo laa laarɛ mɔ mɔ, fo ti nyida gɛdena ne. ");
INSERT INTO acd_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Nengyene fo ɔko fo gyisɛ ginsi gi kya wu ilaa ne i kya yɛgɛ fo kya wɔra ilaa nyɛnyɛn mɔ, lɔgedɛ gimɔ lɛɛ fuɛ! Fo-nyoro gɛtɛɛko i lii giden ne fo nyɛ kyena Wurubuaarɛ asɛ mɔ, i boran don ibono Wurubuaarɛ laa kyu fo-nyoro gimumuli too wɔra ɔgya dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ne fɛɛ fo gyisɛ gibaa ne n kya yɛgɛ fo kya wɔra ilaa nyɛnyɛn mɔ, kɛbi gimɔ fuɛ. Fo-nyoro gɛtɛɛko i lii giden ne fo nyɛ kyena Wurubuaarɛ asɛ mɔ, i boran don ibono Wurubuaarɛ laa kyu fo-nyoro gimumuli too wɔra ɔgya dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Gɛnen kee ne mɛ naa kyena tɔgɛ yɛɛ, ‘Ɔbono ɔ laa kine mɔ-ka mɔ, i kaaborɛ ɔꞌ sa mɔ gikine ɔwolɛ.’ ");
INSERT INTO acd_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Mi‑i me mɔ, n kya tɔgɛ mi‑i sa fɛye yɛɛ nengyene i mɛŋ gyɛ yɛɛ fo-ka gi lii fo-gɛmara daa so ne fo kine mɔ ne ɔkyii mɔ gi kpaa dena ɔbanban mɔ, fo ne n yɛgɛ mɔ ɔ nyida gɛdena gɛnen. Ne ɔnyen ɔbono ɔ dena gɛnen ɔkyii ɔbono mɔ, mɔ, kee gi tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara. Wurubuaarɛ kya kyu imɔ yɛɛ ɔko mɔ-ka ne ɔ laarɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Gɛnen kee ne fɛ nu yɛɛ dedaa mɔ nbara aŋmarasɛbo mɔ mɛ tɔgɛ sa asa yɛɛ, ‘Nengyene fɛ ka ntan sa Wurubuaarɛ mɔ, fɛꞌ gyi nmɔ so; fɛŋ sa fɛꞌ yɛgɛ iꞌ gbangɛ.’ ");
INSERT INTO acd_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Mi‑i me mɔ, n kya tɔgɛ fɛye yɛɛ, ntan ne n gyɛ ntan, fɛŋ sa fɛꞌ ka. Fɛŋ sa fɛꞌ ka yɛɛ ‘a kerɛ fɛɛ soso,’ i lii fɛɛ soso nno mɔ, i gyɛ Wurubuaarɛ gɛwura gɛgyapaa. ");
INSERT INTO acd_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Fɛŋ sa fɛꞌ tɔgɛ yɛɛ ‘a kerɛ fɛɛ gɛsinkpan.’ Gɛsinkpan ne n gyɛ Wurubuaarɛ ayaa okyiseten. Fɛŋ sa fɛꞌ ka yɛɛ ‘a kerɛ fɛɛ Gyɛrusalem.’ Wurubuaarɛ gyɛ Wura belɛ sa ɔkamaasɛ, ne Gyɛrusalem ne n gyɛ mɔ-ɔsowolɛ gbaaꞌ gɛsinkpan gɛdɛ so. ");
INSERT INTO acd_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Fɛŋ sa fɛꞌ ka yɛɛ ‘a kerɛ fɛɛ aye-amu’. I kya nyiile yɛɛ fɛ maŋ taalɛ yɛgɛ fɛye-amu ɔman kolon oꞌ fuuli abɛɛ oꞌ biiri. ");
INSERT INTO acd_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Fɛꞌ yɛgɛ fɛye-‘ɛn’ ɔꞌ wɔra ‘ɛn’, de fɛye-‘kuaa’ ɔꞌ wɔra ‘kuaa’. Ilaa ibono i laa kii bɔla imɔ idɛ so mɔ, i laa lii daa Ɔbonsan, nyamesɛ nyɛnyɛn mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Mɛ kii tɔgɛ sa adedaabo mɔ yɛɛ, ‘Ɔbono ɔ boori mɔ-nanbo ginsi mɔ, mɛꞌ boori mɔ-lɛɛ kee ka gikɔ. Ɔbono ɔ kyigi mɔ-nanbo ginyi mɔ, mɛꞌ kyigi mɔ-lɛɛ kee ka gikɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Me, mɔ, n kya tɔgɛ mi‑i sa fɛye yɛɛ nengyene ɔko gi wɔra fo ɔko ilaa nyɛnyɛn mɔ, gɛŋ sa foꞌ kyu ilaa nyɛnyɛn ka mɔ gikɔ. Ɔko gi da fo ɔtan gyisɛ so mɔ, kisee benɛ-lɛɛ mɔ kee sa mɔ de oꞌ kii da. ");
INSERT INTO acd_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Fo dɛ ɔko gikɔ ne ɔ terɛ fo nbɛlɛ, ne yɛɛ ɔ laa kyu fo-gɛgbɛ kyu yii giyaa mɔ, tɛsɛ kyu fo awo gɛgbɛ kee bɔla mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ɔko gi nyise fo yɛɛ foꞌ sola mɔ-gɛsola sa mɔ gikpaaten kolon mɔ, sola sa mɔ de fo‑rɛ mɔ fɛꞌ naa akpaaten anyɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ɔko gi kolɛ fo ilaa iko ne fo bo mɔ, sa mɔ. Ne ɔko kya laarɛ de ɔꞌ paa fo ilaa iko ne fo bo imɔ mɔ, paa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Fɛ nu mɛ tɔgɛ gɛdɛ gɛko yɛɛ, ‘Fɛꞌ laarɛ fɛye-nanboana ilaa de fɛꞌ kyo fɛye-akyobo.’ ");
INSERT INTO acd_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Me berɛ n kya tɔgɛ fɛye yɛɛ fɛꞌ laarɛ fɛye-akyobo kee ilaa de fɛꞌ dalaa sa asa abono mɛ kya ka fɛye-ansi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Fɛ kya wɔra gɛnen mɔ, fɛ laa wɔra fɛye-sɛ ɔbono ɔ bo soso mɔ mɔ-biana. I lii fɛɛ Wurubuaarɛ kya yɛgɛ owi kya lii sa anyamesɛ dɛnsɛ de anyɛnyɛn pɛwu. Ɔ kya yɛgɛ nyangbon kya da sa abono mɛ kya gyi gɛsintin sa mɔ de abono mɛŋ kya gyi gɛsintin sa mɔ mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Fɛ kya laarɛ asa abono mɛ kya laarɛ fɛye-ilaa wolɛ mɔ, nnɛ so ne Wurubuaarɛ laa tɛɛla fɛye? Lɛnpoo asɔɔbo abono mɛ kya kudi asa gyi mɔ gbaa kee mɛ kya laarɛ daa abono mɛ kya laarɛ mɔmɔ-ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Nengyene fɛ kya faala daa fɛye-subuana wolɛ mɔ, fɛ wɔra ilaa don asa sɛnsɛ mɔ ne? Gɛsinkpan so asa kpɛi-kpɛi abono mɛ mɛŋ kya son Wurubuaarɛ mɔ gbaa mɛ kya faala mɔmɔ-subuana gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Imɔso fɛꞌ yɛgɛ fɛye-ginyamesɛ dɛnsɛ giꞌ ta gudu fɛɛ gɛnɔɔbono fɛye-sɛ Wurubuaarɛ-lɛɛ gi ta gudu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Fɛ laa wɔra gidɛnsɛ mɔ, fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de iŋ sa iꞌ ba yɛɛ asa so ne fɛ kya wɔra de mɛꞌ wu de mɛꞌ yen fɛye. Nengyene gɛnen ne n gyɛ fɛye-nwɔnsa mɔ, fɛ maŋ baa nyɛ ntɛɛla nko lii fɛye-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Fɛɛ fɛ wɔra idɛnsɛ sa ayenbo mɔ, fɛŋ sa fɛꞌ kyu imɔ kyu da gikpengboo. Gɛnen ne abono mɛ kya diirɛ mɔmɔ-nyoro mɔ mɛ kya wɔra mɔmɔ-akyangbon dɔ de sansana de asa mɛꞌ nyɛ yen mɔmɔ ne. Mɛ wɔra gɛnen mɔ, ntɛɛla nbono mɛ laa nyɛ mɔ pɛwu ne. ");
INSERT INTO acd_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Nengyene fo kyu benɛ wɔra gidɛnsɛ sa yenbo mɔ, gɛŋ yɛgɛ de gyisɛ ɔꞌ bii ");
INSERT INTO acd_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","de gɛnen gidɛnsɛ gibono fo wɔra mɔ giŋ sa giꞌ lii gɛwi. I ba gɛnen mɔ, fo-sɛ Wurubuaarɛ ɔbono ɔ kya wu asiiri dɔ mɔ ne nan tɛɛla fo. ");
INSERT INTO acd_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Fɛ laa dalaa kee mɔ, fɛŋ sa fɛꞌ wɔra fɛɛ asa abono mɛ kya son Wurubuaarɛ ansi so giyan mɔ. Mɛ kya dalaa mɔ, mɔmɔ-ilaa laarɛsɛ ne n gyɛ yɛɛ mɛꞌ kpaa yelɛ mɔmɔ-akyangbon dɔ abɛɛ sansana de nyamesɛ kamaasɛ ɔꞌ nyɛ wu mɔmɔ yɛɛ mɔmɔ ne n yelɛ mɛ kya dalaa faa. Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, mɛ kya wɔra gɛnen mɔ, ntɛɛla nbono mɛ laa nyɛ mɔ pɛwu ne. ");
INSERT INTO acd_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Fɛye berɛ, fo ɔko fo laa dalaa mɔ, loo fo-obu dɔ de foꞌ tii gisin wɔra fo-nyoro de foꞌ dalaa sa fo-sɛ Wurubuaarɛ ɔbono asa mɛŋ kya wu mɔ de ansi mɔ. Mɔ ɔbono ɔ kya wu asiiri dɔ mɔ laa nu fo-gɛdalaa. ");
INSERT INTO acd_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Fɛ laa dalaa mɔ, fɛŋ sa fɛꞌ tɔgɛ ilaa kolon fɛ kya kpe fɛ kya ba bolo-bolo. Gɛnen ne asa abono mɛŋ nyi Wurubuaarɛ agyɛbi mɔ mɛ kya dalaa ne. Mɔmɔ asɛ mɔ mɛ nyi daa yɛɛ nengyene mɛ kya dalaa ilaa kolon mɛ kya kpe mɛ kya ba bolo-bolo gɛnen mɔ, imɔ ne nan yɛgɛ mɔmɔ-ikperɛ iꞌ nu mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Fɛye berɛ, fɛŋ sa fɛꞌ wɔra fɛɛ mɔmɔ. Pɛi de fɛ dalaa mɔ, fɛye-sɛ Wurubuaarɛ ti o nyi ilaa ibono i tiri fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","“Imɔso ɔkpa ɔbono so fɛ laa kyu dalaa mɔ ne n gyɛ yɛɛ: ‘Aye-sɛ, fo ɔbono fo bo soso, yɛgɛ asa mɛꞌ buu fo yɛɛ fo-nkon ne n gyɛ Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Yɛgɛ fo-gɛwuragyi dɔ akyenabi aꞌ ba asa dɔ. Yɛgɛ fo-gɛlaarɛ gɛꞌ wɔra gɛsinkpan so, fɛɛ gɛnɔɔbono fo-gɛlaarɛ gɛ kya wɔra soso fo asɛ nno mɔ. ");
INSERT INTO acd_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Sa aye ndɛ gɛkɛ gɛdɛ-lɛɛ ilaa gyisɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Kyu aye-ilaa nyɛnyɛn kyu kyɛɛ aye fɛɛ gɛnɔɔbono aye kee a kyu ilaa nyɛnyɛn ibono asa mɛ wɔra aye mɔ kyu kyɛɛ ɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kpaa aye de ilaa iko iŋ sa iꞌ nyɛ aye penɛ de aꞌ wɔra ilaa nyɛnyɛn. Mɛŋ sa foꞌ yɛgɛ de aꞌ loo ilaa nyɛnyɛn pɛwu gɛmu mɔ abaa dɔ. I lii fɛɛ gɛwuragyi, ɔlon, de nyisigyi i gyɛ daa fo-lɛɛ gɛkpaa-gɛkpaa. Iꞌ ba gɛnen.’ ");
INSERT INTO acd_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Nengyene fɛ kyu asa ilaa nyɛnyɛn ibono mɛ wɔra fɛye mɔ kyu kyɛɛ ɔmɔ mɔ, fɛye-sɛ ɔbono ɔ bo soso mɔ kee laa kyu fɛye-lɛɛ ilaa nyɛnyɛn kyu kyɛɛ fɛye. ");
INSERT INTO acd_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Nengyene fɛ maŋ kyu asa ilaa nyɛnyɛn kyɛɛ mɔmɔ mɔ, fɛye-sɛ Wurubuaarɛ kee maŋ kyu fɛye-lɛɛ ilaa nyɛnyɛn kyu kyɛɛ fɛye. ");
INSERT INTO acd_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Fɛ laa ŋminde gɛnɔ kee mɔ, fɛ mɛŋ sa fɛꞌ bɔɔda. Gɛnen ne asa abono mɛ kya son Wurubuaarɛ ansi so giyan mɔ mɛ kya wɔra ne. Mɛ kya taa mɔmɔ-nyoro yɛgɛ de ɔkamaasɛ gi nyɛ ne o wu mɔmɔ mɔ ɔꞌ nyɛ bii yɛɛ mɛ ŋminde nnɔ. N kya tɔgɛ fɛye gɛsintin yɛɛ mɛ kya wɔra gɛnen mɔ, ntɛɛla nbono mɛ laa nyɛ mɔ pɛwu ne. ");
INSERT INTO acd_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Fɛye berɛ fo ɔko fo laa ŋminde gɛnɔ mɔ, foro fo-ansi de foꞌ pubuu fo-gimu ");
INSERT INTO acd_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","de ɔko‑rɛ ɔko ɔ mɛŋ sa ɔꞌ bii yɛɛ fo ŋminde gɛnɔ. Gɛnen mɔ, fo-sɛ Wurubuaarɛ ɔbono asa mɛŋ kya wu de ansi mɔ wolɛ ne ɔꞌ bii sa fo. Mɔ ɔbono ɔ kya wu asiiri dɔ mɔ ne nan tɛɛla fo. ");
INSERT INTO acd_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Fɛ mɛŋ sa fɛꞌ baala atɔ yela sa fɛye-nyoro gɛsɛ gɛrɛ. Gɛrɛnaa mɔ ntakpenbi gi laa nyida amɔ abɛɛ a laa kuu ideri abɛɛ iyu mɛ laa boori loo puru koso. ");
INSERT INTO acd_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Fɛꞌ wɔra idɛnsɛ gɛsɛ gɛrɛ de fɛꞌ kpaa nyɛ imɔ so ntɛɛla Wurubuaarɛ dɔ. Wurubuaarɛ dɔ-lɛɛ ntɛɛla berɛ, ntakpenbi giŋ kya nyida imɔ ne iŋ kya kuu ideri ne iyu mɛŋ kya nyɛ boori loo nno kpaa puru. ");
INSERT INTO acd_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","I lii fɛɛ nfono fɛye-atɔ a bo mɔ nfono kee ne fɛye-nwɔnsa gi bo. ");
INSERT INTO acd_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Fɛye-nwɔnsa gi boran mɔ, fɛ dɛ fɛɛ ɔbono mɔ-ansi a boran mɔ. Fɛye-ansi a boran mɔ, fɛ laa wu ilaa kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne fɛɛ fɛye-ansi aŋ boran mɔ, fɛye-ilaa kamaasɛ i bo daa gibiri dɔ. Nengyene feyɛ-gɛwɔnsa gɛbono gɛ kya yɛgɛ fɛ kya nu ilaa gɛsɛ mɔ gɛ nyida mɔ, fɛ laa wɔra fɛɛ agyaatanbo. Fɛ laa tansi kyena gibiri dɔ sirim! ");
INSERT INTO acd_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Nyamesɛ ɔko mɛŋ bo no ɔ laa taalɛ son awura anyɔ. Ɔ laa laarɛ ɔko ilaa de ɔꞌ kyo ɔko, abɛɛ ɔ laa buu ɔko, ne ɔ maŋ kyu ɔbanban mɔ terɛ sɛi. Fɛ maŋ taalɛ son Wurubuaarɛ de fɛꞌ kii son aterenbi. ");
INSERT INTO acd_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Imɔso n kya tɔgɛ mi‑i sa fɛye yɛɛ fɛŋ sa fɛꞌ suiili kyu lii fɛye-gɛkyena dɔ ilaa tirisɛ so, fɛɛ ilaa ibonoana fɛ laa gyi abɛɛ fɛ laa nun abɛɛ fɛ laa kyu gyanꞌ fɛye-nyoro so mɔ. Wurubuaarɛ ɔbono ɔ sa fɛye nkpa mɔ maŋ taalɛ sa fɛye agyudɔ kee? Ɔbono ɔ sa fɛye nyoro gibi mɔ maŋ taalɛ sa fɛye ilaa ibono fɛ laa kyu gyanꞌ fɛye-nyoro so mɔ? ");
INSERT INTO acd_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Fɛꞌ taa laa ansi kerɛ nbuii. Giŋ kya duu, giŋ kya tɛɛ, ne giŋ bo agyudɔ ikoolayelaten. Imɔ‑rɛ imɔ gɛnen gbaa faa, fɛye-sɛ ɔbono ɔ bo soso mɔ kya sa mɔmɔ agyudɔ owi kamaasɛ dɔ. Ne fɛye mɔ de‑e? Fɛ mɛŋ nyi yɛɛ fɛ don nbuii gbaa bun? ");
INSERT INTO acd_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Fɛye dɔ anɛ ne nan sa gɛwɔnsa mɔ-nyoro so de ɔꞌ taalɛ kyu ba‑a gɛkɛ kolon bɔla mɔ-nkpa so? ");
INSERT INTO acd_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Ne menɛtɔ so ne fɛ kya suiili ilaa ibono fɛ laa kyu gyanꞌ fɛye-nyoro mɔ so? Fɛꞌ laa ansi kerɛ gɛnɔɔbono iyii i kya wɔra afototo mɔ. Iŋ kya wɔra gɛsun, ne iŋ kya luo akuru sa imɔ-nyoro. ");
INSERT INTO acd_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Imɔ gɛnen gbaa mɔ, n kya buu mi‑i sa fɛye yɛɛ, Wura Solomon mɔ‑rɛ mɔ-awuratɔ pɛwu mɔ, ɔ mɛŋ nyɛ akuru abono a wɔra ɔdan fo gɛnen afototo adɛ. ");
INSERT INTO acd_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Iyii ibono i kya bingiri ngya mɔ gbaa ne Wurubuaarɛ kya gyere imɔ lɔrɔ kanpɛ faa. Fɛye anyamesɛ ne ɔ laa lɛɛ ansi yɛgɛ de fɛꞌ naa gibolonbukpan? O, fɛye asa adɛ! Gisɔɔgyi gibono fɛ bo sa Wurubuaarɛ mɔ giŋ kyɔ. ");
INSERT INTO acd_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Fɛŋ baa suiili yɛɛ, ‘Menɛ ne a laa gyi? Menɛ ne a laa nun? Menɛ ne a laa kyu gyanꞌ aye-nyoro so?’ ");
INSERT INTO acd_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Asa abono mɛ mɛŋ nyi Wurubuaarɛ agyɛbi mɔ ansi ne n kya pɛɛrɛ gɛnen ilaa idɛana so. Fɛye-sɛ ɔbono ɔ bo soso mɔ nyi yɛɛ i tiri fɛye. ");
INSERT INTO acd_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Fɛye berɛ, fɛꞌ laarɛ daa gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi a laa ba asa dɔ mɔ de fɛꞌ nyanga ansi gyi gɛsintin sa Wurubuaarɛ. Fɛ ti fɛ kya wɔra gɛnen mɔ, Wurubuaarɛ laa yɛgɛ ilaa sɛnsɛ idɛana pɛwu kee iꞌ yii fɛye-abaa. ");
INSERT INTO acd_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Imɔso fɛ mɛŋ sa fɛꞌ suiili kyu lii ɔkɛ-lɛɛ so. Ɔkɛ gɛkɛ mɔ gɛ laa bara gɛmɔ-lɛɛ. Imɔso iŋ kaaborɛ fɛꞌ baa kyu ɔkɛ-lɛɛ gikpon kyu too ndɛ-lɛɛ gikpon so. ");
INSERT INTO acd_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Fɛŋ sa fɛꞌ kerɛ ɔko ilaa wɔrasɛ de fɛꞌ tɔgɛ yɛɛ ɔŋ boran de Wurubuaarɛ kee ɔ mɛŋꞌ kerɛ fɛye-ilaa wɔrasɛ tɔgɛ yɛɛ fɛŋ boran. ");
INSERT INTO acd_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Gɛnɔɔbono ɔkara fɛ kya kyu tɔgɛ yɛɛ fɛye-nanboana mɛŋ boran mɔ, gɛnen kee ne Wurubuaarɛ laa kyu tɔgɛ yɛɛ fɛŋ boran ne. Ɔkpa ɔbono so fɛ laa kyu bun fɛye-nanboana gipuɛɛ mɔ, Wurubuaarɛ laa kyu gɛnen ɔkpa ɔbono so kee bun fɛye gipuɛɛ. ");
INSERT INTO acd_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Menɛ n wɔra so ne fo kya wu fo-nanbo ilaa nyɛnyɛn pii ibono ɔ kya wɔra mɔ tɔgɛ ne foŋ kya wu fo-lɛɛ ibelɛ idɛ? I dɛ daa fɛɛ fo wu gikpara gi bo ɔko ginsi dɔ, ne foŋ kya wu yɛɛ gɛgyakpaabi gɛ taa fo-lɛɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Nnɛ so ne fo laa tɔgɛ sa fo-nanbo yɛɛ, ‘O, me-nanbo, kerɛ, gikpara gi bo fo-ginsi dɔ. Yɛgɛ nꞌ lɛɛ gimɔ sa fo.’ --Yɛgɛ gɛgyakpaabi gɛ taa fo-lɛɛ dɔ? ");
INSERT INTO acd_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","O, gikerɛansi anyamesɛ! Fɛꞌ lɛɛ ngyakpaabi nbono gi taa fɛye-ansibi dɔ mɔ de fɛꞌ nyɛ wu dɔɔdan kpaa lɛɛ akpara abono a bo fɛye-nanboana lɛɛ ansi abi dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Fɛŋ sa fɛꞌ kyu Wurubuaarɛ ɔkalan mɔ kpaa tɔgɛ sa asa abono Wurubuaarɛ gɛlaarɛ ilaa giwɔra iŋ fɛ mɔmɔ-giso mɔ. Gɛnen asa abono mɛ dɛ daa fɛɛ igyoono kpensɛ. Fɛ wɔra gɛnen mɔ, mɛ laa kyu ginyadon kisee dun fɛye. I dɛ daa kee fɛɛ fɛ kyu awuratɔ too sa akuuri. Mɛ laa kyise-kyise amɔ daa nugidi giyan. ");
INSERT INTO acd_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Fɛꞌ dalaa kolɛ Wurubuaarɛ; ɔ laa sa fɛye. Fɛ laarɛ mɔ, fɛ laa nyɛ. Fɛ ŋmɛɛ Wurubuaarɛ gisin mɔ, ɔ laa tigi fɛye. ");
INSERT INTO acd_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","I kya nyiile yɛɛ ɔkamaasɛ ɔbono ɔ kpɛ ɔ kya kolɛ Wurubuaarɛ mɔ, ɔ laa sa mɔ. Ne ɔbono ɔ kpɛ ɔ kya laarɛ mɔ, ɔ laa nyɛ, ne ɔbono mɔ, ɔ kpɛ ɔ kya ŋmɛɛ Wurubuaarɛ gisin mɔ, ɔ laa tigi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Fɛye dɔ ɔsɛ ɔmɔ ne n bo no yɛɛ mɔ-bi laa kolɛ mɔ bodobodo de oꞌ kyu daa gibui kyu sa mɔ? ");
INSERT INTO acd_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Abɛɛ mɔ-bi laa kolɛ mɔ ɔken de oꞌ kyu daa giwɔɔ sa mɔ? ");
INSERT INTO acd_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Fɛye abono fɛ gyɛ ilaa nyɛnyɛn awura mɔ gbaa ne n kya bii kyu ilaa dɛnsɛ kyu sa fɛye-biana faa. Menɛtɔ so ne aye-sɛ ɔbono ɔ bo soso mɔ maŋ kyu ilaa dɛnsɛ kyu sa asa abono mɛ kya kolɛ mɔ mɔ? ");
INSERT INTO acd_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Gɛnɔɔbono fɛ kya laarɛ fɛɛ asa mɛꞌ wɔra sa fɛye mɔ, fɛꞌ wɔra imɔ ɔnan kee sa asa. Mosisi nbara mɔ de Wurubuaarɛ ikalan atɔgɛbo mɔ ilaa nyiilesɛ mɔ gɛsɛ pɛwu ne. ");
INSERT INTO acd_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Fɛꞌ loo de gɛbunono pi‑i gɛbono gɛ dɛ kpe Wurubuaarɛ asɛ gɛkyena mɔ dɔ mɔ. Wurubuaarɛ gisobiidɛ gɛten mɔ gɛbunono lɛɛ mɔ berɛ gɛ ŋmangɛ, ne ɔkpa ɔbono ɔ dɛ kpe gɛnen gɛbunono mɔ asɛ mɔ gyɛ daa otinpon. Asa sakyɔ mɛ naa mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Gɛbunono gɛbono gɛ dɛ kpe Wurubuaarɛ asɛ gɛkyena mɔ dɔ mɔ gɛŋ ŋmangɛ, ne ɔkpa ɔbono ɔ dɛ kpe gɛnen gɛbunono mɔ asɛ mɔ gyɛ daa gɛkpasuɛɛ. Asa kalɛsɛ ne n kya wu gɛnen ɔkpa ɔbono bii. ");
INSERT INTO acd_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Fɛꞌ dɛsɛ fɛye-nyoro so de asa abono mɛ kya kɛɛ abon yɛɛ Wurubuaarɛ ikalan ne mɛ kya tɔgɛ mɔ. Ansi so mɔ, mɛ dɛ fɛɛ isandɛ, yɛgɛ mɔmɔ-itɔ dɔ mɔ, mɛ don agbowugbowu. ");
INSERT INTO acd_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mɔmɔ-ilaa wɔrasɛ ne fɛ laa kyu bii mɔmɔ-gisen dɔ ilaa. I dɛ daa fɛɛ gɛnɔɔbono fɛ kya kerɛ oyii abi kyu bii mɔ-gidebi mɔ. Mɛ kya tɛɛ mango lii giwii oyii so? Mɛ kya tɛɛ payaa abi lii fɔlɔgɛ oyii so? ");
INSERT INTO acd_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Nyamesɛ ɔbono mɔ-gisen dɔ i boran mɔ kya wɔra daa ilaa dɛnsɛ, ne ɔbono mɔ-gisen dɔ iŋ boran mɔ kya wɔra daa ilaa nyɛnyɛn. ");
INSERT INTO acd_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","I dɛ daa fɛɛ iyii. Oyii ɔbono ɔ bo alanfiya mɔ maŋ taalɛ sɔrɔ abi nyɛnyɛn, ne oyii ɔbono ɔ kya lɔ mɔ maŋ taalɛ sɔrɔ abi dɛnsɛ. ");
INSERT INTO acd_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Oyii kamaasɛ ɔbono ɔ maŋ sɔrɔ abi dɛnsɛ mɔ mɛ laa ŋɛ mɔ kyu wɔra ɔgya dɔ. ");
INSERT INTO acd_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Imɔso asa ilaa wɔrasɛ ne fɛ laa kyu bii yɛɛ mɛ gyɛ Wurubuaarɛ ikalan atɔgɛbo gɛsintin? ");
INSERT INTO acd_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“I mɛŋ gyɛ nyamesɛ kamaasɛ ɔbono ɔ kpɛ nyɛ ɔ kya terɛ me yɛɛ, ‘Me-wura, me-wura’ mɔ ne nan nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi mɔ dɔ. Gɛnen mɔ, asa abono mɛ kya wɔra me-sɛ ɔbono ɔ bo soso mɔ gɛlaarɛ mɔ wolɛ. ");
INSERT INTO acd_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Gɛkaabono Wurubuaarɛ laa gyi anyamesɛ pɛwu nbɛlɛ mɔ, asa sakyɔ mɛ laa terɛ me yɛɛ, ‘Aye-wura, aye-wura’ de mɛꞌ tɔgɛ sa me yɛɛ, ‘A tɔgɛ Wurubuaarɛ ikalan sa asa, a gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so, ne a wɔra ilaa gbaaꞌgbaa ibono i lɛɛ Wurubuaarɛ ɔlon nyiile asa mɔ fo-ginyen dɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Nfono ne nan tɔgɛ tigi mɔmɔ yɛɛ, ‘Meŋ nyi fɛye. Fɛ gyɛ daa ilaa nyɛnyɛn awɔrabo. Fɛꞌ naa me-ansi so!’ ");
INSERT INTO acd_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Ɔkamaasɛ ɔbono ɔ kya nu me-ilaa tɔgɛsɛ idɛ ne ɔ kya wɔra imɔ so ilaa mɔ, ɔ dɛ fɛɛ ɔsɛɛbo ɔbono o yii obu. Ɔ laa yii gɛsɛ ɔpɔɔrɛ mɔ, o kuru kpaa tu gifolɛ, pɛi ne ɔ too ɔpɔɔrɛ gyanꞌ gifolɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Gɛkɛ gɛdɛ mɔ, nyangbon gi baa da, afuu belɛ a da ne ibon i bɔla baa da de gɛnen obu mɔ. Imɔ gɛnen gbaa mɔ, ɔ mɛŋ boori, i lii fɛɛ ɔ pɔrɔ mɔ dandan gyan gifolɛ so. ");
INSERT INTO acd_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Nyamesɛ ɔbono, mɔ, ɔ kya nu me-ilaa tɔgɛsɛ idɛ ne ɔ mɛŋ kya wɔra imɔ so ilaa mɔ, kaasɛ mɔ dɛ fɛɛ ɔnyen ɔbono oŋ nyi ɔlaako ne o yii obu gyanꞌ daa giŋɛsii so mɔ. Ɔ mɛŋ kuru gɛsɛ ɔpɔɔrɛ mɔ gɛten. ");
INSERT INTO acd_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Gɛkɛ gɛdɛ mɔ, nyangbon de afuu belɛ a baa da, ne ibon i bɔla baa da de obu mɔ. Obu mɔ yii daa giŋɛsii so so mɔ, ɔ tɔrɔ daa wurum!” ");
INSERT INTO acd_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Yesu gi tɔgɛ gɛnen ilaa idɛana ta mɔ, mɔ-ilaa nyiilesɛ mɔ i wɔra sakpii ɔbono o nu imɔ mɔ giyan. ");
INSERT INTO acd_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","I lii fɛɛ mɛ nu mɔ-anyiilebi mɔ, mɛ wolaa wu yɛɛ Wurubuaarɛ ne n sa mɔ gɛnen ilaa nyiilesɛ mɔ. I mɛŋ gyɛ gɛnen ne mɔmɔ-nbara aŋmarasɛbo mɔ mɛ kya nyiile ilaa ne. ");
INSERT INTO acd_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Yesu gi nyiile asa ilaa mɔ ta mɔ, mɔ‑rɛ sakpii belɛ ɔbono o buu mɔ mɔ mɛ kpelegɛ lii gibii mɔ so mɛ kya ba. ");
INSERT INTO acd_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Nfono mɔ okononbu ɔko gi lii tu mɔ. Okononbu mɔ gi kpelegɛ ŋmii mɔ-ayaa dɔ, ne ɔ tɔgɛ mɔ yɛɛ, “Me-wura, nengyene i gyɛ fo-gɛlaarɛ dɔ mɔ, fo laa taalɛ kyɛ me.” ");
INSERT INTO acd_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ɔ kolɛ Yesu gɛnen mɔ, Yesu gi tengɛ mɔ-gibaa kpaa yii mɔ, ne ɔ lɛɛ gɛnɔ sa mɔ yɛɛ, “I gyɛ me-gɛlaarɛ; fo-gilɔ mɔ giꞌ ta.” Ayaa abono so mɔ, okononbu mɔ alɔtɔ mɔ a ta, ne ");
INSERT INTO acd_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yesu gi tɔgɛ mɔ yɛɛ, “Gɛŋ sa foꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ me ne n kyɛ fo. Naa kpaa wɔra nbara ilaa ibono Mosisi gi yela sa okononbu kamaasɛ ɔbono mɔ-gilɔ gi ta mɔ. Imɔ ne n gyɛ yɛɛ fo laa kperɛ fo-nyoro kpaa nyiile Wurubuaarɛ asunbi ɔlɛɛbo de ɔꞌ kerɛ fo-nyoro pɛwu gyanꞌ. Ɔ laa wu yɛɛ fo-gilɔ mɔ gi ta, de foꞌ kyu fo-afaala kyu sa mɔ de oꞌ kyu lɛɛ asunbi sa Wurubuaarɛ sa fo. Imɔ ne nan yɛgɛ asa mɛꞌ bii yɛɛ fo-alɔtɔ mɔ a ta gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Yesu gi kyon kpe Kapɛɛniyon. Ɔ loo nno mɔ, Rom awura asogya ɔbelɛnsɛ ɔko gi lii kpaa gyangara mɔ ne ɔ kolɛ mɔ ");
INSERT INTO acd_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","yɛɛ, “Me-wura, me-dega dɛ me-gɛten dɔ, ɔ kya lɔ ibono i bo lon. Nfono ɔ kpɛ ɔ dɛ mɔ ne ɔ dɛ. Ɔ tansi ɔ kya yiyɛɛ. Imɔso gyanꞌ me-giwoo.” ");
INSERT INTO acd_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yesu gi kyule sa mɔ yɛɛ, “Nan kpaa kyɛ mɔ sa fo.” ");
INSERT INTO acd_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Yesu gi tɔgɛ mɔ gɛnen mɔ, asogya ɔbelɛnsɛ mɔ gi lɛɛ gɛnɔ sa Yesu yɛɛ, “Me-wura, me ɔdɛ meŋ kaaborɛ ibono foꞌ kpe me-gɛten dɔ. Fo kpɛ nyɛ lɛɛ gɛnɔ mɔ, me-dega mɔ gilɔ mɔ gi laa ta. ");
INSERT INTO acd_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Me gbaa-gbaa kee n gyɛ ɔbelɛnsɛ ɔbono n bo abelɛnsɛ ako gɛsɛ. Ne nꞌ bo abono, mɔ, mɛ bo me gɛsɛ mɔ. Nengyene nɛ lɛɛ gɛnɔ yɛɛ, ‘fo ɔdɛ, kpe faa’ mɔ, kaasɛ mɔ laa kpe, abɛɛ nꞌ tɔgɛ yɛɛ, ‘fo ɔdɛ, ba gɛrɛ’ mɔ, kaasɛ mɔ laa ba. Nengyene nɛ tɔgɛ me-dega yɛɛ ‘wɔra idɛ!’ mɔ, imɔ ne ɔ laa wɔra.” ");
INSERT INTO acd_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Yesu gi nu ɔbelɛnsɛ mɔ ilaa tɔgɛsɛ mɔ mɔ, i dɛ mɔ-gɛnɔ gikyɔ. Nfono ne Yesu gi kisee tɔgɛ sa sakpii ɔbono o buu mɔ mɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, ba‑a aye Isirale awura mɔ dɔ gbaa, meŋ wu nyamesɛ ɔbono ɔ bo gisɔɔgyi belɛ gidɛ ɔnan sa me fɛɛ Rom ɔbelɛnsɛ baarɛ. ");
INSERT INTO acd_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","N kya tɔgɛ mi‑i sa fɛye yɛɛ gɛkaako mɔ asa sakyɔ mɛ laa lii nsinkpan kpɛi-kpɛi so baa nyɛ ikyenaten Wurubuaarɛ gɛwuragyi mɔ dɔ taa aye-Isirale awura ako yɛgɛ. Gɛnen asa abono mɔmɔ‑rɛ aye-naanaana Aberaham de Ayisiki de Gyeekɔpo mɛ laa wɔra abaa gyi. ");
INSERT INTO acd_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","I san aye Isirale awura abono nkana Wurubuaarɛ gɛwuragyi mɔ gɛ gyɛ aye-lɛɛ mɔ, aye dɔ abono mɛŋ sɔɔ Wurubuaarɛ gyi mɔ berɛ, Wurubuaarɛ laa lɛɛ mɔmɔ lii mɔ asɛ kyu kpaa too wɔra nfono i tansi i bo gibiri mɔ. Gɛnen gibiri gibono dɔ mɔ osulon de anɛbi giwɛ ne n bo nno.” ");
INSERT INTO acd_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Nfono ne Yesu gi tɔgɛ sa asogya ɔbelɛnsɛ mɔ yɛɛ, “Naa fo kya kpe. Iꞌ wɔra sa fo fɛɛ gɛnɔɔbono fo sɔɔ me gyi faa.” Gɛnen owi ɔbono dɔ gbaa-gbaa mɔ, mɔ-dega mɔ gi nyɛ alanfiya mɔ-gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yesu gi naa kpe Piita gɛwi. Ɔ loo gɛten mɔ dɔ mɔ, o wu Piita mɔ-saa kyiisɛ dɛ ɔ kya lɔ ɔkyagyii, ");
INSERT INTO acd_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ne Yesu gi yii mɔ. O yii mɔ mɔ, ɔkyagyii mɔ gi taa mɔ yɛgɛ, ne ɔ taalɛ kii koso keda mɔ-gisafo. ");
INSERT INTO acd_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Imɔ gɛdɔɔdɛ mɔ asa mɛ kyu alɔbo de asa sakyɔ abono ilaa nyɛnyɛn oduduu kpɛi-kpɛi i tɛ mɔmɔ so mɔ kyu ba Yesu asɛ. Yesu gi kpɛ lɛɛ gɛnɔ daa ne ilaa nyɛnyɛn oduduu mɔ i koso mɔmɔ so. Ɔ kyɛ asa abono mɛ kya lɔ mɔ pɛwu kee. ");
INSERT INTO acd_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Yesu gi wɔra gɛnen ilaa idɛ mɔ, i kyena de ilaa ibono Wurubuaarɛ ikalan ɔtɔgɛbo Isaya gi wolaa tɔgɛ lii mɔ so mɔ. Ɔ tɔgɛ yɛɛ, “Ibono a gyɛ nbaari so mɔ, o kyu imɔ yɛɛ mɔ-nyoro ne i gyɛ. Ne ɔ kyɛ aye-alɔtɔ sa aye.” ");
INSERT INTO acd_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ bo Galeli ɔbon belɛ mɔ asɛ, ne Yesu gi wu yɛɛ sakpii mɔ gi kyaabɔɔ mɔ mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Aꞌ fara kpe gibenbɛ.” ");
INSERT INTO acd_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Mɛ kya laarɛ mɛꞌ kyon mɔ, Gyuda awura nbara ɔŋmarasɛbo ɔko gi ba Yesu asɛ, ne ɔ kolɛ Yesu yɛɛ, “Ɔbelɛnsɛ, nan buu fo kpe gɛten kamaasɛ gɛbono fo kya kpe mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Agbowugbowu gbaa mɛ bo ibɔ dɛsɛ, ne nbuii mɛ bo asisaa. Me, anyamesɛ pɛwu mɔmɔ-daa mɔ berɛ, meŋ bo me-gimu okunten.” ");
INSERT INTO acd_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Yesu akasɛbo mɔ dɔ ɔko berɛ gi kolɛ mɔ yɛɛ, “Me-wura, yɛgɛ me nꞌ kpaa pule me-sɛ pɛi de nꞌ lɔɔ baa buu fo.” ");
INSERT INTO acd_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yesu gi tɔgɛ sa mɔ yɛɛ, “Fo berɛ, baa buu me daa de asa abono Wurubuaarɛ asɛ gɛkyena mɔ ilaa iŋ fɛ ɔmɔ-giso mɔ mɛꞌ pule abara.” ");
INSERT INTO acd_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Yesu gi dii loo gikolii dɔ mɔ‑rɛ mɔ-akasɛbo mɔ, ne mɛ kyon. ");
INSERT INTO acd_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mɛ kpaa fo nkyu mɔ nsana gɛtɛɛko mɔ de‑e, afuu belɛ ako a tigi, a kya da ginyadon so. I yɛgɛ nkyu gi kya loo gikolii mɔ dɔ. Gɛnen aberɛ abono mɔ Yesu berɛ gi dɛ ginsi gidɛ. ");
INSERT INTO acd_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Nfono mɔ, mɔ-akasɛbo mɔ mɛ da mɔ kyingi, ne mɛ tɔgɛ mɔ yɛɛ, “Aye-wura, mɔlɛgɛ aye! A kya laarɛ de aꞌ sii.” ");
INSERT INTO acd_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Yesu gi lɛɛ gɛnɔ yɛɛ, “O, fɛye asa adɛ! Menɛ n wɔra ne i bo fɛye gifuu gɛnen? Gisɔɔgyi gibono fɛ bo sa me mɔ pɛwu ne?” Nfono ne ɔ koso ne ɔ tɔgɛ afuu mɔ yɛɛ aꞌ taa gida yɛgɛ de nkyu mɔ, mɔ, giꞌ wɔra bɔyin. Nfono mɔ, ilaa kamaasɛ i sii faa kurun. ");
INSERT INTO acd_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Mɔ-akasɛbo mɔ mɛ wu gɛnen mɔ, i wɔra mɔmɔ giyan. Mɛ san ma‑a taasɛ abara yɛɛ, “Menɛ nyamesɛ ɔnan ne? Kerɛ, afuu de nkyu gbaa gi kya nu mɔ-gɛdɛ.” ");
INSERT INTO acd_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ fara nkyu kpe gibenbɛ Gadara awura gɛsinkpan so. Ɔ fo nno mɔ, anyen anyɔ ako mɛ lii ibuni opuleten baa gyangara mɔ. Ilaa nyɛnyɛn oduduu kpɛi-kpɛi i tɛ mɔmɔ so, i kya yɛgɛ mɛ kya tansi wɔra asa abono mɛ kya kyu de nno mɔ anyanyan. Imɔso asa mɛ selɛ de mɛꞌ kyu de ɔkpa ɔbono. ");
INSERT INTO acd_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Anyen anyɔ adɛ mɛ wu Yesu mɔ, ilaa nyɛnyɛn oduduu kpɛi-kpɛi ibono i tɛ mɔmɔ so mɔ i kpen ken-ken taasɛ Yesu yɛɛ, “Wurubuaarɛ mɔ-bi, aye‑rɛ fo menɛ asɛ? Fo ba de foꞌ baa wɔra aye-awɔrɔfɔɔ pɛi de Wurubuaarɛ gisobiidɛ owi mɔ ɔꞌ lɔɔ fo abɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Aberɛ abono mɔ, akuuri gikpen belɛ giko gi yelɛ gi kya gyi sindi nfono. ");
INSERT INTO acd_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Imɔso ilaa nyɛnyɛn oduduu kpɛi-kpɛi ibono i tɛ anyen mɔ so mɔ i kolɛ Yesu yɛɛ, “Nengyene fo laa gya aye koso mɔ, yɛgɛ aꞌ kpaa kyena akuuri gikpen gidɛ so.” ");
INSERT INTO acd_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛꞌ koso naa.” Imɔso ilaa nyɛnyɛn oduduu kpɛi-kpɛi mɔ i koso anyen mɔ so kpaa kyena akuuri mɔ so. Ayaa abono so mɔ, akuuri gikpen mɔ pɛwu gi selɛ kpelegɛ de ogee kpaa loo ɔbon dɔ, ne nkyu mɔ gi gyi mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Anyen abono mɛ kya kerɛ akuuri mɔ so mɔ, mɛ selɛ kpe nten dɔ kpaa tɔgɛ ilaa ibono i ba mɔmɔ-akuuri mɔ so de ilaa ibono Yesu gi wɔra sa anyen anyɔ mɔ pɛwu sa asa. ");
INSERT INTO acd_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ɔsowolɛ mɔ so asa mɛ nu gɛnen mɔ, mɔmɔ pɛwu mɛ lii baa kerɛ Yesu. Mɛ wu mɔ mɔ, mɛ dɛ mɔ giserɛ yɛɛ ɔꞌ lii mɔmɔ-gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Yesu gi dii loo gikolii mɔ dɔ kii fara ɔbon mɔ kpe ɔsowolɛ ɔbono so ɔ tɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Yesu bo nno mɔ, asa ako mɛ sola ɔtɛgɛsɛ ɔko de gifengen kyu bara mɔ yɛɛ ɔꞌ kyɛ mɔ. Yesu gi wu yɛɛ asa adɛ mɛ sɔɔ mɔ gyi yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ mɔ, ɔ tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, “Me-bi, yɛgɛ fo-gisen giꞌ tɔrɔ fo. Nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyu kyɛɛ fo.” ");
INSERT INTO acd_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nfono mɔ Gyuda awura nbara aŋmarasɛbo ako mɛ tɔgɛ sa mɔmɔ-nyoro yɛɛ, “Ɔnyen baarɛ kya tɔngɛ fɛɛ mɔ ne n gyɛ Wurubuaarɛ!” ");
INSERT INTO acd_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Yesu gi bii mɔmɔ-nwɔnsa dɔ. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra so ne fɛ kya sa gɛnen nwɔnsa nyɛnyɛn ndɛ? ");
INSERT INTO acd_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Nan tɔgɛ ilaa inyɔ sa ɔtɛgɛsɛ baarɛ. Giko ne n gyɛ yɛɛ, ‘Nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyɛɛ fo.’ Ginyɔsɛ mɔ ne n gyɛ yɛɛ, ‘Koso de foꞌ naa.’ Imɔ idɛ dɔ mɔ, imɔmɔ ne fɛ laa wu de fɛye-ansi? ");
INSERT INTO acd_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","N kya laarɛ de fɛꞌ nyɛ bii yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔkpa gɛsinkpan so de nꞌ kyu asa ilaa nyɛnyɛn ibono mɛ wɔra Wurubuaarɛ mɔ kyɛɛ mɔmɔ.” Gɛnen so mɔ o kisee tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, “Koso puru fo-gifengen de foꞌ naa kpe gɛwi.” ");
INSERT INTO acd_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Gɛsintin mɔ, ɔtɛgɛsɛ mɔ gi koso, ne ɔ naa kyon kpe mɔ-gɛwi. ");
INSERT INTO acd_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Sakpii mɔ gi wu gɛnen mɔ, i dɛ ɔmɔ-gɛnɔ ne mɛ yen Wurubuaarɛ yɛɛ o kyu gɛnen ɔlon baarɛ ɔnan kyu sa nyamesɛ. ");
INSERT INTO acd_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yesu gi lii nfono ɔ kya kpe mɔ, o wu ɔnyen ɔko tɛ mɔ-gɛsun ɔwɔraten. Mɛ kya terɛ mɔ yɛɛ Matiyu. Gɛnen Matiyu mɔ gyɛ daa lɛnpoo sɔɔbo. Yesu gi wu mɔ gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, “Baa buu me de foꞌ wɔra me-ɔkasɛbo.” Gɛsintin mɔ, Matiyu gi koso buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Imɔ gɛmara mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpe Matiyu gɛwi. Mɛ tɛ mɛ kya gyi mɔ, lɛnpoo asɔɔbo abono Gyuda awura asɛ mɔ mɛ gyɛ asa nyɛnyɛn mɔ de ilaa nyɛnyɛn awɔrabo sɛnsɛ sakyɔ mɛ baa tu mɔmɔ, ne mɔmɔ‑rɛ mɔmɔ mɛ wɔra abaa gyi dabɔlɛ. ");
INSERT INTO acd_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Farasii awura mɔ mɛ wu gɛnen mɔ, mɛ baa taasɛ Yesu akasɛbo mɔ yɛɛ, “Menɛ n wɔra so ne fɛye-ɔbelɛnsɛ kya wɔra abaa gyi de lɛnpoo asɔɔbo de ilaa nyɛnyɛn awɔrabo sɛnsɛ daa?” ");
INSERT INTO acd_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Yesu gi nu gɛnen mɔ, ɔ lɛɛ gɛnɔ sa Farasii awura mɔ yɛɛ, “Fɛɛ gɛnɔɔbono ɔlɔbo tiri ɔkyɛbo mɔ, gɛnen kee ne ilaa nyɛnyɛn awɔrabo mɛ tiri me ne. I mɛŋ gyɛ abono mɛ bo alanfiya mɔ ne n tiri ɔkyɛbo. ");
INSERT INTO acd_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Mɛ ŋmarasɛ ilaa ibono nan baa tɔgɛ faa yela Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ yɛɛ, ‘Me, Wurubuaarɛ, n kya laarɛ fɛꞌ su asa gitolon daa; i mɛŋ gyɛ asunbi abono fɛ laa lɛɛ sa me mɔ ne nꞌ kya laarɛ.’ Fɛꞌ nu gɛnen ilaa idɛ, fɛꞌ kasɛ imɔ gɛsɛ, de fɛꞌ bii yɛɛ ilaa nyɛnyɛn awɔrabo ne nɛ ba de nꞌ baa tɔgɛ yɛɛ mɛꞌ wɔra me-akasɛbo. I mɛŋ gyɛ abono mɛ nyi yɛɛ mɛ ti mɛ gyɛ gɛsintin awura mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Nfono mɔ Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ akasɛbo ako mɛ ba Yesu asɛ baa taasɛ mɔ yɛɛ, “Aye‑rɛ Farasii awura a kya ŋminde nnɔ. Ne menɛ n wɔra ne fo-lɛɛ akasɛbo mɔ berɛ mɛŋ kya ŋminde nnɔ daa?” ");
INSERT INTO acd_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yesu gi lɛɛ gɛnɔ da mɔmɔ gikpalɛ yɛɛ, “I mɛŋ gyɛ aberɛ adɛ ne mɛ laa wɔra gɛnen. I dɛ daa fɛɛ gɛnɔɔbono aye Gyuda awura a kya kpii ɔkyii mɔ. Aꞌ kyu yɛɛ me ne n gyɛ ɔkyiifɔ mɔ-kuli mɔ. Me-kyɛmenɛana mɛ ba me asɛ a san a kya gyi ɔkon mɔ, i laa sa de mɛꞌ bɔɔda? Kuaa. I laa baa fo owi ɔko mɔ, i laa baa puru ɔkyiifɔ mɔ kuli mɔ lii mɔ-kyɛmenɛana mɔ asɛ. Lii gɛnen owi ɔbono kyu kyon mɔ, i laa sa de mɛꞌ ŋminde nnɔ kon.” ");
INSERT INTO acd_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Yesu gi kii da mɔmɔ gikpalɛ kyu nyiile yɛɛ mɔ berɛ ɔ bara akyenabi pobɔrɔ. Ɔ da gikpalɛ mɔ yɛɛ, “Nengyene gikuru dedaa gi tɛɛ mɔ, mɛŋ kya kyu gikuru pobɔrɔ gipanan kyu baa tii ɔtɛɛten mɔ. Fɛ wɔra gɛnen mɔ, gikuru pobɔrɔ mɔ gɛten i laa kyigi lɛɛ de iꞌ wɔra ɔbɔ belɛ nyɛ ibono i wolaa tɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Aꞌ kii laa ansi kerɛ gɛnɔɔbono mɛ kya kyu nta kyu wɔra nbuɛ iwolɛ dɔ mɔ de aꞌ kerɛ. Ɔko maŋ kyule kyu nta pobɔrɔ kyu wɔra nta ɔwɔraten iwolɛ dedaa dɔ. Ɔbono ɔ wɔra gɛnen mɔ, gyɛrɛbi ne ɔ kya laarɛ. Nta mɔ gi laa paadɛ nta ɔwɔraten iwolɛ mɔ de nta mɔ giꞌ duuli fuɛ de iwolɛ mɔ, mɔ, kee iꞌ nyida. Mɛ kya kyu nta pobɔrɔ kyu wɔra daa nta ɔwɔraten iwolɛ pobɔrɔ dɔ. Gɛnen ne mɛ laa kerɛ nta mɔ nmɔ‑rɛ nmɔ-iwɔraten mɔ pɛwu so ne i maŋ gyi gyɛrɛbi.” ");
INSERT INTO acd_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Yesu san ɔ kya tɔngɛ de mɔmɔ mɔ, Gyuda awura ɔbelɛnsɛ ɔko gi baa ŋmii mɔ-ayaa dɔ kolɛ mɔ yɛɛ, “Me-bi kyiisɛ gi kpɛ wuꞌ ayaa adɛ so ne. Imɔ gɛnen gbaa mɔ, fo kpe ne fo kpaa kyu fo-abaa gyanꞌ mɔ so mɔ, ɔ laa kyingi.” ");
INSERT INTO acd_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Yesu gi nu ɔbelɛnsɛ mɔ asɛ, ne mɔ‑rɛ mɔ-akasɛbo mɔ mɛ koso buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Mɛ kya kpe mɔ, ɔkyii ɔko gi naa de Yesu gɛmara-gɛmara, ne ɔ kpaa yii Yesu gɛgbɛ ginɛbi. I kya da de gɛnen ɔkyii ɔbono mɔ, imɔ-nsi gudu nnyɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Pɛi ne ɔ laa yii Yesu gɛgbɛ mɔ gɛnen mɔ, ɔ tɔgɛ sa mɔ-nyoro yɛɛ, “Me-gibaa gi taa kpɛ nyɛ yii mɔ-gɛgbɛ mɔ, n nyi ibono i laa kyɛ me.” ");
INSERT INTO acd_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","O yii gɛgbɛ mɔ gɛnen mɔ, Yesu gi kisee kerɛ. O wu mɔ mɔ, ɔ tɔgɛ sa mɔ yɛɛ, “Me-bi, yɛgɛ fo-gisen gi tɔrɔ fo! Gisɔɔgyi gibono fo bo sa me mɔ ne nan kyɛ fo.” Ayaa abono so mɔ, ɔkyii mɔ gilɔ mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Yesu gi kyon kpaa loo Gyuda awura ɔbelɛnsɛ mɔ gɛten dɔ nfono gɛbii kyiisɛ mɔ gɛ wuꞌ mɔ. O wu gɛnɔɔbono ilon abiibo de asa abono mɛ ba gɛli mɔ mɛ kya saawo mɛ kya wɔra ɔlanba mɔ, ");
INSERT INTO acd_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ɔ tɔgɛ sa mɔmɔ yɛɛ, “Ɔkamaasɛ ɔꞌ lii gɛrɛ! Gɛbii mɔ gɛŋ wuꞌ. Gɛ dɛ daa.” Ɔ tɔgɛ yɛɛ gɛbii mɔ gɛŋ wuꞌ mɔ, mɛ kyu mɔ ŋmasɛ daa. ");
INSERT INTO acd_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Yesu gi gya mɔmɔ lii mɔ, ɔ loo obu ɔbono dɔ obuni mɔ dɛ mɔ. Ɔ kpaa keda mɔ gibaa dɔ, ne o kyingi koso yelɛ. ");
INSERT INTO acd_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Gɛnɔɔbono Yesu gi kyingi gɛbii mɔ mɔ i nu gyanꞌ de gɛnen gɛsinkpan gɛbono so pɛwu. ");
INSERT INTO acd_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yesu gi lii gɛten mɔ dɔ ɔ kya kyon mɔ, agyaatanbo anyɔ ako mɛ buu mɔ gɛmara-gɛmara mɛ kya kpen mɔ yɛɛ, “Wura Deefidi ɔnaanabi, su aye so!” ");
INSERT INTO acd_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Yesu gi loo gɛten gɛbono dɔ ɔ bo mɔ, agyaatanbo mɔ mɛ naa kpaa tu mɔ nno. Ɔ taasɛ ɔmɔ yɛɛ, “Fɛ sɔɔ gyi yɛɛ nan taalɛ bugi fɛye-ansi adɛ sa fɛye?” Mɛ kyule yɛɛ, “Ɛɛn, aye-wura.” ");
INSERT INTO acd_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Nfono ne Yesu gi kyu mɔ-abaa gyan mɔmɔ-ansi mɔ so, ne ɔ tɔgɛ yɛɛ, “Iꞌ wɔra fɛɛ gɛnɔɔbono fɛ sɔɔ me gyi mɔ sa fɛye.” ");
INSERT INTO acd_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Nfono mɔ, mɔmɔ-ansi mɔ a bugi, ne Yesu gi tɔgɛ sa mɔmɔ gɛnsipɛɛrɛ so yɛɛ, “Fɛ mɛŋ sa fɛꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ me ne n kyɛ fɛye.” ");
INSERT INTO acd_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Imɔ gɛnen gbaa mɔ, mɛ lii mɔ asɛ mɔ, mɛ naa kpaa tɔgɛ ibono ɔ wɔra sa mɔmɔ mɔ sa asa gɛnen gɛsinkpan gɛbono gɛten kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Abono nkana mɛ gyɛ agyaatanbo mɔ mɛ kya lii Yesu asɛ mɔ, asa ako mɛ kyu ɔnyen ɔko bara Yesu yɛɛ ɔꞌ kyɛ mɔ. Ɔ mɛŋ kya tɔngɛ, i kya nyiile yɛɛ ilaa nyɛnyɛn oduduu tɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Yesu gi kosorɛ ilaa nyɛnyɛn oduduu mɔ lii ɔnyen mɔ so, ne ɔ taalɛ ɔ kya tɔngɛ. Sakpii ɔbono ɔ yelɛ nfono mɔ gi wu gɛnen mɔ, i wɔra mɔmɔ giyan, mɛ san tɔgɛ yɛɛ, “A mɛŋ ti wu gɛnen ilaa idɛ ɔnan Isirale gɛsinkpan gɛdɛ so kerɛ.” ");
INSERT INTO acd_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farasii gikpen mɔ dɔ awura berɛ, mɛ kya tɔgɛ daa yɛɛ, “Ilaa nyɛnyɛn oduduu pɛwu gɛmu mɔ ne n kya sa Yesu ɔlon. Imɔso ne ɔ kya taalɛ gya ilaa nyɛnyɛn oduduu koso asa so gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yesu gi naa de isowolɛ belɛ-belɛ de iburu-buru ibono i kyaabɔɔ gɛnen gɛsinkpan gɛbono so mɔ pɛwu. Ɔ naa Gyuda awura akyangbon dɔ ɔ kya nyiile asa Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa. Wurubuaarɛ ɔkalan konkonsɛ mɔ ne ɔ dɛ ɔ naa gɛnen, ne ɔ kya kyɛ asa alɔbi kpɛi-kpɛi kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Yesu gi wu sakpii belɛ ɔbono ɔ kya kyena ba mɔ asɛ mɔ, mɔmɔ-ilaa i wɔra mɔ ayen. I lii fɛɛ ilaa kpɛi-kpɛi i kya nyala mɔmɔ, ne mɛ mɛŋ nyi gɛnɔɔbono mɛ laa wɔra de iꞌ mɔlɛgɛ mɔmɔ mɔ. Mɛ wɔra fɛɛ isandɛ ibono mɛŋ bo ɔkparɛbo mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Gɛnen so mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Asa abono i kaaborɛ mɛꞌ nu Wurubuaarɛ ɔkalan konkonsɛ mɔ mɛ dɛ fɛɛ ɔmɔlɔgɔ ne n pɛɛrɛ ndɔɔ belɛ nko dɔ. Akɛbibo mɔ, mɔ, mɛŋ kyɔ sa ndɔɔ wura mɔ. ");
INSERT INTO acd_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Imɔso fɛꞌ dalaa kolɛ Wurubuaarɛ ɔbono ɔ gyɛ Ndɔɔ Wura mɔ yɛɛ mɔ gbaa-gbaa oꞌ kyu abono mɛ laa kɛbi ɔmɔlɔgɔ mɔ ba mɔ-ndɔɔ mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Yesu gi terɛ mɔ-akasɛbo gudu anyɔ mɔ ba mɔ asɛ, ne ɔ sa mɔmɔ ɔlon de mɛꞌ taalɛ gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so. Gɛnen ɔlon mɔ laa yɛgɛ mɛ laa taalɛ kyɛ asa alɔtɔ kpɛi-kpɛi kamaasɛ kee. ");
INSERT INTO acd_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Gɛnen asa gudu anyɔ abono ne n wɔra mɔ-isɔɔ. Mɔmɔ ne n gyɛ Simon ɔbono mɛ kya terɛ mɔ-ginyen giko kee yɛɛ Piita mɔ, de Simon mɔ-tedɛ Andiru, Gyeemesi de mɔ-tedɛ Gyɔn, Sɛbedi mɔ-biana; ");
INSERT INTO acd_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filipo de Batolomiyu, Tomaasɛ de Matiyu ɔbono nkana ɔ kya sɔɔ lɛnpoo mɔ, Gyeemesi, Alefayo mɔ-bi, de Taadiyusɛ, ");
INSERT INTO acd_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon ɔbono ɔŋ kya kyule mɔ-ɔsowolɛ so mɔ, de Gyudasɛ Isikaayɔtɛ ɔbono gɛmara-gɛmara ɔ fɛ Yesu sa mɔ-akyobo mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Yesu gi keda mɔ-isɔɔ gudu anyɔ adɛ sun. Ɔ laa sun mɔmɔ mɔ, ɔ ka sa mɔmɔ yɛɛ, “Fɛŋ sa fɛꞌ kpe de asa abono mɛ mɛŋ gyɛ Gyuda awura mɔ gibaafon, ne fɛŋ sa fɛꞌ loo Samariya awura isowolɛ iko so. ");
INSERT INTO acd_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Fɛꞌ kpe daa Isirale awura wolɛ asɛ. Mɛ dɛ fɛɛ isandɛ ibono i fuɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Fɛ naa mɔ, fɛꞌ tɔgɛ tɔgɛ sa asa yɛɛ, ‘Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a kya laarɛ aꞌ ba asa dɔ kon.’ ");
INSERT INTO acd_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Fɛꞌ kyɛ abono mɛ kya lɔ mɔ, de fɛꞌ kyingi asa abono fɛ wu mɛ wuꞌ mɔ. Fɛꞌ kyɛ ikononbu de fɛꞌ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi asa so. Nɛ kyu gɛnen ɔlon baarɛ kyɛɛ fɛye; fɛye kee fɛ kyɛ asa mɔ, fɛꞌ kyu kyɛɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Fɛ mɛŋꞌ kyu aterenbi ne n gyɛ aterenbi wɔra fɛye-igo ibɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Fɛ mɛŋꞌ puru ba‑a atɔ ɔwɔraten abɛɛ gɛgbɛ giwɔra nyɔsɛ. Fɛ mɛŋꞌ puru ayaawolɛ abɛɛ oyii tugɛsɛ keda. Gɛsun ɔwɔrabo gi kaaborɛ ɔꞌ nyɛ mɛꞌ kerɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Ɔsowolɛ kamaasɛ ɔbono so fɛ laa loo mɔ, fɛꞌ laarɛ ɔbono asa mɛ kya buu mɔ mɔ de fɛꞌ kpaa loo mɔ asɛ. Fɛꞌ kyena mɔ asɛ kaaborɛ fɛ laa lii gɛnen ɔsowolɛ ɔbono so. ");
INSERT INTO acd_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Gɛten gɛbono dɔ fɛ laa sogɛ gɛnen mɔ, fɛ loo mɔ, fɛꞌ faala gɛmɔ dɔ asa. ");
INSERT INTO acd_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nengyene gisen yuuli gi kaaborɛ mɔmɔ mɔ, gisen yuuli gi laa wɔra mɔmɔ-lɛɛ. Ne gisen yuuli giŋ kaaborɛ ɔmɔ mɔ, gi laa kii ba fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nfono fɛ loo ne nno asa mɛ kine mɛ mɛŋ sɔɔ fɛye abaa anyɔ abɛɛ mɛ mɛŋ nu fɛye asɛ mɔ, fɛ lii ɔsowolɛ mɔ so abɛɛ gɛten gɛbono dɔ mɔ, fɛꞌ kpiisi mɔmɔ-ɔsowolɛ so abɛɛ mɔmɔ-gɛten dɔ isɛ ibono i yii fɛye-ayaa mɔ yela mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","N kya tɔgɛ fɛye gɛsintin yɛɛ gɛkɛ gɛbono Wurubuaarɛ laa biidɛ asa pɛwu giso mɔ, gɛnen ɔsowolɛ ɔbono so asa-lɛɛ gisobiidɛ gi laa nyaakyɔ don Sodom de Gomora isowolɛ so awura-lɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Fɛꞌ nu yɛɛ n kya sun fɛye fɛɛ nsandɛbii ne n kya kpe agbowugbowu dɔ. Imɔso fɛꞌ bii fɛye-nyoro akedabi. Fɛꞌ wɔra fɛye-nyoro faa dolon‑n fɛɛ abonbuɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Fɛꞌ kerɛ fɛye-nyoro so de asa abono n kya sun fɛye mɔmɔ asɛ mɔ. Mɔmɔ dɔ ako mɛ laa kparɛ fɛye kpe nbɛlɛ agyibo asɛ de mɛꞌ taa fɛye awulibi mɔmɔ-akyangbon dɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Me so mɔ, mɛ laa biidɛ fɛye ako kpe abɛyin abelɛnsɛ de awura-awura ansi dɔ. Mɛ kyu fɛye kpe gɛnen mɔ, i laa bugi ɔkpa sa fɛye de fɛꞌ nyɛ tɔgɛ me-ilaa sa mɔmɔ‑rɛ gɛsinkpan so asa kpɛi-kpɛi. ");
INSERT INTO acd_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Mɛ keda fɛye mɔ, fɛŋ sa fɛꞌ yɛgɛ iꞌ wɔra fɛye gɛwɔnsa yɛɛ fafaanan ne i kaaborɛ fɛꞌ kpaa tɔgɛ abɛɛ ilaa idɛ ne fɛ laa tɔgɛ nbɛlɛ nbono dɔ ne. Owi mɔ gi fo mɔ, Wurubuaarɛ laa sa fɛye ilaa ibono i kaaborɛ fɛꞌ tɔgɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","I kya nyiile yɛɛ iŋ gyɛ fɛye gbaa-gbaa ne nan tɔngɛ fɛye-gibaa so. Fɛye-sɛ Wurubuaarɛ Oduduu ne nan tɔngɛ naa de fɛye so. ");
INSERT INTO acd_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","I laa ba yɛɛ fɛye dɔ ako fɛye-daana abɛɛ fɛye-tedɛana gbaa mɛ laa fɛ fɛye sa asa de mɛꞌ mɔɔ fɛye. Ɔsɛ laa kyu gɛnen kee wɔra mɔ-bi. Ne gɛbii gɛ laa koso yelɛ gɛmɔ-sɛ de gɛmɔ-nyi so de gɛꞌ yɛgɛ asa mɛꞌ mɔɔ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Me so mɔ, ɔkamaasɛ laa kyo fɛye. Ɔbono ɔ laa yelɛ mɔ-ayaa so ka gyanꞌ me so kpaa lii mɔ, Wurubuaarɛ laa mɔlɛgɛ mɔ de ɔꞌ nyɛ ɔkyenaten mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nengyene mɛ ka fɛye-ansi ɔsowolɛ ɔko so mɔ, fɛꞌ selɛ kpe ɔsowolɛ banban so. N kya tɔgɛ fɛye gɛsintin yɛɛ fɛ maŋ naa aye-Isirale awura isowolɛ mɔ pɛwu so gyanꞌ pɛi ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kii ba gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Ilaa ɔkasɛbo maŋ taalɛ don mɔ-onyiilebo, ne dega maŋ taalɛ don mɔ-wura. ");
INSERT INTO acd_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Nengyene fo gyɛ ɔkasɛbo ne ilaa ibono asa mɛ dɛ mɛ kya wɔra fo-onyiilebo mɔ mɛ dɛ ma‑a wɔra fo kee mɔ, bii yɛɛ gɛnen ne i kaaborɛ iꞌ ba ne. Nengyene fo gyɛ dega ne mɛ dɛ ilaa ibono mɛ kya wɔra fo-wura mɔ ma‑a wɔra fo mɔ, bii yɛɛ gɛnen ne i kaaborɛ iꞌ ba ne. Nengyene asa mɛ terɛ me ɔbono n gyɛ gɛten wura mɔ yɛɛ Besibuli, ilaa nyɛnyɛn pɛwu gɛmu mɔ, me-adɛ ne mɛ laa yɛgɛ? Mɔmɔ-lɛɛ asebi a laa don me-lɛɛ adɛ gbaa. ");
INSERT INTO acd_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Imɔso fɛ mɛŋ sa fɛꞌ selɛ anyamesɛ. Sɛi mɛŋ bo no i ŋara yɛɛ i maŋ lii gifuli, abɛɛ ilaa iko i bo asiiri dɔ yɛɛ i maŋ lii gɛwi. ");
INSERT INTO acd_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Imɔso ilaa ibono n kya tɔgɛ fɛye gɛnyɛ mɔ, fɛꞌ tɔgɛ sa asa owi kenken, ne ilaa ibono n kya tɔgɛ fɛye adɛɛdɛɛ dɔ aye-wolɛ mɔ, fɛꞌ liirɛ imɔ da gikpengboo. ");
INSERT INTO acd_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Fɛŋ sa fɛꞌ selɛ abono mɛ laa mɔɔ nyamesɛ nyoro gibi mɔ wolɛ ne mɛ maŋ taalɛ nyida mɔ-oduduu bɔla mɔ. Fɛꞌ selɛ daa Wurubuaarɛ ɔbono ɔ laa taalɛ kyu fɛye too wɔra ɔgya dɔ fɛye-lɛwu gɛmara de iꞌ nyida fɛye-nyoro de oduduu pɛwu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Abonbuɛ abono mɛ kya fɛ mɔmɔ anyɔ aterenbi gibi kolon daa mɔ gbaa, fɛye-sɛ Wurubuaarɛ nyi mɔmɔ pɛwu so. Mɔmɔ dɔ ɔkolon mɛŋ kya wuꞌ yɛɛ ɔ mɛŋ nyi mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Ne fɛye mɔ de‑e? Wurubuaarɛ nyi dabɔlɛ fɛye-gimu dɔ iman gɛgyɔnɔ gbaa. ");
INSERT INTO acd_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Imɔso fɛ mɛŋ sa fɛꞌ selɛ gifuu. Fɛ tiri sa Wurubuaarɛ gikyɔ don gɛnen abonbuɛ abono gikpadɔ gifonɛɛ-gifonɛɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Ɔbono ɔ yelɛ asa dɔ tɔgɛ yɛɛ me ne n gyɛ mɔ-wura mɔ, gɛnen ne me kee nan lɛɛ tɔgɛ me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ ansi dɔ yɛɛ ɔ gyɛ me-sonbo. ");
INSERT INTO acd_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne ɔbono, mɔ, o kine me sansana yɛɛ meŋ gyɛ mɔ-wura mɔ, gɛnen ne me kee nan kine mɔ me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ ansi dɔ yɛɛ meŋ nyi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Fɛŋ sa fɛꞌ tɔgɛ yɛɛ nɛ ba gɛsinkpan so faa mɔ, i laa yɛgɛ asa mɛꞌ nyɛ gisen yuuli kyu kyena de abara. Me-giba mɔ gi laa baragɛ asa abono mɛ kya nu me-gɛdɛ mɔ lii abono mɛŋ kya nu me-gɛdɛ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ɔnyen mɔ‑rɛ mɔ-sɛ mɛ maŋ nu abara asɛ. Ɔkyii mɔ‑rɛ mɔ-nyi mɛ maŋ nu abara asɛ. Ne ɔkyii mɔ‑rɛ mɔ-saa kyiisɛ mɛ maŋ nu abara asɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Asa abono mɛ laa kyo fɛye gikyɔ mɔ mɛ laa lii daa fɛye-giyaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Fo ɔbono fo kya laarɛ fo-sɛ abɛɛ fo-nyi ilaa don gɛnɔɔbono fo kya laarɛ me-ilaa mɔ, foŋ kaaborɛ foꞌ wɔra me-ɔkasɛbo. Fo ɔbono fo kya laarɛ fo-bi nyensɛ abɛɛ fo-bi kyiisɛ ilaa don me-lɛɛ mɔ, foŋ kaaborɛ foꞌ wɔra me-ɔkasɛbo. ");
INSERT INTO acd_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ne fo ɔbono fo maŋ kyule wu awɔrɔfɔɔ me so de foꞌ kasɛ me-gidebi, ba‑a mɛ laa da fo-aŋanbi oyii so mɔɔ mɔ ne fo maŋ kyule gɛnen mɔ, foŋ kaaborɛ foꞌ wɔra me-ɔkasɛbo. ");
INSERT INTO acd_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Fo ɔbono fo kya kɔrɔsɛ fo-nkpa fii yela fo-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena ɔnan mɔ gɛ laa lii fo-gibaa. Ne fo ɔbono, mɔ, kyu lii me so ne fo-nkpa gi lii fo-gibaa mɔ, fo laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Isa ɔbono ɔ sɔɔ fɛye abaa anyɔ mɔ, me ne ɔ sɔɔ abaa anyɔ gɛnen. Ne ɔbono ɔ sɔɔ me abaa anyɔ mɔ, Wurubuaarɛ ɔbono o sun me mɔ kee ne ɔ sɔɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɔbono o wu Wurubuaarɛ ikalan ɔtɔgɛbo bii, ne gɛnen so ne ɔ sɔɔ mɔ abaa anyɔ mɔ, ɔ laa nyɛ Wurubuaarɛ ikalan ɔtɔgɛbo ntɛɛla Wurubuaarɛ asɛ. Ɔbono o wu bii yɛɛ ɔko kya gyi gɛsintin sa Wurubuaarɛ, ne gɛnen so ne ɔ sɔɔ mɔ abaa anyɔ mɔ, ɔ laa nyɛ gɛsintin agyibo ntɛɛla Wurubuaarɛ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɔko gi wu nbii ndɛ dɔ gɛko bii yɛɛ me-ɔkasɛbo ne ɔ gyɛ, ne gɛnen so ne ɔ sa mɔ nkyu nunsɛ mɔ, n kya tɔgɛ fɛye gɛsintin, kaasɛ mɔ maŋ wɔra imɔ too nkyu dɔ. Wurubuaarɛ ntɛɛla gi dɛ sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Yesu gi ka mɔ-akasɛbo gudu anyɔ mɔ ta mɔ, ɔ koso ɔ naa de isowolɛ kpɛi-kpɛi ibono i bo gɛnen gɛsinkpan gɛbono so mɔ ɔ kya nyiile asa ilaa ne ɔ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Yesu naa ɔ kya nyiile ilaa gɛnen mɔ, Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ tii de obu, ne o nu Yesu Kirisito ilaa wɔrasɛ mɔ so. Gɛnen so mɔ o sun mɔ-lɛɛ akasɛbo ako Yesu asɛ ");
INSERT INTO acd_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","yɛɛ mɛꞌ kpaa taasɛ mɔ yɛɛ, “Fo ne n gyɛ ɔmɔlɛgɛbo ɔbono a nu yɛɛ ɔ laa ba mɔ abɛɛ aꞌ kerɛ nyamesɛ banban ɔko kpɛi ɔkpa daa?” ");
INSERT INTO acd_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Gyɔn isɔɔ mɔ mɛ kpe kpaa taasɛ Yesu gɛnen mɔ, Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛꞌ kpaa tɔgɛ ilaa kamaasɛ ibono fɛ baa nu de fɛye-aso de ibono fɛ baa wu de fɛye-ansi n kya wɔra faa sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Nɛ yɛgɛ agyaatanbo ansi a bugi, ne ɔtɛgɛsɛana mɛ koso mɛ naa. Nɛ yɛgɛ ikononbu alɔtɔ a ta, ne isintiribu mɛ kya nu ilaa. Nɛ kyingi abono mɛ wuꞌ mɔ ako. Ne nɛ tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ sa ayenbo. ");
INSERT INTO acd_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Imɔso omudɛnsɛbo ne n gyɛ ɔbono mɔ-gisɔɔgyi gi maŋ koso me so mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Gyɔn akasɛbo mɔ mɛ kya kii mɔ, Yesu gi yii gɛsɛ ɔ kya tɔgɛ Gyɔn ilaa ɔ kya sa sakpii ɔbono ɔ bo mɔ asɛ nfono mɔ. Mɔ-gɛtɔngɛ mɔ dɔ mɔ, ɔ taasɛ sakpii mɔ yɛɛ, “Owi ɔbono fɛ kpe Gyɔn asɛ gipen mɔ dɔ kpaa nu mɔ-ilaa tɔgɛsɛ mɔ mɔ, menɛ isa ɔnan ne fɛ kpaa kerɛ daa? Fɛ wu mɔ mɔ, ɔ dɛ fɛɛ gifɛdaa ne afuu a kya da gimɔ a kya kpe a kya ba abɛɛ? ");
INSERT INTO acd_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ne ɔŋ dɛ gɛnen mɔ, nnɛ ne ɔ dɛ? Fɛ wu o bun gikuru dɛnsɛ? Kuaa, nkana akuru dɛnsɛ abunbo ne fɛ kya laarɛ de fɛꞌ kpaa kerɛ berɛ mɔ, ɔfaanan fɛ kpe daa awura-awura nwi. ");
INSERT INTO acd_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Imɔso fɛ kpe Gyɔn asɛ mɔ, menɛ nyamesɛ ɔnan ne fɛ kpaa kerɛ daa? Wurubuaarɛ ikalan ɔtɔgɛbo abɛɛ? Ɛn, n kya buu mi‑i sa fɛye yɛɛ ɔ don Wurubuaarɛ ikalan ɔtɔgɛbo gbaa. ");
INSERT INTO acd_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Gyɔn ne n gyɛ Wurubuaarɛ ɔsɔɔ ɔbono mɛ ŋmarasɛ mɔ-ilaa yela Wurubuaarɛ agyɛbi dɔ yɛɛ Wurubuaarɛ laa sun mɔ de ɔꞌ gyangbara kpaa tɔgɛ sa asa yɛɛ mɛꞌ lɔrɔ mɔmɔ-akyenabi gyoo me ɔbono nan baa mɔlɛgɛ asa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Gɛsintin ne n kya tɔgɛ fɛye faa, iŋ ti korogɛ nyamesɛ ɔbono ɔ don Gyɔn baarɛ. Abono, mɔ, mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi lii nperɛ kyu kyon mɔ, mɔmɔ dɔ ɔbono ɔŋ fo sɛi gbaa mɔ, laa don Gyɔn. ");
INSERT INTO acd_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Lii aberɛ abono Gyɔn gi yii gɛsɛ ɔ kya tɔgɛ Wurubuaarɛ ɔkalan mɔ ɔ kya sa asa baa lii de ndɛ mɔ, asa mɛ kya nyanga ansi ma‑a nyise de mɛꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. Gɛnsipɛɛrɛ awura adɛ mɛ dɛ ansiɔlon mɛ kya nyɛ gɛnen akyenabi abono. ");
INSERT INTO acd_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lii ko‑o dedaa kyu baa lii Gyɔn aberɛ adɛ mɔ, asa mɛ wolaa wu Wurubuaarɛ gɛwuragyi dɔ akyenabi abono so ilaa tɔgɛ yela, ne mɛ ŋmarasɛ imɔ wɔra Wurubuaarɛ nbara iwolɛ dɔ de mɔ-ikalan atɔgɛbo iwolɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Nꞌ tɔgɛ sa fɛye abono fɛ laa kyule sɔɔ imɔ gyi mɔ yɛɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔko gi tɔgɛ yɛɛ ‘Ilaagya laa kii ba’. Gyɔn ne ɔ darɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Yesu gi kii taasɛ sakpii mɔ yɛɛ, “Menɛtɔ gbaa ne nan nyɛ kyu kɛserɛ de ndɛ asa adɛ ne?” Yesu gi taasɛ gɛnen mɔ, o kii lɛɛ gɛsɛ sa sakpii mɔ yɛɛ, “Ndɛ asa mɛ dɛ fɛɛ nbii ne n kpaa gyanꞌ sansana gɛtɛɛko. Mɛ gyanꞌ gɛnen mɔ, mɛ kya tɔgɛ mɛ kya sa abara ");
INSERT INTO acd_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","yɛɛ, ‘A lan akɔrɛ ne a bii ilon sa fɛye mɔ, fɛ kine, fɛŋ kyaa. A kpen saawo bii lɛwu ilon de fɛꞌ saawo mɔ, fɛ kine, fɛŋ saawo.’ ” ");
INSERT INTO acd_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Yesu gi lɛɛ gɛsɛ yɛɛ, “Gyɔn gi ba gɛsinkpan so faa mɔ, ɔ kya ŋminde gɛnɔ belen-belen ne ɔ mɛŋ kya nun nta. Imɔso asa mɛ kya tɔgɛ yɛɛ, ‘Ilaa nyɛnyɛn oduduu ne n tɛ mɔ so.’ ");
INSERT INTO acd_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, mɔ, nɛ ba gɛsinkpan so faa, n kya gyi n kya nun. Imɔso asa mɛ kya tɔgɛ yɛɛ, ‘Kerɛ, ɔnyen baarɛ! Ogyibelɛbo de nta nunbo ne ɔ gyɛ. Mɔ-kyɛmenɛana ne n gyɛ lɛnpoo asɔɔbo abono mɛ kya kudi asa gyi mɔ de ilaa nyɛnyɛn awɔrabo sɛnsɛ.’ Fɛŋ nu ndɛ asa mɔ ilaa tɔgɛsɛ?” Ne Yesu gi kii tɔgɛ bɔla yɛɛ, “Ilaa ibono nyamesɛ kya kyu ɔlaako ginyi wɔra mɔ ne n kya nyiile yɛɛ mɔ-ɔlaako ginyi mɔ gi boran.” ");
INSERT INTO acd_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Nfono mɔ Yesu gi yii gɛsɛ ɔ kya tɔgɛ isowolɛ iko so asa ilaa yɛɛ mɛ bo ilaa nyɛnyɛn, yɛgɛ nkana o kyu Wurubuaarɛ ɔlon kyu wɔra amunale ilaa gbaaꞌgbaa gikyɔ ne mɛ mɛŋ nu Wurubuaarɛ gɛdɛ de mɛꞌ taa mɔmɔ-ilaa nyɛnyɛn giwɔra yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɔ tɔgɛ yɛɛ, “O, Korasin ɔsowolɛ so asa, fɛye laako! O, Bɛsayida ɔsowolɛ so asa, fɛye laako! Nɛ kyu Wurubuaarɛ ɔlon wɔra amunale ilaa gbaaꞌgbaa fɛye-isowolɛ so ibono fɛ wu de ansi. Nengyene nkana Taya de Sidon awura ne nen nyɛ me-ilaa ibono wu gɛnen mɔ, ɔfaanan mɛ ti wolaa taa mɔmɔ-ilaa nyɛnyɛn giwɔra yɛgɛ. Nkana ɔfaanan mɛ kya bɔɔda kyena mɛ kya pɛɛrɛ ansi lɛɛ nyiile Wurubuaarɛ yɛɛ mɛ nu mɔmɔ-nyoro gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","N kya tɔgɛ fɛye yɛɛ gɛkaabono Wurubuaarɛ laa biidɛ asa nyɛnyɛn pɛwu giso mɔ, fɛye-lɛɛ i laa wɔra nyɛnyɛn don Taya de Sidon awura-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ne fɛye Kapɛɛniyon awura mɔ de‑e? Fɛ nyi yɛɛ Wurubuaarɛ laa kyu fɛye kpe mɔ asɛ? Kuaa, ɔ laa too fɛye wɔra daa ɔbɔ dɔ nfono ɔ kya biidɛ ilaa nyɛnyɛn awɔrabo giso mɔmɔ-lɛwu gɛmara mɔ. I lii fɛɛ nɛ kyu Wurubuaarɛ ɔlon kyu wɔra amunale ilaa gbaaꞌgbaa fɛye-ɔsowolɛ so ne fɛ wu de fɛye-ansi. Nengyene nkana Sodom awura ne nen nyɛ me-ilaa ibono wu gɛnen mɔ, ɔfaanan mɔmɔ-ɔsowolɛ san o yii baa lii de ndɛ. ");
INSERT INTO acd_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","N kya tɔgɛ mi‑i sa fɛye yɛɛ gɛkaabono Wurubuaarɛ laa biidɛ asa nyɛnyɛn pɛwu giso mɔ, fɛye-lɛɛ i laa wɔra nyɛnyɛn don Sodom awura-lɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Owi ɔbono Yesu san ɔ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ so ilaa ɔ sa asa mɔ, Yesu gi faala Wurubuaarɛ yɛɛ, “Me-sɛ, soso de gɛsinkpan pɛwu Wura, n kya faala fo yɛɛ fo kyu gɛnen ilaa idɛ ŋara abono mɛ nyi ɔlaako mɔ de abono mɛ sɛɛ mɔ, ne fo san lɛɛ imɔ-gɛwi nyiile daa nbii de asa abono mɛ mɛŋ nyi gisɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Gɛsintin, me-sɛ. Imɔ ibono ne n wɔra fo ɔbolɛ.” ");
INSERT INTO acd_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Yesu gi kii tɔgɛ yɛɛ, “Me-sɛ Wurubuaarɛ gi kyu ilaa kamaasɛ wɔra me-abaa dɔ. Ɔko mɛŋ bo no o nyi me, Wurubuaarɛ mɔ-bi mɔ, gɛnen mɔ, me-sɛ Wurubuaarɛ wolɛ. Gɛnen kee ne ɔko mɛŋ bo no o nyi Wurubuaarɛ, gɛnen mɔ, me ɔbono n gyɛ mɔ-bi mɔ; me‑rɛ asa abono nꞌ kya laarɛ de nꞌ lɛɛ mɔ-gɛwi nyiile ɔmɔ mɔ wolɛ ne nan nyɛ bii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Fɛye abono pɛwu fɛye-gɛkyena dɔ ilaa i bo ɔlon sa fɛye, ne i wɔra fɛɛ gɛsola i kya nu fɛye mɔ, fɛꞌ ba me asɛ. Nan sɔɔ fɛye de fɛꞌ kyoola. ");
INSERT INTO acd_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Fɛꞌ nu me-gɛdɛ de fɛꞌ kasɛ me-gidebi. Fɛ wɔra gɛnen mɔ, fɛye-asen a laa kyena fɛye gɛten kolon. I kya nyiile yɛɛ n gyɛ nyamesɛ ɔbono n kya bara me-nyoro gɛsɛ, ne nꞌ pɔɔ lii me-gisen dɔ. ");
INSERT INTO acd_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Me asɛ gɛkyena gɛŋ bo sen, ne gɛsola gɛbono nan kyu sola fɛye mɔ gɛŋ bo duduu.” ");
INSERT INTO acd_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Gɛnen nkɛ nbono dɔ imɔ gɛkɛ kyoolasɛ gɛko mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya kpe gɛtɛɛko, ne mɛ baa loo awayu ndɔɔ nko dɔ. Mɛ kya kyon mɔ, akon a dɛ mɔ-akasɛbo mɔ, ne mɛ yii gɛsɛ mɛ kya kyadɛ awayu mɔ, mɛ kya fɔlɔgɛ mɛ kya wɛ. ");
INSERT INTO acd_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Farasii gikpen mɔ dɔ ako mɛ wu mɔmɔ gɛnen mɔ, mɛ tɔgɛ sa Yesu yɛɛ, “Kerɛ, fo-akasɛbo mɔ mɛ kya kyadɛ awayu adɛ faa, gɛsun ne mɛ kya wɔra aye-gɛkɛ kyoolasɛ mɔ faa. Aye-nbara mɔ giŋ kya sa ɔkpa gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛ nyi yɛɛ iŋ dɛ ɔkpa gɛnen faa mɔ, imɔso fɛŋ ti kalɛ Deefidi mɔ‑rɛ mɔ-nanboana ilaa Wurubuaarɛ agyɛbi mɔ dɔ kerɛ? Mɛ ŋmarasɛ nno yɛɛ owi ɔko dɔ mɔ, akon a dɛ Deefidi mɔ‑rɛ mɔ-nanboana. ");
INSERT INTO acd_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Imɔso ɔ loo Wurubuaarɛ ɔson panpan mɔ dɔ kpaa puru bodobodo ɔbono asa mɛ kyu bara Wurubuaarɛ mɔ, ne o gyi ne o kyu iko kee sa mɔ-nanboana mɔ. Naafo aye-nbara mɔ giŋ kya sa ɔkpa yɛɛ fo nyamesɛ giyan foꞌ nyɛ gyi gɛnen bodobodo ɔbono, gɛnen mɔ, aye Gyuda awura asunbi alɛɛbo wolɛ. ");
INSERT INTO acd_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ne fɛŋ ti kalɛ Wurubuaarɛ agyɛbi dɔ nfono mɛ ŋmarasɛ Wurubuaarɛ asunbi alɛɛbo gɛsun wɔrasɛ ilaa mɔ? Nno i kya nyiile yɛɛ Wurubuaarɛ asunbi alɛɛbo mɔ mɛ bo mɔmɔ-gɛsun wɔrasɛ mɛ kya wɔra Wurubuaarɛ ɔson obu mɔ dɔ gɛkɛ kyoolasɛ, ne Wurubuaarɛ mɛŋ kya kyu imɔ yɛɛ mɛ tɔrɔ gɛkɛ kyoolasɛ nbara. ");
INSERT INTO acd_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","N kya tɔgɛ mi‑i sa fɛye yɛɛ, me ɔbono n yelɛ fɛye asɛ gɛrɛnaa faa nɛ don Wurubuaarɛ ɔson obu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Wurubuaarɛ gi tɔgɛ yela mɔ-agyɛbi ɔwolɛ dɔ yɛɛ, ‘Me Wurubuaarɛ, n kya laarɛ fɛꞌ su asa gitolon; i mɛŋ gyɛ asunbi abono fɛ laa lɛɛ sa me mɔ ne nꞌ kya laarɛ.’ Fɛmɛn nu agyɛbi adɛ gɛsɛ mɔ, nkana fɛ maŋ bun me-akasɛbo adɛ gipuɛɛ. I lii fɛɛ mɛ mɛŋ wɔra ilaa nyɛnyɛn iko. ");
INSERT INTO acd_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Imɔso fɛꞌ nu yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔlon dabɔlɛ gɛkɛ kyoolasɛ mɔ so.” ");
INSERT INTO acd_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Yesu gi lii nfono ne ɔ naa kpaa loo Gyuda awura gikyangbon giko dɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ɔnyen ɔko bo nno, mɔ-gibaa giko gi wuꞌ. Ne asa abono mɛ bo gɛnen gikyangbon gibono dɔ mɔ ako mɛ kya dii Yesu de mɛꞌ nyɛ kyu mɔ wɔra nbɛlɛ dɔ. Imɔso mɛ taasɛ mɔ yɛɛ, “Aye-nbara gi kya sa ɔkpa yɛɛ aꞌ kyɛ alɔbo gɛkɛ kyoolasɛ?” ");
INSERT INTO acd_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yesu gi lɛɛ gɛnɔ taasɛ mɔmɔ yɛɛ, “Ne fɛɛ fɛye ɔko bo sandɛ ne ɔ tɔrɔ ɔbɔ dɔ gɛkɛ kyoolasɛ mɔ de‑e? Ɔ maŋ kpaa lɛɛ mɔ lii gɛnen ɔbɔ mɔ dɔ? ");
INSERT INTO acd_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Ne nyamesɛ mɔ mɛŋ tiri don sandɛ gbaa bun? Imɔso fɛꞌ bii yɛɛ aye-nbara gi kya sa aye ɔkpa de aꞌ wɔra idɛnsɛ gɛkɛ kyoolasɛ.” ");
INSERT INTO acd_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Nfono mɔ ɔ tɔgɛ sa ɔnyen gibaa wusɛ wura mɔ yɛɛ, “Tengɛ fo-gibaa mɔ.” Gɛsintin mɔ, ɔ tengɛ gimɔ, ne gibaa mɔ gi kii kyingi wɔra fɛɛ gidɛnsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Farasii gikpen mɔ dɔ awura mɛ wu gɛnen mɔ, mɛ lii kpaa da gɛdɛ gɛnɔɔbono mɛ laa nyɛ Yesu mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Yesu gi nu yɛɛ mɛ da gɛdɛ mɛ kya laarɛ mɔ-imɔɔten mɔ, ɔ lii nfono kpe gɛten pobɔrɔ. Ɔ kya kpe mɔ, sakpii belɛ ɔko gi buu mɔ. Ɔ kyɛ abono pɛwu mɛ kya lɔ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ne ɔ ka sa mɔmɔ yɛɛ mɛŋ sa mɛꞌ tɔgɛ isa ɔbono ɔnan ɔ gyɛ mɔ sa asa. ");
INSERT INTO acd_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ɔ ka sa mɔmɔ gɛnen daa de mɔ Yesu ilaa ibono Wurubuaarɛ gi tɔgɛ kyu naa de mɔ-ikalan ɔtɔgɛbo Isaya so mɔ iꞌ nyɛ ba gɛsintin. Ɔ tɔgɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Fɛꞌ kerɛ ɔbono nɛ lɛɛ gibaa yii yɛɛ ɔꞌ wɔra me-gɛsun mɔ. Mɔ-ilaa i bo me-gisen dɔ; ɔ tansi ɔ kya gyi me-ginsi. Nan yɛgɛ me-Oduduu mɔ ɔꞌ kyena mɔ dɔ, de ɔꞌ tɔgɛ sa gɛsinkpan so asa kpɛi-kpɛi yɛɛ nan gyi mɔmɔ pɛwu nbɛlɛ gɛsintin ɔkpa so. ");
INSERT INTO acd_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ɔ maŋ lɔgedɛ de ɔko, ne ɔ maŋ puiidɛ asa so. Asa mɛ maŋ nu yɛɛ mɔ ne n naa ɔ kya kpen de ikpa faa. ");
INSERT INTO acd_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Abono mɛ gyɛ afɔlɛbo de abono mɛŋ ti sɔɔ Wurubuaarɛ gyi dandan mɔ, ɔ maŋ ŋaala mɔmɔ ne ɔ maŋ yɛgɛ iꞌ yɔɔ mɔmɔ-nyoro. Ɔ maŋ lɛɛ ansi yɛgɛ mɔmɔ kpaa fo gɛkaabono ɔ laa yɛgɛ gɛsintin gɛꞌ gyi ilaa kamaasɛ so mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Mɔ so ne gɛsinkpan so asa kpɛi-kpɛi mɛ laa kyu mɔmɔ-ansi gyanꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Imɔ idɛ gɛmara mɔ, asa ako mɛ kyu ɔnyen ɔko kyu bara Yesu. Gɛnen ɔnyen mɔ gyɛ gyaatanbo ne o kii ɔ gyɛ omuumuu. I kya nyiile yɛɛ ilaa nyɛnyɛn oduduu tɛ mɔ so. Yesu gi kosorɛ gɛnen oduduu nyɛnyɛn ɔbono lii ɔnyen mɔ so, ne ɔ taalɛ ɔ kya tɔngɛ ne ɔ kya wu ilaa. ");
INSERT INTO acd_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Asa abono mɛ koola nfono mɔ mɛ wu gɛnɔɔbono Yesu gi kosorɛ ilaa nyɛnyɛn oduduu mɔ lii ɔnyen mɔ so mɔ, i dɛ mɔmɔ pɛwu gɛnɔ. Mɛ san ma‑a taasɛ abara yɛɛ, “Itɛfaa ɔdɛ ne n gyɛ Wura Deefidi ɔnaanabi ɔbono a kerɛ mɔ-ɔkpa mɔ do‑o?” ");
INSERT INTO acd_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Farasii awura mɛ nu ilaa idɛ mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Mɔ ɔdɛ berɛ, ilaa nyɛnyɛn oduduu pɛwu gɛmu mɔ ɔbono mɛ kya terɛ mɔ-ginyen giko yɛɛ Besibuli mɔ ne n kya sa mɔ ɔlon. Imɔso ne ɔ taalɛ ɔ kya gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Yesu, mɔ, gi bii mɔmɔ-nwɔnsa dɔ, ne ɔ tɔgɛ sa mɔmɔ akpalɛ dɔ yɛɛ, “Nengyene ilaa nyɛnyɛn gɛmu mɔ ne n kya yɛgɛ nꞌ kosorɛ mɔ-adɛ mɔ, i laa wɔra fɛɛ wura mɔ‑rɛ mɔ-adɛ ne n kya kɔ de abara. Mɛ kya kɔ gɛnen mɔ, mɔ-gɛwuragyi mɔ gɛ laa nyida. Ɔsowolɛ kolon dɔ asa abɛɛ gɛten kolon dɔ asa mɛ yɛ mɔmɔ-nyoro dɔ mɛ kya kɔ mɔ, gɛnen ɔsowolɛ ɔbono abɛɛ gɛten gɛbono gɛ laa boori. ");
INSERT INTO acd_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Imɔso nengyene i gyɛ gɛsintin yɛɛ ilaa nyɛnyɛn pɛwu gɛmu mɔ kya kosorɛ mɔ-adɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi mɔ, mɛ yɛ mɔmɔ-nyoro dɔ ne. Nnɛ so ne mɔ-gɛwuragyi gɛ laa dɛ kpe? ");
INSERT INTO acd_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","“Fɛye yɛɛ Besibuli ɔlon dɔ ne nꞌ kya kosorɛ ilaa nyɛnyɛn oduduu asa so? Ne ibono fɛye-adɛ ako, mɔ, kee mɛ kya kosorɛ ilaa nyɛnyɛn oduduu asa so faa mɔ de‑e? Anɛ ɔlon dɔ ne mɛ kya kosorɛ imɔ gɛnen daa? Fɛye gbaa-gbaa adɛ mɔ mɛ laa kyɔɔlɛ fɛye yɛɛ iŋ gyɛ Besibuli ɔlon dɔ ne isa laa taalɛ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi. ");
INSERT INTO acd_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Gɛnɔɔbono i dɛ faa mɔ, Wurubuaarɛ Oduduu mɔ ne nꞌ dɛ mi‑i kosorɛ ilaa nyɛnyɛn oduduu asa so. Imɔso i kya lɛɛ i kya nyiile fɛye yɛɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi a ti a bo fɛye dɔ ne.” ");
INSERT INTO acd_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Ne Yesu gi kii da gikpalɛ sa ɔmɔ yɛɛ, “Ilaa nyɛnyɛn pɛwu gɛmu mɔ dɛ daa fɛɛ ɔnyen bolonsɛ ɔbono ɔ kya dii mɔ-gɛten dandan. Nnɛ ne fo ɔko fo laa wɔra de foꞌ loo gɛnen gɛten gɛbono dɔ yuuri mɔ-atɔ? Pɛi ne fo laa yuuri mɔ-atɔ mɔ, gɛnen mɔ, fo ŋminde mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Fɛꞌ nu yɛɛ ɔbono ɔŋ kya buu me mɔ kya sɔɔ akyɔɔlɛ de me ne. Ɔbono ɔŋ kya kpaa me de nꞌ koola asa mɔ, ɔ kya yaasɛ mɔmɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","N kya tɔgɛ mi‑i sa fɛye yɛɛ, ilaa nyɛnyɛn kpɛi-kpɛi kamaasɛ ibono fo nyamesɛ fo laa wɔra mɔ de asebi kamaasɛ abono fo laa saalɛ Wurubuaarɛ mɔ, i laa sa de Wurubuaarɛ oꞌ kyu imɔ kyu kyɛɛ fo. Ibono ɔko laa saalɛ Wurubuaarɛ Oduduu mɔ berɛ, Wurubuaarɛ maŋ kyu imɔ ibono kyu kyɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Fo ɔbono fo tɔgɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nyoro so ilaa nyɛnyɛn mɔ, i laa sa de Wurubuaarɛ oꞌ kyu kyɛɛ fo. Ɔbono, mɔ, ɔ laa saalɛ Wurubuaarɛ Oduduu mɔ berɛ, Wurubuaarɛ maŋ kyu kyɛɛ mɔ gɛkyena gɛdɛ dɔ ne ɔ maŋ kyu kyɛɛ mɔ gɛkyena pobɔrɔ gɛbono gɛ laa baa ba gɛkaako mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Fɛꞌ kerɛ nyamesɛ ilaa wɔrasɛ de fɛꞌ kyu bii mɔ-gisen dɔ ilaa. I dɛ daa fɛɛ gɛnɔɔbono oyii bo alanfiya ne mɔ-abi sɔrɔsɛ kee mɔ a boran mɔ. Ne fɛɛ ɔŋ bo alanfiya mɔ, mɔ-abi kee aŋ boran. Oyii abi ne mɛ kya kyu bii mɔ-alanfiya. Nyamesɛ ilaa wɔrasɛ kee ne mɛ kya kyu bii mɔ-gisen dɔ ilaa. ");
INSERT INTO acd_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Fɛ dɛ fɛɛ awɔɔ abono a bo gibɔrɔ mɔ gikpen. Fɛye ilaa nyɛnyɛn awura adɛ, ilaa dɛnsɛ imɔ ne nan lii fɛye-nnɔ dɔ? Ilaa ibono i bo nyamesɛ gisen dɔ mɔ, imɔ ne ɔ kya lɛɛ tɔgɛ. ");
INSERT INTO acd_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Nyamesɛ dɛnsɛ berɛ, ilaa dɛnsɛ ne n bo mɔ-gisen dɔ, ne ilaa dɛnsɛ ne nan lii mɔ-gɛnɔ dɔ. Ne nyamesɛ nyɛnyɛn, mɔ, ilaa nyɛnyɛn ne n bo mɔ-gisen dɔ, ne ilaa nyɛnyɛn kee ne nan lii mɔ-gɛnɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","N kya tɔgɛ mi‑i sa fɛye yɛɛ gɛkɛ gɛbono Wurubuaarɛ laa gyi anyamesɛ pɛwu nbɛlɛ mɔ, anyantɔgɛ kamaasɛ abono fo ɔko fo tɔgɛ mɔ fo laa yelɛ Wurubuaarɛ ansi dɔ lɛɛ fo-gɛnɔ ilaa ibono so fo tɔgɛ amɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Fo nyamesɛ fo-gɛnɔ dɔ ilaa tɔgɛsɛ ibono fo laa tɔgɛ gɛsinkpan so mɔ ne Wurubuaarɛ laa kyu gyi fo-nbɛlɛ de oꞌ bun fo gipuɛɛ abɛɛ ɔꞌ sa fo aso.” ");
INSERT INTO acd_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Nfono mɔ nbara aŋmarasɛbo ako de Farasii gikpen mɔ dɔ asa ako mɛ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, a kya laarɛ foꞌ wɔra ilaa ibono i laa lɛɛ nyiile aye yɛɛ Wurubuaarɛ ne n sa fo ɔlon ɔbono fo dɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛye ndɛ asa adɛ! Fɛ bo ilaa nyɛnyɛn ne fɛŋ kya son Wurubuaarɛ gɛsintin ɔkpa so! Gɛnen so ne fɛ kpɛ fɛ kya laarɛ fɛꞌ wu ilaa lɛɛnyiilesɛ faa. Ilaa kolon guan‑n ne Wurubuaarɛ laa wɔra sa fɛye de fɛꞌ wu. Gɛnen ilaa ibono mɔ i laa wɔra daa fɛɛ ibono i ba Wurubuaarɛ ikalan ɔtɔgɛbo Gyoona so mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Fɛɛ gɛnɔɔbono Gyoona gi gyi nkɛ nsa toloowi kalaadɛ ɔken belɛ ɔtɔ dɔ mɔ, gɛnen kee ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan gyi nkɛ nsa toloowi kalaadɛ gɛsinkpan ɔbɔ dɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","“Owi ɔbono Wurubuaarɛ laa gyi anyamesɛ pɛwu nbɛlɛ mɔ, Ninifa awura mɛ laa koso yelɛ tɔgɛ yɛɛ i kaaborɛ Wurubuaarɛ oꞌ bun fɛye ndɛ asa gipuɛɛ. I lii fɛɛ Gyoona owi mɔ, Gyoona gi tɔgɛ Wurubuaarɛ ɔkalan sa Ninifa awura mɔ, mɛ nu mɔmɔ-nyoro gɛsɛ ne mɛ kyɛɛgɛ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ. Fɛye berɛ, fɛ nyɛ me ɔbono nɛ don Gyoona mɔ n bo fɛye asɛ gɛrɛ ndɛ faa, ne fɛ maŋ sɔɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Gɛkaabono kee mɔ wura kyiisɛ ɔbono o gyi gɛwura Siiba gɛsinkpan so dedaa mɔ laa koso yelɛ tɔgɛ yɛɛ i kaaborɛ Wurubuaarɛ oꞌ bun fɛye ndɛ asa adɛ gipuɛɛ. I lii fɛɛ Wura Solomon owi mɔ, gɛnen ɔkyii baarɛ gi nu mɔ-ɔlaako ginyi mɔ so, ne ɔ koso lii ko‑o mɔ-gɛwi gɛten bogɛtasɛ kpaa nu Wura Solomon ɔlaako ginyi ilaa nyiilesɛ mɔ. Fɛye berɛ, fɛ nyɛ me ɔbono nɛ don Wura Solomon mɔ, n bo fɛye asɛ gɛrɛ ndɛ, ne fɛ kine fɛ mɛŋ sɔɔ me gyi. ");
INSERT INTO acd_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Nengyene ilaa nyɛnyɛn oduduu i koso isa so mɔ, i kya naa kingi, ne i kya wɔra imɔ fɛɛ i naa gɛsinkpan so nfono nkyu giŋ bo mɔ. I naa i naa i kya laarɛ ɔkyoolaten. Nengyene iŋ nyɛ ɔkyoolaten mɔ, ");
INSERT INTO acd_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","i kya tɔgɛ sa imɔ-nyoro yɛɛ, ‘Nan kii kpaa kyena isa ɔbono n wolaa n tɛ mɔ so mɔ.’ I kii kpe isa mɔ asɛ mɔ, i kya kpaa wu yɛɛ isa mɔ gi wɔra fɛɛ gɛten gɛbono mɛ kpa gɛmɔ lɔrɔ, gɛ wɔra ɔdan, ne ɔko mɛŋ tɛ gɛmɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Nfono mɔ, ilaa nyɛnyɛn oduduu mɔ i kya kpaa terɛ imɔ-nanboana sono ibono i bo ilaa nyɛnyɛn don imɔ-nyoro mɔ kyu baa bɔla imɔ-nyoro so de iꞌ kii kpaa kyena isa mɔ so. Nengyene i ba gɛnen mɔ, i kya lɔrɔ wɔra nyɛnyɛn sa isa mɔ don gigyangbarasɛ mɔ. Gɛnen ne i laa wɔra sa ndɛ nkɛ ndɛ dɔ asa abono mɛ bo ilaa nyɛnyɛn mɔ ne.” ");
INSERT INTO acd_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Yesu san ɔ kya tɔngɛ de asa mɔ mɔ, mɔ-nyi de mɔ-tedɛana mɛ ba, mɛ yelɛ nŋmaŋman mɛ kya laarɛ mɛꞌ wu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ɔko gi tɔgɛ sa Yesu yɛɛ, “Kerɛ, fo-nyi de fo-tedɛana mɛ yelɛ nŋmaŋman mɛ kya laarɛ mɛꞌ wu fo.” ");
INSERT INTO acd_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Yesu gi lɛɛ gɛnɔ taasɛ mɔ yɛɛ, “Anɛ ne n gyɛ me-nyi? Anɛana ne n gyɛ me-tedɛana?” ");
INSERT INTO acd_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Nfono mɔ ɔ lɛɛ gibaa nyiile mɔ-akasɛbo mɔ ne ɔ tɔgɛ yɛɛ, “Me-nyi de me-tedɛana ne! ");
INSERT INTO acd_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Isa ɔbono ɔ kya wɔra me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ gɛlaarɛ mɔ, mɔ ne n gyɛ me-tedɛ, mɔ ne n gyɛ me-pikyii, mɔ ne n gyɛ me-nyi.” ");
INSERT INTO acd_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Gɛnen gɛkɛ kolon gɛbono mɔ, Yesu gi lii gɛten mɔ dɔ kyon ɔbon belɛ mɔ gigengen. Ɔ fo nno mɔ, ɔ kpelegɛ kyena ne o nyiile asa ilaa. ");
INSERT INTO acd_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Sakpii belɛ ɔko gi kyaabɔɔ mɔ. Gɛnen so mɔ ɔ dii loo gikolii dɔ ɔ tɛ; asa mɔ, mɔ, mɛ san mɛ yelɛ gigengen so. ");
INSERT INTO acd_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ɔ tɔgɛ mɔmɔ ilaa gikyɔ akpalɛ dɔ. Ɔ da gikpalɛ giko sa mɔmɔ yɛɛ, “Dɔɔbo ɔko gi kyena. Owi ɔko dɔ mɔ, ɔ koso kpe ndɔɔ kpaa ŋmadɛ ayu. ");
INSERT INTO acd_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ɔ kya ŋmadɛ ayu mɔ mɔ, ako a tɔrɔ ɔkpa dɔ, ne nbuii mɛ baa tɔɔsɛ amɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ayu mɔ ako, mɔ, a tɔrɔ kpandan so. Amɔ abono a kpaala kɔrɔ. I kya nyiile yɛɛ isɛ ibono i bo kpandan mɔ so mɔ iŋ kyɔ, ");
INSERT INTO acd_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","imɔso ayu mɔ a mɛŋ nyɛ de amɔ-ilin iꞌ loo gɛsɛ. Owi gi dii mɔ, a wiili ne a wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ako kee a tɔrɔ iwe dɔ. Abono a kɔrɔ mɔ, iwe mɔ i koso bun wɔra amɔ, ne a wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amɔ ako, mɔ, a tɔrɔ gɛsinkpan dɛnsɛ so. Amɔ berɛ, a kɔrɔ, ne a sen da amu kanpɛ. Dɔɔbo mɔ gi kɛbi amɔ mɔ, ɔ nyɛ abono ɔnan o kyu ŋmadɛ mɔ, amɔ ako ikue-inun, ako ikue-isa, ne ako mɔ oko de saalaa.” ");
INSERT INTO acd_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ tɔgɛ yɛɛ, “Ɔbono ɔ bo aso mɔ, oꞌ nu!” ");
INSERT INTO acd_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Nfono mɔ Yesu akasɛbo mɔ mɛ tu sindi mɔ ne mɛ taasɛ mɔ yɛɛ, “Menɛ n wɔra so ne fo kya tɔngɛ daa akpalɛ dɔ fi‑i sa mɔmɔ?” ");
INSERT INTO acd_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛye berɛ Wurubuaarɛ laa lɛɛ mɔ-gɛwuragyi dɔ akyenabi mɔ ilaa boduduusɛ nyiile fɛye. I mɛŋ gyɛ mɔmɔ asa sɛnsɛ adɛ. ");
INSERT INTO acd_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","I lii fɛɛ ɔbono ɔ kya nu Wurubuaarɛ asɛ mɔ, ɔ laa nu de oꞌ nu imɔ gɛsɛ. Ne ɔbono, mɔ, ɔŋ kya nu Wurubuaarɛ asɛ mɔ, ipii ibono o nu mɔ gbaa, i laa kii lii mɔ-gimu dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Gɛnen asa abono ɔnan berɛ, mɛ dɛ mɔmɔ-ansi mɛ kya kerɛ, mɛŋ kii mɛ wu sɛi, mɛ kya nu ilaa de mɔmɔ-aso, mɛŋ kii ma‑a nu imɔ gɛsɛ. Imɔso ne nꞌ kya tɔngɛ de mɔmɔ akpalɛ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Mɔmɔ-ilaa idɛ i kyena de ilaa ibono Isaya gi wolaa wu tɔgɛ yela mɔ. Ɔ tɔgɛ yela yɛɛ, ‘Mɛ laa kpɛ mɛ kya nu ilaa, mɛ maŋ kii nu imɔ gɛsɛ. Mɛ laa kpɛ mɛ kya kerɛ ilaa, mɛ maŋ kii wu sɛi. ");
INSERT INTO acd_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","I lii fɛɛ mɔmɔ-nwɔnsa dɔ iŋ bugi de ilaa gɛsɛ ginu. Mɔmɔ-aso a tii, ne mɛ baala mɔmɔ-ansi bun. Ne fɛɛ i mɛŋ gyɛ gɛnen mɔ, ɔfaanan mɛ kya wu ilaa. Mɛ kya nu ilaa de mɔmɔ-aso, ne mɛ kya nu ilaa gɛsɛ. Ne fɛɛ mɛ nyɛ mɛ kya nu ilaa gɛsɛ mɔ, nkana mɛ laa kii ba me asɛ de nꞌ kyɛ mɔmɔ-gilɔtɔ gibono mɛ kya lɔ mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Yesu gi kii tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛye berɛ, amudɛnsɛbo ne n gyɛ fɛye. Fɛye-ansi a kya wu ilaa, ne fɛye-aso a kya nu. ");
INSERT INTO acd_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, Wurubuaarɛ ikalan atɔgɛbo de asɛnsɛ abono mɛ gyi gɛsintin sa Wurubuaarɛ baa kyon mɔ mɔmɔ sakyɔ mɛ tansi laarɛ mɛꞌ nyɛ wu ilaa ibono fɛ kya wu faa, mɛŋ kii nyɛ. Mɛ tansi laarɛ mɛꞌ nyɛ nu ilaa ibono fɛ kya nu faa, mɛŋ kii nyɛ. ");
INSERT INTO acd_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Fɛꞌ nu dɔɔbo mɔ gikpalɛ mɔ gɛsɛ kon. ");
INSERT INTO acd_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ayu abono a tɔrɔ ɔkpa dɔ mɔ a dɛ fɛɛ asa abono mɛ kya nu Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa ne mɛŋ kya nu imɔ gɛsɛ mɔ. Ɔbonsan, nyamesɛ nyɛnyɛn mɔ ne n kya baa sɔgɛ amɔ lii mɔmɔ-asen dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ayu abono a tɔrɔ kpandan so mɔ a dɛ fɛɛ asa abono mɛ kpɛ nu Wurubuaarɛ agyɛbi mɔ, ne mɛ kya sɔɔ amɔ de ɔkon, ");
INSERT INTO acd_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","yɛgɛ mɛŋ kya sɔɔ amɔ wɔra mɔmɔ-asen dɔ mɔ. Mɛ dɛ daa fɛɛ nbokyu. Ɔgɛnda ɔko gi kpɛ tu mɔmɔ abɛɛ asa mɛ kpɛ ka mɔmɔ-ansi kyu lii agyɛbi mɔ so mɔ, fɛ laa kerɛ mɔ, mɛ kya luu nyoro. ");
INSERT INTO acd_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ayu abono a tɔrɔ iwe dɔ mɔ a dɛ fɛɛ asa abono mɛ kya nu Wurubuaarɛ agyɛbi, ne gɛsinkpan gɛdɛ so nsuiili de aterenbi gilaarɛ i kya gyi mɔmɔ-amu mɔ. Imɔso mɛŋ baa ma‑a taalɛ wɔra agyɛbi mɔ so ilaa mɔmɔ-gɛkyena dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ayu abono a tɔrɔ gɛsinkpan dɛnsɛ so mɔ berɛ, a dɛ fɛɛ asa abono mɛ nu Wurubuaarɛ agyɛbi mɔ, ne mɛ nu gɛsɛ wɔra amɔ so ilaa mɔmɔ-gɛkyena dɔ fɛɛ gɛnɔɔbono dɔɔbo mɔ gi nyɛ ayu abono ɔnan o kyu ŋmadɛ mɔ, ako gikpadɔ ikue-inun, ako ikue-isa, ne ako mɔ oko de saalaa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a kya ba asa dɔ mɔ i dɛ fɛɛ gikpalɛ gibono nan baa da faa. Dɔɔbo ɔko gi duu awayu mɔ-ndɔɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Imɔ gɛnyɛ asa pɛwu mɛ dɛ mɔ, mɔ-ɔkyobo gi kpaa duu ifɛ wɔra mɔ-awayu mɔ dɔ, ne ɔ naa kyon. ");
INSERT INTO acd_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Awayu mɔ de ifɛ mɔ i kɔrɔ. Owi ɔbono awayu mɔ a boori a kya mada mɔ, ne mɛ wu yɛɛ ifɛ i saarɛ awayu mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Nfono mɔ dɔɔbo mɔ adega mɔ mɛ baa taasɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, iŋ gyɛ awayu ne fo duu fo-ndɔɔ mɔ dɔ? Fonɛ dɔ ne ifɛ idɛ ɔnan i lii?’ ");
INSERT INTO acd_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Ne dɔɔbo mɔ gi lɛɛ gɛnɔ yɛɛ, ‘Ɔkyobo ɔko ne n duu ifɛ mɔ gɛnen.’ Ne mɔ-adega mɔ mɛ taasɛ mɔ yɛɛ, ‘Fo kya laarɛ aꞌ kpaa kyigi ifɛ mɔ de iꞌ san awayu mɔ wolɛ?’ ");
INSERT INTO acd_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ɔ lɛɛ gɛnɔ yɛɛ, ‘Kuaa. Nengyene fɛ laa kyigi ifɛ mɔ mɔ, fɛ laa naa kyigi dabɔlɛ de awayu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Imɔso fɛꞌ yɛgɛ awayu mɔ de ifɛ mɔ pɛwu iꞌ yelɛ dabɔlɛ. I baa fo owi ɔbono a laa gbaa awayu mɔ mɔ, nan tɔgɛ gɛsun awɔrabo mɔ yɛɛ mɛꞌ daa gikɛbi ifɛ mɔ ŋminde imɔ adiila-adiila de mɛꞌ yii imɔ ɔgya pɛi de mɛꞌ lɔɔ gbaa awayu mɔ kyu kpaa gyanꞌ me-gigbaran so.’ ” ");
INSERT INTO acd_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yesu gi kii da gikpalɛ giko sa mɔmɔ yɛɛ, “Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a kya yɛlegɛ asa dɔ mɔ i dɛ daa fɛɛ Maasadɛ giponfɛ ilaa. ");
INSERT INTO acd_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Maasadɛ gibi gi kerɛ faa ŋini-ŋini. Aponfɛ abi pɛwu dɔ mɔ, gimɔ ne mɛŋ kiirɛ. Dɔɔbo gi duu Maasadɛ gibi mɔ-ndɔɔ dɔ mɔ, gi kya kɔrɔ wɔra giponfɛ belɛ baa don giponfɛ kamaasɛ. Gi kya wɔra oyii gbaa, ne nbuii gi kya baa luo asisaa gimɔ-ngyalenbi dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yesu gi kii da asa mɔ gikpalɛ giko yɛɛ, “Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a kya yɛlegɛ asa dɔ mɔ i dɛ daa fɛɛ gɛlin gɛbono mɛ kya kyu wɔra bodobodo ne ɔ kya ŋan dii mɔ. Mɛ kya kyu gɛnen gɛlin gɛbono kyu bagadɛ bodobodo nnyufo fɛɛ imudu isaꞌ dɔ mɔ, gɛ kya yɛlegɛ loo saarɛ nnyufo mɔ pɛwu dɔ de bodobodo mɔ ɔꞌ nyɛ dii.” ");
INSERT INTO acd_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Yesu gi tɔgɛ sa sakpii mɔ gɛnen mɔ, ɔ tɔgɛ imɔ pɛwu daa akpalɛ dɔ. Ɔ mɛŋ tɔgɛ mɔmɔ ilaa iko yɛɛ ɔŋ da gikpalɛ. Ɔ kya tɔngɛ akpalɛ dɔ gɛnen mɔ, ");
INSERT INTO acd_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","i nyɛ kyena de ilaa ibono Wurubuaarɛ ikalan ɔtɔgɛbo ɔko gi wolaa tɔgɛ yela mɔ. Ɔ tɔgɛ yela yɛɛ, “Nan tɔngɛ akpalɛ dɔ sa mɔmɔ. Nan tɔgɛ mɔmɔ asiiri ilaa ibono asa mɛ mɛŋ ti nu imɔ kerɛ gɛkaako mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Yesu gi tɔngɛ ta mɔ, ɔ lɛɛ sakpii mɔ ɔkpa, ne ɔ naa kpaa loo gɛten dɔ. Ɔ loo gɛten dɔ mɔ, mɔ-akasɛbo mɔ mɛ ba mɔ asɛ baa taasɛ mɔ yɛɛ, “Ifɛ mɔ gikpalɛ gibono fo da mɔ gɛsɛ ne n gyɛ yɛɛ menɛ?” ");
INSERT INTO acd_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Dɔɔbo ɔbono o duu awayu mɔ ne n gyɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ndɔɔ mɔ ne n gyɛ gɛsinkpan. Awayu mɔ ne n gyɛ asa abono mɛ kya nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi dɔ mɔ, ne ifɛ mɔ, mɔ, ne n gyɛ asa abono mɛ bo Ɔbonsan, nyamesɛ nyɛnyɛn mɔ gikpen dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ɔkyobo ɔbono, mɔ, ɔ baa duu ifɛ mɔ ne n gyɛ gɛnen Ɔbonsan, ilaa nyɛnyɛn pɛwu gɛmu mɔ. Awayu mɔ gigbaa owi mɔ ne n gyɛ owi ɔbono gɛsinkpan so gɛkyena gɛ laa yela ɔkara mɔ. Adega abono mɛ laa gbaa awayu mɔ ne n gyɛ Wurubuaarɛ dɔ isɔɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Fɛɛ gɛnɔɔbono mɛ laa koola ifɛ de mɛꞌ dɛɛ imɔ mɔ, gɛnen kee ne mɛ laa kyu wɔra asa nyɛnyɛn owi ɔbono gɛsinkpan so gɛkyena gɛ laa yela ɔkara mɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan sun me-isɔɔ yɛɛ mɛꞌ kpe me-adɛ abono n kya gyi gɛwura mɔmɔ so mɔ asɛ. Isɔɔ mɔ mɛ ba mɔ, mɛ laa baa tɔɔsɛ ilaa nyɛnyɛn awɔrabo pɛwu de ilaa ibono pɛwu i kya yɛgɛ me-adɛ mɛꞌ wɔra ilaa nyɛnyɛn mɔ lɛɛ lii me-gɛwuragyi mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Mɛ tɔɔsɛ mɔmɔ lɛɛ gɛnen mɔ, mɛ laa kyu mɔmɔ too wɔra ɔgya gin-gin dɔ. Osulon de anɛbi giwɛ ne n bo nno. ");
INSERT INTO acd_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Gɛnen owi ɔbono dɔ mɔ asa abono mɛ gyi gɛsintin sa Wurubuaarɛ mɔ mɛ laa ŋɛlegi fɛɛ owi mɔmɔ-sɛ Wurubuaarɛ gɛwuragyi gɛkyena mɔ dɔ. Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Gɛnɔɔbono fɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ i dɛ fɛɛ gikpalɛ gibono nan baa da faa. Awuratɔ gbaaꞌ ako a ŋara ndɔɔ nko dɔ, ne ɔnyen ɔko gi kpaa beendi amɔ. I tansi wɔra mɔ ɔkon gikyɔ, ne ɔ lɔrɔ amɔ ŋara, ne ɔ kpaa fɛ ilaa kamaasɛ ibono ɔ bo mɔ, ne o kii kpaa sɔɔ gɛsinkpan gɛbono dɔ awuratɔ mɔ a bo mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Yesu gi da gikpalɛ banban kyu lii Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so yɛɛ, “Ilaa ɔfɛbo ɔko kya laarɛ ngyi boɔgyalonsɛ nko de ɔꞌ sɔɔ. ");
INSERT INTO acd_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","O wu nko nbono gi bo kanpɛ ne gi tansi gi bo ɔgyalon mɔ. O wu nmɔ gɛnen mɔ, ɔ kpaa fɛ ilaa kamaasɛ ibono ɔ bo mɔ ne ɔ kpaa sɔɔ gɛnen ngyi nbono. ");
INSERT INTO acd_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","“Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ gɛ fo mɔ, gɛ laa wɔra fɛɛ gɛnɔɔbono iken akedabo mɛ kya too asɛwu mɔ. Asɛwu mɔ a kya keda iken kpɛi-kpɛi gikyɔ de mɛꞌ biidɛ amɔ‑rɛ iken mɔ lii gyanꞌ gigengen so. Mɛ lɛɛ iken mɔ mɔ, mɛ kya kyɛɛ iken nyɛnyɛn lii idɛnsɛ dɔ. Mɛ kya kyu idɛnsɛ mɔ wɔra nkeebii dɔ, ne mɛ kya kyu inyɛnyɛn mɔ, mɔ, kyu too fuɛ. ");
INSERT INTO acd_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Fafaanan kee ne i laa wɔra owi ɔbono gɛsinkpan so gɛkyena gɛ laa yela ɔkara mɔ ne. Wurubuaarɛ dɔ isɔɔ mɛ laa baa kyɛɛ abono mɛ bo ilaa nyɛnyɛn mɔ lɛɛ lii abono mɛ kya gyi gɛsintin sa Wurubuaarɛ mɔ dɔ ");
INSERT INTO acd_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","de mɛꞌ kyu asa nyɛnyɛn mɔ kpaa too ɔgya gin-gin dɔ. Osulon de anɛbi giwɛ ne n bo nno.” ");
INSERT INTO acd_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yesu gi da akpalɛ adɛ sa mɔmɔ gɛnen mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Fɛ nu ilaa ibono nɛ tɔgɛ fɛye faa pɛwu gɛsɛ?” Mɛ lɛɛ gɛnɔ yɛɛ, “Ɛɛn.” ");
INSERT INTO acd_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nbara ɔŋmarasɛbo kamaasɛ nyi Wurubuaarɛ agyɛbi dedaa ne o kii nyɛ kasɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi ilaa bɔla mɔ, ɔ dɛ fɛɛ gɛten wura ɔbono ɔ bo ilaa dedaa de ilaa pobɔrɔ pɛwu mɔ-ilaa ɔyelaten mɔ. Nengyene i gyɛ ilaa dedaa ilaa mɔ, ɔ bo nno, ne i kii i gyɛ ilaa pobɔrɔ ilaa kee mɔ, ɔ bo nno.” ");
INSERT INTO acd_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Yesu gi da gɛnen akpalɛ adɛ pɛwu ta mɔ, ɔ koso lii nfono ");
INSERT INTO acd_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ne o kii kpe ɔsowolɛ ɔbono so mɛ bela mɔ mɔ. O nyiile asa ilaa mɔmɔ-gikyangbon dɔ. Mɔ-ilaa nyiilesɛ mɔ i dɛ asa mɔ gɛnɔ, ne mɛ san mɛ kya taasɛ abara yɛɛ, “Fonɛ ne ɔdɛ gi kpaa nyɛ gɛnen ɔlaako ginyi gidɛ lii? Nnɛ ne ɔ wɔra ne ɔ nyɛ ɔlon baarɛ ɔ kya wɔra ilaa gbaaꞌgbaa ibono i kya dɛ gɛnɔ faa? ");
INSERT INTO acd_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Iŋ gyɛ kaafenta mɔ-bi mɔ ne? Iŋ gyɛ mɔ-nyi ne n gyɛ Mariya? Ne iŋ gyɛ Gyeemesi, de Gyosɛfo, de Simon de Gyudasɛ mɔmɔ-daa mɔ ne? ");
INSERT INTO acd_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Iŋ gyɛ aye‑rɛ mɔ-pikyiiana ne n tɛ gɛrɛ? Ne fonɛ dɔ ne ɔ nyɛ imɔ idɛ pɛwu lii daa?” ");
INSERT INTO acd_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Yesu mɛŋ gyɛ isafo sa mɔmɔ so mɔ, mɛ kine mɛ mɛŋ sɔɔ mɔ gyi. Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Wurubuaarɛ ikalan ɔtɔgɛbo kya gyi ginsi gɛten kamaasɛ, gɛnen mɔ, mɔ gbaa-gbaa mɔ-gɛwi abɛɛ mɔ-gɛten dɔ wolɛ.” ");
INSERT INTO acd_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Asa mɛ mɛŋ sɔɔ mɔ gyi so mɔ, oŋ kyu Wurubuaarɛ ɔlon wɔra amunale ilaa gbaaꞌgbaa nno gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Gɛnen nkɛ nbono dɔ mɔ, Wura Hɛrodɛ ɔbono ɔ kya kerɛ Galeli gɛsinkpan so mɔ gi nu Yesu ilaa wɔrasɛ so. ");
INSERT INTO acd_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","O nu imɔ gɛnen mɔ, ɔ tɔgɛ sa mɔ-adega yɛɛ, “Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ ne. O kyingi lii ibuni dɔ daa so ne ɔ nyɛ Wurubuaarɛ ɔlon ɔ kya wɔra ilaa gbaaꞌgbaa gɛnen faa.” ");
INSERT INTO acd_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Gɛnɔɔbono i ba ne Gyɔn gi nyɛ lɛwu mɔ ne n gyɛ yɛɛ Wura Hɛrodɛ mɔ-tedɛ Filipo gi dena ɔkyii ɔko, mɛ kya terɛ mɔ yɛɛ Hɛrodiyasɛ, ne wura mɔ gi sɔgɛ ɔkyii mɔ kyu dena. Gyɔn gi nu gɛnen mɔ, ɔ tɔgɛ sa Wura Hɛrodɛ yɛɛ ibono ɔ sɔgɛ mɔ-tedɛ mɔ-ka dena mɔ, iŋ boran, iŋ dɛ ɔkpa gɛnen. Ɔ tɔgɛ mɔ gɛnen mɔ, wura mɔ gi yɛgɛ mɛ kpaa keda mɔ, ne mɛ ŋminde mɔ kyu kpaa tii de obu. ");
INSERT INTO acd_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Nkana wura mɔ gi laarɛ ɔꞌ yɛgɛ mɛꞌ mɔɔ mɔ. O kii ɔ selɛ sakpii mɔ. I kya nyiile yɛɛ sakpii mɔ kya buu Gyɔn yɛɛ ɔ gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo. ");
INSERT INTO acd_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gɛkɛ gɛdɛ mɔ Wura Hɛrodɛ kya gyi mɔ-gɛkɛ korogɛsɛ gɛsi. Mɔ‑rɛ mɔ-nanboana mɛ tɛ mɛ kya gyi gɛkɛ belɛ mɔ mɔ, Hɛrodiyasɛ mɔ-bi obolonbu ɔko gi lii kyaa tala asa mɔ ansi. Mɔ-gɛkyaa mɔ gɛ wɔra Wura Hɛrodɛ ɔbolɛ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Imɔso ɔ ka sa obolonbu mɔ yɛɛ, “Ilaa kamaasɛ ibono fo kya laarɛ mɔ, tɔgɛ me, nan kyu sa fo. Nengyene fo taasɛ me ne meŋ nyɛ sa fo mɔ, nɛ tɔrɔ ntan.” ");
INSERT INTO acd_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Obolonbu mɔ gi lii kpaa taasɛ mɔ-nyi, ne mɔ-nyi gi tɔgɛ mɔ ilaa ibono i kaaborɛ ɔꞌ taasɛ mɔ. Imɔso obolonbu mɔ gi kii baa tɔgɛ wura mɔ yɛɛ, “N kya laarɛ Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ gimu tangalan dɔ fɛye-ansi dɔ gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Obolonbu mɔ gi taasɛ gɛnen mɔ, Wura Hɛrodɛ gisen dɔ i nyida mɔ. Ɔ ti ka ntan abelɛnsɛ mɔ ansi dɔ so mɔ, ɔ kyule ne ɔ tɔgɛ mɔ-adega mɔ yɛɛ mɛꞌ wɔra ilaa ibono obolonbu mɔ kya laarɛ mɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Imɔso o sun ne mɛ kpaa ten Gyɔn gimu nfono o tii de obu mɔ, ");
INSERT INTO acd_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ne mɛ kyu gimɔ taga tangalan dɔ kyu bara obolonbu mɔ, ne obolonbu mɔ gi kyu kperɛ mɔ-nyi. ");
INSERT INTO acd_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Gyɔn akasɛbo mɔ mɛ nu gɛnen mɔ, mɛ kpaa kyu mɔ-gibuni mɔ kyu kpaa pule, ne mɛ kpaa buu sa Yesu. ");
INSERT INTO acd_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Yesu gi nu Gyɔn lɛwu mɔ so mɔ, ɔ dii loo gikolii dɔ ne ɔ lii nfono ɔ bo mɔ de oꞌ kpe nfono asa mɛŋ tɛ mɔ. Asa sakyɔ mɛ nu yɛɛ Yesu gi koso nfono mɔ, mɛ naa de ayaa lii mɔmɔ-isowolɛ so de mɛꞌ kpaa tu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yesu gi fo nfono ɔ kya kpe mɔ, ɔ baa lii gikolii mɔ dɔ mɔ, o wu sakpii belɛ ti ɔ yelɛ. O wu mɔmɔ gɛnen mɔ, mɔmɔ-ilaa i wɔra mɔ ayen, ne ɔ kyɛ-kyɛ abono mɛ kya lɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","I wɔra gɛdɔɔdɛ mɔ, mɔ-akasɛbo mɔ mɛ kpaa tɔgɛ sa mɔ yɛɛ, “Nfono a bo faa, i gyɛ daa ifɛ nsana, ne owi gi ta. Imɔso lɛɛ sakpii mɔ ɔkpa de mɛꞌ naa kpe isowolɛ ibono i sindi gɛrɛ mɔ de mɛꞌ kpaa nyɛ agyudɔ sɔɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “Iŋ tiri yɛɛ mɛꞌ kpe gɛtɛɛko. Fɛye gbaa-gbaa fɛꞌ sa mɔmɔ ilaa iko de mɛꞌ gyi.” ");
INSERT INTO acd_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Mɛ lɛɛ gɛnɔ yɛɛ, “Aye asɛ gɛrɛ a bo daa ibodobodo inun de iken inyɔ.” ");
INSERT INTO acd_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Yesu gi tɔgɛ mɔmɔ yɛɛ, “Fɛꞌ kyu imɔ bara me gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Mɛ kyu kperɛ mɔ, ne Yesu gi tɔgɛ sa sakpii mɔ yɛɛ mɛꞌ kpelegɛ kyena ifɛ bonboli mɔ so. Mɛ kyena mɔ, o puru ibodobodo inun de iken inyɔ mɔ ne ɔ diirɛ mɔ-ansi kerɛ soso, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa gbaa ibodobodo mɔ dɔ kyu sa mɔ-akasɛbo mɔ, ne mɔmɔ, mɔ, mɛ yɛ sa sakpii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ɔkamaasɛ gi gyi kaabo, ne i kii san. Mɔ-akasɛbo mɔ mɛ koola agyisan mɔ mɔ, a bɔla nkeebii gudu nnyɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Anyen abono mɛ saarɛ asa abono mɛ gyi agyudɔ mɔ gɛgyɔnɔ gɛ laa wɔra fɛɛ anyen nwɛ ikue-inyɔ de saalaa. Akyii de nbii-lɛɛ gɛgyɔnɔ gɛŋ too. ");
INSERT INTO acd_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Imɔ gɛmara mɔ, Yesu gi yɛgɛ mɔ-akasɛbo mɔ mɛ dii loo gikolii dɔ de mɛꞌ gyangbara mɔ fara kpe gibenbɛ giko mɔ so de mɔ mɔ ɔꞌ lɛɛ sakpii mɔ ɔkpa de ɔꞌ baa tu mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Yesu gi lɛɛ mɔmɔ-ɔkpa ta ne i san mɔ-wolɛ mɔ, ɔ dii kpe gibii giko so ɔꞌ kpaa dalaa. O sii nno mɔ-wolɛ gɛnen kaaborɛ i bun. ");
INSERT INTO acd_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Gɛnen owi ɔbono mɔ mɔ-akasɛbo mɔ mɛ ti palɛ gikolii mɔ kyon gɛta. Afuu a kya da nkyu mɔ so, ne i yɛgɛ gikolii mɔ gi kya kyengben. Afuu mɔ a kya da a kya ba de mɔmɔ asɛ so. ");
INSERT INTO acd_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","I baa fo gibaadiikɛ mɔ, Yesu naa nkyu mɔ so ɔ kya kpe de mɔ-akasɛbo mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Mɛ wu mɔ ɔ naa nkyu mɔ so ɔ kya ba mɔ, i ŋmaa mɔmɔ-gisen, mɛ kya kpen yɛɛ, “Obuni ne!” Ne i wɔra mɔmɔ gifuu, mɛ san ma‑a saawo. ");
INSERT INTO acd_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ayaa abono so mɔ, Yesu gi tɔgɛ sa ɔmɔ yɛɛ, “Fɛꞌ keda nyoro! Me Yesu ne. Fɛŋ sa fɛꞌ selɛ gifuu.” ");
INSERT INTO acd_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Yesu gi tɔgɛ sa ɔmɔ gɛnen mɔ, Piita gi tɔgɛ sa mɔ yɛɛ, “Me-wura, nengyene i gyɛ fo mɔ, tɔgɛ me kee de nꞌ naa nkyu mɔ so baa tu fo.” ");
INSERT INTO acd_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yesu gi lɛɛ gɛnɔ yɛɛ, “Naa ba.” Nfono mɔ Piita gi lii gikolii mɔ dɔ ɔ naa nkyu mɔ so ɔ kya kpe Yesu asɛ. ");
INSERT INTO acd_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","O wu ibono afuu mɔ a kya da de ɔlon mɔ, i wɔra mɔ gifuu. Gɛnen so mɔ, o yii gɛsɛ ɔ kya muiinɛ ɔ kya loo nkyu mɔ dɔ. Ɔ kya loo mɔ, ɔ saawo yɛɛ, “Me-wura, mɔlɛgɛ me!” ");
INSERT INTO acd_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Ayaa abono so mɔ, Yesu gi tengɛ mɔ-gibaa keda mɔ, ne ɔ taasɛ mɔ yɛɛ, “Kerɛ, gisɔɔgyi gibono fo bo sa me mɔ pɛwu ne? I wonɛ ne fo sɔɔ fo-nyoro akyɔɔlɛ?” ");
INSERT INTO acd_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Yesu mɔ‑rɛ Piita mɛ baa dii loo gikolii mɔ dɔ mɔ, nfono mɔ, afuu mɔ a taa gida yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Mɔ-akasɛbo abono mɛ bo gikolii mɔ dɔ mɔ mɛ ŋmii mɔ kyu buubuu sa mɔ ne mɛ kya tɔgɛ yɛɛ, “Gɛsintin, fo gyɛ Wurubuaarɛ mɔ-bi!” ");
INSERT INTO acd_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mɛ fara ɔbon belɛ mɔ gɛnen mɔ, mɛ lii gikolii mɔ dɔ dii gyanꞌ Gɛnɛsarɛtɛ gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Gɛnɛsaretɛ awura mɛ wu Yesu bii mɔ, mɛ yɛgɛ i nu gyanꞌ gɛnen gɛsinkpan gɛbono so pɛwu yɛɛ Yesu gi loo mɔmɔ asɛ. Mɛ nu gɛnen mɔ, mɛ kyu mɔmɔ-asa abono mɛ kya lɔ mɔ pɛwu bara mɔ. ");
INSERT INTO acd_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mɛ kolɛ mɔ yɛɛ ɔꞌ yɛgɛ mɛꞌ yii ba‑a mɔ-gɛgbɛ ginɛbi. Ne gɛsintin mɔ, ɔkamaasɛ ɔbono ɔ nyɛ ne o yii mɔ-gɛgbɛ mɔ, mɔ-alɔtɔ a kya ta. ");
INSERT INTO acd_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Imɔ idɛ gɛmara mɔ, Farasii gikpen mɔ dɔ asa ako de Gyuda awura nbara aŋmarasɛbo ako mɛ lii Gyɛrusalem ba Yesu asɛ baa taasɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“I wonɛ so ne fo-akasɛbo mɔ mɛ kya kerɛ ansi taa aye-itiibilaa mɔ giwɔra yɛgɛ daa? Imɔ ne n gyɛ yɛɛ mɛ laa gyi mɔ, mɛŋ kya foro mɔmɔ-abaa aye-itiibilaa aforobi de sɛi ɔŋꞌ sa ɔꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson.” ");
INSERT INTO acd_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Ne fɛye mɔ de‑e? I wonɛ so ne fɛye-itiibilaa so mɔ, fɛ kya kerɛ ansi taa Wurubuaarɛ nbara mɔ yɛgɛ daa? ");
INSERT INTO acd_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Wurubuaarɛ gi yela nbara yɛɛ, ‘Buu fo-sɛ de fo-nyi.’ Nko kee ne n gyɛ yɛɛ, ‘Fo ɔbono fo tɔgɛ nnɔ wɔra fo-nyi abɛɛ fo-sɛ mɔ, mɛꞌ mɔɔ fo.’ ");
INSERT INTO acd_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Fɛye Farasii awura de nbara aŋmarasɛbo mɔ berɛ, fɛ kya nyiile daa yɛɛ ɔko laa taalɛ tɔgɛ sa mɔ-nyi abɛɛ mɔ-sɛ yɛɛ, ‘Ilaa ibono n bo ne nkana nan kyu kpaa fɛye mɔ, nan lɔrɔ imɔ yela sa Wurubuaarɛ.’ Nengyene ɔ nyɛ tɔgɛ gɛnen mɔ, fɛye yɛɛ iŋ baa i tiri yɛɛ ɔ baa buu mɔ-sɛ de mɔ-nyi de ɔꞌ kpaa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Fɛye-anyamesɛ itiibilaa idɛ so mɔ, fɛ kya nyaa Wurubuaarɛ nbara mɔ yela nkan. ");
INSERT INTO acd_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Fɛ bo gikerɛansi! Wurubuaarɛ ɔkalan ɔbono Isaya gi nu tɔgɛ mɔ i kyena de fɛye-ilaa wɔrasɛ idɛ gɛsintin so. ");
INSERT INTO acd_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“Isaya gi nu Wurubuaarɛ gi tɔgɛ yɛɛ, ‘Ansi so ne me-asa adɛ mɛ kya lɛɛ me-ginyen; Mɔmɔ-nwɔnsa dɔ berɛ, me‑rɛ ɔmɔ aŋ bo gɛsu. ");
INSERT INTO acd_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mɛ kya son me daa ansi so giyan. I kya nyiile yɛɛ anyamesɛ-lɛɛ nbara ne mɛ dɛ mɛ kya penɛ mɛ kya nyiile asa yɛɛ i gyɛ me Wurubuaarɛ-lɛɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Nfono ne Yesu gi terɛ sakpii ɔbono ɔ bo nfono mɔ ba mɔ asɛ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ yela giso de fɛꞌ nu gɛsɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","i mɛŋ gyɛ ilaa ibono i kya loo nyamesɛ gɛnɔ dɔ mɔ ne n kya kyɔlesɛ mɔ-Wurubuaarɛ ɔson. Ilaa ibono i kya lii nyamesɛ gɛnɔ dɔ mɔ ne n kya kyɔlesɛ mɔ-Wurubuaarɛ ɔson.” ");
INSERT INTO acd_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Nfono mɔ Yesu akasɛbo mɔ mɛ tu sindi mɔ ne mɛ taasɛ mɔ yɛɛ, “Fo bii yɛɛ ilaa ibono fo tɔgɛ mɔ i loo Farasii awura mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Yesu gi lɛɛ gɛnɔ yɛɛ, “Farasii awura ilaa nyiilesɛ mɔ i dɛ fɛɛ iyii ibono i mɛŋ gyɛ me-sɛ ɔbono ɔ bo soso mɔ ne n duu imɔ mɔ. Ɔ laa kyigi imɔ pɛwu fuɛ daa. ");
INSERT INTO acd_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Gɛnen so mɔ, fɛꞌ taa ɔmɔ yɛgɛ! Mɛ gyɛ daa agyaatanbo abono mɛ dɛ mɔmɔ-nanboana agyaatanbo de iyii! Nengyene gyaatanbo laa keda mɔ-nanbo gɛnen mɔ, mɔmɔ anyɔ mɛ laa wolaa tɔrɔ ɔbɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Nfono ne Piita yɛɛ, “Lɛɛ ilaa ibono fo tɔgɛ sa sakpii mɔ gɛsɛ sa aye.” ");
INSERT INTO acd_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Yesu gi lɛɛ gɛnɔ taasɛ mɔ-akasɛbo mɔ yɛɛ, “Imɔso fɛye kee fɛye-nwɔnsa dɔ iŋ ti bugi de fɛꞌ nu ilaa gɛsɛ? ");
INSERT INTO acd_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Fɛ mɛŋ nyi yɛɛ ilaa ibono i kya loo nyamesɛ gɛnɔ dɔ mɔ i kya kyon kpe mɔ-ɔtɔ dɔ de ɔꞌ kɔɔ fuɛ? ");
INSERT INTO acd_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ilaa ibono i kya lii fo-gɛnɔ dɔ mɔ i kya lii daa fo-gɛwɔnsa dɔ. Imɔ ibono ne n kya kyɔlesɛ nyamesɛ Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","I kya nyiile yɛɛ nyamesɛ kya sa gɛwɔnsa pɛi ne ɔ kya wɔra ilaa nyɛnyɛn fɛɛ ɔ kya mɔɔ isa, ɔ kya lii mɔ-ka abɛɛ mɔ-kuli gɛmara, ɔ kya laarɛ ogyibara, ɔ kya yuuri, ɔ kya ten ɔko gɛnɔ nbɛlɛ dɔ, abɛɛ ɔ kya nyida asa. ");
INSERT INTO acd_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Gɛnen ilaa idɛana ne n kya kyɔlesɛ nyamesɛ Wurubuaarɛ ɔson. Nyamesɛ gi gyi ne ɔŋ foro mɔ-abaa aye-itiibilaa aforobi mɔ, imɔ ibono i maŋ taalɛ kyɔlesɛ mɔ-Wurubuaarɛ ɔson.” ");
INSERT INTO acd_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Yesu gi lii nno, ne ɔ kyon kpe gɛsinkpan gɛko so, gɛ sindi Taya de Sidon isowolɛ. ");
INSERT INTO acd_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ɔkyii ɔko tɛ nno, ɔ gyɛ daa Keenakyii. O nu Yesu so. Imɔso ɔ naa ɔ kya kpe mɔ asɛ mɔ, ɔ kya kpen ɔ kya kolɛ mɔ yɛɛ, “Me-wura, Deefidi ɔnaanabi, su me so! Ilaa nyɛnyɛn oduduu tɛ me-bi kyiisɛ so, i kya nyala mɔ gikyɔ!” ");
INSERT INTO acd_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ɔkyii mɔ gi kolɛ Yesu gɛnen mɔ, Yesu mɛŋ tɔgɛ mɔ sɛi-sɛi. Nfono mɔ, mɔ-akasɛbo mɔ mɛ tu ba mɔ asɛ baa tɔgɛ mɔ yɛɛ, “Gya ɔkyii mɔ. O buu aye ɔ kya wɔra ɔlanba.” ");
INSERT INTO acd_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ne Yesu gi lɛɛ gɛnɔ tɔgɛ yɛɛ, “Wurubuaarɛ gi sun me yɛɛ nꞌ baa kpaa daa aye Isirale awura abono mɛ dɛ fɛɛ isandɛ ibono i fuɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ɔ tɔgɛ gɛnen mɔ, ɔkyii mɔ gi dabɔlɛ kpaa ŋmii Yesu ayaa dɔ kolɛ mɔ yɛɛ, “Me-wura, kpaa me!” ");
INSERT INTO acd_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yesu gi tɔgɛ sa mɔ yɛɛ, “Iŋ kaaborɛ fɛɛ ɔko oꞌ kyu nbii agyudɔ abono mɛ laa gyi mɔ kyu too sa igyoono.” ");
INSERT INTO acd_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ne ɔkyii mɔ gi tɔgɛ yɛɛ, “Me-wura, i gyɛ gɛsintin berɛ. Imɔ, mɔ, igyoono gbaa kee mɛ kya nyɛ tɔɔsɛ ibono mɔmɔ-wuraana mɛ kya gyi ne i kya lii tɔrɔ lɛpɛ gikɔɔdɔ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Nfono ne Yesu gi tɔgɛ sa ɔkyii mɔ yɛɛ, “Ɔkyii, gisɔɔgyi gibono fo bo sa me mɔ gi tansi gi nyaakyɔ! Ibono fo kolɛ me mɔ, iꞌ wɔra sa fo.” Gɛnen owi ɔbono dɔ mɔ, mɔ-bi mɔ gi nyɛ mɔ-nyoro lii ilaa nyɛnyɛn oduduu mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Yesu gi lii nno kpaa naa Galeli ɔbon belɛ mɔ gigengen so. Ɔ dii gyanꞌ gibii giko so, ne ɔ kpelegɛ kyena. ");
INSERT INTO acd_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ɔ kpelegɛ kyena mɔ, sakpii belɛ ɔko gi ba mɔ asɛ. Mɛ kyu alɔbo sakyɔ bara mɔ yɛɛ ɔꞌ kyɛ, fɛɛ itɛgɛsɛana, agyaatanbo, isintiribu, asa abono mɛ lii adin, de abono mɛ kya lɔ alɔbi kpɛi-kpɛi mɔ. Mɛ kyu mɔmɔ baa yela Yesu ayaa dɔ, ne ɔ kyɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Sakpii mɔ gi wu ibono agyaatanbo mɛ kya wu ilaa, ɔtɛgɛsɛana mɛ koso mɛ kya naa, abono mɛ lii adin mɔ mɛ kii nyɛ mɔmɔ-nyoro, ne imuumuu mɛ kya tɔngɛ gɛnen mɔ, i dɛ mɔmɔ-gɛnɔ gikyɔ, ne mɛ yen Wurubuaarɛ yɛɛ Wurubuaarɛ ɔbono mɔmɔ Isirale awura mɛ kya son mɔ ne n sa Yesu ɔlon ne ɔ kya kpaa asa gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Imɔ idɛ gɛmara mɔ, Yesu gi terɛ mɔ-akasɛbo mɔ ba mɔ asɛ ne ɔ tɔgɛ sa ɔmɔ yɛɛ, “Asa adɛ ilaa i bo me ayen. Ndɛ nkɛ nsa ne mɛ bo me asɛ faa, mɛŋ baa mɛ bo sɛi de mɛꞌ gyi. Meŋ kya laarɛ nꞌ tɔgɛ mɔmɔ yɛɛ mɛꞌ naa kpe mɔmɔ-nwi yɛgɛ mɛ mɛŋ nyɛ sɛi gyi. Nɛ wɔra gɛnen mɔ, mɛ laa tɔrɔ agbalɛ ɔkpa dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Mɔ-akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Fonɛ dɔ ne a laa nyɛ agyudɔ sa gɛnyamesɛbi gɛdɛ de mɛꞌ gyi kaabo ifɛ nsana gɛrɛ?” ");
INSERT INTO acd_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yesu gi taasɛ mɔmɔ yɛɛ, “Ibodobodo ifonɛ ne fɛ bo?” Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “A bo ibodobodo sono de nkenbii kalɛsɛ nko.” ");
INSERT INTO acd_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Nfono ne Yesu gi tɔgɛ sa asa abono pɛwu mɛ buu ɔmɔ mɔ yɛɛ mɛꞌ kpelegɛ kyena. Mɛ kpelegɛ kyena gɛsinkpan mɔ, ");
INSERT INTO acd_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","o puru ibodobodo sono mɔ de iken mɔ, o kyu afaala kyu sa Wurubuaarɛ, ne ɔ gbaa gbaa imɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ mɛꞌ yɛ sa sakpii mɔ de mɛꞌ gyi. Ne mɛ sɔɔ yɛ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mɛ yɛ gɛnen mɔ, ɔkamaasɛ gi nyɛ gyi kaabo, ne i fo mɔmɔ kii san. Yesu akasɛbo mɔ mɛ koola agyisan mɔ mɔ, i bɔla nkeebii sono. ");
INSERT INTO acd_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Anyen abono mɛ gyi gɛnen agyudɔ abono mɔ gɛgyɔnɔ gɛ gyɛ nwɛ ikue-inyɔ. Akyii de nbii-lɛɛ gɛgyɔnɔ gɛŋ too. ");
INSERT INTO acd_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Asa mɔ mɛ gyi ta mɔ, Yesu gi lɛɛ mɔmɔ-ɔkpa, ne ɔ dii loo gikolii dɔ kyon kpe Magadan gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Farasii de Saadusii akpen mɔ dɔ asa ako mɛ ba Yesu asɛ mɛꞌ baa kolɛ mɔ yɛɛ ɔꞌ wɔra ilaa lɛɛnyiilesɛ lii Wurubuaarɛ dɔ sa mɔmɔ de mɛꞌ nyɛ bii yɛɛ Wurubuaarɛ ne n sa mɔ ɔlon ɔbono ɔ dɛ mɔ. Mɛ kya kolɛ mɔ gɛnen mɔ, mɛ kya daasɛ mɔ mɛ kya kerɛ daa. ");
INSERT INTO acd_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Owi kya kpe ɔꞌ kpaa tɔrɔ ne ɔ pɛɛrɛ kɔ‑ɔ mɔ, fɛ kya wu bii tɔgɛ yɛɛ, ‘Ɔkɛ owi laa lii.’ ");
INSERT INTO acd_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Gɛnen kee ne gɛdɛ gɛ kɛ ne fɛ wu nyangbon gi sin kiti-kiti-kiti mɔ, fɛ kya bii tɔgɛ yɛɛ, ‘Ndɛ nyangbon laa da.’ Fɛ kya wu Wurubuaarɛ awolɛ bii tɔgɛ yɛɛ idɛ ne nan wɔra, ne gɛsintin i kya ba gɛnen. I wonɛ ne fɛŋ kii fa‑a bii kerɛ nkɛ ndɛ dɔ lɛɛ ilaa dɔ de fɛꞌ bii ilaa ibono Wurubuaarɛ kya lɛɛ ɔ kya nyiile fɛye mɔ? ");
INSERT INTO acd_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Fɛye ndɛ asa adɛ! Fɛ bo ilaa nyɛnyɛn ne fɛŋ kya son Wurubuaarɛ gɛsintin ɔkpa so! Gɛnen so ne fɛ kpɛ fɛ kya laarɛ fɛꞌ wu ilaa lɛɛnyiilesɛ faa. Ilaa kolon guan‑n ne Wurubuaarɛ laa wɔra sa fɛye de fɛꞌ wu. Gɛnen ilaa ibono mɔ i laa wɔra daa fɛɛ ibono i ba Gyoona so mɔ.” Yesu gi tɔgɛ gɛnen mɔ, ɔ naa kyon taa mɔmɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kyon kpe gibenbɛ giko mɔ so mɔ, mɔ-akasɛbo mɔ mɛ nyingi yɛɛ mɛ tan bodobodo so. ");
INSERT INTO acd_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yesu gi tɔgɛ sa ɔmɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan. Farasii awura de Saadusii awura ilaa i dɛ fɛɛ gɛlin gɛbono gɛ kya yɛgɛ bodobodo kya ŋan mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Yesu gi tɔgɛ sa mɔmɔ gɛnen mɔ, mɛ kyu mɛ kya taasɛ abara yɛɛ, “Ibono a mɛŋ dɛ bodobodo mɔ so ne ɔ tɔgɛ aye gɛnen faa abɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mɛ kya taasɛ abara gɛnen mɔ, Yesu gi ti bii ilaa ibono mɛ darɛ mɔ. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya tɔgɛ kyu lii bodobodo ɔbono fɛ mɛŋ dɛ mɔ so? Gisɔɔgyi gibono fɛ bo sa me mɔ pɛwu ne? ");
INSERT INTO acd_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Fɛŋ ti bii isa ɔbono n gyɛ mɔ? Fɛ tan ibodobodo inun ibono nɛ gbaa-gbaa imɔ dɔ sa asa nwɛ ikue-inyɔ de saalaa ne mɛ gyi kpon mɔ so? Agyisan nkeebii nfonɛ ne fɛ koola mɔ? ");
INSERT INTO acd_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ne fɛ tan ibodobodo sono ibono nɛ gbaa-gbaa imɔ dɔ sa asa nwɛ ikue-inyɔ ne mɛ gyi kpon mɔ so? Agyisan nkeebii nfonɛ ne fɛ koola mɔ? ");
INSERT INTO acd_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nkana i kaaborɛ fɛ wolaa nu gɛsɛ yɛɛ iŋ gyɛ bodobodo ilaa ne nꞌ darɛ. N kya nyiile fɛye daa yɛɛ fɛꞌ kerɛ fɛye-nyoro so kyu lii Farasii de Saadusii awura mɔ so. Mɔmɔ-ilaa i dɛ fɛɛ gɛlin gɛbono gɛ kya yɛgɛ bodobodo kya ŋan mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Nfono mɔ, mɔ-akasɛbo mɔ mɛ nu gɛsɛ kon yɛɛ iŋ gyɛ bodobodo ilaa ne ɔ darɛ. Ɔ darɛ daa Farasii awura de Saadusii awura mɔ ilaa nyiilesɛ ibono i kya yɛlegɛ i kya nyida ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya laarɛ mɛꞌ sindi Sɛsariya-Filipayi ɔsowolɛ mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Asa asɛ mɔ, menɛ nyamesɛ ɔnan ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n gyɛ daa?” ");
INSERT INTO acd_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ne mɛ lɛɛ gɛnɔ yɛɛ, “Ako mɛ kya tɔgɛ yɛɛ fo gyɛ Oloobu Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ. Ako mɔ yɛɛ kuaa. Fo ne n gyɛ Oloobu Ilaagya. Ne ako, mɔ, yɛɛ Wurubuaarɛ ikalan atɔgɛbo iloobu mɔ dɔ ɔko fɛɛ Gyɛrɛmaya abɛɛ ɔbanban ɔko ne n kyingi lii ibuni dɔ ba gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Nfono ne Yesu gi kii taasɛ mɔ-akasɛbo mɔ yɛɛ, “Ne fɛye mɔ de‑e? Menɛ nyamesɛ ɔnan ne fɛ nyi yɛɛ nꞌ gyɛ?” ");
INSERT INTO acd_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simon Piita gi lɛɛ gɛnɔ yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi sun yɛɛ foꞌ baa mɔlɛgɛ mɔ-adɛ de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ. Mɔ ɔbono ɔ bo nno gɛkpaa-gɛkpaa mɔ mɔ-bi ne n gyɛ fo.” ");
INSERT INTO acd_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Fo Simon, Gyoona mɔ-bi, fo gyɛ omudɛnsɛbo! I mɛŋ gyɛ nyamesɛ ne n lɛɛ ilaa idɛ nyiile fo. Me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ ne n lɛɛ nyiile fo gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Nꞌ buu sa fo yɛɛ nan terɛ fo yɛɛ Piita. (Piita gɛsɛ ne n gyɛ yɛɛ gifolɛ.) Fɛɛ gɛnɔɔbono gifolɛ gi laa taalɛ yɛgɛ obu ɔꞌ wɔra ɔlon mɔ, gɛnen kee ne nengyene nɛ koola me-asonbo gikpen mɔ mɔ, gɛnen gifolɛ gidɛ ne nan wɔra mɔmɔ-gɛkpara. Ba‑a lɛwu gbaa maŋ taalɛ tii me-asonbo gikpen mɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nan yɛgɛ foꞌ kerɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ gɛbunono mɔ so; ilaa ibono fo maŋ sa ɔkpa gɛsinkpan so mɔ, Wurubuaarɛ ɔbono ɔ bo soso mɔ kee maŋ sa ɔkpa, ne ibono fo sa ɔkpa gɛsinkpan so mɔ, Wurubuaarɛ ɔbono ɔ bo soso mɔ kee gi sa ɔkpa.” ");
INSERT INTO acd_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Nfono ne Yesu gi ka sa mɔ-akasɛbo mɔ yɛɛ mɛŋ sa mɛꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ mɔ-adɛ de mɛꞌ nyɛ mɔ asɛ gɛkyena mɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Lii nfono mɔ Yesu gi yii gɛsɛ ɔ kya tɔgɛ ɔ kya sa mɔ-akasɛbo mɔ yɛɛ i gyɛ ilaa ibono i laa ba yɛɛ ɔ laa kpe Gyɛrusalem de ɔꞌ kpaa wu ɔlaawusɛ kpɛi-kpɛi gikyɔ Gyuda awura asunbi alɛɛbo abelɛnsɛ de nbara aŋmarasɛbo mɔ de mɔmɔ-abelɛnsɛ sɛnsɛ mɔ abaa dɔ. Asa mɛ laa mɔɔ mɔ. Mɛ mɔɔ mɔ mɔ, imɔ gɛkɛ sasɛ mɔ, ɔ laa kyingi lii ibuni dɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Nfono mɔ Piita gi kyu Yesu lii nkan ne o yii gɛsɛ ɔ kya gya mɔ yɛɛ ɔŋ baa tɔgɛ gɛnen. Ɔ tɔgɛ mɔ yɛɛ, “Me-wura, Wurubuaarɛ ɔꞌ kparɛ fuɛ! I mɛŋ sa iꞌ ba fo so gɛkaako!” ");
INSERT INTO acd_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Yesu gi kisee tɔgɛ sa Piita yɛɛ, “Naa me asɛ, ilaa nyɛnyɛn gɛmu! Fo kya laarɛ foꞌ nyida me-ilaa sa me. Fo-gɛwɔnsa gɛŋ gyanꞌ Wurubuaarɛ gɛlaarɛ so. Anyamesɛ-lɛɛ gɛlaarɛ so ne fo-gɛwɔnsa gɛ gyanꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ne Yesu gi kisee tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Ɔbono ɔ kya laarɛ de ɔꞌ wɔra me-ɔkasɛbo mɔ, kaasɛ oꞌ kyu mɔ-nyoro fuɛ me so de oꞌ kyule sɔɔ awɔrɔfɔɔ abono a laa tu mɔ me so mɔ abaa anyɔ, ba‑a mɛ laa da mɔ aŋanbi oyii so mɔɔ me so mɔ, mɛꞌ da mɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","I kya nyiile yɛɛ fo ɔbono fo kya kɔrɔsɛ fo-nkpa fo kya yela fo-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena ɔnan gɛ laa lii fo-gibaa. Ne fo ɔbono mɔ, kyu lii me so ne fo-nkpa gi lii fo-gibaa mɔ, fo laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Fo nyamesɛ fo nyɛ gɛsinkpan gɛdɛ so ilaa kamaasɛ pɛwu, ne fo too fo-ɔkyenaten Wurubuaarɛ asɛ mɔ fuɛ mɔ, fo nyi yɛɛ fo nyɛ gɛkyena ne? Menɛ ne fo laa kyu sa Wurubuaarɛ de foꞌ kii nyɛ ɔkyenaten mɔ asɛ? ");
INSERT INTO acd_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Fɛꞌ bii yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kii ba gɛsinkpan so mɔ, me‑rɛ Wurubuaarɛ dɔ isɔɔ ne nan ba. Me-sɛ Wurubuaarɛ nyisigyi ne nan kyu ba. Nɛ kii ba mɔ, nan kyu nyamesɛ kamaasɛ gɛkyena dɔ ilaa wɔrasɛ kyu tɛɛla mɔ. ");
INSERT INTO acd_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fɛye abono fɛ yelɛ gɛrɛnaa faa fɛ maŋ wuꞌ ta pɛi de fɛꞌ lɔɔ wu yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n dɛ me-gɛwuragyi n kya kpelegɛ mii ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Imɔ nkɛ nsee gɛmara mɔ, Yesu gi kyu Piita de Gyeemesi de Gyɔn, Gyeemesi mɔ-tedɛ, ne mɛ dii kpe gibii belɛ giko so mɔmɔ wolɛ. ");
INSERT INTO acd_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mɛ bo nno gɛnen mɔ, Yesu nyoro gi kyɛɛgɛ kii lɔrɔ wɔra ɔdan too, ne mɔ-ansi dɔ i kya ŋɛlegi fɛɛ owi. Mɔ-ngbɛ nbono o suu mɔ gi fuuli gi kya ŋɛlegi faa ŋela-ŋela. ");
INSERT INTO acd_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mɛ baa kii kerɛ mɔ, iloobu inyɔ iko ne: Mosisi mɔ‑rɛ Ilaagya. Mɛ ba Yesu asɛ, mɔmɔ‑rɛ mɔ mɛ yelɛ mɛ kya gyi nsingyi. ");
INSERT INTO acd_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Mɛ yelɛ gɛnen mɔ, Piita gi tɔgɛ sa Yesu yɛɛ, “Me-wura, i wɔra ɔdan yɛɛ a bo gɛrɛnaa. Nengyene fo kya laarɛ mɔ, nan yii ipanpan isaꞌ sa fɛye: fo-lɛɛ ɔko, Mosisi-lɛɛ ɔko, de Ilaagya-lɛɛ ɔko.” ");
INSERT INTO acd_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Piita mɛŋ ti taa tɔgɛ ta mɔ, gibuntɔ ŋɛlegisɛ giko gi baa bun mɔmɔ so faa kpem, ne Wurubuaarɛ gigyɛbiꞌ gi lii gibuntɔ mɔ dɔ tɔgɛ akasɛbo mɔ yɛɛ, “Me-gisen dɔ obi ne n gyɛ Yesu. Ɔ kya gyi me-ginsi. Fɛꞌ nu mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Mɔ-akasɛbo mɔ mɛ nu gigyɛbiꞌ mɔ gɛnen mɔ, i tansi wɔra mɔmɔ gifuu, ne mɛ kpelegɛ dɛ kyu mɔmɔ-ansi bun gɛsinkpan. ");
INSERT INTO acd_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Nfono ne Yesu gi tu kpe mɔmɔ asɛ, ne o yii mɔmɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ koso, fɛŋ sa fɛꞌ selɛ gifuu.” ");
INSERT INTO acd_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Mɛ diirɛ mɔmɔ-ansi kerɛ mɔ, mɛŋ baa wu ɔko baa too de Yesu. ");
INSERT INTO acd_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mɛ kii kpelegɛ mɛ kya ba mɔ, Yesu gi da mɔmɔ tii yɛɛ, “Fɛŋ sa fɛꞌ tɔgɛ ilaa ibono Wurubuaarɛ gi lɛɛ nyiile fɛye faa sa ɔko nperɛ. Me, anyamesɛ pɛwu mɔmɔ-daa mɔ nɛ wuꞌ kii kyingi lii ibuni dɔ mɔ pɛi de fɛꞌ lɔɔ gyi imɔ so gɛsingyi sa asa.” ");
INSERT INTO acd_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Yesu akasɛbo mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Aye Gyuda awura nbara aŋmarasɛbo mɔ mɛ kya kyena tɔgɛ sa aye yɛɛ Oloobu Ilaagya laa kii lii Wurubuaarɛ dɔ ba pɛi ne ɔbono Wurubuaarɛ laa sun de ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ ɔꞌ lɔɔ ba. Ne fo ne n gyɛ gɛnen isa ɔbono mɔ, menɛ n wɔra so ne Ilaagya mɛŋ wolaa gyangbara fo ba?” ");
INSERT INTO acd_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yesu gi tɔgɛ sa ɔmɔ yɛɛ, “I gyɛ gɛsintin yɛɛ i kaaborɛ Ilaagya ɔꞌ gyangbara ba de ɔꞌ baa lɔrɔ ilaa kamaasɛ yela pɛi de nꞌ lɔɔ ba. ");
INSERT INTO acd_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Nꞌ buu sa fɛye yɛɛ Ilaagya gi ti wolaa kii ba ne Gyuda awura mɛ mɛŋ bii mɔ. Mɛ wɔra mɔ gɛnɔɔbono mɛ kya laarɛ mɔ. Gɛnen kee ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan wu awɔrɔfɔɔ mɔmɔ-abaa dɔ ne.” ");
INSERT INTO acd_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ gɛnen mɔ, idɛ kon mɛ bii yɛɛ Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ ne ɔ darɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mɛ kii kpaa tu sakpii mɔ mɔ, ɔnyen ɔko gi ba Yesu asɛ, ne ɔ ŋmii mɔ-ansi dɔ kolɛ mɔ ");
INSERT INTO acd_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","yɛɛ, “Ɔbelɛnsɛ, su me-bi baarɛ so sa me. Ɔ kya lɔ gilɔ tɔrɔsɛ, ɔ kya yiyɛɛ gikyɔ. I kya taalɛ kuu mɔ too ɔgya dɔ, nkɛ nko mɔ, nkyu dɔ. ");
INSERT INTO acd_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nɛ kyu mɔ bara fo-akasɛbo mɔ mɔ, mɛ mɛŋ taalɛ kyɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Yesu gi nu gɛnen mɔ, ɔ tɔgɛ yɛɛ, “O! Fɛye nkɛ ndɛ dɔ asa! Fɛŋ kya sɔɔ Wurubuaarɛ gyi. Fɛ bo gɛnɔbiidɛ! Nkɛ nfonɛ ne nan kyena fɛye asɛ, n kpɛ mi‑i nyɛ gisen mi‑i sa fɛye daa? Fɛꞌ kyu gɛbii mɔ bara me gɛrɛnaa.” ");
INSERT INTO acd_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Nfono mɔ Yesu gi tɔgɛ sa ilaa nyɛnyɛn oduduu ibono i tɛ gɛbii mɔ so ne gɛ kya lɔ gilɔ tɔrɔsɛ mɔ yɛɛ iꞌ koso gɛbii mɔ so ɔ kerɛ imɔ faa. Ayaa abono so mɔ, ilaa nyɛnyɛn oduduu mɔ i koso gɛbii mɔ so, ne gɛbii mɔ gilɔ mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Imɔ gɛmara mɔ, mɔ-akasɛbo mɔ mɛ baa taasɛ Yesu mɔmɔ-wolɛ yɛɛ, “I wonɛ so ne aye berɛ a mɛŋ taalɛ gya ilaa nyɛnyɛn oduduu mɔ koso gɛbii mɔ so daa?” ");
INSERT INTO acd_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Gisɔɔgyi gibono fɛ bo sa Wurubuaarɛ mɔ giŋ fo ilaa iko so daa ne n yɛgɛ ne i ba gɛnen. Gɛsintin ne n kya tɔgɛ fɛye faa, nkana fɛye-gisɔɔgyi mɔ gi dabɔlɛ gi kerɛ pii fɛɛ Maasadɛ giponfɛ gibi gbaa mɔ, fɛ laa taalɛ tɔgɛ sa gɛnen gibii gibono fɛ kya wu faa yɛɛ, ‘Koso gɛrɛ kpe faanaa.’ Gɛsintin mɔ gi laa koso. Sɛi maŋ don fɛye-giwɔra.  ");
INSERT INTO acd_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Imɔ‑rɛ imɔ gɛnen mɔ, pɛi ne fɛ laa taalɛ kosorɛ ilaa nyɛnyɛn oduduu idɛ ɔnan mɔ, i tiri gɛnɔ ŋminde de ndalaa.” ");
INSERT INTO acd_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ naa de Galeli mɔ, Yesu gi tɔgɛ sa ɔmɔ yɛɛ, “Ako mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra asa abaa dɔ ");
INSERT INTO acd_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","de mɛꞌ mɔɔ me. Mɛ mɔɔ me mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” Akasɛbo mɔ mɛ nu gɛnen mɔ, mɔmɔ-asen dɔ i tansi wɔra mɔmɔ ayen gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpe Kapɛɛniyon mɔ, Wurubuaarɛ ɔson obu mɔ too-too asɔɔbo ako mɛ ba Piita asɛ, ne mɛ taasɛ mɔ yɛɛ, “Fɛye-ɔbelɛnsɛ kya too Wurubuaarɛ ɔson obu mɔ too-too ne?” ");
INSERT INTO acd_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Piita gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Ɛn, ɔ kya too.” Piita gi loo gɛten dɔ mɔ, Yesu ne n daa gikyu too-too mɔ ilaa kyu tu mɔ. Ɔ taasɛ Simon Piita yɛɛ, “Simon, fo asɛ mɔ, nengyene wura gi bara gɛsinkpan so too-too sa asafo abɛɛ fɛɛ mɛꞌ dɔɔ de mɛꞌ yɛ ne gɛmɔ so too-too gi ba mɔ, i kaaborɛ nten abi kee mɛꞌ too gɛnen too-too mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Piita gi lɛɛ gɛnɔ yɛɛ, “Kuaa.” Ne Yesu yɛɛ, “I gyɛ gɛsintin. Nten abi mɔ berɛ mɛŋ bo too-too ɔbono dɔ. Imɔso me kee meŋ bo me-sɛ Wurubuaarɛ ɔson obu mɔ too-too mɔ gitoo dɔ. ");
INSERT INTO acd_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Imɔ‑rɛ imɔ gɛnen mɔ, aŋ kya laarɛ aꞌ wɔra too-too asɔɔbo mɔ ginyadon. Imɔso kpe ɔbon mɔ dɔ kpaa too daaruwa. Ɔken ɔbono fo laa daa gilɛɛ mɔ, kerɛ mɔ-gɛnɔ dɔ, fo laa wu aterenbi gibi. Lɛɛ gimɔ de foꞌ kyu kpaa too me‑rɛ fo-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Gɛnen owi ɔbono dɔ mɔ, Yesu akasɛbo mɔ mɛ ba mɔ asɛ baa taasɛ mɔ yɛɛ, “Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ dɔ mɔ, anɛ ne n don mɔ-nanbo?” ");
INSERT INTO acd_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Nfono mɔ Yesu gi terɛ gɛbii gɛko ba mɔ asɛ ne o kyu gɛmɔ yelɛ mɔmɔ-ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ɔ tɔgɛ sa mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, nengyene fɛ maŋ kyɛɛgɛ wɔra fɛye-nyoro fɛɛ nbii mɔ, fɛ maŋ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ kpa‑a. ");
INSERT INTO acd_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Imɔso fo ɔbono fo bara fo-nyoro gɛsɛ wɔra fɛɛ gɛnen gɛbii gɛdɛ mɔ, fo ne nan don fo-nanboana Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Nengyene me so ne fo ɔko fo sɔɔ gɛbii fɛɛ gɛdɛ ɔnan abaa anyɔ mɔ, me ne fo sɔɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ɔbono, mɔ, ɔ laa yɛgɛ apiipii abono mɛ sɔɔ me gyi mɔ dɔ ɔko gisɔɔgyi giꞌ koso me so mɔ, nengyene fɛɛ mɛ kyu gibui belɛ ŋminde kyaga de kaasɛ ɔbono gibɔ ne mɛ too mɔ wɔra apoo dɔ mɔ, i tɛsɛ i bɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Ilaa ibono i kya yɛgɛ asa gisɔɔgyi giꞌ koso me so mɔ i nyaakyɔ gɛsinkpan so, imɔso gɛsinkpan so asa, mɔmɔ laako! I wɔra nnɛ mɔ, gɛnen ilaa ibonoana i laa ba. Ɔbono ɔ laa yɛgɛ iꞌ ba gɛnen mɔ berɛ, mɔ laako! ");
INSERT INTO acd_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Nengyene fo-gibaa abɛɛ fo-giyaa gi kya yɛgɛ fo-gisɔɔgyi giꞌ koso me so mɔ, kɛbi gimɔ fuɛ! I boran yɛɛ fo-nyoro gɛtɛɛko i lii giden de foꞌ nyɛ kyena Wurubuaarɛ asɛ don ibono Wurubuaarɛ laa kyu fo‑rɛ fo-abaa anyɔ de fo-ayaa anyɔ too wɔra ɔgya ɔbono ɔŋ kya wuꞌ gɛkaako mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ne fɛɛ fo-ginsi ne n kya yɛgɛ fo-gisɔɔgyi giꞌ koso me so mɔ, lɔgedɛ gimɔ lɛɛ fuɛ! I boran yɛɛ foꞌ kyu ginsi kolon kpaa kyena Wurubuaarɛ asɛ don ibono Wurubuaarɛ laa kyu fo‑rɛ fo-ansi anyɔ too wɔra ɔgya ɔbono dɔ ɔ kya biidɛ ilaa nyɛnyɛn awɔrabo giso mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de fɛŋ sa fɛꞌ tɔgɛ yɛɛ apiipii adɛ dɔ ɔko mɛŋ gyɛ sɛi. N kya tɔgɛ mi‑i sa fɛye yɛɛ Wurubuaarɛ dɔ isɔɔ ibono mɛ kya kerɛ mɔmɔ so mɔ mɛ kya wu me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ owi kamaasɛ.  ");
INSERT INTO acd_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nɛ ba gɛsinkpan so de nꞌ baa mɔlɛgɛ abono mɛ fuɛ Wurubuaarɛ ɔkpa mɔ de mɔmɔ‑rɛ Wurubuaarɛ nsana iꞌ nyɛ lɔrɔ.” ");
INSERT INTO acd_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nfono mɔ Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nꞌ taasɛ fɛye ilaa iko. Nengyene nyamesɛ bo isandɛ ikue-inun ne ɔkolon gi fuɛ mɔ, ɔ maŋ taa asɛnsɛ mɔ yɛgɛ abii dɔ nfono mɛ kya gyi mɔ de ɔꞌ kpaa laarɛ ɔbono ɔ fuɛ mɔ? ");
INSERT INTO acd_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gɛsintin, ɔ laa laarɛ sandɛ mɔ kpaa wu mɔ. O wu mɔ mɔ, i laa wɔra mɔ ɔkon gikyɔ kyɔde don isandɛ ikue-inan de saalaa isandɛ sango mɔ mɛ san mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Gɛnen kee ne fɛye-sɛ Wurubuaarɛ dɛ ne. Iŋ gyɛ mɔ-gɛlaarɛ yɛɛ apiipii adɛ dɔ ɔko ɔꞌ fuɛ Wurubuaarɛ ɔkpa mɔ de mɔ-ɔkyenaten Wurubuaarɛ asɛ ɔꞌ lii mɔ-gibaa. ");
INSERT INTO acd_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nengyene fo-nanbo ɔbono ɔ sɔɔ me gyi mɔ gi wɔra fo ilaa nyɛnyɛn mɔ, kpe mɔ asɛ de foꞌ kpaa tɔgɛ mɔ ilaa nyɛnyɛn ibono ɔ wɔra fo mɔ fo‑rɛ mɔ wolɛ. Nengyene o nu fo gɛsɛ mɔ, fo‑rɛ mɔ nsana i lɔrɔ ne. ");
INSERT INTO acd_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne fɛɛ ɔ mɛŋ nu fo gɛsɛ mɔ, laarɛ me-sonbo ɔko abɛɛ anyɔ bɔla de fo-nyoro de fɛye pɛwu foꞌ kpe mɔ asɛ. I lii fɛɛ Wurubuaarɛ agyɛbi dɔ mɔ i tɔgɛ yɛɛ pɛi ne fɛ laa bun isa gipuɛɛ yɛɛ ɔ wɔra ilaa nyɛnyɛn mɔ, i kaaborɛ iꞌ nyɛ asa anyɔ abɛɛ asaꞌ abono mɛ kyule yɛɛ ɔ wɔra gɛnen ilaa nyɛnyɛn ibono gɛsintin. ");
INSERT INTO acd_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nengyene ɔ mɛŋ nu mɔmɔ kee gɛsɛ mɔ, kyu gɛnen ilaa ibono kyu kpaa too me-asonbo gikpen mɔ ansi dɔ. Ne fɛɛ ɔ mɛŋ nu me-asonbo gikpen mɔ gɛsɛ kee mɔ, fɛꞌ kyu mɔ fɛɛ ɔ gyɛ daa abono mɛŋ kya son Wurubuaarɛ mɔ dɔ ɔko abɛɛ ilaa nyɛnyɛn awɔrabo mɔ dɔ ɔko. ");
INSERT INTO acd_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, ilaa ibono fɛŋ sa ɔkpa gɛsinkpan so mɔ, Wurubuaarɛ ɔbono ɔ bo soso mɔ kee maŋ sa ɔkpa; ne ibono fɛ sa ɔkpa gɛsinkpan so mɔ, Wurubuaarɛ ɔbono ɔ bo soso mɔ kee gi sa ɔkpa. ");
INSERT INTO acd_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Nꞌ kii tɔgɛ sa fɛye yɛɛ nengyene fɛye dɔ anyamesɛ anyɔ fɛ wɔra gɛnɔ dalaa kolɛ me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ ilaa iko mɔ, ɔ laa wɔra imɔ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Fɛꞌ nu yɛɛ nfono asa anyɔ abɛɛ asaꞌ mɛ gyanꞌ me-ginyen dɔ mɔ, n bo mɔmɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nfono mɔ Piita gi ba Yesu asɛ baa taasɛ mɔ yɛɛ, “Me-wura, gikpadɔ gifonɛ ne fɛɛ me-nanbo gi wɔra me ilaa nyɛnyɛn ne i kaaborɛ nꞌ kyu kyɛɛ mɔ? Gikpadɔ sono abɛ‑ɛ?” ");
INSERT INTO acd_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yesu yɛɛ, “Kuaa, i mɛŋ gyɛ gikpadɔ sono wolɛ. Nꞌ tɔgɛ sa fo yɛɛ ikue-isa de saalaa gɛnen‑n gikpadɔ sono. ");
INSERT INTO acd_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Imɔso fɛꞌ nu. Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a dɛ fɛɛ gikpalɛ gibono nan da faa. Owi ɔko dɔ mɔ, wura ɔko gi kyena. Ɔ bo adega. Gɛkɛ gɛdɛ mɔ, ɔ sa gɛwɔnsa yɛɛ ɔ laa terɛ mɔ-adega mɔ de mɛꞌ baa buu-buu akɔ abono mɛ dɛ mɔ mɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ɔ terɛ mɔmɔ ɔko ɔko. Dega gyangbarasɛ ɔbono ɔ ba mɔ dɛ mɔ gikɔ ibono i tansi i gyɛ gikɔ belɛ. Nengyene fo buu-buu aterenbi mɔ mɔ, fo maŋ bii amɔ-gɛgyɔnɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ɔ taasɛ mɔ mɔ, ɔ mɛŋ nyɛ de ɔꞌ ka. Imɔso wura mɔ yɛɛ mɛꞌ keda mɔ‑rɛ mɔ-ka de mɔ-biana, de mɛꞌ kpaa kyu mɔ-atɔ abono ɔ bo mɔ pɛwu dabɔlɛ kyu kpaa fɛ de mɛꞌ kyu baa ka mɔ gikɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nfono ne dega mɔ gi kpelegɛ ŋmii wura mɔ ansi dɔ kolɛ mɔ yɛɛ, ‘Nyɛ gisen sa me. I wɔra mɔ, nan baa ka fo.’ ");
INSERT INTO acd_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wura mɔ gi nu gɛnen mɔ, i wɔra mɔ ayen, ne o kyu gikɔ mɔ pɛwu kyu kyɛɛ mɔ. Ne ɔ sa mɔ ɔkpa yɛɛ ɔꞌ naa. ");
INSERT INTO acd_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Dega mɔ gi kpɛ lii mɔ-wura mɔ asɛ mɔ, ɔ kpaa gyangara mɔ-nanbo dega ɔko. Mɔ-nanbo ɔbono dɛ mɔ gikɔ kee. Gikɔ gibono ɔ dɛ mɔ mɔ gi laa wɔra fɛɛ aterenbi abono ɔnan gɛsun ɔwɔrabo laa nyɛ ibosɛ isaꞌ dɔ mɔ. Gɛnen gikɔ mɔ so mɔ, ɔ kpɛ wu mɔ mɔ, ɔ too keda mɔ. Ne ɔ ŋmere mɔ-gibɔ dɔ yɛɛ ɔꞌ ka mɔ-gikɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Mɔ-nanbo mɔ, mɔ, gi kpelegɛ ŋmii mɔ-ayaa dɔ kolɛ mɔ yɛɛ, ‘Nyɛ gisen sa me. I wɔra mɔ, nan baa ka fo.’ ");
INSERT INTO acd_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Oŋ kyule, ne ɔ yɛgɛ mɛ keda mɔ kpaa tii de obu. Nengyene ɔꞌ ka gikɔ mɔ mɔ, pɛi de mɛꞌ lɔɔ tigi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Mɔ-nanboana adega mɛ nu gɛnɔɔbono dega mɔ gi kyu wɔra mɔ-nanbo mɔ mɔ, i mɛŋ wɔra mɔmɔ ɔkon, ne mɛ kpaa buu sa mɔmɔ-wura mɔ. ");
INSERT INTO acd_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Wura mɔ gi nu gɛnen mɔ, ɔ yɛgɛ mɛ kpaa terɛ mɔ ba mɔ asɛ. Ɔ kpɛ da de ginsi wu mɔ mɔ, ɔ taasɛ mɔ yɛɛ, ‘Ɔnyen, gɛnen ne fo dɛ ne? Fo dɛ me gikɔ belɛ ne fo kolɛ me mɔ, meŋ kyu kyɛɛ fo? ");
INSERT INTO acd_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Fo mɛŋ nyi yɛɛ i kaaborɛ foꞌ su fo-nanbo so fɛɛ gɛnɔɔbono nɛ su fo so mɔ?’ ");
INSERT INTO acd_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Ilaa ibono dega mɔ gi kyu wɔra mɔ-nanbo mɔ i kyu wura mɔ ginyadon gikyɔ. Imɔso ɔ yɛgɛ mɛ keda mɔ kpaa tii de obu de mɛꞌ kii biidɛ mɔ-giso bɔla kpaa fo owi ɔbono ɔkara ɔ laa ka gikɔ mɔ pɛwu mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yesu gi lɛɛ gikpalɛ mɔ gɛsɛ yɛɛ, “Gɛnen kee ne Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a dɛ ne. Fo ɔbono fo-nanbo laa wɔra fo ilaa nyɛnyɛn ne fo maŋ kyu kyɛɛ mɔ lii fo-gisen dɔ mɔ, me-sɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ laa wɔra fo fɛɛ gɛnɔɔbono wura mɔ gi wɔra mɔ-dega ɔbono oŋ su mɔ-nanbo so mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Yesu gi tɔgɛ ilaa idɛ ta mɔ, ɔ lii Galeli nfono kyon kpe ɔbon Gyɔɔdan gibenbɛ giko so Gyudiya gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Sakpii belɛ gi buu mɔ. Mɛ loo nno mɔ, ɔ kyɛ kyɛ abono mɛ kya lɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Farasii gikpen dɔ awura ako mɛ ba mɔ asɛ de mɛꞌ baa soo mɔ idoo kerɛ. Gɛnen so mɔ mɛ taasɛ mɔ yɛɛ, “Imɔso aye-nbara gi kya nyiile yɛɛ nyamesɛ laa taalɛ yelɛ ilaa kamaasɛ ibono ɔ kya laarɛ mɔ so kine mɔ-ka?” ");
INSERT INTO acd_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Yesu gi lɛɛ gɛnɔ taasɛ ɔmɔ yɛɛ, “Fɛ mɛŋ ti kalɛ Wurubuaarɛ agyɛbi kyu lii imɔ so do‑o? Mɔ-agyɛbi mɔ a kya nyiile yɛɛ lii ko‑o gɛsɛ de gɛsɛ mɔ, Wurubuaarɛ gi lɛɛ ɔnyen oyuduu de ɔkyii oyuduu. ");
INSERT INTO acd_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Wurubuaarɛ gi tɔgɛ nfono yɛɛ, ‘Imɔ idɛ so mɔ, ɔnyen laa taa mɔ-sɛ de mɔ-nyi yɛgɛ de oꞌ kyu mɔ-nyoro mada de mɔ-ka de mɔmɔ asa anyɔ mɛꞌ bingiri nyamesɛ kolon.’ ");
INSERT INTO acd_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Imɔso ɔnyen mɔ‑rɛ mɔ-ka mɛŋ baa mɛ gyɛ asa anyɔ, mɛ bingiri nyamesɛ kolon. Ibono Wurubuaarɛ ne n kyu mɔmɔ dabɔlɛ wɔra nyamesɛ kolon faa mɔ, ɔko ɔŋ sa ɔꞌ baragɛ mɔmɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farasii awura mɔ mɛ kii taasɛ Yesu yɛɛ, “Gɛnen berɛ mɔ, menɛ ne n wɔra so ne Mosisi gi yela nbara yɛɛ nengyene ɔnyen laa kine mɔ-ka mɔ, ɔꞌ sa mɔ gikine ɔwolɛ de ɔꞌ lɛɛ mɔ-ɔkpa mɔ daa?” ");
INSERT INTO acd_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛye-aso dɔ i kɔrɔ ifuu so daa ne Mosisi gi sa fɛye ɔkpa de fɛꞌ kine fɛye-kaana gɛnen. Nkana lii gɛsɛ de gɛsɛ mɔ, i mɛŋ dɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nꞌ buu sa fɛye yɛɛ nengyene i mɛŋ gyɛ yɛɛ fo-ka gi lii fo-gɛmara so ne fo kine mɔ kpaa kyu ɔkyii pobɔrɔ mɔ, fo tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara. Ɔ kya kyu imɔ yɛɛ ɔko mɔ-ka ne fo laarɛ gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Yesu gi tɔgɛ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Nengyene fafaanan ne gɛdena ilaa i dɛ berɛ mɔ, nyamesɛ maŋ tɛsɛ dena mɔ, nkana i boran.” ");
INSERT INTO acd_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Gimaadena mɔ iŋ gyɛ nyamesɛ kamaasɛ ne nan taalɛ kyena, gɛnen mɔ, abono Wurubuaarɛ gi kyu sa mɔmɔ mɔ wolɛ. ");
INSERT INTO acd_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","I kya nyiile yɛɛ i bo ilaa kpɛi-kpɛi ibono so anyen ako mɛŋ kya dena mɔ. Ako berɛ, i korogɛ ɔmɔ de gɛnen daa. Ako mɔ, mɔ, mɔmɔ-nanboana anyamesɛ ne n kya keda mɔmɔ lɛɛ awɔrɛbi. Ako, mɔ, mɛŋ kya dena mɔ, mɛ kya laarɛ mɛꞌ nyɛ nyoro kpaa asa de mɛꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. Ɔbono ɔ laa taalɛ wɔra gɛnen mɔ, ɔꞌ wɔra.” ");
INSERT INTO acd_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Owi ɔko dɔ mɔ, asa ako mɛ dɛ nbii ma‑a bara Yesu yɛɛ oꞌ kyu mɔ-abaa gyanꞌ mɔmɔ so de ɔꞌ dalaa sa mɔmɔ. Mɔ-akasɛbo mɔ, mɔ, mɛ kya gya mɔmɔ yɛɛ mɛꞌ kiiri nbii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Yesu gi wu gɛnen mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ yɛgɛ nbii mɔ mɛꞌ ba me asɛ; fɛŋꞌ baa tii mɔmɔ-ɔkpa. Abono mɛ dɛ fɛɛ gɛnen nbii ndɛana ɔnan mɔ ne nan nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ne o kyu mɔ-abaa gyanꞌ nbii mɔ so, ne ɔ naa lii nno kyon. ");
INSERT INTO acd_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Owi ɔko dɔ mɔ, ɔnyen ɔko gi ba Yesu asɛ baa taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, menɛ ilaa dɛnsɛ ne nan wɔra de nꞌ nyɛ Wurubuaarɛ asɛ gɛkyena gɛkpaa?” ");
INSERT INTO acd_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Yesu gi kisee taasɛ mɔ yɛɛ, “Fo kya taasɛ me kyu lii ilaa dɛnsɛ so faa mɔ, fo mɛŋ nyi yɛɛ Wurubuaarɛ wolɛ ne n gyɛ nyamesɛ dɛnsɛ? Nengyene fo kya laarɛ foꞌ nyɛ ɔkyenaten Wurubuaarɛ asɛ mɔ, gyi mɔ-nbara mɔ so.” ");
INSERT INTO acd_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ne ɔnyen mɔ gi taasɛ Yesu yɛɛ, “Nbara nmɔ?” Yesu gi lɛɛ gɛnɔ yɛɛ, “Gɛŋ sa foꞌ mɔɔ isa, gɛŋꞌ lii fo-ka abɛɛ fo-kuli gɛmara, gɛŋꞌ yuuri, gɛŋꞌ ten ɔko gɛnɔ nbɛlɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Buu fo-sɛ de fo-nyi de foꞌ laarɛ fo-nanbo fɛɛ fo-nyoro.” ");
INSERT INTO acd_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ɔnyen mɔ gi lɛɛ gɛnɔ sa Yesu yɛɛ, “N ti n kya gyi gɛnen nbara ndɛ pɛwu so. Menɛ ne n kii san me?” ");
INSERT INTO acd_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yesu gi tɔgɛ sa mɔ yɛɛ, “Nengyene fo kya laarɛ fo ta gudu berɛ mɔ, naa kpaa fɛ fo-ilaa ibono fo bo mɔ pɛwu de foꞌ kyu aterenbi mɔ kyu yɛ sa ayenbo. Fo wɔra gɛnen mɔ, fo laa nyɛ ntɛɛla Wurubuaarɛ dɔ, de foꞌ san naa baa buu me wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Ɔnyen mɔ gi nu gɛnen mɔ, mɔ-gisen dɔ i nyida mɔ, ne ɔ naa kyon. I kya nyiile yɛɛ ɔ tansi ɔ bo atɔ gikyɔ. Ɔ kerɛ mɔ, ɔ maŋ taalɛ wɔra gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Nfono mɔ Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Nꞌ tɔgɛ fɛye gɛsintin yɛɛ i tansi i bo lon sa aterenbi awura de mɛꞌ nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi dɔ. ");
INSERT INTO acd_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nꞌ kii tɔgɛ sa fɛye yɛɛ pɛi de aterenbi wura ɔꞌ nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi dɔ mɔ, i laa wɔra ɔlon sa mɔ don gɛnɔɔbono gɛkpatitii gɛ laa loo ɔbaatɔ ɔbɔ dɔ lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Yesu akasɛbo mɔ mɛ nu imɔ idɛ mɔ, i tansi dɛ ɔmɔ-gɛnɔ, ne mɛ san taasɛ yɛɛ, “Gɛnen berɛ mɔ, anɛ kaasɛ ne nan nyɛ Wurubuaarɛ asɛ gɛkyena ne?” ");
INSERT INTO acd_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Yesu gi kerɛ mɔmɔ faa yiridididi ne ɔ lɛɛ gɛnɔ yɛɛ, “Imɔ idɛ i don nyamesɛ giwɔra; Wurubuaarɛ berɛ, sɛi mɛŋ fo mɔ-giwɔra.” ");
INSERT INTO acd_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Nfono mɔ Piita gi taasɛ mɔ yɛɛ, “Aye, mɔ, ibono a taa gɛsinkpan so ilaa kamaasɛ yɛgɛ ne a naa a buu fo faa mɔ, nnɛ ne?” ");
INSERT INTO acd_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, gɛkaako mɔ, Wurubuaarɛ laa lɛɛ gɛkyena pobɔrɔ. Gɛnen aberɛ abono mɔ, me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kyena me-nyisigyi gɛgyapaa so n kya gyi gɛwura. Fɛye abono, mɔ, fɛ gyɛ me-akasɛbo gudu anyɔ mɔ kee fɛ laa kyena ngyapaa so fɛ kya gyi gɛwura Isirale nten gudu nnyɔ mɔ so fɛ kya gyi mɔmɔ-nbɛlɛ fa‑a sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne nyamesɛ kamaasɛ ɔbono ɔ taa mɔ-gɛten yɛgɛ abɛɛ mɔ-sɛ, abɛɛ mɔ-nyi, abɛɛ mɔ-daana, abɛɛ mɔ-tedɛana, abɛɛ mɔ-pikyiiana, abɛɛ mɔ-biana abɛɛ mɔ-nsinkpan yɛgɛ me so mɔ, kaasɛ laa nyɛ imɔ-ɔnan gikpadɔ ikue-inun de oꞌ kii nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ne Yesu gi kii tɔgɛ yɛɛ, “Gɛnen gɛkyena pobɔrɔ gɛbono dɔ mɔ abono mɛ gyɛ abelɛnsɛ gɛsinkpan so ilaa dɔ mɔ ako mɛ laa kpaa bingiri nbii, ne abono mɛ gyɛ nbii gɛsɛ gɛrɛ ilaa dɔ mɔ ako, mɔ, mɛ laa kpaa wɔra abelɛnsɛ.” ");
INSERT INTO acd_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Yesu gi tɔgɛ yɛɛ, “Gɛnɔɔbono asa mɛ laa nyɛ ntɛɛla Wurubuaarɛ gɛwuragyi mɔ dɔ mɔ i laa wɔra fɛɛ gikpalɛ gibono nan baa da faa. Gɛten wura ɔko ne n kyena. Ɔ bo gifɔlɛ giko ndɔɔ. Gɛkɛ gɛdɛ mɔ, o kyingi nyɛnyɛngɛ fu‑u kpaa laarɛ gɛsun awɔrabo de mɛꞌ kpaa wɔra gɛsun mɔ-ndɔɔ dɔ sa mɔ de ɔꞌ ka ɔmɔ gikɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mɔ‑rɛ gɛsun awɔrabo mɔ mɛ gyi gigya, ne o kyule yɛɛ ɔ laa ka ɔmɔ gɛnɔɔbono mɛ kya ka gɛkɛ toloowi-lɛɛ gikɔ mɔ, ne ɔ yɛgɛ mɛ kyon ndɔɔ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Owi gi dii mɔ, o kpe oyiidɔ, ne ɔ kpaa wu anyen banban ako mɛ tɛ mɛŋ kya wɔra sɛi. ");
INSERT INTO acd_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","O wu mɔmɔ gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, ‘Fɛye kee fɛꞌ baa kyon kpaa wɔra gɛsun sa me me-ndɔɔ dɔ de nꞌ ka fɛye gikɔ gɛnɔɔbono i laa kyena sa me‑rɛ fɛye mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Gɛsintin mɔ, asa mɔ mɛ kpe. Owi gi kyena nten nsana mɔ, o kii kpaa nyɛ ako ne mɛ kpe. Owi gi gbaa mɔ, o kii kpaa nyɛ abanban, ne mɛ kpe. ");
INSERT INTO acd_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","I san ŋmaraa de owi ɔꞌ tɔrɔ mɔ, o kii kpe oyiidɔ kpaa wu anyen ako mɛ tɛ giyan mɛŋ kya wɔra sɛi. Ne ɔ taasɛ ɔmɔ yɛɛ, ‘Menɛ n wɔra ne fɛ kya waala gɛkɛ mumuli, fɛ mɛŋ kya wɔra sɛi?’ ");
INSERT INTO acd_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, ‘A mɛŋ nyɛ ɔko de ɔꞌ baa sa aye gɛsun de aꞌ wɔra de ɔꞌ ka aye gikɔ.’ Ne ndɔɔ wura mɔ yɛɛ, ‘To, fɛye kee fɛꞌ kii baa kyon kpe me-ndɔɔ dɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Owi gi ta mɔ, ndɔɔ wura mɔ gi tɔgɛ ɔbono ɔ kya kerɛ mɔ-ndɔɔ mɔ so ɔ kya sa mɔ mɔ yɛɛ, ‘Terɛ gɛsun awɔrabo mɔ de foꞌ ka mɔmɔ gikɔ. Ka lii abono mɛ ba gɛmara gɛmara mɔ, de foꞌ kyu kpaa logɛ de abono mɛ daa gikpe ndɔɔ mɔ dɔ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ɔ ka abono mɛ kpe ndɔɔ mɔ dɔ owi kya laarɛ ɔꞌ tɔrɔ mɔ, mɔmɔ ɔkamaasɛ gi nyɛ aterenbi abono mɛ kya ka gɛkɛ toloowi gikɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","I tu abono mɛ daa gikpe ndɔɔ mɔ dɔ mɔ, mɛ nyi yɛɛ mɔmɔ berɛ mɛ laa nyɛ aterenbi don abono mɛŋ kpe belen mɔ. Imɔ gɛnen mɔ, mɔmɔ kee mɛ nyɛ daa gɛnɔɔbono mɛ kya ka gɛkɛ toloowi-lɛɛ gikɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mɛ sɔɔ mɔmɔ-aterenbi kalɛ mɔ, mɛ yii gɛsɛ mɛ kya lɔgedɛ de ndɔɔ wura mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Asa abono mɛ ba gɛmara gɛmara mɔ mɛŋ wɔra gɛsun kɛɛla iko. Aye, mɔ, a yelɛ owi kɛlɛlɛ so wɔra gɛsun toloowi mɔ, fo kya ka aye‑rɛ ɔmɔ pɛwu gikɔ kyɛɛ-kyɛɛ?’ ");
INSERT INTO acd_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ndɔɔ wura mɔ gi lɛɛ gɛnɔ sa mɔmɔ dɔ ɔko yɛɛ, ‘Ɔnyen, meŋ kudi fo gyi. Me‑rɛ fo aŋ tɔgɛ kyule daa yɛɛ gɛkɛ gikɔ ne nan ka fo? ");
INSERT INTO acd_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Imɔso kyu fo-aterenbi de foꞌ naa fo kya kpe. N kya laarɛ de nꞌ ka ɔkamaasɛ ɔbono nɛ nyɛ gɛmara gɛmara mɔ kee gikɔ fɛɛ fo-lɛɛ mɔ ɔnan. ");
INSERT INTO acd_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Meŋ bo ɔkpa de nꞌ kyu me-aterenbi kyu wɔra ilaa ibono n kya laarɛ mɔ? Abɛɛ fo wu me-gidɛnsɛ gibono nɛ wɔra mɔ, i kya loo fo daa?’ ” ");
INSERT INTO acd_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yesu gi da gikpalɛ gidɛ ta mɔ, ɔ lɛɛ gɛsɛ yɛɛ, “Gɛnen ne i laa wɔra ne. Owi ɔbono asa mɛ laa nyɛ ntɛɛla Wurubuaarɛ gɛwuragyi mɔ dɔ mɔ, abono mɛ gyɛ nbii gɛsinkpan so ilaa dɔ mɔ ako mɛ laa kpaa wɔra abelɛnsɛ, ne abono mɛ gyɛ abelɛnsɛ gɛsɛ gɛrɛ ilaa dɔ mɔ ako, mɔ, mɛ laa kpaa bingiri nbii.” ");
INSERT INTO acd_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Yesu kya kpe Gyɛrusalem mɔ, o kyu mɔ-akasɛbo gudu anyɔ mɔ lii nkan ne ɔ tɔgɛ sa ɔmɔ ");
INSERT INTO acd_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","yɛɛ, “Fɛꞌ nu. A kya kpe Gyɛrusalem faa, ako mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra aye Gyuda awura asunbi alɛɛbo abelɛnsɛ de aye-nbara aŋmarasɛbo abaa dɔ. Mɔmɔ, mɔ, mɛ laa tɔgɛ yɛɛ n gyɛ ilaa nyɛnyɛn ɔwɔrabo, imɔso nꞌ wɔra ɔmɔɔsɛ, ");
INSERT INTO acd_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","de mɔmɔ kee mɛꞌ kyu me wɔra asa abono mɛ mɛŋ gyɛ aye Gyuda awura mɔ abaa dɔ. Gɛnen asa abono mɛ laa gyaabii me ikpa kpɛi-kpɛi so, de mɛꞌ taa me awulibi, de mɛꞌ da me aŋanbi oyii so mɔɔ. Nɛ wuꞌ mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Imɔ gɛmara mɔ Yesu akasɛbo ako mɔmɔ-nyi gi kyu mɔmɔ ba mɔ asɛ baa kolɛ mɔ ilaa iko. Akasɛbo mɔ mɛ gyɛ Sɛbedi mɔ-biana. Ɔkyii mɔ gi baa ŋmii mɔ-ayaa dɔ ");
INSERT INTO acd_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ne Yesu gi taasɛ mɔ yɛɛ, “Menɛ ne fo kya laarɛ?” Ɔ lɛɛ gɛnɔ yɛɛ, “Owi ɔbono fo laa gyi gɛwura mɔ, yɛgɛ me-biana anyɔ adɛ mɛꞌ wɔra fo-nwurabi nbono mɛ laa sindi fo titiritii, ɔko ɔꞌ kyena fo-gibaa gyisɛ so de ɔko, mɔ, ɔꞌ kyena fo-benɛ so.” ");
INSERT INTO acd_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yesu gi lɛɛ gɛnɔ tɔgɛ sa mɔ-akasɛbo anyɔ mɔ yɛɛ, “Fɛ mɛŋ nyi ilaa ibono fɛ kya kolɛ faa. Imɔso fɛ laa taalɛ wu ɔlaawusɛ ɔbono ɔnan ɔ dɛ ɔ gyoo me mɔ?” Mɛ kyule mɔ yɛɛ, “Ɛn, a laa taalɛ.” ");
INSERT INTO acd_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Nfono mɔ, Yesu gi tɔgɛ sa ɔmɔ yɛɛ, “Gɛsintin mɔ, fɛ laa wu ɔlaawusɛ ɔbono ɔnan nan wu mɔ. Me asɛ ikyenaten mɔ berɛ, meŋ bo ɔkpa de nꞌ lɛɛ yɛɛ ɔdɛ ne ɔꞌ kyena me-gibaa gyisɛ so abɛɛ ɔdɛ ne ɔꞌ kyena me-benɛ so. Gɛnen ikyenaten ibono i gyɛ sa daa abono me-sɛ Wurubuaarɛ gi wolaa lɔrɔ yela sa mɔmɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Yesu akasɛbo sɛnsɛ gudu mɔ mɛ nu ilaa ibono mɔmɔ-nanboana anyɔ, nyamesɛ mɔ‑rɛ mɔ-tedɛ mɔ, mɛ kpaa kolɛ Yesu mɔ, i loo ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Imɔso Yesu gi terɛ mɔmɔ pɛwu baa mɔ asɛ ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛɛ gɛnɔɔbono fɛ nyi mɔ, abono mɛ mɛŋ nyi Wurubuaarɛ agyɛbi mɔ mɔmɔ-awura awura mɛ kya kyu abono mɛ bo mɔmɔ gɛsɛ mɔ kyu wɔra fɛɛ mɔmɔ-nbide. Mɔmɔ-anyamesɛ gbaaꞌgbaa mɔ kee mɛ kya kyu ɔlon mɛ kya gyi gɛbelɛnsɛ asa sɛnsɛ so. ");
INSERT INTO acd_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Fɛye-lɛɛ berɛ, iŋ kaaborɛ iꞌ wɔra fɛɛ asa adɛ. Nengyene ɔko kya laarɛ ɔꞌ wɔra nyamesɛ gbaaꞌ fɛye dɔ mɔ, i kaaborɛ ɔꞌ wɔra mɔ-nyoro fɛɛ fɛye-dega, ");
INSERT INTO acd_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ne ɔbono ɔ kya laarɛ ɔꞌ wɔra fɛye-wura mɔ, i kaaborɛ ɔꞌ wɔra mɔ-nyoro fɛɛ fɛye-gɛbide. ");
INSERT INTO acd_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","I lii fɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ gbaa, meŋ ba gɛsinkpan so yɛɛ asa mɛꞌ son me. Nɛ ba daa de nꞌ baa son asa de nꞌ kyu me-nkpa kyɛɛ de iꞌ lɛɛ asa sakyɔ lii ilaa nyɛnyɛn giwɔra dɔ kiiri mɔmɔ sa Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya lii Gyɛriko ɔsowolɛ so mɔ, sakpii belɛ ɔko buu mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Mɛ kya kpe mɔ, agyaatanbo anyɔ ako ne n tɛ ɔkpa nkan. Mɛ kpɛ nu yɛɛ Yesu ne n kya kyon faa mɔ, mɛ yii gɛsɛ mɛ kya kpen ken-ken yɛɛ, “Aye-wura, Wura Deefidi ɔnaanabi, su aye so!” ");
INSERT INTO acd_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Sakpii ɔbono o buu Yesu mɔ gi gya ɔmɔ yɛɛ mɛꞌ bun ɔmɔ-nnɔ so. Mɛ kya gya mɔmɔ gɛnen mɔ, idɛ kon gbaa ne mɛ lɔrɔ mɛ kya kpen ken-ken yɛɛ, “Aye-wura, Wura Deefidi ɔnaanabi, su aye so!” ");
INSERT INTO acd_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Nfono mɔ Yesu gi sii yelɛ ne ɔ terɛ mɔmɔ ne ɔ taasɛ mɔmɔ yɛɛ, “Menɛ ne fɛ kya laarɛ nꞌ wɔra sa fɛye?” ");
INSERT INTO acd_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Mɛ lɛɛ gɛnɔ yɛɛ, “Aye-wura, a kya laarɛ aye-ansi aꞌ bugi.” ");
INSERT INTO acd_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mɔmɔ-ilaa i wɔra Yesu ayen ne o kyu mɔ-abaa yii mɔmɔ-ansi mɔ. Ayaa abono so mɔ, mɔmɔ-ansi a bugi mɛ kya wu ilaa kamaasɛ, ne mɛ san naa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya fuude Gyɛrusalem mɔ, mɛ kpaa fo Bɛtɛfagye ɔsowolɛ ɔbono ɔ gyanꞌ Nfɔ Iyii Gibii Mɔ so mɔ. Mɛ fo nno mɔ, Yesu gi sun mɔ-akasɛbo mɔ dɔ anyɔ ");
INSERT INTO acd_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","yɛɛ, “Fɛꞌ kpe ɔsowolɛ ɔbono ɔ bo aye-ansi dɔ faa. Fɛ kpɛ fɛ kya loo ɔsowolɛ mɔ so mɔ, fɛ laa wu bee kyiisɛ kyaa de ɔfɛ, mɔ-bi yelɛ mɔ asɛ. Fɛꞌ sangɛ mɔ de fɛꞌ kyu mɔ‑rɛ mɔ-bi mɔ bara me. ");
INSERT INTO acd_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ne fɛɛ ɔko gi taasɛ fɛye ilaa iko mɔ, fɛꞌ tɔgɛ mɔ yɛɛ, ‘Wura mɔ yɛɛ ɔ tiri abee mɔ.’ Fɛ tɔgɛ gɛnen mɔ, mɛ laa yɛgɛ de fɛꞌ kyu abee mɔ ba ayaa adɛ so.” ");
INSERT INTO acd_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Gɛnɔɔbono Yesu laa gyanꞌ bee so loo Gyɛrusalem mɔ, i laa yɛgɛ ilaa ibono Wurubuaarɛ gi tɔgɛ naa de mɔ-ikalan ɔtɔgɛbo ɔko so mɔ iꞌ nyɛ ba gɛsintin. Ɔ wolaa tɔgɛ Gyɛrusalem ilaa yela. (Gyɛrusalem ginyen giko ne n gyɛ Sayon.) Ɔ tɔgɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Fɛꞌ tɔgɛ sa Sayon awura yɛɛ, ‘Fɛꞌ kerɛ fɛye-wura kya ba fɛye asɛ. Ɔ bara mɔ-nyoro gɛsɛ; ɔ gyanꞌ bee so. Mɔ-bee ɔbono gyɛ daa bee fɔlɛ; ɔ mɛŋ ti sɛɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Yesu akasɛbo mɔ mɛ kpe kpaa wɔra fɛɛ gɛnɔɔbono ɔ tɔgɛ mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mɛ kyu bee mɔ mɔ‑rɛ mɔ-bi mɔ bara mɔ, ne mɛ kyu mɔmɔ-akuru too bun abee mɔ so, ne ɔ dii gyanꞌ. ");
INSERT INTO acd_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Sakpii mɔ dɔ ako mɛ kyu mɔmɔ-akuru too mɔ-ɔkpa dɔ, ne ako mɛ ŋɛ iyii afɛdaa mɛ kya too de ɔkpa yɛɛ ɔꞌ baa naa. ");
INSERT INTO acd_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Asa abono mɛ gyangbara Yesu de abono mɛ buu mɔ-gɛmara mɔ pɛwu mɛ kya kpen yɛɛ, “Ayenbi a gyɛ fo-lɛɛ, Wura Deefidi ɔnaanabi! Wurubuaarɛ ɔꞌ kosorɛ fo-gimu! Wurubuaarɛ ginyen dɔ ne fo naa fo kya ba faa! Ayenbi aꞌ wɔra Wurubuaarɛ ɔbono ɔ bo soso-soso mɔ-lɛɛ!” ");
INSERT INTO acd_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Yesu gi loo Gyɛrusalem mɔ, ɔsowolɛ mɔ gi gyigisi. Nno asa mɔ mɛ san mɛ kya taasɛ yɛɛ, “Anɛ ne n ba daa?” ");
INSERT INTO acd_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Sakpii mɔ mɔ‑rɛ Yesu mɛ naa mɔ mɛ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Yesu, Wurubuaarɛ ikalan ɔtɔgɛbo mɔ ne n ba. Ɔ lii Nasarɛtɛ ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Yesu gi loo Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so, ne ɔ gya abono mɛ kya gyi gigya nno mɔ. Ɔ da abono mɛ kya boori aterenbi mɔ iteebulu too. Ɔ da abono mɛ kya fɛ abonbuɛ mɔ ngyapaa kee too, ne ");
INSERT INTO acd_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ɔ tɔgɛ sa mɔmɔ yɛɛ, “Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi ako yela yɛɛ, ‘Me-ɔson obu mɔ laa wɔra daa ɔdalaaten.’ Fɛye, mɔ, fɛ kyu nno bingiri iyu gikpalan.” ");
INSERT INTO acd_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Agyaatanbo de itɛgɛsɛ mɛ yɛgɛ asa mɛ kyu mɔmɔ ba Yesu asɛ Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so nno, ne ɔ kyɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo mɔ mɛ kya wu ilaa dɛnsɛ ibono Yesu kya wɔra ne i kya dɛ asa gɛnɔ mɔ ne mɛ kya nu ibono nbii mɛ kya yen mɔ mɔ, i kya loo mɔmɔ. Nbii mɔ mɛ kya kpen mɛ kya yen mɔ Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so nno yɛɛ, “Ayenbi aꞌ wɔra Wura Deefidi ɔnaanabi mɔ-lɛɛ!” Gɛnen so mɔ, i kyu abelɛnsɛ mɔ ginyadon, ");
INSERT INTO acd_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ne mɛ taasɛ Yesu yɛɛ, “Ibono adɛ mɛ kya tɔgɛ faa, foŋ kya nu de foꞌ gya mɔmɔ?” Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “N kya nu kyɔde. Wurubuaarɛ agyɛbi ako a tɔgɛ yɛɛ, ‘Nbii de abono mɛ san ma‑a nyabo mɔ ne fo yɛgɛ mɛ kya yen fo de iꞌ tansi gyi fo-ginsi.’ Imɔso fɛŋ ti kalɛ nno?” ");
INSERT INTO acd_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Yesu gi taasɛ abelɛnsɛ mɔ gɛnen mɔ, ɔ naa taa mɔmɔ yɛgɛ ne ɔ kyon kpaa dɛ Bɛtani. ");
INSERT INTO acd_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Gɛdɛ kɛsɛ nyɛnyɛngɛ mɔ, Yesu gi kii ɔ kya kpe Gyɛrusalem mɔ, akon a dɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","O wu gifeeya oyii ɔko yelɛ ɔkpa nkan. Ɔ bagɛ kpe mɔ asɛ mɔ, ɔŋ wu ba‑a gibi kolon oyii mɔ so, afɛdaa wolɛ ne o wu. Nfono mɔ Yesu gi tɔgɛ nnɔ wɔra oyii mɔ yɛɛ, “Foŋ baa nyɛ sɔrɔ abi gɛkaako!” Ɔ tɔgɛ gɛnen mɔ, oyii mɔ gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Owi ɔbono Yesu akasɛbo mɔ mɛ wu imɔ mɔ, i dɛ mɔmɔ-gɛnɔ gikyɔ, ne mɛ taasɛ mɔ yɛɛ, “Nnɛ ne gifeeya oyii mɔ gi ti kpɛ wuꞌ kusaa gɛnen?” ");
INSERT INTO acd_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “N kya tɔgɛ fɛye gɛsintin, nengyene fɛ sɔɔ Wurubuaarɛ gyi ne fɛŋ sɔɔ fɛye-nyoro akyɔɔlɛ fɛye-asen dɔ mɔ, fɛ laa wɔra ilaa ibono nɛ kyu wɔra oyii baarɛ faa mɔ ɔnan. Ne i mɛŋ gyɛ imɔ ibono wolɛ gbaa. Nkana fɛ laa taalɛ tɔgɛ gibii gidɛ yɛɛ, ‘Koso gɛrɛ kpaa tɔrɔ apoo dɔ,’ gɛsintin mɔ, i laa wɔra gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ilaa kamaasɛ ibono fɛ laa dalaa kolɛ Wurubuaarɛ mɔ, nengyene fɛ sɔɔ mɔ gyi yɛɛ ɔ laa wɔra sa fɛye mɔ, i laa yii fɛye-gibaa.” ");
INSERT INTO acd_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Imɔ gɛmara mɔ, Yesu gi kii kpe Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so ɔ kya nyiile asa ilaa, ne Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de mɔmɔ abelɛnsɛ sɛnsɛ ako mɛ ba mɔ asɛ baa taasɛ mɔ yɛɛ, “Ilaa ibonoana fo kya wɔra faa mɔ, anɛ ginyen dɔ ne fo kya wɔra imɔ daa? Anɛ ne n sa fo ɔkpa yɛɛ foꞌ wɔra imɔ?” ");
INSERT INTO acd_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Me kee nan taasɛ fɛye ilaa kolon. Nengyene fɛ lɛɛ gɛnɔ sa me mɔ, nan tɔgɛ fɛye ɔbono ginyen n dɛ n kya wɔra ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Wurubuaarɛ sagyere ɔbono Gyɔn gi gyere asa mɔ, anɛ ne n sa mɔ ɔkpa? Wurubuaarɛ abɛɛ nyamesɛ?” Yesu gi taasɛ ɔmɔ gɛnen mɔ, akyɔɔlɛ a tɔrɔ mɔmɔ wolɛ-wolɛ so, ne mɛ tɔgɛ yɛɛ, “Nengyene a kyule sa mɔ yɛɛ Wurubuaarɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono mɔ, ɔ laa taasɛ aye yɛɛ ne menɛ n wɔra ne a mɛŋ sɔɔ Gyɔn gyi? ");
INSERT INTO acd_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ne fɛɛ a kii tɔgɛ yɛɛ nyamesɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono mɔ, aŋ nyi ilaa ibono sakpii baarɛ laa kyu wɔra aye mɔ. I lii fɛɛ mɔmɔ pɛwu mɛ kya buu Gyɔn yɛɛ Wurubuaarɛ ne n sun mɔ yɛɛ ɔꞌ wɔra gɛnen ne ɔ gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo.” ");
INSERT INTO acd_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Gɛnen so mɔ mɛ lɛɛ gɛnɔ sa Yesu yɛɛ, “A mɛŋ nyi.” Ne Yesu gi kisee tɔgɛ abelɛnsɛ mɔ yɛɛ, “Fɛ maŋ tɔgɛ me berɛ mɔ, me kee maŋ tɔgɛ fɛye ɔbono ɔ sa me ɔkpa ne nꞌ kya wɔra ilaa ibono n kya wɔra mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ nu gikpalɛ gidɛ de nꞌ taasɛ fɛye gimɔ so ilaa. Owi ɔko dɔ mɔ, ɔnyen ɔko gi kyena. Ɔ bo nbii nyensɛɛ nnyɔ. Gɛkɛ gɛdɛ mɔ, ɔ kpaa tɔgɛ sa ɔbelɛnsɛ mɔ yɛɛ, ‘Me-bi, ndɛ kpe me-ndɔɔ kpaa wɔra gɛsun sa me.’ ");
INSERT INTO acd_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Mɔ-bi mɔ gi lɛɛ gɛnɔ sa mɔ yɛɛ, ‘Maŋ kpe.’ Imɔ gɛmara mɔ, o nu mɔ-nyoro gɛsɛ yɛɛ oŋ kpe mɔ, iŋ boran, ne ɔ koso kpe ndɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Mɔmɔ-sɛ mɔ gi kpaa tɔgɛ ɔpii mɔ ilaa kolon ibono kee. Ɔpii mɔ gi kyule yɛɛ, ‘Yo‑o, me-sɛ, nan kpe,’ ne oŋ kii kpe. ");
INSERT INTO acd_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Imɔso nbii nnyɔ ndɛ dɔ mɔ, ɔmɔ mɔ ne n wɔra mɔ-sɛ mɔ gɛlaarɛ ne?” Yesu gi taasɛ gɛnen mɔ, asa mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Mɔ-bi belɛnsɛ mɔ.” Mɛ lɛɛ gɛnɔ gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “N kya tɔgɛ fɛye gɛsintin yɛɛ, tutu akyii de lɛnpoo asɔɔbo abono fɛ kya kyu mɔmɔ yɛɛ mɛ gyɛ asa nyɛnyɛn mɔ mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena taa fɛye yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Imɔ gɛsɛ ne n gyɛ yɛɛ Gyɔn gi baa nyiile fɛye gɛnɔɔbono fɛ laa gyi gɛsintin sa Wurubuaarɛ mɔ, fɛ mɛŋ kyule sɔɔ mɔ gyi. Lɛnpoo asɔɔbo de tutu akyii mɔ berɛ mɛ sɔɔ mɔ gyi. Fɛ dabɔlɛ wu ibono gɛnen asa adɛ mɛ sɔɔ Gyɔn gyi mɔ, imɔ gɛmara mɔ, fɛ mɛŋ kyɛɛgɛ fɛye-nwɔnsa de fɛye kee fɛꞌ sɔɔ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Yesu gi tɔgɛ sa abelɛnsɛ mɔ yɛɛ, “Fɛꞌ kii nu gikpalɛ giko. Gɛten wura ɔko gi kyena. Ɔ dɔɔ gifɔlɛ giko ndɔɔ. (Mɛ kya kyu gɛnen gifɔlɛ gibono abi kyu wɔra nta.) Ɔ pɔrɔ ɔpɔɔrɛ kyaabɔɔ ndɔɔ mɔ, ɔ wɔra nta mɔ ɔdooten, ne ɔ pɔrɔ obu faa lege-lege nfono asa mɛ laa nyɛ dii ndɔɔ mɔ mɔ. Ɔ wɔra imɔ idɛ ta mɔ, o kyu ndɔɔ mɔ kyu wɔra asa ako abaa dɔ yɛɛ mɛꞌ kerɛ nmɔ so sa mɔ de mɔ‑rɛ ɔmɔ mɛꞌ yɛ agyan abono mɛ laa nyɛ mɔ. Ne ɔ koso kpe gɛsinkpan gɛko so kpaa kɛɛla. ");
INSERT INTO acd_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Gifɔlɛ mɔ abi aberɛ tɛɛsɛ a fo mɔ, ndɔɔ wura mɔ gi lɛɛ mɔ-adega ako sun mɔ-ndɔɔ akerɛbo mɔ asɛ yɛɛ mɛꞌ kpaa sɔɔ mɔ-lɛɛ ogyiten bara mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Adega mɔ mɛ kpe mɔ, ndɔɔ akerɛbo mɔ mɛ keda mɔmɔ ne mɛ daarɛ ɔko ne mɛ mɔɔ ɔko ne mɛ da ɔbanban abui. ");
INSERT INTO acd_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ndɔɔ wura mɔ gi nu ilaa ibono i ba mɔ, o kii sun adega abono mɛ nyaakyɔ nyɛ agyangbarasɛ mɔ. Mɔ-ndɔɔ akerɛbo mɔ mɛ kii wɔra ɔmɔ fɛɛ agyangbarasɛ mɔ-lɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Imɔ tiikara mɔ, ɔ lɛɛ mɔ gbaa-gbaa mɔ-bi sun mɔmɔ asɛ. Ɔ tɔgɛ sa mɔ-nyoro yɛɛ, ‘Me-bi mɔ berɛ, mɛ laa kyu buubuu sa mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Mɔ-bi mɔ gi kpe mɔ, mɔ, ndɔɔ akerɛbo mɔ mɛ kpɛ da de ginsi wu mɔ mɔ, mɛ tɔgɛ sa abara yɛɛ, ‘Ɔbono ɔ laa gyi mɔ-sɛ atɔ mɔ ne n kya ba faa. Aꞌ mɔɔ mɔ de mɔ-tɔgyi mɔ ɔꞌ nyɛ sii de aye.’ ");
INSERT INTO acd_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mɛ tɔgɛ sa abara gɛnen mɔ, gɛsintin mɔ, mɛ keda ndɔɔ wura mɔ mɔ-bi mɔ ne mɛ biidɛ mɔ lii ndɔɔ mɔ dɔ ne mɛ mɔɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Ndɔɔ wura mɔ gi kpaa ba mɔ, menɛ ne ɔ laa kyu wɔra mɔ-ndɔɔ akerɛbo abono?” ");
INSERT INTO acd_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Mɛ lɛɛ gɛnɔ yɛɛ, “Ɔ laa yɛgɛ gɛnen asa nyɛnyɛn abono mɛ laa wuꞌ awɔrɔfɔɔ lɛwu de oꞌ kyu mɔ-ndɔɔ mɔ kyu sa akerɛbo dɛnsɛ abono mɛ laa kyu mɔ-lɛɛ ogyiten sa mɔ imɔ-aberɛ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yesu gi kii taasɛ mɔmɔ yɛɛ, “Fɛŋ ti kalɛ Wurubuaarɛ agyɛbi adɛ? Mɛ ŋmarasɛ yɛɛ, ‘Gibui gibono ibu apɔrɔbo mɔ mɛ kyu too gɛbaamara mɔ gɛnen gibui gibono ne n kii baa yɛgɛ ne obu mɔ gi wɔra ɔlon ɔ yelɛ faa. Wurubuaarɛ ilaa wɔrasɛ ne i gyɛ. I bo aye ɔbolɛ ne i kya dɛ aye-gɛnɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Yesu gi kii tɔgɛ bɔla yɛɛ, “Imɔso nꞌ tɔgɛ fɛye yɛɛ ɔkpa ɔbono Wurubuaarɛ gi sa fɛye ne fɛ kya kerɛ mɔ-gɛwuragyi dɔ akyenabi ilaa so mɔ, ɔ laa sɔgɛ lii fɛye asɛ de oꞌ kyu sa asa abono mɛ laa wɔra ilaa ibono i laa kaaborɛ gɛnen akyenabi abono mɔ. ");
INSERT INTO acd_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Fɛꞌ kii nu Wurubuaarɛ agyɛbi adɛ kee. ‘Nyamesɛ kamaasɛ ɔbono ɔ laa tɔrɔ gibui gibono so mɔ, kaasɛ laa gbaa gberi-gberi. Ne gibui mɔ, mɔ, ne n kii baa tɔrɔ fo ɔko so mɔ, fo laa kɔrɔ faa dogo-dogo wɔra fɛɛ nnyufo.’ ” ");
INSERT INTO acd_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de Farasii awura mɔ mɛ nu Yesu akpalɛ adɛ mɔ, mɛ bii ibono mɔmɔ ne ɔ darɛ. ");
INSERT INTO acd_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Imɔso mɛ laarɛ de mɛꞌ keda mɔ. Mɛ kii mɛ selɛ sakpii ɔbono ɔ bo nno mɔ gifuu. I lii fɛɛ sakpii mɔ gi sɔɔ Yesu gyi yɛɛ ɔ gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo. ");
INSERT INTO acd_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yesu gi kii da gikpalɛ sa asa ");
INSERT INTO acd_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","3","yɛɛ, “Fɛꞌ nu gɛnɔɔbono asa mɛ laa nyɛ kyena Wurubuaarɛ gɛwuragyi dɔ gɛkaako mɔ so ilaa. Owi ɔko dɔ mɔ wura ɔko gi wolaa tɔgɛ asa yela yɛɛ ɔ laa kpii ɔkyii sa mɔ-bi. Imɔso, i wɔra mɔ, mɛꞌ baa gyi gɛnen gɛkɛ belɛ mɔ kpaa mɔ. “Gɛkɛ mɔ gɛ fo mɔ, o sun mɔ-adega ako yɛɛ mɛꞌ naa terɛ terɛ abono ɔ da gibaa terɛ mɔ yɛɛ mɛꞌ ba. Adega mɔ mɛ kpaa terɛ mɔmɔ mɔ, mɛ kine yɛɛ mɛ maŋ ba. ");
INSERT INTO acd_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ne o kii sun mɔ-adega banban yɛɛ mɛꞌ kpaa tɔgɛ sa abono ɔ da gibaa terɛ mɔ yɛɛ, ‘Fɛꞌ kerɛ! Nɛ yɛgɛ mɛ mɔɔ anaadɛ abono mɛ kiirɛ mɔ de abono mɛ bo nfɔ mɔ kyu wɔra agyudɔ; mɛ wɔra ilaa kamaasɛ logɛ; imɔso fɛꞌ baa gyi.’ ");
INSERT INTO acd_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Adega mɔ mɛ kpaa tɔgɛ asa mɔ gɛnen mɔ, mɛ mɛŋ ka mɔmɔ-gɛnɔ; mɔmɔ ɔkamaasɛ gi koso mɔ, ɔ kyon mɔ-gɛsun dɔ. Ɔko gi kyon mɔ-ndɔɔ dɔ ne ɔbanban mɔ gi kyon mɔ-ilaa ɔfɛten. ");
INSERT INTO acd_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ne ako, mɔ, mɛ keda wura mɔ adega mɔ daarɛ mɔɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Wura mɔ gi nu gɛnen mɔ, i kyu mɔ ginyadon, ne o sun mɔ-asogya ne mɛ kpaa mɔɔ gɛnen asa amɔɔbo abono, ne mɛ yii mɔmɔ-ɔsowolɛ mɔ ɔgya. ");
INSERT INTO acd_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Nfono mɔ ɔ terɛ mɔ-adega mɔ ako ne ɔ tɔgɛ sa mɔmɔ yɛɛ, ‘Mɛ wɔra gɛdena mɔ agyudɔ mɔ ta. Abono nɛ da gibaa terɛ mɔ, mɔ, mɛ mɛŋ kaaborɛ mɛꞌ nyɛ agyudɔ mɔ gyi ne. ");
INSERT INTO acd_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Imɔso fɛꞌ naa loo nten dɔ de fɛꞌ kpaa terɛ asa abono ɔkara fɛ laa nyɛ mɔ yɛɛ mɛꞌ ba de mɛꞌ baa gyi.’ ");
INSERT INTO acd_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Gɛsintin mɔ, mɔ-adega mɔ mɛ naa loo nten mɔ dɔ ne mɛ kpaa koola asa abono ɔkara mɛ nyɛ mɔ, adɛnsɛ de anyɛnyɛn pɛwu, ne asa mɔ mɛ baa bɔla obu ɔbono dɔ mɛ kya wɔra gɛdena mɔ ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wura mɔ gi loo obu mɔ dɔ de ɔꞌ faala abono mɛ kya gyi gɛkɛ belɛ mɔ ma‑a kpaa mɔ mɔ, o wu ɔnyen ɔko bo nno. Oŋ suu gɛgbɛ gɛbono ɔnan mɛ kya kyu kpe gɛdena gɛkɛ gigyi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Wura mɔ gi wu gɛnen mɔ, ɔ taasɛ mɔ yɛɛ, ‘Ɔnyen, nnɛ ne fo wɔra ne fo nyɛ loo gɛrɛ yɛgɛ foŋ suu gɛgbɛ gɛbono mɛ kya suu kpe gɛdena gɛkɛ gigyi mɔ?’ Ɔnyen mɔ mɛŋ nyɛ gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nfono mɔ wura mɔ gi tɔgɛ mɔ-adega abono mɛ kya kerɛ gɛkɛ mɔ gigyi so mɔ yɛɛ, ‘Fɛꞌ ŋminde ɔnyen mɔ ayaa de abaa de fɛꞌ kyu mɔ lii kpaa too wɔra nfono i bo gibiri mɔ. Osulon de anɛbi giwɛ ne n bo nno.’ ” ");
INSERT INTO acd_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ tɔgɛ yɛɛ, “I bo nno yɛɛ Wurubuaarɛ gi tɔgɛ asa sakyɔ yɛɛ mɛꞌ baa nyɛ ɔkyenaten mɔ-gɛwuragyi mɔ dɔ. Akalɛsɛ, mɔ, ne ɔ tɔɔsɛ lɛɛ yɛɛ mɛ laa nyɛ gɛnen gɛkyena gɛbono.” ");
INSERT INTO acd_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Nfono mɔ Farasii awura gikpen mɔ dɔ ako mɛ lii asa mɔ dɔ kpaa da gɛnɔ gɛnɔɔbono mɛ laa soo Yesu idoo de mɛꞌ nyɛ mɔ mɔ-ilaa tɔgɛsɛ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Imɔso mɛ sun mɔmɔ-akasɛbo ako de Wura Hɛrodɛ gɛmara abuubo ako kpe mɔ asɛ. Abono mɛ kpaa too mɔ soso taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, a wu yɛɛ fo gyɛ gɛsintin wura. Fo kya nyiile asa Wurubuaarɛ ɔkpa gɛsintin ɔkpa so, ne fo mɛŋ selɛ ɔko. Fo berɛ, fo mɛŋ kya kerɛ nyamesɛ sakyɔ abɛɛ mɔ-nyisigyi ɔbono ɔ bo mɔ de foꞌ buu ɔko don ɔko. ");
INSERT INTO acd_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","A dɛ fo giserɛ, tɔgɛ aye, imɔso Rom wura belɛ ɔbono ɔ kya kerɛ aye so ne ɔŋ kya son Wurubuaarɛ mɔ, i dɛ ɔkpa yɛɛ aꞌ sɔɔ mɔ-lɛnpoo abɛɛ a mɛŋ sa aꞌ sɔɔ?” ");
INSERT INTO acd_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Yesu, mɔ, gi dɛsɛ yɛɛ mɛ dɛ nwɔnsa nyɛnyɛn, imɔso ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛ gyɛ o-dun-me, o-fon-me anyamesɛ! Menɛ so ne fɛ kya soo me idoo gɛnen? ");
INSERT INTO acd_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɔko ɔꞌ lɛɛ aterenbi abono fɛ kya kyu sɔɔ lɛnpoo mɔ gibi ba de nꞌ kerɛ.” Gɛsintin mɔ, mɛ kyu aterenbi mɔ gibi mɔ kyu sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ne ɔ taasɛ mɔmɔ yɛɛ, “Anɛ gimu de mɔ-ginyen ne n gyanꞌ aterenbi gibi gidɛ so faa?” ");
INSERT INTO acd_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Mɛ lɛɛ gɛnɔ yɛɛ, “Rom wura belɛ mɔ-lɛɛ.” Ne Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “To. Gɛnen berɛ mɔ, ilaa ibono i gyɛ Rom wura belɛ mɔ-lɛɛ mɔ fɛꞌ kyu sa mɔ, ne ibono, mɔ, i gyɛ Wurubuaarɛ-lɛɛ mɔ, fɛꞌ kyu sa Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Mɛ nu gɛnɔɔbono Yesu gi lɛɛ gɛnɔ sa mɔmɔ mɔ, i dɛ mɔmɔ-gɛnɔ gikyɔ, ne mɛ san naa kyon taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Gɛnen gɛkɛ gɛbono mɔ, Saadusii gikpen dɔ awura ako mɛ ba Yesu asɛ. (Saadusii awura adɛ ne n kpɛ mɛ dɛ yɛɛ nengyene nyamesɛ gi wuꞌ mɔ, i ta. Iŋ baa i bo gɛtɛɛko mɛ laa kpaa kyena, ne Wurubuaarɛ maŋ kyingi asa gɛkaako.) Gɛnen asa adɛ mɛ baa tɔgɛ sa Yesu ");
INSERT INTO acd_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","yɛɛ, “Ɔbelɛnsɛ, Mosisi gi yela nbara nko sa aye yɛɛ, ‘Nengyene ɔnyen gi wuꞌ taa mɔ-ka yɛgɛ owi ɔbono mɔ-ka mɔ mɛŋ ti korogɛ sa mɔ mɔ, mɔ-daa abɛɛ mɔ-tedɛ oꞌ kyu ɔkyii mɔ lɛɛ gikulaa de mɔ‑rɛ mɔ mɛꞌ korogɛ nbii sa mɔ-kuli ɔbono o wuꞌ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","To. Owi ɔko dɔ mɔ ɔnyen ɔko mɔ‑rɛ mɔ-tedɛana asee mɛ kyena aye-ɔsowolɛ baarɛ so gɛrɛ. Gɛnen ɔnyen mɔ gi dena ɔkyii. Mɔ‑rɛ mɔ-ka mɔ mɛŋ korogɛ, ne o wuꞌ taa mɔ-ka mɔ yɛgɛ. Mosisi nbara nbono ɔ yela sa aye mɔ so mɔ, mɔ-gigyanmara mɔ gi kyu ɔkyii mɔ lɛɛ gikulaa. ");
INSERT INTO acd_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mɔ‑rɛ ɔkyii mɔ mɛ mɛŋ korogɛ, ne mɔ kee gi wuꞌ taa ɔkyii mɔ yɛgɛ. Ɔsasɛ mɔ kee, gɛnen; ne mɔmɔ anyen sono mɔ pɛwu mɛ dena ɔkyii mɔ, ne mɛ wuꞌ taa mɔ yɛgɛ. Ɔkyii mɔ mɛŋ korogɛ sa mɔmɔ ɔko‑rɛ ɔko. ");
INSERT INTO acd_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Laalaalogɛ mɔ, ɔkyii mɔ kee gi wuꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Mɛ tɔgɛ Yesu gɛnen mɔ, ne mɛ taasɛ mɔ yɛɛ, “To, nengyene Wurubuaarɛ laa kyingi asa gɛsintin mɔ, mɔmɔ anyen sono adɛ dɔ mɔ, anɛ ne n bo ɔkyii mɔ gɛnen gɛkyena pobɔrɔ mɔ dɔ? I kya nyiile yɛɛ owi ɔbono mɛ tɛ de ansi mɔ, mɔmɔ pɛwu mɛ dena mɔ gyanꞌ.” ");
INSERT INTO acd_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛ fuɛ. I kya nyiile yɛɛ fɛ mɛŋ nyi Wurubuaarɛ agyɛbi mɔ, ne fɛ mɛŋ nyi Wurubuaarɛ ɔlon ɔbono ɔ bo mɔ kee. ");
INSERT INTO acd_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Asa abono Wurubuaarɛ laa kyingi de mɛꞌ kyena gɛkyena pobɔrɔ mɔ, gɛdena gɛŋ baa gɛ bo no sa mɔmɔ. Mɔmɔ-gɛkyena gɛ laa wɔra daa fɛɛ Wurubuaarɛ dɔ isɔɔ-lɛɛ mɔ ɔnan.” ");
INSERT INTO acd_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yesu gi kii tɔgɛ sa Saadusii awura mɔ yɛɛ, “Fɛ kya sɔɔ akyɔɔlɛ yɛɛ asa mɛ wuꞌ mɔ iŋ baa i bo gɛtɛɛko mɛ kya kpaa kyena faa mɔ, aꞌ kerɛ Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ de aꞌ kerɛ. Imɔso fɛ mɛŋ ti kalɛ mɔ-agyɛbi abono mɛ ŋmarasɛ yela sa fɛye nno ");
INSERT INTO acd_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","yɛɛ, ‘Me ne n gyɛ Aberaham Wurubuaarɛ. N gyɛ Ayisiki Wurubuaarɛ, ne nꞌ gyɛ Gyeekɔpo Wurubuaarɛ’ mɔ? Aberɛ abono Wurubuaarɛ gi tɔgɛ gɛnen ilaa idɛ sa Mosisi mɔ, gɛnen asa adɛ mɛ ti wolaa wuꞌ. Ne fɛɛ iloobu idɛ mɛŋ bo gɛtɛɛko daa mɔ, Wurubuaarɛ maŋ tɔgɛ yɛɛ, ‘N gyɛ mɔmɔ-Wurubuaarɛ.’ Nkana ɔ laa tɔgɛ daa yɛɛ, ‘Nɛ naa kyena wɔra mɔmɔ-Wurubuaarɛ yɛgɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Sakpii ɔbono ɔ bo nfono mɔ gi nu gɛnɔɔbono ɔ lɛɛ gɛsɛ mɔ, i dɛ mɔmɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Farasii awura mɔ mɛ nu yɛɛ Saadusii awura mɔ ayaa aŋ fo gɛsɛ Yesu asɛ mɔ, mɔmɔ kee mɛ kpaa ŋminde ba. ");
INSERT INTO acd_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mɛ fo mɔ, mɔmɔ dɔ ɔbono ɔ gyɛ nbara onyiilebo mɔ gi taasɛ Yesu ilaa iko de ɔꞌ daasɛ mɔ kerɛ. Ɔ taasɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ɔbelɛnsɛ, Wurubuaarɛ nbara mɔ dɔ mɔ, nmɔ mɔ ne n tansi gi tiri daa?” ");
INSERT INTO acd_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Nbono gi tiri mɔ ne n gyɛ yɛɛ, ‘Laarɛ fo-Wura Wurubuaarɛ lii fo-gisen dɔ. Kyu fo-gisen pɛwu de fo-gɛwɔnsa pɛwu kyu laarɛ Wurubuaarɛ ilaa.’ ");
INSERT INTO acd_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gɛnen nbara ndɛ ne n don nsɛnsɛ mɔ, ne nmɔ ne n tansi gi tiri. ");
INSERT INTO acd_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Nnyɔsɛ nbono kee gi tiri mɔ gi dɛ fɛɛ nbono nɛ tɔgɛ kyon mɔ. Nmɔ ne n gyɛ yɛɛ, ‘Laarɛ fo-nanbo fɛɛ fo-nyoro.’ ");
INSERT INTO acd_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Wurubuaarɛ ikalan atɔgɛbo ilaa nyiilesɛ mɔ de Mosisi nbara mɔ pɛwu dɔ mɔ gɛnen nbara nnyɔ ndɛ ne n gyɛ nmɔ-gɛmu.” ");
INSERT INTO acd_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Owi ɔbono Farasii awura mɔ mɛ san mɛ bo Yesu asɛ mɔ, Yesu kee gi taasɛ mɔmɔ ilaa taasɛsɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ɔbono Wurubuaarɛ laa sun de ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ, nnɛ ne n gyɛ fɛye-gɛwɔnsa kyu lii mɔ so? Anɛ ɔnaanabi ne ɔ gyɛ?” Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “Ɔ gyɛ daa Deefidi ɔnaanabi.” ");
INSERT INTO acd_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ne Yesu gi kii taasɛ mɔmɔ yɛɛ, “Ne i wonɛ ne Wurubuaarɛ Oduduu mɔ gi yɛgɛ Deefidi gi wolaa terɛ gɛnen ɔnaanabi mɔ yɛɛ, ‘Me-Wura’ mɔ daa? Deefidi gi wolaa tɔgɛ yela yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Wurubuaarɛ laa tɔgɛ sa me-Wura mɔ yɛɛ, “Baa kyena me-gibaa gyisɛ so de me‑rɛ fo aꞌ gyi gɛwura de nꞌ yɛgɛ foꞌ kyise fo-akyobo de fo-ayaa.” ’ ” ");
INSERT INTO acd_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Yesu gi kii lɛɛ gɛsɛ yɛɛ, “Deefidi kya terɛ mɔ yɛɛ, ‘Me-Wura’ faa mɔ, nnɛ so ne ɔ laa kii kisee wɔra daa Deefidi ɔnaanabi?” ");
INSERT INTO acd_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Asa mɔ dɔ ɔko‑rɛ ɔko mɛŋ taalɛ lɛɛ gɛnɔ sa Yesu. San kyu lii gɛnen gɛkɛ gɛbono mɔ, ɔko mɛŋ baa taalɛ da otu taasɛ Yesu ilaa de ɔꞌ daasɛ mɔ kerɛ. ");
INSERT INTO acd_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Nfono mɔ Yesu gi tɔgɛ sa sakpii mɔ de mɔ-akasɛbo mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Nbara aŋmarasɛbo mɔ de Farasii awura mɔ ne n bo ɔkpa de mɛꞌ lɛɛ Mosisi nbara mɔ gɛsɛ sa asa. ");
INSERT INTO acd_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Imɔso ilaa kamaasɛ ibono mɛ kya tɔgɛ fɛye kyu lii nmɔ so mɔ fɛꞌ nu de fɛꞌ wɔra imɔ. Mɔmɔ-ilaa wɔrasɛ berɛ ne fɛŋ sa fɛꞌ wɔra. I lii fɛɛ ilaa ibono mɛ kya nyiile fɛye mɔ, iŋ gyɛ imɔ ne mɛ kya wɔra. ");
INSERT INTO acd_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mɔmɔ-anyiilebi mɔ a dɛ daa fɛɛ nsola boduduusɛ nbono giŋ bo gisola mɔ ne mɛ dɛ ma‑a nyise asa. Mɔmɔ gbaa-gbaa berɛ, mɛ maŋ kyu ba‑a mɔmɔ-gibaa taa puru kpaa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Mɛ kya wɔra ilaa kamaasɛ mɔ, mɛ kya laarɛ daa de asa mɛꞌ wu de mɛꞌ nyɛ yen mɔmɔ. Wurubuaarɛ agyɛbi abono aye Gyuda awura a kya kyu mada aye-asegbelɛ so de abono a kya kyu kyaga aye-abaa dɔ mɔ, mɛ kya yɛgɛ mɔmɔ-lɛɛ berɛ i kya wɔra ibelɛ-belɛ. Aye-itiibilaa ibono a kya kyu kyaga de aye-ngbɛ mɔ, mɛ kya yɛgɛ mɔmɔ-lɛɛ berɛ i kya tansi wɔra gisoro. ");
INSERT INTO acd_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ne fɛɛ mɛ laa gyi gɛkɛ belɛ mɔ, abɛɛ mɛ kya kpe mɔmɔ-akyangbon dɔ mɔ, abelɛnsɛ de anyamesɛ gbaaꞌgbaa ikyenaten ne mɛ kya laarɛ. ");
INSERT INTO acd_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mɛ kya laarɛ de asa mɛꞌ terɛ mɔmɔ yɛɛ ‘Anyiilebo’ de mɛꞌ kyu buubuu faala mɔmɔ sakpii dɔ de ɔkamaasɛ oꞌ wu. ");
INSERT INTO acd_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Fɛye berɛ fɛŋ sa fɛꞌ yɛgɛ asa mɛꞌ terɛ fɛye dɔ ɔko yɛɛ ‘Onyiilebo.’ I lii fɛɛ fɛye pɛwu fɛ gyɛ gikpen kolon dɔ asa ne onyiilebo kolon ne fɛ bo. Me ne n gyɛ fɛye-onyiilebo ɔbono. ");
INSERT INTO acd_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Fɛŋ sa fɛꞌ terɛ ɔko yɛɛ ‘aye-sɛ’ gɛsinkpan so gɛrɛ. I kya nyiile yɛɛ fɛ bo daa ɔsɛ kolon, mɔ ne n gyɛ Wurubuaarɛ ɔbono ɔ bo soso mɔ. ");
INSERT INTO acd_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Gɛnen kee ne fɛŋ sa fɛꞌ yɛgɛ asa mɛꞌ terɛ fɛye dɔ ɔko yɛɛ ‘Ɔgyangbarabo’; ɔgyangbarabo kolon guan‑n ne fɛ bo, mɔ ne n gyɛ me ɔbono Wurubuaarɛ gi sun yɛɛ nꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. ");
INSERT INTO acd_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ɔbono ɔ tansi ɔ gyɛ nyamesɛ gbaaꞌ fɛye dɔ mɔ gi kaaborɛ ɔꞌ wɔra daa fɛye-dega. ");
INSERT INTO acd_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɔbono ɔ diirɛ mɔ-nyoro mɔ, Wurubuaarɛ laa kpelegɛrɛ mɔ gɛsɛ, ne ɔbono, mɔ, ɔ bara mɔ-nyoro gɛsɛ mɔ, Wurubuaarɛ laa diirɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Nfono mɔ, Yesu gi kisee tɔgɛ sa abelɛnsɛ mɔ ako yɛɛ, “Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ daa o-dun-me, ɔ-fon-me anyamesɛ! Fɛ kyu ilaa ibono nkana i laa yɛgɛ asa mɛꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ kyu ŋara mɔmɔ. Fɛye gbaa-gbaa fɛ mɛŋ kya kyu gɛnen akyenabi mɔ kyu kyena, ne abono, mɔ, mɛ kya laarɛ mɛꞌ kyena gɛnen gɛkyena mɔ, fɛ kya ŋɛ fɔlɔgɛ fɛ kya tii mɔmɔ-ɔkpa.  ");
INSERT INTO acd_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ daa o-dun-me, ɔ-fon-me anyamesɛ! Fɛ kya kudi akyii ikulaabo mɔmɔ‑rɛ mɔmɔ-biana gyi, yɛgɛ fɛye, mɔ, ne n kii fa‑a dalaa faa bolo-bolo de asa mɛꞌ nyɛ yen fɛye yɛɛ fɛye ne n nyi gɛdalaa. Owi ɔbono Wurubuaarɛ laa gyi fɛye-nbɛlɛ mɔ, fɛye-gisobiidɛ gi laa nyaakyɔ too. ");
INSERT INTO acd_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ daa o-dun-me, ɔ-fon-me anyamesɛ! Fɛ kya naa nkyu so de nsinkpan so gyanꞌ de fɛꞌ taa nyɛ ba‑a nyamesɛ kolon ɔꞌ kyɛɛgɛ baa buu fɛye-lɛɛ Wurubuaarɛ asonbi mɔ. Fɛ nyɛ ɔkolon gɛnen mɔ, fɛ kya yɛgɛ ɔ kya kii bingiri daa isa ɔbono ɔ kaaborɛ oꞌ kpe ɔgya dɔ mɔ-lɛwu gɛmara mɔ kii don fɛye-lɛɛ mɔ! ");
INSERT INTO acd_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Fɛye laako! Fɛ dɛ daa fɛɛ agyaatanbo ne n gyangbara mɛ sa agyaatanbo. Fɛ kya nyiile asa yɛɛ nengyene ɔko gi ka Wurubuaarɛ ɔson obu mɔ ntan mɔ, ɔ laa taalɛ yɛgɛ iꞌ gbangɛ. Sika kɔkɔɔ ɔbono ɔ bo Wurubuaarɛ ɔson obu mɔ dɔ mɔ berɛ ne ɔko gi kyu ka ntan mɔ, fɛye asɛ mɔ, gi gyɛ ntan belɛ. ");
INSERT INTO acd_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Fɛ dɛ fɛɛ agyaatanbo, ne fɛ mɛŋ nyi ɔlaako! Imɔ imɔmɔ ne n tiri gikyɔ, sika kɔkɔɔ mɔ abɛɛ Wurubuaarɛ ɔson obu mɔ daa? Iŋ gyɛ Wurubuaarɛ ɔson obu mɔ dɔ ne sika kɔkɔɔ mɔ dɛ so ne ɔ gyɛ Wurubuaarɛ-lɛɛ? ");
INSERT INTO acd_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Fɛ kya nyiile asa kee yɛɛ nengyene ɔko gi ka Wurubuaarɛ asunbi ɔlɛɛten mɔ ntan mɔ, mɔ-ntan mɔ giŋ gyɛ ntan nko. Nengyene o kyu ilaa ibono ɔ laa kyu lɛɛ asunbi mɔ berɛ daa kyu ka ntan mɔ, fɛ kya kyu nmɔ yɛɛ gi gyɛ ntan belɛ. ");
INSERT INTO acd_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Menɛ gigyaatanbo ne n kya mɔɔ fɛye faa? Ilaa ibono mɛ kyu ba mɛꞌ baa lɛɛ asunbi mɔ ne n tiri abɛɛ Wurubuaarɛ asunbi ɔlɛɛten mɔ ne n tiri daa? Iŋ gyɛ asunbi ɔlɛɛten mɔ ne n kya yɛgɛ asunbi atɔ mɔ a kya nyɛ bingiri Wurubuaarɛ-lɛɛ? ");
INSERT INTO acd_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Imɔso nengyene isa gi ka Wurubuaarɛ asunbi ɔlɛɛten mɔ ntan mɔ, ɔ ka dabɔlɛ de asunbi atɔ abono a gyanꞌ asunbi ɔlɛɛten mɔ so mɔ pɛwu ne. ");
INSERT INTO acd_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Nengyene ɔko gi ka Wurubuaarɛ ɔson obu mɔ ntan mɔ, ɔ ka dabɔlɛ de Wurubuaarɛ ɔbono ɔ bo obu mɔ dɔ mɔ kee ne. ");
INSERT INTO acd_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ne fɛɛ ɔko gi ka Wurubuaarɛ dɔ ntan mɔ, ɔ ka Wurubuaarɛ gɛwuragyapaa mɔ ntan de Wurubuaarɛ ɔbono ɔ tɛ gɛwuragyapaa mɔ so mɔ ntan kee ne. ");
INSERT INTO acd_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ o-dun-me, ɔ-fon-me-ana gikyɔ! Ansi so mɔ, fɛ kya yɛ fɛye-afɛdaa gyisɛ fɛɛ agbɛɛma de malebokyu de benkeni afɛdaa dɔ gikpadɔ gudu-gudu de fɛꞌ kyu gikolon-gikolon kyu kpaa kyɛɛ Wurubuaarɛ fɛɛ gɛnɔɔbono i dɛ sa fɛye mɔ. Ilaa ibono i tiri gikyɔ Wurubuaarɛ nbara mɔ dɔ mɔ berɛ, fɛ kya nyaa imɔ ibono yela nkan. Fɛɛ fɛ laa gyi gɛsintin sa asa abɛɛ fɛꞌ su asa so, abɛɛ fɛꞌ sɔɔ Wurubuaarɛ gyi mɔ, fɛ kya lɛɛ ansi taa imɔ ibono yɛgɛ. Nbara nbono ne i kaaborɛ fɛꞌ tansi gyi nmɔ so. Iŋ gyɛ yɛɛ fɛꞌ taa nbono fɛ ti fɛ kya gyi nmɔ so mɔ yɛgɛ berɛ. ");
INSERT INTO acd_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Fɛ dɛ fɛɛ agyaatanbo ne n gyangbara mɛ sa agyaatanbo. Fɛ kya wɔra fɛɛ ɔbono ɔ laa wu kyɛsen mɔ-agyudɔ dɔ de ɔꞌ bii lɛɛ pɛi de oꞌ gyi mɔ, ne tɛtɛmenyi berɛ gi bo mɔ-agyudɔ dɔ ne ɔ maŋ bii lɛɛ mɔ! ");
INSERT INTO acd_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ o-dun-me, ɔ-fon-me anyamesɛ gɛsintin! Fɛ dɛ fɛɛ asa abono mɛ kya foro mɔmɔ-nwɛ de mɔmɔ-ilɛpɛ nyoro so taa imɔ tudɔ yɛgɛ mɔ. Imɔ ne n gyɛ yɛɛ ansi so giyan ne fɛ kya gyere lɔrɔ fɛye-nyoro. Fɛye-itɔ dɔ de fɛye-amu dɔ berɛ onsipara de gɛkyo ne n bɔla nno. ");
INSERT INTO acd_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Farasii awura, fɛ gyɛ agyaatanbo gɛsintin! Fɛꞌ foro fɛye-nwɛ tudɔ de imɔ-nyoro so kee iꞌ wɔra ɔdan. ");
INSERT INTO acd_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ daa o-dun-me, ɔ-fon-me anyamesɛ! Fɛ dɛ fɛɛ nkyan nbono mɛ pɔrɔ nmɔ ne gi bo kanpɛ ansi so, yɛgɛ nmɔ tudɔ mɔ, awuye de anyamesɛ gyɔsɛ ne n bo nno! ");
INSERT INTO acd_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Gɛnen ne ansi so mɔ, asa mɛ laa kyu fɛye yɛɛ gɛsintin awura ne fɛ gyɛ, yɛgɛ gikerɛansi de ilaa nyɛnyɛn ne n bɔla fɛye-itɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Fɛye nbara aŋmarasɛbo de fɛye Farasii awura, fɛye laako! Fɛ gyɛ o-dun-me, ɔ-fon-me anyamesɛ! Fɛ kya kerɛ ansi pɔrɔ Wurubuaarɛ ikalan atɔgɛbo de abono mɛ gyi gɛsintin sa Wurubuaarɛ baa kyon mɔ ako nkyan, ne fɛ kya dɛnkyi mɔmɔ ako-lɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","de fɛꞌ kyu gyaabii asa yɛɛ, ‘Fɛɛ aye ne nan kyena aye-naanaana aberɛ dɔ mɔ, nkana a maŋ kyule ibono mɛ mɔɔ Wurubuaarɛ ikalan atɔgɛbo mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Imɔ mɔ mɔ, ibono fɛ nyɛ kyule yɛɛ fɛye-naanaana ne n mɔɔ Wurubuaarɛ ikalan atɔgɛbo mɔ faa mɔ, fɛye‑rɛ mɔmɔ fɛ gyɛ daa oyuduu kolon. ");
INSERT INTO acd_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Imɔso fɛꞌ tɛsɛ logɛ fɛye-naanaana gɛsun gɛbono mɛ yii gɛsɛ mɔ! ");
INSERT INTO acd_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Fɛ bo ilaa nyɛnyɛn ne fɛ gyɛ asa amɔɔbo fɛɛ awɔɔ abono a bo gibɔrɔ mɔ! Wurubuaarɛ laa bun fɛye gipuɛɛ de oꞌ kyu fɛye too wɔra ɔgya ɔbono dɔ ɔ laa biidɛ ilaa nyɛnyɛn awɔrabo giso mɔ. Fɛ maŋ nyɛ lii gɛnen gisobiidɛ gibono dɔ. ");
INSERT INTO acd_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nꞌ tɔgɛ sa fɛye yɛɛ pɛi de iꞌ lɔɔ fo gɛnen mɔ, nan sun Wurubuaarɛ ikalan atɔgɛbo de asɛɛbo de Wurubuaarɛ nbara aŋmarasɛbo fɛye asɛ. Fɛ laa mɔɔ mɔmɔ ako, de fɛꞌ da mɔmɔ ako aŋanbi iyii so mɔɔ de fɛꞌ taa mɔmɔ ako awulibi fɛye-akyangbon dɔ de fɛꞌ ka mɔmɔ ako ansi lii isowolɛ so kpe isowolɛ so. ");
INSERT INTO acd_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Imɔ idɛ so mɔ, asa abono mɛ gyi gɛsintin sa Wurubuaarɛ ne asa mɛ mɔɔ mɔmɔ mɔ pɛwu, Wurubuaarɛ laa kyu imɔ-ilaa kyu taasɛ fɛye ndɛ asa de ɔꞌ biidɛ fɛye-giso. Ɔ laa yii gɛsɛ taasɛ fɛye ilaa kyu lii Abelɛ ɔbono ɔŋ wɔra sɛi ne mɛ mɔɔ mɔ mɔ kyu gɛnen‑n kyu kpaa fo Sakariya, Barakaya mɔ-bi mɔ-lɛɛ lɛwu mɔ so. Sakariya ɔbono mɔ mɛ mɔɔ mɔ daa Wurubuaarɛ asunbi ɔlɛɛten de Wurubuaarɛ obu belɛ mɔ nsana. ");
INSERT INTO acd_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","N kya tɔgɛ fɛye gɛsintin yɛɛ Wurubuaarɛ laa biidɛ fɛye ndɛ asa adɛ giso kyu lii gɛnen asa abono so. ");
INSERT INTO acd_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“O, Gyɛrusalem asa! Fɛye ne n kpɛ fa‑a mɔɔ Wurubuaarɛ ikalan atɔgɛbo mɔ, ne fɛ kya too abui fa‑a mɔɔ Wurubuaarɛ isɔɔ ibono ɔ kya sun fɛye asɛ mɔ. Nɛ tansi laarɛ fɛɛ nꞌ nyaa fɛye ba me asɛ fɛɛ gɛnɔɔbono kyaasɛ kya nyaa mɔ-biana baa wɔra mɔ-abantɛɛ dɔ mɔ. Gikpadɔ gifonɛɛ ne nɛ laarɛ nꞌ koola fɛye gɛnen ne fɛŋ kya kyule faa. ");
INSERT INTO acd_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Fɛꞌ nu yɛɛ Wurubuaarɛ laa lɛɛ ansi taa fɛye-ɔsowolɛ yɛgɛ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","N kya buu mi‑i sa fɛye yɛɛ fɛ maŋ baa wu me kpaa fo gɛkɛ gɛbono fɛ laa bugi fɛye-nnɔ tɔgɛ yɛɛ, ‘Wurubuaarɛ ɔꞌ kosorɛ ɔnyen baarɛ gimu! Wurubuaarɛ ginyen dɔ ne ɔ naa ɔ kya ba faa!’ ” ");
INSERT INTO acd_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Yesu kya lii Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so mɔ, mɔ-akasɛbo mɔ mɛ naa kpaa tu mɔ, ne mɛ kya tɔgɛ mɔ yɛɛ ɔꞌ kerɛ ibu mɔ ɔdan! ");
INSERT INTO acd_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Yesu, mɔ, gi tɔgɛ sa mɔmɔ yɛɛ, “Nga fɛ wu ibu idɛ pɛwu? Nꞌ tɔgɛ fɛye gɛsintin, i laa baa fo owi ɔko mɔ, ako mɛ laa baa boori imɔ bun. Ba‑a imɔ-gisodoo kolon gi maŋ san yɛɛ gi maŋ dɛ gɛsɛ.” ");
INSERT INTO acd_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Imɔ gɛmara mɔ, Yesu tɛ Nfɔ Iyii Gibii mɔ so mɔ, mɔ-akasɛbo mɔ mɛ ba mɔ asɛ mɔmɔ-wolɛ ne mɛ taasɛ mɔ yɛɛ, “Owi ɔmɔ dɔ ne mɛ laa boori imɔ bun gɛnen? Menɛ ilaa ne nan ba de iꞌ lɛɛ nyiile yɛɛ fo kya laarɛ foꞌ kii ba gɛsinkpan so abɛɛ gɛsinkpan so gɛkyena gɛ kya laarɛ gɛꞌ yela ɔkara? A kya kolɛ fo, tɔgɛ aye.” ");
INSERT INTO acd_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dandan daa de ɔko ɔꞌ mɛŋ sa ɔꞌ nyɛ fɛye penɛ. Gɛnen ilaa ibono i maŋ ba nperɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Pɛi de iꞌ lɔɔ ba gɛnen mɔ, asa sakyɔ mɛ laa naa mɛ kya tɔgɛ yɛɛ mɔmɔ ne gyɛ me, ɔbono Wurubuaarɛ gi sun yɛɛ nꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. Gɛnen asa abono mɛ laa nyɛ asa sakyɔ penɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Fɛ laa nu ikɔ so titiritii de koo-koo. Fɛ kya nu gɛnen mɔ, fɛ mɛŋ sa fɛꞌ yɛgɛ fɛye-gisen giꞌ ŋmaa fɛye. Imɔ idɛ i gyɛ ilaa ibono i laa ba daa. Ne i mɛŋ gyɛ yɛɛ ilaa kamaasɛ i kya yela ɔkara ayaa abono so ne. ");
INSERT INTO acd_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","I kya nyiile yɛɛ fɛ laa nu gɛsinkpan so asa kpɛi-kpɛi mɛ laa laarɛ ikɔ too abara so. Abɛyin de abɛyin mɛ laa koso yelɛ mɛ kya kɔ de abara. Nten kpɛi-kpɛi so mɔ, akon a laa tɔrɔ, ne gɛsinkpan gɛ laa gyigisi. ");
INSERT INTO acd_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Imɔ idɛana pɛwu i laa nyiile yɛɛ gɛkyena gɛdɛ ilaa i kya kpe laalaalogɛ ne. I laa wɔra fɛɛ gɛnɔɔbono gɛdun gɛ kya daa gitu ɔkyii ne i mɛŋ gyɛ nfono-nfono ne ɔ kya korogɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Gɛnen aberɛ abono mɔ, ibono fɛ gyɛ me-akasɛbo faa so mɔ, asa mɛ laa kyu fɛye wɔra ako abaa dɔ de mɛꞌ wɔra fɛye awɔrɔfɔɔ de mɛꞌ mɔɔ fɛye ako. Me so mɔ, asa kpɛi-kpɛi pɛwu mɛ laa kyo fɛye. ");
INSERT INTO acd_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Nfono mɔ, me-akasɛbo sakyɔ mɛ laa taa me yɛgɛ, mɛŋ baa wɔra me-akasɛbo. Mɛ laa fɛ abara sa mɔmɔ-akyobo de mɛꞌ kyo abara. ");
INSERT INTO acd_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Asa sakyɔ mɛ laa koso mɛ kya kɛɛ abon yɛɛ Wurubuaarɛ ikalan atɔgɛbo ne mɛ gyɛ, de mɛꞌ penɛ asa sakyɔ kee. ");
INSERT INTO acd_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Ilaa nyɛnyɛn giwɔra i laa gbigi gikyɔ so mɔ, asa sakyɔ mɛ laa taa gɛsalaarɛ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Fo ɔbono, mɔ, fo sɔɔ me gyi ne fo yelɛ fo-ayaa so girin gɛnen kaaborɛ fo wuꞌ mɔ, Wurubuaarɛ laa mɔlɛgɛ fo de foꞌ nyɛ ɔkyenaten mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Asa mɛ laa naa gɛsinkpan so gɛten kamaasɛ pɛwu gyanꞌ mɛ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ma‑a sa gɛsinkpan so asa kpɛi-kpɛi pɛwu de mɛꞌ nyɛ nu Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa de mɔmɔ-aso. I nyɛ ba gɛnen ta mɔ, gɛsinkpan so gɛkyena gɛ laa yela ɔkara. ");
INSERT INTO acd_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Pɛi de iꞌ lɔɔ ba gɛnen mɔ, fɛ laa wu ilaa kyosɛ ibono i kya nyida Wurubuaarɛ ɔson ilaa mɔ i yelɛ Wurubuaarɛ ɔson obu mɔ dɔ. I laa wɔra fɛɛ gɛnɔɔbono Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono mɛ kya terɛ mɔ yɛɛ Danyɛlɛ mɔ gi wolaa wu tɔgɛ yela mɔ. (Fo ɔbono fo kya kalɛ ilaa idɛ mɔ, nu imɔ gɛsɛ.) Fɛ wu ilaa kyosɛ mɔ nno gɛnen mɔ, ");
INSERT INTO acd_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","fɛye abono fɛ bo Gyudiya gɛsinkpan so mɔ, fɛꞌ selɛ kpe abii dɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Fo ɔbono fo bo nŋmaŋman gɛnen owi ɔbono mɔ, selɛ. Gɛŋ sa foꞌ kii loo obu dɔ yɛɛ fo laa kpaa puru ilaa iko. ");
INSERT INTO acd_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ne fo ɔbono fo bo ndɔɔ dɔ gɛnen owi ɔbono mɔ, gɛŋ baa kii ba gɛwi yɛɛ fo kya ba de foꞌ baa kyu fo-gikuru. ");
INSERT INTO acd_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Awɔrɔfɔɔ a laa nyaakyɔ gikyɔ so mɔ, akyii abono mɛ dɛ itɔ gɛnen nkɛ nbono dɔ abɛɛ mɔmɔ-biana mɛ san mɛ kya nyabo mɔ, mɔmɔ laako! ");
INSERT INTO acd_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Fɛꞌ dalaa yɛɛ gɛnen ilaa idɛ i mɛŋ sa iꞌ ba gikyɛ abɛɛ gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","I lii fɛɛ gɛnen nkɛ nbono dɔ-lɛɛ awɔrɔfɔɔ mɔ a laa don awɔrɔfɔɔ kamaasɛ abono nyamesɛ gi ti wu kerɛ kpɛ kyu lii ko‑o ibono Wurubuaarɛ gi lɛɛ soso de gɛsɛ mɔ baa lii de ndɛ mɔ. Gɛnen awɔrɔfɔɔ abono ɔnan kee a maŋ baa ba gɛkaako. ");
INSERT INTO acd_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛꞌ nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ so mɔ, ɔ keda awɔrɔfɔɔ nkɛ nbono kɔɔgɛ. Iŋ gyɛ gɛnen mɔ, nkana pɛi de nkɛ mɔ giꞌ baa logɛ mɔ, iŋ baa san ba‑a isa. ");
INSERT INTO acd_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Gɛnen owi ɔbono mɔ, ako mɛ laa tɔgɛ yɛɛ, ‘Kerɛ, ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ aye mɔ ne gɛrɛ.’ Ako, mɔ, mɛ laa tɔgɛ yɛɛ, ‘Mɔ ne n gyɛ ɔdɛ.’ Nengyene mɛ tɔgɛ fɛye gɛnen mɔ, fɛ mɛŋ sa fɛꞌ sɔɔ imɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","I kya nyiile yɛɛ gɛnen owi ɔbono mɔ, i laa nyɛ abonbo ako. Ɔko laa tɔgɛ yɛɛ, ‘Me ne n gyɛ ɔbono Wurubuaarɛ gi tɔgɛ yɛɛ ɔ laa sun mɔ.’ Ɔbanban, mɔ, laa tɔgɛ yɛɛ, ‘N gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo.’ Mɛ laa wɔra ilaa ibono i kya dɛ gɛnɔ de ilaa ibono i kya lɛɛ ɔlon belɛ nyiile mɔ. Nkana mɔmɔ-ilaa wɔrasɛ mɔ i laa penɛ asa abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛꞌ nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ gbaa. I maŋ kii sa gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Imɔso fɛ wu gɛnen ilaa idɛana mɔ, fɛꞌ nyingi yɛɛ nɛ wolaa gyɔ fɛye imɔ so ɔwɔlii yela. ");
INSERT INTO acd_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Nengyene ako mɛ tɔgɛ fɛye yɛɛ, ‘Fɛꞌ kerɛ, ɔ bo gipen dɔ’ mɔ, fɛŋ sa fɛꞌ buu mɔmɔ kpe nno. Ne mɛ kii tɔgɛ yɛɛ, ‘Fɛꞌ kerɛ, ɔ bo obu dɔ’ mɔ, fɛŋ sa fɛꞌ sɔɔ imɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","I lii fɛɛ owi ɔbono me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kii ba gɛsinkpan so mɔ, i laa wɔra daa fɛɛ gɛnɔɔbono nyangbon kya kyan gikolon kel‑l lii owi ɔbaaliiten kpaa lii owi ɔtɔrɔten ne i kya wu gɛsinkpan so pɛwu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Nfono gɛbuɛ wusɛ gɛ dɛ mɔ, nno ne ipatɛɛ mɛ kya da gikilen. ");
INSERT INTO acd_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Awɔrɔfɔɔ mɔ nkɛ mɔ gi baa kyon mɔ, owi laa biiri. Bosɛ laa yela asa gikulaa. Agyɛkpebi a laa kyigi giyan-giyan. Wurubuaarɛ laa keda ilaa ibono i bo soso mɔ gyigisi. ");
INSERT INTO acd_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Nfono mɔ asa mɛ laa wu ilaa ibono i laa lɛɛ nyiile yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n kya laarɛ nꞌ kii ba gɛsinkpan so mɔ. Mɛ wu imɔ gɛnen mɔ, gɛsinkpan so asa kpɛi-kpɛi pɛwu mɛ laa saawo. Mɛ laa wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan naa lii Wurubuaarɛ awolɛ dɔ n kya ba, n dɛ nyisigyi de ɔlon belɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Nan yɛgɛ gɛgandan belɛ gɛꞌ su de nꞌ sun Wurubuaarɛ dɔ isɔɔ de mɛꞌ kpaa koola asa abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛꞌ nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ. Mɛ laa koola-koola mɔmɔ lii gɛsinkpan gɛdɛ gɛten kamaasɛ pɛwu so.” ");
INSERT INTO acd_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Ne Yesu gi tɔgɛ yɛɛ, “Fɛꞌ kasɛ ilaa lii gifeeya oyii so. Aye gɛrɛ mɔ, nengyene fɛ wu gifeeya ngyalenbi gi punge ne gi kya pɔrɔgɛ afɛdaa mɔ, fɛ kya bii yɛɛ gikyɛ gi kya fuude ne. ");
INSERT INTO acd_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Gɛnen kee ne i dɛ ne. Nengyene fɛ wu ilaa ibonoana nɛ tɔgɛ sa fɛye faa mɔ, fɛꞌ bii yɛɛ me-gikiiba gɛsinkpan so mɔ gi tansi fuude ne. N ti n yelɛ fɛye-gɛbunono gbaa-gbaa. ");
INSERT INTO acd_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa. Gɛsinkpan so asa adɛ mɛ maŋ wuꞌ logɛ pɛi de gɛnen ilaa idɛana pɛwu iꞌ lɔɔ ba. ");
INSERT INTO acd_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Soso de gɛsɛ i laa yela ɔkara. Me-agyɛbi mɔ berɛ, a maŋ yela ɔkara gɛkaako kpa‑a. ");
INSERT INTO acd_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Gɛkɛ gɛbono abɛɛ owi ɔbono nan kii ba mɔ berɛ, ɔko mɛŋ nyi. Wurubuaarɛ dɔ isɔɔ gbaa mɛ mɛŋ nyi, ne me, Wurubuaarɛ mɔ-bi mɔ kee, meŋ nyi. Gɛnen mɔ, me-sɛ Wurubuaarɛ mɔ-nkon ne n nyi. ");
INSERT INTO acd_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, gikiiba gɛsinkpan so mɔ i kya fuude mɔ, i laa wɔra daa fɛɛ Nowa aberɛ dɔ-lɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Imɔ ne n gyɛ yɛɛ pɛi de nkyu gi lɔɔ gyi asa Nowa aberɛ mɔ dɔ mɔ, asa mɛ kpɛ san mɛ dɛ mɔmɔ-gɛkyena dɔ laawɔra, fɛɛ gigyi, ginun, de gɛdena gɛnen‑n kaaborɛ gɛkaabono Nowa gi dii loo gikolii mɔ dɔ mɔ. Ɔ loo gikolii mɔ dɔ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","nkyu mɔ gi baa gyi asa mɔ pɛwu, ibono mɛ mɛŋ dɛsɛ. Gɛnen kee ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ, gikiiba gɛsinkpan so mɔ i laa wɔra ne. ");
INSERT INTO acd_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Gɛnen gɛkɛ gɛbono mɔ, i laa nyɛ fɛɛ asa anyɔ mɛ yelɛ ndɔɔ dɔ dabɔlɛ. Wurubuaarɛ laa baa puru ɔko de ɔꞌ taa ɔko yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Akyii anyɔ mɛ yelɛ dabɔlɛ mɛ kya kɔrɔ fɛɛ awayu mɔ, Wurubuaarɛ laa puru ɔko de ɔꞌ taa ɔnyɔsɛ mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Imɔso fɛꞌ dɛsɛ fɛye-nyoro so gyoo me-giba. Fɛ mɛŋ nyi gɛkaabono me, fɛye-wura mɔ, nan kii ba mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Yesu gi da imɔ so gikpalɛ yɛɛ, “Iŋ gyɛ fɛye gbaa-gbaa fɛ nyi? Nkana gɛten wura nyi yɛɛ owi baarɛ ɔkara ne oyu laa ba mɔ, naafo ɔ maŋ dɛ ginsi gidɛ. Ɔ laa dii mɔ-gɛten de oyu ɔŋ sa ɔꞌ nyɛ boori loo gɛmɔ dɔ yuuri mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Gɛnen kee ne i kaaborɛ fɛꞌ bii fɛye-nyoro akedabi owi kamaasɛ dɔ ne. I kya nyiile yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan lii Wurubuaarɛ dɔ kii ba daa owi ɔbono fɛ mɛŋ dɛsɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Nfono mɔ, Wura Yesu gi kii da mɔmɔ gikpalɛ yɛɛ, “Anɛ ne n dɛ fɛɛ dega ɔbono ilaa nan baa tɔgɛ faa? Ɔ kya gyi gɛsintin sa mɔ-wura ne o nyi ɔlaako. Mɔ-wura mɔ gi kyu mɔ-gɛten dɔ ilaa wɔra mɔ-abaa dɔ de owi gyisɛ gi fo mɔ, ɔꞌ yɛ agyudɔ sa mɔ-nanboana adega abono kee mɛ tɛ mɔ-wura mɔ asɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nengyene mɔ-wura mɔ gi baa tu mɔ ɔ kya wɔra ibono ɔ yela sa mɔ mɔ, ɔ laa gyi ginsi.” ");
INSERT INTO acd_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne Yesu gi tɔgɛ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, mɔ-wura mɔ laa kyu mɔ-ilaa pɛwu wɔra gɛnen dega ɔbono abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","“To, ne fɛɛ gɛnen dega ɔbono gyɛ nyamesɛ nyɛnyɛn mɔ, foŋbii mɔ, ɔ laa tɔgɛ sa mɔ-nyoro yɛɛ, ‘Ilaa iko i keda me-wura yela.’ ");
INSERT INTO acd_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Fo baa kerɛ mɔ, o yii gɛsɛ ɔ kya daarɛ mɔ-nanboana sɛnsɛ mɔ, ɔ kya gyi ne ɔ kya nun nta ɔ kya boo. ");
INSERT INTO acd_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ɔ kya wɔra gɛnen mɔ, mɔ-wura mɔ laa baa tuule mɔ owi ɔbono ɔ mɛŋ dɛsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ɔ laa tansi biidɛ dega ɔbono giso de ɔꞌ kalɛ mɔ bɔla gikerɛansi awura mɔ so. Osulon de anɛbi giwɛ ne n bo nno.” ");
INSERT INTO acd_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Yesu gi tɔgɛ idɛ ta mɔ, o kii da gikpalɛ giko yɛɛ, “Aꞌ kyu asa abono mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ ilaa kyu kɛserɛ de me-gikpalɛ gidɛ. Abolonbu gudu ne n kyena. Gɛkɛ gɛdɛ mɔ mɛ puru mɔmɔ-ifatela de mɛꞌ kpaa gyoo ɔkyiifɔ mɔ-kuli. Nengyene ɔnyen mɔ gi kpii ɔkyii mɔ ɔ kya kpe mɔ-gɛwi mɔ, de mɛꞌ buu ɔmɔ kpaa kyaa de mɛꞌ gyi de mɛꞌ nun kpaa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Gɛnen abolonbu gudu adɛ dɔ mɔ, anun mɛ gyɛ asɛɛbo ne anun banban mɔ mɛ mɛŋ nyi ɔlaako. ");
INSERT INTO acd_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Abolonbu mɔ mɛ kya kpe mɛꞌ kpaa gyoo ɔkyiifɔ mɔ-kuli mɔ gɛnen mɔ, abono mɛ mɛŋ nyi ɔlaako mɔ, mɛ puru mɔmɔ-ifatela mɔ, mɛŋ bii puru ifatela nfɔ baa keda too, nengyene fɛɛ nfɔ gi ta mɔmɔ-ifatela mɔ dɔ mɔ, de mɛꞌ nyɛ kii kɔ wɔra. ");
INSERT INTO acd_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Asɛɛbo mɔ berɛ mɛ puru mɔmɔ-ifatela mɔ, mɛ bii puru ifatela nfɔ keda too. ");
INSERT INTO acd_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Mɛ gyoo ɔkyiifɔ mɔ-kuli mɔ gɛnen mɔ, ɔŋ ba belen, ne ginsi gidɛ gi kyu mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“I baa fo gɛnyɛ de nsana mɔ, mɛ nu ɔko gi lɛɛ gɛnɔ yɛɛ, ‘Ɔkyiifɔ mɔ-kuli mɔ kya ba‑o! Fɛꞌ koso de fɛꞌ kpaa gyangara mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Nfono ne abolonbu gudu mɔ mɛ koso diirɛ mɔmɔ-ifatela mɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Anun abono mɛŋ nyi ɔlaako mɔ, mɛ kolɛ asɛɛbo mɔ yɛɛ, ‘Aye-ifatela i kya wu. Fɛꞌ sa aye nfɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Asɛɛbo mɔ mɛ kine yɛɛ, ‘Kuaa. Ibono a dɛ mɔ i maŋ fo aye‑rɛ fɛye. Fɛꞌ kpe ɔfɛten de fɛꞌ kpaa sɔɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Gɛsintin mɔ, abono mɛŋ nyi ɔlaako mɔ mɛ koso kyon ɔfɛten mɔ. Mɔmɔ-gɛmara mɔ, ɔkyiifɔ mɔ-kuli mɔ gi ba, ne abolonbu abono mɛ bii baala mɔmɔ-nyoro gyoo mɔ mɔ mɔmɔ‑rɛ mɔ mɛ san naa loo gɛten dɔ de mɛꞌ kpaa gyi de mɛꞌ nun de mɛꞌ kyaa. Mɛ loo mɔ, mɛ keda gisin tii wɔra mɔmɔ-nyoro. ");
INSERT INTO acd_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Iŋ kɛɛla iko mɔ, abono mɛŋ nyi ɔlaako mɔ mɛ kpaa ba, mɛ kya ŋmɛɛ gisin yɛɛ, ‘Ɔbelɛnsɛ, Ɔbelɛnsɛ, tigi aye!’ ");
INSERT INTO acd_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ne ɔkyiifɔ mɔ-kuli mɔ gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, ‘Gɛsintin ne n boran, meŋ nyi fɛye.’ ” ");
INSERT INTO acd_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ tɔgɛ yɛɛ, “Fɛꞌ dɛsɛ fɛye-nyoro so. I lii fɛɛ fɛ mɛŋ nyi gɛkɛ gɛbono abɛɛ owi ɔbono nan kii ba mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Me-gikiiba mɔ i laa wɔra fɛɛ gikpalɛ gibono nan ba da faa. Imɔ ne n gyɛ yɛɛ ɔbelɛnsɛ ɔko kya laarɛ oꞌ kpe ɔkpa. Imɔso ɔ terɛ mɔ-adega ba mɔ asɛ ne o kyu mɔ-ilaa wɔra mɔmɔ-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ne ɔ yɛ mɔ-sika kɔkɔɔ sa mɔmɔ, ɔkamaasɛ gi nyɛ gɛnɔɔbono ɔkara ɔ laa bii kerɛ imɔ so mɔ. Ɔko gi nyɛ sika kɔkɔɔ abi nwɛ ikue-inyɔ de saalaa, ne ɔbanban gi nyɛ sika kɔkɔɔ abi nwɛ oko, ne ɔsasɛ, mɔ, gi nyɛ sika kɔkɔɔ abi nwɛ gudu. Ɔ yɛ sika kɔkɔɔ mɔ sa mɔmɔ gɛnen mɔ, o yii kyon mɔ-ɔkpa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ɔ kpɛ kyon mɔ, dega gyangbarasɛ ɔbono ɔ nyɛ sika kɔkɔɔ abi nwɛ ikue-inyɔ de saalaa mɔ, ɔ kpaa fɛ sika kɔkɔɔ mɔ nyɛ aterenbi ɔ dɛ ɔ kya buɛɛdɛ, ne o kii nyɛ sɔɔ sika kɔkɔɔ ɔbono ɔbelɛnsɛ mɔ gi kyu wɔra mɔ-abaa dɔ mɔ ɔnan gikpadɔ ginyɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Gɛnen kee ne dega ɔbono ɔ nyɛ sika kɔkɔɔ abi nwɛ oko mɔ gi kpaa fɛ sika kɔkɔɔ mɔ nyɛ aterenbi kyu buɛɛdɛ. Ɔ buɛɛdɛ mɔ, o kii nyɛ sɔɔ sika kɔkɔɔ ɔbono ɔbelɛnsɛ mɔ gi kyu wɔra mɔ-abaa dɔ mɔ ɔnan gikpadɔ ginyɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Dega ɔbono ɔ nyɛ sika kɔkɔɔ abi nwɛ gudu mɔ gi kpaa kuru ɔbɔ, ne o kyu mɔ-ɔbelɛnsɛ sika kɔkɔɔ mɔ ŋara nno. ");
INSERT INTO acd_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ɔbelɛnsɛ mɔ gi kɛɛla nfono o kpe mɔ. Ɔ ba mɔ, ɔ terɛ mɔ-adega yɛɛ mɛꞌ baa buu-buu agyan abono ɔkamaasɛ gi nyɛ mɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Dega ɔbono ɔ nyɛ sika kɔkɔɔ abi nwɛ ikue-inyɔ de saalaa mɔ o kyu amɔ-ɔnan gikpadɔ ginyɔ ba, ne ɔ tɔgɛ sa mɔ-ɔbelɛnsɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, sika kɔkɔɔ abi nwɛ ikue-inyɔ de saalaa ne fo kyu sa me. Amɔ ne. Kerɛ, nɛ nyɛ amɔ-ɔnan kii bɔla.’ ");
INSERT INTO acd_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Ɔbelɛnsɛ mɔ gi nu gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, ‘Fo wɔra ilaa; fɔɔꞌkpon. Fo gyɛ dega dɛnsɛ ne fo kya gyi gɛsintin. Fɛɛ gɛnɔɔbono fo gyi gɛsintin ilaa pii idɛ dɔ faa mɔ, nan kyu ilaa gikyɔ kyu wɔra fo-abaa dɔ. Ba de me‑rɛ fo aꞌ gyi ɔkon dabɔlɛ.’ ");
INSERT INTO acd_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Dega ɔbono ɔ nyɛ sika kɔkɔɔ abi nwɛ oko mɔ kee gi baa tɔgɛ sa ɔbelɛnsɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, sika kɔkɔɔ abi nwɛ oko ne fo kyu sa me; kerɛ, nɛ nyɛ amɔ-ɔnan kii bɔla.’ ");
INSERT INTO acd_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Ɔbelɛnsɛ mɔ gi tɔgɛ sa ɔbono kee yɛɛ, ‘Fo wɔra ilaa; fɔɔꞌkpon. Fo gyɛ dega dɛnsɛ ne fo kya gyi gɛsintin. Fɛɛ gɛnɔɔbono fo gyi gɛsintin ilaa pii idɛ dɔ faa mɔ, nan kyu ilaa gikyɔ kyu wɔra fo-abaa dɔ. Ba de me‑rɛ fo aꞌ gyi ɔkon dabɔlɛ.’ ");
INSERT INTO acd_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Nfono mɔ dega ɔbono ɔ nyɛ sika kɔkɔɔ nwɛ gudu mɔ gi baa tɔgɛ sa mɔ-ɔbelɛnsɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, nɛ wu yɛɛ fo-ilaa i bo lon, fo bo onsipara. Fo kya laarɛ agyan lii gɛsun gɛbono iŋ gyɛ fo ne n wɔra gɛmɔ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Imɔso nɛ selɛ fo gifuu, ne nɛ kyu fo-sika kɔkɔɔ mɔ kyu kpaa ŋara ɔbɔ dɔ. Kerɛ, fo-sika kɔkɔɔ mɔ ne.’ ");
INSERT INTO acd_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Dega mɔ gi tɔgɛ gɛnen mɔ, ɔbelɛnsɛ mɔ gi tɔgɛ sa mɔ yɛɛ, ‘Fo gyɛ dega nyɛnyɛn, ne fo bo wolɛgyɔ. Fo nyi yɛɛ me-ilaa i bo lon. N gyɛ onsipara wura. N kya laarɛ agyan lii gɛsun gɛbono iŋ gyɛ me ne n wɔra mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Ne i wonɛ so ne foŋ kyu me-sika kɔkɔɔ mɔ kyu kpaa fɛ de foꞌ kyu aterenbi abono fo laa nyɛ mɔ kpaa yela aterenbi ɔyelaten de owi ɔbono nɛ ba ne nan kpaa lɛɛ amɔ mɔ, nꞌ nyɛ de aꞌ korogɛ sa me?’ ");
INSERT INTO acd_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Nfono mɔ ɔbelɛnsɛ mɔ gi tɔgɛ sa abono mɛ yelɛ nno mɔ yɛɛ, ‘Fɛꞌ sɔgɛ me-sika kɔkɔɔ mɔ lii dega baarɛ asɛ kyu bɔla ɔbono ɔ nyɛ agyan nwɛ ikue-inyɔ de saalaa mɔ lɛɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","I kya nyiile yɛɛ ɔbono ɔ bo ne ɔ kya kyu wɔra ilaa mɔ, ɔ laa kii nyɛ too de iꞌ tansi nyaakyɔ sa mɔ. Ne ɔbono, mɔ, ɔŋ bo ne ɔŋ kya wɔra sɛi mɔ, ipii ibono ɔ nyɛ mɔ gbaa mɛ laa sɔgɛ imɔ lii mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Fɛꞌ kyu dega ɔbono ɔŋ bo agyan faa kyu lii me asɛ kpaa too wɔra nfono i bo gibiri mɔ. Osulon de anɛbi giwɛ ne n bo nno.’ ” ");
INSERT INTO acd_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Yesu gi tɔgɛ yɛɛ, “Gɛkaako mɔ, me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kii ba gɛsinkpan so de nꞌ baa gyi gɛwura de nyisigyi. Nan kii ba mɔ, me‑rɛ Wurubuaarɛ dɔ isɔɔ ne nan ba de nꞌ kpelegɛ kyena me-gɛwuragyapaa so. ");
INSERT INTO acd_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Nfono mɔ, asa kpɛi-kpɛi pɛwu mɛ laa koola baa gyanꞌ me-ansi dɔ. Nan kyɛɛ ilaa dɛnsɛ awɔrabo lɛɛ lii asa sɛnsɛ dɔ fɛɛ gɛnɔɔbono nbuɛ ɔkparɛbo kya kyɛɛ mɔ-isandɛ lɛɛ lii itiidɛ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Nɛ kyɛ asa mɔ dɔ mɔ, nan kyu ilaa dɛnsɛ awɔrabo mɔ yela me-gibaa gyisɛ so, de nꞌ kyu asa sɛnsɛ mɔ, mɔ, yela me-benɛ gibaa so. ");
INSERT INTO acd_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Nfono mɔ me ɔbono n gyɛ wura mɔ nan tɔgɛ sa abono mɛ yelɛ me-gibaa gyisɛ so mɔ yɛɛ, ‘Fɛye berɛ, fɛ wɔra amudɛnsɛbo me-sɛ Wurubuaarɛ asɛ. Fɛꞌ baa kyena mɔ asɛ mɔ-gɛwuragyi mɔ dɔ. Ɔ wolaa lɔrɔ nno yela sa fɛye lii ko‑o aberɛ abono ɔ lɛɛ soso de gɛsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","I kya nyiile yɛɛ owi ɔbono akon a dɛ me mɔ, fɛ sa me agyudɔ; bolefɔ kya mɔɔ me mɔ, fɛ sa me nkyu, n gyɛ isafo fɛye-isowolɛ so mɔ, fɛ keda me-gisafo, ");
INSERT INTO acd_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","meŋ bo gikuru bunsɛ abɛɛ gɛgbɛ suusɛ mɔ, fɛ sa me; nɛ lɔ mɔ, fɛ kerɛ me so; ne mɛ keda me tii de obu mɔ, fɛ kpaa laa me.’ ");
INSERT INTO acd_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Nfono mɔ, ilaa dɛnsɛ awɔrabo mɔ mɛ laa taasɛ me yɛɛ, ‘Aye-wura, gɛmenkɛ ne a wu fo yɛɛ akon a dɛ fo ne a sa fo agyudɔ, abɛɛ bolefɔ kya mɔɔ fo ne a sa fo nkyu? ");
INSERT INTO acd_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Gɛmenkɛ ne fo ba aye-ɔsowolɛ so ne a keda fo gisafo, abɛɛ a wu yɛɛ foŋ bo gikuru abɛɛ gɛgbɛ ne a sa fo? ");
INSERT INTO acd_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Gɛmenkɛ ne a wu fo fo kya lɔ abɛɛ mɛ tii fo de obu, ne a kpaa laa fo?’ ");
INSERT INTO acd_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Me ɔbono n gyɛ wura mɔ nan lɛɛ gɛnɔ sa mɔmɔ yɛɛ, ‘Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, owi ɔbono fɛ wɔra gɛnen ilaa idɛana sa me-nanboana adɛ dɔ ɔko, ba‑a gɛbii pii ne ɔ gyɛ mɔ, me ne fo wɔra sa gɛnen.’ ");
INSERT INTO acd_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Nfono mɔ, nan tɔgɛ sa abono mɛ yelɛ me-benɛ gibaa so mɔ yɛɛ, ‘Fɛye berɛ, Wurubuaarɛ gi tɔgɛ nnɔ wɔra fɛye. Fɛꞌ naa me asɛ kpe ɔgya ɔbono ɔŋ kya wuꞌ gɛkaako mɔ dɔ! Wurubuaarɛ gi baala ɔgya ɔbono yela sa ilaa nyɛnyɛn pɛwu gɛmu mɔ mɔ‑rɛ mɔ-isɔɔ. ");
INSERT INTO acd_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","I lii fɛɛ owi ɔbono akon a dɛ me mɔ, fɛŋ sa me agyudɔ; bolefɔ kya mɔɔ me mɔ, fɛŋ sa me nkyu; ");
INSERT INTO acd_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nɛ gyi gisafo fɛye-isowolɛ so mɔ, fɛŋ sɔɔ me abaa anyɔ; meŋ bo gikuru bunsɛ abɛɛ gɛgbɛ suusɛ mɔ, fɛŋ sa me; nɛ lɔ abɛɛ mɛ keda me tii de obu mɔ, fɛŋ kpaa laa me.’ ");
INSERT INTO acd_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Nfono mɔ, mɛ laa taasɛ me yɛɛ, ‘Aye-wura, gɛmenkɛ ne a wu fo yɛɛ akon a dɛ fo abɛɛ bolefɔ kya mɔɔ fo abɛɛ fo kya gyi gisafo abɛɛ foŋ bo gikuru abɛɛ gɛgbɛ abɛɛ fo kya lɔ abɛɛ mɛ keda fo tii de obu, ne a mɛŋ kerɛ fo so?’ ");
INSERT INTO acd_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nan lɛɛ gɛnɔ sa mɔmɔ yɛɛ, ‘N kya tɔgɛ fɛye gɛsintin yɛɛ gɛnɔɔbono fɛŋ kpaa me-nanboana adɛ dɔ ɔko, ba‑a gɛbii ne ɔ gyɛ mɔ, me ne fɛŋ kpaa gɛnen.’ ");
INSERT INTO acd_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Nfono mɔ, gɛnen asa abono mɛ laa kpe daa nfono Wurubuaarɛ laa biidɛ mɔmɔ-giso gɛkpaa-gɛkpaa mɔ. Ilaa dɛnsɛ awɔrabo mɔ berɛ, mɛ laa nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Yesu gi nyiile asa ilaa idɛ pɛwu ta mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Fɛɛ gɛnɔɔbono fɛ nyi mɔ, i san nkɛ nnyɔ de aꞌ gyi aye-Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ. Gɛnen gɛkɛ belɛ gɛbono gigyi dɔ mɔ, mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra me-akyobo abaa dɔ de mɛꞌ da me aŋanbi oyii so mɔɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ abelɛnsɛ sɛnsɛ mɔ mɛ kpaa gyanꞌ Kayifasɛ gɛwi. Kayifasɛ ne n gyɛ mɔmɔ-asunbi alɛɛbo gɛmu. ");
INSERT INTO acd_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Mɛ gyanꞌ gɛnen mɔ, mɛ da gɛnɔ gɛnɔɔbono mɛ laa ŋara keda Yesu de mɛꞌ mɔɔ mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Mɛ tɔgɛ yɛɛ iŋ kaaborɛ mɛꞌ mɔɔ mɔ gɛsi mɔ gigyi dɔ; iŋ gyɛ gɛnen mɔ, i laa naa bara ikɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Yesu gi kpe Bɛtani ɔsowolɛ so. Ɔ bo nno mɔ, o kpe Simon ɔbono nkana ɔ gyɛ okononbu mɔ gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mɛ wɔra agyudɔ, Yesu tɛ ɔ kya gyi mɔ, ɔkyii ɔko gi ba mɔ asɛ, ɔ dɛ puruntuwa dɛnsɛ ɔko de anuwanterɛ boɔgyalonsɛ. Ɔ fo Yesu asɛ mɔ, ɔ kyɛɛgɛ anuwanterɛ mɔ worogɛ mɔ-gimu so. ");
INSERT INTO acd_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Yesu akasɛbo mɔ mɛ wu gɛnen mɔ, i loo mɔmɔ, ne mɛ taasɛ yɛɛ, “Menɛ n wɔra ne ɔkyii baarɛ gi gyi anuwanterɛ mɔ gyɛrɛbi faa? ");
INSERT INTO acd_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Anuwanterɛ baarɛ mɛn wɔra ɔfɛsɛ mɔ, nkana a laa nyɛ aterenbi belɛ de aꞌ kyu yɛ sa ayenbo!” ");
INSERT INTO acd_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Yesu gi nu mɔmɔ asɛ, imɔso ɔ tɔgɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya nyala ɔkyii baarɛ? Ilaa dɛnsɛ ne ɔ wɔra sa me faa. ");
INSERT INTO acd_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ayenbo abono fɛ darɛ faa, mɛ bo fɛye asɛ adaa-adaa. Me berɛ fɛ maŋ nyɛ me nꞌ kyena fɛye asɛ kpaa lii. ");
INSERT INTO acd_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ɔ kyɛɛgɛ anuwanterɛ baarɛ worogɛ me-gimu so faa mɔ, o gyere me yela gyoo me-gipule ne. ");
INSERT INTO acd_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Fɛꞌ sɔɔ gibui yela. Gɛsinkpan so gɛten kamaasɛ gɛbono mɛ laa tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ kyu lii me so mɔ, mɛ laa tɔgɛ ilaa ibono ɔkyii baarɛ gi wɔra sa me faa kee kyu nyingi mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Imɔ idɛ gɛmara mɔ, Gyudasɛ Isikaayɔtɛ ɔbono ɔ gyɛ Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko gi kpe kpaa wu Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ne ɔ taasɛ mɔmɔ yɛɛ, “Nengyene nɛ taalɛ kyu Yesu wɔra fɛye abaa dɔ mɔ, menɛ ne fɛ laa sa me?” Nfono mɔ, abelɛnsɛ mɔ mɛ kalɛ aterenbi boduduusɛ ako abi oko de saalaa kyu sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","San kyu lii nfono mɔ, Gyudasɛ gi san ɔ kya kerɛ ɔkpa ɔbono so ɔ laa yɛgɛ abelɛnsɛ mɔ mɛꞌ nyɛ Yesu mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Gɛkɛ gɛbono Bodobodo Maadiisɛ Agyiberɛ mɔ gɛ kya yii gɛsɛ mɔ, Yesu akasɛbo mɔ mɛ ba mɔ asɛ baa taasɛ mɔ yɛɛ, “Fonɛ ne fo kya laarɛ aꞌ kpaa baala de aꞌ gyi Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛꞌ naa loo nten dɔ de fɛꞌ kpaa tɔgɛ sa ɔnyen ɔko yɛɛ, ‘Me, fɛye-onyiilebo mɔ yɛɛ, “Me-owi gi fo. Fo-gɛten dɔ ne me‑rɛ me-akasɛbo a laa baa kyena de aꞌ gyi Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ agyudɔ mɔ.” ’ ” ");
INSERT INTO acd_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Yesu akasɛbo mɔ mɛ kpaa wɔra fɛɛ gɛnɔɔbono ɔ tɔgɛ sa mɔmɔ mɔ, ne mɛ kerɛ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ agyudɔ mɔ yela nno. ");
INSERT INTO acd_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","I fo gɛdɔɔdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo gudu anyɔ mɔ mɛ kpe ogyiten mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Mɛ kya gyi mɔ, Yesu gi tɔgɛ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, fɛye dɔ ɔko laa yɛgɛ me-akyobo mɛꞌ nyɛ me.” ");
INSERT INTO acd_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Yesu gi tɔgɛ gɛnen mɔ, i wɔra mɔ-akasɛbo mɔ ayen gikyɔ, ne mɛ san mɛ kya taasɛ mɔ ɔko-ɔko yɛɛ, “Me-wura, imɔso me ne nan wɔra fo gɛnen?” ");
INSERT INTO acd_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Ɔbono ɔ laa yɛgɛ me-akyobo mɛꞌ nyɛ me mɔ me‑rɛ kaasɛ ne n kya wɔra abaa gyi lɛpɛ kolon dɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","I bo no yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan wuꞌ lɛwu ɔbono ɔnan mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ kyu lii me so mɔ. Ɔbono ɔ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra me-akyobo abaa dɔ mɔ berɛ, mɔ laako. I mɛŋnan korogɛ mɔ mɔ, i boran sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Nfono mɔ Gyudasɛ ɔbono ɔ laa kyu Yesu wɔra mɔ-akyobo abaa dɔ mɔ gi taasɛ Yesu yɛɛ, “Ɔbelɛnsɛ, me ne nan wɔra fo gɛnen?” Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fo-gɛnɔ dɔ ne i lii.” ");
INSERT INTO acd_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mɛ san mɛ kya gyi mɔ, Yesu gi puru bodobodo keda, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa-gbaa mɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ sɔɔ de fɛꞌ gyi. Me-nyoro ne.” ");
INSERT INTO acd_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","O puru konkon de nta kee keda, o kyu afaala sa Wurubuaarɛ, ne o kyu nta mɔ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛye pɛwu fɛꞌ sɔɔ de fɛꞌ nun kɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Nta nbono n dɛ mi‑i sa fɛye faa, me-nkalan ne. Nan wuꞌ mɔ, me-nkalan gi laa kyɛɛgɛ fuɛ sa asa sakyɔ de Wurubuaarɛ ɔꞌ yɛgɛ mɔmɔ‑rɛ mɔ mɛꞌ nyɛ wɔra gɛnɔ pobɔrɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nꞌ tɔgɛ fɛye yɛɛ pɛi ne nan kii nun nta fafaanan mɔ, gɛnen mɔ, gɛkaabono me‑rɛ fɛye a tɛ a kya nun nmɔ npobɔrɔ me-sɛ Wurubuaarɛ gɛwuragyi mɔ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ gyi ta mɔ, mɛ bii afaala ɔlon sa Wurubuaarɛ, ne mɛ lii kyon Nfɔ Iyii Gibii mɔ so. ");
INSERT INTO acd_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mɛ kya kpe mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Ndɛ gɛnyɛ gɛdɛ fɛye pɛwu fɛ laa selɛ taa me yɛgɛ. I kya nyiile yɛɛ mɛ wolaa ŋmarasɛ me-ilaa yela Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, ‘Wurubuaarɛ laa mɔɔ isandɛ ɔkparɛbo mɔ. I ba gɛnen mɔ, isandɛ gikpen mɔ gi laa yaasɛ giyan-giyan.’ ” ");
INSERT INTO acd_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne Yesu gi kii tɔgɛ yɛɛ, “Nɛ kyingi lii ibuni dɔ mɔ, nan gyangbara fɛye kpe Galeli.” ");
INSERT INTO acd_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Nfono ne Piita gi tɔgɛ sa Yesu yɛɛ, “Ba‑a me-nanboana pɛwu mɛ laa selɛ taa fo yɛgɛ mɔ, me berɛ maŋ selɛ taa fo yɛgɛ kpa‑a.” ");
INSERT INTO acd_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Yesu gi tɔgɛ sa mɔ yɛɛ, “Sɔɔ gibui yela, ndɛ gɛnyɛ gɛdɛ gbaa, pɛi de kyaasɛ gyangbarasɛ ɔꞌ lɔɔ folɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” ");
INSERT INTO acd_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piita gi lɛɛ gɛnɔ yɛɛ, “Ba‑a mɛ laa mɔɔ me‑rɛ fo mɔ, maŋ sorogɛ yɛɛ meŋ nyi fo.” Ne Yesu akasɛbo sɛnsɛ mɔ mɛ tɔgɛ gɛnen kee. ");
INSERT INTO acd_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpe gɛtɛɛko, mɛ kya terɛ nno yɛɛ Gɛsɛmeni. Mɛ fo nno mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kyena gɛrɛ gyoo me. Nan tu kpe faanaa kpaa dalaa.” ");
INSERT INTO acd_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ɔ yɛgɛ Piita mɔ‑rɛ Sɛbedi mɔ-biana anyɔ mɔ berɛ mɛ buu mɔ. Mɛ kya kpe mɔ, mɔ-gisen dɔ i yii gɛsɛ i kya dɛɛ mɔ, ne mɔ-nyoro gi kya togɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “N kya wuꞌ mi‑i fuɛ. I kya laarɛ iꞌ mɔɔ me gbaa. Fɛꞌ kyena gɛrɛ de fɛꞌ dii ilaa kamaasɛ ibono i laa ba mɔ kpaa me.” ");
INSERT INTO acd_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ɔ naa taa mɔmɔ yɛgɛ kpe ansi dɔ ŋmaraa, ne o kyu mɔ-nyoro da bun gɛsinkpan, ɔ kya dalaa ɔ kolɛ Wurubuaarɛ yɛɛ, “Me-sɛ, nengyene i laa sa mɔ, yɛgɛ awɔrɔfɔɔ abono a kya ba me so faa aꞌ kyon gibaafon. Nɛ dabɔlɛ dalaa gɛnen faa mɔ, yɛgɛ fo-lɛɛ fo-gɛlaarɛ ne gɛꞌ wɔra, iŋ gyɛ me-lɛɛ me-gɛlaarɛ.” ");
INSERT INTO acd_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ɔ dalaa gɛnen mɔ, o kii kpe mɔ-akasɛbo asaꞌ mɔ asɛ. Ɔ baa kpe mɔ, mɛ dɛ ginsi gidɛ. O kyingi mɔmɔ, ne ɔ taasɛ Piita yɛɛ, “Imɔso fɛŋ taalɛ kyena ba‑a ŋmaraa de fɛꞌ dii ilaa ibono i laa ba mɔ kpaa me? ");
INSERT INTO acd_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Fɛꞌ dii ilaa ibono i kya ba mɔ de fɛꞌ dalaa yɛɛ imɔ iko i mɛŋꞌ nyɛ fɛye penɛ de fɛꞌ wɔra ilaa nyɛnyɛn. Nɛ wu yɛɛ fɛye-asen dɔ mɔ, nkana fɛ kya laarɛ fɛꞌ wɔra me-gɛlaarɛ, fɛye anyamesɛ-lɛɛ ɔlon ne mɛŋ kya taalɛ.” ");
INSERT INTO acd_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yesu gi kii kyon taa mɔmɔ yɛgɛ ginyɔsɛ kpaa dalaa kolɛ Wurubuaarɛ yɛɛ, “Me-sɛ, nengyene i maŋ sa de awɔrɔfɔɔ abono a kya ba me so faa aꞌ kyon gibaafon sa me berɛ mɔ, yɛgɛ fo-gɛlaarɛ ne gɛꞌ wɔra.” ");
INSERT INTO acd_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ɔ baa kii kpe mɔ-akasɛbo mɔ asɛ mɔ, mɛ kii dɛ. I lii fɛɛ ginsi gidɛ gi dɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yesu gi taa ɔmɔ yɛgɛ ne o kii kpaa dalaa gɛsasɛ. Gɛdalaa kolon gɛbono ne ɔ kpɛ ɔ kya dalaa. ");
INSERT INTO acd_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","46","O kii ba tu mɔ-akasɛbo mɔ, o kyingi mɔmɔ, ne ɔ taasɛ mɔmɔ yɛɛ, “Fɛ san fɛ dɛ fɛ kya kyoola? Owi mɔ gi fo. Kon ne ilaa nyɛnyɛn awɔrabo mɛ laa nyɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ ne. Fɛꞌ kerɛ. Ɔbono ɔ laa kyu me wɔra mɔmɔ-abaa dɔ mɔ ne n kya ba faa. Fɛꞌ koso de aꞌ gyangara mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yesu san ɔ kya tɔngɛ mɔ, Gyudasɛ, Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko, gi ba nfono. Sakpii belɛ buu mɔ, mɛ dɛ nki de nkpotii. Mɛ lii Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ abelɛnsɛ sɛnsɛ mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Gyudasɛ ɔbono ɔ laa kyu Yesu ɔ kya wɔra abelɛnsɛ mɔ abaa dɔ gɛnen mɔ gi wolaa tɔgɛ sa sakpii mɔ yɛɛ, “Ɔbono fɛ wu nɛ faala mɔ da mɔ gya-gya mɔ, mɔ ne; fɛꞌ keda mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Imɔso mɛ kpaa fo nno mɔ, gɛsintin mɔ, Gyudasɛ gi naa kpe Yesu asɛ, ɔ terɛ mɔ yɛɛ, “Ɔbelɛnsɛ,” ne ɔ faala mɔ da mɔ gya-gya. ");
INSERT INTO acd_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yesu gi tɔgɛ sa mɔ yɛɛ, “Ɔnyen, ilaa ibono fo ba de foꞌ baa wɔra mɔ, wɔra.” Ɔ tɔgɛ mɔ gɛnen mɔ, sakpii mɔ dɔ asa mɛ lii keda Yesu. ");
INSERT INTO acd_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Nfono mɔ, asa abono mɛ bo Yesu asɛ mɔ dɔ ɔko gi loorɛ mɔ-gɛki lɛɛ, ne ɔ ŋɛɛlɛ dega ɔko giso fuɛ. Dega mɔ wura ne n gyɛ asunbi alɛɛbo gɛmu. ");
INSERT INTO acd_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Yesu gi tɔgɛ sa mɔ yɛɛ, “Kiiri gɛki mɔ wɔra gɛmɔ-gifɔrɔ dɔ. Abono mɛ kya kɔ de nki mɔ, nki lɛwu ne mɛ kya wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Fɛ nyi yɛɛ maŋ taalɛ saawo terɛ me-sɛ Wurubuaarɛ de ɔꞌ baa kpaa me? Fɛɛ nɛ saawo terɛ mɔ mɔ, ayaa adɛ so mɔ, ɔ laa sun mɔ-isɔɔ akpen afonɛɛ-afonɛɛ de mɛꞌ kpelegɛ baa kpaa me. ");
INSERT INTO acd_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne fɛɛ mɛ baa kpaa me mɔ, nnɛ ne i laa nyɛ kyena de Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ ilaa? I bo mɔ-ɔwolɛ mɔ dɔ yɛɛ i kaaborɛ gɛnen ilaa idɛ iꞌ ba me so.” ");
INSERT INTO acd_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Mɛ bo nno mɔ, Yesu gi taasɛ sakpii mɔ yɛɛ, “I gyɛ yɛɛ n gyɛ oyu nyɛnyɛn daa ne fɛ kyu nki de nkpotii baa keda me faa? N kya kpaa kyena Wurubuaarɛ ɔson obu gikpaara mɔ so gɛkɛ kamaasɛ n kya nyiile asa ilaa. I wonɛ so ne fɛŋ keda me nno? ");
INSERT INTO acd_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Imɔ idɛ pɛwu i ba me so faa, i kyena daa de ilaa ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ.” Nfono mɔ, mɔ-akasɛbo mɔ pɛwu mɛ selɛ taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Abono mɛ keda Yesu mɔ mɛ kparɛ mɔ kpe Kayifasɛ gɛwi. Mɔ ne n gyɛ Gyuda awura asunbi alɛɛbo gɛmu. Mɔmɔ-nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ abono mɛ kya gyi asa nbɛlɛ mɔ mɛ gyanꞌ mɔ-gɛwi. ");
INSERT INTO acd_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Mɛ dɛ Yesu mɛ kya kpe gɛnen mɔ, Piita gi buu mɔmɔ giyaa-giyaa gɛnen‑n kpaa loo asunbi alɛɛbo gɛmu mɔ gikpaara mɔ so. Ɔ loo nno mɔ, ɔ kpaa kyena saarɛ Wurubuaarɛ ɔson obu mɔ adiibo mɔ dɔ de oꞌ wu ilaa ibono i laa ba mɔ. ");
INSERT INTO acd_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mɛ kya gyi Yesu nbɛlɛ mɔ, asunbi alɛɛbo abelɛnsɛ mɔ de nbɛlɛ agyibo mɔ pɛwu mɛ laarɛ asa abono mɛ laa baa kɛɛ abon gyanꞌ Yesu so de mɛꞌ nyɛ mɔ mɔɔ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","mɛ mɛŋ nyɛ. Asa sakyɔ mɛ baa kɛɛ abon gyanꞌ mɔ so berɛ. Mɛ mɛŋ kii nyɛ abon abono mɛ laa yelɛ amɔ so de mɛꞌ mɔɔ mɔ mɔ. Laalaalogɛ mɔ asa anyɔ ako mɛ lii yelɛ ");
INSERT INTO acd_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","tɔgɛ yɛɛ, “Ɔnyen baarɛ gi tɔgɛ yɛɛ ɔ laa taalɛ boori Wurubuaarɛ ɔson obu mɔ de oꞌ kyu nkɛ nsa kii kyu yii mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Nfono mɔ, asunbi alɛɛbo gɛmu mɔ gi koso yelɛ ne ɔ taasɛ Yesu yɛɛ, “Ibono pɛwu mɛ dɛ ma‑a gyan fo so faa, foŋ bo gɛnɔ lɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Yesu mɛŋ tɔgɛ sɛi. Asunbi alɛɛbo gɛmu mɔ gi kii tɔgɛ sa Yesu yɛɛ, “Ilaa ibono nan baa taasɛ fo faa, ne foŋ tɔgɛ gɛsintin mɔ, fo‑rɛ Wurubuaarɛ ɔbono ɔ bo nno gɛkpaa-gɛkpaa mɔ abaa anyɔ. Imɔso fo ne n gyɛ ɔbono Wurubuaarɛ gi sun fo yɛɛ foꞌ baa gyi gɛwura mɔ-adɛ so mɔ? Fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fo ne n tɔgɛ. N kya buu mi‑i sa fɛye yɛɛ gɛkaako mɔ fɛ laa wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n tɛ Wurubuaarɛ Ɔlolonbo mɔ gyisɛ gibaa so, n kya gyi gɛwura mɔ asɛ, ne nan kyena Wurubuaarɛ awolɛ so kpelegɛ ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Asunbi alɛɛbo gɛmu mɔ gi nu imɔ idɛ mɔ, ɔ biidɛ mɔ-gɛgbɛ kyadɛ de iꞌ nyiile yɛɛ ilaa i ba, ne ɔ tɔgɛ yɛɛ, “Ɔ dɛ mɔ-nyoro ɔ kya kɛserɛ de Wurubuaarɛ! Ilaa imɔ ne a baa a kya laarɛ de aꞌ baa nu lii mɔ asɛ baa don de idɛ? Ilaa ibono ɔ tɔgɛ faa, idɛ kon fɛye gbaa-gbaa fɛ nu de fɛye-aso. ");
INSERT INTO acd_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Menɛ nwɔnsa ne fɛ dɛ?” Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “Ɔ kaaborɛ ɔꞌ wɔra ɔmɔɔsɛ.” ");
INSERT INTO acd_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Nfono mɔ, mɛ too akyɔlɛ wɔra mɔ-ansi dɔ ne mɛ ŋɛ ŋɛ mɔ akɔn. Ako mɛ da mɔ itan, ");
INSERT INTO acd_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ne mɛ tɔgɛ mɔ yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi sun yɛɛ foꞌ gyi gɛwura aye Gyuda awura so mɔ, bii ɔbono ɔ ŋɛ fo mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Piita tɛ gikpaara mɔ so mɔ, obolonbu ɔko gi baa tu mɔ, ne ɔ tɔgɛ sa mɔ yɛɛ, “Fo kee fo‑rɛ Yesu Galelinyen mɔ ne n naa.” ");
INSERT INTO acd_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Piita gi sorogɛ mɔmɔ pɛwu ansi dɔ yɛɛ, “Meŋ nyi ilaa ibono fo kya tɔgɛ faa so.” ");
INSERT INTO acd_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ɔ tɔgɛ gɛnen mɔ, ɔ koso lii kpe gɛten mɔ gɛbunono. Obolonbu ɔko kee gi kii wu mɔ, ne ɔ tɔgɛ sa abono mɛ bo nfono mɔ yɛɛ, “Ɔnyen baarɛ kee mɔ‑rɛ Yesu, Nasarɛtɛnyen mɔ ne n naa.” ");
INSERT INTO acd_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Piita gi ka sa mɔ yɛɛ, “Meŋ nyi gɛnen ɔnyen ɔbono!” ");
INSERT INTO acd_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","I kii wɔra ŋmaraa too mɔ, anyen abono mɛ yelɛ nfono mɔ mɛ naa ba Piita asɛ ne mɛ tɔgɛ yɛɛ, “Gɛsintin fo tansi fo gyɛ ɔmɔ dɔ ɔko. Fo-gɛdɛ atɔgɛbi gbaa i kya nyiile gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Nfono mɔ, Piita gi ka sa mɔmɔ yɛɛ, “Nɛ kerɛ fɛɛ Wurubuaarɛ. Meŋ nyi ɔnyen ɔbono fɛ darɛ faa. Nengyene abon ne nꞌ kya kɛɛ mɔ, me‑rɛ Wurubuaarɛ abaa anyɔ.” Ayaa abono so mɔ, kyaasɛ gi folɛ. ");
INSERT INTO acd_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Nfono mɔ Piita gi nyingi ilaa ibono Yesu gi tɔgɛ sa mɔ mɔ. Yesu gi tɔgɛ sa mɔ yɛɛ, “Ndɛ gɛnyɛ gɛdɛ pɛi de kyaasɛ ɔꞌ baa folɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” Piita gi nyingi gɛnen mɔ, ɔ lii gikpaara mɔ so kpaa su gɛnsipɛɛrɛ so. ");
INSERT INTO acd_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nyɛnyɛngɛ fu‑u mɔ Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ abelɛnsɛ sɛnsɛ abono mɛ kya gyi nbɛlɛ mɔ pɛwu mɛ da gɛnɔ gɛnɔɔbono mɛ laa wɔra de Yesu ɔꞌ wɔra ɔmɔɔsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Imɔso mɛ ŋminde mɔ, ne mɛ kparɛ mɔ kyu kpaa wɔra ɔbelɛnsɛ ɔbono ɔ tɛ sa Rom wura mɔ abaa dɔ yɛɛ oꞌ gyi mɔ-nbɛlɛ. Mɛ kya terɛ gɛnen ɔbelɛnsɛ ɔbono yɛɛ Pilato. ");
INSERT INTO acd_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Gyudasɛ ɔbono ɔ yɛgɛ Yesu akyobo mɛ nyɛ mɔ mɔ gi nu yɛɛ Yesu laa wɔra ɔmɔɔsɛ. Imɔso o nu mɔ-nyoro gɛsɛ yɛɛ ɔ wɔra ilaa nyɛnyɛn. Gɛnen so mɔ o kiiri aterenbi abi oko de saalaa mɔ kperɛ asunbi alɛɛbo abelɛnsɛ mɔ de mɔmɔ abelɛnsɛ sɛnsɛ mɔ, ");
INSERT INTO acd_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Nɛ fɛ ɔnyen ɔbono ɔŋ wɔra ilaa nyɛnyɛn mɔ sa fɛye kaaborɛ ɔ kya laarɛ ɔꞌ nyɛ lɛwu faa, nɛ wɔra ilaa nyɛnyɛn!” Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “Imɔ ibono iŋ fɛ aye-giso. Fo-nkon ilaa ne!” ");
INSERT INTO acd_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mɛ tɔgɛ gɛnen mɔ, Gyudasɛ gi ŋmanyan aterenbi mɔ too mɔmɔ Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so nfono, ne ɔ naa kyon kpaa wɔra mɔ-nyoro ɔfɛ mɔɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Asunbi alɛɛbo abelɛnsɛ mɔ mɛ tɔɔsɛ aterenbi mɔ ne mɛ tɔgɛ yɛɛ, “Aterenbi adɛ mɔ, nkalan aterenbi ne. I lii fɛɛ amɔ ne a kyu sɔɔ isa ɔbono a laa yɛgɛ de ɔꞌ wɔra ɔmɔɔsɛ mɔ, imɔso iŋ dɛ ɔkpa yɛɛ aꞌ kyu amɔ kpaa saarɛ aye-ɔson aterenbi dɔ.” ");
INSERT INTO acd_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mɔmɔ pɛwu mɛ tɔgɛ kyule abara yɛɛ mɛꞌ kyu gɛnen aterenbi mɔ kpaa sɔɔ gɛsinkpan gɛbono mɛ kya terɛ yɛɛ Nlɔbi Ɔpɔrɔbo Gɛsinkpan mɔ de mɛꞌ kyu nno wɔra asafo opuleten. ");
INSERT INTO acd_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Imɔ idɛ so mɔ, asa mɛ yela gɛsinkpan gɛbono ginyen giko yɛɛ Nkalan Gɛsinkpan. Mɛ san ma‑a terɛ gɛnen ginyen mɔ baa lii de ndɛ. ");
INSERT INTO acd_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Imɔ idɛ mɔ i yɛgɛ ilaa ibono Gyɛrɛmaya gi wolaa wu tɔgɛ mɔ i wɔra gɛsintin. Gyɛrɛmaya gi wɔra Wurubuaarɛ ikalan ɔtɔgɛbo. Ɔ tɔgɛ yela yɛɛ, “Isirale awura mɛ kyule yɛɛ mɛ laa sɔɔ mɔ aterenbi boduduusɛ abi oko de saalaa. ");
INSERT INTO acd_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Ne mɛ kyu gɛnen aterenbi mɔ kpaa sɔɔ nlɔbi ɔpɔrɔbo gɛsinkpan. Gɛnen ne Wurubuaarɛ gi tɔgɛ me yɛɛ nꞌ wɔra ne.” ");
INSERT INTO acd_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Ɔbelɛnsɛ Pilato kya gyi Yesu nbɛlɛ mɔ, ɔ taasɛ mɔ yɛɛ, “Fo ne n gyɛ wura sa Gyuda awura mɔ?” Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo-gɛnɔ dɔ ne i lii.” ");
INSERT INTO acd_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Gɛnɔten gɛbono Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de mɔmɔ abelɛnsɛ sɛnsɛ mɔ mɛ ten gyanꞌ Yesu so mɔ berɛ, Yesu mɛŋ tɔgɛ sɛi kyu naa de imɔ so. ");
INSERT INTO acd_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Pilato gi kii taasɛ mɔ yɛɛ, “Foŋ kya nu ilaa ibono pɛwu mɛ dɛ ma‑a gyanꞌ fo so faa?” ");
INSERT INTO acd_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Yesu mɛŋ baa bugi mɔ-gɛnɔ tɔgɛ sɛi, imɔso i tansi dɛ ɔbelɛnsɛ mɔ gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Gɛsi kamaasɛ Gyuda awura mɛ laa gyi mɔmɔ-Lɛwu Gi Sorogɛ Aye So gɛkɛ belɛ mɔ, Pilato kya kyena tigi mɔmɔ-asa abono mɛ tii de obu mɔ dɔ ɔko de kaasɛ ɔꞌ nyɛ mɔ-nyoro naa. Gyuda awura mɔ gbaa-gbaa ne n kya lɛɛ gibaa yii yɛɛ ɔdɛ ne mɛ kya laarɛ, ne Pilato kya tigi mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Gɛnen owi ɔbono dɔ mɔ ɔnyen ɔko tii de obu, mɛ kya terɛ mɔ yɛɛ Yesu Barabasɛ. Asa sakyɔ mɛ nyi mɔ-ilaa so. ");
INSERT INTO acd_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Imɔso asa mɛ koola mɛ yelɛ, ne Pilato gi taasɛ mɔmɔ yɛɛ, “Nꞌ tigi anɛ sa fɛye? Yesu Barabasɛ abɛɛ Yesu ɔbono mɛ kya terɛ mɔ yɛɛ Kirisito mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilato gi wu yɛɛ Yesu ilaa i bo Gyuda awura abelɛnsɛ mɔ gɛlaaloo daa so ne mɛ kyu mɔ bara mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilato san ɔ tɛ nbɛlɛ ogyiten ɔ kya gyi nbɛlɛ mɔ gɛnen mɔ, mɔ-ka gi sun isa mɔ asɛ yɛɛ, “Ɔnyen ɔbono fo kya gyi mɔ-nbɛlɛ faa mɛŋ wɔra ilaa nyɛnyɛn. Imɔso gɛŋ sa foꞌ wɔra mɔ sɛi. Deeri gɛnyɛ nɛ kuu oderi wu mɔ, ne baa lii de ndɛ faa, iŋ gyɛ me ne n tɛ.” ");
INSERT INTO acd_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de abelɛnsɛ sɛnsɛ mɔ mɛ wolaa tɔgɛ wɔra sakpii mɔ yɛɛ mɛꞌ tɔgɛ Pilato yɛɛ oꞌ tigi daa Barabasɛ de ɔꞌ yɛgɛ Yesu ne ɔꞌ wɔra ɔmɔɔsɛ. ");
INSERT INTO acd_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Pilato gi kii taasɛ sakpii mɔ yɛɛ, “Gɛnen asa anyɔ adɛ dɔ mɔ, anɛ ne fɛ kya laarɛ yɛɛ nꞌ tigi sa fɛye?” Mɔmɔ pɛwu mɛ lɛɛ gɛnɔ yɛɛ, “Barabasɛ.” ");
INSERT INTO acd_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mɛ tɔgɛ gɛnen mɔ, Pilato gi taasɛ mɔmɔ yɛɛ, “Mɔ, nnɛ ne nꞌ wɔra Yesu ɔbono mɛ kya terɛ mɔ yɛɛ Kirisito mɔ?” Nfono mɔ asa mɔ pɛwu mɛ lɛɛ gɛnɔ yɛɛ, “Da mɔ aŋanbi mada de oyii de oꞌ wuꞌ!” ");
INSERT INTO acd_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ne Pilato gi taasɛ mɔmɔ yɛɛ, “De iꞌ wonɛ? Menɛ ilaa nyɛnyɛn ne ɔ wɔra?” Nfono mɔ, mɛ lɔrɔ kpen ken-ken daa yɛɛ, “Da mɔ aŋanbi mada de oyii de oꞌ wuꞌ!” ");
INSERT INTO acd_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Pilato gi wu yɛɛ ɔ buɛɛlɛ sakpii mɔ kpon. I kya laarɛ iꞌ bara ikɔ. Gɛnen so mɔ, o kyu nkyu foro mɔ-abaa sakpii mɔ ansi dɔ nfono, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Gɛnen ɔnyen baarɛ lɛwu berɛ, meŋ nyi mɔ so sɛi. Fɛꞌ wolaa bii yɛɛ fɛye ne n yɛgɛ ne ɔ laa wɔra ɔmɔɔsɛ faa.” ");
INSERT INTO acd_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Sakpii mɔ pɛwu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Yɛgɛ mɔ-lɛwu mɔ ɔꞌ sola daa aye‑rɛ aye-biana de aye-naanaana!” ");
INSERT INTO acd_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Mɛ tɔgɛ gɛnen mɔ, Pilato gi tigi Barabasɛ sa mɔmɔ, ne ɔ yɛgɛ asogya mɛ taa Yesu awulibi ne ɔ tɔgɛ yɛɛ mɛꞌ kyu mɔ naa kpaa da mɔ aŋanbi mada de oyii de oꞌ wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Nfono mɔ Pilato asogya mɔ mɛ kyu Yesu kyu loo mɔmɔ-gɛsun ɔwɔraten, ne mɛ terɛ mɔmɔ Rom asogya gikpen pɛwu ba mɔ asɛ nno. ");
INSERT INTO acd_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mɛ luu mɔ-ngbɛ nbono o suu mɔ ne mɛ kyu giwurakuru kyu gyaabii bun mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mɛ luo iwe kyu wɔra fɛɛ wura gɛpɛ kyu bun mɔ-gimu, ne mɛ kyu oyii tugɛsɛ kyu wɔra mɔ-gibaa gyisɛ dɔ fɛɛ ɔ gyɛ daa wura. Mɛ san mɛ kya gyaabii mɛ kya ŋmii mɔ mɛ kya koso mɛ kya faala mɔ yɛɛ, “Gyuda awura wura! Fo‑rɛ gimu dɛnsɛ!” ");
INSERT INTO acd_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mɛ kya too akyɔlɛ ma‑a bun mɔ, ne mɛ sɔgɛ oyii tugɛsɛ mɔ lii mɔ-gibaa dɔ kiiri taa mɔ-gimu dɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mɛ kyɛfoo Yesu gɛnen ta mɔ, mɛ maragɛ giwurakuru mɔ, ne mɛ kiiri mɔ gbaa-gbaa lɛɛ ngbɛ kyu suu mɔ, ne mɛ san kparɛ mɔ lii de mɛꞌ kpaa da mɔ aŋanbi mada de oyii de oꞌ wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Mɛ dɛ Yesu mɛ kya lii ɔsowolɛ mɔ so mɛꞌ kpaa mɔɔ mɔ mɔ, mɛ gyangara ɔnyen ɔko, mɛ kya terɛ mɔ yɛɛ Simon. Ɔ gyɛ daa Siirinnyen. Ne mɛ nyise mɔ yɛɛ ɔꞌ sola Yesu lɛwu oyii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mɛ naa gɛnen kpaa fo gɛtɛɛko, mɛ kya terɛ nno yɛɛ Gologota. (Gologota gɛsɛ ne n gyɛ yɛɛ Gimu Giwuye Gikpalan.) ");
INSERT INTO acd_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Mɛ fo nno mɔ, mɛ kyu ilaa bololosɛ iko kyu wɔra nta dɔ ne mɛ kyu sa Yesu; ɔ da kerɛ mɔ, o kine yɛɛ ɔ maŋ nun. ");
INSERT INTO acd_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Mɛ da Yesu aŋanbi mada de oyii mɔ, ne mɛ yɛ mɔ-nyoro so atɔ kyu. Mɛ kya yɛ atɔ mɔ mɔ, mɛ too ilaa iko kerɛ. Ibono ɔko gi gyi mɔ, o kyu. ");
INSERT INTO acd_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mɛ yɛ atɔ mɔ ta mɔ, mɛ san sii mɛ tɛ mɛ kya dii mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ilaa ibono so mɛ da mɔ aŋanbi oyii so gɛnen mɔ i mada mɔ-amu so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mɛ da iyu inyɔ iko kee aŋanbi lɛwu iyii so fɛɛ Yesu-lɛɛ mɔ. Ɔko bo de Yesu gyisɛ gibaa so ne ɔko, mɔ, bo de mɔ-benɛ so. ");
INSERT INTO acd_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Yesu kyɔlɛ oyii mɔ so gɛnen mɔ, asa abono mɛ kya kyon de nfono mɔ mɛ kya tugi mɔ inosun, ne mɛ kya saalɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Fo ne yɛɛ fo laa boori Wurubuaarɛ ɔson obu mɔ de foꞌ kyu nkɛ nsa kii yii mɔ mɔ? Kii mɔlɛgɛ fo-nyoro! Nengyene fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ gɛsintin mɔ, kpelegɛ lii lɛwu oyii mɔ so de aꞌ kerɛ.” ");
INSERT INTO acd_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Gɛnen kee ne Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de nbara aŋmarasɛbo mɔ de mɔmɔ abelɛnsɛ sɛnsɛ mɔ mɛ yoole mɔ ne. Mɛ kya tɔgɛ ");
INSERT INTO acd_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","yɛɛ, “Mɔ ne n mɔlɛgɛ asa. Ɔ maŋ taalɛ mɔlɛgɛ mɔ-nyoro. Iŋ gyɛ mɔ ne n gyɛ Isirale awura wura mɔ? Oꞌ kii kpelegɛ oyii baarɛ so de aꞌ sɔɔ mɔ gyi! ");
INSERT INTO acd_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Mɔ ne yɛɛ ɔ gyɛ Wurubuaarɛ mɔ-bi mɔ. Mɔ ne n kya ka gyanꞌ Wurubuaarɛ so. Imɔso nengyene Wurubuaarɛ kya laarɛ mɔ-ilaa mɔ, ɔꞌ mɔlɛgɛ mɔ kon de aꞌ kerɛ!” ");
INSERT INTO acd_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ne iyu ibono mɛ da mɔmɔ‑rɛ Yesu aŋanbi mɔ kee mɛ saalɛ mɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","I fo owi ken-ken gerɛ-gerɛ mɔ, i wɔra gibiri sirim gɛnen gɛsinkpan mɔ pɛwu so kaaborɛ owi gbaasɛ. ");
INSERT INTO acd_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Gɛnen owi gbaasɛ ɔbono dɔ mɔ, Yesu gi kpen ken-ken tɔgɛ mɔ-gɛdɛ dɔ yɛɛ, “Ilayi, Ilayi, lama sabakitani?” (Imɔ gɛsɛ ne n gyɛ yɛɛ, “Me-Wurubuaarɛ, me-Wurubuaarɛ, i wonɛ ne fo lɛɛ ansi taa me yɛgɛ gɛnen?”) ");
INSERT INTO acd_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Asa abono mɛ yelɛ nno mɔ ako mɛ nu mɔ asɛ ne mɛ tɔgɛ yɛɛ, “Ɔ kya terɛ Oloobu Ilaagya!” ");
INSERT INTO acd_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nfono mɔ, ɔko gi selɛ kyu taatɔ dufu-dufu ɔko kyu kpaa nyise wɔra mɔmɔ-nta bonyansɛ nko dɔ, ne o kyu de gɛyabii diirɛ kpe Yesu gɛnɔ asɛ yɛɛ ɔꞌ kyogyoo. ");
INSERT INTO acd_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Abono mɛ yelɛ nno mɔ ako mɛ tɔgɛ sa kaasɛ mɔ yɛɛ, “Yelɛ de aꞌ kerɛ yɛɛ Ilaagya laa lii Wurubuaarɛ dɔ baa mɔlɛgɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yesu gi kii kpen ken-ken ne ɔ lɛɛ ɔŋɛ. ");
INSERT INTO acd_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nfono mɔ gikuru gibono gi tii Wurubuaarɛ tudɔ-lɛɛ obu belɛ mɔ gi kyan ginyɔ lii soso baa yii gɛsɛ kyim. Gɛsinkpan gɛ gyigisi, ne afolɛ a boori-boori. ");
INSERT INTO acd_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nkyan nbono gi bo afolɛ dɔ mɔ gi bugi-bugi ne asa abono Wurubuaarɛ gi lɔrɔ ɔmɔ yela sa mɔ-nyoro mɔ sakyɔ mɛ kyingi lii ibuni dɔ, ");
INSERT INTO acd_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ne mɛ lii nkyan mɔ dɔ. Yesu gi kyingi mɔ, imɔ gɛmara mɔ, gɛnen ibuni ibono mɛ naa baa loo Gyɛrusalem ɔsowolɛ ɔbono Wurubuaarɛ gi lɔrɔ yela sa mɔ-ɔson mɔ, ne mɛ lɛɛ mɔmɔ-nyoro gɛwi nyiile asa sakyɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Asogya ɔbelɛnsɛ mɔ mɔ‑rɛ asogya sɛnsɛ abono mɛ kya dii Yesu mɔ mɛ wu gɛsinkpan gigyigisibi mɔ de ilaa ibono i wɔra-wɔra nfono mɔ, i tansi dɛ ɔmɔ-gɛnɔ ne i wɔra ɔmɔ gifuu, ne mɛ tɔgɛ yɛɛ, “Gɛsintin, ɔnyen baarɛ tansi ɔ gyɛ Wurubuaarɛ mɔ-bi!” ");
INSERT INTO acd_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Akyii sakyɔ abono mɛ buu Yesu lii Galeli ba Gyɛrusalem mɛ kya kpaa mɔ mɔ kee mɛ bo nno. Mɛ yelɛ gɛta-gɛta wu ilaa idɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Gɛnen akyii abono dɔ ako ne n gyɛ Mariya Magadalakyii mɔ, de Mariya, Gyeemesi de Gyosɛfo mɔmɔ-nyi, de Sɛbedi mɔ-ka ɔbono ɔ korogɛ Yesu akasɛbo anyɔ ako mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","I baa wɔra gɛdɔɔdɛ mɔ, aterenbi wura ɔko gi ba. Mɛ kya terɛ mɔ yɛɛ Gyosɛfo. Ɔ gyɛ daa Arimatiyanyen, ne ɔ sɔɔ Yesu gyi. ");
INSERT INTO acd_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","O kpe Pilato asɛ ne ɔ kpaa kolɛ mɔ yɛɛ ɔ laa kpaa saga Yesu gibuni mɔ lii lɛwu oyii mɔ so kyu kpaa pule. Pilato gi sa mɔ ɔkpa. ");
INSERT INTO acd_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Imɔso Gyosɛfo gi kpaa saga Yesu gibuni mɔ. O kyu gikɛlɛlɛ kyabi-kyabi kyu mili Yesu gibuni mɔ, ");
INSERT INTO acd_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ne o kyu kpaa pule mɔ Gyosɛfo gbaa-gbaa gɛkyan pobɔrɔ dɔ. Gɛ gyɛ daa folɛbɔ ɔbono ɔ wolaa yɛgɛ mɛ logedi yela sa ibuni gipule mɔ. Nno ne o pule Yesu, ne ɔ belen gibui belɛ-belɛ baa tii ɔbɔ mɔ gɛbunono ne ɔ naa. ");
INSERT INTO acd_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ɔ kya pule Yesu gɛnen mɔ, Mariya Magadalakyii mɔ de Mariya banban ɔko mɔ mɛ tɛ nno mɔmɔ-ansi a sa de gɛkyan mɔ. ");
INSERT INTO acd_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Gɛkaabono Yesu gi wuꞌ mɔ gɛ gyɛ gɛkɛ gɛbono Gyuda awura mɛ kya baala nyoro ma‑a gyoo mɔmɔ-gɛkɛ kyoolasɛ. Imɔ gɛdɛ kɛsɛ mɔ, Gyuda awura asunbi alɛɛbo abelɛnsɛ de Farasii gikpen mɔ dɔ asa mɛ kpaa gyanꞌ Pilato asɛ. ");
INSERT INTO acd_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, a kya nyingi yɛɛ nkɛ nbono gɛnen ɔbonbo mɔ tɛ de ansi mɔ, ɔ tɔgɛ yɛɛ, ‘Nɛ wuꞌ mɔ, imɔ gɛkɛ sasɛ mɔ Wurubuaarɛ laa kyingi me lii ibuni dɔ.’ ");
INSERT INTO acd_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Imɔso sa fo-asogya gɛnɔ yɛɛ mɛꞌ kpaa dii mɔ-gɛkyan mɔ dandan kaaborɛ nkɛ nsa mɔ giꞌ lɔɔ gyanꞌ. Iŋ gyɛ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ laa naa kpaa yuuri mɔ-gibuni mɔ de mɛꞌ kyu naa mɛ kya kɛɛ abon yɛɛ Wurubuaarɛ gi kyingi mɔ lii ibuni dɔ. Gɛnen gɛmara-gɛmara abon abono a laa wɔra nyɛnyɛn don abono mɔmɔ-ɔbelɛnsɛ mɔ gbaa-gbaa tɛ de ansi ne ɔ kɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato gi tɔgɛ sa mɔmɔ yɛɛ, “Yo, nan sa fɛye asogya gikpen de mɛꞌ kpaa dii gɛkyan mɔ sa fɛye. Fɛye, mɔ, fɛꞌ kpaa wɔra ilaa kamaasɛ ibono fɛ laa taalɛ mɔ de ɔko ɔŋ sa ɔꞌ nyɛ kpaa yii folɛbɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Pilato gi tɔgɛ gɛnen mɔ, mɛ koso lii, ne mɛ kyon kpe gɛkyan mɔ gɛten. Mɛ kpaa wɔra adawo ako kyu daasɛ folɛbɔ mɔ. Ne mɛ san yɛgɛ asogya mɔ mɛꞌ yelɛ nno mɛ kya dii. ");
INSERT INTO acd_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Gɛkɛ kyoolasɛ mɔ gɛdɛ kɛsɛ mɔ, i gyɛ Kosida. Imɔ nyɛnyɛngɛ fu‑u mɔ, Mariya Magadalakyii de Mariya nyɔsɛ mɔ mɛ kpe de mɛꞌ kpaa kerɛ Yesu gɛkyan mɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Nfono mɔ, gɛsinkpan gɛ gyigisi ibono i wɔra ɔlon. Wurubuaarɛ dɔ ɔsɔɔ ɔko gi kpelegɛ lii soso baa belen gibui belɛ gibono gi tii folɛbɔ mɔ gɛbunono mɔ yela nkan, ne ɔ dii ɔ tɛ gimɔ so. ");
INSERT INTO acd_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ɔsɔɔ mɔ kya ŋɛlegi fɛɛ nyangbon gi wiisɛɛ, ne mɔ-ilaa ibono o suu mɔ i fuuli parɛ-parɛ fɛɛ okurufɛpuu. ");
INSERT INTO acd_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Asogya abono mɛ kya dii gɛkyan mɔ mɛ wu Wurubuaarɛ dɔ ɔsɔɔ mɔ mɔ, i tansi wɔra mɔmɔ gifuu, ne mɛ kya seli faa gyin-gyin. Ne mɛ lii tɔrɔ gɛsinkpan, mɛ dɛ fɛɛ mɛ wuꞌ daa. ");
INSERT INTO acd_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ sa akyii mɔ yɛɛ, “Fɛ mɛŋ sa fɛꞌ selɛ gifuu. Iŋ gyɛ Yesu ɔbono mɛ da mɔ aŋanbi oyii so mɔɔ mɔ ne fɛ kya laarɛ? ");
INSERT INTO acd_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ɔŋ baa ɔ bo gɛrɛnaa. O kyingi lii ibuni dɔ fɛɛ gɛnɔɔbono ɔ wolaa tɔgɛ fɛye mɔ. Fɛꞌ baa kerɛ nfono nkana mɔ-gibuni mɔ gi dɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Fɛꞌ kii belen kpaa tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ o kyingi lii ibuni dɔ. Fɛꞌ tɔgɛ sa mɔmɔ yɛɛ ɔ laa gyangbara mɔmɔ kpe Galeli. Nno ne mɛ laa kii wu mɔ. Mɔ-ɔkalan ɔbono ɔ sa me yɛɛ nꞌ tɔgɛ fɛye mɔ ne.” ");
INSERT INTO acd_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Imɔso akyii mɔ mɛ nu mɔ, mɛ selɛ belen lii gɛkyan mɔ gɛten de mɛꞌ kpaa tɔgɛ ɔkalan mɔ sa Yesu akasɛbo mɔ. Mɛ kya kpe mɔ, ɔkon belɛ bɔla mɔmɔ-asen dɔ, ne i kii koso i bo mɔmɔ-gifuu. ");
INSERT INTO acd_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Mɛ baa kerɛ mɔ, Yesu ne! Mɔmɔ‑rɛ mɔ mɛ gyanꞌ, ne ɔ faala mɔmɔ. Nfono mɔ, mɛ tu sindi mɔ. Mɛ ŋmii keda mɔ-ayaa dɔ ne mɛ yen mɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛ mɛŋ sa fɛꞌ selɛ gifuu! Fɛꞌ kpaa tɔgɛ sa me-akasɛbo, mɔmɔ abono mɛ dɛ fɛɛ me-tedɛana mɔ, yɛɛ mɛꞌ kpe Galeli. Nno ne mɛ laa wu me.” ");
INSERT INTO acd_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Akyii mɔ mɛ kya kpe mɔ, asogya abono mɛ kya dii Yesu gɛkyan mɔ dɔ ako mɛ koso kpe nten dɔ kpaa buu ilaa ibono i tu ɔmɔ gɛkyan mɔ gidii mɔ dɔ mɔ pɛwu sa Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Abelɛnsɛ mɔ mɛ nu gɛnen mɔ, mɔmɔ‑rɛ abelɛnsɛ sɛnsɛ mɔ mɛ kpaa gyanꞌ, ne mɛ da gɛdɛ gɛnɔɔbono mɛ laa wɔra ne Yesu gikyingi mɔ i maŋ nyɛ lii gɛwi mɔ. Mɛ da gɛdɛ gɛnen mɔ, mɛ kyu aterenbi belɛ kyu sa asogya mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Fɛꞌ sɔɔ de fɛꞌ naa tɔgɛ sa asa yɛɛ gɛnyɛ fɛ dɛ mɔ, Yesu akasɛbo mɔ mɛ baa yuuri mɔ-gibuni mɔ koso. ");
INSERT INTO acd_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Nengyene ilaa idɛ i kpaa nu Ɔbelɛnsɛ Pilato mɔ, aye ne nan buɛɛlɛ mɔ de ɔŋ sa oꞌ kyu ilaa nyɛnyɛn iko kyu wɔra fɛye.” ");
INSERT INTO acd_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Gɛsintin mɔ, asogya mɔ mɛ sɔɔ aterenbi mɔ, ne mɛ san mɛ naa mɛ kya tɔgɛ gɛnen ilaa ibono ma‑a sa asa. Gɛnen ilaa idɛ i gbigi mɔmɔ Gyuda awura mɔ dɔ ne mɛ san mɛ kya tɔgɛ imɔ baa lii de ndɛ. ");
INSERT INTO acd_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yesu akasɛbo gudu ɔko mɔ mɛ kpe Galeli mɔ, mɛ kyon kpe gibii gibono so Yesu gi tɔgɛ sa mɔmɔ yɛɛ mɛꞌ kpaa gyanꞌ mɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mɛ wu Yesu mɔ, mɛ ŋmii mɔ ne mɛ yen mɔ. Mɔmɔ ako berɛ, i wɔra mɔmɔ fɛɛ i mɛŋ gyɛ Yesu gbaa-gbaa ne. ");
INSERT INTO acd_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yesu gi tu sindi mɔmɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Me-sɛ Wurubuaarɛ gi kyu soso de gɛsinkpan so ɔlon kamaasɛ kyu wɔra me-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Imɔso fɛꞌ kpaa yɛgɛ gɛsinkpan so asa kpɛi-kpɛi pɛwu mɛꞌ bingiri me-akasɛbo de fɛꞌ kyu aye-sɛ Wurubuaarɛ ginyen, de me, mɔ-bi mɔ ginyen, de mɔ-Oduduu mɔ ginyen kyu gyere gɛnen asa abono Wurubuaarɛ sagyere, ");
INSERT INTO acd_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","de fɛꞌ nyiile mɔmɔ yɛɛ mɛꞌ wɔra ilaa kamaasɛ ibono nɛ ka sa fɛye yɛɛ fɛꞌ wɔra mɔ. N bo fɛye asɛ aberɛ kamaasɛ dɔ kpaa lii owi ɔbono gɛsinkpan so gɛkyena gɛ laa yela ɔkara mɔ.”");
INSERT INTO acd_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Ɔkalan konkonsɛ kyu lii Yesu Kirisito, Wurubuaarɛ mɔ-bi mɔ so giyiigɛsɛ ne n gyɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","3","Wurubuaarɛ gi tɔgɛ sa mɔ-bi mɔ yɛɛ ɔ laa yɛgɛ mɔ de ɔꞌ ba gɛsinkpan so. O kii tɔgɛ sa mɔ yɛɛ, “Pɛi ne fo laa kpe mɔ, nan sun ɔko de ɔꞌ gyangbara kpaa tɔgɛ sa asa yɛɛ mɛꞌ lɔrɔ mɔmɔ-gɛkyena dɔ gyoo fo. Nengyene o kpe mɔ, asa mɛ laa nu mɔ-gigyɛbiꞌ gipen dɔ, ɔ laa kpen ɔ kya tɔgɛ yɛɛ, ‘Fɛꞌ lɔrɔ fɛye-gɛkyena dɔ gyoo Wurubuaarɛ de ɔꞌ nyɛ naa de ɔkpa ntintin ba fɛye asɛ.’ ” Ilaa ibono Wurubuaarɛ gi tɔgɛ sa mɔ-bi mɔ gɛnen mɔ, ɔ yɛgɛ mɔ-ikalan ɔtɔgɛbo Isaya gi wolaa wu imɔ ne mɛ ŋmarasɛ imɔ yela ɔwolɛ dɔ, ");
INSERT INTO acd_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ne gɛnen ilaa ibono i ba gɛsintin. Imɔ ne n gyɛ yɛɛ Wurubuaarɛ gi sun ɔnyen ɔko mɛ kya terɛ mɔ yɛɛ Gyɔn yɛɛ ɔꞌ gyangbara mɔ-bi mɔ. Gyɔn gi kpe gipen dɔ ɔ kya gyere asa Wurubuaarɛ sagyere. Ɔ kya tɔgɛ ɔ sa asa yɛɛ, “Fɛꞌ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ lii fɛye-ilaa nyɛnyɛn giwɔra dɔ. Fɛ wɔra gɛnen mɔ, nan gyere fɛye Wurubuaarɛ sagyere de iꞌ nyiile yɛɛ Wurubuaarɛ gi kyu fɛye-ilaa nyɛnyɛn kyɛɛ fɛye.” ");
INSERT INTO acd_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Gɛsintin mɔ asa sakyɔ mɛ kya lii ma‑a lii Gyudiya gɛsinkpan so de Gyɛrusalem ɔsowolɛ so mɛ kya ba Gyɔn asɛ gipen mɔ dɔ. Mɛ kya kpe mɛ kya tɔgɛ mɔmɔ-ilaa nyɛnyɛn ibono mɛ wɔra mɔ, ne Gyɔn kya gyere mɔmɔ Wurubuaarɛ sagyere Gyɔɔdan ɔbon dɔ. ");
INSERT INTO acd_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Gyɔn gɛgbɛ suusɛ mɔ, mɛ kyu daa gɛkpatitii ifuu kyu luo gɛmɔ, ne o kyu gɛbuɛ ɔwolɛ wɔra liide. Mɔ-ilaa gyisɛ ne n gyɛ nkpenfuree nko oyuduu de ŋmasan. ");
INSERT INTO acd_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Gyɔn ilaa tɔgɛsɛ dɔ mɔ, ɔ kya tɔgɛ ɔ kya sa asa yɛɛ, “Me-gɛmara mɔ, ɔko laa ba. Ɔ don me ilaa kamaasɛ dɔ. Fɛɛ nꞌ ba gɛsɛ de nꞌ kyu mɔ-ayaawolɛ tolɛ mɔ-ayaa dɔ sa mɔ gbaa mɔ, meŋ fo. ");
INSERT INTO acd_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Me, n dɛ daa nkyu n kya gyere fɛye Wurubuaarɛ sagyere. Mɔ, ɔbono ɔ don me mɔ berɛ, Wurubuaarɛ Oduduu ne ɔ laa kyu gyere fɛye.” ");
INSERT INTO acd_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Gɛnen nkɛ nbono Gyɔn kya gyere asa Wurubuaarɛ sagyere mɔ ne Yesu gi lii Nasarɛtɛ ɔsowolɛ Galeli gɛsinkpan so ba Gyɔn asɛ. Ne Gyɔn gi gyere mɔ Wurubuaarɛ sagyere Gyɔɔdan ɔbon dɔ. ");
INSERT INTO acd_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Yesu gi kpɛ lii nkyu mɔ dɔ dii gyan gigengen so mɔ, o wu Wurubuaarɛ dɔ i kya bugi, ne Wurubuaarɛ Oduduu gi kpelegɛ lii nno fɛɛ bonbuɛ baa gyan mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ne Wurubuaarɛ gi tɔngɛ lii soso yɛɛ, “Fo gyɛ me-bi. Fo-ilaa i bo me-gisen dɔ. Fo kya gyi me-ginsi.” ");
INSERT INTO acd_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ayaa abono so mɔ Wurubuaarɛ Oduduu mɔ gi yɛgɛ Yesu gi kpe gipen mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ɔ kyena gipen mɔ dɔ nkɛ ikue-inyɔ. Ɔ bo nno mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi baa soo mɔ idoo kerɛ yɛɛ ɔ laa nyɛ mɔ de oꞌ nu mɔ asɛ? Ɔ mɛŋ kii nyɛ mɔ. Aberɛ abono mɔ, ɔko mɛŋ bo Yesu asɛ nno, ifɛ dɔ nbuɛ wolɛ. Ne Wurubuaarɛ dɔ isɔɔ mɛ kpaa kerɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","I baa fo aberɛ ako dɔ mɔ, mɛ keda Gyɔn tii de obu. Imɔ gɛmara mɔ Yesu gi baa kpe Galeli gɛsinkpan so ɔ naa ɔ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ɔ sa asa. ");
INSERT INTO acd_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Mɔ-ilaa tɔgɛsɛ mɔ dɔ mɔ, ɔ kya tɔgɛ yɛɛ, “Nkɛ nbono Wurubuaarɛ gi yela mɔ gi fo. Idɛ kon ne Wurubuaarɛ gɛwuragyi dɔ akyenabi a laa ba asa dɔ ne. Imɔso fɛꞌ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ de fɛꞌ sɔɔ Wurubuaarɛ ɔkalan konkonsɛ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Yesu naa Galeli ɔbon gigengen mɔ so, ɔ baa kerɛ mɔ, iken alɛɛbo ako ne, Simon mɔ‑rɛ mɔ-tedɛ Andiru. Mɛ kya too asɛwu. ");
INSERT INTO acd_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","O wu mɔmɔ gɛnen mɔ, ɔ tɔgɛ mɔmɔ yɛɛ, “Fɛꞌ baa wɔra me-akasɛbo. Nɛ wu yɛɛ nkana fɛ gyɛ iken alɛɛbo. Nperɛ nan yɛgɛ de fɛꞌ san laarɛ daa asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ayaa abono so mɔ, mɛ taa mɔmɔ-asɛwu mɔ yɛgɛ, ne mɛ naa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ɔ naa kpe ansi dɔ ŋmaraa mɔ, o wu Gyeemesi mɔ‑rɛ mɔ-tedɛ Gyɔn, Sɛbedi mɔ-biana, mɛ tɛ gikolii dɔ, mɛ kya lɔrɔ mɔmɔ-asɛwu. ");
INSERT INTO acd_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Nfono mɔ, Yesu gi tɔgɛ mɔmɔ kee yɛɛ mɛꞌ baa buu mɔ de mɛꞌ wɔra mɔ-akasɛbo. Ne gɛsintin mɔ, mɛ taa mɔmɔ-sɛ Sɛbedi de mɔ-gɛsun awɔrabo yɛgɛ, ne mɛ naa buu Yesu. ");
INSERT INTO acd_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Yesu mɔ‑rɛ mɔmɔ mɛ naa kpaa loo Kapɛɛniyon. Mɛ bo nno mɔ, mɔmɔ-gɛkɛ kyoolasɛ gɛ fo. Asa mɛ kpaa gyan mɔmɔ-gikyangbon dɔ, ne Yesu gi nyiile mɔmɔ Wurubuaarɛ ilaa nno. ");
INSERT INTO acd_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Yesu ilaa nyiilesɛ mɔ i kya dɛ mɔmɔ-gɛnɔ. I lii fɛɛ mɛ nu mɔ-anyiilebi mɔ, mɛ wolaa wu yɛɛ Wurubuaarɛ ne n sa mɔ mɔ-ilaa nyiilesɛ pɛi ne ɔ kya nyiile gɛnen. I mɛŋ gyɛ gɛnen ne mɔmɔ-nbara aŋmarasɛbo mɔ mɛ kya nyiile ilaa ne. ");
INSERT INTO acd_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ɔnyen ɔko bo mɔmɔ-gikyangbon mɔ dɔ, ilaa nyɛnyɛn oduduu i tɛ mɔ so. Ɔnyen mɔ gi kpɛ wu Yesu mɔ, ilaa nyɛnyɛn oduduu ibono i tɛ mɔ so mɔ i tɔgɛ ken-ken taasɛ Yesu yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Yesu, Nasarɛtɛnyen, menɛ ne fo kya laarɛ aye asɛ? Fo ba de foꞌ baa nyida aye ilaa nyɛnyɛn oduduu kpɛi-kpɛi mɔ abɛɛ?” Ne ilaa nyɛnyɛn oduduu mɔ i kii tɔgɛ sa Yesu yɛɛ, “N nyi isa ɔbono fo Yesu fo gyɛ. Fo ne n gyɛ gisen fufuli wura ɔbono fo-nkon ne n lii Wurubuaarɛ asɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nfono mɔ Yesu gi tɔgɛ ilaa nyɛnyɛn oduduu mɔ yɛɛ, “Bun fo-gɛnɔ so de foꞌ koso lii ɔnyen baarɛ so, n kerɛ fo faa.” ");
INSERT INTO acd_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Gɛsintin mɔ, ilaa nyɛnyɛn oduduu mɔ i saawo ken-ken kuu ɔnyen mɔ da gɛsɛ, i kya gbebi mɔ, pɛi ne i koso lii ɔnyen mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Gɛnen ilaa idɛ i wɔra asa abono mɛ bo nno mɔ pɛwu giyan. Mɛ san ma‑a taasɛ abara yɛɛ, “Menɛ ilaa ne idɛ? Ilaa pobɔrɔ iko mɔ ne? Yesu gɛnɔ dɔ agyɛbi a bo gya! Ilaa nyɛnyɛn oduduu gbaa i kya nu mɔ asɛ!” ");
INSERT INTO acd_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Nfono mɔ, ilaa ibono Yesu kya wɔra mɔ i nu gyanꞌ de Galeli gɛsinkpan gɛbono so pɛwu. ");
INSERT INTO acd_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpɛ lii gikyangbon mɔ dɔ mɔ, Simon mɔ‑rɛ Andiru mɛ kyu Yesu kpe mɔmɔ-gɛwi. Gyeemesi mɔ‑rɛ Gyɔn kee mɛ buu mɔmɔ kpe. ");
INSERT INTO acd_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Simon mɔ-saa kyiisɛ kya lɔ ɔkyagyii, ɔ dɛ gifengen so. Imɔso Yesu gi loo mɔmɔ-gikpaara so mɔ, mɛ buu sa mɔ yɛɛ ɔkyii mɔ kya lɔ. ");
INSERT INTO acd_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Yesu gi loo ɔkyii mɔ asɛ, ne ɔ keda mɔ-gibaa dɔ kosorɛ mɔ kyena. Nfono mɔ ɔkyii mɔ nyoro mɔ gi taa mɔ yɛgɛ, ne ɔ koso kii taalɛ keda mɔmɔ-gisafo. ");
INSERT INTO acd_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Gɛnen gɛkɛ gɛbono gɛdɔɔdɛ owi gi tɔrɔ mɔ, asa mɛ kyu alɔbo bara Yesu yɛɛ ɔꞌ kyɛ mɔmɔ. Ne ako, mɔ, mɛ kyu abono ilaa nyɛnyɛn oduduu i tɛ i tɛ mɔmɔ so mɔ ba yɛɛ Yesu ɔꞌ kosorɛ imɔ lii asa mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ɔsowolɛ ɔbono so asa pɛwu mɛ ba Yesu asɛ nfono. Mɛ yelɛ gikpaara mɔ so sindi obu mɔ gibunono. ");
INSERT INTO acd_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ne Yesu gi kyɛ asa alɔbi kpɛi-kpɛi gikyɔ ne ɔ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi lii asa so kee gikyɔ. Ilaa nyɛnyɛn oduduu mɔ i nyi Yesu, imɔso Yesu mɛŋ sa imɔ ɔkpa de iꞌ nyɛ tɔngɛ. ");
INSERT INTO acd_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","I kya laarɛ iꞌ fo gibaadiikɛ mɔ, Yesu gi koso lii kpe nfono ɔko mɛŋ bo mɔ ne ɔ kpaa dalaa sa Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simon mɔ‑rɛ mɔ-nanboana mɛ naa ma‑a laarɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Mɛ wu mɔ mɔ, mɛ tɔgɛ sa mɔ yɛɛ, “Ɔkamaasɛ kya laarɛ fo-gɛten.” ");
INSERT INTO acd_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “Aꞌ kpe gɛten banban isowolɛ ibono i sindi gɛrɛ mɔ de nꞌ nyɛ tɔgɛ Wurubuaarɛ ilaa sa imɔ so awura kee. Imɔso ne nɛ ba.” ");
INSERT INTO acd_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Gɛsintin ɔ naa gyan de Galeli isowolɛ mɔ so. Ɔ naa mɔ, ɔ kya tɔgɛ Wurubuaarɛ ilaa mɔmɔ-akyangbon dɔ ne ɔ kya kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi lii asa so. ");
INSERT INTO acd_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Okononbu ɔko gi ba Yesu asɛ baa ŋmii mɔ-ayaa dɔ ne ɔ tɔgɛ mɔ yɛɛ, “Nengyene i gyɛ fo-gɛlaarɛ dɔ mɔ, fo laa taalɛ kyɛ me.” ");
INSERT INTO acd_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ɔ tɔgɛ gɛnen mɔ, mɔ-ilaa i wɔra Yesu ayen. Imɔso Yesu gi tengɛ mɔ-gibaa kpaa yii mɔ, ne ɔ tɔgɛ yɛɛ, “I gyɛ me-gɛlaarɛ. Fo-gilɔ mɔ giꞌ ta.” ");
INSERT INTO acd_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Gɛsintin mɔ, ayaa abono so mɔ, gilɔ mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Yesu gi kyɛ ɔnyen mɔ mɔ, ɔ tɔgɛ mɔ yɛɛ, “Naa fo kya kpe.” Ne o kii ka mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Gɛŋ sa foꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ me ne n kyɛ fo. Naa kpaa wɔra nbara ilaa ibono Mosisi gi yela sa okononbu kamaasɛ ɔbono mɔ-gilɔ gi ta mɔ. Imɔ ne n gyɛ yɛɛ fo laa kperɛ fo-nyoro kpaa nyiile Wurubuaarɛ asunbi ɔlɛɛbo de ɔꞌ kerɛ fo-nyoro pɛwu gyanꞌ. Ɔ laa wu yɛɛ fo-gilɔ mɔ gi ta de foꞌ kyu fo-afaala sa mɔ de oꞌ kyu lɛɛ asunbi sa Wurubuaarɛ sa fo. Imɔ ne nan yɛgɛ asa mɛꞌ bii yɛɛ fo-alɔtɔ mɔ a ta.” ");
INSERT INTO acd_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ɔnyen mɔ gi kyon mɔ, ɔ san ɔ naa ɔ kya da imɔ so gikpengboo ɔ sa asa. Gɛten kamaasɛ nfono ɔ kpɛ nyɛ ne ɔ loo mɔ, ɔ kya tɔgɛ imɔ so ilaa daa. Imɔso i yɛgɛ Yesu mɛŋ baa nyɛ loo isowolɛ so tentegelen. I lii fɛɛ asa mɛ kya ŋmaa mɔ gikyɔ. Ɔ san ɔ tɛ daa ifɛ dɔ. Imɔ gɛnen gbaa mɔ, asa mɛ kya lii gɛten kamaasɛ ba mɔ asɛ ifɛ mɔ dɔ nno. ");
INSERT INTO acd_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Imɔ nkɛ kalɛsɛ gɛmara mɔ, Yesu gi kii ba Kapɛɛniyon ɔsowolɛ so. Ne i nu gyan de ɔsowolɛ mɔ yɛɛ Yesu gi kii ba; ɔ bo mɔ-gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Imɔso asa mɛ baa gyan mɔ asɛ faa fiye‑e. Mɛ gɛnda, ibono isa mɛŋ baa nyɛ ɔkpa tu ba gɛbunono asɛ. Ɔ kya tɔgɛ Wurubuaarɛ agyɛbi ɔ kya sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Mɛ bo nno gɛnen mɔ, asa ako mɛ kpaa kyu ɔtɛgɛsɛ ɔko ba mɔ asɛ. Anyen anan ne n sola mɔ ba. ");
INSERT INTO acd_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Asa mɛ nyaakyɔ nno so mɔ, abono mɛ sola ɔlɔbo mɔ ba mɔ mɛŋ nyɛ ɔkpa kyu mɔ loo Yesu asɛ obu mɔ dɔ de gɛbunono so. Imɔso mɛ dii obu mɔ soso maragɛ mɔ de nfono so Yesu yelɛ mɔ ŋmaraa, ne mɛ kpelegɛrɛ ɔlɔbo mɔ mɔ‑rɛ mɔ-gifengen loo de ɔmaragɛten mɔ kyu mɔ yela Yesu asɛ. ");
INSERT INTO acd_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Yesu gi wu yɛɛ asa adɛ mɛ sɔɔ mɔ gyi yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ mɔ, ɔ tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, “Me-bi, nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyu kyɛɛ fo.” ");
INSERT INTO acd_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Yesu gi tɔgɛ gɛnen mɔ, Gyuda awura nbara aŋmarasɛbo ako mɛ tɛ nno. Mɛ kya taasɛ mɔmɔ-asen dɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Ɔkpa ɔmɔ so ne ɔnyen baarɛ kya tɔgɛ gɛnen? Ɔ kya tɔngɛ fɛɛ mɔ ne n gyɛ Wurubuaarɛ. Ne iŋ gyɛ Wurubuaarɛ wolɛ mɔ, fo anɛ ne nan taalɛ kyu ɔko ilaa nyɛnyɛn ibono ɔ wɔra Wurubuaarɛ mɔ kyu kyɛɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ayaa abono so mɔ, Yesu gi bii mɔmɔ-nwɔnsa nbono mɛ kya sa mɔ, ne ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra so ne fɛ kya sa gɛnen nwɔnsa ndɛ? ");
INSERT INTO acd_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nan tɔgɛ ilaa inyɔ sa ɔtɛgɛsɛ baarɛ. Giko ne n gyɛ yɛɛ, ‘Nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyɛɛ fo.’ Ginyɔsɛ mɔ ne n gyɛ yɛɛ, ‘Koso, puru fo-gifengen de foꞌ naa.’ Imɔ inyɔ idɛ dɔ mɔ, imɔmɔ ne fɛ laa wu de fɛye-ansi? ");
INSERT INTO acd_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","N kya laarɛ de fɛꞌ nyɛ bii yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔkpa gɛsinkpan so de nꞌ kyu asa ilaa nyɛnyɛn ibono mɛ kya wɔra Wurubuaarɛ mɔ kyɛɛ mɔmɔ.” Gɛnen so mɔ, o kisee tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nꞌ tɔgɛ sa fo yɛɛ koso, puru fo-gifengen de foꞌ naa kpe gɛwi.” ");
INSERT INTO acd_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Gɛsintin, ayaa abono so mɔ, ɔnyen mɔ gi koso ne o puru mɔ-gifengen, ne ɔ naa lii asa mɔ dɔ. Ɔkamaasɛ ɔbono ɔ bo nfono mɔ gi wu mɔ mɔ, i wɔra mɔ giyan. Mɛ san mɛ kya yen Wurubuaarɛ, mɛ kya tɔgɛ yɛɛ mɛ mɛŋ ti wu imɔ idɛ ɔnan gɛkaako kerɛ. ");
INSERT INTO acd_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Yesu gi kii naa kpe ɔbon mɔ gigengen. Sakpii belɛ ɔko gi ba mɔ asɛ nno, ne o nyiile mɔmɔ ilaa. ");
INSERT INTO acd_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Yesu gi nyiile mɔmɔ ilaa ta mɔ, ɔ naa ɔ kya kyon mɔ, o wu Lɛfi, Alefayo mɔ-bi, tɛ lɛnpoo ɔsɔɔten, ɔ kya sɔɔ lɛnpoo, ne Yesu gi tɔgɛ mɔ yɛɛ, “Baa buu me de foꞌ wɔra me-ɔkasɛbo.” Ne Lɛfi gi koso baa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Imɔ gɛmara mɔ, Yesu tɛ Lɛfi gɛten dɔ ɔ kya gyi mɔ, lɛnpoo asɔɔbo abono Gyuda awura asɛ mɔ mɛ gyɛ asa nyɛnyɛn mɔ de ilaa nyɛnyɛn awɔrabo sɛnsɛ sakyɔ mɛ baa tu mɔmɔ, ne mɔmɔ‑rɛ mɔmɔ mɛ wɔra abaa gyi dabɔlɛ. Lɛnpoo asɔɔbo de ilaa nyɛnyɛn awɔrabo abono mɛ buu Yesu mɔ mɛ nyaakyɔ. ");
INSERT INTO acd_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Gyuda awura nbara aŋmarasɛbo abono mɛ gyɛ Farasii gikpen mɔ dɔ awura mɔ mɛ wu yɛɛ lɛnpoo asɔɔbo de ilaa nyɛnyɛn awɔrabo mɔmɔ‑rɛ Yesu mɛ kya gyi mɔ, mɛ taasɛ Yesu akasɛbo mɔ yɛɛ, “Menɛ n wɔra so ne fɛye-ɔbelɛnsɛ kya wɔra abaa gyi de gɛnen asa adɛ?” ");
INSERT INTO acd_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Yesu gi nu gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛɛ gɛnɔɔbono ɔlɔbo tiri ɔkyɛbo mɔ, gɛnen kee ne ilaa nyɛnyɛn awɔrabo mɛ tiri me, Yesu, ne. I mɛŋ gyɛ abono mɛ bo alanfiya mɔ ne n tiri ɔkyɛbo. Fɛꞌ bii yɛɛ ilaa nyɛnyɛn awɔrabo ne nɛ ba de nꞌ baa tɔgɛ yɛɛ mɛꞌ wɔra me-akasɛbo. I mɛŋ gyɛ abono mɛ nyi yɛɛ mɛ ti mɛ gyɛ gɛsintin awura mɔ so ne nɛ ba.” ");
INSERT INTO acd_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Owi ɔko dɔ mɔ, i ba yɛɛ Gyɔn akasɛbo de Farasii awura akasɛbo mɛ kya ŋminde nnɔ. Nfono ne asa ako mɛ baa taasɛ Yesu yɛɛ, “Gyɔn akasɛbo mɛ kya ŋminde nnɔ. Farasii awura akasɛbo kee mɛ kya ŋminde nnɔ. Ne menɛ n wɔra ne fo-lɛɛ akasɛbo mɔ berɛ, mɛŋ kya ŋminde nnɔ daa?” ");
INSERT INTO acd_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yesu gi lɛɛ gɛnɔ da mɔmɔ gikpalɛ yɛɛ, “I mɛŋ gyɛ aberɛ adɛ ne mɛ laa wɔra gɛnen. I dɛ daa fɛɛ gɛnɔɔbono aye Gyuda awura a kya kpii ɔkyii mɔ. Aꞌ kyu yɛɛ me ne n gyɛ ɔkyiifɔ mɔ-kuli. Owi ɔbono me-kyɛmenɛana mɛ ba me asɛ a san a kya gyi ɔkon mɔ, i kaaborɛ mɛꞌ ŋminde nnɔ? I maŋ sa gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","I laa baa fo owi ɔko mɔ, i laa puru ɔkyiifɔ mɔ-kuli mɔ lii mɔ-kyɛmenɛana asɛ. Lii gɛnen owi ɔbono kyu kyon mɔ, i laa sa de mɛ ŋminde nnɔ kon.” ");
INSERT INTO acd_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Yesu gi kii da mɔmɔ gikpalɛ kyu nyiile yɛɛ ɔ bara akyenabi pobɔrɔ. Ɔ da gikpalɛ mɔ yɛɛ, “Nengyene gikuru dedaa gi tɛɛ mɔ, mɛŋ kya kyu gikuru pobɔrɔ gipanan kyu baa tii ɔtɛɛten mɔ. Fɛ wɔra gɛnen mɔ, gikuru pobɔrɔ mɔ gɛten i laa kyigi lɛɛ de iꞌ wɔra ɔbɔ belɛ nyɛ ibono i wolaa tɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Aꞌ kii laa ansi kerɛ gɛnɔɔbono mɛ kya kyu nta kyu wɔra nbuɛ iwolɛ dɔ mɔ de aꞌ kerɛ. Ɔko maŋ kyule kyu nta pobɔrɔ kyu wɔra nta ɔwɔraten iwolɛ dedaa dɔ. Ɔbono ɔ wɔra gɛnen mɔ, gyɛrɛbi ne ɔ kya laarɛ. Nta mɔ gi laa paadɛ nta ɔwɔraten iwolɛ mɔ de nta mɔ giꞌ duuli fuɛ de iwolɛ mɔ, mɔ, kee iꞌ nyida. Mɛ kya kyu nta pobɔrɔ kyu wɔra daa nta ɔwɔraten iwolɛ pobɔrɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Gɛkɛ kyoolasɛ gɛko mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ naa mɛ kya kpe mɔmɔ-nten kpesɛ, ne mɛ baa loo awayu ndɔɔ nko dɔ. Mɛ naa awayu mɔ dɔ mɛ kya kpe mɔ, Yesu akasɛbo mɔ mɛ yii gɛsɛ mɛ kya kyadɛ awayu mɔ, mɛ kya fɔlɔgɛ mɛ kya wɛ. ");
INSERT INTO acd_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Farasii gikpen mɔ dɔ awura ako mɛ wu mɔmɔ gɛnen mɔ, mɛ taasɛ Yesu yɛɛ, “Kerɛ, fo-akasɛbo mɔ mɛ kya kyadɛ awayu adɛ faa, fo mɛŋ nyi yɛɛ gɛsun ne mɛ kya wɔra aye-gɛkɛ kyoolasɛ mɔ dɔ faa? Aye-nbara giŋ kya sa ɔkpa gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ne Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛye yɛɛ iŋ dɛ ɔkpa gɛnen faa mɔ, imɔso fɛŋ ti kalɛ Wura Deefidi mɔ‑rɛ mɔ-nanboana ilaa Wurubuaarɛ agyɛbi mɔ dɔ kerɛ? Mɛ ŋmarasɛ nno yɛɛ owi ɔko dɔ mɔ Abiyata gi wɔra Wurubuaarɛ asunbi alɛɛbo gɛmu. Abiyata gɛkyena dɔ mɔ, gɛkɛ gɛko dɔ mɔ, Wura Deefidi mɔ‑rɛ mɔ-nanboana mɛ kya wu gɛnsipɛɛrɛ ne akon a dɛ ɔmɔ. Imɔso ɔ loo Wurubuaarɛ ɔson panpan mɔ dɔ kpaa puru bodobodo ɔbono asa mɛ kya kyu bara Wurubuaarɛ mɔ. Naafo aye-nbara mɔ giŋ kya sa ɔkpa fɛɛ fo nyamesɛ giyan foꞌ nyɛ gyi gɛnen bodobodo ɔbono, gɛnen mɔ, Gyuda awura asunbi alɛɛbo wolɛ. Wura Deefidi, mɔ, gi gyi bodobodo mɔ iko ne o kyu iko kee sa mɔ-nanboana mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Imɔso Yesu gi lɛɛ gɛsɛ sa mɔmɔ yɛɛ, “Fɛꞌ nu yɛɛ Wurubuaarɛ gi yela gɛkɛ kyoolasɛ sa daa anyamesɛ. Ɔ mɛŋ lɛɛ anyamesɛ mɔ sa gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Imɔso me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔlon dabɔlɛ gɛkɛ kyoolasɛ mɔ so.” ");
INSERT INTO acd_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Gɛkɛ kyoolasɛ gɛko kee mɔ Yesu gi kii kpaa loo Gyuda awura gikyangbon giko dɔ. Ɔnyen ɔko bo nno, mɔ-gibaa giko gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Yesu gi loo nno mɔ, asa ako mɛ kya dii mɔ de mɛꞌ kerɛ yɛɛ ɔ laa kyɛ gibaa wusɛ wura mɔ abɛɛ? Nengyene ɔ nyɛ kyɛ mɔ gɛnen gɛkɛ kyoolasɛ gɛbono dɔ mɔ de mɛꞌ nyɛ kyu mɔ wɔra nbɛlɛ dɔ yɛɛ ɔ wɔra gɛsun gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nfono mɔ Yesu gi tɔgɛ sa ɔnyen mɔ yɛɛ, “Koso baa yelɛ asa ansi dɔ gɛrɛ.” Ne ɔnyen mɔ gi naa kpaa yelɛ ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nfono ne Yesu gi taasɛ asa mɔ yɛɛ, “Nnɛ ne Wurubuaarɛ nbara gi kya nyiile yɛɛ aꞌ wɔra aye-gɛkɛ kyoolasɛ dɔ? Aꞌ wɔra ilaa dɛnsɛ abɛɛ aꞌ wɔra ilaa nyɛnyɛn? Aꞌ sɔɔ abara nkpa abɛɛ aꞌ mɔɔ abara?” Yesu gi taasɛ mɔmɔ gɛnen mɔ, asa mɔ mɛŋ tɔgɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ɔ kerɛ mɔmɔ dɔ pɛwu gyan. Mɔmɔ-gisoɔlon so mɔ, i yɛgɛ o kyu ginyadon mɔmɔ so, ne mɔmɔ-ilaa i kii kisee wɔra mɔ ayen. Ɔ tɔgɛ sa ɔnyen gibaa wusɛ wura mɔ yɛɛ, “Tengɛ fo-gibaa mɔ.” Gɛsintin mɔ ɔ tengɛ gimɔ, ne gibaa mɔ gi kii kyingi. ");
INSERT INTO acd_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nfono mɔ, Farasii awura mɔ mɛ lii kpaa wu Wura Hɛrodɛ adɛ, ne mɛ yii gɛsɛ mɛ kya ŋminde gɛnɔɔbono mɛ laa nyɛ Yesu mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","8","Imɔso Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ lii kyon Galeli ɔbon belɛ mɔ gigengen so. Asa mɛ nu Yesu ilaa wɔrasɛ so, imɔso sakpii belɛ gi lii Galeli buu mɔ. Ne ako kee mɛ lii Gyudiya de Gyɛrusalem de Idumiya nsinkpan so. Ako, mɔ, mɛ lii Gyɔɔdan gɛmara nno so de Taya de Sidon isowolɛ so ba mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ sakpii mɔ gi don abaa. Imɔso mɛꞌ kyu gikolii ba. Nengyene asa mɛ laa gɛnda de mɔ gikyɔ mɔ de ɔꞌ dii loo gikolii mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Mɔ-asa gikyɛ so mɔ, ɔlɔbo kamaasɛ kya laarɛ de ɔꞌ kpaa yii mɔ de mɔ-alɔtɔ aꞌ nyɛ ta. ");
INSERT INTO acd_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Nengyene asa abono ilaa nyɛnyɛn oduduu i tɛ mɔmɔ so mɔ mɛ wu Yesu mɔ, ilaa nyɛnyɛn oduduu mɔ i kya yɛgɛ asa mɔ mɛ kya kpelegɛ ŋmii mɔ-ayaa dɔ de ilaa nyɛnyɛn oduduu mɔ iꞌ saawo tɔgɛ yɛɛ, “Yesu, fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Yesu kya da ilaa nyɛnyɛn oduduu mɔ tii yɛɛ i mɛŋꞌ sa iꞌ lɛɛ mɔ-gɛwi nyiile asa. ");
INSERT INTO acd_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Imɔ gɛmara mɔ, Yesu gi dii kpe gibii giko so, ne ɔ terɛ asa abono ɔ kya laarɛ mɔ yɛɛ mɛꞌ ba mɔ asɛ. Gɛsintin mɔ, mɛ kpe, ");
INSERT INTO acd_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ne ɔ lɛɛ mɔmɔ dɔ asa gudu anyɔ abono mɛ laa kyena mɔ asɛ de ɔꞌ kyena ɔ kya sun mɔmɔ de mɛꞌ kpaa tɔgɛ Wurubuaarɛ ilaa sa asa. ");
INSERT INTO acd_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ɔ sa mɔmɔ ɔlon de mɛꞌ taalɛ gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so. ");
INSERT INTO acd_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Gɛnen asa gudu anyɔ abono ɔ lɛɛ mɔ ɔko ne n gyɛ Simon. Yesu gi yela mɔ-ginyen giko yɛɛ Piita. ");
INSERT INTO acd_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Ako ne n gyɛ Gyeemesi de mɔ-tedɛ Gyɔn Sɛbedi mɔ-biana, abono Yesu gi yela mɔmɔ ayenbi yɛɛ Buwaneegyisi. (Buwaneegyisi gɛsɛ ne n gyɛ yɛɛ “abono mɛ dɛ fɛɛ nyangbon gigbere mɔ.”) ");
INSERT INTO acd_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Mɛ kya terɛ ako kee yɛɛ Andiru de Filipo de Batolomiyu de Matiyu de Tomaasɛ de Gyeemesi ɔko kee; Alefayo mɔ-bi, de Taadiyusɛ, ");
INSERT INTO acd_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","de Simon ɔko kee, ɔbono ɔŋ kya kyule mɔ-ɔsowolɛ so mɔ de Gyudasɛ Isikaayɔtɛ, ɔbono gɛmara gɛmara ɔ fɛ Yesu sa mɔ-akyobo mɔ. Yesu ɔ baa lii gibii mɔ so kpe gɛwi mɔ, ");
INSERT INTO acd_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","sakpii gi ti baa bɔla mɔ-gɛten dɔ ibono i yɛgɛ mɔ‑rɛ mɔ-akasɛbo gudu anyɔ mɔ mɛŋ kya nyɛ nyoro de mɛꞌ kpɛɛ agyudɔ wɔra gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Yesu mɔ-subuana mɛ kya nu asa mɛ kya tɔngɛ nkan-nkan yɛɛ, “Yesu mɛŋ baa ɔ bo gimu. Itɛfaa i kya pɛɛdɛ mɔ.” Imɔso mɛ kpe mɛꞌ kpaa keda mɔ lii sakpii mɔ dɔ de mɛꞌ baa kerɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Gyuda awura nbara aŋmarasɛbo ako mɛ lii Gyɛrusalem baa nu yɛɛ Yesu kya gya ilaa nyɛnyɛn oduduu lii asa so. Gɛnen so mɔ, mɛ kya nyida mɔ-ginyen yɛɛ, “I mɛŋ gyɛ giyan so ne Yesu kya taalɛ gya ilaa nyɛnyɛn oduduu koso asa so gɛnen. Ilaa nyɛnyɛn oduduu pɛwu gɛmu mɔ ɔbono mɛ kya terɛ mɔ-ginyen giko yɛɛ Besibuli mɔ ne n tɛ mɔ so, ɔ kya sa mɔ ɔlon gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Yesu gi nu yɛɛ mɛ kya nyida mɔ-ginyen gɛnen mɔ, ɔ terɛ Gyuda awura nbara aŋmarasɛbo mɔ, ne ɔ tɔngɛ sa mɔmɔ akpalɛ dɔ yɛɛ, “Ilaa nyɛnyɛn pɛwu gɛmu de ilaa nyɛnyɛn oduduu kamaasɛ mɛ gyɛ nyamesɛ kolon. Imɔso ilaa nyɛnyɛn pɛwu gɛmu mɔ maŋ gya mɔ-adɛ koso asa so. ");
INSERT INTO acd_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Ɔ tɔgɛ yɛɛ ɔꞌ wɔra gɛnen mɔ, i laa wɔra fɛɛ wura mɔ‑rɛ mɔ-adɛ ne n kya kɔ de abara. Mɛ kya kɔ gɛnen mɔ, mɔ-gɛwuragyi mɔ gɛ maŋ dɛ kpe. ");
INSERT INTO acd_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Gɛten kolon dɔ asa mɛ yɛ mɔmɔ-nyoro dɔ mɛ kya kɔ de abara mɔ, gɛnen gɛten gɛbono gɛ laa boori. ");
INSERT INTO acd_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Imɔso nengyene i gyɛ gɛsintin yɛɛ ilaa nyɛnyɛn pɛwu gɛmu mɔ ne n kya kɔ de mɔ-adɛ ne mɛŋ bo gɛnɔ kolon mɔ, gɛnen berɛ mɔ, mɔ-gɛwuragyi gɛ maŋ dɛ kpe. Ɔ maŋ baa nyɛ ɔlon asa so.” ");
INSERT INTO acd_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Ne Yesu gi kii da gikpalɛ sa mɔmɔ yɛɛ, “Ilaa nyɛnyɛn pɛwu gɛmu mɔ dɛ daa fɛɛ ɔnyen bolonsɛ ɔbono ɔ kya dii mɔ-gɛten dɔ atɔ pɛwu dandan. Nnɛ ne fo ɔko fo laa wɔra de foꞌ loo gɛnen gɛten gɛbono dɔ sɔgɛ ɔnyen mɔ atɔ kyu kyon daa? Gɛnen mɔ, fo taalɛ ŋminde mɔ yela. ");
INSERT INTO acd_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“N kya tɔgɛ fɛye gɛsintin yɛɛ ilaa nyɛnyɛn kpɛi-kpɛi kamaasɛ ibono fo nyamesɛ fo laa wɔra mɔ, de asebi kamaasɛ abono fo laa saalɛ Wurubuaarɛ mɔ, i laa sa de Wurubuaarɛ oꞌ kyu kyɛɛ fo. ");
INSERT INTO acd_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ibono ɔko laa saalɛ mɔ Wurubuaarɛ Oduduu mɔ mɔ berɛ, Wurubuaarɛ maŋ kyu imɔ ibono kyu kyɛɛ mɔ. Gɛnen ilaa nyɛnyɛn ibono berɛ, i laa sii fo kaasɛ mɔ so gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Nkana Yesu gi nu yɛɛ Gyuda awura nbara aŋmarasɛbo mɔ mɛ kya nyida mɔ-ginyen yɛɛ ilaa nyɛnyɛn oduduu ne n tɛ mɔ so. Imɔso ne o bugi mɔ-gɛnɔ tɔgɛ ilaa idɛ sa mɔmɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Imɔ gɛmara mɔ, Yesu mɔ-nyi de mɔ-tedɛana mɛ ba mɛ yelɛ nŋmaŋman, ne mɛ sun terɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Sakpii tɛ kyaabɔɔ mɔ. Imɔso sakpii mɔ dɔ ako mɛ tɔgɛ sa mɔ yɛɛ, “Fo-nyi de fo-tedɛana mɛ yelɛ nŋmaŋman mɛ kya laarɛ mɛꞌ wu fo.” ");
INSERT INTO acd_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Yesu gi lɛɛ gɛnɔ taasɛ mɔmɔ yɛɛ, “Anɛana ne n gyɛ me-nyi de me-tedɛana?” ");
INSERT INTO acd_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ɔ kerɛ abono mɛ tɛ kyaabɔɔ mɔ mɔ, ne ɔ tɔgɛ yɛɛ, “Me-nyi de me-tedɛana ne! ");
INSERT INTO acd_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Isa ɔbono ɔ kya wɔra Wurubuaarɛ gɛlaarɛ mɔ, mɔ ne n gyɛ me-tedɛ, mɔ ne n gyɛ me-pikyii, mɔ ne n gyɛ me-nyi.” ");
INSERT INTO acd_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Yesu kii ɔ kya nyiile asa ilaa Galeli ɔbon belɛ mɔ gigengen so. Asa mɛ kyaabɔɔ mɔ faa fiye‑e. Imɔso ɔ dii loo gikolii dɔ ɔ gyan nkyu so, yɛgɛ asa mɔ mɛ san mɛ yelɛ gigengen, mɛ kya nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","O nyiile mɔmɔ ilaa gikyɔ akpalɛ dɔ. Ɔ kya nyiile mɔmɔ ilaa ɔ kya kpe mɔ, ɔ baa tɔgɛ mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Fɛꞌ nu gikpalɛ gibono nan baa da faa. Dɔɔbo ɔko gi kyena. Owi ɔko dɔ mɔ, ɔ koso kpe ndɔɔ kpaa ŋmadɛ ayu. ");
INSERT INTO acd_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ɔ kya ŋmadɛ mɔ, amɔ ako a tɔrɔ ɔkpa dɔ ne nbuii mɛ tɔɔsɛ amɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ayu mɔ ako, mɔ, a tɔrɔ kpandan so. Amɔ abono a kpaala kɔrɔ. I kya nyiile yɛɛ isɛ mɔ i bo kpandan mɔ so mɔ iŋ kyɔ, ");
INSERT INTO acd_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","imɔso ayu mɔ a mɛŋ nyɛ de amɔ-ilin iꞌ loo gɛsɛ. Owi gi dii mɔ, a wiili ne a wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ako kee a tɔrɔ iwe dɔ. Abono a kɔrɔ mɔ, iwe mɔ kee i kɔrɔ koso gɛɛlɛ amɔ, ne a mɛŋ nyɛ da amu de aꞌ wɔra abi. ");
INSERT INTO acd_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amɔ ako, mɔ, a tɔrɔ gɛsinkpan dɛnsɛ so. Amɔ berɛ, a kɔrɔ, ne a sen da amu kanpɛ. Dɔɔbo mɔ gi kɛbi amɔ mɔ, ɔ nyɛ abono ɔnan o kyu ŋmadɛ mɔ, amɔ ako oko de saalaa, ako ikue-isa, ne ako mɔ ikue-inun.” ");
INSERT INTO acd_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ tɔgɛ yɛɛ, “Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","I san Yesu mɔ‑rɛ mɔ-akasɛbo gudu anyɔ mɔ de asa kalɛsɛ ako mɔ, mɛ taasɛ mɔ akpalɛ mɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yesu gi tɔgɛ mɔmɔ yɛɛ, “Fɛye ne n gyɛ abono Wurubuaarɛ laa lɛɛ mɔ-gɛwuragyi dɔ akyenabi mɔ ilaa boduduusɛ nyiile. Asɛnsɛ mɔ berɛ, mɛ laa nu ilaa kamaasɛ daa akpalɛ dɔ ");
INSERT INTO acd_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","de iꞌ nyɛ kyena de ilaa ibono i bo Wurubuaarɛ ɔwolɛ mɔ agyɛbi dɔ mɔ. I bo nno yɛɛ, ‘Mɛ laa kpɛ mɛ kya kerɛ ilaa, mɛ maŋ kii wu sɛi; Mɛ laa kpɛ mɛ kya nu ilaa, mɛ maŋ kii nu ilaa gɛsɛ. Nkana mɛ nyɛ nu ilaa gɛsɛ mɔ, mɛ laa naa kii ba Wurubuaarɛ asɛ de Wurubuaarɛ oꞌ kyu mɔmɔ-ilaa nyɛnyɛn kyɛɛ mɔmɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Ne Yesu gi taasɛ mɔmɔ yɛɛ, “Fɛŋ nu gikpalɛ gidɛ gɛsɛ? Gidɛ ne fɛŋ nu gɛsɛ faa, nnɛ ne fɛ laa wɔra de fɛꞌ nu akpalɛ sɛnsɛ gɛsɛ?” Nfono mɔ Yesu gi lɛɛ gɛsɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","“Ayu abono dɔɔbo mɔ gi ŋmadɛ mɔ ne n gyɛ Wurubuaarɛ agyɛbi. ");
INSERT INTO acd_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Asa ako mɛ dɛ fɛɛ ayu abono a tɔrɔ ɔkpa dɔ mɔ. Asa abono mɔ, mɛ kpɛ nu Wurubuaarɛ agyɛbi mɔ, ayaa abono so mɔ, ilaa nyɛnyɛn pɛwu gɛmu kya baa lɛɛ agyɛbi mɔ lii mɔmɔ-nwɔnsa dɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","17","Gɛnen kee ne asa ako mɔ mɛ dɛ fɛɛ ayu abono a tɔrɔ kpandan so, ne amɔ-ilin i mɛŋ nyɛ isɛ loo gɛsɛ mɔ. Gɛnen asa mɔ mɛ dɛ daa fɛɛ nbokyu. Mɛ kpɛ nu Wurubuaarɛ agyɛbi mɔ, mɛ kya sɔɔ amɔ de ɔkon. Ɔgɛnda ɔko gi kpɛ tu mɔmɔ abɛɛ asa mɛ kpɛ ka mɔmɔ-ansi kyu lii agyɛbi mɔ so mɔ, fɛ laa kerɛ mɔ, mɛ kya luu nyoro. ");
INSERT INTO acd_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Asa ako mɔ, mɛ dɛ fɛɛ ayu abono a tɔrɔ iwe dɔ mɔ. Nengyene mɛ nu Wurubuaarɛ agyɛbi mɔ, ");
INSERT INTO acd_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","gɛsinkpan gɛdɛ so nsuiili, de nkyoola, de ilaa kpɛi-kpɛi kamaasɛ gilaarɛ i kya gyi mɔmɔ-gimu. Imɔso i kya gɛɛlɛ agyɛbi abono mɛ nu mɔ, ne mɛŋ baa ma‑a taalɛ wɔra amɔ so ilaa mɔmɔ-gɛkyena dɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Asa ako mɔ, mɛ dɛ fɛɛ ayu abono a tɔrɔ gɛsinkpan dɛnsɛ so mɔ. Mɛ kya nu Wurubuaarɛ agyɛbi mɔ, de mɛꞌ nu gɛsɛ wɔra amɔ so ilaa mɔmɔ-gɛkyena dɔ fɛɛ gɛnɔɔbono dɔɔbo mɔ gi nyɛ ayu abono ɔnan o kyu ŋmadɛ mɔ, ako gikpadɔ oko de saalaa, ako ikue-isa, ne ako mɔ gikpadɔ ikue-inun mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Yesu san ɔ kya nyiile ɔmɔ ilaa mɔ, ɔ tɔgɛ yɛɛ, “Ɔko mɛŋ bo no ɔ laa nyɔga fatela kyu loo obu dɔ de oꞌ kyu fɛɛ gɛlɔbi baala bun mɔ so, abɛɛ oꞌ kyu wɔra npa gɛsɛ. Ɔ laa kyu mɔ gyanꞌ daa nfono i laa wu asa mɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","I lii fɛɛ sɛi mɛŋ bo no i bo ɔbɔ dɔ yɛɛ i maŋ lii gifuli, abɛɛ ilaa iko i ŋara yɛɛ i maŋ lii gɛwi. ");
INSERT INTO acd_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne Yesu yɛɛ, “Ilaa ibono fɛ nu mɔ, fɛꞌ kerɛ imɔ dɔ dɔɔdan. Kaala ɔbono fɛ laa kyu kaala mɔ, Wurubuaarɛ laa kyu mɔ-ɔnan kaala sa fɛye kee de oꞌ kii too fɛye. ");
INSERT INTO acd_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ɔbono ɔ kya nu Wurubuaarɛ asɛ mɔ, ɔ laa nyɛ nu too, ne ɔbono ɔŋ kya nu Wurubuaarɛ asɛ mɔ, ipii ibono o nu mɔ gbaa, i laa kii lii mɔ-gimu dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi a kya yɛlegɛ asa dɔ mɔ a dɛ fɛɛ ilaa duusɛ. Dɔɔbo kya kpaa ŋmadɛ fɛɛ ayu de ɔꞌ naa ba gɛwi mɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Gɛnyɛ de gɛpɛ, ɔ dɛ‑o, ɔ kerɛ‑o, gɛnɔɔbono ayu mɔ a kya kɔrɔ de aꞌ sen mɔ, ɔ mɛŋ nyi. ");
INSERT INTO acd_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Gɛsinkpan mɔ gbaa-gbaa ne n kya yɛgɛ ne ayu mɔ a kya kɔrɔ amɔ-gibaa so. A kɔrɔ mɔ de aꞌ baa da itɔ. A da itɔ mɔ de aꞌ boori wɔra abi de aꞌ pɛɛrɛ. ");
INSERT INTO acd_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","A pɛɛrɛ mɔ, dɔɔbo mɔ mɛŋ baa ɔ waala nkɛ. Ɔ kya loo amɔ dɔ gikɛbi daa. I kya nyiile yɛɛ ayu mɔ akɛbiberɛ a fo.” ");
INSERT INTO acd_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","O kii taasɛ mɔmɔ yɛɛ, “Nnɛ ne a laa tɔgɛ yɛɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a dɛ? Menɛ gikpalɛ ne a laa kyu kɛserɛ ne? ");
INSERT INTO acd_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Gɛnɔɔbono gɛnen akyenabi abono a kya yɛlegɛ asa dɔ mɔ i dɛ fɛɛ Maasadɛ giponfɛ ilaa. Pɛi ne fo laa duu gimɔ mɔ, gibi mɔ gi kerɛ faa ŋini-ŋini. Aponfɛ abi dɔ pɛwu mɔ, gimɔ ne mɛŋ kiirɛ. ");
INSERT INTO acd_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nengyene fo kyu gimɔ duu ne gi kɔrɔ mɔ, gi kya wɔra giponfɛ belɛ don giponfɛ kamaasɛ. Gi kya ba-ba ngyalenbi kiirɛsɛ de nbuii giꞌ taalɛ luo asisaa kyena gimɔ-oyuli dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Akpalɛ gikyɔ fafaanan so‑o ne Yesu gi kyu tɔgɛ Wurubuaarɛ agyɛbi sa mɔmɔ, gɛnɔɔbono ɔkara mɛ laa taalɛ nu gɛsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ɔŋ tɔngɛ de mɔmɔ yɛɛ ɔ mɛŋ da gikpalɛ. Nengyene i san mɔ‑rɛ mɔ-akasɛbo mɔ wolɛ mɔ, ɔ kya lɛɛ ilaa kamaasɛ gɛsɛ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","36","Gɛnen gɛkaabono gɛdɔɔdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ san mɛ bo gikolii mɔ dɔ mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Aꞌ fara kpe gibenbɛ.” Ne gɛsintin mɔ, akasɛbo mɔ mɛ palɛ Yesu de gikolii mɔ lii nfono kyon taa asa mɔ yɛgɛ. Akolii ako kee a buu mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","38","Mɛ kya kpe mɔ, Yesu tɛ gikolii mɔ gɛmara. Ɔ dɛ ginsi gidɛ, o sin gɛputu. Nfono mɔ afuu belɛ ako a tigi, a kya da ginyadon so. A kya yɛgɛ nkyu mɔ gi kya loo gikolii mɔ dɔ. I wɔra mɔmɔ gifuu, ne mɛ da Yesu kyingi taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, a kya laarɛ aꞌ sii faa, iŋ fɛ fo-giso?” ");
INSERT INTO acd_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Yesu gi kyingi, ne ɔ tɔgɛ afuu mɔ yɛɛ aꞌ taa gida yɛgɛ, de nkyu mɔ, mɔ, giꞌ wɔra bɔyin. Gɛsintin mɔ, afuu mɔ a tɔrɔ ne ilaa kamaasɛ i sii faa kurun. ");
INSERT INTO acd_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ne ɔ taasɛ mɔ-akasɛbo mɔ yɛɛ, “I wonɛ so ne fɛ gyɛ afuubo gɛnen? Fɛŋ kya sɔɔ me gyi?” ");
INSERT INTO acd_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Yesu akasɛbo mɔ mɛ wu ilaa ibono ɔ wɔra gɛnen mɔ, i dɛ ɔmɔ-gɛnɔ ne i wɔra mɔmɔ gifuu, mɛ san ma‑a taasɛ abara yɛɛ, “Menɛ nyamesɛ ɔnan ne? Kerɛ, afuu de nkyu gbaa gi kya nu mɔ-gɛdɛ.” ");
INSERT INTO acd_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ fara ɔbon belɛ mɔ kpe gibenbɛ giko so Gerigasa gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Yesu gi kpɛ lii gikolii mɔ dɔ mɔ, ɔnyen ɔko gi da lii ibuni opuleten ba de ɔꞌ baa gyangara mɔ. Ilaa nyɛnyɛn oduduu kpɛi-kpɛi i tɛ gɛnen ɔnyen ɔbono so. ");
INSERT INTO acd_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ibuni opuleten mɔ nno ne ɔnyen mɔ tɛ. Ilaa nyɛnyɛn oduduu kpɛi-kpɛi ibono i tɛ mɔ so mɔ so mɔ i yɛgɛ ɔko mɛŋ baa ɔ kya taalɛ ŋminde mɔ yela. Ba‑a fo ne n kine fo kyu agbangbaran, fo maŋ taalɛ. ");
INSERT INTO acd_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Gikpadɔ gifonɛɛ gifonɛɛ mɔ, asa mɛ da mɔ abaa de ayaa ilaran de ipan. Fɛɛ mɛ da mɔ ilaran de ipan gɛnen mɔ, ɔ kya wolaa gbaa-gbaa imɔ. Ɔ bo ɔlon gikyɔ ibono ɔko mɛŋ kya taalɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Gɛnyɛ de gɛpɛ ilaa nyɛnyɛn oduduu mɔ i kya yɛgɛ ɔnyen mɔ kya saawo ken-ken, ɔ kya kpen ibuni opuleten mɔ de abii so. I san mɔ, ɔ dɛ abui ɔ kya ten mɔ-nyoro giyan-giyan. ");
INSERT INTO acd_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Gɛnen ɔnyen baarɛ gi wu Yesu koo-koo ne ɔ selɛ kpaa ŋmii Yesu ayaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nfono ne Yesu gi ka sa ilaa nyɛnyɛn oduduu mɔ yɛɛ iꞌ koso lii ɔnyen mɔ so ɔ kerɛ imɔ faa. Yesu gi ka sa imɔ gɛnen mɔ, ilaa nyɛnyɛn oduduu mɔ i yɛgɛ ɔnyen mɔ gi kpen ken-ken taasɛ Yesu yɛɛ, “Me‑rɛ fo menɛ asɛ, Yesu, Gitɔbelɛ mɔ mɔ-bi? N dɛ Wurubuaarɛ ginyen n kya kolɛ fo, gɛŋ wɔra me awɔrɔfɔɔ.” ");
INSERT INTO acd_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Yesu gi taasɛ ilaa nyɛnyɛn oduduu mɔ yɛɛ, “Mɛ kya terɛ fo-ginyen yɛɛ menɛ?” ");
INSERT INTO acd_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ne ilaa nyɛnyɛn oduduu mɔ i lɛɛ gɛnɔ yɛɛ, “Mɛ kya terɛ me yɛɛ Sakpii, i kya nyiile yɛɛ a kyɔ.” Nfono ne ilaa nyɛnyɛn oduduu mɔ i tɛ ɔnyen mɔ so mɔ i kpɛ i kya dɛ Yesu giserɛ i kya kolɛ mɔ yɛɛ ɔ mɛŋꞌ sa ɔꞌ gya imɔ lii gɛnen gɛsinkpan gɛbono so. ");
INSERT INTO acd_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Aberɛ abono mɔ, akuuri gikpen belɛ giko gi yelɛ gibii mɔ alan dɔ nno mɛ kya gyi. ");
INSERT INTO acd_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Ne ilaa nyɛnyɛn oduduu mɔ i tɛ ɔnyen mɔ so mɔ i kolɛ Yesu yɛɛ ɔꞌ yɛgɛ imɔ iꞌ nyɛ kpe kpaa kyena akuuri mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Imɔso Yesu gi sa imɔ ɔkpa, ne i koso lii ɔnyen mɔ so kpaa kyena akuuri mɔ so. Akuuri mɔ pɛwu gɛgyɔnɔ gɛ laa wɔra fɛɛ nwɛ oko. Mɔmɔ pɛwu mɛ selɛ kpelegɛ de gibii mɔ kpaa loo ɔbon belɛ mɔ dɔ, ne nkyu mɔ gi gyi mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Anyen abono mɛ kya kerɛ akuuri mɔ so mɔ, mɛ selɛ kpe nten dɔ de ndɔɔana dɔ mɛ kya tɔgɛ ilaa ibono i ba mɔmɔ-akuuri mɔ so mɔ ma‑a sa asa nno. Ne asa mɔ mɛ lii kpaa kerɛ. ");
INSERT INTO acd_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Mɛ ba Yesu asɛ mɔ, mɛ wu ɔnyen mɔ nkana ilaa nyɛnyɛn oduduu gikpen mɔ gi tɛ mɔ so mɔ, o bun gikuru ɔ tɛ Yesu asɛ. Ɔ nyɛ mɔ-ginyamesɛ gɛwɔnsa. I wɔra asa mɔ gifuu ne i dɛ mɔmɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Abono mɛ yelɛ nfono ne mɛ wu ilaa kamaasɛ mɔ mɛ buu ilaa ibono i wɔra ɔnyen mɔ de ilaa ibono i wɔra akuuri mɔ sa asa abono mɛ selɛ baa tu ɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Asa abono mɛ tɛ gɛnen gɛsinkpan mɔ so mɔ mɛ kolɛ Yesu yɛɛ ɔꞌ lii mɔmɔ-gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Yesu kya dii ɔ loo gikolii dɔ mɔ, ɔnyen ɔbono nkana ilaa nyɛnyɛn oduduu mɔ i tɛ mɔ so mɔ gi kolɛ mɔ yɛɛ ɔꞌ yɛgɛ de ɔꞌ baa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Yesu mɔ mɛŋ kyule sa mɔ. Ɔ tɔgɛ mɔ daa yɛɛ ɔꞌ naa kpe gɛwi de ɔꞌ kpaa tɔgɛ sa mɔ-adɛ ilaa gbaaꞌ ibono Wurubuaarɛ gi wɔra sa mɔ mɔ de gɛnɔɔbono o su mɔ gitolon mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Imɔso ɔnyen mɔ gi naa kyon gɛsinkpan gɛbono mɛ kya terɛ yɛɛ Isowolɛ Gudu mɔ so. Ɔ kpaa tɔgɛ ilaa ibono pɛwu Yesu gi wɔra sa mɔ mɔ. Asa mɛ nu mɔ, i wɔra mɔmɔ giyan. ");
INSERT INTO acd_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Yesu gi kyu gikolii mɔ kii fara kpe ɔbon belɛ mɔ gibenbɛ giko so. O kpe mɔ, asa sakyɔ mɛ ba gigengen mɔ so nno baa kyaabɔɔ mɔ faa fina‑a. ");
INSERT INTO acd_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Nfono mɔ ɔnyen ɔko gi ba Yesu asɛ. Mɛ kya terɛ mɔ yɛɛ Gyarasɛ. Ɔ gyɛ Gyuda awura gikyangbon akerɛbo mɔ dɔ ɔko. Gyarasɛ gi wu Yesu mɔ, ɔ kpelegɛ ŋmii mɔ-ayaa dɔ ");
INSERT INTO acd_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ne ɔ kolɛ mɔ yɛɛ ɔꞌ gyan mɔ giwoo. Mɔ-bi kyiisɛ pii ɔko kya lɔ, ɔ kya laarɛ de oꞌ wu. Imɔso ɔꞌ kpaa kyu mɔ-abaa gyan gɛbii mɔ so de ɔꞌ kyɛ mɔ de ɔꞌ nyɛ nkpa. ");
INSERT INTO acd_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Yesu gi kyule ne o buu ɔnyen mɔ mɛ kya kpe ɔnyen mɔ gɛwi. Mɛ kya kpe mɔ, asa abono mɛ buu mɔmɔ mɔ mɛ nyaakyɔ, mɛ kya gɛnda de abara. Imɔso mɛ dɛ mɔmɔ-nyoro ma‑a kpiidɛ de mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Mɛŋ ti taa loo ɔnyen mɔ gɛwi mɔ, ɔkyii ɔko bo sakpii mɔ dɔ i kya da de mɔ. I kya da de mɔ faa, imɔ nsi gudu nnyɔ ne. ");
INSERT INTO acd_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","O kpe-kpe alɔtɔ akyɛbo asɛ, ne o wu ɔlaa mɔmɔ-abaa dɔ gikyɔ. Iŋ lɛɛ mɔ, i kya kii lɔrɔ kine daa. Ɔ nyida mɔ-aterenbi abono ɔ bo mɔ pɛwu, iŋ taa wɔra sɛi. ");
INSERT INTO acd_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","O nu Yesu so mɔ, ɔ tɔgɛ sa mɔ-nyoro yɛɛ, “Me-gibaa gi taa kpɛ nyɛ yii mɔ-gɛgbɛ mɔ, n nyi ibono i laa kyɛ me.” Ɔkyii mɔ gi buu Yesu gɛmara gɛmara baa loo sakpii mɔ dɔ lii kpaa yii Yesu gɛgbɛ. ");
INSERT INTO acd_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ayaa abono so mɔ, ibono i kya da de ɔkyii mɔ mɔ, i ten. Gɛnɔɔbono i tɛɛ mɔ-nyoro dɔ mɔ, i yɛgɛ ɔ bii yɛɛ mɔ-gilɔ mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Nfono mɔ, Yesu gi dɛsɛ yɛɛ mɔ-oduduu gi wɔra ilaa iko, ne o kisee kerɛ asa mɔ dɔ, ne ɔ taasɛ yɛɛ, “Anɛ ne n yii me-gɛgbɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Mɔ-akasɛbo mɔ mɛ buu mɔ mɔ mɛ kisee taasɛ mɔ yɛɛ, “Ne aye asa kpatakperɛ abono a kya gɛnda de abara faa, i wonɛ so ne fo kya taasɛ yɛɛ ɔko gi yii fo?” ");
INSERT INTO acd_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Yesu gi kisee ɔ kya kerɛ de oꞌ wu ɔkolon ɔbono o yii mɔ-gɛgbɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ɔkyii mɔ nyi ilaa ibono i wɔra mɔ-nyoro dɔ so mɔ, ɔ lii kpaa ŋmii Yesu ansi dɔ, ɔ kya seli gyin-gyin. I wɔra mɔ gifuu, ne ɔ tɔgɛ ilaa ibono i ba mɔ pɛwu gɛsintin sa Yesu. ");
INSERT INTO acd_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ɔkyii mɔ gi tɔgɛ ta mɔ ne Yesu yɛɛ, “Me-bi, gisɔɔgyi gibono fo bo sa me mɔ ne n kyɛ fo faa. Imɔso naa fo kya kpe de gisen yuuli. Fo-nyoro giꞌ tɔrɔ fo.” ");
INSERT INTO acd_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Yesu san ɔ yelɛ ɔ kya tɔngɛ ɔ kya sa ɔkyii mɔ mɔ, ako mɛ lii Gyarasɛ gɛwi ba. Gyarasɛ ne n gyɛ gikyangbon ɔkerɛbo ɔbono ɔ kolɛ Yesu yɛɛ ɔꞌ baa kyɛ mɔ-bi sa mɔ mɔ. Mɛ baa tɔgɛ Gyarasɛ yɛɛ, “Fo-bi mɔ gi wuꞌ. Menɛ so ne fo ba fi‑i nyala ɔbelɛnsɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Yesu gi nu ɔkalan ɔbono mɛ baa tɔgɛ Ɔbelɛnsɛ Gyarasɛ mɔ, o kisee tɔgɛ sa mɔ yɛɛ, “Gɛŋ sa foꞌ selɛ gifuu. Fo berɛ, kpɛ sɔɔ me gyi daa.” ");
INSERT INTO acd_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Yesu gi tɔgɛ gɛnen mɔ, ɔ gya asa mɔ pɛwu. Ɔŋ baa yɛgɛ mɛ buu mɔ baa too de Piita, Gyeemesi, de Gyɔn, Gyeemesi mɔ-tedɛ. ");
INSERT INTO acd_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mɛ naa kpaa loo ɔbelɛnsɛ mɔ gɛten dɔ mɔ, ɔlanba ne. Asa mɛ dɛ osulon mɛ yelɛ. ");
INSERT INTO acd_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Yesu gi loo nno mɔ, ɔ taasɛ yɛɛ, “Menɛ ɔlanba de osulon ne fɛ dɛ fɛ yelɛ gɛnen? Gɛbii mɔ gɛŋ wuꞌ, gɛ dɛ daa.” ");
INSERT INTO acd_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ɔ tɔgɛ gɛnen mɔ, mɛ kyu mɔ ŋmasɛ daa. Nfono mɔ ɔ gya asa mɔ lii gɛten mɔ dɔ, ne i san gɛbii mɔ mɔ-sɛ de mɔ-nyi de mɔ-akasɛbo asaꞌ abono mɛ buu mɔ mɔ, ne o kyu mɔmɔ loo obu mɔ dɔ nfono obuni mɔ dɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ɔ keda gɛbii mɔ gibaa dɔ, ne ɔ tɔgɛ de mɔ-gɛdɛ dɔ yɛɛ, “Talita kum!” (“Talita kum” gɛsɛ ne n gyɛ yɛɛ “Gɛbolonbubii, koso.”) ");
INSERT INTO acd_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Ayaa abono so mɔ, gɛbii kyiisɛ mɔ gɛ koso gɛ naa. I dɛ mɔmɔ-gɛnɔ gikyɔ kyɔde. Gɛbii kyiisɛ mɔ gɛ gyi nsi gudu nnyɔ gɛnen owi ɔbono. ");
INSERT INTO acd_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ne Yesu gi ka sa mɔmɔ yɛɛ mɛŋꞌ sa mɛꞌ tɔgɛ imɔ sa ɔko‑rɛ ɔko. Ne ɔ tɔgɛ sa mɔmɔ yɛɛ mɛꞌ laarɛ ilaa iko sa gɛbii mɔ de gɛꞌ gyi. ");
INSERT INTO acd_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Yesu gi lii gɛnen ɔsowolɛ ɔbono so kpe mɔ-gɛwi. Mɔ-akasɛbo mɔ mɛ buu mɔ kpe. ");
INSERT INTO acd_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","I fo gɛkɛ kyoolasɛ mɔ, Yesu gi yii gɛsɛ ɔ kya nyiile asa ilaa mɔmɔ-gikyangbon dɔ. Asa abono mɛ bo nno mɔ mɛ nyaakyɔ. Mɛ nu mɔ-ilaa nyiilesɛ mɔ, i dɛ mɔmɔ-gɛnɔ. Mɛ san mɛ kya taasɛ yɛɛ, “Fonɛ ne ɔdɛ gi nyɛ imɔ idɛ pɛwu lii? Fonɛ ne ɔ nyɛ ɔlaako ginyi gidɛ lii? Nnɛ so nnɛ so ne ɔ kya nyɛ wɔra amunale ilaa gɛnen? ");
INSERT INTO acd_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Iŋ gyɛ mɔ ne n gyɛ kaafenta mɔ? Iŋ gyɛ mɔ-nyi ne n gyɛ Mariya? Iŋ gyɛ mɔ-tedɛana ne n gyɛ Gyeemesi, Gyosɛfo, Gyudasɛ de Simon? Iŋ gyɛ aye‑rɛ mɔ-pikyiiana ne n tɛ gɛrɛ?” Yesu mɛŋ gyɛ isafo sa mɔmɔ so mɔ, mɛ mɛŋ kyule nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yesu gi wu gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Wurubuaarɛ ikalan ɔtɔgɛbo kya gyi ginsi gɛten kamaasɛ, gɛnen mɔ, mɔ-gɛwi, mɔ gbaa-gbaa gɛten dɔ de mɔ-subuana asɛ wolɛ.” ");
INSERT INTO acd_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Yesu mɛŋ taalɛ wɔra amunale ilaa ibono i kya dɛ gɛnɔ mɔ nfono. O kyu mɔ-abaa gyan daa alɔbo kalɛsɛ ako so ne ɔ kyɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","I dɛ Yesu gɛnɔ yɛɛ asa mɔ mɛ mɛŋ sɔɔ mɔ gyi. Yesu gi lii nno mɔ, ɔ naa de isowolɛ ibono i sindi nfono mɔ ɔ kya nyiile mɔmɔ Wurubuaarɛ agyɛbi. ");
INSERT INTO acd_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ɔ terɛ mɔ-akasɛbo gudu anyɔ mɔ, ne o sun mɔmɔ yɛɛ mɛꞌ naa anyɔ-anyɔ kpe isowolɛ so, ne ɔ sa mɔmɔ ɔlon de mɛꞌ taalɛ gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so. ");
INSERT INTO acd_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ɔ ka sa mɔmɔ yɛɛ, “Fɛ kya kpe faa, fɛŋ sa fɛꞌ puru sɛi-sɛi keda baa too de fɛye-iyii tugɛsɛ. Fɛŋ sa fɛꞌ puru agyudɔ keda. Fɛ mɛŋꞌ keda atɔ ɔwɔraten. Fɛ mɛŋꞌ puru aterenbi wɔra fɛye-igo ibɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Fɛŋꞌ sa fɛꞌ suu ngbɛ nnyɔ. Ayaawolɛ berɛ fɛꞌ wɔra.” ");
INSERT INTO acd_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Gɛten gɛbono dɔ fɛ loo mɔ, fɛꞌ kyena nno kaaborɛ fɛ laa lii ɔsowolɛ ɔbono so. ");
INSERT INTO acd_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Nengyene fɛ loo ɔsowolɛ ɔko so ne nno asa mɛ kine mɛ mɛŋ bugi ansi de fɛye abɛɛ mɛ mɛŋ nu fɛye asɛ mɔ, fɛ lii ɔsowolɛ mɔ so mɔ, fɛꞌ kpiisi fɛye-ayaa isɛ yela mɔmɔ. Imɔ ne nan lɛɛ nyiile asa yɛɛ mɛ kine Wurubuaarɛ ɔkalan faa mɔ, gisobiidɛ gi dɛ gi gyoo mɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Gɛsintin mɔ, Yesu akasɛbo gudu anyɔ mɔ mɛ kyon kpaa tɔgɛ sa asa yɛɛ mɛꞌ nu mɔmɔ-nyoro gɛsɛ de mɛꞌ kyɛɛgɛ mɔmɔ-nwɔnsa lii ilaa nyɛnyɛn giwɔra dɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mɛ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi gikyɔ ibono i tɛ asa so mɔ, ne mɛ kyu nfɔ nko kyu nyaa alɔbo sakyɔ, ne mɔmɔ-alɔtɔ a ta. ");
INSERT INTO acd_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Wura Hɛrodɛ kee gi nu Yesu ilaa wɔrasɛ mɔ so. I kya nyiile yɛɛ Yesu ginyen gi nu gyan de gɛten kamaasɛ. Ako yɛɛ, “Oloobu Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ ne. O kyingi lii ibuni dɔ daa so ne ɔ nyɛ ɔlon ɔ kya wɔra ilaa gbaaꞌgbaa ibono i kya dɛ gɛnɔ gɛnen faa.” ");
INSERT INTO acd_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ako mɔ mɛ kya sɔɔ akyɔɔlɛ yɛɛ, “Kuaa. Oloobu Ilaagya ne n kii ba.” Abanban mɔ yɛɛ, “Ɔ gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo fɛɛ Wurubuaarɛ ikalan atɔgɛbo adedaabo mɔ ɔko.” ");
INSERT INTO acd_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Wura Hɛrodɛ gi nu Yesu ilaa mɔ mɔ, mɔ-lɛɛ ibono ɔ kya tɔgɛ mɔ ne n gyɛ yɛɛ, “Gyɔn ɔbono nɛ yɛgɛ mɛ ten mɔ-gimu mɔ ne n kii kyingi faa.” ");
INSERT INTO acd_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Gɛnɔɔbono i ba ne Wura Hɛrodɛ gi yɛgɛ mɛꞌ ten Gyɔn gimu mɔ ne n gyɛ yɛɛ, wura mɔ mɔ-tedɛ Filipo gi dena ɔkyii ɔko, mɛ kya terɛ mɔ yɛɛ Hɛrodiyasɛ, ne Wura Hɛrodɛ gi sɔgɛ ɔkyii mɔ kyu dena. ");
INSERT INTO acd_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Gyɔn mɔ gi nu gɛnen mɔ, ɔ kya tɔgɛ wura mɔ yɛɛ, “Fo sɔgɛ fo-tedɛ mɔ-ka faa, iŋ boran. Iŋ dɛ ɔkpa gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Ɔkyii mɔ gi nu yɛɛ Gyɔn kya kyɔɔlɛ mɔ‑rɛ wura mɔ gɛdena mɔ mɔ, ɔ sɔɔ ginyadon de Gyɔn. Imɔso mɔ-kuli wura mɔ gi kpaa keda Gyɔn ŋminde tii de obu. Ɔkyii mɔ gi laarɛ fɛɛ mɛꞌ mɔɔ mɔ; oŋ kii nyɛ. ");
INSERT INTO acd_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","I kya nyiile yɛɛ wura mɔ nyi yɛɛ Gyɔn gi lɔrɔ mɔ-nyoro yela ne ɔ kya gyi gɛsintin sa Wurubuaarɛ. Imɔso ɔ selɛ mɔ, ne ɔ mɛŋ yɛgɛ de mɛꞌ mɔɔ mɔ. Ɔ kya kyena nu Gyɔn agyɛbi tɔgɛsɛ mɔ, mɔ-gɛwɔnsa dɔ iŋ kya kyena mɔ ɔkpa kolon. I kii i dɛ mɔ agyɛbi mɔ ginu. ");
INSERT INTO acd_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Gɛkɛ gɛdɛ mɔ Wura Hɛrodɛ kya gyi mɔ-gɛkɛ korogɛsɛ gɛsi. Imɔso ɔ da gibaa terɛ mɔ-abelɛnsɛ de mɔ-asogya abelɛnsɛ de Galeli abelɛnsɛ gbaaꞌgbaa yɛɛ mɛꞌ baa gyi gɛkɛ mɔ kpaa mɔ. Gɛnen gɛkɛ gɛbono mɔ i bugi ɔkpa sa Hɛrodiyasɛ de ɔꞌ nyɛ Gyɔn mɔɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Asa mɔ mɛ gyan mɛ kya gyi gɛkɛ belɛ mɔ, Hɛrodiyasɛ mɔ-bi obolonbu ɔko gi lii kyaa tala asa mɔ ansi. Mɔ-gɛkyaa mɔ gɛ wɔra Wura Hɛrodɛ mɔ‑rɛ mɔ-asafo mɔ ɔbolɛ gikyɔ. Imɔso ɔ ka sa obolonbu mɔ yɛɛ, “Ilaa kamaasɛ ibono fo kya laarɛ mɔ, tɔgɛ me, nan kyu sa fo.” ");
INSERT INTO acd_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","O kii ka sa obolonbu mɔ yɛɛ, “Nengyene fo taasɛ me ne meŋ nyɛ sa fo mɔ, nɛ tɔrɔ ntan. Ba‑a me-gɛsinkpan mɔ de gɛmɔ-asa mɔ gibaafon pɛwu ne fo kya laarɛ mɔ, nan kyu sa fo.” ");
INSERT INTO acd_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Obolonbu mɔ gi lii kpaa taasɛ mɔ-nyi yɛɛ, “Menɛ ne nꞌ tɔgɛ wura mɔ yɛɛ ɔꞌ sa me?” Ne mɔ-nyi yɛɛ, “Tɔgɛ mɔ yɛɛ Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ gimu ne fo kya laarɛ.” ");
INSERT INTO acd_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ayaa abono so mɔ, obolonbu mɔ gi selɛ kpaa tɔgɛ wura mɔ yɛɛ, “N kya laarɛ daa Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ gimu tangalan dɔ ayaa adɛ so.” ");
INSERT INTO acd_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Obolonbu mɔ gi taasɛ gɛnen mɔ, i yɛgɛ Wura Hɛrodɛ gisen dɔ i nyida mɔ. Ɔ ti ka ntan abelɛnsɛ mɔ ansi dɔ so mɔ, mɔ, iŋ kya sa mɔ gikine. ");
INSERT INTO acd_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Imɔso ayaa abono so mɔ, o sun mɔ-nten amuana mɔ dɔ ɔko yɛɛ ɔꞌ kpaa kyu Gyɔn gimu ba, ne ɔ kpaa ten mɔ-gimu nfono o tii de obu mɔ, ");
INSERT INTO acd_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ne o kyu gimɔ taga tangalan dɔ kyu bara obolonbu mɔ, ne obolonbu mɔ gi kyu kperɛ mɔ-nyi. ");
INSERT INTO acd_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Gyɔn akasɛbo mɔ mɛ nu gɛnen mɔ, mɛ kpaa kyu mɔ-gibuni mɔ kyu kpaa pule. ");
INSERT INTO acd_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Yesu akasɛbo mɔ mɛ lii nfono o sun mɔmɔ mɔ ba mɔ, mɛ baa buu ilaa ibono mɛ wɔra mɔ de ibono mɛ nyiile mɔ pɛwu sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mɛ ba mɔ, asa mɛ kpɛ ma‑a dii ma‑a kpelegɛ mɔmɔ so. Imɔso i yɛgɛ mɛŋ kya nyɛ nyoro de mɛꞌ gyi gbaa. Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ koso de aye-wolɛ aꞌ kpe nfono asa mɛŋ tɛ mɔ de fɛꞌ nyɛ kyoola ŋmaraa.” ");
INSERT INTO acd_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ne gɛsintin mɔ, mɛ dii loo mɔmɔ-gikolii dɔ ne mɛ kyon nfono asa mɛŋ bo mɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Mɛ kya kpe mɔ, asa sakyɔ mɛ wu mɔmɔ bii. Imɔso mɛ kuu ɔnangya lii isowolɛ mɔ pɛwu so kyu de gigengen so, ne mɛ gyangbara kpaa gyoo mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yesu gi lii gikolii mɔ dɔ yelɛ gigengen mɔ, o wu sakpii belɛ-belɛ ti ɔ yelɛ. O wu mɔmɔ gɛnen mɔ, mɔmɔ-ilaa i wɔra mɔ ayen, i lii fɛɛ mɛ dɛ fɛɛ isandɛ ibono mɛŋ bo ɔkparɛbo. Ne o nyiile mɔmɔ ilaa gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ɔ kya nyiile asa mɔ ilaa ɔ kya kpe mɔ, owi kya ta. Imɔso mɔ-akasɛbo mɔ mɛ kpaa tɔgɛ mɔ yɛɛ, “Nfono a bo faa, i gyɛ daa ifɛ nsana, ne owi kya ta. ");
INSERT INTO acd_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Imɔso lɛɛ asa mɔ ɔkpa de mɛꞌ naa kpe isowolɛ de ndɔɔana nbono gi sindi gɛrɛ mɔ de mɛꞌ kpaa nyɛ agyudɔ sɔɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ sa mɔmɔ ilaa iko de mɛꞌ gyi.” Yesu akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Aꞌ kyu aterenbi belɛ kyu kpaa sɔɔ bodobodo bara asa adɛ de mɛꞌ gyi?” ");
INSERT INTO acd_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nfono ne Yesu gi taasɛ mɔ-akasɛbo mɔ yɛɛ, “Ibodobodo ifonɛ ne fɛ bo? Fɛꞌ kpaa kerɛ de fɛꞌ baa buu sa me.” Mɛ kpaa kerɛ, ne mɛ baa buu sa mɔ yɛɛ, “A bo daa ibodobodo inun de iken inyɔ.” ");
INSERT INTO acd_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Nfono ne Yesu gi tɔgɛ yɛɛ asa mɔ pɛwu mɛꞌ kpelegɛ kyena ifɛ bonboli mɔ so akpen-akpen. ");
INSERT INTO acd_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Gɛsintin mɔ, mɛ kyena ifɛ mɔ so akpen ako dɔ, ikue inun-inun, de akpen ako mɔ dɔ, ikue-inyɔ de saalaa-saalaa. ");
INSERT INTO acd_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Mɛ kyena gɛnen mɔ, Yesu gi puru ibodobodo inun mɔ de iken inyɔ mɔ, ne ɔ diirɛ mɔ-ansi kerɛ soso, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa ibodobodo mɔ dɔ ne o kyu sa mɔ-akasɛbo mɔ de mɛꞌ kyu sa asa mɔ. Ɔ yɛ iken inyɔ mɔ kee sa asa mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Mɔmɔ pɛwu mɛ gyi kaabo. ");
INSERT INTO acd_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Yesu akasɛbo mɔ mɛ koola-koola bodobodo mɔ de iken agyisan mɔ pɛwu mɔ, i bɔla nkeebii gudu nnyɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Anyen abono mɛ saarɛ asa abono mɛ gyi agyudɔ mɔ gɛgyɔnɔ gɛ gyɛ anyen nwɛ ikue-inyɔ de saalaa. ");
INSERT INTO acd_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Nfono mɔ, Yesu gi yɛgɛ mɔ-akasɛbo mɔ mɛ dii loo gikolii mɔ dɔ de mɛꞌ gyangbara mɔ fara kpe Bɛsayida, gibenbɛ giko mɔ so de mɔ mɔ ɔꞌ lɛɛ sakpii mɔ ɔkpa de ɔꞌ baa tu ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Yesu gi lɛɛ mɔmɔ-ɔkpa ta mɔ, ɔ dii kpe abii dɔ de ɔꞌ kpaa dalaa. ");
INSERT INTO acd_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","I kya bun mɔ, i san Yesu wolɛ gɛsinkpan mɔ so nno yɛgɛ mɔ-akasɛbo mɔ mɛ bo gikolii mɔ dɔ mɛ gyan nkyu so mɛ kya kpe. Mɛ ti fo nkyu mɔ nsansana. ");
INSERT INTO acd_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Yesu gi wu mɔ-akasɛbo mɔ mɛ kya yiyɛɛ de gikolii mɔ nkyu mɔ so. I kya nyiile yɛɛ afuu a kya da ken-ken kyu kpe de nfono so mɛ lii de mɔ. Imɔso i yɛgɛ mɛ kya palɛ gikolii mɔ mɛ kya kpon. I baa fo sindi gibaadiikɛ mɔ, Yesu naa nkyu mɔ so ɔ kya kpe de mɔmɔ asɛ. Ɔ kerɛ ansi wɔra fɛɛ ɔ laa kyon mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Mɛ wu mɔ ɔ naa nkyu mɔ so ɔ kya ba mɔ, mɛ nyi yɛɛ obuni. Mɛ san mɛ kya saawo. ");
INSERT INTO acd_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Mɔmɔ pɛwu mɛ wu mɔ mɔ, i ŋmaa mɔmɔ-asen. Ayaa abono so mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ keda nyoro. Me Yesu ne. Fɛŋ sa fɛꞌ selɛ gifuu.” ");
INSERT INTO acd_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nfono mɔ ɔ dii loo mɔmɔ asɛ gikolii mɔ dɔ ne afuu mɔ a taa gida yɛgɛ. A taa yɛgɛ gɛnen mɔ, i dɛ mɔmɔ-gɛnɔ gikyɔ kyɔde. ");
INSERT INTO acd_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","I kya nyiile yɛɛ gɛnɔɔbono Yesu gi yɛgɛ ibodobodo mɔ iꞌ ŋan mɔ, mɛ mɛŋ ti nu imɔ gɛsɛ. Mɔmɔ-nwɔnsa dɔ iŋ bugi de mɛꞌ bii isa ɔbono ɔnan Yesu gyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mɛ fara ɔbon belɛ mɔ lii kpe gibenbɛ giko mɔ so, Gɛnɛsarɛtɛ gɛsinkpan so, ne mɛ ŋminde mɔmɔ-gikolii mɔ kyaga nfono. ");
INSERT INTO acd_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Mɛ kpɛ mɛ kya lii gikolii mɔ dɔ mɔ, asa mɛ wu Yesu bii, ");
INSERT INTO acd_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","imɔso mɛ selɛ gyan de gɛsinkpan mɔ pɛwu mɛ kya sola alɔbo mɔmɔ‑rɛ mɔmɔ-afengen mɛ dɛ ma‑a kpe nfono mɛ kya nu yɛɛ Yesu bo mɔ. ");
INSERT INTO acd_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Gɛten kamaasɛ gɛbono Yesu gi kpɛ nyɛ loo mɔ, isowolɛ belɛ-belɛ so‑o, nsowolɛbi so‑o, ndɔɔ dɔ‑o, mɛ kya kyu alɔbo kpaa yela sansana, de mɛꞌ kolɛ mɔ yɛɛ ɔꞌ yɛgɛ mɛꞌ yii ba‑a mɔ-gɛgbɛ ginɛbi. Gɛsintin mɔ, ɔkamaasɛ ɔbono ɔ nyɛ yii mɔ-gɛgbɛ mɔ, mɔ-alɔtɔ a kya ta. ");
INSERT INTO acd_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farasii gikpen dɔ awura ako de Gyuda awura nbara aŋmarasɛbo ako mɛ lii Gyɛrusalem ɔsowolɛ so baa gyan Yesu asɛ. ");
INSERT INTO acd_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Nfono mɔ mɛ wu Yesu akasɛbo ako mɛ tɛ mɛ kya gyi ibono mɛ mɛŋ foro mɔmɔ-abaa mɔmɔ Gyuda awura itiibilaa aforobi de iꞌ lɛɛ ilaa kyɔlesɛsɛ sa mɔmɔ pɛi de mɛꞌ lɔɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Farasii awura de mɔmɔ Gyuda awura asɛnsɛ mɔ pɛwu berɛ mɛ kya wɔra mɔmɔ-tiibi ilaa wɔrasɛ ibono mɛ kasɛ lii mɔmɔ-sɛana asɛ mɔ, imɔso mɛŋ kya gyi yɛɛ mɛ mɛŋ foro mɔmɔ-abaa itiibilaa aforobi. ");
INSERT INTO acd_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Mɔmɔ-ilaa kyosɛ i nyaakyɔ gikyɔ. Nengyene ba‑a mɛ lii gigya ba mɔ, mɛ kya kyu nkyu ŋmadɛ mɔmɔ-nyoro pɛi de mɛꞌ lɔɔ nyɛ gyi. Ne mɛ kya kyu nkyu ŋmadɛ nwɛ, nlɔbi, de ikuruwa de sɛi ɔŋꞌ sa ɔꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Imɔso Farasii awura mɔ de Gyuda awura nbara aŋmarasɛbo mɔ mɛ taasɛ Yesu yɛɛ, “I wonɛ so ne fo-akasɛbo mɔ mɛ kya kerɛ ansi taa aye-itiibilaa mɔ giwɔra yɛgɛ daa? Imɔ ne n gyɛ yɛɛ mɛ laa gyi mɔ, mɛŋ kya foro mɔmɔ-abaa aye-itiibilaa aforobi mɔ de sɛi ɔŋꞌ sa ɔꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson.” ");
INSERT INTO acd_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Abelɛnsɛ mɔ mɛ taasɛ Yesu gɛnen mɔ, ɔ lɛɛ gɛnɔ kyu bun mɔmɔ gipuɛɛ yɛɛ, “Wurubuaarɛ ɔkalan ɔbono Isaya gi nu tɔgɛ mɔ i kyena de fɛye-gikerɛansi ilaa wɔrasɛ idɛ gɛsintin so. Isaya gi nu Wurubuaarɛ gi tɔgɛ yɛɛ, ‘Ansi so ne me-asa adɛ mɛ kya lɛɛ me-ginyen; Mɔmɔ-nwɔnsa dɔ berɛ, me‑rɛ mɔmɔ aŋ bo gɛsu. ");
INSERT INTO acd_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mɛ kya son me daa ansi so giyan. I kya nyiile yɛɛ anyamesɛ-lɛɛ nbara ne mɛ dɛ mɛ kya penɛ mɛ kya nyiile asa yɛɛ i gyɛ me Wurubuaarɛ-lɛɛ.’ ");
INSERT INTO acd_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Fɛye Farasii awura de nbara aŋmarasɛbo mɔ, fɛ too Wurubuaarɛ-lɛɛ nbara mɔ fuɛ ne fɛ san fɛ kya gyi daa anyamesɛ-lɛɛ tiibi ilaa wɔrasɛ mɔ so.” ");
INSERT INTO acd_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Yesu gi kii tɔgɛ mɔmɔ yɛɛ, “Gɛnɔɔbono fɛ nyaa Wurubuaarɛ nbara mɔ yela nkan de fɛꞌ nyɛ sii de fɛye anyamesɛ itiibilaa faa mɔ, fɛ wɔra ilaa ne? ");
INSERT INTO acd_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Adedaabo owi mɔ, Wurubuaarɛ gi yela nbara sa Mosisi yɛɛ oꞌ kyu sa fɛye. Nbara mɔ nko ne n gyɛ yɛɛ, ‘Buu fo-sɛ de fo-nyi.’ Nko kee ne n gyɛ yɛɛ, ‘Fo ɔbono fo tɔgɛ nnɔ wɔra fo-sɛ abɛɛ fo-nyi mɔ, mɛꞌ mɔɔ fo.’ ");
INSERT INTO acd_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Fɛye Farasii awura de nbara aŋmarasɛbo adɛ berɛ, fɛŋ kya gyi nbara ndɛ so. Ɔko bo no, ɔ laa sɔɔ ginyadon wɔra mɔ-nyi de mɔ-sɛ, ɔŋ kya laarɛ mɛꞌ yii mɔ-ilaa. Ɔ laa tɔgɛ sa mɔmɔ yɛɛ, ‘Ilaa ibono n bo ne nkana nan kyu kpaa fɛye mɔ, fɛŋ baa nyɛ yii imɔ, i gyɛ Koriban.’ (Koriban gyɛ ntan nbono i kya nyiile yɛɛ nɛ lɔrɔ imɔ yela sa Wurubuaarɛ.) ");
INSERT INTO acd_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Ɔ ka Koriban ntan ne gɛmara o nu mɔ-nyoro gɛsɛ yɛɛ iŋ boran mɔ, fɛye Gyuda awura nbara aŋmarasɛbo de Farasii awura mɔ fɛŋ baa fa‑a yɛgɛ mɔ de ɔꞌ lɛɛ Koriban ntan mɔ de mɔ-nyi abɛɛ mɔ-sɛ mɛꞌ nyɛ yii mɔ-ilaa. ");
INSERT INTO acd_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Fɛye-anyamesɛ itiibilaa idɛ so mɔ, fɛ kya nyaa Wurubuaarɛ agyɛbi mɔ yela nkan. Fɛye-itiibilaa idɛ ne fɛ dɛ fɛ kya nyiile fɛye-biana baa lii de ndɛ faa. Iŋ gyɛ yɛɛ Koriban ntan ndɛ wolɛ gbaa; fɛ kya wɔra imɔ idɛ ɔnan kee gikyɔ.” ");
INSERT INTO acd_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Yesu gi kii terɛ sakpii ɔbono ɔ bo nfono mɔ ba mɔ asɛ ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛye pɛwu fɛꞌ yela giso de fɛꞌ nu gɛsɛ yɛɛ ");
INSERT INTO acd_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","sɛi mɛŋ bo no i laa loo nyamesɛ gɛnɔ dɔ de iꞌ kyɔlesɛ mɔ-Wurubuaarɛ ɔson. Gɛnen mɔ, ilaa ibono i kya lii mɔ-gɛnɔ dɔ mɔ wolɛ ne n kya kyɔlesɛ mɔ-Wurubuaarɛ ɔson.  ");
INSERT INTO acd_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɔkamaasɛ ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Yesu gi taa sakpii mɔ yɛgɛ ne ɔ loo gɛten dɔ mɔ, mɔ-akasɛbo mɔ mɛ taasɛ mɔ ilaa ibono ɔ tɔgɛ sa sakpii mɔ mɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Yesu gi lɛɛ gɛnɔ taasɛ mɔmɔ yɛɛ, “Imɔso fɛye kee fɛye-nwɔnsa dɔ iŋ ti bugi de fɛꞌ nu ilaa gɛsɛ? Imɔso fɛ mɛŋ nyi yɛɛ sɛi mɛŋ bo no i laa loo nyamesɛ gɛnɔ dɔ de iꞌ kyɔlesɛ mɔ-Wurubuaarɛ ɔson? ");
INSERT INTO acd_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","I kya nyiile yɛɛ iŋ kya loo mɔ-gɛwɔnsa dɔ, i kya loo daa mɔ-ɔtɔ dɔ de ɔꞌ kɔɔ fuɛ.” Yesu gi tɔgɛ gɛnen mɔ, ɔ lɛɛ nyiile yɛɛ ilaa gyisɛ kamaasɛ i boran; iŋ kya kyɔlesɛ nyamesɛ Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Yesu gi kii lɛɛ gɛsɛ bɔla yɛɛ, “Ilaa ibono i kya lii nyamesɛ gɛwɔnsa dɔ mɔ ne n kya kyɔlesɛ mɔ-Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","I kya nyiile yɛɛ nyamesɛ kya sa gɛwɔnsa pɛi ne ɔ kya wɔra ilaa nyɛnyɛn fɛɛ ɔ kya laarɛ ogyibara, ɔ kya yuuri, ɔ kya mɔɔ asa, ");
INSERT INTO acd_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ɔ kya lii mɔ-ka abɛɛ mɔ-kuli gɛmara, ɔ kya wɔra onsipara, ɔ kya sa gɛkpɛ nwɔnsa, ɔ kya penɛ asa, ɔ kya wɔra ilaayan, ɔ bo gɛlaaloo, ɔ kya nyida asa, ɔ kya nyiile mɔ-nyoro, ne ɔ kya wɔra ilaa gyaga. ");
INSERT INTO acd_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Gɛnen ilaa nyɛnyɛn idɛana pɛwu i kya lii nyamesɛ gɛwɔnsa dɔ ne imɔ ne n kya kyɔlesɛ mɔ-Wurubuaarɛ ɔson.” ");
INSERT INTO acd_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Yesu gi koso lii nno kyon kpe gɛsinkpan gɛko so, gɛ sindi Taya de Sidon isowolɛ. Ɔ fo nno mɔ, ɔ kpaa loo gɛten gɛko dɔ. Ɔŋ kya laarɛ de ɔko oꞌ wu mɔ. Ɔŋ bo ŋara dɔ so mɔ, imɔ pɛwu i wɔra giyan. ");
INSERT INTO acd_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","26","Mɔ‑rɛ mɔ-giloo mɔ, ɔkyii ɔko gi nu mɔ so. Ilaa nyɛnyɛn oduduu i tɛ gɛnen ɔkyii mɔ mɔ-bi kyiisɛ so. Ɔkyii mɔ gi baa kpelegɛ dɛ Yesu ayaa dɔ, ne ɔ kolɛ mɔ yɛɛ ɔꞌ gya gɛnen ilaa nyɛnyɛn oduduu mɔ koso mɔ-bi mɔ so sa mɔ. Ɔkyii mɔ gi lii Sirofinisiya gɛsinkpan so. Ɔŋ gyɛ asa abono mɛ kya son Wurubuaarɛ mɔ dɔ isa. ");
INSERT INTO acd_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ɔkyii mɔ gi kolɛ Yesu mɔ, Yesu gi tɔgɛ sa mɔ yɛɛ, “Iŋ kaaborɛ fɛɛ ɔko oꞌ kyu nbii agyudɔ kyu too sa igyoono aberɛ abono nbii mɔ mɛŋ ti gyi mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ɔkyii mɔ yɛɛ, “Me-wura, i gyɛ gɛsintin berɛ. Imɔ, mɔ, igyoono gbaa kee mɛ kya nyɛ tɔɔsɛ ibono nbii mɛ kya gyi ne i kya lii tɔrɔ lɛpɛ gikɔɔdɔ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ne Yesu gi kisee tɔgɛ sa ɔkyii mɔ yɛɛ, “Ibono fo tɔgɛ faa so mɔ, nɛ yɛgɛ ilaa nyɛnyɛn oduduu mɔ gi koso fo-bi mɔ so, imɔso fo berɛ, naa kpe gɛwi.” ");
INSERT INTO acd_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Gɛsintin mɔ, ɔkyii mɔ gi kii kpe gɛwi mɔ, ɔ kpaa wu mɔ-bi mɔ dɛ gifengen so; ilaa nyɛnyɛn oduduu ibono nkana i tɛ gɛbii mɔ so mɔ i koso. ");
INSERT INTO acd_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yesu gi lii gɛsinkpan gɛbono gɛ sindi Taya ɔsowolɛ so mɔ kpaa loo lii Sidon ɔsowolɛ so kyu gɛnen‑n kpaa lii gɛsinkpan gɛbono so Isowolɛ Gudu mɔ i bo mɔ baa fo ɔbon belɛ ɔbono mɛ kya terɛ mɔ yɛɛ Galeli mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Asa ako mɛ kyu ɔlɔbo ɔko kyu baa tu Yesu. Ɔlɔbo mɔ gyɛ daa osintiribu ne ɔ kya tɔngɛ mɔ, iŋ kya lii dɔɔdan. Nfono mɔ asa mɔ mɛ kolɛ Yesu yɛɛ ɔꞌ wɔra aniya de oꞌ kyu mɔ-gibaa gyan ɔlɔbo mɔ so de mɔ-gilɔ mɔ giꞌ ta. ");
INSERT INTO acd_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yesu gi kyu ɔnyen mɔ lii sakpii mɔ dɔ kpe nkan ne o kyu mɔ-abaabi wɔra ɔnyen mɔ aso dɔ. Imɔ gɛmara mɔ, ɔ too akyɔlɛ bun mɔ-gibaabi so ne o kyu yii ɔnyen mɔ ɔnandii. ");
INSERT INTO acd_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ne Yesu gi diirɛ mɔ-ansi kerɛ soso ne ɔ muusi. Ɔ kisee kerɛ ɔnyen mɔ ne ɔ tɔgɛ de mɔ-gɛdɛ dɔ yɛɛ “Ɛfata”. (Ɛfata gɛsɛ ne n gyɛ yɛɛ, “Tigi”.) ");
INSERT INTO acd_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Nfono mɔ ɔnyen mɔ aso mɔ a tigi, ne ɔ san ɔ kya nu ilaa, ne mɔ-ɔnandii kee gi sangɛ ɔ san ɔ kya tɔngɛ dandan. ");
INSERT INTO acd_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yesu gi kyɛ ɔnyen mɔ mɔ, ɔ da asa mɔ tii yɛɛ mɛŋ sa mɛꞌ buu ilaa idɛ sa ɔko‑rɛ ɔko. Ɔ kya gya mɔmɔ mɔ, i kya lɔrɔ wɔra mɔmɔ iwen daa. ");
INSERT INTO acd_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Gɛnɔɔbono Yesu gi kyɛ ɔnyen mɔ mɔ, i wɔra ɔkamaasɛ giyan. Mɛ san ma‑a tɔgɛ yɛɛ, “Yesu kya wɔra daa ilaa dɛnsɛ so‑o. Isintiribu de imuumuu gbaa, ɔ kya kyɛ mɔmɔ mɛ kya nu ilaa ne mɛ kya tɔngɛ.” ");
INSERT INTO acd_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Gɛnen nkɛ nbono dɔ mɔ asa mɛ kii gyan Yesu asɛ faa fiye‑e. Ɔsowolɛ mɛŋ bo nno, ne asa mɔ mɛŋ bo agyudɔ de mɛꞌ gyi. Nfono mɔ Yesu gi terɛ mɔ-akasɛbo mɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ndɛ nkɛ nsa ne asa gikpen belɛ gidɛ mɛ buu me faa, mɛ mɛŋ baa mɛ bo agyudɔ de mɛꞌ gyi. Imɔso mɔmɔ-ilaa i bo me ayen. ");
INSERT INTO acd_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nengyene nɛ tɔgɛ mɔmɔ yɛɛ mɛꞌ naa kpe mɔmɔ-nwi yɛgɛ mɛ mɛŋ nyɛ sɛi gyi mɔ, mɛ laa tɔrɔ agbalɛ ɔkpa dɔ. Ako mɛ maŋ taalɛ loo gɛwi. Mɔmɔ ako mɛ lii gɛta-gɛta.” ");
INSERT INTO acd_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Yesu akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Ifɛ nsana gɛrɛ, nnɛ ne a laa nyɛ agyudɔ sa gɛnyamesɛbi gɛdɛ de mɛꞌ gyi?” ");
INSERT INTO acd_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yesu gi taasɛ mɔ-akasɛbo mɔ yɛɛ, mɔmɔ-lɛɛ bodobodo mɔ mɛ bo mɔ i gyɛ ifonɛ? Mɛ lɛɛ gɛnɔ yɛɛ i gyɛ sono. ");
INSERT INTO acd_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Nfono mɔ, ɔ tɔgɛ asa abono pɛwu mɛ buu mɔmɔ mɔ yɛɛ mɛꞌ kyena. Mɛ kpelegɛ kyena gɛsinkpan mɔ, o puru ibodobodo sono mɔ, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa-gbaa imɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ mɛꞌ yɛ sa sakpii mɔ de mɛꞌ gyi. Ne mɛ sɔɔ yɛ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Mɔ, mɛ bo nkenbii kalɛsɛ nko. Nfono ne ɔ sɔɔ nkenbii mɔ ne o kii kyu afaala sa Wurubuaarɛ ne o kiiri sa mɔmɔ yɛɛ mɛꞌ kyu yɛ sa asa mɔ de mɛꞌ kyu gyi de mɔmɔ-bodobodo mɔ. ");
INSERT INTO acd_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Mɛ yɛ gɛnen mɔ, ɔkamaasɛ gi nyɛ gyi kaabo, ne i fo mɔmɔ kii san. Mɛ koola agyisan mɔ, i bɔla nkeebii sono. ");
INSERT INTO acd_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Asa abono mɛ gyi amɔ mɔ gɛgyɔnɔ gɛ laa wɔra fɛɛ nwɛ ikue-inyɔ. Asa mɔ mɛ gyi ta mɔ, Yesu gi lɛɛ mɔmɔ-ɔkpa, ne mɛ kyon gɛwi. ");
INSERT INTO acd_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Nfono mɔ Yesu mɔ‑rɛ mɔ-akasɛbo mɔ, mɔ, mɛ san dii loo mɔmɔ-gikolii dɔ ne mɛ kyon Dɔmanuta gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Mɛ bo nno mɔ, Farasii gikpen dɔ awura ako mɛ baa sɔɔ akyɔɔlɛ de Yesu. Mɛ laarɛ fɛɛ ɔꞌ wɔra ilaa lɛɛnyiilesɛ lii Wurubuaarɛ dɔ sa mɔmɔ de mɛꞌ nyɛ bii yɛɛ Wurubuaarɛ ne n sa mɔ ɔlon ɔbono ɔ dɛ mɔ. Mɛ kya laarɛ ɔꞌ wɔra gɛnen mɔ, mɛ kya daasɛ mɔ mɛ kya kerɛ. ");
INSERT INTO acd_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Yesu gi sɔnga faa fo‑o ne ɔ tɔgɛ yɛɛ, “Menɛ n wɔra ne ndɛ asa adɛ mɛ kya laarɛ ilaa lɛɛnyiilesɛ de mɛꞌ wu gɛnen? Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, mɛ maŋ nyɛ ba‑a ilaa kolon wu de ansi.” ");
INSERT INTO acd_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nfono ne ɔ naa taa mɔmɔ yɛgɛ, ne o kii dii loo gikolii mɔ dɔ fara kpe ɔbon belɛ mɔ gibenbɛ giko mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mɛ kya kpe mɔ, mɛ tan mɛ mɛŋ laarɛ agyudɔ keda. Bodobodo kolon ne n san mɔmɔ asɛ gikolii mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yesu gi ka mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan. Farasii gikpen dɔ awura de Wura Hɛrodɛ ilaa mɔ i dɛ fɛɛ gɛlin gɛbono gɛ kya yɛgɛ bodobodo kya ŋan mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Yesu gi ka mɔmɔ gɛnen mɔ, mɛ kyu mɛ kya taasɛ abara yɛɛ, “Ibono a mɛŋ dɛ bodobodo mɔ so ne ɔ tɔgɛ aye gɛnen faa abɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Mɛ kya taasɛ abara gɛnen mɔ, Yesu gi ti bii ilaa ibono mɛ darɛ mɔ. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya tɔngɛ kyu lii bodobodo ɔbono fɛ mɛŋ dɛ mɔ so? Fɛŋ ti bii isa ɔbono n gyɛ mɔ? Menɛtɔ so ne fɛye-aso dɔ i kɔrɔ ifuu gɛnen? ");
INSERT INTO acd_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Fɛ bo ansi, yɛgɛ fɛ mɛŋ kya wu. Fɛ bo aso, yɛgɛ fɛ mɛŋ kya nu. Imɔso fɛ tan ");
INSERT INTO acd_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","owi ɔbono nɛ gbaa-gbaa ibodobodo inun dɔ ne asa nwɛ ikue-inyɔ de saalaa mɛ gyi kpon mɔ? Agyisan nkeebii nfonɛ ne fɛ koola mɔ?” Mɔ-akasɛbo mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Nkeebii gudu nnyɔ.” ");
INSERT INTO acd_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ne Yesu gi kii taasɛ mɔmɔ yɛɛ, “Ne owi ɔbono nɛ gbaa-gbaa ibodobodo sono mɔ dɔ kyu sa asa nwɛ ikue-inyɔ mɔ de? Agyisan nkeebii nfonɛ ne fɛ koola mɔ?” Mɔ-akasɛbo mɔ mɛ kii lɛɛ gɛnɔ yɛɛ, “Nkeebii sono.” ");
INSERT INTO acd_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Nfono ne Yesu gi kii taasɛ mɔmɔ yɛɛ, “Imɔso fɛŋ ti nu gɛsɛ?” ");
INSERT INTO acd_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ baa fo Bɛsayida ɔsowolɛ so. Ɔsowolɛ mɔ so asa ako mɛ kyu ɔnyen ɔko baa tu Yesu. Ɔnyen mɔ gyɛ daa gyaatanbo. Mɛ ba mɔ, mɛ kolɛ Yesu yɛɛ ɔꞌ wɔra aniya de oꞌ kyu mɔ-abaa gyan mɔ so sa mɔmɔ de mɔ-ansi mɔ aꞌ bugi. ");
INSERT INTO acd_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Yesu gi keda gyaatanbo mɔ gibaa dɔ kyu mɔ lii nten nkan ne ɔ too akyɔlɛ wɔra mɔ-ansi dɔ ne o kyu mɔ-abaa bun mɔ-ansi mɔ so. Yesu gi lɛɛ mɔ-abaa ɔnyen mɔ-ansi mɔ so ne ɔ taasɛ mɔ yɛɛ, “Fo kya wu ilaa iko?” ");
INSERT INTO acd_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Gyaatanbo mɔ gi diirɛ mɔ-ansi ne ɔ kerɛ mɔ, ɔ tɔgɛ yɛɛ, “N kya wu asa. Mɔ, mɛ dɛ fɛɛ iyii mɛ naa mɛ naa.” ");
INSERT INTO acd_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ne Yesu gi kii kyu mɔ-abaa bun gyaatanbo mɔ ansi mɔ so ne ɔ lɛɛ. Nfono mɔ gyaatanbo mɔ gi kii lɔrɔ kerɛ mɔ, mɔ-ansi mɔ a bugi. Ɔ san ɔ kya wu ilaa kamaasɛ dɔɔdan. ");
INSERT INTO acd_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Yesu gi kyɛ gyaatanbo mɔ ta mɔ, ɔ tɔgɛ mɔ yɛɛ ɔꞌ naa kpe mɔ-gɛwi. Ɔ mɛŋꞌ sa oꞌ kyu de ɔsowolɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ yii ɔkpa mɛ kya kpe isowolɛ ibono i sindi Sɛsariya Filipayi ɔsowolɛ so mɔ. Mɛ naa mɛ kya kpe mɔ, Yesu gi taasɛ mɔ-akasɛbo mɔ yɛɛ, “Asa asɛ mɔ, menɛ nyamesɛ ɔnan ne nꞌ gyɛ?” ");
INSERT INTO acd_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ne mɔ-akasɛbo mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Ako mɛ kya tɔgɛ yɛɛ fo gyɛ Oloobu Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ. Ako mɔ yɛɛ Kuaa! Fo ne n gyɛ Oloobu Ilaagya. Ne ako, mɔ, yɛɛ Wurubuaarɛ ikalan atɔgɛbo iloobu mɔ dɔ ɔko kpɛi ne n kyingi lii ibuni dɔ ba gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Nfono ne Yesu gi kii taasɛ mɔ-akasɛbo mɔ yɛɛ, “Ne fɛye mɔ de? Menɛ nyamesɛ ɔnan ne fɛ nyi yɛɛ nꞌ gyɛ?” Piita gi lɛɛ gɛnɔ yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi sun de foꞌ baa mɔlɛgɛ asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Piita gi lɛɛ gɛnɔ gɛnen mɔ, Yesu gi ka sa mɔ-akasɛbo mɔ yɛɛ mɛ mɛŋꞌ sa mɛꞌ tɔgɛ sa ɔko‑rɛ ɔko nyamesɛ ɔbono ɔnan ɔ gyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nfono ne Yesu gi yii gɛsɛ ɔ kya nyiile mɔmɔ yɛɛ, “I gyɛ ibono i laa ba yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nꞌ wu ɔlaawusɛ kpɛi-kpɛi gikyɔ. Gyuda awura asunbi alɛɛbo abelɛnsɛ de nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ mɔ mɛ laa kine me, ne mɛ laa yɛgɛ asa mɛꞌ mɔɔ me. Mɛ mɔɔ me mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Ɔ tɔgɛ tigi mɔmɔ, ɔŋ ŋara mɔmɔ. Ne Piita gi kyu mɔ lii nkan ne ɔ gya mɔ yɛɛ ɔŋ baa tɔgɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ne Yesu gi kisee kerɛ mɔ-akasɛbo sɛnsɛ mɔ, ne ɔ gya Piita yɛɛ, “Naa me asɛ; ilaa nyɛnyɛn gɛmu! Fo-gɛwɔnsa gɛŋ gyan Wurubuaarɛ gɛlaarɛ so. Anyamesɛ-lɛɛ gɛlaarɛ so ne fo-gɛwɔnsa gɛ gyan.” ");
INSERT INTO acd_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Nfono ne Yesu gi terɛ sakpii mɔ ba mɔ asɛ dabɔlɛ de mɔ-akasɛbo mɔ ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Ɔbono ɔ kya laarɛ de ɔꞌ wɔra me-ɔkasɛbo mɔ, kaasɛ mɔ oꞌ kyu mɔ-nyoro fuɛ, oꞌ kyule wu awɔrɔfɔɔ me so, de ɔꞌ kasɛ me-gidebi. Ba‑a mɛ laa da mɔ aŋanbi oyii so mɔɔ mɔ, mɛꞌ da mɔ. ");
INSERT INTO acd_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","I kya nyiile yɛɛ fo ɔbono fo kya kɔrɔsɛ fo-nkpa fo kya yela fo-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena ɔnan mɔ gɛ laa lii fo-gibaa. Ne fo ɔbono, mɔ, kyu lii me‑rɛ me-ɔkalan konkonsɛ mɔ so ne fo-nkpa gi lii fo-gibaa mɔ, fo laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Fo nyamesɛ fo nyɛ gɛsinkpan gɛdɛ so ilaa kamaasɛ pɛwu gyan ne fo too fo-ɔkyenaten Wurubuaarɛ asɛ mɔ fuɛ mɔ, fo nyi yɛɛ fo nyɛ gɛkyena ne? ");
INSERT INTO acd_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Menɛ ne fo laa kyu sa Wurubuaarɛ de foꞌ kii nyɛ ɔkyenaten mɔ asɛ? ");
INSERT INTO acd_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gɛkyena gɛdɛ dɔ mɔ fɛ tɛ saarɛ asa abono mɛ kya wɔra ilaa nyɛnyɛn ne mɛŋ kya gyi gɛsintin sa Wurubuaarɛ mɔ. Imɔso fɛꞌ keda fɛye-nyoro. Nengyene asa adɛ ansi dɔ ne i bo fo ɔko ipeeli yɛɛ fo kya son me abɛɛ fo kya sɔɔ me-agyɛbi mɔ gyi mɔ, gɛnen kee ne i laa wɔra me, anyamesɛ pɛwu mɔmɔ-daa mɔ, ipeeli sa fo gɛnen kaasɛ ɔbono, gɛkaabono nan kii ba gɛsinkpan so mɔ. Gɛnen gɛkaabono mɔ me-sɛ Wurubuaarɛ laa keda mɔ-isɔɔ sun lii Wurubuaarɛ dɔ. Me‑rɛ ɔmɔ ne nan ba, ne me-sɛ Wurubuaarɛ laa lɛɛ me-nyisigyi nyiile asa.” ");
INSERT INTO acd_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fɛye abono fɛ yelɛ gɛrɛnaa faa, fɛ maŋ wuꞌ ta pɛi ne fɛ laa wu Wurubuaarɛ gɛwuragyi gɛkyena gɛ ba anyamesɛ dɔ ne Wurubuaarɛ gi lɛɛ mɔ-ɔlon nyiile.” ");
INSERT INTO acd_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Imɔ nkɛ nsee gɛmara mɔ, Yesu gi kyu mɔ-akasɛbo Piita, Gyeemesi, de Gyɔn ne mɛ dii kpe gibii belɛ giko so mɔmɔ wolɛ. Mɛ bo nno gɛnen mɔ, Yesu nyoro gi kyɛɛgɛ kii lɔrɔ wɔra ɔdan too, ");
INSERT INTO acd_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ne mɔ-ngbɛ nbono o suu mɔ gi fuuli faa parɛ-parɛ, gi kya ŋɛlegi. Gɛsinkpan gɛdɛ so mɔ, nyamesɛ maŋ taalɛ foro ilaa de iꞌ lii fuuli parɛ-parɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mɛ baa kii kerɛ mɔ, iloobu inyɔ iko ne: Ilaagya mɔ‑rɛ Mosisi. Mɛ ba Yesu asɛ, mɔmɔ‑rɛ mɔ mɛ yelɛ mɛ kya gyi nsingyi. ");
INSERT INTO acd_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Mɛ yelɛ gɛnen mɔ, Piita gi ten loo tɔgɛ atɔgɛkpandɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, i wɔra ɔdan yɛɛ a bo gɛrɛ. Yɛgɛ de aꞌ yii ipanpan isaꞌ sa fɛye: fo-lɛɛ ɔko, Ilaagya-lɛɛ ɔko, de Mosisi-lɛɛ ɔko.” ");
INSERT INTO acd_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Yesu akasɛbo mɔ mɛ wu iloobu mɔ gɛnen mɔ, i ŋmaa mɔmɔ-gisen ne i wɔra mɔmɔ gifuu. Piita mɛŋ bii ilaa ibono ɔ laa tɔgɛ mɔ. Imɔ ne n bara mɔ-atɔgɛkpandɛ mɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Mɔmɔ pɛwu mɛ san mɛ yelɛ mɔ, gibuntɔ giko gi ba baa bun mɔmɔ so faa kpem, ne Wurubuaarɛ gigyɛbi gi lii gibuntɔ mɔ dɔ tɔgɛ sa akasɛbo mɔ yɛɛ, “Me-gisen dɔ obi ne n gyɛ Yesu, fɛꞌ nu mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ayaa abono so mɔ, Yesu akasɛbo mɔ mɛ kerɛ kyaabɔɔ mɔ, mɛŋ baa wu ɔko baa too de Yesu. ");
INSERT INTO acd_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mɛ kya kpelegɛ ma‑a ba mɔ, Yesu gi da mɔmɔ tii yɛɛ, “Fɛŋ sa fɛꞌ tɔgɛ ilaa ibono fɛ wu faa sa ɔko nperɛ. Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nɛ wuꞌ kii kyingi lii ibuni dɔ mɔ, pɛi de fɛꞌ lɔɔ gyi imɔ so gɛsingyi sa asa.” ");
INSERT INTO acd_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Ɔ gya mɔmɔ mɔ, mɛ nu mɔ asɛ; mɛ mɛŋ buu sa ɔko. Mɔmɔ-wolɛ ne n taasɛ abara yɛɛ, “Ibono ɔ darɛ yɛɛ ɔ laa wuꞌ de oꞌ kii kyingi faa mɔ, imɔ gɛsɛ ne n gyɛ nnɛ?” ");
INSERT INTO acd_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ne Yesu akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Aye Gyuda awura nbara aŋmarasɛbo mɔ mɛ kya kyena tɔgɛ sa aye yɛɛ Oloobu Ilaagya laa kii lii Wurubuaarɛ dɔ ba pɛi de ɔbono Wurubuaarɛ laa sun yɛɛ ɔꞌ baa gyi gɛwura Wurubuaarɛ adɛ so mɔ ɔꞌ lɔɔ ba. Ne fo ne n gyɛ gɛnen isa ɔbono mɔ, menɛ n wɔra so ne Ilaagya mɛŋ baa gyangbara fo ba?” ");
INSERT INTO acd_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yesu gi lɛɛ gɛnɔ yɛɛ, “I gyɛ gɛsintin yɛɛ i kaaborɛ Ilaagya ɔꞌ gyangbara ba de ɔꞌ baa lɔrɔ ilaa kamaasɛ pɛi de nꞌ lɔɔ ba. Mɛ ŋmarasɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ ilaa Wurubuaarɛ agyɛbi mɔ dɔ yela yɛɛ i gyɛ ibono i laa ba yɛɛ nꞌ wu awɔrɔfɔɔ gikyɔ asa abaa dɔ de mɛŋꞌ kyu me terɛ sɛi. Ilaa ibono mɛ ŋmarasɛ gɛnen mɔ gɛsɛ ne n gyɛ menɛ? ");
INSERT INTO acd_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Nꞌ tɔgɛ fɛye yɛɛ Ilaagya gi ti wolaa kii ba, ne ibono Gyuda awura mɛ kya laarɛ mɔ mɛ ti kyu wɔra mɔ fɛɛ gɛnɔɔbono mɛ wolaa ŋmarasɛ wɔra Wurubuaarɛ agyɛbi mɔ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mɛ kpelegɛ mɛ kya ba Yesu akasɛbo sɛnsɛ mɔ asɛ mɔ, mɛ wu sakpii yelɛ kyaabɔɔ mɔmɔ; mɔmɔ‑rɛ nbara aŋmarasɛbo mɛ kya sɔɔ akyɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Sakpii mɔ gi da de ginsi wu Yesu kya ba mɔ, i dɛ sakpii mɔ gɛnɔ gikyɔ, ne mɛ selɛ kpaa gyangara mɔ, ne mɛ faala mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ne Yesu gi taasɛ mɔmɔ yɛɛ, “Menɛ gɛsingyi ne fɛye‑rɛ me-akasɛbo fɛ kya gyi mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nfono mɔ ɔko gi lɛɛ gɛnɔ lii sakpii mɔ dɔ yɛɛ, “Ɔbelɛnsɛ, ilaa nyɛnyɛn oduduu ɔko tɛ me-bi nyensɛ so, i kya yɛgɛ gɛŋ kya taalɛ tɔngɛ. Imɔso nɛ kyu mɔ ba fo asɛ. ");
INSERT INTO acd_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Nengyene i kyena gɛmɔ so mɔ, i kya kuu gɛmɔ too gɛsinkpan. I san mɔ, gɛmɔ-gɛnɔ dɔ i kya furu afuru, ne gɛ kya wɛ gɛmɔ-anyi. Gɛmɔ-nyoro gi kya san faa kenkesen. Nɛ ba ne meŋ tu fo mɔ, nɛ kolɛ fo-akasɛbo mɔ yɛɛ mɛꞌ gya gɛnen ilaa nyɛnyɛn oduduu mɔ koso gɛmɔ so sa me mɔ, mɛ mɛŋ taalɛ.” ");
INSERT INTO acd_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ne Yesu gi tɔgɛ sakpii mɔ yɛɛ, “O! Fɛye nkɛ ndɛ dɔ asa! Fɛŋ kya sɔɔ Wurubuaarɛ gyi. Nkɛ nfonɛ ne nan kyena fɛye asɛ, n kpɛ mi‑i nyɛ gisen mi‑i sa fɛye daa? Fɛꞌ kyu gɛbii mɔ bara me.” ");
INSERT INTO acd_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ne mɛ kyu gɛmɔ bara mɔ. Ilaa nyɛnyɛn oduduu mɔ gi wu Yesu mɔ, ayaa abono so mɔ, i kyu gɛbii mɔ too gɛsinkpan. Gɛ san gɛ kya belen, gɛ kya kpiri, ne gɛmɔ-gɛnɔ dɔ i kya furu. ");
INSERT INTO acd_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ne Yesu gi taasɛ gɛbii mɔ mɔ-sɛ yɛɛ, “I kya wɔra gɛmɔ ɔfaanan faa, i ti kɛɛla?” Gɛbii mɔ mɔ-sɛ gi lɛɛ gɛnɔ yɛɛ, “Lii ko‑o gɛmɔ-nbii dɔ ne i yii gɛmɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","I kya laarɛ iꞌ mɔɔ gɛmɔ so mɔ, i kya kyu gɛmɔ kyu too ɔgya dɔ de nkyu dɔ. Nengyene fo laa taalɛ wɔra ilaa iko kyu lii imɔ so mɔ, su aye so de foꞌ mɔlɛgɛ aye.” ");
INSERT INTO acd_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Yesu gi taasɛ mɔ yɛɛ, “Fo yɛɛ, ‘nengyene nan taalɛ mɔ’? Imɔso fo kya sɔɔ akyɔɔlɛ yɛɛ maŋ taalɛ? Nu yɛɛ ɔbono ɔ kya sɔɔ Wurubuaarɛ gyi mɔ, ilaa kamaasɛ i kya wɔra sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Gɛbii mɔ mɔ-sɛ gi kpɛ nu yɛɛ gisɔɔgyi ne n tiri mɔ, o kyu osulon kolɛ mɔ yɛɛ, “N kya sɔɔ Wurubuaarɛ gyi berɛ. Ibono meŋ sɔɔ gyi mɔ, yɛgɛ nꞌ sɔɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Yesu gi wu yɛɛ sakpii mɔ kya nyaakyɔ ɔ kya too mɔ, ɔ tɔgɛ sa ilaa nyɛnyɛn oduduu mɔ yɛɛ, “Fo ilaa nyɛnyɛn oduduu ɔbono fo tɛ gɛbii gɛdɛ so, ne fo yɛgɛ gɛ bingiri gɛmugamuga de osintiribu mɔ, n kya tɔgɛ mi‑i sa fo yɛɛ, koso gɛmɔ so, n kerɛ fo faa, de foŋꞌ baa kii ba gɛmɔ so gɛkaako.” ");
INSERT INTO acd_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ilaa nyɛnyɛn oduduu mɔ gi lɔgedɛ saawo, ne i kyu ɔlon nyala gɛbii mɔ kerii-kerii pɛi ne i koso gɛmɔ so. I koso taa gɛbii mɔ yɛgɛ mɔ, gɛ san gɛ dɛ fɛɛ obuni. Asa sakyɔ mɛ kya tɔgɛ yɛɛ gɛ wuꞌ daa. ");
INSERT INTO acd_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Nfono ne Yesu gi keda gɛmɔ-gibaa dɔ puru ne gɛ koso yelɛ. ");
INSERT INTO acd_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Yesu gi kpaa loo obu dɔ mɔ, mɔ-akasɛbo mɔ mɛ baa taasɛ mɔ mɔmɔ-wolɛ yɛɛ, “I wonɛ so ne aye berɛ, a mɛŋ taalɛ gya ilaa nyɛnyɛn oduduu mɔ koso gɛbii mɔ so daa?” ");
INSERT INTO acd_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Mɛ taasɛ Yesu gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Sɛi mɛŋ bo no i laa taalɛ gya ilaa idɛana ɔnan koso, gɛnen mɔ, gɛnɔ ŋminde de gɛdalaa.” ");
INSERT INTO acd_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Mɛ lii nfono mɔ, mɛ naa loo Galeli gɛsinkpan so mɛ kya kyon. Yesu mɛŋ kya laarɛ de ɔko ɔꞌ bii nfono so mɛ bo de mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","I kya nyiile yɛɛ ɔ kya laarɛ de oꞌ nyiile mɔ-akasɛbo mɔ ilaa mɔmɔ-wolɛ. Ɔ kya nyiile mɔmɔ ilaa mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Owi mɔ gi fo ibono me-akyobo mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra asa ako abaa dɔ de mɛꞌ mɔɔ me. Mɛ mɔɔ me mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","O buu sa ɔmɔ gɛnen mɔ, mɛ mɛŋ nu imɔ gɛsɛ. I kii i bo mɔmɔ gifuu de mɛꞌ taasɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","34","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya kpe Kapɛɛniyon ɔsowolɛ so. Mɛ naa ɔkpa dɔ mɛ kya kpe mɔ, mɔ-akasɛbo mɔ mɛ kya sɔɔ akyɔɔlɛ yɛɛ mɔmɔ dɔ mɔ, anɛ ne n don mɔ-nanbo. Mɛ loo gɛten dɔ mɔ, Yesu gi taasɛ mɔ-akasɛbo mɔ yɛɛ, “A kya ba mɔ, menɛ akyɔɔlɛ ne fɛ kya sɔɔ mɔ?” Mɛ sii kurun. I kya nyiile yɛɛ ipeeli i gyi mɔmɔ kyu lii akyɔɔlɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ne Yesu gi kpelegɛ kyena ne ɔ terɛ mɔ-akasɛbo gudu anyɔ mɔ ba mɔ asɛ ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Nengyene ɔko kya laarɛ gɛbelɛnsɛ oꞌ gyi mɔ, i kaaborɛ ɔꞌ wɔra mɔ-nyoro fɛɛ gɛbii de ɔꞌ wɔra dega sa ɔkamaasɛ.” ");
INSERT INTO acd_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nfono ne Yesu gi keda gɛbii pii gɛko, ne o kyu gɛmɔ yelɛ mɔmɔ-ansi dɔ, ne o kyu mɔ-abaa mili gɛmɔ kyaabɔɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Nengyene me so ne fo ɔko fo bugi ansi de gɛbii gɛko fɛɛ gɛdɛ ɔnan mɔ, me ne fo bugi ansi de gɛnen. Ne fo bugi ansi de me mɔ, fo bugi ansi de me-sɛ ɔbono o sun me mɔ kee ne.” ");
INSERT INTO acd_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ne Gyɔn gi tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, a wu ɔnyen ɔko ɔ dɛ fo-ginyen ɔ kya gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi ɔ kya koso asa so. Kaasɛ mɔ mɛŋ kii ɔ bo aye dɔ, imɔso a gya mɔ yɛɛ ɔŋꞌ baa wɔra gɛnen.” ");
INSERT INTO acd_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ne Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fɛ san wu gɛnen mɔ, fɛŋꞌ baa gya mɔ. Ɔbono ɔ dɛ me-ginyen ɔ kya wɔra amunale ilaa mɔ, gɛnen kaasɛ ɔbono maŋ baa kii tɔgɛ ilaa nyɛnyɛn iko kyu lii me so ayaa abono so. ");
INSERT INTO acd_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","I kya nyiile yɛɛ ɔbono ɔŋ kya sɔɔ akyɔɔlɛ de aye mɔ, ɔ yelɛ aye-gɛmara ne. ");
INSERT INTO acd_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ibono fɛ kya son me, Kirisito, mɔ so ne ɔko gi sa fɛye ba‑a nkyu nunsɛ mɔ, n kya tɔgɛ fɛye gɛsintin, kaasɛ mɔ maŋ wɔra imɔ too nkyu dɔ giyan. Wurubuaarɛ ntɛɛla gi dɛ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Ɔbono, mɔ, ɔ laa yɛgɛ apiipii abono mɛ sɔɔ me gyi mɔ dɔ ɔko gisɔɔgyi giꞌ koso me so mɔ, nengyene fɛɛ mɛ kyu gibui belɛ ŋminde kyaga de kaasɛ ɔbono gibɔ ne mɛ too mɔ wɔra apoo dɔ mɔ, i tɛsɛ i bɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Imɔso nengyene fo-gibaa gi kya yɛgɛ fo-gisɔɔgyi giꞌ koso me so mɔ, kɛbi gimɔ fuɛ! I boran yɛɛ fo kyu gibaa kolon de foꞌ kpaa kyena Wurubuaarɛ asɛ mɔ don ibono Wurubuaarɛ laa kyu fo‑rɛ fo-abaa anyɔ too wɔra ɔgya ɔbono ɔŋ kya wuꞌ gɛkaako mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","“Nengyene fo-giyaa gi kya yɛgɛ fo-gisɔɔgyi giꞌ koso me so mɔ, kɛbi gimɔ fuɛ! I boran yɛɛ fo kyu giyaa kolon kpaa kyena Wurubuaarɛ asɛ don ibono Wurubuaarɛ laa kyu fo‑rɛ fo-ayaa anyɔ too wɔra ɔgya ɔbono ɔŋ kya wuꞌ gɛkaako mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","“Nengyene fo-ginsi gi kya yɛgɛ fo-gisɔɔgyi giꞌ koso me so mɔ, lɔgedɛ gimɔ lɛɛ fuɛ. I boran yɛɛ foꞌ kyu ginsi kolon kpaa kyena Wurubuaarɛ gɛwuragyi mɔ dɔ don ibono Wurubuaarɛ laa kyu fo‑rɛ fo-ansi anyɔ too wɔra ɔgya dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Nno berɛ i don gɛsinkpan so gibiinaa de gɛkyan gbaa bun. Imɔ-lɛɛ ɔgya ɔnan mɛŋ kya nu giwuꞌ, ne nno ilaa gyɔsɛ-lɛɛ asonsɔɔ aŋ kya wuꞌ gɛkaako. ");
INSERT INTO acd_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ɔgya laa fuo ɔkamaasɛ. Ɔbono ɔ loo lii mɔ, i laa lɔrɔ mɔ fɛɛ gɛnɔɔbono nfɔlɛ gi kya lɔrɔ ipɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Nfɔlɛ gi bo kon. Nengyene fɛɛ nfɔlɛ gi ta nmɔ-ɔkon mɔ, nnɛ ne fɛ laa wɔra nmɔ de giꞌ kii wɔra ɔkon? Iŋ bo sɛi fɛ laa taalɛ wɔra. Imɔso fɛꞌ wɔra fɛɛ nfɔlɛ sa abara de fɛꞌ nyɛ gisen yuuli kyu kyena.” ");
INSERT INTO acd_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Yesu gi koso lii nno, ne o kpe Gyudiya gɛsinkpan so de Gyɔɔdan ɔbon mɔ gibenbɛ giko so. Sakpii gi ti kpaa kyaabɔɔ mɔ, ne o nyiile mɔmɔ ilaa fɛɛ gɛnɔɔbono ɔ wolaa ɔ kya wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Nfono mɔ Farasii gikpen mɔ dɔ awura ako mɛ baa soo Yesu idoo kerɛ. Gɛnen so mɔ, mɛ taasɛ mɔ yɛɛ, “Aye-nbara dɔ mɔ, i dɛ ɔkpa fɛɛ ɔnyen oꞌ kine mɔ-ka?” ");
INSERT INTO acd_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ne Yesu gi kisee taasɛ mɔmɔ yɛɛ, “Menɛ nbara ne Mosisi gi yela sa fɛye kyu lii ɔkyii gikine so?” ");
INSERT INTO acd_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Mɛ lɛɛ gɛnɔ yɛɛ, “Mosisi yɛɛ, nengyene ɔnyen laa kine mɔ-ka mɔ, ɔꞌ sa mɔ gikine ɔwolɛ de ɔꞌ lɛɛ mɔ ɔkpa.” ");
INSERT INTO acd_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mɛ lɛɛ gɛnɔ gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Ibono fɛye-aso dɔ i kɔrɔ ifuu mɔ so ne Mosisi gi yela nbara ndɛ sa fɛye gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Nkana mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ yɛɛ lii ko‑o aberɛ abono Wurubuaarɛ gi lɛɛ soso de gɛsɛ mɔ, ‘ɔ lɛɛ ɔnyen oyuduu de ɔkyii oyuduu’. Mɛ kii ŋmarasɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","‘Imɔ idɛ so ne ɔnyen kya taa mɔ-sɛ de mɔ-nyi yɛgɛ de oꞌ kyu mɔ-nyoro mada de mɔ-ka ");
INSERT INTO acd_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","de mɛꞌ bingiri nyamesɛ kolon mɔ.’ Imɔso ɔnyen mɔ‑rɛ mɔ-ka mɛŋ baa mɛ gyɛ asa anyɔ, mɛ bingiri nyamesɛ kolon. ");
INSERT INTO acd_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ibono Wurubuaarɛ ne n kyu mɔmɔ dabɔlɛ wɔra nyamesɛ kolon faa mɔ, ɔko ɔŋ sa ɔꞌ baragɛ mɔmɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kii ba gɛten dɔ mɔ, mɔ-akasɛbo mɔ mɛ kii lɔrɔ taasɛ mɔ kyu lii gɛdena gɛsingyi mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ne Yesu gi tɔgɛ mɔ-akasɛbo mɔ yɛɛ, “N kya tɔgɛ mi‑i sa fɛye yɛɛ nengyene fo kine fo-ka kpaa kyu ɔkyii pobɔrɔ mɔ, fo tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara. Ɔ kya kyu imɔ yɛɛ ɔko mɔ-ka ne fo laarɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ne fo ɔkyii ɔbono fo kine fo-kuli kpaa dena ɔnyen pobɔrɔ mɔ, fo kee fo tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara mɔ. Ɔ kya kyu imɔ fɛɛ fo lii fo-kuli gɛmara ne.” ");
INSERT INTO acd_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Owi ɔko dɔ mɔ, asa ako mɛ kpɛ mɛ dɛ nbii ma‑a bara Yesu yɛɛ oꞌ kyu mɔ-abaa gyan nmɔ so de ɔꞌ dalaa sa mɔmɔ. Yesu akasɛbo mɔ, mɔ, mɛ kya gya mɔmɔ yɛɛ mɛꞌ kiiri nbii mɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Yesu gi wu gɛnen mɔ, i loo mɔ. Ne ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ yɛgɛ nbii mɔ giꞌ ba me asɛ; fɛŋꞌ baa tii mɔmɔ-ɔkpa. Abono mɛ dɛ fɛɛ gɛnen nbii ndɛana ɔnan mɔ ne n kya nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fo nyamesɛ kamaasɛ ɔbono fo mɛŋ kyu fo-nyoro wɔra fɛɛ gɛbii de foꞌ kyule kyena Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ, fo maŋ nyɛ gɛnen gɛkyena gɛbono kpa‑a.” ");
INSERT INTO acd_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Imɔso Yesu gi puge nbii mɔ ne ɔ kyu mɔ-abaa gyan mɔmɔ so kolɛ Wurubuaarɛ ayuule sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Yesu kya laarɛ oꞌ kpe ɔkpa mɔ, ɔnyen ɔko gi selɛ baa ŋmii mɔ-ayaa dɔ ne ɔ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ dɛnsɛ, nnɛ ne nan wɔra de nꞌ nyɛ Wurubuaarɛ asɛ gɛkyena gɛkpaa?” ");
INSERT INTO acd_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Yesu gi kisee taasɛ mɔ yɛɛ, “Fo kya terɛ me yɛɛ nyamesɛ dɛnsɛ faa mɔ, fo mɛŋ nyi yɛɛ Wurubuaarɛ wolɛ ne n gyɛ nyamesɛ dɛnsɛ? ");
INSERT INTO acd_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Iŋ gyɛ fo nyi Wurubuaarɛ nbara mɔ? Nbara mɔ gi kya nyiile yɛɛ gɛŋꞌ sa foꞌ mɔɔ isa, gɛŋꞌ lii fo-ka abɛɛ fo-kuli gɛmara, gɛŋꞌ yuuri, gɛŋꞌ ten ɔko gɛnɔ nbɛlɛ dɔ, gɛŋꞌ kudi ɔko gyi, buu fo-sɛ de fo-nyi.” ");
INSERT INTO acd_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ɔnyen mɔ gi lɛɛ gɛnɔ sa Yesu yɛɛ, “Ɔbelɛnsɛ, kpɛ kyu lii me-nbii dɔ mɔ, n kya gyi nbara ndɛ pɛwu so.” ");
INSERT INTO acd_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Yesu gi kisee kerɛ ɔnyen mɔ mɔ, mɔ-ilaa i loo mɔ-gisen dɔ, ne ɔ tɔgɛ sa mɔ yɛɛ, “I kya san fo ilaa kolon. Naa kpaa fɛ fo-ilaa ibono fo bo mɔ pɛwu de foꞌ kyu aterenbi mɔ kyu yɛ sa ayenbo. Fo wɔra gɛnen mɔ, fo laa nyɛ ntɛɛla Wurubuaarɛ dɔ, de foꞌ san naa baa buu me wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Ɔnyen mɔ gi nu ibono Yesu gi tɔgɛ mɔ gɛnen mɔ, mɔ-gisen dɔ i nyida mɔ, i yɔɔ mɔ-nyoro, ne ɔ naa kyon. I kya nyiile yɛɛ ɔ tansi ɔ bo atɔ gikyɔ. Ɔ kerɛ mɔ, ɔ maŋ taalɛ wɔra gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nfono mɔ, Yesu gi kerɛ mɔ-akasɛbo mɔ dɔ gyan, ne ɔ tɔgɛ mɔmɔ yɛɛ, “I tansi i bo lon sa aterenbi awura de mɛꞌ kyena Wurubuaarɛ gɛwuragyi dɔ akyenabi.” ");
INSERT INTO acd_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Yesu gi tɔgɛ gɛnen mɔ, i dɛ mɔ-akasɛbo mɔ gɛnɔ gikyɔ. Ne o kii tɔgɛ sa mɔmɔ yɛɛ, “Me-biana, i tansi i bo lon de nyamesɛ ɔꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi. ");
INSERT INTO acd_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Pɛi de aterenbi wura ɔꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ, i bo lon sa mɔ don gɛnɔɔbono gɛkpatitii gɛ laa loo ɔbaatɔ ɔbɔ dɔ lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Yesu gi tɔgɛ gɛnen mɔ, i lɔrɔ dɛ mɔ-akasɛbo mɔ gɛnɔ too, ne mɛ san taasɛ mɔ yɛɛ, “Gɛnen berɛ mɔ, anɛ kaasɛ ne nan nyɛ Wurubuaarɛ asɛ gɛkyena ne?” ");
INSERT INTO acd_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yesu gi kerɛ mɔmɔ faa yiridididi, ne ɔ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Imɔ idɛ i don nyamesɛ giwɔra. Wurubuaarɛ-lɛɛ kpɛi. I lii fɛɛ sɛi mɛŋ fo Wurubuaarɛ berɛ giwɔra.” ");
INSERT INTO acd_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Nfono mɔ Piita gi taasɛ mɔ yɛɛ, “Aye, mɔ, ibono a taa gɛsinkpan ilaa kamaasɛ yɛgɛ, ne a naa a buu fo faa mɔ, nnɛ ne?” ");
INSERT INTO acd_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","30","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, nyamesɛ kamaasɛ ɔbono ɔ taa ilaa iko yɛgɛ me so abɛɛ me-ɔkalan konkonsɛ mɔ so mɔ, kaasɛ laa nyɛ gɛnen ilaa ibono ɔnan gikpadɔ ikue-inun. Fɛɛ ɔko gi taa mɔ-gɛten yɛgɛ, abɛɛ mɔ-sɛ, abɛɛ mɔ-nyi, abɛɛ mɔ-daana, abɛɛ mɔ-tedɛana, abɛɛ mɔ-pikyiiana, abɛɛ mɔ-biana, abɛɛ mɔ-nsinkpan yɛgɛ me so mɔ, kaasɛ laa nyɛ nten, adaa, atedɛ, anyi, apikyii, nbii de nsinkpan aberɛ abono ɔ tɛ de ansi faa. Iko kee ne n gyɛ yɛɛ asa mɛ laa ka mɔ-ansi. Ne gɛkyena gɛbono gɛ laa kii ba mɔ dɔ mɔ, ɔ laa nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ne Yesu gi kii tɔgɛ yɛɛ, “Gɛnen gɛkyena pobɔrɔ gɛbono dɔ mɔ, abono mɛ gyɛ abelɛnsɛ gɛsinkpan so ilaa dɔ mɔ ako mɛ laa kpaa bingiri nbii. Ne abono mɛ gyɛ nbii gɛsɛ gɛrɛ ilaa dɔ mɔ ako mɔ, mɔ, mɛ laa kpaa wɔra abelɛnsɛ.” ");
INSERT INTO acd_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya kpe Gyɛrusalem. Asa ako kee mɛ buu mɔmɔ. Mɛ naa mɛ kya kpe mɔ, Yesu ne n gyangbara. Ako mɛ kya laarɛ mɛꞌ mɔɔ Yesu Gyɛrusalem, imɔso ibono mɛ kii mɛ kya kpe nno mɔ, i dɛ mɔ-akasɛbo mɔ gɛnɔ ne i bo abono mɛ buu mɔmɔ mɔ gifuu. Yesu gi kii kyu mɔ-akasɛbo gudu anyɔ mɔ lii nkan ne o kii tɔgɛ ɔmɔ ilaa ibono i laa ba mɔ so Gyɛrusalem mɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ nu. A kya kpe Gyɛrusalem faa, ako mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra aye Gyuda awura asunbi alɛɛbo abelɛnsɛ de aye-nbara aŋmarasɛbo abaa dɔ. Mɔmɔ, mɔ, mɛ laa tɔgɛ yɛɛ n gyɛ ilaa nyɛnyɛn ɔwɔrabo, imɔso nꞌ wɔra ɔmɔɔsɛ, de mɔmɔ kee mɛꞌ kyu me wɔra asa abono mɛ mɛŋ gyɛ Gyuda awura mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Gɛnen asa abono mɛ laa gyaabii me ikpa kpɛi-kpɛi so, de mɛꞌ too akyɔlɛ bun me. Mɛ laa taa me awulibi de mɛꞌ mɔɔ me. Nɛ wuꞌ mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Imɔ gɛmara mɔ Gyeemesi mɔ‑rɛ Gyɔn, Sɛbedi mɔ-biana mɔ, mɛ ba Yesu asɛ, ne mɛ baa kolɛ mɔ yɛɛ, “Ɔbelɛnsɛ, a dɛ fo giserɛ, ilaa ibono a kya laarɛ aꞌ baa kolɛ fo faa, wɔra aniya de foꞌ wɔra imɔ sa aye.” ");
INSERT INTO acd_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne Yesu gi taasɛ mɔmɔ yɛɛ, “Menɛ ne fɛ kya laarɛ nꞌ wɔra sa fɛye?” ");
INSERT INTO acd_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ne mɛ lɛɛ gɛnɔ yɛɛ, “Aberɛ abono fo laa baa gyi gɛwura de nyisigyi mɔ, yɛgɛ aye ne aꞌ wɔra fo-nwurabi nbono a laa sindi fo titiritii mɔ, ɔko ɔꞌ kyena fo-gibaa gyisɛ so de ɔko, mɔ, ɔꞌ kyena fo-benɛ so.” ");
INSERT INTO acd_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛ mɛŋ nyi ilaa ibono fɛ kya kolɛ faa. Imɔso fɛ laa taalɛ wu ɔlaawusɛ ɔbono ɔnan ɔ dɛ ɔ gyoo me mɔ? Me-awɔrɔfɔɔ sagyere ɔbono mɛ laa kyu gyere me mɔ, fɛ laa taalɛ de mɛꞌ gyere fɛye gɛnen sagyere ɔbono ɔnan kee?” ");
INSERT INTO acd_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Mɛ kyule mɔ yɛɛ, “Ɛn, a laa taalɛ.” Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “I gyɛ gɛsintin berɛ. Fɛ laa wu ɔlaawusɛ ɔbono ɔnan ɔ dɛ ɔ gyoo me mɔ, ne awɔrɔfɔɔ sagyere ɔbono nan gyere mɔ, fɛye kee fɛ laa gyere gɛnen sagyere ɔbono. ");
INSERT INTO acd_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Me asɛ ikyenaten mɔ berɛ, meŋ bo ɔkpa de nꞌ lɛɛ yɛɛ ɔdɛ ne ɔꞌ kyena me-gibaa gyisɛ so abɛɛ ɔdɛ ne ɔꞌ kyena me-benɛ so. Gɛnen ikyenaten ibono i gyɛ sa daa abono Wurubuaarɛ gi lɔrɔ imɔ yela sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Yesu akasɛbo sɛnsɛ gudu mɔ mɛ nu ilaa ibono Gyeemesi de Gyɔn mɛ kpaa kolɛ Yesu mɔ, i loo ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Imɔso Yesu gi terɛ mɔmɔ pɛwu ba mɔ asɛ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛɛ gɛnɔɔbono fɛ nyi mɔ, asa abono mɛ mɛŋ nyi Wurubuaarɛ agyɛbi mɔ mɔmɔ-awura awura mɛ kya kyu abono mɛ bo mɔmɔ gɛsɛ mɔ wɔra fɛɛ mɔmɔ-nbide. Mɔmɔ-anyamesɛ gbaaꞌgbaa mɔ kee, mɛ kya kyu ɔlon gyi gɛbelɛnsɛ asa sɛnsɛ so. ");
INSERT INTO acd_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Fɛye-lɛɛ berɛ, iŋ kaaborɛ iꞌ wɔra fɛɛ asa adɛ. Nengyene ɔko kya laarɛ ɔꞌ wɔra nyamesɛ gbaaꞌ fɛye dɔ mɔ, i kaaborɛ ɔꞌ wɔra mɔ-nyoro fɛɛ fɛye-dega, ");
INSERT INTO acd_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ne ɔbono ɔ kya laarɛ ɔꞌ wɔra fɛye-wura mɔ, i kaaborɛ ɔꞌ wɔra mɔ-nyoro fɛɛ gɛbide sa ɔkamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","I lii fɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ gbaa, meŋ ba gɛsinkpan so yɛɛ asa mɛꞌ son me. Nɛ ba daa de nꞌ baa son asa de nꞌ kyu me-nkpa kyɛɛ de iꞌ lɛɛ asa sakyɔ lii ilaa nyɛnyɛn giwɔra dɔ kiiri mɔmɔ sa Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Yesu mɔ‑rɛ mɔ-akasɛbo de sakpii belɛ mɛ loo Gyɛriko ɔsowolɛ so. Mɛ loo mɛ kya lii mɔ, gyaatanbo ɔko tɛ ɔkpa nkan. Mɛ kya terɛ gɛnen gyaatanbo ɔbono yɛɛ Batimeyasɛ. Mɔ-sɛ ne n gyɛ Timeyasɛ. ");
INSERT INTO acd_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Gyaatanbo mɔ gi nu yɛɛ Yesu, Nasarɛtɛnyen mɔ ne n ba ɔ kya kyon mɔ, o yii gɛsɛ ɔ kya kpen ɔ kya tɔgɛ yɛɛ, “Yesu, Wura Deefidi ɔnaanabi, su me so!” ");
INSERT INTO acd_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ɔ kya kpen gɛnen mɔ, asa sakyɔ mɛ kya gya mɔ yɛɛ, “Bun fo-gɛnɔ so!” Mɛ kya gya mɔ gɛnen mɔ, idɛ kon gbaa ne ɔ lɔrɔ ɔ kya kpen ken-ken yɛɛ, “Wura Deefidi ɔnaanabi, su me so!” ");
INSERT INTO acd_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yesu gi nu gɛnen mɔ, o sii yelɛ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ terɛ mɔ sa me.” Gɛsintin mɔ, mɛ terɛ gyaatanbo mɔ yɛɛ, “Fo-gisen giꞌ yuule fo, koso, Yesu kya terɛ fo.” ");
INSERT INTO acd_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Gyaatanbo mɔ gi nu gɛnen mɔ, ɔ ŋmanyan mɔ-gikuru too nkan, ne ɔ firigi yelɛ mɔ-ayaa so, ne ɔ naa kpe Yesu asɛ. ");
INSERT INTO acd_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ne Yesu gi taasɛ mɔ yɛɛ, “Menɛ ne fo kya laarɛ nꞌ wɔra sa fo?” Gyaatanbo mɔ gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, n kya laarɛ me-ansi aꞌ bugi.” ");
INSERT INTO acd_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Naa fo kya kpe. Gisɔɔgyi gibono fo bo sa me mɔ ne nan bugi fo-ansi faa.” Ayaa abono so mɔ, mɔ-ansi mɔ a bugi, ne ɔ san naa buu Yesu. ");
INSERT INTO acd_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya fuude Gyɛrusalem mɔ, mɛ kpaa fo Bɛtɛfagye de Bɛtani isowolɛ ibono i gyanꞌ Nfɔ Iyii Gibii mɔ so. Mɛ fo nno mɔ, Yesu gi sun mɔ-akasɛbo mɔ dɔ anyɔ ");
INSERT INTO acd_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","yɛɛ, “Fɛꞌ kpe ɔsowolɛ ɔbono ɔ bo aye-ansi dɔ faa. Fɛ kpɛ fɛ kya loo ɔsowolɛ mɔ so mɔ, fɛ laa wu bee fɔlɛ ɔbono ɔko mɛŋ ti gyanꞌ mɔ kerɛ mɔ kyaa de ɔfɛ. Fɛꞌ sangɛ mɔ de fɛꞌ kyu mɔ bara me gɛrɛ. ");
INSERT INTO acd_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne fɛɛ ɔko gi taasɛ fɛye yɛɛ, ‘Menɛ ne fɛ kya wɔra gɛnen?’ mɔ, fɛꞌ tɔgɛ mɔ yɛɛ, ‘Wura mɔ tiri bee mɔ.’ Fɛ tɔgɛ mɔ gɛnen mɔ, ɔ laa yɛgɛ de fɛꞌ kyu mɔ ba ayaa adɛ so.” ");
INSERT INTO acd_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Imɔso mɛ kpe, ne gɛsintin mɔ, mɛ kpaa wu bee fɔlɛ kyaa de ɔfɛ gɛbunono gɛko asɛ ɔkpa nkan, ne mɛ sangɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Mɛ kya sangɛ mɔ mɔ, abono mɛ yelɛ nfono mɔ mɛ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya sangɛ bee mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne akasɛbo mɔ mɛ tɔgɛ mɔmɔ fɛɛ gɛnɔɔbono Yesu gi tɔgɛ sa mɔmɔ mɔ, imɔso mɛ taa mɔmɔ yɛgɛ, ne mɛ sangɛ bee mɔ kyon. ");
INSERT INTO acd_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mɛ kyu bee mɔ bara Yesu mɔ, mɛ kyu akuru too gyan mɔ so, ne Yesu gi dii gyanꞌ. ");
INSERT INTO acd_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Asa sakyɔ mɛ kyu mɔmɔ-akuru too mɔ-ɔkpa dɔ, ne ako mɛ kyadɛ afɛdaa mɛ kya too de ɔkpa yɛɛ ɔꞌ baa naa. ");
INSERT INTO acd_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Abono mɛ gyangbara de abono mɛ buu mɔ-gɛmara mɔ pɛwu, mɛ kya kpen mɛ kya tɔgɛ yɛɛ, “Ayenbi a gyɛ fo-lɛɛ! Wurubuaarɛ ɔꞌ kosorɛ fo-gimu! Wurubuaarɛ ginyen dɔ ne fo naa fo kya ba faa! ");
INSERT INTO acd_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Aye-naana Wura Deefidi gɛwuragyi gɛbono fo dɛ fo kya ba mɔ gɛꞌ bara nkyoola! Ayenbi aꞌ wɔra Wurubuaarɛ ɔbono ɔ bo soso-soso mɔ-lɛɛ!” ");
INSERT INTO acd_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Yesu gi naa kpaa loo Gyɛrusalem, ne ɔ kyon kpe Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so. Ɔ kerɛ kerɛ ilaa kamaasɛ gyan. Owi kya ta so mɔ, mɔ‑rɛ mɔ-akasɛbo gudu anyɔ mɔ mɛ lii Gyɛrusalem kpe Bɛtani. ");
INSERT INTO acd_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Imɔ gɛdɛ kɛsɛ mɔ, mɛ kii lii Bɛtani mɛ kya kpe Gyɛrusalem mɔ, akon a dɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ɔ lɛɛ ansi kerɛ mɔ, o wu gifeeya oyii ɔko mɔ‑rɛ mɔ-afɛdaa. Ne ɔ naa kpe mɔ asɛ de ɔꞌ kpaa kerɛ yɛɛ ɔ laa nyɛ mɔ-abi de oꞌ gyi abɛɛ. O kpe mɔ, oŋ wu ba‑a gibi kolon oyii mɔ so, afɛdaa wolɛ ne o wu. I lii fɛɛ oyii mɔ owi sɔrɔsɛ mɛŋ ti fo. ");
INSERT INTO acd_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Nfono mɔ Yesu gi tɔgɛ nnɔ wɔra oyii mɔ yɛɛ, “Foŋ baa nyɛ sɔrɔ de ɔko ɔꞌ nyɛ fo-abi gyi gɛkaako.” Yesu gi tɔgɛ sa oyii mɔ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ nu. ");
INSERT INTO acd_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mɛ kpaa fo Gyɛrusalem mɔ, Yesu gi kii naa kpe Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so. Ɔ fo nno mɔ, o wu yɛɛ asa mɛ kyu nno bingiri gigya ogyiten. Ɔ gya gigya agyibo abono lii gikpaara mɔ so. Asa ako mɛ tɛ mɛ kya boori aterenbi, ne ako mɔ mɛ kya fɛ abonbuɛ nno. O wu mɔmɔ mɔ, ɔ da abono mɛ kya boori aterenbi mɔ iteebulu bun, ne ɔ da abono mɛ kya fɛ abonbuɛ mɔ ngyapaa too-too. ");
INSERT INTO acd_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","O kine kee yɛɛ ɔko‑rɛ ɔko ɔ mɛŋꞌ sa ɔꞌ sola gɛsola baa kyu de Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","O nyiile asa abono mɛ bo nfono mɔ ilaa yɛɛ, “Mɛ wolaa ŋmarasɛ Wurubuaarɛ agyɛbi ako yela yɛɛ, ‘Me-ɔson obu mɔ laa wɔra ɔdalaaten sa asa kpɛi-kpɛi pɛwu.’ Ne i wonɛ ne fɛye, mɔ, fɛ kyu nno bingiri iyu gikpalan?” ");
INSERT INTO acd_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Yesu ilaa nyiilesɛ mɔ i dɛ sakpii mɔ pɛwu gɛnɔ, ne i tɔrɔ mɔmɔ-gisen. Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ nbara aŋmarasɛbo mɔ berɛ, mɛ nu ilaa ibono Yesu gi wɔra mɔ, mɛ laarɛ ɔkpa ɔbono so mɛ laa nyɛ mɔɔ mɔ mɔ. Mɛ kii mɛ selɛ Yesu gifuu. I kya nyiile yɛɛ mɛ wu yɛɛ sakpii mɔ yelɛ mɔ-gɛmara. ");
INSERT INTO acd_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","I baa fo gɛnen gɛkɛ gɛbono gɛdɔɔdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ lii ɔsowolɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Gɛdɛ kɛsɛ nyɛnyɛngɛ fu‑u mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kii mɛ kya kyon mɔ, mɛ wu gifeeya oyii mɔ gi wuꞌ lii mɔ-ilin dɔ kyu dii. ");
INSERT INTO acd_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Piita gi wu gɛnen mɔ, o nyingi ilaa ibono Yesu gi tɔgɛ sa oyii mɔ mɔ, ne o nyiile Yesu yɛɛ, “Ɔbelɛnsɛ, kerɛ, gifeeya oyii ɔbono fo tɔgɛ nnɔ wɔra mɔ gi wuꞌ mɔ!” ");
INSERT INTO acd_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yesu gi lɛɛ gɛnɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ sɔɔ Wurubuaarɛ gyi. ");
INSERT INTO acd_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gɛsintin ne n kya tɔgɛ fɛye faa, nengyene fo ɔko fo tɔgɛ sa gibii gidɛ yɛɛ, ‘Koso gɛrɛ kpaa tɔrɔ apoo dɔ’, ne fo mɛŋ sɔɔ fo-nyoro akyɔɔlɛ fo-gisen dɔ ne fo sɔɔ gyi yɛɛ i laa wɔra mɔ, Wurubuaarɛ laa yɛgɛ iꞌ wɔra sa fo gɛsintin. ");
INSERT INTO acd_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Imɔso n kya tɔgɛ fɛye yɛɛ ilaa kamaasɛ ibono fo ɔko fo laa dalaa kolɛ Wurubuaarɛ mɔ, sɔɔ gyi yɛɛ i laa yii fo-gibaa, ne gɛsintin, ɔ laa sa fo imɔ. ");
INSERT INTO acd_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Fo yelɛ fo kya dalaa ne fo nyi yɛɛ ɔko gi wɔra fo ilaa nyɛnyɛn mɔ, kyu kyɛɛ mɔ, de fo-sɛ ɔbono ɔ bo soso mɔ oꞌ kyu fo-lɛɛ ilaa nyɛnyɛn kyɛɛ fo.  ");
INSERT INTO acd_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Nengyene fo maŋ kyu kyɛɛ fo-nanboana mɔ, gɛnen kee ne fo-sɛ ɔbono ɔ bo soso mɔ maŋ kyu fo-lɛɛ ilaa nyɛnyɛn kyɛɛ fo ne.” ");
INSERT INTO acd_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kii ba Gyɛrusalem ɔsowolɛ so. Ɔ naa Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so mɔ, Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo de abelɛnsɛ sɛnsɛ ako mɛ ba mɔ asɛ ");
INSERT INTO acd_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ne mɛ baa taasɛ mɔ yɛɛ, “Ilaa ibono fo kya wɔra faa mɔ, anɛ ginyen dɔ ne fo kya wɔra imɔ daa? Anɛ ne n sa fo ɔkpa yɛɛ foꞌ wɔra imɔ?” ");
INSERT INTO acd_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Nfono ne Yesu gi tɔgɛ abelɛnsɛ mɔ yɛɛ, “Nan taasɛ fɛye ilaa kolon. Fɛ lɛɛ gɛnɔ sa me mɔ, nan tɔgɛ fɛye ɔbono ginyen n dɛ n kya wɔra gɛnen ilaa idɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Ilaa taasɛsɛ mɔ ne n gyɛ yɛɛ, ‘Wurubuaarɛ sagyere ɔbono Gyɔn gi gyere asa mɔ, anɛ ne n sa mɔ ɔkpa? Wurubuaarɛ abɛɛ anyamesɛ?’ Fɛꞌ lɛɛ gɛnɔ de nꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Yesu gi taasɛ abelɛnsɛ mɔ gɛnen mɔ, akyɔɔlɛ a tɔrɔ mɔmɔ wolɛ-wolɛ so, ne mɛ tɔgɛ yɛɛ, “Nengyene a tɔgɛ yɛɛ Wurubuaarɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono mɔ, ɔ laa taasɛ aye yɛɛ ne menɛ n wɔra so ne a mɛŋ sɔɔ Gyɔn gyi? ");
INSERT INTO acd_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Abɛɛ aꞌ tɔgɛ yɛɛ nyamesɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono daa? Kuaa!” Ibono so mɛ mɛŋ taalɛ tɔgɛ gɛnen mɔ ne n gyɛ yɛɛ mɛ selɛ sakpii mɔ gifuu. I lii fɛɛ sakpii mɔ kya buu Gyɔn yɛɛ Wurubuaarɛ ne n sun mɔ ne ɔ gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo gɛsintin. ");
INSERT INTO acd_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Imɔso mɛ tɔgɛ sa Yesu yɛɛ, “A mɛŋ nyi.” Ne Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “Fɛ maŋ tɔgɛ me berɛ mɔ, me kee maŋ tɔgɛ fɛye ɔbono ɔ sa me ɔkpa ne nꞌ kya wɔra ilaa ibono n kya wɔra mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Yesu gi kii tɔgɛ sa abelɛnsɛ mɔ akpalɛ dɔ yɛɛ, “Ɔnyen ɔko gi kyena. Ɔ dɔɔ gifɔlɛ giko ndɔɔ. (Mɛ kya kyu gɛnen gifɔlɛ gibono abi kyu wɔra nta.) Ɔ pɔrɔ ɔpɔɔrɛ kyaabɔɔ ndɔɔ mɔ, ɔ wɔra nta mɔ ɔdooten ndɔɔ mɔ dɔ, ne ɔ pɔrɔ obu faa lege-lege nfono asa mɛ laa nyɛ dii ndɔɔ mɔ mɔ. Ɔ wɔra imɔ idɛ ta mɔ, o kyu ndɔɔ mɔ kyu wɔra asa ako abaa dɔ yɛɛ mɛꞌ kerɛ nmɔ so de mɔ‑rɛ mɔmɔ mɛꞌ yɛ agyan abono mɛ laa nyɛ mɔ. Ne ɔ koso kpe ɔkpa kpaa kɛɛla. ");
INSERT INTO acd_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","“Gifɔlɛ mɔ abi aberɛ tɛɛsɛ a fo mɔ, ndɔɔ wura mɔ gi sun mɔ-dega ɔko yɛɛ oꞌ kpe mɔ-ndɔɔ akerɛbo mɔ asɛ de ɔꞌ kpaa sɔɔ mɔ-lɛɛ ogyiten bara mɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Mɔ-dega mɔ gi kpe mɔ, mɔ-ndɔɔ akerɛbo mɔ mɛ keda mɔ, ne mɛ daarɛ mɔ, ne mɛ gya mɔ kii abaa gikpan. ");
INSERT INTO acd_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ndɔɔ wura mɔ gi nu ilaa ibono i ba mɔ, o kii sun mɔ-dega ɔko ndɔɔ akerɛbo mɔ asɛ. Mɛ daarɛ ɔbono kee gooli mɔ-gimu, ne mɛ wɔra mɔ ibono i mɛŋ gyɛ iwɔrasɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ndɔɔ wura mɔ gi kii sun mɔ-dega ɔko kee. Ɔbono berɛ mɔ, mɛ mɔɔ mɔ kpem! O sun mɔ-adega sɛnsɛ gɛnen, ne ndɔɔ akerɛbo mɔ mɛ kya daarɛ ako, ne mɛ kya mɔɔ ako. ");
INSERT INTO acd_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“I san ndɔɔ wura mɔ isa kolon ɔko ɔŋ ti sun mɔ. Mɔ ne n gyɛ mɔ-bi kolon ɔbono ɔ bo ne mɔ-ilaa ne n bo mɔ-gisen dɔ mɔ. Ɔ tɔgɛ sa mɔ-nyoro yɛɛ, ‘Me-bi mɔ berɛ, mɛ laa kyu buubuu sa mɔ.’ Gɛsintin mɔ, o sun mɔ-bi mɔ mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ndɔɔ akerɛbo mɔ mɛ wu mɔ ɔ kya ba mɔ, mɛ tɔgɛ sa abara yɛɛ, ‘Ɔbono ɔ laa gyi mɔ-sɛ atɔ mɔ ne n kya ba faa. Aꞌ mɔɔ mɔ de mɔ-tɔgyi mɔ ɔꞌ nyɛ sii de aye.’ ");
INSERT INTO acd_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Gɛsintin mɔ, mɛ keda ndɔɔ wura mɔ mɔ-bi mɔ mɔɔ, ne mɛ too mɔ lii ndɔɔ mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Yesu gi da gikpalɛ gidɛ ta mɔ, ɔ taasɛ abelɛnsɛ mɔ yɛɛ, “Fɛ nyi yɛɛ menɛ ne ndɔɔ wura mɔ laa wɔra? Nꞌ tɔgɛ sa fɛye: ɔ laa kpaa mɔɔ mɔ-ndɔɔ akerɛbo mɔ de oꞌ kyu ndɔɔ mɔ wɔra apobɔrɔ abaa dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Yesu gi kii taasɛ mɔmɔ yɛɛ, “Imɔso fɛŋ ti kalɛ Wurubuaarɛ ɔwolɛ mɔ agyɛbi adɛ? Mɛ ŋmarasɛ yɛɛ, ‘Gibui gibono ibu apɔrɔbo mɔ mɛ kyu too gɛbaamara mɔ, gɛnen gibui kolon gibono ne n baa yɛgɛ obu mɔ giꞌ wɔra ɔlon ɔ yelɛ faa. ");
INSERT INTO acd_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Gɛnen ilaa idɛ i kya lii Wurubuaarɛ asɛ daa. I bo aye ɔbolɛ ne i kya dɛ aye-gɛnɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Gikpalɛ mɔ Yesu gi da kyu lii ndɔɔ akerɛbo mɔ so mɔ, abelɛnsɛ mɔ mɛ laarɛ yɛɛ mɛꞌ keda mɔ. I lii fɛɛ mɛ bii yɛɛ mɔmɔ ne ɔ darɛ. Mɛ kii mɛ selɛ sakpii ɔbono ɔ bo nfono mɔ. Imɔso mɛ naa taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Abelɛnsɛ mɔ mɛ naa gɛnen mɔ, mɛ kpaa sun Farasii gikpen mɔ dɔ asa ako de Wura Hɛrodɛ gɛmara abuubo mɔ ako kpe Yesu asɛ yɛɛ mɛꞌ kpaa taasɛ mɔ ilaa adawo so; nengyene fɛɛ ɔ lɛɛ gɛnɔ ɔkpa so mɔ, de ɔꞌ nyɛ tɔrɔ mɔmɔ-ɔdoo dɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Asunbo mɔ mɛ kpe, ne mɛ kpaa too Yesu soso yɛɛ, “Ɔbelɛnsɛ, a wu yɛɛ fo bo gɛsintin ne fo mɛŋ selɛ ɔko. Fo berɛ, fo mɛŋ kya kerɛ nyamesɛ sakyɔ abɛɛ mɔ-nyisigyi ɔbono ɔ bo mɔ de foꞌ buu ɔko don ɔko. Fo kya nyiile asa Wurubuaarɛ ɔkpa daa gɛsintin ɔkpa so. Rom wura belɛ ɔbono ɔ kya kerɛ aye so ne ɔŋ kya son Wurubuaarɛ mɔ, i dɛ ɔkpa Wurubuaarɛ asɛ fɛɛ aꞌ sɔɔ mɔ-lɛnpoo abɛɛ a mɛŋ sa aꞌ sɔɔ?” ");
INSERT INTO acd_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Yesu gi dɛsɛ yɛɛ mɛ kerɛ ansi daa ne mɛ kya taasɛ mɔ. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Menɛ so ne fɛ kya soo me idoo gɛnen? Ɔko ɔꞌ lɛɛ aterenbi gibi ba de nꞌ kerɛ.” ");
INSERT INTO acd_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Gɛsintin mɔ, mɛ kyu aterenbi gibi kyu sa mɔ, ne Yesu gi taasɛ mɔmɔ yɛɛ, “Anɛ gimu de mɔ-ginyen ne n gyan aterenbi gibi gidɛ so faa?” Ne mɛ lɛɛ gɛnɔ yɛɛ, “Rom wura belɛ mɔ-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Nfono ne Yesu gi tɔgɛ mɔmɔ yɛɛ, “To. Gɛnen berɛ mɔ, ilaa ibono i gyɛ Rom wura belɛ mɔ-lɛɛ mɔ, fɛꞌ kyu sa mɔ, de ibono, mɔ, i gyɛ Wurubuaarɛ-lɛɛ mɔ, fɛꞌ kyu sa Wurubuaarɛ.” Gɛnɔɔbono Yesu gi tɔgɛ mɔ, i dɛ mɔmɔ-gɛnɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Saadusii gikpen dɔ awura ako kee mɛ ba Yesu asɛ. Saadusii awura adɛ ne n kpɛ mɛ dɛ yɛɛ nyamesɛ gi wuꞌ mɔ, i ta. Iŋ baa i bo gɛtɛɛko ɔ laa kpaa kyena, ne Wurubuaarɛ maŋ kyingi asa gɛkaako. Imɔso gɛnen asa adɛ mɛ ba de mɛꞌ baa nu Yesu gɛnɔ dɔ. Mɛ taasɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ɔbelɛnsɛ, Mosisi gi yela nbara nko sa aye yɛɛ, ‘Nengyene ɔnyen gi wuꞌ taa mɔ-ka yɛgɛ owi ɔbono mɔ-ka mɔ mɛŋ ti korogɛ sa mɔ mɔ, mɔ-tedɛ abɛɛ mɔ-daa oꞌ kyu ɔkyii mɔ lɛɛ gikulaa de mɔ‑rɛ mɔ mɛꞌ korogɛ nbii sa mɔ-kuli ɔbono o wuꞌ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","“To. Owi ɔko dɔ mɔ, ɔnyen ɔko mɔ‑rɛ mɔ-tedɛana asee mɛ kyena. Gɛnen ɔnyen baarɛ gi kyu ɔkyii. Mɔ‑rɛ mɔ-ka mɔ mɛŋ korogɛ pɛi ne ɔnyen mɔ gi wuꞌ taa mɔ-ka mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mosisi nbara nbono ɔ yela sa aye mɔ so mɔ, mɔ-gigyanmara mɔ gi kyu ɔkyii mɔ lɛɛ gikulaa. Mɔ‑rɛ ɔkyii mɔ mɛ mɛŋ korogɛ, ne mɔ kee gi wuꞌ taa ɔkyii mɔ yɛgɛ. Ɔsasɛ mɔ kee gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mɔmɔ anyen sono mɔ pɛwu mɛ dena ɔkyii mɔ, ne mɛ wuꞌ taa mɔ yɛgɛ. Ɔkyii mɔ mɛŋ korogɛ sa mɔmɔ ɔko‑rɛ ɔko. Laalaalogɛ mɔ, ɔkyii mɔ kee gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","To, nengyene Wurubuaarɛ laa kyingi asa mɔ, anɛ ne n bo ɔkyii mɔ gɛnen gɛkyena pobɔrɔ gɛbono dɔ? I kya nyiile yɛɛ owi ɔbono mɛ tɛ de ansi mɔ, mɔmɔ anyen sono adɛ pɛwu mɛ dena mɔ gyan.” ");
INSERT INTO acd_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛ fuɛ. I kya nyiile yɛɛ fɛ mɛŋ kya nu Wurubuaarɛ agyɛbi mɔ gɛsɛ, ne fɛ mɛŋ nyi Wurubuaarɛ ɔlon ɔbono ɔ bo mɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Asa abono Wurubuaarɛ laa kyingi de mɛꞌ nyɛ gɛkyena pobɔrɔ mɔ, gɛdena gɛ mɛŋ baa gɛ bo no sa mɔmɔ. Mɔmɔ-gɛkyena gɛ laa wɔra daa fɛɛ Wurubuaarɛ dɔ isɔɔ-lɛɛ mɔ ɔnan.” ");
INSERT INTO acd_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ne Yesu gi kii tɔgɛ sa Saadusii awura mɔ yɛɛ, “Fɛ kya sɔɔ akyɔɔlɛ yɛɛ asa mɛ wuꞌ mɔ, iŋ baa i bo gɛtɛɛko mɛ laa kpaa kyena mɔ faa mɔ, aꞌ kerɛ Wurubuaarɛ agyɛbi mɔ dɔ de aꞌ kerɛ. Imɔso fɛŋ ti kalɛ aye-naana Mosisi ilaa nno? Owi ɔbono Wurubuaarɛ gi yelɛ giponfɛ giko dɔ tɔngɛ sa mɔ mɔ, ɔ tɔgɛ Mosisi yɛɛ, ‘Me ne n gyɛ Aberaham Wurubuaarɛ. N gyɛ Ayisiki Wurubuaarɛ, ne nꞌ gyɛ Gyeekɔpo Wurubuaarɛ.’ ");
INSERT INTO acd_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Aberɛ abono Wurubuaarɛ gi tɔgɛ gɛnen ilaa idɛ sa Mosisi mɔ, gɛnen asa adɛ mɛ ti wolaa wuꞌ. Ne fɛɛ iloobu idɛ mɛŋ bo gɛtɛɛko daa mɔ, Wurubuaarɛ maŋ tɔgɛ yɛɛ, ‘N gyɛ mɔmɔ-Wurubuaarɛ.’ Nkana ɔ laa tɔgɛ daa yɛɛ, ‘Nɛ naa kyena wɔra mɔmɔ-Wurubuaarɛ yɛgɛ.’ Fɛ fuɛ gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mɛ yelɛ mɛ kya sɔɔ akyɔɔlɛ gɛnen mɔ, Gyuda awura nbara ɔŋmarasɛbo ɔko gi ba ɔ kya nu mɔmɔ asɛ. O nu ibono Yesu gi lɛɛ gɛnɔ kanpɛ mɔ, mɔ kee gi taasɛ Yesu yɛɛ, “Wurubuaarɛ nbara mɔ dɔ pɛwu mɔ, nmɔ ne n tansi gi tiri don nsɛnsɛ?” ");
INSERT INTO acd_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Nbono gi tiri don nsɛnsɛ mɔ ne n gyɛ nbono gi kya tɔgɛ yɛɛ, ‘Isirale awura, fɛꞌ yela fɛye-aso de fɛꞌ nu! Aye-Wura Wurubuaarɛ gyɛ daa ɔkolon. ");
INSERT INTO acd_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Imɔso laarɛ fo-Wura Wurubuaarɛ ilaa lii fo-gisen dɔ. Kyu fo-gisen pɛwu, fo-gɛwɔnsa pɛwu de fo-ɔlon pɛwu kyu laarɛ Wurubuaarɛ ilaa.’ ");
INSERT INTO acd_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Nbara nyɔsɛ nbono kee gi baa gi tiri mɔ ne n gyɛ yɛɛ, ‘Laarɛ fo-nanbo fɛɛ fo-nyoro.’ I mɛŋ baa i bo nbara nko gi tiri don nmɔ ndɛ.” ");
INSERT INTO acd_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Nbara ɔŋmarasɛbo mɔ gi tɔgɛ Yesu yɛɛ, “Ɔbelɛnsɛ, ibono fo tɔgɛ mɔ, i gyɛ gɛsintin; Wurubuaarɛ kolon ne n bo no. Mɔ-gɛmara mɔ, Wurubuaarɛ ɔko mɛŋ baa ɔ bo no. ");
INSERT INTO acd_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","I kaaborɛ nyamesɛ oꞌ kyu mɔ-gisen pɛwu, mɔ-nwɔnsa pɛwu, de mɔ-nyoro ɔlon pɛwu kyu laarɛ Wurubuaarɛ ilaa de ɔꞌ laarɛ mɔ-nanbo ilaa fɛɛ mɔ-nyoro. Nyamesɛ gi gyi gɛnen nbara nnyɔ ndɛ so mɔ, imɔ ne n tiri gikyɔ don ibono ɔ laa kyu nbuɛ lɛɛ asunbi kamaasɛ sa Wurubuaarɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Yesu gi nu gɛnɔɔbono ɔnyen mɔ gi lɛɛ gɛnɔ fɛɛ ɔlaako onyibo mɔ, ɔ tɔgɛ mɔ yɛɛ, “Fo‑rɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ iŋ bo gɛta de abara.” San kyu lii nfono mɔ, ɔko mɛŋ baa taalɛ da otu taasɛ Yesu ilaa de mɛꞌ daasɛ mɔ kerɛ. ");
INSERT INTO acd_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Imɔ gɛmara mɔ Yesu kya nyiile ilaa Wurubuaarɛ ɔson obu gikpaara mɔ so mɔ, ɔ taasɛ abelɛnsɛ mɔ yɛɛ, “Nnɛ so ne nbara anyiilebo mɔ mɛ kya tɔgɛ yɛɛ ɔbono Wurubuaarɛ laa sun de oꞌ gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ laa kisee wɔra daa Wura Deefidi ɔnaanabi? ");
INSERT INTO acd_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Yɛgɛ Wurubuaarɛ Oduduu mɔ gi nyiile Wura Deefidi ne mɔ gbaa-gbaa gi wolaa tɔgɛ kaasɛ mɔ ilaa yela yɛɛ, ‘Wurubuaarɛ laa tɔgɛ sa me-Wura mɔ yɛɛ, “Baa kyena me-gibaa gyisɛ so de me‑rɛ fo aꞌ gyi gɛwura de nꞌ yɛgɛ foꞌ kyise fo-akyobo de fo-ayaa.” ’ ” ");
INSERT INTO acd_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Yesu gi kii lɛɛ gɛsɛ yɛɛ, “Imɔso Deefidi gbaa-gbaa kya terɛ kaasɛ yɛɛ ‘me-Wura’ faa mɔ, nnɛ so ne ɔ laa kisee wɔra daa Deefidi ɔnaanabi?” Sakpii ɔbono ɔ bo nfono mɔ pɛwu gi nu Yesu ilaa tɔgɛsɛ mɔ, i wɔra mɔmɔ ɔkon kyɔde. ");
INSERT INTO acd_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Yesu kya nyiile asa mɔ ilaa mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de aye Gyuda awura nbara aŋmarasɛbo adɛ. Mɛ kya laarɛ daa ngbɛ belɛ-belɛ gisuu naa asa dɔ. Mɛ kya laarɛ de asa mɛꞌ terɛ mɔmɔ yɛɛ ‘Abelɛnsɛ’ de mɛꞌ kyu buubuu faala ɔmɔ sansana de ɔkamaasɛ oꞌ wu. ");
INSERT INTO acd_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ne fɛɛ mɛ kpe mɔmɔ-akyangbon dɔ abɛɛ mɛ laa gyi gɛkɛ belɛ mɔ, abelɛnsɛ de anyamesɛ gbaaꞌgbaa ikyenaten ne mɛ kya laarɛ gikyena. ");
INSERT INTO acd_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Mɔmɔ gɛnen asa abono ne n kya kii kudi akyii ikulaabo mɔmɔ‑rɛ mɔmɔ-biana gyi, yɛgɛ mɛ laa dalaa mɔ, mɛ kya dalaa faa bolo-bolo de asa mɛꞌ nyɛ yen mɔmɔ yɛɛ mɛ nyi gɛdalaa. Owi ɔbono Wurubuaarɛ laa gyi mɔmɔ-nbɛlɛ mɔ, mɔmɔ-gisobiidɛ gi laa nyaakyɔ too.” ");
INSERT INTO acd_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Yesu tɛ Wurubuaarɛ ɔson obu gikpaara mɔ so, mɔ-ansi a sa de aterenbi gidɛkaa. Nno ne asa mɛ kya kyu aterenbi abono mɛ kya kyɛɛ Wurubuaarɛ mɔ wɔra. Imɔso Yesu tɛ ɔ kerɛ asa sakyɔ abono mɛ kya baa too aterenbi mɔ. O wu aterenbi awura sakyɔ mɛ kya baa too aterenbi belɛ-belɛ mɛ kya wɔra gidɛkaa mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Nfono mɔ, ɔkyii okulaabo yenbo ɔko gi ba. Ne o kyu aterenbi abi anyɔ kyu too wɔra gidɛkaa mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yesu gi wu gɛnen mɔ, ɔ terɛ mɔ-akasɛbo mɔ, ne o nyiile mɔmɔ yɛɛ, “Iŋ gyɛ fɛ wu okulaabo yenbo baarɛ? Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, ɔkyii baarɛ gi kyɛɛ Wurubuaarɛ aterenbi don asa sɛnsɛ abono mɛ kya too mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","I kya nyiile yɛɛ asa adɛ pɛwu mɛ kya gyɔgɛ mɔmɔ-aterenbi dɔ daa kyu baa kyɛɛ Wurubuaarɛ. Ɔkyii mɔ berɛ, ipii ibono ɔ bo ne nkana imɔ ne ɔ tɛ ɔ kpasa de mɔ, imɔ pɛwu ne o kyu baa kyɛɛ Wurubuaarɛ faa.” ");
INSERT INTO acd_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Yesu kya lii Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so mɔ, mɔ-akasɛbo mɔ dɔ ɔko gi tɔgɛ mɔ yɛɛ, “Ɔbelɛnsɛ, kerɛ ibu mɔ ɔdan. Kerɛ gɛnɔɔbono imɔ-abui mɔ a kiirɛ ne a bo kanpɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Iŋ gyɛ fɛ kya wu ibu belɛ-belɛ idɛ? Ako mɛ laa baa boori imɔ bun. Ba‑a gibui kolon gi maŋ san yɛɛ gi maŋ dɛ gɛsɛ.” ");
INSERT INTO acd_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Imɔ gɛmara mɔ, Yesu tɛ Nfɔ Iyii Gibii mɔ so mɔ-ansi a sa de Wurubuaarɛ ɔson obu mɔ, ne Piita, Gyeemesi, Gyɔn, de Andiru mɛ ba mɛ kya taasɛ mɔ ilaa mɔmɔ wolɛ. Mɛ taasɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Owi ɔmɔ dɔ ne mɛ laa boori imɔ bun gɛnen? Menɛ ilaa ne nan ba de iꞌ lɛɛ nyiile yɛɛ ilaa idɛ pɛwu i kya laarɛ iꞌ ba gɛsintin? A kya kolɛ fo, tɔgɛ aye.” ");
INSERT INTO acd_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de ɔko ɔ mɛŋꞌ sa ɔꞌ nyɛ fɛye penɛ. Gɛnen ilaa ibono i maŋ ba nperɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Pɛi de iꞌ lɔɔ ba gɛnen mɔ, asa sakyɔ mɛ laa naa mɛ kya tɔgɛ yɛɛ mɔmɔ ne n gyɛ me ɔbono Wurubuaarɛ gi sun mɔ. Gɛnen asa abono mɛ laa nyɛ asa sakyɔ penɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Nengyene fɛ kya nu ikɔ so titiritii de koo-koo mɔ, fɛ mɛŋ sa fɛꞌ yɛgɛ fɛye-gisen giꞌ ŋmaa fɛye. I lii fɛɛ gɛnen ilaa idɛ i kaaborɛ iꞌ ba. Ne i mɛŋ gyɛ yɛɛ ilaa kamaasɛ i kya yela ɔkara ayaa abono so ne. ");
INSERT INTO acd_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","I kya nyiile yɛɛ fɛ laa nu gɛsinkpan so asa kpɛi-kpɛi mɛ laa laarɛ ikɔ too abara so. Abɛyin de abɛyin mɛ laa koso yelɛ mɛ kya kɔ de abara. Nten kpɛi-kpɛi so mɔ, gɛsinkpan gɛ laa gyigisi. Akon kee a laa tɔrɔ. Imɔ idɛana i laa nyiile yɛɛ gɛkyena gɛdɛ ilaa i kya yii gɛsɛ i kya kpe laalaalogɛ daa. I laa wɔra fɛɛ gɛnɔɔbono gɛdun gɛ kya tu ɔkyii, ne i mɛŋ gyɛ ayaa abono so ne ɔ kya korogɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Fɛye abono fɛ kya son me mɔ berɛ, fɛꞌ bii fɛye-nyoro akedabi. Ibono fɛ gyɛ me-akasɛbo faa so mɔ, mɛ laa kyu fɛye kyu kpe nbɛlɛ agyibo asɛ. Mɛ laa taa fɛye awulibi mɔmɔ-akyangbon dɔ. Me so mɔ, fɛ laa yelɛ awura de abɛyin abelɛnsɛ ansi dɔ de mɛꞌ nyɛ nu me-ilaa lii fɛye-gɛnɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Pɛi ne gɛsinkpan so gɛkyena gɛ laa ta ɔkara mɔ, gɛnen mɔ, mɛ tɔgɛ me-ɔkalan konkonsɛ mɔ sa gɛsinkpan so asa kpɛi-kpɛi pɛwu gyanꞌ. ");
INSERT INTO acd_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","“Nengyene mɛ kyu fɛye kyu kpe nbɛlɛ agyibo asɛ mɔ, fɛ mɛŋꞌ sa fɛꞌ yɛgɛ de iꞌ wɔra fɛye gɛwɔnsa yɛɛ menɛ ne fɛ laa kpaa tɔgɛ nbɛlɛ ogyiten mɔ. Owi mɔ gi fo mɔ, fɛꞌ bugi fɛye-nnɔ de fɛꞌ tɔgɛ ilaa ibono Wurubuaarɛ laa sa fɛye yɛɛ fɛꞌ tɔgɛ mɔ. Wurubuaarɛ Oduduu mɔ ne nan tɔngɛ naa de fɛye so, i mɛŋ gyɛ fɛye gbaa-gbaa ne nan tɔngɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“I laa ba yɛɛ fɛye abono fɛ kya son me faa dɔ ako, fɛye-daana abɛɛ fɛye-tedɛana mɛ laa fɛ fɛye sa fɛye-akyobo de mɛꞌ mɔɔ fɛye. Ɔsɛ gbaa laa kyu gɛnen wɔra mɔ-bi, ne gɛbii gɛ laa koso yelɛ gɛmɔ-sɛ de gɛmɔ-nyi so de gɛꞌ yɛgɛ asa mɛꞌ mɔɔ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Me so mɔ, ɔkamaasɛ laa kyo fɛye. Ɔbono ɔ laa yelɛ mɔ-ayaa so ka gyan me so kpaa lii mɔ, Wurubuaarɛ laa mɔlɛgɛ mɔ de ɔꞌ nyɛ ɔkyenaten mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Pɛi de gɛkyena gɛdɛ gɛꞌ yela ɔkara mɔ, fɛ laa wu ilaa kyosɛ ibono i kya nyida Wurubuaarɛ ɔson ilaa mɔ i yelɛ nfono i mɛŋ kaaborɛ iꞌ yelɛ mɔ. (Fo ɔbono fo kya kalɛ ilaa idɛ mɔ, nu imɔ gɛsɛ.) Fɛ wu ilaa kyosɛ mɔ nno gɛnen mɔ, fɛye abono fɛ bo Gyudiya gɛsinkpan so mɔ, fɛꞌ selɛ kpe abii dɔ. ");
INSERT INTO acd_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Fo ɔbono fo bo nŋmaŋman gɛnen owi ɔbono mɔ, selɛ. Gɛŋ sa foꞌ kii gɛmara abɛɛ foꞌ loo obu dɔ yɛɛ fo laa kpaa puru ilaa iko. ");
INSERT INTO acd_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Fo ɔbono fo bo ndɔɔ dɔ gɛnen owi ɔbono mɔ, gɛŋ baa kii ba gɛwi yɛɛ fo kya ba de foꞌ baa kyu fo-gikuru. ");
INSERT INTO acd_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Awɔrɔfɔɔ a laa nyaakyɔ gikyɔ so mɔ, akyii abono mɛ dɛ itɔ gɛnen nkɛ nbono dɔ abɛɛ mɔmɔ-biana mɛ san mɛ kya nyabo mɔ, mɔmɔ laako! ");
INSERT INTO acd_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Fɛꞌ dalaa sa Wurubuaarɛ yɛɛ gɛnen ilaa idɛ mɔ, i mɛŋꞌ sa iꞌ ba gikyɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","I lii fɛɛ gɛnen nkɛ nbono dɔ-lɛɛ awɔrɔfɔɔ mɔ a laa don awɔrɔfɔɔ kamaasɛ abono nyamesɛ gi ti wu kerɛ kpɛ kyu lii ko‑o ibono Wurubuaarɛ gi lɛɛ soso de gɛsɛ mɔ baa lii de ndɛ faa. Ne awɔrɔfɔɔ abono ɔnan kee a maŋ baa ba gɛkaako. ");
INSERT INTO acd_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Asa abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛꞌ nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ so mɔ, ɔ keda awɔrɔfɔɔ nkɛ mɔ kɔɔgɛ. Iŋ gyɛ gɛnen mɔ, nkana pɛi de nkɛ mɔ gi baa logɛ mɔ, iŋ baa san ba‑a isa. ");
INSERT INTO acd_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Gɛnen owi ɔbono mɔ, ako mɛ laa tɔgɛ yɛɛ, ‘Kerɛ, ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ aye mɔ ne gɛrɛ.’ Ako, mɔ, mɛ laa tɔgɛ yɛɛ, ‘Kerɛ, mɔ ne n gyɛ ɔdɛ.’ Nengyene mɛ nyiile fɛye gɛnen mɔ, fɛ mɛŋ sa fɛꞌ sɔɔ mɔmɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","I kya nyiile yɛɛ gɛnen owi ɔbono mɔ, i laa nyɛ abonbo ako. Ɔko laa tɔgɛ yɛɛ, ‘Me ne n gyɛ ɔbono Wurubuaarɛ gi tɔgɛ yɛɛ ɔ laa sun mɔ.’ Ɔbanban, mɔ, laa tɔgɛ yɛɛ, ‘N gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo.’ Mɛ laa wɔra ilaa ibono i kya dɛ gɛnɔ de ilaa ibono i kya lɛɛ ɔlon belɛ nyiile mɔ. Nkana mɔmɔ-ilaa wɔrasɛ mɔ i laa penɛ asa abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛꞌ nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ gbaa. I maŋ kii sa gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","“Imɔso fɛye abono fɛ kya son me mɔ berɛ, fɛꞌ dɛsɛ fɛye-nyoro so. Nɛ wolaa gyɔ fɛye ilaa kamaasɛ ɔwɔlii yela. ");
INSERT INTO acd_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Awɔrɔfɔɔ mɔ nkɛ mɔ gi baa kyon mɔ, gɛnen nkɛ nbono dɔ mɔ, owi laa biiri. Bosɛ laa yela asa gikulaa. ");
INSERT INTO acd_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Agyɛkpebi a laa kyigi giyan-giyan. Wurubuaarɛ laa keda ilaa ibono i bo soso mɔ gyigisi. ");
INSERT INTO acd_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Nfono ne asa mɛ laa wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan naa lii Wurubuaarɛ awolɛ dɔ n kya ba, n dɛ nyisigyi de ɔlon belɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nan sun Wurubuaarɛ dɔ isɔɔ de mɛꞌ kpaa koola asa abono Wurubuaarɛ gi tɔɔsɛ lɛɛ yɛɛ mɛ laa nyɛ mɔ-gɛwuragyi dɔ akyenabi mɔ. Mɛ laa koola mɔmɔ lii gɛsinkpan gɛdɛ gɛten kamaasɛ.” ");
INSERT INTO acd_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Ne Yesu gi da gikpalɛ sa mɔmɔ yɛɛ, “Fɛꞌ kasɛ ilaa lii gifeeya oyii so. Aye gɛrɛ mɔ, nengyene fɛ wu gifeeya ngyalenbi gi punge ne gi boori afɛdaa mɔ, fɛ kya bii yɛɛ gikyɛ gi kya fuude ne. ");
INSERT INTO acd_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Gɛnen kee ne i dɛ ne. Nengyene fɛ wu ilaa ibonoana nɛ tɔgɛ sa fɛye faa i kya ba mɔ, fɛꞌ bii yɛɛ me-gikiiba mɔ gi tansi fuude ne. N ti n yelɛ fɛye-gɛbunono gbaa-gbaa. ");
INSERT INTO acd_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gɛsintin ne n kya tɔgɛ fɛye faa. Asa abono mɛ tɛ gɛsinkpan so gɛnen aberɛ adɛ dɔ mɔ mɛ maŋ wuꞌ ta pɛi de gɛnen ilaa idɛana pɛwu iꞌ lɔɔ ba. ");
INSERT INTO acd_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Soso de gɛsɛ i laa yela ɔkara. Me-agyɛbi mɔ berɛ, a maŋ yela ɔkara gɛkaako kpa‑a. ");
INSERT INTO acd_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Gɛkɛ gɛbono abɛɛ owi ɔbono nan kii ba mɔ berɛ, ɔko mɛŋ nyi. Wurubuaarɛ dɔ isɔɔ gbaa mɛ mɛŋ nyi, ne me, Wurubuaarɛ mɔ-bi mɔ kee, meŋ nyi, gɛnen mɔ, me-sɛ Wurubuaarɛ mɔ-nkon ne n nyi. ");
INSERT INTO acd_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Imɔso fɛ mɛŋ nyi owi ɔbono nan kii ba faa mɔ, fɛꞌ kerɛ dandan de fɛꞌ dɛsɛ fɛye-nyoro so. ");
INSERT INTO acd_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“I laa wɔra fɛɛ gikpalɛ gibono nan baa da faa. Ɔbelɛnsɛ ɔko ne n kyena, ɔ kya laarɛ oꞌ kpe ɔkpa. Gɛkaabono ɔ laa koso gɛwi mɔ, o kyu mɔ-gɛsun wɔra mɔ-adega abaa dɔ, mɔmɔ ɔkamaasɛ mɔ‑rɛ mɔ-lɛɛ gɛsun wɔrasɛ. Ɔ tɔgɛ sa ɔbono ɔ tɛ ɔ kya dii mɔ-gɛbunono mɔ yɛɛ ɔ kya kyon faa, ɔꞌ kerɛ dɔɔdan; ɔ mɛŋꞌ sa ɔꞌ dɛ ginsi gidɛ.” ");
INSERT INTO acd_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Imɔso fɛye kee, fɛꞌ dɛsɛ fɛye-nyoro so. I kya nyiile yɛɛ fɛ mɛŋ nyi aberɛ abono me, fɛye-gɛten wura mɔ, nan kii ba mɔ. I gyɛ gɛnyɛ‑o, gɛnyɛ de nsana‑o, kyaasɛ gyangbarasɛ afolɛberɛ‑o, abɛɛ gibaadiikɛ daa‑o, ɔko mɛŋ nyi. ");
INSERT INTO acd_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Meŋꞌ kya laarɛ fɛɛ nꞌ baa tuule fɛye ibono fɛ mɛŋ dɛsɛ. ");
INSERT INTO acd_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iŋ gyɛ fɛye-wolɛ ne nꞌ kya tɔgɛ ilaa idɛ mi‑i sa. N darɛ daa nyamesɛ kamaasɛ yɛɛ ɔꞌ dɛsɛ mɔ-nyoro so gyoo me-giba.” ");
INSERT INTO acd_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","I kya san nkɛ nnyɔ de Gyuda awura mɛꞌ gyi mɔmɔ-Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ de Bodobodo Maadiisɛ Agyiberɛ gɛsi. Gɛnen owi ɔbono mɔ Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo mɛ san mɛ kya laarɛ gɛnɔɔbono mɛ laa ŋara keda Yesu de mɛꞌ mɔɔ mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","I kya nyiile yɛɛ mɛ kya tɔgɛ yɛɛ iŋ kaaborɛ mɛꞌ mɔɔ mɔ gɛsi mɔ gigyi dɔ; iŋ gyɛ gɛnen mɔ, i laa naa bara ikɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Yesu gi kpe Bɛtani ɔsowolɛ so. Ɔ bo nno mɔ, o kpe Simon ɔbono nkana ɔ gyɛ okononbu mɔ gɛwi. Mɛ tɛ mɛ kya gyi mɔ, ɔkyii ɔko gi ba Yesu asɛ ɔ dɛ anuwanterɛ boɔgyalonsɛ ɔko ɔnan. Nadi oyii ilin ne mɛ kyu wɔra mɔ. Ɔ fo Yesu asɛ mɔ, ɔ keda puruntuwa dɛnsɛ ɔbono anuwanterɛ mɔ bo mɔ dɔ mɔ gibɔ kpɛɛdɛ, ne ɔ kyɛɛgɛ anuwanterɛ mɔ worogɛ Yesu gimu so. ");
INSERT INTO acd_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ibono ɔkyii mɔ gi wɔra mɔ i loo asa abono mɛ bo nno mɔ ako. Imɔso mɛ taasɛ abara yɛɛ, “Menɛ n wɔra ne ɔkyii baarɛ gi gyi anuwanterɛ mɔ gyɛrɛbi faa? ");
INSERT INTO acd_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Anuwanterɛ baarɛ mɛn wɔra ɔfɛsɛ mɔ, nkana a laa nyɛ aterenbi belɛ de aꞌ kyu yɛ yɛ sa ayenbo!” Imɔso mɛ saalɛ ɔkyii mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Yesu, mɔ, gi tɔgɛ sa mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya nyala ɔkyii mɔ gɛnen? Fɛꞌ taa mɔ yɛgɛ. Ilaa dɛnsɛ ne ɔ wɔra sa me faa. ");
INSERT INTO acd_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ayenbo abono fɛ darɛ faa, mɛ bo fɛye asɛ adaa-adaa. Nengyene fɛ kya laarɛ fɛꞌ wɔra mɔmɔ idɛnsɛ mɔ, fɛ laa taalɛ wɔra sa mɔmɔ aberɛ kamaasɛ. Me berɛ, fɛ maŋ nyɛ me nꞌ kyena fɛye asɛ kpaa lii. ");
INSERT INTO acd_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ɔkyii mɔ gi wɔra ibono ɔ laa taalɛ mɔ sa me. O gyere me yela gyoo me-gipule ne. ");
INSERT INTO acd_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Fɛꞌ sɔɔ gibui yela. Gɛsinkpan so gɛten kamaasɛ gɛbono mɛ laa tɔgɛ tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ kyu lii me so mɔ, mɛ laa tɔgɛ ilaa ibono ɔkyii baarɛ gi wɔra sa me faa kee kyu nyingi mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Imɔ idɛ gɛmara mɔ, Yesu akasɛbo gudu anyɔ mɔ dɔ ɔbono mɛ kya terɛ mɔ yɛɛ Gyudasɛ Isikaayɔtɛ mɔ, gi kpe kpaa wu Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ, ne ɔ tɔgɛ mɔmɔ yɛɛ ɔ laa kpaa ɔmɔ de mɛꞌ nyɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Mɛ nu ibono Gyudasɛ gi tɔgɛ mɔ, i wɔra mɔmɔ ɔkon, ne mɛ ka sa mɔ yɛɛ nengyene ɔ taalɛ wɔra gɛnen mɔ, mɛ laa sa mɔ aterenbi. Imɔso ɔ san ɔ kya kerɛ owi ɔbono i laa sa de ɔꞌ yɛgɛ mɛꞌ nyɛ Yesu mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Bodobodo Maadiisɛ Agyiberɛ gɛkɛ belɛ mɔ gɛ kya yii gɛsɛ mɔ, mɛ kya kyɔɔlɛ isandɛ de mɛꞌ kyu gyi mɔmɔ-Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ. Gɛnen gɛkɛ gɛbono mɔ, Yesu akasɛbo mɔ mɛ baa taasɛ mɔ yɛɛ, “Fonɛ ne fo kya laarɛ aꞌ kpaa kerɛ agyudɔ yela de aꞌ gyi Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ne Yesu gi lɛɛ mɔ-akasɛbo anyɔ sun, ne ɔ tɔgɛ mɔmɔ yɛɛ, “Fɛꞌ naa loo nten dɔ. Fɛ kya loo mɔ, fɛ laa wu ɔnyen ɔko so nkyu de gɛlɔbi. Fɛꞌ buu mɔ kpaa loo gɛten gɛbono dɔ ɔ laa loo mɔ, ");
INSERT INTO acd_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","de fɛꞌ taasɛ gɛten wura mɔ yɛɛ, ‘Ɔbelɛnsɛ mɔ yɛɛ asafo obu ɔmɔ dɔ ne mɔ‑rɛ mɔ-akasɛbo mɔ mɛ laa baa kyena de mɛꞌ gyi gɛkɛ belɛ mɔ agyudɔ mɔ?’ ");
INSERT INTO acd_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Gɛten wura mɔ laa nyiile fɛye soso-lɛɛ obu belɛ ɔko. Ikyenaten de ikamaasɛ i ti i bo nno. Fɛꞌ baala agyudɔ mɔ yela sa aye nno.” ");
INSERT INTO acd_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Yesu akasɛbo mɔ mɛ kyon kpaa loo nten mɔ dɔ. Gɛsintin mɔ, mɛ wu ibono pɛwu Yesu gi tɔgɛ sa mɔmɔ mɔ. Ne mɛ kerɛ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ agyudɔ mɔ yela nno. ");
INSERT INTO acd_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","I fo gɛdɔɔdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo gudu anyɔ mɔ mɛ kpe nno de mɛꞌ kpaa gyi. ");
INSERT INTO acd_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Mɛ kya gyi mɔ, Yesu gi tɔgɛ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa; fɛye dɔ ɔko laa yɛgɛ me-akyobo mɛꞌ nyɛ me. Me‑rɛ kaasɛ ne n kya wɔra abaa gyi.” ");
INSERT INTO acd_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Yesu gi tɔgɛ gɛnen mɔ, i wɔra mɔ-akasɛbo mɔ ayen, ne mɛ san mɛ kya taasɛ mɔ ɔko-ɔko yɛɛ, “Me ne nan wɔra fo gɛnen?” ");
INSERT INTO acd_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛye gudu anyɔ adɛ dɔ ɔko laa yɛgɛ me-akyobo mɛꞌ nyɛ me. Me‑rɛ kaasɛ a kya wɔra abaa gyi lɛpɛ kolon dɔ faa. ");
INSERT INTO acd_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","I bo no yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan wuꞌ lɛwu ɔbono ɔnan mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ kyu lii me so mɔ. Ɔbono ɔ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra me-akyobo abaa dɔ mɔ berɛ, kaasɛ mɔ laako. I mɛŋnan korogɛ mɔ mɔ, i bɔ sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mɛ san mɛ kya gyi mɔ, Yesu gi puru bodobodo keda, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa-gbaa mɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ sɔɔ de fɛꞌ gyi. Me-nyoro ne.” ");
INSERT INTO acd_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ne o puru konkon de nta keda, ne o kyu afaala sa Wurubuaarɛ. O kyu nta mɔ sa mɔ-akasɛbo mɔ, ne mɔmɔ pɛwu mɛ nun kɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nta nbono nɛ sa fɛye faa, me-nkalan ne. Nan wuꞌ mɔ, me-nkalan gi laa kyɛɛgɛ fuɛ sa asa sakyɔ de iꞌ yɛgɛ mɔmɔ‑rɛ Wurubuaarɛ mɛꞌ nyɛ wɔra gɛnɔ pobɔrɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gɛsintin ne n kya tɔgɛ fɛye faa, pɛi ne nan kii nun nta mɔ, gɛnen mɔ, gɛkaabono n tɛ n kya nun nmɔ npobɔrɔ Wurubuaarɛ gɛwuragyi mɔ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ gyi ta mɔ, mɛ bii afaala ɔlon sa Wurubuaarɛ, ne mɛ lii kyon Nfɔ Iyii Gibii mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mɛ kya kpe mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛye pɛwu fɛ laa selɛ taa me yɛgɛ. I kya nyiile yɛɛ mɛ wolaa ŋmarasɛ me-ilaa yela Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, ‘Wurubuaarɛ laa mɔɔ isandɛ ɔkparɛbo mɔ; i ba gɛnen mɔ, isandɛ mɔ mɛ laa yaasɛ giyan-giyan.’ ” ");
INSERT INTO acd_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne Yesu gi kii tɔgɛ yɛɛ, “Nɛ kyingi lii ibuni dɔ mɔ, nan gyangbara fɛye kpe Galeli.” ");
INSERT INTO acd_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nfono ne Piita gi tɔgɛ sa Yesu yɛɛ, “Ba‑a asɛnsɛ mɔ pɛwu mɛ laa selɛ taa fo yɛgɛ mɔ, me berɛ, maŋ selɛ taa fo yɛgɛ kpa‑a.” ");
INSERT INTO acd_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Yesu gi tɔgɛ sa mɔ yɛɛ, “Sɔɔ gibui yela, ndɛ gɛnyɛ gɛdɛ pɛi de ikyaasɛ iꞌ baa folɛ ginyɔ mɔ, fo gbaa ne nan sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” ");
INSERT INTO acd_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ne Piita gi kii tɔgɛ mɔ ginsi pɛɛrɛ so yɛɛ, “Ba‑a mɛ laa mɔɔ me‑rɛ fo mɔ, maŋ sorogɛ yɛɛ meŋ nyi fo.” Ne akasɛbo sɛnsɛ mɔ mɛ tɔgɛ gɛnen kee. ");
INSERT INTO acd_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpe gɛtɛɛko, mɛ kya terɛ nno yɛɛ Gɛsɛmeni. Mɛ fo nno mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kyena gɛrɛ gyoo me de nꞌ kpaa dalaa.” ");
INSERT INTO acd_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ɔ yɛgɛ Piita, Gyeemesi, de Gyɔn berɛ mɛꞌ buu mɔ. Mɛ kya kpe mɔ, mɔ-gisen dɔ i yii gɛsɛ i kya dɛɛ mɔ, ne mɔ-nyoro gi kya togɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “N kya wuꞌ mi‑i fuɛ. I kya laarɛ de iꞌ mɔɔ me gbaa. Fɛꞌ kyena gɛrɛ de fɛꞌ dii ilaa kamaasɛ ibono i laa ba mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ɔ naa taa mɔmɔ yɛgɛ kpe ansi dɔ ŋmaraa, ne o kyu mɔ-nyoro too gɛsinkpan, ɔ kya dalaa ɔ kya kolɛ Wurubuaarɛ yɛɛ nengyene i laa sa mɔ, ɔꞌ yɛgɛ gɛnen ilaa ibono i kya ba mɔ so faa, iꞌ baa kyon nkan sa mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","O kii tɔgɛ yɛɛ, “Me-sɛ, sɛi mɛŋ don fo giwɔra. Nengyene fo laa kyule mɔ, nkana yɛgɛ awɔrɔfɔɔ abono a kya ba me so faa aꞌ kyon gibaafon. Nɛ dabɔlɛ kolɛ gɛnen faa, yɛgɛ fo-lɛɛ fo-gɛlaarɛ ne gɛꞌ wɔra. I mɛŋ gyɛ me-lɛɛ gɛlaarɛ.” ");
INSERT INTO acd_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ɔ dalaa gɛnen mɔ, o kii kpe mɔ-akasɛbo asaꞌ mɔ asɛ. Ɔ baa kpe mɔ, mɛ dɛ ginsi gidɛ. O kyingi mɔmɔ, ne ɔ taasɛ Simon Piita yɛɛ, “Simon, fɛ dɛ daa? Fɛ mɛŋ taalɛ kyena ba‑a ŋmaraa de fɛꞌ dii ilaa ibono i laa ba mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ dii ilaa ibono i laa ba mɔ de fɛꞌ dalaa yɛɛ imɔ iko i mɛŋꞌ nyɛ fɛye penɛ de fɛꞌ wɔra ilaa nyɛnyɛn. Nɛ wu yɛɛ fɛye-asen dɔ berɛ mɔ nkana fɛ kya laarɛ fɛꞌ wɔra me-gɛlaarɛ; fɛye anyamesɛ-lɛɛ ɔlon ne mɛŋ kya taalɛ.” ");
INSERT INTO acd_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","O kii kyon taa mɔmɔ yɛgɛ kpaa dalaa gɛnen gɛdalaa kolon gɛbono kee sa Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ɔ baa kii kpe mɔ-akasɛbo mɔ asɛ mɔ, mɛ kii dɛ. I lii fɛɛ ginsi gidɛ gi dɛ mɔmɔ. O kyingi ɔmɔ mɔ, mɛ mɛŋ bii ilaa ibono mɛ laa tɔgɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","42","Gisasɛ mɔ, o kpe kii baa tu mɔ-akasɛbo mɔ, o kyingi mɔmɔ, ne ɔ taasɛ mɔmɔ yɛɛ, “Fɛ san fɛ dɛ, fɛ kya kyoola? Fɛꞌ koso gɛnen; owi mɔ gi fo. Kon ne ilaa nyɛnyɛn awɔrabo mɛ laa nyɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ. Fɛꞌ kerɛ. Ɔbono ɔ laa kyu me wɔra mɔmɔ-abaa dɔ mɔ ne n kya ba faa. Fɛꞌ koso de aꞌ kpaa gyangara mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Yesu san ɔ kya tɔngɛ mɔ, ayaa abono so mɔ, Gyudasɛ, Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko, gi ba nfono. Sakpii buu mɔ, mɛ dɛ nki de nkpotii. Mɛ lii Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Gyudasɛ ɔbono ɔ laa kyu Yesu wɔra abelɛnsɛ mɔ abaa dɔ gɛnen mɔ gi wolaa tɔgɛ sa sakpii mɔ yɛɛ, “Ɔbono fɛ wu nɛ faala mɔ da mɔ gya-gya mɔ, mɔ ne. Fɛꞌ keda mɔ de fɛꞌ kparɛ mɔ kpe abelɛnsɛ mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Imɔso mɛ kpaa fo nno mɔ, gɛsintin mɔ, Gyudasɛ gi naa kpe Yesu asɛ, ne ɔ terɛ mɔ yɛɛ, “Ɔbelɛnsɛ!” ne ɔ faala mɔ da mɔ gya-gya. ");
INSERT INTO acd_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Nfono mɔ sakpii mɔ gi keda Yesu. ");
INSERT INTO acd_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ne Yesu asa abono mɛ bo nfono mɔ dɔ ɔko gi loorɛ mɔ-gɛki lɛɛ, ne ɔ ŋɛɛlɛ dega ɔko giso fuɛ. Dega mɔ wura ne n gyɛ Gyuda awura asunbi alɛɛbo gɛmu. ");
INSERT INTO acd_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Nfono ne Yesu gi taasɛ sakpii mɔ yɛɛ, “N gyɛ oyu nyɛnyɛn daa, ne fɛ kyu nki de nkpotii ba de fɛꞌ baa keda me faa? ");
INSERT INTO acd_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Iŋ gyɛ me‑rɛ fɛye ne n bo no gɛkɛ kamaasɛ n kya nyiile asa ilaa Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so? I wonɛ so ne fɛ mɛŋ keda me nno? To. Ɔfaanan ne fɛ laa kyu wɔra me de iꞌ yɛgɛ ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ iꞌ nyɛ ba gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nfono mɔ mɔ-akasɛbo mɔ pɛwu mɛ selɛ taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Sakpii mɔ dɛ Yesu ɔ kya kpe mɔ, gɛdegabi gɛko berɛ gɛ buu mɔ. Gikuru boɔgyalonsɛ wolɛ ne gɛ bun. Sakpii mɔ gi laarɛ ɔꞌ keda mɔ. ");
INSERT INTO acd_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ne o luu mɔ-nyoro lii gikuru mɔ dɔ sa mɔmɔ selɛ kyon gibolonbukpan. ");
INSERT INTO acd_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Mɛ kparɛ Yesu kpe Gyuda awura asunbi alɛɛbo gɛmu mɔ gɛwi, ne Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ abono mɛ kya gyi nbɛlɛ mɔ pɛwu mɛ baa gyanꞌ. ");
INSERT INTO acd_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Mɛ dɛ Yesu mɛ kya kpe gɛnen mɔ, Piita gi buu mɔmɔ giyaa-giyaa kpaa loo asunbi alɛɛbo gɛmu mɔ gikpaara mɔ so. Ɔ loo nno mɔ, o sii kyena saarɛ asunbi alɛɛbo gɛmu mɔ ngbɛ awura dɔ, mɛ tɛ mɛ kya wolɛ ɔgya. ");
INSERT INTO acd_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Mɛ kya gyi Yesu nbɛlɛ mɔ, Gyuda awura asunbi alɛɛbo abelɛnsɛ de nbɛlɛ agyibo mɔ pɛwu mɛ kya laarɛ ilaa ibono mɛ laa nyɛ yelɛ imɔ so kyu bun Yesu gipuɛɛ de mɛꞌ nyɛ mɔɔ mɔ mɔ. Mɛ mɛŋ kya nyɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Abono mɛ ten Yesu gɛnɔ mɔ mɛ nyaakyɔ. Mɔmɔ pɛwu nnɔ mɔ gɛŋ wɔra gikolon. ");
INSERT INTO acd_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ako mɛ koso kɛɛ abon gyan mɔ so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“A nu Yesu gi tɔgɛ yɛɛ, ‘Nan boori Wurubuaarɛ ɔson obu baarɛ bun de nꞌ kyu nkɛ nsa yii ɔpobɔrɔ. Anyamesɛ abaa ne mɛ kyu pɔrɔ ɔdɛ; ɔbono nan yii mɔ berɛ, iŋ gyɛ anyamesɛ abaa ne nan kyu yii mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Imɔ idɛ gɛnen gbaa mɔ, mɔmɔ abono mɛ tɔgɛ mɔ nnɔ gi mɛŋ wɔra gikolon. ");
INSERT INTO acd_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Nfono ne asunbi alɛɛbo gɛmu mɔ gi koso yelɛ sansana, ne ɔ taasɛ Yesu yɛɛ, “Ibono pɛwu mɛ dɛ ma‑a gyan fo so faa, foŋ bo gɛnɔ lɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","O sii kurun, ɔŋ tɔgɛ sɛi. Nfono ne asunbi alɛɛbo gɛmu mɔ gi kii taasɛ Yesu yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de oꞌ gyi gɛwura mɔ-adɛ so mɔ? Fo-sɛ ne n gyɛ mɔ ɔbono ayenbi pɛwu a kaaborɛ mɔ mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yesu yɛɛ, “Ɛn, me ne. Ne fɛ laa wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n tɛ Wurubuaarɛ Ɔlolonbo mɔ gyisɛ gibaa so, n kya gyi gɛwura mɔ asɛ. Nan kyena Wurubuaarɛ awolɛ so kpelegɛ ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Asunbi alɛɛbo gɛmu mɔ gi nu imɔ idɛ mɔ, ɔ biidɛ mɔ-gɛgbɛ kyadɛ de iꞌ lɛɛ nyiile yɛɛ ilaa i ba. Ne ɔ tɔgɛ yɛɛ, “Abelɛnsɛ, ibono ɔ tɔgɛ faa, iŋ don abaa? Ilaa imɔ ne a baa a kya laarɛ de aꞌ baa nu lii mɔ so? ");
INSERT INTO acd_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Fɛ nu gɛnɔɔbono o kyu mɔ-nyoro kɛserɛ de Wurubuaarɛ mɔ, fɛ dɛ nnɛ?” Ɔ taasɛ mɔmɔ gɛnen mɔ, mɔmɔ pɛwu mɛ bun Yesu gipuɛɛ, ne mɛ kyule yɛɛ ɔ kaaborɛ ɔꞌ wɔra ɔmɔɔsɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Nfono mɔ, mɔmɔ ako mɛ too akyɔlɛ bun mɔ. Ne mɛ kyu ilaa iko ŋminde mɔ-ansi, mɛ kya ŋɛ ma‑a ŋɛ mɔ akɔn, ne mɛ kya tɔgɛ mɔ yɛɛ ɔꞌ bii ɔbono ɔ ŋɛ mɔ mɔ. Mɛ kyu mɔ sa asunbi alɛɛbo gɛmu mɔ ngbɛ awura mɔ, ne mɛ da-da mɔ itan. ");
INSERT INTO acd_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Piita san ɔ tɛ gikpaara mɔ so gɛsɛ nno mɔ, asunbi alɛɛbo gɛmu mɔ obolonbu ɔko gi ba nfono. ");
INSERT INTO acd_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","O wu Piita tɛ ɔ kya wolɛ ɔgya. Ɔ kpɛɛlɛ kerɛ mɔ, ne ɔ tɔgɛ yɛɛ, “Fo kee fo‑rɛ Yesu Nasarɛtɛnyen mɔ ne n naa.” ");
INSERT INTO acd_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne Piita gi sorogɛ yɛɛ, “Meŋ nyi ilaa ibono fo darɛ faa. Meŋ kya nu imɔ gɛsɛ gbaa.” Piita gi tɔgɛ gɛnen ta mɔ, ɔ naa kpe gɛbunono asɛ. Ayaa abono so mɔ, ikyaasɛ i folɛ. ");
INSERT INTO acd_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Obolonbu ɔko gi wu Piita ne ɔ tɔgɛ sa abono mɛ bo nfono mɔ yɛɛ, “Ɔnyen baarɛ bo Yesu adɛ mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Piita gi kii sorogɛ imɔ lɛɛ ɔkpa. I kii wɔra ŋmaraa too mɔ, abono mɛ yelɛ nfono mɔ mɛ tɔgɛ sa Piita yɛɛ, “I gyɛ gɛsintin daa. Fo bo Yesu adɛ mɔ dɔ, i lii fɛɛ fo kee fo gyɛ Galelinyen.” ");
INSERT INTO acd_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ne Piita gi ka sa mɔmɔ yɛɛ, “Nɛ kerɛ fɛɛ Wurubuaarɛ, meŋ nyi ɔnyen ɔbono fɛ darɛ faa. Nengyene abon ne n kya kɛɛ mɔ, me‑rɛ Wurubuaarɛ abaa anyɔ.” ");
INSERT INTO acd_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Ayaa abono so mɔ, ikyaasɛ i folɛ ginyɔsɛ. Ne Piita gi nyingi gɛnɔɔbono Yesu gi wolaa tɔgɛ sa mɔ yɛɛ, “Ndɛ gɛnyɛ gɛdɛ pɛi de ikyaasɛ i baa folɛ ginyɔsɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” Piita gi nyingi gɛnen mɔ, ɔ loo osuten. ");
INSERT INTO acd_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Gɛdɛ gɛ kpɛ gɛ kya kɛ mɔ, nbɛlɛ agyibo mɔ pɛwu mɛ kii gyan. Gɛnen nbɛlɛ agyibo abono ne n gyɛ Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-isowolɛ so abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo. Mɛ gyan gɛnen mɔ, mɛ tɔgɛ kyule abara gɛnɔɔbono mɛ laa wɔra Yesu mɔ. Imɔso mɛ ŋminde mɔ, ne mɛ kparɛ mɔ lii kyu kpaa wɔra ɔbelɛnsɛ ɔbono ɔ tɛ sa Rom wura mɔ abaa dɔ yɛɛ oꞌ gyi mɔ-nbɛlɛ. Mɛ kya terɛ gɛnen ɔbelɛnsɛ ɔbono yɛɛ Pilato. ");
INSERT INTO acd_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ɔbelɛnsɛ Pilato kya gyi Yesu nbɛlɛ mɔ, ɔ taasɛ mɔ yɛɛ, “Fo ne n gyɛ wura sa Gyuda awura mɔ?” Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo-gɛnɔ dɔ ne i lii.” ");
INSERT INTO acd_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ mɛ kyu ilaa kpɛi-kpɛi gikyɔ gyan Yesu so. ");
INSERT INTO acd_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Imɔso Ɔbelɛnsɛ Pilato gi taasɛ Yesu yɛɛ, “Foŋ kya nu gɛnɔɔbono mɛ dɛ ilaa kpɛi-kpɛi gikyɔ ma‑a gyan fo so mɔ? Fo maŋ lɛɛ gɛnɔ?” ");
INSERT INTO acd_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Yesu mɛŋ baa bugi mɔ-gɛnɔ tɔgɛ sɛi, imɔso i dɛ Ɔbelɛnsɛ Pilato gɛnɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Gɛsi kamaasɛ i wolaa i gyɛ ilaa ibono Ɔbelɛnsɛ Pilato kya wɔra sa Gyuda awura mɔ yɛɛ nengyene mɛ laa gyi mɔmɔ-gɛkɛ belɛ gɛdɛ mɔ, ɔ kya tigi mɔmɔ-asa abono ɔ keda tii de obu mɔ dɔ nyamesɛ kolon de ɔꞌ naa. Mɔmɔ gbaa-gbaa ne n kya lɛɛ yii yɛɛ ɔdɛ ne mɛ kya laarɛ, ne Pilato kya tigi mɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Gɛnen owi ɔbono dɔ mɔ, ɔnyen ɔko tii de obu mɛ kya terɛ mɔ yɛɛ Barabasɛ. Owi ɔko dɔ mɔ, mɔ‑rɛ asa ako mɛ koso kɔ de abɛyin awura. Ikɔ mɔ dɔ mɔ mɛ mɔɔ asa, imɔso mɛ keda ɔmɔ tii de obu. Gɛnen Barabasɛ baarɛ bo mɔmɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Gɛkɛ belɛ mɔ so mɔ, sakpii gi kpe Ɔbelɛnsɛ Pilato asɛ kpaa kolɛ mɔ yɛɛ oꞌ tigi abono o tii de obu mɔ dɔ ɔko sa mɔmɔ fɛɛ gɛnɔɔbono ɔ kya kyena wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ne Ɔbelɛnsɛ Pilato gi taasɛ mɔmɔ yɛɛ, “Nꞌ tigi Yesu, fɛye Gyuda awura wura mɔ sa fɛye de ɔꞌ naa abɛɛ?” ");
INSERT INTO acd_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","I kya nyiile yɛɛ Pilato gi wu yɛɛ Yesu ilaa i bo Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ gɛlaaloo daa so ne mɛ kyu mɔ bara mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ mɛ ti wolaa wu sakpii mɔ yela yɛɛ, “Nengyene Pilato gi taasɛ fɛye yɛɛ anɛ ne ɔꞌ taa yɛgɛ sa fɛye mɔ, fɛꞌ tɔgɛ yɛɛ ɔꞌ tigi daa Barabasɛ; iŋ gyɛ Yesu.” Imɔso mɛ tɔgɛ sa Pilato yɛɛ Barabasɛ ne mɛ kya laarɛ. ");
INSERT INTO acd_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ne Pilato gi kii taasɛ mɔmɔ yɛɛ, “Mɔ, nnɛ ne nꞌ wɔra Yesu ɔbono fɛ kya terɛ yɛɛ fɛye Gyuda awura wura mɔ?” ");
INSERT INTO acd_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ɔ taasɛ mɔmɔ gɛnen mɔ, mɛ kpen tɔgɛ mɔ yɛɛ, “Da mɔ aŋanbi mada de oyii de oꞌ wuꞌ!” ");
INSERT INTO acd_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ne Pilato gi taasɛ mɔmɔ yɛɛ, “De iꞌ wonɛ? Menɛ ilaa nyɛnyɛn ne ɔ wɔra?” Nfono mɔ mɛ lɔrɔ kpen ken-ken daa yɛɛ, “Da mɔ aŋanbi oyii so mɔɔ!” ");
INSERT INTO acd_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Pilato kya laarɛ ɔꞌ buɛɛlɛ sakpii mɔ de iꞌ yuuli so mɔ, o tigi Barabasɛ, ne ɔ yɛgɛ asogya mɛꞌ taa Yesu awulibi, ne yɛɛ mɛꞌ kyu mɔ kpaa da aŋanbi oyii so mɔɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Nfono mɔ, asogya mɔ mɛ kyu Yesu kyu loo Pilato gɛwi nfono i gyɛ mɔmɔ-gɛsun ɔwɔraten mɔ. Ne mɛ terɛ mɔmɔ Rom asogya gikpen mɔ pɛwu baa gyan nno. ");
INSERT INTO acd_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Nfono mɔ, mɛ kyu giwurakuru kyu gyaabii bun mɔ, ne mɛ luo iwe wɔra fɛɛ wura gɛpɛ ne mɛ kyu bun mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Mɛ san mɛ kya gyaabii faala mɔ yɛɛ, “Gyuda awura wura! Fo‑rɛ gimu dɛnsɛ!” ");
INSERT INTO acd_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mɛ dɛ gɛyabii mɛ kya taa mɔ-gimu so ma‑a kpe ma‑a ba, ne mɛ kya too akyɔlɛ ma‑a bun mɔ. Mɛ san mɛ kya faala mɔ mɛ kya ŋmii mɛ kya koso fɛɛ wura-lɛɛ mɔ ɔnan. ");
INSERT INTO acd_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mɛ gyaabii mɔ gɛnen ta mɔ, mɛ maragɛ giwurakuru mɔ, ne mɛ kiiri mɔ gbaa-gbaa lɛɛ ngbɛ kyu suu mɔ, ne mɛ san kparɛ mɔ lii de mɛꞌ kpaa da mɔ aŋanbi oyii so mɔɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Mɛ dɛ Yesu mɛ kya kpe mɔ, mɛ gyangara ɔnyen ɔko, mɛ kya terɛ mɔ yɛɛ Simon. Ɔ gyɛ daa Siirinnyen. Mɔ-biana ne n gyɛ Alɛsanda de Rufusɛ. Mɛ wu mɔ mɔ, ɔ naa ɔ kya ba ɔꞌ baa loo ɔsowolɛ mɔ so, ne mɛ nyise mɔ yɛɛ ɔꞌ sola Yesu lɛwu oyii mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mɛ kyu Yesu kpaa fo gɛtɛɛko, mɛ kya terɛ nno yɛɛ Gologota. (Gologota gɛsɛ ne n gyɛ Gimu Giwuye Gikpalan.) ");
INSERT INTO acd_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Mɛ fo nno mɔ, mɛ kyu gɛlin gɛko mɛ kya terɛ gɛmɔ yɛɛ miira kyu saarɛ nta dɔ sa Yesu yɛɛ oꞌ nun, ne o kine. ");
INSERT INTO acd_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Nfono mɔ, mɛ luu Yesu ngbɛ nbono o suu mɔ ne mɛ da mɔ aŋanbi mada de oyii mɔ. Ne mɛ yɛ mɔ-nyoro so atɔ kyu. Mɛ kya yɛ atɔ mɔ mɔ, mɛ too ilaa iko kerɛ. Ibono i yii de fo mɔ, fo kyu. ");
INSERT INTO acd_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Nyɛnyɛngɛ iwi sango ne mɛ da Yesu aŋanbi mada de oyii mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Mɛ ŋmarasɛ ilaa ibono so mɛ kyu bun mɔ gipuɛɛ mɔ mada mɔ-amu so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Mɛ da iyu inyɔ iko kee aŋanbi mada de iyii Yesu asɛ nfono, ɔko bo mɔ-gyisɛ gibaa so, ne ɔko bo mɔ-benɛ so.  ");
INSERT INTO acd_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Gɛnen ilaa idɛ i yɛgɛ ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ kyu lii Yesu so mɔ iꞌ ba gɛsintin. Mɛ ŋmarasɛ yɛɛ, “Mɛ laa kalɛ mɔ wɔra ilaa nyɛnyɛn awɔrabo dɔ.” ");
INSERT INTO acd_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Asa abono mɛ yelɛ mɛ kerɛ mɔ, mɛ kya tugi mɔ inosun, mɛ kya yoole mɔ yɛɛ, “Fo ne yɛɛ fo laa boori Wurubuaarɛ ɔson obu mɔ de foꞌ kyu nkɛ nsa kii yii mɔ mɔ? ");
INSERT INTO acd_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kii mɔlɛgɛ fo-nyoro! Kpelegɛ lii oyii mɔ so de aꞌ kerɛ!” ");
INSERT INTO acd_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Gɛnen kee ne Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔmɔ‑rɛ nbara aŋmarasɛbo mɔ mɛ yoole mɔ ne. Mɛ kya tɔgɛ ma‑a sa abara yɛɛ, “Mɔ ne n mɔlɛgɛ asa, ne ɔŋ kya taalɛ ɔꞌ mɔlɛgɛ mɔ-nyoro faa. ");
INSERT INTO acd_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Iŋ gyɛ mɔ ne Wurubuaarɛ gi sun yɛɛ ɔꞌ mɔlɛgɛ anyamesɛ mɔ? Iŋ gyɛ mɔ ne n gyɛ wura sa Isirale awura mɔ? Oꞌ kii kpelegɛ oyii baarɛ so de aꞌ kerɛ de aꞌ sɔɔ mɔ gyi.” Ne abono mɛ da mɔmɔ‑rɛ Yesu aŋanbi mɔ kee mɛ kya saalɛ mɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","I fo owi ken-ken gerɛ-gerɛ mɔ, i wɔra gibiri sirim gɛnen gɛsinkpan mɔ pɛwu so kaaborɛ owi gbaasɛ. ");
INSERT INTO acd_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Gɛnen owi gbaasɛ ɔbono mɔ, Yesu gi kpen ken-ken tɔgɛ mɔ-gɛdɛ dɔ yɛɛ, “Ilayi, Ilayi, lama sabakitani?” (Imɔ gɛsɛ ne n gyɛ yɛɛ, “Me-Wurubuaarɛ, me-Wurubuaarɛ, i wonɛ ne fo lɛɛ ansi taa me yɛgɛ gɛnen?”) ");
INSERT INTO acd_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Asa abono mɛ yelɛ nno mɔ ako mɛ nu mɔ asɛ mɔ, mɛ tɔgɛ sa abara yɛɛ, “Fɛꞌ nu! Ɔ kya terɛ Oloobu Ilaagya.” ");
INSERT INTO acd_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nfono mɔ ɔko gi selɛ kyu taatɔ dufu-dufu ɔko kyu kpaa nyise wɔra mɔmɔ-nta bonyansɛ nko dɔ, ne o kyu de gɛyabii diirɛ kpe Yesu gɛnɔ asɛ yɛɛ ɔꞌ kyogyoo. Ne kaasɛ mɔ gi kii tɔgɛ yɛɛ, “Fɛꞌ taa mɔ yɛgɛ de aꞌ kerɛ yɛɛ Ilaagya laa lii Wurubuaarɛ dɔ baa kpelegɛrɛ mɔ oyii mɔ so?” ");
INSERT INTO acd_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Nfono mɔ Yesu gi kpen ken-ken, ne ɔ lɛɛ ɔŋɛ. ");
INSERT INTO acd_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Yesu gi wuꞌ gɛnen mɔ, gikuru gibono gi tii Wurubuaarɛ tudɔ-lɛɛ obu belɛ mɔ gi kyan ginyɔ lii soso baa yii gɛsɛ kyim. ");
INSERT INTO acd_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Asogya mɔ ɔbelɛnsɛ yelɛ nfono mɔ‑rɛ Yesu ansi a kerɛ abara. O wu gɛnɔɔbono i ba ne Yesu gi kyu lɛɛ ɔŋɛ mɔ, ɔ tɔgɛ yɛɛ, “Gɛsintin, ɔnyen baarɛ tansi ɔ gyɛ Wurubuaarɛ mɔ-bi.” ");
INSERT INTO acd_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Akyii kee mɛ yelɛ gɛta-gɛta wu ilaa idɛ pɛwu. Mɔmɔ ako ne n gyɛ Mariya Magadalakyii, de Salome, de Mariya ɔbono ɔ gyɛ Gyeemesi ɔpiiasɛ de Gyosesi mɔmɔ-nyi mɔ. ");
INSERT INTO acd_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Aberɛ abono Yesu naa de Galeli gɛsinkpan so mɔ, mɔmɔ ne n buu mɔ mɛ kya kerɛ mɔ so. Akyii sakyɔ abono mɛ buu mɔ ba Gyɛrusalem mɔ kee mɛ bo mɔ-owuten mɔ nfono. ");
INSERT INTO acd_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Gɛnen gɛkaabono mɛ mɔɔ Yesu mɔ gɛ gyɛ abaala gɛkɛ sa Gyuda awura. Mɛ kya baala ma‑a gyoo mɔmɔ-gɛkɛ kyoolasɛ. Imɔso i kya fo gɛdɔɔdɛ mɔ, ");
INSERT INTO acd_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ɔnyen ɔko gi da otu kpe Ɔbelɛnsɛ Pilato asɛ kpaa tɔgɛ mɔ yɛɛ ɔꞌ yɛgɛ mɔ de ɔꞌ kpaa saga Yesu gibuni mɔ kpaa pule. Mɛ kya terɛ ɔnyen ɔbono yɛɛ Gyosɛfo. Ɔ lii Arimatiya ɔsowolɛ so. Ɔ gyɛ nyamesɛ gbaaꞌ Gyuda awura nbɛlɛ agyibo mɔ dɔ, ne mɔ-gisen dɔ mɔ, mɔ-ansi a gyan gɛkaabono asa mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ so. ");
INSERT INTO acd_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ɔbelɛnsɛ Pilato gi nu yɛɛ Yesu gi wuꞌ belen gɛnen mɔ, i dɛ mɔ-gɛnɔ. Imɔso ɔ terɛ asogya ɔbelɛnsɛ mɔ, ne ɔ taasɛ mɔ yɛɛ, “I gyɛ gɛsintin yɛɛ Yesu gi ti wuꞌ?” ");
INSERT INTO acd_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ne asogya ɔbelɛnsɛ mɔ gi kyule yɛɛ, “Ɛn, Yesu gi ti wuꞌ.” Nfono mɔ, Pilato gi sa Gyosɛfo ɔkpa de ɔꞌ taalɛ kpaa saga Yesu gibuni mɔ kpaa pule. ");
INSERT INTO acd_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Gyosɛfo gi kpaa sɔɔ gikɛlɛlɛ ne ɔ baa saga Yesu gibuni mɔ lii oyii mɔ so, ne o kyu gikɛlɛlɛ mɔ kyu mili mɔ pɛwu. Ɔ mili mɔ ta mɔ, o kyu obuni mɔ kpaa pule folɛbɔ ɔbono mɛ wolaa logedi yela sa ibuni gipule mɔ dɔ. Ne ɔ belen gibui kpaatakpɛrɛ baa tii folɛbɔ mɔ gɛbunono. ");
INSERT INTO acd_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mariya Magadalakyii mɔ de Mariya, Gyosesi mɔ-nyi mɔ, mɛ bo nno mɛ kperɛ mɔmɔ-ansi kpaa wu Yesu opuleten. ");
INSERT INTO acd_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Gyuda awura gɛkɛ kyoolasɛ mɔ gɛ kyon mɔ, Mariya Magadalakyii mɔ de Mariya, Gyeemesi mɔ-nyi, de Salome mɛ kpaa sɔɔ ilaa iko i dɛ fɛɛ atikee. Mɛ laa kyu kpe folɛbɔ mɔ dɔ de mɛꞌ kyu kpaa bɔ Yesu gibuni mɔ. ");
INSERT INTO acd_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Gɛkɛ kyoolasɛ mɔ gɛdɛ kɛsɛ mɔ, i gyɛ Kosida. Imɔ nyɛnyɛngɛ fu‑u mɔ, gɛnen akyii adɛ mɛ puru ilaa ibono mɛ kpaa sɔɔ mɔ, ne owi mɔ‑rɛ mɔ-gibalii mɔ, mɛ ba Yesu opuleten mɔ. ");
INSERT INTO acd_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mɛ kya kpe mɔ, mɛ kya taasɛ abara yɛɛ, “Anɛ ne a laa nyɛ de ɔꞌ belen gibui mɔ lii folɛbɔ mɔ gɛbunono sa aye ne?” ");
INSERT INTO acd_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mɛ baa diirɛ ansi kerɛ mɔ, gibui kpaatakpɛrɛ mɔ gi dɛ nkan, giŋ baa gi tii folɛbɔ mɔ gɛbunono. ");
INSERT INTO acd_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Mɛ loo folɛbɔ mɔ dɔ mɔ, mɛ baa kerɛ mɔ, mɛ wu dega ɔko tɛ de gyisɛ so, o suu gɛgbɛ fufuli wurugakyaa. Akyii mɔ mɛ wu dega mɔ, i ŋmaa mɔmɔ-gisen. ");
INSERT INTO acd_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne ɔ tɔgɛ mɔmɔ yɛɛ, “Fɛŋꞌ yɛgɛ fɛye-gisen giꞌ ŋmaa fɛye. Iŋ gyɛ Yesu Nasarɛtɛnyen ɔbono mɛ da mɔ aŋanbi oyii so mɔɔ mɔ ne fɛ kya laarɛ faa? O kyingi lii ibuni dɔ. Ɔŋ baa ɔ bo gɛrɛnaa. Fɛꞌ kerɛ. Nfono nkana mɔ-gibuni mɔ gi dɛ mɔ ne. ");
INSERT INTO acd_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Imɔso fɛꞌ kpaa tɔgɛ Piita mɔ‑rɛ Yesu akasɛbo sɛnsɛ mɔ yɛɛ ɔ gyangbara mɔmɔ kyon Galeli. Nno ne mɛ laa kii wu mɔ fɛɛ gɛnɔɔbono ɔ wolaa tɔgɛ mɔmɔ yela mɔ.” ");
INSERT INTO acd_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nfono mɔ akyii mɔ mɛ lii ɔbɔ mɔ dɔ selɛ kyon. I dɛ mɔmɔ-gɛnɔ, ne mɔmɔ-nyoro gi kya da mɔmɔ. I wɔra mɔmɔ gifuu so mɔ, mɛŋ tɔgɛ sɛi sa ɔko‑rɛ ɔko.  ");
INSERT INTO acd_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Kosida gɛkɛ mɔ Yesu gi kyingi lii ibuni dɔ mɔ, imɔ nyɛnyɛngɛ fu‑u mɔ, ɔ daa gilɛɛ mɔ-nyoro nyiile daa Mariya Magadalakyii mɔ. (Mɔ ne n gyɛ ɔkyii ɔbono fɛ nu yɛɛ Yesu gi naa kyena gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi sono koso mɔ so mɔ.) ");
INSERT INTO acd_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Yesu gi lɛɛ mɔ-nyoro nyiile mɔ gɛnen mɔ, ɔkyii mɔ gi naa kpe abono nkana mɛ buu Yesu mɔ asɛ. Ɔ baa kpe mɔ, mɛ kya su, mɛ kya nyingi Yesu. O buu sa mɔmɔ ");
INSERT INTO acd_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","yɛɛ o wu Yesu tɛ nkpa. O buu sa mɔmɔ gɛnen mɔ, mɛ mɛŋ sɔɔ imɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Imɔ gɛmara mɔ, Yesu mɔ-nanboana anyɔ ako mɛ lii ɔsowolɛ belɛ ɔko so mɛ kya kpe gɛtɛɛko. Mɛ naa mɛ kya kpe mɔ, Yesu gi baa lɛɛ mɔ-nyoro nyiile mɔmɔ. Gɛnɔɔbono ɔ kyɛɛgɛ mɔ, mɛ mɛŋ bii mɔ belen. ");
INSERT INTO acd_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Ɔ lɛɛ mɔ-nyoro nyiile mɔmɔ gɛnen mɔ, mɛ kii kpe ɔsowolɛ belɛ mɔ so kpaa buu sa mɔmɔ-nanboana asɛnsɛ mɔ. Mɔmɔ-nanboana mɔ berɛ mɛ mɛŋ sɔɔ imɔ gyi. ");
INSERT INTO acd_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Yesu akasɛbo gudu ɔko mɔ mɛ tɛ mɛ kya gyi mɔ, Yesu gi kpaa lɛɛ mɔ-nyoro nyiile mɔmɔ. Ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ bo akyɔɔlɛ ne fɛŋ kya sɔɔ ilaa gyi gɛnen? I kya nyiile yɛɛ asa mɛ wu me nɛ kyingi lii ibuni dɔ ne mɛ baa buu sa fɛye mɔ, fɛ mɛŋ sɔɔ mɔmɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kpe gɛsinkpan gɛten kamaasɛ so de fɛꞌ kpaa tɔgɛ me-ɔkalan konkonsɛ mɔ sa nyamesɛ kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɔbono ɔ sɔɔ ɔkalan mɔ gyi ne fɛ gyere mɔ Wurubuaarɛ sagyere mɔ, Wurubuaarɛ laa mɔlɛgɛ mɔ de ɔꞌ nyɛ kyena mɔ asɛ gɛkpaa-gɛkpaa. Ɔbono mɔ, ɔ mɛŋ sɔɔ ɔkalan mɔ gyi mɔ, Wurubuaarɛ laa bun mɔ gipuɛɛ. ");
INSERT INTO acd_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Abono mɛ sɔɔ me-ɔkalan konkonsɛ mɔ gyi mɔ, mɛ laa wɔra ilaa gbaaꞌgbaa ibono nkana nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so mɔ. Imɔ ne n gyɛ yɛɛ mɛ laa kyu me Yesu ginyen gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so; mɛ laa dalaa de ndɛ nbono mɛŋ wolaa mɛ kya nu mɔ; ");
INSERT INTO acd_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","mɛ laa keda awɔɔ de abaa ne mɛ laa nun gibɔrɔ kamaasɛ, i maŋ wɔra mɔmɔ sɛi. Mɛ laa kyu mɔmɔ-abaa gyan alɔbo so, de mɔmɔ-alɔbi mɔ aꞌ ta.” ");
INSERT INTO acd_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wura Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ gɛnen ta mɔ, i puru mɔ kyon Wurubuaarɛ dɔ, ne o kpe ɔ tɛ Wurubuaarɛ gibaa gyisɛ so ɔ kya gyi gɛwura. ");
INSERT INTO acd_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Yesu akasɛbo mɔ, mɔ, mɛ naa kpe gɛten kamaasɛ mɛ kya tɔgɛ mɔ-ɔkalan konkonsɛ mɔ ma‑a sa asa, ne Wura Yesu gbaa-gbaa gi naa de mɔmɔ so wɔra ilaa gbaaꞌgbaa de iꞌ lɛɛ nyiile asa yɛɛ mɔ-ɔkalan mɔ gyɛ gɛsintin.");
INSERT INTO acd_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Ɔbelɛnsɛ Tiyofilo, fo wolaa fo nyi yɛɛ asa sakyɔ mɛ kyu too mɔmɔ-nyoro so yɛɛ mɛ laa tɔɔsɛ ilaa ibono Yesu gi wɔra aye dɔ mɔ de mɛꞌ ŋmarasɛ imɔ yela. ");
INSERT INTO acd_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Mɛ ŋmarasɛ imɔ yela de iꞌ kyu kyena gɛnɔ kolon fɛɛ gɛnɔɔbono asa ako mɛ wu tɔgɛ mɔ. Gɛnen asa abono berɛ ne n wu Yesu ilaa wɔrasɛ de mɔmɔ-ansi lii gɛsɛ de gɛsɛ ne mɛ naa wɔra Yesu agyɛbi mɔ so gɛsun. ");
INSERT INTO acd_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Me kee, fɛɛ gɛnɔɔbono aŋmarasɛbo mɔ mɛ ŋmarasɛ mɔ, n wolaa mi‑i laarɛ Yesu gɛkyena dɔ ilaa mɔ dɔ dɔɔdan lii imɔ gɛsɛ de gɛsɛ. Ɔbelɛnsɛ Tiyofilo, nɛ laarɛ imɔ dɔ wu mɔ, nɛ wɔra me-gɛwɔnsa yɛɛ me kee, nan ŋmarasɛ imɔ so ilaa gigyan so gigyan so sa fo ");
INSERT INTO acd_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","de foꞌ nyɛ bii gɛsintin kyu lii ilaa ibono fo nu mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Owi ɔbono Hɛrodɛ kya gyi gɛwura Gyudiya gɛsinkpan so mɔ, Gyuda awura asunbi alɛɛbo mɔ dɔ ɔko bo no, mɛ kya terɛ mɔ-ginyen yɛɛ Sakariya. Asunbi alɛɛbo akpen mɔ dɔ mɔ, Sakariya gyɛ Oloobu Abigya-lɛɛ gikpen dɔ. Mɛ kya terɛ mɔ-ka yɛɛ Elisabɛtɛ. Mɔ kee gyɛ Gyuda awura asunbi alɛɛbo gɛsu dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Sakariya mɔ‑rɛ mɔ-ka mɛ kya gyi gɛsintin sa Wurubuaarɛ. Mɛ kya gyi mɔ-nbara so, ne mɛ kya wɔra itiibilaa pɛwu imɔ-ikpa so. ");
INSERT INTO acd_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Imɔ gɛnen mɔ, mɛ mɛŋ nyɛ gɛkorogɛ. Elisabɛtɛ gyɛ daa ɔlabanbo, ne mɔmɔ anyɔ mɛ ti mɛ kya belɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Owi ɔko dɔ mɔ, i tu Sakariya-lɛɛ gikpen dɔ awura yɛɛ mɔmɔ ne mɛꞌ wɔra asunbi ilaa sa Wurubuaarɛ. Imɔso gɛkɛ gɛdɛ mɛ kya wɔra Wurubuaarɛ ɔson ilaa ");
INSERT INTO acd_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","fɛɛ gɛnɔɔbono Gyuda awura asunbi alɛɛbo mɔ mɛ kya wɔra mɔ, mɛ too ilaa iko kerɛ de mɛꞌ wu ɔbono ɔ laa loo Wurubuaarɛ ɔson obu mɔ dɔ kpaa dɛɛ onufuii de iꞌ wɔra ofen mɔ. Mɛ too imɔ kerɛ gɛnen mɔ, i baa yii daa de Sakariya. ");
INSERT INTO acd_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Imɔso mɛ kya son mɔ, i fo onufuii adɛɛberɛ mɔ, ɔ loo ɔson obu mɔ dɔ, yɛgɛ sakpii mɔ pɛwu yelɛ nŋmaŋman mɛ kya dalaa. ");
INSERT INTO acd_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ɔ bo obu mɔ dɔ mɔ, Wurubuaarɛ dɔ ɔsɔɔ ɔko gi ba mɔ asɛ baa yelɛ Wurubuaarɛ onufuii ɔdɛɛten mɔ gyisɛ so. ");
INSERT INTO acd_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakariya gi wu mɔ gɛnen mɔ, i ŋmaa mɔ-gisen ne i wɔra mɔ gifuu. ");
INSERT INTO acd_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ sa mɔ yɛɛ, “Sakariya, gɛŋ sa foꞌ yɛgɛ iꞌ wɔra fo gifuu. Wurubuaarɛ gi nu fo-gɛdalaa. Fo-ka Elisabɛtɛ laa korogɛ gɛbii nyensɛɛ sa fo. Yela mɔ-ginyen yɛɛ Gyɔn. ");
INSERT INTO acd_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","I laa wɔra fo-gisen dɔ ɔkon gikyɔ. Asa sakyɔ kee mɛ laa gyi ɔkon yɛɛ i korogɛ gɛnen gɛbii gɛbono. ");
INSERT INTO acd_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Ɔ laa baa wɔra nyamesɛ gbaaꞌ sa Wurubuaarɛ. Nta ne n gyɛ nta gi maŋ yii mɔ-gɛnɔ. Wurubuaarɛ Oduduu mɔ laa suu de mɔ lii ko‑o mɔ-nyi ɔtɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Ɔ laa yɛgɛ fɛye-Isirale awura sakyɔ mɛꞌ kii ba mɔmɔ-Wura Wurubuaarɛ asɛ baa son mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Pɛi ne Wurubuaarɛ laa ba mɔ-adɛ asɛ mɔ, Gyɔn baarɛ laa kyu oduduu de ɔlon belɛ fɛɛ Oloobu Ilaagya-lɛɛ mɔ ɔnan gyangbara mɔ. Ɔ laa lɔrɔ nbii de asɛ nsana. Ɔ laa yɛgɛ abono mɛ bo gisomaanu sa Wurubuaarɛ mɔ mɛꞌ bii ɔlaako fɛɛ abono mɛ kya gyi gɛsintin sa mɔ mɔ. Ɔ laa lɔrɔ Wurubuaarɛ adɛ sa Wurubuaarɛ de mɛꞌ wɔra asa abono mɛ baala mɔmɔ-nyoro yela mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ gɛnen ta mɔ, Sakariya gi taasɛ mɔ yɛɛ, “Nnɛ ne nan wɔra de nꞌ bii yɛɛ gɛnen ilaa ibono fo tɔgɛ faa i laa ba gɛsintin? N gyɛ daa ɔnyen belɛnsɛ ne me-ka kee gi belɛ.” ");
INSERT INTO acd_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Nfono mɔ Wurubuaarɛ dɔ ɔsɔɔ mɔ gi lɛɛ gɛnɔ yɛɛ, “Me ne n gyɛ Gaberiyɛlɛ. Me‑rɛ Wurubuaarɛ ne owi kamaasɛ dɔ. Mɔ ne n keda me sun fo asɛ yɛɛ nꞌ baa tɔgɛ fo gɛnen ɔkalan konkonsɛ baarɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Sɔɔ gibui yela. Fo maŋ baa tɔngɛ. Fo laa bingiri omuumuu kaaborɛ gɛnen ilaa idɛ i laa ba gɛsintin. I kya nyiile yɛɛ ilaa ibono nɛ tɔgɛ sa fo mɔ fo mɛŋ sɔɔ imɔ gyi. Owi mɔ gi fo mɔ, i laa ba gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Gɛnen owi ɔbono pɛwu mɔ asa abono mɛ bo nŋmaŋman mɔ mɛ gyoo Sakariya mɛ kya kpon. I dɛ mɔmɔ-gɛnɔ yɛɛ ɔ kɛɛla Wurubuaarɛ ɔson obu mɔ dɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Owi ɔbono ɔ kpaa lii ba mɔ, ɔŋ baa ɔ taalɛ ɔꞌ tɔngɛ. Nfono mɔ, mɛ bii ibono o wu ilaa iko lii Wurubuaarɛ asɛ Wurubuaarɛ ɔson obu mɔ dɔ. Mɔ-abaa ne ɔ san ɔ dɛ ɔ kya kaala. O bingiri omuumuu. ");
INSERT INTO acd_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Sakariya-lɛɛ owi ɔbono ɔ kya kyu wɔra asunbi ilaa sa Wurubuaarɛ mɔ gi logɛ mɔ, o kii kyon mɔ-ɔsowolɛ so. ");
INSERT INTO acd_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Imɔ gɛmara mɔ, mɔ-ka Elisabɛtɛ gi da ɔtɔ. Ɔ da ɔtɔ mɔ, ɔ mɛŋ kyule lii gikpaara so gɛnen‑n ibosɛ inun. Ɔ kya tɔgɛ ɔ kya sa mɔ-nyoro yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Kerɛ ilaa ibono Wurubuaarɛ gi wɔra sa me! Idɛ berɛ, o nyingi me so yɛɛ ɔ laa dengɛ me-ansi ipeeli me-nanboana dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Elisabɛtɛ ɔtɔ ibosɛ isee dɔ mɔ, Wurubuaarɛ gi sun mɔ-ɔsɔɔ Gaberiyɛlɛ lii Wurubuaarɛ dɔ kpe Nasarɛtɛ ɔsowolɛ so Galeli gɛsinkpan so yɛɛ oꞌ kpe obolonbu ɔko asɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Obolonbu mɔ mɛŋ ti taa bii ɔnyen. Ɔnyen ɔko ne n kya yɛ mɔ, mɛ kya terɛ mɔ yɛɛ Gyosɛfo. Ɔ gyɛ Oloobu Deefidi gɛsu dɔ. Obolonbu mɔ ginyen ne n gyɛ Mariya. ");
INSERT INTO acd_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Imɔso Wurubuaarɛ dɔ ɔsɔɔ mɔ gi ba Mariya baarɛ asɛ baa faala mɔ ne ɔ tɔgɛ sa mɔ yɛɛ, “Omudɛnsɛbo! Wurubuaarɛ yelɛ fo-gɛmara.” ");
INSERT INTO acd_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Wurubuaarɛ dɔ ɔsɔɔ mɔ ilaa tɔgɛsɛ mɔ i wɔra Mariya gɛwɔnsa gikyɔ. Ɔ san ɔ kya taasɛ mɔ-nyoro yɛɛ, “Menɛ afaala ɔnan ne?” ");
INSERT INTO acd_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Nfono mɔ, Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ mɔ yɛɛ, “Mariya, gɛŋ yɛgɛ iꞌ wɔra fo gifuu. Wurubuaarɛ gibaa gi gyan fo so. ");
INSERT INTO acd_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nu yɛɛ fo laa nyɛ ɔtɔ de foꞌ korogɛ ɔnyen. Yela mɔ-ginyen yɛɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ɔ laa wɔra nyamesɛ gbaaꞌ ne mɛ laa terɛ mɔ yɛɛ Gitɔbelɛ mɔ-bi. Wura Wurubuaarɛ laa kyu mɔ-naana Oloobu Deefidi gɛwuragyi mɔ sa mɔ ");
INSERT INTO acd_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","de oꞌ gyi gɛwura Oloobu Gyeekɔpo gɛsu pɛwu so gɛkpaa-gɛkpaa. Mɔ-gɛwuragyi gɛ maŋ ta ɔkara.” ");
INSERT INTO acd_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ gɛnen ta mɔ, Mariya gi taasɛ mɔ yɛɛ, “Nnɛ so ne i laa ba gɛnen? Meŋ ti bii ɔnyen kerɛ.” ");
INSERT INTO acd_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi lɛɛ gɛnɔ yɛɛ, “Wurubuaarɛ Oduduu laa ba fo so. Gitɔbelɛ mɔ ɔlon laa baa bun fo so. Gɛnen so mɔ mɛ laa terɛ gɛbii gɛbono fo laa baa korogɛ faa yɛɛ Wurubuaarɛ-lɛɛ, Wurubuaarɛ mɔ-bi. ");
INSERT INTO acd_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nu yɛɛ fo-subu Elisabɛtɛ kee gi nyɛ ɔtɔ mɔ-gikyiibelɛnsɛ gidɛ dɔ. Mɔ ɔbono nkana mɛ kya terɛ mɔ yɛɛ ɔlabanbo mɔ, mɔ-ɔtɔ mɔ ibosɛ isee ne. Mɔ kee laa korogɛ ɔnyen. ");
INSERT INTO acd_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","I kya nyiile yɛɛ sɛi mɛŋ bo no i don Wurubuaarɛ giwɔra.” ");
INSERT INTO acd_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ gɛnen ta mɔ, Mariya gi lɛɛ gɛnɔ yɛɛ, “Yo, nɛ nu. N tɛ sa daa Wurubuaarɛ. Iꞌ ba sa me fɛɛ gɛnɔɔbono fo tɔgɛ faa.” Nfono mɔ Wurubuaarɛ dɔ ɔsɔɔ mɔ gi lii kyon taa Mariya yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Gɛnen nkɛ nbono dɔ mɔ, Mariya gi koso kyon belen-belen kpe Gyudiya gɛsinkpan so abii dɔ ɔsowolɛ ɔko so. ");
INSERT INTO acd_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ɔ fo nno mɔ, ɔ naa loo Ɔbelɛnsɛ Sakariya gɛten dɔ kpaa faala mɔ-ka Elisabɛtɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Elisabɛtɛ gi kpɛ nu Mariya afaala de mɔ-aso mɔ, gɛbii mɔ gɛ kisee gikolon Elisabɛtɛ ɔtɔ dɔ. Ayaa abono so mɔ, Wurubuaarɛ Oduduu gi baa suu de Elisabɛtɛ, ");
INSERT INTO acd_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ne o bugi gɛnɔ tɔgɛ Wurubuaarɛ ilaa ken-ken sa Mariya yɛɛ, “Akyii dɔ pɛwu mɔ, fo ne Wurubuaarɛ gi yuule, ne gɛbii gɛbono fo laa korogɛ mɔ, Wurubuaarɛ ayuule a bun gɛmɔ so. ");
INSERT INTO acd_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Fo ɔbono fo laa wɔra me-ɔmɔlɛgɛbo de me-wura mɔ-nyi mɔ ne n naa de fo-ayaa baa laa me ɔdɛ faa? ");
INSERT INTO acd_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Kerɛ! Nɛ kpɛ nu fo-afaala mɔ, ayaa abono so mɔ, gɛbii gɛbono gɛ bo me-ɔtɔ dɔ mɔ gɛ kyu ɔkon kisee. ");
INSERT INTO acd_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Fo ɔkyii baarɛ, ibono fo sɔɔ gyi yɛɛ ɔkalan ɔbono Wurubuaarɛ gi sa fo mɔ laa ba gɛsintin faa, Wurubuaarɛ ayuule a gyɛ fo-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Mariya gi tɔgɛ yɛɛ, “N kya yen me Wura Wurubuaarɛ lii me-gisen dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Wurubuaarɛ, me-ɔmɔlɛgɛbo mɔ so mɔ, ɔkon bɔla me-gisen dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Me, Wurubuaarɛ obolonbu ɔbono meŋ bo gikɔ dɔ mɔ, me-ilaa i tiri Wurubuaarɛ ne ɔ kalɛ me wɔra asa dɔ. Lii ndɛ kyu kyon mɔ, nyamesɛ kamaasɛ ɔbono i korogɛ mɔ mɔ laa san terɛ me yɛɛ Omudɛnsɛbo. ");
INSERT INTO acd_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Gɛsintin, Wurubuaarɛ ɔbono ɔ gyɛ Ɔlolonbo mɔ gi wɔra ilaa gbaaꞌ sa me. Mɔ ne n gyɛ Gisen Fuuli Wura. ");
INSERT INTO acd_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Asa abono mɛ selɛ Wurubuaarɛ mɔ, Wurubuaarɛ laa kpɛ ɔ kya su mɔmɔ gitolon san sa abi san sa anaana. ");
INSERT INTO acd_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Wurubuaarɛ laa lɛɛ mɔ-ɔlon belɛ nyiile. Abono mɛ kya diirɛ mɔmɔ-nyoro mɔ, ɔ laa bara mɔmɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ɔ laa kyigi awura mɔmɔ-ngyapaa so de ɔꞌ diirɛ abono mɛ mɛŋ bo gikɔ dɔ mɔ loo asa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Abono mɛŋ bo sɛi mɔ ɔ laa kyu ilaa dɛnsɛ kyu kyɛɛ ɔmɔ de iꞌ tɔrɔ ɔmɔ-asen. Aterenbi awura berɛ, ɔ laa lɛɛ ɔmɔ-ɔkpa abaa gudu, ayaa gudu. ");
INSERT INTO acd_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Ɔ laa lɛɛ mɔ-gitolon gibono ɔ bo mɔ nyiile de ɔꞌ kpaa aye Isirale awura abono a gyɛ mɔ-asonbo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Ɔ laa kpaa Isirale fɛɛ gɛnɔɔbono ɔ wolaa ka yela sa aye-naanaana agyangbarasɛ mɔ. Ɔ ka yɛɛ ɔ laa su Oloobu Aberaham mɔ‑rɛ mɔ-naana naanaana pɛwu so gɛkpaa-gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Mariya gi ba Elisabɛtɛ asɛ gɛnen mɔ, ɔ kyena nno fɛɛ ibosɛ isaꞌ pɛi ne ɔ lɔɔ kii gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Elisabɛtɛ owi korogɛsɛ gi fo mɔ, ɔ korogɛ ɔnyen. ");
INSERT INTO acd_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Ɔ korogɛ mɔ, mɔ-nanboana de mɔ-subuana mɛ nu yɛɛ Wurubuaarɛ gi tansi su mɔ gitolon, ne mɛ gyi ɔkon kpaa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Mɔ-gɛkorogɛ mɔ nkɛ gukue gɛmara mɔ, mɛ ba de mɛꞌ baa ten kyokyoo mɔ giwɔrɛ de mɛꞌ yela mɔ-ginyen fɛɛ gɛnɔɔbono mɔmɔ-itiibilaa i kya nyiile mɔ. Nkana mɛ kya laarɛ de mɛꞌ kyu mɔ-sɛ Sakariya ginyen kyu yela mɔ, ");
INSERT INTO acd_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ne kyokyoo mɔ mɔ-nyi gi kine yɛɛ, “Kuaa. A laa terɛ mɔ yɛɛ Gyɔn.” ");
INSERT INTO acd_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Talabo mɔ gi tɔgɛ gɛnen mɔ, asa mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Fɛye-gɛsu dɔ mɔ, mɛ mɛŋ ti yela ɔko‑rɛ ɔko ginyen gidɛ.” ");
INSERT INTO acd_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Nfono mɔ mɛ kaala abaa dɔ kyu taasɛ kyokyoo mɔ mɔ-sɛ de mɛꞌ bii ginyen gibono ɔ kya laarɛ mɛꞌ terɛ gɛbii mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Mɛ kaala nyiile mɔ gɛnen mɔ, ɔ taasɛ taatɔ ŋmarasɛsɛ so, ne ɔ ŋmarasɛ gyan yɛɛ, “Mɛꞌ terɛ mɔ yɛɛ Gyɔn.” Ɔ ŋmarasɛ gɛnen mɔ, i dɛ mɔmɔ pɛwu gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ayaa abono so mɔ, Sakariya gɛnɔ gɛ bugi ne o kii taalɛ ɔ kya tɔngɛ, ne o yii gɛsɛ ɔ kya yen Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Abono mɛ tɛ sindi mɔmɔ mɔ pɛwu mɛ nu imɔ mɔ, i wɔra mɔmɔ gifuu. Gɛnen ilaa idɛ pɛwu ne n san wɔra gɛsingyi gyisɛ sola kyon kpaa lii Gyudiya abii mɔ dɔ isowolɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ɔkamaasɛ ɔbono o nu ilaa ibono i ba mɔ pɛwu mɔ gi sa imɔ so nwɔnsa gikyɔ ne ɔ san ɔ kya taasɛ mɔ-nyoro yɛɛ, “Menɛ ne gɛbii gɛdɛ gɛ laa baa wɔra gɛkaako?” I kya nyiile yɛɛ mɛ wu ibono Wurubuaarɛ ɔlon bo mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wurubuaarɛ Oduduu mɔ gi suu de gɛbii mɔ mɔ-sɛ, Sakariya ne o wu Wurubuaarɛ ilaa tɔgɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Ayenbi a gyɛ sa Isirale awura wura, Wurubuaarɛ. Ɔ ba aye abono a gyɛ mɔ-adɛ mɔ asɛ de ɔꞌ lɛɛ aye lii ilaa nyɛnyɛn dɔ de aꞌ nyɛ kyena sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Ɔ laa bara aye ɔlolonbo de ɔmɔlɛgɛbo ɔko lii Deefidi ɔbono ɔ wɔra Wurubuaarɛ sonbo mɔ gɛsu dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ɔ wolaa tɔgɛ gɛnen ɔmɔlɛgɛbo baarɛ so ilaa yela lii ko‑o dedaa kyu naa de mɔ-ikalan atɔgɛbo abono ɔ lɔrɔ yela sa mɔ-gɛsun mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Wurubuaarɛ laa mɔlɛgɛ aye lii aye-akyobo asɛ. Ɔ laa sɔgɛ aye lii asa abono pɛwu mɛ mɛŋ kya laarɛ aye-ilaa mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ɔ laa mɔlɛgɛ aye gɛnen de oꞌ su aye gitolon fɛɛ gɛnɔɔbono ɔ ka yela sa aye-naanaana mɔ. Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa yɛgɛ aye‑rɛ mɔ aꞌ wɔra gɛnɔ pobɔrɔ. Ɔ maŋ lɛɛ ansi yɛgɛ gɛnen gɛnɔ pobɔrɔ gɛbono. ");
INSERT INTO acd_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Ɔ laa gyi ntan nbono ɔ ka yela sa aye Gyuda awura ɔnaana gyangbarasɛ, Aberaham, mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Ɔ ka ntan mɔ yɛɛ ɔ laa sɔgɛ aye lii aye-akyobo abaa dɔ de ɔꞌ sa aye ɔkpa yɛɛ aꞌ son mɔ ibono a maŋ selɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","A laa kyu gisen fufuli de gɛsintin son mɔ aye-nkɛ ɔkara. ");
INSERT INTO acd_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Me-bi, fo‑o fo mɔ, mɛ laa terɛ fo yɛɛ Gitɔbelɛ mɔ ikalan ɔtɔgɛbo. I kya nyiile yɛɛ fo laa gyangbara sa aye-Wura ɔbono ɔ laa mɔlɛgɛ aye mɔ de foꞌ lɔrɔ ɔkpa gyoo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Fo laa yɛgɛ mɔ-adɛ mɛꞌ nu mɔ-amɔlɛgɛ mɔ so yɛɛ ɔ laa kyu mɔmɔ-ilaa nyɛnyɛn kyu kyɛɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Aye-Wurubuaarɛ mɔ gyɛ otolonbo lii mɔ-gisen dɔ. Mɔ-gitolon mɔ so mɔ, ɔ laa yɛgɛ gɛdɛ dɛnsɛ gɛꞌ kɛ sa aye ");
INSERT INTO acd_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","de aye abono a tɛ gibiri dɔ ne a selɛ lɛwu mɔ, iꞌ nyɛ wu aye de aꞌ naa de gisen yuuli ɔkpa mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Gɛbii mɔ gɛ sɛɛ, ne ɔ nyɛ oduduu dɔ ɔlon. Ɔ san kyena daa gipen dɔ kpaa fo gɛkɛ gɛbono Wurubuaarɛ gi baa lɛɛ mɔ-gɛwi nyiile Isirale awura mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Owi ɔbono dɔ mɔ, Gyuda awura de asa oyuduu kpɛi-kpɛi mɛ tɛ sa daa Rom awura. Gɛnen nkɛ nbono dɔ mɔ i ba yɛɛ mɔmɔ Rom wura belɛ, Siisa Ɔgustusɛ, gi yela nbara sa ɔkamaasɛ yɛɛ ɔꞌ ŋmarasɛ mɔ-ginyen de mɛꞌ kalɛ abono pɛwu mɛ tɛ gɛsinkpan gɛbono so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Imɔ idɛ ne n gyɛ ibono i gyangbara yɛɛ mɛ kalɛ asa de mɛꞌ bii gɛsinkpan so asa gɛgyɔnɔ. I ba daa aberɛ abono Ɔbelɛnsɛ Kuriniyusɛ tɛ sa Rom abɛyin Siiriya gɛsinkpan so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Mɛ kya kalɛ asa gɛnen mɔ, ɔkamaasɛ gi kpe mɔ-gɛwi de ɔꞌ kpaa ŋmarasɛ mɔ-ginyen. ");
INSERT INTO acd_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Imɔso Gyosɛfo kee gi koso lii Nasarɛtɛ ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ, ne o kpe Gyudiya gɛsinkpan so de ɔꞌ kpaa ŋmarasɛ mɔ-ginyen Bɛtelɛhɛm ɔsowolɛ so nfono mɛ korogɛ mɔ-naana Oloobu Deefidi mɔ. I kya nyiile yɛɛ ɔ gyɛ daa Oloobu Deefidi gɛsu dɔ de mɔ-gɛten dɔ isa. ");
INSERT INTO acd_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Imɔso o kpe nno de mɛꞌ kpaa ŋmarasɛ mɔ‑rɛ mɔ-ka Mariya ɔbono ɔ kya yɛ mɔ ne Wurubuaarɛ gi yɛgɛ mɔ ɔ da ɔtɔ mɔ anyen. ");
INSERT INTO acd_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Mɛ bo Bɛtelɛhɛm nno mɔ, owi gi fo ibono Mariya laa korogɛ, ");
INSERT INTO acd_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ne ɔ korogɛ mɔ-bi gyangbarasɛ, gɛbii nyensɛɛ. O kyu ataaban mili mɔ ne o kyu mɔ diila nbuɛ ogyiten gidɛkaa dɔ. I kya nyiile yɛɛ mɛ mɛŋ nyɛ ɔkpa kpaa sogɛ asafo ɔlooten. Nno mɔ i ti bɔla. ");
INSERT INTO acd_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Gɛnen gɛsinkpan gɛbono so kee mɔ, isandɛ akparɛbo ako mɛ bo ndɔɔ dɔ mɛ kya dii ɔmɔ-nbuɛ gɛnyɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Mɛ bo nno gɛnen mɔ, Wurubuaarɛ dɔ ɔsɔɔ ɔko gi lii ɔmɔ so. Ɔsɔɔ mɔ gi lii ɔmɔ so gɛnen mɔ, Wurubuaarɛ nyisigyi gi baa ŋɛlegi kyaabɔɔ ɔmɔ. Mɛ wu gɛnen mɔ, i wɔra isandɛ akparɛbo mɔ gifuu gikyɔ kyɔde. ");
INSERT INTO acd_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","I wɔra ɔmɔ gifuu gɛnen mɔ, Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ sa ɔmɔ yɛɛ, “Fɛŋ sa fɛꞌ selɛ gifuu. N dɛ ɔkalan konkonsɛ mi‑i bara fɛye! Ɔkon belɛ ɔko kya ba. Ɔ kya ba daa sa anyamesɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Imɔ ne n gyɛ yɛɛ ndɛ gɛkɛ gɛdɛ Oloobu Deefidi ɔsowolɛ mɔ so mɔ, mɛ korogɛ ɔmɔlɛgɛbo. Mɔ ne n gyɛ Wura. Mɔ ne Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de ɔꞌ baa mɔlɛgɛ fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ilaa ibono i laa lɛɛ mɔ-gɛwi nyiile fɛye mɔ ne n gyɛ yɛɛ fɛ laa wu kyokyoo mɛ kyu ataaban kyu mili mɔ, ɔ dɛ nbuɛ ogyiten gidɛkaa dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ gɛnen mɔ, mɛ baa kerɛ mɔ, Wurubuaarɛ dɔ isɔɔ alolonbo gikpen belɛ ne n lii Wurubuaarɛ dɔ ba. Mɛ ba mɛ yelɛ ɔsɔɔ gyangbarasɛ mɔ asɛ mɛ kya yen Wurubuaarɛ mɛ kya tɔgɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Nyisigyi ɔꞌ wɔra Wurubuaarɛ-lɛɛ Wurubuaarɛ dɔ, de gɛsinkpan gɛdɛ so mɔ, gisen yuuli giꞌ wɔra abono mɛ kya gyi Wurubuaarɛ ginsi mɔ-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wurubuaarɛ dɔ isɔɔ mɔ mɛ naa taa ɔmɔ yɛgɛ kii kpe Wurubuaarɛ dɔ. Mɛ kyon mɔ, isandɛ akparɛbo mɔ mɛ kya tɔgɛ mɛ kya sa abara yɛɛ, “Aꞌ kpe Bɛtelɛhɛm de aꞌ kpaa kerɛ ilaa ibono i ba nno ne Wurubuaarɛ gi lɛɛ nyiile aye faa.” ");
INSERT INTO acd_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Ne gɛsintin mɛ yii ɔkpa kyon belen-belen. Mɛ kpe mɔ, mɛ kpaa wu Mariya mɔ‑rɛ Gyosɛfo. Ne mɛ wu kyokyoo mɔ dɛ nbuɛ ogyiten gidɛkaa mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mɛ wu mɔ gɛnen mɔ, mɛ buu ɔkalan ɔbono mɛ nu lii mɔ so mɔ sa mɔ-sɛ de mɔ-nyi. ");
INSERT INTO acd_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ne i dɛ abono pɛwu mɛ nu imɔ mɔ gɛnɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Mariya berɛ, gi kyu ilaa mɔ wɔra mɔ-gisen dɔ, ɔ kpɛ ɔ kya sa imɔ so gɛwɔnsa. ");
INSERT INTO acd_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Isandɛ akparɛbo mɔ, mɔ, mɛ kii kpe mɔmɔ-isandɛ mɔ asɛ mɛ kpɛ mɛ dɛ nyisigyi mɛ kya sa Wurubuaarɛ, mɛ kya yen mɔ kyu lii ilaa ibono pɛwu mɛ nu ne mɛ kpaa wu de mɔmɔ-ansi mɔ so. I kya nyiile yɛɛ mɛ kpaa wu ilaa kamaasɛ fɛɛ gɛnɔɔbono Wurubuaarɛ dɔ ɔsɔɔ mɔ gi wolaa tɔgɛ ɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Mariya gi korogɛ mɔ imɔ gɛkɛ kuesɛ mɔ, mɛ ten kyokyoo mɔ-giwɔrɛ. Mɛ wɔra kyokyoo mɔ itiibilaa idɛ gɛnen mɔ, mɛ yela mɔ-ginyen yɛɛ Yesu. Ginyen gidɛ ne Wurubuaarɛ dɔ ɔsɔɔ mɔ gi wolaa sa mɔ pɛi ne mɔ-nyi gi lɔɔ da mɔ-ɔtɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Imɔ idɛ gɛmara mɔ, owi mɔ gi fo ibono mɛ laa wɔra tiibi ilaa sa Mariya de iꞌ nyiile yɛɛ ɔ kɔ lii fɛɛ gɛnɔɔbono Oloobu Mosisi nbara mɔ gi kya nyiile sa atalabo mɔ. Imɔso mɛ kyu kyokyoo mɔ kpe mɔmɔ-ɔsowolɛ gɛmu Gyɛrusalem, kyon kpaa loo Wurubuaarɛ ɔson obu mɔ gikpaara so de mɛꞌ kyu mɔ kpaa wɔra Wurubuaarɛ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","(I kya nyiile yɛɛ Wurubuaarɛ nbara mɔ dɔ mɔ mɛ ŋmarasɛ yela sa Gyuda awura mɔ yɛɛ, “Gɛbii nyensɛɛ kamaasɛ gɛbono mɛ laa daa gikorogɛ mɔ mɛꞌ kyu gɛmɔ yɛɛ gɛ gyɛ Wurubuaarɛ-lɛɛ.”) ");
INSERT INTO acd_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Mɛ kpe Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so gɛnen mɔ, tiibi ilaa ibono mɛ laa wɔra sa talabo mɔ de ɔꞌ wɔra fɛɛ ɔ kɔ lii mɔ ne n gyɛ yɛɛ mɛ laa kyu abonbuɛ anyɔ abɛɛ gɛwi nbuii nko ɔnan nmɔ nnyɔ kpaa lɛɛ asunbi sa Wurubuaarɛ fɛɛ gɛnɔɔbono mɛ ŋmarasɛ yela Wurubuaarɛ nbara mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Gɛnen owi ɔbono mɔ, ɔnyen ɔko tɛ Gyɛrusalem ɔsowolɛ ɔbono so, mɛ kya terɛ mɔ-ginyen yɛɛ Simon. Ɔ gyɛ isa ɔbono ɔ selɛ Wurubuaarɛ ne ɔ kya gyi gɛsintin sa mɔ. Ɔnyen mɔ tɛ ɔ gyoo owi ɔbono Wurubuaarɛ laa mɔlɛgɛ Isirale awura de mɔmɔ-asen aꞌ tɔrɔ mɔmɔ mɔ. Wurubuaarɛ Oduduu bo mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Wurubuaarɛ Oduduu mɔ gi wolaa lɛɛ nyiile Simon baarɛ yɛɛ pɛi ne ɔ laa wuꞌ mɔ, gɛnen mɔ, oꞌ wu isa ɔbono Wura Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ mɔ Wurubuaarɛ adɛ mɔ de mɔ-ansi. ");
INSERT INTO acd_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Gɛkɛ gɛdɛ mɔ, Wurubuaarɛ Oduduu mɔ gi suu de Simon ne ɔ kparɛ mɔ kpe Wurubuaarɛ ɔson obu gikpaara mɔ so. Owi ɔbono Yesu mɔ-sɛ de mɔ-nyi mɛ kyu kyokyoo Yesu baa loo nno de mɛꞌ baa wɔra Wurubuaarɛ nbara tiibi ilaa sa mɔ mɔ, ");
INSERT INTO acd_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Simon gi wu mɔmɔ. O wu mɔmɔ mɔ, ɔ sɔɔ kyokyoo mɔ keda, ne ɔ yen Wurubuaarɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Me-Wurubuaarɛ, ɔbono ilaa kamaasɛ i bo daa fo-abaa dɔ, idɛ kon berɛ, fo laa taalɛ terɛ me de nꞌ ba fo asɛ de gisen yuuli fɛɛ gɛnɔɔbono fo wolaa tɔgɛ yela mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","I kya nyiile yɛɛ nɛ wu ɔbono fo sun de ɔꞌ baa mɔlɛgɛ asa mɔ de me-ansi. ");
INSERT INTO acd_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Amɔlɛgɛ abono fo baala fo laa lɛɛ nyiile asa kpɛi-kpɛi pɛwu mɔ, nɛ wu amɔ de me-ansi. ");
INSERT INTO acd_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Kyokyoo baarɛ laa baa wɔra fatela de ɔꞌ lɛɛ fo Wurubuaarɛ ilaa nyiile asa kpɛi-kpɛi abono mɛ mɛŋ nyi fo Wurubuaarɛ mɔ de oꞌ kyu nyisigyi kyu bara fo-adɛ Isirale awura.” ");
INSERT INTO acd_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Ilaa ibono Simon gi tɔgɛ kyu lii kyokyoo mɔ so gɛnen mɔ, i dɛ mɔ-sɛ de mɔ-nyi gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simon gi faala Wurubuaarɛ gɛnen mɔ, ɔ kolɛ Wurubuaarɛ ayuule bun mɔmɔ so ne ɔ tɔgɛ sa kyokyoo mɔ mɔ-nyi Mariya yɛɛ, “Fo wu fo-bi baarɛ? Ɔ paa ba yɛɛ ɔ laa yɛgɛ iꞌ diirɛ asa sakyɔ mɔmɔ-gɛkyena dɔ de asa sakyɔ mɔ kee mɛꞌ lii tɔrɔ mɔmɔ-gɛkyena dɔ Isirale gɛsinkpan gɛdɛ so. Ɔ paa ba yɛɛ ɔ laa wɔra ɔbono ɔ laa lɛɛ Wurubuaarɛ ilaa wɔrasɛ nyiile asa de mɛꞌ sɔɔ imɔ akyɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","I laa yɛgɛ asa nwɔnsa nbono mɛ dɛ mɔ giꞌ lii gɛwi. Fo, Mariya mɔ, fo-gisen dɔ i laa sogya fo fɛɛ gɛki ne mɛ yii fo.” ");
INSERT INTO acd_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Wurubuaarɛ ikalan ɔtɔgɛbo kyiisɛ ɔko kee bo nno. Mɛ kya terɛ mɔ-ginyen yɛɛ Ana. Ɔ wɔra ɔkyii belɛnsɛ. Mɔ-sɛ ginyen ne n gyɛ Fanuwɛlɛ, Akya gɛsu dɔ ne ɔ lii. Mɔ-gibolonbu dɔ mɔ, ɔ dena nsi sono ɔkara ne mɔ-kuli gi wuꞌ taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Mɔ-kuli gi wuꞌ mɔ, ɔŋ baa dena. Owi ɔbono mɛ kyu kyokyoo Yesu ba Wurubuaarɛ ɔson obu mɔ dɔ gɛnen mɔ, ɔkyii mɔ gi gyi nsi ikue-inan nsi nnan. Owi kamaasɛ dɔ mɔ ɔ kpɛ ɔ bo daa Wurubuaarɛ ɔson obu mɔ dɔ ɔ kya son Wurubuaarɛ ɔ kya ŋminde gɛnɔ, ɔ kya dalaa gɛnyɛ de gɛpɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Gɛnen ɔkyii belɛnsɛ baarɛ gi kpaa loo Wurubuaarɛ ɔson obu gikpaara mɔ so mɔ, i kpɛ kpaa gyangara owi ɔbono Gyosɛfo mɔ‑rɛ Mariya de kyokyoo mɔ mɛ bo nno mɔ. Mɛ kpaa gyan gɛnen mɔ, ɔkyii belɛnsɛ mɔ gi kyu afaala kyu sa Wurubuaarɛ ne o yii gɛsɛ ɔ kya tɔgɛ ilaa ibono kyokyoo mɔ laa baa wɔra mɔ ɔ kya sa asa. Ɔ tɔgɛ kyokyoo mɔ ilaa sa abono pɛwu mɛ kya kerɛ ɔmɔlɛgɛbo mɔ ɔkpa mɔ. Mɔmɔ-gɛwɔnsa gɛ gyan yɛɛ gɛnen kaasɛ ɔbono laa yɛgɛ Gyɛrusalem, mɔmɔ-ɔsowolɛ gɛmu mɔ, oꞌ nyɛ mɔ-nyoro lii mɔ-akyobo abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Yesu mɔ-sɛ de mɔ-nyi mɛ wɔra ilaa kamaasɛ logɛ fɛɛ gɛnɔɔbono Wurubuaarɛ nbara mɔ gi kya nyiile mɔ, mɛ kii kpe Galeli gɛsinkpan so ne mɛ kii kpe Nasarɛtɛ ɔsowolɛ ɔbono so mɛ tɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gɛbii mɔ gɛ sɛɛ ne gɛ wɔra ɔlon. Ɔlaako ginyi gi bɔla mɔ dɔ, ne Wurubuaarɛ gibaa gi gyan mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Gɛsi kamaasɛ dɔ mɔ owi ɔbono mɛ kya gyi mɔmɔ Gyuda awura Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ, Yesu mɔ-nyi de mɔ-sɛ mɛ kya kyena kpe Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Imɔso gɛsi gɛbono Yesu gi gyi nsi gudu nnyɔ mɔ, mɛ kyon kpe Gyɛrusalem de mɛꞌ kpaa gyi gɛkɛ belɛ mɔ fɛɛ gɛnɔɔbono mɔmɔ Gyuda awura mɛ kya wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Mɛ gyi gɛkɛ belɛ mɔ ta mɛ kya kii mɔ, Yesu berɛ, gi sii kyena Gyɛrusalem yɛgɛ mɔ-nyi de mɔ-sɛ mɛ mɛŋ bii. ");
INSERT INTO acd_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mɛ kyu imɔ yɛɛ ɔ bo mɔmɔ-gikpen gibono mɛ naa mɔ dɔ. Mɛ naa gɛkɛ mumuli toloowi pɛi ne mɛ lɔɔ laarɛ mɔ-gɛten mɔmɔ-subuana de mɔmɔ-kyɛmenɛana asɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mɛ mɛŋ wu mɔ. Gɛnen so mɛ kii kpe Gyɛrusalem mɛꞌ kpaa laarɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Mɛ kya laarɛ mɔ gɛnen mɔ, imɔ gɛkɛ sasɛ mɔ, mɛ kpaa wu mɔ Wurubuaarɛ ɔson obu gikpaara mɔ so. Ɔ tɛ Wurubuaarɛ nbara aŋmarasɛbo mɔ dɔ ɔ kya nu mɔmɔ asɛ, ne ɔ kya taasɛ mɔmɔ ilaa. ");
INSERT INTO acd_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Gɛnɔɔbono gɛbii mɔ gɛ kya nu gɛsɛ ne gɛ kya lɛɛ gɛnɔ mɔ i dɛ ɔkamaasɛ ɔbono ɔ kya nu mɔ asɛ mɔ gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Mɔ-nyi de mɔ-sɛ mɛ kpaa wu mɔ gɛnen mɔ, i dɛ ɔmɔ-gɛnɔ gikyɔ. Ne mɔ-nyi gi taasɛ mɔ yɛɛ, “Me-bi, menɛtɔ ne n wɔra ne fo wɔra aye gɛnen? Kerɛ gɛnɔɔbono me‑rɛ fo-sɛ a naa a kya yiyɛɛ a kya laarɛ fo a kya kpon mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Mɔ-nyi gi taasɛ mɔ gɛnen mɔ, Yesu gi kii taasɛ ɔmɔ daa yɛɛ, “Menɛ n wɔra ne fɛ naa fɛ kya laarɛ me? Fɛ mɛŋ nyi yɛɛ i kaaborɛ ɔfaanan n bo me-sɛ gɛten dɔ?” ");
INSERT INTO acd_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ɔ taasɛ mɔmɔ gɛnen mɔ, mɛ mɛŋ nu mɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Imɔ idɛ gɛmara mɔ Yesu gi buu mɔ-nyi de mɔ-sɛ lii ne mɛ kii kyon Nasarɛtɛ ɔsowolɛ so nfono mɛ tɛ mɔ. Mɔmɔ-gɛkyena dɔ mɔ, ɔ kya bara mɔ-nyoro gɛsɛ sa ɔmɔ. Mɔ-nyi gi kyu gɛnen ilaa idɛ pɛwu kyu wɔra mɔ-nwɔnsa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Yesu gi sɛɛ, ne mɔ-ɔlaako ginyi gi nyaakyɔ, ne o gyi Wurubuaarɛ de anyamesɛ pɛwu ginsi. ");
INSERT INTO acd_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","2","Owi ɔbono Tabiriyusɛ gyɛ Rom wura belɛ mɔ, imɔ nsi gudu nnun dɔ mɔ, Wurubuaarɛ gi tɔngɛ sa Gyɔn, Sakariya mɔ-bi. Gɛnen aberɛ abono mɔ, i bo abelɛnsɛ abono mɛ kya kerɛ Gyuda awura so sa Rom wura belɛ mɔ. Ɔbono ɔ kya kerɛ Gyudiya gɛsinkpan so mɔ ne n gyɛ Pontiyusɛ Pilato. Wura Hɛrodɛ ne n kya kerɛ Galeli so, ne mɔ-tedɛ Filipo gyɛ wura ɔ kya kerɛ Ituriya de Tirakonitɛ so. Wura Lisaniya mɔ ne n kya kerɛ Abelin gɛsinkpan so. Abono mɛ gyɛ Gyuda awura asunbi alɛɛbo gɛmu gɛnen owi ɔbono dɔ mɔ ne n gyɛ Anasɛ de Kayifasɛ. Gɛnen aberɛ abono dɔ mɔ Wurubuaarɛ gi tɔngɛ sa Gyɔn gipen dɔ. ");
INSERT INTO acd_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Wurubuaarɛ gi tɔngɛ sa Gyɔn gɛnen mɔ, Gyɔn gi naa gɛsinkpan gɛbono gɛ kyaabɔɔ Gyɔɔdan ɔbon mɔ ɔ kya tɔgɛ ɔ sa asa yɛɛ mɛꞌ nu mɔmɔ-nyoro gɛsɛ de mɛꞌ kyɛɛgɛ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ. Mɛ wɔra gɛnen mɔ, ɔ laa gyere mɔmɔ Wurubuaarɛ sagyere de iꞌ nyiile yɛɛ Wurubuaarɛ gi kyu mɔmɔ-ilaa nyɛnyɛn kyɛɛ ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Gyɔn naa ɔ kya tɔgɛ ilaa idɛ ɔ kya sa asa gɛnen mɔ, i kyena de ilaa ibono Wurubuaarɛ ikalan ɔtɔgɛbo Isaya gi wolaa wu tɔgɛ mɔ. Mɛ wolaa ŋmarasɛ Isaya agyɛbi abono yela ɔwolɛ dɔ yɛɛ, “Asa mɛ laa nu ɔko gigyɛbi gipen dɔ ɔ laa kpen ɔ kya tɔgɛ yɛɛ, ‘Fɛꞌ lɔrɔ fɛye-gɛkyena dɔ gyoo Wurubuaarɛ de ɔꞌ naa de ɔkpa ntintin ba fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Nfonoana i wɔra fɛɛ i bo igee mɔ Wurubuaarɛ laa yɛgɛ isɛ i dii bɔla imɔ. Ɔ laa yɛgɛ abii de nbiibi mɔ pɛwu giꞌ boori de giꞌ dɛ gitaga. Nfonoana i mɛɛ mɛɛ mɔ, ɔ laa yɛgɛ i laa kyirigi ne nfonoana i bo ibɔ logoto-logoto mɔ, Wurubuaarɛ laa waalɛ imɔ isɛ de iꞌ dii kyaga. ");
INSERT INTO acd_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Amɔlɛgɛ abono Wurubuaarɛ laa kyu mɔlɛgɛ anyamesɛ de iꞌ lɔrɔ mɔmɔ‑rɛ mɔ nsana mɔ, mɔmɔ pɛwu mɛ laa wu amɔ de ansi.’ ” ");
INSERT INTO acd_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Sakpii kya kpe Gyɔn asɛ de oꞌ gyere ɔmɔ Wurubuaarɛ sagyere mɔ, ɔ tɔgɛ sa ɔmɔ yɛɛ, “Fɛ dɛ daa fɛɛ awɔɔ abono a bo gibɔrɔ mɔ gikpen! Wurubuaarɛ ginyadon gɛkɛ mɔ gɛ kya ba. Ɔ laa biidɛ asa nyɛnyɛn pɛwu giso. Imɔso fɛye kee fɛ wu yɛɛ i kaaborɛ fɛꞌ selɛ lii Wurubuaarɛ ginyadon mɔ dɔ? ");
INSERT INTO acd_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Gɛnen berɛ mɔ, fɛꞌ wɔra ilaa wɔrasɛ ibono i laa lɛɛ nyiile yɛɛ fɛ nu fɛye-nyoro gɛsɛ gɛsintin mɔ daa. Fɛŋ sa fɛꞌ penɛ fɛye-nyoro yɛɛ ibono fɛ kpɛ nyɛ fɛ gyɛ Aberaham ɔpaa dɔ asa faa so mɔ, Wurubuaarɛ laa yɛgɛ kyɛɛ fɛye. Nꞌ tɔgɛ fɛye yɛɛ Wurubuaarɛ laa taalɛ yɛgɛ abui adɛ aꞌ bingiri Aberaham ɔpaa dɔ asa. ");
INSERT INTO acd_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Anyamesɛ mɛ dɛ fɛɛ iyii ibono Wurubuaarɛ gi duu mɔ. Oyii kamaasɛ ɔbono ɔŋ kya sɔrɔ abi mɔ, Wurubuaarɛ gi ti puru mɔ-gɛkyɔɔ ɔ laa ŋɛ mɔ too kyu kpaa wɔra ɔgya dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Gyɔn gi tɔgɛ sa sakpii mɔ gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Nnɛ ne a laa wɔra de iꞌ lɛɛ nyiile yɛɛ a kyɛɛgɛ?” ");
INSERT INTO acd_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ɔ lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛye abono fɛ bo ngbɛ nnyɔ-nnyɔ mɔ, fɛꞌ kyu gɛko-gɛko sa abono mɛ mɛŋ bo ba‑a gɛkolon mɔ. Ɔbono, mɔ, ɔ bo agyudɔ mɔ, mɔ kee ɔꞌ sa mɔ-nanbo ɔbono ɔ mɛŋ bo mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Lɛnpoo asɔɔbo ako kee mɛ saarɛ sakpii mɔ dɔ. Mɛ kpe Gyɔn asɛ yɛɛ oꞌ gyere ɔmɔ Wurubuaarɛ sagyere. Pɛi ne ɔ laa gyere mɔmɔ Wurubuaarɛ sagyere mɔ, mɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, nnɛ ne a laa wɔra de iꞌ lɛɛ nyiile yɛɛ a kyɛɛgɛ?” ");
INSERT INTO acd_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Lɛnpoo asɔɔbo mɔ mɛ taasɛ Gyɔn gɛnen mɔ, ɔ lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛ laa sɔɔ asa lɛnpoo mɔ, fɛŋ sa fɛꞌ sɔɔ mɔmɔ aterenbi de iꞌ don gɛnɔɔbono i kaaborɛ fɛꞌ sɔɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Asogya kee mɛ kpaa taasɛ mɔ yɛɛ, “Ne aye mɔ de‑e? Nnɛ ne a laa wɔra de iꞌ lɛɛ nyiile yɛɛ a kyɛɛgɛ?” Mɛ taasɛ Gyɔn gɛnen mɔ, ɔ lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛꞌ mɛŋ kyu fɛye-gisogya ɔlon ɔbono fɛ bo mɔ kyu sɔgɛ aterenbi lii ako asɛ abɛɛ fɛꞌ ŋaala mɔmɔ yɛɛ nengyene mɛ maŋ sa fɛye aterenbi mɔ, fɛ laa kyu mɔmɔ wɔra nbɛlɛ dɔ. Gikɔ gibono abɛyin kya ka fɛye mɔ, fɛꞌ yɛgɛ iꞌ gyi fɛye-ginsi.” ");
INSERT INTO acd_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gɛnen aberɛ abono mɔ asa nwɔnsa gi gyanꞌ daa yɛɛ ɔfaanan Gyɔn ne n gyɛ ɔbono Wurubuaarɛ yɛɛ ɔ laa sun de ɔꞌ baa mɔlɛgɛ ɔmɔ de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan mɔ. ");
INSERT INTO acd_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Lii gɛnen so mɔ, Gyɔn gi tɔgɛ sa ɔmɔ pɛwu yɛɛ, “Me, n dɛ daa nkyu n kya gyere fɛye Wurubuaarɛ sagyere. Ɔbono ɔ don me mɔ kya ba. Fɛɛ nꞌ ba gɛsɛ de nꞌ kyu mɔ-ayaawolɛ tolɛ mɔ-ayaa dɔ sa mɔ gbaa mɔ, meŋ fo. Gɛnen kaasɛ ɔbono mɔ, Wurubuaarɛ Oduduu de ɔgya ne ɔ laa kyu gyere fɛye Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Kaasɛ ɔbono gi ti baala de ɔꞌ baragɛ ilaa dɛnsɛ awɔrabo lii ilaa nyɛnyɛn awɔrabo dɔ. Ɔ laa kyu ilaa dɛnsɛ awɔrabo mɔ kpaa yela mɔ asɛ de ɔꞌ biidɛ ilaa nyɛnyɛn awɔrabo mɔ giso gɛkpaa-gɛkpaa. I laa wɔra fɛɛ gɛnɔɔbono mɛ kya fon ɔmɔlɔgɔ mɔ. Mɛ kya kyu ɔmɔlɔgɔ abi mɔ yela gɛten dɛnsɛ de mɛꞌ kyu afonfontɛɛ mɔ kpaa fuɛ de mɛꞌ yii amɔ ɔgya. Gɛnen ɔgya ɔbono mɛŋ kya nu giwuꞌ.” ");
INSERT INTO acd_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Gyɔn gi tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ sa sakpii mɔ, ne ɔ ka mɔmɔ kyu lii ilaa kpɛi-kpɛi gikyɔ so. ");
INSERT INTO acd_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Gɛnen aberɛ abono mɔ Gyɔn wolaa ɔ kya ka Wura Hɛrodɛ kee kyu lii ilaa nyɛnyɛn ibono ɔ kya wɔra mɔ pɛwu so. Imɔ iko ne n gyɛ yɛɛ Wura Hɛrodɛ gi sɔgɛ mɔ-tedɛ mɔ-ka Hɛrodiyasɛ kyu dena. Gyɔn mɔ gi nu gɛnen mɔ, ɔ tɔgɛ sa Wura Hɛrodɛ yɛɛ ibono ɔ wɔra faa, iŋ boran. Ɔ ka wura mɔ gɛnen mɔ, i loo wura mɔ, ");
INSERT INTO acd_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ne ɔ keda Gyɔn kpaa tii de obu. O tii Gyɔn de obu gɛnen mɔ, i yɛgɛ o kii lɔrɔ wɔra ilaa nyɛnyɛn bɔla ibono ɔ ti wolaa wɔra mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Mɛŋ ti keda Gyɔn tii de obu ne asa pɛwu mɛ kya ba mɔ asɛ de oꞌ gyere mɔmɔ Wurubuaarɛ sagyere ɔbon dɔ mɔ, o gyere Yesu kee Wurubuaarɛ sagyere. Ɔ gyere mɔ ta ne Yesu kya dalaa mɔ, Wurubuaarɛ dɔ i bugi. ");
INSERT INTO acd_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Nfono mɔ asa mɛ wu Wurubuaarɛ Oduduu mɔ gi kpelegɛ lii soso fɛɛ bonbuɛ baa gyanꞌ Yesu so, ne Wurubuaarɛ gi tɔngɛ lii soso yɛɛ, “Fo gyɛ me-bi. Fo-ilaa i bo me-gisen dɔ. Fo kya gyi me-ginsi.” ");
INSERT INTO acd_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Yesu gi gyi fɛɛ nsi oko de saalaa pɛi ne o yii gɛsɛ ɔ naa ɔ naa ɔ kya wɔra gɛsun gɛbono Wurubuaarɛ gi kyu wɔra mɔ-abaa dɔ mɔ. Asa mɛ nyi mɔ mɔ, mɛ nyi mɔ daa yɛɛ Gyosɛfo mɔ-bi. Gyosɛfo-lɛɛ mɔ-sɛ ne n gyɛ Heeli, ");
INSERT INTO acd_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Heeli mɔ-sɛ ne n gyɛ Matati, Matati mɔ-sɛ ne n gyɛ Lɛfi, Lɛfi mɔ-sɛ ne n gyɛ Mɛliki, Mɛliki mɔ-sɛ ne n gyɛ Gyanayi, Gyanayi mɔ-sɛ ne n gyɛ Gyosɛfo ɔko. ");
INSERT INTO acd_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Gɛnen Gyosɛfo ɔbono mɔ-sɛ ne n gyɛ Matatiya, Matatiya mɔ-sɛ ne n gyɛ Amɔsɛ, Amɔsɛ mɔ-sɛ ne n gyɛ Nahum, Nahum mɔ-sɛ ne n gyɛ Esili, Esili mɔ-sɛ ne n gyɛ Nagayi, ");
INSERT INTO acd_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagayi mɔ-sɛ ne n gyɛ Maati, Maati mɔ-sɛ ne n gyɛ Matatiya ɔko, Matatiya ɔbono mɔ-sɛ ne n gyɛ Semeyin, Semeyin mɔ-sɛ ne n gyɛ Gyoseki, Gyoseki mɔ-sɛ ne n gyɛ Gyoodɛ, ");
INSERT INTO acd_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Gyoodɛ mɔ-sɛ ne n gyɛ Gyowanan, Gyowanan mɔ-sɛ ne n gyɛ Resa, Resa mɔ-sɛ ne n gyɛ Serubabelɛ, Serubabelɛ mɔ-sɛ ne n gyɛ Sɛɛletɛɛ, Sɛɛletɛɛ mɔ-sɛ ne n gyɛ Neri, ");
INSERT INTO acd_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri mɔ-sɛ ne n gyɛ Mɛliki ɔko. Mɛliki ɔbono mɔ-sɛ ne n gyɛ Adi, Adi mɔ-sɛ ne n gyɛ Koosam, Koosam mɔ-sɛ ne n gyɛ Elimadam, Elimadam mɔ-sɛ ne n gyɛ Erɛ, ");
INSERT INTO acd_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Erɛ mɔ-sɛ ne n gyɛ Gyiisasɛ, Gyiisasɛ mɔ-sɛ ne n gyɛ Eliyasa, Eliyasa mɔ-sɛ ne n gyɛ Gyorim, Gyorim mɔ-sɛ ne n gyɛ Matati ɔko. Matati ɔbono mɔ-sɛ ne n gyɛ Lɛfi ɔko. ");
INSERT INTO acd_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lɛfi ɔbono mɔ-sɛ ne n gyɛ Simiyon, Simiyon mɔ-sɛ ne n gyɛ Gyuda, Gyuda mɔ-sɛ ne n gyɛ Gyosɛfo ɔko kee. Gyosɛfo ɔbono mɔ-sɛ ne n gyɛ Gyonam, Gyonam mɔ-sɛ ne n gyɛ Eliyakim, ");
INSERT INTO acd_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliyakim mɔ-sɛ ne n gyɛ Mɛliya, Mɛliya mɔ-sɛ ne n gyɛ Mena, Mena mɔ-sɛ ne n gyɛ Matata, Matata mɔ-sɛ ne n gyɛ Natan, Natan mɔ-sɛ ne n gyɛ Deefidi, ");
INSERT INTO acd_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Deefidi mɔ-sɛ ne n gyɛ Gyɛsi, Gyɛsi mɔ-sɛ ne n gyɛ Obɛdɛ, Obɛdɛ mɔ-sɛ ne n gyɛ Bowasɛ, Bowasɛ mɔ-sɛ ne n gyɛ Salimon, Salimon mɔ-sɛ ne n gyɛ Naason, ");
INSERT INTO acd_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Naason mɔ-sɛ ne n gyɛ Aminadabɛ, Aminadabɛ mɔ-sɛ ne n gyɛ Adamin, Adamin mɔ-sɛ ne n gyɛ Hɛsuron, Hɛsuron mɔ-sɛ ne n gyɛ Pɛrɛsɛ, Pɛrɛsɛ mɔ-sɛ ne n gyɛ Gyuda ɔko. ");
INSERT INTO acd_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Gyuda ɔbono mɔ-sɛ ne n gyɛ Gyeekɔpo, Gyeekɔpo mɔ-sɛ ne n gyɛ Ayisiki, Ayisiki mɔ-sɛ ne n gyɛ Aberaham, Aberaham mɔ-sɛ ne n gyɛ Tera, Tera mɔ-sɛ ne n gyɛ Neehɔ, ");
INSERT INTO acd_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Neehɔ mɔ-sɛ ne n gyɛ Serugi, Serugi mɔ-sɛ ne n gyɛ Rewu, Rewu mɔ-sɛ ne n gyɛ Pelegi, Pelegi mɔ-sɛ ne n gyɛ Ebɛ, Ebɛ mɔ-sɛ ne n gyɛ Sila, ");
INSERT INTO acd_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sila mɔ-sɛ ne n gyɛ Kayinan, Kayinan mɔ-sɛ ne n gyɛ Afakisadɛ, Afakisadɛ mɔ-sɛ ne n gyɛ Sem, Sem mɔ-sɛ ne n gyɛ Nowa, Nowa mɔ-sɛ ne n gyɛ Lamɛki, ");
INSERT INTO acd_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamɛki mɔ-sɛ ne n gyɛ Mɛtusala, Mɛtusala mɔ-sɛ ne n gyɛ Inɔki, Inɔki mɔ-sɛ ne n gyɛ Gyaradɛ, Gyaradɛ mɔ-sɛ ne n gyɛ Mahalali, Mahalali mɔ-sɛ ne gyɛ Kayinan ɔko. ");
INSERT INTO acd_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kayinan ɔbono mɔ-sɛ ne n gyɛ Inosi, Inosi mɔ-sɛ ne n gyɛ Sɛti, Sɛti mɔ-sɛ ne n gyɛ Adam. Adam berɛ Wurubuaarɛ gi lɛɛ mɔ daa kyu ba gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Yesu gi lii Gyɔɔdan ɔbon mɔ dɔ nfono Gyɔn gi gyere mɔ Wurubuaarɛ sagyere mɔ mɔ, Wurubuaarɛ Oduduu gi suu de mɔ, ne Wurubuaarɛ Oduduu mɔ gi kyu mɔ kpe ɔ naa gipen mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Yesu gi gyi gipen mɔ dɔ nkɛ ikue-inyɔ. Ɔ bo nno gɛnen mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ kya soo mɔ idoo ɔ kya kerɛ yɛɛ ɔ laa nu mɔ asɛ? Nkɛ nbono pɛwu dɔ mɔ, Yesu mɛŋ gyi sɛi-sɛi. Nkɛ mɔ gi baa logɛ mɔ, akon a kya mɔɔ mɔ kon. ");
INSERT INTO acd_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Ilaa nyɛnyɛn pɛwu gɛmu mɔ gi tɔgɛ Yesu yɛɛ, “Nengyene gɛsintin fo gyɛ Wurubuaarɛ mɔ-bi mɔ, tɔgɛ sa gibui gidɛ de giꞌ bingiri bodobodo sa fo de foꞌ gyi.” ");
INSERT INTO acd_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Yesu gi kine ne ɔ lɛɛ gɛnɔ sa mɔ yɛɛ, “Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, ‘I mɛŋ gyɛ agyudɔ wolɛ so ne nyamesɛ laa nyɛ gɛkyena.’ ” ");
INSERT INTO acd_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Yesu gi kine gɛnen mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kyu Yesu kpaa yelɛ soso-soso gɛtɛɛko, ne ɔ yɛgɛ Yesu gi kerɛ gɛsinkpan so isowolɛ kpɛi-kpɛi imɔ‑rɛ imɔ-awura pɛwu gyanꞌ gikolon. ");
INSERT INTO acd_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","O nyiile Yesu gɛnen mɔ, o kii soo Yesu ɔdoo yɛɛ, “Gɛsinkpan so gɛwuragyi pɛwu de gɛmɔ-nyisigyi ɔbono fo kya wu faa mɔ, i san i bo daa me-gibaa dɔ. Nyamesɛ kamaasɛ ɔbono n kya laarɛ mɔ, nan taalɛ kyu kyɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Imɔso nengyene fo laa ŋmii son me mɔ, imɔ ibono fo kya wu faa nan kyu imɔ pɛwu sa fo.” ");
INSERT INTO acd_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Nfono mɔ, Yesu gi kine, ne ɔ lɛɛ gɛnɔ yɛɛ, “Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, ‘Ŋmii de foꞌ kyu buubuu sa fo-Wura Wurubuaarɛ. Mɔ-wolɛ guan ne i kaaborɛ fo nyamesɛ foꞌ son.’ ” ");
INSERT INTO acd_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Yesu gi kii kine gɛnen mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kyu mɔ kpe Gyɛrusalem ɔsowolɛ so. Mɛ fo nno mɔ, o kyu mɔ kpaa gyanꞌ Wurubuaarɛ ɔson obu mɔ nfono i bo lege-lege mɔ ne o kii soo mɔ ɔdoo kerɛ yɛɛ, “Nengyene fo gyɛ Wurubuaarɛ mɔ-bi gɛsintin mɔ, lɛɛ fo-nyoro lii soso gɛrɛnaa kpaa too gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","A nyi ibono mɛ ŋmarasɛ Wurubuaarɛ agyɛbi ako yela yɛɛ, ‘Wurubuaarɛ laa tɔgɛ sa mɔ Wurubuaarɛ dɔ isɔɔ yɛɛ mɛꞌ dii fo dandan. ");
INSERT INTO acd_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Mɛ laa kɔɔlɛ fo. Gisidi gbaa fo maŋ sidi.’ ” ");
INSERT INTO acd_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Ilaa nyɛnyɛn pɛwu gɛmu mɔ gi tɔgɛ mɔ gɛnen mɔ, Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Wurubuaarɛ agyɛbi ako kee a tɔgɛ yɛɛ, ‘Gɛŋ sa foꞌ daasɛ fo-Wura Wurubuaarɛ kerɛ yɛɛ ɔ laa wɔra fo-gɛlaarɛ sa fo.’ ” ");
INSERT INTO acd_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Ilaa nyɛnyɛn pɛwu gɛmu mɔ gi soo Yesu idoo ikpa kamaasɛ so kpon gɛnen mɔ, ɔ naa kyon taa Yesu yɛgɛ kpe ɔ gyoo owi ɔbono ɔ laa kii nyɛ ɔkpa soo mɔ idoo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Yesu gi kii kpe Galeli gɛsinkpan so mɔ, Wurubuaarɛ Oduduu mɔ kya wɔra ilaa kyu naa de Yesu so. Imɔso mɔ-ilaa i nu gyanꞌ de isowolɛ ibono i sindi nno mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ɔ kya kpe mɔmɔ-akyangbon dɔ kpaa nyiile mɔmɔ Wurubuaarɛ ilaa, ne ɔkamaasɛ kya yen mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Yesu gi kyon kpe Nasarɛtɛ ɔsowolɛ so nfono mɛ bela mɔ mɔ. Ɔ bo nno mɔ, mɔmɔ Gyuda awura gɛkɛ kyoolasɛ gɛko mɔ, o kpe mɔmɔ-gikyangbon dɔ fɛɛ gɛnɔɔbono ɔ kya kyena wɔra mɔ. Ɔ bo gikyangbon mɔ dɔ gɛnen mɔ, ɔ koso yelɛ de ɔꞌ kalɛ Wurubuaarɛ agyɛbi. ");
INSERT INTO acd_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Nfono mɔ mɛ kyu ɔwolɛ ɔbono Wurubuaarɛ gi yɛgɛ mɔ-ikalan ɔtɔgɛbo Isaya mɔ gi wolaa ŋmarasɛ yela mɔ kyu sa mɔ. Yesu gi sɔɔ ɔwolɛ mɔ, ne o bugi mɔ, ne ɔ kalɛ kyu lii nyamesɛ ɔbono Wurubuaarɛ laa yɛgɛ ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ so. Nno mɔ isa mɔ gi tɔgɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Wurubuaarɛ gi yɛgɛ mɔ-Oduduu mɔ gi suu de me, ne o sun me de nꞌ baa tɔgɛ mɔ-ɔkalan konkonsɛ mɔ sa abono ilaa i tiri mɔmɔ mɔ. Ne abono ilaa i ŋminde mɔmɔ fɛɛ mɛ keda mɔmɔ tii de ibu mɔ Wurubuaarɛ gi sun me yɛɛ nꞌ baa tɔgɛ sa mɔmɔ yɛɛ mɛ laa nyɛ mɔmɔ-nyoro. O sun me yɛɛ nꞌ baa bugi agyaatanbo ansi de nꞌ yɛgɛ abono i kya ka mɔmɔ-ansi mɔ mɛꞌ nyɛ mɔmɔ-nyoro. ");
INSERT INTO acd_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","O sun me de nꞌ baa buu sa asa yɛɛ owi ɔbono Wura Wurubuaarɛ laa mɔlɛgɛ ɔmɔ mɔ gi fo kon.” ");
INSERT INTO acd_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Yesu gi kalɛ imɔ idɛ ta mɔ, ɔ baala ɔwolɛ mɔ bun ne o kiiri sa ɔbono ɔ kya kerɛ gikyangbon mɔ so mɔ, ne ɔ gbaa kyena de ɔꞌ lɛɛ gɛsɛ sa mɔmɔ. Ɔ kpelegɛ ɔ tɛ gɛnen mɔ, ɔkamaasɛ ɔbono ɔ bo mɔmɔ-gikyangbon mɔ dɔ nfono mɔ pɛwu ansi a san a yii daa mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Nfono mɔ, o yii gɛsɛ ɔ laa tɔngɛ mɔ, ɔ tɔgɛ yɛɛ, “Wurubuaarɛ agyɛbi abono nɛ kalɛ sa fɛye faa, i kyena de me-gɛkyena dɔ ilaa. Ndɛꞌ gɛkɛ gɛdɛ mɔ agyɛbi abono nɛ kalɛ faa a ba gɛsintin fɛɛ gɛnɔɔbono fɛ nu mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Mɔmɔ abono pɛwu mɛ bo nno mɔ mɛ kya yen mɔ. I dɛ mɔmɔ-gɛnɔ yɛɛ ɔ kya taalɛ bii tɔgɛ agyɛbi abono a kya gyi ginsi gɛnen. Mɛ san ma‑a taasɛ abara yɛɛ, “Iŋ gyɛ Gyosɛfo mɔ-bi mɔ ne?” ");
INSERT INTO acd_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nɛ bii fɛye-nwɔnsa dɔ yɛɛ fɛ kya laarɛ fɛꞌ tɔgɛ me yɛɛ, ‘Fo gyɛ asa ɔkyɛbo faa mɔ, kyɛ fo gbaa-gbaa fo-adɛ. Ilaa ibonoana a nu fo naa fo kya wɔra Kapɛɛniyon ɔsowolɛ so mɔ, wɔra fo-ɔsowolɛ gbaa-gbaa so gɛrɛ kee de aꞌ kerɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, Wurubuaarɛ ikalan ɔtɔgɛbo ɔko mɛŋ bo no ɔ kya gyi ginsi mɔ-gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nꞌ sa fɛye sinkaala ɔko de fɛꞌ nu. Dedaa mɔ, ikulaabo mɛ nyaakyɔ aye Isirale gɛsinkpan gɛdɛ so. Gɛnen owi ɔbono mɔ, Wurubuaarɛ ikalan ɔtɔgɛbo ɔko gi kyena. Wurubuaarɛ Oduduu bo mɔ dɔ. Mɛ kya terɛ mɔ yɛɛ Ilaagya. Mɔ-gɛkyena dɔ mɔ owi ɔko dɔ mɔ, i ba yɛɛ nyangbon mɛŋ baa da nsi nsa de gibaafon. Imɔso i yɛgɛ akon belɛ ako a baa tɔrɔ gɛsinkpan gɛdɛ pɛwu so. ");
INSERT INTO acd_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Nfono mɔ Wurubuaarɛ gi yɛgɛ Ilaagya giꞌ kpaa wɔra ilaa dɛgɛnɔsɛ sa daa okulaabo kolon ɔko ne ɔ nyɛ agyudɔ gyi kpaa lii owi ɔbono akon mɔ aberɛ mɔ a baa kyon mɔ. Okulaabo ɔbono gbaa mɛŋ taa gyɛ aye Isirale awura dɔ. Gɛnen okulaabo ɔbono mɔ ɔ kyena daa Sarefa ɔsowolɛ so. Sarefa mɔ gyɛ gɛsowolɛbi sindi Sidon ɔsowolɛ. ");
INSERT INTO acd_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Sinkaala nyɔsɛ kee ne n gyɛ yɛɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔko kee gi kyena, Wurubuaarɛ Oduduu bo mɔ dɔ. Mɛ kya terɛ mɔ yɛɛ Elisiya. Mɔ-gɛkyena dɔ mɔ, akononbu mɛ nyaakyɔ aye Isirale gɛsinkpan gɛdɛ so. Mɔmɔ ɔko‑rɛ ɔko mɛŋ nyɛ de Elisiya ɔbono nꞌ darɛ faa ɔꞌ kyɛ mɔ. Siiriyanyen kolon ɔko wolɛ ne n nyɛ ne Elisiya gi kyɛ mɔ. Mɔ gbaa kee mɛŋ gyɛ aye Isirale awura mɔ dɔ. Mɛ kya terɛ mɔ-ginyen yɛɛ Naaman.” ");
INSERT INTO acd_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Ilaa ibono Yesu gi tɔgɛ faa so mɔ, i yɛgɛ asa abono mɛ bo mɔmɔ-gikyangbon mɔ dɔ nno mɔ pɛwu mɛ kyu ginyadon de mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Mɛ koso ne mɛ nen mɔ kyu lii ɔsowolɛ mɔ so kpe ogee gɛnɔ de mɛꞌ kpaa nen mɔ too wɔra ogee mɔ dɔ. Mɛ yii ɔsowolɛ mɔ gyanꞌ daa gibii so. ");
INSERT INTO acd_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Mɛ yelɛ ogee mɔ gɛnɔ gɛnen mɔ, Yesu gi naa loo mɔmɔ dɔ lii kyon taa mɔmɔ yɛgɛ, ne mɛ mɛŋ baa nyɛ nen mɔ wɔra ogee mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Yesu gi lii nno mɔ, o kii kyon kpe Kapɛɛniyon ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ. Ɔ bo nno mɔ, ɔ kya kyena nyiile mɔmɔ Wurubuaarɛ ilaa mɔmɔ-nkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Mɔ-anyiilebi mɔ a kya dɛ asa gɛnɔ. I lii fɛɛ mɛ kya wolaa wu bii yɛɛ Wurubuaarɛ ne n sa mɔ ilaa nyiilesɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Gɛkɛ kyoolasɛ gɛko mɔ, ɔnyen ɔko bo mɔmɔ-gikyangbon mɔ dɔ, ilaa nyɛnyɛn oduduu i tɛ mɔ so. Ɔnyen mɔ gi wu Yesu mɔ, ilaa nyɛnyɛn oduduu ibono i tɛ mɔ so mɔ i tɔgɛ ken-ken taasɛ Yesu yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Ndo‑o! Yesu Nasarɛtɛnyen, menɛ ne fo kya laarɛ aye asɛ? Fo ba de foꞌ baa nyida aye ilaa nyɛnyɛn oduduu kpɛi-kpɛi mɔ abɛɛ?” Ne ilaa nyɛnyɛn oduduu mɔ i kii tɔgɛ sa Yesu yɛɛ, “N nyi isa ɔbono fo, Yesu, fo gyɛ. Fo ne n gyɛ gisen fufuli wura ɔbono fo-nkon ne n lii Wurubuaarɛ asɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nfono mɔ, Yesu gi tɔgɛ ilaa nyɛnyɛn oduduu mɔ yɛɛ, “Bun fo-gɛnɔ so de foꞌ koso lii ɔnyen baarɛ so, n kerɛ fo faa.” Gɛsintin mɔ, ilaa nyɛnyɛn oduduu mɔ i kuu ɔnyen mɔ da gɛsɛ asa mɔ ansi dɔ nfono, ne i koso lii ɔnyen mɔ so, iŋ wɔra ɔnyen mɔ sɛi. ");
INSERT INTO acd_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Gɛnen ilaa idɛ i wɔra asa abono mɛ bo nno mɔ pɛwu giyan. Mɛ san ma‑a taasɛ abara yɛɛ, “Menɛ ilaa ne idɛ? Yesu gɛnɔ dɔ agyɛbi a bo gya! Ɔ bo ɔkpa lii Wurubuaarɛ asɛ yɛɛ ɔꞌ gya ilaa nyɛnyɛn oduduu de iꞌ nu mɔ asɛ!” ");
INSERT INTO acd_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ilaa ibono Yesu kya wɔra mɔ i nu gyanꞌ de gɛnen gɛsinkpan gɛbono so pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Yesu gi lii mɔmɔ-gikyangbon mɔ dɔ mɔ, ɔ kyon kpe Simon gɛwi. Gɛnen aberɛ abono mɔ, Simon mɔ-saa kyiisɛ kya lɔ. Ɔkyagyii dɛ mɔ. Imɔso Yesu gi loo Simon gɛwi mɔ, abono mɛ bo gɛten mɔ dɔ mɔ mɛ kolɛ mɔ yɛɛ ɔꞌ wɔra aniya de ɔꞌ kyɛ ɔkyii mɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Nfono mɔ Yesu gi kpaa yelɛ ɔkyii mɔ amu so, ne ɔ tɔgɛ sa gilɔtɔ mɔ yɛɛ giꞌ taa ɔkyii mɔ yɛgɛ ɔ kerɛ gimɔ faa. Ayaa abono so mɔ, ɔkyii mɔ gi nyɛ alanfiya, ne ɔ koso kii taalɛ keda mɔmɔ-gisafo. ");
INSERT INTO acd_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Gɛnen gɛkɛ gɛbono mɔ owi mɔ kya kpe ɔꞌ kpaa tɔrɔ mɔ, asa abono mɛ dɛ alɔbo mɔ mɛ kyu ɔmɔ pɛwu bara Yesu. Ne o kyu mɔ-abaa gyanꞌ mɔmɔ ɔkamaasɛ so, ɔ kya kyɛ mɔmɔ-alɔtɔ ɔ sa ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ɔ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi lii asa so gikyɔ. Gɛnen ilaa nyɛnyɛn oduduu mɔ i kya koso mɔ, i kya saawo ken-ken tɔgɛ sa Yesu yɛɛ, “Fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ.” Imɔso Yesu kya da imɔ tii. Ɔ mɛŋ kya sa imɔ ɔkpa de iꞌ nyɛ tɔngɛ. I kya nyiile yɛɛ ilaa nyɛnyɛn oduduu mɔ i wu Yesu bii yɛɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Gɛdɛ gɛ kɛ mɔ, Yesu gi kpe nfono asa mɛŋ bo mɔ. Asa mɛ laarɛ mɔ ne mɛ laarɛ mɔ gɛnen‑n kpaa wu mɔ ne mɛ buɛɛlɛ mɔ yɛɛ ɔꞌ kyena mɔmɔ asɛ, ɔŋ baa naa taa mɔmɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “I kaaborɛ nꞌ naa isowolɛ banban so de nꞌ kpaa tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ kyu lii mɔ-gɛwuragyi dɔ akyenabi mɔ so sa nno asa. Imɔso ne Wurubuaarɛ gi sun me ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Imɔso Yesu gi naa Gyudiya gɛsinkpan so tɔgɛ tɔgɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa sa asa mɔmɔ-akyangbon dɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Gɛkɛ gɛdɛ mɔ Yesu yelɛ ɔbon belɛ ɔbono mɛ kya terɛ mɔ yɛɛ Gɛnɛsarɛtɛ mɔ gigengen so. Asa mɛ ba mɔ asɛ mɛ kya nyise ma‑a loo abara dɔ de mɛꞌ nyɛ tu sindi mɔ de mɛꞌ nu Wurubuaarɛ agyɛbi abono ɔ kya tɔgɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","O wu akolii anyɔ ako a yii ɔbon mɔ gigengen. Iken akedabo ne n taa amɔ yɛgɛ mɛ kya foro mɔmɔ-asɛwu nkyu mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Yesu gi wu akolii mɔ gɛnen mɔ, ɔ dii loo giko dɔ. Simon ne n bo gɛnen gikolii gibono. Yesu tɛ gikolii mɔ dɔ mɔ, ɔ tɔgɛ Simon yɛɛ ɔꞌ nen gikolii mɔ loo nkyu mɔ dɔ ŋmaraa. Gɛsintin mɔ, Simon gi nen gikolii mɔ loo nkyu mɔ dɔ. Yesu gi san ɔ gyanꞌ nkyu mɔ so ɔ kya nyiile asa Wurubuaarɛ ilaa. ");
INSERT INTO acd_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Yesu gi nyiile asa mɔ ilaa ta mɔ, ɔ tɔgɛ Simon mɔ‑rɛ mɔ-nanboana abono mɛ bo Yesu asɛ gikolii mɔ dɔ mɔ yɛɛ, “Fɛꞌ palɛ gikolii mɔ kpe nkyu bokensɛ mɔ dɔ de fɛꞌ too fɛye-asɛwu mɔ de fɛꞌ keda iken.” ");
INSERT INTO acd_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simon gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, deeri gɛnyɛ pɛwu mɔ a too asɛwu adɛ kalaadɛ, aŋ nyɛ sɛi-sɛi mɔ, idɛ dɔ gɛrɛ ne a laa nyɛ ilaa iko? To! Fo ne n nyɛ tɔgɛ faa mɔ, a laa too.” ");
INSERT INTO acd_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Gɛsintin mɔ, mɛ too asɛwu mɔ mɔ, mɛ keda iken gikyɔ-gikyɔ. Mɛ kya biidɛ iken mɔ mɔ, asɛwu mɔ gbaa a kya laarɛ de aꞌ tɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Mɛ terɛ mɔmɔ-nanboana abono mɛ dɛ gikolii nyɔsɛ mɔ yɛɛ mɛꞌ baa kpaa mɔmɔ. Gɛsintin mɔ, mɛ kpe ne mɛ kpaa lɛɛ iken mɔ bɔla akolii mɔ anyɔ. Iken mɔ oduduu so mɔ, akolii mɔ a kya laarɛ de aꞌ muiinɛ loo nkyu mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simon Piita gi wu ilaa ibono Yesu gi wɔra sa ɔmɔ mɔ, ɔ kpelegɛ ŋmii Yesu ayaa dɔ, ne ɔ tɔgɛ sa mɔ yɛɛ, “Me-Wura, n gyɛ daa ilaa nyɛnyɛn ɔwɔrabo. Imɔso tu lii me asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ilaa ibono so Simon gi tɔgɛ gɛnen mɔ ne n gyɛ yɛɛ iken mɔ ilaa mɔ i tansi dɛ mɔ‑rɛ abono mɛ bo gikolii mɔ dɔ mɔ pɛwu gɛnɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","I dɛ Gyeemesi de Gyɔn, Sɛbedi mɔ-biana mɔ gɛnɔ kee. Mɔmɔ‑rɛ Simon ne n kya wɔra gɛsun gɛbono dabɔlɛ. Nfono mɔ Yesu gi tɔgɛ Simon yɛɛ, “Gɛŋ selɛ gifuu. Nɛ wu yɛɛ fo kya lɛɛ daa iken. Lii nperɛ kyu i kya kpe mɔ nan yɛgɛ fo laa san laarɛ daa asa de mɛꞌ baa nyɛ Wurubuaarɛ asɛ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ɔ tɔgɛ gɛnen mɔ, Simon mɔ‑rɛ mɔ-nanboana Gyeemesi de Gyɔn, mɛ palɛ akolii mɔ lii gyanꞌ gigengen so, ne mɛ kyon taa ilaa kamaasɛ yɛgɛ san mɛ naa mɛ buu daa Yesu. ");
INSERT INTO acd_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Yesu bo gɛsinkpan gɛbono so mɔ, gɛkɛ gɛdɛ mɔ, ɔ bo mɔmɔ-isowolɛ mɔ ɔko so, ne ɔnyen ɔko gi baa tu mɔ. Ɔ gyɛ okononbu. O wu Yesu mɔ, ɔ kpelegɛ bun Yesu ayaa dɔ, ne ɔ kolɛ mɔ yɛɛ, “Ɔbelɛnsɛ, nengyene i gyɛ fo-gɛlaarɛ mɔ, n nyi yɛɛ fo laa taalɛ kyɛ me.” ");
INSERT INTO acd_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Yesu gi tengɛ mɔ-gibaa kpaa yii okononbu mɔ, ne ɔ lɛɛ gɛnɔ sa mɔ yɛɛ, “I gyɛ me-gɛlaarɛ; fo-gilɔ mɔ giꞌ ta.” Ayaa abono so mɔ, mɔ-gikononbu mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yesu gi ka sa ɔnyen mɔ yɛɛ, “Gɛŋ sa foꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ me ne n kyɛ fo. Naa kpaa wɔra ilaa ibono Mosisi gi yela sa okononbu kamaasɛ ɔbono mɔ-gilɔ gi ta mɔ. Imɔ ne n gyɛ yɛɛ fo laa kperɛ fo-nyoro kpaa nyiile Wurubuaarɛ asunbi ɔlɛɛbo de ɔꞌ kerɛ fo-nyoro pɛwu gyanꞌ. Ɔ laa wu yɛɛ fo-gilɔ mɔ gi ta, de foꞌ kyu fo-afaala abono fo laa kyu faala Wurubuaarɛ mɔ kyu sa mɔ de oꞌ kyu lɛɛ asunbi sa fo. Imɔ ne nan yɛgɛ asa mɛꞌ bii yɛɛ fo-alɔtɔ mɔ a ta gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Yesu gi da ɔnyen mɔ tii yɛɛ ɔŋ sa oꞌ buu sa isa gbaa faa, Yesu ilaa i dabɔlɛ nu gyanꞌ nten kpɛi-kpɛi. Imɔso i yɛgɛ asa sakyɔ mɛ kya san kpandɛ kpaa mili Yesu. Mɛ kya laarɛ mɛꞌ nu ilaa ibono ɔ kya nyiile asa mɔ ne mɛ kya laarɛ ɔꞌ kyɛ mɔmɔ-alɔtɔ sa ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Asa mɛ kya mili Yesu gikyɔ so mɔ, ɔ kya kyena lii sakpii mɔ dɔ kpe nfonoana asa mɛŋ bo mɔ kpaa dalaa. ");
INSERT INTO acd_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Gɛkɛ gɛdɛ mɔ Yesu kya nyiile asa Wurubuaarɛ ilaa mɔ, Farasii awura gikpen mɔ dɔ ako de Gyuda awura nbara anyiilebo mɔ ako mɛ tɛ mɔ asɛ. Mɛ lii isowolɛ kpɛi-kpɛi so. Mɔmɔ ako mɛ lii Galeli isowolɛ so de Gyudiya isowolɛ so de Gyɛrusalem. Wurubuaarɛ ɔlon bo Yesu so ɔ kya kyɛ asa alɔtɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Anyen ako kee mɛ sola ɔtɛgɛsɛ ɔko de gifengen kyu ba de ɔꞌ kyɛ mɔ sa mɔmɔ. Mɛ laarɛ ɔkpa ɔbono so mɛ laa nyɛ kyu ɔtɛgɛsɛ mɔ loo obu mɔ dɔ de mɛꞌ kyu mɔ kpaa yela Yesu ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Sakpii ɔbono ɔ bo nno mɔ kyɔ so mɔ, mɛŋ kya nyɛ ɔkpa. Imɔso mɛ sola ɔtɛgɛsɛ mɔ dii kpaa gyanꞌ obu mɔ soso. Mɛ maragɛ obu mɔ ŋmaraa, ne mɛ kyu ɔtɔgɛsɛ mɔ loo de ɔmaragɛten mɔ kpelegɛrɛ mɔ‑rɛ gifengen mɔ loo yela Yesu asɛ asa mɔ nsana. ");
INSERT INTO acd_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Yesu gi wu yɛɛ asa adɛ mɛ sɔɔ mɔ gyi yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ mɔ, ɔ tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, “Ɔnyen, nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyɛɛ fo.” ");
INSERT INTO acd_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Yesu gi tɔgɛ gɛnen mɔ, Gyuda awura nbara aŋmarasɛbo mɔ de Farasii awura gikpen mɔ dɔ asa mɔ mɛ kya taasɛ mɔmɔ-nyoro yɛɛ, “Mɔ ne n gyɛ anɛ ne ɔ kya tɔngɛ fɛɛ mɔ ne n gyɛ Wurubuaarɛ gɛnen? Ne iŋ gyɛ Wurubuaarɛ wolɛ mɔ, fo anɛ ne nan taalɛ kyu ɔko ilaa nyɛnyɛn ibono ɔ wɔra Wurubuaarɛ mɔ kyu kyɛɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Yesu gi bii mɔmɔ-nwɔnsa dɔ. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra so ne fɛ kya sa gɛnen nwɔnsa ndɛ? ");
INSERT INTO acd_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Nan tɔgɛ ilaa inyɔ sa ɔtɛgɛsɛ baarɛ. Giko ne n gyɛ yɛɛ, ‘Nɛ kyu fo-ilaa nyɛnyɛn ibono fo wɔra Wurubuaarɛ mɔ kyɛɛ fo.’ Ginyɔsɛ mɔ ne n gyɛ yɛɛ, ‘Koso de foꞌ naa.’ Imɔ inyɔ idɛ dɔ mɔ, imɔmɔ ne fɛ laa wu de fɛye-ansi? ");
INSERT INTO acd_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","N kya laarɛ de fɛꞌ nyɛ bii yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔkpa gɛsinkpan so de nꞌ kyu asa ilaa nyɛnyɛn ibono mɛ wɔra Wurubuaarɛ mɔ kyɛɛ mɔmɔ.” Gɛnen so mɔ, o kisee tɔgɛ sa ɔtɛgɛsɛ mɔ yɛɛ, “Koso, puru fo-gifengen de foꞌ naa kpe gɛwi.” ");
INSERT INTO acd_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Ayaa abono so mɔ, ɔnyen mɔ gi koso yelɛ mɔmɔ pɛwu‑u ansi dɔ. O puru mɔ-gifengen gibono so ɔ dɛ mɔ ne o yen Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","I wɔra mɔmɔ abono mɛ bo nfono mɔ pɛwu giyan, mɛ kya yen Wurubuaarɛ, ne i kya wɔra ɔmɔ gifuu. Mɛ san ma‑a taasɛ abara yɛɛ, “Menɛ ilaa ne a wu ndɛ gɛkɛ gɛdɛ faa?” ");
INSERT INTO acd_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Imɔ idɛ gɛmara mɔ, Yesu kya kpe gɛtɛɛko ne o wu lɛnpoo ɔsɔɔbo ɔko. Mɛ kya terɛ mɔ yɛɛ Lɛfi. Ɔ tɛ mɔ-gɛsun ɔwɔraten. Yesu gi wu Lɛfi gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, “Baa buu me de foꞌ wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Gɛsintin mɔ, Lɛfi gi koso taa ilaa kamaasɛ yɛgɛ ne ɔ san ɔ naa o buu Yesu. ");
INSERT INTO acd_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Lɛfi naa o buu Yesu gɛnen mɔ, gɛkɛ gɛdɛ mɔ ɔ yɛgɛ mɛꞌ gyi gɛkɛ belɛ mɔ-gɛten dɔ sa Yesu. Imɔso lɛnpoo asɔɔbo abono Gyuda awura asɛ mɔ mɛ gyɛ asa nyɛnyɛn mɔ sakyɔ de Yesu akasɛbo mɔ de asa kpɛi-kpɛi sakyɔ mɛ baa wɔra abaa gyi dabɔlɛ. ");
INSERT INTO acd_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Imɔso Farasii awura ako mɔmɔ‑rɛ Gyuda awura nbara aŋmarasɛbo mɔ mɛ lɔgedɛ de Yesu akasɛbo mɔ yɛɛ, “Menɛ n wɔra so ne fɛye‑rɛ lɛnpoo asɔɔbo de ilaa nyɛnyɛn awɔrabo fɛ kya gyi fɛ kya nun de abara gɛnen?” ");
INSERT INTO acd_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Yesu gi nu gɛnen mɔ, ɔ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛɛ gɛnɔɔbono ɔlɔbo ne n tiri ɔkyɛbo mɔ, gɛnen kee ne ilaa nyɛnyɛn awɔrabo mɛ tiri me, Yesu, ne. I mɛŋ gyɛ abono mɛ bo alanfiya mɔ ne n tiri ɔkyɛbo. ");
INSERT INTO acd_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Imɔso i mɛŋ gyɛ abono mɛ nyi yɛɛ mɛ ti mɛ gyɛ gɛsintin awura mɔ so ne nɛ ba gɛsinkpan so. Nɛ ba daa de nꞌ baa tɔgɛ sa ilaa nyɛnyɛn awɔrabo yɛɛ mɛꞌ nu mɔmɔ-nyoro gɛsɛ de mɛꞌ kyɛɛgɛ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Asa ako mɛ baa tɔgɛ sa Yesu yɛɛ, “Gyɔn akasɛbo mɛ kya ŋminde nnɔ belen-belen de mɛꞌ dalaa. Farasii awura mɔ-lɛɛ akasɛbo mɔ kee mɛ kya wɔra gɛnen. Ne menɛ n wɔra ne fo-lɛɛ akasɛbo mɔ berɛ mɛŋ kya ŋminde nnɔ daa?” ");
INSERT INTO acd_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yesu gi da mɔmɔ gikpalɛ yɛɛ, “I mɛŋ gyɛ aberɛ adɛ ne mɛ laa wɔra gɛnen. I dɛ daa fɛɛ gɛnɔɔbono aye Gyuda awura a kya kpii ɔkyii mɔ. Aꞌ kyu yɛɛ me ne n gyɛ ɔkyiifɔ mɔ-kuli mɔ. Me-kyɛmenɛana mɔ mɛ ba me asɛ a kya gyi ɔkon mɔ, i laa sa de mɛꞌ ŋminde nnɔ? ");
INSERT INTO acd_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Kuaa. I laa baa fo owi ɔko mɔ, i laa baa puru ɔkyiifɔ mɔ-kuli mɔ lii me-kyɛmenɛana asɛ. Lii gɛnen owi ɔbono kyu kyon mɔ, i laa sa de mɛꞌ ŋminde nnɔ kon.” ");
INSERT INTO acd_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yesu gi kii da mɔmɔ gikpalɛ kyu nyiile yɛɛ mɔ berɛ ɔ bara akyenabi pobɔrɔ. Ɔ da gikpalɛ mɔ yɛɛ, “Nengyene gikuru dedaa gi tɛɛ mɔ, mɛŋ kya ten gikuru pobɔrɔ kyu baa tii ɔtɛɛten mɔ. Fɛ wɔra gɛnen mɔ, fɛ laa nyida gikuru pobɔrɔ mɔ daa giyan. Gi maŋ kyena de gidedaa mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Yesu gi kii da ɔmɔ gikpalɛ yɛɛ, “Aꞌ laa ansi kerɛ gɛnɔɔbono mɛ kya kyu nta kyu wɔra nbuɛ iwolɛ dɔ mɔ de aꞌ kerɛ. Ɔko maŋ kyule kyu nta pobɔrɔ kyu wɔra nta ɔwɔraten iwolɛ dedaa dɔ. Ɔbono ɔ wɔra gɛnen mɔ, gyɛrɛbi ne ɔ kya laarɛ. Nta mɔ gi laa paadɛ nta ɔwɔraten iwolɛ mɔ de nta mɔ giꞌ duuli fuɛ de iwolɛ mɔ, mɔ, kee iꞌ nyida. ");
INSERT INTO acd_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Mɛ kya kyu nta pobɔrɔ kyu wɔra daa nta ɔwɔraten iwolɛ pobɔrɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Fɛꞌ nu kee yɛɛ ɔko maŋ nun nta dedaa de ɔꞌ koso ayaa abono so kpe kpaa laarɛ nta pobɔrɔ gɛten. O nun nta dedaa mɔ, ilaa ibono ɔ laa tɔgɛ mɔ ne n gyɛ yɛɛ nta ndɛ gi boran.” ");
INSERT INTO acd_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Gɛkɛ kyoolasɛ gɛko mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya kpe gɛtɛɛko, ne mɛ baa loo awayu ndɔɔ nko dɔ. Mɛ naa awayu mɔ dɔ mɛ kya kpe mɔ, mɔ-akasɛbo mɔ mɛ yii gɛsɛ mɛ kya kyadɛ awayu mɔ, mɛ kya fɔlɔgɛ mɛ kya wɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Farasii gikpen mɔ dɔ ako mɛ wu mɔmɔ gɛnen mɔ, mɛ taasɛ mɔmɔ yɛɛ, “Fɛ kya kyadɛ awayu adɛ faa, fɛ mɛŋ nyi yɛɛ gɛsun ne fɛ kya wɔra aye-gɛkɛ kyoolasɛ dɔ faa? Aye-nbara giŋ kya sa ɔkpa gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ne Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Fɛ nyi yɛɛ iŋ dɛ ɔkpa gɛnen faa mɔ, imɔso fɛŋ ti kalɛ Wura Deefidi mɔ‑rɛ mɔ-nanboana ilaa Wurubuaarɛ agyɛbi mɔ dɔ kerɛ? Mɛ ŋmarasɛ nno yɛɛ owi ɔko dɔ mɔ, akon a dɛ Deefidi mɔ‑rɛ mɔ-nanboana. ");
INSERT INTO acd_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Imɔso ɔ loo Wurubuaarɛ ɔson panpan dɔ kpaa puru bodobodo ɔbono asa mɛ kyu bara Wurubuaarɛ mɔ. Naafo aye-nbara mɔ giŋ kya sa ɔkpa yɛɛ fo nyamesɛ giyan foꞌ nyɛ gyi gɛnen bodobodo ɔbono, gɛnen mɔ, Gyuda awura asunbi alɛɛbo wolɛ. Wura Deefidi mɔ gi gyi bodobodo mɔ iko ne o kyu iko kee sa mɔ-nanboana mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Imɔso Yesu gi lɛɛ gɛsɛ sa mɔmɔ yɛɛ, “Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, n bo ɔlon dabɔlɛ gɛkɛ kyoolasɛ mɔ so.” ");
INSERT INTO acd_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Gɛkɛ kyoolasɛ gɛko kee mɔ, Yesu gi kpe mɔmɔ Gyuda awura gikyangbon giko dɔ, ne ɔ kpaa nyiile asa ilaa. Ɔnyen ɔko bo nno, mɔ-gibaa gyisɛ gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Gyuda awura nbara aŋmarasɛbo ako de Farasii gikpen mɔ dɔ ako mɛ kya laarɛ ɔkpa ɔbono so mɛ laa nyɛ kyu Yesu wɔra nbɛlɛ dɔ. Imɔso mɛ kya dii mɔ de mɛꞌ kerɛ yɛɛ ɔ laa kyɛ ɔnyen mɔ gɛkɛ kyoolasɛ gɛbono? Nengyene ɔ kyɛ mɔ mɔ, mɛ laa kyu imɔ yɛɛ Yesu gi tɔrɔ nbara wɔra gɛsun gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Yesu gi bii mɔmɔ-nwɔnsa dɔ. Gɛnen so mɔ, ɔ tɔgɛ sa ɔnyen mɔ yɛɛ, “Koso yelɛ de foꞌ naa ba ansi dɔ gɛrɛ.” Gɛsintin mɔ, ɔnyen mɔ gi koso naa kpaa yelɛ asa mɔ ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nfono mɔ Yesu gi taasɛ ɔmɔ yɛɛ, “Nnɛ ne Wurubuaarɛ nbara gi kya nyiile aye yɛɛ aꞌ wɔra gɛkɛ kyoolasɛ? Aꞌ wɔra idɛnsɛ abɛɛ aꞌ wɔra ilaa nyɛnyɛn? Aꞌ sɔɔ abara nkpa abɛɛ aꞌ mɔɔ abara daa?” ");
INSERT INTO acd_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ɔ kerɛ asa mɔ dɔ pɛwu gyanꞌ ne ɔ tɔgɛ sa ɔnyen mɔ yɛɛ, “Tengɛ fo-gibaa mɔ.” Gɛsintin mɔ, ɔ tengɛ gimɔ, ne gibaa mɔ gi kii kyingi. ");
INSERT INTO acd_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Gɛnɔɔbono Yesu gi kyɛ ɔnyen mɔ gɛkɛ kyoolasɛ mɔ so mɔ, nbara aŋmarasɛbo mɔ de Farasii awura mɔ mɛ keda mɔ ginyadon, ne mɛ lii kpe mɛ kya ŋminde ilaa ibono mɛ laa kyu wɔra Yesu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Gɛnen owi ɔbono mɔ Yesu gi dii kpe gibii giko so ɔꞌ kpaa dalaa, ne ɔ dalaa sa Wurubuaarɛ gɛnen‑n kalaadɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Gɛdɛ gɛ kɛ mɔ, ɔ terɛ mɔ-akasɛbo mɔ ba mɔ asɛ ne ɔ lɛɛ mɔmɔ dɔ asa gudu anyɔ, ne ɔ yela ɔmɔ ginyen yɛɛ mɔ-isɔɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Gɛnen asa gudu anyɔ mɔ ne n gyɛ Simon ɔbono Yesu gi yela mɔ ginyen nyɔsɛ yɛɛ Piita mɔ, de Simon mɔ-tedɛ Andiru, Gyeemesi de Gyɔn, Filipo de Batolomiyu, ");
INSERT INTO acd_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Matiyu de Tomaasɛ, Gyeemesi, Alefayo mɔ-bi, de Simon ɔbono mɛ kya terɛ mɔ yɛɛ Ɔbono Ɔŋ Kya Kyule Mɔ-Ɔsowolɛ So mɔ, de Gyudasɛ, Gyeemesi mɔ-tedɛ, ");
INSERT INTO acd_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","de Gyudasɛ Isikaayɔtɛ ɔbono gɛmara gɛmara ɔ fɛ Yesu sa Yesu akyobo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Yesu gi lɛɛ mɔ-isɔɔ mɔ gɛnen mɔ, mɔ‑rɛ mɔmɔ mɛ kpelegɛ lii gibii mɔ so ba gitaga giko dɔ. Mɛ fo gitaga mɔ dɔ mɔ, mɛ tu sakpii belɛ yelɛ ɔ gyoo Yesu. Mɔ-akasɛbo mɔ sakyɔ mɛ bo nno. Asa abono mɛ lii nten kpɛi-kpɛi mɔ sakyɔ kee mɛ bo sakpii mɔ dɔ. Asa sakyɔ mɛ lii Gyudiya isowolɛ so, Gyɛrusalem ɔsowolɛ so, de isowolɛ ibono i bo apoo gɛnɔ gɛnɔ ne i sindi Taya de Sidon isowolɛ so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Mɛ ba de mɛꞌ baa nu Yesu ilaa tɔgɛsɛ de mɛꞌ nyɛ ɔꞌ kyɛ mɔmɔ-alɔtɔ. Abono ilaa nyɛnyɛn oduduu kpɛi-kpɛi i kya nyala mɔmɔ mɔ kee mɛ ba, ne Yesu gi kosorɛ ilaa nyɛnyɛn oduduu mɔ lii mɔmɔ so ne mɛ nyɛ mɔmɔ-nyoro. ");
INSERT INTO acd_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Sakpii mɔ dɔ nyamesɛ kamaasɛ kya laarɛ ɔkpa ɔbono so ɔ laa nyɛ de oꞌ yii Yesu mɔ. I kya nyiile yɛɛ ɔkamaasɛ ɔbono o yii Yesu mɔ, ɔlon ɔko kya lii Yesu dɔ kpaa kyɛ kaasɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Yesu yelɛ ɔ kerɛ mɔ-akasɛbo mɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Amudɛnsɛbo ne n gyɛ fɛye abono fɛ gyɛ ayenbo mɔ. Wurubuaarɛ gɛwuragyi dɔ akyenabi a gyɛ fɛye-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Amudɛnsɛbo ne n gyɛ fɛye abono akon a kya mɔɔ fɛye nperɛ faa mɔ. Wurubuaarɛ laa yɛgɛ fɛ laa gyi kaabo. Amudɛnsɛbo ne n gyɛ fɛye abono fɛ dɛ ginsikyu dɔ nperɛ mɔ. Wurubuaarɛ laa yɛgɛ fɛ laa baa ŋmasɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Fɛye abono kyu lii me, anyamesɛ pɛwu mɔmɔ-daa mɔ so ne asa mɛ laa kyo fɛye, ne mɛ maŋ yɛgɛ fɛꞌ saarɛ mɔmɔ dɔ, mɛ laa saalɛ fɛye, ne mɛ laa kpa fɛye-giso yɛɛ fɛ gyɛ asa nyɛnyɛn mɔ, fɛ gyɛ amudɛnsɛbo. ");
INSERT INTO acd_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","I ba gɛnen mɔ, fɛꞌ yɛgɛ iꞌ wɔra fɛye ɔkon de fɛꞌ kyaa. I kya nyiile yɛɛ Wurubuaarɛ ntɛɛla belɛ gi dɛ gi sa fɛye Wurubuaarɛ dɔ. Fafaanan kee ne fɛye-akyobo mɔmɔ-naanaana mɔ mɛ kyu wɔra Wurubuaarɛ ikalan atɔgɛbo mɔ baa kyon mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Ne fɛye abono fɛ gyɛ aterenbi awura nperɛ faa mɔ, fɛye laako. Fɛye berɛ, fɛ ti nyɛ fɛye-lɛɛ nkyoola ne. Fɛye abono fɛ kya nyɛ fɛ kya gyi fɛ kya kaabo nperɛ faa mɔ, fɛye laako. Akon a laa baa mɔɔ fɛye. ");
INSERT INTO acd_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Fɛye abono fɛ kya ŋmasɛ nperɛ faa mɔ, fɛye laako. Fɛ laa suiili de fɛꞌ ŋɛ gɛnɔ saawo. ");
INSERT INTO acd_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Dedaa mɔ Wurubuaarɛ ikalan atɔgɛbo ako mɛ taa Wurubuaarɛ ikalan mɔ yɛgɛ san tɔgɛ daa mɔmɔ gbaa-gbaa lɛɛ gɛwɔnsa dɔ ilaa sa asa, ne fɛye-naanaana mɛ yen mɔmɔ. Fɛye abono asa pɛwu mɛ laa yen fɛye gɛnen kee mɔ, fɛye laako. ");
INSERT INTO acd_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Fɛye abono fɛ kya nu me asɛ mɔ berɛ, n kya tɔgɛ mi‑i sa fɛye yɛɛ fɛꞌ laarɛ fɛye-akyobo ilaa. Fɛꞌ wɔra gidɛnsɛ sa abono mɛ kya kyo fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Fɛꞌ kolɛ Wurubuaarɛ ayuule sa abono mɛ kya tɔgɛ nnɔ mɛ kya wɔra fɛye mɔ. Fɛꞌ dalaa kolɛ Wurubuaarɛ sa abono mɛ kya wɔra fɛye ilaa nyɛnyɛn mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nengyene ɔko gi da fo-ɔtan gyisɛ so mɔ, kisee ɔnyɔsɛ mɔ sa mɔ de oꞌ kii da. Nengyene ɔko gi sɔgɛ fo soso-lɛɛ gɛgbɛ mɔ, yɛgɛ de oꞌ kyu gɛsɛ-lɛɛ mɔ kee bɔla. ");
INSERT INTO acd_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ɔkamaasɛ ɔbono ɔ laa kolɛ fo ilaa iko ne fo bo mɔ, sa mɔ. Nengyene ɔko gi sɔgɛ ilaa ibono i gyɛ fo-lɛɛ mɔ, gɛŋ tɔgɛ mɔ yɛɛ oꞌ kiiri imɔ sa fo. ");
INSERT INTO acd_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Gɛnɔɔbono fɛ kya laarɛ fɛɛ asa mɛꞌ wɔra sa fɛye mɔ, fɛꞌ wɔra imɔ ɔnan kee sa asa. ");
INSERT INTO acd_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nengyene fɛ kya laarɛ asa abono mɛ kya laarɛ fɛye-ilaa mɔ wolɛ mɔ, nnɛ so ne i kaaborɛ Wurubuaarɛ oꞌ yen fɛye? Ilaa nyɛnyɛn awɔrabo gbaa kee mɛ kya laarɛ asa abono mɛ kya laarɛ ɔmɔ-ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Nengyene fɛ kya wɔra gidɛnsɛ sa daa abono mɛ kya wɔra gidɛnsɛ sa fɛye wolɛ mɔ, nnɛ so ne i kaaborɛ Wurubuaarɛ oꞌ yen fɛye? Ilaa nyɛnyɛn awɔrabo gbaa kee mɛ kya wɔra gɛnen. ");
INSERT INTO acd_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Fɛ kya kyu fɛye-aterenbi kyu paa daa abono fɛ nyi mɔmɔ so yɛɛ ɔkɛ de ɔkaamara mɛ laa taalɛ kii nyɛ ka fɛye mɔ wolɛ mɔ, i kaaborɛ Wurubuaarɛ oꞌ yen fɛye? Kuaa. Ilaa nyɛnyɛn awɔrabo gbaa kee mɛ kya kyu mɔmɔ-aterenbi paa mɔmɔ-nanboana ilaa nyɛnyɛn awɔrabo. I lii fɛɛ mɛ nyi yɛɛ ɔkɛ de ɔkaamara mɛ laa kiiri mɔmɔ-atɔ mɔ bara mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Imɔso fɛye abono fɛ gyɛ me-akasɛbo mɔ berɛ, fɛꞌ laarɛ fɛye-akyobo ilaa de fɛꞌ wɔra gidɛnsɛ sa ɔmɔ. Mɛ laa paa fɛye ilaa iko ne fɛ bo mɔ, fɛꞌ sa mɔmɔ de fɛŋ sa fɛꞌ sa gɛwɔnsa yɛɛ mɛꞌ kiiri bara fɛye. Fɛ wɔra gɛnen mɔ, fɛ laa nyɛ ntɛɛla belɛ, ne fɛ laa wɔra Wurubuaarɛ ɔbono ɔ gyɛ Gitɔbelɛ mɔ mɔ-biana. I kya nyiile yɛɛ ɔ bo gidɛnsɛ sa dabɔlɛ ilaa nyɛnyɛn awɔrabo de abono ɔ kya wɔra ilaa dɛnsɛ sa mɔmɔ ne iŋ kya gyi mɔmɔ-ginsi mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Fɛꞌ wɔra gitolon awura fɛɛ fɛye-sɛ gitolon wura Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Fɛŋ sa fɛꞌ kerɛ ansi so tɔgɛ yɛɛ fɛye-nanboana ilaa iŋ boran, de Wurubuaarɛ kee ɔ mɛŋꞌ kerɛ fɛye-ilaa ansi so tɔgɛ yɛɛ iŋ boran. Fɛ mɛŋ sa fɛꞌ bun fɛye-nanboana gipuɛɛ de Wurubuaarɛ kee ɔ mɛŋꞌ bun fɛye gipuɛɛ. Fɛꞌ kyu ilaa nyɛnyɛn ibono asa mɛ kya wɔra fɛye mɔ kyu kyɛɛ mɔmɔ, de Wurubuaarɛ kee oꞌ kyu fɛye-ilaa nyɛnyɛn kyɛɛ fɛye. ");
INSERT INTO acd_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Fɛꞌ kyɛɛ ilaa. Fɛ kya kyɛɛ ilaa mɔ, Wurubuaarɛ laa tansi kyɛɛ fɛye ilaa kee. I laa wɔra fɛɛ gɛnɔɔbono mɛ kya kyu mudu dɛnsɛ kyu kaala fɛɛ nnyufo faa. Akaalabo dɛnsɛ mɔ mɛ kya kaala bɔla de mɛꞌ gyigisi de mɛꞌ nyise de iꞌ loo gɛnda abara dɔ de mɛꞌ kii gyɔgɛ too de iꞌ bɔla i kya fuɛ. Mudu ɔbono ɔnan fɛ kyu kaala sa ako mɔ, mɔ-ɔnan kee ne Wurubuaarɛ laa kyu kaala sa fɛye.” ");
INSERT INTO acd_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yesu gi da mɔmɔ gikpalɛ gidɛ kee taasɛ yɛɛ, “Gyaatanbo laa taalɛ keda mɔ-nanbo gyaatanbo de oyii de iꞌ kyena? Mɔmɔ anyɔ mɛ maŋ tɔrɔ ɔbɔ dɔ? ");
INSERT INTO acd_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ilaa ɔkasɛbo maŋ taalɛ don mɔ-onyiilebo. Ɔkasɛbo, mɔ, gi kasɛ ilaa kpaa logɛ mɔ, ɔ laa wɔra daa fɛɛ mɔ-onyiilebo. ");
INSERT INTO acd_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Menɛ n wɔra so ne fo kya wu fo-nanbo ilaa nyɛnyɛn pii ibono ɔ kya wɔra mɔ ne foŋ kya wu fo-lɛɛ ibelɛbelɛ idɛ? I dɛ daa fɛɛ fo wu gikpara gi bo ɔko ginsi dɔ ne fo maŋ wu yɛɛ gɛgyakpaabi gɛ taa fo-lɛɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Nnɛ so ne fo laa tɔgɛ sa fo-nanbo yɛɛ, ‘O, me-nanbo, kerɛ, gikpara gi bo fo-ginsi dɔ. Yɛgɛ nꞌ lɛɛ gimɔ sa fo.’ --Yɛgɛ gɛgyakpaabi gɛ taa fo-lɛɛ dɔ? O, gikerɛansi anyamesɛ! Fɛꞌ lɛɛ ngyakpaabi nbono gi taa fɛye-lɛɛ ansi dɔ mɔ de fɛꞌ nyɛ wu dɔɔdan kpaa lɛɛ akpara abono a bo fɛye-nanboana lɛɛ ansi abi dɔ mɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","44","“Nyamesɛ ilaa wɔrasɛ ne fɛ laa kyu bii mɔ-gisen dɔ ilaa. Oyii ɔbono ɔ bo alanfiya mɔ maŋ taalɛ sɔrɔ abi nyɛnyɛn. Ne oyii ɔbono ɔ kya lɔ mɔ kee maŋ taalɛ sɔrɔ abi dɛnsɛ. Oyii kamaasɛ kee mɔ, mɔ-abi ne mɛ kya kyu bii mɔ. Ɔko maŋ nyɛ mango tɛɛ lii giwii oyii dɔ. Ɔko maŋ nyɛ payaa tɛɛ lii fɔlɔgɛ oyii dɔ. ");
INSERT INTO acd_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Nyamesɛ dɛnsɛ berɛ, ilaa dɛnsɛ ne n bo mɔ-gisen dɔ; ne ilaa dɛnsɛ ne nan lii mɔ-gɛnɔ dɔ. Nyamesɛ nyɛnyɛn mɔ, ilaa nyɛnyɛn ne n bo mɔ-gisen dɔ, ne ilaa nyɛnyɛn ne nan lii mɔ-gɛnɔ dɔ. Ilaa ibono i bo nyamesɛ gisen dɔ mɔ, imɔ ne ɔ kya lɛɛ tɔgɛ.” ");
INSERT INTO acd_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Yesu gi taasɛ asa abono mɛ buu mɔ mɔ yɛɛ, “Menɛ n wɔra so ne fɛ kya terɛ me yɛɛ, ‘Aye-Wura, Aye-Wura,’ yɛgɛ fɛŋ kya wɔra ilaa ibono n kya tɔgɛ fɛye mɔ daa? ");
INSERT INTO acd_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ɔkamaasɛ ɔbono ɔ ba me asɛ, o nu me-ilaa tɔgɛsɛ, ne ɔ kya wɔra imɔ so ilaa mɔ, nan nyiile fɛye gɛnen nyamesɛ ɔbono oyuduu. ");
INSERT INTO acd_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kaasɛ mɔ dɛ fɛɛ ɔsɛɛbo ɔbono o yii obu. Ɔ laa yii obu mɔ mɔ, o kuru gɛsɛ ɔpɔɔrɛ mɔ gɛten kpaa tu gifolɛ pɛi ne ɔ too gɛsɛ ɔpɔɔrɛ mɔ gyanꞌ gifolɛ mɔ so. Ɔsɛɛbo mɔ gi ti pɔrɔ obu mɔ ta mɔ, gɛkɛ gɛdɛ mɔ, ɔbon gi bɔla baa da de gɛnen obu mɔ. Nkyu gi da de mɔ gɛnen mɔ, ɔ mɛŋ boori. I lii fɛɛ ɔ pɔrɔ mɔ dɔɔdan gyan gifolɛ so. ");
INSERT INTO acd_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Nyamesɛ ɔbono, mɔ, o nu me-ilaa tɔgɛsɛ, ne ɔ mɛŋ kya wɔra imɔ so ilaa mɔ, kaasɛ mɔ dɛ fɛɛ ɔnyen ɔbono oŋ nyi ɔlaako ne o yii obu gyanꞌ daa giŋɛsii so giyan mɔ. Ɔ mɛŋ kuru gɛsɛ ɔpɔɔrɛ mɔ gɛten. Ɔnyen mɔ gi ti pɔrɔ obu mɔ ta mɔ, gɛkɛ gɛdɛ mɔ, ɔbon gi bɔla baa da de obu mɔ. Ayaa abono so mɔ, obu mɔ gi tɔrɔ daa wurum!” ");
INSERT INTO acd_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Yesu gi tɔngɛ sa sakpii mɔ ta mɔ, ɔ naa loo Kapɛɛniyon ɔsowolɛ so. ");
INSERT INTO acd_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Gɛnen owi ɔbono mɔ, Rom awura asogya ɔbelɛnsɛ ɔko bo ɔsowolɛ mɔ so, mɔ-dega ɔbono mɔ-ilaa i bo mɔ-gisen dɔ mɔ kya lɔ, ibono i bo lon. Ɔ kya laarɛ de ɔꞌ lɛɛ gibaa. ");
INSERT INTO acd_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Ɔbelɛnsɛ baarɛ gi nu Yesu so, ne ɔ keda Gyuda awura abelɛnsɛ ako sun Yesu asɛ yɛɛ mɛꞌ kpaa kolɛ mɔ de ɔꞌ baa kyɛ mɔ-dega mɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Isɔɔ mɔ o sun mɔ mɛ kpe Yesu asɛ mɔ, mɛ kpaa kolɛ mɔ yɛɛ ɔꞌ wɔra aniya ɔꞌ kpaa kyɛ mɔmɔ-ɔbelɛnsɛ dega mɔ sa mɔ. Mɛ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ mɔ gi kaaborɛ ibono foꞌ kpe de foꞌ kpaa kyɛ mɔ-dega mɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Ɔ kya laarɛ aye Gyuda awura ilaa. Ɔ pɔrɔ aye-gikyangbon kyɛɛ aye giyan.” ");
INSERT INTO acd_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Isɔɔ mɔ mɛ tɔgɛ Yesu gɛnen mɔ, Yesu gi naa buu mɔmɔ. Mɛ kya fuude ɔbelɛnsɛ mɔ gɛten dɔ mɔ, ɔbelɛnsɛ mɔ gi kii sun mɔ-kyɛmenɛana ako Yesu asɛ yɛɛ, “Me-Wura, me ɔdɛ meŋ kaaborɛ ibono foꞌ ba me-gɛten dɔ. Imɔso gɛŋꞌ baa nyala fo-nyoro. ");
INSERT INTO acd_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Me gbaa-gbaa kee nɛ wu yɛɛ meŋ kaaborɛ nꞌ ba fo asɛ baa yelɛ fo-ansi dɔ. Gɛnen so mɔ, wɔra aniya, fo berɛ, kpɛ lɛɛ gɛnɔ. Fo nyɛ lɛɛ gɛnɔ mɔ, me-dega mɔ gilɔ mɔ gi laa ta. ");
INSERT INTO acd_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Me kee n gyɛ ɔbelɛnsɛ ɔbono n bo ɔko gɛsɛ, ne nꞌ bo abono, mɔ, mɛ bo me gɛsɛ mɔ. Nengyene nɛ lɛɛ gɛnɔ yɛɛ ‘fo ɔdɛ, kpe faa’ mɔ, kaasɛ mɔ laa kpe, abɛɛ nꞌ tɔgɛ yɛɛ ‘fo ɔdɛ, ba gɛrɛ’ mɔ, kaasɛ mɔ laa ba. Nengyene nɛ tɔgɛ sa me-dega yɛɛ, ‘wɔra idɛ’ mɔ, imɔ ne ɔ laa wɔra.” ");
INSERT INTO acd_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Yesu gi nu ɔbelɛnsɛ mɔ ilaa tɔgɛsɛ mɔ, i dɛ mɔ-gɛnɔ gikyɔ. Nfono ne Yesu gi kisee tɔgɛ sa sakpii ɔbono o buu mɔ mɔ yɛɛ, “Nꞌ tɔgɛ sa fɛye yɛɛ ba‑a aye Isirale awura mɔ dɔ gbaa, meŋ wu nyamesɛ ɔbono ɔ bo gisɔɔgyi belɛ gidɛ ɔnan sa me fɛɛ Rom ɔbelɛnsɛ baarɛ.” ");
INSERT INTO acd_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Ɔbelɛnsɛ mɔ isɔɔ mɔ mɛ baa kii kpe mɔmɔ-ɔbelɛnsɛ mɔ gɛten dɔ mɔ, mɛ kpaa wu daa dega mɔ gi nyɛ alanfiya. ");
INSERT INTO acd_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Imɔ idɛ gɛmara mɔ, Yesu gi naa kpe ɔsowolɛ ɔko so mɛ kya terɛ mɔ yɛɛ Neen. Ɔ kya kpe mɔ, mɔ-akasɛbo mɔ de sakpii belɛ mɛ buu mɔ kpe. ");
INSERT INTO acd_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mɛ yii gɛkpen kyaabɔɔ Neen ɔsowolɛ mɔ ne mɛ lɛɛ gɛbunono. Yesu kpɛ ɔ kya sindi Neen gɛkpen mɔ gɛbunono mɔ, ɔ baa kerɛ mɔ, asa mɛ so obuni mɛ kya lii mɛ kya kpe mɔmɔ-ibuni opuleten mɛꞌ kpaa pule. Gɛnen ɔnyen ɔbono o wuꞌ mɔ, mɔ-nkon ne gyɛ mɔ-nyi mɔ-bi, ne mɔ-nyi mɔ gyɛ daa okulaabo. Mɛ so obuni mɔ mɛ kya lii gɛnen mɔ, obuni mɔ mɔ-nyi de sakpii belɛ mɛ buu mɔ mɛ kya kpe opuleten mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Wura Yesu gi wu ɔkyii mɔ gɛnen mɔ, mɔ-ilaa i wɔra mɔ ayen gikyɔ ne ɔ tɔgɛ sa mɔ yɛɛ, “Ɔkyii, gɛŋ baa su.” ");
INSERT INTO acd_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Nfono mɔ Yesu gi tu sindi obuni mɔ ne o kyu mɔ-gibaa yii ilaa ibono obuni mɔ dɛ imɔ so mɔ. O yii imɔ gɛnen mɔ, asa abono mɛ so obuni mɔ mɛ sii yelɛ. Ne Yesu gi tɔgɛ sa obuni mɔ yɛɛ, “Dega, n kya tɔgɛ mi‑i sa fo yɛɛ, kyingi.” ");
INSERT INTO acd_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Nfono nfono mɔ, ɔnyen mɔ o wuꞌ mɔ gi kyingi koso ɔ tɛ ɔ kya tɔngɛ. Ne Yesu gi kiiri mɔ kyu wɔra mɔ-nyi mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ibono Yesu gi kyingi ɔnyen mɔ mɔ, i wɔra asa abono mɛ bo nfono mɔ pɛwu gifuu. Mɛ yen Wurubuaarɛ kyu lii imɔ so. Mɛ san mɛ kya tɔgɛ ma‑a sa abara yɛɛ, “I korogɛ Wurubuaarɛ ikalan ɔtɔgɛbo gbaaꞌ saarɛ aye dɔ. Wurubuaarɛ gi ba de ɔꞌ baa laa mɔ-adɛ.” ");
INSERT INTO acd_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Yesu ilaa idɛ i kpaa nu gyanꞌ de Gyudiya gɛsinkpan so de gɛsinkpan gɛbono gɛ sindi nno mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ-lɛɛ akasɛbo mɛ kpaa buu ilaa ibono Yesu gi wɔra mɔ pɛwu sa mɔmɔ-ɔbelɛnsɛ. ");
INSERT INTO acd_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Ibono Gyɔn gi nu imɔ mɔ, ɔ terɛ mɔ-akasɛbo mɔ dɔ asa anyɔ ne o sun mɔmɔ Wura Yesu asɛ yɛɛ mɛꞌ kpaa taasɛ mɔ yɛɛ, “Fo ne n gyɛ asa ɔmɔlɛgɛbo ɔbono a nu yɛɛ ɔ laa ba mɔ abɛɛ aꞌ kerɛ nyamesɛ banban ɔko kpɛi ɔkpa daa?” ");
INSERT INTO acd_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Gyɔn isɔɔ mɔ mɛ kpe Yesu asɛ ne mɛ kpaa tɔgɛ sa mɔ yɛɛ, “Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ ne n sun aye fo asɛ faa. O sun aye de aꞌ baa taasɛ fo yɛɛ, ‘Fo ne n gyɛ asa ɔmɔlɛgɛbo ɔbono a nu yɛɛ ɔ laa ba mɔ abɛɛ aꞌ kerɛ nyamesɛ banban ɔko kpɛi ɔkpa daa?’ ” ");
INSERT INTO acd_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Pɛi de Gyɔn isɔɔ mɔ mɛ taasɛ Yesu gɛnen mɔ, mɛ wu Yesu gi kpɛ kyɛ asa sakyɔ alɔbi ta ne. Ɔ kyɛ dabɔlɛ de alɔtɔ abono aŋ boran a kya nyala asa gikyɔ gikyɔ mɔ. Ɔ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi ibono i tɛ asa ako so mɔ. O bugi agyaatanbo sakyɔ ansi, ne mɛ kii nyɛ mɛ kya wu ilaa. ");
INSERT INTO acd_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Yesu laa lɛɛ gɛnɔ sa Gyɔn isɔɔ mɔ mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kii kpe kpaa buu ilaa ibono fɛ baa nu de fɛye-aso de ilaa ibono fɛ wu de fɛye-ansi n kya wɔra faa sa Gyɔn. Nɛ yɛgɛ agyaatanbo ansi a bugi, ne ɔtɛgɛsɛana mɛ koso mɛ naa. Nɛ yɛgɛ akononbu alɔtɔ a ta, ne isintiribu mɛ kya nu ilaa. Nɛ kyingi abono mɛ wuꞌ mɔ ako. Ne nɛ tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ sa ayenbo. ");
INSERT INTO acd_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Imɔso omudɛnsɛbo ne n gyɛ nyamesɛ ɔbono mɔ-gisɔɔgyi gi maŋ koso me so mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Yesu gi tɔngɛ de Gyɔn isɔɔ mɔ ta ne mɛ kyon mɔ, o yii gɛsɛ ɔ kya tɔgɛ Gyɔn ilaa ɔ kya sa sakpii ɔbono ɔ bo mɔ asɛ nfono mɔ. Mɔ-gɛtɔngɛ mɔ dɔ mɔ, ɔ taasɛ sakpii mɔ yɛɛ, “Owi ɔbono fɛ kpe Gyɔn asɛ gipen dɔ kpaa nu mɔ-ilaa tɔgɛsɛ mɔ mɔ, menɛ isa ɔnan ne fɛ kpe fɛꞌ kpaa kerɛ daa? Fɛ wu mɔ mɔ, ɔ dɛ fɛɛ gifɛdaa ne afuu a kya da gimɔ a kya kpe a kya ba abɛɛ? ");
INSERT INTO acd_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne ɔŋ dɛ gɛnen mɔ, nnɛ ne ɔ dɛ? Fɛ wu o bun gikuru dɛnsɛ? Kuaa, asa abono mɛ kya bun akuru dɛnsɛ ne mɛ kyoola mɔ mɛ kya kyena daa awura nten dɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Imɔso fɛ kpe Gyɔn asɛ mɔ, menɛ isa ɔnan ne fɛ kpe de fɛꞌ kpaa kerɛ daa? Wurubuaarɛ ikalan ɔtɔgɛbo abɛɛ? Wurubuaarɛ ikalan ɔtɔgɛbo ne fɛ kpaa wu gɛsintin. N kya buu mi‑i sa fɛye yɛɛ ɔ don gɛnen gbaa. ");
INSERT INTO acd_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Gyɔn ne n gyɛ Wurubuaarɛ ɔsɔɔ ɔbono mɛ ŋmarasɛ mɔ-ilaa yela Wurubuaarɛ agyɛbi dɔ yɛɛ Wurubuaarɛ laa sun mɔ de ɔꞌ gyangbara kpaa tɔgɛ sa asa yɛɛ mɛꞌ lɔrɔ mɔmɔ-gɛkyena dɔ gyoo me ɔbono nan baa mɔlɛgɛ asa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","“N kya tɔgɛ fɛye yɛɛ iŋ ti korogɛ nyamesɛ ɔbono ɔ don Gyɔn baarɛ mɔ. Abono, mɔ, mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi lii nperɛ kyu kyon mɔ, mɔmɔ dɔ ɔbono ɔŋ fo sɛi gbaa mɔ laa don Gyɔn. ");
INSERT INTO acd_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Asa abono pɛwu mɛ kpaa nu Gyɔn ilaa tɔgɛsɛ mɔ de lɛnpoo asɔɔbo abono fɛ kya kyu mɔmɔ yɛɛ mɛ gyɛ asa nyɛnyɛn mɔ gbaa mɛ sɔɔ kyule yɛɛ Wurubuaarɛ ilaa ibono Gyɔn gi tɔgɛ mɔ i gyɛ gɛsintin, ne mɛ yɛgɛ Gyɔn gi gyere mɔmɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Farasii gikpen mɔ dɔ asa de Gyuda awura nbara aŋmarasɛbo mɔ berɛ, mɛ nu Wurubuaarɛ gɛlaarɛ ilaa ibono Gyɔn gi tɔgɛ mɔmɔ mɔ, mɛŋ sɔɔ kyule, ne mɛ kine yɛɛ Gyɔn maŋ nyɛ gyere mɔmɔ Wurubuaarɛ sagyere.” ");
INSERT INTO acd_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Yesu gi kii taasɛ sakpii mɔ yɛɛ, “Menɛtɔ gbaa ne nan nyɛ kyu kɛserɛ de ndɛ asa adɛ ne? Nnɛ ne mɛ dɛ daa?” ");
INSERT INTO acd_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Yesu gi taasɛ gɛnen ne o kii lɛɛ gɛsɛ sa sakpii mɔ yɛɛ, “Ndɛ asa mɔ mɛ dɛ fɛɛ nbii ne n kpaa gyanꞌ sansana. Mɛ gyanꞌ gɛnen mɔ, nfono mɔ, mɛ kya tɔgɛ mɛ kya sa abara yɛɛ, ‘A lan akɔrɛ ne a bii ilon sa fɛye mɔ, fɛ kine, fɛŋ kyaa. A kpen saawo bii lɛwu ilon de fɛꞌ saawo mɔ, fɛ kine, fɛŋ saawo.’ ” ");
INSERT INTO acd_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Yesu gi lɛɛ gɛsɛ yɛɛ, “Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ gi ba gɛsinkpan so mɔ, ɔ kya ŋminde gɛnɔ belen-belen ne ɔ mɛŋ kya nun nta. Imɔso fɛ tɔgɛ yɛɛ, ‘Ilaa nyɛnyɛn oduduu ne n tɛ mɔ so.’ ");
INSERT INTO acd_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, mɔ, nɛ ba gɛsinkpan so faa, n kya gyi n kya nun. Imɔso fɛ kya tɔgɛ yɛɛ, ‘Kerɛ, ɔnyen baarɛ! Ogyibelɛbo de nta nunbo ne ɔ gyɛ. Mɔ-kyɛmenɛana ne n gyɛ lɛnpoo asɔɔbo de ilaa nyɛnyɛn awɔrabo sɛnsɛ.’ Fɛŋ nu ndɛ asa ilaa tɔgɛsɛ?” ");
INSERT INTO acd_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ne Yesu gi kii tɔgɛ bɔla yɛɛ, “Abono mɛ buu ɔlaako ginyi ɔkpa mɔ berɛ ne nan lɛɛ gimɔ-gɛwi nyiile yɛɛ gi gyɛ ɔlaako ginyi gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Owi ɔko dɔ mɔ, Farasii gikpen mɔ dɔ ɔnyen ɔko gi sun kpaa terɛ Yesu yɛɛ ɔꞌ ba mɔ-gɛten dɔ de mɔ‑rɛ mɔ mɛꞌ gyi dabɔlɛ. Yesu gi kpe ne ɔ kpaa kyena saarɛ abono mɛ tɛ ogyiten mɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Ɔkyii ɔko bo ɔsowolɛ ɔbono so. Asa pɛwu mɛ nyi mɔ so yɛɛ mɔ-gɛkyena dɔ mɔ ɔ gyɛ ilaa nyɛnyɛn ɔwɔrabo. Gɛnen ɔkyii baarɛ gi nu yɛɛ Yesu tɛ Farasiinyen mɔ gɛten dɔ ɔ kya gyi mɔ, o kpe gɛten mɔ dɔ. Yesu gi wolaa kyu ɔkyii mɔ ilaa nyɛnyɛn ibono ɔ wɔra Wurubuaarɛ mɔ kyɛɛ mɔ. Ɔkyii mɔ kya kpe mɔ, ɔ dɛ anuwanterɛ de puruntuwa. ");
INSERT INTO acd_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ɔkyii mɔ gi loo gɛten mɔ dɔ mɔ, o kyu de Yesu gɛmara-gɛmara kpe Yesu ayaa asɛ. Ɔ kya nyingi gitolon gibono Yesu gi su mɔ mɔ, i wɔra mɔ ɔkon, ne i kii kyu wɔra mɔ gisu. O sii ŋmii mɔ-ayaa dɔ ne o su gɛnen‑n kaaborɛ mɔ-ansikyu a palɛ Yesu ayaa, ne o kyu mɔ-gimu iman kyu kpaarɛ Yesu ayaa. Ɔ kpɛ ɔ kya faala mɔ lii mɔ-gisen dɔ, ne o kyu anuwanterɛ mɔ ɔ dɛ mɔ kyu kyɛɛgɛ worogɛ Yesu ayaa so. ");
INSERT INTO acd_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Farasiinyen ɔbono ɔ da gibaa terɛ Yesu mɔ gi wu ibono ɔkyii mɔ gi wɔra gɛnen mɔ, ɔ tɔgɛ sa mɔ-nyoro yɛɛ, “Ɔkyii ɔbono ɔ kya pusaa ɔnyen baarɛ faa gyɛ daa ilaa nyɛnyɛn ɔwɔrabo. Nengyene fɛɛ ɔnyen baarɛ gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo gɛsintin mɔ, ɔfaanan ɔ laa bii nyamesɛ ɔbono ɔnan ɔkyii baarɛ gyɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Farasiinyen mɔ kya tɔgɛ ɔ kya sa mɔ-nyoro gɛnen mɔ, Yesu gi bii. Imɔso Yesu gi tɔgɛ sa mɔ yɛɛ, “Simon, n bo ilaa iko n kya laarɛ nꞌ tɔgɛ sa fo.” Ne Simon gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, tɔgɛ me, n kya nu.” ");
INSERT INTO acd_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Nfono ne Yesu gi da mɔ gikpalɛ yɛɛ, “Asa anyɔ ako mɛ dɛ aterenbi wura ɔko gikɔ. Ɔko dɛ mɔ gikɔ belɛ fɛɛ gɛsun ɔwɔrabo aterenbi abono ɔ laa nyɛ gɛsi dɔ mɔ. Ne ɔko, mɔ, dɛ mɔ gikɔ pi‑i fɛɛ gɛsun ɔwɔrabo aterenbi abono ɔ laa nyɛ bosɛ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Ɔ yela mɔmɔ owi ɔbono mɛ laa kyu baa ka mɔ mɔ. Owi mɔ gi fo ne mɛ mɛŋ kya taalɛ de mɛꞌ ka mɔ mɔ, o kyu kyɛɛ mɔmɔ asa anyɔ.” Yesu gi da gikpalɛ mɔ ta mɔ, ɔ taasɛ Simon yɛɛ, “Mɔmɔ asa anyɔ adɛ dɔ mɔ, ɔmɔ ne nan laarɛ aterenbi wura mɔ ilaa gikyɔ don mɔ-nanbo?” ");
INSERT INTO acd_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simon gi lɛɛ gɛnɔ yɛɛ, “Itɛfaa i laa wɔra ɔbono mɔ-lɛɛ gikɔ gi nyaakyɔ mɔ.” Simon gi lɛɛ gɛnɔ gɛnen mɔ, Yesu gi tɔgɛ sa mɔ yɛɛ, “I kyena.” ");
INSERT INTO acd_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Nfono mɔ, Yesu gi tɔgɛ sa Simon yɛɛ, “Gɛnen ne fo‑rɛ ɔkyii baarɛ ilaa i dɛ faa. Nyamesɛ ilaa nyɛnyɛn i dɛ fɛɛ gikɔ ne ɔ dɛ Wurubuaarɛ. Me n gyɛ isafo ne nɛ ba fo-gɛten dɔ. Nɛ ba faa, fo mɛŋ yɛgɛ mɛꞌ sa me nkyu de nꞌ foro me-ayaa. Ɔkyii baarɛ, mɔ, mɔ-ansikyu ne o kyu foro me-ayaa, ne o kyu mɔ-gimu iman lɛɛ me-ayaa nkyu. ");
INSERT INTO acd_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Fo faala me mɔ, foŋ da me gya-gya; ɔkyii baarɛ berɛ, lii aberɛ abono ɔ ba gɛrɛnaa faa, ɔ kpɛ ɔ dɛ daa me-ayaa dɔ ɔ kya faala me lii mɔ-gisen dɔ. ");
INSERT INTO acd_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Fo mɛŋ worogɛ me-gimu nfɔ sa me. Ɔkyii baarɛ, mɔ, anuwanterɛ ne o kyu worogɛ me-ayaa gbaa. ");
INSERT INTO acd_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nꞌ tɔgɛ fo yɛɛ mɔ-ilaa nyɛnyɛn ibono i nyaakyɔ ne nɛ kyu kyɛɛ mɔ mɔ ne n yɛgɛ ɔ nyɛ gɛlaarɛꞌ belɛ sa me faa. Isa ɔbono, mɔ, mɔ-ilaa nyɛnyɛn iŋ kyɔ ne ɔko gi kyu kyɛɛ mɔ mɔ, gɛlaarɛꞌ pi‑i ne ɔ laa nyɛ sa kaasɛ kee.” ");
INSERT INTO acd_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Yesu gi kisee tɔgɛ sa ɔkyii mɔ yɛɛ, “Ɔkyii, fo wɔra Wurubuaarɛ ilaa nyɛnyɛn, ne nɛ kyu kyɛɛ fo.” ");
INSERT INTO acd_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Nfono mɔ, abono mɔ‑rɛ ɔmɔ mɛ tɛ ogyiten mɔ mɛ san mɛ kya taasɛ abara yɛɛ, “Mɔ ne n gyɛ anɛ de ɔꞌ taalɛ kyu asa ilaa nyɛnyɛn ibono mɛ wɔra Wurubuaarɛ mɔ kyɛɛ mɔmɔ?” ");
INSERT INTO acd_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Yesu gi kii tɔgɛ sa ɔkyii mɔ yɛɛ, “Gɛnɔɔbono fo sɔɔ me gyi mɔ ne n mɔlɛgɛ fo faa. Imɔso naa fo kya kpe de gisen yuuli.” ");
INSERT INTO acd_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Imɔ idɛ gɛmara mɔ i mɛŋ kɛɛla ne Yesu gi naa de isowolɛ belɛ-belɛ de iburu-buru so ɔ kya lɛɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ɔ kya tɔgɛ asa de mɛꞌ nu Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa. Yesu naa de isowolɛ mɔ so gɛnen mɔ, mɔ-akasɛbo gudu anyɔ mɔ mɛ buu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Akyii ako kee mɛ buu ɔmɔ. Ɔ wolaa gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso gɛnen akyii abono ako so ne ɔ kyɛ mɔmɔ ako alɔbi kee. Mɔmɔ dɔ ɔko ne n gyɛ Mariya Magadalakyii. Ɔkyii baarɛ so ne Yesu gi naa kyena gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi sono koso mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Akyii mɔ dɔ ɔko kee ginyen ne n gyɛ Gyowana. Gyowana mɔ-kuli ne n gyɛ Kyusa ɔbono ɔ kya kerɛ Wura Hɛrodɛ gɛten de mɔ-ilaa so mɔ. Mɛ kya terɛ akyii mɔ dɔ ɔko kee yɛɛ Susana. Akyii sakyɔ ako kee mɛ buu Yesu. Mɛ naa mɛ naa gɛnen mɔ, akyii adɛ mɛ dɛ mɔmɔ gbaa-gbaa aterenbi mɛ kya kpaa Yesu mɔ‑rɛ mɔ-akasɛbo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Asa mɛ kpɛ ma‑a lii ma‑a lii isowolɛ so ma‑a ba Yesu asɛ. Sakpii mɔ gi nyaakyɔ mɔ, ɔ da gikpalɛ gidɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Dɔɔbo ɔko gi kyena. Owi ɔko dɔ mɔ, ɔ koso kpe ndɔɔ kpaa ŋmadɛ ayu. Ɔ kya ŋmadɛ ayu mɔ, ako a tɔrɔ ɔkpa dɔ, ne asa mɛ kyise-kyise amɔ ne nbuii mɛ baa tɔɔsɛ amɔ gyi. ");
INSERT INTO acd_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ayu mɔ ako, mɔ, a tɔrɔ kpandan so. A kɔrɔ lii mɔ, a kii wuꞌ. I nyiile yɛɛ gɛsinkpan mɔ nfono iŋ bo isɛ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ako kee a tɔrɔ iwe dɔ. Abono a kɔrɔ mɔ, iwe mɔ i koso bun wɔra amɔ, ne a wuꞌ. ");
INSERT INTO acd_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Amɔ ako, mɔ, a tɔrɔ gɛsinkpan dɛnsɛ so. Amɔ berɛ, a kɔrɔ ne a sen da amu kanpɛ. Dɔɔbo mɔ gi kɛbi amɔ mɔ, ɔ nyɛ ibono ɔnan o kyu ŋmadɛ mɔ, gikpadɔ ikue-inun.” Yesu gi da gikpalɛ mɔ ta mɔ, ɔ tɔgɛ sakpii mɔ yɛɛ, “Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Yesu akasɛbo mɔ mɛ taasɛ mɔ gikpalɛ mɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ne Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛye ne n gyɛ abono Wurubuaarɛ laa lɛɛ mɔ-gɛwuragyi dɔ akyenabi mɔ ilaa boduduusɛ nyiile. Asɛnsɛ mɔ berɛ, n kya tɔgɛ sa ɔmɔ daa akpalɛ dɔ de iꞌ nyɛ kyena de ilaa ibono i bo Wurubuaarɛ agyɛbi mɔ dɔ mɔ. I bo nno yɛɛ, ‘mɛ laa kpɛ mɛ kya kerɛ, mɛ maŋ kii wu sɛi; mɛ laa kpɛ mɛ kya nu ilaa, mɛ maŋ kii nu gɛsɛ.’ ");
INSERT INTO acd_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Fɛꞌ nu gikpalɛ mɔ gɛsɛ kon. Ayu abono dɔɔbo mɔ gi ŋmadɛ mɔ ne n gyɛ Wurubuaarɛ agyɛbi. ");
INSERT INTO acd_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Abono a tɔrɔ ɔkpa dɔ mɔ, a dɛ fɛɛ asa abono mɛ kya nu Wurubuaarɛ agyɛbi mɔ ne ilaa nyɛnyɛn pɛwu gɛmu mɔ kya baa lɛɛ amɔ lii ɔmɔ-asen dɔ mɔ. Ilaa nyɛnyɛn gɛmu mɔ mɛŋ kya laarɛ de mɛꞌ nyɛ sɔɔ agyɛbi mɔ gyi de Wurubuaarɛ ɔꞌ mɔlɛgɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ayu abono a tɔrɔ kpandan so ne amɔ-ilin i mɛŋ nyɛ isɛ loo gɛsɛ mɔ a dɛ fɛɛ asa abono mɛ nu Wurubuaarɛ agyɛbi mɔ, ne mɛ nu gɛsɛ de ɔkon, yɛgɛ mɛ mɛŋ kya kyu amɔ wɔra mɔmɔ-asen dɔ mɔ. Mɛ kya sɔɔ amɔ gyi ŋmaraa, ne ɔgɛnda ɔko gi tu mɔmɔ mɔ, fo baa kerɛ mɔ, mɛ kya luu nyoro. ");
INSERT INTO acd_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ayu abono a tɔrɔ iwe dɔ mɔ a dɛ fɛɛ asa abono mɛ kya nu Wurubuaarɛ agyɛbi mɔ, ne gɛsinkpan gɛdɛ so nsuiili, aterenbi gilaarɛ, de anyamesɛ ɔbolɛ gɛlaarɛ ilaa i kya gyi ɔmɔ-amu mɔ. Imɔso mɛŋ kya kpe ansi dɔ de mɛꞌ wɔra agyɛbi mɔ so ilaa mɔmɔ-gɛkyena dɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ayu abono a tɔrɔ gɛsinkpan dɛnsɛ so mɔ berɛ, a dɛ fɛɛ asa abono mɛ kya kyu gɛsintin de gisen dɛnsɛ kyu nu Wurubuaarɛ agyɛbi mɔ. Mɛ nu amɔ mɔ, mɛ kya sɔɔ amɔ wɔra mɔmɔ-amu dɔ de mɛꞌ nyɛ gisen mɛ kya wɔra amɔ so ilaa mɔmɔ-gɛkyena dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Yesu gi kii da sakpii mɔ gikpalɛ yɛɛ, “Ɔko mɛŋ bo no ɔ laa nyɔga fatela de oꞌ kyu ŋara gɛlɔbi dɔ, abɛɛ oꞌ kyu wɔra npa gɛsɛ. Ɔ laa kyu mɔ kyɔlɔga daa de iꞌ nyɛ wu asa abono mɛ laa baa loo mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Sɛi mɛŋ bo no i bo ɔbɔ dɔ yɛɛ i maŋ lii gifuli, abɛɛ ilaa iko i ŋara yɛɛ i maŋ lii gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Imɔso ibono fɛ kya nu Wurubuaarɛ ilaa faa, fɛꞌ kerɛ imɔ so dɔɔdan. I kya nyiile yɛɛ ɔbono ɔ kya nu Wurubuaarɛ asɛ mɔ, ɔ laa nyɛ nu too. Ne ɔbono, mɔ, ɔŋ kya nu Wurubuaarɛ asɛ mɔ, ipii ibono o nu mɔ gbaa, i laa kii lii mɔ-gimu dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Gɛnen aberɛ abono mɔ Yesu mɔ-nyi de mɔ-tedɛana mɛ ba mɔ asɛ nno. Sakpii mɔ so mɔ, mɛ mɛŋ nyɛ ɔkpa tu sindi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Nfono mɔ, ako mɛ buu sa mɔ yɛɛ, “Fo-nyi de fo-tedɛana mɛ yelɛ nŋmaŋman mɛ kya laarɛ mɛꞌ wu fo.” ");
INSERT INTO acd_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Yesu gi lɛɛ gɛnɔ tɔgɛ sa mɔmɔ yɛɛ, “Me-nyi de me-tedɛana ne n gyɛ asa abono mɛ nu Wurubuaarɛ agyɛbi mɔ ne mɛ kya wɔra amɔ so ilaa mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Gɛkɛ gɛdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɛ bo ɔbon belɛ mɔ asɛ mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Aꞌ fara kpe gibenbɛ.” Gɛsintin mɔ, mɛ dii loo gikolii dɔ ne mɛ yii ɔkpa. ");
INSERT INTO acd_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mɛ kya kpe mɔ, Yesu gi dɛ ginsi gidɛ gikolii mɔ dɔ. Nfono mɔ, afuu belɛ ako a tigi, a kya da ginyadon so. A kya yɛgɛ nkyu mɔ gi kya loo gi kya bɔla gikolii mɔ, ne gɛnsipɛɛrɛ gɛ tu ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Mɛ da Yesu kyingi mɛ kya tɔgɛ mɔ yɛɛ, “Ɔbelɛnsɛ, Ɔbelɛnsɛ, a kya laarɛ de aꞌ sii!” Yesu gi kyingi mɔ, ɔ koso ne ɔ tɔgɛ afuu mɔ yɛɛ aꞌ taa gida yɛgɛ de nkyu nbono gi kya koso mɔ, mɔ, giꞌ wɔra bɔyin. Gɛsintin mɔ, afuu mɔ a taa gida yɛgɛ, ne ilaa kamaasɛ i sii kurun. ");
INSERT INTO acd_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Nfono mɔ, ɔ taasɛ mɔ-akasɛbo mɔ yɛɛ, “Gisɔɔgyi gibono fɛye yɛɛ fɛ bo sa me mɔ gi bo fonɛ dɔ daa?” Yesu akasɛbo mɔ mɛ wu ilaa ibono ɔ wɔra mɔ, i wɔra mɔmɔ gifuu ne i wɔra mɔmɔ giyan. Mɛ san mɛ kya taasɛ abara yɛɛ, “Menɛ nyamesɛ ɔnan ne? Kerɛ, ɔ kya tɔngɛ sa afuu de nkyu gbaa ne i kya nu mɔ gɛdɛ.” ");
INSERT INTO acd_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kii palɛ gikolii mɔ kpaa fo Gerigasa awura gɛsinkpan so. Fo lii Galeli gɛsinkpan so mɔ, mɔmɔ-gɛsinkpan gɛ bo ɔbon belɛ mɔ gibenbɛ giko mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Yesu gi lii gikolii mɔ dɔ dii gyanꞌ gigengen mɔ, ɔsowolɛ mɔ so ɔnyen ɔko gi baa gyangara mɔ. Ilaa nyɛnyɛn oduduu i tɛ gɛnen ɔnyen ɔbono so, i yɛgɛ ɔ san ɔ naa daa gibolonbukpan, ne ɔŋ baa ɔ tɛ nten dɔ. Ibuni opuleten ne ɔ san ɔ tɛ gɛkpaa-gɛkpaa. I wɔra mɔ gɛnen mɔ, i kɛɛla. ");
INSERT INTO acd_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","O wu Yesu mɔ, Yesu gi tɔgɛ ilaa nyɛnyɛn oduduu mɔ yɛɛ iꞌ koso lii ɔnyen mɔ so, ɔ kerɛ imɔ faa. Nfono mɔ ilaa nyɛnyɛn oduduu mɔ i yɛgɛ ɔnyen mɔ gi saawo kpaa gyaa ŋmii Yesu ansi dɔ, ne i kpen ken-ken taasɛ Yesu yɛɛ, “Yesu, Wurubuaarɛ Gitɔbelɛ mɔ-bi, menɛ ne fo kya laarɛ foꞌ wɔra me? N kya kolɛ fo, gɛŋ wɔra me awɔrɔfɔɔ.” Pɛi de Yesu mɔ‑rɛ ɔnyen mɔ mɛꞌ gyanꞌ gɛnen mɔ, ilaa nyɛnyɛn oduduu mɔ i kya kyena ba ɔnyen mɔ so belen-belen. I ba mɔ so mɔ, asa mɛ kya kyu agbangbaran ŋminde mɔ abɛɛ mɛ kya da mɔ ilaran yela, ne mɛ kya dii mɔ de ɔŋ sa ɔꞌ nyɛ kpaa wɔra ilaa iko. Ilaa nyɛnyɛn oduduu mɔ ɔlon so mɔ, ɔ kya wolaa gbaa gbaa agbangbaran mɔ fuɛ, de iꞌ kparɛ mɔ kyu lii kpe gipen dɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ɔnyen mɔ gi kpen gɛnen mɔ, Yesu gi taasɛ mɔ yɛɛ, “Mɛ kya terɛ fo-ginyen yɛɛ menɛ?” Ilaa nyɛnyɛn oduduu mɔ i tɛ ɔnyen mɔ so mɔ i lɛɛ gɛnɔ sa Yesu yɛɛ, “Mɛ kya terɛ me yɛɛ Sakpii.” I kya nyiile yɛɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi gikyɔ ne n tɛ ɔnyen mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ilaa nyɛnyɛn oduduu mɔ i kpɛ i kya kolɛ Yesu yɛɛ ɔꞌ mɛŋ sa ɔꞌ gya imɔ koso lii ɔnyen mɔ so kyu kpe nfono Wurubuaarɛ kya tii ilaa nyɛnyɛn oduduu kpɛi-kpɛi wɔra ɔbɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Akuuri gikpen giko gi yelɛ gibii giko alan dɔ nfono, mɛ kya gyi. Ilaa nyɛnyɛn oduduu ibono i tɛ ɔnyen mɔ so mɔ i kolɛ Yesu yɛɛ nengyene ɔ laa gya imɔ koso mɔ, ɔꞌ yɛgɛ de iꞌ kpaa kyena akuuri mɔ so. Ne Yesu gi sa imɔ ɔkpa. ");
INSERT INTO acd_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Imɔso i koso lii ɔnyen mɔ so kpaa kyena akuuri mɔ so. Ne akuuri gikpen mɔ pɛwu gi selɛ kpelegɛ de gibii mɔ kpaa loo ɔbon belɛ mɔ dɔ, ne nkyu mɔ gi gyi mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Anyen abono mɛ kya kerɛ akuuri mɔ so mɔ mɛ wu ilaa ibono i ba mɔ pɛwu. Imɔso mɛ selɛ kpe ɔsowolɛ mɔ so de ndɔɔana dɔ mɔ kpaa buu ilaa idɛ sa asa. ");
INSERT INTO acd_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Gɛnen so mɔ, asa mɔ mɛ kpaa wu ilaa ibono i ba mɔ de ansi. Mɛ ba Yesu asɛ mɔ, mɛ wu ɔnyen ɔbono ilaa nyɛnyɛn oduduu mɔ i koso mɔ so mɔ. O bun gikuru, ɔ nyɛ mɔ-ginyamesɛ gɛwɔnsa, ɔ tɛ Yesu gilan dɔ ɔ kya nu mɔ asɛ. I wɔra asa mɔ gifuu, ne i dɛ mɔmɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Abono mɛ wu ilaa kamaasɛ de ansi mɔ mɛ buu gɛnɔɔbono Yesu gi kyu mɔlɛgɛ ɔnyen mɔ mɔ pɛwu sa abono mɛ selɛ baa tu mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Mɛ nu imɔ mɔ, mɔmɔ Gerigasa awura mɔ pɛwu mɛ kolɛ Yesu yɛɛ ɔꞌ lii mɔmɔ-gɛsinkpan so. I lii fɛɛ Yesu ilaa mɔ i don wɔra mɔmɔ gifuu gikyɔ. Gɛsintin mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ dii loo gikolii dɔ de mɛꞌ kii. ");
INSERT INTO acd_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Mɛ kya laarɛ mɛꞌ kii mɔ, ɔnyen ɔbono Yesu gi kosorɛ ilaa nyɛnyɛn oduduu mɔ lii mɔ so mɔ gi kolɛ Yesu yɛɛ, “Yɛgɛ me nꞌ buu fo de nꞌ kpaa kyena fo asɛ.” Yesu mɔ mɛŋ kyule sa mɔ. Ɔ tɔgɛ mɔ daa yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Kii kpe fo-gɛwi de foꞌ kpaa tɔgɛ ilaa gbaaꞌ ibono Wurubuaarɛ gi wɔra sa fo faa sa fo-gɛwi awura.” Gɛsintin mɔ, ɔnyen mɔ gi kii kpe mɔ-gɛwi, ne ɔ naa gyanꞌ de ɔsowolɛ mɔ ɔ kya tɔgɛ ilaa gbaaꞌ ibono Yesu gi wɔra sa mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Yesu gi kii kpe ɔbon belɛ mɔ gigengen gibono so ɔ daa gilii mɔ. Ɔ baa loo nno mɔ, sakpii belɛ ti ɔ yelɛ ɔ gyoo mɔ mɛ kya faala mɔ mɔ‑rɛ ginaa-naa. ");
INSERT INTO acd_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Ɔnyen ɔko gi ba Yesu asɛ nno. Mɛ kya terɛ mɔ-ginyen yɛɛ Gyarasɛ. Ɔ gyɛ ɔbelɛnsɛ ɔbono ɔ kya kerɛ Gyuda awura gikyangbon giko so. Gɛnen ɔnyen baarɛ gi baa kpelegɛ ŋmii Yesu ayaa dɔ, ne ɔ kolɛ mɔ yɛɛ ɔꞌ wɔra aniya, ɔꞌ yɛgɛ mɛꞌ kpe mɔ-gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","I kya nyiile yɛɛ gɛbii kolon ne ɔ korogɛ; gɛ gyɛ daa ɔkyii. Gɛ gyi fɛɛ nsi gudu nnyɔ. Gɛ kya lɔ gɛ kya laarɛ gɛꞌ wu. O buu sa Yesu gɛnen mɔ, Yesu gi nu mɔ asɛ, ne ɔ naa buu mɔ. Mɛ kya kpe mɔ, asa mɛ kya kpiidɛ de Yesu. ");
INSERT INTO acd_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ɔkyii ɔko bo ɔmɔ dɔ. I kya da de mɔ. I kya da de mɔ mɔ, imɔ nsi gudu nnyɔ ne. Ɔ nyida aterenbi abono ɔ bo mɔ pɛwu kpe-kpe alɔtɔ akyɛbo asɛ; mɔmɔ ɔko‑rɛ ɔko mɛŋ taalɛ kyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Gɛnen ɔkyii baarɛ kya laarɛ mɔ-gilɔ mɔ giꞌ ta so mɔ, o kyu de Yesu gɛmara gɛmara kpaa yii Yesu gɛgbɛ ginɛbi. Ayaa abono so mɔ, ibono i kya da de mɔ mɔ, i ten. ");
INSERT INTO acd_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ɔkyii mɔ gi yuuri kpaa yii Yesu gɛnen mɔ, Yesu gi dɛsɛ, ne ɔ taasɛ yɛɛ, “Anɛ ne n yii me mɔ?” Ɔkamaasɛ kya kine yɛɛ iŋ gyɛ mɔ ne n yii mɔ, ne Piita gi taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, sakpii ɔbono ɔ kyaabɔɔ fo mɛ kya kpiidɛ de fo faa mɔ, fo kya tɔgɛ yɛɛ ɔko gi yii fo?” ");
INSERT INTO acd_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Ɔko gi yii me. I kya nyiile yɛɛ nɛ bii me-nyoro dɔ yɛɛ me-oduduu gi wɔra ilaa iko.” ");
INSERT INTO acd_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ɔkyii mɔ gi wu yɛɛ ibono o yii Yesu mɔ i mɛŋ ŋara mɔ. Imɔso ɔ lii baa ŋmii Yesu ayaa dɔ, ɔ kya seli faa gyin-gyin. Ɔ tɔgɛ ilaa ibono so o yii mɔ mɔ de gɛnɔɔbono i kpɛ kyɛ mɔ ayaa abono so mɔ asa mɔ pɛwu ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Nfono ne Yesu gi tɔgɛ mɔ yɛɛ, “Me-bi, gisɔɔgyi gibono fo bo sa me mɔ ne n kyɛ fo faa. Imɔso naa fo kya kpe de gisen yuuli.” ");
INSERT INTO acd_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Yesu san ɔ yelɛ ɔ kya tɔngɛ mɔ, ɔko gi lii Ɔbelɛnsɛ Gyarasɛ gɛten dɔ baa tɔgɛ sa Gyarasɛ yɛɛ, “Fo-bi mɔ gi wuꞌ. Imɔso gɛŋ baa nyala ɔbelɛnsɛ mɔ yɛɛ ɔꞌ baa kyɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Yesu gi nu imɔ idɛ mɔ, o kisee tɔgɛ sa Gyarasɛ yɛɛ, “Gɛŋ sa foꞌ selɛ gifuu. Fo berɛ, kpɛ sɔɔ me gyi, ne gɛ laa kii nyɛ nkpa kyena sa fo.” ");
INSERT INTO acd_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Yesu gi kpaa loo Gyarasɛ gɛten dɔ mɔ, ɔ mɛŋ yɛgɛ de asa mɛꞌ nyɛ loo obu mɔ dɔ obuni mɔ asɛ baa too de mɔ‑rɛ Piita, Gyɔn, de Gyeemesi, de gɛbii mɔ mɔ-sɛ de mɔ-nyi. ");
INSERT INTO acd_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Asa abono mɛ bo nno mɔ pɛwu mɛ dɛ osulon mɛ yelɛ. Mɛ kya yiyɛɛ gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛŋ baa saawo. Gɛbii mɔ gɛŋ wuꞌ. Gɛ dɛ daa.” ");
INSERT INTO acd_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Ɔ tɔgɛ gɛnen mɔ, mɛ kyu mɔ ŋmasɛ daa. Mɛ nyi ibono gɛbii mɔ gɛ wuꞌ gɛsintin. ");
INSERT INTO acd_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Yesu, mɔ, mɛŋ taa ka ɔmɔ gɛnɔ. Ɔ keda gɛbii mɔ gibaa dɔ ne ɔ tɔgɛ sa gɛmɔ yɛɛ, “Gɛbii, koso.” ");
INSERT INTO acd_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Yesu gi tɔgɛ sa gɛbii mɔ gɛnen mɔ, o kiiri gɛmɔ-ɔŋɛ baa wɔra gɛmɔ dɔ. Ayaa abono so mɔ gɛ koso, ne Yesu gi tɔgɛ yɛɛ, “Fɛꞌ laarɛ ilaa iko sa gɛmɔ de gɛꞌ gyi.” ");
INSERT INTO acd_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","I dɛ gɛbii mɔ mɔ-nyi de mɔ-sɛ gɛnɔ, ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ mɛ mɛŋ sa mɛꞌ tɔgɛ ilaa ibono i ba faa sa ɔko‑rɛ ɔko. ");
INSERT INTO acd_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yesu gi terɛ mɔ-isɔɔ gudu anyɔ mɔ baa gyanꞌ ne ɔ sa mɔmɔ ɔkpa de mɛꞌ kyu mɔ-ginyen de mɛꞌ nyɛ ɔlon ilaa nyɛnyɛn oduduu kpɛi-kpɛi pɛwu so. Gɛnen ɔlon mɔ laa yɛgɛ mɛ laa taalɛ kyɛ asa alɔtɔ kee. ");
INSERT INTO acd_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Ɔ sa mɔmɔ ɔlon mɔ gɛnen mɔ, ɔ keda mɔmɔ sun yɛɛ mɛꞌ naa tɔgɛ tɔgɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa sa asa de mɛꞌ kyɛ asa alɔbi. ");
INSERT INTO acd_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛ kya kpe faa, fɛŋ sa fɛꞌ puru sɛi-sɛi keda. Fɛ mɛŋꞌ puru ba‑a oyii tugɛsɛ, abɛɛ gidiiku, abɛɛ agyudɔ, abɛɛ aterenbi keda. Fɛ mɛŋꞌ puru gɛgbɛ giwɔra nyɔsɛ gbaa baa keda. ");
INSERT INTO acd_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Gɛten gɛbono dɔ fɛ loo ne mɛ kya kerɛ fɛye so mɔ, fɛꞌ kyena nno kaaborɛ fɛ laa lii gɛnen ɔsowolɛ ɔbono so. ");
INSERT INTO acd_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ɔsowolɛ ɔbono fɛ loo ne nno asa mɛ kine mɛ mɛŋ bugi ansi de fɛye mɔ, fɛ lii mɔmɔ-ɔsowolɛ mɔ so mɔ, fɛꞌ kpiisi fɛye-ayaa isɛ yela mɔmɔ. Imɔ ne nan yɛgɛ mɛꞌ bii yɛɛ mɛ kine Wurubuaarɛ ɔkalan mɔ faa mɔ, gisobiidɛ gi dɛ gi gyoo ɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Yesu gi sun mɔ-asunbo mɔ gɛnen mɔ, gɛsintin mɔ, mɛ yii ɔkpa ne mɛ naa de isowolɛ, ne gɛten kamaasɛ gɛbono mɛ kya kpe mɔ, mɛ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ne mɛ kya kyɛ asa alɔbi. ");
INSERT INTO acd_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Gɛnen owi ɔbono mɔ, Wura Hɛrodɛ gi nu ilaa ibono Yesu kya wɔra mɔ. O nu imɔ gɛnen mɔ, i wɔra mɔ giyan, ne ɔŋ kya bii imɔ dɔ. I lii fɛɛ asa mɛ kya tɔgɛ yɛɛ, “Oloobu Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ ne n kyingi lii ibuni dɔ ba gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ako mɔ yɛɛ, “Kuaa. Oloobu Ilaagya ne n kii ba.” Abanban, mɔ, yɛɛ, “Wurubuaarɛ ikalan atɔgɛbo adedaabo mɔ dɔ ɔko ne n kyingi lii ibuni dɔ kii ba gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Wura Hɛrodɛ-lɛɛ ibono ɔ tɔgɛ mɔ ne n gyɛ yɛɛ, “Nɛ yɛgɛ mɛ ten Gyɔn gimu. Ne anɛ, mɔ, ne n ba ɔ gyɛ ɔbono n kya nu mɔ so gɛnen faa?” Ne Wura Hɛrodɛ gi san ɔ kya laarɛ gɛnɔɔbono ɔ laa nyɛ wu Yesu de ansi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Yesu asunbo mɔ mɛ kpe nfono o sun mɔmɔ mɔ ne mɛ kii ba mɔ, mɛ baa buu ilaa ibono mɛ wɔra mɔ pɛwu sa mɔ. Mɛ buu sa mɔ ta mɔ, ɔ yɛgɛ mɔ‑rɛ mɔmɔ wolɛ mɛ kpe ɔsowolɛ ɔbono mɛ kya terɛ mɔ yɛɛ Bɛsayida mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Mɛ laa kpe mɔ, sakpii ɔbono ɔ bo mɔmɔ asɛ mɔ gi bii nfono mɛ kya kpe mɔ, ne mɛ buu mɔmɔ. Sakpii mɔ gi kpaa tu mɔmɔ mɔ, Yesu gi faala ɔmɔ, ne ɔ tɔgɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa sa mɔmɔ, ne ɔ kyɛ kyɛ abono mɔ mɛ kya lɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Owi gi kpelegɛ mɔ, Yesu akasɛbo gudu anyɔ mɔ mɛ kpaa tɔgɛ sa mɔ yɛɛ, “Lɛɛ sakpii mɔ ɔkpa de mɛꞌ naa kpe isowolɛ de ndɔɔana nbono gi sindi gɛrɛ mɔ de mɛꞌ kpaa laarɛ nten nko loo de mɛꞌ nyɛ agyudɔ gyi. Nfono a bo faa, i gyɛ daa ifɛ nsana.” ");
INSERT INTO acd_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “Fɛye gbaa-gbaa fɛꞌ sa mɔmɔ ilaa iko de mɛꞌ gyi.” Mɛ lɛɛ gɛnɔ yɛɛ, “Aye asɛ gɛrɛ mɔ, a bo daa ibodobodo inun de iken inyɔ. A laa taalɛ sɔɔ agyudɔ sa ginyamesɛbi gidɛ pɛwu?” ");
INSERT INTO acd_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Anyen abono mɛ bo gɛnen sakpii belɛ ɔbono dɔ mɔ gɛgyɔnɔ gɛ laa wɔra fɛɛ nwɛ ikue-inyɔ de saalaa. Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ yɛgɛ de asa mɔ mɛꞌ kpelegɛ kyena akpen-akpen; gikpen kamaasɛ dɔ asa mɛꞌ wɔra fɛɛ ikue-inyɔ de saalaa.” ");
INSERT INTO acd_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Gɛsintin mɔ, Yesu akasɛbo mɔ mɛ yɛgɛ asa mɔ pɛwu mɛ kpelegɛ kyena gɛsinkpan. ");
INSERT INTO acd_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Mɛ kyena gɛnen mɔ, Yesu gi puru ibodobodo inun mɔ de iken inyɔ mɔ, ne ɔ diirɛ mɔ-ansi kerɛ Wurubuaarɛ, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa-gbaa ibodobodo mɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ mɛꞌ kyu yɛ sa sakpii mɔ de mɛꞌ gyi. ");
INSERT INTO acd_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Mɛ yɛ sa mɔmɔ mɔ, mɔmɔ pɛwu mɛ nyɛ gyi kaabo kii san. Mɔ-akasɛbo mɔ mɛ koola agyisan mɔ mɔ, i bɔla nkeebii gudu nnyɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Owi ɔko dɔ mɔ Yesu kya dalaa mɔ wolɛ, ne mɔ-akasɛbo mɔ mɛ bo mɔ asɛ. Nfono mɔ ɔ taasɛ mɔmɔ yɛɛ, “Sakpii mɔ asɛ mɔ, menɛ nyamesɛ ne nꞌ gyɛ?” ");
INSERT INTO acd_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ne mɔ-akasɛbo mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Asa ako mɛ kya tɔgɛ yɛɛ fo gyɛ Oloobu Gyɔn ɔbono ɔ naa kyena gyere asa Wurubuaarɛ sagyere mɔ. Ako mɔ yɛɛ Kuaa! Fo ne n gyɛ Oloobu Ilaagya. Ne ako, mɔ, yɛɛ Wurubuaarɛ ikalan atɔgɛbo adedaabo mɔ dɔ ɔko kpɛi ne n kyingi lii ibuni dɔ ba gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nfono ne Yesu gi kii taasɛ mɔ-akasɛbo mɔ yɛɛ, “Ne fɛye asɛ mɔ de‑e? Menɛ nyamesɛ ɔnan ne nꞌ gyɛ?” Piita gi lɛɛ gɛnɔ yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Piita gi lɛɛ gɛnɔ gɛnen mɔ, Yesu gi ka sa ɔmɔ yɛɛ mɛ mɛŋ sa mɛꞌ tɔgɛ sa ɔko‑rɛ ɔko yɛɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi sun mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Yesu gi kii tɔgɛ sa ɔmɔ yɛɛ, “I gyɛ ilaa ibono i laa ba yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan wu ɔlaawusɛ kpɛi-kpɛi gikyɔ. Gyuda awura asunbi alɛɛbo abelɛnsɛ de nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ mɔ mɛ laa kine me, ne mɛ laa yɛgɛ asa mɛꞌ mɔɔ me. Mɛ mɔɔ me mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Nfono ne Yesu gi tɔgɛ sa mɔmɔ abono mɛ bo nno mɔ pɛwu yɛɛ, “Ɔbono ɔ kya laarɛ de ɔꞌ wɔra me-ɔkasɛbo mɔ, kaasɛ mɔ oꞌ kyu mɔ-nyoro fuɛ, gɛkɛ kamaasɛ mɔ oꞌ kyule wu awɔrɔfɔɔ me so, de ɔꞌ kasɛ me-gidebi. Ba‑a mɛ laa da mɔ aŋanbi oyii so mɔɔ mɔ, mɛꞌ da mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","I kya nyiile yɛɛ fo ɔbono fo laa kɔrɔsɛ fo-nkpa yela fo-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena ɔnan mɔ gɛ laa lii fo-gibaa. Ne fo ɔbono, mɔ, kyu lii me so ne fo-nkpa gi lii fo-gibaa mɔ, fo laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Fo nyamesɛ fo nyɛ gɛsinkpan gɛdɛ so ilaa kamaasɛ pɛwu gyanꞌ ne foŋ nyɛ ɔkpa kpe Wurubuaarɛ asɛ mɔ, fo nyi yɛɛ fo nyɛ gɛkyena ne? ");
INSERT INTO acd_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Nengyene i bo fo ɔko ipeeli yɛɛ fo gyɛ me-sonbo abɛɛ fo kya sɔɔ me-agyɛbi mɔ gyi mɔ, gɛnen kee ne i laa wɔra me, anyamesɛ pɛwu mɔmɔ-daa mɔ, ipeeli sa fo, gɛkaabono nan kii ba gɛsinkpan so mɔ. Gɛnen gɛkaabono mɔ, me-sɛ Wurubuaarɛ laa keda mɔ-isɔɔ sun, ne mɛ laa sun me ba de nyisigyi. Wurubuaarɛ laa kyu mɔ-lɛɛ nyisigyi ɔnan kyu sa me de asa mɛꞌ wu de ansi. ");
INSERT INTO acd_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fɛye abono fɛ yelɛ gɛrɛnaa faa fɛ maŋ wuꞌ ta pɛi de fɛꞌ lɔɔ wu yɛɛ Wurubuaarɛ gɛwuragyi gɛkyena mɔ gɛ ba anyamesɛ dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Yesu gi tɔgɛ gɛnen ilaa idɛ mɔ, fɛɛ nkɛ gukue gɛmara mɔ, o kyu Piita de Gyɔn de Gyeemesi, ne mɛ dii kpe gibii giko so de ɔꞌ kpaa dalaa. ");
INSERT INTO acd_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ɔ kya dalaa gɛnen mɔ, mɔ-ansi dɔ i kyɛɛgɛ kii lɔrɔ wɔra ɔdan too ne mɔ-ngbɛ nbono o suu mɔ gi fuuli gi kya ŋɛlegi faa ŋela-ŋela-ŋela. ");
INSERT INTO acd_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Mɛ baa kerɛ mɔ, iloobu inyɔ iko ne: Mosisi mɔ‑rɛ Ilaagya. Mɛ ba Yesu asɛ, mɔmɔ‑rɛ mɔ mɛ yelɛ mɛ kya gyi nsingyi. ");
INSERT INTO acd_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Ibono mɛ lii Wurubuaarɛ dɔ ba mɔ so mɔ, mɛ bo nyisigyi. Mɔmɔ‑rɛ Yesu mɛ tɔgɛ lɛwu ɔbono ɔ laa wuꞌ Gyɛrusalem mɔ so ilaa. ");
INSERT INTO acd_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Piita mɔ‑rɛ mɔ-nanboana mɔ berɛ, gɛnen aberɛ abono pɛwu mɔ ginsi gidɛ gi kya boo ɔmɔ. Imɔso i ŋmangɛ mɔmɔ-ansi so mɔ, mɛ wu Yesu de nyisigyi de iloobu inyɔ mɔ mɛ yelɛ mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iloobu mɔ mɛ kya laarɛ mɛꞌ kyon taa Yesu yɛgɛ mɔ, Piita gi ten loo tɔgɛ atɔgɛkpandɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, i wɔra ɔdan yɛɛ a bo gɛrɛnaa. Yɛgɛ de aꞌ yii ipanpan isaꞌ sa fɛye: fo-lɛɛ panpan ɔko, Mosisi-lɛɛ ɔko de Ilaagya-lɛɛ ɔko.” ");
INSERT INTO acd_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Piita mɛŋ ti taa tɔngɛ ta mɔ, gibuntɔ giko gi ba baa bun mɔmɔ so faa kpem. Aberɛ abono gibuntɔ mɔ gi kya laarɛ giꞌ bun mɔmɔ so gɛnen mɔ, i wɔra Piita mɔ‑rɛ mɔ-nanboana mɔ gifuu. ");
INSERT INTO acd_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Nfono mɔ, Wurubuaarɛ gigyɛbiꞌ gi lii gibuntɔ mɔ dɔ tɔgɛ kyu lii Yesu so yɛɛ, “Me-bi ne. Mɔ ne nɛ lɛɛ gibaa yii de ɔꞌ wɔra me-gisen dɔ ilaa. Fɛꞌ nu mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wurubuaarɛ gi tɔgɛ gɛnen ta mɔ, Yesu akasɛbo mɔ mɛ kerɛ mɔ, mɔmɔ‑rɛ Yesu wolɛ ne n san mɛ yelɛ. Gɛnen nkɛ nbono dɔ mɔ, mɛ mɛŋ tɔgɛ gɛnen ilaa ibono mɛ kpaa wu gibii mɔ so mɔ sa ɔko‑rɛ ɔko. ");
INSERT INTO acd_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Imɔ gɛdɛ kɛsɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo asaꞌ mɔ mɛ kpelegɛ lii gibii mɔ so mɛ kya ba mɔ, sakpii belɛ gi baa gyangara mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Mɛ gyanꞌ mɔ, ɔnyen ɔko gi kpen tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, n dɛ fo giserɛ, kerɛ me-bi so sa me. Mɔ-nkon ne nꞌ bo. ");
INSERT INTO acd_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","I bo no i bo no mɔ, ilaa nyɛnyɛn oduduu kya baa kyena mɔ so. I kyena mɔ so gɛnen mɔ, ayaa abono so mɔ, i kya yɛgɛ ɔ kya kpen ken-ken gikolon de iꞌ kuu mɔ taa gɛsinkpan, i kya gbebi mɔ yɛgɛ mɔ-gɛnɔ dɔ i kya furu afuru. I kya nyala mɔ gɛnen‑n kɛɛla pɛi de iꞌ lɔɔ ba‑a kyon mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nɛ kolɛ fo-akasɛbo yɛɛ mɛꞌ wɔra aniya de mɛꞌ gya gɛnen ilaa nyɛnyɛn oduduu ɔbono koso mɔ so sa me mɔ, mɛ mɛŋ taalɛ.” ");
INSERT INTO acd_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Yesu gi tɔgɛ yɛɛ, “O! Ndɛ fɛye nkɛ ndɛ dɔ asa! Fɛŋ kya sɔɔ Wurubuaarɛ gyi. Fɛ kpɛ fa‑a biidɛ gɛnɔ daa so‑o! Nkɛ nfonɛ ne nan kyena fɛye asɛ n kpɛ mi‑i nyɛ gisen mi‑i sa fɛye daa?” Ne ɔ tɔgɛ gɛbii mɔ mɔ-sɛ yɛɛ, “Kyu fo-bi mɔ ba gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Gɛbii mɔ gɛ kya ba Yesu asɛ mɔ, ilaa nyɛnyɛn oduduu mɔ i kuu gɛmɔ taa gɛsinkpan, i san i kya gbebi gɛmɔ. Nfono mɔ Yesu gi tɔgɛ sa ilaa nyɛnyɛn oduduu mɔ yɛɛ iꞌ koso gɛbii mɔ so ɔ kerɛ imɔ faa. Yesu gi kyɛ gɛbii mɔ, ne o kiiri gɛmɔ sa gɛmɔ-sɛ. ");
INSERT INTO acd_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Gɛnɔɔbono Yesu gi kyu lɛɛ Wurubuaarɛ ɔlon belɛ gɛwi nyiile asa mɔ nfono mɔ, i dɛ mɔmɔ ɔkamaasɛ gɛnɔ. Owi ɔbono sakpii mɔ kya diilɛ Yesu ilaa wɔrasɛ mɔ ne i kya dɛ mɔmɔ-gɛnɔ gɛnen mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Fɛꞌ yela giso de fɛꞌ nu dɔɔdan: me-akyobo mɛ laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra asa ako abaa dɔ de mɛꞌ wɔra me ilaa ibono mɛ kya laarɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","O buu sa ɔmɔ gɛnen mɔ, mɛ mɛŋ nu imɔ gɛsɛ. Mɔmɔ-nwɔnsa dɔ i mɛŋ bugi de mɛꞌ bii imɔ so ilaa. I kii i bo mɔmɔ gifuu de mɛꞌ taasɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Owi ɔko dɔ mɔ, akyɔɔlɛ a tɔrɔ Yesu akasɛbo mɔ so. Mɛ kya sɔɔ akyɔɔlɛ yɛɛ mɔmɔ dɔ mɔ, anɛ ne n don mɔ-nanbo? ");
INSERT INTO acd_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Yesu gi bii yɛɛ mɛ kya sɔɔ akyɔɔlɛ gɛnen mɔ, ɔ keda gɛbii gɛko ba mɔ asɛ, ");
INSERT INTO acd_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ne o buu sa mɔmɔ yɛɛ, “Nengyene fɛɛ me so ne fo ɔko fo bugi ansi de gɛnen gɛbii gɛdɛ ɔnan mɔ, me ne fo bugi ansi de gɛnen. Ne fo bugi ansi de me mɔ, fo bugi ansi de Wurubuaarɛ ɔbono o sun me mɔ kee ne. I kya nyiile yɛɛ ɔbono ɔ kya wɔra mɔ-nyoro fɛɛ mɔ ne n gyɛ gɛbii fɛye dɔ mɔ, mɔ ne n gyɛ ɔbono ɔ gyɛ nyamesɛ gbaaꞌ fɛye dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Ne Gyɔn gi tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, a wu ɔnyen ɔko dɛ fo-ginyen ɔ kya gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi ɔ kya koso asa so. I mɛŋ kii i gyɛ aye‑rɛ mɔ ne n naa. Imɔso a gya mɔ yɛɛ ɔŋ baa wɔra gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Ne Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fɛ san wu mɔ gɛnen mɔ, fɛŋꞌ baa gya mɔ. I kya nyiile yɛɛ isa ɔbono ɔ mɛŋ kya sɔɔ akyɔɔlɛ de fɛye mɔ, ɔ yelɛ fɛye-gɛmara ne.” ");
INSERT INTO acd_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Owi mɔ kya fuude ibono Wurubuaarɛ laa puru Yesu lii gɛsinkpan so kii kpe mɔ asɛ mɔ, Yesu gi kyu mɔ-ansi kyu yii de Gyɛrusalem ɔsowolɛ so yɛɛ nno ne ɔ laa kpe kon. ");
INSERT INTO acd_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Pɛi ne ɔ laa yii ɔkpa mɔ, o sun isɔɔ yɛɛ mɛꞌ gyangbara mɔ. Isɔɔ mɔ mɛ kyon mɔ, mɛ kpaa loo Samariya ɔsowolɛ ɔko so de mɛꞌ lɔrɔ ɔkpa sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ibono Yesu gi tɔgɛ yɛɛ Gyɛrusalem ne ɔ kya kpe so mɔ, ɔsowolɛ mɔ so asa mɛ mɛŋ kyule sɔɔ mɔ gisafo. ");
INSERT INTO acd_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Isɔɔ mɔ mɛ kpaa buu sa Yesu yɛɛ ɔsowolɛ mɔ so asa mɛ kine mɔ. Mɔ akasɛbo, Gyeemesi mɔ‑rɛ Gyɔn, mɛ nu gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Aye-wura, fo kya laarɛ aꞌ terɛ ɔgya lii Wurubuaarɛ dɔ kpelegɛ ba de ɔꞌ baa dɛɛ mɔmɔ?” ");
INSERT INTO acd_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mɛ taasɛ Yesu gɛnen mɔ, o kisee kerɛ mɔmɔ, ne ɔ tɔgɛ mɔmɔ yɛɛ ibono mɛ tɔgɛ faa iŋ boran. ");
INSERT INTO acd_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Nfono mɔ, mɛ naa kyon kpe ɔsowolɛ banban ɔko so. ");
INSERT INTO acd_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mɛ sɔɔ de ɔkpa ɔko mɛ kya kpe mɔ, ɔnyen ɔko gi tɔgɛ sa Yesu yɛɛ, “Nan buu fo kpe gɛten kamaasɛ gɛbono fo laa kpe mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yesu gi tɔgɛ sa ɔnyen mɔ yɛɛ, “Agbowugbowu gbaa mɛ bo ibɔ dɛsɛ, ne nbuii kee mɛ bo asisaa. Me, anyamesɛ pɛwu mɔmɔ-daa mɔ berɛ, meŋ bo me-gimu okunten.” ");
INSERT INTO acd_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Yesu gi tɔgɛ sa ɔnyen banban ɔko berɛ yɛɛ, “Baa buu me de foꞌ wɔra me-ɔkasɛbo.” Ɔbono gi lɛɛ gɛnɔ sa Yesu yɛɛ, “Me-wura, yɛgɛ me nꞌ kpaa pule me-sɛ pɛi de nꞌ lɔɔ baa buu fo.” ");
INSERT INTO acd_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Yɛgɛ asa abono Wurubuaarɛ ilaa iŋ fɛ ɔmɔ-giso mɔ mɛꞌ pule abara. Fo berɛ, baa kyon kpe de foꞌ kpaa tɔgɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so ilaa sa asa.” ");
INSERT INTO acd_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ɔko mɔ gi buu sa Yesu yɛɛ, “Me-wura, nan baa buu fo de nꞌ wɔra fo-ɔkasɛbo. Imɔ mɔ mɔ, yɛgɛ de nꞌ kpaa kalɛ me-gɛten dɔ awura de nꞌ ba.” ");
INSERT INTO acd_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Ɔ kolɛ Yesu gɛnen mɔ, Yesu gi tɔgɛ sa mɔ yɛɛ, “Fo ɔbono fo yii gɛsɛ fo kya baalɛ baalɛ ne fo kya kpɛɛlɛ fɛ kya kerɛ fo-gɛmara mɔ, bii yɛɛ foŋ kaaborɛ foꞌ nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi mɔ dɔ ne.” ");
INSERT INTO acd_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Imɔ idɛ gɛmara mɔ, Yesu gi lɛɛ asa ikue-isa de saalaa asa anyɔ ako kee ne ɔ keda ɔmɔ sun yɛɛ mɛꞌ naa anyɔ-anyɔ kpe isowolɛ de nten kpɛi-kpɛi nfonoana mɔ gbaa-gbaa laa baa kpe mɔ yɛɛ mɛꞌ gyangbara mɔ kpe nnoana. ");
INSERT INTO acd_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Mɛ laa kyon mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Asa abono i kaaborɛ mɛꞌ nu Wurubuaarɛ ɔkalan konkonsɛ mɔ mɛ dɛ fɛɛ ɔmɔlɔgɔ ne n pɛɛrɛ ndɔɔ belɛ nko dɔ. Akɛbibo mɔ, mɔ, mɛŋ kyɔ sa ndɔɔ wura mɔ. Imɔso fɛꞌ dalaa kolɛ Wurubuaarɛ ɔbono ɔ gyɛ Ndɔɔ Wura mɔ yɛɛ mɔ gbaa-gbaa oꞌ kyu akɛbibo ba mɔ-ndɔɔ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","“Fɛꞌ naa fɛ kya kpe. Fɛꞌ bii yɛɛ n kya sun fɛye fɛɛ nsandɛbii ne n kya kpe agbowugbowu dɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Fɛ mɛŋ sa fɛꞌ kyu aterenbi, atɔ ɔwɔraten, abɛɛ ayaawolɛ keda. Fɛ kya kpe mɔ, fɛ mɛŋ sa fɛꞌ waala fɛye-nyoro yɛɛ fɛ kya faala ɔko‑rɛ ɔko ɔkpa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Gɛtenꞌ gɛbono dɔ fɛ laa loo mɔ, fɛꞌ daa gifaala gɛmɔ dɔ asa yɛɛ, ‘Gisen yuuli giꞌ wɔra fɛye-lɛɛ.’ ");
INSERT INTO acd_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nengyene gisen yuuli awura mɛ bo gɛtenꞌ gɛbono dɔ mɔ, mɛ laa nyɛ gisen yuuli. Nengyene gisen yuuli awura mɛŋ bo nno mɔ, gisen yuuli mɔ gi laa kii ba fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","“Gɛtenꞌ gɛbono dɔ fɛ sogɛ mɔ, fɛꞌ kyena gɛmɔ dɔ kaaborɛ fɛ laa lii ɔsowolɛ ɔbono so. Ilaa ibono mɛ laa sa fɛye mɔ, fɛꞌ gyi de fɛꞌ nun. I kya nyiile yɛɛ gɛsun ɔwɔrabo gi kaaborɛ ɔꞌ nyɛ mɛꞌ kerɛ mɔ so. Fɛꞌ sii de gɛtenꞌ kolon, fɛŋ sa fɛꞌ sogɛ gɛtenꞌ gɛdɛ dɔ de fɛꞌ lii kii kpaa sogɛ gɛbanban gɛko dɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","“Nengyene fɛ loo ɔsowolɛ so ne ɔsowolɛ ɔbono so asa mɛ kya keda fɛye gisafo mɔ, agyudɔ abono mɛ laa kyu baa yii fɛye-ansi dɔ mɔ, fɛꞌ gyi amɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Fɛꞌ kyɛ alɔbo abono mɛ bo gɛnen ɔsowolɛ ɔbono so mɔ de fɛꞌ tɔgɛ sa ɔsowolɛ mɔ so asa mɔ yɛɛ, ‘Wurubuaarɛ kya laarɛ ɔꞌ kalɛ fɛye bɔla mɔ-adɛ so mɔ-gɛwuragyi mɔ dɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","“Nengyene fɛ loo ɔsowolɛ ɔko so ne nno asa mɛ kine mɛ maŋ bugi ansi de fɛye mɔ, fɛꞌ lii kpaa yelɛ ɔsowolɛ ɔbono ikpa dɔ de fɛꞌ tɔgɛ sa asa mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Fɛye-ɔsowolɛ mɔ so isɛ ibono i yii aye-ayaa mɔ gbaa, a kpiisi yela fɛye. Idɛ berɛ, fɛꞌ bii yɛɛ Wurubuaarɛ gi laarɛ ɔꞌ kalɛ fɛye bɔla mɔ-adɛ so mɔ-gɛwuragyi mɔ dɔ. Fɛye ne n kine.’ ” ");
INSERT INTO acd_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yesu gi kii tɔgɛ sa ɔmɔ yɛɛ, “Fɛye berɛ n kya tɔgɛ mi‑i sa fɛye yɛɛ ɔsowolɛ ɔbono fɛ loo ne mɛ maŋ keda fɛye gisafo mɔ, gɛkɛ gɛbono Wurubuaarɛ laa biidɛ asa pɛwu giso mɔ, gɛnen ɔsowolɛ ɔbono so asa-lɛɛ gisobiidɛ gi laa nyaakyɔ don Sodom awura lɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O, Korasin awura, fɛye laako! O, Bɛsayida awura, fɛye laako! Nɛ kyu Wurubuaarɛ ɔlon wɔra ilaa gbaaꞌgbaa fɛye asɛ ibono fɛ wu de ansi. Nengyene nkana Taya de Sidon awura ne nen nyɛ me-ilaa ibono wu gɛnen mɔ, ɔfaanan mɛ ti wolaa taa mɔmɔ ilaa nyɛnyɛn giwɔra yɛgɛ. Nkana ɔfaanan mɛ kya bɔɔda kyena mɛ kya pɛɛrɛ ansi nyiile Wurubuaarɛ yɛɛ mɛ nu mɔmɔ-nyoro gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Fɛꞌ bii yɛɛ gɛkaabono Wurubuaarɛ laa biidɛ asa nyɛnyɛn pɛwu giso mɔ, fɛye-lɛɛ i laa wɔra nyɛnyɛn don Taya de Sidon awura-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ne fɛye Kapɛɛniyon awura mɔ de‑e? Gɛnen gɛkaabono mɔ fɛ nyi yɛɛ Wurubuaarɛ laa kyu fɛye kpe mɔ asɛ? Kuaa, ɔ laa too fɛye wɔra daa ɔbɔ dɔ nfono ɔ kya biidɛ ilaa nyɛnyɛn awɔrabo giso mɔmɔ-lɛwu gɛmara mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Yesu gi kii tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Ɔbono o nu fɛye asɛ mɔ, me asɛ ne o nu gɛnen, ne ɔbono o kine yɛɛ ɔ maŋ nu fɛye asɛ mɔ, me ne kaasɛ mɔ gi kine gɛnen. Ɔbono o kine yɛɛ ɔ maŋ nu me asɛ kee mɔ, Wurubuaarɛ ɔbono o sun me ba gɛsinkpan so mɔ ne kaasɛ mɔ gi kine gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Asa ikue-isa de saalaa anyamesɛ anyɔ abono Yesu gi sun mɔ mɛ kpe ne mɛ kii ba de ɔkon. Mɛ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, ilaa nyɛnyɛn oduduu kpɛi-kpɛi gbaa i bara imɔ-nyoro gɛsɛ sa aye fo-ginyen dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mɛ buu sa Yesu gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nɛ wu ilaa nyɛnyɛn pɛwu gɛmu mɔ gi lii Wurubuaarɛ dɔ faa pila‑a fɛɛ gɛnɔɔbono nyangbon kya wiisɛɛ gikolon mɔ baa kyon kpaa tɔrɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Fɛꞌ nu yɛɛ nɛ sa fɛye ɔlon de fɛꞌ taalɛ kyise awɔɔ de nnan so de fɛꞌ taalɛ kyise ilaa nyɛnyɛn pɛwu gɛmu ɔbono ɔ gyɛ Wurubuaarɛ ɔkyobo mɔ ɔlon pɛwu so. Sɛi maŋ wɔra fɛye. ");
INSERT INTO acd_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Imɔ gɛnen gbaa mɔ, fɛ mɛŋ sa fɛꞌ yɛgɛ de iꞌ wɔra fɛye ɔkon yɛɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi i bara imɔ-nyoro gɛsɛ sa fɛye. Fɛꞌ yɛgɛ de iꞌ wɔra fɛye ɔkon daa yɛɛ Wurubuaarɛ gi ŋmarasɛ fɛye-anyen yela Wurubuaarɛ dɔ yɛɛ fɛ laa baa kyena nno.” ");
INSERT INTO acd_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Owi ɔbono Yesu kya tɔngɛ de mɔ-akasɛbo mɔ gɛnen mɔ, Wurubuaarɛ Oduduu mɔ gi sa mɔ ɔkon belɛ mɔ-gisen dɔ, ne ɔ faala Wurubuaarɛ yɛɛ, “Me-sɛ, soso de gɛsinkpan pɛwu Wura, n kya faala fo yɛɛ fo kyu gɛnen ilaa idɛ ŋara abono mɛ nyi ɔlaako mɔ de abono mɛ sɛɛ mɔ, ne fo san lɛɛ imɔ-gɛwi nyiile daa nbii de asa abono mɛ mɛŋ nyi gisɛɛ mɔ. Gɛsintin, me-sɛ. Imɔ ibono ne n wɔra fo ɔbolɛ.” ");
INSERT INTO acd_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Yesu gi kii tɔgɛ yɛɛ, “Me-sɛ Wurubuaarɛ gi kyu ilaa kamaasɛ kyu wɔra me-abaa dɔ. Ɔko mɛŋ bo no o nyi me, Wurubuaarɛ mɔ-bi mɔ, gɛnen mɔ, me-sɛ Wurubuaarɛ wolɛ. Gɛnen kee ne ɔko mɛŋ bo no o nyi Wurubuaarɛ, gɛnen mɔ, me ɔbono n gyɛ mɔ-bi mɔ; me‑rɛ asa abono n kya laarɛ de nꞌ lɛɛ mɔ gɛwi nyiile ɔmɔ mɔ wolɛ ne n nyi mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Yesu gi kisee tɔgɛ sa mɔ-akasɛbo mɔ wolɛ yɛɛ, “Amudɛnsɛbo ne n gyɛ fɛye abono fɛ kya nyɛ wu me-ilaa wɔrasɛ de ansi. ");
INSERT INTO acd_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","N kya tɔgɛ mi‑i sa fɛye yɛɛ Wurubuaarɛ ikalan atɔgɛbo kpɛi-kpɛi de awura-awura sakyɔ mɛ laarɛ mɛꞌ wu ilaa ibono fɛ kya wu faa, mɛŋ kii nyɛ; mɛ laarɛ mɛꞌ nu ilaa ibono fɛ kya nu faa, mɛŋ kii nyɛ.” ");
INSERT INTO acd_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Owi ɔko dɔ mɔ, Wurubuaarɛ nbara onyiilebo ɔko gi ba de ɔꞌ baa daasɛ Yesu kerɛ. Imɔso ɔ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, nnɛ ne nan wɔra de nꞌ nyɛ kyena Wurubuaarɛ asɛ gɛkpaa?” ");
INSERT INTO acd_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Yesu gi kisee taasɛ mɔ yɛɛ, “Fo kya kalɛ Wurubuaarɛ nbara mɔ mɔ, fo kya nu nmɔ gɛsɛ nnɛ?” ");
INSERT INTO acd_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Wurubuaarɛ nbara mɔ gi kya nyiile yɛɛ, ‘Laarɛ fo-Wura Wurubuaarɛ lii fo-gisen dɔ. Kyu fo-gisen pɛwu, fo-ɔlon pɛwu de fo-gɛwɔnsa pɛwu kyu laarɛ Wurubuaarɛ ilaa.’ Ne i kya nyiile kee yɛɛ, ‘Laarɛ fo-nanbo fɛɛ fo-nyoro.’ ” ");
INSERT INTO acd_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Nfono ne Yesu yɛɛ, “Fo lɛɛ gɛnɔ mɔ, i kyena. Fo gyi nmɔ ndɛ so mɔ, fo laa kyena Wurubuaarɛ asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nbara onyiilebo mɔ gi laarɛ ɔꞌ lɛɛ nyiile yɛɛ ɔŋ fuɛ. Gɛnen so mɔ o kii taasɛ Yesu yɛɛ, “Wurubuaarɛ nbara gi kya nyiile yɛɛ nꞌ laarɛ me-nanbo fɛɛ me-nyoro faa mɔ, anɛ mɔ ne n gyɛ me-nanbo daa?” ");
INSERT INTO acd_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Yesu gi lɛɛ gɛnɔ gikpalɛ dɔ sa ɔnyen mɔ yɛɛ, “Owi ɔko dɔ mɔ aye-nanbo, Gyudanyen ɔko gi lii Gyɛrusalem ɔ kya kpe Gyɛriko. Ɔ kya kpe mɔ, nkyɛɛ iyu mɛ bun ɔkpa dɔ ne. Mɛ lii tu mɔ, ne mɛ daarɛ mɔ san ŋmaraa de oꞌ wuꞌ. Mɛ puru mɔ-atɔ pɛwu ne mɛ selɛ taa mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Ɔ dɛ nfono gɛnen mɔ, aye gbaa-gbaa aye-isa ɔko gi baa kyu de nno. Ɔ gyɛ Wurubuaarɛ asunbi ɔlɛɛbo. Ɔ fuɛ lii mɔ so gɛnen mɔ, o wu ibono ɔ dɛ, ne ɔ gelegɛ kyon. ");
INSERT INTO acd_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Aye Gyudanyen ɔko kee gi baa tu mɔ. Ɔ gyɛ Lɛfi gɛten dɔ isa. Ɔ baa tu ɔnyen mɔ dɛ gɛnen mɔ, mɔ kee gi gelegɛ kyon mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Nfono mɔ, Samariyanyen ɔko gi baa lii mɔ so. Ɔŋ taa gyɛ aye isa gbaa. Ɔ baa tu mɔ ɔ dɛ mɔ, mɔ-ilaa i wɔra mɔ ayen gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ɔ gyanꞌ bee so, imɔso ɔ kpelegɛ mɔ-bee so naa kpe ɔnyen mɔ asɛ. O wu ibono ɔnyen mɔ gi gooli mɔ, o kyu nfɔ de nta nko kyu worogɛ mɔ-ilɔ mɔ so ne ɔ ŋminde imɔ. Ɔ ŋminde imɔ ta mɔ, ne o puru mɔ gyanꞌ mɔ-bee so kyu mɔ kpe ɔsowolɛ ɔbono o sindi nfono mɔ. Ɔ gyɛ isafo so mɔ, ɔ kpaa loo asafo ɔsogɛten. Imɔso o kyu ɔlɔbo mɔ kee kpe nno, ne ɔ kerɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gɛdɛ kɛsɛ mɔ, ɔ lɛɛ mɔ-aterenbi kyu sa gɛten wura mɔ ne ɔ tɔgɛ sa gɛten wura mɔ yɛɛ, ‘Kerɛ ɔlɔbo baarɛ so sa me. N kya kpe de nꞌ ba. Aterenbi abono fo laa kii nyida bɔla de adɛ so mɔ, nɛ ba mɔ, nan ba ka fo.’ ” ");
INSERT INTO acd_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Yesu gi da gikpalɛ mɔ ta mɔ, ne ɔ taasɛ nbara onyiilebo mɔ yɛɛ, “Fo asɛ mɔ, gɛnen asa asaꞌ adɛ dɔ mɔ, anɛ ne n wɔra gɛnanbo ilaa sa aye-nanbo Gyudanyen ɔbono iyu mɔ mɛ daarɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Ne ɔ lɛɛ gɛnɔ yɛɛ, “Ɔbono o su mɔ gitolon mɔ.” Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Gɛsintin, fo lɛɛ gɛnɔ mɔ, i kyena. Imɔso naa fo kya kpe de foꞌ kpaa wɔra gɛnen kee.” ");
INSERT INTO acd_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Owi ɔko dɔ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ naa mɛ kya kpe mɔ, mɛ kpaa fo ɔsowolɛ ɔko so. Ɔkyii ɔko bo gɛnen ɔsowolɛ ɔbono so, mɛ kya terɛ mɔ-ginyen yɛɛ Maata. Mɔ-gɛwi ne Yesu gi sogɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Maata bo ɔtedɛ ɔko mɛ kya terɛ mɔ yɛɛ Mariya. Wura Yesu gi loo gɛten mɔ dɔ gɛnen mɔ, Mariya gi naa kpaa gbaa kyena mɔ-ayaa dɔ ɔ kya nu mɔ-ilaa nyiilesɛ. ");
INSERT INTO acd_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Maata berɛ ilaa ibono ɔ kya wɔra de oꞌ kyu keda asafo mɔ i nyaakyɔ ne imɔ ne n kpɛ i bo mɔ-ansi so. Imɔso ɔ kpaa taasɛ Yesu yɛɛ, “Me-wura, ibono me-tedɛ gi taa gɛsun mɔ giwɔra pɛwu yɛgɛ sa me-nkon faa, i mɛŋ fɛ fo-giso do‑o? Tɔgɛ sa mɔ de ɔꞌ koso baa kpaa me.” ");
INSERT INTO acd_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Maata gi tɔgɛ sa mɔ gɛnen mɔ, Wura Yesu gi lɛɛ gɛnɔ yɛɛ, “O, Maata! Ilaa kpɛi-kpɛi i kya wɔra fo nwɔnsa gikyɔ, ne foŋ kya nyɛ fo-nyoro. ");
INSERT INTO acd_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ilaa kolon, mɔ, ne n tiri sa nyamesɛ. Imɔ ne Mariya berɛ gi bii lɛɛ faa. Ɔko maŋ taalɛ sɔgɛ imɔ lii mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","I ba yɛɛ Yesu bo gɛtɛɛko ɔ kya dalaa. Ɔ dalaa ta mɔ, mɔ-ɔkasɛbo ɔko gi kolɛ mɔ yɛɛ, “Aye-wura, nyiile aye gɛdalaa fɛɛ gɛnɔɔbono Gyɔn gi nyiile mɔ-lɛɛ akasɛbo mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Nfono ne Yesu gi nyiile mɔmɔ yɛɛ, “Nengyene fɛ laa dalaa mɔ, fɛꞌ dalaa yɛɛ: Aye-sɛ, yɛgɛ asa mɛꞌ buu fo yɛɛ fo-nkon ne n gyɛ Wurubuaarɛ. Yɛgɛ fo-gɛwuragyi dɔ akyenabi aꞌ ba asa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Sa aye ndɛ gɛkɛ gɛdɛ-lɛɛ ilaa gyisɛ. ");
INSERT INTO acd_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Kyu aye-ilaa nyɛnyɛn kyɛɛ aye. Aye, mɔ, kee, a dɛ ilaa nyɛnyɛn ibono nyamesɛ kamaasɛ gi wɔra aye mɔ a kya kyɛɛ mɔ. Kpaa aye de ilaa iko iŋ sa iꞌ nyɛ aye penɛ de aꞌ wɔra ilaa nyɛnyɛn.” ");
INSERT INTO acd_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Aꞌ kyu yɛɛ fɛye dɔ ɔko bo ɔkyɛmenɛ. Gɛnyɛ de nsana gɛko mɔ, ɔ koso kpe mɔ-kyɛmenɛ mɔ-gɛwi kpaa ŋmɛɛ mɔ-gisen ne ɔ tɔgɛ sa mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","‘Me-kyɛmenɛ, nperɛ-nperɛ ne me-kyɛmenɛ ɔko gi kpɛ baa sogɛ me so faa. Meŋ bo sɛi de nꞌ sa mɔ. Imɔso paa me ibodobodo isaꞌ.’ ");
INSERT INTO acd_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ɔ kolɛ mɔ gɛnen mɔ, mɔ-kyɛmenɛ mɔ gi lɛɛ gɛnɔ yɛɛ, ‘Gɛŋ sa foꞌ nyala me. Nɛ ti tii. Me-biana mɛ dɛ me asɛ. Maŋ baa taalɛ koso de nꞌ baa sa fo ilaa iko!’ ");
INSERT INTO acd_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nꞌ tɔgɛ fɛye yɛɛ nkana fɛɛ gɛkyɛmenɛ mɔ wolɛ so ne ɔ maŋ koso sa mɔ sɛi mɔ, gɛnɔɔbono mɔ-kyɛmenɛ mɔ laa kpɛ mada mɔ-gikolɛ mɔ, i wɔra nnɛ mɔ, ɔ laa koso de ɔꞌ sa mɔ ilaa kamaasɛ ibono i tiri mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Imɔso n kya tɔgɛ mi‑i sa fɛye yɛɛ, ‘Fɛꞌ dalaa kolɛ Wurubuaarɛ; ɔ laa sa fɛye. Fɛꞌ laarɛ; fɛ laa nyɛ. Fɛꞌ ŋmɛɛ Wurubuaarɛ gisin; ɔ laa tigi fɛye.’ ");
INSERT INTO acd_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","I kya nyiile yɛɛ ɔkamaasɛ ɔbono ɔ kpɛ ɔ kya kolɛ mɔ, Wurubuaarɛ kya sa mɔ. Ne ɔbono ɔ kpɛ ɔ kya laarɛ mɔ, ɔ kya nyɛ. Ɔbono mɔ, ɔ kpɛ ɔ kya ŋmɛɛ Wurubuaarɛ gisin mɔ, ɔ kya tigi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Fɛye dɔ ɔsɛ ɔmɔ ne n bo no yɛɛ mɔ-bi laa kolɛ mɔ ɔken de oꞌ kyu daa giwɔɔ kyu sa mɔ? ");
INSERT INTO acd_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Abɛɛ mɔ-bi laa kolɛ mɔ gibɔli de oꞌ kyu daa gɛnan kyu sa mɔ? ");
INSERT INTO acd_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Fɛye abono fɛ gyɛ ilaa nyɛnyɛn awura mɔ gbaa ne n kya bii kyu ilaa dɛnsɛ kyu sa fɛye-biana faa. Menɛtɔ so ne aye-sɛ ɔbono ɔ bo soso mɔ maŋ kyu mɔ Wurubuaarɛ Oduduu mɔ kyu sa asa abono mɛ kya kolɛ mɔ mɔ?” ");
INSERT INTO acd_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Owi ɔko dɔ mɔ, Yesu gi kosorɛ ilaa nyɛnyɛn oduduu ɔnyen ɔko so. Ilaa nyɛnyɛn oduduu mɔ mɛŋ kya tɔngɛ, ne i yɛgɛ ɔnyen mɔ gi wɔra omuumuu. Yesu gi kosorɛ gɛnen oduduu ɔbono ɔnyen mɔ so mɔ, ɔnyen mɔ gi taalɛ ɔ kya tɔngɛ. I dɛ sakpii ɔbono ɔ gyanꞌ nno mɔ gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Asa mɔ ako berɛ mɛ kya tɔgɛ yɛɛ, “Ilaa nyɛnyɛn oduduu pɛwu gɛmu mɔ ɔbono mɛ kya terɛ mɔ-ginyen giko yɛɛ Besibuli mɔ ne n kya sa Yesu ɔlon. Imɔso ne ɔ kya taalɛ ɔ kya gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi koso asa so gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Mɔmɔ ako, mɔ, mɛ tɔgɛ mɔ yɛɛ ɔꞌ wɔra ilaa lii Wurubuaarɛ dɔ sa mɔmɔ de iꞌ lɛɛ nyiile yɛɛ Wurubuaarɛ ne n sa mɔ ɔlon ɔbono ɔ dɛ mɔ. Mɛ tɔgɛ mɔ gɛnen mɔ, mɛ kya daasɛ mɔ mɛ kya kerɛ. ");
INSERT INTO acd_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Yesu, mɔ, gi bii mɔmɔ-nwɔnsa dɔ, ne ɔ tɔgɛ sa mɔmɔ akpalɛ dɔ yɛɛ, “Nengyene ilaa nyɛnyɛn gɛmu mɔ ne n kya yɛgɛ nꞌ kosorɛ mɔ-adɛ mɔ, i laa wɔra fɛɛ wura mɔ‑rɛ mɔ-adɛ ne n kya kɔ de abara. Mɛ kya kɔ gɛnen mɔ, mɔ-gɛwuragyi mɔ gɛ laa nyida. Ne gɛten kolon dɔ asa mɛ yɛ mɔmɔ-nyoro dɔ mɛ kya kɔ de abara mɔ, gɛnen gɛten gɛbono gɛ laa boori. ");
INSERT INTO acd_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Imɔso nengyene i gyɛ gɛsintin yɛɛ ilaa nyɛnyɛn pɛwu gɛmu mɔ kya kɔ de mɔ-adɛ mɔ, nnɛ so ne mɔ-gɛwuragyi gɛ laa dɛ kpe? Fɛye yɛɛ ilaa nyɛnyɛn gɛmu mɔ ɔlon ne nꞌ dɛ n kya kosorɛ mɔ gbaa-gbaa adɛ. Fɛ sɔɔ gyi yɛɛ ɔ laa kyule sa me gɛnen? Ɔ maŋ kyule. ");
INSERT INTO acd_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne ibono fɛye-adɛ ako, mɔ, mɛ kya kosorɛ ilaa nyɛnyɛn oduduu asa so faa mɔ de‑e? Anɛ ɔlon dɔ ne mɛ kya kosorɛ imɔ gɛnen daa? Fɛye gbaa-gbaa adɛ mɔ mɛ laa kyɔɔlɛ fɛye yɛɛ iŋ gyɛ Besibuli ɔlon dɔ ne isa laa taalɛ kosorɛ ilaa nyɛnyɛn oduduu kpɛi-kpɛi. ");
INSERT INTO acd_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Gɛnɔɔbono i dɛ faa mɔ, Wurubuaarɛ ɔlon ne nꞌ dɛ mi‑i kosorɛ ilaa nyɛnyɛn oduduu asa so. Imɔso i kya lɛɛ i kya nyiile fɛye yɛɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi a ti ba fɛye dɔ ne.” ");
INSERT INTO acd_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Ne Yesu gi kii da mɔmɔ gikpalɛ yɛɛ, “Ilaa nyɛnyɛn pɛwu gɛmu mɔ dɛ daa fɛɛ ɔnyen bolonsɛ ɔbono ɔ dɛ adontɔ ɔ kya dii mɔ-gɛten dɔ atɔ pɛwu dandan. Ɔ bo nno gɛnen mɔ, ɔko maŋ nyɛ sɔgɛ sɛi lii mɔ-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ne fɛɛ ɔko gi ba ne ɔ bo lon don mɔ mɔ, ɔbono laa baa kɔ de mɔ. O gyi mɔ so mɔ, ɔ laa sɔgɛ mɔ-adontɔ abono ɔ kya ka gyanꞌ amɔ so mɔ lii mɔ asɛ de ɔꞌ san kyu atɔ mɔ yɛ-yɛ sa asa. ");
INSERT INTO acd_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Fɛꞌ nu yɛɛ ɔbono ɔŋ kya buu me mɔ kya sɔɔ akyɔɔlɛ de me ne. Ɔbono ɔŋ kya kpaa me de nꞌ koola asa mɔ kya yaasɛ mɔmɔ ne. ");
INSERT INTO acd_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Nengyene ilaa nyɛnyɛn oduduu i koso isa so mɔ, i kya naa kingi, ne i kya wɔra imɔ fɛɛ i naa gɛsinkpan so nfono nkyu giŋ bo mɔ i kya laarɛ ɔkyoolaten. Nengyene iŋ nyɛ ɔkyoolaten mɔ, i kya tɔgɛ sa imɔ-nyoro yɛɛ, ‘Nan kii kpaa kyena isa ɔbono so n wolaa n tɛ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","I kii kpe isa mɔ asɛ mɔ, i kya kpaa wu yɛɛ isa mɔ gi wɔra fɛɛ gɛten gɛbono mɛ kpa gɛmɔ lɔrɔ gɛmɔ dɔ ne gɛ wɔra ɔdan mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Nfono mɔ, ilaa nyɛnyɛn oduduu mɔ kya kpaa terɛ imɔ-nanboana sono ibono i bo ilaa nyɛnyɛn don imɔ-nyoro mɔ kyu baa bɔla imɔ-nyoro so de iꞌ kpaa kyena isa mɔ so kon. Nengyene i ba gɛnen mɔ, i kya lɔrɔ wɔra nyɛnyɛn sa isa mɔ don gigyangbarasɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Ɔkyii ɔko bo sakpii mɔ dɔ. Yesu gi tɔgɛ idɛ ta mɔ, o kpen tɔgɛ Yesu yɛɛ, “Kaasɛ ɔbono ɔ korogɛ fo ne fo nyabo mɔ mɔ, mɔ‑rɛ gimu dɛnsɛ.” ");
INSERT INTO acd_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Yesu, mɔ, gi lɛɛ gɛnɔ sa ɔkyii mɔ yɛɛ, “Omudɛnsɛbo gbaa-gbaa, mɔ, ne n gyɛ ɔbono ɔ laa nu Wurubuaarɛ agyɛbi ne ɔ laa gyi amɔ so mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Sakpii ɔbono ɔ kya ba Yesu asɛ mɔ kpɛ ɔ kya nyaakyɔ ɔ kya too mɔ, Yesu gi yii gɛsɛ ɔ kya tɔgɛ ɔ kya sa mɔmɔ yɛɛ, “Ndɛ nkɛ ndɛ asa mɛ bo ilaa nyɛnyɛn. Mɛ kpɛ mɛ kya laarɛ yɛɛ nꞌ wɔra ilaa sa mɔmɔ de iꞌ lɛɛ nyiile yɛɛ Wurubuaarɛ ne n sa me ɔlon ɔbono n dɛ mɔ. Ilaa lɛɛnyiilesɛ kolon guan‑n ne Wurubuaarɛ laa wɔra sa ɔmɔ. Gɛnen ilaa ibono mɔ i laa wɔra daa fɛɛ ibono i ba Gyoona so mɔ ɔnan. ");
INSERT INTO acd_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Wurubuaarɛ gi kyu mɔ-ɔlon wɔra ilaa sa mɔ-ikalan ɔtɔgɛbo Gyoona, ne i wɔra ilaa lɛɛnyiilesɛ sa Ninifa awura. Gɛnen kee ne ɔ laa kyu mɔ-ɔlon wɔra ilaa sa me, anyamesɛ pɛwu mɔmɔ-daa mɔ ne. I laa wɔra ilaa lɛɛnyiilesɛ sa ndɛ asa adɛ. ");
INSERT INTO acd_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","“Owi ɔbono Wurubuaarɛ laa gyi anyamesɛ pɛwu nbɛlɛ mɔ, wura kyiisɛ ɔbono o gyi gɛwura Siiba gɛsinkpan so dedaa mɔ laa yelɛ tɔgɛ yɛɛ i kaaborɛ Wurubuaarɛ oꞌ bun fɛye ndɛ asa adɛ gipuɛɛ. I lii fɛɛ Wura Solomon owi mɔ, gɛnen ɔkyii baarɛ gi nu Solomon ɔlaako ginyi mɔ so, ne ɔ koso lii koo-koo mɔ-gɛwi kpaa nu Wura Solomon ɔlaako ginyi ilaa nyiilesɛ mɔ. Fɛye berɛ, fɛ nyɛ me ɔbono nɛ don Wura Solomon mɔ n bo fɛye asɛ gɛrɛ ndɛ, ne fɛ mɛŋ sɔɔ me gyi. ");
INSERT INTO acd_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Gɛkaabono kee mɔ, Ninifa awura mɛ laa yelɛ tɔgɛ yɛɛ i kaaborɛ Wurubuaarɛ oꞌ bun fɛye ndɛ asa gipuɛɛ. I lii fɛɛ Gyoona owi mɔ, Gyoona gi tɔgɛ Wurubuaarɛ ɔkalan sa Ninifa awura mɔ, mɛ nu mɔmɔ-nyoro gɛsɛ ne mɛ kyɛɛgɛ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ. Fɛye berɛ, fɛ nyɛ me ɔbono nɛ don Gyoona mɔ, n bo fɛye asɛ gɛrɛ ndɛ, ne fɛ mɛŋ sɔɔ me gyi.” ");
INSERT INTO acd_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Yesu gi da mɔmɔ gikpalɛ yɛɛ, “Ɔko mɛŋ bo no ɔ laa nyɔga fatela de oꞌ kyu yii nfono i ŋara mɔ abɛɛ oꞌ kyu fɛɛ tasa baala bun mɔ so. Ɔ laa kyu mɔ kyɔlɔga daa de asa abono mɛ laa ba fatela mɔ asɛ mɔ iꞌ nyɛ wu mɔmɔ peren‑n. ");
INSERT INTO acd_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Fɛye-nwɔnsa gi boran mɔ, fɛ dɛ fɛɛ ɔbono mɔ-ansi a boran mɔ. Fɛye-ansi a boran mɔ, fɛ laa wu ilaa kamaasɛ. Ne fɛɛ fɛye-ansi aŋ boran mɔ, fɛye-ilaa kamaasɛ i bo daa gibiri dɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Imɔso fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de fɛye-gɛwɔnsa gɛbono gɛ kya yɛgɛ fɛ kya nu ilaa gɛsɛ mɔ gɛŋ sa gɛꞌ nyida. ");
INSERT INTO acd_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Nengyene Wurubuaarɛ kya yɛgɛ fɛꞌ nu ilaa gɛsɛ ne sɛi mɛŋ sii gibiri dɔ sa fɛye mɔ, fɛye-gɛkyena dɔ ilaa i laa wɔra fɛɛ fatela ne n kya wu hayin.” ");
INSERT INTO acd_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Ibono Yesu gi tɔngɛ ta mɔ, Farasii gikpen mɔ dɔ ɔnyen ɔko gi da gibaa terɛ mɔ yɛɛ ɔꞌ ba mɔ-gɛten dɔ de mɔ‑rɛ mɔ mɛꞌ gyi. Yesu gi kpe kpaa tu asa ako ogyiten mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Yesu gi yii gɛsɛ ɔ kya gyi agyudɔ mɔ mɔ, i dɛ Farasiinyen mɔ gɛnɔ yɛɛ Yesu mɛŋ foro mɔ-abaa mɔmɔ Gyuda awura itiibilaa aforobi de iŋ sa iꞌ kyɔlesɛ mɔ-Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Gɛnen so mɔ, Wura Yesu gi tɔgɛ sa mɔ yɛɛ, “Gɛnɔɔbono fɛye Farasii awura fɛ kya wɔra mɔ, fɛ dɛ fɛɛ asa abono mɛ kya foro mɔmɔ-nwɛ de mɔmɔ-ilɛpɛ imɔ-nyoro so taa imɔ tudɔ yɛgɛ mɔ. Imɔ ne n gyɛ yɛɛ ansi so giyan ne fɛ kya gyere lɔrɔ fɛye-nyoro. Fɛye-itɔ dɔ de fɛye-amu dɔ berɛ, onsipara de gɛkyo ne n bɔla nno. ");
INSERT INTO acd_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Fɛŋ kya sa gɛwɔnsa kpe gɛta! Iŋ gyɛ Wurubuaarɛ kolon ɔbono ɔ pɔrɔ nyoro mɔ kee ne n pɔrɔ ɔtɔ? ");
INSERT INTO acd_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Fɛꞌ kyu ilaa ibono i bo fɛye-asen dɔ mɔ kyu wɔra gidɛnsɛ sa ayenbo. Fɛ wɔra gɛnen mɔ, fɛ laa wu yɛɛ sɛi maŋ baa kyɔlesɛ fɛye-ɔson mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Fɛye Farasii awura adɛ, fɛye laako! Ansi so berɛ mɔ, fɛ kya bii yɛ fɛye-ilaa dɔ gikpadɔ gudu-gudu de fɛꞌ kyu gikpadɔ kolon-kolon kyu sa Wurubuaarɛ fɛɛ gɛnɔɔbono i dɛ sa fɛye mɔ, dabɔlɛ de afɛdaa gyisɛ fɛɛ agbɛɛma de malebokyu gbaa. Fɛ kya wɔra imɔ idɛ pɛwu faa mɔ, gɛnɔɔbono fɛ laa gyi gɛsintin sa asa abɛɛ fɛꞌ laarɛ Wurubuaarɛ ilaa mɔ berɛ, fɛ kya lɛɛ ansi yɛgɛ imɔ. Nbara nbono, mɔ, ne i kaaborɛ fɛꞌ tansi gyi nmɔ so. Iŋ gyɛ yɛɛ fɛꞌ taa nbono fɛ ti fɛ kya gyi nmɔ so mɔ yɛgɛ daa. ");
INSERT INTO acd_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Fɛye Farasii awura, fɛye laako! Nengyene fɛ kya kpe fɛye-akyangbon dɔ mɔ, abelɛnsɛ ikyenaten gikyena ne n tiri fɛye. Fɛ kya laarɛ asa mɛꞌ kyu buubuu faala fɛye sakpii dɔ de ɔkamaasɛ oꞌ wu. ");
INSERT INTO acd_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Fɛye laako! Fɛye-ilaa nyɛnyɛn i ŋara fɛye-itɔ dɔ fɛɛ nkyan nbono mɛ mɛŋ daasɛ nmɔ ne asa mɛ kya kyise nmɔ so kyon mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Yesu gi tɔgɛ ilaa idɛ mɔ, Gyuda awura nbara anyiilebo mɔ dɔ ɔko gi tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, fo tɔgɛ ilaa idɛ mɔ, fɛ saalɛ aye kee ne.” ");
INSERT INTO acd_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛye nbara anyiilebo mɔ kee, fɛye laako! Fɛye-anyiilebi mɔ a dɛ daa fɛɛ nsola boduduusɛ nbono giŋ bo gisola ne fɛ dɛ fa‑a nyise asa. Fɛye gbaa-gbaa berɛ fɛ maŋ kyu ba‑a fɛye-gibaa kolon taa puru kpaa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Fɛye laako! Fɛ kya pɔrɔ nkyan fɛ kya wɔra Wurubuaarɛ ikalan atɔgɛbo abono fɛye-naanaana mɛ mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Fɛ kya pɔrɔ mɔmɔ-nkyan mɔ faa mɔ, fɛ kya kyule yɛɛ ibono fɛye-naanaana mɔ mɛ mɔɔ mɔmɔ gɛnen mɔ, i boran sa fɛye ne. ");
INSERT INTO acd_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Fɛye‑rɛ fɛye-naanaana ilaa wɔrasɛ i kyena de ibono Wurubuaarɛ gi wolaa tɔgɛ mɔ-Ɔlaako Ginyi Ɔwolɛ mɔ dɔ mɔ. Ɔ tɔgɛ yɛɛ, ‘Nan sun me-ikalan atɔgɛbo de me-isɔɔ mɔmɔ asɛ. Mɛ laa mɔɔ mɔmɔ ako, ne mɛ laa ka mɔmɔ ako ansi.’ ");
INSERT INTO acd_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","“Imɔ idɛ so mɔ, Wurubuaarɛ ikalan atɔgɛbo abono pɛwu asa mɛ mɔɔ kyu lii gɛsinkpan so gɛkyena giyiigɛsɛ kyu baa lii de ndɛ mɔ, Wurubuaarɛ laa kyu imɔ-ilaa kyu taasɛ ndɛ asa de ɔꞌ biidɛ mɔmɔ-giso. I lii fɛɛ mɛ kyule yɛɛ ibono mɛ mɔɔ mɔmɔ mɔ, i kyena sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Ɔ laa yii gɛsɛ taasɛ ndɛ asa ilaa kyu lii Abelɛ ɔbono mɛ gyangbara mɔɔ mɔ mɔ kyu gɛnen‑n baa lii Sakariya-lɛɛ lɛwu mɔ so. Ɔbono, mɔ, mɛ mɔɔ mɔ Wurubuaarɛ asunbi ɔlɛɛten de Wurubuaarɛ obu belɛ mɔ nsana. N kya buu mi‑i sa fɛye yɛɛ Wurubuaarɛ laa biidɛ fɛye ndɛ asa adɛ giso kyu lii gɛnen asa abono lɛwu so. ");
INSERT INTO acd_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Fɛye nbara anyiilebo, fɛye laako! Fɛ kyu ilaa ibono nkana i laa yɛgɛ de asa mɛꞌ bii Wurubuaarɛ ilaa mɔ kyu ŋara mɔmɔ. Fɛye gbaa-gbaa fɛ mɛŋ kya kyu de ɔlaako ginyi ɔkpa mɔ, ne fɛ kii koso ŋɛ fɔlɔgɛ tii abono mɛ kya laarɛ de mɛꞌ kyu de ɔkpa ɔbono mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Lii owi ɔbono Yesu gi lii Farasiinyen mɔ gɛwi mɔ, nbara aŋmarasɛbo mɔ de Farasii awura mɔ mɛ san mɛ dɛ mɔ ginyadon, ne mɛ kya laarɛ mɛꞌ nu mɔ-gɛnɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Mɛ kya soo mɔ idoo de ɔꞌ nyɛ tɔgɛ ilaa nyɛnyɛn iko de mɛꞌ nyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Gɛnen aberɛ abono dɔ mɔ, asa sakyɔ mɛ koola gyanꞌ Yesu asɛ kaaborɛ mɛ kya kyise abara ayaa. Mɛ ba gɛnen mɔ, Yesu gi daa gitɔngɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan. Farasii awura mɔ mɛ gyɛ o-dun-me, ɔ-fon-me anyamesɛ. Mɔmɔ-ilaa nyiilesɛ i dɛ daa fɛɛ gɛlin gɛbono gɛ kya yɛgɛ bodobodo kya ŋan mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","I lii fɛɛ sɛi mɛŋ bo no i bo asiiri dɔ yɛɛ i maŋ lii gɛwi, abɛɛ ilaa iko i ŋara yɛɛ i maŋ lii gifuuli. ");
INSERT INTO acd_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Imɔso ilaa ibono fɛ ŋara tɔgɛ gɛnyɛ mɔ, asa mɛ laa nu imɔ owi ken-ken, ne ilaa ibono fɛ tɔgɛ adɛɛdɛɛ dɔ wɔra abara aso dɔ obu dɔ fɛye-wolɛ mɔ, asa mɛ laa liirɛ imɔ da gikpengboo. ");
INSERT INTO acd_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Nꞌ buu sa fɛye abono fɛ gyɛ me-kyɛmenɛana mɔ yɛɛ fɛꞌ mɛŋ sa fɛꞌ selɛ mɔmɔ abono mɛ laa mɔɔ daa nyamesɛ nyoro gibi mɔ wolɛ ne mɛ maŋ baa taalɛ nyida mɔ-oduduu bɔla mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nan tɔgɛ fɛye ɔbono i kaaborɛ fɛꞌ selɛ mɔ. Fɛꞌ selɛ daa Wurubuaarɛ. Mɔ berɛ, nengyene ɔ mɔɔ fɛye-nyoro gibi mɔ, ɔ bo ɔlon de oꞌ kii taalɛ too fɛye wɔra ɔgya dɔ nfono ɔ kya biidɛ ilaa nyɛnyɛn awɔrabo giso mɔ. Ɛn, n kya tɔgɛ mi‑i sa fɛye yɛɛ mɔ ne fɛꞌ selɛ. ");
INSERT INTO acd_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Abonbuɛ abono mɛ kya fɛ mɔmɔ anun aterenbi abi anyɔ gbaa mɔ, Wurubuaarɛ mɛŋ kya tan mɔmɔ dɔ ɔkolon so. ");
INSERT INTO acd_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne fɛye mɔ de‑e? Wurubuaarɛ nyi dabɔlɛ fɛye-gimu dɔ iman gɛgyɔnɔ gbaa. Imɔso fɛ mɛŋ sa fɛꞌ selɛ gifuu. Fɛ tiri sa Wurubuaarɛ gikyɔ don gɛnen abonbuɛ abono afonɛɛ-afonɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Nꞌ buu sa fɛye yɛɛ, ɔbono ɔ yelɛ asa dɔ tɔgɛ yɛɛ me ne n gyɛ mɔ-wura mɔ, gɛnen ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ kee, nan lɛɛ tɔgɛ Wurubuaarɛ dɔ isɔɔ mɔ ansi dɔ yɛɛ ɔ gyɛ me-sonbo. ");
INSERT INTO acd_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne ɔbono, mɔ, o kine me sansana yɛɛ meŋ gyɛ mɔ-wura mɔ, gɛnen ne me kee nan kine mɔ Wurubuaarɛ dɔ isɔɔ mɔ ansi dɔ yɛɛ ɔ mɛŋ gyɛ me-sonbo. ");
INSERT INTO acd_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Fo ɔbono fo saalɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ mɔ, i laa sa de Wurubuaarɛ oꞌ kyu kyɛɛ fo. Ɔbono, mɔ, ɔ saalɛ Wurubuaarɛ Oduduu mɔ mɔ berɛ, Wurubuaarɛ maŋ kyu imɔ ibono kyɛɛ kaasɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Nengyene fɛɛ asa mɛ kyu fɛye kpe akyangbon dɔ, awura-awura asɛ de abelɛnsɛ asɛ mɔ, fɛꞌ mɛŋ sa fɛꞌ yɛgɛ iꞌ wɔra fɛye gɛwɔnsa yɛɛ nnɛ ne fɛ laa lɛɛ gɛnɔ abɛɛ menɛ ilaa ne fɛ laa tɔgɛ. ");
INSERT INTO acd_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Owi mɔ gi fo mɔ, Wurubuaarɛ Oduduu mɔ laa nyiile fɛye gɛnɔɔbono fɛ laa lɛɛ gɛnɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Ɔnyen ɔko bo sakpii mɔ dɔ nfono. Ɔ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, tɔgɛ sa me-daa de ɔꞌ yɛgɛ aꞌ gyi aye-sɛ atɔ abono o wuꞌ taa yɛgɛ sa aye mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Yesu gi taasɛ mɔ yɛɛ, “Ɔnyen, me ne n gyɛ fɛye-atɔ ɔyɛbo? Iŋ gyɛ fɛye-atɔ giyɛ so ne Wurubuaarɛ gi sun me ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Yesu gi kine sa ɔnyen mɔ gɛnen mɔ, o kisee tɔgɛ sa sakpii mɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dandan. Onsipara ne n gyɛ onsipara, fɛŋ sa fɛꞌ wɔra. Fo nyamesɛ ne n kine fo bo awuratɔ nnɛ, i maŋ yɛgɛ foꞌ nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan.” ");
INSERT INTO acd_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Nfono ne Yesu gi too ɔtarɛ sa mɔmɔ yɛɛ, “Aberɛ ako dɔ mɔ, aterenbi wura ɔko gi kyena ibono ɔ bo ndɔɔ. Gɛsi gɛko dɔ mɔ, mɔ-ndɔɔ gi wɔra ɔdan sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ne ɔ sa gɛwɔnsa yɛɛ, ‘Nnɛ ne nan wɔra? Me-agbaran mɔ aŋ kyɔ sa me-agyudɔ abono nɛ dɔɔ faa. ");
INSERT INTO acd_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Nbuo, nɛ bii ilaa ibono nan wɔra mɔ. Nan singi agbaran adɛ, de nꞌ kii lɔrɔ yii abelɛ-belɛ. Nfono ne nan kyu me-ilaa gyisɛ mɔ pɛwu yela. ");
INSERT INTO acd_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nɛ wɔra gɛnen ta mɔ, nan tɔgɛ sa me-nyoro yɛɛ n bo ilaa gyisɛ ibono i laa fo me gigyi nsi nfonɛ nfonɛ. Imɔso nan kyoola, de nꞌ gyi, de nꞌ nun, de me-gisen giꞌ tɔrɔ me.’ ");
INSERT INTO acd_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","“Ɔ kpɛ ɔ kya sa idɛana pɛwu gɛwɔnsa mɔ, Wurubuaarɛ gi tɔgɛ sa mɔ yɛɛ, ‘Fo mɛŋ nyi ɔlaako. Ndɛ gɛnyɛ gɛdɛ kpini fo laa wuꞌ. Fo wuꞌ mɔ, anɛ ne nan san nyɛ gyi ilaa ibono fo baala baala yela sa fo-nyoro gɛnen mɔ?’ ” ");
INSERT INTO acd_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yesu gi tɔgɛ gɛnen mɔ, ɔ lɛɛ gɛsɛ yɛɛ, “Gɛnen kee ne i laa wɔra fo ɔbono fo baala awuratɔ yela sa fo-nyoro ne foŋ wɔra gidɛnsɛ de foꞌ nyɛ awuratɔ Wurubuaarɛ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “N kya tɔgɛ mi‑i sa fɛye yɛɛ fɛꞌ mɛŋ sa fɛꞌ suiili kyu lii fɛye-gɛkyena dɔ ilaa tirisɛ so, fɛɛ ilaa ibonoana fɛ laa gyi abɛɛ fɛ laa kyu gyanꞌ fɛye-nyoro so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Wurubuaarɛ ɔbono ɔ sa fɛye-nkpa mɔ maŋ taalɛ sa fɛye agyudɔ kee? Ɔbono ɔ sa fɛye nyoro gibi mɔ maŋ taalɛ sa fɛye ilaa ibono fɛ laa kyu gyan fɛye-nyoro so mɔ? ");
INSERT INTO acd_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Fɛꞌ taa laa ansi kerɛ nbuii. Giŋ kya duu. Giŋ kya tɛɛ. Giŋ bo agyudɔ ikoolayelaten. Imɔ‑rɛ imɔ gɛnen gbaa faa, Wurubuaarɛ kya sa mɔmɔ agyudɔ owi kamaasɛ dɔ. Ne fɛye mɔ de‑e? Fɛ mɛŋ nyi yɛɛ fɛ don nbuii gbaa bun? ");
INSERT INTO acd_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","“Fɛ suiili fɛye-gɛkyena dɔ ilaa so mɔ, nnɛ ne i laa kpaa fɛye? I maŋ yɛgɛ fɛꞌ nyɛ kyena ba‑a gɛkɛ kolon bɔla. ");
INSERT INTO acd_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nengyene fɛ maŋ taalɛ wɔra gɛnen ilaa petɛ-petɛ idɛ mɔ, menɛ n wɔra so ne fɛ kya nyala fɛye-nyoro de ilaa sɛnsɛ? ");
INSERT INTO acd_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Fɛꞌ laa ansi kerɛ gɛnɔɔbono iyii i kya wɔra afototo mɔ. Iŋ kya wɔra gɛsun ne iŋ kya luo akuru sa imɔ-nyoro. Imɔ gɛnen gbaa mɔ, n kya buu mi‑i sa fɛye yɛɛ Wura Solomon mɔ‑rɛ mɔ-awuratɔ pɛwu mɔ, ɔ mɛŋ nyɛ akuru abono a wɔra ɔdan fo gɛnen afototo adɛ. ");
INSERT INTO acd_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Iyii ibono i kya bingiri ngya mɔ gbaa ne Wurubuaarɛ kya gyere imɔ lɔrɔ kanpɛ faa. Fɛye anyamesɛ ne ɔ laa lɛɛ ansi yɛgɛ de fɛꞌ naa gibolonbukpan? O, fɛye asa adɛ, gisɔɔgyi gibono fɛ bo sa Wurubuaarɛ mɔ giŋ ti taa wɔra sɛi. ");
INSERT INTO acd_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","“Fɛꞌ mɛŋ sa fɛꞌ pɛɛrɛ ginsi ilaa ibono fɛ laa gyi de fɛꞌ nun mɔ so. Fɛŋ sa fɛꞌ yɛgɛ iꞌ wɔra fɛye nwɔnsa. ");
INSERT INTO acd_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Asa abono mɛŋ nyi Wurubuaarɛ agyɛbi mɔ ansi ne n kya pɛɛrɛ gɛnen ilaa idɛana so. Fɛye-sɛ Wurubuaarɛ nyi yɛɛ i tiri fɛye. ");
INSERT INTO acd_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Imɔso fɛye berɛ, fɛꞌ pɛɛrɛ ansi daa de Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ aꞌ ba asa dɔ. Fɛ ti fɛ kya wɔra gɛnen mɔ, Wurubuaarɛ laa yɛgɛ ilaa sɛnsɛ idɛana pɛwu kee iꞌ yii fɛye-abaa.” ");
INSERT INTO acd_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Yesu gi kii tɔgɛ yɛɛ, “Me-adɛ kalɛsɛ, fɛŋ sa fɛꞌ selɛ gifuu. I gyɛ fɛye-sɛ Wurubuaarɛ ɔbolɛ gɛlaarɛ yɛɛ ɔꞌ sa fɛye ikyenaten dɛnsɛ mɔ-gɛwuragyi mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Fɛꞌ fɛ fɛye-atɔ de fɛꞌ kyu amɔ-aterenbi kyɛɛ ayenbo. Fɛꞌ laarɛ daa ikpengyo ibono ɔnan i mɛŋ kya nyida mɔ yela sa fɛye-nyoro. Imɔ ne n gyɛ yɛɛ fɛ laa wɔra idɛnsɛ yela de fɛꞌ nyɛ ntɛɛla Wurubuaarɛ dɔ. Wurubuaarɛ dɔ-lɛɛ ntɛɛla mɔ berɛ, giŋ kya ta, oyu mɛŋ kya tu sindi nmɔ ne ntakpenbi giŋ kya nyida nmɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Imɔso fɛꞌ laarɛ daa soso-lɛɛ awuratɔ. I lii fɛɛ nfono fo-awuratɔ a bo mɔ, nfono kee ne fo-nwɔnsa gi bo.” ");
INSERT INTO acd_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Yesu gi kii tɔgɛ yɛɛ, “Fɛꞌ baala fɛye-nyoro gyoo owi ɔbono nan kii lii Wurubuaarɛ dɔ ba mɔ de fɛꞌ wɔra fɛɛ gikpalɛ gibono nan da faa. Adega ako mɔmɔ‑rɛ mɔmɔ-wura ne n bo nno. Mɔmɔ-wura mɔ gi koso kyon gɛkɛ belɛ gigyi de ɔꞌ ba. Mɛ baala mɔmɔ-nyoro mɛ tɛ mɛ gyoo mɔ. Mɛ wu yɛɛ owi gi ta ne ɔŋ ti ba mɔ, mɛ nyɔga ifatela yela, mɛ kya kerɛ mɔ-ɔkpa. Mɛ kya laarɛ fɛɛ ɔ baa ŋmɛɛ gisin mɔ, de mɛꞌ nyɛ koso tigi mɔ kusaa. ");
INSERT INTO acd_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Amudɛnsɛbo ne n gyɛ adega abono mɔmɔ-wura laa kii baa tu mɔmɔ, mɛ tɛ mɛ kerɛ mɔ-ɔkpa gɛnen mɔ. Fɛye kee fɛꞌ kyena kerɛ me-ɔkpa de fɛꞌ bii fɛye-nyoro akedabi gɛnen. Gɛsintin ne n kya tɔgɛ mi‑i sa fɛye faa, aberɛ abono adega mɔ wura mɔ gi kii baa tu ɔmɔ mɛ tɛ mɛ kerɛ mɔ-ɔkpa mɔ, ɔ laa lɔrɔ mɔ-nyoro de ɔꞌ yɛgɛ mɛꞌ kpelegɛ kyena ogyiten, de mɔ gbaa-gbaa ne ɔꞌ san kyu agyudɔ baa yii mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Gɛnyɛ de nsana abɛɛ gibaadiikɛ gbaa ne ɔ kpaa kii ba mɔ, ɔ baa tu mɔmɔ mɛ tɛ mɛ kerɛ mɔ-ɔkpa gɛnen mɔ, mɛ laa gyi mɔ-ginsi.” ");
INSERT INTO acd_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yesu gi da imɔ so gikpalɛ yɛɛ, “Iŋ gyɛ fɛye gbaa-gbaa fɛ nyi? Nkana gɛten wura nyi yɛɛ owi baarɛ ɔkara ne oyu laa ba mɔ, naafo ɔ maŋ yɛgɛ de oyu ɔꞌ nyɛ loo mɔ-gɛten dɔ baa yuuri mɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Gɛnen kee ne i kaaborɛ fɛꞌ bii fɛye-nyoro akedabi owi kamaasɛ dɔ. I kya nyiile yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan lii Wurubuaarɛ dɔ kii ba daa owi ɔbono fɛ mɛŋ dɛsɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Yesu gi tɔgɛ gɛnen mɔ, Piita gi taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, aye fo-akasɛbo mɔ wolɛ ne fo kya da gikpalɛ gidɛ faa abɛɛ ɔkamaasɛ daa?” ");
INSERT INTO acd_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Nfono mɔ, Wura Yesu gi da mɔ gikpalɛ yɛɛ, “Anɛ ne n dɛ fɛɛ dega ɔbono ilaa nan baa tɔgɛ faa? Ɔ kya gyi gɛsintin sa mɔ-wura ne o nyi ɔlaako. Mɔ-wura mɔ gi kyu mɔ-gɛten dɔ ilaa wɔra mɔ-abaa dɔ de owi gyisɛ gi fo mɔ, ɔꞌ yɛ agyudɔ sa gɛten mɔ dɔ awura. ");
INSERT INTO acd_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nengyene mɔ-wura mɔ gi baa tu mɔ ɔ kya wɔra ibono ɔ ka yela sa mɔ mɔ, ɔ laa gyi mɔ-ginsi.” ");
INSERT INTO acd_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne Yesu gi tɔgɛ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, mɔ-wura mɔ laa kyu mɔ-ilaa pɛwu kyu wɔra gɛnen dega ɔbono abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“To, ne fɛɛ dega mɔ gi tɔgɛ sa mɔ-nyoro yɛɛ, ‘Ilaa iko i keda me-wura yela,’ fo baa kerɛ mɔ, o yii gɛsɛ ɔ kya daarɛ mɔ-nanboana sɛnsɛ, anyen de akyii mɔ, ɔ kya gyi ne ɔ kya nun nta ɔ kya boo. ");
INSERT INTO acd_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Ɔ kya wɔra gɛnen mɔ, mɔ-wura mɔ laa baa tuule mɔ owi ɔbono ɔ mɛŋ dɛsɛ mɔ. Ɔ baa tuule mɔ mɔ, ɔ laa tansi biidɛ mɔ-giso de ɔꞌ kalɛ mɔ bɔla asa abono mɛŋ kya gyi gɛsintin mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Dega ɔbono o nyi mɔ-wura gɛlaarɛ ne ɔ mɛŋ baala ilaa yela abɛɛ ɔ mɛŋ wɔra mɔ-wura mɔ gɛlaarɛ mɔ, wura mɔ laa yɛgɛ mɛ laa tansi koree mɔ gɛsintin so. ");
INSERT INTO acd_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Dega ɔbono, mɔ, ɔ mɛŋ nyi ne ɔ kpaa wɔra ilaa ibono i gyɛ ilaa koreesɛ mɔ, wura mɔ laa yɛgɛ mɛ laa koree mɔ ŋmaraa daa de mɛꞌ taa mɔ yɛgɛ.” Yesu gi da gikpalɛ mɔ ta mɔ, ɔ lɛɛ gɛsɛ yɛɛ, “Ɔkamaasɛ ɔbono Wurubuaarɛ gi kyɛɛ mɔ gikyɔ mɔ, gɛnen kee ne Wurubuaarɛ laa taasɛ ilaa gikyɔ lii mɔ asɛ. Ɔbono Wurubuaarɛ gi kyu ilaa gikyɔ wɔra mɔ-abaa dɔ mɔ, ilaa ibono Wurubuaarɛ laa baa taasɛ lii mɔ asɛ mɔ kee i laa nyaakyɔ.” ");
INSERT INTO acd_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Yesu gi kii tɔgɛ yɛɛ, “Nɛ ba gɛsinkpan so faa, ɔgya ne nɛ ba de nꞌ baa nyɔga kyu too gɛmɔ so. Nkana fɛɛ gɛnen ɔgya ɔbono gi ti kyangɛ gbaa mɔ, i gyɛ me-gɛlaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Pɛi de nꞌ wɔra gɛnen mɔ, ɔlaawusɛ ɔko laa tu me. Gɛnen ɔlaawusɛ ɔbono ne nan yɛgɛ nꞌ wɔra Wurubuaarɛ gɛlaarɛ kpaa logɛ. Ɔlaawusɛ ɔbono mɛŋ ti tu me faa mɔ, me-gisen giŋ tɛ me gɛten kolon. ");
INSERT INTO acd_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“Imɔso fɛ nyi yɛɛ nɛ ba faa mɔ, i laa yɛgɛ asa mɛꞌ nyɛ gisen yuuli kyu kyena de abara daa? Kuaa! Nꞌ buu sa fɛye yɛɛ me-giba mɔ gi laa baragɛ asa abono mɛ kya nu me-gɛdɛ mɔ lii abono mɛŋ kya nu me-gɛdɛ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Kpɛ kyu lii ndɛ kyu kyon mɔ, gɛten kolon dɔ asa anun dɔ mɔ, asaꞌ mɛ laa wɔra gɛnɔ anyɔ mɔ so, ne anyɔ mɔ, mɔ, mɛ laa wɔra gɛnɔ asaꞌ mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ɔnyen mɔ‑rɛ mɔ-sɛ mɛ maŋ nu abara asɛ. Ɔkyii mɔ‑rɛ mɔ-nyi mɛ maŋ nu abara asɛ. Ne ɔkyii mɔ‑rɛ mɔ-saa kyiisɛ mɛ maŋ nu abara asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Yesu gi kii tɔgɛ sa sakpii ɔbono ɔ bo nno mɔ yɛɛ, “Nengyene fɛ kpɛ nyɛ ne fɛ wu nyangbon kya yii mɔ, fɛ kya bii tɔgɛ yɛɛ nyangbon laa da. Gɛsintin mɔ, nyangbon mɔ kya baa da. ");
INSERT INTO acd_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne fɛ wu yɛɛ owi gi baa lii nyɛnyɛngɛ fu‑u awulun aberɛ mɔ, fɛ kya bii tɔgɛ kee yɛɛ, ‘Ndɛ berɛ owi laa lii de ɔlon.’ Gɛsintin mɔ, i kya ba gɛnen. ");
INSERT INTO acd_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Gikerɛansi awura! Fɛ kya kerɛ soso de gɛsinkpan adebi de fɛꞌ bii tɔgɛ yɛɛ ilaa idɛ ne nan wɔra. Fɛŋ kaaborɛ fɛꞌ bii kerɛ nkɛ ndɛ-lɛɛ ilaa dɔ de fɛꞌ bii ilaa ibono Wurubuaarɛ kya laarɛ ɔꞌ baa wɔra mɔ? ");
INSERT INTO acd_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Fɛye gbaa-gbaa fɛꞌ kerɛ ilaa dɛnsɛ de ilaa nyɛnyɛn dɔ de fɛꞌ lɛɛ ibono i boran mɔ wɔra. ");
INSERT INTO acd_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","“Nengyene ɔko gi terɛ fo ɔko nbɛlɛ ne fɛ kya kpe nbɛlɛ mɔ ogyiten mɔ, kyu aniya de fo‑rɛ mɔ fɛꞌ tɔgɛ lɔrɔ ɔkpa dɔ pɛi de fɛꞌ lɔɔ loo. I mɛŋ gyɛ gɛnen mɔ, foŋbii ɔ laa kyu fo kpe nbɛlɛ ogyibo mɔ asɛ de ɔbono, mɔ, oꞌ kyu fo kpaa wɔra ngbɛ awura ɔbelɛnsɛ abaa dɔ de ɔꞌ keda fo tii de obu. ");
INSERT INTO acd_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","N kya buu mi‑i sa fɛye yɛɛ mɛ keda fo tii de obu gɛnen mɔ, fo laa sii nno gɛnen‑n kpaa fo owi ɔbono ɔkara mɛꞌ wu yɛɛ fo ka fo-ilaa nyɛnyɛn gikɔ mɔ ta mɔ, pɛi de mɛꞌ lɔɔ tigi fo.” ");
INSERT INTO acd_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Gɛnen owi ɔbono dɔ mɔ, asa ako mɛ baa buu sa Yesu yɛɛ Ɔbelɛnsɛ Pilato gi mɔɔ Galeli asa ako. Owi ɔbono ɔ mɔɔ mɔmɔ gɛnen mɔ, mɛ yelɛ mɛ kya kyan asunbi mɛ kya sa Wurubuaarɛ. Imɔso i yɛgɛ mɔmɔ-nkalan gbaa gi saarɛ nbuɛ nbono mɛ kyu kyan asunbi mɔ lɛɛ nkalan dɔ. ");
INSERT INTO acd_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mɛ buu sa Yesu gɛnen mɔ, ɔ lɛɛ gɛnɔ taasɛ yɛɛ, “Gɛnɔɔbono gɛnen asa adɛ mɛ wuꞌ awɔrɔfɔɔ lɛwu faa mɔ, fɛ nyi yɛɛ mɔmɔ-ilaa nyɛnyɛn i kyɔ don Galeli asa sɛnsɛ daa abɛɛ? ");
INSERT INTO acd_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Kuaa. N kya buu mi‑i sa fɛye yɛɛ nengyene fɛ maŋ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ lii fɛye-ilaa nyɛnyɛn giwɔra dɔ mɔ, gɛnen kee ne fɛye pɛwu fɛ laa wuꞌ ne.” ");
INSERT INTO acd_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Yesu gi kii taasɛ mɔmɔ yɛɛ, “Ne asa gudu gukue abono obu lege-lege mɔ gi gbaa mɔɔ mɔmɔ Silowam mɔ de‑e? Fɛ nyi yɛɛ gɛnen asa abono kee, mɔmɔ-lɛɛ ilaa nyɛnyɛn i kyɔ don Gyɛrusalem awura-lɛɛ? ");
INSERT INTO acd_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Kuaa. N kya buu mi‑i sa fɛye yɛɛ nengyene fɛ maŋ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ lii fɛye-ilaa nyɛnyɛn giwɔra dɔ mɔ, gɛnen kee ne fɛye pɛwu fɛ laa wuꞌ ne.” ");
INSERT INTO acd_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Nfono mɔ, Yesu gi da mɔmɔ gikpalɛ yɛɛ, “Ɔnyen ɔko gi kyena. Ɔ bo ndɔɔ, ne o duu oyii ɔko ɔ laa sɔrɔ abi gyisɛ mɔ-ndɔɔ mɔ dɔ. Ɔ bo ɔko kya kerɛ ndɔɔ mɔ so ɔ sa mɔ. Gɛkɛ gɛdɛ mɔ, o kpe ndɔɔ, ne ɔ naa kpe oyii mɔ asɛ de ɔꞌ kpaa kerɛ yɛɛ ɔ laa nyɛ mɔ-abi de oꞌ gyi abɛɛ? O kpe gɛnen mɔ, ɔ mɛŋ nyɛ ba‑a gibi kolon. ");
INSERT INTO acd_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Imɔso ɔ tɔgɛ sa mɔ-ndɔɔ ɔkerɛbo mɔ yɛɛ ɔꞌ ŋɛ oyii mɔ fuɛ. I lii fɛɛ nsi nsa ne ɔ kya ba gɛrɛ faa, ɔŋ kya nyɛ oyii mɔ abi. Ɔ yelɛ giyan. Ɔ mɛŋ bo agyan. ");
INSERT INTO acd_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Nfono mɔ ne mɔ-ndɔɔ ɔkerɛbo mɔ gi lɛɛ gɛnɔ yɛɛ, ‘Ɔbelɛnsɛ, yɛgɛ ɔꞌ yelɛ gɛsi kolon de aꞌ kerɛ. Nan puligi mɔ-gikɔɔrɛ dɔ kyaabɔɔ de nꞌ kyu fɛɛ inaadɛbin worogɛ opuligiten mɔ. ");
INSERT INTO acd_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Gɛsi gɛꞌ baa gyanꞌ mɔ, foŋbii mɔ ɔ laa sɔrɔ. Nengyene ɔ mɛŋ kii sɔrɔ berɛ mɔ, pɛi de ɔꞌ lɔɔ wɔra ɔŋɛfuɛsɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Gɛkɛ kyoolasɛ gɛko mɔ, Yesu kya nyiile asa ilaa Gyuda awura gikyangbon giko dɔ. ");
INSERT INTO acd_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ɔkyii ɔko bo nno, ilaa nyɛnyɛn oduduu tɛ mɔ so, ne i yɛgɛ ɔ loo gilɔ. Ɔ mɛɛ faa gɔnꞌgerɔnꞌgɔn. Ɔ mɛŋ kya taalɛ yelɛ ntintin. I wɔra ɔkyii mɔ gɛnen mɔ, imɔ nsi gudu gukue ne. ");
INSERT INTO acd_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Yesu gi wu ɔkyii mɔ mɔ, ɔ terɛ mɔ ba mɔ asɛ, ne ɔ tɔgɛ mɔ yɛɛ, “Ɔkyii, fo-gilɔ mɔ giꞌ ta sa fo!” ");
INSERT INTO acd_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ne o kyu mɔ-abaa kyu gyanꞌ ɔkyii mɔ so. Ayaa abono so mɔ, gilɔ mɔ gi ta ne ɔkyii mɔ gi tengɛ yelɛ ntintin ne ɔ yen Wurubuaarɛ kyu lii ilaa ibono Wurubuaarɛ gi yɛgɛ Yesu gi wɔra sa mɔ mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Yesu gi kyɛ ɔkyii mɔ gɛkɛ kyoolasɛ so mɔ, i kya loo ɔbelɛnsɛ ɔbono ɔ kya kerɛ gikyangbon gibono so mɔ. Gɛnen so mɔ ɔbelɛnsɛ mɔ gi tɔgɛ sa asa abono mɛ bo gikyangbon mɔ dɔ mɔ yɛɛ, “Nkɛ sono dɔ mɔ, nkɛ nsee ne i kaaborɛ fɛɛ aꞌ kyu wɔra gɛsun; gɛkɛ sonosɛ mɔ gɛ gyɛ gɛkɛ kyoolasɛ sa aye. Imɔso fɛꞌ kyena ba daa nkɛ nbono dɔ i kaaborɛ asa mɛꞌ wɔra gɛsun mɔ de mɛꞌ kyɛ fɛye. Fɛ mɛŋꞌ baa kyena ba nkɛ kyoolasɛ yɛɛ mɛꞌ kyɛ fɛye.” ");
INSERT INTO acd_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Ɔbelɛnsɛ mɔ gi tɔgɛ gɛnen sa asa mɔ mɔ, Wura Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fo‑rɛ abono fɛ dɛ gɛnen gɛwɔnsa gɛdɛ mɔ, fɛ gyɛ o-dun-me, ɔ-fon-me anyamesɛ. Imɔso aye-gɛkɛ kyoolasɛ so mɔ, fɛye ɔkamaasɛ mɛŋ kya sangɛ mɔ-gɛbuɛ fɛɛ naadɛ abɛɛ bee de ɔꞌ kparɛ mɔ lii mɔ-ɔdɛten kyu mɔ kpe de ɔꞌ kpaa nun nkyu? ");
INSERT INTO acd_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","To! Fɛꞌ kerɛ gɛnen ɔkyii baarɛ, aye-naana Aberaham ɔpaa dɔ isa ne. Ilaa nyɛnyɛn pɛwu gɛmu mɔ gi nyɛ mɔ wɔra mɔ-gyɔlɔ dɔ faa, imɔ nsi gudu gukue ne. Imɔso i mɛŋ kaaborɛ fɛɛ gɛkɛ kyoolasɛ fɛɛ gɛdɛ faa mɔ, ɔkyii baarɛ ɔꞌ nyɛ de nꞌ lɛɛ mɔ lii ilaa nyɛnyɛn pɛwu gɛmu mɔ abaa dɔ?” ");
INSERT INTO acd_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Yesu ilaa taasɛsɛ mɔ ɔ taasɛ gɛnen mɔ, i wɔra mɔ-akyobo pɛwu ipeeli. Sakpii ɔbono ɔ kya kyena buu mɔ mɔ pɛwu berɛ ilaa dɛnsɛ ibono Yesu kya kyena wɔra fɛɛ idɛ ɔnan pɛwu mɔ i bo mɔmɔ ɔbolɛ gikyɔ kyɔde. ");
INSERT INTO acd_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Nfono mɔ, Yesu gi taasɛ yɛɛ, “Wurubuaarɛ gɛwuragyi dɔ akyenabi a dɛ nnɛ? Menɛ ne nan kyu kɛserɛ de amɔ ne? ");
INSERT INTO acd_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi a kya yɛlegɛ asa dɔ mɔ, i dɛ daa fɛɛ Maasadɛ giponfɛ ilaa. Dɔɔbo gi duu gimɔ abi ŋini-ŋini ndɔɔ dɔ mɔ, gi laa kɔrɔ de giꞌ sen wɔra giponfɛ kpatakperɛ. Nbuii gbaa gi laa baa luo asisaa gimɔ-ngyalenbi dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yesu gi kii taasɛ yɛɛ, “Menɛ ne nan kyu Wurubuaarɛ gɛwuragyi dɔ akyenabi kyu kɛserɛ de ne? ");
INSERT INTO acd_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Gɛnɔɔbono Wurubuaarɛ gɛwuragyi dɔ akyenabi a kya yɛlegɛ asa dɔ mɔ i dɛ daa fɛɛ gɛlin gɛbono mɛ kya kyu wɔra bodobodo ne ɔ kya ŋan dii mɔ. Mɛ kya kyu gɛnen gɛlin gɛbono kyu bagadɛ bodobodo nnyufo fɛɛ imudu isaꞌ dɔ mɔ, gɛ kya yɛlegɛ loo saarɛ nnyufo mɔ pɛwu dɔ de bodobodo mɔ ɔꞌ ŋan dii.” ");
INSERT INTO acd_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Yesu kya kpe Gyɛrusalem mɔ, ɔ naa de isowolɛ belɛ-belɛ de ipii-pii so ɔ kya nyiile asa ilaa. ");
INSERT INTO acd_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Owi ɔko dɔ mɔ, ɔko gi kpaa taasɛ Yesu yɛɛ, “Ɔbelɛnsɛ, imɔso asa abono mɛ laa nyɛ Wurubuaarɛ ɔꞌ mɔlɛgɛ mɔmɔ de mɛꞌ nyɛ kyena mɔ asɛ mɔ mɛ laa wɔra daa asa kalɛsɛ?” Ɔ taasɛ gɛnen mɔ, Yesu gi tɔgɛ sa asa abono mɛ bo mɔ asɛ nfono mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Fɛꞌ nyanga ansi de fɛꞌ loo de gɛbunono pi‑i gɛbono gɛ dɛ kpe Wurubuaarɛ asɛ gɛkyena mɔ dɔ mɔ. Nꞌ buu sa fɛye yɛɛ asa abono mɛ laa laarɛ yɛɛ mɛꞌ nyɛ gɛkyena Wurubuaarɛ asɛ ne mɛ maŋ nyɛ mɔ, mɛ laa nyaakyɔ.” ");
INSERT INTO acd_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Yesu gi da imɔ so gikpalɛ sa mɔmɔ yɛɛ, “Owi gi ta mɔ, gɛten wura laa yɛgɛ mɛꞌ tii mɔ-gikpaara gɛbunono wɔra giŋanbi, asa mɛŋ baa nyɛ loo. Fɛye dɔ ako fɛ laa san fɛ yelɛ nŋmaŋman fɛ kya ŋmɛɛ mɔ-gisin yɛɛ, ‘Ɔbelɛnsɛ, tigi aye!’ Nfono mɔ, mɔ mɔ laa tɔgɛ yɛɛ, ‘Meŋ nyi fɛye.’ ");
INSERT INTO acd_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","I ba gɛnen mɔ, fɛ laa dɛ mɔ giserɛ yɛɛ, ‘Ɔbelɛnsɛ, aye‑rɛ fo a gyi ne a nun dabɔlɛ kerɛ. Fo nyiile asa ilaa aye-isowolɛ so.’ ");
INSERT INTO acd_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Nfono mɔ ɔbelɛnsɛ mɔ laa kii lɛɛ gɛnɔ yɛɛ, ‘Meŋ nyi fɛye. Me ne n tɔgɛ sa fɛye. Fɛ gyɛ daa ilaa nyɛnyɛn awɔrabo. Fɛꞌ naa me-ansi so!’ ");
INSERT INTO acd_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Nfono mɔ osulon de anɛbi giwɛ i laa tɔrɔ fɛye so. I lii fɛɛ fɛ laa wu Iloobu Aberaham, Ayisiki, de Gyeekɔpo de mɔmɔ abono pɛwu mɛ tɔgɛ Wurubuaarɛ ikalan baa kyon mɔ mɛ nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi mɔ dɔ, ne fɛye, mɔ, Wurubuaarɛ gi gya fɛye lii mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Asa mɛ laa lii ansi de gɛmara de benɛ so de gyisɛ so pɛwu ba, de mɛꞌ baa nyɛ ɔkyenaten Wurubuaarɛ gɛwuragyi mɔ dɔ. Mɛ laa gyi de mɛꞌ nun de ɔkon. ");
INSERT INTO acd_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Gɛnen gɛwuragyi gɛbono dɔ mɔ, fɛ laa wu yɛɛ abono mɛ gyɛ gɛmara awura gɛsinkpan so ilaa dɔ mɔ ako mɛ laa kpaa wɔra agyangbarabo, ne abono mɛ gyɛ agyangbarabo gɛsɛ gɛrɛ mɔ ako mɛ laa kpaa bingiri gɛmara awura.” ");
INSERT INTO acd_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Yesu gi kpɛ tɔgɛ gɛnen ta mɔ, ayaa abono so mɔ, Farasii awura ako mɛ baa tɔgɛ sa mɔ yɛɛ, “Naa lii gɛrɛ kpe gɛten banban. I kya nyiile yɛɛ Wura Hɛrodɛ kya laarɛ fo-imɔɔten.” ");
INSERT INTO acd_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Nfono mɔ Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kpaa tɔgɛ sa Wura Hɛrodɛ ɔbono ɔ dɛ fɛɛ agyagaa mɔ yɛɛ, ‘Nkɛ kalɛsɛ ndɛ dɔ mɔ, n kya gya ilaa nyɛnyɛn oduduu kpɛi-kpɛi n kya koso asa so ne nꞌ kya kyɛ asa alɔtɔ. Imɔ idɛ gɛmara mɔ, nan wɔra ilaa ibono so nɛ ba gɛsinkpan so mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","To. Nkɛ kalɛsɛ ndɛ dɔ mɔ, i kaaborɛ nꞌ yii ɔkpa de nꞌ kpaa loo Gyɛrusalem de iꞌ kyu kyena de fɛye-gɛlaarɛ yɛɛ Wurubuaarɛ ikalan atɔgɛbo ba‑a ɔkolon maŋ wɔra ɔmɔɔsɛ ɔsowolɛ banban ɔko so baa too de Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“O, Gyɛrusalem asa! Fɛye ne n kpɛ fa‑a mɔɔ Wurubuaarɛ ikalan atɔgɛbo mɔ ne fɛ kya too fa‑a too abui fa‑a mɔɔ Wurubuaarɛ isɔɔ ibono ɔ kya sun fɛye asɛ mɔ. Nɛ tansi laarɛ fɛɛ nꞌ nyaa fɛye ba me asɛ fɛɛ gɛnɔɔbono kyaasɛ kya nyaa mɔ-biana baa wɔra mɔ-abantɛɛ dɔ mɔ. Gikpadɔ gifonɛɛ ne nɛ laarɛ nꞌ koola fɛye gɛnen ne fɛŋ kya kyule faa. ");
INSERT INTO acd_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Fɛꞌ nu yɛɛ Wurubuaarɛ laa lɛɛ ansi taa fɛye-ɔsowolɛ yɛgɛ sa fɛye. N kya tɔgɛ fɛye gɛsintin yɛɛ fɛ maŋ baa wu me kpaa fo gɛkɛ gɛbono fɛ laa bugi fɛye-nnɔ tɔgɛ yɛɛ, ‘Wura Wurubuaarɛ ɔꞌ kosorɛ ɔnyen baarɛ gimu! Wurubuaarɛ ginyen dɔ ne ɔ naa ɔ kya ba faa!’ ” ");
INSERT INTO acd_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Gyuda awura gɛkɛ kyoolasɛ gɛko mɔ, Farasii awura ɔbelɛnsɛ gbaaꞌ ɔko gi da gibaa terɛ Yesu yɛɛ ɔꞌ baa gyi mɔ-gɛwi. Yesu gi kpe mɔ, ɔbelɛnsɛ mɔ mɔ‑rɛ abono mɛ bo mɔ asɛ mɔ mɛ kya dii mɔ de mɛꞌ kerɛ ilaa ibono ɔ laa wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Nfono mɔ, ɔnyen ɔko gi ba Yesu asɛ, ɔ kya lɔ kyankpan. ");
INSERT INTO acd_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Yesu gi wu ɔlɔbo mɔ mɔ, ɔ taasɛ Gyuda awura nbara aŋmarasɛbo mɔ de Farasii awura abono mɛ bo nfono mɔ yɛɛ, “I dɛ ɔkpa fɛɛ aꞌ kyɛ alɔtɔ gɛkɛ kyoolasɛ abɛɛ i mɛŋ dɛ ɔkpa?” ");
INSERT INTO acd_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Yesu gi taasɛ mɔmɔ mɔ, mɛ mɛŋ lɛɛ gɛnɔ. Nfono ne ɔ tengɛ gibaa yii ɔlɔbo mɔ ne ɔ kyɛ mɔ ne ɔ lɛɛ mɔ-ɔkpa yɛɛ ɔꞌ naa kpe gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Yesu gi kyɛ ɔnyen mɔ ta mɔ, ɔ taasɛ asa mɔ yɛɛ, “Fɛye ɔko mɔ-bi abɛɛ mɔ-naadɛ gi tɔrɔ lɔkɔ dɔ gɛkɛ kyoolasɛ mɔ, ɔ maŋ lɛɛ mɔ ayaa abono so? Ɔ laa kyena yɛɛ i gyɛ gɛkɛ kyoolasɛ so mɔ, ɔ maŋ lɛɛ mɔ?” ");
INSERT INTO acd_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Yesu gi taasɛ mɔmɔ gɛnen mɔ, mɛŋ taa lɛɛ gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Yesu gi wu yɛɛ asa abono gɛten wura mɔ gi da gibaa terɛ mɔ mɛ kya laarɛ daa abelɛnsɛ ikyenaten. Imɔso ɔ da mɔmɔ gikpalɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nengyene ɔko gi da gibaa terɛ fo ɔko yɛɛ foꞌ baa gyi gɛkɛ belɛ kpaa mɔ mɔ, fo kpe mɔ, gɛŋ kpaa laarɛ abelɛnsɛ ikyenaten. Foŋbii mɔ, nyamesɛ gbaaꞌ ɔbono ɔ don fo mɔ kee laa ba giterɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","I ba gɛnen mɔ, ɔbono ɔ da gibaa terɛ fɛye mɔ laa baa tɔgɛ sa fo yɛɛ, ‘Koso de foꞌ sa ɔbelɛnsɛ gɛgyapaa.’ Nfono mɔ, fo laa koso de ansi ipeeli kpaa kyena nbii ikyenaten. ");
INSERT INTO acd_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Imɔso nengyene ɔko gi da gibaa terɛ fo ɔko mɔ, fo kpe mɔ, fo berɛ, kpaa laarɛ daa nbii ɔkyenaten de foꞌ kyena. Ɔbono ɔ terɛ fo mɔ gi wu yɛɛ fo gyɛ nyamesɛ gbaaꞌ sa mɔ mɔ, ɔ laa baa tɔgɛ sa fo yɛɛ, ‘Me-kyɛmenɛ, koso baa kyena ansi dɔ gɛrɛ.’ Nfono mɔ fo laa gyi ginsi asa abono mɛ bo nfono mɔ pɛwu asɛ. ");
INSERT INTO acd_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Imɔ gɛsɛ ne n gyɛ yɛɛ nyamesɛ kamaasɛ ɔbono ɔ kya diirɛ mɔ-nyoro mɔ, Wurubuaarɛ laa bara mɔ gɛsɛ. Ne ɔbono, mɔ, ɔ kya bara mɔ-nyoro gɛsɛ mɔ, Wurubuaarɛ laa diirɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Yesu gi tɔgɛ sa ɔbono ɔ da gibaa terɛ mɔ mɔ kee yɛɛ, “Fo laa wɔra gɛkɛ belɛ agyudɔ owi kenken abɛɛ gɛdɔɔdɛ ne fo laa da gibaa terɛ asa mɔ, gɛŋ terɛ fo-kyɛmenɛana, fo-daana, fo-tedɛana, fo-subuana, de aterenbi awura wolɛ. Fo terɛ mɔmɔ mɔ, mɔmɔ kee mɛ laa da gibaa terɛ fo gɛkaako ka gikɔ. ");
INSERT INTO acd_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Imɔso fo laa da gibaa terɛ asa gɛnen mɔ, terɛ daa ayenbo, abono mɛ lii giden, ɔtɛgɛsɛana, de agyaatanbo. ");
INSERT INTO acd_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Abono ne fo terɛ mɔ, fo laa wɔra omudɛnsɛbo Wurubuaarɛ asɛ. I kya nyiile yɛɛ mɔmɔ berɛ, mɛ maŋ taalɛ wɔra imɔ ɔnan ka fo gikɔ. Wurubuaarɛ ne nan ka fo gikɔ sa mɔmɔ gɛkaabono ɔ laa kyingi gɛsintin awura lii ibuni dɔ de mɛꞌ kpaa kyena mɔ asɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Asa abono mɔmɔ‑rɛ Yesu mɛ tɛ ogyiten mɔ dɔ ɔko gi nu ilaa ibono Yesu gi tɔgɛ gɛnen mɔ, ɔ tɔgɛ sa Yesu yɛɛ, “Amudɛnsɛbo ne n gyɛ asa abono mɛ laa nyɛ gyi Wurubuaarɛ gɛkɛ belɛ agyudɔ gɛkaabono asa mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Nfono ne Yesu gi da gikpalɛ kyu lii imɔ so sa ɔnyen mɔ yɛɛ, “Ɔnyen ɔko bo nno. Gɛkɛ gɛdɛ mɔ, ɔ da gibaa terɛ asa sakyɔ yɛɛ ɔ laa gyi gɛkɛ belɛ, imɔso mɛꞌ ba de mɛꞌ baa gyi de mɛꞌ nun kpaa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Owi mɔ gi fo mɔ, o sun mɔ-dega yɛɛ ɔꞌ naa kpaa terɛ abono ɔ da gibaa terɛ mɔ yɛɛ mɛꞌ ba. Mɛ gyan ta. ");
INSERT INTO acd_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Dega mɔ gi kpe asa mɔ asɛ mɔ, mɔmɔ pɛwu mɛ nyɛ ikyɛɛrɛgyanten yɛɛ mɛ maŋ nyɛ nyoro ba. Mɔmɔ ɔko yɛɛ ɔ sɔɔ gɛsinkpan gɛtɛɛko. Ɔ kya kpe de ɔꞌ kpaa kerɛ gɛmɔ. Imɔso ɔꞌ kpaa tɔgɛ mɔ-wura mɔ yɛɛ ɔ dɛ mɔ giserɛ, ɔ maŋ nyɛ nyoro ba. ");
INSERT INTO acd_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ɔbanban kee yɛɛ ɔ sɔɔ inaadɛ gudu ibono ɔ kya laarɛ ɔꞌ kpaa kerɛ mɔmɔ-gidebi. Imɔso ɔ dɛ mɔ-wura mɔ giserɛ yɛɛ ɔ maŋ nyɛ nyoro ba. ");
INSERT INTO acd_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ɔko kee yɛɛ ɔ kpɛ dena ɔkyii ne, imɔso ɔ maŋ nyɛ nyoro ba. ");
INSERT INTO acd_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Dega mɔ gi kii baa buu sa mɔ-wura mɔ yɛɛ nfono o sun mɔ mɔ, o kpe mɔ, asa mɔ ɔkamaasɛ yɛɛ ɔ maŋ nyɛ nyoro ba. Mɔ-wura mɔ gi nu gɛnen mɔ, i kyu mɔ ginyadon ne ɔ tɔgɛ mɔ yɛɛ ɔꞌ kpaala de ɔꞌ naa kpe nten-ana dɔ de gɛbɔgɔlɔn kamaasɛ dɔ de ɔꞌ kpaa terɛ ayenbo, ɔtɛgɛsɛana, abono mɛ lii giden mɔ, de agyaatanbo pɛwu yɛɛ mɛꞌ ba de mɛꞌ baa gyi. ");
INSERT INTO acd_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Dega mɔ gi kpe kpaa terɛ mɔmɔ ba, ne ɔ baa tɔgɛ mɔ-wura mɔ yɛɛ, ‘Nfono fo sun me mɔ, nɛ kpe ba. Abono nɛ nyɛ mɔ, mɛ mɛŋ taalɛ bɔla ikyenaten mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Nfono ne mɔ-wura mɔ yɛɛ, ‘Kii naa kpe ibunmara de ndɔɔ ikpa dɔ de foꞌ kpaa pɛɛrɛ ansi wɔra asa abono fo laa nyɛ mɔ pɛwu yɛɛ mɛꞌ baa bɔla me-gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","N kya buu mi‑i sa fɛye abono fɛ bo gɛrɛnaa mɔ yɛɛ abono nɛ terɛ yɛɛ mɛꞌ ba ne mɛ kine mɔ, mɔmɔ ɔko‑rɛ ɔko maŋ nyɛ agyudɔ abono nɛ yɛgɛ mɛꞌ gyan yela mɔmɔ mɔ daa kerɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Owi ɔko dɔ mɔ, sakpii belɛ ɔko buu Yesu. Nfono ne Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Nyamesɛ ɔbono ɔ kya laarɛ fɛɛ ɔꞌ ba me asɛ de ɔꞌ baa wɔra me-ɔkasɛbo mɔ, i kaaborɛ ɔꞌ lɛɛ mɔ-gɛwɔnsa lii mɔ-sɛ de mɔ-nyi de mɔ-subuana pɛwu so. Ɔꞌ lɛɛ mɔ-gɛwɔnsa lii mɔ-ka de mɔ-biana kee so de ɔꞌ lɛɛ mɔ-gɛwɔnsa lii mɔ gbaa-gbaa mɔ-nyoro kee so. Nengyene ɔ mɛŋ wɔra gɛnen mɔ, ɔ maŋ taalɛ wɔra me-ɔkasɛbo. ");
INSERT INTO acd_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne fo ɔbono fo maŋ kyule wu awɔrɔfɔɔ me so de foꞌ kasɛ me-gidebi, ba‑a mɛ laa da fo aŋanbi oyii so mɔɔ mɔ ne fo maŋ kyule gɛnen mɔ, fo maŋ taalɛ wɔra me-ɔkasɛbo. ");
INSERT INTO acd_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Imɔso i kaaborɛ ɔbono ɔ laa buu me mɔ ɔꞌ taasɛ mɔ-nyoro yɛɛ ɔ laa taalɛ buu me kpaa lii? I dɛ daa fɛɛ ɔbono ɔ kya laarɛ ɔꞌ pɔrɔ gikagya mɔ. Pɛi ne ɔ laa pɔrɔ gɛnen obu ɔbono mɔ, i kaaborɛ ɔꞌ kyena de oꞌ buu-buu kerɛ yɛɛ ɔ laa taalɛ yii mɔ kpaa logɛ? ");
INSERT INTO acd_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","I mɛŋ gyɛ gɛnen mɔ, ɔ too gɛsɛ ɔpɔɔrɛ ne ɔŋ baa taalɛ logɛ obu mɔ mɔ, asa mɛ laa ŋmasɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Kaasɛ baarɛ gi yii gɛsɛ ɔ kya pɔrɔ gikagya ne ɔ kponderɛ gimɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Abɛɛ aꞌ kyu yɛɛ wura ɔko laa kpaa kɔ de wura banban. Mɔ-lɛɛ ikɔ akɔbo mɔ mɛ laa wɔra fɛɛ nwɛ gɛwɛ. Ne mɔ-nanbo mɔ-lɛɛ, mɔ, mɛ laa wɔra fɛɛ mɔ-lɛɛ mɔ ɔnan gikpadɔ ginyɔ. Pɛi ne ɔ laa kpe ikɔ mɔ mɔ, ɔ maŋ daa gikyena de ɔꞌ taasɛ mɔ-nyoro yɛɛ imɔso nan taalɛ kɔ de wura ɔbono mɔ-ikɔ akɔbo mɔ mɛ kyɔ don me-lɛɛ mɔ gikpadɔ ginyɔ faa? ");
INSERT INTO acd_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nengyene o wu yɛɛ ɔ maŋ taalɛ mɔ, ɔ laa lɛɛ isɔɔ wolaa sun wura banban mɔ asɛ owi ɔbono mɛ san mɛ bo gɛta de abara mɔ de ɔꞌ kpaa kolɛ mɔ yɛɛ mɛꞌ tɔgɛ kyule abara de mɛꞌ lɔrɔ mɔmɔ nsana de gisen yuuli giꞌ ba. ");
INSERT INTO acd_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Gɛnen kee ne i kaaborɛ fɛꞌ taasɛ fɛye-nyoro ilaa ne. I lii fɛɛ ɔbono ɔ maŋ lɛɛ mɔ-ansi lii mɔ-atɔ abono ɔ bo mɔ pɛwu so de ɔꞌ baa buu me mɔ, gɛnen kaasɛ ɔbono maŋ taalɛ wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Yesu gi da mɔmɔ imɔ so gikpalɛ yɛɛ, “Nfɔlɛ gi bo kon. Ne fɛɛ nfɔlɛ mɔ gi ta nmɔ-ɔkon mɔ? Nnɛ ne fɛ laa wɔra nmɔ de giꞌ kii wɔra ɔkon? Iŋ bo sɛi fɛ laa wɔra. ");
INSERT INTO acd_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Gɛnen nfɔlɛ nbono giŋ baa gi bo giko dɔ. Mɛ kya too nmɔ fuɛ daa. Ɔbono ɔ bo aso mɔ, oꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Aberɛ ako dɔ mɔ, ilaa nyɛnyɛn awɔrabo de lɛnpoo asɔɔbo abono mɛ kya kudi asa gyi mɔ mɛ ba Yesu asɛ baa nu mɔ-ilaa tɔgɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Gɛnen so mɔ Farasii awura de Gyuda awura nbara aŋmarasɛbo mɔ mɛ kya lɔgedɛ yɛɛ, “Menɛ ne n ba ne Yesu kya bugi ansi de ilaa nyɛnyɛn awɔrabo adɛ ne ɔ kya gyi de mɔmɔ?” ");
INSERT INTO acd_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Nfono mɔ, Yesu gi da mɔmɔ gikpalɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Nꞌ taasɛ fɛye ilaa iko. Nengyene nyamesɛ bo isandɛ ikue-inun ne ɔkolon gi fuɛ mɔ, ɔ maŋ taa asɛnsɛ mɔ yɛgɛ mɔmɔ-ogyiten de ɔꞌ kpaa laarɛ ɔbono ɔ fuɛ mɔ? Gɛsintin, ɔ laa laarɛ mɔ gɛnen‑n kaaborɛ oꞌ wu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","O wu mɔ mɔ, i kya wɔra mɔ ɔkon gikyɔ kyɔde, de oꞌ puru mɔ gyanꞌ gigɔngɔn kyu mɔ ba gɛwi. ");
INSERT INTO acd_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Ɔ ba gɛwi mɔ, ɔ laa terɛ mɔ-gɛten dɔ awura de mɔ-nanboana de ɔꞌ tɔgɛ sa mɔmɔ yɛɛ, ‘Aye pɛwu aꞌ gyi ɔkon me-sandɛ fuɛsɛ mɔ so. I lii fɛɛ nɛ kpaa wu mɔ baa bɔla asɛnsɛ mɔ so.’ ");
INSERT INTO acd_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Gɛnen kee ne i dɛ ne. Nengyene fɛɛ gɛsinkpan so gɛrɛ ilaa nyɛnyɛn ɔwɔrabo kolon gi nu mɔ-nyoro gɛsɛ ne ɔ kyɛɛgɛ lii mɔ-ilaa nyɛnyɛn giwɔra dɔ mɔ, abono mɛ bo Wurubuaarɛ dɔ mɔ mɛ laa gyi ɔkon belɛ. Fɛɛ asa ikue-inan de saalaa asa sango mɛ bo no mɛ nyi yɛɛ mɛ gyɛ gɛsintin awura ne iŋ tiri yɛɛ mɛꞌ kyɛɛgɛ mɔ, nꞌ buu sa fɛye yɛɛ mɔmɔ-ilaa i maŋ wɔra Wurubuaarɛ dɔ asa mɔ ɔkon fɛɛ nyamesɛ kolon ɔbono ɔ kyɛɛgɛ mɔ lɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Yesu gi kii da gikpalɛ yɛɛ, “Ɔkyii ɔko bo aterenbi abi tirisɛ gudu, ne gɛnyɛ gɛko mɔ, gikolon gi fuɛ mɔ asɛ mɔ-obu dɔ. Nnɛ ne ɔ laa wɔra? Ɔ laa nyɔga fatela de ɔꞌ kpa mɔ-obu mɔ laarɛ gimɔ dɔɔdan kaaborɛ ɔꞌ kpaa wu gimɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Nengyene o wu gimɔ mɔ, ɔ kya terɛ mɔ-gɛten dɔ awura de mɔ-nanboana baa gyanꞌ de ɔꞌ tɔgɛ sa mɔmɔ yɛɛ, ‘Aye pɛwu aꞌ gyi ɔkon, i lii fɛɛ nɛ wu me-aterenbi gibi gibono gi fuɛ mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Yesu gi tɔgɛ gɛnen ta mɔ, ɔ lɛɛ gɛsɛ yɛɛ, “Nꞌ buu sa fɛye yɛɛ nengyene fɛɛ ilaa nyɛnyɛn ɔwɔrabo kolon gi nu mɔ-nyoro gɛsɛ ne ɔ kyɛɛgɛ lii mɔ-ilaa nyɛnyɛn giwɔra dɔ mɔ, gɛnen kee ne i kya wɔra Wurubuaarɛ dɔ isɔɔ ɔkon ne.” ");
INSERT INTO acd_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Yesu gi kii da gikpalɛ kyu lii Wurubuaarɛ so yɛɛ, “Aberɛ ako dɔ mɔ, ɔnyen ɔko gi kyena. Ɔ bo nbii nyensɛɛ nnyɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Gɛkɛ gɛdɛ mɔ, ɔpiiasɛ mɔ gi koso kpaa tɔgɛ mɔ-sɛ yɛɛ, ‘Me-sɛ, yɛ fo-atɔ de foꞌ kyu me-lɛɛ ogyiten sa me, ibono fo san fo tɛ de ansi faa.’ Gɛsintin mɔ, mɔmɔ-sɛ gi yɛ mɔ-atɔ mɔ dɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Ɔ yɛ sa mɔmɔ gɛnen mɔ, imɔ nkɛ kalɛsɛ nko mɔ, ɔpiiasɛ mɔ gi baala mɔ-ilaa pɛwu ne ibono i gyɛ ifɛsɛ mɔ, ɔ fɛ. Ne ɔ koso taa mɔ-sɛ de mɔ-daa yɛgɛ kyon kpe ɔsowolɛ ɔko so koo gɛta-gɛta. O kpe nno mɔ, ɔ kpaa gyi ɔkon giyan-giyan nyida mɔ-aterenbi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Aberɛ abono mɔ-aterenbi mɔ a ta wɔra mɔ mɔ, akon belɛ ako a tɔrɔ gɛsinkpan gɛbono so ɔ tɛ mɔ. Nfono mɔ, ayen a keda mɔ. Ɔŋ baa ɔ dɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ɔ san koso kyu mɔ-nyoro kpaa da mada de nten obi ɔko ne ɔbono, mɔ, yɛɛ ɔꞌ kpaa kyena mɔ-ndɔɔ dɔ de ɔꞌ kerɛ akuuri so. ");
INSERT INTO acd_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Akon mɔ a don mɔ-abaa so mɔ, nengyene fɛɛ ɔ nyɛ akuuri mɔ ilaa gyisɛ gbaa mɔ, nkana ɔ kya laarɛ kyɔde. Imɔ gɛnen mɔ, ɔko mɛŋ kya sa mɔ imɔ iko‑rɛ iko. ");
INSERT INTO acd_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Gɛkɛ gɛdɛ, ɔ baa nu mɔ-nyoro gɛsɛ yɛɛ ɔ wɔra ilaa nyɛnyɛn. Imɔso ɔ tɔgɛ sa mɔ-nyoro yɛɛ, ‘Adega abono mɛ tɛ me-sɛ asɛ mɔ gbaa, mɔmɔ pɛwu mɛ kya nyɛ gyi kaabo kii san. Kerɛ, me ne n tɛ gɛrɛnaa, n kya wu akon mɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nan koso de nꞌ kpe me-sɛ asɛ de nꞌ kpaa dɛ mɔ giserɛ. Nɛ loo mɔ asɛ mɔ, nan tɔgɛ mɔ yɛɛ, “Me-sɛ, nɛ wɔra fo‑rɛ Wurubuaarɛ ilaa nyɛnyɛn. ");
INSERT INTO acd_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Meŋ kaaborɛ foꞌ baa terɛ me yɛɛ fo-bi. Imɔso, me-sɛ, n dɛ fo giserɛ, sɔɔ me de foꞌ kyu me wɔra fɛɛ fo-adega mɔ dɔ ɔko.” ’ ");
INSERT INTO acd_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Ɔ sa gɛnen gɛwɔnsa gɛdɛ ta mɔ, gɛsintin mɔ, ɔ koso ne ɔ kyon mɔ-sɛ asɛ. Ɔ kya fuude mɔ-sɛ gɛten mɔ, mɔ-sɛ gi wu mɔ koo-koo gɛta. O wu mɔ gɛnen mɔ, i wɔra mɔ ayen. Ne o kuu ɔnangya kpaa puge mɔ ɔ kya da mɔ gya-gya. ");
INSERT INTO acd_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ɔ faala mɔ ta mɔ, mɔ-bi mɔ gi dɛ mɔ giserɛ yɛɛ, ‘Me-sɛ, nɛ wɔra fo‑rɛ Wurubuaarɛ ilaa nyɛnyɛn. Meŋ baa kaaborɛ foꞌ baa terɛ me yɛɛ fo-bi.’ ");
INSERT INTO acd_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Mɔ-sɛ mɔ, mɔ, gi kyu mɔ naa loo gɛten dɔ, ne ɔ tɔgɛ sa mɔ-adega yɛɛ, ‘Belen! Fɛꞌ kpaala! Fɛꞌ kyu gɛgbɛ dɛnsɛ baa suu mɔ de fɛꞌ wɔra mɔ gɛbɔɔrɛ gibaa dɔ de fɛꞌ kyu ayaawolɛ kyu tolɛ mɔ-ayaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","De fɛꞌ kpaa keda naadɛ kiirɛsɛ ɔbono ɔ laa wɔra nfɔ mɔ de fɛꞌ baa mɔɔ de fɛꞌ kyu wɔra agyudɔ de aꞌ gyi de aꞌ nun de aꞌ kyaa. ");
INSERT INTO acd_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","I kya nyiile yɛɛ me-bi baarɛ mɔ dɛ fɛɛ ɔbono o wuꞌ ne o kii kyingi. Ɔ fuɛ, ne a kii wu mɔ.’ Gɛsintin mɔ, ɔnyen mɔ adega mɔ mɛ wɔra fɛɛ gɛnɔɔbono mɔmɔ-wura mɔ gi tɔgɛ mɔmɔ mɔ, ne mɛ gyi ne mɛ nun ne mɛ kyaa. ");
INSERT INTO acd_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Gɛnen owi ɔbono dɔ pɛwu mɔ, ɔnyen mɔ mɔ-bi belɛnsɛ mɔ, mɔ, bo ndɔɔ dɔ. Ɔ lii ndɔɔ ɔ kya ba gɛwi ne o kya fuude gɛten dɔ mɔ, ɔ kya nu ilon de gɛkyaa i dɛ i yelɛ mɔ-sɛ gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Nfono mɔ, ɔ terɛ mɔ-sɛ adega mɔ dɔ ɔko ne ɔ taasɛ mɔ ilaa ibono i ba nno mɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ɔ taasɛ mɔ gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, ‘Fo-tedɛ ne n ba ne fo-sɛ gi yɛgɛ mɛ keda naadɛ ɔbono ɔ wɔra nfɔ mɔ mɔɔ yɛɛ mɔ-bi gi kii ba baa tu mɔ gimu nkpa de alanfiya.’ ");
INSERT INTO acd_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“O nu gɛnen mɔ, ɔ sɔɔ ginyadon ne o kine yɛɛ ɔ maŋ baa loo gɛten dɔ. Mɔ-sɛ gi nu yɛɛ mɔ-bi belɛnsɛ mɔ gi sɔɔ ginyadon mɔ, ɔ lii kpe mɔ asɛ, ɔ kya buɛɛlɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Nfono mɔ, mɔ-bi mɔ gi lɛɛ gɛnɔ sa mɔ yɛɛ, ‘Me-sɛ, fo gbaa-gbaa kerɛ, nsi ndɛ dɔ pɛwu mɔ, n yelɛ n kya son fo. Meŋ wɔra gisomaanu sa fo gɛkaako kerɛ. Mi‑i me mɔ, fo mɛŋ sa me ba‑a gɛtiidɛbi yɛɛ nꞌ mɔɔ de me‑rɛ me-kyɛmenɛana aꞌ kyu gyi ɔkon. ");
INSERT INTO acd_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Foŋ wu fo-bi ɔbono ɔ kpaa nyida fo-aterenbi akyii so giyan mɔ gi kpaa kii ba mɔ, fo bii yɛgɛ mɛ keda naadɛ ɔbono ɔ wɔra nfɔ mɔ mɔɔ sa mɔ mɔ?’ ");
INSERT INTO acd_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Ɔ taasɛ gɛnen mɔ, mɔ-sɛ mɔ gi lɛɛ gɛnɔ sa mɔ yɛɛ, ‘Me-bi, fo bo me asɛ gɛrɛ owi kamaasɛ dɔ. Ilaa ibono n bo mɔ pɛwu i gyɛ daa fo-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Fo-tedɛ baarɛ, mɔ, i kaaborɛ aꞌ kyaa sa mɔ de aꞌ yɛgɛ iꞌ wɔra aye ɔkon. I kya nyiile yɛɛ ɔ dɛ fɛɛ ɔbono o wuꞌ ne o kii kyingi. Ɔ wɔra fɛɛ ɔbono o fuɛ ne a kii wu mɔ mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Yesu gi da gikpalɛ sa mɔ-akasɛbo mɔ yɛɛ, “Owi ɔko dɔ mɔ aterenbi wura ɔko gi kyena. Ɔ bo dega ɔbono ɔ kya kerɛ mɔ-ilaa so ɔ kya sa mɔ. Owi ɔko dɔ mɔ i ba yɛɛ aterenbi wura mɔ gi nu yɛɛ mɔ-dega mɔ kya gyi mɔ-aterenbi mɔ gyɛrɛbi. ");
INSERT INTO acd_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","O nu gɛnen mɔ, ɔ terɛ mɔ-dega mɔ ba mɔ asɛ ne ɔ tɔgɛ mɔ yɛɛ, ‘N kya nu yɛɛ fo kya gyi me gyɛrɛbi. Imɔso meŋ baa mi‑i laarɛ fo yɛɛ foꞌ kerɛ me-ilaa so sa me. Baa buu-buu ilaa ibono fo kya kerɛ imɔ so mɔ gɛgyɔnɔ sa me de foꞌ nyɛ ɔkpa.’ ");
INSERT INTO acd_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Mɔ-dega mɔ gi nu gɛnen mɔ, ɔ tɔgɛ sa mɔ-nyoro yɛɛ, ‘Me-ɔbelɛnsɛ kya gya me ɔ kya lii gɛsun gɛdɛ dɔ ne. Nnɛ ne nan wɔra? Me ne, meŋ bo lon de nꞌ taalɛ wɔra gɛsun bolonsɛ, ne i laa wɔra me ipeeli yɛɛ nꞌ lii kpaa kolɛ pɛi de nꞌ lɔɔ nyɛ gyi. ");
INSERT INTO acd_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Nbuo! Nɛ bii ilaa ibono nan wɔra mɔ. Nan wɔra ilaa ibono i laa yɛgɛ nꞌ nyɛ akyɛmenɛ de owi ɔbono me-wura mɔ gi lɛɛ me-ɔkpa mɔ, mɛꞌ nyɛ sɔɔ me kyena mɔmɔ asɛ mɔmɔ-nten-ana dɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Dega mɔ gi sa gɛwɔnsa gɛnen ta mɔ, ɔ terɛ asa abono mɛ dɛ mɔ-ɔbelɛnsɛ mɔ akɔ mɔ pɛwu ɔko-ɔko. Ɔ taasɛ ɔgyangbarasɛ mɔ yɛɛ, ‘Nnɛ ne fo dɛ me-ɔbelɛnsɛ gikɔ?’ ");
INSERT INTO acd_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ɔbono gi lɛɛ gɛnɔ yɛɛ, ‘Nfɔ nlɔ gɛwɛ.’ Dega mɔ gi tɔgɛ sa mɔ yɛɛ, ‘Sɔɔ ɔwolɛ de foꞌ ŋmarasɛ gɛwɛfan yela, imɔ ne n gyɛ fo-gikɔ gibono fɛ laa kɔ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","O kii taasɛ ɔnyɔsɛ mɔ yɛɛ, ‘Ne fo‑o fo mɔ de‑e? Nnɛ ne fo dɛ me-ɔbelɛnsɛ gikɔ?’ Ɔ lɛɛ gɛnɔ yɛɛ, ‘Awayu ikotoku gɛwɛ.’ Dega mɔ gi kii tɔgɛ sa mɔ yɛɛ, ‘Sɔɔ ɔwolɛ de foꞌ ŋmarasɛ akpanyaa ikue-inan. Fo-gikɔ gibono fo laa ka mɔ ne.’ ");
INSERT INTO acd_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Ɔbelɛnsɛ mɔ gi nu gɛnen mɔ, ɔ yen mɔ-dega ɔbono ɔŋ bo gɛsintin faa yɛɛ ɔ bii sa gɛwɔnsa kyu lii ɔkɛ so. Me Yesu, n kya tɔgɛ mi‑i sa fɛye yɛɛ asa abono gɛsinkpan gɛrɛ-lɛɛ gɛkyena ne n tiri mɔmɔ mɔ mɛ kya bii sa gɛwɔnsa kyu lii ɔkɛ so. Fɛye abono fɛ nyɛ Wurubuaarɛ fatela mɔ berɛ, fɛŋ kya bii sa gɛwɔnsa kyu lii Wurubuaarɛ ilaa so gɛnen. ");
INSERT INTO acd_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Asa mɛ dɛ aterenbi ma‑a kudi abara. Nꞌ tɔgɛ sa fɛye yɛɛ fɛye berɛ fɛꞌ kyu fɛye-aterenbi kyu lɛɛ akyɛmenɛ; de owi ɔbono iŋ baa i gyɛ aterenbi ilaa mɔ fɛꞌ nyɛ akyɛmenɛ mɛꞌ da fɛye gya-gya Wurubuaarɛ gɛten dɔ de fɛꞌ kyena. ");
INSERT INTO acd_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Ɔbono ɔ kya gyi gɛsintin ilaa buru-buru dɔ mɔ mɔ kee ne nan gyi gɛsintin ilaa belɛ-belɛ dɔ. Ne ɔbono, mɔ, ɔŋ kya gyi gɛsintin ilaa buru-buru dɔ mɔ, ɔ maŋ taalɛ gyi gɛsintin ilaa belɛ-belɛ dɔ kee. ");
INSERT INTO acd_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","To! Nengyene gɛsinkpan so-lɛɛ awuratɔ ne fɛŋ kya gyi gɛsintin kyu kerɛ amɔ so faa, fɛ nyi yɛɛ Wurubuaarɛ laa kyule kyu awuratɔ gbaa-gbaa mɔ wɔra fɛye-abaa dɔ? ");
INSERT INTO acd_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne fɛɛ gɛsinkpan so ilaa ibono i maŋ wɔra fɛye-lɛɛ kpaa lii mɔ ne fɛŋ kya gyi gɛsintin kyu kerɛ imɔ so mɔ, fɛ nyi yɛɛ Wurubuaarɛ laa kyule kyu ilaa ibono i laa wɔra fɛye-lɛɛ gɛkpaa-gɛkpaa mɔ kyu sa fɛye? ");
INSERT INTO acd_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Nyamesɛ ɔko mɛŋ bo no ɔ laa taalɛ son awura anyɔ. Ɔ laa laarɛ ɔko ilaa de ɔꞌ kyo ɔko, abɛɛ ɔ laa buu ɔko, ne ɔ maŋ kyu ɔbanban mɔ kyu terɛ sɛi. Fɛ maŋ taalɛ son Wurubuaarɛ de foꞌ kii son aterenbi.” ");
INSERT INTO acd_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Yesu gi tɔgɛ ilaa idɛ pɛwu mɔ, Farasii awura gikpen mɔ dɔ asa mɛ nu mɔ asɛ. Mɔmɔ berɛ, mɛ kya laarɛ aterenbi ilaa. Imɔso mɛ kyu mɔ ŋmasɛ daa. ");
INSERT INTO acd_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛye berɛ fɛ kya laarɛ fɛꞌ gyi ginsi asa ansi so. Wurubuaarɛ nyi fɛye-asen dɔ. Ilaa ibono i gyɛ ilaa gbaaꞌ sa anyamesɛ mɔ i gyɛ daa ilaa kyosɛ sa Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Pɛi ne Gyɔn ɔbono ɔ gyere asa Wurubuaarɛ sagyere mɔ gi ba gɛsinkpan so mɔ, asa mɛ kya kasɛ daa Wurubuaarɛ nbara de mɔ-ikalan atɔgɛbo ilaa ŋmarasɛsɛ mɔ de mɛꞌ nyɛ bii gɛnɔɔbono mɛ laa kyena sa Wurubuaarɛ mɔ. San kyu lii Gyɔn owi mɔ, asa mɛ yii gɛsɛ mɛ kya nu Wurubuaarɛ ɔkalan konkonsɛ kyu lii mɔ-gɛwuragyi dɔ akyenabi mɔ so. Imɔso ɔkamaasɛ kya nyise ɔ kya loo ɔlon so de ɔꞌ nyɛ gɛnen awuragyibo akyenabi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Iŋ gyɛ yɛɛ Wurubuaarɛ nbara mɔ giŋ bo no daa. Fɛꞌ nu yɛɛ gɛnɔɔbono soso de gɛsɛ ilaa pɛwu i laa ŋaa mɔ i maŋ wɔra ɔsen fɛɛ gɛnɔɔbono Wurubuaarɛ laa lɛɛ mɔ-nbara mɔ gigyɛbi kolon fuɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Fo ɔbono fo kine fo-ka kpaa kyu ɔkyii pobɔrɔ mɔ, fo tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara. Ɔ kya kyu imɔ fɛɛ ɔko mɔ-ka ne fo laarɛ gɛnen. Ne ɔnyen ɔbono ɔ dena fo-ka dedaa mɔ, mɔ, kee gi tɔrɔ Wurubuaarɛ gɛlaarɛ adenabi nbara fɛɛ ɔko mɔ-ka ne ɔ laarɛ gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Yesu gi kii tɔgɛ yɛɛ, “Aterenbi wura ɔko gi kyena. Ɔ kya bun daa akuru dɛnsɛ de akuru boɔgyalonsɛ ne ɔ kpɛ ɔ kya gyi ɔkon adaa-adaa. ");
INSERT INTO acd_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Ɔnyen ɔko kee gi kyena. Ɔ gyɛ daa yenbo. Mɔ-nyoro gi tigi ilɔ. Mɛ kya terɛ mɔ yɛɛ Lasarosɛ. Asa mɛ kya kyena kyu mɔ kpaa yela aterenbi wura mɔ-gɛbunono asɛ. ");
INSERT INTO acd_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Lasarosɛ kya laarɛ yɛɛ aterenbi wura mɔ gi gyi ta mɔ, ɔꞌ nyɛ ɔ kya tɔɔsɛ mɔ-lɛpɛ gikɔɔdɔ ɔ kya gyi. Aterenbi wura mɔ mɛŋ kya sa mɔ ɔkpa. Ɔ tɛ gɛbunono asɛ gɛnen mɔ, igyoono i kya baa ninde mɔ-ilɔ mɔ kii siile mɔ bɔla. ");
INSERT INTO acd_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Gɛkɛ gɛdɛ mɔ yenbo mɔ gi wuꞌ ne mɛ pule mɔ, ne Wurubuaarɛ dɔ isɔɔ mɛ baa kyu mɔ kpaa yela aye-naana Aberaham gɛkɛlɛbi dɔ Wurubuaarɛ dɔ. Aterenbi wura mɔ kee gi baa wuꞌ ne mɛ pule mɔ. ");
INSERT INTO acd_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","O kpe ɔgya dɔ nfono asa nyɛnyɛn mɛ kya nyɛ gisobiidɛ mɔmɔ-lɛwu gɛmara mɔ, i kya ka mɔ-ansi. Ɔ bo nno mɔ, ɔ baa diirɛ mɔ-ansi mɔ, o wu Aberaham koo-koo Wurubuaarɛ dɔ. Lasarosɛ tɛ mɔ-gɛkɛlɛbi dɔ. ");
INSERT INTO acd_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","“O wu mɔmɔ gɛnen mɔ, o kpen ken-ken tɔgɛ sa Aberaham yɛɛ, ‘Me-sɛ Aberaham, su me gitolon; sun Lasarosɛ de oꞌ kyu mɔ-gibaabi kpaa nyɔɔ nkyu dɔ de ɔꞌ taa kyu baa yuule me-ɔnandii sa me. I kya nyiile yɛɛ n kya yiyɛɛ ɔgya baarɛ dɔ gɛrɛ.’ ");
INSERT INTO acd_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Nfono mɔ, Aberaham gi lɛɛ gɛnɔ sa mɔ yɛɛ, ‘Me-bi, nyingi yɛɛ owi ɔbono fo kyena gɛsinkpan so mɔ, fo nyɛ ilaa dɛnsɛ, ne Lasarosɛ, mɔ, gi nyɛ ilaa nyɛnyɛn. Idɛ kon berɛ, Wurubuaarɛ gi yɛgɛ Lasarosɛ nyoro gi tɔrɔ mɔ, ne fo, mɔ, fo kya yiyɛɛ. ");
INSERT INTO acd_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Imɔ idɛ pɛwu gɛmara kee mɔ, Wurubuaarɛ gi yɛgɛ ɔbɔ belɛ gi dɛ aye‑rɛ fɛye nsana. Ɔbono ɔ kya laarɛ ɔꞌ lii aye asɛ kpe fɛye asɛ nno mɔ, maŋ taalɛ. Ne ɔko mɔ kee maŋ taalɛ lii fɛye asɛ nno ba aye asɛ gɛrɛnaa.’ ");
INSERT INTO acd_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Aberaham gi tɔgɛ sa mɔ gɛnen mɔ, ɔ kolɛ Aberaham yɛɛ, ‘Me-sɛ, n dɛ fo giserɛ, gɛnen berɛ mɔ, sun Lasarosɛ de oꞌ kpe me-sɛ gɛten dɔ gɛsinkpan so sa me. ");
INSERT INTO acd_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","N bo atedɛ anun. Oꞌ kpe de ɔꞌ kpaa ka mɔmɔ sa me. I mɛŋ gyɛ gɛnen mɔ, mɔmɔ kee mɛ laa baa loo gɛnen ɔlaawusɛ baarɛ dɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Ɔ kolɛ Aberaham gɛnen mɔ, Aberaham gi tɔgɛ sa mɔ yɛɛ, ‘Fo-tedɛana mɔ mɛ ti mɛ bo ɔkpa de mɛꞌ nu Wurubuaarɛ agyɛbi abono Mosisi mɔ‑rɛ Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wolaa ŋmarasɛ yela mɔ. Imɔso mɛꞌ nu imɔ ibono.’ ");
INSERT INTO acd_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“Nfono mɔ, ɔbono nkana ɔ gyɛ aterenbi wura mɔ gi lɛɛ gɛnɔ yɛɛ, ‘Kuaa, me-sɛ Aberaham, mɛ maŋ taa nu imɔ ibono. Nengyene fɛɛ fo yɛgɛ ɔko gi lii ibuni dɔ fɛye asɛ kii kpe gɛsinkpan so kpaa tɔngɛ sa mɔmɔ mɔ, mɛ laa nu mɔmɔ-nyoro gɛsɛ de mɛꞌ kyɛɛgɛ lii ilaa nyɛnyɛn giwɔra dɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ne Aberaham yɛɛ, ‘Nengyene mɛ maŋ nu Wurubuaarɛ agyɛbi abono Mosisi mɔ‑rɛ Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wolaa ŋmarasɛ yela mɔ, gɛnen kee ne ba‑a ɔko gi kii lii ibuni dɔ kpe mɔmɔ asɛ mɔ, mɛ maŋ taa nu kaasɛ ɔbono asɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “I wɔra nnɛ mɔ, ilaa ibonoana i laa yɛgɛ asa mɛꞌ wɔra ilaa nyɛnyɛn mɔ i laa ba. Imɔ mɔ, ɔbono ɔ laa yɛgɛ i ba gɛnen mɔ, kaasɛ mɔ laako! ");
INSERT INTO acd_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Nengyene fɛɛ mɛ kyu gibui belɛ ŋminde kyaga de mɔ-gibɔ ne mɛ too mɔ wɔra apoo dɔ mɔ, i bɔ sa mɔ nyɛ ibono ɔ laa yɛgɛ apiipii abono mɛ sɔɔ me gyi mɔ dɔ ɔko gisɔɔgyi giꞌ koso me so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Imɔso fɛꞌ kerɛ fɛye-nyoro so dɔɔdan! Nengyene fɛɛ fo-nanbo ɔko gi wɔra fo ilaa nyɛnyɛn mɔ, tɔgɛ mɔ. Fo tɔgɛ mɔ ne o nu mɔ-nyoro gɛsɛ yɛɛ ɔ wɔra, iŋ boran mɔ, kyu kyɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Nengyene fɛɛ ɔ wɔra fo ilaa nyɛnyɛn gikpadɔ sono gɛkɛ kolon dɔ ne imɔ ikamaasɛ dɔ ɔ kya ba fo asɛ baa tɔgɛ sa fo yɛɛ o nu mɔ-nyoro gɛsɛ mɔ, kpɛ fo dɛ fo kya kyɛɛ mɔ gɛnen kee.” ");
INSERT INTO acd_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Yesu gi tɔgɛ gɛnen mɔ, mɔ-isɔɔ mɔ mɛ kolɛ mɔ yɛɛ, “Aye-Wura, kpaa aye de aꞌ nyɛ kii sɔɔ fo gyi too.” ");
INSERT INTO acd_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mɛ kolɛ gɛnen mɔ, Wura Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nengyene fɛye-gisɔɔgyi mɔ gi dabɔlɛ gi kerɛ pi‑i fɛɛ Maasadɛ giponfɛ gibi gbaa mɔ, fɛ laa taalɛ tɔgɛ sa gɛnen oyii belɛ-belɛ ɔbono ɔ yelɛ faa yɛɛ, ‘Kyigi koso gɛrɛ de foꞌ kyu fo-nyoro kpaa too wɔra apoo dɔ.’ Gɛsintin mɔ, oyii mɔ laa nu fɛye asɛ de oꞌ kyigi. ");
INSERT INTO acd_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Aꞌ kyu imɔ yɛɛ ɔbelɛnsɛ gbaaꞌ ɔko bo gɛdegabi gɛ tɛ mɔ asɛ, ne o sun gɛmɔ yɛɛ gɛꞌ kpaa dɔɔ mɔ-ndɔɔ abɛɛ gɛꞌ kerɛ mɔ-nbuɛ so. Ne fɛɛ gɛ lii aponfɛ dɔ ba mɔ, nnɛ ne ɔ laa tɔgɛ sa gɛmɔ? Imɔso ɔ laa tɔgɛ sa gɛmɔ yɛɛ, ‘Ba de nꞌ kyu agyudɔ baa yii fo?’ ");
INSERT INTO acd_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Kuaa. Ɔ laa tɔgɛ sa gɛmɔ daa yɛɛ, ‘Ba kyon kpaa gyere, de foꞌ baa laarɛ agyudɔ ako sa me de nꞌ gyi. Nɛ gyi ta mɔ, de foꞌ kpaa gyi kon.’ ");
INSERT INTO acd_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","“Fɛɛ fɛye dɔ ɔko bo dega ɔ tɛ fo asɛ ne fo sa mɔ gɛsun ne ɔ wɔra mɔ, iŋ tiri yɛɛ foꞌ yen mɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Wurubuaarɛ kee gi sa fɛye nsun wɔrasɛ. Fɛ wɔra nmɔ ta mɔ, fɛꞌ tɔgɛ daa yɛɛ, ‘A gyɛ daa Wurubuaarɛ adega. Nsun nbono gi gyɛ aye-nwɔrasɛ mɔ ne a wɔra. Iŋ tiri yɛɛ Wurubuaarɛ ɔꞌ yen aye.’ ” ");
INSERT INTO acd_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Yesu naa ɔ kya kpe Gyɛrusalem mɔ, o kyu de Samariya de Galeli nsinkpan mɔ nsana. ");
INSERT INTO acd_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ɔ naa ɔ kya kpe gɛnen mɔ, ibono ɔ kya laarɛ de oꞌ loo ɔsowolɛ ɔko so mɔ, mɔ‑rɛ ikononbu gudu iko mɛ gyanꞌ. Ikononbu mɔ mɛ laa gyangara Yesu gɛnen mɔ, mɛ sii yelɛ fɛɛ koo-koo faa, ");
INSERT INTO acd_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ne mɛ kpen tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ Yesu, a dɛ fo giserɛ, su aye so.” ");
INSERT INTO acd_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Yesu gi nu gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ kyu fɛye-nyoro kpaa nyiile Wurubuaarɛ asunbi alɛɛbo de mɛꞌ kerɛ fɛye-nyoro so gyanꞌ de mɛꞌ bii yɛɛ fɛye-gilɔ mɔ gi ta sa fɛye.” Akononbu mɔ mɛ naa mɛ kya kpe Wurubuaarɛ asunbi alɛɛbo mɔ asɛ fɛɛ gɛnɔɔbono Yesu gi tɔgɛ mɔmɔ mɔ, mɛ baa kerɛ mɔ, mɔmɔ-gilɔ mɔ gi ta. ");
INSERT INTO acd_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Nfono mɔ, mɔmɔ dɔ ɔko berɛ, ibono o wu yɛɛ mɔ-gilɔ mɔ gi ta mɔ, o kii kpe Yesu asɛ. Ɔ kya kpe gɛnen mɔ, ɔ kya kpen ɔ kya faala Wurubuaarɛ kyu lii ilaa ibono Wurubuaarɛ gi yɛgɛ Yesu gi wɔra sa mɔ mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ɔ kpaa fo Yesu asɛ mɔ, ɔ kpelegɛ ŋmii mɔ-ayaa dɔ ɔ kya faala mɔ. Gɛnen okononbu baarɛ gyɛ daa Samariyanyen. ");
INSERT INTO acd_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","O kii ba ɔ kya faala Yesu gɛnen mɔ, Yesu gi taasɛ yɛɛ, “I mɛŋ gyɛ asa gudu ne nɛ kyɛ mɔ? Ne sango abono mɛ san mɔ mɛ bo fonɛ? ");
INSERT INTO acd_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Imɔso mɔmɔ dɔ ba‑a ɔkolon mɛŋ taalɛ kii ba de ɔꞌ baa kyu afaala kyu sa Wurubuaarɛ, gɛnen mɔ, ɔbono ɔ gyɛ isafo mɔ wolɛ?” ");
INSERT INTO acd_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nfono mɔ Yesu gi tɔgɛ sa ɔnyen ɔbono o kii baa ɔ kya faala mɔ mɔ yɛɛ, “Koso naa. Gisɔɔgyi gibono fɛ bo sa me mɔ ne n mɔlɛgɛ fo faa.” ");
INSERT INTO acd_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Farasii awura ako mɛ taasɛ Yesu yɛɛ, “Owi ɔmɔ dɔ ne asa mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena?” Yesu gi lɛɛ gɛnɔ yɛɛ, “Wurubuaarɛ gɛwuragyi dɔ akyenabi a laa ba mɔ, fɛ maŋ wu ilaa ibono i laa lɛɛ imɔ nyiile tentegelen. ");
INSERT INTO acd_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Ɔko maŋ tɔgɛ sa mɔ-nanbo yɛɛ, ‘Kerɛ, Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ ne.’ I kya nyiile yɛɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ a ti a bo fɛye asɛ.” ");
INSERT INTO acd_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Nfono mɔ ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Gɛkaako fɛ laa laarɛ yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nꞌ kii kyena fɛye asɛ fɛɛ gɛkɛ kolon gbaa mɔ, fɛ maŋ nyɛ. ");
INSERT INTO acd_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","I laa baa nyɛ abono mɛ laa tɔgɛ fɛye yɛɛ, ‘Kerɛ, mɔ ne faanaa’ abɛɛ ‘Kerɛ, mɔ ne gɛrɛ!’ I ba gɛnen mɔ, fɛŋ sa fɛꞌ ka mɔmɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","I kya nyiile yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan kii ba gɛsinkpan so mɔ, i laa wɔra daa fɛɛ gɛnɔɔbono nyangbon kya wiisɛɛ pila-a baa kyon ne i kya wu gɛsinkpan so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Pɛi de nꞌ lɔɔ lii gɛsinkpan so kpe Wurubuaarɛ dɔ mɔ, i tiri yɛɛ nꞌ wu ɔlaawusɛ de ndɛ nkɛ ndɛ dɔ asa mɛꞌ kine me. ");
INSERT INTO acd_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, gikiiba gɛsinkpan so mɔ i kya fuude mɔ, i laa wɔra daa fɛɛ Nowa aberɛ dɔ-lɛɛ mɔ kee. ");
INSERT INTO acd_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Imɔ ne n gyɛ yɛɛ pɛi de nkyu gi lɔɔ gyi asa Nowa aberɛ mɔ, asa mɛ kpɛ san mɛ dɛ mɔmɔ-gɛkyena dɔ laawɔra mɛ kya wɔra, fɛɛ gigyi, ginun, de gɛdena gɛnen‑n kaaborɛ gɛkaabono Nowa gi dii loo gikolii mɔ dɔ. Ɔ loo gikolii mɔ dɔ gɛnen mɔ, nkyu gi baa gyi asa mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Me-gikiiba mɔ gi laa wɔra fɛɛ Lɔtɛ owi mɔ kee. Lɔtɛ owi mɔ dɔ mɔ asa mɛ kya gyi mɛ kya nun. Mɔmɔ ako mɛ dɛ gɛbuɛɛdɛ dɔ. Abanban, mɔ, mɛ kya dɔɔ, ne ako, mɔ, mɛ kya pɔrɔ ibu. ");
INSERT INTO acd_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Gɛkɛ gɛbono Lɔtɛ giyaa gi lii Sodom mɔ, ɔgya de fɛrɛwuta i lii Wurubuaarɛ dɔ baa ŋmadɛ ɔsowolɛ mɔ ne i dɛɛ asa mɔ pɛwu mɔɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Gɛnɔɔbono nɛ kaala faa pɛwu mɔ, gɛnen ne i laa wɔra asa gɛkɛ gɛbono me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan lɛɛ me-nyoro gɛwi nyiile mɔ. ");
INSERT INTO acd_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Gɛnen gɛkɛ gɛbono mɔ, fo ɔbono fo bo nŋmaŋman mɔ, selɛ. Gɛŋ sa foꞌ tɔgɛ yɛɛ fo-ilaa i bo obu dɔ, fo laa kpaa puru. Gɛnen kee ne fo ɔbono fo bo ndɔɔ dɔ gɛnen owi ɔbono mɔ, gɛŋ tɔgɛ yɛɛ fo laa kii gɛwi kpaa puru ilaa iko. ");
INSERT INTO acd_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Fɛꞌ nyingi ilaa ibono i wɔra Lɔtɛ mɔ-ka mɔ! ");
INSERT INTO acd_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Ɔbono ɔ laa kɔrɔsɛ mɔ-nkpa yela mɔ-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena gɛ laa lii mɔ-gibaa, ne ɔbono, mɔ, kyu lii me so ne mɔ-nkpa gi lii mɔ-gibaa mɔ, kaasɛ mɔ laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“N kya buu mi‑i sa fɛye yɛɛ gɛnen gɛkɛ gɛbono nan lɛɛ me-nyoro gɛwi nyiile asa mɔ, i laa nyɛ fɛɛ asa anyɔ mɛ dɛ npa kolon so mɔ, Wurubuaarɛ laa baa puru ɔko de ɔꞌ taa ɔko yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Akyii anyɔ mɛ yelɛ dabɔlɛ mɛ kya kɔrɔ fɛɛ awayu mɔ, Wurubuaarɛ laa puru ɔko de ɔꞌ taa ɔnyɔsɛ mɔ yɛgɛ.  ");
INSERT INTO acd_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Anyen anyɔ mɛ bo ndɔɔ dɔ dabɔlɛ mɔ, Wurubuaarɛ laa kyɔlɛ ɔko lɛɛ de ɔꞌ taa ɔko yɛgɛ.” ");
INSERT INTO acd_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Yesu akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, fonɛ dɔ ne ilaa idɛ pɛwu i laa ba gɛnen?” Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Nfono gɛbuɛ wusɛ gɛ dɛ mɔ, nno ne ipatɛɛ mɛ kya da gikilen.” ");
INSERT INTO acd_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Gɛkɛ gɛdɛ mɔ, Yesu gi da gikpalɛ sa mɔ-akasɛbo mɔ kyu nyiile mɔmɔ yɛɛ i kaaborɛ mɛꞌ dalaa owi kamaasɛ dɔ. Mɛ mɛŋ sa mɛꞌ yɛgɛ iꞌ yɔɔ mɔmɔ-nyoro de mɛꞌ taa yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Yesu gi da gimɔ yɛɛ, “Owi ɔko dɔ mɔ nbɛlɛ gyibo ɔko gi kyena ɔsowolɛ ɔko so. Gɛnen ɔnyen baarɛ mɛŋ kya kyu Wurubuaarɛ kyu terɛ sɛi, iꞌ baa yɛgɛ nyamesɛ. ");
INSERT INTO acd_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Owi ɔbono dɔ mɔ ɔkyii okulaabo ɔko mɔ kee bo gɛnen ɔsowolɛ ɔbono so. Okulaabo baarɛ kpɛ ɔ kya dii ɔ kya kpelegɛ nbɛlɛ gyibo mɔ so ɔ kya kolɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, n dɛ fo giserɛ, ɔko kya gɛnda me. Imɔso gyi me‑rɛ mɔ nbɛlɛ de nꞌ nyɛ me-nyoro.’ ");
INSERT INTO acd_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Okulaabo mɔ gi tɔɔraa nbɛlɛ gyibo mɔ gɛnen‑n kɛɛla. Nbɛlɛ gyibo baarɛ gi kine lɛɛ ɔkpa. Okulaabo mɔ, mɔ, mɛŋ taa mɔ-gitɔɔraa yɛgɛ. Imɔso nbɛlɛ gyibo mɔ gi tɔgɛ sa mɔ-nyoro yɛɛ, ‘I bo no yɛɛ meŋ kya kyu Wurubuaarɛ terɛ sɛi iꞌ baa yɛgɛ nyamesɛ. ");
INSERT INTO acd_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","Gɛnɔɔbono ɔkyii baarɛ kya tɔɔraa me faa berɛ, nan kerɛ de nꞌ kɛbi mɔ-nbɛlɛ ndɛ lɛɛ lii me-ayaa dɔ de nꞌ kyu mɔ-amɔlɛgɛ abono a gyɛ mɔ-lɛɛ mɔ sa mɔ. Meŋ wɔra gɛnen mɔ, ɔ laa tɔɔraa me don idɛ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aye-Wura Yesu gi da gikpalɛ gidɛ ta mɔ, ne ɔ taasɛ mɔ-akasɛbo mɔ yɛɛ, “Fɛ nu ilaa ibono nbɛlɛ gyibo ɔbono ɔŋ bo gɛsintin mɔ gbaa gi tɔgɛ sa mɔ-nyoro mɔ? ");
INSERT INTO acd_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","8","To, ne Wurubuaarɛ, Gɛsintin Wura mɔ, mɔ de‑e? Ɔ maŋ gyi gɛsintin sa fɛye abono ɔ tɔɔsɛ fɛye lɛɛ ne fɛ kya tɔɔraa mɔ gɛnyɛ de gɛpɛ mɔ de ɔꞌ mɔlɛgɛ fɛye? N kya buu mi‑i sa fɛye yɛɛ, Wurubuaarɛ maŋ yɛgɛ de iꞌ kɛɛla ne ɔ laa wolaa mɔlɛgɛ fɛye. Imɔ‑rɛ imɔ ibono Wurubuaarɛ kya gyi gɛsintin sa fɛye faa mɔ, imɔso me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nꞌ baa kii ba gɛsinkpan so mɔ, nan baa wu yɛɛ anyamesɛ mɛ kya ka gyanꞌ Wurubuaarɛ so berɛ ne?” ");
INSERT INTO acd_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Yesu gi kii da gikpalɛ giko sa asa abono mɛ kya sɔɔ mɔmɔ-nyoro gyi yɛɛ mɛ gyɛ gɛsintin awura ne mɛŋ kya kyu mɔmɔ-nanboana anyamesɛ terɛ sɛi mɔ, ");
INSERT INTO acd_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","yɛɛ, “Anyen anyɔ ako mɛ kpe Wurubuaarɛ ɔson obu gikpaara mɔ so de mɛꞌ kpaa dalaa. Gɛnen anyen anyɔ adɛ dɔ mɔ, ɔko gyɛ Farasii awura gikpen mɔ dɔ isa ne ɔko, mɔ, gyɛ lɛnpoo sɔɔbo. ");
INSERT INTO acd_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","“Mɛ loo ɔdalaaten mɔ gɛnen mɔ, Farasiinyen mɔ gi koso dalaa mɔ-gɛwɔnsa dɔ yɛɛ, ‘Wurubuaarɛ, n kya faala fo yɛɛ meŋ dɛ fɛɛ asa sɛnsɛ. Asa sɛnsɛ berɛ mɛ kya kudi asa gyi, mɛŋ kya gyi gɛsintin, ne mɛ kya laarɛ asa mɔmɔ-kaana. Meŋ kii n dɛ fɛɛ lɛnpoo sɔɔbo baarɛ. ");
INSERT INTO acd_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Fo-ɔson mɔ so mɔ, nkɛ sono kamaasɛ dɔ mɔ, n kya kyu nkɛ nnyɔ kyu ŋminde gɛnɔ. Ne me-aterenbi abono n kya nyɛ bosɛ mumuli dɔ mɔ, n kya yɛ amɔ dɔ gikpadɔ gudu de nꞌ kyu giko kyu sa fo Wurubuaarɛ.’ ");
INSERT INTO acd_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Lɛnpoo ɔsɔɔbo mɔ, mɔ, gi yelɛ koo-koo. O nyi yɛɛ ɔ gyɛ ilaa nyɛnyɛn ɔwɔrabo so mɔ, ɔ selɛ Wurubuaarɛ ansi ipeeli, imɔso o kyu mɔ-gimu kyu too gɛsɛ, ne ɔ dalaa kolɛ Wurubuaarɛ yɛɛ, ‘Wurubuaarɛ, su me so. N gyɛ ilaa nyɛnyɛn ɔwɔrabo.’ ” ");
INSERT INTO acd_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Yesu gi da gikpalɛ mɔ ta mɔ, ɔ lɛɛ gɛsɛ yɛɛ, “N kya buu mi‑i sa fɛye yɛɛ mɔmɔ asa anyɔ adɛ dɔ mɔ, lɛnpoo ɔsɔɔbo baarɛ ne n wɔra nyamesɛ dɛnsɛ Wurubuaarɛ ansi so; i mɛŋ gyɛ Farasiinyen mɔ. I kya nyiile yɛɛ fo nyamesɛ ɔbono fo kya diirɛ fo-nyoro mɔ, Wurubuaarɛ laa bara fo gɛsɛ. Ne fo ɔbono fo kya bara fo-nyoro gɛsɛ mɔ, Wurubuaarɛ laa diirɛ fo.” ");
INSERT INTO acd_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Owi ɔko dɔ mɔ, asa ako mɛ dɛ nbii buru-buru kee ma‑a bara Yesu yɛɛ oꞌ kyu mɔ-abaa gyanꞌ mɔmɔ so de ɔꞌ dalaa sa mɔmɔ. Yesu akasɛbo mɔ, mɔ, mɛ wu gɛnen mɔ, mɛ kya gya mɔmɔ yɛɛ mɛꞌ kiiri nbii mɔ. ");
INSERT INTO acd_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Yesu gi wu gɛnen mɔ, ɔ terɛ nbii mɔ ba mɔ asɛ, ne ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ yɛgɛ nbii mɔ mɛꞌ ba me asɛ; fɛŋꞌ baa tii mɔmɔ-ɔkpa. Abono mɛ dɛ fɛɛ gɛnen nbii ndɛana ɔnan mɔ ne n kya nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fo nyamesɛ kamaasɛ ɔbono fo mɛŋ kyu fo-nyoro wɔra fɛɛ gɛbii pii de foꞌ kyule kyena Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ, fo maŋ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ kpa‑a.” ");
INSERT INTO acd_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Owi ɔko dɔ mɔ, Gyuda awura ɔbelɛnsɛ gbaaꞌ ɔko gi baa taasɛ Yesu yɛɛ, “Ɔbelɛnsɛ dɛnsɛ, nnɛ ne nan wɔra de nꞌ nyɛ Wurubuaarɛ asɛ gɛkyena gɛkpaa?” ");
INSERT INTO acd_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Yesu gi kisee taasɛ mɔ yɛɛ, “Fo kya terɛ me yɛɛ ɔbelɛnsɛ dɛnsɛ faa mɔ, fo mɛŋ nyi yɛɛ Wurubuaarɛ wolɛ ne n gyɛ nyamesɛ dɛnsɛ? ");
INSERT INTO acd_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Iŋ gyɛ fo nyi Wurubuaarɛ nbara mɔ? Nbara mɔ gi kya nyiile yɛɛ, ‘Gɛŋ sa foꞌ lii fo-ka abɛɛ fo-kuli gɛmara laarɛ ɔko. Gɛŋꞌ mɔɔ isa. Gɛŋꞌ yuuri. Gɛŋꞌ ten ɔko gɛnɔ nbɛlɛ dɔ. Buu fo-sɛ de fo-nyi.’ ” ");
INSERT INTO acd_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Ɔnyen mɔ gi lɛɛ gɛnɔ sa Yesu yɛɛ, “Ɔbelɛnsɛ, kpɛ kyu lii me-nbii dɔ mɔ, n kya gyi nbara ndɛ pɛwu so.” ");
INSERT INTO acd_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Yesu gi nu gɛnen mɔ, ɔ tɔgɛ sa ɔnyen mɔ yɛɛ, “I kya san fo ilaa kolon. Kpaa fɛ fo-ilaa ibono fo bo mɔ pɛwu de foꞌ kyu aterenbi mɔ yɛ sa ayenbo. Fo wɔra gɛnen mɔ, fo laa nyɛ ntɛɛla Wurubuaarɛ dɔ de foꞌ san naa baa buu me wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Ɔnyen mɔ gi nu gɛnen mɔ, i yɔɔ mɔ-nyoro. I kya nyiile yɛɛ ɔ tansi ɔ bo atɔ gikyɔ. Ɔ kerɛ mɔ, ɔ maŋ taalɛ wɔra gɛnen. ");
INSERT INTO acd_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Yesu gi kerɛ ɔnyen mɔ, ne ɔ tɔgɛ yɛɛ, “I tansi i bo lon sa aterenbi awura de mɛꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. ");
INSERT INTO acd_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gɛsintin, pɛi de mɛꞌ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ, i laa wɔra ɔlon sa mɔmɔ don gɛnɔɔbono gɛkpatitii gɛ laa loo ɔbaatɔ ɔbɔ dɔ lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Asa mɛ nu imɔ idɛ mɔ, mɛ taasɛ yɛɛ, “Gɛnen berɛ mɔ, anɛ kaasɛ ne nan nyɛ amɔlɛgɛ de ɔꞌ nyɛ kyena Wurubuaarɛ asɛ ne?” ");
INSERT INTO acd_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Ilaa ibono i don nyamesɛ giwɔra mɔ, iŋ fo Wurubuaarɛ berɛ giwɔra.” ");
INSERT INTO acd_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Nfono mɔ Piita gi taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, aye berɛ, a taa ilaa ibono a bo mɔ pɛwu yɛgɛ ne a ba a naa a buu fo faa, nnɛ ne?” ");
INSERT INTO acd_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Yesu gi tɔgɛ mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, nyamesɛ kamaasɛ ɔbono ɔ taa mɔ-gɛten yɛgɛ, abɛɛ mɔ-sɛ, abɛɛ mɔ-nyi, abɛɛ mɔ-daana, abɛɛ mɔ-tedɛana, abɛɛ mɔ-biana abɛɛ mɔ-ka yɛgɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so mɔ, ");
INSERT INTO acd_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","kaasɛ laa nyɛ imɔ ɔnan gikpadɔ gifonɛɛ gifonɛɛ aberɛ abono ɔ tɛ de ansi faa. Ne gɛkyena gɛbono gɛ laa kii ba mɔ dɔ mɔ, ɔ laa nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Yesu gi kyu mɔ-akasɛbo gudu anyɔ mɔ lii nkan ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ nu. A kya kpe Gyɛrusalem faa, ilaa ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wolaa ŋmarasɛ yela kyu lii me, anyamesɛ pɛwu mɔmɔ-daa mɔ so mɔ, i laa ba gɛsintin kon. ");
INSERT INTO acd_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Gyuda awura mɛ laa kyu me wɔra asa abono mɛ mɛŋ gyɛ Gyuda awura mɔ abaa dɔ. Gɛnen asa abono mɛ laa gyaabii me ikpa kpɛi-kpɛi so. Mɛ laa saalɛ me, de mɛꞌ too akyɔlɛ bun me. ");
INSERT INTO acd_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mɛ laa taa me awulibi, de mɛꞌ mɔɔ me. Nɛ wuꞌ mɔ, imɔ gɛkɛ sasɛ mɔ, nan kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Yesu akasɛbo mɔ mɛ mɛŋ nu ilaa ibono ɔ tɔgɛ mɔ iko‑rɛ iko gɛsɛ. Imɔ gɛsɛ ginu i ŋara mɔmɔ, ne mɛ mɛŋ taalɛ bii ilaa ibono ɔ darɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Yesu kya sindi Gyɛriko ɔsowolɛ mɔ, gyaatanbo ɔko tɛ ɔkpa nkan ɔ kya kolɛ ilaa. ");
INSERT INTO acd_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","O nu sakpii mɔ kya kyon mɔ, ɔ taasɛ yɛɛ, “Menɛ ne n ba daa?” ");
INSERT INTO acd_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Asa mɔ dɔ ako mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “Yesu Nasarɛtɛnyen mɔ ne n ba ɔ kya kyon.” ");
INSERT INTO acd_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Nfono mɔ gyaatanbo mɔ gi kpen ken-ken yɛɛ, “Yesu! Wura Deefidi ɔnaanabi, su me so!” ");
INSERT INTO acd_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Asa abono mɛ gyangbara Yesu ansi dɔ mɔ mɛ gya ɔnyen mɔ yɛɛ oꞌ bun mɔ-gɛnɔ so. Mɛ gya mɔ gɛnen mɔ, idɛ kon gbaa ne ɔ lɔrɔ ɔ kya kpen ken-ken daa yɛɛ, “Wura Deefidi ɔnaanabi, su me so!” ");
INSERT INTO acd_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Yesu gi nu gɛnen mɔ, o sii yelɛ, ne ɔ tɔgɛ yɛɛ mɛꞌ kyu gyaatanbo mɔ ba. Mɛ kyu mɔ ba mɔ, Yesu gi taasɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Menɛ ne fo kya laarɛ nꞌ wɔra sa fo?” Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Me-wura, n kya laarɛ me-ansi aꞌ bugi.” ");
INSERT INTO acd_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Fo-ansi aꞌ bugi! Gisɔɔgyi gibono fo bo sa me mɔ ne nan kyɛ fo faa.” ");
INSERT INTO acd_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Ayaa abono so mɔ, ɔnyen mɔ ansi a bugi, ɔ kya wu ilaa kamaasɛ, ne ɔ san naa buu Yesu ɔ kya lɛɛ Wurubuaarɛ ginyen. Sakpii mɔ gi wu ilaa ibono i ba mɔ, mɔmɔ pɛwu mɛ yen Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Yesu gi loo Gyɛriko ɔ kya lii mɔ, ");
INSERT INTO acd_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ɔbelɛnsɛ ɔko bo nno. Mɛ kya terɛ mɔ yɛɛ Sakiyɔsɛ. Ɔ bo abono mɛ kya sɔɔ lɛnpoo ne mɛ kya kudi asa gyi mɔ gikpen mɔ dɔ. Ɔ gyɛ aterenbi wura gɛsintin. ");
INSERT INTO acd_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Yesu gi loo ɔsowolɛ mɔ so gɛnen mɔ, Sakiyɔsɛ baarɛ ginsi gi pɛɛrɛ ɔ kya laarɛ de oꞌ wu Yesu de mɔ-ansi. Sakiyɔsɛ gyɛ daa nyamesɛ din. Imɔso ibono sakpii mɔ kyɔ gikyɔ so mɔ, ɔ mɛŋ kya nyɛ de oꞌ wu Yesu. ");
INSERT INTO acd_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Gɛnen so mɔ, o kuu ɔnangya kyon asa mɔ so ne ɔ kpaa dii ɔ gyanꞌ Siikamɔɔ oyii belɛ ɔko so nfono Yesu laa kyu de mɔ. Yesu laa kyon mɔ, de ɔꞌ nyɛ wu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Yesu gi baa fo oyii mɔ gikɔɔdɔ mɔ, ɔ diirɛ mɔ-ansi kerɛ oyii mɔ dɔ, ne ɔ terɛ yɛɛ, “Sakiyɔsɛ, kpelegɛ ba belen. Fo-gɛwi ne i kaaborɛ nꞌ kyena ndɛ.” ");
INSERT INTO acd_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nfono mɔ Sakiyɔsɛ gi kpelegɛ lii oyii mɔ so ne o kyu Yesu kpe mɔ-gɛwi kpaa keda mɔ gisafo de ɔkon. ");
INSERT INTO acd_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Asa abono mɛ wu yɛɛ Yesu gi kpe ɔ bo Sakiyɔsɛ gɛten dɔ mɔ pɛwu, mɛ kya lɔgedɛ yɛɛ, “Kerɛ, Yesu gi kpe kpaa sogɛ daa ilaa nyɛnyɛn ɔwɔrabo gɛwi.” ");
INSERT INTO acd_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Yesu bo Sakiyɔsɛ gɛwi gɛnen mɔ, Sakiyɔsɛ gi koso yelɛ ne ɔ tɔgɛ sa Yesu yɛɛ, “Me-wura, nu me asɛ. Nan yɛ me-ilaa kamaasɛ ibono n bo mɔ dɔ de nꞌ kyu gibaafon kyu yɛ-yɛ sa ayenbo. Asa abono pɛwu nɛ kudi mɔmɔ gyi baa kyon mɔ nan ka ibono nɛ kudi mɔmɔ gyi mɔ sa mɔmɔ de nꞌ kii ka da gyanꞌ mɔmɔ gikpadɔ ginan.” ");
INSERT INTO acd_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Nfono ne Yesu gi tɔgɛ yɛɛ, “Ndɛ berɛ, gɛnen gɛten gɛdɛ dɔ asa mɛ nyɛ Wurubuaarɛ amɔlɛgɛ. Fɛye abono pɛwu fɛ bo gɛrɛnaa mɔ, fɛꞌ bii yɛɛ gɛnen ɔnyen baarɛ gyɛ aye-naana Aberaham ɔpaa dɔ isa fɛɛ fɛye kee. ");
INSERT INTO acd_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nɛ ba daa de nꞌ baa laarɛ asa abono mɛ fuɛ Wurubuaarɛ ɔkpa mɔ gɛten de nꞌ mɔlɛgɛ ɔmɔ de mɛꞌ kii wu ɔkpa mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Asa mɔ mɛ san mɛ kya nu Yesu ilaa tɔgɛsɛ mɔ, ɔ da mɔmɔ gikpalɛ giko. I kya nyiile yɛɛ mɔmɔ-nwɔnsa ne n gyɛ yɛɛ ɔ kya fuude Gyɛrusalem faa mɔ, Wurubuaarɛ gɛwuragyi gɛbono o kyu sa mɔ mɔ gɛ laa lii gɛwi kon ne. Gikpalɛ gɛbono ɔ da mɔmɔ mɔ ne n gyɛ ");
INSERT INTO acd_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","yɛɛ, “Nyamesɛ gbaaꞌ ɔko gi kyena, ɔ gyɛ wuragyibo. Owi ɔko dɔ mɔ, ɔ kya laarɛ de oꞌ kpe ɔbono ɔ gyɛ Wura belɛ mɔ asɛ de Wura belɛ mɔ ɔꞌ kpaa yii mɔ gɛwura de oꞌ kyu baa gyi mɔ-lɛɛ ɔsowolɛ so. ");
INSERT INTO acd_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","“Pɛi ne ɔ laa kyon mɔ, ɔ terɛ mɔ-adega gudu abono mɛ tɛ mɔ asɛ mɔ ne ɔ yɛ aterenbi sa mɔmɔ ɔkamaasɛ. Mɔmɔ ɔkamaasɛ gi nyɛ kyɛɛ-kyɛɛ. Ɔ laa yɛ aterenbi mɔ sa mɔmɔ mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, ‘Fɛꞌ sɔɔ aterenbi adɛ buɛɛdɛ gyoo me de nꞌ baa kii ba mɔ aꞌ wɔra agyan sa me.’ ");
INSERT INTO acd_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Mɔ-ɔsowolɛ mɔ so asa, mɔ, mɛ kya kyo mɔ. Imɔso ɔ kyon mɔ, mɛ sun isɔɔ kpe Wura belɛ mɔ asɛ de mɛꞌ kpaa tɔgɛ sa Wura belɛ mɔ yɛɛ mɛŋ kya laarɛ yɛɛ oꞌ gyi gɛwura sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Wura belɛ mɔ mɔ gi dabɔlɛ kyu gɛwuragyi mɔ sa mɔ, ne o kii ba mɔ-ɔsowolɛ mɔ so. Ɔ ba mɔ, ɔ terɛ mɔ-adega abono ɔ sa ɔmɔ aterenbi mɔ ba mɔ asɛ yɛɛ mɛꞌ baa buu-buu agyan abono ɔkara mɛ nyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Mɔ-dega gyangbarasɛ mɔ gi tɔgɛ sa mɔ yɛɛ, ‘Ɔbelɛnsɛ, kerɛ, aterenbi abono fo kyu sa me mɔ, nɛ nyɛ amɔ-ɔnan gikpadɔ gudu.’ ");
INSERT INTO acd_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Ɔbelɛnsɛ mɔ gi nu gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, ‘Fo wɔra ilaa; fɔɔꞌkpon. Fɛɛ gɛnɔɔbono fo gyi gɛsintin ilaa ipii idɛ dɔ faa mɔ, nan kyu isowolɛ gudu kyu sa fo de foꞌ kerɛ imɔ so.’ ");
INSERT INTO acd_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Mɔ-dega nyɔsɛ mɔ gi tɔgɛ mɔ yɛɛ, ‘Ɔbelɛnsɛ, aterenbi abono fo kyu sa me mɔ, nɛ nyɛ amɔ-ɔnan gikpadɔ ginun.’ ");
INSERT INTO acd_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Ɔbelɛnsɛ mɔ gi lɛɛ gɛnɔ yɛɛ, ‘Fo, mɔ, nan yɛgɛ fo laa kerɛ isowolɛ inun so.’ ");
INSERT INTO acd_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Mɔ-dega mɔ ɔko berɛ, gi tɔgɛ sa mɔ yɛɛ, ‘Ɔbelɛnsɛ, fo-aterenbi ne! Nɛ kyu amɔ ŋminde de gipanan ŋara kyin‑n. ");
INSERT INTO acd_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Nɛ wu yɛɛ fo-ilaa i bo lon, imɔso nɛ selɛ fo gifuu. Fo bo onsipara. Fo kya laarɛ agyan lii gɛsun gɛbono iŋ gyɛ fo ne n wɔra mɔ dɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Ɔ tɔgɛ gɛnen ta mɔ, ɔbelɛnsɛ mɔ gi tɔgɛ mɔ yɛɛ, ‘Fo gyɛ dega nyɛnyɛn. Nan kyu fo-ilaa tɔgɛsɛ idɛ kyu bun fo gipuɛɛ. Fo nyi yɛɛ me-ilaa i bo lon. N gyɛ onsipara wura. N kya laarɛ agyan lii gɛsun gɛbono iŋ gyɛ me ne n wɔra mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Ne i wonɛ ne foŋ kyu me-aterenbi mɔ kpaa yela aterenbi ɔyelaten de owi ɔbono nɛ ba ne nan kpaa lɛɛ amɔ mɔ, nꞌ nyɛ de aꞌ korogɛ sa me?’ ");
INSERT INTO acd_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Nfono mɔ, ɔbelɛnsɛ mɔ gi tɔgɛ sa abono mɛ yelɛ nno mɔ yɛɛ, ‘Fɛꞌ sɔgɛ me-aterenbi mɔ lii dega baarɛ asɛ kyu bɔla ɔbono ɔ nyɛ amɔ-ɔnan gikpadɔ gudu mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, ‘Ɔbelɛnsɛ, ɔ ti nyɛ amɔ-ɔnan gikpadɔ gudu!’ ");
INSERT INTO acd_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Ɔbelɛnsɛ mɔ gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, ‘Nꞌ buu sa fɛye yɛɛ ɔbono ɔ bo ne ɔ kya kyu wɔra ilaa mɔ, ɔ laa kii nyɛ too. Ne ɔbono, mɔ, ɔŋ bo ne ɔŋ kya kyu wɔra sɛi mɔ, ipii ibono ɔ nyɛ mɔ gbaa mɛ laa sɔgɛ lii mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","I san abono mɛ gyɛ me-akyobo ne mɛ mɛŋ kya laarɛ nꞌ wɔra mɔmɔ-wura mɔ, fɛꞌ kyu mɔmɔ baa mɔɔ me-ansi dɔ gɛrɛnaa.’ ” ");
INSERT INTO acd_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Yesu gi tɔgɛ imɔ idɛ ta mɔ, idɛ kon mɔ o yii ɔkpa ɔ kya dii ɔ kya kpe Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","O sindi Bɛtɛfagye de Bɛtani isowolɛ ibono i gyanꞌ Nfɔ Iyii gibii mɔ so mɔ, o sun mɔ-akasɛbo mɔ dɔ anyɔ ");
INSERT INTO acd_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","yɛɛ, “Fɛꞌ kpe ɔsowolɛ ɔbono ɔ bo aye-ansi dɔ faa. Fɛ kya loo ɔsowolɛ mɔ so mɔ, fɛ laa wu bee fɔlɛ ɔbono ɔko mɛŋ ti gyanꞌ mɔ kerɛ mɔ kyaa de ɔfɛ. Fɛꞌ sangɛ mɔ kyu bara me gɛrɛ. ");
INSERT INTO acd_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne fɛɛ ɔko gi taasɛ fɛye yɛɛ, ‘Menɛ n wɔra ne fɛ kya sangɛ bee mɔ’ mɔ, fɛꞌ tɔgɛ sa mɔ yɛɛ, ‘Wura mɔ tiri bee mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Abono o sun mɔ mɛ kyon mɔ, mɛ kpaa wu ilaa kamaasɛ, fɛɛ gɛnɔɔbono Yesu gi tɔgɛ sa mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mɛ kya sangɛ bee mɔ mɔ, bee mɔ mɔ-wuraana mɛ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ kya sangɛ bee mɔ?” ");
INSERT INTO acd_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ne mɛ lɛɛ gɛnɔ yɛɛ, “Wura mɔ tiri bee mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Imɔso mɛ sangɛ bee mɔ kyu kperɛ Yesu. Ne mɛ kyu mɔmɔ-akuru too gyanꞌ bee mɔ so, ne mɛ puru Yesu gyanꞌ. ");
INSERT INTO acd_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Asa sakyɔ mɛ buu mɔ. Ako, mɔ, mɛ gyangbara sa mɔ mɛ kya kyu mɔmɔ-akuru too mɔ-ɔkpa dɔ yɛɛ ɔꞌ baa naa amɔ so kyon. ");
INSERT INTO acd_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mɛ kya laarɛ mɛꞌ kpelegɛ Nfɔ Iyii Gibii mɔ mɔ, i bo mɔ-akasɛbo gikpen belɛ mɔ ɔkon kyɔde, ne mɛ yii gɛsɛ mɛ kya yen Wurubuaarɛ ken-ken kyu lii ilaa gbaaꞌgbaa ibono pɛwu Yesu gi kyu Wurubuaarɛ ɔlon kyu kpaa asa ne mɛ wu de mɔmɔ-ansi mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Mɛ naa mɛ kya kpen yɛɛ, “Fo ne n gyɛ Wura! Wura Wurubuaarɛ ɔꞌ kosorɛ fo-gimu! Wurubuaarɛ ginyen dɔ ne fo naa fo kya ba faa! Gisen yuuli gi bo Wurubuaarɛ dɔ! Wurubuaarɛ ɔbono ɔ bo soso mɔ tansi ɔ bo nyisigyi!” ");
INSERT INTO acd_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Farasii awura abono mɛ bo sakpii mɔ dɔ mɔ mɛ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, gya fo-adɛ mɔ yɛɛ mɛꞌ sii kurun.” ");
INSERT INTO acd_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne Yesu gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Nꞌ buu sa fɛye yɛɛ ba‑a mɛꞌ sii kurun mɔ, abui gbaa a laa bugi gɛnɔ kpen.” ");
INSERT INTO acd_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Yesu kya fuude Gyɛrusalem. Ɔ da de ginsi ne o wu ɔsowolɛ mɔ mɔ, o su sa nno asa. ");
INSERT INTO acd_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Ɔ kya su gɛnen mɔ, ɔ tɔgɛ yɛɛ, “Gyɛrusalem awura, me-gisen dɔ gɛlaarɛ ne yɛɛ nkana fɛꞌ bii ɔkpa ɔbono so fɛ laa kyu de fɛꞌ nyɛ gisen yuuli ndɛ gɛkɛ gɛdɛ mɔ! Imɔ, mɔ, mɔ, i baala fɛye-ansi bun; fɛŋ nyɛ bii gɛnen ɔkpa ɔbono. ");
INSERT INTO acd_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Gɛkaako mɔ fɛye-akyobo mɛ laa kyaabɔɔ fɛye faa kilenten. Mɛ laa sola isɛ mada gɛkpen gɛbono fɛ yii kyaabɔɔ fɛye-ɔsowolɛ mɔ de iꞌ dii kyaga de ɔpɔɔrɛ mɔ. I dii kyaga mɔ, mɛ laa kyu de nfono so kpelegɛ loo fɛye-ɔsowolɛ dɔ baa kɔ de fɛye. Mɛ laa tii fɛye wɔra nsana. ");
INSERT INTO acd_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Fɛye-akyobo mɛ laa boori fɛye-ibu bun, ba‑a ɔpɔɔrɛ kolon maŋ san, ne mɛ laa mɔɔ fɛye. I lii fɛɛ Wurubuaarɛ gi sun me yɛɛ nꞌ baa kerɛ fɛye mɔ, fɛŋ wu me bii.” ");
INSERT INTO acd_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Yesu gi loo Gyɛrusalem mɔ, ɔ kyon kpe Wurubuaarɛ ɔson obu gikpara mɔ so. Ɔ fo nno mɔ, o wu yɛɛ asa mɛ kyu nno bingiri gigya ogyiten. O wu gɛnen mɔ, o yii gɛsɛ ɔ kya gya abono mɛ kya fɛ ilaa nno mɔ, ");
INSERT INTO acd_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ne ɔ tɔgɛ sa ɔmɔ yɛɛ, “Mɛ ŋmarasɛ Wurubuaarɛ agyɛbi ako yela yɛɛ, ‘Me-ɔson obu mɔ laa wɔra daa ɔdalaaten.’ Fɛye, mɔ, fɛ kyu nno bingiri iyu gikpalan.” ");
INSERT INTO acd_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Gɛkɛ kamaasɛ mɔ Yesu kya nyiile asa ilaa Wurubuaarɛ ɔson obu gikpaara mɔ so. Gyuda awura asunbi alɛɛbo abelɛnsɛ, mɔmɔ-nbara aŋmarasɛbo, de mɔmɔ-anyamesɛ gbaaꞌgbaa mɔ mɛ kya laarɛ mɔ-imɔɔten. ");
INSERT INTO acd_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Mɔmɔ-asa sɛnsɛ mɔ so mɔ, mɛŋ kii mɛ kya nyɛ de mɛꞌ keda mɔ. I kya nyiile yɛɛ mɔmɔ abono pɛwu mɛ kpɛ mɛ kya nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Gɛkɛ gɛdɛ, Yesu kya nyiile asa ilaa ne ɔ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so, ne Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo de mɔmɔ-abelɛnsɛ sɛnsɛ ako mɔ mɛ kpe mɔ asɛ, ");
INSERT INTO acd_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ne mɛ kpaa taasɛ mɔ yɛɛ, “Ilaa ibonoana fo kya wɔra faa mɔ, anɛ ginyen dɔ ne fo kya wɔra imɔ daa? Anɛ ne n sa fo ɔkpa yɛɛ foꞌ wɔra imɔ? Tɔgɛ aye.” ");
INSERT INTO acd_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Yesu gi lɛɛ gɛnɔ yɛɛ, “Me kee nan taasɛ fɛye ilaa kolon de fɛꞌ lɛɛ gɛnɔ sa me. ");
INSERT INTO acd_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wurubuaarɛ sagyere ɔbono Gyɔn gi gyere asa mɔ, anɛ ne n sa mɔ ɔkpa? Wurubuaarɛ abɛɛ nyamesɛ? Fɛꞌ lɛɛ gɛnɔ de nꞌ nu.” ");
INSERT INTO acd_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Yesu gi taasɛ ɔmɔ gɛnen mɔ, akyɔɔlɛ a tɔrɔ mɔmɔ wolɛ-wolɛ so, ne mɛ tɔgɛ yɛɛ, “Nengyene a kyule sa mɔ yɛɛ Wurubuaarɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono mɔ, ɔ laa taasɛ aye yɛɛ, ne menɛ n wɔra ne a mɛŋ sɔɔ Gyɔn gyi? ");
INSERT INTO acd_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ne fɛɛ a kii tɔgɛ yɛɛ nyamesɛ ne n sa Gyɔn gɛnen ɔkpa ɔbono mɔ, asa mɔ pɛwu mɛ laa da aye abui mɔɔ. I lii fɛɛ mɛ nyi yɛɛ Wurubuaarɛ ne n sun Gyɔn ne ɔ gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo.” ");
INSERT INTO acd_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Gɛnen so mɔ mɛ lɛɛ gɛnɔ sa Yesu yɛɛ, “A mɛŋ nyi ɔbono ɔ sa Gyɔn gɛnen ɔkpa ɔbono mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛ maŋ tɔgɛ me berɛ mɔ, me kee maŋ tɔgɛ fɛye ɔbono ɔ sa me ɔkpa ne nꞌ kya wɔra ilaa ibono n kya wɔra mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ne Yesu gi da gikpalɛ sa abelɛnsɛ mɔ yɛɛ, “Ɔnyen ɔko gi kyena. Ɔ dɔɔ gifɔlɛ giko ndɔɔ. Ɔ dɔɔ ndɔɔ mɔ gɛnen mɔ, o kyu nmɔ wɔra asa ako abaa dɔ yɛɛ mɛꞌ kerɛ nmɔ so sa mɔ de mɔ‑rɛ mɔmɔ mɛꞌ yɛ agyan abono mɛ laa nyɛ mɔ. Ne ɔ koso kpe ɔkpa kpaa kɛɛla. ");
INSERT INTO acd_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Gifɔlɛ mɔ abi aberɛ tɛɛsɛ a fo mɔ, ndɔɔ wura mɔ gi sun mɔ-dega ɔko yɛɛ, ɔꞌ kpe mɔ-ndɔɔ akerɛbo mɔ asɛ de mɛꞌ kyu mɔ-lɛɛ ogyiten bara mɔ. Mɔ-dega mɔ gi kpe mɔ, mɔ-ndɔɔ akerɛbo mɔ mɛ daarɛ mɔ, ne mɛ gya mɔ kii abaa gikpan. ");
INSERT INTO acd_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Ndɔɔ wura mɔ gi nu ilaa ibono i ba mɔ, o kii sun mɔ-dega ɔko mɔ-ndɔɔ akerɛbo mɔ asɛ. Ɔbono kee gi kpe mɔ, ndɔɔ akerɛbo mɔ mɛ daarɛ mɔ ne mɛ wɔra mɔ ibono i mɛŋ gyɛ iwɔrasɛ mɔ gya mɔ kii abaa gikpan. ");
INSERT INTO acd_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ndɔɔ wura mɔ gi sun dega sasɛ. O kpe mɔ, ndɔɔ akerɛbo mɔ mɛ daarɛ ɔbono kee gooli mɔ, ne mɛ too mɔ lii ndɔɔ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Nfono mɔ, ndɔɔ wura mɔ gi taasɛ mɔ-nyoro yɛɛ, ‘Nnɛ ne nan wɔra me-ilaa idɛ ne?’ Ne o kii tɔgɛ sa mɔ-nyoro yɛɛ, ‘Nan sun me gbaa-gbaa me-gisen dɔ obi me-ndɔɔ akerɛbo adɛ asɛ. Mɔ berɛ, nɛ sɔɔ gyi yɛɛ mɛ laa kyu buubuu sa mɔ.’ Gɛsintin mɔ, o sun mɔ-bi mɔ mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Mɔ-bi mɔ gi kpe mɔ, mɔ, ndɔɔ akerɛbo mɔ mɛ kpɛ da de ginsi wu mɔ mɔ, mɛ tɔgɛ sa abara yɛɛ, ‘Ɔbono ɔ laa gyi mɔ-sɛ atɔ mɔ ne n kya ba faa. Aꞌ mɔɔ mɔ de mɔ-tɔgyi mɔ ɔꞌ nyɛ sii de aye.’ ");
INSERT INTO acd_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Gɛsintin mɔ, mɛ keda ndɔɔ wura mɔ mɔ-bi mɔ biidɛ lii ndɔɔ mɔ dɔ ne mɛ mɔɔ mɔ.” Yesu gi da gikpalɛ gidɛ ta mɔ, ɔ taasɛ asa mɔ yɛɛ, “Imɔso menɛ ne ndɔɔ wura mɔ laa wɔra mɔ-ndɔɔ akerɛbo mɔ? ");
INSERT INTO acd_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nꞌ tɔgɛ sa fɛye yɛɛ ndɔɔ wura mɔ laa kpaa mɔɔ mɔmɔ de oꞌ kyu ndɔɔ mɔ kyu wɔra akerɛbo pobɔrɔ abaa dɔ.” Asa mɔ mɛ nu imɔ idɛ mɔ, mɛ tɔgɛ yɛɛ, “Iŋ sa iꞌ ba gɛnen!” ");
INSERT INTO acd_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mɛ lɛɛ gɛnɔ gɛnen mɔ, Yesu gi kerɛ ɔmɔ faa yiridididi ne ɔ taasɛ ɔmɔ yɛɛ, “Ne fɛɛ i maŋ ba gɛnen mɔ, i wonɛ so ne mɛ ŋmarasɛ imɔ idɛ yela Wurubuaarɛ agyɛbi dɔ? Mɛ ŋmarasɛ yɛɛ, ‘Gibui gibono ibu apɔrɔbo mɔ mɛ kyu too gɛbaamara mɔ gɛnen gibui kolon gibono ne n kii baa yɛgɛ ne obu mɔ gi wɔra ɔlon ɔ yelɛ faa. ");
INSERT INTO acd_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nyamesɛ kamaasɛ ɔbono ɔ laa tɔrɔ gɛnen gibui gibono so mɔ, kaasɛ laa gbaa gberi-gberi. Ne gibui mɔ, mɔ, ne n kii baa tɔrɔ fo ɔko so mɔ berɛ, fo laa kɔrɔ faa dogo-dogo wɔra fɛɛ nnyufo.’ ” ");
INSERT INTO acd_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Yesu gi da gikpalɛ mɔ gɛnen mɔ, Gyuda awura nbara aŋmarasɛbo mɔ de mɔmɔ-asunbi alɛɛbo abelɛnsɛ mɔ mɛ bii yɛɛ mɔmɔ ne ɔ darɛ. Imɔso mɛ laarɛ fɛɛ mɛꞌ keda mɔ gɛnen owi ɔbono. Mɛ kii mɛ selɛ sakpii ɔbono ɔ bo nfono mɔ gifuu. ");
INSERT INTO acd_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Imɔso abelɛnsɛ abono mɛ kya laarɛ mɛꞌ keda Yesu mɔ mɛ san mɛ kya dii mɔ daa. Mɛ sun asa ako mɔ asɛ yɛɛ mɛꞌ kpaa penɛ fɛɛ mɛ gyɛ gɛsintin awura; nengyene ɔ tɔgɛ ilaa ibono mɛ laa nyɛ yelɛ imɔ so mɔ, de mɛꞌ kyu mɔ wɔra mɔmɔ-abɛyin ɔbelɛnsɛ ɔbono ɔ kya kerɛ mɔmɔ so mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Imɔso isɔɔ mɔ mɛ kpe Yesu asɛ ne mɛ kpaa too mɔ soso yɛɛ, “Ɔbelɛnsɛ, a wu yɛɛ fo kya tɔgɛ ne fo kya nyiile ilaa de iꞌ kyena ɔkpa so. Fo berɛ, fo mɛŋ kya kerɛ nyamesɛ sakyɔ abɛɛ mɔ-nyisigyi ɔbono ɔ bo mɔ de foꞌ buu ɔko don ɔko. Fo kya nyiile asa Wurubuaarɛ ɔkpa daa de iꞌ kyena de Wurubuaarɛ gɛsintin mɔ. ");
INSERT INTO acd_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","A dɛ fo giserɛ, tɔgɛ aye, imɔso Rom wura belɛ ɔbono ɔ kya kerɛ aye so ne ɔŋ kya son Wurubuaarɛ mɔ, i dɛ ɔkpa Wurubuaarɛ asɛ yɛɛ aꞌ sɔɔ mɔ-lɛnpoo abɛɛ a mɛŋ sa aꞌ sɔɔ?” ");
INSERT INTO acd_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Yesu, mɔ, gi dɛsɛ yɛɛ mɛ kya soo mɔ idoo daa. Ne ɔ tɔgɛ sa ɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ɔko ɔꞌ lɛɛ aterenbi gibi ba de nꞌ kerɛ.” Gɛsintin mɔ, mɛ kyu aterenbi gibi kyu sa mɔ, ne ɔ taasɛ ɔmɔ yɛɛ, “Anɛ gimu de mɔ-ginyen ne n gyanꞌ aterenbi gibi gidɛ so faa?” Mɛ lɛɛ gɛnɔ yɛɛ, “Rom wura belɛ mɔ-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Ne Yesu gi kisee tɔgɛ sa mɔmɔ yɛɛ, “To! Gɛnen berɛ mɔ, ilaa ibono i gyɛ Rom wura belɛ mɔ-lɛɛ mɔ fɛꞌ kyu sa mɔ, ne ibono, mɔ, i gyɛ Wurubuaarɛ-lɛɛ mɔ, fɛꞌ kyu sa Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Gɛnɔɔbono ɔ lɛɛ gɛnɔ sa ɔmɔ mɔ, i dɛ mɔmɔ-gɛnɔ. Mɛ mɛŋ nyɛ ilaa nyɛnyɛn iko lii ilaa ibono ɔ tɔgɛ sansana mɔ de mɛꞌ kyu mɔ wɔra nbɛlɛ dɔ. Imɔso mɛ mɛŋ baa taalɛ tɔgɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Saadusii gikpen dɔ awura ako kee mɛ ba Yesu asɛ. Saadusii awura adɛ ne n kpɛ mɛ dɛ yɛɛ nengyene nyamesɛ gi wuꞌ mɔ, i ta. Iŋ baa i bo gɛtɛɛko ɔ laa kpaa kyena, ne Wurubuaarɛ maŋ baa kyingi asa gɛkaako. ");
INSERT INTO acd_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Gɛnen asa adɛ mɛ ba Yesu asɛ baa taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, Mosisi gi yela nbara nko sa aye yɛɛ, ‘Nengyene ɔnyen gi wuꞌ taa mɔ-ka yɛgɛ owi ɔbono mɔ-ka mɔ mɛŋ ti korogɛ sa mɔ mɔ, mɔ-daa abɛɛ mɔ-tedɛ oꞌ kyu ɔkyii mɔ lɛɛ gikulaa de mɔ‑rɛ mɔ mɛꞌ korogɛ nbii sa mɔ-kuli ɔbono o wuꞌ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","To. Owi ɔko dɔ mɔ, ɔnyen ɔko mɔ‑rɛ mɔ-tedɛana asee ne n kyena. Gɛnen ɔnyen baarɛ gi kyu ɔkyii. Mɔ‑rɛ mɔ-ka mɔ mɛŋ korogɛ ne o wuꞌ taa mɔ-ka mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mosisi nbara nbono ɔ yela sa aye mɔ so mɔ, mɔ-gigyaamara mɔ gi kyu ɔkyii mɔ lɛɛ gikulaa. Mɔ‑rɛ ɔkyii mɔ mɛ mɛŋ korogɛ, ne mɔ kee gi wuꞌ taa ɔkyii mɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Ɔsasɛ mɔ kee gɛnen, ne mɔmɔ anyen sono mɔ pɛwu mɛ dena ɔkyii mɔ gyanꞌ, ne mɛ wuꞌ taa mɔ yɛgɛ. Ɔkyii mɔ mɛŋ korogɛ sa mɔmɔ ɔko‑rɛ ɔko. ");
INSERT INTO acd_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Laalaalogɛ mɔ, ɔkyii mɔ kee gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","To, nengyene Wurubuaarɛ laa kyingi asa mɔ, anɛ ne n bo gɛnen ɔkyii baarɛ gɛkyena pobɔrɔ gɛbono dɔ? I kya nyiile yɛɛ owi ɔbono mɛ tɛ de ansi mɔ, mɔmɔ anyen sono adɛ pɛwu mɛ dena mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Yesu gi lɛɛ gɛnɔ yɛɛ, “Abono mɛ tɛ de ansi mɔ ne n kya dena. ");
INSERT INTO acd_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Asa abono Wurubuaarɛ gi wu yɛɛ mɛ kaaborɛ mɛꞌ nyɛ kyena mɔ asɛ ne ɔ laa kyingi mɔmɔ lii ibuni dɔ gɛkaako mɔ, mɔmɔ berɛ, gɛdena gɛŋ baa gɛ bo no sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mɛ maŋ baa wuꞌ gɛkaako. Mɔmɔ-gɛkyena gɛ laa wɔra daa fɛɛ Wurubuaarɛ dɔ isɔɔ-lɛɛ mɔ ɔnan. Mɛ gyɛ Wurubuaarɛ mɔ-biana gɛsintin. I lii fɛɛ Wurubuaarɛ gi kyingi mɔmɔ lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ne Yesu gi kii tɔgɛ sa Saadusii awura mɔ yɛɛ, “Fɛ kya sɔɔ akyɔɔlɛ yɛɛ asa mɛ wuꞌ mɔ, iŋ baa i bo gɛtɛɛko mɛ laa kpaa kyena mɔ, aꞌ kerɛ Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ de aꞌ kerɛ. Ɔwolɛ mɔ dɔ mɔ, Mosisi gbaaꞌ gi wolaa lɛɛ nyiile aye yɛɛ asa mɛ wuꞌ mɔ, mɛ bo gɛtɛɛko mɛ kya kpaa kyena. O nu Wurubuaarɛ gi tɔngɛ sa mɔ lii giponfɛ giko dɔ ne ɔ ŋmarasɛ agyɛbi mɔ yela yɛɛ, ‘Me ne n gyɛ Aberaham Wurubuaarɛ. N gyɛ Ayisiki Wurubuaarɛ, ne nꞌ gyɛ Gyeekɔpo Wurubuaarɛ.’ ");
INSERT INTO acd_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Aberɛ abono Wurubuaarɛ gi tɔgɛ gɛnen ilaa idɛ sa Mosisi mɔ, gɛnen asa adɛ mɛ ti wolaa wuꞌ. Ne fɛɛ iloobu idɛ mɛŋ bo gɛtɛɛko daa mɔ, Wurubuaarɛ maŋ tɔgɛ yɛɛ, ‘N gyɛ mɔmɔ-Wurubuaarɛ.’ Nkana ɔ laa tɔgɛ daa yɛɛ, ‘Nɛ naa kyena wɔra mɔmɔ-Wurubuaarɛ yɛgɛ.’ Imɔso Wurubuaarɛ nyi yɛɛ mɛ bo gɛtɛɛko mɛ tɛ.” ");
INSERT INTO acd_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Yesu gi tɔgɛ gɛnen ta mɔ, Gyuda awura nbara aŋmarasɛbo mɔ ako mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, fo lɛɛ gɛnɔ kanpɛ.” ");
INSERT INTO acd_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Kpɛ kyu lii nfono mɔ, ɔko mɛŋ baa taalɛ too Yesu soso kerɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Nfono mɔ, Yesu, mɔ, gi taasɛ mɔmɔ yɛɛ, “Nnɛ so ne ɔkamaasɛ kya tɔgɛ yɛɛ ɔbono Wurubuaarɛ laa sun de oꞌ gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ laa kisee wɔra daa Wura Deefidi ɔnaanabi? ");
INSERT INTO acd_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Yɛgɛ Deefidi gbaa-gbaa gi ti tɔgɛ kaasɛ mɔ ilaa wolaa yela. Ɔ tɔgɛ Wurubuaarɛ Ilon Ɔwolɛ mɔ dɔ yɛɛ, ‘Wurubuaarɛ laa tɔgɛ sa me-Wura mɔ yɛɛ, “Baa kyena me-gibaa gyisɛ so de me‑rɛ fo aꞌ gyi gɛwura ");
INSERT INTO acd_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","de nꞌ yɛgɛ foꞌ kyise fo-akyobo de fo-ayaa.” ’ ” ");
INSERT INTO acd_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Yesu gi kii lɛɛ gɛsɛ yɛɛ, “Imɔso Deefidi kya terɛ kaasɛ yɛɛ, ‘Me-Wura’ faa mɔ, nnɛ so ne ɔ laa kisee wɔra daa Deefidi ɔnaanabi?” ");
INSERT INTO acd_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Owi ɔbono asa mɔ pɛwu mɛ kya nu Yesu asɛ mɔ, ɔ tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Fɛꞌ kerɛ fɛye-nyoro so dɔɔdan de aye Gyuda awura nbara aŋmarasɛbo adɛ. Mɛ kya laarɛ daa ngbɛ belɛ-belɛ gisuu naa asa dɔ. Mɛ kya laarɛ fɛɛ asa mɛꞌ terɛ mɔmɔ yɛɛ ‘Abelɛnsɛ’ de mɛꞌ kyu buubuu faala ɔmɔ sakpii dɔ de ɔkamaasɛ oꞌ wu. Ne fɛɛ mɛ kya kpe mɔmɔ-akyangbon dɔ mɔ, abɛɛ mɛ laa gyi gɛkɛ belɛ mɔ, abelɛnsɛ de anyamesɛ gbaaꞌgbaa ikyenaten ne mɛ kya laarɛ. ");
INSERT INTO acd_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Mɔmɔ gɛnen asa abono ne n kya kii kudi akyii ikulaabo mɔmɔ‑rɛ mɔmɔ-biana gyi, yɛgɛ mɛ laa dalaa mɔ, mɛ kya dalaa faa bolo-bolo de asa mɛꞌ nyɛ yen mɔmɔ yɛɛ mɔmɔ ne n nyi gɛdalaa. Owi ɔbono Wurubuaarɛ laa gyi mɔmɔ-nbɛlɛ mɔ, mɔmɔ-gisobiidɛ gi laa nyaakyɔ too.” ");
INSERT INTO acd_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Yesu bo Wurubuaarɛ ɔson obu gikpaara mɔ so mɔ, ɔ diirɛ mɔ-ansi kerɛ gidɛkaa gibono asa mɛ kya kyu aterenbi wɔra sa Wurubuaarɛ mɔ. O wu aterenbi awura mɛ kya lɛɛ mɔmɔ-aterenbi mɛ kya wɔra. ");
INSERT INTO acd_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Nfono mɔ, o wu ɔkyii okulaabo yenbo ɔko, mɔ, gi baa kyu aterenbi abi anyɔ ako baa wɔra gidɛkaa mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Yesu gi wu gɛnen mɔ, o nyiile mɔ-akasɛbo mɔ yɛɛ, “Iŋ gyɛ fɛ wu okulaabo yenbo baarɛ? Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, ɔkyii baarɛ gi kyɛɛ Wurubuaarɛ aterenbi don asa sɛnsɛ adɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","I kya nyiile yɛɛ asa adɛ pɛwu mɛ lɛɛ mɔmɔ-aterenbi dɔ daa kyu baa kyɛɛ Wurubuaarɛ. Ɔkyii baarɛ, mɔ, ipii ibono ɔ bo ne nkana imɔ ne ɔ tɛ kpasa de mɔ, imɔ pɛwu ne o kyu baa kyɛɛ Wurubuaarɛ faa.” ");
INSERT INTO acd_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Yesu akasɛbo mɔ ako mɛ kya gyi nsingyi kyu lii Wurubuaarɛ ɔson obu mɔ so. Mɛ kya diilɛ mɔ-ɔdan ne mɛ kya kerɛ abui dɛnsɛ-dɛnsɛ abono mɛ kyu pɔrɔ mɔ mɔ de ilaa dɛnsɛ ibono asa mɛ kyu baa kyɛɛ Wurubuaarɛ ne mɛ kyu lɔrɔ obu mɔ mɔ. Yesu, mɔ, gi tɔgɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Imɔ ibono pɛwu fɛ kya wu faa, i laa baa fo owi ɔko mɔ, ako mɛ laa baa boori imɔ bun. Ba‑a gibui kolon gi maŋ san yɛɛ gi maŋ dɛ gɛsɛ.” ");
INSERT INTO acd_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Yesu akasɛbo mɔ dɔ ako mɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, owi ɔmɔ dɔ ne mɛ laa boori imɔ bun gɛnen? Menɛ ilaa ne nan ba de iꞌ lɛɛ nyiile yɛɛ ilaa idɛ i kya laarɛ iꞌ ba gɛsintin?” ");
INSERT INTO acd_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ɔ lɛɛ gɛnɔ yɛɛ, “Fɛꞌ kerɛ fɛye-nyoro so dandan daa de ɔko ɔꞌ mɛŋ sa ɔꞌ nyɛ fɛye penɛ. Asa sakyɔ mɛ laa naa mɛ kya tɔgɛ yɛɛ mɔmɔ ne n gyɛ me ɔbono Wurubuaarɛ gi sun mɔ. Mɛ laa tɔgɛ yɛɛ, ‘Owi mɔ gi fuude.’ Fɛ nu gɛnen mɔ, fɛ mɛŋ sa fɛꞌ buu mɔmɔ-gitan. ");
INSERT INTO acd_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","“Nengyene fɛ kya nu yɛɛ faanaa isowolɛ mɛ kya kɔ de abara, de faanaa asa mɛŋ kya kyule mɔmɔ-ɔsowolɛ mɔ, fɛ mɛŋ sa fɛꞌ yɛgɛ fɛye-gisen giꞌ ŋmaa fɛye. Imɔ idɛ i gyɛ ilaa ibono i laa daa giba mɔ daa. Ne i mɛŋ gyɛ yɛɛ ilaa kamaasɛ i kya yela ɔkara ayaa abono so ne.” ");
INSERT INTO acd_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Ne Yesu gi kii tɔgɛ ɔmɔ yɛɛ, “Fɛ laa nu asa kpɛi-kpɛi mɛ laa laarɛ ikɔ too abara so. Abɛyin de abɛyin mɛ laa koso yelɛ mɛ kya kɔ de abara. ");
INSERT INTO acd_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Nten kpɛi-kpɛi so mɔ, gɛsinkpan gɛ laa gyigisi de ɔlon, akon a laa tɔrɔ, ne alɔtɔ abono a kya kyangɛ asa mɔ a laa gbigi. Ilaa ibono i laa wɔra gɛsinkpan mɔ so mɔ, i laa wɔra asa gifuu. Ilaa belɛ-belɛ i laa wɔra Wurubuaarɛ awolɛ dɔ, ne i laa lɛɛ Wurubuaarɛ ɔlon nyiile asa. ");
INSERT INTO acd_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Pɛi ne gɛnen ilaa idɛana pɛwu i laa baa ba mɔ, ibono fɛ gyɛ me-akasɛbo faa so mɔ, asa abaa a laa gyanꞌ fɛye so de mɛꞌ ka fɛye-ansi. Mɛ laa kparɛ fɛye kpe mɔmɔ-akyangbon dɔ kpaa gyi fɛye-nbɛlɛ de mɛꞌ kyu fɛye tii de ibu. Mɛ laa kparɛ fɛye kpe awura de abɛyin abelɛnsɛ ansi dɔ. Me so ne mɛ laa wɔra fɛye imɔ idɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","I ba gɛnen mɔ, i laa bugi ɔkpa sa fɛye daa de fɛꞌ nyɛ tɔgɛ me-ilaa sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Fɛꞌ kyu too fɛye-nyoro so yɛɛ fɛ maŋ sa gɛwɔnsa yela yɛɛ idɛ ne a laa kpaa tɔgɛ nbɛlɛ mɔ ogyiten. ");
INSERT INTO acd_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Owi mɔ gi fo mɔ, me, Yesu ne nan sa fɛye agyɛbi de ɔlaako ginyi de fɛꞌ kyu lɛɛ gɛnɔ. Fɛye-akyobo mɔ dɔ ɔko‑rɛ ɔko maŋ nyɛ lɛɛ imɔ gɛnɔ abɛɛ mɛꞌ sɔɔ imɔ akyɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Fɛye abono fɛ kya son me faa dɔ ako akorogɛbo, abɛɛ fɛye-daana, abɛɛ fɛye-tedɛana, abɛɛ fɛye-subuana, abɛɛ fɛye-kyɛmenɛana, mɛ laa fɛ fɛye dɔ ako sa fɛye-akyobo de mɛꞌ mɔɔ fɛye dɔ ako. ");
INSERT INTO acd_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Me so mɔ, ɔkamaasɛ laa kyo fɛye. ");
INSERT INTO acd_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Mɛ dabɔlɛ kyo fɛye nnɛ mɔ, mɛ maŋ taalɛ wɔra fɛye sɛi. ");
INSERT INTO acd_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Fo ɔbono fo ka gyan me so kpaa lii mɔ, fo laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan. ");
INSERT INTO acd_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Nengyene fɛ wu asogya mɛ kyaabɔɔ Gyɛrusalem mɔ, fɛꞌ bii yɛɛ i maŋ kɛɛla ne ɔsowolɛ mɔ laa boori bun. ");
INSERT INTO acd_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Fɛ wu gɛnen mɔ, fɛye abono fɛ bo Gyudiya gɛsinkpan so mɔ, fɛꞌ selɛ kpe abii dɔ. Fɛye abono fɛ bo ɔsowolɛ mɔ so mɔ, fɛꞌ lii mɔ dɔ, ne fɛye abono, mɔ, fɛ bo ndɔɔ dɔ gɛnen owi ɔbono mɔ, fɛ mɛŋ sa fɛꞌ tɔgɛ yɛɛ fɛ laa kii ba nten dɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Gɛnen owi ɔbono ne Wurubuaarɛ laa ka asa ilaa nyɛnyɛn ibono mɛ wɔra mɔ gikɔ. Ɔ biidɛ mɔmɔ-giso gɛnen mɔ, i laa yɛgɛ ilaa kamaasɛ ibono mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ iꞌ nyɛ ba gɛsintin. ");
INSERT INTO acd_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Awɔrɔfɔɔ a laa nyaakyɔ gikyɔ so mɔ, akyii abono mɛ da itɔ gɛnen nkɛ nbono dɔ mɔ abɛɛ mɔmɔ-biana mɛ san mɛ kya nyabo mɔmɔ mɔ, mɔmɔ laako. I kya nyiile yɛɛ gɛyiyɛɛ belɛ gɛ laa tɔrɔ gɛsinkpan so, ne Wurubuaarɛ laa lɛɛ mɔ-ginyadon gɛwi nyiile fɛye Gyuda awura adɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Asa mɛ laa mɔɔ Gyuda awura ako de nki. Mɛ laa keda mɔmɔ ako gikyii ŋminde mɔmɔ kyu kpaa bingiri asafo gɛten kamaasɛ kyaabɔɔ de gɛsinkpan so. Asafo ne nan san kyu Gyɛrusalem ɔsowolɛ kyu bingiri mɔmɔ-lɛɛ kpaa fo owi ɔbono mɔmɔ-lɛɛ ɔlon laa yela ɔkara mɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Asa mɛ laa wu ilaa lɛɛnyiilesɛ owi de bosɛ de agyɛkpebi dɔ. Gɛsinkpan so asa kpɛi-kpɛi mɛ laa nu apoo kya gbere, ne mɛ laa nu afuu abono a laa da apoo so mɔ, i laa ŋmaa mɔmɔ-asen, ne mɔmɔ-nyoro gi laa togɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Asa mɛ laa wu ilaa ibono i kya wɔra gɛsinkpan so mɔ, imɔ-gifuu dɔ so‑o so mɔ, i laa yɛgɛ mɛ laa lii tɔrɔ mɛ kya kiidɛ ma‑a wu. I kya nyiile yɛɛ ɔlon kpɛi-kpɛi ɔbono ɔ bo soso ne i yɛgɛ a taalɛ a tɛ gɛsɛ gɛrɛ mɔ, Wurubuaarɛ laa keda mɔ kyɛɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Nfono mɔ, asa mɛ laa wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan naa lii Wurubuaarɛ awolɛ dɔ n kya ba, n dɛ ɔlon de nyisigyi belɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Nengyene fɛ wu gɛnen ilaa idɛana i yii gɛsɛ i kya ba mɔ, fɛꞌ diirɛ fɛye-ansi kerɛ soso. I lii fɛɛ owi ɔbono Wurubuaarɛ laa mɔlɛgɛ fɛye de fɛꞌ nyɛ fɛye-nyoro mɔ gi fuude ne.” ");
INSERT INTO acd_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Ne Yesu gi da gikpalɛ sa mɔmɔ yɛɛ, “Fɛꞌ kerɛ gifeeya oyii de iyii sɛnsɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nengyene fɛ kya wu iyii i kya yaa ne i kya laarɛ iꞌ pɔrɔgɛ mɔ, fɛ kya bii yɛɛ gikyɛ gi kya fuude ne. ");
INSERT INTO acd_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Gɛnen kee ne i dɛ ne. Nengyene fɛ wu ilaa ibonoana nɛ tɔgɛ sa fɛye faa i kya ba mɔ, fɛꞌ bii yɛɛ Wurubuaarɛ kya laarɛ ɔꞌ lɛɛ mɔ-gɛwuragyi mɔ nyiile asa kon. ");
INSERT INTO acd_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa. Asa abono mɛ tɛ gɛsinkpan so gɛnen aberɛ adɛ dɔ mɔ mɛ maŋ wuꞌ logɛ pɛi de gɛnen ilaa idɛana pɛwu iꞌ lɔɔ ba. ");
INSERT INTO acd_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Soso de gɛsɛ i laa yela ɔkara. Me-agyɛbi mɔ berɛ a maŋ yela ɔkara gɛkaako kpa‑a. ");
INSERT INTO acd_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Fɛꞌ dɛsɛ fɛye-nyoro so. Fɛꞌ mɛŋ sa fɛꞌ yɛgɛ ɔkon gigyi de nta giboo de fɛye-gɛkyena dɔ ilaa tirisɛ iꞌ gyi fɛye-amu. I mɛŋ gyɛ gɛnen mɔ, gɛkɛ gɛbono nan kii ba mɔ, i laa tuule fɛye; fɛ maŋ dɛsɛ. ");
INSERT INTO acd_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","I kya nyiile yɛɛ gɛnen gɛkɛ gɛbono gɛ laa tuule asa sɛnsɛ pɛwu abono mɛ bo gɛsinkpan so mɔ fɛɛ gɛnɔɔbono ɔdoo kya too gɛbuɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Fɛꞌ dɛsɛ fɛye-nyoro so owi kamaasɛ dɔ fɛ kpɛ fɛ kya dalaa fɛ kya kolɛ Wurubuaarɛ yɛɛ ɔꞌ sa fɛye ɔlon de nengyene gɛnen ilaa idɛ pɛwu i ba i kya wɔra mɔ de fɛꞌ nyɛ taalɛ lii imɔ dɔ de fɛꞌ nyɛ ayaa yelɛsɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ-ansi dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Gɛkɛ kamaasɛ mɔ Yesu kya nyiile asa ilaa Wurubuaarɛ ɔson obu gikpaara mɔ so. Owi gi ta mɔ, ɔ kya lii Gyɛrusalem de ɔꞌ kpaa dɛ Nfɔ Iyii Gibii mɔ so. ");
INSERT INTO acd_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Gɛdɛ gɛ kpɛ gɛ kya kɛ mɔ, ɔ kya kii ba Gyɛrusalem Wurubuaarɛ ɔson obu gikpaara mɔ so. Asa mɔ pɛwu mɛ kya ba mɔ asɛ nno nyɛnyɛngɛ fu‑u de mɛꞌ nyɛ nu mɔ-ilaa nyiilesɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Gyuda awura Bodobodo Maadiisɛ gɛkɛ belɛ gɛbono mɛ kya terɛ yɛɛ Lɛwu Gi Seregɛ Aye So mɔ gɛ kya fuude. ");
INSERT INTO acd_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Ne Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo mɔ mɛ kya laarɛ gɛnɔɔbono mɛ laa nyɛ Yesu mɔɔ mɔ, mɛ kii mɛ selɛ sakpii ɔbono ɔ yelɛ Yesu gɛmara mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Nfono mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi suu de Gyudasɛ. Ɔ gyɛ Yesu isɔɔ gudu anyɔ mɔ dɔ ɔko. Mɔ-ginyen giko ne n gyɛ Isikaayɔtɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Ilaa nyɛnyɛn gɛmu mɔ gi suu de Gyudasɛ mɔ, o kpe kpaa wu gɛnen asunbi alɛɛbo abelɛnsɛ mɔ de Wurubuaarɛ ɔson obu mɔ adiibo abelɛnsɛ. Ne ɔ tɔgɛ mɔmɔ yɛɛ ɔ laa laarɛ ɔkpa ɔbono so ɔ laa nyɛ kyu Yesu wɔra mɔmɔ-abaa dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Mɛ nu gɛnen mɔ, i wɔra mɔmɔ ɔkon ne mɛ tɔgɛ sa mɔ yɛɛ ɔ taalɛ wɔra gɛnen mɔ, mɔmɔ, mɔ, mɛ laa sɔɔ mɔ ka gikɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","O kyule ne ɔ san ɔ kya laarɛ owi ɔbono i laa sa de oꞌ kyu Yesu wɔra mɔmɔ-abaa dɔ ne asa sɛnsɛ mɔ mɛ maŋ bii mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Gɛkɛ gɛbono Bodobodo Maadiisɛ Agyiberɛ mɔ gɛ kya yii gɛsɛ mɔ, mɛ kya kyɔɔlɛ isandɛ de mɛꞌ kyu gyi mɔmɔ-Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Gɛnen gɛkɛ gɛbono dɔ mɔ, Yesu gi lɛɛ Piita mɔ‑rɛ Gyɔn sun yɛɛ, “Fɛꞌ kpe de fɛꞌ kpaa baala Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ agyudɔ sa aye de aꞌ baa gyi.” ");
INSERT INTO acd_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ne mɛ taasɛ mɔ yɛɛ, “Fonɛ ne fo kya laarɛ aꞌ kpaa baala agyudɔ mɔ yela?” ");
INSERT INTO acd_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛꞌ naa loo nten dɔ. Fɛ kya loo mɔ, fɛ laa wu ɔnyen ɔko, ɔ so nkyu de gɛlɔbi. Fɛꞌ buu mɔ kpaa loo gɛten gɛbono dɔ ɔ laa loo mɔ ");
INSERT INTO acd_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","de fɛꞌ taasɛ gɛten wura mɔ yɛɛ, ‘Ɔbelɛnsɛ mɔ yɛɛ asafo obu ɔmɔ dɔ ne mɔ‑rɛ mɔ-akasɛbo mɔ mɛ laa kyena de mɛꞌ gyi Lɛwu Gi Seregɛ Aye So Gɛkɛ Belɛ agyudɔ mɔ?’ ");
INSERT INTO acd_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Gɛten wura mɔ laa nyiile fɛye soso-lɛɛ obu belɛ ɔko. Ikyenaten de ikamaasɛ i ti i bo nno. Fɛꞌ kerɛ agyudɔ mɔ yela sa aye nno.” ");
INSERT INTO acd_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Yesu akasɛbo mɔ mɛ kyon. Gɛsintin mɔ, mɛ kpaa wu ilaa kamaasɛ fɛɛ gɛnɔɔbono Yesu gi nyiile mɔmɔ mɔ. Ne mɛ kerɛ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ agyudɔ mɔ yela nno. ");
INSERT INTO acd_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Owi gyisɛ mɔ gi fo mɔ, Yesu mɔ‑rɛ mɔ-isɔɔ mɔ mɛ kpe nno kpaa kyena mɛ kya gyi. ");
INSERT INTO acd_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Mɛ kya gyi mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nɛ tansi laarɛ yɛɛ me‑rɛ fɛye aꞌ gyi gɛnen Lɛwu Gi Seregɛ Aye So agyudɔ adɛ dabɔlɛ pɛi de nꞌ lɔɔ wu ɔlaawusɛ ɔbono ɔ dɛ sa me mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","N kya tɔgɛ mi‑i sa fɛye yɛɛ meŋ baa kii gyi gɛnen gɛsi gɛdɛ. Pɛi de nꞌ kii gyi gɛmɔ mɔ, gɛnen mɔ, ilaa ibono so a kya gyi gɛmɔ gɛsi kamaasɛ mɔ i ba gɛsintin ne Wurubuaarɛ gi ti yɛgɛ asa mɛ nyɛ mɔ-gɛwuragyi dɔ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Ɔ tɔgɛ gɛnen ta mɔ, o puru konkon de nta, ne o kyu afaala kyu sa Wurubuaarɛ, ne o kyu sa mɔ-isɔɔ mɔ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ sɔɔ nta ndɛ de fɛꞌ nun kɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nꞌ tɔgɛ fɛye yɛɛ pɛi ne nan kii nun nta mɔ, gɛnen mɔ, asa mɛ nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ɔ tɔgɛ gɛnen ta mɔ, o puru bodobodo keda, o kyu afaala sa Wurubuaarɛ, ne ɔ gbaa-gbaa mɔ dɔ kyu sa mɔ-akasɛbo mɔ yɛɛ, “Me-nyoro ne. N dɛ mi‑i sa fɛye. Fɛꞌ wɔra imɔ idɛ kyu nyingi me.” ");
INSERT INTO acd_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Gɛnen kee ne mɛ gyi ta mɔ, o puru konkon de nta keda, ne ɔ tɔgɛ yɛɛ, “Nta nbono n dɛ mii sa fɛye faa, me-nkalan ne. Nan wuꞌ mɔ, me-nkalan gi laa kyɛɛgɛ fuɛ sa fɛye, de Wurubuaarɛ ɔꞌ yɛgɛ fɛye‑rɛ mɔ fɛꞌ nyɛ wɔra gɛnɔ pobɔrɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Ɔbono ɔ laa yɛgɛ me-akyobo mɛꞌ nyɛ me mɔ bo me asɛ gɛnen ogyiten baarɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","I bo no yɛɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan wuꞌ lɛwu ɔbono ɔnan Wurubuaarɛ gi wolaa tɔgɛ yela mɔ. Ɔbono ɔ laa kyu me wɔra me-akyobo mɔ abaa dɔ mɔ berɛ, kaasɛ laako!” ");
INSERT INTO acd_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nfono mɔ mɔ-isɔɔ mɔ mɛ yii gɛsɛ mɛ kya taasɛ abara de mɛꞌ bii mɔmɔ dɔ ɔkolon ɔbono ɔ laa wɔra gɛnen mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Nfono mɔ, Yesu isɔɔ mɔ mɛ kya sɔɔ abara akyɔɔlɛ yɛɛ mɔmɔ pɛwu dɔ mɔ anɛ ne n don mɔ-nanbo. ");
INSERT INTO acd_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Imɔso Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Asa abono mɛ mɛŋ nyi Wurubuaarɛ agyɛbi mɔ, mɔmɔ-awura mɛ kya kyu abono mɛ bo mɔmɔ gɛsɛ mɔ wɔra fɛɛ mɔmɔ-nbide, ne abono mɛ kya gyi gɛbelɛnsɛ mɔmɔ so mɔ, mɛ kya yɛgɛ ɔmɔ mɛꞌ terɛ mɔmɔ yɛɛ, ‘Aye-sɛana.’ ");
INSERT INTO acd_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Fɛye-lɛɛ berɛ, iŋ kaaborɛ iꞌ wɔra fɛɛ asa abono. Ɔbono ɔ don mɔ-nanboana mɔ gi kaaborɛ ɔꞌ bara mɔ-nyoro gɛsɛ de oꞌ bingiri fɛɛ gɛbii pii gɛkpaa fɛye dɔ de ɔbono ɔ gyɛ fɛye-ɔgyangbarabo mɔ ɔꞌ wɔra mɔ-nyoro fɛɛ fɛye-dega. ");
INSERT INTO acd_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ɔbono ɔ tɛ ne mɛ kya kyu agyudɔ baa yii mɔ de oꞌ gyi mɔ, de ɔbono ɔ laa kyu agyudɔ mɔ baa yii mɔ mɔ, ɔmɔ dɔ mɔ, anɛ ne n don mɔ-nanbo? Asa asɛ mɔ, ɔbono ɔ tɛ ne mɛ kya kyu agyudɔ baa yii mɔ mɔ ne n don. Me berɛ nɛ ba daa de nꞌ baa son fɛye. ");
INSERT INTO acd_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Me-ɔlaawusɛ kamaasɛ dɔ mɔ, fɛye ne n gyɛ abono fɛ mili me. ");
INSERT INTO acd_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Fɛɛ gɛnɔɔbono me-sɛ Wurubuaarɛ gi sa me gɛwuragyi mɔ, me kee nɛ sa fɛye gɛwuragyi. ");
INSERT INTO acd_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Aberɛ abono n kya gyi gɛwura mɔ, me‑rɛ fɛye a laa wɔra abaa gyi de aꞌ nun dabɔlɛ. Fɛ laa gyi gɛwura Isirale nten gudu nnyɔ mɔ so de fɛꞌ gyi mɔmɔ-nbɛlɛ sa mɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Nfono mɔ Yesu gi tɔgɛ sa Simon yɛɛ, “Simon, Simon, kerɛ! Ilaa nyɛnyɛn pɛwu gɛmu mɔ gi kolɛ ɔkpa de ɔꞌ nyɛ fo‑rɛ fo-nanboana adɛ de ɔꞌ daasɛ gisɔɔgyi gibono fɛ bo sa me mɔ kerɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Fo berɛ nɛ dalaa sa fo yɛɛ fo-gisɔɔgyi mɔ giŋ sa giꞌ koso me so. Nengyene fo-gisɔɔgyi gi kii wɔra ɔlon mɔ, kpaa fo-nanboana de mɔmɔ-lɛɛ giꞌ wɔra ɔlon kee.” ");
INSERT INTO acd_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Simon Piita, mɔ, gi lɛɛ gɛnɔ yɛɛ, “Me-wura, mɛ laa tii fo de obu‑o, mɛ laa mɔɔ fo daa‑o, me‑rɛ fo ne.” ");
INSERT INTO acd_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Sɔɔ gibui yela, gɛnyɛ gɛdɛ pɛi de kyaasɛ gyangbarasɛ ɔꞌ lɔɔ folɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” ");
INSERT INTO acd_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Nfono mɔ Yesu gi taasɛ mɔ-isɔɔ mɔ yɛɛ, “Owi ɔbono nɛ sun fɛye ne fɛ mɛŋ keda aterenbi, abɛɛ ilaa ɔwɔraten abɛɛ ayaawolɛ mɔ, fɛ kponderɛ ilaa iko?” Mɛ lɛɛ gɛnɔ yɛɛ, “Kuaa, aŋ kponderɛ sɛi sɛi.” ");
INSERT INTO acd_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nperɛ berɛ fɛye dɔ ɔbono ɔ bo aterenbi ɔwɔraten abɛɛ atɔ ɔwɔraten mɔ oꞌ puru keda. Ne ɔbono, mɔ, ɔŋ bo gɛki mɔ ɔꞌ fɛ mɔ-gɛgbɛ de oꞌ kyu sɔɔ gɛki. ");
INSERT INTO acd_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","I bo Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, ‘Mɛ kalɛ mɔ wɔra ilaa nyɛnyɛn awɔrabo dɔ.’ N kya buu mi‑i sa fɛye yɛɛ i laa ba me so gɛnen. Me-gɛsinkpan so gɛkyena gɛ kya ba laalaalogɛ fɛɛ gɛnɔɔbono mɛ wolaa ŋmarasɛ yela mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Ɔ tɔgɛ gɛnen ta mɔ, mɔ-isɔɔ mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, kerɛ, a bo nki nnyɔ.” Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “I kaabo gɛnen.” ");
INSERT INTO acd_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Yesu gi lii kpe Nfɔ Iyii Gibii mɔ so, fɛɛ gɛnɔɔbono ɔ wolaa ɔ kya wɔra mɔ, ne mɔ-akasɛbo mɔ mɛ buu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mɛ fo nno mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ dalaa yɛɛ ilaa ibono i kya ba mɔ i mɛŋꞌ nyɛ fɛye penɛ de fɛꞌ wɔra ilaa nyɛnyɛn.” ");
INSERT INTO acd_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Ɔ naa taa mɔmɔ yɛgɛ tu kpe ansi dɔ ŋmaraa, ne o sii ŋmii ɔ kya dalaa. ");
INSERT INTO acd_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Ɔ dalaa yɛɛ, “Me-sɛ, nengyene fo laa kyule mɔ, nkana yɛgɛ awɔrɔfɔɔ abono a kya ba me so faa aꞌ kyon gibaafon. Nɛ dabɔlɛ kolɛ gɛnen faa, i mɛŋ gyɛ me-lɛɛ gɛlaarɛ ne gɛꞌ wɔra. Fo-lɛɛ gɛlaarɛ ne gɛꞌ wɔra.”  ");
INSERT INTO acd_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Ɔ dalaa gɛnen mɔ, Wurubuaarɛ ɔsɔɔ gi lii Wurubuaarɛ dɔ ba mɔ asɛ baa sa mɔ ɔlon. ");
INSERT INTO acd_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Imɔ gɛnen gbaa mɔ, mɔ-gisen dɔ i kya dɛɛ mɔ, ne o kii lɔrɔ pɛɛrɛ ansi dalaa. Gisisiri gibono gi kya lii mɔ-nyoro so gi kya tɔrɔ gɛsinkpan mɔ gi dɛ fɛɛ nkalan. ");
INSERT INTO acd_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Yesu gi kyon ɔꞌ kpaa dalaa mɔ, mɔ-akasɛbo mɔ mɛ kya yiyɛɛ mɔ so, ne ginsi gidɛ gi baa yuuri mɔmɔ. Yesu gi dalaa ta ne ɔ baa tu mɔmɔ mɔ, mɛ dɛ ginsi gidɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","O kyingi mɔmɔ, ne ɔ taasɛ mɔmɔ yɛɛ, “Fɛ dɛ daa? Fɛꞌ koso de fɛꞌ dalaa yɛɛ ilaa ibono i kya ba mɔ i mɛŋꞌ nyɛ fɛye penɛ de fɛꞌ wɔra ilaa nyɛnyɛn.” ");
INSERT INTO acd_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Yesu san ɔ yelɛ ɔ kya tɔngɛ mɔ, sakpii belɛ ɔko gi dii lii mɔmɔ so. Gyudasɛ ɔbono ɔ gyɛ mɔ-isɔɔ gudu anyɔ mɔ dɔ ɔko gyangbara ɔ sa mɔmɔ. Gyudasɛ gi fo mɔ, ɔ naa kpe Yesu asɛ, ɔ kya laarɛ ɔꞌ faala mɔ da mɔ gya-gya. ");
INSERT INTO acd_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","O kpe Yesu asɛ mɔ, Yesu gi taasɛ mɔ yɛɛ, “Gyudasɛ, me-afaala ne? Gɛnen ne fo laa kyu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, wɔra me-akyobo abaa dɔ ne?” ");
INSERT INTO acd_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Yesu isɔɔ mɔ mɛ wu ilaa ibono i kya ba mɔ, mɛ taasɛ Yesu yɛɛ, “Aye-wura, aꞌ ŋɛ mɔmɔ nki?” ");
INSERT INTO acd_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Yesu mɛŋ ti lɛɛ gɛnɔ mɔ, mɔ-isɔɔ mɔ dɔ ɔko gi ŋɛɛlɛ dega ɔko gyisɛ giso fuɛ. Dega mɔ wura ne n gyɛ asunbi alɛɛbo gɛmu. ");
INSERT INTO acd_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Nfono mɔ Yesu gi tɔgɛ sa mɔ-isɔɔ mɔ yɛɛ, “Fɛꞌ taa yɛgɛ!” Ne ɔ tengɛ mɔ-gibaa yii dega mɔ giso, ne giso mɔ gi kii baa kyaga. ");
INSERT INTO acd_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ne Yesu gi taasɛ asunbi alɛɛbo abelɛnsɛ mɔ de Wurubuaarɛ ɔson obu mɔ adiibo abelɛnsɛ de abelɛnsɛ sɛnsɛ abono mɛ ba de mɛꞌ baa keda mɔ mɔ yɛɛ, “N gyɛ oyu nyɛnyɛn daa, ne fɛ kyu nki de nkpotii baa keda me faa? ");
INSERT INTO acd_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Iŋ gyɛ me‑rɛ fɛye ne, Wurubuaarɛ ɔson obu gikpaara mɔ so adaa-adaa? I wonɛ ne fɛ mɛŋ keda me nno? Idɛ kon berɛ fɛye-owi mɔ ne n fo faa, ne ilaa nyɛnyɛn gɛmu ɔbono ɔ bo lon gibiri dɔ mɔ laa nyɛ mɔ-nyoro wɔra mɔ-gɛlaarɛ kon.” ");
INSERT INTO acd_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Imɔso mɛ keda Yesu, ne mɛ kparɛ mɔ kpe asunbi alɛɛbo gɛmu mɔ gɛten dɔ. Mɛ kya kpe gɛnen mɔ, Piita gi buu mɔmɔ giyaa-giyaa. ");
INSERT INTO acd_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Mɛ loo asunbi alɛɛbo gɛmu mɔ gɛten dɔ mɔ, mɛ wu yɛɛ asa mɛ baada ɔgya gikpaara mɔ so mɛ tɛ kyaabɔɔ ɔgya mɔ mɛ kya wolɛ, ne Piita gi naa kpaa kyena mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Obolonbu ɔko gi wu Piita tɛ ɔgya mɔ asɛ, ne ɔ kerɛ mɔ-ansi dɔ faa yiridididi, ne ɔ tɔgɛ yɛɛ, “Gɛnen ɔnyen baarɛ kee mɔ‑rɛ Yesu ne n naa.” ");
INSERT INTO acd_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Piita gi sorogɛ kpalɛ-kpalɛ yɛɛ, “Ɔkyii, meŋ taa nyi mɔ!” ");
INSERT INTO acd_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","I wɔra ŋmaraa mɔ, ɔnyen ɔko kee gi wu Piita ne ɔ tɔgɛ sa mɔ yɛɛ, “Fo kee fo gyɛ gɛnen asa abono dɔ.” Piita gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Ɔnyen, meŋ bo mɔmɔ dɔ!” ");
INSERT INTO acd_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","I kii wɔra ŋmaraa too mɔ, ɔnyen ɔko kee gi tɔgɛ yɛɛ, “I gyɛ gɛsintin daa. Ɔnyen baarɛ kee mɔ‑rɛ Yesu ne n naa. I lii fɛɛ mɔ kee gyɛ Galelinyen.” ");
INSERT INTO acd_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Piita gi lɛɛ gɛnɔ sa ɔbono kee yɛɛ, “Ɔnyen, meŋ taa nyi ilaa ibono fo kya tɔgɛ faa.” Piita san ɔ kya tɔngɛ mɔ, ayaa abono so mɔ, kyaasɛ gyangbarasɛ gi folɛ. ");
INSERT INTO acd_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Nfono mɔ Wura Yesu gi kpɛɛlɛ kerɛ mɔ. Mɔmɔ-ansi a gyanꞌ mɔ, Piita gi nyingi gɛnɔɔbono Wura Yesu gi wolaa tɔgɛ sa mɔ yɛɛ, “Ndɛ gɛnyɛ gɛdɛ pɛi de kyaasɛ gyangbarasɛ ɔꞌ lɔɔ folɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” ");
INSERT INTO acd_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Piita gi nyingi gɛnen mɔ, ɔ lii gikpaara mɔ so kpaa su gɛnsipɛɛrɛ so. ");
INSERT INTO acd_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Nfono mɔ, ngbɛ awura abono mɛ kya dii Yesu mɔ mɛ gyaabii mɔ ikpa kpɛi-kpɛi so, ne mɛ daarɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Mɛ ŋminde mɔ-ansi yɛgɛ mɛ kya ŋɛ mɔ, ne mɛ kya taasɛ mɔ yɛɛ, “Anɛ ne n ŋɛ fo? Bii ɔbono ɔ ŋɛ fo mɔ de aꞌ kerɛ.” ");
INSERT INTO acd_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mɛ tɔgɛ agyɛbi loosɛ kpɛi-kpɛi gikyɔ sa mɔ kee. ");
INSERT INTO acd_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Gɛdɛ gɛ kpɛ gɛ kya kɛ mɔ, Gyuda awura asunbi alɛɛbo abelɛnsɛ de mɔmɔ nbara aŋmarasɛbo de mɔmɔ abelɛnsɛ gbaaꞌgbaa ako mɛ baa gyanꞌ, ne mɛ yɛgɛ mɛ kpaa kyu Yesu bara mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mɛ kyu mɔ ba mɔ, abelɛnsɛ mɔ mɛ taasɛ mɔ yɛɛ, “Fo ne n gyɛ ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de ɔꞌ baa gyi gɛwura mɔ-adɛ so mɔ? Tɔgɛ aye.” Ɔ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Me ne n kine nꞌ tɔgɛ fɛye nnɛ mɔ, fɛ maŋ sɔɔ me gyi. ");
INSERT INTO acd_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nengyene nɛ kii taasɛ fɛye ilaa iko kee mɔ, fɛ maŋ lɛɛ gɛnɔ sa me. ");
INSERT INTO acd_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Lii ndɛ kyu i kya kpe mɔ, me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan san kyena daa Wurubuaarɛ Ɔlolonbo mɔ gyisɛ gibaa so n kya gyi gɛwura.” ");
INSERT INTO acd_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Ɔ tɔgɛ mɔmɔ gɛnen mɔ, mɔmɔ pɛwu mɛ taasɛ mɔ yɛɛ, “Gɛnen berɛ mɔ, fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ ne!” Ɔ lɛɛ gɛnɔ yɛɛ, “Fɛye gbaa-gbaa fɛ bii ne.” ");
INSERT INTO acd_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Mɛ nu gɛnen mɔ, mɛ taasɛ abara yɛɛ, “Ilaa imɔ ne a baa a kya laarɛ de aꞌ baa nu lii mɔ so? Aye gbaa-gbaa a nu de aye-aso lii mɔ-gɛnɔ dɔ kon.” ");
INSERT INTO acd_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Mɛ tɔgɛ gɛnen mɔ, abelɛnsɛ gikpen mɔ pɛwu mɛ koso ne mɛ kyu Yesu kpe Ɔbelɛnsɛ Pilato asɛ. ");
INSERT INTO acd_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mɛ kpɛ fo Pilato asɛ mɔ, mɛ yii gɛsɛ mɛ kya buu mɔmɔ-lɛɛ gɛnɔ mɛ kya sa Pilato yɛɛ, “A wu ɔnyen baarɛ yelɛ ɔ kya penɛ aye-adɛ Gyuda awura. Ɔ gya mɔmɔ yɛɛ mɛꞌ mɛŋ sa mɛꞌ sɔɔ Rom awura wura belɛ ɔbono ɔ kya kerɛ aye so mɔ lɛnpoo. Ɔ kya kyu mɔ-nyoro yɛɛ mɔ ne n gyɛ wura ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Imɔso Pilato gi taasɛ Yesu yɛɛ, “Fo ne n gyɛ wura sa Gyuda awura mɔ?” Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo-gɛnɔ dɔ ne i lii.” ");
INSERT INTO acd_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Nfono mɔ Pilato gi tɔgɛ sa Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de sakpii mɔ yɛɛ, “Me berɛ, meŋ wu ilaa nyɛnyɛn iko lii gɛnen ɔnyen baarɛ so.” ");
INSERT INTO acd_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Pilato gi buu sa mɔmɔ gɛnen mɔ, mɛ kii lɔrɔ tɔgɛ bɔla yɛɛ, “Gɛnen ɔnyen baarɛ kya yogesi asa mɔ-ilaa nyiilesɛ dɔ Gyudiya gɛsinkpan pɛwu so. O yii gɛsɛ lii Galeli gɛsinkpan so kaaborɛ o kyu baa loo gɛrɛnaa.” ");
INSERT INTO acd_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Pilato gi nu gɛnen mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Ɔ gyɛ Galelinyen daa?” ");
INSERT INTO acd_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Pilato gi bii yɛɛ Yesu gi lii daa nfono so Wura Hɛrodɛ kya kerɛ mɔ, ɔ yɛgɛ mɛ kyu Yesu kyu kperɛ Hɛrodɛ. Gɛnen owi ɔbono mɔ Hɛrodɛ gbaa-gbaa kee bo Gyɛrusalem nno. ");
INSERT INTO acd_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Hɛrodɛ gi da dɛ ginsi ne o wu Yesu mɔ, i wɔra mɔ ɔkon gikyɔ kyɔde. I kya nyiile yɛɛ o nu Yesu so mɔ, i kɛɛla, ne ɔ kya laarɛ oꞌ wu mɔ de ansi. Ɔ kya laarɛ fɛɛ Yesu ɔꞌ wɔra ilaa ibono nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so mɔ iko de ɔꞌ kerɛ. ");
INSERT INTO acd_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Hɛrodɛ gi taasɛ Yesu ilaa gikyɔ. Yesu, mɔ, mɛŋ lɛɛ gɛnɔ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Gyuda awura asunbi alɛɛbo mɔ de mɔmɔ-nbara aŋmarasɛbo mɛ yelɛ nno mɛ kya kyu ilaa ibono i bo lon mɔ mɛ kya gyanꞌ Yesu so. ");
INSERT INTO acd_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Nfono mɔ Hɛrodɛ mɔ‑rɛ mɔ-ngbɛ awura mɔ mɛ kyɛfoo Yesu, ne mɛ gyaabii mɔ ikpa kpɛi-kpɛi so. Mɛ kyu giwurakuru kyu gyaabii bun mɔ, ne Hɛrodɛ gi yɛgɛ mɛ kyu mɔ kiiri kperɛ Ɔbelɛnsɛ Pilato. ");
INSERT INTO acd_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nkana Pilato mɔ‑rɛ Hɛrodɛ mɛ mɛŋ kya loo. Kyu lii gɛnen gɛkɛ gɛbono kyu kyon mɔ, mɛ kyu abara gɛkyɛmenɛ. ");
INSERT INTO acd_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Mɛ kiiri Yesu bara Pilato mɔ, ɔ terɛ Gyuda awura asunbi alɛɛbo de mɔmɔ-abelɛnsɛ gbaaꞌgbaa de mɔmɔ-asa sɛnsɛ abono mɛ bo nfono mɔ, ");
INSERT INTO acd_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ne o buu sa mɔmɔ yɛɛ, “Fɛ kyu gɛnen ɔnyen baarɛ ba me asɛ mɔ, fɛye yɛɛ ɔ kya yogesi asa. Ilaa ibono fɛ dɛ fɛ kya gyanꞌ mɔ so mɔ, nɛ taasɛ mɔ fɛye-ansi dɔ gɛrɛnaa mɔ, meŋ wu yɛɛ ɔ wɔra imɔ iko‑rɛ iko. ");
INSERT INTO acd_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Hɛrodɛ kee mɛŋ wu ilaa nyɛnyɛn iko mɔ so. I kya nyiile yɛɛ nɛ yɛgɛ mɛ kyu mɔ kpe Hɛrodɛ ansi dɔ ne Hɛrodɛ gi kpaa kiiri mɔ bara me‑rɛ fɛye faa. Fɛꞌ nu yɛɛ ilaa iko i mɛŋ bo no i kya nyiile yɛɛ ɔnyen baarɛ gi wɔra ilaa nyɛnyɛn ibono i kaaborɛ ɔꞌ wɔra ɔmɔɔsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Imɔso nan yɛgɛ mɛꞌ biidɛ mɔ-giso de nꞌ taa mɔ yɛgɛ de ɔꞌ naa.”  ");
INSERT INTO acd_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","I wolaa i gyɛ ilaa ibono Ɔbelɛnsɛ Pilato kya wɔra sa Gyuda awura mɔ yɛɛ nengyene mɛ laa gyi mɔmɔ-gɛkɛ belɛ gɛdɛ mɔ, ɔ kya tigi mɔmɔ-asa abono ɔ keda tii de obu mɔ dɔ nyamesɛ kolon de ɔꞌ naa. Gɛnen so mɔ, Pilato gi taasɛ Gyuda awura mɔ yɛɛ anɛ ne mɛ kya laarɛ de oꞌ tigi sa mɔmɔ gɛnen gɛsi gɛbono dɔ? ");
INSERT INTO acd_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Sakpii mɔ gi nu yɛɛ ɔ laa tigi Yesu mɔ, mɔmɔ pɛwu mɛ kpen gikolon yɛɛ, “Fɛꞌ kyu gɛnen ɔnyen baarɛ kpaa mɔɔ! Fɛꞌ tigi daa Barabasɛ sa aye!” ");
INSERT INTO acd_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ibono so Barabasɛ tii de obu gɛnen mɔ ne n gyɛ yɛɛ owi ɔko dɔ mɔ, mɔ‑rɛ asa ako mɛ koso kɔ de abɛyin awura Gyɛrusalem ɔsowolɛ mɔ so, ne ɔ mɔɔ isa gɛnen ikɔ ibono dɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato gi laarɛ fɛɛ nkana ɔ taa Yesu yɛgɛ de ɔꞌ naa. Gɛnen so mɔ, o kii kpen tɔngɛ sa sakpii mɔ de ɔꞌ buɛɛlɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Sakpii mɔ, mɔ, kpɛ ɔ kya kpen ɔ kya sa mɔ yɛɛ, “Da mɔ aŋanbi oyii so! Da mɔ aŋanbi oyii so mɔɔ!” ");
INSERT INTO acd_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mɛ tɔgɛ sa Pilato gɛnen mɔ, o kii taasɛ mɔmɔ gisasɛ yɛɛ, “De iꞌ wonɛ? Menɛ ilaa nyɛnyɛn ne ɔ wɔra? Meŋ wu ilaa ibono ɔ wɔra ne i kaaborɛ ɔꞌ wɔra ɔmɔɔsɛ mɔ. Imɔso nan yɛgɛ mɛꞌ biidɛ mɔ-giso de nꞌ taa mɔ yɛgɛ de ɔꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pilato gi tɔgɛ sa mɔmɔ gɛnen mɔ, mɛ lɔrɔ mɛ kya kpen ken-ken yɛɛ ɔꞌ da mɔ aŋanbi oyii so mɔɔ. Mɛ kpɛ ma‑a kpen gɛnen mɔ, mɔmɔ-lɛɛ mɔ ne Pilato gi san nu. ");
INSERT INTO acd_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","O kyule yɛɛ ɔ laa wɔra ilaa ibono mɛ kya laarɛ mɔ sa ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ɔ tigi ɔnyen ɔbono ɔ bara ikɔ ne ɔ mɔɔ isa mɔ sa mɔmɔ. Yesu berɛ, ɔ yɛgɛ mɛ kyu mɔ kyon de ɔꞌ kpaa wɔra ɔmɔɔsɛ fɛɛ gɛnɔɔbono mɛ kya laarɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Mɛ dɛ Yesu mɛ kya kpe gɛnen mɔ, mɛ gyangara Simon ɔbono ɔ lii Siirini mɔ. Mɛ wu mɔ mɔ, ɔ naa ɔ kya ba ɔꞌ baa loo ɔsowolɛ mɔ so, ne mɛ nyise mɔ yɛɛ ɔꞌ sola Yesu lɛwu oyii mɔ. Mɛ kyu oyii mɔ sola mɔ yɛɛ oꞌ buu Yesu de mɛꞌ kpe. ");
INSERT INTO acd_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Sakpii belɛ buu mɔmɔ. Akyii ako kee mɛ buu mɔmɔ mɛ kya saawo mɛ kya yiyɛɛ mɛ kya sa Yesu. ");
INSERT INTO acd_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Yesu gi kisee tɔgɛ sa akyii mɔ yɛɛ, “Gyɛrusalem akyii, fɛꞌ mɛŋ sa fɛꞌ su sa me. Fɛꞌ su sa daa fɛye-nyoro de fɛye-biana. ");
INSERT INTO acd_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Awɔrɔfɔɔ owi kya ba. Asa abono mɛ laa wu awɔrɔfɔɔ abono mɔ mɛ laa tɔgɛ yɛɛ, ‘Amudɛnsɛbo ne n gyɛ alabanbo de abono nbii mɛŋ nyabo mɔmɔ kerɛ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Awɔrɔfɔɔ belɛ abono so mɔ, asa mɛ laa tɔgɛ sa abii de nbiibi yɛɛ, ‘Fɛꞌ boori bun aye so.’ ");
INSERT INTO acd_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Asa mɛ dɛ me ɔbono n dɛ fɛɛ oyii bonboli mɛ kya wɔra ɔgya faa mɔ, fɛye abono fɛ dɛ fɛɛ ngya wolɛsɛ mɔ berɛ ne mɛ laa yɛgɛ?” ");
INSERT INTO acd_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Asa mɔ mɛ dɛ Yesu mɛ kya kpe gɛnen mɔ, mɛ dɛ ilaa nyɛnyɛn awɔrabo anyɔ ako kee mɛ kya kpe mɛꞌ kpaa da aŋanbi iyii so mɔɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mɛ naa gɛnen kpaa fo gikpalan giko asɛ. Mɛ kya terɛ nno yɛɛ Gimu Giwuye Gikpalan. Nno ne mɛ da Yesu mɔ‑rɛ ilaa nyɛnyɛn awɔrabo anyɔ mɔ aŋanbi mada de iyii. Mɔmɔ dɔ ɔko bo de Yesu gyisɛ so ne ɔko, mɔ, bo de mɔ-benɛ so. I san Yesu, mɔ, bo nsana.  ");
INSERT INTO acd_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Nfono ne Yesu gi dalaa kolɛ Wurubuaarɛ sa abono mɛ da mɔ aŋanbi mada de oyii mɔ yɛɛ, “Me-sɛ, kyu kyɛɛ mɔmɔ. Mɛ mɛŋ nyi ilaa ibono mɛ kya wɔra faa.” Mɛ wɔra ilaa idɛ pɛwu ta mɔ, mɛ yɛ mɔ-nyoro so atɔ kyu. Mɛ kya yɛ atɔ mɔ mɔ, mɛ too ilaa iko kerɛ. Ɔbono i yii de mɔ mɔ, o kyu. ");
INSERT INTO acd_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Gɛnen owi ɔbono pɛwu mɔ, asa mɛ yelɛ mɛ kerɛ mɔ. Ne Gyuda awura abelɛnsɛ mɔ mɛ kya yoole mɔ. Mɛ kya tɔgɛ yɛɛ, “Mɔ ne n mɔlɛgɛ asa; ɔꞌ mɔlɛgɛ mɔ-nyoro. Nengyene ɔ gyɛ ɔbono Wurubuaarɛ ne n lɛɛ gibaa yii yɛɛ ɔꞌ mɔlɛgɛ asa mɔ, ɔꞌ mɔlɛgɛ mɔ-nyoro de aꞌ kerɛ.” ");
INSERT INTO acd_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Asogya mɔ kee mɛ yoole mɔ, ne mɛ kpaa kyu mɔmɔ-nta bonyansɛ nko kyu ba mɛ kya sa mɔ, ");
INSERT INTO acd_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ne mɛ tɔgɛ sa mɔ yɛɛ, “Fo ne n gyɛ wura sa Gyuda awura mɔ gɛsintin mɔ, mɔlɛgɛ fo-nyoro de aꞌ kerɛ.” ");
INSERT INTO acd_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Mɛ ŋmarasɛ kpaa mada Yesu amu so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Ilaa nyɛnyɛn awɔrabo anyɔ mɔ dɔ ɔko mada de mɔ-lɛɛ oyii mɔ mɔ, ɔ tɔgɛ ilaa loosɛ sa Yesu yɛɛ, “Iŋ gyɛ fo ne Wurubuaarɛ gi sun yɛɛ foꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ? Kii mɔlɛgɛ fo-nyoro de foꞌ mɔlɛgɛ aye kee.” ");
INSERT INTO acd_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ɔ kya tɔgɛ gɛnen mɔ, mɔ-nanbo ilaa nyɛnyɛn ɔwɔrabo mɔ gi gya mɔ yɛɛ ɔŋꞌ baa tɔgɛ gɛnen, ne ɔ taasɛ mɔ yɛɛ, “Fo mɛŋ selɛ Wurubuaarɛ do‑o? Aye‑rɛ mɔ pɛwu ne mɛ kya biidɛ giso mɛ kya mɔɔ faa. ");
INSERT INTO acd_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Aye berɛ, i kaaborɛ aye. I lii fɛɛ aye-ilaa nyɛnyɛn ibono a wɔra mɔ gikɔ ne mɛ kya ka aye faa. Ɔnyen baarɛ, mɔ, ɔŋ wɔra ilaa nyɛnyɛn iko.” ");
INSERT INTO acd_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Ɔnyen mɔ gi tɔgɛ sa mɔ-nanbo mɔ gɛnen mɔ, ne o kisee tɔgɛ sa Yesu yɛɛ, “Yesu, n dɛ fo giserɛ, nyingi me so owi ɔbono fo-gɛwuragyi mɔ gɛ laa yii fo-gibaa mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Gɛsintin ne n kya buu mi‑i sa fo faa, ndɛ gɛkɛ gɛdɛ fo laa loo ɔkyoolaten me asɛ Wurubuaarɛ dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","I baa wɔra fɛɛ owi ken-ken gerɛ-gerɛ mɔ, owi mɛŋ baa ɔ kya lii ne i wɔra gibiri sirim gɛnen gɛsinkpan mɔ pɛwu so kaaborɛ owi gbaasɛ. Gikuru gibono gi tii Wurubuaarɛ obu belɛ mɔ gi kyan ginyɔ lii soso baa yii gɛsɛ kyim. ");
INSERT INTO acd_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nfono mɔ, Yesu gi kpen ken-ken tɔgɛ sa Wurubuaarɛ yɛɛ, “Me-sɛ, fo-abaa dɔ ne nꞌ dɛ me-ɔŋɛ mi‑i wɔra.” Ɔ tɔgɛ gɛnen ta mɔ, ɔ lɛɛ ɔŋɛ. ");
INSERT INTO acd_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Asogya abono mɛ kya dii Yesu mɔ mɔmɔ-ɔbelɛnsɛ gi wu ilaa ibono i ba gɛnen mɔ, ɔ yen Wurubuaarɛ ne ɔ tɔgɛ yɛɛ, “Gɛsintin, ɔnyen baarɛ tansi ɔ gyɛ gɛsintin wura.” ");
INSERT INTO acd_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Gɛnen kee ne sakpii belɛ ɔbono ɔ kpaa yelɛ kerɛ Yesu gimɔɔ ne mɛ wu ilaa kamaasɛ mɔ mɛ kii mɛ kya kpe gɛwi mɔ, mɔmɔ ɔkamaasɛ kya wɛ nyoro ɔ kpɛ ɔ dɛ mɔ-abaa ɔ kya suii mɔ-gikan. I kya nyiile yɛɛ, mɔmɔ-asen dɔ i nyida mɔmɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Yesu mɔ-kyɛmenɛana de akyii abono mɛ buu mɔ lii Galeli kpe Gyɛrusalem mɔ mɛ yelɛ gɛta-gɛta wu ilaa idɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Ɔnyen ɔko bo gɛnen ɔsowolɛ mɔ so. Mɛ kya terɛ mɔ yɛɛ Gyosɛfo. Ɔ lii Arimatiya, Gyudiya awura ɔsowolɛ ɔko so. Ɔ gyɛ Gyuda awura nbɛlɛ agyibo abelɛnsɛ mɔ dɔ ɔko. Ɔ gyɛ isa dɛnsɛ ne ɔ kya gyi gɛsintin. ");
INSERT INTO acd_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Mɔ berɛ, ɔ mɛŋ yelɛ kyule ibono mɛ kyu wɔra Yesu mɔ. Owi kamaasɛ dɔ mɔ, mɔ-ansi a gyanꞌ gɛkaabono asa mɛ laa nyɛ Wurubuaarɛ gɛwuragyi dɔ gɛkyena mɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Gɛnen Gyosɛfo baarɛ gi kpe Pilato asɛ kpaa kolɛ mɔ yɛɛ, ɔ kya laarɛ ɔꞌ kpaa saga Yesu gibuni mɔ lii lɛwu oyii mɔ so kyu kpaa pule. Pilato mɛŋ kine. ");
INSERT INTO acd_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Imɔso Gyosɛfo gi kpaa saga Yesu gibuni mɔ. O kyu gikɛlɛlɛ kyu mili obuni mɔ ne o kyu mɔ kpaa pule gifolɛ gibono mɛ wolaa logedi wɔra ɔbɔ yela sa ibuni gipule mɔ dɔ. Mɛ mɛŋ ti taa pule obuni gɛnen folɛbɔ ɔbono dɔ kerɛ. ");
INSERT INTO acd_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Owi kya ta mɔmɔ. Gɛnen gɛkɛ gɛbono gɛ gyɛ abaala gɛkɛ kyu sa mɔmɔ Gyuda awura gɛkɛ kyoolasɛ so mɔ, mɛ kya kpaala. ");
INSERT INTO acd_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Akyii abono mɛ buu Yesu lii Galeli ba Gyɛrusalem nfono mɔ mɛ buu Gyosɛfo kpe, ne mɛ kperɛ mɔmɔ-ansi kpaa wu folɛbɔ mɔ de gɛnɔɔbono Gyosɛfo gi kyu pule Yesu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Owi kya ta so mɔ, akyii mɔ mɛ kii kpe gɛwi, ne mɛ kpaa baala ilaa ikoana ibono mɛ kya kyu bɔ ibuni mɔ fɛɛ onufuii de piperɛ yela. Mɛ kyena kyoola gɛkɛ kyoolasɛ mɔ, fɛɛ gɛnɔɔbono mɔmɔ-nbara gi kya nyiile mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Mɛ pule Yesu mɔ, imɔ Kosida gibaadiikɛ mɔ, akyii mɔ mɛ kyu ibono mɛ kpaa baala yela i dɛ fɛɛ onufuii de piperɛ mɔ kyu kyon kpe Yesu folɛbɔ gɛkyan mɔ asɛ de mɛꞌ kyu imɔ kyu kpaa bɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mɛ fo nno mɔ, mɛ wu gibui belɛ gɛbono nkana gi tii folɛbɔ mɔ gɛbunono mɔ gi belen kpe gi dɛ nkan. ");
INSERT INTO acd_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Nfono mɔ, mɛ loo folɛbɔ mɔ dɔ. Mɛ loo nno gɛnen mɔ, mɛ mɛŋ wu Wura Yesu gibuni mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","I wɔra ɔmɔ ya‑a. Mɛ san sii mɛ yelɛ. Mɛ yelɛ mɔ, anyen anyɔ ako mɛ lii tuule mɔmɔ. Mɛ suu ngbɛ, gi kya ŋɛlegi ŋalɛ-ŋalɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","I wɔra akyii mɔ gifuu gikyɔ, ne mɛ kyu mɔmɔ-ansi too gɛsɛ. Nfono mɔ anyen mɔ mɛ taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne fɛ ba ibuni opuleten ba fɛ kya laarɛ ɔbono ɔ tɛ de ansi mɔ? ");
INSERT INTO acd_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ɔ mɛŋ bo gɛrɛ. O kyingi lii ibuni dɔ. Fɛꞌ nyingi ilaa ibono ɔ wolaa tɔgɛ fɛye nkɛ nbono ɔ bo fɛye asɛ Galeli gɛsinkpan so mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Ɔ tɔgɛ fɛye yɛɛ i gyɛ ilaa ibono i laa ba yɛɛ mɛ laa kyu mɔ ɔbono ɔ gyɛ anyamesɛ pɛwu mɔmɔ-daa mɔ kyu wɔra ilaa nyɛnyɛn awɔrabo abaa dɔ de mɛꞌ da mɔ aŋanbi mada de oyii de oꞌ wuꞌ. Imɔ gɛkɛ sasɛ mɔ, ɔ laa kyingi lii ibuni dɔ.” ");
INSERT INTO acd_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Anyen mɔ mɛ tɔgɛ gɛnen ta mɔ, nfono mɔ, akyii mɔ mɛ nyingi yɛɛ Yesu gi naa kyena tɔgɛ ɔmɔ gɛnen ilaa idɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Akyii mɔ mɛ lii opuleten mɔ mɔ, mɛ kyon Yesu isɔɔ gudu ɔko mɔ de mɔ-akasɛbo sɛnsɛ mɔ asɛ, ne mɛ kpaa buu ilaa ibono mɛ kpaa wu nno mɔ pɛwu sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Akyii abono mɛ kpaa buu ilaa idɛ sa Yesu isɔɔ mɔ ne n gyɛ Mariya Magadalakyii de Gyowana de Mariya, Gyeemesi mɔ-nyi. Akyii ako kee mɛ bɔla mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Yesu isɔɔ mɔ mɛ nu ilaa ibono akyii mɔ mɛ kpaa wu mɔ, mɛ mɛŋ kyu imɔ kyu wɔra ilaa dɔ; mɛ mɛŋ sɔɔ imɔ gyi.  ");
INSERT INTO acd_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Piita berɛ gi nu gɛnen mɔ, ɔ koso ne o kuu ɔnangya kyon gɛkyan mɔ gɛten. Ɔ fo nno mɔ, o sunge kerɛ folɛbɔ mɔ dɔ, mɔ, o wu daa gikɛlɛlɛ gibono mɛ kyu mili Yesu mɔ wolɛ ne n dɛ. I wɔra mɔ giyan, ne ɔ lii nno san ɔ kya sa imɔ so gɛwɔnsa. ");
INSERT INTO acd_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Gɛnen gɛkɛ kolon gɛbono mɔ, Yesu akasɛbo mɔ dɔ anyɔ ako mɛ kya kpe ɔsowolɛ ɔko so. Mɛ kya terɛ gɛnen ɔsowolɛ mɔ yɛɛ Imayɔsɛ. Lii Gyɛrusalem kpe nno mɔ, i gyɛ akpaaten sono. ");
INSERT INTO acd_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mɛ kya kpe mɔ, mɛ kya gyi nsingyi kyu lii ilaa ibono pɛwu i ba Yesu so mɔ, ");
INSERT INTO acd_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ne mɛ kya sa imɔ so gɛwɔnsa. Nfono mɔ, Yesu gbaa-gbaa gi kpaa tu mɔmɔ, ne mɔmɔ pɛwu mɛ san naa dabɔlɛ mɛ kya kpe. ");
INSERT INTO acd_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Mɔmɔ‑rɛ mɔ mɛ naa gɛnen mɔ, i lɛɛ mɔmɔ-nwɔnsa, mɛ mɛŋ nyɛ bii mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Nfono mɔ, Yesu gi taasɛ mɔmɔ yɛɛ, “Menɛ nsingyi ne fɛ naa fɛ kya gyi ne i bo fɛye ayen gɛnen?” Ɔ taasɛ ɔmɔ gɛnen mɔ, mɛ sii yelɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Ne mɔmɔ dɔ ɔbono mɛ kya terɛ mɔ yɛɛ Kulopasɛ mɔ gi lɛɛ gɛnɔ taasɛ mɔ yɛɛ, “Ilaa ibono i ba Gyɛrusalem gɛnen nkɛ nsa ndɛ dɔ faa, imɔso fo-wolɛ ne n gyɛ isafo ɔbono fo mɛŋ ti nu imɔ?” ");
INSERT INTO acd_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Yesu gi kisee taasɛ yɛɛ, “Menɛ ilaa?” Ne mɛ lɛɛ gɛnɔ sa mɔ yɛɛ, “Ilaa ibono i ba Yesu Nasarɛtɛnyen mɔ so mɔ ne a darɛ. Nkana ɔ gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo. Wurubuaarɛ gbaa-gbaa de anyamesɛ pɛwu mɛ wu yɛɛ mɔ-ilaa wɔrasɛ de mɔ-ilaa tɔgɛsɛ i bo duduu. ");
INSERT INTO acd_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Aye Gyuda awura asunbi alɛɛbo abelɛnsɛ de aye-abelɛnsɛ gbaaꞌgbaa mɛ kyu mɔ wɔra abɛyin abaa dɔ yɛɛ ɔꞌ yɛgɛ mɛꞌ mɔɔ mɔ, ne gɛsintin mɔ, mɛ da mɔ aŋanbi oyii so mɔɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","“Aye, mɔ, aye-ansi a gyanꞌ yɛɛ nkana mɔ ne n gyɛ ɔbono ɔ laa lɛɛ aye Isirale awura lii aye-akyobo abaa dɔ de aye-nyoro giꞌ tɔrɔ aye. Mɛ mɔɔ mɔ faa, ndɛ nkɛ nsa ne. ");
INSERT INTO acd_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Imɔ idɛ pɛwu gɛmara mɔ, ndɛ mɔ aye-gikpen mɔ dɔ akyii ako mɛ yɛgɛ i wɔra aye ya‑a. I lii fɛɛ gibaadiikɛ mɔ, mɛ koso kpe Yesu gɛkyan mɔ gɛten; ");
INSERT INTO acd_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","mɔ, mɛ mɛŋ wu mɔ-gibuni mɔ. Mɛ kii ba baa tɔgɛ sa aye yɛɛ mɛ kpe mɔ, mɛ wu Wurubuaarɛ dɔ isɔɔ iko. Wurubuaarɛ dɔ isɔɔ mɔ mɛ tɔgɛ sa mɔmɔ yɛɛ Yesu tɛ de ansi. ");
INSERT INTO acd_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Aye dɔ ako kee mɛ kpe gɛkyan mɔ gɛten nno. Mɛ kpaa wu fɛɛ gɛnɔɔbono akyii mɔ mɛ baa tɔgɛ mɔ. Mɔmɔ kee mɛ mɛŋ wu mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Mɛ tɔgɛ gɛnen ta mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛ ŋaabaa‑o! Imɔso kookoomenɛ fɛ kya nu ilaa ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ tɔgɛ yela pɛwu faa mɔ, fɛŋ ti sɔɔ imɔ gyi? ");
INSERT INTO acd_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Fɛ mɛŋ nyi yɛɛ i kaaborɛ ɔbono Wurubuaarɛ gi sun yɛɛ oꞌ gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ oꞌ wu ɔlaawusɛ ɔbono ɔnan pɛi de mɔ-nyisigyi mɔ ɔꞌ lɔɔ yii mɔ-gibaa?” ");
INSERT INTO acd_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nfono mɔ Yesu gi lɛɛ Wurubuaarɛ agyɛbi abono mɛ tɔgɛ kyu naa de mɔ so mɔ gɛsɛ sa mɔmɔ. O yii gɛsɛ lii Mosisi iwolɛ mɔ dɔ kyu kpaa lii Wurubuaarɛ ikalan atɔgɛbo asɛnsɛ mɔ pɛwu-lɛɛ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mɛ fo ɔsowolɛ ɔbono so mɛ kya kpe mɔ, Yesu gi wɔra fɛɛ mɔ berɛ ɔ kya loo ɔ kya lii daa. ");
INSERT INTO acd_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Mɛ wu gɛnen mɔ, mɛ keda mɔ yela yɛɛ, “Owi gi ta. I laa bun fo ɔkpa dɔ. Naa dɛ aye asɛ gɛrɛ.” Mɛ tɔgɛ mɔ gɛnen mɔ, o nu mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","I fo owi gyisɛ mɔ, o puru bodobodo ne ɔ faala Wurubuaarɛ ne ɔ gbaa-gbaa bodobodo mɔ dɔ ne o kyu sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Nfono mɔ, mɔmɔ-ansi a bugi ne mɛ bii mɔ kon. Ayaa abono so mɔ, mɛŋ baa wu mɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Mɛ san mɛ kya tɔgɛ ma‑a sa abara yɛɛ, “Nkyɛɛ imɔso ne ɔ kya lɛɛ Wurubuaarɛ agyɛbi mɔ gɛsɛ ɔ kya sa aye ɔkpa dɔ ne i keda aye-nyoro ne i wɔra aye-asen dɔ ɔkon mɔ.” ");
INSERT INTO acd_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mɛŋ baa wu Yesu gɛnen mɔ, mɛ nyise koso ayaa abono so kii kpe Gyɛrusalem nfono Yesu isɔɔ mɔ mɛ bo mɔ. Mɛ loo nno mɔ, mɛ wu Yesu isɔɔ gudu ɔko mɔ mɔmɔ‑rɛ Yesu akasɛbo ako mɛ koola mɛ tɛ, ");
INSERT INTO acd_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ne mɛ nu mɛ kya tɔgɛ ma‑a sa abara yɛɛ, “Aye-wura mɔ gi kyingi lii ibuni dɔ gɛsintin. Ɔ lɛɛ mɔ-nyoro nyiile Simon.” ");
INSERT INTO acd_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Nfono mɔ, anyen anyɔ mɔ kee mɛ lɛɛ mɔmɔ-lɛɛ ibono mɛ wu mɔ tɔgɛ sa mɔmɔ. Mɛ tɔgɛ ibono i ba ɔkpa dɔ mɔ de gɛnɔɔbono mɔmɔ-wura mɔ gi gbaa gbaa bodobodo dɔ kyu sa mɔmɔ ne mɛ lɔɔ bii mɔ mɔ kee sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Anyɔ mɔ mɛ san mɛ kya tɔgɛ imɔ mɔ, mɛ baa kerɛ mɔ, Wura Yesu gbaa-gbaa ne n yelɛ mɔmɔ dɔ. Ne ɔ faala ɔmɔ yɛɛ, “Wurubuaarɛ gisen yuuli giꞌ wɔra fɛye-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Mɛ wu Yesu gɛnen mɔ, i ŋmaa mɔmɔ-gisen ne i wɔra mɔmɔ gifuu. Mɛ nyi yɛɛ obuni. ");
INSERT INTO acd_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Nfono mɔ Yesu gi taasɛ mɔmɔ yɛɛ, “Menɛ n wɔra ne i bo fɛye-nwɔnsa dɔ kpada-kpada? Menɛ n wɔra ne fɛ bo akyɔɔlɛ gɛnen? ");
INSERT INTO acd_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Fɛꞌ kerɛ me-abaa, de fɛꞌ kerɛ me-ayaa. Me gbaa-gbaa ne. Meŋ gyɛ obuni. Fɛꞌ tabo me de fɛꞌ kerɛ. Obuni mɛŋ bo awuye de nyoro inun fɛɛ me-lɛɛ idɛ.”  ");
INSERT INTO acd_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ɔ tɔgɛ imɔ idɛ mɔ, o kyu mɔ-abaa de mɔ-ayaa kyu nyiile mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Imɔ gɛnen gbaa mɔ, gɛnɔɔbono i wɔra mɔmɔ ɔkon kyɔde so mɔ, i dɛ mɔmɔ fɛɛ i gyɛ daa abon ne i dɛ mɔmɔ-gɛnɔ. Imɔso Yesu gi taasɛ mɔmɔ yɛɛ, “Fɛ bo ilaa gyisɛ iko gɛrɛ?” ");
INSERT INTO acd_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Ɔ taasɛ gɛnen mɔ, mɛ sa mɔ ɔken. ");
INSERT INTO acd_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ɔ sɔɔ ɔken mɔ ne ɔ wɛ, mɔmɔ pɛwu ansi dɔ nfono. ");
INSERT INTO acd_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nfono ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Ilaa ibonoana fɛ wu i ba me so faa, owi ɔbono n bo fɛye asɛ mɔ, nɛ wolaa tɔgɛ sa fɛye yɛɛ i laa ba gɛsintin fɛɛ gɛnɔɔbono mɛ wolaa ŋmarasɛ yela mɔ. Ilaa ibono i bo Mosisi nbara mɔ dɔ mɔ de ibono Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ yɛgɛ mɛ ŋmarasɛ yela mɔ de ibono i bo Wurubuaarɛ Ilon Ɔwolɛ mɔ dɔ kyu lii me so mɔ pɛwu i kaaborɛ iꞌ ba gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nfono mɔ ɔ yɛgɛ mɛ nyɛ nu Wurubuaarɛ agyɛbi mɔ gɛsɛ, ");
INSERT INTO acd_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ i dɛ sa ɔbono Wurubuaarɛ laa sun de ɔꞌ mɔlɛgɛ mɔ-adɛ mɔ yɛɛ oꞌ wu ɔlaawusɛ lɛwu de imɔ gɛkɛ sasɛ mɔ oꞌ kyingi lii ibuni dɔ. ");
INSERT INTO acd_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Mɛ kii ŋmarasɛ yɛɛ asa mɛ laa naa kaasɛ mɔ ginyen dɔ mɛ kya tɔgɛ ɔkamaasɛ yɛɛ ɔꞌ kyɛɛgɛ lii mɔ-ilaa nyɛnyɛn giwɔra dɔ de Wurubuaarɛ oꞌ kyu mɔ-ilaa nyɛnyɛn kyɛɛ mɔ. Mɛ laa tɔgɛ ilaa idɛ sa gɛsinkpan so asa kpɛi-kpɛi pɛwu. Mɛ laa yii gɛsɛ lii daa Gyɛrusalem gɛrɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Fɛye ne n gyɛ abono fɛ wu ilaa ibono nɛ wɔra de ilaa ibono i ba me so mɔ pɛwu de fɛye-ansi. Fɛye ne nan tɔgɛ me-ilaa sa asa de mɛꞌ nu. ");
INSERT INTO acd_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Fɛꞌ nu! Nan kyu me-sɛ Wurubuaarɛ ɔlon ɔbono ɔ ka yela sa fɛye mɔ kyu bunge fɛye. Imɔso, fɛꞌ kyena Gyɛrusalem gɛrɛ gyoo gɛnen ɔlon mɔ. Ɔ laa kpelegɛ lii Wurubuaarɛ dɔ baa bun fɛye so.” ");
INSERT INTO acd_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Yesu gi tɔngɛ sa mɔmɔ ta mɔ, ɔ kparɛ mɔmɔ lii ɔsowolɛ mɔ so. Mɛ kpaa fo sindi Bɛtani mɔ, ɔ diirɛ mɔ-abaa mɔmɔ so ne ɔ kolɛ Wurubuaarɛ ayuule bun ɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ɔ san ɔ kya yuule mɔmɔ mɔ, i puru mɔ dii kyon kpe Wurubuaarɛ dɔ taa mɔmɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Mɛ son Yesu nno, ne mɛ kii kpe Gyɛrusalem de ɔkon belɛ. ");
INSERT INTO acd_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Kpɛ kyu lii gɛnen gɛkɛ gɛbono mɔ, mɛ kya kpe Wurubuaarɛ ɔson obu gikpaara mɔ so gɛkɛ kamaasɛ kpaa yen Wurubuaarɛ.");
INSERT INTO acd_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Lii ko‑o gɛsɛ de gɛsɛ mɔ, Wurubuaarɛ Gigyɛbi mɔ gi bo no. Ɔbono ɔ gyɛ gɛnen Gigyɛbi mɔ ti ɔ bo Wurubuaarɛ asɛ, ne Gigyɛbi mɔ kee gi gyɛ Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Gigyɛbi mɔ gi bo Wurubuaarɛ asɛ lii ko‑o gɛsɛ de gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Ilaa kamaasɛ ibono Wurubuaarɛ gi lɛɛ soso de gɛsɛ pɛwu mɔ, ɔ lɛɛ imɔ naa daa de mɔ-Gigyɛbi mɔ so. Sɛi mɛŋ bo no ibono Wurubuaarɛ gi lɛɛ yɛɛ iŋ gyɛ mɔ‑rɛ mɔ-Gigyɛbi mɔ ne n lɛɛ imɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Lii Wurubuaarɛ Gigyɛbi mɔ so ne anyamesɛ mɛ kya nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan ne gɛnen gɛkyena mɔ gɛ gyɛ fatela sa anyamesɛ. ");
INSERT INTO acd_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Fatela mɔ kya wu gibiri dɔ, ne gibiri mɔ gi mɛŋ taalɛ mɔɔ fatela mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Wurubuaarɛ gi sun ɔnyen ɔko mɛ kya terɛ mɔ yɛɛ Gyɔn. ");
INSERT INTO acd_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","O sun mɔ de ɔꞌ baa tɔgɛ ilaa ibono o nyi kyu lii fatela mɔ so mɔ sa asa de ɔkamaasɛ oꞌ kyu mɔ-nyoro too fatela mɔ so kyu lii ilaa ibono gɛnen Gyɔn baarɛ laa buu sa mɔmɔ mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Gyɔn mɛŋ gyɛ fatela mɔ berɛ. Ɔ ba de ɔꞌ baa buu fatela mɔ nyoro so ilaa sa asa daa. ");
INSERT INTO acd_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Fatela mɔ gbaa-gbaa bo no. Mɔ ne n kya kyangɛ sa nyamesɛ kamaasɛ ne i kya wu mɔ mɔ. Gɛnen fatela mɔ ne n kya ba gɛsinkpan so faa. ");
INSERT INTO acd_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ɔ wolaa ɔ bo gɛsinkpan mɔ so ne mɔ ne n lɛɛ gɛsinkpan mɔ, ne gɛsinkpan so anyamesɛ mɛ mɛŋ bii mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Ɔ ba mɔ gbaa-gbaa mɔ-gɛsinkpan so, ne mɔ gbaa-gbaa asa mɛŋ kyule sɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Asa abono mɛ sɔɔ mɔ, ne mɛ kyu mɔmɔ-nyoro too mɔ so mɔ berɛ, Wurubuaarɛ gi sa mɔmɔ ɔkpa de mɛꞌ wɔra mɔ Wurubuaarɛ mɔ-biana gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Gɛnen Wurubuaarɛ mɔ-biana abono, mɔmɔ‑rɛ Wurubuaarɛ gɛsɛ de gibi mɔ gi mɛŋ dɛ fɛɛ ibono anyamesɛ mɛ kya da itɔ korogɛ mɔ. Ne iŋ gyɛ nyamesɛ anɔkyu abɛɛ nyamesɛ ne n wɔra adawo sa gɛwɔnsa kyu korogɛ mɔmɔ. Wurubuaarɛ gbaa-gbaa ne n yɛgɛ ne mɛ wɔra mɔ-biana. ");
INSERT INTO acd_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Gɛnen Wurubuaarɛ Gigyɛbi gibono gi baa wɔra nyamesɛ ne ɔ kyena saarɛ aye dɔ. A wu mɔ-nyisigyi de aye-ansi. Gɛnen nyisigyi ɔbono ɔ bo mɔ kya nyiile yɛɛ mɔ-nkon ne n gyɛ Wurubuaarɛ mɔ-bi ɔbono ɔ lii Wurubuaarɛ asɛ. Ɔ kpɛ ɔ kya sa aye so gɛwɔnsa dɛnsɛ ne ɔ tansi ɔ gyɛ gɛsintin wura. ");
INSERT INTO acd_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Gɛnen Wurubuaarɛ Gigyɛbi gibono ilaa ne Gyɔn gi tɔgɛ mɔ. Gyɔn gi lɛɛ gibaa nyiile mɔ yɛɛ, “Ɔdɛ ilaa ne nɛ naa kyena tɔgɛ yɛɛ, ‘Mɔ ɔbono ɔ laa ba me-gɛmara mɔ gi don me ilaa kamaasɛ dɔ mɔ. I kya nyiile yɛɛ ɔ wolaa ɔ bo no pɛi ne i lɔɔ korogɛ me.’ ” ");
INSERT INTO acd_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Ɔ ta gudu ilaa kamaasɛ dɔ so mɔ, ɔ kya sa aye so gɛwɔnsa dɛnsɛ ne ɔ kya wɔra ilaa ɔ kya sa aye pɛwu ɔ kya kpe ɔ kya ba. ");
INSERT INTO acd_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Dedaa Wurubuaarɛ gi sa anyamesɛ mɔ-ɔson nbara mɔ, o kyu naa daa de Oloobu Mosisi so. Ne Wurubuaarɛ gi san lɛɛ mɔ-gɛwɔnsa dɛnsɛ de mɔ-gɛsintin nyiile anyamesɛ mɔ, o kyu naa daa de Yesu Kirisito so. ");
INSERT INTO acd_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nyamesɛ kamaasɛ mɛŋ ti taa wu Wurubuaarɛ kerɛ. Wurubuaarɛ mɔ-bi kolon ɔbono o nyi Wurubuaarɛ gisen dɔ ilaa mɔ ne n lɛɛ Wurubuaarɛ gidebi nyiile anyamesɛ. ");
INSERT INTO acd_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Fɛꞌ nu ilaa ibono Wurubuaarɛ gi sun Gyɔn yɛɛ ɔꞌ baa tɔgɛ anyamesɛ mɔ. I lii fɛɛ Gyuda awura abelɛnsɛ abono mɛ bo Gyɛrusalem ɔsowolɛ so mɔ, mɛ sun Wurubuaarɛ asunbi alɛɛbo ako de Lɛfi gikpen dɔ asa ako Gyɔn asɛ, ne mɛ kpaa taasɛ mɔ yɛɛ mɔ ne n gyɛ anɛ? ");
INSERT INTO acd_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Mɛ kpaa taasɛ mɔ gɛnen mɔ, ɔ tɔgɛ gɛsintin sa mɔmɔ. Ɔ mɛŋ ŋara ɔmɔ. Ɔ tɔgɛ tigi mɔmɔ yɛɛ, “I mɛŋ gyɛ me ne n gyɛ asa ɔmɔlɛgɛbo ɔbono Wurubuaarɛ yɛɛ ɔ laa sun mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Gyɔn gi tɔgɛ mɔmɔ gɛnen mɔ, mɛ kii taasɛ mɔ yɛɛ, “Ne iŋ gyɛ fo ne n gyɛ kaasɛ ɔbono mɔ, fo ne n gyɛ anɛ? Fo gyɛ Oloobu Ilaagya abɛɛ?” Gyɔn gi lɛɛ gɛnɔ yɛɛ, “Kuaa, meŋ gyɛ Ilaagya.” “Mɔ, fo ne n gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo mɔ?” Ne Gyɔn gi kii lɛɛ gɛnɔ yɛɛ, “Kuaa.” ");
INSERT INTO acd_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Nfono mɔ, isɔɔ mɔ mɛ tɔgɛ mɔ yɛɛ, “Kii tɔgɛ aye isa ɔbono fo gyɛ mɔ. I kaaborɛ aꞌ nyɛ ilaa iko kpaa tɔgɛ abono mɛ sun aye mɔ. Fo gbaa-gbaa asɛ mɔ, fo ne n gyɛ anɛ daa?” ");
INSERT INTO acd_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Gyɔn gi tɔgɛ sa mɔmɔ yɛɛ, “Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono mɛ kya terɛ mɔ yɛɛ Isaya mɔ gi ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ yɛɛ, Mɛ laa nu ɔko gigyɛbi gipen dɔ, ɔ laa kpen ɔ kya tɔgɛ ɔ kya sa mɔmɔ yɛɛ, ‘Fɛꞌ lɔrɔ fɛye-akyenabi de fɛꞌ baala fɛye-nyoro gyoo Wurubuaarɛ.’ Me ne n gyɛ gɛnen kaasɛ ɔbono Isaya darɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Gyuda awura abelɛnsɛ abono mɛ sun isɔɔ mɔ Gyɔn asɛ gɛnen mɔ mɛ gyɛ daa Farasii gikpen dɔ asa. ");
INSERT INTO acd_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Imɔso isɔɔ mɔ mɛ taasɛ Gyɔn yɛɛ, “Fo yɛɛ iŋ gyɛ fo ne n gyɛ ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ aye mɔ, foŋ gyɛ Oloobu Ilaagya, ne foŋ kii fo gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo mɔ, i wonɛ so ne fo kya gyere asa Wurubuaarɛ sagyere?” ");
INSERT INTO acd_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Mɛ taasɛ Gyɔn gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Me berɛ, n dɛ daa nkyu n kya gyere fɛye Wurubuaarɛ sagyere. Ɔko, mɔ, gi ti ba ɔ saarɛ fɛye dɔ gbaa, fɛŋ kii fɛ nyi mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","I bo no yɛɛ n gyɛ mɔ-ɔbelɛnsɛ berɛ. Meŋ kii fo mɔ de sɛi. Fɛɛ nꞌ ba gɛsɛ de nꞌ kyu mɔ-ayaawolɛ kyu tolɛ mɔ-ayaa dɔ sa mɔ gbaa mɔ, meŋ fo.” ");
INSERT INTO acd_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Gɛnen ilaa idɛ pɛwu i ba daa Bɛtani ɔsowolɛ so Gyɔɔdan ɔbon gibenbɛ giko mɔ so owi ɔbono Gyɔn kya gyere asa Wurubuaarɛ sagyere mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Imɔ gɛdɛ kɛsɛ mɔ, Gyɔn gi wu Yesu naa ɔ kya ba de mɔ asɛ, ne ɔ tɔgɛ yɛɛ, “Fɛꞌ kerɛ ɔbono Wurubuaarɛ laa kyu lɛɛ asunbi fɛɛ sandɛ mɔ. Ɔnyen baarɛ lɛwu ne nan kpaarɛ anyamesɛ ilaa nyɛnyɛn fuɛ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Ɔdɛ ilaa ne nɛ naa kyena tɔgɛ yɛɛ, ‘N gyɛ mɔ-ɔbelɛnsɛ berɛ. Meŋ kii fo mɔ de sɛi mɔ. I kya nyiile yɛɛ ɔ wolaa ɔ bo no pɛi ne iꞌ lɔɔ korogɛ me.’ ");
INSERT INTO acd_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Me-gibaa so mɔ, maŋ wu mɔ bii. Mɔ so ne Wurubuaarɛ gi sun me ba gɛsinkpan so de nꞌ gyere asa Wurubuaarɛ sagyere de nꞌ baa lɛɛ mɔ gɛwi nyiile Isirale awura.” ");
INSERT INTO acd_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Gyɔn gi buu Yesu ilaa sa asa mɔ yɛɛ, “Nɛ wu Wurubuaarɛ Oduduu mɔ gi kpelegɛ fɛɛ bonbuɛ lii soso, ne ɔ baa suu de Yesu. ");
INSERT INTO acd_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Gɛnen owi ɔbono pɛwu mɔ, meŋ wolaa bii mɔ. Wurubuaarɛ ɔbono o sun me yɛɛ nꞌ baa gyere asa Wurubuaarɛ sagyere mɔ ne n tɔgɛ sa me yɛɛ, ‘Nyamesɛ ɔbono fo wu Wurubuaarɛ Oduduu mɔ gi kpelegɛ lii soso baa suu de mɔ mɔ, gɛnen kaasɛ ɔbono ne nan kyu Wurubuaarɛ Oduduu kyu gyere asa Wurubuaarɛ sagyere mɔ.’ ");
INSERT INTO acd_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Nɛ wu imɔ de me-ansi. Imɔso ne nꞌ kya buu mi‑i sa fɛye yɛɛ mɔ ne n gyɛ Wurubuaarɛ mɔ-bi mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Imɔ gɛdɛ kɛsɛ kee mɔ, Gyɔn mɔ‑rɛ mɔ-akasɛbo mɔ dɔ anyɔ ako mɛ yelɛ. ");
INSERT INTO acd_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","O wu Yesu naa ɔ kya kyon mɔ, ɔ tɔgɛ yɛɛ, “Fɛꞌ kerɛ. Ɔbono Wurubuaarɛ laa kyu lɛɛ asunbi fɛɛ sandɛ mɔ ne.” ");
INSERT INTO acd_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Gyɔn akasɛbo mɔ mɛ nu ibono ɔ tɔgɛ gɛnen so mɔ, mɛ naa buu Yesu. ");
INSERT INTO acd_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yesu gi kisee kerɛ ne o wu mɔmɔ mɛ buu mɔ gɛnen mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Menɛ ne fɛ kya laarɛ?” Mɛ lɛɛ gɛnɔ yɛɛ, “Rabi! Fonɛ ne fo sogɛ?” (Rabi gɛsɛ ne n gyɛ yɛɛ onyiilebo.) ");
INSERT INTO acd_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Mɛ taasɛ mɔ-ɔlooten gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ baa kpe de fɛꞌ kpaa kerɛ.” Imɔso mɛ naa buu mɔ kpaa fo nfono ɔ bo mɔ. Mɛ kyena mɔ asɛ nno owi ɔbono ɔkara ɔ san gɛnen gɛkɛ mɔ dɔ mɔ pɛwu. Owi ɔbono mɛ naa buu Yesu gɛnen mɔ, i laa wɔra fɛɛ owi gbaasɛ, iwi inan dɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Andiru, Simon Piita mɔ-tedɛ, gyɛ asa anyɔ abono mɛ nu ilaa ibono Gyɔn gi tɔgɛ mɔ ne mɛ naa buu Yesu mɔ dɔ ɔko. ");
INSERT INTO acd_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Andiru gi kpe nno kii ba mɔ, ilaa ibono ɔ daa giwɔra mɔ ne n gyɛ yɛɛ ɔ kpaa laarɛ mɔ-tedɛ Simon gɛten, ne o buu sa mɔ yɛɛ, “A wu Masaya mɔ.” (Masaya gɛsɛ ne n gyɛ yɛɛ ɔbono Wurubuaarɛ gi sun yɛɛ ɔꞌ baa mɔlɛgɛ anyamesɛ de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ.) ");
INSERT INTO acd_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Andiru gi buu sa mɔ-tedɛ Simon gɛnen mɔ, o kyu mɔ kpe Yesu asɛ. Yesu gi kerɛ mɔ, ne ɔ terɛ mɔ-ginyen sa mɔ yɛɛ, “Fo ne n gyɛ Simon, Gyɔn mɔ-bi mɔ. Mɛ laa san terɛ fo-ginyen yɛɛ Sɛfasɛ.” (Sɛfasɛ gɛsɛ ne n gyɛ yɛɛ Piita abɛɛ gifolɛ.) ");
INSERT INTO acd_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Imɔ gɛdɛ kɛsɛ mɔ, Yesu gi sa gɛwɔnsa yɛɛ ɔ laa kpe Galeli gɛsinkpan so. O wu Filipo ne ɔ tɔgɛ sa mɔ yɛɛ, “Baa buu me de foꞌ wɔra me-ɔkasɛbo.” ");
INSERT INTO acd_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Filipo kee gi lii Bɛsayida, ɔsowolɛ ɔbono so Andiru de Piita mɛ lii mɔ. ");
INSERT INTO acd_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Filipo gi wu Natanelɛ ne o buu sa mɔ yɛɛ, “Nyamesɛ ɔbono Mosisi gi wolaa tɔgɛ mɔ-ilaa yela Wurubuaarɛ nbara mɔ dɔ mɔ ne Wurubuaarɛ ikalan atɔgɛbo mɔ kee mɛ kpɛ ma‑a tɔgɛ mɔ-ilaa mɔ, ndɛ berɛ, a wu mɔ de aye-ansi. Mɔ ne n gyɛ Yesu Nasarɛtɛnyen, Gyosɛfo mɔ-bi mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Filipo gi tɔgɛ Yesu ilaa sa mɔ gɛnen mɔ, Natanelɛ gi kisee taasɛ Filipo yɛɛ, “Imɔso nyamesɛ gbaaꞌ ɔko laa taalɛ lii Nasarɛtɛ ɔsowolɛ ɔbono so?” Nfono ne Filipo gi tɔgɛ sa mɔ yɛɛ, “Fo berɛ, baa kerɛ.” ");
INSERT INTO acd_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Yesu gi wu Natanelɛ naa ɔ kya ba mɔ asɛ mɔ, ɔ tɔgɛ yɛɛ, “Fɛꞌ kerɛ, Isiralenyen gbaa-gbaa, ɔŋ kya penɛ asa.” ");
INSERT INTO acd_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Yesu gi tɔgɛ sa Natanelɛ gɛnen mɔ, Natanelɛ gi taasɛ mɔ yɛɛ, “Nnɛ ne fo wɔra ne fo bii me-gidebi?” Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Pɛi de Filipo ɔꞌ lɔɔ terɛ fo lii gifeeya oyii mɔ asɛ mɔ, nɛ ti wolaa wu fo.” ");
INSERT INTO acd_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Yesu gi buu Natanelɛ nyoro so ilaa sa mɔ gɛnen mɔ, Natanelɛ gi tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, fo ne n gyɛ Wurubuaarɛ mɔ-bi mɔ. Fo ne n gyɛ wura sa aye Isirale awura mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Nfono ne Yesu gi taasɛ mɔ yɛɛ, “Ibono nɛ buu sa fo yɛɛ nɛ wolaa wu fo gifeeya oyii mɔ asɛ mɔ so ne n yɛgɛ ne fo sɔɔ me gyi faa? Fo berɛ, yɛgɛ! Fo laa baa wu ilaa gbaaꞌgbaa don idɛ gbaa. ");
INSERT INTO acd_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, fɛ laa wu Wurubuaarɛ dɔ i laa bugi de fɛꞌ wu Wurubuaarɛ dɔ isɔɔ mɛ laa dii mɛ kya kpelegɛ me, anyamesɛ pɛwu mɔmɔ-daa mɔ so.” ");
INSERT INTO acd_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Imɔ nkɛ nsa gɛmara mɔ, mɛ kya kpii ɔkyii Keena ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ. Yesu mɔ-nyi bo nno. ");
INSERT INTO acd_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Mɛ da gibaa terɛ Yesu mɔ‑rɛ mɔ-akasɛbo mɔ kee. Gɛsintin mɔ, mɛ kpe gɛdena mɔ gɛten. ");
INSERT INTO acd_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mɛ tɛ mɛ kya gyi gɛkɛ belɛ mɔ mɔ, mɔmɔ-nta gi ta wɔra ɔmɔ. Ne Yesu mɔ-nyi gi tɔgɛ sa mɔ yɛɛ, “Mɛŋ baa mɛ bo nta.” ");
INSERT INTO acd_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ɔ tɔgɛ gɛnen mɔ, Yesu gi taasɛ mɔ yɛɛ, “Ɔkyii, idɛ i gyɛ me‑rɛ fo ilaa iko? Me-owi mɛŋ ti fo.” ");
INSERT INTO acd_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Nfono ne Yesu mɔ-nyi gi tɔgɛ sa adega abono mɛ kya kerɛ gɛten gɛbono so mɔ yɛɛ, “Ilaa kamaasɛ ibono Yesu laa tɔgɛ fɛye mɔ, fɛꞌ wɔra.” ");
INSERT INTO acd_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Gɛten mɔ dɔ mɔ, nkyu nlɔ nsee nko gi yii nno. Afolɛ ne mɛ kyu wɔra gɛnen nlɔ nbono. Mɛ kya saa nkyu lii nlɔ nbono dɔ kyu foro mɔmɔ-ayaa de abaa mɔmɔ Gyuda awura itiibilaa ɔkpa so de iŋꞌ sa iꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson. Nkyu fɛɛ ankɔrɔn gidin ne nan loo gɛnen nlɔ nbono gɛkamaasɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Yesu gi tɔgɛ sa gɛten mɔ dɔ adega mɔ yɛɛ, “Fɛꞌ saa nkyu wɔra nlɔ ndɛ dɔ.” Ne mɛ saa nkyu wɔra nmɔ dɔ ne gi bɔla yelɛ-yelɛ. ");
INSERT INTO acd_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Nkyu mɔ gi bɔla nlɔ mɔ gɛnen mɔ, ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Idɛ kon, fɛꞌ saa nko kyu kperɛ ɔbelɛnsɛ ɔbono ɔ kya kerɛ gɛkɛ belɛ gɛdɛ so mɔ.” Gɛsintin mɔ, adega mɔ mɛ saa nmɔ nko kperɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ɔ daa kerɛ mɔ, gi gyɛ nta. Ɔ mɛŋ nyi nfono gɛnen nta mɔ gi lii mɔ. (Adega mɔ mɛ saa nkyu mɔ mɔ berɛ mɛ nyi yɛɛ nkyu ne Yesu gi yɛgɛ gi bingiri nta.) Ɔbelɛnsɛ mɔ gi terɛ ɔkyiifɔ mɔ mɔ-kuli mɔ, ");
INSERT INTO acd_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ne ɔ tɔgɛ sa mɔ yɛɛ, “Ɔkamaasɛ ɔbono ɔ kya kpii ɔkyii fafaanan mɔ kya daa gikyu nta dɛnsɛ yɛ pɛi. Nengyene mɛ ti nun ne i fo mɔmɔ mɔ, idɛ kon mɔ de ɔꞌ san loo nta nbono giŋ boran mɔ dɔ. Fo‑o fo mɔ, fo kyu nta dɛnsɛ mɔ daa yela baa fo gɛnen aberɛ adɛ?” ");
INSERT INTO acd_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Yesu gi wɔra gɛnen ilaa lɛɛnyiilesɛ idɛ Keena ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ. I gyɛ ilaa ibono ɔ da giwɔra ne i lɛɛ mɔ-nyisigyi ɔbono ɔ bo mɔ gɛwi nyiile, ne mɔ-akasɛbo mɔ mɛ sɔɔ mɔ gyi yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ɔkyiifɔ mɔ gikpii mɔ i kyon mɔ, imɔ gɛmara mɔ, Yesu mɔ‑rɛ mɔ-nyi, de mɔ-tedɛana de mɔ-akasɛbo mɔ mɛ kyon kpe Kapɛɛniyon ɔsowolɛ so. Ne mɛ kyena nno nkɛ kalɛsɛ nko. ");
INSERT INTO acd_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Gyuda awura mɔ gɛkɛ belɛ gɛbono mɛ kya terɛ yɛɛ Lɛwu gi Seregɛ Aye So mɔ gɛ kya fo mɔ, Yesu gi kpe Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ɔ loo Wurubuaarɛ ɔson obu gikpaara mɔ so mɔ, o wu asa mɛ kya fɛ inaadɛ de isandɛ de abonbuɛ. O wu asa abono mɛ kya boori aterenbi nno mɛ dɛ mɔmɔ-gɛsun dɔ. ");
INSERT INTO acd_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Yesu gi wu gɛnen asa mɔ, o fili ɔfɛ wɔra giwulibi ne o kyu gya asa mɔ pɛwu de isandɛ mɔ de inaadɛ mɔ lii Wurubuaarɛ ɔson obu gikpaara mɔ so. Abono mɛ kya boori aterenbi mɔ ɔ kyɛɛgɛ mɔmɔ-aterenbi abi mɔ fuɛ ne ɔ da mɔmɔ-iteebulu mɔ too-too. ");
INSERT INTO acd_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Ne ɔ tɔgɛ sa asa abono mɛ kya fɛ abonbuɛ mɔ yɛɛ, “Fɛꞌ puru fɛye-abonbuɛ lii gɛrɛ. Fɛŋꞌ sa fɛ kyu me-sɛ, Wurubuaarɛ gɛten dɔ kyu bingiri gigya ogyiten.” ");
INSERT INTO acd_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Ibono Yesu gi gya asa mɔ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ nyingi ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ. Mɛ ŋmarasɛ yela nno yɛɛ, Gɛnɔɔbono me-gɛwɔnsa gɛ gyan fo-ɔson obu mɔ so mɔ, i gyi me-gimu. ");
INSERT INTO acd_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gɛnen ilaa ibono Yesu gi kyu wɔra asa Wurubuaarɛ ɔson obu gikpaara mɔ so mɔ, i yɛgɛ Gyuda awura abelɛnsɛ mɔ mɛ taasɛ mɔ yɛɛ, “Menɛ ne fo laa taalɛ wɔra de iꞌ lɛɛ nyiile aye yɛɛ Wurubuaarɛ ne n sa fo ɔkpa yɛɛ foꞌ wɔra gɛnen ilaa idɛ?” ");
INSERT INTO acd_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Gyuda awura abelɛnsɛ mɔ mɛ taasɛ Yesu gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Nengyene fɛ boori Wurubuaarɛ ɔson obu baarɛ bun mɔ, nan kyu nkɛ nsa kii yii mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Yesu gi tɔgɛ gɛnen mɔ, Gyuda awura abelɛnsɛ mɔ mɛ taasɛ mɔ yɛɛ, “Wurubuaarɛ ɔson obu ɔbono a kyu nsi ikue-inyɔ nsi nsee kyu yii mɔ, ne fo yɛɛ fo laa kyu nkɛ nsa kyu yii mɔ faa?” ");
INSERT INTO acd_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Yesu gi tɔgɛ gɛnen mɔ, mɔ-nyoro ne ɔ darɛ gɛnen. Iŋ gyɛ Wurubuaarɛ ɔson obu mɔ gbaa-gbaa. ");
INSERT INTO acd_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Imɔso, ibono asa mɛ mɔɔ Yesu ne o kii kyingi lii ibuni dɔ mɔ, mɔ-akasɛbo mɔ mɛ nyingi yɛɛ ɔ wolaa tɔgɛ gɛnen ilaa idɛ kyu lii mɔ-nyoro so baa kyon, ne mɛ sɔɔ Wurubuaarɛ agyɛbi mɔ de mɔ Yesu ilaa tɔgɛsɛ mɔ gyi. ");
INSERT INTO acd_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Gyuda awura mɛ kya gyi mɔmɔ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ, Yesu san ɔ bo Gyɛrusalem. Ɔ wɔra ilaa ibono i lɛɛ nyiile yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ, ne asa sakyɔ mɛ sɔɔ mɔ gyi. ");
INSERT INTO acd_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Imɔ‑rɛ imɔ gɛnen gbaa mɔ, Yesu mɛŋ kyu mɔmɔ-gisɔɔgyi mɔ kyu wɔra ilaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","I kya nyiile yɛɛ o nyi ɔkamaasɛ dɔ son lii. Ɔŋ tɛ de ɔko ne ɔꞌ baa buu ɔko nyoro so ilaa sa mɔ. Mɔ gbaa-gbaa gi ti wolaa o nyi ilaa ibono i bo nyamesɛ gisen dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Mɛ kya terɛ ɔnyen ɔko yɛɛ Nikodemusi. Ɔ gyɛ Farasii gikpen mɔ dɔ de Gyuda awura isowolɛ so abelɛnsɛ mɔ dɔ ɔko. ");
INSERT INTO acd_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Gɛnyɛ gɛko mɔ, gɛnen Nikodemusi baarɛ gi ba Yesu asɛ baa tɔgɛ mɔ yɛɛ, “Ɔbelɛnsɛ, a wu yɛɛ fo gyɛ onyiilebo ɔbono Wurubuaarɛ ne n sun fo mɔ. I lii fɛɛ ɔko mɛŋ bo no ɔ laa taalɛ wɔra ilaa lɛɛnyiilesɛ gbaaꞌgbaa ibono ɔnan fo kya wɔra faa, gɛnen mɔ, Wurubuaarɛ ɔlon bo mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Ɔ tɔgɛ gɛnen mɔ, Yesu gi lɛɛ gɛnɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fo faa, iŋ kii lɔrɔ korogɛ nyamesɛ mɔ, ɔ maŋ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Nfono ne Nikodemusi gi taasɛ Yesu yɛɛ, “Nnɛ so ne i laa sa de mɛꞌ kii lɔrɔ korogɛ nyamesɛ aberɛ abono ɔ ti sɛɛ mɔ? Ɔ maŋ taalɛ kii kpaa loo mɔ-nyi ɔtɔ dɔ de mɔ-nyi oꞌ kii lɔrɔ korogɛ mɔ ginyɔsɛ.” ");
INSERT INTO acd_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Yesu gi lɛɛ gɛnɔ yɛɛ, “Foŋ ti nu me gɛsɛ. Gɛsintin ne nꞌ kya tɔgɛ fo faa, nengyene mɛ mɛŋ kyu nkyu de Wurubuaarɛ Oduduu mɔ kii kyu lɔrɔ korogɛ nyamesɛ mɔ, ɔ maŋ nyɛ Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ilaa ibono nyamesɛ gi korogɛ mɔ, nyamesɛ oyuduu ne i gyɛ. Ilaa ibono Wurubuaarɛ Oduduu mɔ gi korogɛ mɔ berɛ, oduduu ne i gyɛ. ");
INSERT INTO acd_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Imɔso nengyene nɛ tɔgɛ sa fo yɛɛ i kaaborɛ iꞌ kii lɔrɔ korogɛ fo mɔ, gɛŋ sa foꞌ yɛgɛ de iꞌ dɛ fo-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","“Afuu a kya da kpe de nfono so a kya laarɛ mɔ daa. Nengyene a kya da gɛnen mɔ, fo nyamesɛ fo laa nu amɔ-ɔlanba daa de fo-aso: fo maŋ wu amɔ de fo-ansi. Fo mɛŋ nyi nfono so a kya lii de mɔ, ne fo mɛŋ nyi nfono so a kya kpe de mɔ. Gɛnen kee ne i dɛ sa nyamesɛ ɔbono i kya kyu Wurubuaarɛ Oduduu lɔrɔ korogɛ mɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Yesu gi tɔgɛ gɛnen mɔ, Nikodemusi gi taasɛ mɔ yɛɛ, “Nnɛ so nnɛ so ne i laa taalɛ ba gɛnen?” ");
INSERT INTO acd_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nfono ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo ɔbono fo gyɛ Wurubuaarɛ nbara onyiilebo sa Isirale awura mɔ ne mɛŋ kya nu gɛnen ilaa idɛ gɛsɛ faa? ");
INSERT INTO acd_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","N kya tɔgɛ fo gɛsintin, ilaa ibono a nyi mɔ, imɔ so ilaa ne a kya tɔgɛ, ne ilaa ibono a wu de ansi mɔ ne a kya buu sa asa. Fɛye mɔ, fɛŋ kya laarɛ fɛꞌ sɔɔ imɔ gyi. ");
INSERT INTO acd_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Gɛsinkpan so ilaa ne nɛ tɔgɛ sa fɛye ne fɛ mɛŋ kya sɔɔ gyi faa, nengyene nɛ tɔgɛ Wurubuaarɛ dɔ ilaa sa fɛye mɔ, nnɛ ne fɛ laa wɔra de fɛꞌ sɔɔ imɔ gyi? ");
INSERT INTO acd_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Nyamesɛ ɔko mɛŋ bo no ɔ ti dii kpe Wurubuaarɛ asɛ, gɛnen mɔ, me, anyamesɛ pɛwu mɔmɔ-daa ɔbono nɛ kpelegɛ lii Wurubuaarɛ dɔ ba mɔ wolɛ. ");
INSERT INTO acd_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Dedaa mɔ Oloobu Mosisi gi puru giwɔɔ de oyii diirɛ soso gipen mɔ dɔ, ne asa mɛ nyɛ nkpa. Gɛnen kee ne i gyɛ ilaa ibono i laa ba yɛɛ asa mɛ laa puru me, anyamesɛ pɛwu mɔmɔ-daa mɔ diirɛ soso, ");
INSERT INTO acd_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","de nyamesɛ kamaasɛ ɔbono o kyu mɔ-nyoro too me so mɔ ɔꞌ nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“Ibono Wurubuaarɛ kya laarɛ aye anyamesɛ ilaa gikyɔ so mɔ, o kyu mɔ-bi kolon sa aye yɛɛ ɔbono o kyu mɔ-nyoro too mɔ-bi mɔ so mɔ ɔꞌ nyɛ kyena mɔ asɛ gɛkpaa-gɛkpaa. Ɔ mɛŋ sa ɔꞌ fuɛ mɔ-lɛwu gɛmara. ");
INSERT INTO acd_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Wurubuaarɛ mɛŋ sun mɔ-bi mɔ ba gɛsinkpan so yɛɛ ɔꞌ baa bun asa gipuɛɛ. O sun mɔ daa yɛɛ ɔꞌ baa mɔlɛgɛ mɔmɔ de mɔmɔ‑rɛ mɔ nsana iꞌ lɔrɔ kyu naa de mɔ-bi mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","“Fo nyamesɛ ɔbono fo kyu fo-nyoro too mɔ so mɔ, Wurubuaarɛ maŋ bun fo gipuɛɛ. Fo ɔbono fo mɛŋ kyu fo-nyoro too mɔ so mɔ berɛ, Wurubuaarɛ gi ti wolaa bun fo gipuɛɛ. I kya nyiile yɛɛ foŋ kyu fo-nyoro too Wurubuaarɛ mɔ-bi kolon mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Ilaa ibono so Wurubuaarɛ laa kyu bun anyamesɛ gipuɛɛ mɔ ne n gyɛ yɛɛ ɔbono ɔ gyɛ fatela mɔ gi lii Wurubuaarɛ dɔ ba anyamesɛ dɔ mɔ, mɛ laarɛ gibiri mɔ ilaa daa taa fatela mɔ yɛgɛ. I lii fɛɛ mɔmɔ-ilaa wɔrasɛ iŋ boran. ");
INSERT INTO acd_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Imɔ gɛsɛ ne n gyɛ yɛɛ nyamesɛ kamaasɛ ɔbono ɔ kya wɔra ilaa nyɛnyɛn mɔ kya kyo fatela, ɔŋ kya tu sindi mɔ. Iŋ gyɛ gɛnen mɔ, mɔ-ilaa nyɛnyɛn ibono ɔ kya wɔra mɔ i laa naa lii gɛwi. ");
INSERT INTO acd_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Nyamesɛ ɔbono ɔ kya gyi gɛsintin mɔ berɛ, kya kyu mɔ-nyoro ba fatela asɛ de asa mɛꞌ wu mɔ-ilaa wɔrasɛ de mɔmɔ-ansi yɛɛ ilaa ibono ɔ wɔra mɔ, ɔ wɔra imɔ naa daa de Wurubuaarɛ so.” ");
INSERT INTO acd_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Imɔ gɛmara mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kyon kpe Gyudiya gɛsinkpan so ne mɛ kyena nno nkɛ kalɛsɛ nko, ne ɔ gyere asa Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Gɛnen owi ɔbono dɔ mɔ, Gyɔn kee kya gyere asa Wurubuaarɛ sagyere Ayinon ɔsowolɛ ɔbono o sindi Salim mɔ so. I kya nyiile yɛɛ nkyu gi nyaakyɔ nno. Asa mɛ kya kpe Gyɔn asɛ nno ne ɔ kya gyere mɔmɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","(Gɛnen owi ɔbono mɔ, mɛ mɛŋ ti taa keda Gyɔn tii de obu.) ");
INSERT INTO acd_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Gyɔn-lɛɛ akasɛbo mɔ de Gyuda awura mɔ dɔ ɔko mɛ nyɛ biidɛ kyu lii gɛnɔɔbono mɔmɔ Gyuda awura mɛ kya wɔra de iŋ sa iꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson mɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mɛ biidɛ ta mɔ, mɛ naa kpe Gyɔn asɛ ne mɛ kpaa taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, ɔnyen ɔbono ɔ baa tu aye Gyɔɔdan ɔbon gibenbɛ ne fo lɛɛ mɔ nyiile aye mɔ gi ba ɔ bo faanaa ɔ kya gyere asa Wurubuaarɛ sagyere. Kerɛ asa mɔ pɛwu mɛ san ma‑a kpe daa mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Gyɔn gi lɛɛ gɛnɔ sa ɔmɔ yɛɛ, “Ilaa ibono Wurubuaarɛ gi kyu sa ɔko lii Wurubuaarɛ dɔ mɔ wolɛ guan‑n ne nan taalɛ wɔra mɔ-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Fɛye gbaa-gbaa fɛ nu lii me-gɛnɔ dɔ yɛɛ i mɛŋ gyɛ me ne n gyɛ ɔbono Wurubuaarɛ gi sun de nꞌ baa mɔlɛgɛ anyamesɛ mɔ. Me berɛ, n gyɛ daa ɔbono Wurubuaarɛ gi sun yɛɛ nꞌ baa lɔrɔ ɔkpa sa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","“Ɔkyiifɔ mɔ-kuli ne n bo mɔ-ka. Pɛi de ɔnyen ɔꞌ nyɛ ɔkyii mɔ, ɔ kya nyɛ okpowura. Mɛ dena ne ɔnyen mɔ kya tɔgɛ gɛdena mɔ so ilaa mɔ, i kya wɔra okpowura mɔ ɔkon gikyɔ kyɔde. Imɔso me nꞌ dɛ daa fɛɛ okpowura. Yesu ne n bo mɔ-adɛ. Nɛ nyɛ wu yɛɛ asa mɛ san mɛ kya kpe daa mɔ asɛ faa mɔ, idɛ kon ne i wɔra me ɔkon kpaa logɛ ne. ");
INSERT INTO acd_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Imɔso mɔ-lɛɛ nyisigyi ɔꞌ kpɛ ɔ kya ŋan ɔ kya too de me-lɛɛ mɔ, ɔꞌ kɔɔgɛ.” ");
INSERT INTO acd_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“Nyamesɛ ɔbono ɔ lii Wurubuaarɛ asɛ ba mɔ gi don nyamesɛ kamaasɛ. Ɔbono ɔ lii gɛsinkpan so mɔ ɔ gyɛ daa gɛsinkpan so isa. Ne ilaa ibono ɔ kya tɔngɛ mɔ, ɔ kya tɔngɛ naa daa de gɛsinkpan so ilaa. Ɔbono ɔ lii Wurubuaarɛ dɔ mɔ gi don nyamesɛ kamaasɛ. ");
INSERT INTO acd_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Ilaa ibono o wu de mɔ-ansi mɔ de ibono o nu de mɔ-aso mɔ ne ɔ kya tɔgɛ. Ɔko‑rɛ ɔko mɛŋ kii ɔ laarɛ oꞌ nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Nyamesɛ ɔbono ɔ kya nu mɔ asɛ mɔ berɛ, kaasɛ mɔ gi kyule ne ɔ nyise gibaa yɛɛ Wurubuaarɛ gyɛ gɛsintin wura. ");
INSERT INTO acd_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","I kya nyiile yɛɛ ɔbono Wurubuaarɛ gi sun lii Wurubuaarɛ dɔ mɔ, Wurubuaarɛ agyɛbi ne n kya lii mɔ-gɛnɔ dɔ. Wurubuaarɛ gi yɛgɛ mɔ-Oduduu mɔ pɛwu giꞌ suu de mɔ. Ɔŋ sa mɔ-Oduduu mɔ san. ");
INSERT INTO acd_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Wurubuaarɛ kya laarɛ mɔ-bi mɔ ilaa ne o kyu ilaa kamaasɛ wɔra mɔ-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Nyamesɛ kamaasɛ ɔbono o kyu mɔ-nyoro kyu too Wurubuaarɛ mɔ-bi mɔ so mɔ laa nyɛ ɔkyenaten Wurubuaarɛ asɛ gɛkpaa-gɛkpaa. Ne ɔbono mɔ ɔ mɛŋ kya nu Wurubuaarɛ mɔ-bi mɔ gɛdɛ mɔ, maŋ nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan kpa‑a. Wurubuaarɛ ginyadon ne nan sii de mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Farasii awura mɔ mɛ nu yɛɛ Yesu kya nyɛ asa don Gyɔn. Mɛ nu yɛɛ asa sakyɔ mɛ buu Yesu ne ɔ kya gyere ɔmɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","(Gɛsintin berɛ mɔ, Yesu gbaa-gbaa mɛŋ gyere asa Wurubuaarɛ sagyere. Mɔ-akasɛbo mɔ ne n gyere mɔmɔ.) ");
INSERT INTO acd_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Wura Yesu gi nu ilaa ibono Farasii awura mɔ mɛ kya tɔgɛ kyu lii mɔ so gɛnen mɔ, ɔ koso lii Gyudiya gɛsinkpan mɔ so kyon kpe Galeli. ");
INSERT INTO acd_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ɔ laa kpe Galeli mɔ, i kaaborɛ ɔꞌ naa daa de Samariya gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Imɔso ɔ kya kpe mɔ, ɔ kpaa fo Samariya awura ɔsowolɛ ɔko so, mɛ kya terɛ mɔ yɛɛ Sayikaa. Sayikaa ɔsowolɛ baarɛ sindi gɛsinkpan gɛbono aye Gyuda awura naana Gyeekɔpo gi kyu sa mɔ-bi Gyosɛfo mɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Gyeekɔpo lɔkɔ bo gɛnen gɛsinkpan gɛbono so. Yesu gi kpaa fo nno mɔ, i tagerɛ mɔ, ne ɔ kpaa kyena lɔkɔ mɔ asɛ. Gɛnen owi ɔbono mɔ, i gyɛ owi kenken gerɛ-gerɛ fɛɛ iwi gudu inyɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Yesu tɛ lɔkɔ mɔ asɛ ɔ kya kyoola mɔ, Samariyakyii ɔko gi ba de ɔꞌ baa saa nkyu. Nfono ne Yesu gi kolɛ ɔkyii mɔ yɛɛ, “Sa me nkyu de nꞌ nun.” ");
INSERT INTO acd_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","(Ɔkyii mɔ gi ba ne Yesu gi kolɛ mɔ nkyu mɔ gɛnen mɔ, Yesu akasɛbo mɔ mɛ kyon nten dɔ mɛꞌ kpaa sɔɔ agyudɔ.) ");
INSERT INTO acd_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Yesu gi kolɛ Samariyakyii mɔ nkyu mɔ gɛnen mɔ, ɔkyii mɔ gi taasɛ mɔ yɛɛ, “Nnɛ so ne fo Gyudanyen fo kya kolɛ me, Samariyakyii nkyu de foꞌ nun?” (Ɔkyii mɔ mɛŋ taasɛ Yesu gɛnen giyan. Gyuda awura mɔmɔ‑rɛ Samariya awura mɛ mɛŋ kya yii abara ilaa.) ");
INSERT INTO acd_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ɔkyii mɔ gi taasɛ mɔ gɛnen mɔ, Yesu gi lɛɛ gɛnɔ yɛɛ, “Nengyene fɛɛ fo nyi gidɛnsɛ gibono Wurubuaarɛ kya laarɛ ɔꞌ wɔra sa fo de nyamesɛ ɔbono ɔnan n gyɛ ne nɛ kolɛ fo yɛɛ foꞌ sa me nkyu de nꞌ nun faa mɔ, nkana fo gbaa ne nan kolɛ me nkyu. Gɛnen nkyu nbono mɔ gi laa kpɛ gi kya kyon gi kya sa fo Wurubuaarɛ asɛ gɛkyena ɔnan.” ");
INSERT INTO acd_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Nfono mɔ, ɔkyii mɔ gi taasɛ Yesu yɛɛ, “Ɔbelɛnsɛ, fo mɛŋ dɛ ilaa ibono fo laa kyu saa nkyu mɔ. Lɔkɔ baarɛ bo kin. Fonɛ dɔ ne fo laa nyɛ gɛnen nkyu nbono gi laa kpɛ gi kya kyon mɔ sa isa? ");
INSERT INTO acd_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Fo ne n don aye-naana Gyeekɔpo ɔbono o kyu lɔkɔ mɔ sa aye mɔ abɛɛ? Gyeekɔpo gbaa-gbaa de mɔ-biana de mɔ-nbuɛ kee mɛ nun lɔkɔ baarɛ nkyu.” ");
INSERT INTO acd_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yesu gi lɛɛ gɛnɔ yɛɛ, “Ɔkamaasɛ ɔbono o nun lɔkɔ baarɛ nkyu mɔ, bolefɔ laa kii mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ɔbono, mɔ, ɔ laa nun me-lɛɛ nkyu nbono nan sa mɔ mɔ berɛ, bolefɔ maŋ baa mɔɔ mɔ gɛkaako kpa‑a. I laa sa mɔ Wurubuaarɛ asɛ gɛkyena ɔnan fɛɛ ɔbon ɔbono mɔ-gɛmu gɛŋ kya ŋaa mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Nfono mɔ, ɔkyii mɔ gi kolɛ Yesu yɛɛ, “Ɔbelɛnsɛ, sa me gɛnen nkyu nbono fo darɛ faa de bolefɔ ɔ mɛŋ baa mɔɔ me, de meŋ baa ba gɛrɛ baa saa nkyu.” ");
INSERT INTO acd_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Yesu gi kii tɔgɛ sa mɔ yɛɛ, “Naa kpe gɛwi de foꞌ kpaa terɛ fo-kuli de fɛꞌ ba.” ");
INSERT INTO acd_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Nfono mɔ ɔkyii mɔ gi lɛɛ gɛnɔ yɛɛ, “Meŋ bo ɔnyen.” Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Fo bo gɛsintin fɛɛ ibono fo tɔgɛ yɛɛ foŋ bo ɔnyen faa. ");
INSERT INTO acd_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Fo ti dena anyen anun ne ɔbono fo‑rɛ mɔ fɛ bo no nperɛ faa kee mɛŋ gyɛ fo-kuli. Gɛnen so mɔ fo tɔgɛ yɛɛ foŋ bo ɔnyen faa mɔ, fo tɔgɛ gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Yesu gi tɔgɛ gɛnen mɔ, ɔkyii mɔ gi tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, n kya wu fo faa, fo gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo. ");
INSERT INTO acd_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Aye-naanaana Samariya awura mɛ baa son Wurubuaarɛ daa gibii gidɛ so. Ne fɛye Gyuda awura, mɔ, fɛ kya tɔgɛ yɛɛ Gyɛrusalem ɔsowolɛ so ne i kaaborɛ asa mɛꞌ kpaa son Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yesu gi tɔgɛ sa mɔ yɛɛ, “Ɔkyii, gɛsintin ne n kya tɔgɛ fo faa, owi mɔ kya fo ibono Wurubuaarɛ gison giŋ baa tiri yɛɛ gibii gidɛ so abɛɛ Gyɛrusalem ɔsowolɛ mɔ so ne mɛ laa son Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Fɛye Samariya awura fɛ kya wu daa ɔson fɛ kya son giyan. Fɛ mɛŋ nyi ilaa ibono fɛ kya son mɔ. Aye Gyuda awura berɛ, a nyi ɔbono a kya son mɔ. Gɛnɔɔbono asa mɛ laa nyɛ Wurubuaarɛ amɔlɛgɛ de mɔmɔ‑rɛ mɔ mɛꞌ kyena mɔ i laa lii daa aye Gyuda awura asɛ. ");
INSERT INTO acd_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","“Owi ɔko kya ba, owi mɔ gi ti fo gbaa ibono aye-sɛ Wurubuaarɛ asonbo mɛ laa kyu gɛsintin son mɔ oduduu dɔ. Gɛnen asonbo abono ɔnan ne n gyɛ asonbo gbaa-gbaa abono aye-sɛ Wurubuaarɛ kya laarɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Wurubuaarɛ gyɛ daa Oduduu. Abono mɛ laa son mɔ mɔ, i kaaborɛ mɛꞌ kyu gɛsintin son mɔ oduduu dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Nfono mɔ, ɔkyii mɔ yɛɛ, “N nyi ibono Masaya mɔ kya ba, mɔ ne n gyɛ ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ. Nengyene ɔ ba mɔ, ɔ laa lɛɛ ilaa kamaasɛ gɛsɛ sa aye.” ");
INSERT INTO acd_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yesu gi buu sa mɔ yɛɛ, “Me ɔbono n kya tɔngɛ de fo faa, me ne n gyɛ Masaya ɔbono fo-gɛwɔnsa gɛ gyan mɔ so mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Yesu mɔ‑rɛ Samariyakyii mɔ mɛ yelɛ mɛ kya tɔngɛ gɛnen mɔ, Yesu akasɛbo mɔ mɛ baa tu mɔmɔ. Mɛ baa wu mɔmɔ gɛnen mɔ, i dɛ ɔmɔ-gɛnɔ yɛɛ Yesu mɔ‑rɛ ɔkyii mɔ mɛ kya tɔngɛ. Mɔmɔ dɔ ɔko‑rɛ ɔko mɛŋ kii taalɛ taasɛ mɔ yɛɛ, “Menɛ ne fo kya laarɛ lii ɔkyii mɔ asɛ?” abɛɛ “Menɛ n wɔra ne fo kya tɔngɛ de ɔkyii mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Nfono mɔ ɔkyii mɔ gi taa mɔ-nkyu gɛlɔbi mɔ yɛgɛ ne ɔ selɛ kpe ɔsowolɛ mɔ dɔ kpaa tɔgɛ sa asa yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Fɛꞌ baa kpe fɛꞌ kpaa kerɛ ɔnyen ɔko! O buu ilaa kamaasɛ ibono nɛ wɔra me-gɛkyena dɔ mɔ pɛwu sa me. Abɛ‑ɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ fɛɛ?” ");
INSERT INTO acd_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ɔkyii mɔ gi kpaa buu sa asa gɛnen mɔ, mɛ koso lii ɔsowolɛ mɔ so mɛ kya kpe Yesu asɛ. ");
INSERT INTO acd_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ɔkyii mɔ gi kyon nten dɔ ɔꞌ kpaa terɛ asa mɔ, Yesu akasɛbo mɔ mɛ kyu agyudɔ mɔ mɛ kpaa sɔɔ mɔ sa mɔ, ne mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, wɔra aniya, sɔɔ agyudɔ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “N bo agyudɔ abono n kya gyi ne fɛ mɛŋ nyi amɔ so sɛi.” ");
INSERT INTO acd_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mɔ-akasɛbo mɔ mɛ san mɛ kya taasɛ abara yɛɛ, “Abɛɛ ɔko gi ti kyu agyudɔ bara mɔ daa?” ");
INSERT INTO acd_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Nfono mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Me-ilaa gyisɛ ne n gyɛ yɛɛ nꞌ wɔra ɔbono o sun me ba gɛsinkpan so mɔ gɛlaarɛ de nꞌ wɔra mɔ-gɛsun mɔ kpaa logɛ. ");
INSERT INTO acd_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Fɛye fɛ laa tɔgɛ yɛɛ, ‘I san daa ibosɛ inan de ɔmɔlɔgɔ akɛbiberɛ aꞌ fo.’ Mi‑i me mɔ, n kya tɔgɛ mi‑i sa fɛye yɛɛ fɛꞌ laa ansi de fɛꞌ kerɛ asa abono i tiri yɛɛ mɛꞌ nu Wurubuaarɛ agyɛbi mɔ. Mɛ dɛ fɛɛ ɔmɔlɔgɔ ne n pɛɛrɛ de gikɛbi. ");
INSERT INTO acd_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Abono mɛ kya kpaa asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ mɛ dɛ fɛɛ adɔɔbo abono mɛ kya koola agyudɔ kyu kpaa gyanꞌ agbaran so mɔ. Gɛnen Wurubuaarɛ gɛsun awɔrabo abono mɛ ti loo gɛsun mɔ dɔ mɛ kya wɔra. Mɛ ti mɛ kya nyɛ mɔmɔ-ntɛɛla ne. I kya ba gɛnen de aduubo mɔ de akoolabo mɔ mɛꞌ nyɛ gyi ɔkon kolon dabɔlɛ. ");
INSERT INTO acd_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Ilaa ibono adedaabo mɛ tɔgɛ mɔ i gyɛ gɛsintin yɛɛ, ‘Ɔko kya duu de ɔko, mɔ, ɔꞌ kɛbi de ɔꞌ koola.’ ");
INSERT INTO acd_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Imɔ gɛsɛ ne n gyɛ yɛɛ nɛ sun fɛye ne i wɔra fɛɛ fɛ kpaa koola agyudɔ abono i mɛŋ gyɛ fɛye ne n nyaadɛ gisisiri duu amɔ. Asa ako kpɛi ne n nyaadɛ mɔmɔ-gisisiri kyu duu amɔ, ne fɛye mɔ, fɛ baa kyu gɛnen gɛsun mɔ fɛ kya wɔra faa.” ");
INSERT INTO acd_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Gɛnen Samariya awura ɔsowolɛ mɔ so asa sakyɔ mɛ sɔɔ Yesu gyi kyu lii ilaa ibono ɔkyii mɔ gi buu sa mɔmɔ mɔ so. Ɔkyii mɔ gi buu sa mɔmɔ yɛɛ, “Ɔ tɔgɛ me-nyoro so ilaa kamaasɛ ibono nɛ wɔra mɔ sa me.” ");
INSERT INTO acd_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Asa mɔ mɛ lii ɔsowolɛ mɔ so ba Yesu asɛ gɛnen mɔ, mɛ kolɛ mɔ yɛɛ ɔꞌ kyena mɔmɔ asɛ. Imɔso ɔ kyena nno nkɛ nnyɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Kyu lii Yesu ilaa nyiilesɛ so mɔ, asa sakyɔ mɛꞌ kii sɔɔ mɔ gyi too. ");
INSERT INTO acd_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Asa mɔ mɛ tɔgɛ sa ɔkyii mɔ yɛɛ, “I mɛŋ baa i gyɛ mɔ-ilaa ibono fo tɔgɛ aye mɔ so ne a kya sɔɔ mɔ gyi. Aye gbaa-gbaa a nu de aye-aso, ne a nyi yɛɛ i mɛŋ bo sɛi, ɔnyen baarɛ gyɛ ɔbono ɔ laa mɔlɛgɛ anyamesɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Yesu gi kyena Samariya awura asɛ nkɛ nnyɔ mɔ, ɔ koso lii nno, ne ɔ kyon kpe Galeli gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Yesu gbaa-gbaa gi wolaa tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔko mɛŋ bo no ɔ kya gyi ginsi mɔ-gɛwi. ");
INSERT INTO acd_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Yesu gi loo Galeli gɛsinkpan so gɛnen mɔ, Galeli awura mɔ mɛ sɔɔ mɔ abaa anyɔ. I kya nyiile yɛɛ mɔmɔ kee mɛ kpe kpaa gyi mɔmɔ-gɛkɛ belɛ mɔ Gyɛrusalem ɔsowolɛ so mɔ, mɛ wu ilaa ibono Yesu gi wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Yesu naa de Galeli gɛsinkpan so mɔ, o kii kpe Keena ɔsowolɛ so. Nno ne ɔ yɛgɛ nkyu gi bingiri nta mɔ. Ɔ bo nno gɛnen mɔ, ɔbelɛnsɛ ɔko bo Kapɛɛniyon ɔsowolɛ so, mɔ-bi nyensɛ kya lɔ. ");
INSERT INTO acd_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Ɔbelɛnsɛ mɔ gi nu yɛɛ Yesu gi lii Gyudiya gɛsinkpan so ba Galeli gɛsinkpan so mɔ, ɔ kpaa kolɛ Yesu yɛɛ ɔꞌ baa kyɛ mɔ-bi mɔ sa mɔ. Ɔ kya laarɛ de oꞌ wu. ");
INSERT INTO acd_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ɔ kolɛ mɔ gɛnen mɔ, Yesu gi tɔgɛ mɔ yɛɛ, “Imɔso fɛye ɔko‑rɛ ɔko maŋ sɔɔ gyi yɛɛ Wurubuaarɛ ne n sun me, gɛnen mɔ, fɛ wu amunale ilaa de ilaa ibono i kya dɛ gɛnɔ mɔ de fɛye-ansi?” ");
INSERT INTO acd_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Ɔbelɛnsɛ mɔ gi kolɛ Yesu yɛɛ, “Ɔbelɛnsɛ, yɛgɛ de aꞌ kpe gɛbii mɔ asɛ pɛi de gɛꞌ lɔɔ lɛɛ ɔŋɛ.” ");
INSERT INTO acd_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nfono mɔ Yesu gi tɔgɛ sa ɔbelɛnsɛ mɔ yɛɛ, “Kii kpe gɛwi. Nɛ yɛgɛ fo-bi mɔ gi nyɛ nkpa.” Ɔbelɛnsɛ mɔ gi sɔɔ Yesu ilaa tɔgɛsɛ mɔ gyi. Imɔso o kii kyon gɛwi. ");
INSERT INTO acd_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ɔ kya kpe gɛwi mɔ, mɔ‑rɛ mɔ-adega mɔ ako mɛ gyan ɔkpa dɔ ne mɛ tɔgɛ sa mɔ yɛɛ mɔ-bi mɔ gi nyɛ alanfiya. ");
INSERT INTO acd_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ɔbelɛnsɛ mɔ gi nu gɛnen mɔ, ɔ taasɛ mɔ-adega mɔ, “Owi ɔmɔ dɔ ne gilɔ mɔ gi ta?” Ne mɛ buu sa mɔ yɛɛ, “Deeri owi gi kpɛɛlɛ mɔ ne ɔkyagyii mɔ gi taa gɛmɔ yɛgɛ.” ");
INSERT INTO acd_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nfono mɔ, ɔ bii yɛɛ gɛnen owi ɔbono gbaa-gbaa ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Kii; nɛ yɛgɛ fo-bi mɔ gi nyɛ nkpa” mɔ. Imɔso mɔ‑rɛ mɔ-gɛten dɔ asa pɛwu mɛ sɔɔ Yesu gyi. ");
INSERT INTO acd_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Yesu gi lii Gyudiya gɛsinkpan so ba Galeli mɔ, gɛnen ilaa idɛ ne n gyɛ ilaa lɛɛnyiilesɛ nyɔsɛ ibono ɔ wɔra ne i lɛɛ nyiile asa yɛɛ Wurubuaarɛ ne n sun mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Imɔ idɛ gɛmara mɔ, mɔmɔ Gyuda awura gɛkɛ belɛ gɛko gɛ baa gyanꞌ. Ne Yesu gi kpe Gyɛrusalem mɔmɔ ɔsowolɛ gɛmu mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Gibun giko gi bo Gyɛrusalem ɔsowolɛ mɔ so. De Gyuda awura gɛdɛ dɔ mɔ, mɛ kya terɛ gibun gibono yɛɛ Bɛtesata. Gibun mɔ gi sindi ɔsowolɛ mɔ gɛkpen gɛbunono gɛbono mɛ kya terɛ gɛmɔ yɛɛ Isandɛ Gɛbunono mɔ. Mɛ yii ipanpan inun kyaabɔɔ gibun mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Mɛ kya kyu alɔbo sakyɔ abono mɛ mɛŋ kya taalɛ wɔra sɛi, fɛɛ agyaatanbo, ɔtɛgɛsɛana, de abono mɔmɔ-nyoro abaafon a wuꞌ mɔ kyu kpaa yela gɛnen ipanpan mɔ dɔ de mɛꞌ gyoo owi ɔbono nkyu mɔ gi laa luburu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","I kya nyiile yɛɛ Wurubuaarɛ dɔ ɔsɔɔ kya kyena kpelegɛ lii Wurubuaarɛ dɔ baa luburu nkyu mɔ. Owi ɔbono nkyu mɔ gi kya luburu gɛnen mɔ, ɔlɔbo ɔbono ɔ daa ginyɛ loo nkyu mɔ dɔ mɔ, mɔ-gilɔ mɔ gi kya ta. ");
INSERT INTO acd_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Ɔnyen ɔko bo gɛnen alɔbo adɛ dɔ ɔ kya lɔ faa, imɔ nsi oko de saalaa nsi gukue ne. ");
INSERT INTO acd_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Yesu gi wu gɛnen ɔnyen baarɛ ne ɔ bii yɛɛ ɔ dɛ nno kɛɛla gikyɔ mɔ, ɔ taasɛ mɔ yɛɛ, “Fo kya laarɛ fo-gilɔ mɔ giꞌ ta sa fo?” ");
INSERT INTO acd_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ɔlɔbo mɔ gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, meŋ bo ɔko de ɔꞌ kpaa me de nꞌ nyɛ loo nkyu mɔ dɔ. Owi ɔbono nkyu mɔ gi kya luburu ne nꞌ kya laarɛ de nꞌ loo nmɔ dɔ mɔ, ɔko kya wolaa da me.” ");
INSERT INTO acd_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nfono ne Yesu gi tɔgɛ mɔ yɛɛ, “Koso yelɛ, puru fo-gifengen de foꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Ayaa abono so mɔ, ɔnyen mɔ gilɔ mɔ gi ta. Ɔ koso puru mɔ-gifengen ne ɔ naa. Gɛnen gɛkɛ gɛbono Yesu gi kyu kyɛ gɛnen ɔlɔbo baarɛ mɔ, gɛ gyɛ gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Imɔso Gyuda awura abelɛnsɛ mɔ mɛ wu ɔnyen ɔbono Yesu gi kyɛ mɔ so mɔ-gifengen mɔ, mɛ tɔgɛ sa mɔ yɛɛ, “Ndɛ i gyɛ gɛkɛ kyoolasɛ. I mɛŋ dɛ ɔkpa yɛɛ foꞌ sola gifengen.” ");
INSERT INTO acd_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Gyuda awura abelɛnsɛ mɔ mɛ tɔgɛ sa mɔ gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Ɔbono ɔ kyɛ me mɔ ne n tɔgɛ sa me yɛɛ nꞌ koso, puru me-gifengen de nꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nfono mɔ, Gyuda awura abelɛnsɛ mɔ mɛ taasɛ ɔnyen mɔ yɛɛ, “Anɛ ne n gyɛ ɔnyen ɔbono ɔ tɔgɛ sa fo yɛɛ ‘koso puru fo-gifengen de foꞌ naa’ mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ɔnyen mɔ maŋ bii Yesu. I lii fɛɛ asa mɛ nyaakyɔ nno, ne Yesu gi naa loo mɔmɔ dɔ kyon. ");
INSERT INTO acd_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Imɔ gɛmara mɔ Yesu gi kpe kpaa wu ɔnyen mɔ Wurubuaarɛ ɔson obu gikpaara mɔ so, ne Yesu gi tɔgɛ mɔ yɛɛ, “Fo wu gɛnɔɔbono fo kii nyɛ alanfiya mɔ? Taa ilaa nyɛnyɛn giwɔra yɛgɛ de ilaa iko i mɛŋ sa iꞌ kii baa wɔra fo de iꞌ don gilɔ gibono fo lɔ faa.” ");
INSERT INTO acd_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Ɔnyen mɔ gi kyon kpe Gyuda awura abelɛnsɛ mɔ asɛ ne ɔ kpaa tɔgɛ sa mɔmɔ yɛɛ Yesu ne n gyɛ ɔbono ɔ kyɛ mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Imɔ idɛ so mɔ Gyuda awura abelɛnsɛ mɔ mɛ yii gɛsɛ mɛ kya ka Yesu ansi. I kya nyiile yɛɛ gɛkɛ kyoolasɛ ne Yesu gi kyu kyɛ ɔnyen mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Owi kamaasɛ dɔ mɔ me-sɛ Wurubuaarɛ kya wɔra gɛsun. Imɔso me kee n kpɛ mi‑i wɔra gɛsun.” ");
INSERT INTO acd_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Yesu gi tɔgɛ sa mɔmɔ gɛnen mɔ, i yɛgɛ Gyuda awura abelɛnsɛ mɔ mɛ kii lɔrɔ keda nyoro mɛ kya laarɛ mɔ-imɔɔten. Mɔmɔ asɛ mɔ Yesu gi tɔrɔ mɔmɔ-gɛkɛ kyoolasɛ nbara mɔ ne mɛ kii tɔgɛ yɛɛ iŋ gyɛ ibono wolɛ gbaa. Ɔ tɔgɛ kee yɛɛ Wurubuaarɛ ne n gyɛ mɔ-sɛ. Mɛ kyu imɔ yɛɛ Yesu kya nyiile yɛɛ mɔ‑rɛ Wurubuaarɛ mɛ gyɛ kyɛɛ-kyɛɛ. Ɔko mɛŋ don mɔ-nanbo. ");
INSERT INTO acd_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ fɛye faa, me, Wurubuaarɛ mɔ-bi mɔ, maŋ wɔra ilaa iko me-gibaa so. N kya wɔra daa ilaa ibono n kya wu me-sɛ Wurubuaarɛ kya wɔra mɔ. Ilaa kamaasɛ ibono ɔ kya wɔra mɔ, imɔ kee ne me, mɔ-bi mɔ kya wɔra. ");
INSERT INTO acd_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","I kya nyiile yɛɛ Wurubuaarɛ kya laarɛ me, mɔ-bi mɔ, ilaa. Imɔso ɔ kya kyu ilaa ibono mɔ gbaa-gbaa kya wɔra mɔ pɛwu kyu nyiile me. Ɔ laa baa kyu ilaa belɛ-belɛ ibono i don idɛ mɔ gbaa kyu nyiile me de iꞌ dɛ fɛye-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Fɛɛ gɛnɔɔbono Wurubuaarɛ laa baa kyingi asa abono mɛ wuꞌ mɔ de ɔꞌ sa mɔmɔ nkpa mɔ, gɛnen kee ne me, Wurubuaarɛ mɔ-bi mɔ nꞌ kya kyu Wurubuaarɛ asɛ gɛkyena ɔnan sa asa abono n kya laarɛ nꞌ sa mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","“Wurubuaarɛ mɛŋ kya gyi asa nbɛlɛ. O kyu asa nbɛlɛ gigyi kyu sa daa me, mɔ-bi mɔ ");
INSERT INTO acd_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","de ɔkamaasɛ oꞌ kyu buubuu kyu sa me, fɛɛ gɛnɔɔbono mɛ kya kyu buubuu sa Wurubuaarɛ mɔ. Fo nyamesɛ kamaasɛ ɔbono fo mɛŋ kya buu me, Wurubuaarɛ mɔ-bi mɔ, gɛnen kee ne fo mɛŋ kya buu Wurubuaarɛ ɔbono o sun me mɔ kee ne. ");
INSERT INTO acd_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Gɛsintin ne n kya tɔgɛ mi‑i sa fɛye faa, fo ɔbono fo nu me-gɛdɛ ne fo kyu fo-nyoro too ɔbono o sun me mɔ so mɔ, fo gɛnen kaasɛ ɔbono fo ti fo bo Wurubuaarɛ asɛ gɛkyena. Maŋ bun fo kaasɛ ɔbono gipuɛɛ. Fo lii Wurubuaarɛ gisobiidɛ mɔ dɔ baa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","N kya tɔgɛ fɛye gɛsintin, owi mɔ kya ba, owi mɔ gi ti fo gbaa. Asa abono mɛ wɔra fɛɛ mɛ wuꞌ mɛ naa mɔ, mɛ laa nu me, Wurubuaarɛ mɔ-bi mɔ gigyɛbiꞌ, ne mɔmɔ abono mɛ nu me-gɛdɛ mɔ mɛ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan kon. ");
INSERT INTO acd_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","I kya nyiile yɛɛ gɛnɔɔbono Wurubuaarɛ ne n dɛ nkpa de mɔ-gibaa mɔ, gɛnen ne Wurubuaarɛ gi yɛgɛ me, mɔ-bi mɔ kee nꞌ dɛ nkpa de me-gibaa ne. ");
INSERT INTO acd_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Wurubuaarɛ gi sa me, mɔ-bi mɔ ɔkpa yɛɛ nꞌ gyi asa nbɛlɛ, i kya nyiile yɛɛ me ne n gyɛ anyamesɛ pɛwu mɔmɔ-daa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Fɛ mɛŋ sa fɛꞌ yɛgɛ de ilaa idɛ iꞌ dɛ fɛye-gɛnɔ. I kya nyiile yɛɛ owi mɔ kya ba, asa abono mɛ dɛ nkyan dɔ mɔ pɛwu mɛ laa nu me-gigyɛbiꞌ kon. ");
INSERT INTO acd_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","Abono mɛ wɔra idɛnsɛ mɔ mɛ laa kyingi lii ibuni dɔ ba de mɛꞌ kyena Wurubuaarɛ asɛ, ne abono, mɔ, mɛ wɔra inyɛnyɛn mɔ, mɛ laa kyingi lii ibuni dɔ ba de nꞌ bun mɔmɔ gipuɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Maŋ taalɛ wɔra sɛi me-gibaa so. Gɛnɔɔbono n kya nu mɔ, gɛnen ne nꞌ kya kyu kerɛ asa ilaa dɔ wu mɔmɔ-gidebi ne. Gɛnɔɔbono n kya kyu wu asa ilaa mɔ, i gyɛ gɛsintin ɔkpa so. I kya nyiile yɛɛ meŋ kya laarɛ me-lɛɛ gɛlaarɛ. Ɔbono o sun me mɔ gɛlaarɛ ne nꞌ kya laarɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nengyene nɛ tɔgɛ yɛɛ me gbaa-gbaa nꞌ buu sa asa isa ɔbono ɔnan n gyɛ mɔ, i maŋ sa de asa mɛꞌ bii yɛɛ i gyɛ gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Ɔko bo soso ɔ kya lɛɛ me-gidebi nyiile, ne nꞌ nyi yɛɛ ilaa ibono ɔ kya lɛɛ nyiile mɔ i gyɛ gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Fɛ sun kpaa taasɛ Gyɔn kyu lii me so, ne ɔ lɛɛ gɛsintin gɛbono o nyi mɔ tɔgɛ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Iŋ gyɛ yɛɛ n kya sɔɔ ilaa ibono anyamesɛ mɛ kya tɔgɛ kyu lii me so mɔ kyule berɛ. Nɛ taa tɔgɛ Gyɔn ilaa idɛ daa de fɛꞌ nyɛ Wurubuaarɛ ɔꞌ mɔlɛgɛ fɛye. ");
INSERT INTO acd_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Gyɔn gi wɔra fɛɛ fatela ɔbono ɔ kyangɛ ne i kya wu mɔ. Fɛ kyule kyena de mɔ-fatela mɔ ŋmaraa daa ne fɛ gyi ɔkon. ");
INSERT INTO acd_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","“N bo ilaa ibono i kya lɛɛ me-gidebi nyiile ne i don Gyɔn-lɛɛ mɔ gbaa. I kya nyiile yɛɛ nsun nbono me-sɛ Wurubuaarɛ gi kyu wɔra me-abaa dɔ de nꞌ wɔra logɛ mɔ, nmɔ dɔ ne nꞌ kpɛ n dɛ faa. Gɛnen nsun mɔ ne n kya lɛɛ me nyiile asa yɛɛ me-sɛ Wurubuaarɛ ne n sun me. ");
INSERT INTO acd_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","“Me-sɛ ɔbono o sun me mɔ gbaa-gbaa kee gi lɛɛ isa ɔbono ɔnan nꞌ gyɛ mɔ nyiile. Fɛŋ ti taa nu mɔ-gigyɛbiꞌ, ne fɛŋ ti taa wu mɔ de fɛye-ansi kerɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ne mɔ-agyɛbi mɔ kee aŋ bo fɛye-asen dɔ. I kya nyiile yɛɛ fɛ mɛŋ kya kyu fɛye-nyoro too me ɔbono Wurubuaarɛ gi sun me mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","“Fɛ kya pɛɛrɛ ansi kasɛ Wurubuaarɛ agyɛbi mɔ. Fɛ nyi yɛɛ amɔ ne nan yɛgɛ fɛꞌ nyɛ kyena Wurubuaarɛ asɛ gɛkpaa. To! Gɛnen Wurubuaarɛ agyɛbi abono kee ne n kya lɛɛ me-ilaa nyiile. ");
INSERT INTO acd_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Imɔ gɛnen gbaa mɔ, fɛ kine fɛ maŋ ba me asɛ de fɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nengyene anyamesɛ mɛ kya yen me mɔ, meŋ kya kyu imɔ wɔra ilaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","N nyi fɛye, fɛŋ kya laarɛ Wurubuaarɛ ilaa fɛye-asen dɔ. ");
INSERT INTO acd_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nɛ ba me-sɛ Wurubuaarɛ ginyen dɔ ne fɛŋ kya laarɛ fɛꞌ nu me asɛ. Nengyene fɛɛ ɔko kpɛi ne n ba fɛye asɛ mɔ-gibaa so mɔ, ɔbono berɛ, fɛ laa nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Fɛ kpɛ fa‑a laarɛ de fɛꞌ gyi ginsi fɛye-nanboana asɛ. Iŋ tiri fɛye yɛɛ fɛꞌ gyi ginsi ɔbono mɔ-nkon ne n gyɛ Wurubuaarɛ mɔ asɛ. Nnɛ ne fɛ laa taalɛ sɔɔ me gyi? ");
INSERT INTO acd_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Imɔso fɛꞌ mɛŋ sa fɛꞌ sa gɛwɔnsa yɛɛ me ne nan kpaa tɔgɛ fɛye-gidebi sa Wurubuaarɛ. Mosisi ɔbono fɛye-ansi a gyan mɔ so mɔ ne nan kpaa tɔgɛ fɛye-gidebi sa Wurubuaarɛ de oꞌ gyi fɛye-nbɛlɛ. ");
INSERT INTO acd_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Nengyene fɛɛ fɛ sɔɔ Mosisi gyi gɛsintin mɔ, nkana fɛ laa sɔɔ me kee gyi. I kya nyiile yɛɛ ɔ ŋmarasɛ me-ilaa yela. ");
INSERT INTO acd_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Ibono fɛ mɛŋ sɔɔ imɔ gyi faa, nnɛ so ne fɛ laa sɔɔ ilaa ibono n kya tɔgɛ mɔ gyi?” ");
INSERT INTO acd_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Imɔ idɛ gɛmara mɔ, Yesu gi fara kpe Galeli ɔbon belɛ mɔ gigengen giko so. Mɛ kya terɛ gɛnen ɔbon mɔ ginyen giko yɛɛ Tabiriyasɛ. ");
INSERT INTO acd_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Sakpii belɛ buu mɔ. I lii fɛɛ asa mɛ kya wu Yesu kya kyɛ alɔbo ne i kya lɛɛ nyiile yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Yesu gi kpe nno mɔ, o dii kpe gibii giko so, ne mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kpelegɛ kyena. ");
INSERT INTO acd_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Gɛnen owi ɔbono mɔ, Gyuda awura gɛkɛ belɛ gɛbono mɛ kya terɛ gɛmɔ yɛɛ Lɛwu Gi Seregɛ Aye So mɔ gɛ kya fuude. ");
INSERT INTO acd_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Yesu tɛ gibii mɔ so gɛnen mɔ, o wu sakpii belɛ kya ba mɔ asɛ. Imɔso ɔ taasɛ Filipo yɛɛ, “Nnɛ ne a laa wɔra de aꞌ nyɛ agyudɔ sɔɔ de asa adɛ mɛꞌ nyɛ gyi ne?” ");
INSERT INTO acd_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Yesu gi taasɛ Filipo gɛnen mɔ, ɔ kya too mɔ soso daa. Ɔ ti wolaa o nyi ilaa ibono ɔ laa wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Filipo gi lɛɛ gɛnɔ yɛɛ, “Aye ne n kine a nyɛ aterenbi abono ɔnan gɛsun ɔwɔrabo laa nyɛ ibosɛ gukue dɔ kyu kpaa sɔɔ agyudɔ gbaa mɔ, iŋ gyɛ mɔmɔ ɔkamaasɛ ne nan nyɛ baa pii faa gyi.” ");
INSERT INTO acd_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Yesu akasɛbo mɔ dɔ ɔbono mɛ kya terɛ mɔ yɛɛ Andiru, Simon Piita mɔ-tedɛ mɔ, gi tɔgɛ sa Yesu yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Gɛdegabi gɛko gɛ dɛ ibodobodo pii-pii inun de nkenbii nnyɔ nko. Gɛnen agyudɔ pii adɛ mɔ, menɛ ne i laa wɔra sa asa belɛ adɛ pɛwu?” ");
INSERT INTO acd_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yesu gi tɔgɛ yɛɛ, “Fɛꞌ yɛgɛ asa mɔ mɛꞌ kpelegɛ kyena.” Ifɛ bonboli i nyaakyɔ nfono, imɔso mɛ kpelegɛ kyena. Mɔmɔ-gɛgyɔnɔ gɛ laa wɔra fɛɛ nwɛ ikue-inyɔ de saalaa. ");
INSERT INTO acd_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Mɛ kyena mɔ, Yesu gi puru ibodobodo mɔ, o kyu afaala sa Wurubuaarɛ, ne ɔ yɛgɛ mɛꞌ yɛ sa asa mɔ nfono mɛ tɛ mɔ. Gɛnɔɔbono Yesu gi wɔra ibodobodo mɔ, gɛnen kee ne o wɔra iken mɔ, ne mɛ gyi kaabo kii san. ");
INSERT INTO acd_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Mɛ gyi kaabo mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kpaa puru agyisan mɔ de imɔ iko i mɛŋ sa iꞌ dɛ nyida.” ");
INSERT INTO acd_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Imɔso mɛ wɔra fɛɛ gɛnɔɔbono ɔ tɔgɛ mɔmɔ mɔ. Agyisan mɔ mɛ kii nyɛ lii ibodobodo inun mɔ dɔ mɔ, i bɔla nkeebii gudu nnyɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Asa mɔ mɛ wu ilaa ibono Yesu gi wɔra ne i lɛɛ Wurubuaarɛ ɔlon ɔbono ɔ bo mɔ dɔ mɔ nyiile mɔ, mɛ tɔgɛ yɛɛ, “I gyɛ gɛsintin yɛɛ ɔdɛ ne n gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa ba gɛsinkpan so mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Gɛnen so mɔ mɛ kya laarɛ de mɛꞌ baa keda mɔ ɔlon so kyu kpaa yii gɛwura. Yesu gi bii gɛnen mɔ, ɔ naa taa mɔmɔ yɛgɛ kii kpe gibii mɔ so mɔ-wolɛ. ");
INSERT INTO acd_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","I baa fo gɛdɔɔdɛ mɔ, Yesu akasɛbo mɔ mɛ kii kpelegɛ kpe ɔbon belɛ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mɛ dii loo gikolii dɔ ne mɛ palɛ gimɔ foro mɛ kya kpe de Kapɛɛniyon ɔsowolɛ so. I wɔra gɛnyɛ ne Yesu mɛŋ ti taa baa tu ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Gɛnen aberɛ abono kee mɔ, afuu belɛ a koso a kya da ne i yɛgɛ nkyu mɔ gi kya gyigisi. ");
INSERT INTO acd_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Yesu akasɛbo mɔ mɛ palɛ gikolii mɔ gɛnen‑n kpe ansi dɔ fɛɛ akpaaten asaꞌ abɛɛ anan mɔ, mɛ wu isa naa nkyu mɔ so ɔ kya ba de mɔmɔ asɛ so sindi gikolii mɔ. Mɛ wu mɔ gɛnen mɔ, i ŋmaa mɔmɔ-gisen. ");
INSERT INTO acd_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ne isa mɔ gi tɔgɛ sa mɔmɔ yɛɛ, “Me Yesu ne. Fɛŋ sa fɛꞌ selɛ gifuu.” ");
INSERT INTO acd_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Yesu gi tɔgɛ gɛnen mɔ, mɛ yɛgɛ mɔ ɔꞌ baa loo gikolii mɔ dɔ. Mɔ‑rɛ mɔ-gidiiloo gikolii mɔ dɔ mɔ, mɛ ti loo nfono mɛ kya kpe mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Gɛdɛ kɛsɛ mɔ asa abono mɛ san ɔbon belɛ mɔ gigengen mɔ so mɔ mɛ wu ibono nkana gikolii kolon ne n san nno. Mɛŋ kii wu Yesu ɔꞌ loo gikolii mɔ dɔ mɔ-akasɛbo mɔ asɛ. Mɔmɔ-wolɛ ne n kyon. ");
INSERT INTO acd_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Akolii ako a lii Tabiriyasɛ baa sindi nfono. (Nno ne Yesu gi kyu afaala sa Wurubuaarɛ ne o kyu bodobodo sa asa mɔ ne mɛ gyi mɔ.) ");
INSERT INTO acd_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Imɔso ibono asa mɔ mɛŋ wu Yesu abɛɛ mɔ-akasɛbo mɔ nfono mɔ, mɛ dii loo akolii abono a ba nfono mɔ dɔ ne mɛ kyon Kapɛɛniyon mɛꞌ kpaa laarɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Asa mɔ mɛ kpaa wu Yesu ɔbon belɛ mɔ gigengen giko mɔ so mɔ, mɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, owi mɔmɔ dɔ ne fo ti baa loo gɛrɛ?” ");
INSERT INTO acd_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Yesu gi lɛɛ gɛnɔ yɛɛ, “Nꞌ tɔgɛ fɛye gɛsintin yɛɛ fɛ naa fɛ kya laarɛ me faa, bodobodo ɔbono fɛ nyɛ gyi kaabo mɔ so. Nkana i mɛŋ gyɛ ilaa ibono nɛ wɔra ne i lɛɛ nyiile yɛɛ Wurubuaarɛ ɔlon bo me dɔ mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Fɛ mɛŋ sa fɛꞌ wɔra gɛsun kyu laarɛ gɛsinkpan-lɛɛ agyudɔ wolɛ. Fɛꞌ wɔra gɛsun laarɛ daa agyudɔ abono a laa yɛgɛ fɛꞌ nyɛ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa mɔ. Me, anyamesɛ pɛwu mɔmɔ-daa mɔ ne nan sa fɛye gɛnen agyudɔ abono. Aye-sɛ Wurubuaarɛ gi lɛɛ nyiile yɛɛ me ne o sun de nꞌ yɛgɛ asa mɛꞌ nyɛ mɔ asɛ gɛkyena.” ");
INSERT INTO acd_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Yesu gi tɔgɛ gɛnen mɔ, asa mɔ mɛ taasɛ mɔ yɛɛ, “Menɛ gɛsun ne Wurubuaarɛ kya laarɛ aꞌ wɔra?” ");
INSERT INTO acd_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yesu gi lɛɛ gɛnɔ yɛɛ, “Gɛsun gɛbono Wurubuaarɛ kya laarɛ yɛɛ fɛꞌ wɔra mɔ ne n gyɛ yɛɛ fɛꞌ kyu fɛye-nyoro too me, ɔbono Wurubuaarɛ gi sun me mɔ so.” ");
INSERT INTO acd_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Nfono ne asa mɔ mɛ taasɛ Yesu yɛɛ, “Menɛ ne fo laa wɔra de iꞌ lɛɛ nyiile aye yɛɛ Wurubuaarɛ ne n sun fo de aꞌ kyu aye-nyoro too fo so? Menɛ gɛsun ne fo laa wɔra? ");
INSERT INTO acd_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Owi ɔko dɔ mɔ, aye-naanaana adedaabo mɔ mɛ nyɛ agyudɔ abono mɛ kya terɛ yɛɛ ‘mana’ mɔ gyi gipen dɔ. Ne mɛ ŋmarasɛ imɔ wɔra Wurubuaarɛ agyɛbi ɔwolɛ mɔ dɔ yela yɛɛ, Ɔ sa mɔmɔ agyudɔ lii soso ne mɛ gyi.” ");
INSERT INTO acd_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Asa mɔ mɛ tɔgɛ gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “N kya tɔgɛ fɛye gɛsintin, i mɛŋ gyɛ Mosisi ne n sa fɛye-adedaabo agyudɔ abono a lii Wurubuaarɛ dɔ mɔ. Me-sɛ Wurubuaarɛ ne n sa ɔmɔ gɛnen agyudɔ abono. Ne idɛ kon mɔ ɔ kya sa fɛye Wurubuaarɛ dɔ agyudɔ gbaa-gbaa. ");
INSERT INTO acd_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Gɛnen Wurubuaarɛ dɔ agyudɔ abono n darɛ mɔ ne n gyɛ ɔbono ɔ kpelegɛ lii Wurubuaarɛ dɔ ne ɔ kya sa anyamesɛ Wurubuaarɛ asɛ gɛkyena mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Nfono mɔ, asa mɔ mɛ kolɛ Yesu yɛɛ, “Ɔbelɛnsɛ, sa aye gɛnen agyudɔ abono owi kamaasɛ.” ");
INSERT INTO acd_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Yesu gi lɛɛ gɛnɔ yɛɛ, “Me ne n gyɛ agyudɔ abono a kya sa Wurubuaarɛ asɛ gɛkyena ɔnan mɔ. Nyamesɛ kamaasɛ ɔbono ɔ ba me asɛ mɔ, akon a maŋ baa mɔɔ mɔ gɛkaako kpa‑a. Ɔbono o kyu mɔ-nyoro too me so mɔ, bolefɔ maŋ baa mɔɔ mɔ gɛkaako kpa‑a. ");
INSERT INTO acd_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","“Fɛɛ gɛnɔɔbono nɛ wolaa buu sa fɛye mɔ, fɛ wu me, fɛŋ kii kyu fɛye-nyoro too me so. ");
INSERT INTO acd_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Abono pɛwu me-sɛ Wurubuaarɛ kya sa me mɔ, mɛ laa ba me asɛ. Ne ɔbono ɔ ba gɛnen mɔ, maŋ gya mɔ yɛɛ oꞌ kii. ");
INSERT INTO acd_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","I kya nyiile yɛɛ nɛ lii Wurubuaarɛ dɔ ba de nꞌ baa wɔra ɔbono o sun me mɔ ɔbolɛ gɛlaarɛ, i mɛŋ gyɛ me gbaa-gbaa lɛɛ gɛlaarɛ. Ɔbono o sun me mɔ-gɛlaarɛ so ne n naa. ");
INSERT INTO acd_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Mɔ-gɛlaarɛ ne n gyɛ yɛɛ abono o kyu sa me mɔ dɔ ɔko‑rɛ ɔko ɔŋ sa ɔꞌ fuɛ mɔ-lɛwu gɛmara. Ɔ kya laarɛ daa fɛɛ nꞌ kyingi mɔmɔ lii ibuni dɔ gɛkɛ laalaalogɛsɛ gɛbono Wurubuaarɛ laa gyi anyamesɛ pɛwu nbɛlɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Me-sɛ Wurubuaarɛ kya laarɛ yɛɛ nyamesɛ kamaasɛ ɔbono o wu me bii yɛɛ me ne n gyɛ mɔ-bi mɔ ne o kyu mɔ-nyoro too me so mɔ, gɛnen kaasɛ mɔ ɔꞌ nyɛ ɔkyenaten Wurubuaarɛ asɛ gɛkpaa-gɛkpaa. Nan kyingi mɔ lii ibuni dɔ gɛkɛ laalaalogɛsɛ gɛbono Wurubuaarɛ laa gyi anyamesɛ nbɛlɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Yesu gi tɔgɛ yɛɛ, “Me ne n gyɛ agyudɔ abono a lii Wurubuaarɛ dɔ ba mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ɔ tɔgɛ gɛnen mɔ, Gyuda awura abelɛnsɛ mɔ mɛ kya ŋuiini kyu lii imɔ so yɛɛ, “Iŋ gyɛ Yesu, Gyosɛfo mɔ-bi mɔ ne? Iŋ gyɛ mɔ-sɛ de mɔ-nyi ne a nyi mɔ? Ne menɛ so ne idɛ kon ɔ kya tɔgɛ yɛɛ ɔ lii Wurubuaarɛ dɔ ba mɔ daa?” ");
INSERT INTO acd_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ yɛgɛ giŋuiini mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ɔko maŋ taalɛ ba me asɛ mɔ-gibaa so, gɛnen mɔ, Wurubuaarɛ ɔbono o sun me mɔ gi biidɛ mɔ ba. Ne nan kyingi mɔ lii ibuni dɔ gɛkɛ laalaalogɛsɛ gɛbono Wurubuaarɛ laa gyi anyamesɛ nbɛlɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Wurubuaarɛ ikalan atɔgɛbo ɔwolɛ mɔ dɔ mɔ, mɛ ŋmarasɛ yela yɛɛ, Wurubuaarɛ laa nyiile asa pɛwu ilaa. N kya tɔgɛ fɛye yɛɛ nyamesɛ kamaasɛ ɔbono o nu imɔ ne ɔ kasɛ lii me-sɛ Wurubuaarɛ asɛ mɔ, gɛnen kaasɛ ɔbono laa ba me asɛ. ");
INSERT INTO acd_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Nɛ tɔgɛ gɛnen mɔ, iŋ gyɛ yɛɛ n kya tɔgɛ yɛɛ nyamesɛ ɔko gi ti wu Wurubuaarɛ de ansi kerɛ. Ɔbono ɔ lii Wurubuaarɛ asɛ mɔ mɔ-nkon ne n ti wu Wurubuaarɛ de ansi. ");
INSERT INTO acd_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gɛsintin ne n kya tɔgɛ mi‑i sa fɛye faa, ɔbono o kyu mɔ-nyoro too me so mɔ laa kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Me ne n gyɛ agyudɔ abono a kya sa Wurubuaarɛ asɛ gɛkyena ɔnan mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","I gyɛ gɛsintin yɛɛ fɛye-naanaana mɛ gyi agyudɔ abono mɛ kya terɛ yɛɛ ‘mana’ mɔ gipen dɔ. Imɔ gɛnen gbaa mɔ, mɛ wuꞌ. ");
INSERT INTO acd_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Me berɛ, n gyɛ agyudɔ abono a lii Wurubuaarɛ dɔ ba mɔ. Nengyene fo ɔko fo gyi amɔ mɔ, fo maŋ wu fuɛ fo-lɛwu gɛmara. ");
INSERT INTO acd_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Me ne n gyɛ agyudɔ abono a kya sa Wurubuaarɛ asɛ gɛkyena ɔnan mɔ. Nɛ kpelegɛ lii Wurubuaarɛ dɔ ba. Nengyene ɔko gi gyi gɛnen agyudɔ adɛ mɔ, ɔ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan gɛkpaa. Gɛnen agyudɔ abono nan kyu sa anyamesɛ de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan mɔ ne n gyɛ me-nyoro.” ");
INSERT INTO acd_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ilaa ibono Yesu gi tɔgɛ gɛnen mɔ, i yɛgɛ akyɔɔlɛ a tɔrɔ Gyuda awura abelɛnsɛ mɔ so. Mɛ san mɛ kya taasɛ abara yɛɛ, “Nnɛ ne ɔnyen baarɛ laa taalɛ kyu mɔ-nyoro sa aye de aꞌ gyi?” ");
INSERT INTO acd_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Nfono mɔ Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “N kya tɔgɛ fɛye gɛsintin; nengyene fɛŋ kya gyi me, anyamesɛ pɛwu mɔmɔ-daa mɔ-nyoro ne fɛ mɛŋ kya nun me-nkalan mɔ, fɛŋ bo Wurubuaarɛ asɛ gɛkyena ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Ɔbono ɔ kya gyi me-nyoro ne o kya nun me-nkalan mɔ, ɔ ti nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan gɛkpaa. Nan kyingi mɔ lii ibuni dɔ gɛkɛ laalaalogɛsɛ gɛbono nan gyi anyamesɛ nbɛlɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Me-nyoro gi gyɛ agyudɔ gɛsintin so, ne me-nkalan gi gyɛ nkyu nunsɛ gɛsintin so. ");
INSERT INTO acd_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ɔbono ɔ kya gyi me-nyoro ne ɔ kya nun me-nkalan mɔ, gɛnen kaasɛ ɔbono bo me dɔ, ne me kee n bo mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","“Me-sɛ ɔbono ɔ bo no adaa-adaa mɔ ne n sun me. Kyu lii mɔ so ne nꞌ bo Wurubuaarɛ asɛ gɛkyena ɔnan faa. Gɛnen kee ne, kyu lii me so mɔ, ɔbono ɔ kya gyi me-nyoro mɔ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Me ne n gyɛ agyudɔ abono a lii Wurubuaarɛ dɔ ba mɔ. Meŋ dɛ fɛɛ agyudɔ abono ɔnan aye-naanaana mɔ mɛ gyi ne mɛ dabɔlɛ wuꞌ mɔ. Nyamesɛ ɔbono o gyi gɛnen agyudɔ abono n darɛ faa berɛ, laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Yesu gi tɔgɛ imɔ idɛana gikyangbon dɔ aberɛ abono ɔ kya nyiile ilaa Kapɛɛniyon mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Akasɛbo mɔ mɛ nu ibono ɔ tɔgɛ mɔ, mɔmɔ dɔ asa sakyɔ mɛ tɔgɛ yɛɛ, “Ilaa idɛ berɛ, i bo lon. Anɛ ne nan taalɛ sɔɔ imɔ idɛ kyule?” ");
INSERT INTO acd_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Yesu gi ti wolaa bii mɔ-gisen dɔ yɛɛ mɛ kya ŋuiinɛ kyu lii ilaa idɛ so. Imɔso ɔ taasɛ mɔmɔ yɛɛ, “Imɔ idɛ i kya laarɛ iꞌ yɛgɛ fɛye-gisɔɔgyi giꞌ koso me so? ");
INSERT INTO acd_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","To! Imɔ idɛ gbaa ne. N baa kerɛ fɛ wu me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nɛ kii dii n kya kpe Wurubuaarɛ dɔ nfono nkana n wolaa n bo pɛi ne nɛ kpelegɛ ba gɛsinkpan so mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","“Wurubuaarɛ Oduduu mɔ ne n kya sa nyamesɛ Wurubuaarɛ asɛ gɛkyena ɔnan. Nyamesɛ gibaa so mɔ ɔ maŋ taalɛ wɔra sɛi de ɔꞌ nyɛ Wurubuaarɛ asɛ gɛkyena. Agyɛbi abono nɛ tɔgɛ sa fɛye faa a gyɛ daa oduduu dɔ ilaa ne a kya sa Wurubuaarɛ asɛ gɛkyena ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Imɔ‑rɛ imɔ gɛnen mɔ, fɛye ako fɛŋ kya sɔɔ gyi.” Yesu gi tɔgɛ gɛnen mɔ, ɔ ti wolaa o nyi asa mɔ dɔ abono mɛ mɛŋ sɔɔ mɔ gyi mɔ de ɔbono ɔ laa yɛgɛ mɔ-akyobo mɛꞌ nyɛ mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Yesu gi kii tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Imɔ idɛ so ne nɛ tɔgɛ fɛye yɛɛ ɔko mɛŋ bo no ɔ laa taalɛ ba me asɛ mɔ-gibaa so, gɛnen mɔ, me-sɛ Wurubuaarɛ gi sa mɔ ɔkpa.” ");
INSERT INTO acd_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Lii gɛnen aberɛ abono mɔ, akasɛbo mɔ sakyɔ mɛ tɛɛ mɔmɔ-nyoro lii mɔ dɔ, mɛŋ baa mɛ naa buu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Imɔso Yesu gi taasɛ mɔ-akasɛbo gudu anyɔ mɔ yɛɛ, “Ne fɛye mɔ de‑e? Fɛye kee fɛ laa tɛɛ fɛye-nyoro lii me dɔ?” ");
INSERT INTO acd_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Nfono mɔ Piita gi lɛɛ gɛnɔ yɛɛ, “Aye-Wura, anɛ asɛ ne a laa kpe? Fo ne n bo agyɛbi abono a laa yɛgɛ nyamesɛ ɔꞌ kyena Wurubuaarɛ asɛ gɛkpaa-gɛkpaa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","A ti kyu aye-nyoro too fo so ne a bii yɛɛ fo ne n gyɛ gisen fufuli wura ɔbono fo-nkon ne n lii Wurubuaarɛ asɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Me ne n lɛɛ fɛye gudu anyɔ adɛ. Fɛye dɔ ɔko, mɔ, bo nwɔnsa nyɛnyɛn.” ");
INSERT INTO acd_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Yesu kya tɔgɛ gɛnen mɔ, Gyudasɛ, Simon Isikaayɔtɛ mɔ-bi mɔ ne ɔ darɛ gɛnen. Gɛsintin mɔ, Gyudasɛ baarɛ gi baa kyu Yesu wɔra mɔ-akyobo abaa dɔ, yɛgɛ ɔ gyɛ Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko. ");
INSERT INTO acd_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Imɔ gɛmara mɔ, Yesu gi san naa-naa daa de Galeli isowolɛ so. Ɔ mɛŋ baa kyule kpe Gyudiya isowolɛ so. I kya nyiile yɛɛ Gyuda awura abelɛnsɛ mɔ mɛ kya laarɛ mɔ-imɔɔten. ");
INSERT INTO acd_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Mɔmɔ-gɛkɛ belɛ gɛko gɛ kya fuude. Gɛnen gɛkɛ belɛ gɛbono gigyi dɔ mɔ, mɛ kya lii kpaa da ipanpan kyena imɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Gɛnen so mɔ, Yesu mɔ-tedɛana mɛ tɔgɛ sa mɔ yɛɛ, “Koso lii gɛrɛ de foꞌ kpe aye-isowolɛ gɛmu Gyudiya gɛsinkpan so de fo-akasɛbo mɛꞌ nyɛ wu ilaa gbaaꞌgbaa ibono fo kya wɔra mɔ de mɔmɔ-ansi. ");
INSERT INTO acd_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Nengyene ɔko kya laarɛ de asa mɛꞌ bii mɔ so mɔ, ɔ mɛŋ kya wɔra mɔ-ilaa kyu ŋara. Nengyene fo kya taalɛ wɔra gɛnen ilaa idɛ mɔ, tɛsɛ lɛɛ fo-nyoro gɛwi nyiile asa tentegelen.” ");
INSERT INTO acd_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Yesu mɔ-tedɛana mɛ tɔgɛ gɛnen mɔ, i kya nyiile yɛɛ mɔmɔ gbaa mɛ mɛŋ kya sɔɔ Yesu gyi yɛɛ Wurubuaarɛ ne n sun mɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Mɛ tɔgɛ sa Yesu gɛnen mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Me-owi mɔ mɛŋ ti fo. Fɛye berɛ, owi kamaasɛ dɔ mɔ, fɛye-owi gi fo sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Asa abono gɛsinkpan so ilaa ne n bo mɔmɔ-ansi so mɔ mɛ maŋ taalɛ kyo fɛye. Me berɛ mɛ kya kyo me. I kya nyiile yɛɛ n kya tɔgɛ mɔmɔ gɛsintin yɛɛ mɔmɔ-ilaa wɔrasɛ mɔ iŋ boran. ");
INSERT INTO acd_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Fɛꞌ koso kpe gɛkɛ belɛ mɔ gigyi. Me berɛ, maŋ kpe. Me-owi ɔbono nan kyu lɛɛ me-nyoro gɛwi sa asa mɔ mɛŋ ti fo.” ");
INSERT INTO acd_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Yesu gi tɔgɛ sa mɔ-tedɛana mɔ gɛnen mɔ, o sii kyena Galeli. Mɔ-tedɛana mɔ, mɔ, mɛ kyon. ");
INSERT INTO acd_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Yesu mɔ-tedɛana mɔ mɛ kyon gɛnen mɔ, imɔ gɛmara mɔ ne Yesu mɔ kee gi koso kpe nno. Ɔ mɛŋ kyule naa kpe tentegelen de oꞌ kyu mɔ-nyoro saarɛ asa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Gyuda awura abelɛnsɛ mɔ mɛ kya laarɛ mɔ gɛkɛ belɛ ogyiten mɔ mɛ kya kpon. Mɛ san mɛ kya taasɛ yɛɛ, “Ɔ bo fonɛ daa?” ");
INSERT INTO acd_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Sakpii mɔ dɔ asa kee mɛ kya gyi nsingyi adɛɛdɛɛ dɔ kyu lii mɔ so gikyɔ. Ako mɛ kya tɔgɛ yɛɛ, “Ɔ gyɛ nyamesɛ dɛnsɛ.” Mɔmɔ ako mɔ yɛɛ, “Kuaa. Ɔ kya penɛ asa daa de mɛꞌ fuɛ Wurubuaarɛ ɔkpa.” ");
INSERT INTO acd_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Ɔko‑rɛ ɔko mɛŋ tɔgɛ imɔ so ilaa tentegelen. I kya nyiile yɛɛ mɛ selɛ Gyuda awura abelɛnsɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Mɛ gyi Ipanpan Dɔ Gikyena gɛsi mɔ baa fo nsansana mɔ, idɛ kon mɔ, Yesu gi koso kpe Wurubuaarɛ ɔson obu gikpaara mɔ so kpe ɔ kya nyiile asa ilaa. ");
INSERT INTO acd_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Yesu ilaa nyiilesɛ mɔ i dɛ Gyuda awura abelɛnsɛ mɔ gɛnɔ. Mɛ san mɛ kya taasɛ yɛɛ, “Nnɛ so ne mɔ ɔbono ɔ mɛŋ kpe imɔ-ɔwolɛ mɔ ne n kii o nyi ilaa mɔ gɛnen?” ");
INSERT INTO acd_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Me-ilaa nyiilesɛ i mɛŋ lii me gbaa-gbaa asɛ. I lii daa ɔbono o sun me mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Fo nyamesɛ kamaasɛ ɔbono fo kya laarɛ foꞌ wɔra Wurubuaarɛ gɛlaarɛ mɔ, fo ne n gyɛ ɔbono fo laa bii yɛɛ me-ilaa nyiilesɛ idɛ i lii daa Wurubuaarɛ asɛ, abɛɛ me gbaa-gbaa gibaa so ne nꞌ kya kyu nyiile ilaa gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ɔbono ɔ kya nyiile asa ilaa mɔ-gibaa so mɔ kya laarɛ daa nyisigyi ɔ kya sa mɔ-nyoro. Ne ɔbono, mɔ, ɔ kya laarɛ fɛɛ ɔbono o sun mɔ mɔ ne ɔꞌ nyɛ nyisigyi mɔ, gɛnen kaasɛ ɔbono ne n bo gɛsintin. Ɔŋ kya penɛ asa. ");
INSERT INTO acd_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Iŋ gyɛ Mosisi ne n kyu Wurubuaarɛ nbara sa fɛye? Ne i wonɛ so ne fɛye dɔ ɔko‑rɛ ɔko mɛŋ kya gyi nmɔ so ne fɛ kii fɛ kya laarɛ me-imɔɔten daa?” ");
INSERT INTO acd_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Yesu gi taasɛ asa mɔ gɛnen mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Ilaa nyɛnyɛn oduduu tɛ fo so. Anɛ ne n kya laarɛ ɔꞌ mɔɔ fo?” ");
INSERT INTO acd_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Nfono mɔ, Yesu gi lɛɛ gɛnɔ yɛɛ, “Ilaa kolon ne nɛ wɔra gɛkɛ kyoolasɛ ne i dɛ fɛye gɛnɔ faa. ");
INSERT INTO acd_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Iŋ gyɛ Mosisi gi yela awɔrɛ giten nbara sa fɛye? I mɛŋ lii Mosisi gbaa-gbaa asɛ berɛ. Gɛnen nbara nbono gi lii daa aye-naanaana agyangbarabo mɔ asɛ. Fɛ korogɛ gɛbii nyensɛɛ ne gɛkɛ gɛbono mɛ laa kyu ten gɛmɔ-giwɔrɛ mɔ i baa yii de gɛkɛ kyoolasɛ mɔ, fɛ mɛŋ kya tɔgɛ yɛɛ i gyɛ gɛkɛ kyoolasɛ so mɔ fɛꞌ kosorɛ yela gɛkɛ pobɔrɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ibono i ti i gyɛ nbara so mɔ fɛ kya dabɔlɛ ten awɔrɛ nkɛ kyoolasɛ gɛnɔɔbono i laa wɔra ne fɛ maŋ tɔrɔ Mosisi nbara mɔ. Menɛ n wɔra ne fɛ kyu ginyadon me so yɛɛ nɛ kyɛ nyamesɛ gɛkɛ kyoolasɛ? ");
INSERT INTO acd_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Fɛŋ sa fɛꞌ kerɛ asa ansi so tɔgɛ yɛɛ mɔmɔ-ilaa iŋ boran. Fɛꞌ kyu gɛsintin bun asa gipuɛɛ de fɛꞌ sa aso.” ");
INSERT INTO acd_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Yesu kya tɔgɛ gɛnen mɔ, Gyɛrusalem ɔsowolɛ mɔ so nten abi abono mɛ bo nfono mɔ, mɛ kya taasɛ yɛɛ, “I mɛŋ gyɛ gɛnen ɔnyen baarɛ ne mɛ kya laarɛ de mɛꞌ mɔɔ mɔ? ");
INSERT INTO acd_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Kerɛ, mɔ ne n yelɛ tentegelen sansana ɔ kya tɔngɛ ne ɔko mɛŋ kya tɔgɛ mɔ sɛi mɔ. Abɛɛ idɛ kon, abelɛnsɛ mɔ mɛ bii yɛɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi wolaa tɔgɛ yɛɛ ɔ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ daa? ");
INSERT INTO acd_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Ɔdɛ berɛ a nyi ɔsowolɛ ɔbono so ɔ lii mɔ. Ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ, nkana a nyi yɛɛ ɔko‑rɛ ɔko maŋ bii nfono ɔ laa lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Akyɔɔlɛ mɔ so mɔ, Yesu san ɔ kya nyiile ilaa Wurubuaarɛ ɔson obu gikpaara mɔ so gɛnen mɔ, ɔ taasɛ ɔmɔ ken-ken yɛɛ, “Fɛ nyi me? Fɛ nyi nfono nɛ lii mɔ? I mɛŋ gyɛ me-gibaa so ne nɛ ba. Ɔbono o sun me mɔ bo no gɛsintin. Fɛye berɛ, fɛ mɛŋ nyi mɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Me berɛ, n nyi mɔ. Mɔ asɛ ne nɛ lii ne mɔ ne n sun me.” ");
INSERT INTO acd_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Yesu gi tɔgɛ gɛnen ta mɔ, nfono mɔ Gyuda awura abelɛnsɛ mɔ mɛ san mɛ kya laarɛ ɔkpa de mɛꞌ nyɛ keda mɔ. Imɔ gɛnen mɔ, ɔko‑rɛ ɔko gibaa gi mɛŋ yii mɔ. I kya nyiile yɛɛ mɔ-owi ɔbono Wurubuaarɛ gi yela mɔ mɛŋ ti taa fo. ");
INSERT INTO acd_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Sakpii mɔ dɔ asa sakyɔ berɛ, mɛ sɔɔ Yesu gyi ne mɛ san mɛ kya taasɛ yɛɛ, “Ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ laa ba mɔ, ɔbono laa taalɛ baa wɔra ilaa lɛɛnyiilesɛ de iꞌ don ibono ɔnyen baarɛ gi wɔra faa?” ");
INSERT INTO acd_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Farasii awura mɔ mɛ kya nu ibono sakpii mɔ mɛ kya gyi nsingyi kyu lii Yesu so gɛnen mɔ, mɔmɔ‑rɛ Gyuda awura asunbi alɛɛbo abelɛnsɛ mɛ sun Wurubuaarɛ ɔson obu mɔ adiibo ako yɛɛ mɛꞌ kpaa keda Yesu ba. ");
INSERT INTO acd_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Nfono mɔ Yesu gi tɔgɛ yɛɛ, “Nan kii kyena fɛye asɛ daa ŋmaraa faa bɔla de nꞌ kii kpe ɔbono o sun me mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gɛnen owi ɔbono mɔ, fɛ laa laarɛ me, fɛ maŋ kii nyɛ me wu. Nfono nan kpaa kyena mɔ fɛye berɛ, fɛ maŋ taalɛ ba nno.” ");
INSERT INTO acd_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Yesu gi tɔgɛ gɛnen mɔ, Gyuda awura abelɛnsɛ mɔ mɛ san mɛ kya tɔgɛ ma‑a sa abara yɛɛ, “Ndo, fɛꞌ nu mɔ-ilaa tɔgɛsɛ! Fonɛ ne ɔnyen baarɛ kya laarɛ oꞌ kpe daa ne ɔ kya tɔgɛ yɛɛ a laa laarɛ mɔ-gɛten, a maŋ wu mɔ faa? Abɛɛ ɔ laa selɛ kpaa kyena aye-adɛ abono mɛ tɛ saarɛ Geriiki awura dɔ mɔ de oꞌ nyiile Geriiki awura mɔ ilaa daa? ");
INSERT INTO acd_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Ibono ɔ tɔgɛ yɛɛ a laa laarɛ mɔ-gɛten kpon, a maŋ wu mɔ, ne nfono ɔ laa kpe mɔ, a maŋ taalɛ kpe nno mɔ, menɛ ne ɔ darɛ gɛnen?” ");
INSERT INTO acd_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Gɛkɛ gɛbono gɛ tiikara mɔmɔ-gɛkɛ belɛ gigyi dɔ mɔ ne n gyɛ gɛkɛ gbaaꞌ sa mɔmɔ. Gɛnen gɛkɛ gɛbono mɔ, Yesu gi koso yelɛ ne ɔ tɔgɛ ken-ken yɛɛ, “Nengyene bolefɔ dɛ ɔko mɔ, kaasɛ ɔꞌ ba me asɛ de ɔꞌ baa nun nkyu. ");
INSERT INTO acd_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Nyamesɛ kamaasɛ ɔbono o kyu mɔ-nyoro too me so mɔ laa wɔra fɛɛ gɛnɔɔbono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ. Mɛ ŋmarasɛ yɛɛ, ‘Ɔbon laa kyon lii mɔ-gisen dɔ. Gɛnen ɔbon ɔbono maŋ ŋaa gɛkaako.’ ” ");
INSERT INTO acd_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Yesu gi tɔgɛ gɛnen mɔ, imɔ gɛsɛ ne n gyɛ yɛɛ Wurubuaarɛ laa kyu mɔ-Oduduu mɔ sa asa abono mɛ laa kyu ɔmɔ-nyoro too Yesu so mɔ. Aberɛ abono Yesu gi tɔgɛ gɛnen mɔ, Wurubuaarɛ mɛŋ ti taa kyu mɔ-Oduduu mɔ sa ɔmɔ. I kya nyiile yɛɛ Wurubuaarɛ mɛŋ ti lɛɛ Yesu nyisigyi gɛwi nyiile asa. ");
INSERT INTO acd_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Asa mɔ mɛ nu ilaa ibono Yesu gi tɔgɛ gɛnen mɔ, mɔmɔ ako yɛɛ, “Gɛsintin mɔ, ɔnyen baarɛ ne n gyɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono a nyi yɛɛ ɔ laa ba mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Mɔmɔ ako, mɔ, yɛɛ, “Mɔ ne n gyɛ ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ.” Ne mɔmɔ ako mɔ yɛɛ, “Ɔ maŋ taalɛ wɔra isa ɔbono Wurubuaarɛ laa sun mɔ. Gɛnen kaasɛ ɔbono maŋ lii Galeli gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Wurubuaarɛ agyɛbi mɔ dɔ mɔ, i tɔgɛ yɛɛ ɔbono Wurubuaarɛ laa sun gɛnen mɔ laa wɔra daa Deefidi mɔ-naanaana dɔ de ɔꞌ lii Bɛtelɛhɛm, Deefidi gɛwi.” ");
INSERT INTO acd_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Mɔmɔ-nnɔ giŋ wɔra gikolon kyu lii Yesu so. ");
INSERT INTO acd_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mɔmɔ ako mɛ laarɛ fɛɛ mɛꞌ keda mɔ kpaa tii. Mɔmɔ ɔko‑rɛ ɔko gibaa gi mɛŋ kii nyɛ yii mɔ. ");
INSERT INTO acd_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Nfono mɔ Wurubuaarɛ ɔson obu mɔ dɔ adiibo mɔ mɛ kii kpe Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de Farasii awura mɔ asɛ. Ne abelɛnsɛ mɔ mɛ taasɛ adiibo mɔ yɛɛ, “Menɛ n wɔra ne fɛ mɛŋ bara mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Mɛ lɛɛ gɛnɔ yɛɛ, “Nyamesɛ ɔko mɛŋ bo no ɔ laa taalɛ tɔngɛ lɛɛ ɔnyen baarɛ.” ");
INSERT INTO acd_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Nfono mɔ Farasii awura mɔ mɛ taasɛ adiibo mɔ yɛɛ, “Imɔso ɔ kpaa nyɛ fɛye kee penɛ? ");
INSERT INTO acd_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Abelɛnsɛ mɔ ako abɛɛ aye Farasii awura mɔ dɔ ako kee mɛ sɔɔ mɔ gyi do‑o? ");
INSERT INTO acd_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Gɛnen asa abono mɛ sɔɔ mɔ gyi mɔ berɛ mɛŋ nyi Wurubuaarɛ nbara nbono Mosisi gi yela mɔ. Imɔso mɔmɔ‑rɛ Wurubuaarɛ abaa anyɔ.” ");
INSERT INTO acd_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ɔ tɔgɛ gɛnen mɔ, ɔbelɛnsɛ ɔko bo mɔmɔ Farasii awura mɔ dɔ mɛ kya terɛ mɔ yɛɛ Nikodemusi. (Gɛnen Nikodemusi baarɛ ne n gyɛ ɔnyen ɔbono ɔ naa kyena kpaa wu Yesu gɛnyɛ gɛko mɔ.) Nikodemusi gi taasɛ mɔ-nanboana abelɛnsɛ mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Aye-nbara gi kya bun nyamesɛ gipuɛɛ owi ɔbono ɔŋ ti taa buu mɔ-gɛnɔ dɔ ilaa de aꞌ nu de aꞌ bii ilaa ibono ɔ wɔra mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Mɛ kisee taasɛ mɔ daa yɛɛ, “Fo kee fo lii Galeli daa do‑o? Lɔrɔ kpaa kerɛ Wurubuaarɛ agyɛbi mɔ dɔ dandan. Fo laa wu de foꞌ bii yɛɛ Wurubuaarɛ ikalan ɔtɔgɛbo ɔko mɛŋ bo no ɔ laa taalɛ lii Galeli gɛsinkpan so.”  ");
INSERT INTO acd_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Mɛ tɔgɛ gɛnen ta mɔ, mɔmɔ ɔkamaasɛ gi yaasɛ kyon mɔ-gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yesu berɛ, gi naa kyon kpe Nfɔ Iyii Gibii mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Gibaadiikɛ fu‑u mɔ, Yesu gi baa loo ɔsowolɛ mɔ so ne o kii naa kpe Wurubuaarɛ ɔson obu gikpaara mɔ so. Asa abono mɛ bo nfono mɔ pɛwu mɛ naa ba Yesu asɛ, ne o kpelegɛ kyena ɔ kya nyiile mɔmɔ ilaa. ");
INSERT INTO acd_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Gyuda awura nbara aŋmarasɛbo mɔ de Farasii awura mɔ mɛ kpaa kyu ɔkyii ɔko ba Yesu asɛ nfono. Mɛ keda mɔ de ɔnyen. Mɛ kyu mɔ baa yelɛ sansana ");
INSERT INTO acd_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","ne mɛ tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, a keda ɔkyii baarɛ de ɔnyen. ");
INSERT INTO acd_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","To, Wurubuaarɛ nbara dɔ mɔ Mosisi gi ŋmarasɛ yela yɛɛ aꞌ too abui mɔɔ gɛnen asa abono ɔnan. Fo‑o fo mɔ, nnɛ ne fo dɛ?” ");
INSERT INTO acd_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mɛ taasɛ Yesu gɛnen ilaa idɛ daa kyu soo mɔ idoo kerɛ de mɛꞌ kyu mɔ wɔra nbɛlɛ dɔ. Mɛ taasɛ Yesu gɛnen mɔ, o sii wuruge ne o kyu mɔ-gibaabi ɔ kya ŋmarasɛ gɛsinkpan. ");
INSERT INTO acd_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mɛ kpɛ ma‑a taasɛ mɔ gɛnen so mɔ, ɔ koso yelɛ ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛye dɔ ɔbono ɔŋ ti wɔra ilaa nyɛnyɛn mɔ, ɔꞌ daa gigyangbara too gibui da ɔkyii mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Yesu gi tɔgɛ mɔmɔ gɛnen mɔ, o kii sii wuruge kyu mɔ-gibaabi ɔ kya ŋmarasɛ gɛsinkpan mɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Gyuda awura nbara aŋmarasɛbo mɔ de Farasii awura mɔ mɛ nu ilaa ibono Yesu gi tɔgɛ sa mɔmɔ gɛnen mɔ, mɛ yaasɛ gɛbelɛnsɛ so gɛkuii-gɛkuii ne i san ɔkyii mɔ wolɛ gi san ɔ yelɛ Yesu asɛ sakpii mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","I san mɔmɔ-wolɛ gɛnen mɔ, Yesu gi koso yelɛ ne ɔ taasɛ ɔkyii mɔ yɛɛ, “Ɔkyii, mɛ bo fonɛ? I mɛŋ nyɛ ɔko de oꞌ bun fo gipuɛɛ?” ");
INSERT INTO acd_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ɔkyii mɔ gi lɛɛ gɛnɔ yɛɛ, “Kuaa, me-wura.” Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Me kee maŋ bun fo gipuɛɛ. Naa fo kya kpe de foꞌ taa fo-ilaa nyɛnyɛn giwɔra yɛgɛ.” ");
INSERT INTO acd_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Me ne n gyɛ fatela sa anyamesɛ. Ɔbono ɔ laa wɔra me-ɔkasɛbo mɔ maŋ naa gibiri dɔ. Ɔ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan de iꞌ wɔra fɛɛ fatela ne n kya wu mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Nfono mɔ Farasii awura mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Fo-wolɛ ne n kya buu faa. I maŋ sa de aꞌ kyu imɔ wɔra ilaa dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Yesu gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Me-wolɛ ne n kya buu gbaa mɔ, i kaaborɛ fɛꞌ nu me asɛ. I kya nyiile yɛɛ me ne n nyi nfono nɛ lii mɔ ne me ne n nyi nfono nan kii kpe mɔ. Fɛye berɛ, fɛ mɛŋ nyi nfono nɛ lii mɔ ne fɛ mɛŋ nyi nfono nan kii kpe mɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ansi so ne fɛ kya kerɛ de fɛꞌ tɔgɛ yɛɛ ɔko ilaa i boran abɛɛ iŋ boran. Me berɛ, meŋ kya kerɛ asa ilaa dɔ tɔgɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Nengyene fɛɛ nꞌ taa tɔgɛ ɔko ilaa gbaa mɔ, nkana i laa kyena. I kya nyiile yɛɛ i mɛŋ gyɛ me-wolɛ ne n kya kerɛ imɔ dɔ. Me‑rɛ me-sɛ ɔbono o sun me mɔ ne n kya kerɛ imɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Fɛye gbaa-gbaa nbara dɔ mɔ, mɛ wolaa ŋmarasɛ yela yɛɛ nengyene fɛɛ asa anyɔ nnɔ gi wɔra gikolon nbɛlɛ dɔ mɔ i kaaborɛ fɛꞌ nu mɔmɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","To, me n kya tɔgɛ me-nyoro so ilaa ne; me-sɛ ɔbono o sun me mɔ kee laa lɛɛ nyiile yɛɛ me-ilaa tɔgɛsɛ idɛ i gyɛ gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Lii gɛnen so mɔ, mɛ taasɛ mɔ yɛɛ, “Fo-sɛ mɔ bo fonɛ?” Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛ mɛŋ nyi me. Me-sɛ ne fɛ laa bii? Nengyene fɛ nyi me mɔ, nkana ɔfaanan fɛ nyi me-sɛ kee.” ");
INSERT INTO acd_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Owi ɔbono Yesu gi tɔgɛ gɛnen agyɛbi adɛ sa mɔmɔ mɔ, o sindi nfono mɛ kya too aterenbi wɔra sa Wurubuaarɛ, ɔson obu gikpaara mɔ so. Ɔko‑rɛ ɔko mɛŋ kii keda mɔ nfono, i kya nyiile yɛɛ mɔ-owi kedasɛ mɛŋ ti fo. ");
INSERT INTO acd_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “N kya kii mi‑i kyon ne. Fɛ laa san laarɛ me de Wurubuaarɛ ɔꞌ baa mɔlɛgɛ fɛye, fɛŋ baa nyɛ. Fɛ laa wuꞌ de fɛye-ilaa nyɛnyɛn daa. Nfono n kya kpe mɔ, fɛ maŋ taalɛ ba nno.” ");
INSERT INTO acd_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nfono mɔ, Gyuda awura abelɛnsɛ mɔ mɛ kya tɔgɛ ma‑a sa abara mɛ kya ŋmasɛ yɛɛ, “Ɔnyen baarɛ tɛ faa, ɔ laa mɔɔ mɔ-nyoro. Fɛ mɛŋ kya nu gɛnɔɔbono ɔ kya kalɛ aye mɔ? Ɔ tɔgɛ yɛɛ nfono ɔ kya kpe mɔ a maŋ taalɛ ba nno.” ");
INSERT INTO acd_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Fɛ lii daa gɛsɛ gɛrɛ. Me berɛ, nɛ lii daa Wurubuaarɛ dɔ. Gɛsinkpan gɛrɛ-lɛɛ wolɛ asa ne fɛ gyɛ. Fɛŋ kya nyingi Wurubuaarɛ so. Me berɛ, meŋ dɛ fɛɛ fɛye gɛnen asa abono ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nɛ ti wolaa tɔgɛ sa fɛye yɛɛ fɛ laa wuꞌ daa de fɛye-ilaa nyɛnyɛn. I gyɛ gɛsintin yɛɛ nengyene fɛ kine fɛ maŋ sɔɔ me gyi yɛɛ me ne n bo no pɛi ne ilaa kamaasɛ i bo no mɔ fɛ laa wuꞌ daa de fɛye-ilaa nyɛnyɛn.” ");
INSERT INTO acd_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Yesu gi tɔgɛ ɔmɔ gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Fo ne n gyɛ anɛ?” Yesu gi lɛɛ gɛnɔ yɛɛ, “Nɛ ti wolaa tɔgɛ fɛye lii ko‑o gɛsɛ de gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","N bo ilaa gikyɔ nan tɔgɛ kyu lii fɛye so de iꞌ kyu bun fɛye gipuɛɛ. Ɔbono o sun me mɔ, mɔ, ne n bo gɛsintin. Ilaa ibono nɛ nu lii mɔ asɛ mɔ wolɛ ne nꞌ kya lɛɛ tɔgɛ sa anyamesɛ.” ");
INSERT INTO acd_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Yesu kya tɔngɛ de ɔmɔ gɛnen pɛwu faa, mɛ mɛŋ nu gɛsɛ yɛɛ mɔ-sɛ Wurubuaarɛ ne ɔ darɛ yɛɛ mɔ ne n sun mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Imɔso Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Nengyene mɛ ti puru me, anyamesɛ pɛwu mɔmɔ-daa mɔ, diirɛ gyan lɛwu oyii so mɔ, nfono ne fɛ laa bii yɛɛ me ne n bo no pɛi ne ilaa kamaasɛ i bo no. Gɛnen kee mɔ fɛ laa bii yɛɛ meŋ kya wɔra ilaa iko abɛɛ nꞌ tɔgɛ ilaa iko me-gibaa so. Ilaa ibono me-sɛ Wurubuaarɛ gi nyiile me mɔ ne nꞌ kya tɔgɛ. ");
INSERT INTO acd_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ɔbono o sun me mɔ bo me asɛ. Ɔ mɛŋ taa me yɛgɛ. I kya nyiile yɛɛ owi kamaasɛ dɔ mɔ, n kya wɔra daa ilaa ibono i kya gyi mɔ-ginsi mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Asa mɔ mɛ nu Yesu gi tɔgɛ gɛnen ilaa idɛ mɔ, mɔmɔ dɔ sakyɔ mɛ sɔɔ mɔ gyi yɛɛ Wurubuaarɛ ne n sun mɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Yesu gi tɔgɛ sa Gyuda awura abono mɛ sɔɔ mɔ gyi mɔ yɛɛ, “Nengyene fɛ keda me-ilaa nyiilesɛ ibono n kya nyiile fɛye faa dɔ mɔ, fɛ gyɛ me-akasɛbo gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Fɛ laa bii Wurubuaarɛ gɛsintin ilaa mɔ, ne gɛnen gɛsintin ilaa ibono mɔ i laa yɛgɛ fɛ laa nyɛ fɛye-nyoro. Fɛŋ baa wɔra nbide.” ");
INSERT INTO acd_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Gyuda awura abelɛnsɛ mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Aberaham mɔ-naanaana ne a gyɛ. Gɛkaako a mɛŋ ti taa wɔra nbide sa ako. Ne nnɛ so ne fo kya tɔgɛ yɛɛ a laa nyɛ aye-nyoro?” ");
INSERT INTO acd_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Nfono mɔ Yesu gi lɛɛ gɛnɔ yɛɛ, “Gɛsintin ne n kya tɔgɛ mi‑i sa fɛye faa, nyamesɛ kamaasɛ ɔbono ɔ kya wɔra ilaa nyɛnyɛn mɔ gyɛ daa gɛbide sa ilaa nyɛnyɛn. ");
INSERT INTO acd_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Gɛbide ne n kine gɛ kɛɛla nnɛ mɔ, gɛ maŋ bingiri gɛmɔ-wura mɔ-bi. Gɛten wura mɔ-bi mɔ berɛ, gyɛ gɛten mɔ dɔ gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Imɔso nengyene me, Wurubuaarɛ mɔ-bi mɔ nɛ yɛgɛ fo ɔko foꞌ nyɛ fo-nyoro lii gɛbide dɔ mɔ, fo nyɛ fo-nyoro gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","N nyi ibono Aberaham mɔ-naanaana ne fɛ gyɛ. Fɛ kii fɛ kya laarɛ me-imɔɔten. I kya nyiile yɛɛ ilaa ibono n kya nyiile mɔ fɛŋ kya nu gɛsɛ sa me. ");
INSERT INTO acd_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ilaa ibono nɛ wu me-sɛ Wurubuaarɛ asɛ mɔ ne nꞌ kya tɔgɛ. Fɛye mɔ kee, ilaa ibono fɛ nu lii fɛye-sɛ asɛ mɔ ne fɛ kya wɔra.” ");
INSERT INTO acd_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Mɛ lɛɛ gɛnɔ yɛɛ, “Aberaham ne n gyɛ daa aye-naana.” Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nengyene fɛɛ Aberaham mɔ-naanaana ne fɛ gyɛ gɛsintin mɔ, nkana fɛ laa wɔra ilaa ibono Aberaham gi wɔra mɔ ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Imɔmɔ mɔ, n kya tɔgɛ gɛsintin gɛbono nɛ nu lii me-sɛ Wurubuaarɛ asɛ n kya sa fɛye mɔ, fɛ kya laarɛ me-imɔɔten daa. Aberaham berɛ mɛŋ wɔra fɛye-lɛɛ idɛ ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ɔbono ɔ gyɛ fɛye-sɛ gbaa-gbaa mɔ ilaa wɔrasɛ mɔ ɔnan ne fɛ kya wɔra faa.” Mɛ lɛɛ gɛnɔ yɛɛ, “Aye berɛ, a mɛŋ gyɛ agyibara nbii. Ɔsɛ kolon ne a bo. Mɔ ne n gyɛ Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nengyene Wurubuaarɛ ne n gyɛ fɛye-sɛ mɔ, nkana fɛ laa laarɛ me-ilaa. Nɛ lii daa Wurubuaarɛ asɛ ne nɛ ba. Wurubuaarɛ ne n sun me. I mɛŋ gyɛ me gbaa-gbaa me-gibaa so ne nɛ ba. ");
INSERT INTO acd_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Menɛ n wɔra ne fɛ mɛŋ kya nu ilaa ibono n kya tɔgɛ mɔ gɛsɛ daa? Fɛ kya kyo me me-ilaa tɔgɛsɛ so. Gɛnen so ne fɛ mɛŋ kya nu me-gɛsɛ faa. ");
INSERT INTO acd_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Fɛ lii fɛye-sɛ ilaa nyɛnyɛn pɛwu gɛmu mɔ asɛ. Imɔso fɛye-gɛlaarɛ ne n gyɛ yɛɛ fɛꞌ wɔra fɛye-sɛ mɔ gɛlaarɛ. Lii ko‑o gɛsɛ de gɛsɛ mɔ, ɔ gyɛ daa ɔbono ɔ kya mɔɔ asa. Mɔ‑rɛ gɛsintin mɛŋ kya wu abara ginsi. Gɛsintin gɛ mɛŋ bo mɔ dɔ. Nengyene ɔ kya kɛɛ abon mɔ, mɔ-ilaa wɔrasɛ ne i wolaa i gyɛ. Mɔ-oyuduu ne. Ɔ gyɛ daa ɔbonbo, ne mɔ ne n gyɛ abon pɛwu gɛmu. ");
INSERT INTO acd_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Me berɛ, n kya tɔgɛ daa gɛsintin. Imɔso ne fɛ mɛŋ kya sɔɔ me gyi faa. ");
INSERT INTO acd_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","“Fɛye dɔ anɛ ne nan taalɛ lɛɛ yii me yɛɛ nɛ wɔra ilaa nyɛnyɛn iko kerɛ? Fɛ nyi ibono gɛsintin ne nꞌ kya tɔgɛ. Ne menɛ n wɔra ne fɛ maŋ sɔɔ me gyi? ");
INSERT INTO acd_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Abono mɛ gyɛ Wurubuaarɛ adɛ mɔ mɛ kya nu Wurubuaarɛ ilaa tɔgɛsɛ. Fɛ mɛŋ gyɛ Wurubuaarɛ adɛ so ne fɛ mɛŋ kya nu Wurubuaarɛ ilaa tɔgɛsɛ faa.” ");
INSERT INTO acd_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Yesu gi tɔgɛ Gyuda awura abelɛnsɛ mɔ gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Iŋ gyɛ a tɔgɛ yɛɛ i tɛ faa fo gyɛ daa Samariyanyen, ilaa nyɛnyɛn oduduu i tɛ fo so, i mɛŋ gyɛ imɔ ne?” ");
INSERT INTO acd_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Nfono ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Ilaa nyɛnyɛn oduduu iŋ taa tɛ me so. N kya kyu buubuu kyu sa me-sɛ Wurubuaarɛ daa, ne fɛye berɛ, fɛ mɛŋ kya buu me. ");
INSERT INTO acd_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nɛ tɔgɛ gɛnen faa, meŋ kya laarɛ nyisigyi mi‑i sa me-nyoro. I bo ɔbono ɔ kya laarɛ nyisigyi ɔ sa me mɔ. Mɔ ne nan gyi me‑rɛ fɛye-nbɛlɛ. ");
INSERT INTO acd_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, ɔbono ɔ kya nu me-gɛdɛ mɔ, maŋ wuꞌ lɛwu gbaa-gbaa gɛkaako kpa‑a.” ");
INSERT INTO acd_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Gyuda awura abelɛnsɛ mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Idɛ kon berɛ, a wu gɛsintin yɛɛ ilaa nyɛnyɛn oduduu i tɛ fo so. Aberaham gi wuꞌ. Wurubuaarɛ ikalan atɔgɛbo mɔ kee mɛ wuꞌ. Fo‑o fo berɛ, fo kya tɔgɛ daa yɛɛ nyamesɛ ɔbono ɔ kya nu fo-gɛdɛ mɔ, maŋ wuꞌ gɛkaako kpa‑a. ");
INSERT INTO acd_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Fo ne n don aye-naana Aberaham? Aberaham gi wuꞌ ne Wurubuaarɛ ikalan atɔgɛbo mɔ kee mɛ wuꞌ. Ne menɛ nyamesɛ ɔnan ne fo kya tɔgɛ yɛɛ fo gyɛ daa?” ");
INSERT INTO acd_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Yesu gi lɛɛ gɛnɔ yɛɛ, “Nengyene fɛɛ n kya lɛɛ me-nyisigyi nyiile asa me-gibaa so mɔ, gɛnen nyisigyi ɔbono mɛŋ gyɛ sɛi. Me-sɛ Wurubuaarɛ ne n kya lɛɛ me-nyisigyi nyiile. Mɔ ne n gyɛ ɔbono fɛ kya ten fɛye-nyoro gɛnɔ yɛɛ fɛye-Wurubuaarɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Yɛgɛ fɛ mɛŋ nyi mɔ. Me berɛ, n nyi mɔ. Nengyene nɛ tɔgɛ yɛɛ meŋ nyi mɔ mɔ, nan wɔra ɔbonbo fɛɛ fɛye. N nyi mɔ, ne nꞌ kya nu mɔ-gɛdɛ. ");
INSERT INTO acd_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","“Fɛye-naana Aberaham gi nu yɛɛ ɔ laa nyɛ wu me-gɛsinkpan so giba mɔ, i wɔra mɔ ɔkon. Ne gɛsintin mɔ, o wu me-giba, ne o gyi ɔkon.” ");
INSERT INTO acd_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Gyuda awura abelɛnsɛ mɔ mɛ taasɛ Yesu yɛɛ, “Fo ɔbono foŋ ti taa gyi nsi ikue-inyɔ de saalaa mɔ, nnɛ ne fo wɔra ne fo‑rɛ Aberaham fɛ wu abara?” ");
INSERT INTO acd_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Nfono mɔ, Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Nꞌ tɔgɛ fɛye gɛsintin yɛɛ pɛi de iꞌ lɔɔ korogɛ Aberaham mɔ, n wolaa n bo no. Me ne n bo no pɛi ne ilaa kamaasɛ i bo no.” ");
INSERT INTO acd_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Ibono Yesu gi tɔgɛ gɛnen so mɔ, mɛ puru abui mɛ laa too da mɔ mɔɔ. O wu gɛnen mɔ, ɔ ŋara lii Wurubuaarɛ ɔson obu gikpaara mɔ so ne ɔ kyon taa mɔmɔ yɛgɛ. ");
INSERT INTO acd_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Yesu gi lii Wurubuaarɛ ɔson obu gikpaara mɔ so ɔ kya kyon mɔ, o wu ɔnyen gyaatanbo ɔko. Mɛ korogɛ mɔ daa de gigyaatanbo mɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Nfono mɔ Yesu akasɛbo mɔ mɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, anɛ ilaa nyɛnyɛn so ne mɛ korogɛ ɔnyen baarɛ de gigyaatanbo faa? Mɔ-sɛ de mɔ-nyi abɛɛ mɔ gbaa-gbaa daa?” ");
INSERT INTO acd_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yesu akasɛbo mɔ mɛ taasɛ mɔ gɛnen mɔ, Yesu gi lɛɛ gɛnɔ yɛɛ, “I mɛŋ gyɛ ɔnyen baarɛ ilaa nyɛnyɛn so, ne i mɛŋ kii i gyɛ mɔ-sɛ abɛɛ mɔ-nyi ilaa nyɛnyɛn so ne mɛ korogɛ mɔ de gigyaatanbo. I ba gɛnen daa de Wurubuaarɛ gɛsun wɔrasɛ mɔ gɛꞌ lii gɛwi kyu naa de ɔnyen mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Aye berɛ, ilaa ibono i kaaborɛ aꞌ wɔra mɔ ne n gyɛ yɛɛ aꞌ kpɛ keda ɔbono o sun me mɔ gɛsun mɔ dɔ aꞌ kpɛ a kya wɔra aberɛ abono a bo nyoro faa. Gɛnyɛ gɛ kya ba. I baa bun wɔra aye mɔ, ɔko‑rɛ ɔko maŋ baa taalɛ wɔra sɛi. ");
INSERT INTO acd_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Aberɛ abono me n san n bo gɛsinkpan so faa, n gyɛ fatela sa gɛsinkpan so anyamesɛ.” ");
INSERT INTO acd_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Yesu gi tɔgɛ gɛnen ta mɔ, ɔ too akyɔlɛ bun yela gɛsinkpan ne ɔ fɔgedɛ wɔra gipatɛɛ ne o kyu bɔ gyaatanbo mɔ ansi. Ɔ bɔ mɔ ta mɔ, ");
INSERT INTO acd_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ɔ tɔgɛ sa mɔ yɛɛ, “Naa kpaa foro fo-ansi Silowam gibun dɔ.” (Silowam gɛsɛ ne n gyɛ yɛɛ abunge.) Ɔnyen mɔ gi naa kpaa foro mɔ-ansi ne ɔ lii nfono mɔ, mɔ-ansi mɔ a bugi. Idɛ kon mɔ, ɔ san ɔ kya wu. ");
INSERT INTO acd_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Asa abono mɔmɔ‑rɛ gyaatanbo mɔ-lɛɛ nten gi sindi abara mɔ de abono pɛwu nkana mɛ nyi mɔ yɛɛ ɔ kya kyena kolɛ aterenbi mɔ, mɛ san mɛ kya taasɛ abara yɛɛ, “I mɛŋ gyɛ ɔnyen baarɛ ne n kya kyena ikpa nkan-nkan kolɛ aterenbi mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Asa ako mɛ kyule yɛɛ, “Ɛn, mɔ ne.” Ne mɔmɔ ako mɔ yɛɛ, “Kuaa, i mɛŋ gyɛ mɔ ne. Ɔ lii mɔ daa.” Mɛ kya sɔɔ abara akyɔɔlɛ gɛnen mɔ, ɔnyen mɔ gbaa-gbaa gi tɔgɛ sa ɔmɔ yɛɛ, “Me ne.” ");
INSERT INTO acd_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Imɔso asa mɔ mɛ taasɛ mɔ yɛɛ, “Ne nnɛ ne fo-ansi mɔ a wɔra ne a bugi?” ");
INSERT INTO acd_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ɔ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Ɔnyen ɔbono mɛ kya terɛ mɔ yɛɛ Yesu mɔ ne n wɔra gipatɛɛ ne o kyu bɔ me-ansi ne ɔ tɔgɛ sa me yɛɛ, ‘Naa kpaa foro fo-ansi Silowam gibun dɔ.’ Gɛsintin mɔ, nɛ naa kpaa foro me-ansi mɔ, me-ansi a bugi. Imɔ ne nɛ nyɛ n kya wu faa.” ");
INSERT INTO acd_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Ɔnyen mɔ gi tɔgɛ sa asa mɔ gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Ɔ bo fonɛ dɔ?” Ne ɔ lɛɛ gɛnɔ yɛɛ, “Meŋ nyi.” ");
INSERT INTO acd_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nfono mɔ, asa mɔ mɛ kyu ɔnyen mɔ kpe Farasii awura mɔ ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Gɛkɛ gɛbono Yesu gi wɔra gipatɛɛ mɔ kyu bugi gyaatanbo baarɛ ansi mɔ, gɛnen gɛkɛ gɛbono gɛ gyɛ mɔmɔ Gyuda awura gɛkɛ kyoolasɛ. ");
INSERT INTO acd_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Asa mɔ mɛ kyu ɔnyen mɔ kperɛ Farasii awura mɔ gɛnen mɔ, Farasii awura mɔ kee mɛ taasɛ mɔ gɛnɔɔbono i ba ne mɔ-ansi a bugi ne ɔ nyɛ ɔ kya wu mɔ. Ɔnyen mɔ gi buu sa mɔmɔ yɛɛ, “O kyu gipatɛɛ kyu bɔ me-ansi ne nɛ kpaa foro me-ansi ne a bugi ne nɛ nyɛ n kya wu faa.” ");
INSERT INTO acd_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Ɔnyen mɔ gi buu sa Farasii awura mɔ gɛnen mɔ, mɔmɔ ako mɛ tɔgɛ yɛɛ, “Ɔnyen ɔbono ɔ wɔra gɛnen ilaa idɛ faa, i mɛŋ gyɛ Wurubuaarɛ ne n sun mɔ. I kya nyiile yɛɛ ɔ mɛŋ kya gyi Wurubuaarɛ gɛkɛ kyoolasɛ nbara mɔ so.” Mɔmɔ ako mɔ yɛɛ, “Nengyene ɔ gyɛ ilaa nyɛnyɛn ɔwɔrabo mɔ, nnɛ so ne ɔ laa taalɛ wɔra amunale ilaa idɛ ɔnan?” Mɔmɔ pɛwu nnɔ gi wɔra kpɛi-kpɛi. ");
INSERT INTO acd_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Nfono mɔ, Farasii awura mɔ mɛ kii taasɛ ɔnyen mɔ yɛɛ, “Fo‑o fo mɔ, fo-ansi ne o bugi sa fo mɔ. Imɔso menɛ ilaa ne fo bo fo laa tɔgɛ kyu lii mɔ so?” Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Ɔ gyɛ daa Wurubuaarɛ ikalan ɔtɔgɛbo.” ");
INSERT INTO acd_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Imɔ idɛ gɛmara pɛwu mɔ, Gyuda awura abelɛnsɛ mɔ mɛ mɛŋ sɔɔ gyi yɛɛ i gyɛ gɛsintin fɛɛ nkana gɛnen ɔnyen baarɛ gyɛ daa gyaatanbo. Imɔso mɛ sun kpaa terɛ mɔ-nyi de mɔ-sɛ, ");
INSERT INTO acd_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ne mɛ taasɛ mɔmɔ yɛɛ, “Fɛye-bi ɔbono fɛ kya tɔgɛ yɛɛ fɛ korogɛ mɔ de gigyaatanbo mɔ ne? Ne menɛ n wɔra ne mɔ-ansi a bugi ne ɔ kya wu kon?” ");
INSERT INTO acd_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Nfono mɔ, ɔnyen mɔ mɔ-sɛ de mɔ-nyi mɛ lɛɛ gɛnɔ yɛɛ, “A nyi ibono aye-bi ne. A korogɛ mɔ de gigyaatanbo daa. ");
INSERT INTO acd_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","To, gɛnɔɔbono i ba ne idɛ kon ɔ kya wu faa berɛ, aye a maŋ taalɛ bii. A mɛŋ kii a nyi nyamesɛ kolon ɔbono o bugi mɔ-ansi mɔ. Ɔ mɛŋ baa ɔ gyɛ gɛbii. Fɛꞌ taasɛ mɔ gbaa-gbaa. Ɔ laa taalɛ tɔngɛ sa mɔ-nyoro.” ");
INSERT INTO acd_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Gyuda awura abelɛnsɛ mɔ gifuu so‑o so ne n yɛgɛ ne ɔnyen mɔ mɔ-nyi de mɔ-sɛ mɛ tɔgɛ gɛnen. I kya nyiile yɛɛ Gyuda awura abelɛnsɛ mɔ mɛ ti tɔgɛ yela yɛɛ ɔbono ɔ laa lɛɛ tɔgɛ sansana yɛɛ Yesu ne n gyɛ ɔmɔlɛgɛbo ɔbono Wurubuaarɛ gi tɔgɛ yɛɛ ɔ laa sun ne mɛ nu mɔ, mɛ laa tii kaasɛ yɛɛ mɔ-giyaa gi maŋ baa nyɛ yii mɔmɔ-gikyangbon dɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Gɛnen ilaa ibono so ne mɛ tɔgɛ sa Gyuda awura abelɛnsɛ mɔ yɛɛ, “Ɔ mɛŋ baa ɔ gyɛ gɛbii. Fɛꞌ taasɛ mɔ gbaa-gbaa” mɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Nfono mɔ, abelɛnsɛ mɔ mɛ kii terɛ ɔnyen mɔ nkana ɔ gyɛ gyaatanbo mɔ ba mɔmɔ asɛ ginyɔsɛ, ne mɛ tɔgɛ mɔ yɛɛ, “Kerɛ fɛɛ Wurubuaarɛ de foꞌ tɔgɛ gɛsintin gɛbono fo nyi mɔ. Aye berɛ, a nyi ibono gɛnen ɔnyen baarɛ gyɛ daa ilaa nyɛnyɛn ɔwɔrabo.” ");
INSERT INTO acd_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mɛ tɔgɛ sa mɔ gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Me ne yɛɛ ɔ gyɛ ilaa nyɛnyɛn ɔwɔrabo abɛɛ fɛye daa? Ilaa kolon ibono n nyi mɔ ne n gyɛ yɛɛ nkana n gyɛ daa gyaatanbo, ne idɛ kon mɔ n kya wu ilaa.” ");
INSERT INTO acd_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Ɔ tɔgɛ gɛnen mɔ, mɛ kii taasɛ mɔ yɛɛ, “Menɛ ne o kyu wɔra fo? Nnɛ so nnɛ so ne ɔ wɔra ne o bugi fo-ansi mɔ sa fo daa?” ");
INSERT INTO acd_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Nɛ ti wolaa buu sa fɛye gɛnɔɔbono i ba mɔ, ne fɛ mɛŋ nu me asɛ. Menɛ ne fɛ kii fɛ kya laarɛ de fɛꞌ kii nu? Abɛɛ fɛye kee fɛ kya laarɛ fɛɛ fɛꞌ baa wɔra mɔ-akasɛbo daa?” ");
INSERT INTO acd_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Ɔnyen mɔ gi taasɛ mɔmɔ gɛnen mɔ, mɛ tɔrɔ loo mɔ-asebi dɔ, ne mɛ tɔgɛ sa mɔ yɛɛ, “Fo ne n gyɛ mɔ-ɔkasɛbo. Aye berɛ, a gyɛ daa Mosisi-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","A nyi ibono Wurubuaarɛ gi tɔngɛ sa Mosisi. Gɛnen ɔnyen baarɛ berɛ, a mɛŋ nyi nfono ɔ lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Gɛnen berɛ mɔ, i gyɛ ilaa ibono i kya dɛ gɛnɔ ne. Fɛye yɛɛ fɛ mɛŋ nyi nfono ɔ lii mɔ. Mɔ, mɔ ne n kii bugi me-ansi sa me faa. ");
INSERT INTO acd_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","A nyi ibono Wurubuaarɛ mɛŋ kya nu ilaa nyɛnyɛn awɔrabo ndalaa. Nyamesɛ ɔbono ɔ kya selɛ mɔ Wurubuaarɛ, ne ɔ kya wɔra mɔ-gɛlaarɛ ilaa mɔ, gɛnen kaasɛ ɔbono ne Wurubuaarɛ kya nu mɔ-gɛdalaa. ");
INSERT INTO acd_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kpɛ kyu lii ko‑o ibono Wurubuaarɛ gi lɛɛ soso de gɛsɛ baa fo gɛnen owi baarɛ faa, a mɛŋ ti taa nu yɛɛ nyamesɛ ɔko gi ti taalɛ bugi gyaatanbo ɔbono mɛ korogɛ mɔ de gigyaatanbo mɔ ansi gɛkaako kerɛ. ");
INSERT INTO acd_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Imɔso, nengyene i mɛŋ gyɛ Wurubuaarɛ ne n sun gɛnen ɔnyen baarɛ mɔ, nkana ɔfaanan ɔ mɛnaŋ taalɛ wɔra sɛi.” ");
INSERT INTO acd_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Ɔnyen mɔ gi tɔgɛ gɛnen ta mɔ, Gyuda awura abelɛnsɛ mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Fo ɔbono i korogɛ fo de gibusafo mɔ, fo ne nan kii baa nyiile aye ilaa?” Nfono ne mɛ tii mɔ yɛɛ mɔ-giyaa gi maŋ baa nyɛ yii mɔmɔ-gikyangbon dɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Yesu gi nu yɛɛ Gyuda awura abelɛnsɛ mɔ mɛ tii ɔnyen mɔ gɛnen mɔ, ɔ kpaa wu ɔnyen mɔ, ne ɔ taasɛ mɔ yɛɛ, “Fo sɔɔ anyamesɛ pɛwu mɔmɔ-daa mɔ gyi?” ");
INSERT INTO acd_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ɔnyen mɔ gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, anyamesɛ pɛwu mɔmɔ-daa mɔ ne n gyɛ anɛ? Nyiile me mɔ de nꞌ sɔɔ mɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yesu gi tɔgɛ mɔ yɛɛ, “Fo ti wu mɔ ne. Mɔ ne n kya tɔngɛ de fo faa.” ");
INSERT INTO acd_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Nfono mɔ, ɔnyen mɔ gi tɔgɛ sa Yesu yɛɛ, “Me-wura, nɛ sɔɔ gyi,” ne o ŋmii mɔ ne o kyu buubuu sa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Nfono mɔ Yesu gi tɔgɛ yɛɛ, “Nɛ ba gɛsinkpan so daa de iꞌ baragɛ anyamesɛ dɔ de asa abono iŋ kya wu ɔmɔ mɔ, mɛꞌ nyɛ wu ilaa, de abono, mɔ, mɛ kya wu mɔ, mɛꞌ bingiri agyaatanbo.” ");
INSERT INTO acd_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Farasii awura abono mɛ bo Yesu asɛ nfono mɔ mɛ nu ibono Yesu gi tɔgɛ gɛnen mɔ, mɛ taasɛ mɔ yɛɛ, “Aye ne n gyɛ agyaatanbo mɔ faa?” ");
INSERT INTO acd_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ne ɔ lɛɛ gɛnɔ yɛɛ, “Nengyene fɛ gyɛ agyaatanbo mɔ, nkana fɛ maŋ gyi gipuɛɛ. To, ibono mɔ, fɛ kya tɔgɛ yɛɛ fɛ kya wu faa, fɛye-gipuɛɛ mɔ gi sii de fɛye.” ");
INSERT INTO acd_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Yesu gi da gikpalɛ sa mɔmɔ yɛɛ, “N kya tɔgɛ fɛye gɛsintin, nyamesɛ ɔbono ɔ mɛŋ kyu de gɛbunono so kyu loo isandɛ gɛkpen mɔ dɔ ne ɔ kpaa dii de gɛtɛɛko so kyu loo mɔ, gɛnen kaasɛ ɔbono gyɛ daa oyu abɛɛ ɔ kya laarɛ ɔꞌ kpaa yuuri gɛyu pinini daa. ");
INSERT INTO acd_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ne nyamesɛ ɔbono, mɔ, o kyu de gɛbunono so kyu loo isandɛ gɛkpen mɔ dɔ mɔ ne n gyɛ isandɛ mɔ ɔkparɛbo. ");
INSERT INTO acd_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Isandɛ ɔkparɛbo mɔ kya naa kpe gɛbunono asɛ ne ɔbono ɔ kya dii isandɛ gɛbunono mɔ kya tigi gisen sa mɔ de ɔꞌ loo. Ɔ kya terɛ mɔ-isandɛ mɔ ɔkamaasɛ mɔ‑rɛ mɔ-ginyen de oꞌ kyu mɔmɔ kyu kpe gigyi. ");
INSERT INTO acd_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Ɔkparɛbo mɔ gi kparɛ mɔ-isandɛ mɔ lii gɛkpen mɔ dɔ mɔ, ɔ kya gyangbara sa mɔmɔ de mɛꞌ buu mɔ. I kya nyiile yɛɛ mɛ kya bii mɔ-gɛnɔ de mɛꞌ nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Isa ɔko giyan berɛ, mɛ maŋ kyule naa buu mɔ. Mɛ laa selɛ taa mɔ yɛgɛ. I kya nyiile yɛɛ mɛ mɛŋ kya bii mɔ-gɛnɔ de mɛꞌ nu mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Yesu gi da Gyuda awura abelɛnsɛ mɔ gikpalɛ gɛnen mɔ, mɛ mɛŋ nu gimɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Gɛnen so mɔ, o kii tɔgɛ yɛɛ, “N kya tɔgɛ fɛye gɛsintin. Me ne n gyɛ isandɛ gɛkpen mɔ gɛbunono mɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Mɔmɔ abono pɛwu mɛ da gibaa wɔra fɛɛ me-lɛɛ ɔnan mɔ, mɛ dɛ daa fɛɛ iyu abɛɛ abono mɛ kya yuuri gɛyu pinini mɔ. Isandɛ mɔ mɛ mɛŋ ka mɔmɔ abono gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Me n dɛ fɛɛ gɛkpen gɛbunono mɔ. Nengyene ɔko laa naa de me so kyu loo mɔ, gɛnen kaasɛ ɔbono laa nyɛ amɔlɛgɛ. Ɔ laa loo de ɔꞌ lii owi kamaasɛ ɔbono ɔ kya laarɛ mɔ de ɔꞌ nyɛ ogyiten. ");
INSERT INTO acd_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Iyu mɔ mɛ ba daa de mɛꞌ baa yuuri, mɛꞌ mɔɔ de mɛꞌ nyida. Mi‑i me berɛ, nɛ ba daa de nꞌ yɛgɛ asa mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Me ne n gyɛ isandɛ ɔkparɛbo dɛnsɛ mɔ. Ɔbono ɔ gyɛ isandɛ ɔkparɛbo dɛnsɛ mɔ ne n kya kyu mɔ-nyoro fuɛ de ɔꞌ sɔɔ mɔ-isandɛ lɛwu. ");
INSERT INTO acd_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ɔbono ɔ kya kparɛ isandɛ de mɛꞌ ka mɔ gikɔ mɔ berɛ, i mɛŋ gyɛ mɔ ne n bo isandɛ mɔ. Nengyene o wu fɛɛ kuntun kya ba isandɛ mɔ dɔ mɔ, ɔ laa selɛ taa isandɛ mɔ yɛgɛ de kuntun mɔ ɔꞌ baa keda isandɛ mɔ, de ɔꞌ yaasɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ibono so ɔ kya selɛ taa isandɛ mɔ yɛgɛ gɛnen mɔ ne n gyɛ yɛɛ ɔ kya kerɛ mɔmɔ so daa de mɛꞌ ka mɔ gikɔ. Isandɛ mɔ ilaa i mɛŋ tiri mɔ de sɛi. ");
INSERT INTO acd_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","“Me ne n gyɛ isandɛ ɔkparɛbo dɛnsɛ mɔ. N nyi me-isandɛ ne me-isandɛ, mɔ, kee mɛ nyi me, ");
INSERT INTO acd_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","fɛɛ gɛnɔɔbono me-sɛ Wurubuaarɛ nyi me ne me kee n nyi mɔ mɔ. Nan kyu me-nyoro fuɛ de nꞌ sɔɔ me-isandɛ mɔ lɛwu. ");
INSERT INTO acd_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","N bo isandɛ iko kee nten nko. Mɔmɔ abono mɛ mɛŋ bo gikpen gidɛ dɔ. I kaaborɛ nꞌ kyu mɔmɔ ba kee de mɛꞌ nu me asɛ de mɛꞌ wɔra isandɛ gikpen kolon de mɛꞌ nyɛ isandɛ ɔkparɛbo kolon. ");
INSERT INTO acd_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Wurubuaarɛ kya laarɛ me-ilaa. I kya nyiile yɛɛ nan kyu me-nkpa fuɛ de nꞌ kii kpaa kyu. ");
INSERT INTO acd_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Ɔko maŋ sɔgɛ me-nkpa lii me-abaa dɔ. Me gbaa-gbaa me-gibaa so ne nꞌ kya kyu me-nkpa kyu fuɛ. N bo ɔkpa de nꞌ kyu me-nkpa fuɛ ne nꞌ bo ɔkpa de nꞌ kii kpaa kyu me-gibaa so. Gɛnen ne me-sɛ Wurubuaarɛ gi ka sa me ne.” ");
INSERT INTO acd_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Ilaa ibono Yesu gi tɔgɛ faa so mɔ, i yɛgɛ Gyuda awura abelɛnsɛ mɔ nwɔnsa nbono mɛ kya sa kyu lii mɔ so mɔ gi kii wɔra kpɛi-kpɛi. ");
INSERT INTO acd_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Asa mɔ dɔ sakyɔ mɛ kya tɔgɛ yɛɛ, “Ilaa nyɛnyɛn oduduu i tɛ Yesu so. Ɔ kya lɔ giyee daa. Ma‑a nuꞌ ɔdɛ asɛ?” ");
INSERT INTO acd_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Mɔmɔ ako mɔ yɛɛ, “I mɛŋ gyɛ isa ɔbono ɔnan ilaa nyɛnyɛn oduduu i tɛ mɔ so mɔ atɔngɛbi ne. Nnɛ so ne ilaa nyɛnyɛn oduduu i laa taalɛ bugi agyaatanbo ansi?” ");
INSERT INTO acd_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Owi ɔko dɔ mɔ Yesu bo Gyɛrusalem, ne owi gi fo ibono Gyuda awura mɔ mɛ kya gyi gɛkɛ belɛ kyu nyingi gɛnɔɔbono mɛ lɔrɔ Wurubuaarɛ ɔson obu mɔ yela sa mɔ-ɔson mɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Gɛnen owi ɔbono mɔ, i gyɛ awo aberɛ. Yesu naa de Wurubuaarɛ ɔson obu gikpaara mɔ so gɛsalaga gɛbono mɛ kya terɛ gɛmɔ yɛɛ Solomon gɛsalaga mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nfono mɔ, Gyuda awura abelɛnsɛ mɔ mɛ baa kyaabɔɔ Yesu ne mɛ taasɛ mɔ yɛɛ, “Fo kya laarɛ aꞌ kyena kpaa fo owi ɔmɔ daa? Nengyene fo ne n gyɛ ɔbono Wurubuaarɛ gi sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ, tɛsɛ tɔgɛ tigi aye.” ");
INSERT INTO acd_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Mɛ taasɛ Yesu gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Nɛ wolaa tɔgɛ sa fɛye. Fɛŋ sɔɔ me gyi daa. Ilaa gbaaꞌgbaa ibono n dɛ me-sɛ Wurubuaarɛ ginyen n kya wɔra mɔ ne n kya lɛɛ nyamesɛ ɔbono ɔnan n gyɛ mɔ gɛwi nyiile. ");
INSERT INTO acd_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Fɛye mɔ, fɛ mɛŋ kii sɔɔ me gyi. I kya nyiile yɛɛ fɛŋ gyɛ me-isandɛ. ");
INSERT INTO acd_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","“Isandɛ ibono i gyɛ me-lɛɛ mɔ, mɛ kya nu me-gɛdɛ. N nyi mɔmɔ ne mɛ kya naa buu me. ");
INSERT INTO acd_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","N kya sa mɔmɔ Wurubuaarɛ asɛ gɛkyena gɛkpaa. Iŋ bo no yɛɛ mɔmɔ dɔ ɔko laa fuɛ mɔ-lɛwu gɛmara. Ɔko mɛŋ bo no ɔ laa sɔgɛ mɔmɔ lii me-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Me-sɛ Wurubuaarɛ ɔbono o kyu mɔmɔ sa me mɔ bo lon don ilaa kamaasɛ. Ne ɔko mɛŋ bo no, ɔ laa taalɛ sɔgɛ mɔmɔ lii me-sɛ Wurubuaarɛ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Me‑rɛ me-sɛ Wurubuaarɛ mɔ a gyɛ daa gikolon.” ");
INSERT INTO acd_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Ibono Yesu gi tɔgɛ gɛnen ta mɔ, Gyuda awura abelɛnsɛ mɔ mɛ kii puru abui mɛ laa da mɔ mɔɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Wurubuaarɛ gi yɛgɛ nɛ wɔra ilaa gbaaꞌgbaa fɛye-ansi so. Imɔ imɔmɔ so ne fɛ kya laarɛ de fɛꞌ da me abui faa?” ");
INSERT INTO acd_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Gyuda awura abelɛnsɛ mɔ mɛ lɛɛ gɛnɔ yɛɛ, “I mɛŋ gyɛ ilaa gbaaꞌgbaa ibono fo wɔra mɔ so ne a kya laarɛ de aꞌ da fo abui mɔɔ. Ibono fo kya kyu fo-nyoro kɛserɛ de Wurubuaarɛ mɔ so ne a kya laarɛ de aꞌ mɔɔ fo gɛnen. Fo gyɛ daa nyamesɛ ne fo kya kyu fo-nyoro yɛɛ fo gyɛ Wurubuaarɛ.” ");
INSERT INTO acd_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Yesu gi kii taasɛ ɔmɔ yɛɛ, “Mɛ mɛŋ ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ yɛɛ, Wurubuaarɛ gi tɔgɛ yɛɛ fɛ gyɛ Wurubuaarɛ ɔnan? ");
INSERT INTO acd_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Wurubuaarɛ agyɛbi mɔ berɛ, a mɛŋ kya kɛɛ abon gɛkaako. Asa abono mɛ nyɛ Wurubuaarɛ gi tɔngɛ sa mɔmɔ mɔ gbaa ne Wurubuaarɛ gi terɛ mɔmɔ yɛɛ mɛ gyɛ Wurubuaarɛ ɔnan faa. ");
INSERT INTO acd_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ne me, ɔbono me-sɛ Wurubuaarɛ gi lɔrɔ me yela sa mɔ-nyoro ne o sun me ba gɛsinkpan so mɔ, n kya tɔgɛ yɛɛ ‘N gyɛ Wurubuaarɛ mɔ-bi’ mɔ, nnɛ so ne fo laa tɔgɛ yɛɛ n dɛ me-nyoro mi‑i kɛserɛ de Wurubuaarɛ? ");
INSERT INTO acd_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","“Nengyene fɛɛ fɛ wu yɛɛ meŋ kya wɔra ilaa ibono i gyɛ me-sɛ Wurubuaarɛ ilaa wɔrasɛ mɔ, fɛŋ sa fɛꞌ sɔɔ me gyi. ");
INSERT INTO acd_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Ne fɛɛ fɛ wu yɛɛ n kya wɔra imɔ berɛ mɔ, ba‑a ne fɛ maŋ sɔɔ me gbaa-gbaa gyi mɔ, fɛꞌ sɔɔ me-sɛ ilaa wɔrasɛ ibono n kya wɔra mɔ gyi de fɛꞌ nu gɛsɛ de fɛꞌ bii yɛɛ Wurubuaarɛ bo me dɔ ne me kee n bo mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Yesu gi tɔgɛ gɛnen mɔ, asa mɔ mɛ kii laarɛ fɛɛ mɛꞌ keda mɔ. Mɛ mɛŋ nyɛ mɔ. Ɔ lii mɔmɔ-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Yesu gi kii naa foro Gyɔɔdan ɔbon mɔ, ne ɔ san kpaa kyena nfono Gyɔn gi naa kyena gyere asa Wurubuaarɛ sagyere mɔ. ");
INSERT INTO acd_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Asa sakyɔ mɛ kya kpe mɔ asɛ nno. Mɛ kya tɔgɛ yɛɛ, “Gyɔn mɛŋ wɔra ilaa lɛɛnyiilesɛ iko. Ilaa kamaasɛ ibono ɔ tɔgɛ kyu lii ɔnyen baarɛ so mɔ berɛ, i gyɛ gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Imɔso asa sakyɔ mɛ sɔɔ Yesu gyi nno. ");
INSERT INTO acd_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Gɛnen owi ɔbono dɔ mɔ ɔnyen ɔko kya lɔ gɛnsipɛɛrɛ so. Mɛ kya terɛ mɔ yɛɛ Lasarosɛ. Ɔ gyɛ Bɛtaninyen. (Bɛtani ɔsowolɛ baarɛ gyɛ Mariya de mɔ-daa Maata gɛwi. ");
INSERT INTO acd_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Mariya ne n gyɛ ɔkyii ɔbono fɛ nu yɛɛ o kyu anuwanterɛ worogɛ Yesu ne o kyu mɔ-gimu iman kpaarɛ Yesu ayaa mɔ. Gɛnen Mariya baarɛ mɔ-pinyen ne n gyɛ Lasarosɛ ɔbono ɔ kya lɔ mɔ.) ");
INSERT INTO acd_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Ɔ kya lɔ gɛnen mɔ, mɔ-pikyiiana adɛ mɛ sun kpaa tɔgɛ sa Yesu yɛɛ, “Aye-wura, fo-kyɛmenɛ ɔbono fo kya laarɛ mɔ-ilaa mɔ kya lɔ.” ");
INSERT INTO acd_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Yesu gi nu gɛnen mɔ, ɔ tɔgɛ yɛɛ, “Gilɔ gidɛ giŋ ba de giꞌ baa mɔɔ Lasarosɛ. Gi ba daa de giꞌ baa lɛɛ Wurubuaarɛ nyisigyi mɔ nyiile de Wurubuaarɛ ɔꞌ lɛɛ me, Wurubuaarɛ mɔ-bi mɔ nyisigyi mɔ kee nyiile.” ");
INSERT INTO acd_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Yesu kya laarɛ Maata de mɔ-tedɛ de mɔmɔ-pinyen Lasarosɛ ilaa. ");
INSERT INTO acd_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Imɔ‑rɛ imɔ gɛnen mɔ, o nu Lasarosɛ gilɔ mɔ so mɔ, o sii kyena nfono ɔ bo mɔ nkɛ nnyɔ bɔla. ");
INSERT INTO acd_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Imɔ gɛmara mɔ, Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Aꞌ kii kpe Gyudiya.” ");
INSERT INTO acd_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Ɔ tɔgɛ ɔmɔ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, Gyuda awura abelɛnsɛ mɔ mɛ laarɛ de mɛꞌ da fo abui mɔɔ faa, iŋ ti gyi nkɛ nko. Fo laa kii kpe nno?” ");
INSERT INTO acd_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Yesu akasɛbo mɔ mɛ taasɛ mɔ gɛnen mɔ, o kisee da mɔmɔ gikpalɛ de oꞌ kyu nyiile mɔmɔ yɛɛ gɛnen owi ɔbono dɔ mɔ iŋ bo gifuu. Ɔ da gikpalɛ mɔ yɛɛ, “Iŋ gyɛ iwi gudu inyɔ ne n bo gɛkɛ dɔ? Nyamesɛ ɔbono ɔ naa owi kenken mɔ, mɛŋ kya sidi. I kya nyiile yɛɛ gɛsinkpan gɛdɛ so fatela kya wu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ne ɔbono, mɔ, ɔ naa gɛnyɛ mɔ kya sidi. I kya nyiile yɛɛ ɔŋ bo fatela mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Yesu gi tɔgɛ gɛnen mɔ ne o kii tɔgɛ sa mɔmɔ yɛɛ, “Aye-kyɛmenɛ Lasarosɛ gi dɛ. Nan kpaa kyingi mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Nfono mɔ, mɔ-akasɛbo mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, nengyene ɔ dɛ ginsi gidɛ berɛ mɔ, ɔ laa nyɛ alanfiya ne.” ");
INSERT INTO acd_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Yesu akasɛbo mɔ mɛ mɛŋ bii yɛɛ ɔ kya tɔgɛ kyu lii Lasarosɛ lɛwu so daa. Mɛ nyi daa yɛɛ ginsi gidɛ gbaa-gbaa ne ɔ darɛ. ");
INSERT INTO acd_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Nfono ne Yesu gi tɔgɛ tigi mɔmɔ yɛɛ, “Lasarosɛ gi wuꞌ. ");
INSERT INTO acd_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Fɛye so mɔ, i wɔra me ɔkon fɛɛ meŋ bo nno pɛi ne o wuꞌ de fɛꞌ nyɛ sɔɔ me gyi. Imɔso fɛꞌ yɛgɛ de aꞌ kpe mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Nfono mɔ, Tomaasɛ ɔbono mɛ kya terɛ mɔ yɛɛ Ata mɔ gi tɔgɛ sa mɔ-nanboana mɔ yɛɛ, “Aye‑rɛ mɔ pɛwu aꞌ kpe. Nengyene i gyɛ lɛwu mɔ, aye‑rɛ Yesu pɛwu aꞌ kpe de aꞌ kpaa wuꞌ.” ");
INSERT INTO acd_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Yesu gi kpaa loo nno mɔ, o nu yɛɛ Lasarosɛ gi wuꞌ. O wuꞌ ne mɛ pule mɔ mɔ, imɔ nkɛ nnan ne. ");
INSERT INTO acd_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Bɛtani ɔsowolɛ mɔ de Gyɛrusalem i mɛŋ bo gɛta de abara. I maŋ fo akpaaten anyɔ dandan. ");
INSERT INTO acd_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Imɔso i yɛgɛ Gyuda awura mɔ asa sakyɔ mɛ kpe Maata de Mariya asɛ de mɛꞌ kpaa tɔgɛ wɔra mɔmɔ kyu lii mɔmɔ-pinyen lɛwu mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Maata gi nu Yesu so mɔ, ɔ lii kyon ɔꞌ kpaa gyangara mɔ, yɛgɛ Mariya, mɔ, tɛ gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Maata gi wu Yesu mɔ, ɔ tɔgɛ sa mɔ yɛɛ, “Me-Wura, ne fɛɛ fo bo gɛrɛ mɔ, nkana me-pinyen ɔ mɛŋnan wuꞌ. ");
INSERT INTO acd_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Imɔ‑rɛ imɔ gɛnen gbaa faa, n nyi yɛɛ ba‑a nperɛ, ilaa kamaasɛ ibono fo kolɛ lii Wurubuaarɛ asɛ mɔ ɔ laa kyu sa fo.” ");
INSERT INTO acd_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Yesu gi tɔgɛ sa mɔ yɛɛ, “Fo-pinyen laa kii kyingi kyena nkpa.” ");
INSERT INTO acd_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Maata gi kyule mɔ yɛɛ, “N nyi ibono me-pinyen laa kii nyɛ nkpa gɛkɛ laalaalogɛsɛ gɛbono Wurubuaarɛ laa kyingi ibuni de oꞌ gyi ɔmɔ-nbɛlɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Nfono mɔ, Yesu gi kii lɔrɔ tɔgɛ sa Maata yɛɛ, “Me ne n gyɛ ɔbono n bo ɔkpa de nꞌ kyingi asa abono mɛ wuꞌ mɔ. Me ne n gyɛ ɔbono n kya sa asa Wurubuaarɛ asɛ gɛkyena ɔnan mɔ. Nyamesɛ ɔbono o kyu mɔ-nyoro too me so mɔ, ba‑a o wuꞌ mɔ, ɔ laa kyena Wurubuaarɛ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Ne nyamesɛ kamaasɛ ɔbono ɔ tɛ ne o kyu mɔ-nyoro too me so mɔ, mɔ-Wurubuaarɛ asɛ gɛkyena ɔnan mɔ gɛ maŋ lii mɔ-gibaa kpa‑a. Maata, fo kya sɔɔ ilaa idɛ gyi?” ");
INSERT INTO acd_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Maata gi lɛɛ gɛnɔ yɛɛ, “Ɛɛn, me-wura. Nɛ sɔɔ gyi yɛɛ fo ne n gyɛ ɔbono Wurubuaarɛ gi sun de foꞌ baa mɔlɛgɛ anyamesɛ mɔ. Fo ne n gyɛ Wurubuaarɛ mɔ-bi ɔbono aye-ansi a gyan mɔ so yɛɛ ɔ laa kpelegɛ lii Wurubuaarɛ dɔ ba gɛsinkpan so mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Maata gi tɔgɛ Yesu gɛnen ta mɔ, ɔ kpaa terɛ mɔ-tedɛ Mariya lii nkan ne ɔ tɔgɛ mɔ yɛɛ, “Ɔbelɛnsɛ mɔ gi ba, ɔ bo faanaa, ɔ kya terɛ fo.” ");
INSERT INTO acd_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Mariya gi nu gɛnen mɔ, ɔ kpɛ koso daa ne ɔ lii kpaa gyangara mɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Gɛnen owi ɔbono mɔ, Yesu mɛŋ ti loo ɔsowolɛ mɔ gbaa-gbaa so. Ɔ san ɔ bo nfono Maata gi kpaa gyangara mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Gyuda awura abono mɛ bo Mariya asɛ gɛten mɔ dɔ mɔ mɛ kya tɔgɛ ma‑a wɔra mɔ mɔ, mɛ wu gɛnɔɔbono Mariya gi kpɛ nyise koso lii gɛnen mɔ, mɛ nyi fɛɛ ɔ kya kpe nfono mɛ pule mɔ-pinyen mɔ ɔꞌ kpaa saawo daa. Imɔso mɛ buu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Mariya gi kpaa fo nfono Yesu bo mɔ, ɔ da de ginsi wu mɔ mɔ, ɔ kpelegɛ ŋmii mɔ-ayaa dɔ ne ɔ tɔgɛ sa mɔ yɛɛ, “Me-Wura, nengyene fɛɛ fo bo gɛrɛ daa mɔ, nkana me-pinyen ɔ mɛŋnan wuꞌ.” ");
INSERT INTO acd_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Ibono Yesu gi wu gɛnɔɔbono Mariya kya saawo de Gyuda awura abono mɛ buu mɔ mɔ kee mɛ kya saawo mɔ, mɔ-gisen dɔ i nyida mɔ, ne i loo mɔ kee gikyɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ne ɔ taasɛ yɛɛ, “Fonɛ dɔ ne fɛ pule mɔ?” Mɛ lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, ba de foꞌ baa kerɛ.” ");
INSERT INTO acd_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Nfono mɔ Yesu gi su. ");
INSERT INTO acd_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Gyuda awura mɔ mɛ wu gɛnen mɔ, mɛ tɔgɛ sa abara yɛɛ, “Fɛꞌ kerɛ, ɔ laarɛ mɔ-ilaa gikyɔ ne‑o!” ");
INSERT INTO acd_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Asa mɔ ako, mɔ, yɛɛ, “Mɔ ɔbono ɔ kyɛ gyaatanbo mɔ mɔ mɛŋ taalɛ yɛgɛ de Lasarosɛ ɔ mɛŋ sa oꞌ wuꞌ?” ");
INSERT INTO acd_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Imɔso Yesu gisen gi kii nyida mɔ ginyɔsɛ. Nfono mɔ ɔ naa kpe nfono mɛ pule mɔ mɔ. Folɛbɔ dɔ ne mɛ pule Lasarosɛ ne mɛ kyu gibui belɛ giko kyu tii gifolɛ mɔ gɛbunono. ");
INSERT INTO acd_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Yesu gi naa kpe nno gɛnen mɔ, ɔ tɔgɛ sa asa mɔ yɛɛ, “Fɛꞌ belen gibui mɔ lii folɛbɔ mɔ gɛbunono.” Nfono mɔ Lasarosɛ mɔ-pikyii Maata gi tɔgɛ sa Yesu yɛɛ, “Ɔbelɛnsɛ, mɛ pule mɔ faa, ndɛ nkɛ nnan ne. Ɔ laa lii son.” ");
INSERT INTO acd_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Yesu gi taasɛ mɔ yɛɛ, “Meŋ tɔgɛ sa fo yɛɛ nengyene fo kyu fo-nyoro too me so mɔ, fo laa wu Wurubuaarɛ nyisigyi?” ");
INSERT INTO acd_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Nfono mɔ, mɛ belen gibui belɛ mɔ lii folɛbɔ mɔ gɛbunono, ne Yesu gi diirɛ mɔ-ansi kerɛ soso ne ɔ faala Wurubuaarɛ yɛɛ, “Me-sɛ, foꞌsun, fɛɛ fo nu me asɛ. ");
INSERT INTO acd_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","N nyi yɛɛ fo kya nu me asɛ owi kamaasɛ dɔ. Asa abono mɛ yelɛ gɛrɛnaa faa so ne nꞌ kya tɔgɛ gɛnen ilaa idɛ faa de mɛꞌ nyɛ sɔɔ gyi yɛɛ fo ne n sun me.” ");
INSERT INTO acd_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Yesu gi dalaa ta mɔ, o kpen ken-ken yɛɛ, “Lasarosɛ, lii ba!” ");
INSERT INTO acd_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Nfono mɔ Lasarosɛ ɔbono o wuꞌ mɔ gi lii ba Yesu asɛ gɛsintin. Ɔ lii ba gɛnen mɔ, akuru abono mɛ kyu dela mɔ-gibuni mɔ a kpɛ san a mili mɔ-ayaa de mɔ-abaa de mɔ-ansi gɛnen. Yesu gi tɔgɛ sa asa mɔ yɛɛ, “Fɛꞌ maragɛ akuru mɔ lii mɔ-nyoro so de ɔꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Gyuda awura mɔ mɛ buu Mariya kpe nno mɔ mɛ wu ilaa ibono Yesu gi wɔra faa mɔ, mɔmɔ dɔ asa sakyɔ mɛ sɔɔ Yesu gyi. ");
INSERT INTO acd_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Mɔmɔ ako mɔ, mɛ naa kpe Farasii awura mɔ asɛ ne mɛ kpaa buu ilaa ibono Yesu gi wɔra mɔ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Imɔso Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de Farasii awura mɔ mɛ terɛ Gyuda awura nbɛlɛ agyibo baa gyanꞌ ne mɛ taasɛ abara yɛɛ, “Ilaa lɛɛnyiilesɛ kpɛi-kpɛi ibono ɔnyen baarɛ kya wɔra faa, nnɛ ne a laa wɔra mɔ? ");
INSERT INTO acd_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","A taa mɔ yɛgɛ mɔ, asa mɔ pɛwu mɛ laa naa sɔɔ mɔ gyi yɛɛ mɔ ne n gyɛ ɔbono Wurubuaarɛ gi sun de ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. Nengyene i ba gɛnen mɔ, Rom awura mɔ mɛ laa baa boori aye Wurubuaarɛ ɔson obu mɔ de mɛꞌ sɔgɛ gɛwura mɔ lii aye asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Mɔmɔ dɔ ɔbono ɔ gyɛ Gyuda awura asunbi alɛɛbo gɛmu gɛnen gɛsi gɛbono dɔ mɔ ginyen ne n gyɛ Kayifasɛ. Nbɛlɛ agyibo mɔ mɛ gyan mɛ kya sa gɛwɔnsa gɛnen mɔ, Kayifasɛ baarɛ gi tɔgɛ sa mɔmɔ yɛɛ, “Fɛŋ taa nyi ɔlaako. ");
INSERT INTO acd_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Fɛ mɛŋ nyi yɛɛ nengyene asa mɔ pɛwu lɛwu so ne nyamesɛ kolon gi tɛsɛ wuꞌ sa mɔmɔ mɔ, i boran?” ");
INSERT INTO acd_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Gɛsintin so mɔ, Kayifasɛ baarɛ, mɛŋ tɔgɛ gɛnen ilaa idɛ mɔ gbaa-gbaa gibaa so. Ibono mɔ ne n gyɛ asunbi alɛɛbo gɛmu gɛnen gɛsi gɛbono dɔ mɔ so ne Wurubuaarɛ gi yɛgɛ ɔ wolaa wu tɔgɛ ilaa ibono i laa baa ba Yesu so mɔ gɛnen. Ɔ wu yɛɛ Yesu laa wuꞌ sa mɔmɔ Gyuda awura pɛwu. ");
INSERT INTO acd_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Gɛnen gbaa mɔ, Kayifasɛ mɛŋ bii yɛɛ i mɛŋ gyɛ mɔmɔ Gyuda awura mɔ wolɛ ne Yesu laa wuꞌ sa. Yesu gi nyɛ wuꞌ mɔ, de iꞌ koola Wurubuaarɛ mɔ-biana gbaa-gbaa abono mɛ yaasɛ mɛ bo nten kpɛi-kpɛi mɔ pɛwu, kyu baa wɔra nyamesɛ kolon. ");
INSERT INTO acd_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","San kyu lii gɛnen gɛkɛ gɛbono nbɛlɛ agyibo mɔ mɛ gyanꞌ kyu kyon mɔ, Gyuda awura abelɛnsɛ adɛ mɛ da gɛdɛ yela de mɛꞌ nyɛ Yesu mɔɔ. ");
INSERT INTO acd_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Kyu lii gɛnen so mɔ, Yesu mɛŋ baa naa tentegelen saarɛ Gyuda awura mɔ dɔ. Mɔ‑rɛ mɔ-akasɛbo mɔ mɛ san naa kpaa kyena daa Ifiram ɔsowolɛ so sindi gipen giko. ");
INSERT INTO acd_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mɛ bo nno mɔ, mɔmɔ Gyuda awura Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ gɛ kya fuude. Imɔso asa sakyɔ mɛ kya lii gɛnen gɛsinkpan gɛbono so mɛ kya kpe Gyɛrusalem, mɔmɔ-isowolɛ gɛmu mɔ so. Mɛ kya daa gigyangbara kpe nno kpaa wɔra itiibilaa iko baala gyoo mɔmɔ-gɛkɛ belɛ mɔ gigyi de iŋꞌ sa iꞌ kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson. ");
INSERT INTO acd_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","I fo gɛnen owi ɔbono mɔ, asa mɔ mɛ yelɛ Wurubuaarɛ ɔson obu gikpaara mɔ so, mɛ kya laarɛ Yesu. Mɛ san mɛ kya taasɛ abara yɛɛ, “Nnɛ ne n gyɛ fɛye-nwɔnsa? Fɛ nyi yɛɛ ɔ laa baa gyi gɛkɛ belɛ gɛdɛ abɛɛ?” ");
INSERT INTO acd_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Asunbi alɛɛbo abelɛnsɛ mɔ de Farasii awura mɔ mɛ wolaa ka sa asa yɛɛ ɔkamaasɛ ɔbono o nyi nfono Yesu bo mɔ ɔꞌ baa buu sa mɔmɔ de mɛꞌ nyɛ keda mɔ kpaa tii. ");
INSERT INTO acd_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","I kya san nkɛ nsee de Gyuda awura mɛꞌ gyi mɔmɔ-Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ, Yesu gi kpe Bɛtani ɔsowolɛ ɔbono so Lasarosɛ tɛ mɔ. (Lasarosɛ ne n gyɛ ɔnyen ɔbono o wuꞌ ne mɛ pule mɔ ne Yesu gi kyingi mɔ lii ibuni dɔ mɔ.) ");
INSERT INTO acd_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ɔ loo nno mɔ, mɛ wɔra agyudɔ ne mɛ kyu gyi gɛkɛ belɛ sa mɔ. Lasarosɛ mɔ-pikyii Maata ne n kerɛ gɛgyan mɔ so. Lasarosɛ kee bo mɔmɔ dɔ ogyiten mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Mɛ tɛ mɛ kya gyi mɔ, Lasarosɛ mɔ-pikyii Mariya gi kpaa kyu puruntuwa de anuwanterɛ boɔgyalonsɛ ɔko ɔnan kyu ba. Nadi oyii ilin ne mɛ kyu wɔra mɔ. Mariya gi kyu anuwanterɛ mɔ ba mɔ, ɔ kyɛɛgɛ worogɛ Yesu ayaa so ne o kyu mɔ-gimu iman kyu kpaarɛ Yesu ayaa. Ɔ wɔra gɛnen mɔ, anuwanterɛ mɔ-ofen gi sɔɔ gɛten gɛbono dɔ mɛ bo mɔ pɛwu gyi. ");
INSERT INTO acd_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Owi ɔbono mɔ, Gyudasɛ Isikaayɔtɛ, Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko bo nno. (Mɔ ne n baa yɛgɛ Yesu akyobo mɛ nyɛ mɔ mɔ.) ");
INSERT INTO acd_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","O wu ilaa ibono Mariya gi wɔra mɔ, ɔ tɔgɛ yɛɛ, “Anuwanterɛ baarɛ mɛn wɔra ɔfɛsɛ mɔ, nkana a laa nyɛ aterenbi belɛ de aꞌ kyu yɛ sa ayenbo!” ");
INSERT INTO acd_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Gyudasɛ gi tɔgɛ gɛnen mɔ, i mɛŋ gyɛ yɛɛ mɔ-gɛwɔnsa gɛ gyanꞌ ayenbo mɔ so gɛsintin daa. Ɔ gyɛ daa oyu. Mɔ ne n kya keda mɔmɔ-aterenbi ɔwɔraten. Ɔ kya kyena yuuri aterenbi mɔ ako. Imɔ ne n yɛgɛ ne ɔ tɔgɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Taa ɔkyii mɔ yɛgɛ. Ɔ wɔra imɔ yela gyoo me-gipule ne. ");
INSERT INTO acd_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ayenbo abono fo darɛ faa, mɛ bo fɛye asɛ adaa-adaa. Me berɛ, fɛ maŋ nyɛ me de nꞌ kyena fɛye asɛ kpaa lii.” ");
INSERT INTO acd_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ibono Gyuda awura sakyɔ mɛ nu yɛɛ Yesu bo Bɛtani ɔsowolɛ so mɔ, mɛ kpe mɔ asɛ nno. I mɛŋ gyɛ Yesu mɔ-nkon so ne sakpii belɛ mɔ gi kpe nno gɛnen. Mɛ kpe nno kee daa de mɛꞌ kpaa kerɛ Lasarosɛ ɔbono o wuꞌ ne Yesu gi kyingi mɔ lii ibuni dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Imɔso Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ mɛ laarɛ ɔkpa ɔbono so mɛ laa nyɛ de mɛꞌ mɔɔ Lasarosɛ kee mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","I lii fɛɛ kyu lii Lasarosɛ so mɔ, mɔmɔ Gyuda awura sakyɔ mɛ san ma‑a kine mɔmɔ-asunbi alɛɛbo abelɛnsɛ mɔ-lɛɛ mɔ, ne mɛ san ma‑a sɔɔ Yesu gyi. ");
INSERT INTO acd_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Imɔ gɛdɛ kɛsɛ mɔ, sakpii belɛ ɔbono ɔ ba Gyɛrusalem de mɛꞌ baa gyi mɔmɔ-gɛkɛ belɛ mɔ mɛ nu yɛɛ Yesu bo ɔkpa dɔ ɔ kya ba Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Gɛnen so mɔ, mɛ kyadɛ-kyadɛ abelafɛ ne mɛ kyu lii kpe mɛꞌ kpaa gyangara mɔ. Mɛ san mɛ kya kpen mɛ kya tɔgɛ yɛɛ, “Ayenbi a gyɛ fo-lɛɛ! Wurubuaarɛ ɔꞌ kosorɛ fo-gimu! Wurubuaarɛ ginyen dɔ ne fo naa fo kya ba faa! Fo ne n gyɛ ɔbono fo laa gyi gɛwura aye Isirale awura so!” ");
INSERT INTO acd_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Yesu gi laarɛ bee fɔlɛ ɔko ne ɔ dii gyanꞌ mɔ so ɔ kya kpe, fɛɛ gɛnɔɔbono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ. Mɛ ŋmarasɛ yela yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","Sayon! Ɔsowolɛ belɛ so awura! Fɛŋ sa fɛꞌ selɛ gifuu. Fɛꞌ kerɛ, fɛye-wura ne n gyanꞌ bee fɔlɛ so ɔ kya ba mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","I ba gɛnen pɛwu faa, Yesu akasɛbo mɔ mɛ mɛŋ nu gɛsɛ ayaa abono so. Owi ɔbono Wurubuaarɛ gi kyu nyisigyi kyu sa Yesu mɔ, pɛi ne mɔ-akasɛbo mɔ mɛ lɔɔ baa nyingi yɛɛ ilaa ibono mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ, nkyɛɛ Yesu ne mɛ darɛ gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Sakpii ɔbono o wu Yesu gi kyingi Lasarosɛ ne ɔ terɛ mɔ lii folɛbɔ gɛkyan mɔ dɔ mɔ, mɛ naa tɔgɛ tɔgɛ imɔ so ilaa sa asa pɛi ne mɔmɔ-gɛkɛ belɛ gigyi mɔ gi lɔɔ fo. ");
INSERT INTO acd_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Amunale ilaa ibono Yesu gi wɔra mɔ so ne asa sakyɔ mɛ lii kpaa gyangara mɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Sakpii ɔbono o buu Yesu mɔ so mɔ, Farasii awura mɔ mɛ tɔgɛ sa abara yɛɛ, “Fɛ mɛŋ wu? A laa taa kpon daa. Fɛꞌ kerɛ. Asa mɔ pɛwu ne n kpandɛ kpaa mili mɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Owi ɔbono asa mɛ kpe Gyɛrusalem kpaa son Wurubuaarɛ gɛnen gɛkɛ belɛ gɛbono mɔ, abono mɛŋ gyɛ Gyuda awura mɔ ako kee mɛ saarɛ mɔmɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Gɛnen asa adɛ mɛ ba Filipo asɛ baa tɔgɛ mɔ yɛɛ, “Ɔbelɛnsɛ, a kya laarɛ fɛɛ aꞌ wu Yesu.” (Gɛnen Filipo baarɛ gyɛ Yesu akasɛbo mɔ dɔ ɔko. Ɔ lii Bɛsayida, Galeli gɛsinkpan so.) ");
INSERT INTO acd_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Mɛ tɔgɛ mɔ gɛnen mɔ, ɔ kpaa tɔgɛ imɔ sa Andiru, ne mɔmɔ asa anyɔ mɛ naa kpaa tɔgɛ sa Yesu. ");
INSERT INTO acd_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Nfono ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Idɛ kon berɛ, owi mɔ gi fo ibono me, anyamesɛ pɛwu mɔmɔ-daa mɔ, nan nyɛ nyisigyi belɛ. ");
INSERT INTO acd_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gɛsintin ne nꞌ kya tɔgɛ fɛye faa; nengyene giwayu gibi giŋ tɔrɔ isɛ dɔ de giꞌ wuꞌ mɔ, gi kya sii de gimɔ-nkon. Nengyene giwayu gibi mɔ gi wuꞌ isɛ dɔ mɔ, gi kya kɔrɔ de giꞌ sɔga wɔra abi gikyɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Imɔso fo ɔbono fo-nkpa ne n tiri fo ne fo kya kɔrɔsɛ nmɔ fi‑i yela fo-gibaa so mɔ, Wurubuaarɛ asɛ gɛkyena gɛ laa lii fo-gibaa. Ne fo ɔbono, mɔ, Wurubuaarɛ ilaa so ne fo yɛɛ fo-nkpa giŋ tiri fo gɛsɛ gɛrɛ mɔ, fo kya baala nmɔ fi‑i yela de foꞌ nyɛ Wurubuaarɛ asɛ gɛkyena gɛkpaa ne. ");
INSERT INTO acd_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Fo nyamesɛ kamaasɛ ɔbono fo kya laarɛ de foꞌ son me mɔ, i kaaborɛ foꞌ baa wɔra me-ɔkasɛbo. Nfono mɛ laa wu me mɔ, nno kee ne mɛ laa wu me-asonbo. Me-sɛ Wurubuaarɛ laa tɛɛla ɔbono ɔ kya son me mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Idɛ kon, me-gisen dɔ i kya dɛɛ me fɛɛ ɔgya. Nnɛ ne nan tɔgɛ ne? Nꞌ kolɛ me-sɛ yɛɛ ɔꞌ mɔlɛgɛ me de awɔrɔfɔɔ abono a kya ba me so faa aꞌ kyon gibaafon abɛɛ? Kuaa. Gɛnen awɔrɔfɔɔ adɛ so ne nɛ ba gɛsinkpan so.” ");
INSERT INTO acd_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Yesu gi dalaa kolɛ Wurubuaarɛ yɛɛ, “Me-sɛ, lɛɛ fo-nyisigyi gɛwi.” Ɔ dalaa gɛnen mɔ, gigyɛbiꞌ giko gi lii Wurubuaarɛ dɔ tɔgɛ yɛɛ, “Nɛ ti wolaa lɛɛ me-nyisigyi gɛwi nyiile, ne nan kii lɛɛ mɔ gɛwi.” ");
INSERT INTO acd_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Sakpii mɔ ɔ yelɛ nfono mɔ gi nu gigyɛbiꞌ mɔ gɛnen mɔ, mɔmɔ ako mɛ tɔgɛ yɛɛ, “Nyangbon gi gbere.” Ako mɔ yɛɛ, “Wurubuaarɛ dɔ ɔsɔɔ ne n tɔngɛ sa mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Asa mɔ mɛ kya tɔgɛ gɛnen mɔ, Yesu gi lɛɛ gɛnɔ yɛɛ, “Fɛye so ne gigyɛbiꞌ gidɛ gi tɔngɛ gɛnen, nkana i mɛŋ gyɛ me so. ");
INSERT INTO acd_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Idɛ kon Wurubuaarɛ laa bun gɛsinkpan so asa gipuɛɛ kyu lii mɔmɔ-ilaa nyɛnyɛn so. Nkana ilaa nyɛnyɛn pɛwu gɛmu mɔ ne n bo ɔlon gɛsinkpan so. Idɛ kon Wurubuaarɛ laa kosorɛ mɔ gɛgyapaa mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Nengyene i puru me diirɛ lɛwu oyii so ne nɛ wuꞌ mɔ, nan biidɛ asa kpɛi-kpɛi pɛwu kyu ba me asɛ de iꞌ mɔlɛgɛ ɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Yesu gi tɔgɛ gɛnen ilaa idɛ kyu lɛɛ nyiile lɛwu ɔbono ɔnan ɔ laa kyu wuꞌ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nfono mɔ asa mɔ mɛ tɔgɛ sa Yesu yɛɛ, “A nu lii Wurubuaarɛ nbara mɔ dɔ yɛɛ ɔbono Wurubuaarɛ laa sun de ɔꞌ baa mɔlɛgɛ anyamesɛ mɔ laa kyena gɛkpaa-gɛkpaa. Ne i wonɛ so ne fo kya tɔgɛ yɛɛ i kaaborɛ mɛꞌ puru anyamesɛ pɛwu mɔmɔ-daa mɔ diirɛ lɛwu oyii so de oꞌ wuꞌ? Anɛ ne n gyɛ gɛnen anyamesɛ pɛwu mɔmɔ-daa mɔ daa?” ");
INSERT INTO acd_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Asa mɔ mɛ taasɛ Yesu gɛnen mɔ, ɔ da gikpalɛ kyu lii mɔ-nyoro so sa mɔmɔ yɛɛ, “I san ŋmaraa daa de owi ɔꞌ ta. Owi san ɔ bo no faa, fɛꞌ naa de owi mɔ. Nengyene i bun wɔra fɛye mɔ, fɛ laa naa gibiri. Nyamesɛ ɔbono ɔ naa gibiri mɔ, mɛŋ kya bii nfono so ɔ kya kpe de. ");
INSERT INTO acd_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Imɔso ibono owi san ɔ bo no faa, fɛꞌ kyu fɛye-nyoro too mɔ so de fɛꞌ nyɛ wɔra fɛɛ asa abono fɛ gyɛ owi mɔ asa.” Yesu gi tɔgɛ gɛnen ta mɔ, ɔ naa taa mɔmɔ yɛgɛ kpaa ŋara. ");
INSERT INTO acd_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Ilaa lɛɛnyiilesɛ ibono Yesu gi wɔra mɔ i nyaakyɔ gikyɔ, ne asa mɔ mɛ wu imɔ de mɔmɔ-ansi. Mɛŋ kii sɔɔ mɔ gyi. ");
INSERT INTO acd_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","I mɛŋ gyɛ giyan. I ba gɛnen mɔ i nyɛ kyena de ilaa ibono Isaya gi wolaa ŋmarasɛ yela mɔ daa. Isaya gi wɔra Wurubuaarɛ ikalan ɔtɔgɛbo, ne ɔ naa kyena taasɛ Wurubuaarɛ yɛɛ, “Me-Wura Wurubuaarɛ, mɔmɔ dɔ anɛ ne n sɔɔ fo-ɔkalan ɔbono a tɔgɛ sa mɔmɔ mɔ gyi? Ne amɔlɛgɛ abono fo kya laarɛ foꞌ kyu mɔlɛgɛ asa mɔ anɛana ne n wu amɔ bii?” ");
INSERT INTO acd_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Gɛnen kee ibono mɛ mɛŋ taalɛ sɔɔ Yesu gyi mɔ, i dɛ daa fɛɛ gɛnɔɔbono Isaya baarɛ gi wolaa tɔgɛ yela yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Wurubuaarɛ yɛɛ mɛꞌ tɛsɛ wɔra fɛɛ agyaatanbo. Mɔmɔ-nwɔnsa dɔ iŋ sa iꞌ bugi de ilaa gɛsɛ ginu. Mɔmɔ adɛ berɛ mɛ maŋ nyɛ wu ilaa ibono i bo no mɔ, abɛɛ mɔmɔ-nwɔnsa dɔ iꞌ bugi de ilaa gɛsɛ ginu. Nkana mɛ nu ilaa gɛsɛ mɔ, mɛ laa kii ba me Wurubuaarɛ asɛ de nꞌ kyɛ mɔmɔ-gilɔtɔ gibono mɛ kya lɔ faa.” ");
INSERT INTO acd_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Isaya mɛŋ tɔgɛ gɛnen giyan. Ɔ wolaa wu Yesu nyisigyi mɔ, imɔso ne ɔ tɔgɛ kyu lii mɔ so gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Gyuda awura mɔ mɛ kine Yesu faa, imɔ‑rɛ imɔ gɛnen mɔ, mɔmɔ sakyɔ mɛ sɔɔ Yesu gyi, dabɔlɛ de mɔmɔ abelɛnsɛ mɔ ako. Mɛ mɛŋ kyule lɛɛ mɔmɔ-gisɔɔgyi mɔ gɛwi daa. I kya nyiile yɛɛ mɛ selɛ Farasii awura mɔ gifuu yɛɛ mɛ laa naa gya mɔmɔ yɛɛ mɔmɔ-giyaa giŋ baa nyɛ yii mɔmɔ-gikyangbon dɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Nyisigyi ɔbono asa mɛ laa kyu sa mɔmɔ mɔ ne mɛ kya laarɛ don Wurubuaarɛ-lɛɛ nyisigyi ɔbono ɔ laa sa mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Yesu gi kpen tɔgɛ sa asa mɔ yɛɛ, “Ɔbono ɔ sɔɔ me gyi mɔ, i mɛŋ gyɛ me-wolɛ ne ɔ sɔɔ gyi. Kaasɛ gi sɔɔ ɔbono ɔ sun me mɔ kee gyi ne. ");
INSERT INTO acd_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ɔbono o wu me mɔ gi wu ɔbono o sun me mɔ kee ne. ");
INSERT INTO acd_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Me nɛ ba gɛsinkpan so daa fɛɛ fatela de ɔbono o kyu mɔ-nyoro too me so mɔ ɔ mɛŋ sa oꞌ sii gibiri dɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Nengyene fo ɔko fo kya nu me-ilaa tɔgɛsɛ ne foŋ kya gyi imɔ so mɔ, iŋ gyɛ me ne nan bun fo gipuɛɛ. I kya nyiile yɛɛ meŋ ba gɛsinkpan so de nꞌ baa bun anyamesɛ gipuɛɛ. Nɛ ba daa de nꞌ baa mɔlɛgɛ mɔmɔ de mɛꞌ nyɛ gɛkyena Wurubuaarɛ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Nyamesɛ ɔbono o kine me ne o kine de me-ilaa tɔgɛsɛ mɔ berɛ bo ɔbono ɔ laa bun mɔ gipuɛɛ mɔ. Me-agyɛbi abono nɛ tɔgɛ mɔ ne nan bun mɔ gipuɛɛ gɛkɛ gɛbono gɛsinkpan so gɛkyena gɛ laa yela ɔkara mɔ. ");
INSERT INTO acd_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","I kya nyiile yɛɛ ilaa ibono n kya tɔgɛ mɔ, i mɛŋ gyɛ me-gibaa so ne n kya tɔgɛ imɔ. Me-sɛ Wurubuaarɛ ɔbono o sun me mɔ gbaa-gbaa ne n ka sa me yɛɛ idɛ de idɛ ne nꞌ tɔgɛ. ");
INSERT INTO acd_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","N nyi yɛɛ ilaa ibono ɔ ka sa me gɛnen mɔ i laa yɛgɛ asa mɛꞌ nyɛ kyena mɔ asɛ gɛkpaa. Imɔso ilaa ibono n kya tɔgɛ mɔ, n kya tɔgɛ daa gɛnɔɔbono me-sɛ Wurubuaarɛ gi tɔgɛ me yɛɛ nꞌ tɔgɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","I san gɛkɛ kolon de Gyuda awura mɛꞌ gyi mɔmɔ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ, Yesu gi bii yɛɛ owi mɔ gi fo ibono ɔ laa lii gɛsinkpan so de oꞌ kii kpe mɔ-sɛ asɛ. Mɔ-gɛkyena dɔ mɔ, ɔ laarɛ mɔ-akasɛbo abono mɛ bo mɔ asɛ mɔ ilaa. Gɛnen aberɛ adɛ dɔ mɔ Yesu kya laarɛ ɔꞌ baa lɛɛ nyiile gɛnɔɔbono ɔkara ɔ kya laarɛ ɔmɔ-ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Gɛnen gɛkɛ gɛbono gɛdɔɔdɛ mɔ, Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ tɛ mɛ kya gyi mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi ti suu de Gyudasɛ Isikaayɔtɛ, ɔbono ɔ gyɛ Simon mɔ-bi mɔ de ɔꞌ yɛgɛ Yesu akyobo mɛꞌ nyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Yesu nyi ibono mɔ-sɛ Wurubuaarɛ gi kyu ilaa kamaasɛ kyu wɔra mɔ Yesu abaa dɔ. O nyi kee yɛɛ ɔ lii Wurubuaarɛ asɛ ne ɔ laa kii kpe mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mɛ gyi ta mɔ, ɔ koso yelɛ ne o luu soso-lɛɛ gɛgbɛ gɛbono o suu mɔ, ne o kyu bɔdɛbaa kyu dela mɔ-gɛsara dɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nfono mɔ, ɔ kyɛɛgɛ nkyu wɔra tasa dɔ ne o yii gɛsɛ ɔ kya foro mɔ-akasɛbo mɔ-ayaa ɔko ɔko yɛgɛ ɔ dɛ bɔdɛbaa mɔ o kyu dela mɔ-gɛsara dɔ mɔ, ɔ kya lɛɛ mɔmɔ-ayaa nkyu. ");
INSERT INTO acd_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Yesu gi baa fo Simon Piita asɛ mɔ, Piita gi taasɛ mɔ yɛɛ, “Me-Wura, fo ne nan foro me-ayaa sa me?” ");
INSERT INTO acd_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo mɛŋ nyi ilaa ibono n kya wɔra faa. Gɛmara mɔ, fo laa baa bii.” ");
INSERT INTO acd_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Piita gi kii tɔgɛ mɔ yɛɛ, “O kuaa! Iŋ kaaborɛ foꞌ foro me-ayaa sa me gɛkaako.” Yesu gi tɔgɛ mɔ yɛɛ, “Nengyene maŋ foro fo-ayaa sa fo mɔ, gɛnen berɛ mɔ, me‑rɛ fo a mɛŋ baa a bo sɛi giwɔra.” ");
INSERT INTO acd_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Nfono mɔ, Piita gi lɛɛ gɛnɔ yɛɛ, “Ɔbelɛnsɛ, gɛnen berɛ mɔ, i mɛŋ gyɛ me-ayaa wolɛ. Tɛsɛ foro me-abaa de me-gimu kee sa me.” ");
INSERT INTO acd_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Nengyene nyamesɛ gi gyere mɔ, mɔ-nyoro gɛtɛɛko giŋ baa gi bo ineesi ibono i tiri yɛɛ oꞌ kii gyere. Mɔ-ayaa dɔ wolɛ ne n tiri yɛɛ ɔꞌ foro. Fɛye adɛ pɛwu fɛŋ bo ineesi, gɛnen mɔ, fɛye dɔ nyamesɛ kolon guan ne n bo ineesi.” ");
INSERT INTO acd_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Yesu ti wolaa o nyi ɔbono ɔ laa yɛgɛ mɔ-akyobo mɛꞌ nyɛ mɔ mɔ. Imɔso ne ɔ tɔgɛ yɛɛ, “Fɛye adɛ pɛwu fɛŋ bo ineesi, gɛnen mɔ, fɛye dɔ nyamesɛ kolon guan.” ");
INSERT INTO acd_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Yesu gi foro mɔ-akasɛbo mɔ ayaa ta mɔ, o kiiri mɔ-soso lɛɛ gɛgbɛ mɔ suu ne ɔ naa kii kpaa kyena mɔ-ɔkyenaten ogyiten mɔ. Nfono mɔ ɔ taasɛ mɔ-akasɛbo mɔ yɛɛ, “Fɛ nu ilaa ibono nɛ wɔra sa fɛye faa gɛsɛ? ");
INSERT INTO acd_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Fɛ kya terɛ me yɛɛ fɛye-Ɔbelɛnsɛ de fɛye-Wura. Fɛ terɛ me gɛnen mɔ, fɛ mɛŋ fuɛ. I kya nyiile yɛɛ gɛnen nyamesɛ ne nꞌ gyɛ. ");
INSERT INTO acd_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","To, me ɔbono n gyɛ fɛye-ɔbelɛnsɛ de fɛye-wura mɔ ne n bara me-nyoro gɛsɛ, ne nɛ foro fɛye-ayaa sa fɛye faa. Imɔso, fɛye kee fɛꞌ bara fɛye-nyoro gɛsɛ de fɛꞌ foro abara ayaa sa abara gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nɛ wɔra sinkaala yela sa fɛye ne. Fɛye kee fɛꞌ wɔra ilaa ibono nɛ wɔra sa fɛye faa ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, dega mɛŋ kya don mɔ-ɔbelɛnsɛ. Ɔsɔɔ mɛŋ kya don ɔbono o sun mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ibono fɛ nyɛ bii yɛɛ i kaaborɛ fɛꞌ son abara faa, ne fɛ kya son abara gɛsintin mɔ, fɛ laa wɔra amudɛnsɛbo. ");
INSERT INTO acd_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“I mɛŋ gyɛ fɛye pɛwu ne nꞌ darɛ. N nyi fɛye abono nɛ lɛɛ yɛɛ fɛꞌ wɔra me-gɛsun mɔ. I tiri yɛɛ ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ mɔ, mɔ, iꞌ nyɛ ba gɛsintin. Mɛ wolaa ŋmarasɛ yela yɛɛ, ‘Nyamesɛ ɔbono me‑rɛ mɔ a kya wɔra abaa gyi mɔ ne nan kisee dii yelɛ me so.’ ");
INSERT INTO acd_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","N wolaa mi‑i tɔgɛ fɛye gɛnen ilaa idɛ nperɛ pɛi de iꞌ lɔɔ ba. Nengyene i san ba mɔ, de fɛꞌ sɔɔ me gyi yɛɛ me ne n bo no pɛi ne ilaa kamaasɛ i bo no. ");
INSERT INTO acd_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa, ɔbono ɔ sɔɔ ɔbono nɛ sun mɔ abaa anyɔ mɔ, me ne ɔ sɔɔ gɛnen. Ne ɔbono ɔ sɔɔ me abaa anyɔ mɔ, ɔbono o sun me mɔ ne ɔ sɔɔ gɛnen.” ");
INSERT INTO acd_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Yesu gi tɔgɛ gɛnen ta mɔ, mɔ-gisen dɔ i nyida mɔ ne o buu sa mɔmɔ yɛɛ, “Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye faa; fɛye dɔ ɔko laa kyu me wɔra me-akyobo abaa dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Yesu gi tɔgɛ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ kpɛɛlɛ kerɛ abara. Mɛ mɛŋ nyi ɔbono ɔ darɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Me, Yesu ɔkasɛbo ɔbono ɔ kya laarɛ me-ilaa mɔ ne n tɛ n sindi mɔ ogyiten mɔ. ");
INSERT INTO acd_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Nfono ne Simon Piita gi da gimu sa me yɛɛ nꞌ taasɛ mɔ yɛɛ aye dɔ anɛ ne ɔ darɛ daa? ");
INSERT INTO acd_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Gɛsintin mɔ, nɛ tu sindi Yesu ne nɛ taasɛ mɔ yɛɛ, “Ɔbelɛnsɛ, anɛ ne fo darɛ daa?” ");
INSERT INTO acd_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Yesu gi tɔgɛ sa me yɛɛ, “Kaasɛ ɔbono nan kyu bodobodo nyɔɔ ipɔ dɔ sa mɔ de oꞌ gyi mɔ, mɔ ne nꞌ darɛ gɛnen.” Nfono mɔ Yesu gi kyu bodobodo ɔbono ɔ dɛ mɔ kyu nyɔɔ ipɔ mɔ dɔ gɛsintin ne o kyu sa Gyudasɛ, Simon Isikaayɔtɛ mɔ-bi yɛɛ ɔꞌ sɔɔ gyi. ");
INSERT INTO acd_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Gyudasɛ gi kpɛ sɔɔ bodobodo mɔ gyi mɔ, ilaa nyɛnyɛn pɛwu gɛmu mɔ gi suu de mɔ. Nfono mɔ Yesu gi tɔgɛ sa Gyudasɛ yɛɛ, “Idɛ kon ilaa ibono fo laa wɔra mɔ, wɔra imɔ kusaa.” ");
INSERT INTO acd_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","(Aye akasɛbo sɛnsɛ abono aye‑rɛ Yesu a tɛ a kya gyi mɔ dɔ ɔko‑rɛ ɔko mɛŋ nu ilaa ibono Yesu gi tɔgɛ sa Gyudasɛ mɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Mɔmɔ ako berɛ, mɛ nyi daa yɛɛ Yesu kya tɔgɛ ɔ kya sa Gyudasɛ yɛɛ ɔꞌ kpaa sɔɔ ilaa ibonoana mɛ laa kyu gyi gɛkɛ belɛ mɔ abɛɛ ɔꞌ kpaa kyu ilaa iko kpaa sa ayenbo. I kya nyiile yɛɛ Gyudasɛ ne n kya keda mɔmɔ-aterenbi.) ");
INSERT INTO acd_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Gyudasɛ gi kpɛ gyi bodobodo mɔ, ayaa abono so mɔ, ɔ lii taa mɔmɔ yɛgɛ. Gɛnen owi ɔbono mɔ, i gyɛ gɛnyɛ. ");
INSERT INTO acd_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Gyudasɛ gi lii, ne i san Yesu mɔ‑rɛ mɔ-akasɛbo sɛnsɛ mɔ, Yesu gi tɔgɛ yɛɛ, “Idɛ kon ne me, anyamesɛ pɛwu mɔmɔ-daa mɔ nyisigyi mɔ laa lii gɛwi ne. Gɛnen kee ne Wurubuaarɛ-lɛɛ nyisigyi mɔ laa lii gɛwi kyu lii me so ne. ");
INSERT INTO acd_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Nengyene Wurubuaarɛ nyisigyi mɔ gi lii gɛwi kyu lii me so mɔ, gɛnen kee ne Wurubuaarɛ laa yɛgɛ me-lɛɛ nyisigyi mɔ ɔꞌ lii gɛwi kyu lii mɔ Wurubuaarɛ so ne. Ayaa adɛ so ne Wurubuaarɛ laa wɔra gɛnen ilaa idɛ.” ");
INSERT INTO acd_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Me-biana, nan kyena fɛye dɔ ŋmaraa daa faa bɔla. Fɛ laa laarɛ me-gɛten. Fɛɛ gɛnɔɔbono nɛ tɔgɛ sa Gyuda awura abelɛnsɛ baa kyon mɔ, nperɛ n kya tɔgɛ mi‑i sa fɛye kee yɛɛ nfono n kya kpe mɔ, fɛ maŋ taalɛ kpe nno. ");
INSERT INTO acd_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Pɛi ne nan kyon mɔ, n kya yela nbara pobɔrɔ n kya sa fɛye yɛɛ fɛꞌ laarɛ abara ilaa. Fɛɛ gɛnɔɔbono nɛ laarɛ fɛye-ilaa mɔ, fɛye kee fɛꞌ laarɛ abara ilaa gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Nengyene fɛ laarɛ abara ilaa mɔ, imɔ ne nan yɛgɛ ɔkamaasɛ ɔꞌ bii yɛɛ me-akasɛbo ne fɛ gyɛ.” ");
INSERT INTO acd_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Yesu gi tɔgɛ gɛnen mɔ, Simon Piita gi taasɛ mɔ yɛɛ, “Me-wura, fo laa kpe fonɛ?” Nfono ne Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Nfono n kya kpe mɔ, fo maŋ taalɛ buu me kpe nno nperɛ. Gɛmara mɔ fo laa buu me ba nno.” ");
INSERT INTO acd_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Piita gi kii taasɛ mɔ yɛɛ, “Me-wura, menɛ n wɔra so ne maŋ taalɛ buu fo kpe nno nperɛ yɛgɛ nan taalɛ sɔɔ fo-lɛwu wuꞌ?” ");
INSERT INTO acd_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ne Yesu gi taasɛ Piita yɛɛ, “Fo laa sɔɔ me-lɛwu wuꞌ? Sɔɔ gibui yela, pɛi de kyaasɛ gyangbarasɛ ɔꞌ lɔɔ folɛ ndɛ mɔ, fo laa sorogɛ gikpadɔ gisaꞌ yɛɛ fo mɛŋ nyi me.” ");
INSERT INTO acd_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛ mɛŋ sa fɛꞌ yɛgɛ fɛye-asen dɔ iꞌ nyida fɛye. Fɛye berɛ fɛꞌ kpɛ kyu fɛye-nyoro too Wurubuaarɛ so daa. Fɛꞌ kyu fɛye-nyoro too me so kee. ");
INSERT INTO acd_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ibu kyenasɛ i nyaakyɔ me-sɛ Wurubuaarɛ gɛten dɔ. Ne fɛɛ i mɛŋ gyɛ gɛnen mɔ, nkana maŋ tɔgɛ sa fɛye yɛɛ nan kpaa lɔrɔ gɛtɛɛko gyoo fɛye. ");
INSERT INTO acd_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nengyene nɛ kpaa lɔrɔ nno yela sa fɛye gɛnen mɔ, nan kii ba fɛye asɛ de nꞌ baa puru fɛye kyu kpe me asɛ. Nfono nan kyena mɔ, nno ne fɛye kee fɛ laa kyena. ");
INSERT INTO acd_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ɔkpa ɔbono so nan naa de nꞌ kpe mɔ, fɛ ti fɛ nyi gɛnen ɔkpa mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Yesu gi tɔgɛ gɛnen mɔ, Tomaasɛ gi taasɛ mɔ yɛɛ, “Me-wura, a mɛŋ nyi nfono fo kya kpe mɔ. Ne nnɛ ne a laa wɔra de aꞌ bii ɔkpa mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Yesu gi lɛɛ gɛnɔ yɛɛ, “Me ne n gyɛ ɔkpa mɔ. Me so ne asa mɛ laa bii gɛsintin mɔ ne mɛ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan. Ɔko‑rɛ ɔko mɛŋ bo no ɔ laa taalɛ kpe Wurubuaarɛ asɛ, gɛnen mɔ, kaasɛ mɔ gi kyu de me so. ");
INSERT INTO acd_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Fɛɛ fɛ bii me mɔ, fɛ bii me-sɛ Wurubuaarɛ kee ne. San kyu lii nperɛ kyu i kya kpe mɔ, fɛ ti nyɛ me-sɛ Wurubuaarɛ bii, ne fɛ nyɛ mɔ wu de fɛye-ansi ne.” ");
INSERT INTO acd_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Yesu gi tɔgɛ gɛnen mɔ, Filipo gi tɔgɛ sa mɔ yɛɛ, “Me-Wura, nyiile aye aye-sɛ Wurubuaarɛ. A nyɛ bii mɔ mɔ, i kaabo aye.” ");
INSERT INTO acd_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yesu gi taasɛ mɔ yɛɛ, “Filipo, ko‑o ibono me‑rɛ fɛye a kyena kaaborɛ faa, imɔso fo mɛŋ ti taa bii me? Nyamesɛ kamaasɛ ɔbono o wu me mɔ, o wu me-sɛ Wurubuaarɛ ne, ne nnɛ so ne fo kii fi‑i tɔgɛ me yɛɛ nꞌ nyiile fɛye me-sɛ Wurubuaarɛ? ");
INSERT INTO acd_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Fo mɛŋ kya sɔɔ me gyi yɛɛ me-sɛ Wurubuaarɛ bo me dɔ ne me kee n bo mɔ dɔ? Ilaa ibono n kya tɔgɛ mɔ i mɛŋ gyɛ me-gibaa so ne nꞌ kya tɔgɛ imɔ. I gyɛ daa me-sɛ Wurubuaarɛ ɔbono ɔ tɛ me dɔ mɔ ne n kya wɔra mɔ-gɛsun. ");
INSERT INTO acd_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Sɔɔ me gyi yɛɛ n bo me-sɛ dɔ, ne mɔ kee bo me dɔ. Nɛ tɔgɛ faa ne fo maŋ sɔɔ gyi mɔ, kii sɔɔ me gyi kyu lii me-ilaa ibono n dɛ Wurubuaarɛ ɔlon n kya wɔra mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Gɛsintin ne nꞌ kya tɔgɛ mi‑i sa fɛye; ɔbono o kyu mɔ-nyoro too me so mɔ laa wɔra ilaa ibono ɔnan n kya wɔra mɔ de iꞌ kii don me-lɛɛ mɔ gbaa. I kya nyiile yɛɛ nan kpe me-sɛ Wurubuaarɛ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Ilaa kamaasɛ ibono fɛ dalaa kolɛ Wurubuaarɛ naa de me so mɔ, nan wɔra sa fɛye de asa mɛꞌ nyɛ wu Wurubuaarɛ nyisigyi mɔ kyu naa de me, Wurubuaarɛ mɔ-bi mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Ilaa kamaasɛ ibono fɛ dalaa kolɛ me-ginyen dɔ mɔ, gɛsintin, nan wɔra sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Nengyene fɛ kya laarɛ me-ilaa mɔ, fɛ laa gyi me-nbara mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Nan dalaa kolɛ me-sɛ Wurubuaarɛ de oꞌ kii sun ɔkpaabo ɔko de ɔꞌ baa kyena fɛye asɛ gɛkpaa-gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Mɔ ne n gyɛ Wurubuaarɛ Oduduu ɔbono ɔ bo gɛsintin mɔ. Abono mɛŋ kya sɔɔ Wurubuaarɛ gyi mɔ mɛ maŋ taalɛ sɔɔ mɔ abaa anyɔ. I kya nyiile yɛɛ mɛ mɛŋ nyi yɛɛ ɔ bo no, ne mɛ mɛŋ kii mɛ nyi mɔ. Fɛye berɛ, fɛ nyi mɔ. Ɔ tɛ fɛye asɛ ne ɔ laa kyena fɛye-asen dɔ. ");
INSERT INTO acd_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Maŋ taa fɛye yɛgɛ fɛye-nkon fɛɛ aŋmenbi. Nɛ kpe mɔ, nan kii ba fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","I kpɛ san ŋmaraa daa, abono mɛ mɛŋ kya sɔɔ Wurubuaarɛ gyi mɔ mɛ maŋ baa wu me. Fɛye berɛ, fɛ laa wu me. Me, n ti n bo Wurubuaarɛ asɛ gɛkyena. Imɔso fɛye kee fɛ laa nyɛ Wurubuaarɛ asɛ gɛkyena. ");
INSERT INTO acd_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Gɛnen owi ɔbono mɔ, fɛ laa nyɛ bii yɛɛ n bo me-sɛ Wurubuaarɛ dɔ ne fɛye mɔ, fɛ bo me dɔ, ne mi‑i me mɔ, n bo fɛye dɔ. ");
INSERT INTO acd_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Fo nyamesɛ ɔbono fo kya sɔɔ me-nbara wɔra fo-gisen dɔ ne fo kya gyi nmɔ so mɔ, fo ne n kya laarɛ me-ilaa. Me-sɛ Wurubuaarɛ laa laarɛ fo gɛnen kaasɛ ɔbono ilaa. Me kee nan laarɛ fo-ilaa ne nan lɛɛ me-nyoro gɛwi nyiile fo.” ");
INSERT INTO acd_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Yesu gi tɔgɛ gɛnen ta mɔ, mɔ-akasɛbo mɔ dɔ ɔbono mɛ kya terɛ mɔ yɛɛ Gyudasɛ mɔ (I mɛŋ gyɛ Gyudasɛ Isikaayɔtɛ berɛ) gɛnen Gyudasɛ baarɛ gi taasɛ Yesu yɛɛ, “Me-Wura, menɛ n wɔra so ne aye-wolɛ ne fo laa lɛɛ fo-nyoro gɛwi nyiile, ne abono mɛŋ kya sɔɔ Wurubuaarɛ gyi mɔ berɛ, fo maŋ lɛɛ fo-nyoro gɛwi nyiile mɔmɔ daa?” ");
INSERT INTO acd_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Yesu gi lɛɛ gɛnɔ sa mɔ yɛɛ, “Ɔbono ɔ kya laarɛ me-ilaa mɔ kya nu me-gɛdɛ. Me-sɛ Wurubuaarɛ laa laarɛ mɔ-ilaa, ne me‑rɛ me-sɛ Wurubuaarɛ a laa ba mɔ asɛ de aꞌ baa kyena mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ɔbono ɔ mɛŋ kya laarɛ me-ilaa mɔ, mɛŋ kya nu me-gɛdɛ. Ɔkalan ɔbono nɛ tɔgɛ sa fɛye faa mɛŋ lii me asɛ, ɔ lii daa Wurubuaarɛ ɔbono o sun me mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Ibono a san a tɛ dabɔlɛ faa ne nꞌ kya tɔgɛ fɛye gɛnen ilaa idɛ faa. ");
INSERT INTO acd_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Nengyene nɛ kyon mɔ, Wurubuaarɛ laa sun ɔko de ɔꞌ baa yii me-giyaa de ɔꞌ kpaa fɛye. Mɔ ne n gyɛ Wurubuaarɛ Oduduu mɔ. Ɔ laa baa nyiile fɛye ilaa kamaasɛ de oꞌ nyingi fɛye-ilaa ibono pɛwu nɛ tɔgɛ fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Gisen yuuli ne nꞌ dɛ mi‑i yela fɛye. Me-gisen yuuli ne nꞌ dɛ mi‑i sa fɛye. I mɛŋ gyɛ gɛsinkpan gɛdɛ so gisen yuuli mɔ ɔnan. Fɛ mɛŋ sa fɛꞌ yɛgɛ fɛye-asen aꞌ nyida fɛye. Fɛ mɛŋ sa fɛꞌ yɛgɛ iꞌ wɔra fɛye gifuu. ");
INSERT INTO acd_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","“Fɛ ti wolaa nu me nɛ tɔgɛ sa fɛye yɛɛ nan kpe de nꞌ kii ba fɛye asɛ. Nengyene fɛ kya laarɛ me-ilaa gɛsintin mɔ, nkana fɛ nu yɛɛ n kya kpe me-sɛ Wurubuaarɛ asɛ mɔ, i laa wɔra fɛye ɔkon daa. I kya nyiile yɛɛ me-sɛ gi don me. ");
INSERT INTO acd_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","N wolaa mi‑i buu mi‑i sa fɛye aberɛ adɛ pɛi de iꞌ lɔɔ ba. I san ba mɔ, de fɛꞌ nyɛ sɔɔ me gyi. ");
INSERT INTO acd_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Maŋ baa nyɛ tɔngɛ de fɛye gikyɔ iko. I kya nyiile yɛɛ ilaa nyɛnyɛn pɛwu gɛmu ɔbono ɔ bo ɔlon gɛsinkpan so mɔ kya ba. Me berɛ, ɔ mɛŋ bo ɔlon ɔko me so. ");
INSERT INTO acd_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","Ilaa ibono me-sɛ Wurubuaarɛ gi ka sa me mɔ ne nꞌ kya wɔra. Imɔ ne nan yɛgɛ asa mɛ laa wu bii yɛɛ n kya laarɛ me-sɛ Wurubuaarɛ ilaa. “Fɛꞌ koso de aꞌ lii gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Yesu gi kii tɔgɛ sa mɔ akasɛbo mɔ yɛɛ, “Me n dɛ fɛɛ oyii duusɛ kolon ɔbono me-sɛ Wurubuaarɛ gi duu mɔ. Mɔ ne n kya kerɛ gɛnen oyii ɔbono so. ");
INSERT INTO acd_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Me-gɛgyalenbi kamaasɛ gɛbono gɛ mɛŋ kya sɔrɔ abi mɔ, me-sɛ Wurubuaarɛ kya ŋɛ gɛmɔ fuɛ, ne me-gɛgyalenbi gɛbono, mɔ, gɛ kya sen ne gɛŋ kya sɔrɔ abi gikyɔ mɔ, ɔ kya ŋɛɛlɛ gɛmɔ-gimu so de gɛꞌ ba ngyalenbi de giꞌ nyɛ sɔrɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Fɛye ne n gyɛ me-ngyalenbi nbono Wurubuaarɛ kya kerɛ nmɔ so gɛnen mɔ. I kya nyiile yɛɛ kyu lii Wurubuaarɛ agyɛbi abono nɛ tɔgɛ sa fɛye mɔ so mɔ, fɛ nyɛ ne i kpaarɛ fɛye-ilaa nyɛnyɛn fuɛ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Fɛꞌ kyena me dɔ de me kee nꞌ kyena fɛye dɔ. Oyii gɛgyalenbi wolɛ gɛ maŋ taalɛ sɔrɔ abi gɛmɔ-gibaa so, gɛnen mɔ, gɛ kyaa de oyii mɔ. Gɛnen kee ne i dɛ sa fɛye ɔkamaasɛ faa. Fo-wolɛ fo maŋ taalɛ wɔra Wurubuaarɛ gɛlaarɛ ilaa wɔrasɛ, gɛnen mɔ, me‑rɛ fo ne n tɛ. ");
INSERT INTO acd_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Me ne n gyɛ oyii mɔ. Fɛye mɔ, ne n gyɛ oyii mɔ ngyalenbi mɔ. Ɔbono ɔ tɛ me dɔ ne me kee n tɛ mɔ dɔ mɔ, gɛnen kaasɛ ɔbono ne nan tansi wɔra Wurubuaarɛ gɛlaarɛ ilaa wɔrasɛ mɔ. Ne fɛɛ i mɛŋ gyɛ me‑rɛ fo ne n tɛ mɔ fo maŋ taalɛ wɔra imɔ iko‑rɛ iko. ");
INSERT INTO acd_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Nengyene nyamesɛ mɛŋ tɛ me dɔ mɔ, ɔ dɛ fɛɛ gɛgyalenbi gɛbono mɛ kya ŋɛɛlɛ fuɛ. Gɛ wolɛ ne asa mɛ kya puru kpaa too wɔra ɔgya dɔ de gɛꞌ dɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","“Nengyene fɛ tɛ me dɔ ne me-agyɛbi a tɛ fɛye dɔ mɔ, ilaa kamaasɛ ibono fɛ kya laarɛ ne fɛ dalaa kolɛ Wurubuaarɛ mɔ, ɔ laa wɔra imɔ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ilaa ibono i laa lɛɛ me-sɛ Wurubuaarɛ nyisigyi mɔ nyiile mɔ ne n gyɛ yɛɛ foꞌ tansi wɔra mɔ-gɛlaarɛ ilaa wɔrasɛ. Imɔ ne nan lɛɛ nyiile yɛɛ fɛ gyɛ me-akasɛbo gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","“Fɛɛ gɛnɔɔbono Wurubuaarɛ gi laarɛ me-ilaa mɔ, gɛnen ne me kee nɛ laarɛ fɛye-ilaa faa. Fɛꞌ kpɛ fɛ tɛ me dɔ de nꞌ laarɛ fɛye-ilaa gɛnen kyu i kya kpe. ");
INSERT INTO acd_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nengyene fɛ kya gyi me-nbara so mɔ, fɛ laa kyena me dɔ de nꞌ laarɛ fɛye-ilaa fɛɛ gɛnɔɔbono nɛ gyi me-sɛ Wurubuaarɛ nbara so, ne nꞌ tɛ mɔ dɔ ɔ kya laarɛ me-ilaa faa. ");
INSERT INTO acd_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nɛ buu gɛnen ilaa idɛ sa fɛye de iꞌ nyɛ wɔra fɛye ɔkon fɛɛ gɛnɔɔbono i bo me ɔkon mɔ. N kya laarɛ iꞌ wɔra fɛye-gisen dɔ ɔkon kpaa logɛ. ");
INSERT INTO acd_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","“Me-nbara nbono n dɛ n kya sa fɛye mɔ ne n gyɛ yɛɛ fɛꞌ laarɛ abara ilaa fɛɛ gɛnɔɔbono nɛ laarɛ fɛye-ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Gɛlaarɛ gɛko gɛŋ bo no gɛ baa don de ibono nyamesɛ laa sɔɔ mɔ-kyɛmenɛana lɛwu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ilaa ibono n kya ka fɛye yɛɛ fɛꞌ wɔra faa, ne fɛ wɔra imɔ mɔ, fɛ gyɛ me-kyɛmenɛana. ");
INSERT INTO acd_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Meŋ baa n kya terɛ fɛye yɛɛ me-adega. I kya nyiile yɛɛ dega mɛŋ nyi mɔ-ɔbelɛnsɛ gɛwɔnsa. Idɛ berɛ, nɛ terɛ fɛye daa yɛɛ me-kyɛmenɛana. I kya nyiile yɛɛ ilaa kamaasɛ ibono nɛ nu lii me-sɛ Wurubuaarɛ asɛ mɔ, nɛ kyu nyiile fɛye. ");
INSERT INTO acd_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","“I mɛŋ gyɛ fɛye ne n tɔɔsɛ me lɛɛ de nꞌ wɔra fɛye-ɔbelɛnsɛ. Me ne n tɔɔsɛ fɛye lɛɛ yɛɛ fɛꞌ wɔra Wurubuaarɛ gɛsun de iꞌ bara ilaa dɛnsɛ fɛɛ gɛnɔɔbono oyii kya sɔrɔ abi mɔ. N kya laarɛ yɛɛ gɛnen ilaa dɛnsɛ mɔ iꞌ dɛ kpe gɛkpaa-gɛkpaa. I ba gɛnen mɔ, fɛ dalaa kolɛ Wurubuaarɛ ilaa kamaasɛ me-ginyen dɔ mɔ, ɔ laa yɛgɛ iꞌ yii fɛye-gibaa. ");
INSERT INTO acd_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ilaa ibono n kya ka fɛye mɔ ne n gyɛ yɛɛ fɛꞌ laarɛ abara ilaa. ");
INSERT INTO acd_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Nengyene abono mɛŋ kya sɔɔ Wurubuaarɛ gyi mɔ mɛ kya kyo fɛye mɔ, fɛꞌ nyingi yɛɛ me ne mɛ wolaa kyo pɛi ne i tu fɛye gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Fɛɛ fɛye‑rɛ ɔmɔ fɛ gyɛ nyamesɛ kolon daa mɔ, nkana mɛ laa laarɛ fɛye-ilaa. Idɛ mɔ faa mɔ, fɛ mɛŋ baa fɛ gyɛ mɔmɔ dɔ. Nɛ tɔɔsɛ fɛye lɛɛ lii mɔmɔ dɔ. Imɔso ne mɛ kya kyo fɛye gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Fɛꞌ nyingi gigyɛbi gibono nɛ tɔgɛ sa fɛye mɔ. Nɛ tɔgɛ yɛɛ, ‘Dega mɛŋ kya don mɔ-ɔbelɛnsɛ.’ Nengyene mɛ ka me ɔbono n gyɛ fɛye-ɔbelɛnsɛ mɔ ansi mɔ, i dɛ i gyoo fɛye kee. Nengyene mɛ nu me-gɛdɛ mɔ, mɛ laa nu fɛye-gɛdɛ kee. ");
INSERT INTO acd_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Me so ne mɛ laa ka fɛye-ansi gɛnen. I kya nyiile yɛɛ mɛ mɛŋ nyi ɔbono o sun me mɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","“Nengyene fɛɛ meŋ ba gɛsinkpan gɛdɛ so de nꞌ baa tɔngɛ sa asa mɔ, nkana ilaa ibono mɛ kya wɔra faa, Wurubuaarɛ maŋ bun mɔmɔ gipuɛɛ. Imɔ idɛ, mɔ, nɛ ba ne mɛ nu lii me asɛ faa, mɛ mɛŋ baa mɛ bo ɔkyɛɛrɛgyanten. ");
INSERT INTO acd_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Nyamesɛ ɔbono ɔ kya kyo me mɔ kya kyo me-sɛ Wurubuaarɛ kee ne. ");
INSERT INTO acd_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Nɛ wɔra ilaa dɛgɛnɔsɛ ibonoana ɔko‑rɛ ɔko mɛŋ ti taa wɔra kerɛ. Ne fɛɛ nkana meŋ wɔra gɛnen de mɛꞌ wu de mɔmɔ-ansi mɔ, nkana ilaa ibono mɛ kya wɔra faa, Wurubuaarɛ maŋ bun mɔmɔ gipuɛɛ. Imɔ idɛ, mɔ, mɛ wu de mɔmɔ-ansi ne mɛ dabɔlɛ kyo me‑rɛ me-sɛ Wurubuaarɛ pɛwu. ");
INSERT INTO acd_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","I mɛŋ ba gɛnen giyan. I ba gɛnen mɔ, i kyena daa de ilaa ibono Wurubuaarɛ gi yɛgɛ mɛ ŋmarasɛ yela mɔ-agyɛbi ɔwolɛ mɔ dɔ sa mɔmɔ mɔ. Mɛ wolaa ŋmarasɛ nno yɛɛ, I mɛŋ bo ilaa kolon ibono so mɛ kyo me mɔ. ");
INSERT INTO acd_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Nan sun ɔbono ɔ laa kpaa fɛye mɔ fɛye asɛ. Mɔ ne n gyɛ Wurubuaarɛ Oduduu ɔbono ɔ laa lii Wurubuaarɛ asɛ mɔ. Ɔ gyɛ gɛsintin wura. Nengyene ɔ ba mɔ, ɔ laa lɛɛ me-ilaa nyiile asa. ");
INSERT INTO acd_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Fɛye kee fɛ laa lɛɛ me-ilaa nyiile asa. I kya nyiile yɛɛ kpɛ kyu lii owi ɔbono nɛ yii me-gɛsun mɔ gɛsɛ mɔ, me‑rɛ fɛye ne.” ");
INSERT INTO acd_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Awɔrɔfɔɔ abono a dɛ a gyoo fɛye mɔ so ne nɛ tɔgɛ gɛnen ilaa idɛ pɛwu sa fɛye, de fɛye-gisɔɔgyi mɔ gi mɛŋ sa giꞌ koso me so. ");
INSERT INTO acd_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Asa mɛ laa tii fɛye yɛɛ fɛye-giyaa gi maŋ nyɛ yii mɔmɔ-akyangbon dɔ. I mɛŋ gyɛ ibono wolɛ gbaa. Owi ɔko kya ba ibono fɛɛ ɔko gi mɔɔ fɛye dɔ ɔko mɔ, ɔ laa kyu imɔ yɛɛ Wurubuaarɛ ɔson mɔ dɔ ne ɔ kpɛ ɔ dɛ gɛnen yɛgɛ iŋ gyɛ gɛnen ne. ");
INSERT INTO acd_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ibono mɛ mɛŋ nyi me abɛɛ me-sɛ Wurubuaarɛ mɔ so ne mɛ laa wɔra fɛye gɛnen ilaa ibonoana faa. ");
INSERT INTO acd_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","I mɛŋ gyɛ giyan so ne nꞌ kya tɔgɛ fɛye gɛnen ilaa idɛ. Meŋ kya laarɛ awɔrɔfɔɔ mɔ aꞌ baa tuule fɛye. N kya laarɛ daa fɛɛ nengyene awɔrɔfɔɔ mɔ a baa tu fɛye mɔ de fɛꞌ nyingi yɛɛ nɛ wolaa tɔgɛ fɛye amɔ so ilaa yela de iꞌ nyɛ keda fɛye-nyoro. “Meŋ wolaa tɔgɛ gɛnen ilaa idɛ sa fɛye lii gɛsɛ de gɛsɛ. I kya nyiile yɛɛ n san n bo fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Idɛ kon berɛ, n kya kii n kya kpe ɔbono o sun me mɔ asɛ. Fɛye dɔ ɔko‑rɛ ɔko mɛŋ kii taasɛ me yɛɛ fonɛ ne n kya kpe. ");
INSERT INTO acd_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Nɛ wu yɛɛ ilaa ibono pɛwu nɛ tɔgɛ sa fɛye faa ne n yɛgɛ ne fɛye-asen dɔ i nyida fɛye gikyɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","N kya tɔgɛ fɛye gɛsintin yɛɛ nɛ kii kpe mɔ, fɛye ne i laa wɔra ɔdan sa. I kya nyiile yɛɛ nengyene meŋ kii kpe Wurubuaarɛ asɛ mɔ, ɔbono nan sun de ɔꞌ baa kpaa fɛye mɔ maŋ ba. Nengyene nɛ kii kpe mɔ, pɛi ne nan sun mɔ fɛye asɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","“Ɔ ba mɔ, ɔ laa bugi anyamesɛ nwɔnsa kyu lii ilaa nyɛnyɛn giwɔra de gɛsintin gigyi de gipuɛɛ gibun so. Ɔ laa nyiile mɔmɔ yɛɛ mɔmɔ-nwɔnsa nbono mɛ dɛ kyu lii gɛnen ilaa ibonoana so mɔ iŋ kyena. ");
INSERT INTO acd_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Kyu lii ilaa nyɛnyɛn giwɔra so mɔ, Wurubuaarɛ Oduduu mɔ laa yɛgɛ asa mɛꞌ bii yɛɛ mɛ gyɛ ilaa nyɛnyɛn awɔrabo. I lii fɛɛ mɛ mɛŋ kyu mɔmɔ-nyoro too me so. ");
INSERT INTO acd_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Kyu lii gɛsintin gigyi so mɔ, Wurubuaarɛ Oduduu mɔ laa yɛgɛ asa mɛꞌ bii yɛɛ nɛ gyi gɛsintin sa Wurubuaarɛ. I lii fɛɛ nan kpe me-sɛ Wurubuaarɛ asɛ ne fɛŋ baa wu me. ");
INSERT INTO acd_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ne kyu lii gipuɛɛ gibun so mɔ, Wurubuaarɛ Oduduu mɔ laa yɛgɛ asa mɛꞌ bii kee yɛɛ mɛŋ kyɛɛgɛ mɔ, Wurubuaarɛ laa bun ɔmɔ gipuɛɛ. I lii fɛɛ ɔ ti bun ilaa nyɛnyɛn pɛwu gɛmu ɔbono ɔ bo ɔlon gɛsinkpan so mɔ gipuɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“N san n bo ilaa gikyɔ nan tɔgɛ sa fɛye. Imɔ gɛnen mɔ, nengyene nɛ tɔgɛ imɔ pɛwu ayaa adɛ so mɔ, i laa don fɛye-abaa, fɛ maŋ taalɛ nu imɔ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Wurubuaarɛ Oduduu mɔ ne n gyɛ ɔbono ɔ kya lɛɛ Wurubuaarɛ gɛsintin ilaa nyiile. Nengyene gɛnen Wurubuaarɛ Oduduu ɔbono gi ba mɔ, mɔ ne nan baa gyangbara sa fɛye de fɛꞌ bii Wurubuaarɛ gɛsintin ilaa mɔ pɛwu. I kya nyiile yɛɛ i mɛŋ gyɛ mɔ-gibaa so ne ɔ laa baa tɔngɛ. Ilaa ibono o nu mɔ, imɔ ne ɔ laa tɔgɛ, ne ɔ laa tɔgɛ fɛye ilaa ibono i laa baa ba mɔ. ");
INSERT INTO acd_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Wurubuaarɛ Oduduu mɔ laa kyu nyisigyi bara me. Ɔ laa lɛɛ ilaa ibono i gyɛ me-lɛɛ mɔ gɛwi nyiile fɛye. ");
INSERT INTO acd_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ilaa ibono pɛwu me-sɛ Wurubuaarɛ bo mɔ, i gyɛ me-lɛɛ. Imɔso ne nɛ tɔgɛ yɛɛ Wurubuaarɛ Oduduu mɔ laa lɛɛ ilaa ibono i gyɛ me-lɛɛ mɔ gɛwi nyiile fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“I san daa ŋmaraa faa, fɛ maŋ baa wu me ne i kii wɔra ŋmaraa mɔ, fɛ laa kii wu me.” ");
INSERT INTO acd_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Yesu gi tɔgɛ gɛnen mɔ, mɔ-akasɛbo mɔ ako mɛ kya taasɛ abara yɛɛ, “Menɛ ilaa ne ɔ darɛ gɛnen? Ɔ kya tɔgɛ yɛɛ i san daa ŋmaraa faa, a maŋ baa wu mɔ, ne i kii wɔra ŋmaraa mɔ, a laa kii wu mɔ. O kii tɔgɛ kee yɛɛ ɔ kya kpe mɔ-sɛ Wurubuaarɛ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mɛ kpɛ san ma‑a taasɛ abara yɛɛ, “Menɛ ne ɔ darɛ yɛɛ, ‘ŋmaraa daa faa’? A mɛŋ kya nu imɔ gɛsɛ.” ");
INSERT INTO acd_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Yesu akasɛbo mɔ mɛ kpɛ ma‑a taasɛ abara gɛnen mɔ, ɔ bii yɛɛ mɛ kya laarɛ fɛɛ mɛꞌ taasɛ mɔ imɔ gɛsɛ. Ɔ taasɛ mɔmɔ yɛɛ, “Ibono nɛ tɔgɛ fɛye yɛɛ, ‘I san daa ŋmaraa faa, fɛ maŋ baa wu me; ne i kii wɔra ŋmaraa mɔ, fɛ laa kii wu me’ mɔ, imɔ gɛsɛ ne fɛ kya taasɛ abara faa? ");
INSERT INTO acd_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","N kya tɔgɛ fɛye gɛsintin; ilaa ibono i laa ba me so mɔ, fɛ laa saawo de fɛꞌ yiyɛɛ. Asa abono mɛŋ kya sɔɔ Wurubuaarɛ gyi mɔ berɛ i laa wɔra mɔmɔ ɔkon. Imɔ gɛnen mɔ, fɛye-gɛyiyɛɛ mɔ gɛ laa baa bingiri ɔkon sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","I laa wɔra fɛye fɛɛ owi ɔbono ɔkyii kya dun mɔ. Gɛnen owi ɔbono dɔ mɔ, ɔ kya yiyɛɛ, i kya nyiile yɛɛ gɛdun gɛ yii mɔ. Nengyene ɔ nyɛ ne ɔ korogɛ mɔ, ɔ kya tan mɔ-gɛyiyɛɛ mɔ so. Ɔŋ baa ɔ kya nyingi imɔ. I kya nyiile yɛɛ i kya wɔra mɔ ɔkon yɛɛ ɔ korogɛ nyamesɛ ba gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Gɛnen ne i laa baa wɔra fɛye kee ne. Nperɛ faa berɛ mɔ, fɛ bo gɛyiyɛɛ dɔ. Nan kii ba fɛye asɛ de fɛye-gisen giꞌ tɔrɔ fɛye. Gɛnen owi ɔbono mɔ ɔko mɛŋ bo no ɔ laa taalɛ sɔgɛ ɔkon ɔbono fɛ laa gyi mɔ lii fɛye-abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Nengyene gɛnen gɛkɛ gɛbono gɛ fo mɔ, fɛ maŋ baa taasɛ me ilaa taasɛsɛ iko. “Gɛsintin ne n kya tɔgɛ mi‑i sa fɛye faa; ilaa kamaasɛ ibono fɛ laa dalaa kolɛ lii Wurubuaarɛ asɛ mɔ, ɔ laa yɛgɛ de iꞌ yii fɛye-gibaa kyu lii me Yesu so. ");
INSERT INTO acd_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Fɛ mɛŋ ti taa dalaa kolɛ Wurubuaarɛ ilaa iko kyu naa de me so gɛkaako kerɛ. Fɛꞌ dalaa kolɛ mɔ kyu naa de me so. Ɔ laa yɛgɛ iꞌ yii fɛye-gibaa de iꞌ tansi wɔra fɛye-asen dɔ ɔkon. ");
INSERT INTO acd_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Akpalɛ dɔ ne nɛ tɔgɛ me-sɛ ilaa sa fɛye faa. Owi ɔko kya ba ibono maŋ baa da fɛye akpalɛ kyu lii mɔ so. Nan san tɔgɛ me-sɛ Wurubuaarɛ ilaa sa fɛye mɔ, nan tɔgɛ tigi fɛye daa. ");
INSERT INTO acd_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","San kyu lii gɛnen owi ɔbono kyu kyon mɔ, fɛ laa dalaa kolɛ Wurubuaarɛ ilaa kyu naa de me so. I mɛŋ gyɛ yɛɛ me ne nan kolɛ me-sɛ Wurubuaarɛ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Me-sɛ Wurubuaarɛ gbaa-gbaa kya laarɛ fɛye-ilaa. I kya nyiile yɛɛ fɛ laarɛ me-ilaa ne fɛ sɔɔ me gyi yɛɛ nɛ kpelegɛ lii daa Wurubuaarɛ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Nɛ lii me-sɛ asɛ ne nɛ ba gɛsinkpan so. Nperɛ mɔ n kya lii gɛsinkpan so n kya kii mi‑i kpe me-sɛ Wurubuaarɛ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Yesu gi tɔgɛ gɛnen mɔ, mɔ-akasɛbo mɔ mɛ tɔgɛ sa mɔ yɛɛ, “Foŋ wu? Idɛ kon berɛ ne fo tɔgɛ tigi aye ne. Foŋ baa tɔngɛ akpalɛ dɔ sa aye. ");
INSERT INTO acd_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Idɛ kon ne a bii yɛɛ fo nyi ilaa kamaasɛ. I mɛŋ baa i tiri yɛɛ ɔko ɔꞌ baa taasɛ fo ilaa. Imɔ idɛ i yɛgɛ aꞌ sɔɔ fo gyi yɛɛ fo lii daa Wurubuaarɛ asɛ gɛsintin.” ");
INSERT INTO acd_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Mɛ tɔgɛ gɛnen ta mɔ, Yesu gi taasɛ mɔmɔ yɛɛ, “Idɛ kon berɛ, fɛ sɔɔ me gyi? ");
INSERT INTO acd_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","To, owi ɔko kya ba, ɔ ti fo gbaa, ibono fɛ laa yaasɛ giyan-giyan de fɛꞌ kii kpe fɛye-nwi taa me yɛgɛ de iꞌ san me-nkon. I maŋ kii san me-nkon berɛ. Me-sɛ Wurubuaarɛ bo me asɛ. ");
INSERT INTO acd_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Nɛ tɔgɛ gɛnen ilaa idɛ sa fɛye daa de fɛꞌ nyɛ gisen yuuli. I lii fɛɛ me‑rɛ fɛye a wɔra nyamesɛ kolon. Asa mɛ laa yɛgɛ fɛꞌ wu awɔrɔfɔɔ gɛsinkpan so gɛrɛ. Imɔ gɛnen gbaa mɔ, fɛꞌ yɛgɛ iꞌ keda fɛye-nyoro. Nɛ ti gyi anyamesɛ ɔlon pɛwu so.” ");
INSERT INTO acd_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Yesu gi tɔgɛ gɛnen ta mɔ, ɔ diirɛ mɔ-ansi kerɛ soso ne ɔ dalaa sa Wurubuaarɛ yɛɛ, “Me-sɛ, owi mɔ gi fo. Lɛɛ me, fo-bi mɔ nyisigyi nyiile asa. Fo lɛɛ me-nyisigyi nyiile mɔ, de me, fo-bi mɔ nꞌ lɛɛ fo-lɛɛ nyisigyi mɔ nyiile. ");
INSERT INTO acd_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Fo sa me ɔlon nyamesɛ kamaasɛ so de nꞌ yɛgɛ asa abono fo sa me mɔ mɛꞌ kyena fo Wurubuaarɛ asɛ gɛkpaa-gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Gɛnɔɔbono asa mɛ laa nyɛ fo asɛ gɛkyena gɛkpaa mɔ ne n gyɛ yɛɛ mɛꞌ bii fo ɔbono fo-nkon ne n gyɛ Wurubuaarɛ mɔ, de mɛꞌ bii me, Yesu Kirisito ɔbono fo sun me mɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nɛ lɛɛ fo-nyisigyi mɔ gɛwi nyiile. I lii fɛɛ nɛ logɛ gɛsun gɛbono fo sa me yɛɛ nꞌ baa wɔra gɛsinkpan so mɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Idɛ kon, me-sɛ, fo‑o fo mɔ, yɛgɛ nꞌ gyi ginsi fo asɛ, de foꞌ kiiri me-nyisigyi ɔbono n wolaa n bo mɔ fo asɛ pɛi ne soso de gɛsɛ iꞌ lɔɔ wɔra ilɛɛsɛ mɔ sa me. ");
INSERT INTO acd_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Asa abono fo sa me lii asa sɛnsɛ dɔ mɔ, nɛ lɛɛ fo-gidebi mɔ nyiile mɔmɔ. Mɛ wolaa mɛ gyɛ daa fo-lɛɛ pɛi ne fo kyu ɔmɔ kyu sa me. Mɔmɔ, mɔ, mɛ nu fo-gɛdɛ. ");
INSERT INTO acd_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Idɛ kon mɛ bii yɛɛ ilaa kamaasɛ ibono fo kyu sa me mɔ, i lii daa fo asɛ. ");
INSERT INTO acd_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Ikalan ibono fo sa me mɔ, nɛ tɔgɛ mɔmɔ, ne mɔmɔ, mɔ, mɛ nu me asɛ, ne mɛ bii ibono i gyɛ gɛsintin yɛɛ nɛ lii fo asɛ. Mɛ sɔɔ gyi yɛɛ fo ne n sun me. ");
INSERT INTO acd_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Mɔmɔ ne nꞌ kya dalaa mi‑i sa faa. Iŋ gyɛ asa sɛnsɛ ne n kya dalaa mi‑i sa. Mɔmɔ abono fo kyu sa me ne mɛ sɔɔ me gyi mɔ ne nꞌ kya dalaa n kya sa. I kya nyiile yɛɛ mɛ gyɛ daa fo-lɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ɔkamaasɛ ɔbono ɔ gyɛ me-lɛɛ mɔ, ɔ gyɛ daa fo-lɛɛ ne ɔkamaasɛ ɔbono ɔ gyɛ fo-lɛɛ mɔ, ɔ gyɛ me-lɛɛ kee. N kya nyɛ nyisigyi kyu naa de mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Idɛ kon berɛ maŋ baa kyena gɛsinkpan so. Mɔmɔ adɛ berɛ mɛ san mɛ tɛ saarɛ asa abono mɛ mɛŋ sɔɔ fo gyi mɔ dɔ. Mi‑i me mɔ, n kya kii n kya ba fo asɛ mi‑i taa ɔmɔ mi‑i yɛgɛ. Imɔso, me-sɛ, fo ɔbono fo-nkon ne n gyɛ Wurubuaarɛ mɔ, kyu ɔlon ɔbono fo sa me mɔ, kyu kerɛ mɔmɔ so de mɛꞌ wɔra nyamesɛ kolon fɛɛ gɛnɔɔbono me‑rɛ fo a gyɛ nyamesɛ kolon mɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Owi ɔbono n bo mɔmɔ asɛ mɔ, nɛ kyu fo-ɔlon kerɛ mɔmɔ so, gɛnen ɔlon ɔbono ne fo kyu sa me mɔ. Nɛ kun mɔmɔ, ne mɔmɔ dɔ ba‑a nyamesɛ kolon meŋ yɛgɛ mɔ-ɔkyenaten ɔbono ɔ laa nyɛ fo asɛ mɔ ɔꞌ lii mɔ-gibaa, gɛnen mɔ, ɔkolon ɔbono i wolaa i gyɛ mɔ-npaaba mɔ wolɛ, de iꞌ yɛgɛ ilaa ibono mɛ ŋmarasɛ yela fo-agyɛbi mɔ dɔ mɔ iꞌ ba gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Idɛ kon n kya kii mi‑i ba fo asɛ ne. N san n bo gɛsinkpan so faa mɔ, n kya tɔgɛ gɛnen ilaa idɛ, de ɔkon ɔbono nɛ nyɛ mɔ, mɔmɔ adɛ kee mɛꞌ nyɛ gɛnen ɔkon ɔbono kpaa logɛ. ");
INSERT INTO acd_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nɛ tɔgɛ fo-ɔkalan mɔ sa me-adɛ adɛ, ne abono mɛŋ kya sɔɔ fo gyi mɔ mɛ kya kyo mɔmɔ. I kya nyiile yɛɛ mɛŋ gyɛ ɔmɔ dɔ, fɛɛ gɛnɔɔbono me kee, meŋ gyɛ mɔmɔ dɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Meŋ kya dalaa yɛɛ foꞌ lɛɛ mɔmɔ lii abono mɛ mɛŋ kya sɔɔ fo Wurubuaarɛ gyi mɔ dɔ daa. N kya kolɛ fo daa yɛɛ foꞌ kerɛ mɔmɔ so de Ɔbonsan, nyamesɛ nyɛnyɛn mɔ, ɔ mɛŋ sa ɔꞌ nyɛ ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Meŋ gyɛ abono mɛŋ kya sɔɔ fo gyi mɔ dɔ. Gɛnen kee me-adɛ adɛ mɛŋ gyɛ abono mɛŋ kya sɔɔ fo gyi mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Lɔrɔ mɔmɔ yela sa fo-nyoro kyu naa de fo Wurubuaarɛ gɛsintin mɔ so. Fo-agyɛbi mɔ ne n gyɛ gɛnen gɛsintin gɛbono. ");
INSERT INTO acd_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Fɛɛ gɛnɔɔbono fo Wurubuaarɛ fo sun me ba abono mɛŋ kya sɔɔ fo gyi mɔ asɛ mɔ, gɛnen ne me kee n kya sun me-akasɛbo adɛ asa abono mɛŋ kya sɔɔ fo gyi mɔ asɛ ne. ");
INSERT INTO acd_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Mɔmɔ so mɔ, nɛ lɔrɔ me-nyoro yela sa fo de mɔmɔ kee mɛꞌ nyɛ lɔrɔ ɔmɔ-nyoro yela sa fo gɛsintin mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Yesu gi kii dalaa yɛɛ, “I mɛŋ gyɛ adɛ wolɛ ne nꞌ kya dalaa n kya sa. N kya dalaa n kya sa asa abono kee mɛ laa kyu mɔmɔ-nyoro too me so kyu lii ɔkalan ɔbono adɛ mɛ laa tɔgɛ sa mɔmɔ mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Me-sɛ, yɛgɛ mɔmɔ pɛwu mɛ wɔra nyamesɛ kolon. Fɛɛ gɛnɔɔbono fo bo me dɔ ne me kee n bo fo dɔ mɔ, yɛgɛ mɔmɔ kee mɛꞌ kyena aye dɔ de iꞌ yɛgɛ asa abono mɛ mɛŋ kya sɔɔ fo gyi mɔ mɛꞌ nyɛ sɔɔ gyi yɛɛ fo ne n sun me. ");
INSERT INTO acd_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Fo-nyisigyi ɔbono fo kyu sa me mɔ, nɛ kyu sa mɔmɔ. Imɔ ne nan yɛgɛ mɛꞌ wɔra nyamesɛ kolon fɛɛ gɛnɔɔbono me‑rɛ fo a gyɛ nyamesɛ kolon faa. ");
INSERT INTO acd_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Nan kyena mɔmɔ dɔ de fo fo, mɔ, foꞌ kyena me dɔ, de mɛꞌ nyɛ wɔra nyamesɛ kolon kpaa logɛ. I ba gɛnen mɔ, asa abono mɛŋ kya sɔɔ fo gyi mɔ mɛ laa nyɛ bii yɛɛ fo ne n sun me ne fo kya laarɛ mɔmɔ-ilaa fɛɛ gɛnɔɔbono fo kya laarɛ me-ilaa mɔ. ");
INSERT INTO acd_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Me-sɛ, me-gisen dɔ mɔ, n kya laarɛ fɛɛ nfono nan kyena mɔ, mɔmɔ abono fo kyu sa me mɔ me‑rɛ ɔmɔ aꞌ kyena nno de mɛꞌ nyɛ wu me-nyisigyi ɔbono fo kyu sa me pɛi ne soso de gɛsɛ iꞌ lɔɔ wɔra ilɛɛsɛ mɔ. Gɛnɔɔbono fo laarɛ me-ilaa mɔ ne n yɛgɛ ne fo kyu gɛnen nyisigyi ɔbono sa me. ");
INSERT INTO acd_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O, me-sɛ, Gɛsintin Wura, anyamesɛ mɛ mɛŋ nyi fo gɛsinkpan gɛdɛ so. Me berɛ n nyi fo. Ne me-adɛ mɔ kee, mɛ nyɛ bii yɛɛ fo ne n sun me. ");
INSERT INTO acd_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Nɛ lɛɛ fo-gidebi mɔ nyiile mɔmɔ. Ne nan kpɛ mi‑i lɛɛ fo-gidebi mɔ n kya nyiile mɔmɔ de gɛlaarɛꞌ gɛbono fo bo sa me mɔ gɛꞌ kyena mɔmɔ dɔ, de me kee nꞌ kyena mɔmɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Yesu gi dalaa gɛnen ta mɔ, mɔ‑rɛ mɔ-akasɛbo mɔ mɛ lii fara Kideron gɛkolobi mɔ kyon kpe ndɔɔ nko dɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Yesu mɔ‑rɛ mɔ-akasɛbo mɔ mɛ kya kyena kpaa gyanꞌ nno. Imɔso Gyudasɛ ɔbono ɔ kya laarɛ oꞌ kyu Yesu wɔra abelɛnsɛ mɔ abaa dɔ mɔ nyi nno. ");
INSERT INTO acd_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Gyudasɛ baarɛ gi kpe Gyuda awura asunbi alɛɛbo abelɛnsɛ de Farasii awura asɛ ne mɛ lɛɛ mɔmɔ-asogya gikpen belɛ de Wurubuaarɛ ɔson obu mɔ dɔ adiibo ako kyu wɔra de mɔ yɛɛ mɛꞌ kpe ndɔɔ mɔ dɔ kpaa keda Yesu. Mɛ kya kpe mɔ, mɛ dɛ ifatela de afulaa de adontɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Yesu gi ti wolaa bii ilaa ibono i kya ba mɔ so mɔ. Gɛnen so mɔ, ɔ lii kpaa gyangara mɔmɔ ne ɔ taasɛ mɔmɔ yɛɛ, “Anɛ ne fɛ kya laarɛ?” ");
INSERT INTO acd_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Yesu gi taasɛ mɔmɔ gɛnen mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Yesu, Nasarɛtɛnyen mɔ ne a kya laarɛ.” Ne Yesu gi tɔgɛ sa mɔmɔ yɛɛ, “Me ne.” (Gɛnen owi ɔbono dɔ mɔ, Gyudasɛ ɔbono ɔ yɛgɛ abelɛnsɛ mɔ mɛ nyɛ mɔ gɛnen mɔ yelɛ mɔmɔ asɛ nfono.) ");
INSERT INTO acd_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Yesu gi tɔgɛ sa mɔmɔ yɛɛ “Me ne” mɔ, mɛ kii gɛmara ŋmaraa ne mɛ lii-lii tɔrɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yesu gi kii lɔrɔ taasɛ mɔmɔ yɛɛ, “Anɛ ne fɛ kya laarɛ?” Ne mɛ lɛɛ gɛnɔ yɛɛ, “Yesu, Nasarɛtɛnyen mɔ ne a kya laarɛ.” ");
INSERT INTO acd_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Yesu gi kii tɔgɛ sa mɔmɔ yɛɛ, “Meŋ buu sa fɛye yɛɛ, ‘Me ne’? Imɔso nengyene me ne fɛ kya laarɛ berɛ mɔ, fɛꞌ yɛgɛ de me-akasɛbo adɛ mɛꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Yesu gi tɔgɛ gɛnen ilaa idɛ de iꞌ yɛgɛ ibono ɔ wolaa daa gitɔgɛ mɔ, iꞌ nyɛ ba gɛsintin. Ɔ wolaa tɔgɛ sa mɔ-sɛ Wurubuaarɛ yɛɛ, “Asa abono fo kyu sa me mɔ, meŋ yɛgɛ mɔmɔ dɔ ba‑a ɔkolon ɔkyenaten Wurubuaarɛ asɛ mɔ ɔꞌ lii mɔ-gibaa.” ");
INSERT INTO acd_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Mɛ kya laarɛ de mɛꞌ keda Yesu mɔ, Simon Piita gi loorɛ gɛki gɛbono ɔ dɛ mɔ lɛɛ ne ɔ ŋɛɛlɛ dega ɔko giso fuɛ. Mɛ kya terɛ dega mɔ yɛɛ Malekosi. Mɔ-wura ne n gyɛ Gyuda awura asunbi alɛɛbo gɛmu mɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Yesu gi wu gɛnen mɔ, ɔ tɔgɛ sa Piita yɛɛ, “Kiiri gɛki mɔ wɔra gɛmɔ-gifɔrɔ dɔ.” Ne ɔ taasɛ mɔ yɛɛ, “Meŋ sa nꞌ wu awɔrɔfɔɔ abono me-sɛ Wurubuaarɛ yɛɛ nꞌ wu mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nfono mɔ, asogya mɔ de mɔmɔ-ɔbelɛnsɛ mɔ de Wurubuaarɛ ɔson obu mɔ adiibo mɔ mɛ keda Yesu ne mɛ ŋminde mɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Mɛ ŋminde mɔ gɛnen mɔ, mɛ daa gikyu mɔ kpe Anasɛ asɛ daa pɛi. (Anasɛ ne n gyɛ Kayifasɛ mɔ-saa nyensɛ. Gɛnen Kayifasɛ baarɛ ne n gyɛ Gyuda awura asunbi alɛɛbo gɛmu gɛnen gɛsi gɛbono. ");
INSERT INTO acd_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Mɔ ne n gyɛ ɔbono ɔ wolaa tɔgɛ gigyɛbi giko sa Gyuda awura abelɛnsɛ mɔ baa kyon mɔ. Ɔ tɔgɛ yɛɛ, “Nyamesɛ kolon gi tɛsɛ wuꞌ sa asa mɔ pɛwu mɔ, i boran.”) ");
INSERT INTO acd_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Mɛ dɛ Yesu mɛ kya kpe Anasɛ asɛ gɛnen mɔ, Simon Piita de me, Yesu ɔkasɛbo ɔko, a buu mɔ. Me berɛ, me‑rɛ asunbi alɛɛbo gɛmu mɔ a nyi abara so mɔ, nɛ nyɛ buu Yesu loo gikpaara mɔ so. Ne i san Piita gi sii ɔ yelɛ nŋmaŋman gɛbunono asɛ. ");
INSERT INTO acd_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","O sii gɛnen mɔ, nɛ kii kpe gɛbunono mɔ asɛ ne nɛ kpaa tɔngɛ de obolonbu ɔbono ɔ kya kerɛ gɛbunono mɔ so mɔ, ne o kyu Piita loo. ");
INSERT INTO acd_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Piita kya loo mɔ, obolonbu mɔ gi taasɛ mɔ yɛɛ, “Fo kee foŋ bo ɔnyen baarɛ akasɛbo mɔ dɔ?” Piita gi kine yɛɛ, “Kuaa! Meŋ gyɛ mɔ-akasɛbo mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gɛnen owi ɔbono gyɛ awo aberɛ so mɔ, asunbi alɛɛbo gɛmu mɔ adega de abono mɛ kya dii mɔ-gɛten mɔ mɛ wɔra ɔgya gikpaara mɔ so mɛ yelɛ mɛ kya wolɛ. Piita gi naa sii yelɛ mɔmɔ asɛ, mɔ kee kya wolɛ ɔgya mɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Yesu bo Gyuda awura asunbi alɛɛbo gɛmu mɔ asɛ gɛnen mɔ, ɔ taasɛ Yesu ilaa kyu lii mɔ-akasɛbo de mɔ-ilaa nyiilesɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Nɛ yelɛ tentegelen tɔngɛ Wurubuaarɛ ilaa sa ɔkamaasɛ. Owi kamaasɛ dɔ mɔ, nɛ nyiile asa ilaa akyangbon dɔ de Wurubuaarɛ ɔson obu mɔ gikpaara mɔ so, nfono Gyuda awura pɛwu mɛ kya kpaa gyanꞌ mɔ. Meŋ tɔgɛ sɛi asiiri dɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Imɔso gɛŋ sa foꞌ taasɛ me. Kpaa taasɛ asa abono mɛ nu me-ilaa nyiilesɛ mɔ. Mɛ nyi ilaa ibono nɛ tɔgɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Yesu gi lɛɛ gɛnɔ gɛnen mɔ, abono mɛ kya dii gɛten mɔ dɔ ɔko yelɛ sindi Yesu. Ɔ fon Yesu ɔtan ne ɔ taasɛ mɔ yɛɛ, “Gɛnen ne i kaaborɛ foꞌ tɔngɛ de asunbi alɛɛbo gɛmu mɔ ne?” ");
INSERT INTO acd_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “Nengyene nɛ tɔgɛ ilaa iko ne i mɛŋ boran mɔ, tɔgɛ de nꞌ nu. Ne i gyɛ ilaa dɛnsɛ ne nɛ kii tɔgɛ daa mɔ, i gyɛ itan ilaa daa?” ");
INSERT INTO acd_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Nfono mɔ mɛ kparɛ Yesu de ɔfɛ kpe Kayifasɛ ɔbono ɔ gyɛ asunbi alɛɛbo gɛmu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Piita san ɔ yelɛ ɔgya mɔ asɛ ɔ kya wolɛ mɔ, nfono mɔ, asa abono mɛ bo ɔgya mɔ asɛ mɔ mɛ taasɛ mɔ yɛɛ, “Fo kee fo mɛŋ gyɛ Yesu akasɛbo mɔ dɔ ɔko?” Ne Piita gi lɛɛ gɛnɔ yɛɛ, “Kuaa! Meŋ gyɛ mɔ-akasɛbo mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mɛ taasɛ Piita gɛnen mɔ, asunbi alɛɛbo gɛmu mɔ-dega ɔko bo nfono, mɔ‑rɛ ɔbono Piita gi kɛbi mɔ-giso mɔ mɛ bo gɛsu. Gɛnen dega baarɛ gi taasɛ Piita yɛɛ, “Meŋ wu fo Yesu asɛ ndɔɔ mɔ dɔ?” ");
INSERT INTO acd_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Ne Piita gi lɛɛ gɛnɔ yɛɛ, “Kuaa.” Ayaa abono so mɔ, kyaasɛ gi folɛ. ");
INSERT INTO acd_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Gɛdɛ gɛ kpɛ kɛ mɔ, Gyuda awura abelɛnsɛ mɔ mɛ kyu Yesu lii Kayifasɛ asɛ kyu mɔ kpe Ɔbelɛnsɛ Pilato gɛwi. Ɔbelɛnsɛ Pilato baarɛ tɛ sa Rom awura ɔ kya kerɛ mɔmɔ Gyuda awura so. Gyuda awura mɔ Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ gɛ fo so mɔ, mɛ kpe Ɔbelɛnsɛ Pilato gɛwi gɛnen mɔ, mɔmɔ gbaa-gbaa berɛ, mɛ mɛŋ loo gɛten mɔ dɔ. I kya nyiile yɛɛ nengyene mɛ loo gɛten mɔ dɔ mɔ, i laa kyɔlesɛ mɔmɔ-Wurubuaarɛ ɔson. I kyɔlesɛ mɔmɔ mɔ, mɛ maŋ nyɛ gyi mɔmɔ-gɛkɛ belɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gɛnen so mɔ, Ɔbelɛnsɛ Pilato gi lii kpe mɔmɔ asɛ ne ɔ taasɛ mɔmɔ yɛɛ, “Menɛ ilaa ne ɔnyen baarɛ gi wɔra so ne fɛ dɛ mɔ fɛ kya bara me?” ");
INSERT INTO acd_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ɔ taasɛ mɔmɔ gɛnen mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Nengyene ɔ mɛŋ gyɛ ilaa nyɛnyɛn ɔwɔrabo mɔ, nkana a maŋ kyu mɔ baa wɔra fo-abaa dɔ.” ");
INSERT INTO acd_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Nfono ne Ɔbelɛnsɛ Pilato gi tɔgɛ sa Gyuda awura abelɛnsɛ mɔ yɛɛ, “Fɛꞌ kyu mɔ naa, de fɛye gbaa-gbaa fɛꞌ kpaa kyu fɛye-lɛɛ nbara kpaa gyi mɔ-nbɛlɛ.” Pilato gi tɔgɛ sa mɔmɔ gɛnen mɔ, mɛ tɔgɛ sa mɔ yɛɛ, “Rom awura abɛyin mɔ mɛŋ sa aye ɔkpa yɛɛ aꞌ mɔɔ isa.” ");
INSERT INTO acd_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Gɛnen ilaa ibono Gyuda awura abelɛnsɛ mɔ mɛ tɔgɛ sa Pilato faa, i yɛgɛ ilaa ibono Yesu gi wolaa tɔgɛ kyu lii lɛwu ɔbono ɔnan ɔ laa wuꞌ mɔ so mɔ iꞌ nyɛ ba gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Ɔbelɛnsɛ Pilato gi nu gɛnen mɔ, o kii naa loo mɔ-gɛten dɔ ne ɔ terɛ Yesu ne ɔ taasɛ mɔ yɛɛ, “Fo ne n gyɛ wura sa Gyuda awura mɔ?” ");
INSERT INTO acd_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo gbaa-gbaa ne n kya tɔgɛ abɛɛ ako ne n tɔgɛ me-ilaa sa fo daa?” ");
INSERT INTO acd_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Ne Pilato gi taasɛ Yesu yɛɛ, “Fo nyi yɛɛ n gyɛ Gyudanyen? Fo gbaa-gbaa fo-gɛwi awura de mɔmɔ-asunbi alɛɛbo abelɛnsɛ ne n kyu fo baa wɔra me-abaa dɔ. Menɛ ilaa ne fo tansi wɔra daa?” ");
INSERT INTO acd_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Nfono ne Yesu gi lɛɛ gɛnɔ yɛɛ, “I mɛŋ gyɛ gɛsinkpan so gɛwura ɔnan ne nꞌ kya gyi. Nengyene me-gɛwuragyi gɛ gyɛ gɛsinkpan so lɛɛ ɔnan mɔ, nkana me-adɛ mɛ laa kɔ de meŋ sa nꞌ loo Gyuda awura abelɛnsɛ adɛ abaa dɔ. Idɛ mɔ faa mɔ, me-gɛwuragyi gɛŋ bo gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Ɔbelɛnsɛ Pilato gi taasɛ mɔ yɛɛ, “Gɛnen berɛ mɔ, fo gyɛ wura ne?” Ne Yesu gi lɛɛ gɛnɔ yɛɛ, “Fo ne n kya tɔgɛ yɛɛ n gyɛ wura. I korogɛ me ba gɛsinkpan so de nꞌ baa lɛɛ gɛsintin nyiile anyamesɛ de mɛꞌ nyɛ bii gɛmɔ-ilaa. Imɔso ne nɛ ba. Nyamesɛ kamaasɛ ɔbono ɔ kya laarɛ gɛsintin mɔ kya nu me asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nfono mɔ, Ɔbelɛnsɛ Pilato gi taasɛ yɛɛ, “Menɛ, mɔ, ne n gyɛ gɛsintin?” Nfono mɔ Pilato gi lii kpe Gyuda awura mɔ asɛ, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Meŋ wu ilaa nyɛnyɛn kolon ibono ɔnyen baarɛ gi wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","I wolaa i gyɛ ilaa ibono a kya wɔra sa fɛye gɛsi kamaasɛ yɛɛ nengyene fɛ kya gyi fɛye Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ, n kya tigi fɛye asa abono nɛ keda tii de obu mɔ dɔ nyamesɛ kolon de ɔꞌ naa. Imɔso nꞌ tigi fɛye Gyuda awura wura mɔ sa fɛye de ɔꞌ naa?” ");
INSERT INTO acd_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Ɔbelɛnsɛ Pilato gi taasɛ gɛnen mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Kuaa! I mɛŋ gyɛ ɔbono. Tigi daa Barabasɛ sa aye!” (Owi ɔko dɔ mɔ, Barabasɛ baarɛ mɔ‑rɛ asa ako mɛ koso kɔ de abɛyin awura. Imɔso ne mɛ keda mɔ tii de obu.) ");
INSERT INTO acd_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Imɔ gɛmara mɔ, Pilato gi yɛgɛ mɛ taa Yesu awulibi. ");
INSERT INTO acd_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Ne asogya mɔ mɛ luo iwe wɔra fɛɛ wura gɛpɛ ne mɛ kyu bun mɔ, ne mɛ kyu giwurakuru kyu gyaabii bun mɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Nfono mɔ, mɛ san mɛ kya gyaabii mɔ mɛ kya faala mɔ mɛ kya kpe mɛ kya ba yɛɛ, “Gyuda awura wura! Fo‑rɛ gimu dɛnsɛ!” mɛ san mɛ kya da mɔ itan. ");
INSERT INTO acd_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilato asogya mɔ mɛ wɔra Yesu gɛnen ta mɔ, Pilato gi kii lii kpaa tɔgɛ sa Gyuda awura mɔ yɛɛ, “Fɛꞌ nu yɛɛ nan kyu Yesu bara fɛye de fɛꞌ bii yɛɛ meŋ wu ilaa nyɛnyɛn ibono so nan kyu bun mɔ gipuɛɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Imɔso Pilato gi kyu Yesu lii baa nyiile Gyuda awura mɔ. O bun iwe gɛpɛ gɛbono asogya mɔ mɛ kyu bun mɔ mɔ, ne o bun giwurakuru mɔ. Ne Pilato gi tɔgɛ sa Gyuda awura mɔ yɛɛ, “Fɛꞌ kerɛ fɛye-ɔnyen mɔ!” ");
INSERT INTO acd_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ de mɔmɔ-asogya mɔ mɛ wu Yesu mɔ, mɛ kpen ken-ken tɔgɛ sa Pilato yɛɛ, “Da mɔ aŋanbi oyii so! Da mɔ aŋanbi oyii so mɔɔ!” Mɛ kpen tɔgɛ sa Pilato gɛnen mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛye gbaa-gbaa fɛꞌ baa kyu mɔ kpaa da mɔ aŋanbi mɔɔ fɛye-atɔ. Me berɛ, meŋ wu ilaa nyɛnyɛn ibono ɔ wɔra mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Nfono ne Gyuda awura abelɛnsɛ mɔ mɛ tɔgɛ sa Pilato yɛɛ, “A bo nbara nko. Imɔso kyu lii gɛnen nbara nbono so mɔ, i kaaborɛ ɔꞌ wɔra ɔmɔɔsɛ. I lii fɛɛ ɔ kya kyu mɔ-nyoro yɛɛ ɔ gyɛ Wurubuaarɛ mɔ-bi.” ");
INSERT INTO acd_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ibono Pilato gi nu gɛnen ilaa idɛ mɔ, i lɔrɔ wɔra mɔ gifuu too. ");
INSERT INTO acd_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Ɔ naa loo gɛten dɔ, ne ɔ taasɛ Yesu yɛɛ, “Fo lii fonɛ daa?” Ɔ taasɛ Yesu gɛnen mɔ, Yesu mɛŋ ka mɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Ibono ɔ mɛŋ ka mɔ-gɛnɔ mɔ, Pilato gi kii taasɛ mɔ yɛɛ, “Fo maŋ ka me-gɛnɔ? Fo mɛŋ nyi yɛɛ n bo ɔkpa de nꞌ taa fo yɛgɛ de foꞌ naa, ne nꞌ bo ɔkpa kee de nꞌ yɛgɛ de mɛꞌ da fo aŋanbi mada de oyii de foꞌ wu?” ");
INSERT INTO acd_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Nfono ne Yesu gi tɔgɛ sa mɔ yɛɛ, “I mɛŋ gyɛ fo-gibaa so ne fo nyɛ ɔkpa me so faa. Fɛɛ Wurubuaarɛ mɛŋ sa fo ɔkpa mɔ, nkana fo maŋ nyɛ ɔkpa me so. Imɔso nyamesɛ ɔbono o kyu me baa wɔra fo-abaa dɔ mɔ ne n so ilaa nyɛnyɛn ibono i nyaakyɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Yesu gi tɔgɛ gɛnen mɔ, Pilato gi san ɔ kya laarɛ ɔkpa ɔbono so ɔ laa kyu de ɔꞌ taa Yesu yɛgɛ de ɔꞌ naa mɔ. Nfono mɔ Gyuda awura mɔ mɛ kpɛ ma‑a kpen ken-ken daa ma‑a tɔgɛ ma‑a sa Ɔbelɛnsɛ Pilato yɛɛ, “Nengyene fo taa ɔnyen baarɛ yɛgɛ ne ɔ naa mɔ, fo mɛŋ kya buu fɛye Rom awura wura belɛ mɔ. Nu yɛɛ nyamesɛ kamaasɛ ɔbono ɔ kya kyu mɔ-nyoro yɛɛ ɔ gyɛ wura fɛɛ gɛnɔɔbono ɔnyen baarɛ kya wɔra faa mɔ, gɛnen kaasɛ ɔbono kya laarɛ fɛye-wura belɛ mɔ abolɔn ne.” ");
INSERT INTO acd_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilato gi nu ilaa ibono Gyuda awura mɔ mɛ tɔgɛ gɛnen mɔ, ɔ yɛgɛ mɛꞌ kparɛ Yesu kyu lii kpe gikpalan giko dɔ ne Pilato gi kpaa kpelegɛ kyena awura gɛgyapaa gɛbono mɛ kya kyena gɛmɔ so gyi nbɛlɛ mɔ. (Mɛ kya terɛ gikpalan gibono yɛɛ Abui Ɔtagaten Gikpalan. Gyuda awura gɛdɛ dɔ mɔ, mɛ kya terɛ gimɔ yɛɛ Gabata.) ");
INSERT INTO acd_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Gɛnen gɛkɛ gɛbono gɛ gyɛ abaala gɛkɛ sa Gyuda awura Lɛwu Gi Seregɛ Aye So gɛkɛ belɛ mɔ gigyi. Owi ɔbono mɛ lii kpe gikpalan mɔ dɔ mɔ, i san ŋmaraa de iꞌ wɔra fɛɛ owi kenken aberɛ. Nfono ne Pilato gi kyu Yesu nyiile Gyuda awura mɔ yɛɛ, “Fɛye-wura mɔ ne.” ");
INSERT INTO acd_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Pilato gi tɔgɛ gɛnen mɔ, mɛ kpen ken-ken gikolon tɔgɛ sa mɔ yɛɛ, “Kyu mɔ naa. Aŋ kya laarɛ de aꞌ baa wu mɔ. Da mɔ aŋanbi mada de oyii de oꞌ wuꞌ.” Ne Pilato gi taasɛ mɔmɔ yɛɛ, “Nꞌ da fɛye-wura mɔ aŋanbi mada de oyii de oꞌ wuꞌ?” Ɔ taasɛ ɔmɔ gɛnen mɔ, Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ mɛ lɛɛ gɛnɔ yɛɛ, “Aŋ bo wura ɔko baa too de fɛye-Rom wura belɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Pilato gi kerɛ mɔ, kuaa daa. Ne o kyu Yesu kyu wɔra mɔ-asogya mɔ abaa dɔ yɛɛ mɛꞌ kpaa da mɔ aŋanbi oyii so mɔɔ. Ne asogya mɔ mɛ kyu Yesu kyu kyon. ");
INSERT INTO acd_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Mɛ kyu mɔ lii mɛ kya kpe mɔ, mɛ yɛgɛ Yesu gbaa-gbaa ne n so mɔ-lɛwu oyii. Mɛ kpaa fo gɛtɛɛko mɛ kya terɛ nno yɛɛ Gimu Giwuye Gikpalan. De Gyuda awura gɛdɛ dɔ mɔ, mɛ kya terɛ nno yɛɛ Gologota. ");
INSERT INTO acd_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Nno ne mɛ da Yesu aŋanbi mada de oyii. Mɛ da anyen anyɔ ako kee aŋanbi mada de iyii bɔla de Yesu. Mɔmɔ dɔ ɔko bo de Yesu gyisɛ gibaa so ne ɔko, mɔ, bo de mɔ-benɛ gibaa so, i san Yesu, mɔ, bo nsansana. ");
INSERT INTO acd_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilato gi yɛgɛ mɛꞌ ŋmarasɛ kyu kpaa mada Yesu amu so yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nfono mɛ da Yesu aŋanbi mada de oyii mɔ i mɛŋ bo gɛta de nten. Imɔso i yɛgɛ Gyuda awura sakyɔ mɛ kalɛ ilaa ibono Pilato gi yɛgɛ mɛꞌ ŋmarasɛ mada Yesu amu so mɔ. I kya nyiile yɛɛ mɛ ŋmarasɛ imɔ de Gyuda awura gɛdɛ dɔ, de Rom awura gɛdɛ dɔ, de Geriiki awura gɛdɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ mɛ wu gɛnen mɔ, mɛ lɔgedɛ de Pilato yɛɛ, “I mɛŋ kaaborɛ foꞌ yɛgɛ de mɛꞌ ŋmarasɛ yɛɛ, ‘Gyuda awura wura mɔ ne’ kyu kpaa mada gɛnen. I kaaborɛ foꞌ yɛgɛ mɛꞌ ŋmarasɛ daa yɛɛ ‘Ɔnyen baarɛ ne yɛɛ mɔ ne n gyɛ Gyuda awura wura mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Nfono ne Pilato gi tɔgɛ sa mɔmɔ yɛɛ, “Ilaa ibono nɛ yɛgɛ mɛꞌ ŋmarasɛ mɔ, mɛ ŋmarasɛ daa gɛkpaa.” ");
INSERT INTO acd_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Asogya mɔ mɛ da Yesu aŋanbi mada de oyii mɔ ta mɔ, mɛ yɛ ilaa ibono nkana i bo mɔ-nyoro so mɔ dɔ gikpadɔ ginan ne mɔmɔ ɔkamaasɛ gi kyu giko. Mɛ yɛ imɔ gɛnen mɔ, i san Yesu gɛgbɛ gɛbono ɔ kya suu gɛsɛ pɛi de oꞌ suu ngbɛ sɛnsɛ gyanꞌ mɔ. Gɛnen gɛgbɛ gɛbono berɛ, mɛ mɛŋ baa-baa gɛmɔ kyaga. Mɛ kpɛ luo gɛmɔ daa lii soso baa yii gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Asogya mɔ mɛ tɔgɛ sa abara yɛɛ, “Fɛ mɛŋ sa fɛꞌ yɛgɛ de aꞌ kyadɛ gɛgbɛ gɛdɛ dɔ yɛ. Aꞌ too ilaa iko kerɛ. Ɔbono i yii de mɔ mɔ, kaasɛ mɔ oꞌ kyu gɛmɔ.” Ilaa ibono mɛ too kerɛ gɛnen mɔ, i yɛgɛ ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ i ba gɛsintin. Mɛ ŋmarasɛ yɛɛ, Mɛ yɛ me-nyoro so atɔ kyu ne mɛ too ilaa iko kerɛ de mɛꞌ wu ɔbono ɔ laa kyu me-gɛgbɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Asogya mɔ mɛ kya wɔra gɛnen pɛwu mɔ, Yesu mɔ-nyi, de mɔ-nyibelɛ, de Mariya, Kulopasɛ mɔ-ka mɔ, de Mariya Magadalakyii mɔ mɛ yelɛ Yesu lɛwu oyii mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ibono Yesu gi wu mɔ-nyi de me, mɔ-ɔkasɛbo ɔbono ɔ kya laarɛ me-ilaa mɔ, a yelɛ sindi abara mɔ, ɔ tɔgɛ sa mɔ-nyi yɛɛ, “Ɔkyii, fo-bi ne.” ");
INSERT INTO acd_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Ne o kii kisee tɔgɛ sa me yɛɛ, “Fo‑o fo mɔ, fo-nyi ne.” Kpɛ kyu lii gɛnen gɛkɛ gɛbono dɔ ne nɛ kyu mɔ kpaa kyena me asɛ me-gɛten dɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Yesu mada de lɛwu oyii mɔ gɛnen mɔ, o wu yɛɛ idɛ kon berɛ ɔ logɛ ilaa kamaasɛ. Ne ɔ tɔgɛ yɛɛ, “Bolefɔ kya mɔɔ me.” Ɔ tɔgɛ gɛnen de iꞌ yɛgɛ ilaa ibono mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ iꞌ nyɛ ba gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Gɛnen owi ɔbono mɔ, nta bonyansɛ nko oyuduu gi yii de gɛlɔbi nno. Imɔso mɛ kyu taatɔ dufu-dufu ɔko kyu kpaa nyise wɔra nta mɔ dɔ, ne mɛ kyu de hisopo gɛyabii kyu diirɛ kpe mɔ-gɛnɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Yesu gi kyogyoo nta mɔ mɔ, ɔ tɔgɛ yɛɛ, “I logɛ kon.” Ne o kyu mɔ-gimu too gɛsɛ, o lɛɛ mɔ-ɔŋɛ kyu wɔra Wurubuaarɛ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ibono gɛdɛ gɛ laa kɛ ne mɛ laa gyi mɔmɔ Gyuda awura gɛkɛ kyoolasɛ so mɔ, Gyuda awura mɔ mɛ kya laarɛ yɛɛ abono mɛ da mɔmɔ aŋanbi mada de iyii mɔ mɛꞌ nyɛ wuꞌ kusaa de mɛŋ sa mɛꞌ sii mɛ kyɔlɛ iyii mɔ so gɛnen gɛkɛ gɛbono dɔ de i mɛŋ sa iꞌ kyɔlesɛ mɔmɔ-gɛsi mɔ gigyi. I kya nyiile yɛɛ mɔmɔ-gɛkɛ kyoolasɛ gɛdɛ gɛ baa saarɛ mɔmɔ Gyuda awura gɛsi gigyi. Imɔso Gyuda awura mɔ mɛ kpaa wu Pilato yɛɛ ɔꞌ yɛgɛ de mɔ-asogya mɔ mɛꞌ kpaa boori gɛnen asa asaꞌ abono ayaa awuye. Nengyene mɛ nyɛ wuꞌ kusaa mɔ de mɛꞌ saga mɔmɔ lii iyii mɔ so kpaa pule. ");
INSERT INTO acd_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Gɛnen so mɔ, asogya mɔ mɛ kpaa boori ɔko-lɛɛ ayaa awuye de ɔbanban mɔ kee. ");
INSERT INTO acd_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Mɛ baa fo Yesu asɛ de mɛꞌ baa boori mɔ-lɛɛ ayaa awuye fɛɛ anyen anyɔ ako mɔ-lɛɛ mɔ, mɛꞌ baa kerɛ mɔ, Yesu gi ti wolaa wuꞌ. Imɔso mɛ mɛŋ baa boori mɔ-ayaa awuye mɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Asogya mɔ dɔ ɔko gi san lɛɛ mɔ-gikpɛ yii Yesu gɛkɛlɛbi dɔ fondi. Ayaa abono so mɔ, nkalan de nkyu gi tigi lii Yesu nyoro dɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Me ɔbono n kya ŋmarasɛ ilaa idɛ mɔ nɛ wu imɔ de me-ansi, ne ibono nɛ wu mɔ ne nꞌ kya buu mi‑i sa fɛye faa. N nyi yɛɛ n kya tɔgɛ fɛye gɛsintin de fɛye kee fɛꞌ nyɛ kyu fɛye-nyoro too Yesu so. ");
INSERT INTO acd_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ibono Yesu gi wuꞌ ne Gyuda awura mɔ mɛ mɛŋ nyɛ boori mɔ-ayaa awuye mɔ, i yɛgɛ ilaa ibono mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ i ba gɛsintin. Mɛ ŋmarasɛ yɛɛ, Ba‑a mɔ-giwuye kolon gi maŋ wɔra giboorisɛ. ");
INSERT INTO acd_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Ne mɛ kii ŋmarasɛ yɛɛ, Gyuda awura mɔ mɛ laa kerɛ nyamesɛ ɔbono mɛ yii mɔ fondi mɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Gyosɛfo, Arimatiyanyen ɔko bo no. Ɔ sɔɔ Yesu gyi. Gyuda awura abelɛnsɛ mɔ gifuu so mɔ, ɔŋ lɛɛ mɔ-gisɔɔgyi mɔ gɛwi. Yesu gi wuꞌ mɔ, ɔ kpaa wu Pilato yɛɛ ɔꞌ yɛgɛ mɔ de ɔꞌ kpaa saga Yesu gibuni mɔ lii oyii mɔ so kyu kpaa pule. Pilato gi sa mɔ ɔkpa ne ɔ kpaa saga Yesu gibuni mɔ kyu kyon ɔꞌ kpaa pule. ");
INSERT INTO acd_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nfono ne Nikodemusi ɔbono ɔ naa kyena kpaa wu Yesu gɛnyɛ gɛko mɔ gi kpaa kyu ilaa iko i dɛ fɛɛ onufuii de piperɛ ne mɛ kyu saarɛ abara dɔ gɛnen mɔ. Nikodemusi gi kyu gɛnen ilaa idɛ kpaa tu Gyosɛfo de mɛꞌ kyu kpaa bɔ Yesu gibuni mɔ. Ilaa ibono Nikodemusi gi kyu kpe gɛnen mɔ, imɔ-oduduu laa wɔra fɛɛ awayu bagi oduduu. ");
INSERT INTO acd_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Gyosɛfo mɔ‑rɛ Nikodemusi mɛ kyu gikɛlɛlɛ de ilaa ibono i dɛ fɛɛ onufuii de piperɛ mɔ kyu mili Yesu gibuni mɔ itiibilaa ɔkpa so fɛɛ gɛnɔɔbono mɔmɔ Gyuda awura mɛ kya kyu pule ibuni mɔ. ");
INSERT INTO acd_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Ndɔɔ nko gi sindi nfono mɛ da Yesu aŋanbi mada de oyii ne o wuꞌ mɔ. Gɛnen ndɔɔ nbono dɔ mɔ, gifolɛ giko gi bo nno mɛ wolaa logedi gimɔ wɔra ɔbɔ yela sa ibuni gipule. Mɛ mɛŋ ti taa pule obuni gɛnen folɛbɔ ɔbono dɔ kerɛ. ");
INSERT INTO acd_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gɛnen gɛkɛ gɛbono mɛ da Yesu aŋanbi mɔ gɛ gyɛ abaala gɛkɛ sa Gyuda awura gɛkɛ kyoolasɛ mɔ so mɔ, Gyosɛfo mɔ‑rɛ Nikodemusi mɛ san mɛ kya kpaala. Folɛbɔ mɔ sindi nfono mɛ da Yesu aŋanbi mɔ. Imɔso mɔ dɔ ne mɛ kyu Yesu gibuni mɔ kpaa pule. ");
INSERT INTO acd_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Mɛ pule Yesu mɔ, imɔ Kosida gɛkɛ mɔ, Mariya Magadalakyii mɔ gi koso kpe nfono mɛ pule mɔ mɔ. Ɔ koso gɛnen mɔ, i gyɛ gibaadiikɛ, i mɛŋ ti taa ŋmangɛ logɛ. Ɔ fo nno mɔ, o wu yɛɛ gibui belɛ gibono mɛ kyu tii folɛbɔ mɔ gɛbunono mɔ, giŋ baa gi tii. ");
INSERT INTO acd_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","O wu gɛnen mɔ, ɔ selɛ kpe Simon Piita de me, Yesu ɔkasɛbo ɔbono Yesu kya laarɛ me-ilaa mɔ asɛ ne ɔ kpaa tɔgɛ sa aye yɛɛ, “Mɛ kpaa puru aye-wura gibuni mɔ lii folɛbɔ mɔ dɔ. A mɛŋ bii nfono mɛ kyu mɔ kpaa yela mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Ɔkyii mɔ gi tɔgɛ sa aye gɛnen mɔ, me‑rɛ Piita a yii ɔkpa kyon nten nkan folɛbɔ mɔ gɛten. ");
INSERT INTO acd_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","A kya kpe mɔ, a selɛ daa. Nɛ selɛ belen-belen kyon Piita so. Gɛnen so mɔ, nɛ daa mɔ kpaa loo folɛbɔ mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nɛ fo nno mɔ, nɛ mada kerɛ folɛbɔ mɔ dɔ ne nɛ wu akuru mɔ mɛ kyu mili obuni mɔ a dɛ nno. Meŋ loo folɛbɔ mɔ dɔ berɛ. ");
INSERT INTO acd_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simon Piita gi selɛ lii gɛmara gɛmara baa tu me, ne ɔ loo folɛbɔ mɔ dɔ kpaa wu akuru abono mɛ kyu mili obuni mɔ a dɛ. ");
INSERT INTO acd_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","O wu gitaaban gibono mɛ kyu ŋminde obuni mɔ gɛnɔ kyaga de mɔ-gimu mɔ gi bɔɔ gi dɛ nkan gi mɛŋ kya yii akuru abono mɛ kyu mili mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Nfono mɔ, me, ɔbono nɛ gyangbara kpaa fo nno mɔ kee nɛ loo folɛbɔ mɔ dɔ kpaa wu de me-ansi ne nɛ sɔɔ gyi yɛɛ Yesu gi kyingi lii ibuni dɔ gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Wurubuaarɛ agyɛbi mɔ a wolaa nyiile yɛɛ Yesu laa kyingi lii ibuni dɔ. Nkana kyu baa fo gɛnen aberɛ abono mɔ, aye, mɔ-akasɛbo mɔ, a mɛŋ ti taa nu gɛnen agyɛbi adɛ gɛsɛ. ");
INSERT INTO acd_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Lii nfono mɔ, a yaasɛ kyon aye-ntenana dɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Mariya Magadalakyii mɔ berɛ, gi sii ɔ yelɛ folɛbɔ mɔ asɛ ɔ kya su. Ɔ kya su gɛnen mɔ, ɔ mada kerɛ folɛbɔ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Ɔ mada kerɛ mɔ, Wurubuaarɛ dɔ isɔɔ inyɔ iko ne n tɛ folɛbɔ mɔ dɔ mɛ suu ilaa fufuli. Mɔmɔ dɔ ɔko tɛ de nfono so nkana Yesu ayaa a sa de mɔ ne ɔnyɔsɛ mɔ, mɔ, tɛ de nfono so nkana Yesu gimu gi dɛ de mɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Nfono mɔ, Wurubuaarɛ dɔ isɔɔ mɔ mɛ taasɛ Mariya yɛɛ, “Ɔkyii, menɛ n wɔra ne fo kya su?” Ɔ lɛɛ gɛnɔ yɛɛ, “Ako mɛ baa puru me-wura gibuni mɔ. Meŋ nyi nfono mɛ kyu mɔ kpaa yela.” ");
INSERT INTO acd_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Ɔ tɔgɛ gɛnen mɔ, ɔ baa kpɛɛlɛ kerɛ mɔ, Yesu ne. O wu mɔ gɛnen mɔ, ɔ mɛŋ nyi yɛɛ i gyɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Nfono mɔ Yesu gi taasɛ mɔ yɛɛ, “Ɔkyii, menɛ n wɔra ne fo kya su? Anɛ ne fo kya laarɛ?” Mariya berɛ nyi daa yɛɛ ɔfaanan ɔbono ɔ kya kerɛ ndɔɔ nbono gi bo nfono mɔ so mɔ ne n kya taasɛ mɔ gɛnen. Imɔso ɔ tɔgɛ sa mɔ yɛɛ, “Ɔbelɛnsɛ, nengyene fo puru mɔ kpaa yela gɛtɛɛko mɔ, nyiile me de nꞌ kpaa puru mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Ne Yesu gi terɛ mɔ yɛɛ, “Mariya.” Ɔ terɛ mɔ gɛnen mɔ, Mariya gi dɛsɛ ne ɔ terɛ mɔ de Gyuda awura gɛdɛ dɔ yɛɛ, “Raboni!” (Raboni gɛsɛ ne n gyɛ yɛɛ onyiilebo.) ");
INSERT INTO acd_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nfono ne Yesu gi tɔgɛ sa Mariya yɛɛ, “Gɛŋ baa mili me gɛnen. Meŋ ti dii kpe me-sɛ Wurubuaarɛ asɛ. Fo berɛ, naa kpaa tɔgɛ sa me-akasɛbo abono mɛ wɔra me-tedɛana mɔ yɛɛ n kya dii mi‑i kpe me-sɛ Wurubuaarɛ asɛ, me-sɛ ɔbono ɔ gyɛ fɛye-sɛ, me-Wurubuaarɛ ɔbono ɔ gyɛ fɛye-Wurubuaarɛ mɔ asɛ.” ");
INSERT INTO acd_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Yesu gi tɔgɛ gɛnen mɔ, Mariya Magadalakyii mɔ gi naa, ne ɔ kpaa tɔgɛ sa Yesu akasɛbo mɔ yɛɛ, “Nɛ wu aye-Wura Yesu,” ne o buu ilaa ibono Yesu gi tɔgɛ mɔ mɔ sa ɔmɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Gɛnen Kosida ɔbono gɛdɔɔdɛ mɔ, Yesu akasɛbo mɔ mɛ gyanꞌ obu ɔko dɔ. Mɛ selɛ Gyuda awura abelɛnsɛ mɔ gifuu so mɔ, mɛ tii gisin wɔra giŋanbi wɔra mɔmɔ-nyoro. Mɛ bo obu mɔ dɔ gɛnen mɔ, mɛ baa kerɛ mɔ, Yesu ne n yelɛ mɔmɔ nsana. Ne ɔ faala ɔmɔ yɛɛ, “Wurubuaarɛ gisen yuuli giꞌ wɔra fɛye-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Yesu gi tɔgɛ mɔ-akasɛbo mɔ gɛnen mɔ, o kyu mɔ-abaa dɔ apan mɔ de mɔ-gɛkɛlɛbi dɔ-lɛɛ mɔ kyu nyiile ɔmɔ. Mɔ-akasɛbo mɔ mɛ wu mɔmɔ-ɔbelɛnsɛ mɔ, i wɔra mɔmɔ ɔkon gikyɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yesu gi kii faala mɔ-akasɛbo mɔ yɛɛ, “Wurubuaarɛ gisen yuuli giꞌ wɔra fɛye-lɛɛ.” Ne o kii tɔgɛ sa mɔmɔ yɛɛ, “Fɛɛ gɛnɔɔbono me-sɛ Wurubuaarɛ gi sun me mɔ, me kee n kya sun fɛye.” ");
INSERT INTO acd_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Yesu gi tɔgɛ gɛnen mɔ, ɔ sɔnga bun mɔmɔ so, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛꞌ sɔɔ Wurubuaarɛ Oduduu. ");
INSERT INTO acd_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Asa abono fɛ kyu mɔmɔ-ilaa nyɛnyɛn ibono mɛ wɔra mɔ kyɛɛ mɔmɔ mɔ, Wurubuaarɛ laa kyu kyɛɛ mɔmɔ kee. Ne asa abono, mɔ, fɛ kine ne fɛ maŋ kyu mɔmɔ-ilaa nyɛnyɛn ibono mɛ wɔra mɔ kyɛɛ mɔmɔ mɔ, Wurubuaarɛ kee maŋ kyu kyɛɛ mɔmɔ.” ");
INSERT INTO acd_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Owi ɔbono Yesu gi kpaa tuule mɔ-akasɛbo sɛnsɛ mɔ, Tomaasɛ, ɔbono mɛ kya terɛ mɔ yɛɛ Ata mɔ, Yesu akasɛbo gudu anyɔ mɔ dɔ ɔko mɛŋ bo nno. ");
INSERT INTO acd_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Imɔso ɔ baa loo mɔ, mɔ-nanboana mɔ mɛ buu sa mɔ yɛɛ, “A wu aye-Wura Yesu.” Ne Tomaasɛ gi tɔgɛ sa mɔmɔ yɛɛ, “Nengyene meŋ wu aŋanbi mɔ apan nten mɔ-abaa dɔ de nꞌ kyu me-gibaabi kyu yii nfono aŋanbi mɔ a fondi mɔ de nꞌ kyu me-gibaa yii mɔ-gɛkɛlɛbi dɔ-lɛɛ mɔ, maŋ sɔɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Imɔ gɛkɛ kuesɛ mɔ, Yesu akasɛbo mɔ mɛ kii mɛ bo obu mɔ dɔ. Idɛ kon berɛ, Tomaasɛ kee bo mɔmɔ dɔ. Mɛ tii gisen wɔra giŋanbi. Mɛ baa kerɛ mɔ, Yesu ne n yelɛ mɔmɔ dɔ. Ɔ faala ɔmɔ yɛɛ, “Wurubuaarɛ gisen yuuli giꞌ wɔra fɛye-lɛɛ.” ");
INSERT INTO acd_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Nfono mɔ, ɔ tɔgɛ sa Tomaasɛ yɛɛ, “Kyu fo-gibaabi yii gɛrɛ de foꞌ kerɛ me-abaa. Tengɛ fo-gibaa baa yii me-gɛkɛlɛbi. Gɛŋ baa sɔɔ akyɔɔlɛ. Sɔɔ gyi.” ");
INSERT INTO acd_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tomaasɛ gi terɛ mɔ yɛɛ, “Me-wura de me-Wurubuaarɛ!” ");
INSERT INTO acd_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nfono ne Yesu gi taasɛ mɔ yɛɛ, “Iŋ gyɛ ibono fo wu me mɔ so ne fo sɔɔ gyi faa? Nu yɛɛ omudɛnsɛbo ne n gyɛ ɔbono ɔ mɛŋ wu me de mɔ-ansi ne ɔ sɔɔ gyi yɛɛ nɛ kyingi lii ibuni dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Yesu gi wɔra ilaa gbaaꞌgbaa gikyɔ kee ibono i lɛɛ Wurubuaarɛ ɔlon nyiile ne mɔ-akasɛbo mɔ mɛ wu de ansi. I mɛŋ gyɛ imɔ pɛwu ne nɛ ŋmarasɛ wɔra ɔwolɛ baarɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Nɛ ŋmarasɛ imɔ idɛ ɔkara yela daa de iꞌ kpaa fɛye de fɛꞌ nyɛ sɔɔ gyi yɛɛ Yesu ne n gyɛ Wurubuaarɛ mɔ-bi ɔbono o sun yɛɛ ɔꞌ baa mɔlɛgɛ anyamesɛ de mɔmɔ‑rɛ Wurubuaarɛ nsana iꞌ nyɛ lɔrɔ mɔ. Nengyene fɛ sɔɔ Yesu gyi mɔ, fɛ laa nyɛ Wurubuaarɛ asɛ gɛkyena ɔnan. ");
INSERT INTO acd_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Imɔ nkɛ kalɛsɛ gɛmara mɔ, Yesu gi kii lɛɛ mɔ-nyoro nyiile mɔ-akasɛbo ɔbon belɛ ɔko gɛten. Mɛ kya terɛ gɛnen ɔbon ɔbono yɛɛ Tabiriyasɛ. Gɛnɔɔbono so i ba mɔ ne n gyɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","owi ɔko dɔ mɔ, Simon Piita de Tomaasɛ Ata mɔ, de Natanelɛ ɔbono ɔ lii Keena ɔsowolɛ ɔbono ɔ bo Galeli gɛsinkpan so mɔ, de Sɛbedi mɔ-biana mɔ, de Yesu akasɛbo mɔ dɔ anyɔ ako kee mɛ bo gɛten kolon. ");
INSERT INTO acd_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Nfono mɔ, Simon Piita gi kalɛ mɔ-nanboana mɔ yɛɛ, “N kya kpe nꞌ kpaa keda iken.” Piita gi kalɛ mɔmɔ gɛnen mɔ, mɛ tɔgɛ mɔ yɛɛ, “Aye‑rɛ fo a laa kpe!” Nfono mɔ, mɛ lii ne mɛ dii loo gikolii dɔ ne mɛ kyon. Gɛnyɛ gɛbono pɛwu mɔ, mɛ mɛŋ nyɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Gɛdɛ gɛ kpɛ gɛ kya kɛ mɔ, mɛꞌ baa kerɛ mɔ, Yesu ne n yelɛ ɔbon mɔ gigengen so. Yesu akasɛbo mɔ mɛ wu mɔ gɛnen mɔ, mɛ mɛŋ bii yɛɛ i gyɛ Yesu. ");
INSERT INTO acd_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Yesu gi wu mɔmɔ ne ɔ taasɛ mɔmɔ yɛɛ, “Adega, fɛŋ nyɛ sɛi?” Ne mɛ lɛɛ gɛnɔ yɛɛ, “Kuaa.” ");
INSERT INTO acd_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ne Yesu gi tɔgɛ mɔmɔ yɛɛ, “Fɛꞌ too asɛwu mɔ wɔra nkyu mɔ dɔ kyu kpe de gikolii mɔ gyisɛ so. Fɛ laa keda iken.” Gɛsintin mɔ, mɛ too amɔ mɔ, mɛ keda iken gikyɔ. Mɛ mɛŋ kya taalɛ de mɛꞌ biidɛ asɛwu mɔ. Iken ibono mɛ keda mɔ, i nyaakyɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Me, Yesu ɔkasɛbo ɔbono ɔ kya laarɛ me-ilaa mɔ, nɛ tɔgɛ sa Piita yɛɛ, “I gyɛ daa aye-wura.” Simon Piita kya wɔra gɛsun gikolii mɔ dɔ gɛnen owi ɔbono dɔ so mɔ, ɔ mɛŋ suu gɛgbɛ. Ibono ɔ kpɛ nu yɛɛ i gyɛ aye-wura mɔ, o kyu mɔ-ngbɛ kyu suu ne o tin loo nkyu mɔ dɔ fara lii kyon gigengen so. ");
INSERT INTO acd_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Aye asɛnsɛ mɔ berɛ, a palɛ gikolii mɔ a kya biidɛ asɛwu mɔ, yɛgɛ iken mɔ i bɔla amɔ dɔ. Nfono a yelɛ ne a wu Yesu mɔ de gigengen mɔ iŋ bo gɛta de abara. I laa kpɛ wɔra daa fɛɛ ifɛ inan gisoro. ");
INSERT INTO acd_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","A dii lii gigengen mɔ so mɔ, a wu ɔken tɔ agyangbalii dɔ ne a wu bodobodo kee dɛ nfono. ");
INSERT INTO acd_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Yesu gi tɔgɛ sa mɔ-akasɛbo mɔ yɛɛ, “Fɛꞌ kyu iken ibono fɛ keda nperɛ-nperɛ mɔ iko ba.” ");
INSERT INTO acd_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Nfono ne Simon Piita gi dii loo gikolii mɔ dɔ ne o biidɛ asɛwu mɔ de iken belɛ-belɛ ibono i bɔla asɛwu mɔ mɔ lii gigengen so. Iken ibono mɛ keda mɔ gɛgyɔnɔ gɛ gyɛ ikue-sono de saalaa iken isa. Dabɔlɛ ibono iken mɔ i kiirɛ ne i nyaakyɔ gɛnen faa, mɛ biidɛ imɔ mɔ, asɛwu mɔ a mɛŋ tɛɛ. ");
INSERT INTO acd_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Yesu gi tɔgɛ sa aye yɛɛ, “Fɛꞌ ba gyi nyɛnyɛngɛ agyudɔ.” Aye dɔ ɔko‑rɛ ɔko mɛŋ taalɛ da otu taasɛ mɔ yɛɛ, “Fo ne n gyɛ anɛ?” A ti wolaa bii yɛɛ i gyɛ aye-wura ne. ");
INSERT INTO acd_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Nfono mɔ Yesu gi kpaa puru bodobodo mɔ ne o kyu sa aye. Gɛnen kee ne o puru ɔken mɔ ɔ tɔ ɔgya mɔ dɔ mɔ ne o kyu sa aye yɛɛ aꞌ kyu gyi de bodobodo mɔ. ");
INSERT INTO acd_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Yesu gi kyingi lii ibuni dɔ mɔ, ɔbon baarɛ so-lɛɛ idɛ ne n wɔra gisasɛ ibono ɔ kya lɛɛ mɔ-nyoro nyiile mɔ-akasɛbo mɔ. ");
INSERT INTO acd_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","A gyi ta mɔ, Yesu gi terɛ Simon Piita yɛɛ, “Simon, Gyɔn mɔ-bi.” Ne ɔ taasɛ mɔ yɛɛ, “Fo kya laarɛ me-ilaa don gɛnɔɔbono mɔmɔ adɛ mɛ kya laarɛ me-ilaa mɔ?” Ɔ taasɛ mɔ gɛnen mɔ, Piita gi lɛɛ gɛnɔ yɛɛ, “Ɛn, me-wura. Fo nyi ibono n kya laarɛ fo-ilaa.” Piita gi lɛɛ gɛnɔ gɛnen mɔ, Yesu gi tɔgɛ sa mɔ yɛɛ, “Sa me-nsandɛbii mɔ agyudɔ.” ");
INSERT INTO acd_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yesu gi kii terɛ Piita yɛɛ, “Simon, Gyɔn mɔ-bi.” Ne o kii taasɛ mɔ ginyɔsɛ yɛɛ, “Fo kya laarɛ me-ilaa?” Piita gi kii lɛɛ gɛnɔ yɛɛ, “Ɛn, me-wura, fo nyi ibono n kya laarɛ fo-ilaa.” Piita gi lɛɛ gɛnɔ mɔ, Yesu gi kii tɔgɛ sa mɔ yɛɛ, “Kerɛ me-isandɛ mɔ so.” ");
INSERT INTO acd_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yesu gi kii terɛ Piita gisasɛ yɛɛ, “Simon, Gyɔn mɔ-bi.” Ne o kii taasɛ mɔ yɛɛ, “Fo kya laarɛ me-ilaa?” Ibono Yesu gi taasɛ mɔ gisasɛ gidɛ mɔ, mɔ-gisen dɔ i nyida mɔ yɛɛ Yesu gi kii taasɛ mɔ gɛnen. Nfono ne Piita gi lɛɛ gɛnɔ yɛɛ, “Me-wura, fo nyi ilaa kamaasɛ. Fo nyi ibono n kya laarɛ fo-ilaa.” Piita gi lɛɛ gɛnɔ gɛnen mɔ, Yesu gi kii tɔgɛ sa mɔ yɛɛ, “Kerɛ me-isandɛ mɔ so de agyudɔ. ");
INSERT INTO acd_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","N kya tɔgɛ fo gɛsintin; owi ɔbono fo gyɛ dega mɔ, fo kya dela fo-gbagya fo-atɔ de foꞌ naa kpe gɛten kamaasɛ gɛbono fo kya laarɛ mɔ. Fo baa wɔra ɔbelɛnsɛ mɔ, fo laa tengɛ fo-abaa de ɔko ne ɔꞌ san kyu fo-gbagya dela fo de ɔꞌ sola fo kpe de nfono so fo mɛŋ kya laarɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","(Yesu gi tɔgɛ gɛnen ilaa idɛ sa Piita kyu lɛɛ nyiile mɔ lɛwu ɔbono ɔnan mɔ Piita laa baa wuꞌ de iꞌ kyu nyisigyi bara Wurubuaarɛ mɔ.) Idɛ gɛmara mɔ, Yesu gi tɔgɛ sa Piita yɛɛ, “Baa buu me de foꞌ wɔra fɛɛ me-lɛɛ mɔ ɔnan.” ");
INSERT INTO acd_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Piita gi kisee kerɛ mɔ, o wu me, Yesu ɔkasɛbo ɔbono Yesu kya laarɛ me-ilaa mɔ. (Owi ɔko dɔ a tɛ a kya gyi mɔ, me ne n faga taasɛ Yesu ilaa mɔ-giso dɔ yɛɛ, “Me-wura, anɛ ne nan yɛgɛ fo-akyobo mɛꞌ nyɛ fo mɔ?”) ");
INSERT INTO acd_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Piita gi kisee kerɛ ne o wu me gɛnen mɔ, ɔ taasɛ Yesu yɛɛ, “Me-wura, ne ɔnyen baarɛ mɔ de‑e? Menɛ ne nan ba mɔ so gɛkaako?” ");
INSERT INTO acd_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Yesu gi lɛɛ gɛnɔ sa Piita yɛɛ, “Nengyene i gyɛ me-gɛlaarɛ yɛɛ ɔꞌ kyena kaaborɛ nꞌ kii ba mɔ, i gyɛ fo menɛ? Fo berɛ baa buu me de foꞌ wɔra me-lɛɛ mɔ ɔnan daa.” ");
INSERT INTO acd_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gɛnen ilaa ibono Yesu gi tɔgɛ kyu lii me, mɔ-ɔkasɛbo ɔbono ɔ kya laarɛ me-ilaa faa so mɔ, i yɛgɛ Yesu asonbo mɔ mɛ san mɛ naa ma‑a tɔgɛ yɛɛ me berɛ, maŋ wuꞌ. Yesu mɔ, mɛŋ kii tɔgɛ gɛnen. Ɔ tɔgɛ daa yɛɛ nengyene i gyɛ mɔ-gɛlaarɛ yɛɛ nꞌ kyena kaaborɛ oꞌ kii baa tu me mɔ, i gyɛ Piita menɛ? ");
INSERT INTO acd_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ɔbono Yesu akasɛbo mɔ mɛ darɛ gɛnen mɔ ne n ŋmarasɛ ɔwolɛ baarɛ faa. O wu imɔ de mɔ-ansi, ne aye kee a wu yɛɛ ibono ɔ ŋmarasɛ yela faa i gyɛ gɛsintin. ");
INSERT INTO acd_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yesu gi wɔra wɔra ilaa kpɛi-kpɛi gikyɔ. Iŋ gyɛ imɔ pɛwu ne nɛ taalɛ ŋmarasɛ wɔra ɔwolɛ baarɛ dɔ faa. Nengyene mɛ tɔgɛ yɛɛ mɛꞌ ŋmarasɛ imɔ ikamaasɛ yela mɔ, nɛ sɔɔ gyi yɛɛ iwolɛ mɔ i laa bɔla gɛsinkpan san. I maŋ nyɛ iyelaten.");
INSERT INTO acd_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Tiyofilo dɛnsɛ, me-ɔwolɛ gyangbarasɛ mɔ dɔ mɔ, nɛ tɔgɛ ilaa ibono Yesu gi wɔra de ilaa ibono o nyiile asa kyu lii gɛsɛ de gɛsɛ kyu kpaa fo gɛkɛ gɛbono Wurubuaarɛ gi puru mɔ kyu dii kpe mɔ asɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","Pɛi ne Wurubuaarɛ laa puru mɔ dii kpe mɔ asɛ gɛnen mɔ, ɔ tɔgɛ ilaa sa mɔ-isɔɔ mɔ ɔ lɛɛ mɔ. Kyu naa de Wurubuaarɛ Oduduu mɔ ɔlon dɔ mɔ, ɔ tɔgɛ mɔmɔ ilaa ibono i kaaborɛ mɛꞌ wɔra mɔ. ");
INSERT INTO acd_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Yesu awɔrɔfɔɔ lɛwu gɛmara mɔ, o kii kyingi. O kyingi mɔ, nkɛ ikue-inyɔ dɔ mɔ, ɔ lɛɛ mɔ-nyoro gɛwi nyiile mɔ-isɔɔ mɔ yɛɛ ɔ tɛ de ansi ibono iŋ bo akyɔɔlɛ. Ɔ tɔgɛ ilaa sa mɔmɔ kyu naa de Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Gɛnen nkɛ ikue-inyɔ nbono dɔ mɔ, imɔ gɛkɛ gɛdɛ mɔ, Yesu mɔ‑rɛ mɔ-isɔɔ mɔ mɛ koola mɛ tɛ mɔ, ɔ tɔgɛ sa mɔmɔ yɛɛ, “Fɛ mɛŋ sa fɛꞌ lii Gyɛrusalem ɔsowolɛ baarɛ so kpe gɛtɛɛko. Fɛꞌ kyena gɛrɛ gyoo ilaa ibono me-sɛ Wurubuaarɛ yɛɛ ɔ laa kyu baa kyɛɛ fɛye mɔ. Fɛ ti nu me nɛ tɔgɛ gɛnen ilaa ibono so ilaa sa fɛye baa kyon. ");
INSERT INTO acd_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Nɛ tɔgɛ fɛye yɛɛ Gyɔn gi kyu daa nkyu kyu gyere asa Wurubuaarɛ sagyere. Fɛye berɛ, nkɛ kalɛsɛ ndɛ dɔ mɔ, Wurubuaarɛ laa kyu mɔ-Oduduu mɔ daa kyu gyere fɛye Wurubuaarɛ sagyere.” ");
INSERT INTO acd_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Gɛkɛ gɛdɛ mɛ kii mɛ tɛ dabɔlɛ mɔ, mɛ taasɛ mɔ yɛɛ, “Aye-Wura, idɛ kon owi mɔ gi fo ibono fo laa sɔgɛ aye Isirale awura mɔ gɛwuragyi mɔ kiiri wɔra aye-abaa dɔ?” ");
INSERT INTO acd_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Mɛ taasɛ Yesu gɛnen mɔ, ɔ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Owi ɔbono ilaa idɛ i laa ba mɔ i mɛŋ gyɛ ibono i kaaborɛ fɛꞌ bii. Me-sɛ Wurubuaarɛ ne n kya yela imɔ-aberɛ mɔ-gibaa so. ");
INSERT INTO acd_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Fɛꞌ nu yɛɛ Wurubuaarɛ Oduduu mɔ laa ba fɛye so de fɛꞌ nyɛ ɔlon. Fɛ laa naa fɛ kya tɔgɛ me-ilaa ibono fɛ wu de ansi mɔ sa asa Gyɛrusalem ɔsowolɛ so de Gyudiya de Samariya nsinkpan pɛwu so de gɛsinkpan gɛten kamaasɛ so.” ");
INSERT INTO acd_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Yesu gi tɔgɛ gɛnen ta mɔ, i puru mɔ dii i kya kpe soso yɛgɛ mɛ yelɛ mɛ kerɛ mɔ kaaborɛ o muule Wurubuaarɛ awolɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Yesu isɔɔ mɔ mɛ kpɛ san mɛ yelɛ ma‑a kerɛ soso yiridididi mɔ, ayaa abono so mɔ, mɛ baa kerɛ mɔ, anyen anyɔ ako ne n yelɛ mɔmɔ asɛ. Mɛ suu ilaa fufuli. ");
INSERT INTO acd_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Anyen mɔ mɛ taasɛ Yesu isɔɔ mɔ yɛɛ, “Galeli awura, menɛ n wɔra ne fɛ yelɛ fɛ kya kerɛ soso yiridididi gɛnen? Gɛnen Yesu ɔbono Wurubuaarɛ gi puru dii kpe mɔ asɛ taa fɛye yɛgɛ faa laa kii ba fɛɛ gɛnɔɔbono fɛ wu mɔ ɔ kya kyon Wurubuaarɛ dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Anyen anyɔ mɔ mɛ tɔgɛ mɔmɔ gɛnen ta mɔ, Yesu isɔɔ mɔ mɛ naa lii gibii gibono mɛ kya terɛ gimɔ yɛɛ Nfɔ Oyii Gibii mɔ so nno kii kyon kpe Gyɛrusalem ɔsowolɛ mɔ so. Lii gibii mɔ so nno kyu kpe ɔsowolɛ mɔ so mɔ i mɛŋ bo gɛta; i laa wɔra daa fɛɛ gikpaaten kolon. ");
INSERT INTO acd_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Yesu isɔɔ mɔ mɛ loo ɔsowolɛ mɔ so mɔ, mɛ naa kpe abansoro nfono mɛ kya kyena sogɛ mɔ, ne mɛ dii loo soso-lɛɛ obu mɔ dɔ. Gɛnen Yesu isɔɔ ibono anyen ne n gyɛ Piita, Gyɔn, Gyeemesi, Andiru, Filipo, Tomaasɛ, Batolomiyu, Matiyu de Gyeemesi, Alefayo mɔ-bi. Mɔmɔ ako ne n gyɛ Simon ɔbono ɔŋ kya kyule mɔ-ɔsowolɛ so mɔ de Gyudasɛ, Gyeemesi mɔ-bi. ");
INSERT INTO acd_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mɔmɔ asa adɛ pɛwu de akyii ako de Mariya Yesu mɔ-nyi de Yesu mɔ-tedɛana mɛ kpɛ mɛ dɛ gɛdalaa dɔ de gɛnɔ kolon. ");
INSERT INTO acd_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Gɛnen nkɛ nbono dɔ mɔ, imɔ gɛkɛ gɛdɛ mɔ, Yesu asonbo adɛ ako mɛ gyanꞌ. Mɔmɔ pɛwu gɛgyɔnɔ gɛ gyɛ fɛɛ asa ikue-isee. Ne Piita gi koso yelɛ ne ɔ tɔngɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Me-nanboana, Wurubuaarɛ Oduduu mɔ gi naa de aye-naana Wura Deefidi so tɔgɛ Gyudasɛ nyoro so ilaa, ne mɛ ŋmarasɛ imɔ yela Wurubuaarɛ agyɛbi dɔ. Imɔso i kaaborɛ iꞌ ba gɛsintin. Gyudasɛ baarɛ ne n gyɛ ɔbono ɔ gyangbara sa abono mɛ kpaa keda Yesu mɔ. ");
INSERT INTO acd_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nkana ɔ bo aye-gikpen gidɛ dɔ. Aye‑rɛ mɔ ne Wurubuaarɛ gi sa gɛnen gɛsun gɛdɛ.” ");
INSERT INTO acd_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ilaa nyɛnyɛn ibono Gyudasɛ gi wɔra ne mɛ nyɛ Yesu mɔ, mɛ ka mɔ imɔ so gikɔ, o kyu gɛnen aterenbi abono kpaa sɔɔ gɛsinkpan. Imɔ gɛmara mɔ, Gyudasɛ gi tɔrɔ paadɛ, ne mɔ-ɔtɔ dɔ ilaa pɛwu i lii. ");
INSERT INTO acd_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Asa abono pɛwu mɛ tɛ Gyɛrusalem ɔsowolɛ so mɔ mɛ nu Gyudasɛ ilaa idɛ so. Lii gɛnen so mɔ, mɛ yela gɛsinkpan gɛbono ginyen mɔmɔ-gɛdɛ dɔ yɛɛ Akɛledama. (Imɔ gɛsɛ ne n gyɛ yɛɛ Nkalan Gɛsinkpan.) ");
INSERT INTO acd_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Piita gɛtɔngɛ mɔ dɔ mɔ, ɔ tɔgɛ yɛɛ, “Wurubuaarɛ agyɛbi dɔ nfono mɛ kya terɛ yɛɛ Ilon Ɔwolɛ mɔ, mɛ ŋmarasɛ Gyudasɛ nyoro so ilaa yela yɛɛ, ‘Mɔ-ɔkyenaten iꞌ bingiri akyanfon. Ɔko ɔŋꞌ sa ɔꞌ kyena nno.’ I kii tɔgɛ kee yɛɛ, ‘Ɔko kpɛi ne oꞌ kyu mɔ-gɛsun wɔrasɛ wɔra.’ ");
INSERT INTO acd_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Imɔso, me-nanboana, i kaaborɛ aꞌ laarɛ ɔko kyu bɔla aye so de aye‑rɛ mɔ pɛwu aꞌ nyɛ a kya tɔgɛ Wura Yesu giwukyingi mɔ so ilaa a kya sa asa. I kaaborɛ kaasɛ ɔꞌ wɔra nyamesɛ ɔbono aye‑rɛ mɔ a naa owi ɔbono pɛwu aye‑rɛ aye-Wura Yesu a naa a kya kingi, kpɛ kyu lii aberɛ abono Gyɔn kya gyere asa Wurubuaarɛ sagyere mɔ kyu baa fo gɛnen gɛkɛ gɛbono Wurubuaarɛ gi puru Yesu dii kyon Wurubuaarɛ dɔ taa aye yɛgɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Piita gi tɔgɛ gɛnen ta mɔ, mɛ lɛɛ asa anyɔ yɛɛ mɛꞌ kerɛ mɔmɔ anyɔ dɔ de mɛꞌ lɛɛ ɔko. Gɛnen asa anyɔ abono anyen ne n gyɛ Gyosɛfo de Matiyasɛ. Gyosɛfo baarɛ anyen ako ne n gyɛ Basabasɛ abɛɛ Gyusetisɛ. ");
INSERT INTO acd_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Mɛ lɛɛ Gyosɛfo de Matiyasɛ gɛnen mɔ, mɛ dalaa yɛɛ, “Aye-Wura Wurubuaarɛ, fo ne n nyi nyamesɛ kamaasɛ gisen dɔ. Gɛnen asa anyɔ abono a lɛɛ faa mɔ, fo ne nan nyiile aye ɔkolon ɔbono fo lɛɛ ");
INSERT INTO acd_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","de ɔꞌ baa wɔra Yesu ɔsɔɔ fɛɛ aye de ɔꞌ wɔra gɛnen gɛsun gɛbono Gyudasɛ gi wuꞌ taa yɛgɛ kyon kpe nfono i kaaborɛ mɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Mɛ dalaa gɛnen ta mɔ, nfono mɔ, mɛ too ilaa iko kerɛ ne i kpaa yii de Matiyasɛ ne mɛ kyu mɔ kyu bɔla mɔmɔ Yesu isɔɔ gudu ɔko abono mɛ san mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Gɛkɛ gɛdɛ mɔ, Gyuda awura mɛ kya gyi mɔmɔ-agyudɔ ako akɛbiberɛ gɛsi. Mɛ kya terɛ gɛnen gɛsi mɔ yɛɛ Pɛntekosi. Gɛnen gɛsi gɛbono dɔ mɔ, Yesu asonbo pɛwu mɛ kpaa gyanꞌ gɛten kolon. ");
INSERT INTO acd_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Mɛ bo nno mɔ, mɛ nu ɔlanba ɔko gi tɔrɔ! Ɔlanba mɔ gi lii Wurubuaarɛ dɔ fɛɛ afuu belɛ ako ne n kya da a kya ba, ne ɔlanba mɔ gi kpaa bɔla gɛten gɛbono dɔ mɛ gyanꞌ mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Mɛ baa kerɛ mɔ, ilaa iko ne n baa yɛ gyanꞌgyan mɔmɔ ɔkamaasɛ so fɛɛ ɔgya ɔbono ɔ kya dɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Nfono mɔ, Wurubuaarɛ Oduduu mɔ gi suu de Yesu asonbo mɔ, mɛ san ma‑a bugi nnɔ ma‑a tɔngɛ ndɛ kpɛi-kpɛi nbono mɛŋ wolaa ma‑a tɔgɛ mɔ. Mɛ kya tɔgɛ gɛnɔɔbono ɔkara Oduduu mɔ gi sa ɔmɔ yɛɛ mɛꞌ tɔgɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Gɛnen owi ɔbono mɔ, asa mɛ nyaakyɔ Gyɛrusalem ɔsowolɛ mɔ so. I lii fɛɛ mɔmɔ-nanboana Gyuda awura abono mɛ selɛ Wurubuaarɛ mɔ ako kee mɛ ba bɔla mɔmɔ so mɛ kya son Wurubuaarɛ. Mɛ lii nten kpɛi-kpɛi mɛ kya tɔgɛ ndɛ nbono asa mɛ kya tɔgɛ gɛsinkpan pɛwu so mɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ɔlanba ɔbono ɔ wɔra gɛten mɔ dɔ so mɔ, sakpii belɛ gi kpaa gyanꞌ nno. Yesu asonbo mɔ mɛ kya tɔngɛ mɔ, i wɔra sakpii mɔ giyan. I kya nyiile yɛɛ mɔmɔ ɔkamaasɛ kya nu mɔmɔ-ilaa tɔngɛsɛ de mɔmɔ gbaa-gbaa ndɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","I dɛ mɔmɔ-gɛnɔ, mɛŋ baa mɛ nyi gibono dɔ mɛ dɛ mɔ. Mɛ san mɛ kya taasɛ yɛɛ, “Gɛnen anyen abono mɛ kya tɔngɛ faa mɔmɔ pɛwu mɛ mɛŋ gyɛ Galeli awura daa? ");
INSERT INTO acd_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ne i wonɛ so ne mɛ kya taalɛ mɛ kya tɔngɛ de aye ɔkamaasɛ ndɛ gɛnen? ");
INSERT INTO acd_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","A lii isowolɛ kpɛi-kpɛi so. Kerɛ, aye dɔ ako mɛ gyɛ Paatiya awura. Ako mɔ mɛ gyɛ Miidi awura. Elamiti awura mɛ bo aye dɔ. Ako mɔ mɛ tɛ Mɛsopotemiya. Ako mɛ gyɛ Gyudiya awura, Kapadosiya awura, Pontusɛ awura, Esiya awura, ");
INSERT INTO acd_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigyiya awura, Panfiliya awura, Igyipiti awura, ne ako mɛ lii Libiya gibaafon gibono gi sindi Siirin ɔsowolɛ so mɔ. Aye dɔ ako mɛ gyɛ asafo kpan‑n abono mɛ lii Rom ɔsowolɛ so. Gɛnen asafo adɛ ako mɛ gyɛ Gyuda awura gbaa-gbaa ne ako mɛ loo daa Gyuda awura ɔson mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Aye ako mɛ gyɛ Keriiti awura ne ako mɛ gyɛ Arabiya awura. Aye gɛnen asa adɛ ɔkamaasɛ kya nu ilaa belɛ-belɛ ibono Wurubuaarɛ gi wɔra ne mɛ kya tɔgɛ imɔ so ilaa faa aye-ndɛ dɔ.” ");
INSERT INTO acd_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sakpii mɔ ɔkamaasɛ kya nu ilaa ibono mɛ kya tɔgɛ mɔ gɛsɛ de mɔmɔ-ndɛ dɔ mɔ, i dɛ mɔmɔ pɛwu gɛnɔ ne i wɔra mɔmɔ giyan. Mɛ san mɛ kya taasɛ abara daa yɛɛ, “Menɛ ilaa ne a laa wu gɛsinkpan so faa?” ");
INSERT INTO acd_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Sakpii mɔ dɔ asa ako berɛ mɛ kya ŋmasɛ Yesu asonbo mɔ yɛɛ, “Ŋmaawo, mɛ mɛŋ boo daa?” ");
INSERT INTO acd_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ibono mɛ kya ŋmasɛ Yesu asonbo mɔ gɛnen mɔ, Piita mɔ‑rɛ mɔ-nanboana Yesu isɔɔ gudu ɔko mɔ mɛ koso yelɛ, ne Piita gi bugi gɛnɔ tɔgɛ ken-ken sa sakpii mɔ yɛɛ, “Me-nanboana Gyudiya awura de fɛye asa abono pɛwu fɛ tɛ Gyɛrusalem gɛrɛ mɔ, fɛꞌ yela giso de fɛꞌ nu dɔɔdan. ");
INSERT INTO acd_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Aye gɛnen anyen abono fɛ kya wu aye faa, a mɛŋ kya boo fɛɛ gɛnɔɔbono fɛye-nwɔnsa gɛ kya nyiile fɛye mɔ. I san i gyɛ nyɛnyɛngɛ gikyɔ de giboo. Nperɛ ibono a yelɛ faa, i laa wɔra daa fɛɛ iwi sango. ");
INSERT INTO acd_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","“To, ilaa ibono i ba aye so faa mɔ ilaa ne mɛ wolaa ŋmarasɛ yela Wurubuaarɛ agyɛbi dɔ mɔ. Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono mɛ kya terɛ mɔ yɛɛ Gyowelɛ mɔ ne n ŋmarasɛ imɔ yela. Ɔ ŋmarasɛ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Wurubuaarɛ gi tɔgɛ yɛɛ, “Gɛsinkpan so gɛkyena nkɛ laalaalogɛ mɔ dɔ mɔ, i laa ba yɛɛ me Wurubuaarɛ nan kyɛɛgɛ me-Oduduu bun anyamesɛ so. Gɛnen asa abono, anyen de akyii mɛ laa tɔngɛ me Wurubuaarɛ ilaa sa asa. Abelɛnsɛ de adega mɛ laa wu me-ilaa fɛɛ ideri yɛgɛ mɛ kerɛ, ne mɛ laa kuu me ilaa wɔrasɛ so ideri kee. ");
INSERT INTO acd_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Abono mɛ gyɛ me-adɛ mɔ, nan kyɛɛgɛ me-Oduduu bun mɔmɔ‑rɛ mɔmɔ-anyen de akyii so gɛnen nkɛ nbono dɔ de mɛꞌ tɔngɛ me Wurubuaarɛ ilaa sa asa. ");
INSERT INTO acd_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Nan lɛɛ ilaa nyiile asa Wurubuaarɛ awolɛ dɔ fɛɛ nkalan, ɔgya, de igyɛsii. Nan wɔra adɛgɛnɔ ilaa gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Pɛi de me Wura Wurubuaarɛ nyisigyi gɛkɛ gbaaꞌ mɔ gɛ lɔɔ baa fo mɔ, owi laa kisee bingiri obibiri de bosɛ mɔ ɔꞌ pɛɛrɛ fɛɛ nkalan. ");
INSERT INTO acd_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","I laa ba yɛɛ ɔkamaasɛ ɔbono ɔ saawo terɛ Wura Wurubuaarɛ mɔ, ɔ laa mɔlɛgɛ mɔ.” ’ ");
INSERT INTO acd_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Me-nanboana Isirale awura, fɛꞌ nu ilaa idɛ. Wurubuaarɛ gi nyiile fɛye yɛɛ Yesu, Nasarɛtɛnyen mɔ, ne n gyɛ ɔbono mɔ Wurubuaarɛ gi sun mɔ. Ilaa ibono Wurubuaarɛ gi wɔra fɛye-ansi so ne i lɛɛ nyiile gɛnen mɔ ne n gyɛ nsun boduduusɛ kpɛi-kpɛi nbono Yesu gi wɔra aberɛ abono ɔ bo gɛsinkpan so mɔ. Ɔ wɔra ilaa gbaaꞌgbaa ibono nkana nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so mɔ, de ilaa ibono i lɛɛ Wurubuaarɛ nyisigyi nyiile asa mɔ. Fɛye gbaa-gbaa fɛ nyi imɔ so. ");
INSERT INTO acd_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Wurubuaarɛ gi wolaa tɔgɛ yela ne ɔ wolaa o nyi yɛɛ anyamesɛ mɛ laa nyɛ Yesu baarɛ mɔɔ. Imɔso ne i ba yɛɛ fɛ yɛgɛ ilaa nyɛnyɛn awɔrabo mɛ da mɔ aŋanbi oyii so, ne o wuꞌ. ");
INSERT INTO acd_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Imɔ‑rɛ imɔ gɛnen gbaa mɔ, Wurubuaarɛ gi kii kyingi mɔ. Ɔ lɛɛ mɔ lii lɛwu anyanyan dɔ. I kya nyiile yɛɛ iŋ bo no yɛɛ ɔ laa wuꞌ sii isɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","“Aye-naana Deefidi gi wolaa wu Yesu gisen dɔ ilaa, ne ɔ ŋmarasɛ imɔ yela Wurubuaarɛ agyɛbi dɔ yɛɛ, ‘Owi kamaasɛ dɔ mɔ n kya wu me-Wura Wurubuaarɛ sindi me. Imɔso i maŋ ŋmaa me-gisen. ");
INSERT INTO acd_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Imɔso i bo me-gisen dɔ ɔkon. N kya lɛɛ mɔ-ginyen. Ne me-ansi a gyan yɛɛ sɛi maŋ taasɛ me-nyoro gibi so. ");
INSERT INTO acd_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","I kya nyiile yɛɛ fo Wurubuaarɛ, fo maŋ yɛgɛ me-oduduu mɔ ɔꞌ kpaa sii ibuni dɔ. Nɛ kyu me-nyoro fuɛ sa fo. Fo maŋ yɛgɛ me nꞌ gyɔ sii isɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Fo ne n nyiile me ikpa ibono so nyamesɛ laa naa de ɔꞌ nyɛ ɔkyenaten dɛnsɛ fo asɛ. N bo fo asɛ mɔ, i laa tansi wɔra me ɔkon gikyɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Ne Piita gi lɛɛ gɛsɛ yɛɛ, “Me-nanboana, nan tɔgɛ tigi fɛye yɛɛ aye-naana Deefidi ɔbono ɔ tɔgɛ gɛnen ilaa idɛ mɔ gi wuꞌ ne mɛ pule mɔ. Mɔ-gɛkyan gɛ dɛ aye asɛ gɛrɛ kyu baa lii de ndɛ. ");
INSERT INTO acd_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ɔ wɔra daa Wurubuaarɛ ikalan ɔtɔgɛbo. Wurubuaarɛ gi ka sa mɔ yɛɛ ɔꞌ kerɛ fɛɛ mɔ Wurubuaarɛ gbaa-gbaa, ɔ laa kyu mɔ Deefidi mɔ-naanaana dɔ ɔko kyu yii gɛwura mɔ Deefidi giyaa dɔ gɛkaako mɔ-lɛwu gɛmara. ");
INSERT INTO acd_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Wurubuaarɛ gi lɛɛ nyiile mɔ gɛnen mɔ, ɔ bii yɛɛ gɛnen mɔ-ɔnaanabi ɔbono ne nan gyi gɛwura Wurubuaarɛ adɛ so mɔ. Ne o wu yɛɛ Wurubuaarɛ laa kyingi mɔ lii ibuni dɔ. Gɛnen so mɔ, ɔ tɔgɛ imɔ so ilaa yela yɛɛ, ‘Wurubuaarɛ maŋ yɛgɛ mɔ de oꞌ wuꞌ sii asa abono mɛ wuꞌ mɔ dɔ, ne mɔ-nyoro inun i maŋ nyɛ gyɔ gɛkyan dɔ kpa‑a.’ ");
INSERT INTO acd_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Gɛsintin mɔ, Yesu baarɛ gi wuꞌ mɔ, Wurubuaarɛ gi kyingi mɔ lii ibuni dɔ. Aye adɛ pɛwu a wu imɔ de ansi. ");
INSERT INTO acd_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","“Wurubuaarɛ gi diirɛ mɔ kpe mɔ asɛ, kyu mɔ yela mɔ-gyisɛ gibaa so, ne o kyu mɔ-Wurubuaarɛ Oduduu mɔ sa mɔ fɛɛ gɛnɔɔbono ɔ wolaa ka yela sa mɔ mɔ. Imɔso ilaa ibono fɛ kya wu de ansi ne fɛ kya nu de aso faa, Yesu ne n kyu imɔ kyu kyɛɛgɛ bun aye so. ");
INSERT INTO acd_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Aye-naana Deefidi berɛ, i mɛŋ diirɛ mɔ kpe Wurubuaarɛ dɔ. Deefidi gbaa-gbaa gi wu tɔgɛ yɛɛ, ‘Wura Wurubuaarɛ gi tɔgɛ sa me-Wura yɛɛ, “Baa kyena me-gyisɛ gibaa so de me‑rɛ fo aꞌ gyi gɛwura ");
INSERT INTO acd_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","de nꞌ yɛgɛ foꞌ kyise fo-akyobo de fo-ayaa.” ’ ");
INSERT INTO acd_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Imɔso me-nanboana Isirale awura pɛwu, fɛꞌ bii yɛɛ iŋ bo akyɔɔlɛ yɛɛ Yesu ne n gyɛ Wura. Mɔ ne Wurubuaarɛ gi lɛɛ yɛɛ oꞌ gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ. Ne mɔ mɔ ne fɛ yɛgɛ mɛ da mɔ aŋanbi oyii so mɔɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Asa mɛ nu ilaa ibono Piita gi tɔgɛ faa mɔ, i selɛ mɔmɔ-nyoro nyer‑r. Nfono ne mɛ taasɛ Piita de mɔ-nanboana Yesu isɔɔ sɛnsɛ mɔ yɛɛ, “Ansaana, nnɛ ne a laa wɔra ne?” ");
INSERT INTO acd_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Asa mɔ mɛ taasɛ gɛnen mɔ, Piita gi lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛye ɔkamaasɛ oꞌ nu mɔ-nyoro gɛsɛ yɛɛ ɔ gyɛ ilaa nyɛnyɛn ɔwɔrabo de fɛꞌ kyɛɛgɛ de mɛꞌ gyere fɛye Wurubuaarɛ sagyere Yesu Kirisito ginyen dɔ de Wurubuaarɛ oꞌ kyu fɛye-ilaa nyɛnyɛn kyɛɛ fɛye. Fɛ wɔra gɛnen mɔ, Wurubuaarɛ laa kyu mɔ-Oduduu mɔ kyɛɛ fɛye. ");
INSERT INTO acd_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","I kya nyiile yɛɛ ilaa ibono aye-Wura Wurubuaarɛ yɛɛ ɔ laa kyu kyɛɛ asa mɔ, fɛye ne ɔ darɛ yɛɛ ɔ laa kyɛɛ mɔ. Ɔ ka yela sa fɛye‑rɛ fɛye-biana de fɛye-naanaana de asa abono mɛ bo gɛta-gɛta mɔ pɛwu. Ɔ ka yela sa daa nyamesɛ kamaasɛ ɔbono Wurubuaarɛ laa tɔgɛ mɔ yɛɛ oꞌ kyu mɔ-nyoro kyu sa mɔ Wurubuaarɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Piita gi tɔgɛ ilaa sakyɔ sa asa mɔ gɛnsipɛɛrɛ so. Ɔ tɔgɛ wɔra mɔmɔ yɛɛ, “Fɛꞌ mɔlɛgɛ fɛye-nyoro lii abono mɛ mɛŋ bo gɛsintin mɔ dɔ de fɛŋ sa fɛꞌ loo mɔmɔ-gisobiidɛ mɔ dɔ.” ");
INSERT INTO acd_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Piita gi tɔngɛ sa mɔmɔ gɛnen mɔ, asa sakyɔ mɛ nu gɛsɛ, ne mɛ gyere mɔmɔ Wurubuaarɛ sagyere. Asa abono mɛ baa bɔla Yesu asonbo so gɛnen gɛkɛ gɛbono wolɛ mɔ mɛ laa wɔra fɛɛ asa nwɛ oko de saalaa. ");
INSERT INTO acd_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Yesu asonbo mɔ mɛ kpɛ mɛ kya kasɛ Yesu isɔɔ mɔ ilaa nyiilesɛ mɔ, ne mɛ kpɛ mɛ bo abara dɔ. Mɛ kya kpaa gyanꞌ dabɔlɛ, mɛ kya gyi agyudɔ abono a kya nyiile yɛɛ mɛ gyɛ nyamesɛ kolon mɔ, ne mɛ kya dabɔlɛ dalaa. ");
INSERT INTO acd_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Yesu isɔɔ mɔ mɛ kya wɔra ilaa gbaaꞌgbaa ibono nkana nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so mɔ ne i kya lɛɛ Wurubuaarɛ ɔlon mɔ nyiile. Imɔso i yɛgɛ gifuu gi keda ɔkamaasɛ. ");
INSERT INTO acd_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Asa abono pɛwu mɛ kyu ɔmɔ-nyoro too Yesu so mɔ mɛ kyena fɛɛ nyamesɛ kolon. Ɔkamaasɛ ilaa i gyɛ mɔ-nanbo ilaa. ");
INSERT INTO acd_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","I bo no i bo no mɔ, mɛ kya fɛ mɔmɔ-ilaa ibono mɛ bo mɔ de mɛꞌ yɛ imɔ-aterenbi mɔ sa abara gɛnɔɔbono ɔkara i tiri ɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Gɛkɛ kamaasɛ mɛ kya kpaa gyanꞌ Wurubuaarɛ ɔson obu mɔ dɔ dabɔlɛ. Mɛ kya gyanꞌ mɔmɔ-nten-ana dɔ kee, mɛ kya gyi agyudɔ abono a kya lɛɛ mɔmɔ-ginyamesɛ kolon nyiile mɔ. Mɛ kya gyi amɔ de ɔkon lii mɔmɔ-asen dɔ. ");
INSERT INTO acd_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Mɛ kya yen Wurubuaarɛ, ne mɛ kya gyi asa sɛnsɛ ginsi. Gɛkɛ kamaasɛ Wurubuaarɛ kya kyu asa pobɔrɔ abono ɔ kya mɔlɛgɛ mɔmɔ lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ mɔ baa bɔla mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Gɛkɛ gɛdɛ owi gbaasɛ ibono mɔmɔ Isirale awura mɛ kya kpaa gyanꞌ dalaa mɔ, Piita mɔ‑rɛ mɔ-nanbo Gyɔn mɛ koso mɛ kya kpe Wurubuaarɛ ɔson obu mɔ dɔ de mɛꞌ kpaa dalaa. ");
INSERT INTO acd_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Mɛ kpaa fo Wurubuaarɛ ɔson obu mɔ gɛbunono gɛbono mɛ kya terɛ gɛmɔ yɛɛ Ɔdan Gɛbunono mɔ asɛ mɔ, mɛ baa kerɛ mɔ, ɔnyen ɔko ne. Ɔnyen baarɛ gyɛ daa ɔtɛgɛsɛ. Gɛnen ne i kyu korogɛ mɔ ne. Gɛkɛ kamaasɛ mɔ, asa mɛ kya sola mɔ kyu baa yela gɛnen gɛbunono gɛbono asɛ de ɔꞌ kyena kolɛ asa abono mɛ kya kpaa dalaa Wurubuaarɛ ɔson obu mɔ dɔ mɔ aterenbi. ");
INSERT INTO acd_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Ɔnyen mɔ gi wu Piita mɔ‑rɛ Gyɔn mɛ kya laarɛ de mɛꞌ loo ɔson obu mɔ dɔ mɔ, ɔ kolɛ mɔmɔ yɛɛ mɛꞌ sa mɔ aterenbi. ");
INSERT INTO acd_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Nfono mɔ, Piita mɔ‑rɛ Gyɔn mɛ kerɛ mɔ yiridididi, ne mɛ tɔgɛ sa mɔ yɛɛ, “Kerɛ aye gɛrɛ.” ");
INSERT INTO acd_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Gɛsintin mɔ, ɔnyen mɔ gi kerɛ mɔmɔ mɔ, o nyi yɛɛ ɔ laa nyɛ ilaa iko lii mɔmɔ asɛ daa. ");
INSERT INTO acd_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Nfono mɔ, Piita gi tɔgɛ sa ɔnyen mɔ yɛɛ, “Aterenbi berɛ, meŋ bo. Ilaa ibono n bo ne nan kyu sa fo mɔ ne n gyɛ yɛɛ kyu lii Yesu Kirisito, Nasarɛtɛnyen mɔ-ginyen dɔ mɔ, koso yelɛ de foꞌ naa.” ");
INSERT INTO acd_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Piita gi tɔgɛ gɛnen sa ɔnyen mɔ mɔ, ɔ keda mɔ-gibaa gyisɛ dɔ, ne o puru mɔ koso yelɛ mɔ-ayaa so. Ayaa abono so mɔ, ɔnyen mɔ-ayaa dɔ de mɔ-aŋmeli dɔ pɛwu i wɔra mɔ ɔlon. ");
INSERT INTO acd_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Ɔ koso tin, ne ɔ naa buu mɔmɔ loo Wurubuaarɛ ɔson obu mɔ dɔ. Ɔ naa ɔ kya tin o‑o tin ne ɔ kya faala Wurubuaarɛ ɔ kya yen mɔ. ");
INSERT INTO acd_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Asa abono mɛ bo nfono mɔ pɛwu mɛ wu ɔnyen mɔ naa ɔ kya yen Wurubuaarɛ mɔ, ");
INSERT INTO acd_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","mɔmɔ pɛwu mɛ wu mɔ bii yɛɛ nkana mɔ ne n kya kyena Ɔdan Gɛbunono mɔ asɛ kolɛ aterenbi Wurubuaarɛ ɔson obu mɔ asɛ mɔ. Gɛnɔɔbono i wɔra ne ɔnyen mɔ gi nyɛ alanfiya mɔ, i wɔra asa mɔ giyan, mɛŋ baa mɛ nyi imɔ-atɔgɛbi. ");
INSERT INTO acd_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Piita mɔ‑rɛ Gyɔn mɛ naa kpe mɛ yelɛ Solomon gikpalan mɔ dɔ mɔ, ɔnyen mɔ mili mɔmɔ. Ibono asa mɛ wu ɔnyen mɔ gi taalɛ ɔ naa mɔ, i dɛ mɔmɔ-gɛnɔ, ne mɔmɔ kee mɛ selɛ kpe mɔmɔ asɛ nno. ");
INSERT INTO acd_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Piita gi wu yɛɛ i dɛ asa gɛnɔ mɔ, ɔ taasɛ mɔmɔ yɛɛ, “Me-nanboana, Isirale awura, menɛ n wɔra ne imɔ idɛ i kya dɛ fɛye-gɛnɔ gikyɔ gɛnen? Menɛ n wɔra ne fɛ kya kerɛ aye ŋaa‑a gɛnen? Fɛ nyi yɛɛ aye ne n nyɛ ɔlon aye-gibaa so abɛɛ aye ne n kya gyi Wurubuaarɛ ginsi so ne ɔnyen baarɛ gi taalɛ ɔ naa faa? ");
INSERT INTO acd_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Wurubuaarɛ ɔbono aye-naanaana, Aberaham, Ayisiki, de Gyeekɔpo, de aye-adedaabo sɛnsɛ mɔ mɛ son mɔ ne n kyu nyisigyi kyu sa Yesu, Wurubuaarɛ Gɛsun Ɔwɔrabo mɔ. Fɛye berɛ, fɛ kyu gɛnen Yesu baarɛ kyu wɔra nbɛlɛ dɔ, ne fɛ kine mɔ Ɔbelɛnsɛ Pilato ansi dɔ, yɛgɛ nkana Pilato gi laarɛ fɛɛ ɔꞌ taa mɔ yɛgɛ de ɔꞌ naa. ");
INSERT INTO acd_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Fɛ kine Gɛsintin de Gisen Fufuli Wura mɔ, ne asa ɔmɔɔbo berɛ ne fɛ kolɛ Pilato yɛɛ oꞌ tigi sa fɛye de ɔꞌ naa. ");
INSERT INTO acd_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ɔbono ɔ kya sa Wurubuaarɛ asɛ gɛkyena mɔ ne fɛ yɛgɛ mɛꞌ kyu mɔɔ. Wurubuaarɛ, mɔ, gi kyingi mɔ lii ibuni dɔ. Aye a wu imɔ de ansi ne a kya tɔgɛ fɛye faa. ");
INSERT INTO acd_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","“Fɛ kya wu ɔtɛgɛsɛ baarɛ ne fɛ wolaa fɛ nyi mɔ. Yesu ginyen mɔ dɔ ne mɔ-ayaa a kyaga faa. Gɛnɔɔbono a sɔɔ Yesu gyi mɔ so ne ɔ nyɛ alanfiya fɛye pɛwu ansi dɔ gɛrɛ faa. ");
INSERT INTO acd_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Me-nanboana, Isirale awura, nɛ wu yɛɛ ilaa ibono fɛye‑rɛ fɛye-abelɛnsɛ mɔ fɛ kyu wɔra Yesu mɔ, fɛ mɛŋ nyi daa. ");
INSERT INTO acd_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","I mɛŋ ba gɛnen giyan. I gyɛ daa ilaa ibono Wurubuaarɛ gi wolaa naa de mɔ-ikalan atɔgɛbo mɔ pɛwu so tɔgɛ yela yɛɛ ɔbono ɔ laa sun de ɔꞌ baa mɔlɛgɛ asa mɔ laa wu awɔrɔfɔɔ. Wurubuaarɛ gi yɛgɛ i ba gɛnen gɛsintin. ");
INSERT INTO acd_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Imɔso fɛꞌ nu fɛye-nyoro gɛsɛ de fɛꞌ kyɛɛgɛ de Wurubuaarɛ ɔꞌ kpaarɛ fɛye ilaa nyɛnyɛn ibono fɛ kya wɔra mɔ fuɛ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Fɛ wɔra gɛnen mɔ, i bo no i bo no mɔ, ɔ laa kpɛ ɔ kya kpaa fɛye de fɛye-nyoro giꞌ tɔrɔ fɛye. Imɔ gɛmara mɔ, ɔ laa yɛgɛ Yesu oꞌ kii ba gɛsinkpan so. Mɔ ne ɔ wolaa lɛɛ yɛɛ ɔꞌ baa mɔlɛgɛ fɛye mɔ. ");
INSERT INTO acd_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","“Wurubuaarɛ laa yɛgɛ oꞌ sii kyena Wurubuaarɛ dɔ kpaa fo owi ɔbono mɔ Wurubuaarɛ laa lɔrɔ ilaa kamaasɛ mɔ. Lii ko‑o dedaa mɔ, ɔ wolaa tɔgɛ ilaa idɛ yela kyu naa de asa abono ɔ lɔrɔ yela yɛɛ mɛꞌ tɔgɛ mɔ-ikalan mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Aye-naana Mosisi gbaa kee gi wolaa tɔgɛ kyu lii Yesu baarɛ so yela yɛɛ, ‘Wura Wurubuaarɛ laa lɛɛ mɔ-ikalan ɔtɔgɛbo fɛɛ me, Mosisi lii fɛye dɔ sa fɛye. Ilaa kamaasɛ ibono gɛnen Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono laa tɔgɛ fɛye mɔ, fɛꞌ nu mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","I laa ba yɛɛ nyamesɛ kamaasɛ ɔbono ɔ maŋ nu gɛnen Wurubuaarɛ ikalan ɔtɔgɛbo ɔbono asɛ mɔ, Wurubuaarɛ laa lɛɛ mɔ lii mɔ-adɛ mɔ dɔ.’ ");
INSERT INTO acd_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Lii Samuɛlɛ aberɛ kyu ba lii de ndɛ, abono pɛwu mɛ wɔra Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ wu ndɛ nkɛ ndɛ dɔ ilaa tɔgɛ yela kyu lii Yesu so. ");
INSERT INTO acd_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Fɛye ne Wurubuaarɛ ikalan atɔgɛbo mɔ mɛ tɔgɛ gɛnen ilaa idɛ yela. Ne fɛye so ne Wurubuaarɛ gi yɛgɛ mɔ‑rɛ fɛye-naanaana mɛ wɔra gɛnɔ. Wurubuaarɛ gi ka yela sa aye-naana Aberaham yɛɛ, ‘Kyu naa de fo-naanaana so ne gɛsinkpan so ɔpaa kamaasɛ asa mɛ laa nyɛ Wurubuaarɛ oꞌ yuule mɔmɔ.’ ");
INSERT INTO acd_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Gɛsintin mɔ, Wurubuaarɛ gi lɛɛ Yesu yɛɛ ɔꞌ baa wɔra mɔ-Gɛsun Ɔwɔrabo gɛsinkpan so. Ɔ ba mɔ, fɛye asɛ ne ɔ daa gikpe de ɔꞌ nyɛ yuule fɛye de fɛye ɔkamaasɛ ɔꞌ nyɛ kyɛɛgɛ lii mɔ-ilaa nyɛnyɛn giwɔra dɔ.” ");
INSERT INTO acd_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Piita mɔ‑rɛ Gyɔn mɛ san mɛ kya tɔngɛ mɛ kya sa asa mɔ mɔ, abelɛnsɛ ako mɛ kpe mɔmɔ asɛ nno. Mɔmɔ ne n gyɛ Gyuda awura asunbi alɛɛbo de Wurubuaarɛ ɔson obu mɔ adiibo ɔbelɛnsɛ, de Saadusii awura. ");
INSERT INTO acd_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Gɛnen abelɛnsɛ adɛ mɛ kpaa tu mɔmɔ gɛnen mɔ, mɛ wu ibono Piita mɔ‑rɛ Gyɔn mɛ kya nyiile asa ilaa yɛɛ Wurubuaarɛ gi kyingi Yesu lii ibuni dɔ. Ibono i kya nyiile yɛɛ nyamesɛ gi wuꞌ mɔ, ɔ bo gɛtɛɛko ɔ kya kpe. Abelɛnsɛ mɔ mɛ wu gɛnen mɔ, mɛ kyu ginyadon de Piita mɔ‑rɛ Gyɔn. ");
INSERT INTO acd_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Gɛnen so mɔ, abelɛnsɛ mɔ mɛ kya laarɛ mɛꞌ kyu Piita mɔ‑rɛ Gyɔn wɔra nbɛlɛ dɔ. Owi gi ta so mɔ, mɛ keda mɔmɔ kyu tii de obu kaaborɛ gɛdɛ gɛ kɛ. ");
INSERT INTO acd_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Asa abono mɛ nu Piita mɔ‑rɛ Gyɔn gɛtɔngɛ mɔ berɛ, mɔmɔ dɔ sakyɔ mɛ kyu ɔmɔ-nyoro too Yesu so. Mɔmɔ‑rɛ abono mɛ ti wolaa kyu ɔmɔ-nyoro too Yesu so mɔ kyu dabɔlɛ mɔ, anyen abono mɛ bo mɔmɔ dɔ mɔ gɛgyɔnɔ gɛ gyɛ nwɛ ikue-inyɔ de saalaa. ");
INSERT INTO acd_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Mɛ keda Piita de Gyɔn kyu tii de obu gɛnen mɔ, gɛdɛ gɛ kɛ mɔ, abelɛnsɛ mɔ mɛ kpaa gyanꞌ Gyɛrusalem ɔsowolɛ mɔ so nno. Mɛ gyɛ abelɛnsɛ abono mɛ kya kerɛ mɔmɔ Gyuda awura mɔ so, de Gyuda awura nbɛlɛ agyibo, de Wurubuaarɛ nbara aŋmarasɛbo. ");
INSERT INTO acd_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Abelɛnsɛ mɔ mɛ kpaa gyanꞌ Gyuda awura asunbi alɛɛbo gɛmu ɔbono mɛ kya terɛ mɔ yɛɛ Anasɛ mɔ asɛ. Kayifasɛ, de Gyɔn ɔko, de Alɛsanda, de asunbi alɛɛbo gɛmu mɔ gɛsu mɔ dɔ abelɛnsɛ pɛwu mɛ bo gɛnen gɛgyanꞌ mɔ dɔ kee. ");
INSERT INTO acd_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Mɛ tigi Piita mɔ‑rɛ Gyɔn ne mɛ kyu mɔmɔ kyu baa yelɛ mɔmɔ-ansi dɔ ne mɛ taasɛ mɔmɔ yɛɛ, “Menɛtɔ ɔlon dɔ abɛɛ anɛ ginyen dɔ ne fɛ kyɛ ɔtɛgɛsɛ mɔ daa?” ");
INSERT INTO acd_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Nfono mɔ, Wurubuaarɛ Oduduu mɔ gi suu de Piita, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, “Abelɛnsɛ abono fɛ kya kerɛ aye Gyuda awura so de ɔsowolɛ so abelɛnsɛ, ");
INSERT INTO acd_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","iŋ gyɛ gidɛnsɛ gibono a wɔra sa ɔtɛgɛsɛ baarɛ faa so ne fɛ kya taasɛ aye imɔ so ilaa ndɛꞌ faa? Nengyene fɛ kya laarɛ de fɛꞌ bii gɛnɔɔbono a kyu kyɛ mɔ berɛ mɔ de‑e, ");
INSERT INTO acd_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","n kya laarɛ nꞌ tɔgɛ tigi fɛye pɛwu de Isirale awura pɛwu de fɛꞌ nu yɛɛ Yesu Kirisito, Nasarɛtɛnyen mɔ, ɔbono fɛ yɛgɛ mɛ da mɔ aŋanbi oyii so mɔɔ mɔ ginyen dɔ ne ɔnyen baarɛ gi nyɛ mɔ-nyoro alanfiya ɔ yelɛ fɛye-ansi so faa. Wurubuaarɛ, mɔ, gi kyingi mɔ lii ibuni dɔ. ");
INSERT INTO acd_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Yesu baarɛ ilaa ne mɛ ŋmarasɛ yela Wurubuaarɛ agyɛbi mɔ dɔ gɛtɛɛko mɔ. Mɛ ŋmarasɛ yɛɛ, Gibui kolon gibono fɛye ibu apɔrɔbo mɔ fɛ kyu too gɛbaamara mɔ ne n kii baa yɛgɛ ne obu mɔ gi wɔra ɔlon ɔ yelɛ faa. ");
INSERT INTO acd_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Ɔko mɛŋ bo no gɛsinkpan so, ɔ laa taalɛ mɔlɛgɛ asa lii mɔmɔ-ilaa nyɛnyɛn giwɔra dɔ de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena. Gɛnen mɔ, Yesu ginyen wolɛ ne Wurubuaarɛ gi sa aye yɛɛ aꞌ saawo terɛ de aꞌ nyɛ gɛnen amɔlɛgɛ abono.” ");
INSERT INTO acd_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Piita mɔ‑rɛ Gyɔn mɛ tɔgɛ tigi nbɛlɛ agyibo mɔ gɛnen mɔ, i dɛ mɔmɔ-gɛnɔ. Mɛŋ kii mɛ gyɛ mɔmɔ ɔsowolɛ so abelɛnsɛ, ne mɛ mɛŋ kii mɛ nyi ɔwolɛ. Idɛ kon mɔ, abelɛnsɛ mɔ mɛ san baa bii yɛɛ ibono nkana mɔmɔ‑rɛ Yesu ne n kya naa mɔ so ne mɛ sɔɔ ɔmɔ-nyoro gyi ne mɛ taalɛ tɔgɛ tigi mɔmɔ gɛnen. ");
INSERT INTO acd_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ibono abelɛnsɛ mɔ mɛ wu ɔnyen ɔbono Piita mɔ‑rɛ Gyɔn mɛ kyɛ mɔ mɔ yelɛ mɔmɔ asɛ nfono mɔ, mɛ mɛŋ baa taalɛ tɔgɛ sɛi. ");
INSERT INTO acd_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Nbɛlɛ agyibo mɔ mɛ yɛgɛ Piitaana mɛ lii taa mɔmɔ yɛgɛ ne mɔmɔ wolɛ-wolɛ mɛ san mɛ kya taasɛ abara yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Nnɛ ne a laa wɔra gɛnen anyen adɛ ne? Ilaa gbaaꞌ ibono i ba kyu naa de mɔmɔ so faa iŋ bo ŋara dɔ. Ɔkamaasɛ ɔbono ɔ tɛ Gyɛrusalem ɔsowolɛ baarɛ so mɔ gi nu imɔ. A maŋ taalɛ sɔɔ imɔ so akyɔɔlɛ. ");
INSERT INTO acd_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Imɔso ilaa ibono a laa wɔra ne gɛnen ilaa idɛ i maŋ nyɛ gbigi kyon gɛta-gɛta mɔ ne n gyɛ yɛɛ a laa terɛ ɔmɔ de aꞌ ka sa mɔmɔ yɛɛ gɛkaako-gɛkaako mɛꞌ mɛŋ baa kii tɔngɛ Yesu ilaa sa ɔko‑rɛ ɔko.” ");
INSERT INTO acd_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Mɛ tɔgɛ kyule abara gɛnen mɔ, ne mɛ terɛ Piita mɔ‑rɛ Gyɔn kii ba mɔmɔ asɛ ne mɛ da mɔmɔ tii yɛɛ, “Gɛkaako-gɛkaako fɛ mɛŋꞌ baa tɔgɛ abɛɛ fɛꞌ nyiile asa ilaa kyu naa de Yesu ginyen dɔ.” ");
INSERT INTO acd_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Mɛ tɔgɛ sa Piita de Gyɔn gɛnen mɔ, mɛ lɛɛ gɛnɔ sa mɔmɔ yɛɛ, “Fɛye gbaa-gbaa fɛꞌ kerɛ imɔ idɛ dɔ yɛɛ imɔmɔ ne n boran sa Wurubuaarɛ: Aꞌ nu fɛye asɛ abɛɛ aꞌ nu Wurubuaarɛ asɛ daa? ");
INSERT INTO acd_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Aye berɛ Yesu ilaa ibono a wu de ansi ne a nu de aso mɔ, a maŋ taalɛ baala aye-nnɔ bun yɛɛ a maŋ tɔgɛ imɔ sa asa.” ");
INSERT INTO acd_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Mɛ tɔgɛ gɛnen mɔ, abelɛnsɛ mɔ mɛ kii lɔrɔ ka sa mɔmɔ ken-ken yɛɛ nengyene mɛ kii wɔra gɛnen mɔ, mɛ laa wu mɔmɔ kyule. Nfono ne mɛ taa mɔmɔ yɛgɛ. Kyu lii asa so mɔ, abelɛnsɛ mɔ mɛ mɛŋ nyɛ ɔkpa ɔbono mɛ laa kyu biidɛ Piita mɔ‑rɛ Gyɔn giso mɔ. I kya nyiile yɛɛ asa mɔ pɛwu mɛ kya yen Wurubuaarɛ kyu lii gɛnɔɔbono mɛ taalɛ kyɛ ɔnyen mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ɔnyen ɔbono mɛ wɔra gɛnen ilaa gbaaꞌ idɛ kyu kyɛ mɔ gɛnen mɔ nsi gi laa don nsi ikue-inyɔ. ");
INSERT INTO acd_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Abelɛnsɛ mɔ mɛ taa Piita mɔ‑rɛ Gyɔn yɛgɛ gɛnen mɔ, mɛ naa kpe mɔmɔ-nanboana asɛnsɛ mɔ asɛ ne mɛ kpaa buu ilaa ibono pɛwu asunbi alɛɛbo abelɛnsɛ mɔ de abelɛnsɛ sɛnsɛ mɔ mɛ tɔgɛ sa mɔmɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Mɔmɔ-nanboana mɔ mɛ nu imɔ mɔ, mɔmɔ pɛwu mɛ dabɔlɛ ne mɛ bugi gɛnɔ dalaa sa Wurubuaarɛ yɛɛ, “Wura Wurubuaarɛ, fo ɔbono ilaa kamaasɛ i bo daa fo-gibaa dɔ mɔ, fo ne n lɛɛ soso de gɛsinkpan, apoo, de ilaa kamaasɛ ibono i bo imɔ dɔ mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Fo ne n tɔgɛ ilaa naa de fo-dega, aye-naana Deefidi so. Fo-Oduduu gi yɛgɛ mɔ ɔ taalɛ lɛɛ gɛnɔ taasɛ ilaa, ne mɛ ŋmarasɛ imɔ yela Wurubuaarɛ agyɛbi dɔ yɛɛ, ‘Menɛ n wɔra ne gɛsinkpan so asa kpɛi-kpɛi mɛ kya kyu ginyadon nyɛnyɛn, mɛ kya wɔra gɛnɔ Wurubuaarɛ so daa? Mɛ kya too owi abui ne. ");
INSERT INTO acd_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Awura-awura de isowolɛ so abelɛnsɛ mɛ laa gyanꞌ de mɛꞌ baala yɛɛ mɛ laa kɔ de Wurubuaarɛ mɔ‑rɛ ɔbono o sun yɛɛ ɔꞌ baa gyi gɛwura mɔ Wurubuaarɛ adɛ so mɔ.’ ” ");
INSERT INTO acd_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Yesu asonbo mɔ mɛ dalaa yɛɛ, “Wurubuaarɛ, i gyɛ gɛsintin yɛɛ Gyɛrusalem ɔsowolɛ baarɛ so mɔ, asa mɛ gyanꞌ yɛɛ mɛ laa kɔ de fo-Gɛsun Ɔwɔrabo, Yesu. Mɔ ne fo lɔrɔ yela ne fo sun yɛɛ ɔꞌ baa gyi gɛwura fo-adɛ so mɔ. Wura Hɛrodɛ, Ɔbelɛnsɛ Pontiyusɛ Pilato, fo-adɛ Isirale awura, de asa kpɛi-kpɛi mɛ gyanꞌ ");
INSERT INTO acd_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","de mɛꞌ wɔra ilaa ibono fo wolaa tɔgɛ yela mɔ. Fo ɔlon dɔ de fo-gɛlaarɛ dɔ ne fo wolaa tɔgɛ yela yɛɛ i laa ba gɛnen. ");
INSERT INTO acd_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","“Idɛ kon berɛ, Wurubuaarɛ, kerɛ ilaa nyɛnyɛn ibono mɛ tɔgɛ yɛɛ mɛ laa wɔra aye abono a tɛ sa fo mɔ. Sa aye otu de aꞌ taalɛ tɔgɛ fo-agyɛbi mɔ sa asa de a mɛŋꞌ selɛ gifuu ");
INSERT INTO acd_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","de foꞌ tengɛ fo-gibaa gyanꞌ aye so de aꞌ taalɛ kyɛ asa alɔbi. Yɛgɛ de aꞌ taalɛ wɔra ilaa gbaaꞌgbaa ibono nkana nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so kyu naa de fo-Gɛsun Ɔwɔrabo Yesu ɔbono fo lɔrɔ yela sa fo-nyoro mɔ ginyen dɔ.” ");
INSERT INTO acd_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Yesu asonbo mɔ mɛ dalaa kolɛ Wurubuaarɛ gɛnen mɔ, nfono mɛ bo mɔ i gyigisi. Wurubuaarɛ Oduduu mɔ gi suu de mɔmɔ pɛwu, ne mɛ san da otu mɛ kya tɔngɛ Wurubuaarɛ agyɛbi. Mɛ mɛŋ selɛ nyamesɛ gifuu. ");
INSERT INTO acd_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Asa abono mɛ ka gyanꞌ Yesu so mɔ pɛwu gɛwɔnsa de mɔmɔ-asen a san wɔra daa gikolon. Ilaa kamaasɛ ibono mɔmɔ ɔkamaasɛ bo mɔ, kaasɛ mɔ mɛŋ kya kyu imɔ yɛɛ gɛnen ilaa ibono i baa i gyɛ mɔ wolɛ-lɛɛ. Mɛ kya kyu imɔ fɛɛ i gyɛ daa mɔmɔ pɛwu ilaa. ");
INSERT INTO acd_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Wurubuaarɛ gi sa Yesu isɔɔ mɔ gɛtɔngɛ, ne mɔ-ɔlon dɔ mɔ mɛ kya tansi bii lɛɛ Wura Yesu giwukyingi mɔ so ilaa mɛ kya tɔgɛ mɛ kya sa asa. Wurubuaarɛ tansi ɔ kya kpaa ɔmɔ ne ɔ kya wɔra ilaa sa mɔmɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Sɛi mɛŋ kya tiri mɔmɔ abono mɛ ka gyanꞌ Yesu so mɔ dɔ ɔko‑rɛ ɔko. I kya nyiile yɛɛ mɔmɔ dɔ ɔkamaasɛ ɔbono ɔ bo nsinkpan abɛɛ ibu mɔ, mɛ kya fɛ imɔ ne mɛ kya kyu imɔ-aterenbi abono mɛ nyɛ mɔ, ");
INSERT INTO acd_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","kyu baa wɔra Yesu isɔɔ mɔ abaa dɔ. Ne fɛɛ i tiri Yesu asonbo mɔ dɔ ɔko mɔ, Yesu isɔɔ mɔ mɛ kya yɛ sa mɔmɔ ɔkamaasɛ gɛnɔɔbono ɔkara i tiri mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Gɛnen owi ɔbono mɔ ɔnyen ɔko bo mɔmɔ dɔ. Mɛ kya terɛ mɔ-ginyen yɛɛ Gyosɛfo. Yesu isɔɔ mɔ mɛ yela mɔ ayenbi yɛɛ Banabasɛ. (Banabasɛ gɛsɛ ne n gyɛ yɛɛ ɔbono ɔ kya wɔra ilaa keda asa nyoro.) Ɔ gyɛ daa Gyudanyen, ne ɔ lii Lɛfi gɛten dɔ. Ɔ lii Saapurosɛ gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Gɛnen Gyosɛfo baarɛ bo ndɔɔ. Ɔ fɛ ndɔɔ mɔ, ne o kyu aterenbi abono ɔ nyɛ mɔ kyu baa wɔra Yesu isɔɔ mɔ abaa dɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ɔnyen ɔko mɔ kee bo Yesu asonbo mɔ dɔ, mɛ kya terɛ mɔ yɛɛ Ananiyasɛ, ne mɔ-ka ginyen ne n gyɛ Safira. Mɔ‑rɛ mɔ-ka mɛ bo gɛsinkpan, ne ɔ kpaa fɛ gɛmɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Ɔ lɛɛ gɛsinkpan mɔ aterenbi abono ɔ nyɛ mɔ dɔ ako yela, ne o kyu abono a san mɔ kyu kpaa penɛ wɔra Yesu isɔɔ mɔ abaa dɔ yɛɛ ɔ fɛ mɔ-gɛsinkpan gɛko mɔ, aterenbi abono ɔ nyɛ mɔ pɛwu ne ɔ dɛ ɔ kya kyɛɛ faa. Ɔ kya wɔra gɛnen pɛwu mɔ, mɔ-ka kee nyi imɔ so. ");
INSERT INTO acd_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","O kyu aterenbi mɔ ba gɛnen mɔ, Piita gi terɛ mɔ ne ɔ taasɛ mɔ yɛɛ, “Ananiyasɛ, menɛ n wɔra ne fo yɛgɛ ilaa nyɛnyɛn gɛmu mɔ gi suu de fo ne fo kya penɛ Wurubuaarɛ Oduduu mɔ gɛnen? Menɛ n wɔra ne fo keda aterenbi abono fo nyɛ lii fo-gɛsinkpan mɔ fo fɛ mɔ dɔ iko kɔɔgɛ yela? ");
INSERT INTO acd_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Nengyene gɛsinkpan mɔ gɛ dɛ ne fo mɛŋ fɛ gɛmɔ mɔ, gɛ mɛŋ gyɛ fo-lɛɛ daa? Ne fo kii fɛ gɛmɔ mɔ, i mɛŋ gyɛ fo ne n bo fo-aterenbi? Ne i wonɛ ne fo sa gɛwɔnsa gɛdɛ gɛnen? Fo nyi yɛɛ anyamesɛ ne fo penɛ faa? Wurubuaarɛ ne fo penɛ gɛnen.” ");
INSERT INTO acd_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","6","Ananiyasɛ gi nu ilaa ibono Piita gi taasɛ mɔ gɛnen mɔ, ɔ lii tɔrɔ ne o wuꞌ. Nfono mɔ adega abono mɛ bo nno mɔ mɛ koso kyu akuru mili mɔ ne mɛ keda mɔ lii kyu kyon kpaa pule. Ɔkamaasɛ ɔbono o nu gɛnen Ananiyasɛ ilaa idɛ mɔ, gifuu belɛ gi keda mɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Adega mɔ mɛ keda Ananiyasɛ gibuni mɔ kyu kyon mɛꞌ kpaa pule mɔ, i baa wɔra ŋmaraa mɔ, mɔ-ka gi baa loo. Ɔ baa loo gɛnen mɔ, ɔ mɛŋ nyi ilaa ibono i ba mɔ-kuli so mɔ so sɛi. ");
INSERT INTO acd_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nfono ne Piita gi tɔgɛ sa mɔ yɛɛ, “Tɔgɛ me, imɔso i gyɛ gɛsintin yɛɛ aterenbi gɛgyɔnɔ gɛdɛ ɔkara ne fo‑rɛ fo-kuli fɛ nyɛ lii gɛsinkpan gɛbono fɛ fɛ mɔ dɔ?” Piita gi taasɛ mɔ gɛnen mɔ, ɔ lɛɛ gɛnɔ yɛɛ, “Ɛn, aterenbi adɛ ɔkara ne a nyɛ.” ");
INSERT INTO acd_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ɔkyii mɔ gi tɔgɛ sa Piita gɛnen mɔ, Piita gi taasɛ mɔ yɛɛ, “I wonɛ so ne fo‑rɛ fo-kuli fɛ tɔgɛ kyule abara ne fɛ ba fɛ kya soo Wurubuaarɛ Oduduu mɔ idoo fɛ kya kerɛ gɛnen? To, asa abono mɛ kyu fo-kuli kpaa pule mɔ, gɛnen asa abono mɛ laa kyu fo kee kyu lii kpe kpaa pule.” ");
INSERT INTO acd_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Ɔkyii mɔ gi nu gɛnen mɔ, ayaa abono so mɔ, ɔ lii tɔrɔ Piita ayaa dɔ ne o wuꞌ. Adega abono mɛ kpaa pule mɔ-kuli mɔ mɛ baa loo mɔ, ɔkyii mɔ kee gi wuꞌ ɔ dɛ, ne mɛ kyu mɔ lii kyon mɛꞌ kpaa pule sindi mɔ-kuli. ");
INSERT INTO acd_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Nfono mɔ gifuu belɛ giko gi keda Yesu asonbo mɔ pɛwu de asa abono mɛ nu gɛnen ilaa idɛ mɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Yesu isɔɔ mɔ mɛ kya wɔra ilaa gbaaꞌgbaa ibono i kya lɛɛ nyiile yɛɛ Wurubuaarɛ ɔlon bo mɔmɔ dɔ. Mɔmɔ‑rɛ Yesu asonbo sɛnsɛ mɔ pɛwu mɛ kya kyena kpaa gyanꞌ fɛɛ nyamesɛ kolon Wurubuaarɛ ɔson obu mɔ dɔ gibaafon giko nfono mɛ kya terɛ yɛɛ Solomon Gikpalan mɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Asa sɛnsɛ abono mɛ mɛŋ bo mɔmɔ-gikpen mɔ dɔ mɔ mɛŋ kya taalɛ da otu kpaa saarɛ mɔmɔ dɔ. Imɔ gɛnen gbaa faa mɔ, Yesu asonbo mɔ mɛ dabɔlɛ mɛ kya gyi ginsi asa ansi so. ");
INSERT INTO acd_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Asa sakyɔ, anyen de akyii, mɛ kya sɔɔ Wura Yesu gyi ne mɛ kpɛ ma‑a ba ma‑a bɔla mɔ-asonbo mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Kyu lii ilaa dɛnsɛ ibono Yesu isɔɔ mɔ mɛ kya wɔra mɔ so mɔ, asa mɛ kya sola alɔbo de mɔmɔ-idɛten kyu kpaa diila de ikpa de nengyene Piita kya kyon de nfono so mɔ, ba‑a mɔ-gɛyii gbaa gɛꞌ taa nyɛ ten kyon alɔbo mɔ ako so mɔ de iꞌ kyɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Asa sakyɔ mɛ kya lii ma‑a lii isowolɛ ibono i sindi Gyɛrusalem mɔ mɛ kya sola alɔbo de asa abono ilaa nyɛnyɛn oduduu i tɛ mɔmɔ so i kya nyala mɔmɔ mɔ mɛ kya bara Yesu isɔɔ mɔ, ne mɔmɔ mɔ mɛ kya kyɛ mɔmɔ pɛwu. ");
INSERT INTO acd_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Nfono mɔ, Gyuda awura asunbi alɛɛbo gɛmu mɔ mɔ‑rɛ mɔ-nanboana pɛwu abono mɛ bo Saadusii gikpen mɔ dɔ mɔ, mɛ wu Yesu isɔɔ mɔ gɛsun wɔrasɛ mɔ, i bo mɔmɔ gɛlaaloo gikyɔ, ");
INSERT INTO acd_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","imɔso mɛ kpaa keda mɔmɔ, ne mɛ kyu mɔmɔ kpaa tii de obu nfono mɛ kya tii ɔsowolɛ mɔ so ilaa nyɛnyɛn awɔrabo mɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Mɛ keda mɔmɔ kyu tii de obu gɛnen mɔ, imɔ gɛnyɛ mɔ Wurubuaarɛ dɔ ɔsɔɔ gi baa keda obu mɔ tigi ne ɔ kparɛ mɔmɔ lii, ne ɔ tɔgɛ sa mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Fɛꞌ naa kpe Wurubuaarɛ ɔson obu gikpaara mɔ so de fɛꞌ kpaa tɔgɛ gɛkyena pobɔrɔ gɛbono Yesu kya sa mɔ ilaa pɛwu sa asa.” ");
INSERT INTO acd_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Yesu isɔɔ mɔ mɛ nu ilaa ibono Wurubuaarɛ dɔ ɔsɔɔ mɔ gi tɔgɛ sa mɔmɔ. Gɛdɛ gɛ kɛ mɔ, mɛ naa kpaa loo Wurubuaarɛ ɔson obu gikpaara mɔ so, ne mɛ yii gɛsɛ mɛ kya nyiile asa ilaa. Gɛnen owi ɔbono mɔ, Isirale awura asunbi alɛɛbo gɛmu mɔ mɔ‑rɛ mɔ-nanboana mɛ terɛ abelɛnsɛ sɛnsɛ mɔ pɛwu (mɔmɔ ne n gyɛ nbɛlɛ agyibo sa Isirale awura mɔ), ne mɛ baa gyanꞌ. Mɛ baa gyanꞌ mɔ, mɛ sun asogya kpe nfono mɛ kya tii asa de obu mɔ yɛɛ mɛꞌ kpaa kyu Yesu isɔɔ mɔ ba mɔmɔ-ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Asogya abono mɛ lɛɛ sun gɛnen mɔ mɛ kpe mɔ, mɛ mɛŋ wu Yesu isɔɔ mɔ mɛ keda tii de obu mɔ, ne mɛ kii kpaa buu sa abelɛnsɛ mɔ ");
INSERT INTO acd_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","yɛɛ, “A kpe mɔ, obu mɔ asin mɔ a tii kpem, ne abono mɛ kya dii nno mɔ mɛ yelɛ gɛbunono mɔ asɛ mɛ kya dii. A tigi ne a loo obu mɔ dɔ mɔ, a mɛŋ wu ɔko‑rɛ ɔko.” ");
INSERT INTO acd_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wurubuaarɛ ɔson obu mɔ adiibo ɔbelɛnsɛ mɔ de asunbi alɛɛbo gɛmu mɔ‑rɛ mɔ-nanboana mɔ mɛ nu gɛnen mɔ, i wɔra mɔmɔ giyan ne i dɛ mɔmɔ-gɛnɔ mɛ mɛŋ nyi gɛnɔɔbono i wɔra ne i ba gɛnen mɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Nfono mɔ, ɔko gi baa buu sa mɔmɔ yɛɛ, “Anyen abono fɛ keda tii de obu mɔ, mɛ yelɛ Wurubuaarɛ ɔson obu gikpaara mɔ so mɛ kya nyiile asa ilaa.” ");
INSERT INTO acd_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Abelɛnsɛ mɔ mɛ nu gɛnen mɔ, Wurubuaarɛ ɔson obu mɔ adiibo ɔbelɛnsɛ mɔ‑rɛ mɔ-asogya mɔ, mɛ lii kyon de mɛꞌ kpaa keda Yesu isɔɔ mɔ ba abelɛnsɛ mɔ ansi dɔ. Asogya mɔ mɛ selɛ gifuu yɛɛ asa mɛ laa naa da mɔmɔ abui mɔɔ so mɔ, mɛ mɛŋ kyu Yesu isɔɔ mɔ kiri-kiri. ");
INSERT INTO acd_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Mɛ kpaa kyu Yesu isɔɔ mɔ ba gɛnen mɔ, mɛ yɛgɛ mɔmɔ‑rɛ nbɛlɛ agyibo mɔ mɛ baa gyanꞌ. Nfono mɔ, Gyuda awura asunbi alɛɛbo gɛmu mɔ gi taasɛ Yesu isɔɔ mɔ ilaa. Ɔ taasɛ mɔmɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“A mɛŋ gya fɛye yɛɛ gɛkaako-gɛkaako fɛꞌ mɛŋ baa nyiile asa ilaa kyu lii Yesu baarɛ ginyen dɔ? Fɛꞌ kerɛ gɛnɔɔbono fɛ naa fɛ kya nyiile asa mɔ-ilaa gyanꞌ de Gyɛrusalem pɛwu mɔ. Fɛ kya laarɛ fɛɛ fɛꞌ kyu mɔ-lɛwu mɔ kyu sola aye ne.” ");
INSERT INTO acd_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Ɔ taasɛ mɔmɔ gɛnen mɔ, Piita mɔ‑rɛ Yesu isɔɔ sɛnsɛ mɔ, mɛ lɛɛ gɛnɔ yɛɛ, “Wurubuaarɛ gɛdɛ ne i kaaborɛ aꞌ nu. I mɛŋ gyɛ nyamesɛ-lɛɛ gɛdɛ. ");
INSERT INTO acd_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Wurubuaarɛ ɔbono aye-naanaana mɛ son mɔ mɔ gi kii kyingi Yesu ɔbono fɛ da mɔ aŋanbi kyɔlɔga oyii so mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Wurubuaarɛ gi diirɛ mɔ kpe mɔ asɛ kyu mɔ kpaa yii gɛwura buu de mɔ Wurubuaarɛ. Wurubuaarɛ yɛɛ Yesu ne ɔꞌ wɔra ɔgyangbarabo de ɔmɔlɛgɛbo sa asa. I lii fɛɛ gɛnen Yesu baarɛ laa yɛgɛ Isirale awura mɛꞌ nyɛ nu mɔmɔ-nyoro gɛsɛ yɛɛ mɛ gyɛ ilaa nyɛnyɛn awɔrabo de Wurubuaarɛ ɔꞌ nyɛ kyu mɔmɔ-ilaa nyɛnyɛn kyɛɛ mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Aye ne n wu Yesu ilaa idɛ de aye-ansi ne a kya tɔgɛ imɔ a kya sa asa faa. Wurubuaarɛ Oduduu mɔ kee kya lɛɛ imɔ-gɛsintin nyiile asa. Mɔ-Oduduu ɔbono ne ɔ kya kyu sa asa abono mɛ kya nu mɔ-gɛdɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Nbɛlɛ agyibo mɔ mɛ nu ilaa ibono Yesu isɔɔ mɔ mɛ tɔgɛ sa mɔmɔ gɛnen mɔ, i kyogedɛ mɔmɔ-gisen dɔ, ne mɛ laarɛ mɔmɔ-imɔɔten. ");
INSERT INTO acd_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ɔbelɛnsɛ ɔko bo abelɛnsɛ mɔ dɔ. Mɛ kya terɛ mɔ yɛɛ Gameeliya. Asa pɛwu mɛ kya kyu buubuu sa mɔ gikyɔ. Ɔ gyɛ daa Farasii gikpen mɔ dɔ ne ɔ kya nyiile Wurubuaarɛ nbara. Gameeliya baarɛ gi koso tɔgɛ yɛɛ mɛꞌ kyu Yesu isɔɔ mɔ kyu lii kpe nkan ŋmaraa pɛi. ");
INSERT INTO acd_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Mɛ liirɛ mɔmɔ nkan gɛnen mɔ, ɔ tɔgɛ sa nbɛlɛ agyibo mɔ yɛɛ, “Me-nanboana Isirale awura, ilaa ibono fɛ kya laarɛ de fɛꞌ kyu wɔra gɛnen asa adɛ faa, fɛꞌ kerɛ fɛye-nyoro so dɔɔdan. ");
INSERT INTO acd_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Nkɛ nko dɔ mɔ, ɔnyen ɔko gi koso yɛɛ ɔ gyɛ ɔmɔlɛgɛbo, mɛ kya terɛ mɔ yɛɛ Tiyodasɛ. Asa mɛ laa wɔra fɛɛ asa nwɛ nnan mɛ kpaa kpandɛ mili mɔ. Asa ako mɛ mɔɔ mɔ. Mɛ mɔɔ mɔ gɛnen mɔ, asa abono pɛwu mɛ buu mɔ mɔ mɛ yaasɛ ne ilaa ibono nkana mɛ kya wɔra mɔ pɛwu i sii giyan. ");
INSERT INTO acd_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","“Mɔ-gɛmara mɔ, owi ɔbono mɛ naa kyena kalɛ asa iko dɔ mɔ, Gyudasɛ, Galelinyen mɔ kee gi koso yelɛ yɛɛ ɔ laa kɔ de abɛyin. Mɔ kee gi baa nyɛ asa mɛ kpandɛ mili mɔ. Ako mɛ mɔɔ mɔ kee, ne asa abono mɛ mili mɔ gɛnen mɔ pɛwu mɛ yaasɛ giyan-giyan. ");
INSERT INTO acd_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Imɔso nperɛ-nperɛ ilaa ibono anyen adɛ mɛ dɛ faa, nꞌ tɔgɛ tigi fɛye yɛɛ fɛye berɛ fɛꞌ taa mɔmɔ yɛgɛ. Ɔko ɔŋꞌ sa o yii mɔmɔ. I kya nyiile yɛɛ nengyene ilaa ibono mɛ kya wɔra faa, mɔmɔ-anyamesɛ gbaa-gbaa ne n ŋminde yɛɛ mɛ laa wɔra mɔmɔ-gibaa so mɔ, mɛ laa kpon daa. ");
INSERT INTO acd_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ne kuaa, ilaa ibono mɛ kya wɔra faa, i lii daa Wurubuaarɛ asɛ mɔ, nkana fɛ maŋ taalɛ gyi mɔmɔ so. Laalaalogɛ mɔ, fɛ laa baa wu daa yɛɛ fɛ kya kɔ de Wurubuaarɛ.” Gameeliya gi ka abelɛnsɛ mɔ de nbɛlɛ agyibo mɔ gɛnen mɔ, mɛ nu mɔ asɛ, ");
INSERT INTO acd_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ne mɛ terɛ Yesu isɔɔ mɔ kii loo kpe mɔmɔ asɛ. Mɛ yɛgɛ mɛ taa mɔmɔ, ne mɛ da ɔmɔ tii yɛɛ gɛkaako mɛꞌ mɛŋ baa yelɛ Yesu ginyen dɔ tɔngɛ sa asa. Nfono mɔ nbɛlɛ agyibo mɔ mɛ taa mɔmɔ yɛgɛ, ");
INSERT INTO acd_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ne mɛ naa lii. Yesu isɔɔ mɔ mɛ lii gɛnen mɔ, i wɔra mɔmɔ ɔkon fɛɛ Wurubuaarɛ gi kalɛ ɔmɔ wɔra mɔ-asonbo dɔ yɛɛ asa mɛ ka ɔmɔ-ansi kyu lii Yesu so gɛnen. ");
INSERT INTO acd_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Imɔ gɛnen gbaa mɔ, gɛkɛ gɛŋ bo no yɛɛ Yesu isɔɔ mɔ mɛ mɛŋ kpe Wurubuaarɛ ɔson obu mɔ dɔ de nten-ana dɔ kpaa tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ sa asa yɛɛ Yesu ne n gyɛ ɔbono ɔ laa mɔlɛgɛ asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ. ");
INSERT INTO acd_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Owi ɔbono Yesu akasɛbo mɔ mɛ kya nyaakyɔ ma‑a too mɔ, i bo Gyuda awura abono mɛ kya tɔgɛ Geriiki awura gɛdɛ ne i bo abono mɛ kya tɔgɛ mɔmɔ Gyuda awura-lɛɛ gɛdɛ wolɛ mɔ mɔmɔ dɔ. Gɛnen owi ɔbono mɔ, biidɛ ɔko gi baa tɔrɔ akpen anyɔ adɛ so. Gyuda awura abono mɛ kya tɔgɛ Geriiki awura gɛdɛ mɔ mɛ kya lɔgedɛ yɛɛ nengyene gɛkɛ kamaasɛ Yesu akasɛbo mɔ mɛ kya yɛ agyudɔ sa ikulaabo mɔ, mɛ kya ligi mɔmɔ-lɛɛ ikulaabo. ");
INSERT INTO acd_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Nfono mɔ, Yesu isɔɔ gudu anyɔ mɔ mɛ terɛ Yesu akasɛbo mɔ pɛwu baa gyanꞌ ne mɛ tɔgɛ sa mɔmɔ yɛɛ, “I mɛŋ boran yɛɛ aꞌ nyaa Wurubuaarɛ agyɛbi mɔ gitɔgɛ yela nkan de aꞌ nu de agyudɔ giyɛ sa asa wolɛ. ");
INSERT INTO acd_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Imɔso, ansaana, fɛꞌ kerɛ fɛye dɔ de fɛꞌ lɛɛ asa sono sa aye de aꞌ kyu gɛsun gɛbono wɔra mɔmɔ-abaa dɔ. Abono fɛ laa lɛɛ mɔ, fɛꞌ kerɛ yɛɛ asa mɛ kya terɛ mɔmɔ-ginyen dɛnsɛ ne Wurubuaarɛ Oduduu mɔ tɛ mɔmɔ so ne mɛ nyi ɔlaako; ");
INSERT INTO acd_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","de aye mɔ, aꞌ nyɛ aye-nyoro a kya nu daa de gɛdalaa de Wurubuaarɛ agyɛbi mɔ gɛsun gɛbono o kyu wɔra aye-abaa dɔ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ilaa ibono Yesu isɔɔ gudu anyɔ mɔ mɛ tɔgɛ gɛnen mɔ, i wɔra sakpii mɔ pɛwu ɔkon. Nfono ne mɛ lɛɛ Sitiifen de asa asee ako. Gɛnen Sitiifen baarɛ kya ka gyanꞌ Yesu so gikyɔ-gikyɔ ne Wurubuaarɛ Oduduu mɔ tansi ɔ tɛ mɔ so. Asɛnsɛ abono mɛ lɛɛ mɔ anyen ne n gyɛ Filipo, Perokoro, Nikanɔ, Timon, Pamenasɛ, de Nikolasɛ. Gɛnen Nikolasɛ baarɛ gi lii Antiyoki. Ɔ gyɛ isafo, ne o kyu mɔ-nyoro wɔra Gyuda awura ɔson dɔ. ");
INSERT INTO acd_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Mɛ kyu gɛnen asa sono abono mɛ lɛɛ faa kyu baa yela Yesu isɔɔ gudu anyɔ mɔ ansi dɔ ne mɔmɔ mɔ, mɛ kyu mɔmɔ-abaa gyanꞌ mɔmɔ so dalaa kolɛ Wurubuaarɛ sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Wurubuaarɛ agyɛbi mɔ a kya yɛlegɛ a kya too ne Yesu akasɛbo mɛ kya ŋan Gyɛrusalem ɔsowolɛ mɔ so gikyɔ-gikyɔ. Wurubuaarɛ asunbi alɛɛbo mɔ dɔ sakyɔ kee mɛ nu Wurubuaarɛ gɛdɛ ne mɛ sɔɔ Yesu ɔkalan mɔ gyi. ");
INSERT INTO acd_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Wurubuaarɛ gibaa gi gyan Sitiifen so ne mɔ-ɔlon bo mɔ dɔ. Imɔso i yɛgɛ ɔ kya wɔra ilaa gbaaꞌgbaa ibono nkana nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so mɔ de ilaa ibono i kya lɛɛ Wurubuaarɛ ɔlon gɛwi nyiile mɔ. ");
INSERT INTO acd_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Asa ako mɛ lii Gyuda awura gikyangbon giko dɔ. Mɔmɔ dɔ ako mɛ kya sɔɔ akyɔɔlɛ de Sitiifen. Mɛ kya terɛ gɛnen gikyangbon mɔ yɛɛ Asa Abono Mɛŋ Baa Mɛ Gyɛ Nbide Mɔ Gikyangbon. Mɔmɔ ako mɛ lii Siirini ɔsowolɛ so de Alɛsandiriya ɔsowolɛ so, ne ako mɛ lii Silisiya de Esiya nsinkpan so. ");
INSERT INTO acd_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Wurubuaarɛ Oduduu mɔ gi sa Sitiifen ɔlaako ginyi giko. Nengyene ɔ kya tɔngɛ mɔ, asa abono mɛ kya sɔɔ akyɔɔlɛ de mɔ mɔ mɛ mɛŋ kya taalɛ wɔda. ");
INSERT INTO acd_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Imɔso gɛnen asa abono mɛ sa anyen ako aterenbi ŋara yɛɛ mɛꞌ ten Sitiifen gɛnɔ yɛɛ mɛ nu ɔ kya saalɛ mɔmɔ-naana Mosisi de Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Asa adɛ mɛ ten Sitiifen gɛnɔ ne i yɛgɛ Gyuda awura abelɛnsɛ de mɔmɔ-nbara aŋmarasɛbo de asa sɛnsɛ mɔ mɛ kyu ginyadon wɔra Sitiifen. Nfono mɔ, mɛ kpaa keda mɔ ne mɛ kparɛ mɔ kpe nbɛlɛ agyibo mɔ ansi dɔ. ");
INSERT INTO acd_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Mɛ kyu mɔ kpe nbɛlɛ agyibo mɔ asɛ gɛnen mɔ, mɛ ten mɔ-gɛnɔ yɛɛ, “Owi kamaasɛ dɔ mɔ, gɛnen ɔnyen baarɛ kpɛ ɔ kya tɔgɛ daa ilaa nyɛnyɛn kyu lii Wurubuaarɛ ɔson obu baarɛ de aye-naana Mosisi nbara mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","A nu ɔ kya tɔgɛ yɛɛ Yesu Nasarɛtɛnyen mɔ laa baa nyida Wurubuaarɛ ɔson obu baarɛ de ɔꞌ kyɛɛgɛ idedaabolaa ibono aye-naana Mosisi gi yela sa aye mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Asa abono pɛwu mɛ tɛ nbɛlɛ mɔ ogyiten mɔ mɛ kerɛ Sitiifen yiridididi mɔ, mɔ-ansi dɔ i wɔra fɛɛ Wurubuaarɛ dɔ ɔsɔɔ ansi dɔ ɔnan. ");
INSERT INTO acd_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Mɛ bo nbɛlɛ mɔ ogyiten gɛnen mɔ, asunbi alɛɛbo gɛmu mɔ gi taasɛ Sitiifen yɛɛ, “Ilaa ibono mɛ kya tɔgɛ kyu lii fo so faa i gyɛ gɛsintin?” ");
INSERT INTO acd_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sitiifen gi lɛɛ gɛnɔ yɛɛ, “Me-sɛana de me-subuana, fɛꞌ nu me asɛ. Nyisigyi Wura Wurubuaarɛ gi lɛɛ mɔ-nyoro nyiile aye-naana Aberaham owi ɔbono ɔ tɛ Mɛsopotemiya gɛsinkpan so pɛi ne ɔ lɔɔ kpaa kyena Haran ɔsowolɛ so. ");
INSERT INTO acd_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Owi ɔbono Wurubuaarɛ gi lɛɛ mɔ-nyoro gɛwi nyiile Aberaham gɛnen mɔ, ɔ tɔgɛ sa mɔ yɛɛ, ‘Aberaham, koso fo-gɛsinkpan gɛdɛ so de foꞌ naa taa fo-subuana yɛgɛ de foꞌ kpaa kyena gɛsinkpan gɛbono nan nyiile fo mɔ so.’ ");
INSERT INTO acd_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Wurubuaarɛ gi tɔgɛ Aberaham gɛnen mɔ, gɛsintin mɔ Aberaham gi koso lii kyon Kaladiya gɛsinkpan so, ne ɔ kpaa kyena Haran ɔsowolɛ so. Aberaham mɔ-sɛ lɛwu gɛmara ne Wurubuaarɛ gi yɛgɛ ɔ koso lii Haran baa kyena gɛnen gɛsinkpan gɛbono so aye Gyuda awura a tɛ ndɛ faa. ");
INSERT INTO acd_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","“Owi ɔbono Wurubuaarɛ gi kyu Aberaham baa kyena gɛsinkpan gɛbono a tɛ faa mɔ, Wurubuaarɛ mɛŋ sa mɔ yɛɛ mɔ-gɛsinkpan ogyiten ne. Baa nyamesɛ giyaa ɔŋmangɛ ɔkara Wurubuaarɛ mɛŋ sa mɔ. Imɔ gɛnen mɔ, Wurubuaarɛ gi ka yela sa Aberaham yɛɛ ɔ laa kyu gɛmɔ kyu kyɛɛ mɔ gɛkaako de gɛꞌ wɔra mɔ‑rɛ mɔ-biana kyu kpaa lii mɔ-naanaana gɛnɔ-gɛnɔ gɛsinkpan gɛkpaa. Owi ɔbono Wurubuaarɛ kya ka ɔ kya sa Aberaham gɛnen mɔ, Aberaham mɛŋ bo ba‑a gɛbii. ");
INSERT INTO acd_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Wurubuaarɛ gɛnɔ dɔ agyɛbi abono ɔ tɔgɛ sa Aberaham mɔ ne n gyɛ yɛɛ, ‘Aberaham, fo-naanaana oyuduu dɔ pɛwu mɛ laa kpaa gyi gisafo ako gɛsinkpan so. Nten abi mɔ mɛ laa ka mɔmɔ-ansi de mɛꞌ kyu mɔmɔ wɔra nbide san sa abi san sa anaana nsi nwɛ nnan. ");
INSERT INTO acd_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nan biidɛ asa abono fo-oyuduu mɔ mɛ laa son mɔ giso. Imɔ gɛmara mɔ mɛ laa lii nten abi mɔ dɔ de mɛꞌ kii baa kyena gɛsinkpan gɛbono so fo yelɛ faa de mɛꞌ son me.’ ");
INSERT INTO acd_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wurubuaarɛ gi yela awɔrɛ giten nbara sa Aberaham de iꞌ lɛɛ nyiile yɛɛ Wurubuaarɛ gi yɛgɛ mɔ‑rɛ Aberaham mɛ wɔra gɛnɔ kolon. Gɛnen so mɔ, Aberaham gi korogɛ Ayisiki mɔ, imɔ gɛkɛ kuesɛ mɔ, ɔ ten Ayisiki giwɔrɛ. Ayisiki gi kyu korogɛ Gyeekɔpo mɔ, mɔ kee gi ten mɔ-bi mɔ giwɔrɛ. Gyeekɔpo gi korogɛ ne ɔ ten mɔ-biana gudu anyɔ mɔ awɔrɛ. Gɛnen Gyeekɔpo mɔ-biana gudu anyɔ adɛ ne n yɛgɛ aye-Isirale awura ɔpaa mɔ gi yɛlegɛ. ");
INSERT INTO acd_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Aye-naana Gyeekɔpo mɔ-biana adɛ mɔmɔ-gɛnɔɔrɛ asɛ ne n gyɛ Gyosɛfo. Mɔ-ilaa i wɔra mɔ-daana gɛlaaloo gikyɔ. Gɛnen so mɔ, mɛ fɛ mɔ sa asa ako ne mɛ kyu mɔ kpe Igyipiti. Mɛ fɛ Gyosɛfo gɛnen mɔ, Wurubuaarɛ dɛ mɔ ɔ naa. ");
INSERT INTO acd_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Imɔso Wurubuaarɛ gi lɛɛ mɔ lii mɔ-awɔrɔfɔɔ kamaasɛ dɔ. Ɔ yɛgɛ Igyipiti wura gi wu mɔ bii yɛɛ o nyi ɔlaako. Imɔso o gyi Igyipiti wura mɔ ginsi ne wura mɔ gi yii mɔ gɛbelɛnsɛ buu de mɔ. Gyosɛfo kee ne n kya kerɛ wura mɔ-gɛten dɔ ilaa kamaasɛ so. ");
INSERT INTO acd_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Mɛ bo nno gɛnen‑n mɔ, owi ɔko dɔ mɔ, akon belɛ ako a tɔrɔ Igyipiti gɛsinkpan pɛwu so de Keena gɛsinkpan so nfono aye-naanaana mɛ tɛ mɔ. Nfono mɔ awɔrɔfɔɔ belɛ a tu mɔmɔ. Aye-naanaana mɛŋ kya nyɛ agyudɔ de mɛꞌ gyi. ");
INSERT INTO acd_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Ibono aye-naana Gyeekɔpo gi nu yɛɛ Igyipiti berɛ agyudɔ a bo no mɛ kya fɛ mɔ, ɔ keda aye-naanaana kyu sun ne mɛ kpe mɔmɔ-gikpe gyangbarasɛ. ");
INSERT INTO acd_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Ginyɔsɛ mɔ o kii sun mɔmɔ mɔ, idɛ kon ne mɔmɔ-tedɛ Gyosɛfo mɔ gi lɔɔ lɛɛ mɔ-nyoro nyiile mɔmɔ. Nfono ne Igyipiti wura mɔ gi kyu bii gɛsu gɛbono dɔ Gyosɛfo gi lii mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Gyosɛfo gi sun kpaa kyu mɔ-sɛ Gyeekɔpo mɔ‑rɛ mɔ-adɛ pɛwu yɛɛ mɛꞌ baa kyena mɔ asɛ. Mɔmɔ pɛwu gɛgyɔnɔ gɛ gyɛ asa ikue-isa de saalaa asa anun. ");
INSERT INTO acd_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Gɛsintin mɔ, Gyeekɔpo gi koso mɔ‑rɛ mɔ-adɛ mɔ, ne mɛ kpaa kyena Igyipiti gɛsinkpan so. Gyeekɔpo de mɔ-biana, aye-naanaana mɔ, mɛ kyena Igyipiti kaaborɛ mɛ wuꞌ nno. ");
INSERT INTO acd_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Mɛ kya wuꞌ mɔ, abono mɛ tɛ de ansi mɔ mɛ kya sola ibuni mɔ kyu kpe Sikyem ɔsowolɛ so kpaa wɔra folɛbɔ gɛkyan gɛko dɔ. Mɔmɔ-naana Aberaham ne n kalɛ aterenbi wolaa sɔɔ gɛnen gɛkyan gɛbono yela. Ɔ sɔɔ gɛmɔ lii ɔnyen ɔko mɔ-biana asɛ mɛ kya terɛ mɔ yɛɛ Hamɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Owi ɔbono Wurubuaarɛ laa baa wɔra ilaa ibono ɔ wolaa ka yela sa Aberaham mɔ kya fuude mɔ, aye-asa abono mɛ kpaa kyena Igyipiti awura asɛ mɔ mɛ yɛlegɛ nyaakyɔ too. ");
INSERT INTO acd_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","I bo no i bo no mɔ, wura pobɔrɔ ɔko gi baa gyi gɛwura sa Igyipiti awura. Gɛnen wura ɔbono berɛ mɛŋ nyi Gyosɛfo. ");
INSERT INTO acd_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","O kyu adawo ɔ kya wɔra aye-gɛsu mɔ gɛnɔ. Ɔ kya nyise mɔmɔ okyugya. Ɔ kya yɛgɛ mɛꞌ kyu mɔmɔ-nbii nyensɛɛ pobɔrɔ abono mɛ kya korogɛ mɔ kpaa yela nŋmaŋman de mɛꞌ wuꞌ. ");
INSERT INTO acd_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","“Mɔmɔ-awɔrɔfɔɔ mɔ aberɛ dɔ ne i kyu korogɛ Mosisi. Mɛ korogɛ Mosisi gɛnen mɔ, ɔ wɔra ɔdan Wurubuaarɛ ansi so. Mɛ ŋara kerɛ mɔ so mɔ-sɛ gɛten dɔ ibosɛ isaꞌ. ");
INSERT INTO acd_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Mɛ kyu mɔ lii kpaa yela nŋmaŋman mɔ, wura mɔ mɔ-bi kyiisɛ ɔko gi kpaa puru mɔ, ne o kyu mɔ bela wɔra fɛɛ mɔ gbaa-gbaa mɔ-bi. ");
INSERT INTO acd_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Imɔso mɛ kyu Igyipiti awura ilaa wɔrasɛ pɛwu kyu bela mɔ. Mosisi gi sɛɛ wɔra nyamesɛ gbaaꞌ mɔ-gɛtɔngɛ dɔ de mɔ-ilaa wɔrasɛ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“O gyi nsi ikue-inyɔ mɔ, i ba mɔ-gɛwɔnsa dɔ yɛɛ ɔꞌ kpaa laa mɔ-nanboana Isirale awura. ");
INSERT INTO acd_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ɔ kpaa laa mɔmɔ gɛnen mɔ, o wu Igyipitinyen ɔko kya kudi mɔ-nanbo Isiralenyen ɔko ɔ kya daarɛ giyan. Mosisi gi wu gɛnen mɔ, ɔ kɔɔlɛ mɔ-nanbo Isiralenyen mɔ so, ne ɔ mɔɔ Igyipitinyen mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Mosisi gi wɔra gɛnen mɔ, mɔ berɛ, o nyi yɛɛ mɔ-nanboana Isirale awura mɔ mɛ laa nu ilaa ibono ɔ wɔra mɔ gɛsɛ de mɛꞌ bii yɛɛ Wurubuaarɛ kya laarɛ de ɔꞌ naa de mɔ Mosisi so lɛɛ mɔmɔ lii mɔmɔ-gɛbide mɔ dɔ daa. Mosisi gi dabɔlɛ wɔra gɛnen faa, mɔ-nanboana mɔ mɛ mɛŋ taa nu imɔ gɛsɛ sa mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Imɔ gɛdɛ kɛsɛ mɔ, Mosisi gi naa kpaa lii mɔ-nanboana Isirale awura wolɛ-wolɛ anyɔ ako so mɛ yelɛ mɛ kya kɔ. Nfono ne Mosisi gi keda mɔmɔ ne ɔ taasɛ mɔmɔ yɛɛ, ‘Me-nanboana, fɛ mɛŋ nyi yɛɛ fɛ gyɛ daa nyamesɛ kolon? Fɛŋꞌ baa kɔ.’ ");
INSERT INTO acd_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Mosisi kya keda mɔmɔ gɛnen mɔ, ɔbono ɔ kya kudi mɔ-nanbo mɔ gi nen Mosisi kpaa yela nkan ne ɔ taasɛ Mosisi yɛɛ, ‘Anɛ ne n lɛɛ fo yɛɛ foꞌ kerɛ aye so de foꞌ gyi aye-nbɛlɛ? ");
INSERT INTO acd_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Fo kya laarɛ de foꞌ mɔɔ me fɛɛ gɛnɔɔbono deeri fo ti mɔɔ Igyipitinyen mɔ abɛɛ?’ ");
INSERT INTO acd_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Mosisi gi nu ilaa ibono mɔ-nanbo Isiralenyen gi taasɛ mɔ mɔ, ɔ koso selɛ lii gɛnen ɔsowolɛ ɔbono so ne ɔ kpaa kyena Midiyan awura gɛsinkpan so. Ɔ korogɛ nbii nyensɛɛ nnyɔ nno. ");
INSERT INTO acd_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Owi ɔbono Mosisi tɛ Midiyan mɔ, imɔ nsi ikue-inyɔ gɛmara mɔ, Wurubuaarɛ dɔ ɔsɔɔ gi lɛɛ mɔ-nyoro nyiile mɔ giponfɛ giko dɔ. Giponfɛ mɔ gi yelɛ gi kya dɛɛ gipen dɔ sindi Saanayi gibii. ");
INSERT INTO acd_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Mosisi gi wu gɛnen mɔ, i dɛ mɔ-gɛnɔ. Imɔso ɔ kya tu ɔ kya sindi giponfɛ mɔ de ɔꞌ lɔrɔ kerɛ dɔɔdan mɔ, o nu Wurubuaarɛ gigyɛbiꞌ. Wurubuaarɛ gi tɔgɛ sa mɔ yɛɛ, ");
INSERT INTO acd_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Me ne n gyɛ Wurubuaarɛ ɔbono fo-naanaana Aberaham, de Ayisiki, de Gyeekɔpo mɛ son mɔ.’ Nfono mɔ, i wɔra Mosisi gifuu. Ɔ san ɔ yelɛ nno ɔ kya seli. Ɔŋ baa taalɛ diirɛ ansi kerɛ giponfɛ mɔ gɛten gbaa. ");
INSERT INTO acd_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Nfono ne Wura Wurubuaarɛ gi tɔgɛ sa Mosisi yɛɛ, ‘Nɛ kpelegɛ ba nfono fo yelɛ faa. Imɔso lɛɛ fo-ayaawolɛ. ");
INSERT INTO acd_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Gɛnɔɔbono Igyipiti awura mɛ kya wɔra me-adɛ abono mɛ bo mɔmɔ-gɛsinkpan so mɔ gɛnɔ mɔ, nɛ wu de me-ansi. Nɛ nu mɔmɔ-osulon ne nɛ kpelegɛ ba de nꞌ baa mɔlɛgɛ ɔmɔ. Idɛ kon tu ba. Nan sun fo Igyipiti.’ ");
INSERT INTO acd_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Gɛnen Mosisi baarɛ ne aye-naanaana Isirale awura mɔ mɛ naa kyena gya mɔ. Mɛ taasɛ mɔ gɛnen aberɛ abono dɔ yɛɛ, ‘Anɛ ne n lɛɛ fo yɛɛ foꞌ kerɛ aye so de foꞌ gyi aye-nbɛlɛ?’ Mosisi baarɛ, mɔ, kee ne Wurubuaarɛ gi sun yɛɛ ɔꞌ kerɛ mɔmɔ so de ɔꞌ sɔgɛ mɔmɔ lii mɔmɔ-gɛbide dɔ. Wurubuaarɛ dɔ ɔsɔɔ ɔbono Mosisi gi wu giponfɛ mɔ dɔ mɔ ne nan kpaa mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Mosisi gi lɛɛ aye-naanaana mɔ lii Igyipiti awura gɛsinkpan mɔ so. Ɔ wɔra ilaa gbaaꞌgbaa ibono i lɛɛ nyiile yɛɛ Wurubuaarɛ ɔlon bo mɔ dɔ. Ɔ wɔra ilaa ibono i kya dɛ gɛnɔ mɔ Igyipiti gɛsinkpan so de apoo abono mɛ kya terɛ mɔ yɛɛ Apoo Pebara mɔ so. Nsi ikue-inyɔ mumuli dɔ kee mɔ, ɔ kpɛ ɔ kya wɔra ilaa gbaaꞌgbaa gipen mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","“Gɛnen Mosisi baarɛ ne n tɔgɛ sa aye-naanaana Isirale awura mɔ owi ɔko dɔ baa kyon yɛɛ, ‘Wurubuaarɛ laa lɛɛ mɔ Wurubuaarɛ ikalan ɔtɔgɛbo ɔko lii fɛye dɔ sa fɛye fɛɛ gɛnɔɔbono ɔ lɛɛ me Mosisi kee sa fɛye mɔ.’ ");
INSERT INTO acd_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Owi ɔbono aye-naanaana mɛ bo gipen mɔ dɔ mɔ, Mosisi mɔ‑rɛ Wurubuaarɛ dɔ ɔsɔɔ kee mɛ bo mɔmɔ asɛ nno. Wurubuaarɛ dɔ ɔsɔɔ mɔ kya tɔngɛ sa Mosisi Saanayi gibii so de Mosisi mɔ oꞌ kyu gɛnen ikalan ibono kyu kpaa buu sa aye-naanaana mɔ. Imɔ ne n dɛ sa aye baa lii de ndɛ faa, ne i laa dɛ sa aye gɛkpaa-gɛkpaa. ");
INSERT INTO acd_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Imɔ‑rɛ imɔ gɛnen gbaa mɔ, aye-naanaana mɔ mɛ kine mɛ mɛŋ nu Mosisi gɛdɛ. Mɛ nyaa Mosisi-lɛɛ mɔ yela nkan ne mɔmɔ-nwɔnsa gi kii kpe Igyipiti gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Aberɛ abono Mosisi bo gibii mɔ so ɔ kya nu Wurubuaarɛ ikalan mɔ, mɛ baa kolɛ aye-naana Aron yɛɛ, ‘Wɔra ikperɛ sa aye de aꞌ son imɔ de iꞌ nyɛ gyangbara sa aye. Mosisi ɔbono ɔ kparɛ aye kyu lii Igyipiti gɛsinkpan mɔ so mɔ berɛ aŋ baa wu mɔ, ne a mɛŋ nyi ilaa ibono i wɔra mɔ mɔ.’ ");
INSERT INTO acd_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Nfono ne Aron gi yɛgɛ mɛ wɔra ɔkperɛ fɛɛ gɛnaadɛbi ne mɛ kyu nbuɛ kyu kyɔɔlɛ mɔ. Mɛ kerɛ gɛnen ɔkperɛ ɔbono mɔmɔ anyamesɛ mɛ kyu mɔmɔ-abaa kyu pɔrɔ gɛnen mɔ, i wɔra mɔmɔ ɔkon. ");
INSERT INTO acd_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Wurubuaarɛ, mɔ, mɛŋ kya laarɛ gɛnen. Gɛnen so mɔ, ɔ lɛɛ mɔ-ansi taa mɔmɔ yɛgɛ yɛɛ mɛꞌ wɔra ibono i bo mɔmɔ ɔbolɛ mɔ, ne mɛ san kyu agyɛkpebi kyu bingiri mɔmɔ-ikperɛ mɛ kya son amɔ ibono iŋ gyɛ Wurubuaarɛ gɛlaarɛ. Mɛ wolaa ŋmarasɛ mɔmɔ-ilaa idɛ yela Wurubuaarɛ ikalan atɔgɛbo ɔwolɛ mɔ dɔ. Mɛ ŋmarasɛ nno yɛɛ, ‘O, Isirale awura, menɛ ilaa ne fɛ wɔra faa? Nsi ikue-inyɔ nbono fɛ kyu kyena gipen mɔ dɔ ne fɛye yɛɛ fɛ kya kyɔɔlɛ nbuɛ fɛ kya sa me mɔ, iŋ gyɛ me ne fɛ kya wɔra imɔ fɛ kya sa. ");
INSERT INTO acd_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Fɛ sola fɛye-ɔkperɛ Moloki mɔ‑rɛ mɔ-obu kee fɛ naa fɛ kya son. Ne fɛye-ɔkperɛ Refan ɔbono fɛ salɛ mɔ fɛɛ gigyɛkpebi mɔ kee ne fɛ sola fɛ naa. Gɛnen ilaa ibono fɛye gbaa-gbaa ne n kyu fɛye-abaa kyu wɔra imɔ mɔ, fɛ baa kii son imɔ? Kyu lii gɛnen ilaa ibono so mɔ, me Wurubuaarɛ nan gya fɛye koso de nꞌ kperɛ fɛye kpaa kyena Babilon awura gɛsinkpan mɔ gɛmara.’ ");
INSERT INTO acd_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Ansaana, fɛꞌ nu yɛɛ aye-naanaana mɛ bo gipen mɔ dɔ mɔ, mɛ nyɛ Wurubuaarɛ ɔsonten mɔmɔ asɛ. I gyɛ nbuɛ iwolɛ-lɛɛ panpan ɔbono mɛ kya taalɛ bɔɔ mɔ sola naa naa mɔ. Wurubuaarɛ ne n kaala panpan mɔ gidebi nyiile Mosisi, ne Mosisi gi yɛgɛ mɛ wɔra panpan mɔ fɛɛ gɛnɔɔbono Wurubuaarɛ gi kaala nyiile mɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Aye-naanaana mɔ mɛ kyu panpan mɔ kyu sa mɔmɔ-biana, ne mɔmɔ-biana mɔmɔ‑rɛ mɔmɔ-ɔbelɛnsɛ Gyosuwa mɛ kyu panpan mɔ kyu ba gɛsinkpan gɛbono so a tɛ faa. Pɛi de mɛꞌ lɔɔ baa loo gɛrɛnaa mɔ, asa kpɛi-kpɛi mɛ ti wolaa mɛ tɛ gɛrɛ, ne Wurubuaarɛ gi gya mɔmɔ abono koso ne ɔ sɔgɛ gɛsinkpan mɔ kyu sa aye-naanaana. “Gɛnen Wurubuaarɛ nbuɛ iwolɛ-lɛɛ panpan ɔbono n darɛ faa gi sii aye-naanaana asɛ gɛnen‑n kaaborɛ i baa fo Deefidi gɛkyena dɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Deefidi gi gyi Wurubuaarɛ ginsi ne Wurubuaarɛ gi wɔra wɔra ilaa sa mɔ. Ne Deefidi gi kolɛ Wurubuaarɛ yɛɛ ɔꞌ yɛgɛ mɔ de oꞌ yii obu gbaa-gbaa de iꞌ wɔra mɔ Wurubuaarɛ ɔbono mɔ-naana Gyeekɔpo gi son mɔ ɔsonten. ");
INSERT INTO acd_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Deefidi gi kolɛ Wurubuaarɛ gɛnen mɔ, i mɛŋ gyɛ mɔ gbaa-gbaa ne n nyɛ yii Wurubuaarɛ ɔsonten mɔ. Mɔ-bi Solomon ne n baa yii gɛnen obu mɔ. ");
INSERT INTO acd_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Wurubuaarɛ gi yɛgɛ Solomon gi dabɔlɛ yii Wurubuaarɛ ɔson obu mɔ gɛnen gbaa faa, Gitɔbelɛ mɔ mɛŋ kya kyena ibu ibono anyamesɛ mɛ kyu mɔmɔ-abaa kyu pɔrɔ mɔ dɔ. Wurubuaarɛ ikalan ɔtɔgɛbo ɔko gi wolaa ŋmarasɛ imɔ so ilaa yela ");
INSERT INTO acd_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","yɛɛ, Wurubuaarɛ gi tɔgɛ yɛɛ, ‘Wurubuaarɛ dɔ ne n gyɛ me-gɛwuragyapaa. Gɛsinkpan ne n gyɛ me-ayaa dɔ ɔwolɛ toosɛ. Ne menɛ obu ɔnan ne fɛ laa pɔrɔ wɔra me yɛɛ me-obu ne? Fonɛ dɔ ne fɛ laa taalɛ lɔrɔ yela yɛɛ nꞌ baa kyena? ");
INSERT INTO acd_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","I mɛŋ gyɛ me gbaa-gbaa ne nꞌ kyu me-abaa kyu pɔrɔ ilaa kamaasɛ pɛwu?’ ");
INSERT INTO acd_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Fɛye abelɛnsɛ abono fɛ tɛ gɛrɛ faa, fɛye-aso dɔ i kɔrɔ ifuu. I wonɛ so ne fɛ bo gisomaanu fɛɛ abono mɛŋ kya son Wurubuaarɛ gɛnen? Fɛ maŋ kyu fɛye-gisen kyu sa Wurubuaarɛ, ne fɛ maŋ nu Wurubuaarɛ gɛdɛ. Ilaa ibono aye-naanaana de aye-sɛana mɛ wɔra mɔ, imɔ-ayaa kee ne fɛ buu faa. Owi kamaasɛ dɔ fɛ kpɛ fa‑a kine Wurubuaarɛ Oduduu mɔ gɛlaarɛ. ");
INSERT INTO acd_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Wurubuaarɛ ikalan ɔtɔgɛbo ɔmɔ ne n bo no yɛɛ aye-sɛana de aye-naanaana mɛ mɛŋ ka mɔ-ansi? Mɛ mɔɔ-mɔɔ Wurubuaarɛ ikalan atɔgɛbo abono mɛ wolaa tɔgɛ yela yɛɛ Gɛsintin Wura laa ba gɛsinkpan so mɔ. Gɛsintin mɔ, Yesu, ɔbono ɔ gyɛ Gɛsintin Wura mɔ, gi kpaa ba mɔ, fɛ kyu mɔ wɔra asa abaa dɔ, ne mɛ mɔɔ mɔ sa fɛye. ");
INSERT INTO acd_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Yɛgɛ fɛye ne Wurubuaarɛ dɔ isɔɔ mɔ mɛ kyu Wurubuaarɛ nbara mɔ baa sa, ne fɛye, mɔ, ne mɛŋ gyi nmɔ so faa.” ");
INSERT INTO acd_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Nbɛlɛ agyibo mɔ mɛ nu gɛnen ilaa ibono Sitiifen yelɛ ɔ kya tɔngɛ ɔ kya sa mɔmɔ mɔ, i kyogedɛ mɔmɔ-asen dɔ ne mɛ san mɛ kya wɛ nyoro kyu lii mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Sitiifen berɛ, Wurubuaarɛ Oduduu mɔ gi suu de mɔ so mɔ, ɔ diirɛ mɔ-ansi kerɛ soso yiridididi mɔ, o wu Wurubuaarɛ nyisigyi ne o wu Yesu yelɛ Wurubuaarɛ asɛ Wurubuaarɛ gibaa gyisɛ so. ");
INSERT INTO acd_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Sitiifen gi wu gɛnen mɔ, ɔ tɔgɛ sa abelɛnsɛ mɔ yɛɛ, “Fɛꞌ kerɛ! Soso i bugi ne Yesu, anyamesɛ pɛwu mɔmɔ-daa mɔ, yelɛ Wurubuaarɛ asɛ mɔ-gibaa gyisɛ so.” ");
INSERT INTO acd_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Sitiifen gi tɔgɛ sa mɔmɔ gɛnen mɔ, mɛ puiidɛ mɔ so, ne mɛ kyu mɔmɔ-abaa tii mɔmɔ-aso de mɛŋꞌ baa nu ilaa ibono ɔ kya tɔgɛ mɔ. Nfono mɔ, mɔmɔ pɛwu mɛ dabun mɔ so gikolon, ");
INSERT INTO acd_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ne mɛ biidɛ mɔ lii nten nkan kpe mɛꞌ kpaa da mɔ abui mɔɔ. Pɛi ne nbɛlɛ agyibo mɔ mɛ laa da mɔ abui mɔɔ mɔ, mɛ maragɛ mɔmɔ-akuru kyu kpaa yela ɔnyen ɔko asɛ, mɛ kya terɛ mɔ yɛɛ Sɔɔlo. ");
INSERT INTO acd_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Mɛ kya da Sitiifen abui gɛnen mɔ, Sitiifen gi saawo terɛ Yesu yɛɛ, “Me-Wura Yesu, fo-abaa dɔ ne nꞌ dɛ me-ɔŋɛ n kya wɔra.” ");
INSERT INTO acd_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nfono mɔ, Sitiifen gi sii ŋmii ne o kpen ken-ken yɛɛ, “Me-wura, kyu mɔmɔ-ilaa nyɛnyɛn ibono mɛ kya wɔra faa kyu kyɛɛ mɔmɔ.” Sitiifen gi dalaa gɛnen mɔ, ɔ lɛɛ ɔŋɛ. ");
INSERT INTO acd_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Sɔɔlo gi yelɛ abono mɛ mɔɔ Sitiifen mɔ gɛmara. Kpɛ san kyu lii gɛkɛ gɛbono mɛ da Sitiifen abui mɔɔ mɔ kyu kyon mɔ, asa mɛ lɔrɔ mɛ kya ka Yesu asonbo gikpen gibono gi bo Gyɛrusalem mɔ ansi gikyɔ. I yɛgɛ mɔmɔ pɛwu mɛ san yaasɛ gyanꞌ de Gyudiya de Samariya nsinkpan so. I san daa Yesu isɔɔ mɔ wolɛ nno. ");
INSERT INTO acd_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Mɛ mɔɔ Sitiifen gɛnen mɔ, asa abono mɛ selɛ Wurubuaarɛ mɔ dɔ ako mɛ pule mɔ, ne mɛ su mɔ gɛsintin so. ");
INSERT INTO acd_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Yesu asonbo gikpen mɔ ɔson mɔ so mɔ, Sɔɔlo kpɛ ɔ kya wɔra mɔmɔ anyanyan daa. Ɔ kya gbere loo nten-ana dɔ kpaa biidɛ anyen de akyii lii kyu kyon kpaa tii de obu. ");
INSERT INTO acd_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Yesu asonbo abono mɛ yaasɛ mɛ naa mɔ, mɛ kpɛ mɛ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ mɛ kya sa asa nfonoana mɛ naa mɛ naa mɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filipo gi kyon kpe ɔsowolɛ belɛ ɔbono mɛ kya terɛ mɔ yɛɛ Samariya mɔ ne ɔ kpaa tɔgɛ sa nno asa yɛɛ ɔbono ɔ laa mɔlɛgɛ asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ gi ti ba gɛsinkpan so. ");
INSERT INTO acd_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Sakpii belɛ mɔ dɔ ɔkamaasɛ gi yela giso ne o nu Filipo asɛ, ne asa mɛ wu ilaa gbaaꞌgbaa ibono o kyu Yesu ɔlon wɔra mɔ de mɔmɔ-ansi. ");
INSERT INTO acd_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","I lii fɛɛ ɔ kyɛ asa sakyɔ abono i mara ɔmɔ mɔ de ɔtɛgɛsɛana. Ne ɔ yɛgɛ ilaa nyɛnyɛn oduduu ibono i tɛ asa sakyɔ so mɔ i saawo ken-ken koso mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kyu lii gɛnen so mɔ, i wɔra ɔsowolɛ ɔbono so asa ɔkon kyɔde. ");
INSERT INTO acd_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ɔnyen ɔko gi kyena gɛnen Samariya ɔsowolɛ ɔbono so, mɛ kya terɛ mɔ yɛɛ Simon. Simon baarɛ kya wɔra afɛ nno mɔ i kɛɛla. Ɔ kya nyiile mɔ-nyoro yɛɛ mɔ ne n bo no. Mɔ-ilaa wɔrasɛ i kya dɛ asa gɛnɔ Samariya gɛsinkpan pɛwu so. ");
INSERT INTO acd_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nyamesɛ kamaasɛ ɔbono ɔ bo nno mɔ, gɛbii‑o, ɔbelɛnsɛ‑o, kya yela giso nu Simon baarɛ asɛ. Asa mɛ san mɛ kya tɔgɛ yɛɛ, “Gɛnen ɔnyen baarɛ ne n gyɛ Wurubuaarɛ ɔlon ɔbono mɛ kya terɛ mɔ yɛɛ Ɔbelɛ mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Simon baarɛ wolaa ɔ kya wɔra afɛ ne i kya dɛ asa gɛnɔ mɔ, iŋ gyɛ gɛnen owi ɔbono dɔ, i kɛɛla. Imɔso asa mɔ mɛ kya nu mɔ-gɛdɛ. ");
INSERT INTO acd_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Filipo gi kpe nno, ne ɔ kpaa tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ sa asa de mɛꞌ nu Wurubuaarɛ gɛwuragyi dɔ akyenabi mɔ ilaa. Ɔ tɔgɛ ɔmɔ yɛɛ Yesu ne n gyɛ ɔbono ɔ laa mɔlɛgɛ asa de mɛꞌ nyɛ gɛnen akyenabi abono. Asa mɔ mɛ nu Filipo ilaa tɔgɛsɛ mɔ, mɛ sɔɔ imɔ gyi, ne ɔ gyere mɔmɔ Wurubuaarɛ sagyere, mɔmɔ‑rɛ mɔmɔ-anyen de akyii. ");
INSERT INTO acd_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Simon fɛwura baarɛ gbaa kee gi sɔɔ Filipo ilaa tɔgɛsɛ mɔ gyi ne ɔ nyɛ Wurubuaarɛ sagyere. Ɔ san kyu mɔ-nyoro kyu da mada de Filipo. Filipo kya wɔra ilaa gbaaꞌgbaa ibono nyamesɛ maŋ taalɛ wɔra mɔ-gibaa so ne i kya lɛɛ Yesu ɔlon belɛ gɛwi nyiile asa. Simon ɔbono nkana ɔ gyɛ fɛwura mɔ, kya wu gɛnen mɔ, i kya dɛ mɔ-gɛnɔ gikyɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Imɔ gɛmara mɔ Yesu isɔɔ mɔ mɛ bo Gyɛrusalem mɔ mɛ nu yɛɛ Samariya awura mɛ sɔɔ Wurubuaarɛ agyɛbi mɔ gyi. Imɔso Yesu isɔɔ mɔ mɛ lɛɛ mɔmɔ dɔ asa anyɔ, Piita mɔ‑rɛ Gyɔn kyu sun gɛnen asa abono asɛ nno. ");
INSERT INTO acd_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Mɛ kpe mɔ, mɛ kpaa dalaa sa mɔmɔ de mɛꞌ nyɛ Wurubuaarɛ Oduduu mɔ ɔꞌ ba mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","I kya nyiile yɛɛ Samariya awura mɔ mɛ nyɛ daa Wurubuaarɛ sagyere mɔ wolɛ Wura Yesu ginyen dɔ. Mɛŋ ti nyɛ de Wurubuaarɛ Oduduu mɔ ɔꞌ baa bun mɔmɔ ɔko‑rɛ ɔko so. ");
INSERT INTO acd_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Piita mɔ‑rɛ Gyɔn mɛ dalaa sa mɔmɔ mɔ, mɛ kyu mɔmɔ-abaa gyanꞌ mɔmɔ so, ne Wurubuaarɛ Oduduu mɔ gi baa bun mɔmɔ so. ");
INSERT INTO acd_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Nfono mɔ, ibono Simon gi wu Piita mɔ‑rɛ Gyɔn, Yesu isɔɔ mɔ, mɛ kya kyu mɔmɔ-abaa gyanꞌ asa so ne Wurubuaarɛ Oduduu mɔ kya baa bun mɔmɔ so mɔ, o kyu aterenbi kyu sa mɔmɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Ne ɔ tɔgɛ sa Piita mɔ‑rɛ Gyɔn yɛɛ, “Fɛꞌ sɔɔ aterenbi adɛ de fɛꞌ kyu gɛnen ɔlon ɔbono fɛ bo faa kyu gbaa me-gibaa de ɔkamaasɛ ɔbono me kee nɛ nyɛ kyu me-abaa gyanꞌ mɔ so mɔ, ɔꞌ nyɛ Wurubuaarɛ Oduduu mɔ ɔꞌ baa bun mɔ so.” ");
INSERT INTO acd_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Simon gi tɔgɛ gɛnen mɔ ne Piita gi tɔgɛ sa mɔ yɛɛ, “Fo‑rɛ fo-aterenbi nnɛ, fo‑rɛ Wurubuaarɛ abaa anyɔ! Aterenbi a maŋ taalɛ sɔɔ ilaa ibono Wurubuaarɛ kya kyu kyɛɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Fo maŋ taalɛ saarɛ aye dɔ de foꞌ wɔra ilaa idɛ ɔnan. I kya nyiile yɛɛ fo-gisen dɔ iŋ boran Wurubuaarɛ ansi so. ");
INSERT INTO acd_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Nu fo-nyoro gɛsɛ de foꞌ kyɛɛgɛ lii ilaa nyɛnyɛn ibono fo dɛ faa dɔ de foꞌ dalaa kolɛ Wurubuaarɛ yɛɛ nengyene i laa sa mɔ, oꞌ kyu fo-nwɔnsa nbono fo dɛ faa kyu kyɛɛ fo. ");
INSERT INTO acd_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","I kya nyiile yɛɛ nɛ wu fo faa ako gɛnyɛ gɛ gyɛ fo gɛlaaloo. Ilaa nyɛnyɛn kee i suu fo gɛgbɛ.” ");
INSERT INTO acd_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Nfono mɔ, Simon mɔ gi kolɛ Piita mɔ‑rɛ Gyɔn yɛɛ, “Fɛꞌ dalaa sa Wurubuaarɛ sa me de gɛnen ilaa ibono fɛ darɛ faa dɔ iko‑rɛ iko iꞌ mɛŋ sa iꞌ ba me so.” ");
INSERT INTO acd_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Piita mɔ‑rɛ Gyɔn mɛ lɛɛ Wura Yesu agyɛbi de mɔ-ilaa ibono mɛ wu de mɔmɔ-ansi mɔ tɔgɛ sa nno asa ta mɔ, mɛ kii kyon kpe Gyɛrusalem. Mɛ kya kpe mɔ, mɛ naa de Samariya awura isowolɛ gikyɔ so mɛ kya tɔgɛ Wurubuaarɛ ɔkalan konkonsɛ mɔ ma‑a sa nno awura kee pɛi ne mɛ kpaa loo Gyɛrusalem. ");
INSERT INTO acd_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Owi ɔko dɔ mɔ, Wurubuaarɛ dɔ ɔsɔɔ ɔko gi baa tɔgɛ sa Filipo yɛɛ, “Koso, de foꞌ kpelegɛ de gɛsɛ so naa de ɔkpa ɔbono ɔ dɛ lii Gyɛrusalem kyu kpe de Gaasa ɔsowolɛ so mɔ. Gɛnen ɔkpa ɔbono ne n kya loo de gipen dɔ lii mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Gɛsintin mɔ, Filipo gi koso yii ɔkpa ɔ kya kpe. Filipo kya kpe mɔ, ɔ baa kerɛ mɔ, Itopiyanyen ɔko ne. Itopiyanyen mɔ gyɛ daa ɔbelɛnsɛ gbaaꞌ, ne ɔ bo abono mɛ kya kerɛ Itopiya wura so mɔ dɔ. Itopiya awura berɛ mɔmɔ-wura gyɛ daa ɔkyii. Ɔnyen mɔ ne n gyɛ ɔbelɛnsɛ ɔbono ɔ kya kerɛ wura kyiisɛ mɔ aterenbi de mɔ-awuratɔ pɛwu so. Gɛnen ɔbelɛnsɛ baarɛ gi kpe Gyɛrusalem kpaa son Wurubuaarɛ. ");
INSERT INTO acd_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Ɔ kya kii mɔ ne Filipo gi kpaa tu mɔ gɛnen. Ɔbelɛnsɛ mɔ tɛ ilaa iko dɔ i naa, mɔ, bee ne n kya biidɛ gɛnen ilaa mɔ. I so Itopiyanyen mɔ i naa gɛnen mɔ, ɔ kya kalɛ ilaa ɔ kya lii ɔwolɛ ɔbono Wurubuaarɛ ikalan ɔtɔgɛbo Isaya gi ŋmarasɛ mɔ dɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nfono mɔ, Wurubuaarɛ Oduduu mɔ gi tɔgɛ sa Filipo yɛɛ, “Naa kpe de foꞌ kpaa naa sindi ɔbelɛnsɛ baarɛ.” ");
INSERT INTO acd_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Gɛsintin mɔ, Filipo gi selɛ kpe ɔbelɛnsɛ mɔ asɛ ɔ naa sindi mɔ. O nu ɔbelɛnsɛ mɔ kya kalɛ ilaa ɔ kya lii ɔwolɛ ɔbono Wurubuaarɛ ikalan ɔtɔgɛbo Isaya gi ŋmarasɛ mɔ dɔ. Filipo gi nu mɔ, ɔ taasɛ ɔbelɛnsɛ mɔ yɛɛ, “Fo kya nu ilaa ibono fo kya kalɛ faa gɛsɛ ne?” ");
INSERT INTO acd_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Ɔbelɛnsɛ mɔ gi lɛɛ gɛnɔ yɛɛ, “Nnɛ ne nan wɔra de nꞌ nu gɛsɛ? Gɛnen mɔ, nɛ nyɛ ɔko gi lɛɛ gɛsɛ sa me.” Nfono mɔ ɔbelɛnsɛ mɔ gi kolɛ Filipo yɛɛ ɔꞌ dii loo baa kyena mɔ asɛ. Gɛsintin mɔ, Filipo gi dii loo kyena mɔ asɛ. ");
INSERT INTO acd_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wurubuaarɛ agyɛbi abono ɔbelɛnsɛ mɔ kya kalɛ gɛnen owi ɔbono dɔ mɔ ne n gyɛ yɛɛ, “Mɛ kparɛ mɔ lii kpaa mɔɔ fɛɛ sandɛ. Mɔ mɔ gi sii kurun fɛɛ gɛsandɛbi ne mɛ keda mɛ laa daasɛ. Oŋ bugi mɔ-gɛnɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Mɛ wɔra mɔ ipeeli. Mɛ mɛŋ gyi mɔ-nbɛlɛ gɛsintin ɔkpa so. Ibono mɛ ten mɔ-agyo faa, ɔko‑rɛ ɔko maŋ baa nyɛ wu mɔ-biana abɛɛ mɔ-naanaana ilaa tɔgɛ.” ");
INSERT INTO acd_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Filipo gi dii ɔ tɛ ɔbelɛnsɛ mɔ asɛ mɔ, ɔbelɛnsɛ mɔ gi taasɛ mɔ yɛɛ, “Anɛ ne Wurubuaarɛ ikalan ɔtɔgɛbo mɔ darɛ faa? Ɔ tɔgɛ kyu lii mɔ gbaa-gbaa mɔ-nyoro so abɛɛ ɔko kpɛi ne ɔ darɛ daa?” ");
INSERT INTO acd_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Ɔ taasɛ Filipo gɛnen mɔ, Filipo gi lɛɛ gɛnɔ yɛɛ Yesu ne ɔ darɛ gɛnen, ne ɔ tɔgɛ Yesu ɔkalan konkonsɛ mɔ sa ɔbelɛnsɛ mɔ. Filipo laa lɛɛ Yesu ɔkalan konkonsɛ mɔ tɔgɛ sa ɔbelɛnsɛ mɔ mɔ, o yii gɛsɛ lii daa Wurubuaarɛ agyɛbi mɔ nfono ɔbelɛnsɛ mɔ kya kalɛ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mɛ kya kpe mɔ, mɛ kpaa tu nkyu nko. Ɔbelɛnsɛ mɔ gi tɔgɛ Filipo yɛɛ, “Kerɛ, nkyu. Menɛ ne n bo no i laa taa tii me-ɔkpa de meŋ sa nꞌ nyɛ sɔɔ Wurubuaarɛ sagyere?”  ");
INSERT INTO acd_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filipo gi tɔgɛ sa ɔbelɛnsɛ mɔ yɛɛ, “Nengyene fo ka gyan Yesu so lii fo-gisen dɔ berɛ mɔ, ɔkpa dɛ fɛɛ foꞌ nyɛ Wurubuaarɛ sagyere.” Nfono mɔ ɔbelɛnsɛ mɔ gi lɛɛ gɛnɔ yɛɛ, “Nɛ ka gyan Yesu Kirisito so yɛɛ mɔ ne n gyɛ Wurubuaarɛ mɔ-bi mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nfono mɔ, ɔbelɛnsɛ mɔ gi yɛgɛ mɛ sii yelɛ ne mɔ‑rɛ Filipo mɛ loo nkyu mɔ dɔ ne Filipo gi gyere mɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Mɛ dii lii nkyu mɔ dɔ mɔ, Wurubuaarɛ Oduduu gi puru Filipo kyon kpe gɛtɛɛko. Ɔbelɛnsɛ mɔ mɛŋ baa wu mɔ. Ɔbelɛnsɛ mɔ gi san keda mɔ-gɛwi ɔkpa de ɔkon fɛɛ ɔ ka gyan Yesu so. ");
INSERT INTO acd_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Wurubuaarɛ Oduduu mɔ gi puru Filipo lii Itopiya ɔbelɛnsɛ mɔ asɛ gɛnen mɔ, Filipo gbaa-gbaa ɔꞌ baa kerɛ mɔ, ɔ ti ɔ yelɛ ɔsowolɛ ɔbono mɛ kya terɛ mɔ yɛɛ Asotusi mɔ so. Nfono mɔ Filipo gi naa de isowolɛ ɔ kya tɔgɛ Wurubuaarɛ agyɛbi mɔ ɔ sa asa gɛnen‑n kaaborɛ ɔ kpaa loo ɔsowolɛ belɛ ɔbono mɛ kya terɛ mɔ yɛɛ Sɛsariya mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Gɛnen owi ɔbono pɛwu mɔ, Sɔɔlo gi luu mɔ-ansi gyanꞌ Wura Yesu akasɛbo mɔ so, ɔ kya laarɛ ɔmɔ-imɔɔten. Gɛnen so mɔ o kpe Gyuda awura asunbi alɛɛbo gɛmu mɔ asɛ kpaa tɔgɛ mɔ ");
INSERT INTO acd_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","yɛɛ ɔ kya laarɛ de oꞌ kpe Damasikosɛ ɔsowolɛ so de oꞌ kpe mɔmɔ Gyuda awura akyangbon dɔ. O kpe ne o wu ɔko kya son Wurubuaarɛ kyu naa de Yesu-lɛɛ ɔkpa mɔ so mɔ, ɔ gyɛ ɔnyen‑o ɔkyii‑o mɔ de ɔꞌ ŋminde mɔ kyu mɔ ba Gyuda awura asunbi alɛɛbo gɛmu mɔ ansi dɔ Gyɛrusalem nno. Imɔso asunbi alɛɛbo gɛmu mɔ ɔꞌ sa mɔ mɔ-gibaa dɔ ɔwolɛ de iꞌ wɔra yɛɛ mɔ ne n sun mɔ. ");
INSERT INTO acd_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Gɛsintin mɔ, Sɔɔlo gi nyɛ ɔwolɛ mɔ, ne o yii ɔkpa. O fuude Damasikosɛ ɔsowolɛ mɔ, ɔ baa kerɛ mɔ, fatela gi lii Wurubuaarɛ dɔ baa kyaabɔɔ mɔ gikolon fɛɛ nyangbon ne n wiisɛɛ. ");
INSERT INTO acd_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Ɔ lii tɔrɔ ne o nu gigyɛbiꞌ giko gi terɛ mɔ nnɔ nnyɔ yɛɛ, “Sɔɔlo, Sɔɔlo.” Ne gigyɛbiꞌ mɔ gi taasɛ mɔ yɛɛ, “Menɛ n wɔra ne fo kya ka me-ansi gɛnen?” ");
INSERT INTO acd_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Sɔɔlo gi lɛɛ gɛnɔ taasɛ yɛɛ, “Me-wura ɔmɔ ne?” Ne gigyɛbiꞌ mɔ gi tɔgɛ mɔ yɛɛ, “Me ne n gyɛ Yesu, ɔbono fo kya ka ansi mɔ. ");
INSERT INTO acd_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Fo berɛ, dabɔlɛ koso de foꞌ naa loo ɔsowolɛ mɔ so. Fo ti loo nno mɔ, mɛ laa tɔgɛ fo ilaa ibono i kaaborɛ foꞌ wɔra mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Anyen abono mɔmɔ‑rɛ Sɔɔlo mɛ kya kpe ɔkpa ɔbono mɔ mɛ sii yelɛ mɛ mɛŋ tɔgɛ ba‑a gigyɛbi. Mɛ nu gigyɛbiꞌ mɔ berɛ, mɛ mɛŋ kii wu ɔko‑rɛ ɔko. ");
INSERT INTO acd_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sɔɔlo gi nyise koso ne o bugi mɔ-ansi mɔ, ɔŋ baa ɔ kya wu sɛi. Imɔso mɛ keda mɔ daa de gibaa kyu loo Damasikosɛ ɔsowolɛ mɔ so. ");
INSERT INTO acd_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Nkɛ nsa pɛwu mɔ, ɔ mɛŋ kya wu. Ɔŋ kya gyi, ne ɔŋ kya nun. ");
INSERT INTO acd_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Gɛnen owi ɔbono dɔ mɔ, Yesu akasɛbo mɔ dɔ ɔko bo Damasikosɛ ɔsowolɛ ɔbono so nno; mɛ kya terɛ mɔ yɛɛ Ananiyasɛ. Wura Yesu gi lɛɛ nyiile Ananiyasɛ baarɛ fɛɛ oderi ne ɔ terɛ mɔ-ginyen so yɛɛ, “Ananiyasɛ.” Yesu gi terɛ mɔ gɛnen mɔ ne o kyule yɛɛ, “Me-wura, me ne.” ");
INSERT INTO acd_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Ananiyasɛ gi kyule mɔ, Wura Yesu gi tɔgɛ sa mɔ yɛɛ, “Koso kpe ɔkpa ɔbono mɛ kya terɛ yɛɛ Ntintin Ɔkpa mɔ dɔ de foꞌ kpe Gyudasɛ gɛten dɔ. Fo loo gikpaara mɔ so mɔ, taasɛ ɔnyen ɔko so, mɛ kya terɛ mɔ yɛɛ Sɔɔlo. Ɔ gyɛ Taasu ɔsowolɛ so isa; ɔ ba ɔ bo nno ɔ kya dalaa. ");
INSERT INTO acd_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Ɔ kya dalaa mɔ, nɛ ti wolaa lɛɛ nyiile mɔ fɛɛ oderi yɛɛ ɔko laa ba mɔ asɛ. Mɛ kya terɛ mɔ yɛɛ Ananiyasɛ. Nɛ tɔgɛ mɔ yɛɛ Ananiyasɛ laa kyu mɔ-abaa kyu gyanꞌ mɔ so de mɔ-ansi mɔ aꞌ bugi sa mɔ de oꞌ kii nyɛ ɔ kya wu.” ");
INSERT INTO acd_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Nfono mɔ Ananiyasɛ gi lɛɛ gɛnɔ yɛɛ, “Me-wura, nɛ ti nu Sɔɔlo baarɛ ilaa lii asa sakyɔ asɛ. Nɛ nu yɛɛ ilaa nyɛnyɛn ibono ɔ dɛ ɔ kya wɔra fo Yesu adɛ abono fo lɔrɔ yela sa fo-nyoro Gyɛrusalem ɔsowolɛ so mɔ i nyaakyɔ. ");
INSERT INTO acd_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Ne ibono ɔ ba gɛrɛ faa, ɔ bo ɔkpa lii Gyuda awura asunbi alɛɛbo abelɛnsɛ mɔ asɛ de ɔꞌ ŋminde nyamesɛ kamaasɛ ɔbono ɔ laa dalaa terɛ fo Yesu ginyen mɔ kyu kpaa tii de obu.” ");
INSERT INTO acd_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Nfono mɔ Wura Yesu gi buu sa Ananiyasɛ yɛɛ, “Fo berɛ, koso kpe mɔ asɛ daa. Nɛ lɛɛ gibaa yii mɔ yɛɛ ɔꞌ tɔgɛ me-ilaa sa gɛsinkpan so asa kpɛi-kpɛi, de awura-awura, de Isirale awura kee. ");
INSERT INTO acd_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Me gbaa-gbaa ne nan nyiile mɔ gɛnɔɔbono ɔkara ɔ laa wu awɔrɔfɔɔ me so mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Nfono mɔ, Ananiyasɛ gi koso lii kpaa loo gɛten gɛbono dɔ Sɔɔlo gi sogɛ mɔ, ne ɔ kpaa kyu mɔ-abaa kyu gyanꞌ Sɔɔlo so ne ɔ tɔgɛ sa mɔ yɛɛ, “Me-nanbo Sɔɔlo, Wura Yesu ɔbono ɔ lɛɛ mɔ-nyoro nyiile fo ɔkpa dɔ gɛkaabono fo kya ba gɛrɛnaa mɔ ne n sun me fo asɛ faa. O sun me yɛɛ nꞌ baa yɛgɛ fo-ansi mɔ aꞌ bugi de foꞌ kii nyɛ wu ilaa de Wurubuaarɛ Oduduu kee ɔꞌ baa suu de fo.” ");
INSERT INTO acd_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Ananiyasɛ gi kpɛ tɔgɛ gɛnen ta mɔ, ayaa abono so mɔ, i wɔra Sɔɔlo fɛɛ ilaa iko ne n kyalɛ lii mɔ-ansi dɔ. Mɔ-ansi mɔ a bugi ne o kii nyɛ ɔ kya wu. Ɔ koso yelɛ ne mɛ gyere mɔ Wurubuaarɛ sagyere. ");
INSERT INTO acd_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Mɛ laarɛ ilaa iko sa mɔ ne o gyi. I baa wɔra ŋmaraa mɔ, ɔ nyɛ ɔlon kon. Idɛ gɛmara mɔ, Sɔɔlo gi sii kyena Yesu akasɛbo mɔ asɛ Damasikosɛ nno nkɛ kalɛsɛ. ");
INSERT INTO acd_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Ayaa abono so mɔ, ɔ san ɔ kya kpe daa Gyuda awura akyangbon dɔ ɔ kya lɛɛ ɔ kya tɔgɛ ɔ sa asa yɛɛ, “Yesu ne n gyɛ Wurubuaarɛ mɔ-bi mɔ.” ");
INSERT INTO acd_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nyamesɛ kamaasɛ ɔbono o nu ilaa ibono Sɔɔlo kya tɔgɛ mɔ, i kya dɛ mɔ-gɛnɔ. Asa mɛ san mɛ kya taasɛ yɛɛ, “Iŋ gyɛ Sɔɔlo ne n kya yɛgɛ ɔlanba kya tɔrɔ Gyɛrusalem asa abono mɛ dɛ Yesu ginyen mɛ kya son Wurubuaarɛ dɔ mɔ? Iŋ gyɛ gɛnen so ne ɔ ba gɛrɛ de ɔꞌ baa keda asa ŋminde kyu kperɛ asunbi alɛɛbo abelɛnsɛ faa?” ");
INSERT INTO acd_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Sɔɔlo, mɔ, kpɛ ɔ kya lɔrɔ ɔ kya tɔgɛ Yesu ilaa ɔ kya too daa. Ɔ keda nyoro ɔ kya lɛɛ ɔ kya tɔgɛ yɛɛ Yesu ne n gyɛ ɔbono ɔ kya mɔlɛgɛ asa de mɛꞌ nyɛ Wurubuaarɛ asɛ gɛkyena mɔ, ne Gyuda awura abono mɛ bo Damasikosɛ nno mɔ gɛnɔ gɛ wuꞌ. ");
INSERT INTO acd_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Sɔɔlo gi kyena nno kɛɛla mɔ, Gyuda awura abono mɛ bo nno mɔ mɛ gyanꞌ ne mɛ da gɛdɛ yela yɛɛ mɛ laa mɔɔ mɔ. ");
INSERT INTO acd_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Mɛ da mɔ gɛdɛ gɛnen mɔ, Sɔɔlo gi bii. Gɛnyɛ de gɛpɛ mɔ, mɛ san mɛ kya dii nbunono nbono gi dɛ lii ɔsowolɛ mɔ dɔ mɔ de mɛꞌ nyɛ mɔ mɔɔ. ");
INSERT INTO acd_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Gɛnyɛ gɛko mɔ Sɔɔlo akasɛbo mɛ kyu mɔ kpe de gɛkpen mɔ mɛ yii wɔra ɔsowolɛ mɔ gɛtɛɛko so. Ne mɛ kyu mɔ kyu wɔra gɛkeebii dɔ ne mɛ kpelegɛrɛ mɔ de ɔfɛ ne ɔ selɛ kyon. ");
INSERT INTO acd_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Sɔɔlo gi naa kyon kpaa loo Gyɛrusalem mɔ, ɔ laarɛ fɛɛ oꞌ kyu mɔ-nyoro kpaa loo Yesu akasɛbo gikpen mɔ dɔ. Ye