﻿USE sofia;
DROP TABLE IF EXISTS sofia.aca_vpl;
CREATE TABLE aca_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES aca_vpl WRITE;
INSERT INTO aca_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Liáni áabai lista nashínaa náa'a Jesucristo wérrinaimica, rey David cúuleemi ya Abrahám. ");
INSERT INTO aca_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abrahámcala Isaac sálijinaa, Isaac Jacob sálijinaa, Jacob Judá sálijinaa ya náa'a libécanata náajcha náa'a líshiibimica. ");
INSERT INTO aca_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Judá Fares ya Zérah sálijinaa, natúwa nárra Tamarca. Fares Esrom sálijinaa, Esrom Arám sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arám Aminadab sálijinaa, Aminadab Nahasón sálijinaa ya Nahasón Salmón sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmón Booz sálijinaa, rucúulee ruá'a Rahab; Booz Obed sálijinaa, rucúulee ruá'a Rut. Obed Isaí sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Isaí rey David sálijinaa. Rey David Salomón sálijinaa, ne ruá'a Salomón túwaca ruyáwa líinumi liá'a Uríasca. ");
INSERT INTO aca_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Salomón Roboam sálijinaa, Roboam Abías sálijinaa, ya Abías Ása sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ása Josafat sálijinaa ya Josafat Joram sálijinaa ya Joram Uzías wérrimi. ");
INSERT INTO aca_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzías Jotam sálijinaa náimi, Jotam Acaz sálijinaa ya Acaz Ezequías sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Ezequías Manasés sálijinaa, Manasés Amón sálijinaa ya Amón Josías sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josías Jeconías sálijinaa ya náa'a léenajinaibimi, liyáali éerrimi natée'inaami israelítabini preso Babiloniala. ");
INSERT INTO aca_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Liáwinaami liá'a presocaica, Jeconías Salatiel sálijinaa ya Salatiel Zorobabel sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zorobabel Abihud sálijinaa, Abihud Eliaquim sálijinaa ya Eliaquim Azor sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor Sadoc sálijinaa, Sadoc Aquín sálijinaa ya Aquín Eliud sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliud Eleazar sálijinaa, Eleazar Matán sálijinaa ya Matán Jacob sálijinaa. ");
INSERT INTO aca_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jacob José sálijinaa, liá'a Joséca rúnirrimi ruá'a Maríaca, ya ruyá litúwa liá'a Jesúsca, liá'a wáni jí'inaa Mesíasca. Ne jócani yáa náajcha wáacoo újnibii. ");
INSERT INTO aca_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Néenee wacába catorce generaciones Abrahám néenee, cáashia líinu David néerra; David néenee áabata catorce generaciones, natée'inaami israelítabini preso Babiloniala, ya áabata catorce néenee presoquictami náa'a israelítabinica cáashia lijiácoo liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Quéechanacu'inaa Jesucristo jiácoo cháji'i: Ruá'a María litúwaca comprométechoo rucásacoo liájcha liá'a Joséca. Libéecha'inaa nayá náajcha wáacoo, náa léenaa quéenibi ruyá Espíritu Santo dánaniyu. ");
INSERT INTO aca_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Litáaniaca'ee ruájcha, liá'a José washiálicuerri sáicaica, jócai liwówa chóniwenai yáa léenaa ruíiwanaa, jáiwa'ee liwówai limáaca ruyái cabáyainta. ");
INSERT INTO aca_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Néenee nácula lipénsaa linácu liáni, báqueerri ángel Dios shínaa íyadau lirrú dajuíshi rícueji, limá lirrú: “José, rey David táqueerrimi, ucáarru jitée María újni jíinucaa, léecaa liárra yéerri ruáwi rícu ruwáaliani Espíritu Santoyu. ");
INSERT INTO aca_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","María rucúulicuminaa rucúuleujoo, jiáminaa lijí'inaa Jesúsjoo, liyáca wásedeerri'inaa lishínaa chóniwenai najíconaa yúchau.” ");
INSERT INTO aca_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Quinínama liáni bésuneerriu quéewique'e licúmpliacoo, liá'a Wawácali máyu'umica linúma licuéji liá'a íiwadedeerri Dios chuáni báinacumi, limá'inaa: ");
INSERT INTO aca_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Báquetoo miyácau jócau cúnusia máachu, quéenibiminaa rumáacacoo ya ruwáalia báqueerri rucúuleu, náani'inaa jí'inaa Emanuel” (liwówau'u limáca: “Dios wáajcha”). ");
INSERT INTO aca_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Néenee licáwia'inau liá'a Joséca, liméda léjta Dios shínaa ángel máyu'u lirrú, lirríshibia María líinuyu. ");
INSERT INTO aca_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ne jócau limáa yáajcha, cáashia rucúlicu liá'a rucúuleecoo quéechanacu sáica, liá'a José yáni jí'inaa JESÚS. ");
INSERT INTO aca_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Jesús jiá'inau lirrícu liá'a Belénca, yéerri áabai cáinabi íta'aa jí'ineerri Judea, liyáali éerri Herodes máanuica jái reycai. Néenee náiinu Jerusalén néerra áabi chóniwenai cawíteeni mawí, íinuenai cáiwia jiáctejcoo, nashínaa tráawajo éewidenaiu sáalii nácu ");
INSERT INTO aca_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Nasáta'ee néemiu: “¿Tanácucha liyá léji liá'a jiéirricoo judíobinica shínaa rey'inaaca? Níwata wacábacaala sáalii jiácoo, wayá éebidenai wacába lijiácalawai, tánda wáiinu wáa lirrú sáicai.” ");
INSERT INTO aca_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Liá'a rey Herodes éemi'inaa liáni, néenee urrúni liwówa léemicani, chacábacanaa nabésunacoo quinínama náa'a chóniwenaica yéenai Jerusalén rícu. ");
INSERT INTO aca_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Néenee rey wána namáida nayá quinínama náa'a sacerdote wácanaica, ya náa'a éewidenaica ley shínaaca, ya lisáta léemiu nayá táshia nácucha'inaa lijiáu jiliá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Néenee namá lirrú: “Liyá jiéirri'inau Belénca rícu, Judea cáinaberra íta'aa, chácate litánaca liá'a íiwadedeerri Dios chuáni báinacumi limá'inaa: ");
INSERT INTO aca_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","Ne jiyá chacáalee Belén, liá'a cáinabi Judea shínaa, áawita píituirri jiyá, máanuiminaa jíiwana médacojoo náiibicha náa'a chacáalee máanui namánica líta'aa liáni cáinabica; jiníwata jíibichaminaa lijiáu báqueerri wánacaleerri bánuerri'inaa nanácu náa'a nushínaa chóniwenai náa'a israelítabinica.” ");
INSERT INTO aca_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Néenee Herodes máida nayá cabáyainta náa'a cawíteeni mawí déecucha sána, jáiwa liá léenaa narrícueji liá'a éerri sáica nacába'inaami rujiáctamicoo ruá'a sáalii. ");
INSERT INTO aca_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Néenee libánua nayá Belénra ya limá nalí: “Yáau néerra isátada éemiu sáica linácu liárra samálitaca; jáicta íinu linácujoo, íiwa nulíjoni, quéewique'e nuáacoo nuá lirrú sáicai lécchoojoo.” ");
INSERT INTO aca_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Néenee nanísa'inaa néemi limáyu'u liá'a reyca, jáiwa náawai Belénra. Quéecha'inaami néejoocoo nacába ruá'a sáaliica, sáicta wéerri nawówa, níwata rujínacalau ruácoo nabéecha, cáashia líinu quirrácua yáctalaca, jáiwa rubárruawai liwícau. ");
INSERT INTO aca_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Néenee nawárruawai cuíta lícula, jáiwa nacába liá'a quirrácuaca María yáajcha, ruá'a litúwaca; néenee natúyau lirrúi náaque'e lirrú sáicai. Jáiwa naméecu nashínaa cajón natéeni náacoo, jáiwa náa lirrúi oro, ya áabai sáictai juménibee jí'ineerri incienso, ya áabata juménibee jí'ineerri mirra. ");
INSERT INTO aca_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Liáwinaami Dios íiwa nalí dajuíshi rícueji jócubeecha néejoo Herodes néenee, níwata Dios yáirri léenaa Herodes wówai líinua liá'a quirrácuaca; néenee néejoowai nashínaa cáinabi ítalau áabai iníjbaa rícu. ");
INSERT INTO aca_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Quéecha'inaa náacuwai náa'a yáine léenaa, néenee José cába báqueerri ángel Dios shínaa dajuíshi rícueji, ángel ma lirrú: “Jibárroo jiwína liárra samálitaca litúwa yáajchau, jicánacau Egipto shínaa cáinabi ítala, jimáacau néerrajoo cáashia nuíiwa jirrúni, níwata Herodes wówairri libánua namúrru liárra samálitaca náiinuaque'ini.” ");
INSERT INTO aca_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Néenee licáwiacuwai libárruawai liá'a Joséca, liwína liá'a samálitaca litúwa yáajchau táayee lijiáu Egipto néerra, ");
INSERT INTO aca_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Namáacau néerrai cáashia máanali liá'a Heródesca. Cháwa lijiácuwai léjta limáyumi liá'a wawácalica linúma licuéji liá'a íiwadedeerri Dios chuáni báinacumi, limá'inaa: “Numáidaminaajoo nucúuleu Egiptoeji.” ");
INSERT INTO aca_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Ne Herodes yá'inaa léenaa nachálujueda liyá náa'a yáine léenaa, néenee íiwirri wérri liwówa, liwána náiinua quinínama náa'a sáamanai máachuca wáalienai chámai camuí cáinacula yéenai Belén rícu, ya quinínama narrícu náa'a chacáaleeca yéenai Belén téeji. Liwána náiinua nayá léjta éerrimi náiiwa'inaa lirrúni náa'a yáine léenaa. ");
INSERT INTO aca_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Cha licúmpliacuwai liá'a limánimica liá'a íiwadedeerri Dios chuáni báinacumi jí'ineerri Jeremías, limá'inaa: ");
INSERT INTO aca_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","Néemi'e áabau wítama líta'aa liá'a Ramá néeni, íchenai wérri cáiwinaa, ruyáwoo Raquelbinica íchanenai nanácueji náa'a natáqueenai'inaaca, jócau índa sáicta naméda ruwówa, níwatajani máanalicai. ");
INSERT INTO aca_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Liáwinaami máanali'inaami Herodes, néenee báqueerri ángel Dios shínaa, íyadau Josérru dajuíshi rícueji chalé'e Egiptola. ");
INSERT INTO aca_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Limá lirrú: “Jibárroo, jiwína liárra samálitaca litúwa yáajchau, jéejoo jiácoo Israel shínaa cáinabi ítala, máanalica náa'a wówainaimi náiinua liárra samálitaca.” ");
INSERT INTO aca_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Néenee libárruawai liá'a Joséca, liwína liá'a samálitaca litúwa yáajchau, léejoo Israel shínaa cáinabi ítala. ");
INSERT INTO aca_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ne liá'inaa léenaa Arquelao wánacaala Judea néeni, liáarrumirra liá'a Heródesca lisálijinaa, néenee cáarru liácoo néerrai liá'a Joséca. Quéecha'inaa Dios íiwa lirrú dajuíshi rícueji, néenee liáu lirrícula liá'a cáinabica jí'ineerri Galilea. ");
INSERT INTO aca_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ne líinu'inaa néerrai, néenee liáu liyá áabai chacáalee rícu jí'ineerri Nazaret. Cha licúmpliacuwai liá'a namánimica náa'a íiwadedeenai Dios chuáni báinacumi, namá'inaa náaque'e lijí'inaa Nazaret néeni sái. ");
INSERT INTO aca_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Íchaba camuí liáwinaami líyadau liá'a Juan Bautístaca á'a cáinabi Judea shínaa wáunamactalaca; néerra chóniwenai yáau néemi lirrú. ");
INSERT INTO aca_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Lichuáni rícuejiu limá'ee: “¡Éejoo Diosru, jiníwata liá'a Dios wánacaalactalaca urrúniyii!” ");
INSERT INTO aca_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Léewa Juanja liérra Dios máni jinácucha lirrú liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Isaíasca: “Báqueerri chóniwerri máidada á'a wáunamactalaca: ‘Ichúni iyáu libéecha quéewique'e irríshibia wawácali jáicta líinui’,” Léjta nachúni iníjbaa libéecha liá'a chóniwerri cawéni íinuerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Juan íibala yáairri caméeyu íchunayu, libájini líwali rícu áabai íimanaayu; ya líiya langosta, újni irríchu máanuica ya máaba yáamitu. ");
INSERT INTO aca_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Náa'a chóniwenai Jerusalén néeni sánaca, ya íchaba wérri náa'a yéenai Judea téeji, ya náa'a yáanai urrúni méeda jí'ineerri Jordán najiáu néemicani. ");
INSERT INTO aca_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Náiiwanaa najíconau chóniwenai náneewa Diosru ya Juan báutiseerri nayá á'a méeda jí'ineerri Jordán. ");
INSERT INTO aca_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ne Juan cába'inaa íchaba náa'a fariséobinica ya saduceobinica, náiinu liyáctala quéewique'e Juan báutisa nayá, limá nalí: “¡Áai cawálai táqueenaimi! ¿Tána ma irrúi iwásedacaala'inau liúcha liá'a carrúnatabeeca máanui wérrica urrúniyaca? ");
INSERT INTO aca_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Imédau sáica, chacábacanaa quéewique'e nacábacani icúcani éejuacoo Diosru, ");
INSERT INTO aca_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ya jócu imá irrúwoo iyá jájiu: ‘Jócu cáarru wacába liá'a Dios shínaa carrúnatabeeca, níwata wayá Abrahám táqueenaimi’; Dios éewerri liá irrú carrúnatabee, liyácta rúnaa Abrahám táqueenaimi, liyá éewerri liquénuda nayá matuínaami íibicha áawita íiba íibicha. ");
INSERT INTO aca_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Léjta báqueerri washiálicuerri liwínacta lishínaa chúushiu, liwíchuaque'e áabai áicuba yáirri lítau, ya liúca chichái rículani jócta liá lítau sáica, chacábacanaa Dios yáairri urrúni quéewique'e liá lirrú carrúnatabee liá'a jócai chúni liwíteu. ");
INSERT INTO aca_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Nuyá, yáawaiyi, nubáutisa shiátaiyu quéewique'e numáida iyá éejuacoo Diosru; ne liá'a íinuerri'inaa nuíshiirricu, yáirri'inaaminaa irrú Espíritu Santo, quéewique'e icámbia iwítee yáayu'u yáminaa liá'a nalí carrúnatabee náa'a jócani éebida infierno shínaa chicháiyu. Liyá mawí cadánani núcha, jiní báawita nutéeyu'inaa lishínaa cotiza. ");
INSERT INTO aca_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Liá'a wawácalica léjta washiálicuerri cáabanacai téerri licáaji ricúu lipálaniu, quéewique'e lisárraa lishínaa trigo, ya licháquidaque'e máashiibee yúcha. Liwáaliaminaa lishínaa trigoca liáarrui rículau, ne léemaminaa liá'a máashiibee chichái ricúla jócai chácacajiu. Chacábacanaa Dios shírri náa'a chóniwenai machácanini wítee ya táminaa léema'inaa náa'a chóniwenai jócani éebida áabai chichái ricúla jócai chácacajiu.” ");
INSERT INTO aca_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Jesús yáau Galilea néenee méedala jí'ineerri Jordán, Juan yáctalaca, quéewique'e Juan báutisacani. ");
INSERT INTO aca_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Quéechanacu Juan jócai wówai libáutisacani, limá lirrú: —Nuyá jócai sáicanata báutisa jiyá, jiyáwata arrúnai'inaata báutisa nuyá. ");
INSERT INTO aca_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Jesús éeba'ee: —Jimáaca cha nírra íchaitaa, ne jiníwata arrúnaa wacúmplia quinínama liá'a sáicaica Dios náneewa. Néenee Juan áabenama liyá. ");
INSERT INTO aca_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ne liyáalimi Jesús báutisa'inau, lijiáu shiátai yáacucha, jáiwa éerri méecu lirrúi, licába'ee liá'a Espíritu Dios shínaaca, yúrrucoo linácula jicá'a áabai paloma. ");
INSERT INTO aca_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Néenee léemi'e áabai chuánshi áacaiji, máirri'e: “Léwa nucúulee caníinai nucábaca, sáicta nuwówa liájcha.” ");
INSERT INTO aca_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Liáwinaami libáutisa'inaa liá'a Jesúsca, Espíritu Santo litée liyá wáunamactala jiníctala yáairri, quéewique'e Wawásimi énedacani. ");
INSERT INTO aca_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Cuarenta éerri Jesús jócai íya, ya cuarenta táayebee, liáwinaami sáamu liwówai. ");
INSERT INTO aca_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wawásimi rúniu lirrú lénedaque'e liyá, limá lirrú: —Yáawaicta Dios Cúulee jiyá, jiwánate nanáawacoo náani íibaca íyacaishiyu. ");
INSERT INTO aca_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Néenee Jesús éeba'ee: —Jóca'inaa numéda. Liá'a tánerricoo máirri: ‘Jócai bácai íyacaishiyu cáwi liá'a washiálicuerri, cáwica liyá lécchoo liyú liá'a Dios chuáni jiéirricoo linúma licuéji.’ ");
INSERT INTO aca_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Liáwinaami, Wawásimi tée liájcha Jesús lirrícula liá'a chacáalee majíconaa jí'ineerri Jerusalén, libárruedani templo máanui númacua íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Limá'ee lirrú: —Yáawaicta Dios Cúulee jiyá, jicáteu cáinacula, jái tánacuwai, ‘Dios bánuaminaa lishínaa ángelbini jinácu'inaa, nawínaque'e jiyá nacáaji rícuu, jócubeecha jíinua jíibau íiba nácula.’ ");
INSERT INTO aca_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Néenee Jesús ma lirrú: —Jócai'inaa numéda. Jái tánacuwai lécchu, ‘Ujiméda carrúnatai quéewique'e jéneda wawácali litúyaque'e jiyá.’ ");
INSERT INTO aca_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Néenee Wawásimi tée liyá báaniwai áabai dúuli áacai wérri ítala, líyada lirrú quinínama chacáalee cáinabi íta sána, sáictani wérri cawéninamani. ");
INSERT INTO aca_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Limá lirrú: —Nuá jirrú quinínama léju liéni, jitúyactau jitájeda jinániu nulí jiá nulí sáicai jiwówa yáajchau. ");
INSERT INTO aca_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Néenee Jesús éeba'ee lirrú: —Jócai'inaa numéda. Jidánau núcha, Wawásimi, jái tánacuwai: ‘Jiméda lirrú sáicai jiwówa yáajchau liá'a jiwácali Diosca, jishírrueda lirrú bácai.’ ");
INSERT INTO aca_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Néenee Wawásimi shírriu Jesús yúcha, jáiwa ángelbini íinuenai nashírrueda lirrú. ");
INSERT INTO aca_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Néenee Jesús éemi'inaa naníqui Juan cuíta manúmai rícula, léejoo Galilea cáinaberra ítala. ");
INSERT INTO aca_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ne jócu limáacau Nazaret á'a liyáctamica, jócta liáu liyáca Capernaúm chacáalee rícula, litácoowa liá'a manuá jí'ineerri Galilea, nayácta náa'a tribu Zabulón shínaa ya Neftalí. ");
INSERT INTO aca_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Liáni bésuneerriu quéewique'e licúmpliacoo liá'a litánani liá'a íiwadedeerri Dios chuáni báinacu, jí'ineerri Isaíasca: ");
INSERT INTO aca_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Cáinabi lishínaa liá'a Zabulón ya Neftalí, bajiála Jordán, manuá tácoowa: Galilea nayácta náa'a jócani éebida.” ");
INSERT INTO aca_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Náa'a chóniwenai jínanenai'inaacoo catáwacabee jirrícu, nacábaminaa áabai jucámarrabee máanui; áabai jucámarrabee úcuni nalí náa'a yáainaimi catáwacabee jirrícu máanalinimica. ");
INSERT INTO aca_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Néenee liyáali Jesús lichánau líiwadeda nalí: “Éejoo Diosru, jiníwata Dios wánacaalactalaca jái urrúnicai.” ");
INSERT INTO aca_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesús jínaneerriu litácoowa liá'a manuá jí'ineerri Galilea, jáiwa licábai chámata washiálicuenai néenajinai wáacoo: báqueerri liá'a Simónca, Jesús yáni'inaa jí'inaa Pé'eru, ya liá'a báqueerrica Andrés. Náani catésucani, yúquenai nayá nashínaa máayau manuá yácula. ");
INSERT INTO aca_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Jesús má'ee nalí: —Yáau nuájcha, numédaminaa iyá cáindacani'inaa chóniwenai Diosru. ");
INSERT INTO aca_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Liyáalimi namáaca nashínau máayamiu, jáiwa náau liájchai. ");
INSERT INTO aca_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Mawí nabéechala, Jesús cába áabibi chámata washiálicuenai néenajinai wáacoo: Santiago ya Juan, léenibi liá'a Zebedeoca, yéenai nasálijinaa yáajchau áabai bónco rícu, chúneenai nayá namáayaniu. Jáiwa Jesús máida nalí. ");
INSERT INTO aca_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Liyáalimi namáaca nashínaa bónco ya nasálijinaami, jáiwa náau liájchai liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesús lijínaniu quinínama Galilea shínaa cáinabi, léewida limácoo narrícu náa'a sinagogaca. Líiwadeda linácu liá'a sáicai chuánshica linácu liá'a Dios wánacaalactalaca, ya lichúni chóniwenai quinínama bálinacaalashi ya cáiwibee. ");
INSERT INTO aca_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Natáania Jesús nácu quinínama náa'a yéenai Siria shínaa cáinabi íta'aa, naínda lirrú quinínama náa'a bálinenaicoo méenaami bálinacaalashi ya cáiwibee, ya náa'a wáalenai espíritu máashii, ya náa'a cúcunenaicoo, ya náa'a macáwanica. Yá'ee Jesús chúni nayá, ");
INSERT INTO aca_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","íchaba chóniwenai yáau Jesús yáctalaca, náa'a Galilea sánaca, ya náa'a chacáalee Decápolis sánaca, náa'a Jerusalén néenee sánaca, náa'a Judea néenee sánaca, ya náa'a yáine Jordán cáinaberra ítacha cáiwia jiáctejcoo, najínani'eewoo Jesús íshiirricu. ");
INSERT INTO aca_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Licába'inaa íchaba wérri chóniwenai, Jesús íirrau liwáacoo dúuli lítala quéewique'e léewidaca. Náa'a éewidenaicoo liájcha náiinu liyáctalaca, ");
INSERT INTO aca_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","jáiwa lichánau léewida nayái, limá'ee: ");
INSERT INTO aca_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Sáicta wérri nawówa náa'a yáine léenaa narrúnijinaa cáwicaishi Dios shínaa, jiníwata nashínaa'inaa liá'a sáicaica Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Sáicta wérri nawówa náa'a máashiini wówa, jiníwata Dios yáirri'inaa nalí sáictaque'e nawówa. ");
INSERT INTO aca_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Sáicta wérri nawówa náa'a imíyanica, jiníwata Dios yáirri'inaa nalí liá'a cáinabi limánimi líshiirrini'inaa nalí. ");
INSERT INTO aca_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Sáicta wérri nawówa náa'a wáalianai ínaaishi ya náa'a iméeni wówa namédaque'e léjta Dios wánacaalau'u, jiníwata liyáminaa liwána licúmpliacoo léjta nawówau'i. ");
INSERT INTO aca_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Sáicta wérri nawówa náa'a carrúni jináatani cába áabi, jiníwata Dios carrúni jináataminaa licába nayá. ");
INSERT INTO aca_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Sáicta wérri nawówa náa'a masáculani wówa, jiníwata áabai éerri nayáminaa Dios yáctalaca ya nacábaminaa liyá. ");
INSERT INTO aca_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Sáicta wérri nawówa náa'a múrruenai sáictaque'e nawówa, jiníwata Dios yáa nají'inaa nayá léenibiyu. ");
INSERT INTO aca_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Sáicta wérri nawówa náa'a nacánaquedanica namédacala liá'a Dios bánua namédaca, jiníwata nashínaa'inaa liá'a Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Sáicta wérri iwówa, jáicta chóniwenai báulidacta iyá ya nacáitadeda iyá, ya nunácue jíni nawína iyá quinínama númashi yúwicayu. ");
INSERT INTO aca_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Jáicta libésunau léju liáni, sáicta iwówa, cachúnica iwówa, jiníwata irríshibiacaala'inaa áabai iwéniu máanui áacairra; chái lécchoo nacánacaida náa'a íiwadedenai Dios chuáni báinacu yáainaimi ibéecha. ");
INSERT INTO aca_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Iyáwa chánii cábacanaa jicá'a iwíduma cáinabi shínaa. Ne ya limáacacta lijúwacau, ¿chítashia léewa liwína lijúwacau jíni? Jái jócu sírbia mawiá, náucaminaani bináawala ya chóniwenai báawedani. ");
INSERT INTO aca_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Iyáwa chánii cábacanaa jicá'a jucámarrabee cáinabi shínaa. Léjta jucámarrabee chacáalee shínaa yáairrictani dúuli íta'aa, jócai éewa libáyacoo, chacábacanaa náa'a chóniwenai néewa nacába quinínama iyá imédanica. ");
INSERT INTO aca_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Jócu watúculia áabai lámpara waníquique'e áabai cajón rícuni; mawí sáicaca, wamáacacani áacai íta'aa liquénaque'e quinínama yáanai cuíta rícu. ");
INSERT INTO aca_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Chacábacanaa, imédau machácani, quéewique'e quinínama náa'a chóniwenai néewa nacába liá'a sáicai imédani iyá, ya quinínama náa sáicai lirrú liá'a isálijinaaca yéeirri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Iyá u'éebida nuíinucala numárda liá'a leyca o liá'a néewidani náa'a cáiiwadedacani Dios chuáni báinacu; nuyá jócai íinu nuá linúmami, nuyá íinuerri nuá lirrú yáawaiyi licábacanaaca. ");
INSERT INTO aca_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Ne yáawaiyi numá irrú, nácula liyája liá'a éerrica ya cáinabi, jiníminaa nuédani liúcha liá'a leyca, báawita áabai púnto'inaa báawita áabai letra, cáashia libésunacoo quinínama liá'a arrúnaa libésunacoo. ");
INSERT INTO aca_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Tándawa, liá'a jócai éewida néenaa náa'a ley shínaaca, báawita píituicani, jiní léewidacala náa'a chóniwenaica éewidacani, nacábadedacani'inaa jiní wéni liúcha liá'a wánacaleerri Dios shínaa. Ne liá'a éewiderrica ya léewida lécchoo áabi méda léjta liyá, mawí'inaa cawéni wérri chaléeni Dios liwánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Tánda numá irrú, iyá jócta iméda mawí sáica Dios náneewa, náucha náa'a quéewidacani ley shínaaca ya náa'a fariséobinica, jiní wérri wárroo áacairra Dios yáctalaca. ");
INSERT INTO aca_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Iyá jái éemicai namá nalí náa'a wawérrinaimica: ‘Ujíinua, ne liá'a íinuerrica yúquerri'inau carrúnatai rícula.’ ");
INSERT INTO aca_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ne nuyá ma irrú, tánashia íiwirri wówa léenajirri yáajchau, yúquerri'inau. Tánashia cáitadedeerri léenajirriu, nacábadedani yáawacta cajíconaajani náa'a nawácanaica; tánashia cáiteerri cáiwinaa wérri léenajirriu, arrúnai'inaa chichái infierno shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","“Chái jitécta jishínaa ofrendau Dios íibana rícula, jédacanictau áicta jéenajirri wáaliani jiájchau jináculaja, ");
INSERT INTO aca_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","jimáaca jishínaa ofrendau néenijaa, arrúni lirrú liá'a néemacta ofrenda, ya jiáu jéenajirri néerrau jichúni jishínaa wíteshiu quéecha. Ta jéewa jéejocoo jitée jishínaa ofrendau Diosru, néemactala'inaacani. ");
INSERT INTO aca_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Ya áicta yáirri jijíconaaja ya liwówai jiyá máashictala néerra, jénedau jimédacoo áabenaa liájcha nácula jócu libésunajau, jócubeecha léejueda jiyá juezru; táda jóctacala, liá'a juez yúquerri'inaa jiyá ya léentregaa jiyá nalí náa'a catúyacanica ya naníqui jiyá cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Numá jirrú yáawaa, jócala jijiáu chéni jóctacala jipáida quinínamani liá'a jimówinianica. ");
INSERT INTO aca_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Iyá éemini quéecha namáyu'u: ‘Ujiméda jirrúwoo liá'a máashii jíinayu.’ ");
INSERT INTO aca_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ne nuyá ma irrú, tánashia liá'a cáberri báquetoo íinetoo liméda rúnainaa, jáiyi méda máashii ruájchai liwówa licuéjiwai. ");
INSERT INTO aca_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","“Chacábacanaa, jituícta sáicaquictejica liwána jicáacoo jíconaashi rícula, ujiméda máashii, jicábau újnii jijédacchu jituíu ya jiúca jiúchau déecuchalani; mawí sáicaca jipérdia áabai jitánai sái, ne jócaita quinínama jináananaica liúcacoo infierno rícula. ");
INSERT INTO aca_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Jicáaji sáicaquictejica wánacta jicáacoo jíconaashi rícula, ujiméda máashii, jicába újni jiwíchuacchu jicáajiu ya jiúca jiúchau déecuchalani; mawí sáicaca jipérdia áabai jitánai sái, ne jócaicta quinínama jináananaica liúcacoo infierno rícula. ");
INSERT INTO aca_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Cha lécchoo Moisés litána quéechanacumi: ‘Tánashia máaquerri líinuu, arrúnaa liá rulí áabai cáashta limáctaca shírrida yáaqueneu.’ ");
INSERT INTO aca_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ne nuyá ma irrú, báqueerri washiálicuerri máacacta líinuu, ne jócta ruméda ruíinayu máashii, limáacani carrúnata ruméda máashii ruíinayu, ya liá'a cásairricoo ruájcha ruá'a namáacanimi, liméda máashii líinaayu lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Iyá éemenai lécchoo liá'a Moisés tánani nalí náa'a iwérrinaibimica: ‘U'imíya máecha iméda liá'a imánimi iméda iwácalirru juraméntoyu.’ ");
INSERT INTO aca_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ne nuyá ma irrú: ‘U'ijúrau mawiá. U'ijúra linácu liá'a éerri áacairra sáica, jiníwata liyáwa Dios yáctalaca.’ ");
INSERT INTO aca_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Jiní liá'a cáinabica, níwata Dios wánacaalacta líta'aa lécchoo; báawita Jerusalén nácu, níwata liá'a chacáaleeca lishínaa liá'a Dios máanui wérri reyca. ");
INSERT INTO aca_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Jiní ijúracalau inácu iyá jájiu, jiníwata jócta éewa iméda cabálai ya cachájulai báawita bácua iwíta báinau. ");
INSERT INTO aca_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Imácta iyá ‘jajá’, jajá'inaa; imácta iyá ‘jócai’, jócai'inaa, ne liá'a shírrerriu liúcha liáni, máashiiyii. ");
INSERT INTO aca_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Iyá éemini namáyu'u quéecha: ‘tuíshiyu'inaa ya éeshiyu'inaa.’ ");
INSERT INTO aca_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ne nuyá ma irrú: Ujiméda lirrú máashii liá'a méderri máashii; mawí sáictaca, jáicta báseerri jináni sáicaquicteji já'a, jináawida lirrú béema. ");
INSERT INTO aca_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ya áicta yáirri jijíconaaja ya wówerri léda jicámisani já'a, jínda litée lécchoo liá'a jishínaa cápaca. ");
INSERT INTO aca_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ne báqueerri wánacaleerri liwánacta jitée jiánairrau áabai déecuchala, jitée chámaichu lidécuchaca. ");
INSERT INTO aca_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Jáicta báqueerri sáteerri áabai rúni jináshi já'a, yáa lirrúni; ya áicta báqueerri sátani préstau jiúchaja, jiprésta lirrúni. ");
INSERT INTO aca_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Iyá éemenai lécchoo namá irrú: ‘Caníinaa icába náa'a ijúninaica ya cadéni icába náa'a ijínaica.’ ");
INSERT INTO aca_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ne nuyá ma irrú: Arrúnaa caníinaa icába ijínaiu lécchoo, ya i'óra nanácu náa'a cánaquedeenai iyá. ");
INSERT INTO aca_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Iméda liáni, cháminaa léenibi iyá liá'a Dios isálijinaa yéerri áacairra; ya liyá wáneerri cáiwia jiácoo nanácu náa'a sáicanica ya máashiinica, libánua únia sáicani nácu ya máashiini nácu. ");
INSERT INTO aca_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Jiníwata caníinacta jicába náa'a caníinaani icába iyá, ¿tána iwéni irríshibia? Báawita náa'a cóbrenai impuesto Romarru cháni médacajau, ya iyá pénsenai máashiica wérri nayá. ");
INSERT INTO aca_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ne itácta nalí rímija náa'a éenajinaica, ¿tána iméda mawí sáicacai? Báawita náa'a jócani éewida médenaiu chá'a. ");
INSERT INTO aca_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Iyáyu machácani, ya caníinaa icába lécchoo náa'a cadénini cába iyá, chaléjta isálijinaa yéerri áacairra machácani. ");
INSERT INTO aca_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ujéneda linácu liá'a jiwíteecoo, quéewique'e chóniwenai cába iyá sáicai. Jimédacta cháni, isálijinaa liá'a yéerri áacairra, jiníminaa iwéni liéni'inaa irrú. ");
INSERT INTO aca_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Tándawa jiyúdacta náa'a carrúni jináatanica, ujíiwadeda matuínaamini, chaléjta namédani náa'a chámai wítee sinagoga rícu, ya namédani bináawala chóniwenai natáaniaque'e nanácui sáica. Yáawaiyi numá irrú, linácu jiliéni jái nísa nawáalia nawéniwai, Dios jócai liá nalí nawéni mawí. ");
INSERT INTO aca_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Ne jiyúdacta náa'a rúnenaicani, ujíiwadedani báawita jijúnicairru wáni; ");
INSERT INTO aca_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","jimédaca cabáyaintani. Ya Jisálijinaa licábani jimédani cabáyainta, liáminaa jirrú jiwéni. ");
INSERT INTO aca_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Jáicta i'órawai, uchá iyá léjta náa'a chámaini wítee, ísenai nabárruacoo na'óraca sinagoga rícu ya plaza táiba, quéewique'e chóniwenai cába nayá. Yáawaiyi numá irrú, linácu jiliéni jái nísa nawáalia nawéniwai. ");
INSERT INTO aca_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Jiyá jáicta ji'óra, jiwárroo jíibana licúlau, jibáya cuíta núma ya ji'óra jisálijinau yáairri bácai jiájcha, ya jisálijinaa licábani jimédani cabáyainta, liáminaa jirrú jiwéni. ");
INSERT INTO aca_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Jáicta ji'óra ujéneda chuánshi jócai sírbia, chaléjta namédani náa'a jócani éebida, namá nalíwoo, ne mawícta'ee natáaniaca, mawíminaa'ee Dios méda nalí nawánacaala. ");
INSERT INTO aca_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Uchá cábacanaa iyá léjta nayá, jiníwata isálijinaa jái yáa léenaa liá'a jirrúnaanica, libéecha isáta liúchani. ");
INSERT INTO aca_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Ne iyá éewenai i'óra chá'a: ‘Wasálijinaa yáairri áacairra, chóniwenai cawáunta nacába jijí'inaa. ");
INSERT INTO aca_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Jíinu chérra jiwánacaala áani, jiméda jiwánacaalau áani cáinabi íta'aa, chaléjta jimédau'inaa áacairra. ");
INSERT INTO aca_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Jiá walí íyacaishi warrúnaanica éerri jútainchu. ");
INSERT INTO aca_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Jipérdona wáucha máashii wamédanica, chaléjta wapérdonau wayá, náa'a médenai walí máashii. ");
INSERT INTO aca_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ujínda wacácoo máashii rícula, jitúya wayá liúcha liá'a wawásimica.’ ");
INSERT INTO aca_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Ipérdonaa náa'a médenai irrú máashii, níwata chacábacanaa, liá'a Isálijinaa yáairri áacairra, lipérdonaaminaa iyá lécchoo; ");
INSERT INTO aca_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ne jócta ipérdonaa áabi, chacábacanaa jócu Isálijinaa pérdonaa iyájoo ijíconaa lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Iyá jáicta iyúnaa, umáashii iméda inániu máashii wówa chaléjta náa'a chámai wítee, íyadeneu nayá jájiu máashii naméda nawówau chóniwenai cábaque'e nayá cháji'i. Yáawaiyi numá irrú, liyú léja liérra iwáalia iwéniu. ");
INSERT INTO aca_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Jiyá, jáicta jiyúnaa, jibádeda jinániu jichúndaniu sáica, ");
INSERT INTO aca_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","quéewique'e náa'a chóniwenai jócu yáa léenaa jinácu jiyúnaaca. Bácai rími jisálijinaa yáa léenaani, báawita jócu wacábani, liyá cáberri quinínama liá léenaa linácu, ya yáairri jiájcha, liyá yáa jirrú jiwéniu. ");
INSERT INTO aca_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Oyáawaqueda warrúwa líta'aa liéni cáinabica, á'a wijíi márdacta'inaa ya shínaashi amáarrai'inaa o yúquerri'inau, nayácta náa'a canédica nawárroo nanéduca. ");
INSERT INTO aca_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Mawí sáicaca, iméda liá'a sáictai Dios cábaca, imédacta chacábacanaa, chaléjta wáalenai rícucai éerri ítala, níwata Dios yáa iwéniu. ");
INSERT INTO aca_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Édacaniu, táshia nácucha jiwáaliacta jirrícucau, jiwówa néeni yáa lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Náa'a watuíca jicá'a lámpara wanáanairru, nayú wéewa wacába matuínaami. Tándawa, ituí sáicai, éewa nacába sáica quinínama. Chái cábacanaa, jócai camáisani ya náa'a iwáalinica, iyá éewenai yáa léenaa atéwa quinínama liá'a Dios wówerri iyá yáni léenaa. ");
INSERT INTO aca_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Ne máashicta náa'a ituíca, iyá jócu éewa icába sáica matuínaami. Ya liáni mamáarraca namédacoo chá'a, líinuminaa liá'a éerrica jáicta jiní éewani icábaca. Iyáminaa quinínama catáwacabee rícu. Chái cábacanaa, mamáarraca namédacoo camáisaniniyu, quinínama icáwica yáairri catáwacabee rícu. Quinínamacta iyá éewani icába ya iwítee pénsani náa'a matuínaami éerri shínanaa, quinínamaminaa liá'a imédanica máashii'inaa. ");
INSERT INTO aca_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Jiní éewerri lishírrueda chámatacta liwácali, jiníwata máashii licába báqueerri, ya caníinaa licába liá'a báqueerrica, jócta machácani báqueerrirruni ya lichánini liá'a báqueerrica. Jócai wéewa washírrueda Diosru ya warrúwarru. Chái cábacanaa, iyá jócai éewa yáa icáwica Diosru ya lécchoo yáa icáwica yáawacaidaque'e warrúwa ya matuínaami. ");
INSERT INTO aca_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Tánda numá irrú: O'urrúni iwówa linácueji liá'a íyacaishi, ya írra'inaa nácu ya iyáayu'inaa, jiní íibalashi nácu lécchoo liá'a isúwani'inaaca. ¿Jócu cawéni icáwica mawí yúcha liá'a íyacaishica ya ináanai liúcha liá'a íibalashica? ");
INSERT INTO aca_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Icába náa'a míshiiduca yáarraneneecoo áacai: Jócani yáabana, jócani yáawaqueda, jócani wáalia íyacaishi náabana lícuu; ne liá'a isálijinaa yáairri áacairra yáirri náaya'inaa. ¡Ne iyá mawí cawéni náucha náa'a míshiiduca! ");
INSERT INTO aca_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ne máayabaca, báawita íchaba urrúni wawówa, ¿chíta quéewau jíni wadáwineda wacáwicau jíni báawita áabai hóra'inaa? Néeenee iyá jócai urrúni wówa íyacaishi nácu jócta íibalashi nácu. ");
INSERT INTO aca_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“¿Tánda bájiala urrúni iwówa íibalashi nácu? Icábau chítashia lidáwinau'u náa'a íiwinaashi yáairri bacháida rícu: jócani tráawajaa, jócani súcueda. ");
INSERT INTO aca_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Ne áawita chácani, numá irrú, áawita rey Salomón, quinínama lishínaa chúnica, jócu lisúweda líibalau sáicabeetaica léjta íiwinaashi. ");
INSERT INTO aca_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ne Dios súwacta chacábacanaa íiwinaashi sáictani wérri, wáalee liyá bacháida rícu, ya cajójcha léemau chichái rícula, ¡mawíminaa liá'a íibalajoo, chóniwenai cháuctani éebidaca! ");
INSERT INTO aca_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Dios caníinaa licába iyá, tánda cha numá irrú jócubeecha isátada éemiu: ‘¿Tána'ee wáayai?’ o ‘¿Tána'ee wáirrai?’ o ‘¿Tána'ee wasúwai?’ ");
INSERT INTO aca_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Quinínama liéni wáneerri urrúni nawówa náani jócani éebida, ne iyá wáalianai báqueerri isálijinau yáairri áacairra ya yáirri léenaa liá'a irrúnaanica. ");
INSERT INTO aca_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Tándawa numá irrú ya liwíbanaa liéni numáni irrú Dios wánacaalactalaca, imédaque'e lirrú léjta liwówau, chacábacanaa irríshibia quinínama méenaami. ");
INSERT INTO aca_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","U'urrúni iwówa linácu liá'a cajójcha sái éerrica, jiníwata cajójcha ái éerri já'a urrúni iwówa. Éerri jútainchu wáalianai lishínaa chúnsai máashiica. Tándawa, jócu urrúni iwówa libéecha liá'a éerrica. ");
INSERT INTO aca_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Ujitáania máashii linácu liá'a namédanica náa'a áabica, quéewique'e Dios jócu litáania máashii linácu liá'a imédani iyá. ");
INSERT INTO aca_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Chacábacanaa Dios yúca jiyá máashictala lécchoo, jimédacta máashii báqueerrirru; ne liyúja liá'a jénedauca iyá lécchoo, Dios éejoo léneda iyá liyú lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","¿Tánda arrúnaa jicába jéenajirri tuí rícu liá'a catábibee liwáalianica, ne jócai jicába liá'a jiwáaliani áicuba shírricu yáairri jituí rícu lécchoo? ");
INSERT INTO aca_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ne jiwáaliacta jituí rícu áabai áicuba shírricu, ¿chíta quéewa jimá jéenajirrirru jíni: ‘Jínda nujéda jiúcha liá'a catábibee yáairri jituí rícu’? ");
INSERT INTO aca_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","¡Chámai wítee! jijéda quéechanacu liá'a áicuba shírricuca yáairri jituí rícu, cháminaajoo jéewa jicába sáica, jéewaque'e jédaca liwáalia lituí rícu jéenajirrica. ");
INSERT INTO aca_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Ujiá nalí náa'a yáawaiyi dujíwala chuánshi sáicai Dios bánuani, nalí náa'a chóniwenai cháneenai ya jócu nawówai néemica. Liérra léjta wácta áulirru, jócu náa léenaa néemica ya néewa náamueda iyá; jócta jiá íiba cawénii puítirru, jócani yáa léenaa íiba cawénii ya éewenai nabáwedani. ");
INSERT INTO aca_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Isátau, ya Dios yáminaa irrújoni; imúrru, ya íinuminaajoni; imáida cuíta núma lícu, ya liméecuminau irrújoo. ");
INSERT INTO aca_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Jiníwata liá'a sáterrica, lirríshibiaminaani; liá'a múrruerricani, líinuminaa; liá'a máiderri cuíta núma lícu, liméecuminau lirrú. ");
INSERT INTO aca_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“Néenee Jesús liméda liáni licábacanaa: ¿Ne éenaminaa iyá yáa licúulee íyau bátui íiba, jáicta lisáta líyau jiúcha páani? ");
INSERT INTO aca_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","¿O lisátacta líyau jiúcha cubái, jiáminaa líya bácua áai cawálai? ");
INSERT INTO aca_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ne chaléjta iyá báawita máashii, éewa yáa sáicai éenibirru, ¡chítashia mawí jíni isálijinaa sáicai yáairri áacairra liá irrú, méenaami sáicai wérri tánashia nasátani liúchai! ");
INSERT INTO aca_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Chacábacanaa, iméda náajcha náa'a áabi chóniwenaica, chaléjta iwówa naméda yáajcha náa'a áabica; jiníwata cháwa libánuacani liéni leyca, nashínaaminaa náa'a íiwadedenai Dios chuáni báinacumi. ");
INSERT INTO aca_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Jesús liméda liáni licábacanaa, limá nalí: Iwárroo rícuba liá'a cuíta núma áulabai téerri'inaa iyá áacairra. Níwata liá'a linúma ya iníjbaa téerri'inaa máashictala manúshidai ya jócai tráawajui wáacoo rícu, ya íchabaminaajoo wárroo lirrícubajoo; ");
INSERT INTO aca_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ne liá'a linúma ya iníjbaa téerri'inaa liá'a cáwicaishi jócai amáarra, áulabani wérri ya tráawajui wérri wáau rícu, ya áulabani rími náiinujoni. ");
INSERT INTO aca_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Cáwiwa icába yúchau náa'a chóniwenai médenai númashi yúwica, quéewique'e nawána áabi éebidacani nayá táanianai Dios nácu, ne jócai yáawaiyi. Náiinu iyáctala náabala léjta oveja, ne yáawaiyi nawówa lícueji chaléjta cháawi carrúnatai. ");
INSERT INTO aca_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","¿Chíta quéewau yáa léenaa tánashia cachálujuedacani? Iyá éewani icúnusiaca tánashia jiliá'a namédanica, jócu wéewa nawína uva áabai banácali catúwirre ítacha, jócu wéewa wawína ítashi banácali máashii nácucha. ");
INSERT INTO aca_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Chacábacanaa, quinínama banácali sáicaitani yáairri lítau sáica, ne liá'a banácali máashictani liá lítau máashii lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Liá'a banácali sáicaitani jócai éewa liá lítau máashii, jiní banácali máashii éewau liá lítau sáica. Cha lécchoo nabésunau náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Quinínama banácali jócai yáa lítau sáica, nawíchuani ya náuca chichái rículani. Cha lécchoo Dios méda náajcha náa'a chóniwenai cachálujuedacanica. ");
INSERT INTO aca_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Iyáminaa yáa léenaajoo icúnusia yúchau linácu liá'a namédanicojoo. ");
INSERT INTO aca_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Jesús má'ee: jócuminaa quinínama náa'a máine nulí: ‘Nuwácali, nuwácali’, nawárroominaujoo Dios wánacaalactalaca, nayá rímiminaajoo wárruaujoo náa'a médenai nusálijinaa wánacaala yáairri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Liyáali éerriminaajoo íchaba ma nulíjoo: ‘Nuwácali, nuwácali, wayá arrúnaa jída wawárruacoo Dios wánacaalactala, níwata wayá táanianai jijí'inaa nácu, jijí'inaa nácu wajéda demonio chóniwenai yúcha, jijí'inaa nácu waméda íchaba jócai wacába cáji.’ ");
INSERT INTO aca_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Néenee nuéebaminaa nachuánijoo numá nalí: ‘Jócuwa nucúnusia iyá; ¡ishírriu núcha iyá camédacani máashii!’ ” ");
INSERT INTO aca_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Jesús má'ee chóniwenairru: “Táda numá, tánashia éemerri liáni nuchuánica ya liméda léjta numáyu'u, chái léjta báqueerri washiálicuerri cawítee bárruedeerri líibanau íiba íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Néenee únia yúwawai manúta quinínama méeda, cáuli cánaca'eewoowai lécchoo, náiinu linácula quinínama liá'a cuítaca, ne jócu licáwai, níwata'ee lidáni bárruerriu íiba íta'aa cabálininaa. ");
INSERT INTO aca_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ne tánashia éemerri liáni nuchuánica ya jócai liméda léjta numáyu'u, chái léjta báqueerri washiálicuerri mawítee, bárruedeerri líibanau cáina íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Néenee únia yúwawai manútai quinínama méeda, cáuli cánaca'eewoowai lécchoo, náiinu linácula quinínama liá'a cuítaca néenee licáwai. ¡Licáarraliawai quinínama!” ");
INSERT INTO aca_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Néenee Jesús nísa'inaa litáaniacai, quinínama náa'a chóniwenai nacáarruda'eewoo néemica léewidau nayá Jesús, ");
INSERT INTO aca_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","níwata léewida nayá léjta báqueerri yáirri léenaa linácu liá'a léewidani liyáca, jócani chaléjta náa'a qéewidacani ley shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Quéecha'inaa Jesús yúrrucuacoo dúuli ítacha, íchaba chóniwenai yáa líshiirricu. ");
INSERT INTO aca_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Liyáalimi'e lirrúniu báqueerri bálinerriu lepra nácu, jáiwa litúyau liúrruimiyu Jesús náneewa, limá'ee lirrú: —Nuwácali, jiwówaicta, jéewaminaata jichúni nuyá liúcha liá'a nubálinacaalaca. ");
INSERT INTO aca_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Jesús dúnu'e licáajiyu wáni, limá'ee lirrú: —Jajá nuwówai. ¡Jimáacacoo masáculaiyu! Liyáalimi, liá'a bálinerricoo lepra nácu limáacacoo masáculai. ");
INSERT INTO aca_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Jesús má'ee lirrú mawí: —Jicábate, ówa jíiwa jiyá áabirrujoni jiní wérri; jimédani já'a jiá namówai jíyadacoo lirrú liá'a sacerdóteca, jitée liérra ofrendaca Moisés wánani yáaca, quéewique'e quinínama yáa léenaa jáicala masáculai jiyái jishínaa bálinacaalashi yúchau. ");
INSERT INTO aca_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Jái'inaa Jesús wárruau lirrícula liá'a chacáaleeca jí'ineerri Capernaúm, néenee báqueerri soldado wácali romano, lirrúniu lirrú lisáta liwówa yáajchau liúcha. ");
INSERT INTO aca_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","Limá lirrú: —Nuwácali, liá'a icúlirrijui tráawajairri nulí bálinerriu, jócai éewa libárruacoo ái ruwáirriu núbana néeni, súfrierri cáiwibee. ");
INSERT INTO aca_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Néenee Jesús éeba'ee lirrú: —Nuáu nuchúnicani. ");
INSERT INTO aca_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Jáiwa soldado wácali léeba'ee: —Nuwácali, nuyá jócai sáicanata jiwárruacoo núbana rícula, jimá cháji'i liárra chuánshica, lichúnique'iniujoo liá'a icúlirrijuica. ");
INSERT INTO aca_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Níwata ái áabi wánacaleenai cadájcueta nuyája'a, nuyá chái wánacaala lécchoo soldado. Numácta báqueerrirru jiá namówai, yáairriu. Numácta báqueerrirru jíinu chérra, íinuerri néenee. Numácta lirrú liá'a nushínaa tráawajairri nulí, jiméda liáni, liméda jíni. ");
INSERT INTO aca_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Jesús nísa'inaa léemiqui jíni, néenee licáarrudau léemiqui jíni sáicta liwówa lécchoo, limá'ee nalí náa'a máinecoo liájcha: —Yáawaiyii numá irrú, jiní nuíinuni nácu náa'a israelítabinica, báawita bácairrimi, éebiderri'inaa nunácu, léjta liáni washiálicuerri. ");
INSERT INTO aca_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Numá irrú íchabaminaa chóniwenai íinu déecuchejijoo cáiwia jiáctejcoo ya cáiwia wárruactalacoo, nawáau náaya liájcha liá'a Abrahám, ya Isaac ya Jacob, chaléeni Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Ne náa'a Dios máidani quéechanacu, arrúnaa nayá Dios wánacaalactalaca, náucaminaa nayájoo bináawala catáwacactaca. Néenee náichaminaajoo ya náamueda néu licáicha. ");
INSERT INTO aca_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Néenee Jesús ma lirrú liá'a soldado wácalica: —Jiá namówai, jíibana néerra, cha limédacoo jirrú léjta jéebidau'u. Liyáalimija liá'a tráawajairri lirrú limáacau sáica. ");
INSERT INTO aca_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Jesús yáa'eewoo Pé'eru íibana néerra, jáiwa'ee líinu Pé'eru néerru runácue yáaichoo cama íta'aa bálinechoo licámunayu. ");
INSERT INTO aca_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Jáiwa Jesús dúnu rucáaji nácui, ya liyáalimi licámuna éedau rúchai, jáiwa'ee rubárruawai, ya ruchána rushírrueda náaya'inaa. ");
INSERT INTO aca_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Catáwaca'inaa liácuwai natée'e Jesúsru íchaba chóniwenaica wáalenai espíritu máashii; áabai wánacaalashiyu já'a lijéda espíritu máashiini, yá'ee lécchoo lichúni'e quinínama bálineneecoo. ");
INSERT INTO aca_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Liéni bésuneerriu quéewique'e licúmpliacoo líiwadedani báinacu liá'a íiwadedeerri Dios chuáni báinacu liá'a Isaíasca, limá'inaa: “Liyá'ee liwína washínaa májinabee ya litée washínaa bálinacaalashi.” ");
INSERT INTO aca_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Jesús, cába'inaa'ee liyáu cashiámu litéeji chóniwenai, limá'ee wabésunau bajiála manuá. ");
INSERT INTO aca_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Libéecha nabésunacoo bájiala, lirrúni lirrúi báqueerri quéewidacai ley shínanaa, limá'ee lirrú: —Quéewidacai, nuwówai nuáacoo jiájcha táshia jiáctalau jíni. ");
INSERT INTO aca_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Jesús éeba'ee lichuáni: —Náa'a iyáliduca wáalenai náutabeu, ya náa'a míshiiduca wáalenai namúrrubeu, ne nuyá washiálicuerri Dios cúuleeca, jócai wíta wáalia núbanau chúnsai táshia nurrúwaida'inaa nuwítau. ");
INSERT INTO aca_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Báqueerri'e lishínaa éewiderricoo, limá'ee lirrú: —Nuwácali, jínda nuáacoo quéechanacu nuquéni nusálijinau. ");
INSERT INTO aca_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Jesús éeba'ee lichuáni: —Jiáu nuíshiirricu, ya jimáaca namáanalinica naquéni nashínaa máanalinica. ");
INSERT INTO aca_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Jesús yúrrucoo lancha rícula, lishínaa éewidenaicoo natálideda liyá. ");
INSERT INTO aca_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Jáiwa cawíquinta áabai cáuli cadánani wérri íinu manuá yáacu, jáiwa'ee marrádaca ísau lancha rículai. Né'e liá'a Jesúsca máairri liácoo. ");
INSERT INTO aca_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Néenee náau nacáweda liyá náa'a lishínaa éewidenaicoo, namá lirrú: —¡Wawácali, jiwáseda wayá! ¡wayájani waquétacoo wayácai! ");
INSERT INTO aca_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Néenee léeba'ee nalí: —¿Tánda cáarru wérri iyá? ¡Iyá píituirrimi imáaca iwówau nunácu! Limá'inaa liáni, libárruau'eewoo liá'ee áabai wánacaalashi lirrú liá'a cáulica ya lirrú liá'a manuáca, quinínama limáacau machúnucunaa wérri. ");
INSERT INTO aca_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Néenee nacáarrudau nacábaqui jíni nasáta néemiu wáacoo: —¿Tána washiálicuerri léji liáni, báawita cáuli ya manuá éewidani lirrú? ");
INSERT INTO aca_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Néenee Jesús íinu'inaa bajiála manuá, nashínaa cáinabi náa'a Gerasaca, jáiwa chámata wáalenai demonio jiáneu útawi rícucha máanalini yáarruica, jáiwa narrúniu Jesúsrui. Nayá carrúnatani wérri, jiní éewerri libésunacoo lirrícuba liá'a iníjbaaca; ");
INSERT INTO aca_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Jáiwa nachánau namáidadaca namá'ee: —¡Ujiníquiu wáajcha, jiyá Jesús, Dios cúulee! ¿Jíinu áani jiwánau'e wasúfriaca libéecha liá'a éerrica? ");
INSERT INTO aca_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ne urrúni néeni já'a íchaba puíti íyenai'e nayáca, ");
INSERT INTO aca_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","náa'a demonioca namésuda Jesúsru: —Jijédacta wayá, jínda wawárruacoo nalí náa'a puítica. ");
INSERT INTO aca_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Jesús ma nalí: —Yáa namówai. Náa'a demonio najiáu náucha náa'a washiálicuenaica, jáiwa nawárroo nalí náa'a puítica; ne liyáalimi náa'a puítica, jáiwa nacánacawai báju rícula cáashia náiinu manuá néerra, néeni'e nasácumawai. ");
INSERT INTO aca_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Náa'a túyenaimi puíti najiáu nacánacacoo nacárruniu, náiinu'inaami lirrícula liá'a chacáaleeca, nachánau náiiwadedaca liá'a bésuneerricoo, quinínama libésunaucoo náajcha náa'a wáalenai demonio. ");
INSERT INTO aca_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Néenee bájialanaa náa'a chacáalee rícu sánaca, najiáu chaléeni Jesús yáctalaca, nacába'inaami jíni namá lirrú lijiáque'iu lirrícucha liá'a nashínaa cáinabica. ");
INSERT INTO aca_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Néenee liáwinaami liéni, Jesús yúrrucoo áabai lancha rícula, lichuáu bajiála manuá, liyáctala quéecha, jáiwa líinui lishínaa chacáalee rículawai. ");
INSERT INTO aca_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Néeni natée lirrú báqueerri macáwai, rúwerriu áabai yáarruishi íta'aa; Jesús cába'inaa'ee néebida linácu, limá lirrú liá'a bálinerricoo: —Cadánani jiyá, nucúulee, jishínaa jíconaashi jái méetuacuwai. ");
INSERT INTO aca_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Áabibi qéewidacani ley shínaa, namá'ee nawówa licuéjiu: “Limáni jiliéni máashii Dios nácucha, níwata liyá táanierri újni Dios.” ");
INSERT INTO aca_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ne Jesús yáa léenaa liá'a namáni nalíwoo, lisáta léemiu nayá: —¿Tánda iwáalia iwíteu máashii wérri? ");
INSERT INTO aca_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","¿Tána mawí jócui tráawajui, numácai: ‘Jijíconaa jái méetuacuwai’, jócta numá ‘Jibárroo jijínau’? Nulí áabenai jócai tráawajui numéetua jíconaashi jócta nuchúni bálinacaalashi. ");
INSERT INTO aca_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ne núyadaminaa irrúni nuyá, Washiálicuerri Dios Cúuleeca, wáalierri wánacaalashi líta'aa liéni cáinabi liméetua'inaa jíconaashi. Néenee limá macáwairru: —Jibárruau, jiwína jiárrubaiu ya jiáu jíibana néerrau. ");
INSERT INTO aca_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Liá'a macáwaica jáiwa libárruawai, jáiwa liáwai líibana néerrau. ");
INSERT INTO aca_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nacába'inaa liáni, náa'a chóniwenaica, jáiwa cáarru nayái, jáiwa náa sáicai Diosrui, liácala lidánaniu nalí náa'a washiálicuenaica. ");
INSERT INTO aca_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Liáwinaami Jesús yáau néenee. Néenee licába báqueerri washiálicuerri jí'ineerri Mateo wáairriu liyá á'a licóbracta liyá impuesto Romarru. Jáiwa'ee Jesús ma lirrú: —Jíinu nuájcha, quéewique'e jéewida'au nunácu. Néenee Mateo bárruawai ya liáu liájchai. ");
INSERT INTO aca_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Libésunaute quéecha Jesús íya liyáca Mateo íibana rícu, jáiwa náa'a íchaba cóbrenai impuesto wánacaalactalaca Romarru, ya áabi chóniwenai máashiini íiwanaa, náiinu'e nawáacoo mésa nácu lécchoo, Jesús yáajcha ya lishínaa éewidenaicoo. ");
INSERT INTO aca_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ne nacába'inaa liáni náa'a fariséobinica, néenee nasáta néemi náa'a éewidenaicoo liájcha: —¿Tánda ishínaa qéewidacai íya náajcha náa'a cóbrenai impuesto Romarru ya náajcha náa'a áabi cajíconaanica? ");
INSERT INTO aca_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Jesús éemi'inaa liá'a namánica, limá nalí: —Náa'a yáainai sáica ya jócu nabálinau, jócani rúnaa médico, náwa rúnaani náa'a bálinenaicoo. ");
INSERT INTO aca_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Yáau éewidacoo chítashia liwówau'i limáqui jíni liá'a tánerricoo: ‘Uwówai mawí carrúni jináata icába áabi, náucha náa'a cuéshinai éemanica altarca íta'aa.’ Jiníwata nuyá jócaita íinu numáida náa'a namáni nalíwoo majíconaa nayá, nuíinu numáida náa'a cajíconaanica, quéewique'e nacámbia nawíteu. ");
INSERT INTO aca_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Náa'a jínanenaicoo liájcha liá'a Juan Bautístaca, narrúniu Jesúsru nasátaque'e néemiu liyá namá'ee: —Wayá ya náa'a fariséobinica wayúnaa bájiala, ¿tánda jishínaa éewidenaicoo jócu nayúnaa? ");
INSERT INTO aca_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Jesús éeba'ee: —¿Ya néewaminau máashii nawówa náa'a nacúmidani áabai bódarru, nácula liá'a nashínaaca yáa náajcha? Ne líinuminaa liá'a éerrica jinícta'inaa nuyá náajcha; jáicta líinu liá'a éerrica, néenee liyáali éerriminaa nayúnaaca. ");
INSERT INTO aca_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Jiní chúneerri áabai íibalashi dánumimi áabai wáarruma wáalii yáajcha, jiníwata liá'a wáarruma wáaliica liáwaqueda liá'a íibalashi dánumimica jái lisúbirria jíni, ya liá'a shírricuerriu mawí máanuique'e jíni. ");
INSERT INTO aca_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Chacábacanaa jócu wachácuma vino wáalii íimanaashi dánumimica rícu, jiníwata carrúnatai dúwacoo, chacábacanaa liúcacoo liá'a vinoca léjta íimanaashi jái liúcawai. Tándawa arrúnaa wanuá liá'a vinoca wáalii lirrícu liá'a íimanaashi wáaliica, quéewique'e sáica nayá chámainaa. ");
INSERT INTO aca_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Nácula Jesús táania liyáca chóniwenairru, báqueerri nawácali náa'a judíobinica líinu, litúyau lináneewa, limá lirrú: —Numíyacaula máanaliuyi chóca rímijani; ne jiáctau jichánaa jicáajiu runácu rucáwiaminaujoo. ");
INSERT INTO aca_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Jesús bárruawai ya liáwai lishínaa éewidenaicoo yáajchau. ");
INSERT INTO aca_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Néenee báquetoo íinetoo bálinechoo doce camuí, íirrai éechani, rurrúniu Jesúsru liwójune, rudúnu líibala númacua nácu. ");
INSERT INTO aca_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Jiníwata rumá'ee rulíwoo: “Lécta nudúnucta líibala nácu, sáicaminaa nuyájoo.” ");
INSERT INTO aca_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ne Jesús náawau, licába ruá'a íinetooca, ya limá rulí: —Cha jiwítemija'a, numíyacaula, jéebidacala nunácu sáica jiyái. Liyáalimi éerri sáica ruyái. ");
INSERT INTO aca_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Néenee Jesús íinui'inaami líibana néerra liá'a judío wácalica, licába'ee náa'a músicoca ya náa'a chóniwenaica máidadenai náichaca máashiica nawówa, naméda bájiala nawítamau. ");
INSERT INTO aca_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Jesús má'ee nalí: —Ijiáyu mayéji áani, ne ruá'a miyácauca jócau máanali, máichoo ruyáca. Nacáida'ee Jesús náa'a chóniwenaica, náaca léenaa ruá'a miyácau máanaliu. ");
INSERT INTO aca_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Jáiwa liwána najiácuwai; néenee liwárruawai liwína rucáaji nácu ruá'a miyácauca, liyáalimi rubárruawai. ");
INSERT INTO aca_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ya quinínama líta'aa liá'a cáinabica, líiwanaa cánacacoo liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesús jiá'inaamiu Jairo íibana rícucha, chámata matuíni jiáu liánai namáidadaca: —¡Carrúni jináata jicába wayá, David táqueerrimi! ");
INSERT INTO aca_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Néenee Jesús wárroo áabai cuíta rícula, náa'a matuínica narrúniu lirrú, néenee Jesús sáta léemiu nayá: —¿Eebidaminaa nuéewacta nuchúni iyá? —Nayá néeba'ee lirrú: —Jajá, wawácali. ");
INSERT INTO aca_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Néenee Jesús dúnu natuí nácu, ya limá nalí: —Nuchúni iyá éebidaque'e nunácu. ");
INSERT INTO aca_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Liyáalimi néewa nacába báaniu. Jesús má'ee nalí bájiala: —Jiní jibéecha yáa léenaani. ");
INSERT INTO aca_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ne, liyáalimi najiáwai, náiiwadeda jíni quinínama cáinabi liá'a Jesús médani náajcha. ");
INSERT INTO aca_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Nácula najiáu náa'a matuínica, áabibi chóniwenai naínda Jesúsru báqueerri jócai éewa litáaniaca, liwáaliaca demonio. ");
INSERT INTO aca_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Ne liyáalimi Jesús jéda'inaa demonio, liá'a jócaimi éewa litáaniaca, jáiwa litáania. Náa'a chóniwenaica nacáarruda'eewoo, namá'ee: —¡Jócai wacába cáji líta'aa liéni Israel shínaa cáinabica chái cábacanaa jí'i! ");
INSERT INTO aca_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ne namá'ee náa'a fariséobinica: —Léeminawa chúnsai demonio wácali, liáni'inaa liéni lidánani lijéda demonio náuchani. ");
INSERT INTO aca_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Jesús jínaniu quinínama chacáalee ya náa'a chacáalee júbini rímica, léewidaca narrícu náa'a sinagogaca. Líiwadeda chuánshi sáicaica liá'a Diosca wánacaleerrica, ya lichúni quinínama bálinacaalashi ya cáiwibee. ");
INSERT INTO aca_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Licába'inaa náa'a chóniwenaica, carrúni jináata wérri licába nayá, jiníwata yáainai urrúni wérri nawówa ya jiní néewactalau, chaléjta náa'a oveja jinínicta túyanini. ");
INSERT INTO aca_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Néenee Jesús ma lishínaa éewidenaicoorru: —Yáawaiyi wéerri liá'a shínaashica íchabai, ne náa'a tráawajadorbinica áulabani. Chacábacanaa, éerri rícu ái íchaba chóniwenai jócani yáa léenaa Dios nácu, ne náa'a íiwadedenai nalí Dios chuáni áulabani rími. ");
INSERT INTO aca_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Tándawa, cháucta tráawajadorbini arrúnaa isáta liúcha liá'a shínaashi wácalica, libánuaque'e mawí tráawajadorbini quéewique'e náawaquedacani. Chacábacanaa, isáta Dios yúcha, libánuaque'e mawí náa'a íiwadedenai Dios chuáni nalí náa'a chóniwenai. ");
INSERT INTO aca_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Jesús máida lishínaa doce éewidenaicoo, liáque'e nalí lidánaniu quéewique'e najéda náa'a espíritu máashiinica, ya quéewique'e lichúni quinínama bálinacaalashi ya cáiwibee. ");
INSERT INTO aca_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Léewa liáni nají'inaa náa'a doce apóstoluca: Quéechanacu lijí'inaa Simón, lijí'inaa lécchoo Pé'eru ya limérrerri Andrés; Santiago ya léenajirri Juan, licúulee liá'a Zebedeoca; ");
INSERT INTO aca_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Felipe ya Bartolomé; ya Tomás ya Mateo cacóbracaica impuesto Romarru; Santiago Alfeo cúulee, ya Tadeo; ");
INSERT INTO aca_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simón liá'a cananita, ya Judas Iscariote, liáwinaami éntregueerri'inaa Jesús lijínairru. ");
INSERT INTO aca_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesús bánua náani doce apóstoluca, liájcha liá'a tánashia namédani'inaaca: Uyáu nashínaa cáinabi ítala náa'a jócani judío, u'iwárroo lirrícula náa'a chacáalee Samariaca; ");
INSERT INTO aca_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Yáau machácani chaléeni nayáctala náa'a Israel shínaa cáinabi ítala, nalí náa'a chóniwenaica yáainai jicá'a oveja yúquenaiu. ");
INSERT INTO aca_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Yáayu íiwadedaca urrúnicala liá'a Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ichúniu náa'a bálinenaicoo, icáweda náa'a máanalinica, iméetua nashínaa bálinacaalashi náa'a chorrówai sánaca ya ijéda demonio. Iyá irríshibia mawéni liáni danáanshica; u'icóbra náucha wéni'inaami ichúni nayá. ");
INSERT INTO aca_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","U'itée oro, báawita warrúwa ya cobre, ");
INSERT INTO aca_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","jiní chácala'inaa iníjbaa lícu. Jiní itéeca íibalau áabai mawiá, báawita cotiza, báawita icháque'e, jiníwata liá'a catráawajaacaica arrúnaa liwáalia líya'inau. ");
INSERT INTO aca_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Jáicta íinu áabai chacáalee rículai, jócta chacáalee júbini rími, imúrru áabi chóniwenai sáicanictani, iyá nábana néeni cáashia yáacoo lirrícucha liá'a chacáaleeca. ");
INSERT INTO aca_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Jáicta iwárroojoo nábana rícula, itáa nalí náa'a yéenai lirrícu liá'a cuítaca. ");
INSERT INTO aca_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Náa'a chóniwenaica cuíta narríshibiacta sáica iyá, sáicabee wérri'inaa nalí; inísa iméda sáicai, ne jócta narríshibia iyá sáica, Dios jócu liméda nalí sáicai lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Jócta narríshibia iyá, ya jócu nawówai néemi irrú, ijiáyu lirrícucha liá'a cuítaca, jócta chacáalee rícucha ya icúsudau íiba nácucha liá'a pucúpucubeeca, quéewique'e náa'a chóniwenai náaqué'e léenaa Dios íiwirri liwówa náajcha, níwata nayá nachánicala liyá. ");
INSERT INTO aca_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Ne éemi sáica numáni irrú, liyáali éerri amáarracta'inaa cáinabi, Dios cástigaaminaa mawí nárra chóniwenai, jócani wówai narríshibia iyá ya jócu néemi irrú, náucha náa'a chóniwenaimica yáainaimi cáinabi íta'aa Sodoma ya Gomorra rícu. ");
INSERT INTO aca_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“¡Icábate! Nubánua iyá léjta oveja náa'a níquenai'inau béewami cháawirru. Imédau léjta liá'a áai cawítee wérrica, báawita iyá arrúnaa lécchoo léjta paloma jócani méda máashii. ");
INSERT INTO aca_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Cá'wa yúchajoo, jiníwata néntregaa iyájoo nalí náa'a cawánacaalanica, nabáseda iyájoo narrícu náa'a sinagogaca, ");
INSERT INTO aca_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ya cáashia náyadaminaa iyá nanáneewa náa'a cawánacaalanica ya reybini nunácue; cháminaa éewa íiwadeda chuánshi sáicaica nunácu nanáneewa náa'a jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Ne jáicta néntregaa iyái nalí náa'a wánacaleenaica, cha iwíteemija'a linácu liá'a imáni'inaaca, léjta liá'a imáni'inaaca, jiníwata jáicta líinujoo táaniacta'inaaca, Dios yáminaa ichuánijoo. ");
INSERT INTO aca_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ne jócuminaa iyájoo cha táaniaca, Isálijinaa shínaa Espíritu táaniaminaa irrícueji. ");
INSERT INTO aca_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Néenajinai néntregaaminaa néenajinaiu náiinuaque'e nayá, ya náa'a nasálijinaaca néntregaaminaa néenibiu; náa'a néenibica nanáawaminau nasálijinaa náculau náiinuaque'ini. ");
INSERT INTO aca_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Íchabaminaa chóniwenai máashiiminaa nacába iyá nunácueji; ne liá'a cabálininaa wérri yáca nunácu, liyáminaa liwásedajoo. ");
INSERT INTO aca_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Jáicta namúrru iyái áabai chacáalee rícu, yáau áabai rícula; ne yáawaiyi numá irrú, nuyá Washiálicuerri Dios Cúuleeca, nuíinuminaajoo jóctanaa icánaqueda quinínama chacáalee Israel shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Jiní wérri báqueerri éewidenaicoo mawíyi lishínaa quéewidacai yúchau, jiní wérri catráawajaacai mawíyi liwácali yúchau. ");
INSERT INTO aca_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","O'inénda chóniwenai méda báqueerri éewiderri mawí sáicai lishínaa quéewidacai yúcha, jócta naméda báqueerri shírruederri mawí sáicai liwácali yúcha. Chái cábacanaa, níwata nuyá ishínaa quéewidacai, iyá arrúnaa inénda chóniwenai méda irrú máashii, níwatajani méda nulí máashii. Ne mawí, iyá arrúnaa inénda náa'a chóniwenai naméda máashii iyá, léjta naméda nuyá. Nayá nacáitadeda nuyá náa nují'inaa Beelzebú, néenee yáawaiyii iyá mawí wérri naméda irrú máashii. ");
INSERT INTO aca_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ucáarru icába náa'a chóniwenaica. Jiníwata quinínama liá'a cabáyaintaica, áabai éerri'inaa náa léenaajoni; quinínama liá'a yéerri báyeerricoo, áabai éerri'inaa náa léenaani. ");
INSERT INTO aca_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Liá'a numáni irrú catáwacabee rícu, íiwa jucámarrabee jirrículani; ya liá'a numáni cabáyainta, imáidadau íiwacani cuíta íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ucáarru icába náa'a íinuenai ináanai, ne jócani éewa náiinua liá'a icáwicaca; sáicanata cáarru icábaca liá'a éewerri líinuaca ya lécchoo éewerri limárdaca iyá infierno rícula mamáarraca éerri. ");
INSERT INTO aca_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","“¿Jócu iwénda chámai míshiidu áabai moneda rími nácueji? Ne jiní wérri, áabai néenaa máanali, jóctaca wasálijinaa Dios wówai. ");
INSERT INTO aca_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Báawita iyá jájiu, cáashia iwíta báinaa liwáaliani jútaderriu bácuanama. ");
INSERT INTO aca_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Tánda ucáarru iyá: Iyá cawénini wérri mawí náucha náa'a míshiidu rími íchabanica. ");
INSERT INTO aca_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Báqueerricta íiwadeda nunácu nanáneewa náa'a washiálicuenaica, nuyá lécchoo nuíiwadeda lináawa nusálijinaarru liá'a yéerri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ne liá'a báyeerri nunáawa náucha náa'a chóniwenaica, nuyá lécchoo nubáyaminaa, lináawa lécchoo liúcha liá'a nusálijinaa yéerri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“U'éebida irrúwoo nuíinucala nuíndacala sáictacta nawówa lítala liéni éerrica; nuyá jócai íinu nuínda sáictacta nawówa, nuyá íinderri jináawiu. ");
INSERT INTO aca_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nuyá íinuerri nuwánaque'e liá'a washiálicuerrica lináwacoo lijúnta liá'a lisálijinaacoo, ya rumíyacaula rutúwa júntau, ya ruá'a runírruca rúneerru júntau; ");
INSERT INTO aca_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","nayáminaa nája nárra éenajinai bácainaa, nayáminaa ijínai'inaa nárra. ");
INSERT INTO aca_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Liá'a wówerri wérri lisálijinau jócta litúwa mawí núcha, jócai éewa nushínaaca; liá'a wówerri wérri licúuleu jócta limíyacaula mawí núcha, jócai éewa nushínaaca; ");
INSERT INTO aca_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","liá'a jócai wówai carrúni jináata limédacoo nunácueji, ya jócu lisíguia nuyá, jócai éewa nushínaaca. ");
INSERT INTO aca_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Tánashia náa'a báyenai nuyá chóniwenai náneewa, jócu nabéecha náiinua liyá, jócai nacáwi Dios yáajcha mamáarraca. Ne liá'a máirrica léebidaca nunácu, báawita náiinua liyá, cáwiminaa liyá Dios yáajcha mamáarraca. ");
INSERT INTO aca_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Jesús síguerri limáca: Liá'a ríshibierri iyá, ríshibierri nuyá, ne liá'a ríshibierri nuyá, ríshibierri liá'a nusálijinaa bánuerri nuyá. ");
INSERT INTO aca_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Liá'a ríshibierri báqueerri cáiiwadedacai Dios chuáni, lirríshibiaminaa liyá liwéniu, léjta liá'a cáiiwadecai Dios chuáni; ne liá'a ríshibierri báqueerri sáicaica, jiníwata sáicacalani, lirríshibiaminaa chacábacanaa áabai liwéniu léjta liyá. ");
INSERT INTO aca_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ne tánashia yáirri náirra shiátai casálini, náani júbinica máinecoo nuájcha nasíguiaca nuyá, yáawaiyi numá irrú, liwáaliaminaa liwéniujoo.” ");
INSERT INTO aca_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Quéecha'inaa Jesús nísa líiwadeda nalí náa'a doce éewidenaicoo, liáu néenee líiwadedaca ya léewidaca liá'a chuánshica Dios shínaa nalí náa'a chacáaleeca liá'a shínaa cáinabica. ");
INSERT INTO aca_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Juan, yéerri cuíta manúmai rícula, léemi líiwanaa liá'a Cristo médani liyáca. Néenee libánua áabibi néenaa náa'a jínanenaicoo liájcha, ");
INSERT INTO aca_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","nasátaque'e néemiu Jesús liyácta yáawaa liá'a Cristoca léjta náiiwadedau náa'a cáiiwadedacani Dios chuáni báinacu íinuerri'inaaca, jócta arrúnaa nanénda báqueerri. ");
INSERT INTO aca_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Jesús éeba'ee nalí: “Yáa namówai íiwa Juanruni liá'a icábanica ya liá'a éeminica. ");
INSERT INTO aca_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Íiwa Juanruni náa'a matuínica cábenai, náa'a macáwanica éewenai najínacoo, náa'a chorrówai sánaca sáicani nabálinacaalashi yúchau, náa'a mawíbanica éewenai néemica, náa'a máanalinimica éejueneu nacáwiacoo, náa'a carrúni jináatanica náiiwadeda nalí liá'a chuánshi sáicaica wásedeerri'inaa nayá. ");
INSERT INTO aca_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","¡Ya sáictai wérri liwówa liá'a jócai éejueda liwówau núcha!” ");
INSERT INTO aca_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Néenee náa'ináamiwai, jáiwa Jesús táania nalí náa'a chóniwenaica linácu liá'a Juanca, limá'ee: “¿Tána ijiáu icábacai á'a wáunamactalaca? ¿Báqueerri washiálicuerri éerri jútainchu lináawida lichuániu? Jócai. ");
INSERT INTO aca_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Jiníctani, ¿tána ijiáu icábacai? ¿Báqueerri washiálicuerri sáictai wérri íibala? Iyá yáine léenaa náa'a súwedenai íibalashi sáictai yáainai nábana rícu náa'a reybinica. ");
INSERT INTO aca_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ya jócta, ¿tána ijiáu icábacai? ¿Icába báqueerri íiwadedeerri Dios chuáni? Jajá, yáawaiyi, Juan mawíyi wérri náucha náa'a íiwadedeenai Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Juan léewa liá'a limáni jiliá'a tánerricoo cáashta íta'aa: ‘Nuyá bánua cáiiwadecai chuánshi jibéecha, quéewique'e lichúni liá'a iníjbaa.’ ");
INSERT INTO aca_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ne yáawai numá irrú, jiní náiibicha náa'a washiálicuenaica, jiní wérri mawí máanui liúcha liá'a Juan Bautístaca; ne máayabacaminaa, nayá náa'a chóniwenai máaquenai nawówau Dios nácu, mawíni cawéni Juan yúcha, báawita nayá jiní nawéni. ");
INSERT INTO aca_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","“Néenee liyáali éerri jáicta Juan Bautista íneda líiwa Dios chuáni chóque'e, liá'a Dios wánacaalactaca súfrierri jináwiu, ya náa'a médenai danáanshi nénedaque'e namárdacani. ");
INSERT INTO aca_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Quinínama náa'a íiwadedeenai Dios chuáni ya liá'a leyca yáainai bácai náiiwadedacanica linácucha liá'a wánacaalactaca, cáashia Juan íinuca; ");
INSERT INTO aca_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ne iyá iwówaicta éebida liáni, Juan léjta liá'a Elíasca íiwadedeerri Dios chuáni íinuerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Iyá iwówaicta yáa léenaa liáni numánica, arrúnaa édacanicoo sáica. ");
INSERT INTO aca_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","¿Chíta nacábacanaa náa'a chóniwenaica chóque'e? Iyá cháni léjta sáamanai jócani wówai naséwica áabi sáamanai yáajcha, wáanenaicoo plaza rícu namáidadaca najúnicairru: ");
INSERT INTO aca_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wáiinuate íiwa, ne iyá jócuwa iwáilaa; warrábate shímashi cáiwii, ne iyá jócute iwowai ichálujueda íchaca chaléjta wawówau imédacani.’ ");
INSERT INTO aca_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Jiníwata Juan íinuerri, jócai íya jiní líirraca, iyá imá'ee liwáaliaca'ee espíritu máashii, níwata jócai iwówai néemica lirrú. ");
INSERT INTO aca_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Néenee nuíinui nuyá washiálicuerri Dios cúuleeca, íyeerrica ya nuíirra, iyá imá'ee cáayacai ya cáirracalai, najúnicai náa'a cóbrenai impuesto Romarru ya áabi chóniwenai máashiini íiwanaa. Ne liá'a Dios wíteeca íyaderriu liyú liá'a méderricoo quinínamarru.” ");
INSERT INTO aca_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Néenee Jesús, báawita jócu liyá náiibi, lichána liárraca náa'a chacáaleeca á'a limédacta mawí máanuica jóca nacába cáji, jiníwata náa'a chóniwenaica yáainai náiibi jócani éejueda nayáu Diosru. Jesús má'ee: ");
INSERT INTO aca_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“¡Ái jiyámi carrúni jináata, Corazín! ¡Ái jiyámi carrúni jináata, Betsaida! Jiníwata á'a Tiro néeni ya Sidón néenictata naméda jócai nacába cáji, namédani íibi, báinacuminaata éejueda nayáwai Diosru, náayadaminata nasúwa íibalashi cadúrruderri ya nawáta báali nawíteu. ");
INSERT INTO aca_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ne numá irrú liyáali éerri amáarraquicta cáinabiminaajoo, mawí'inaa máanuica ishínaa cástigu náucha náa'a chóniwenai yáainai Tiro ya Sidón rícu. ");
INSERT INTO aca_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya jiyá, chacáalee Capernaúm, ¿jéebidaminaa jinácudacoo áacairra? Jócai, ¡mawíminaa dujíwala wérri jiáu útawica! Jiníwata á'a Sodoma néeni naméda liáni jócai nacába cáji, liá'a méderricoo íibi, liárra chacáaleeca yéerri'inaata chóque'e. ");
INSERT INTO aca_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ne numá irrú liyáali éerri amáarraquicta cáinabiminaajoo, mawí'inaa máanuica ishínaa cástigu náucha náa'a chóniwenai yéenaimi Sodoma shínaa cáinabi íta'aa.” ");
INSERT INTO aca_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ne liyáali éerri Jesús ma: Nuá jirrú sáicai nusálijinaa cawánacaalacai áacairra ya cáinabi, jiníwata jíyadaca nalí náa'a imíyanica iwíteu, ya jibáyate náucha náa'a yáainai léenaa ya náa'a cawíteenica. ");
INSERT INTO aca_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Jajá, nusálijinaa, jiníwata le jiwówau jáni. ");
INSERT INTO aca_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“Nusálijinaa liá nulí quinínama wíteeshica. Jiní wérri cúnusierri yáawaa nuyá liá'a licúuleeca, léerrimija liá'a lisálijinaaca; jiní wérri cúnusierri yáawaa liá'a lisálijinaaca, léerrimija nuyá liá'a licúuleeca ya léerrimija náa'a nuyá licúulee wówaini liméda nacúnusiacani. ");
INSERT INTO aca_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Íinu nulí quinínama iyá sámunica ishínaa tráawajuyu ya cadúcunibeeca, nuyáminaa wána iwówa íyabacoo. ");
INSERT INTO aca_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Irríshibia nulíni liá'a cadúcunini nuáni irrú, ya éewidau nunácu, nuyácala sáicai wáaleerri nuwówau imíyai; cháminaa íinu iwówa íyabacoo. ");
INSERT INTO aca_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Jiníwata liá'a nuwánanica ya liá'a cadúcunibeeca nuá irrú, itéeni'inaa madéjcanamai.” ");
INSERT INTO aca_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ne liyáali éerri, áabai éerri nawówa íyabactacoo, Jesús jínaneerriu náabanacta banácali. Lishínaa éewidenaicoo, jáiwa sámu nawówai, jáiwa nachána néerrueda líta liá'a trigoca náyaque'e líta. ");
INSERT INTO aca_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Náa'a fariséobinica nacába'inaamini liá'a namédani nayáca, namá'ee Jesúsru: —Jicábate, jishínaa éewidenaicoo médani nayáca báawita jócai wéewa wamédaca éerri wawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Jesús éeba'ee nalí: —¿Jócu iliá éemiu liá'a David médanica, liyáali éerrimi liyá ya lijúnicaibinica sámu'inaa nawówa? ");
INSERT INTO aca_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ne liwárruateu Dios íibana rícula, jáiwa líya liá'a páanica Dios shínaaca, jócai'inaa ta sáicanaa líyaca, liyá ya náa'a limánabacaca, liyárrimi léja liá'a sacerdótebinica, ya Dios jócai licástigaa naméda linácueji. ");
INSERT INTO aca_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","¿Jócu iliá éemiu Moisés shínaa ley rícu, náa'a sacerdóteca templo rícu jócani méda cajíconau, báawita natráawajaaca liá'a éerri nawówa íyabactacoo? ");
INSERT INTO aca_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Ne numá irrú ái ája áani, báqueerri mawí cawénica templo yúcha. ");
INSERT INTO aca_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Iyá jócani yáa léenaa éemi limáni nácucha liáni tánerricoo: ‘Nuwówa iyá carrúni jináataiyu, jócubeecha éema cuéshinai. Yácta ta léenaa éemicani, jócuminaa ta yúca chóniwenai chaléjta éebidenaicoo nuájcha, jiníni méda máashii.’ ");
INSERT INTO aca_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Ne sáicai, nuyá Washiálicuerrica Dios Cúuleeca, wáalierri wánacaalashi lirrícu liá'a éerri nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Néenee Jesús yáau náabanactalaca, liyáali éerri sábadoca, jáiwa liwárroo sinagoga rícula yéerri néeni. ");
INSERT INTO aca_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Néeni lirrícuja'a báqueerri washiálicuerri cáaji íshiderriu; namúrrucala chítashia néewau'inaa náuca Jesús, nasáta néemiu liyá: —¿Léewaminau wachúni báqueerri léerdi wáalee liá'a wawówa íyabactacoo? ");
INSERT INTO aca_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Jesús éeba'ee nalí: —¿Tána éenaa iyái, wáaleerri áabai oveja licáctau áabai útawi rícula, á'a nawówa íyabactacoo, jócuminaa yáau ijédacani? ");
INSERT INTO aca_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","¡Mawí cawénica báqueerri washiálicuerri oveja yúcha! Yáawaiyi sáica waméda liá'a sáicabeeca éerrica nawówa íyabactacoo lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Néenee Jesús ma lirrú liá'a washiálicuerrica: —Jidáquinia jicáajiu. Jáiwa dáquinia licáajiu liá'a washiálicuerrica, limáacau lirrú sáica léjta ruá'a béemaca. ");
INSERT INTO aca_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Ne náa'a fariséobinica, jócai sáicta nawówa, quéecha'inaa najiácoo nachána natáania nalíwoo chítashia néewau'inaa náiinua Jesús jíni. ");
INSERT INTO aca_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Jesús yáa léenaa nawówai náiinua liyá liáu néenee, íchaba chóniwenai yáau liájcha. Jesús chúni quinínama náa'a bálinenaicoo, ");
INSERT INTO aca_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","limá'ee nalí jócubeecha natáania linácu chóniwenai íibi. ");
INSERT INTO aca_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Léja liáni licúmpliaque'iu liá'a limánimi liá'a íiwadedeerri Dios chuáni báinacu, jí'ineerri Isaíasca, limá'inaami: ");
INSERT INTO aca_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Ái ája áani nushínaa cashírruedacaica, liá'a nuwínanica, liá'a caníinai nucábaca, sáicta nuwówa nucábacani. Nuáminaa lirrú nushínaa Espíritu, ya líiwadeda machácani quinínama cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Jócai'inaa litáania chuánshi amuáiyu, jócuminaa lécchu limáidada, jiní lécchoo éemenai'inaa lichuáni cáaye rícuba béewami chacáalee. ");
INSERT INTO aca_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Limédaminaa nalí sáica náa'a máajinaa néebidauca, cháni léjta liá'a basuéca wówerri litúcuacoo, cháni léjta lámpara íyacua májtarrimi jéda íisa. Limédaminaa chájoni cáashia machácanicani liwánacaalactala'inaa quinínama cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Ya chóniwenaica quinínama cáinabi íta'aa sánaca, namáacaminaa nanéndacaishi linácu.” ");
INSERT INTO aca_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Natée Jesúsru báqueerri washiálicuerri matuíyii ya jócai éewa litáaniaca, níwata wáaleerri demonio, jáiwa Jesús éejua liwána licába bániwai ya léewa litáaniaca jáicta Jesús jéda liúcha demonio. ");
INSERT INTO aca_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Quinínama nacáarrudau nasáta néemiu nalí wáacoo: “¿Liyáminaa léja liáni Cristo, litáqueerrimi liá'a washínaa rey Davidca?” ");
INSERT INTO aca_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Néemi'inaamini liáni, náa'a fariséobinica namá'ee: “Beelzebú, liá'a demonio wácalica, liyája liérra yáairri lidánani liéni washiálicuerri lijédaque'e demonio.” ");
INSERT INTO aca_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Jesús, yáirri léenaa liá'a napénsaa nayáca, limá nalí: “Quinínama país náawaca yáacaquictau máashii nacába yáacacoo, namárda yáacau nayá jájiu; áabai chacáaleeca o néenajinai yáacoo máashii nacába yáacacoo, jócani éewa nayá sáica, amáarrani'inaa. ");
INSERT INTO aca_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Chacábacanaa, Wawásimi jédacta lishínaa chúnsana demonio, liyá jájiu limárdau; ¿chíta quéewau liwáalia lidánaniu jíni? ");
INSERT INTO aca_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Iyá máinai nujédacala demonio Beelzebú dánaniyu; ne cháctani, ¿tána yáa irrú náa'a ijúnicaica liá'a danáanshica quéewique'e ijéda demonio? Tándawa nayája náiiwa ináawa iyáca yúqueneu. ");
INSERT INTO aca_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Jiníwata nujédacta demonio Espíritu Dios dánaniyu, liwówau limáca liá'a wánacaleerri Dios shínaa jái íinu irrúi. ");
INSERT INTO aca_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Nuá irrú áabai licábacanaa nuíiwaque'e tádashia nuyá nuéewa nujéda demonio: ¿Chíta quéewoo liwárruacoo báqueerri shínaa cuíta rícula jíni liá'a washiálicuerri cadánanica lédaque'e lishínaa, jócta libájida liúchau quéechani? Táminaa, libájidaqui jíni léewa lijédaque'e lishínaa. ");
INSERT INTO aca_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Liá'a jócai yáau nuájcha, yáairriu báawachala núcha; liá'a jócai yáawaqueda nuájcha, cáarralerri'inau. ");
INSERT INTO aca_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","“Tánda numá irrú Dios pérdonaa náa'a washiálicuenaica quinínama jíconaashi, ya quinínama máashii namánica, ne jócuminaa lipérdonaa liá'a namáni máashiica Espíritu Santo nácucha. ");
INSERT INTO aca_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Dios pérdonaaminaa quinínama cha lécchoo táaneerri máashii nuyá washiálicuerri Dios Cúuleeca; ne táaneerricta máashii Espíritu Santo nácucha, jócuminaa lipérdonaani nácula cáwi liyá líta'aa liáni cáinabica, ne jiní áabata léerdi liáwinaami liáni. ");
INSERT INTO aca_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yáabanau sáica áabai banácali, iwáalia'a lítau sáica; yáabanau máashii iwáalia'a lítau máashii; ne liá'a banácalica wacúnusiani líta nácuejiu. ");
INSERT INTO aca_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","¡Áai éenajinai! ¿Chíta quéewoo imá chuánshi sáicai jíni, ne iyá jájiu máashiini? Liá'a yéerri iwówa lícu, litáania inúma licuéji. ");
INSERT INTO aca_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Liá'a washiálicuerri sáicaica táaneerri chuánshi sáicai, jiníwata sáicaca liyá, ne liá'a washiálicuerri máashiica táaneerri chuánshi máashii, jiníwata máashii yéerri linácu. ");
INSERT INTO aca_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ne numá irrú liyáali éerri Dios márdacta'inaa cáinabi, arrúnaa náa nashínaa cuenta quinínama chuánshi mawénii namánica. ");
INSERT INTO aca_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ne linácueji liá'a chúnsai jichuánica namáni jiyácta sáicai jócta cajíconai.” ");
INSERT INTO aca_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Áabi néenaa náa'a fariséobinica ya néenaa náa'a áabibi quéewidacani ley shínaaca, néenee namá'ee Jesúsru: —Quéewidacai, wawówai wacábaca jimédaca áabai cábacanaashi jócai wacába cáji. ");
INSERT INTO aca_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Néenee Jesús éeba'ee nalí: —Nárra chóniwenai máashiini ne yáawaiyi jócai éebida Dios nácu, nasáta'ee áabai jócai nacába cáji; íyadaque'e nusálijinaa Dios bánuani nuyá, ne jócuminaa nuá mawí señal léjta liá'a íiwadedeerri Dios chuáni báinacu, jí'ineerri Jonás. ");
INSERT INTO aca_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Chaléjta Jonás yáayumi matáli éerri ya matáli táayebee liáawi rícu liá'a cubái máanuica, chacábacanaa nuyá Washiálicuerri Dios Cúuleeca, nuyáminaa matáli éerri ya matáli táayebee cáinabi yáajabala. ");
INSERT INTO aca_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Náa'a yáainaimi Nínive rícu nacáwiaminaujoo máanalicai yúcha amáarracta'inaa cáinabi, ya natáaniaminaa ijúnta iyá quéewique'e Dios cástigaa iyá; níwata nárra chóniwenaica yáawani nanáawida nacáwicau néemi'inaami liá'a chuánshi Jonás íiwani nalí. Ne iyá éemenai nuchuáni ne jócai éebida, báawita nuyá mawí cáiwanaca Jonás yúcha. ");
INSERT INTO aca_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ruá'a reina wánacaleechoo chaléeni sur néerra, rubárruaminau amáarracta'inaa cáinabi, jáicta liúca chóniwenaica le éerri jiliéni, ya rutáaniaminaa ijúnta iyá, níwata ruyá íinuechoo déecucheji wérri cáinabica, quéewique'e ruéemi Salomón wítee. Ne iyá jócani wówai éemica nuéewidacala, báawita nuyá mawí cáiwanaca Salomón yúcha. ");
INSERT INTO aca_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Jáicta áabai espíritu máashii lijiáu báqueerri washiálicuerri yúchai, jínaneerriu yáarrushi máacarrai rícu múrruerri limáacoo liárruiu; ne jinícta líinuni limá lirrúwoo: ");
INSERT INTO aca_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Nuéejo'quictátawai núbana rículau báaniu nujiáctejmicoo.’ Jáicta léejua'inaawai, líinu linácu liárra washiálicuerrica, léjta áabai cuíta máisaictani, jíchuderrictau wáni ya nachúndadanini. ");
INSERT INTO aca_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Néenee liáwai liáwaqueda áabi siete espíritu íchaba mawí máashiini wérri liúcha, ya quinínama nárra sieteca nawárruau lirrú liá'a washiálicuerrica, mawíque'e nawána máashii wérri mawíjani. Chacábacanaani'inaa bésunacoo nárra chóniwenai máashiini wérrica. ");
INSERT INTO aca_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesús táania'inaa liyá újnibii nalí náa'a chóniwenaica, jáiwa náiinu lirrú lécchoo ruá'a litúwaca ya léenajinai, nawówaica'ee natáania liájcha. Ne jáiwa namáacoo bináaweji, ");
INSERT INTO aca_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","néenee báqueerri íiwa Jesúsru jíni: —Jitúwa ya jéenajinai yáaine bináaweji, wówenai natáania jiájcha. ");
INSERT INTO aca_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Néenee Jesús éeba'ee liá'a íiwerri lirrúni: —¿Tána nutúwai ya nuéenajinaica? ");
INSERT INTO aca_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Néenee, lidúcua nátala náa'a lishínaa éewidenaicoo, limá'ee: —Náawa nutúwa ya nuéenajinai náani. ");
INSERT INTO aca_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Níwata tánashia méderri liwánacaala liá'a nusálijinaa yéerri áacairra, nuwówai lécchoo chái cábacanaa léjta nuéenajirri, nuéenajetoo ya léjta nutúwa. ");
INSERT INTO aca_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Liyáali éerrimija lijiáu liá'a Jesúsca lirrícucha liá'a cuítaca léewidacta liyáca, néenee liáu liwáacoo manuá tácoowala. ");
INSERT INTO aca_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Ne íchabaca wérri chóniwenai yáawacacoo Jesúsru, jáiwa Jesús yúrrucuau áabai lancha rícula, jáiwa liwáawai léewidaque'e, nácula náa'a chóniwenaica máaquenaiu cáina íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Néenee litáania nalí íchaba nácu licábacanaayu. Limá'ee nalí: “Báqueerri cáabanacai liáu licása banácali íimi. ");
INSERT INTO aca_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ne liáabana'inaa áabata léenaa liá'a líimica cáu iníjbaa lícu, náiinu náa'a míshiiduca, jáiwa náya jíni. ");
INSERT INTO aca_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Áabata cáirriu íiba íibirra, jinícta sáica cáinabi; jáiwa liárra líimica páquiau madéjcata, jiníwata jinírru cáinabi dujíwala; ");
INSERT INTO aca_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ne liá'a cáiwiaca lijiá'inaamiwai, jáiwa léema jíni, jiníwata jiní jíchu sáica, jáiwa léemawai míishii jíni. ");
INSERT INTO aca_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Áabata léenaa liá'a líimica cáirriu túwirri íibi, ne jáiwa lidáwinau náa'a túwirrica, jáiwa lisácumeda jíni. ");
INSERT INTO aca_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ne áabata liá'a banácalica cáirriu sáiquitacta cáinabi, jáiwa liá lítau sáica; áabata yáa lítau újni cien líimi máanabaca, áabata sesenta líimi máanabaca, áabata treinta limáanabaca. ");
INSERT INTO aca_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ne iwówaicta liwárrueda lirrú liá'a numánica, arrúnaa e'écanicoo sáica.” ");
INSERT INTO aca_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Náa'a lishínaa éewidenaicoo liá'a Jesúsca náiinu lirrú nasáta néemiu liyá, tándashia léewida chóniwenai licábacanaayu. ");
INSERT INTO aca_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Jesús éeba'ee nalí: “Iyá Dios wána yáa léenaa cabáyainta liá'a liwánacaalanica, ne nalí jócai. ");
INSERT INTO aca_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Cháwajani, éemiu sáica, liá'a éemerri sáica, yáirri'inaa léenaa mawí, ne liá'a jócai éemi sáica, áawita liyá liá léenaa mawí, liyá pérderri'inaa liá'a píitui rími liáni léenaa nácu. ");
INSERT INTO aca_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Tándawa nutáania nalí licábacanaayu; níwata nayá báawita néemi nuchuáni, néemi bácai licábacanaa, cháija ne yáawaa jócai wárrueda nalí limáyuca yáawaiyii liá'a numáni nácucha. ");
INSERT INTO aca_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Cháminaa léjta nabésunau nayá, licúmpliawai liá'a limánimi liá'a cáiiwadedacai Dios chuáni báinacu jí'ineerri Isaías, limá'inaate: ‘Iyá éemiminaa liá'a numánica, ne jócuminaa liwárrueda irrú. Iyá síguiaminaa icába liá'a numédanica, ne jócuminaa liwárrueda liéni limáyu'ca. ");
INSERT INTO aca_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Ne nawítee náani chóniwenai yáainai mawíteeni, níwata jócani wówai liwárrueda nalí, wáalianai nawíbau báyeerriu, wáalianai natuí báyeerriu, quéewique'e jócu néewa nacába ya néemica, ya jócubeecha náa léenaa; jócubeecha néejoo nulí, nuchúni nayá.’ ");
INSERT INTO aca_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“Ne Dios sáicta wérri liwówa yáajcha, níwata iyá cábenai liá'a numédanica, ya yáayu léenaa liá'a numánica. ");
INSERT INTO aca_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ne numá irrú yáawaa, íchaba cáiiwadedacani Dios chuáni báinacu ya chóniwenai sáicanica, wówenai nacába liáni icábani iyá, ne jócu néenaa nacábaqui jíni; nawówai néemi liáni éemini iyáca, ne jócu néenaa néemiqui jíni.” ");
INSERT INTO aca_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Liáwinaami, Jesús ma nalí náa'a lishínaa éewidenaicoo: “Éemite liáni liwówau'i limáca liá'a licábacanaa linácu liá'a cáabanacaica. ");
INSERT INTO aca_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Náa'a éemenai liá'a chuánshi Dios shínaa linácu liá'a Dios wánacaalactalaca, ne jócu náa léenaa néemicani, nayá léjta liá'a banácali íimica cáirricoo iníjbaa lícu; líinu liá'a Wawásimica lijéda liá'a Dios chuáni liáabanani liwówa lícu. ");
INSERT INTO aca_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Liá'a banácali íimica cáirricoo íiba íibirra, chái licábacanaa léjta náa'a chóniwenaica éemenai Dios chuáni, narríshibia sáicta néemicani, ");
INSERT INTO aca_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ne jóca liwáalia lijíchu sáica, jócani yáa cabálininaa, ne jáicta linácue liá'a Dios chuánica, nasúfria carrúni jináata nayá o nacánaqueda nayá namúrru namédaque'e nalí máashii, náuca náuchau liá'a néebidauca. ");
INSERT INTO aca_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Liá'a banácali íimi cáirricoo túwirri íibi, léjta náa'a chóniwerrica éemenai Dios chuáni, ne nawówai namédacoo cawárruanicajiyu, néenee nayá urrúni nawówa bácai linácu liá'a shínaashica. Libésunau'e nalí namíya máecha liá'a Dios chuánica ya jócu naméda liá'a shínaashica Dios wówaini'e nayá médaca. ");
INSERT INTO aca_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ne liá'a banácali íimi yáabaneerricoo cáinabi sáicai íta'aa, chái léjta náa'a chóniwenaica éemenai Dios chuáni, náa léenaa néemicani. Natráawajaa Diosru sáica, áabi cháni léjta liá'a banácali íimica yáairri cien lítau, naméda bájialanaa, áabi léjta líimica yáirri sesenta, naméda íchaba mawí, ya áabi cháni léjta líimica yáirri treinta, naméda píituita.” ");
INSERT INTO aca_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Néenee Jesús íiwa báaniu áabata licábacanaa: “Liá'a Dios wánacaalactalaca chái léjta báqueerri washiálicuerri yáabaneerri banácali íimi sáicai bacháida lícu. ");
INSERT INTO aca_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ne quinínama namáa'inaami nayáca, líinu báqueerri najínai, jáiwa liáabanai máashiibee máashii nashínaa trigo íibi, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ne jái'inaami lidáwinau liá'a trigoca, jáiwa líiwinaa jiáwai lécchoo, néenee lijiáu lécchoo máashii máashibeeca. ");
INSERT INTO aca_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Néenee náa'a tráawajadorbinica náawai náiiwa lirrúni liá'a liwácalica: ‘Wawácali, liá'a banácali íimi jiáabananica bacháida lícu sáicaica, ¿chíta lijiáu jiliá'a máashii máashibeeca?’ ");
INSERT INTO aca_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Liá'a liwácalica limá nalí: ‘Báqueerri wajínai médaniminaa liáni.’ Náa'a catráawajaacanica nasáta néemiu liyá: ‘¿Jiwówai jiyá wáacoo wéerruaque'e liá'a máashii máashibeeca?’ ");
INSERT INTO aca_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Néenee limá nalí: ‘Jóca, éerruacta liá'a máashii máashibeeca, carrúnata éerrua lécchoo liá'a trigoca. ");
INSERT INTO aca_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Mawí sáica waínda lidáwinacoo áabenaa, cáashia lidáwinacoo wawínaquicta'inaacani; néeneeminaajoo nubánua náawaquedacoojoni, nashírrique'e quéecha liá'a máashii máashibeeca, nabáji macáishitani, wéemaque'ini, ne liábinaami nawína ya náawaqueda liá'a trigoca nushínaa liárrui rículau.’ ” ");
INSERT INTO aca_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesús íiwa nalí lécchoo liéni licábacanaa: “Liá'a Dios wánacaalactalaca chái léjta áabai líimi jí'ineerri mostaza, báqueerri washiálicuerri yáabanani bacháida lícu. ");
INSERT INTO aca_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Liéni yáawaiyi, áabau néenaa náa'a mawí píituica quinínama náiibicha náa'a líimica; ne jáicta lidáwinawai mawí máanuica liúcha liá'a yéerri lirrícu liá'a náabanactacani, lidáwinau léjta áabai áicuba máanui, máanui wérri míshiidu íinu naméda líibanau linácai nácu.” Cha lécchoo, liá'a Dios chuánica náiiwani ya lichána píitui rímiyu, néenee lidáwinawai máanui limédacuwai. ");
INSERT INTO aca_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Jesús íiwa nalí lécchoo liéni licábacanaayu: “Liá'a Dios wánacaalactalaca chái léjta liá'a múrracairricoo, báquetoo íinetoo píilechoo matálinai harina íinabi, quéewique'e cáiwique'ini quinínamani liá'a liinábica.” ");
INSERT INTO aca_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Jesús táania quinínama liáni nalí náa'a chóniwenairru linácueji liéni licábacanaayu, cháiji jócai táania nalí liyáwoo licábacanaayu. ");
INSERT INTO aca_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Cháwa quéewique'e licúmpliacoo liá'a limáni liá'a cáiiwadedacai Dios chuáni báinacu: “Nutáaniaminaa liyáwoo licábacanaayu; nuíiwa áabata yéerri cabáyainta liyáalimi Dios liquénuda'inaami cáinabi”. ");
INSERT INTO aca_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Néenee Jesús íiwa lináwau nalí náa'a chóniwenaica, jáiwa liwárroawai áabai cuíta rícula, jáiwa lishínaa éewidenaicoo narrúniu lirrú, ya nasáta néemiu liyá namá lirrú líiwaque'e nalí linácu liá'a licábacanaa liá'a máashii máashibeeca yéerri bacháida rícu. ");
INSERT INTO aca_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Jesús éeba'ee nalí: “Liá'a yáabaneerri líimi sáicaica, nuyá Washiálicuerri Dios Cúuleeca, ");
INSERT INTO aca_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","léja liérra bacháidaca liyáwa éerrija. Liá'a líimi sáicaica, wówerri limáca náa'a médenai Dios wówainica, ya liá'a máashii máashibeeca wówerri limáca náa'a médenai Wawásimi wówainica, ");
INSERT INTO aca_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","liá'a wajínai yáabaneerri máashii máashiibee íibi, léwa Wawásimi liérra. Liá'a lítaca wówerri limáca amáarrau'inaa liá'a cáinabica, náa'a yáawacadenai banácali íta, náawa ángelbini nárra. ");
INSERT INTO aca_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Licábacanaa léjta náawaquedau máashii máashibeeca náucaque'ini chichái tuírricula léemaque'iu, chacábacanaa libésunacoo nalí náa'a Wawásimi shínaaca jáicta amáarra cáinabijoo. ");
INSERT INTO aca_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Nuyá Washiálicuerri Dios cúuleeca, nubánuaminaa nushínaa ángelbiniu, náawaquedaque'e nushínaa nuwánacaalactaca, náa'a quinínama wánenai naméda máashii chóniwenaica cajíconaanica, ya náa'a médenai máashii. ");
INSERT INTO aca_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Náucani'inaa lirrícula liá'a chichái túculerricoo, náichactala'inaa náamueda néu quirríquirrinaa licáichau. ");
INSERT INTO aca_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Néenee náa'a médenaica léjta Dios máyu'uca, quéenenai'inaa chaléjta cáiwia quéenau chaléeni wánacaalactalaca nusálijinaa néerra. Iyá iwówaicta yáa léenaa liáni numánica, arrúnaa édacanicoo sáica. ");
INSERT INTO aca_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Jesús má'ee nalí: Liá'a Dios wánacaalactalaca chái jicá'a áabai cawéni wérrica báyeerricoo cáinabi yáawi rícula. Báqueerri washiálicuerri íinu linácu liá'a cawéni wérrica, ya léejoo libáya néeni jíni; liwówa chúnicau liáu liwénda quinínama liá'a liwáalianica, ya liwéni liérra cáinabica, quéewique'e liá'a cawéniica lishínaacani. ");
INSERT INTO aca_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Jesús má'ee nalí lécchoo: Liá'a Dios wánacaalactalaca, chái léjta báqueerri cawéndacai jínaneerriu limúrruerri íiba úcunini cawéninamai; ");
INSERT INTO aca_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","jái'inaa líinu linácui liá'a áabai cawéni wérrica báqueerri yúcha, liáu liwénda quinínama liá'a liwáalianica, ya liwéni liá'a íiba úcuni cawéniica. ");
INSERT INTO aca_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Jesús má'ee báaniu, lé'e liá'a Dios wánacaalactaca chái'e léjta áabai máaya náucanicta manuá yáaculani, lijéda matuínaami cubái cábacanaa. ");
INSERT INTO aca_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Jáicta cashiámu léji liá'a máayaca, náa'a catésucanica najédani cáina ítala, nawáctala'inau naníwacani náa'a cubáica; nawáaliani náa'a cubái sáicanica náarrui rículau ya náuca liá'a máashiica. ");
INSERT INTO aca_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Chacábacanaa jáicta amáarra léju liá'a cáinabica; Dios bánuaminaa náa'a ángelbinica nashírridaque'e máashiinica báawachala ya náa'a sáicanica, ");
INSERT INTO aca_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","náucani'inaa náa'a máashiinica lirrícula liá'a infiernoca írranii chicháiyu, náichactala'inaa ya náamuactala'inaa néu quirríquirrinaa licáichau.” ");
INSERT INTO aca_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Néenee Jesús sáta léemiu nayá: —¿Éemi jíni quinínama liáni? —Jajá, wawácali —namá'ee. ");
INSERT INTO aca_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Néenee Jesús má'ee nalí: —Jáicta báqueerri quéewidacai ley shínaa léewidau sáica linácu liá'a Dios wánacaalactalaca, chái léjta báqueerri cuíta wácali, liá'a liwáalianica liá léenaa lijéda méenaami wáaliica ya liá'a lidánimimica. ");
INSERT INTO aca_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Ne Jesús nísa'inaa líiwadeda liyú liá'a licábacanaaca, néenee liáwai néeneeji, ");
INSERT INTO aca_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","jáiwa líinui lishínaa cáinabi néerrau, jí'ineerri Nazaret, jáiwa lichánau léewidaca lirrícu liá'a sinagogaca. Náa'a chóniwenai nacáarruda'eewoo, namá'ee: —¿Tanácucha jéewidau linácu quinínama liéni jiáni léenaa? ¿Chíta quéewau jéewa jiméda léji liérra jócai wacába cáaji? ");
INSERT INTO aca_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","¿Jócaita le licúulee liá'a camédacai méenaami áicubayu, ya María cúulee? ¿Jócaita le Santiago éenajirri ya José ya Simón ya Judas, ");
INSERT INTO aca_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ya léenajinai íina yéenai lécchoo wáiibi áani? ¿Néenee tána bésunawai chóque'e litáania íchaba wíteeshiyu ya léewa liméda jócai wacába cáji? ");
INSERT INTO aca_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Tándawa jóca nawówai naméda liwánacaala. Tándawa Jesús má'ee nalí: —Jáicta báqueerri cáiiwadedacai litáania Dios chuáni nácu, báawachala jócaita lishínaa cáinabi, náa'a chóniwenaica cawáunta ya néebida lirrú, ne jáicta litáania nalí náa'a chóniwenai lishínaa chacáalee rícu sánaca o á'a líibana néeni, nayá jócu cawáunta nacábacani jiní néebidaca lirrú. ");
INSERT INTO aca_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Jiní limédani íchaba jócai nacába cáji néerra, jiníwata náa'a chóniwenaica jócani éebida liyácala liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Liyáali éerrimi, Herodes Antipas, wánacaleerri léjta rey á'a Galilea, léemi'e natáania Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Herodes má'ee lishínaa tráawajadorbinirru: “Le Juan Bautístaja liérra cha cáwiacoo; tádawa léewa liméda jócai wacába cáji.” ");
INSERT INTO aca_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Jiníwata quéechami liá'a Heródesca wáneerri nawína Juan preso, liwánani nabájida cadénayu natéeque'ini cuíta manúmai rícula. Herodes wánaca nawárrueda Juan preso ruwánaca ruá'a Herodíasca, líinu liá'a Felipeca Herodes éenajirri. ");
INSERT INTO aca_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Jiníwata Juan máirrite Heródesru: “Jócai éewoo jijéda jíinu ruárra íinetooca cáwicalani rúnirri liá'a jéenajirrica.” ");
INSERT INTO aca_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Linácueji Herodes wówai líinua Juan, ne cáarru licába náa'a chóniwenaica, jiníwata quinínamarru néebida liá'a Juanica cawéni wérri líiwadedaca Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ne liyáali éerri Herodes shínaa licúmpliacta camuí, rumíyacaula ruá'a Herodíasca rujiáu ruwáilaca nanáneewa náa'a namáidanica, Herodes gusta ruyá ruwáilauca bájialanaa, ");
INSERT INTO aca_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","tánda Herodes ma rulí liwánacaala nácu, liáminaa rulí tánashia rusátani liúchai. ");
INSERT INTO aca_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Néenee ruá'a miyácauca rutúwa éewidaca'ee ruwítee, rumá'ee Heródesru: —Jiá nulí áabai mitájia rícu, liá'a liwítami liá'a Juan Bautístaca, nacábaque'ini. ");
INSERT INTO aca_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Linácueji liwána máashii wérri liwówa liá'a rey Heródesca; ne jiníwata arrúnaa licúmplia liá'a limánimica nanáneewa náa'a limáidanica, liwána náa rulíni. ");
INSERT INTO aca_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Libánua báqueerri soldado nawíchua Juan wáa cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Jáiwa natée liwítamica báji mitájia rícu náa rulí jíni ruá'a miyácauca, jáiwa rutée jíni rutúwarru. ");
INSERT INTO aca_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Néenee náiinu náa'a jínanenaicoo Juan yáajcha, natée limáashiicaimi nabáyaque'ini, liáwinaami náawai náiiwacani Jesúsru jíni. ");
INSERT INTO aca_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesús éemi'inaa liéni chuánshica liáu lancha rícu náajcha náa'a éebidenaicoo liájcha, liáu chaléeni báawachala. Ne chóniwenai éemi'inaa jíni, jáiwa najiáwai chacáalee rícucha, quéewique'e náacoo lijúnta macáshtai. ");
INSERT INTO aca_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Jesús jiá'inau lancha rícucha, licába chóniwenai íchabani, carrúni jináata licába nayá, jáiwa lichúni náa'a bálinenaicoo natéenica. ");
INSERT INTO aca_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Jái'inaa samásamai liácuwai, náa'a lishínaa éewidenaicoo narrúniu namá'ee lirrú: —Jái táicalacai, liáni júshiquitawa áani. Jíiwana náacoo náa'a chóniwenaica, náaque'iu nawéni náayau lirrícula liá'a chacáalee júbininica. ");
INSERT INTO aca_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Jesús éeba'ee nalí: —Jócai arrúnaa náacoo; yáa náaya iyá. ");
INSERT INTO aca_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Néenee néeba'ee lirrú: —Wawáalia áani bácai cinco páani rími ya chámacua cubái. ");
INSERT INTO aca_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Jesús má'ee nalí: —Índa nulíni ájini áani. ");
INSERT INTO aca_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Néenee liwána náa'a chóniwenai máanabanaamica nawáaque'iu imíshi íta'aa. Jáiwa liwína licáaji rícu náa'a cinco páanica ya náa'a chámacua cubáica, licába áacairra, liá sáicai Diosru, litúcueda liá'a páanica, ya náa'a cubáica; liá jíni lishínaa éewidenaicoorru, nayá nashírridaque'ini chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Quinínama náaya cáashia cáawai wérri nayá, ya újnibii nacámusheda doce canasta lishídanaami máaquerricoo. ");
INSERT INTO aca_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Namáanabaca náa'a íyenaica cinco mil washiálicuenai nayáwoo, jócani jútada íina ya sáamanai lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Liáwinaami, Jesús bánua náa'a lishínaa éewidenaicoo náurrucocoo lancha rícula, nachuáque'iu bajiála manuá libéecha, nácula líiwa lináwau nalí náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Jái'inaa líiwa lináawau nalí náa'a chóniwenaica, Jesús líirrau áabai dúuli ítala quéewique'e lióraca bácai. Líinu'inaa liá'a catáwacabeeca yéeirri néeni bácai, ");
INSERT INTO aca_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","nácula liá'a lanchaca jái yáacuwai déecuchala litácoowa yúcha. Liá'a marrádacaca íinuerri lancha nácula cadánani, jiníwata cáuli íinuerri najúnta. ");
INSERT INTO aca_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Jái'inaa újni cátai Jesús jíinau najúnta shiátai náani nácu. ");
INSERT INTO aca_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nacába'inaateni lishínaa éewidenaicoo lijínacoo shiátai náninacu, nacáarrudau wérri, namáidada nacáarruniu namá'ee: —¡Wówanaashimi chái jínacoo! ");
INSERT INTO aca_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ne Jesús táania nalí, limá'ee: —¡Ya iwówau cadánani, nuyácani, ucáarru iyá! ");
INSERT INTO aca_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Néenee Pé'eru éeba'ee lirrú: —Nuwácali, jiyáquictani, jiwána nujínacoo jiyáctala shiátai náani nácu. ");
INSERT INTO aca_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","—Jesús má'ee lirrú: —Jíinu chérra. Néenee Pé'eru yúrrucoo barco rícucha, jáiwa lichána lijínacoo shiátai náani nácu Jesús yáctalaca. ");
INSERT INTO aca_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ne licába'inaa náa'a marrádaca ya cáuli máanui wérriyu, jáiwa cáarru jíni; jái'inaa liwówai liájuacuwai, jáiwa limáidadai: —¡Jiwáseda nuyá, nuwácali! ");
INSERT INTO aca_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Liyáalimi'e Jesús wína licáaji nácui, limá'ee lirrú: —¡Jiyá jócai máacai jiwówau nunácu sáica! ¿Tánda jócu jéebida nuyá wásedeerri jiyá? ");
INSERT INTO aca_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Náirra'inaamiwai lancha rícula, machúnucunaa liá'a cáulica. ");
INSERT INTO aca_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Néenee liyáali, náa'a yáainai lancha rícu, jáiwa natúyau náurrui juátamiyu Jesús náneewa, namá'ee lirrú: —¡Yáawaiyi jiyá Dios Cúulee! ");
INSERT INTO aca_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Nachuáu bajiála manuá, jáiwa náiinuque'e lishínaa cáinabi ítala liá'a Genesaret. ");
INSERT INTO aca_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Náa'a chóniwenai néeni sánaca nacúnusia nacába liá'a Jesúsca, lichuáni licáarraliau quinínama liá'a cáinabica. Natée Jesúsru náa'a bálinenaicoo, ");
INSERT INTO aca_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ya namésuda'ee liwówa namá'ee lirrú jínda nadúnu líibala númacua nácu cadánia; ya quinínama náa'a dúnuenaicani, sáicani máacacoo. ");
INSERT INTO aca_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Narrúniu Jesúsru áabibi fariséobini ya áabibi quéewidacani ley shínaa, íinuenai Jerusalén néenee, ya nasáta néemiu liyá: ");
INSERT INTO aca_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","—¿Tánda jishínaa éewidenaicoo jócu néewida nawítee náa'a wawérrinaimica? ¿Ya tánda jócu nacúmplia nawítee nabádeda nacáajiu quéecha jóctanaa náaya, chaléjta nawánau'i naméda náa'a wawérrinaibimica? ");
INSERT INTO aca_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Jesús má'ee nalí: —Iyá jócani arrúnaa yáasacalaca náa'a éewidenaicoo nuájcha, níwata iyá iméda máashii mawí, ne iyá jócani méda Dios chuáni wánacaala, imédaque'e chaléja limáyu'u liá'a iwíteeca. ");
INSERT INTO aca_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Jiníwata Dios má'ee: ‘Cawáunta jiyá jitúya jisálijinau ya jitúwa,’ ya ‘liá'a máashii núma lisálijinaa nácu, ya litúwa nácu lécchoo, arrúnai'inaa náiinuaca.’ ");
INSERT INTO aca_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ne iyá máinai yáawaa báqueerri washiálicuerri éewerri limá lisálijinaarru jócta litúwarru: ‘Jócu nuéewa nuyúda jiyá, jiníwata liá'a nuwáaliani quinínama nuáni'inaa Diosru’; ");
INSERT INTO aca_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ya tánashia máirri liáni, jócai éewa liyúda lisálijinau jócta litúwa. Chacábacanaa iyá jócani éewida Dios chuáni, quéewique'e iméda léjta iwítee wówau'ca. ");
INSERT INTO aca_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","¡Iyá chámaini iwítee! Sáicai litáania liá'a Isaíasca íiwadedeerrimi Dios chuáni báinacu, limá'inaami inácu iyá: ");
INSERT INTO aca_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Náani chóniwenaica éebidenai nanúmayu cháji'i, ne nawówa déecuchai yáa núcha. ");
INSERT INTO aca_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Jiní wéni báawita naméda culto nulí; ne éewida nuchuáni nácu, ya éewida liá'a napénsanica namáta náa'a nawánacaalactaca, ne liyáwoo washiálicuenai chuáni bácai.’ ");
INSERT INTO aca_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jáiwa Jesús máida náa'a chóniwenaica, limá'ee: —Éemini ya yáa léenaa: ");
INSERT INTO aca_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Liá'a wárruerricoo washiálicuerri núma lícueji, jócai wána casácula liwówa. Ta léja liá'a jiérricoo washiálicuerri núma lícueji, wáneerri casácula liwówa. ");
INSERT INTO aca_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Néenee náa'a lishínaa éewidenaicoo liá'a Jesúsca narrúniu lirrú, jáiwa nasáta néemiu liyá: —¿Jiá léenaa íiwirri nawówa náa'a fariséoca néemi'inaa liáni jimánica? ");
INSERT INTO aca_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Jesús éeba'ee limá'ee nalí liyú liáni licábacanaaca: —Nusálijinaa liá'a yáairri áacairra, liúcaminaa bináawala quinínama náa'a éewidenai méenaami yáairri báawachala yáawaiyi yúcha, chaléjta liá'a cáabanacaica léerrua liúca quinínama lijíchu yáajchau náa'a banácali jócani liáabana. ");
INSERT INTO aca_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Imáacani, matuíyii liérra chái tée áabi matuíyii. Ne báqueerri matuíyii técta báqueerri matuíyii, chámatanaa nacáacoo útawi rícula. ");
INSERT INTO aca_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Néenee Pé'eru ma Jesúsru: —Jichúni jíiwadeda walí liá'a jimánica. ");
INSERT INTO aca_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Jesús éeba'ee: —Nuyá máashii wówa níwata iyá jócu yáa léenaa liá'a nuéewidanica. ");
INSERT INTO aca_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Iyá arrúnaa yáa léenaa liá'a quinínama wárruerricoo wanúma lícu, yáairriu wáayacua rícula, qéewique'e liáwinaami lijiáu wáiibicha. ");
INSERT INTO aca_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ne lijiérricoo linúma lícueji, jiérriu liwówa lícueji liá'a washiálicuerrica, léwa liérra chái wána casácula liyá. ");
INSERT INTO aca_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Níwata liwówa liá'a washiálicuerrica najiáu náa'a máashii liwíteeca, liá'a náiinua'inaaca, namáa washiálicuerri yáajcha jócai náanirri, ya íinetoo rumáa washiálicuerri yáajcha jócai rúnirri; camédacani máashii náiinaayu, náa'a nédishica, nanúma yúwica, ya liá'a nacáitauca. ");
INSERT INTO aca_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Léewa liéni wáneerri casácula liá'a washiálicuerrica; ne náayacta ya jócu nacúmplia nabádeda nacáajiu, jócai wána casácula liyá. ");
INSERT INTO aca_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesús yáau chéni Genesaret néenee liáque'iu cáinabi Tiro ya Sidón néerra. ");
INSERT INTO aca_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Báquetoo íinetoo Caná néenee sáu, yéechoo líta'aa liá'a cáinabica jí'ineerri Tiro, ruíinu Jesúsru rumáidadaca: —¡Nuwácali, David táqueerrimi, carrúni jináata jicába nuyá! ¡Numíyacaula wáalechoo áabai espíritu máashii méderri rulí máashii! ");
INSERT INTO aca_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Jesús jócai éeba ruchuáni. Néenee lishínaa éewidenaicoo rúniu lirrú, nasáta'ee liúcha: —Jíiwa rulíni ruáque'iu wáucha ruá'a íinetooca bájialaca rumáidadaca wáishiirricu. ");
INSERT INTO aca_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Jesús má'ee: —Dios bánuerri nuyá nalí náa'a bácai náa'a chóniwenai yéenai Israel néeni, léjta oveja yúquenaicta wáni. ");
INSERT INTO aca_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ne ruá'a íinetoo ruáu rutúyacoo rúrrui juátamiyu Jesúsru, rumá lirrú'e: —¡Nuwácali, jiyúda nuyá! ");
INSERT INTO aca_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesús éeba'ee ruchuáni: —Jócai sáicanata wéda náayanibi náa'a wéenibicoo wáaque'e nalí náa'a áulica. ");
INSERT INTO aca_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Ruyá rumá'ee: —Yáawaiyi, nuwácali; ne náa'a áulica íyenai liá'a lítabi cáirricoo nawácanai shínaa mesa yáajabala. ");
INSERT INTO aca_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Néenee Jesús ma rulí: —¡Íinetoo, máanui wérri liá'a jéebidauca! Liméda jirrú léjta jiwówauca. Liyáalimi rumíyacaula ruá'a íinetooca sáica jíni. ");
INSERT INTO aca_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Jesús jiáu néeni, jáiwa líinu á'a litácoowa liá'a lishínaa manuá liá'a Galileaca; néenee líirrau áabai dúuli ítala, jáiwa liwáawai. ");
INSERT INTO aca_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Íchaba chóniwenai yáawacau Jesúsru. Natée lirrú macáwani, matuíni, ya máacarrani cáaji, jócai éewa natáaniaca, ya áabibi wáalenai íchaba bálinacaalashi, náindani Jesús yáctalaca, jáiwa lichúni nayái. ");
INSERT INTO aca_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Tánda náa'a chóniwenaica cáarrudeneu, nacába natáaniacala náa'a jócanimi éewa natáaniaca, ya náa'a máacarrani cáaji, namáacau sáica lécchu, náa'a macáwanimica éewenai najínacoo, ya náa'a matuínica néewa nacábaca. Jáiwa nachána náa lirrú sáicai liá'a Dios chóniwenai Israel shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Jesús máida lishínaa éewidenaicoorru, limá'ee nalí: —Carrúni jináata nucába náani chóniwenaica, jiníwata nawáalia matáli éerri nayá nuájcha áani, jinícala nalí náayani'inaa. Jócu nuwówai nubánua nayá máayaca náabana néerrau, carrúnataca májina nayá iníjbaa lícu. ");
INSERT INTO aca_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Lishínaa éewidenaicoo namá'ee lirrú: —Ne ¿chíta quéewau wáiinu íyacashi áji'ani náaya náa'a chóniwenai íchabanica, líta'aa liáni júshiquitaca jinícta yáairri? ");
INSERT INTO aca_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Jesús sáta léemiu nayá: —¿Chíta máanaba páani iwáalia jíni? —Siete páani ya píitui rími cubái júbinini, —néeba'ee nayá. ");
INSERT INTO aca_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Néenee Jesús wána nawáacoo cáinabi rícu náa'a chóniwenaica, ");
INSERT INTO aca_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","jáiwa liwína jíni náa'a siete páanica ya náa'a cubái rími, jáiwa liá sáicai Diosrui, lipúrraida, jáiwa liá lishínaa éewidenaicoorru jíni, néenee nashírrida jíni nalí náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Quinínama náaya cáawaina wérri, néenee náawaqueda néenamiu liá'a máaquerricoo siete canasta liyú liá'a litábimi máaquerricoo. ");
INSERT INTO aca_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Náa'a íyenaica cuatro mil namáanabaca washiálicuenaica, jócani najútada náa'a íinaca ya sáamanai. ");
INSERT INTO aca_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Néenee Jesús íiwa lináawau nalí náa'a chóniwenaica, jáiwa líirrawai lancha rícula, jáiwa liáwai chaléeni áabai cáinabi jí'ineerri Magadán. ");
INSERT INTO aca_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Náa'a fariséobini ya náa'a saduceobini náau nacába Jesús néerra, nawówa namédaque'e lirrú áabai trampa, namá lirrú limédaque'e áabai señal jócai nacába cáji, néenedaque'i nacábawani yáawaicta íinuerri Dios néenee jíni, ne nanúma yúwicawajani. ");
INSERT INTO aca_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ne Jesús éeba'ee nalí: “Táicala imá iyájoo: ‘Sáitai'inaa liá'a éerrica, jiníwata liá'a éerrica chunídai wérri'inaa’; ");
INSERT INTO aca_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","manúlacaiba namá'ee: ‘Wáalee máashii'inaa éerri, jiníwata liá'a éerrica quíirrai ya casáculai’. Ne yácta léenaa icába liá'a éerri cábacanaa, ¿chíta quéewau'u jócu éewa yáa léenaa liá'a Dios médanica? ");
INSERT INTO aca_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Iyá chóniwenai máashiini jócani éebida yáawaiyiyu, nasáta áabai señal jócai nacába cáji; ne jócuminaa nuá irrú áabai señal mawiá léjta Jonás.” Jáiwa limáaca nayái, liáwai. ");
INSERT INTO aca_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Quéecha'inaami nabésunacoo bajiála manuá, náa'a éewidenaicoo namíya máecha natée páani. ");
INSERT INTO aca_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Néenee Jesús ma nalí: —Icábate, cáwi icába yúchau levadura fariséobini shínaaca ya saduceobinica. ");
INSERT INTO aca_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Náa'a éewidenaicoo Jesús yáajcha jócu náa léenaa néemicani limánica, táda cha namá nayá jájiu: —¡Jócuwa'ee waínda páanii! ");
INSERT INTO aca_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesús yáa léenaa nanácu, limá'ee nalí: —¿Táda imá jiníca irrú páani? ¡Píitui rími éebidaca yáawaa! ");
INSERT INTO aca_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nuyá máashii wówa níwata iyá újnibi jócai yáa léenaa éemicani nuyá éewerri numéda jócai icába cáji, jiní éedanicoo linácu liá'a cinco páani nushírridani nalí náa'a cinco mil washiálicuenaica. ¿Ya chíta máanaba canasta yáawaqueda jíni? ");
INSERT INTO aca_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","¿Jiní édacanicalau lécchoo linácu liá'a siete páani, nushírridani nalí náa'a cuatro mil, ya chíta máanaba canasta yáawaqueda jíni? ");
INSERT INTO aca_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","¿Chíta jócu yáa léenaa éemiqui jíni jóca nutáania nuyá páani nácu? Cáwi icá'a yúchau náa'a jócani éewida yáawaiyi fariséobini shínaaca ya saduceobini shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Néenee náa léenaa néemiqui jíni, Jesús jócai ma liyáca itúyaque'iu liúcha liá'a wáneerri páani múrracacoo, jócta quéewique'e cáwi nacá'a náuchau liá'a éewidacaishi nashínaa náa'a fariséobinica ya náa'a saduceobinica. ");
INSERT INTO aca_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Quéecha'inaami Jesús íinucai lítala liá'a cáinabi jí'ineerri Cesarea Filipo shínaaca, lisáta léemiu lishínaa éewidenaicoo: —¿Tána namá nunácu chái náa'a chóniwenai nuyá Washiálicuerri Dios Cúuleeca? ");
INSERT INTO aca_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Néeba'ee lichuáni: —Áabi máinei jiyácala'ee Juan Bautista cáwerriwai; áabi máinei jiyácala'ee Elías cáwerriwai, ya áabi máinei jiyácala'ee Jeremías cáwerriwai o áabimi cáiiwadedacanimi Dios chuáni báinacu cáweneu. ");
INSERT INTO aca_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","—Ya iyá, ¿tánashia imá nuyái? —Lisáta léemiu nayá. ");
INSERT INTO aca_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simón Pé'eru éeba'ee: —Jiyá waliérra, Mesíasca, liá'a Dios Cúulee cáwiica mamáarraca éerri'inaa. ");
INSERT INTO aca_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Néenee Jesús ma lirrú: —Sáicta wérri jiwówa, Simón Jonás cúulee, jiníwata jiní báqueerri washiálicuerri íiyaderri jirrú liáni, liyárrimija liá'a nusálijinaa yáairri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ne nuyá ma jirrú jiyácala Pé'eru, linácueji liáni jinísani jimáca, jicá'a áabai íiba nubárruedaque'e nushínaa iglésiau, jiníminaa máanalicai shínaa danáanshi éenaaca limárdaca nushínaa iglesia. ");
INSERT INTO aca_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Nuáminaa jirrú wánacaalashi áacai sái jicá'a áabai yáawi; liá'a jibájini líta cáinabi liáni, ne cháminaa limáacacoo libáji áacairrajoo, ne liá'a jiyá liwásedanica líta cáinabi liáni, cháminaa limáacacoo liwásedacoo áacairra. ");
INSERT INTO aca_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jáiwa Jesús bánua lishínaa éewidenaicoorru jócubeecha náiiwadeda matuínaamirru liyácala liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Liáwinaami liáni Jesús chánau líiwadeda lishínaa éewidenaicoorru, arrúnaaca'ee liácoo Jerusalénra, ya chaléeni náa'a salínai, sacerdótebini wácanai, ya qéewidacani ley shínaabinica, nawánaminaa carrúni jináata bájialanaa. Limá nalí nuyá náiinuaminaajoni, ne nucáwiaujoo matáli éerri rícula. ");
INSERT INTO aca_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Néenee Pé'eru tée liyá báawachalani, jáiwa lichánau licáita Jesús, limá lirrú: —¡Dios jócu wówai, nuwácali! ¡Liéni jócai éewa libésunacoo jiájcha! ");
INSERT INTO aca_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Jáiwa Jesús náawawai, limá Pé'erurru: —¡Jishírriu núcha, níwata jiyá pénserri ya jitáania jiyáca chaléjta limédau'u liá'a Wawásimica, linácu jiliéni jimánica carrúnata jiwánata jócu néewida nusálijinaarru! Jiyá jócai cábau léjta Dios cábau'u, jiyá cáberri léjta nacábau náa'a washiálicuenaica. ");
INSERT INTO aca_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Jáiwa, Jesús ma lishínaa éewidenaicoorru: —Tánashia wówerri nushínaa éewiderricoo, limíya máecha liyá jájiu, yéerri liyá báitanacu lirrú liá'a carrúnataica ya cáashia máanalictalacani léewaque'e líinu nuíshiirricu, chaléjta litécta áabai cruz. ");
INSERT INTO aca_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Jiníwata liá'a wówerri liwáseda licáwicau jócai amáarra, yúquerri'inau; ne liá'a yúquerri licáwicau jócai amáarra nunácueji, líinuminaa cáwicaishi jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","¿Tána liwéni lirrúi liá'a washiálicuerrica ligáanacta quinínama cáinabi, ya liúca licáwicau jócai amáarra jóca limédau chaléjta éewidenaicoo nuájcha? ¿O chíta máanaba léenaa lipáida liá'a washiálicuerri licáwica jócai amáarra nácuejiu? Jiní wérri léewa liwárruacoo áacairra báawita lipáidaca. ");
INSERT INTO aca_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Tándawa, yáau nuíshiirricu báawita libésunacoo liá'a bésuneerri'inaacoo, jiníwata nuyá Washiálicuerri Dios Cúuleeca, nuíinuminaa nusálijinaa wítee yáajchau ya nushínaa ángelbinica, ya néenee nupáidaminaa bácainaa tánashia namédanii. ");
INSERT INTO aca_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ne yáawaiyi numá irrú, áabi yáainai áani jócuminaa máanali nayá, cáashia nacába nuyá Washiálicuerri Dios Cúulee nuíinu nuwánacaalaca. ");
INSERT INTO aca_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Seis éerri liáwinaami, Jesús tée liájchau Pé'eru, Santiago ya Juan Santiago éenajirrica, ya liáu náajcha báawachala áabai dúuli áacai wérri ítala. ");
INSERT INTO aca_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Néeni libáwachau nanáneewa licábacanau liá'a Jesúsca. Lináni quéneerri jicá'a cáiwia, ya líibala náawerriu cabálaiyu jicá'a jucámarrabee. ");
INSERT INTO aca_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Liyáali nacába Moisés ya Elías táanianai nayá Jesús yáajcha. ");
INSERT INTO aca_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Pé'eru má'ee Jesúsru: —Nuwácali, ¡sáicai wérri wayá áani! Jiwówaicta, waméda'a matálii cuíta rími; áabai jirrú sái'inaa, áabai Moisésru, ya áabai Elíasru. ");
INSERT INTO aca_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nácula Pé'eru táania liyáca, áabai sáanai quirrámini lirríjcueda nayá catámuabeeyu, líibee sáanaica áabai chuánshi jiáu, máirri nalí: “Léewa nucúulee caníinai nucábaca, liérra nuwínanica, éemiu lirrú.” ");
INSERT INTO aca_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Néemi'inaamini liáni, náa'a éewidenaicoo natúyau náurrui juátamiyu, náa nanániu cáinabi nácula, cáarru wérri nayá. ");
INSERT INTO aca_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Jáiwa Jesús rúniu nalí, lidúnu nanácu limá'ee nalí: —Ibárroo, ucáarru iyá. ");
INSERT INTO aca_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Quéecha'inaami nacábacani, jiní néeni Moisés ya Elías, Jesús bácai yáa néeni. ");
INSERT INTO aca_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Nácula náurrucoo dúuli ítacha, Jesús ma nalí: —Jiníqui béecha náiiwadeda rúni liá'a nacábanica, cáashia nuyá Washiálicuerri Dios Cúuleeca cáwiacoo máanalini íibicha. ");
INSERT INTO aca_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Néenee náa'a éewidenaicoo nasáta'ee néemiu Jesús: —¿Tánda namá náa'a quéewidacani ley shínaaca Elías íinucala'ee libéechalawau liá'a Mesíasca? ");
INSERT INTO aca_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Jesús éeba'ee: —Yáawaiyi báqueerri léjta Elías íinuca quéechanacu, ne liyáminaajoo lipréparaminaa nawówa nayá quinínamajoo. ");
INSERT INTO aca_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ne nuyá ma irrú Elías jái nísa líinucai, ne nayá jócu nacúnusia nacábaque'e jíni, ne naméda liájcha máashii quinínama liá'a nawówaini naméda lirrú. Chacábacanaa nuyá Washiálicuerri Dios Cúuleeca, nusúfria nacáaji rícujoo. ");
INSERT INTO aca_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Néenee lishínaa éewidenaicoo yáa léenaa néemica, Jesús táaniaca liyá Juan Bautista nácucha, litáania'inaa liyáca jicá'a Elías. ");
INSERT INTO aca_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Náiinu'inaami Jesús ya matálitai éewidenaicoo liájcha néerra báaniu chóniwenai yáctala ya náa'a áabi éewidenaicoo liájcha, báqueerri washiálicuerri rúniu Jesúsru, túyerriu lináneewa limá lirrú: ");
INSERT INTO aca_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","—Nuwácali, carrúni jináata jicába nucúulee, súfrierri bájiala liwáaliaca espíritu máashii, wánacaleerri liyá, jiníwata íchabachu licáacoo chichái rícula, jócta shiátai yáacula lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Áani nuínda nalíni náa'a jishínaa éewidenaicoo, ne jócai néenaa nachúnica. ");
INSERT INTO aca_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Jáiwa Jesús éeba jíni: —¡Wóo, iyá chóniwenai jócani éebida, ya máashiicani! ¿Chacálita arrúnaa nuyá yáajcha jíni? ¿Chacálita arrúnaa nuwánta yáajcha jíni? Índa nulí áani liérra icúlirrijuica. ");
INSERT INTO aca_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Néenee Jesús licáita jíni liá'a espíritu máashii ya jáiwa liwána lijiácuwai icúlirrijui yúcha, jáiwa limáacau sáicai liyáalimi. ");
INSERT INTO aca_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Liáwinaami náa'a lishínaa éewidenaicoo linácu natáania liájcha báawacha Jesús, jáiwa nasáta néemiu jíni: —¿Tánda jócu wéenaa wajéda liá'a espíritu máashii wayá? ");
INSERT INTO aca_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Néenee Jesús ma nalí: —Iyá jócani éenaa ijéda bináawalani liá'a espíritu máashii, níwata jócala éebida Dios dánaniyu éewa imédacani. Yáawaiyii numá irrú, iwáaliactata liá'a éebidauca, áawita píitui rími léjta áabai ítashi íimi rími jí'ineerri mostaza, néenee éewa imá lirrú liáni dúulica: ‘Jishírroo chérra, ya jiáu báawachala’, ya dúuli lishírroominau. Yácta léenaa éebidaca, éewa iméda quinínama.  ");
INSERT INTO aca_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ne liérra licábacanaa espíritu máashiica, jócai najiáu jócta na'óraa Dios ya nayúnaca. ");
INSERT INTO aca_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Nácula lijínaniu náajcha líta'aa liá'a cáinabi Galilea shínaaca, Jesús má'ee nalí: —Nuyá Washiálicuerri Dios Cúuleeca, néejuedani'inaa nacáaji rícu'inaa nalí náa'a washiálicuenai, ");
INSERT INTO aca_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ya náiinuaminaa nuyájoo; ne matálii éerri ricúla nucáwiaujoo. Néemi'inaami liá'a chuánshi limáni nalí, máashii wérri nawówai. ");
INSERT INTO aca_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Quéecha'inaami Jesús ya lishínaa éewidenaicoo íinu Capernaúmra, náa'a cóbrenai impuesto templorru, náuu nacába Pé'eru, jáiwa nasáta néemiu liyá: —¿Ishínaa quéewidacai lipáida impuesto templorru? ");
INSERT INTO aca_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Pé'eru éeba'ee: —Jajá, lipáidani. Jáiwa, Pé'eru wárroo'inaamiu cuíta lícula, Jesús táania'ee lirrú quéechanacu, limá'ee lirrú: —¿Chíta jimáqui jíni, Simón? ¿Tána yúcha nacobra impuesto ya náawaqueda yúcha náa'a reyebini cáinabi íta'aa sánaca: Náa'a chúnsana ásana áani o náweji náa'a bájirra cáinabi ítee sánaca? ");
INSERT INTO aca_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Pé'eru éeba'ee lirrú: —Náa'a bájirra cáinabi ítee sánaca. Jesús má'ee mawí: —Cháwajani náa'a chúnsana ásana áani, jócani rúnaa páidaca. ");
INSERT INTO aca_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ne, jiníqui béecha wáucani chuáni, jiá namówai jitésuca manuála, jiúca jicúlupaniu úniacula, ya jijéda quéechanacu sái cubái wíneerri jirrú. Linúma lícu liá'a cubáica jíinuminaajoo áabai moneda, liyáminaa éenaa lipáida impuesto nushínaaca ya jishínaa, jitéeyuni jiáu jipáidaca. ");
INSERT INTO aca_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Liyáalimi éerri náa'a éewidenaicoo rúniu Jesúsru, nasáta'ee néemiwani: —¿Tána mawí cawéni wérri cái Dios médacta jiyá reyyu? ");
INSERT INTO aca_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Néenee Jesús máida báqueerri samálita, libárrueda nalí béewamini, ");
INSERT INTO aca_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ya limá'ee: —Yáawaiyi numá irrú, jóctaca ináawida iwíteu ya éejoo jicá'a liéni samálitaca, jócuminaa éewa iwárruacoo Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Liá'a mawí cawéni wérri Dios wánacaalactalaca, liyáwa arrúnaa imíyai limédacoo, ya limédactau jicá'a liéni samálitaca níwata náa'a sáamanaica jócani pénsaa nayáca cawénini náiibi náa'a máanui namánica. ");
INSERT INTO aca_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ya liá'a ríshibierri nují'inaa nácu báqueerri samálita léjta liéni, lirríshibiaminaa nuyá lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Matuínaami tánashia wáneerri nacáacoo jíconaashi rícula, bácai náani júbini éebidenai nunácu, mawíminata cawéni lirrú náajuedactatani dujíwala wérri manuá yáacula, áabai íibayu máanui wérri molino shínaa, nabájini liwáa nácu. ");
INSERT INTO aca_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","¡Tándawa máashii wérri náani chóniwenai yáainai cáinabi íta'aa íchabacala máida naméda najíconau! Chái'inaa mamáarraca, ne ¡carrúni jináatai rími liá'a washiálicuerri wáneerri naméda najíconau áabica, súfrierri'inaa mawí bájialanaa castíguca! ");
INSERT INTO aca_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Lítala mawí, jicáajicta o jíiba wána jicáacoo jíconaashi rícula, ujiméda máashii, jicá'a liá'a jiwíchuani ya jiúca jiúchau déecuchalani, mawí sáicaca jiwárrocoo áacairra macáaji o máiba, ne jócubeecha jiáu chámainaa jicáaji ya jíiba, jiácoo chichái rícula jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Jituícta wána jicáacoo jíconaashi rícula, ujiméda máashii, jicá'a jijéda jiúchau ya jiúca déecuchalani, mawí sáicaca jiwárruacoo cáwicashi rícula, bátui jituí yáajchau, ne jócubeecha jiáu chámai jituí yáajchau infierno rícula. ");
INSERT INTO aca_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Jiní icháanini náani júbini rímica. Ne numá irrú, áacairra nashínaa ángelbini yáainai séewirri nusálijinaa náneewa áacairra.  ");
INSERT INTO aca_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Jiníwata nuyá Washiálicuerri Dios Cúuleeca, íinuerri nuwásedaca náa'a yúquenaimicoo nayáca. ");
INSERT INTO aca_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“¿Chíta icábaqui jiníni? Báqueerricta washiálicuerri wáaliacta cien oveja, ya áabai yúquerriu liúcha, ¿jócuminaata limáaca náa'a noventa nueve awáca íibi, liáque'iu limúrru ruá'a áabai oveja jiáchocoo liúcha? ");
INSERT INTO aca_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ne léenactata líinu runácu, ne yáawaiyi sáictai wérricta liwówa runácue ruárra ovejaca, náucha náa'a noventa nueveca jócani yúcau. ");
INSERT INTO aca_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Cháwa cábacanaa lécchoo liá'a Isálijinaaca yáairri áacairra, jócai wówai náucacoo liúcha naáani júbinini rímica. ");
INSERT INTO aca_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Ne jéenajirri médacta jirrú máashii, jitáania liájcha bácai, ya jiwána liá léenaa lijíconau. Ne limédacta jiwánacaala, jái jigáana liá'a jéenajirricoo. ");
INSERT INTO aca_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ne jócta liméda jiwánacaala, jimáida jiájchau báqueerri o chámata chóniwenai mawí, quéewique'e quinínama náa lijíconaa, limáaque'iu chámata o matálitai chóniwenai náneewa náa'a yáainai léenaa linácu. ");
INSERT INTO aca_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ne jócta liméda nawánacaala lécchoo, íiwa nalíni náa'a iglesia ísanaca éebidenai Dios chuáni; ne jócta liméda iglesia wánacaala, néeneeminaa imáacani léjta jócai éebida Dios nácu, o léjta náa'a cóbrenai impuesto Romarru. ");
INSERT INTO aca_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Yáawaiyi numá irrú, liá'a ibájini mayéji áani cáinabi íteeji, lécchoo chalé'inaa ya áacairra, ne quinínama liá'a iwásedani mayéji áani cáinabi íteeji, cháminaa cábacanaa liwásacoo áacairra. ");
INSERT INTO aca_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Liéni numá irrú: Ne chámata iyá, áabeenacta iwówa cáinabi íta'aa, quéewique'e isáta máayabaca oraciónyu, nusálijinaa yáairri áacairra, liáminaa irrúni. ");
INSERT INTO aca_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Níwata chámata o matálitai yáawacactacoo nují'inaa nácu, néeniminaa nuyá béewami nalí, néemique'e nalí ya nusátaque'e Dios nanácu. ");
INSERT INTO aca_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Néenee Pé'eru yáau lisáta léemiu Jesús: —Nuwácali, ¿chíta máanabachu arrúnaa nupérdonaa nuéenajirriu méderricta nulí máashii mamáarracani? ¿Sietechu limáanabaca? ");
INSERT INTO aca_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Néenee Jesús éeba'ee: —Jócai numá jirrú siétechucalani, numá jirrú setentachu siete namáanabaca. ");
INSERT INTO aca_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Numéda irrú áabai licábacanaa quéewique'e yáa léenaa tánda iyá arrúnaa ipérdonaa liá'a méderri máashii irrú. “Liá'a Dios wánacaalactalaca, chái cábacanaa léjta báqueerri rey wówerri liméda cuenta lishínaa tráawajadorbini yáajchau. ");
INSERT INTO aca_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wáali'inaate liméda liyáca, quéecha'inaami náayada lirrú báqueerri mówinierri máanui wérri millones. ");
INSERT INTO aca_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ne liá'a catráawajaacai quiníyu léenaa lipáidaca, jáiwa liá'a reyca liwána nawénda liyái léjta esclavo, chámatanaa líinu yáajcha, ya léenibi, ya quinínama liá'a liwáalianica, quéewique'e limáacacoo páiderriu limówiniacalau. ");
INSERT INTO aca_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Liá'a catráawajaacaica, jáiwa litúyawai liúrrui juátamiyu lináneewa liá'a reyca, ya lisáta liúcha cáiwinaa, limá'ee: ‘Nuwácali, carrúni jináata jicába nuyá, mátaminaa nupáida jirrú quinínamani.’ ");
INSERT INTO aca_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Néenee liá'a reyca, jáiwa carrúni jináata licábaqui jíni, jáiwa lipérdonaa liúcha quinínama liá'a limówinianica, jócu liwána liácuwai cuíta manúmai rículai. ");
INSERT INTO aca_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Ne quéecha'inaami lijiácoo, liá'a mówinierrimica, jáiwa lijúnta báqueerri lijúnicai yáajcha, limówinierri lirrú píitui rími warrúwa. Jáiwa liwína liwáa nácui, lichána lisácumedacani, ta limá lirrúi: ‘¡Jipáida nuyá liá'a jimówinianica!’ ");
INSERT INTO aca_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Ne liá'a lijúnicaica, litúyau liúrrui juátamiyu lináneewa, limá'ee lirrú cáiwinaa: ‘Carrúni jináata jicába nuyá, mátaminaa nupáida jirrú quinínamajoni.’ ");
INSERT INTO aca_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Ne liá'a lijúnicaica jócu liwówai lipérdonaa liúcha jíni, jáiwa liwána naníquiqui jíni cuíta manúmai rícula, cáashia lipáida limówiniacalau lirrú. ");
INSERT INTO aca_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Jáiwa cáiwi liyá nalí náa'a áabi tráawajadorbinica rey shínaa, náau náiiwa reyrru quinínama liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Néenee rey wána namáida liyái, jáiwa limá lirrúi: ‘¡Máashiicai jiyá! Nupérdonaa jiúcha quinínama liá'a jimówinianimica, jiníwata jisátawa núchani cáiwinaa. ");
INSERT INTO aca_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Ne jiyá lécchoo éewerricta carrúni jináata jicábacani liá'a jijúnicaica, chacábacanaa léjta carrúni jináata nucába jiyá lécchoo.’ ");
INSERT INTO aca_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Néenee íiwirri wérri liwówa liá'a reyca, jáiwa liwána nacástigaa cáiwinaa jíni, cáashia lipáida quinínama liá'a limówiniacalacoo.” ");
INSERT INTO aca_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Jesús má'ee nalí mawí: —Cháminaa cábacanaa liméda yáajcha liá'a nusálijinaa yáairri áacairra, jóctaca bácainaa ipérdonaa iwówa yáajchau éenajirriu. ");
INSERT INTO aca_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Liáwinaami limá quinínama liáni, Jesús yáau Galilea néenee, jáiwa líinu Judea shínaa cáinabi ítala, yéerri Jordán nácue cáiwia jiáctejcoo. ");
INSERT INTO aca_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Íchaba chóniwenai yáau liájcha, néeni lichúni náa'a bálinenaicoo. ");
INSERT INTO aca_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Áabi fariséobini narrúniu Jesúsru, quéewique'e naméda lirrú áabai trampa, ne nasáta néemiu liyá: —¿Léewaminau báqueerri máaca líinu matuínaami nácueji? ");
INSERT INTO aca_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Jesús éeba'ee nalí: —Léjta iyájani iliá Dios chuáni rícueji, arrúnaa yáa léenaa jái'inaa Dios liquénuda chóniwenai, liyá liquénuda báqueerri washiálicuerri, néenee liméda báquetoo íinetoo quéewique'e líinucani liá'a washiálicuerri. ");
INSERT INTO aca_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Jáiwa limá'ee: ‘Tándawa, liá'a washiálicuerrica lishírriminau lisálijinaa yúchau ya litúwa, quéewique'e lirrúnicoo líinu yáajchau, ne nayá namédaminau léjta bácai rími chóniwerri.’ ");
INSERT INTO aca_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Tándawa, jócu chámata nayá mawiá, Dios náneewa nayá léjta bácai rími. Tándawa liá'a washiálicuerri jócu arrúnaa lishírrida liá'a Dios rúndanica. ");
INSERT INTO aca_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Nayá nasáta néemiu liyá: —¿Ne tánda libánua Moisés liá'a washiálicuerri liwówai limáaca líinu, liyá liá lirrú ruá'a líinuca, áabai cáashta quéewique'e limáaca ruyái ya libánuacani? ");
INSERT INTO aca_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Jesús má'ee nalí: —Tándawa, jócala iwówai éebida Dios chuáni, Moisés wána imáaca ruá'a íinuca; ne quéechanacumi jócaimi chárra. ");
INSERT INTO aca_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Numá irrú liá'a máaquerri líinu, jócaita linácui ruyá médechoo máashii báqueerri washiálicuerri yáajcha, ya liyá licásau báquetoo yáajcha, liméda máashii líinayu. Ya liá'a éederri líinu máaquechoo rúnirriu, liméda máashii líinayu lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Namá lirrú éewidenaicoo: —Cháctaca libésunacoo liáni washiálicuerri líinu yáajchau, jócai sáicanata léda líinuu. ");
INSERT INTO aca_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Jesús éeba'ee nalí: —Jócai quinínama néewa náa léenaa linácu liáni, ne nayá rími yáa léenaa néemicani náa'a Dios wánani náa léenaani. ");
INSERT INTO aca_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Ne ái íchaba nácueji liá'a jócai índa washiálicuenai múrru náiinu: Áabi jiániu méewi, táda jócu arrúnaa cáinu nayá; ya áabi náa'a washiálicuenai jócu naínda néewa namúrru náiinu náijudaca nayá máashiiyu, áabi yáainai léjta jócani éewoo linácueji liá'a Dios wánacaalactalaca. Náa'a éewenai cáinuca nacásaque'iu, ne náa'a éewenai nayá bácai, nayáque'e cha járra. ");
INSERT INTO aca_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Natée áabi sáamanai Jesúsru, quéewique'e lichánaa licáajiu nanácu ya lióraque'e nanácu; ne náa'a éewidenaicoo, jáiwa nachánau nacáita náa'a téenai nayá. ");
INSERT INTO aca_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Néenee Jesús ma nalí: —Imáaca náiinu nulí náa'a sáamanaica, u'imáisania núchani, jiníwata liá'a wánacaalactaca Dios shínaa, cháni léjta náa'a éebidenai Dios nácu léjta sáamanaica. ");
INSERT INTO aca_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Jáiwa Jesús chánaa licáajiu nanácui náa'a sáamanaica, jáiwa liáu náuchai néeneeji. ");
INSERT INTO aca_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Báqueerri icúlirrijui yáau licába Jesús, ya lisáta léemiwani: —Quéewidacai, ¿Tána sáicai arrúnaa numédacai nuwáaliaque'e liá'a cáwicashi jócai amáarra? ");
INSERT INTO aca_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Jesús éeba'ee lirrú: —¿Tánda jisáta jéemiu nuyá linácu liá'a sáicaica? Liá'a sáicaica bácairrimi, Dios. Ne jiwówaicta jiwárruacoo cáwicashi jócai amáarra, jicúmplia náa'a wánacaalashi Dios máacanica Moisés nácueji. ");
INSERT INTO aca_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","—¿Tána jiliá? —Lisáta léemiu liá'a icúlirrijuica. Ya Jesús ma lirrúi: —‘Ujíinua, ujiméda máashii jíinayu, ujinédu; ujiméda jinúma yúwicau újnii áabi nácueji, ");
INSERT INTO aca_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","cawáunta jiyúda jisálijinau ya jitúwa, ya caníinaa jicába jiyácchuniu, léjta caníinau jicába jiyá jájiu.’ ");
INSERT INTO aca_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","—Quinínama liérra jái nunísa numédacai, —limá liá'a icúlirrijuica—. ¿Tána cháucta mawí numédacai? ");
INSERT INTO aca_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Jesús éeba lirrú: —Jiwówaicta machácani jiyá, jiáu jiwénda liá'a jiwáalianica ya jiá nalíni náa'a carrúni jináatanica. Cháminaa jiwáalia jirrícucau áacairra. Néenee jíinu jiáu nuíshiirricu. ");
INSERT INTO aca_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Néenee léemi'inaami liáni liá'a icúlirrijuica, jáiwa liáawai máashiita liwówa, jiníwata bájialai rícuerrica, ya jócute liwówai liá lirrícucau nalí náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Néenee Jesús ma lishínaa éewidenaicoorru: —Yáawaiyi numá irrú, tráawajuminaa nalí náa'a rícubinica namáaca Dios wánacaala nacáwica. ");
INSERT INTO aca_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Nuéejoo numá irrú, áabai caméeyu jócai léewa libésunacoo lituí rícu liá'a áabai ishíduica, ne mawí tráawajuca báqueerri rícuerrirru léewa liwárruacoo Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Néemi'inaamini, náa'a lishínaa éewidenaicoo mawí nacáarrudacoo néemicani, ya namá'ee: —¿Néenee tána éewa liwásedacai? ");
INSERT INTO aca_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Jesús cába'ee nalí ya léeba'ee: —Washiálicuenairru liéni jócaiminaa néenaa namédaca, ne Dios jócai, Dios éewerri liméda quinínama. ");
INSERT INTO aca_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Néenee Pé'eru má'ee Jesúsru: —Wayá máaquenai quinínama liá'a wawáalianimica, quéewique'e wáacoo jíshiirricu, ¿tána'inaa warríshibia? ");
INSERT INTO aca_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Jesús éeba'ee nalí: —Ne yáawaiyi numá irrú, jáictaminaa líinu liyáali éerri quinínama wáaliiminaajoni, jáicta nuyá Washiálicuerri Dios Cúuleeca, nuwáau nuárrubaishi balíbali íta'aajoo, iyáminaa íinuenai nuíshiirricu, iwáaminau léquichoo doce yáarrubaishi, quéewique'e iwánacaala náa'a doce tribu Israel shínaaca. ");
INSERT INTO aca_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Ne quinínama náa'a máaquenai nunácueji náabanau, o néenajinai, o néenajetoo, o nasálijinaa, ya natúwa, o néenibi, o cáinabi, narríshibiaminaa cien máanabachu mawí liá'a namáacadanica, ya lécchoo narríshibiaminaa cáwicashi jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ne íchaba chóque'e náa'a cawéninica, jócani'inaa cawéni, ya náa'a mawéninica chóque'e, nayáminaa cawénini'inaa. ");
INSERT INTO aca_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Liá'a Dios wánacaalactalaca chái cábacanaa jicá'a báqueerri finca wácali, lijiáu manúlacaiba wérri limúrru tráawajadorbini quéewique'e natráawajaa lishínaa uva yáanai íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Líinu'inaami nanácui náa'a tráawajadorbini, lichúni liwéni náajcha áabai éerriquictacani, ya ta libánua natráawajaacai lishínaa uva yáanai íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Liáwinaami léejoo lijiácoo las nueve manúlacaiba, jáiwa licába áabi yáainai nayá plaza rícu, jiníni médani nayáca. ");
INSERT INTO aca_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Néenee limá nalí: ‘Yáau iyá lécchoo itráawajaaca nushínaa uva yáanai ítala, máta nupáida iyá sáicai.’ Jáiwa náawai natráawajaaca. ");
INSERT INTO aca_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Uva wácalica léejoo lijiácoo wíyaicumi, ya las tres táicala léejoo lijiácoo lécchoo, chacábacanaa léejoo liméda náajcha. ");
INSERT INTO aca_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Léejoo lijiácoo plaza néerra las cinco táicala rími, jáiwa licába áabi bániwai jiníni médani nayáca, lisáta léemiu nayá: ‘¿Tánda iyá áani éerri yáajinaa jócani tráawajaa?’ ");
INSERT INTO aca_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Néenee néeba lirrú: ‘Níwata jiní íinuerri litáa wáajcha.’ Néenee limá nalí: ‘Yáayu iyá lécchoo itráawajaa nushínaa uva yáanai ítala.’ ");
INSERT INTO aca_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Jái'inaa táayebee íinui, liwácali máida lishínaa wánacaleerri náa'a tráawajadorbinica, limá lirrú: ‘Jimáida náa'a tráawajadorbinica ya ta jipáidaqui jíni, quéechanacu náa'a wárruenaicoo natráawajaa amáarractalacani, ya liáwinaami náajcha náa'a wárruenaimicoo quéechanacu.’ ");
INSERT INTO aca_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ne náiinu'inaa éenaa, wárruenaimicoo natráawajaa las cinco táicala rími, ya ta narríshibia nawéniwai áabenaa áabai éerriquictacani. ");
INSERT INTO aca_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Liáwinaami náiinu'inaa náa'a wárruenaimicoo natráawajaa quéechanacu, napénsaa nalíwoo narríshibiacala'inaa mawí, ne bácainaa nayá narríshibia nawéniu áabai éerriquictacani. ");
INSERT INTO aca_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Nacóbra'inaamini nachánau namúnumunuacoo linácula liá'a nawácalica, ");
INSERT INTO aca_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","namá'ee: ‘Náani íinuenaimi éerri éenaami nácu, natráawajaa áabai rími hóraa, jiyá páidenai nayá áabenaa wáajcha, wayá wántenai liá'a tráawajo ya cáiwia amuá quinínama éerri.’ ");
INSERT INTO aca_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Ne liá'a chúnsai nawácalica léeba'ee báqueerri chuáni: ‘Nujúnicai, jiní máashii numédani nuyá jirrú. ¿Jócute wachúni liwéni liá'a áabai éerri jitráawajaani nulí? ");
INSERT INTO aca_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ya jiwína jiwéniu ya jiá namówai. Ne nuwówaicta nupáida liéni wárruerricoo litráawajaa hóraa éenami nácu, áabenaa léjta nupáidau jiyá, ");
INSERT INTO aca_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","léewa nuwówau'u numédaca nuwárruani yáajchau. ¿O cadéniwee jiyá sáicacala nuyá?’ ");
INSERT INTO aca_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Chái'inaa cábacanaa léjta Dios yá'inaa nawéni náa'a chóniwenai áacairra; chóque'e náa'a cawéninica, liáwinaami'inaa jócai cawéni, ya chóque'e jiníni wéni, liáwinaami cawéniminaa nayá. ");
INSERT INTO aca_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Liáwinaami Jesús lijínau liácoo iníjbaa lícu Jerusalén néerra'inaa, limáida báawachala lishínaa éewidenaicoo ya limá'ee nalí: ");
INSERT INTO aca_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","—Léjta icábau'ini, chócaja'a wáau Jerusalén néerraminaa, nuyá Washiálicuerri Dios Cúuleeca, néentregaaminaa nuyá nalí náa'a sacerdótebini wácanaica, ya nalí náa'a quéewidacani ley shínaa, máine'inaa arrúnaaca náiinua nuyá, ");
INSERT INTO aca_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ya néejuedaminaa nuyá nalí náa'a bájirra cáinabi ítesanaca, quéewique'e nacáida nacábau nuyá, ya náiinueda nuyá, ya nacuájidaque'e nuyá cruz nácu; ne matálii éerri rícula nucáwiaminaujoo máanalicai yúcha. ");
INSERT INTO aca_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Natúwa náa'a Zebedeo éenibica, náajcha náa'a ruéenibica rurrúniu Jesúsru, jáiwa rutúyau lináneewai rusátaque'e liúcha áabai sáicai. ");
INSERT INTO aca_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Jesús sáta léemiu ruyá: —¿Tána jiwówai? Rumá'ee lirrú: —Jiwána nawáacoo náani nuéenibica chaléeni jiwánacaalactalaca, nawáacoo báqueerri sáicaquictejica ya báqueerri apáulicue jiájchau. ");
INSERT INTO aca_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Jesús éeba'ee nalí: —Iyá jócani yáa léenaa isátanica. ¿Ya éewaminaa isúfria chaléjta nusúfriau'inaa? Néenee namá'ee lirrú: —Wéewani. ");
INSERT INTO aca_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Jesús éeba'ee: —Iyá yáawani'inaa isúfriaca léjta nuyá, ne liá'a wáairri'inaacoo nuémanacu sáicaquictejica o apáulicueji, jócai arrúnaa nuyá yáa irrú, liyáminaa yáa nalíni náa'a nusálijinaa chúninica. ");
INSERT INTO aca_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Quéecha'inaami néemicani náa'a áabi diez éewidenaicoo liájcha, jáiwa íiwirri nawówai náa'a chámataca léenajinaica. ");
INSERT INTO aca_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ne Jesús máida nalí limá'ee: —Léjta yáayu léenaani, náiibi náa'a jócani éebida Dios nácu, nawácanai wánacaleenai máashii náa'a nashínaa chóniwenaica, ya náa'a nawácanaica mawíni máanuica, sáictani wánacaala áabibi. ");
INSERT INTO aca_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ne íibicha jócai éewa chácaarra. Arrúnaa báawatacani, íibicha iyá tánashia wówerri máanui limédacoo Dios náneewa, arrúnaa lisírbia quinínamarru. ");
INSERT INTO aca_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ne liá'a íibicha iyá, tánashia wówerri quéechanacu sái'inaa, arrúnaa línda nawánacaala liyá. ");
INSERT INTO aca_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Iyá arrúnaa éenueda nuyá, báawita nuyá Washiálicuerri Dios Cúuleeca, jócai nuíinu quéewique'e nasírbia nulí, nuyá íinuerri nusírbiaque'e nalí, ya máanali nuyá quéewique'e nuwáseda íchaba jíconaa. ");
INSERT INTO aca_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Najiá'inaamiu nayá Jericó rícucha, íchaba chóniwenai náau Jesús íshiirricu. ");
INSERT INTO aca_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Chámata matuíni wáaineu nayáca iníjbaa éema nácu, néemi'inaami Jesús bésunacoo, namáidada'ee: —¡Wawácali, David táqueerrimi, carrúni jináata jicába wayá! ");
INSERT INTO aca_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Náa'a chóniwenai nacáita nayá quéewique'e manúmata, ne nayá namáidada mawí cadánani: —¡Wawácali, David táqueerrimi, carrúni jináata jicába wayá! ");
INSERT INTO aca_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Néenee Jesús bárruawai, limáida náa'a matuínica lisáta léemiu nayá: —¿Tána iwówai numéda irrúi? ");
INSERT INTO aca_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Néeba'ee lirrú: —Wawácali, wéejuaque'iu wacába báaniu. ");
INSERT INTO aca_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Jesús carrúni jináata licába nayái, jáiwa lidúnu natuí. Liyáalimi náa'a matuínica néewa nacába báaniu, ya ta náacoo Jesús íshiirricui. ");
INSERT INTO aca_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Quéecha'inaami urrúni nayá Jerusalénru, liá'a Jesúsca náa'a lishínaa éewidenaicoo yáajchau, náiinu'inaa'ee áabai chacáaleerru jí'ineerri Betfagé, yéerri áabai dúuli yáajba jí'ineerri Olivos, Jesús bánua chámata lishínaa éewidenaicoo liájcha, ");
INSERT INTO aca_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","limá'ee nalí: —Yáau chaléeni lirrícula liá'a chacáalee rímica yéerri wajúntami. Néenimichu íinu runácujoo áabai burro nabájini rucúulee yáajchau. Iwáseda wáajooni índa nulíjoni rucúulee yáajchaujoo. ");
INSERT INTO aca_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Áicta báqueerri máni irrú já'a, imáwa lirrújoo, Wawácali rúnaani, liyáalimi léejuedanijoo. ");
INSERT INTO aca_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Liéni bésuneerricoo quéewique'e licúmpliacoo léjta limáyu'u liá'a íiwadedeerri Dios chuáni báinacumi, litána'inaamica: ");
INSERT INTO aca_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Imá nalí chóniwenaica yéenai lirrícu liá'a chacáaleeca jí'ineerri Sión: ‘Icábateni, ishínaa Rey íinuerri liácoo irrú, imíyayu, íirrerriu burro íta'aa, áabai burro rími, licúulee liá'a cuésherri cadúcunibee shínanaaca.’ ” ");
INSERT INTO aca_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Néenee náa'eewoowai náa'a lishínaa éewidenaicoo naméda'ee lirrú léjta Jesús bánua'u nayá, ");
INSERT INTO aca_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Natée'e ruá'a búrroca rucúulee yáajchau, namáaca náabalau líta'aa, jáiwa Jesús wáa'eewoo líta'aa liá'a búrroca. ");
INSERT INTO aca_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Íchaba wérri chóniwenai. Áabibi nadáquinieda'ee nashínaa capa iníjbaa lícu, ya áabi nawíchueda'ee cushíbai báinaa ya áicuba náacai nadáquinieda iníjbaa lícu. ");
INSERT INTO aca_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Náa'a chóniwenai yáainecoo libéecha ya náa'a íinuenai líshiirricu namáidada'ee namá'ee: —¡Wáa lirrú sáicai liá'a Rey David táqueerrimi! ¡Sáicai wérri bájialanaa liá'a íinuerrica lijí'inaa nácu Wawácali! ¡Wáa lirrú cawéni wérri liá'a yáairri áacairra! ");
INSERT INTO aca_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Jesús wárrua'inaa'eewoo Jerusalén rícula, quinínama chóniwenai chacáalee rícu sánaca nacáarralia'eewau, ya íchaba nasáta néemiu: —¿Tána léji liáni? ");
INSERT INTO aca_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Néenee náa'a chóniwenaica néeba'ee: —Léwa Jesús íiwadedeerri Dios chuáni, Nazaret sái wáalierra yéerri Galilea rícu. ");
INSERT INTO aca_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Jesús wárroo templo rícula, jáiwa lijéda náa'a wéndenai nayáca ya náa'a wénenai nayáca. Lináawida nashínaa mesa náa'a cámbianai nayá warrúwa chóniwenairru, ya náarrubai náa'a wéndenai palomas; ");
INSERT INTO aca_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ya limá nalí: —Á'a Dios chuáni íta'aa limá: ‘Núbana jí'ineerriminaa cuíta oración shínanaa’, ne iyá médenaini áabai cuíta chaléjta canédibini íibana. ");
INSERT INTO aca_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Narrúniu Jesúsru templo rícula, náa'a matuínica, ya náa'a macáwanica, jáiwa lichúni nayái. ");
INSERT INTO aca_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ne quéecha'inaami náa'a nawácanai sacerdótebinica ya éewidenaica ley shínaaca, nacába jócai nacába cáji limédanica, ya néemi sáamanai máidada templo rícu, namá'ee: “¡Wáa lirrú sáicai liá'a David táqueerrimi!”, jáiwa íiwirri nawówai éemiqui jíni, ");
INSERT INTO aca_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ya namá'ee Jesúsru: —¿Jéemi jiyá liá'a namáni náa'a sáamanaica? Jesús éeba'ee nachuáni: —Jajá, nuéemini. Ne ¿jócu iliá icábau Dios chuáni litáaniacta nanácu náani sáamanaica? Limá chá'a: ‘Náa'a sáamanai júbinica, ya náa'a quirrácua újnibii, narrábaminaa sáicai wérri jirrújoo,’ ");
INSERT INTO aca_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Néenee limáaca nayái, jáiwa liáu chacáalee rícuchai Betania néerra, libésuneda táayebee. ");
INSERT INTO aca_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Manúlacaiba, Jesús éejoo'inaami chacáalee rícula, jáiwa ínaaishi lirrúi. ");
INSERT INTO aca_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Licába'inaami áabai higuera urrúni iníjbaa, jáiwa lirrúniu néerrai, ne líinu liyáwoo libáinaa. Néenee limá higuérarrui: —¡Jiníminaa jéejoo jiá jítau mawiá! Ne liyáalimi míishii liá'a higuéramica. ");
INSERT INTO aca_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nacába'inaami liá'a bésuneerricoo, nacáarruda'eewoo náa'a éewidenaicoo, nasáta'ee néemiu Jesúsru: —¿Chíta quéewoo míishii higuérami madéjcanaa jíni? ");
INSERT INTO aca_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Jesús éeba'ee nalí: —Ne yáawaiyi numá irrú, éebidacta yáawaiyi, ya jócu éejueda iwówau, jócai bábaujuta éewa iméda liéni numédani higuera yáajcha, éenaminaa iméda mawíyi liájcha liáni dúulica imácta lirrú: ‘Cachéerra jichácau manuá yáacula’, ya cháminaa libésunacoo irrú. ");
INSERT INTO aca_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Ne quinínama iyá isátacta i'óracoo ya éebidani, cháminaa limédacoo irrú léjta isátau'uni. ");
INSERT INTO aca_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Liáwinaami liáni, Jesús wárroo templo rícula. Nácula léewida liyá néeni narrúniu lirrú náa'a nawácanai náa'a sacerdótebinica ya náa'a salínai judíobinica, nasáta néemiu wáni: —¿Tána wánacaalashiyu jiméda léji liéni? ¿Tána yáa jirrú wánacaalashi? ");
INSERT INTO aca_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Jesús éeba'ee nalí: —Nuyá lécchoo nusáta nuéemiu iyá áabai chuánshi nácu: ¿Tána bánua Juan báutisacai, Dios o washiálicuenai? Ne éewacta éeba nuchuáni, nuyá lécchoo nuíiwaminaa irrú tánashia wánacaalashiyu numéda léji liéni. ");
INSERT INTO aca_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Jáiwa nachánau najútacoo nalí wáacuwai, namá'ee: “Ne wamácta lirrú Dios bánuani Juan, limáminaajoo walí: ‘Néenee, ¿ne tánda jócai éebida lirrúi?’ ");
INSERT INTO aca_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Jiní wéewaca wamá washiálicuenai, jiníwata cáarru wacába náa'a chóniwenaica, jiníwata quinínama éebidenai Juan táaniacala Dios chuáni rícueji.” ");
INSERT INTO aca_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Jáiwa néeba'ee Jesúsrui: —Jócu wáa léenaa. Néenee Jesús éebai: —Ya nuyá cha já'a jóca nuéewa irrú tánashia wánacaalashiyu numéda léji liéni. ");
INSERT INTO aca_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesús sáta'ee léemiu nayá: —¿Chíta liyáyu'u irrú léji liéni? Báqueerri washiálicuerri wáalierri chámata licúuleu, jáiwa limá báqueerrirru: ‘Nucúulee, jiáu wáalee jitráawajaa nushínaa uva yáanai ítala.’ ");
INSERT INTO aca_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Jáiwa licúulee éeba'ee lirrú: ‘¡Jócu nuwówai nuáacoo!’ Ne liáwinaami lipénsaa lirrúwoo báaniu, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Jáiwa lisálijinaa yáau linácula liá'a báqueerrica, néenee limá lirrú chacábacanaa. Néenee léeba lisálijinaa chuániwai: ‘Jajá, nusálijinaa, nuáaminaujoo.’ Ne jócu liáwai. ");
INSERT INTO aca_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","¿Tána náji náani chámataca méderri lisálijinaa liwówainica? —Liá'a quéechanacu sáica, néeba'ee Jesúsru. Néenee Jesús má'ee nalí: —Yáawaiyi numá irrú, náa'a cóbrenai impuesto Romarru, ya náa'a rúmbaca, wárruenai'inau Dios wánacaalactalaca liárrumirra'inaa iyáca. ");
INSERT INTO aca_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Jiníwata Juan liá'a Bautístaca íinuerri léewida chítashia arrúnau'inau iyáqui jíni, ne iyá jócu éebida lirrúi; ne ta nája náa'a cóbrenai impuesto ya náa'a rúmbaca éebidenai lichuáni. Ne iyá, áawita icába quinínama liáni, jócu éenaa ináawida iwíteu quéewique'e éebida lirrú. ");
INSERT INTO aca_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesús má'ee nalí: “Éemiu áabai licábacanaa báaniu: Báqueerri finca wácali, liáabana áabai shínaashi uva yáanai ya ta lirríjcueda litéejii, lichúni áabai yáarrushi limédacta'inaa vino, ya libárrueda áabai torre quéewique'e litúyacani lishínaa shínaashi. Néenee limáaca nalí liá'a cáinabi shínaashi áabi tráawajadorbinica, quéewique'e natráawajaacani ya nashírri lishínaa éenaa lirrú, jáiwa liáwai áabai viaje. ");
INSERT INTO aca_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Quéecha'inaami líinucai éerri salírriquicta quinínama liá'a lishínaa shínaashica, jáiwa libánua áabi náa'a shírruedenai lirrú, nasátaque'e lirrú náucha náa'a tráawajadorbinica liá'a léenaa liá'a lishínaa shínaashica. ");
INSERT INTO aca_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ne náa'a tráawajadorbinica, jáiwa nawína náaji náa'a shírruedenai lirrú: ya ta náiinueda báqueerri, ya náiinua báqueerri, ya báqueerri náiinueda íibayu. ");
INSERT INTO aca_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Néenee liwácali liá'a shínaashica, léejoo libánua mawí shírruedenai lirrú quéechasanami yúcha; ne náa'a tráawajadorbinica, jáiwa naméda náajcha léjta licábacanaa. ");
INSERT INTO aca_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","“Ne liáwinaami ya ta libánua chúnsai licúuleewai, limá lirrúwoo: ‘Yáawaiyiiminaa nucúulee cawáuntai ya páiderri lirrú.’ ");
INSERT INTO aca_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ne nacába'inaami licúulee íinuca, náa'a tráawajadorbinica namá nalí wáacoo: ‘Léwa licúulee liá'a shínaashi wácalica, lé'inawaa máaquerriu lirrúwoo liájcha liá'a shínaashica; wáiinuani quéewique'e wamáacacoo liájcha liáni cáinabica.’ ");
INSERT INTO aca_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Jáiwa nawína jíni, najéda shínaashi ítacha jíni, ya ta náiinuaqui jíni. ");
INSERT INTO aca_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ya chóque'e, jáicta líinu liá'a shínaashi wácalica, ¿tána imá irrúwoowai tánashia liméda náajcha jinárra tráawajadorbini máashiinica?” ");
INSERT INTO aca_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Néeba'ee Jesúsru: —Jócuminaa carrúni jináata licába nayá, líinuaminaa nayá limáashiicayu, ne táminaa liá áabi tráawajadorbinirru liá'a shínaashimica, yáaine'inaa lishínaa shínaashi éenaa lirrú, jáicta léerdi nawína lítai. ");
INSERT INTO aca_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Néenee Jesús má'ee nalí: —¿Jócai cáji iliá icábau Dios chuáni cáashta íta'aa? Limá'ee: ‘Liá'a íibaca nacháaninimi náa'a camédacani cuíta, náawerriu íiba quéechanacu sáiyu. Liáni limédani liá'a wawácalica, tándawa wayá cáarrudenaiu.’ ");
INSERT INTO aca_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Jiníwata iyá yáasacalaca nuyá nuíiwa irrú, léedacala'inau yúcha liá'a Dios wánacaalactalaca, ya táminaa liá nalíni náa'a chóniwenaica namédenai léjta Dios wówainica.  ");
INSERT INTO aca_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ne linácu liá'a íibaca, tánashia cáirriu linácula limáacani lishídanaamiyu, ne íibacta cáu báqueerri íta'aa, limédaminaa pucúpucunani. ");
INSERT INTO aca_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Náa'a nawácanai náa'a sacerdótebini ya fariséobinica, néemi'inaami náa'a licábacanaa Jesús íiwadedani liyáca, jáiwa náa léenaa néemicani litáania liyá nanácu. ");
INSERT INTO aca_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Néenee nawówai nawína Jesús preso, ne cáarru nayá, jiníwata náa'a chóniwenai éebidenai Jesús báqueerri cáiiwadedacai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesús lichána litáania nalí báaniu, limá'ee nalí: Nanácu náa'a chóniwenai jócai ríshibia Dios wánacaalactaca chaléjta liwówau'u, nuá irrú áabai licábacanaa: ");
INSERT INTO aca_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Liá'a Dios wánacaalactalaca chái jicá'a liá'a báqueerri rey méderri áabai sáictacta nawówa cáserricoo licúulee shínaa. ");
INSERT INTO aca_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Libánua lishínaa náa'a shírruedenai lirrú náaque'iu namáida náa'a nawánani íinuca, ne náani jócu nawówai náacuwai. ");
INSERT INTO aca_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Léejoo libánua áabi lishínaa shírruedenai lirrú, licárgueda nalí: ‘Imá nalí náa'a wamáidanica, jáica wanísa waméda íyacaishii. Nuwánacaala náiinua pacáa ya cuéshinai quéenanica, ya quinínama jái yácai; quéewique'e náiinu licásactalacoo.’ ");
INSERT INTO aca_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Ne náa'a náanicoo namáidaca jócu naméda nawánacaala. Báqueerri néenaa yáau lishínaa cáinabi ítala, báqueerri yáau liwéndaque'e lishínau, ");
INSERT INTO aca_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ne náa'a áabica jáiwa nawína náa'a shírruedenai reyrru, jáiwa náiinueda jíni cáashia náiinua nayá. ");
INSERT INTO aca_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Néenee liá'a reyca íiwirri liwówa bájiala, jáiwa libánua lishínaa soldado náiinuaque'e'inaa cáiinuacanica ya néema nashínaa chacáalee. ");
INSERT INTO aca_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Jáiwa limá nalí náa'a lishínaa shírruedenai lirrú: ‘Quinínama jái yácai cáserri'inaacoo, ne náa'a wamáidanica jócani sáicanata íinuca. ");
INSERT INTO aca_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Yáa namówai iyá, cáaye cawéni mawí, imáida quinínama náa'a tánashia íinuni nácui cáserricoo.’ ");
INSERT INTO aca_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Náa'a shírruedenai lirrú liá'a nawácali sáictacta nawówa, najiáu cáaye rícula, jáiwa náawaqueda quinínama náa'a náiinuni nácu, náa'a máashiinica ya náa'a sáicanica, jáiwa cashiámu chóniwenaiyu liá'a cuítaca. ");
INSERT INTO aca_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Jáiwa liwárrua'inaamiu liá'a reyca licába náa'a namáidanica fiestarru, ya licába báqueerri washiálicuerri jócai yáau íibalashi rícu liwárruaque'iu nacásactalacoo. ");
INSERT INTO aca_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Liá'a rey sáta'ee léemiu: ‘Nujúnicai, ¿chíta quéewoo'u jiwárruacoo áji áani, jiyá jócai íinu íibalashi cáserricoo shínanaaca?’ Ne liá'a washiálicuerrica manúma'ee liyá. ");
INSERT INTO aca_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Néenee rey má'ee nalí náa'a shírruedenai mesa nácula: ‘Ibáji líiba ya licáaji, yúca bináawala catáwacactalaca, néeniminaa lícha lirrúwoo liámueda léu cáiwinaa.’ ");
INSERT INTO aca_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jiníwata Dios máida íchaba chóniwenai, ne áulabaniminaa náa'a liwínanica.” ");
INSERT INTO aca_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Liáwinaami liáni, náa'a fariséobini nacúmida yáacau, quéewique'e nawána Jesús cácoo áabai máashictaca, quéewique'e néewa náa lijíconaa. ");
INSERT INTO aca_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Néenee nabánua'ee áabi nashínaa chóniwenai náajcha, náajcha náa'a chóniwenai Herodes shínaaca, quéewique'e namá lirrú: —Quéewidacai, wáa léenaa jimánica yáawaiyi, ya jéewidacala yáawaa léjta Dios wówau'u wayáca, jóca jiméda nawánacaala náa'a chóniwenaica léjta namáyu'u, jiníwata jócai jicába náa'a washiálicuenai máanuini cábacoo, áabebactani jicábaca. ");
INSERT INTO aca_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Jíiwate walí, chítashia jimáyu jíni: ¿Sáicai wérri wapáidacta impuesto lirrú liá'a romano wácali jí'ineerri César, o jócuwee wapáida? ");
INSERT INTO aca_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Jesús, yá'inaami léenaa nashínaa nawítee máashiica natéenica, limá'ee nalí: —Chámai wítee, ¿Tánda imáaca nulí trampa? ");
INSERT INTO aca_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Íyada nulí liá'a moneda ipáidaniyu impuesto. Jáiwa naínda lirrúi áabai moneda jí'ineerri denario. ");
INSERT INTO aca_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Néenee Jesús sáta léemiu nayái: —¿Tána náani léji liéni yáairri moneda nácu, ya lijí'inaa tánerricoo áani? ");
INSERT INTO aca_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Néeba'ee Jesúsru: —Liwácali liá'a Romaca, jí'ineerri César. Néenee Jesús ma nalí: —Ne yáa lirrú liá'a Roma wácalirru liá'a lisátanica, ya yáa Diosru liá'a lisátanica. ");
INSERT INTO aca_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Néemi'inaami liá'a Jesús mánica, jáiwa nacáarrudau néemiqui jíni, ne lishínaa léebau'u jócu línda náa lijíconaa. ");
INSERT INTO aca_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Liyáali éerrimi, áabi chóniwenai jí'ineenai saduceobini, náau nacába Jesús. Náa'a saduceobinica namá'ee jiní nacáwiactau náa'a máanalinica; tánda náiiwa Jesúsru liá'a bésuneerrimiteu náiibi: ");
INSERT INTO aca_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","—Quéewidacai, Moisés máirrite báqueerricta máanali, ya jócu limáaca licúuleu, léenajirri arrúnaa liwína líinu ruá'a máanali íinirri, liáque'e licúulee liá'a léenajirri máanalica, quéewique'e náa'a chóniwenai nacába léjta licúulee liá'a máanalica. ");
INSERT INTO aca_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Ne sáicai, áani wáiibi, áija'a siete néenajinai wáacoo. Liá'a natátanica lédate líinu, jáiwa máanali jíni. Ne jócala liwáalia licúuleu, limáaca ruá'a máanirriuca léenajirri líshimirru. ");
INSERT INTO aca_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Chacábacanaa libésunacoo líshimica, ya liáwinaami matálitai yáajcha, ya chacábacanaa cáashia máanali náa'a sieteca néenajinai. ");
INSERT INTO aca_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ne liáwinaami quinínama máanali lécchu ruá'a íinetoomica. ");
INSERT INTO aca_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ne sáicai, jáicta nacáwiawai náju náa'a máanalinimica, ¿tána'inaa chúnsai rúnirri róju ruáni íinetooca, jiníwata quinínamanimi rúnirrica náani siete néenajinai yáacau? ");
INSERT INTO aca_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Jesús éeba'ee nalí: —Iyá yúquenaiu iyáca, jiníwata jócani yáa léenaa liá'a Dios chuánica, jiní icúnusiacala lécchoo Dios wítee quéewique'e licáweda máanalini. ");
INSERT INTO aca_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Jáicta máanalinimi cáwiaujoo, náa'a washiálicuenai ya náa'a íinaca jócuminaa nacásau mawiá, ne cháminaa nayá léjta ángelbini yáainai áacairra. ");
INSERT INTO aca_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ne nanácu náa'a máanalini cáwienai'inaacoo, ¿jócu iliá iyá Diosja chuáni limáctaca: ");
INSERT INTO aca_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Nuyáwa liá'a Diosca Abrahám shínaaca, ya Isaac ya Jacob’? ¡Ya Dios jócai máanali shínaa, Dios nashínaa náa'a cáwinica, áawita máanalini nayá cáwiniyaca! ");
INSERT INTO aca_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Néemi'inaami liéni, náa'a chóniwenaica nacáarrudau namáacacoo néemi Jesús éewidacala. ");
INSERT INTO aca_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Náa'a fariséobinica náawaca'eewoo ná'inaami léenaa Jesús wána manúma namáacacoo náa'a saduceobinica. ");
INSERT INTO aca_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ne báqueerri néenaa náa'a quéewidacai ley shínaaca, quéewique'e limáaca áabai trampa Jesúsru, limá'ee: ");
INSERT INTO aca_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","—Quéewidacai, ¿tánawa wánacaalashi mawíyii cawénicai líta'aa liá'a leyca? ");
INSERT INTO aca_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Jesús má'ee lirrú: —‘Caníinaa jicába Jiwácali Dios quinínama jiwówa yáajchau, ya quinínama jicáwica yáajchau, ya quinínama jiwítee yáajchau.’ ");
INSERT INTO aca_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Léwa mawí cawéniyi liéni ya quéechanacu sái wánacaalashica. ");
INSERT INTO aca_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ya liá'a áabaica atéwai chacábacanaa léjta liáni; limá cha: ‘Caníinaa jicába jiyácchuniu léjta caníinau'u jicába jiyá jájiu.’ ");
INSERT INTO aca_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Liéni chámai wánacaalashica léwa cawénii ley íta'aa, ya le néewidau'unaa íiwadedenai Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Nácula náawacau újnibi náa'a fariséobinica, ");
INSERT INTO aca_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","Jesús sáta'ee léemiu nayá: —¿Chíta imá irrúwoo jíni linácueji liá'a Mesíasca? ¿Tána nasálijinaa báinacu sáimi rícueji líinui? Néeba'ee lichuáni: —Íinuerri wawérrinaimi David éenibi rícueji. ");
INSERT INTO aca_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Néenee Jesús má'ee nalí: —¿Ta quéewoo Espíritu Santo wítabee rícueji, David, limá lirrú nuwácali? Jiníwata David má'ee: ");
INSERT INTO aca_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Dios má'ee nuwácalirru liá'a Mesíasca: Jiwáayuu nuéema nácu sáicaquictejica, cáashia numáaca jijínai jíiba yáajbeji quéewique'e naméda léjta jiwówau'u.’ ");
INSERT INTO aca_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","¿Chíta qéewau Mesías íinu David éenibi rícueji jíni, Davídmija ma lirrú nuwácali? Néenee liá'a Mesías jócai éewa báacai David táqueerrica. Liyá arrúnaa mawí cawénica David yúcha. ");
INSERT INTO aca_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jiní éeneerri léeba áabai chuánshi lirrú, ne liyáali éerrimi, jiní yáairri liwówau lisáta léemiu mawiá jíni. ");
INSERT INTO aca_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Liáwinaami quinínama liáni, Jesús má'ee nalí náa'a chóniwenaica ya lishínaa éewidenaicoo liájcha: ");
INSERT INTO aca_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Náa'a quéewidacanica ley shínaaca ya fariséobini, wáalianai néewidaque'e ya náiiwa Moisés shínaa ley. ");
INSERT INTO aca_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Tándawa éewida nalí iyá ya iméda quinínama liá'a namánica; ne u'iwína nawítee, jiníwata nayá namá áabai chuánshi, ne nayá naméda áabai. ");
INSERT INTO aca_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Éewidenai wánacaalashi nácu liá'a tráawajui wérri naméda'inaa, ne nayá jiní wérri namédani nacúmpliani'inaa; chaléjta liá'a méderri cadúcuni máanui wéerri, náaque'ini naséjcu íta'aa náa'a áabica, ne nayá jócai nawówai nadúnu báju nacáajiyu. ");
INSERT INTO aca_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Quinínama naméda liéni quéewique'e chóniwenai cába nayá. Chacábacanaa, nabústani natéeca nanáni íta'aa ya naná nácu Dios chuáni, tánerriu ya naníquini náusacai rícuu nabájidani naná nácu manújirrai cínta íimanaayu; ya nabústa nasúwaca náabalau sáictai díirrirri lichílinaa máanui yáajchau manújirrai númacua. ");
INSERT INTO aca_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Wówenai nawáalia náarru sáictacta'inaa náayactaca, ya yáarrubaishi quéecha nácu sáica ya cawéni wérri sinagoga rícu, ");
INSERT INTO aca_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ya wówenai quéewique'e chóniwenai ta nalí cawáunta cáaye rícuba ya namáque'e irrú quéewidacanica. ");
INSERT INTO aca_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ne iyá jócani arrúnaa iméda liáni, quéewique'e chóniwenai máida irrú quéewidacanica, jiníwata iyá quinínama éenajinai wáacoo, wáalianai bácairrimi quéewidacai. ");
INSERT INTO aca_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ya iyá u'imá áabirru nusálijinaa cáinabi íta'aa sánaca, jiníwata iyá wáalienai bácairrimi isálijinau: Liá'a Dios yáairri áacairra. ");
INSERT INTO aca_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Jiní imédacala quéewique'e namá irrú wawácali, jiníwata nuyá Cristo bácairrimi iwácalica. ");
INSERT INTO aca_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Bácainaa iyá wówenai quéewique'e Dios cába iyá cawéniyu, arrúnaa ishírrueda nalí náa'a áabica. ");
INSERT INTO aca_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Jiníwata liá'a mawí máanui médacoo jiyá jájiu, léwa jiní'inaa wéni liérra; ne liá'a imíyai médacoo, liyá'inaawa máanui liérra. ");
INSERT INTO aca_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaaca ya fariséobinica, chámaini wítee!, báyeenai linúma liá'a Dios wánacaalactaca, quéewique'e jócu néewa nawárruacoo náa'a áabica. Jiní iwárruacalau iyá jájiu, jiní índaca nawárruacoo náa'a wówenai namédacani.  ");
INSERT INTO aca_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaaca ya fariséobinica, chámaini wítee!, jiníwata éedacala rúbana náa'a máanirriuca, ya quéewique'e áabi pénsaa sáica inácueji, imédaca oración machénii. Tándawa linácu jiliéni irríshibiaminaajoo máanui wéerri liá'a carrúnataica. ");
INSERT INTO aca_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaaca ya fariséobinica, chámaini wítee!, iyá iméda quinínama liá'a éenanica, quéewique'e igáanaa báqueerri irrúwoo, ne jáicta inísa imédaqui jíni, imédaminau liá'a chóniwerrica, chámaichu mawí sáicaminaata liácoo infierno rícula, chaléjta iyá jájiu. ");
INSERT INTO aca_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“¡Ái iyája, carrúni jináatani'inaa, jicá'a náa'a matuínica jínedenai náa'a chóniwenaica!, imá'ee: ‘Báqueerricta liméda áabai promesa, lijúracoo templo nácula, jócai'inaa cawéni lirrú; jócta liméda liá'a limánica, ne ta lijúractau oro nácu yáairri templo nácu, néeneeminaa ta cha cawéni lirrújani.’ ");
INSERT INTO aca_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","¡Iyá mawíteeni ya léjta matuíni! ¿Tána mawí cawénicai: liá'a óroca o léwee jiliá'a templo, wáneerri oro máacacoo madúnucunai Diosru? Arrúnaa yáa léenaa liá'a templo mawí cawénica. ");
INSERT INTO aca_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Iyá máinai lécchoo: ‘Báqueerricta ma liá'a limédani'inaa, lijúractau altar nácu, jócai'inaa cawéni lirrú; ne ta lijúractau ofrenda yáairri altar íta'aa, néeneeminaa ta cha cawéni lirrújani.’ ");
INSERT INTO aca_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","¡Matuíni! ¿Tána mawí cawénicai, liá'a ofrendaca o léwee jiliá'a altarca, wáneerri ofrenda máacacoo madúnucanai Diosru? Arrúnaa yáa léenaa liá'a altar mawí cawénica. ");
INSERT INTO aca_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ya liá'a júlerricoo altar nácu, jócaita bábajuta júracoo altar nácu, limédani liyá quinínama yáairri altar íta'aa; ");
INSERT INTO aca_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ya liá'a júlerricoo templo nácu, jócaita bábajuta júracoo liyá templo nácu, ne jóctata lécchui Dios wánacai liá'a yáairri néeni. ");
INSERT INTO aca_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ya liá'a júlerricoo éerri nácu, júlerriu liyáca Dios yáarrubai nácu, ya Dios nácu, wáairricoo liyá liárrubai íta'au néeni. ");
INSERT INTO aca_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“¡Ái iyámi, carrúni jináatani'inaa, quéewidacanica ley shínaa ya fariséobinica, chámaini wítee!, shírrenai Diosru quinínama ishínaa banácali éenaa diezmoyu, áawita banácali píitui léjta menta ya anís ya comino éenaani yáaca, ne jócani méda liwánacaala liá'a néewidauca mawíyii cawénica ley shínaaca, léjta liá'a imédau'u sáicai quinínama, ya carrúni jináatau jicá'a áabi ya síguia machácanii iwítee. Léwa arrúnaa iméda liérra, jiní imáacacala liá'a áabata lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","¡Iyá, cajínedacani matuíni, jínedenai chóniwenai wítee, iyá léjta náa'a jíchuenai malíiwi, quéewique'e jócu íya irrúwoo wáni, ne jócai yáa léenaa íyau'u áabai cuésherri caméeyu máanui! ");
INSERT INTO aca_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaa ya fariséobinica, chámaini wítee!, iyá léjta náa'a méetuedenai baso ya mitájia íteeji, quéewique'e nacábacoo majíconaaniyu chóniwenai náneewa, ne liwówa lícu cashiámui liyú liá'a quinínama inédunica, ya liá'a éedani áabi wójunaa íteeji yawíquica iyá. ");
INSERT INTO aca_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","¡Fariseo matuíyii: quéechanacu iméetueda baso rícu, cháque'e cábacanaa masácula líteeji lécchoo! ");
INSERT INTO aca_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaa ya fariséobinica, chámaini wítee!, cháni cábacanaa léjta liá'a máanalini yáarrui nasáquedani líta'aa, sáictai litéeji, ne iwówa lícu léjta liá'a máanalini yáarruica cashiámui iyájimiyu ya íchaba cacháninabee lirrícu. ");
INSERT INTO aca_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Cháwa cábacanaa iyá jírra: íteeji íyada jicá'a náa'a sáicani chóniwenai náneewa, ne iwówa lícu cashiámui ya liyú liá'a ichálujuedauca ya áabata máashii mawí. ");
INSERT INTO aca_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“¡Ái iyája, carrúni jináatani'inaa, quéewidacanica ley shínaaca ya fariséobinica, chámaini wítee!, médenai nayájide yáarrui sáica náa'a cáiiwadedacanimi Dios chuáni báinacu, ya ichúni cuíta júbini rími cachílinani náa'a chóniwenai sáicanimica, ");
INSERT INTO aca_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ya ta imácai: ‘Wayáquictactai liyáali éerrimi cáwi'inaami wawérrinaibimi, jócaminaata wayúda náiinua náji náa'a cáiiwadedacanimi Dios chuáni báinacu.’ ");
INSERT INTO aca_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Chái cábacanaa iyá íiwactani néenibimica ya quéewidacani náa'a íinuenaimi náa'a íiwadedenai Dios chuáni báinacumi. ");
INSERT INTO aca_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","¡Inísa imédacani, náa'a iwérrinaibimi nachánanimi naméda báinacu! ");
INSERT INTO aca_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“¡Iyá máashiini wérri! Iyá carrúnatani wérri chaléjta náa'a áaica wáalierri veneno. ¿Iyá pénsenai jócu yáau infierno rícula chalée'i Dios cástigactala'inaa náa'a chóniwenai máashiinica? ");
INSERT INTO aca_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Linácue jiliéni nubánuaminaa irrú áabi cáiiwadedacani Dios chuáni, cawíteenica, ya náa'a quéewidacanica. Ne iyáminaa íinuaminaa néenajoo ya icuájida nayá cruz nácu néenaa nárra náiinuaque'ini, ya áabi nabásedami'inaa nayájoo sinagoga rícu, ya táminaa icánaqueda nayájoo chacáalee jútainchu. ");
INSERT INTO aca_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Cháminaa líinu inácujoo carrúnatai wérri, linácueji quinínama náa'a chóniwenai sáicani náiinuedanimica, rícuete náiinua Abel majíconaica, cáashia Zacarías Berequías cúulee, liá'a íinuanimica templo rícu altar éema nácu. ");
INSERT INTO aca_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ne yáawaiyi numá irrú, liá'a carrúnatai wérrica quinínama'inaa liáni nacáminau nanácu náani chóniwenai chóque'e sánaca. ");
INSERT INTO aca_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“¡Chóniwenai Jerusalén rícu sána, chóniwenai Jerusalén rícu sána, íinuenai náa'a íiwadedenai Dios chuáni ya náa'a íinuedanimi íibayu náa'a índenaimi nalí náiiwa Dios chuáni libánuacala nayá! ¡Chíta máanabachu nuwówai nuáawaqueda nayá jéenibiu, léjta ruá'a cawáamaica yáawaquedau ruéenibiu rubáinaa yáajabalau, ne nayá jócani wówai! ");
INSERT INTO aca_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ne icábate, liá'a íibanaca máaquerri'inau juíshi jinícta'inaa yáairri; ");
INSERT INTO aca_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ne numá irrú, liáwinaami liáni éerrica, jócuminaa éejoo icába nuyá mawiá, cáashia imáca: ‘¡Sáictai wérri liá'a íinuerrica lijí'inaa nácu liá'a wawácalica!’ ” ");
INSERT INTO aca_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Quéecha'inaa Jesús jiácoo templo máanui rícucha, ya yáairriu liácoo, néenee narrúniu lirrú náa'a lishínaa éewidenaicoo, nachána náyada lirrú náa'a lishínaa cuítaca máanui liá'a temploca. ");
INSERT INTO aca_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Néenee Jesús má'ee nalí: ¿Icába quinínama liáni? Yáawaiyii numá irrú, náani íiba máanuica templo shínanaaca, jócani wérri'inaa máacau nayáca nátaba wáacoo. Quinínama cáarralerri'inau. ");
INSERT INTO aca_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jáiwa náawai lítala liá'a dúuli jí'ineerri Olivos, Jesús wáairriu náajcha náa'a éewidenaicoo liájcha, ya narrúniu lirrú náa'a éewidenaicoo liájcha nasátaque'e néemiu báawachala: —Wawówai jíiwa walíni chacálitashia libésuna léji liáni. ¿Tánashia jíyada licábacanaajoo jáicta jéejoo jíinucojoo, ya amáarractala'inaa liá'a éerrica? ");
INSERT INTO aca_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Jesús éeba'ee nalí: —Cáwiwa yúchaujoo jiníbeecha chálujuedeerri iyájoo. ");
INSERT INTO aca_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Jiníwata íinujoo íchaba nují'inaa nácu, nanúma yúwicau nunácueji, namájoo: ‘Nuyáwaa liá'a Mesíasca’, ya nachálujueda'inaa íchaba chóniwenaijoo. ");
INSERT INTO aca_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Néenee éemijoo liwítama urrúni léju liá'a jináwiucojoo áani ya déecuchejijoo; ne úwa icáarrudaujoo, Dios ma arrúnaa cha libésunacoo; ne máayabaca, jócai amáarra újnibi. ");
INSERT INTO aca_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Níwata náa'a chóniwenai áabai cáinabi íta sánaca, náiinua yáacau najúnta, ya bájirra cáinabi, íinua yáacau bájirra cáinabi júnta; ya íinuminaajoo ínaaishijoo, ya cáinabi cúsuminau matuínaami. ");
INSERT INTO aca_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ne quinínama liáni píitui rími cáiwibeeca quéechanacu sái'inaa nalí náa'a chóniwenaica; néenee libésunauminaajoo áabata máashiica liwánaminaa íchaba cáiwibee. ");
INSERT INTO aca_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Néenee néejuedaminaa iyájoo náiinuedaque'e iyá; ne áabata náiinuaminaa iyájoo, ya quinínama chóniwenai máashiiminaa nacába iyájoo nunácueji. ");
INSERT INTO aca_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Liyáali éerriminaajoo íchaba chóniwenai namáacaminaa liá'a néebidauca, máashiiminaa nacába yáacacojoo, ya íchabaminaa táania nanácu wáacoo. ");
INSERT INTO aca_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Náyadaminaujoo íchabaminaa cáiiwadedacani Dios chuáni jócai yáawaiyi, ya nachálujuedaminaa íchaba chóniwenai; ");
INSERT INTO aca_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","íchabaminaa máashiijoo, tándawa íchaba chóniwenai jócu caníinaa nacába áabi. ");
INSERT INTO aca_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ne náa'a máaquerri liwówau Dios nácu mamáarracaa, nayáminaajoo Dios wásedajoo. ");
INSERT INTO aca_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Náiiwaminaa linácu liá'a chuánshi sáicaica, linácu liá'a Dios wánacaalau'uca quinínama cáinabi ítala, quéewique'e quinínama chóniwenai yáa léenaa. Néenee ta íinuminaa amáarraqui jíni. ");
INSERT INTO aca_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Daniel, litána linácu liá'a lijíconaa cacháninai wérrica. Jáicta icába jíni o éemicani á'a yáarruishi majíconai rícu —liá'a liérrica, liá léenaa—, ");
INSERT INTO aca_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","néenee tánashia yáainai Judea shínaa cáinabi ítala, quéewique'e nacánacacoo dúuli íibirra. ");
INSERT INTO aca_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Tánashia yáairri áacai líibana íta'au, ujiúrrucoo jijéda jishínau cuíta lícucha; jiá namówai ujiwárruau cuíta licúla; ");
INSERT INTO aca_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ne tánashia yáairri bacháida lícu, ujéejoo wítau liáwaqueda líibalau. ");
INSERT INTO aca_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","¡Carrúni jináata náa'a íinaca liyáali éerrica yáawirricuenaica, o náa'a júbinini éenibi írrenaica! Níwata tráawajui wérri náucha namánicoo. ");
INSERT INTO aca_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Isátau Dios yúcha, jócubeecha ijiáu icánacacoo uniábi yáaji, jiní éerdi nawówa íyabactacoo; ");
INSERT INTO aca_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Jiníwata líinuminaa áabata carrúni jináata máanui wérri, jiní chái cábacanaa rícue cáinabi, cáashia chóque'e, jiní liyácala liáwinaami. ");
INSERT INTO aca_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Ne jóctata Dios wána chúcu éerri jiliérra, jinícata wásedeerriwai; ne liwánaminaa chúcucani nanácueji'inaa liwínanica. ");
INSERT INTO aca_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Néenee áabi mácta irrú: ‘Icábateni Mesías liéni yáa áani,’ o namáweeca, ‘icábateni liá'a yáa á'a’, u'éebidani u'iméda liwánacaala. ");
INSERT INTO aca_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Jiníwata náiinuminaa náa'a Mesías jócai yáawai, ya náa'a íiwadedenai Dios chuáni jócai yáawai; ya namédaminaa máanui wérri licábacanaa ya jócai nacába cáji, quéewique'e néewacta nachálujueda áawita náa'a éebidenai Dios wínanica. ");
INSERT INTO aca_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tándawa nuíiwa irrúni libéecha libésunacoo. ");
INSERT INTO aca_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Tándawa, namácta irrú: ‘Icábateni, liá'a Mesías yáa á'a, jiníctala yáairri’, uyáu néerra; o namáwee irrú: ‘Icábateni, libáyau áani’, u'éebidani. ");
INSERT INTO aca_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Jiníwata jicá'a áabai éenu cámarraa liquénacta cáiwia jiáctejcoo cáashia liwárractalacoo, cháwa cábacanaa jáicta nuéjoojoo nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Jiníwaa táshia máanalini máashiicaimi yáctami jíni, néeni wáachuli yáawacau. Chacábacanaa, jáicta icába náani señalca, quinínama éewa yáa léenaa yáawaiyiyu nuyá íinuerri'inaa madéjcanaa. ");
INSERT INTO aca_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Cawíquinta libésunacoo liá'a éerri cacháninai wérrica, liá'a cáiwiaca lichácaminau catáwacanaa, ya quéerrica jócuminaa ruá rucáamarrau, ya sáalii cáinenau áacaiji, ya espíritu wánacaleenai áacai éerri rícu nachéchinaminau. ");
INSERT INTO aca_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Néenee nacábaminaa áacairra nácu, liá'a licábacanaa nuyá Washiálicuerri Dios Cúuleeca, nacáarrudaminau bájiala náa'a quinínama chacáalee yáairri cáinabi íta'aa, náichaminaa ya ta nacába nuyá washiálicuerri Dios Cúuleeca, íinuerri sánai íibi éerri íteeji quinínama máanui nudánani yáajchau nucáamarrayu. ");
INSERT INTO aca_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ya nubánuaminaa nushínaa ángelbiniu, quéewique'e náiinua cadánani trompeta, quéewique'e náawaqueda náa'a Dios wínanica quinínama yáainai éerri rícu, ya náa'a yáainai cáinabi íta'aa cáiwia jiáctejcoo cáashia cáiwia wárruactalacoo. ");
INSERT INTO aca_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Éewidau linácu liéni áicuba higuéraca: Jáicta icába wáalii libáinaa ya icába libáinaa páquiacoo, yáa léenaa jáica urrúni camuí. ");
INSERT INTO aca_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Cháwa cábacanaa, jáicta icába quinínama liáni, bésuneerricoo, yáa léenaa jáica urrúni nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ne yáawaiyi numá irrú, quinínama libésucala'inau liéni, jóctanaa máanali náani chóniwenaica liyáali éerri sánaca. ");
INSERT INTO aca_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Iyá éewenai iyá yáawaiyiyu quinínama liáni numáni irrú bésuneerri'inau. Liá'a éerrica ya cáinabi amáarrai'inaa, ne liá'a nuchuánica jócainaa arrúnai'inaa cúmpliacoo. ");
INSERT INTO aca_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ne liá'a éerrica, ya liá'a hóraaca jiní yáa léenaa, jiní áawita náa'a ángelbinica yáainai áacairra, báawita Licúulee. Bácairrimi liá léenaa liá'a lisálijinaaca. ");
INSERT INTO aca_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","“Léjta libésuna'inaamiu Noé éerdimica, cháwa cábacanaa lécchoo jáicta nuéejojoo nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ne liyáali éerrimi libéecha liá'a unésaca wérrica, cáashia Noé wárruacoo barco rícula, náa'a chóniwenaica náaya ya náirra ya nacásau, jócani édacaniu Dios nácu. ");
INSERT INTO aca_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ne á'a jócta naméda nayácani, líinu léji liá'a unésaca wérrimica, jáiwa litée quinínama nayái. Chái cábacanaa'inaa nacárrudau jáicta nuéejojoo nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ne liyáali éerriminaa, jócu nutée quinínama chóniwenai áacairra, bácai rími náa'a éebidenai nunácu, léjta liéni: Chámata washiálicuenai yáaminaa nayá bacháidala, báqueerriminaa natée liyájoo, ya báqueerriminaa namáaca liyájoo. ");
INSERT INTO aca_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Chámata íinaminaa júli nayá molino rícueji, báquetoominaa natée ruyájoo, ya báquetoominaa namáaca ruyájoo. ");
INSERT INTO aca_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Arrúnaa cáwi iyá iyáca, jiníwata jócai yáa léenaa liá'a éerri táshia líinu liá'a iwácalica. ");
INSERT INTO aca_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ne yáa léenaa linácu liáni, báqueerri cuíta wácali yáctata léenaa táshia hóraa táayebee líinu liá'a canédica, linéduca, cáwicata liyá cái jócata línda liwárruacoo líibana licúlai linéduca. ");
INSERT INTO aca_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Tándawa, iyá lécchoo arrúnaa iyá sáica; jiníwata nuyá Washiálicuerri Dios Cúuleeca íinuerri'inaa jócta inénda iyácani. ");
INSERT INTO aca_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“¿Tánawa léji liá'a tráawajador sáicaica cáwi wítee yáca, jáicta liwácali limáaca lirrú cuíta ísana yáaca, quéewique'e licábadeda áabi ya liá náaya léerdictaca lécchoo? ");
INSERT INTO aca_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Sáicta liá'a tráawajador liwácali máacani, jáicta líinui linácu méderri liyá léjta limáyu lirrú sáictaminaa liwówa liá'a liwácalica. ");
INSERT INTO aca_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ne yáawaiyi numá irrú, liwácali máacaminaa lirrú quinínama liá'a lishínaaca licáaji rícu. ");
INSERT INTO aca_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ne liá'a tráawajador máashiictani, ya lipénsaa lirrúwoo liwácali déecudacalau ");
INSERT INTO aca_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ya ta lichána máashii náajcha náa'a áabi tráawajadorbinica, ya ta liwína yáacacoo náajcha camáiwanaica líya náajcha ya líirraca, ");
INSERT INTO aca_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","liyáali éerri jócta linénda liyácani, ya áabai hóraa jócta liá léenaa, líinuminaa liá'a liwácalica ");
INSERT INTO aca_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ya táminaa líinueda liyájoo, carrúni jináataminaa liméda liyájoo léjta náa'a chámai wítee. Néeneeminaa líchajoo ya liámuedaminaa léujoo licáichajoo. ");
INSERT INTO aca_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Numá irrú áabai mawí linácu liá'a liyáali éerri jáicta nuéejojoo áaqueji léjta rey. Íchaba chóniwenai namá'ee nacúnusiaca nuyá, nabésunaaminau léjta nabésu náa'a diez miyácanai áabai sáictata nawówa nacásactacoo. Náa'a miyácanai nawína nashínaa lámparau acéiteyu sáica, jáiwa najiáu nashínaa cuíta najúntedaque'e liá'a nashínaacoo, ya natálideda liyá licásactalacoo. ");
INSERT INTO aca_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Cinco néenaa mawíteeni, ya cinco cáwini wítee. ");
INSERT INTO aca_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Náa'a mawíteenica natée nashínaa lámparau, ne jócu natée aceite nacámushedaque'e báaniwani; ");
INSERT INTO aca_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ne ta nája náa'a cawíteenica, natée nashínaa aceite botella rícu ya nashínaa lámpara. ");
INSERT INTO aca_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Ne lidécudacalau líinu liá'a nashínaacoo, jáiwa cadájuni nayái quinínamai, ya ta namáacai. ");
INSERT INTO aca_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Ya wówai'inaami béewami táayebee cái, jáiwa néemi namáidadaca: ‘¡jái líinu chéjirra nashínaacoo! ¡Ijiáyu irríshibiacani!’ ");
INSERT INTO aca_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Quinínama náa'a miyácanaimica nabárruau, jáiwa nachána nachúndadani nashínaa lámparau. ");
INSERT INTO aca_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Néenee náa'a cinco mawíteenica, namá'ee nalí náa'a cinco cawíteenica: ‘Yáa walí píitui ishínaa aceite éenau, jiníwata washínaa lámpara cháqueneu nayáca.’ ");
INSERT INTO aca_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ne náa'a cinco miyácanai cawíteenica néeba'ee: ‘Jóca, jiníwata jóca léenaa walí jiní irrú. Mawí cawénica yáacoo chaléeni nawéndactalacani iwénique'e irrúwoo iyá jájiwani.’ ");
INSERT INTO aca_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ne nácula náa'a cinco miyácanaica náau nawéni aceite, jáiwa líinu léji liá'a nashínaacoo, ne náa'a cinco cawíteeninica nawárroo liájcha boda rícula, jáiwa cuíta númaca báyeerriwai. ");
INSERT INTO aca_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ne liáwinaami náiinu náa'a áabi miyácanaimi namá'ee: ‘¡Wawácali, wawácali, jiméecu wáajaba cuíta númaca!’ ");
INSERT INTO aca_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ne léeba'ee nalí: ‘Ne yáawaiyi numá irrú, jócai nucúnusia iyá, tándawa jócai numéecu cuíta núma.’ ");
INSERT INTO aca_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Cáwi iwítee yáca, jiníwata jócai yáa léenaa, tánashia éerri rícu, ya hóraa nuíinui. —Jesús má'ee. ");
INSERT INTO aca_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Linácu liá'a nuéejoocojoo áacairra néeni léjta rey, nuá irrú áabai licábacanaa. “Dios wánacaalactalaca chái cábacanaa léjta báqueerri washiálicuerri, wówerri liácoo liyáca áabai cáinabi ítala, limáida lishínaa tráawajadorbiniu, jáiwa licárgueda nalí natúyaque'e liwárruanica. ");
INSERT INTO aca_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Báqueerri néenaarru léntregaa lirrú cinco mil monedayu, báqueerrirru dos mil moneda, ya báqueerri mil moneda. Bácainaa liá nalí léjta nawítee éenau'u liá léenaami. Jáiwa liáwai áabai cáinabi néerra. ");
INSERT INTO aca_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Liá'a tráawajadorca ríshibierri cinco mil moneda, néenee liméda negocio liyú liá'a warrúwaca, jáiwa ligáana áabata cinco mil moneda liyúi. ");
INSERT INTO aca_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Chacábacanaa liá'a ríshibierri dos mil moneda, ligáana áabata dos mil mawí. ");
INSERT INTO aca_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ne liá'a ríshibierri mil moneda, jáiwa liáwai libáya liwácali wárruaniwai, útawi rícu liméda cáinabi rícu, quéewique'e léejueda liwácalirru wáni. ");
INSERT INTO aca_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Íchaba éerri liáwinaami léejoo liá'a nawácalica náa'a tráawajadorbinica, jáiwa lichánau liméda náajcha cuenta. ");
INSERT INTO aca_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Quéechanacu líinu liá'a ríshibierri cinco mil moneda, jáiwa léejueda liwácalirru áabata cinco mil, limá'ee: ‘Nuwácali, jiyá yáirri nulí cinco mil, áajee áabata cinco mil nugáanani jirrú.’ ");
INSERT INTO aca_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Liwácali má'ee lirrú: ‘Sáicai wérri, jiyá tráawajador sáicai machácanii wítee; ne machánica jiyá liyú liéni píituica, numáacaminaa jiyá jiwánacaala áabata mawí. Jiwárroo sáicta jiwówau nuájcha.’ ");
INSERT INTO aca_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Liáwinaami líinu liá'a tráawajadorca ríshibierri dos mil moneda, limá'ee: ‘Nuwácali, jiyá yáirri nulí dos mil moneda, áajee áabata dos mil nugáanani jirrú.’ ");
INSERT INTO aca_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Liwácali má'ee lirrú: ‘Sáicai wérri, jiyá tráawajador sáicai machácani wítee; ne machácanica jiyá liyú liéni píituica, numáacaminaa jiwánacaala áabata mawí. Jiwárroo sáicta jiwówau nuájcha.’ ");
INSERT INTO aca_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ne quéecha'inaami líinu liá'a tráawajador ríshibierri mil moneda, limá'ee liwácalirru: ‘Nuwácali, nuyá yáairri léenaa jiyáca washiálicuerri cabálini wérri, léjta liyá yáawaquederri ítashi áabi shínaa bacháida rícu, ya jiáwaqueda á'a jócta jiáabana. ");
INSERT INTO aca_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Cáarru nuyái wísta jócu nugáana ya nupérdia jiwárruani, tándawa nuáu nubáya jiwárruani cáinabi yáajabala. Ne áajee liéni jiwárruanica jishínaaca.’ ");
INSERT INTO aca_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Liwácali éeba'ee lirrú: ‘Jiyá tráawajador máashii ya íinui, ne jiácta léenaa nuáwaqueda banácali á'a jócta nuáabana ya nuáwaqueda á'a jócta nucása, ");
INSERT INTO aca_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","jirrúna'inaa jitée ta nuwárruani banco rícula, ya jáicta nuéejoowai nurríshibiacta nuwárruaniu ya ta liá'a ligáanani nulí lítala.’ ");
INSERT INTO aca_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Néenee liwácali ma nalí náa'a yáainai nayá néeni: ‘Éeda liúcha liérra mil monedaca, ya yáa lirrúni liá'a wáalierri diez mil. ");
INSERT INTO aca_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Liá'a éemerri sáica, yáirri'inaa léenaa mawí, ne liá'a jócai éemi sáica, áawita liyá liá léenaa mawí, liyá pérderri'inaa liá'a píitui rími liáni léenaa nácu. ");
INSERT INTO aca_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ya liéni tráawajador jiní sírbiani, ijéda bináawalani catáwacactalaca. Néeneeminaa líchajoo ya liámuedaminaa léujoo licáichajoo. ");
INSERT INTO aca_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Jáicta nuyá washiálicuerri Dios Cúulee, íinujoo quinínama macájirra nucáamarra yáajchau, ya quinínama nushínaa ángelbini, nuwáaminau nuárrubai balíbali íta'au. ");
INSERT INTO aca_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Quinínama chóniwenai cáinabi íta'aa sánaca, náawacaminau nunáneewa, ya táminaa nushírrida nayái bácainaa, jicá'a báqueerri pastor shírridau'u lishínaa ovejau cabra íibicha. ");
INSERT INTO aca_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Léjta pastor máidau oveja sáicaquictejica ya náa'a cabraca apáuliquictéjica; chacábacanaa numéda'inaa nuyá Washiálicuerri Dios Cúuleeca, numáidaminaa náa'a Dios wínanica sáicaquictejica, ya náa'a chóniwenai máashiinica numáidaminaa apáuliquictéjica. ");
INSERT INTO aca_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Numáminaa nuyá Reyca nalí náa'a yáainai sáicaquictejica: ‘Íinu chérra iyá, nusálijinaa yáaque'e irrú sáicabee; irríshibia liá'a wánacaalactalaca níseerri lichúnicuwai irrúi, rícuete Dios méda éerrica. ");
INSERT INTO aca_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Quéecha'inaamite ínaaishi nulí, iyáte yáate núya; iméete nuwówa, yáate nuíirra shiátai; nujínani'inaamiteu jiní núbana, yáate nuárrui. ");
INSERT INTO aca_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Cháuctate núbala, yáate nulíni; nubálina'inaamiteu, yáateu iyúda nuyá; nuyá'inaamite cuíta manúmai rícula, íinute icába nuyá.’ ");
INSERT INTO aca_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Néenee nasátaminaa néemiu náa'a majíconaanica Dios wínanica: ‘Wawácali, ¿chacálitate wacába ínaaishi jirrú jíni, ya wáate jíya? ¿O chacálitate wacába imée jiwówa jíni, ya wáate jíirra shiátai? ");
INSERT INTO aca_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","¿Chacálitate wacába jiní jiárrui jíni, wáate jiárrui, o cháucta'inaamite jíibala, ya wáate jirrúni? ");
INSERT INTO aca_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","¿Chacálitamite wacába jibálinacoo jíni, ya jiyá cuíta manúmai rícula, ya wáateu wacába jiyá?’ ");
INSERT INTO aca_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Nuyá Rey nuéebaminaa nalí: ‘Ne yáawaiyi numá irrú, quinínama liá'a imédani nalí náani nuéenajinai mawíni rími imíyaca, nulí iméda iyácani.’ ");
INSERT INTO aca_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Néenee nuyá Rey máminaa nalí náa'a yáainai apáuliquictéji: ‘Ishírriu núcha iyá náa'a Dios nísani limárru nayácala licástigaani'inaa; yáa namówai infierno rícula méderricoo Wawásimirru ya lishínaa ángelbinica. ");
INSERT INTO aca_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Iyá'ee éenalicuni yáacoo infierno rícula, níwata ínaaishite nulí, ne jóctate yáa núya; iméete nuwówa, ne jóctate yáa nuíirra shiátai, ");
INSERT INTO aca_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","nujínaniteu déecucha nucáinaberra yúchau, ne jóctate yáa nulí yáarrushi. Cháuctate núbala, ne jóctate yáa nulíni; nubálinateu ya nuyá cuíta manúmai rícula, ne jóctate íinu iyúda nuyá.’ ");
INSERT INTO aca_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Néenee nasátaminaa néemiu liyá: ‘Wawácali, ¿chacálitate wacába ínaaishi jirrú, o imée jiwówa, o léjta liá'a jiní yáarrui liyácta'inaa, o cháucta jíibala, o jibálinacoo, o cuíta manúmai rícula, ne jóctate wayúda jiyá?’ ");
INSERT INTO aca_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Nuyá liá'a Reyca léebaminaa nalí: ‘Ne yáawaiyi numá irrú, quinínama liá'a jócai iméda nalí náani éebidenaica imíyani rímica, chacábacanaa jóca iméda nulíni.’ ");
INSERT INTO aca_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Náaminau náani carrúnatai néerra jócai amáarra, ne náa'a majíconaanica náaminau cáwicashi néerra jócai amáarra.” ");
INSERT INTO aca_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Liáwinaami linísa'inaami limá quinínama léji liáni, Jesús má'ee lishínaa éewidenaicoo: ");
INSERT INTO aca_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","—Léjta yáyu'u léenani, chámai éerri rícula, fiestaminaa pascua shínaaca, ya nuyá Washiálicuerri Dios Cúuleeca, néejuedaminaa nuyá quéewique'e natáata nuyá cruz nácu. ");
INSERT INTO aca_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Liyáali éerrimi, náa'a nawácanai náa'a sacerdótebinica ya náa'a salínai judíobinica, jáiwa náawacawai Caifás shínaa cuíta máanui néeni, chúnsai sacerdótebini wácalica, ");
INSERT INTO aca_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","namá'ee nalíwau chítashia néewau'inaa nawína Jesús jíni númashi yúwica nácue jíni, náiinuaque'ini. ");
INSERT INTO aca_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ne namá'ee: —Ne jócu wamédani fiesta éerdi rícu, quéewique'e jócu nacáarraliau chóniwenai. ");
INSERT INTO aca_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Jesús jínaniu áabai chacáalee jí'ineerri Betania, líibana néeni Simónca náanimi jí'inaa chorrówai sái; ");
INSERT INTO aca_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","nácula lirrúwedau, báquetoo íinetoo rúniu lirrú, téechoo ruácoo áabai urrúwa rími, namédani íibayu jí'ineerri alabastro, cashiámui juménibeeyu cawéni wérri. Nácula Jesús rúweda liyáu líyaca, jáiwa runuádeda Jesús juáta licué jíni. ");
INSERT INTO aca_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Náa'a lishínaa éewidenaicoo, nacába'inaamini, jáiwa íiwirri nawówai ya nachána namá'ee nalí wáacoo: —¿Tánda ruíinu runuádeda léji liérra juménibeeca? ");
INSERT INTO aca_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Sáicaicta nawéndaca máanui warrúwa nacuéjica, quéewiquinicta wayúda náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Jesús éemi'inaani, limá'ee nalí: —¿Tánda ijódia ruáni íinetooca? Liéni rumédani ruyáca nuájcha sáicai. ");
INSERT INTO aca_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ne náa'a carrúni jináatanica mamáarracani'inaa yáa íibijoo, ne nuyá jócainaa mamáarraca yáa yáajcha. ");
INSERT INTO aca_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Liéni rumédani nuájcha ruáni íinetooca, runuádedau'u juménibee nutánai, chúnechoo ruyá nuyá urrúnica naquéni nuyá. ");
INSERT INTO aca_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ne yáawaiyi numá irrú, táshia nácucha quinínama cáinabi íta'aa náiiwadedacta liáni chuánshi wásedeerri'inaaca, natáaniaminaa runácu lécchoo liá'a rumédani ruáni íinetooca, cháminaa nédacanicoo runácujoo lécchoo. ");
INSERT INTO aca_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Judas Iscariote, báawitate néenaa náa'a doce éewidenaicoo, liáu licába nayáctala náa'a sacerdote wácanaica ");
INSERT INTO aca_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ya limá'ee nalí: —¿Chíta máanaba iwówai yáa nulí jíni, nuéntregaaque'e irrú Jesús? Nayá chánaa liwénija: Treinta moneda warrúwayu. ");
INSERT INTO aca_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Lirrícuete liáwinaami Judas limúrru chítashia léewau'u léntregaa Jesús jíni. ");
INSERT INTO aca_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Quéechanacu sái éerri fiestaca, éerdi náayacta liá'a páanica jiní íibisai wáneerri limúrracacoo, náa'a éewidenaicoo narrúniu Jesúsru nasáta néemiu liyá: —¿Tanácucha jiwówai wachúni liá'a íyacaishi pascua shínaaca? ");
INSERT INTO aca_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Jesús éeba'ee: —Yáa namówai lirrícula liá'a chacáaleeca, líibana néerra liá'a washiálicuerrica nutáaniani'ini irrú nácu, imá lirrú: ‘Quéewidacai má'ee: Liá'a éerri numánimi jirrú nácu jái urrúnicai, nuáu jíibana néerra numéda íyacaishi pascua shínanaaca nushínaa éewidenaicoo yáajchau,’ ");
INSERT INTO aca_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Náa'a éewidenaicoo naméda léjta Jesús bánua'u nayá, ya ta naméda íyacaishi pascua shínanaaca. ");
INSERT INTO aca_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Quéecha'inaami catáwacacai, Jesús yáau liyá mesa nácula lishínaa doce éewidenaicoo yáajchau; ");
INSERT INTO aca_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ne nácula náaya nayáca Jesús ma nalí: —Ne yáawaiyi numá irrú, báqueerri éenaa náawerri'inau nujúnta. ");
INSERT INTO aca_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Jáiwa máashii wéerri nawówai, ya nachána bácainaa nasátada néemiu liyá: —Nuwácali, ¿nuyáminaa? ");
INSERT INTO aca_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Jesús éeba'ee nalí: —Báqueerri íyeerri nuájcha, chaléjta nujúnicai mawíyica, lé'inawa náawerriu nujúnta liérra. ");
INSERT INTO aca_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Nuyá washiálicuerrica Dios Cúuleeca, arrúnaa máanali nuyá, léjta limá liá'a Dios chuáni; ¡ne carrúni jináatai rími'inaa liá'a náawerricoo nujúnta! Sáicanata lirrú jócu lijiáu liúchau cáinabi ítala. ");
INSERT INTO aca_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Néenee Judasca, náawerri'inaacoo lijúnta, lisáta léemiu Jesús: —Quéewidacai, ¿nuyá'inaamina? —Jesús éeba'ee lirrú: —Chái já'a léjta jimáyu'u. ");
INSERT INTO aca_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Nácula náaya nayáca, Jesús wína licáaji rícuu páani, linísa'inaami liá sáicai Diosru, lisúbirreda ya ta liá lishínaa éewidenaicoorru jíni, limá'ee: —Íyau, léwa nuíinaa liéni. ");
INSERT INTO aca_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Jáiwa liwína licáaji rícuu áabai copa, liá sáicai Diosru, lidúcua nalíni limá'ee: —Íirrau quinínama iyá liéni cópaca, ");
INSERT INTO aca_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","níwata léwa nuíirranaa, liéni nuéejo'u numéda yáajcha áabai wáalii wíteeshica; liéni íirraica nuádedeerri'inaaminau íchaba nácueji, quéewique'e najíconaa méetuacoo. ");
INSERT INTO aca_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ne numá irrú jócuminaa nuéejoo nuíirra liábi liáni uvaca, cáashia liyáali éerri nuíirra yáajchani liá'a vino wáalii nusálijinaa wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Liáwinaami nanísa'inaami narrába salmo, náau dúuli ítala jí'ineerri Olivos. ");
INSERT INTO aca_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ya Jesús má'ee nalí: —Quinínama iyájoo yúrrucuedaminaa éebidauca nunácu wáalee táayee. Cháwa limá tánerricoo cáashta íta'aa: ‘Nuwánaca nuíinuaminaa liá'a pastorca, ya táminaa oveja nacáarraliacojoo.’ ");
INSERT INTO aca_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ne quéechanacu jáicta nucáwiaujoo, nuáaminaajoo ibéechajoo Galilea rículajoo. ");
INSERT INTO aca_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Pé'eru má'ee lirrú: —Áawita quinínamacta yúrrucueda néebidauca jinácu, nuyá jócai'inaa yúrrucuedani. ");
INSERT INTO aca_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Jesús má'ee lirrú: —Ne yáawaiyi numá jirrú, wáalee béwaami táayee yáawinaami, jóctanaa limáida chámaichu liá'a gáayuca, matálichu jibáyaminaa nunáawa jócala jicúnusia nuyá. ");
INSERT INTO aca_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Pé'eru éejoo'ee limá mamáarraca: —Arrúnacta máanali nuyá jiájcha, jócuminaa nubáya jináawa. Ya quinínama éewidenaicoo liájcha namá'ee chacábacanaa. ");
INSERT INTO aca_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Jáiwa Jesús yáau lishínaa éewidenaicoo yáajchau, áabai yáarruishi jí'ineerri Getsemaní, limá'ee nalí: —Iwáayu áani, nácula nuáu nuóracoo chaléeni. ");
INSERT INTO aca_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ne jáiwa litée Pé'eru ya chámata léenibi liá'a Zebedeoca, jáiwa lichánau lisíntia limáashii wérri liwówai ya cáiwi licábacoo. ");
INSERT INTO aca_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Limá'ee nalí: —Nusíntia nucáwica nácuu máashii nuwówa máanalicaiyu. Imáacau áani, ya cáwi iyá nuájcha. ");
INSERT INTO aca_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Liyáalimi Jesús yáau píituirrimi libéechalawoo, litájiau linánimiyu cáinabi nácula, lióra'eewoo limá'ee: “Nusálijinaa, jéewacta jijéda nuyá liúcha liáni carrúnatai wérrica; ne jócubeecha jiméda léjta nuwówau'u, ne jimédaque'e léjta jiwówau'u.” ");
INSERT INTO aca_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Jáiwa léejuawai licába lishínaa matálitai éewidenaicoo néerrawai, líinu nanácu máinai nayáca. Limá'ee Pé'erurru: —¿Ne jócuwita éenaa cáwi áabai hóraa nuájchai? ");
INSERT INTO aca_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Cáwi iyáca ya i'órau, quéewique'e jócubeecha icáu máashictalaca. Iyá sáicani métaa iwówai imédacani, ne ináanai wáneerri máajinaa iyá. ");
INSERT INTO aca_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Chámaichu léejocoo lióraca chá'a: “Nusálijinaa, ne jócta jéewacta jijéda nuyá liúcha liáni carrúnatai wérrica, jimédau léjta jiwówau'u.” ");
INSERT INTO aca_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Léejua'inaamiu, líinu nanácu náa'a éewidenaicoo máinai nayá báaniu, jiníwata natuí báyeerriu dajuíshiyu. ");
INSERT INTO aca_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Limáaca nayái léejoo liácoo li'óracoo matálichu, limá léja liá'a chuánshi chái cábacanaa. ");
INSERT INTO aca_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Néenee léejoo nayáctala náa'a éewidenaicoo, limá'ee nalí: —¿Iyá mamáarracani máa iyáca, ya iwówa íyabactacoo? Jái íinu liá'a léerdicai nuyá Washiálicuerri Dios Cúuleeca, néentregacta'inaa nuyá nacáaji rícula náa'a cajíconaanica. ");
INSERT INTO aca_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ibárroo, wayúwai; jái urrúnicai liá'a éentreguerri'inaa nuyá nujínairru. ");
INSERT INTO aca_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Nácula Jesús táania liyá újnibii, Judas íinu'inaami, báqueerri néenaa náa'a doce éewidenaicoo, íinuerri íchaba chóniwenai téenai espada ya áicuba yáajcha. Yáaineu nawánacaala nácu náa'a sacerdótebini wácanai ya salínai judíobini wácanai. ");
INSERT INTO aca_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Judas, liá'a náawerri'inaacoo Jesús júnta, liá nalí áabai chítashia quéewau'u náa léenaa nacábaqui jiníni, limá'ee nalí: “Tánashia icábanii nushíshi wídani, liyáwa léju liárra; iwínani preso áani.” ");
INSERT INTO aca_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Jáiwa'ee, lirrúniu Jesúsrui, limá'ee: —¡Yáali, quéewidacai! Jáiwa'ee lishíshi liwídani. ");
INSERT INTO aca_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Jesús éeba'ee lirrú: —Nujúnicai, liá'a jíinuni jimédaca, jimédani. Néenee náa'a áabica narrúniu, nawína Jesús, natée preso jíni. ");
INSERT INTO aca_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Liyáalimi, báqueerri néenaa náa'a yáainai Jesús yáajcha, lijéda lishínaa espadau, jáiwa liwíchua liwíba liá'a shírruederri nalí náa'a sacerdótebini wácanaica. ");
INSERT INTO aca_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Jesús má'ee lirrú: —Jiwáalia jishínaa espadau liárrui rículau. Jiníwata quinínama náa'a íinua yáaquenaicoo espadayu, espadayu lécchu máanali nayá. ");
INSERT INTO aca_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","¿Jócu jiá léenaa nusátactata nusálijinaa yúchau, libánuaminaata nulí chóca jirrímitaja'a setenta y dos mil ángelbini? ");
INSERT INTO aca_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ne cháctatani, ¿chítashia quéewaucta licúmpliacoo liá'a cáashta tánerricoo máirrica arrúnaaca libésunacoo cháa? ");
INSERT INTO aca_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Liyáalimi Jesús sáta léemiu náa'a chóniwenaica: —¿Tánda íinu iyá espada yáajcha ya áicuba iwína nuyá preso, jicá'a liá'a máashiicaica? Éerri jútainchu nuéewida templo máanuica, ne jiníwaa iwínacta nuyá. ");
INSERT INTO aca_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ne quinínama liéni libésunau quéewique'e licúmpliacoo léjta liá'a namáyu'u náa'a íiwadedenai Dios chuáni báinacu, tánerricoo cáashta íta'aa. Ne liyáalimi, quinínama éewidenaicoo liájcha, namáaca bácai Jesús, jáiwa nacánacawai. ");
INSERT INTO aca_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Néenee náa'a wínenai Jesús natée Caifás íibana néerra, liá'a sacerdote wácanaica, náawacai yáacactalau náa'a quéewidacanica ley shínaa ya náa'a salínaica. ");
INSERT INTO aca_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Pé'eru yáau líshiirricu déecucheji lishínaa patio néerra liá'a sacerdote wácalica. Néenee liwárruau liwáacoo náajcha náa'a soldado túyenai liá'a templo máanuica, quéewique'e licába namédau'e lirrúni quinínama liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Náa'a sacerdote wácanai ya quinínama náa'a Judío wácanaica, namúrru áabai chuánshi jicá'a liá'a sáicaica, áawita máashiicani, quéewique'e nawána náiinuacani liá'a Jesúsca, ");
INSERT INTO aca_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ne jócai náiinu, áawita íchaba chóniwenai íyadacoo ya náa lijíconaa jócai yáawaiyii. Ne máayabaca náyadacoo chámata mawí, ");
INSERT INTO aca_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","namá'ee: —Ne liáni washiálicuerrica limá'ee: ‘Nuéewa nucáarralia liá'a templo Dios shínaaca, ya nuéewa nubárrueda báaniwani matálii éerri rícula.’ ");
INSERT INTO aca_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Néenee libárrua'eewoo liá'a sacerdote wácalica, lisáta léemiu Jesúsru: ¿Jiní jéebaca? ¿Tána léji liáni namáni nayá jinácucha? ");
INSERT INTO aca_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Ne Jesús máaquerriu manúma. Jáiwa'ee sacerdote wácali má'ee lirrú: —Lijí'inaa nácu Dios cáwiica mamáarraca, nubánua jimáque'e liá'a yáawaiyica. Jíiwa walíni, jiyáctani Mesíasca, Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Jesús éeba'ee lirrú: —Chái já'a, léjta jimáyu'u. Ne numá irrú lécchoo iyá icábaminaajoo nuyá Washiálicuerri Dios Cúuleeca, wáairri'inau léema nácu sáicaquicteji liá'a Dios cadánani wítee, ya líinu sáanai íibeji áacaiji. ");
INSERT INTO aca_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Néenee lishírricua líibala liá'a sacerdote wácalica, líyadaque'e liyáu íiwirri wérrica liwówa, ya limá'ee: —¡Liéni washiálicuerrica táanierri léjta liyácchu Dios! ¿Tánda warrúnaa wamúrru áabi mawí táanianai'inaa linácu? Ne iyá inísa éemi lichuáni, jócala cawáunta licába Dios; ");
INSERT INTO aca_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","¿chíta icábau jiníni? Jáiwa néeba'ee: —Jái cajíconaacai, arrúnaa máanalicani. ");
INSERT INTO aca_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Néenee'e nawísada lináni ya náiinuedani. Áabi nabáya lituí tá'ee nabáseda lináni, ");
INSERT INTO aca_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","namá'ee lirrú: —Jiyáwa liá'a Mesíasca, ¡jidíwinate tánashia íinua jiyái! ");
INSERT INTO aca_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Pé'eru, nácula liwáau liyáca bináawa, patio íta'aa. Liyáalimija, báquetoo íinetoo nawánacaala yáarru rurrúniu Pé'erurru, ya rumá lirrú: —Jiyá lécchoo yéerrimi Jesús yáajcha, liá'a Galilea néenee sái. ");
INSERT INTO aca_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ne Pé'eru báya lináawa quinínama náneewa, limá'ee rulí: —Jócu nuá léenaa liá'a jitáaniani jiyá nácu. ");
INSERT INTO aca_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Jáiwa liáwai cuíta núma néerra, néeni báquetoo íinetoo cábani, ya rumá nalí: —Liérra jínaneerrimiu Jesús yáajcha, liá'a Nazaret néenee sáica. ");
INSERT INTO aca_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Pé'eru báaniu báya lináawa, limá'ee: —¡Dios cástigaa nuyá jócta numá liá'a yáawaiyi, jócai nucúnusia liérra washiálicuerrica! ");
INSERT INTO aca_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Íchaitaa liáwinaami, náa'a yéenai néeni narrúniu Pé'erurru ya namá'ee lirrú: —Yáawaiyi jiyá báqueerri néenaa náa'a jínaneneecoo Jesús yáajcha, níwata jitáaniacala chaléjta nayá. ");
INSERT INTO aca_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Néenee Pé'eru chána limáca cadánani mawí: —¡Dios cástigaa nuyá jócta numá yáawaiyi, jócu nucúnusia liérra washiálicuerrica! Liyáalimi já'a, áabai gáayu máidai. ");
INSERT INTO aca_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Néenee Pé'eru édacaniu linácu liá'a Jesús mánimi lirrú: ‘Libéecha limáida liá'a gáayuca matálichu jibáya nunáawajoo’. Néenee Pé'eru jiáu néeni, lícha cáiwinaa wérri. ");
INSERT INTO aca_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Quéecha'inaa jucámarracai, quinínama náa'a sacerdote wácanai, yá'ee náa'a salínai Judíobini shínaaca, náawaqueda yáacau chítashia néewo'inaa nawána náiinua Jesús jíni. ");
INSERT INTO aca_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Naté'inaa jíni nabájini ya néntregaa Pilatorru jíni, liá'a wánacaleerri Roma néenee sái. ");
INSERT INTO aca_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Néenee liá'a Judasca náawerricoo Jesús júnta, licába'inaa náiinua liá'a Jesúsca, jáiwa cáiwi liyá lirrú. Néenee lipénsaa léejueda náa'a treinta moneda jiárrunica cawénitani jí'ineerri plata, nalí náa'a sacerdote wácanai yá'ee náa'a salínaica. ");
INSERT INTO aca_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Limá'ee nalí: —Cajíconaa nuyá nuéntregaacalani máanalique'ini liá'a báqueerri washiálicuerri majíconai. Néenee néeba'ee lirrú: —Jiní wéni walí. ¡Jiyáiwa méda jirrúwoojani! ");
INSERT INTO aca_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Néenee'e Judasca liúca náa'a moneda templo rícula, ya lijiáu néenee, jáiwa'ee lijórcawai. ");
INSERT INTO aca_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Néenee'e náa'a sacerdote wácanai náawaqueda liá'a warrúwaca, namá'ee: —Liéni warrúwaca yáairri casáculai íirraiyu, jócai wéewa wamáaca á'a yáarrushi ofrenda shínaaca, níwata liá'a washínaa ley jócai línda. ");
INSERT INTO aca_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Jáiwa'ee naméda áabenaama, nawínaque'e liyú áabai cáinabi jí'ineerri Campo del Alfarero (liwówau'u limáca: lishínaa cáinabi liá'a washiálicuerri méderri méenaami cáinabiyu) naquénicta'inaa náa'a chóniwenai máanali déecucha sánaca. ");
INSERT INTO aca_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Tándawa, liá'a cáinabica, lijí'inaa chóque'e éerri Yáarruishi íirrai shínaa. ");
INSERT INTO aca_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Cha libésunacuwai léjta limáyu'u liá'a íwadedeerri Dios chuáni báinacu jí'ineerri Jeremías, limá'inaa: “Nawína'inaa náa'a treinta moneda jiárrunica cawénitani jí'ineerri plata, léwa liwéni namáacani náa'a israelítabini wácanaica. ");
INSERT INTO aca_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Néenee nawéni'inaa nayú náa'a monedaca liá'a cáinabi lishínaa liá'a tráawajairri méenaami cáinabiyu. Namédani'inaa liáni níwata nuwácali cháa liwówaicani.” Cháwate limá liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Jeremías. ");
INSERT INTO aca_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Náa'a soldádobini natée Jesús lijúnta liá'a wánacaleerrica, néenee wánacaleerri sáta léemiu jíni limá'ee: —¿Jiyá rey judíobini shínaaca? Jesús léeba'ee lirrú: —Chái já'a, léjta jimáyu'u. ");
INSERT INTO aca_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nácula náa'a sacerdote wácanaica ya náa'a salínaica náa lijíconaa, Jesús jiní jócai éeba. ");
INSERT INTO aca_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Tándawa Pilato sáta léemiu Jesús: —¿Jóca jéemi quinínama liá'a namáni jinácucha? ¿Táda jócu jéeba? ");
INSERT INTO aca_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ne Jesús jiníwita áabai chuánshi léebani Pilatorru; tándawa licáarrudau wérri licábacani liá'a wánacaleerrica. ");
INSERT INTO aca_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Nácula liyá liá'a fiesta jí'ineerri pascua, liá'a wánacaleerrica séewirrinaa liwásaida báqueerri preso, tánashia chóniwenai wínanii. ");
INSERT INTO aca_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ái báqueerri preso cáiwanai jí'ineerri Jesús Barrabás; ");
INSERT INTO aca_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ya nácula náawacaida yáacau quinínama, Pilato sáta léemiu nayá: —¿Tána iwówai nuwásedacai: Jesús Barrabás o liyáwee Jesús, liá'a náa jí'ineerri Mesías? ");
INSERT INTO aca_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Jiníwata liáca léenaa néntregaa liyá cadénica nayá, ne jáiwa nasáta'inaa liúcha liwáseda. ");
INSERT INTO aca_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Nácula Pilato wáau liyáca á'a lijí'inacta tribunal, líinu rubánua namá lirrú: “Ujiméda máashii lirrú liérra washiálicuerrica sáicaica, jiníwata táayee nudájuni áabai dajuíshi cáarrui wérri linácueji.” ");
INSERT INTO aca_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Ne náa'a chóniwenaica nawówai'e Pilato liwáseda liá'a Barrabásca, ya lishínaa soldádobini náiinuaque'e Jesús, léjta sacerdótebini wácanai ya salínai wówau'u. ");
INSERT INTO aca_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Liá'a wánacaleerri lisáta léemiu nayá báaniu: —¿Tána néenaa náa'a chámataca iwówai nuwásedaca? Néeba'ee liúchani: —¡Barrabás! ");
INSERT INTO aca_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Pilato sáta léemiu nayá: —¿Ya tánaque'e numéda liájcha liérra Jesús, namáni nácucha Mesías? Quinínama néeba'ee: —¡Jitáata cruz nácuni! ");
INSERT INTO aca_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Pilato limá'ee nalí: Ne ¿tána máashii limédai? Ne nayá namáidada báaniu: —¡Jitáata cruz nácuni! ");
INSERT INTO aca_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Jái'inaa Pilato cába jócu léenaa lináawida nawítee náa'a chóniwenaica, mawí'e naméda nawítamau, libánua náacoo néeda shiátai ya libádeda licáajiu quinínama náneewa, limá cháa: —Nuyá jócai wárroo limáanalicau nácu liáni washiálicuerrica; ishínaa ítalashi iyá jájiu. ");
INSERT INTO aca_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Quinínama chóniwenai néeba'ee: —¡Wayá ya wéenibi ta wayá waméda limáanalica! ");
INSERT INTO aca_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Néenee Pilato wáseda liá'a Barrabásca; jáiwa liwána nabásaida Jesús ya léntregaa nalí náa'a soldádoca quéewique'e natáata liyá cruz nácu. ");
INSERT INTO aca_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Náa'a soldádoca lishínaa liá'a wánacaleerrica, natée Jesús líibana máanui néerra, ya náawacau litéeji quinínama náa'a áabibi soldádoca. ");
INSERT INTO aca_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Namídu líibala, nasúwa linácu áabai capa quíirrai, léjta báqueerri rey, ");
INSERT INTO aca_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ya namáaca liwíta nácu áabai túwirri yáacanaa chaléjta corona, ya báju vara licáaji sáicaquicteji léjta nawáaliani reybinica. Jáiwa natúyau lináneewa, nacáida liyá namá'ee lirrú: —¡Jiyá yéerri íchaba camuí, jiyá rey judíobini shínaa! ");
INSERT INTO aca_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Yá'ee nawísada lécchoo, yá'ee liyú liá'a varaca nabása'ee liwíta nácu. ");
INSERT INTO aca_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Liáwinaami nacáidaqui jíni, namídu'e liúcha íibalashi quíirrai, néejo'e nasúwa linácu líibala, yá'ee natée quéewique'e natáata cruz nácuni. ");
INSERT INTO aca_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Quéechanacu'inaa najíau náacoo, Jesús litécta liácoo lishínaa cruz, náiinu linácu báqueerri washiálicuerrica jí'ineerri Simón, áabai chacáalee sái jí'ineerri Cirene, ne liáni nawána máashiiyu liyúda litée Jesús shínaa cruz. ");
INSERT INTO aca_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Náiinu'inaa linácu áabai dúuli rími lijí'inacta Gólgota, (wówerri limáca: “Iyájimi yáarru”). ");
INSERT INTO aca_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Néenee náa líirrai liá'a Jesúsca vino éewiderriu ténaashiyu; ne Jesús jáiwa linísa'inaa'ee liprówaqui jíni, jócai liwówa líirraqui jíni. ");
INSERT INTO aca_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Néenee namídu líibala ya nanísa'inaa natáataniqui jíni cruz nácu, náa'a soldádoca náuqueda tánashia wíshii, náaque'e léenaa tánashia máacau nashírdaque'e nalí wáacoo líibala liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Jáiwa nawáau néeni natúyaque'e liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Namáaca liwíta wícau áabai tánerriu íiwerri tándashia náiinua jíni, máirri'e: “Le Jesúsja liáni, rey Judíobini shínaa.” ");
INSERT INTO aca_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Natáata cruz nácu lécchoo liájcha liá'a Jesúsca, chámata canédi, báqueerri sáicaquicteji ya báqueerri apáuliquictéji. ");
INSERT INTO aca_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Náa'a chóniwenaica bésunenaicoo néeni nacáitani ya nacúsuda nawíta nacáidaque'e, ");
INSERT INTO aca_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","ya namá'ee: —¡Yáawaicta Dios cúulee jiyá, jiúrrucoo cruz nácucha! ¡Jiyá máirri jéenacala jicáarralia liá'a temploca, jéejoo jinácuda báaniujoni matálii éerri rícula, jiwásedateu jiyá jájiu! ");
INSERT INTO aca_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Chacábacanaa nacáida liyá náa'a sacerdótebinica wácanaica náajcha náa'a qéewidacani ley shínaaca yá'ee náajcha náa'a salínai lécchoo. Namá'ee nalí wáacoo: ");
INSERT INTO aca_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","—Jiyá chúneerri náa'a bálineneecoo ya jicáweda náa'a máanalica, ne jócu jéewa jiwásedacoo náinueda'echa jiyá. Israel shínaa reyca waliérra: ¡icúwaa liúrrucuacoojoo chóca já'a cruz nácucha, ya wéebidaque'e linácu! ");
INSERT INTO aca_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Liyá máirri limáaca liwówau Dios nácu: ¡ne Dios wáseda chócu jiní'i, yáawaicta caníinaa licába liyá! ¿Jócai limácala Dios cúuleecaalani? ");
INSERT INTO aca_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Chacábacanaa lécchoo natáania máashii linácu náa'a canédibinica táateneecoo cruz nácu liájcha liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Néenee'e catáawaca quinínama cáinabi wíiyaicumi cáashia las tresca. ");
INSERT INTO aca_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Liyáali hóraami, Jesús máidada'ee cadánani limá'ee: “Elí, Elí, ¿lema sabactani?” (wówerri limáca: “nushínaa Dios, nushínaa Dios, ¿tánda jimáaca nuyá bácai?”) ");
INSERT INTO aca_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Néenee nanísa'inaa néemiqui jíni náa'a áabica namánabaca yáainai néeni, namá'ee: —Liáni washiálicuerri máiderri liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Elías. ");
INSERT INTO aca_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Néenee báqueerri yáau madéjcanaa línda esponja, újni espumaca. Néenee'e lisábida jíni liyú liá'a vino ijíshiiyu, jáiwa libájini báju shitúwa, jáiwa liá Jesús íirraqui jíni. ");
INSERT INTO aca_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ne náa'a áabica namá'ee: —Jimáacani, wacába'aa Elías íinucta liwásedacani. ");
INSERT INTO aca_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Jesús limáidada cadánani báaniu, jáiwa máanali jíni. ");
INSERT INTO aca_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Liyáalimi, liá'a cortina templo núma lícu sáica, lishírricuawai béewami áaqueji cáinaculanaa. Cáinabi cúsuwai yá'ee íiba wérri páquiawai. ");
INSERT INTO aca_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Yá'ee útawi namáacacta máanalinimi méecuenai'eewoo, néenee íchaba washiálicuenai Dios shínaa máanalicai néejoocoo nacáwiacoo. ");
INSERT INTO aca_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Néenee licáwia'inau báaniu liá'a Jesúsca, najiáu útawi rícucha náa'a mashíquishimica, nawárruau lirrícula liá'a chacáalee Dios shínaa jí'ineerri Jerusalén, ya íchaba chóniwenai cábacta nayá. ");
INSERT INTO aca_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Jái'inaa liá'a soldado wácalica ya náa'a yáaine liájcha néeni túyenai Jesús, nacába'inaa cáinabi cúsucoo yá'ee quinínama liá'a bésuneerricoo, cáarru wérri'e nayá ya namá'ee: —¡Yáawaiyii liáni washiálicuerrica Dios Cúulee! ");
INSERT INTO aca_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Íchaba íina yáa néeni cábenai nayá déecucheji, íinuenai Jesús yáajcha Galilea rícucha nayúda liyá. ");
INSERT INTO aca_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Náiibi ruyá lécchoo ruá'a María Magdalenaca ya ruá'a báquetoo Maríaca natúwa náa'a Santiago ya José, ya ruá'a natúwa náa'a nacúulee liá'a Zebedeoca. ");
INSERT INTO aca_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Jái'inaa catáwacai, líinu báqueerri washiálicuerri rícuerri jí'ineerri José, Arimatea néenee sái, liá'a lécchoo éebiderri Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","José yáau licába Pilato néerra, ya lisáta liúcha Jesús máshicaimi quéewique'e liquénicani. Pilato bánua néntregaa Jesús náanaimi Josérru. ");
INSERT INTO aca_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Jáiwa José ya áabi nawína limáshicaimi, nawówanaani áabai wárruma íibi jí'ineerri lino, masáculai, ");
INSERT INTO aca_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ya liwárrueda útawi wáalii rícula José shínaa, liwánani naquéni íiba máanui rícu. Liáwinaami linísa'inaa libáya útawi íiba máanuiyu jíni, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ne ruá'a María Magdalena ya ruá'a báquetoo Maríaca namáacau nawáanicoo útawi júntami. ");
INSERT INTO aca_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Cajójchanaami, liwówai limá, liá'a éerri nawówa íyabactacoo, náa'a sacerdote wácanaica ya náa'a fariséobini náau nacába Pilato, ");
INSERT INTO aca_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ya namá lirrú: —Wawácali, wayá édacanineu liá'a limáni liá'a canúma yúwicaica, cáwi'inaami liyá újnibi, limá'inaa matáli éerri yáwinaami máanalicani shínaa, licáwiominaa báaniu. ");
INSERT INTO aca_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Táda, bánua náa'a soldádoca natúyaque'e útawi, cáashia matáli éerri bésunacoo, jócubeecha náiinu táayee náa'a lishínaa éewidenaicoo ya nanédu limáshicaimi, ya liáwinaami namá chóniwenairru licáwiacaalawai. Libésunactau liáni chá'a, liá'a amáarractalacani númashi yúwica máashii mawí liúcha liá'a quéechanacu sáimica. ");
INSERT INTO aca_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Pilato limá'ee nalí: —Soldado nárra iwáalia áarra natúyaque'e. Yáau itúya útawi léjta yáayu'i léenaa. ");
INSERT INTO aca_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Náau nachúni sáica wérri útawi núma, namáaca sello íiba nácu nabáyau liá'a útawica, quéewique'e nayá náa léenaa tánashia méecu jíni, jáiwa namáaca soldádoca túyacani. ");
INSERT INTO aca_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Libésuna'inau liá'a éerri nawówa íyabactacoo, jái'inaa jucámarrai liá'a éerri quéecha sái semana nácu, María Magdalena ya báquetoo María náau nacába útawi. ");
INSERT INTO aca_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Cawíquinta cáinabi cúsucoo cadánani, jiníwata báqueerri ángel wawácali shínaa yúrrucuerriu áacai, ya lirrúniu útawirru, léeda íiba nabáyau'i útawi núma, jáiwa liwáau líta'aa. ");
INSERT INTO aca_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Liá'a ángelca licámarra quéenaca újni éenu bérrudau'i, ya líibala cabálai wérri. ");
INSERT INTO aca_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nacába'inaa ángel, náa'a soldádoca nachéchinau nacáarruniu ya namáacau újni máanalinica. ");
INSERT INTO aca_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Liá'a ángel limá nalí náa'a íinaca: —O'icáarrudau iyá. Nuá léenaa imúrru imácoo Jesús, liá'a natáatanimi cruz nácu. ");
INSERT INTO aca_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Jiní áani, cáwierriwai, léjta limáyu'umi. Íinu icába áani namáacactami limáshicaimi. ");
INSERT INTO aca_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Yáa namówai madéjcalicu ya íiwa nalíni náa'a éewidenaicoo: ‘Cáwerriwai, ya liáu ibéecha Galilearra, néerra icábajoni.’ Léwa arrúnai'inaa nuíiwa irrú liáni, —limá'ee liá'a ángelca. ");
INSERT INTO aca_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Náa'a íinaca náau madéjcanaa útawi néenee, cáarruni ne sáicta wérri nawówa, ya nacánacau natée chuánshi sáicaica nalí náa'a éewidenaicoo. ");
INSERT INTO aca_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Liyáalimi rímija Jesús jiáu nalí najúnta yáa litáa nalí. Narrúniu Jesúsru natúyau nanánimiyu lirrú ya nashíquia licáwa nácu. ");
INSERT INTO aca_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Jáiwa Jesús ma nalí: —Ocáarru iyá. Yáau íiwa nalí náa'a éewidenaicoo nuájcha, náaque'iniu Galilearra, ya néerra nacába nuyájoo. ");
INSERT INTO aca_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Nácula náa'a íinaca náau náiiwa nalíni náa'a éewidenaicoo, néenaa náa'a soldado túyenai útawi, náiinu chacáalee rícula, ya náiiwa sacerdote wácanairru quinínama liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Náani nawácanaica náau natáania náajcha náa'a salínai wácanaica quéewique'e áabenaa nawówa náajcha. Yá'ee náa íchaba warrúwa nalí náa'a soldádoca, quéewique'e áabenamaa nayáca ya náiiwaque'e léja liá'a namáni náa'a nawácanaica. ");
INSERT INTO aca_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Náa'a nawácanaica néewida nawítee náa'a soldádoca chá'a: —Máta imájoo táayeemi, nácula wamáa wayáca, náa'a éewidenaicoo Jesús shínaaca, náiinu nanédu Jesús máshicaimi. ");
INSERT INTO aca_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Ya wánacaleerri wérri yácta léenaa liáni, wayá wachúni quinínama liájcha, jiní éecha ibésunau'iu. ");
INSERT INTO aca_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Náa'a soldádoca nawína liá'a warrúwa, jáiwa'ee naméda léjta namáyu'i nalí. Íchaba chóniwenai éemi liáni íiwadedeerriu, ya cáashia chóque'e éerri náa'a judíobini namá chá'a. ");
INSERT INTO aca_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Liáwinaami, náa'a once éewidenaicoo náau Galilea néerra, lítala liá'a dúulii Jesús máni nácucha nalí. ");
INSERT INTO aca_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Ya nacába'inaa Jesús, natúyau nanánimiyu lirrú, báawita áabi éewidenaicoo napénsaa nalíwoo jócai liyá liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Jesús rúniu nalí ya limá'ee: —Dios yáa nulí quinínama lidánaniyu áacairra ya cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Yáau nalí náa'a chóniwenai yéenai quinínama cáinabi ítala, ya éewida nayá quéewique'e nushínaa éewidenaicoo nulí; ibáutisa nayá nusálijinaa jí'inaa nácu, ya licúulee ya Espíritu Santo, ");
INSERT INTO aca_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ya éewida nayá naméda liwánacaala liáni quinínama nuwánini iméda iyá. Nuyáminaa, yáajcha éerri jútainchu, cáashia amáarra liá'a éerrica.");
INSERT INTO aca_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Quéechanacu sáicai chuánshi bangéliu Jesucristo Dios Cúulee shínaa. ");
INSERT INTO aca_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Liá'a íiwadedeerri Dios chuáni báinacu Isaías litánanimica limáni Licúuleerru: “Nubánua nubéechau íiwerri'inaa nuchuáni jibéecha, quéewique'e lichúni iníjbaa. ");
INSERT INTO aca_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Báqueerri chóniwerri máidaderri jiníctala yáairri: Ichúni iníjbaa íiwaca lirrú; iméecu áabai iníjbaa machácani”. ");
INSERT INTO aca_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Libésunate'eewoo Juan Bautista íyadau wáunamactaca libáutisa chóniwenai; limá'ee nalí, arrúnaa éejuederri iyáu Diosru ya ibáutisacoo, quéewique'e Dios méetuerri ijíconaa. ");
INSERT INTO aca_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Íchaba náa'a yáainai Judea shínaa cáinabi íta'aa, ya liá'a chacáalee Jerusalén najiáu néemicani. Náiiwa najíconaa Diosru, ya Juan báutisa nayá méeda Jordán yáacula. ");
INSERT INTO aca_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Juan íibala yáairri caméeyu íchunayu, libájini líiwali rícu áabai íimanaayu, ya líya langosta, újni irríchu máanuica ya máaba yáamitu awáca íibisai. ");
INSERT INTO aca_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Léewidacala limá'ee: “Nuáwinaami báqueerri íinu mawí cadánani núcha, jócaita cawówanaa nutájiacoo nuwáseda lishínaa sandalia báji. ");
INSERT INTO aca_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nuyá báutiseerri iyá shiátaiyu; ne liyá liáminaa irrújoo iyá Espíritu Santoyu.” ");
INSERT INTO aca_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Liyáali éerrimite, Jesús jiáu Nazaret rícucha yáairri cáinabi Galilea rícu, ya Juan báutisa méeda Jordán yáacu jíni. ");
INSERT INTO aca_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Quéecha'inaami lijiácoo shiátai yáacucha, Jesús cába éerri méecucoo ya Espíritu Santo yúrrucoo linácula jicá'a áabai paloma. ");
INSERT INTO aca_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Jáiwa'ee Jesús éemi Lisálijinaa chuániu éerri rícueji, máirri'ee: “Jiyáwa Nucúulee caníinai nucábaca, liá'a nuwínanica”. —Cháwa'ee Dios ma licúuleerru. ");
INSERT INTO aca_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Liáwinaami liáni, liá'a Espíritu Santo libánua Jesús liáque'iu jiníctala yáairri. ");
INSERT INTO aca_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Néerra liyá cuarenta éerri, liyá cuéshinai cawálani íibi ya Wawásimi wówairri licába licáacoo liá'a Jesúsca; ya ángelbini íinuenai ya nasírbia lirrú. ");
INSERT INTO aca_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Liáwinaami naníqui Juan cuíta manúmai rícula, Jesús yáau Galilea néerra líiwa liá'a chuánshi sáicaica Dios bánuani líiwaca. ");
INSERT INTO aca_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Jesús má'ee chóniwenairru: “Jái íinucai liá'a léerdica, ya liá'a Dios wánacaalauca urrúnii. Éejoo Diosru ya irríshibia éebidayu liá'a sáicai chuánshica”. ");
INSERT INTO aca_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Áabai éerri Jesús bésuneerriu liácoo Galilea shínaa manuá tácoowa, licába'inaa Simón ya léenajirri Andrés. Yúquenai nayá nashínaa máaya shiátai yáacula. ");
INSERT INTO aca_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesús limá'ee nalí: —Yáau nuájcha, ya nuyá numéda iyájoo catésucani washiálicuenai. ");
INSERT INTO aca_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Liyáalimi namáaca namáayaniu ya náau liájchai. ");
INSERT INTO aca_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Píitui rími libéechalata, Jesús cába Santiago ya léenajirri Juan, Zebedeo éenibi, yéenai áabai lancha rícu nachúni nashínaa máayau. ");
INSERT INTO aca_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Liyáalimi limáida nalí, ya jáiwa'ee namáaca nasálijinaa Zebedeo lancha rícu náajcha náa'a yúdainai liyá, ya náau Jesús yáajchai. ");
INSERT INTO aca_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Náiinu Capernaúm néerra, lirrícula éerrica liwówa íyabactacoo, Jesús wárroo sinagoga rícu (cuíta náawacatau náa'a judíobini) ya lichána léewida'ee nayá chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Náa'a chóniwenaica nacáarrudau nacába léewidacala, jiníwata limédacala quinínama wánacaalashiyuni, ya jócala léewida léjta náa'a éewidenai ley nácu. ");
INSERT INTO aca_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Chacáalee shínaa sinagoga rícu ái báqueerri washiálicuerri wáaleerri áabai espíritu máashii, liyá limáidada'ee Jesúsru: ");
INSERT INTO aca_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","—¿Táda jiwárroo wáajcha Jesús Nazaret néenee sái? ¿Jiyá íinuerri limárda wayá? Nucúnusia jiyá, nuá léenaa jiyá Santo Dios shínaa. Chá'ee limá Jesúsru liá'a espíritu máashiica. ");
INSERT INTO aca_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Jesús cáita liá'a espíritu limá lirrú: —¡Manúmata jimáaca washiálicuerri liéni! ");
INSERT INTO aca_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Liá'a espíritu máashiica licúsuda liá'a washiálicuerrica, ya limáidada cadánani lijiáu liúchai. ");
INSERT INTO aca_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Quinínama nacáarrudau, ya nasáta néemi nayá wáacoo: —¿Tána léji liéni? ¡Léewidaca wáaliyu, ya wáalierri quinínama libánuaca! ¡Lécchoo liá nalí bánua náa'a espíritu máashii ya naméda liwánacaala! ");
INSERT INTO aca_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ya liyáalimi náa léenaa Jesús íiwanaa quinínama Galilea shínaa cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Quéecha'inaami najiácoo sinagoga rícucha, Jesús yáa'eewoo Santiago ya Juan yáajcha, náabana néerra náa'a Simón ya Andrés. ");
INSERT INTO aca_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ruá'a Simón néerruca rúwechoo cama íta'aa bálinechoo ruwáalia licámuna. Jáiwa náiiwa Jesúsru jíni, ");
INSERT INTO aca_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","jáiwa lirrúniwai, liwína rucáaji nácu libárrueda ruyá; liyáalimija léedau rúcha liá'a licámuna, jáiwa rusírbia nalí. ");
INSERT INTO aca_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wówai'inaami cáiwia wárruacuwai samáaque'e, natée quinínama náa'a bálineneecoo ya náa'a wáalianai demonio Jesúsru, ");
INSERT INTO aca_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ya quinínama chacáalee náawacau cuíta núma lícu. ");
INSERT INTO aca_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesús chúni matuínaami bálinacaalashi chóniwenai wáalianica, ya lijéda íchaba demonio; ne jócai línda natáaniaca náa'a demonioca, níwata nacúnusiani. ");
INSERT INTO aca_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ujnicáta'inaa, catáwacai újnibii, Jesús bárroo ya lijiáu chacáalee rícucha quéewique'e liácoo lióracoo chalée jiníctala yáairri. ");
INSERT INTO aca_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simón ya lijúnicai náau namúrru Jesús, ");
INSERT INTO aca_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ya náiinu'inaami jíni namá'ee lirrú: —Quinínama namúrru jiyá. ");
INSERT INTO aca_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ne léeba'ee nachuáni: —Wáau áabata chalée urrúnicta mawí; néeni lécchoo nurrúnaa nuíiwa sáicai chuánshica, linácuejiwa nujiáu liáni. ");
INSERT INTO aca_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Cháwa'ee Jesús jínanicoo quinínama Galilea, líiwa limácoo sáicai chuánshica sinagoga rícuba ya lijéda demonio. ");
INSERT INTO aca_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Báqueerri washiálicuerri bálinerriu chorrówa íyeerri náinaa jí'ineerri lepra nácu, irrúniu Jesúsru, ya litúyau liúrruiu íta'aa limá'ee: —Jiwówaicta jéewa jichúni nushínaa bálinacaalashi. ");
INSERT INTO aca_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Jesús carrúni jináata licábacani; lidúnuni licáajiyu wáni limá: —Jajá, nuwówai ¡Jimáacau sáica! ");
INSERT INTO aca_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Liyáalimi léedau liúcha lepraca bálinerrimicoo ya limáacau sáica. ");
INSERT INTO aca_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Jesús wána liácoo liyáalimi, ya líiwa lirrú bájialanani: ");
INSERT INTO aca_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","—Jicábateni, ujíiwa áabirruni; bácai rími jiáu jíyadacoo sacerdóterru, ya jitée jishínaa jiméetua'inau jiyáu, liá'a Moisés wánanimi imédaca, quéewique'e quinínama yáa léenaa jáica sáica jiyái jibálinacaala yúchau. ");
INSERT INTO aca_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ne liá'a washiálicuerri liáwai, jáiwa líiwadeda quinínamarru jíni liá'a bésuneerricoo. Tándawa Jesús jócai éewa liwárruacoo matuínaami chacáalee rícu, arrúnaa limáacacoo bináaweji, á'a báawachala jinícta chóniwenai; ne quinínama matuínaami náiinu nacába liyá. ");
INSERT INTO aca_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Áabi éerri liáwinaami, Jesús éejoo liwárruacoo Capernaúm rícula. Quéecha'inaami náa'a chóniwenai náa léenaa liyá cuíta lícu, ");
INSERT INTO aca_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","jáiwa náawacau íchaba chóniwenai jócani éenaa cuíta nánibala; ya líiwa nalí sáicai chuánshica. ");
INSERT INTO aca_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Néenee, cuatro washiálicuenai tée lirrú, báqueerri macáwai. ");
INSERT INTO aca_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Ne bájialaca chóniwenai jóca néewa narrúnda Jesúsruni, jáiwa náirrau cuíta íta'aa néeda áabai libáinaa á'a liyáctaca, súwarra rícueji náurrucueda liá'a bálinerricoo liárrubai íta'au lirrú wáctacoo. ");
INSERT INTO aca_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Jesús cába'inaami néebida linácu, limá lirrú liá'a bálinerricoo: —Nucúulee, jijíconaa máaquerriu liméetuacoo. ");
INSERT INTO aca_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Áabi éewidenai yáaine léenaa ley wáaineu nayáca, napénsaa: ");
INSERT INTO aca_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","¿Chíta quéewoo litáaniaca cháji liéni? Lichuáni táanierri máashii Dios nácula. Bácairrimi Dios éewerri liméetua jíconaashi. ");
INSERT INTO aca_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ne Jesús liyáalimi liá léenaa liá'a napénsani nayáca, néenee lisáta léemiu nayá: —¿Tánda ipénsa chárra? ");
INSERT INTO aca_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","¿Tána mawí jócai tráawajui, numá macáwai: “Jijíconaa máaquerriu liméetuacoo”, o numá lirrú: “Jibárroo, jiwína jiárrubaiu jijínau”? ");
INSERT INTO aca_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ne núyadaminaa irrúni nuyá, Washiálicuerri Dios Cúuleeca, wáalierri wánacaalashi cáinabi íta'aa liméetua'inaa jíconaashi. Néenee limá macáwairru: ");
INSERT INTO aca_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","—Numá jirrú, jibárruau, jiwína jiárrubaiu ya jiáu jíibana néerrau. ");
INSERT INTO aca_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Liá'a bálinerricoo libárroo cawíquinta, ya liwína liárrubaiu lijiáu néenee, natuími rícula quinínama. Linácue jiliéni, nacáarrudau quinínama, jáiwa náa sáicai Diosrui, namá'ee: —Jócai wacába cáji chái bésunacoo. ");
INSERT INTO aca_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Liáwinaami Jesús yáu báaniu manuá tácoowala; náa'a chóniwenai yáawacau lirrú, ya liyá léewida nayá. ");
INSERT INTO aca_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Libésuna'inaamiu licába Leví, licúulee liá'a Alfeo, wáairriu liyáca náarrui náa'a cóbrenai impuesto Romarru. Jesús ma lirrú: —Jíinu nuájcha. Leví bárroowai liáu liájchai. ");
INSERT INTO aca_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Jáiwa'ee Jesús íyeerri liyáca Leví íibana néeni, ya íchaba cóbrenai impuesto Romarru, ya áabi chóniwenai máashiini íiwanaa, wáaine'eewoo mésa nácu lécchoo, Jesús yáajcha ya lishínaa éewidenaicoo, jiníwata íchabani náa'a yáainecoo liájcha. ");
INSERT INTO aca_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Áabi éewidenai ley shínaa, náa'a fariséoca, nacába'inaami Jesúsca íyeerri liyáca náajcha quinínama náa'a, nasáta néemi náa'a éewidenaicoo: —¿Tánda ishínaa qéewidacai íya náajcha náa'a cóbrenai impuesto ya náa'a cajíconaanica? ");
INSERT INTO aca_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Jesús éemi'e jíni, yá'ee limá nalí: —Náa'a sáicanica jócani rúnaa médico, náwa rúnaani náa'a bálinenaicoo. Chacábacanaa, nuyá jócai íinu numáida náa'a máinai sáicaca nayá, náwa nuíinu numáida náa'a cajíconaanica. ");
INSERT INTO aca_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Báitate yúnenai nayáca náa'a éewidenaicoo Juan Bautista ya náa'a fariséoca, néenee áabi chóniwenai náa'a'eewoo Jesús néerra nasáta néemiu wáni: —Náa'a Juan shínaa éewidenaicoo ya náa'a fariséoca yúnenai: ¿Tánda jóca jishínaa éewidenaica nayúna? ");
INSERT INTO aca_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Jesús éeba'ee nachuáni: —¿Ya néewa nayúnaa náa'a nabítani áabai boda, nácula nashínaa novio yáa náajcha? Nácula liyá náajcha nashínaa novioca jócani éewa nayúnaaca. ");
INSERT INTO aca_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ne líinuminaa liá'a éerrica natécta'inaa nuyá léjta nashínaa novio; jáicta líinu liá'a éerrica, néenee liyáali éerriminaa nayúnaa. ");
INSERT INTO aca_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Jesús íyada chuánshi mawí litáania linácu liá'a wáalii léewidani jinácu ya liá'a ajuítaimi nawáalianica quéecha. Jiní chúneerri áabai íibalashi dánumimi áabai wáarruma wáalii yáajcha, jiníwata liá'a wáarruma wáaliica liáwaqueda liá'a íibalashi dánumimica jái lisúbirria jíni, ya liá'a shírricuerriu mawí máanuique'e jíni. ");
INSERT INTO aca_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Jiní lécchoo yáa vino wáalii íimanaashi lidánumimi rícu, jiníwata liá'a vino wáaliica wáneerri lisúbirriacoo liá'a íimanaashica, ta lipérdiacoo liá'a vinoca ya íimanaashica. Tándawa arrúnaa yáa vino wáalii íimanaashi wáalii rícu. ");
INSERT INTO aca_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Áabai sábado Jesús jínaneerriu náabanacta banácali, ya lishínaa éewidenaicoo nabésunau náacoo, jáiwa néerrua trigo dácue. ");
INSERT INTO aca_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Jáiwa náa'a fariseo nacába'inaami liáni, nasáta néemiu: —Jicábate, ¿Tánda naméda náa'a jishínaa éewidenaicoo jócai wéewa waméda sábado rícu? ");
INSERT INTO aca_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ne limá nalí: —¿Jócai cáji iliá icábau Dios chuáni nácu, liá'a David médanimica áabai éerrite quéecha'inaamite liyá ya lijúnicaibinica jáiwate nawáalia jiní rúnijinaa ya nasíntia ínaaishi? ");
INSERT INTO aca_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Quéecha'inaami Abiatar yáairri sacerdote wácaliyu, David wárroo Dios íibana rícula, jáiwa líiya liá'a páanica Diosru sáica; bácai sacerdótebini éewa náayacani, jáiwa liá náaya lécchoo náa'a chóniwenai yáainecoo liájcha. ");
INSERT INTO aca_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Jesús túculeda mawí: —Dios limáaca liá'a sábadoca chóniwenairru, ne jócai chóniwenai sábadorru. Náa'a chóniwenai jócai arrúnaa néndaca táanashia namédani sábado rícuii, jiníwata wawácali nísani limáacai. ");
INSERT INTO aca_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Linácueji liéni, nuyá Washiálicuerri Dios Cúuleeca, wáalierri wánacaalishi lécchoo éerri nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Jesús wárroo báaniu sinagoga rícu; lirrícu báqueerri washiálicuerri wáalierri áabai licáaji íshiderriu. ");
INSERT INTO aca_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Náa'a fariseo néda lituínaa Jesúsca lichúnicta nacába sábado rícu, quéewique'e néewa náa lijíconaa. ");
INSERT INTO aca_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Jesús ma lirrú liá'a washiálicuerri cáaji íshiderricoo: —Jibárroo jimédau béewami. ");
INSERT INTO aca_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Jáiwa lisáta léemiu náa'a áabica: —¿Tána wéewa waméda sáica mawí éerri wawówa íyabactacoo: Liá'a sáicaica o léewee jiliá'a máashiica? ¿Wawáseda áabai cáwicashi o wamárdacani? Ne jáiwa manúma nayái. ");
INSERT INTO aca_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Néenee Jesús cába nalí íiwirri liwówa náa'a yáaine litéeji, máashii liwówa cabálinica nawówa, limá lirrú liá'a washiálicuerrica: —Jidáquinia jicáajiu. Liá'a washiálicuerri dáquinia jíni, ya licáaji chúniwai. ");
INSERT INTO aca_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Quéecha'inaami najiácoo fariséoca, nachánau naméda natáaniaca náajcha náa'a heródesbinica quéewique'e náiinua Jesús. ");
INSERT INTO aca_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesús, náaniu íshiirricu íchaba chóniwenai Galilea sánaca, ya liáu lishínaa éewidenaicoo manuá tácoowala. ");
INSERT INTO aca_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Quéecha'inaami náa léenaa máanui limédanica, jáiwa íchaba lécchoo náau nacábacani náa'a Judea sánaca, ya Jerusalén, ya Idumea, cáiwia jiáctejcoo Jordánca ya náa'a cáinabi Tiro ya Sidón. ");
INSERT INTO aca_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Tádawa linácu jiliéni, Jesús bánua jishínaa éewidenaicoorru nawáaliaque'e libéecha madánainaa áabai lancha, quéewique'e jóca chóniwenai bádadani. ");
INSERT INTO aca_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Jiníwata íchaba lichúni, quinínama náa'a bálinenaicoo náiinu linácula nadúnuque'ini. ");
INSERT INTO aca_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Quéecha'inaami espíritu máashiini cábacani, nacáu náurruimiyu lináneewa namáidada'ee: —¡Jiyáwa Dios Cúulee! ");
INSERT INTO aca_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ne Jesús liwána jócu natáania linácu quinínama chóniwenai náneewa. ");
INSERT INTO aca_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Liáwinaami Jesús írrerriu dúuli ítala, jáiwa limáida léjta liwówau. Báitate náawacau, ");
INSERT INTO aca_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","liníwa náiibicha doce, quéewique'e natálidedacani ya quéewique'e libánua náiiwa sáicai chuánshica. Náani liá nají'inaa apóstolubinica. ");
INSERT INTO aca_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Ya liá nalí wánacaalashi najédau'inaa demonio chóniwenai yúcha. ");
INSERT INTO aca_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Náawa liníwani doce náani: Simón, liáni jí'inaa Pé'eru; ");
INSERT INTO aca_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Santiago ya léenajirri Juan, Zebedeo éenibi, limáni jí'inaa Boanerges (liwówa limáca “túrrunerriu éenibi”); ");
INSERT INTO aca_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Andrés, Felipe, Bartolomé, Mateo, Tomás, ya Santiago, Alfeo cúulee; Tadeo, Simón cananeo sái, ");
INSERT INTO aca_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ya Judas Iscariote, liáwinaami wáneerri'inaa náiinua Jesús. ");
INSERT INTO aca_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Liáwinaami Jesús wárroo áabai cuíta rícu, éejoo náawacacoo íchaba chóniwenai, jócai éewa líiyaca ya lishínaa éewidenaicoo. ");
INSERT INTO aca_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Náa'inaami léenaani náa'a Jesús éenajinaica, náau natéecani, namá'ee lócucala éewani. ");
INSERT INTO aca_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Lécchoo quéewidacani ley shínaaca íinuenai Jerusalén néenee namá'ee: “Beelzebú, chúnsai demonio wácalica, léewa yáairri lirrú liéni washiálicuerrica wánacaalashi léewau'inaa lijédacani chóniwenai yúcha”. ");
INSERT INTO aca_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Jesús máida nayá, jáiwa liá nalí áabai licábacanaa limá'ee nalí: “Wawásimi jócai jéda chúnsai Wawásimica. ");
INSERT INTO aca_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Áabai país shírrerriu yáaineu grupoyu máashiini cába yáacacoo, jócani éewa nayá machúnuca; ");
INSERT INTO aca_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ya áabai éenajinai shírreneu, jócai éewa nayáca. ");
INSERT INTO aca_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Cháwa lécchoo ya Wawásimi lishírrictau ya libárroo lináculawoo, jóca éewa liyáca; líinuminaa amáarractala liyá. ");
INSERT INTO aca_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Litáania chítashia wéewau'inaa wagáanaqui jíni Wawásimica, liá'a cadánani wérrica, Jesús má'ee: Jiní éewerri liwárruacoo líibana rícula washiálicuerri cadánanirru ya linédu lishínaa, jóctaca libájidaque'e cháani; bácai cha já'a léewa linéducani. ");
INSERT INTO aca_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Nuíiwa irrú Dios éewerri liméetua quinínama washiálicuenai jíconaa ya quinínama liá'a máashii namánica: ");
INSERT INTO aca_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ne liá'a táanierri máashii Espíritu Santo nácu, jócuminaa lédacaniu linácu liá'a limédanica, máaquerriminau cajíconaiyu mamáarraca.” ");
INSERT INTO aca_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Liéni Jesús máni'e, jiníwata namácala'ee liwáaliacala espíritu máashii. ");
INSERT INTO aca_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Néenimichu ruíinu ruá'a litúwaca ya Jesús éenajinai, jáiwa namáacau bináaweji nabánua namáidacani. ");
INSERT INTO aca_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Náa'a chóniwenai wáainecoo Jesús téeji namá lirrú'e: —Jitúwa, ya jéenajinai ya jéenajetoo yáaine bináawa, namúrru jiyá. ");
INSERT INTO aca_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Jesús éeba nachuáni: —¿Tána nutúwai ya nuéenajinai? ");
INSERT INTO aca_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Jáiwa, licába náa'a wáainecoo litéeji, lidúcueda'ee: —Náawa nutúwa ya nuéenajinai náani. ");
INSERT INTO aca_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Quinínama náa'a médenai Dios wánacaala, léewa nuéenajirri liérra, ya nuéenajetoo ya nutúwa. ");
INSERT INTO aca_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Báaniu lichána léewidaca calísa tácoowa liá'a Jesúsca. Jáiwa náawacau lirrú íchaba wérri chóniwenai, néenee Jesús írrau áabai lancha rícula liérra calísa yáacu, jáiwa liwáawai, nácula chóniwenai máacau litácoowa. ");
INSERT INTO aca_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Néenee léewida nayá íchaba nácu chá'a licábacanaayu. Liyú liá'a léewidau'u limá nalí: ");
INSERT INTO aca_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Éemi liáni: báqueerri cáabanacai liáu licása banácali íimi. ");
INSERT INTO aca_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Liáabana'inaa liyáca áabata líimi cáu liúcha iníjbaa lícu, náiinu náa'a míshiiduca jáiwa náaya jíni. ");
INSERT INTO aca_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Áabata cáu líibi íibaca, jinícta sáica cáinabi, liérra banácalica, jáiwa lipáquiau madéjcata, jócala sáica cáinabi, dujíwalanaa liá'a cáinabica; ");
INSERT INTO aca_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Néenee cáiwia éema jíni lipáquia'inaamiu jiníwata lijíchui, máacarra jíni. ");
INSERT INTO aca_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Áabata léenaa liá'a banácalica cáirriu túwirri íibi, jáiwa túwirri dáwinawai líinua jíni jócu liá lítawai. ");
INSERT INTO aca_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ne áabata liá'a banácalica cáirriu sáiquitacta cáinabi, lidáwinawai liá lítau sáica; áabata yáa lítau léjta treinta bátuinaa, áabata sesenta lítau ya áabata cien.” ");
INSERT INTO aca_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Ne Jesús túculedani mawí: “Náa'a wáalianai nawíbau, néemi'a.” ");
INSERT INTO aca_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Néenee liáwinaami, Jesús máaca'inaamiu bácai, náa'a yéenai urrúni lirrú náajcha náa'a doce léewidanicoo, nasáta néemiu Jesús tánashia liwówai limá léji liéni licábacanaaca. ");
INSERT INTO aca_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Jesús éeba'ee limá'ee nalí: “Iyá Dios wána yáa léenaa jócai náa léenaa liwánacaalactaca shínaaca; ne náa'a jócani éebida Dios nácu numá nalí quinínama licábacanaayu, ");
INSERT INTO aca_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","quéewique'e nacába mawí, ne jócai nacába, ne mawícta éemica jócai éemi, quéewique'e jócai éejoo Diosru, ya tándawa jócai Dios pérdonaa nayá.” ");
INSERT INTO aca_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jáiwa limá nalí: “¿Iyá jócani yáa léenaa éemi licábacanaa liéni? ¿Chíta quéewoo yáa léenaa éemi quinínama áabata?” ");
INSERT INTO aca_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Liá'a yáabaneerri líimi chaléjta liá'a íiwadedeerri Dios shínaa chuánshi. ");
INSERT INTO aca_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ái áabi chaléjta líimi cáirricoo iníjbaa lícu: Néemini liá'a Dios shínaa chuánshi, ne liáwinaami néemicani líinu liá'a Wawásimi ya lijéda liá'a Dios chuáni yáairri nawówa lícu, léjta míshiidu íyau'u banácali íimi cáirricoo iníjbaa lícu. ");
INSERT INTO aca_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ái áabi já'a léjta líimi liá'a náabanani íiba íibi: Éemenai Dios chuáni narríshibia nawówa yáajchau ya néejoo Diosrui, ");
INSERT INTO aca_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ne jócala liwáalia lijíchu sáica, léjta banácali íimi cáirricoo íiba íibi, jócu léewa machácani liyáca; táda linácueji, Dios chuáni nácueji naméda máashii nalí, jócai namáaca nawówa Dios nácu, tánda néewa nacáacoo Dios chuáni yúcha. ");
INSERT INTO aca_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Áabi chaléjta náa'a líimi náabanani túwirri íibi: Éemenai Dios chuáni, ");
INSERT INTO aca_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ne náa'a shínaashica yéenai áani cáinabi íta'aa, nawána urrúni liwówa bájiala, lináinaa liá'a rícucai lichálujueda nayá, nawówaicta nawáalia quinínama cábacanaa. Quinínama liáni liwárroo nanácu, ya jócu línda nadáwinacoo Dios chuáni nácu, léjta banácali jócai éewa liá lítau. ");
INSERT INTO aca_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ne ái áabi éemenai Dios chuáni ya narríshibiani, nayá médenai sáicai, chaléjta líimi náabanani sáicacta cáinabi. Áabi néenaa náani chái léjta lítau yáainai treinta lítau bátui líimi nácu, naméda píituica, áabi chaléjta yáirriu lítau sesenta, naméda íchaba mawí, ya áabi chaléjta yáairri cien lítau, naméda bájialanaa. ");
INSERT INTO aca_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ne limá'ee nalí lécchoo: “¿Ne léquichoo naínda áabai lámpara namáacani cajón yáajaba ya cama yáajaba? Jócai, áabai lámpara namáacani áacai, liquénique'e. ");
INSERT INTO aca_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Chacábacanaa, jiní éenaa libáyacoo liúcha quinínama liá'a léenaajoo, jiní cabáyaintai máacacoo. ");
INSERT INTO aca_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Náa'a nawáalianai nawíbau, néemique'e.” ");
INSERT INTO aca_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ne limá'ee nalí lécchoo: “Yáa liwówanaa linácu sáica liá'a éemini lécchoo. Ne liá'a néenee dáuca liyú Dios éeneda iyá lécchoo; ya liáminaa irrú mawíjoo. ");
INSERT INTO aca_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Liá'a éemerri sáica, yáirri'inaa léenaa mawí, ne liá'a jócai éemi sáica, áawita liyá liá léenaa mawí, liyá pérderri'inaa liá'a píitui rími liáni léenaa nácu.” ");
INSERT INTO aca_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesús má'ee lécchoo: “Dios wánacaala chacábacanaa jicá'a báqueerri washiálicuerri yáabaneerri liáabanacaalau cáinabi íta'aa: ");
INSERT INTO aca_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Chacábacanaa újni jimácta, chacábacanaa újni cábichu liyá, chacábacanaa léjta táayee, léjta éerrinacu, liá'a líimi páquerriu dáwinerriu jócai liá léenaa dáwinau'iu. ");
INSERT INTO aca_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Liyá jájiu liá'a cáinabica liwána: Quéechanacu lipáquiau áabai máashiibeeca, néenee lidáwinau liwínaca, néenee liáwinaami líta cámushederri'inaa lináanaa. ");
INSERT INTO aca_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Jáicta salírrii lítai, liwína jíni, jiníwata jái yácai léerdi rícuwai.” Cháwa jáicta amáarra liáni éerrica, Dios yúcaminaa wayájoo, o lirríshibiaminaa wayájoo áacairra. ");
INSERT INTO aca_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Jesús má'ee lécchoo: “¿Chíta licábacanaa irrú jíni Dios wánacaala? ¿Tánayu ta wéewa wacómparaqui jíni? ");
INSERT INTO aca_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Chaléjta mostaza íimi náabanane cáinabi íta'aa. Léwa áabai banácali íimi mawí píituica yáairri quinínama cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Ne liáwinaami náabana'inaa jíni, jáiwa lidáwinawai mawí máanui quinínama banácali yúcha, léjta áabai áicuba, linácai máanui namái míshiidu éenaa naméda nábanau, libáinaa yáajba. Cha lécchoo, liá'a Dios chuánica náiiwani ya lichána píitui rímiyu, néenee lidáwinawai máanui limédacuwai.” ");
INSERT INTO aca_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Chacábacanaa Jesús éewida nayá linácu liá'a lichuánica, léewida nayá chacábacanaa léjta licábacanaa, limáyu liáni táshia náctala néemiqui jíni. ");
INSERT INTO aca_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Ne jócai limá jiní licábacanaa, báawita éewidenaicoo íiwa quinínama báawachala. ");
INSERT INTO aca_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Liyáali éerri táayeemi, Jesús má'ee lishínaa éewidenaicoorru: —Wáau bajiála manuá, —limá'ee nalí. ");
INSERT INTO aca_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Néenee namáaca náa'a chóniwenaica ya natée Jesús lirrícu liá'a lancha liániu liácoo rícu; ya áabi lancha natálideda náacoo liyá. ");
INSERT INTO aca_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Cawíquinta íinuerri cáuli wérri, áabai cáuli cadánani wérri marrádaca íserriu lancha rícula, jái wáuwai cashiámu shiátaiyui. ");
INSERT INTO aca_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ne Jesús máairri liáju néenee, ruwáirriu liwíta yáarrubai íta'au. Jái nacáweda jíni, namá'ee lirrú: —¡Quéewidacai! ¿Tánda jiní jiwéni jicába wayá báawita jicába waquétacoo wayáca? ");
INSERT INTO aca_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Jesús bárruawai limá'ee cáulirru, ya limá'ee manuárru: —¡Jibórroo! ¡machúnuca! Néenee libárroo cáuli, ya quinínama machúnucai. ");
INSERT INTO aca_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Liáwinaami Jesús má'ee lishínaa éewidenaicoorru: —¿Tánda bájiala cáarru iyá? ¿Ái újnibii jócu éebida nunácu já'a? ");
INSERT INTO aca_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ne nayá bájialani wérri cáarruca, ya nasáta néemiu nayá wáacoo: —¿Tánashia léji liéni, cáuli ya manuá éewidani lirrú? ");
INSERT INTO aca_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Jesús bésunau bajiála manuá náajcha náa'a lishínaa éewidenaicoo, áabai cáinabi ítala, urrúni áabai chacáaleerru jí'ineerri Gerasa. ");
INSERT INTO aca_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jáyaali Jesús jiáu lancha rícucha, néenee báqueerri washiálicuerri rúniu lirrú, wáalierri espíritu máashii, íinu lijúnta lirrícucha náa'a útawi yéenai máanali íibi. ");
INSERT INTO aca_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ne liyá yéerri narrícu náa'a útawica liáni washiálicuerrica, jiní éewa libájica, báawita cadénayu. ");
INSERT INTO aca_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Nabájidanimi íchabachu cadénayu licáaji nácu ya jiárruyu líiba nácu, jiníwata carrúnatai, ne liwíchua náucha liá'a cadénaca ya liá'a jiárruca liwíchua liúchau lécchoo, jiní éenaa libárruedaca. ");
INSERT INTO aca_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Limáu séewirrinaa éerrinacu ya táayee limáidada narrícula náa'a útawica ya náiibi náa'a dúulica, ya íinuederriu íibayu. ");
INSERT INTO aca_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Licába'inaa Jesús déecucheji, néenee licánacau litúyau Jesúsru. ");
INSERT INTO aca_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Néenee liá'a espíritu máashii máidada cadánani limá'ee: ¿Táda jiwárruau nuájcha, Jesús, licúulee liá'a Diosca yéerri áacairra quinínama íta'aa? ¡Nusáta Dios yúcha jócubeecha carrúni jináata nuyá bájiala! ");
INSERT INTO aca_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Limáni liáni Jesúsca ma liyá lirrú: —¡Espíritu máashii, jijiáu liúcha liárra washiálicuerrica! ");
INSERT INTO aca_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Néenee Jesús ma lirrú: —¿Tána jijí'inaa? Ne liyá ma Jesúsru: —Nují'inaa íchabani, jiníwata wayáca íchabani. ");
INSERT INTO aca_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Néenee liá'a espíritu máashiica lisáta'ee bájiala Jesús yúcha, jócu lijéda nayá báawachala liúcha liá'a cáinabica nayáctaca. ");
INSERT INTO aca_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ái íchaba puíti urrúni nalí íyenai dúuli íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Táda nasáta Jesús yúcha namá'ee: —Jibánua wayá nanácula puíti náa'a wawárruaque'iu nawówa rícula. ");
INSERT INTO aca_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Néenee línda náacoo nawárruacoo. Néenee náa'a espíritu máashiinica najiáu liúcha liá'a washiálicuerrica nawárruaque'iu narrícula náa'a puítica, újni dos mil namánabaca, néenee nacánacau danáanshiyu carrátalia íteeji, náa'a puítica nacáacoo manuá yáacula nasácumactala'inau. ");
INSERT INTO aca_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Néenee náa'a natúyenai puíti nacánacawai náiiwaque'e chacáalee rículani ya nalí náa'a yéenai bacháida lícu. Néenee náa'a chóniwenai éemenai liáni íinuenai nacába liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Náiinu'inaa Jesús néerra, néenee nacába liá'a washiálicuerrica wáalierrimi náa'a espíritu máashiica, náa'a espíritu máashiini íchabanica. Nacába liyá wáairriu, líibala rícu, jái sáica wítee, cáarru nacábaqui jíni. ");
INSERT INTO aca_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Néenee náa'a cábeneemi liá'a bésuneerricoo, náiiwadeda nalí chítashia libésunau'u jiliá'a washiálicuerri wáalierrimi náa'a espíritu máashiinica, ya nanácu lécchoo náa'a puítica. ");
INSERT INTO aca_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Táda linácueji nasáta Jesús yúcha nawówa yáajchau, quéewique'e liácoo nashínaa cáinabi ítacha, jiníwata cáarrui nacábaca linácu liá'a Jesús médanica. ");
INSERT INTO aca_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Jesús wárrua'inau liyáca lancha rícula liáque'iu, néenee liá'a wáalierrimi náa'a espíritu máashiini lisáta liúcha liwówa yáajchau liáque'iu liájcha. ");
INSERT INTO aca_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ne Jesús jócai índa liácoo liájcha, limá lirrú: —Jiáu jíibana néerrau jéenajinai íibirrau, jíiwadeda quinínama liáni jiwácali médani jirrú ya chítashia carrúni jináatau'u licába jiyá jíni. ");
INSERT INTO aca_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Néenee liá'a washiálicuerrica liáwai, íineda lichánacoo líiwadedaca narrícuba náa'a chacáaleeca Decápolis shínaaca, liá'a Jesús médanica lirrú, ya quinínama namáacau nacáarrudacoo. ");
INSERT INTO aca_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Quéecha'inaa Jesús éejuacoo lichuácoo bajiála manuá, náawacau lirrú íchaba chóniwenai, liyá yáairri manuá tácoowa. ");
INSERT INTO aca_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Liyáalimi líinu liá'a liwácali liá'a báqueerrica nawácanai náa'a sinagogaca, jí'ineerri Jairo, licába'inaa Jesús litúyau líiba néeni. ");
INSERT INTO aca_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Liyá sáteerri wérri, liwówa limá lirrú: —Numíyacaula máanaliuyaca; jíinu jicháanaa jicáajiu runácu sáicaque'e ya cáwique'e ruyá. ");
INSERT INTO aca_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Jesús yáau liájcha, ya íchaba chóniwenai yáau liájcha bádada yáaquenaiu litéeji. ");
INSERT INTO aca_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Náiibi náa'a chóniwenaica báquetoo íinetoo bálinechoo doce camuí, íirrai éechani. ");
INSERT INTO aca_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Carrúni jináatau bájialanaa íchaba médico cáaji rícueji, rugástaa quinínama liá'a ruwáalianimica, jiní wéni rulí, mawíu rubálinacuwai. ");
INSERT INTO aca_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ruéemi'inaami cáiwanaa Jesús chúnica, jáiwa ruáni íinetooca rurrúniu liwójuna íteeji, chóniwenai íibi, jáiwa rudúnu Jesús íibala nácu. ");
INSERT INTO aca_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Jiníwata rumá'ee rulíwoo: “Nudúnucta líibala nácu, sáicaminaa nuyájoo”. ");
INSERT INTO aca_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Liyáalimi, liá'a íirraica libárroo rúcha, ya rusíntia rutácai rushínaa bálinacaalashi sáica ruyái. ");
INSERT INTO aca_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesús, yá'inaa léenaa lijiácoo liá'a lidánanica lináwau licába chóniwenairru, ya lisáta léemiu nayá: —¿Tána dúnu núbala nácui? ");
INSERT INTO aca_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Lishínaa éewidenaicoo ma lirrú: —Jicába chóniwenai bádada yáaquenaiu, ya jisáta jéemiu “¿Tána dúnu nuyái?” ");
INSERT INTO aca_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ne Jesús licábadeda litéejiu, tánashia licába dúnu liyái. ");
INSERT INTO aca_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Néenee ruá'a íinetooca, cáarru wérri chéchinecho ruáca léenaa liá'a rubésunaucoo, jáiwa ruáwai rutúyacoo lináneewai, ruíiwa lirrú quinínama yáawaiyi. ");
INSERT INTO aca_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Jesús ma rulí: —Numíyacaula, jéebidaca nunácu jisánawai. Jiá namówai chajiwíteemija'a ya sáica jiyái. ");
INSERT INTO aca_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Újnibii Jesús táaneerri liyáca, náiinu lirrú áabi líibana néenee liá'a sinagoga wácanaica, namá'ee lirrú liá'a samáshta sálijinaacarru: —Jimíyacaula máanaliuyi. ¿Táda jijódia liá'a quéewidacaica? ");
INSERT INTO aca_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ne Jesús, jiní limédaca nawánacaala, limá sinagoga wácalirru: —Ocáarru jiyá, jéebida nunácu cháji'i. ");
INSERT INTO aca_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ya nayárrimi já'a tálideda liyá Pé'eru, Santiago ya Juan, Santiago éenajirri. ");
INSERT INTO aca_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Líinu'inaa liácoo líibana néerra liá'a sinagoga wácalica, Jesús éemi nawítama ya licába chóniwenai íchaca ya namáidadaca. ");
INSERT INTO aca_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Liwárroo ya limá nalí: —¿Táda bájiala iméda iwítamau ya ícha chárra? Ruá'a samáshta jócau máanali, máichoo ruyáca. ");
INSERT INTO aca_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Náa'a chóniwenai nacáida Jesús nácu, ne liyá liwána najiácoo bináawala quinínama, ya liwína rusálijinaa ya rutúwa ya náa'a liájcha sánaca, liwárroo ruyáctala ruá'a samáshtaca máanaliuca. ");
INSERT INTO aca_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Liwína rucáaji nácu ya limá rulí: —Talita, cumi (liwówau'i limáca: “miyácau, numá jirrú jibárroo.”) ");
INSERT INTO aca_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Liyáalimi, ruá'a miyácau, wáalechoo doce camuí, rubárroowai ya rujínawai. Ya chóniwenai nacáarrudau nacábacani. ");
INSERT INTO aca_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Ne Jesús bánua wérri nayá jiní éecharru náiiwani, ya jáiwa libánua náaque'e rúya ruá'a samáshtaca. ");
INSERT INTO aca_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Jesús jiérriu lítacha cáinabi néenee liáwai lishínaa cáinabi néerrau, ya lishínaa éewidenaicoo yáaineu liájcha. ");
INSERT INTO aca_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Líinu'inaa liá'a éerri nawówa íyabactacoo, lichána léewidacai sinagoga rícu. Manuábani chóniwenaica, néemi ná'ee Jesús éewidaca, nasáta néemiu nacáarrudau néemicani: —¿Tanácucha léewidau léji liéni bájiala liá'a léenaa? ¿Tanácucha lijéda léji liéni liwíteeshica ya léji liéni jócai wacába cáji limédanica? ");
INSERT INTO aca_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Léwa carpintero liáni, María cúuleeca, Santiago, José ya Judas ya Simón léenajirri, léenajinai íina yáainai wáiibi áani. Tánda jóca néewa naméda liwánacaala. ");
INSERT INTO aca_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ne Jesús má'ee nalí: —Quinínama cáinabi naméda liwánaca liá'a íiwadedeerri Dios chuáni báinacu, ne jócaita lishínaa cáinabi íta'au, jócaita léenajinai íibi ya líibana rícu. ");
INSERT INTO aca_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Jóca léewa liméda jócai wacába cáji, bácai rími licháanaa licáajiu nanácu áabi nabálineneecoo ya lichúnique'e nayá, jiníwita jócala quinínama néebida linácu. ");
INSERT INTO aca_vpl VALUES ("MK6_6a","071_6_6a","MRK","6","6a","6a","Licáarrudau licába nayá jócala chóniwenai éebida linácu. ");
INSERT INTO aca_vpl VALUES ("MK6_6b","071_6_6b","MRK","6","6b","6b","Jesús jínaniu chacáalee júbini rími urrúni léewida limácoo. ");
INSERT INTO aca_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Limáida nayá náa'a doce éewidenaicoo Jesús yáajcha, jáiwa libánua jíni chámatanaa, liá nadánani najédau'inaa espíritu máashiini. ");
INSERT INTO aca_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Jáiwa limá nalí jiní béecha natéeni iníjbaa lícu, báajui rími licháque'e. Jóca néewa natée chácala ya páani ya warrúwa. ");
INSERT INTO aca_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Néewa nasúwa cotiza, ne jóca natée íibalashi áabai rími. ");
INSERT INTO aca_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Limá'ee nalí: —Jáicta iwárroo áabai chacáalee rículai, imáacau áabai cuíta lícu já'a cáashia yáacoo néenee. ");
INSERT INTO aca_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Táshia jócta nawówai narríshibia iyá jíni, jócta nawówa néemirru, ijiáu liúcha icúsudau íiba tábiu, quéewique'e jái náiiwa nalí bésuneerri'inaacoo. ");
INSERT INTO aca_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Néenee najiáwai náa'a éewidenaicoo namá'ee chóniwenairru néejuedaque'e nayáu Diosru. ");
INSERT INTO aca_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Íchaba espíritu máashii najéda lécchoo, ya íchaba nachúni bálineneu nachánaa nanácu aceite. ");
INSERT INTO aca_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Rey Herodes léemi natáania Jesús nácu, líiwanaa cáarralia'eewoo quinínama. Ya limá'ee Heródesca: “Juan Bautista jái cáwiacuwai báaniu, tánda liwáalia lidánaniu, limédau jócai wacába cáji.” ");
INSERT INTO aca_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Áabi má'ee: “Léewa liá'a íiwadedeerri Dios chuáni báinacu Elías ya áabi: Chaléjta íiwadedeerri Dios chuáni báinacu sánamica.” ");
INSERT INTO aca_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Ne Herodes, léemi'inaa lé'ilieni, limá'ee: —Juan waliérra, nuyá wána nawíchua liwíta, ne léejoo licáwiacuwai. ");
INSERT INTO aca_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ruwánaca ruá'a Herodíasca, Herodes wána nawína Juan ya nawána nabájicani cadénayu ya nawárrueda cuíta manúmai rícula, Herodías líinu liá'a Felipeca, éenajirri liá'a Herodes, ne Herodes cáaserriu ruájcha. ");
INSERT INTO aca_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Juan má'ee Heródesru: “Jóca jéewa jiwáalia jíinuyu wáni, jiníwata jéenajirri íinu.” ");
INSERT INTO aca_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Herodías máashii rucába Juan limáca rulí jóca ruéewa rumáacoo liá'a Herodes, ne ruwówaine ruíinuaca; ne jócai ruéewa ruíinuaca. ");
INSERT INTO aca_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Jiníwata cáarruca Herodes, yáa léenaa liyá washiálicuerri sáicai wítee ne litúyani. Libánua namáidaca quéewique'e litáaniani lirrú, báawita léemicani jiní léewa limédacani, Herodes sáictaimi éemi Juan mánica. ");
INSERT INTO aca_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Né'e Herodías rucába'inaami éerri íinu rulí léjta ruwówau ruíinua Juan, ne líinu'inaa'ee lirrú liá'a Herodes licúmplia camuí, liméda áabai fiesta máanui nalí náa'a nawácanai mawí máanuica ya nalí náa'a chóniwenaica cawéni wérri náa'a Galilea sánaca. ");
INSERT INTO aca_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Né'e Herodías míyacaula, ruwárroo sáictacactala wérri nawówa rícula, Jáiwa'ee ruwáila, jáiwa'ee Herodes ligústaa wérri ya náa'a íyanai liájcha, ne rey má'ee rulí íinetooca: —Jisáta núcha tánashia jiwówaini, nuáni'inaa jirrú. ");
INSERT INTO aca_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Yá'ee lijúra'eewoo limá'ee rulí yáawaiyi numá jirrú, nuáminaa jirrú tánashia sátani núchai, báawita arrúnaa nuá jirrú béewami cáinabi. ");
INSERT INTO aca_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Jáiwa'ee rujiáwai rusáta ruéemiu rutúwau: —¿Tána nusátai? Jáiwa'ee rumá rulí: —Sáta Juan Bautista wíta. ");
INSERT INTO aca_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ruá'a íinetooca jáiwa'ee ruwárroo madéjcanaa liyácta liá'a reyca, ya rumá'ee lirrú: —Nuwówai madéjcanaa jiá nulí Juan Bautista wítami mitájia rícu, quéewique'e quinínama cábacani. ");
INSERT INTO aca_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Rey éemi'inaami ruchuáni, jáiwa máashii liwówai; ne lijúracala'eewau nanáneewa náa'a chóniwenai limáidanica, jócai liwówa liásacala rúcha liá'a rusáta liúcha. ");
INSERT INTO aca_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Néenimichu'e libánua báqueerri soldado lishínaa wánacaleerri rícueji litéeque'e lirrú Juan wítami. ");
INSERT INTO aca_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Liá'a soldado liáu cuíta manúmai rícula, jáiwa liwíchua Juan wítai, jáiwa litée mitájia rícu jíni. Jáiwa'ee liá rulí jíni ruá'a íinetooca, ne ruyá jáiwa ruá rutúwarru jíni. ");
INSERT INTO aca_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Náa'inaa léenaa jíni náa'a máinecoo Juan yáajcha, jáiwa nawína limáashiicaimi, jáiwa'ee náau nabáyaqui jíni. ");
INSERT INTO aca_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Quéecha'inaami néejoocoo chacáalee rícucha náa'a Jesús bánuani náiiwadeda Dios chuáni, náawacau Jesús yáajcha, náiiwadeda lirrú quinínama liá'a namédanica ya liá'a néewidauca. ");
INSERT INTO aca_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Jesús má'ee nalí: —Íinucherra, iyáawoo iyábitau wá'au wawówa íyabactacoo íchaitaa á'a wáunamactaca. Jiníwata íchaba chóniwenai yáainaiu ya éejuenaiu, nayá jiní nalí yáarrushi náayau'inaa. ");
INSERT INTO aca_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesús ya lishínaa éewideneubinica yáainaiu áabai lancha rícu chaléenii wáunamactalaca. ");
INSERT INTO aca_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ne íchaba cába náacoo, ya nacúnusia nayá; néenee quinínama náa'a chacáalee rícu sánaca nacánacau néerra, náiinu'e nabéecha. ");
INSERT INTO aca_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Liúrrucua'inaawai lancha rícucha, licába íchaba chóniwenai, jáiwa'ee carrúni jináata licába nayái, jiníwata yáainai bácainaa léjta oveja jinícta shínaa pastor, ya jáiwa léewida nayái íchaba Dios chuáni nácu. ");
INSERT INTO aca_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Táicala náawacau lirrú náa'a lishínaa éewideneu namá lirrú: —Jái táicala cái áani jiníctawa yáairri liáni. ");
INSERT INTO aca_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Jíiwa jináwau nalí náa'a chóniwenaica, quéewique'e náau bacháidala ya chacáalee júbini yáainai litéeji ya nawéni íyacaishi náayau. ");
INSERT INTO aca_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ne Jesús má'ee nalí: —Yáa náaya iyá. Namá'ee: —¿Jiwówai wáa'au wawéni páani, chái léjta tráawajo doscientos éerri tácani liwéni, quéewique'e wáa náaya? Íchabani, jócani wéenaa wáa íya. ");
INSERT INTO aca_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Jesús má'ee nalí: —¿Ta mánabaca páani iwáalia jíni? Yáau icábacani. Quéecha'inaa nacábaqui jíni, namá lirrú: —Cinco páani rími ya chámai cubái. ");
INSERT INTO aca_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Jáiwa limá nalí libánua nayá nawáaque'eu macáishita imíshi ulé íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Jáiwa nawáawai macáishita áabi wáau cien ya áabi cincuéntanaa. ");
INSERT INTO aca_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Néenee Jesús wína licáaji rícuu, liá'a cinco páanica ya náa'a chámai cubáica, jáiwa licába áacairra, liá sáicai Diosru, litúcueda liá páanica lishínaa éewideneurru nachújidaque'ini chóniwenairru. Lichújida lécchoo liá'a chámai cubáica quinínama chóniwenai nácu. ");
INSERT INTO aca_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Quinínama náaya cáawaina wérri namáacau sáicta nawówa. ");
INSERT INTO aca_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Jáiwa náawaqueda léenaami liá'a máaquerricoo páanica ya cubái ya nacámusheda doce canastas. ");
INSERT INTO aca_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Náa'a íyenaicani liá'a páanica cinco mil washiálicuenai. ");
INSERT INTO aca_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Jesús nísa'inaa'ee liá chóniwenai íyai, liwána'ee nawárruacoo náa'a lishínaa éewideneu lancha rícula nabésunaque'iu libéecha bajiála áabai chacáaleerra jí'ineerri Betsaida, nácula libánua náacoo náabana néerrau náa'a chóniwenai. ");
INSERT INTO aca_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Linísa'inaa'ee libánua náacoo náabana néerrau, lijiáu dúuli ítala li'óraca. ");
INSERT INTO aca_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Néenee samásama'inaa, liá'a lanchaca jái ya béewami manuá. Yá Jesús máaquerriu macáshtai bácai; ");
INSERT INTO aca_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","licába'ee tráawaju natéeniaca, cáuli cánacacaa'eewoo najúnta. Ujnicáta'inaa'ee, lirrúni'eewoo nanácula jínerri'eewoo shiátai náninacu jái'e wówai libésunacuwai. ");
INSERT INTO aca_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nacába'inaa'ee lijínacoo shiátai náninacu, napénsa'ee natuí rícusai chái léjta wówanaashi, néenee namáidada'ee; ");
INSERT INTO aca_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","jiníwata nacába'ee quinínama cáarru'e nacábacani. Ne madéjcanaa litáania náajcha limá'ee nalí: —¡Nuyácani, sáicta iwówa! ¡O'icáarrudau! ");
INSERT INTO aca_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Linísa'inaa'ee litáania náajchai, liwárrua'eewoo náajcha lancha rícula. Linísa'inaa'ee liwárruacuwai, cáuli íyaba'eewoowai, nacáarrudau wérri'e nacábacani. ");
INSERT INTO aca_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Jócta néenaa nédacanicoo linácu páanimica, nawítee cabálini, jócala néenaa náa léenaa sáica Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Jesús lishínaa éewideneu yáajchau nabésunau bajiála manuá náiinu lijí'inacta Genesaret, nabájita nashínaa lancha manuá tácoowa. ");
INSERT INTO aca_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Cawíquinta najiá'inau lancha rícucha náa'a chóniwenai náa léenaa Jesúsqui jíni. ");
INSERT INTO aca_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Najiá'eewoo quinínama lirrícu liá'a nayáctaca, nachána'ee natéeca liárrubai íta'au náa'a bálineneecoo nácta léenaa Jesús yáaca. ");
INSERT INTO aca_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Táshia Jesús wárruactau liácoo jíni, báawita báawachalacani, chacáalee júbini rícula, o chacáalee rícula o bacháida lícu, najéda náa'a bálineneecoo bináawala ya namésuda Jesús wówa nadúnuque'e líibala númacua nácu; ya quinínama nadúnuenai linácu namáacau sáica nayái. ");
INSERT INTO aca_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Narrúniu lirrú fariséoca Jesúsru, náajcha náa'a áabi quéewidacani ley shínanaaca íinuenai Jerusalén néenee. ");
INSERT INTO aca_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Náani, nacába'inaa néenaa náa'a Jesús shínaa éewidenaicoo, náaya nacáaji sáculau, liwówau'i limáca, jócu nabádeda nacáajiu éerri jútainchu, natáania máashii nanácu. ");
INSERT INTO aca_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Jiníwata náa'a fariséobini ya quinínama judíobinica nasíguia naméda nawítee báinacu sáimi, jócani íya jócta nabádeda nacáajiu léjta arrúnaa nabádedacani. ");
INSERT INTO aca_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Ya néejo'inau nawéniqui téejica, jócau íya jóctanaa nabádeda icáajiu libéecha. Ya lécchoo nawáalia íchaba áabi wíteeshi, léjta nabádedau báasu, náa'a jáarru, náa'a mulíquia jiárru shínaa ya náa'a camaca. ");
INSERT INTO aca_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Táda, náa'a fariséobini ya náa'a quéewidacani ley shínaa nasáta néemiu Jesús: —¿Táda jishínaa éewidenaicoo jócani síguia naméda nawítee báinacu sáimi, jócta náaya nacáajiu masáculai? ");
INSERT INTO aca_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Jesús éeba'ee nayá: —Sáicai litáania nácu liá'a íiwadedeerri Dios chuáni báinacu Isaíasca ishínaa chámai wítee, litána'inaa linácu: ‘Liéni chacáalee nanúmayu natáania nanácu sáica, ne nawówa déecuchai ya núcha, jócani éemi nulí. ");
INSERT INTO aca_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Jiní sírbiani naméda culto nulí, nashínaa néewidacala washiálicuerri wánacaala.’ ");
INSERT INTO aca_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Táda iyá imáaca liá'a Dios bánuani namédacala, quéewique'e nasíguia naméda nawítee báinacu sáimi washiálicuerri shínaa. ");
INSERT INTO aca_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Lécchoo limá nalí: —Quéewique'e nawáalia mamáarraca naméda nawítee báinacu sáimi, iyá bésuneneu liwícau liá'a Dios bánuani imédaca. ");
INSERT INTO aca_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Táda Moisés ma: ‘Caníinaa jicába jisálijinau ya jitúwa’, ya liá'a mándisierri jisálijinau ya jitúwa, éewerri máanalica. ");
INSERT INTO aca_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ne iyá imá yáawacaala báqueerri washiálicuerri éewerri limá lisálijinaarru o litúwarru: “Jócu nuéwa nuyúda jiyá, jiníwata quinínama liá'a nuwáalianica ‘corbán’ (liwówau'i limáca, fréserriu Diosru”); ");
INSERT INTO aca_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ya lécchoo yáawacaala tánashia máirri liéni jái jócai arrúnaa yúda jisálijinau o jitúwa. ");
INSERT INTO aca_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Chái liérra iyá quiní wéni liá'a Dios bánuanica liyú liá'a naméda liwítee báinacu sáimi liá'a ibésunaidani irrú wáacoo. Ya iméda áabata íchaba méenaami áabenamai. ");
INSERT INTO aca_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Jáiwa Jesús máida chóniwenai ya limá: —Éemi nulí quinínama ya yáa léenaa éemica: ");
INSERT INTO aca_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Jiní liá'a wárruerricoo bináaweji (íyacaishi wáayanica) léewa máashii liméda chóniwenai. Liá'a liérricoo washiálicuerri wówa lícueji liyáwa wáneerri máashii chóniwenai.  ");
INSERT INTO aca_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Iyá wáalenee iwíbau éemiu. ");
INSERT INTO aca_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Quéecha'inaa Jesús máaca chóniwenai ya liwárroo cuíta lícula, lishínaa éewidenaicoo nasáta néemiu liyá linácu liáni léewidauca. ");
INSERT INTO aca_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Liyá ma nalí: —¿Cha iyá lécchoo jócai yáa léenaa? ¿Jóca yáa léenaa éemi quiní liá'a wárruerricoo bináawe éewa máashii liméda chóniwenai, ");
INSERT INTO aca_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","táda jócai wárroo wówashi rícula, jócta yáawaishi rícula, quéewique'e liáwinaami lijiácoo tácaishi yúcha? Liyú liáni léewidauca liwówa limá quinínama íyacaishi masáculani. ");
INSERT INTO aca_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Limá lécchoo: —Liá'a jiérricoo washiálicuerri yúcha, ta liyá méderriu casáculai liá'a washiálicuerri. ");
INSERT INTO aca_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Táda lirrícueji, liwówa limáca, nawówa licuéji náa'a washiálicuenaica, najiáu náa'a máashiini íinuerri nawíta lícu, máashii namédani náinaayu, náa'a nédishi, cáiinuacabini, ");
INSERT INTO aca_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","náa'a báawachala líinu yúchau, wówairri lirrúwoo quinínama, náa'a máashiicaica, liá'a cháluedacalashi, náa'a ísadenecoo naméda máashii, cadéni cába áabi shínaa, náa'a númashi yúwica, sáictai cábacoo áabi yúcha, ya cháucta liwítee pénsaca. ");
INSERT INTO aca_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Quinínama náani méenaami máashiinica jiáneu narrícueji ya naméda máashii chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Néenee lijiáu Jesús lítala liá'a cáinabi jí'ineerri Tiro. Liwárroo áabai cuíta rícula, jiní liwówaini yáa léenaa; ne jócai léewa libáyacoo. ");
INSERT INTO aca_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Madéjcanaa ruá léenaa rutúwa ruá'a báquetoo miyácauca wáalechoo áabai espíritu casáculai, ruyá ruáni íinetooca ruíinu rutúyacoo Jesús íiba néeni. ");
INSERT INTO aca_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ruá'a íinetoo áabai cáinabi báawata ítesana, yéechoo sirofenicia rícu. Néenee ruáu, ya rusáta bájiala Jesús quéewique'e lijéda rumíyacaula yúcha liá'a demonioca. ");
INSERT INTO aca_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ne Jesús ma rulí: —Jída náaya quéecha náa'a néenibica náa'a judíobinica, jiníwata jócai sáica néda náucha páani náa'a néenibica náaque'e nalí náa'a áulica, náa'a báawacha sánaca. ");
INSERT INTO aca_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ruyá ruéeba liúchani: —Jajá, nuwácali, ne cáashia áuli íyene mésa yáajaba lítabi náidani cáacoo náa'a néenibica. ");
INSERT INTO aca_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Jesús ma rulí: —Jiyá táaniechoo sáica; jéewa jiácowai. Liá'a demonioca jái jiácoo jimíyacaula yúchai. ");
INSERT INTO aca_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jái'inaa ruíinu rúbana néerrau, ruíinu rumíyacaula cama íta'aa, ne demonio jái jiácoo rúchai. ");
INSERT INTO aca_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Jesús éejoo lijiácoo lítacha liá'a cáinabi jí'ineerri Tiro, ya libésunau Sidón, ya náa'a chacáalee yáaine lirrícu liá'a cáinabi jí'ineerri Decápolis, líinu Galilea shínaa manuá néerra. ");
INSERT INTO aca_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Néeni naínda lirrú báqueerri jócai éemi ya jócai táaniaca, ya nasáta liúcha lichánaque'e licáajiu linácu. ");
INSERT INTO aca_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Jesús tée báawachala, náucha náa'a chóniwenaica, liníqui licáaji shíwianaa liwíba rícu, ya jáiwa lérrueyu lidúnu líinane. ");
INSERT INTO aca_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Jáiwa, licába áacairra, léejueda licálesau máanui ya limá lirrú liá'a washiálicuerrica: “¡Efata!” (liwówa limáca, “¡jiméecu!”). ");
INSERT INTO aca_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Liyáalimi, liwíba liá'a jócani éemi liméecuwai, ya líinane máacau sáica léewa litáaniacai sáicai. ");
INSERT INTO aca_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Jesús bánua nayá jiní éecharru náiiwani; ne áawita libánua jócubeecha náiiwani, mawí náiiwadedaca. ");
INSERT INTO aca_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Bájialai nacáarrudacoo nacábaca, namá: “Quinínama liméda sáicai. ¡Cáashia léewa liméda náa'a jócani éemi néemique'e ya náa'a jócani táania natáaniaque'e!” ");
INSERT INTO aca_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Áabai éerri báaniu náawacau íchaba chóniwenai ya jiní nawáalia náaya'inaaca, Jesús máida lishínaa éewidenaicoo ya limá nalí: ");
INSERT INTO aca_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","—Nusíntia carrúni jináata náani chóniwenai, jiníwata jái matálii éerri nayá nuájcha áani ya jiní wáaliani náaya'inaa. ");
INSERT INTO aca_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Ya nubánuacta nayá jiní náayaca nábana néerrau, néewa májina nayá iníjbaa lícu, jiníwata áabi íinuene déecucheji. ");
INSERT INTO aca_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Lishínaa éewidenaicoo néeba liúcha: —¿Ne chíta quéewoo wáa náaya áani, jinícta yéerri? ");
INSERT INTO aca_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Jesús sáta léemiu nayá: —¿Chíta máanaba páani iwáalia iyá jíni? —Siete —néeba nayáni. ");
INSERT INTO aca_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Néenee libánua nawáacoo náa'a chóniwenaica cáinabi rícu, liwína licáaji rícu náa'a siete páanica, ya néenee liáwinaami liá sáica Diosru, lipúrraida ya liá lishínaa éewidenaicoorru, ya nayá jáiwa nashírrida chóniwenai nácu. ");
INSERT INTO aca_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nawáalia lécchoo jócai íchaba cubái rími; Jesús yá sáicai Diosru nanácu, ya lécchoo libánua nashírrida. ");
INSERT INTO aca_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Quinínama náayaca cáashia namáacacoo cáawaina, ya újnibii cashiámui siete canasta liyú liá'a litábimi máaquerricoo. ");
INSERT INTO aca_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Náa'a íyeneca urrúnini yáca cuatro mílru. Jáiwa Jesús líiwa lináwau, ");
INSERT INTO aca_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","liwárroo lancha rícula lishínaa éewideneu yáajchau, ya liáu liá'a cáinabi jí'ineerri Dalmanuta. ");
INSERT INTO aca_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Náiinu náa'a fariséobinica naméda yáacacoo Jesús yáajcha. Ya quéewique'e naméda lirrú áabai trampa, nasáta liúcha limédaque'e áabai jócai nacába cáji, quéewique'e néeneda yáawacta Dios bánuajani. ");
INSERT INTO aca_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Jesús léejueda licálesau máanui ya limá: —¿Táda nasáta náani chóniwenai áabai jócai nacába cáji? Nuyá yáawai numáca irrú jiníminaa numédani icába. ");
INSERT INTO aca_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Néenee limáaca nayá, ya léejoo liúrrucocoo lancha rícula liáu bajiála manuá. ");
INSERT INTO aca_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Náa'a éewidenaicoo Jesús yáajcha namíya máecha natée íyacaishi, ya bánai rími báshida páani nawáalia lancha rícu. ");
INSERT INTO aca_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Jesús íiwa nalí: —Icába, yúchau liá'a levadura fariséobini shínaaca ya lécchoo liá'a Herodes shínaaca. ");
INSERT INTO aca_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ne jócu náa léenaa néemi Jesús wówaini limáca, náa'a lishínaa éewidenaicoo Jesús yáajcha, natáania'ee nalí wáacoo: —Limá walí liáni jócala waínda páani. ");
INSERT INTO aca_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Jesús yáa'inaa léenaa, limá nalí: —¿Táda imá jiníca irrú páani? ¿Újnibii jócai yáa léenaa éemica jiní yáaca léenaa? ¿Iwáalia iwíteu cabálini wérri? ");
INSERT INTO aca_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","¿Iwáalia ituíu ya jócai icábaca, ya iwíba jócai éemi? ¿Jócu édacaniu? ");
INSERT INTO aca_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Quéecha'inaa nuchújida cinco páani nanácu náa'a cinco mil washiálicuenai, ¿chíta máanaba canasta cashiámui lishídami yáawacaida jíni? Nayá éeba: —Doce. ");
INSERT INTO aca_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","—Ya quéecha'inaa nuchújida náa'a siete páani nanácu náa'a cuatro mílca, ¿chíta máanaba canasta cashiámui yáawacaida jíni? Nayá éeba: —Siete. ");
INSERT INTO aca_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Néenee limá nalí: —¿Újnibii jócu yáa léenaa? ");
INSERT INTO aca_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Liáwinaami Jesús ya lishínaa éewidenaicoo náiinu áabai chacáalee rícula jí'ineerri Betsaida, néenee náinda lirrú báqueerri matuíyii nasáta liyá nawówa yáajchau lidúnuque'e linácu, lichúnique'ini. ");
INSERT INTO aca_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Néenee Jesús wína licáaji nácu liá'a matuíyiica lijéda báawachala chacáalee yúcha jíni. Néenee liwísa lituí íta'aa lichánaa náa'a licáajicoo linácu lisáta léemiu liyá áicta léewani licábaca já'a. ");
INSERT INTO aca_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Néenee licába liá'a matuíyiica limá'ee: —Nucába washiálicuenai újnini áicubaca ne jíneneu. ");
INSERT INTO aca_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Néenee Jesús chánaa náa'a licáajicoo lituí íta'aa bániu néenee liwána licábacai. Néenee lichúniwai liá'a matuíyiica licába quinínama jucámarranaa. ");
INSERT INTO aca_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Néenee Jesús bánua líibana néerra jíni limá lirrú: —Ojiwárruau chacáalee rículajoo, jiní jíiwanirru néerrajooni. ");
INSERT INTO aca_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Liáwinaami liéni, Jesús ya lishínaa éewideneu náau náa'a chacáalee júbini lítala liá'a cáinabi jí'ineerri Cesarea Filipo shínaa. Iníjbaa lícu Jesús sáta léemiu lishínaa éewidenaicoo: —¿Tána namá náa'a chóniwenaica tánashia nuyá? ");
INSERT INTO aca_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nayá éebani: —Áabi ma jiyácala liá'a Juan Bautista, áabi ma jiyácala liá'a íiwaderri Dios chuáni báinacu Elías, ya áabi ma jiyácala báqueerri néenaa náa'a éewidenai Dios chuáni báinacumi. ");
INSERT INTO aca_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","—Ya iyá ¿tánashia imá nuyái? —lisáta nayá. Pé'eru éeba liúcha: —Jiyáwa liá'a Mesíasca, liá'a Dios bánuani liméda sáicai chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ne Jesús bánua nayá jócubeecha natáania linácu, liyácala liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Jesús chánau léewida nayá, Nuyá Washiálicuerri Dios Cúuleeca arrúnai'inaa carrúni jináata'inaa médacoo bájiala, ya nacháani nuyá náa'a salínaica, náa'a sacerdótebini wácanai ya náa'a quéewidacani ley shínaa. Limá nalí, nuyá náiinuani'inaa, ne matálii éerri ricúla nucáwiaujoo. ");
INSERT INTO aca_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Liáni líiwani nalí jucámarranaa. Néenee Pé'eru tée liyá báawachalani ya licáitacani. ");
INSERT INTO aca_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ne Jesús linácuau, licába nalí náa'a éewidenecoo ya licáita Pé'eru, limá lirrú: —¡Jidánau núcha, Wawásimi! Jiyá jócai cába léjta Dios cábau'u, jiyá cáberri léjta washiálicuenai cábau'u. ");
INSERT INTO aca_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Jáiwa Jesús limáida náa'a lishínaa éewidenaicoo ya chóniwenai, ya limá: —Tánashia wówairri limédacoo nushínaa éewidenaicoo, limíya máecha liyá jájiu, liánaida lishínaa cruz ya jiáu nuíshiirricu. ");
INSERT INTO aca_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Jiníwata liá'a wówerri liyá léjta liwítee wówau'u, jócuminaa líinu licáwicau sáica Dios yáajcha; ne liá'a yúquerri licáwicau nunácueji ya linácueji liá'a chuánshi wásedeerrica, liwásedaminaujoo. ");
INSERT INTO aca_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","¿Tána lisírbia washiálicuerrirru ligáanacta quinínama éerri, ya liúcacta licáwicau Dios yúcha báawachala? ");
INSERT INTO aca_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Jiní éeneerri washiálicuerrica lipáida quéewique'e liwáalia licáwicau Dios yáajcha. ");
INSERT INTO aca_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Áicta áabi báini nunácueji ya nushínaa chuánshi nácueji nanáneewa náani chóniwenai jócani éebida ya mamáarraca cajíconaani, cha lécchoo nuyá Washiálicuerri Dios Cúuleeca báiminaa nucába liyá, jáicta nuíinu nusálijinaa balíbalicta lichúnicayu ya nuájcha majíconaani náa'a ángelbini. ");
INSERT INTO aca_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesús lécchoo limá nalí: Numá irrú yáawaiyi néenaa náani yáaine áani nunáneewa jócani'inaa máanali cáashia nacába liá'a Dios wánacaalaca líinu lidánaniyu. ");
INSERT INTO aca_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Seis éerri liáwinaami, Jesús yáu áabai dúuli áacai ítala, litée liájcha yáu Pé'eru, ya Santiago ya Juan. Néeni, nanáneewa, libáwachau licábacanau liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Líibala náawerriu quirrámini, cabálai wérri quinínama yúcha liá'a nabádedaniquictani. ");
INSERT INTO aca_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jáiwa nacába Elías ya Moisés táanianai nayá Jesús yáajcha. ");
INSERT INTO aca_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Pé'eru má'ee Jesúsru: —Quéewidacai, ¡sáicai wérri wayá áani! Waméda matálii cuíta rími: áabai jirrú sái'inaa, áabai Moisésru, ya áabai Elíasru. ");
INSERT INTO aca_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Jiníwata náa'a éewidenaicoo cáarrudenaiu, ya Pé'eru jócai liá léenaa liá'a limáni liyáca. ");
INSERT INTO aca_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Liyáalimi, áabai sáanai yúrrucoo nanácu catámuana. Jáiwa áabai chuánshi, jiáu sáanai íibeji limá'ee: “Léewa nucúulee caníinai nucába liéni, éemiu lirrú”. ");
INSERT INTO aca_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Liyáalimi, nacába'inaami natéejiu, jiní nacábani náajcha, Jesús bácai rími. ");
INSERT INTO aca_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Nácula náurrucoo náacoo dúuli ítacha, Jesús yáarra nayá jócubeecha náiiwadeda nayá áabi rúni liá'a nacábanica, cáashia Nuyá Washiálicuerri Dios Cúuleeca cáwiacoo máanali íibicha. ");
INSERT INTO aca_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Linácu jiliéni nawáaliadani nawíta lícuu, áawita nasáta néemiu nayá jájiu tánashia léji liá'a licáwiacoo máanalini íibicha. ");
INSERT INTO aca_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Nasáta'ee néemiu Jesús: —¿Tánda namá náa'a quéewidacani ley shínaaca Elíasca'ee arrúnai íinu quéecha nácu? ");
INSERT INTO aca_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Néenee léeba nachuáni: —Yáawaiyi arrúnaa Elías íinu quéecha nácu, liyáminaajoo lichúni quinínamani. Tándawa namá náa'a cáashtaca arrúnaacala Nuyá Washiálicuerri Dios Cúuleeca carrúni jináatayu ya nacháani nuyá. ");
INSERT INTO aca_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ne nuyá ma irrú Elías jái íinucai, ne nayá naméda liájcha léjta nawówau, léjta litánau'inimi limáyu'u linácu cháa. ");
INSERT INTO aca_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Quéecha nácu'inaami néejoocoo náacoo nayáctala náa'a áabi néenaaca éewidenaicoo Jesús yáajcha, náiinu nanácu íchabani wérri chóniwenai natéeji, ya áabi quéewidacani ley shínaaca méda yáaqueneu nayá náajcha. ");
INSERT INTO aca_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ne nacába'inaami Jesús, quinínama nacánacau natáa lirrú nacáarrudacalau. ");
INSERT INTO aca_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Néenee Jesús sáta léemiu nayá: —¿Tána ijútau iméda iyá náajchai? ");
INSERT INTO aca_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ne báqueerri yáairri liyá néeni léeba: —Quéewidacai, nuínda nucúuleu áani, wáaleerri áabai espíritu máaquerri liyá machuáni. ");
INSERT INTO aca_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Táshia nácucha liyácta jíni, liá'a espíritu liwínani liúcani cáinabi rícula; ya cacáli jiáu liwálicueji, liwána liá'a muéda léu, ya limáacau cadácani. Ne nusáta jishínaa éewidenaicoo yúcha najédaque'e liúcha liá'a espírituca, ne jócai néenaa. ");
INSERT INTO aca_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Jesús éeba'ee: —¡Chóniwenai jócani éebida! ¿Cachálita arrúnaa nuyá yáajcha mamáarraca jíni? ¿Cachálita arrúnaa nuwánta yáajcha jíni? Índa liérra icúlirrijui máyala áani. ");
INSERT INTO aca_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Néenee natée liá'a icúulirrijui Jesúsru. Ne quéecha'inaami espíritu cába Jesús, liwána icúulirrijui cúcunacoo, jáiwa licáu cáinabi ricúla liwówanaanicoo cacálibee jiáu liwálicueji. ");
INSERT INTO aca_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Jesús sáta léemiu lisálijinaa: —¿Cachálitami liwáalia cháiqui jiliérra? Lisálijinaa éeba: —Rícue samálitaqui jíni. ");
INSERT INTO aca_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ya íchabachu liérra espírituca liúcani chichái ricúla ya shiátai yáacula, líinuaque'ini. Jéewacta jimédacani walí, carrúni jináata jicába wayá ya jiyúda wayá. ");
INSERT INTO aca_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Jesús má'ee lirrú: —¿Chíta ‘Jéewacta jimédacani’? ¡Quinínama éewacoo lirrú liá'a éebiderri nunácu! ");
INSERT INTO aca_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Néenee lisálijinaa liá'a icúulirrijuica limáidada: —Nuyá éebiderri. ¡Jiyúda nuéebida mawí! ");
INSERT INTO aca_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Jesús cába'inaami náawacacoo íchaba chóniwenai, licáita liá'a espíritu máashii, limá'ee: —Espíritu jócai índa táaniaca ya mawíbai nuyá wána jijíacoo liúcha liérra icúulirrijuica ya ujéejoo jiwárruacoo linácu mawiá. ");
INSERT INTO aca_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Liá'a espíritu limáidada, liwána icúulirrijui cúcunacoo. Jáiwa lijiáu liúchai, limáacani jicá'a máanali, tánda íchaba ma máanalicalani. ");
INSERT INTO aca_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ne Jesús wína licáaji nácu, libárruedaque'ini; jáiwa libárroo liá'a icúulirrijuica. ");
INSERT INTO aca_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Néenee Jesús wárroo áabai cuíta licúla, jáiwa lishínaa éewidenaicoo sáta néemiu liyái nayá bítau: —¿Tánda jócu wéenaa wajéda liérra espírituca? ");
INSERT INTO aca_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ne Jesús éeba'ee: —Liéni demonio cháica'a jiáirriu bácai oración ya ayúnoyu. ");
INSERT INTO aca_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Quéecha'inaami náacoo chéni, nayáctami nayáca nabésunau Galileai. Ne Jesús jócai liwówai áabi yáa léenaa táshia nayá jíni, ");
INSERT INTO aca_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","jiníwata éewiderri liyá lishínaa éewidenaiu liájcha. Limá'ee nalí: —Nuyá Washiálicuerri Dios Cúuleeca néntregaani'inaa nayá nalí náa'a washiálicuenaica, ya náiinuaminaa nuyájoo; ne matálii éerri ricúla nucáwiaujoo máanalicai yúcha. ");
INSERT INTO aca_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ne nayá jócai náa léenaa néemica liúcha cáarru nasáta néemiwani. ");
INSERT INTO aca_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Néenee náiinu chacáalee jí'ineerri Capernaúm. Nayá'inaami cuíta ricúla, Jesús sáta léemiu nayá éewidenaicoo liájcha: —¿Tána ijútau yáacoo iníjbaa lícui? ");
INSERT INTO aca_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ne jáiwa manúma nayái, jiníwata iníjbaa lícuu jútenaiu náiinuca tánashia mawí cawénii wérri náiibicha. ");
INSERT INTO aca_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Néenee Jesús liwáawai, limáida náa'a doceca, limá nalí: —Tánashia wówerri quéecha nácu, arrúnai'inaa náishiirricuu quinínama yúcha, ya lishírrueda nalí quinínama. ");
INSERT INTO aca_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Jáiwa libárrueda béewami nalí báqueerri samálita, jáiwa liwína liná licúlau jíni limá nalí: ");
INSERT INTO aca_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","—Tánashia ríshibierri nují'inaa nácu báqueerri samálita léjta liéni, ríshibierri nuyá; ya liá'a ríshibierricta nuyáni, jócai bábaujta lirríshibia nuyá, ya lécchoo liá'a bánuerri nuyá. ");
INSERT INTO aca_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Juan má'ee lirrú: —Quéewidacai, wacába báqueerri jéderri demonio jijí'inaa nácu, ne jócaica wáajcha sái jíni, jáiwa waprúbibia liúcha jíni. ");
INSERT INTO aca_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Jáiwa Jesús éeba'ee: —Jócai iprúbibia liúchani, jiníwata liá'a méderri jócai nacába cáji nují'inaa nácu, jócai éewa litáania máashii nunácueji. ");
INSERT INTO aca_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ne liá'a jócaicta ya wajúntami, yáairri wáajcha. ");
INSERT INTO aca_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Matuínaami tánashia yáairri írra áabai báasu shiátai iyá Cristo shínaaca, yáawai numá irrú liwáaliaminaa liwéniujoo. ");
INSERT INTO aca_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Matuínaami tánashia wáneerri nacáacoo jíconaashi rícula náani áabi júbini éebidenai nunácu, Dios cástigaa liyá, sáictami náuca manuá yáaculani áabai íiba wérri liwánacoo nabájini linácula. ");
INSERT INTO aca_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Ne jicáajiquicta wána jicáacoo jíconaashi rícula, ujiméda máashii, jicá'a liá'a wíchuerri jicáajiu; sáicai jiwárruacoo macáaji áacairra, ne jócubeecha chámai jicáajiyu jiáu jibárruacoo infierno rícula, chaléeni jóctala chichái éewa lichácacoo.  ");
INSERT INTO aca_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Chaléeni jóctala máanali dalánai, ya chichái jócai chácacajiu. ");
INSERT INTO aca_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Ne jíibacta wána jicáacoo jíconaashi rícula, ujiméda máashii, jicá'a liá'a wíchuerri jíibau; sáicai jiwárruacoo áacairra macáwa, ne jócubeecha chámai jíibayu jiáu jibárruacoo infierno rícula.  ");
INSERT INTO aca_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Chaléeni jóctala máanali dalánai, ya chichái jócai chácau. ");
INSERT INTO aca_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ne jituícta wána jicáacoo jíconaashi rícula, ujiméda máashii, jicá'a liá'a jijédanica jituíu; sáicai jiwárruacoo bátui tuíshiyu Dios wánacaalactaca ricúla, ne jócubeecha chámatui jituíyu jicáu infierno ricúla. ");
INSERT INTO aca_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Chaléeni jóctala máanali dalánai, ya chichái jócai chácacajiu. ");
INSERT INTO aca_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Jiníwata quinínama mináajoo nasálau chicháiyu, liwówau limáaca arrúnaa wabésunacoo íchaba cacháninai íibeji. ");
INSERT INTO aca_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Iwíduma sáicai; ne jáicta majúwacani, ¿chíta quéewau éewa iwána lisírbia bániu jíni? Iyá léjta iwíduma sáicaica, sáica iyá iyáwaacoo.” ");
INSERT INTO aca_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesús jiáu Capernaúm néenee, jáiwa liáu Judea shínaa cáinabi ítala, cáiwia jiáctejcoo Jordán shínaa cáinabi ítala. Néeni néejoo náawacacoo lirrú náa'a chóniwenaica, jáiwa léejoo léewida nayái léjta limédau'uni séewirrinaa. ");
INSERT INTO aca_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Áabi fariséobini narrúniu Jesúsru, quéewique'e néneda nacába wáni, nasáta néemiu wáni washiálicuerri léewacta limáaca líinu, léjta wawítee báinacu. ");
INSERT INTO aca_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Jáiwa léeba nachuáni: —¿Tána Moisés bánua imédacai? ");
INSERT INTO aca_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Namá'ee: —Moisés máca néewaca namáaca naníinaiu, liá nalí áabai cáashta namáaca yáaca'inau. ");
INSERT INTO aca_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Néenee Jesús ma nalí: —Moisés yáa irrú liérra wánacaalashica liyá júrricacala iyá. ");
INSERT INTO aca_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ne quéechanacu'inaami Dios quénuda cáinabi, Dios quénuda washiálicuerri ya íinetoo, ");
INSERT INTO aca_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Linácu jiliéni washiálicuerri shírriu lisálijinaa yúcha ya litúwa quéewique'e cáinu liyá. ");
INSERT INTO aca_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ne nayá chámata léjta chóniwenaica áabaiminaa nayája. Chá'a jóca chámata nayá mawiájani bácaicai. ");
INSERT INTO aca_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Linácue jiliéni liá'a washiálicuerrica jócai éewa lishírrica liá'a Dios rúndanica. ");
INSERT INTO aca_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Jái'inaami nayá cuíta rículai lishínaa éewidenaicoo sáta néemiu liyá linácue jiliéni. ");
INSERT INTO aca_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Jesús má'ee nalí: —Tánashia liá'a máaquerri líinu ya licásau báquetoo yáajcha, liméda máashii líinayu runácula ruá'a quéecha nácu sáumica. ");
INSERT INTO aca_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ya íinetoo mácacta rúneerriu ya rucásau báqueerri yáajcha, chái cábacanaa ruméda ruíinayu máashii. ");
INSERT INTO aca_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Natée Jesúsru áabi sáamanai lidúnuque'ini; ne náa'a éewidenaicoo jáiwa nacáita náa'a téenei lirrúni. ");
INSERT INTO aca_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Jesús cába'inaami jíni liáni, íwirri liwówa ya limá nalí: —Imáaca sáamanai íinu nulí, ya u'ipróbibia núchani, jiníwata náa'a éebidenai Dios nácu, léjta náani sáamanaica, jócai éewa náiinuminaa Dios néerra. ");
INSERT INTO aca_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Yáawai numá irrú jócta éebida Dios nácu léjta náani sáamanaica, jócai éewa liwárroocoo néerra. ");
INSERT INTO aca_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Jáiwa linácuda limá licú sáamanai, jáiwa liá nalí sáicai nayái lichánaa licáajiu nanácu. ");
INSERT INTO aca_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jái'inaa Jesús jiáu liwína liájabau, báqueerri washiálicuerri cánacau líinuca litúyau lirrú, lisáta léemiu jíni limá lirrú: —Quéewidacai sáicai, ¿tána arrúnaa numédacai quéewique'e nuyá Dios yáajcha mamáarraca? ");
INSERT INTO aca_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Néenee Jesús ma lirrú: —¿Táda jiá nují'inaa sáicai? Jiní sáicai, bácai Dios. ");
INSERT INTO aca_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Jiá léenaa náa'a Dios wánacaalau'uca: ‘Ujíinua; Ujimá báquetoo yáajcha jíinu yúchau, (ujimá báqueerri yáajcha jíinirri yúchau lécchoo); ujinédu; ujiméda jinúma yúwicau báqueerri nácucha; ujichálueda; cawáunta jisálijinau ya jitúwa lécchoo.’ ");
INSERT INTO aca_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Néenee limá Jesúsru liá'a washiálicuerrica: —Quéewidacai, quinínama liáni numédani icúulirrijuicteji nuyá. ");
INSERT INTO aca_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Néenee Jesús cába lirrú caníinaa licába liyái limá lirrú: —Cháucta jirrú áabai rími mawí: Jiáu, jiwénda quinínama liá'a jiwáalianica ya jiá nalíni náa'a carrúni jináatanica. Jiwáaliaminaa méenaami chaléeni áacairrajoo. Néenee jíinu jijínanicoo nuájcha. ");
INSERT INTO aca_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Néenee liá'a washiálicuerrica, linísa'inaa léemi liá'a Jesús máni lirrú, liúrrucueda liwówau liáwai máashii wérrica liwówa yáacoo, bájialaca rícuerricani. ");
INSERT INTO aca_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Néenee Jesús cába náa'a lishínaa éewidenaicoo yéenai litéeji limá nalí: —¡Tráawajui wérri nalí náa'a rícubinica nawárrua'inau Dios wánacaalactalaca! ");
INSERT INTO aca_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Néenee náa'a lishínaa éewidenaicoo nacáarrudau néemi lichuáni, ne Jesús éejoo limá nalí: —Nuéenibi, ¡tráawajui wérri nalí náa'a máaquenai nawówau warrúwa nácu nawárrua'inau Dios wánacaalactalaca! ");
INSERT INTO aca_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Tráawajui mawí báqueerri rícuerrirru liwárrua'inau Dios wánacaalactalaca liúcha léjta áabai caméeyu jócai éewa libésunacoo ishídui tuí rícueji. ");
INSERT INTO aca_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Néenee nacárrudau wérri néemicani namá'ee nalíwaacoo: —¿Yáawaicta liáni, tána éewa líinu Dios néerra? ");
INSERT INTO aca_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Néenee Jesús cába nalí limá nalí: —Chóniwenai jócai néewa naméda liáni, ne Dios, léewaca liméda, ne Dios léewaca liméda quinínama. ");
INSERT INTO aca_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jáiwa Pé'eru ma lirrúi: —Wayá wamáacani quinínama liá'a wawáalianimica, quéewique'e wéewa wasíguia jiyá. ");
INSERT INTO aca_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Jesús éeba'ee: —Ne yáawaiyi namá irrú matuínaami máaquerricta nunácueji o nuchuáni nácueji sálwerrica limáacacta líibanau, o léenajinai, o léenajetoo, o litúwa, o lisálijinaa, o léenibi, o cáinabi, ");
INSERT INTO aca_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","lirríshibiaminaa lirrícu liéni éerrica, cien cuíta yúcha mawí, léenajinai, léenajetoo, litúwanai, léenibi ya cáinabi, báawita namúrru iyá namédaque'e irrú máashii; ya liá'a éerri íinuerrica iwáaliaminaa cáwicashi jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Ne íchaba náa'a chóque'e cawéninica, nayáminaa mawénini'inaa; ya íchabaminaa chóque'e náa'a mawéninimica, nayáminaa cawénini'inaa. ");
INSERT INTO aca_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ná'eewoo Jerusalénra, Jesús jínerriu éewidenaicoo béecha. Ne nayá cáarrudenaiu, ne náa'a yáainecoo líshiirricu cáarruni. Jesús éejoo limáida náa'a doce éewidenaicoo báawachala, jáiwa líiwa nalí liá'a libésuna'inaacoo. ");
INSERT INTO aca_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Léjta icábau'uni, wayá yáaineu Jerusalénra, chaléeni nuyá Washiálicuerri Dios Cúulee'inaaca néntregaani'inaa nuyá nalí náa'a sacerdótebini wácanaica, ya nalí náa'a quéewidacai ley shínaa, nawánaminaa náiinuacojoni nuyá, ya néntregaaminaajoni nuyá nalí náa'a bájirra cáinabi ítesanaca. ");
INSERT INTO aca_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Nacáidaminaa nuyájoo, nawísadaminaa nuyá, náiinuedaminaa nuyá ya náiinuaminaa nuyájoo; ne matáli éerri yáwinaami nucáwiaminaujoo máanalicai yúcha.” ");
INSERT INTO aca_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Santiago ya Juan, Zebedeo éenibi, narrúniu Jesúsru namá'ee lirrú: —Quéewidacai, wawówai jiméda walí áabai sáicai wasátani'inaa jiúcha. ");
INSERT INTO aca_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ne lisáta léemiu nayái: —¿Tána iwówai numéda irrúi? ");
INSERT INTO aca_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Namá'ee lirrú: —Jimáca walí jiwána wawáacoo jiwánacaalactaca balíbalictaca báqueerri sáicaquicteji ya báqueerri apáulicueji. ");
INSERT INTO aca_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Jesús éeba'ee: —Iyá jócai yáa léenaa isátanica. Nuyá carrúni jináata'inaa namédaca ya náiinua nuyá. ¿Iyá éenaa iméda carrúni jináata ya máanali iyá léjta nuyá? ");
INSERT INTO aca_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Jáiwa néebai: —Wéenani. Jesús má'ee nalí: —Iyá carrúni jináatani namédaca ya máanali iyá léjta máanali nuyá; ");
INSERT INTO aca_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ne iwáayu'inau sáicaquictejica o apáulicueji, jócai nutóca nuá irrú, ne náa'a nusálijinaa wínani quéecha, náwa wáaine'inau néeni nárra. ");
INSERT INTO aca_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Quéecha'inaami néemicani náa'a áabi diez éewidenaicoo, jáiwa íwirri nawówai Santiago yáajcha ya Juan. ");
INSERT INTO aca_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ne Jesús máida'ee nalí limá'ee: —Léjta yáayu léenaani, náiibi náa'a jócani éebida, ái wánacaleerri nayá já'a mawí máanui cábacoo náucha, ya náa'a máanuini cábacoo áacai nacábacoo áabi yúcha. ");
INSERT INTO aca_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ne íibicha jócai éewa chácaarra. Báawacha wáucha, iyá, liá'a wówerri máanui limédacoo íibicha, arrúnaa lisírbia quinínamarru. ");
INSERT INTO aca_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ne liá'a íibicha wówerri limédacoo cawéniyu arrúnaa lishírrueda áabirru. ");
INSERT INTO aca_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Jiníwata Nuyá Washiálicuerri Dios Cúuleeca, íinuca jócai nasírbia nulí, nuyá íinuerri nusírbiaque'e nalí, ya máanali nuyá quéewique'e nuwáseda íchaba jíconaa. ");
INSERT INTO aca_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Liáwinaami Jesús íinu áabai chacáalee rícula jí'ineerri Jericó náajcha náa'a lishínaa éewideneu. Jáyaali najiáu Jericó rícula, íchaba chóniwenai yáajcha, néenee báqueerri matuíyii jí'ineerri Bartimeo, licúulee liá'a Timeoca, wáairriu liyáca iníjbaa éemanacu sáteerri warrúwa chóniwenai yúcha. ");
INSERT INTO aca_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Léemi'inaa liyáca Jesús Nasaret sái, néenee limáida liá'a matuíyiica limá'ee: —¡Jesús, David táqueerrimi, carrúni jináata jicába nuyá! ");
INSERT INTO aca_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Néenee íchaba cáita liyá quéewique'e manúmata liyáca, ne limáidada danáanshiyu mawí: —¡Jesús, David táqueerrimi, carrúni jináata jicába nuyá! ");
INSERT INTO aca_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Néenee Jesús bárruawai limá'ee: —Imáida lirrú. Néenee namáida lirrúi matuíyiica namá lirrú: —Cadánani, jiwówa, jibárroo, limáida jirrú liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Néenee liúca lishínaa sábanawai léjta ruana liá'a Bartimeoca léenu libárruacoo líinu Jesús néerra. ");
INSERT INTO aca_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Néenee Jesús sáta léemiu jíni limá lirrú: —¿Tána jiwówai numéda jirrúi? Liá'a matuíyiica limá Jesúsru: —Nuwácali, nuwówai nucábaca báaniu. ");
INSERT INTO aca_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Néenee Jesús ma lirrú: —Jéewa jiácuwai. Nunísa nuchúni jiyái jéebidacala nunácu. Madéjcanaa léewa licábaca liá'a matuíyiica liáu Jesús yáajcha iníjbaa lícui. ");
INSERT INTO aca_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Quéecha'inaami urrúni nayá Jerusalénru, á'a chacáalee Betfagé ya Betania rícu, urrúni lirrú liá'a Olivos shínaa awácaca, Jesús bánua chámata lishínaa éewidenaicoo, ");
INSERT INTO aca_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","limá'ee nalí: —Yáayu'u áabai chacáalee píitui rími júntami, iwárruaminau néerrajoo íinuminaa áabai burro bájerriu, jiní írracajiu íta'aa újnibii. Iwásedani ya ta índaque'e jíni. ");
INSERT INTO aca_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ne áabi sátacta néemi iyá tánda imédani, imá nalí wawácalirru náani, ne liyáalimin léejueda irrújoni. ");
INSERT INTO aca_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jáiwa náawai, náiinu linácu liá'a búrroca cáaye rícu, bájerriu cuíta núma lícu, jáiwa nawáseda jíni. ");
INSERT INTO aca_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Áabi yáaine nayá néeni nasáta néemiu nayá: —¿Tána imédai? ¿Tánda iwáseda liárra búrroca? ");
INSERT INTO aca_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ne néeba nachuáni léjta Jesús máyu'u nalí; jáiwa naínda náacuwai. ");
INSERT INTO aca_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Néenee namáaca náabalau burro íta'aa ta natée Jesúsru jíni. Jáiwa Jesús írrau burro íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Íchaba dáquinia náabalau iníjbaa lícu, liá'a Jesús bésunactacoo, ya áabi dáquinia áicuba nácai nawíchua bacháida lícu. ");
INSERT INTO aca_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ya náa'a yáainecoo libéecha ya líshiirricu, namáidada'ee: —¡Cawéni wérri! ¡Sáicai wérri íinuerri lijí'inaa nácu Wawácali Diosca! ");
INSERT INTO aca_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","¡Sáicai wérri líinuca liá'a wánacaleerrica, léjta wawérri Davidmi wánacaalactamica lishínaami sáictai wérri! ¡Cawéni wérri Jesúsru áacairra! ");
INSERT INTO aca_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Jesús wárroo Jerusalénra jáiwa liáu templo néerra. Licábadeda litéejiu néenee ta liácoo Betania néerra náajcha náa'a doce éewidenaicoo, níwata jái táicalacai. ");
INSERT INTO aca_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Áabai éerri ricúla, najiá'inaamiu Betania rícueji, Jesús síntia ínaaishi. ");
INSERT INTO aca_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Déecucheji licába áabai higuera cabáinai, jáiwa lirrúniwai licába cátactani, ne líinu licába liyáwoo libáinaaca, jócala léerdi liá'a lítau. ");
INSERT INTO aca_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Néenee limá higuérarrui: —¡Jiníminaa mawiá éejoo líiya jíta mawiá! Lishínaa éewidenaicoo néemini. ");
INSERT INTO aca_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Liáwinaami Jesús íinu Jerusalénra náajcha náa'a lishínaa éewidenaicooca. Quéecha'inaa liwárruacuwai (lishínaa patio ítala liá'a) templo máanuica, néenee licába náa'a wéndenai néeni ya náa'a wénenai lécchoo. Néenee ya ta liúca bináawala jíni. Lináawida nashínaa mésa náa'a cámbianai warrúwa chóniwenairru, ya náarrubai náa'a wéndenai paloma, ");
INSERT INTO aca_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","jócu línda jiní'eecha bésuneerriu templo rícueji tánashia natéenii. ");
INSERT INTO aca_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Néenee léewida nayá limá nalí: —Jái tánacuwai, ‘Núbana jí'inaaminaa cuíta na'óracta'inaa náa'a quinínama chóniwenai yéenai cáinabi íta'aa’, ne iyá médani léjta áabai útawi canédibini shínaa. (Jesús ma nalí liáni náa'a wéndenaica nachálujuedacala chóniwenai.) ");
INSERT INTO aca_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Néemi'inaa liá'a Jesús médani náa'a sacerdote wácanai ya náa'a quéewidacai ley shínaa, néenee namúrru chítashia náiinuau'u'inaa Jesús jíni, cáarrucaa nacábacani, níwata quinínama chóniwenai cáarrudau néemi léewidacala, sáicta néemi lécchuni. ");
INSERT INTO aca_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ne catáawaca'inaa, Jesús jiáu lirrícucha liá'a chacáaleeca lishínaa éewidenaicoo yáajcha. ");
INSERT INTO aca_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Manúlacai'inaami néejoo nabésunacoo higuera júntami, jáiwa nacába jíni míishii lijíchu yáajchau. ");
INSERT INTO aca_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Néenee Pé'eru, lédacaniu bésuneerricoo, limá'ee Jesúsru: —Quéewidacai, jicábate, liá'a higuera jimándisiani míishiyii. ");
INSERT INTO aca_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Jesús éeba'ee: —Éebida Dios nácu. ");
INSERT INTO aca_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ne báqueerri chóniwerri éebidacta liwówa yáajchau Dios nácu éewerri limá lirrú liáni dúulica: ‘¡Cachéerra, jichánau manuá yáacula!’, ya yáawaa léebidaca cháminaa libésunacoo léjta limáyu. ");
INSERT INTO aca_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Tándawa numá irrú quinínama liá'a isátani Dios yúcha, éebidani jái íinucai, ya irríshibiaminaajoni. ");
INSERT INTO aca_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ne jáicta isáta iyá Dios, ipérdonaa yáacau jáicta máashii imédani irrúwacoo, quéewique'e isálijinaa yáairri áacai liméetuaque'e ijíconaa lécchoo.  ");
INSERT INTO aca_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ne jóctaca ipérdonaa, chacábacanaa isálijinaa yáairri áacai jócai lipérdonaa ijíconaa lécchoo. ");
INSERT INTO aca_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Liáwinaami liáni néejoo Jerusalénra. Nácula Jesús jínaniu templo rícu, jáiwa narrúniu lirrúi náa'a sacerdótebini wácanai, náa'a quéewidacai ley shínaaca, ya náa'a salínaica, ");
INSERT INTO aca_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ya nasáta néemiu wáni: —¿Tána wíteeshiyu jiúqueda nashínaa náa'a cawéndacani templo rícu? ¿Tána yáa jirrú wíteeshi jimédau'inaani? ");
INSERT INTO aca_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","30","Jesús éeba'ee nachuáni: —Nuyá lécchoo nusáta nuéemiu iyá: ¿Tána bánua Juan Bautístaca, Dios o washiálicuenai? Éeba nulíni. Ne íiwacta nulíni, nuyáminaa lécchoo nuíiwaminaa irrú tánashia wíteeshiyu numéda léji liéni. ");
INSERT INTO aca_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jáiwa nachánau najútacoo nayá wáacoo: “Ne wamácta lirrú Dios bánuani, limáminaajoo: ‘Néenee, ¿ne tánda jóca éebida lirrúi?’ ");
INSERT INTO aca_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ne wamácta washiálicuenai bánuani,” íiwirriminaa chóniwenai wówa wáajcha, quinínama yáine léenaa yáawaiyii, Juan táania yáawaiyi Dios rícueji. ");
INSERT INTO aca_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Jáiwa néeba Jesúsrui: —Jócu wáa léenaa. Néenee Jesús éebai: —Ya nuyá chajá'a jóca nuíiwa irrú tánashia wíteeshiyu numéda léji liéni. ");
INSERT INTO aca_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesús litáania nalí licábacanaayu. Limá'ee nalí: “Báqueerri washiálicuerri liáabana uva yáanai, jáiwa lirríjcueda litéejii; lichánau lichúni liárrui limédacta'inaa vino, jáiwa libárrueda áabai torre quéewique'e litúyacani quinínama. Néenee liá nalí jíni lishínaa shínaashiwai áabi tráawajadorbinirru, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Léerdi'inaami náawaqueda banácali íta, libánua báqueerri lishínaa tráawajadorru yáairri liájcha, lisáta náucha náa'a cáabanacani lishínaa cáinabi íta'aa, léenaa liá'a shínaashi éenaaca banácali íta litócani'inaaca. ");
INSERT INTO aca_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ne jáiwa nawína liyái, náiinuedaque'ini nabánuani cháaji macáaji rícu sái. ");
INSERT INTO aca_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Néenee liá'a liwácalica libánua báqueerri léenaa, ne liáni nawánani catúca liwíta nácu ya nacáitadeda liyá. ");
INSERT INTO aca_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Libánua báqueerri jáiwa náiinua jíni. Liáwinaami libánua áabi íchabani; ya áabi nabásedani ya áabi náiinuani. ");
INSERT INTO aca_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Újnibii limáacau lirrú báqueerri: Licúulee, caníinai wérri licábaca. Último libánua liyá lipénsaa lirrúwoo: ‘Cájbami cawáunta nacába liáni nucúuleeca.’ ");
INSERT INTO aca_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Ne namá nalíwoo, náa'a cáabanacanica: ‘Lé'inaa léju liáni ríshibierri'inaa liá'a máacaderricoo jáicta máanali lisálijinaajoo, wáiinuani washínaa áani quinínama.’ ");
INSERT INTO aca_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Jáiwa'ee nawína jíni, náiinua jíni ya náuca jíni limáashiicaimi bináawala banácali yúcha. ");
INSERT INTO aca_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“¿Ya tána imá irrúwoo tána liméda liá'a liwácali liá'a banácalica? Ya liáminau líinuaca náa'a cáabanacánica, liáminaa liá'a banácalica áabirru. ");
INSERT INTO aca_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","“¿Jóca iliá icábau liá'a Dios chuánica? Limáctaca: ‘Cristo léjta liá'a íibaca nacháninica náa'a camédacaica, liyá'inaawa íiba chúnsai sáicaca. ");
INSERT INTO aca_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Liáni limédani liá'a Wánacaleerrica, ya wayá cárrudenaiu.’ ” ");
INSERT INTO aca_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Néenee náa'a wánacaleenai judíobini nawówai'e natée Jesús preso, jiníwata náaca léenaa liméda licábacanaa nanácula. Ne cáarru nayái chóniwenai nácueji, néenee namáaca jíni, ya náawai. ");
INSERT INTO aca_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Nabánua Jesús náa'a áabica fariséobinica ya lishínaa néenaa náa'a Heródesca, quéewique'e nawána limá áabata náucaque'e linácue jíni. ");
INSERT INTO aca_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Nayá janárra ma lirrúni: —Quéewidacai, wáa léenaa jimáni yáawaiyi, jócala jínda natée jiwítee jiní cáarrucala jicába chóniwenaica, áabenaacala jimédacoo quinínama chóniwenai yáajcha. Jiyá éewiderriu yáawaa léjta Dios máyu'u. ¿Sáicai wérri wapáidacta impuesto lirrú liá'a romano wácalirru, o jócta wapáida? ¿Arrúnaa wapáida o jócuwee wapáidani? ");
INSERT INTO aca_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ne Jesús, yáirri léenaa nawówaicala naméda lirrú máashii, limá nalí: —¿Tánda iméda nulí trampa? Índa nulí áabai moneda nucába áani. ");
INSERT INTO aca_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Natée jíni, ya Jesús ma nalí: —¿Tána náani léji liérra ya liérra jí'inaa tánerricoo lináni nácu? Namá'ee néebacani: —César, romanobini wácali. ");
INSERT INTO aca_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Néenee Jesús ma nalí: —Ne yáa lirrú liá'a César tánashia lishínaa, ya Diosru liá'a lishínaa lécchoo. Ya liá'a léebau náuchani nacáarrudau wérri néemicani. ");
INSERT INTO aca_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Néenee náau nacába Jesús áabi néenaa náa'a saduceoca. Namá'ee náani náa'a máanalinica jócani éewa nacáwiacoo mawiá; táda náau nalí namá chá'a: ");
INSERT INTO aca_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","—Quéewidacai, Moisés máacani tánerriu báqueerri washiálicuerri máanali cáinui ya jiní licúulee ruájcha ruá'a líinuca, liá'a léenajirrica liwínaminaa líinu ruá'a máanirriuca, náa'a léenibi jiáinecoo, máaquenaimicoo léenibiyu liá'a léenajirri máanalimica. ");
INSERT INTO aca_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Wée sáicai wérri, áitee já'a siete léenajinai, liá'a quéecha nácu sáica cáserriu, jáiwa máanali jíni jócai máaca licúuleu. ");
INSERT INTO aca_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Néenee liá'a líshiirricusaica licásau ruájcha ruá'a mánirriuca, liyá chái máanalica jiní máacani licúuleu. Chacábacanaa liá'a báqueerri léenajirri líshiirricusai lécchoo, ");
INSERT INTO aca_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ya náajcha náa'a sieteca; ne jiní wérri éeneerri limáca licúuleu. Néenee máanali ruá'a líinumica. ");
INSERT INTO aca_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Wée sáicai wérri, jáicta rucáwiaujoo, nayá náajcha wáacojoo báaniu, ¿Tánashia néenaa náani rúnirri'inaa náani sieteca yéenaimi ruájcha cásenaimiu? ");
INSERT INTO aca_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Jesús má'ee nalí: —Iyá yúquenaiu wérri iyáca, jócala yáa léenaa liá'a tánerricoo ya liá'a Dios wíteeca. ");
INSERT INTO aca_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Jáicta máanalini cáwiaujoo, náa'a washiálicuenaica ya náa'a íinaca jócuminaa nacásau, ne cháminaa nayá léjta ángelbini yéenai áacairra. ");
INSERT INTO aca_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Léjta jáicta máanalini cáwiawai, ¿Jócu iliá iyá, liá'a cáashta Moisés tánanimica? Moisés cába'inaami áabai banácali éemacoo liyáca ne jiní bálanaa. Dios má'ee Moisésru: —Nuyá jáa liérra Dios néebidanimi nácu liá'a Abrahámca, ya Isaac ya Jacob. ");
INSERT INTO aca_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","¡Ya Dios jócai máanalini shínaa, Dios nashínaa náa'a cáwinica! Tándawa iwítee wérri iyá yúquerriu liyáca. Dios má'ee chá'a áawita máanalini nayá, cáwiniyaca. ");
INSERT INTO aca_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Lirrúniu Jesúsru báqueerri néenaa náa'a éewidenai Moisés chuáni éemerrimi Jesús méda yáacau'u chóniwenai yáajcha. Liá'inaa léenaa Jesús éeba nachuáni sáica, néenee lisáta léemiu jíni lécchoo limá'ee lirrú: —¿Tána náiibicha náa'a Dios wánacaalau'u cawénii mawí quinínama yúcha? ");
INSERT INTO aca_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ne Jesús ma lirrú: —Le Dios wánacaalau'u cawénii mawí quinínama yúcha liáni: ‘Israel shínaa chóniwenai, éemite liáni: Wawácali, washínaa Dios, Wawácali Dios bácai rími. ");
INSERT INTO aca_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Táda arrúnaa caníinaa jicába jiwácali Dios quinínama jiwówa yáajchau, quinínama jicáwica yáajchau, quinínama jiwítee yáajchau ya quinínama jidánani yáajchau.’ Liyáwa Dios wánacaalau'u cawénii mawí quinínama yúcha liáni. ");
INSERT INTO aca_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ya liá'a yéerri líshiirricu liá'a Dios wánacaalau'u cawéniica cha léjta liáni: ‘Arrúnaa caníinaa jicába áabi léjta jiyá jájiu.’ Jiní áabai Dios wánacaalau'u mawí cawéniica náuchaja liáni. ");
INSERT INTO aca_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Néenee liá'a éewiderri Moisés chuáni ma lirrú liá'a Jesúsca: —Sáicai jimáca, Quéewidacai. Yáawaiyi jimácaa bácai rími Dios, jiní báqueerri mawí liúcha. ");
INSERT INTO aca_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Arrúnaa caníinaa wacába Dios quinínama wawówa yáajchau, ya quinínama wawítee yáajchau, ya quinínama wacáwica yáajchau ya quinínama wadánani yáajchau. Arrúnaa caníinaa wacába wayácchuniu léjta wayá jájiu. Cawénii mawí náucha náa'a cuéshinai wéemani wáa Diosruni, ya quinínama náucha náa'a áabata náiindani altar ítala. ");
INSERT INTO aca_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Jesús cába'inaa liá'a quéewidacai ley shínaaca, léeba liwítee sáicaiyu jíni, néenee limá lirrú: —Jócai déecucha yáaca Dios wánacaalactalaca. Néenee náa'a éemenai nayácani, jócu náa'a nawówau nasátau néemiu liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Jesús yéerri liyáca templo rícu éewiderri liyáca, ya lisáta léemiu: —¿Tánda namá náa'a quéewidacani ley shínaaca lécala liá'a Mesíasca néenaa náa'a Davidca? ");
INSERT INTO aca_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Le Davidja liérra, táanierri Espíritu Santo dánaniyu limá'ee: ‘Liá'a Diosca limá nushínaa cawánacaalacai: Jiwáau nulí sáicaquictejica, cáashia nuwáalia jijínaiu jiájabalau’. ");
INSERT INTO aca_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","¿Chíta quéewau liá'a Mesíasca David cúuleequi jiníni, liyá jájiu limáni liwácalica? Náa'a chóniwenai, íchabani néemi nawówa yáajchau Jesús chuáni. ");
INSERT INTO aca_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesús má'ee já'a léewidacta liyáca: “Itúyau náucha náa'a quéewidacani shínaa leyca, náa'a wówenai namáacoo machénita náabala ya natáaque'e sáica nawówa yáajchau plaza rícu. ");
INSERT INTO aca_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Níiwenai yáarrubaishi mawí sáicaca sinagoga rícu, ya níiwenai liá'a yáarrushi mawí sáitaca ya íyacaishi sáicaica. ");
INSERT INTO aca_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ya néda náabana náa'a máanirrinica, nawówaiyu ta náa'a óraca machéni. Nayá rishíbenai'inaa carrúnatabee máanui mawí.” ");
INSERT INTO aca_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesús yéerrite lijúntami náa'acaja náawaquedani rícu warrúwa nachúnique'e liyú templo, licába liyáca náayu'u warrúwa lirrícula. Íchaba rícubini yáa íchaba warrúwa. ");
INSERT INTO aca_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Jáiwa'ee ruíinu báquetoo máanirriu carrúni jináatau, jáiwa'ee ruácaja rícula chámai moneda rími cobre, jiníjtai wéni. ");
INSERT INTO aca_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Néenee Jesús máida lishínaa éewidenaicoo, ya limá nalí: —Ne yáawaiyi numá irrú ruáni máanirriuca carrúni jináatau yáichoo lirrícula mawí máanui náucha náa'a áabibica; ");
INSERT INTO aca_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ne yáainai quinínama liá'a sóbrerri nalí, ne ruyá carrúni jináatau ruáni quinínama carrúni jináataiyu ruyáu'inaa. ");
INSERT INTO aca_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesús jiá'inaamiu templo rícucha, báqueerri néenaa náa'a lishínaa éewidenaicoo limá Jesúsru: —¡Quéewidacai, jicábateja íiba ya cuíta máanui namáni sáiquitani! ");
INSERT INTO aca_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Jesús éeba'ee lirrú: —¿Jicába náani cuíta máanui namánica? Ne jócai éenaa lichánacu linácula íiba líta'aa wáacoo. Quinínama cáarralerri'inau. ");
INSERT INTO aca_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Jáiwa náawai awáca íibirra jí'ineerri Olivos, yéerri templo júntami. Jesús wáairriu ya Pé'eru ya Santiago ya Juan ya Andrés nasátani néemiu báawacha ");
INSERT INTO aca_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","chacálita'inaa libésunau jiliérra, tánashia lishínaa señal liá'a bésuneerri'inaacoo urrúniquictacani. ");
INSERT INTO aca_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Jesús éeba'ee limá'ee nalí: “Cá'wa yúchaujoo jiní béecha chálujueda iyájoo. ");
INSERT INTO aca_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Jiníwata íinuenai'inaa íchaba ménai nuyája liéni Cristo. Namá'ee nuyája liáni Cristoca, nachálujueda'inaa íchaba chóniwenaijoo. ");
INSERT INTO aca_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","“Jáicta éemi jináawiu íibana áanijoo ya chaléenii, u'icáarrudau. Arrúnaawa chácani, libésunacoo, ne jócai amáarra újnibi. ");
INSERT INTO aca_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Jiníwata áabi cáinabi íinua yáacaminau áabi cáinabi júnta, ya áabi chóniwenai naméda jináwiu nalí wáacoo, ya cáinabi cúsuu matuínaami, já'inaa ínaaishi. Liyáminaa wacábani quéechanacu carrúnatabeeca. ");
INSERT INTO aca_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Itúya iyáu; jiníwata náa'inaa iyá nalí náa'a wánacaleenaica carrúnatanica ya básaida iyá sinagoga rícu lécchoo. Nawánaminaa yáacoo nanáneewa náa'a wánacaleenaica ya reybini náneewa éebidacala nunácueji; cháminaa éewa itáania éebidau'u nunácu nanáneewa. ");
INSERT INTO aca_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Quéechanacu jóctanaa amáarrajani, liá'a chuánshica wásedeerrica arrúnaa cáiiwanacani quinínama cáinabi. ");
INSERT INTO aca_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Ne u'urrúni iwówa iyá linácue liá'a imánica jáicta néntregaa iyájoo lirrú liá'a carrúnataica. Jáicta nasáta néemiu iyá, imáyu liá'a Dios wánani imáca, jiníwata jócta iyá táania léja liá'a Espíritu Santo táanierri'inaa nalí irrícueji. ");
INSERT INTO aca_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Néenajinai wáacoo néntregaaminaa néenajinaiu náiinuaque'inini, ya nasálijinaa néntregaa néenibiu lécchu; ya náa'a néenibica nanáwaminau náiinua nasálijinau. ");
INSERT INTO aca_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Quinínama chóniwenai máashii nacába iyá éebidacala nunácu; ne liá'a bárruerricoo machácani cáashia quiníctala mawiá, liyáminaa wásedeerri'inau. ");
INSERT INTO aca_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Jáicta icábajoo líinuminaa liérra chóniwerri máashiicai wérrica, Dios jínaica. Liwárruaminau Dios íibana licúla, jóctala léewa liwárruacoo, —Liá'a liérrica léemini—, jáicta libésunau léju liáni, náa'a yéenai Judea rícu, náau awáca íibirra nabáyacoo, ");
INSERT INTO aca_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ya liá'a yéerrica líibana lícu jócu limúrru lishínau, jiníwata liyáali éerri carrúnatai wérri'inaaca, cánacau ibáyacoo. ");
INSERT INTO aca_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Néenee liá'a yéerri bacháida lícu jócu léejoo líibana néerra liáwaqueda líibalau. ");
INSERT INTO aca_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","¡Carrúni jináatani náa'a íinaca máanuini yáawai, ya náa'a wáalenai sáamanai írrenai náini! ");
INSERT INTO aca_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Isátau Dios yúcha jócubeecha uniábi yáajini, ");
INSERT INTO aca_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","jiníwata liyáali éerrica bájialai cacháninaca, jócai wacábacaji líta'aa liéni cáinabi limédanica, jiníminaa mawiá chái. ");
INSERT INTO aca_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Jóctata Dios wána amáarraitai liyáali éerrica, jiníminata wásedeerriwai; ne amáarraitai nanácueji, náa'a lishínaacoo liníwanica, jócubeecha carrúni jináata bájiala nayá. ");
INSERT INTO aca_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Ne jáicta máirri irrú já'a ‘Cristo liéni yáa áani, o icábateni liá'a yáa á'a’, u'éebidani”. ");
INSERT INTO aca_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Jiníwata náiinuminaa chóniwenai máinei'inaa nayáca'ee Cristo, ya íiwadedenai chuáni báawachala. Namédaminaa íchaba señal ya méenaami, quéewique'e nachálujueda chóniwenai, áawita néewacta náa'a Dios wínanica. ");
INSERT INTO aca_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","¡Cá'wa yúchaujoo! Quinínama liáni nunísani nuíiwa irrúi jóctanaa libésunajau. ");
INSERT INTO aca_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Ne liyáali éerri'inaa, libésunactacoo carrúnatacaica, liá'a cáiwiaca lichácaminau, liá'a quéerrica jócai'inaa quéena, ");
INSERT INTO aca_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","ya sáalii cáinenau áacai ya náa'a quinínama yáinai áacai nachéchinaminau lécchu. ");
INSERT INTO aca_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Néenee nacábaninaa nuyá Washiálicuerri Dios Cúuleeca líinu'inaa sáanai íibeji lichúnicayu lidánaniyu. ");
INSERT INTO aca_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nubánuaminaa nushínaa ángelbiniu, náawaquedaminaa náa'a nushínaa chóniwenaica quinínama cáinabi íta'aa, quinínama licúchui rícu liá'a cáinabica cáashia último licúchui rícueji áacairranaa. ");
INSERT INTO aca_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Éewidau linácu liáni licábacanaa áicuba báinaca: Jáicta icá'a libáinaa páquiawai wáa léenaa ái urrúni camuí. (Cháwa'ee Israel shínaa cáinabi íta'aa). ");
INSERT INTO aca_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Chacábacanaa, jáicta icábai libésunacoo liá'a nuíiwani irrú, yáa léenaa urrúni nuíinuca, Nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Numá irrú yáawaa quinínama liérra bésuneerri'inau yáawaa jóctanaa máanali náa'a chóniwenaica cábenai liáni bésuneerricoo liyáca. ");
INSERT INTO aca_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Quinínama cáinabi ítasai ya éerri rícu amáarrai'inaa, ne nuchuáni arrúnaa licúmpliacoo. ");
INSERT INTO aca_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ne liá'a éerrica ya liá'a hóraaca jiní yáa léenaa, báawita náa'a ángelbinica yéenai áacai, báawita Licúulee. Bácai yáa léenaa liá'a Lisálijinaaca. ");
INSERT INTO aca_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","“Tanda, arrúnaa iyá cáwitui yáca icábadeda iyáca, jócta yáa léenaa chacálishia nuíinujoni. ");
INSERT INTO aca_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Chái cábacanaa léjta báqueerri washiálicuerri, yáairrictau liyácani bájirra cáinabi ítala, licárgueda lishínaa tráawajadorbiniu natúyaque'e líibana. Bácainaa nabánua natráawajaaca ya libánua liá'a catúyacai cuíta núma cáberri liyá líinuquicta. ");
INSERT INTO aca_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Chacábacanaa, cáwitui yáca, jócta yáa léenaa chacálishia nuíinojoni nuyá cuíta wácalica, jócta samásamanaa, jócta béewami táayebee, jócta á'a cawáamai máidactaca, jócta manúlacaiba; ");
INSERT INTO aca_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","jócubeecha nuíinu walíqueda nuíinu'inaacu máinei iyáca. ");
INSERT INTO aca_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Liéni nuíiwani irrú, nuíiwani irrú quinínama: ¡Cáwique'e ituí yáca quinínama!” ");
INSERT INTO aca_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Cháucta chámai éerri liyáali lishínaa sáictacta nawówa lijí'inaa pascuaca, náayacta'inaa liá'a páanica jócai múrracau. Náa'a nawácanaica, náa'a sacerdótebinica ya náa'a quéewidacani ley shínaaca náawacau natáania nalí wáacoo, chítashia néewoo nawínaque'e Jesús natéeque'e cuíta manúmai rículani, númashi yúwica nácueji ya náiinuaque'inini. ");
INSERT INTO aca_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ne áabi má'ee: —Jócaita fiesta éerdi rícu, jócubeecha íiwirri chóniwenai wówa naméda máashii. ");
INSERT INTO aca_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Jesús yáairriu Betániala, Simón íibana néerra, liá'a Simónca wáalierrimite lepra; nácula liwáau mésa nácula, ruíinu báquetoo íinetoo índechoo áabai frasco alabastro yúsai cashiámui juménibeeyu jí'ineerri nardo liyáwoo, cawéni wérri. Lisúwirria liá'a frascoca léewaque'e liméecucoo ya linuádeda liá'a juménibeeca Jesús wíta nácu. ");
INSERT INTO aca_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Áabibi náa'a yéenei néenee íiwirrini wówa, namá'ee nalí wáacoo: —¿Táda namáshida liá'a juménibeeca? ");
INSERT INTO aca_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Éewerricta wawéndaca áabai camuíta liwéni liá'a tráawajuca, quéewique'e nayúda náa'a carrúni jináatanica. Ya táania máashii runácula ruá'a íinetooca. ");
INSERT INTO aca_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ne Jesús má'ee: —Imáacani; ¿tánda ijódiani? Liáni rumédani nulí sáicai wérri. ");
INSERT INTO aca_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ne náa'a carrúni jináatanica arrúnaa iyá íibi, ya éewani iméda irrú sáicai táshia éewacta jiníni; ne nuyá jócai'inaa nayá íibi mamáarraca. ");
INSERT INTO aca_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ruáni íinetooca le ruénani rumédacaja liáni: Rujúsueda nunácu juménibee jóctanaa naquéni nuyá. ");
INSERT INTO aca_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ne yáawaiyi numá irrú, táshia nácucha cáinabi jíni táshia náiiwadedacta liá'a chuánshica wásedau'inaacoo, natáaniaminaa runácu ruá'a íinetooca liá'a rumédanica, cháminaa nédacanicoo runácujoo. ");
INSERT INTO aca_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Judas Iscarioteca, néenaa náa'a doce éewideneu, yáairriu licábaca nawácanai náa'a sacerdótebinica quéewique'e chítashia léewoo'u léntregaa nalí Jesús. ");
INSERT INTO aca_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Néemi'inaami, sáita nawówa ya nafrésia náa lirrú warrúwa liá'a Judasca, liyá prínsipierri limúrru liyáalimi sáica léntregaaque'e Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Quéechanacu áabai éerri liá'a fiestaca náayacta liá'a páanica jócai náarru limúrracau'u, quéecha'inaa náiinua liá'a cordéroca pascua shínanaaca, náa'a éewidenaicoo nasáta néemiu Jesús: —¿Tanácucha jiwówai jiyá jíni wáacoo waméda liá'a íyacashica pascua shínaaca jirrú jíni? ");
INSERT INTO aca_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Néenee'e libánua chámata lishínaa éewidenaicoo ma nalí: —Yáa namówai lirrícula liá'a chacáaleeca. Néeni íinujoo báqueerri washiálicuerri téerri áabai cántaru shiátai; yáau liánai, ");
INSERT INTO aca_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","táshia liwárruactau jíni, imá lirrú liá'a cuíta wácalica: ‘Liá'a quéewidacai lisáta léemiu: ¿Tanácucha liyá jíni liá'a cuartoca núyacta'inaa nushínaa éewidenaicoo yáajchau pascua íyaninaaca?’ ");
INSERT INTO aca_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Liyá líyadaminaa irrú liá'a piso áacaica áabai cuarto máanui, ichúnini ya listo náayacta'inaa cena. Iméda árra quinínama liá'a arrúnai'inaa wáayaca. ");
INSERT INTO aca_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Néenee náa'a éewidenaicoo jáiwa náawai chacáalee rícula. Náiinu quinínama léjta Jesús máyu'u nalí, ya naméda liá'a cenaca pascua shínanaaca. ");
INSERT INTO aca_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Quéecha'inaa samáacai, líinu liá'a Jesúsca cuarto rícula lishínaa doce éewidenaicoo yáajchau. ");
INSERT INTO aca_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Nácula'ee nawáacoo náayaque'e Jesús má'ee nalí: —Yáawai'inaa numá irrú, ái báqueerri íibi já'a íyeerri nuájcha éntregueerri'inaa nuyá náiinuaque'e nuyá. ");
INSERT INTO aca_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Néenee máashii nawówai náa'a éewidenaicoo nasáta néemiu liyá bácainaa namá'ee: —¿Nuyáminaani? Báqueerri ma lécchoo: —¿Nuyáminaani? ");
INSERT INTO aca_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Jesús ma nalí: —Báqueerri íibi iyá doceca íyeerri nuájcha lirrícu liáni mitájiaca. ");
INSERT INTO aca_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Nuyá Washiálicuerri Dios Cúuleeca, íinuerri Dios néenee yáairri'inau máanalica léjta litánau'u Dios chuáni rícu. Ne máashii wérri lijiácoo lirrú liá'a washiálicuerri léejueda'inaa náiinua nuyá. Sáictaminaata jíni jóctata lijiáwai liá'a washiálicuerrica cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Nácula náaya náa'a éewidenaicoo liájcha liá'a Jesúsca, liwína páani, liá Diosru sáicai linácu liá'a páanica. Linísa'inaa liá Diosru sáicai linácu liá'a páanica, litúcuedani liá nalí, limá'ee: —Íyau, nuíinaa waliérra. ");
INSERT INTO aca_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Néenee liwína vino áabai báasu liá Diosru sáicai linácu. Linísa'inaa liá Diosru sáicai linácui, liá jíni nalí náiirra quinínama báasu rícueji. ");
INSERT INTO aca_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Limá nalí: —Liáni wówerri limáaca nuíirranacaalani, nuádedani'inaa íchaba jíconaashi nácueji. Liyú liáni íirraica, numéda nuyá léjta Dios máyu'u numédaque'ini quéewique'e numéetua íchaba jíconaa. ");
INSERT INTO aca_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Yáawaayii numá jóca nuíirra liábi liá'a uvaca mawiá ne liyáali éerri'inaajoo nuíirra liábi liá'a wáaliica chaléeni áacairra Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Quéecha'inaa narrába áabai shímashi, jáiwa najiáu cuíta lícucha náau áabai dúuli néerra jí'ineerri Olivos. ");
INSERT INTO aca_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Néenee'e Jesús má'ee nalí náa'a éewidenaicoo: —Quinínama iyájoo yúrrucuedaminaajoo iwówaujoo nunácueji wáalee táayee, imáaca nuyá bácai, jiníwata jái tánacuwai wanácu: ‘Nuíinuaminaajoo léju liá'a pastorcojoo, náju náa'a ovejaca nacáarraliaminaujoo.’ ");
INSERT INTO aca_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ne quéechanacu jáicta nucáwiaujoo, nuáuminaajoo ibéechajoo Galilea rículajoo. ");
INSERT INTO aca_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Néenee'e Pé'eru má'ee Jesúsru: —Áawita náurrucueda nawówaujoo quinínamajoo namáaca jiyá bácai, nuyá jócai'inaa. ");
INSERT INTO aca_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Néenee'e Jesús éeba'ee Pé'eru chuáni: —Yáawaiyii numá jirrú jiyá, wáalee táayee, jóctanaa limáida chámaichu liá'a gáayuca, jibáya jináawaujoo matálichujoo nunácueji, jócala yáa léenaa nunácu. ");
INSERT INTO aca_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ne limá'ee Jesúsru danáanshiyu mawí: —Áawita rúnaa máanali nuyá jiájchajoo, jóca nuéjoo nubáya jináawa mawiá. Quinínama cha namácai. ");
INSERT INTO aca_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Jáiwa náawai chaléeni jí'ineerri Getsemaní. Jesús ma lishínaa éewidenaicoorru: —Iwáayu íchaitaa áani nácula, nuáu nu'óracoo. ");
INSERT INTO aca_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ya litée Pé'eru, ya Santiago ya Juan, ya néenee lisíntia bájiala máashii liwówa cáiwi licábacoo lécchu. ");
INSERT INTO aca_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Limá nalí: —Nusíntia nácuu máashii máanalicai. Imáacau áani, úwa imáajoo. ");
INSERT INTO aca_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Liyáalimi Jesús yáu libéechalawoo mawí, litájiau cáashia lináni dúnu cáinabi, lisáta'eewoo Dios yúcha, jócubeecha línda carrúni jináata limédacoo bájiala. ");
INSERT INTO aca_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Á'a li'óractacoo limá'ee: Nusálijinaa, jiyá éewerri jiméda quinínama: Jéda nútacha liáni carrúnatai wérrica; ne jócubeecha jiméda léjta nuwówau'u, ne jimédaque'e léjta jiwówau'u. ");
INSERT INTO aca_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Néenee léejuawai chaléeni nayáctalaca ya líinu nanácu máainai. Limá'ee Pé'erurru: —Simón, ¿jimáa jiyáca? ¿Jócu wíta áabai hóraa jéewa jiyá cáwi jitálideda nuyá? ");
INSERT INTO aca_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Arrúnaa cáwi iyáca ya i'órau, quéewique'e jócubeecha licáu irrú liá'a máashiica. Iyá sáicai iwówa, ne íinaa wáneerri cáarru iyá. ");
INSERT INTO aca_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ne liáu báaniu, ya li'orau lirrípitia liyája chuánshicaja. ");
INSERT INTO aca_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Néenee léejua'inau báaniu, líinu nanácu náa'a éewidenaicoo báaniu máainai, jiníwata dajuíshi báya wérri natuí. Jiní náa léenaa namá lirrú. ");
INSERT INTO aca_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Léejoo matálichu, ya limá nalí: —¿Isíguia imáaca ya iwówa íyabacoo? Cái ája árra, líinu léji liárra hóraaca Nuyá Washiálicuerri Dios Cúuleeca néntregaani'inaa nacáaji ricúla náa'a cajíconaanica. ");
INSERT INTO aca_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ibárroo, wáawai; ái urrúnicai liá'a éntregueerri'inaa nuyá nujínairru. ");
INSERT INTO aca_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesús táania'inaa liyá újni'ii, líinu néerrai liá'a Judasca néenaa náa'a doce éewidenaicoo, íchabani chóniwenai yáajcha índenai espada ya áicuba. Íinuenai nawánacaala nácu náa'a sacerdote wácanaica, náa'a íiwadenai Moisés chuáni, yá'ee náa'a salínaica. ");
INSERT INTO aca_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Liá'a Judasca éntregueerri nalí Jesús linísa líiwa nalí chítashia quéewo'oo náa léenaa Jesúsqui jíni: —Léju liárra nushíshi linánijoo, liyáwa léju liárra. Iprésudani itée sáicani. ");
INSERT INTO aca_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Líinu'inaa liá'a Judasca, lirrúniu Jesúsru madéjcalicunaa limá lirrú: —¡Quéewidacai! Néenee lishíshi jíni. ");
INSERT INTO aca_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Linísa'inaa lishíshiqui jíni, néenee nawína jíni natée preso jíni. ");
INSERT INTO aca_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Néenee báqueerri néenaa yáainai néeni, lijéda lishínaa espada líimanaca licúchau, jáiwa líiju le jiliá'a sacerdote wácali shínaa chóniwerri tráawajairri lirrú liwíchua liwíbai. ");
INSERT INTO aca_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ya Jesús lisáta léemiu náa'a chóniwenaica: —¿Tánda índa espada ya áicuba quéewique'e iwína nuyá preso, jicá'a liá'a máashiicaica? ");
INSERT INTO aca_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Éerri jútainchu nuyá yáajcha nuéewida iyá lirrícu liá'a templo máanuica, jócai iwína nuyá preso. Ne liáni imédani iyáca léjta limáyu'u liá'a Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Néenee quinínama náa'a lishínaa éewidenaicoo namáaca jíni liá'a Jesúsca nacánacau liúchai. ");
INSERT INTO aca_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ne báqueerri icúlirrijui yáau liánai, dájiderriu áabai éeyaishiyu. Ne liárra jáiwa nawína jíni. ");
INSERT INTO aca_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","Ne liyá jáiwa liwáseda lishínaa éeyaishimiwai jáiwa licánacau jushícai. ");
INSERT INTO aca_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Natée Jesús lirrú liá'a sacerdote wácalirru, ya náawacau quinínama náa'a wácanaica sacerdótebinica, náa'a salínaica ya náa'a quéewidacanica ley shínaaca. ");
INSERT INTO aca_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Pé'eru yáau líshiirricu déecuchata, cáashia líinu patio ítala lishínaa cuíta liá'a sacerdote wácalica, ya jáiwa limáacawai náajcha náa'a catúyacani templo, licámudau liyá chichái téeji. ");
INSERT INTO aca_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Náa'a sacerdótebini wácanaica ya quinínama nawácanaica, namúrru'e chítashia quéewau'inaa cajíconaa nalí Jesús náiinuaque'inini; ne jócai jiáu nalí léjta nawówau. ");
INSERT INTO aca_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Jiníwata báawita namá íchaba ne jócai yáawaiyi, namá'ee nalí wáacoo bácainaa. ");
INSERT INTO aca_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Áabi bárroo namáca újnii namé'e nanúma yúbicau: ");
INSERT INTO aca_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","—Wayá éemenai limáca: ‘Nuyá cáarralerri'inaa liáni temploca namédani náa'a washiálicuenaica, ya matáli éerri nubárrueda áabai ya jócai namédacala náa'a washiálicuenaica.’ ");
INSERT INTO aca_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ne jiní éewiderrini liá'a namánica. ");
INSERT INTO aca_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Néenee liá'a sacerdótebini wácanaica libárroo béewami nalí quinínama, ya lisáta léemiu liá'a Jesúsca: —¿Jiní éebaca? ¿Tána léji liéni namáni nayá jáica jiyá jíni? ");
INSERT INTO aca_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Ne Jesús máacau manúma, jiní éebacta; jiníwata náa'aca léenaa jócu liwáalia ítalashi. Liá'a sacerdótebini wácanaica léejoo lisáta léemiuni: —¿Jiyá jiliérra Mesías, liá'a licúulee Dios sáicaica? ");
INSERT INTO aca_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Jesús ma lirrú: —Jajá, nuyá. Ya iyá icábaminaajoo nuyá Licúulee liá'a Washiálicuerrica wáairriu chéni sáicaquictejica liá'a Dios cadánani wítee, ya líinu sáanai íibeji. ");
INSERT INTO aca_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Néenee liá'a sacerdótebini wácanaica jáiwa lishírricua líibalawai liwówau limáca íiwirricala liwówa, ya limá'ee: —¿Tána arrúnaa warrúnaacai nacábaque'e mawí jíni? ");
INSERT INTO aca_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Iyá éemenai limá chuánshi máashii Dios nácu. ¿Chíta icábau jiníni? Quinínama namá cajíconaacalani ya arrúnaacala máanalicani. ");
INSERT INTO aca_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Áabibi chánau nawísadacani, ya nabáya lituí ya nabásaida liyá, namá lirrú: —¡Jiácta léenaa tánashia básaida jiyái! Ya náa'a catúyacani templo nabáseda lináni. ");
INSERT INTO aca_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Nácula Pé'eru yáa liyáca cáinacula patio íta'aa, néenee ruíinu ruá'a báquetoo néenaa náa'a sacerdote wácali shínaa chóniwenai néeni sána yáca. ");
INSERT INTO aca_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Rucába'inaa Pé'eru nábeerri liyáca chichái dáninacu, néenee'e rucába'ee lirrú rumá'ee lirrú: —Jiyácani yáairrimi liájcha lécchoo liá'a Jesús Nazaret sáica. ");
INSERT INTO aca_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ne Pé'eru báya jíni limá'ee: —Jócai nucúnusia liyá, jiní nuá léenaa liá'a tánashia jitáaniaca. Néenee lijiáu bináawalai cuíta núma licúla néenee gáayu máidai. ");
INSERT INTO aca_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Rucába'inaa lirrú báaniu ruá'a chóniwetooca, néenee rumá nalí náa'a yáinai néerra: —Léwa báqueerri néenaa liárra náa'a yéeneemi Jesús yáajcha. ");
INSERT INTO aca_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Néenee Pé'eru léejoo libáya báaniu jíni liá'a Jesús náwa. Íchaitaa rími liáwinaami, náa'a yáainai néerra namáwee Pé'erurru báaniu: —Yáawaiyii, jiyá báqueerri néenaa, níwata jiyá Galilea sái lécchoo, jitáaniacala léjta nayá. ");
INSERT INTO aca_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Néenee'e lijúrawai limá'ee: —Dios cástigaa nuyá jócta numá liá'a yáawaiyiica. “Dios yáa léenaa jócai nucúnusia liá'a washiálicuerrica chái itáania iyá nácu”. ");
INSERT INTO aca_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Liyáalimi já'a, gáayu éejoo limáida báaniu. Néenee'e líinu Pé'eru liwíta lículai liá'a chuánshica Jesús mánimi lirrú: —Jóctanaa gáayu máida chámaichu, jibáya nunáawa matálichu. Ne lédacani'inau linácu liáni, néenee líchai. ");
INSERT INTO aca_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Jucámarra'inaami liácuwai, nawáca yáacau náa'a sacerdótebini wácanaica náajcha náa'a salínaica ya náa'a quéewidacani ley shínaaca, quinínama judío wácanaica. Ya natée Jesús libáji rícuu, jáiwa néntregaa jíni Pilatorru. ");
INSERT INTO aca_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Pilato sáta léemiuni: —¿Jiyá jiliérra rey judíobini shínaaca? —Jiyái máca, —Jesús éeba'ee. ");
INSERT INTO aca_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jiníwata sacerdótebini wácanaica náani nalíta'aa íchaba chuánshi, ");
INSERT INTO aca_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Pilato éejoo lisáta léemiuni: —¿Jiní jéebacta? Jicába chítashia mánaba najútacoo jíni. ");
INSERT INTO aca_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ne Jesús jócai éeba lichuáni; jáiwa'ee Pilato cáarrudawai. ");
INSERT INTO aca_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","(Nuwówai nuíiwa irrú áabai chuánshi rími). Lijútainchu liá'a fiestaca jí'ineerri pascua, Pilato wáseda nalí náa'a judíobinica báqueerri preso tánashia nasátani. ");
INSERT INTO aca_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ái báqueerri cuíta manúmai rícula já'a jí'ineerri Barrabás náajcha náa'a limánabacaca, íinuenai chóniwenai lirrícu liá'a jináwiuca namédani náajcha náa'a gobierno shínaa chóniwenai, ya náiinua báqueerri chóniwerrite. ");
INSERT INTO aca_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Néenee narrúni'inau Pilatorru náa'a chóniwenai íchabanica, néenee nasáta limédaque'e nalí léjta liwítee séewirrinaa. ");
INSERT INTO aca_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Néenee Pilato má'ee nalí: —¿Iwówai nuwáseda irrúni liá'a Judíobini shínaa reyca? ");
INSERT INTO aca_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilato liáca léenaa náa'a sacerdótebini wácanaica, néejueda Jesús lirrú cadénica nayá. ");
INSERT INTO aca_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ne náa'a sacerdóteca wáneenai nacáarraliacoo náa'a chóniwenaica quéewique'e nasáta Pilato wáseda sáica mawí liá'a Barrabásca. ");
INSERT INTO aca_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Néenee Pilato má'ee nalí báaniu: —¿Tánawa iwówai numéda liájcha liá'a imáni liá'a imáni nácucha judíobini shínaa reyca? ");
INSERT INTO aca_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Néenee namáidada báaniwai namá'ee: —¡Jíinua cruz nácuni! ");
INSERT INTO aca_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Néenee Pilato má'ee nalí: —¿Tánawa máashii limédai? Ne namáidada danáanshiyu mawí namá'ee: —¡Jíinua cruz nácuni! ");
INSERT INTO aca_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Néenee Pilato wówai limáacacoo sáica chóniwenai yáajcha, néenee liwáseda nalí jíni liá'a Barrabásca. Néenee'e liwána nabása liyá danáanshiyu mawí liá'a Jesúsca. Nanísa'inaa nabásaqui jíni, néenee'e liá nalí jíni quéewique'e máanali cruz nácuni. ");
INSERT INTO aca_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Néenee náa'a soldádoca nanísa'inaa natée Jesús lítala liá'a cuíta wérrica shínaa bináawaca, néenee náawaqueda yáacuwai náa'a soldado íchabani mawí. ");
INSERT INTO aca_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Néenee nasúwa lirrú liá'a líibala quíirrai wérrica léjta rey íibala, jáiwa'ee nanísa'inaa nayáaqui jíni liá'a túwirrica macájcuiyu újni corónaca, nasúwa liwíta nácu jíni. ");
INSERT INTO aca_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Néenee'e ya ta nachána namáidadaca namá'ee lirrú: —¡Yáali, Judíobini shínaa Rey! ");
INSERT INTO aca_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Nanísa'inaa natáa lirrúi jíni, néenee nabáseda náacoo jíni liwíta nácu varayu, nawísadani náacoo natúyau náacoo náurrui íta'au lirrú naméda náacoo lirrú nacáidaque'inini. ");
INSERT INTO aca_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Nanísa'inaa nacáidaqui jíni, néenee namídu líibalami liá'a quíirrai wérrica néenee nasúwa lirrú le jiliá'a líibalaca. Néenee natée jíni náiinuaque'e cruz nácuni. ");
INSERT INTO aca_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Báqueerri washiálicuerri Cirene néenee sái, jí'ineerri Simón, liá'a lisálijinaa liá'a Alejandro ya Rufo, íinuerri bacháideji. Libésuna'inaamiu á'a, nawána litée máashiiyu Jesús shínaa cruz. ");
INSERT INTO aca_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Natée Jesús áabai sitio jí'ineerri Gólgota (wówerri limáca: “iyájimi yáarru”); ");
INSERT INTO aca_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Náa líirra vino éewiderriu mirra yáajcha, áabai debé cáiwibeeyuca, jí'ineerri mirra, ne Jesús jócai líirra náuchani. ");
INSERT INTO aca_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ne jáiwa natáata jíni. Ya náa'a soldádoca jáiwa nachújida nalí wáacoo líibalami liá'a Jesúsca, nacába tánashia natée nalí wáacuwai. ");
INSERT INTO aca_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Manúlacaiba las nueve natáata'inaamini liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Ya nachánaa áabai letra cruz nácu wówerri limáca tándashia nácueji náiinua jíni, limá: “Rey judíobini shínaa”. ");
INSERT INTO aca_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Liájcha natáata chámata máashiinini lécchoo, báqueerri sáicaquicteji ya báqueerri apáuliquicteji.  ");
INSERT INTO aca_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Cha licúmpliacoo liá'a tánerricoo: “Naníquini náiibi náa'a máashiinica”. ");
INSERT INTO aca_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Náa'a bésunenaicoo náacoo nacáita liyá, nacúsuda nawítau ya namá lirrú: —¡Jéemite, jiyá cáarralerri templo ya matáli éerri jinácuda báaniu wáni, ");
INSERT INTO aca_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Jiwásedateu jiyá jájiu ya jiúrrucoo cruz nácucha! ");
INSERT INTO aca_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Chacábacanaa nacáida liyá náa'a sacerdótebinica wácanaica ya náa'a quéewidacani ley shínaaca. Namá'ee: —liwáseda áabi, ne liyá jájiu jócai éewa liwásedacoo. ");
INSERT INTO aca_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","¡Jiúrrucoo cruz nácucha liá'a Mesíasca, Rey Israel shínaa, quéewique'e wacábacani ya wéebidaque'ini! Ya náa'a chámataca táatenaicoo liájcha nacáitade liyá. ");
INSERT INTO aca_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ne wówai'inaami wíyaicumi cái, quinínama cáinabi máaquerriu catáwaca cáashia las tresca. ");
INSERT INTO aca_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Liyáali hóraami Jesús máidada cadánani: “Eloi, Eloi, ¿lema sabactani?” (wówerri limáca: “Nushínaa Dios, nushínaa Dios, ¿Tánda jimáca nuyá bácai?”) ");
INSERT INTO aca_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Áabi náa'a yéenai á'a, néemini namá'ee: —Éemite, máiderri liá'a íiwadedeerri Dios chuáni Elíasca. ");
INSERT INTO aca_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Néenee báqueerri néenaa jáiwa licánacawai, jáiwa lisábida áabai esponja vino ijíshiiyu, libájini báju shitúwa juáta lícu, jáiwa lidúcua Jesúsru jíni quéewique'e líirracani, limá'ee: —Imáacani, wacába Elías íinucta liúrrucueda cruz nácuchajoni. ");
INSERT INTO aca_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ne Jesús jáiwa limáidada cadánani wérri, jáiwa máanali jíni. ");
INSERT INTO aca_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ne liá'a cortinaca templo núma lícu sáica jáiwa lishírricuawai béewami cáinacueji áacairra. ");
INSERT INTO aca_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Liá'a wánacaleerri romanoca, yéerri Jesús júntami, licába'inaa máanali Jesús, limá'ee: —Yáawaiyi liéni washiálicuerrica Dios Cúulee. ");
INSERT INTO aca_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Lécchoo ái áabi íina já'a cábenai nayá déecucheji; náiibi ruyá ruá'a María Magdalena, María litúwa liá'a Santiago líshiimica ya José, ya Salomé. ");
INSERT INTO aca_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Náani íinaca yáainaiu Jesús yáajcha ya nayúda liyá quéecha'inaa liyá Galilea néeni. Ái áabi mawí já'a áani íchaba áabi yéenaiu liájcha Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Jesús máanali'inaami liyáali éerrica náa'a judíoca nachúnicta quinínama nayáca liá'a éerrica sábadoca, liwówai limá walí, libéecha liá'a éerri nawówa íyabactacoo, táda samáabee béecha. ");
INSERT INTO aca_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Jáiwa, báqueerri washiálicuerri Arimatea sái jí'ineerri José íinuerri. Liá'a Joséca wánacaleerri áacai náiibi náa'a wánacaleenai judíobini, néenderri Dios wánacaalau'u lécchoo, jócai cáarrunaa wárruacoo Pilato néerra lisátaque'e liúcha Jesús náanaimi. ");
INSERT INTO aca_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Néenee Pilato cáarrudau léemi jáica máanali liá'a Jesúsca néenee limáida lirrú liá'a soldado wácalica lisátaque'e léemiu liyá jáicta máanali jíni. ");
INSERT INTO aca_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Jáyaali soldado wácali íiwa lirrú jíni, néenee Pilato línda áabi éntregaa Josérruni Jesús náanaimi. ");
INSERT INTO aca_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Néenee José wéni bájirra wáarruma mawíyii cawénica. Liúrrucoo Jesús cruz liúcha jíni, linísa'inaa lidájidaqui jíni, néenee libáyani útawi rícu wáalii jíni naquénini íiba íibi. Linísa'inaa libáya útawi rícu jíni, néenee liwówaneda áabai íiba libáyaque'e útawi núma. ");
INSERT INTO aca_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ruá'a María Magdalena ruájcha ruá'a María José túwaca nacábani liá'a namáacactacani. ");
INSERT INTO aca_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Libésuna'inau liá'a éerri nawówa íyabactacoo, ruá'a María Magdalena, ruájcha ruá'a María Santiago túwaca ya ruá'a Saloméca, nawéni juménibee náaque'iu najúsua Jesús náanai nácuni (jócubeecha máashii líisaani). ");
INSERT INTO aca_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Domingo manúlacaiba wérri, cáiwia wáalii jiácuwai, náau útawi néerra. ");
INSERT INTO aca_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Namá'ee náacoo nalíwaacoo: —¿Tána wówanaida walí útawi núma rícucha liá'a íibaca? ");
INSERT INTO aca_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ne nacába'inaa nabéechau, nacába liá'a íibaca shírruerriu liárru rícuchau liá'a íiba máanui wérrica. ");
INSERT INTO aca_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Néenee nawárrua'inau útawi rícula, nacába báqueerri icúlirrijui wáacoo liyáca sáicacaquictejica wáalierri líibalau cabálai díirrirri néenee nacáarrudau bájiala. ");
INSERT INTO aca_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ne limá nalí: —O'icáarrudau. Imúrru imácoo liá'a Jesús Nazaret sáica liá'a náiinuanimi cruz nácu. Ne cáweerriwai, jiní áani. Icábateni áani namáacactamicani. ");
INSERT INTO aca_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Yáa namówai, íiwa nalí náa'a lishínaa éewidenaicoo ya Pé'erurru lécchoo: ‘Liácalau nabéecha Galilearra. Icába néerrajoni, léjta limáyu'umi irrúni.’ ");
INSERT INTO aca_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Néenee najiáu nacánacacoo útawi yúcha náa'a íinaca, níwata chéchineneu, nacáarrudacalau. Jiní namá áabirru jiníwata cáarrucaa nayá.  ");
INSERT INTO aca_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Quéecha'inaa Jesús cáwiacuwai domingo manúlacaiba wérri, líyadau rulí quéechanacu ruá'a María Magdalenaca, lijédanimi yúcha siete espíritu máashiini. ");
INSERT INTO aca_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Néenee ruáu ruíiwa nalí náa'a yéenaimi Jesús liájcha náa'a máashiini wówa íchenaica. ");
INSERT INTO aca_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Néemi'inaa cáwicaa Jesús báaniu rucábacalani, ne nayá jócai néebida rulí. ");
INSERT INTO aca_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Liáwinaami, Jesús íyaderriu nalí áabaiyu nalí náa'a chámata limáanabaca yéenaimi liájcha yáaineu náacoo náibayu bacháidala. ");
INSERT INTO aca_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Néenee néejoo náaque'iu náiiwa áabi apóstolu Jesús yáajcha, ne nayá jócai néebida nalí lécchoo. ");
INSERT INTO aca_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Liáwinaami, Jesús íyadau nalí náa'a once éewidenaicoo nalí já'a nácula náaya nayácacaa, néenee licáita nayá cháuctacaa néebidaca ya cabálinicala nawówa níwata jócai néebida nalí náa'a cábeneemi licáwiacoo. ");
INSERT INTO aca_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Néenee limá nalí: “Yáau quinínama cáinabi íiwa liáni chuánshica wásedeerri'inaa quinínamarru. ");
INSERT INTO aca_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Tánashia éebiderri liá'a chuánshi sáicaicojoo libáutisacoo, liáminaa Dios néerra, ne tánashia jócai éebida liá'a chuánshijoo, jócani liwásedaujoo, liúcaminau máashiiquictalaca. ");
INSERT INTO aca_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Namédaminaa léju liáni, náa'a éebidenai nuchuáni: Nují'inaa nácu najédaminaa espíritu máashii chóniwenai yúchajoo; natáaniaminaa chuánshi wáaliiyujoo; ");
INSERT INTO aca_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Nawínaminaa áai nacáaji rícujoo; ya náiirracta'ee méenaami máanalicaica, jócuminaa máashii liméda nalíjoo; ya mawí'inaajoo jáicta nachánaminaa nacáajiu nanácu náa'a bálineneecoo sáicaminaa nayájoo.” ");
INSERT INTO aca_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Linísa'inaa litáania náajcha liá'a Nawácali Jesúsca, néenee linácudawai narríshibia áacairra jíni, liwáau Dios éemanacu sáicaquictejica, wáaque'e léenaa Dios máaca liyá áacai wérri. ");
INSERT INTO aca_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Néenee najíau náa'a éewidenaicoo náiiwa liá'a chuánshi sáicaica matuínaamirru. Liyá Nawácali yúda nayá líyadaque'e quinínamarru lichuáni sáicai nayú náa'a méenaami libánuani lichuáni yáajchau. Chácajani.");
INSERT INTO aca_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Íchaba chóniwenai natána liá'a quéecha sáimi bésunacoo wáiibi. ");
INSERT INTO aca_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Chaléjta néewidaumi náa'a chóniwenai cábenai quéechanacumi, ya narríshibia liá'a libánuani namédaca náiiwa liá'a sáica chuánshica Jesucristo shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nuyá Lucas, lécchoo nujúnicai cawéni wérri Teófilo, nunísa nuá léenaa quinínama sáica quéechanacu sáimica, nucába lirrúnaacoo nácu íchaba nutána jirrú quinínama liáni nuchúni jirrú sáicani, ");
INSERT INTO aca_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","quéewique'e jicúnusia sáica liá'a yáawaiyiica néewidani jiyá nácu. ");
INSERT INTO aca_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Liyáali éerrimi liwánacaala'inaami liá'a rey Heródesca líta'aa liá'a cáinabi jí'ineerri Judea, yéerri néeni báqueerri sacerdote jí'ineerri Zacarías, báqueerri Abías táqueerri éenaami. Líinu liá'a Zacaríasca rují'inaa Isabel Aarón táquetoomi. ");
INSERT INTO aca_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Chámatanaa nayá majíconaani Dios náneewa ya naméda liwánacaala liá'a Dios wánani namédaca, táda jiní éewa liá najíconaa. ");
INSERT INTO aca_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ne jócai nawáalia néenibiu, jiníwata Isabel jócau éewa quéenibica; ya mawíjani salínai cái. ");
INSERT INTO aca_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Áabai éerri arrúnaa naméda nashínaa tráawaju náa'a Zacarías máanabaca Dios náneewa, ");
INSERT INTO aca_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","léjta séewirrinaa nawítee nayáwacoo náa'a sacerdótebinica, naníwani náiibiu tánashia wárruerri'inau templo rícula, jáiwa lijiáwai Zacaríasru arrúnaa liwárruacoo Dios shínaa templo rícula quéewique'e léema juménibee nafrésiani Diosru. ");
INSERT INTO aca_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Nácula léema liá'a juménibeeca Diosru, quinínama chóniwenai na'óraa nayáca bináaweji. ");
INSERT INTO aca_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Liyáalimija báqueerri ángel Dios shínaa íyadau Zacaríasru, bárruerriu altar éema nácu sáicaquictejica néemactaca juménibee jí'ineerri incienso. ");
INSERT INTO aca_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Jái'inaa Zacarías cába ángel, jáiwa licáarrudawai. ");
INSERT INTO aca_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Ne ángel má'ee lirrú: —Zacarías, ocáarru jiyá, jiníwata Dios éemerri jisátau'u liúcha, ya ruá'a jíinu Isabelca wáaleecho'inaa rucúuleu, jáicta samálita jiáujoo jiáni'inaa jí'inaa Juan. ");
INSERT INTO aca_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Iyá sáictai wérri'inaa iwówa, ya íchabaminaa sáicta wówajoo jáicta lijiáujoo. ");
INSERT INTO aca_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Jiníwata jicúulee cadánani'inaa wítee Dios náneewa. Jócai'inaa írra íirracaishi cáiwii, cashiámui'inaa Espíritu Santoyu jóctanaa lijiájau. ");
INSERT INTO aca_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Liwánaminaa íchaba éejueda nawíteu nashínaa Diosru, náa'a chóniwenai Israel rícu sánaca. ");
INSERT INTO aca_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Liéni Juan yáairri'inau, Wawácali béecha, Espíritu dánaniyu ya liwítee léjta liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Elías, quéewique'e néejoocoo áabenaa nawówa nasálijinaa néenibi yáajchau ya náa'a máashiinica néewidaque'iu naméda sáicai. Cha licábacanaa lichúni náa'a chóniwenai narríshibia'inaaque'e Wawácali. —Limá'ee liáni ángelca. ");
INSERT INTO aca_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Zacarías sáta léemiu ángelca: —¿Chíta quéewau'inaa nuá léenaa nuéewa nuwáalia nucúuleu níwata nuyá bájialai salírranica ya nuíinu lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ángel éeba'ee lichuáni: —Nuyá Gabriel ya nutráawajaa Diosru; liyá bánuerri nuyá nutáaniaque'e jiájcha, ya nuíiwa jirrú liáni sáicai chuánshica. ");
INSERT INTO aca_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Ne wáalee, níwata jócai jéebida liáni chuánshica numáni nácucha jirrú, jiyá manúmai'inaa; jócuminaa jéewa jitáaniacojoo, cáashia libésunacoo quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Nácula, náa'a chóniwenai nanénda Zacarías bináaweji ya nasáta néemiu nayá jájiu táda lidécudau bájiala lijiácoo templo rícucha. ");
INSERT INTO aca_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Lijiá'inaawai, jócai éewa litáania nalí; néenee náa léenaa jíni licábaca lituírricu sáiu templo rícu, litáania nalí señalyu; cha lisíguiacoo jócu litáania. ");
INSERT INTO aca_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Linísa'inaa liméda lishínaa tráawaju Diosru templo rícu, Zacaríasca jáiwa léejoo líibana néerrawai. ");
INSERT INTO aca_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Liáwinaami liáni, ruá'a líinu Isabelca ruáwi rícui, ya nácula cinco quéerri jócau jiáu rúbana yúchau, rupénsaa rumá rulíwoo: ");
INSERT INTO aca_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Liá'a Nuwácali chóque'e liméda nulí liáni, quéewique'e náa'a chóniwenai jócubeecha nacháani nuyá mawiá.” ");
INSERT INTO aca_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ruwáalia'inaa seis quéerri ruáwi rícucai ruá Isabelca, néenee Dios bánua báqueerri ángel jí'ineerri Gabriel, lirrícula liá'a chacáalee jí'ineerri Nazaret, yéerri áabai cáinabi íta'aa judíobini shínaa jí'ineerri Galilea, ");
INSERT INTO aca_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","quéewique'e litáania ruájcha ruá'a miyácau jócai yáacaji washiálicuerri yáajcha, jí'ineechoo María, comprométechoo rucásacoo báqueerri washiálicuerri yáajcha jí'ineerri José, litáqueerrimi liá'a rey David. ");
INSERT INTO aca_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Néenee liwárruau ruyáctala liá'a ángelca limá rulí: —¡Nutáa jirrú, Dios wówairri liméda jirrú áabai sáicabee máanui! Wawácali yéerri jiájcha. Dios méderri sáicai mawí náucha náa'a íina quinínama. ");
INSERT INTO aca_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Ne rucába'inaa ángel ruá'a Maríaca, jáiwa rucáarrudau ruéemi lichuáni, rumá rulíwoo tádashia líinu limá rulí cháji'i. ");
INSERT INTO aca_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Néenee liá'a ángel ma rulí: —Ocáarru jiyá, María, níwata Dios wówairri liméda jirrú sáicai. ");
INSERT INTO aca_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Jiáwi rícuminaajoo, jiwáaliaminaa jicúuleujoo, jiáminaa lijí'inaa Jesúsjoo. ");
INSERT INTO aca_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Liyá sáicai'inaa chóniwenai yúcha, jí'ineerri'inaa Licúulee liá'a Dios yéerri áacairra wérri, ya Wawácali Dios méderri'inaa liyá reyyui liwánacaalaque'e léjta liwérrimi David. ");
INSERT INTO aca_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Liwánacaalaminaa náa'a israelítacujoo Jacob éenibimica mamáarraca éerri, liá'a liwánacaalau'uca jócai'inaa amáarra. ");
INSERT INTO aca_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Néenee ruá'a Maríaca rumá ángelrru: —¿Chítai'inaa libésuna'inau liáni? nuyá jócai yáacaji washiálicuerri yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Néenee limá rulí liá'a ángelca: —Liá'a Espíritu Santoca íinuerri'inaa jináculajoo ya lidánani liá'a Dios yéerri áacairra wérri liúrrucoominau lidájida jiyájoo léjta áabai sáanai. Tándawa liá'a samálita jiéirri'inaacoo jí'ineerri'inaa majíconai Dios Cúulee. ");
INSERT INTO aca_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ya jéemite liáni: —Ruá'a jéenajetoo déecucheji jí'ineechoo Isabelca, ruyá jáu yáawi rícu lécchoo, báawita salítueni ruyá. Namánimi nácucha jócala éewa quéenibi ruyá, ne chóque'e ruáwi rícu, ruwáalia seis quéerri, ");
INSERT INTO aca_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","“níwata Dios éewerri liméda quinínama.” ");
INSERT INTO aca_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Néenee rumá ruá'a Maríaca: —Nuyá yéerri Dios wánacaala nácu. Dios méda'aa nulí léjta jimáyu'u nulí. Néenee ángel jiáu rúchai. ");
INSERT INTO aca_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Liyáali éerrimica, María yáau madéjcanaa áabai chacáalee rícula yéerri dúuli namáctalaca Judea shínaa cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Ruwárroo Zacarías íibana rícula ya rutáa Isabelru. ");
INSERT INTO aca_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Jái'inaa Isabel éemi María táa rulí, liá'a samálita ruáwi rícu sáica jáiwa lichúnuniwai, ya Isabel máacau cashiámu Espíritu Santoyu. ");
INSERT INTO aca_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Néenee Isabel rumá cadánani chuánshiyu: —¡María, Dios túya jiyá mawí náucha náa'a quinínama íinaca, ya litúya jicúulee! ");
INSERT INTO aca_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","¿Tána nuyái? Nuyá jócai cawéni quéewique'e jíinu jipáshia nuyáctalaca Nuwácali túwaca. ");
INSERT INTO aca_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nuéemi'inaa jitáa nulí, nucúulee chúnuniu liwówa chúnicau nuáwi rícu. ");
INSERT INTO aca_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","¡Sáicta jiwówa jiyá jéebidacala liá'a cúmplerri'inaacoo Wawácali máni nácucha jirrú! ");
INSERT INTO aca_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","María má'ee: “Nucáwica méda sáicai lirrú liá'a Nuwácali máanui wérrica; ");
INSERT INTO aca_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","nushínaa espíritu sáicta liwówa Dios nácu liwáseda nuyá. ");
INSERT INTO aca_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Jiníwata Dios cába nulí sáica, nuyá imíyau, cashírruedacau jirrú, ya chóquejoo chóniwenai ma nunácucha sáictau wówa; ");
INSERT INTO aca_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","jiníwata liá'a Dios éewerri liméda quinínama liméda nulí máanui wérri sáicaica majíconaa lijí'inaa. ");
INSERT INTO aca_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Dios wáalia séewirrinaa carrúni jináata licába náa'a cawáunta liyá. ");
INSERT INTO aca_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Dios méda íchaba quinínama liwítee dánaniyu, licáarralia náucha nashínaa náa'a fachósunica. ");
INSERT INTO aca_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Liúrrucueda náa'a reyebini náarrubai ítachau ya limáaca áacai náa'a imíyanica. ");
INSERT INTO aca_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Dios yáa sáicai nalí náa'a sáamuni wówa ya liwána náacoo macáaji rícu sái náa'a rícubinica. ");
INSERT INTO aca_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Liyúda nayá chóniwenai Israel shínaaca sírbeerri lirrú, ya jócai limíya máecha nayá liméda sáicaica carrúni jináataca licába nayá. ");
INSERT INTO aca_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Dios íiwanimi báinacu wawérrinaimirru, ya Abrahámru ya náa'a jitáqueenemi jiénecoo liáwinaami liéni.” ");
INSERT INTO aca_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","María máacau ruájcha ruá'a Isabelca matálicua quéerri, liáwinaami ruéejoo rúbana néerrau. ");
INSERT INTO aca_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Líinu'inaa liá'a éerrica, Isabel cúlicuctála'inaaca, jáiwa ruwáalia rucúuleewai. ");
INSERT INTO aca_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Náa'a yéenai urrúni ya náa'a ruéenajinai náau nawána sáicta ruwówa náa'inaa léenaa Dios méda rulí sáicai, liá rucúulee. ");
INSERT INTO aca_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Liwáalia'inaa ocho éerri natée liá'a samálitaca namédaque'e lirrú náiju nachíipi juáta líimana, ya nawówai náa lijí'inaa léjta lisálijinaa, Zacarías. ");
INSERT INTO aca_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Ne litúwa rumá nalí: —Jócai. Arrúnaa yáa lijí'inaa Juan. ");
INSERT INTO aca_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Néeba'eerru chuáni: —Jiní jéenajinai wáaleerri lijí'inau chárra. ");
INSERT INTO aca_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Néenee natáania nacáajiyu samálita sálijinaarru, náaque'e léenaa tánashia jí'inaashi liwówai licúuleerru. ");
INSERT INTO aca_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Zacarías sáta náucha áabai tablero píitui litánaque'e ya jáiwa litána: ‘Lijí'inaa Juan’. Ya jáiwa báawata liyá nalí quinínama. ");
INSERT INTO aca_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Liyáalimi rímija Zacarías léewa litáania báaniuwai, ya lichána liá sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Quinínama náa'a yéenai urrúni báawatai wérri yájnali, ya quinínama liá'a cáinabi yéenai dúuli íibi Judea shínaaca, náiiwadeda liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Quinínama náa'a éemenai liáni nasáta néemiu nayá jájiu: “¿Tánashia liméda liáni samálitaca jáicta máanui jíni?” Níwata yáawaiyi Dios íyada liwítee dánaniu liájcha liáni samálitaca. ");
INSERT INTO aca_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Zacarías, samálita sálijinaaca, cashiámui Espíritu Santoyu, ya litáania lijí'inaa nácu, limá: ");
INSERT INTO aca_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“¡Nuá lirrú sáicai nuwácalica, Dios Israel shínaaca, jiníwata líinuca quéewique'e lishínaa chóniwenai éewaque'e náacoo áacairra! ");
INSERT INTO aca_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Libánua walí báqueerri cadánani wítee wásedeerri'inaa wayá wajíconaa yúchau, báqueerri David táqueerrimi sírbeerrimi lirrú. ");
INSERT INTO aca_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Liyáwa limánimi liá'a walí báinacu, náiiwanimi náa'a majíconaani íiwadedenai Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Liwásedaque'e wayá wajínai yúcha, ya quinínama náucha náa'a máashiini cába wayá, ");
INSERT INTO aca_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ya licába carrúni jináataiyu wawérrinaimica, ya jócai limíya máecha liá'a limánimi limédaca wawérrinaimi yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Liyáwa liéni yáawaiyi Dios máni nácucha lirrú liá'a wasálijinaa Abrahámmica: ");
INSERT INTO aca_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Liwásedacala'inaa wayá náucha náa'a wajínaica, quéewique'e wasírbia lirrú jócu cáarru wayá, ");
INSERT INTO aca_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ya wayá lináneewa machácaniyu ya majíconaani, ya quinínama éerri jútainchu wacáwica. ");
INSERT INTO aca_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ya jiyá, nucúulee rími, jiyá jí'ineerri'inaa cáiiwadedaca Dios chuáni, lishínaa liá'a Diosca máanui wérri yéerri áacairra wérri, níwata yáairri'inau libéecha liá'a Wawácali jichúnique'e libéecha iníjbaa. ");
INSERT INTO aca_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Quéewique'e jiwána náa léenaa náa'a lishínaa chóniwenaica Dios méetuerri najíconaa ya línda nawárruacoo liyáctalaca. ");
INSERT INTO aca_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Jiníwata washínaa Dios, carrúni jináataca wérri, liwána jucámarra wawítee, újni líndachu cáiwia chaléjta éerri wáalii. ");
INSERT INTO aca_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Quéewique'e liá nalí cámarrashi náa'a yéenai dujíwala catáwacabee rícu, quéewique'e litée wayá lirrícuba liá'a iníjbaa sáictactaca wawówa.” Limá liá'a Zacarías. ");
INSERT INTO aca_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Liá'a samálitaca lidáwinau ya liwíteu cadánani liwítee Dios wíteeyu, ya liyá jiníctala yéerri, cáashia líinu liá'a éerri líyadactacoo nacába náa'a israelítabinica. ");
INSERT INTO aca_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Liyáali éerrimi, liá'a wánacaleerri íchaba cáinabi jí'ineerri Augusto César, liwána, natána nají'inau quinínama náa'a chóniwenai cáashta íta'aa lijútadaque'e nayá. ");
INSERT INTO aca_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Liáni quéechanacu sái natána najiá'inau chóniwenai quéecha'inaa Cirenio ya lishínaa wánacaleerri liá'a cáinabica jí'ineerri Siria. ");
INSERT INTO aca_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Quinínama arrúnaa náacoo natána nají'inau chúnsai nashínaa chacáalee rícula. ");
INSERT INTO aca_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Tándawa José jiáu liúcha liá'a chacáaleeca jí'ineerri Nazaret yéerri áabai cáinabi rícu jí'ineerri Galilea, ya liáque'iu áabai chacáalee néerra jí'ineerri Belén, yéerri áabai cáinabi jí'ineerri Judea rey David jiáctamicoo, Josécala David táqueerrimi. ");
INSERT INTO aca_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Liáu néerra quéewique'e litána lijí'inau cáashta íta'aa ruájcha ruá'a líinu'inaa Maríaca comprométechoo rucásacoo liájcha, liyáali éerri jáu yáawi rícucai. ");
INSERT INTO aca_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","Néenee nácula nayá'inaa Belénra, líinu liá'a éerdi María cúlicucta'inaaca, ");
INSERT INTO aca_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","jáiwa lijiáu néenii quéechanacu sái rucúuleeca, jáiwa rudájida jíni wáarruma shídami íibi, rurrúwaida cuéshinai íibana rícu jíni, jinícala náarrui nayácta'inaa cuíta rícu. ");
INSERT INTO aca_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Urrúni Belénru áabi washiálicuenai catúyacani ovejas, nají'inaa pastorbini, nayá bésunedenai táayebee bacháida rícu túyenai nashínaa ovejaca. ");
INSERT INTO aca_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Cawíquinta báqueerri ángel Dios shínaa íyadacoo nalí náa'a pastorbinica ya Dios shínaa cámarrashi quéena natéeji, jáiwa cáarru bájiala nacábacani. ");
INSERT INTO aca_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ne ángel ma nalí: “Ocáarru iyá, nuínda irrú áabai chuánshi sáicai, quéewique'e sáicta wéerri iwówai quinínama chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Wáalee lijiáu irrú, David shínaa chacáalee rícu jí'ineerri Belén, báqueerri cawásedacai iyá cáarrunatai ijíconaa yúchau, Iwácali Cristo'inaaca. ");
INSERT INTO aca_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ne quéewique'e yáa léenaa tánashia jíni, íinuminaa iyájoo linácu liá'a quirrácuaca dájiderriu wáarruma shídami íibi ruwáirriu cuéshinai íibana rícu.” ");
INSERT INTO aca_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Liyáalimi cawíquinta, íchaba ángel áacai sána íyadacoo mawí liájcha liá'a ángelca náa Diosru sáicai namá'ee: ");
INSERT INTO aca_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“¡Wáa lirrú sáicai liá'a Diosca yéerri áacai! ¡Sáictaque'e nawówa quinínama yéerri áani cáinabi íta'aa, sáicaque'e chóniwenai!” ");
INSERT INTO aca_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Quéecha'inaa jáyaali néejoo áacairra náa'a ángelmica, náa'a pastorbini namá'ee nalí wáacoo: —Wáateu Belénra, wacába liáni bésuneerricoo Wawácali íiwani walí. ");
INSERT INTO aca_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Néenee náau madéjcanaa náiinu María ya José ya quirrácua ruwáirriu cuéshinai íibana rícu. ");
INSERT INTO aca_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Nacába'inaa jíni, náiiwadeda liá'a ángel máni nalí linácu liáni samálitaca. ");
INSERT INTO aca_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Ya quinínama náa'a éemenaicani nacáarrudau néemi nachuáni namáni náa'a pastorbinica. ");
INSERT INTO aca_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Né'e ruá'a Maríaca ruwáalia ruwówa lícuu quinínama liáni rupénsani'e nácu séewirrinaa. ");
INSERT INTO aca_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Náa'a pastorbinica néejua'inaa'eewoowai náa'ee sáicai Diosru quinínama linácu'e liá'a néeminica yá'ee liá'a nacábanica, ne quinínama bésunau léjta náa'a ángelbini máyu'u nalí. ");
INSERT INTO aca_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Liwáalia'inaa ocho éerri nacírcuncida liá'a samálitaca, ya ná'ee lijí'inaa Jesús, liyá'ee jí'inaashica liá'a ángel máni Maríarru jóctanaa quéenibi ruyá. ");
INSERT INTO aca_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Líinu'inaa liá'a éerrica arrúnaa naméda léjta Moisés wánau'mi namédaca masáculaque'e nayá, natée liá'a samálitaca Jerusalénra náyadaque'ini Diosruni. ");
INSERT INTO aca_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Cha namédaqui jíni, jiníwata ley lishínaa liá'a wácalishica tánerriu: “Quinínama quéechanacu sái samálitaca arrúnaa nashírri Wawácalirruni.” ");
INSERT INTO aca_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Néenee náawai nafrésia sacrificio liá'a libánua naméda liá'a ley Wawácali mánica: Chámai paloma wérri o chámai paloma éenibi. ");
INSERT INTO aca_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Liyáali éerrimi liyá Jerusalén rícu báqueerri washiálicuerri jí'ineerri Simeón. Liéni washiálicuerri machácani ya sáicai wítee, ya yáairri sáicai Diosru, ya liméda léjta Dios wówau'i, ya linénda liwásaida Israel táqueenaimi. Liá'a Espíritu Santo liyá Simeón yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Espíritu Santo wána liá léenaa jóctanaa máanali liyá libéecha, cáashia lijiáctala'inaa ya licába liá'a Mesíasca, liá'a Dios bánuani'inaaca. ");
INSERT INTO aca_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Espíritu Santo bánua Simeón liáque'iu templo rícula; ya jái'inaa litúwanai liá'a samálita Jesúsca natée liyá lécchoo, nacúmpliaque'e léjta ley wánacaalau'i, náiinu Simeón nácu. Nawíchua lichípi íimanaa dácu. ");
INSERT INTO aca_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Néenee Simeón liwína liná lícu liá'a samálitaca, liá Diosru sáicai limá chá'a: ");
INSERT INTO aca_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Ya ta, Nuwácali, jinísa jiméda léjta jimáyumi; ya ta jéewa jimáaca máanali nuyái jishínaa cha liwíteemija'a, nuyá cashírruedacaica jirrú. ");
INSERT INTO aca_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Jiníwata nunísa nucába liá'a wásedeerri'inaa wayá Dios shínaa máashii yúcha, ");
INSERT INTO aca_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","lichána limédacoo quinínama chóniwenai tuími rícula, ");
INSERT INTO aca_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","liá'a cámarrashica liquénaminaa nawítee rícuejijoo quinínama chóniwenai, yáminaa liwánaque'e cawáunta nayá Israel táqueenaimi. Limá liáni Simeónca.” ");
INSERT INTO aca_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Néenee José ya litúwa liá'a Jesús nacáarrudau néemi liá'a simeón máni linácucha liéni samálitaca. ");
INSERT INTO aca_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Néenee Simeón liá nalí sáicai, ya limá Maríarru, Jesús túwaca: —Jéemite, liéni samálitaca Dios wínani quéewique'e liméda íchaba chóniwenai israel néenee sána nacáu o nabárroo. Liyá'inaminaa áabai señal, íchabaminaa cháani liyá, ");
INSERT INTO aca_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","quéewique'e liá'a yéerri íchaba wówa lícu líyadaque'iu. Ne quinínama liéni jirrú'inaa cáiwi wérri'inaa, chaléjta áabai espada dúurruerri jicáwica íbeeji. ");
INSERT INTO aca_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Cha lécchoo ruyá néeni báquetoo íinetoo jí'ineechoo Ana, rutáania Dios jí'inaa nácu, limíyacaulami liá'a Panuel, litáqueerrimi liá'a Aser. Ana bájialau salítuenica, ya rucása'inaamiu miyácau wáaliu rími, ya rúnirri máanali nawáalia'inaa náajcha wáacoo siete camuí; ");
INSERT INTO aca_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","liyáalimi éerri ruwáalia ochenta cuatro camuí, ruyá máanirri. Jócau jiáu templo rícucha, rusírbia Diosru táayenaa ya éerrinacu ayúnoyu ya oraciónyu. ");
INSERT INTO aca_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ana íinu liyáalimi jáa, ya ruchánaa ruá Diosru sáicai, ya rutáania linácu liá'a samálita Jesúsca ya quinínama náa'a chóniwenai néndenai liwásaida, náa'a chóniwenai yéenai Jerusalén rícu. ");
INSERT INTO aca_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Liáwinaami nanísa'inaa nacúmplia quinínama léjta libánua liá'a ley Wawácali shínaa, jáiwa néejoo Galilea néerra, nashínaa chacáalee jí'ineerri Nazaret. ");
INSERT INTO aca_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Ya liá'a samálita Jesús lidáwinau cadánani ya mawí cawíteeca, ya Dios yáa lirrú sáicai mamáarraca. ");
INSERT INTO aca_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Jesús túwanai yáaineu Jerusalén néerra camuí jútainchu lirrú liá'a fiestaca jí'ineerri pascua. ");
INSERT INTO aca_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Quéecha'inaa Jesús cúmplia doce camuí, yáaineu Jerusalénra naméda fiesta léjta nawíteeyu. ");
INSERT INTO aca_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Ne amáarrai'inaa fiestai, néejoowai, ne liá'a samálita Jesús máaquerriu Jerusalén rícu, jócani litúwanai yáa léenaa. ");
INSERT INTO aca_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Namáta'ee Jesús yáairri chóniwenai íibi, najínactacoo áabai éerri iníjbaa lícu. Quéecha'inaa namúrruqui jíni náiibiu náa'a néenaaca náa'a nacúnusianica lécchoo, ");
INSERT INTO aca_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","jócai náiinu linácu liá'a Jesúsca. Néenee néejoowai Jerusalén rícula báaniu namúrruque'e néerrani. ");
INSERT INTO aca_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Liáwinaami matálii éerri rícula, náiinu linácu templo rícu, wáairriu liyá náiibi náa'a éewidenaica Moisés chuáni, éemerri liyá nalí ya sáteerri liyá léemiu nayá. ");
INSERT INTO aca_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ya quinínama náa'a éemenai Jesúsru nacáarrudau néemi liwítee ya léebaca nachuáni. ");
INSERT INTO aca_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Litúwanai cába'inaa jíni, nacáarrudau nacábaque'e jíni, litúwa ma lirrú: —¿Nucúulee rími, táda jiméda walí liárra? Jicá'ateni, jisálijinaa yáajchau urrúni wawówa wamúrru jiyá. ");
INSERT INTO aca_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Jesús ma nalí: —¿Táda imúrru nuyá? jócai yáa léenaa arrúnaa báwatui nuyáca linácu liá'a nusálijinaa wówainica? ");
INSERT INTO aca_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Né'e jócai náa léenaa néemi liá'a limáni nalí. ");
INSERT INTO aca_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Néenee Jesús léejoo náajcha Nazaret néerra, lisíguia liméda nawánacaala. Quinínama liáni litúwa jócai rumíya máecha, ruwáaliani ruácoo ruwówa lícuu. ");
INSERT INTO aca_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Ya Jesús mamáarracai dáwinacoo lináanaica, ya liwítee, ya sáicta liwówa Dios yáajcha chóniwenai yáajcha lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Jái'inaa quinse camuí liwánacaala liá'a chúnsai wánacaalaca jí'ineerri Tiberio, liyáali éerrimi Poncio Pilato liwánacaala cáinabi jí'ineerri Judea, Herodes liwánacaala cáinabi jí'ineerri Galilea, ya léenajirri Felipe liwánacaala cáinabi jí'ineerri Iturea ya Traconite, ya liá'a Lisinias liwánacaala cáinabi jí'ineerri Abilinia. ");
INSERT INTO aca_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Anás ya Caifás sacerdótebini wácanai. Liyáalite Dios táania Juanru licúulee liá'a Zacaríasca yáairri jiníctala yáa, ");
INSERT INTO aca_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ya Juan libésunau quinínama cáinabi urrúni méeda jí'ineerri Jordán, limá liácoo chóniwenairru arrúnaa néejoocoo Diosru ya nawána nabáutisa nayá, quéewique'e Dios méetua najíconaa. ");
INSERT INTO aca_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Liáni bésuneerriu léjta litánaumi liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Isaías: “Báqueerri chóniwerri máidaderri'inaa jiníctala yáairri: ‘Ichúni liá'a iníjbaaca Wawácalirru, iméecu áabai iníjbaa machácani. ");
INSERT INTO aca_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Quinínama sájaba máanui wérri báyeerri'inau, quinínama dúuli wérri ya dúuli rími naquénini nabáyaque'e liyáque'e áabee, náa'a iníjbaa cúwaneerricoo arrúnaa machácanicani, ya áabee naméda iníjbaa dujíwanamaica. ");
INSERT INTO aca_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Quinínama chóniwenai nacábaminaa liá'a Dios bánuani wáseda wayá.’ ” ");
INSERT INTO aca_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Najiá'inau náa'a chóniwenai quéewique'e Juan báutisa nayá, limá nalí: “¡Iyá léjta áai éenajinai! ¿Tána ma irrúi ibáutisaacalau iwásedacaalau liúcha liá'a carrrúnatai rúneerricoo liácoo? Ipénsacta chárra iyá yúquenaiu iyáca. ");
INSERT INTO aca_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Iyá sáica, nacábaque'e yáawacta éejoo Wawácalirru, ya ówa imá irrúwoo: ‘¡Wayá Abrahám táqueenaimi wásedeenai'inau!’ Ne yáawaiyi numá irrú, Dios éewerri lináwida náani íibaca Abrahám táqueenaimiyu. ");
INSERT INTO aca_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ya mawí, liá'a chúushi jái ya cái quéewique'e liwíchua áicuba lijíchu yáajchau. Quinínama áicuba jócai yáa lítau sáica, wíchuerriu ya náuca chichái rículani.” ");
INSERT INTO aca_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Néenee chóniwenai sáta néemiu liyá: —¿Tána wéewa wamédacai? ");
INSERT INTO aca_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Juan éeba nachuáni: —Liá'a wáaleerri chámai íibalashi, jiá lirrú áabai liá'a jiní wáaliani; ya liá'a wáaleerri íyacaishi, jishírrida liájcha liá'a jiní wáaliani. ");
INSERT INTO aca_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Néenaa náa'a cóbrenai impuesto Romarru narrúniu Juanru quéewique'e nabáutisacoo ya nasáta néemiu liyá: —Quéewidacai, ¿tána wéewa wamédacai? ");
INSERT INTO aca_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Juan ma nalí: —Jócai cobra bájiala liúcha liá'a léjta nawánau icóbraca. ");
INSERT INTO aca_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Néenaa náa'a soldado nasáta néemiu lécchoo: —Ya wayá ¿tána arrúnaa wamédacai? Juan éeba nachuáni: —Jiní éedani náucha cháji'i, jiní ibáulidaca nayá, uyáa najíconaa cháji'i jócai naméda; ya sáicta iwówa liájcha liérra iwénica napáida iyá. ");
INSERT INTO aca_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Náa'a chóniwenai nanénda nacábau tána'inaa bésunawai, nasáta néemiu nayá wáacoo Mesías liá'a Juanca; ");
INSERT INTO aca_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Ne Juan ma nalí quinínama: “Nuyá yáawaa nubáutisa shiátaiyu; ne báqueerri íinuminaa báutiseerri'inaa Espíritu Santo wíteeyu, ya chicháiyu. Liyá mawí cadánani wítee núcha, jócai sáicaminaata nutájiacoo nuwáseda lishínaa cotiza báji. ");
INSERT INTO aca_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Línda licáaji rícuu léjta áabai pala, quéewique'e liáwaqueda trigo ya lishírrini máashiibee liúcha. Liwáaliaminaa trigo líibana rículau, ne léemaminaa liá'a máashiibeeca chichái rícula jócai chácacajiu.” Liáni wówerri limáca lishírri náa'a sáicanica, ya máashii liúcani'inaa chichái rícula jócai chácacajiu. ");
INSERT INTO aca_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Cháwate Juan íiwa nalíni, ya áabi íchaba wítee lécchoo, Juan íiwa nalí sáicai chuánshi chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ya lécchoo licáita Herodes wánacaleerri Galilea shínaa cáinabi, jiníwata liwáaliaca líinuyu ruá'a Herodíasca, léenajirri Felipe íinucoo, ya lécchoo quinínama máashii limédanica; ");
INSERT INTO aca_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Ne Herodes jócai méda liwánacaala liá'a Juanca, litúculeda áabai máashii mawí: liwárrueda Juan cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Jóctanaa Juan yáa cuíta manúmai rícula, báutisa'inaa quinínama chóniwenai, Jesús báutisau lécchoo; ya nácula li'óra, liá'a Jesús éerri méecu lirrú, ");
INSERT INTO aca_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ya Espíritu Santo yúrrucoo linácula léjta áabai paloma, ya nacábani; ya léemi áabai chuánshi áacai mérri lirrú: —Jiyá Nucúulee nuwówaini, jiyáwa nuwínani. ");
INSERT INTO aca_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesús wáalia'inaa újni treinta camuíca lichánau liméda lishínaa tráawajo. Léjta néebidau'u José cúuleecani. José Elí cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Elí Matat cúuleemi, Matat Leví cúuleemi, Leví Melqui cúuleemi, Melqui Jana cúuleemi, Jana José cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","José Matatías cúuleemi, Matatías Amós cúuleemi, Amós Nahum cúuleemi, Nahum Esli cúuleemi, Esli Nagai cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai Maat cúuleemi, Maat Matatías cúuleemi, Matatías Simei cúuleemi, Simei Josec cúuleemi, Josec Judá cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Judá Joanán cúuleemi, Joanán Resa cúuleemi, Resa Zorobabel cúuleemi, Zorobabel Salatiel cúuleemi, Salatiel Neri cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Neri Melqui cúuleemi, Melqui Adi cúuleemi, Adi Cosam cúuleemi, Cosam Elmadam cúuleemi, Elmadam Er cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er Jesús cúuleemi, Jesús Eliezer cúuleemi, Eliezer Jorim cúuleemi, Jorim Matat cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Matat Leví cúuleemi, Leví Simeón cúuleemi, Simeón Judá cúuleemi, Judá José cúuleemi, José Jonam cúuleemi, Jonam Eliaquim cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Eliaquim Melea cúuleemi, Melea Mena cúuleemi, Mena Matata cúuleemi, Matata Natán cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Natán David cúuleemi, David Isaí cúuleemi, Isaí Obed cúuleemi, Obed Booz cúuleemi, Booz Sala cúuleemi, Sala Nahasón cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nahasón Aminadab cúuleemi, Aminadab Admin cúuleemi, Admin Arni cúuleemi, Arni Esrom cúuleemi, Esrom Fares cúuleemi, Fares Judá cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Judá Jacob cúuleemi, Jacob Isaac cúuleemi, Isaac Abrahám cúuleemi, Abrahám Taré cúuleemi, Taré Nacor cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Nacor Serug cúuleemi, Serug Ragau cúuleemi, Ragau Peleg cúuleemi, Peleg Heber cúuleemi, Heber Sala cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sala Cainán cúuleemi, Cainán Arfaxad cúuleemi, Arfaxad Sem cúuleemi, Sem Noé cúuleemi, Noé Lamec cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamec Matusalén cúuleemi, Matusalén Enoc cúuleemi, Enoc Jared cúuleemi, Jared Mahalaleel cúuleemi, Mahalaleel Cainán cúuleemi, ");
INSERT INTO aca_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Cainán Enós cúuleemi, Enós Set cúuleemi, Set Adán cúuleemi, Adán Dios cúuleemi. ");
INSERT INTO aca_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Jesús Espíritu Santo cámusheda liwítee, léejoo méeda Jordán néenee, ya Espíritu litée jiníctala yáairri. ");
INSERT INTO aca_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Néerra liyá cuarenta éerri, ya liá'a Wawásimi wówai Jesús méda lijíconau. Jesús jiní íyani narrícu náa'a éerrica, táda cha liáwinaami lisíntia ínaaishi. ");
INSERT INTO aca_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Néenee Wawásimi ma lirrú: —Yáawaicta Dios Cúulee jiyá, jiwánate lináawacoo liéni íibaca páaniyu. ");
INSERT INTO aca_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Jesús éeba'ee: —Limá'ee liá'a Dios chuáni jái tánacuwai: ‘jócai bácai íyacaishiyu liyá liá'a washiálicuerrica.’ ");
INSERT INTO aca_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Néenee Wawásimi írrida Jesús ya líyada lirrú quinínama náa'a país éerri rícu, ");
INSERT INTO aca_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","limá lirrú: —Nuá jirrú quinínama jiwánacaalaque'e éerri rícu cawéninica. Níwata nuyá nunísani nurríshibiaca, ya nuá tánashia nuwówaini nuárru jíni. ");
INSERT INTO aca_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Jitúyactau nulí ya jiá nulí sáicai, quinínama jishínaaminaa. ");
INSERT INTO aca_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Jesús éeba'ee lichuáni: —Nuyá jócai túyau jirrú, jiníwata limá liá'a tánerricoo: ‘Jitúyau Diosruja, ya jisírbia lirrú bácai.’ ");
INSERT INTO aca_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Liáwinaami Wawásimi tée Jesús chacáalee Jerusalénra, lírrida liyá templo ítala mawíta áacaica ya limá lirrú: —Yáawaicta Dios Cúulee jiyá, jicáteu cáinabi rícula wayéji áani; ");
INSERT INTO aca_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Jiníwata limá liá'a tánerricoo: ‘Dios bánuaminaa lishínaa ángelbini nayúda ya natúya jiyá. ");
INSERT INTO aca_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Nanácudaminaa jiyá nacáaji rícuu, jócubeecha jíinuau íiba nácula’. ");
INSERT INTO aca_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Jesús éeba'ee Wawásimi chuáni: —Limá lécchoo liá'a tánerricoo: ‘Ujimáca máashii Diosru jiwówaini limédaca.’ ");
INSERT INTO aca_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Quéecha'inaami Wawásimi jócu léenaa liwána Jesús méda lijíconau, néenee Wawásimi dáanau liúcha íchaba éerri. ");
INSERT INTO aca_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Liáwinaami Jesús éejoo lishínaa cáinabi ítalau jí'ineerri Galilea Espíritu Santo dánaniyu, néenee natáania linácu quinínama lirrícu liá'a cáinabica yéerri litéeji. ");
INSERT INTO aca_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Ne léewida nayá narrícu náa'a cuíta jí'ineenai sinagoga, ya náa lirrú quinínama sáicai. ");
INSERT INTO aca_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Jesús yáau Nazaret néerra, chacáalee lidáwinactamicoo. Léerdi nawówa íyabactacoo liwárroo sinagoga rícula, léjta liwíteeja, jáiwa libárruawai quéewique'e liliá Dios Chuáni. ");
INSERT INTO aca_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Náa liliá cáashta litánanimi liá'a íiwadedeerri Dios chuáni báinacu Isaíasca, limécu'inaamini líinu linácu liá'a tánerricoo chá'a: ");
INSERT INTO aca_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Espíritu nuwácali shínaa yáairri nunácu, jiníwata liníwaca nuyá quéewique'e nutée chuánshi wáalii nalí náa'a carrúni jináatanica; libánua nuyá nuíiwadeda chítashia éewau'inaa mabáji náa'a presoca ya nuéejueda natuí náa'a matuínica; nuchánaa nuéda nabáji náa'a nabádadanica; ");
INSERT INTO aca_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","nuíiwa liá'a camuí sáictaica Wawácali shínaaca.” ");
INSERT INTO aca_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Liáwinaami Jesús támu liá'a cáashta, jáiwa liá lirrú jíni liá'a yúderri nayá sinagoga rícu, jáiwa liwáawai. Quinínama náa'a yáaine néeni nacába lirrú. ");
INSERT INTO aca_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Jáiwa lichánau litáaniacai limá'ee: —Wáalee éerri linísa licúmpliacoo liéni tánerricoo ináneewa. ");
INSERT INTO aca_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Quinínama natáania Jesús nácu sáica ya nacáarrudau nacába liá'a limánica sáictaica. Nasátada'ee néemiu nayá wáacoo: —¿Jócaita le José cúulee léji liéni? ");
INSERT INTO aca_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Jesús éeba'ee nalí: —Yáawaiyi numá irrú, imáminaa nulí léju liéni chuánshica: ‘Médico, jichúni jiyá jájiu.’ Mawí imáminaa nulíjoo: ‘Liá'a wéeminica jimédani Capernaúm rícu, jiméda lécchoo ája áani chúnsai jicáinabeerra íta'au.’ ");
INSERT INTO aca_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ne mamáarraca limá'ee: —Ne yáawaiyi jiní báqueerri cáiiwadedacai Dios chuáni, jócai sáica narríshibia lishínaa cáinabi íta'au. ");
INSERT INTO aca_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Yáawai méetaa íchabate máanirrini Israel rícu, éerri liyá'inaami liá'a íiwadedeerri Dios chuáni báinacu Elíasca, quéecha'inaamite jócu liúwau matálii camuí ya béewami mawí, jáiwa íchaba íinaishi quinínama Israel cáinaberra íta'aa; ");
INSERT INTO aca_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ne Elías Dios jócai libánua nalí náa'a máanirrinica Israel rícu, ne ta chaléjani Sarepta néerra, urrúni lirrú liá'a chacáalee Sidónca. ");
INSERT INTO aca_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Chacábacanaa íchabate bálinenaiu liyú liá'a chorrówa íyeerri náinaa Israel rícu, éerrimi liyá liá'a cáiiwadedacaimi Dios chuáni báinacu Eliseoca, ne jiní éeneerri lichúnicoo néenaaca bácai rími Naamán, chéesaicani Siria sáica. ");
INSERT INTO aca_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Quéecha'inaami néemi quinínama liéni, náa'a yáaine sinagoga rícu íiwirri wérri nawówa bájialanaa. ");
INSERT INTO aca_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nabárrua'inaamiu, jáiwa najéda chacáalee rícucha Jesús, natée'e wáni dúuli áacai ítala chacáalee yáctaca, quéewique'e najúsunedacani cáinacula néenini. ");
INSERT INTO aca_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ne Jesús bésunau nadécumi quinínama, jáiwa liáu néenee. ");
INSERT INTO aca_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Jesús yá'eewoo Capernaúmra, áabai chacáalee Galilea sái, ne léerdi nawówa íyabactacoo léewida náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Ne náa'a chóniwenai nacáarrudau nacába léewidacalaca, jiníwata táanierri quinínama wánacaalashiyu. ");
INSERT INTO aca_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Sinagoga rícu báqueerri washiálicuerri yá'ee wáalierri demonio, jáiwa'ee limáidada lidánaniyuwai: ");
INSERT INTO aca_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","¡Jimáaca wayá! ¿Tánda jiníquiu wáajcha, Jesús Nazaret néenee sái? ¿Jiyá íinuerri'e jimárda wayá? Nuyá cúnusierri jiyá, nuá léenaa jiyá majíconaica Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Jesús cáita'ee liá'a demonioca limá'ee lirrú: —¡Manúmata ya jimáaca liéni washiálicuerrica! Néenee liá'a demonio liúca liá'a washiálicuerrimica cáinabi rícula nanáneewa quinínama, ya jáiwa lijiáu liúchai jiní limédacta lirrú máashii. ");
INSERT INTO aca_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Quinínama nacáarrudau'eewoo, ya namá'ee nalí wáacoo: —¿Tána chuánshiqui jiliéni? Quinínama liá'a wánacaleerrica ya liwítee dánani liéni washiálicuerrica liwána najiácoo náa'a espíritu máashiinica, ¡ya nayá jiáneu! ");
INSERT INTO aca_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Ya natáania sáica Jesús nácue quinínama líta'aa liá'a quinínama cáinabica. ");
INSERT INTO aca_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Jesús jiá'inaamiu sinagoga rícucha ya jáiwa liwárroo líibana lícula liá'a Simónca. Linéerru liá'a Simónca bálinechoo'eewoo ruyáca, máanui wérri licámuna, nasáta Jesús yúcha runácui. ");
INSERT INTO aca_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Jesús tájia'eewoo ruyáctaca ya jáiwa licáita liá'a licámunacaa, jáiwa licámuna éedawai, liyáalimi, jáiwa rubárruawai ya ruchánau rushírrueda nalí. ");
INSERT INTO aca_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Éerri wárruau'inaami liyá cái, quinínama náa'a nawáalia bálinacaalashi, matuínaami bálinacaalashi natée'e nayá Jesúsru; ne jáiwa licháanaa licáajiu nanácui bácainaa, jáiwa lichúni nayái. ");
INSERT INTO aca_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ne náiibicha náa'a bálinenaicoo íchaba lécchoo najiáu náa'a demonioca, namáidadaca namá'ee: —¡Jiyáwa liérra Dios Cúuleeca! Ne Jesús cáita náa'a demonioca, ya jócu línda natáaniaca, jiníwata náaca léenaa liyá liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Jucámarra'inaami, Jesús jiáu chacáalee rícucha, áabai yáarruishi jiníctala yáairri. Ne náa'a chóniwenaica namúrru liyá, jáiwa náiinu liyáctala liyáca. Nawówai náayabedacani jócubeechata liáu, ");
INSERT INTO aca_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ne Jesús má'ee nalí: —Lécchoo arrúnaa nuíiwa liáni chuánshi sáicaica linácue sái liá'a Dios wánacaalactalaca nalí náa'a áabi chacáaleeca, linácueji liéni Dios bánua nuyá máyala áani. ");
INSERT INTO aca_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Cháwa'ee Jesús íiwa liácoo liá'a chuánshica sinagoga rícuba cáinabi nashínaa náa'a judíobinica. ");
INSERT INTO aca_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Áabai éerrite, Jesús yáa liyáca litácoowa liá'a manuá jí'ineerri Genesaret, lisíntia nabádeda liyá náa'a chóniwenai máanabanaamica wówenai néemi Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Jesús cába chámai lancha cáina nácu. Máisananiyaca níwata náa'a catésucanica yúrrucuenaiu lirrícucha nabádeda nashínaa máayau. ");
INSERT INTO aca_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Jesús yúrrucoo áabai lancha rícula, Simón shínaaca, jáiwa liwána lidáanaa píituita litácooweji bachátairra. Jáiwa liwáau lirrícu liá'a lanchaca néenee lichánau léewida náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Linísa'inaami litáaniacai, limá'ee Simónru: —Jitée liá'a lanchaca chaléeni bachátala dujíwactalaca, ya ta yúca ishínaa máayawai itésuque'e. ");
INSERT INTO aca_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Simón éeba'ee: —Quéewidacai, táayenaa watráawajaaca watésuca, ne jiní wérri wajédani; ne jiyáctaca bánuani, nuá'au nudáquinia numáayaniu. ");
INSERT INTO aca_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Ne naméda'inaami jíni, náawaqueda bájialanaa cubái liá'a namáayani atéwanamai súbirriacoo. ");
INSERT INTO aca_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Néenee namáida náa'a nashínaa najúnicaica máinecoo áabai lancha rícu, quéewique'e náacoo nayúda nayá. Néenee náau néerrai, nacámusheda náa'a chámai lanchaca atéwa namácta natámucoo. ");
INSERT INTO aca_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Simón Pé'eru cába'inaami liéni, litúyau liúrruimiyu Jesús náneewa limá'ee lirrú: —¡Jishírriu núcha, Nuwácali, níwata nuyá cajíconai! ");
INSERT INTO aca_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Jiníwata Simón ya quinínama cáarrudenaiu nacába liá'a najédau cubái, máanaba náami jócai nacába cáji. ");
INSERT INTO aca_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Lécchoo cáarrudenaiu náa'a Santiago ya Juan, Zebedeo éenibica, Simón máanabacaca. Ne Jesús má'ee Simónru: —Ocáarru jiyá; léjta jinísau jitésucai, chacábacanaa jimúrru nulí chóque'e chóniwenai nasíguia nuyá. ");
INSERT INTO aca_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Néenee natée lanchami litácoowalai, namáaca quinínama, jáiwa náau Jesús yáajchai. ");
INSERT INTO aca_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Áabai éerrite, Jesús yáa liyáca áabai chacáalee rícu, líinu báqueerri washiálicuerri bálinerriu chorrówa íyeerri náinaa jí'ineerri lepra; licába'inaami Jesús litájiau linánimiyu cáinabi nácula, lisáta'ee liúcha: —Nuwácali, jiwówaicta, jichúni nuyá nubálinacaala yúcha. ");
INSERT INTO aca_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Jesús dúnu'e licáajiyu wáni, limá'ee: —Nuwówai, ¡jichúnicoo! Liyáalimi libálinacaala'ee chorrówa íyeerri líinaa éedau liúcha, ");
INSERT INTO aca_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Jáiwa Jesús ma lirrúi: —Jiníwaa jíiwani jiyárrujoni; bácai rímii jiáu jíyadacoo sacerdote náneewa, ya jitée jishínaa jiméetua'inau jiyáu, liá'a Moisés wánanimi imédaca, quéewique'e quinínama yáa léenaa jáica sáica jiyái jibálinacaala yúchau. ");
INSERT INTO aca_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Ne mamáarraca, Jesús íiwanaa cáarraliacoo quinínama matuínaami, ya íchaba chóniwenai yáawacau néemique'e lichuáni ya lichúnique'e nabálinacaala. ");
INSERT INTO aca_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ne Jesús lishírriu jiníctala yáairri quéewique'e li'óracoo. ");
INSERT INTO aca_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Áabai éerri Jesús éewidacta liyáca, nawáau nayá néeni náa'a áabi fariséobini ya quéewidacanica ley shínaabinica íinuenai quinínama chacáalee rími Galilea shínaaca, ya Judea ya Jerusalén néenee. Ya Dios wítee íyadau Jesús nácu lichúni náa'a bálinenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Néenee áabi washiálicuenai íinu índenai báqueerri macáwai liárrubai íta'au. Nawówaicta'ee nawárrueda cuíta licúlani ya náyada Jesús náneewani; ");
INSERT INTO aca_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Ne jócu náiinu táshia nácucha nawárrua jíni, jiníwata bájialaca íchaba chóniwenai; jáiwa náirda liyá cuíta íteeji, néeda bájirra cuíta báinaa ya náurrucuedaque'e liyá néenee bálinerricoo liárrubai íta'au, néeni béewami nalí quinínama, Jesús náneewa. ");
INSERT INTO aca_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Quéecha'inaami Jesús yáa léenaa néebida'inaa linácu, limá'ee lirrú liá'a bálinerricoo: —Nujúnicai, jijíconaa jái méetuacuwai. ");
INSERT INTO aca_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Néenee náa'a quéewidacanica ley shínaabinica ya náa'a fariséobinica nachánau napénsaaca: “¿Tána léji liéni éeneerri limá chá'a chuánshi máashii Dios nácula? Bácai rími Dios éeneerri liméetua jíconaashi.” ");
INSERT INTO aca_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Ne Jesús yáirri léenaa liá'a napénsaani nayáca, lisáta'ee léemiu nayá: —¿Tána ipénsa irrúwoo chárra? ");
INSERT INTO aca_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","—¿Tána mawí jócu tráawajui, wamácai: ‘Jijíconaa máaquerriu liméetuacuwai’, o numáca: ‘Jibárroo jijínau?’ ");
INSERT INTO aca_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Ne núyadaminaa irrú, nuyá Washiálicuerri Dios Cúuleeca wáalierri wánacaalashi cáinabi íta'aa liméetua'inaa jíconaashi. Néenee limá lirrú liá'a macáwaica: —Numá jirrú, jibárroo, jiwína jiárrubaiu ya jiáu jíibana néerrau. ");
INSERT INTO aca_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Liyáalimi, liá'a macáwaica léenuu libárruacoo quinínama náneewa, liwína liárrubaiu lirrú wánimicoo íta'aa, jáiwa liáu líibana néerrawai liá sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Quinínama nacáarrudau nacábacani, jáiwa náa sáicai Diosrui ya bájialanaa nacáarrudacoo namá'ee: —Wáalee wacába watuíyu jócai wacába cáji. ");
INSERT INTO aca_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Liáwinaami liéni, Jesús jiáu, jáiwa licába báqueerri cacóbracai impuesto Romarru. Jí'ineerrimi Leví, wáairriu liyáca yáarrubaishi íta'aa licóbra liyá impuesto. Jesús má'ee lirrú: —Jisíguia nuyá. ");
INSERT INTO aca_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Néenee Leví bárroowai, limáaca quinínama, jáiwa liáu Jesús yáajchai. ");
INSERT INTO aca_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Táicala'inaami mawí, Leví méda áabai fiesta máanui wérri líibana néeniu Jesúsru; ya íchaba náa'a cóbrenai impuesto Romarru, náajcha náa'a áabi chóniwenaica, wáaineu nayáca mesa nácula náajcha. ");
INSERT INTO aca_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Ne náa'a fariséobinica ya náa'a quéewidacanica ley shínaabinica néenaacajaa, nachánau nacáida Jesús shínaa éewidenaicoo. Namá'ee nalí: —¿Tánda íya ya írra náajcha nárra cacóbracani impuesto ya cajíconaanica? ");
INSERT INTO aca_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Jesús éeba'ee nachuáni: —Náa'a sáicanica, jócani rúnaa médico, ta nayá náa'a bálinenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nuyá jócai íinu numáida náa'a sáicanica, nuíinu numáida náa'a cajíconaanica, quéewique'e néejueda nayáu Diosru. ");
INSERT INTO aca_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Néenee namá'ee Jesúsru: —Náa'a casíguiacani Juan ya fariséobini shínaaca yúnenai bájialanaa ya naméda bájialanaa oración, ne jishínaa éewidenaicoo jiájcha éerri jútainchu náaya ya náirra. ");
INSERT INTO aca_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Jesús éeba'ee nalí: —¿Léewaminaatau éewa iwána nayúnaa náa'a namáidani áabai matrimóniorru, nácula liyá náajcha néeni liá'a novioca? ");
INSERT INTO aca_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ne líinuminaa liá'a éerrica, natécta'inaa liá'a novioca; jáicta líinu liá'a éerrica, liyáaliminaa nayúnaajoo. ");
INSERT INTO aca_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Chá'a lécchoo líiwa nalí áabai licábacanaa: —Jiní dáulerri áabai íibalashi wáalii quéewique'e lichánaida áabai íibalashi dánumimi. Ne limédactacala cháni'i, ya táminaa liúca liá'a íibalashi wáaliimica; mawíyi liá'a shídanaamica wáalii, jócai sáicta máacacoo íibalashi dánumimi yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Ne jiní lécchoo wanuácala vino wáalii áabai íimanaashi salírrani rícula, níwata liá'a vino wáaliica wáneerri lisúbirriacoo liá'a íimanaashi dánumimica, léjta liá'a íimanaashi ya liá'a vinoca jái liúcawai. ");
INSERT INTO aca_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Tádawa arrúnaa wanuá vino wáalii lirrícula liá'a íimanaashi wáaliica. ");
INSERT INTO aca_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ne liá'a írrerri vino salírrani, jócai wówai liáwinaami vino wáalii, jiníwata jái limái: ‘Liá'a vino salírranica mawí sáictaca.’ ");
INSERT INTO aca_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Áabai éerri nawówa íyabactacoo Jesús jínaniu nabáanacaala íibi. Lishínaa éewidenaicoo liájcha néerrua líta liá'a trigoca, ya ta nacárra nacáaji rícuu jíni ya ta náaya líimii. ");
INSERT INTO aca_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Jáiwa áabi fariséobini nacába'inaami liáni, nasáta néemiu: —¿Tánda iméda iyá liérra jócai wéewa waméda éerdi wawówa íyabactacoo? Jiníwata jócai ley índa wamédaca. ");
INSERT INTO aca_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Jesús éeba'ee nachuáni: —¿Jócai iliá icábau Dios chuáni nácu báitate David ya náa'a limánabaca nawáaliate ínaaishi? ");
INSERT INTO aca_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Jáiwate liwárruawai Dios íibana rícula, jáiwa liwína náji náa'a páanica nashírrini Diosru, líya liyái ya liá náaya lécchoo náa'a limánabaca, báawita bácai rími ta náa'a sacerdótebinica éewata náayacani bácai liá'a páanica. ");
INSERT INTO aca_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Néenee Jesús ma mawí: —Nuyá Washiálicuerri Dios Cúuleeca, nuwáalia wánacaalashi linácu liá'a éerrica nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Áabai éerri nawówa íyabactacoo náa'a judíobinica, Jesús wárruerriu sinagoga rícu ya lichánau léewidaca. Báqueerri washiálicuerri yáairri néeni máacarrai cáaji ché'e sáicaquictejica. ");
INSERT INTO aca_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Néenee néeda lituínaa liá'a Jesúsca náa'a éewidenaica Moisés shínaa ley ya fariséobini lécchoo, nacábaque'e lichúnicta liá'a máacarrai cáaji, lirrícu liá'a éerrica nawówa íyabactacoo, néewaque'e náa lijíconaa liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Ne liá'a Jesúsca, liá léenaa chítashia nawítee jíni, limá lirrú liá'a washiálicuerrica máacarrai cáaji: —Jibárroo, jimédau béewami. Néenee libárruawai. ");
INSERT INTO aca_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Néenee Jesús ma nalí náa'a áabica: —Nuwówai nusáta nuéemiu iyá áabai chuánshi rími: ¿Lirrícu liá'a éerrica wawówa íyabacoo, wéewa waméda sáicai o máashii? ¿Wawáseda cáwicaishi o wamárdacani? ");
INSERT INTO aca_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Linísa litáania náajcha, liá'a Jesúsca licába quinínama litéejiu limá lirrú liá'a washiálicuerrica: —Jidúcua jicáajiu. Liméda jíni, sáicai báaniu jíni licáajica. ");
INSERT INTO aca_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Ne náa'a áabica íiwirrini wérri nawówa. (Namáctacala'ee Jesús méda lijíconau litráawajaaca lirrícu liá'a éerrica nawówa íyabactacoo). Táda natáania nalí wáacoo tánashia néewa namédaca Jesús júnta. ");
INSERT INTO aca_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Liyáali éerrite, Jesús yáau áabai dúuli ítala li'óracoo, libésuneda quinínama táayebee li'óracoo Diosru. ");
INSERT INTO aca_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Quéecha'inaami jucámarra cái, limáida lishínaa éewidenaicoo, jáiwa liwína doce néenaa, liá nají'inaa apóstolu. (Wówerri limá bánuani naméda áabai tráawajuca). ");
INSERT INTO aca_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Léewa nají'inaa liáni: Simón, liá liéni jí'inaa Pé'eru; Andrés, Simón éenajirrica; Santiago, Juan, Felipe, Bartolomé, ");
INSERT INTO aca_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateo, Tomás, Santiago, licúulee liá'a Alfeo; Simón liá'a Celote, ");
INSERT INTO aca_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Judas, Santiago cúuleeca, ya Judas Iscariote, liá'a náawiderriu liwítee máashii éejuederri'inaa Jesús. ");
INSERT INTO aca_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Jesús yúrrucoo dúuli ítacha lishínaa apóstolu yáajcha, jáiwa limáacau áabai bacháida lícui. Néeni náawacau íchaba náa'a síguianai liyá, ya íchaba chóniwenai Judea shínaa cáinabi ítesanaca ya Jerusalén ya litácooweji liá'a Tiroca ya Sidón. Íinuenai néemique'e Jesús chuáni ya quéewique'e lichúni nashínaa bálinacaalashi. ");
INSERT INTO aca_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ya náa'a carrúni jináata nanácueji náa'a espíritu máashii, máaquenai lécchoo sáica. ");
INSERT INTO aca_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Chacábacanaa quinínama Chóniwenai wówenai nadúnu Jesús nácu, níwata lichúnicala nayá quinínama liyú liá'a Dios wítee jiáirricoo linácucha. ");
INSERT INTO aca_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Jesús cába'ee lishínaa náa'a éewidenaicoo liájcha, ya limá'ee nalí: “Sáicta iwówa iyá carrúni jináatanica, níwata liá'a Dios wánacaalactalaca ishínaa. ");
INSERT INTO aca_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Sáicta iwówa iyá chóque'e ínaaishinirru, jiníwata imáacaminaujoo cáawai. Sáicta iwówa chóque'e iyá íchenaica, jiníwata liáwinaamiminaa icáidaminaajoo. ");
INSERT INTO aca_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Sáicta iwówa iyá jáicta máashii chóniwenai cába iyái, jáicta nawáana yáacuwai, jáicta máashii nanúma irrúi ya jáicta nacháani iyái jicá'a náa'a máashiinica, nunácueji nuyá Washiálicuerri Dios Cúuleeca, ");
INSERT INTO aca_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Sáicta wérri iméda iwówau, cashiámu iméda iwówau liyú liá'a sáicai liyáali éerri, níwata iyá ríshibianai'inaa máanui wérri sáicai áacairra; cháwa cábacanaa náiinueda náa'a nawérrinaibimi chóniwenai náa'a íiwadedeenaimi Dios chuáni báinacu nabéecha. ");
INSERT INTO aca_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Ne, ¡ái éenaa já'a carrúni jináata'inaa iyá rícubinica, jáni nísa sáicta iméda iwówawai! ");
INSERT INTO aca_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“¡Ái éenaa já'a carrúni jináata iyá chóque'e nísenai cáawaica, ne liáwinaami'inaa ínaaishi irrújoo! “¡Ái éenaa já'a carrúni jináata'inaa iyá chóque'e cáidenaica, ne liáwinaami'inaa ícha irrúwoo máashii'inaa iméda iwówau! ");
INSERT INTO aca_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“¡Ái éenaa já'a carrúni jináata'inaa iyá quinínama cáinabi ítesana náa irrú sáicai, ne cháwa cábacanaa nabésunacoo náajcha náa'a chóniwenai ibéecha sánaca, náajcha náa'a íiwadedenai Dios chuáni jócai yáawaiyi! ");
INSERT INTO aca_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ne iyá éemenai nulí numá irrú: Caníinaa icába ijínaiu, iméda nalí sáicai náa'a máashiini cába iyá. ");
INSERT INTO aca_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Yáa nalí sáicai náa'a mándisieni iyá, i'óra nanácu náa'a máashiini numá inácucha. ");
INSERT INTO aca_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Áiwee báseerri jiwídani já'a, jináawida lirrú béema; ne áiwee éederri jisácuni já'a, jimáaca lécchoo litée jicámisani. ");
INSERT INTO aca_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Ne matuínaami tánashia nasátani jiúcha, jiá lirrúni, ne léedacta jishínaa, ujisáta liúchani. ");
INSERT INTO aca_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Iméda náajcha náa'a chóniwenaica, chaléjta iwówa naméda yáajcha náa'a áabica. ");
INSERT INTO aca_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Ne iyá caníinacta icába iyá jájiu liá'a caníinai cába iyá, ¿tána iwáalia mawí sáicacai? Áawita náa'a cajíconaanica caníinaa nacába yáacacoo. ");
INSERT INTO aca_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ne imédacta nalí sáicai náa'a médenai irrú sáicai iyá jájiu, ¿tána iwáalia mawí sáicacai? Áawita náa'a cajíconaanica naméda sáicai nalí wáacoo. ");
INSERT INTO aca_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ne ipréstacta nalí bácai náa'a ipénsani éejueda irrú lijúnta náa'a sái, ¿tána íyada néenii iwíteecoowai? Lécchoo náa'a cajíconaanica préstenai nashínaa wáacoo bácainaa napénsaa narríshibia lijúnta sái náucha wáacoo. ");
INSERT INTO aca_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Iyá éewenai caníinaa icába ijínaiu, ya iméda nalí sáicai, ya éewa iprésta ishínau jiní inéndacala néejueda irrú lijúntanaa sái. Cháminaa máanui ishínaa sáicabee ya iyáminaa léenibi liá'a Dios áacai sáica, liá'a lécchoo sáicaica náajcha náa'a chóniwenai cháaninica, ya náa'a máashiinica. ");
INSERT INTO aca_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Arrúnaa iyá carrúni jináata icába áabi, léjta carrúni jináata isálijinaa Dios cába iyá. ");
INSERT INTO aca_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Ojiúca áabi máashiquictala, jócubeecha Dios yúca jiyá máashiquictala lécchoo. Jócu jiá áabi jíconaa, ya Dios jócuminaa liá ijíconaa lécchoo. Jimíya máecha áabi jíconaa, ya Dios pérdonaaminaa iyá. ");
INSERT INTO aca_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Yáa áabirru, ya Dios liáminaa irrú lécchoo. Liáminaa ishínaa cháacala rícu áabai léenedayu'inaa sáicai wérri, libádadani, licúsudani ya cashiámunaa. Dios éenedaminaa iyá lécchoo léjta cábacanaa éenedau'u áabibi.” ");
INSERT INTO aca_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesús máaca nalí liéni licábacanaa: “¿Léewaminau báqueerri matuíyii lijíneda báqueerri matuíyii wítabii? ¿Jócuminaa nacáu chámatanaa útawi rícula? ");
INSERT INTO aca_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Jiní báqueerri éewiderricoo mawíyii lishínaa quéewidacai yúchau; jáicta limárda lishínaa estúdiowai líinuminaa limédacoo léjta lishínaa quéewidacai. ");
INSERT INTO aca_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“¿Tánda jicába jéenajirri tuí rícu catábibee, ne jócu jicába liá'a áicuba dánumimi yáairri jituí rícu? ");
INSERT INTO aca_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ne jócta jiá léenaa jiwáalia'u áicuba dánumimi chúnsai jituí rícu, ¿chíta jéenau'u jimá jéenajirrirru jíni: ‘Nuéenajirri, jínda nujéda'aa jituí rícucha liérra catábibeeca’? ¡Chámai wítee! Jijédau quéechanacu liérra áicuba dánumimi yáairri jituí rícu, táminaa cha jéewa jicába sáica quéewique'e jéewa jijéda jéenajirri tuí rícucha catábibee. ");
INSERT INTO aca_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Jiní banácali sáicai éewa liá lítau máashii, jiní banácali máashii éewa liá lítau sáica. ");
INSERT INTO aca_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Quinínama banácali wáa léenaa wacába líta nácuejiu: Jócu wéewa wawína ítashi sáicai áabai túwirri náanai ítacha, jiní wéewaca wawína uva catícali ítacha. ");
INSERT INTO aca_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Liá'a washiálicuerri sáicaica, táanierri chuánshi sáicai, níwata sáicacala liá'a yáairri liwówa lícu, liá'a washiálicuerri máashiica, táanierri chuánshii cacháninai, jiníwata máashii liá'a yáairri liwówa lícu. Ne tándawa liá'a cashiámui ya liwówa lícu, léewa linúma táaniani liérra. ");
INSERT INTO aca_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“¿Tánda imá nulí, ‘nuwácali, nuwácali’, ne jócani méda léjta numáyu'u irrú? ");
INSERT INTO aca_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Nuíiwa'ee irrú liá'a chái cábacanaa íinuerri nulí léemi nuchuáni ya limédani liá'a numáni lirrú: ");
INSERT INTO aca_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","chái cábacanaa léjta báqueerri washiálicuerri, jáicta libárrueda líibanawai, quéechanacu liméda dujíwala útawi, ya ta limáaca lidánani íiba íta'aa. Quéecha'inaami manútaa méedai, unésaca íinu linácula liá'a cuítaca, ne jócu léenaa lichúndaqui jíni, níwata bárruerriu sáica íiba íta'aa. ");
INSERT INTO aca_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ne liá'a éemerri nuchuáni, ya jócu liméda liá'a numáni lirrú, chái cábacanaa léjta báqueerri washiálicuerri bárruedeerri líibanau cáina íta'aa, jáiwa jócu liá'a lidánani dujíwalai; quéecha'inaami manútaa méedai unésaca íinu lítala liá'a cuítamica, jáiwa licáuwai limáacacoo licáarraliacoo.” ");
INSERT INTO aca_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesús nísa'inaami litáania náajcha náa'a chóniwenaica, jáiwa liáwai Capernaúm néerra. ");
INSERT INTO aca_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Néeni báqueerri yáa Roma sái nawácali náa'a soldádoca, wáalierri báqueerri shírruederri lirrú caníinai wérri licábaca, bálinerriuminaatanaa atéwacta máanalicani. ");
INSERT INTO aca_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Quéecha'inaami romanobini wácali éemi natáania Jesús nácu, libánua áabi salínai judíobini shínaaca, quéewique'e nasáta liúcha liácoo lichúni liá'a shírruederri lirrú liá'a romano wácalica. ");
INSERT INTO aca_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Jáiwa náiinu Jesús yáctalai nasáta liúcha cáiwinaa namá'ee lirrú: —Liéni wawácalica sáicanatai jiyúdaca, ");
INSERT INTO aca_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","jiníwata caníinai licába washínaa chóniwenai quinínama, ya liwána naméda walí washínaa sinagoga. ");
INSERT INTO aca_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Jesús yáau náajchai, ne quéecha'inaami urrúni líinu cuítarrui, liá'a nawácalica libánua áabi lijúninaiu namá lirrú: “Nuwácali, chaijiwítemija, jiníwata nuyá jócai sáicanata jiwárruacoo núbana rícula; ");
INSERT INTO aca_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","tándawa, jócu nuáu nuyá jájiu numúrru jiyá. Bácai rími jiá wánacaleerri chuánshi quéewique'e jichúni shírruederri nulí. ");
INSERT INTO aca_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Jiníwata nuyá jájiu yáairri nuwánacaala nácu lécchoo, liyáalimi lécchoo nuwáalia náa'a soldado nuwánacaalaninica. Jáicta numá néenaa báqueerrirrui jiáyu, arrúnaa liácoo; jáicta numá báqueerrirrui jíinuu, arrúnaa líinuca; ya jáicta nubánua nushínaa shírruederri nulí liméda nuwánacaala, jái liméda jíni.” ");
INSERT INTO aca_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Jesús cáarrudau léemi jiliéni, licábadeda nalí náa'a chóniwenai yáaineu líshiirricu, limá'ee nalí: —Ne yáawaiyi numá irrú, jiníwita Israel rícu nuíinuni nácu éebiderri wérri léjta liáni washiálicuerrica. ");
INSERT INTO aca_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Quéecha'inaami néejoocoo cuíta néerra, náa'a libánuanimica náiinu linácu liá'a cashírruedacaica, jái sáicacai. ");
INSERT INTO aca_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Liáwinaami Jesús yáau áabai chacáaleerra jí'ineerri Naín, náajcha náa'a lishínaa éewidenaicoo ya íchaba chóniwenai liájcha mawí. ");
INSERT INTO aca_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Líinu'inaa urrúni chacáalee numá lícula, licába náinda náacoo báqueerri máanalii naquénique'inini. Liyámi'e bácairrimi rucúuleeca ruá'a máanaliu íinirrimi, ya íchaba chóniwenai chacáalee rícu sána yáaineu ruájcha. ");
INSERT INTO aca_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesús cába'inaa ruyái, néenee carrúni jináata licába ruyái limá rulí: —Ujícha. ");
INSERT INTO aca_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Néenee Jesús rúniu lidúnu cajón nácu, néenee nabárruawai náa'a índenai náacoo liá'a máanalica. Néenee limá lirrú liá'a máanalica: —Icúlirrijui, numá jirrú: ¡jibárroo! ");
INSERT INTO aca_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Néenee libárrueda liá'a máanalimica ya ta litáaniaca, néenee Jesús éejueda litúwarru jíni. ");
INSERT INTO aca_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Nacába'inaa liáni, cáarru quinínama náa'a chóniwenaica náa Diosru sáicai namá'ee: —Báqueerri cawénii cáiiwadedacani Dios chuáni jiárriu wáiibi. Namá'ee lécchoo: —Dios íinuerri liyúda lishínaa chóniwenaiu. ");
INSERT INTO aca_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Néenee náiiwadeda liá'a namáni Jesús nácucha quinínama lirrícu liá'a Judeaca rícu lécchoo liá'a cáinabi yéerri Judea téeji. ");
INSERT INTO aca_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Juan éemi quinínama liá'a Jesús médanica, náiiwacala lirrúnini náa'a máinecoo liájcha. Limáida chámata néenaa, ");
INSERT INTO aca_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","jáiwa libánua Jesús néerra jíni, nasátaque'e néemiuni liyácta yáawaa liá'a nanéendani nayáca, o wanéendawee báqueerri. ");
INSERT INTO aca_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Náa'a Juan bánuanica narrúni'eewoo Jesúsru namá'ee lirrú: —Juan liá'a Bautístaca libánua wayá wasátaque'e wéemiu, jiyácta liá'a wanéendani wayáca o arrúnaawee wanéenda báqueerri. ");
INSERT INTO aca_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Liyáalimi nanáneewa Jesús chúni íchaba chóniwenai bálinenaicoo ya liá'a máashii yáairri nanácu, ya náa'a wáalianai espíritu máashii, jáiwa liwána íchaba matuíni cábaca. ");
INSERT INTO aca_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Néenee léeba nachuánii: —yáayu Juan néerra íiwa lirrú liá'a icábanica ya liá'a éeminica. Íiwadeda lirrú náa'a matuínica éewenai nacábaca, náa'a macáwanica éewenai najínacoo, náa'a cacháunanica méetuerriu náucha liá'a nabálinacaalaca, náa'a mawíbanica éewenai néemica, náa'a máanalinimica éejueneu nacáwiacoo, ya nalí náa'a carrúni jináatanica náiiwa liá'a chuánshi wásedeerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Sáicta liwówa liá'a chóniwerri éebiderri nunácu mamáarraca, jócai náawida liwíteu núcha. ");
INSERT INTO aca_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Quéecha'inaami náacoo náji náa'a Juan bánuanimica, Jesús chánau litáania chóniwenairru Juan nácu, limá'ee nalí: “¿Tána ijiáu icábacai iyá chaléeni jiníctala yáairri? ¿Áabai basué cáuli cúsudani? ");
INSERT INTO aca_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Ne jócta, ¿tána ijiáu icábacai? ¿Báqueerri washiálicuerri cawéni namái íibala? Iyá yáine léenaa náa'a súwedenai íibalashi cáwena namái yáainei nawíteeyu, yáainai nábana rícu náa'a wánacaleenaica. ");
INSERT INTO aca_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ne cháctani, ¿tána ijiáu icábacai? ¿Báqueerri íiwadedeerri Dios chuáni? Jajá, yáawaiyii, ne báqueerri ta mawíyii máanui liúcha liá'a íiwadedeerri Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Juan liá'a litáanianimi nácu liá'a cáashtaca: ‘Nubánua catéecai nuchuáni jibéecha, quéewique'e lichúni jibéecha iníjbaa.’ ");
INSERT INTO aca_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Ne yáawaiyi numá irrú, náiibicha quinínama náa'a washiálicuenaica, jiní máanui Juan yúcha mawí; ne áawita liá'a mawí píitui Dios wánacaalactalaca mawíyii máanui liúcha.” ");
INSERT INTO aca_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Quinínama náa'a éemenai Juan chuáni, áawita náa'a cacóbracani impuesto Romarru, wánenai Juan báutisa nayá, néebidacala yáawaa Dios machácanii; ");
INSERT INTO aca_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ne náa'a fariséoca ya náa'a quéewidacanica ley shínaaca, jócani índa Juan báutisa nayá, nacháani quinínama liéni Dios wóweni liméda nawícaubali. ");
INSERT INTO aca_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","“¿Chíta nacábacanaa náa'a chóniwenai chóque'e sánaca? ¿Chíta nacábacanaa jíni? ");
INSERT INTO aca_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Cháni cábacanaa léjta náa'a sáamanaica wáainecoo naséwicaca plaza rícu ya ta namáidada najúnicairruwai: ‘Wáiinuate irrú butútu, ne iyá jócani báaweda; warrábate shímashi cáiwii wítama, ne iyá jócani ícha.’ ");
INSERT INTO aca_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Áawita Juan Bautista íinuca, jócai íya páani jiní líirraca vino, ne iyá máinai jáica liwáalia áabai demonio. ");
INSERT INTO aca_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Néenee liáwinaami nuíinu nuyá Washiálicuerri Dios Cúuleeca, íyeerrica ya nuíirra, ne iyá máinai jáica yawíqui jíni ya cáirracalai, najúnicai náa'a chóniwenai máashiini íiwanaa ya náa'a cacóbracani impuesto Romarru. ");
INSERT INTO aca_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Ne Dios íyada quinínama liwíteu linácueji liá'a limédanica.” ");
INSERT INTO aca_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Báqueerri fariseo cúmida Jesús íya liájcha, jáiwa Jesús yáau líibana néerrai. Liwáau liyá mesa nácula, ");
INSERT INTO aca_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","jáiwa báquetoo íinetoo máashiu íiwanaa yáichoo lirrícu léja liá'a chacáaleeca, jáiwa ruá léenaa Jesús yáacoo líiya líibana néerra liá'a fariséoca, ruíinda áabai frasco jí'ineerri alabastro cashiámu juménibee. ");
INSERT INTO aca_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Ruchánau ruíchaca Jesús íiba néeni, rusábida rutuí yáabiyu. Jáiwa rumácarra ruwíta báinayu, ya ta rushíshi líibai, jáiwa runuádeda juménibee linácui. ");
INSERT INTO aca_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Liá'a fariseo cúmideerri Jesús, licába'inaamini liéni limá'ee lirrúwoo: “Liéni washiálicuerrica yáawaictata báqueerri cáiiwadedacai Dios chuáni, liá'aca ta léenaa tánashia chóniwetooca róji ruárra dúnuechoo ruyá linácu: báquetoo íinetoo máashiu íiwanaa.” ");
INSERT INTO aca_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Néenee Jesús ma lirrú liá'a fariséoca: —Simón, nuwáalia áabai chuánshi nuíiwani'inaa jirrú. Léeba'ee liá'a fariséoca: —Jíiwate nulíni, quéewidacai. ");
INSERT INTO aca_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Néenee Jesús má'ee lirrú: —Chámata washiálicuenai mówiniate warrúwa báqueerri capréstacai warrúwa. Báqueerri mówiniate léjta liwéni liéni quinientos éerrictaca, ya liá'a báqueerrica cincuenta éerrictaca; ");
INSERT INTO aca_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ne jócala néenaa napáida lirrúni, liá'a capréstacai nalíni, jáiwa jócu liwána néejueda lirrúi liérrumirrai náa'a chámataca jíni. Ya ta jíiwa nulí jíni, ¿tána néenaa caníinaa licába mawí? ");
INSERT INTO aca_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Simón éeba'ee lichuáni: —Nulí tá'ee liá'a washiálicuerri mawíyii mówiniaca. Jesús má'ee lirrú: —Yáawaiyi jimácaa. ");
INSERT INTO aca_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Néenee licába rulí ruá'a íinetooca, Jesús má'ee Simónru: —¿Jicába róji ruáni íinetooca? Nuwárroo jíibana rícula, ne jócu jiá nulí shiátai nubádeda'inaa nuíibau; ne ta rója ruáni íinetooca bádedeechoo nuíiba rutuí yáawiyu, ya ta rumácarra ruwíta báinayu jíni. ");
INSERT INTO aca_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Jócai shíshi nuyá, ne ruyá rícue ruwárruacuwai jócau máaca rushíshi nuíiba. ");
INSERT INTO aca_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Jóca jíinu nuwíta nácu aceite, ne ruyá nuádedeechoo juménibee nuíiba nácu. ");
INSERT INTO aca_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Tándawa numá jirrú íchaba wérri rujíconaa méetuerriu, níwata bájialaca caníinaa rucábaca; ne liá'a chóniwerri píitui mówiniaca, píitui líyada caníinau'u licá'aca. ");
INSERT INTO aca_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Néenee Jesús má'ee rulí ruá'a íinetooca: —Jijíconaa jái méetuacuwai. ");
INSERT INTO aca_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Náa'a áabi yáainai nayá néeni, nachánau nasáta néemiu nayá jájiu: —¿Tána léji liéni éeneerri liméetua jíconaashi? ");
INSERT INTO aca_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Ne Jesús má'ee mawí, rulí ruá'a íinetooca: —Jéebidacala jiyá'au jíconaa méetuacuwai; jiáu chaiwíteemija'a. ");
INSERT INTO aca_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Liáwinaami liéni, Jesús jínaniu íchaba chacáalee rícu ya náa'a júbininica, lichánau léewidaca ya líiwadeda Dios wánacaalactaca. Náa'a doce apóstolu natálideda liyá. ");
INSERT INTO aca_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Ya lécchoo áabi íina tálideda liyá, náa'a liwásedani espíritu máashii yúcha ya áabata bálinacaalashi; náiibicha lécchoo ruáu ruá'a María jí'ineechoo Magdalena, siete demonio jiánimicoo yúcha; ");
INSERT INTO aca_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","lécchoo Juanaca, líinu liá'a Cúzaca, liá'a wánacaleerrimi Heródesru; ya Susana, ya áabi íchaba mawí náa'a yúdenaimi nayá liyú liá'a nawáalianica. ");
INSERT INTO aca_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Íchaba jiáu chacáalee rícucha quéewique'e nacába Jesús, jáiwa náawacawai íchaba chóniwenai. Néenee líiwa nalí liéni áabai licábacanaa: ");
INSERT INTO aca_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Báqueerri cáabanacai jiáu licása líimi liá'a liáabanani'inaaca. Licása'inaamini, áabata líimi cáu iníjbaa lícu, jáiwa nabáweda jíni ya ta míshiidu íyaqui jíni. ");
INSERT INTO aca_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Áabata léenaa cáu íiba íibi; ne quéecha'inaami lipáquiacoo, jáiwa máacarra jíni cháuctacala lirrú shiátai. ");
INSERT INTO aca_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Áabata léenaa liá'a líimica cáu túwirri íibirra; ne quéecha'inaami lipáquiacuwai túwirri yáajcha, jáiwa lisácumeda jíni. ");
INSERT INTO aca_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ne áabata cáu sáicai cáinabi íta'aa; jáiwa lidáwinawai, liá lítau manuába, cáashia liá cien líimiu líta nácuu.” Léewa Jesús máni liéni, jáiwa limá mawí cadánani: “¡Náa'a wáalianai nawíbau, néemique'e!” ");
INSERT INTO aca_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Néenee lishínaa éewidenaicoo sáta néemiuni, chítashia liwówau'u limá léji liá'a licábacanaa. ");
INSERT INTO aca_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Jesús má'ee nalí: “Iyá Dios íyadani irrú liá'a báyeerricoo liwánacaalactalaca; ne áabimi nutáanianirru licábacanaayu; ya áawita nacábaca jócai néenaa nacába sáica, ya áawita néemica jócai néenaa náa léenaa. ");
INSERT INTO aca_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Léewa liwówau'u limá liéni licábacanaa: Liá'a banácali íimica wówerri limáca léewa Dios chuáni liérra; ");
INSERT INTO aca_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ne liá'a áabata líimi liá'a banácalica cáirricoo iníjbaa lícu, wówerri limáca náa'a éemenai Dios chuáni, ne Wawásimi íinu, jáiwa lijéda Dios chuáni nawówa rícucha, jócubeecha néebida ya jócu néewa nawárruacoo Dios yáctalaca. ");
INSERT INTO aca_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Liá'a líimi cáirricoo íiba íibi wówerri limáca, náa'a éemenai Dios chuáni narríshibia nawówa yáajcha wáni, ne jócani wáalia sáica najíchu; néebida áabata éerri rími, ne jáicta carrúnatai íinu náatalai jái namáaca Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Liá'a líimi cáirricoo túwirri íibirra, wówerri limáca, náa'a éemenai Dios chuáni, ne arrájuatayu náinda lisácumacoo nawówa lícu Dios chuánica nafánacalau éerri shínanaa nácu, namúrru warrúwa ya sáicta nacába liá'a éerri íyadanica, chacábacanaa jócu néewa náa'a naméda sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ne liá'a líimi cáirricoo sáicai cáinabi íibirra, náwa chóniwenai méecuenai nawówau sáica máaqueneu nayáu néemi Dios chuáni namédaque'e léjta liwówau'u, ya ta nayá machácanii náayada nayáu léjta banácali yáairri lítau sáica. ");
INSERT INTO aca_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Jiní túculeerri áabai lámpara ya ta libáyaqui jíni o limáaca cama yáajbalani, litúculiactani limáacani áacai, quéewique'e nawáalia jucámarrabee náa'a wárruenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Ne cháwa cábacanaa, jiní báyeerriu néenaani'inaa náa léenaa, jiní liá'a cabáyaintaica éeneerri'inaa náa léenaa ya limáacacoo jucámarranaa. ");
INSERT INTO aca_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Cháwa jáni, éemiu sáica, liá'a éemerri sáica, yáirri'inaa léenaa mawí, ne liá'a jócai éemi sáica, áawita liyá liá léenaa mawí, liyá pérderri'inaa liá'a píitui rími liáni léenaa nácu.” ");
INSERT INTO aca_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesús túwa ya léenajinai náiinu liyáctalaca, ne jócu néenaa narrúnicoo lirrú, íchabaca wérri chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Áabi náiibicha íiwa Jesúsruni: —Jitúwa ya jéenajinai náa'a yáa bináawa, wówenai nacába jiyá. ");
INSERT INTO aca_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Jesús éeba'ee: —Náa'a éemenai Dios chuáni, ya naméda liwánacaala, náwa nutúwa ya nuéenajinai nárra. ");
INSERT INTO aca_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Áabai éerri, Jesús yúrrucoo áabai lancha rícula lishínaa éewidenaicoo yáajchau, limá'ee nalí: —Wáau bajiála manuá. Jáiwa náawai. ");
INSERT INTO aca_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Nácula nachuáu manuá íiwalirricu, Jesús máairri. Liyáalimi áabai cáuli wérri íinu manuá yáacoo, jáiwa'ee liá'a lanchaca lichána cashiámu shiátaiyu, ya atéwacta natámucoo. ");
INSERT INTO aca_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Néenee náau nacáweda Jesús namá'ee lirrú: —¡Quéewidacai! ¡quéewidacai! ¡Watámucoo wayácai! Jesús bárrua'inaamiu litáania cáulirru ya marrádacarru, jáiwa machúnucunaa limáacacoo quinínama chawítemija'a. ");
INSERT INTO aca_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Néenee limá lishínaa éewidenaicoo liájcha: —¿Ta liáu éebidaumi jíni? Ne nayá, cárdaneeneu nacábadedanica, nasátada'ee néemiu nayá wáacoo: —¿Tánashia léji liéni, táanierri cáulirru ya shiátairru ya léewida lichuáni? ");
INSERT INTO aca_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Déecu'inaami wáali náiinu licáinaberra ítala liá'a Gerasaca, yáairri bajiála manuá, lijúntami liá'a Galileaca. ");
INSERT INTO aca_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Jesús yúrrucue'inaamiu lancha rícucha cáinabi ítala, báqueerri washiálicuerri jiáu chacáalee rícucha, wáalierri demonio, jáiwa lirrúniwai Jesúsru. Íchaba wérri éerri jócai súwa líibalau jiní liyácala cuíta lícu, níwata yáairri útawi rícuba máanalini yáarruica. ");
INSERT INTO aca_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Quéecha'inaami licába Jesús, licáu liúrruimiyu Jesús náneewa, limáidada'ee: —¡Ujníquiu nuájcha, Jesús Dios Cúulee áacai sáica! ¡Nusátani wérri jiúcha jócubeecha jiwána nusúfria bájiala! ");
INSERT INTO aca_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Limá liáni jiníwata Jesús wáneerri lijiácoo liá'a espíritu máashiica liúcha. Íchabachu liá'a demonioca wáarroo lirrú; áawita chóniwenai bájida liná ya líiba cadénayu quéewique'e nawínacani, liyá léenaani lisúbirriaca, ya liá'a demonio wána licánacacoo liácoo jiníctala yáairri. ");
INSERT INTO aca_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Jesús sáta'ee léemiu wáni: —¿Tána jijí'inaa? Liyá'ee léeba'ee: —Nují'inaa legión. Limá liáni jiníwata íchaba wérri demonio cha wáarruacoo lirrú. ");
INSERT INTO aca_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Náa'a demonio nasáta Jesús yúcha jócubeecha libánua nayá liwítabami rícula chaléeni cástigu yáctala'inaa nalí. ");
INSERT INTO aca_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ne néeni íchaba puíti íyenai namáacoo dúuli nácu, náa'a espíritu nasáta Jesús yúcha líndaque'e nawáarruacoo puítirru; jáiwa Jesús índa nawárruacoo nalí. ");
INSERT INTO aca_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Néenee najiáu náa'a demonioca liúcha liá'a washiálicuerrica, jáiwa nawáarroo puítirrui, najiáu nacánacau najúsunacoo cáinacula shiátai yáacula, jáiwa néeni nasácumacuwai. ");
INSERT INTO aca_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Náa'a túyenai nayá puíti, quéecha'inaami nacába liá'a bésuneerricoo, najiáu nacánacacoo, jáiwa náau náiiwadeda chacáalee rícula jíni ya litéejibaa. ");
INSERT INTO aca_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Náa'a chóniwenai najiáu nacábaca liá'a bésuneerricoo. Ne quéecha'inaami náiinu Jesús yáctalaca, náiinu linácu liá'a wáalierrimi demonio, wáairriu liyáca Jesús íiba néeni, jái cáabalacai, jócai mawítee mawiá, jáiwa cáarru nayái. ");
INSERT INTO aca_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Náa'a cábenai liá'a bésuneerricoo, náiiwadeda chítashia liwásedau'u jiníni liá'a wáalierrimi demonio. ");
INSERT INTO aca_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Quinínama náa'a chóniwenai yáainai Gerasa cáinaberra íta'aa, nachánau nasáta Jesús yúcha quéewique'e liácoo nacáinaberra ítacha, níwata bájialaca cáarru nayá. Jócala nacába cáji liá'a bésuneerricoo. Jáiwa Jesús yúrrucoo lancha rículai, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Liá'a washiálicuerri demonio jiánicoo yúcha, lisáta Jesús yúcha quéewiquini'e liácoo liájcha, ne Jesús wána'ee limáacacoo limá'ee lirrú: ");
INSERT INTO aca_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","—Jéejoo jíibana néerrau ya jíiwadeda quinínama liá'a Dios médani jirrú. Liá'a washiálicuerrica, jáiwa liáwai ya líiwadeda quinínama chacáalee rícu liá'a Jesús médani liájcha. ");
INSERT INTO aca_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Quéecha'inaami Jesús éejuacuwai báaniu bajiála manuá, náa'a chóniwenai sáicta nawówa níwata nanéndacala nayácani. ");
INSERT INTO aca_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Liyáalimi báqueerri íinu jí'ineerri Jairo, liwácali liá'a sinagogaca. Liéni washiálicuerrica litúyau Jesús íiba néeni, lisáta liúcha liáque'iu líibana néerra, ");
INSERT INTO aca_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","níwata liwáaliacala bácau rími limíyacalau, wáaliachoo doce camuí, wówechoo máanali ruyáca. Nácula Jesús yáau, lisíntia nabádeda liyá náa'a chóniwenai íchabanica yáaineu líshiirricu. ");
INSERT INTO aca_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Náiibicha náa'a chóniwenaica báquetoo íinetoo rícuete doce camuí ruwáalia bálinacaalashi íirrai éechani, ya rugástaa quinínama ruwáalianica nanácula náa'a médicoca, ne jiní éeneerri lichúni ruyá. ");
INSERT INTO aca_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ruáni íinetooca rurrúniu Jesúsru liwójuna itéeji, jáiwa rudúnu líibala númacua, liyáalimi libárruau rúcha liá'a íirrai éechau'u ruyá. ");
INSERT INTO aca_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Néenee Jesús sáta léemiu: —¿Tána dúnu nunácui? Ne quinínama nabáyaca liúchani, nadúnu, Pedro má'ee: —Quéewidacai, náa'a chóniwenaica nabádeda jiyá, ya nadáanaida jiyá matuínaami. ");
INSERT INTO aca_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ne Jesús má'ee mamáarraca: —Ái dúnuerri nunácu já'a, nuáca léenaa nunácucha jiérriu liá'a cadánani wíteeshica. ");
INSERT INTO aca_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ruá'a íinetooca ruá'inaa léenaa jócu ruéenaa rubáyaqui jíni, jáiwa ruchéchinau ruácoo rutúyacoo Jesús íiba néeni. Ruíiwa quinínama náneewani tánashia rudúnu jíni, chítashia sáicau ruchúnicoo liyáalimi jíni. ");
INSERT INTO aca_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Jesús má'ee rulí: —Numíyacaula, jéebidacala Dios nácu sáica jiyái, jiá namówai chaijiwítemija'a. ");
INSERT INTO aca_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesús táaniacta liyá újnibi, báqueerri íinu índeerri chuánshi limá'ee lirrú liá'a sinagoga wácalica: —Jimíyacaula máanaliuyii; ujijódia mawiá liérra quéewidacaica. ");
INSERT INTO aca_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Ne Jesús éemi'inaamini limá'ee: —Ucáarru jiyá, bácai rími jéebida Dios nácu, ya jimíyacaula sáicaminaa ruyájoo. ");
INSERT INTO aca_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Quéecha'inaami náiinu cuíta néerra, jiní líndani wárruacoo liájcha bácai rímii Pé'eru ya Santiago ya Juan ya rusálijinaa ya rutúwa ruá'a samáshtaca. ");
INSERT INTO aca_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Quinínama íchenai nayáca ya cáiwi wérri nacábacoo runácueji ruá'a samáshtaca, ne Jesús má'ee nalí: —U'ícha, ruárra samáshta jócauwa máanali ruárra, máichoo ruyá cháji'i. ");
INSERT INTO aca_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Quinínama nacáida'ee Jesús, níwata náa'aca'ee léenaa máanali ruyá. ");
INSERT INTO aca_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Néenee Jesús wína rucáaji nácui, limá'ee danáanshiyu: —¡Miyácau, jibárruau! ");
INSERT INTO aca_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Jáiwa rucáwica éejoo rulí; liyáalimi rubárruawai, néenee Jesús bánua náa rúyai. ");
INSERT INTO aca_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Rusálijinaa ya rutúwa nacáarrudau nacábacani; ne Jesús wána'ee jiníbeecha náiiwadedanirruni liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Liáwinaami, Jesús yáawacaida náa'a lishínaa doce éewidenaicoo liá nalí néewaque'e najéda quinínama demonio ya nachúnique'e bálinacaalashi. ");
INSERT INTO aca_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Libánua náiiwadeda chítashia Dios wówau'u liwánacaala cáinabi íta'aa jíni, ya nachúni náa'a bálineneecoo. ");
INSERT INTO aca_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Limá'ee nalí: —Jiní itéeni iníjbaa lícujoo, jiní áicuba icháqui'inaa, jiní chácala, jiní íyacaishi, jiní warrúwa, itée áabai rími íibalashi, jiní mawiá. ");
INSERT INTO aca_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Tánashia cuíta íinuni nácu, iyá néenijoo cáashia ijiácoo néenee. ");
INSERT INTO aca_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ne tánashia chacáalee jócai wówai narríshibia iyá, ijiáu lirrícucha liérra chacáaleeca ya itútuda liá'a pucúpucubee yéerri íiba nácu, quéewique'e náa léenaa jáicala jócu sáica nayá náa'a chóniwenaica jóca narríshibia iyá. ");
INSERT INTO aca_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Néenee najiáu nawárruanicoo narrícula náa'a chacáaleeca quinínama, náiiwa liá'a Dios chuánica nachúni chóniwenai lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Liá'a rey Herodes éemi natáania Jesús nácu quinínama liá'a limédanica, ne jócai éenajta éebidaca, áabi mácala Juancala éejoo licáwiacoo, ");
INSERT INTO aca_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","áabi ma jáicala'ee liá'a cáiiwadedacaimi Dios chuáni báinacu Elíasca cha íyadacuwai, ya áabi ma jáicala'ee cáiiwadedacaimi Dios chuáni báinacu wérri cha éejoocoo licáwiacoo. ");
INSERT INTO aca_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ne Herodes má'ee: —Nuyá jájiu nuwána nawíchua Juan wíta liwáa númami. ¿Tánashia léji liérra, cha nuéemi náiiwadeda íiwanaa bájiala? Tándawa'ee Herodes wówerri licába Jesús. ");
INSERT INTO aca_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Quéecha'inaa'ee néejuacoo Jesúsru náa'a éewidenaicoo, náiiwadeda'ee lirrú liá'a namédanica. Néenee'e litée'e nayái náa'eewoowai báawachala chaléeni urrúni lirrú liá'a chacáaleeca jí'ineerri Betsaida. ");
INSERT INTO aca_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Quéecha'inaa'ee chóniwenai yáa léenaa jíni, náa'eewoo líshiirricu, jáiwa Jesús lirríshibia nayái, litáania nalí chítashia Dios wówau'u liwánacaala nayá jíni ya lichúni náa'a bálinenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Quéecha'inaa táicala liácuwai, narrúni'e náacoo Jesúsru náa'a doce éewidenaicoo liájcha namá'ee lirrú: —Jiwána chóniwenai yáacuwai, náaque'iniu nawówa íyabacoo ya namúrruque'e náayau chacáalee júbini rícu ya bacháida urrúnii nalí, níwata áani wayáctaca jinícta yáairri. ");
INSERT INTO aca_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Néenee'e Jesús ma nalí náa'a éewidenaicoo: —Yáa náaya iyá. Néenee namá'ee lirrú: —Wawáalia rími cinco páani ya chámacua cubái, yáshiawa wáacoo wawéni náaya'inaa náani quinínama chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Léjta'ee cinco mil washiálicuenai máanabaca. Ne Jesús má'ee nalí náa'a lishínaa éewidenaicoo: —Iwána nawáacoo cincuéntanaa namáanabaca. ");
INSERT INTO aca_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Chá'ee namédaqui jíni, jáiwa nawáau quinínamai. ");
INSERT INTO aca_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Néenee'e Jesús wína náa'a cinco páanica ya náa'a chámacua cubáica ya licába'ee áacairra, liá'ee Diosru sáicai linácueji liá'a íyacaishica. Linísa'inaami liá Diosru sáicai, lisúbirreda jíni, jáiwa liá nalí jíni náa'a lishínaa éewidenaicoo quéewique'e nachújida chóniwenai íyani. ");
INSERT INTO aca_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Náa'a chóniwenai náaya quinínamai cáashia cáawai nayá, ya néenaa náawaqueda doce canasta liá'a máacaderricoo léenaamica. ");
INSERT INTO aca_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Áabai éerri Jesús óractau liyá bácai ya lishínaa éewidenaicoo yáainai liájcha, lisáta'ee léemiu nayá: —¿Tána chóniwenai ma nunácuchai tánashia nuyái? ");
INSERT INTO aca_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Néeba'ee lichuáni: —Áabi máinei jiyáca'ee Juan Bautista, áabi máinei jiyáca'ee Elías, ya áabi máinei jiyáca'ee liá'a báqueerri íiwadedeerrimi Dios chuáni báinacu éejuerri'eewoo licáwiacoo. ");
INSERT INTO aca_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Ne Jesús éejoo'e lisáta léemiu nayá: —Ya iyá, ¿tána imácai tánashia nuyái? Jáiwa'ee Pé'eru éebai: —Jiyáwa liérra Mesías Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Ne Jesús má'ee nalí jiní béecha íiwerri liyácani liyáwa Mesías. ");
INSERT INTO aca_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Limá'ee nalí linácu cháu: —Nuyá Washiálicuerri Dios Cúuleeca, arrúnai'inaa nusúfria bájialanaa, ya nacháaniminaajoni náa'a salínaica, ya nawácanai náa'a sacerdótebinica, ya náa'a quéewidanica ley shínaabinica. Náiinuaminaajoni, ne matálii éerri rícula nucáwiaminaujoo. ");
INSERT INTO aca_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Néenee limá nalí quinínama: —Ne áicta wówerri já'a limédacoo nushínaa ewidenaicooyu, limíya máechau liyá jájiu liwánacaalacoo, ya línda Dios wánacaala licáwica nácu éerri jútainchu, liyá lichúni carrúni jináatau'inaa ya máanali liyá nunácueji. ");
INSERT INTO aca_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Jiníwata liá'a caníinai cába licáwicau líta'aa liéni éerrica, liúca licáwicau jócai amáarra, ne liá'a jócai caníinaa cába licáwicau lítacha liéni éerrica nunácueji, ligáanaminaa lirrúwoo liá'a cáwicashi jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","¿Tána lishírbia lirrú liá'a washiálicuerrica ligáanacta quinínama éerri rícu sái yáca, ya liúca lishínaa licáwicau ya licáarraliau liyá jájiu? ");
INSERT INTO aca_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ne tánashia báiyii nunácueji ya nuchuáni nácueji, nuyá lécchoo Washiálicuerri Dios Cúuleeca báiminaa nuíiwa lináawa lécchoo, jáicta nuíinujoo quinínama nucáamarra yáajchau, ya nusálijinaa cáamarra ya liwítee yáajchau, ya náa'a majíconaa ángelbini shírruedenai nulí. ");
INSERT INTO aca_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Ne yáawaiyii numá irrú áabi néenaa náani yáainai áani nunáneewa, jócuminaa máanali nayá cáashia nacába liá'a Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Liáwinaami ocho éerri néenee litáaniactami liyá nalí, Jesús íirrau áabai dúuli ítala li'óracoo, natálideda liyá Pé'eru, Santiago ya Juan. ");
INSERT INTO aca_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ne nácula li'óracta liyáca, lináni cábacanaa báwachau, ya líibala náawau cabálai ya úcuni lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jáiwa najiáu lirrúi chámata washiálicuenai natáania nayá liájcha. Náawa'ee Moisés ya Elías. ");
INSERT INTO aca_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Yáainai nayáca natéeji áabai cáamarrashi úcuni sáictai wérri, ya natáania linácu liá'a Jesús máanalicaica licúmpliani'inaaca Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Áawita Pé'eruca ya náa'a limánabacaca cadájuni wérri nayá, jáiwa cáwi nayácai, nacába Jesús cáamarra ya náa'a chámata washiálicuenai yáainai liájcha néeni. ");
INSERT INTO aca_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Qéecha'inaami náacoo náacuwai náa'a washiálicuenaica Jesús yúcha, limá'ee Pé'eruca Jesúsru: —Quéewidacai, ¡sáictai walí wayáca áani! Waméda'aa matálii cuíta rími: áabai jirrú, áabai Moisésru ya áabai Elíasru. Ne Pé'eru jócai yáa léenaa tánashia limácai. ");
INSERT INTO aca_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Nácula litáania liyáca, áabai sáanai yúrrucoo libáya nayái, nacába'inaami sáanai dájida nayái, jáiwa cáarru nayái. ");
INSERT INTO aca_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Néenee sáanai íbeeji lijiáu áabai chuánshi máirri'e: “Léewa Nucúulee, nuníwani, éemiu lirrú.” ");
INSERT INTO aca_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Linísa'inaa néemi liá'a chuánshica, Jesús máacau bácai. Jáiwa'ee náa'a éewidenaicoo jiní wérri náiiwadedacta liá'a nacábanimica liyáali éerri. ");
INSERT INTO aca_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Áabai éerri rícula cajójchanaami, náurrucoo'inaamiu dúuli ítacha, chóniwenai máanabanaami jiáu najúnteda Jesús. ");
INSERT INTO aca_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Ya báqueerri washiálicuerri máidada náiibicha limá'ee cadánani wérri: —Quéewidacai, jiméda nulí sáicai, jicábate nucúulee bácai rímii nuwáalianica. ");
INSERT INTO aca_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Áabai espíritu wínani, liwána limáidadaca ya liwána licúcunacoo ya cacálibee jiáu linúma licuéji, liwána líinuedacoo jócai liwówai limáacaca. ");
INSERT INTO aca_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Nusáta jishínaa éewidenaicoo yúcha, najédaque'e liúchani liérra espírituca, ne jócai néenaa najédaca. ");
INSERT INTO aca_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Jesús éeba'ee: —¡Wóo, chóniwenai jiníni éebidacta ya máashiicani! ¿Chacálita iwówai nuyá yáajcha mamáarraca jíni ya nuwánta yáajcha jiníni? Jínda liérra jicúuleecoo áani. ");
INSERT INTO aca_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Quéecha'inaami lirrúnicoo liá'a icúlirrijuica, liá'a demonio yúca cáinabi ricúla, liwána licúcunacoo báaniu; ne Jesús cáita liá'a espíritu máashiica, jáiwa lichúni léji liá'a icúlirrijuimica, ya ta léejueda lisálijinaarru jíni. ");
INSERT INTO aca_vpl VALUES ("LK9_43a","072_9_43a","LUK","9","43a","43a","Ya quinínama namáacau nacáarrudacoo nacába Dios wítee máanuica. ");
INSERT INTO aca_vpl VALUES ("LK9_43b","072_9_43b","LUK","9","43b","43b","Nacáarrudau nacábacani liá'a Jesús médanica, limá'ee lishínaa éewidenaicoo: ");
INSERT INTO aca_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","—Éemi sáica liéni ya u'imíya máechani: Nuyá Washiálicuerri Dios Cúuleeca, néentregaani'inaami náa'a nacáaji rícula náa'a washiálicuenaica quéewique'e naméda nuájcha léjta nawówau. ");
INSERT INTO aca_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Ne nayá jócai náa léenaa néemica liá'a limánica, níwata Dios báya nawítee nájbeecha léenaa néemicani; mawí lécchoo cáarru nayá nasáta néemiu Jesús líiwaquinicta nalíni jucámarranaa. ");
INSERT INTO aca_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Ya néenee náa'a éewidenaicoo nachánau najútacoo nalíwaacoo tánashia néenaa liá'a mawíyii cawéni náiibichai. ");
INSERT INTO aca_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Jesús, yá'inaami léenaa liá'a nédacanicoo nácu nayáca, liwína'ee báqueerri samálita, libárrueda'ee léema nácuu wáni. ");
INSERT INTO aca_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Jáiwa limá'ee nalí: —Liá'a ríshibierri samálitaca nují'inaa nácu, lirríshibiaminaa nuyá, ne liá'a ríshibierri nuyá, lirríshibiaminaa lécchoo liá'a bánuerri nuyá áaqueji. Tándawa liá'a mawíyii mawéni icábaca quinínama íibichau, léewa cawénii wérri liérra. ");
INSERT INTO aca_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Juan má'ee Jesúsru: —Quéewidacai, wacába báqueerri jédeerri demonio jijí'inaa nácu, jáiwa jócu waínda limédaqui jíni, jiníwata jóca wáajcha sáini. ");
INSERT INTO aca_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Jesús éeba'ee lichuáni: —U'imáisaniani liúchani, jiníwata liá'a jócai médau wajúnta, léewa wáajcha sái liérra. ");
INSERT INTO aca_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Quéecha'inaami urrúni liá'a éerrica Jesús íirractala'inaacoo áacairra, liá'a liwówa dánaniu liácoo Jerusalénra. ");
INSERT INTO aca_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Libánua libéechau catéecani chuánshi, náaque'iu áabai chacáalee júbini rícula yáainai Samaria, quéewique'e namúrru liárrui limáacacta'inaacoo. ");
INSERT INTO aca_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Ne náa'a samaritánobinica jócai nawówai narríshibiaca, náaca léenaa liácoo Jerusalénra. ");
INSERT INTO aca_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Quéecha'inaami lishínaa éewidenaicoo Santiago ya Juan cába léji liéni, namá'ee lirrú: —Wawácali, ¿jiwówai jiwána wáurrucueda chichái áaqueji, quéewique'e wamárda nayá quinínama? ");
INSERT INTO aca_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Ne Jesús náawau nanácula, jáiwa licáita nayái máashiica nawítee. ");
INSERT INTO aca_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Néenee Jesús má'ee: Nuyá jócai íinu nuá chóniwenai jíconaa, nuyá íinuerri nuwáseda nayá najíconaa yúchau. Néenee náau áabata chacáalee júbini rículai. ");
INSERT INTO aca_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Nácula náau náacoo iníjbaa lícu, báqueerri washiálicuerri má'ee Jesúsru: —Nuwácali, nuwówaicta nusíguia jiyá táshia jiáctalau jíni. ");
INSERT INTO aca_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Jesús éeba'ee lichuáni: —Náa'a iyáliduca wáalianai útawi nayácta'inaa nawówa íyabacoo ya náa'a míshiiduca wáalianai namúrrubeu; ne nuyá Washiálicuerri Dios Cúuleeca, jiní wíta wáaliacta nuwíta yáarrubai nuwówa íyabacta'inaacoo. ");
INSERT INTO aca_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Jesús má'ee báqueerrirru: —Jíinu nuíshiirricu. Ne léeba'ee: —Nuwácali, jínda nuáacoo quéecha nuquéni nusálijinau. ");
INSERT INTO aca_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Jesús éeba'ee lichuáni: —Jínda máanalini quénicoo nayá jájiu, ne jiyá jiáu jíiwadeda Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Báqueerri má'ee Jesúsru: —Nuwácali, nuwówai méetaa nusíguia jiyá, ne quéecha jínda nuáacoo nuíiwa nunáawau nuéenajinairru. ");
INSERT INTO aca_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Jesús éeba'ee lichuáni: —Liá'a caníinai cába éerri shínanaa, chái jicá'a liá'a tráawajeerricta liácuwani, ya licába liwójunalau, jócai éewa lipíqueda cáinabi, cháwa limédacoo chóniwerri jírra jócai'inaa sírbia Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Liáwinaami liáni, Wawácalica, liwína lécchoo áabi setenta y dos éewidenaicoo, ya libánua nayá libéechau chámatanaa, quinínama chacáalee ya júbini arrúnactala'inaa liácoo. ");
INSERT INTO aca_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Limá'ee nalí: “Chái cábacanaa liá'a Dios wánacaalactaca léjta áabai finca, íchabacta banácali náawaquedani'inaa, ne náa'a tráawajadorbinica áulabani, tándawa isáta liúcha liá'a banácali wácalica, libánuaque'e íchaba tráawajadorbini náawaquedacani. ");
INSERT INTO aca_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Yáau iyá, icábateni, nubánua iyá léjta oveja béewami cháawirru. ");
INSERT INTO aca_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","U'itée chácala ya warrúwa yáarrui, jiní zapatos; ya jócu ibárroo itáa déecu ijúntacta báqueerri iníjbaa lícu. ");
INSERT INTO aca_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Jáicta iwárroo áabai cuíta lícui, itáa ibéechau quéechanacu ya ta imácai: ‘sáica iyáca quinínama lirrícu liáni cuítaca’. ");
INSERT INTO aca_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Ne áicta néeni chóniwenai sáicani wítee já'a, liá'a nawítee sáicaica licúmpliaminau liyá náajcha; ne jócta sáica nawítee, jócuminaa licúmpliau nalí. ");
INSERT INTO aca_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Imáacau néeni já'a lirrícu liá'a cuítaca, ya íya ya írrau liá'a nawáaliani néeni, níwata liá'a tráawajeerrica íiwerri Dios chuáni, rúni jínerri liwéniu. U'ijínaniu cuíta jútainchu. ");
INSERT INTO aca_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Jáicta íinu áabai chacáalee rículai narríshibiacta iyá sáica, íyau tánashia náani íyai; ");
INSERT INTO aca_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ichúni náa'a bálinenaicoo néeni, ya imá nalí: ‘Liá'a Dios wánacaalactaca jái ya urrúni irrúi.’ ");
INSERT INTO aca_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ne íinucta áabai chacáalee rícula ya jócu narríshibia iyá, ijiáyu imáidada cáaye rícula chá'a: ");
INSERT INTO aca_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘¡Áawita liá'a pucúpucubee yáairri ishínaa chacáalee rícu, liá'a cháneerricoo wáiiba nácu, watútuda ináneewani! Yáaque'e léenaa linácu liéni, Dios wánacaalactaca jái ya urrúni irrúi.’ ");
INSERT INTO aca_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Numá irrú liyáali éerriminaa liá'a carrúnatabeeca lirrú liéni chacáaleeca mawí'inaa cacháninaca, náucha náa'a chóniwenaibini yáainai Sodoma rícu. ");
INSERT INTO aca_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“¡Áchunu carrúni jináata jiyámi Corazín! ¡Áachunu carrúni jináata jiyámi Betsaida! Jiníwata á'a Tiro néeni ya Sidón néeni Dios médactata liá'a jócai nacába cáji médanicta íibini, báinacuminaata néejueda nayáwai Diosru, ya nasúwa náabalau jarrájarrai ya nawáacoo báali íibi quéewique'e náayada néejueda nayáu Diosru. ");
INSERT INTO aca_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ne éerri amáarrau'u cáinabi liá'a carrúnatabeeca mawí'inaa cachánina irrú, náucha náa'a chóniwenai yáainai Tiro rícu ya Sidón. ");
INSERT INTO aca_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya jiyá, chacáalee Capernaúm, ¿jirrúminaata jéenaa jinácudacoo áacairra? ¡Jiúrrucuaminau mawí cáinacula wérri dujíwala jiúcacoo! ");
INSERT INTO aca_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“Liá'a éemerri ichuáni, léemiminaa nulí, ne liá'a cháaneerri iyá, licháani nuyá; ne liá'a cháaneerri nuyá, licháaniminaa liá'a bánuerri nuyá.” ");
INSERT INTO aca_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Náa'a setenta y dosca néejua'inaamiu sáicta wérri'e nawówa, namá'ee: —¡Wawácali, áawita náa'a demonioca médenai wawánacaala najiácoo jijí'inaa nácu! ");
INSERT INTO aca_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Jesús má'ee nalí: —Jajá, yáawaiyi, ne nuyá cábeerri Wawásimi cácoo áaqueji léjta éenu íimi únia shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nuyá yáirri irrú wíteeshi cadánani quéewique'e ijínanicoo áai íibi ya aquétu íibi, ya éenaque'e igáanaa quinínama danáanshi lishínaa liá'a wajínaica Wawásimica, jócubeecha liméda irrú máashii. ");
INSERT INTO aca_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Usáicta iwówa namédacala iwánacala irrú náa'a espírituca, sáicta iméda iwówau mawí jáicala ijí'inaa tánau áacairrai. ");
INSERT INTO aca_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ne liyáalimi éerri, Jesús sáictai wérri liwówa Espíritu Santoyu, limá'ee: “Nuá jirrú sáicai nusálijinaa, Wácalishi wánacaleerri áacai ya áani cáinabi íta'aa, jíyadacala nalí náa'a imíyanica liá'a báyeerrimicoo náucha náa'a yáine léenaa ya néemica. Jajá, Nusálijinaa, léewa jiwówau jáni. ");
INSERT INTO aca_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","“Nusálijinaa éejueda nulí quinínama. Jiní yáirri léenaa tánashia Licúulee nácu, Lisálijinaa rímii; jiní yáirri léenaa tánashia Lisálijinaa, bácai rími Licúulee yáa léenaa jáni, ne tánashia Licúulee wówaini líyadarru jíni licúnusiaque'ini.” ");
INSERT INTO aca_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Lináawa'eewoo lishínaa éewidenaicoo náculau, limá'ee nalí báawachala: “Sáicta nawówa náa'a cábenai liá'a icábani iyáca; ");
INSERT INTO aca_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","níwata nuíiwa irrú íchaba cáiiwadedacanimi Dios chuáni báinacu ya náa'a reybinica wówenaimi nacába liáni icábani iyáca, ne jócu nacába jíni; nawówai néemi liá'a éemini iyáca, ne jócu néemi jíni.” ");
INSERT INTO aca_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Báqueerri quéewidacai ley nácu yáau litáania Jesús yáajcha, ya léenedaque'e licábau limá'ee: —Quéewidacai, ¿tána nuéewa numédacai nuwáaliaque'e nucáwicau jócai amáarra? ");
INSERT INTO aca_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Jesús má'ee lirrú: —¿Tána jiliá'a tánerricoo ley rícu? ¿Tána léji liá'a jiliénica? ");
INSERT INTO aca_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Liá'a quéewidacai ley nácu léeba'ee: —Caníinaaminaa jicába jiwácali Dios quinínama jiwówa yáajchau, quinínama jicáwica yáajchau, quinínama jidánani yáajchau ya quinínama jiwítee yáajchau; ya arrúnaa caníinaa jicába jiyácachuni chóniwenai léjta caníinau jicába jiyá jájiu. ");
INSERT INTO aca_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Jesús ma lirrú: —Jéebani sáica liáni. Jimédacta liáni, jiwáaliaminaa jicáwicau mamáarraca. ");
INSERT INTO aca_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ne liá'a quéewidacai ley shínaaca, liwówai limáacacoo sáica, lisáta'ee léemiu Jesús limá'ee —¿Ya tána arrúnaa nuyúdacai? ");
INSERT INTO aca_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Néenee Jesús éeba'ee lirrú: —Báqueerri washiálicuerri yáairriu Jerusalén yáajba náalicu Jericó néerra'inaa, jáiwa áabi canédibini jiáu lirrú, jáiwa nanédu jíni néedacta liá'a líibalaca; náiinueda jíni, jáiwa náawai atéwai náiinuaca. ");
INSERT INTO aca_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Chítashiawa wánaca jíni báqueerri sacerdote bésunau néenee jíni lirrícu liá'a iníjbaaca, jáiwa licába jíni, jáiwa líshiirriu liúcha liáawai. ");
INSERT INTO aca_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Cha lécchoo báqueerri néenaa náa'a levítaca libésunau néeni, ne licába'inaamini líshiirriu liúcha, jáiwa liáawai. ");
INSERT INTO aca_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Ne báqueerri washiálicuerri Samaria néenee sái yáairriu lirrícuba léja liá'a iníjbaaca, licába'inaamini, carrúni jináata licábaqui jíni. ");
INSERT INTO aca_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Lirrúniu lirrú, jáiwa liméda lídabee acéiteyu ya vino, jáiwa lidájida litúcai. Jáiwa lírda jíni lishínaa éema ítalau, litée jíni áabai cuíta rícula litúya jíni. ");
INSERT INTO aca_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Cajójchanaami, liá'a samaritánoca lijéda léjta chámai éerricta lishínaa tráawaju wéni, jáiwa liá lirrú jíni liá'a cuíta wácalica ya limá'ee lirrú: ‘Jitúya liáni washiálicuerrica, ne jigáastacta áabata mawí, nupáidaminaa jirrújoni jáicta nuéejojoo.’ ");
INSERT INTO aca_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Sáicai wérri, ¿tána néenaa náani matálitaica caníinai cába liá'a washiálicuerri canédi íinuedanimica? ");
INSERT INTO aca_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Liá'a quéewidacai ley shínaaca léeba'ee: —Liá'a carrúni jináatai cába liyá. Jesús má'ee lirrú: —Ya jiáu jiméda chacábacanaa. ");
INSERT INTO aca_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesús síguia lishínaa iníjbau (náajcha náa'a lishínaa éewidenaicoo) jáiwa liwárroo áabai chacáalee rími, báquetoo íinetoo yácta jí'ineechoo Marta rurríshibia liyá rúbana rícula. ");
INSERT INTO aca_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Marta wáalia báquetoo ruéenajetoo jí'ineechoo María, wáaichoo ruyáca Jesús íiba néeni ruéemique'e liá'a limáni liyáca. ");
INSERT INTO aca_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ne Marta urrúniu wówa linácu liá'a íchaba arrúnai'inaa rumédaca, tándawa rurrúniu Jesúsru rumá'ee lirrú: —Nuwácali, ¿jiní wéni jirrú nuéenajetooca rumáacau'u nuyá bácai quinínama liájcha liáni tráawajuca? Jíiwa rulíni, ruyúda'aa nuyá. ");
INSERT INTO aca_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ne Jesús éeba'ee rulí: —Marta, Marta, urrúni jiwówa ya máashii jiwówa íchaba jishínaa nácueji. ");
INSERT INTO aca_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ne ái áabai mawíyii chúnsaica já'a. Maríaca ruwína mawíyii sáictaca, ya jiní'inaa éenaa léeda rúcha. ");
INSERT INTO aca_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Báitate Jesús órau liyá áabai yáarruishimi, ne quéecha'inaami linísa li'óracuwai, báqueerri néeenaa náa'a lishínaa éewidenaicoo má'ee lirrú: —Wawácali, jéewida wa'óracoo, léjta Juan éewidau'u lishínaa éewidenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Jesús má'ee nalí: —Jáicta i'órawai imá chá'a: ‘Wasálijinaa yáairri áacairra, chóniwenai cáarru nacába jijí'inaa. Jíinu chérra liá'a jiwánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Jiá walí íyacaishi warrúnaani éerri jútainchu. ");
INSERT INTO aca_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Jimíya máecha wajíconaa níwata wayá lécchoo wamíya máecha najíconaa quinínama náa'a médenai walí máashii. Jáicta máashii íinu wáatalai ujínda wacácoo jíconaashi rícula.’ ");
INSERT INTO aca_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Jesús má'ee lécchoo nalí: —Wamáacate báqueerri éenaa wáalierri báqueerri lijúnicaiu, yá'ee béewami táayebee'inaa liá'eewoo jíibana néerra ya limá'ee jirrú: ‘Nujúnicai, jiprésta nulí matálii páani, ");
INSERT INTO aca_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","níwata báqueerri nujúnicai chóca rímii nísa líinu déecucheji núbana néerra, ya jiní nuwáaliani nuáni'inaa lirrú.’ ");
INSERT INTO aca_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Ne yáawaiyi jócta léeba jichuáni cuíta lícucha limáminaa jirrú: ‘Ujijódia nuyá, cuíta núma báyeerriu, ya nuéenibi ya nuyájani rúwacuwai; jócu nuéewa nubárruacoo nuá jirrúni.’ ");
INSERT INTO aca_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Ne numá irrú áawita jócu libárroo liá irrúni liá'a jirrúnaanica áawita jijúnicaicani, liáminaani jimésudacta liwówa, ya liáminaa jirrú quinínama liá'a jirrúnaanica. ");
INSERT INTO aca_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Tándawa numá irrú: Isátau, ya Dios yáaminaa irrúni; imúrru, ya íinuminaa linácu; imáida cuíta náanibala, ya liméecuminau irrú. ");
INSERT INTO aca_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Jiníwata liá'a sáterrica, lirríshibiaminaani; ya liá'a múrruerricani, líinuminaa linácu; ya liá'a máiderri cuíta núma lícu, liméecuminau lirrú. ");
INSERT INTO aca_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","“¿Áiminaa báqueerri éenaa já'a cacúulectani, ya licúulee sátacta liúcha áabai cubái, léenaaminaa liá lirrú bácua áai? ");
INSERT INTO aca_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","¿O lisátawee jiúcha bátui éewishi, éenaaminaa jiá lirrú áabai aquétu? ");
INSERT INTO aca_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ne iyá máashiicani séewirri, yáaine léenaa yáa éenibirru sáicabeeca, ¡chítashia ta mawí jíni Isálijinaa yáairri áacai liáminaa irrú Espíritu Santo isátacta liúchani!” ");
INSERT INTO aca_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Jesús jéderrite liyáca áabai demonio báqueerri washiálicuerri wáneerrite limáacacoo manúma; ne quéecha'inaami lijiácoo liá'a demonioca, jáiwa léewa litáaniacai. Náa'a chóniwenai nacáarrudau nacábacani. ");
INSERT INTO aca_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Ne áabi má'ee: “Beelzebú, demonio wácalica, léwa cha yáa lirrú liwíteu liáni washiálicuerrica léewaque'e lijéda demonio.” ");
INSERT INTO aca_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ne áabibi, namédaquini'e lirrú áabai trampa, nasáta'ee liúcha áabai jócai nacába cáji áaqueji. ");
INSERT INTO aca_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Ne Jesús, liáca'e léenaa liá'a nédacanicoo nayá nácu, limá'ee nalí: “Quinínama país nashírrictau nayá wáacoo, ya máashii nacába yáacacoo, jócani éewa nayá jájiu, ya náa'a chóniwenai jócuminaa nayá sáica nayá wáacoo, cháiminaa cábacanaa nalí, léjta áabai néenajinai náiinua yáacaminau nayá wáacoo. ");
INSERT INTO aca_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Cháminaa cábacanaa, Wawásimi máashiiquicta licába yáacacoo liyá jájiu, ¿chíta quéewau'u cadánani liwítee cábacoo jíni? Numá irrú liáni, imácala jáica nujéda demonio Beelzebú wítee dánaniyu. ");
INSERT INTO aca_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ne cháctacalani, ¿tána yáa ishínaa chóniwenai irrúi wíteeshi danáanshi najédaque'e demonio? Tándawa, nayá jájiu náayada liá'a yáawaiyica, ne iyácala yúquenaeu iyáca. ");
INSERT INTO aca_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Jiníwata nuyácta jéda demonio numédani nuyáca Dios wíteeyu, liáni wówerri limáca Dios wánacaalactaca jái íinu irrúi. ");
INSERT INTO aca_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Áicta báqueerri washiálicuerri cadánani já'a ya liwáalia íchaba arma ya litúya líibanau, liá'a liwáaliani líibana lícuu jiní éenaa linédu liúcha. ");
INSERT INTO aca_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ne áicta báqueerri íinuerri liyáctalaca mawí cadánani liúcha ya ligáanani, léeda liúcha lishínaa ármami liwínani liwówau nácula, ya quinínama línda litée liá'a liwáalianimica limédaque'e léjta liwówau'u. ");
INSERT INTO aca_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Liá'a yáa nuájcha áabenaa, léewa nujínai liérra, ne liá'a jócaicta yáawaqueda nuájcha, léewa cacáarraliacai liérra. ");
INSERT INTO aca_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Jáicta áabai espíritu máashii jiáu báqueerri washiálicuerri yúchai, jínaneerriu yáarruishi máacarractaca limúrru liwówa íyabacta'inaacoo; ne jinícta líinuctani, lédacanictau lirrúwoo: ‘Nuéejoctawai núbana rículau nujiáctejimicoo.’ ");
INSERT INTO aca_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Jáicta léejuawai, líinu linácu liá'a washiálicuerrica léjta áabai cuíta máisai jíchuderriu ya nachúndadanini sáica. ");
INSERT INTO aca_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Néenee liáu liáwaqueda siete espíritu lítalau mawíni máashiicaca liúcha, ya quinínama nawárruau nayá liwówa lícu liá'a washiálicuerrica, mawíque'e nawána máashii wérri liyá quéecha yúcha.” ");
INSERT INTO aca_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Nácula Jesús táania liyáca linácueji quinínama liáni, báquetoo íinetoo chóniwenai íibicha rumáidada'ee rumáca: —¡Sáicta ruá'a íinetooca cúlicuechoo jiyá ya rudáwinaa jiyá! ");
INSERT INTO aca_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Jesús éeba'ee: —¡Sáicta mawí tánashia liá'a éemerri Dios chuáni, ya liméda liwánacaala! ");
INSERT INTO aca_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Náa'a chóniwenai máanabacanaamica náawaca'eewoo Jesús téeji, jáiwa lichánau léewida nayái limá'ee: “Náani chóniwenai chóque'e sánaca bájialani máashiicaca; nasáta'ee ya nawówai nacába jócai nacába cáji, ne Dios jócai éejoo liméda nalí léjta limédau Jonás yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Ne léjta Jonás liyá señal nalí náa'a chóniwenai yáainemi Nínive, chacábacanaa lécchoo nuyá Washiálicuerri Dios Cúuleeca, núyadaminaa nuyáu léjta áabai señal nalí sána'inaa náa'a chóniwenai chóque'e sánaca'a. ");
INSERT INTO aca_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Jáicta amáarra cáinabijoo limáidacta'inaa quinínama náani chóniwenai chóque'e sánaca, rubárruaminau ruá'a reinaca íinuechoomi déecucheji rumáminaa jóca sáica nayáca; jiníwata ruyá íinuechoo déecucheji wérri bájirra cáinabi íteeji, quéewique'e ruéemi Salomón wíteeca, ne nuyá yáairri yáajcha chóca rími áani, mawíyii cawéni Salomón yúcha. ");
INSERT INTO aca_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Chacábacanaa lécchoo jáicta amáarra cáinabijoo, nabárruaminaujoo náa'a Nínive sánaca quéewique'e namá náani chóniwenai jócani sáicayaca; níwata náa'a Nínive sánaca, néemi'inaami Jonás chuáni, jáiwa néejoo Diosrui, ne nuyá yáairri chóca rími áani, mawíyii cawéni Jonás yúcha. ");
INSERT INTO aca_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Jiní túculierri áabai lámpara ya ta libáyaqui jíni, jiní limáacalani áabai cajón yáajabani, limáacaminaani áacai, quéewique'e náa'a wárruenaicoo nawáalia jucámarrabee. ");
INSERT INTO aca_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Jituí chái cábacanaa léjta áabai lámpara jináanairru; sáicaquicta jituí, quinínama jináanai liwáaliaminaa jucámarrabee; ne máashictani, quinínama jináanai yáairri catáwacacta. ");
INSERT INTO aca_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Jicáwaa jiúchaujoo quéewique'e liá'a jucámarrabee yáairri jinácu, jócu lináwau catáwacabeeyu, quéewique'e quinínama liá'a jimédanica lijiáque'iu jirrú sáica. ");
INSERT INTO aca_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Ne quinínama jináanai liwáaliacta jucámarrabee sáicaica, jiní éewo'u jiyá catáwacacta, jicábaminaa quinínama jucámarranaa liá'a jimédanica, léjta áabai lámpara jáicta liquénai quinínama cábani cámarraa.” ");
INSERT INTO aca_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Quéecha'inaami Jesús nísa litáaniacai, báqueerri fariseo cúmida líya líibana néerra, jáiwa Jesús wárruau liwáacoo mesa nácula. ");
INSERT INTO aca_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Liá'a fariséoca, licáarrudau licába jóca liméda liwánacaala liá'a nawítee nabádeda nacáajiu jóctanaa náayaa. ");
INSERT INTO aca_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ne Jesús má'ee lirrú: —Iyá fariséobinica méetuedenai líteeji liá'a básoca ya mitájia, ne iwówa lícu cashiámui yáca liyú liá'a shínaashica inédunica ya liá'a iwítee máashiica. ");
INSERT INTO aca_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","¡Chóniwenai jócani éewa nédacanicoo sáica! ¿Jócu yáa léenaa liá'a méderri bináawe sái ya liméda liá'a yáairri lirrícu lécchoo? ");
INSERT INTO aca_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Yáa ishínau limósnau liá'a yáairri iwówa lícu, cháminaa limáacacoo masácula. ");
INSERT INTO aca_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“¡Ái éenaa já'a carrúni jináatani'inaa iyá fariséobinica! shírrenai Diosru diésnaa méenaami éenaa áabata méenaami éenaa liá'a ibánacalaca píituinamai jí'ineerri menta, ya ruda ya quinínama méenaami banácali júbinica, ne jócani méda machácanica ya caníinaabeeca Diosru. Léewa éewani iméda liárra, ya jócu imáaca iméda lécchu liá'a áabataca. ");
INSERT INTO aca_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“¡Ái éenaa já'a carrúni jináatani'inaa iyá, fariséobinica! wówenai iwáalia yáarrubaiu mawí cawéninamaica sinagoga rícu, ya iwówai chóniwenai natáa irrú sáicai wérri cáaye rícuba. ");
INSERT INTO aca_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“¡Ái éenaa já'a carrúni jináatani'inaa iyá cháni cábacanaa léjta útawi máanalini yáarrui, jócai íyadau chóniwenai tuírricu, náa'a chóniwenai báawedani jócta náa léenaa jíni! ");
INSERT INTO aca_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Néenee báqueerri quéewidacai ley shínaa éeba'ee, limá'ee: —Quéewidacai, liéni jimáni jiyá nalí náani, jócai sáica cáacoo walí lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Ne Jesús má'ee: —¡Ái éenaa já'a carrúni jináatani'inaa iyá lécchoo, quéewidacaica ley shínaaca!, yáainei áabirru cadúcunibee léjta náayu'u éemarru cadúcunibee, ne iyá jócai iwówechoo idúnu nácu icáajiyu. ");
INSERT INTO aca_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“¡Ái éenaa já'a carrúni jináatani'inaa iyá!, chúndenai iméda náutabee náa'a íiwadedeenaimi Dios chuáni báinacu, náa'a iwérrinaibimi íinuanimi báinacu. ");
INSERT INTO aca_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Liyú liárra iwówau'u imáca áabenaaca iwíteu náajcha iwérrinaibimi médani báinacu, ne nayá íinuenai yáawaa náa'a cáiiwadedacanimi Dios chuáni, ya iyá médenai bárrueda náutabee. ");
INSERT INTO aca_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","“Tándawa, Dios liwítee rícuejiu limá'ee: ‘Nubánuaminaa irrú íiwadedeerri nuchuáni ya quéewidacani, ne íinuaminaa áabi néenaajoo, ya áabiminaa icánaquedanijoo.’ ");
INSERT INTO aca_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Ne náa'a chóniwenai chóque'e sánaca, Dios sátaminaa náucha nanácue sái liá'a náirranaami náa'a cáiiwadedacanimi Dios chuáni báinacu, rícuete cáinabi quénucuwai, ");
INSERT INTO aca_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","rícuete Abel íirranaami néenee cáashia Zacarías íirranaami néerra, liá'a náiinuanimi béewami lirrú altarca ya templo. Tándawa Dios sátaminaa lijúniba sái liá'a limáanalicaca náucha náa'a chóniwenai chóque'e sánaca ya licástigaaminaa nayá. ");
INSERT INTO aca_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“¡Ái éenaa já'a carrúni jináatani'inaa iyá, éewidenai ley shínaa nácu!, iyá léjta náa'a túyenai cuíta núma Dios shínaa, jiní yácala léenaa linácu sáica, jiní ijínacalau Dios yáajabalicu, jiní índaca áabi jínacoo. ");
INSERT INTO aca_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Jesús nísa'inaami limá nalí léji liéni, náa'a quéewidacaica ley shínaaca ya fariséobinica, jáiwa íiwirri wérri nawówai, ya ta nachánau najódia nasátada néemiu liyá íchaba chuánshiyu, ");
INSERT INTO aca_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","naméda'ee lirrú trampa quéewiquinicta nachálujuedaca liyá cháquinicta néewa náa lijíconaa liyú liá'a chuánshi limánicaja. ");
INSERT INTO aca_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Nácula íchaitaa náawacau miles ya miles chóniwenai, bájialacalani nadánaida yáacau nayá wáacoo. Jáiwa Jesús chánau litáaniacai, limá'ee lishínaa éewidacoo quéechanacu: “Cáwi icába yúchau néewidacala náa'a fariséobinica, liwówau'u limáca, chámaica nawítee. ");
INSERT INTO aca_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Jiníwata liá'a báyeerrimicoo néenaani'inaa náa léenaa nácu, áawita liá'a báyeerrimicoo arrúnai'inaa jiácoo jucámarrai rícula náaque'e léenani. ");
INSERT INTO aca_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Tándawa, quinínama liá'a itáanianica catáwacacta, jiéirri'inau jucámarrai jíirricula; ya liá'a imáni cabáyainta áawita ibáya íibana númau, arrúnai'inaa namáidada cuíta íteeji. ");
INSERT INTO aca_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Iyá nujúninai, numá irrú: jócai éewa cáarru icába liá'a máanaliu wanáanai, ne jiní léewani liméda mawiá. ");
INSERT INTO aca_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Nuíiwa irrú sáica liá'a tánashia éewani cáarru icába yáawaa: ‘Cáarru icába liá'a wáalierri wánacaalashi cáwicaishi nácu léewacala lédacani ya ta libánua infierno rícula jíni. Léewa éewani cáarru icába liérra.’ ");
INSERT INTO aca_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“¿Jócai iwénda cinco míshiidu chámai moneda nácueji rími? Ne áawita chácani Dios jócai míya máecha áabai néenaa. ");
INSERT INTO aca_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Ne áawita iyá jájiu, iwíta báinaa lijútadani máanabaca báajunaa. Tándawa jócu éewa cáarru iyá. Iyá cawénini mawí íchaba míshiidu yúcha. ");
INSERT INTO aca_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Numá irrú áicta báqueerri chóniwerri jócai bái íiwa nunáawa chóniwenai náneewa, cháminaa cábacanaa nuyá Washiálicuerri Dios Cúuleeca, jócuminaa bái nuíiwa lináawa lécchoo nanáneewa náa'a ángelbini Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ne liá'a báiyii íiwa nunáawa chóniwenai náneewa, báiminaa nuíiwa lináawa lécchoo nanáneewa náa'a ángelbini Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Dios méetuaminaa lijíconaa liá'a chóniwerri táanierri máashii nunácucha nuyá Washiálicuerri Dios Cúuleeca; ne jócuminaa liméetua lijíconaa liá'a táanierri máashii Espíritu Santo nácueji. ");
INSERT INTO aca_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Jáicta natée iyái sinagoga rícula o lináneewa náa'a chóniwenai yáairri léenaa léemi sáicani o máashiibeecani o nanáneewa náa'a wánacaleenaica, o'icáarrudau chítashia éewo'inaa ijiácoo o imáqui jíni, ");
INSERT INTO aca_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","jiníwata jáicta líinu liá'a éerrica itáaniacta'inaaca, liá'a Espíritu Santoca léewidaminaa iyá, tánashia itáaniani'inaa.” ");
INSERT INTO aca_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Báqueerri náiibicha náa'a chóniwenaica limá'ee Jesúsru: —Quéewidacai, jimá lirrú liá'a nuéenajirrica, liáque'e nushínaa léenaa liá'a shínaashi máaquerricoo walí. ");
INSERT INTO aca_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Jáiwa'ee Jesús éeba lichuánii: —Nujúnicai, ¿tána máaca nuyái irrúi léjta liá'a yaárri léenaa licába sáicani o máashictani o cashírruedacaica? ");
INSERT INTO aca_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Limá'ee lécchoo: Itúyau iyá quinínama liúcha liá'a iwówau'u iwáalia méenaami quinínama; níwata liá'a cáwicaishica jócai íinu lirrícueji liá'a wawáaliacta méenaami. ");
INSERT INTO aca_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Néenee líiwa nalí liéni áabai cha licábacanaa: “Báqueerri washiálicuerri rícuerri, yáte lirrú lishínaa cáinabi banácali manuábai íta. ");
INSERT INTO aca_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Liá'a rícuerrica lichánau lipénsaa lirrúwoo: ‘¿Tána'ee numédajoo? jócai nuwáalia liárru nuwáaliacta'inaa nushínaa shínaashi íta.’ ");
INSERT INTO aca_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Limá'ee lirrúwoo: ‘Ya ta nuá léenaa numédani'inaa. Nucáarraliaminaa nushínaa banácali yáarrui, ya ta numéda áabi mawí máanuica, quéewique'e nuwáaliada néeni nushínaa banácali íta, ya quinínama liá'a nuwáalianica. ");
INSERT INTO aca_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ne ya ta numá nulíwoowai nuyá jájiu: Nujúnicai, jiwáalia íchaba wérri shínaashi éeneerri'inaa jirrú íchaba wérri camuí; jiwówa íyabau, jíyau, jíirra, sáicta jiméda jiwówau.’ ");
INSERT INTO aca_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Ne Dios má'ee lirrú: ‘Mawítee, wáalee táayee máanali jiyájoo, ya liá'a jiwáaliadanica ¿tánarru sái'inaa jíni?’ ");
INSERT INTO aca_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Cháwa cábacanaa libésunacoo liájcha liá'a washiálicuerri yáawaquederri lirrícucau liyá jájiu ne carrúni jináatai Dios náneewa.” ");
INSERT INTO aca_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Liáwinaami Jesús ma lishínaa éewidenaicoo: “Liáni numá irrú: O'urrúni iwówa linácueji liá'a íyacaishica éewau'inaa cáwi iyá, jiní íibala nácuu isúwani'inaaca. ");
INSERT INTO aca_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Liá'a cáwicaishica mawí cawénica íyacaishi yúcha, ya liá'a náanaishica mawí cawénica íibalashi yúcha. ");
INSERT INTO aca_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Éeda natuínaa náa'a míshiiduca: Jócani yáabana, jiní nawáaliacala nashínau, jócani wáalia nábanau nawáaliadacta'inaa náaya'inau; ne áawita chácani, Dios yáirri náaya'inaa. ¡Chíta mawí jíni iyá cawénini míshiidu yúcha! ");
INSERT INTO aca_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ne áawita chácani, iméda urrúni iwówau, ¿tána éenaa idáwineda icáwicau áabai hóraa mawí? ");
INSERT INTO aca_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ne jócta éenaa imédacani liá'a mawí píituica, ¿tánda urrúni iwówa linácueji liá'a mawí méenaamica? ");
INSERT INTO aca_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Éeda natuínaa náa'a íiwinaashica chítashia nadáwinau'u jíni: jócani tráawajaa jiní natíticala. Ne áawita chácani, numá irrú liá'a rey Salomónimica, áawita liwáalia quinínama lishínaa méenaami cawéninamaica, jócai súweda líibalau léjta íiwinaashi. ");
INSERT INTO aca_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ne Dios yácta sáicta nacábacanaa náa'a íiwinaashica yáaine chóque'e bacháida lícu, ya cajójchanaami léemawai, ¡chíta mawí iyá jíni liáminaa irrú íibala irrúnaanica, iyá chóniwenai jócai éenaa éebidaca! ");
INSERT INTO aca_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Ne tándawa, umáashii iwówa máacoo, imúrru tánashia íinuni'inaa íyawai ya írra'inaa. ");
INSERT INTO aca_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Jiníwata quinínama liáni, léewa wáneerri urrúni chóniwenai wówa náa'a éerri rícu sánaca, ne iyá wáalianai báqueerri isálijinau áacai, yáirri léenaa tánashia irrúnaanica. ");
INSERT INTO aca_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Iyá imáaca iwíteu linácula liá'a Dios wánacaalactalaca, ya táminaa irríshibia quinínama léji liéni. ");
INSERT INTO aca_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ucáarru iyá nushínaa oveja jínanenaiu nuájcha, iyá áulabani rími, ne Nusálijinaa sáicalani liwówaiyu liá irrú lishínaa wánacaalashi. ");
INSERT INTO aca_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Iwénda liá'a iwáalianica, ya yáa nalíni náa'a carrúni jináatanica; éeneda iwáalia chácala wáalii, jócai salírrani, cháminaa máanui wérri rícucaishi áacairra jócai amáarra, jóctala canédi éewa liwárruacoo jiní camárra íyacala shínaashi néerra. ");
INSERT INTO aca_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Táshia nácucha iwáaliacta ishínaa cawéninamai, iwówa néeniya lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Léjta náa'a cashírruedacanica súwedenai nábalau sáica ya nashínaa lámpara túculerriu, nanénda nawácali íinuca, chacábacanaa iyá chúni jáicta líinu léji liá'a Wawácalica. ");
INSERT INTO aca_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Imédau léjta náa'a tráawajadorbinica néndenai nayáca nawácali éejoocoo áabai boda yúcha, jáicta líinueda cuíta númai le naméecu lirrú jiliá'a. ");
INSERT INTO aca_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Sáicta náa'a cashírruedacanica jáicta líinu léji liá'a nawácalica, ya líinu nanácu cáwi. Ne yáawaiyii numá irrú nawácalicaja liwána nawáacoo mesa nácula, ya táminaa lishírrueda náayai. ");
INSERT INTO aca_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Sáicta wérri nayá, líinucta nanácu cáwi béewami táayebee o mésactala éerri. ");
INSERT INTO aca_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Yáa léenaa sáica linácu liéni: Liá'a cuíta wácalica liáctata léenaa táshia hóraa líinu léji liá'a canédica, jócata línda naméecu líibanai nanéduque'e lishínaa. ");
INSERT INTO aca_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Iyá lécchoo ichúniu; jiníwata nuyá Washiálicuerri Dios Cúuleeca, nuíinuminaa jócta nanénda nayá nuyá.” ");
INSERT INTO aca_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Pé'eru sáta'ee léemiu Jesús: —Nuwácali, ¿jíiwadeda liáni licábacanaa walí sái'inaa já'a bácai o quinínamarru sái'inaa wéeca? ");
INSERT INTO aca_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Limá'ee liá'a Wácalishica: “¿Tána léji liá'a chóniwerri liwácali máacanica machácani liyáca ya cáwi wíteeyaca, liwácali máacani lirrú litúyaque'e líibana, quéewique'e liá íyacaishi éerdi náayaca? ");
INSERT INTO aca_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Sáicta liá'a cashírruedacaica, jáicta liwácali íinui méderrii liyá léjta limáyu'u lirrú. ");
INSERT INTO aca_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ne yáawaiyi numá irrú, liwácali máacaminaa liwánacaala quinínama liá'a liwáalianica. ");
INSERT INTO aca_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ne liá'a cashírruedacaica lipénsacta lirrúwoo liwácali déecudacalau, lichánau liméda máashii nanácula náa'a áabi cashírruedacani ya náa'a íinaca cashírruedacani, ya lichánau líyaca ya líirraca licámadectalaca, ");
INSERT INTO aca_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","liá'a éerrica jócta linénda liyá liwácaliu, ya áabai hóraa jócai liá léenaa nácu, liwácali íinuminaa ya ta licástigaa cáiwinaa jíni, liúcaminaa liyá chacábacanaa léjta náa'a jócani machácaniyaca. ");
INSERT INTO aca_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Liá'a cashírruedacaica yáirri léenaa tánashia liwówai liwána liméda liá'a liwácalica, ne jócai chúni liyáca, jiní léewidacala, licástigaaminaani libásaidaminaa liyá íchabachu. ");
INSERT INTO aca_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ne liá'a cashírruedacaica jócai yáa léenaa liméda liá'a máashiica, jócai'inaami náa bájiala libásaca. Liá'a náani lirrú mawí íchaba, chacábacanaa lécchoo nasáta liúcha íchaba; ne liá'a namáacani lirrú nashínaa chawítemija'a, chacábacanaa nawána liméda mawí máanui lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Nuyá íinuerri éerri rícula nutúcula chichái; ya ¡chítata nuwówau'u nucába léemau'u jíni! ");
INSERT INTO aca_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Arrúnaa nusúfria bájialanaa, ¡ne máashii wérri nuwówa nunénda libésunacoo quinínama liérra! ");
INSERT INTO aca_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","¿Éebida nuíinucala éerri rícula nuínda sáictaque'e iwówa iyáca? Numá irrú jócala, índeerri quéewique'e ishírrida yáacaque'iu. ");
INSERT INTO aca_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Ne chóque'e wabéechalawoo, cinco néenajinai wáacoo áabai cuíta lícu máashiiminaa nacába yáacacoo, matálitai chámata júnta, chámata matálitai júnta. ");
INSERT INTO aca_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Liá'a lisálijinaaca máashiiminaa licába licúuleu, liá'a licúuleeca máashiiminaa licába lisálijinau; ruá'a natúwaca máashiiminaa rucába rumíyacalau ya rumíyacaula máashiiminaa rucába rutúwau; ruá'a rúneerruca máashiiminaa rucába runírru ya runírru máashiiminaa rucába rúneerru.” ");
INSERT INTO aca_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesús má'ee lécchoo chóniwenairru: “Jáicta icába sáanai nácudacoo chéni éerri wárruactalacoo, imá'ee yúwerri'inau, ne yáawaiyi imácaa. ");
INSERT INTO aca_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ne áicta cáuli cánacau bácheji imá amuábeecala'inaa chunídanaa, ne yáawaiyi imácaa. ");
INSERT INTO aca_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","¡Chámaini wítee!, Ne yácta léenaa icába éerri cábacanaa bésuneerri'inaacoo cáinabi íta'aa, ¿chíta quéewau'u jócu yáa léenaa icába liéni éerri Dios íyadani liyá icába? ");
INSERT INTO aca_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Jesús má'ee nalí: ‘¿Tánda jócu yáa léenaa icábacoo sáicacta o máashicta iyá jájiu imá tánashia sáicai? ");
INSERT INTO aca_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Báqueerri yácta jijíconaa, ya litée jiyá jíyadacoo nalí náa'a wánacaleenaica, arrúnaa jéeneda jichúnicoo jóctanaa natée jiyá ái éerri já'a jéewaque'e jichúnicani, quéewique'e jócu natée jiyá lináneewa liá'a yáirri léenaa licába sáicactani o máashictani; léejuedaminaa jiyá nalí náa'a soldado, ya táminaa naníqui jiyái cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Ne numá jirrú jócuminaa jijiáu néenee, cáashia jipáida quinínama liá'a jimówinianica.’ ” ");
INSERT INTO aca_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Liyáalimi éerri áabi yáau nacába Jesús, náiiwadeda'ee lirrú Pilato bánuaca náiinua áabii washiálicuenai Galilea néenee sánami, yá'ee léewida náirra náa'a cuéshinai íirranaa íibi sacrificioyu. ");
INSERT INTO aca_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Jesús má'ee nalí: “¿Imáuminau irrúwau libésunacalau liéni náajcha náa'a washiálicuenaimica yáainaimi Galilea rícu, níwata nalí mawíni cajíconaaca náucha náa'a ishínaa cáinabi íta sánaca? ");
INSERT INTO aca_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Numá irrú jócala; ne iyá jájiu jóctacala éejueda iyáu Diosru, chái'inaa cábacanaa máanali iyá. ");
INSERT INTO aca_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","¿O imáuminau irrúwau nanácu náa'a dieciocho máanalinimica licá'inaamiu nawítee liá'a cuíta áacai yáairrimi chacáalee Siloé rícu, nalí mawíni cajíconaaca náucha náa'a yáaine Jerusalén rícu? ");
INSERT INTO aca_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Numá irrú jócala; ne iyá jájiu jóctacala éejueda iyáu Diosru, chái'inaa cábacanaa máanali iyá.” ");
INSERT INTO aca_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesús íiwa'ee nalí liáni licábacanaaca: “Báqueerri washiálicuerri wáaliate áabai banácali jí'ineerri higuera lishínaa shínaashi íta'au, liá'inaamiu licába liácta higos, ne jiní líinucta líta. ");
INSERT INTO aca_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Jáiwa'ee limá lirrú liá'a washiálicuerri túyerri lishínaa shínaashi: ‘Jicábateni, matáli camuí nuíinuca numúrru líta liáni higuéraca, ne jiní wérri nuíinucta líta. Jiwíchuani, ¿tándashia ta liwína liyá néeni cáinabi újni?’ ");
INSERT INTO aca_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Ne liá'a túyerri lirrú cáinabi limá'ee léeba lichuáni: Nuwácali, jimáaca újnibini le camuícaja liáni; nuwáseda'a lirrú cáinabi nuáque'e lirrú abono. ");
INSERT INTO aca_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Cháminaa cájbami liá lítau; ne jóctacala, ya ta jiwíchuacojoni.” ");
INSERT INTO aca_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Áabai éerri, éerdi nawówa íyabactacoo, Jesús chánau léewidaca áabai sinagoga rícu; ");
INSERT INTO aca_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ya néeni báquetoo íinetoo bálinechoo báinacu wérri dieciocho camuí. Áabai espíritu máashii máacani mulídu ruwójuna, jócau éewa rumáchiquiniacoo sáica. ");
INSERT INTO aca_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Quéecha'inaami Jesús cába ruyái, limáida rulí limá'ee: —Íinetoo, jiyá'au chúnicuwai jishínaa bálinacaalashi yúcha. ");
INSERT INTO aca_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Néenee lichánaa licáajiu runácu, liyáalimi ruéewa rumáchiquiniacoo, jáiwa ruchánau ruá sáicai Diosrui. ");
INSERT INTO aca_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Ne liá'a sinagoga wácalica íiwirri liwówa, níwata Jesús chúnica'ee ruyá éerdi nawówa íyabactacoo, limá'ee nalí náa'a chóniwenaica: —Ái seis éerri já'a éerdi natráawajaaca; íinu liyáali éerri quéewique'e ichúnicoo ibálinacaala yúcha, ne jócai éerdictaca nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Jesús éeba'ee lichuáni: —Chámai wítee, ¿jócu iwáseda ishínaa pacáa o burro léerdi nawówa íyabactacoo, quéewique'e itée líirra shiátai? ");
INSERT INTO aca_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ne ruáni íinetooca, Abrahám táquetoomica, Wawásimi ya rulí liéni bálinacaalashica dieciocho camuí, ¿ne jócuminaata nuéewa nuchúni nuwáseda rúcha léerdi nawówa íyabactacoo? ");
INSERT INTO aca_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Quéecha'inaami Jesús ma léji liéni, lijínai máaqueneu báinata; ne quinínama náa'a chóniwenaica sáicta nawówa nacába liá'a máanui Jesús médanica. ");
INSERT INTO aca_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Jesús má'ee lécchoo: “¿Chíta licábacanaa liá'a Dios wánacaalactaca ya tána cábacanaa nuíiwa irrú jíni? ");
INSERT INTO aca_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Chái léjta áabai mostaza íimi báqueerri washiálicuerri yáabanani lishínaa shínaashi íta'au, ya ta lidáwinacuwai máanui, cáashia limédacoo áicubayu máanui ya ta náiinu náa'a míshiiduca naméda nábanau linácai nácu.” ");
INSERT INTO aca_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Jesús má'ee lécchoo: “¿Chíta nuéewa numéda licábacanaa liá'a Dios wánacaalactaca? ");
INSERT INTO aca_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Chái cábacanaa léjta liá'a wáneerri páani múrracacoo báquetoo íinetoo ruéewidani matálii íinabishi íibirra, quéewique'e liwána íinabishi múrracacoo quinínama.” ");
INSERT INTO aca_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Jesús liá'a'inaamiu liácoo iníjbaa lícu Jerusalénra, Jesús éewida liácoo chacáalee máanuini rícu ya júbini libésunactacoo liácoo. ");
INSERT INTO aca_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Báqueerri sáta'ee léemiwani: —Nuwácali, ¿áulabani yáainecoo'inaa Dios néerra? Jesús éeba'ee lichuáni: ");
INSERT INTO aca_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","—Éeneda iméda idánaniu iwárruacoo lirrícu liá'a cuíta nánibala áulabaica; jiníwata numá irrú íchaba éenedaminaa nawárruacoo, ne jócuminaa nawárroojoo. ");
INSERT INTO aca_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Liáwinaami libárruacoo liá'a cuíta wácalica ya libáya cuíta núma, iyá yáaine bináawa imáidaminaa iyáca: ‘Wawácali, jiméecu walí cuíta núma.’ Ne léebaminaa ichuáni: ‘jócu nuá léenaa chítashia sána iyái.’ ");
INSERT INTO aca_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Néenee ichánaminau imáca: ‘Wayáwa nárra íyenaimi ya wáirra jiájcha, ya jéewidate washínaa cáaye rícuba.’ ");
INSERT INTO aca_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ne léebaminaa ichuáni: ‘Jái nunísa numá irrúi, jócu nuá léenaa chítashia sána iyái. ¡Ishírriu núcha iyá médenai máashii!’ ");
INSERT INTO aca_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Néeniminaa ícha irrúwoo cáiwinaa yáamuedacta éeu chíchichinaa, icába nawáacoo Abrahám, Isaac, Jacob ya quinínama náa'a cáiiwadedacanimi Dios chuáni báinacu yáainai Dios wánacaalactalaca, ne ya iyá najédani bináawala. ");
INSERT INTO aca_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Jiníwata náiinuminaa chóniwenaica matuínaami íiba nácueji, ya báacheeji, ya cáirricueji ya áaqueji náawacaque'iu nawáacoo náayaca Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Néenee áabiminaa chóque'e náa'a jócani cawéni cábacoo éenajta, náa'inaminaa cawénini'inaa, ya chóque'e náa'a cawénini cábacoo nayá'inaa mawénini'inaa. ");
INSERT INTO aca_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Néenee náiinu lécchoo áabi fariséobini namá'ee Jesúsru: —Jiáu mayéji áani níwata Herodes wówerri líinua jiyá. ");
INSERT INTO aca_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Jesús éeba'ee nachuáni: —Yáa namówai imá lirrú liérra újni iyáliduca: ‘Jicábateni, wáalee ya cajójcha nujéda demonio ya nuchúni náa'a bálinenaicoo ya batáijinaami nunísajoo.’ ");
INSERT INTO aca_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Ne arrúnaa nusíguia nushínaa iníjbau wáalee, cajójcha ya batáijinaami, jiníwata jócai éewau máanali báqueerri cáiiwadedacai Dios chuáni Jerusalén yúcha báawachala. ");
INSERT INTO aca_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","¡Chóniwenai Jerusalén rícu sána, chóniwenai Jerusalén rícu sána, íinuenai náa'a íiwadedeenai Dios chuáni ya íinueda íibayuni náa'a índenai irrú íinuenai náiiwa irrú Dios chuáni libánuacala nayá! ¡Chíta máanabachu nuwówai nuáawaqueda iyá nuéenibiyu, léjta ruá'a cawáamai yáawaquedau ruéenibiu rubáinaa yáajbau, ne iyá jócani wówai! ");
INSERT INTO aca_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Ne icábate, liá'a iyáctaca máaquerri'inau jinícta'inaa yáairri; ne numá irrú jócuminaa éejoo icába nuyá, cáashia líinu liá'a éerrica imácta'inaaca: ‘¡Sáictai wérri liá'a íinuerrica lijí'inaa liá'a wácalishica!’ ");
INSERT INTO aca_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Libésunateu áabai éerrii léerdi nawówa íyabactacoo, Jesús yáau líiyaca líibana néerra liá'a fariséobini wácalica, ne áabi fariséobini néeda'ee nayá natuínaa. ");
INSERT INTO aca_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Néeni lécchoo báqueerri washiálicuerri yáa Jesús náneewa, bálinerriu liyú liá'a iméemai wána lináanai. ");
INSERT INTO aca_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Jesús sáta'ee léemiu náa'a éewidenai ley nácu ya náa'a fariséobinica: —¿Tána imá iyái? ¿Dios índaminaa wachúni bálinerriu léerdi nawówa íyabactacoo, jajá o jócuweeca? ");
INSERT INTO aca_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Ne nayá namáaca'eewoo manúma. Néenee liwína liá'a bálinerricoo, lichúni'e jíni ya ta limá lirrúi léewaque'e liácuwai. ");
INSERT INTO aca_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ya fariséobinirru limá'ee: —¿Tána éenaa iyái, jicúulee o jishínaa pacáa cáctau útawi rícula, jócu ijéda liyáalimijani, áawita léerdi nawówa íyabactacoo? ");
INSERT INTO aca_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Ne jócu néewa néeba lichuánii. ");
INSERT INTO aca_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Jesús cába'inaami'e náa'a nacúmidanica namúrru yáarrubaishi mawíyii cawéni namáaca nawáaque'iu líta'aa mesa nácula, liá'ee nawítee limá'ee nalí: ");
INSERT INTO aca_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","—Jáicta báqueerri cúmida iyái áabai fiestarrui licásaque'iniu, u'iwáau náarrubai íta'aa náa'a cawénini yúcha mawí, éewerri báqueerri íinu mawí cawéni yúcha; ");
INSERT INTO aca_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ne liá'a cúmideerri iyá chámatanaa éewerri líinu limá jirrú: ‘Jimáaca liáarrubai liáni báqueerrica’. Ne ya táminaa báinata jibárruacoo jiácoo jiwáacoo último yáarrubaishi íta'aa. ");
INSERT INTO aca_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Báawacha wáucha, nuyá ma jirrú: Jáicta nacúmida jiyái, jiwáayu quéecha nácu sái yáarrubaishi íta'aa, quéewique'e áicta líinu léji liá'a cúmideerri jiyá, limá jirrú: —‘Nujúnicai, jibésunau jiwáacoo áabai yáarrubaishi cawéni mawí ítala.’ Cháminaa liwána cawéni jiyá nanáneewa náa'a wáainecoo nayá jiájcha mesa nácula. ");
INSERT INTO aca_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Jiníwata liá'a máanui jicábacoo, carrúni jináatai'inaa médacoo; ne liá'a carrúni jináatai médacoo, máanui'inaaminaa médacoo. ");
INSERT INTO aca_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Jesús má'ee lirrú lécchoo liá'a cúmideerri liyá: —Jáicta jiwáalia áabai fiesta o léerdi jíyaca, ujicúmida náa'a jijúninaica, ya jéenajinai, o wéenaa, jiní náa'a rícubini yáainai jirrú urrúni; níwata nayá lécchoo nacúmidaminaa jiyá chacábacanaa, cháminaa jinísa jimáacacoo cawéni. ");
INSERT INTO aca_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ne uliámaca, numá irrú: —Jáicta jiméda áabai fiestai, jicúmida náa'a carrúni jináatanica, náa'a jócani éewa najínacoo, náa'a tucútucuni jínacoo, ya náa'a matuínica. ");
INSERT INTO aca_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Cháminaa sáicta jiwówa. Nayácala jócani éewa napáida jiyá lijúniba, ne jiyáminaa wáaleerri'inaa jiwéniu, éerri nacáwio náa'a chóniwenai sáicanimica. ");
INSERT INTO aca_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Néemi'inaami liéni báqueerri wáairricoo liyá mesa nácula, limá'ee Jesúsru: —¡Sáicta wérri liá'a íyeerri'inaa íyacaishi máanui wérri Dios wánacaalactalaca! ");
INSERT INTO aca_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Jesús má'ee lirrú: —Báqueerri washiálicuerri méda áabai íyacaishi wérri, ya ta libánua nacúmida íchaba wérri chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Quéecha'inaami léerdicai liá'a íyacaishica, libánua lishínaa cashírruedacai lirrú líiwa nalíni náa'a nacúmidanica: ‘Déjcaa jái ya sáicai quinínamai.’ ");
INSERT INTO aca_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Ne quinínama nachána'eewoo namáaca. Limá'ee liá'a báqueerri quéechanacu: ‘Chóca rími nunísa nuwéni áabai cáinabi, arrúnaa nuáacoo nucábacani. Ne nusáta jiúcha jócubeecha máashii liyá jirrú.’ ");
INSERT INTO aca_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Báqueerri má'ee: ‘Nunísa nuwéni diez pacáa, píquedenai'inaa cáinabi, arrúnaa nuáacoo nuéneda nucába wáni. Ne nusáta jiúcha jócubeecha máashii liyá jirrú.’ ");
INSERT INTO aca_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ya báqueerri má'ee: ‘Nunísa nucásacoo chóca rími já'a, jócu nuéewa nuáacoo.’ ");
INSERT INTO aca_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Liá'a cashírruedacaica léejo'eewoo liwácali néerrau, líiwa'ee liwácalirru quinínama, jócau'u nawówai náiinuca. Néenee íiwirri wérri liwówa liá'a liwácalica, ya tá'ee limá lirrú liá'a cashírruedacai lirrú: ‘Jiá namówai madéjcanaa cáaye rícula ya plaza rícula chacáalee shínaaca, ya jínda áani náa'a carrúni jináatanica, náa'a macáwanica ya náa'a matuínica ya náa'a tucútucunica.’ ");
INSERT INTO aca_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Déecu'inaami'e mawí cashírruedacai má'ee: ‘Nuwácali, nunísa numéda jirrú jiwánani numédaca, ái újnibi já'a yáarruishi.’ ");
INSERT INTO aca_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Néenee liwácali má'ee lirrú liá'a cashírruedacaica: ‘Jiáu iníjbaa lícu ya náa'a yáainai carretera éemanacu, ya jimésuda nawówa náiinuque'e nawáarruacoo, quéewique'e cashiámu núbana. ");
INSERT INTO aca_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Jiníwata numá irrú, jiní'inaa néenaa náa'a nacúmida quéechanacu jócani'inaa éenaa náaya núya nuíibi.’ ");
INSERT INTO aca_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Íchaba chóniwenai yáau Jesús íshiirricu; jáiwa léejoo limá'ee nalí: ");
INSERT INTO aca_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ne báqueerricta íinu nulí, ya jócu caníinaa licába nuyá mawí lisálijinaa yúchau, ya litúwa, ya líinu, ya léenibi, ya léenajinai, ya léenajetoo, ya liyá jájiu mawí, jócai éewa nushínaa éewidenaicoo. ");
INSERT INTO aca_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Ne liá'a jócai wówai carrúni jináata limédacoo nunácueji, ya jócu líinu nuíshiirricu, jócai éewa nushínaa éewidenaicoo nuájcha. ");
INSERT INTO aca_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Ne báqueerricta éenaa wówai liméda áabai cuíta wérri, ¿jócuminaa quéechanacu liwáau lijútada léenacta linísacani? ");
INSERT INTO aca_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Ne áabatayu, liúcacta lidáni ya liáwinaami jócu léenaa linísacani, quinínama náa'a cábenaicani, nachána'inaa nacáidaminaa líiwanaa, ");
INSERT INTO aca_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","namá'ee: ‘Liéni washiálicuerrica lichánau liméda cuíta, ne jócai léenaa linísaca.’ ");
INSERT INTO aca_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","O báqueerri rey yáctau jináwiurru báqueerri rey júnta, ¿jócuminaa liwáau quéechanacu lijútada, léenacta diez mil soldado yáajcha léewa limédacoo lijúnta liá'a íinuerri lijúnta veinte mil soldado yáajcha? ");
INSERT INTO aca_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Ne jócta léenaa líinua yáacacoo lijúnta, áicta újnibi déecucheji liyá báqueerri reyca, libánuaminaa catéecai chuánshi yáajcha lijúnta jócubeecha naméda jináwiu. ");
INSERT INTO aca_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Cháwa licábacanaa, matuínaami éenaa jócai wówai limáaca quinínama liwáalianica, jócai éewa nushínaa éewidenaicoo nuájcha. ");
INSERT INTO aca_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Liá'a iwídumaca sáicai; ne jócta liá'a lijúwacau, ¿chítaminaa léejoo limédacoo sáicai jíni? ");
INSERT INTO aca_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","jócai éewau áawita cáinabirru, jiní léewacalau namédaque'e liyú abono. Jiní wéni náucaca. Nawáalianai nawíbau éemiu.” ");
INSERT INTO aca_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Narrúni'eewoo Jesúsru íchaba néenaa náa'a jédenai warrúwa chóniwenai yúcha gobiernorru, ya náa'a áabi chóniwenai máashiini íiwanaa cajíconaanica, lécchoo néemi'e lirrú. ");
INSERT INTO aca_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Néenee náa'a fariséobinica ya náa'a éewidenai ley Moisés shínaa natáania máashii linácu liá'a Jesúsca namá'ee: —Liáni chóniwerrica lirríshibia náa'a cajíconaanica ya líiya náajcha. ");
INSERT INTO aca_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Néenee Jesús íiwa nalí áabai licábacanaa, limá'ee: ");
INSERT INTO aca_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“¿Áicta báqueerri íibi já'a wáalierri cien oveja ne liúca áabai, jócuminaata limáaca náa'a noventa y nueveca chaléeni bacháidala, ya ta limúrru liácoo liá'a áabai oveja yúcairrimicoo cáashiaque'e líinu linácu? ");
INSERT INTO aca_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Jáicta líinu linácui, sáicta liwówa liúca liséjcu íta'auni, ");
INSERT INTO aca_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","jáicta líinu líibana néerrawai, liáawaqueda lijúninai ya náa'a yáainai lirrú urrúni, limá'ee nalí: ‘Sáicta iméda iwówau nuájcha, jáicala nuíinu linácu liá'a oveja yúquerrimicoo núcha.’ ");
INSERT INTO aca_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Numá irrú chái cábacanaa sáicta wérri wówashi áacairra báqueerri cajíconai nácueji éejuederricta liwíteu Diosru, náucha náa'a noventa y nueve chóniwenai sáicanica jócani arrúnaa éejueda nayáu Diosru. ");
INSERT INTO aca_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“O lécchoo, ¿chíta báquetoo íinetoo wáaliechocta diez monedani ya bátui yúcau rúcha, jócuminaa rutúculia áabai lámpara ya ta rujíchuda cuíta lícui, rumúrru arrájuata cáashia ruíinu linácu? ");
INSERT INTO aca_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Ne jáicta ruíinu linácui, ruáawaqueda rujúninaiu ya náa'a yáainai rulí urrúni, rumá nalí: ‘Sáicta iméda iwówau nuájcha, jáicala nuíinu linácu liá'a moneda yúquerrimicoo núcha.’ ");
INSERT INTO aca_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Numá irrú chacábacanaa lécchoo ái sáictani wówa náa'a ángelbini Dios shínaaca báqueerri cajíconaica éejueda liwíteu Diosru.” ");
INSERT INTO aca_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesús íiwadeda'ee lécchoo: “Báqueerri washiálicuerri wáaliate chámata léenibiu. ");
INSERT INTO aca_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Liá'a, mawí icúlirrijuica, limá'ee lisálijinaarru: ‘Nusálijinaa, jiá nulí léenaa liá'a nushínaa jiwáaliani nulí sái'inaaca.’ Néenee nasálijinaa shírrida nalí quinínama liá'a liwáalianica nanácu. ");
INSERT INTO aca_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Jócai íchaba éerri néenee liáwinaami, liá'a licúulee náishiimica liwénda lishínaa quinínama éenaa, ya liyú liá'a warrúwaca liáu déecuchala áabai cáinabi ítala, ligástactala máashii quinínama liá'a liwáalianica, liyácta cáwicaishi cacháninai rícu. ");
INSERT INTO aca_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ne linísa'inaami ligásta quinínama liwárruaniu, jáiwa áabai ínaaishi wérri íinu lítala liá'a cáinabi liyáctalaca, néenee liwántedani lináiwai. ");
INSERT INTO aca_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Jáiwa liáu lisáta lirrúwoo tráawaju báqueerri washiálicuerri yúcha, lítala liá'a cáinabi yáctalaca, jáiwa libánua lishínaa finca néerrau jíni litúya puíti. ");
INSERT INTO aca_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Liá'a icúlirrijuica wówerricta'ee líiya cáawaina liá'a puíti íyanibica, ne jiní yáirri líiyani. ");
INSERT INTO aca_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Néenee'e lipénsaa lirrúwoo limá'ee: ‘¡Íchaba tráawajadorbini ya nusálijinaa íibana néeni wáalianai íyacaishi yúcactacoo, nácula nuyá áani máanali nuyá nunáiu! ");
INSERT INTO aca_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nuéejoctatawai nusálijinaa íibana néerrawai, ya numáminaa lirrújoo: Nusálijinaa, numéda nujíconau Diosru ya jirrú lécchoo; ");
INSERT INTO aca_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","nuyá jócai sáicanata jimáida jicúuleeyu mawiá; jicába nuyá léjta báqueerri jishínaa tráawajadorbiniu.’ ");
INSERT INTO aca_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Néenee liwína'ee iníjbaa ya tá'ee léejocoo lisálijinaa íibana néerrawai. “Líinu'inaa déecucheji újni'ii, lisálijinaa cába'ee jíni carrúni jináata'ee licábaqui jíni. Licánaca'eewoo licúulee júntau lishíquia'ee ya lishíshi liwídani. ");
INSERT INTO aca_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Néenee licúulee má'ee lirrú: ‘Nusálijinaa, nuyá méderri nujíconau Diosru ya jirrú lécchoo. Nuyá jócai sáicanata jimáida cúuleeyu mawiá.’ ");
INSERT INTO aca_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Ne lisálijinaa má'ee nalí náa'a lishínaa chóniwenai tráawajainai lirrú: ‘Ijéda liá'a íibalashi mawí sáictaca isúwa linácuni. Ya isúwa áabai aníiyu licáaji nácu ya áabai zapato líiba nácu. ");
INSERT INTO aca_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Índa liá'a becerro mawí quéenaaca ya íinuani, wáya áani waméda'aa fiesta sáicta'a wawówa. ");
INSERT INTO aca_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Léca liáni nucúuleeca nédacanimicoo nácu máanalica, ne éejuerri licáwiacoo, nédacanimicoo nácu yúcacoo, ne wáiinu linácui.’ Jáiwa nachánau naméda fiesta sáicta nawówai. ");
INSERT INTO aca_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ne nácula liá'a licúulee nabéecanaataca chalé'e yáa bacháidala. Líinu'inaa urrúni cuítarru, léemi'e shímashi wítama yá'ee nawáilaaca. ");
INSERT INTO aca_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Néenee'e limáida báqueerri icúlirrijui, ya lisáta'ee léemiu liyá tánashia léji liérra. ");
INSERT INTO aca_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Icúlirrijui má'ee lirrú: ‘Jéenajirri jái éejuacuwai, tánda jisálijinaa wána wáiinua liá'a becerro mawí quéenaaca, licúulee éejuacalau lirrú sáica cáwicalani.’ ");
INSERT INTO aca_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Ne jáiwa'ee bájiala íiwirri liwówai, jóca'ee liwówai liwárruacoo. Néenee táda'ee lisálijinaa jiáu litáania liájcha liwówa yáajchau liwárruaque'iu. ");
INSERT INTO aca_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ne limá'ee lisálijinaarru: ‘Jicábateni íchaba camuí nutráawajaa jirrú, séewirri numéda jiwánacaala, ne jiyá jócai yáacaji nulí áabai cabra rími nuíinuaque'ini sáictaque'e nuwówa nujúnicaibini yáajchau. ");
INSERT INTO aca_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ne líinu'inaa liéni jicúuleeca, gástairri máashii jishínaa warrúwa rúmbabini nácula, ái jáji jiyá wáneerri náiinua lirrú becerro mawí quéenaaca.’ ");
INSERT INTO aca_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“Ne lisálijinaa éeba'ee lichuáni: ‘Nucúulee, jiyá séewirrinaa yáa nuájcha, quinínama liáni nuwáalianica jishínawa liérra. ");
INSERT INTO aca_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Tánda arrúnaa waméda fiesta, sáictaque'e wawówa lécchoo, léca liáni jéenajirrica nuédacanimicoo nácu máanalica, ne éejuerriu licáwiacoo, nuédacanimicoo yúcacoo, ne wáiinu linácui.’ ” ");
INSERT INTO aca_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Jesús íiwa'ee lishínaa éewidenaicoo liáni: “Báqueerri washiálicuerri rícuerri liwáaliate báqueerri túyerri lishínaa; jáiwa'ee áabi yáau náiiwa lirrú liá'a rícuerrica léca'ee liá'a limáacani túya lishínaa, gásteerri'e liyá máashii lishínaa. ");
INSERT INTO aca_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Liwácali máida'ee lirrú ya tá'ee limá lirrúi: ‘¿Tána léji liéni namáni nulí jinácucha? Jíiwadeda nulí chítashia liá'a quinínama jishínaa tráawajuca, jiyá jócai éewa jitúya nushínaa mawiá.’ ");
INSERT INTO aca_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Lédacani'eewoo lirrúwoo liá'a catúyacaimi rícuerri shínaa: ‘¿Tána'ee numéda chóquejoo nuwácali jócai yáa nulí mawiá tráawaju? Jiní nudánani nutráawajau'inaa nulíwoo cáinabi, ya báibee nujínanicoo nusáta áabi yúcha. ");
INSERT INTO aca_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ya ta nuá léenaa tánashia numédani'inaa, quéewique'e ái ríshibierri nuyá já'a nábana licúlau, jáicta numáacau jiní nulí tráawajujoo.’ ");
INSERT INTO aca_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Néenee limáida'ee bácainaa náa'a mówinianai liwácalirru. Lisáta'ee léemiu báqueerri quéechanacu: ‘¿Chíta máanaba jimówinia nuwácalirru jíni?’ ");
INSERT INTO aca_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Léeba'ee lichuáni: ‘Numówinia lirrú cien tíimbu aceite.’ Limá'ee liá'a catúyacai rícuerri shínaa: ‘Jishínaa recibo liáni yáa áani; jiwáayu madéjcanaa ya jitána áabata cincuenta, béewamicta bácaijani.’ ");
INSERT INTO aca_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Néenee liáwinaami lisáta léemiu báqueerri: ‘¿ya jiyá, chíta máanaba jimówinia lirrú jíni?’ Léeba'ee lichuáni: ‘Cien máanabaca trigo ínaabishi.’ Limá'ee lirrú: ‘Jishínaa recibo liéni; jiméda áabata ochenta, béewamicta máayabacajani.’ ");
INSERT INTO aca_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Liá'a liwácali yáa léenaa licába liá'a limáacani wánacaala, yáairri léenaa liyá liméda léjta liwówau'u. Ne jáicta chúnsai nashínaa negocioca, náa'a máinecoo éerri rícu, mawíni cáwi tuí naméda nashínau, náucha náa'a éewidenai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ne nuá iwítee iyá wáalianai irrícucau éerri rícu cajíconaica, igáanaque'e ijúninaiu, quéewique'e jáicta amáarra rícucaishi áani, narríshibia iyá nábana licúlau jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","“Liá'a sáicai médacoo áulabai yáajcha, cháminaa cábacanaa lécchoo sáica limédacoo íchaba yáajcha; ne liá'a jócai sáica áulaba yáajcha, chái cábacanaa lécchoo jócai éewa sáica limédacoo íchaba yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Ne cháwa cábacanaa, liyú liáni rícucai éerri rícu sái cajíconaica, iyá jócani sáica médacoo, ¿tánaminaa éewida'inaacu yáawaa, nácta irrú liá'a rícucai jócai amáarra? ");
INSERT INTO aca_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ne jóctaca imédau sáica liájcha liá'a jócai ishínaa, ¿tánaminaa yáa irrú ishínaa'inaa yáawaa? ");
INSERT INTO aca_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Jiní cashírruedacai éewacala lishírrueda chámata liwácanairru; jiníwata máashiiminaa licába báqueerri ya caníinaa licába báqueerri, o machácaniwee báqueerrirruni o lichániwee báqueerri. Jócai éewa washírrueda Diosru ya rícucairru.” ");
INSERT INTO aca_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Náa'a fariséobinica máanalini warrúwa nácu, néemi'inaa quinínama liáni nacáida'ee Jesús náawa. ");
INSERT INTO aca_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Jesús má'ee nalí: “Iyá wanárra bésunenaicoo sáicaniyu chóniwenai náneewa, ne Dios yáirri léenaa iwówa; ne liá'a washiálicuerri wáaliani áacai mawí, Dios cháanini. ");
INSERT INTO aca_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Jócu'inaami Juan Bautista íinu újnibi, Dios wówerricta nayá náa'a chóniwenaica áabenaa nawówa liájcha liá'a leyca ya liá'a natánanimica náa'a cáiiwadedacanimi Dios chuáni. Néeneete nuíiwadeda sáicai chuánshica Dios wánacaalactala nácu, ya quinínama naméda nadánaniu quéewiquinicta nawárruacoo. ");
INSERT INTO aca_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","“Mawí jócu tráawaju amáarra liá'a éerrica ya cáinabi liúcha liá'a licúmpliacoo quinínama tánerricoo ley rícu. ");
INSERT INTO aca_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Báqueerri washiálicuerri máacacta líinuu ya léeda líinuu báquetoo, liméda máashii líinayu; ya liá'a éederri líinu ruá'a máaquechoo rúnirriu, chái lécchoo méda máashii líinayu. ");
INSERT INTO aca_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Báqueerri washiálicuerri rícuerri yáate, séewirrinaa lisúweda líibala cawéninamai ya sáicabeetai, ya éerri jútainchu liméda fiesta máanui wérri. ");
INSERT INTO aca_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Báqueerri lécchoo carrúni jináatai jí'ineerri Lázaro, yáairri cacháunai wérri liwá'eewoo cáinabi rícu líibana núma lícu liá'a rícuerrica. ");
INSERT INTO aca_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Liéni washiálicuerri carrúni jináataica wówerri'e cáawaica liyú liá'a íyacaishi tábi cáirricoo rícuerri shínaa mesa ítacha; yá'ee áuli narrúni'eewoo nabérruda lichúrruani. ");
INSERT INTO aca_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Áabai éerri'e máanali léji liá'a carrúni jináataimica, yá'ee náa'a ángelbinica natée'e liyá Abrahám néerra paraíso rícula. Liá'a rícuerrimi máanali lécchoo jíni, jáiwa'ee nabáya jíni. ");
INSERT INTO aca_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","“Nácula carrúni jináata rícuerri yáca náarrui rícula náa'a máanalinica, linácuda'ee linániu licába'ee déecucheji Abrahám, ya Lázaro liájcha. ");
INSERT INTO aca_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Néenee'e limáidada liá'a rícuerrica limá'ee: ‘¡Nuwérri Abrahám, carrúni jináata jicába nuyá! Jibánua Lázaro jisábida licáaji juátau shiátai yáacula, ya líinuque'e lidúji nuínanee náculani, níwata carrúni jináata nuyá bájialanaa lirrícu liáni chicháica.’ ");
INSERT INTO aca_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Ne Abrahám éeba'ee lichuáni: ‘Nutáqueerri, jédacaniu linácu liá'a sáica'umi jiyá cáinabi íta'aa, yá'ee Lázaro máashiimiyaca. Chóque'e sáicta lirríshibia liméda liwówau áani, ya nácula jiyá carrúni jináata. ");
INSERT INTO aca_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nácula liúcha liáni, ái áabai carrátalia wérri wáucha wáacoo já'a ya jiájcha; tándawa náa'a wówerri nabésunacoo mayéji áani jiyáctalaca, jócani éewa nabésunacoo, áawita náa'a yáaine chérra wówai nabésunacoo máyala áani, jócani éewa lécchoo nabésunacoo máyala áani. ");
INSERT INTO aca_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Limá'ee liá'a rícuerrica: ‘Nusátani wérri jiúcha, nuwérri Abrahám, jibánuaque'e Lázaro nusálijinaa íibana néerra, ");
INSERT INTO aca_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","nuwáaliacta cinco nuéenajinaiu, quéewique'e litáania líiwa nalí, jócubeecha náiinu máyala áani carrúni jináata nuyá.’ ");
INSERT INTO aca_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Abrahám éeba'ee lichuáni: ‘Nayá jái wáalia liá'a Moisés tánanimica ya nachuánimi náa'a cáiiwadedacanimi Dios chuáni báinacu; ¡namédaque'e nawánacaala!’ ");
INSERT INTO aca_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Léeba'ee liá'a rícuerrimica: ‘Jajá, nuwérri Abrahám, ne báqueerri máanalimicta éejoo licáwiacoo, ya líiyadau nalí, ya táminaa néejueda nawíteu.’ ");
INSERT INTO aca_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Ne Abrahám má'ee lirrú: ‘Ne jócta nawówai néemi Moisés chuánimi tánerricoo, ya nachuáni náa'a cáiiwadedacanimi Dios chuáni báinacu, jócuminaa néebida lécchoo áawitata báqueerri máanali cáwiacoo nalí.’ ” ");
INSERT INTO aca_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Jesús ma nalí náa'a éewidenaicoo: “Ái séewirrinaa cúmideerri naméda jíconaashi; ne ¡carrúni jináatai liá'a washiálicuerri wáneerri naméda najíconau! ");
INSERT INTO aca_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Sáicaita liérra chóniwerri náuca manuá yáaculani nabáji liwáa nácu bátui íiba máanui wérri, liwánaca naméda najíconau náani júbini rímica. ");
INSERT INTO aca_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","¡Cáwiwa yúchajoo! “Jéenajirri médacta máashii jirrú, jiárra liyá; ne licámbiacta liwíteu, jimíya máecha lijíconaa limédani jirrú. ");
INSERT INTO aca_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Éewita liméda jirrú máashii sietechu áabai éerri, ya sietechu líinu limá jirrú: ‘jóca nuéejoo numéda jirrú máashii’, sietechu arrúnaa jimíya máecha lijíconaa.” ");
INSERT INTO aca_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Náa'a apóstolu nasáta Jesús yúcha: —Jiá walí wéebidaque'e mawí. ");
INSERT INTO aca_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Jesús éeba'ee: —Iwáaliactata éebidau, éewita píitui rími, léjta bátui líta íimi liá'a mostaza, éewa imá lirrú liáni banácali jí'ineerri sicómoro: ‘Jéerruau wayéji áani, ya jiáabanau manuá yáacula’, ya banácali liméda liwánacaala. ");
INSERT INTO aca_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Báqueerri éenaa liwáaliacta báqueerri cashírruedacai éejuerriu bacháideji liáwinaami liyá lipúrreda cáinabi o litúya pacáa, ¿Limáminaa, jiwárroo jiwácoo jíyaca? ");
INSERT INTO aca_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","jócai, újni limá lirrú: ‘jiwárroo jichúni núyanibi, ya lístau quéewique'e jiméda nuwánacaala, nácula núya ya nuíirra. Liáwinaami jéewa jíya ya jíirrai.’ ");
INSERT INTO aca_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Ya lécchoo jócani liá sáicai cashírruedacairru, tánashia liá'a liwána limédaca. ");
INSERT INTO aca_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Cha lécchoo iyá, jáicta inísa iméda quinínama liá'a Dios wánani limédaca, ya ta éewa imáca: ‘Wayá cashírruedacani jócani cawéni, níwata waméda bácai liá'a arrúnai wamédaca.’ ");
INSERT INTO aca_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Quéecha'inaa'ee Jesús yáacoo Jerusalén néerra, libésunau béewami náa'a cáinabica jí'ineenai Samaria ya Galilea. ");
INSERT INTO aca_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Liwárrua'inaa'eewoo áabai chacáalee rími rícu, najiáu lijúnta náa'a diez washiálicuenai bálineneu chorrówa nácu, nabárrua'eewoo déecucheji, ");
INSERT INTO aca_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","namáidada'ee cadánani namá'ee: ¡Jesús, quéewidacai, carrúni jináata jicába wayá! ");
INSERT INTO aca_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Licába'inaa'ee nayá liá'a Jesúsca, limá'ee nalí: —Yáau íyadacoo sacerdótebinirru. Nácula'ee náawai, sáica jíni náa'a bálineneemicoo. ");
INSERT INTO aca_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Néenee'e báqueerri néenaa licába'inaa sáica liyái, léejua'eewoowai liá'ee Diosru sáicai cadánani, ");
INSERT INTO aca_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","litúyau linánimiyu cáinabi nácula Jesús náneewa, liá lirrú sáicai. Liáni washiálicuerrica, licáinaberra jí'ineerri Samaria. ");
INSERT INTO aca_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Néenee'e Jesús má'ee: —¿Ya jócai diez namáanabaca náa'a chúneneecoo? ¿Ya náa'a nueve, tanácucha nayá jíni? ");
INSERT INTO aca_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","¿Jiní éejueneu náa Diosru sáicai mawí bácai rími liáni déecucha sáica? ");
INSERT INTO aca_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Néenee'e Jesús ma lirrú, —Jibárroo, jiá namówai, jéebidacala sáica jiyá. ");
INSERT INTO aca_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Náa'a fariséobini nasáta néemiu Jesús, chacálita'inaa líinu liá'a Dios wánacaalactaca, ya liyá léeba náuchani: —Jáicta líinu Dios wánacaalactaca iyá jócainaa jéewa icábaca. ");
INSERT INTO aca_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Jiní namá irrú: ‘Liáni yáa áani’, ‘jócta liá'a yáa á'a’; níwata Dios wánacaalactaca jái yáa íibii. ");
INSERT INTO aca_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Ya Jesús ma lishínaa éewidenaicoo: —Líinuminaa éerri iwówaiminaa icábacani nuyá Washiálicuerri Dios Cúuleeca, ne jócaiminaa icába. ");
INSERT INTO aca_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Áabi máminaa: ‘Liáni yáa áani’, jócta ‘Liá'a yáa á'a’; ne oyáau néerra, jiní isíguiacalani. ");
INSERT INTO aca_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Cháminaajoni icába éenu bérrudeerrica jáicta liquénai quinínama éerri rícu, cháminaa nuíinucojoo nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ne quéechanacu rúnaa nusúfria bájialanaa, ya nacháani nuyá náa'a chóniwenai liyáali éerri. ");
INSERT INTO aca_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Cháminaa libésunacoo léjta Noé yá'inaami, cháminaa libésunacoo lécchoojoo liáni éerrica rícu léejocta'inaacoo nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Chóniwenai liyáali éerrimi íyenai ya íirrenai ya lécchoo cáseneu, cáashia líinu liá'a éerrica Noé wárrua'inau barco rículai, líinu'inaa liá'a únésacaca, ya quinínama máanali nayá. ");
INSERT INTO aca_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Chacábacanaa libésunacoo léjta Lot yá'inaami: Yáanimi rícu, chóniwenai cha nawíteemija náaya ya náirra, nawéni ya nawénda, ya náabana ya naméda nábanau; ");
INSERT INTO aca_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Ne Lot jiá'inaawai liúcha liá'a chacáalee Sodomaca, liúwa'eewau éerri rícue chichái, ya azufre amuáiyii lécchoo ya quinínama máanali nayái. ");
INSERT INTO aca_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Cháminaa liéni éerri rícu líyadaminaa nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Liyáali éerrijoo, líinuni nácujoo cuíta íta'aa, liúrrucoo liáque'iu machácani, jócubeecha liwárroo cuíta rícula léeda lishínaa liá'a yéerri lirrícu; liá'a yéerri bacháida rícu, jócubeecha léejoo cuíta néerra. ");
INSERT INTO aca_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Édacaniteu runácu ruá'a Lot íinumica. ");
INSERT INTO aca_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Liá'a cáarrui máanali Dios jí'inaa nácu, liúcaminau; ne liá'a jócai cáarru máanalica Dios jí'inaa nácu, léeminaa wárruau Dios yáctalaca. ");
INSERT INTO aca_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","“Numá irrú liyáali táayee nayáminaajoo chámata máaminaa nayá áabai yáarrubaijaa íta'aa: Báqueerriminaa yáujoo, ya báqueerriminaa máacaujoo. ");
INSERT INTO aca_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Chámata íina júlenai nayáca molinoyu, báquetoo yáaicho'inau, báquetoo máaquecho'inau.  ");
INSERT INTO aca_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Chámata washiálicuenai yéenai bacháida rícu: báqueerri yáairri'inau, báqueerri máaquerri'inau. ");
INSERT INTO aca_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Néenee nasáta néemiu Jesús: —¿Nuwácali, tanácucha'inaa libésunau léju liérra? Néenee'e limá nalí: —Táshia liyácta liá'a máanalimi, náiinuminaa náa'a wáachulica néerra. ");
INSERT INTO aca_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Jesús íiwa'ee nalíni áabai licábacanaa léewidaque'e na'óraca jócubeecha sámu nayá. ");
INSERT INTO aca_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Limá nalí: “Ái báqueerri washiálicuerri já'a áabai chacáalee rícu, báqueerri wánacaleerri, jócai cáarru cába Dios, jócai cawáunta chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Liyá chacáaleeca ái báquetoo máanirriu, ruá'eewau liyáctala liá'a wánacaleerrica liyúdaque'e ruyá licástigaaque'e liá'a washiálicuerrica méderri rulí máashii. ");
INSERT INTO aca_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Íchaba éerri liá'a wánacaleerrica jócai liwówai liyúda ruyá, ne liáwinaami lipénsaa: ‘Áawita jócu cáarru nucába Dios, jóca cawáunta washiálicuenai lécchoo’, ");
INSERT INTO aca_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ne néenee léjta ruáni máanirriuca éerrii jútainchu ruíinu rutáania nuájcha nuyúdaque'e ruyá rushínaa pleito nácu, ya tácoojoo nuyúda ruyájoo, jócubeecha ruíinu usébica nuwówa mawiá.” ");
INSERT INTO aca_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Jesús má'ee nalí mawí: “Léewa limáni liáni washiálicuerri wánacaleerrica máashiica. ");
INSERT INTO aca_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Wée, sáica cajáni, ¿ya jócuminaa Dios túya lécchoo náa'a éebidenai linácu sátenaicoo liúcha éerri jútainchu ya táayee? ¿Liwánaminaa nanéndaca? ");
INSERT INTO aca_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Numáminaajoo léemiminaa ya liyúda nayá madéjcalicunaa. Ne jáicta nuyá Washiálicuerri Dios Cúuleeca nuíinu, nuíinuminaa náa'a chóniwenai yéenai cáinabi íta'aa, ¿áani újni éebida nunácu já'a?” ");
INSERT INTO aca_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Jesús íiwa'ee nalí liéni áabai licábacanaa áabibirru máine'e nalíwoo nayá sáicani wítee náucha náa'a áabica: ");
INSERT INTO aca_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Chámata washiálicuenai yáaineu templo néerra na'óraca: báqueerri fariseo ya báqueerri liérra cacóbracai impuesto Romarru. ");
INSERT INTO aca_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Liá'a fariséoca, libárruau li'óracoo chá'a: ‘Oh Dios, nuyá nuá jirrú sáicai jiníwata nuyá jócai cha léjta náa'a áabica, canédini, máashiica, méderri líinayu máashii líinu yúchau, ya jiníwata jócala cha nuyá léjta liérra cáwaquedacai warrúwa chóniwenai yúcha. ");
INSERT INTO aca_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Nuyá nuyúnaa chámai éerri semana nácu, ya nuá diezmo liá'a quinínama nugáananica.’ ");
INSERT INTO aca_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Ne liá'a cáwaquedacai warrúwa chóniwenai yúcha, limáaca'eewau déecuchata, jócai wíta'ee nácuda linániu áacairra, ta jiáirriu cáinabi nácula cáiwii ya liwówa lícu limá'ee: ‘¡Oh Dios, carrúni jináata jicába nuyá, nuyá cajíconai!’ ");
INSERT INTO aca_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Numá jirrú liá'a cacóbracai impuesto, léejo'eewoo líibana néerrau jái Dios pérdonaa jíconaa, ne liá'a fariseo jócai Dios pérdonaa jíconaa. Ne liá'a máanui wérri cábacoo, jócainaa cawéni; liá'a carrúni jináatai cábacoo jiníca, léewani máanui'inaa Dios yáa wítee.” ");
INSERT INTO aca_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Náinda'ee Jesúsru sáamanai júbini lécchoo lidúnuque'e nanácu, quéewique'e Dios yúda nayá. Nacába'inaa'ee jíni náa'a éewidenaicoo, nárra'ee nayá náa'a índenai sáamanai. ");
INSERT INTO aca_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Néenee'e Jesús máida sáamanairru limá'ee: —Imáaca náarra sáamanaica náiinuque'e nuyáctala, o'íyabaida nayá, nayácala jicá'a sáamanai nawárruaminau á'a Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Yáawaiyii numá irrú, táanashia jócai wówai Dios wánacaalactala liyá léjta báqueerri samálita, jócaiminaa'ee liwárruau lirrícula liá'a Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Báqueerri washiálicuerri wánacaleerri lisáta'ee léemiu Jesús: —Quéewidacai sáicai, ¿tána'inaa numédai nuéewaque'e nuéenaa liá'a cáwicashi jócai amáarra? ");
INSERT INTO aca_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Jesús éeba'ee lirrú: —¿Tánda jimá nulí sáicaca nuyá? Sáicai ái já'a bácai rímii: Dios. ");
INSERT INTO aca_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Jái jiá léenaa linácu liá'a Dios bánuanica: ‘Ujiméda jíinayu máashii báquetoo íinetoo yáajcha, ujíinua, ujinédu, ujiméda jinúma yúwicau báqueerrirru, ya cawáunta ya jitúya jisálijinaarru ya jitúwa lécchoo.’ ");
INSERT INTO aca_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Liá'a washiálicuerrica limá'ee Jesúsru: —Quinínama nucúmplianicai quéecha'inaa icúlirrijui nuyá. ");
INSERT INTO aca_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Quéecha'inaa Jesús léemiqui jíni, Jesús má'ee lirrú: cháucta jibéecha áabata mawí: jiwénda quinínama liárra jiwáalianica jiáque'e nalíni náarra carrúni jináatanica. Ya táminaacojoo jiwáalia mawíjoo áacairra. Néenee jíinu chérra jisíguia nuyá. ");
INSERT INTO aca_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Né'e léemi'inaa liá'a washiálicuerrica liáni, jáiwa'ee máashii liwówai, níwata liyá rícuerri wérri. ");
INSERT INTO aca_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Jesús cába'inaa máashii liwówa liá'a washiálicuerrica, Jesús má'ee: —¡Tráawajui wérri nalíwoo náa'a rícubinica nawárrua'inau Dios wánacaalactalaca! ");
INSERT INTO aca_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","jócaiminaa tráawaju lirrú liá'a caméeyuca liwárruaque'iu lituí rícu liá'a ishídui yájuca, tráawajui wérri nalíwoo náa'a rícubinica nawárrua'inau Dios wánacaalactalaca. ");
INSERT INTO aca_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Náa'a éemenaicani nasáta'ee néemiu: —¿Tána éenaa liácoo Dios néerrai? ");
INSERT INTO aca_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Jesús éeba'ee nalí: Liá'a jócai washiálicuenai éenaa namédaca, Dios éenaani limédaca. ");
INSERT INTO aca_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Pé'eru má'ee lirrú: —Nuwácali, wayá máaquenai quinínama washínau wasíguiaque'e jiyá. ");
INSERT INTO aca_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Jesús éeba'ee lirrú: —Yáawaiyi numá irrú tánashia máaquerri nunácueji, líibanau, ya líinu, ya léenajinai, ya lisálijinaa, ya léenibi lécchoo, ");
INSERT INTO aca_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","lirríshibiaminaa máanui wérri áani líta'aa liéni cáinabica, ne liáwinaami liá'a cáwicashi áani, lirríshibia licáwica jócai amáarra áacairra. ");
INSERT INTO aca_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Jesús máida'ee báawachala náa'a lishínaa doce éewidenaicoo, limá'ee nalí: “Chóquejoo wáaminaujoo chaléeni chacáalee Jerusalén néerra, licúmpliactala'inaacoo quinínama namánimi náa'a íiwadedeene Dios chuáni báinacu natánanimica urrúnicala jíni nuyá Washiálicuerri Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Néejuedaminaajoni nuyá nalí náa'a chóniwenai báawache sánaca, nacáidaminaa nuyájoo, máashiiminaa nanúma nulíjoo, nawísadaminaa nuyájoo. ");
INSERT INTO aca_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Nabásedaminaa nuyájoo ya náiinuaminaa nuyájoo; ne matálii éerri rícula nuéejoo nucáwiacoo báaniu.” ");
INSERT INTO aca_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Nayá jócai yáa léenaa néemi quinínama Jesús mánica, jiní náacala léenaa liá'a litáaniani nácu, ne áabi jócai néenaa náa léenaa nácu. ");
INSERT INTO aca_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Urrúni'inaa Jesús íinu lirrú liá'a chacáalee Jericóca, báqueerri matuíyii wáairriu liyá iníjbaa éemanacu, sáteerri liyá tánashia náani lirrúi. ");
INSERT INTO aca_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Léemi'inaa'ee nawítama bésunacoo náa'a chóniwenaica, lisáta'ee léemiu tána jinárra. ");
INSERT INTO aca_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Namá'ee lirrú Jesús Nazaret néenee sái liérra bésunau árra, ");
INSERT INTO aca_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","liá'a matuíyiica limáida'ee: —¡Jesús, David cúulee, carrúni jináata jicába nuyá! ");
INSERT INTO aca_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Náa'a yáainecoo libéecha jáiwa'ee nacáita jíni, manúmata jíyabau, ne liyá liá'a matuíyiica limáidada mawí cadánani: —¡David cúulee, carrúni jináata jicába nuyá! ");
INSERT INTO aca_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Néenee'e Jesús libárroowai liwána naíndacani. Urrúni'inaa'ee liyá líinu Jesús néerra lisáta'ee léemiu liyá: ");
INSERT INTO aca_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","¿Tána jiwówai numéda jirrúi? Liá'a matuíyiica má'ee Jesúsru: —Nuwácali, nuwówai jiá nulí nutuí nuéewaque'e nucába báaniu. ");
INSERT INTO aca_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Jesús má'ee lirrú: —¡Jiwáalia jituí báaniu! Jiwáaliaca jéebidaca nunácu sáica jiyái. ");
INSERT INTO aca_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Liyáalimi'eewai licábai, jáiwa'ee liáwai Jesús íshiirricu liá'ee lirrú sáicai Diosru. Quinínama náa'a chóniwenaica nacábani, má'ee sáicai Diosru lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Néenee Jesús wárruawai á'a Jericó rícula libésunacta'eewoo liácoo néerra. ");
INSERT INTO aca_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ái báqueerri washiálicuerri néerra jí'ineerri Zaqueo, nawácali náa'a jédenai impuesto Romarru. ");
INSERT INTO aca_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Liwówa'ee licábacani tánashia jíni liá'a Jesúsca, ne jócai léewa licábacani jócta'ee íchaba chóniwenai yá'ee bájiala píituicani liá'a Zaqueoca. ");
INSERT INTO aca_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Jáiwa licánacawai Jesús béecha néenee líirrawai áabai áicuba nácu jí'ineerri sicómoro quéewique'e licábacani á'a libésunacta'inaacoo liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Quéechanacu Jesús íinuca chalé'e liyáctala liá'a Zaqueoca, licába'ee áacairra, néenee'e licába jíni. Licába'inaa jíni, néenee'e limá lirrúi, “Zaqueo, jiúrrucoo cálicu chérra, arrúnaaca numáacacoo wáalee jíibana néerra.” ");
INSERT INTO aca_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Néenee'e liúrrucua'eewoowai madéjcalicu sáicta wérri liwówa licúmida Jesúsca líibana néerrau. ");
INSERT INTO aca_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Nacába'inaa quinínama léji liáni, natáania'ee máashii linácu liá'a Jesúsca, namá'ee liácala'eewoo limáacacoo chaléeni liájcha liá'a cajíconaica. ");
INSERT INTO aca_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Náiinu'inaa líibana néerra liá'a Zaqueoca, néenee liáwinaami Zaqueo bárruawai limá'ee liwácalirru: —Jicábateni, Nuwácali, nuáni'inaa nalí náa'a carrúni jináata béewami liá'a nushínaaca. Tánashia nunéduni náucha náa'a áabica, nuéejueda nalí cuatro mawí. ");
INSERT INTO aca_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Néenee Jesús má'ee lirrú: —Wáalee líinu liwáseda iyá quinínama náani yáainai lirrícu liáni cuítaca, liyácala liáni washiálicuerrica chái lécchoo litáqueerrimica liá'a Abrahámca. ");
INSERT INTO aca_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Táda'ee nuyá, liá'a Washiálicuerrica Dios Cúuleeca, nuyá íinuerri numúrruca ya nuwásedaca cajíconaani náa'a chóniwenai yúquenaimicoo nayáca. ");
INSERT INTO aca_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Náa'a chóniwenaica éemenai nayáca Jesús máni liyáca quinínama liáni, jáiwa líiwa nalí áabai licábacanaa, jiníwata urrúnicala náiinu náacoo Jerusalénra, yá'ee napénsaa náacoo linácu liá'a Dios wánacaalactaca jáicala'ee líinu liyáalimi. ");
INSERT INTO aca_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Limá'ee nalí: —Báqueerri washiálicuerri cawénii yáte, jáiwa'ee liáu déecuchala áabai cáinabi ítala, quéewiquini'e namáaca reyni ya ta léejocoo néenee. ");
INSERT INTO aca_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Jóctana'e liájau limáida'ee lishínaa diez tráawajadorbiniu, liá'ee nalí bácainaa manuába warrúwa, ya tá'ee limá nalí: ‘Itráawajaa liyú liáni warrúwaca cáashia nuéejocoo.’ ");
INSERT INTO aca_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Ne chóniwenai lishínaa cáinabi lítala sánaca jócai nawówai liyá, nabánua líshiirricu áabi téenee lirrú áabai chuánshi máirri'e: ‘Jócu wawówai liéni washiálicuerri washínaa reyyu.’ ");
INSERT INTO aca_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Ne máayabaca limáacacoo reyyui ya tá'ee léejuacuwai lishínaa cáinabi ítala. Quéecha'inaami líinuca libánua namáida lishínaa tráawajadorbiniu, náa'a léejuedaminaa nalí warrúwa, quéewique'e liá léenaa chítashia máanaba nagáana jíni bácainaa. ");
INSERT INTO aca_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Quéechanacu sáica líinu'e líyadacoo limá'ee: ‘Nuwácali, jiwárruani dáwinerriu mawí diez máanabachu lítala mawí.’ ");
INSERT INTO aca_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Rey éeba'ee lichuáni: ‘Sáicai wérri, jiyá tráawajador sáicai wérri; machácanicala jimédacoo áulaba yáajcha, numáacaminaa jiwánacaalaca diez chacáalee.’ ");
INSERT INTO aca_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Líinu'e líyadacoo báqueerrica lishínaa tráawajador, limá'ee: ‘Nuwácali, jiwárruani dáwinerriu cinco máanabachu mawí.’ ");
INSERT INTO aca_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Rey éeba'ee lichuáni liéni lécchoo: ‘Jiyáminaa numáaca jiwánacaala cinco chacáalee.’ ");
INSERT INTO aca_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ne báqueerri líinu'e líyadacoo limá'ee: ‘Nuwácali, jiwárruani liáni ya áani. Nuwáaliawa nudájidaqui jíni wárrumashidami íibi; ");
INSERT INTO aca_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","cáarruwa nucába jiyái, níwata jiyá washiálicuerri camáashiicaica, yáawaquederri jócta jimáacani ya jiáawaqueda banácali jócta cáji jiáabana.’ ");
INSERT INTO aca_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Néenee limá'ee lirrú liá'a reyca: ‘Tráawajador máashii, jichuániyuja nuá jijíconaa. Ne jiácta léenaa washiálicuerri camáashiicai nuyá, nuáawaqueda jócta numáacani ya nuáawaqueda banácali jócta nuáabana, ");
INSERT INTO aca_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","¿tánda jócu jitée nuwárruani lirrícula liá'a cuíta nawáaliadacta warrúwa, quéewiquinicta jéejueda nulí ligáananica jáictata nuéejoo cuíta néerrai?’ ");
INSERT INTO aca_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Rey má'ee nalí náa'a yáaine néeni: ‘Éeda liúcha warrúwa liárra, ya yáa lirrúni liá'a gáneerri diez máanabachu mawí.’ ");
INSERT INTO aca_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Namá'ee reyrru: ‘Wawácali, ¡ne liyá ái wáalia diez máanabachu mawí!’ ");
INSERT INTO aca_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Léeba'ee liá'a reyca: ‘Ne numá irrú, liá'a wáalierri, náaminaa lirrú mawí; ne liá'a jiní wáaliani, áawita áulabai liwáalianica nédaminaa liúchani. ");
INSERT INTO aca_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ya náa'a nujínai jócanimi wówai rey nuyá, índa áani áani ya ta íinua nunáneewa jíni.’ ” ");
INSERT INTO aca_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Liáwinaami limá quinínama liáni, Jesús síguia lishínaa iníjbau Jerusalénra. ");
INSERT INTO aca_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Quéecha'inaami urrúni líinu nalíi náa'a chacáalee júbini jí'ineenai Betfagé ya Betania, urrúni lirrú liá'a dúuli jí'ineerri Olivos, libánua'ee chámata lishínaa éewidenaicoo, ");
INSERT INTO aca_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","limá'ee nalí: —Yáau narrícula náa'a chacáalee júbinica yáainai ijúntami, jáicta íinu néerrajoo íinuminaa áabai burro bájerriu, jiní íirraniu íta'aa újnibi. Iwásedani ya índa nulíni. ");
INSERT INTO aca_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ne áicta sáteerri léemiu iyá já'a tádashia iwásedani, imá lirrú wawácali rúnaani. ");
INSERT INTO aca_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Náa'a éewidenaicoo ná'inaami'eewoo náiinu linácu quinínama léjta Jesús máyu'u nalí. ");
INSERT INTO aca_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Nácula nawáseda nayáca liá'a búrroca, nawácali sáta'ee léemiu nayá: —¿Tánda iwásedani? ");
INSERT INTO aca_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Nayá néeba'ee lichuáni: —Jiníwata Wawácali rúnaani. ");
INSERT INTO aca_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Ne nadáquinia'ee náabalau burro íta'aa, natée'e jíni Jesúsru nawá'ee líirracoo líta'aa. ");
INSERT INTO aca_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Léjta Jesús jínau'u liácoo, náa'a chóniwenai nadáquinia'ee náabalau iníjbaa lícu. ");
INSERT INTO aca_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Ya urrúni'inaami liúrrucocoo liácoo dúuli ítacha jí'ineerri Olivos, quinínama náa'a yáainecoo liájcha nachánau namáidadaca nawówa chúnicau náa sáicai Diosru quinínama linácueji liá'a jócai nacába cáji. ");
INSERT INTO aca_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Namá'ee: —¡Sáicta wérri liá'a rey íinuerri Wawácali jí'inaa nácu! ¡Sáictacta nawówa áacairra ya licámarra áacairra wérri! ");
INSERT INTO aca_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Néenee áabi fariséobini yáainai chóniwenai íibi namá'ee Jesúsru: —Quéewidacai, jiárra náarra jínanenaicoo jiájcha. ");
INSERT INTO aca_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Ne Jesús éeba'ee nachuáni: —Ne numá irrú náctaca manúmata náani, íiba máidadaminaa. ");
INSERT INTO aca_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Quéecha'inaami urrúni líinu Jerusalénra, licába'inaami liá'a chacáaleeca Jesús íicha'ee linácueji, ");
INSERT INTO aca_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","limá'ee: “¡Jiáctata léenaa, linácueji liéni éerrica liá'a éewerri liá jirrú sáitaque'e liwówa! Ne chóque'e liá'a báyeerricoo jiúcha jócainaa jéewa jicábaca níwata jicháanica nuyá. ");
INSERT INTO aca_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Ne líinuminaa ítala liá'a éerri máashiica, jijínai naméda pared máanui jitéeji ayáacai áani, narríjcuedaminaa jiyá ya natáca iyá matuínaami, ");
INSERT INTO aca_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ya táminaa namárda iyái quinínama. Náiinuaminaa quinínama chóniwenai yáainai jirrícu, jiníminaa namáacani jirrú áawita bátui íiba lítaba wáacoo, jiníwata jócala jiá léenaa jéemica éerdi Dios bánua nuwáseda iyá.” ");
INSERT INTO aca_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Liáwinaami liéni, Jesús wárroo templo rícula ya jáiwa lijéda néenee náa'a wéndenai nayá lirrícu, ");
INSERT INTO aca_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ya limá'ee nalí: —Á'a cáashta íta'aa Dios chuánica limá: ‘Núbanaminaa, cuíta nasátacta'inaacoo’, ne iyá imédani áabai cuíta chaléjta canédibini íibana. ");
INSERT INTO aca_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Éerri jútainchu Jesús éewida templo rícu, ya náa'a sacerdótebini wácanaica ya quéewidacanica ley shínaa, ya náa'a lécchoo chacáalee wácanaica, namúrru namáacoo chítashia náiinua'inaa Jesús. ");
INSERT INTO aca_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Ne jócu náiinu chítashia namédau'inaa jíni, jiníwata quinínama chóniwenai éemenai nayá nawówa yáajchau liá'a limánica. ");
INSERT INTO aca_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Áabai éerri, nácula Jesús yáa liyá templo rícu, léewida liyá náa'a chóniwenaica ya líiwa nalí Dios chuáni, náiinu náa'a nawácanai náa'a sacerdótebinica, ya náa'a éewidenai ley shínaaca, náajcha náa'a salínaica. ");
INSERT INTO aca_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Ya namá'ee lirrú Jesúsca: —¿Tánayu jéewa jiméda léji liáni? ¿Tána yáa jirrú jíni liérra jidánanica? ");
INSERT INTO aca_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Jesús éeba'ee nalí: —Nuyá nusáta nuéemiu iyá lécchoo. Éeba nulí: ");
INSERT INTO aca_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","¿Tána bánua Juan báutisacai, Dios o washiálicuenai? ");
INSERT INTO aca_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Jáiwa'ee natáania nalí wáacuwai: “Wamá lirrú Dios bánuani, limá walí: ¿Táda jóca éebida lirrú jíni? ");
INSERT INTO aca_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Quiní wéewa wamá lirrú jáica washiálicuenai jíni, táda chóniwenai wówai náiinua wayá íibayu, quinínama néebidaca Dios bánuaca Juan báutisaca.” ");
INSERT INTO aca_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Jáiwa éeba'ee lichuáni jócala náa léenaa tánashia bánua Juan báutisacai. ");
INSERT INTO aca_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Néenee Jesús éeba'ee nachuáni: —Ne nuyá lécchoo jócai nuíiwa irrú tánashia dánaniyu jíni numéda léji liáni. ");
INSERT INTO aca_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jáiwa lichána litáania nalí chóniwenai ya líiwaque'e liáni licábacanaaca: —Báqueerri washiálicuerri yáabaneerri áabai shínaashi uva, jáiwa limáaca nalí liá'a cáinabi shínaashi yáctaca nalí náa'a áabi tráawajadorbinica quéewique'e natráawajaacani ya nashírri lishínaa éenaa lirrú, jáiwa liáwai déecuchala wérri. ");
INSERT INTO aca_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Liáwinaami linísa liá'a banácalica, libánua báqueerri tráawajadorbini lisáta náucha liá'a banácali íta éenaa náabananica, ne nayá jáiwa nabása jíni liáu cháji'i. ");
INSERT INTO aca_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Néenee liwácali bánua báqueerri, ne lécchoo jáiwa nacáita jíni, nabásani ya nabánua cha jiní. ");
INSERT INTO aca_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Léejoo libánua báqueerri, ne náa'a tráawajadorbini nawínani catúcaca lécchoo, jáiwa nabánua jiní. ");
INSERT INTO aca_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","“Néenee limá jiliá'a cáinabi wácalica: ‘¿Tána numédai? Nubánua nucúuleu caníinai nucábaca; cájbami cawáunta liyá.’ ");
INSERT INTO aca_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ne nacába'inaa jíni náa'a tráawajadorbinica namá'ee, léewata'ee máaquerri'inau liájcha liéni shínaashica, wáiinuani, limáaque'iu walí liá'a cáinabica. ");
INSERT INTO aca_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Cháwa'ee najéda jíni liúcha liá'a shínaashica, jáiwa náiinua jíni. “¿Tána imácai, tánashia liméda náajcha liá'a shínaashi wácalica? ");
INSERT INTO aca_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ne liyá yáairriu líinuaminaa náa'a tráawajadorbinica ya ta liáminaa shínaashi áabirru”. Néemi'inaa jíni léji liérra, namá'ee: —¡Jóctata'inaa libésunau wáajcha! ");
INSERT INTO aca_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ne Jesús cába nayá limá cháa: —Néenee ¿tána liwówai limácai Dios chuáni tánerrimicoo?: ‘Liá'a íiba nacháaninica náa'a médenai cuíta, wáalee limáaca liérra íibaca mawíyi rúnaacoo’. ");
INSERT INTO aca_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Tánashia cáirriu líta'aa liá'a íibaca lisúbirriaminau, ya íiba cáctau matuínaami íta'aa, limédani'inaa pucúpucubeeyu. ");
INSERT INTO aca_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Náa'a wánacaleenai sacerdótebini ya náa'a quéewidacai ley shínaaca, nawówai nawína Jesús preso liyáalimi, níwata náaca léenaa litáania nanácu. Ne cáarru nacába chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Liáwinaami nabánua áabi éeda lituínaa, namédacoo washiálicuenai sáicanica, namédaque'e Jesúsru liáni chuánshica quéewiquinicta nawínacani natéequinictani lirrú liá'a chúnsai wánacaalaca. ");
INSERT INTO aca_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Néenee nasáta néemiu Jesús: —Quéewidacai, wáa léenaa jéewida machácani, jiyá jinírru liwéni liérra mawí rúnaacau. Jiyá éewiderri wayáca léjta Dios bánuau. ");
INSERT INTO aca_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","¿Sáicaminaa wapáida impuesto lirrú liá'a wánacaleerrica Roma sáica, o jócuweeca? ");
INSERT INTO aca_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Jesús yáa léenaa nanácu nawítee máashii natéenica náacoo, limá nalí: ");
INSERT INTO aca_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","—Jíyadani nulí áabai moneda. Nabésuneda'inaa lirrú liá'a moneda licábaque'e, lisáta'ee léemi nayá: ¿tánashia náani jíni, tána jí'inaa jíni liérra yéerri moneda nácu? Néeba'ee lichuáni: —Wánacaleerrica. ");
INSERT INTO aca_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Jesús ma nalí: —Yáa lirrúni liá'a wánacaleerrica lishínaawa jáni, yáa Diosru lishínaaca. ");
INSERT INTO aca_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Quiní limá nalí chóniwenai náneewa, quiní náiinuni lijíconaaca natéeque'e preso; nacáarrudawai limá nalí manúma nayái. ");
INSERT INTO aca_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Liáwinaami áabi saduceos yáau nacába Jesús. Saduceos namá'ee máanalini jócani cáwiu; táda náiiwa lirrú jíni liáni bésuneerricoo, ne jócai yáawaiyi. ");
INSERT INTO aca_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Quéewidacai, Moisés limáacani walí tánerriu, báqueerri washiálicuerri cáserriu máanalicta jíni, jiníca léenibi ruájcha ruá'a líinuca, liá'a léenajirrica licásau ruájcha ruá'a máanaliu íinirri, limáacaque'e léenibiu lirrú liá'a léenajirri liá'a máanalimica. ");
INSERT INTO aca_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ne sáicai, báitate nácu nayá siete léenajinai, quéechanacu sái néenajirrica, nabéecanaataca léeda líinuwai, ne máanali jíni, jiní limáacacta cúuleu. ");
INSERT INTO aca_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","31","Liá'a léenajirri líshiirricu sáica ya liá'a matálitaictacani, léeda líinu lécchuni ya quinínama náa'a léenajinai, ne náa'a sieteca jáiwa máanali jíni, jiní namáacala nacúuleu ruájcha. ");
INSERT INTO aca_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Néenee liáwinaami máanali ruyá lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ne sáicai, ne nacáwiacta'inau ¿tánashia náiibicha, náa'a éedenai náiinu ruyá, tána'inaa chúnsai rúnirricai? ");
INSERT INTO aca_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Jesús éeba'ee nachuáni: —Líta'aa liáni cáinabica, washiálicuenai cásenenaiu íina yáajcha; ");
INSERT INTO aca_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","náa'a éewenai náiinuca lítala liá'a áabai cáinabica néejoo nacáwiacoo, nayá washiálicuenai jócta íina, jócuminaa néejoo nacásacoo mawiá, ");
INSERT INTO aca_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","jócani éewa máanali mawí. Cháminaa nayá jicá'a ángelbini, Dios éenibiminaa nayá nacáwiacalau liúcha liá'a máanalicaica, tánda jócu néewa nacásacoo mawiá. ");
INSERT INTO aca_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Moisés liyája limáaca wáa léenaa litániactaca linácu liá'a banácali éemerrimicoo, náa'a máanalini nacáwiacalau báaniu. Á'a limá Wácalishi liá'a Dios shínaa Abrahám, Isaac ya Jacob. ");
INSERT INTO aca_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","¡Dios jócai máanalini shínaa, nashínanaa cáwinica, quinínama lirrú cáwini! ");
INSERT INTO aca_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Néenee áabi quéewidacani ley shínaa namá lirrú: —Sáicai wérri jimáca, quéewidacai. ");
INSERT INTO aca_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Jócuwa'ee náa'a nawówau nasáta néemiu mawiá jíni, carrúnata namáacacoo bái nayá. ");
INSERT INTO aca_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Jesús sáta léemiu nayá: —¿Táda imá iyá Cristoca David táqueerrimi? ");
INSERT INTO aca_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Ne David liyája, liá'a cáashta lijí'inaa salmos, limá'ee: ‘Dios limá'ee nuwácali: Jiwáau sáicaquictejica, ");
INSERT INTO aca_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","cáashia nuyá méderri jishínaa jijínai máaqueneu jíiba yáajba.’ ");
INSERT INTO aca_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","¿Chíta quéewau'u Cristo David táqueenaimi, David liyája lijí'inaa nuwácalica? ");
INSERT INTO aca_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Quinínama chóniwenai éemenai nayáca, Jesús ma lishínaa éewidenaicoo liájcha: ");
INSERT INTO aca_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Itúyau náucha náa'a éewidenai ley nácu, ya sáicta nawówa jínanicoo náabala machéni rícu, náyadaque'e nacábacanau jicá'a náa'a chóniwenai sáicanica. Nawówai itáa nalí cawáuntaiyu plaza rícu. Namúrru yáarrubaishi mawí sáicaca sinagoga rícu, ya mawí sáictacta yáarruishi náayadaquictaca; ");
INSERT INTO aca_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","néeda náabana náa'a máanirrinica, ya náyadaque'e nacábacanau jicá'a náa'a chóniwenai sáicanica; nasátacoo déecu; nayá narríshibiaminaa mawíyii máashiica”. ");
INSERT INTO aca_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesús cába náa'a rícubinica náuca warrúwaca liárrui rículau warrúwa yáarruica. ");
INSERT INTO aca_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Jesús cába lécchoo báquetoo íinetoo máanirriu, carrúni jináataurruca chámai moneda rími cóbreyu sána. ");
INSERT INTO aca_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Néenee Jesús ma: Yáawai numá irrú, ruáni íinetoo carrúni jináatauca yáichoo náucha mawí; ");
INSERT INTO aca_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ne quinínama yáine warrúwa lénabimica nalí, ne ruyá, carrúni jináataca ruyá, ruá quinínama ruwáalianimica ruyáu'inaami. ");
INSERT INTO aca_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Áabi táanianai nayáca templo nácu, náa'a íiba sáicabeetanica, ya náa'a cachílinaica chóniwenai téenica. Jesús ma nalí: ");
INSERT INTO aca_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","Líinuminaa éerrica, quiníminaa icábani jiní máaquerri'inau, áawita bátui íibana máaquerri'inaa wítau. Quinínama'inaa cáarraliacoo. ");
INSERT INTO aca_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Néenee nasáta néemiu Jesús: —Quéewidacai, ¿chacálita libésunau léji liéni? ¿Tána léji liéni wacábani wayáca jái atéwa bésunacoo liyácai? ");
INSERT INTO aca_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Jesús éeba'ee nachuáni: “Icábawa yúchajoo nachálujueda'eecha iyájoo. Íchabaca náiinucojoo máine'inaa nuyáwa Cristo. Máine'inaa, ‘nuyáwa jáni’ ya ‘wáalee éerrija.’ Ne iyá uwáyau náishiirricujoo. ");
INSERT INTO aca_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Jáicta éemi jináwi íiwanaajoo ya íinua yáaquenaiu, ówa icáarrudaujoo, léca liéni rúnainaa bésunacoo quéecha, újnibii jócai íinu néerra amáarractalacani.” ");
INSERT INTO aca_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Jesús má'ee nalí mawí: —Áabai cáinabi líinua yáacaminau áabai cáinabi júnta, áabai país limédaminaa jináwiu áabai país júnta. ");
INSERT INTO aca_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Líinuminaajoo liá'a cáinabi cúsuerri'inaacoo máanui ya ínaaishi ya bálinacaalashi yáirri'inau matuínaami cáinabi íta'aa; éerri náani nácu wacábaminaa íchaba cacháninai wérri ya máanui wérri jócai wacába cáji. ");
INSERT INTO aca_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ne quéechanacu mináajoo nawína iyájoo nawánaminaa carrúni jináata iyá, ya nacánaquedaminaa iyájoo. Natéemi'inaa iyájoo sinagogala nacástigaaque'e iyá. Nawárruedaminaa cuíta manúmai rícula. Natéeminaa iyájoo nanáneewa náa'a reyesca ya wánacaleerri náneewa nunácueji. ");
INSERT INTO aca_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Cháminaa éewa itáania nalí liá'a yáaini léenaa nunácueji. ");
INSERT INTO aca_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","O'ipénsaa libéecha liá'a imáni'inaaca chítashia itúya'inau jíni. ");
INSERT INTO aca_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Jiníwata nuyá nuá irrú chuánshi wawítee quiníminaa, ijínai jiní éewa'inaa naméda iyá. ");
INSERT INTO aca_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Ne iyá néejuedaminaa iyájoo cáashia isálijinaaja, jéenajinai ya ijúnicai. Éenaaminaa iyájoo náiinuaminaa iyájoo. ");
INSERT INTO aca_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ya quinínama chóniwenai íiwirri nawówa cába iyá nunácueji. ");
INSERT INTO aca_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ne jiníminaa yúquerriu bácua iwíta báinaa. ");
INSERT INTO aca_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","¡Jiyá machácani Dios chuáni nácu, éewaque'e Dios iwáseda iyájoo! ");
INSERT INTO aca_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Jáicta icába chacáalee jí'ineerri Jerusalén narríjcuedacani náa'a soldado máanabanaami yáa léenaa cawíquinta'inaa namárdacani. ");
INSERT INTO aca_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Néenee náa'a yáaineca liá'a cáinabi jí'ineerri Judea, cánaquenai'inau awáca íibirra; náa'a yáaine chacáalee rícu jí'ineerri Jerusalén, najiáque'iu chacáalee rícucha. Náa'a yáaine bacháida rícu, jócubeecha néejoo chacáalee rícula. ");
INSERT INTO aca_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Liyáali éerriminaajoo líinuminaajoo liá'a carrúnataica, jáicta licúmpliaujoo quinínama liá'a Dios chuánica tánerricoo. ");
INSERT INTO aca_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","¡Carrúni jináatani náa'a íinaca liyáali éerri quéenibinica, o nawáalia néenibiu írrene náini! Liyáalimi'inaajoo íchaba carrúni jináata cáinabi íta'aa, líinuminaa carrúnatai máanui wérri linácula liáni chacáaleeca. ");
INSERT INTO aca_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Áabiminaa máanalini'inaa espadayu, ya áabiminaa natéeminaa nayá preso áabata cáinabi ítala, náa'a jócani judíobini nabáwedaminaa quinínama macárruninaa ya náiinuedaminaa chóniwenai Jerusalén rícu sána, táshia linúmami Dios wówaiqui jíni. ");
INSERT INTO aca_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Liyáaminaa jócai wacába cáji linácu liá'a cáiwiaca, walícui nácu ya sáalii nácu; ya liá'a cáinabica náa'a nasiónica jiníminaa nawíteejoo, nacáarrudaminau bájiala, cáiwinaa wérri liwítamayu ya manuáca ya marrádaca shínaa. ");
INSERT INTO aca_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Náa'a chóniwenaica mawíteeminaa nayájoo nacáarruniu libésunau'inau liáni cáinabica; ne náa'a espíritu yéenai áacai lítacha liéni cáinabica wáalenai nadánaniu cháminaa cábacanaa licúsuda nayá. ");
INSERT INTO aca_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Néenee icábaminaa nuyá Washiálicuerri Dios Cúuleeca nuíinuminaa sáanai íibeji nudánaniyu nuchúnicayu. ");
INSERT INTO aca_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Jáicta léju liáni nachána médanicoo, cadánani méda iwíteu ya ibárrueda iwítau, jiníwata cawíquintaminaa nawáseda iyájoo.” ");
INSERT INTO aca_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Chacábacanaa liméda nalí liá'a licábacanaa: “Icábate áicuba jí'ineerri higuera jócta áabata áicuba mawiá. ");
INSERT INTO aca_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Jáicta icába libáinaa cárracuwai, jái urrúni liá'a camuíca. ");
INSERT INTO aca_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Chacábacanaa, jáicta icába jiliéni libésunacoo liéni, yáa léenaa Dios wánacaleerrica jái urrúnicai. ");
INSERT INTO aca_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Ne yáawaiyi numá irrú, quinínama liáni bésuneerri'inau, jóctanaa máanali náani chóniwenaica liyáali éerri sánaca. ");
INSERT INTO aca_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Liá'a éerrica ya liá'a cáinabica amáarrai'inaa, ne nuchuáni jócainaa éenaa amáarraca. ");
INSERT INTO aca_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Cábawa yúchajoo u'índa cabálini iwówa linácu liá'a éerri rícu sáica liá'a iwítee, icámadedauca ya urrúni iwówa linácu liáni icáwica rícu sáica, quéewique'e liyáali éerri jócu licáu cawíquinta íta'aa léjta áabai trampaca. ");
INSERT INTO aca_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Níwata íinuerri'inaa nanácula quinínama náa'a yéenai líta'aa liéni cáinabica. ");
INSERT INTO aca_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Iyá ichúni iwówau sáica, isátau éerri jútainchu Dios yúcha, quéewique'e éenaa imánicoo quinínama liúcha liáni bésuneerri'inaujoo, ya quéewique'e éewa íyadacoo sáicai nunáneewa nuyá Washiálicuerri Dios Cúuleeca.” ");
INSERT INTO aca_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Liyáali éerri Jesús éewiderri éerrinacu templo rícu, ne táayee liáu limáaca líibi liá'a awáca jí'ineerri Olivos. ");
INSERT INTO aca_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ya quinínama náa'a chóniwenaica yáaineu manúlacaiba templo rícula néemique'e lirrú. ");
INSERT INTO aca_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Jái'e urrúnicai liá'a fiestaca jí'ineerri'e Pascua náayacta'inaa'ee liá'a páanica jiní'e éewisaa léewaque'e limúrracacoo. ");
INSERT INTO aca_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Náa'a nawácanaica náa'a sacerdótebinica yá'ee náa'a éewidenai Moisés chuáni, namúrruni chítashia'ee néewau'inaa náiinuaqui jiníni liá'a Jesúsca, né'e cáarru nacába chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Néenee Wawásimi wárruau Judas wówa lícu, lé'e liá'a jí'ineerrica Iscariote, namáanabacami náa'a doce apóstolubinica. ");
INSERT INTO aca_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Quéechanacu'e liáu litáania náajcha náa'a sacerdótebini wácanaica, náa'a nawácanai túyenaica templo máanui lécchoo, chítashia'ee léewau'u léejueda nalí jiníni liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nayá'ee sáicta'ee nawówa nabáuli'e náa lirrú warrúwa liá'a Judasca. ");
INSERT INTO aca_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Liyá'ee wée limá'ee nalí, ya múrruerri'e chítashia léejuedayu'u'inaa'ee nalíni cabáyainta chóniwenai yúcha. ");
INSERT INTO aca_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Quéecha'inaa líinu liá'a éerrica náayacta liá'a páanica méewisaica, náiinuacta liá'a cuésherri jí'ineerri cordero líyani'inaa liá'a fiesta pascuaca. ");
INSERT INTO aca_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Jesús máida liá'a Pé'eruca ya Juan, limá nalí: —Yáau ichúni liá'a íyacaishi pascua shínanaaca. ");
INSERT INTO aca_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nayá nasáta néemiu Jesús: —¿Tanácucha jiwówai wamédaqui jiníni? ");
INSERT INTO aca_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Jesús má'ee nalí: —Yáayu chacáalee néerra, á'a linúma lícu liá'a chacáalee Jerusalénca icába báqueerri washiálicuerri téerri shiátai urrúwa rícu. Yáau líshiirricu táshia liwárruaquictalau jíni lirrícula liá'a cuítaca. ");
INSERT INTO aca_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Imá lirrú liá'a cuíta wácalica: “Liá'a quéewidacai liwówai liá léenaa táshia liyá jiliá'a sala líyacta'inaa lishínaa éewidenaicoo yáajchau táayee pascua éerdi rícu”. ");
INSERT INTO aca_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Liyá líyadaminaa irrú cuíta rícu áacairra áabai sala máanui ya lichúnini. Iméda íyau néenii, quinínama tánashia irrúnaani. ");
INSERT INTO aca_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Pé'eru ya Juan náa'eewoo nacábaca náiinu'e quinínama léjta Jesús máyu, liyáalimi nachána liá'a íyacashica pascua íyaninaaca. ");
INSERT INTO aca_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Líinu'inaa léji liá'a hóraaca, Jesús ya lishínaa éewidenaicoo nawáau náayaca. ");
INSERT INTO aca_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Néenee Jesús ma nalí: “Nuyá wówerri wérri núya yáajcha le pascua liáni, jóctanaa carrúni jináata nuyá numáanalica béechau. ");
INSERT INTO aca_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Ne yáawaa numá irrú, jócuminaa nuéejoo núya yáajcha liáni íyacashica mawiá cáashia linísa limédacoo liáni Dios wánacaalactalaca.” ");
INSERT INTO aca_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Néenee liwína áabai copa vino, jáiwa liá sáicai Diosru, limá'ee: —Áajee liáni ichújidau inácu wáacuwani; ");
INSERT INTO aca_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ne yáawaiyi numá irrú, jócuminaa nuíirra vino mawiá, cáashia líinu liá'a Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Liáwinaami liwína páani liá sáicai linácu Diosru; néenee litúcuedani jíni, liá jíni lishínaa éewidenaicoorru ya limá nalí: —Liyáwa nuíinaa liárra, wáni irrú íinuaque'ini numédaque'e irrú sáicai. Chóque'e wabéechalawoo iméda liáni édacanique'iu nunácu jáicta isúbirreda liá'a páanica. ");
INSERT INTO aca_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Chacábacanaa liméda liájcha liá'a cópaca, liáwinaami líiyaca, Jesús má'ee: —Liéni vinoca léewa nuíirranaa liérra nuádedeerricoo inácueji. Linácueji liérra Dios méda áabai iwítee wáalii. ");
INSERT INTO aca_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Liá'a éejuederri'inaa nuyá yéerri áani, wáairriu liyáca wáajcha mesa nácula. ");
INSERT INTO aca_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nuyá Washiálicuerri Dios Cúuleeca, máanaliminaa nuyájoo léjta Dios máyu. Ne liá'a éejuederri nuyá máashii wérriminaajoo libésunacoo. ");
INSERT INTO aca_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Jáiwa náa'a éewidenaicoo nasáta néemiu nayá wáacoo tánashia éenaa liméda liárra léejuedaminaa Jesúsjoo. ");
INSERT INTO aca_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Néenee náa'a éewidenaicoo naméda yáaca'eewau tánashia'ee mawí cawéni náiibicha. ");
INSERT INTO aca_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Néenee Jesús má'ee nalí: —Líta'aa liéni cáinabica, náa'a reybinica nawánacaala máashii, léjta nawówau'u nachóniwenai. Mawí náa'a nawácanaica wánacaleenai namá'ee náa'a washiálicuenai médenai sáicai. ");
INSERT INTO aca_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ne iyá jócani éewa médacoo léjta nayá. Iméda báawachala, liá'a mawí cawéni yúcha, éewerricta mawítee yúcha mawí; liá'a nawácalica quinínama arrúnaa liyúda náa'a áabica lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","“Ipénsate liéni: ¿Tána mawí cawénicai, liá'a shírruederri íyacaishi? ¿O léewee jiliá'a wáairricoo líiyaca mesa nácula? ¿Ya jócu liéni liá'a wáairricoo líiya mésa nácula? Ne nuyá yáairri íibi nushírruedaque'e irrú íya quinínama. ");
INSERT INTO aca_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iyá tálidedeenai nuyá liyáali éerri máashiiquictaca. ");
INSERT INTO aca_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Tádawa nuá irrú áabai wánacaleerri, léjta nusálijinaa yáu nulí nuwánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Chaléeni nuwánacaalactala'inaaca néerra, iwáaminau íyaminaa ya írra nushínaa mesa íta'aa, iwáaminau nuárrubai íta'aa nuéma nácu íiwaque'e sáicacta jócta máashii nayá náa'a doce tribu israelítabinica”. ");
INSERT INTO aca_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Néenee Jesús má'ee Pé'erurru: —Simón Pé'eru, jéemi sáicani. Liá'a Wawásimica sáteerri Dios yúcha, lénedaque'e licábau iyá, ya Dios wánaca. ");
INSERT INTO aca_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Ne nuyá sáteerri Dios jócubeecha cháucta jirrú liá'a éebidauca, ya jiyá jéejoo'ínaa nulí báaniu, jiyúdaque'e jéenajinaiu, nayáque'e cabálininaa nuchuáni nácu. ");
INSERT INTO aca_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Pé'eru má'ee Jesúsru: —Nuwácali, rúnacta nuáacoo jiájcha cuíta manúmai rícula, nuáujoo; ne arrúnacta máanali nuyá jiájcha, máanali nuyájoo. ");
INSERT INTO aca_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Ya Jesús éeba'ee Pé'erurru: —Pé'eru, numá jirrú wáaleejaa, jóctanaa gáayu máida, matálichuminaa jibáya nunáawa jócala jiá léenaa nunácu. ");
INSERT INTO aca_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Néenee Jesús sáta léemiu lishínaa éewidenaicoo: —¿Quéecha'inaa nubánua iyá mashínaa machácalee, jiní shínaa moneda yáarrui, jiní zapato, cháucta irrú áabata mawí? Jiní, namá'ee lirrú. ");
INSERT INTO aca_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Néenee Jesús má'ee nalí: —Wée, ya báaniu ái áabatacai, liá'a wáaleerri chácala, litéeni, ya wáaleerri lichácaleu warrúwa yáarru'inaa lécchoo; liá'a jiníctarru espadani jiwénda jisácuniu jiwéni'a liyú áabai espada. ");
INSERT INTO aca_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Ne numá irrú, arrúnaaca libésunacoo nunácu liáni limáni jiliéni Dios chuánica tánerricoo: ‘Ne najútadani náiibi náa'a camédacani máashii’. Ne liá'a tánerricoo quinínama nunácueji arrúnai'inaa médacoo. ");
INSERT INTO aca_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Náa'a éewidenaicoo namá'ee: —Wawácali, áani ái chámai espada já'a. Jesús éeba'ee: —Ája árra. ");
INSERT INTO aca_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Jesús nísa'inaa litáania náajchai, lijiáwai cuíta rícucha. Léjta liwítee séewirrinaaja, liáwai áabai dúuli ítala jí'ineerri Olivos, náa'a lishínaa éewidenaicoo náau líshiirricui. ");
INSERT INTO aca_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Líinu'inaa néerrai, limá nalí: —I'óra, jócubeecha máashii wíteeshi wárruau irrú, icá'eechau. ");
INSERT INTO aca_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Néenee lidáanau náucha píituita liá'a Jesúsca, lidéecucha lidáanacoo náucha léjta báqueerri éenactala liúca bátui íiba, litúyawai li'óraca. ");
INSERT INTO aca_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","Néenee limái: “Nusálijinaa, jijéda nuyá liúcha liá'a cáiwi'inaaca jócubeecha nusúfria bájiala, jiwówaicta, ne jócaita bésunau nuwánacaala nácu nuyá, ne jiwánacaala nácu jiyá.”  ");
INSERT INTO aca_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Néenee líyadau lirrú báqueerri ángel áacai sái quéewique'e liá lidánani liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Carrúni jináatai licáwica nácuu órerri danáanshiyu mawí ne lirruéca jicá'a íirrai dújuerriu máanui cáirriu cáinabi rícula. ");
INSERT INTO aca_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Libárrua'inau liúcha liá'a oraciónca, liáu lishínaa éewidenaicoo néerrau, líinu nanácu máainai nayáca máashii wérricala nawówa. ");
INSERT INTO aca_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Limá'ee nalí: —¿Tánda imá iyáca? Ibárroo ya i'óra jócubeecha icáu máashii rícula. ");
INSERT INTO aca_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Nácula litáania Jesúsca újnibi, náiinu lirrú íchaba chóniwenai. Liá'a yáairricoo nabéecha, jí'ineerri Judas, néenaa náa'a lishínaa doce éewidenaicoo. Liérra rúneerriu lishíshique'e Jesús wídani. ");
INSERT INTO aca_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Néenee Jesús ma lirrú: —Judas, ¿áabai ishíshicala nuwídani jimáaca nuyá nacáaji rícu náa'a nujínaica, nuyá Washiálicuerri Dios Cúuleeca? ");
INSERT INTO aca_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Quéecha'inaa éewidenaicoo cába liá'a namédani'inaaca, nasáta néemiu liyá liá'a Jesúsca: —Wawácali, ¿jiwówai wáiinua nayá espadayu? ");
INSERT INTO aca_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Néenaa náa'a éewidenaicoo, liwána catúca liá'a méderri liwánacaala liá'a sacerdote wácalica, liwánani catúcaca, liwíchuani wíiba sáicaquictejica. ");
INSERT INTO aca_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Néenee Jesús ma nalí: —Imáacani, ája árra. Néenee lidúnu liwíba liá'a lishínaa camé'ecai liwánacaala, jáiwa lichúni jíni. ");
INSERT INTO aca_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Néenee Jesús sáta léemiu náa'a sacerdótebini wácanaica, náa'a liwácali náa'a nawácanai túyenai templo, ya náa'a salínaica, íinuenai natéeque'inini: —¿Tánda índa áicubayu ya espadayu újni icábacuchu canédi nuyá? ");
INSERT INTO aca_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Éerri jútainchu nuyá yáajcha templo rícu, ne jócai néenaa natée cuíta manúmai rícula. Ne wée, léewa éerdi ishínaa liéni, éerdi liwánacaala liá'a wíteeshi máashiica. ");
INSERT INTO aca_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Náa'a wínenai Jesús preso natéeni chaléeni náabana néerra náa'a sacerdótebini wácanaica. Pé'eru yáairriu déecuchecta lisíguia liácoo nayá. ");
INSERT INTO aca_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Á'a, béewami patio, natúculia chichái, nawáaniu nanábaca litéeji; ya Pé'eru wáairriu náajcha lécchoo. ");
INSERT INTO aca_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Nácula Pé'eru wáau liyá néeni, báquetoo íinetoo camé'ecau nawánacaala, rucába'inaa Pé'eru wáairriu liyáca chichái dáni, rucába jíni, rumá'ee: —Cháiwatee yáa Jesús yáajcha liárra. ");
INSERT INTO aca_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Pé'eru má'ee jócala licúnusiani, limá'ee: —Iinetoo, jócu nucúnusia Jesús. ");
INSERT INTO aca_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Néenee íchaitaa rími, báqueerri cába jíni, limá'ee: —Jiyá néenaa náa'a Jesúsca. Pé'eru má'ee léebacani: —Jócu, washiálicuerri, jócu nuyáni. ");
INSERT INTO aca_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Néenee áabai hóraa liáwinaami, báqueerri éejoo limáca: —Liyáwa yéerrimi Jesús yáajcha liárra. Chái Galilea néenee sái. ");
INSERT INTO aca_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Pé'eru má'ee: —Washiálicuerri, jócu nuá léenaa tánashia nácu jitáania. Liyáalimi, litáaniacta liyáca, jáiwa áabai gáayu máida. ");
INSERT INTO aca_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Néenee liá'a Jesúsca lináawau licába Pé'erurru, jáiwa Pé'eru lédacaniu liá'a Jesús mánimi lirrú: “Wáaleeminaa, jóctanaa gáayu máida, matálichujoo jimáminaajoo jócala jiá léenaa nunácu.” ");
INSERT INTO aca_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Pé'eru jiáu néeni, lícha lirrúwoo cáiwinaa wérri. ");
INSERT INTO aca_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Náa'a washiálicuenaica túyenai nayá Jesús, náasacala ya nabásaida liyá. ");
INSERT INTO aca_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Nabáya lituí, nabásaida liyá, néenee nasáta néemiu liyá: —¡Jiácta léenaa jíiwa walíni tánashia báseda jiyái! ");
INSERT INTO aca_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ya máashii nanúma lirrú, namá lirrú íchaba chuánshi mawí máashii. ");
INSERT INTO aca_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Jái'inai jucámarrai, náawacau náa'a salínai judíobini, náa'a nawácanai náa'a sacerdótebinica, ya náa'a éewidenai ley nácu, ya natée Jesús nalí néenaa náa'a cawénini mawí jí'ineerri Júnta Suprema Wácanai. ");
INSERT INTO aca_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Néerra nasátani néemiu liá'a Jesúsca: —Jíiwa walí: ¿Jiyá liá'a Dios Cúuleeca, liá'a Mesíasca? Jesús má'ee nalí: —Numácta irrú jajá, jócai'inaa éebida nulí. ");
INSERT INTO aca_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Nusátacta nuéemiu iyá, jócai'inaa éenaa éeba núcha. ");
INSERT INTO aca_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ne chóque'e, nuyá Washiálicuerri Dios Cúuleeca, nuwáau sáicaquictejica lidáni liá'a Dios cadánani wérri wítee. ");
INSERT INTO aca_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Néenee quinínama nasáta néemiu liyá: —¿Yáawaiyi jiyá Licúulee liá'a Diosca? Jesús má'ee nalí: —Iyá jájiu májani. ");
INSERT INTO aca_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Nayá namá'ee: —Jócu mawiá warrúnaa náa'a íiwenai walíni. Wayá jájiu wéemi liérra jinúma licuéji. ");
INSERT INTO aca_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Quinínama nabárroo natée Jesús Pilato náneewa. ");
INSERT INTO aca_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Lináneewa nachánau náa lijíconaa, namá'ee: —Wáiinu linácu liáni washiálicuerrica cáarrulederri limáacoo washínaa chóniwenai ásana áani cáinabi íta'aa. Limá'ee jócala wéewa wapáida impuesto lirrú liá'a chúnsai wánacaala, ya cadájcueta limá liyácala'ee Dios níwani, reyca liyá. ");
INSERT INTO aca_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Pilato sáta'ee léemiu wáni: —¿Yáawaa jiyá rey judíobini shínaaca? —Jesús éeba'ee: —Jiyái mácaja. ");
INSERT INTO aca_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Néenee Pilato ma nalí náa'a sacerdótebini wácanaica ya chóniwenairru: —Jiní nuíinucta áabai lijíconaa liéni washiálicuerrica. ");
INSERT INTO aca_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ne nayá namá mamáarraca danánshiyu: —Liyú liá'a léewidauca wáneerri matuínaami chóniwenai wítee. Lichánau quéechanacu Galilea shínaa cáinabi íteeji, ya chóque'e lichánau liméda áani áani Judea. ");
INSERT INTO aca_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Quéecha'inaami Pilato éemi liéni, lisáta'ee léemiu Jesúscta Galilea sái. ");
INSERT INTO aca_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Namá'inaamite lirrú néenee sáicalani, libánua'ee Heródesruni, wánacaleerri Galilea shínaa cáinabi íta'aa, ne liyáalimi éerri chalée yáacani Jerusalénra. ");
INSERT INTO aca_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Herodes cába'inaami Jesús, sáita wérri liwówa, jiníwata íchaba wérri éerri liwówa licába Jesús, léemica'ee natáania linácu ya linénda liméda lináneewa áabai jócai licába cáji. ");
INSERT INTO aca_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Ne íchabachu lisáta léemiu Jesús, ne Jesús jócai éeba lichuáni. ");
INSERT INTO aca_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ya néeni nayá lécchu náa'a sacerdótebini wácanaica, ya náa'a éewidenai ley shínaaca, ná'ee lijíconaa mamáarraca. ");
INSERT INTO aca_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Néenee Herodes ya lishínaa soldado náasacala nacáida nacábacani, ya nacáidaque'e nacábacani nasúwa líibala léjta reybini íibala. Néenee Herodes bánua Pilatorru báaniu jíni. ");
INSERT INTO aca_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Liyáali éerrimi sáicta nawówa médacoo Pilato ya Herodes, máashiinimi cába yáacacoo quéecha. ");
INSERT INTO aca_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Pilato yáawaqueda náa'a sacerdótebini wácanaica, ya náa'a wáalianai wánacaleenaica ya quinínama chóniwenai, ");
INSERT INTO aca_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","limá'ee nalí: —Iyá índa nulí liáni washiálicuerrica, liwánaca matuínaami chóniwenai wítee; ne nuyá sátaderri nuéemiu wáni jiní nuíinucta áabai lijíconaa liá'a imáni linácucha. ");
INSERT INTO aca_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Jiní Herodes íinuca lijíconaa lécchoo, tándawa jicá'a léejueda walí jíni. Jái inísa icábacai jiní lijíconaa, jócai sáicanata máanalica. ");
INSERT INTO aca_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Nuwána'a nabásedacani ya liáwinaami nuwásedajoni.  ");
INSERT INTO aca_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Fiesta éerdi rícu Pilato wánaque'e sáicta chóniwenai wówa liájcha liwáseda nalí báqueerri preso tánashia nawówaini. ");
INSERT INTO aca_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Ne quinínama nayá nachánau namáidaca: —¡Jiwána náiinua Jesús! ya ¡Jiwáseda Barrabás! ");
INSERT INTO aca_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Liéni Barrabásca, naníquini cuíta manúmai rícula, liwánaca quinínama chóniwenai íinua yáacacoo lijúnta liá'a wánacaleerri chacáalee rícu, ya líinuacala lirrúwoo, báqueerri chóniwerri. ");
INSERT INTO aca_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Pilato, wówerri liwáseda Jesús, léejoo litáania nalí báaniu; ");
INSERT INTO aca_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ne néejoo namáidada mawí cadánani: —¡Itáata cruz náculani! ¡Itáata cruz náculani! ");
INSERT INTO aca_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Matálichu Pilato éejoo limá nalí báaniu: —Ne ¿tána máashii lijíconaa limédai? Nuyá jiní nuíinucta lijíconaa quéewique'e máanalicani. Nuwána'a nabásedacani, néenee ta numáaca machúnucajoni. ");
INSERT INTO aca_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Ne nayá namáidada mamáarraca, nawánaque'e natáata cruz náculani; ne namáidadacala mamáarraca nawána náiinua Jesúsmi. ");
INSERT INTO aca_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Pilato máaca liyáu liá nalí liá'a nasátanica; ");
INSERT INTO aca_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","jáiwa liwáseda nalí liá'a Barrabás nawówaini jiácoo, liá'a yáairrimi cuíta manúmai rícula, líinuacala lirrúwoo ya léewidacala chóniwenai wítee máashii, ya ta liá nalí Jesús quéewique'e naméda liájcha léjta nawówau'u. ");
INSERT INTO aca_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Quéecha'inaami soldado tée Jesús natáataque'inini cruz nácula, iníjbaa lícu náiinu báqueerri washiálicuerri Cirene néenee sái, jí'ineerri Simón, jáiwa'ee nawána litée cruzca Jesús íshiirricu. Liyáali éejuerriu liácoo bacháide, yáairriu chacáalee jí'ineerri Jerusalén. ");
INSERT INTO aca_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Íchaba chóniwenai ya íchaba íina yáainaiu Jesús, yáainai íchenai ya máidadenai máashiicala nawówa linácu. ");
INSERT INTO aca_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Néenee Jesús cába nayái náa'a íinaca limá'ee nalí: —Iina Jerusalén néenee sána, u'ícha nunácu, ícha inácu ya éenibi nácu. ");
INSERT INTO aca_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Jiníwata líinuminaajoo liá'a éerrica namáctaca: ‘Sáictaminaa nawówa náa'a jócani éewa nawáalia néenibiu, sáictaminaa nawówa náa'a jócani yáawi rícucaji, jiníni éenibi náani'inaa írra’. ");
INSERT INTO aca_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Néenee nachánaminau namáca náa'a chóniwenaica awácarru: ‘¡Icáu wáata'aa!’ ya náa'a dúulirru: ‘¡Ibáya wayá!’ ");
INSERT INTO aca_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ne nuyá jiní médani máashiica, náiinua nuyá cháa, ¿chítaminaa náji náa'a médenai máashii? ");
INSERT INTO aca_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Lécchoo natée chámata washiálicuenai máashiini natáataque'e cruz nácuni Jesús yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Náiinu'inaa liyácta liá'a yáarrushi jí'ineerri iyájimi, jáiwa natáata Jesús ya náa'a chámata máashiinica, báqueerri sáicaquicteji ya báqueerri máashiquiteji.  ");
INSERT INTO aca_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Jesús má'ee: —Nusálijinaa, jimíya máecha najíconaa, jiníwata jócai náa léenaa liá'a namédanica. Náa'a soldádoca nachújida liá'a íibalashica, tánashia sáicai yáajba máaquerri'inau Jesús íibala yáajcha. ");
INSERT INTO aca_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Náa'a chóniwenaica yéenai néeni nacábani nayáca; báawita náa'a wánacaleenaica nacáida liyá namá'ee: —Liwáseda áabi, chacábacanaa liwásedau liyá jájiu, liyácta yáawaa liá'a Cristo, Dios wínanica. ");
INSERT INTO aca_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Náa'a soldádoca yáasacalenai Jesús lécchu. Narrúniu náa líirra liá'a vinoca ijíshiica, ");
INSERT INTO aca_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","namá'ee lirrú: —¡Jiyácta liá'a nashínaa rey náa'a judíoca, jiwásedau jiyá jájiu! ");
INSERT INTO aca_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ya ái áabai já'a tánerriu liwícau, máirri'e: “Léwata nashínaa rey náa'a judíoca.” ");
INSERT INTO aca_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Báqueerri léenaa, liá'a máashiicaica cuérricoo cruz nácu, licáita'ee limá'ee: —¡Jiyácta liá'a Cristoca, jiwásedau jiyá jájiu ya wayá lécchu! ");
INSERT INTO aca_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ne liá'a báqueerrica liárra'ee liá'a lijúnicaicoo limá'ee lirrú: —¿Jócu cáarru jicá'a Dios, jiyá yáairri jiyá liáajba léja liáni cacháninaica? ");
INSERT INTO aca_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Wayája carrúni jináatanica, yáawaa níwata wapáida wajíconau liá'a wamédanica; ne liéni washiálicuerrica, jiní médani máashiica. ");
INSERT INTO aca_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Néenee limá mawí: —Jesús, jédacaniu nunácu jáicta jichánau jiwánacaalacojoo. ");
INSERT INTO aca_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Jesús éeba'ee lichuáni: —Numá jirrú yáawaa wáaleeminaa jiyá nuájcha sáictactala wérrica rícula. ");
INSERT INTO aca_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wíyaicumi yáwinaami ya léjta las tres táicala'inaami, quinínama cáinabi catáwacai máacacoo. ");
INSERT INTO aca_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Liá'a cáiwiaca jócai quéena, ya liá'a cortinaca lishínaa liá'a temploca shírricuerriu béewami áaqueji cáinaculanaa. ");
INSERT INTO aca_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Jesús máidada cadánani limá'ee: —¡Nusálijinaa, jicáaji rícu numáaca nushínaa nucáwicau! Limá'inaa liáni, máanali jíni. ");
INSERT INTO aca_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Quéecha'inaa liá'a nawácali romanoca licába'inaa liárra bésuneerricoo, jáiwa liá sáicai Diosru limá'ee: —Yáawaiyi liéni washiálicuerri jiní jíconaa. ");
INSERT INTO aca_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Quinínama náa'a chóniwenai máanabanaamica yéenai néeni, nacába liá'a bésuneerricoo, yéenai máashiini wówa nábana néerrau náinueda nacútau, náaca léenaa cajíconaa nayá. ");
INSERT INTO aca_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ne quinínama náa'a Jesús júnicaica, ya náa'a íina yáainai liájcha Galilea néenee namáacau néeni, nacába'ee déecuche liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Liyáte báqueerri washiálicuerri sáicai ya liá'a yáawaiyica, jí'ineerri José che sáimi chacáalee jí'ineerri Arimatea, yéerri Judea shínaa cáinabi íta'aa. Néenaa náa'a nawácanai náa'a judíobinica. Liyája liárra José, nénderri Dios wánacaalacai líta'aa liáni cáinabi. Liyá jócai áabenaa wówa náajcha náa'a limáanabaca wánacaleenaica namá'inaa náa'a áabi wánacaleenaica máanalicaala'inaa Jesús. ");
INSERT INTO aca_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Liá'a Joséca yáairriu Pilato néerra, lisáta liúcha Jesús máshicaimi. ");
INSERT INTO aca_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Néenee liúrrucueda'inaa Jesús máshicaimii liwówanaa jíni áabai wáarruma cabálai íibi, limáacani áabai útawi rícu áabai dúuli wáaleerri útawi jócta náucacaji chóniwenai. ");
INSERT INTO aca_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Liyáali éerri biérnimi, náa'a judíoca chúndadeneu nawówa íyabaque'iu lirrícu liá'a sábadoca, níwata ái atéwa íinu néerra liá'a éerrica. ");
INSERT INTO aca_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Náa'a íinaca tálidedeenai Jesús chéni Galilea néenee, náau nacába liá'a útawica, ya nacába'ee chítashia namáacau Jesús máshicaimi. ");
INSERT INTO aca_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Néenee néejuawia cuíta néerra, nachúndada juménibee najúsuedaque'e Jesús máshicaimi nácuni. Néenee nawówa íyabau sábado rícu léjta liwánacaalau liá'a Moisés shínaa leyca. ");
INSERT INTO aca_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Náa'a íinaca nawówa íyabau sábado rícu, léjta cábacanaa nawítee yáayu'u, ne domingomi manúlacaiba wérri néejoo Jesús shínaa útawi néerra, natée liá'a juménibeeca nachúnini. ");
INSERT INTO aca_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Néenee náiinu'inaa néerrai nacába liá'a íiba nabáyau linúma útawi yáairri báawachala. ");
INSERT INTO aca_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Néenee nawárruawai útawi rícula, ne jiní náiinu Jesús máshicaimi lirrícu. ");
INSERT INTO aca_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nayá cáarrudenaiu, jiní náa léenaa naméda árra, ne cawíquinta nacába chámata washiálicuenai bárruenaiu urrúni nalí, nábala cabálai ya balíbali wérri. ");
INSERT INTO aca_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Náa'a íinaca cáarru wérri nayá natájeda nanániu cáinabi nácula, ne namá nalí náa'a washiálicuenaica: —¿Tánda imúrru máanalini íibi liá'a cáwica? ");
INSERT INTO aca_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Jiní áani, cáwerriwai. Édacaniu linácu liá'a limánimica liyá'inaa újnibi Galilea: ");
INSERT INTO aca_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Liyácala, licúulee liá'a Washiálicuerrica arrúnaacala'inaa néejueda nacáaji rícu náa'a cajíconaanica, natáataque'inini cruz nácu, ne matáli éerriminaajoo licáwiaminaujoo. ");
INSERT INTO aca_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Néenee nédacaniwai linácu liá'a Jesús mánimi nalí náa'a íinaca. ");
INSERT INTO aca_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Néenee néejoo'inaawai chéni útawi néenee, náiiwa nalíni náa'a once apóstoluca ya nalí náa'a quinínama chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Náa'a téenai liá'a chuánshica nalí náa'a apóstoluca ruá'a María Magdalenaca, Juana, María Santiago túwaca ya áabibi íina mawí. ");
INSERT INTO aca_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ne náa'a apóstoluca namá'ee nalíwoo mawítee yúquenaicoo nárra, ya jócai nawówai néebida nalí. ");
INSERT INTO aca_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ne máayabaca, Pé'eru cánacau liácoo útawi néerra; ne licába'inaa lirrícui licába léeyeimica jiní néeni. Néenee léejuawai cuíta néerrai, cáarruderriu liácoo licába liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Liyáalimi éerri, chámata éewidenaicoo ná'eewoo áabai chacáalee rícula jí'ineerri Emaús, máaquerricoo once quilómetros Jerusalén yúcha. ");
INSERT INTO aca_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Natáania náacoo quinínama linácu liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Nácula natáania náacoo, ya náiiwadeda, Jesúsja lirrúni'eewoo nalí, lichána'eewoo lijínacoo náajcha. ");
INSERT INTO aca_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ne áawita nacábacani nayá, jócai'e nacúnusia nacába Jesús shía jíni. ");
INSERT INTO aca_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Jesús sáta'ee léemiu nayá: —¿Tána itáania yáacoo nácui iníjbaa lícu? Jáiwa nabárruawai máashicta nawówa, ");
INSERT INTO aca_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","báqueerri néenaa jí'ineerri Cleofás léeba'ee: —¿Jiyá bácai rímii yáairri Jerusalén, jócai yáa léenaa liá'a bésuneerricoo lirrícu éerri jiliéni? ");
INSERT INTO aca_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Jesús sáta'ee léemi wáni: —¿Tána bésunawai? Namá'ee lirrú: —Linácue sái Jesús Nazaret néenee sáica, báqueerri íiwadedeerri Dios chuáni wíteeshi dánaniyu liá'a limédanica, ya lichuáni Dios náneewa ya quinínama chóniwenai náneewa; ");
INSERT INTO aca_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ne náa'a sacerdótebini wácanaica ya náa'a wáalianai wánacaalashi wéenaaca, jáiwa néejueda nalíni náa'a romanobinica quéewique'e náiinuacani natáata cruz náculani. ");
INSERT INTO aca_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Wayá éebidenaimi liyácala liá'a íinuerri liwáseda Israel quinínama máashii yúcha. Ne jái matálii éerri máanaliqui jíni. ");
INSERT INTO aca_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Áajuani manúlacaiba áabi íina wéenaaca, nacáarruda wayá, náa'eewoo manúlacaiba wérri namáacactami Jesús, ");
INSERT INTO aca_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ne jócala náiinu limáshicaimi néejoo nábana néerrau. Ya náiiwadeda áabi ángel íyadau nalí, namá'ee nalí cáwica'ee Jesús. ");
INSERT INTO aca_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ne áabi wajúnicai wéenaa náau liáwinaami nabáyactalami Jesús, chái yáca léjta namáyu'u náa'a íinaca. Ne Jesús jócai nacába. ");
INSERT INTO aca_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Néenee Jesús má'ee nalí: —¡Chábala iwítee báyacoo jírra, ne jócani éenaa éebidaca léjta namáyuni náa'a éewidenai Dios chuáni rícueji! ");
INSERT INTO aca_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","¿Ya jócu arrúnaa carrúni jináata limédacoo liá'a Cristoca quinínama liáni bésuneerricoo, quéecha'inaa jóctanaa Dios yáa lirrú wíteeshi cawénica? ");
INSERT INTO aca_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Néenee lichánau líiwa nalí sáica liá'a Dios chuánica táanierri linácu, lichána léewidaca Moisés cáashtami rícueji, ya quinínama lichánau nacáashtami rícueji náa'a íiwadedeenaimi Dios chuánshi rícueji báinacu. ");
INSERT INTO aca_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Náiinu'inaami lirrícula liá'a chacáaleeca, Jesús méda'eewoo jicá'a liá'a bésuneerri'inaacoo machácani. ");
INSERT INTO aca_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Ne jáiwa'ee namáisania jíni namá'ee lirrú: —Jimáacau wáajcha, jái táicala cái. Wówerri samáacai. Jesús wárrua'eewoowai limáacaque'iu náajcha. ");
INSERT INTO aca_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Ne quéecha'inaami nawáacoo nayá mesa nácula náayaque'e, Jesús wína licáaji rícu liá'a páani, liá'e sáicai Diosru, litúcueda'ee liá nalí jíni. ");
INSERT INTO aca_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Ne liyáalimi natuí méecu nacúnusia Jesús; jáiwa lichálinawai, náau natuí rícucha. ");
INSERT INTO aca_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Namá'ee nalí wáacoo: —¿Jócai újni yáawaa litáania'inaami liácoo walí iníjbaa lícu lichánau líiwa walí sáica liá'a Dios chuánica, wasíntia wawówa lícuu jicá'a áabai chichái éemerricoo liyáca? ");
INSERT INTO aca_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Jócu nanénda mawiá, jáiwa néejoo Jerusalén néerrai, náiinu nanácu náa'a once apóstolu yáawaquenaiu ya quinínama najúnicai. ");
INSERT INTO aca_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Náa'a apóstoluca namá'ee nalí: —Yáawaiyi cáwiacoo liá'a wawácalica, líyadau Simónru. ");
INSERT INTO aca_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Néenee náa'a chámataca náiiwa nalí liá'a bésuneerricoo náajcha iníjbaa lícu, ya néewau'u nacúnusia Jesús quéecha'inaami litúcueda nalí páani. ");
INSERT INTO aca_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Natáaniacta nayá újnibi quinínama liá'a bésuneerricoo, jáiwa Jesús íyadau nalí béewami litá'ee limá'ee nalí: —Sáictacta iyáca. ");
INSERT INTO aca_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Jáiwa'ee nacáarrudau bájialai nacábacani nalí tá'ee liwówanaami. ");
INSERT INTO aca_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ne Jesús má'ee nalí: —¿Tánda icáarrudau? ¿Tánda jócai éewa éebida iwówa licuéjiu? ");
INSERT INTO aca_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Icába nucáaji ya nuíiba. Nuyáwajani. Idúnu nunácu ya icába nuyá. Áabai wówanaashimi jócai wáalia líinau ya liyájide, léjta icábau'u nuwáaliacani. ");
INSERT INTO aca_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Limá'inaami liéni, líyada licáajiu nalí ya líiba. ");
INSERT INTO aca_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ne jócala néenaa néebida újnibi sáictaca nawówa ya nacáarrudau, Jesús sáta'ee léemiu nayá: —¿Iwáalia íyacaishi wáya'inaa? ");
INSERT INTO aca_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Jáiwa natúcua lirrúi bácua cubái mídiquinaa. ");
INSERT INTO aca_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Jáiwa liwína náucha jíni líya nanáneewa jíni. ");
INSERT INTO aca_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Néenee limá'ee nalí: —Liá'a bésuneerricoo nunácula léewa nuíiwanimite irrú quéecha nuyá'inaami yáajcha: arrúnai cúmpliacoo nunácue sáica Moisés shínaa ley rícue sáica, ya nacáashta rícuesaimi náa'a tánenaimi Dios chuáni rícueji, ya cáashta salmos shínaaca. ");
INSERT INTO aca_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Néenee liwána náa léenaa sáica liá'a Dios chuáni tánerricoo báinacu. ");
INSERT INTO aca_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Ya limá'ee nalí: —Jái tánacuwai, arrúnaaca'ee máanali liá'a Cristoca, ya licáwiacoo matáli éerri ricúla. ");
INSERT INTO aca_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Nují'inaa nácu, ya Jerusalén néenee, arrúnaa íiwa quinínama cáinabi néejuedaque'e nawíteu Diosru, quéewique'e liméetua najíconaa. ");
INSERT INTO aca_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Iyá'inaawa nárra arrúnaani'inaa íiwa quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nubánuaminaa irrú liá'a nusálijinaa báulini liá irrú. Ne iyá imáacau áani, chacáalee Jerusalénca, cáashia irríshibia liá'a wíteeshi dánanica íinuerri áaqueji. ");
INSERT INTO aca_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Néenee Jesús tée nayá bináawala chacáalee, urrúni Betániarru, linácuda licáajiu liáque'e nalí sáicai. ");
INSERT INTO aca_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nácula liá nalí sáicai, lishírriu náucha, jáiwa liáu áacairrai. ");
INSERT INTO aca_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nayá nácula, caníinaa nacába liyá náa lirrú sáicai, néejoo Jerusalénra sáictani wérri wówa. ");
INSERT INTO aca_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Éerri jútainchu nayá templo rícu, náa sáicai Diosru.");
INSERT INTO aca_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Ne nushínaa quéechanacu sái cáashta, nujúnicai cawéni wérri Teófilo, tánerri urrúni quinínama liá'a Jesús médanica ya liá'a léewidanica quéechanacu, ");
INSERT INTO aca_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","cáashia'inaamitee éerri líirracoo áacairra. Ne jóctanaa liájau áacairra, léewida nayá Espíritu Santo rícueji, náa'a apóstolubinica liwínanica quéecha, liá'a arrúnai'inaa namédaca. ");
INSERT INTO aca_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Ne liáwinaami máanalini, líyadau cáwi chóniwerriyu, yáawacaala cáwijani. Cuarenta éerri líyadacoo liyá náajcha, litáania nalí Dios wánacaalactala nácu, ne ta liácoo áacairra. ");
INSERT INTO aca_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Quéecha'inaami liyá újnibi náajcha náa'a apóstolubinica, Jesús má'ee nalí jócu béecha éenau chéni Jerusalén néenee. Ne limá nalí: —Inéndau liá'a nusálijinaa mánimi irrú, linácu liá'a nutáanianimi irrú nácu. ");
INSERT INTO aca_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Ne yáawaiyi liá'a Juanca báutiseerri shiátaiyu, ne wabéechalawoo Dios báutisa iyájoo liá'a Espíritu Santoyu. ");
INSERT INTO aca_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Náa'a yéenaimi Jesús yáajcha náawacau nasáta néemiu liyá: —Wawácali, ¿jiwána nawánacaala báaniu Israel lirrícu éerri jiliéni? ");
INSERT INTO aca_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Néenee Jesús má'ee nalí: —Ne jócai arrúnaa yáa léenaa tánashia éerri o jócta áabata éerri bácai nusálijinaa Dios éewerri liméda liáni. ");
INSERT INTO aca_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Quéecha'inaa líinu liá'a Espíritu Santo inácuda, irríshibiaminaa lidánanijoo, ijiáminau itáania nunácu, á'a Jerusalén, quinínama Judea shínaa cáinabi íta'aa ya Samaria cáinabi íta'aa lécchu, ya quinínama déecuchala áabata cáinabi ítala. ");
INSERT INTO aca_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Nácula limá nalí léja liérra, nácula nacába nayáca jíni, Jesús nácudau liáque'iu áacairra, jáiwa libáyau sáanai íibirra, jócu nacába mawiá jíni. ");
INSERT INTO aca_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nácula nacába Jesús írrau'u áacairra, chámata washiálicuenai jiáu nalí cabálani íibala, ");
INSERT INTO aca_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","namá nalí: —Chóniwenai Galilea néenee sána, ¿tánda icába iyá áacairra? liyája liárra Jesús yéerrimi yáajcha yáairriu áacairra, líinuminaajoo chacábacanaa léjta liáyu'imiu. ");
INSERT INTO aca_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ne chéni lítee liá'a dúulica jí'ineerrica Olivos, néejoo náa'a apóstolubinica Jerusalén néerra; urrúni rími, léjta númami línda najínanicoo liá'a ley liyáali éerri nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Quéecha'inaa náiinucai lirrícula liá'a chacáaleeca, náirrau lirrícula liá'a cuítaca áacairra namáctala nayáca. Náa'a apóstoluca Pé'eru ya Juan, ya Santiago, ya Andrés, ya Felipe, ya Tomás, ya Bartolomé, ya Mateo, ya Santiago Alfeo cúulee, ya Simón liá'a Celóteca, ya Judas licúulee liá'a Santiagoca. ");
INSERT INTO aca_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Quinínama nayá náawacau séewirri quéewique'e na'óraca náajcha náa'a Jesús éenajinaica, ruájcha ruá'a Maríaca Jesús túwaca, ya náajcha náa'a áabi íinaca. ");
INSERT INTO aca_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Liyáalite náawacau náa'a éebidenai Dios nácu, namáanabaca újni ciento veinte chóniwenai, jáiwa Pé'eru táania limá'ee nalí: ");
INSERT INTO aca_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Nuéenajinai, arrúnaa licúmpliacoo liá'a Espíritu Santo máni Davidru, jái limácai lirrícu liá'a tánerricoo linácu liá'a Judasca, liá'a yúderri náa'a Jesús jínaica nawínaque'e preso liyá. ");
INSERT INTO aca_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Liá'a Judasca wéenaami, wáaleerrimi tráawaju léjta wayá. ");
INSERT INTO aca_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Ne jáiwa liáu liwéni áabai cáinabi liyú liá'a warrúwaca ligáanani máashiicaca liyá; néenee licáwai lijuátamiyu, jáiwa lipáquiawai, lijiáu quinínama líyacuaca. ");
INSERT INTO aca_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Quéecha'inaa néemiqui jíni náa'a yéenai Jerusalén, jáiwa náa lijí'inaa liá'a cáinabica Acéldama, nachuániyu wówerri limáca: ‘bacháida íirrai.’ ");
INSERT INTO aca_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Jiníwata líta'aa liá'a cáashta Salmoca limá'ee: ‘Liá'a jíibanaca máaquerri'inau bácai, jiní'inaa yáa rícu. Ya limá'ee lécchoo: Báqueerri wíneerri'inaa jishínaa tráawajumi.’ ” ");
INSERT INTO aca_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","Néenee Pé'eru má'ee nalí: “Wawáalia áani washiálicuenai tálidedeenaimi wayá quinínama éerri Jesús máa'inaami wáajcha, ");
INSERT INTO aca_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","jínanenaiu wáajcha quéecha'inaami libáutisactami Jesús liá'a Juanca, cáashia líirracoo wáucha áacairra. Mawíminaa sáica, néenaa máacacoo wáajcha, quéewique'e áabenaa wáajcha natáania sáica licáwiacaalau liá'a Jesúsca.” ");
INSERT INTO aca_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Néenee namáaca chámata: José, jí'ineerri Barsabás, ya áabai lijí'inaa Justo, matáli lijí'inaa, lijúnicai báqueerrica Matías. ");
INSERT INTO aca_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Ya jáiwa nasátau Dios yúcha cháji'i: “Wawácali, jiyá cúnusierri nawówa quinínama, jíyada walí tánashia jiwínani néenaa náani chámataca. ");
INSERT INTO aca_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","Quéewique'e liwína tráawajumi apóstolu shínaa, lipérdiani liá'a Judasca lishínaa lijíconaa nácueji, quéecha'inaa liácoo chaléeni liárrui yáctalaca.” ");
INSERT INTO aca_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Naméda léjta judíobini wítee napóstaca. Jáiwa naméda léji liéni Matías gánaa, ne liyáalimi limáacau náiibirrai náa'a once apóstoluca. ");
INSERT INTO aca_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Liyáalite léerdi íinu'inaa liá'a fiesta jí'ineerri Pentecostés, quinínama náa'a máaquenai nawówa Dios nácu, yáawaqueneu macáishita áabai cuíta rícuu. ");
INSERT INTO aca_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Cawíquinta, néemi áacaiji cawítamai wérri íinuca, léjta áabai cáuli cadánani, cawítamai wérri lirrícula liá'a cuítaca nayáctaca. ");
INSERT INTO aca_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Líyadau nalí léjta chichái íimini bérrucuta, cáirri nanácu quinínama. ");
INSERT INTO aca_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Ya quinínama namáacau cashiámu nayá Espíritu Santoyu, jáiwa nachánau natáania áabi chuánshiyui, léjta Espíritu Santo liwána natáaniaca. ");
INSERT INTO aca_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Liyáali éerri áabi judíobini yéenai Jerusalén rícu, náani éebidenai linácu liáni Dios wánani namédaca, íinuenai bájirra cáinabi íteeji. ");
INSERT INTO aca_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Náa'a chóniwenaica yáawaquenaiu néemi liá'a wítamashi, jiní néewau namáca, jiníwata bácainaa néemicala natáania náa'a éebidenaica Jesús nácu chúnsai nachuániyu. ");
INSERT INTO aca_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Nayá cáarrudedeeneu wérri nasátada néemiu nayá wáacoo: —¿Ya jócani Galilea néenee sána náji náani cháni wéemi táaniaca? ");
INSERT INTO aca_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","¿Tánda wéemi néewa natáania chúnsai wachuániyu? ");
INSERT INTO aca_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Áani ái chóniwenai já'a báawache sána jí'ineerri Partia, ya Media shínaa, ya Elam shínaa, ya Mesopotamia shínaa, ya Judea shínaa, ya Capadocia shínaa, ya Ponto shínaa, ya Asia shínaa cáinabi, ");
INSERT INTO aca_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ya Frigia shínaa, ya Panfilia shínaa, ya Egipto shínaa, ya náa'a cáinabi Libia shínaaca urrúni Cirénerru. Ái áabibi já'a íinuenai Roma néenee; ");
INSERT INTO aca_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","áabi judíobini já'a, áabi náaweneu judíobiniyu. Ya ái chóniwenai já'a íinuenai Creta néenee ya Arabia néenee. ¡Ya quinínama wéemi natáania chúnsai wachuániyu, linácu liá'a Dios médani máanuica! ");
INSERT INTO aca_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Quinínama nacáarrudau jiní náa léenaa namáca; ya nasáta néemi nayá wáacoo bácainaa: —¿Tánda libésunau liéni cháica? ");
INSERT INTO aca_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ne áabi nacáida'ee namá'ee: —¡Cámenai nárra! ");
INSERT INTO aca_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Néenee Pé'eru bárruawai náajcha náa'a once apóstoluca, limá'ee cadánani: “Judíobini, ya quinínama náa'a yéenai Jerusalén néenee, yáa léenaa quinínama liáni, éemi sáica liáni nuíiwani'inaa irrú. ");
INSERT INTO aca_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Náani jócani cáma nayáca léjta imáyu, wáalii las nueveca manúlacaiba. ");
INSERT INTO aca_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Jócai cha, léjta limáyumi liá'a íiwadedeerri Dios chuáni báinacu jí'ineerri Joel, limá'inaami: ");
INSERT INTO aca_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Bésuneerri'inau á'a amáarracta'inaa éerri, limá liá'a Diosca, nuwátani'inaa nushínaa Espíritu Santo quinínama chóniwenai íta'aa; náa'a éenibica washiálicuenaica, ya náa'a íinaca éenibinaaca natáaniaminaa nuchuáni nácu chóniwenairru, náa'a icúlinaica nacábaminaa natuírricu sái, ya náa'a salínaica nadájuniminaa dajuíshi. ");
INSERT INTO aca_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Ya lécchoo nanácu náa'a médenai nuwánacaala, ya nanácu náa'a íinaca médenai nuwánacaala, chóniwenaica nuwátaminaa nalí nuwítee dánaniu liá'a Espíritu Santoca liyáali éerri, natáaniaminaa nunácu. ");
INSERT INTO aca_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Éerri rícu núyadaminaa jócai icába cáji, ya cáinabi íta'aa íirrai, ya chichái, ya íisa léjta sáanai cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Liá'a cáiwiaca catáwacai'inaa, ya liá'a quéerrica náawerri'inau léjta íirrai, jóctanaa líinu léja liá'a Wawácalica, léerdi máanui ya sáictai wérri. ");
INSERT INTO aca_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Ne quinínama náa'a mánulicuenai Wawácali jí'inaa nácu, wásedeerri'inaa nayá.’ ");
INSERT INTO aca_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“Éemiu iyá, israelítabinica, liá'a numáni'inaa irrú: Léjta yáa léenau'u sáica, liá'a Jesús Nazaret néenee sáica, liyá washiálicuerri Dios wínani ináneewa limédaca lirrú léjta liwówau'u, Dios méda lirrícueji máanui sáictai wérrica, jócai icába cáji ya señal íibiu. ");
INSERT INTO aca_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Ne quéewanaa ná'inaa néewa náa'a icáaji rícu jíni, léjta limáyu liá'a Dios quéecha, iyája iwínani preso íinuaque'inini itáatani cruz nácu, nawánacanaa washiálicuenai máashiini wérrica. ");
INSERT INTO aca_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Ne jáiwa Dios cáweda jíni, liwáseda jíni liúcha liá'a cáiwibeeca máanalicaica, jócai léewa liwáalia néeni mamáarraca jíni. ");
INSERT INTO aca_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Liá'a rey Davidca, limáte Jesús nácucha: ‘Nuyá cáberri séewirri liá'a Nuwácalica nunáneewa; nuyácta liájcha sáicaquicteji, jiníminaa wána nucáacoo. ");
INSERT INTO aca_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Tándawa sáicta wérri nuwówa, ya nurrába nuínaneyu sáictaca nuwówa. Cadánani nuwówa cábacoo jinácu. ");
INSERT INTO aca_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Jiníwata jócuminaa jimáaca nunáanai útawi rícula, chacábacanaa jócu jínda nuíinaa bádacoo, nuyáwa jishínaa cashírruedacai jirrú majíconaica. ");
INSERT INTO aca_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Jíyadate nulí iníjbaa yáirri nucáwica, ya jicámusheda nuyá sáitau'u jiwána nuwówa jináneewa.’ ");
INSERT INTO aca_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“Nuéenajinai, índate nuíiwa irrú quinínama yáawaa liá'a wawérrimi Davidca máanaliyi ya naquénini, liá'a lishínaa útawica yéerri wáiibi újnibii. ");
INSERT INTO aca_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Ne liá'a Davidca íiwadedeerri Dios chuáni, ne liá léenaa Dios ma lirrú yáawaiyi liá'a báqueerri litáqueerri rey'inaa. ");
INSERT INTO aca_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Chacábacanaa újni licábani liyáca, David táanierrimi liyáca Cristo cáwiactacoo nácu, ya limá'ee liárra jócai'inaa lináanai máacau útawi rícula, jiní limáshicaimi máashiidacaalau. ");
INSERT INTO aca_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ne sáicai, quinínama iyá yáine léenaa Dios cáwedacala liá'a Jesúsca, linácueji quinínama wayá wáiiwadeda líiwanaa. ");
INSERT INTO aca_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Jesús nácuderriu quéewique'e liácoo liwáacoo sáicaquictejica Dios lisálijinaa éemanacu, tándawa Lisálijinaa yáa lirrú Espíritu Santo limánimi liáca, tándawa chóque'e Jesús yáa walí léja liérra Espíritu Santo icábani iyáca ya éemini. ");
INSERT INTO aca_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Wáa léenaa David jócai íirrau áacairra, liyá jájiu limá: ‘Dios ma Nuwácali, Cristorru: Jiwáau nuémanacu sáicaquictejica, ");
INSERT INTO aca_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","cáashia numáaca jijínai jíiba yáajba.’ ");
INSERT INTO aca_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“Yáa léenaa quinínama chóniwenai Israel shínaa cáinabi ítesana, quinínama yáawaiyica, liéni Jesús itáatanimi cruz nácula, Dios máacani Wawácaliyu ya Cristo.” ");
INSERT INTO aca_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Náa'a yáawaquenaicoo néemi'inaami liéni, máashii wérri nawówa cáiwinaa, ya nasáta'ee néemiu Pé'eru ya náa'a áabi apóstoluca namá'ee: —Numánubaca, ¿Tána arrúnaa wamédacai? ");
INSERT INTO aca_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Pé'eru éeba'ee: —Éejueda iyáu Diosru, ya ibáutisau bácainaa Jesucristo jí'inaa nácu, quéewique'e Dios méetuerri ijíconaa, ya cháminaa liá irrú liá'a Espíritu Santoca. ");
INSERT INTO aca_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Liáni libáulini liáca irrú sái'inaawa liérra ya éenibirru, ya lécchoo nalí náa'a yáainai déecuchala; liwówau'u limáca, quinínama náa'a Dios wawácali wówaini limáidaca. ");
INSERT INTO aca_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Liyú liáni chuánshica, Pé'eru táania ya liá nawítee limá'ee nalí: —¡Ishírriu náucha nárra chóniwenai máashiini cajíconaanica! ");
INSERT INTO aca_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Ne náa'a éewidenai lichuáni, jáiwa nabáutisawai; ne liyáalimi éerri nawínau náiibirra náa'a éebidenaica namáanabaca tres mil chóniwenai. ");
INSERT INTO aca_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Quinínama nayá cabálininaa léjta apóstolu éewidau nayá, ya nashírda nanácu wáacoo quinínama liá'a nawáalianica ya na'órau náawacacoo náayaca. ");
INSERT INTO aca_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Quinínama nayá nacáarrudacoo, nacába liá'a jócai nacába cáji Dios médanica narrícueji náa'a apóstoluca, líyadaque'e liwítee dánaniu. ");
INSERT INTO aca_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Náa'a éebidenaica yáawaquenaiu sáictaca nawówa náajcha wáacoo, ya nashírridani nashínau nanácu wáacoo; ");
INSERT INTO aca_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","nawéndadani nashínau ya quinínama liá'a nawáalianica, ya nashírridani liá'a warrúwaca nanácu wáacoo náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Éerri jútainchu náawacacoo templo rícula, ya nábana lícu wáacoo náaya macáishita sáictaca wérri nawówa, jiní báawatai cábacoo liúcha wáacoo. ");
INSERT INTO aca_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Náa sáicai Diosru, ya quinínama chóniwenai caníinaa nacába nayá; ya éerri jútainchu Wawácali dáwineda namánabaca náa'a liwásedani'inaaca. ");
INSERT INTO aca_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Áabai éerri, Pé'eru ya Juan náau templo rícula táicala las tres, éerdi judíobini óracoo. ");
INSERT INTO aca_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Néeni, templo núma lícu, báqueerri washiálicuerri macáwai lijiániu yáajcha, natéeni éerri jútainchu linúma licúla liá'a templo jí'ineerri Hermosa, quéewique'e lisáta náucha warrúwa náa'a wárruenaicoo náacoo. ");
INSERT INTO aca_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Quéecha'inaami macáwai cába Pé'eru ya Juan, jáni wówai nawárruacuwai templo rícula, lisáta náucha warrúwa. ");
INSERT INTO aca_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Pé'eru ya Juan yáajcha narrátueda'ee lirrú, jáiwa'ee Pé'eru má'ee lirrúi: —Jicába walí. ");
INSERT INTO aca_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Liá'a washiálicuerri licába'ee nalí, linénda tánashia náa lirrúi. ");
INSERT INTO aca_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Ne Pé'eru má'ee lirrú: —Jiní nulí warrúwa ya oro, ne liá'a nuwáalianica nuá'a jirrúni: Jesucristo Nazaret néenee sái jí'inaa nácu, jibárroo jijínacoo. ");
INSERT INTO aca_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Linísa'inaami limá liáni Pé'eru, wína licáaji sáicaquictejica ya libárrueda jíni, ya liyáalimi danáanshi íinu líiba rícu ya licúdi nácu. ");
INSERT INTO aca_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Liá'a macáwaica léenuu libárruacoo, ya lichánau lijínacoo, jáiwa liwárroo náajcha templo rúculai, chúnsai lijínacoo líibayu, léenunicoo liá sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Quinínama náa'a cábenai lijínacoo ya liá sáicai Diosru, ");
INSERT INTO aca_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","nacáarruda'eewoo nacábacani linácueji liá'a bésuneerricoo, náaca'ee léenaa nacába liá'a washiálicuerrica ya náa léenaa liyácala liá'a séewirrimi wáacoo lisáta warrúwa templo núma lícu jí'ineerri Hermosa. ");
INSERT INTO aca_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Liá'a macáwai níseerri sáicacai, jócai máaca Pé'eru ya Juan. Quinínama chóniwenai nacáarrudau, nacánacau liyácta liá'a templo númaca néerra jí'ineerri Salomón shínaa, á'a nayácta nayáca. ");
INSERT INTO aca_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Pé'eru cába'inaa liáni, limá nalí: “¿Tánda icáarrudau iyá israelítabini? ¿Tánda icába walí újni wayáchu chúni liéni washiálicuerri, újni wayáchu wána lijínacoo wadánaniyu o wéebidaca Dios nácu? ");
INSERT INTO aca_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Liá'a Abrahám shínaa Diosmica, Isaac ya Jacob, wawérrinaimi shínaa Dios, liyáwa Dios bánuerri wawácali Jesús, liwánacaalaque'e mawí quinínama yúcha. Ne iyá éejueda romanobinirru quéewique'e náiinuacani, ya áawita Pilato wówai liwásaidacani, iyá jócai índa liwásaidacani. ");
INSERT INTO aca_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Jócubeecha isáta Pilato yúcha liwásedaque'e liá'a majíconaica ya sáicaica, iyá isáta liwásedaque'e irrú báqueerri cáiinuacai. ");
INSERT INTO aca_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Ya cháte íinua liá'a yáirri wacáwica. Ne Dios cáweda báaniu jíni, táda linácueji wayá wáiiwadeda linácu yáawaiyi. ");
INSERT INTO aca_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Liá'a wáneerri cadánani licáwa liéni washiálicuerri icábani iyá icúnusianica, léebidaca lijí'inaa Jesús nácu. Liá'a limáacau liwówau Jesús nácu liyáwa wáneerri lichúnicoo sáica quinínama, léjta icábau'i quinínama. ");
INSERT INTO aca_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Nuá léenaa, nuéenajinai, quéecha'inaa iwácanai íinua Jesús, yáawaiyi iyá ya iwácanai jócai yáa léenaa liá'a imédanica. ");
INSERT INTO aca_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Ne Dios méda cha licábacanaa liá'a náiiwanimi libéecha náa'a quinínama íiwadedenai Dios chuáni báinacu: Léecala'e liá'a Cristoca máanali'inaa. ");
INSERT INTO aca_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Tánda, iyá rúnaa éejuacoo Diosru, ináwida iwíteu, quéewique'e liméetua yúcha ijíconau. Ne cájbami Wawácali bánua irrú éerri iwówa íyabaque'iu, ");
INSERT INTO aca_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","libánua irrú Jesús, liá'a liwínani quéechanacu léjta Cristo irrú'inaa. ");
INSERT INTO aca_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Báawita chóque'e Jesucristo yáa chaléja áacairra, cáashia Dios lichúni quinínama, léjta limáyumi nalí náa'a íiwadedeenaimi Dios chuáni báinacu yéenaimi báinacu. ");
INSERT INTO aca_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Moisés íiwadeda nanácu náa'a wawérrinaimica: ‘Liá'a wawácali Diosca liwána báqueerri jiácoo éewiderri Dios chuáni léjta nuyá. Éewidau lirrú quinínama liá'a limánica, ");
INSERT INTO aca_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","jiníwata quinínama liáni jócai méda liwánacaala liá'a íiwadedeerri Dios chuáni, jiérri'inau lirrícucha liáni chacáaleeca.’ ");
INSERT INTO aca_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","“Ya quinínama náa'a íiwadedenai Dios chuáni, ne íiwadedeerrini Samuel quéechanacu, natáania lécchu linácu liáni éerrica. ");
INSERT INTO aca_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Iyája irríshibiaminaa liá'a Dios máni liáca narrícueji náa'a íiwadedeenaimi Dios chuáni báinacu, ya lécchoo irríshibiaminaa liá'a Dios mánica nalí náa'a wawérrinaimica. Ne Dios ma Abrahámru: ‘Quinínama náa'a chóniwenaica yéenai cáinabi íta'aa narríshibiaminaa sáicai nanácu náa'a natáqueenaimica.’ ");
INSERT INTO aca_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Quéecha'inaa Dios cáweda licúuleu, libánuani quéechanacu iyáctala, quéewique'e litúya iyá, quéewique'e iyá bácainaa imáacaque'e ijíconau éejuaque'iu lirrú.” ");
INSERT INTO aca_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Újnibii Pé'eru ya Juan táanenaimi nayáca chóniwenairru, jáiwa náiinu nalí náa'a sacerdóteca, liájcha liá'a liwácali liá'a catúyacai templo ya náajcha náa'a saduceobinica. ");
INSERT INTO aca_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Íiwirri wówa jiníwata Pé'eru ya Juan éewidenai náa'a chóniwenaica, ya namá'ee léecala'e liá'a nacáwiactacoo máanalicai yúcha yáawaiyi, jiníwata licáwiacaalau liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Jáiwa nawína nayá preso, ya jái táicalacai, nawárrueda nayái cuíta manúma ricúla cáashia jucámarraca. ");
INSERT INTO aca_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ne íchaba náa'a éemenai lichuáni, náa'a éebidenaica Jesús nácu; namáanabaca náa'a chóniwenai éebidenai lichuáni atéwani cinco mílca jócai wajútada náa'a sáamanaica ya íina. ");
INSERT INTO aca_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Cajójchanaami náawacau lirrícu liá'a Jerusalén náa'a judíobinica wácanaica, ya náa'a salínaica ya náa'a quéewidacanica ley shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Néeni yáca liá'a Anás, nawácali náa'a sacerdótebini, Caifás, Juan, Alejandro ya quinínama náa'a néenajinai náa'a sacerdótebini wácanai éenaa. ");
INSERT INTO aca_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Nawána natéeca Pé'eru ya Juan, naínda nayá nasáta néemiu nayá: —¿Tána wánacaala nácu, ya tána jí'inaa nácu jíni iméda iyáji liáni? ");
INSERT INTO aca_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Jáiwa Pé'eru, cashiámui Espíritu Santoyu, léeba jíni: —Chóniwenai wácanai ya salínaibini: ");
INSERT INTO aca_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","Iyá isáta éemiu wayá linácu liáni bálinerricoo, yáaque'e léenaa chítashia éewau sáicaqui jiníni. ");
INSERT INTO aca_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Wée sáicai, wáiiwa irrúni quéewique'e náa léenaa náa'a quinínama chóniwenai Israel néenee sánaca, ne liéni washiálicuerri yéerri áani, quinínama náneewa, sáicacai Jesucristo jí'inaa nácu Nazaret néenee sái, liyája liérra iwánanimi natáata cruz nácu, liá'a Dios cáwedanimica. ");
INSERT INTO aca_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Liéni Jesús léjta íiba iyá camédacani cuíta jócaimi iwówai, ne liyáwa íinuerri limédacoo yáawaiyi íibaca. ");
INSERT INTO aca_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Quiní báqueerri mawiá éeneerri litée wayá áacairra, jiníwata mawiá éerri rícu Dios yáni mawiá báqueerri washiálicuerri éeneerri liwáseda wayá, újni Jesúsca. ");
INSERT INTO aca_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Ne nacába'inaa jíni, náa'a chóniwenai wácanaica, natáania danáanshiyu náa'a Pé'eru ya Juan, náa léenaa washiálicuenai jócani éenajta éewa naliáca, yáni léenaa májta rímii, jáiwa jiní namácai nacáarrudacuwai, ya náa léenaa jíni éewidenaicoo Jesús shínaa. ");
INSERT INTO aca_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Mawí'inaa, lécchoo liá'a bálinerrimiu jái sáicacai, néeni limáaca náajcha, tánda quiní néewa namáca linácucha. ");
INSERT INTO aca_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Jáiwa nawána najiácuwai náawacactacoo yúcha, jáiwa namáacau natáaniaca nayáca nayáwoo. ");
INSERT INTO aca_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Nayá namá'ee: —¿Tána waméda náajcha náani washiálicuenaica? Quinínama chóniwenai yéenai Jerusalén rícu yáine léenaa namédau liéni jócai wacába cáji, quiní wéewaca wamáca jóca namédani. ");
INSERT INTO aca_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ne léju liáni jócubeecha wawówai wéemi nanúma licuéji, wacáarruda nayá, jócu béecha natáania mawiá Jesús jí'inaa nácu. ");
INSERT INTO aca_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Jáiwa namáida nayái namá nalí jócu béecha natáania mawiá, jócu béecha néewida mawiá, quiní nácu mawiá lijí'inaa nácu liá'a Jesúsca. ");
INSERT INTO aca_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ne liá'a Pé'eru ya Juan néeba nachuáni: —Isátate éemiu iyá jájiu, sáicactani Dios náneewa, wéewidaquicta ichuáni quéechanacu ya jócuweeca wéewida Diosru. ");
INSERT INTO aca_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Wayá jócani éewa wamáaca wamá liá'a wacábanica ya liá'a wéeminica. ");
INSERT INTO aca_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Náa'a chóniwenai wácanaica nabáulida nayá, ne namáaca nayái. Quní náiinu najíconaa, jiníwata náa'a chóniwenai médenai sáicai Diosru quinínama, linácucha liá'a bésuneerricoo. ");
INSERT INTO aca_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Liá'a washiálicuerrica chúneerricoo sáica léjta licábacanaa jócai nacába cáji, wáaleerri'e mawí cuarenta camuí yúcha. ");
INSERT INTO aca_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Pé'eru ya Juan jáni nawásedacai, náawacacoo najúnicai yáajchau náiiwa nalíni quinínama nawácanai náa'a sacerdótebini ya salínai máni nácucha. ");
INSERT INTO aca_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Néemi'inaamini, quinínama áabebacta nasáta Dios yúcha, namá cháa: “Wawácali, jiyá méderri éerri, ya cáinabi, ya manuá ya quinínama liwáaliani néeni, ");
INSERT INTO aca_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","jimáte lirrícue liá'a Espíritu Santoca ya linúma licuéji liá'a lishínaa cashírruedacai jirrú Davidca: ‘¿Tánda cha chóniwenai ya cárra? ¿Tánda naméda mawítee liáni? ");
INSERT INTO aca_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Náa'a reyebini ya náa'a wánacaleenai cáinabi íiwirri nawówa, nayá quinínama náajcha áabenaani yáca Dios júnta, ya najúnta liá'a Dios wínanica, liá'a Mesíasca.’ ");
INSERT INTO aca_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","“Yáawaiyica lé'e liá'a Heródesca ya Poncio Pilato yáawaqueneu áani, lirrícu liáni chacáaleeca, náajcha náa'a chóniwenai báawatani chuáni ya náa'a israelítabinica, najúnta náa'a jishínaa Santoca shírruederri jirrú Jesúsca, léjta liá'a jiwínanica Mesíasca. ");
INSERT INTO aca_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Cháminaaja, nayá namédaminaa léjta jinísau jimácai, arrúnai'inaa bésunacoo. ");
INSERT INTO aca_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Wáalee, Wawácali, jicábateni nabáulidau wayá, ne wayá shírruedenai jirrú, jiyúda wayá jócubeecha cáarru wáiiwa jichuáni. ");
INSERT INTO aca_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Ne jidánaniyu sáicaque'e náa'a chóniwenai bálinenaicoo, wamédaque'e báawataica ya jócai wacába cáji lijí'inaa nácu liá'a Santo shírruederri jirrú Jesúsca.” ");
INSERT INTO aca_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Nanísa'ínaami nasátacuwai, á'a nayáctaca jáiwa licúsuwai; jáiwa cashiámu nayái Espíritu Santoyu, náiiwani cha nawíteemija liá'a Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Náa'a éebidenai íchabani, ne quinínama áabenaa nawówa náajcha wáacoo. Quiní máirri jishínaacalani bácai, ne nashínaa quinínama. ");
INSERT INTO aca_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Náa'a apóstolubini íiwenai cadánani wawácali Jesús cáwiactacoo, ya Dios túya nayá máanui quinínama. ");
INSERT INTO aca_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Quiní liyáali náiibi carrúni jináatai, nawáalianai cáinabi, ya cuíta nawéndani, liá'a warrúwaca, ");
INSERT INTO aca_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","náani apóstolubinirru nachújidaque'ini quinínamarru, léjta narrúnijina bácainaa. ");
INSERT INTO aca_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Cháwate libésunacoo báqueerrirru néenaa náa'a levítabinica jí'ineerri José, Chipre néenee sái, liá'a apóstolubini yáni jí'inaashi báawatai jí'ineerri Bernabé (liwówaiyu limáca “Liá sáictai wówa chóniwenai yáajcha”). ");
INSERT INTO aca_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Liéni washiálicuerrica wáaleerri áabai cáinabi, jáiwa liwénda jíni limáaca warrúwa nacáaji rícu náa'a apóstolubinica. ");
INSERT INTO aca_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Ne néeni báqueerri, jí'ineerri Ananías, ne nayá Safira líinu yáajchau, wéndenai áabai cáinabi. ");
INSERT INTO aca_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Liéni washiálicuerrica, limédani líinu yáajchau namáacau warrúwa éenaa yáajcha, ya namáaca áabata warrúwa nacáaji rícu apóstolubinirru. ");
INSERT INTO aca_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Pé'eru ma Ananíasru: —Ananías, ¿tánda jínda Wawásimi wárroo jiwówa licúla, jéenedaquinicta lichálujueda jiyáca Espíritu Santoca, áawita jiwína warrúwa éenaa napáidaumi jirrú cáinabi? ");
INSERT INTO aca_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","¿Ya jócai jishínaa léji liérra cáinabica? Ya jiwéndana jíni ¿jócai jishínaa liérra warrúwaca? ¿Jiá jiwówai jiméda jinúma yúwicau? Jócai méda jiyá jinúma yúwicau washiálicuenairru, méderri jiyá jinúma yúwicau Diosru. ");
INSERT INTO aca_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Ananías éemi'inaami liáni, licáu máanalina. Náa'a quinínama yáine léenaa cáarru wérri nayá. ");
INSERT INTO aca_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Jáiwa áabi icúlinai íinui, nadájida liá'a limáshicaimi natéeni naquéniqui'ini. ");
INSERT INTO aca_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Újni matáli hora liáwinaami ruwárruau ruá'a Ananías íinuca, jócu yáa léenaa tánashia bésuneerriwai. ");
INSERT INTO aca_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Pé'eru sáta léemiu ruyá: —Jíiwa nulíni: ¿Iwénda iyá liárra cáinabica le liwéni imáni nácucha? Jáiwa ruéeba jíni: —Jajá, léewa liwéni liérra. ");
INSERT INTO aca_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Pé'eru ma rulí: —¿Tánda itáania chárra éeneda iyáca Espíritu Wawácali shínaa? Náa'a íinu chéji téenaimi nabáyau jíinirri, chócaja natée jiyá lécchooja. ");
INSERT INTO aca_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Jái liyáali rucáu ruá'a Safira máanali'inaa Pé'eru íiba néeni. Nawárruau'inaa icúlinai, náiinu runácu máanali, ya natéu naquéni ruyá rúnirri éema nácu. ");
INSERT INTO aca_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Quinínama náa'a iglesia ísanaca, ya náa'a quinínama yáine léenaa liá'a bésuneerricoo, jáiwa cáarru wérri nayái. ");
INSERT INTO aca_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Dios yúda apóstolubini namédaque'e jócai nacába cáji ya méderricoo wérri chóniwenai íibi; ya quinínama yáawaquenaiu templo núma néerra jí'ineerri Salomón shínaa. ");
INSERT INTO aca_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Quiní néenaa náa'a áabica liwówai liwína yáacacoo náajcha, cáarruca nacába nawácanai, báawita quinínama chóniwenai cawáunta nayá natáania nanácucha sáica. ");
INSERT INTO aca_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Jáiwa manuába nayá washiálicuenaica ya íinaca, náa'a éebidenaica nawácali nácuu. ");
INSERT INTO aca_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Najéda náa'a bálinenaicoo cáaye rícula cama íta'aa ya yáarrubaishi íta'aa, jáicta Pé'eru bésunawai, cadánia litáana wínaque'e nayá. ");
INSERT INTO aca_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ya lécchoo áabi chacáalee urrúnini liyáca yáaineu íchaba chóniwenai Jerusalén néerra, téenaiu bálineneu ya chóniwenai wáaleenai espíritu máashii; ne quinínama sáicani'inaa. ");
INSERT INTO aca_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Liá'a sacerdótebini wácalica ya náa'a saduceobini éenaaca, yáainai liájcha, jáiwa cadéni nayái. ");
INSERT INTO aca_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Jáiwa nawína apóstolubinimi preso naníqui nayá cuíta manúmai rícula chacáalee shínaa. ");
INSERT INTO aca_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Ne báqueerri ángel Wawácali shínaa liméecu táayee linúma liá'a cuíta manúmaica, jái lijéda nayái jáiwa limá lirrúi: ");
INSERT INTO aca_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Yáa namówai, íibayu templo rícula, íiwa chóniwenairruni liéni cáwiacaishi wáaliica.” ");
INSERT INTO aca_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Léjta éemiu'inii, cajójchanaami nawárroo manúlacaiba templo rícu, jáiwa néewidai. Nácula, liá'a sacerdótebini wácanai ya náa'a yéenai liájcha, namáida salínaibini israelita áabai yáawaquedenaiu nawácanai nayáwoo, nawána nácu néeda cuíta manúmai rícueji náa'a apóstolubinica. ");
INSERT INTO aca_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ne náiinu náa'a catúyacani cuíta manúmai rícula, jócu náiinu nanácu náa'a apóstolubinica. Jáiwa néejoowai chuánshi yáajcha, ");
INSERT INTO aca_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","namá'ee: —Wáiinu cuíta manúmai báyeerricoo sáica, ya soldado néenini túyaca cuíta núma júntami; ne waméecu'inaani quiní wáiinuni nácu lirrícula. ");
INSERT INTO aca_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Quéecha'inaa léemiqui jíni sacerdótebini wácalica, ya liá'a nawácali náa'a catúyacani templo, ya nawácanai náa'a sacerdótebini, nasáta'ee nayá wáacoo táshia liáu léju liáni. ");
INSERT INTO aca_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Néenimichu báqueerri íinu, limá'ee nalí: —Náa'a iwárruedanimica cuíta manúmai rícula, náa'a yáa templo rícula éewidenai nayáca chóniwenai. ");
INSERT INTO aca_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Liá'a nawácali náa'a catúyacanica náajcha náa'a túyenai, náau néeda nayá; ne jócani náinueda, cáarruca nacába chóniwenai íinueda nayá íibayu. ");
INSERT INTO aca_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Náiinu'inaami natée nayái najúntanaa nawácanaicoo, liá'a nawácali náa'a sacerdótebini limá nalí: ");
INSERT INTO aca_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","—Wayá wanísa wamá irrúi jócubeecha itáania mawiá, linácu mawiá léji liérra jí'inaashi liérra. ¿Iyá tána imédajoo? Jái cashiámu iméda Jerusalén liyú liérra éewidauca, ya líta'aa mawí iwówai yáa wáta'a limáanalica liérra washiálicuerrica. ");
INSERT INTO aca_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Pé'eru ya náa'a apóstolubini néeba'ee chá'a: —Mawí cawéni liá'a Dios wánani wamédaca, liúcha liá'a washiálicuenai shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Liá'a Dios wawérrinaibimi shínaa cáwedeerri Jesús, léja liérra íinuanimica icuájidani cruz nácu. ");
INSERT INTO aca_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Dios nácuda liyá limáaca liyá machácaniquicteji, limáaca liyá nawíta ya wásedeerri nayá, quéewique'e chóniwenai quinínama Israel shínaa néejoocoo Diosru ya néewaque'e najíconaa méetuacoo. ");
INSERT INTO aca_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Wayá yáini léenaa lécchoo wacábacaalani, tánda wáiiwani lécchoo, liá'a Espíritu Santo Dios yáni nalí léquichoo náa'a éebidenaica. ");
INSERT INTO aca_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Quéecha'inaa néemi jiliáni, íiwirri wérri nawówa, jáiwa nawówai náiinuaqui jíni. ");
INSERT INTO aca_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ne náiibi náa'a nawácanaica, báqueerri fariseo jí'ineerri Gamaliel, báqueerri quéewidacai ley shínaa, chóniwenai íchaba cawáuntani'e. Jáiwa libárruawai ya liwána najéda nayá náa'a apóstolubini íchaitaa. ");
INSERT INTO aca_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Néenee limá nalí náa'a áabi wánacaleenaica: —Israelítabini, cáwi icába yúchaujoni namédani'inaa náani washiálicuenaica. ");
INSERT INTO aca_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Édacaniu báinacu nácu báqueerri washiálicuerri jiáteu jí'ineerri Teudas, máirri'e liyá washiálicuerri wérricala'e liyá, jáiwa'ee cuatrocientos washiálicuenai yáau liájchai. Ne liéni náiinuanica ya náa'a yáainaimicoo liájcha cáarralianaiwai, jáiwa amáarra quinínama jíni. ");
INSERT INTO aca_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Néenee liáwinaami, liá'a censo éerdimi, jáiwa lijiáu báqueerri Judas, Galilea néenee sái, jáiwa'ee líinu áabi yáaineu liájcha; jáiwa náiinua jíni lécchoo, ya náa'a yáainaimicoo liájcha cáarralianaiwai. ");
INSERT INTO aca_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Tánda, nuá iwítee imáaca náani washiálicuenaica, u'iníquiu náajcha. Jiníwata liáni shínaashica washiálicuenai shínactani bésuneerri'inau. ");
INSERT INTO aca_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Ne Dios shínactani, jócainaa éenaa yáajcha. Cáwiwa icá yúchaujoo, wíshiquicta iméda iyá danáanshi Dios júnta. Nayá naméda liwánacaala. ");
INSERT INTO aca_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Jáiwa namáida apóstolubini, néenee nabásaida nayá, jáiwa néeneda náiiwaca jócubeecha náiiwa Jesús jí'inaa mawiá; liáwinaami nawáseda nayái. ");
INSERT INTO aca_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Náa'a apóstolubinica jiáineu nanáneewa náa'a wánacaleenaica sáitani wérri wówa, léca, Dios wówaiyu carrúni jináatai máashiicaishi linácucha liá'a Jesús jí'inaaca. ");
INSERT INTO aca_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Éerri jútainchu néewidaca ya náiiwaca liá'a sáicaica chuánshica Jesús shínaa liá'a Mesíasca, léjta templo rícu ya cuíta lícu. ");
INSERT INTO aca_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Liyáali éerrimi, namáanabaca náa'a éebidenaica dáwinerri liáacoo mawí, natáania néemi griégoyu, jáiwa najútawai nanácu náa'a táanianai hebreoyu, namá'ee nanácucha náa'a máanirrini griegasca jócala néenaa natúya nayá sáica jáicta éerdi nachújidaca. ");
INSERT INTO aca_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Náa'a doce apóstolubini náawaqueda'ee náa'a éebidenai quinínama, namá'ee nalí: —Jócai sáica wamáaca liá'a wáiiwadeda Dios chuáni linácu jiliáni washírruedau náaya náa'a chóniwenai carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Tánda, wéenajinai, imúrru íibi siete washiálicuenai icúnusiani wítee, cawíteenibinai ya cashiámu Espíritu Santoyu, wamáacaque'e nalí liéni tráawajuca. ");
INSERT INTO aca_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Wayáminaa mamáarraca sátacoo ya wáiiwadeda Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Quinínama áabenaa nawówa, jáiwa nawína Esteban, washiálicuerri cashiámui wítee éebiderri ya Espíritu Santo nácu, ya Felipe, ya Prócoro, ya Nicanor, ya Timón, ya Parmenas, ya Nicolás, báqueerri Antioquía sái, quéecha níquerriu judaismo rícula. ");
INSERT INTO aca_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Jáiwa natée nayá apóstolubini néerra, jáiwa nasáta Dios yúcha nanácuda nacáajiu náta'aa, quéewique'e Dios yúda nayá linácu liáni tráawajuca. ");
INSERT INTO aca_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Liá'a Dios chuánica mamáarracai dáwinacoo libéechalawoo, liá'a namáanabaca náa'a éebidenaica mamáarracai manuábaca Jerusalén rícu. Mawíquichuca íchabani sacerdote judío éebidenai linácu. ");
INSERT INTO aca_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Esteban cashiámui Dios wíteeyu, ya sáicabeeyu Dios shínaa, liméda jócai nacába cáji ya liá'a méderricoo chóniwenai íibi. ");
INSERT INTO aca_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Áabibi sinagoga rícu jí'ineerri cashírruedacani jáni wasácuwai, náajcha náa'a áabi Cirene néenee sána, Alejandría néenee, Cilicia néenee, cáinabi Asia néenee sái, náani chóniwenaica jáiwa nacáita yáacawai Esteban yáajcha; ");
INSERT INTO aca_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ne jócai néenaa liájcha, jiníwata litáaniacala lidánaniyu liyú liá'a liwíteeyu Espíritu Santo yáni lirrú. ");
INSERT INTO aca_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Napáida'ee áabibi lécchoo náiiwaque'e Esteban íiwaca chuánshi máashii Moisés júnta yá Dios júnta léquichoo. ");
INSERT INTO aca_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Cháwa cábacanaaji nacáarralia chóniwenaiji ya salínai ya quéewidacai ley shínaabini; tánda natáca Estébanmi, nawínani preso, jáiwa natée jíni chaléeni nawácanai néerra. ");
INSERT INTO aca_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Jáiwa namúrru chóniwenai canúmai yúwicani, namá'ee: —Liéni washiálicuerrica jócai éenaa manúmaca lijúnta liáni santo temploca ya lijúnta liá'a leyca. ");
INSERT INTO aca_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Ne wéemi jimáca liérra'ee Jesús Nazaret néenee sáica, licáarraliani'inaa liérra temploca, náawiderri'inaa liá'a wíteeshica Moisés máacanimica. ");
INSERT INTO aca_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Náa'a wánacaleenaica, náa'a quinínama wáainecoo, nacába'inaa Esteban, nacába lináni jicá'a báqueerri ángel. ");
INSERT INTO aca_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Liá'a sacerdótebini wácanai lisáta léemiu Esteban, liá'a namáni jinácucha yáawactajani, ");
INSERT INTO aca_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","jáiwa léeba jíni: “Iyá numánubaca ya iyá nujúnicaica, éemiteni nulíni: Washínaa Dios cadánani balíbali wérrica, líyada liyáu wawérrimi Abrahámru, liyá'inaami cáinabi Mesopotamia shínaa, jóctanaa liáu liyáca Harán rícula, ");
INSERT INTO aca_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","ne limá lirrú: ‘Jimáaca jishínaa cáinabiu ya náa'a jimánubaca, jiá namówai chaléeni cáinabi núyadani'inaa jirrú.’ ");
INSERT INTO aca_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Jáiwa, Abrahám jiáu chéji Caldea néenee, jáiwa liáu liyá Harán rículai. Liáwinaami máanali jisálijinaami ya Dios índa Abrahám áani íinuctala iyá chóque'e. ");
INSERT INTO aca_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ne quiní lishínaa limáacani néeni; quiní wíta liwáidactana líibau. Ne limá lirrú liáminaa lirrújoo liáni cáinabica quéewique'e liáwinaami máanalicojoni limáacau litáqueenairru, (áawita liyáali éerrijoo Abrahám jiníte cúulee). ");
INSERT INTO aca_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Lécchoote, Dios ma lirrú, táqueenaiminaajoo yáaine'inaa chaléjta chóniwenai báawatani áabai cáinabi báawatai íta'aa, chóniwenai íjirra, máashiiminaa nacába nayájoo cha mánubaca cuatrocientos camuíjoo. ");
INSERT INTO aca_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Lécchoo Dios ma lirrú: Nuyáminaajoo cástigaa nayájoo yáaine líta'aa liérra cáinabi náa'a wánenaica nájirra nayá, liáwinaami'inaajoo najiáminau che jórra náiinuminaa nusírbia nulíjoo líta'aa liáni cáinabicojoo. ");
INSERT INTO aca_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Limácanica Dios méda Abrahám yáajcha, liwána náiju nachíipi dácu íimanaa. Tánda, liwáalianami ocho éerri lijiácuwai jicúulee Isaac, Abrahám íju lichípi dácu íimanaa. Cháwa liméda Isaac licúulee Jacob yáajchau, ya Jacob liméda lécchoo léenibi yáajchau, nayáwa'ee nasálijinaa náa'a doce tribu israelítabinica. ");
INSERT INTO aca_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Náani Jacob éenibica, náa'a wawérrinaibimi quéecha, cadéni'inaa nacába néenajirri José, jáiwa nawénda jíni natéeque'e jíni Egiptola léjta nájirra. Ne Dios yéerri José yáajcha, ");
INSERT INTO aca_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ne litúya liyá liúcha liá'a máashiu liwówa. Dios liá lirrú wíteeshi máanui, jáiwa sáica licáacoo Faraónrui, rey Egipto shínaa, jáiwa limáaca Josémi wánacaleerri Egipto rícu ya cuíta máanui wérri rícula. ");
INSERT INTO aca_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Liyáali éerrija ínaashi ya máashii wérri nawówa quinínama cáinabi Egipto rícu ya Canaán rícu ya náa'a quéecha wawérrinaibi quinínibinai wáalia náaya'inau. ");
INSERT INTO aca_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Quéecha'inaami Jacob yáa léenaa Egipto néeni ái'e trigoja, libánua'ee néerra léenibiu, nuwówayu numáca náa'a wawérrinaibimica. Léewate quéecha nácui náctamiu namédanimi liáni. ");
INSERT INTO aca_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Náa'a náau chámaichui, jáiwa José líyadau nalí néenajinaica liyá, jáiwa Faraón yáa léenaa tánashia éenaa léji liá'a Joséca. ");
INSERT INTO aca_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Mawí libéechau, jáiwa José libánua jisálijinaa Jacobru ya náa'a jéenajinai, setenta y cinco chóniwenai, natéequene'e nayá Egiptola. ");
INSERT INTO aca_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Léewau'inaa Jacob éewa liácoo Egipto néerra; liáwinaami néeni máanali jíni, liáwinaami néeni lécchoo máanali náa'a wawérrinaimi. ");
INSERT INTO aca_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Liá'a nayájidemi Jacob natéeni Siquem néerra, naquénique'e nayá líta'aa cáinabi liá'a Abrahám liwénini warrúwayu néenibi yúcha náa'a Hamor, Siquem néeni. ");
INSERT INTO aca_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Quéecha'inaami urrúni liá'a éerri licúmpliactala'inaacoo liá'a Dios máni liá'a Abrahámru, náa'a chóniwenai israelítabinica manuába wérri nadáwinacoo Egipto shínaa cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ne liyáali éerri báqueerri rey wánacaala Egipto rícu, jócai cúnusia José. ");
INSERT INTO aca_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Liáni rey lichálujuedate washínaa chóniwenai, ya liá nalí cáiwinaa náa'a wawérrinaimica; liwána máashiiyu namáaca ya náiinua nacúuleu wáaliimi jiácoo. ");
INSERT INTO aca_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ne liyáali éerrimi Moisés jiáu. Liyá samálitaca sáictai Dios cába liwítee, ya lisálijinaa ya litúwa dáwina jíni liyá líibana lícuu matáli quéerri. ");
INSERT INTO aca_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Ne quéecha'inaami arrúnaa namáaca liyái, Faraón míyacaula éeda jíni ta rudáwinaqui jíni jicá'a chúnsai rucúuleeca. ");
INSERT INTO aca_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Tándawa Moisés éewidau nawítee rícueji náa'a egipcioca, jáiwa lináwau washiálicuerri máanui wérri wítee, chuánshiyu ya liá'a limédani nanáneewa. ");
INSERT INTO aca_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Liwáalia'inaami cuarenta camuí, Moisés yá'eewoo licábadedaca israelítabini, náa'a chúnsana lishínaa chóniwenai líirranaa wéenaica. ");
INSERT INTO aca_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Ne licába'inaa báqueerri egipcio íinueda liyá báqueerri israelita léenaa, Moisés wárrua'eewoo liyúda léenaaca, jáiwa líinua egipciomi. ");
INSERT INTO aca_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Ne jiníwata Moisés máirri lirrúwoo léenajinai israelítabini yáaquinicta léenaa, lirríjcue'inaacala Dios jéda nayá liúcha liá'a carrúnatabeeca; ne nayá jócu néenaa náa léenaa jíni. ");
INSERT INTO aca_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Ne áabai éerri ricúla, Moisés íinu licába chámata israelítabini íinua yáaquenaiu nayáca, ne liwówai lichúni nayá, limá'ee nalí: ‘Iyá éenajinai yáaquenaiu; ¿tánda íinueda iyácau? ");
INSERT INTO aca_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Néenee liá'a báqueerri íinuederri liyá lijúnicaiu lidána'ee Moisés limá'ee lirrú: ¿Tána máaca jiyái wawácali ya cáberri'inaa wanácu? ");
INSERT INTO aca_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","¿Ya jiwówai jíinua nuyá lécchoo léjta jíinua'u táiquicha egipcioca? ");
INSERT INTO aca_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Quéecha'inaami léemi liéni, Moisés máni'eewoo liácoo Madián shínaa cáinabi néerra. Néerra liyái áawita jócaimi néerra sáimi, liwáalia chámata léenibiu néerra. ");
INSERT INTO aca_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Cuarenta camuí liáwinaami, liyá chaléeni jiníctala yáa, urrúni lirrú liá'a dúuli jí'ineerri Sinaí, báqueerri ángel íyadau lirrú áabai banácali jí'ineerri zarza jújunerriu íibi liyáca. ");
INSERT INTO aca_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moisés cáarruda'eewoo licába liá'a licábani liyáca, ne quéecha'inaami lirrúnicoo licába mawí urrúni, léemi'e liwácali chuáni, limá'ee lirrú: ");
INSERT INTO aca_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Nuyáwa liá'a Dios iwérrinaimi shínaaca. Nuyáwa Dios Abrahám shínaa, ya Isaac ya Jacob.’ Moisés chána'eewoo lichéchinacoo licáarruniu, jóca'ee liá liwówau licábacani. ");
INSERT INTO aca_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Néenee liwácali má'ee lirrú: ‘Jimídu jizápatoeu, jiníwata liérra cáinabi jibáwacta jiyáca madúnucunai. ");
INSERT INTO aca_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Jucámarranaa nucába carrúni jináata nushínaa chóniwenai yáainai Egipto nácu. Nuéemi nawítama jútacoo, tándawa núrrucuau quéewique'e nujéda nayá máashii yúcha. Tándawa jíinu chérra, quéewique'e nubánua jiyá Egiptola.’ ");
INSERT INTO aca_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ne áawitate nacháani Moisés ya namáte lirrú: ‘¿Tána máaca jiyái wawácali cáberri'inaa wanácu?’, Dios bánua liyá nawácali'inaa jéderri'inaa nayá máashii yúcha, lirrícueji liá'a ángel íyaderricoo lirrú banácali zarza jújunerriu íibi. ");
INSERT INTO aca_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ne Moisés waliérra jéderrite wawérrinaimi Egipto rícucha, liá'a méderrite jócai wacába cáji ya liá'a wacábanica líta'aa liá'a cáinabi Egipto shínaaca, chaléeni manuá quíirrai néerra ya chaléeni jiníctala yáairri cuarenta camuí'inaa. ");
INSERT INTO aca_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Léwa Moisés léja liérra máirrimi nalí náa'a israelítabinica: ‘Dios wánaminaa lijiácoo íibicha báqueerri cáiiwadedacani nuchuáni léjta nuyá. ");
INSERT INTO aca_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Léwa Moisés lécchoo léja liérra jínederrimi israelita wítabi jinícta yáairri, liájcha liá'a ángel táanierrimi lirrú dúuli jí'ineerri Sinaí néeni, ya náajcha náa'a wawérrinaibimica; liyáwa liá'a ríshibierrimi chuánshi cáwii quéewique'e libésuneda walíni. ");
INSERT INTO aca_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Ne náa'a wawérrinaibimi jócu nawówai néewida lirrú, quéewanaa nacháanicajani nawówai néejoocoo Egiptola. ");
INSERT INTO aca_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Namá'ee Aarónru: ‘Jiméda walí áabibi diose jínedeerri'inaa wawítabi, jiníwata jócai wáa léenaa tánashia yéesa léji liéni Moisés jéderrimi wayá Egiptoeji’. ");
INSERT INTO aca_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Néenee naméda áabai ídolo léjta pacáa cúulee cábacanaa, náiinua lirrú cuéshinai ta naméda liyáanaami áabai fiesta wérri, lirrú liá'a becerro cábacanaaca nayái médaca. ");
INSERT INTO aca_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Tándawa linácueji, Dios shírriu náucha línda náa lirrú sáicai náa'a sáaliica. Ne cháwa litánacoo nacáashte íta'aa náa'a cáiiwadedacanimi Dios chuáni báinacu: ‘Israelítabini, ¿Ya jócute cuarenta camuí jinícta yáairri, yáate nulí cuéshinai éemanimica ya áabata mawí? ");
INSERT INTO aca_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ne jócu cha jíni, quéewanaa yáanaida licábacanaa liá'a dios jí'ineerri Moloc, ya liájcha liá'a sáalii cábacanaa lishínaa liá'a dios Refán, dios cábacanaa quéewique'e yáa nalí sáicai. Tándawa núcaminaa iyá chaléeni áabai cáinabi ítala, mawí chaléeni jí'ineerri Babilonia.’ ");
INSERT INTO aca_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“Wawérrinaibimi wáalianaite chaléeni jinícta yáairri templo licábacanaa léjta tólda máanui, chái médacoo léjta Dios íiwaumi Moisésruni, léjta líyadau lirrú licábacanaa. ");
INSERT INTO aca_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Náa'a wawérrinaibimica narríshibia liéni templo cábacanaaca máaquerricoo nalí, ya náa'a íinuenaimi Josué yáajcha naínda yáajchau jíni quéecha'inaami néeda áabi chacáalee cáinaberra, náa'a Dios jédani nabéechau. Chacábacanaa cáashia David yáctalaca. ");
INSERT INTO aca_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Liá'a rey Davidca sáica Dios cábaqui jíni, liwówaite liméda áabai yáarruishi nayácta'inaamicta náa'a Jacob táqueenaimica. ");
INSERT INTO aca_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Ne Salomón waliérra bárruedeerrimi templo Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Áawita liá'a Dios áaque sáica jócai yáa templo rícu namédani nacáajiyu washiálicuenaica. Léjta limáyu'u liá'a cáiiwadedacani Dios chuáni báinacu: ");
INSERT INTO aca_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Liá'a éerrica léwa nuárrui, liá'a cáinabica léwa numáacacta nuíibau. ¿Chítashia cábacanaa liá'a cuíta nabárruedani nulí?, limá liá'a wácalishica; ¿tánashia nuárrui nuwówa íyabacta'inau jíni, ");
INSERT INTO aca_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ne nuyáwa liérra méderri quinínama yáairrica?’ ");
INSERT INTO aca_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","“Ne Esteban má'ee nalí mamáarraca: Iyá mamáarracani mawíteeca, wáalianai iwíbau ya iwówa jócai éebida. Séewirri iyá lijúnta liá'a Espíritu Santoca. Cháni cábacanaa léjta iwérrinaimi. ");
INSERT INTO aca_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","¿Tána náiibicha náa'a cáiiwadedacanimi Dios chuáni báinacu jócani iwérrinaimi íinueda? Nayá íinuenai náa'a íiwenai líinucala'inaa liá'a chóniwerri machácanica, ne chóque'e linísaca líinu liéni washiálicuerri machácanica, iyá yáa lijíconaa ya ta íinuaqui jíni. ");
INSERT INTO aca_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Iyá, ríshibienai liá'a ley narrícueji náa'a ángelbinica, jócai iméda wánacaala.” ");
INSERT INTO aca_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Quéecha'inaami néemi jiliéni, íiwirri wérri nawówa, náamueda néu Esteban júnta. ");
INSERT INTO aca_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ne liyá, cashiámui Espíritu Santo wíteeyu, licába áacairra licába'ee Dios cámarra, licába'ee Jesús bárruerriu liyáca sáicaquictejica Dios éema nácu. ");
INSERT INTO aca_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Néenee limá'ee: —¡Icábate! nucába éerri méecucoo, ya Washiálicuerri Dios Cúuleeca sáicaquictejica Diosru. ");
INSERT INTO aca_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Ne nayá nabáya'ee nawíbau, namáidada'ee cadánani náu'eewoo linácula quinínama. ");
INSERT INTO aca_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Najéda'ee chacáalee rícucha jíni ya náiinueda'ee íibayu jíni; yá'ee yáinai lijíconaa namáaca'ee liá'a líibalaca báqueerri icúlirrijui jí'ineerri Saulo, quéewique'e litúyacani. ");
INSERT INTO aca_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Nácula náiinueda íibayuni, Esteban óra'eewoo limá'ee: “Nuwácali Jesús, jirríshibia nucáwica.” ");
INSERT INTO aca_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Néenee litúyau liúrruiu juátamiyu limáidada'ee cadánani limá'ee: “¡Nuwácali, ujédacaniu linácu liáni najíconaaca!” Ne linísa'inaami limá léji liéni, máanali jíni. ");
INSERT INTO aca_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Saulo néeni yáaca, áabenai wówa náajcha náiinua'inaa Esteban. Liyáali éerrimi lichána naméda jináwiu najúnta náa'a éebidenai Dios chuáni Jerusalén rícu. Ne bácai rími náa'a apóstolubini máaquenai Jerusalén rícu, ne náa'a quinínama éebidenai nacáarraliau quinínama cáinabi ítala Judea shínaaca ya Samaria. ");
INSERT INTO aca_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Áabi washiálicuenai sáicani naquéni Estébanmi yá'ee náicha bájialanaa linácueji. ");
INSERT INTO aca_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Nácula Saulo licánaqueda náa'a éebidenai Dios chuáni, liwárrua'eewoo cuíta jútainimi lijédaque'e liárdedani washiálicuenai ya íina, ya libánua nayá cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ne náa'a rúnaanimi jiácoo Jerusalén rícucha, náiiwadeda'ee Dios chuáni táshia náctau jíni. ");
INSERT INTO aca_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Felipe, báqueerri néenaa, liá'eewoo chacáalee mawí cáiiwanaca Samaria shínaaca lichána'eewoo litáania nalí Cristo nácue sái. ");
INSERT INTO aca_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Náawaca'eewoo náa'a chóniwenaica, quinínama nábedacoo Felipe chuáni nácu, nacábacala liméda jócai nacába cáji nanáneewa. ");
INSERT INTO aca_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Íchaba chóniwenai wáalianai espíritu máashiini chúneneu, ya náa'a espíritu máashiinica najiá'eewoo namáidada náucha, ya lécchoo íchaba macáwani ya náa'a tucútucunica chúneneu. ");
INSERT INTO aca_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Linácueji liéni sáicta wérri nawówa lirrícu liá'a chacáaleeca. ");
INSERT INTO aca_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ne néeni báqueerri washiálicuerri jí'ineerri Simón, quéecha éewerri lirrúwoo limálica, lichálujueda chóniwenai Samaria ísanaca libésunacoo washiálicuerri cawéni wérri. ");
INSERT INTO aca_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Quinínama, náa'a sáamanai ya náa'a salínaica, néemi'e lirrú quinínama, ya namá'ee: “Léwa namáni nácucha liáni ‘liá'a Dios wíteeca’.” ");
INSERT INTO aca_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Naméda'ee liwánaca néewida'ee lirrú, jiníwata limálicaji rícueji, lichálujueda nayá íchaba éerri. ");
INSERT INTO aca_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Ne quéecha'inaami néebida sáicai chuánshi nácu Felipe íiwadedani, linácueji liá'a Dios wánacaalactalaca, ya linácue sái liá'a Jesucristoca, tándawa washiálicuenai ya íina nabáutisau. ");
INSERT INTO aca_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Áawita Simónimi léebida liwána nabáutisa liyá lécchoo, lichána'eewoo litálideda Felipe, licáarrudau licába liá'a máanui jócai licába cáji ya señal licábanica. ");
INSERT INTO aca_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Quéecha'inaami náa léenaa náa'a apóstolu yáaine Jerusalén rícu, Samariacala'ee éebiderri Dios chuáni, nabánua'ee néerra Pé'eru ya Juan. ");
INSERT INTO aca_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Náiinu'inaami néerra, na'óra nanácu náa'a éebidenai Dios chuáni Samaria rícu, quéewique'e narríshibia Espíritu Santo. ");
INSERT INTO aca_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Jiníwata jócai íinu nanácu újnibi liá'a Espíritu Santoca; bácai rímii nabáutisau Jesús Wawácali jí'inaa nácu. ");
INSERT INTO aca_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Néenee Pé'eru ya Juan nachánaa nacáajiu nanácu, cháwa'ee narríshibia Espíritu Santo. ");
INSERT INTO aca_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Simón, licába'inaa Espíritu Santo íinu nanácula, jáicta apóstolubini chánaa nacáajiu chóniwenai nácui, libáuli'e liá nalí warrúwa, ");
INSERT INTO aca_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","limá'ee nalí: —Yáa nulí lécchoo liérra wíteeshica, quéewique'e nuchánacta nucáajiu, lirríshibiaque'e lécchoo Espíritu Santo. ");
INSERT INTO aca_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Néenee Pé'eru éeba'ee lichuáni: —¡Jiwárruani yúcau jiájcha, jiníwata jimáca jirrúwoo jiwéni warrúwayu liá'a Dios wíteeca! ");
INSERT INTO aca_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Jiyá jiní wána jirríshibia jiyáca, jiníwata Dios náneewa jiwówa jócai machácani. ");
INSERT INTO aca_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Jimáaca liérra jijíconaacoo, ya jisáta cáiwinaa Dios, cájbamicta liméetua jijíconaa chácala jimá jirrú wawárra. ");
INSERT INTO aca_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Nucábacala jiyá cashiámu jiwówa máashiiyu, ya jijíconaa bájiderri jiyá. ");
INSERT INTO aca_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Simón éeba'ee: —I'óraa iwácaliu nunácueji, jócubeecha máashii libésunacoo léjta imáyu'u nulí. ");
INSERT INTO aca_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Liáwinaami quinínama náyada nayáu náiiwadeda Dios chuáni, náa'a apóstoluca náiiwa sáicai chuánshica íchaba chacáalee júbini Samaria shínaa rícu, ya tá'ee néejoocoo Jerusalénrai. ");
INSERT INTO aca_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Liáwinaami liáni, báqueerri ángel wawácali shínaa limá Feliperru: “Jibárruau ya jiáu báchairra, lirrícuba liá'a iníjbaa Jerusalén néenee sáica yáairricoo Gazala.” Liéni iníjbaa bésuneerriu jiníctala yáairri. ");
INSERT INTO aca_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","Felipe bárrua'eewoo, jáiwa liáwai; ne iníjbaa lícu lijúnta yáacau báqueerri cawéni wérri, wánacaleerri ruwárruani ruá'a reina Etiopía sáica. Liéni washiálicuerrica yáairriu Jerusalénra liá sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Jái éejoocoo liácoo lichácaaleerrau, wáairriu liácoo carroza rícuu ya liliá'ee liácoo licáashtemi liá'a cáiiwadedacai Dios chuáni báinacu, jí'ineerri Isaías. ");
INSERT INTO aca_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Espíritu má'ee Feliperru: “Jiáyu jirrúniu lirrú liérra carrozaca.” ");
INSERT INTO aca_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Quéecha'inaami Felipe lirrúnicoo, léemi'e etiope liliá liácoo Isaías cáashtemica; néenee Felipe sáta léemiu jíni: —¿Jiá léenaa jéemica léja liérra jiliéni jiyáca? ");
INSERT INTO aca_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Léeba'ee liá'a etiopeca: —¿Chíta quéewoo'u nuá léenaa nuéemiqui jiníni, jiní yáa léenaa líiwa nulí? Néenee lisáta Felipe yúcha quéewique'e líirracoo liwáacoo léema nácu. ");
INSERT INTO aca_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Liá'a tánerricoo cáashta íta'aa liliéni liyáca liwówau limáca: “Natéete liyá jicá'a áabai oveja natéeni náiinuactalacani; jicá'a áabai oveja máachu, máaquerricoo manúma nanáneewa náa'a dáulenai nayá líichuna, chacábacanaa liérra washiálicuerrica jócu liméecu linúmau. ");
INSERT INTO aca_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Carrúni jináatate namédacani, ya jócu naméda lirrú machácanica; ¿tána éewa natáania litáqueenaimi nácueji? Jiníwata licáwica nédani cáinabi ítacha.” ");
INSERT INTO aca_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Liá'a cawénii washiálicuerri etiopeca, lisáta léemiu Felipe: —Jíiwate nulí, yáawaiyini, ¿tána nácueji litáania liyá léji liéni cáiiwadedacai Dios chuáni báinacu, linácu liyá jájiu o báqueerriweeca? ");
INSERT INTO aca_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Néenee Felipe, liwína cáashta liliácta liyá quéecha nácu, etiope liéni liyáca, líiwa lirrú sáicai chuánshi Jesús nácue sái. ");
INSERT INTO aca_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Mátacachu, nabésunau áabai shiátai yácta, limá'ee liá'a cawéni washiálicuerrica: —Áani ái shiátai já'a; ¿nuéewaminaa nubáutisacoo?  ");
INSERT INTO aca_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Felipe má'ee lirrú: —Jéebidacta quinínama jiwówa yáajchau, éewerriu. Liá'a washiálicuerri léeba'ee: —Nuéebida Jesucristocala Dios Cúulee. ");
INSERT INTO aca_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Néenee liwána carroza bárruacoo; jáiwa náurrucoo chámatanaa shiátai yáacula, jáiwa Felipe báutisa liá'a etiopeca. ");
INSERT INTO aca_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Quéecha'inaa najiácoo shiátai yácucha, Espíritu Wawácali shínaa litée Felipemi, liá'a cawénii washiálicuerrica jócu léejoo licába mawiá jíni; ne liyá mamáarraca lijínacoo lishínaa iníjbaa lícuu sáicta wérri liwówa. ");
INSERT INTO aca_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Felipe íinu'e Azótola, ya libésunau chacáalee jútainimi líiwa liácoo sáicai chuánshica cáashia líinu Cesareala. ");
INSERT INTO aca_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Nácula, Saulo jócai íiyabau libáulida líinua náa'a éebidenaica linácu liá'a Jesúsca. Tánda, liáu sacerdótebini wácanai néerra, ");
INSERT INTO aca_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","tánda lisáta liúcha cáashta léewaque'e limédacani, liáque'iu sinagogala chacáalee jí'ineerri Damasco, wówerri liácoo limúrruca náa'a éebidenaica Jesús chuáni nácu, chaléjta washiálicuenai íina lécchoo, natéeque'e nayá preso Jerusalén rícula. ");
INSERT INTO aca_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Ne urrúni'inaami líinu liácoo chacáalee Damasco, áabai cámarrashi íinuerri áaqueji quéena litéeji cawíquinta. ");
INSERT INTO aca_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Saulo cáirriu cáinabi ricúla, léemi áabai chuánshi máirri lirrú: “Saulo, Saulo, ¿tánda jicánaqueda nuyá?” ");
INSERT INTO aca_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Saulo sáta léemiu: “¿Tána jiyá, nuwácali?” Liwítama éeba lichuáni: “Nuyáwa Jesús, léja liá'a chái jicánaqueda jimácoo.” ");
INSERT INTO aca_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Jibárroo jiwárroo chacáalee rícula, néerraminaa náiiwa jirrú liá'a jimédani'inaaca. ");
INSERT INTO aca_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Náa'a yáainecoo séewirri Saulo yáajcha cáarruni wérri, néemica áabai chuánshi, ne quiní nacábani. ");
INSERT INTO aca_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Jáiwa, Saulo bárruawai cáinabi ítacha; ne liméecu'inaa lituíu jócu léewa licábaca. Jáiwa nawína licáaji nácu natéeque'e liyá Damasco rícula. ");
INSERT INTO aca_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Néeni liyá matálii éerri jócai éewa licábaca, jócai íya ya jócai íirra shiátai. ");
INSERT INTO aca_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Á'a Damasco báqueerri washiálicuerri éebiderri Dios chuáni jí'ineerri Ananías, Dios íyadaniu lirrú licábani lituírricuejiu ya limá lirrú: “¡Ananías!” Jáiwa léeba lichuáni: “nuyá liéni yáa áani, nuwácali.” ");
INSERT INTO aca_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Liá'a liwácalica ma lirrú: “Jibárroo ya jiáu jiwína liá'a cáaye jí'ineerri Machácani, Judas íibana néeni, lisáta jéemiu báqueerri washiálicuerri Tarso néenee sái, jí'ineerri Saulo. Sáterriu liyáca, ");
INSERT INTO aca_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","licába lituírricuejiu báqueerri jí'ineerri Ananías wárruerriu lichánaa licáajiu líta'aa léewaque'e licába báaniu.” ");
INSERT INTO aca_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Ne léemi'inaami, Ananías má'ee: “Nuwácali, íchaba táania nulí linácu liáni washiálicuerrica, líiwanaa liá'a máashii limédanica Jerusalén rícu jishínaa chóniwenai majíconaani. ");
INSERT INTO aca_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Chóque'e íinuerri áani, nawánacaala nácu náa'a sacerdótebini wácanaica, natéeque'e preso quinínama náa'a mánulicuenai jijí'inaa.” ");
INSERT INTO aca_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Ne liwácali ma lirrú: “Jiá namówai, léca liérra washiálicuerrica nuníwani litáaniaque'e nují'inaa áabi chóniwenairru bájirra cáinabi ítala, ya nashínaa reybinirru, léquichu israelítabinirru. ");
INSERT INTO aca_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nuyá núyadaminaa lirrú máanui carrúni jináatau'inaa liyá nunácu.” ");
INSERT INTO aca_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Ananías yáu chalée cuíta néerra Saulo yáctaca. Liwárrua'inaami liácoo limáaca licáajiu linácu, ya limá lirrú: —Nuéenajirri Saulo, liá'a nuwácali Jesús, liá'a jicábanimi iníjbaa lícu jíinuctani, jiácoo nuyá libánuani jéewaque'e jicába báaniu, quéewaque'e cashiámu jimáacacoo Espíritu Santoyu. ");
INSERT INTO aca_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Néenimichu licáu Saulo tuí rícueji jicá'a chíchubeshi, jáiwa léewa licábacai. Jáiwa libárruawai libáutisawai. ");
INSERT INTO aca_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Jáiwa líyai, jáiwa cadánani jíni, jáiwa limáacau píitui éerri rími náajcha náa'a éebidenai Dios chuáni nácu Damasco rícu. ");
INSERT INTO aca_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Liáwinaami Saulo lichána íiwa Dios náawa sinagoga lícu, Jesús liá'a Dios Cúuleeca. ");
INSERT INTO aca_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Quinínama náa'a éemenaicani nacáarruda'eewoo néemicani, ya namá'ee: —¿Jócai liyá léji liéni cánaquedeerri Jerusalén rícu liáni náa'a táanianai Jesús chuáni nácu? ¿Jócai liyá báaniu léji liéni chái íinu áani liwína preso náa'a éebidenai Jesús nácu, litée léejuedaque'e nayá sacerdótebini wácanairru? ");
INSERT INTO aca_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ne liá'a Saulo táanierri ne jócai cáarrunaa, limáaca nayá mawítee náa'a judíobini yéenai Damasco rícu, íiyaderri yáawaa lé'e liá'a Jesús léewa'ee Mesías liárra. ");
INSERT INTO aca_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Jái'inaami íchaba éerri bésunawai, náa'a judíobini natáania nayá wáacoo náiinuaque'e Saulo. ");
INSERT INTO aca_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Jáiwa liá léenaa jíni. Éerrinacu ya táayee nanénda liyá linúma lícu liá'a chacáaleeca náiinuaque'ini. ");
INSERT INTO aca_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Ne náa'a éebidenai Jesús nácu namáaca liyá áabai canasto máanui rícu, ne áabai táayee náurrucueda liyá bádanicaishi máanui ríjcuederri chacáalee. Cháwa limánicoo jírra. ");
INSERT INTO aca_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Jái'inaami líinu Saulo Jerusalén néerra, liwówai liáawacacoo náajcha náa'a éebidenai Jesús nácu; ne nayá quinínama cáarru nacába liyá, jiníwata jócai néebida Pablo yáawaiyi máacaca liwówau Jesús nácu lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ne jáiwa Bernabé tée jíni, líyada apóstolubinirru jíni Saulo cába'ee Jesús iníjbaa lícu, jáiwa'ee liwácali Jesús táania lirrú, né'e Damasco rícu Saulo íiwa'ee Jesús nácu jócai cáarrunaa. ");
INSERT INTO aca_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Jáiwa Saulo máacawai Jerusalén rícu, ya jínaneerriu náajcha. Táanierri liwácali Jesús nácu cadánani liwówa. ");
INSERT INTO aca_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Táanierri náajcha ya méda yáaquerri náajcha judíobini náa'a táanianai Griego; ne náani nawówaini náiinuaca. ");
INSERT INTO aca_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Náa'a áabi éebidenai Dios chuáni, náa'a náa léenaa nawówai náiinuacani, natée Saulo lirrícula liá'a chacáalee jí'ineerri Cesarea, néenee nabánua liyá chacáalee jí'ineerri Tarso. ");
INSERT INTO aca_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Néenee liá'a iglésiaca, quinínama liá'a cáinabica Judea shínaaca, Galilea shínaaca ya Samaria chaiwíteemi yácajaa, ya mamáarracai dáwinacoo Dios wíteeshi nácu. Yáainai carrúicai yáajaba nawácali Jesús nácuu, ya liyúda liyá liá'a wíteeshi Espíritu Santoyu, mawí dáwinacoo liácoo namáanabacoo náa'a éebidenai Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Pé'eru, jínaneerriu íchaba cáinabi ítaba, licábaque'e liácoo náa'a éebidenaica wawácali Jesús nácu. Áji éerri léquichoo liáu licába náa'a éebidenai Jesús chuáni nácu yéenai chacáalee rícu jí'ineerri Lida. ");
INSERT INTO aca_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Néeni líinu báqueerri washiálicuerri jí'ineerri Eneas, jái'e liwáalia ocho camuí liyá yáarrubaishi íta'aa, macáwai. ");
INSERT INTO aca_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Pé'eru ma lirrú: —Eneas, Jesucristo chúneerri'inaa jiyá. Jibárroo ya jichúni jiárrubaimiu. Eneas bárroowai cawíquinta. ");
INSERT INTO aca_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ya náa'a yéenai quinínama Lida néeni ya Sarón rícu nacábani bárroo quinínama, jáiwa néejueda nayáu Nawácali Jesúsru. ");
INSERT INTO aca_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Liyáali éerri liyáte lirrícu liá'a chacáaleeca jí'ineerri Jope, báquetoo éebidechoo Jesús chuáni jí'ineechoo Tabita, griego liwówayu limáca Dorcas. Ruáni íinetooca ruméda séewirri sáicai ya ruyúdaca náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Liyáali éerrica, ruá'a Dorcas rubálinawai néenee máanali ruyái. Rumáshicaimi nanísa'inaa nabádedaqui jíni, namáaca ruyá áabai cuarto rícu áacai piso rícu. ");
INSERT INTO aca_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Jope yéerri urrúni Lida, Pé'eru yáctaca; ne náa'a náa léenaa náa'a éebidenai Jesús chuáni, Pé'eru néeni yáca, nabánua chámata washiálicuenai náiiwa lirrú: “Jíinu chérra Jope néerra madéjcanaa.” ");
INSERT INTO aca_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ya Pé'eru yáairriu náajcha. Líinu'inaami néerra natée liyá cuarto licúla ruyácta ruá'a mashíquishimi. Ne nayá quinínama náa'a íinaca máanirrinica yáainai Pé'eru téji náichaca, náyada náabalau ya natúnicue Dorcas médanimi'e quéecha'inaa'ee cáwi ruyá. ");
INSERT INTO aca_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Pé'eru wána najiácoo quinínama, jáiwa litúyawai ya lisáta Dios; néenee licába ruá'a máanaliuca, limá: —¡Tabita, jibárroo! Ruyá ruméecoo rutuíu, rucába'inaa Pé'eru jáiwa ruwáawai. ");
INSERT INTO aca_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Jáiwa liwína rucáaji nácu libárrueda ruyá; jáiwa limáida náa'a éebidenai Jesús chuáni ya náa'a máanirrinica, líyada ruyá cáwiu. ");
INSERT INTO aca_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Liéni quinínama náa léenaa chacáalee Jope shínaaca ya íchaba éebida wawácali Jesús. ");
INSERT INTO aca_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Pé'eru máacau néeni íchaba éerri lirrícu liá'a chacáaleeca, áabai cuíta báqueerri íibana cachúnicai íimanaashi jí'ineerri'e Simón. ");
INSERT INTO aca_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Liyáte chacáalee jí'ineerri Cesarea, báqueerri washiálicuerri jí'ineerri Cornelio, wánacaleerri áabi soldado jí'ineenai Italiano. ");
INSERT INTO aca_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Báqueerri washiálicuerri sáicai wérri, quinínama léenajinai yáajcha liá sáicai Diosru. Yáirri manuába warrúwa lécchoo liyúdaque'e náa'a judíobini carrúni jináatanica, ya séewirri lisáta Dios lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Áabai éerri táicalate las trésmi, licábate lituírricu sáiu: Licába jucámarranaa báqueerri ángel Dios shínaa, liwárroo liyáctala limá lirrú: “¡Cornelio!” ");
INSERT INTO aca_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Jáiwa Cornelio cába lítalai liá'a ángel, licáarruni íibejiu lisáta léemiu liyá: “¿Tána jiwówai, nuwácali?” Ángel ma lirrú: “Dios éemi jichuáni ya licába lécchoo liá'a jimédani náajcha náa'a jiyúdacala carrúni jináatani. ");
INSERT INTO aca_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Jibánua báqueerri liá'a chacáalee jí'ineerri Jope jiwánaque'e líinu liá'a Simónca, ya áabai lijí'inaa lécchoo Pé'eru. ");
INSERT INTO aca_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Ái yéerri áabai cuíta rícu báqueerri jí'ineerri Simón, báqueerri cachúnicai íimanaashi yéerri manuá tácoowa.” ");
INSERT INTO aca_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Jái'inaa ángelmi yáawai liá'a táania rími lirrú, Cornelio máida chámata cashírruedacani ya báqueerri soldado bájialai éebidaca ya liá'a líisainica. ");
INSERT INTO aca_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Liáwinaami'inaa líiwa nalí jíni libánua nayá chacáalee jí'ineerri Jope. ");
INSERT INTO aca_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Cajójchanaami, léjtaminaa wíyaicumi, nácula náawa iníjbaa urrúni Joperru, Pé'eru íirrau lisáta Dios cuíta juátaba lícu. ");
INSERT INTO aca_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Sámui wówa ne liwówai'e líyaca, nácula naméda nayá líya, licába'ee lituírricu sáiu: ");
INSERT INTO aca_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","licába'ee éerri méecucoo lirrú, yá'ee liúrrucocoo lirrú cáinabi ítala, áabai újni sábanaca máanui bájerriu quinínama náa'a cuatro lijuátaca. ");
INSERT INTO aca_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Líibi liá'a sábanaca nayá'ee quinínama cuéshinai cábacanaa náa'a wáalianai cuatro náibau, ya lécchoo náa'a cuéshinai yáarrudenaicoo ya lécchoo náa'a míshiiduca. ");
INSERT INTO aca_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Pé'eru éemi áabai chuánshi máirri lirrú: “Jibárroo Pé'eru, jíinuani ya jíyani.” ");
INSERT INTO aca_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Pé'eru éeba'ee lichuáni: “Jócai, nuwácali, nuyá jócai íyacaji íyacaishi casáculai, jócaimi línda wáaya liá'a ley Moisés shínaaca.” ");
INSERT INTO aca_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Léemi lichuáni wítama báaniu, limá lirrú: “Liá'a Dios yáni jí'inaa sáicai, ujimá máashiicalani.” ");
INSERT INTO aca_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Jái matálichu libésunacuwai, jáiwa sábana íirrau báaniu áacairra. ");
INSERT INTO aca_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Pé'eru urrúni wérri wówa, limá'ee lirrúwoo chítashia liwówau limá jiliérra liá'a licábaniu lituírricu, náiinu'inaami néerra náa'a Cornelio shínaa washiálicuenai cuíta núma néeni, sátenai'e náacoo néemiu Simón íibana nácu. ");
INSERT INTO aca_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Náiinu'inaa néerra, nasáta néemiu cadánani, jáicta'ee néeni liérra jí'ineerri Simón, chái namájirru lécchoo lijí'inaa Pé'eru. ");
INSERT INTO aca_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ne nácula Pé'eru újnibi édacanirriu liyáca linácu liá'a licábani lituírricuu, liá'a Espíritu Santoca limá lirrú: “Jicábateni, matálitai washiálicuenai namúrru jiyá. ");
INSERT INTO aca_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Jibárroo, jiúrrucoo jiáu náajcha ujiásacala, jiníwata nuyáwa bánua nayá.” ");
INSERT INTO aca_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Pé'eru yúrrucoo limá nalí náa'a washiálicuenaica: —Nuyáwajani liá'a chái imúrruca. ¿Tána íinu imédacai? ");
INSERT INTO aca_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Nayá néeba chá'a: —Wayá íinuenai liwánacaala nácu liá'a Cornélioca, báqueerri washiálicuerri majíconai, yá'ee sáicai wérri Diosru. Quinínama náa'a judíobini cawáuntani ya nawówaini. Báqueerri ángel Dios shínaa limá'ee lirrú, quéewiquini'e limáida jiyá jiáqueni'eewoo líibana néerra, léemiquini'e jirrú tánashia jimáni'inaa lirrú. ");
INSERT INTO aca_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Néenee Pé'eru wána nawárruacoo, jáiwa namáa néeni liyáali táayee. Cajójchanaami, jáiwa Pé'erumi yáu náajcha, ya áabi mawí éebidenai Dios chuáni Jope néenee sána, yáau liájcha. ");
INSERT INTO aca_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Néenee cajójchanaami náiinu Cesarea néerra, chalée Cornelio néndactala liyá nayá, náajcha náa'a áabi chóniwenai léenaaja, ya lijúnicai urrúni rími, nayá'ee náa'a Cornelio máidani'inaica. ");
INSERT INTO aca_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Quéecha'inaami Pé'eru íinu líibana néerra, jáiwa Cornelio jiáu lijúntedacani, jáiwa litúyawai lináneewa liá lirrú sáicai. ");
INSERT INTO aca_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Pé'eru nácuda liyá limá lirrú: —Jibárroo jíibayu, nuyá chái washiálicuerri lécchoo jicá'a jiyá. ");
INSERT INTO aca_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Nácula litáania liácoo liájcha, liwárroo'inau liácoo líinu íchaba chóniwenai yáainai macábaita. ");
INSERT INTO aca_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Pé'eru ma nalí: —Iyá yáine léenaa liá'a judíobini wítee jócai línda liyá litáania áabi chóniwenai yáajcha ya nawárroo'inau áabi íibana licúla. Ne liá'a Dios éewiderri nuyá jócubeecha nují'inaa máashiicai nuyá ya jócubeecha casácula nuyá quiní chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Tándawa, náiiwa'inaa nulí jíni, nuíinu'inaa jócaita nuíinuque'e numéda nuyá máashiica. Nuwówai nuá léenaa tándashia namáida nuyá. ");
INSERT INTO aca_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Cornelio éeba jíni: —Jái cuatro éerri néenee, léeminaa hóraa léja liáni, nuyá yáairri núbana rícuu yúnerri nuyáca ya méderri oración liyáali táicala, jáiwa báqueerri washiálicuerri íyadau nulí balíbali íibala. ");
INSERT INTO aca_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Limá nulí: ‘Cornelio, Dios éemi jishínaa jisátaucoo, lédacani'eewoo linácu liá'a jiyúdayu náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Jiwána líinu jiliá'a chacáalee jí'ineerri Jope, jiwána líinu néenee liá'a Simónca, liyá chái jí'inaa lécchoo Pé'eru. Ái ya Simón íibana rícu lécchoo, báqueerri cachúnicai íimanaashi yáairri manuá tácoowa.’ ");
INSERT INTO aca_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Tánda nuwána nácu namúrru jiyá madéjcanaa, ne jiyá nuáni léenaa méda jiliérra. Wayá náani ya áani quinínama Dios náneewa, ne wawówai wéemi jirrú liá'a wawácali bánuani jíiwa walí. ");
INSERT INTO aca_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Jáiwa Pé'eru lichána táania liyácai, limá cháa: —Ta nuá léenaa yáawaiyi Dios jócai cába báawacha áabi chóniwenai yúcha, ");
INSERT INTO aca_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","jócta matuínaami cáinabi ítabaa liwínani nanácucha náa'a éebidenaicani náa'a cawáuntai liyá ya naméda sáicai. ");
INSERT INTO aca_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Dios táania nalí náa'a Israel táqueenairru, íiwenai chuánshi sáitacta nawówa Jesucristo chuániyu, léwa'ee quinínama Wácali. ");
INSERT INTO aca_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Iyá yáinai léenaa sáica linácu liá'a bésuneerricoo quinínama liá'a cáinabica nashínaa náa'a judíobinica, lichána á'a Galilea néerra, liáwinaami liá'a Juan íiwanaa liá'a narrúnaa nabáutisacoo. ");
INSERT INTO aca_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Yáa léenate liá Dios cashiámui liwíteeyu, ya Espíritu Santoyu liá'a Jesús Nazaret néenee sái, ya liá'a Jesús jínaneerriu liméda sáicai, ya lichúnica náa'a quinínama náa'a carrúni jináatanica lirrú liá'a lidánaniyu liá'a Wawásimica. Léewa liméda liáni jiníwata Dios yáani yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Wayá lécchoo wacábani quinínama liá'a limédanica liá'a Jesúsca á'a líta'aa liá'a Judeaca ya á'a Jerusalén rícu. Liáwinaami liá'a náiinua jíni, nacuájidani áabai cruz nácu. ");
INSERT INTO aca_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Né'e Dios cáweda jíni matáli éerri rícula, jáiwa liméda líyadawai walí. ");
INSERT INTO aca_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Jócai íyadau quinínama chóniwenairru, walí rímija, náa'a Dios níwanica quéecha náa'a quéewique'e wáiiwa quinínama wáyu léenaa linácu. Wayá íyenai ya wáirra liájcha liáwinaami liá'a licáwia'inau. ");
INSERT INTO aca_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Liyá bánua wayá wáiiwaque'e chóniwenairru, lé'e liá'a Dios máacanica nawácali náa'a chóniwenaica, cáberri liá'a máashiica ya liá'a sáicaica cáberri'inaa cáwinica ya náa'a máanalinica. ");
INSERT INTO aca_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Quinínama náa'a íiwadedenai Dios chuáni báinacu náa'a táanianaica Jesús nácu, ya namá lécchoo tánashia náa'a éebidenai linácu, narríshibia'ee linácu méetuerri'inaa najíconaa —Pé'eru má'ee nalí. ");
INSERT INTO aca_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Újnibi Pé'eru táanierri liyáca, liyáali éerri Espíritu Santo íinu náta'aa náa'a éemenai nayáca liá'a Dios chuáni líiwani liyá nácu. ");
INSERT INTO aca_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ya náa'a éebidenaica Dios chuáni nácu natáqueenaibiminaa israelítabini, íinuenai Pé'eru yáajcha, nacáarruda'eewoo nacábacani Espíritu Santo wínaca nayá lécchoo náa'a jócani judíobini, ");
INSERT INTO aca_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","néemi'e natáania áabi chuánshi báawataiyu, ya naméda sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Néenee Pé'eru má'ee: —¿Ya nayá jócani'eewoo lécchoo nabáutisacuwai, náani chóniwenaica cháni ríshibia Espíritu Santo léjta wayá? ");
INSERT INTO aca_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Jáiwa libánua nayái nabáutisaque'iu lijí'inaa nácu liá'a Jesucristoca. Liáwinaami náa'a chóniwenaica namá lirrú quéewique'ini'e limáacacoo náajcha áabi éerri rími mawí. ");
INSERT INTO aca_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Náa'a apóstolubinica ya náa'a néenajinai yáainai Judea rícu néemi'e chuánshi lécchoo náa'a jócai judíobini nawína'ee Dios chuáni lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Ne Pé'eru éejoo'inau Jerusalén néerra, natáania máashii linácu náa'a éebidenai Dios chuáni natáqueenaibimi náa'a israelítabini. ");
INSERT INTO aca_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Nasáta léemiu liyá: —¿Tánda jiwárroo náiibirra náa'a jócani judíobini, jáiwa jimáacoo náajchai, ne tánda jíya náajcha? ");
INSERT INTO aca_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Pé'eru íiwa nalí lidáni néenee quinínama liá'a libésunaucoo. Limá nalí: ");
INSERT INTO aca_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","—Nuyá yáairri chacáalee jí'ineerri Jope, nácula nutáania Dios yáajcha, nuwáalia áabai nutuírricu sái: Nucába jicá'a áabai sábana máanui nabájerriu náa'a cuatro lijuátaca, íinuerri éerri néenee chalée nuyáctalaca. ");
INSERT INTO aca_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Jáiwa nucába sáica jíni tánashia yáa lirrícui, jáiwa nucába líibi cuéshinai cuatroni íiba, ya cuéshinai cawálani, ya náa'a yáarrudenaicoo cáinabi íta'aa ya náa'a míshiiduca. ");
INSERT INTO aca_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Jáiwa nuéemi lichuáni wítama mérri nulí: ‘Jibárroo, Pé'eru, jíinuani ya jíyani.’ ");
INSERT INTO aca_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nuyá éeberri: ‘Jócai, Nuwácali, quiní wárruerriu nunúma lícu máashiica ya casáculai.’ ");
INSERT INTO aca_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Néenee lichuáni wítama éerri néeneeji léejoo litáania nulí: ‘Liá'a Dios yáni jí'inaa sáicai, ujimá máashiicalani.’ ");
INSERT INTO aca_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Liáni jái bésunacuwai matálichu, jáiwa quinínama léejoo líirracuwai áacairra. ");
INSERT INTO aca_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Liyáalimi, matálitai washiálicuenai nabánuani Cesarea néenee sána namúrru nuyá, náiinu cuíta néerra á'a nuyáctalaca. ");
INSERT INTO aca_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Liá'a Espíritu Santoca libánua nuyá, jócubeecha né'e nuásacala, nuáaquene'eewoo náajcha. Ya náani seis nuéenajinaica yáaineu nuájcha lécchoo. Quinínama wawárruacoo áabai cuíta rícu báqueerri washiálicuerri shínaa, ");
INSERT INTO aca_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","líiwa walí licába'ee báqueerri ángel líibana rícu, licába báqueerri ángel bárruacoo, limá lirrú: Jibánua áabibi chalée chacáalee rícula jí'ineerri Jope, jiwánaque'e líinu néenee liá'a jí'ineerri Simónca, ya áabai lijí'inaa lécchoo Pé'eru. ");
INSERT INTO aca_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Limáminaa jirrújoo chítashia'eewoo wáseda jiyá ya quinínama yáainai jíbanaa lícu. ");
INSERT INTO aca_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Quéecha'inaami nutáania nalí, Espíritu Santo íinu'inaami náta'aa, léjta líinu'inaami wáta'a quéecha. ");
INSERT INTO aca_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Jáiwa nuédacani linácu liáni wawácali mánimica: ‘Yáawaiyi Juan báutisa shiátaiyu, ne iyáminaa báutiseene'inau Espíritu Santoyu.’ ");
INSERT INTO aca_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Wée sáicai, Dios yácta nalí lécchoo, léjta liá'a Dios yáni walí, wayá éebidenaica wawácali Jesucristo nácu, ¿tána nuyái nuyáque'e Dios júnta? ");
INSERT INTO aca_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Quéecha'inaami náa'a néenajinai yáainai Jerusalén néeni néemi'inaa liáni chuánshica, jáiwa manúma nayái, jáiwa naméda sáicai Diosrui namá'ee: —¡Namá'ee léquichoo náa'a jócani judíobini liá'e nalí néejooque'iu wawácali Diosru, nénaque'e liá'a cáwicashi jócai amáarra! ");
INSERT INTO aca_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Liáwinaami liá'a Esteban máanalicamica, jáiwa nacánaquedenai náji náa'a éebidenaica Dios chuáni, néewau nacánacacuwai cáinabi jí'ineerri Fenicia, Chipre ya Antioquía. Néerra náiiwa nalí náa'a judíobinica chuánshi sáicai, jócaita áabirru. ");
INSERT INTO aca_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Ne máayabaca, áabi éebidenai Dios chuáni Chipre néenee sána ya Cirene néenee sána, náiinu chacáalee jí'ineerri Antioquía néerra, jáiwa natáania nalí léquichoo náa'a jócani judíobini, náiiwa nalí sáicai chuánshi nácu linácu liá'a Jesús, wawácalica. ");
INSERT INTO aca_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Liá'a Dios wítee cadánani yéerri náajcha, tánda íchaba máaca nawíteemiu ajuítemi, jáiwa néebida Jesús nácuwai. ");
INSERT INTO aca_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Náa'a iglesia Jerusalén néenee sána, néemi'inaami liáni chuánshica, nabánua Bernabé Antioquía néerra. ");
INSERT INTO aca_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Quéecha'inaami Bernabé íinu néerra, licába Dios túya nayáu, sáicta wérri liwówa. Liá nawítee quinínama namáaca nawówau cadánani linácu liá'a éebidani Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Jiníwata liá'a Bernabé washiálicuerri sáicai, cashiámui Espíritu Santoyu ya éebiderri. Tánda íchaba chóniwenai máaca nawówau Wawácali nácu. ");
INSERT INTO aca_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Liáwinaami liáni, Bernabé yáairriu áabai chacáalee jí'ineerri Tarso néerra, limúrru Saulo. ");
INSERT INTO aca_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Líinu'inaami linácu, jáiwa litée jíni Antioquía. Néenee nayá yáajcha náa'a iglesia ísanaca áabai camuí quinínama, néewida íchaba chóniwenai. Antioquía néeniwa náa'a éewidenaicoo nácta nají'inaa náa'a quéechanacu sánaca cristiánobinica. ");
INSERT INTO aca_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Liyáali éerri, áabi quéewidacai Dios chuáni yáaineu Jerusalén néenee Antioquía néerra. ");
INSERT INTO aca_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Báqueerri néenaa náa'a jí'ineerri Agabo, jáiwa libárruawai Espíritu ma lirrú, líiwa'ee áabai ínaaishi wérri íinuerri'inaa'ee quinínama cáinabi ítala, jáiwa libésunawai yáawaa, léerdimi liá'a wánacaleerri jí'ineerri Claudio. ");
INSERT INTO aca_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Jáiwa náa'a éebidenai Dios chuáni nácu Antioquía néenee sánaca, jáiwa nawówai nabánua nayúda nayájoo náa'a néenajinai yéenai Judea néeni, bácainaa tánashia néenaani náacai. ");
INSERT INTO aca_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Jáiwa naméda cha jíni, nawánaca liá'a Bernabé ya Saulo, natée nalí nayúdau'naa nayá náa'a salínaica yéenai Judea néeni. ");
INSERT INTO aca_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Liyáali éerrimi, liá'a rey Heródesmi, jáiwa lichánau licánaquedani nayá náa'a áabi iglesia ísana. ");
INSERT INTO aca_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Libánua líinua espada númayu Santiagomi, liá'a Juan éenajirrimica. ");
INSERT INTO aca_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Licábaca'ee sáica licáacoo judíobinirru, jáiwa nawína preso Pé'erumi. Liáni bésunawai liyáali éerri fiesta'inaami, náaya'inaami páani jócai múrracau. ");
INSERT INTO aca_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Liáwinaamite nawína liyá preso, Herodes wána naníqui liyá Pé'eruca cuíta manúmai ricúla, éedenai nayáca natuínaa cuatro grupo soldado, ne cuatro soldado grupo namáni máanubaca. Liwówaini líyadaca chóniwenai náneewa quinínama, liáwinaami liá'a fiesta jí'ineerri pascua. ");
INSERT INTO aca_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Liyáali Pé'eru yéerri cuíta manúmai rícula, natúyani wérri, ne náa'a iglesia ísanaca mamáarracani sáta linácu Dios yúcha cadánani wérri. ");
INSERT INTO aca_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Áabai táayee libéecha liyáali éerri Herodes íyadacta'inaamini chóniwenairruni, Pé'eru máairri liyáca chámata soldado éemanacu, bájerriu chámai cadénayu, nácula áabi soldado yéenai túyenai linúma liá'a cuíta manúmaica. ");
INSERT INTO aca_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Cawíquinta báqueerri ángel íyadacoo Wawácali shínaa, jáiwa cashiámu cámarrashiyu liá'a cuíta manúmaica. Liá'a ángel lidúnu Pé'eru bárrai nácu, jáiwa licáweda jíni, limá lirrú: “¡Jibárroo cálicu!” Liyáalimi cadena licáwai Pé'eru cáaji nácucha, ");
INSERT INTO aca_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","jáiwa ángel ma lirrúi: “Jisúwa jíibalau, jisúwa jishínaa sandalias.” Cháwa Pé'eru médacani, ángel ma lirrú báaniu: “Jisúwa jishínaa capau wayúwai.” ");
INSERT INTO aca_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Pé'eru yáau líshiirricu liá'a ángel, jócai liá léenaa yáawashia liá'a ángel médanica. Cájbami lirrúta'ee lituírricu sái chái licábaca. ");
INSERT INTO aca_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ne nabésuneda quéechanacu sána catúyacanica, néenee néejoo nabésuneda áabi catúyacani báaniu, ne náiinu'inaami néerra linánibala jiárrui néerra yáairri bináawe, jáiwa liméecu liá'a linánibala bácai. Najiá'inaamiwai, nanísa'inaami najínacuwai áabai cáaye, ángel máaca liyá bácai. ");
INSERT INTO aca_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Jáiwa cawítee Pé'erumi, limá'ee: “Chóque'e nucába yáawaiyi, liá'a Wawácali, bánuerri nulí ángel litúyaque'e nuyá Herodes yúcha, náucha lécchoo náa'a quinínama judíobini wówaini naméda nuájcha.” ");
INSERT INTO aca_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Liáni léenaa jíni, Pé'eru yáau cuíta María íibana néerra, ruá'a Juan túwaca, jí'ineerri lécchoo Marcos, íchabacta náawacacoo natáania Dios yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Limáida liá'a cuíta núma yéerri cáaye rícueji, báquetoo miyácau jí'ineechoo Rode rujiáu rucába tánashia jíni. ");
INSERT INTO aca_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Rucúnusia'inaa ruéemi Pé'eru wawítama, jáiwa sáicta ruwówai jócuwa ruméecu lirrúi, jáiwa rucánacawai cuíta licúla ruíiwa nalíni, Pé'eru yáairri cuíta núma lícu. ");
INSERT INTO aca_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Nayá namá rulí: —¡Jiyá mawítee! Ruyá rumá yáawaiyii. Nayá namá'ee: —Jócai liyá, léwa jishínaa ángel liérra. ");
INSERT INTO aca_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Nácula, liyá Pé'eru mamáarracai limáida nalí cuíta núma licué. Naméecu'inaamini, ya nacába liyá, jáiwa nacáarrudawai. ");
INSERT INTO aca_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Ne liyá liméda nalí licáajiu, manúmataque'e nayá, jáiwa líiwa nalí jíni chítashia liwácali jédau liyá cuíta manúmai rícueji. Jáiwa limá: —Jíiwa liáni Santiagorru ya léenajinairru. Jáiwa lijiáwai liáu báawachalai. ");
INSERT INTO aca_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Quéecha'inaami jucámarracai, jáiwa natáania matuínaami nayá wáacoo náa'a soldado, jiníwata jócta náa léenaa chítashia nabésunau'u jíni Pé'eru yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Jáiwa Herodes bánua namúrruqui jíni, ne jóca néenaa náiinuqui jíni, liáni náata náa'a guárdiaca, jáiwa liwána náiinua nayái. Liáwinaami liáni, Herodes jiáu Judea yúcha, jáiwa liáu liyácai Cesarea néerra. ");
INSERT INTO aca_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Herodes íiwirri wówa náajcha náa'a chóniwenai yéenaica chacáalee jí'ineerri Tiro ya Sidón. Tánda néenaa náa'a chóniwenaica náacoo natáania Herodes yáajcha, jáiwa'ee néenaa naméda najúnicai liá'a Blástoca, báqueerri chóniwerri cawéni wérri liájabasai liá'a rey Heródesca. Tánda nabánua nachuániu Blasto yáajcha Heródesru: Wayá jócai wówai wáiinua yáacacoo jiájcha, jiníwata wayá cúnsiguenai íyacaishi jishínaa cáinabi. Néenee lécchoo Blasto táania liájcha liá'a Heródesca, quéewique'e lirríshibia nayá. ");
INSERT INTO aca_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Liyáali éerri lirríshibia'inaa jíni liá'a Heródesca lisúwa'ee líibalau rey shínanaa, jáiwa'ee liwárruawai lishínaa liárrubai íta'aa. Néenee'e máanui cábacoo litáania nalí. ");
INSERT INTO aca_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Néenee'e chóniwenai nachána namáidada'ee: “¡Jócaiwa washiálicuerri liéni chái jitáania, wamá báqueerri Dios!” ");
INSERT INTO aca_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Liyáalimi'e, báqueerri ángel Dios shínaa liwána Herodes bálinacoo, jiníwata liá'a Herodes jócai méda Dios carrúninaa, cáberriu jicá'a dios. Néenee libéechalawoo máanali jíni éenishi íyani. ");
INSERT INTO aca_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Nácula'ee liá'a Dios chuánica cáarralerriu mamáarraca náiiwa quinínama cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Bernabé ya Saulo nanísa'inaa'ee nashínaa tráawaju Jerusalén rícu, néejoo'eewoo Antioquía néerra. Náajcha'eewoo natée Juan lijí'inaa léquichoo Marcos. ");
INSERT INTO aca_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Liá'a iglésiaca yéerri Antioquía ái íiwadedeerri Dios chuáni já'a ya éewiderri. Nayá Bernabé, Simón (yá'ee liá'a jí'ineerri léquichoo cachájulai), yá'ee Lucio Cirene néenee sái, Manaén (liá'a dáwinerricoo Herodes yáajcha, liá'a wánacaleerri Galilea rícu) ya Saulo. ");
INSERT INTO aca_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Áabai éerri, nácula'ee nayá'ee nayá culto rícu lirrú'e Wawácalica liyáali nayá jócai íya, yúnenai, liá'a Espíritu Santo má'ee nalí: “Ishírri nulí liá'a Bernabé ya Saulo lirrú liá'a tráawajuca numáidani nayá nácu.” ");
INSERT INTO aca_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Néenee, liáwinaami na'óra'inaa ya nayúnaa léquichoo, namáaca'ee nacáajiu nanácu ya tá'ee náiiwa nanáwau nalí. ");
INSERT INTO aca_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Espíritu Santo bánua nayá, náa'a Bernabé ya Saulo ná'eewau áabai chacáalee jí'ineerri Seleucia, néenee'e ná'eewau náurrucoo lancha ricúla náaque'iu áabai liwówai néerra jí'ineerri Chipre. ");
INSERT INTO aca_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Náiinu'inaa'ee liá'a lancha chánactacoo néeni jí'ineerri Salamina, liwówata néeni jí'ineerri Chipre. Jáiwa nachána'ee náiiwa Dios chuáni lirrícula liá'a sinagoga judíobini shínaa, Juan yáairriu náajcha léquichoo jicá'a liá'a tálidedeerri nayá. ");
INSERT INTO aca_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Najína'eewau quinínama litéeji liá'a liwówaica náiinu'e áabai chacáalee jí'ineerri Pafos, náiinu'e báqueerri washiálicuerri camálicai judío jí'ineerri Barjesús, washiálicuerri canúma yúwicai jócai íiwa yáawaiyi Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Liéni camálicaica yáairri liyá liájcha liá'a wánacaleerrica jí'ineerri Sergio Paulo, washiálicuerri cawítee. Liá'a wánacaleerri libánua namáidaca Bernabé ya Saulo, jiníwata wówairri léemica Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Ne liá'a camálicaica, lijí'inaa griégoyu Elimas, jócu'e liwówai wánacaleerri éebidaca Jesucristo nácu. ");
INSERT INTO aca_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Néenee liá'a Sauloca, jí'ineerri léquichoo Pablo, cashiámui Espíritu Santoyu, licába'ee ya lirrátueda'ee lirrú, ");
INSERT INTO aca_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","limá'ee lirrú: —¡Canúma yúwicai, máashii wítee, Wawásimi cúulee, lijínai liá'a quinínama sáicaica! ¿Tánda jísai jináawida báawachala Dios chuáni? ");
INSERT INTO aca_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Chóquejoo Dios cástiguerri'inaa jiyái: jiyá máaquerri'inau matuí'inaa, íchaba éerriminaajoo, jiyá jócai'inaa éewa jicábaca cáiwia cámarraa. Liyáalimi'e camálicaica Elimasca limáaca'eewoo báitanacu catáwacai rícu, matuí jócai cába, limúrru'e báqueerri washiálicuerri téerri'inaa licáaji nácu jiníwata jócai cába. ");
INSERT INTO aca_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wánacaleerri cába'inaa jíni, jáiwa léebidai Dios chuáni nácui, jiníwata cáarruderriu léemica liá'a náiiwanica Jesucristo chuánica. ");
INSERT INTO aca_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Pablo ya náa'a máinaicoo liájcha, náurrucoo á'a Pafos néeni lancha ricúla náaque'iniu áabai chacáalee jí'ineerri Perge, cáinabi íta'aa jí'ineerri Panfilia; néenee Juan máacau éejoowai Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Náiinu'inaa Perge néerrai nabésunau Antioquía néerra, yáairri urrúni Pisidia. Néenee, sábadoca, éerri nawówa íyabactacoo, nawárrua'eewoo sinagoga rícu, nawáa'eewawai. ");
INSERT INTO aca_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Néenee náa'a sinagoga néenee sána, naliá'inaa cáashta shínaa ley ya náa'a íiwadedenai Dios chuáni báinacu, nawácanai náa'a sinagogaca namáida nalí ya namá'ee: —Nuéenajinai, áicta iwáaliani iwówa lícuu já'a íiwa walíni wéemi áani sáicta'a wawówa yáajcha, íiwa walíni. ");
INSERT INTO aca_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Néenee Pablo libárrua'eewau liméda licáajiu nalí manúmataque'e nayáca, limá'ee: —Éemiu iyá, israelítabini, iyá chajá chóniwenai báawatani chuáni, cáarruni cába Dios. ");
INSERT INTO aca_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Liá'a Dios shínaa chóniwenai Israel wíneerri wawérrinaibimi; liméda chacáalee wérrinai quéecha'inaa nayáca újnibi yáainai báawachala Egipto rícu, néenee lidánaniyu Diosca najiáu néenee lirrícucha liá'a cáinabica. ");
INSERT INTO aca_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Dios guánta náajcha liá'a máashii namédani lirrú, chaléeni liá'a cáinabi jiníctala yéerri cájbami cuarenta camuí, ");
INSERT INTO aca_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","néenee limárda siete naciones cáinabi jí'ineerri Canaán, quéewique'e liá nalí cáinabi náa'a wawérrinaibimi. ");
INSERT INTO aca_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Quinínama liéni lidécudau újni cuatrocientos cincuenta camuí. Liáwinaami liá wánacaleenai chóniwenairru cáashia liá'a léerdi liá'a íiwadedeerri Dios chuáni báinacumi jí'ineerri Samuel. ");
INSERT INTO aca_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Néenee nasáta'ee báqueerri rey wánacaleerri'inaa, ne Dios yáa rey Saul licúulee liá'a Cisca, Benjamín éenajinaimirru; Saul rey cuarenta camuí. ");
INSERT INTO aca_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Liáwinaamite Dios éeda liárru liá'a Saúlca, liá rey Davidruni, Dios má'ee David liúcha: ‘nuíinu liá'a washiálicuerri Davidca, licúulee liá'a Isaíca, washiálicuerri nugújtani, méderri quinínama liá'a nuwówainica’. ");
INSERT INTO aca_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Néenaa náa'a natáqueenaimi liá'a Davidca, néenaa Jesúsja, liá'a Dios bánuanica quéewique'e liwáseda israelítabini, léjta limáyu liá'a Diosca. ");
INSERT INTO aca_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Jóctanaa Jesús íinu, Juan jái íiwa Dios chuáni quinínama chóniwenai Israelru, limá nalí néejooque'iu Diosru nabáutisaque'iniu. ");
INSERT INTO aca_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Juan urrúni'inaa máanaliqui jíni limá'ee nalí: ‘Nuyá jócai léjta imáyu'u irrúwoo; ne liáwinaamijoo líinu báqueerri, nuyá jócai nuénaminaa nuwásaidaca líiba nácucha cotizas.’ ");
INSERT INTO aca_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Nuéenajinai Abrahám táqueenaimi, iyá báawacha sánaca cáarruni cába Dios: liéni chuánshica léewa éewerri litée iyá áacairra. ");
INSERT INTO aca_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Náa'a yéenaimica Jerusalén rícu, ya náa'a wánacaleenaica, jócani yáa léenaa tánashia Jesús, jócai néemi léquichoo náiiwani náa'a íiwadedenai Dios chuáni báinacu, liá'a cáashta iliánica sábado rícu; cháwa nalíwoojoo, namá'inaa Jesús rúnai'inaa máanalica, líinu'inaa néerra liá'a Dios máni nácucha báinacu. ");
INSERT INTO aca_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Jiní náiinuni linácu máashii limédanica néewaque'e náiinuacani, nasáta'ee Pilato yúcha nawánaque'e náiinuacani. ");
INSERT INTO aca_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Néenee liáwinaami, jái sámu liméda quinínama liá'a limáni nácucha Dios chuáni, náurrucueda cruz nácucha jíni, naquéni jíni. ");
INSERT INTO aca_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ne Dios éejoo licáwiadacani. ");
INSERT INTO aca_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Íchaba éerrite, Jesús íyadau nalí náa'a yáainemicoo liájcha Galilea Jerusalén néerra, ne chóque'e nayá náa'a táanenai Jesús nácu chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ne cháwa wayá índenai wayá irrú liáni sáicai chuánshica: Liá'a Dios máni nácucha nalí náa'a wawérrinaimica, ");
INSERT INTO aca_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Ái Dios méda wáajchai, wayá natáqueenaimica. Liéni limédani léejueda Jesús cáwica, újni litánau rey David salmo chámai rícu, linácu liá'a Dios mánimi Jesúsru: ‘Jiyá nucúulee, nuyá jisálijinaa yáawaiyi.’ ");
INSERT INTO aca_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Dios jái íiwaqui jíni liyá éejuerri'inau cáwica, jócubeecha máashii liá'a líinaaca, limá'inaate náa'a tánenaicoo: ‘Numédani'inaa liá'a majíconaa ya yáawaiyica numánimi Davidru báinacu.’ ");
INSERT INTO aca_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Tánda limá léquichoo áabai rícu: ‘Jócuminaa línda lináanai bádacoo liá'a lishínaa majíconaa cashírruedacaica.’ ");
INSERT INTO aca_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Néenee sáicani, yáawaiyi liá'a Davidca sírbeerri lirrú liá'a chóniwenaica lishínaa éerrimi, léjta Dios wánacaalau liyá, néeneete máanali jíni liáawacau liwérrinaibini náajchau, néenee lináanaimi bádawai. ");
INSERT INTO aca_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Ne lináanai liá'a Jesús, Dios éejuedani cáwicai, jócu bádacoo. ");
INSERT INTO aca_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Chái cábacanaa, nuéenajinai, iyá arrúnaa yáa léenaa léca liá'a lipérdonaayu'u wajíconaa wáiiwani irrú Jesús íiwanaa rícueji. ");
INSERT INTO aca_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ne náa'a quinínama máaquenai nawówau Moisés shínaa ley nácu, jócai nawáalia bádedeerri'inaa najíconaa nácuejiu, ne chóque'e quinínama máaquenai nawówau Jesús nácu libádeda najíconaa. ");
INSERT INTO aca_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Icábawa yúchaujoo, jócubeecha licáu inácula liá'a natánani náa'a íiwadenaica Dios chuáni báinacu: ");
INSERT INTO aca_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Icábani, iyáte cháaneenaicani, icáarrudau ya amáarra iyái, jiníwata ishínaa éerri numédaminaa máanui wówashica jócai éebida nácu, áiquita íiwerri irrújani'i’. ");
INSERT INTO aca_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Liá'a Pabloca ya náa'a lijúnicaica najiá'inau lirrícucha liá'a sinagogaca judíobini shínaa, náa'a jócani jiáu judíobini, namésuda'ee nayá néejooque'iu báaniu liá'a áabai sábadoca natáaniaque'e nalí quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Amáarrai'inaami liá'a náawacactacoo sinagoga rícu, íchaba judío ya náa'a báawache sánaca éebidenai nanácu náa'a judíobinica, jáiwa náau yáajchai Pablo ya Bernabé. Ya náa nawítee nayáquini'e machácani mamáarraca linácu liá'a Dios nísau'u limáida nayái. ");
INSERT INTO aca_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Liá'a áabai semana, sábado rícu, atéwa quinínama chóniwenai chacáalee rícu sána yáawaquenai'inau néemique'e Wawácali chuáni. ");
INSERT INTO aca_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Ne náa'a judíobinica nacába'inaa íchaba chóniwenai yáawacacuwai, jáiwa cadéni nayái, jóca áabenaa nawówa Pablo yáajchai, ya namá cacháni chuánshi Pablorru. ");
INSERT INTO aca_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Néenee liá'a Pabloca ya liá'a Bernabéca, natáania'ee cadánaniyu, namá'ee nalí: —Wawáalia arrúnaaca wáiiwa Dios chuáni quéechanacu irrú iyá judíobinica; ne iyá jócani icábau icáwicaca jócai amáarra, yáaliminaa wáujoo nayáctala náa'a jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Jiníwata cháwa Dios bánua wayá jírra, limá walí: ‘Numáaca jiyá jicá'a áabai cámarrashi quinínama chóniwenairru, itée nuchuáni wásedeerri'inaa cáashia íinu amáarractala cáinabi.’ ");
INSERT INTO aca_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Néemi'inaa jíni, náa'a jócani judíobini sáicta'ee nawówa nachána'eewoo namáca liá'a Dios chuánica sáicai; yá'ee néebida quinínama náa'a yáainai linácu liwínanica liáque'e nacáwica jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Cháwa náiiwa Wácalishi chuáni jírra quinínama cáinabi. ");
INSERT INTO aca_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ne náa'a judíobinica natáania'ee náajcha náa'a íina sáicani wérri ya cawéninica ya washiálicuenai cawéninica lirrícu liá'a chacáaleeca, natáania Pablo nácu ya Bernabé quéewique'e nacánaqueda nayá, néewaque'e najédani lirrícucha liá'a cáinabica. ");
INSERT INTO aca_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Néenee Pablo ya lijúnicaica, jáiwa'ee natútuda náiiba nácuchau liá'a pucúpucubeeca, limáyu'inaa jócani nawówai Dios chuáni náa'a chóniwenaica, néenee náa'a éewawai Iconio néerra. ");
INSERT INTO aca_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ne náa'a éebidenaica cashiámuni Espíritu Santoyu ya sáictani wówa. ");
INSERT INTO aca_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Liá'a chacáalee jí'ineerri Iconio, Pablo ya Bernabé nawárroo lirrícula chámatanaa liá'a sinagoga rícula judíobini shínaa, natáania'ee sáicai wérri chuánshica nalí, íchaba'ee chóniwenai éebida nalí liá'a náiiwanica, náa'a judíoca ya náa'a jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Ne náa'a judíobinica jócani éebida natáania máashii nalí náa'a jócani judío, nawánaque'e napénsaa máashii nanácucha náa'a néenajinaica. ");
INSERT INTO aca_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Tánda náa'a apóstoluca namáaca'eewoo néeni íchaba éerri, máaquenai nawówau Dios nácu natáania quinínama yáawaiyi Dios chuáni nácu; ya liá'a wawácalica íyada liá'a namánica liá'a níinaashica Dios wáalianica, liáyu nalí liwíteu namédacai shínaashica ya jócai nacába cáji. ");
INSERT INTO aca_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ne náa'a chóniwenaica chacáalee rícu sánaca jócani áabenaa wówa, áabibi judíobini yáajcha, áabibi yéenai apóstolu yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Néenee náa'a judíobinica, ya náa'a jócani judío natáania'ee náajcha náa'a wánacaleenaica nabásedaque'e nayá ya léquichoo náiinuaque'e nayá íibayu. ");
INSERT INTO aca_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Ne Pablo ya Bernabé ná'inaa'ee léenaa jíni, jáiwa namániwai chacáalee jí'ineerri Listra rícula, ya léquichoo chacáalee jí'ineerri Derbe, chacáalee cáinabi jí'ineerri Licaonia, ne cáinabi líteeji sáica, ");
INSERT INTO aca_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","néeni léquichoo náiiwa nalí Dios chuáni sáicaica. ");
INSERT INTO aca_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Liá'a chacáalee Listraca néeni'e liyá liá'a washiálicuerri jócai éewa lijínacoo. Jócai jínacajiu, jiníwata lijédanirra. Liéni washiálicuerri wáairriu liyáca, ");
INSERT INTO aca_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","éemerri liyáca liá'a Pablo íiwanica, liá'a Pabloca cába lirrú, yá'ee licába wáalierri'e éebiderri lichúni'inau. ");
INSERT INTO aca_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Néenee Pablo ma lirrú cadánani chuánshiyu: —¡Jibárroo machácani jicáwayu! Liá'a washiálicuerrica, jáiwa libárruawai ya léenuwai ya lijínawai. ");
INSERT INTO aca_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Náa'a chóniwenaica nacába'inaa liá'a Pablo médanica, jáiwa'ee namáidada chuánshi Licaoniayu: —¡Diose újnini washiálicuenaica yúrrucuenaiu wayáctalaca! ");
INSERT INTO aca_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Nacába'ee liá'a Bernabéca jicá'ee nashínaa dios jí'ineerri Zeus, ya liá'a Pabloca jicá'ee dios jí'ineerri Hermes, jiníwata liyáwa mawí táaniaca. ");
INSERT INTO aca_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Liá'a sacerdóteca Zeus shínaa, wáalierri áabai templo iníjbaa wárruerricoo chacáalee rícula, línda'ee pacáa yá'ee cachílinai íwinaashi; liyá'ee ya chóniwenai nawówai'e nasátacoo apóstolubini yúcha, yá'ee náiinu pacáa néemani'inaa nalí. ");
INSERT INTO aca_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Ne liá'a Bernabéca ya Pabloca ná'inaa'ee léenaa jíni chóniwenai méda nayá náajcha, jáiwa'ee nashírricueda nábalawai, jáiwa nawárroo chóniwenai íibirrai, namáidada'ee: ");
INSERT INTO aca_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","—Washiálicuenai, ¿ne tánda iméda liérra? Wayá washiálicuenai léjta iyá. Tánda jicá'a wáiinuca wáiiwa irrúni, jócubeecha iméda mawiá liá'a jiníyi iwéni, éejooque'iu lirrú liá'a Dios cáwiica, liá'a méderri éerri ya cáinabi ya manuá ya quinínama yáairri lirrícu. ");
INSERT INTO aca_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Báawita íchaba éerri néenee bésuneerricoo Dios máaca bácainaa nawína nashínaa iníjbau, ");
INSERT INTO aca_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","séewirri táania liyá jájiu ne liá'a yáawaiyiica; liyá bánuerri irrú únia quéewique'e iwáalia banácali, yáirri quinínama irrú íyacaishi quéewique'e íyacani sáictaque'e iwówa. ");
INSERT INTO aca_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Ne áawita namá nalí quinínama liáni, ne atéwa cabálini wérri nalí jócu naínda chóniwenai íinua náa'a pacáaca náque'e irrú cuésherri éemerriu, ya náa irrú sáicai. ");
INSERT INTO aca_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Ya liyáalimi náiinu náa'a judío Antioquía néenee sánaca, ya náa'a Iconio néenee sána, natáania'ee náajcha náa'a chóniwenaica nanáawidaque'e nawítee; néenee jáiwa náiinua Pablo íibayu, jáiwa'ee namá'ee nalíwoo máanaliyi, jáiwa'ee nárda jíni bináawala chacáalee yúcha. ");
INSERT INTO aca_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Né'e náa'a éebidenaica jáiwa'ee nayá Pablo téejii, jáiwa'ee libárruawai léejo'eewau chacáalee rícula, áabai éerri cajójcha'inaami jáiwa lijiáwai Bernabé yáajcha chacáalee jí'ineerri Derbe. ");
INSERT INTO aca_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Liáwinaami líiwa'inaa Dios chuáni sáicai Derbe rícu, léejuedacta íchaba chóniwenai Diosru, jáiwa'ee néejoo bániwai Listra néerra, Iconio néerra, ya Antioquía néerra léquichoo. ");
INSERT INTO aca_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Narrícu nárra chacáaleeca náa nadánani'e náa'a éebidenai namá'ee nalí iyáwajoo cadánani Dios chuáni nácujoo, namá'ee nalí wawárruaque'iu Dios wánacaalactalaca rúna'ee wabésuneda carrúni jináata liá'a íichaba máashiica. ");
INSERT INTO aca_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Ne léquichoo namáaca wánacaleenai quinínama iglesia máanabaca, ya liáwinaami na'óra'inaa'ee ya nayúna'inaa, jáiwa'ee namáaca Dios cáaji rícu jíni, náa'ee éebidenaica. ");
INSERT INTO aca_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Nabésuna'eewoo liá'a cáinabi shínaa jí'ineerri Pisidia, náiinu'e cáinabi jí'ineerri Panfilia néerra. ");
INSERT INTO aca_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Náiiwa'ee Dios chuáni chacáalee jí'ineerri Perge rícu, jáiwa náawai chacáalee jí'ineerri Atalía néerra; ");
INSERT INTO aca_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","náurrucua'eewoo lancha rículai chacáalee jí'ineerri Antioquía néerra, liá'a chacáalee nasátactani nanácu namáacactani nayá quéechanacu Dios cáaji rícu, linácu liá'a tráawaju jáiyi nanísacai. ");
INSERT INTO aca_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Náiinu'inaa Antioquía néerrai, náawaca'eewau náa'a iglesia ísanaca quinínama, ya tá'ee náiiwa'ee nalí quinínama liá'a Dios médani náajcha, ya léjta wácalishi méecu nalí iníjbaa náa'a jócani judíobini, quéewique'e néewa néebida léquichoo. ");
INSERT INTO aca_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Pablo ya Bernabé namáaca'eewoo néeni íchaba éerri náajcha náa'a éebidenaica Dios nácu. ");
INSERT INTO aca_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Liyáali éerrimi'e, áabibi chóniwenai jiánaimicoo Judea néenee Antioquía néerra, nachána'eewau néewidaca náa'a néenajinaica jócani'e nawásedacoo néebida linácu liá'a náijuque'e nachíipi íimanaa juáta, cha léjta Moisés liwána namédaca. ");
INSERT INTO aca_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Pablo ya Bernabé, jáiwa nacáita yáacau wérri náajchai, néenee Pablo ya Bernabé ya áabibi mawí nawína áabai washiálicuenai náaque'iniu Jerusalén néerra ya natáaniaque'e linácu liáni náajcha náa'a apóstoluca ya náa'a salínai iglesia ísanaca Jerusalén néenee sánaca. ");
INSERT INTO aca_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Nabánua'ee náa'a iglesia Antioquía néenee sánaca, nabésuneda'inaa liá'a cáinabi jí'ineerri Fenicia ya Samaria, jáiwa'ee náiiwa náa'a jócani judíos namáaca'ee nawítee ajuítaimica quéewique'e nasíguia Diosru. Ya quinínama náa'a máaquenai nawówau Dios nácu, sáicta'ee wérri nawówa néemi'inaa liá'a chuánshi sáicaica. ");
INSERT INTO aca_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Náiinu'inaa Jerusalén néerra, Pablo ya Bernabé narríshibia'ee nayá iglesia ísanaca ya náa'a apóstoluca ya náa'a salínaibinica, náiiwa'ee nalí quinínama liá'a Dios médani náajcha. ");
INSERT INTO aca_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Ne áabi náa'a fariséobinica éebidenai Jesús nácu, nabárrua'eewau ya namá'ee: —Arrúnaa'ee nawíchua nachíipi íimanaa juáta náa'a éebidenaica jócani judío, nabánua'ee nacúmpliaque'e ley Moisés wánani namédaca. ");
INSERT INTO aca_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Jáiwa'ee náawacawai náa'a apóstolubinica ya náa'a salínaica quéewique'e natáaniacani linácui. ");
INSERT INTO aca_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Néenee liáwinaami natáania linácui, jáiwa'ee Pé'eru bárruawai limá'ee nalí: —Nuéenajinai, iyá yáine léenaa báinacu Dios máiderrite nuyá íibicha nuíiwaque'e irrú sáicai chuáninica liá'a wásedeerri'inaa nalí náa'a jócani'inai judíobini, quéewique'e nayá néebidaca. ");
INSERT INTO aca_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Dios yáa léenaa wawówa, líiyada'ee walí lirríshibiaca nayá, liá'ee nalí Espíritu Santo, léjta liáyu'u walíni. ");
INSERT INTO aca_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Dios jiní limédani báawatani wítee wáucha nayá ya wayá, ne léquichoo nayá bádedeenai nawówau níwata namáacaca nawówau linácu. ");
INSERT INTO aca_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ne chóque'e ¿tánda éeneda Dios iwána namédaca liá'a nawítee ajuítaimica, jócaite wéenaa wacúmpliacte jiní wérri áawita náa'a wawérrinaimica? ");
INSERT INTO aca_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Báawachala wáucha, wayá éebidenai wawásedacoo mawéniyu sáicaca wáajcha liá'a Wawácali Jesúsca, nayá wáseneu liúcha liá'a máashii léquichoo léjta wayá. ");
INSERT INTO aca_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Quinínama nayá manúmata néemi'e nayáca liá'a Pablo ya Bernabé táaniani liyá nácu liá'a shínaashi ya liá'a jócai wacába cáji Dios médani náajcha náiibicha náa'a jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Jái'inaa nanísa natáaniacai, Santiago má'ee: —Nuéenajinai, éemite nulí: ");
INSERT INTO aca_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simón íiwa walíni léjta Dios caníinaa licába nayá quéechanacu náa'a jócani judíobini, liwína'ee néenaa chóniwenai namédaque'e chacáalee Diosruja. ");
INSERT INTO aca_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Liáni áabenai léjta natánaumini náa'a íiwadedenai Dios chuáni báinacu, léjta limáyu Dios chuánica: ");
INSERT INTO aca_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Ne liáwinaami liáni nuéejoominaajoo nubárrueda báaniujoni liá'a cuíta cáarralierricoo liyáca David shínaaca; nuchúniminaa báaniujoni ya nubárruedaminaa báaniujoni, ");
INSERT INTO aca_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","quéewique'e quinínama náajcha náa'a namúrruque'e Wácalishi nawówa yáajchau léquichoo, náajcha náa'a quinínama cáinabi ítesanaca náa'a máaquenai nayáu báawacha nují'inaa nácu. ");
INSERT INTO aca_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Liá'a Wawácalica, wáneerri náa léenaa liáni quinínama báinacumi, liá'a máaquerri lichuániu’. ");
INSERT INTO aca_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","“Nuá léenaa nulíwoo, jócai sáica wabánua naméda liá'a jócai rúnau náa'a jócani judío, máaquenai nawíteu ajuítaimica nasíguiaque'e Diosru. ");
INSERT INTO aca_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Rúnaaminaajoo watána nalí nashírrique'iu liúcha liá'a namédani nalí náa'a jócani Dios. Cáwique'e nacá'a náuchau naméda máashii náinaayu. Jócubeecha íya liérra cuéshinai sácumenaicoo íinaa, jiní liá'a jórquerricoo, ya jócai léquichoo íirrai. ");
INSERT INTO aca_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Ne wawówaicta wáa léenaa báinacu sáimi ái néenaa já'a chacáalee rícu, náa'a éewidenaica Moisés shínaa ley, liá'a naliénica sinagoga rícu éerri jútainchu nawówa íyabactacoo. ");
INSERT INTO aca_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Apóstolubinica ya náa'a salínaica, ya náa'a quinínama iglesia ísanaca, jáiwa nawína áabi néenaa náa'a éebidenaica nabánuaque'e nayá Antioquía néerra Pablo ya Bernabé yáajcha. Jáiwa'ee nawína Judas, né'e léquichoo lijí'inaa Barsabás, ya Silas, washiálicuenai cawíteenica náiibicha náa'a éebidenaica, ");
INSERT INTO aca_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","náajcha nabánua áabai cáashta mérri chá'a: “Wayá apóstolubinica ya náa'a salínaica náa'a éenajinaica watáa wéenajinai náa'a jócani judíobini, náa'a yéenai Antioquía rícu, ya Siria rícu léquichoo ya Cilicia léquichoo. ");
INSERT INTO aca_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Wáa léenaa áabi chóniwenai yáaineu wayéji áani jócani wabánua néerra, ijódia'ee liyú liá'a ichuánicoo, jócai náa léenaa chítashia nayáu'inaa jíni. ");
INSERT INTO aca_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Tánda, wáawacawai, sáica wacábaca wawína wéenau náaque'iniu nacába iyáctalaca náajcha náa'a sáictani wérri wítee wéenajinai Bernabé ya Pabloca, ");
INSERT INTO aca_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","náa'a máaqueneu nayáu carrúnatairru Jesucristo jí'inaa nácu. ");
INSERT INTO aca_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ne léquichoo wabánua Judas ya Silas léquichoo: Nayájoo natáaniaminaa yáajchajoo náiiwaque'e irrú quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ne sáicai wérri wacába liá'a Espíritu Santoca ya wayá léquichoo, jócuminaa wabánua irrú quéewique'e iméda quinínama léjta Moisés tánimica, báawacha liúcha liáni: ");
INSERT INTO aca_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Jócubeecha íya cuéshinai íinaa náani néemani nalí náa'a jócani diose. Jócubeecha íya íirrai, ya léquichoo náa'a cuéshinai sácumenaicoo, cáwique'e nacába náuchau naméda máashii náinaayu. Itúyactau wáujoo liúcha léju liáni, imédaminaa sáicaijoo. Sáicaque'e yáajabajoo.” ");
INSERT INTO aca_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Ne nayájoo, néenee náiiwa'inaa nanáawau, náau Antioquía néerra, náawacacoo'eewau náa'a iglesia ísanaca néntregaa cáashta nalí. ");
INSERT INTO aca_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Náa'a néenajinaica naliá'inaa cáashtai sáicta wérri nawówa. ");
INSERT INTO aca_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Liá'a Judasca ya Silasca wáalenai Dios wítee nawówa lícu, náiiwani'inaa chóniwenairru sáicta wérri'e nawówa néenajinai yáajchau. ");
INSERT INTO aca_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Liáwinaami liá'a éerrica, náa'a néenajinaica náiiwa'ee nanáawau nalí, nabánua nachuániu nalí sáicta wérri nawówa, quéewique'e néejoocoo báaniu náa'a bánuenai nayá.  ");
INSERT INTO aca_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Ne liá'a Silasca wówerri limáacacoo. ");
INSERT INTO aca_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ne Pablo ya Bernabé namáacau Antioquía rícu, íchaba yáajcha mamáarraca néewida ya náiiwa Jesucristo chuáni. ");
INSERT INTO aca_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Áabai éerri liáwinaami, Pablo má'ee Bernabérru: —Wáu wacába náibeji báaniu náa'a wéenajinaica chítashia nayáu jíni quinínama chacáalee rícuba, liá'a wáiiwactamite wawácali chuáni, wacábaque'e chítashia nayáu jíni. ");
INSERT INTO aca_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Bernabé wówerri litée náajchau Juan, liá'a jí'ineerri léquichoo Marcos; ");
INSERT INTO aca_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Ne Pablo jócai wówai litée Marcos, jiníwata liá'a Marcosca limáaca bácai Pablo ya Bernabé Panfilia rícu, jócai wówai liácoo náajcha liá'a tráawaju namédanica. ");
INSERT INTO aca_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Jáiwa náawacawai naméda yáacacuwai linácu liáni, jáiwa'ee nashírria yáacawai. Bernabé litée'e liájchau Marcos náurrucoo'eewau lancha rícula náaque'iniu liwówai jí'ineerri Chipre, ");
INSERT INTO aca_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","nácula Pablo liwówaiyu liwína'a Silas, ya náa'a néenajinaica nasáta'ee nanácu Dios jí'inaa nácu, jáiwa'ee najiá'eewau néenee, ");
INSERT INTO aca_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","nabésuna'eewau Siria ya Cilicia náa'ee nadánani náa'a néenajinaicoo yáainai iglesia rícu. ");
INSERT INTO aca_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Pablo líinu'e Derbe ya Listra néerra, líinuctala'ee linácu liá'a báqueerri quéebidacai Jesucristo nácu, jí'ineerri Timoteo, rucúulee ruá'a báquetoo íinetoo judía quéebidacau Jesucristo nácu, lisálijinaa griego. ");
INSERT INTO aca_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Náa'a néenajinaica yéenai Listra rícu ya Iconio rícu, natáania'ee sáicai wérri linácu. ");
INSERT INTO aca_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Pablo wówerri'e Timoteo yáacoo liájcha, ne quéechanacu liwána náiju nachíipi íimanaa juáta, quéewique'e jóca íiwirri nawówa náa'a judíobinica náa'a yéenaica líta'aa liá'a cáinabica, ne quinínama yáine léenaa Timoteo lisálijinaa griego. ");
INSERT INTO aca_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Quinínama chacáalee nabésunactacoo, náiiwa'ee náacoo néenajinairru, linácu liá'a náiiwani náa'a apóstolubinica ya náa'a salínaibinica náa'a iglesia Jerusalén ísanaca. ");
INSERT INTO aca_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Náa'a iglesia ísanaca, jáiwa'ee nadáwina nawíteewai Jesucristo jí'inaa nácu, náa'a máaquenai cabálininaa, ya liá'a namánaba náa'a éebidenaica lidáwinau mawí. ");
INSERT INTO aca_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Liá'a Dios shínaa Espíritu Santoca jócai wówai náiiwa Jesucristo chuáni léenaa lirrícu liá'a cáinabi jí'ineerri Asia shínaaca, jáiwa'ee nabésunawai liá'a cáinabi jí'ineerri Frigia ya Galacia, ");
INSERT INTO aca_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","náiinu linúmamirra liá'a cáinabica jí'ineerri Misia. Ne néenee namá'inaa'ee nalíwoo nabésunacoo cáinabi jí'ineerri Bitinia, ne liá'a Espíritu Jesús shínaaca, jócai línda jíni. ");
INSERT INTO aca_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Néenee'e, nabésunau machácani Misiarra, náurrucua'eewau á'a lancha chánactau jí'ineerri Troas. ");
INSERT INTO aca_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Liyáali éerrimi Pablo dájuni'e dajuíshi táayee; licába'ee báqueerri washiálicuerri shínaa cáinabi jí'ineerri Macedonia, libárrua'eewau limá'ee Pablorru: “Jibésunau Macedonia rícula jiyúda wayá.” ");
INSERT INTO aca_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Pablo quéecha'inaa lidájuni'inaa liárra dajuíshica, jáiwa wachúni washínaa iníjbaawai wáaque'iu Macedoniala shínaa cáinabi ítala, yáawaiyi Dios máiderri liyá wayá wáaque'iu wáiiwa nalí sáicai chuánshica liá'a Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wáurrucoowai Troas néenee, wáau machácani liwówai jí'ineerri Samotracia, áabai éerri néenee wáiinu áabai chacáalee jí'ineerri Neápolis. ");
INSERT INTO aca_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Néenee jáiwa wáawai áabai chacáalee jí'ineerri Filipos, liá'a chacáalee mawí máanuica líta'aa liá'a cáinabi Macedonia shínaaca, nayácta íchaba náa'a romanobini. Néerra wayáte jócai íchaba éerri. ");
INSERT INTO aca_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Áabai éerri liá'a wawówa íyabactacoo, jáiwa wajiáwai bináawala chacáalee, méeda tácoowala, liá'a wamácacta walíwoo áabai yáarrushi nasátactau náa'a judíobinica. Jáiwa wawáawai watáania sáicai chuánshi, nalí náa'a íinaca yáawaquenaicoo wáajcha. ");
INSERT INTO aca_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Báquetoo néenaa jí'ineechoo Lidia; ruyá néenee sáu áabai chacáalee jí'ineerri Tiatira, wéndechoo wárruma cawéni quíirrai wérri. Ruáni íinetooca, yáichoo sáicai Diosru, éemechoo'e ruyáca, liá'a Wawácalica jáiwa lidúnu ruwówai ruéemique'e liá'a Pablo táaniani liyá nácu. ");
INSERT INTO aca_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Ruéebida Jesucristo nácui rubáutisawai, náajcha náa'a quinínama ruéenajinaica, ne liáwinaami, jáiwa rusáta wáucha: —Ne iyá imácacta iwówau yáawaiyica yáliminaa nuyá nuéebidaminaa Jesucristo nácu, íinu chérra yáaque'iniu núbana néerra. Jáiwa ruwána wamáacaque'iniu ruájcha. ");
INSERT INTO aca_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Libésunate áabai éerri wá'inaateu chaléeni náctalacoo nasáta Dios yúcha, jáiwa wáiinu báquetoo miyácau wáalechoo áabai espíritu cadíbinacai. Ruyá nawánacaala yáarru, ruyá yáichoo léenaa wérri jiníwata áabai espíritu máashii íiwaca rulíni. Tánda ruwácanai jéda íchaba warrúwa. ");
INSERT INTO aca_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Ruáni miyácauca, jáiwa ruchánau rujínacoo Pablo ya wáajchai, rumáidada'ee ruácoo: —¡Náani washiálicuenaica sírbenai Diosru liá'a yéerri áacairra, náa'a íiwenai irrú, chítashia Dios éewa'inaa litée iyá áacairra'inaa! ");
INSERT INTO aca_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Liáni rumédani íchaba éerri, cáashia Pablo, wówa íiwirri liwówa, jáiwa'ee léejoo báaniu limá'ee lirrú liá'a espíritu yéerri runácu ruá'a miyácauca: —Lijí'inaa nácu liá'a Jesucristoca, nuwána jijiácoo rúcha. Liyáalimi espíritu máashiica limáaca ruyái. ");
INSERT INTO aca_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Ne náa'a ruwácanaica ruá'a miyácauca, nacába'ee jócai sáica nagáana runácu warrúwa mawí, jáiwa'ee nawína Pablo ya Silas, jáiwa natéeque'e nayá wánacaleenairru, liá'a plaza chúnsaica. ");
INSERT INTO aca_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Jáiwa nabárrueda nayái nawácanai náneewa namá'ee: —Náani judíobinica íinuenai naméda walí máashii nacáarralia washínaa chóniwenai, ");
INSERT INTO aca_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","éewidenai nawíteeyu wayá jócai wéenaa warríshibiaca, jócai wéenaa namédaca, jiníwata wayá romanobini. ");
INSERT INTO aca_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Néenee náa'a chóniwenaica nabárroo nanácula liá'a Pabloca ya Silas, ya namá'ee náa'a nawácanaica namídudaque'e náabala nabásaidaque'e bárayuni. ");
INSERT INTO aca_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Néenee nanísa'inaa nabásaida nayái, naníqui jíni cuíta manúmai rícula, namá'ee lirrú liá'a catúyacaica liá'a cuíta manúmaica licábaque'e nayá, jócubeecha najiáu nayáca. ");
INSERT INTO aca_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Quéecha'inaa lirríshibia liáni catúyacaica cuíta manúmai liníqui wérri nayá sáica, ya liníqui náiiba áacairra linácula liá'a áicuba cadúcunica lijí'inaa cepo. ");
INSERT INTO aca_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ne liyáalimi béewami táayebee, Pablo ya Silas nasátau ya narrába shímashi Diosru, ya náa'a áabi yáainai cuíta manúmai rícu néemini nayáca, ");
INSERT INTO aca_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ne liyáalimi licúsu liá'a cáinabica cadánani wérri lichúnda liá'a cuíta manúmaica. Liyáalimi liméecu linúma liá'a cuíta manúmaica quinínama, náa'a yéenai cuíta manúmai rícu liwásau liá'a nashínaa cadénaca. ");
INSERT INTO aca_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Quéecha'inaa licáwiacoo liá'a catúyacai cuíta manúmai licába quinínama linúma liá'a cuíta manúmaica méecuerriu, lijéda lishínaa espadau líinuaque'e liyáu, jiníwata limá lirrúwoo náa'a yéenai cuíta manúmai rícu máanenaiwai. ");
INSERT INTO aca_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Ne jáiwa Pablo máidada lirrúi: —¡Ujíinuau, wayá náani ya áani quinínama! ");
INSERT INTO aca_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Néenee liá'a catúyacai cuíta manúmai lisáta áabai licámarrau liwárroo licánacacoo ya chéchinau licáarruniu licuá Pablo ya Silas yáajba. ");
INSERT INTO aca_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Néenee liá'a catúyacai cuíta manúmai lijéda Pablo ya Silas ya lisáta léemiu nayá: —Washiálicuenai, ¿tána arrúnaa numédacai nuwáaliaque'e nucáwicau Dios yáajcha? ");
INSERT INTO aca_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Namá'ee lirrú: —Éebidau linácu liá'a wawácali Jesúsca, jiwáaliaminaa jicáwicau Dios yáajcha jócai amáarra ya jéenajinai lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Jáiwa natáania lirrúi linácu liá'a Wawácali chuánica ya nalí náa'a yéenai lishínaa cuíta néeni. ");
INSERT INTO aca_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Ne liyáalimi hóraaca táayebeeca, liá'a catúyacai cuíta manúmai litée jíni báawachala libádeda natúca náa'a Pabloca ya Silas, jáiwa nabáutisawai liyá ya léenajinai. ");
INSERT INTO aca_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Néenee litée nayá líibana néerrau, liá náaya, liyá ya léenajinai sáitani wérri wówa néebidacala Dios nácu. ");
INSERT INTO aca_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Manúlacaiba, náa'a nawácanaibinica nabánua áabi catúyacani chaléeni catúyacai cuíta manúmai quéewique'e nawáseda Pablo ya Silas. ");
INSERT INTO aca_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Liá'a catúyacai cuíta manúmai limá'ee Pablorru: —Náa'a nawácanaibinica nabánua nuwásedaque'e iyá; tánda yáa namówai chaiwíteemija'a. ");
INSERT INTO aca_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ne Pablo má'ee nalí náa'a catúyacanica: —Ne wayá cháni cábacanaa léjta chóniwenai Roma néenee sánaca, nabásaida wayá chóniwenai náneewa, jóctanaa náa léenaa wajíconaa, naníqui wayá cuíta manúmai rícula; ¿ya chóque'e iwówai iwáseda wayá cabáyainta? ¡Ne jóca! Náiinuque'e nayá jájiu najéda wayá. ");
INSERT INTO aca_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Náa'a catúyacani náaniu náiiwaca nalí náa'a nawácanaibinica, jáiwa nacáarrudawai náa'ee léenaa nayá'ee cháni cábacanaa léjta chóniwenai Roma néenee sánaca. ");
INSERT INTO aca_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Náawai náa'a nawácanaibinica, nasáta perdón Pablo ya Silas yúcha, ya najéda jíni cuíta manúmai rícucha, ya namá'ee nalí najiáque'iu lirrícucha liá'a chacáaleeca. ");
INSERT INTO aca_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Najiá'inau lirrícucha liá'a cuíta manúmai náa'a Pablo ya Silas, jáiwa náawai rúbana néerra ruá'a Lidiaca, néenee nanísa nacába náa'a éebidenai Dios chuáni náa nadánani, jáiwa náau néenee. ");
INSERT INTO aca_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Pablo ya Silas náau mamáarraca nabéechalau. Nabésunau lirrícu náa'a chacáalee jí'ineerri Anfípolis ya Apolonia, jáiwa náiinui chaléeni chacáalee jí'ineerri Tesalónicaca, nawáaliacta áabai sinagoga judíobinica. ");
INSERT INTO aca_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Pablo, léjta liwíteeja, liáu chaléeni sinagoga néerra, táshia éerri jíni liwówa íyabactacoo, léjta matálii semana litáania náajcha. Léewida nayá léjta limáyu liá'a Dios chuánica, ");
INSERT INTO aca_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","líiwadeda nalí liá'a Mesíasca arrúnai'inaa máanalica, ne máanalicai yáawinaami licáwiaminau báaniu. Limá nalí: —Liyája liáni Jesús numáni irrú, liyája liérra Mesíasca. ");
INSERT INTO aca_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Áabi néenaa náa'a judíobinica néebidani, nawína yáacau Pablo yáajcha ya Silas. Cha lécchoo néebida íchaba néenaa náa'a griégobinica yáine Diosru sáicai ya íichaba íina cawénini wérri. ");
INSERT INTO aca_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ne náa'a áabi judíobinica cadéni nayá. Namúrru áabai chóniwenai máashiini jínanenaiu cáaye rícu jiníni médani, quéewique'e nacáarraliaca ya najódiaque'e chóniwenai chacáalee rícu sánaca. Náani máashiinica lécchoo náau líibana nácula liá'a báqueerri washiálicuerri jí'ineerri Jasónca, najédaque'e néenee Pablo ya Silas quéewique'e néejuedaque'e chóniwenairruni. ");
INSERT INTO aca_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ne jócala náiinu Pablo ya Silas, jáiwa nárdeda Jasón ya áabi éebidenai Dios nácu nanáneewa náa'a chacáalee wácanaica, máidadenai náacoo: —¡Nayája náani washiálicuenai jínanenaiu quinínama cáinabi naméda namáacoo quinínama máashii chóniwenai íibi, náiinu léquichoo áani, ");
INSERT INTO aca_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ya Jasón wína nayá líibana néeniu! ¡Quinínama nayá jócani méda liwánacaala liá'a chúnsai liwácali romano shínaaca, ne namá jáicala báqueerri reyja'a, léja liá'a Jesúsca! ");
INSERT INTO aca_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Néemi'inaa liáni, jáiwa chóniwenai ya náa'a cawánacaalacani cáarrudenaiu. ");
INSERT INTO aca_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Ne Jasón ya náa'a áabibica napáida áabai warrúwa, ya nawáseda nayá. ");
INSERT INTO aca_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Ne táaye'inaami, náa'a éebidenaica nabánua Pablo ya Silas náaque'iu báitanacu chaléeni chacáalee jí'ineerri Berea. Náiinu'inaami náau báitanacu chaléeni sinagoga néerra judíobini shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Náani judíoca, mawíni sáica wítee náucha náa'a Tesalónica néenee sánaca, narríshibiani sáica wérri nawówa yáajchau liá'a chuánshica, mawí éerri néewidau Dios chuáni nácu, nacábaque'e namáni nalí yáawaictajani. ");
INSERT INTO aca_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Ne íchaba néenaa éebidenai, ya lécchoo néebida íchaba néenaa náa'a griégobinica, cha lécchoo íina cawénini wérrica ya washiálicuenai. ");
INSERT INTO aca_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Ne náa'a judíobinica Tesalónica néenee sánaca, náa léenaa'inaa Pablo íiwadeda liá'a chuánshi Dios shínaa á'a Berea lécchoo, náau néerrai nacáarraliaque'e náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ne náa'a áabi éebidenaica nawána Pablo jiácoo madéjcata chaléeni litácoowala liá'a manuáca, ne Silas ya Timoteo máaquenai á'a Berea. ");
INSERT INTO aca_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Náa'a tálidedeenai Pablo yáaineu liájcha atanúma á'a chacáalee jí'ineerri Atenas. Néenee néejuawai náiiwa nalí náa'a Silasca ya Timoteo náaque'iu madéjcata Pablo íshiirricu. ");
INSERT INTO aca_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Nácula Pablo nénda á'a Atenas néerra liá'a Silas ya Timoteo, máashii wérri liwówa licábacala liá'a chacáalee cashiámu diosnai jócai yáawaiyi. ");
INSERT INTO aca_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Tándawa liméda yáacau sinagoga rícu, náajcha náa'a judíobinica ya áabi chóniwenai yáinai sáicai Diosru, ya éerri jútainchu naméda yáacacoo náajcha náa'a yáawaquenaicoo plaza rícu. ");
INSERT INTO aca_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Cha lécchoo áabi quéewidacani néenaa jí'ineenai epicúreos ya estóicos, nachána naméda yáacacoo Pablo yáajcha. Áabi má'ee: —¿Tána litáania léji liéni catáaniacaica? Ya áabi má'ee: —Jicá'a liá'a táaneerri áabata diosnai déecuche sái nácu. Léewa'ee namáni liérra níwata Pablo íiwadedeerri linácu liá'a chuánshi sáicaica Jesús nácu, néewacala nacáwiacoo náa'a máanalinica. ");
INSERT INTO aca_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Néenee natée jíni chaléeni Areópago néerra. (Atenas néerra jí'ineerri Areópago, náarrui náa'a wánacaleenai chacáalee rícu). Liá'a yáarrushi sáictata nacába náawacacoo, nasáta néemiu Pablo: —¿Jéewa jíiwa walí liá'a wáalii chuánshi jéewidani nácu jíndani walí? ");
INSERT INTO aca_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ne jitáania walí áabata chuánshi báawatai, ya wawówaini wáa léenaa tánashia jiwówai jimácai. ");
INSERT INTO aca_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ya quinínama náa'a yéenai Atenas néerra, léjta lécchoo náa'a déecuche sánaca yéenaimi á'a, bácainaa sáictai néemica ya natáaniaca chuánshi wáalii. ");
INSERT INTO aca_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Pablo bárroo nalí béewami Areópago rícu, limá'ee: —Chóniwenai Atenas néenee sánaca, quinínama liáni nucábanica, iyá chóniwenai éebidenai wérri linácu liá'a wíteeshica. ");
INSERT INTO aca_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Nácula nujínaniu chacáalee rícu, nucába iyá isátau íchaba diose yúcha, ya nuíinu áabai altar liá'a tánerricoo cháa: ‘Liá'a Dios jócai wacúnusia’. Wée sáicai, liérra Dios isátanicoo yúcha jócai icúnusia, linácuwa nutáania irrú. ");
INSERT INTO aca_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","“Liá'a Diosca quénuderri quinínama cáinabi quinínama liá'a yéerri líta'aa, liyáwaja liérra wácalishi áacai sáica ya cáinabi íta'aa. Jócai yáa lirrícu liá'a temploca washiálicuenai médanica. ");
INSERT INTO aca_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Jiní lirrúnaani naméda liwícaubali, liyája liárra yáirri wacáwica quinínama, cáuli ya quinínama mawí. ");
INSERT INTO aca_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","“Bácai rímii washiálicuerri rícue quénuderri quinínama chóniwenai, nayáque'e quinínama cáinabi íta'aa; líyadani nalí liá'a éerrica ya liá'a yáarruishica néewacta nayáca, ");
INSERT INTO aca_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","namúrruque'e Dios, ya cáajbami, újni najísedauca néewaque'e náiinucani, báawita yáawaa jócu Dios ya wáucha déecucha bácainaa. ");
INSERT INTO aca_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Jiníwata wayá yéenai Dios nácula, wachúniniu ya wéewa wayáca; ya léjta léquichoo náa'a áabibi éewenai najéda chuánshi nawíta rícuejiu nashínaaca namá'ee: ‘Wayáca Dios táqueenaibimi’. ");
INSERT INTO aca_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Wayácta Dios táquenaibimi, jócu arrúnaa wamá walíwau léecala, liá'a Dios litáanaaminaa óroyu, ya platayu, jócta íibayu namédani náa'a washiálicuenaica nawíteeyu. ");
INSERT INTO aca_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Báinacu Dios míya máecha quinínama namédani liárra, jiníwata jócala náa léenaa liá'a namédanica; ne chóque'e, Dios bánua quinínama chóniwenai, quinínama cáinabi néejuacoo lirrú, néebidaque'e linácu. ");
INSERT INTO aca_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Dios ái wína áabai éerri, ya liyáali éerri, jiní licábacala báqueerri chóniwerri sáicai áabi yúcha; liyáminaa májoo chóniwenai médacta sáictai o máashii. Quinínama liérra limédani'inaa báqueerri washiálicuerri rícueji liá'a liwínanica, jí'ineerri Jesús. Dios íyadani chóniwenairru cháca rúnaa libésunacoo, liyáwa wáneerri Jesús cáwiacoo náiibicha náa'a máanalinica”. ");
INSERT INTO aca_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Néemi'inaa liáni nacáwiacalau máanalicai yúcha, áabibi nacáida'ee ya áabi namá'ee: —Wanísaminaa wéemicojoni áabata yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Néenee Pablo máaca nayái, jáiwa liáwai. ");
INSERT INTO aca_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Ne áabi yáau liájcha néebidani. Náiibi yéerri liá'a Dionísioca, néenaa náa'a Areópagoca; ya léquichoo báquetoo íinetoo jí'ineechoo Dámaris, ya áabi mawí. ");
INSERT INTO aca_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Liáwinaami liáni, Pablo jiáu Atenas rícucha, jáiwa liáwai lirrícula liá'a chacáalee jí'ineerri Corinto. ");
INSERT INTO aca_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Néerra líinu báqueerri washiálicuerri judío jí'ineerri Aquila, liyá che sáini cáinabi jí'ineerri Ponto. Liyáali íchaitaa Aquila ya líinu Priscila íinuenai lítee liá'a cáinabica jí'ineerri Italia, chéni rúnacte najiácoo jiníwata liá'a nawácali jí'ineerri Claudio, wáneerri najiácoo quinínama náa'a judíobinica, najiáque'iu chacáalee jí'ineerri Roma. Pablo yáairri licába nayá, ");
INSERT INTO aca_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","jiníwata Pablo wáaleerri léenaa liá'a tráawajuca, namédaque'e tólda nawéndacta'inaa nashínau, íchaitaa limáacau náajcha limédaque'e náajcha liá'a tráawaju. ");
INSERT INTO aca_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ne éerri jútainchu nawówa íyabactacoo, Pablo yáairriu sinagoga rícula, natáaniactaca néewidactaca náa'a judíobinica ya náa'a jócani judío, quéewique'e néebida Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Quéecha'inaa Silas ya Timoteo náiinu'inaa á'a Macedonia, Pablo liyá'inaaja líiwadeda quinínama éerri liá'a chuánshica, líyadaque'e nalí náa'a judíobinica Jesúscala léja liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Ne nayá nachána namédacoo báawacha liúcha namá lirrú chuánshi máashii; jáiwa Pablo tútuda líibalau, liwówau limáca nayá médenai máashii jócai néebida, ya limá nalí: —Iyáminaa wáalia ítalashi iyá jájiu yúcaque'iu; nuyá jócai wáalia ítalashi. Chóque'e libéechalawoo nuáu jócani judíobini néerra. ");
INSERT INTO aca_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Lijiáu chéni sinagoga, néenee liáu líibana néerra liá'a báqueerri washiálicuerri jí'ineerri Ticio Justo, sáterriu Dios yúcha, yéerri léema nácu liá'a sinagogaca. ");
INSERT INTO aca_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Báqueerri washiálicuerri jí'ineerri Crispo, liwácali liá'a sinagogaca, léebida Jesús nácu quinínama yáainai líbana lícu. Ya lécchu quinínama náa'a Corinto sánaca, néemi liá'a Jesús chuánica, jáiwa néebida jíni nabáutisawai. ");
INSERT INTO aca_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Áabai táayee, liá'a Wawácalica limá'ee Pablorru liá'a áabai lituírricu sái: “Ucáarru jiyá; jiáyu jíiwadeda liá'a chuánshica mamáarraca. ");
INSERT INTO aca_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Jiníwata nuyá yéerri jiájcha, jiní éewa lidúnu jinácu limédaque'e jirrú máashii, ne nuyá wáaleerri íchaba chóniwenai lirrícu liáni chacáaleeca.” ");
INSERT INTO aca_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Tándawa Pablo máacau áabai camuí ya béewami á'a Corinto, léewidaca náiibi liá'a chuánshica Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Ne liyáali éerri liá'a Galiónca wánacaleerri á'a Acaya, náa'a judíobinica náawacau Pablo júnta'inaa; natéeni nawácanaibini júnta, ");
INSERT INTO aca_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ne má'ee lirrú liá'a wánacaleerrica: —Liáni washiálicuerrica jínaneerriu éewiderri limácoo náa'a chóniwenaica, quéewique'e náa Diosru sáica liyú liá'a áabataca lijúnta liá'a leyca. ");
INSERT INTO aca_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Pablo ái'inaata táaniacai, quéecha'inaa Galión máca nalí náa'a judíobinica: —Ne jíconaashiquictani, jócta cáiinuacai áabi, nuyáminaa nuéemiminaa irrújoni iyá judíobinica; ");
INSERT INTO aca_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ne liyú'inaa liérra chuánshica, jí'inaashi ya ishínaa ley, ichúniu iyá jájiuni, jiníwata nuyá jócai wówai nuwárruacoo linácu liárra. ");
INSERT INTO aca_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Ya lijédani lirrícucha liá'a náawacactacoo náa'a wánacaleenaica. ");
INSERT INTO aca_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Néenee nawína báqueerri namánabayu jí'ineerri Sóstenes, liwácali liá'a sinagogaca, nabásaidani néeni, nanáneewa náa'a nawácanaibinica. Ne Galión jiní wérri wéni lirrú liérra. ");
INSERT INTO aca_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Pablo máaquerriu íchaba éerri á'a Corinto. Liáwinaami líiwa lináwawai léenajinairru, liájcha Priscila ya Aquila, náurrucoo náaque'iu lítala liá'a cáinabi jí'ineerri Siria. Liá'a chacáaleeca jí'ineerri Cencrea, jóctanaa liúrrucuajau, lirráirreda liwíta báinawai, quéewique'e licúmpliaque'e liá'a chuánshi limánimica. ");
INSERT INTO aca_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Quéecha'inaa náiinucai á'a Éfeso, Pablo máaca Priscila ya Aquila, jáiwa liáwai sinagoga néerra litáaniactaca náajcha náa'a judíobinica náawacactacoo. ");
INSERT INTO aca_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","Nayá namésudani wówa namáaque'iu íchaba éerri mawí, ne jócu liwówai, ");
INSERT INTO aca_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ne jáiwa líiwa lináawawai limá'ee nalí: “Dios wówaicta, nuéejuaminaujoo nucába iyá báaniu.” Néenee Pablo yúrrucoo báaniu, jáiwa liáwai Éfeso néenee. ");
INSERT INTO aca_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Quéecha'inaa líinucai á'a chacáalee jí'ineerri Cesarea, liáwai Jerusalén néerra, liáque'iu litáa nalí náa'a éebidenaica Dios nácu, néenee liáu chaléeni Antioquía néerra. ");
INSERT INTO aca_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Liáwinaami áabi éerri, liáu báaniu lijínanicoo áabainaa lirrícu liá'a chacáalee liá'a cáinabi jí'ineerri Galacia ya Frigia, liá nadánani quinínama náa'a éebidenai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Ne liyáali éerrimi líinu Éfeso néerra báqueerri judío jí'ineerri Apolos, chacáalee jí'ineerri Alejandría néenee sái. Yáirri wérri léenaa sáica, cúnusierri sáica liá'a tánerricoo Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Yéerri sáica wérri Dios chuáni nácu, ya táaneerri jucámarranaa liwówa yáajchau, léewidaca jucámarranaa Jesús nácu, báawita bácai licúnusia linácu liá'a bautísmoca Juan shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Liá'a Apólosca libárroo litáaniaca chóniwenai náneewa sinagoga rícu; ne néemi'inaami jíni Priscilaca ya Aquila, néenee natée jíni báawachala náiiwa lirrú jíni sáica wérri liá'a Dios chuánica. ");
INSERT INTO aca_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Quéecha'inaa Apolos wówai liácoo nayáctala náa'a chóniwenai yéenai cáinabi íta'aa jí'ineerri Acaya, néenajinai yúdani, ya natána áabai cáashta nalí náa'a éebidenai Dios nácu néenee sánaca, quéewique'e narríshibia sáicani. Ne líinu'inaa Acaya néerrai, liyúda íchaba nalí náa'a éebidenaica, jiníwata Dios sáicai wérri néebidaque'e linácu. ");
INSERT INTO aca_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Ne quinínama náneewa namá judíobini nácucha, limáni nalí jócai néenaa nabáyaca, líyada Dios chuáni nácu, léewidani yáawacaala léja liá'a Jesúsca liá'a Mesíasca. ");
INSERT INTO aca_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Nácula Apolos yáa á'a Corinto, Pablo chuáu líibi liá'a awácaca líinu Éfeso néerrai, líinu íchaba éebidenai Dios nácu. ");
INSERT INTO aca_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Jáiwa lisáta léemi nayái: —¿Irríshibia léji liá'a Espíritu Santoca éebida'inaami Jesús nácu? Nayá néeba liúchani: —Jócai wíta wéemi natáania nácu liá'a Espíritu Santoca. ");
INSERT INTO aca_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Pablo sáta léemiu nayá: —Ne, ¿chíta nabáutisau iyá jíni? Nayá éeba'ee: —Liyú liá'a bautismo Juan shínaamica. ");
INSERT INTO aca_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Pablo má'ee nalí: —Jajá, Juan báutiseerri náa'a éejuenaicoo Diosru, ne limá'ee nalí éebida linácu liá'a íinuerri'inaa báaniu nuíshiirricu, wówerri limáca, liyáca Jesús. ");
INSERT INTO aca_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Néemi'inaa liáni, jáiwa nabáutisawai Jesús jí'inaa nácu; ");
INSERT INTO aca_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ya néenee Pablo máaca'inaa licáajiu nanácu, líinu nanácu liá'a léquichoo liá'a Espíritu Santoca, natáania áabai chuánshi báawatai, néewidau chuánshi Dios yáani nalí. ");
INSERT INTO aca_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Namánabaca doceca náa'a washiálicuenaica. ");
INSERT INTO aca_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ne liyáali matálii quéerri, Pablo yáairriu liyáca sinagoga néerra, líiwadedacta jócai cáarrunaa chuánshi, cáiteerri nayá yáawai wérriyu, ya liwówai métaa néebidaque'e Dios wánacaalactaca. ");
INSERT INTO aca_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Ne áabibi, liyájurricani, jócani wówai néebidaca, újni chóniwenai náneewa natáania máashii linácu liá'a wáalii chuánshica. Néenee Pablo lishírriu náucha, ya litée náa'a éebidenaica chaléeni escuela néerra lishínaa báqueerri jí'ineerri Tirano. Chaléeni litáania éerri jútainchu, ");
INSERT INTO aca_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Cha limédaqui jíni chámacua camuí, chái léjta náa'a yéenai quinínama líta'aa liá'a cáinabi jí'ineerri Asia, ya náa'a judíobinica ya náa'a jócani judío, néemi liá'a wawácali chuánica. ");
INSERT INTO aca_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Dios limédaca máanui jócai nacába cáji Pablo nácueji, ");
INSERT INTO aca_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","báawita liá'a pañueloca, ya liá'a íibalashi dúnuerri lináanai natéeni bálinenairru, ne liáni éederri nabálinacaala ya náa'a espíritu máashiica jiérriu náucha. ");
INSERT INTO aca_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Ne áabibi judíobini, jínanenaiu cáaye rícu jédenai namácoo chóniwenai yúcha espíritu máashii, nawówaini namédaca lijí'inaa lícu liá'a Wawácali Jesúsca; namá'ee nalí náa'a espírituca: “¡Lijí'inaa lícu liá'a wawácali Jesúsca, Pablo íiwanica, nabánua jirrú jijiáyu!” ");
INSERT INTO aca_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Léwa liáni namédani náa'a siete léenibi liá'a judíoca jí'ineerri Esceva, liá'a báqueerri nawácalica náa'a sacerdótebini. ");
INSERT INTO aca_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ne áabai éerrimite liá'a espíritu máashiica limá'ee: “Nucúnusia Jesús, ya nuá léenaa Pablo; ne iyá ¿tána iyái?” ");
INSERT INTO aca_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Ne liyáalimi, liá'a washiálicuerrica wáaleerri espíritu máashii íinuerri nanácula, ya quinínama lidánani yáajchau liméda mawí náucha quinínama, líinueda bájiala nayá carrúnatai, najiáwai nábana rícucha jushícai ya catúcai. ");
INSERT INTO aca_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Quinínama náa'a yáainai Éfeso rícu, judíobini ya jócani judío, ná'inaa léenaa, jáiwa cáarru wérri nayái. Ne chacábacanaa licáarraliau Jesús jí'inaa íiwanaa cawéni wérrica. ");
INSERT INTO aca_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Ya lécchoo íchaba náa'a éebidenaica náiinu náiiwadedaca quinínama liá'a máashiica namédani quéecha, ");
INSERT INTO aca_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ya íchaba médenaiu camálicaniyu, náinda nashínaa cáashtau néemaque'ini quinínama náneewa. Quéecha'inaa májna nalíwoo liwéni liá'a cáashtaca, liwéni jiá'eewoo léjta cincuenta mil éerri tráawaju shínaa. ");
INSERT INTO aca_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Cha járra liá'a lichuánica liá'a wawácalica yáairriu mamáarraca cáarraliacoo matuínaami, liácoo íyaderriu liácoo liwíteu. ");
INSERT INTO aca_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Liáwinaami liáni bésuneerricoo, Pablo wówai liácoo Macedonia néerra ya Acaya néerra, ya liáu mamáarraca chaléeni Jerusalén néerra. Ya léquichoo limá'ee néenee liáu Jerusalén néerra ya arrúnaa liácoo léquichoo chaléeni Roma néerra. ");
INSERT INTO aca_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Ya néenee libánua Macedonia néerra chámata liájcha sána, Timoteo ya Erasto, nácula limáacau áabata éerri mawí á'a Asia. ");
INSERT INTO aca_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ne liyáali éerrimi, naméda á'a Éfeso rícu íchaba cáarraleneu nayáca urrúni lirrú liá'a néewidani wáaliiyu, ");
INSERT INTO aca_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","liwánaca liá'a báqueerri jí'ineerri Demetrio, tráawajeerri jiárru sáicai jí'ineerri warrúwa, méderri quinínama méenaami cábacanaa. Liáni washiálicuerrica méderri mawí licábacanaa cuíta píitui rími, léjta templo diosa jí'ineechoo Artemisa, liáni namédanica yáirri nalí manuába warrúwa, lirrú ya náa'a tráawajenai liájcha. ");
INSERT INTO aca_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Liáawaqueda náani, áabi yáajcha tráawajenai áabenaa tráawajuca, limá'ee nalí: “Nawácali, yáa léenaa washínaa cashínanica wayáque'e sáica wacábajoni liáni washínaa tráawajuca. ");
INSERT INTO aca_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Ne iyá cábenai ya éemi, liárra Pabloca máirri limácoo náa'a diosnai washiálicuenai médani áani, jócaita diosnai; cha léewida íchaba chóniwenai, jócaita bábajuta áani Éfeso rícu, á'a atéwa quinínama cáinabi Asia íta'aa. ");
INSERT INTO aca_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Liáni carrúnatai, jiníwata washínaa negocio carrúnatai yúcacoo, ya léja liá'a temploca lishínaa liá'a diosa cawéninica jí'ineechoo Artemisa, éewerri lipérdia liá'a cawénica lishínaaca, chacábacanaa náuca ruá'a máanui cábacoo jicá'a diosa náani jirrú sáicai á'a Asia ya quinínama macájirra cáinabi.” ");
INSERT INTO aca_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Néemi'inaa quinínama liáni, íiwirri wérri nawówa, jáiwa namáidada namá'ee: “¡Sáicacajani Artemisa efesios sána shínaa!” ");
INSERT INTO aca_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Jáiwa namáidada mamáarracai lirrícu liá'a chacáaleeca. Jáiwa náiinu lináculai náa'a Gayo ya Aristarco, chámata washiálicuenai Macedonia sána máinaiu Pablo yáajcha, jáiwa nárda jíni chaléeni áabai cuíta máanui wérri quiní báinaa jí'ineerri teatro, náawacactacoo. ");
INSERT INTO aca_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Pablo wówai liwárruacoo lirrícu liá'a cuíta máanuica, quéewique'e litáania nalí náa'a chóniwenaica, ne náa'a éebidenaica jócu náinda jíni. ");
INSERT INTO aca_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ya léquichoo náiibi náa'a cawánacaalacanica Asia sánaca ái néenaa já'a Pablo júnicai, nabánua nachuániu lirrú jócala léewa liwárruacoo néerra. ");
INSERT INTO aca_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Nácula, lirrícu liá'a náawacactacoo, áabi máidada báawatai, áabi báawata, jiníwata náa'a chóniwenaica yáawaquenaiu matuínaami; náa'a áabibica jócai náa léenaa tándashia náawacawai. ");
INSERT INTO aca_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ne áabi néenaa náiiwa lináwa liá'a Alejandro. Liyá judíobini dáanedani quinínama náneewa. Alejandro nácuda licáajiu quéewique'e náyabacoo, litáaniaque'e liwícaubali chóniwenai náneewa. ");
INSERT INTO aca_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Ne ná'inaa léenaa liá'a Alejándroca judío lécchoo, namáidada quinínama chámai hóraa: “¡Sáicacajani Artemisa efesios sána shínaa!” ");
INSERT INTO aca_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Báqueerri nawácali náa'a chacáaleeca, léewa'inaa liyábeda náa'a chóniwenaica, limá'ee: “Chóniwenai Éfeso sána, quinínama náa'a chóniwenaica lísana liáni chacáaleeca namáacani túyaca liáni temploca shínaa máanuica diosa Artemisa, ya rushínaa tánaashi cáirriu áacaiji. ");
INSERT INTO aca_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Jiníwata jiní éewa libáya liáni, íyabau iyá, u'iméda jóctanaa yáa léenaa sáica. ");
INSERT INTO aca_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Jiníwata náani washiálicuenaica índanica jócani méda máashii templorru, jiní natáaniacala máashii runácucha ruá'a washínaa diosaca. ");
INSERT INTO aca_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Ya Demetrio ya náa'a tráawajene liájcha wáalenai áabata chuánshi linácucha, wánacaleenai náa'a ya néeni ya náarru náa'a wánacaleenaica; nasátaque'e néemiu nanáneewani náa'a wánacaleenaica natúyaque'iu nashínaa bácainaa. ");
INSERT INTO aca_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Ya iyá isátacta áabata mawí, arrúnaa náawacacoo yáawaiyi. ");
INSERT INTO aca_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","41","Liá'a bésuneerricoo wáalee carrúnatai, jiníwata néewa náiiwacai wayá cáiinua yáacacanicoo, jiní áabai chuánshi wéewani wáiiwaca, nasátacta néemiu wayá linácu liáni wacáarraliactacoo.” Linísa'inaa limáqui jiliéni, líiwa lináwawai chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Amáarrai'inaa léji liá'a nacáarraliactacoo macáishita, Pablo máida náa'a éebidenaica quéewique'e léewida nawítee. Néenee líiwa lináwau nalí, jáiwa liáwai Macedoniala. ");
INSERT INTO aca_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Ne liáu licába nashínaa cáinabi néerra quinínama, liá nadánani íchaba limácala nalí náa'a léenajinaica; ya néenee líinu Greciala. ");
INSERT INTO aca_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Grecia néerra limáacau matálicua quéerri. Áimi yáacoo liyá cái lancha rícula quéewique'e liácoo Siriala, liá'inaa léenaa náa'a judíobinica nawówai naméda lirrú máashii. Néenee liwówai liácoo macáshtai, libésunau báaniu Macedonia. ");
INSERT INTO aca_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Natálideda liyá náa'a Sópater Berea néenee sái, lisálijinaa jí'ineerri Pirro; ya Aristarco ya Segundo Tesalónica néenee sánaca, Gayo, Derbe sái, Timoteo ya léquichoo Tíquico ya Trófimo chésa náani líta'aa liá'a cáinabi jí'ineerri Asia. ");
INSERT INTO aca_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Náani wéenajinaica náau wabéecha nanénda wayá á'a Troas. ");
INSERT INTO aca_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Wayá, liáwinaami liá'a fiestaca wáayacta liá'a páanica méewisaa jócta limúrracau wajiáu chéni Filipos néenee lancha rícu, ne cinco éerri rícula wáiinu nanácu á'a Troas, wamáacactacoo siete éerri. ");
INSERT INTO aca_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ya néenee áabai éerri domingo rícu, wáawaca yáacau náajcha náa'a éebidenai Jesús nácui, wáirraque'e liá'a Santa Cenaca, Pablo táaneerri liyáca náajcha náa'a éebidenaica. Arrúnaaca liácoo cajójchanaami, Pablo íiwa nalí Dios chuáni cáashia béewamicta táayebeeca. ");
INSERT INTO aca_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Wáawaca yáacau áabai cuarto rícu áacairra matálii piso rícula, íchabactala lámpara túculenaiu; ");
INSERT INTO aca_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ya báqueerri icúlirrijui jí'ineerri Eutico wáairri liyáca ventana númacua íta'aa. Ne Pablo táaniacala déecu wérri, néenee cadájuni jíni liá'a icúlirrijuica, jáiwa limáaca béemi, néenee licáwai chéni matálii piso ítee; jáiwa nabárrueda jíni máanali. ");
INSERT INTO aca_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Néenee Pablo yúrrucuawai liyácta liá'a icúlirrijuica, liwína jíni lishíquia jíni. Limá'ee léenajinairru: —U'icáarrudau, cáwi. ");
INSERT INTO aca_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Néenee Pablo éejoo líirracoo, lisúbirreda páani, wáaya jíni, jáiwa lisíguia litáaniaca cáashia jucámarraca. Néenee liáwai. ");
INSERT INTO aca_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Néenee natée jíni liá'a icúlirrijuica, cáwi líibana néerrau, liyú sáicta wéerri nawówa. ");
INSERT INTO aca_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Wayá yáainaiu nabéecha wáau lancha rícu, chaléeni Aso néerra wáque'iu wéda Pablo, le namáyu'u, jiníwata liwówaicala liácoo macáshtai. ");
INSERT INTO aca_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Quéecha'inaa wáiinu linácui á'a Aso, liúrrucoo wáajchai wáawai Mitilene néerra. ");
INSERT INTO aca_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Wajiáu néenee, cajójchanaami wabésunau lijúntami liá'a Quío, wáiinu áabai éerri liáwinaami liájba lícu liá'a Samos. Ne batáijinaami náau áabai éerri mawí, wáiinui Mileto néerra. Liáwinaami wabárruacoo áabai chacáalee jí'ineerri Troguílio. ");
INSERT INTO aca_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Liméda cháa, jiníwata Pablo, jócubeecha lidécudau bájiala Asia néeni, jócu liwówai liácoo Éfeso néerra; liwówai linísacoo madéjcata Jerusalén néerra, léewactau liyáca Jerusalén néerra léerdi liá'a Pentecostés. ");
INSERT INTO aca_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Nayá'inaa chacáalee jí'ineerri Mileto rícu, Pablo wána namáida náa'a salínai yáainai iglesia Éfeso rícu litáaniaque'e náajcha. ");
INSERT INTO aca_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Quéecha'inaa náiinuca limá'ee nalí: “Iyá yáine léenaa sáicai, chítashia nuyáu jíni quéechanacu'inaa nuíinu cáinabi Asia rícula. ");
INSERT INTO aca_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Éerri jútainchu nuyá yáajcha nusírbia nuwácali nuwówa yáajchau, rúnaa nuíchaca liá'a máashii nubésunedanica, náa'a nawówaini naméda nuájcha náa'a judíobinica. ");
INSERT INTO aca_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ne jócai numáaca iyá nuíiwaque'e irrú, liá'a sáicai'inaa irrú, nuéewida iyá chóniwenai náneewa ya nábana rícu lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Náa'a judíobinirru ya náa'a jócani judíobini numá nalí éejooque'iu Diosru imáaca iwówau Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","Chóque'e nuáu Jerusalén néerra, Espíritu Santo wána nuáacoo néerra, jócai nuá léenaa tánashia yéesa nuyá néerrai. ");
INSERT INTO aca_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Ne nuá léenaa máayabaca táshia nuíinucta chacáalee náiiwa nulí, Espíritu Santo ma nulí rúnaaminaa natée nuyájoo cuíta manúmai rícula carrúni jináataminaa nuyá néerrajoo. ");
INSERT INTO aca_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Ne nulí, áawita libésunacoo liáni, jiní wéni máanaliquicta nuyá. Ne nuwówaini nutée liá'a sáicai Dios chuánica, Dios caníinaa licába wayá, léjta Jesús nuwácali bánua nuyá. ");
INSERT INTO aca_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","26","“Nuyá nuá léenaa yáawaiyi jócuminaa éejoo icába nuyá mawiá, iyá nuíiwani irrú Dios chuáni wánacaalactalaca. Nuwówai numá irrú nunísa nuíiwa irrú Dios chuáni, tánda linácue jóca nuá léenaa cajíconaa nuyá. ");
INSERT INTO aca_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Jái nunísa nuíiwa irrúi Dios chuáni máyu'uca. Jócai nubáya yúcha. ");
INSERT INTO aca_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Ne rúnaa iyáca, cawíteeyu itúyau'inaa quinínama náa'a máaquenai nawówau; Espíritu Santo máacanica pastorbini, natúyaque'e chóniwenai iglesia rícu sána Dios shínaaca, liá'a liwénini chúnsai líirranayu. ");
INSERT INTO aca_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Ne nuá léenaa jáicta nuáawai, náiinuminaa áabi chóniwenai, jicá'a náa'a cháawi carrúnatanica, wówainai namáardaca chóniwenai iglesia rícu sána. ");
INSERT INTO aca_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Ne íibicha lijiáminau chóniwenai íiwadedenai nanúma yúwicau quéewique'e náa'a éebidenaica náaque'iu líshiirricu. ");
INSERT INTO aca_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Yáainai cáwi tuíshiyu; édacaniteu linácu liá'a matáli camuíca, éerrinacu ya táayee, nuéewida iyá ya nuíicha irrú bácainaa yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ne chóque'e, nuéenajinai, iwína iwówa lícula Dios, caníinaa Dios cába iyá. Dios wáaleerri lidánaniu liwánau náa wadáwinacoo lichuáni nácu, liáminaa irrú quinínama liá irrú iyá lishínaa chóniwenai majíconaanica. ");
INSERT INTO aca_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","Jócai nuwówai nulíwoo nuyá, liá'a warrúwaca ya liá'a íibalashica jiní shínaa; ");
INSERT INTO aca_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","jócai cha, ne iyá yáine léenaa nuyá tráawajairri nucáajiyu nuíinu'inaa quinínama liá'a nurrúnaani jinánica ya náa'a yáainai nuájcha. ");
INSERT INTO aca_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Séewirri nuéewidani iyá nácu léquichoo cháwa wéewa watráawajaaqui jírra, wayúdaque'e náa'a carrúni jináatanica, wédacanique'u linácu liá'a wawácali Jesúsca: ‘Dios túyerri liá'a yáairri lishínaa'eenau báqueerrirru.’ ” ");
INSERT INTO aca_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Ne liáwinaami limá'inaa léji liáni, Pablo litúyau liúrrui juátayu lisáta Dios liúcha náajchau quinínama. ");
INSERT INTO aca_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Jáiwa'ee quinínama náichai, ya jáiwa'ee nashíquia yáacawai nashíshi'e Pablo wídani nácu. ");
INSERT INTO aca_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Jáiwa'ee máashii nawówai, jiníwata limáca'ee nalí jóca néejoo nacába liyá mawiá. Jáiwa'ee náau liájchai lancha néerrai. ");
INSERT INTO aca_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Liáwinaami wamáaca'inaa náa'a wéenajinaica, jáiwa wáurrucoo lancha rículai machácani Cos néerra, áabai éerri liáwinaami jáiwa wáawai Rodas néerra, ne néenee jáiwa wáau báaniu Pátara néerra. ");
INSERT INTO aca_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Pátara néenee jáiwa wáiinu áabai lancha yáairriu Fenicia néerra, jáiwa wáurrucoo lirrículai. ");
INSERT INTO aca_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Wabésuna'inau wáacoo wacába liwówai jí'ineerri Chipre, wamáaca'inaami béema waná apáulicue sáica, wabésunau machácani Siria néerra. Liá'a lanchaca, arrúnaaca limáaca shínaashi liájba lícu Tiroca, jáiwa warrúniu néeni. ");
INSERT INTO aca_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Jáiwa wáiinu néeni áabibi máaquenai nawówau Dios nácu, jáiwa wamáacau náajchai siete éerri. Espíritu Santo má'ee nalí, jócubeecha Pablo yáau Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Jái'inaa libésunawai siete éerri, jáiwa wajiáwai. Quinínama náiinu ya néenibi yáajchau lécchoo, jáiwa náau wáajchai bináawala chacáalee yúcha, chaléeni cáina ítala, jáiwa watúyawai wasátacoo Dios yúcha. ");
INSERT INTO aca_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Jáiwa wáiiwa wanáwau nalí ya wáurrucoo lancha rículai wáawai néeni, nayá éejoo nábana néerra. ");
INSERT INTO aca_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Jáiwa wanísa washínaa iníjbaawai manuá yáacu yáaineu Tiro néenee, Tolemaida néerra, watáaniactala'inaa náajcha náa'a wéenajinaica, jáiwa wamáacau náajcha áabai éerri. ");
INSERT INTO aca_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Áabai éerri liáwinaami, jáiwa wajiáwai wáiinu Cesarea néerra. Jáiwa wáawai Felipe íibana néerra, liá'a éewiderri Dios chuáni, liyáwa'ee néenaa náa'a siete cayúdacanica apóstolubini, wamáacau liájchai. ");
INSERT INTO aca_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Liá'a Felipeca wáalierri cuatro miyácanai máanirri, íiwadedenai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Íchaba éerri'inaa wayáca néeni, jáiwa báqueerri íinu chésaini Judea íiwadedeerri Dios chuáni jí'ineerri Agabo. ");
INSERT INTO aca_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Líinu'inaa wáiibirrai, jáiwa liwína wálibeshi Pablo shínaa, jáiwa libáji lináu ya jicáaji ya líiba chámajianaa, limá'ee: —Espíritu Santo ma Jerusalén néeni, náa'a judíobinica nabájidaminaa chá'a léquichoo liwácali liéni wálibeshica, ya néejuedaminaajoo nacáaji rícuni náa'a chóniwenai báawatanica. ");
INSERT INTO aca_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Wéemi'inaa léji liéni, wayá ya náa'a Cesarea néenee sánaca, jáiwa wamá Pablorrui jócubeecha liáu Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Ne Pablo éeba'ee nachuáni: —¿Tánda íicha iwánaque'e máashii nuwówa? Nuyá yáairri sáica, jócaita bácai nabáji nuyá, nuyá yáairri sáica máanalique'e nuyá Jerusalén néerra Jesús Nuwácali nácue. ");
INSERT INTO aca_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Jóca'inaa wéenaa wáayabeda liyái, wamáaca liyái, wamá'ee: —Máta Dios méda liájcha léjta liwówau. ");
INSERT INTO aca_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Ne liáwinaami liáni, jáiwa wáchúndadaniwai wáque'iniu Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Jáiwa náau wáajcha náa'a wéenajinaica Cesarea néenee sánaca, jáiwa natée wayái líibana néerra liá'a báqueerri washiálicuerri Chipre sái, jí'ineerri Mnasón, máaquerri'e liwówau báinacu wérri, yáirri'inaa walí cuíta wamáctala'inaa. ");
INSERT INTO aca_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Wáiinu'inaa Jerusalén néerra, náa'a wéenajinaica narríshibia wayá sáictacta nawówa yáajchau. ");
INSERT INTO aca_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Cajójchanaami Pablo yáau wáajcha licába Santiago, néerra nayá léquichoo quinínama náa'a salínaica. ");
INSERT INTO aca_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Pablo tá'ee nalí, jáiwa líiwa nalí quinínama liá'a Dios médani lirrícueji náajcha, náa'a jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Néemi'inaa jíni, jáiwa'ee náa sáicai Diosrui. Namá'ee Pablorru: —Wée, nuéenajirri, náiibi náa'a judíobinica íchaba máaquenai nawówau, quinínama nayá yáaineu namáca rúnaa wamédaque'e Moisés shínaa ley. ");
INSERT INTO aca_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Náiiwani nalí, jiyá éewidenai quinínama náa'a judíobinica náa'a yéenai déecuche áabai cáinabi ítee, jócubeecha naméda Moisés wánacaala, limá'ee nalí jócubeecha iméda iwíchua nachíipi íimanaa dácu, jócubeecha nasíguia liá'a wawíteeca. ");
INSERT INTO aca_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","¿Tána jimá linácucha jiliéni? Ne chóniwenai yáine léenaa jinácu jíinucala'inaa. ");
INSERT INTO aca_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Cájbamiminaa jimédaque'e sáicai chá'a: Áani wáiibi, cuatro washiálicuenai rúnaa namédaca liá'a namáni nácucha íinuerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Jitée jiájcha wáni, jichúni jiwíteu náajcha, jipáida nashínaa arrúnai páida nalí, quéewique'e néewa nabíchu nawíta báinau. Cháwa jáni quinínama nacábaque'inini jócai yáawaiyini liá'a namáni jinácucha, jócai báawacha jiyá éewiderri liá'a ley Moisés máacanica. ");
INSERT INTO aca_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Náa'a wéenajinai jócani judíobini, máaquenai nawówau, wayájani nísa watánacai liá'a waméda'inaaca: jócubeecha íya ínaashi náani lirrú liá'a jóca Dios, ya íirrai léquichoo jócai wéewa wáayaca, ya liá'a ínaashica cuéshinai sácumenaicoo, cáwique'e nacába náuchau naméda máashii náiinaayu. ");
INSERT INTO aca_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Néenee Pablo tée nayái cuatro washiálicuenaica, cajójchanaami, jáiwa'ee lichúni libádeda liwówawau náajchai; jáiwa liwárroo templo rículai líiwaque'e nalí linácu liá'a chacálitashia éerdi néewa naméda liá'a namáni nácucha, liwówai limáca, chacálishi éerri néewa bácainaa natée nashínaa náni'inaa Diosru. ");
INSERT INTO aca_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Jái'inaa nawówai nanísa nayáca siete éerrica, áabi judíobini cáinabi jí'ineerri Asia néenee sána, nacába'ee Pablo templo rícu, jáiwa'ee nacáarralia chóniwenai. Jáiwa'ee náau Pablo júnta, ");
INSERT INTO aca_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","máidadenai náacoo: “¡Israelítabini, iyúda wayá! Liéni washiálicuerrica jínaneerriu quinínama éerri rícu, léewida chóniwenai máashii lijúnta liá'a wíteeshi washínaa chacáaleerru, táanierri máashii linácucha liá'a ley Moisés shínaa, ya linácucha liáni temploca. Áawita mawí, jáiwa'ee liwárrueda áabi griégobini, jóca cawáunta liéni templo santoca.” ");
INSERT INTO aca_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Namá'ee liáni, jiníwata nanísaca'ee nacábate liájcha liá'a Trófimo Éfeso néenee sái, nayá máinai nalíwoo jáica'ee Pablo tée liyái templo rícula. ");
INSERT INTO aca_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Quinínama chóniwenai chacáalee ísanaca íiwirrini wówa, cánaqueneu Pablo néerra. Nawína'ee Pablo'ee, jáiwa'ee nárda bináawala templo yúcha, jáiwa'ee nabáya madéjcanaa templo númai. ");
INSERT INTO aca_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Atéwai náiinuaca, liá'a nawácalica batallón romanoca, léemi'inaa'ee líiwanaa náiiwa lirrú jíni quinínama chóniwenai Jerusalén ísanaca íiwirrini wówa. ");
INSERT INTO aca_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Liá'a wánacaleerri liáawaqueda'ee lishínaa soldádobini ya náa'a áabica licánaca'ee náau chaléeni chóniwenai yáctalaca. Nacába'inaa'ee liá'a wánacaleerri ya náa'a soldádoca, jóca'ee nabáseda Pablo mawiá. ");
INSERT INTO aca_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Néenee'e liá'a wánacaleerrica lirrúniu nalí, liwína preso Pabloi, liwána nabáji Pablo chámai cadénayu. Néenee lisáta léemiu chóniwenai tána washiálicuerriqui jíni ya tána limédai. ");
INSERT INTO aca_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Ne áabi namáidada matuínaami náibeji wáacoo, tándawa linácueji, liá'a wánacaleerrica jócai léewa liá léenaa jíni, bájialacala namáidada matuínaami; tándawa liwána natéequi jíni nayáctalaca. ");
INSERT INTO aca_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Náiinu'inaa ásacaleera númami soldado íibana rícu, jáiwa'ee nanácuda jíni nawárruedaqui'inini, chóniwenai yúcha; ");
INSERT INTO aca_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","jiníwata quinínama máidadenai náacoo líshiirricu “¡máanali jiyá!” ");
INSERT INTO aca_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Jái'inaa natée chaléeni náawacactalacoo soldado íibana néerra, Pablo sáta léemiu liá'a wánacaleerri soldado: —¿Nuéewa nutáania yáajcha íchaitaa rími? Liá'a wánacaleerrica léeba'ee: —¿Jéewa jitáania griégoyu? ");
INSERT INTO aca_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","¿Jócaita jiyá liá'a egipcio méderri máashii báinacumi jijiá'inaamiu áabai cáinabi ítala wáunamactalaca cuatro mil washiálicuenai máashiini wérri yáajcha? ");
INSERT INTO aca_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Pablo má'ee nalí: —Nuyá judío, nuyá Tarso shínaa Cilicia sái, jiáirriu áabai chacáalee máanui wérri; ne nusáta jiúcha sáicai jída nutáania chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Liá'a wánacaleerrica jáiwa línda litáaniacai, Pablo bárrua'eewau á'a ásacaleera númami yáctaca licáajiyu liwána manúma náa'a chóniwenaica. Manúmata'inaa nayácai, jáiwa'ee litáania chuánshi hebreoyui, limá'ee: ");
INSERT INTO aca_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Nuéenajinai ya nusálijinaanai, éemi liéni nuíiwani'inaa irrú nuwícaubaliu, jócaita yáawaiyi liá'a éeminica.” ");
INSERT INTO aca_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Néemi'inaa litáania chuánshi hebreoyu, jáiwa'ee mawí néemi lirrúi. Pablo Mamáarraca'ee litáaniaca: ");
INSERT INTO aca_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Nuyá judío. Nuyá jiáirriu Tarso shínaa Cilicia, ne nuyá dáwinerriu Jerusalén rícu. Nuyá éewiderriu liájcha liá'a Gamaliel, nuyá áabenai wítee náajcha náa'a wawérrinaimica. Ne nuyá séewirri wówai nushírrueda Diosru quinínama nuwówa yáajchau, chaléjta imédanica chóque'e éerri. ");
INSERT INTO aca_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Nuyáte quéecha nucánacaida wérri náa'a chóniwenai wínenai liáni wáalii iníjbaaca, nuwína nayá nuwárruedaque'ini cuíta manúmai rícula, ya washiálicuenai ya íina lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Liá'a nawácali sacerdótebinica ya náa'a salínaica yáine léenaa linácu liáni bésuneerricoo. Nayá tánenai nulí cáashta nuéewaque'e nuwína náa'a wéenajinai judío yéenai Damasco rícu, néerrate nuáu numúrru nayái náa'a éebidenaica Jesús nácu, nuíindaque'e nayá áani Jerusalén rícu cacástigaaque'e nayá. ");
INSERT INTO aca_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Nuá'inau nuáacoo iníjbaa lícu urrúni'inaa nuyá Damascorru, újnita wíyaicumi, nucába áabai cámarrashi quéneerri áacaiji nuyáctaca ya nutéeji, ");
INSERT INTO aca_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","jáiwa nucáu cáinabi rículai. Nuéemi áabai chuánshi mérri nulí: ‘Saulo, Saulo, ¿tánda jicánaqueda nuyá?’ ");
INSERT INTO aca_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nusáta nuéemiu liyá: ‘¿Tána jiyái, nuwácali?’ Liá'a táaneerri liyá nulí limá nulí: ‘Nuyáwa Jesús Nazaret sái, nuyáwa liá'a jicánaquedanica.’ ");
INSERT INTO aca_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Náa'a chóniwenai yáainecoo nuájcha, nacába'ee áabai cámarrashi quéneerri, Jáiwa'ee nacáarrudawai, ne jócai néemi liá'a chuánshi táaneerri liyáca. ");
INSERT INTO aca_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nusátai nuéemiu: ¿Tána nuéewa numédacai nuwácali Jesús? Nuwácali Jesús ma nulí: Jibárroo jiá namówai iníjbaa yáairricoo Damasco néerra. Néerraminaajoo náiiwau jirrújoo liá'a jimédani'inaaca. ");
INSERT INTO aca_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Liá'a cámarrashi máaquerri nuyá matuí, náa'a nujúnicaica natée nucáaji nácu Damasco néerra. ");
INSERT INTO aca_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Néerra báqueerri washiálicuerri jí'ineerri Ananías, sáicai wérri washiálicuerrica máaquerri liwówau Moisés shínaa ley máyu'uca; quinínama náa'a judíobinica yáainai Damasco rícu, natáania'ee linácu sáicai wérri washiálicuerrica. ");
INSERT INTO aca_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Ananías íinu licába nuyá, líinu'inaa limá nulí: ‘Nuéenajirri Saulo, jirríshibia wáalii jituí.’ Liyáalimi nucábai jucámarranaa, nuéewa nucába Ananías. ");
INSERT INTO aca_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Néenee Ananías ma nulí: ‘Wawérrinaibimi shínaa Dios, liwína jiyá jicúnusiaque'inini léjta liwówau'u, jicábaque'e liá'a Jesús machácani wérri, jéemique'e jiwíbayu limáni linúmayu chúnsai Jesúsca. ");
INSERT INTO aca_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Jiyá yáairri'inau jíiwa lichuáni quinínamai chóniwenairru, jíiwaminaa nalíjoni liá'a jicábanica ya liá'a jéeminica. ");
INSERT INTO aca_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ne chóque'e, ujinénda mawiá. Jibárroo, jibáutisau, jimánu lícu Wawácali jí'inaa quéewique'e libádeda jijíconaa. ");
INSERT INTO aca_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Nuéejoo'inau Jerusalén néerra, jáiwa nuáu templo néerra nu'óraca, nucábani nutuírricu. ");
INSERT INTO aca_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nucába Jesús, limá nulí: ‘Madéjcalicunaa, jijiáu Jerusalén rícucha, jiníwata jóca néebida jirrújoni liá'a jíiwani nunácu’. ");
INSERT INTO aca_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Numá lirrú: ‘Nuwácali, nayá yáine léenaa, nuyá yáairriu quinínama sinagoga ya nutée cuíta manúmai rícula náa'a máaquenai nawówau, nabásedaque'e nayá. ");
INSERT INTO aca_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Quéecha'inaa náiinua jishínaa cashírruedacai jirrú Esteban, liyá táanierrimi sáica jinácu, nuyáwa yéerri náajcha néeni, nuyá áabenai wówa náiinuaque'e Esteban, néenee nutúya náabala náa'a íinuenaicani.’ ");
INSERT INTO aca_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Ne nuwácali Jesús ma nulí: ‘Jiáu iníjbaa rícula, nubánuaminaa jiyájoo bájirra cáinabi ítala déecuchala nalí náa'a jócani judíobini.’ ” ");
INSERT INTO aca_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Atanúma ája'arra léemi lirrú jíni; né'e jáiwa namáidada cadánani: “¡Liéni washiálicuerrica jócai sáicanata cáwica! ¡Jimárdani lítacha liáni cáinabica!” ");
INSERT INTO aca_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ya léjta mamáarraca namáidadaca, nacúsuda'ee náabalau, nawína'ee pucúpucubee náuca'ee áacairrani. ");
INSERT INTO aca_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Liá'a wánacaleerrica liwána'ee nawárrueda Pablo soldado íibana rícula, liwána'ee nabásedacani, líiwaque'e nalí ne tándashia chóniwenai máidadai linácuchai. ");
INSERT INTO aca_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Jái'inaa'ee nabájida nayáqui jíni nabásaidaque'inini, Pablo sáta'ee léemiu liá'a wánacaleerrica liá'a yéerri náajcha néeni: —¿Iwáaliaminaa liá'a wánacaalashi, libásedaque'e liá'a báqueerri washiálicuerri chái cábacanaa léjta náa'a romanobinica, ya mawí jóca isátadani éemiu yáawacta cajíconaajani? ");
INSERT INTO aca_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Léemi'inaa liá'a wánacaleerrica, jáiwa'ee liáwai líiwa lirrú liá'a wánacaleerri liúcha mawí, limá'ee: —¿Tána'inaa jimédai? Liáni washiálicuerri chái jicá'a náa'a chóniwenai Roma shínaa cáinabi ítesanaca. ");
INSERT INTO aca_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Néenee liá'a wánacaleerrica lirrúniu Pablorru, lisáta léemiu liyá: —¿Jiyá yáawai Roma shínaa cáinabi ítesai? Pablo éeba'ee: —Jajá. ");
INSERT INTO aca_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Liá'a wánacaleerrica limá'ee: —Nuyá cawéni wérri jiácoo nulí warrúwayu quéewique'e éewa romano sái nuyá. Ya Pablo éeba'ee lichuáni: —Nuyá jiáirriu chái cábacanaa léjta náa'a chóniwenai cáinabi Roma ítesana. ");
INSERT INTO aca_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Ne linácue, náa'a wówenaica nabáseda Pablo, jáiwa náawai; liá'a wánacaleerrica, liá'inaa léenaa linácu romano néenee sáicalani, jáiwa'ee cáarru liyái liwánaca nabájida Pablo. ");
INSERT INTO aca_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Cajójchanaami, liá'a chúnsai wánacaalaca, wówairri liá léenaa sáica tándashia náa'a judíobini náa Pablo jíconaa, jáiwa liwáseda liúcha cadena licáaji nácuchai, jáiwa'ee liwána náawacacoo náa'a wánacaleenaica sacerdótebini, ya quinínama néenaa wánacaleenaica jí'ineenai Júnta Suprema. Jáiwa najéda Pablo limáaca nanáneewa jíni. ");
INSERT INTO aca_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Pablo cába nalí náa'a wánacaleenaica limá'ee nalí: —Nuéenajinai, nuyá yáairri sáica machúnuca nuwítee chóque'e Dios náneewa. ");
INSERT INTO aca_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Néenee liá'a Ananíasca, nawácali sacerdótebinica, libánua'ee náa'a yéenai urrúni Pablorru nabásaque'e linúma. ");
INSERT INTO aca_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Ne Pablo éeba'ee lirrú: —¡Dios básairri'inaa jiyájoo, chámaini wítee! Jiyá wáairricoo árra, jiáque'e nujíconaa léjta limáyu liá'a ley, ¿tánda jiwána nabáseda nuyá, jócai ley bánua imédaca? ");
INSERT INTO aca_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Náa'a yéenai néeni namá lirrú: —¿Chá'a máashii jinúma lirrú, liá'a sacerdote wácali Dios shínaaca? ");
INSERT INTO aca_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Pablo má'ee nalí: —Nuéenajinai, nuyá jócai yáa léenaa liyáshia wánacaleerri sacerdótebini; ne limá liá'a Dios chuánica limá: ‘umáashii jinúma linácucha liá'a wánacaleerri jishínaa chacáalee’. ");
INSERT INTO aca_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Ne, liá'a'inaa léenaa náa'a áabi néenaa náa'a wánacaleenaica náa'a saduceobinica, áabi mawí néenaa náa'a fariséobinica, Pablo má'ee máanui chuánshiyu: —Nuéenajinai, nuyá fariseo, wéenajinai fariséobini shínaa; iyá múrruenai nujíconaa médacta máashii nuéebida linácu liá'a nacáwiactacoo náa'a máanalinimica. ");
INSERT INTO aca_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Néenee Pablo má'inaami léji liéni, náa'a fariseo ya saduceo nachánau najútacoo nalíwaacoo, jáiwa nashírrida náucha wáacuwai. ");
INSERT INTO aca_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Jiníwata náa'a saduceo máinai jócala máanalini éejoo nacáwiacoo, jinícala'ee ángelbini ya wówanaashi; ne náa'a fariséobinica éebidenai quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Quinínama namáidadaca; ya áabi quéewidacani ley shínaabinica, néenaa náa'a fariséobinica, nabárruau namá'ee: —Liáni washiálicuerrica jiní médani máashiica, cájbami báqueerri wówanaashimi jócta báqueerri ángel táania lirrú. ");
INSERT INTO aca_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Ne nacáarraliacalau mamáarraca, liá'a wánacaleerrica cáarru liyá, carrúnataca nasúberreda Pablo, jáiwa libánua namáida lishínaa soldado quéewique'e lijéda néeneeni ya liwárrueda soldado íibana rículani. ");
INSERT INTO aca_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Áabai táayebee rícula, liá'a Wawácali líyadau Pablorru limá'ee: “Cadánani, Pablo, léjta jitáaniau'u nunácu áani Jerusalén rícu, chacábacanaa arrúnaa jitáania Romala.” ");
INSERT INTO aca_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Áabai éerri ricúla, áabi judíobini nachánau áabenaa nawítee quéewique'e náiinua Pablo, jáiwa najúrau máashii máashiinaa wérri jócu náaya, jiní náiirraca shiátai cáashia náiinuacani. ");
INSERT INTO aca_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Namánabaca cuarenta washiálicuenai náa'a máaquenaicoo naméda chái jiliéni. ");
INSERT INTO aca_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Jáiwa náau nayáctala náa'a nawácanai náa'a sacerdótebinica ya náa'a salínai judíobinica, namá'ee nalí: —Wayá júrenai máashiinaa jócubeecha wáaya nácula wáiinua Pablo. ");
INSERT INTO aca_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Chóca já'a, iyá ya náa'a áabi ijúninai, isátau liúcha liá'a wánacaleerrica soldado, quéewique'e náinda cajójchani ináneewa, iwówai yútaa yáque'e léenaa linácu arrájuata; ya wayáminaajoo nénda wayácojoni quéewique'e wáiinuacani jóctanaa linísau irrú. ");
INSERT INTO aca_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Ne Pablo éenajetoo cúulee, jáiwa liá léenaa linácu jiliáni, jáiwa liáu soldado íibana néerrai líiwa Pablorru. ");
INSERT INTO aca_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Jáiwa Pablo máida báqueerri néenaa wánacaleenaica, limáa'ee lirrú: —Jitée liéni samálitaca lirrú liá'a wánacaleerri soldado, jiníwata wáalierri chuánshi líiwani'inaa lirrú. ");
INSERT INTO aca_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Liá'a wánacaleerri litée samálitamica lirrú liá'a wánacaleerri soldado, limá'ee lirrú: —Liá'a preso Pabloca limáida nulí quéewique'e nuínda jirrú liáni samálitaca wáalierri áabai chuánshi jirrú. ");
INSERT INTO aca_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Liá'a wánacaleerri soldado liwína samálita licáaji nácu litée báawachalani lisáta léemiu wáni: —¿Tána jiwówai jíiwa nulí? ");
INSERT INTO aca_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Samálita má'ee lirrú: —Náa'a judíobinica áabenaani wówa quéewique'e nasáta jiúcha cajójcha jitéeque'e Pablo nalí náa'a wánacaleenai nanácu, nawówai yútaaque'e náa léenaa linácu mawí. ");
INSERT INTO aca_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Ne jócu jéebida nalí jóni, jiníwata mawí cuarenta washiálicuenai néndenai nayá liájaba cabáyainta, jiníwata júrenaiu máashiinaa jócu náaya, jiní náiirraca shiátai cáashia náiinua'ee Pablo; chóca já'a néndenai nayá jichuáni tánashia jimá nalí. ");
INSERT INTO aca_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Néenee liá'a wánacaleerrica soldado, libánua samálitami limá lirrú jócu béecha líiwadeda liá'a líiwani lirrú. ");
INSERT INTO aca_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Liá'a wánacaleerri soldado limáida chámata wánacaleenai liájabata, libánua nachúndadanica doscientos soldado náiibayu sána, ya setenta éema íta'aa, ya doscientos cuélaleyu sána, quéewique'e náacoo liá'a chacáalee jí'ineerri Cesarea las nueve táayebeeca. ");
INSERT INTO aca_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ya mawí liwána nachúni éema Pablo yáni'inau íta'aa ya liwána natée sáicani cáwi lirrú liá'a wánacaleerrica jí'ineerri Félix. ");
INSERT INTO aca_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Náajcha libánua áabai cáahsta máirri liliácoo: ");
INSERT INTO aca_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Nuyá Claudio Lisias, nutána jirrú nuédacanica jinácu jiyá chóniwerri cawénica Félix cawánacaalacai: Nutáa jirrú: ");
INSERT INTO aca_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Náa'a judíobinica nawína preso liáni washiálicuerrica quéewiquinicta náiinuacani, ne quéecha'inaami nuá léenaami chái cábacanaa léjta náa'a chóniwenai cáinabi Roma ítesana, jáiwa nuáu nushínaa soldado yáajchawai, jáiwa nuéda náucha jíni. ");
INSERT INTO aca_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Ne nuwówaicala nuá léenaani tánashia nácueji náa lijíconaa, jáiwa nutée liyái nanáneewa náa'a judíobini wácanai. ");
INSERT INTO aca_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Cha nuá léenaa náani nayá jíconaa linácueji liá'a ley nashínaaca; ne jócai cajíconaa náiinua'inaacani, jiní sáicanata liyá cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Ne nuáca léenaa náa'a judíobini nawówai náiinaucani, liárra nubánua jirrú; ne nusáta náucha náa'a yáinai lijíconaa, quéewique'e namá jináneewa liá'a arrúnai'inaa namáni'inaaca”. ");
INSERT INTO aca_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Náa'a soldado, léjta nawácali bánua nayá, nawína Pablomi, jáiwa natée táayee jíni áabai chacáalee jí'ineerri Antípatris rícula. ");
INSERT INTO aca_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Áabai éerri rícula náa'a soldado yáainemicoo náiibayu néejoo nárrui licúla báaniu, ne náa'a éema ítasanaca náau Pablo yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Ne náiinu'inaami Cesareala, jáiwa néejueda lirrú cáashta lirrú liá'a wánacaleerri néeni ya néejueda lirrú lécchoo Pablomi. ");
INSERT INTO aca_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Liáwinaami liliá cáashtaca liá'a wánacaleerri néeni, lisáta léemiu Pablo chítashia sái jiníni; ne liá'inaami léenaa Cilicia sáicani, ");
INSERT INTO aca_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","limá'ee Pablorru: —Nuéemiminaajoo jichuáni cáashia náiinu náa'a yáinai jíconaa. Néenee liwánacaala nácu liwána natúya lirrícuni liá'a Herodes íibana wérri rícu, jócubeecha limániu. ");
INSERT INTO aca_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Cinco éerri liáwinaami, Ananías sacerdótebini wácalica, líinu Cesareala áabi salínai yáajcha ya báqueerri catáaniacai sáica, quéewique'e liá Pablo jíconaa, jí'ineerri Tértulo. Náiinu náyadacoo Félix cawánacaalacai náneewa, quéewique'e náa Pablo jíconaa. ");
INSERT INTO aca_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Quéecha'inaami náinda Pablo, Tértulo chánau liá lijíconaa, limá Félixru: —Sáicai wérri jiwítee, jiyá wánacaleerrica, wayá sáicta wawówa, ya jiwítee rícueji jiméda sáicai wérri washínaa cáinabirru. ");
INSERT INTO aca_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Liáni warríshibiani wawówa yáajchau séewirrinaa ya quinínama wayáctaca, jiyá cawítee Félixca, sáicai wérri wáa jirrú. ");
INSERT INTO aca_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ne quéewique'e jócu nuéda jiúcha bájiala éerri, nusáta jiúcha nuwówa yáajchau jéemique'e walí íchaitaa. ");
INSERT INTO aca_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Wáiinu linácu liáni washiálicuerri carrúnataica, quinínama cáinabi íta'aa jínaneerriu léewida liwána máashii nacába yáacacoo náa'a judíobinica, léewa'ee nawíta náa'a éewiderri áabai wíteeshi jí'ineenai nazarenos. ");
INSERT INTO aca_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","7","Ya jiní wéni licába lirrúwoo liá'a Dios íibanaca, tándawa linácueji wawína natée cuíta manúmai rícula jíni. Ne wawówaini wáa léenaa quinínama liá'a limédanica, quéewique'e wacástigaacani léjta washínaa ley; ne liá'a wánacaleerrica jí'ineerri Lisias, jáiwa léeda wáucha danáanshiyu jíni; ne limá'ee náa'a yáine nayá lijíconaa arrúnaa náacoo náayadacoo jiyáctala. ");
INSERT INTO aca_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Jiyá éewa jisáta jéemiu jáni, tánashia nácue yáawaa wáa lijíconaa. ");
INSERT INTO aca_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Náa'a judíobinica yáaine néeni chacábacanaa namá lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Liá'a Félix wánacaleerrica limá'ee licáajiyu Pablorru litáaniaque'e, jáiwa'ee Pablo má'ee: —Sáicta nuwówa nutáania nuwícaubaliu irrú, nuácala léenaa jiyá yáirri léenaa jéemica sáicactani o máashiiquictani; jiyá wánacaleerri líta'aa liáni cáinabica báinacu wérri. ");
INSERT INTO aca_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Léjta jiyá jájiu éewerri jisátada jéemiu, walícanama doce éerri néenee nuíinu Jerusalén néeni, quéewique'e nuá sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Jiní náiinucta nunácu nucáita yáacacoo áabi yáajcha, jiní nucáarraliaca numácoo chóniwenai Dios íibana rícucha, jiní sinagoga rícuba, jiní báawachala chacáalee yúcha. ");
INSERT INTO aca_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Náani chóniwenai jócani éewa náyada yáawaaca cajíconaa nuyá. ");
INSERT INTO aca_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Ne ta liyá nuíiwani nusírbia Diosru léjta nuwérrinaibimi, áabenaa liájcha liá'a wáalii iníjbaaca liá'a namáni linácucha jáicala nuéewidacala jócai yáawai, jiníwata nuéebidacala liá'a ley tánerricoo cáahsta ley íta'aa, léjta namáyu'u náa'a éewidenai Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Ya nuwáalia, chaléjta nayá, nuéebida Dios nácu nacáwia'inaacalau náa'a máanalinimica, léjta náa'a sáicanica ya náa'a máashiinica. ");
INSERT INTO aca_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Tándawa linácueji séewirrinaa nuéneda nuyá masácula nuwítee Dios náneewa ya washiálicuenai náneewa. ");
INSERT INTO aca_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Liáwinaami nujínanicoo íchaba camuí matuínaami cáinabi íta'aa, nuéejoo nushínaa cáinabi ítala, quéewique'e nuá warrúwa nalí náa'a carrúni jináatanica ya nuá ofrendaca. ");
INSERT INTO aca_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","Numédacta nuyá liáni, liáwinaami nuchúni nubádeda nuyáu léjta wawítee médau'u séewirrini, áawita áulaba chóniwenai yáajcha, jiní wíta cáitadedeerri nuyá, quéecha'inaami áabi judíobini chésanani Asia náiinu nunácu templo rícu. Nayáwa éewenai náiinu áani náyadacoo náaque'e nujíconaa, yáawacta nawáalia nunácula jíconaashi. ");
INSERT INTO aca_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Ne jócta, náani yáaine áani namáque'e yáawacta náiinu nujíconaa quéecha'inaami nuyá nanáneewa náa'a wánacaleenai judío. ");
INSERT INTO aca_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ne jócuminaa nuyá'inaami náiibi numá cadánani chuánshiyu: ‘Wáalee yáa iyá nujíconaa nuéebidacala nacáwia'inaacoo náa'a máanalinimica.’ ");
INSERT INTO aca_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Félix éemi'inaami liéni, liáca léenaa linácu liá'a wáalii iníjbaaca, limáaca léji liéni léejo'inaacoo litáania linácu báaniu, limá'ee nalí: —Jáicta líinu léju liá'a Lisias wánacaleerri soldado, líiwaminaa nulí sáica léju liá'a ichuánica. ");
INSERT INTO aca_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Félix bánua liá'a wánacaleerri liájbata quéewique'e nawáalia cuíta manúmai rícula Pablo újnibi, ne quéewique'e línda máayaba nacábacani náa'a lijúninaica nashírruedaque'e lirrú. ");
INSERT INTO aca_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Liáwinaami áabata éerri rícula léejoo báaniu néerra liá'a Félixca, ruájcha ruá'a líinu Drusila, judíobini éenaa. Félix bánua namáida Pablo, léemiu Pablo chuáni linácue sái liá'a léebidau'u Jesucristo nácu. ");
INSERT INTO aca_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Ne Pablo táania'inaami linácu liá'a cáwicaishi machácanica, ya wéewau'inaa wawánacaalacoo wayá jájiu, ya carrúnatabee íinuerri'inaaca, Félix cáarrudau léemicani, limá'ee lirrú: —Cái jiá namówai. Nuéejoominau numáida jiyájoo jáicta nuwáalia éerrijoo. ");
INSERT INTO aca_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Ne limédacalau, Félix néndacta Pablo yáa lirrú warrúwa, quéewiquinicta liwásedacani; tándawa íchabachu limáida áji éerri náani litáaniaque'e liájcha. ");
INSERT INTO aca_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Cháji'i chámai camuí bésunacuwai; néenee jócu Félix wánacaala mawiá, ne liárrumirra báqueerri wárroo jí'ineerri Porcio Festo. Ne Félix wówaica sáica limáacacoo judíobini yáajcha, limáaca preso Pablo. ");
INSERT INTO aca_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Festo íinu quéewique'e liwína yáarruishi liwánacaalacta'inaaca, matáli éerri yáawinaami lijiáu Cesarea néenee Jerusalén néerra. ");
INSERT INTO aca_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Néerra sacerdótebini wácanaica ya náa'a judíobini cawénini mawí náiiwa lirrú Pablo jíconaa nácue sái. ");
INSERT INTO aca_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","Nasáta liúcha cáiwinaa, quéewiquinicta libánua Pablo Jerusalénra. Nawówa licuéjiu quéewiquinicta náiinua iníjbaa licué jíni. ");
INSERT INTO aca_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Ne Festo éeba'ee nachuáni Pabloca yáairri cuíta manúmai rícula Cesarea néerra, ne liyá jájiu éejuerri'inau áulaba éerri ricúla. ");
INSERT INTO aca_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Limá nalí: —Tándawa, náa'a iwácanaica, éewenai náacoo nuájcha Cesareala, ne liárra washiálicuerrica yáawacta ái limédau lijíconau, já'a néeniminaa éewa yáa lijíconaa. ");
INSERT INTO aca_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Festo máacau Jerusalén néerra újni ocho o diez éerri mawí, néenee léejoo Cesareala. Áabai éerri ricúla liwáau liárrubai íta'aa liwánacaalacta'inaaca, jáiwa liwána náinda lirrú Pablo. ");
INSERT INTO aca_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Quéecha'inaami Pablo wárruacoo, náa'a judíobini íinuenai Jerusalén néenee narrúniu nawárruacoo, náa lijíconaa cáiwinaa, áawita jócu néewa náa léenaa yáawaitani. ");
INSERT INTO aca_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Pablo, liyája, táania liwícaubaliu: —Nuyá jócai méda nujíconau, jiní linácula liá'a ley judíobini shínaaca, jiní templo nácula lécchoo, jiní linácula liá'a wánacaleerri Roma. ");
INSERT INTO aca_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Ne Festo wówaica sáica limáacacoo judíobini yáajcha, lisáta léemiu Pablo: —¿Jiwówai jiácoo Jerusalénra quéewique'e néerra nucába tánashia jijíconaa? ");
INSERT INTO aca_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Pablo éeba'ee: —Nuyá yáairri lináneewa liá'a wánacaleerri Roma, néeniwa néewa náa nujíconaa. Léjta jéewau'u jiá léenaani, jiní máashii numédani nanácula náa'a judíobinica. ");
INSERT INTO aca_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Ne yáawacta ái nujíconaa cáiwiica já'a sáicanatai náiinua nuyá nácueji, jócu cáarru máanali nuyá; ne jinícta yáawaiyii liá'a náayu'u nujíconaa, jiní yáirri léejueda nuyá nalí. Nusáta quéewique'e liyá yáa nujíconaa léja liá'a wánacaleerri quinínama cáinabi Roma shínaaca. ");
INSERT INTO aca_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Néenee Festo sáta léemiu náa'a yáainai'inaa liwítee, néenee limá'ee: —Ne jáicala jisáta liáque'e jíconaa liá'a wánacaleerri quinínama cáinabi Roma shínaa, néerraminaa jiáu lirrújoo. ");
INSERT INTO aca_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Liáwinaami áabi éerri bésunau, liá'a rey Agripa ya Berenice náau Cesareala nacába Festo néerra. ");
INSERT INTO aca_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Ne nayácala néerra íchaba éerri, Festo líiwa linácu liá'a reyca, linácue sái liá'a Pabloca. Limá'ee lirrú: —Ái báqueerri washiálicuerri ája áani Félix máacanitee cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Quéecha'inaamite numáacoo Jerusalénra, náa'a sacerdótebini wácanaica ya náa'a salínai judíobinica, náyada nulí áabai jíconaashi linácula, nasáta núcha quéewique'e náiinuacani. ");
INSERT INTO aca_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Nuyá nuéeba nachuáni náa'a wánacaleenai Roma rícu, jócani ísadau náiinua cháji'i cáashia najéda nanániu áani náa'a yáine lijíconaa, quéewique'e léewa litáania liwícaubaliu. ");
INSERT INTO aca_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Tándawa, náiinu'inaami áani, jócu núcha éerri, jáiwa cajójchanaami nuwáau nuárrubai íta'au nuwánacaalacta'inaaca, jáiwa nuwána náinda léji liá'a washiálicuerrica. ");
INSERT INTO aca_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Ne náa'a íinuenai náa lijíconaa, jócu natáania máashii wérri linácula, léjta jíconaashi máanui léjta numáyu'u nulíwau. ");
INSERT INTO aca_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Liyárrimi namáni linácucha liá'a léjta nawítee éebidau, ne ya báqueerri cáiwanai jí'ineerri Jesús máanalimi, ne Pablo máirri cáwicalani. ");
INSERT INTO aca_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Ne jócala nuá léenaa numéda linácueji liéni, nusáta nuéemiu Pablo liwówaicta liácoo Jerusalénra quéewique'e náiiwa lijíconaa méenaami. ");
INSERT INTO aca_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Ne liyá sáteerri quéewique'e liyá yáa lijíconaa liyá máanui wánacaalaca, tándawa linácue nuwána nawáalia preso cáashia nuéewa nubánua lirrúni. ");
INSERT INTO aca_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Néenee Agripa ma lirrú liá'a Festoca: —Nuyá wówerricta nuéemi lichuáni liérra washiálicuerri lécchoo. Néenee Festo éeba'ee lichuáni: —Cajójchaminaa jéemi lichuánijoo. ");
INSERT INTO aca_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Áabai éerri ricúla, Agripa ya Berenice íinu nawárroo cacábacanani wérri líibana ricúla liá'a wánacaleerrica, náajcha náa'a soldado wácanaica ya náa'a wánacaleenai chacáalee rícu. Festo bánua natéeque'e lirrú Pablo, ");
INSERT INTO aca_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Festo limá'ee: —Rey Agripa ya iyá wánacaleenai yáawaquenai wáajcha áani: liérra iwáalia árra washiálicuerrica. Quinínama judíobini yáa nulí lijíconaa, léjta Jerusalén néenee, ya chacábacanaa áani Cesarea rícu, jócu íyabau imáidada nulí quéewique'e máanalicani. ");
INSERT INTO aca_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Ne nulí jiní médacta lijíconau cáiwii quéewique'e máanalicani. Ne liyá jájiu, sáta núcha quéewique'e liyá yáa lijíconaa liá'a máanui liyá wánacaleerrica, jái nuwówai nubánua lirrú jíni Romala. ");
INSERT INTO aca_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Ne jinícala nuá léenaa yáawaiyii nutána jirrú lijíconaa nácue sái, liyá máanui wánacaleerrica linácue sái, nuínda ináneewani, ya jináneewa jiyá, rey Agrípaca, jáicta quéewique'e jisátada éemi wáni nuwáalia chuánshi nutánani'inaa lirrú, liá'a máanui wánacaleerri quinínama Roma. ");
INSERT INTO aca_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Ne nucába jócu sáicta nubánua lirrú preso, jócai náiiwa tánashia lijíconaa. ");
INSERT INTO aca_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Néenee Agripa ma Pablorru: —Jéewa jitáania jiwícaubaliu. Pablo nácuda lináu, jáiwa lichánau litáania chá'a: ");
INSERT INTO aca_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","Sáicta nuwówa nuéewacala nutáania wáalee jináneewa jiyá cawéni wánacaalaca, oh jiyá rey Agripa, quéewique'e nutáania nuwícaubaliu linácueji liá'a nujíconaa náani núta'a judíobinica. ");
INSERT INTO aca_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Jiníwata jiyá máanui wánacaalaca, yáirri léenaa jicába nawítee quinínama náa'a judíoca ya léewa wacáita yáacaniu nácueji. Tándawa nusáta jiúcha quéewique'e jéemi nulí arrájuata jiwówa yáajchau. ");
INSERT INTO aca_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Quinínama judíobini yáine léenaa chítashia nucáwicami jíni náiibi, nucáinabi íta'aa ya Jerusalén rícue, icúlirrijui'inaate nuyái. ");
INSERT INTO aca_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Chái náa léenaa, néewani náiiwaca nawówaicta náiiwadedacai, nuyá séewirrinaa fariséoca, léewa máanabacashi mawíyii machácani wéebidani nácu. ");
INSERT INTO aca_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Ne chóque'e náa nujíconaa nuéebidacala liá'a Dios mánimi wawérrinaimirru. ");
INSERT INTO aca_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Washínaa doce tribu Israel shínaaca, nanénda licúmpliacoo liá'a limáni liá walí, tándawa náa sáicai Diosru nashírrueda lirrú éerrinacu ya táayee. Linácue liéni wanéndani wayáca, oh rey Agripa, náa'a judíobini náa nujíconaa chóque'e. ");
INSERT INTO aca_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","¿Ne tánda jócu éebida Dios éenaaca licáwedaca náa'a máanalinimica? ");
INSERT INTO aca_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Nuyá jájiu numáte nulíwoo quéecha nuéebacta'ee numéda íchaba méenaami lijúnta liá'a Jesús jí'inaaca Nazaret néenee sáica, ");
INSERT INTO aca_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","ne cháwa numéda Jerusalén néeni jíni. Nawánacaala nácu náa'a sacerdótebini wácanaica, nawárrueda íchaba cuíta manúmai rícula, náa'a éebidenai Jesús nácu; jáicta náiinua nayái, nuyá áabenai wówa náajcha. ");
INSERT INTO aca_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Íchabachu numéda nalí máashii quéewiquinicta nuwána namáaca néebidauca. Liéni numédani quinínama sinagoga rícu, áawita nuyá camáashiicai wérri náajcha nucánacaida nayá áabata chacáalee rícula báawachala. ");
INSERT INTO aca_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","“Linácue jiliérra nuáteu nuáacoo chacáalee jí'ineerri Damasco rícula, nawánacaala nácu nuáu náa'a sacerdótebini wácanaica. ");
INSERT INTO aca_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","Ne iníjbaa lícu, oh rey, nucába wíyaicumi áabai jucámarrabee éerri rícueji, mawí cadánani cáiwia cámarra yúcha, liquéna nutéeji náajcha náa'a yáainecoo nuájcha. ");
INSERT INTO aca_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","Quinínama wacáu cáinabi ricúla, jáiwa nuéemi áabai chuánshi mérri nulí hebreoyu: ‘Saulo, Saulo, ¿tánda jicánaqueda nuyá? Jiyá jájiu máashii jiméda jirrúwoo, jicá'a liá'a jidúrruchucoo jicúshtau.’ ");
INSERT INTO aca_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","Néenee numái: ‘¿Tána jiyái, nuwácali?’ Jáiwa Wawácali éeba nuchuáni: ‘Nuyáwa Jesús, léja liá'a jicánaquedani jimáacoo. ");
INSERT INTO aca_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Ne jibárroo, jíiba íta'au, ne jiníwata núyadau jirrú quéewique'e shírrueda nulí ya jíiwaque'e quinínama liá'a jicábani wáalee, ya liá'a jicábani'inaa nuájcha mawí. ");
INSERT INTO aca_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Nujéda'a jiyá náucha náa'a judíobinica, ya náucha náa'a jócani judíobini, chóque'e nubánua jiyá nalí. ");
INSERT INTO aca_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Nubánua jiyá nalí quéewique'e jiméecu natuí, jócubeecha najínaniu catácta, quéewique'e najínanicoo jucámarrabee rícu, jócubeecha náinda Wawásimi wánacaala nayá mawiá, quéewique'e náaque'iu Diosru; ya néebidaque'e nunácu ya nawínaque'e liá'a numéetuau'u najíconaa, ya áabai sáicabee náiibi náa'a chóniwenai majíconaanica Dios shínaaca.’ ");
INSERT INTO aca_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“Cháwa jíni, oh rey Agripa, jáiwa nuéebida linácu liá'a nucábani áacaiji, ");
INSERT INTO aca_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","quéechanacu nuíiwa nalí chuánshi náa'a yéenai Damasco rícu, liáwinaami nalína náa'a Jerusalén rícu sánaca, ya quinínama cáinabi Judea shínaaca, ya nalí lécchoo náa'a jócani judío, numáida néejoocoo, néejueda nayáu Diosru, ya namédaque'e liá'a sáicaica íyadenai nayá yáawaaca néejueda nayáu. ");
INSERT INTO aca_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","Linácueji liáni nawína nuyá templo rícu náa'a judíobinica, nawówai náiinua nuyá. ");
INSERT INTO aca_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","Ne Dios yúdacala nuyá numédau cabálininaa újnibi wáalee, nutáania Dios nácu quinínamarru, júbinica ya máanui namánirru. Jócu náiiwa báawachala náucha náa'a táanianaimi Dios wítee rícueji, Moisésca arrúnai'inaa bésunacoo; ");
INSERT INTO aca_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","liá'a Dios wínanica arrúnaacala máanalicani, ne liáwinaami máanalicani lé'e nawáa quéechanacu sái cáwiacoo liérra, ne líiwaminaajoni nawásedacoo jucámarranaa, léjta washínaa chóniwenairru ya áabata cáinabi ítesana.” ");
INSERT INTO aca_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","Linísa'inaami litáania linácu liáni Pabloca, Festo máidada cadánani: —¡Báawa jiwítee, Pablo! Bájialacala jéewidacoo jináwau jiyáca báawa jiwítee. ");
INSERT INTO aca_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","Ne Pablo éeba'ee: —Nuyá jócai báawa wítee, jiyá cawénica Festo; jócai cha léjta jimáyu'u, liá'a numánica cawíteeyui numáca yáawaiyiica. ");
INSERT INTO aca_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","Liérra yáa árra rey Agrípaca, yáirri léenaa sáica quinínama liáni, tándawa nutáania chawítemija'a lináneewa; náucala léenaa yáawaa liá léenaa quinínama linácu liáni, jiníwata jócala watáania wayá cabáyainta liúcha liáni. ");
INSERT INTO aca_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","¿Jéebida jiyá máanui wánacaleerri, namánimi náa'a éewidenaimi Dios chuáni báinacu? Nuáni léenaa jéebidaca. ");
INSERT INTO aca_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","Agripa éeba'ee lichuáni Pablorru: —Atéwata jiwána nunáawacoo cristiánoyui. ");
INSERT INTO aca_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","Pablo má'ee: —Áawita atéwa áulabacani ya manuába, Dios wówaicta, jócai jiyá bácai máanuica wánacaalaca, áawita quinínama náa'a éemenai nayá nulí wáalee, néenaaquinicta namédacoo léjta nuyá, áawita jócu liájcha liáni cadena nubájica. ");
INSERT INTO aca_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","Néenee libárroo liá'a reyca, ya lécchoo liá'a wánacaleerri liájbata, ruájcha ruá'a Bereníseca ya quinínama náa'a wáainecoo nayá náajcha, ");
INSERT INTO aca_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","ya ta náacoo báawachalai natáania linácu liáni. Namá'ee nalí wáacoo: —Liáni washiálicuerri jiní médani máashiica éewaque'e máanalicani; jócaita sáicanata nabáya cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","Agripa má'ee Festorru: —Sáica natái iwáseda liáni washiálicuerri, jóctata liyá jájiu sáta quéewique'e liyá yáa lijíconaa liá'a máanui wánacaleerri Roma. ");
INSERT INTO aca_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","Quéecha'inaami namácacoo nabánua wayá Italiala, Pablo ya áabi presobini, jáiwa'ee néejueda jíni báqueerrirru wánacaleerri jí'ineerri Julio, néenaa náa'a soldado yáarruica jí'ineerri Emperador shínaa. ");
INSERT INTO aca_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","Wáurrucoo lancha rícula, áabai lancha chánactacoo jí'ineerri Adramitio jái jiácoo liyácai íyaberri'inau liácoo chaléeni áabi lancha chánactacoo liá'a cáinabi jí'ineerri Asia. Yáairri wáajcha lécchoo báqueerri jí'ineerri Aristarco, che sáini Tesalónica néenee sái, áabai chacáalee yáairri Macedonia shínaa cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","Cajójchanaami wáiinu áabai chánactacoo lijí'inacta Sidón, néenee Julio sáica limédacoo Pablo yáajcha, línda Pablo yáacoo licába náa'a lijúnicai quéewique'e nashírrueda lirrú. ");
INSERT INTO aca_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","Wajiáu Sidón néenee, jáiwa wanáwau liwójuna íteeji liá'a liwówaica jí'ineerri Chipre, jiníwata liá'a cáulica cánaquerriu wajúnta. ");
INSERT INTO aca_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","Wachuáu manuá lirrícu lijúntamirra liá'a litácoowa jí'ineerri Cilicia ya Panfilia, ya ta wáiinu chalée jíni Mirala, áabai chacáalee Licia shínaa. ");
INSERT INTO aca_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","Liá'a wánacaleerri soldado líinu áabai lancha mawíyii máanuica nácu che sáini Alejandría sái, yáairri'eewoo liyáca Italiala, jáiwa liwána wáurrococoo wawína washínaa iníjbau úniacu. ");
INSERT INTO aca_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","Íchaba éerri wáau arrájuata, ya carrúni jináatayu wáiinu lijúntamirra liá'a jí'ineerri Cnido. Ne áicala újnibii cáuli cánacau wajúnta já'a, wabésunau lijúntami liá'a jí'ineerri Salmón, warríjcocoo liwówai íteeji liá'a Crétaca; ");
INSERT INTO aca_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","wachuáu carrúni jináatayu litácoowala, wáiinu áabai yáarruishi jí'ineerri Buenos Puertos, urrúni lirrú liá'a chacáalee jí'ineerri Lasea. ");
INSERT INTO aca_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","Jái wáuca íchaba éerri, jái carrúnata wamáacacoo manuá yáacoo, jiníwata jái urrúni wárruacoo liá'a uniábica. Linácueji Pablo yáa nawítee: ");
INSERT INTO aca_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","—Washiálicuenai wánacaleenai, nucába liáni wáctacoo carrúnatai wérri'inaa, ya wáucaminaajoo liá'a lanchaca ya liá'a quinínama watéeni lirrícu, ya carrúnata wáuca wacáwicau. ");
INSERT INTO aca_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","Ne liá'a soldado wácalica, léewida lirrú mawí liá'a lancha wácalica ya liá'a wánacaleerri litée lancha, Pablo yúcha mawí. ");
INSERT INTO aca_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","Ne jócala sáica liá'a nachánactacoo nabésunedau'inaa uniábi néeni, jáiwa quinínama namá'ee nalíwoo sáicanata najiácoo néenee, néenedaquinicta náiinu Fenice néerra, áabai náiinucta nachánacoo Creta shínaa yáairri lijúntami liá'a cáiwia wárruactalacoo ya léemalawoo báchairra, ya néeni wawówaicta wabésuneda uniábi. ");
INSERT INTO aca_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","Namá nalíwoo najínacoo báaniu machúnuca lijiáu áabai cáuli arrájuata chéni sur néenee, najiá'eewoo nachuáu litácoowa liá'a liwówai jí'ineerri Creta. ");
INSERT INTO aca_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","Ne arrájuata rími liáwinaami áabai cáuli wérri íinuerri léemamiyu, báseerri cadánani lancha nácula, ");
INSERT INTO aca_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","jáiwa lichánau liwátanedaqui jíni. Jócu wéenaa wamáchiquinia cáuli júnta liá'a lanchaca, arrúnaa wáida litée wayái. ");
INSERT INTO aca_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","Wabésuna'inau liwójuna ítee áabai liwówai píitui rími jí'ineerri Cauda, jiníwata liá'a cáuli jócai énajta bása néenee cadánani, ya jócai súti tráawajo wéenaque'e wáawaqueda liá'a íida éenibi natéenica. ");
INSERT INTO aca_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","Néenee náirda'inaa lirrícula, narrúnaa nabájiqui jíni jócubeecha liájoo dujíwala liá'a lanchaca. Néenee'e cáarru náiinu lítala liá'a cáina jí'ineerri sirte, náaca'ee léenaa limíicheda nayá, náinda'ee cáuli tée nayá. ");
INSERT INTO aca_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","Cajójchanaami, liá'a cáuli wérri ái újni cadánani já'a, cháwa'ee nachánaa náuca manuá yáacula liá'a shínaashi natéeni lancha rícu. ");
INSERT INTO aca_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","Matáli éerri ricúla'inaami, náuca nacáajiyu quinínama yáairri lancha rícu sáica ");
INSERT INTO aca_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","Íchaba éerri jócai wéewa wacába cáiwia ya náa'a sáaliica, liyú liá'a cáuli wérri básairri wayá, wayá walíjani yúcacuwai. ");
INSERT INTO aca_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","Jiníwata wabésunau íchaba éerri jiní wáayani, Pablo libárruacoo béewami nalí, limá nalí: —Nuwácanai, imédactata sáica nuwánacaalai jócu wajiáu chéni Creta; jócuminaata wabésunau cháiji'i, jiní wáuquedaca washínau yáairrimi lancha rícu. ");
INSERT INTO aca_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","Ne wáalee, áawita wabésunacoo cha, oyúrruqueda iwówa, jiníwata íibicha éenaa máanali'inaa, áawita liúcacoo liá'a lanchaca. ");
INSERT INTO aca_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","Ne táayee báqueerri ángel íyadau nulí Dios bánuani, nuyá Dios shínaa lécchoo nusírbia lirrú, ");
INSERT INTO aca_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","limá nulí: —Ocáarru jiyá, Pablo, jiníwata arrúnaa jíyadacoo lináneewa liá'a máanui wérri wánacaalaca Roma néenee sáica, ne jinácueji Dios jócu línda máanali jiyá ya náa'a yáainai jiájcha lancha rícu. ");
INSERT INTO aca_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","Tándawa, nuwácanai, o'éjueda iwówau, jiníwata nuéebida Dios nácu nuyá yéerri yáawaiyi quinínama liá'a bésuneerricoo limá'ee nulí liá'a ángel. ");
INSERT INTO aca_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","Ne arrúnaa wachánacoo áabai liwówai nácula. ");
INSERT INTO aca_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","Áabai táayebee, libésunau chámai semana nácu, jáiwa wáiinu manuá, áabai jí'ineerri Adriático, litéecala bajiálanaa liá'a cáulica, ne liyáali béewami táayebee, ne náa'a téeni'inaacoo lancha náa léenaa warrúnicoo wáacoo cáinabirru. ");
INSERT INTO aca_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","Néeneda lidujíwaca liá'a shiátaica, ne liwáalia treinta y seis metros, ne mawí libéechala néeneda báaniu, liwáalia'ee veintisiete metros. ");
INSERT INTO aca_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","Ne cáarrucala nayá carrúnataca náiinuacoo íiba wérrica nácula, jáiwa náuca cuatro náa'a gámbia wérrinai chéni líishii néenee liá'a lanchaca, nácula nasáta Dios yúcha quéewique'e jucámarraca. ");
INSERT INTO aca_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","Ne náa'a téene nácu lancha namá'ee nalíwoo quéewique'e namánicoo lancha rícucha, jáiwa nachánau náurrucueda náa'a íida éenibirrimica, namédacala'eewoo nayáca jicá'a náa'a yúquenai'inaa gámbia wérrinai lancha béecha. ");
INSERT INTO aca_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","Ne Pablo líiwa'ee lirrú liá'a wánacaleerrica ya lishínaa soldádorru lécchoo, limá'ee: —Ne jócta namáacau lancha rícu, iyá jócai'inaa cáwi. ");
INSERT INTO aca_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","Néenee náa'a soldádoca, nawíchua nabáji náa'a íida éenibirrimica, jáiwa náida licáacoo shiátai yáacula. ");
INSERT INTO aca_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","Ne wówai'inaa jucámarracai, Pablo íiwa nalí quinínama quéewique'e náaya máayabaca, limá'ee nalí: —Jái chámai semanacai wanénda wacábaca libésunau'u, iyá jócaini íya léjta iwítee séewirrinaa. ");
INSERT INTO aca_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","Nusáta yúcha íyaque'e máayabaca. Sáicabee'inaawa irrú liérra quéewique'e cáwi iyá, jiní'inaa yúquerriu yúcha, jiní áabai iwíta báinaa. ");
INSERT INTO aca_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","Linísa'inaami limá liéni, Pablo wína licáaji rícuu áabai páani, liá sáicai Diosru quinínama nanáneewa. Lishírridani jíni, jáiwa lichánau líyaqui jíni. ");
INSERT INTO aca_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","Jáiwa liá nadánani quinínamai nachánau náaya lécchu. ");
INSERT INTO aca_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","Wayá'ee wamánaba lancha rícu doscientas setenta y seis chóniwenai quinínama. ");
INSERT INTO aca_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","Liáwinaami nanísa'inaa'ee náaya liá'a nawówainica, náuca'ee liá'a trigo manuá yáacula jéewique'e lijínacoo madéjcalicu liá'a lanchaca. ");
INSERT INTO aca_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","Jái'inaa jucámarrai, náa'a téenai nácu lancha jócu náa léenaa táshia nayá jíni, ne nacába áabai libéerricula liwáalia'ee cáina; nawówai narrúnda lancha néerra. ");
INSERT INTO aca_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","Nawíchueda licuábai náa'a gámbia wérrinaimica, namáaca'ee manuá yáacu jíni, ne nawáseda jíni náa'a téenaca sírbierri litée lancha. Jáiwa nanácuda cáulirru liá'a vela libéechala sáica, jáiwa liá'a lanchaca lichánau lirrúnicoo cáina nácula. ");
INSERT INTO aca_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","Ne liáu cáina ítala macáshtairra, limáacactala'inau liá'a barco machúnucunaa. Liá'a libéechala sáica cháneerri júchananaa cáina íibirra, jócta néewa nachúnidacani, nácula liá'a líishiicaa néenee sáica lichána'eewoo lisúbirriedacoo lidánaniyu'e liá'a marrádacaca. ");
INSERT INTO aca_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","Náa'a soldádoca nawówai'e náiinua náa'a presobinica, jócubeecha náindata namánicoo náamarracoo. ");
INSERT INTO aca_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","Ne liá'a nashínaa wánacaleerri soldado, liwówai lijédacani liá'a Pabloca, jócu línda namédacani, jiníwata liwánacaala nayá, tánashia éewerri liámarracoo shiátai yáacu quéecha mawí íinu litácoowala. ");
INSERT INTO aca_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","Ne náa'a áabica náa'eewau líta'aa liá'a tabla lancha shídanaamica. Cháwa'ee wáiinu quinínama cáwi cáinabi íitala. ");
INSERT INTO aca_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","Quéecha'inaa cáwi wayá quinínama, wáa léenaa liá'a liwówai jí'ineerri Malta. ");
INSERT INTO aca_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","Náa'a chóniwenai néeni sánaca narríshibia wayá sáica wérri quinínama, jiníwata yúwairriu liyáca ya casálini lécchoo, natúculia chichái wérri, jáiwa namáida wayá warrúnicoo néerra. ");
INSERT INTO aca_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","Pablo yáawaquederri chichába máacarrai liníquini liyá libówanaa, ne bácua áai cánacau lijiácoo líibicha liá'a amóeiyica, jáiwa'ee liwówanau licáaji nácui liámuacani. ");
INSERT INTO aca_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","Nacába náa'a chóniwenaica nacába áai cuácoo licáaji nácu liá'a Pabloca, namá'ee nalí wáacoo: “Ta liá'a washiálicuerri cájbami cáiinuacai léji liéni, ne áawita jócu lisácumawai manuá yúcha, ái áabai wíteeshi cadánani jócai'inaa índa cáwi liyá.” ");
INSERT INTO aca_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","Ne Pablo licúsuda liúcha liá'a áaica chichái ricúla, ne jiní libésunawai. ");
INSERT INTO aca_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","Quinínama nanénda nayáca limúrracacoo, jócta licáu máanalina; néenee íchaba liáwinaami nanénda jiní'e libésunawai, nanáawida'ee nawíteu yá'ee nachánau namáca Pablo cála'ee dios. ");
INSERT INTO aca_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","Urrúni lirrú liá'a áabai cáinabi lishínaa liá'a chóniwerri wánacaleerri liwówai néeni, jí'ineerri Publio, ríshibia wayá sáica ya licába wanácu matáli éerri. ");
INSERT INTO aca_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","Ne bésuneerriu liá'a lisálijinaa liá'a Publio yéerri liárrubaiu íta'aa, bálinerri'eewoo cáiwinaa, licámuna nácu ya suliá wérri nácu. Pablo yáa'eewoo licábaqui jíni, néenee liáwinaami lisáta Dios yúcha jíni licháana'ee licáajiu linácu, jáiwa'ee sáica jíni. ");
INSERT INTO aca_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","Ne linácueji, náiinu náa'a áabica bálineneecoo náa'a yáaine liwówai íta'aa, jáiwa'ee sáica nayá lécchoo. ");
INSERT INTO aca_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","Jáiwa'ee náa walí quinínamai ne liáwinaami jái'inaa wáirrau wayá báaniu náa walí quinínama liá'a warrúni jinánica washínaa wáni'inau yáajcha. ");
INSERT INTO aca_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","Libésunau'inaa matáli quéerri nayá liwówai íta'aa, wáirrau áabai lancha rícula néeni bésuneda uniábi; lishínaa lancha áabai chacáalee jí'ineerri Alejandría, téerri linácu licábacanaa liá'a nashínaa diosca jí'ineenai Cástor ya Pólux. ");
INSERT INTO aca_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","Wáiinu chaléeni nachánactalacoo jí'ineerri Siracusa, néeni wamáacau matáli éerri. ");
INSERT INTO aca_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","Néeni wáau báaniu urrúni litácoowala cáashia wáiinu áaquirra chacáalee jí'ineerri Regio. Cajójchanaami cáuli cánacau sur néenee, áabai éerri táicala mawí wáiinu áabai chacáalee jí'ineerri Puteoli, néeni wabárruau. ");
INSERT INTO aca_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","Wáiinu áabi wéenajinaiu nawána wamáacacoo áabai semana náajcha; cháji'i wanísacoo walíwoo Roma néerra macáshtai. ");
INSERT INTO aca_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","Náa'a wéenajinai Roma néenee sánaca, jái nawáalia chuánshi wáiiwanaa néerrai; ne jái najiáu najúnteda wayái Foro de Apio, néerra liá'a liyáctaca jí'ineerri Matáli Tabernas. Pablo licába'inaa, liá'ee sáicai Diosru ya liá'ee léenaa cadánani liyá. ");
INSERT INTO aca_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","Ne wáiinu'inaa chaléeni Roma néerra, namáaca'ee Pablo liyáaque'e báawachala, bácairrimi soldado túyajani jócubeecha limániu. ");
INSERT INTO aca_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","Matáli éerri liáwinaami líinucai, Pablo bánua namáida nachúnsanaca judíobini Roma rícu. Jái'inaa náawacawai limá'ee nalí: —Nuéenajinai, nuyá jiní médani nanácula náa'a judíobinica, jiní linácula liá'a nawíteemi wawérrinaimi shínaa, ne báawachata Jerusalén néeni nawína nuyá néejueda nuyá nalí náa'a romanobinica. ");
INSERT INTO aca_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","Néenee liáwinaami nunísa nutáaniaca nawówai nawáseda nuyá, jiníwata jiní náiinuni nunácue, éewaque'e náiinua nuyá. ");
INSERT INTO aca_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","Ne náa'a judíoca jócu nawówai nawáseda nuyá, arrúnaacala nusáta liúcha liá'a máanui wérri wánacaalacai libánua náiinua nuyái, o nawásaidawee nuyá, áawita jiní máashii nuwáaliani linácueji liá'a nushínaa cáinabica. ");
INSERT INTO aca_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","Tada linácue, numáida iyá quéewique'e nucába ya nutáania irrú, tánda linácueji wawáaliaque'e wéebidaca wayá israelítabinica, jicába nuyáyu cabáji áani. ");
INSERT INTO aca_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","Namá'ee lirrú: —Wayá jiní ríshibiani áabai cáashta Judea néenee sái jinácue, jiní áabi wéenajinai judío íinuenai néenee, jiní'e namá jinácucha máashii jinácue. ");
INSERT INTO aca_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","Wawówai wéemica chítashia jiwítee jíni, jiníwata wáa léenaa quinínama cáinabi natáania linácucha liáni wáalii éewidacalashica. ");
INSERT INTO aca_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","Tánda namáca áabai éerri, liá'a lijiáctemicoo íchaba chóniwenai liá'a Pablo yáctamica. Néenee manúlacaiba cáashia táicala, Pablo táania Dios wánacaalactaca. Liwówai'e líiwa nalí Jesús nácu, táda béewami ley Moisés shínaa, natána náa'a íiwadedenai Dios chuáni báinacu. ");
INSERT INTO aca_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","Áabi éebidenai liá'a Pablo íiwanica, ne náa'a áabica jócani éebida. ");
INSERT INTO aca_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","Ne jócu áabenaa nawówa nalíwoo, nachána'eewoo náacoo. Ne jóctanaa náawai, Pablo má'ee nalí: —Sáicai litáania Espíritu Santo nalími náa'a iwérrinaibimica ibéechala sánamica, linúma rícue liá'a íiwadedeerri Dios chuáni Isaías, limá'ee: ");
INSERT INTO aca_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","‘Jiá namówai jíiwa nalí náa'a chóniwenaica: Ne áawita mawí néemica, jócai'inaa néewa néemica; áawitaque'e mawí nacábaca, jócai'inaa nacába. ");
INSERT INTO aca_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","Ne liwítee liéni chóniwenai cabálini wérri, nawíba báyau, ya liá'a natuí báyeerri lécchoo, jócubeecha néewa nacábaca, jiní néewaca néemica, jiní néewaca náa léenaani; quéewique'e jócu néejoo nulí, jócubeecha nuchúni nayá.’ ");
INSERT INTO aca_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","Yáaque'e léenaa iyá, chóque'e ibéechalau, liéni liwásedauca Dios shínaa, liáni nalí áawita náa'a jócani judíobini, ta nayá éemenaijani.  ");
INSERT INTO aca_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","Quéecha'inaa Pablo máirri liáni, náa'a judíobini náawai nacáita yáacacoo nayáwacoo. ");
INSERT INTO aca_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","Pablo máacau chámai camuí machácani á'a lijédacta lirrúwoo cuíta, liwínau liyá nayá, náa'a quinínama yáainecoo nacába liyá. ");
INSERT INTO aca_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","Cha liwíteemi íiwa Dios wánacaalactaca, léewidacala urrúnica liá'a wawácali Jesucristo, jiní cáarrucalani jiní namáshidacalani.");
INSERT INTO aca_vpl VALUES ("EP1_1","079_1_1","EPH","1","1","1","Nuyá Pablo, apóstolu Jesucristo shínaa, léjta Dios wówau'u, nutáa irrú iyá yáainai chacáalee jí'ineerri Éfeso, iyácala chóniwenai Dios shínaa, éebidacala áabenaa iwówa Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("EP1_2","079_1_2","EPH","1","2","2","Ya Dios Wasálijinaa ya Wawácali Jesucristo, yáa irrú mawéni sáicaica ya sáictaque'e iwówa. ");
INSERT INTO aca_vpl VALUES ("EP1_3","079_1_3","EPH","1","3","3","Wáa sáicai Dios lisálijinaa liá'a wawácali Jesucristoca, Dios Cristo nácu liá walí sáicaica áacairra, quinínama sáicabee cábacanaa Espíritu nácu. ");
INSERT INTO aca_vpl VALUES ("EP1_4","079_1_4","EPH","1","4","4","Dios wína wayá Cristo nácu jócu'inaami liquénuda cáinabi újnibii, quéewique'e majíconaa wayá lirrú, jiní'inaa máashii wawítee lináneewa. Qéechami caníinaa licába wayá, ");
INSERT INTO aca_vpl VALUES ("EP1_5","079_1_5","EPH","1","5","5","liwínanite quéewique'e liméda léenibiyu wayá Jesucristo nácu, áabenaa léjta liwówau'u naméda liwánacaala. ");
INSERT INTO aca_vpl VALUES ("EP1_6","079_1_6","EPH","1","6","6","Linácue jiliéni wáa sáicai séewirrinaa Diosru, sáicacala liwítee carrúni jináata licába wayá, liá walí sáicai licúulee nácuu caníinaaca licábaca. ");
INSERT INTO aca_vpl VALUES ("EP1_7","079_1_7","EPH","1","7","7","Níwata Dios caníinaa licába wayá bájialanaa quéechami, Cristo nácueji ya líirranaa jiérricoo máanali'inaa cruz nácu, wawáalia liwásedaque'e wayá, ya liméetua wajíconaa. ");
INSERT INTO aca_vpl VALUES ("EP1_8","079_1_8","EPH","1","8","8","Dios íiyada walí caníinau'u licába wayá, liá quinínama wawítee ya wáaque'e léenaa wéemica, ");
INSERT INTO aca_vpl VALUES ("EP1_9","079_1_9","EPH","1","9","9","ya liwána wáa léenaa Wacába liwánacaala báyeerrimicoo. Léjta limáyu'u liá'a yáairrimi liwíta lícu, cháwa limédaqui jíni. ");
INSERT INTO aca_vpl VALUES ("EP1_10","079_1_10","EPH","1","10","10","Liéni léjta limáyumi, limédaminau machácani wérri, quéecha'inaami líinu léerdicai. Dios bánua liáawacacoo liwánacaalaque'e quinínamani liá'a Cristoca, léjta náa'a áacai sánaca ya náa'a cáinabi íta'aa sánaca. ");
INSERT INTO aca_vpl VALUES ("EP1_11","079_1_11","EPH","1","11","11","Dios wína wayá quéechai quéewique'e wayá macáishita Cristo nácu, wawáalia lirrícuca éenaa, léjta áabenaa Dios wówaumijani, quinínama liméda léjta sáicai liwówau'u licábacani. ");
INSERT INTO aca_vpl VALUES ("EP1_12","079_1_12","EPH","1","12","12","Limédani cháji'i, quéewique'e wayá quéechanacu wamáaca wéebida Cristo nácu, quéewique'e wayá quinínama wáa lirrú sáicai liwítee dánani nácueji. ");
INSERT INTO aca_vpl VALUES ("EP1_13","079_1_13","EPH","1","13","13","Sáicacajani Cristo, iyá lécchoo éemenai chuánshi yáawaiyica, liá'a sáicai chuánshi liwásedau'inaa iyá, ya iwárruacala éebidaca, Dios yáa irrú lishínaa Espíritu Santo léjta áabai marca, cháwa limá liáacani quéecha. ");
INSERT INTO aca_vpl VALUES ("EP1_14","079_1_14","EPH","1","14","14","Liéni Espíritu Santoca léewa libéecha sái liérra yáawacaala'inaa Dios yáa walí lirrícuca éenau, jáicta wanísa wawásedacoo quinínama yúcha, ya ta liméda wayái lishínaa chóniwenai liyáni'inaa yáajcha, quéewique'e quinínama wáa lirrú sáicai liwítee dánani nácueji. ");
INSERT INTO aca_vpl VALUES ("EP1_15","079_1_15","EPH","1","15","15","Linácueji liéni, nuá léenaa éebida wawácali Jesús nácu, ya Caníinaaca icába náa'a chóniwenai Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("EP1_16","079_1_16","EPH","1","16","16","Jócu numáaca nuá sáicai Diosru inácueji, nuédacaniu inácu jáicta nusátau Dios yúchai. ");
INSERT INTO aca_vpl VALUES ("EP1_17","079_1_17","EPH","1","17","17","Nusáta Dios wawácali Jesucristo shínaaca, liwítee dánani liá'a wasálijinaaca liáque'e irrú wíteeshi áacai sái, quéewique'e yáa léenaa liá'a Dios íyadani, quéewique'e yáa léenaa Dios mawí mawí. ");
INSERT INTO aca_vpl VALUES ("EP1_18","079_1_18","EPH","1","18","18","Nusáta Dios yúcha quéewique'e liméecu iwítee ya jucámarranaa, quéewique'e yáa léenaa liá'a inéndani iyáca linácueji limáida iyá, sáictacala wérri liwítee ya cawénii liá'a Dios yáani nalí lishínaa chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("EP1_19","079_1_19","EPH","1","19","19","Yáawaiyii máanuica ya jiní númami liá'a jiwítee dánanica, liá'a yáairri wadánani wayá éebidenaica. Léewa wíteeshi máanui Dios íyadanimi lidánaniyu ya liwítee dánani yáajcha, ");
INSERT INTO aca_vpl VALUES ("EP1_20","079_1_20","EPH","1","20","20","quéecha'inaami licáweda Cristo ya liwána liwáacoo sáicaquictejica léema nácu áacairra. ");
INSERT INTO aca_vpl VALUES ("EP1_21","079_1_21","EPH","1","21","21","Dios limáacani quinínama wíteeshi dánani íta'aa, Dios yáirri Cristorru liwíteu máanui mawí, ya Cristo wánacaleerri quinínama náucha mawí náa'a wánacaleenai áacairra nácu ya áani cáinabi íta'aa, léjta liáni léerdica ya liá'a íinuerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("EP1_22","079_1_22","EPH","1","22","22","Limáaca Cristo íiba yáajba quinínama, ya Cristoja limáacani nawíta quinínama náa'a éebidenai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("EP1_23","079_1_23","EPH","1","23","23","Ne liá'a iglésiaca léwa Cristo náanai, tándawa liá'a iglésiaca Cristo rícueji liwáalia quinínama, Cristoca liá'a téerri quinínama sáicai wérricalani. ");
INSERT INTO aca_vpl VALUES ("EP2_1","079_2_1","EPH","2","1","1","Quéecha iyá léjta máanalinimi yáca linácueji liá'a jíconaashica ya máashiica, ");
INSERT INTO aca_vpl VALUES ("EP2_2","079_2_2","EPH","2","2","2","liá'a iyánimi rícu, imédacala léjta éerri wówau'u, ya liwánacaala liá'a espíritu máashii wánacaleerri cáuli rícu, yáairri nadánani náa'a jócani méda Dios wánacaala. ");
INSERT INTO aca_vpl VALUES ("EP2_3","079_2_3","EPH","2","3","3","Cháwate wayámi jírra lécchoo quinínama wayá'inaa báinacumi wawíteeyu, wamédacaalami máashii léjta wawówau'u, ya waméda licábacanaa liá'a wawítee cajíconaica, ya waméda liwánacaala liá'a wawítee máashiica. Linácueji, liérra máashiica sáica natá'inaata líinu wátala liá'a cacháninabeeca Dios, máashiicaca áabenaa náajcha náa'a áabi jócani éebida. ");
INSERT INTO aca_vpl VALUES ("EP2_4","079_2_4","EPH","2","4","4","Ne liá'a Dios carrúni jináatai cába wayá ya caníinaa wérri licába wayá bájialanaa. ");
INSERT INTO aca_vpl VALUES ("EP2_5","079_2_5","EPH","2","5","5","Liyá yáirri wacáwica áabenaa Cristo yáajcha, quéecha'inaa léjta máanali wayá újnibii liwánaca liá'a wajíconaaca. Jiníwata Dios caníinai cába iyá éewani iwáseda ijíconaa ya éewani yáacacoo áacairra. ");
INSERT INTO aca_vpl VALUES ("EP2_6","079_2_6","EPH","2","6","6","Dios cáweda wayá Cristo Jesús yáajcha, ya liwána wawáacoo liájcha áacairra. ");
INSERT INTO aca_vpl VALUES ("EP2_7","079_2_7","EPH","2","7","7","Liméda liáni quéewique'e líiyada liá'a éerri wabéecha, caníinaa licába wayá bájialanaa ya liá'a sáicai wérri liyá wáajcha Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("EP2_8","079_2_8","EPH","2","8","8","Ne sáicai wérrica liá'a Dios, iyá éewenai yáacoo áacairra, inísaca éebida Jesús nácu. Liéni jócai íinu iyá jájiu, níwata liáni wíteeshica Dios yáani irrú. ");
INSERT INTO aca_vpl VALUES ("EP2_9","079_2_9","EPH","2","9","9","Jócai íinu liwánaca liá'a imédanica, jiní béecha éewerri sáicta licábacoo, ");
INSERT INTO aca_vpl VALUES ("EP2_10","079_2_10","EPH","2","10","10","ne Dios méderri wayá; liyá quénuderri wayá Cristo Jesús nácu, quéewique'e waméda sáicai cábacanaa; Dios quéechanacu lichúni walí wamédani'inaa. ");
INSERT INTO aca_vpl VALUES ("EP2_11","079_2_11","EPH","2","11","11","Ne chái'inaa, iyá, náa'a jócani judíobini, náa'a náani jí'inaa “jócani náiju nachíipi dácu íimanaa”, náa'a judíobini (náiju washiálicuerri tácai sáica, ne nayá jájiu nají'inaa náiju nachíipi dácu íimanaa). ");
INSERT INTO aca_vpl VALUES ("EP2_12","079_2_12","EPH","2","12","12","Édacaniteu áabata éerrimite iyá jócani yáa léenaa Cristo nácu, shírreneu chóniwenai Israel shínaa yúcha, ya jócani yáa néeni á'a Dios litáania'inaa nalí náa'a chóniwenai Israel shínaaca, ne liá'a limáni liméda lishínaa chóniwenai yáajchau. Iyá líta'aa liáni cáinabica jiní irrú Dios ya jiní inéndacala líinu liá'a éerrica Dios wásedactala'inaa iyájoo. ");
INSERT INTO aca_vpl VALUES ("EP2_13","079_2_13","EPH","2","13","13","Ne chóque'e, iyá yáainemi Dios yúcha déecuchejijani, nísa irrúnicuwai lirrú, yáaine macáishita Jesucristo nácu, linácueji liá'a líirranaa jiérricoo máanali'inaa cruz nácu. ");
INSERT INTO aca_vpl VALUES ("EP2_14","079_2_14","EPH","2","14","14","Cristo yáirri walí sáictaque'e wawówa. Liyá'ee méderriu judíobinica ya jócani judíobini áabai chacáalee néenee sána, licáarralia liá'a báyeerrimi nayá wáacoo ya licáarralia lináanaiyu liá'a íiwirri nawówa nayá wáacoo. ");
INSERT INTO aca_vpl VALUES ("EP2_15","079_2_15","EPH","2","15","15","Cristo méderri amáarra leyca, liá'a ley wáaleerri liwánacaalau'u ya limá'ee chítashia nayáyu'inaa náa'a chóniwenaica; linácueji liméda chámai chacáalee áabai rími chacáalee wáalii. Cha liméda léji liéni sáictacta'inaa nawówa. ");
INSERT INTO aca_vpl VALUES ("EP2_16","079_2_16","EPH","2","16","16","Cristo máanali cruz nácu amáarra jíni jócu náiinua yáacau mawiá náa'a chámai chacáalee, limáaca nayái sáictaica nawówa Dios yáajcha, liméda nayá áabai rími nanáishija. ");
INSERT INTO aca_vpl VALUES ("EP2_17","079_2_17","EPH","2","17","17","Cristo íinu línda nalí sáicau chuánshica sáictaque'e nawówa quinínama, chaléjta iyá yáainai déecucha Dios yúcha, chaléjta lécchoo náa'a yáainai urrúni. ");
INSERT INTO aca_vpl VALUES ("EP2_18","079_2_18","EPH","2","18","18","Cristo nácueji, náa'a áabica ya náa'a áabi, wéewa warrúnicoo wasálijinaa Diosru áabai rímii Espíritu nácueji. ");
INSERT INTO aca_vpl VALUES ("EP2_19","079_2_19","EPH","2","19","19","Tándawa, iyá jócani áabai cáinabi íta'ai sána mawiá, jócani yáa báawachala ishínaa cáinabi yúchau, ne chóque'e ishírrida liá'a chacáalee Dios shínaa áabenaa, cháni léjta Dios éenibi. ");
INSERT INTO aca_vpl VALUES ("EP2_20","079_2_20","EPH","2","20","20","Iyá éebidenaica chaléjta áabai cuítaca, méderri líta'aa liá'a íibaca cabálininaaca, iyá nayáwa néewidani náa'a apóstolubinica ya náa'a éewidenai Dios chuáni, liyáwa Cristoca léjta íiba cawénii. ");
INSERT INTO aca_vpl VALUES ("EP2_21","079_2_21","EPH","2","21","21","Chaléjta liá'a cuítaca yáairri linácula wáacoo nácuderri liácoo quinínama áabenaa, cáashia líinu limédacoo léjta templo majíconaa ya wáni Wawácalirru. ");
INSERT INTO aca_vpl VALUES ("EP2_22","079_2_22","EPH","2","22","22","Chacábacanaa iyá lécchoo, yáainai Cristo yáajcha macáishita, yáawaaca yáaqueneu éewaque'e iyá chaléjta áabai templo, Dios yáaque'e néeni linácueji lishínaa Espírituyu. ");
INSERT INTO aca_vpl VALUES ("EP3_1","079_3_1","EPH","3","1","1","Linácueji liéni, nuyá Pablo, nuyá cuíta manúmai rícula, Cristo Jesús nácue, sáicabee'inaa irrú iyá jócani judíobini. ");
INSERT INTO aca_vpl VALUES ("EP3_2","079_3_2","EPH","3","2","2","Iyá jáini arrúnaa yáa léenaa sáicaca liá'a Diosca limáaca nulí liáni tráawajuca, nuíiwaque'e irrúni linácue liá'a caníinaabeeca lichúnicau. ");
INSERT INTO aca_vpl VALUES ("EP3_3","079_3_3","EPH","3","3","3","Chítashia Dios wánau'u nuá léenaa linácu liá'a jócaimi chóniwenai yáa léenaa nácu quéecha, léjta nunísau'u nutána irrú áabai chuánshi píitui rími. ");
INSERT INTO aca_vpl VALUES ("EP3_4","079_3_4","EPH","3","4","4","Áicta iliá éemiujoni, néenee yáa léenaajoo nuá léenaa sáica linácu liá'a jócaimi chóniwenai yáa léenaa báinacumi, ne chóque'e Cristo limédani'inaa. ");
INSERT INTO aca_vpl VALUES ("EP3_5","079_3_5","EPH","3","5","5","Dios jócai íiwa nalí liáni náa'a chóniwenai yáainai wabéecha, ne chóque'e liwána lishínaa Espíritu íiwa nalíni náa'a majíconaanica apóstoluca, náajcha náa'a íiwenai Dios chuáni, liwínani namédaque'e lirrú sáicai léjta liwówau'i. ");
INSERT INTO aca_vpl VALUES ("EP3_6","079_3_6","EPH","3","6","6","Néenee, liéni cabáyainta Dios wána nuá léenaa linácu: Jáicta náa'a judíobini ya náa'a jócani judío éewidenai náa'a sáicai chuánshica Dios bánuanica urrúni Cristo, Dios yáani nalí náa'a quinínama náa'a sáicabeeca. Liwówai limá, quinínama nayá áabenaani lináanaija, liyá léjta Cristo lináanai, nayá náa'a jócani judíobini narríshibia lécchoo liá'a Dios limánimi liáca léjta nája náa'a judíobinica. ");
INSERT INTO aca_vpl VALUES ("EP3_7","079_3_7","EPH","3","7","7","Dios yúderri wérri nuyá nutráawajaaque'e lirrú, nuéewaque'e nuíiwadeda chóniwenairru liáni chuánshi sáicaica wásedeerri'inaa nayá. Báawita jócai sáica nuyá, nuéewa numéda quinínama liáni liyú liá'a Dios wíteeca liáni nulí. ");
INSERT INTO aca_vpl VALUES ("EP3_8","079_3_8","EPH","3","8","8","Áawita nuyá mawéni mawí Diosru náucha náa'a quinínama chóniwenai Dios shínaa, liyúda nuyá nuéewaque'e nuíiwadeda nalí náa'a jócani judío liáni chuánshi sáicaica cawénii wérrica Cristo shínaa. ");
INSERT INTO aca_vpl VALUES ("EP3_9","079_3_9","EPH","3","9","9","Dios, liá'a quénuderri quinínama éerri, bánuerri nuyá nuíiwaque'e lichuáni mamáarraca, quéewique'e quinínama chóniwenai yáa léenaa Dios wásedeerri lécchoo náa'a jócani judíobini. Dios quéecha jócai índani quinínama chóniwenai yáa léenaa linácu liáni chuánshica. ");
INSERT INTO aca_vpl VALUES ("EP3_10","079_3_10","EPH","3","10","10","Liméda liáni, quéewique'e náa'a chóniwenai Dios shínaaca, náyadaque'e nalí náa'a ángelca, wánacaleenai áacairra, náyadaque'e nalí lécchoo náa'a espíritu máashiinica, sáictai wérrica Dios wíteeca méderri sáicai quinínama ");
INSERT INTO aca_vpl VALUES ("EP3_11","079_3_11","EPH","3","11","11","Dios méda liáni léjta liwówau'u liméda áabenaa quéechanacu éerrite, liméda liáni lirrícue liá'a Wawácali Jesucristo. ");
INSERT INTO aca_vpl VALUES ("EP3_12","079_3_12","EPH","3","12","12","Cristo nácue wawáalia wawáseda wajíconau wéewaque'e warrúnicoo Diosru, tádawa jócu cáarru warrúnicoo waléenaca wéebida linácu. ");
INSERT INTO aca_vpl VALUES ("EP3_13","079_3_13","EPH","3","13","13","Tádawa nusáta yúcha jócubeecha yúrrucueda iwówau inácueji carrúni jináata nuyáca, jiníwata liáni yáawaiyi numá irrú sáicai wérrica. ");
INSERT INTO aca_vpl VALUES ("EP3_14","079_3_14","EPH","3","14","14","Nuédacaniu'inaa linácu liáni, chítashia Dios médau'u iyá jócani judíoca áabenaani náajcha náa'a judíoca, nutúyau nu'óraaque'e lirrú liá'a Lisálijinaa liá'a Wawácali Jesucristoca. ");
INSERT INTO aca_vpl VALUES ("EP3_15","079_3_15","EPH","3","15","15","Tánashia ríshibianai jí'inaa quinínama chóniwenai chaléjta yáainai áacairra, cha náa'a náani yáainai cáinabi íta'aa. ");
INSERT INTO aca_vpl VALUES ("EP3_16","079_3_16","EPH","3","16","16","Nusáta liúcha liá'a Diosca, wáalierri quinínama sáicai áacairra, quéewique'e liá irrú danáanshi iwówa lícu linácueji liá'a Espíritu Dios shínaa. ");
INSERT INTO aca_vpl VALUES ("EP3_17","079_3_17","EPH","3","17","17","Nusáta Dios yúcha Cristo yáaque'e iwówa lícu éebidau linácu. Nuyá sáteerri lécchoo quéewique'e quinínama liá'a imédanica caníinaaca icába liá'a Diosca ya quinínama náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("EP3_18","079_3_18","EPH","3","18","18","Ya chacábacanaaque'e yáa léenaa náajcha náa'a quinínama chóniwenai Dios shínaa, chítashia manújirrau, limáchenica ya liáacaica ya lidujíwaca liá'a níinaashica Cristo shínaa. ");
INSERT INTO aca_vpl VALUES ("EP3_19","079_3_19","EPH","3","19","19","Nusáta icúnusiaque'e caníinau Cristo cába iyá, mawíyi máanui liúcha liá'a quinínama wéewa wacúnusianica, chacábacanaaque'e cashiámu iyá Dios wíteeyu. ");
INSERT INTO aca_vpl VALUES ("EP3_20","079_3_20","EPH","3","20","20","Ya chóque'e, wáa sáicai wérri Diosru, liwáaliaca danáanshi limédau'inaa íchaba mawí liá'a wasátani o liá'a wapénsani, linácu liá'a lidánani tráawajairri'inaa wanácu. ");
INSERT INTO aca_vpl VALUES ("EP3_21","079_3_21","EPH","3","21","21","Wayá yéenai iglesia rícu, wayá macáishita Cristo Jesús yáajcha, arrúnaa séewirrinaa wáa sáicai Diosru mamáarraca. Chácajani. ");
INSERT INTO aca_vpl VALUES ("EP4_1","079_4_1","EPH","4","1","1","Táda linácue nuyá cuíta manúmai rícula, linácueji liá'a Wawácalica, nusáta yúcha imédaque'e sáica léjta náa'a Dios máidanica, chacábacanaa léjta iyá. ");
INSERT INTO aca_vpl VALUES ("EP4_2","079_4_2","EPH","4","2","2","Imíya iyá ya sáica iyá; u'urrúni iwówa ya iwánta yáajcha wáacoo caníinaabeeyu. ");
INSERT INTO aca_vpl VALUES ("EP4_3","079_4_3","EPH","4","3","3","Éeneda iyá séewirrinaa yáajcha wáacoo, lidánaniyu liá'a Espíritu Santo, ya lirrícueji liá'a sáicta iwówa liwána sáica iyá áabenaa. ");
INSERT INTO aca_vpl VALUES ("EP4_4","079_4_4","EPH","4","4","4","Ái bácai rímija náanaishi, ya bácairrimi Espíritu, chaléjta Dios máidau'u inénda áabai rímii. ");
INSERT INTO aca_vpl VALUES ("EP4_5","079_4_5","EPH","4","5","5","Ái bácai rímija Wawácalija, wéebida áabai rími chuánshija, ái áabai rími bautísmoja. ");
INSERT INTO aca_vpl VALUES ("EP4_6","079_4_6","EPH","4","6","6","Ái bácai rími Diosja, liyáwa Wasálijinaa'inaa quinínama; Dios wájani wawácali wayá'inaa quinínama. Dios méderri quinínama inácueji; Dios méderriu quinínama wanácu. ");
INSERT INTO aca_vpl VALUES ("EP4_7","079_4_7","EPH","4","7","7","Ne wayá bácainaa ái ríshibia wíteeshi Espíritu yáanica Cristo wówaini liáca. ");
INSERT INTO aca_vpl VALUES ("EP4_8","079_4_8","EPH","4","8","8","Tándawa limá liá'a tánerrimicoo: “Líirrau áacairra litée liájchau náa'a yáainemi preso, ya liá nalí wíteeshi áacai sái washiálicuenairru.” ");
INSERT INTO aca_vpl VALUES ("EP4_9","079_4_9","EPH","4","9","9","¿Ya tána liwówau limáca líirracalau áacairra? Wówerri limáca quéechanacu liúrrucoo líta'aa liéni cáinabica. ");
INSERT INTO aca_vpl VALUES ("EP4_10","079_4_10","EPH","4","10","10","Ne liá'a yúrrucuerrimicoo liyáwajani léja liá'a íirrerricoo mawí áacairra quinínama éerri wícau, quéewique'e licámusheda macájirra éerrimi liwánaca. ");
INSERT INTO aca_vpl VALUES ("EP4_11","079_4_11","EPH","4","11","11","Ya liyája yáa áabi quéewique'e apóstolu nayá, ya áabi íiwadedeerri Dios chuáni, ya áabi íiwenai Dios chuáni nalí náa'a jócani éebida, áabi pastorbini ya quéewidacanica. ");
INSERT INTO aca_vpl VALUES ("EP4_12","079_4_12","EPH","4","12","12","Cháwa lichúni náa'a chacáalee majíconaanica, áabai tráawajo lirrú machácani, quéewique'e lidáwinacoo liá'a Cristo náanaica. ");
INSERT INTO aca_vpl VALUES ("EP4_13","079_4_13","EPH","4","13","13","Cáashia quinínama wáiinu áabebata wayá wéebidaca ya cawítee wayá linácu liá'a Dios cúuleeca, ya wéenaa wáiinuca salírricta wayá, áabenaaque'e wamáanuibaca léjta Cristo. ");
INSERT INTO aca_vpl VALUES ("EP4_14","079_4_14","EPH","4","14","14","Ne jócuminaa léjta sáamanai wayá mawiá, jócani déecuna wanáawida wítee wapénsaca, ya jócani déecuna wáardaca áabai wáalii néewidauca, ya waínda wachálujueda nayá nayú náa'a chóniwenai canúma yúwicanica, náa'a jínenaicoo iníjbaa yúquerriu rícu. ");
INSERT INTO aca_vpl VALUES ("EP4_15","079_4_15","EPH","4","15","15","Mawí sáicaca, watáaniaca liá'a yáawaiyica ya liá'a caníinau'u wacába yáacacoo, arrúnaa wadáwinacoo quinínama Cristo nácu, liyáwa liwíta liá'a iglésiaca léjta lináananai. ");
INSERT INTO aca_vpl VALUES ("EP4_16","079_4_16","EPH","4","16","16","Ya Cristo nácu liá'a náanaishica quinínama licháanacoo lirrúnicoo sáica, liyú liáwacau quinínama litánai sáica; ya jáicta quinínama léewawai sáica, lidáwinau liácoo linácu liá'a caníinau nacába yáacacoo. ");
INSERT INTO aca_vpl VALUES ("EP4_17","079_4_17","EPH","4","17","17","Léwa numáni irrú liáni ya nucárgueda irrú Wawácali jí'inaa nácu, jócubeecha imédau mawí léjta náa'a jócani yáa léenaa Dios nácu. Náa'a yáainai áabenaa léjta mawítee mawéni máyu nalí, ");
INSERT INTO aca_vpl VALUES ("EP4_18","079_4_18","EPH","4","18","18","nayá catáwacai wítee, jócani yáa léenaa néemica. Nayá jócani wáalia cáwicaishi Dios yáanica, jiníwata mawíteeni, cháni járra jiníwata nawówa náawerriu cabálini ya jócani nasíntia. ");
INSERT INTO aca_vpl VALUES ("EP4_19","079_4_19","EPH","4","19","19","Cabálinini wérri médacoo ya náijueda nayáu éerri shínanaarru, nasíguia naméda quinínama máashii jócani bárroo. ");
INSERT INTO aca_vpl VALUES ("EP4_20","079_4_20","EPH","4","20","20","Ne iyá nísenai icúnusia Cristo, néenee u'iyá léjta náa'a jócani cúnusia Cristo. ");
INSERT INTO aca_vpl VALUES ("EP4_21","079_4_21","EPH","4","21","21","Ne yáawacta éemi chuánshi linácucha ya éewidau iyáca chaléjta liwówau'u, chaléjta liá'a yáawaiyiica yéerri Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("EP4_22","079_4_22","EPH","4","22","22","Ne léjta iyáyumi báinacu, ijiáyu liúcha liérra wíteeshi ajuítaimica, ijiáque'iu liá'a iyánimi rícu quéecha, máashiiderricoo, chálujuedeerri nawówau'u naméda máashii. ");
INSERT INTO aca_vpl VALUES ("EP4_23","079_4_23","EPH","4","23","23","Iyá arrúnaa iméda wáalii iwíteu ya iwówa. ");
INSERT INTO aca_vpl VALUES ("EP4_24","079_4_24","EPH","4","24","24","Iyá arrúnaa ináawidacoo quinínama iwíteu, quénuerricoo léjta Dios wówau'u, qéewique'e quinínama chóniwenai éewa nacába iyá machácani, majíconaa ya bárruerricoo lirrícueji liá'a yáawaiyiica. ");
INSERT INTO aca_vpl VALUES ("EP4_25","079_4_25","EPH","4","25","25","Tándawa, jóca iméda inúma yúwicau mawiá, ne itáania yáawaiyiica iyácachuirru, jiníwata wayá quinínama léjta bácai rími wanáanaija. ");
INSERT INTO aca_vpl VALUES ("EP4_26","079_4_26","EPH","4","26","26","Íiwirricta iwówa áabi yáajcha, u'iméda ijíconau, ya iméda idánaniu jócubeecha íiwirri iwówa éerri yájinaa. ");
INSERT INTO aca_vpl VALUES ("EP4_27","079_4_27","EPH","4","27","27","O'imáaca yáarrushi lirrú liá'a Wawásimica. ");
INSERT INTO aca_vpl VALUES ("EP4_28","079_4_28","EPH","4","28","28","Liá'a néduerrica, jimáaca jinédiu, jichánau jitráawajaaca, jiméda sáica tráawaju jicáajiyu, quéewique'e éewa jiá narrúnijinaa náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("EP4_29","079_4_29","EPH","4","29","29","U'imá chuánshi máashii, ne imá bácai chuánshi sáicai ya léerdi rícu, iyúdani dáwinacoo ya línda sáicabee nawíba licúla náa'a éemenaicani. ");
INSERT INTO aca_vpl VALUES ("EP4_30","079_4_30","EPH","4","30","30","U'iwána máashii liwówa Espíritu Santo Dios shínaaca, Dios yáaca irrú lishínaa Espíritu liáque'e léenaa lishínaa iyá, liyáali éerri'inaa liá irrú quinínama liwásedaque'e iyá. ");
INSERT INTO aca_vpl VALUES ("EP4_31","079_4_31","EPH","4","31","31","Idána yúchau liá'a máashiu'u iwówa, ya liá'a iwówau'u iméda máashii, ya íiwirriu iwówa, ya imáidadau'u nawítee, ya máashiu inúma, ya quinínama méenaami máashiica. ");
INSERT INTO aca_vpl VALUES ("EP4_32","079_4_32","EPH","4","32","32","Sáicai iyá, carrúni jináata icába yáacacoo yáajcha wáacoo, ya imíya máecha ijíconaa wáacoo, léjta Dios méetuau ijíconaa Cristo nácu. ");
INSERT INTO aca_vpl VALUES ("EP5_1","079_5_1","EPH","5","1","1","Iyá léjta Dios éenibi caníinaani'inai licábaca, éeneda imédacoo léjta liyá. ");
INSERT INTO aca_vpl VALUES ("EP5_2","079_5_2","EPH","5","2","2","Caníinaa icába yáacacoo quinínama, léjta caníinaa Cristo cába wayá léentregau quéewique'e natáata cruz náculani wanácueji. Liá'a Cristo máanalicaca, léjta áabai ofrenda ya carrúni jináata limédacoo, sáitaque'e Dios wówa. ");
INSERT INTO aca_vpl VALUES ("EP5_3","079_5_3","EPH","5","3","3","Iyáwa chóniwenai Dios shínaa, jócani sáicanata táania linácu liá'a éerri shínanaa namédau náinaayu máashii, jiní méenaami casáculai, jiní yawíquica. ");
INSERT INTO aca_vpl VALUES ("EP5_4","079_5_4","EPH","5","4","4","U'imá chuánshi máashii, jiní chuánshi mawénii, jiní chuánshi jócai sáicanata itáaniaca, jiníwata liéni jócai sáica irrú; mawí yáa sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("EP5_5","079_5_5","EPH","5","5","5","Ne yáani léenaayii liá'a méderri máashii líinayu, áabata jíconaashi casáculai, o yawíquicani, (chái léjta liá'a yáirri sáicai jócai Dios), jócai éewa liwáalia lishínau chaléeni Cristo wánacaalactalaca ya Dios. ");
INSERT INTO aca_vpl VALUES ("EP5_6","079_5_6","EPH","5","6","6","Jiníbeecha chálujueda iyá linácu liá'a chuánshi mawéniica, jiníwata yáawaiyi linácueji liéni líinu liá'a carrúnatai wérri Dios shínaaca, nanácula náa'a jócani méda léjta Dios máyu'u. ");
INSERT INTO aca_vpl VALUES ("EP5_7","079_5_7","EPH","5","7","7","U'iníquiu náajcha nárra chóniwenai chánicarra. ");
INSERT INTO aca_vpl VALUES ("EP5_8","079_5_8","EPH","5","8","8","Iyá quéechanacu yáainaimi léjta wajínani'inaamiu catáwacai jirrícu, ne chóque'e, wayácala warrúnicoo Wawácalirru, yáainai léjta wamáctau éerrinacu, iyáyu léjta náa'a wáalianai jucámarrabee, ");
INSERT INTO aca_vpl VALUES ("EP5_9","079_5_9","EPH","5","9","9","ne liá'a Espíritu Dios shínaa wáneerri sáica wayáca, wáneerri wayá machácani ya wáneerri watáania yáawaiyii. ");
INSERT INTO aca_vpl VALUES ("EP5_10","079_5_10","EPH","5","10","10","Éeneda iméda liá'a sáicaica Wawácalirru. ");
INSERT INTO aca_vpl VALUES ("EP5_11","079_5_11","EPH","5","11","11","U'iméda iwówau áabenaa náajcha náa'a jócani cúnusia Dios, ne liá'a namédani nayá jiní wéni. Máajiani, iwána nacába najíconau ya liá'a máashiica. ");
INSERT INTO aca_vpl VALUES ("EP5_12","079_5_12","EPH","5","12","12","Ne yáawaiyi báinatai watáania linácu liá'a namédani cabáyainta. ");
INSERT INTO aca_vpl VALUES ("EP5_13","079_5_13","EPH","5","13","13","Ne jáicta jucámarrai, wéewa wacába quinínama, wéewa wacába chítashia yáawai jiníni. ");
INSERT INTO aca_vpl VALUES ("EP5_14","079_5_14","EPH","5","14","14","Jiníwata liá'a jucámarrabeeca méecuerri liwícau quinínama. Tándawa litánau: “Jicáwiau, jiyá máairrica; jibárroo liúcha liá'a léjta náa'a máanalinica, ya Cristo quéena jiyá”. ");
INSERT INTO aca_vpl VALUES ("EP5_15","079_5_15","EPH","5","15","15","Tándawa, itúyau iyáyu'uca. U'iyá mawíteeta, iyá cawíteeyu. ");
INSERT INTO aca_vpl VALUES ("EP5_16","079_5_16","EPH","5","16","16","U'índa léerdi bésunacoo cháji'i, jiníwata liáni éerrica chóniwenai médacta íchaba máashii. ");
INSERT INTO aca_vpl VALUES ("EP5_17","079_5_17","EPH","5","17","17","Jócu imédau mawíteeta; éenedau éemica tánashia Wawácali wówai imédacai. ");
INSERT INTO aca_vpl VALUES ("EP5_18","079_5_18","EPH","5","18","18","U'icáma mawiá, liérra téerri iyá chaléeni jócai sáicanata imédaca; báawachata, índa Espíritu Santo cámusheda iyá. ");
INSERT INTO aca_vpl VALUES ("EP5_19","079_5_19","EPH","5","19","19","Itáania irrú wáacoo salmoyu, himnos ya shímashi Espírituyu, ya irrábau yáa sáicai iwówa yáajchau Wawácalirru. ");
INSERT INTO aca_vpl VALUES ("EP5_20","079_5_20","EPH","5","20","20","Yáa mamáarraca sáicai quinínama nácu liá'a Dios wasálijinaaca, lijí'inaa nácu liá'a Wawácali Jesucristo. ");
INSERT INTO aca_vpl VALUES ("EP5_21","079_5_21","EPH","5","21","21","Iméda iwánacala yáacau, cawáunta Cristo nácu. ");
INSERT INTO aca_vpl VALUES ("EP5_22","079_5_22","EPH","5","22","22","Iyá náinuca éewenai iméda íinirri wánacaalau, chaléjta imédau Cristo wánacaalacta iyá. ");
INSERT INTO aca_vpl VALUES ("EP5_23","079_5_23","EPH","5","23","23","Níwata liá'a rúnirrica wánacaleerri ruá'a líinucoo, léjta Cristo wánacaalau chóniwenai iglesia rícu sána, liá'a iglesia chaléjta lináanai liá'a Cristoca; ya liyá lécchoo téerri ruyá áacairra. ");
INSERT INTO aca_vpl VALUES ("EP5_24","079_5_24","EPH","5","24","24","Chaléjta náa'a chóniwenai yéenai iglesia rícu néebida Cristo nácu, cha lécchoo náa'a náinuca arrúnaa néebida náanirri chuániu quinínama. ");
INSERT INTO aca_vpl VALUES ("EP5_25","079_5_25","EPH","5","25","25","Iyá náanirri, caníinaa icába íinu, chaléjta caníinau Cristo cába náa'a chóniwenai iglesia rícu sána, máanali liyá nanácueji. ");
INSERT INTO aca_vpl VALUES ("EP5_26","079_5_26","EPH","5","26","26","Liméda liáni sáicai'inaa lirrú jájiu, libádedaque'e liyú liá'a lichuánica ya libádedaque'e nayá shiátaiyu, ya líiwa nalí libádedacala nayái, ");
INSERT INTO aca_vpl VALUES ("EP5_27","079_5_27","EPH","5","27","27","quéewique'e líyada liyá jájiu, léjta áabai iglesia sáictai wérri, jiní jíconaa ya íiwirribee, jiní wérri máashii, jócta majíconaa ya machácani. ");
INSERT INTO aca_vpl VALUES ("EP5_28","079_5_28","EPH","5","28","28","Chaléjta rúnirri caníinaa licába lináananai liyá jájiu, chacábacanaa caníinaa licába líinuu. Liá'a caníinai cába líinuu, caníinaa licába liyá jájiu. ");
INSERT INTO aca_vpl VALUES ("EP5_29","079_5_29","EPH","5","29","29","Níwata jiní máashii cába liyá jájiu, ne litúyani wérri sáica, léjta Cristo médau chóniwenai iglesia rícu sána, ");
INSERT INTO aca_vpl VALUES ("EP5_30","079_5_30","EPH","5","30","30","níwata liá'a iglésiaca léjta lináanai. Wayá léquichu léjta léenaa liá'a lináananaica. ");
INSERT INTO aca_vpl VALUES ("EP5_31","079_5_31","EPH","5","31","31","Tánerriwai: “Néenee, liá'a washiálicuerrica limáacaminaajoo lisálijinau ya litúwa, quéewique'e cáinu liyá, nayáminaa chámatanaa léjta áabai rími náinaa.” ");
INSERT INTO aca_vpl VALUES ("EP5_32","079_5_32","EPH","5","32","32","Léja liáni áabai chuánshi máanui wérri cabáyainta ya manúmata, ne nuyá nutáania nuyáca Cristo nácu ya náa'a iglesia ísanaca. ");
INSERT INTO aca_vpl VALUES ("EP5_33","079_5_33","EPH","5","33","33","Ne tándawa, iyá bácainaa arrúnaa caníinaa icába ruá'a íinucoo, léjta caníinau jicába jiyá jájiu, ya náa'a inínaica, bácainaa cawáuntaque'e nayá náanirrirru. ");
INSERT INTO aca_vpl VALUES ("EP6_1","079_6_1","EPH","6","1","1","Iyá néenibi, éebidau isálijinaarru caníinaa icába liá'a Wawácalica, níwata liéni machácani. ");
INSERT INTO aca_vpl VALUES ("EP6_2","079_6_2","EPH","6","2","2","Liá'a quéechanacu sái liwánacaalauca Dios shínaaca limánica méderri sáicai nalí náa'a éebidenai lirrú, léwani liéni: “Cawáuntaque'e ya jitúyau jisálijinaarru ya jitúwarru lécchoo; ");
INSERT INTO aca_vpl VALUES ("EP6_3","079_6_3","EPH","6","3","3","quéewique'e sáica jiwówa ya iyáque'e machéni jicáwica líta'aa liáni cáinabica.” ");
INSERT INTO aca_vpl VALUES ("EP6_4","079_6_4","EPH","6","4","4","Ya iyá nasálijinaa, u'iwána íiwirri nawówa náa'a éenibicoo, mawí sáicaca idáwinani iwána naméda sáicai, éewidani léjta liá'a éebiderri wawácali nácu arrúnaa limédacani. ");
INSERT INTO aca_vpl VALUES ("EP6_5","079_6_5","EPH","6","5","5","Iyá wáalianai iwácanai, éebidau iyá líta'aa liáni cáinabica nalí náa'a ishínaa iwácanaica. Iméda nalíni cawáuntani, cáarructani ya iméda yáawaiyi iwówa yáajchau, léjta imédau Cristorru. ");
INSERT INTO aca_vpl VALUES ("EP6_6","079_6_6","EPH","6","6","6","Ishírrueda, jócaita á'a nacábacta nayá iyá, quéewique'e sáica imáacacoo náajcha, chaléjta náa'a shírruedenai Cristorru, iméda yáawaiyi liá'a Dios wówainica. ");
INSERT INTO aca_vpl VALUES ("EP6_7","079_6_7","EPH","6","7","7","Imédau jishínaa tráawaju sáica iwówa yáajchau, léjta Wawácalirru jócaita chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("EP6_8","079_6_8","EPH","6","8","8","Ne jái yáa léenaa bácainaa, wánacaala yáarru, jócaita liwánacaala, lirríshibiaminaa Wawácali yúcha liá'a léjta jáni limédanica sáicaica. ");
INSERT INTO aca_vpl VALUES ("EP6_9","079_6_9","EPH","6","9","9","Ya iyá, nawácanai, imédau sáica náajcha náa'a iwánacalanica, jiní ibáulidacala nayá. Édacaniu tándawa iyá ya nayá yáaine licáaji rícu liá'a Wawácalica yéerri áacai, ya liyá jócai níwa liyá chóniwenai, liyá cáberri áabenaa quinínama. ");
INSERT INTO aca_vpl VALUES ("EP6_10","079_6_10","EPH","6","10","10","Ya chóque'e, nuéenajinai, iméda idánaniu macáishita Wawácali yáajchau, linácula cabálininaa jiní éenaa liméda liájchaa. ");
INSERT INTO aca_vpl VALUES ("EP6_11","079_6_11","EPH","6","11","11","Itúyau quinínama liyú liérra ármaca Dios yáni irrú, quéewique'e éewa iyáca cabálininaa liúcha liá'a lichálujuedau liá'a Wawásimica. ");
INSERT INTO aca_vpl VALUES ("EP6_12","079_6_12","EPH","6","12","12","Jiníwata jócani íinua yáacau wayáca chóniwenai júnta náa'a wáalianai náinau ya iyájii, báawachata, najúnta náa'a demonio jócani wáalia náinaa ya nayájideu lécchoo, ne wáalianai danáanshi máanui nawánacaalau'inaa líta'aa liáni cáinabica catáwacaica ríjcuederri wayá. ");
INSERT INTO aca_vpl VALUES ("EP6_13","079_6_13","EPH","6","13","13","Tándawa, iwínau quinínama liá'a arma Dios yáni irrú, quéewique'e éewa iwántaca liá'a éerri jáicta Wawásimi líinu ináculai, ya liáwinaami néenee lichúniu sáica, iyáque'e cabálininaa. ");
INSERT INTO aca_vpl VALUES ("EP6_14","079_6_14","EPH","6","14","14","Tándawa, nuéenajinai, iyáyu cadánani, isúwa íibalau liá'a yáawaiyica, léjta áabai íibalashi, itúyau iméda quinínama liá'a machácanica. ");
INSERT INTO aca_vpl VALUES ("EP6_15","079_6_15","EPH","6","15","15","Iyá séewirrinaa sáica ijiáque'iu íiwadeda liá'a lichuáni sáictaica wána iwówa. ");
INSERT INTO aca_vpl VALUES ("EP6_16","079_6_16","EPH","6","16","16","Quéechanacu sái quinínama, lishínaa liá'a léebidauca léjta áabai escudo túyerri iyá lipúyani túculerricoo chicháiyu, Wawásimi yúcani inácula. ");
INSERT INTO aca_vpl VALUES ("EP6_17","079_6_17","EPH","6","17","17","Liá'a ishínaa wásedeerri iyá chái léjta áabai casco túyerri iwíta nácu, ya liá'a Dios chuánica léjta liá'a espadaca Espíritu Santo yáni irrú. ");
INSERT INTO aca_vpl VALUES ("EP6_18","079_6_18","EPH","6","18","18","Iyá u'imáaca liá'a isátaucoo, isátau wérri Dios yúcha mamáarraca, yáau Espíritu Santo yáajcha. Iyá cawíteeniyu, uyúrrucueda iwówau, ya isáta Dios yúcha lécchoo quinínama lishínaa chóniwenai nácu. ");
INSERT INTO aca_vpl VALUES ("EP6_19","079_6_19","EPH","6","19","19","Isáta Dios yúcha nunácu, quéewique'e Dios yáa nulí chuánshi numáni'inaa, ya nuéewaque'e nutáania jócai cáarru, ya nuyá éewerri nuíiwacani liá'a Dios máanimi cabáyainta liyácala sáicai chuánshi nácu. ");
INSERT INTO aca_vpl VALUES ("EP6_20","079_6_20","EPH","6","20","20","Dios bánua nuyá lijí'inaa lícuu nutée liáni lichuánica, chóque'e linácueji liáni lichuánica nawáalia nuyá cuíta manúmai rícula. Isáta Dios yúcha quéewique'e nutáania linácu liá'a lichuáni jócubeecha cáarru nuyá. ");
INSERT INTO aca_vpl VALUES ("EP6_21","079_6_21","EPH","6","21","21","Tíquico, washínaa wéenajirri caníinai wacábaca, ya séewirri yúda wayá tráawaju Wawácalirru, litéeminaa quinínama liá'a chuánshica nunácu ya liá'a numédani nuyáca. ");
INSERT INTO aca_vpl VALUES ("EP6_22","079_6_22","EPH","6","22","22","Tándawa nubánua irrúni, quéewique'e líiwa irrú chítashia wayáyu jíni, chacábacanaa liá idánani. ");
INSERT INTO aca_vpl VALUES ("EP6_23","079_6_23","EPH","6","23","23","Liá'a Dios Wasálijinaa ya Wawácali Jesucristo, liáque'e irrú iyá wéenajinaica sáitaque'e iwówa yáca ya caníinaaque'e icába yáacacoo, liyú liá'a éebidauca. ");
INSERT INTO aca_vpl VALUES ("EP6_24","079_6_24","EPH","6","24","24","Dios liáque'e lishínaa sáicai nanácu quinínama caníinaani cába Wawácali Jesucristo caníinaiyu mamáarraca.");
INSERT INTO aca_vpl VALUES ("H11_1","082_1_1","1TH","1","1","1","Nuyá Pablo liájcha liá'a Silvano ya Timoteo, nutána liáni cáashtaca iyá'inaa nuéenajinai iglesia ísanaca liá'a chacáalee jí'ineerri Tesalónica, yáainai áabenaa nawówa Dios Lisálijinaa yáajcha ya Wawácali Jesucristoca. Dios yáa irrú sáicai wérri ya sáictaque'e iwówa iyáca. Liá'a nawítee sáicaica nanácu náa éebidenai náa'a chóniwenai yáainai Tesalónica rícu. ");
INSERT INTO aca_vpl VALUES ("H11_2","082_1_2","1TH","1","2","2","Séewirrinaa wáa sáicai Diosru inácueji quinínama, ya wédacaniu inácu jáicta wasátau Dios yúcha. ");
INSERT INTO aca_vpl VALUES ("H11_3","082_1_3","1TH","1","3","3","Éerri jútainchu wédacaniu inácu lináneewa liá'a Dios Wasálijinaaca, linácu liá'a éebidani nácu itráawajaacala, iwówa yáajchau isírbiacala lirrú bájialanaa ya liá'a máanui wérrica inéndanica Wawácali Cristo nácu, quinínama liérra liyúda iyá liá'a idánani ya danáanshi iwántaque'e liá'a carrúni jináatabeeca. ");
INSERT INTO aca_vpl VALUES ("H11_4","082_1_4","1TH","1","4","4","Nuéenajinai, Dios caníinai cába iyá, ya wáa léenaa liwína iyá. ");
INSERT INTO aca_vpl VALUES ("H11_5","082_1_5","1TH","1","5","5","Ne jáicta wayá wáiiwadeda irrú liá'a chuánshica wásedeerri'inaa, jócai bábajuta chuánshiyu, lécchoo liá'a lidánaniyu liá'a Espíritu Santoca ya quinínama yáawai wérri liáni chuánshi yáawaiyiica. Yáani léenaa chítashia wayáyu jíni íibi, wamúrru sáicai irrú. ");
INSERT INTO aca_vpl VALUES ("H11_6","082_1_6","1TH","1","6","6","Iyá inácueji, iwína wawítee, ya liwítee liá'a Wawácali, ya irríshibia liá'a chuánshica sáictai wówashiyu Espíritu Santo yáani irrú, báawitate nawána carrúni jináata iyáca, náa'a jócani éebida Cristo nácu. ");
INSERT INTO aca_vpl VALUES ("H11_7","082_1_7","1TH","1","7","7","Chacábacanaa íinu imédaca sáicai iwítee nalí náa'a quinínama náa'a éebidenai Dios nácu, náa'a yáainai cáinabi jí'ineerri Macedonia ya Acaya. ");
INSERT INTO aca_vpl VALUES ("H11_8","082_1_8","1TH","1","8","8","Jiérriu inácueji, liá'a Wawácali chuánica cáarralerriu jócaita bácai Macedonia rícu ya Acaya rícu, ya quinínama liáni cáinabica lécchoo, ya náa léenaa éebida Dios nácu, tánda wayá jócu arrúnaa watáania mawí quinínama linácu jiliáni. ");
INSERT INTO aca_vpl VALUES ("H11_9","082_1_9","1TH","1","9","9","Ne báawachata, nayája táanianai linácue liá'a wamá'inau néerra, ya sáicai wérri irrú iwína wayá, ya chítashia imáacau'inaa náji náa'a ídoloca, quéewique'e isíguia liá'a Dios cáwiica yáawaiyiica ya quéewique'e ichánau isírbia lirrú. ");
INSERT INTO aca_vpl VALUES ("H11_10","082_1_10","1TH","1","10","10","Cha lécchu náiiwacani inéndaca iyá quéewique'e léejocoo áaqueji liá'a Jesúsca, Dios Cúuleeca, liá'a Dios cáwedanica máanalini íibicha. Jesús liyá'inaa wáseda wayá liúcha liá'a máanui wérri carrúnataica íinuerri'inaaca. ");
INSERT INTO aca_vpl VALUES ("H12_1","082_2_1","1TH","2","1","1","Iyá jájiu, nuéenajinai, yáine léenaa liá'a wéewidau iyá jócai'inaa mawéni. ");
INSERT INTO aca_vpl VALUES ("H12_2","082_2_2","1TH","2","2","2","Mawí sáica, áawita yáa léenaa jíni, báawita quéechami nacáitadeda wayá ya náiinueda wayá lirrícu liá'a chacáalee jí'ineerri Filipos, Dios yúda wayá wáiiwaque'e irrú liá'a lichuánica wásedeerri'inaaca iyá, jócu cáarru wayá béewami lirrú liá'a danáanshi carrúnataica. ");
INSERT INTO aca_vpl VALUES ("H12_3","082_2_3","1TH","2","3","3","Níwata wayá jócani yúcau wayáca linácu liá'a wéewidani nácu, jiní watáaniacala máashii wíteeshiyu, jiní wawówaicala wachálujueda wamácoo áabi. ");
INSERT INTO aca_vpl VALUES ("H12_4","082_2_4","1TH","2","4","4","Báawachata, Dios nísa léeneda wayá, ya limáaca wayá quéewique'e wáiiwa liá'a chuánshica wásedeerri, cháwa cábacanaa watáaniaca. Jócaita wawánaque'e sáicta chóniwenai wówa wáajcha, Diosru wáa wamédani, léewa cáberri wawówa. ");
INSERT INTO aca_vpl VALUES ("H12_5","082_2_5","1TH","2","5","5","Léjta yáayu léenaa, jócai cáji watáania irrú chuánshi sáictaica, jiní wachálujuedaca wamácoo iyá wéedaque'e yúcha warrúwa. Dios yáirri léenaa quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("H12_6","082_2_6","1TH","2","6","6","Jócai cáji wamúrru sáicai walíwau wayá jájiu, jiní yúcha, jiní áabi yúcha. ");
INSERT INTO aca_vpl VALUES ("H12_7","082_2_7","1TH","2","7","7","Báawita wéewa waméda wawánacaalau inácu, jiníwata wayá wánacaleenai chaléjta apóstolubini Cristo nácuji, wayá wéewacta caníinaa wérri wacábacoo íibi. Chaléjta báquetoo íinetoo dáwinechocta ya rutúya chúnsai ruéenibiu. ");
INSERT INTO aca_vpl VALUES ("H12_8","082_2_8","1TH","2","8","8","Chái cábacanaa caníinaa wérri wacába iyá, wawówaicta wáa irrú sáicai chuánshi Dios shínaa, jóctacala wáa irrú wacáwicau inácueji lécchoo. ¡Caníinaacala wérri wacába iyá! ");
INSERT INTO aca_vpl VALUES ("H12_9","082_2_9","1TH","2","9","9","Nuéenajinai, éedacaniu chítashia watráawajaayumi jíni ya yáacaliyu wérri quéewique'e wéewa wawáalia quinínama liá'a warrúnaanica wacáwicarru. Watráawajaa éerrinacu ya táayee, quéewique'e jócubeecha imá iyáca jáicala itúya wayá nácula wáiiwadedanimi irrú Dios chuánica, tándawa waméda chámai tráawaju báitanacu. ");
INSERT INTO aca_vpl VALUES ("H12_10","082_2_10","1TH","2","10","10","Iyá éewenai yáa léenaa sáicaica, ya Dios lécchoo, wayáca jiní máashii wamédani, wayácala machácani, jiní éewerri lijútacoo wanácu iyá éebidenai Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H12_11","082_2_11","1TH","2","11","12","Ya iyá yáine léenaa lécchoo, wayácala yáine idánani ya sáicta iwówa bácainaa iyá, léjta lisálijinaa yáayu'u léenibi wíteu. Wamánimi irrú quéewique'e sáica iyáca léjta náa'a Dios shínaaca, limáidacaalami iyá quéewique'e iwáalia ishínau liwánacaalactaca cadánani wíteeshiyu balíbalictalaca. ");
INSERT INTO aca_vpl VALUES ("H12_13","082_2_13","1TH","2","13","13","Linácueji wáa sáicai Diosru séewirrinaa, quéecha'inaami éemi liá'a Dios chuánica liá'a wáiiwadedani irrú, irríshibiani yáawai wérri léjta Dios chuáni, ne jócai chaléjta washiálicuenai chuáni. Ne yáawaiyi Dios chuánicaa, liáni chuánshica sáicai wérri méda irrú éebidenaica. ");
INSERT INTO aca_vpl VALUES ("H12_14","082_2_14","1TH","2","14","14","Quéecha'inaami iyá nuéenajinai, carrúni jináata nacánaqueda iyá nacáaji rícueji náa'a chóniwenaica éenaaca, ibésunau léjta náa'a iglesia Dios shínaaca yáanai Judea cáinaberra íta'aa, Jesucristo shínaaca, nayá lécchoo cháni cábacanaa nacánaqueda nacáaji rícueji náa'a chóniwenai néenaaca, judíobinica. ");
INSERT INTO aca_vpl VALUES ("H12_15","082_2_15","1TH","2","15","15","Náani judíobini náiinuate Wawácali Jesús, léjta quéecha náiinua náa'a éewidenai Dios chuáni báinacu, náwa nabánua bináawala wayá. Jócai naméda sáicai Diosru yáaine lijúnta quinínama. ");
INSERT INTO aca_vpl VALUES ("H12_16","082_2_16","1TH","2","16","16","Wawówaicta watáaniaque'e nalí náa'a jócani judío, quéewique'e nawásedacoo lécchoo, náa'a judíobini jócai náinda wamédaca. Chacábacanaa jáica cashiámu jíni najíconauyu jíni. Ne chóque'e, ya ta, líinu cái liá'a máanui wérri carrúnatabee Dios shínaaca íinuerri nátala. ");
INSERT INTO aca_vpl VALUES ("H12_17","082_2_17","1TH","2","17","17","Nuéenajinai, quéecha'inaa wadánacoo yúcha íchaitaa, báawita jóca wacába iyá, séewirrinaa wédacanicoo wawáalia iyá wawówa lícuu ya wawówai iyá bájialanaa wáacoo wacába iyá. ");
INSERT INTO aca_vpl VALUES ("H12_18","082_2_18","1TH","2","18","18","Wawówai metá, wáacajau chaléjta nuyá Pablo, íchabachu nuwówai numédacani, ne liá'a Wawásimica jócu línda wamédaqui jíni. ");
INSERT INTO aca_vpl VALUES ("H12_19","082_2_19","1TH","2","19","19","Ne ¿tána léji liá'a washínaa wanéndanica, washínaa sáictai wérri wawówa, sáicta wérri wawówa bájialanaa, ya sáicta wawówa cábacoo wayá jájiu? ¡Iyáwajani jáicta léejocoo washínaa Wawácali Jesucristo! ");
INSERT INTO aca_vpl VALUES ("H12_20","082_2_20","1TH","2","20","20","Jajá, iyáwa wánenai sáicta wawówa bájialanaa, éewauna sáicta wawówa. ");
INSERT INTO aca_vpl VALUES ("H13_1","082_3_1","1TH","3","1","1","Néenee quéecha'inaa jócu nuwánta mawí, jáiwa nuwówai numáacacoo nuyá bácai, chacáalee jí'ineerri Atenas. ");
INSERT INTO aca_vpl VALUES ("H13_2","082_3_2","1TH","3","2","2","Nubánua washínaa wéenajirri Timoteo, liyá cayúdacaica Dios chuáni nácu, quéewique'e líiwa sáicai chuánshica Cristo nácue sái. Nubánuani quéewique'e liácoo licába iyá, liáque'e idánani quéewique'e néebida mamáarraca Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H13_3","082_3_3","1TH","3","3","3","Quéewique'e jócu yúrrucueda iwówau áawita líinu wátala liá'a máashiica. Ne iyá jájiu yáine léenaa arrúnaaca carrúni jináata wamédacoo quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("H13_4","082_3_4","1TH","3","4","4","Ya mawí, quéecha'inaate wayá yáajcha újnibii, wáiiwa irrú jíni wawáaliacala'inaa máashii wawówau, cháwa libésunacuwai, léjta yáayu léenaa. ");
INSERT INTO aca_vpl VALUES ("H13_5","082_3_5","1TH","3","5","5","Tándawa, jócu nuwánta mawí, nubánua lisáta léemiu chítashia iyáqui jíni éebidau Dios nácu, ne cáarru nuyá jócubeecha Wawásimi dáana iyá máashictalaca ya washínaa tráawaju yúcacoo. ");
INSERT INTO aca_vpl VALUES ("H13_6","082_3_6","1TH","3","6","6","Ne chóque'e Timoteo éejuerriu Tesalónica néenee, línda walí sáicai chuánshica éebidauca, ya caníinaa icába yáacacoo. Limá walí séewirrinaa édacanicoo nácu caníinaiyu, ya iwówai icába wayá, léjta wawówai wacába iyá lécchoo. ");
INSERT INTO aca_vpl VALUES ("H13_7","082_3_7","1TH","3","7","7","Táda liáni chuánshica, nuéenajinai, áawita íchaba carrúnataica ya máashii wówa, ne sáicta wawówa bájialanaa wáaca léenaa yáaineu cabálininaa éebidauca Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H13_8","082_3_8","1TH","3","8","8","Ne wáa léenaa iyá sáica Wawácali chuáni nácu, wáne cadánani wawówa. ");
INSERT INTO aca_vpl VALUES ("H13_9","082_3_9","1TH","3","9","9","¿Chítata wéewa wáa sáicai wérri mawí washínaa Diosru inácue ya le sáicta wérri wawówa iwánaca lináneewa liá'a Diosca? ");
INSERT INTO aca_vpl VALUES ("H13_10","082_3_10","1TH","3","10","10","Éerrinacu ya táayenaa wasáta liúcha liá'a Diosca, quéewique'e léejueda wayá bániu wacábaque'e wanáni wáacoo, wachúnique'e wáa irrú liá'a cháuctai irrú liá'a éebideni Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H13_11","082_3_11","1TH","3","11","11","Wawówai liyáque'e Diosja Wasálijinaaca ya Wawácali Jesúsca, liyúda wayá quéewique'e wáacoo wacába iyá, ya watráawajaaque'e yáajcha mawí. ");
INSERT INTO aca_vpl VALUES ("H13_12","082_3_12","1TH","3","12","12","Quéewique'e Wawácali liwána idáwinaacoo, ya iwáaliaque'e mawí caníinaabee icába yáacacoo yáajcha wáacoo, ya quinínama yáajcha, léjta caníinau'u wacába iyá. ");
INSERT INTO aca_vpl VALUES ("H13_13","082_3_13","1TH","3","13","13","Quéewique'e liyá cabálininaa iwówa rícu, ya majíconaa lináneewa liá'a Diosca Wasálijinaa, jáicta léejocoo Wawácali Jesús quinínama náa'a éebidenai linácu. Chácajani. ");
INSERT INTO aca_vpl VALUES ("H14_1","082_4_1","1TH","4","1","1","Chócojoo, nuéenajinai, wasáta irrú ya numá irrú liáni lijí'inaa nácu liá'a Wawácali Jesúsca: Quéewique'e iyá sáica imédaque'e (léjta séewirrinaa iméda yáacuwani) léjta wéewidau'u iyá, quéewique'e sáicta Dios cába iyá. ");
INSERT INTO aca_vpl VALUES ("H14_2","082_4_2","1TH","4","2","2","Iyá yáine léenaa liá'a wéewidani iyá nácu, liwánacaala nácu liá'a Wawácali Jesúsca. ");
INSERT INTO aca_vpl VALUES ("H14_3","082_4_3","1TH","4","3","3","Liá'a Dios wówaini yúcha quéewique'e iyá lirrú majíconaa, jiníbeecha méderri máashii lijíconaa líinaayu. ");
INSERT INTO aca_vpl VALUES ("H14_4","082_4_4","1TH","4","4","4","Quéewique'e bácainaa náa léenaa sáicaque'e liyá líinu yáajchau, jiní jíconaa cawáuntai líinu yáajchau. ");
INSERT INTO aca_vpl VALUES ("H14_5","082_4_5","1TH","4","5","5","Jócaita lijíconaa yáajcha ya máashii wówashi yáajcha, léjta náa'a chóniwenai jócani yáa léenaa Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H14_6","082_4_6","1TH","4","6","6","Jiní chóniwenai méderri máashii, jiní lichálujuedacala áabi linácu liáni, jiníwata Wawácali carrúnatai wérri quinínama liáni jíconaashi, léjta wanísau'u wáiiwami irrúni. ");
INSERT INTO aca_vpl VALUES ("H14_7","082_4_7","1TH","4","7","7","Ne Dios jócai máida wayá quéewique'e wayá wajíconaa rícuu, máiderri wayá quéewique'e wayá sáica lirrú. ");
INSERT INTO aca_vpl VALUES ("H14_8","082_4_8","1TH","4","8","8","Cháwajani, liá'a cháaneerri liáni wéewidacala, jócai cháani washiálicuerri bácai, cháaneerri liyá quéechanacu Dios, liá'a yáirri lishínaa Espíritu Santo irrú. ");
INSERT INTO aca_vpl VALUES ("H14_9","082_4_9","1TH","4","9","9","Ne linácu liá'a caníinaabee icába yáacacoo, éenajinai wáacoo, jócu rúnaa watána irrú, jiníwata Diosja liyá éewida caníinaa icába yáacacoo. ");
INSERT INTO aca_vpl VALUES ("H14_10","082_4_10","1TH","4","10","10","Ne léji liáni imédani náajcha quinínama náa'a éenajinai yáainai liá'a cáinabi jí'ineerri Macedonia. Ne wasáta yúcha, wéenajinai, caníinaaque'e icába yáacacoo mamáarraca. ");
INSERT INTO aca_vpl VALUES ("H14_11","082_4_11","1TH","4","11","11","Éenedate iyá machúnuca ya iméda chúnsai ishínau, itráawajaa icáajiyu, léjta wawánau imédacani. ");
INSERT INTO aca_vpl VALUES ("H14_12","082_4_12","1TH","4","12","12","Quéewique'e cawáunta nacába iyá náa'a yáainai, bináawe jócani éebida, ya quéewique'e jiní cháucta irrú. ");
INSERT INTO aca_vpl VALUES ("H14_13","082_4_13","1TH","4","13","13","Nuéenajinai, jócai wawówai imáacacoo jócta yáa léenaa liá'a bésuneerri náacoo náajcha náa'a máanalinimica, quéewique'e iyá jócu máashii wówa léjta náa'a áabica, jiníni nénda nayáca. ");
INSERT INTO aca_vpl VALUES ("H14_14","082_4_14","1TH","4","14","14","Léjta wéebidau quéecha'inaa máanali Jesús, ya liáwinaami licáwiawai máanalicai yúcha, cháwa wéebida lécchoo, Dios cáwedeerri'inaa Jesús yáajcha, náa'a máanalinimica éebidenai linácu. ");
INSERT INTO aca_vpl VALUES ("H14_15","082_4_15","1TH","4","15","15","Tánda wamá irrú, léjta Wawácali éewidau'u, wayá máaquenaicoo cáwi cáashia léejocoo liá'a Wawácalica, jócuminaa wáau nabéecha náa'a máanalinimica. ");
INSERT INTO aca_vpl VALUES ("H14_16","082_4_16","1TH","4","16","16","Jiníwata wéemiminaa áabai chuánshi cadánani wérri, lichuáni liá'a ángel wánacaleerri ya liwítama liá'a trompetaca Dios shínaaca. Liyáminaaja Wawácali Jesús yúrrucuerri'inau áaqueji. Ya náa'a máanalinimica éebidenaimi Cristo nácu, nacáwiauminau quéechanacu; ");
INSERT INTO aca_vpl VALUES ("H14_17","082_4_17","1TH","4","17","17","liáwinaamijoo, wayá cáwininaica, litéeminaa wayá liájchaujoo, áabenaaque'e wacába yáacacoo náajcha sánai íibirra, quéewique'e wajúnteda Wawácaliu cáuli íibi; cháminaa wayá liájcha liá'a Wawácalica mamáarraca éerri. ");
INSERT INTO aca_vpl VALUES ("H14_18","082_4_18","1TH","4","18","18","Ya idánani yáacau liyú liáni chuánshica. ");
INSERT INTO aca_vpl VALUES ("H15_1","082_5_1","1TH","5","1","1","Ne linácu liá'a éerrica ya léerdi'inaaca, nuéenajinai, jócai arrúnaa nutána irrú. ");
INSERT INTO aca_vpl VALUES ("H15_2","082_5_2","1TH","5","2","2","Iyá yáine léenaa sáica, liá'a éerri léejocta'inaacoo, liá'a Wawácalica íinuerri'inaa jócacta wanénda wayácani, léjta báqueerri canédi íinuerri táayee linéduca. ");
INSERT INTO aca_vpl VALUES ("H15_3","082_5_3","1TH","5","3","3","Jáicta namá náa'a chóniwenaica: “Quinínama yáairri sáica wérri, jiní bésuneerriu”, néeneeminaa líinu cawíquinta náta'aa limárdactana nayá, léjta líinu rulí cáiwibeeca ruá'a íinetooca cúlicuecho'inaaca, jiníminaa náctalau liúcha. ");
INSERT INTO aca_vpl VALUES ("H15_4","082_5_4","1TH","5","4","4","Ne iyá, nuéenajinai, jócai yáa mawítee mawiá, quéewique'e liá'a éerrica líinucta'inaa liá'a Wawácalica licáarruda iyá léjta báqueerri canédi. ");
INSERT INTO aca_vpl VALUES ("H15_5","082_5_5","1TH","5","5","5","Iyá quinínama éebidenai Wawácali nácu, léwa iyáyu'u léjta jucámarrabee, cámarra lícuu, jócaita léjta táayebee catáwacabeeca; ");
INSERT INTO aca_vpl VALUES ("H15_6","082_5_6","1TH","5","6","6","tándawa jócu wéewa mawítee wayáca léjta náa'a áabica, arrúnaa wayá cáwi ya wawítee sáicaque'e wayáca. ");
INSERT INTO aca_vpl VALUES ("H15_7","082_5_7","1TH","5","7","7","Náa'a mawíteenica cháni léjta náa'a máainai éerri nácu, chaléjta náa'a cámadedeenai éerri nácu; ");
INSERT INTO aca_vpl VALUES ("H15_8","082_5_8","1TH","5","8","8","ne wayá yáainai jucámarra jirrícu, arrúnaa wayá séewirrinaa sáicai wíteeshiyu. Wayá éebidenaica, arrúnaa wamúrruca watúya'inau wayáu sáica, jócubeecha waméda máashii wajíconaacoo. Táda arrúnaa wéebidaca Jesucristo chuáni sáica, ya jéewique'e caníinaa wacába yáacacoo, ya jéewique'e wamáaca wawówau Jesucristo nácu, liwásedaque'e wayá Dios shínaa carrúnatai yúcha. ");
INSERT INTO aca_vpl VALUES ("H15_9","082_5_9","1TH","5","9","9","Jiníwata Dios jócai shírri wayá quéewique'e warríshibia carrúnatabee, Dios shírri wayá quéewique'e wéenaa wáacoo áacairra linácueji liá'a Wawácali Jesucristo. ");
INSERT INTO aca_vpl VALUES ("H15_10","082_5_10","1TH","5","10","10","Jesucristo máanali wanácueji, quéewique'e báawita cáwi wayá, o máanali wayá, quéewique'e wayá liájcha mamáarraca. ");
INSERT INTO aca_vpl VALUES ("H15_11","082_5_11","1TH","5","11","11","Tándawa, yáa idánani wáacoo, ya danáanshiyu icába inácu wáacoo, chái léjta imédau iyácajani. ");
INSERT INTO aca_vpl VALUES ("H15_12","082_5_12","1TH","5","12","12","Wéenajinai, wasáta yúcha cawáuntaque'e icába náa'a tráawajenai íibi, náa'a yáaine iwítee ya éewidenai sáicai chuánshi Wawácali nácu. ");
INSERT INTO aca_vpl VALUES ("H15_13","082_5_13","1TH","5","13","13","Arrúnaa iwówaica ya caníinaa wérri icába nayá, linácueji liá'a tráawaju namédanica. Sáictaque'e iwówa iyá wáacoo. ");
INSERT INTO aca_vpl VALUES ("H15_14","082_5_14","1TH","5","14","14","Wéenajinai, Wamá irrú lécchoo, yáarraque'e náa'a jiníni wówai namédaca. Yáa nadánani náa'a máajinaani Dios chuáni nácu, iyúdaque'e náa'a madánaninica ya iwántaque'e chaijiwítemija'a quinínama yáajcha. ");
INSERT INTO aca_vpl VALUES ("H15_15","082_5_15","1TH","5","15","15","Icábawa yúchaujoo jócubeecha éejueda júnibai irrú wáacoo. Báawachata, arrúnaa iméda mamáarraca liá'a sáicaica, chacábacanaa yáajcha wáacoo ya quinínama chóniwenai yáajcha. ");
INSERT INTO aca_vpl VALUES ("H15_16","082_5_16","1TH","5","16","16","Sáicta iwówa éerri jútainchu. ");
INSERT INTO aca_vpl VALUES ("H15_17","082_5_17","1TH","5","17","17","I'óra éerri jútainchu. ");
INSERT INTO aca_vpl VALUES ("H15_18","082_5_18","1TH","5","18","18","Yáa sáicai Diosru quinínama nácu, jiníwata léwa liwówaini yúcha, léjta éebidenai Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("H15_19","082_5_19","1TH","5","19","19","Ujóca imá jáicta Espíritu Santo wána imédaqui jíni. ");
INSERT INTO aca_vpl VALUES ("H15_20","082_5_20","1TH","5","20","20","Ujicháani liá'a chuánshica Dios wánani natáaniaca. ");
INSERT INTO aca_vpl VALUES ("H15_21","082_5_21","1TH","5","21","21","Éenedani quinínama ya iwína liá'a sáicaica. ");
INSERT INTO aca_vpl VALUES ("H15_22","082_5_22","1TH","5","22","22","Ishírriu quinínama méenaami máashii yúcha. ");
INSERT INTO aca_vpl VALUES ("H15_23","082_5_23","1TH","5","23","23","Ne Diosja, liá sáicaica, liméda iyá sáica wérri majíconaanica lijí'inaa nácu, ya litúya iyá quinínama inácu sáica, iwówa, icáwica ya ináanai jiní cháucta irrú libéecha liá'a líinucta'inaa Wawácali Jesucristoca. ");
INSERT INTO aca_vpl VALUES ("H15_24","082_5_24","1TH","5","24","24","Liá'a Dios máiderri iyá machácani wérri, ya licúmpliaminaa quinínama liáni. ");
INSERT INTO aca_vpl VALUES ("H15_25","082_5_25","1TH","5","25","25","Nuéenajinai, isáta Dios yúcha wanácu lécchoo. ");
INSERT INTO aca_vpl VALUES ("H15_26","082_5_26","1TH","5","26","26","Itáa nalí quinínama náa'a wéenajinaica áabai ishíshicani majíconaiyu. ");
INSERT INTO aca_vpl VALUES ("H15_27","082_5_27","1TH","5","27","27","Numáca irrú, Wawácali jí'inaa nácu, iliá'que'e liáni cáashtaca quinínama wéenajinai éebidenaicarru. ");
INSERT INTO aca_vpl VALUES ("H15_28","082_5_28","1TH","5","28","28","Quéewique'e Wawácali Jesucristo yáa irrú sáicabeeca quinínama irrú.");
INSERT INTO aca_vpl VALUES ("H21_1","083_1_1","2TH","1","1","1","Nuyá Pablo, liájcha liá'a Silvano ya Timoteo, nutána liáni cáashtaca iyá'inaa nuéenajinaica iglesia ísanaca liá'a chacáaleeca jí'ineerri Tesalónica, yéenai áabenaa nawówa Dios Wasálijinaa ya liá'a Wawácali Jesucristoca. ");
INSERT INTO aca_vpl VALUES ("H21_2","083_1_2","2TH","1","2","2","Nusáta Dios Wasálijinaa yúcha ya Wawácali Jesucristo yúcha liá irrú mawénii ya liáque'e irrú sáitau'i iwówa inácu. ");
INSERT INTO aca_vpl VALUES ("H21_3","083_1_3","2TH","1","3","3","Nuéenajinai, séewirrinaa warrúnaa wáa sáicai Diosru inácue, níwata rúnaaca wamédacani, níwata liá'a éebidanica dáwinerriu liácoo ya liá'a caníinaabee icába yáacacoo, mawí máanui éerri jútainchu. ");
INSERT INTO aca_vpl VALUES ("H21_4","083_1_4","2TH","1","4","4","Táda, wayá jájiu watáania inácu sáica wérri iglesia rícu Dios shínaaca, linácue liá'a danáanshica ya liá'a éebidauca íyadani, béewami lirrú liá'a quinínama nacánaquedaniyu iyá, ya máashiica nawána ya carrúni jináatabee íibi. ");
INSERT INTO aca_vpl VALUES ("H21_5","083_1_5","2TH","1","5","5","Liáni Dios íyada liyáu machácani léjta liyá limédanica, liwáaliaca iyá sáica iwárrua'inau liwánacaalactalaca, linácueji liá'a carrúni jináata iyáca. ");
INSERT INTO aca_vpl VALUES ("H21_6","083_1_6","2TH","1","6","6","Ne Dios méderri machácaniyuni liwánaca carrúni jináata namédacoo náa'a wánenai carrúni jináata iyá; ");
INSERT INTO aca_vpl VALUES ("H21_7","083_1_7","2TH","1","7","7","Ya iyá náa'a carrúni jináatanica, liáminaa irrú iwówa íyabacta'inaacoo léjta wayá. Liáni bésuneerri'inau liyáali éerri, jáicta Wawácali Jesús íinujoo lishínaa ángelbini cadánaninica, líinuminaa áaqueji íibi liá'a chichái cámarraca. ");
INSERT INTO aca_vpl VALUES ("H21_8","083_1_8","2TH","1","8","8","Íinuerri'inaa liméda nayá carrúni jináata náa'a jócani wówai Dios, jiní namédacala Wawácali Jesús chuáni wánacaala, wásedeerri'inaata wayá máashii yúcha. ");
INSERT INTO aca_vpl VALUES ("H21_9","083_1_9","2TH","1","9","9","Náani carrúni jináataminaa liméda nayájoo cáiwinaa jóctala éewa amáarra nayá, ya táminaa liúca nayá déecuchala lináneewa yúchau liá'a Wawácali, ya lidánani ya licámarra yúchau. ");
INSERT INTO aca_vpl VALUES ("H21_10","083_1_10","2TH","1","10","10","Jáicta líinu liá'a Wawácalica liyáali éerriminaa, náa lirrú sáicai náa'a lishínaaca, ya sáicta wérri nawówa náa'a quinínama éebidenaica, ne iyájani éebida linácu liá'a wamáni irrú Jesús nácue sáica. ");
INSERT INTO aca_vpl VALUES ("H21_11","083_1_11","2TH","1","11","11","Wayá sátenai Dios yúcha inácu séewirrinaa, quéewique'e liméda iyá sáica éewaque'e iméda liá'a tráawaju limáidani iyá nácu. Wasáta Dios yúcha quéewique'e liyúda iyá imédaque'e liá'a sáicaica iwówaini imédaca, ya éewaque'e iméda náa'a tráawaju éebidauca idánani yáajchau Dios nácu. ");
INSERT INTO aca_vpl VALUES ("H21_12","083_1_12","2TH","1","12","12","Chacábacanaa, lijí'inaa nácu liá'a Wawácali Jesúsca náaminaa lirrú sáicai inácueji, ya liyá liáminaa irrú sáicai léjta licábacanaa caníinaabeeca washínaa Dios, ya Wawácali Jesucristo shínaaca. ");
INSERT INTO aca_vpl VALUES ("H22_1","083_2_1","2TH","2","1","1","Chóque'e, nuéenajinai, ne linácu liá'a léejuacta'inaacoo Wawácali Jesucristoca ya wáawacacta'inaacoo liájcha, wasáta yúcha, ");
INSERT INTO aca_vpl VALUES ("H22_2","083_2_2","2TH","2","2","2","quéewique'e jócu ináawida iwíteu madéjcanaa, jiní índaca nacáarruda iyá, áawita báqueerri máca espíritu táaniacala lirrú, jócta máirri jáicala wéewida jíni, o watánaca lirrú áabai cáashta, jáicala wamái Wawácali éerri jái íinu cái. ");
INSERT INTO aca_vpl VALUES ("H22_3","083_2_3","2TH","2","3","3","¡O'índa nachálujueda iyá jiní wérri nácuejoo! Libéechajoo liá'a éerrica chóniwenai náasacalaminaajoo liá'a Dios máni'inaacucha, jáicta lijiáujoo liá'a washiálicuerri máashiicai wérrica, liá'a yúqueerri'inaacoo amáarraca. ");
INSERT INTO aca_vpl VALUES ("H22_4","083_2_4","2TH","2","4","4","Léwa lijínai bárruerriu lijúnta náa'a quinínama téenai Dios jí'inaa, o arrúnaa náa sáicai wérri liúcha, ya lécchoo líinuminaa limáaca liárrubaiu Dios íibana rícu, limáminaajoo liyá waliá Dios, liá lirrú sáicai. ");
INSERT INTO aca_vpl VALUES ("H22_5","083_2_5","2TH","2","5","5","¿Jócu édacaniu nutáania'inaami irrú linácu liáni nuyá'inaami yáajcha? ");
INSERT INTO aca_vpl VALUES ("H22_6","083_2_6","2TH","2","6","6","Ya chóque'e iyá yáine léenaa tánashia chá'a bárrueda liyácani, quéewique'e jócu líiyadau jóctanaa léerdi íinuu. ");
INSERT INTO aca_vpl VALUES ("H22_7","083_2_7","2TH","2","7","7","Ne liá'a limédani cabáyainta máashiica, jái naméda nayácai liérra méenaami máashiica yáairri cabáyainta; cháucta bácai já'a léedacoo béewami liá'a wíneerri liyácani. ");
INSERT INTO aca_vpl VALUES ("H22_8","083_2_8","2TH","2","8","8","Néenee líiyadaminau liá'a máashiicaica, liá'a Wawácali Jesús líinuani'inaa linúma cálesayu, ya limárdani'inaa jáicta léejojoo lidánani cámarrayu. ");
INSERT INTO aca_vpl VALUES ("H22_9","083_2_9","2TH","2","9","9","Ne liárra máashiicaica, íinuerri'inaa Wawásimi dánaniyu; líinuminaa wíteeshi dánaniyu, ya limédaminaa chóniwenai náneewa jócai nacába cáji, quéewique'e lichálujueda nayá. ");
INSERT INTO aca_vpl VALUES ("H22_10","083_2_10","2TH","2","10","10","Ya limédaminaa quinínama máashiica, quéewique'e lichálujueda náa'a yáaine'inaacoo náucacoo, jócala nawówai néebidaca, ya jócu nawówai naméda Dios chuáni wánacaala, quéewiquinicta néenaa náacoo áacairra. ");
INSERT INTO aca_vpl VALUES ("H22_11","083_2_11","2TH","2","11","11","Tándawa, Dios índa nachálujueda nayá ya néebidaque'e liá'a númashi yúwicaca. ");
INSERT INTO aca_vpl VALUES ("H22_12","083_2_12","2TH","2","12","12","Quéewique'e náucacoo quinínama náa'a jócani wówai néebida liá'a yáawaiyiica, báawachata sáicta nawówa méda liá'a máashiica. ");
INSERT INTO aca_vpl VALUES ("H22_13","083_2_13","2TH","2","13","13","Ne wayá séewirrinaa arrúnaa wáa sáicai Diosru inácue, wéenajinai caníinaa licába iyá liá'a Wawácalica, jiníwata Dios wíneerri iyá quéewique'e iyá quéechanacu éenaaque'e íinu icáwicau Dios yáajcha, lirrícueji liá'a Espíritu wáneerri majíconaa iyá, ya liá'a yáawaiyii éebidani nácu. ");
INSERT INTO aca_vpl VALUES ("H22_14","083_2_14","2TH","2","14","14","Tándawa, Dios máida irrú lirrícueji liá'a chuánshi sáicai wayái íiwadeda irrú: Quéewique'e íinu iwáalia léenaa liá'a licámarra liá'a Wawácali Jesucristoca. ");
INSERT INTO aca_vpl VALUES ("H22_15","083_2_15","2TH","2","15","15","Tándawa, nuéenajinai, yáau machácani ya jócu imíya máecha liá'a wéewidau'u iyá wanáanacaiyu ya cáashta rícueji. ");
INSERT INTO aca_vpl VALUES ("H22_16","083_2_16","2TH","2","16","16","Wayá sáta Wawácali Jesucristocaja, ya Dios Wasálijinaa, caníinaaca licába wayá ya liá walí sáictaque'e wawówa mamáarraca, ya áabai sáicai wanéndani wayáca sáicacala liyá, ");
INSERT INTO aca_vpl VALUES ("H22_17","083_2_17","2TH","2","17","17","sáicta liméda iwówa ya limáaca cadánani iyáca, quéewique'e liá'a imánica ya liá'a imédanica sáicaque'ini quinínama. ");
INSERT INTO aca_vpl VALUES ("H23_1","083_3_1","2TH","3","1","1","Léwa liájumirra sái liáni, nuéenajinai, isáta wanácu, quéewique'e liá'a Wawácali chuáni líinu madéjcanaa quinínama cáinabi, quéewique'e caníinaa nacábacani, léjta libésunau yáajcha. ");
INSERT INTO aca_vpl VALUES ("H23_2","083_3_2","2TH","3","2","2","Isáta Dios yúcha lécchoo quéewique'e litúya wayá náucha náa'a chóniwenai máashiinica ya náa'a cajíconaanica, níwata jócai quinínama néebidaca. ");
INSERT INTO aca_vpl VALUES ("H23_3","083_3_3","2TH","3","3","3","Ne Wawácali liá'a machácanica, liyáminaa wáalia iyájoo machácani iwítee ya litúya iyá máashii yúcha. ");
INSERT INTO aca_vpl VALUES ("H23_4","083_3_4","2TH","3","4","4","Wawácali nácu wawáalia éebidani iyá imédacala iyáca, ya imédani'inaa mamáarraca, léjta wabánau'u imédacani. ");
INSERT INTO aca_vpl VALUES ("H23_5","083_3_5","2TH","3","5","5","Wawácali liyúda iyá caníinaaque'e icábaca yáacacoo, léjta Dios caníinaa licábaca, ya iwáalia carrúni jináatabee danáanshi Cristo nácu. ");
INSERT INTO aca_vpl VALUES ("H23_6","083_3_6","2TH","3","6","6","Nuéenajinai, wabánua lijí'inaa lícu liá'a Wawácali Jesucristoca, quéewique'e ishírricoo náucha náa'a wéenajinai jócani wówai natráawajaaca, ya jóca áabenaa nawítee linácu liá'a wéewidani iyá nácu. ");
INSERT INTO aca_vpl VALUES ("H23_7","083_3_7","2TH","3","7","7","Iyá yáine léenaa chítashia'eewo'u iyáqui jíni quéewique'e éewa iméda léjta wamédanica: Wayá séewirrinaa watráawajaaca quéecha'inaami wayá íibi, ");
INSERT INTO aca_vpl VALUES ("H23_8","083_3_8","2TH","3","8","8","jiní wáayacala íiyanibi mawéni, séewirri wapáidaca. Báawachata, watráawajaa yáacaliyu éerrinacu ya táayee, quéewique'e jócubeecha wáiinu waméda imánubaca quiní irrú. ");
INSERT INTO aca_vpl VALUES ("H23_9","083_3_9","2TH","3","9","9","Ne yáawaiyii natáa, wéewa wasáta yúcha iyúdaquinicta wayá, ne jócu cháa jíni, watráawajaa quéewique'e wáa irrú wacábacanau éewani'inaa iméda yácanaa. ");
INSERT INTO aca_vpl VALUES ("H23_10","083_3_10","2TH","3","10","10","Quéecha'inaa wayá yáajcha, wáa irrú chítashia arrúnaa iyáqui jíni: Liá'a jócai wówai litráawajaaca, chacábacanaa jócu líiya. ");
INSERT INTO aca_vpl VALUES ("H23_11","083_3_11","2TH","3","11","11","Ne wáa léenaa áabi éenaa, yáainai cháji'i jócani tráawajaa, níwata awátuini wérri, naníquicoo jóctalata néewa naníquicoo. ");
INSERT INTO aca_vpl VALUES ("H23_12","083_3_12","2TH","3","12","12","Náarra chóniwenaica wabánua nalí ya wamá nalí, liwánacaala nácu liá'a Wawácali Jesucristoca, quéewique'e natráawajaa cha nawíteemi já'a, néewaque'e nawáalia narrúnijinau. ");
INSERT INTO aca_vpl VALUES ("H23_13","083_3_13","2TH","3","13","13","Nuéenajinai, osámu iméda liá'a sáicaica. ");
INSERT INTO aca_vpl VALUES ("H23_14","083_3_14","2TH","3","14","14","Jócta áabi éenaa jócani méda wawánacaala liá'a watánani líta'aa liáni cáashtaca, éeda lituínaa tánashiajoni, ya u'iwína yáacau liájcha, quéewique'e báicani. ");
INSERT INTO aca_vpl VALUES ("H23_15","083_3_15","2TH","3","15","15","Ne jócu iwáalia ijínaiyu wáni, yáa liwítee léjta éenajirri. ");
INSERT INTO aca_vpl VALUES ("H23_16","083_3_16","2TH","3","16","16","Ya liyá jájiu Wawácali sáictactaca nawówa yáca, liá irrú sáictacta iwówa quinínama éerri ya matuínaami. Liá'a Wawácali yáa yáajcha quinínama. ");
INSERT INTO aca_vpl VALUES ("H23_17","083_3_17","2TH","3","17","17","Nuyá, Pablo, nutána irrú nutáayu irrú, chúnsai nucáaji yá nushínaa letrayu. Cháwa nutána nují'inau quinínama nushínaa cáashta nácu, cháwa nutánacani'i. ");
INSERT INTO aca_vpl VALUES ("H23_18","083_3_18","2TH","3","18","18","Ya Wawácali Jesucristo yáa irrú sáicai quinínama irrú.");
INSERT INTO aca_vpl VALUES ("T11_1","084_1_1","1TI","1","1","1","Nuyá, Pablo, apóstolu Jesucristo shínaa, bánuerriu Dios wánacaala nácu wásedeerri wayá, Wawácali Jesucristo, washínaa wanéndani wayáca. ");
INSERT INTO aca_vpl VALUES ("T11_2","084_1_2","1TI","1","2","2","Nutána jirrú liáni cáashta Timoteo, yáawayi nucúulee éebidani nácu, nuwówai Dios Wasálijinaa ya Cristo Jesús washínaa Wawácali yáa jirrú liwíteu, jishínaa carrúni jináatai ya sáictactaca jiwówa yáca. ");
INSERT INTO aca_vpl VALUES ("T11_3","084_1_3","1TI","1","3","3","Léjta jinísa numá jirrúi quéecha'inaa jóctanaa nuáu chaléeni cáinabi jí'ineerri Macedonia, quéewique'e jimáacacoo chacáalee jí'ineerri Éfeso, quéewique'e bánua nalí chóniwenai quéewique'e jócu néewida báawatai wíteeshica, ");
INSERT INTO aca_vpl VALUES ("T11_4","084_1_4","1TI","1","4","4","u'éemi nachuáni náa'a náiiwadedanimica ya chuánshi jócai amáarra nanácu náa'a nawérrinaibimica. Liáni wíteeshi téenai bácai nacáita yáacaque'iu, jócai éewa liwána liwáalia néebidauca liá'a Dios wówaini limédaca. ");
INSERT INTO aca_vpl VALUES ("T11_5","084_1_5","1TI","1","5","5","Liá'a Dios wówaini liméda liájcha liáni rúnaa caníinaa wacába yáacacoo, liájcha liá'a caníinaabee íinuerri áabai wówashi masáculai, áabai wíteeshi sáicai, ya áabai wéebidani yáawaiyica. ");
INSERT INTO aca_vpl VALUES ("T11_6","084_1_6","1TI","1","6","6","Áabi jiéneu báawachala liúcha liáni ya yúqueneu cáita yáaqueneu, jócai áanama nácueji. ");
INSERT INTO aca_vpl VALUES ("T11_7","084_1_7","1TI","1","7","7","Nawówaini namédacoo quéewidacani liá'a ley Dios shínaa, ne jócai néemi liá'a namánija, ne jiní liá'a néewidani jicá'a liá'a yáawaiyi namáca. ");
INSERT INTO aca_vpl VALUES ("T11_8","084_1_8","1TI","1","8","8","Wáa léenaa liá'a ley sáicai wérri, chácta waméda léjta liwówai limédaca, léjta liyáyu'u. ");
INSERT INTO aca_vpl VALUES ("T11_9","084_1_9","1TI","1","9","9","Rúnaa wédacanicoo, jiní ley náa nalí náa'a médenai sáicaica. Liá'a ley náani quéewique'e náa léenaa náa'a médenai máashii ya náa'a jócani éemi, ya náa'a máashiicanica ya cajíconaanica, náa'a jócani cawáunta Diosru ya liá'a éebidani nácu, ya náa'a íinuenai nashínaa nasálijinau ya natúwa, quinínama íinuenaica. ");
INSERT INTO aca_vpl VALUES ("T11_10","084_1_10","1TI","1","10","10","Ya náa'a médenai máashii náiinaa yáajchau, ya náa'a washiálicuenai médenai máashii náajcha wáacoo, ya náa'a íinaca médenai máashii nayá wáacoo lécchoo, ya náa'a nawénda ya nawéni chóniwenai, ya náa'a canúma yúwicanica; ya náa'a júrenaiu mawéni; liáni liwówaiyu limáca, náa'a médenai liá'a yáirrico éewidenai sáicai júnta. ");
INSERT INTO aca_vpl VALUES ("T11_11","084_1_11","1TI","1","11","11","Ya liáni sáicai éewidani léewa wáiinuni sáicai wérri chuánshi, léewidani wayá nácu wéewaunaa wáacoo áacairra, liá'a Dios sáicai wérri máacani nulí. ");
INSERT INTO aca_vpl VALUES ("T11_12","084_1_12","1TI","1","12","12","Nuá sáicai washínaa Wawácali Jesucristo, liyá yáirri nulí danáanshi, níwata cáberri nuéebida linácu limáaca nuyá nuyúdaque'e lishínaa tráawaju nácu, ");
INSERT INTO aca_vpl VALUES ("T11_13","084_1_13","1TI","1","13","13","báawita nuyá quéecha numá chuánshii máashii linácula, nucánaquedani ya nucáitani. Ne liyá Dios carrúni jináata licába nuyá, níwata nuyá újnibi jócai éebida linácu ya jócu nuá léenaa liá'a numédanica. ");
INSERT INTO aca_vpl VALUES ("T11_14","084_1_14","1TI","1","14","14","Cháwa jáni washínaa Wawácali yáa nulí liwíteu máanui wérri, ya liá nulí liá'a nuéebidani nácu, ya liá'a caníinaabee wawáalianica washínaa rúneerriu Cristo Jesúsru. ");
INSERT INTO aca_vpl VALUES ("T11_15","084_1_15","1TI","1","15","15","Liéni yáawaiyi wérri, quinínama rúnaa néebidacani: liá'a Cristo Jesús íinuerri cáinabi ítala quéewique'e litée náa'a cajíconaanica áacairra, náucha nárra nuyá quéechanacu sái. ");
INSERT INTO aca_vpl VALUES ("T11_16","084_1_16","1TI","1","16","16","Tándawa, Dios wáalia carrúni jináata licába nuyá; quéewique'e Jesucristo íyada nunácu quinínama sáica wíteeshica. Nuyá íinue numédacoo núyadacoo nalí náa'a rúnaa néebida linácu, quéewique'e wéewa nawáalia liá'a cáwicaishi jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("T11_17","084_1_17","1TI","1","17","17","¡Wáa lirrú máanui licábacoo, ya cadánanibee wérri mamáarraca éerri, lirrú liá'a rey jócai amáarra, liá'a jócai éewa máanalica, jócai wéewa wacábaca liyá bácai Dios! Chácajani. ");
INSERT INTO aca_vpl VALUES ("T11_18","084_1_18","1TI","1","18","19","Timoteo, nucúulee, nuá jirrú liáni tráawajuca quéewique'e jíinua yáacacoo sáica liáni íinua yáacashica jéebidani nácu, ya sáicai wíteeshiyu, léjta liá'a namáni quéecha náa'a éenajinai náa'a táanianaimi jinácu lijí'inaa lícu Diosca. Áabi jócta néemi jiwánacaala nashínaa nawíteu yúqueneu nashínaa néebidani nanácu. ");
INSERT INTO aca_vpl VALUES ("T11_20","084_1_20","1TI","1","20","20","Liéni bésuneerriu nalí náa'a Himeneo ya Alejandro, náani néejueda Wawásimirru quéewique'e néewidacoo jócubeecha namá máashii chuánshi Dios júnta. ");
INSERT INTO aca_vpl VALUES ("T12_1","084_2_1","1TI","2","1","1","Quéechanacu numáca irrú iméda isáta Diosru, isáta Dios yúcha, isáta íchaba ya yáa sáicai Diosru quinínama nanácu náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("T12_2","084_2_2","1TI","2","2","2","Arrúnaa wasáta Dios yúcha nanácu náa'a wánacaleenaica, ya náa'a bánuenaica, quéewique'e wéewa sáicta wawówa ya wacáwica machúnuca, ya jiní íinua yáaquenaiu, cawáunta wayá Diosru, ya cawáuntaque'e quinínama licábacanaa. ");
INSERT INTO aca_vpl VALUES ("T12_3","084_2_3","1TI","2","3","3","Liáni sáicai ya licába sáictai liá'a Diosca téerri wayá áacairra. ");
INSERT INTO aca_vpl VALUES ("T12_4","084_2_4","1TI","2","4","4","Liyá wówerri quéewique'e quinínama náiinu náa léenaa yáawaiyiica, ya náaque'iu quinínama áacairra. ");
INSERT INTO aca_vpl VALUES ("T12_5","084_2_5","1TI","2","5","5","Ái bácai rími Dios já'a; ái báqueerri Washiálicuerri éeneerri litée quinínama washiálicuenai quéewique'e nayá Dios yáajcha, lijí'inaa liá'a Washiálicuerrica Jesucristo. ");
INSERT INTO aca_vpl VALUES ("T12_6","084_2_6","1TI","2","6","6","Níwata Jesucristo éejuederri licáwicau quéewique'e quinínama chóniwenai éewa náacoo áacairra, léjta liáyu chuánshi liyáali léerdimi rícu. ");
INSERT INTO aca_vpl VALUES ("T12_7","084_2_7","1TI","2","7","7","Tándawa nuyá Dios máacani téerri'inaa lichuáni ya apóstolu, ya namáaca nulí quéewique'e éewiderriu linácu éebidani, ya liá'a yáawayiica náa'a jócani judío. Ne liéni numáni yáawaiyi waliérra; jócaita númashi yúwica. ");
INSERT INTO aca_vpl VALUES ("T12_8","084_2_8","1TI","2","8","8","Cháwa jáni, nuwówai náa'a washiálicuenaica nasáta Dios yúcha quinínama matuínaami, ya nanácuda nacáajiu Diosru wówashi masáculai, jiní íiwirri wówa ya jiní cáiteerri ");
INSERT INTO aca_vpl VALUES ("T12_9","084_2_9","1TI","2","9","9","Ya nuwówai quéewique'e náa'a íinaca nasúwa nábalau léjta íina íibala cábacanaa, imíyaiyu ya sensíyuiyu lécchoo; quéewique'e nachúnicoo ne jócai jiérri ruwítau quéewique'e nacába ruyá, jiní óroyu, ya íiba cawénini, jiní íibalashi cawéni wérri, ");
INSERT INTO aca_vpl VALUES ("T12_10","084_2_10","1TI","2","10","10","arrúnaa iméda sáicai, léjta arrúnaa naméda náa'a íinaca máaqueneu nayáu Diosru. ");
INSERT INTO aca_vpl VALUES ("T12_11","084_2_11","1TI","2","11","11","Ruá'a íinetoo rúnaa ruéemi liá'a néewidani nácu manúmata, cawáuntaque'e quinínama ruyá náajcha wánacaleenaica; ");
INSERT INTO aca_vpl VALUES ("T12_12","084_2_12","1TI","2","12","12","ya jócu nuínda quéewique'e ruá'a íinetoo éewida íchaba chóniwenai náneewa, ya jócaque'e ruwánacala liá'a washiálicuerrica. Nuwówai ruyáque'e manúmata, ");
INSERT INTO aca_vpl VALUES ("T12_13","084_2_13","1TI","2","13","13","níwata Dios méderri quéechanacu Adán, liáwinaami ruá'a Évaca; ");
INSERT INTO aca_vpl VALUES ("T12_14","084_2_14","1TI","2","14","14","ya Adán jócaite Wawásimi chálujueda, ruyáwani ruá'a íinetooca, lichálujuedate ruyá rucáu jíconaashi rículate. ");
INSERT INTO aca_vpl VALUES ("T12_15","084_2_15","1TI","2","15","15","Dios méetuaminaa rujíconaa ruá'a íinetooca ya táminaa litée ruyá áacairra, rumédacta quinínama sáica léjta túwashi, ya ruéebidacta mamáarraca, caníinaabee nácu, jiní rujíconaa ya imíya ruyá. ");
INSERT INTO aca_vpl VALUES ("T13_1","084_3_1","1TI","3","1","1","Liéni yáawaiyii waliáni: Báqueerri wówerricta liárru iglesia rícu liwánacaalaque'e, wówerri áabai tráawajo sáicai. ");
INSERT INTO aca_vpl VALUES ("T13_2","084_3_2","1TI","3","2","2","Tádawa, liá'a licábacanaa liá'a wáaleerri liá'a wánacaalashica léjta wánacaleerri jiní jíconaa. Arrúnaa liwáalia bácau rími líinuwa, ya liyáque'e áabai cáwicaishi cawáuntai, áabai chuánija, catráawajaacai ya jóca liséwica yáarru. Arrúnaa léewa liwína chóniwenai líibana rículau mamáarraca; arrúnaa léewa léewidaca. ");
INSERT INTO aca_vpl VALUES ("T13_3","084_3_3","1TI","3","3","3","Jócai arrúnaa cáirracalaicani, jiní liwówaica líinua yáacacoo, arrúnaa sáicai wérri liyá, machúnucai ya jócai máaca liwówau warrúwa nácu. ");
INSERT INTO aca_vpl VALUES ("T13_4","084_3_4","1TI","3","4","4","Arrúnaa léewa liwánacaala líibana rícu sána, ya léewidaque'e léenibiu juménani nayá ya cawáuntani quinínama. ");
INSERT INTO aca_vpl VALUES ("T13_5","084_3_5","1TI","3","5","5","Ne jóctacala léewa liwánacaala chúnsai líibana rícu sánaca, ¿chítate quéewau'u jíni litúya liá'a iglesia Dios shínaaca? ");
INSERT INTO aca_vpl VALUES ("T13_6","084_3_6","1TI","3","6","6","Tándawa, liá'a wánacaleerrica jócai éewoo báqueerri wáalii éebidaca, carrúnataca máanui licábacoo, ya licáacoo léjta Wawásimi cáayu'u lirrícula liá'a cacháninaica. ");
INSERT INTO aca_vpl VALUES ("T13_7","084_3_7","1TI","3","7","7","Arrúnaa cawáunta nacábacani náa'a jócani éebida Dios nácu, quéewique'e jócu licáu báinabee rícula nanáneewa náa'a chóniwenaica, ya licá'echau Wawásimi shínaa máashii rícula. ");
INSERT INTO aca_vpl VALUES ("T13_8","084_3_8","1TI","3","8","8","Chacábacanaa, náa'a yúdenai pastor iglesia rícu, rúnaa washiálicuenaicani cawáuntani, ya séewirrinaa naméda liá'a namánica, ya jócani cáirracalani, jiní nawówaicala nawáalia shínaashi méenaami naméda máashii chóniwenairru. ");
INSERT INTO aca_vpl VALUES ("T13_9","084_3_9","1TI","3","9","9","Arrúnaa nacháanacoo lirrú liá'a yáawaiyi náyadanica, liá'a wéebida nácu ya nawáaliaque'e masáculai wíteeshica. ");
INSERT INTO aca_vpl VALUES ("T13_10","084_3_10","1TI","3","10","10","Quéechanacu arrúnaa néeneda nayá, ya liáwinaami, ya jócta nawáalia najíconau néewaminau namédacoo léjta nayúdenai pastor iglesia rícu. ");
INSERT INTO aca_vpl VALUES ("T13_11","084_3_11","1TI","3","11","11","Chacábacanaa, náa'a íinaca cawáuntani wérri, jócani cáiiwadedacani chuámshi shínanaa, cawáuntani ya machácani quinínama nácu. ");
INSERT INTO aca_vpl VALUES ("T13_12","084_3_12","1TI","3","12","12","Báqueerri yúderri pastor iglesia rícu, rúnaa liwáalia bácau rími líinuja, ya léewa liwánacaala sáica wérri léenibiu ya lishínaa quinínama líibana rícu sána. ");
INSERT INTO aca_vpl VALUES ("T13_13","084_3_13","1TI","3","13","13","Níwata náa'a yúdenai pastor iglesia rícu, médenai sáica nashínaa tráawajo, náiinuni'inaa nalíwoo áabai yáarruishi cawéni, ya chawíteemi wérri já'a néewaminaa natáaniaca néebidauca Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("T13_14","084_3_14","1TI","3","14","14","Nunénda nuáacoo nucába jiyá; ne nutána jirrú liáni, ");
INSERT INTO aca_vpl VALUES ("T13_15","084_3_15","1TI","3","15","15","quéewique'e, báawita nudécudau, jiáque'e léenaa chítashia jíni rúnaa jimédacoo Dios shínaa éenajinai íibi, léwa liáni iglesia Dios cáwiica, liá'a iglesia wíneerri ya túyerri yáawaiyica. ");
INSERT INTO aca_vpl VALUES ("T13_16","084_3_16","1TI","3","16","16","Yáawaiyii atéwai jócu wéewa wáiiwadedaca liá'a wéebidani nácu bájialai máanui wérrica: “Cristo íinuerri cáinabi ítala limédacoo washiálicuerriyu, néenee Espíritu Santo íiyada majíconaiyu, ya náa'a ángelbini nacábani. Náiiwa nalí chóniwenai yáaine quinínama cáinabi íta'aa, náa'a éebidenai linácu quinínama cáinabi, ya narríshibiani sáicai wérri áacairra.” ");
INSERT INTO aca_vpl VALUES ("T14_1","084_4_1","1TI","4","1","1","Ne liá'a Espíritu Santo limá'ee jucámarranaa, cha lé'e amáarractala'inaa liyáca liá'a éerrica, áabiminaa dánaujoo liúcha liá'a néebidani nácu, nasíguiaminaa náa'a espíritu cachálujuedacanica ya néewidani nanácu náa'a íinuenai demonio néenee. ");
INSERT INTO aca_vpl VALUES ("T14_2","084_4_2","1TI","4","2","2","Namédaminaa nawánacaala náa'a chóniwenai chámaini wíteeshi ya canúma yúwicani, nashínaa nawítee márquerriu nashínaa jíconaashi újni jiárruyucani. ");
INSERT INTO aca_vpl VALUES ("T14_3","084_4_3","1TI","4","3","3","Náani chóniwenaica jócu naínda néda yáacacoo, ya jócu naínda náaya matuínaami íyacaishi, ne Dios quénudanica quéewique'e náa'a éebidenaica ya lécchoo náa'a yáine léenaa liá'a yáawaiyica náayaque'ini, náaque'e sáicai Diosru. ");
INSERT INTO aca_vpl VALUES ("T14_4","084_4_4","1TI","4","4","4","Ne quinínama liá'a Dios quénudanica sáicai wérri; ya jiní wéewani wadánaa jiúcha warríshibiactani wáa sáicai Diosru, ");
INSERT INTO aca_vpl VALUES ("T14_5","084_4_5","1TI","4","5","5","níwata liá'a Dios chuánica ya isáta Dios yúcha limédani majíconaa. ");
INSERT INTO aca_vpl VALUES ("T14_6","084_4_6","1TI","4","6","6","Ne jéewidacta quinínama liáni nalí náa'a jéenajinai, ya jíya liá'a Dios chuánica ya liá'a sáicai jéebidanica nácu séewirrinai jiyá nácu, jiyá bácai cashírruedacai sáicai Jesucristorru. ");
INSERT INTO aca_vpl VALUES ("T14_7","084_4_7","1TI","4","7","7","Ne jócai jiméda liwánacaala náa'a chuánshi éerri rícu sánaca ya mawíteeca. Jimáaca jicáwicau Dios cáaji rícu mamáarraca; ");
INSERT INTO aca_vpl VALUES ("T14_8","084_4_8","1TI","4","8","8","áawita liá'a ejercicio sáicai wanáanairru máayabaca, jimáaca jiyáu Diosru sáicai quinínamarru, níwata índa walí sáicai liáni wacáwicaca, ya liá'a wacáwica wabéechala sáica. ");
INSERT INTO aca_vpl VALUES ("T14_9","084_4_9","1TI","4","9","9","Liáni yáawaiyii waliáni, arrúnaa quinínama néebidacani. ");
INSERT INTO aca_vpl VALUES ("T14_10","084_4_10","1TI","4","10","10","Tándawa liáni, watráawajaa ya waméda wadánaniu, níwata wamáaca wanéndaca liáni liá'a Dios cáwiica, liá'a wásedeerri quinínama chóniwenai, nalí chúnsai náa'a éebidenai linácu. ");
INSERT INTO aca_vpl VALUES ("T14_11","084_4_11","1TI","4","11","11","Liáni arrúnaa jibánua ya jéewida áabi mawí. ");
INSERT INTO aca_vpl VALUES ("T14_12","084_4_12","1TI","4","12","12","Ujicába jiyáu jiníca jiwéni, báawita icúlirrijui jiyá, mawí jíyada jiwíteu nalí chaléjta éebiderri Dios chuáni nácu, chaléjta jitáaniacala, chaléjta jiyáyu'u jiwówa yáajchau, ya jéebidacala ya jicáwica jiní jíconaa. ");
INSERT INTO aca_vpl VALUES ("T14_13","084_4_13","1TI","4","13","13","Nácula nuíinu jichána jiliá nalí náa'a chóniwenaica liá'a Dios chuánica, jiá nadánani náa'a jéenajinai ya jéewida nayá. ");
INSERT INTO aca_vpl VALUES ("T14_14","084_4_14","1TI","4","14","14","Ujínda amáarraca liá'a sáicabee Dios yáani jirrú, quéecha'inaami Dios wána salínaica iglesia ísanaca nachánaa nacáajiu jinácu. ");
INSERT INTO aca_vpl VALUES ("T14_15","084_4_15","1TI","4","15","15","Jimáaca quinínama jiwíteu linácu liáni, néewaque'e nacába quinínama léjta jidáwinacoo jinácu. ");
INSERT INTO aca_vpl VALUES ("T14_16","084_4_16","1TI","4","16","16","Jitúyau jiyá jájiu, liá'a jéewidau'u áabi, jiáu cabálininaa quinínama nácu. Ne jimédacta cháni'i, jéewaminaa jiácoo áacairra jiyá jájiu, ya chacábacanaa náa'a éemenai jirrú, néewaminaa náacoo áacairra lécchoo. ");
INSERT INTO aca_vpl VALUES ("T15_1","084_5_1","1TI","5","1","1","Ujicáitadeda liá'a salírranica, báawachata, jéewida liwítee chaléjta újni jisálijinaa, jiyá náiibi náa'a icúlinaica ya jiá nawítee léjta jéenajinai. ");
INSERT INTO aca_vpl VALUES ("T15_2","084_5_2","1TI","5","2","2","Náa'a salítuenica, jiyá ruájcha chaléjta jitúwa; ya náa'a miyácanai, chaléjta jéenajinai íina, wíteeshi majíconaiyu. ");
INSERT INTO aca_vpl VALUES ("T15_3","084_5_3","1TI","5","3","3","Jiyúda máanirrinica náa'a jócani wáalia tánashia yúderri nayái. ");
INSERT INTO aca_vpl VALUES ("T15_4","084_5_4","1TI","5","4","4","Ne báquetoo máanirriuctani ruwáalia rucúuleu jócta rutáqueerri, nayáwa quéechanacu éewenaa néewidacoo naméda nacábacanau náajcha náa'a chúnsana néenajinaica, caníinaaque'e nacába nasálijinau léjta caníinaa nacába nayá lécchoo, léwa sáicai liéni, sáicai Dios cába lécchoo. ");
INSERT INTO aca_vpl VALUES ("T15_5","084_5_5","1TI","5","5","5","Ne ruá'a yáawaiyii máanirriuca, ruá'a máaquechooca bácai, máaquechoo ruwówau Dios nácu, jócau íiyabau rusátacoo Dios yúcha éerri jútainchu ya táayee lécchoo, quéewique'e Dios yúda ruyá. ");
INSERT INTO aca_vpl VALUES ("T15_6","084_5_6","1TI","5","6","6","Ne ruá'a máanirriuca médechoo léjta éerri wówau, máanaliu yáca rucáwica yáajchau. ");
INSERT INTO aca_vpl VALUES ("T15_7","084_5_7","1TI","5","7","7","Jibánua nalí náa'a quinínama liáni, quéewique'e jócubeecha arrúnaa nacáida íiwanaa. ");
INSERT INTO aca_vpl VALUES ("T15_8","084_5_8","1TI","5","8","8","Ne liá'a jócaita túya léenaaca, mawí'inaa chúnsana léenajinaica, jócai méda nacábacanaa náa'a éebidenai Dios chuáni, chái jicá'a liá'a mawí cacháninai wítee náucha náa'a jóca éebida Dios nácu. ");
INSERT INTO aca_vpl VALUES ("T15_9","084_5_9","1TI","5","9","9","Táshia natánacta nají'inaa náa'a máanirrinica, arrúnaa nayáca bácai nája náa'a wáalenai mawí sesenta camuí, ne ruá'a wáalechoomi bácairrimi rúnirrijau. ");
INSERT INTO aca_vpl VALUES ("T15_10","084_5_10","1TI","5","10","10","Néewani náa léenaa nácu liá'a sáicai rumédanica: Dáwinechoo sáica ruéenibiu, sáica wítee náiinucta rúbana rícula, bádedeechoo náiiba náa'a éebidenaica, ruyúdacta náa'a carrúni jináatanica; ne lécchoo, ruwówa rumédaca quinínama sáicai. ");
INSERT INTO aca_vpl VALUES ("T15_11","084_5_11","1TI","5","11","11","Ne jócu tána nají'inaa néeni náa'a máanirrinica wáalianai píitui camuí, níwata ruíinaa wána rushírricoo Cristo yúcha, wówainai nawína yáacacoo wáaliiyu bániu, ");
INSERT INTO aca_vpl VALUES ("T15_12","084_5_12","1TI","5","12","12","nawáalia najíconaa nayá jájiu, jóca naméda léjta namáyu nalí quéechanacu. ");
INSERT INTO aca_vpl VALUES ("T15_13","084_5_13","1TI","5","13","13","Ne lécchoo najínaniu cuíta jútainchu, ya naméda náinuniu lécchoo, ne jócanita íinu bácai canúma yúwicani lécchoo, níqueneu quinínama nácu ya náiiwadeda jócai sáicanata náiiwadedaca. ");
INSERT INTO aca_vpl VALUES ("T15_14","084_5_14","1TI","5","14","14","Tánda nuwówai náa'a máanirrini miyácanaica ruéewa ruéda yáacacoo wáaliiyu, nawáaliaque'e néenibiu, natúyaque'e nábanau léjta íina, jócubeecha náa lirrú yáarrushi liá'a najínaica. ");
INSERT INTO aca_vpl VALUES ("T15_15","084_5_15","1TI","5","15","15","Ne áabi náa'a máanirrinica najiáu Jesucristo yúcha, jáiwa náawai Wawásimi yáajcha. ");
INSERT INTO aca_vpl VALUES ("T15_16","084_5_16","1TI","5","16","16","Ne báquetoo íinetoo éebidechoo Cristo nácu, ruwáaliacta ruéenajinai máanirrini íibiu, arrúnaa iyúdacani, jócubeecha cadúcuni liyá iglésiarru; cháminaa iglesia éewa liyúda nayá náa'a máanirrinica jiníni yúda mawí. ");
INSERT INTO aca_vpl VALUES ("T15_17","084_5_17","1TI","5","17","17","Náa'a salínaica wánacaleenai sáica iglesia, éewenai cawáunta icába mawí, náa'a yáawaiyinica íiwa ya éewidenai Dios chuáni. ");
INSERT INTO aca_vpl VALUES ("T15_18","084_5_18","1TI","5","18","18","Ne liá'a Dios chuáni limá'ee: “U'ibáji linúma liá'a pacáaca jáicta litráawajaa liyá cái”. Né'e limá'ee lécchoo: “Liá'a tráawajeerrica iglesia rícu, éewerri lirríshibia liwéniu lécchoo”. ");
INSERT INTO aca_vpl VALUES ("T15_19","084_5_19","1TI","5","19","19","Ujiméda nawánacaala náa'a táanianai lijúnta liá'a salírrani éewiderri iglesia rícu, jócta liwáalia chámata jócta matálitai cábenai liyá. ");
INSERT INTO aca_vpl VALUES ("T15_20","084_5_20","1TI","5","20","20","Náa'a médenai náacoo najíconau, arrúnaa náarracani quinínama náneewa, quéewique'e chacábacanaa cáarru náa'a áabica. ");
INSERT INTO aca_vpl VALUES ("T15_21","084_5_21","1TI","5","21","21","Nubánua jiyá Dios náneewa, Jesucristo náneewa ya náa'a ángelbini Dios wínani lécchoo, jiméda quinínama liá'a nuwánani jimédaca, ya machácani jiyá quinínama yáajcha, jicába quinínama áabenaa. ");
INSERT INTO aca_vpl VALUES ("T15_22","084_5_22","1TI","5","22","22","Ujichánaa jicáajiu áabi nácu jóctanaa jiá léenaa liwítee sáica, jócubeecha jiméda jijíconau náajcha. Jitúyau liúcha liá'a quinínama máashiica. ");
INSERT INTO aca_vpl VALUES ("T15_23","084_5_23","1TI","5","23","23","Níwata éerri jútainchu bálinacoo jiáwai nácu, ujíirra shiátai bácai liyáwoo, jéewa jíirra píitui vino lécchoo. ");
INSERT INTO aca_vpl VALUES ("T15_24","084_5_24","1TI","5","24","24","Najíconaa náa'a áabica, nacábani jucámarranaa jóctanaa náau liyáctala cáberri yáawacta cajíconaajani, ne áabata náani léenaa liáwinaami. ");
INSERT INTO aca_vpl VALUES ("T15_25","084_5_25","1TI","5","25","25","Ne chalécchoo, liá'a sáicai namédani lécchoo nacábani jucámarranaa; ya liá'a jócai nacába, jóca'inaa máacau libáyacoo séewirrinaa. ");
INSERT INTO aca_vpl VALUES ("T16_1","084_6_1","1TI","6","1","1","Náa'a arrúnaani tráawajaaca nawácanairru mawéni, arrúnaa náa'a nacáarruni'inau nawácalirru, arrúnaa cawáunta nayá, jócubeecha licáida náiiwanaa Dios jí'inaa nácucha, jiní natáaniacala máashii linácu liá'a wéewidani nácu. ");
INSERT INTO aca_vpl VALUES ("T16_2","084_6_2","1TI","6","2","2","Ne áabi wáaliacta nawácanai éebidenai Dios chuáni, néewaque'e cawáuntaque'e nayá, níwata néenajinaiwajani éebiderri Jesucristo chuáni nácu; tádawa, arrúnaa iyúda nayá sáicai wérri mawí, tándawa náa'a ríshibianai nashínau sáicai tráawajuca, éebidenai lécchoo, ya éenajinai caníinaa icába nayá. Jéewida ya jíiwa nalí liáni: ");
INSERT INTO aca_vpl VALUES ("T16_3","084_6_3","1TI","6","3","3","Ne áabi éewidacta iyá báawatai liúcha liá'a léewidani iyá nácu, ya jócu áabenaa liyá liájcha liá'a yáawaiyica néewidani nácu, Wawácali Jesucristo nácue sáica, ne jócani éewida léjta wawítee, ");
INSERT INTO aca_vpl VALUES ("T16_4","084_6_4","1TI","6","4","4","ne báqueerri sáictai cábacoo liyá jájiu liwítee rícuejiu, ne jiní yáani léenaa. Íiserri litáania nanácu náa'a chuánshi jócani sáica licábaca, ne yáairri linácu chaléjta bálinacaalashi; ne léwa líinucteji liá'a cadéni nacába yáacacoo, jócu áabenaa nawítee, máashii linúma, jócu léebida linácu, ");
INSERT INTO aca_vpl VALUES ("T16_5","084_6_5","1TI","6","5","5","ya líinua yáacau éerri jútainchu áabi yáajcha, náajcha náa'a chóniwenai máashii wítee, ya jócai liá léenaa liá'a yáawaiyica, wíneerri liá'a wíteeshica cháji'i warrúwa nácueji. ");
INSERT INTO aca_vpl VALUES ("T16_6","084_6_6","1TI","6","6","6","Ne jucámarrai yáaca liá'a wawíteeca, yáawaiyii cawéni wérrica, ne bácai lirrú liá'a sáictai wówa liájcha liá'a liwáalianica. ");
INSERT INTO aca_vpl VALUES ("T16_7","084_6_7","1TI","6","7","7","Táda jiní waíndani lítala léji liéni cáinabica, jiní'inaa wéewani watéecojoo. ");
INSERT INTO aca_vpl VALUES ("T16_8","084_6_8","1TI","6","8","8","Áicta wáayanijaa ya ái wábalajaa, ta éewa sáicta wawówai liájcha liáni. ");
INSERT INTO aca_vpl VALUES ("T16_9","084_6_9","1TI","6","9","9","Náa'a wówenai nawáalia máanui wérri warrúwaca, jócu néenaa nawánta liá'a máashii méda nawówa lícu, ya liwána napénsaa áabata matuínaami mawíteeyu, ya liá'a máashiica téerri washiálicuenai carrúni jináatactala'inaa nayá, ya chaléeni náucaquictala'inaacoo. ");
INSERT INTO aca_vpl VALUES ("T16_10","084_6_10","1TI","6","10","10","Níwata lináinaa liá'a warrúwaca, náawiderri nawítee náa'a washiálicuenaica, namédaque'e máashii liyú liá'a warrúwaca, náa'a sáictani cábacani liá'a warrúwaca, lináawida nawítee liúcha liá'a néebidauca. Jáiwa carrúni jináata naméda nacáwica nayá jájiu. ");
INSERT INTO aca_vpl VALUES ("T16_11","084_6_11","1TI","6","11","11","Ne jiyá, washiálicuerri Dios shínaa, jimáaniu liúcha liáni quinínama máashiica. Jitée cáwicau machácani, máaquerri jiwówau Dios nácu, jiwáaliaca jéebidauyu, caníinaaca jicábacani, u'íinu jiyá nuchuáni nácu mamáarraca, jiáu jibéechalau, imíyaiyu jiwówa yáajchau. ");
INSERT INTO aca_vpl VALUES ("T16_12","084_6_12","1TI","6","12","12","Jíinua yáacoo linácue liá'a sáicaica jéebidau Dios nácu, ujínda liácoo jiúcha liá'a cáwicashi jócai amáarra, linácuejiwa Dios máida jiyá, tánda linácueji líiwa jirrú quinínama nanáneewa náa'a chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("T16_13","084_6_13","1TI","6","13","13","Chócaja'a, Dios náneewa, yáairri nacáwica quinínama yáanai lirrícu liáni éerrica, ya Jesucristo náneewa, cha lécchoo liméda áabai líiwa nalí sáicai, ya líiwa sáicai chuánshica lináneewa liá'a Poncio Pilatoca; nubánua jiyá, ");
INSERT INTO aca_vpl VALUES ("T16_14","084_6_14","1TI","6","14","14","jimédaque'e chaléjta nubánuau, jócai jéewa jiwána nanáawidaca, jócubeecha arrúnaa nucáita jiyá. Jiméda cháni cáashia líinuctala liá'a Wawácali Jesucristoca. ");
INSERT INTO aca_vpl VALUES ("T16_15","084_6_15","1TI","6","15","15","Dios méda quinínama áabenaa licábacanaa chaléjta limáyu, liyáwa bácai Dios sáicai wérri yáairri quinínama íta'aa, náiibicha náa'a reyebinica liyá mawí máanui náucha ya náiibicha náa'a wánacaleenaica, liyá mawí máanui náucha. ");
INSERT INTO aca_vpl VALUES ("T16_16","084_6_16","1TI","6","16","16","Liyáwa bácai jócai máanali, yáairri áabai cámarrashiyu jinícta éenaa lirrúnicoo. Jiní báqueerri washiálicuerri éeneerritee licábacani, jócai'inaa léenaa licábacani. ¡Bácai Dios yáairri'inaa mamáarraca éerri! Cháwajani. ");
INSERT INTO aca_vpl VALUES ("T16_17","084_6_17","1TI","6","17","17","Náa'a wáalianai warrúwa líta'aa liáni cáinabica, jibánua nalí jócubeecha máanui nacábacoo, jócubeecha namáaca nawówau linácu liá'a nanéndani nayáca warrúwa nácu, níwata liá'a warrúwaca éewerri amáarraca, jiní wéni. Imáaca iwówau Dios nácu, liyáminaa yáa walí quinínama liá'a warrúnaani'inaa walíwoo, quéewique'e liméda walí sáicai. ");
INSERT INTO aca_vpl VALUES ("T16_18","084_6_18","1TI","6","18","18","Jiwána naméda liá'a sáicaica, quéewique'e namédacoo rícubiniyu naméda sáicaica. Jíiwa nalí nanéndaque'e nayúdau'inaa náa'a carrúni jináatanica. ");
INSERT INTO aca_vpl VALUES ("T16_19","084_6_19","1TI","6","19","19","Cháwaminaa nawáalia rícubinique'e nayá, liáminaa nalí nadánani, yáairri'inaa nalí cabálininaa nabéechalau, náiinuminaa liá'a nacáwica jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("T16_20","084_6_20","1TI","6","20","20","Timoteo, túya sáica liáni nuáni jirrú jicáaji rícu. Ujéemi chuánshi matuínaami éerri rícu sái mawéniica, jiní jiácala liwíbanaa nalí náa'a chóniwenai máinai náacala léenaa, ne jiníni yáani léenaa; ");
INSERT INTO aca_vpl VALUES ("T16_21","084_6_21","1TI","6","21","21","ne áabi náa'a nanáawida nawíteu, liúcha liáni nawítee jócai yáawaiyi, shírreneu liúcha liáni léebidauca. Nusáta Dios yúcha irrú'inaa liáque'e irrú sáicabee inácu'inaa.");
INSERT INTO aca_vpl VALUES ("T21_1","085_1_1","2TI","1","1","1","Nuyá Pablo, apóstolu Jesucristo shínaa, bánuerriu Dios wánacaala nácu, chaléjta Dios máyu'u liá'a cáwicashii Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("T21_2","085_1_2","2TI","1","2","2","Nutána jirrú liáni cáashtaca liá'a Timoteoca, caníinai nucábaca jicá'a nucúulee. Nuwówai Dios wasálijinaa ya Wawácali Jesucristo liá jirrú jidánani ya carrúni jináatau ya sáicai wérri jinácu. ");
INSERT INTO aca_vpl VALUES ("T21_3","085_1_3","2TI","1","3","3","Nuédacaniu'inaacu séewirrinaa jáicta nusáta nuyáwai Dios yúcha, ya nuá sáicai Diosru éerrinacu ya táayee, liá'a nushírruedanirru sáica nuwítee, léjta nashírruedaumi náa'a nuwérrinaibimi lécchoo. ");
INSERT INTO aca_vpl VALUES ("T21_4","085_1_4","2TI","1","4","4","Nuédacaniu séewirrinaa jituí yáabi nácu, ya nuwówaiyu ta nucába jiyá, quéewiquinicta sáicta wérri nuwówa. ");
INSERT INTO aca_vpl VALUES ("T21_5","085_1_5","2TI","1","5","5","Níwata nuédacaniu jéebidau machácani, quéechanacumi ruéebida ruwáalia ruá'a jirruída Loidaca ya jitúwa Eunice, ya nuyá éebiderri lécchoo jiyácala chái wáaliacajani jéebidauca. ");
INSERT INTO aca_vpl VALUES ("T21_6","085_1_6","2TI","1","6","6","Tánda linácue nuárra jiyá, quéewique'e ujínda liácoo jiúcha liá'a jiwítee sáicaica Dios yáani jirrú, quéecha'inaami nusáta jinácu nuchánaa nucáajiu jinácu. ");
INSERT INTO aca_vpl VALUES ("T21_7","085_1_7","2TI","1","7","7","Ne Dios jócai yáa liyá walí áabai wíteeshi cáarruica, yáairriu walí áabai wíteeshi cadánani, caníinaa wacábaca ya wéewa watúyacoo wayá jájiu. ");
INSERT INTO aca_vpl VALUES ("T21_8","085_1_8","2TI","1","8","8","Ubái jiyá jíiwadeda sáicai wawácali nácu, ubái jiyá nunácueji lécchoo, nuyá naníquini cuíta manúmai rícula linácu liá'a Jesús bánuani wamédaca; báawachata, liá'a danáanshi Dios yáani jirrú, jiwánta liá'a carrúni jináatabee íinuerri'inaaca linácueji liá'a chuánshi sáicaica. ");
INSERT INTO aca_vpl VALUES ("T21_9","085_1_9","2TI","1","9","9","Dios wásedeerri wayái ya limáida wayá quéewique'e wamáacaque'e licáaji rícu quinínama wacáwicau, jócaita linácu liá'a wanísani wamédacai, níwata léwa liwówau jáni ya caníinaaca licába wayá Cristo Jesús nácueji. Dios caníinaa licába wayá quéecha'inaa jiní éerri újnibii. ");
INSERT INTO aca_vpl VALUES ("T21_10","085_1_10","2TI","1","10","10","Dios íyaderri walí caníinaa licába wayá chóque'e, quéecha'inaa líinu Jesucristo téerri'inaa wayá áacairra, liá'a márderri máanalicai dánani, ya lirrícueji liá'a Dios chuánica lijéda jucámarranaa liá'a cáwicaishica jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("T21_11","085_1_11","2TI","1","11","11","Dios máaquerri nuyá nuíiwaque'e liáni chuánshica, ya libánua nuyá léjta apóstolu ya qéewidacaica. ");
INSERT INTO aca_vpl VALUES ("T21_12","085_1_12","2TI","1","12","12","Tánda linácueji liáni carrúni jináata nuyá quinínama. Ne jócu bái nuyá linácueji, níwata nuá léenaa tánashia nácu nuéebidai, ne nuyá yáairri léenaa liyá wáalierri liwítee dánaniu quéewique'e nuíiwa lichuáni mamáarraca, cáashia líinuctala'inaa liá'a amáarracta cáinabi. ");
INSERT INTO aca_vpl VALUES ("T21_13","085_1_13","2TI","1","13","13","Jéewidau léjta jicábau nuéewida liá'a chuánshi yáawaiyiica, liá'a jinísani jéewidacoo nácu nuájcha, ya jéebidaque'e mamáarraca, ya liá'a níinaashi wawáalianica wayáyuca macábaita Cristo Jesús nácueji. ");
INSERT INTO aca_vpl VALUES ("T21_14","085_1_14","2TI","1","14","14","Espíritu Santo dánaniyui yáairri wanácu, jitúya linácu liá'a chuánshi machácanica liá'a Dios máacani jirrú. ");
INSERT INTO aca_vpl VALUES ("T21_15","085_1_15","2TI","1","15","15","Léjta jiáyu léenaa, quinínama cáinabi Asia shínaa ítesana, namáaca nuyái bácai, náiibicha náa'a Figelo ya Hermógenes. ");
INSERT INTO aca_vpl VALUES ("T21_16","085_1_16","2TI","1","16","16","Wawácali carrúni jináataque'e licába náa'a léenajinai liá'a Onesíforo, níwata liyá íchabachu líinu liyúda nuyá, ne jócu bái líinu licába nuyá yáairri cuíta manúmai rícula. ");
INSERT INTO aca_vpl VALUES ("T21_17","085_1_17","2TI","1","17","17","Báwachata, jái'inaami líinu Romalai, lichánau limúrru nuyái jócai wówa íyabau cáashia líinu nunácu. ");
INSERT INTO aca_vpl VALUES ("T21_18","085_1_18","2TI","1","18","18","Wawácali carrúni jináataque'e licábacani, liyáali éerri jáicta amáarra cáinabijoo. Jiyá jái yáa léenaa íchabachuca liyúda wayá Éfeso rícu. ");
INSERT INTO aca_vpl VALUES ("T22_1","085_2_1","2TI","2","1","1","Ya jiyá, Timoteo, nucábani jicába nucúulee, jéderri danáanshiyu liá'a Jesucristo yáani jirrú. ");
INSERT INTO aca_vpl VALUES ("T22_2","085_2_2","2TI","2","2","2","Liá'a jéeminica numáca íchaba chóniwenai náneewa, jéewidani náa'a washiálicuenaica jíisainica, náa'a éeneenai néewidaca áabi. ");
INSERT INTO aca_vpl VALUES ("T22_3","085_2_3","2TI","2","3","3","Jiyá sáicai wérri léjta soldado Jesucristo shínaa, éewerri jiyá sáicai áawita carrúni jináata naméda jiyá linácueji. ");
INSERT INTO aca_vpl VALUES ("T22_4","085_2_4","2TI","2","4","4","Jiní báqueerri soldado éewerri liwína áabai tráawaju, arrúnaa liyá linácuja éewaque'e sáicta liwácali cábacani. ");
INSERT INTO aca_vpl VALUES ("T22_5","085_2_5","2TI","2","5","5","Chacábacanaa, liá'a caséwicacaica, jócai éewa lirríshibia liá'a premioca, jóctacala liséwica léjta licábacanaa liséwicau'inaa. ");
INSERT INTO aca_vpl VALUES ("T22_6","085_2_6","2TI","2","6","6","Liá'a tráawajeerri bacháida lícu, quéechanacu arrúnaa litráawajaaca, quéewique'e liáwinaami léewa liáwaqueda líta liá'a liáabananica. ");
INSERT INTO aca_vpl VALUES ("T22_7","085_2_7","2TI","2","7","7","Jédacaniu linácu liáni numánica jirrú, liá'a wawácalica liwánaminaa jiá léenaaca quinínama. ");
INSERT INTO aca_vpl VALUES ("T22_8","085_2_8","2TI","2","8","8","Jédacaniu Jesucristo nácu, cáwerrimicoo máanalicai yúcha, David táqueerrimi; léwa chuánshi léewidani wayá nácu, wéewaunaa wáacoo áacairra ya nuíiwadedani. ");
INSERT INTO aca_vpl VALUES ("T22_9","085_2_9","2TI","2","9","9","Linácu liáni chuánshica nuwánta carrúnatabee, ya nabáji nuyá léjta báqueerri cáiinuacai; ne liá'a Dios chuánica jócai bájiu. ");
INSERT INTO aca_vpl VALUES ("T22_10","085_2_10","2TI","2","10","10","Tándawa nuwánta quinínama, quéewique'e numédaque'e sáicai nalí náa'a Dios wínanica, quéewique'e nayá néenaaque'e náacoo áacairra, liá'a sáictai wérrica, ya jócai amáarra Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("T22_11","085_2_11","2TI","2","11","11","Liáni yáawaiyii wérri: Máanalicta wayá linácu, cáwiminaa wayá liájcha lécchoo; ");
INSERT INTO aca_vpl VALUES ("T22_12","085_2_12","2TI","2","12","12","Carrúni jináatacta wayá linácu, wawáaliaminau washínau liájcha liwánacaalactalaca; ya wabáyacta lináwa wáa léenaa linácu, chacábacanaa libáya wanáwa lécchoo; ");
INSERT INTO aca_vpl VALUES ("T22_13","085_2_13","2TI","2","13","13","jócta machácani wayá, liyá mamáarracai méda machácanii, níwata jócai éewa limáaca licábacanau, le licábacanaaja liérra. ");
INSERT INTO aca_vpl VALUES ("T22_14","085_2_14","2TI","2","14","14","Jédacaniu séewirrinaa nalí linácu liáni: Limá nalí Dios náneewa u'icáita yáacau linácu jiliérra chuánshi. Náa'a cáitenai jócai sáicai, méderri máashii nalí náa'a éemenai nayácani. ");
INSERT INTO aca_vpl VALUES ("T22_15","085_2_15","2TI","2","15","15","Jiméda quinínama tánashia jéewani jimédaca, Dios náneewa jicá'a báqueerri washiálicuerri catráawajaacai méderri sáicai, jócai éewa báica, éewiderri sáica léjta licábacanaa liá'a Dios chuánica yáawaiyiica. ");
INSERT INTO aca_vpl VALUES ("T22_16","085_2_16","2TI","2","16","16","Ujitáania chuánshi máashii cáinabi íta sái, jiní wéni, léca liá'a natáaniani nácu cha, yúquerri nayá mawí máashiiquictala, ");
INSERT INTO aca_vpl VALUES ("T22_17","085_2_17","2TI","2","17","17","ya liá'a néewidacalaca cáarralerriu chaléjta liá'a bálinacaalashi cachánaninica. Léwa libésunau liáni náajcha náani washiálicuenai nají'inaa Himeneo ya Fileto, ");
INSERT INTO aca_vpl VALUES ("T22_18","085_2_18","2TI","2","18","18","náawa yáainiu náani báawachala liúcha liá'a yáawaiyiica; namá'ee linácucha liá'a wacáwiactacoo jái bésunacuwai, ya jínaneneu nacáarraleda chacábacanaa náa'a áabi éebidenaica. ");
INSERT INTO aca_vpl VALUES ("T22_19","085_2_19","2TI","2","19","19","Ne Dios máaca áabai liárrubai cadánaniyaca, tánda litánaa nalí: “Liá'a wawácali yáirri léenaa náa'a lishínaaca”, ya “Quinínama náa'a sátenaicoo Dios yúcha, arrúnaa nashírrique'iu liúcha liá'a jíconaashica”. ");
INSERT INTO aca_vpl VALUES ("T22_20","085_2_20","2TI","2","20","20","Waméda áabai cuíta máanui cábacanaa: Áabai cuíta máanui, jócai bábajuta oro yáca ya warrúwa ái néeni já'a, lécchoo áicuba ya bádanicaishi, áabi namédaniyu sáicai, ya áabata mawí cuíta lícu sái. ");
INSERT INTO aca_vpl VALUES ("T22_21","085_2_21","2TI","2","21","21","Cháwa libésunacoo á'a cuíta wawácali shínaaca. Ne wayácta majíconaa quinínama máashii yúcha, cháiminaa léjta liá'a cawéninamaica, yáairri sáica wawácali cáaji rícu, méderri'inaa quinínama méenaami sáicaica. ");
INSERT INTO aca_vpl VALUES ("T22_22","085_2_22","2TI","2","22","22","Jidánau liúcha liá'a máashiica icúlinai wíteeca. Jimúrru jiyá machácaniyu ya jéebida mawí, caníinaa jicába, ya sáictaque'e jiwówa, náajcha náa'a quinínama chóniwenai wáalianai nawówau masácula nasátacoo Wawácali yúcha. ");
INSERT INTO aca_vpl VALUES ("T22_23","085_2_23","2TI","2","23","23","Ujiméda liwánacaala náa'a cáitenai matuínaami, jicá'a náa'a chóniwenai mawíteeni, jái jiá léenaa índeerri íinua yáacashi. ");
INSERT INTO aca_vpl VALUES ("T22_24","085_2_24","2TI","2","24","24","Báqueerri washiálicuerri tráawajeerri wawácalirru, jócai jínaniu líinua yáacacoo, báawachata, arrúnaa sáica limédacoo quinínama yáajcha, arrúnaa éeneerri léewida sáica, ya arrúnaa liwántaa quinínama. ");
INSERT INTO aca_vpl VALUES ("T22_25","085_2_25","2TI","2","25","25","Ya jiárra imíyayu jiwówa yáajchau náa'a médenai lijúnta máashii, jínda Dios náawida nawíteejoo náaque'e léenaa liá'a yáawaiyiica. ");
INSERT INTO aca_vpl VALUES ("T22_26","085_2_26","2TI","2","26","26","Nawítee cáwiaque'iu, néewaque'e najiácoo liúcha liá'a cachálujuedacaica Wawásimi wáalierri nayá mawítee, limédaque'e náajcha léjta liwówainica. ");
INSERT INTO aca_vpl VALUES ("T23_1","085_3_1","2TI","3","1","1","Ya lécchoo arrúnaa jiá léenaa, liá'a éerdi éenamicojoo líinuminaajoo éerri carrúnatai'inaa. ");
INSERT INTO aca_vpl VALUES ("T23_2","085_3_2","2TI","3","2","2","Náa'a chóniwenaica cadéniminaa nayájoo, caníinaaminaa wérri nacá'a nawárruaniu, wachósuni ya cábadedeenaicoo nayá jájiu. Natáaniaminaajoo máashii Dios nácu, jócuminaajoo néewidajoo nasálijinaarru; nayáminaa quiní'inaajoo máj nalí, quiní nabústanijoo, jóca'inaa náa'a licáarruninaa liá'a Dios máni nácucha. ");
INSERT INTO aca_vpl VALUES ("T23_3","085_3_3","2TI","3","3","3","Jiní caníinai nacábacoo, jiní carrúni jináataca nacába áabi, nayá catáaniacani, nanúma yúwicau, jócuminaa néenaa nawánacaalacojoo liúcha liá'a máashiica; nayá liyájurricani, najínai'inaa quinínama liá'a sáicaica. ");
INSERT INTO aca_vpl VALUES ("T23_4","085_3_4","2TI","3","4","4","Nayá cachálujuedacani, jócani cawáunta, nayáminaa cashiámuni wítee wachósuni, namúrruminaa léjta nawítee máashii wówau'u, méewanita múrru Dios. ");
INSERT INTO aca_vpl VALUES ("T23_5","085_3_5","2TI","3","5","5","Namédaminaa újnii jicá'a náa'a éebidenaica ne újni namá nayáca, ne íyada nayá léja liá'a máashii namédanica. Níwata nayá jócai néebida Dios chuáni dánani. O'iwína yáacoo náajcha nárra chóniwenaica. ");
INSERT INTO aca_vpl VALUES ("T23_6","085_3_6","2TI","3","6","6","Níwata nayá néenaa náa'a wárruenai lirrícula liá'a cuítaca nachálujueda náa'a májinani íinaca, cashiámuni jíconaa, liárdanica quinínama wíteeshi máashiica, ");
INSERT INTO aca_vpl VALUES ("T23_7","085_3_7","2TI","3","7","7","nayá séewirrini éewidacoo, ne jócu néenaa náa léenaa linácu liá'a yáawaiyiica. ");
INSERT INTO aca_vpl VALUES ("T23_8","085_3_8","2TI","3","8","8","Chaléjta náa'a camálicai jí'ineenai Janes ya Jambres, jáiwa naméda máashii Moisés júntai, léquichoo náa'a chóniwenaica jócu néewida liá'a yáawaiyiica. Jiníwata washiálicuenai nawítee máashii wérri najíconaiyu, máashiderriu, jócani éebida linácu. ");
INSERT INTO aca_vpl VALUES ("T23_9","085_3_9","2TI","3","9","9","Ne quiní'inaa namédani bájialajoo, níwata náa'a quinínama náa léenaajoo chóniwenai mawíteeni, chaléjta nabésunaucoo náa'a chámataca Janes ya Jambres Moisés júnta. ");
INSERT INTO aca_vpl VALUES ("T23_10","085_3_10","2TI","3","10","10","Ne jiyá Timoteo, jái éewidacuwai linácu liáni nuéewidau chóniwenai, léjta nucábacanaa yáayu, nuwówaini numéda séewirrinaa, nuéebidanica, nuyá jócai íiwirri wówa áawitate naméda nulí máashii, ne caníinaa nucába chóniwenai, ya nudánani nuwántaque'e quinínama, ");
INSERT INTO aca_vpl VALUES ("T23_11","085_3_11","2TI","3","11","11","léjta nacánaquedau nuyá ya carrúni jináata numácoo. Jiá léenaa quinínama liá'a nubésunaucoo á'a Antioquía, ya Iconio, ya Listra, nacánaquedau nuyá carrúni jináata, ne nuyá liá'a wawácali túyerri nuyá quinínama yúcha. ");
INSERT INTO aca_vpl VALUES ("T23_12","085_3_12","2TI","3","12","12","Yáawaiyii waliáni, quinínama náa'a wówenai nayáca sáicai wérri Cristo Jesús yáajcha, nabésunedaminaa carrúni jináatabee. ");
INSERT INTO aca_vpl VALUES ("T23_13","085_3_13","2TI","3","13","13","Ne náa'a máashiinica, ya náa'a cachálujuedacanica mawíminaa máashii náacojoo, nachálujuedaminaa ya áabi chálujueda nayá lécchoo. ");
INSERT INTO aca_vpl VALUES ("T23_14","085_3_14","2TI","3","14","14","Jiyá yáairri cabálini quinínama linácu liá'a jéewidanicoo nácu, yá jéebidau'uni. Jiníwata jiyá ái yáa léenaa tánashia éewida jiyái. ");
INSERT INTO aca_vpl VALUES ("T23_15","085_3_15","2TI","3","15","15","Jédacaniu samálita'inaami jiyá yáirri léenaa Dios chuáni, jái éewa léewida jiyá ya litée jiyá áacairra, jéebidauca Cristo Jesús nácu. ");
INSERT INTO aca_vpl VALUES ("T23_16","085_3_16","2TI","3","16","16","Quinínama liá'a Dios chuáni tánerricoo sáicai wérri, ya Dios yáani walí, sáicai léewidaca ya liárra wayá, quéewique'e lichúni wayá, léewidaque'e wayá, áabai wíteeshi machácaniyu, ");
INSERT INTO aca_vpl VALUES ("T23_17","085_3_17","2TI","3","17","17","quéewique'e liyá washiálicuerri Dios shínaaca, éeneerri limédaca quinínama, wáaleerri quinínama liwíteu ne yáirri léenaa léewaque'e liméda quinínama méenaami sáicai. ");
INSERT INTO aca_vpl VALUES ("T24_1","085_4_1","2TI","4","1","1","Dios náneewa ya Cristo Jesús náneewa, líinuminaa jicá'a reyjoo, líiwa najíconaajoo, náa'a cáwinica ya náa'a máanalinica ne numá jirrú bájiala, ");
INSERT INTO aca_vpl VALUES ("T24_2","085_4_2","2TI","4","2","2","jíiwa Dios chuáni liá'a sáicaica, ya mamáarraca jiyáca jáicta léerdi ya jócta léerdi, jiwána léewidaca, jiárrani, ya jiá jidánani, jéewidau cawáunta ya u'íiwirri jiwówa. ");
INSERT INTO aca_vpl VALUES ("T24_3","085_4_3","2TI","4","3","3","Líinuminaa léju liá'a léerdica, náa'a chóniwenaica jócu nawánta néewida sáicai chuánshicojoo, namédaminaa nawíteeyu liá'a nawówaini namédaca; namúrruminaa manuába qéewidacani néewidaminaa léjta nawówau néemicani. ");
INSERT INTO aca_vpl VALUES ("T24_4","085_4_4","2TI","4","4","4","Nanáawida nawójunaa lirrú liá'a yáawaiyiica, namédaminaa quinínama liwánacaala liá'a chuánshica. ");
INSERT INTO aca_vpl VALUES ("T24_5","085_4_5","2TI","4","5","5","Ne jiyá wáalierri séewirri liá'a sáicai wíteeshica, jiwántaque'e carrúni jináatabeeca, jiméda mamáarraca jíiwa Dios chuánica, jiméda machácani jishínaa tráawaju. ");
INSERT INTO aca_vpl VALUES ("T24_6","085_4_6","2TI","4","6","6","Jái urrúni náiinua nuyái, nucáwica nuáni Dios cáaji rícu. ");
INSERT INTO aca_vpl VALUES ("T24_7","085_4_7","2TI","4","7","7","Nuyá yáairri machácani nuéebidaca mamáarraca, áawita cacháninabee íinu nútala, léjta báqueerri washiálicuerri íinua yáaquerriu jináwiu rícu. Nunísa nuíinu chaléeni nuéewactala nuíinuca, nuyá jócai numáaca nuéebidauca Dios chuáni nácu. ");
INSERT INTO aca_vpl VALUES ("T24_8","085_4_8","2TI","4","8","8","Chóque'e nushínaa premio nénda nuyá, nugáananica, ne liá'a nuwácali liá'a chóniwerri éewerri licábaca liá'a máashii o liá'a sáicaica, liyáali éerri liáminaa nulíjoni. Léeminaa liá'a nulí ya nalí náa'a quinínama náa'a caníinaani cába liyá, néndenai liyá cáashia líinuca. ");
INSERT INTO aca_vpl VALUES ("T24_9","085_4_9","2TI","4","9","9","Jiméda quinínama jíinuque'e madéjcanaajoo jicába nuyá. ");
INSERT INTO aca_vpl VALUES ("T24_10","085_4_10","2TI","4","10","10","Ne liá'a Demas caníinai cába mawí liá'a éerri shínaaca, jáiwa limáaca bácai nuyái, jáiwa liáwai Tesalónica néerra, Crecente liáu déecuchala Galacia, ya Tito yáa Dalmacia néerra. ");
INSERT INTO aca_vpl VALUES ("T24_11","085_4_11","2TI","4","11","11","Bácai Lucas yáa nuájcha, jimúrru nulí Marcos ya jíndani jiájchawoo, níwata yúderri'inaa nuyá tráawajorru. ");
INSERT INTO aca_vpl VALUES ("T24_12","085_4_12","2TI","4","12","12","Liá'a Tíquico nubánuani Éfeso néerra. ");
INSERT INTO aca_vpl VALUES ("T24_13","085_4_13","2TI","4","13","13","Jáicta jíinujoo jínda nushínaa capa, numáacani Troas tána íibana néeni liá'a Carpo. Lécchoo jínda nushínaa cáashta, ya náa'a cáashta báinacu sánami, jí'ineenai pergamino. ");
INSERT INTO aca_vpl VALUES ("T24_14","085_4_14","2TI","4","14","14","Alejandro jiárru shínanaa, máashii wérri médacoo nuájcha. Liyá wawácali lipáida liyájoo, léjta linácu liá'a limédanica. ");
INSERT INTO aca_vpl VALUES ("T24_15","085_4_15","2TI","4","15","15","Jitúyau jiyá liúcha, níwata máashii médacoo wajúnta linácue liáni wéewidanicoo nácu. ");
INSERT INTO aca_vpl VALUES ("T24_16","085_4_16","2TI","4","16","16","Quéechanacu nutáania nubícaubaliu nanáneewa náa'a wánacaleenaica quiní yúda nuyá, quinínama namáaca bácai nuyá. Nunénda Dios jócubeecha licóbra liúcha liá'a máashii namédanica. ");
INSERT INTO aca_vpl VALUES ("T24_17","085_4_17","2TI","4","17","17","Ne liá'a nuwácalica liyúdawa nuyái, ne liá nudánani quinínama nutéeque'e liéni nuíiwa Dios chuáni, liá'a chuánshi sáicaica wásedeerrica, quéewique'e néemicani quinínama náa'a jócani judíobini. Cháwa wawácali túyerri nuyá liúcha liá'a carrúnatai újni cháawi quíirrai núma rícucha. ");
INSERT INTO aca_vpl VALUES ("T24_18","085_4_18","2TI","4","18","18","Liá'a nuwácali litúyaminaa nuyá quinínama liúcha liá'a máashiica, liwáaliaminaa nuyá lishínaa liwánacaalactaca éerri ítala. Wacábactala balíbalibee ne liyá yáawaiyii, chái'inaa. ");
INSERT INTO aca_vpl VALUES ("T24_19","085_4_19","2TI","4","19","19","Nuédacaniu Prisca nácu ya Aquila nácu, ya náa'a tána éenajinaica Onesíforo. ");
INSERT INTO aca_vpl VALUES ("T24_20","085_4_20","2TI","4","20","20","Erasto liá'a máacau Corinto néeni ya Trófimo numáaca bálinerriu á'a Mileto néeni. ");
INSERT INTO aca_vpl VALUES ("T24_21","085_4_21","2TI","4","21","21","Jimédawa jidánijoo jíinu uniábi béechajoo. Nabánua jirrú nédacani'eewoo jinácu Éubulo, Pudente, Lino, Claudia ya quinínama éenajinai éebidenaica Cristo nácu. ");
INSERT INTO aca_vpl VALUES ("T24_22","085_4_22","2TI","4","22","22","Liá'a Wawácali Jesucristoca liyá jiájcha. Dios cámusheda iyá liwíteeyu quinínama irrú.");
INSERT INTO aca_vpl VALUES ("JD1_1","095_1_1","JUD","1","1","1","Nuyá, Judas, cashírruedacai Jesucristo shínaa ya Santiago éenajirri, nutána liáni cáashtaca nalí náa'a chóniwenai caníinaani Dios wasálijinaa cábaca ya limáida nayá, náa'a Jesucristo túyanica. ");
INSERT INTO aca_vpl VALUES ("JD1_2","095_1_2","JUD","1","2","2","Irríshibia iyá máanui bájiala carrúni jináata, sáictacta iwówa ya caníinaabee. ");
INSERT INTO aca_vpl VALUES ("JD1_3","095_1_3","JUD","1","3","3","Nuéenajinai caníinaani nucábaca, nuwówai nutána máanui wérri linácu liá'a wásedeerri iyá ya chacábacanaa nuyá lécchoo, ne chóque'e nucába rúnaacala irrú, quéewique'e íinua yáacacoo linácu liá'a éebidauca quéechamite léejueda nalí náa'a Dios shínaaca. ");
INSERT INTO aca_vpl VALUES ("JD1_4","095_1_4","JUD","1","4","4","Níwata linácu nachálujueda nawárruacoo íibirra áabi chóniwenai, nalí liá'a chuánshi Dios shínaa líyadanica quéechamite linácula liá'a náucaquictalacoo. Náa'a washiálicuenai máashiicanica, náa'a pénsenaica caníinaaca Dios cába wayá bájiala, jócuminaa carrúni jináata licába wayájoo quinínama liá'a máashii wamédanica, ya namá Jesucristocala jócai wánacaala wayá jiní wawácalicalani. ");
INSERT INTO aca_vpl VALUES ("JD1_5","095_1_5","JUD","1","5","5","Báawita iyá ái yáa léenaa, nuwówai édacanicoo liá'a Wawácalica, liáwinaami lijéda náa'a chóniwenai Israel shínaaca Egipto lícucha, limárda nayái náa'a jócanimi éebida. ");
INSERT INTO aca_vpl VALUES ("JD1_6","095_1_6","JUD","1","6","6","Ya nalí náa'a ángelbini jócani máacau sáica, jiníwata néechate chúnsai náarru, Dios wáaliani cuíta manúmai catáwacai ya jócani amáarra, liyáali éerri máanui Dios mácta'inaa tánashia yáau áacairrai ya tánashia yáau infierno rículai. ");
INSERT INTO aca_vpl VALUES ("JD1_7","095_1_7","JUD","1","7","7","Chacábacanaa léjta náa'a ángelbinica, lécchoo náa'a chacáalee jí'ineenai Sodoma ya Gomorra ya náa'a chacáalee léema nácu sánaca, naméda'inaa náa'a rúmbabini médanica, ya naínda natée nayá máashiiquictala lijúnta liá'a licábacanaa. Tánda nasúfria carrúni jináatami liá'a chichái jócai amáarra ya namáaca náiiwanau chacábacanaa quinínamarru. ");
INSERT INTO aca_vpl VALUES ("JD1_8","095_1_8","JUD","1","8","8","Báawitate náa léenaa liérra, náarra washiálicuenai lécchoo, nayá léjta dajuíshi rícula, nasáculeda nanáanaiu, nacháani liá'a wánacaleerri wawácali chuánica ya nacáitadeda nanáawa náa'a wánacaleenai mawí. ");
INSERT INTO aca_vpl VALUES ("JD1_9","095_1_9","JUD","1","9","9","Liyája liá'a ángel Miguel, liá'a wánacaleerri máanui mawí náucha náa'a áabi ángelbinica, quéecha'inaami líinua yáacacoo lijúnta liá'a Wawásimica quéewique'e léda liúcha Moisés máashiicaimi, jócu léenaa liúca chuánshi máashiiyu, léerrimi'e limáni lirrú: “¡Liá'a Wawácali liárra jiyájoo!” ");
INSERT INTO aca_vpl VALUES ("JD1_10","095_1_10","JUD","1","10","10","Ne náarra washiálicuenai natáania máashii linácu liá'a jócai náa léenaa; ya liá'a náani léenaa cábacanaa, léjta náa léenau'u cuéshinaica jiníni wítee, namédani chúnsai'inaa náucacooyu. ");
INSERT INTO aca_vpl VALUES ("JD1_11","095_1_11","JUD","1","11","11","¡Áchunu carrúni jináata nayá! Quéewique'e wínenai léjta chacábacanaa liá'a Caínca. Linácu nagáana warrúwa nanáawawai, léjta liá'a washiálicuerri jí'ineerri Balaam, ya léjta liá'a jí'ineerri Coré, máanalini jócala léemi nalí namáni nácucha. ");
INSERT INTO aca_vpl VALUES ("JD1_12","095_1_12","JUD","1","12","12","Náa'a báinatanica shímashi caníinacta nacábacoo náiibi éenajinai ya ijúnicai sáictacta naméda nawówau. Liyáali éerri náayactaca ya náirra sáictai wérri nawówa, jócu náyada nayáu cawáunta. Cháni léjta pastorbini natúyenaicoo nayá jájiu. Cháni léjta liá'a sáanai jinírru shiátai, litéeni liá'a cáulica. Cháni léjta banácali jócai yáa lítau léerdi rícuu, máanali chámaichu ya lijíchu éerruau. ");
INSERT INTO aca_vpl VALUES ("JD1_13","095_1_13","JUD","1","13","13","Cháni léjta marrádaca carrúnatai wérri manuá shínaaca, náucani léjta licáli náa'a máashii namédanica, wáneerri báinata nayá. Cháni léjta sáalii yúquenaiu nájabaa yúchau, yéenai yúquenai'inau lirrícula liá'a mawí catáawacabee jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("JD1_14","095_1_14","JUD","1","14","14","Lécchoo liá'a washiálicuerri jí'ineerri Enoc, liyá sietechu, Adán yáawinaami, litáania Dios lijí'inaa nácu, limá'ee nanácucha náa'a chóniwenaica: “Nucába wawácali, íinuca íchaba wérri ya íchaba wérri lishínaa ángelbini yáajchau, ");
INSERT INTO aca_vpl VALUES ("JD1_15","095_1_15","JUD","1","15","15","licábaque'e cajíconaani ya jiní jíconaa quinínama washiálicuenai, ya liúcaque'e quinínama náa'a máashiinica, quinínama máashii namédanica nalíwoo, ya liá'a quinínama chuánshica jócai sáicanata namáca, léjta máashiicani cajíconaani namánimi linácucha.” ");
INSERT INTO aca_vpl VALUES ("JD1_16","095_1_16","JUD","1","16","16","Quinínama najútau, quinínama náasacala, bácai namúrru nalíwoo sáicaque'e nayá. Natáania wachósuniyu, ya natáania áabi nácu újni sáica néedaque'e náucha sáicabee nalíwoo. ");
INSERT INTO aca_vpl VALUES ("JD1_17","095_1_17","JUD","1","17","17","Ne iyá, caníinaani nucába nuéenajinaiu, édacaniu linácu náa'a apóstolubini wawácali Jesucristo shínaa ");
INSERT INTO aca_vpl VALUES ("JD1_18","095_1_18","JUD","1","18","18","mánimi nácucha: “Liá'a éerri éenamictala'inaa nayáminaajoo náa'a chóniwenai cásacalacani, nayáminaa áabenaa náajcha náa'a wówenai naméda liá'a máashiica.” ");
INSERT INTO aca_vpl VALUES ("JD1_19","095_1_19","JUD","1","19","19","Nayáwa náarra wówenai nashírredacoo; naméda nawíteu léjta nawówau ya jinínirru Espíritu Dios shínaa. ");
INSERT INTO aca_vpl VALUES ("JD1_20","095_1_20","JUD","1","20","20","Ne iyá, caníinaani nucábaca nuéenajinai, iyá sáica cabálininaa majíconaa linácu liáni éebidani nácu. Isáta Dios yúcha índa litée iyá liá'a Espíritu Santo. ");
INSERT INTO aca_vpl VALUES ("JD1_21","095_1_21","JUD","1","21","21","Iyá caníinaani icába Dios mamáarraca ya inénda liá'a éerrica linácu liá'a Wawácali Jesucristoca, carrúni jináata wayá linácueji, liá walí licáwica jócai amáarra. ");
INSERT INTO aca_vpl VALUES ("JD1_22","095_1_22","JUD","1","22","22","Carrúni jináata icába náa'a jócani éenajta éebidaca. ");
INSERT INTO aca_vpl VALUES ("JD1_23","095_1_23","JUD","1","23","23","Áabibi iwáseda ijéda nayá néenee chichái yúcha, ya carrúni jináata icába náa'a áabica, áawita itúyacoo náucha ya máashii icába lécchu liá'a náabala natéenica casáculaica máashiica nayá. ");
INSERT INTO aca_vpl VALUES ("JD1_24","095_1_24","JUD","1","24","25","Liyá Dios bácai rími, liá'a wásedeerri wayá, wáaleerri danáanshi litúyaque'e iyá jócubeecha iméda ijíconau, ya quéewique'e líyada iyá jiní wérri jíconaa ya sáicta wérri iwówa lináneewa balíbalibeeca. Liyája liá'a balíbalibeeca, máanui wérrica, liá'a cadánanica ya liwánacaalauca, linácu liá'a Wawácali Jesucristoca, quéecha'inami, chóque'e ya mamáarraca. Chácajani.");
ALTER TABLE aca_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
